// 3D model [bob]
//
// - vertices   : 5344
// - textures   : 5647
// - normals    : 5344
// - triangles  : 10688
//
// - memory size: 238kb
//
// - model bounding box: [-1.0,1.0]x[-0.52,0.52]x[-0.79,0.79]
//
// object [bob] (tagged [ | o Mesh | usemtl feathers | g Default]) with 10688 triangles (474 chains)

#pragma once

#include <tgx.h>

#include "bob_texture.h" // texture for object [bob]


// vertex array: 62kb.
const tgx::fVec3 bob_vert_array[5344] PROGMEM = {
{-0.0925233448474846,-0.23242367766410899,-0.07276350946159355},
{-0.08522228454339678,-0.2659596535948452,-0.0891276131115849},
{-0.08720797725402844,-0.23245816085005364,-0.09030672255097989},
{-0.09822848020207144,-0.19940279432342103,-0.07549931922647748},
{-0.09292054804558458,-0.19951701987686268,-0.09352206412040667},
{-0.08074151780975732,-0.23247648004258673,-0.10744109436700994},
{-0.07876810973411844,-0.2659531879974806,-0.10613062554115704},
{-0.08082244553677116,-0.29949024152777753,-0.1067854827942372},
{-0.08734019872013497,-0.2995074831207499,-0.08964195138194062},
{-0.09054379445434936,-0.2659596535948452,-0.07175250555367875},
{-0.09664710284664085,-0.23236656488738816,-0.05487492571298028},
{-0.10230277638138832,-0.19925947358183857,-0.05702225835772749},
{-0.1111805803627954,-0.1671028250888885,-0.06079644305936981},
{-0.10722697533428482,-0.16738946657205345,-0.08028795615462907},
{-0.10198262155188342,-0.16765455606400295,-0.09911588344036591},
{-0.08642143733462211,-0.1996075382399674,-0.11104555713783092},
{-0.07316416097828796,-0.23248725603819445,-0.12410283101568609},
{-0.07121747737175618,-0.26594456720099446,-0.12269009799151606},
{-0.07320209248282707,-0.299474077534366,-0.12349290966429001},
{-0.07900636699700478,-0.33249711607417554,-0.1263722556906686},
{-0.08679611870190199,-0.33251220246802626,-0.1092718282608028},
{-0.09345859350627726,-0.3325305216605594,-0.09172549013269021},
{-0.09272205420649067,-0.2995236471141614,-0.0721385017163467},
{-0.09469664764164638,-0.26594995519879827,-0.054077178758141935},
{-0.09958517804908139,-0.23230514171242425,-0.03672717927000173},
{-0.10517382489114895,-0.19911830803937766,-0.038204137227993665},
{-0.11391391164868958,-0.16683881319649974,-0.040807402246902845},
{-0.12528010853582774,-0.13593325779360413,-0.044736761285296106},
{-0.12279742690776876,-0.13636860801615538,-0.06647506946476169},
{-0.11908660506029975,-0.13687292461059594,-0.0874571182724786},
{-0.11401714568661139,-0.13738586200152267,-0.10743085717118261},
{-0.09548642035973504,-0.16789270556693323,-0.11727300499952316},
{-0.07877371325183445,-0.19967865981097827,-0.1280252934168904},
{-0.06451653226306142,-0.23249372163555906,-0.1402291084426154},
{-0.06260648704159585,-0.2659381016036298,-0.13873340025226605},
{-0.06451297618451088,-0.2994622239391975,-0.13968707586354787},
{-0.07012166637840875,-0.33248526247900706,-0.1429468145348784},
{-0.08851833831992527,-0.36443608945584993,-0.13119235852599467},
{-0.09658104599356562,-0.3644468654514576,-0.11345722495483511},
{-0.10347380382407753,-0.3644597966461869,-0.09525408989443297},
{-0.1091641760646818,-0.3644727278409161,-0.07666269571228523},
{-0.09896114014343924,-0.33254884085309244,-0.07381169055435494},
{-0.09693428312958617,-0.2995355007093299,-0.05435175112622624},
{-0.09767286986853821,-0.2659348688049475,-0.03617663365440412},
{-0.10134338949243442,-0.23225449453306804,-0.01840680137738776},
{-0.10687212179892312,-0.19900839288417907,-0.01915885811084943},
{-0.1154974442032417,-0.16664484527556106,-0.020486676289630745},
{-0.12666590157097848,-0.13562398671966303,-0.02249445979125819},
{-0.07002015649978419,-0.1997357725876991,-0.14441666033576925},
{-0.08777738086193954,-0.1681006822821619,-0.13475059227565858},
{-0.07889451216259682,-0.1682720206123244,-0.15154174863158326},
{-0.060203224501165664,-0.19978210936881222,-0.16017439871291508},
{-0.05483882612769444,-0.23250342003160598,-0.1557551629141956},
{-0.05297145384883538,-0.265937024004069,-0.15419048835195695},
{-0.05478860998816254,-0.29945575834183286,-0.15529071750350357},
{-0.06017456035284917,-0.3324787968816424,-0.158916840025496},
{-0.07931833206984781,-0.36442854625892457,-0.14837683872160054},
{-0.10162625937713665,-0.39471555951393794,-0.13781313022736813},
{-0.11006882089594858,-0.3947209475117418,-0.11920837381066683},
{-0.117282595635614,-0.3947263355095457,-0.10010328791789984},
{-0.12323417800974902,-0.3947317235073495,-0.08058170979489508},
{-0.12789005467201367,-0.39473818910471414,-0.0607274766874805},
{-0.1136195114486871,-0.3644867366352062,-0.057765047734966546},
{-0.10327143062656484,-0.3325671600456256,-0.05561038741320609},
{-0.09996201461548282,-0.29954412150581605,-0.03635249790272185},
{-0.09946481017814335,-0.2659219376102182,-0.018125871171894913},
{-0.10192744845437199,-0.23223186494229184,2.5089858333373744e-10},
{-0.10742805541232459,-0.19896205610306594,3.7634733620082576e-10},
{-0.11600176079768228,-0.16656510290806406,2.5089858333373744e-10},
{-0.1270840102005574,-0.1355011403697352,1.2544875286708835e-10},
{-0.10761512669607433,-0.13788048019991628,-0.12645092045860482},
{-0.09990641047814706,-0.13833091681631832,-0.14457291227208097},
{-0.09091685942228807,-0.1387102318617095,-0.16185114362947386},
{-0.06887693112576285,-0.16840241015917765,-0.1676389308703718},
{-0.04935729268196747,-0.19980473895958842,-0.1752435509707286},
{-0.04416951287650652,-0.23250665283028832,-0.17061849365590198},
{-0.0423554817759056,-0.2659359464045083,-0.16899455111782097},
{-0.0440757617147195,-0.29945360314271136,-0.17023810101095005},
{-0.04921429522025324,-0.3324755640829601,-0.17421121059151057},
{-0.06901335523015638,-0.3644231582611207,-0.16492876797503417},
{-0.09198842442551818,-0.39471232671525563,-0.1558349052816926},
{-0.1182180598143188,-0.4227579328838666,-0.1460977156505711},
{-0.12715082137332517,-0.42275901048342734,-0.12639057488320168},
{-0.1347813038631405,-0.42276116568254885,-0.10614872921377798},
{-0.14107448529803976,-0.42276224328210965,-0.0854593564467663},
{-0.14599372729295673,-0.42276439848123115,-0.06440963438663302},
{-0.14952609865316213,-0.42276547608079196,-0.04308986587657067},
{-0.13123492370864506,-0.39474249950295726,-0.040623671521791485},
{-0.11682321494285755,-0.3644985902303746,-0.03863765553129161},
{-0.10637222336268173,-0.3325822464394763,-0.03719334883999101},
{-0.10179048555019805,-0.29954950950361997,-0.018211648096932237},
{-0.10006470985362423,-0.26591547201285365,1.2544875286708835e-10},
{-0.03080167480523732,-0.2659294808071436,-0.18307769977752955},
{-0.03254684729390501,-0.2324926440359983,-0.18475444469408833},
{-0.03751684422813426,-0.19978857496617683,-0.18956700433248902},
{-0.020009321236200632,-0.23245385045181055,-0.1980994376546692},
{-0.018353460199129593,-0.2659122392141713,-0.19637527835743654},
{-0.019871129868527432,-0.2994449823462252,-0.1978882281407582},
{-0.03242098366520702,-0.2994503703440291,-0.18445918241443723},
{-0.024716373101606293,-0.199717453395166,-0.20308872362103625},
{-0.0455721164648053,-0.16846060053545922,-0.1975929658611071},
{-0.03235234057318595,-0.16834745258157835,-0.21136899864599615},
{-0.010990233176380926,-0.19957628785270506,-0.21575159605964944},
{-0.006595189487800733,-0.23237841848255664,-0.21058989416355914},
{-0.005053834180057157,-0.26587667842866586,-0.20882047568477413},
{-0.006472849609666468,-0.29943420635061757,-0.21045627181802362},
{-0.024451973273375664,-0.3324755640829601,-0.20250681985822022},
{-0.03729033280046032,-0.3324755640829601,-0.18876419265971506},
{-0.05775825885773366,-0.1684724541306277,-0.18300334540783642},
{-0.06921174130929421,-0.13914989248250384,-0.19402934411363934},
{-0.056573007100842274,-0.13915851327899,-0.2089088388487573},
{-0.04279471135687562,-0.13899256294663134,-0.22296828031812896},
{-0.0181324768572024,-0.16811253587733038,-0.224291572578755},
{0.0035765529421970532,-0.19940171672386026,-0.22751359526545858},
{0.00762207721324136,-0.2322846673207696,-0.22218163263876653},
{0.009031146398904758,-0.26583357444623507,-0.2203680325779899},
{0.0077114102168292275,-0.2994201975563275,-0.2221169766651203},
{-0.010748570698882551,-0.3324744864833993,-0.21536904821557595},
{-0.03198563344265578,-0.3644231582611207,-0.21009850876384784},
{-0.04529538889759945,-0.3644220806615599,-0.1958591081678275},
{-0.057655132579767926,-0.3644220806615599,-0.18077917991440626},
{-0.08118915266730134,-0.394710171516134,-0.17318749100877867},
{-0.10801793341189031,-0.422755777684745,-0.16518200387181523},
{-0.13792789458059015,-0.44814402333649606,-0.15587585406500187},
{-0.14744848669999677,-0.44814510093605686,-0.13485942983129642},
{-0.15558113058513112,-0.44814510093605686,-0.11327080023082182},
{-0.1622848774526839,-0.44814510093605686,-0.09119983706694641},
{-0.16752524411671046,-0.44814510093605686,-0.0687401837415011},
{-0.17128606658379922,-0.44814402333649606,-0.04598882421495525},
{-0.1735533360596602,-0.44814402333649606,-0.023043065727646406},
{-0.15165651298480526,-0.42276655368035276,-0.0215899227199475},
{-0.13325326768596807,-0.3947468099012003,-0.020353377223963444},
{-0.11875869151395732,-0.3645072110268608,-0.019357136430031188},
{-0.10824638451877364,-0.3325930224350841,-0.01863266624532524},
{-0.10240493281974934,-0.2995516647027414,2.5089858333373744e-10},
{-0.10179048555019805,-0.29954950950361997,0.018211648096932237},
{-0.09946481017814335,-0.2659219376102182,0.018125871171894913},
{-0.10134338949243442,-0.23225449453306804,0.01840680137738776},
{-0.10687212179892312,-0.19900839288417907,0.01915885811084943},
{-0.1154974442032417,-0.16664484527556106,0.020486676289630745},
{-0.12666590157097848,-0.13562398671966303,0.02249445979125819},
{-0.11391391164868958,-0.16683881319649974,0.040807402246902845},
{-0.12528010853582774,-0.13593325779360413,0.044736761285296106},
{-0.1111805803627954,-0.1671028250888885,0.06079644305936981},
{-0.12279742690776876,-0.13636860801615538,0.06647506946476169},
{-0.10722697533428482,-0.16738946657205345,0.08028795615462907},
{-0.11908660506029975,-0.13687292461059594,0.0874571182724786},
{-0.10198262155188342,-0.16765455606400295,0.09911588344036591},
{-0.11401714568661139,-0.13738586200152267,0.10743085717118261},
{-0.09548642035973504,-0.16789270556693323,0.11727300499952316},
{-0.10761512669607433,-0.13788048019991628,0.12645092045860482},
{-0.08777738086193954,-0.1681006822821619,0.13475059227565858},
{-0.09990641047814706,-0.13833091681631832,0.14457291227208097},
{-0.07889451216259682,-0.1682720206123244,0.15154174863158326},
{-0.09091685942228807,-0.1387102318617095,0.16185114362947386},
{-0.06887693112576285,-0.16840241015917765,0.1676389308703718},
{-0.080672551437868,-0.13899256294663134,0.17833949450882206},
{-0.05775825885773366,-0.1684724541306277,0.18300334540783642},
{-0.06921174130929421,-0.13914989248250384,0.19402934411363934},
{-0.0455721164648053,-0.16846060053545922,0.1975929658611071},
{-0.056573007100842274,-0.13915851327899,0.2089088388487573},
{-0.03235234057318595,-0.16834745258157835,0.21136899864599615},
{-0.04279471135687562,-0.13899256294663134,0.22296828031812896},
{-0.0181324768572024,-0.16811253587733038,0.224291572578755},
{-0.027915432141669826,-0.13862402389684786,0.23619797012570737},
{-0.0030131838918262144,-0.1678129631994362,0.23631866127651366},
{-0.012054869214435276,-0.13814772489098734,0.24854941629125793},
{0.012905116819874416,-0.16750908012329896,0.24740500555771971},
{0.004666868177784563,-0.13765310669259373,0.25997304923498515},
{0.029521809806910354,-0.16725799942563943,0.2575085790395032},
{0.022130015619805668,-0.13723284286389326,0.27042037697665433},
{0.0467364627902178,-0.16712006668186083,0.2665862777394332},
{0.04021450696856699,-0.13697852936755142,0.2798450627351524},
{0.06448269563685328,-0.16706403150470076,0.2745842216794713},
{0.05885126809222316,-0.13685029501981977,0.28817706253902936},
{0.08269391269396122,-0.16706187630557923,0.2814474532820181},
{0.077971548138797,-0.1368082686369497,0.29534848761595645},
{0.10130351830868596,-0.1670845058963554,0.28712317016859584},
{0.097506057456531,-0.13681257903519278,0.3012925267931661},
{0.11738561415362371,-0.13682119983167895,0.3059380584996474},
{0.1202455633879084,-0.1671028250888885,0.2915564147616053},
{0.13752487234486205,-0.13683305342684743,0.3092753843393533},
{0.1394365339656688,-0.1671179114827393,0.2947374886649996},
{0.15783762406538446,-0.13684598462157668,0.31129049551799404},
{0.1587945324753486,-0.16712868747834697,0.2966566934827317},
{0.17823766135032929,-0.13685676061718438,0.31197153844040093},
{0.1782365837507685,-0.1671362306752724,0.297303253219194},
{0.1594906617916063,-0.19908598005255454,0.286019708218367},
{0.17823550615120773,-0.19909029045079762,0.2866404055653707},
{0.15991523601854982,-0.23215966577172023,0.2795239380660428},
{0.17823550615120773,-0.2321618209708418,0.2801284714196351},
{0.1600585567601323,-0.2657904704638043,0.2773116261677812},
{0.17823442855164695,-0.265791548063365,0.27790969392400877},
{0.1599130808194283,-0.2994201975563275,0.27952717086472517},
{0.17823442855164695,-0.2994201975563275,0.2801295490191958},
{0.15948742899292398,-0.33249065047681087,0.28602725141529234},
{0.17823442855164695,-0.33249065047681087,0.28664256076449224},
{0.15879022207710553,-0.3644425550532145,0.29666854707790025},
{0.17823442855164695,-0.3644425550532145,0.29730756361743704},
{0.15783115846801984,-0.39471663711349875,0.3113088147105271},
{0.17823442855164695,-0.39471663711349875,0.3119801592368871},
{0.15661885896215313,-0.4227568552843058,0.3298047335715906},
{0.17823442855164695,-0.4227568552843058,0.3305159492816991},
{0.15518026354852463,-0.44814294573693525,0.3517532814253625},
{0.17823442855164695,-0.44814294573693525,0.35251191151614486},
{0.1535412346165928,-0.4704578774413692,0.3767514360361147},
{0.17823442855164695,-0.4704578774413692,0.37756394610493554},
{0.15172978975493773,-0.48928569696714996,0.40439617516811904},
{0.17823442855164695,-0.48928569696714996,0.40526795321278225},
{0.17823442855164695,-0.5042072180851379,0.43522091060395685},
{0.14977071375345713,-0.5042072180851379,0.43428447658564734},
{0.17823442855164695,-0.5150694216577039,0.4668603113077371},
{0.1477017225967779,-0.5150694216577039,0.4658559885170991},
{0.17823442855164695,-0.5217171333480966,0.49962688115208326},
{0.14555837707040553,-0.5217182109476572,0.4985514367904344},
{0.17823442855164695,-0.5239984116182475,0.5329591907658339},
{0.14337839315896697,-0.5239984116182475,0.5318126248331742},
{0.17823442855164695,-0.5217580821314057,0.5662958107778275},
{0.14119733164796763,-0.5217591597309665,0.565078123274157},
{0.17823442855164695,-0.51514808642564,0.5990763894164637},
{0.13905290852203453,-0.5151491640252007,0.5977886579413431},
{0.17823442855164695,-0.5043225212381403,0.6307416525097024},
{0.13698283976579453,-0.5043225212381403,0.6293838770631318},
{0.13502268616475316,-0.4894322505074147,0.659305584067044},
{0.17823442855164695,-0.4894322505074147,0.6607301706863824},
{0.13321231890265883,-0.47062921577153166,0.6869923495819183},
{0.1782365837507685,-0.47063029337109247,0.688481592174903},
{0.1315754451698486,-0.4483293704609487,0.7120368409737836},
{0.17823873894989004,-0.4483315256600701,0.7135864291421715},
{0.1301400825549024,-0.42294543520744066,0.7340295704095471},
{0.17824304934813312,-0.4229497456056837,0.7356362713546558},
{0.1289331710468395,-0.39489444104102583,0.7525642828547983},
{0.17824735974637618,-0.3948987514392689,0.7542194757801416},
{0.12797949543555767,-0.3645891085934793,0.7672304128768836},
{0.17825382534374082,-0.36459341899172243,0.7689276321850971},
{0.1272898317166646,-0.3325941000346448,0.7778878725329033},
{0.17826029094110543,-0.33259841043288785,0.7796184974275004},
{0.12686956788796416,-0.299474077534366,0.7843933410812742},
{0.17826460133934854,-0.2994762327334875,0.7861465955666477},
{0.12672840234550323,-0.2657904704638043,0.7866067305790966},
{0.17826783413803085,-0.2657904704638043,0.788369683460517},
{0.17826675653847007,-0.23210578579368174,0.7861433627679653},
{0.12687387828620725,-0.23210794099280327,0.784384720284788},
{0.17826352373978777,-0.19898468569384212,0.7796131094296966},
{0.12729737491359003,-0.1989889960920852,0.7778717085394916},
{0.1782581357419839,-0.16698859953544684,0.7689200889881718},
{0.1279902714311654,-0.16699506513281145,0.7672077832861076},
{0.17825274774418004,-0.13668218948833957,0.7542108549836556},
{0.128945024642008,-0.13668649988658266,0.7525373428657791},
{0.17824843734593696,-0.1086268849236817,0.7356276505581696},
{0.13015301374963165,-0.1086268849236817,0.7340037080200885},
{0.17824520454725468,-0.08323863927193065,0.7135788859452461},
{0.13158837636457785,-0.083232173674566,0.7120109785843252},
{0.17824197174857237,-0.060931789564202574,0.6884729713784169},
{0.1332252500973881,-0.06091896612942941,0.6869675647920206},
{0.1782408941490116,-0.04212272027077923,0.6607193946907748},
{0.13503669495904316,-0.042102892438861055,0.6592775664784639},
{0.17824197174857237,-0.02722641498251326,0.6307265661158517},
{0.13699900375920612,-0.027200552593054764,0.6293493938771871},
{0.13907230531412837,-0.016364642449771743,0.5977444763593515},
{0.17824304934813312,-0.016395246277297618,0.5990548374252482},
{0.14121888363918308,-0.009748288906597449,0.5650242432961184},
{0.17824520454725468,-0.009782017772849561,0.5662677931892475},
{0.14340210034930395,-0.007503972301380898,0.5317512016582102},
{0.17824628214681543,-0.007539209807018087,0.5329268627790107},
{0.14558316186030326,-0.009784711771751482,0.4984878584163489},
{0.17824735974637618,-0.009819625997520447,0.4995923979661386},
{0.14772542978711484,-0.01643608730065082,0.4657934877425744},
{0.17824735974637618,-0.016469277367122552,0.46682582812179246},
{0.14979226574467253,-0.027303894390932653,0.43422628620936576},
{0.17824628214681543,-0.027334174938590295,0.435187505017573},
{0.1517491865470316,-0.042233820785494654,0.404344450389202},
{0.17824520454725468,-0.04226054525460177,0.40523885802464144},
{0.17824304934813312,-0.061094399337922836,0.37754023891459865},
{0.15355847620956514,-0.061071661987190586,0.3767083320536838},
{0.17824197174857237,-0.08341752079901853,0.35249359232361177},
{0.15519319474325385,-0.08339920160648542,0.3517187982394178},
{0.1782398165494508,-0.10881115444857345,0.33050301808696986},
{0.15662855735820005,-0.10879606805472267,0.3297788711821321},
{-0.080672551437868,-0.13899256294663134,-0.17833949450882206},
{0.023835532444637007,-0.26579262566292583,-0.2309737674550924},
{0.02256902968086353,-0.2321941489576649,-0.23283370429698214},
{0.018898941096791643,-0.19922822319457623,-0.23833485005471514},
{0.03817213252103882,-0.23212518258577558,-0.24250300515577508},
{0.03929359038393259,-0.26576137527566346,-0.24059242113452914},
{0.03818764995471391,-0.2993975679655513,-0.24253102274435512},
{0.02261903030048328,-0.29940726636159826,-0.2328240059009352},
{0.03489202721800974,-0.19909029045079762,-0.24817225644498828},
{0.012905116819874416,-0.16750908012329896,-0.24740500555771971},
{0.029521809806910354,-0.16725799942563943,-0.2575085790395032},
{0.05147078870050655,-0.19902240167846907,-0.25698486565296874},
{0.05435810896363483,-0.23209500979807401,-0.25114643123271463},
{0.0553391556037602,-0.26575059928005573,-0.24917873443474783},
{0.054354660645040354,-0.2993964903659906,-0.2511895352151455},
{0.03492877336303201,-0.3324744864833993,-0.24819165323708214},
{0.019004114813922834,-0.3324734088838385,-0.2382594180854612},
{0.0037575896684064816,-0.3324744864833993,-0.22730238575154757},
{-0.0030131838918262144,-0.1678129631994362,-0.23631866127651366},
{-0.012054869214435276,-0.13814772489098734,-0.24854941629125793},
{0.004666868177784563,-0.13765310669259373,-0.25997304923498515},
{0.022130015619805668,-0.13723284286389326,-0.27042037697665433},
{0.0467364627902178,-0.16712006668186083,-0.2665862777394332},
{0.06856916869120688,-0.19900516008549674,-0.26472741849710424},
{0.07105982455601555,-0.23209500979807401,-0.2587273441427345},
{0.0719034772521427,-0.2657527544791773,-0.2567014569684862},
{0.07104904856040783,-0.29940080076423364,-0.2587704481251653},
{0.051469280061121475,-0.3324777192820816,-0.25704844402705423},
{0.02959142273853612,-0.3644328566571677,-0.2574460782649785},
{0.013075485310432221,-0.3644296238584854,-0.24715284726049946},
{-0.0027355942449717543,-0.36442746865936376,-0.23579602548954},
{-0.01777754788987145,-0.3644253134602423,-0.22342733773101714},
{-0.027915432141669826,-0.13862402389684786,-0.23619797012570737},
{0.08821036036545715,-0.23211009619192483,-0.2652091055007686},
{0.08891769671714686,-0.265763530474785,-0.2631271831493602},
{0.08819969212980552,-0.29940726636159826,-0.26524251108715247},
{0.06855171157832239,-0.332480952080764,-0.2648006952672366},
{0.04674745430573765,-0.3644350118562891,-0.26662722652274246},
{0.022249952450919416,-0.39471232671525563,-0.27016929627899483},
{0.0049179488754440715,-0.39471124911569483,-0.25937605907831834},
{-0.011673571385852273,-0.394710171516134,-0.24746966153136596},
{-0.02745626696882555,-0.394710171516134,-0.23450398361617628},
{-0.042361731853358064,-0.3947090939165734,-0.22053182771122704},
{0.10406109558469748,-0.19904610886880603,-0.2768320943632383},
{0.08612132585694762,-0.19901916887978677,-0.27135788859452464},
{0.06448269563685328,-0.16706403150470076,-0.2745842216794713},
{0.08269391269396122,-0.16706187630557923,-0.2814474532820181},
{0.10130351830868596,-0.1670845058963554,-0.28712317016859584},
{0.1202455633879084,-0.1671028250888885,-0.2915564147616053},
{0.12232317534107374,-0.1990655056608999,-0.2811069318208146},
{0.10574322849906011,-0.23213164818314022,-0.2705550769217507},
{0.10631327866670764,-0.2657753840699535,-0.26842466259010755},
{0.1057356853021347,-0.2994137319589629,-0.270576628912966},
{0.08610257562459021,-0.33248526247900706,-0.2714193117694885},
{0.06446674716335389,-0.36443824465497143,-0.2746628864474075},
{0.040254054872447265,-0.39471340431481644,-0.279795493155357},
{0.012978716869875036,-0.4227547000851843,-0.28623091773227793},
{-0.005383902925521137,-0.4227547000851843,-0.27480189679074685},
{-0.022961534544878492,-0.4227547000851843,-0.26219505952929373},
{-0.03968120294594165,-0.4227547000851843,-0.24846751872463937},
{-0.055470083950393746,-0.4227547000851843,-0.23367638715350458},
{-0.07025518096398821,-0.4227547000851843,-0.21787769999304948},
{-0.05632181864322669,-0.3947090939165734,-0.2056081513941175},
{-0.0692822163205686,-0.3947090939165734,-0.18980299863629777},
{-0.09658611071150124,-0.422755777684745,-0.18355615398251163},
{-0.12705383741285584,-0.44814402333649606,-0.1762252441705905},
{-0.16038830222572797,-0.47045895504093,-0.16697836233961952},
{-0.17058347167017693,-0.47045895504093,-0.14447161791336854},
{-0.17929047612120189,-0.47045895504093,-0.12134848653835689},
{-0.18646836679549364,-0.4704578774413692,-0.09770746081443897},
{-0.19207619490974293,-0.4704578774413692,-0.07364746438129352},
{-0.19610102926922043,-0.4704578774413692,-0.04927302439631526},
{-0.1985277834800754,-0.4704567998418084,-0.02468899129676715},
{-0.17431412134956412,-0.44814402333649606,7.968051328222279e-17},
{-0.15237203909315686,-0.42276655368035276,7.570815802135478e-17},
{-0.13393107780969266,-0.394747887500761,6.272459195345632e-11},
{-0.11940945388870657,-0.3645104438255431,2.5089858333373744e-10},
{-0.10887688802178042,-0.3325973328333272,3.7634733620082576e-10},
{-0.10824638451877364,-0.3325930224350841,0.01863266624532524},
{-0.10637222336268173,-0.3325822464394763,0.03719334883999101},
{-0.09996201461548282,-0.29954412150581605,0.03635249790272185},
{-0.09767286986853821,-0.2659348688049475,0.03617663365440412},
{-0.09958517804908139,-0.23230514171242425,0.03672717927000173},
{-0.10517382489114895,-0.19911830803937766,0.038204137227993665},
{-0.10230277638138832,-0.19925947358183857,0.05702225835772749},
{-0.09822848020207144,-0.19940279432342103,0.07549931922647748},
{-0.09292054804558458,-0.19951701987686268,0.09352206412040667},
{-0.08642143733462211,-0.1996075382399674,0.11104555713783092},
{-0.07877371325183445,-0.19967865981097827,0.1280252934168904},
{-0.07002015649978419,-0.1997357725876991,0.14441666033576925},
{-0.060203224501165664,-0.19978210936881222,0.16017439871291508},
{-0.04935729268196747,-0.19980473895958842,0.1752435509707286},
{-0.03751684422813426,-0.19978857496617683,0.18956700433248902},
{-0.024716373101606293,-0.199717453395166,0.20308872362103625},
{-0.010990233176380926,-0.19957628785270506,0.21575159605964944},
{0.0035765529421970532,-0.19940171672386026,0.22751359526545858},
{0.018898941096791643,-0.19922822319457623,0.23833485005471514},
{0.03489202721800974,-0.19909029045079762,0.24817225644498828},
{0.05147078870050655,-0.19902240167846907,0.25698486565296874},
{0.06856916869120688,-0.19900516008549674,0.26472741849710424},
{0.08612132585694762,-0.19901916887978677,0.27135788859452464},
{0.10406109558469748,-0.19904610886880603,0.2768320943632383},
{0.12232317534107374,-0.1990655056608999,0.2811069318208146},
{0.14082555979950187,-0.19907843685562915,0.28417270257120647},
{0.14167363065382815,-0.2321542777739164,0.27772111400087396},
{0.1419613497365539,-0.2657883152646827,0.27552496609602384},
{0.14167147545470662,-0.2994191199567667,0.27772757959823857},
{0.140820171801698,-0.33249065047681087,0.28418671136549645},
{0.13942899076874338,-0.3644425550532145,0.2947601182557758},
{0.13751409634925435,-0.39471771471305955,0.30930555712705493},
{0.13509488533532477,-0.4227568552843058,0.32768294003643367},
{0.1322230825058716,-0.44814294573693525,0.3494903223477446},
{0.12895364543849416,-0.4704578774413692,0.37432683702438124},
{0.12533722131254862,-0.48928569696714996,0.4017937722288585},
{0.12142769010607353,-0.5042072180851379,0.4314891833250089},
{0.1172983285892013,-0.5150694216577039,0.46285810653903575},
{0.1130213359325035,-0.5217182109476572,0.4953434228980208},
{0.10866998890611256,-0.5239994892178083,0.5283901686281672},
{0.1043186418797216,-0.5217591597309665,0.5614423023561176},
{0.10003949402390226,-0.5151491640252007,0.5939427051089534},
{0.09590797730790848,-0.5043235988377011,0.6253331803141957},
{0.0919984461014334,-0.489431172907854,0.6550566089989261},
{0.08838406941465335,-0.4706270605724101,0.6825580273893481},
{0.08511732634617782,-0.44832506006270556,0.7074311804510508},
{0.0822499416749238,-0.42294004720963674,0.7292741235478672},
{0.07983374793976437,-0.3948890530432219,0.7476827568445084},
{0.07792068543952864,-0.36458479819523626,0.7622529805056852},
{0.07653036648622266,-0.3325908672359625,0.7728414737898154},
{0.07568240339185241,-0.2994729999348052,0.7793059935548771},
{0.07539630070846785,-0.2657937032624865,0.7815010638601664},
{0.0756917785080311,-0.23211440659016788,0.7792844415636616},
{0.0765484701588436,-0.1989997720876929,0.7728016026060668},
{0.07794644006903106,-0.16700691872797993,0.7621980229280859},
{0.07986521384693887,-0.13670050868087266,0.7476181008708621},
{0.08228485590069277,-0.1086376609192894,0.7292073123750994},
{0.08515396473124401,-0.08323863927193065,0.7073676020769655},
{0.08842156987936815,-0.0609199359690341,0.6824966042143842},
{0.09203616208606036,-0.04209782772092542,0.654996263423523},
{0.09594677089209622,-0.02718988435740314,0.625266369141428},
{0.10007936520765078,-0.016349448295964877,0.5938672731396994},
{0.1043585130634701,-0.00972986195410827,0.5613582495903775},
{0.10870986008986105,-0.007484359989374873,0.5283007278646233},
{0.11305905191713046,-0.009766177059306236,0.4952539821344769},
{0.11733281177514596,-0.01642013882715142,0.4627729761737349},
{0.12145786289377511,-0.02729074767629125,0.43141267375619413},
{0.12536308370200713,-0.04222272151001871,0.4017269610560907},
{0.12897519742970956,-0.06106067047167073,0.3742697242476604},
{0.1322414016984047,-0.08338734801131696,0.34944183036751},
{0.1351088941296148,-0.10878421445955419,0.3276441464522459},
{0.097506057456531,-0.13681257903519278,-0.3012925267931661},
{0.077971548138797,-0.1368082686369497,-0.29534848761595645},
{0.05885126809222316,-0.13685029501981977,-0.28817706253902936},
{0.04021450696856699,-0.13697852936755142,-0.2798450627351524},
{0.12359043242453978,-0.23214565697743023,-0.27472862002061443},
{0.12402039464928719,-0.26578292726687885,-0.27256048970434443},
{0.12358504442673592,-0.2994169647576452,-0.2747415512153437},
{0.10404816438996822,-0.33248741767812856,-0.27687304314654765},
{0.08267203742287758,-0.36444039985409304,-0.28152288525127195},
{0.0588492206530577,-0.39471448191437714,-0.2882233993201424},
{0.032053414455028295,-0.4227547000851843,-0.29642608717672686},
{0.022323768020832187,-0.4481418681373746,-0.31615585753487246},
{0.001979119353310982,-0.4481418681373746,-0.3052839555662597},
{-0.017606252663691382,-0.4481418681373746,-0.293097382133507},
{-0.03635411430206297,-0.44814294573693525,-0.27965648281201766},
{-0.05418633959364795,-0.44814294573693525,-0.2650205255776338},
{-0.07102480257029045,-0.44814402333649606,-0.24925093360531947},
{-0.08679148502379068,-0.44814402333649606,-0.23240805247047783},
{-0.10142561033892118,-0.44814402333649606,-0.2145694693414843},
{-0.08397948896996027,-0.4227547000851843,-0.20114581161296718},
{-0.11486683294027886,-0.44814402333649606,-0.19581600418539669},
{-0.14874483897160362,-0.47045895504093,-0.1887706582570797},
{-0.18523451529841153,-0.48928246416846755,-0.17923605734338302},
{-0.19617646123847438,-0.48928246416846755,-0.15507950798959255},
{-0.20552140462947543,-0.48928246416846755,-0.13026131250548903},
{-0.2132240862898624,-0.48928246416846755,-0.10488675236815972},
{-0.2192424798367652,-0.48928246416846755,-0.07906024697504334},
{-0.22356042127677225,-0.48928246416846755,-0.052895052039976784},
{-0.22616282421603282,-0.48928246416846755,-0.026503992236972765},
{-0.1993413711484571,-0.4704567998418084,8.318551361358466e-17},
{-0.1985277834800754,-0.4704567998418084,0.02468899129676715},
{-0.1735533360596602,-0.44814402333649606,0.023043065727646406},
{-0.15165651298480526,-0.42276655368035276,0.0215899227199475},
{-0.13325326768596807,-0.3947468099012003,0.020353377223963444},
{-0.11875869151395732,-0.3645072110268608,0.019357136430031188},
{0.14082555979950187,-0.19907843685562915,-0.28417270257120647},
{0.14167363065382815,-0.2321542777739164,-0.27772111400087396},
{0.1594906617916063,-0.19908598005255454,-0.286019708218367},
{0.15991523601854982,-0.23215966577172023,-0.2795239380660428},
{0.1419613497365539,-0.2657883152646827,-0.27552496609602384},
{0.1600585567601323,-0.2657904704638043,-0.2773116261677812},
{0.17823550615120773,-0.2321618209708418,-0.2801284714196351},
{0.17823442855164695,-0.265791548063365,-0.27790969392400877},
{0.1599130808194283,-0.2994201975563275,-0.27952717086472517},
{0.14167147545470662,-0.2994191199567667,-0.27772757959823857},
{0.17823550615120773,-0.19909029045079762,-0.2866404055653707},
{0.1587945324753486,-0.16712868747834697,-0.2966566934827317},
{0.1394365339656688,-0.1671179114827393,-0.2947374886649996},
{0.13752487234486205,-0.13683305342684743,-0.3092753843393533},
{0.15783762406538446,-0.13684598462157668,-0.31129049551799404},
{0.17823766135032929,-0.13685676061718438,-0.31197153844040093},
{0.1782365837507685,-0.1671362306752724,-0.297303253219194},
{0.11738561415362371,-0.13682119983167895,-0.3059380584996474},
{0.1965557762838656,-0.23216289857040256,-0.27952609326516437},
{0.19641030034316162,-0.265791548063365,-0.2773116261677812},
{0.1965557762838656,-0.2994201975563275,-0.27952609326516437},
{0.17823442855164695,-0.2994201975563275,-0.2801295490191958},
{0.19698142811036992,-0.33249065047681087,-0.2860261738157316},
{0.17823442855164695,-0.33249065047681087,-0.28664256076449224},
{0.1976786350261884,-0.36444147745365385,-0.29666746947833944},
{0.17823442855164695,-0.3644425550532145,-0.29730756361743704},
{0.19863877623483486,-0.39471663711349875,-0.3113077371109663},
{0.17823442855164695,-0.39471663711349875,-0.3119801592368871},
{0.19985107574070154,-0.4227568552843058,-0.3298047335715906},
{0.17823442855164695,-0.4227568552843058,-0.3305159492816991},
{0.20128967115433008,-0.44814294573693525,-0.3517532814253625},
{0.17823442855164695,-0.44814294573693525,-0.35251191151614486},
{0.2029276224867011,-0.4704578774413692,-0.3767514360361147},
{0.17823442855164695,-0.4704578774413692,-0.37756394610493554},
{0.20474014494791695,-0.48928569696714996,-0.40439617516811904},
{0.17823442855164695,-0.48928569696714996,-0.40526795321278225},
{0.2066981433498368,-0.5042072180851379,-0.43428447658564734},
{0.17823442855164695,-0.5042072180851379,-0.43522091060395685},
{0.2087682121060768,-0.5150694216577039,-0.4658559885170991},
{0.17823442855164695,-0.5150694216577039,-0.4668603113077371},
{0.21091048003288837,-0.5217171333480966,-0.4985514367904344},
{0.17823442855164695,-0.5217171333480966,-0.49962688115208326},
{0.21309046394432693,-0.5239984116182475,-0.5318115472336133},
{0.17823442855164695,-0.5239984116182475,-0.5329591907658339},
{0.21527044785576546,-0.5217580821314057,-0.5650759680750354},
{0.17823442855164695,-0.5217580821314057,-0.5662958107778275},
{0.21741487098169862,-0.51514808642564,-0.5977865027422214},
{0.17823442855164695,-0.51514808642564,-0.5990763894164637},
{0.21948601733749937,-0.5043214436385797,-0.6293838770631318},
{0.17823442855164695,-0.5043225212381403,-0.6307416525097024},
{0.22144724853810152,-0.4894322505074147,-0.6593088168657263},
{0.17823442855164695,-0.4894322505074147,-0.6607301706863824},
{0.22326300379799968,-0.47063029337109247,-0.687003125577526},
{0.1782365837507685,-0.47063029337109247,-0.688481592174903},
{0.17823873894989004,-0.4483315256600701,-0.7135864291421715},
{0.22490526552861378,-0.4483326032596309,-0.7120583929649991},
{0.17824304934813312,-0.4229497456056837,-0.7356362713546558},
{0.22634924894004615,-0.4229508232052445,-0.7340651311950526},
{0.17824735974637618,-0.3948987514392689,-0.7542194757801416},
{0.2275680140432775,-0.3949009066383905,-0.7526149300341545},
{0.17825382534374082,-0.36459341899172243,-0.7689276321850971},
{0.22853462084928858,-0.3645966517904047,-0.7672993792487731},
{0.17826029094110543,-0.33259841043288785,-0.7796184974275004},
{0.22923937096203242,-0.33260056563200946,-0.7779740804977648},
{0.17826460133934854,-0.2994762327334875,-0.7861465955666477},
{0.2296704107863406,-0.2994773103330483,-0.7844946354399867},
{0.17826783413803085,-0.2657904704638043,-0.788369683460517},
{0.22981696432660537,-0.265791548063365,-0.7867166457342952},
{0.2296704107863406,-0.23210470819412096,-0.7844946354399867},
{0.17826675653847007,-0.23210578579368174,-0.7861433627679653},
{0.22924044856159317,-0.1989814528951598,-0.7779740804977648},
{0.17826352373978777,-0.19898468569384212,-0.7796131094296966},
{0.2285367760484101,-0.1669853667367645,-0.7672993792487731},
{0.1782581357419839,-0.16698859953544684,-0.7689200889881718},
{0.22757016924239903,-0.13668003428921802,-0.7526149300341545},
{0.17825274774418004,-0.13668218948833957,-0.7542108549836556},
{0.2263514041391677,-0.1086268849236817,-0.7340662087946133},
{0.17824843734593696,-0.1086268849236817,-0.7356276505581696},
{0.22490742072773534,-0.08324294967017372,-0.7120594705645598},
{0.17824520454725468,-0.08323863927193065,-0.7135788859452461},
{0.22326408139756046,-0.060940733640556966,-0.6870042031770868},
{0.17824197174857237,-0.060931789564202574,-0.6884729713784169},
{0.22144940373722308,-0.04213608250533278,-0.6593077392661655},
{0.1782408941490116,-0.0421228280307353,-0.6607193946907748},
{0.2194881725366209,-0.027243441055573428,-0.6293795666648887},
{0.17824197174857237,-0.02722641498251326,-0.6307265661158517},
{0.21741810378038093,-0.016415181869171878,-0.5977789595452961},
{0.17824304934813312,-0.016395246277297618,-0.5990548374252482},
{0.21527583585356933,-0.009803785283977122,-0.5650641144798669},
{0.17824520454725468,-0.009782017772849561,-0.5662677931892475},
{0.21309585194213077,-0.007562054917706419,-0.5317964608397626},
{0.17824628214681543,-0.007539209807018087,-0.5329268627790107},
{0.21091694563025298,-0.009842363348252706,-0.498534195197462},
{0.17824735974637618,-0.009819625997520447,-0.4995923979661386},
{0.20877360010388063,-0.01649093711829403,-0.46583874692412675},
{0.17824735974637618,-0.016469277367122552,-0.46682582812179246},
{0.20670353134764066,-0.027354218290420628,-0.434267234992675},
{0.17824628214681543,-0.027334174938590295,-0.435187505017573},
{0.20474445534616,-0.0422782178873984,-0.4043810887742682},
{0.17824520454725468,-0.04226054525460177,-0.40523885802464144},
{0.17824304934813312,-0.061094399337922836,-0.37754023891459865},
{0.20293193288494418,-0.061109270211861466,-0.3767395824409462},
{0.17824197174857237,-0.08341752079901853,-0.35249359232361177},
{0.2012918263534516,-0.083429374394187,-0.3517446606288763},
{0.1782398165494508,-0.10881115444857345,-0.33050301808696986},
{0.1998532309398231,-0.10881977524505962,-0.32979934557378676},
{0.1986398538343956,-0.136863226214549,-0.31130558191184476},
{0.22137504936752989,-0.10882516324286347,-0.3276807848373121},
{0.2189558383536003,-0.1368664590132313,-0.3093044795274941},
{0.239098329343521,-0.13686753661279208,-0.30598224008163893},
{0.24271475346946653,-0.10882624084242425,-0.3241613446718359},
{0.258981118839296,-0.1368664590132313,-0.3013496395698869},
{0.2637785920838459,-0.10882731844198501,-0.31925395627208747},
{0.2844738916484418,-0.10882731844198501,-0.3129726284323566},
{0.27851584367694215,-0.1368664590132313,-0.2954196091869673},
{0.30471552179795336,-0.10882731844198501,-0.3053518443385882},
{0.2976216838894017,-0.1368664590132313,-0.28822663211882477},
{0.31621889710917755,-0.1368664590132313,-0.2798030363522824},
{0.3244172745675189,-0.10882731844198501,-0.29642716477628767},
{0.3342245081700905,-0.1368664590132313,-0.2701822274737241},
{0.34349294199227687,-0.10882731844198501,-0.286235228130521},
{0.3618573937069264,-0.10882731844198501,-0.274810517587233},
{0.3515587747046435,-0.1368664590132313,-0.2593986886690945},
{0.3794362753417742,-0.10882731844198501,-0.26221122352270526},
{0.36815273034094714,-0.1368664590132313,-0.2475052223168714},
{0.38393525350799074,-0.1368664590132313,-0.23455570839509327},
{0.396156310126688,-0.10882731844198501,-0.24849230351453708},
{0.3988373778338848,-0.1368664590132313,-0.2206029492822379},
{0.41194422129153546,-0.10882731844198501,-0.23370979273988846},
{0.426726732066184,-0.10882731844198501,-0.21792188157504105},
{0.4127901369467402,-0.1368664590132313,-0.20570082495634376},
{0.44044565207435227,-0.10882731844198501,-0.20120184679012723},
{0.4257407284680791,-0.1368664590132313,-0.18991722418973944},
{0.4376331172207415,-0.1368664590132313,-0.17332434615299652},
{0.4530460237384407,-0.10882731844198501,-0.18362188755571862},
{0.44841665602537106,-0.1368664590132313,-0.15599007961844355},
{0.464469656682168,-0.10882731844198501,-0.16525743584106914},
{0.4746615933279346,-0.10882731844198501,-0.1461817684163112},
{0.4580374649039293,-0.1368664590132313,-0.13798339095796985},
{0.4835862728902352,-0.10882731844198501,-0.1264810932463064},
{0.4664610606704717,-0.1368664590132313,-0.11938725533775472},
{0.47365403773861425,-0.1368664590132313,-0.10028109184542695},
{0.49120705698400363,-0.10882731844198501,-0.10623924757688269},
{0.47958406812153387,-0.1368664590132313,-0.08074625924782473},
{0.49748838482373436,-0.10882731844198501,-0.08554384025233072},
{0.5023957732234828,-0.10882731844198501,-0.06448010939790741},
{0.4842166686332859,-0.1368664590132313,-0.060863900791874044},
{0.5059173685880807,-0.10882731844198501,-0.04314018977605865},
{0.4875399856787019,-0.1368664590132313,-0.0407207632422169},
{0.4895432432621741,-0.1368664590132313,-0.0204038088834075},
{0.5080391621232376,-0.10882731844198501,-0.021616108389274222},
{0.49021458778853405,-0.1368664590132313,1.2544875286708835e-10},
{0.5087503778333461,-0.10882731844198501,2.5089858333373744e-10},
{0.5304489225890192,-0.08302742975801963,3.7634733620082576e-10},
{0.5297193876863776,-0.08303820575362733,-0.023045867486504414},
{0.5546076271419312,-0.05947228871909512,2.5089858333373744e-10},
{0.553913653024795,-0.059513345262360476,-0.024657740909504806},
{0.5805260517775814,-0.038165343643805937,6.272459195345632e-11},
{0.5799484584130083,-0.03826803888194735,-0.026416598912594284},
{0.6071546145237792,-0.01931640316663407,-0.028287096230179574},
{0.6075005239827864,-0.01911112045030731,1.6824023142528167e-17},
{0.5799484584130083,-0.03826803888194735,0.026416598912594284},
{0.553913653024795,-0.059513345262360476,0.024657740909504806},
{0.5297193876863776,-0.08303820575362733,0.023045867486504414},
{0.5080391621232376,-0.10882731844198501,0.021616108389274222},
{0.4895432432621741,-0.1368664590132313,0.0204038088834075},
{0.5059173685880807,-0.10882731844198501,0.04314018977605865},
{0.4875399856787019,-0.1368664590132313,0.0407207632422169},
{0.4842166686332859,-0.1368664590132313,0.060863900791874044},
{0.5023957732234828,-0.10882731844198501,0.06448010939790741},
{0.47958406812153387,-0.1368664590132313,0.08074625924782473},
{0.49748838482373436,-0.10882731844198501,0.08554384025233072},
{0.49120705698400363,-0.10882731844198501,0.10623924757688269},
{0.47365403773861425,-0.1368664590132313,0.10028109184542695},
{0.4835862728902352,-0.10882731844198501,0.1264810932463064},
{0.4664610606704717,-0.1368664590132313,0.11938725533775472},
{0.4580374649039293,-0.1368664590132313,0.13798339095796985},
{0.4746615933279346,-0.10882731844198501,0.1461817684163112},
{0.44841665602537106,-0.1368664590132313,0.15599007961844355},
{0.464469656682168,-0.10882731844198501,0.16525743584106914},
{0.4530460237384407,-0.10882731844198501,0.18362188755571862},
{0.4376331172207415,-0.1368664590132313,0.17332434615299652},
{0.44044565207435227,-0.10882731844198501,0.20120184679012723},
{0.4257407284680791,-0.1368664590132313,0.18991722418973944},
{0.4127901369467402,-0.1368664590132313,0.20570082495634376},
{0.426726732066184,-0.10882731844198501,0.21792188157504105},
{0.3988373778338848,-0.1368664590132313,0.2206029492822379},
{0.41194422129153546,-0.10882731844198501,0.23370979273988846},
{0.396156310126688,-0.10882731844198501,0.24849230351453708},
{0.38393525350799074,-0.1368664590132313,0.23455570839509327},
{0.3794362753417742,-0.10882731844198501,0.26221122352270526},
{0.36815273034094714,-0.1368664590132313,0.2475052223168714},
{0.3515587747046435,-0.1368664590132313,0.2593986886690945},
{0.3618573937069264,-0.10882731844198501,0.274810517587233},
{0.3342245081700905,-0.1368664590132313,0.2701822274737241},
{0.34349294199227687,-0.10882731844198501,0.286235228130521},
{0.3244172745675189,-0.10882731844198501,0.29642716477628767},
{0.31621889710917755,-0.1368664590132313,0.2798030363522824},
{0.30471552179795336,-0.10882731844198501,0.3053518443385882},
{0.2976216838894017,-0.1368664590132313,0.28822663211882477},
{0.27851584367694215,-0.1368664590132313,0.2954196091869673},
{0.2844738916484418,-0.10882731844198501,0.3129726284323566},
{0.258981118839296,-0.1368664590132313,0.3013496395698869},
{0.2637785920838459,-0.10882731844198501,0.31925395627208747},
{0.24271475346946653,-0.10882624084242425,0.3241613446718359},
{0.239098329343521,-0.13686753661279208,0.30598224008163893},
{0.22137504936752989,-0.10882516324286347,0.3276807848373121},
{0.2189558383536003,-0.1368664590132313,0.3093044795274941},
{0.1986398538343956,-0.136863226214549,0.31130558191184476},
{0.1998532309398231,-0.10881977524505962,0.32979934557378676},
{0.2012918263534516,-0.083429374394187,0.3517446606288763},
{0.20293193288494418,-0.061109270211861466,0.3767395824409462},
{0.20474445534616,-0.0422782178873984,0.4043810887742682},
{0.20670353134764066,-0.027354218290420628,0.434267234992675},
{0.20877360010388063,-0.01649093711829403,0.46583874692412675},
{0.21091694563025298,-0.009842363348252706,0.498534195197462},
{0.21309585194213077,-0.007562054917706419,0.5317964608397626},
{0.21527583585356933,-0.009803785283977122,0.5650641144798669},
{0.21741810378038093,-0.016415181869171878,0.5977789595452961},
{0.2194881725366209,-0.027243441055573428,0.6293795666648887},
{0.22144940373722308,-0.04213608250533278,0.6593077392661655},
{0.22326408139756046,-0.060940733640556966,0.6870042031770868},
{0.22490742072773534,-0.08324294967017372,0.7120594705645598},
{0.2263514041391677,-0.1086268849236817,0.7340662087946133},
{0.22757016924239903,-0.13668003428921802,0.7526149300341545},
{0.2285367760484101,-0.1669853667367645,0.7672993792487731},
{0.22924044856159317,-0.1989814528951598,0.7779740804977648},
{0.2296704107863406,-0.23210470819412096,0.7844946354399867},
{0.22981696432660537,-0.265791548063365,0.7867166457342952},
{0.2296704107863406,-0.2994773103330483,0.7844946354399867},
{0.22923937096203242,-0.33260056563200946,0.7779740804977648},
{0.22853462084928858,-0.3645966517904047,0.7672993792487731},
{0.2275680140432775,-0.3949009066383905,0.7526149300341545},
{0.22634924894004615,-0.4229508232052445,0.7340651311950526},
{0.22490526552861378,-0.4483326032596309,0.7120583929649991},
{0.22326300379799968,-0.47063029337109247,0.687003125577526},
{0.22144724853810152,-0.4894322505074147,0.6593088168657263},
{0.21948601733749937,-0.5043214436385797,0.6293838770631318},
{0.21741487098169862,-0.51514808642564,0.5977865027422214},
{0.21527044785576546,-0.5217580821314057,0.5650759680750354},
{0.21309046394432693,-0.5239984116182475,0.5318115472336133},
{0.21091048003288837,-0.5217171333480966,0.4985514367904344},
{0.2087682121060768,-0.5150694216577039,0.4658559885170991},
{0.2066981433498368,-0.5042072180851379,0.43428447658564734},
{0.20474014494791695,-0.48928569696714996,0.40439617516811904},
{0.2029276224867011,-0.4704578774413692,0.3767514360361147},
{0.20128967115433008,-0.44814294573693525,0.3517532814253625},
{0.19985107574070154,-0.4227568552843058,0.3298047335715906},
{0.19863877623483486,-0.39471663711349875,0.3113077371109663},
{0.1976786350261884,-0.36444147745365385,0.29666746947833944},
{0.19698142811036992,-0.33249065047681087,0.2860261738157316},
{0.1965557762838656,-0.2994201975563275,0.27952609326516437},
{0.19641030034316162,-0.265791548063365,0.2773116261677812},
{0.1965557762838656,-0.23216289857040256,0.27952609326516437},
{0.19698142811036992,-0.1990935232494799,0.2860250962161708},
{0.19767971262574918,-0.16714054107351548,0.2966663918787787},
{0.21564868530159592,-0.19909460084904068,-0.28418563376593564},
{0.19698142811036992,-0.1990935232494799,-0.2860250962161708},
{0.19767971262574918,-0.16714054107351548,-0.2966663918787787},
{0.2170398663345505,-0.16714161867307623,-0.29475904065621505},
{0.2341553801582671,-0.19909460084904068,-0.2811317166107123},
{0.23288489027611878,-0.23216397616996332,-0.2747426288149045},
{0.21479845924814803,-0.23216397616996332,-0.27772757959823857},
{0.2145085849663008,-0.26579262566292583,-0.2755271212951454},
{0.21479845924814803,-0.2994201975563275,-0.27772650199867777},
{0.21564868530159592,-0.3324895728772502,-0.28418455616637495},
{0.2170398663345505,-0.36444147745365385,-0.29475796305665425},
{0.2189558383536003,-0.39471663711349875,-0.3093044795274941},
{0.22137504936752989,-0.4227568552843058,-0.32768186243687286},
{0.2242457745974223,-0.44814294573693525,-0.3494892447481838},
{0.22751628926436052,-0.4704578774413692,-0.37432683702438124},
{0.23113163579074528,-0.48928569696714996,-0.4017937722288585},
{0.23504116699722036,-0.5042072180851379,-0.4314891833250089},
{0.23917160611365337,-0.5150694216577039,-0.46285810653903575},
{0.24344752117079038,-0.5217171333480966,-0.4953434228980208},
{0.24779886819718136,-0.5239984116182475,-0.5283890910286065},
{0.25214913762401153,-0.5217570045318449,-0.561440147156996},
{0.2564282854798309,-0.51514808642564,-0.5939394723102711},
{0.26056087979538545,-0.5043214436385797,-0.6253331803141957},
{0.2644757989996644,-0.489431172907854,-0.6550663073949732},
{0.2680976111234138,-0.47063029337109247,-0.6825838897788066},
{0.2713756689872774,-0.4483326032596309,-0.7074785948317247},
{0.27425501501365596,-0.4229519008048052,-0.7293463227184389},
{0.2766828468240717,-0.3949019842379512,-0.7477808184045384},
{0.2786074396396076,-0.3645977293899655,-0.7623769044551738},
{0.2800072414690484,-0.33260164323157027,-0.7729891049296408},
{0.2808628555203001,-0.2994783879326091,-0.7794719438872357},
{0.2811548850012689,-0.265791548063365,-0.7816821005863759},
{0.2808628555203001,-0.23210470819412096,-0.7794730214867965},
{0.2800072414690484,-0.19898037529559903,-0.7729912601287624},
{0.2786074396396076,-0.16698428913720376,-0.762380137253856},
{0.2766828468240717,-0.13667895668965724,-0.7477851288027815},
{0.27425501501365596,-0.10862796252324247,-0.7293506331166819},
{0.2713745913877166,-0.08324618246885603,-0.7074829052299678},
{0.2680976111234138,-0.060946552678185134,-0.6825871225774889},
{0.2644757989996644,-0.04214438002195071,-0.6550695401936555},
{0.2605619573949462,-0.027253570491444667,-0.6253342579137565},
{0.2564293630793917,-0.016426819944428194,-0.5939383947107103},
{0.2521512928231331,-0.009816500958794211,-0.5614358367587529},
{0.24779994579674214,-0.007575201632347822,-0.5283837030308026},
{0.24344967636991194,-0.009855510062894101,-0.4953369573006562},
{0.23917268371321415,-0.016503760553067202,-0.4628505633421104},
{0.2350433221963419,-0.027366071885589104,-0.4314827177276443},
{0.23113379098986683,-0.04228877836309394,-0.4017873066314938},
{0.2275173668639213,-0.06111810652825978,-0.3743214490265774},
{0.22424685219698307,-0.08343583999155163,-0.3494860119495016},
{0.24700575492045432,-0.08343907279023394,-0.34573381027889893},
{0.269471550563396,-0.0834401503897947,-0.340499909212237},
{0.29154402236665655,-0.08344122798935548,-0.33380047274292735},
{0.31313265196713114,-0.08344122798935548,-0.3256732168555968},
{0.33414584340215425,-0.08344122798935548,-0.31615477993531166},
{0.35449092310949976,-0.08344122798935548,-0.3052839555662597},
{0.37407737272606295,-0.08344122798935548,-0.29309953733262856},
{0.39282652748390745,-0.08344122798935548,-0.27966187080982147},
{0.4106597226150971,-0.08344122798935548,-0.26502914637411995},
{0.4274982933516957,-0.08344122798935548,-0.2492638648000487},
{0.4432635749257669,-0.08344122798935548,-0.23242529406345014},
{0.4578962993614684,-0.08343583999155163,-0.21459102133269972},
{0.47133612108339706,-0.0834218311972616,-0.19584078897529442},
{0.4835237721157105,-0.08339381360868157,-0.17625002896048822},
{0.49439782928344483,-0.08334747682756845,-0.15589956125533883},
{0.5039130334050477,-0.08328820885172607,-0.13488098182251182},
{0.5120241252989666,-0.08322463047764063,-0.11328696422423339},
{0.5186847681840885,-0.08316212970311594,-0.0912125527417635},
{0.5238475476797396,-0.08310824972507741,-0.06874923557781157},
{0.5275221621819667,-0.08306622334220737,-0.04599464325258341},
{0.23245169525268905,-0.265791548063365,-0.27256587770214824},
{0.23288489027611878,-0.2994201975563275,-0.2747426288149045},
{0.2341553801582671,-0.3324895728772502,-0.2811317166107123},
{0.23623622491011476,-0.36444147745365385,-0.29159089794754994},
{0.239098329343521,-0.39471663711349875,-0.3059811624820782},
{0.24271475346946653,-0.422755777684745,-0.3241613446718359},
{0.24700575492045432,-0.44814294573693525,-0.34573488787845974},
{0.251893746528109,-0.4704578774413692,-0.370305235463586},
{0.2572979083253726,-0.48928569696714996,-0.39747690838841215},
{0.2631417307434306,-0.5042072180851379,-0.42685335001457453},
{0.26931422102752356,-0.5150694216577039,-0.4578849845660803},
{0.2757065416220137,-0.5217171333480966,-0.4900211586673758},
{0.28220877737170236,-0.5239984116182475,-0.5227112189429072},
{0.2887131683205126,-0.5217570045318449,-0.5554066672162424},
{0.29510764411412427,-0.5151470088260792,-0.5875579277113887},
{0.30128552239602113,-0.5043214436385797,-0.6186143470527922},
{0.30713581041144367,-0.489431172907854,-0.6480274270640207},
{0.3125496706047543,-0.47063029337109247,-0.6752486695686424},
{0.3174484382080166,-0.4483326032596309,-0.6998772075300502},
{0.32175129325417295,-0.4229519008048052,-0.7215100187125163},
{0.32538064857484766,-0.3949019842379512,-0.7397494688781164},
{0.32825460660342237,-0.3645977293899655,-0.7541914581915616},
{0.33034514975131696,-0.33260164323157027,-0.7646937435108302},
{0.3316231828303907,-0.2994783879326091,-0.7711108488952181},
{0.3320596106525027,-0.265791548063365,-0.773298376003582},
{0.3316231828303907,-0.23210470819412096,-0.7711119264947788},
{0.33034514975131696,-0.19898037529559903,-0.7646958987099517},
{0.32825460660342237,-0.16698428913720376,-0.7541946909902439},
{0.32537957097528686,-0.13668003428921802,-0.7397527016767989},
{0.32175129325417295,-0.10863011772236401,-0.7215143291107594},
{0.3174484382080166,-0.08324833766797757,-0.6998804403287325},
{0.3125496706047543,-0.060950000996779594,-0.6752519023673246},
{0.30713581041144367,-0.04214879818014986,-0.6480306598627031},
{0.30128552239602113,-0.027258742969336374,-0.6186165022519138},
{0.29510764411412427,-0.01643253122210028,-0.5875579277113887},
{0.2887131683205126,-0.009822643276290607,-0.5554066672162424},
{0.28220985497126316,-0.007581559469756363,-0.5227101413433464},
{0.2757065416220137,-0.009862083420214803,-0.4900190034682542},
{0.2693152986270843,-0.016510226150431826,-0.457881751767398},
{0.2631417307434306,-0.027372214203085495,-0.4268501172158922},
{0.2572989859249334,-0.042294274120853875,-0.3974736755897298},
{0.251893746528109,-0.06112252468645895,-0.3703030802644645},
{0.2507374821994023,-0.23216289857040256,-0.2705830945103307},
{0.25242284791244723,-0.1990935232494799,-0.2768751983456692},
{0.23623622491011476,-0.167142696272637,-0.29159197554711075},
{0.255183657987141,-0.16714161867307623,-0.28717705014663436},
{0.27379919039945005,-0.16714161867307623,-0.2815261180499543},
{0.27037134619663933,-0.1990935232494799,-0.2714279325659747},
{0.2682775702500624,-0.23216289857040256,-0.2652597526801248},
{0.2501631216335117,-0.265791548063365,-0.26843974898395834},
{0.2920073901777878,-0.16714161867307623,-0.27467150724389366},
{0.28792544304158946,-0.1990935232494799,-0.26481793686020894},
{0.28543295525752743,-0.23216289857040256,-0.25880062091286693},
{0.26756419934083236,-0.265791548063365,-0.26315735593706174},
{0.2682775702500624,-0.2994201975563275,-0.265258675080564},
{0.2507374821994023,-0.2994201975563275,-0.2705830945103307},
{0.30114974485136403,-0.265791548063365,-0.24924662320707638},
{0.3021314380512259,-0.23216289857040256,-0.2512369495958193},
{0.3050118616771652,-0.1990935232494799,-0.2570786168147558},
{0.31829866426146447,-0.23216289857040256,-0.24259891151668367},
{0.3171898143134317,-0.265791548063365,-0.24067647390026922},
{0.3021314380512259,-0.2994201975563275,-0.2512369495958193},
{0.28543295525752743,-0.2994201975563275,-0.25880062091286693},
{0.28458380680364037,-0.265791548063365,-0.25674994894872083},
{0.28792544304158946,-0.3324895728772502,-0.26481793686020894},
{0.27037134619663933,-0.3324895728772502,-0.27142685496641394},
{0.25242284791244723,-0.3324895728772502,-0.2768751983456692},
{0.3215562477336734,-0.1990935232494799,-0.24823906761775605},
{0.3097295925542181,-0.16714161867307623,-0.26664339051615404},
{0.32688821036036547,-0.16714161867307623,-0.2574751734531193},
{0.34340781162697603,-0.16714161867307623,-0.24719918404161256},
{0.33748209164229953,-0.1990935232494799,-0.2383316172560328},
{0.33386351231723244,-0.23216289857040256,-0.2329156018636007},
{0.3326307384197111,-0.265791548063365,-0.23107075141556174},
{0.33386351231723244,-0.2994201975563275,-0.2329156018636007},
{0.31829866426146447,-0.2994201975563275,-0.2425978339171229},
{0.3050118616771652,-0.3324895728772502,-0.2570786168147558},
{0.3592205075817212,-0.16714161867307623,-0.2358649918614293},
{0.3527279702280794,-0.1990935232494799,-0.22740475770982074},
{0.34876240384444424,-0.23216289857040256,-0.22223659021636583},
{0.34741217159479887,-0.265791548063365,-0.22047579253406696},
{0.34876240384444424,-0.2994201975563275,-0.22223659021636583},
{0.3527279702280794,-0.3324895728772502,-0.22740475770982074},
{0.33748209164229953,-0.3324895728772502,-0.2383316172560328},
{0.3215562477336734,-0.3324895728772502,-0.24823906761775605},
{0.3097295925542181,-0.36444147745365385,-0.26664339051615404},
{0.2920073901777878,-0.36444147745365385,-0.27467150724389366},
{0.27379919039945005,-0.36444147745365385,-0.2815261180499543},
{0.255183657987141,-0.36444147745365385,-0.28717705014663436},
{0.3614716130641705,-0.265791548063365,-0.20894116683558042},
{0.36293391566813604,-0.23216289857040256,-0.210609290955653},
{0.3672292275173669,-0.1990935232494799,-0.21550590335979378},
{0.37631554701378306,-0.23216289857040256,-0.19808111846213614},
{0.3747465620533013,-0.265791548063365,-0.1965110559020936},
{0.36293391566813604,-0.2994201975563275,-0.210609290955653},
{0.38092120753651587,-0.1990935232494799,-0.2026867789848689},
{0.3742605646513939,-0.16714161867307623,-0.22352432169148648},
{0.3884622492627873,-0.16714161867307623,-0.2102278207111403},
{0.4017598278426942,-0.16714161867307623,-0.19602613609974692},
{0.3937414095110015,-0.1990935232494799,-0.18899479896571997},
{0.38884371950729996,-0.23216289857040256,-0.18469948711648904},
{0.38717559538722734,-0.265791548063365,-0.18323610691296283},
{0.38884371950729996,-0.2994201975563275,-0.18469948711648904},
{0.37631554701378306,-0.2994201975563275,-0.19808111846213614},
{0.3672292275173669,-0.3324895728772502,-0.21550590335979378},
{0.41410049801263704,-0.16714161867307623,-0.1809860790300742},
{0.4056391862614677,-0.1990935232494799,-0.1744935416764324},
{0.4004710187680128,-0.23216289857040256,-0.17052797529279728},
{0.3987112986852747,-0.265791548063365,-0.16917774304315195},
{0.4004710187680128,-0.2994201975563275,-0.17052797529279728},
{0.4056391862614677,-0.3324895728772502,-0.1744935416764324},
{0.3937414095110015,-0.3324895728772502,-0.18899479896571997},
{0.38092120753651587,-0.3324895728772502,-0.2026867789848689},
{0.3742605646513939,-0.36444147745365385,-0.22352432169148648},
{0.3592205075817212,-0.36444147745365385,-0.2358649918614293},
{0.34340781162697603,-0.36444147745365385,-0.24719918404161256},
{0.32688821036036547,-0.36444147745365385,-0.2574751734531193},
{0.31621889710917755,-0.39471663711349875,-0.2798030363522824},
{0.2976216838894017,-0.39471663711349875,-0.28822663211882477},
{0.27851584367694215,-0.39471663711349875,-0.2954196091869673},
{0.258981118839296,-0.39471663711349875,-0.3013496395698869},
{0.40930517996720867,-0.265791548063365,-0.15439630986806407},
{0.4111500304152476,-0.23216289857040256,-0.15562908376558546},
{0.41656604580767975,-0.1990935232494799,-0.15924766309065252},
{0.4208333400683307,-0.23216289857040256,-0.14006423570981755},
{0.4189109024519162,-0.265791548063365,-0.138954308162224},
{0.4111500304152476,-0.2994201975563275,-0.15562908376558546},
{0.4264745737689638,-0.1990935232494799,-0.14332074158246574},
{0.4254336125932595,-0.16714161867307623,-0.16517230547576828},
{0.435710679604327,-0.16714161867307623,-0.14865378180871852},
{0.444877819067801,-0.16714161867307623,-0.13149408640301039},
{0.43531304536640275,-0.1990935232494799,-0.12677743312551826},
{0.4294713781474663,-0.23216289857040256,-0.12389700949957892},
{0.42748105175872336,-0.265791548063365,-0.12291531629971708},
{0.4294713781474663,-0.2994201975563275,-0.12389700949957892},
{0.4208333400683307,-0.2994201975563275,-0.14006423570981755},
{0.41656604580767975,-0.3324895728772502,-0.15924766309065252},
{0.4529059357955406,-0.16714161867307623,-0.11377296162614084},
{0.44305236541185594,-0.1990935232494799,-0.10969101448994249},
{0.4370350494645139,-0.23216289857040256,-0.10719852670588051},
{0.4349843775003678,-0.265791548063365,-0.10634927049203735},
{0.4370350494645139,-0.2994201975563275,-0.10719852670588051},
{0.44305236541185594,-0.3324895728772502,-0.10969101448994249},
{0.43531304536640275,-0.3324895728772502,-0.12677743312551826},
{0.4264745737689638,-0.3324895728772502,-0.14332074158246574},
{0.4254336125932595,-0.36444147745365385,-0.16517230547576828},
{0.41410049801263704,-0.36444147745365385,-0.1809860790300742},
{0.4017598278426942,-0.36444147745365385,-0.19602613609974692},
{0.3884622492627873,-0.36444147745365385,-0.2102278207111403},
{0.38393525350799074,-0.39471663711349875,-0.23455570839509327},
{0.36815273034094714,-0.39471663711349875,-0.2475052223168714},
{0.3515587747046435,-0.39471663711349875,-0.2593986886690945},
{0.3342245081700905,-0.39471663711349875,-0.2701822274737241},
{0.3244172745675189,-0.422755777684745,-0.29642716477628767},
{0.30471552179795336,-0.422755777684745,-0.3053507667390275},
{0.2844738916484418,-0.422755777684745,-0.31297155083279593},
{0.2637785920838459,-0.422755777684745,-0.31925395627208747},
{0.44139286208826944,-0.265791548063365,-0.08932966302922934},
{0.44349418123177176,-0.23216289857040256,-0.09004303393845937},
{0.44966236111762165,-0.1990935232494799,-0.0921368098850363},
{0.44881752306197764,-0.23216289857040256,-0.07250262260793103},
{0.44667417753560523,-0.265791548063365,-0.07192826204204039},
{0.44349418123177176,-0.2994201975563275,-0.09004303393845937},
{0.4551096268973161,-0.1990935232494799,-0.07418852712075634},
{0.45976054660160126,-0.16714161867307623,-0.09556486960775915},
{0.4654114786982813,-0.16714161867307623,-0.07694879839566977},
{0.46982640409875776,-0.16714161867307623,-0.058001473078599576},
{0.45936614516235924,-0.1990935232494799,-0.05592084384666405},
{0.45297705736655147,-0.23216289857040256,-0.054650030684647494},
{0.4508003062537952,-0.265791548063365,-0.054217158941086016},
{0.45297705736655147,-0.2994201975563275,-0.054650030684647494},
{0.44881752306197764,-0.2994201975563275,-0.07250262260793103},
{0.44966236111762165,-0.3324895728772502,-0.0921368098850363},
{0.47299346920786195,-0.16714161867307623,-0.03880565330281571},
{0.4624189847180219,-0.1990935232494799,-0.037413610190212485},
{0.4559609305503247,-0.23216289857040256,-0.03656349189672071},
{0.45376154984679234,-0.265791548063365,-0.03627383313478562},
{0.4559609305503247,-0.2994201975563275,-0.03656349189672071},
{0.4624189847180219,-0.3324895728772502,-0.037413610190212485},
{0.45936614516235924,-0.3324895728772502,-0.05592084384666405},
{0.4551096268973161,-0.3324895728772502,-0.07418852712075634},
{0.45976054660160126,-0.36444147745365385,-0.09556486960775915},
{0.4529059357955406,-0.36444147745365385,-0.11377296162614084},
{0.444877819067801,-0.36444147745365385,-0.13149408640301039},
{0.435710679604327,-0.36444147745365385,-0.14865378180871852},
{0.4376331172207415,-0.39471663711349875,-0.17332434615299652},
{0.4257407284680791,-0.39471663711349875,-0.18991722418973944},
{0.4127901369467402,-0.39471663711349875,-0.20570082495634376},
{0.3988373778338848,-0.39471663711349875,-0.2206029492822379},
{0.396156310126688,-0.422755777684745,-0.24849230351453708},
{0.3794362753417742,-0.422755777684745,-0.26221122352270526},
{0.3618573937069264,-0.422755777684745,-0.274810517587233},
{0.34349294199227687,-0.422755777684745,-0.286235228130521},
{0.33414584340215425,-0.44814294573693525,-0.31615477993531166},
{0.31313265196713114,-0.44814294573693525,-0.32567213925603605},
{0.29154402236665655,-0.44814294573693525,-0.33380047274292735},
{0.269471550563396,-0.44814294573693525,-0.340499909212237},
{-0.1333750364363351,-0.10834347623919909,-0.09733482688632457},
{-0.12864760716323528,-0.10922710787903082,-0.11880966197318178},
{-0.12248643167453042,-0.11011828271578798,-0.1389101265802324},
{-0.11489215652995696,-0.11095126717626351,-0.15778536048668707},
{-0.10586424292973455,-0.11165925008768966,-0.1755873052306144},
{-0.09540236759399494,-0.1121797306755418,-0.19246574715096146},
{-0.08355728546205042,-0.11247930335343596,-0.20845516943367295},
{-0.07037996699312543,-0.11252779533367063,-0.2235932880633758},
{-0.055921382646444404,-0.112296111428105,-0.23791566382557544},
{-0.040232395121275716,-0.11175192364991593,-0.25145785750577726},
{-0.023456238951236972,-0.11103316474288205,-0.264160601128139},
{-0.005735987030011655,-0.11027453465209967,-0.2759667819159397},
{0.012785179988760666,-0.10961504372090818,-0.286817131893337},
{0.031963973691484356,-0.10918939189440388,-0.29665238308448866},
{0.05172628755636522,-0.10894585439366976,-0.3053874051240937},
{0.07199776721371011,-0.1088316288402281,-0.31293383484816895},
{0.09270427381373804,-0.10879391285560112,-0.31920438669229195},
{0.11377134522679973,-0.1087799040613111,-0.324113930291162},
{0.1351088941296148,-0.10878421445955419,-0.3276441464522459},
{0.15662855735820005,-0.10879606805472267,-0.3297788711821321},
{-0.1448762565484378,-0.08340997760209314,-0.13216543092937036},
{-0.13923502284780467,-0.08480762423241237,-0.15361828298518784},
{-0.13199678659810976,-0.0861363044908423,-0.17346551169545743},
{-0.12310906870074356,-0.08727532722657663,-0.1919474217622309},
{-0.11252197629604244,-0.08810507888836984,-0.20930755068624232},
{-0.10031320431233788,-0.08859323148939885,-0.2256471928262042},
{-0.08656055543791757,-0.08870745704284051,-0.24106979773995044},
{-0.07134161684115693,-0.08841542756187173,-0.2556798925848758},
{-0.05473440673025578,-0.08768481505966938,-0.26957877171969263},
{-0.03690843151612328,-0.08670312185980754,-0.2826942359738294},
{-0.018033639425488537,-0.08565569508673869,-0.2949530085771537},
{0.0017203876987700046,-0.08472788186491535,-0.30628073515997234},
{0.02218389559784419,-0.0841071845179116,-0.31660413895215295},
{0.043274243161418514,-0.08372894707208117,-0.32581545999761846},
{0.06490899402309407,-0.0835274359542171,-0.3338047831411704},
{0.08700549629655974,-0.08343799519067316,-0.34046434842673157},
{0.10948142137537269,-0.08339596880780312,-0.3456831630995427},
{0.1322414016984047,-0.08338734801131696,-0.34944183036751},
{0.15519319474325385,-0.08339920160648542,-0.3517187982394178},
{0.15355847620956514,-0.061071661987190586,-0.3767083320536838},
{0.1517491865470316,-0.042233820785494654,-0.404344450389202},
{0.14979226574467253,-0.027303894390932653,-0.43422628620936576},
{0.14772542978711484,-0.01643608730065082,-0.4657934877425744},
{0.14558316186030326,-0.009784711771751482,-0.4984878584163489},
{0.14340210034930395,-0.007503972301380898,-0.5317512016582102},
{0.14121888363918308,-0.009748288906597449,-0.5650242432961184},
{0.13907230531412837,-0.016364750209727823,-0.5977444763593515},
{0.13699900375920612,-0.027200552593054764,-0.6293493938771871},
{0.13503669495904316,-0.042102892438861055,-0.6592775664784639},
{0.1332252500973881,-0.060919073889385486,-0.6869675647920206},
{0.13158837636457785,-0.083232173674566,-0.7120109785843252},
{0.13015301374963165,-0.1086268849236817,-0.7340037080200885},
{0.128945024642008,-0.13668649988658266,-0.7525373428657791},
{0.1279902714311654,-0.16699506513281145,-0.7672077832861076},
{0.12729737491359003,-0.1989889960920852,-0.7778717085394916},
{0.12687387828620725,-0.23210794099280327,-0.784384720284788},
{0.12672840234550323,-0.2657904704638043,-0.7866067305790966},
{0.12686956788796416,-0.299474077534366,-0.7843933410812742},
{0.1272898317166646,-0.3325941000346448,-0.7778878725329033},
{0.12797949543555767,-0.3645891085934793,-0.7672304128768836},
{0.1289331710468395,-0.39489444104102583,-0.7525642828547983},
{0.1301400825549024,-0.42294543520744066,-0.7340295704095471},
{0.1315754451698486,-0.4483293704609487,-0.7120368409737836},
{0.13321231890265883,-0.47062921577153166,-0.6869923495819183},
{0.13502268616475316,-0.4894322505074147,-0.659305584067044},
{0.13698283976579453,-0.5043225212381403,-0.6293838770631318},
{0.13905290852203453,-0.5151491640252007,-0.5977886579413431},
{0.14119733164796763,-0.5217591597309665,-0.565078123274157},
{0.14337839315896697,-0.5239984116182475,-0.5318126248331742},
{0.14555837707040553,-0.5217182109476572,-0.4985514367904344},
{0.1477017225967779,-0.5150694216577039,-0.4658559885170991},
{0.14977071375345713,-0.5042072180851379,-0.43428447658564734},
{0.15172978975493773,-0.48928569696714996,-0.40439617516811904},
{0.1535412346165928,-0.4704578774413692,-0.3767514360361147},
{0.15518026354852463,-0.44814294573693525,-0.3517532814253625},
{0.15661885896215313,-0.4227568552843058,-0.3298047335715906},
{0.15783115846801984,-0.39471663711349875,-0.3113088147105271},
{0.15879022207710553,-0.3644425550532145,-0.29666854707790025},
{0.15948742899292398,-0.33249065047681087,-0.28602725141529234},
{-0.15699817400754426,-0.062150015867653535,-0.16954628209293543},
{-0.15048192946356553,-0.06406480252718649,-0.19068770787569028},
{-0.14202385051107852,-0.06571546953437463,-0.21012760395198862},
{-0.13148708200586534,-0.06691171280678586,-0.22815584460367774},
{-0.1189981341363605,-0.06762659235540096,-0.24496747535125704},
{-0.1046821162115694,-0.06783284491133242,-0.26076077451390833},
{-0.08866478410023397,-0.06750363824551706,-0.2757297100125702},
{-0.07107200143105219,-0.0666116013291113,-0.2900704049673029},
{-0.052102800842898346,-0.06539057326680234,-0.30369018581588025},
{-0.031956107214690666,-0.06407417764336519,-0.3164963789960759},
{-0.010831114825237565,-0.06289636132344313,-0.3283963109456637},
{0.011073089806608627,-0.062090640131855085,-0.33929623050285646},
{0.03366216283930246,-0.06158158209934714,-0.3490646705212403},
{0.056841868191254565,-0.061293970776577514,-0.35756800865527966},
{0.08051780814094144,-0.06115226643433621,-0.36467370015899986},
{0.1045955849668396,-0.06108103710336929,-0.37024920028642594},
{0.12897519742970956,-0.06106067047167073,-0.3742697242476604},
{0.12536308370200713,-0.04222272151001871,-0.4017269610560907},
{0.12145786289377511,-0.02729074767629125,-0.43141267375619413},
{0.11733281177514596,-0.01642013882715142,-0.4627729761737349},
{0.11305905191713046,-0.009766284819262309,-0.4952539821344769},
{0.10870986008986105,-0.007484359989374873,-0.5283007278646233},
{0.1043585130634701,-0.00972986195410827,-0.5613582495903775},
{0.10007936520765078,-0.016349448295964877,-0.5938672731396994},
{0.09594677089209622,-0.02718988435740314,-0.625266369141428},
{0.09203616208606036,-0.04209782772092542,-0.654996263423523},
{0.08842156987936815,-0.0609199359690341,-0.6824966042143842},
{0.08515396473124401,-0.08323863927193065,-0.7073676020769655},
{0.08228485590069277,-0.10863873851885018,-0.7292073123750994},
{0.07986521384693887,-0.13670050868087266,-0.7476181008708621},
{0.07794644006903106,-0.16700691872797993,-0.7621980229280859},
{0.0765484701588436,-0.1989997720876929,-0.7728016026060668},
{0.0756917785080311,-0.23211440659016788,-0.7792844415636616},
{0.07539630070846785,-0.2657937032624865,-0.7815010638601664},
{0.07568240339185241,-0.2994729999348052,-0.7793059935548771},
{0.07653036648622266,-0.3325908672359625,-0.7728414737898154},
{0.07792068543952864,-0.36458479819523626,-0.7622529805056852},
{0.07983374793976437,-0.3948890530432219,-0.7476827568445084},
{0.0822499416749238,-0.42294004720963674,-0.7292741235478672},
{0.08511732634617782,-0.44832506006270556,-0.7074311804510508},
{0.08838406941465335,-0.4706270605724101,-0.6825580273893481},
{0.0919984461014334,-0.489431172907854,-0.6550566089989261},
{0.09590797730790848,-0.5043235988377011,-0.6253331803141957},
{0.10003949402390226,-0.5151491640252007,-0.5939427051089534},
{0.1043186418797216,-0.5217591597309665,-0.5614423023561176},
{0.10866998890611256,-0.5239994892178083,-0.5283901686281672},
{0.1130213359325035,-0.5217182109476572,-0.4953434228980208},
{0.1172983285892013,-0.5150694216577039,-0.46285810653903575},
{0.12142769010607353,-0.5042072180851379,-0.4314891833250089},
{0.12533722131254862,-0.48928569696714996,-0.4017937722288585},
{0.12895364543849416,-0.4704578774413692,-0.37432683702438124},
{0.1322230825058716,-0.44814294573693525,-0.3494903223477446},
{0.13509488533532477,-0.4227568552843058,-0.32768294003643367},
{0.13751409634925435,-0.39471771471305955,-0.30930555712705493},
{0.13942899076874338,-0.3644425550532145,-0.2947601182557758},
{0.140820171801698,-0.33249065047681087,-0.28418671136549645},
{0.12231347694502684,-0.3324895728772502,-0.2811317166107123},
{0.10128627671571365,-0.36444147745365385,-0.28717705014663436},
{0.07795441430578076,-0.39471555951393794,-0.2954196091869673},
{0.05175430514494525,-0.4227547000851843,-0.3053518443385882},
{0.043336312896118896,-0.4481418681373746,-0.32567429445515755},
{0.033749340643768784,-0.4704578774413692,-0.3488189778213846},
{0.011243350537210352,-0.4704578774413692,-0.3386238083769357},
{-0.010547512172834006,-0.4704578774413692,-0.32698142272237213},
{-0.03152517515033858,-0.47045895504093,-0.3139306144418816},
{-0.05160581192547103,-0.47045895504093,-0.2995360395091103},
{-0.0707054020604781,-0.47045895504093,-0.2838623538977046},
{-0.08874032382944397,-0.47045895504093,-0.2669742135813105},
{-0.1056265244666286,-0.47045895504093,-0.24893735213313525},
{-0.12129924023842964,-0.47045895504093,-0.22983474471935805},
{-0.13569403069111305,-0.47045895504093,-0.20975152170527975},
{-0.16960932166724046,-0.044913056573438144,-0.20853060140292687},
{-0.1619799167769859,-0.04713549790757106,-0.22932180732843133},
{-0.1517534969452746,-0.048740043653558204,-0.2482994131931592},
{-0.13913049569040994,-0.04971365485671428,-0.26578346606665926},
{-0.1243124241302559,-0.05004361584222219,-0.28208970262023725},
{-0.10750036234285229,-0.04971710317530875,-0.2975360147243204},
{-0.08889614472593138,-0.0487212934212008,-0.3124424494484576},
{-0.06873026982554199,-0.04732871150881719,-0.3266904708409641},
{-0.047233451707645056,-0.04581177460712067,-0.34016477574883736},
{-0.024636296678245444,-0.04444289988507401,-0.35274790581995363},
{-0.001169518803304105,-0.043494612271596046,-0.36432348030174944},
{0.0230568590020243,-0.042884259880375676,-0.37473524725791324},
{0.04793292158254119,-0.042528759785277516,-0.3838258771525725},
{0.07334886154300406,-0.042345567859946545,-0.39143804044985475},
{0.09919465596825827,-0.04225170893820345,-0.39741440761388747},
{0.0933572991475649,-0.027322213583465746,-0.4267800732444421},
{0.08719375293982633,-0.016450096094940834,-0.45779877660121865},
{0.08081145402125138,-0.009793009288369422,-0.48992201950778486},
{0.07431945546738998,-0.0075084982195361295,-0.5226045365863908},
{0.06782627155401175,-0.009754107944225605,-0.5552967520610439},
{0.061442032956227396,-0.0163756339652916,-0.5874447797575078},
{0.0552767625891916,-0.02721865626567571,-0.6184925783024251},
{0.04944037560810293,-0.04212886258827562,-0.6478862615215598},
{0.044042894928116055,-0.06095194067598899,-0.6750708656411151},
{0.039159321478660594,-0.08327096725875376,-0.699657377219653},
{0.03486444066925402,-0.10866891130655175,-0.7212557052161747},
{0.03123336118928201,-0.13672744866989192,-0.7394746809901199},
{0.028340976208218127,-0.16703062591831688,-0.753927446299173},
{0.026224462910908953,-0.199018091280226,-0.7644566716074607},
{0.024920782962288893,-0.2321284153844579,-0.7709071825782323},
{0.02446700578724847,-0.2658023240589727,-0.7731238048747372},
{0.024900308570634258,-0.2994773103330483,-0.7709502865606632},
{0.026184591727160443,-0.3325908672359625,-0.76453964677364},
{0.028283540151629066,-0.36458048779699315,-0.7540427494521753},
{0.031161054258754317,-0.39488366504541816,-0.7396115361343379},
{0.034781034463250385,-0.4229346592118329,-0.7213979483581963},
{0.03906858759564373,-0.4483196720649017,-0.6997953099634318},
{0.0439488204864608,-0.470622750174167,-0.6752001775884076},
{0.04934694772618414,-0.4894290177087324,-0.6480069526723661},
{0.0551880761453402,-0.5043214436385797,-0.6186089590549882},
{0.06136132074912569,-0.5151491640252007,-0.5875590053109494},
{0.06775536550291306,-0.5217591597309665,-0.5554099000149249},
{0.07425943317185507,-0.5239994892178083,-0.5227133741420287},
{0.0807625310011924,-0.5217182109476572,-0.4900211586673758},
{0.08715506711559468,-0.5150694216577039,-0.4578849845660803},
{0.0933282039594241,-0.5042072180851379,-0.42685335001457453},
{0.0991709487779213,-0.48928569696714996,-0.39747690838841215},
{0.10457618817474573,-0.4704578774413692,-0.370305235463586},
{0.10946310218283958,-0.44814294573693525,-0.34573488787845974},
{0.11375410363382739,-0.4227568552843058,-0.3241613446718359},
{0.11737052775977291,-0.39471663711349875,-0.30598224008163893},
{0.12023263219317915,-0.3644425550532145,-0.29159197554711075},
{-0.1647482700486051,-0.05828800680180843,-0.12099180108374188},
{-0.14897005727980464,-0.0820629781511301,-0.10886557322639236},
{-0.1515670722212613,-0.08088623943076881,-0.08347635773503659},
{-0.16625475423456212,-0.05672096152053609,-0.09299738089426755},
{-0.17950276323467365,-0.03532834728016565,-0.10199738466586601},
{-0.17958789359997454,-0.03728031112454519,-0.1326589715282032},
{-0.16170836168767175,-0.060160982598383504,-0.14641129712275527},
{-0.17814606538766373,-0.03971126797368718,-0.16046104019608004},
{-0.17490895630710937,-0.042346860979419476,-0.18566393872337858},
{-0.19210421249832296,-0.025599886205486387,-0.2009410676964208},
{-0.18864296270912836,-0.0288582239973879,-0.22606853425446544},
{-0.18235193647335066,-0.03169274188203842,-0.24872614261922427},
{-0.17277638677634471,-0.033731668010972125,-0.2690313511428213},
{-0.16022881749073398,-0.03498847237869866,-0.2874572260324347},
{-0.1450184996904595,-0.035476948259595895,-0.3044779110948035},
{-0.12745793724814475,-0.03521067340812953,-0.32056862773622735},
{-0.10785758659724767,-0.03420333333872134,-0.33620244216388456},
{-0.08648232170980563,-0.03275062137084673,-0.3512349560366319},
{-0.0635957234383831,-0.031148123064025042,-0.3655217710133261},
{-0.03946201919528094,-0.02969153173773167,-0.3789195663523847},
{-0.01434517776890551,-0.028676432951485937,-0.391281788513543},
{0.011624928541679156,-0.028017480820074825,-0.40242955596971297},
{0.03831868606130359,-0.02762911393837316,-0.412182909594246},
{0.06560620093891252,-0.027425878661211864,-0.42035973506137203},
{0.057434116909853984,-0.016554731012291643,-0.4509010618127272},
{0.04897690003701558,-0.009893657087345372,-0.4825242985230959},
{0.04037862538167233,-0.007604296820488622,-0.514690645412093},
{0.031783583525011386,-0.00984818238588086,-0.5468645354980154},
{0.02333487968870307,-0.016469061847210392,-0.5784974706044309},
{0.015175834614329843,-0.02731079102812158,-0.6090452629531509},
{0.00744944576360594,-0.04221744127217093,-0.637962647166425},
{0.00029892611815774664,-0.0610326528830907,-0.6647022026673822},
{-0.006179031313426806,-0.08334101123020383,-0.6888921576075565},
{-0.011887819730524645,-0.10872710168283335,-0.7101596625389216},
{-0.016730800004525887,-0.13677486305056583,-0.728129712814329},
{-0.020611322230825027,-0.16706941950250462,-0.7424316141848741},
{-0.02346785547450208,-0.19904934166748833,-0.7528864851234687},
{-0.02523889035262826,-0.23215320017435562,-0.7593175993021465},
{-0.02586288515428798,-0.2658195656519451,-0.7615471527933805},
{-0.02527831972055685,-0.29948916392821673,-0.7593973416696436},
{-0.0235453779869039,-0.3325962552337664,-0.7530405818606588},
{-0.02072423311280255,-0.36458048779699315,-0.7426460564974674},
{-0.01687505825772622,-0.3948793546471751,-0.7283840263106709},
{-0.012058026581148334,-0.42292819361446826,-0.7104269072299926},
{-0.006367578908574806,-0.4483132064675371,-0.6891529367012631},
{0.0001018331584928354,-0.47061628457680243,-0.664942507369434},
{0.007255801122535494,-0.4894225521113678,-0.6381770894790183},
{0.014999754846099956,-0.5043171332403366,-0.6092338428762857},
{0.023186170949316753,-0.5151459312265184,-0.5786601881381073},
{0.03166698725253603,-0.5217570045318449,-0.5469992354431116},
{0.04029468037588831,-0.5239984116182475,-0.5147994829677307},
{0.0489214036596359,-0.5217182109476572,-0.4826029632910322},
{0.05740200444294303,-0.5150694216577039,-0.4509527865916442},
{0.06559100678510565,-0.5042072180851379,-0.42039098544863435},
{0.07334336578524414,-0.48928569696714996,-0.3914595924410701},
{0.0805137132626105,-0.4704578774413692,-0.3646995625484583},
{0.08699762981976612,-0.44814294573693525,-0.3405009868117978},
{0.092690265019448,-0.422755777684745,-0.31925395627208747},
{0.09748881586355869,-0.39471663711349875,-0.3013496395698869},
{0.27595546712055163,-0.06112435660571225,-0.36469848494889756},
{0.28312581459791797,-0.042296644839887564,-0.39145851484150934},
{0.29087806583810044,-0.027374800442031343,-0.42038990784907354},
{0.3085022066545006,-0.042297937959360495,-0.38375691078068314},
{0.2995969238842938,-0.061125326445316944,-0.3575227494737273},
{0.3227200552593055,-0.06112575748514126,-0.3488179002218239},
{0.3452257220859957,-0.06112575748514126,-0.338622730777375},
{0.3333214797381649,-0.0422983689991848,-0.3744119673896821},
{0.35747910669151617,-0.0422983689991848,-0.36347002144961926},
{0.36701694040389515,-0.061125541965229103,-0.3269803451228113},
{0.31812948113042355,-0.027376201321460347,-0.4121193312201606},
{0.3447839062660798,-0.027376740121240733,-0.40208472411026647},
{0.37072603809206695,-0.027376740121240733,-0.3903335009000651},
{0.3808684051580381,-0.042298261239228724,-0.35097309934336474},
{0.4033870031794575,-0.042298045719316564,-0.3369643050533493},
{0.38799564865297365,-0.06112543420527302,-0.3139295368423208},
{0.4080767164679304,-0.06112543420527302,-0.2995360395091103},
{0.4271771686825861,-0.061125326445316944,-0.2838645090968261},
{0.4452129525312006,-0.061125326445316944,-0.26697852397955363},
{0.4620989376484731,-0.061125326445316944,-0.24894274013093912},
{0.4777726232598788,-0.061106576212959535,-0.22984013271716192},
{0.4921715085908931,-0.06105032551588733,-0.20975152170527975},
{0.5052320152674307,-0.06093771636178681,-0.18875988226147197},
{0.5168916425149666,-0.06074999851830061,-0.1669460343527964},
{0.5270771135633685,-0.06051443525431619,-0.14441666033576925},
{0.5357140740429434,-0.06025839759867714,-0.12127413216866373},
{0.5427303247831197,-0.06000904106031487,-0.09762351580865496},
{0.5480515114142039,-0.059793736668072944,-0.07357030825274236},
{0.5517530659054504,-0.05962455353703198,-0.04921472626007758},
{0.44544355883720543,-0.042298045719316564,-0.3046934310069575},
{0.464802634946446,-0.042298045719316564,-0.2865682063947991},
{0.4651927259874449,-0.02737630908141642,-0.327212029028377},
{0.48598177671382786,-0.02737630908141642,-0.3077473481621809},
{0.4829278595586045,-0.042298045719316564,-0.2672091302855585},
{0.49975349910047384,-0.042251062378466986,-0.24670133304453665},
{0.5152159751979686,-0.042110327875830356,-0.2251299450370344},
{0.5292506318774425,-0.04182875111060105,-0.20257901902879183},
{0.5417895803665671,-0.04135945650188553,-0.17913368538510982},
{0.5527099743154145,-0.04077065610188057,-0.15491571285635544},
{0.561883579376253,-0.040130561962782946,-0.13004579259333493},
{0.5691853940000334,-0.039507278376833335,-0.10464795630549302},
{0.5744904166377062,-0.03896901739622851,-0.07884235634385556},
{0.5780077016040609,-0.03854595180867004,-0.052731364666695764},
{0.42494222719354824,-0.042298045719316564,-0.3215147601505838},
{0.4431752117617837,-0.02737630908141642,-0.34527798566469303},
{0.4624362263109942,-0.01651432102876275,-0.3703785122337184},
{0.48605397588439947,-0.01651432102876275,-0.351000039332384},
{0.5083548987945433,-0.01651432102876275,-0.3301204702428963},
{0.5054464575800239,-0.02737630908141642,-0.2869582974357979},
{0.5235210350128261,-0.027282450159673316,-0.26493000721452903},
{0.540137620239906,-0.027000873394444007,-0.24174868546323583},
{0.555232634887178,-0.02643782762394147,-0.21749946254721905},
{0.5687381901823138,-0.02549923840651043,-0.192270701630462},
{0.5804452318105235,-0.024321637606500517,-0.16620572345454712},
{0.5901393174592142,-0.023041449328305257,-0.1394532367588607},
{0.5976092376144748,-0.02179488215640604,-0.11215656228498522},
{0.602644860361955,-0.02071846795515246,-0.08446473205217522},
{0.6056815359242059,-0.019872229020079457,-0.0564749455408122},
{-0.19236606919159016,-0.01929905381370567,-0.1428121145897821},
{-0.19319366565426185,-0.022289500354799662,-0.17322843979208796},
{-0.20546213665363305,-0.0032427125982703487,-0.15225619714037406},
{-0.20908718157606476,-0.007385544109652226,-0.18557126516115233},
{-0.2103285762700723,-0.011959523205298347,-0.2160770311270021},
{-0.2280615546421103,0.005511167433648149,-0.19835051835232873},
{-0.23132668131124468,-0.001476419158211554,-0.23177011353050173},
{-0.20874127211705745,-0.016136730142668795,-0.24372608065724952},
{-0.20375198615069043,-0.019624704400970493,-0.2684720769707814},
{-0.19479282340244514,-0.022130985459410328,-0.29026652808736314},
{-0.18228297010146136,-0.023704173058179064,-0.30976138174126083},
{-0.16664700047468256,-0.024392759177511363,-0.32760212006937584},
{-0.14830625595037006,-0.024245235797641897,-0.34444069080597445},
{-0.12768315555634577,-0.023310094898805325,-0.3609236536875187},
{-0.1050702675733589,-0.02189391355604084,-0.3768699719877994},
{-0.08075908268259786,-0.02030305332447547,-0.392098608980607},
{-0.05504238468472397,-0.0188440912791484,-0.40642745034017125},
{-0.028212310820662077,-0.01782360449509881,-0.4196733041411613},
{-0.0004212336683051246,-0.01715775572649877,-0.43163681446483443},
{0.028178366434497875,-0.016762707727520334,-0.4421132373946444},
{0.01769105974912408,-0.010097107884418829,-0.47309099196811166},
{0.007036078572094405,-0.007800096660680608,-0.5045903047289918},
{-0.0036074800495911005,-0.010039240788005463,-0.5360874622907504},
{-0.014066262674591302,-0.016655809851091906,-0.5670479752712453},
{-0.024166861981587025,-0.027490534634858087,-0.5969427422861383},
{-0.03373597840921517,-0.04238479248395859,-0.6252372739532871},
{-0.04260020463615656,-0.061179421943267615,-0.6514003136892321},
{-0.05064405431748343,-0.08346277998057089,-0.6750827192362837},
{-0.05775168550041296,-0.10882300804374193,-0.695935348336752},
{-0.06380757951203056,-0.1368481398206982,-0.7136058259342654},
{-0.06869610991946558,-0.16712653227922544,-0.7277471649702555},
{-0.07232126260185333,-0.19909460084904068,-0.7381427679330078},
{-0.07458702343832921,-0.23219091615898257,-0.7445792701094895},
{-0.07539716278811641,-0.2658497384396466,-0.7468411515875466},
{-0.07465577429030637,-0.2995107159194322,-0.7447139700545858},
{-0.07245704014651042,-0.33261026402805643,-0.7384024694271535},
{-0.06889514255833987,-0.364585875794797,-0.7281081608231137},
{-0.06406426372740608,-0.3948771994480535,-0.7140357881590128},
{-0.05805869361527645,-0.4229217280171037,-0.6963900953513972},
{-0.0509878085773692,-0.4483035080714901,-0.6755277678548819},
{-0.04296130824897073,-0.47060550858119465,-0.6518076463232034},
{-0.03408867674545533,-0.48941285371532084,-0.6255885714100984},
{-0.024479581374122598,-0.5043085124438503,-0.5972293837693031},
{-0.014318173123912602,-0.5151394656291539,-0.5672656503825209},
{-0.003788732295712685,-0.5217537717331627,-0.5362329382314543},
{0.0069245470175546674,-0.5239973340186868,-0.5046678918973673},
{0.017637287531041632,-0.5217182109476572,-0.4731060783619625},
{0.028168991318319174,-0.5150704992572646,-0.4420798318082606},
{0.03833916045295823,-0.5042082956846987,-0.4121193312201606},
{0.04796708148861761,-0.48928569696714996,-0.38375691078068314},
{0.0568721487389122,-0.4704578774413692,-0.3575238270732881},
{0.06492472697668131,-0.4481418681373746,-0.33380155034248804},
{0.07199539649467643,-0.422755777684745,-0.3129726284323566},
{-0.23106590221753823,-0.006984892592957786,-0.26192565963910114},
{-0.2572504939446986,0.0052354097060469985,-0.24919705362728095},
{-0.25677958293664194,-0.0016391366918878892,-0.28109076782740305},
{-0.22679645275776583,-0.011168672887648935,-0.2886878447308345},
{-0.2521006456437768,-0.006562365805179701,-0.30950491304579747},
{-0.28704073380219686,-0.0003359955430482214,-0.30164382424997727},
{-0.28027664135924096,-0.0060432860967565925,-0.3310547490620843},
{-0.24274492625716804,-0.010129974671022331,-0.3339243966924159},
{-0.2180366459282631,-0.014182287819299491,-0.31192520165928783},
{-0.22125543581628432,0.011990558072648524,-0.16180049645011765},
{-0.24603052731795705,0.029196331635575223,-0.1734191749143443},
{-0.25398213447688195,0.014656862665862773,-0.2143399406350402},
{-0.2907142707048632,0.01830782385773099,-0.2363100404800275},
{-0.29025198049329276,0.007561623877882102,-0.26953566773726184},
{-0.3280843458728206,0.005710200072522445,-0.29047019440434874},
{-0.3206747712929632,-0.00303430484321735,-0.3224264093789955},
{-0.3106099913953675,-0.009546346748909069,-0.35254316190340723},
{-0.2691536586929687,-0.010218230075049423,-0.3561822156201289},
{-0.2292275173668639,-0.012470089877191368,-0.3553427655622888},
{-0.2052864879252275,-0.01611366951206831,-0.33246532688713276},
{-0.1890459849448565,-0.017050750090114263,-0.3511368944766018},
{-0.21206135636379111,-0.013710838011462433,-0.37475572164956783},
{-0.19176045823843718,-0.013980561181523262,-0.3931568117492835},
{-0.16981729838246915,-0.0170815694375523,-0.36876534569124514},
{-0.14810151203382366,-0.016293951918585202,-0.3861782769937343},
{-0.12420574177373962,-0.01499609100759331,-0.403142926878943},
{-0.09843979747593852,-0.013496395698869115,-0.4194243786426233},
{-0.07111144157497638,-0.012102843946880814,-0.4347887931800879},
{-0.04252929858505786,-0.011123736985964808,-0.44900233138664974},
{-0.012869750002289867,-0.010481164367877407,-0.46184300775279},
{-0.025508387226781334,-0.008164002032352773,-0.4925384312413354},
{-0.03812504142023308,-0.010382564008066912,-0.5232112251391047},
{-0.05052347092663322,-0.016975102600948182,-0.5533495296547317},
{-0.06250713236209282,-0.027779546837056714,-0.58244040739729},
{-0.07387968708663951,-0.04263425678227694,-0.6099741537745349},
{-0.08444490422025701,-0.06137726922262507,-0.6354378313955399},
{-0.09406431221938631,-0.08360502312259258,-0.6585092379916346},
{-0.10259954730042449,-0.10891352640684665,-0.6788683264932702},
{-0.10991246119968079,-0.1368998645996152,-0.6961939722313368},
{-0.11586469013355227,-0.16715886026604856,-0.7101628953376039},
{-0.12031302112041256,-0.19912261843762075,-0.7205100063201214},
{-0.12311467221845958,-0.23222108894668417,-0.7269637500895755},
{-0.12412707700580339,-0.2658842216255913,-0.7292590371540165},
{-0.12320572938134468,-0.29954412150581605,-0.7271275452228125},
{-0.12049664408556784,-0.33263935921619725,-0.7208214325931841},
{-0.11614368065983574,-0.36460850538557327,-0.7105971679605942},
{-0.11029134520524767,-0.39489228584190433,-0.6967058320227029},
{-0.10308414382290294,-0.42292819361446826,-0.679403893474973},
{-0.0946412590242228,-0.44830135287236855,-0.6590200201834397},
{-0.08508198108058448,-0.4705979653842693,-0.6358828800141381},
{-0.07452538474345313,-0.48940100012015236,-0.610321140833103},
{-0.06309065252425,-0.5042966588486819,-0.5826667033050517},
{-0.05099739921346005,-0.5151308448326677,-0.5534411256173972},
{-0.03846491632170008,-0.5217483837353588,-0.5231691987562346},
{-0.025712700103503405,-0.5239951788195651,-0.49237679130721984},
{-0.01296009594946486,-0.5217182109476572,-0.4615854614577659},
{-0.00042231126786589605,-0.5150704992572646,-0.4313156897957248},
{0.011685274117082301,-0.5042082956846987,-0.40208472411026647},
{0.023147592885041167,-0.48928569696714996,-0.3744130449892429},
{-0.11635392033414205,-0.010947764977691002,-0.44703032419043987},
{-0.08740323829444004,-0.009669516378705124,-0.46352298546803117},
{-0.10365203879142895,-0.011746374012177953,-0.49214402980209343},
{-0.057054801864462726,-0.008764440507614052,-0.4787699416533718},
{-0.14360037866848563,-0.01229497994856618,-0.42960015129497836},
{-0.13421771929285758,-0.012876991471338277,-0.4744444570164393},
{-0.15185048090574396,-0.01912200420587109,-0.5012734532809404},
{-0.11965353018922106,-0.01816886739436965,-0.5202090327627983},
{-0.07154722283735193,-0.0109332173836206,-0.5084815167429337},
{-0.1688388379812896,-0.013407278215193403,-0.41154066025602687},
{-0.16296699797465158,-0.014028083322153244,-0.4557890534203818},
{-0.18215258055460815,-0.020038287112394176,-0.4813626461965854},
{-0.169071599486416,-0.029520408927481326,-0.5271218339451404},
{-0.1352037228909625,-0.02877277035221881,-0.5472718681319866},
{-0.09960069548275649,-0.0281997029058011,-0.5657979597807516},
{-0.08579847702854072,-0.01746638024070342,-0.5376521368529891},
{0.2990678224999556,-0.016512812389377674,-0.4509517089920834},
{0.307547453443658,-0.009864561899204571,-0.4826018856914714},
{0.3282998657849748,-0.01651432102876275,-0.4420798318082606},
{0.31617471552718596,-0.007584037948746139,-0.51479840536817},
{0.32480305521027475,-0.009824906235368223,-0.5469992354431116},
{0.3495458187251243,-0.007585331068219064,-0.5046689694969281},
{0.3388323238919448,-0.009865962778633575,-0.4731071559615232},
{0.3568918149308963,-0.016514859828543137,-0.4313156897957248},
{0.3847197459882316,-0.016514752068587064,-0.4187099301338325},
{0.3958448838536254,-0.02737652460132858,-0.3769119983706695},
{0.4116651230052959,-0.01651453654867491,-0.40431320000193965},
{0.3992123824810329,-0.00986639381845788,-0.4480971477556026},
{0.42804786912768855,-0.009866178298545728,-0.43268962923570714},
{0.43760509963216143,-0.01651442878871883,-0.3881761465794027},
{0.42002729559687435,-0.0273764168413725,-0.3618687085023144},
{0.3694296858204601,-0.009866501578413962,-0.46158653905732666},
{0.38218523182129954,-0.00758576210804337,-0.49238110170546295},
{0.41395394447237227,-0.00758576210804337,-0.47799083717093477},
{0.4447140239345639,-0.007585438828175136,-0.4615563662696251},
{0.4558089890122561,-0.009866070538589657,-0.4154200186748004},
{0.3602614687574254,-0.009826199354841149,-0.5362361710301367},
{0.3949418554216998,-0.009826630394665454,-0.5231788971522815},
{0.42869873926239394,-0.009826630394665454,-0.50788883698451},
{0.4613823339405607,-0.009826414874753301,-0.4904263361022254},
{0.47432645986453503,-0.007585331068219064,-0.443133724178694},
{0.48238259418085466,-0.009865962778633575,-0.39637344643818323},
{0.5076576918787248,-0.009865962778633575,-0.3756350428911565},
{0.531524366950668,-0.009865962778633575,-0.3532899383990211},
{0.529234467884031,-0.01651432102876275,-0.3078195473327525},
{0.5486269495796554,-0.016363995890035277,-0.2841931769628611},
{0.566464455109088,-0.015913235993765013,-0.25933618789456986},
{0.582682328498683,-0.015011500681312328,-0.23334448648878733},
{0.597213758575672,-0.013508788093817978,-0.2063139791064221},
{0.6099326661914454,-0.011463935167300033,-0.17830501132287738},
{0.6207151273965141,-0.008936209877600862,-0.1493800839126778},
{0.6286570361593921,-0.006439303935339721,-0.11980428636777288},
{0.6328510536499106,-0.004487340090960182,-0.08984680305844307},
{0.6346172393300132,-0.003070512188459238,-0.05977261571668183},
{0.6352734974625225,-0.002179445111658176,-0.02984864575369199},
{0.6353241446418787,-0.001865324839693599,1.4720979839728616e-17},
{0.6071546145237792,-0.01931640316663407,0.028287096230179574},
{0.5780077016040609,-0.03854595180867004,0.052731364666695764},
{0.5517530659054504,-0.05962455353703198,0.04921472626007758},
{0.5275221621819667,-0.08306622334220737,0.04599464325258341},
{0.5296353349206374,-0.007585223308262983,-0.4006946206768726},
{0.5550936245438386,-0.007585223308262983,-0.3768581183926309},
{0.5516151331616718,-0.009826091594885067,-0.425757431261271},
{0.5786661149356916,-0.009826091594885067,-0.4004306087844839},
{0.5789290492285195,-0.007585223308262983,-0.3513998287694298},
{0.5538694714428035,-0.009865962778633575,-0.3294232633270779},
{0.5746261941823634,-0.009658955903009577,-0.30416001922437613},
{0.593726646397019,-0.009038258556005816,-0.2776219748412831},
{0.6111029393144419,-0.00779675610204222,-0.24993413172684792},
{0.6266893393614253,-0.005727549425450858,-0.2212182586314378},
{0.640824212800051,-0.0024942119433592155,-0.19122758525563627},
{0.6538480810915221,0.0022400062069734654,-0.1597121085013446},
{0.6629807373690515,0.006992004750058862,-0.12724511133489264},
{0.6654408971662904,0.010279114450232945,-0.09439847584318126},
{0.664654249486928,0.012392071668991584,-0.061950875468823156},
{0.6640464833346534,0.013621936047698863,-0.030680983654431063},
{0.6637867818405078,0.014016014207072606,1.2150689367379014e-17},
{0.6352734974625225,-0.002179445111658176,0.02984864575369199},
{0.6056815359242059,-0.019872229020079457,0.0564749455408122},
{0.5744904166377062,-0.03896901739622851,0.07884235634385556},
{0.5480515114142039,-0.059793736668072944,0.07357030825274236},
{0.5238475476797396,-0.08310824972507741,0.06874923557781157},
{0.5026737939101616,-0.007585223308262983,-0.42281666205992857},
{0.5229671488385902,-0.009826091594885067,-0.44926311048035616},
{0.5429221375049368,-0.016435979540694746,-0.4752698982799895},
{0.5732285475520441,-0.016435979540694746,-0.45040321081565127},
{0.6018452814878632,-0.016435979540694746,-0.42361085293621636},
{0.6039918598129179,-0.009826091594885067,-0.3733807046100248},
{0.6010726426027909,-0.007330694292009012,-0.32449971093391783},
{0.49284716351549623,-0.009826199354841149,-0.4708517400808307},
{0.5110585960925162,-0.01643608730065082,-0.4981074657713969},
{0.5286504089220934,-0.027262299047886913,-0.5244364558397007},
{0.5621982384479981,-0.027262299047886913,-0.5003908992406695},
{0.5941070390419709,-0.027262191287930834,-0.47420954031219137},
{0.6242356451615511,-0.027262191287930834,-0.4460012166099041},
{0.6286376393672982,-0.016435979540694746,-0.3949941190003971},
{0.6275190910232186,-0.009542359630534215,-0.34488035142676876},
{0.6214522054960812,-0.006567215003203169,-0.2963366464131829},
{0.6399987715365008,-0.005040148665635407,-0.2670905943338737},
{0.6491712989977785,-0.008691055977525586,-0.31520756992139454},
{0.6688719741677833,-0.006988556431464406,-0.28463499278277693},
{0.686545684563979,-0.00415091350808766,-0.2534395630980341},
{0.6566412191530391,-0.0024950740230078343,-0.23694259142219973},
{0.6875931113370478,0.008686422299414267,-0.17239976572985546},
{0.705372426490199,0.020257869574892354,-0.13405554055896166},
{0.7396347045248945,0.020280843997527984,-0.15964745252769835},
{0.7430873335176029,0.03838582051393955,-0.11351002733331286},
{0.6987398011936571,0.024820307579242626,-0.09448888644632988},
{0.695130920264637,0.027219671364461948,-0.061576409621455434},
{0.6932149482455872,0.028566657884230243,-0.03036341506387202},
{0.6926804588634451,0.028977061676949654,6.272459195345632e-11},
{0.6932149482455872,0.028566657884230243,0.03036341506387202},
{0.6640464833346534,0.013621936047698863,0.030680983654431063},
{0.6346172393300132,-0.003070512188459238,0.05977261571668183},
{0.602644860361955,-0.02071846795515246,0.08446473205217522},
{0.5691853940000334,-0.039507278376833335,0.10464795630549302},
{0.5427303247831197,-0.06000904106031487,0.09762351580865496},
{0.5186847681840885,-0.08316212970311594,0.0912125527417635},
{0.6722254640009009,0.0018272855751983936,-0.20550685703540506},
{0.7200051509259006,0.00860258505358633,-0.1893892004049619},
{0.7513137285645243,0.0031386164806999164,-0.2070758419958868},
{0.7702751704358406,0.015775949809722852,-0.17824143294879194},
{0.7649248886166155,0.03661878353018383,-0.1355081447668802},
{0.7726609758633863,0.056888636012191955,-0.09658395551237972},
{0.7310731760145736,0.04037603914272644,-0.08648684762796091},
{0.7253845279332665,0.04211636243337066,-0.057216010758754016},
{0.7225213459002995,0.0431338319386501,-0.02847546063340225},
{0.7217961213959009,0.04346185324494861,2.5089858333373744e-10},
{0.7225213459002995,0.0431338319386501,0.02847546063340225},
{0.7253845279332665,0.04211636243337066,0.057216010758754016},
{0.695130920264637,0.027219671364461948,0.061576409621455434},
{0.664654249486928,0.012392071668991584,0.061950875468823156},
{0.6328510536499106,-0.004487340090960182,0.08984680305844307},
{0.5976092376144748,-0.02179488215640604,0.11215656228498522},
{0.561883579376253,-0.040130561962782946,0.13004579259333493},
{0.5357140740429434,-0.06025839759867714,0.12127413216866373},
{0.5120241252989666,-0.08322463047764063,0.11328696422423339},
{0.5039130334050477,-0.08328820885172607,0.13488098182251182},
{0.49439782928344483,-0.08334747682756845,0.15589956125533883},
{0.4835237721157105,-0.08339381360868157,0.17625002896048822},
{0.47133612108339706,-0.0834218311972616,0.19584078897529442},
{0.4578962993614684,-0.08343583999155163,0.21459102133269972},
{0.4432635749257669,-0.08344122798935548,0.23242529406345014},
{0.4274982933516957,-0.08344122798935548,0.2492638648000487},
{0.4106597226150971,-0.08344122798935548,0.26502914637411995},
{0.39282652748390745,-0.08344122798935548,0.27966187080982147},
{0.37407737272606295,-0.08344122798935548,0.29309953733262856},
{0.35449092310949976,-0.08344122798935548,0.3052839555662597},
{0.33414584340215425,-0.08344122798935548,0.31615477993531166},
{0.31313265196713114,-0.08344122798935548,0.3256732168555968},
{0.29154402236665655,-0.08344122798935548,0.33380047274292735},
{0.269471550563396,-0.0834401503897947,0.340499909212237},
{0.24700575492045432,-0.08343907279023394,0.34573381027889893},
{0.22424685219698307,-0.08343583999155163,0.3494860119495016},
{0.2275173668639213,-0.06111810652825978,0.3743214490265774},
{0.23113379098986683,-0.04228877836309394,0.4017873066314938},
{0.2350433221963419,-0.027366071885589104,0.4314827177276443},
{0.23917268371321415,-0.016503760553067202,0.4628505633421104},
{0.24344967636991194,-0.009855510062894101,0.4953369573006562},
{0.24779994579674214,-0.007575201632347822,0.5283837030308026},
{0.2521512928231331,-0.009816500958794211,0.5614358367587529},
{0.2564293630793917,-0.016426712184472114,0.5939383947107103},
{0.2605619573949462,-0.027253570491444667,0.6253342579137565},
{0.2644757989996644,-0.04214438002195071,0.6550695401936555},
{0.2680976111234138,-0.060946552678185134,0.6825871225774889},
{0.2713745913877166,-0.08324618246885603,0.7074829052299678},
{0.27425501501365596,-0.10862796252324247,0.7293506331166819},
{0.2766828468240717,-0.13667895668965724,0.7477851288027815},
{0.2786074396396076,-0.16698428913720376,0.762380137253856},
{0.2800072414690484,-0.19898037529559903,0.7729912601287624},
{0.2808628555203001,-0.23210470819412096,0.7794730214867965},
{0.2811548850012689,-0.265791548063365,0.7816821005863759},
{0.2808628555203001,-0.2994783879326091,0.7794719438872357},
{0.2800072414690484,-0.33260164323157027,0.7729891049296408},
{0.2786074396396076,-0.3645977293899655,0.7623769044551738},
{0.2766828468240717,-0.3949019842379512,0.7477808184045384},
{0.27425501501365596,-0.4229519008048052,0.7293463227184389},
{0.2713756689872774,-0.4483326032596309,0.7074785948317247},
{0.2680976111234138,-0.47063029337109247,0.6825838897788066},
{0.2644757989996644,-0.489431172907854,0.6550663073949732},
{0.26056087979538545,-0.5043214436385797,0.6253331803141957},
{0.2564282854798309,-0.5151470088260792,0.5939394723102711},
{0.25214913762401153,-0.5217570045318449,0.561440147156996},
{0.24779886819718136,-0.5239984116182475,0.5283890910286065},
{0.24344752117079038,-0.5217171333480966,0.4953434228980208},
{0.23917160611365337,-0.5150694216577039,0.46285810653903575},
{0.23504116699722036,-0.5042072180851379,0.4314891833250089},
{0.23113163579074528,-0.48928569696714996,0.4017937722288585},
{0.22751628926436052,-0.4704578774413692,0.37432683702438124},
{0.2242457745974223,-0.44814294573693525,0.3494892447481838},
{0.22137504936752989,-0.4227568552843058,0.32768186243687286},
{0.2189558383536003,-0.39471663711349875,0.3093044795274941},
{0.2170398663345505,-0.36444147745365385,0.29475796305665425},
{0.21564868530159592,-0.3324895728772502,0.28418455616637495},
{0.21479845924814803,-0.2994201975563275,0.27772650199867777},
{0.2145085849663008,-0.26579262566292583,0.2755271212951454},
{0.21479845924814803,-0.23216397616996332,0.27772757959823857},
{0.21564868530159592,-0.19909460084904068,0.28418563376593564},
{0.2170398663345505,-0.16714161867307623,0.29475904065621505},
{0.7032409345589951,0.0007399876183810414,-0.22167300564608292},
{0.7337359245292372,-0.00527754384887313,-0.23807083816232638},
{0.7817483729593633,-0.006555361408034694,-0.22185404237229234},
{0.8002917062011006,0.007602464901235301,-0.19263708548112396},
{0.79208039754803,0.033631214179917095,-0.15289090328166782},
{0.7911450411292813,0.056584106376318236,-0.11518138425206778},
{0.7973681785927305,0.07754783599150203,-0.08124831288318768},
{0.7862667479176735,0.07665353611601868,-0.06312147187168807},
{0.7607976822988647,0.057476897612416526,-0.07462139886431782},
{0.7539646234840196,0.05811947023050393,-0.050515712209795706},
{0.7505734176662751,0.05858725619983437,-0.02548824689099057},
{0.7497382780066779,0.05877734476235427,3.7634733620082576e-10},
{0.7505734176662751,0.05858725619983437,0.02548824689099057},
{0.7539646234840196,0.05811947023050393,0.050515712209795706},
{0.7607976822988647,0.057476897612416526,0.07462139886431782},
{0.7310731760145736,0.04037603914272644,0.08648684762796091},
{0.6987398011936571,0.024820307579242626,0.09448888644632988},
{0.6654408971662904,0.010279114450232945,0.09439847584318126},
{0.6286570361593921,-0.006439303935339721,0.11980428636777288},
{0.5901393174592142,-0.023041449328305257,0.1394532367588607},
{0.5804452318105235,-0.024321637606500517,0.16620572345454712},
{0.5527099743154145,-0.04077065610188057,0.15491571285635544},
{0.5270771135633685,-0.06051443525431619,0.14441666033576925},
{0.5168916425149666,-0.06074999851830061,0.1669460343527964},
{0.5052320152674307,-0.060937608601830735,0.18875988226147197},
{0.4921715085908931,-0.06105032551588733,0.20975152170527975},
{0.4777726232598788,-0.061106576212959535,0.22984013271716192},
{0.4620989376484731,-0.061125326445316944,0.24894274013093912},
{0.4452129525312006,-0.061125326445316944,0.26697852397955363},
{0.4271771686825861,-0.061125326445316944,0.2838645090968261},
{0.4080767164679304,-0.061125326445316944,0.2995360395091103},
{0.38799564865297365,-0.06112543420527302,0.3139295368423208},
{0.36701694040389515,-0.061125541965229103,0.3269803451228113},
{0.3452257220859957,-0.06112564972518518,0.338622730777375},
{0.3227200552593055,-0.06112564972518518,0.3488179002218239},
{0.2995969238842938,-0.061125326445316944,0.3575227494737273},
{0.27595546712055163,-0.06112435660571225,0.36469848494889756},
{0.251893746528109,-0.06112252468645895,0.3703030802644645},
{-0.29265933791205384,0.03305827604544668,-0.2078560240778846},
{-0.3399562602338283,0.03215814635633954,-0.23277120352245745},
{-0.3338796763106439,0.017221441860540296,-0.2593394206932521},
{-0.37910114187837457,0.012155107525578168,-0.278504528881554},
{-0.36850402779775826,-0.00011120827467151228,-0.30968918257068917},
{-0.3565049566885796,-0.009693008049129922,-0.3422757932883867},
{-0.34238301444468333,-0.01700678402803484,-0.3731781158925999},
{-0.29685012260389,-0.01436019950678269,-0.3781566258633593},
{-0.25409851522944515,-0.01302634677046106,-0.3781641690602847},
{-0.23554009559385702,-0.014632832195657601,-0.3981342441204821},
{-0.2139051292122693,-0.015203097883217307,-0.41722823073777315},
{-0.1896214231103079,-0.01490255536571844,-0.4365819188492098},
{-0.3933534736691241,-0.020270833097608434,-0.36003355645032237},
{-0.3748801843988368,-0.02835940316070728,-0.3921675753524963},
{-0.3254226749577177,-0.022468920681667937,-0.39930559484303957},
{-0.2796677976074056,-0.01767575783536111,-0.40053944634012173},
{-0.25933780429391096,-0.019692700933255102,-0.4209599580167211},
{-0.23613277535228075,-0.020611031278943658,-0.4406875731757452},
{-0.21032534347138998,-0.020630428071037522,-0.4609949368984637},
{-0.3890129026383409,0.027522238691535507,-0.2518102325621492},
{-0.4250295127579706,0.0031374311211830722,-0.29316203810715324},
{-0.410021783675121,-0.009876846534197356,-0.32594477194491095},
{-0.4300446611137961,-0.0347268312053436,-0.37453804653829226},
{-0.4073827423507942,-0.04353944041332409,-0.4087184270063692},
{-0.3835473176661133,-0.050238445842809475,-0.43695692349635795},
{-0.35445859512267663,-0.03445732355519492,-0.4190870899801021},
{-0.3319744802872018,-0.03882677425420682,-0.44239664607912704},
{-0.30570368059517977,-0.026311425195463096,-0.4220795839603616},
{-0.2833100841228097,-0.02876641251481026,-0.4429192818661007},
{-0.258323783107226,-0.03006578206518723,-0.4632438871817916},
{-0.23082559751548642,-0.030441541032027876,-0.4844747537280904},
{-0.20100949526852968,-0.0301682617834165,-0.5059782529632642},
{-0.18569896070910358,-0.043910242422185185,-0.551593042370676},
{-0.1500972264203705,-0.04339364119275186,-0.572888564890621},
{-0.11274557820490229,-0.042969498005632614,-0.5924362209229963},
{-0.28035746132629874,-0.043429201978257274,-0.4846051432749436},
{-0.2509939508948656,-0.044186646709522805,-0.5067142534632703},
{-0.21938687817790845,-0.04426078555930381,-0.5292888866618498},
{-0.20155368304671875,-0.06212932595608675,-0.5742948323174264},
{-0.16413188309984442,-0.0618671459829513,-0.5966129968205425},
{-0.12502471743992513,-0.06161153936713655,-0.6170841556764982},
{-0.30731361433897075,-0.04172993523087841,-0.46370078939555825},
{-0.3312018414021294,-0.05845934513197094,-0.4829919767324703},
{-0.302116351657375,-0.06056292723455087,-0.5044793119742325},
{-0.27070647966003886,-0.06171638980439952,-0.5274063202291839},
{-0.23713278774467567,-0.062158744424095774,-0.5509518706320176},
{-0.21634265941873201,-0.08384640542420516,-0.5950009078776299},
{-0.17708462982030485,-0.08382808623167205,-0.6181886952262878},
{-0.13626839125700368,-0.08373649026900656,-0.639450812159849},
{0.3332869965522202,-0.016434794181177895,-0.5786634209367897},
{0.3414821412118793,-0.02726100592841399,-0.6092500068696972},
{0.3707982372626385,-0.01643608730065082,-0.5672764263781286},
{0.3492440908481086,-0.042150953379271404,-0.6382180382623276},
{0.3564273695202042,-0.06095194067598899,-0.6650265601351741},
{0.3995367399488248,-0.06095291051559368,-0.6519401910691781},
{0.3906163707847673,-0.042152030978832175,-0.6256586153815484},
{0.3809761651141151,-0.027262191287930834,-0.5972617117561263},
{0.407487269508189,-0.01643651834047513,-0.5534637552081734},
{0.4431967637529991,-0.01643651834047513,-0.5372879082014487},
{0.4777726232598788,-0.0164361950606069,-0.5188146189311613},
{0.4572012476447715,-0.027262622327755146,-0.5656869670259922},
{0.4936047160067178,-0.027262406807842986,-0.5462373725536469},
{0.4196037989694916,-0.02726273008771122,-0.582717350484408},
{0.43108023429169656,-0.04215256977861256,-0.6104235127913762},
{0.4704654206382946,-0.04215256977861256,-0.5925838520628219},
{0.5085995138948382,-0.04215235425870042,-0.5722085995677748},
{0.5453111757311648,-0.042152246498744335,-0.5493710320763673},
{0.6138799133825473,-0.04215213873878825,-0.4967572335217516},
{0.6454417269179522,-0.04215213873878825,-0.4672062207667444},
{0.6321786315239899,-0.060953126035505824,-0.5176227938169492},
{0.6650658925191423,-0.060953126035505824,-0.4868314639674953},
{0.6958572223685962,-0.060953126035505824,-0.45394420297234284},
{0.6749916620733986,-0.04215213873878825,-0.43564548483090043},
{0.6524450464633991,-0.027262191287930834,-0.4158715328907632},
{0.6535323444202165,-0.016137699982273494,-0.3649344792527062},
{0.5804538526070098,-0.04215213873878825,-0.5241821423433588},
{0.5973495361203291,-0.060953126035505824,-0.5462007341685807},
{0.6126342082902967,-0.08325157046665989,-0.5661212396489828},
{0.6487348711756665,-0.08325049286709911,-0.5365012605220862},
{0.6828215004819564,-0.08325049286709911,-0.5045870719303095},
{0.7147356890737331,-0.08325049286709911,-0.4704993650244588},
{0.7246140442473156,-0.06066282071383429,-0.4194416202355956},
{0.7025146324550359,-0.041854182460235236,-0.40258365270690316},
{0.6786759749716726,-0.026960355650959042,-0.38429140016282526},
{0.6764539646773641,-0.015242753547053655,-0.33381232633809577},
{0.6973292233686086,-0.013452752916657913,-0.3020091305010784},
{0.7160826885246963,-0.010469526292621089,-0.2699052843866061},
{0.7028723955092117,-0.026054956499999737,-0.35172957423502554},
{0.7279966292685739,-0.04096042138453224,-0.36853473938524023},
{0.7249761176997345,-0.024243942678168973,-0.3186537333167383},
{0.7514204109210405,-0.03917289923312627,-0.33400952705771675},
{0.7513967037307037,-0.059792120268731784,-0.3838064803604786},
{0.7762677015932848,-0.05805071937852678,-0.3475183151515347},
{0.7727719686181457,-0.03619365972746429,-0.2995209531152595},
{0.7449311063660811,-0.021225586308451023,-0.28553478841602026},
{0.7635746563669702,-0.015747070141494214,-0.2530430064596706},
{0.7925944125385176,-0.03044014015259888,-0.26571988769257376},
{0.8114286976616629,-0.020329670033626502,-0.23326151132260797},
{0.8298200893653316,-0.0042796866555997225,-0.20279669414006746},
{0.8200430285504616,0.027979355347614754,-0.1660677907107685},
{0.8140548077912604,0.05561577541100994,-0.1302979508905552},
{0.813559111993306,0.07914462302065164,-0.09687760139268968},
{0.8166679867261286,0.10095448381095239,-0.06724081171264515},
{0.8067174323819746,0.09886512602257463,-0.05223728526808252},
{0.7794164475098561,0.07626635459383387,-0.04312154730365732},
{-0.4703188670980297,-0.00980270768441635,-0.3026718542309522},
{-0.43851998165925543,0.019086896012181182,-0.26494509360837987},
{-0.45115052611104556,-0.02356117559646483,-0.33799664543256736},
{-0.4647994021477636,-0.05341822662673083,-0.38615133700471505},
{-0.43835726412557907,-0.06272997995126017,-0.42280480846476004},
{-0.41139141271686014,-0.06986476664312112,-0.4526963426809707},
{-0.3834600321016909,-0.07513045689682578,-0.4779121724029985},
{-0.3582495903774669,-0.05511479937520778,-0.46110054165541925},
{-0.3541202288605947,-0.0788351364267984,-0.5005374527809342},
{-0.3229301871736557,-0.0812871064673754,-0.5226584165644294},
{-0.2894491688205188,-0.08279359065333244,-0.5463602189035748},
{-0.2538582105273934,-0.08357485033489101,-0.570766771355464},
{-0.2297727827446137,-0.10873033448151567,-0.613489283541768},
{-0.18873779147047617,-0.10890921600860357,-0.6373591914123936},
{-0.14630407596645859,-0.10895663038927744,-0.6592473936907624},
{-0.4871703690293575,0.006788446193029327,-0.27214561387344777},
{-0.4506343559214365,0.03828635807448045,-0.24455259952036043},
{-0.5013224840609555,0.026451824564636302,-0.2499966325013726},
{-0.534612767291836,-0.009642684149641947,-0.2721089754883816},
{-0.5140047532916625,-0.02722641498251326,-0.30663095501722276},
{-0.49019088059819704,-0.041670128455255646,-0.346254290866751},
{-0.4958396574957556,-0.07670213585620943,-0.39523334610288813},
{-0.46626924794865454,-0.08611475249962688,-0.43439977973864974},
{-0.43669883840155344,-0.09338854953482721,-0.46608336202442163},
{-0.40654221469339324,-0.09882827211759629,-0.49255567283430773},
{-0.37521424026267564,-0.10273780332407137,-0.5160829040446083},
{-0.525445627828362,-0.06470963810435151,-0.351131506478798},
{-0.5551216421324187,-0.04969512014426904,-0.3046363182302367},
{-0.5540461977707697,-0.09359113825225204,-0.3544138747409047},
{-0.5213873878825007,-0.10493610642804303,-0.40214614728523035},
{-0.4895841920454833,-0.11387587238419443,-0.44347532323945826},
{-0.45817216484902556,-0.12086195033666904,-0.47689707361675276},
{-0.4264282369878506,-0.1261637401756595,-0.5047508670635465},
{-0.3936271839575598,-0.13004848659223686,-0.5293740170271507},
{-0.3590448588533155,-0.13278666707615452,-0.5531070697535584},
{-0.3421297785479022,-0.10542210382995049,-0.5389366355294274},
{-0.3067047705871355,-0.10718290151224934,-0.5633852143641866},
{-0.26917305548506254,-0.10822062988927127,-0.5885342329134466},
{-0.24155094594383442,-0.13644942798321316,-0.6295358186012003},
{-0.19886830494127888,-0.13674792306154657,-0.6538669390838356},
{-0.1549604332381274,-0.1368815454070821,-0.676184025987391},
{-0.5804958789898796,-0.030475916458016453,-0.26353128298464906},
{-0.5880239895214219,-0.07939397955901394,-0.3017839121928774},
{-0.5731250979942101,-0.1292284333264906,-0.35789021092395007},
{-0.5396645540327278,-0.1384763927570223,-0.4072507364045998},
{-0.5067665170419676,-0.14619847120950313,-0.45000665417728775},
{-0.47451827258635204,-0.15233863350677299,-0.4849165695480062},
{-0.4420523530194609,-0.15708976997020976,-0.5142197344040362},
{-0.40850344589399545,-0.16064692612031292,-0.5401554006326587},
{-0.37300731636221784,-0.1632019146788996,-0.5649628201211546},
{-0.3346964967777079,-0.1649497811664692,-0.5908823223563655},
{-0.32195819236984075,-0.134647681517605,-0.5782894938892023},
{-0.28268723157668435,-0.13580825624455478,-0.6040538217876623},
{-0.2513840419358645,-0.16667286286414112,-0.6429152947477258},
{-0.20725741752187657,-0.1669756683407176,-0.6674576247442722},
{-0.16206827994096906,-0.16712329948054314,-0.689969757168327},
{0.3629252948716499,-0.08324941526753835,-0.6892822486485555},
{0.3686344173446115,-0.10863119532192478,-0.7105885471641081},
{0.41469856576886466,-0.10863119532192478,-0.6966034600644297},
{0.40760796065899524,-0.08325049286709911,-0.6757163477780166},
{0.4513100108460396,-0.08325157046665989,-0.6592624800846131},
{0.44170105556264977,-0.060953341555417984,-0.6360639167403476},
{0.48274035723503045,-0.060953341555417984,-0.6174742467174971},
{0.5224768410384396,-0.06095323379546191,-0.5962444577707591},
{0.5607305478462288,-0.060953126035505824,-0.5724467490707051},
{0.37344805458257296,-0.1366811118887788,-0.7285510542425903},
{0.3772616794281395,-0.1669853667367645,-0.7427775236438814},
{0.42541098300248337,-0.16698644433632528,-0.7281620408011522},
{0.4206760105324581,-0.1366811118887788,-0.7142146696861007},
{0.4668683933044429,-0.1366811118887788,-0.6968232903748268},
{0.4597508482055543,-0.10863227292148556,-0.6796409653783425},
{0.4938460983083303,-0.08325157046665989,-0.639994999938038},
{0.5350308759214151,-0.08325157046665989,-0.6179904169071061},
{0.503601607131985,-0.10863227292148556,-0.6597775726746613},
{0.5460601074259003,-0.10863227292148556,-0.6370930243208833},
{0.586934536365483,-0.10863227292148556,-0.6116649074853837},
{0.5746800741604018,-0.08325157046665989,-0.5933252405606319},
{0.5118269245793456,-0.13668218948833957,-0.6764577362758267},
{0.5553587140357882,-0.13668218948833957,-0.653198827356158},
{0.5972676385537106,-0.1366811118887788,-0.6271284611824393},
{0.637383437402511,-0.1366811118887788,-0.5983748721024021},
{0.626062176417057,-0.10863227292148556,-0.5836203789163336},
{0.6632781548478242,-0.10863227292148556,-0.5530844401627822},
{0.6984186765245475,-0.10863227292148556,-0.5201842479729005},
{0.7313199463139899,-0.10863227292148556,-0.48504372629617715},
{0.7446326112877477,-0.08297462737954188,-0.43464547243850543},
{0.6755401602498307,-0.1366811118887788,-0.5670673720633392},
{0.7115686239646289,-0.1366811118887788,-0.5333341954129819},
{0.6852525650910545,-0.16698644433632528,-0.5781418627493767},
{0.7219847013190358,-0.16698644433632528,-0.5437502727673889},
{0.7563762913010237,-0.16698644433632528,-0.5070181365394075},
{0.7453018006149862,-0.1366811118887788,-0.49730573169818376},
{0.7622287345155678,-0.10837688182558299,-0.44797430140567474},
{0.77266636386119,-0.08214487571774866,-0.39742949400773825},
{0.7989910435312507,-0.08048515687425006,-0.3592544519678854},
{0.7992863058109018,-0.055148312721547736,-0.3110588116124284},
{0.8206303203110815,-0.04912851829521594,-0.2752307814159335},
{0.8404753938222295,-0.03803495409695271,-0.2408381138343848},
{0.858999330271873,-0.019911022604267192,-0.2086825429409955},
{0.8763777783884176,0.007199550425463242,-0.1795690356076611},
{0.8483095426290305,0.019292394248420098,-0.17497953907833988},
{0.8391984383427166,0.05303621758243771,-0.14181425739650869},
{0.8335270318543818,0.08064097777073746,-0.10973519607193409},
{0.8310604064597784,0.10422467519802238,-0.08017954963881557},
{0.8300216004831957,0.12769996610949383,-0.05429916426766065},
{0.8213846400036208,0.12507062318121398,-0.04221916543146818},
{0.8005093813123761,0.0977012107369865,-0.035685140494736735},
{0.7759789049109984,0.07619038382479955,-0.021873008124561888},
{0.6463501433476816,-0.16698644433632528,-0.6100603617393966},
{0.6528717758894642,-0.1989814528951598,-0.6185593894751928},
{0.6923162302119046,-0.1989814528951598,-0.5861958418665748},
{0.7295602262312518,-0.1989814528951598,-0.5513247200800442},
{0.7644302704182218,-0.1989814528951598,-0.5140807240606969},
{0.7887915636885587,-0.16680864040879817,-0.46812649079164237},
{0.7770618924695727,-0.1364591263792601,-0.4592082768267064},
{0.7913939666278192,-0.10761286373699674,-0.40928847717401673},
{0.819064568149282,-0.10608374996026353,-0.36929552467514415},
{0.8237618246346803,-0.07771928208162063,-0.32052767895291806},
{0.8469388359877306,-0.07163731016063238,-0.2819959514584502},
{0.8684843616057742,-0.0600295154519695,-0.24441035637833874},
{0.8876753321835346,-0.03987042942881297,-0.20943794023309556},
{0.9037897560152954,-0.008134368044431588,-0.17874682714279325},
{0.9164450852569832,0.030514149690432583,-0.15162256859864104},
{0.8914210682567726,0.0403260385231067,-0.15311612158986884},
{0.8653851852689985,0.048166006367535805,-0.14949861986436253},
{0.8559561891122573,0.08123398080902942,-0.11954781767230951},
{0.8487298064577309,0.10785726331737946,-0.0908224617007646},
{0.8425379193815441,0.1317489386991326,-0.06467084452016378},
{0.8389020984635047,0.15407680159829565,-0.043091590035867905},
{0.8317834757650553,0.15182677371540704,-0.03360138622407498},
{0.8274569135285621,0.15092159008435987,-0.022942633448582606},
{0.816009573394498,0.12356844939350002,-0.028857900717519668},
{0.7973444714023935,0.09720713133837326,-0.018100655342172884},
{0.7751125148641389,0.07623025500854805,2.5089858333373744e-10},
{0.8071743345957413,-0.13579101465158241,-0.41926920430587233},
{0.8359613292621623,-0.1344558687957879,-0.3777158876430042},
{0.8195969023323026,-0.16627415102665605,-0.42725637225030266},
{0.8491576134833567,-0.16520732746149336,-0.3845920504402803},
{0.8637483115361883,-0.1322295481032362,-0.3347746227458638},
{0.845486231779812,-0.10353630459860225,-0.32830687018211974},
{0.8707764158715329,-0.09779162134013515,-0.2864378168479459},
{0.8950504235774475,-0.0866718714725452,-0.24380690062430732},
{0.9156929207635656,-0.06473657809337077,-0.20420403916643365},
{0.9300885732958976,-0.02654440222050166,-0.17142561572691903},
{0.9395940790214534,0.019728186286791266,-0.14397484451585338},
{0.9455639805881215,0.06590448049733375,-0.12036140534069119},
{0.925256616865403,0.07141090649291451,-0.1273485608927266},
{0.9029384523622869,0.07649793073944343,-0.12894233064310603},
{0.8795308347032318,0.08012060494284143,-0.12604143262551207},
{0.868509146395672,0.11103370354266243,-0.09893861831261919},
{0.8578947907220833,0.13641494479726848,-0.07317579905354431},
{0.8494517981634472,0.1585606933706614,-0.050895350535055124},
{0.8447825592666289,0.1763777245084395,-0.03428630850490065},
{0.8394268894495999,0.17568913838910719,-0.026917790468308604},
{0.8363891362877881,0.17681522993011228,-0.01824214416450204},
{0.8252833952144882,0.1504733086670794,-0.01163387261803352},
{0.8132789361075057,0.1229010919855149,-0.014642530591704532},
{0.7965222629375257,0.09712760449078842,6.272459195345632e-11},
{0.7973444714023935,0.09720713133837326,0.018100655342172884},
{0.7759789049109984,0.07619038382479955,0.021873008124561888},
{0.7794164475098561,0.07626635459383387,0.04312154730365732},
{0.7862667479176735,0.07665353611601868,0.06312147187168807},
{0.7726609758633863,0.056888636012191955,0.09658395551237972},
{0.7430873335176029,0.03838582051393955,0.11351002733331286},
{0.705372426490199,0.020257880350887963,0.13405554055896166},
{0.6629807373690515,0.006992004750058862,0.12724511133489264},
{0.6538480810915221,0.0022400062069734654,0.1597121085013446},
{0.6207151273965141,-0.008936209877600862,0.1493800839126778},
{0.6099326661914454,-0.011463935167300033,0.17830501132287738},
{0.5687381901823138,-0.02549923840651043,0.192270701630462},
{0.5417895803665671,-0.04135945650188553,0.17913368538510982},
{0.5292506318774425,-0.04182875111060105,0.20257901902879183},
{0.5152159751979686,-0.042110327875830356,0.2251299450370344},
{0.49975349910047384,-0.042251062378466986,0.24670133304453665},
{0.4829278595586045,-0.042297937959360495,0.2672091302855585},
{0.464802634946446,-0.042297937959360495,0.2865682063947991},
{0.44544355883720543,-0.042297937959360495,0.3046934310069575},
{0.42494222719354824,-0.042298045719316564,0.3215147601505838},
{0.4033870031794575,-0.042298045719316564,0.3369643050533493},
{0.3808684051580381,-0.04229815347927264,0.35097309934336474},
{0.35747910669151617,-0.0422983689991848,0.36347002144961926},
{0.3333214797381649,-0.0422983689991848,0.3744119673896821},
{0.3085022066545006,-0.042297937959360495,0.38375691078068314},
{0.28312581459791797,-0.042296644839887564,0.39145851484150934},
{0.2572989859249334,-0.042294274120853875,0.3974736755897298},
{0.7973013674199626,-0.19885429614698888,-0.4746276489417703},
{0.8285452890849403,-0.1984706707033546,-0.4331271346573799},
{0.8585359624607417,-0.19770341981608608,-0.3897451315398844},
{0.8778368481937007,-0.1634271329871006,-0.34031240688866293},
{0.8907281717391973,-0.1273695740841616,-0.2900046713940959},
{0.9170948777921278,-0.11813239064923758,-0.24296314016822407},
{0.9450855263831395,-0.09921620795947364,-0.1888978150052506},
{0.9548065520208494,-0.15027934074614072,-0.19639251995040888},
{0.9703423048884766,-0.10410096676844596,-0.13833684361390253},
{0.9534864925589056,-0.042611411671588606,-0.15383703569602425},
{0.9596719140377278,0.010279545490057253,-0.12846172123900243},
{0.962938118306423,0.06102381656669236,-0.10708052955397615},
{0.9468538672623636,0.10908497249696521,-0.09949864680435157},
{0.929217872850795,0.11121075315049701,-0.10531186539488367},
{0.9097413383894306,0.11274439284538547,-0.10666630028281601},
{0.8892346187479694,0.11293555900746614,-0.10429687436859401},
{0.8750555637273523,0.14089668137051267,-0.07965594401223722},
{0.8625241584351531,0.16397778636265425,-0.0571607299012865},
{0.853263267809892,0.1815060208181459,-0.03939703994176652},
{0.8484313113793975,0.19067639308030218,-0.028755636519202557},
{0.8462836554547821,0.19530899359205423,-0.02262452605824318},
{0.8444592793983978,0.1988241233592873,-0.015039518269892353},
{0.8348600225110548,0.17712557860361416,-0.00921015723793991},
{0.8247348970380559,0.15036339351188077,-8.41202234725969e-18},
{0.8125741859947618,0.12277598267650947,-4.673344551144761e-18},
{0.8132789361075057,0.1229010919855149,0.014642530591704532},
{0.816009573394498,0.12356844939350002,0.028857900717519668},
{0.8005093813123761,0.0977012107369865,0.035685140494736735},
{0.8067174323819746,0.09886512602257463,0.05223728526808252},
{0.7973681785927305,0.07754783599150203,0.08124831288318768},
{0.7911450411292813,0.056584106376318236,0.11518138425206778},
{0.7649248886166155,0.03661878353018383,0.1355081447668802},
{0.7396347045248945,0.020280843997527984,0.15964745252769835},
{0.6875931113370478,0.008686422299414267,0.17239976572985546},
{0.6722254640009009,0.0018272855751983936,0.20550685703540506},
{0.640824212800051,-0.0024942119433592155,0.19122758525563627},
{0.597213758575672,-0.013508788093817978,0.2063139791064221},
{0.555232634887178,-0.02643771986398539,0.21749946254721905},
{0.540137620239906,-0.027000873394444007,0.24174868546323583},
{0.5235210350128261,-0.027282450159673316,0.26493000721452903},
{0.5054464575800239,-0.02737630908141642,0.2869582974357979},
{0.48598177671382786,-0.02737630908141642,0.3077473481621809},
{0.4651927259874449,-0.02737630908141642,0.327212029028377},
{0.4431752117617837,-0.02737630908141642,0.34527798566469303},
{0.42002729559687435,-0.0273764168413725,0.3618687085023144},
{0.3958448838536254,-0.02737652460132858,0.3769119983706695},
{0.37072603809206695,-0.027376740121240733,0.3903335009000651},
{0.3447839062660798,-0.027376740121240733,0.40208472411026647},
{0.31812948113042355,-0.027376201321460347,0.4121193312201606},
{0.29087806583810044,-0.027374800442031343,0.42038990784907354},
{0.2631417307434306,-0.027372214203085495,0.4268501172158922},
{0.2693152986270843,-0.016510226150431826,0.457881751767398},
{0.2757065416220137,-0.009862083420214803,0.4900190034682542},
{0.28220985497126316,-0.007581559469756363,0.5227101413433464},
{0.2887131683205126,-0.009822643276290607,0.5554066672162424},
{0.29510764411412427,-0.01643253122210028,0.5875579277113887},
{0.30128552239602113,-0.027258742969336374,0.6186165022519138},
{0.30713581041144367,-0.04214879818014986,0.6480306598627031},
{0.3125496706047543,-0.060950000996779594,0.6752519023673246},
{0.3174484382080166,-0.08324833766797757,0.6998804403287325},
{0.32175129325417295,-0.10863011772236401,0.7215143291107594},
{0.32537957097528686,-0.13668003428921802,0.7397527016767989},
{0.32825460660342237,-0.16698428913720376,0.7541946909902439},
{0.33034514975131696,-0.19898037529559903,0.7646958987099517},
{0.3316231828303907,-0.23210470819412096,0.7711119264947788},
{0.3320596106525027,-0.265791548063365,0.773298376003582},
{0.3316231828303907,-0.2994783879326091,0.7711108488952181},
{0.33034514975131696,-0.33260164323157027,0.7646937435108302},
{0.32825460660342237,-0.3645977293899655,0.7541914581915616},
{0.32538064857484766,-0.3949019842379512,0.7397494688781164},
{0.32175129325417295,-0.4229519008048052,0.7215100187125163},
{0.3174484382080166,-0.4483326032596309,0.6998772075300502},
{0.3125496706047543,-0.47063029337109247,0.6752486695686424},
{0.30713581041144367,-0.489431172907854,0.6480274270640207},
{0.30128552239602113,-0.5043214436385797,0.6186143470527922},
{0.29510764411412427,-0.5151470088260792,0.5875579277113887},
{0.2887131683205126,-0.5217570045318449,0.5554066672162424},
{0.28220877737170236,-0.5239984116182475,0.5227112189429072},
{0.2757065416220137,-0.5217171333480966,0.4900211586673758},
{0.26931422102752356,-0.5150694216577039,0.4578849845660803},
{0.2631417307434306,-0.5042072180851379,0.42685335001457453},
{0.2572979083253726,-0.48928569696714996,0.39747690838841215},
{0.251893746528109,-0.4704578774413692,0.370305235463586},
{0.24700575492045432,-0.44814294573693525,0.34573488787845974},
{0.24271475346946653,-0.422755777684745,0.3241613446718359},
{0.239098329343521,-0.39471663711349875,0.3059811624820782},
{0.23623622491011476,-0.36444147745365385,0.29159089794754994},
{0.2341553801582671,-0.3324895728772502,0.2811317166107123},
{0.23288489027611878,-0.2994201975563275,0.2747426288149045},
{0.23245169525268905,-0.265791548063365,0.27256587770214824},
{0.23288489027611878,-0.23216397616996332,0.2747426288149045},
{0.2341553801582671,-0.19909460084904068,0.2811317166107123},
{0.23623622491011476,-0.167142696272637,0.29159197554711075},
{0.255183657987141,-0.16714161867307623,0.28717705014663436},
{0.27379919039945005,-0.16714161867307623,0.2815261180499543},
{0.2920073901777878,-0.16714161867307623,0.27467150724389366},
{0.3097295925542181,-0.16714161867307623,0.26664339051615404},
{0.32688821036036547,-0.16714161867307623,0.2574751734531193},
{0.34340781162697603,-0.16714161867307623,0.24719918404161256},
{0.3592205075817212,-0.16714161867307623,0.2358649918614293},
{0.3742605646513939,-0.16714161867307623,0.22352432169148648},
{0.3884622492627873,-0.16714161867307623,0.2102278207111403},
{0.4017598278426942,-0.16714161867307623,0.19602613609974692},
{0.41410049801263704,-0.16714161867307623,0.1809860790300742},
{0.4254336125932595,-0.16714161867307623,0.16517230547576828},
{0.435710679604327,-0.16714161867307623,0.14865378180871852},
{0.444877819067801,-0.16714161867307623,0.13149408640301039},
{0.4529059357955406,-0.16714161867307623,0.11377296162614084},
{0.45976054660160126,-0.16714161867307623,0.09556486960775915},
{0.4654114786982813,-0.16714161867307623,0.07694879839566977},
{0.46982640409875776,-0.16714161867307623,0.058001473078599576},
{0.47299346920786195,-0.16714161867307623,0.03880565330281571},
{0.4749018980299864,-0.16714161867307623,0.019444206474541443},
{0.475541992169084,-0.16714161867307623,2.5089858333373744e-10},
{0.9315379447051338,-0.15458004059317546,-0.24581877900426566},
{0.9615480148730292,-0.19143933356932763,-0.2005876150404881},
{0.9783628784192908,-0.19220335165791388,-0.15083268812059633},
{0.9736893291242295,-0.15079982133399283,-0.14692638971280356},
{0.9874502755152678,-0.15341838826666496,-0.09763245988500935},
{0.9850677028864043,-0.10753635416818205,-0.09200501945875407},
{0.9721925433343194,-0.05091668700635838,-0.1222148765852163},
{0.9754835323929122,0.004479581374122629,-0.10336776802729775},
{0.9764566047962879,0.05781364747515729,-0.08660527581968958},
{0.9618389667544373,0.1071178144987788,-0.08849182937073034},
{0.9423160955119595,0.14636980953966564,-0.08030196494891909},
{0.9273169872255961,0.1465680878588474,-0.08489922019507784},
{0.9106379012239915,0.14609502165166915,-0.08590839218373934},
{0.892982510020329,0.1443902591465304,-0.08395287226080926},
{0.8772129180480146,0.16902526270530294,-0.06203589807416794},
{0.8641190057850933,0.1882097676856987,-0.043142344975180186},
{0.854657681641529,0.19896852170043053,-0.029662436549590863},
{0.8543171601803256,0.2093339518754812,-0.021177740887952812},
{0.8533182253874914,0.21452690415883385,-0.013618272209192248},
{0.8435109917849197,0.20005797485636945,-0.00750674173225207},
{0.8344731642687383,0.17707708662337948,-1.1683334437872883e-17},
{0.8348600225110548,0.17712557860361416,0.00921015723793991},
{0.8252833952144882,0.1504733086670794,0.01163387261803352},
{0.8274569135285621,0.15092159008435987,0.022942633448582606},
{0.8213846400036208,0.12507062318121398,0.04221916543146818},
{0.8166679867261286,0.10095448381095239,0.06724081171264515},
{0.813559111993306,0.07914462302065164,0.09687760139268968},
{0.8140548077912604,0.05561577541100994,0.1302979508905552},
{0.79208039754803,0.033631224955912704,0.15289090328166782},
{0.7702751704358406,0.015775949809722852,0.17824143294879194},
{0.7513137285645243,0.0031386164806999164,0.2070758419958868},
{0.7200051509259006,0.00860258505358633,0.1893892004049619},
{0.7032409345589951,0.0007399876183810414,0.22167300564608292},
{0.6566412191530391,-0.0024950740230078343,0.23694259142219973},
{0.6266893393614253,-0.005727549425450858,0.2212182586314378},
{0.582682328498683,-0.015011500681312328,0.23334448648878733},
{0.566464455109088,-0.015913128233808933,0.25933618789456986},
{0.5486269495796554,-0.016363995890035277,0.2841931769628611},
{0.529234467884031,-0.01651432102876275,0.3078195473327525},
{0.5083548987945433,-0.01651432102876275,0.3301204702428963},
{0.48605397588439947,-0.01651432102876275,0.351000039332384},
{0.4624362263109942,-0.01651432102876275,0.3703785122337184},
{0.43760509963216143,-0.01651442878871883,0.3881761465794027},
{0.4116651230052959,-0.01651453654867491,0.40431320000193965},
{0.3847197459882316,-0.016514752068587064,0.4187099301338325},
{0.3568918149308963,-0.016514752068587064,0.4313156897957248},
{0.3282998657849748,-0.016514213268806678,0.4420798318082606},
{0.2990678224999556,-0.016512812389377674,0.4509517089920834},
{0.307547453443658,-0.009864561899204571,0.4826018856914714},
{0.31617471552718596,-0.007584037948746139,0.51479840536817},
{0.32480305521027475,-0.009824906235368223,0.5469992354431116},
{0.3332869965522202,-0.016434794181177895,0.5786634209367897},
{0.3414821412118793,-0.02726100592841399,0.6092500068696972},
{0.3492440908481086,-0.042150953379271404,0.6382180382623276},
{0.3564273695202042,-0.06095194067598899,0.6650265601351741},
{0.3629252948716499,-0.08324941526753835,0.6892822486485555},
{0.3686344173446115,-0.10863119532192478,0.7105885471641081},
{0.37344805458257296,-0.1366811118887788,0.7285510542425903},
{0.3772616794281395,-0.1669853667367645,0.7427775236438814},
{0.38003434309800177,-0.1989814528951598,0.7531235570268382},
{0.38172940720709364,-0.23210470819412096,0.7594447560503175},
{0.3823070005716666,-0.265791548063365,0.7615999551718583},
{0.38172940720709364,-0.2994783879326091,0.7594447560503175},
{0.38003434309800177,-0.33260164323157027,0.7531224794272774},
{0.3772616794281395,-0.3645977293899655,0.7427764460443206},
{0.37344913218213377,-0.3949019842379512,0.7285499766430295},
{0.3686344173446115,-0.4229519008048052,0.7105863919649866},
{0.3629263724712106,-0.4483326032596309,0.6892800934494339},
{0.3564273695202042,-0.47063029337109247,0.6650254825356133},
{0.3492440908481086,-0.489431172907854,0.6382169606627668},
{0.3414821412118793,-0.5043214436385797,0.6092489292701364},
{0.3332869965522202,-0.5151470088260792,0.5786623433372289},
{0.32480305521027475,-0.5217570045318449,0.5469992354431116},
{0.31617471552718596,-0.5239984116182475,0.51479840536817},
{0.307547453443658,-0.5217171333480966,0.4826029632910322},
{0.2990667449003948,-0.5150694216577039,0.4509527865916442},
{0.29087806583810044,-0.5042072180851379,0.42039098544863435},
{0.28312581459791797,-0.48928569696714996,0.3914595924410701},
{0.27595546712055163,-0.4704578774413692,0.36469848494889756},
{0.269471550563396,-0.44814294573693525,0.340499909212237},
{0.2637785920838459,-0.422755777684745,0.31925395627208747},
{0.258981118839296,-0.39471663711349875,0.3013496395698869},
{0.255183657987141,-0.36444147745365385,0.28717705014663436},
{0.25242284791244723,-0.3324895728772502,0.2768751983456692},
{0.2507374821994023,-0.2994201975563275,0.2705830945103307},
{0.2501631216335117,-0.265791548063365,0.26843974898395834},
{0.2507374821994023,-0.23216289857040256,0.2705830945103307},
{0.25242284791244723,-0.1990935232494799,0.2768751983456692},
{0.27037134619663933,-0.1990935232494799,0.2714279325659747},
{0.28792544304158946,-0.1990935232494799,0.26481793686020894},
{0.3050118616771652,-0.1990935232494799,0.2570786168147558},
{0.3215562477336734,-0.1990935232494799,0.24823906761775605},
{0.33748209164229953,-0.1990935232494799,0.2383316172560328},
{0.3527279702280794,-0.1990935232494799,0.22740475770982074},
{0.3672292275173669,-0.1990935232494799,0.21550590335979378},
{0.38092120753651587,-0.1990935232494799,0.2026867789848689},
{0.3937414095110015,-0.1990935232494799,0.18899479896571997},
{0.4056391862614677,-0.1990935232494799,0.1744935416764324},
{0.41656604580767975,-0.1990935232494799,0.15924766309065252},
{0.4264745737689638,-0.1990935232494799,0.14332074158246574},
{0.43531304536640275,-0.1990935232494799,0.12677743312551826},
{0.44305236541185594,-0.1990935232494799,0.10969101448994249},
{0.44966236111762165,-0.1990935232494799,0.0921368098850363},
{0.4551096268973161,-0.1990935232494799,0.07418852712075634},
{0.45936614516235924,-0.1990935232494799,0.05592084384666405},
{0.4624189847180219,-0.1990935232494799,0.037413610190212485},
{0.46425952476781773,-0.1990935232494799,0.018746784038810825},
{0.4648769893161392,-0.1990935232494799,3.7634733620082576e-10},
{-0.6400655827092684,-0.11025621545956658,-0.2448532497978154},
{-0.6276731877604087,-0.0595156082214381,-0.24084350183218867},
{-0.5971922065844565,-0.005869146007736091,-0.23559882476991903},
{-0.6397164404515788,-0.02104110126364713,-0.21017070793441944},
{-0.670454967922555,-0.06518054911240818,-0.1786207479941831},
{-0.6707297558105515,-0.10841352021064918,-0.18471996150814368},
{-0.6717965793757142,-0.1552459971217316,-0.18709930133832478},
{-0.6455570300709544,-0.15731067788016773,-0.24723690002623955},
{-0.607060863361992,-0.11850847289594645,-0.3031675500289066},
{-0.6158799381673372,-0.16242173259690182,-0.3053173611526436},
{-0.5839765255711682,-0.16905435789344372,-0.3599344172907315},
{-0.5510590917883141,-0.1756815951921818,-0.4096850338123802},
{-0.5180101908590462,-0.18174848071931926,-0.45329548803675906},
{-0.48571237682363516,-0.18670005070105936,-0.489494212482159},
{-0.45318287888265857,-0.1906354442969929,-0.5202941631280992},
{-0.4194410814358152,-0.19365380066671084,-0.5477115287527808},
{-0.3835052912832433,-0.1958564141689256,-0.573761420534845},
{-0.3443938152250809,-0.19734134636366724,-0.6004567944538105},
{-0.3026680826324895,-0.19825838358988285,-0.6271273835828785},
{-0.29400957016169915,-0.16605216551713733,-0.6171283372584897},
{-0.2588906004761912,-0.19875731218651957,-0.6531007657961279},
{-0.2136206429282259,-0.19898684089296365,-0.6777045189676381},
{-0.16742071695931574,-0.199097833647723,-0.7002694537701707},
{-0.5878957551736902,-0.21050638019759943,-0.3589236289027289},
{-0.5559589369911373,-0.21490837440334662,-0.40859019265863744},
{-0.5235081038180969,-0.21919291025696977,-0.45264785070073604},
{-0.4917318479700988,-0.22282873117500918,-0.4899834426827488},
{-0.4595881306718779,-0.22582445795395095,-0.5223081967071791},
{-0.42603383554860863,-0.22818978898984202,-0.5513290304782872},
{-0.3900280014245866,-0.22993657787785085,-0.5787582496981375},
{-0.35052643432542535,-0.23107344541446365,-0.6063038496705508},
{-0.30819293558055944,-0.2317350915447767,-0.6334205650177777},
{-0.2636880737207411,-0.23205729381344703,-0.6595631303620682},
{-0.5234531462404975,-0.2571987691657817,-0.4473665352534002},
{-0.5547552582817566,-0.2545133910603418,-0.40310521089431606},
{-0.5852642570462888,-0.251846332147435,-0.3538449021728179},
{-0.5478349139024891,-0.2928543834325533,-0.39237016406992115},
{-0.518039286047187,-0.2944341443886427,-0.4367554123784939},
{-0.4881542174283409,-0.29591692138426284,-0.47611258113651195},
{-0.49255297883540583,-0.25960612658454285,-0.4857387780128741},
{-0.6454557357122421,-0.20348366386005862,-0.24721534803502415},
{-0.6181245780524219,-0.20652033942230966,-0.30476131977928606},
{-0.6391183726953512,-0.24775791941387204,-0.24387909979487893},
{-0.6137840070216387,-0.24949608750539476,-0.30047355112698054},
{-0.5764635014334768,-0.2913360456514278,-0.34368421591431364},
{-0.536222701035627,-0.3294561301136814,-0.3781092114826854},
{-0.5081296804863422,-0.33032359776010156,-0.42246536460311734},
{-0.4793394530212389,-0.33114365102584786,-0.4626339658303955},
{-0.4491688205187887,-0.33187103072936786,-0.49934023966891833},
{-0.45729499880655844,-0.29723805844576734,-0.5114783211214363},
{-0.4610353468819926,-0.2616826609381474,-0.5195915682144768},
{-0.39206466459444267,-0.2646320509359761,-0.5792119191132218},
{-0.42787976359620833,-0.2633755698481178,-0.5502934573003868},
{-0.42457368814376467,-0.2983307444003886,-0.5438882055111675},
{-0.3891044986010063,-0.2991292456749195,-0.5743778074836057},
{-0.3500037985384517,-0.2995656734970315,-0.6039837778162123},
{-0.3525717182917676,-0.2653982242236838,-0.6077155050951601},
{-0.21913471988068814,-0.26593271360582593,-0.6864740241931878},
{-0.26539499142500145,-0.2659316360062652,-0.6617732870612083},
{-0.31011106279873074,-0.265791548063365,-0.6353785634196976},
{-0.3079504756793861,-0.2997359342276332,-0.6323709830455874},
{-0.2636288057448987,-0.2997337790285117,-0.6592042897083316},
{-0.21771875405783583,-0.2996540366610147,-0.6841464091419236},
{-0.17204254147546008,-0.26591439441329284,-0.7090529677900104},
{-0.21767349487628346,-0.232174752165571,-0.6841852027261114},
{-0.170813000376621,-0.23222216654624492,-0.7067425943317186},
{0.38003434309800177,-0.1989814528951598,-0.7531235570268382},
{0.38172940720709364,-0.23210470819412096,-0.7594447560503175},
{0.42885499119870557,-0.1989814528951598,-0.7383054854666842},
{0.4766045053360037,-0.1989814528951598,-0.720328969593912},
{0.472505316606833,-0.16698644433632528,-0.7104312176282357},
{0.5183420915237635,-0.16698644433632528,-0.6896680292913113},
{0.5627241070336539,-0.16698644433632528,-0.6659554509565582},
{0.6054509296182011,-0.16698644433632528,-0.639375380190595},
{0.3823070005716666,-0.265791548063365,-0.7615999551718583},
{0.38172940720709364,-0.2994783879326091,-0.7594447560503175},
{0.4316772244483634,-0.265791548063365,-0.7466180884784672},
{0.43095954314089024,-0.23210470819412096,-0.7445049157397963},
{0.4791099243147949,-0.23210470819412096,-0.7263775359285163},
{0.523080296792471,-0.1989814528951598,-0.6992769845747011},
{0.5680808544502438,-0.1989814528951598,-0.6752335831747914},
{0.5259758068122612,-0.23210470819412096,-0.7051488245813391},
{0.5713535243163035,-0.23210470819412096,-0.6809028344640047},
{0.6150394105099363,-0.23210470819412096,-0.6537268511409355},
{0.6114025119923361,-0.1989814528951598,-0.6482828181599233},
{0.4799644607664858,-0.265791548063365,-0.728440061487831},
{0.5269628880099269,-0.265791548063365,-0.7071510045652506},
{0.5724699174612616,-0.265791548063365,-0.6828360480760268},
{0.6162797276043831,-0.265791548063365,-0.6555824775845822},
{0.6582166697108854,-0.265791548063365,-0.625523915436452},
{0.656857816664754,-0.23210470819412096,-0.6237534193581062},
{0.6966320164527902,-0.23210470819412096,-0.5911183166601741},
{0.7341895939443216,-0.23210470819412096,-0.5559540877931138},
{0.7693527452118211,-0.23210470819412096,-0.5183975879011432},
{0.8024727677120999,-0.23202604342618469,-0.4786104569183778},
{0.6981040174528025,-0.265791548063365,-0.5927961391762937},
{0.7357671997012893,-0.265791548063365,-0.5575327711496424},
{0.7341895939443216,-0.2994783879326091,-0.5559540877931138},
{0.7710305677279407,-0.265791548063365,-0.5198695889011555},
{0.8041904614119679,-0.2657516768796165,-0.4799757755618739},
{0.835544298232144,-0.2656331409279317,-0.4380205142628384},
{0.8338998813024084,-0.23178789392325444,-0.4367564899780547},
{0.8639843058399971,-0.23131159491739392,-0.392999482213411},
{0.8930773387816767,-0.23051740404110613,-0.34750215115812316},
{0.8876483921945154,-0.19642538673701238,-0.3446454347225208},
{0.9053824481661141,-0.16014799752367623,-0.2941448089065759},
{0.9400940852176509,-0.1926677970686059,-0.2497778797905362},
{0.9648831855136136,-0.22889992710038973,-0.20296695487066918},
{0.9804889823526909,-0.22950338285442115,-0.15290814487464013},
{0.9914438594874829,-0.23045382566702066,-0.1022635517573763},
{0.9903910447166102,-0.19385531178457494,-0.1007066359119752},
{0.9974881154238442,-0.19529067439952114,-0.05039868489749604},
{0.9953501578952757,-0.15540979225496868,-0.048720646861464344},
{0.9933781506990659,-0.10986504681900693,-0.04593656063625789},
{0.9856916330320904,-0.054604879263051215,-0.08278863369535291},
{0.9868608285555263,0.0012602526863210017,-0.07176963938669499},
{0.9861162072590339,0.055944551037001,-0.06073448108462551},
{0.9733638940568767,0.10605950397014617,-0.07155638243361853},
{0.9549315535698988,0.146058383266603,-0.07149345061926954},
{0.9344097475345869,0.1768357043217669,-0.06332578474841014},
{0.9217199351069545,0.17671393557139986,-0.06646289258972497},
{0.9075775184714036,0.17555874884225398,-0.06699156293423894},
{0.8925525477955816,0.17308996824852896,-0.06536481863729993},
{0.8765997638979363,0.1936225502794485,-0.04641415276159133},
{0.8639864610391185,0.20715827836228576,-0.03122139983415743},
{0.8634336524644433,0.21887394078698175,-0.021498757797106322},
{0.8627817047301772,0.22508414705570165,-0.013421718049307722},
{0.8527363216246754,0.21647197136602447,-0.006659037261776412},
{0.8432556006890172,0.20010431163748257,-1.509059648907287e-17},
{0.8435109917849197,0.20005797485636945,0.00750674173225207},
{0.8444592793983978,0.1988241233592873,0.015039518269892353},
{0.8363891362877881,0.17681522993011228,0.01824214416450204},
{0.8394268894495999,0.17568913838910719,0.026917790468308604},
{0.8317834757650553,0.15182677371540704,0.03360138622407498},
{0.8300216004831957,0.12769996610949383,0.05429916426766065},
{0.8310604064597784,0.10422467519802238,0.08017954963881557},
{0.8335270318543818,0.08064097777073746,0.10973519607193409},
{0.8391984383427166,0.05303621758243771,0.14181425739650869},
{0.8200430285504616,0.02797937043400861,0.1660677907107685},
{0.8002917062011006,0.007602572661191378,0.19263708548112396},
{0.7817483729593633,-0.006555253648078617,0.22185404237229234},
{0.7337359245292372,-0.00527754384887313,0.23807083816232638},
{0.6966320164527902,-0.2994783879326091,-0.5911183166601741},
{0.7295602262312518,-0.33260164323157027,-0.5513247200800442},
{0.7693527452118211,-0.2994783879326091,-0.5183975879011432},
{0.8023380677670037,-0.2994622239391975,-0.4786201553144247},
{0.8333589263229018,-0.2994148095585236,-0.43679528356224245},
{0.8626319183912301,-0.2993199807971758,-0.39309538857431964},
{0.8653884180676809,-0.2653949914250015,-0.3941751433342116},
{0.8940191607977901,-0.264998434786638,-0.3486088459070344},
{0.9205410411874717,-0.26457601575881595,-0.3015436074908256},
{0.9202253045161659,-0.22967364358502287,-0.3005037239146821},
{0.9150959306068988,-0.1947195466323128,-0.29794873535609545},
{0.9444777602308649,-0.22904540304109372,-0.2522455827847005},
{0.9636676532090646,-0.26418915751649935,-0.20380748252807013},
{0.9784771039727324,-0.2644908853935151,-0.15358272219968244},
{0.9887347741917061,-0.26496610679981486,-0.10273457052538906},
{0.9946895893645235,-0.2654122330179738,-0.051471111980374754},
{0.9978986808564977,-0.23134607810333857,-0.051229298638937874},
{1.0,-0.23177819552720752,4.673344551144761e-17},
{0.9998027992803791,-0.1959544757289557,4.252746666580459e-17},
{0.9978351024824124,-0.15624924231280884,3.7386777961149303e-17},
{0.9959299064589702,-0.11075406645664251,3.244027269734485e-17},
{0.9959223632620448,-0.057560734858244485,2.4301378734758027e-17},
{0.9934665138630491,-0.0568208549998195,-0.04178801784720393},
{0.9936367745936507,-0.0004465572579832641,-0.03674215790389644},
{0.9919147704955397,0.055086781786627737,-0.031266551255753706},
{0.981501925939815,0.10564484365916171,-0.050174544188855794},
{0.9644596888862309,0.14619092801257774,-0.05785039362017957},
{0.9448355232850407,0.176891739498927,-0.05678163037580746},
{0.9341672876334136,0.19866356102473254,-0.045052282436689677},
{0.9255906727292418,0.1995568910606112,-0.04912442341688501},
{0.9145916140124581,0.20087910572167653,-0.05035536539515306},
{0.9025128005357825,0.2001474156199134,-0.05023920016250202},
{0.88972492654812,0.19763768624287908,-0.048888105833208066},
{0.8748357334169551,0.21289326322470592,-0.03312659585759953},
{0.8735372259462267,0.2250388878741493,-0.022508899625372513},
{0.8726643703020027,0.23165858197596198,-0.013893491137013013},
{0.8623528201049906,0.22751952206304282,-0.0064376013280336986},
{0.8525498969006621,0.21663361130014003,-1.7525001656809324e-17},
{0.8527363216246754,0.21647197136602447,0.006659037261776412},
{0.8533182253874914,0.21452690415883385,0.013618272209192248},
{0.8543171601803256,0.2093339518754812,0.021177740887952812},
{0.8462836554547821,0.19530899359205423,0.02262452605824318},
{0.8484313113793975,0.19067639308030218,0.028755636519202557},
{0.8447825592666289,0.1763777245084395,0.03428630850490065},
{0.8389020984635047,0.15407680159829565,0.043091590035867905},
{0.8425379193815441,0.1317489386991326,0.06467084452016378},
{0.8487298064577309,0.10785726331737946,0.0908224617007646},
{0.8559561891122573,0.08123398080902942,0.11954781767230951},
{0.8653851852689985,0.048166006367535805,0.14949861986436253},
{0.8483095426290305,0.019292405024415708,0.17497953907833988},
{0.8298200893653316,-0.0042796866555997225,0.20279669414006746},
{0.8114286976616629,-0.020329670033626502,0.23326151132260797},
{0.7635746563669702,-0.015747070141494214,0.2530430064596706},
{0.7160826885246963,-0.010469526292621089,0.2699052843866061},
{0.686545684563979,-0.00415091350808766,0.2534395630980341},
{0.6399987715365008,-0.005040148665635407,0.2670905943338737},
{0.6111029393144419,-0.00779675610204222,0.24993413172684792},
{0.593726646397019,-0.009038258556005816,0.2776219748412831},
{0.5746261941823634,-0.009658955903009577,0.30416001922437613},
{0.5538694714428035,-0.009865962778633575,0.3294232633270779},
{0.531524366950668,-0.009865962778633575,0.3532899383990211},
{0.5076576918787248,-0.009865962778633575,0.3756350428911565},
{0.48238259418085466,-0.009865962778633575,0.39637344643818323},
{0.4558089890122561,-0.009866070538589657,0.4154200186748004},
{0.42804786912768855,-0.009866178298545728,0.43268962923570714},
{0.3992123824810329,-0.00986639381845788,0.4480971477556026},
{0.3694296858204601,-0.009866501578413962,0.46158653905732666},
{0.3388323238919448,-0.009865962778633575,0.4731071559615232},
{0.3495458187251243,-0.007585331068219064,0.5046689694969281},
{0.3602614687574254,-0.009826199354841149,0.5362361710301367},
{0.3707982372626385,-0.01643608730065082,0.5672764263781286},
{0.3809761651141151,-0.027262191287930834,0.5972617117561263},
{0.3906163707847673,-0.042152030978832175,0.6256586153815484},
{0.3995367399488248,-0.06095291051559368,0.6519401910691781},
{0.40760796065899524,-0.08325049286709911,0.6757163477780166},
{0.41469856576886466,-0.10863119532192478,0.6966034600644297},
{0.4206760105324581,-0.1366811118887788,0.7142146696861007},
{0.42541098300248337,-0.16698644433632528,0.7281620408011522},
{0.42885499119870557,-0.1989814528951598,0.7383054854666842},
{0.43095954314089024,-0.23210470819412096,0.7445049157397963},
{0.4316772244483634,-0.265791548063365,0.7466180884784672},
{0.43095954314089024,-0.2994783879326091,0.7445049157397963},
{0.42885499119870557,-0.33260164323157027,0.7383054854666842},
{0.42541098300248337,-0.3645977293899655,0.7281620408011522},
{0.4206760105324581,-0.3949019842379512,0.7142135920865399},
{0.41469856576886466,-0.4229519008048052,0.6966034600644297},
{0.40760796065899524,-0.4483326032596309,0.6757163477780166},
{0.3995367399488248,-0.47063029337109247,0.6519391134696173},
{0.3906163707847673,-0.489431172907854,0.6256586153815484},
{0.3809761651141151,-0.5043214436385797,0.5972606341565656},
{0.3707982372626385,-0.5151470088260792,0.5672764263781286},
{0.3602614687574254,-0.5217570045318449,0.536235093430576},
{0.3495458187251243,-0.5239984116182475,0.5046689694969281},
{0.3388323238919448,-0.5217171333480966,0.4731060783619625},
{0.3282998657849748,-0.5150694216577039,0.4420798318082606},
{0.31812948113042355,-0.5042072180851379,0.4121193312201606},
{0.3085022066545006,-0.48928569696714996,0.38375691078068314},
{0.2995969238842938,-0.4704578774413692,0.3575227494737273},
{0.29154402236665655,-0.44814294573693525,0.33380047274292735},
{0.2844738916484418,-0.422755777684745,0.31297155083279593},
{0.27851584367694215,-0.39471663711349875,0.2954196091869673},
{0.27379919039945005,-0.36444147745365385,0.2815261180499543},
{0.27037134619663933,-0.3324895728772502,0.27142685496641394},
{0.2682775702500624,-0.2994201975563275,0.265258675080564},
{0.26756419934083236,-0.265791548063365,0.26315735593706174},
{0.2682775702500624,-0.23216289857040256,0.2652597526801248},
{0.9440564188026037,-0.264261356687071,-0.2532024911946646},
{0.956761317624087,-0.29883721619395065,-0.20338829629893043},
{0.9707367063277186,-0.29895790734475697,-0.15329069271871365},
{0.9803866103944177,-0.2991486424670133,-0.10255094756023378},
{0.9859685761192084,-0.2993264463945404,-0.05138264105643551},
{0.9877423049962366,-0.2994126543594021,5.017960890679141e-10},
{0.9965915525892832,-0.26562883052968866,1.2544875286708835e-10},
{-0.6028452938802581,-0.29003646058113863,-0.2914238700156306},
{-0.5627348830292617,-0.32863068885013125,-0.3301765054200564},
{-0.5209423392639025,-0.3638423320978655,-0.36204651242984154},
{-0.4945853316070188,-0.3642916911147068,-0.40614511925524943},
{-0.46691149728687364,-0.36466992856053715,-0.446827735473015},
{-0.43746393408970047,-0.36496195804150594,-0.48454910809778357},
{-0.4057900501999755,-0.3651559259624446,-0.5197607513455177},
{-0.41693674005658476,-0.33245724489042694,-0.5333115658222057},
{-0.6259048468811844,-0.28911403535711916,-0.23631758367695288},
{-0.6600744513536536,-0.24693032295120038,-0.18495164541370934},
{-0.6445613280768027,-0.2887250219156811,-0.17909273660180058},
{-0.6074811271906925,-0.32746149332669533,-0.22603405106852079},
{-0.5867825948274142,-0.3279367147329951,-0.27928147816486953},
{-0.5453219517267724,-0.3633865074836595,-0.31505993878156896},
{-0.5030175481700473,-0.3955399231779273,-0.34590730380818296},
{-0.4782704742569547,-0.39576621908568915,-0.3894444812624294},
{-0.4516753170971407,-0.3958782894400093,-0.4302251590402252},
{-0.4229853063911891,-0.3958922982342992,-0.46847778824845354},
{-0.3919558270388048,-0.39582871986021384,-0.5044329751931194},
{-0.3583422639396932,-0.39570264071160366,-0.5383191709811059},
{-0.371434021003493,-0.3652378235290631,-0.5529152570317412},
{-0.3819578583139769,-0.3328548791283513,-0.5652742463942172},
{-0.3435500547689977,-0.3330175966620276,-0.595953505889351},
{-0.5670668332635588,-0.3629877956461745,-0.2657123444956484},
{-0.5254661022200167,-0.3952575920930055,-0.30006945129169166},
{-0.48347096973723275,-0.42407044914888486,-0.33141682251450316},
{-0.46004718808476613,-0.42417174350759734,-0.3740143331517578},
{-0.43443480172437476,-0.4241523467155035,-0.41435211751007694},
{-0.40653574909602863,-0.42404350915986566,-0.45249914196134977},
{-0.37625412383881907,-0.42387432602882474,-0.4885254504770264},
{-0.3434929419922768,-0.4236771253092037,-0.5225010870285569},
{-0.3218989243939984,-0.39553453518012344,-0.5703659043188574},
{-0.33394002188604704,-0.36519364194707155,-0.5844662945715383},
{-0.5855174929430698,-0.36271193015861725,-0.21453067575729656},
{-0.6239468484792646,-0.3272944653947759,-0.17104737828108862},
{-0.6000144398341143,-0.36262248939507336,-0.16204187875173023},
{-0.5616809906588283,-0.3947726722906587,-0.20331070913055496},
{-0.5451700101887038,-0.3949817266054482,-0.25238459312803985},
{-0.5044098068025628,-0.4238991108187225,-0.28694105584282564},
{-0.46221747360015775,-0.4493142964594928,-0.3180071735802761},
{-0.4399079298935277,-0.4493595556410451,-0.35935466872703703},
{-0.4152255119540813,-0.4493056756630066,-0.3988045110472813},
{-0.38817021978181837,-0.44918067411395723,-0.43632113975550346},
{-0.3587442085758606,-0.4490147237815986,-0.4718657612675157},
{-0.3269474783362078,-0.4488379974536322,-0.5054017371982519},
{-0.30815629719549326,-0.4234820797887043,-0.5544960955873914},
{-0.2830072786462332,-0.395349188055671,-0.6003921384801644},
{-0.2937983606477882,-0.36506864039802217,-0.6141951112540727},
{-0.302313552376996,-0.33301220866422376,-0.625083177216097},
{-0.2588453412946388,-0.3329109143055113,-0.6523949380838233},
{-0.2137445668777145,-0.33278160235821885,-0.6776215438014587},
{-0.17090244114016495,-0.29959153588649,-0.706862207882964},
{-0.16761037448201133,-0.33269323919423577,-0.7004957496779324},
{-0.1623840166122748,-0.3646623853636118,-0.6902779506427072},
{-0.155441042642231,-0.3949364674238959,-0.6765331682450807},
{-0.14699805008359476,-0.4229594440017307,-0.659586837552405},
{-0.13717680768673315,-0.4483164392662194,-0.6397299104460885},
{-0.1261012394011348,-0.4705979653842693,-0.6172544164070999},
{-0.11389300621721064,-0.4893902241245446,-0.5924523849164078},
{-0.10067420016519597,-0.5042826500543919,-0.5656147678554206},
{-0.08669741058213543,-0.5151179136379385,-0.5372523474159432},
{-0.07221468800529314,-0.5217397629388726,-0.5078715953915377},
{-0.05747851401175765,-0.523990868421322,-0.4779822163744486},
{-0.042740831378837094,-0.5217160557485357,-0.44809391495692025},
{-0.028250888884937656,-0.5150704992572646,-0.4187099301338325},
{-0.014257558148619268,-0.5042082956846987,-0.3903335009000651},
{-0.0010098185483979275,-0.48928569696714996,-0.36347109904918007},
{-0.2514993450888669,-0.3649080780634674,-0.6418851095676293},
{-0.20753112781031227,-0.36475721412495954,-0.6673186144009328},
{-0.2420466417417888,-0.3951703065285831,-0.6282157591392565},
{-0.19939740632561714,-0.39502483058787907,-0.6536568071694854},
{0.38003434309800177,-0.33260164323157027,-0.7531224794272774},
{0.43095954314089024,-0.2994783879326091,-0.7445049157397963},
{0.4791099243147949,-0.2994783879326091,-0.7263775359285163},
{0.5259758068122612,-0.2994783879326091,-0.7051488245813391},
{0.5713535243163035,-0.2994783879326091,-0.6809028344640047},
{0.6150394105099363,-0.2994783879326091,-0.6537268511409355},
{0.656857816664754,-0.2994783879326091,-0.6237534193581062},
{0.6923162302119046,-0.33260164323157027,-0.5861958418665748},
{0.7219847013190358,-0.3645977293899655,-0.5437502727673889},
{0.7644302704182218,-0.33260164323157027,-0.5140807240606969},
{0.7970470539236209,-0.3325973328333272,-0.47463626973825646},
{0.8275301902986946,-0.3325854792381586,-0.4331648506420069},
{0.8559982154951274,-0.3325617720478217,-0.3898399603012322},
{0.8825728982632868,-0.33252190086407324,-0.34483401464565566},
{0.890372563884143,-0.29916157366174256,-0.3476928862803796},
{0.9158157671134934,-0.29899239053070165,-0.30080114139345476},
{0.9381996651898165,-0.29886631138209147,-0.252628130628774},
{0.3772616794281395,-0.3645977293899655,-0.7427764460443206},
{0.42885499119870557,-0.33260164323157027,-0.7383054854666842},
{0.4766045053360037,-0.33260164323157027,-0.720328969593912},
{0.523080296792471,-0.33260164323157027,-0.6992769845747011},
{0.5680808544502438,-0.33260164323157027,-0.6752335831747914},
{0.6114025119923361,-0.33260164323157027,-0.6482828181599233},
{0.6528717758894642,-0.33260164323157027,-0.6185593894751928},
{0.6852525650910545,-0.3645977293899655,-0.5781418627493767},
{0.7115686239646289,-0.3949019842379512,-0.5333341954129819},
{0.7563762913010237,-0.3645977293899655,-0.5070181365394075},
{0.7884531974264768,-0.3645977293899655,-0.46811571479603464},
{0.8182412820848535,-0.3645977293899655,-0.42721542346699337},
{0.8457685628647338,-0.3645977293899655,-0.38448967848200705},
{0.8710598245560156,-0.3645977293899655,-0.3401076629721166},
{0.8937163553212136,-0.3645977293899655,-0.2942698104556253},
{0.9066669468425526,-0.3324798744812032,-0.29835067999226283},
{0.927697379870548,-0.33244862409394077,-0.250595777857161},
{0.9450790607857749,-0.3324410808970154,-0.20177297455733556},
{0.37344913218213377,-0.3949019842379512,-0.7285499766430295},
{0.42541098300248337,-0.3645977293899655,-0.7281620408011522},
{0.472505316606833,-0.3645977293899655,-0.7104312176282357},
{0.5183420915237635,-0.3645977293899655,-0.6896680292913113},
{0.5627241070336539,-0.3645977293899655,-0.6659554509565582},
{0.6054509296182011,-0.3645977293899655,-0.639375380190595},
{0.6463501433476816,-0.3645977293899655,-0.6100603617393966},
{0.6755401602498307,-0.3949019842379512,-0.5670673720633392},
{0.6984186765245475,-0.4229519008048052,-0.5201842479729005},
{0.7453018006149862,-0.3949019842379512,-0.49730573169818376},
{0.7766879654219854,-0.3949019842379512,-0.45914900885086396},
{0.8056786264053919,-0.3949019842379512,-0.41903213240250287},
{0.8322231363858497,-0.3949019842379512,-0.37712428548414123},
{0.8562697705844415,-0.3949019842379512,-0.33359249602769864},
{0.8775825346973589,-0.3949019842379512,-0.28863288715323515},
{0.8959200464229892,-0.3949019842379512,-0.24244158198081117},
{0.9133415985219645,-0.3645977293899655,-0.24717655445083642},
{0.9295346871216615,-0.3645977293899655,-0.19902617327693178},
{0.9419001420815021,-0.3645977293899655,-0.15001910045221467},
{0.958225775427174,-0.332471253684717,-0.15208593640977233},
{0.9673465781095348,-0.33251866806539093,-0.10175039884653743},
{0.9726526783467683,-0.3325639272469433,-0.05098317489925791},
{0.9743509752545425,-0.3325854792381586,7.526946724016515e-10},
{0.3686344173446115,-0.4229519008048052,-0.7105863919649866},
{0.4206760105324581,-0.3949019842379512,-0.7142135920865399},
{0.4668683933044429,-0.3949019842379512,-0.6968232903748268},
{0.5118269245793456,-0.3949019842379512,-0.6764577362758267},
{0.5553587140357882,-0.3949019842379512,-0.653198827356158},
{0.5972676385537106,-0.3949019842379512,-0.6271284611824393},
{0.637383437402511,-0.3949019842379512,-0.5983748721024021},
{0.6632781548478242,-0.4229519008048052,-0.5530844401627822},
{0.6828215004819564,-0.4483326032596309,-0.5045870719303095},
{0.7313199463139899,-0.4229519008048052,-0.48504372629617715},
{0.7618871354548036,-0.4229519008048052,-0.44782774786540996},
{0.7900254151856408,-0.4229519008048052,-0.4087001078138361},
{0.815643189543836,-0.4229519008048052,-0.36782567887425327},
{0.8386434745689197,-0.4229519008048052,-0.32536717858033803},
{0.8588851047184314,-0.4229519008048052,-0.28151641965390733},
{0.8762258368503489,-0.4229519008048052,-0.23646413721721765},
{0.8905234278226509,-0.4229519008048052,-0.19040106639252535},
{0.9110452338579627,-0.3949019842379512,-0.19521362603092604},
{0.922717792300228,-0.3949019842379512,-0.1471462200232007},
{0.9309894465287015,-0.3949019842379512,-0.09844744843282002},
{0.950565120149657,-0.3645977293899655,-0.10036999380919052},
{0.9556610884725403,-0.3645977293899655,-0.05029211030093584},
{0.9573162813978838,-0.3645977293899655,5.017960890679141e-10},
{-0.5225652042024228,-0.42371053089558763,-0.24096634818211649},
{-0.4819601751530326,-0.44920653650341574,-0.2750712966809395},
{-0.4391697741944,-0.4711475411602622,-0.3051093844374149},
{-0.4178451564863142,-0.4711820243462069,-0.3449665593916304},
{-0.3940819309722049,-0.4711496963593838,-0.3831814726152318},
{-0.3679415208270361,-0.4710710315914476,-0.4196539073490674},
{-0.3394831940266501,-0.4709675820336135,-0.45428149163486403},
{-0.30876514094732854,-0.47086089967709727,-0.4869629311139093},
{-0.29278218426198166,-0.44867959031819904,-0.5368935067622066},
{-0.2705394517281194,-0.42330104306249483,-0.5843563794163398},
{-0.5376408220576009,-0.42355427895927594,-0.19387632497600993},
{-0.5745507622131093,-0.39469077472404024,-0.15330039111476057},
{-0.5493403204888853,-0.4234820797887043,-0.14605030126989718},
{-0.5129648697155191,-0.4489608438035601,-0.18567363711942553},
{-0.49894098903165285,-0.4490761469565625,-0.2308573867025292},
{-0.45792754974873073,-0.4710721091910083,-0.2638567180520017},
{-0.41424058595553714,-0.4894505696999478,-0.2921555601173937},
{-0.3938502470666393,-0.48949151848325706,-0.33034892134977967},
{-0.3710406971638118,-0.48949798408062173,-0.36707782477907863},
{-0.34590353220972025,-0.4894818200872101,-0.4022075704601943},
{-0.31852927056746927,-0.48945272489906927,-0.43560238084846953},
{-0.2890084306001636,-0.4894225521113678,-0.4671254007996867},
{-0.2758498623635961,-0.47077145891355343,-0.5175969314274907},
{-0.25648432065699084,-0.4485438127735419,-0.5662063700142836},
{-0.23094305586761038,-0.42314479112618314,-0.6119267641786509},
{-0.18966344949317795,-0.42302733277405913,-0.6370553083362563},
{-0.4739891712020138,-0.4709794356287821,-0.22145533053480726},
{-0.4321211954674007,-0.4893902241245446,-0.25269494180154173},
{-0.38734370091870746,-0.5041005357286217,-0.2785788832512472},
{-0.36791673603713837,-0.5041393293128094,-0.31500390360440894},
{-0.3461373713144074,-0.504164114102707,-0.3500916229026545},
{-0.3221101339079094,-0.504179200496558,-0.3836911772074762},
{-0.29594062857459974,-0.5041899764921656,-0.4156538577794876},
{-0.26773553767099484,-0.5041996748882125,-0.44582987827974163},
{-0.25743153067090807,-0.48940100012015236,-0.49664300796830996},
{-0.24093024859683063,-0.47069925974298177,-0.5460628014248021},
{-0.21829311462372644,-0.4484349752179041,-0.5932056270093864},
{-0.17844456046599713,-0.44835846564908943,-0.6177587330015405},
{-0.48722317140783533,-0.47089646046260275,-0.17814983698612644},
{-0.5238389268832534,-0.44890049822815686,-0.1398325518042519},
{-0.4975002384189028,-0.47084796848236804,-0.13418808530493642},
{-0.4599825321111199,-0.4892652225754952,-0.170749960802316},
{-0.4473983244404429,-0.48932341295177684,-0.2121610343231624},
{-0.40434714438810393,-0.5040552765470694,-0.2409803569764065},
{-0.3750946267114301,-0.5148409705508203,-0.22884012032476694},
{-0.35896727168494,-0.5148722209380828,-0.2645215969809971},
{-0.34052738800103666,-0.5149023937257844,-0.2990996116869983},
{-0.31983532123512304,-0.5149293337148035,-0.33242976610162733},
{-0.2969988313432763,-0.5149541185047013,-0.36436227388593717},
{-0.27212567828157347,-0.514978903294599,-0.3947484263005414},
{-0.2453246996056524,-0.515002610484936,-0.42343628180737153},
{-0.2375993883544893,-0.5042136836825026,-0.47407052996885196},
{-0.22396559871162194,-0.48938806892542314,-0.5240442095995802},
{-0.20420242276709244,-0.47064645736450406,-0.5722409275545979},
{-0.16586143039488094,-0.4706119741785593,-0.5960116962656327},
{-0.18877658505466388,-0.4893826809276192,-0.5492201681378595},
{-0.1520304400323926,-0.48938375852718,-0.5720588132288278},
{0.3629263724712106,-0.4483326032596309,-0.6892800934494339},
{0.41469856576886466,-0.4229519008048052,-0.6966034600644297},
{0.4597508482055543,-0.4229519008048052,-0.6796409653783425},
{0.503601607131985,-0.4229519008048052,-0.6597775726746613},
{0.5460601074259003,-0.4229519008048052,-0.6370930243208833},
{0.586934536365483,-0.4229519008048052,-0.6116649074853837},
{0.626062176417057,-0.4229519008048052,-0.5836203789163336},
{0.6487348711756665,-0.4483326032596309,-0.5365012605220862},
{0.6650658925191423,-0.47063029337109247,-0.4868314639674953},
{0.7147356890737331,-0.4483326032596309,-0.4704993650244588},
{0.744363211397555,-0.4483326032596309,-0.43439977973864974},
{0.7715909194995413,-0.4483326032596309,-0.39644564560875484},
{0.7963035102266892,-0.4483326032596309,-0.356796447369768},
{0.8183867580255575,-0.4483326032596309,-0.31561166975668337},
{0.8377490669334803,-0.4483326032596309,-0.27307558229439266},
{0.8542977633882317,-0.4483326032596309,-0.22937353210734832},
{0.8679390962280245,-0.4483326032596309,-0.18469194391956364},
{0.8785814694901931,-0.4483326032596309,-0.13921400965636965},
{0.9016356344933154,-0.4229519008048052,-0.14351794230208673},
{0.9095678448601464,-0.4229519008048052,-0.09601993990227249},
{0.9143222141222657,-0.4229519008048052,-0.048112449669365516},
{0.9359108437227401,-0.3949019842379512,-0.04932873629360709},
{0.9375347862608211,-0.3949019842379512,2.5089858333373744e-10},
{0.3564273695202042,-0.47063029337109247,-0.6650254825356133},
{0.40760796065899524,-0.4483326032596309,-0.6757163477780166},
{0.4513100108460396,-0.4483326032596309,-0.6592624800846131},
{0.4938460983083303,-0.4483326032596309,-0.639994999938038},
{0.5350308759214151,-0.4483326032596309,-0.6179904169071061},
{0.5746800741604018,-0.4483326032596309,-0.5933252405606319},
{0.6126342082902967,-0.4483326032596309,-0.5661212396489828},
{0.6321786315239899,-0.47063029337109247,-0.5176227938169492},
{0.6454417269179522,-0.489431172907854,-0.4672062207667444},
{0.6958572223685962,-0.47063029337109247,-0.45394420297234284},
{0.7244351627202277,-0.47063029337109247,-0.41911402996912134},
{0.7506822552219128,-0.47063029337109247,-0.38249611929458177},
{0.774478886322406,-0.47063029337109247,-0.3442413348872319},
{0.7957097528687048,-0.47063029337109247,-0.30450592868338344},
{0.8142983452919945,-0.47063029337109247,-0.2634666270110028},
{0.8301735420212643,-0.47063029337109247,-0.22130231139717788},
{0.8432588334876995,-0.47063029337109247,-0.17819294096855728},
{0.8534809429211677,-0.47063029337109247,-0.13431524205310735},
{0.8608150855317711,-0.47063029337109247,-0.08986350585163502},
{0.8862076415817653,-0.4483326032596309,-0.09314091715576217},
{0.8907971381110865,-0.4483326032596309,-0.04666986713736216},
{0.8923327174851844,-0.4483326032596309,7.526946724016515e-10},
{0.9159062854765981,-0.4229519008048052,5.017960890679141e-10},
{0.3492440908481086,-0.489431172907854,-0.6382169606627668},
{0.3995367399488248,-0.47063029337109247,-0.6519391134696173},
{0.44170105556264977,-0.47063029337109247,-0.6360639167403476},
{0.48274035723503045,-0.47063029337109247,-0.6174742467174971},
{0.5224768410384396,-0.47063029337109247,-0.5962444577707591},
{0.5607305478462288,-0.47063029337109247,-0.5724467490707051},
{0.5973495361203291,-0.47063029337109247,-0.5462007341685807},
{0.6138799133825473,-0.489431172907854,-0.4967572335217516},
{0.6242356451615511,-0.5043214436385797,-0.4460012166099041},
{0.6749916620733986,-0.489431172907854,-0.43564548483090043},
{0.7024176484945664,-0.489431172907854,-0.40221942405536276},
{0.7276054606280142,-0.489431172907854,-0.3670767471795178},
{0.7504441057189826,-0.489431172907854,-0.3303650853431912},
{0.7708182806144689,-0.489431172907854,-0.29223099208664766},
{0.7886579413430231,-0.489431172907854,-0.2528458057400496},
{0.8038930439331954,-0.489431172907854,-0.21238194223312037},
{0.8164513892144137,-0.489431172907854,-0.17100966229646164},
{0.826260778016107,-0.489431172907854,-0.12890138185979677},
{0.8332996583470593,-0.489431172907854,-0.08624104716814918},
{0.8375421678178124,-0.489431172907854,-0.04321249670658635},
{0.8652364765296122,-0.47063029337109247,-0.045027605406748036},
{0.8667181759256715,-0.47063029337109247,5.017960890679141e-10},
{0.3414821412118793,-0.5043214436385797,-0.6092489292701364},
{0.3906163707847673,-0.489431172907854,-0.6256586153815484},
{0.43108023429169656,-0.489431172907854,-0.6104235127913762},
{0.4704654206382946,-0.489431172907854,-0.5925838520628219},
{0.5085995138948382,-0.489431172907854,-0.5722085995677748},
{0.5453111757311648,-0.489431172907854,-0.5493710320763673},
{0.5804538526070098,-0.489431172907854,-0.5241821423433588},
{0.5941070390419709,-0.5043214436385797,-0.47420954031219137},
{0.5732285475520441,-0.5151470088260792,-0.45040321081565127},
{0.6018452814878632,-0.5151470088260792,-0.42361085293621636},
{0.6524450464633991,-0.5043214436385797,-0.4158715328907632},
{0.6786253277923164,-0.5043214436385797,-0.3839638098963511},
{0.7026708843913475,-0.5043214436385797,-0.3504159803704464},
{0.7244718011052939,-0.5043214436385797,-0.3153702874550708},
{0.7439213955776391,-0.5043214436385797,-0.27896681909312454},
{0.7609517790360549,-0.5043214436385797,-0.24136937041784462},
{0.7754950627082126,-0.5043214436385797,-0.2027417365624682},
{0.7874833578217834,-0.5043214436385797,-0.1632477126602323},
{0.7968487756044391,-0.5043214436385797,-0.12305109384437415},
{0.8035676088658427,-0.5043214436385797,-0.08232666676365062},
{0.807617228015218,-0.5043214436385797,-0.041251157746028104},
{0.8089750034617885,-0.5043214436385797,5.017960890679141e-10},
{0.8389645992380294,-0.489431172907854,2.5089858333373744e-10},
{-0.41886025527255993,-0.5040100173655169,-0.20237319751268468},
{-0.38885449550290757,-0.5148107977631189,-0.19220389045769423},
{-0.35786273213515035,-0.5215026910355032,-0.18176626111207198},
{-0.34485071743884754,-0.5215199326284755,-0.21640031099523324},
{-0.32960052845482457,-0.5215382518210087,-0.25012594444866504},
{-0.31216604516111995,-0.5215587262126633,-0.2828063063281495},
{-0.29260006993621146,-0.5215792006043178,-0.3143045414894689},
{-0.2710071299374938,-0.5216007525955333,-0.3444794843901621},
{-0.24749067472280095,-0.5216223045867487,-0.37319320228645075},
{-0.22215523144952762,-0.5216438565779641,-0.4003045296358737},
{-0.2167058104707116,-0.5150284728743945,-0.45028036446572345},
{-0.20567981176490868,-0.5042309252754749,-0.5002712856894239},
{-0.4308129896006254,-0.5039701461817684,-0.16291904479419733},
{-0.4401363810004111,-0.5039432061927492,-0.12278600435242464},
{-0.40903685767657677,-0.5147687713802489,-0.11664907485383709},
{-0.4001876100835301,-0.5147860129732212,-0.15475730572092217},
{-0.3685826925656945,-0.5214886822412133,-0.14636280514252062},
{-0.33647130325429675,-0.5238497028788611,-0.13783360461902275},
{-0.32636557457339177,-0.5238572460757865,-0.17117345742969875},
{-0.3141024915718244,-0.5238658668722727,-0.20378377533773318},
{-0.2997348566280724,-0.5238755652683197,-0.23553416879627279},
{-0.28331547212061353,-0.5238852636643666,-0.2662910154597821},
{-0.26489606282836475,-0.523897117259535,-0.29592177058228636},
{-0.2445746903113562,-0.5239089708547036,-0.32430035501517535},
{-0.22244510573137485,-0.5239219020494328,-0.35129961201027815},
{-0.1986021378497686,-0.523934833244162,-0.37679238481942395},
{-0.19510317207594705,-0.5216675637683011,-0.4256733784955309},
{-0.18640047802316514,-0.5150543352638529,-0.47518045751644555},
{-0.1721212062433963,-0.5042481668684472,-0.5243308510827451},
{-0.13707120292977765,-0.5042664860609803,-0.5461468541905422},
{-0.15454232460854847,-0.5150791200537507,-0.4980406545986292},
{-0.12126389497283638,-0.5151006720449661,-0.5187628941522443},
{-0.10489117052635887,-0.5217268317441434,-0.49039939611320615},
{-0.08823439083566226,-0.5239844028239575,-0.46154343507489587},
{-0.0715751326659759,-0.5217128229498534,-0.4326853188374641},
{-0.05519518830244121,-0.5150694216577039,-0.40431320000193965},
{-0.03937613451028754,-0.5042082956846987,-0.3769130759702302},
{-0.024399720470673906,-0.48928569696714996,-0.3509741769429255},
{-0.1664594981511085,-0.5216891157595164,-0.4492070753031961},
{-0.13634705602493996,-0.5217095901511711,-0.470812946496643},
{-0.1461833848156523,-0.5239617732331813,-0.4227897220709093},
{-0.11784186980765383,-0.5239747044279105,-0.44311648258572167},
{-0.09933301975186111,-0.5217074349520495,-0.41541355307743577},
{-0.08113387180983382,-0.5150661888590214,-0.3881761465794027},
{-0.06355746865397575,-0.5042072180851379,-0.3618697861018752},
{-0.04691685295669071,-0.48928569696714996,-0.33696538265291},
{-0.06847121489113278,-0.48928461936758916,-0.32151583775014453},
{-0.08897254653479,-0.48928461936758916,-0.3046923534073967},
{-0.10833097608429412,-0.48928354176802835,-0.2865660511956775},
{-0.12645576965662825,-0.48928354176802835,-0.2672058974868762},
{-0.14327925399937602,-0.48928246416846755,-0.24670241064409743},
{-0.15872879890214153,-0.48928246416846755,-0.22514503143088518},
{-0.17314277062700667,-0.5239488420384519,-0.4006525942940026},
{-0.1511780587798232,-0.5216934261577595,-0.37561780129818423},
{-0.1259040386815138,-0.521700969354685,-0.3963637480421363},
{-0.10596359760923758,-0.5150629560603391,-0.3703774346341577},
{-0.08670484601910472,-0.5042061404855771,-0.34527906326425384},
{0.3332869965522202,-0.5151470088260792,-0.5786623433372289},
{0.32480305521027475,-0.5217570045318449,-0.5469992354431116},
{0.3707982372626385,-0.5151470088260792,-0.5672764263781286},
{0.3809761651141151,-0.5043214436385797,-0.5972606341565656},
{0.4196037989694916,-0.5043214436385797,-0.582717350484408},
{0.4572012476447715,-0.5043214436385797,-0.5656869670259922},
{0.4936047160067178,-0.5043214436385797,-0.5462373725536469},
{0.5286504089220934,-0.5043214436385797,-0.5244364558397007},
{0.5621982384479981,-0.5043214436385797,-0.5003908992406695},
{0.5429221375049368,-0.5151470088260792,-0.4752698982799895},
{0.5229671488385902,-0.5217570045318449,-0.44926311048035616},
{0.5516151331616718,-0.5217570045318449,-0.425757431261271},
{0.5786661149356916,-0.5217570045318449,-0.4004306087844839},
{0.6286376393672982,-0.5151470088260792,-0.3949941190003971},
{0.6535043268316364,-0.5151470088260792,-0.36468770895328984},
{0.6763429719226046,-0.5151470088260792,-0.3328241675408693},
{0.6970490474828084,-0.5151470088260792,-0.29953819470823184},
{0.7155223367530955,-0.5151470088260792,-0.26496233520135215},
{0.7316981837598203,-0.5151470088260792,-0.22925176335698125},
{0.7455108549297755,-0.5151470088260792,-0.19256380871099157},
{0.7568967718888758,-0.5151470088260792,-0.15505256800057327},
{0.7657923562630357,-0.5151470088260792,-0.11687321556247733},
{0.7721739008619181,-0.5151470088260792,-0.07819364140827176},
{0.7760209312938684,-0.5151470088260792,-0.03918022691013951},
{0.7773097403685498,-0.5151470088260792,7.526946724016515e-10},
{0.7433103966266823,-0.5217570045318449,-0.03703634258398676},
{0.7445291617299137,-0.5217570045318449,5.017960890679141e-10},
{0.7100459757852603,-0.5239984116182475,-0.034856143152636056},
{0.7111936193174808,-0.5239984116182475,1.8817366810041288e-10},
{0.6767858653420813,-0.5217171333480966,-0.03267615924119749},
{0.6778613097037302,-0.5217171333480966,2.5089858333373744e-10},
{0.644090417068746,-0.5150694216577039,-0.030533244754649438},
{0.6450958174589448,-0.5150694216577039,3.7634733620082576e-10},
{0.6125189051372943,-0.5042072180851379,-0.028463930318102},
{0.6134553391556038,-0.5042072180851379,2.5089858333373744e-10},
{0.5826306037197659,-0.48928569696714996,-0.026505069836533536},
{0.58350345936399,-0.48928569696714996,6.272459195345632e-11},
{0.5557983746565826,-0.4704578774413692,8.22508037545724e-17},
{0.5549858645877616,-0.4704578774413692,-0.024693193935054154},
{0.5307463400677918,-0.44814294573693525,7.944678193749169e-17},
{0.5299877099770095,-0.44814294573693525,-0.02305470380290273},
{0.5087503778333461,-0.422755777684745,7.570815802135478e-17},
{0.5080391621232376,-0.422755777684745,-0.021616108389274222},
{0.49021458778853405,-0.39471663711349875,6.272459195345632e-11},
{0.4895432432621741,-0.39471663711349875,-0.0204038088834075},
{0.475541992169084,-0.36444147745365385,2.5089858333373744e-10},
{0.4749018980299864,-0.36444147745365385,-0.019444206474541443},
{0.4648769893161392,-0.3324895728772502,3.7634733620082576e-10},
{0.46425952476781773,-0.3324895728772502,-0.018746784038810825},
{0.45836289997128205,-0.2994201975563275,2.5089858333373744e-10},
{0.4577605218168113,-0.2994201975563275,-0.0183207011724822},
{0.4561441224756557,-0.265791548063365,1.2544875286708835e-10},
{0.45554605471942816,-0.265791548063365,-0.018175548511646426},
{0.4577605218168113,-0.23216289857040256,-0.0183207011724822},
{0.45836289997128205,-0.23216289857040256,2.5089858333373744e-10},
{0.46425952476781773,-0.1990935232494799,-0.018746784038810825},
{0.4749018980299864,-0.16714161867307623,-0.019444206474541443},
{0.31617471552718596,-0.5239984116182475,-0.51479840536817},
{0.3602614687574254,-0.5217570045318449,-0.536235093430576},
{0.407487269508189,-0.5151470088260792,-0.5534637552081734},
{0.4431967637529991,-0.5151470088260792,-0.5372879082014487},
{0.4777726232598788,-0.5151470088260792,-0.5188146189311613},
{0.5110585960925162,-0.5151470088260792,-0.4981074657713969},
{0.49284716351549623,-0.5217570045318449,-0.4708517400808307},
{0.47432645986453503,-0.5239984116182475,-0.443133724178694},
{0.5026737939101616,-0.5239984116182475,-0.42281666205992857},
{0.5296353349206374,-0.5239984116182475,-0.4006946206768726},
{0.5550936245438386,-0.5239984116182475,-0.3768581183926309},
{0.6039918598129179,-0.5217570045318449,-0.3733807046100248},
{0.6274986166315638,-0.5217570045318449,-0.34473164268738243},
{0.6490861686324777,-0.5217570045318449,-0.3146127349638492},
{0.6686607646538724,-0.5217570045318449,-0.283146827789353},
{0.6861232655361571,-0.5217570045318449,-0.2504632331111862},
{0.7014133257039286,-0.5217570045318449,-0.21670742687005282},
{0.7144705995817836,-0.5217570045318449,-0.18202704020577842},
{0.7252336639947585,-0.5217570045318449,-0.146567549059067},
{0.7336421733674502,-0.5217570045318449,-0.11047766216930491},
{0.7396745757086429,-0.5217570045318449,-0.07391492459227675},
{0.7066235195802534,-0.5239984116182475,-0.06956379308579794},
{0.6735778514496678,-0.5217171333480966,-0.06521320037909953},
{0.6410925350906828,-0.5150694216577039,-0.06093642324231389},
{0.6097246894762167,-0.5042072180851379,-0.05680673844557341},
{0.5800282007805053,-0.48928569696714996,-0.052897207239098326},
{0.5525612655760281,-0.4704578774413692,-0.04928110639302103},
{0.5277247508993916,-0.44814294573693525,-0.046011238285819274},
{0.5059173685880807,-0.422755777684745,-0.04314018977605865},
{0.4875399856787019,-0.39471663711349875,-0.0407207632422169},
{0.47299346920786195,-0.36444147745365385,-0.03880565330281571},
{0.3949418554216998,-0.5217570045318449,-0.5231788971522815},
{0.42869766166283313,-0.5217570045318449,-0.5078877593849493},
{0.38218523182129954,-0.5239984116182475,-0.4923800241059022},
{0.41395394447237227,-0.5239984116182475,-0.477989759571374},
{0.4613823339405607,-0.5217570045318449,-0.4904252585026646},
{0.4447140239345639,-0.5239984116182475,-0.4615552886700643},
{0.3992123824810329,-0.5217171333480966,-0.4480960701560418},
{0.42804786912768855,-0.5217171333480966,-0.43268962923570714},
{0.3495458187251243,-0.5239984116182475,-0.5046689694969281},
{0.3388323238919448,-0.5217171333480966,-0.4731060783619625},
{0.3694296858204601,-0.5217171333480966,-0.46158653905732666},
{0.35689073733133553,-0.5150694216577039,-0.4313146121961641},
{0.3847197459882316,-0.5150694216577039,-0.4187099301338325},
{0.4116651230052959,-0.5150694216577039,-0.40431320000193965},
{0.4558089890122561,-0.5217171333480966,-0.4154200186748004},
{0.48238259418085466,-0.5217171333480966,-0.39637344643818323},
{0.5076576918787248,-0.5217171333480966,-0.3756350428911565},
{0.531524366950668,-0.5217171333480966,-0.3532899383990211},
{0.5789290492285195,-0.5239984116182475,-0.3513998287694298},
{0.6010510906115755,-0.5239984116182475,-0.3244382877589539},
{0.6213692303299018,-0.5239984116182475,-0.296092031312888},
{0.6397907948212721,-0.5239984116182475,-0.26647959538291693},
{0.6562252657225818,-0.5239984116182475,-0.23571951592072532},
{0.6706155302571098,-0.5239984116182475,-0.20395080326965256},
{0.682903398048575,-0.5239984116182475,-0.17131139017347738},
{0.693032833919817,-0.5239984116182475,-0.13794028697553903},
{0.7009467250941149,-0.5239984116182475,-0.1039744565800115},
{0.6682555872190227,-0.5217171333480966,-0.09747189755045456},
{0.6361194131177272,-0.5150694216577039,-0.09107946919600836},
{0.6050877785662215,-0.5042072180851379,-0.08490697891191538},
{0.5757113369400592,-0.48928569696714996,-0.07906347977372565},
{0.548539664015233,-0.4704578774413692,-0.07365877917668161},
{0.5239693164301066,-0.44814294573693525,-0.06877132636880737},
{0.5023957732234828,-0.422755777684745,-0.06448010939790741},
{0.4842166686332859,-0.39471663711349875,-0.060863900791874044},
{0.46982532649919695,-0.36444147745365385,-0.058001473078599576},
{-0.3043275859560759,-0.5216460117770857,-0.12926884331001948},
{-0.29484363222173543,-0.5216492445757679,-0.16053647216533395},
{-0.2833370241118289,-0.5216524773744502,-0.19111874769999845},
{-0.26985733120615174,-0.5216557101731325,-0.2208895907654028},
{-0.2544573558831817,-0.5216600205713756,-0.2497229222129369},
{-0.23718882292183574,-0.5216654085691795,-0.2774926628939906},
{-0.21813794028697553,-0.5216718741665441,-0.3040824320560007},
{-0.19739414874214495,-0.5216783397639088,-0.32937692654596473},
{-0.17504581145132722,-0.5216858829608341,-0.3532608432108803},
{-0.26383678246012743,-0.5150414040691237,-0.15004604044123393},
{-0.25307802844539556,-0.5150414040691237,-0.1786293687906693},
{-0.2404765791817463,-0.5150424816686845,-0.20645191185020073},
{-0.22608308184853582,-0.515044636867806,-0.23339513366814352},
{-0.20994602842599877,-0.5150457144673668,-0.25933834309369136},
{-0.19214516128163225,-0.5150489472660491,-0.2841759353698887},
{-0.17276453318117627,-0.5150521800647315,-0.30780338333934093},
{-0.1518817312930063,-0.5150554128634137,-0.33011184944641014},
{-0.22384921795905874,-0.5041975196890909,-0.1665408569179467},
{-0.21210014994797885,-0.5041975196890909,-0.19248083354481224},
{-0.19867972501814404,-0.5041975196890909,-0.21759860170680995},
{-0.183636435149789,-0.5041985972886517,-0.24178209104961967},
{-0.16704355711304608,-0.5041985972886517,-0.26493324001321134},
{-0.14897652287716925,-0.5042007524877733,-0.2869539870375549},
{-0.1295107644114124,-0.504201830087334,-0.3077462705626201},
{-0.12958080838286246,-0.5150597232616568,-0.3509957289341409},
{-0.10872149816511732,-0.5042039852864556,-0.327212029028377},
{-0.172737593192157,-0.48928246416846755,-0.20262643340946576},
{-0.24215332409830506,-0.5041985972886517,-0.11264255968689267},
{-0.272705426845268,-0.5150414040691237,-0.12082046275357938},
{-0.279633314421461,-0.515040326469563,-0.09107246479886334},
{-0.2486146110646845,-0.5041985972886517,-0.08490708667187147},
{-0.2338827474693921,-0.5041975196890909,-0.13989074218053346},
{0.307547453443658,-0.5217171333480966,-0.4826029632910322},
{0.2990667449003948,-0.5150694216577039,-0.4509527865916442},
{0.29087806583810044,-0.5042072180851379,-0.42039098544863435},
{0.3282998657849748,-0.5150694216577039,-0.4420798318082606},
{0.28312581459791797,-0.48928569696714996,-0.3914595924410701},
{0.31812948113042355,-0.5042072180851379,-0.4121193312201606},
{0.3447839062660798,-0.5042072180851379,-0.40208364651070566},
{0.37072603809206695,-0.5042072180851379,-0.3903335009000651},
{0.3958448838536254,-0.5042072180851379,-0.3769119983706695},
{0.43760509963216143,-0.5150694216577039,-0.3881761465794027},
{0.4624362263109942,-0.5150694216577039,-0.3703785122337184},
{0.48605397588439947,-0.5150694216577039,-0.351000039332384},
{0.5083548987945433,-0.5150694216577039,-0.3301204702428963},
{0.5538694714428035,-0.5217171333480966,-0.3294232633270779},
{0.5746078749898302,-0.5217171333480966,-0.3041481656292077},
{0.5936544472264473,-0.5217171333480966,-0.27757456046060913},
{0.610924057787354,-0.5217171333480966,-0.24981344057604163},
{0.6263304987076888,-0.5217171333480966,-0.2209768763298252},
{0.6398209676089737,-0.5217171333480966,-0.19119525726881315},
{0.6513415845131703,-0.5217171333480966,-0.16059789534029786},
{0.6608373918426791,-0.5217171333480966,-0.12931302489201105},
{0.6291872151432912,-0.5150694216577039,-0.12083231634874785},
{0.5986254140002812,-0.5042072180851379,-0.11264363728645345},
{0.569694020992717,-0.48928569696714996,-0.10489117052635889},
{0.5429339911001052,-0.4704578774413692,-0.09772082304899252},
{0.5187354153634447,-0.44814294573693525,-0.09123679873188084},
{0.49748838482373436,-0.422755777684745,-0.08554384025233072},
{0.47958406812153387,-0.39471663711349875,-0.08074625924782473},
{0.4654114786982813,-0.36444147745365385,-0.07694879839566977},
{0.35747910669151617,-0.48928569696714996,-0.36347002144961926},
{0.3808684051580381,-0.48928569696714996,-0.35097309934336474},
{0.42002729559687435,-0.5042072180851379,-0.3618687085023144},
{0.4431752117617837,-0.5042072180851379,-0.34527798566469303},
{0.4651927259874449,-0.5042072180851379,-0.327212029028377},
{0.48598177671382786,-0.5042072180851379,-0.3077473481621809},
{0.529234467884031,-0.5150694216577039,-0.3078195473327525},
{0.5486129407853654,-0.5150694216577039,-0.2842017977593473},
{0.5664105751310495,-0.5150694216577039,-0.2593706710805145},
{0.5825476285535867,-0.5150694216577039,-0.23343069445364895},
{0.5969443586854793,-0.5150694216577039,-0.20648531743658463},
{0.6095501183473717,-0.5150694216577039,-0.17865630877968855},
{0.6203142603599074,-0.5150694216577039,-0.15006543723332777},
{0.5903537597718075,-0.5042072180851379,-0.13989505257877657},
{0.5619913393323301,-0.48928569696714996,-0.13026777810285364},
{0.5357571780253743,-0.4704578774413692,-0.12136249533264691},
{0.5120349012945743,-0.44814294573693525,-0.11330959381500956},
{0.49120705698400363,-0.422755777684745,-0.10623924757688269},
{0.47365403773861425,-0.39471663711349875,-0.10028109184542695},
{0.3085022066545006,-0.48928569696714996,-0.38375691078068314},
{0.3333214797381649,-0.48928569696714996,-0.3744119673896821},
{0.2995969238842938,-0.4704578774413692,-0.3575227494737273},
{0.3227200552593055,-0.4704578774413692,-0.3488168226222631},
{0.3452257220859957,-0.4704578774413692,-0.338622730777375},
{0.44544355883720543,-0.48928569696714996,-0.3046934310069575},
{0.464802634946446,-0.48928569696714996,-0.2865682063947991},
{0.5054464575800239,-0.5042072180851379,-0.2869582974357979},
{0.52351241421634,-0.5042072180851379,-0.26494078321013675},
{0.5401042146535221,-0.5042072180851379,-0.2417928670452274},
{0.5551475045218771,-0.5042072180851379,-0.21761045530197842},
{0.568567929451712,-0.5042072180851379,-0.19249160954041997},
{0.5803191526619134,-0.5042072180851379,-0.16654840011487212},
{0.5526474735408897,-0.48928569696714996,-0.15508705118651792},
{0.5270523287734707,-0.4704578774413692,-0.1444845491080978},
{0.5039076454072438,-0.44814294573693525,-0.13489822341548413},
{0.4835862728902352,-0.422755777684745,-0.1264810932463064},
{0.4664610606704717,-0.39471663711349875,-0.11938725533775472},
{0.4580374649039293,-0.39471663711349875,-0.13798339095796985},
{0.44841665602537106,-0.39471663711349875,-0.15599007961844355},
{0.4530460237384407,-0.422755777684745,-0.18362188755571862},
{0.44044565207435227,-0.422755777684745,-0.20120184679012723},
{0.426726732066184,-0.422755777684745,-0.21792188157504105},
{0.41194422129153546,-0.422755777684745,-0.23370979273988846},
{0.4106597226150971,-0.44814294573693525,-0.26502914637411995},
{0.39282652748390745,-0.44814294573693525,-0.27966187080982147},
{0.37407737272606295,-0.44814294573693525,-0.29309953733262856},
{0.35449092310949976,-0.44814294573693525,-0.3052839555662597},
{0.27595546712055163,-0.4704578774413692,-0.36469848494889756},
{0.4033870031794575,-0.48928569696714996,-0.3369643050533493},
{0.42494222719354824,-0.48928569696714996,-0.3215147601505838},
{0.4271771686825861,-0.4704578774413692,-0.2838645090968261},
{0.4452129525312006,-0.4704578774413692,-0.26697852397955363},
{0.4829278595586045,-0.48928569696714996,-0.2672091302855585},
{0.4997502663017915,-0.48928569696714996,-0.2467067210423405},
{0.5151998112045569,-0.48928569696714996,-0.22515149702824983},
{0.5292075278950116,-0.48928569696714996,-0.20263397660639113},
{0.5417044500012662,-0.48928569696714996,-0.17924360054030844},
{0.5168571593290219,-0.4704578774413692,-0.16699129353434874},
{0.49438920848695866,-0.44814294573693525,-0.15591033725094655},
{0.4746615933279346,-0.422755777684745,-0.1461817684163112},
{0.36701694040389515,-0.4704578774413692,-0.3269803451228113},
{0.38799564865297365,-0.4704578774413692,-0.3139295368423208},
{0.4080767164679304,-0.4704578774413692,-0.2995360395091103},
{0.4274982933516957,-0.44814294573693525,-0.2492638648000487},
{0.4620989376484731,-0.4704578774413692,-0.24894274013093912},
{0.47777046806075724,-0.4704578774413692,-0.22984228791628344},
{0.49216396539396773,-0.4704578774413692,-0.20976014250176592},
{0.5052147736744582,-0.4704578774413692,-0.18878251185224817},
{0.4835194617174674,-0.44814294573693525,-0.1762564945578528},
{0.464469656682168,-0.422755777684745,-0.16525743584106914},
{0.4432635749257669,-0.44814294573693525,-0.23242529406345014},
{0.4578962993614684,-0.44814294573693525,-0.2145920989322605},
{0.4713350434838363,-0.44814294573693525,-0.19584294417441597},
{-0.2601524695618534,0.05377782160015991,-0.15930908626561643},
{-0.3003156827913277,0.05296875984993349,-0.19005946733176113},
{-0.3482106728693297,0.05117897473944989,-0.21450589096739886},
{-0.3989569913851303,0.046406825084578086,-0.23269684915276428},
{-0.30971666135948883,0.07616969391323275,-0.1803373640944904},
{-0.3569747900970755,0.0732795718912465,-0.2035628674277752},
{-0.4084603419115646,0.06815838773864116,-0.22081954679395271},
{-0.4615245770825824,0.06013889180738769,-0.2316989919594909},
{-0.41704881041090486,0.09212689596907721,-0.2158367264249503},
{-0.47134150908120087,0.08404759326220097,-0.2260954742434847},
{-0.513518755889755,0.048553511169588844,-0.2357895598921754},
{-0.3645815653965539,0.097455733557043,-0.19896043970372476},
{-0.37016891911914857,0.12306370175923516,-0.2002244639885085},
{-0.4242471754768512,0.11766201844096127,-0.21740678898499283},
{-0.4802338606566784,0.10941558004220957,-0.2274543272896162},
{-0.5245038058122488,0.07245973414541235,-0.22909120102242647},
{-0.5632068716368791,0.034889667274971614,-0.2317755015283056},
{-0.5503866696623934,0.011525789382088245,-0.24751599831247909},
{-0.6093550728268723,0.020634393637421148,-0.2183356798063769},
{-0.6503792881054021,0.008292236380084448,-0.19351209632446953},
{-0.6759334840895118,-0.029297884618182238,-0.1671615542649505},
{-0.6984014349315751,-0.06801485147714655,-0.1196760520200412},
{-0.695627693662152,-0.10955793094418734,-0.12347782327043923},
{-0.6926686052682764,-0.15494211404559433,-0.125483236053033},
{-0.6867364196862353,-0.20139958630952862,-0.12587871509183574},
{-0.6686984806384992,-0.20192761009430613,-0.18739887401621896},
{-0.3168977848324629,0.10079187403723214,-0.17610670821890573},
{-0.32110688871683213,0.12640867855582263,-0.17681253593121035},
{-0.2769522467142642,0.10289340870064662,-0.1479199365078339},
{-0.2700771615165489,0.07790516800585352,-0.15152127423992864},
{-0.2326004039920753,0.05560790893421631,-0.1222073333882909},
{-0.24144318598775735,0.07956230061040627,-0.11749391290948111},
{-0.24770188423671197,0.10451810555842017,-0.11504345150828918},
{-0.2504670047096489,0.13007952145958704,-0.11492491555660442},
{-0.2801699590027247,0.12848467410964684,-0.14807834364326714},
{-0.5749570172475198,0.0590597836072322,-0.2238109631746514},
{-0.6211246152296068,0.045543991116269215,-0.20924073951347458},
{-0.6614268388024205,0.03360874622907503,-0.18436758645177176},
{-0.6846986789168183,0.00036789249004701586,-0.15534567508110284},
{-0.7037743463415764,-0.033082090995739714,-0.11389041997826482},
{-0.7156678126937995,-0.0693603422887245,-0.060016584257240255},
{-0.7113358624595024,-0.1102669914551743,-0.06183858959459088},
{-0.7062420493357406,-0.1551102195770745,-0.06296694409467359},
{-0.6984531597104922,-0.201444845491081,-0.0632231972702248},
{-0.6860316695734915,-0.24682579579380562,-0.06242835983420053},
{-0.675946415284241,-0.24671803583772858,-0.1242730917462878},
{-0.6584106376318241,-0.28868407313237177,-0.1202773525749511},
{-0.6335417949683643,0.06921928450621964,-0.2069551508450805},
{-0.6735562994584524,0.055950477834585226,-0.18123500452861216},
{-0.6942882374081144,0.024950330742245185,-0.148177482802858},
{-0.7108811154448573,-0.004193263170825936,-0.10790435441818515},
{-0.7211732688497756,-0.03483609980080572,-0.05767991736966568},
{-0.7216301710635423,-0.06966088480622336,2.2434114215855047e-17},
{-0.7168908881952739,-0.11051268415502993,2.990942236891944e-17},
{-0.7112043953130884,-0.15531280829449934,3.645206810213704e-17},
{-0.7027301523671899,-0.20161187342300038,4.299471383535464e-17},
{-0.6896286969073432,-0.24696049573890191,1.2544875286708835e-10},
{-0.6700584112841915,-0.28891144663969437,5.017960890679141e-10},
{-0.6670454429122775,-0.28880799708186045,-0.06040376577942507},
{-0.5867427236436659,0.08360954904074781,-0.2228314251739111},
{-0.5350190223262464,0.0975364457641447,-0.229464050470453},
{-0.2791246874287774,0.1544216334577422,-0.15156761102104174},
{-0.3215971965169827,0.15259402460267557,-0.18190096105716827},
{-0.2763455581615505,0.1826676731446564,-0.1563672394647132},
{-0.3205249849540161,0.18125601772004718,-0.18870169188519037},
{-0.3728736940166823,0.1494603650799552,-0.20688079647538735},
{-0.24883120857639934,0.15585053047532377,-0.11720188342851232},
{-0.2455035811327403,0.18387673985184083,-0.12042821651345895},
{-0.2431942852740093,0.21620149387627108,-0.1231545434022081},
{-0.2743616973701722,0.21518962788870766,-0.1604578073973977},
{-0.3200508411472771,0.21430707384843672,-0.19454766950236993},
{-0.37432845342372234,0.17851999243525107,-0.21562012891323545},
{-0.4295823709022256,0.14411331605941238,-0.22518490261463367},
{-0.4340447106833759,0.17333781614750612,-0.23530679528895024},
{-0.4883524957475227,0.1356455387108784,-0.23548998721428122},
{-0.49596034864656185,0.16458770771405035,-0.24594809095155812},
{-0.4386212760179679,0.20719383914779116,-0.24390280698521588},
{-0.5033181984475023,0.19809027805840268,-0.25457319783596455},
{-0.556364114425987,0.15114680839256092,-0.2457293382407217},
{-0.5458111819273622,0.1231499097240968,-0.2364738356132646},
{-0.3761679158739575,0.21212062433963352,-0.22312884265268373},
{-0.38002572230151554,0.25213620642928225,-0.22609655184304547},
{-0.4443034585019103,0.24753593390435333,-0.2471075880789471},
{-0.5106879018436111,0.23800241059021743,-0.2571131000007004},
{-0.5747027037511779,0.22168108764278868,-0.2534223215050618},
{-0.5661659600307547,0.18337457845652183,-0.2528425729413673},
{-0.6261225219924601,0.1642073150690984,-0.24059888673189378},
{-0.6130339977273426,0.13437580314842262,-0.2353412784748949},
{-0.5996717631737892,0.10811233113341383,-0.22804592944847918},
{-0.32233319701698887,0.25365669940952934,-0.19676967979667853},
{-0.3295315620829352,0.3012144008250103,-0.19269850865608787},
{-0.3875355136405246,0.3004428395394986,-0.22121179303407315},
{-0.45208049453199045,0.2962229596595216,-0.24105471134609965},
{-0.5183323931277165,0.2861721885562159,-0.24931451197940493},
{-0.5814603305967692,0.2679111863994004,-0.2430784433212265},
{-0.6422757394084085,0.24398093295337173,-0.22722048818492901},
{-0.6366355833073363,0.19995883569677855,-0.23937473363085857},
{-0.6967774923934941,0.1742214477873379,-0.21830873981735763},
{-0.6821458455573534,0.14174582982439976,-0.21972901603845307},
{-0.6637512210550023,0.11563311398794272,-0.2154692649747276},
{-0.6476508060175314,0.0920198903326927,-0.210121138354624},
{-0.6874616441906337,0.07635945919588442,-0.18260894396859445},
{-0.7047237115546151,0.09631250818302166,-0.18622752329366152},
{-0.726921184906925,0.11728625947412064,-0.18982455062751316},
{-0.7321637067700731,0.07780742972569164,-0.14773027898513827},
{-0.716819766624263,0.06261769407702789,-0.14542206072596803},
{-0.704921989873797,0.04538752366004535,-0.14506753047047458},
{-0.7596521939657657,0.1427318334225047,-0.1909312453764244},
{-0.7587082167505308,0.19312577688193336,-0.18814457291227207},
{-0.8129405698454237,0.17897904984813928,-0.17869617996343706},
{-0.8164513892144137,0.13888911338879736,-0.17563903000953138},
{-0.7824154070874801,0.10233090172992446,-0.15135209110888767},
{-0.7531327166231047,0.0921231243706145,-0.15047492506642055},
{-0.7663527080346362,0.07047813631311163,-0.10412068684040804},
{-0.748742576012526,0.06226618110030458,-0.10231042733826981},
{-0.7366292793499057,0.05167294637810705,-0.10097959188071835},
{-0.727503088669741,0.037667190918852976,-0.1010642912061949},
{-0.28289951869015617,0.30091482814711606,-0.15842653222534547},
{-0.2757033088233313,0.2539498064900589,-0.16181773804308996},
{-0.24461348389554394,0.2548700765149568,-0.12393041508596281},
{-0.2524702622931211,0.30192777173424024,-0.12130969295416914},
{-0.267598682526777,0.35112881247989597,-0.11675144681211028},
{-0.29601067254604985,0.3491912884696308,-0.15153528303421862},
{-0.340863599063997,0.35076027343011257,-0.1831024845674273},
{-0.39741710161278937,0.3518648129799022,-0.20888728685754188},
{-0.46093513012284093,0.34853718553624313,-0.22632715814905033},
{-0.5259370132280734,0.33810817698710705,-0.23225287813372686},
{-0.5869442347615298,0.3179128836187086,-0.22349630410290644},
{-0.6450484030782709,0.29183174144938223,-0.2061178559863619},
{-0.7013422041329176,0.2637430312983405,-0.18617795371386608},
{-0.701588974432334,0.21692348558198726,-0.20661355178431628},
{-0.7565400864342607,0.2384916407908072,-0.17024025621007158},
{-0.8113608088893343,0.2209181471537632,-0.1648694999991918},
{-0.8625995904044069,0.20871972012584206,-0.16389858279493766},
{-0.8618592795061577,0.1714304649249425,-0.17319718940482562},
{-0.8625931248070422,0.13618649369038516,-0.16756349890111785},
{-0.8226993114677607,0.10519699328170554,-0.14805571405249093},
{-0.7920944063423199,0.07624027668446322,-0.10527673564920255},
{-0.408388142740993,0.40122426086099133,-0.18953683154478745},
{-0.4698511888886554,0.3997587254583435,-0.20351006504929747},
{-0.5331892582720583,0.3893157081149174,-0.20700579802443672},
{-0.5916576552403398,0.3675320329939434,-0.19636126956314653},
{-0.6469589870995168,0.3390640077975104,-0.17804746502785326},
{-0.7007990939542893,0.3085733282255114,-0.1585342921814225},
{-0.7548805831106743,0.28071953477871764,-0.1442938139858414},
{-0.5397733915883656,0.4353011917712342,-0.17465087121230488},
{-0.5961027534285177,0.412612333019213,-0.16335978301455245},
{-0.6491680661990963,0.38213458464194333,-0.1454791735026889},
{-0.7013389713342353,0.3489024917873444,-0.12717183456476022},
{-0.7549861878676297,0.31794521160553174,-0.11460271328793406},
{-0.8124782796338532,0.2942951340453034,-0.11393352396069564},
{-0.8109071394742499,0.2601600127587788,-0.1417959382039756},
{-0.8635618868121749,0.24442167117372685,-0.1442765723928691},
{-0.9075290264911688,0.23103034143203283,-0.14497054651000527},
{-0.9070548826844298,0.19959245184611663,-0.16116579030882386},
{-0.9030343587231954,0.16742933775580193,-0.16657102970564827},
{-0.9005213965474788,0.1374397419795612,-0.15897287520265604},
{-0.8660586849944799,0.1066254592594628,-0.1423896955619601},
{-0.8286056346603433,0.07948363584247002,-0.10464461574685463},
{-0.7958175128247817,0.05995516108227634,-0.053950991849575726},
{-0.7721534264702633,0.05657268382097407,-0.05320162911501597},
{-0.7571338437922452,0.051837280311124535,-0.05230237228155306},
{-0.7477921331999265,0.04440345974114981,-0.051699132047433774},
{-0.7411627407020669,0.032925785179449954,-0.051838034630817084},
{-0.4778114168440664,0.44517200374789134,-0.17318856860833942},
{-0.4177179997381433,0.4440480674060078,-0.16292335519244042},
{-0.42267388011812645,0.475860961639072,-0.12880763069800974},
{-0.4837996376032677,0.4800571343287121,-0.13594672778811376},
{-0.5453779869039325,0.4715721153872058,-0.1362656972581018},
{-0.6007838459205044,0.44900071498730854,-0.12617828776972992},
{-0.6528319047057156,0.41749816942774615,-0.11088391720371535},
{-0.7043368533122986,0.38221540460900116,-0.09557995600160994},
{-0.7581123041934248,0.3483044240311167,-0.08546614532399917},
{-0.8169729474018267,0.32091830879369737,-0.08574071769208347},
{-0.8735458467427129,0.2971001257019888,-0.09157128563554398},
{-0.8665942519761829,0.27504489549170064,-0.11870836761446936},
{-0.9101109550387747,0.2572828219315218,-0.12246487968331504},
{-0.9365293858706223,0.24286238460929205,-0.12298536027116715},
{-0.9426900225595468,0.2214181533499607,-0.13797369256192293},
{-0.9431706319636504,0.19183373500856962,-0.15072277296539774},
{-0.9354259239203935,0.162420654997341,-0.15375298293028417},
{-0.924674713102587,0.14147858513332867,-0.14929172074869462},
{-0.9045699380972932,0.11252079093652562,-0.1361600925011463},
{-0.8701147697412199,0.08398056656952108,-0.1027522431581857},
{-0.8310927344466015,0.06333020290660929,-0.054104549786985506},
{-0.8314817478880395,0.05764338674455556,5.608011306174591e-18},
{-0.7961903622728084,0.0542641422819356,5.2165732657247365e-18},
{-0.7731997756437714,0.051554841466246615,3.73867779611493e-18},
{-0.7592825773164215,0.047901024635542355,5.608011306174591e-18},
{-0.7512124342058117,0.04168758556814012,7.477344816234253e-18},
{-0.7457608580278743,0.03129981675419469,9.068474447689815e-18},
{-0.31510034876509785,0.3918868606669156,-0.14239508355976396},
{-0.35554589307949397,0.396076567759191,-0.16874993601752605},
{-0.3343398113230929,0.42056070737945567,-0.1338831246292384},
{-0.3669943108131189,0.43375483640152873,-0.147806788553953},
{-0.3686247189485645,0.46038878714553033,-0.11843465732603368},
{-0.36620766313375647,0.47778986485285113,-0.08263981719601052},
{-0.42497132238168894,0.4975832135850821,-0.08904043530711857},
{-0.4879300767197007,0.5046598099006615,-0.09351462868343735},
{-0.5497293339303234,0.49784291507922784,-0.09335665258782841},
{-0.6050123465969676,0.4759525576017375,-0.08586087004310937},
{-0.6568578166647538,0.44410518018272854,-0.07476730584484614},
{-0.708343368479243,0.40741722553673887,-0.06381576926869244},
{-0.7625477039855558,0.3710062139778672,-0.05674617735025811},
{-0.8225484475292527,0.33998643302153,-0.057298662645065106},
{-0.8814985315011985,0.3116186245842486,-0.06267459133383657},
{-0.932545500294454,0.28316245298298415,-0.0700755451172078},
{-0.9204602212204138,0.273892941561237,-0.09812578496393005},
{-0.9536211925040019,0.24822236482456408,-0.10639690039262341},
{-0.968931727063428,0.2170172367437743,-0.11737753215691789},
{-0.9693897068767554,0.18373772950850145,-0.12662118118920654},
{-0.9579876259242437,0.1518461705075009,-0.12968048634223378},
{-0.9359679564994609,0.12641654503261623,-0.13128395448866015},
{-0.9108523435365847,0.09350320612809318,-0.10012774942792933},
{-0.8726191111204503,0.06948739127693931,-0.05372383386216532},
{-0.873484423567749,0.06427870603999941,4.673344551144761e-18},
{-0.8310927344466015,0.06333020290660929,0.054104549786985506},
{-0.7958175128247817,0.05995516108227634,0.053950991849575726},
{-0.7721534264702633,0.05657268382097407,0.05320162911501597},
{-0.7571338437922452,0.051837280311124535,0.05230237228155306},
{-0.7477921331999265,0.04440345974114981,0.051699132047433774},
{-0.7411627407020669,0.032925785179449954,0.051838034630817084},
{-0.7366292793499057,0.05167294637810705,0.10097959188071835},
{-0.727503088669741,0.037667190918852976,0.1010642912061949},
{-0.716819766624263,0.06261769407702789,0.14542206072596803},
{-0.704921989873797,0.04538752366004535,0.14506753047047458},
{-0.6874616441906337,0.07635945919588442,0.18260894396859445},
{-0.6735562994584524,0.055950477834585226,0.18123500452861216},
{-0.6476508060175314,0.0920198903326927,0.210121138354624},
{-0.6335417949683643,0.06921928450621964,0.2069551508450805},
{-0.5996717631737892,0.10811233113341383,0.22804592944847918},
{-0.5867427236436659,0.08360954904074781,0.2228314251739111},
{-0.5458111819273622,0.1231499097240968,0.2364738356132646},
{-0.5350190223262464,0.0975364457641447,0.229464050470453},
{-0.4883524957475227,0.1356455387108784,0.23548998721428122},
{-0.4802338606566784,0.10941558004220957,0.2274543272896162},
{-0.4295823709022256,0.14411331605941238,0.22518490261463367},
{-0.4242471754768512,0.11766201844096127,0.21740678898499283},
{-0.3728736940166823,0.1494603650799552,0.20688079647538735},
{-0.37016891911914857,0.12306370175923516,0.2002244639885085},
{-0.3215971965169827,0.15259402460267557,0.18190096105716827},
{-0.32110688871683213,0.12640867855582263,0.17681253593121035},
{-0.2791246874287774,0.1544216334577422,0.15156761102104174},
{-0.2801699590027247,0.12848467410964684,0.14807834364326714},
{-0.24883120857639934,0.15585053047532377,0.11720188342851232},
{-0.2504670047096489,0.13007952145958704,0.11492491555660442},
{-0.22917363738882537,0.156877482856738,0.07981445890762656},
{-0.23079542472778483,0.1312044276410753,0.07845743778074836},
{-0.2186120840937145,0.15749710260418098,0.040411061128451484},
{-0.21995369554687366,0.13187049192958747,0.03978098866526902},
{-0.21560450371960424,0.15770507931940966,-5.017960890679141e-10},
{-0.21674029365665626,0.13208881360059957,-1.2544875286708835e-10},
{0.8973909698234407,0.2188707079882994,-0.035974583736759665},
{0.8862776855532154,0.21664007689750467,-0.034877802903807535},
{0.8839920968848214,0.22870164878120794,-0.02368930218424043},
{0.8826450974338583,0.2353515156707222,-0.01461709924207035},
{0.8721740625018521,0.23435150327832724,-0.006613012984535908},
{0.8621933353699965,0.22779430995103928,-1.9277501822490256e-17},
{0.8623528201049906,0.22751952206304282,0.0064376013280336986},
{0.8627817047301772,0.22508414705570165,0.013421718049307722},
{0.8634336524644433,0.21887394078698175,0.021498757797106322},
{0.8639864610391185,0.20715827836228576,0.03122139983415743},
{0.854657681641529,0.19896852170043053,0.029662436549590863},
{0.853263267809892,0.1815060208181459,0.03939703994176652},
{0.8494517981634472,0.1585606933706614,0.050895350535055124},
{0.8578947907220833,0.13641494479726848,0.07317579905354431},
{0.868509146395672,0.11103370354266243,0.09893861831261919},
{0.8795308347032318,0.08012060494284143,0.12604143262551207},
{0.8914210682567726,0.0403260385231067,0.15311612158986884},
{0.8763777783884176,0.007199550425463242,0.1795690356076611},
{0.858999330271873,-0.019911022604267192,0.2086825429409955},
{0.8404753938222295,-0.038034846336996636,0.2408381138343848},
{0.8206303203110815,-0.04912851829521594,0.2752307814159335},
{0.7925944125385176,-0.03044014015259888,0.26571988769257376},
{0.7727719686181457,-0.03619365972746429,0.2995209531152595},
{0.7449311063660811,-0.021225586308451023,0.28553478841602026},
{0.6973292233686086,-0.013452752916657913,0.3020091305010784},
{0.6688719741677833,-0.006988556431464406,0.28463499278277693},
{0.6214522054960812,-0.006567215003203169,0.2963366464131829},
{0.9182435989239092,0.21547411417275106,-0.03714291718054696},
{0.9080775246676009,0.21875756003441854,-0.03665142402087957},
{0.9043242453974376,0.23004649303304944,-0.02542617715629019},
{0.8941635591389333,0.23073831195106403,-0.024521101285199114},
{0.8924038390561952,0.23726641009021124,-0.015176050134241966},
{0.8916893905474044,0.23997010738818422,-0.007236641402344964},
{0.8820136240912468,0.23811771374321986,-0.006955829732803801},
{0.8818778465465898,0.23853043437499497,-2.1015885433925096e-17},
{0.872024276162905,0.23471573192986767,-2.0329023473890032e-17},
{0.8721740625018521,0.23435150327832724,0.006613012984535908},
{0.8726643703020027,0.23165858197596198,0.013893491137013013},
{0.8735372259462267,0.2250388878741493,0.022508899625372513},
{0.8748357334169551,0.21289326322470592,0.03312659585759953},
{0.8765997638979363,0.1936225502794485,0.04641415276159133},
{0.8641190057850933,0.1882097676856987,0.043142344975180186},
{0.8625241584351531,0.16397778636265425,0.0571607299012865},
{0.8750555637273523,0.14089668137051267,0.07965594401223722},
{0.8892346187479694,0.11293555900746614,0.10429687436859401},
{0.9029384523622869,0.07649793073944343,0.12894233064310603},
{0.925256616865403,0.07141090649291451,0.1273485608927266},
{0.9164450852569832,0.03051416046642819,0.15162256859864104},
{0.9037897560152954,-0.008134368044431588,0.17874682714279325},
{0.8876753321835346,-0.03987042942881297,0.20943794023309556},
{0.8684843616057742,-0.0600295154519695,0.24441035637833874},
{0.8469388359877306,-0.07163731016063238,0.2819959514584502},
{0.8237618246346803,-0.07771928208162063,0.32052767895291806},
{0.7992863058109018,-0.055148312721547736,0.3110588116124284},
{0.7762677015932848,-0.05805071937852678,0.3475183151515347},
{0.7514204109210405,-0.03917289923312627,0.33400952705771675},
{0.7249761176997345,-0.024243942678168973,0.3186537333167383},
{0.6764539646773641,-0.015242645787097582,0.33381232633809577},
{0.6491712989977785,-0.008691055977525586,0.31520756992139454},
{0.6010726426027909,-0.007330694292009012,0.32449971093391783},
{-0.08522228454339678,-0.2659596535948452,0.0891276131115849},
{-0.0925233448474846,-0.23242367766410899,0.07276350946159355},
{-0.08720797725402844,-0.23245816085005364,0.09030672255097989},
{-0.07876810973411844,-0.2659531879974806,0.10613062554115704},
{-0.08074151780975732,-0.23247648004258673,0.10744109436700994},
{-0.09664710284664085,-0.23236656488738816,0.05487492571298028},
{-0.09054379445434936,-0.2659596535948452,0.07175250555367875},
{-0.08734019872013497,-0.2995074831207499,0.08964195138194062},
{-0.08082244553677116,-0.29949024152777753,0.1067854827942372},
{-0.07320209248282707,-0.299474077534366,0.12349290966429001},
{-0.07121747737175618,-0.26594456720099446,0.12269009799151606},
{-0.07316416097828796,-0.23248725603819445,0.12410283101568609},
{-0.06451653226306142,-0.23249372163555906,0.1402291084426154},
{-0.05483882612769444,-0.23250342003160598,0.1557551629141956},
{-0.04416951287650652,-0.23250665283028832,0.17061849365590198},
{-0.03254684729390501,-0.2324926440359983,0.18475444469408833},
{-0.020009321236200632,-0.23245385045181055,0.1980994376546692},
{-0.006595189487800733,-0.23237841848255664,0.21058989416355914},
{0.00762207721324136,-0.2322846673207696,0.22218163263876653},
{0.02256902968086353,-0.2321941489576649,0.23283370429698214},
{0.03817213252103882,-0.23212518258577558,0.24250300515577508},
{0.05435810896363483,-0.23209500979807401,0.25114643123271463},
{0.07105982455601555,-0.23209500979807401,0.2587273441427345},
{0.08821036036545715,-0.23211009619192483,0.2652091055007686},
{0.10574322849906011,-0.23213164818314022,0.2705550769217507},
{0.12359043242453978,-0.23214565697743023,0.27472862002061443},
{0.12402039464928719,-0.26578292726687885,0.27256048970434443},
{0.12358504442673592,-0.2994169647576452,0.2747415512153437},
{0.12231347694502684,-0.3324895728772502,0.2811317166107123},
{0.12023263219317915,-0.3644425550532145,0.29159197554711075},
{0.11737052775977291,-0.39471663711349875,0.30598224008163893},
{0.11375410363382739,-0.4227568552843058,0.3241613446718359},
{0.10946310218283958,-0.44814294573693525,0.34573488787845974},
{0.10457618817474573,-0.4704578774413692,0.370305235463586},
{0.0991709487779213,-0.48928569696714996,0.39747690838841215},
{0.0933282039594241,-0.5042072180851379,0.42685335001457453},
{0.08715506711559468,-0.5150694216577039,0.4578849845660803},
{0.0807625310011924,-0.5217182109476572,0.4900211586673758},
{0.07425943317185507,-0.5239994892178083,0.5227133741420287},
{0.06775536550291306,-0.5217591597309665,0.5554099000149249},
{0.06136132074912569,-0.5151491640252007,0.5875590053109494},
{0.0551880761453402,-0.5043214436385797,0.6186089590549882},
{0.04934694772618414,-0.4894290177087324,0.6480069526723661},
{0.0439488204864608,-0.470622750174167,0.6752001775884076},
{0.03906858759564373,-0.4483196720649017,0.6997953099634318},
{0.034781034463250385,-0.4229346592118329,0.7213979483581963},
{0.031161054258754317,-0.39488366504541816,0.7396115361343379},
{0.028283540151629066,-0.36458048779699315,0.7540427494521753},
{0.026184591727160443,-0.3325908672359625,0.76453964677364},
{0.024900308570634258,-0.2994773103330483,0.7709502865606632},
{0.02446700578724847,-0.2658023240589727,0.7731238048747372},
{0.024920782962288893,-0.2321284153844579,0.7709071825782323},
{0.026224462910908953,-0.199018091280226,0.7644566716074607},
{0.028340976208218127,-0.16703062591831688,0.753927446299173},
{0.03123336118928201,-0.13672744866989192,0.7394746809901199},
{0.03486444066925402,-0.10866783370699098,0.7212557052161747},
{0.039159321478660594,-0.08327096725875376,0.699657377219653},
{0.044042894928116055,-0.06095194067598899,0.6750708656411151},
{0.04944037560810293,-0.04212886258827562,0.6478862615215598},
{0.0552767625891916,-0.02721865626567571,0.6184925783024251},
{0.061442032956227396,-0.0163756339652916,0.5874447797575078},
{0.06782627155401175,-0.009754107944225605,0.5552967520610439},
{0.07431945546738998,-0.0075084982195361295,0.5226045365863908},
{0.08081145402125138,-0.009793009288369422,0.48992201950778486},
{0.08719375293982633,-0.016450096094940834,0.45779877660121865},
{0.0933572991475649,-0.027322213583465746,0.4267800732444421},
{0.09919465596825827,-0.04225170893820345,0.39741440761388747},
{0.1045955849668396,-0.06108103710336929,0.37024920028642594},
{0.10948142137537269,-0.08339596880780312,0.3456831630995427},
{0.11377134522679973,-0.1087799040613111,0.324113930291162},
{0.09270427381373804,-0.10879391285560112,0.31920438669229195},
{0.07199776721371011,-0.1088316288402281,0.31293383484816895},
{0.05172628755636522,-0.10894585439366976,0.3053874051240937},
{0.031963973691484356,-0.10918939189440388,0.29665238308448866},
{0.012785179988760666,-0.10961504372090818,0.286817131893337},
{-0.005735987030011655,-0.11027453465209967,0.2759667819159397},
{-0.023456238951236972,-0.11103316474288205,0.264160601128139},
{-0.040232395121275716,-0.11175192364991593,0.25145785750577726},
{-0.055921382646444404,-0.112296111428105,0.23791566382557544},
{-0.07037996699312543,-0.11252779533367063,0.2235932880633758},
{-0.08355728546205042,-0.11247930335343596,0.20845516943367295},
{-0.09540236759399494,-0.1121797306755418,0.19246574715096146},
{-0.10586424292973455,-0.11165925008768966,0.1755873052306144},
{-0.11489215652995696,-0.11095126717626351,0.15778536048668707},
{-0.12248643167453042,-0.11011828271578798,0.1389101265802324},
{-0.12864760716323528,-0.10922710787903082,0.11880966197318178},
{-0.1333750364363351,-0.10834347623919909,0.09733482688632457},
{-0.13667033589317104,-0.10753312136949973,0.07433529618093328},
{-0.13874794784633643,-0.10686393204226131,0.050192216821652424},
{-0.13982231460842454,-0.10640702982849465,0.025286735773126498},
{-0.14010895609158944,-0.10623245869964984,2.5089858333373744e-10},
{-0.05297145384883538,-0.265937024004069,0.15419048835195695},
{-0.0423554817759056,-0.2659359464045083,0.16899455111782097},
{-0.03080167480523732,-0.2659294808071436,0.18307769977752955},
{-0.018353460199129593,-0.2659122392141713,0.19637527835743654},
{-0.005053834180057157,-0.26587667842866586,0.20882047568477413},
{0.009031146398904758,-0.26583357444623507,0.2203680325779899},
{0.023835532444637007,-0.26579262566292583,0.2309737674550924},
{0.03929359038393259,-0.26576137527566346,0.24059242113452914},
{0.0553391556037602,-0.26575059928005573,0.24917873443474783},
{0.0719034772521427,-0.2657527544791773,0.2567014569684862},
{0.08891769671714686,-0.265763530474785,0.2631271831493602},
{0.10631327866670764,-0.2657753840699535,0.26842466259010755},
{0.1057356853021347,-0.2994137319589629,0.270576628912966},
{0.10404816438996822,-0.33248741767812856,0.27687304314654765},
{0.10128627671571365,-0.36444147745365385,0.28717705014663436},
{0.09748881586355869,-0.39471663711349875,0.3013496395698869},
{0.092690265019448,-0.422755777684745,0.31925395627208747},
{0.08699762981976612,-0.44814294573693525,0.3405009868117978},
{0.0805137132626105,-0.4704578774413692,0.3646995625484583},
{0.07334336578524414,-0.48928569696714996,0.3914595924410701},
{0.06559100678510565,-0.5042072180851379,0.42039098544863435},
{0.05740200444294303,-0.5150694216577039,0.4509527865916442},
{0.0489214036596359,-0.5217182109476572,0.4826029632910322},
{0.04029468037588831,-0.5239984116182475,0.5147994829677307},
{0.03166698725253603,-0.5217570045318449,0.5469992354431116},
{0.023186170949316753,-0.5151459312265184,0.5786601881381073},
{0.014999754846099956,-0.5043171332403366,0.6092338428762857},
{0.007255801122535494,-0.4894225521113678,0.6381770894790183},
{0.0001018331584928354,-0.47061628457680243,0.664942507369434},
{-0.006367578908574806,-0.4483132064675371,0.6891529367012631},
{-0.012058026581148334,-0.42292819361446826,0.7104269072299926},
{-0.01687505825772622,-0.3948793546471751,0.7283840263106709},
{-0.02072423311280255,-0.36458048779699315,0.7426460564974674},
{-0.0235453779869039,-0.3325962552337664,0.7530405818606588},
{-0.02527831972055685,-0.29948916392821673,0.7593973416696436},
{-0.02586288515428798,-0.2658195656519451,0.7615471527933805},
{-0.02523889035262826,-0.23215320017435562,0.7593175993021465},
{-0.02346785547450208,-0.19904934166748833,0.7528864851234687},
{-0.020611322230825027,-0.16706941950250462,0.7424316141848741},
{-0.016730800004525887,-0.13677486305056583,0.728129712814329},
{-0.011887819730524645,-0.10872710168283335,0.7101596625389216},
{-0.006179031313426806,-0.08334101123020383,0.6888921576075565},
{0.00029892611815774664,-0.0610326528830907,0.6647022026673822},
{0.00744944576360594,-0.04221733351221487,0.637962647166425},
{0.015175834614329843,-0.02731079102812158,0.6090452629531509},
{0.02333487968870307,-0.016469061847210392,0.5784974706044309},
{0.031783583525011386,-0.00984818238588086,0.5468645354980154},
{0.04037862538167233,-0.007604296820488622,0.514690645412093},
{0.04897690003701558,-0.009893657087345372,0.4825242985230959},
{0.057434116909853984,-0.016554731012291643,0.4509010618127272},
{0.06560620093891252,-0.027425878661211864,0.42035973506137203},
{0.07334886154300406,-0.042345567859946545,0.39143804044985475},
{0.08051780814094144,-0.06115226643433621,0.36467370015899986},
{0.08700549629655974,-0.08343799519067316,0.34046434842673157},
{0.06490899402309407,-0.0835274359542171,0.3338047831411704},
{0.043274243161418514,-0.08372894707208117,0.32581545999761846},
{0.02218389559784419,-0.0841071845179116,0.31660413895215295},
{0.0017203876987700046,-0.08472788186491535,0.30628073515997234},
{-0.018033639425488537,-0.08565569508673869,0.2949530085771537},
{-0.03690843151612328,-0.08670312185980754,0.2826942359738294},
{-0.05473440673025578,-0.08768481505966938,0.26957877171969263},
{-0.07134161684115693,-0.08841542756187173,0.2556798925848758},
{-0.08656055543791757,-0.08870745704284051,0.24106979773995044},
{-0.10031320431233788,-0.08859323148939885,0.2256471928262042},
{-0.11252197629604244,-0.08810507888836984,0.20930755068624232},
{-0.12310906870074356,-0.08727532722657663,0.1919474217622309},
{-0.13199678659810976,-0.0861363044908423,0.17346551169545743},
{-0.13923502284780467,-0.08480762423241237,0.15361828298518784},
{-0.1448762565484378,-0.08340997760209314,0.13216543092937036},
{-0.14897005727980464,-0.08206190055156934,0.10886557322639236},
{-0.1515670722212613,-0.08088623943076881,0.08347635773503659},
{-0.15299704683840368,-0.07995379253083416,0.05652117456196925},
{-0.15359188179594896,-0.07933643574246879,0.028521689654559295},
{-0.15368024495993213,-0.07910669151611255,3.7634733620082576e-10},
{-0.16640023017526615,-0.05447610611553916,2.5089858333373744e-10},
{-0.1665985084944479,-0.054753049202657146,0.03185750685488021},
{-0.1768712651072723,-0.03269092235518005,6.272459195345632e-11},
{-0.17746610006481756,-0.032999223589516465,0.034952588313325005},
{-0.1836978583247529,-0.01410146785224171,1.6824023142528167e-17},
{-0.1848174842683934,-0.014416773483723134,0.03746511944921731},
{-0.1882561044668118,0.0028118882938743253,1.2618044296885146e-17},
{-0.18995978937238983,0.002506604338308069,0.039358785157359175},
{-0.1919242533716743,0.019569261903568846,7.477344816234253e-18},
{-0.19419906604446066,0.01928334241210963,0.04059748585246477},
{-0.1960805548775658,0.03769039163739637,6.974407549231483e-18},
{-0.19883920975313807,0.0374257978412448,0.041145014189292214},
{-0.20210110362359013,0.058695231675823564,1.8693335100596613e-18},
{-0.20518627116607585,0.0584463061772856,0.04096527058255571},
{-0.20852682980446416,0.08189142430105543,9.346689102289521e-19},
{-0.21178872367491622,0.08165435239768595,0.040430026880721046},
{-0.2138932756171008,0.10658666567527506,-1.8693335100596613e-18},
{-0.21719504067130138,0.10635929216795252,0.039911270452166164},
{-0.228124055416635,0.10567156812826883,0.07865011258221412},
{-0.24770188423671197,0.10451810555842017,0.11504345150828918},
{-0.2769522467142642,0.10289340870064662,0.1479199365078339},
{-0.3168977848324629,0.10079187403723214,0.17610670821890573},
{-0.3645815653965539,0.097455733557043,0.19896043970372476},
{-0.41704881041090486,0.09212689596907721,0.2158367264249503},
{-0.47134150908120087,0.08404759326220097,0.2260954742434847},
{-0.5245038058122488,0.07245973414541235,0.22909120102242647},
{-0.5749570172475198,0.0590597836072322,0.2238109631746514},
{-0.6211246152296068,0.045543991116269215,0.20924073951347458},
{-0.6614268388024205,0.03360874622907503,0.18436758645177176},
{-0.6942882374081144,0.024950330742245185,0.148177482802858},
{-0.7188553521945584,0.019217447198968517,0.10350052829318467},
{-0.7342779571083047,0.01605881969442509,0.05316488296999371},
{-0.739702593297223,0.015123032235852056,1.1215979508366752e-17},
{-0.06260648704159585,-0.2659381016036298,0.13873340025226605},
{-0.06451297618451088,-0.2994622239391975,0.13968707586354787},
{-0.05478860998816254,-0.29945575834183286,0.15529071750350357},
{-0.0440757617147195,-0.29945360314271136,0.17023810101095005},
{-0.03242098366520702,-0.2994503703440291,0.18445918241443723},
{-0.019871129868527432,-0.2994449823462252,0.1978882281407582},
{-0.006472849609666468,-0.29943420635061757,0.21045627181802362},
{0.0077114102168292275,-0.2994201975563275,0.2221169766651203},
{0.02261903030048328,-0.29940726636159826,0.2328240059009352},
{0.03818764995471391,-0.2993975679655513,0.24253102274435512},
{0.054354660645040354,-0.2993964903659906,0.2511895352151455},
{0.07104904856040783,-0.29940080076423364,0.2587704481251653},
{0.08819969212980552,-0.29940726636159826,0.26524251108715247},
{0.08610257562459021,-0.33248526247900706,0.2714193117694885},
{0.08267203742287758,-0.36444039985409304,0.28152288525127195},
{0.07795441430578076,-0.39471555951393794,0.2954196091869673},
{0.07199539649467643,-0.422755777684745,0.3129726284323566},
{0.06492472697668131,-0.4481418681373746,0.33380155034248804},
{0.0568721487389122,-0.4704578774413692,0.3575238270732881},
{0.04796708148861761,-0.48928569696714996,0.38375691078068314},
{0.03833916045295823,-0.5042082956846987,0.4121193312201606},
{0.028168991318319174,-0.5150704992572646,0.4420798318082606},
{0.017637287531041632,-0.5217182109476572,0.4731060783619625},
{0.0069245470175546674,-0.5239973340186868,0.5046678918973673},
{-0.003788732295712685,-0.5217537717331627,0.5362329382314543},
{-0.014318173123912602,-0.5151394656291539,0.5672656503825209},
{-0.024479581374122598,-0.5043085124438503,0.5972293837693031},
{-0.03408867674545533,-0.48941285371532084,0.6255885714100984},
{-0.04296130824897073,-0.47060550858119465,0.6518076463232034},
{-0.0509878085773692,-0.4483035080714901,0.6755277678548819},
{-0.05805869361527645,-0.4229217280171037,0.6963900953513972},
{-0.06406426372740608,-0.3948771994480535,0.7140357881590128},
{-0.06889514255833987,-0.364585875794797,0.7281081608231137},
{-0.07245704014651042,-0.33261026402805643,0.7384024694271535},
{-0.07465577429030637,-0.2995107159194322,0.7447139700545858},
{-0.07539716278811641,-0.2658497384396466,0.7468411515875466},
{-0.07458702343832921,-0.23219091615898257,0.7445792701094895},
{-0.07232126260185333,-0.19909460084904068,0.7381427679330078},
{-0.06869610991946558,-0.16712653227922544,0.7277471649702555},
{-0.06380757951203056,-0.1368481398206982,0.7136058259342654},
{-0.05775168550041296,-0.10882300804374193,0.695935348336752},
{-0.05064405431748343,-0.08346277998057089,0.6750827192362837},
{-0.04260020463615656,-0.06117931418331155,0.6514003136892321},
{-0.03373597840921517,-0.042384684724002517,0.6252372739532871},
{-0.024166861981587025,-0.027490534634858087,0.5969427422861383},
{-0.014066262674591302,-0.016655702091135833,0.5670479752712453},
{-0.0036074800495911005,-0.010039240788005463,0.5360874622907504},
{0.007036078572094405,-0.007800096660680608,0.5045903047289918},
{0.01769105974912408,-0.010097107884418829,0.47309099196811166},
{0.028178366434497875,-0.016762707727520334,0.4421132373946444},
{0.03831868606130359,-0.02762911393837316,0.412182909594246},
{0.04793292158254119,-0.042528759785277516,0.3838258771525725},
{0.056841868191254565,-0.061293970776577514,0.35756800865527966},
{0.03366216283930246,-0.06158158209934714,0.3490646705212403},
{0.011073089806608627,-0.062090640131855085,0.33929623050285646},
{-0.010831114825237565,-0.06289636132344313,0.3283963109456637},
{-0.031956107214690666,-0.06407417764336519,0.3164963789960759},
{-0.052102800842898346,-0.06539057326680234,0.30369018581588025},
{-0.07107200143105219,-0.0666116013291113,0.2900704049673029},
{-0.08866478410023397,-0.06750353048556097,0.2757297100125702},
{-0.1046821162115694,-0.06783284491133242,0.26076077451390833},
{-0.1189981341363605,-0.06762659235540096,0.24496747535125704},
{-0.13148708200586534,-0.06691171280678586,0.22815584460367774},
{-0.14202385051107852,-0.06571536177441854,0.21012760395198862},
{-0.15048192946356553,-0.06406480252718649,0.19068770787569028},
{-0.15699817400754426,-0.062150015867653535,0.16954628209293543},
{-0.16170836168767175,-0.060160982598383504,0.14641129712275527},
{-0.1647482700486051,-0.05828800680180843,0.12099180108374188},
{-0.16625475423456212,-0.05672096152053609,0.09299738089426755},
{-0.16671057884876803,-0.05552202424922292,0.06307125573215616},
{0.28543295525752743,-0.23216289857040256,0.25880062091286693},
{0.3021314380512259,-0.23216289857040256,0.2512369495958193},
{0.31829866426146447,-0.23216289857040256,0.24259891151668367},
{0.33386351231723244,-0.23216289857040256,0.2329156018636007},
{0.34876240384444424,-0.23216289857040256,0.22223659021636583},
{0.36293391566813604,-0.23216289857040256,0.210609290955653},
{0.37631554701378306,-0.23216289857040256,0.19808111846213614},
{0.38884371950729996,-0.23216289857040256,0.18469948711648904},
{0.4004710187680128,-0.23216289857040256,0.17052797529279728},
{0.4111500304152476,-0.23216289857040256,0.15562908376558546},
{0.4208333400683307,-0.23216289857040256,0.14006423570981755},
{0.4294713781474663,-0.23216289857040256,0.12389700949957892},
{0.4370350494645139,-0.23216289857040256,0.10719852670588051},
{0.44349418123177176,-0.23216289857040256,0.09004303393845937},
{0.44881752306197764,-0.23216289857040256,0.07250262260793103},
{0.45297705736655147,-0.23216289857040256,0.054650030684647494},
{0.4559609305503247,-0.23216289857040256,0.03656349189672071},
{0.4577605218168113,-0.23216289857040256,0.0183207011724822},
{0.30114974485136403,-0.265791548063365,0.24924662320707638},
{0.3171898143134317,-0.265791548063365,0.24067647390026922},
{0.3326307384197111,-0.265791548063365,0.23107075141556174},
{0.34741217159479887,-0.265791548063365,0.22047579253406696},
{0.3614716130641705,-0.265791548063365,0.20894116683558042},
{0.3747465620533013,-0.265791548063365,0.1965110559020936},
{0.38717559538722734,-0.265791548063365,0.18323610691296283},
{0.3987112986852747,-0.265791548063365,0.16917774304315195},
{0.40930517996720867,-0.265791548063365,0.15439630986806407},
{0.4189109024519162,-0.265791548063365,0.138954308162224},
{0.42748105175872336,-0.265791548063365,0.12291531629971708},
{0.4349843775003678,-0.265791548063365,0.10634927049203735},
{0.44139286208826944,-0.265791548063365,0.08932966302922934},
{0.44667417753560523,-0.265791548063365,0.07192826204204039},
{0.4508003062537952,-0.265791548063365,0.054217158941086016},
{0.45376154984679234,-0.265791548063365,0.03627383313478562},
{0.45554605471942816,-0.265791548063365,0.018175548511646426},
{0.28458380680364037,-0.265791548063365,0.25674994894872083},
{0.28543295525752743,-0.2994201975563275,0.25880062091286693},
{0.3021314380512259,-0.2994201975563275,0.2512369495958193},
{0.31829866426146447,-0.2994201975563275,0.2425978339171229},
{0.33386351231723244,-0.2994201975563275,0.2329156018636007},
{0.34876240384444424,-0.2994201975563275,0.22223659021636583},
{0.36293391566813604,-0.2994201975563275,0.210609290955653},
{0.37631554701378306,-0.2994201975563275,0.19808111846213614},
{0.38884371950729996,-0.2994201975563275,0.18469948711648904},
{0.4004710187680128,-0.2994201975563275,0.17052797529279728},
{0.4111500304152476,-0.2994201975563275,0.15562908376558546},
{0.4208333400683307,-0.2994201975563275,0.14006423570981755},
{0.4294713781474663,-0.2994201975563275,0.12389700949957892},
{0.4370350494645139,-0.2994201975563275,0.10719852670588051},
{0.44349418123177176,-0.2994201975563275,0.09004303393845937},
{0.44881752306197764,-0.2994201975563275,0.07250262260793103},
{0.45297705736655147,-0.2994201975563275,0.054650030684647494},
{0.4559609305503247,-0.2994201975563275,0.03656349189672071},
{0.4577605218168113,-0.2994201975563275,0.0183207011724822},
{0.46425952476781773,-0.3324895728772502,0.018746784038810825},
{0.4749018980299864,-0.36444147745365385,0.019444206474541443},
{0.4895432432621741,-0.39471663711349875,0.0204038088834075},
{0.5080391621232376,-0.422755777684745,0.021616108389274222},
{0.5299877099770095,-0.44814294573693525,0.02305470380290273},
{0.5549858645877616,-0.4704578774413692,0.024693193935054154},
{0.5826306037197659,-0.48928569696714996,0.026505069836533536},
{0.6125189051372943,-0.5042072180851379,0.028463930318102},
{0.644090417068746,-0.5150694216577039,0.030533244754649438},
{0.6767858653420813,-0.5217171333480966,0.03267615924119749},
{0.7100459757852603,-0.5239984116182475,0.034856143152636056},
{0.7433103966266823,-0.5217570045318449,0.03703634258398676},
{0.7760209312938684,-0.5151470088260792,0.03918022691013951},
{0.807617228015218,-0.5043214436385797,0.041251157746028104},
{0.8375421678178124,-0.489431172907854,0.04321249670658635},
{0.8652364765296122,-0.47063029337109247,0.045027605406748036},
{0.8907971381110865,-0.4483326032596309,0.04666986713736216},
{0.9143222141222657,-0.4229519008048052,0.048112449669365516},
{0.9359108437227401,-0.3949019842379512,0.04932873629360709},
{0.9556610884725403,-0.3645977293899655,0.05029211030093584},
{0.9726526783467683,-0.3325639272469433,0.05098317489925791},
{0.9859685761192084,-0.2993264463945404,0.05138264105643551},
{0.9946895893645235,-0.2654122330179738,0.051471111980374754},
{0.9978986808564977,-0.23134607810333857,0.051229298638937874},
{0.9974881154238442,-0.19529067439952114,0.05039868489749604},
{0.9953501578952757,-0.15540979225496868,0.048720646861464344},
{0.9933781506990659,-0.10986504681900693,0.04593656063625789},
{0.9934665138630491,-0.0568208549998195,0.04178801784720393},
{0.9936367745936507,-0.0004465572579832641,0.03674215790389644},
{0.9958749488813708,-0.0009217786642830194,1.5188334769234748e-17},
{0.9919147704955397,0.055086781786627737,0.031266551255753706},
{0.9938490617071225,0.05491070201839785,5.608011306174591e-18},
{0.9863252615738234,0.10560842079400767,0.025828337312369713},
{0.9879082553285952,0.10568471484291023,-1.937717978186152e-18},
{0.9748908526344885,0.14694740290423858,0.020894978763206656},
{0.9761150057355237,0.14714783642254187,-8.41202234725969e-18},
{0.9597473460069817,0.17974091273760395,0.016589537478104523},
{0.9606234344498882,0.17998013984009498,-1.2851667881660172e-17},
{0.943027311222068,0.20462484179491447,0.013035075326903296},
{0.9435876629936686,0.20486191369828397,-1.5889313283515906e-17},
{0.9268676282087548,0.22223605141658542,0.010354654179442957},
{0.9271650456875274,0.22247204572039414,-1.8588700183245807e-17},
{0.9134008664978068,0.2332092477439106,0.008671271249589838},
{0.9135086264538839,0.2334905012292717,-2.0095399889115004e-17},
{0.9019125775804334,0.23872763509461595,0.007720192653249474},
{0.9018931807883396,0.23907031175494092,-2.103000198817119e-17},
{0.8916893905474044,0.23997010738818422,0.007236641402344964},
{0.8915924065869352,0.24036558642698697,-2.149735691767732e-17},
{0.8820136240912468,0.23811771374321986,0.006955829732803801},
{-0.17814606538766373,-0.0397111602137311,0.16046104019608004},
{-0.17958789359997454,-0.03728031112454519,0.1326589715282032},
{-0.17950276323467365,-0.03532834728016565,0.10199738466586601},
{-0.17856848441548573,-0.03388985962649322,0.06919008155812276},
{-0.17490895630710937,-0.042346860979419476,0.18566393872337858},
{-0.16960932166724046,-0.044913056573438144,0.20853060140292687},
{-0.19210421249832296,-0.025599886205486387,0.2009410676964208},
{-0.19319366565426185,-0.022289500354799662,0.17322843979208796},
{-0.19236606919159016,-0.01929905381370567,0.1428121145897821},
{-0.19007724772451381,-0.017000318430670208,0.10957571133694005},
{-0.1872528592757345,-0.015377992291930343,0.07422527326577862},
{-0.1619799167769859,-0.04713549790757106,0.22932180732843133},
{-0.18864296270912836,-0.0288582239973879,0.22606853425446544},
{-0.2103285762700723,-0.011959523205298347,0.2160770311270021},
{-0.20908718157606476,-0.007385544109652226,0.18557126516115233},
{-0.20546213665363305,-0.0032426048383142722,0.15225619714037406},
{-0.19989956772093614,-0.00035862513382440046,0.11617708624621965},
{-0.19414949646466523,0.0014849321947416345,0.07824288770819898},
{-0.1517534969452746,-0.04873993589360214,0.2482994131931592},
{-0.13913049569040994,-0.049713547096758216,0.26578346606665926},
{-0.1243124241302559,-0.05004361584222219,0.28208970262023725},
{-0.16022881749073398,-0.03498847237869866,0.2874572260324347},
{-0.17277638677634471,-0.033731668010972125,0.2690313511428213},
{-0.18235193647335066,-0.03169274188203842,0.24872614261922427},
{-0.10750036234285229,-0.04971710317530875,0.2975360147243204},
{-0.08889614472593138,-0.0487212934212008,0.3124424494484576},
{-0.10785758659724767,-0.03420333333872134,0.33620244216388456},
{-0.12745793724814475,-0.03521067340812953,0.32056862773622735},
{-0.1450184996904595,-0.035476948259595895,0.3044779110948035},
{-0.18228297010146136,-0.023704173058179064,0.30976138174126083},
{-0.19479282340244514,-0.022130985459410328,0.29026652808736314},
{-0.20375198615069043,-0.019624596641014413,0.2684720769707814},
{-0.20874127211705745,-0.016136622382712722,0.24372608065724952},
{-0.06873026982554199,-0.04732871150881719,0.3266904708409641},
{-0.047233451707645056,-0.04581177460712067,0.34016477574883736},
{-0.0635957234383831,-0.031148123064025042,0.3655217710133261},
{-0.08648232170980563,-0.03275062137084673,0.3512349560366319},
{-0.1050702675733589,-0.02189391355604084,0.3768699719877994},
{-0.12768315555634577,-0.023310094898805325,0.3609236536875187},
{-0.14830625595037006,-0.024245128037685817,0.34444069080597445},
{-0.16664700047468256,-0.024392759177511363,0.32760212006937584},
{-0.2052864879252275,-0.01611366951206831,0.33246532688713276},
{-0.2180366459282631,-0.014182287819299491,0.31192520165928783},
{-0.22679645275776583,-0.011168672887648935,0.2886878447308345},
{-0.23106590221753823,-0.006984892592957786,0.26192565963910114},
{-0.23132668131124468,-0.001476419158211554,0.23177011353050173},
{-0.024636296678245444,-0.04444289988507401,0.35274790581995363},
{-0.03946201919528094,-0.02969153173773167,0.3789195663523847},
{-0.05504238468472397,-0.0188440912791484,0.40642745034017125},
{-0.08075908268259786,-0.02030305332447547,0.392098608980607},
{-0.09843979747593852,-0.013496287938913042,0.4194243786426233},
{-0.12420574177373962,-0.01499609100759331,0.403142926878943},
{-0.14810151203382366,-0.016293844158629122,0.3861782769937343},
{-0.16981729838246915,-0.01708146167759622,0.36876534569124514},
{-0.1890459849448565,-0.017050750090114263,0.3511368944766018},
{-0.2292275173668639,-0.012470089877191368,0.3553427655622888},
{-0.24274492625716804,-0.010129974671022331,0.3339243966924159},
{-0.2521006456437768,-0.006562365805179701,0.30950491304579747},
{-0.25677958293664194,-0.0016391366918878892,0.28109076782740305},
{-0.2572504939446986,0.0052354097060469985,0.24919705362728095},
{-0.25398213447688195,0.014656862665862773,0.2143399406350402},
{-0.2280615546421103,0.005511167433648149,0.19835051835232873},
{-0.22125543581628432,0.011990558072648524,0.16180049645011765},
{-0.21089108324079445,0.01597487468864107,0.12224828217160019},
{-0.20064634421655006,0.01817031137778108,0.08130887397850296},
{-0.001169518803304105,-0.043494612271596046,0.36432348030174944},
{-0.01434517776890551,-0.028676432951485937,0.391281788513543},
{-0.028212310820662077,-0.01782360449509881,0.4196733041411613},
{-0.04252929858505786,-0.011123736985964808,0.44900233138664974},
{-0.07111144157497638,-0.012102843946880814,0.4347887931800879},
{-0.08740323829444004,-0.009669516378705124,0.46352298546803117},
{-0.11635392033414205,-0.010947764977691002,0.44703032419043987},
{-0.14360037866848563,-0.01229497994856618,0.42960015129497836},
{-0.1688388379812896,-0.013407278215193403,0.41154066025602687},
{-0.19176045823843718,-0.013980561181523262,0.3931568117492835},
{-0.21206135636379111,-0.013710838011462433,0.37475572164956783},
{-0.25409851522944515,-0.01302634677046106,0.3781641690602847},
{-0.2691536586929687,-0.010218230075049423,0.3561822156201289},
{-0.28027664135924096,-0.0060432860967565925,0.3310547490620843},
{-0.28704073380219686,-0.0003359955430482214,0.30164382424997727},
{-0.29025198049329276,0.007561623877882102,0.26953566773726184},
{-0.2907142707048632,0.01830782385773099,0.2363100404800275},
{-0.29265933791205384,0.03305827604544668,0.2078560240778846},
{-0.24603052731795705,0.029196331635575223,0.1734191749143443},
{-0.22210673946929296,0.03397282401667692,0.125140559392708},
{-0.20741474705774907,0.03629796058895127,0.08271632676482521},
{0.0230568590020243,-0.042884259880375676,0.37473524725791324},
{0.011624928541679156,-0.028017480820074825,0.40242955596971297},
{-0.0004212336683051246,-0.01715775572649877,0.43163681446483443},
{-0.012869750002289867,-0.010481164367877407,0.46184300775279},
{-0.025508387226781334,-0.008164002032352773,0.4925384312413354},
{-0.057054801864462726,-0.008764440507614052,0.4787699416533718},
{-0.07154722283735193,-0.0109332173836206,0.5084815167429337},
{-0.10365203879142895,-0.011746374012177953,0.49214402980209343},
{-0.13421771929285758,-0.012876991471338277,0.4744444570164393},
{-0.16296699797465158,-0.014028083322153244,0.4557890534203818},
{-0.1896214231103079,-0.01490244760576236,0.4365819188492098},
{-0.2139051292122693,-0.015203097883217307,0.41722823073777315},
{-0.23554009559385702,-0.014632832195657601,0.3981342441204821},
{-0.25933780429391096,-0.019692700933255102,0.4209599580167211},
{-0.2796677976074056,-0.01767575783536111,0.40053944634012173},
{-0.29685012260389,-0.01436019950678269,0.3781566258633593},
{-0.3106099913953675,-0.009546346748909069,0.35254316190340723},
{-0.3206747712929632,-0.00303430484321735,0.3224264093789955},
{-0.3280843458728206,0.005710200072522445,0.29047019440434874},
{-0.3338796763106439,0.017221441860540296,0.2593394206932521},
{-0.3399562602338283,0.03215814635633954,0.23277120352245745},
{-0.3482106728693297,0.05117897473944989,0.21450589096739886},
{-0.3003156827913277,0.05296875984993349,0.19005946733176113},
{-0.2601524695618534,0.05377782160015991,0.15930908626561643},
{-0.2326004039920753,0.05560790893421631,0.1222073333882909},
{-0.2151249719150614,0.057487889127936384,0.08175834075530031},
{-0.03812504142023308,-0.010382564008066912,0.5232112251391047},
{-0.05052347092663322,-0.016975102600948182,0.5533495296547317},
{-0.08579847702854072,-0.01746638024070342,0.5376521368529891},
{-0.11965353018922106,-0.01816886739436965,0.5202090327627983},
{-0.15185048090574396,-0.01912189644591501,0.5012734532809404},
{-0.18215258055460815,-0.020038179352438103,0.4813626461965854},
{-0.21032534347138998,-0.020630320311081442,0.4609949368984637},
{-0.23613277535228075,-0.02061092351898758,0.4406875731757452},
{-0.258323783107226,-0.03006578206518723,0.4632438871817916},
{-0.2833100841228097,-0.02876641251481026,0.4429192818661007},
{-0.30570368059517977,-0.026311425195463096,0.4220795839603616},
{-0.3254226749577177,-0.022468920681667937,0.39930559484303957},
{-0.34238301444468333,-0.01700667626807876,0.3731781158925999},
{-0.3565049566885796,-0.009693008049129922,0.3422757932883867},
{-0.36850402779775826,-0.00011120827467151228,0.30968918257068917},
{-0.37910114187837457,0.012155107525578168,0.278504528881554},
{-0.3890129026383409,0.02752224192433419,0.2518102325621492},
{-0.3989569913851303,0.046406825084578086,0.23269684915276428},
{-0.3569747900970755,0.0732795718912465,0.2035628674277752},
{-0.30971666135948883,0.07616969391323275,0.1803373640944904},
{-0.2700771615165489,0.07790516800585352,0.15152127423992864},
{-0.24144318598775735,0.07956230061040627,0.11749391290948111},
{-0.22246450252346875,0.08089432142747459,0.0799109040683155},
{-0.4084603419115646,0.06815838773864116,0.22081954679395271},
{-0.4615245770825824,0.06013889180738769,0.2316989919594909},
{-0.513518755889755,0.048553511169588844,0.2357895598921754},
{-0.5632068716368791,0.034889667274971614,0.2317755015283056},
{-0.6093550728268723,0.020634393637421148,0.2183356798063769},
{-0.6503792881054021,0.008292236380084448,0.19351209632446953},
{-0.6846986789168183,0.00036789249004701586,0.15534567508110284},
{-0.7108811154448573,-0.004193263170825936,0.10790435441818515},
{-0.7274955454728156,-0.006445769532704342,0.05525402523845931},
{-0.7334104894618845,-0.006994806508916874,1.5422066113965852e-17},
{0.38218523182129954,-0.00758576210804337,0.49238110170546295},
{0.3949418554216998,-0.009826630394665454,0.5231788971522815},
{0.407487269508189,-0.01643651834047513,0.5534637552081734},
{0.4196037989694916,-0.027262622327755146,0.582717350484408},
{0.43108023429169656,-0.04215246201865648,0.6104235127913762},
{0.44170105556264977,-0.060953341555417984,0.6360639167403476},
{0.4513100108460396,-0.08325157046665989,0.6592624800846131},
{0.4597508482055543,-0.10863227292148556,0.6796409653783425},
{0.4668683933044429,-0.1366811118887788,0.6968232903748268},
{0.472505316606833,-0.16698644433632528,0.7104312176282357},
{0.4766045053360037,-0.1989814528951598,0.720328969593912},
{0.4791099243147949,-0.23210470819412096,0.7263775359285163},
{0.4799644607664858,-0.265791548063365,0.728440061487831},
{0.4791099243147949,-0.2994783879326091,0.7263775359285163},
{0.4766045053360037,-0.33260164323157027,0.720328969593912},
{0.472505316606833,-0.3645977293899655,0.7104312176282357},
{0.4668683933044429,-0.3949019842379512,0.6968232903748268},
{0.4597508482055543,-0.4229519008048052,0.6796409653783425},
{0.4513100108460396,-0.4483326032596309,0.6592624800846131},
{0.44170105556264977,-0.47063029337109247,0.6360639167403476},
{0.43108023429169656,-0.489431172907854,0.6104235127913762},
{0.4196037989694916,-0.5043214436385797,0.582717350484408},
{0.407487269508189,-0.5151470088260792,0.5534637552081734},
{0.3949418554216998,-0.5217570045318449,0.5231788971522815},
{0.38218523182129954,-0.5239984116182475,0.4923800241059022},
{0.3694296858204601,-0.5217171333480966,0.46158653905732666},
{0.35689073733133553,-0.5150694216577039,0.4313146121961641},
{0.3447839062660798,-0.5042072180851379,0.40208364651070566},
{0.3333214797381649,-0.48928569696714996,0.3744119673896821},
{0.3227200552593055,-0.4704578774413692,0.3488168226222631},
{0.31313265196713114,-0.44814294573693525,0.32567213925603605},
{0.30471552179795336,-0.422755777684745,0.3053507667390275},
{0.2976216838894017,-0.39471663711349875,0.28822663211882477},
{0.2920073901777878,-0.36444147745365385,0.27467150724389366},
{0.28792544304158946,-0.3324895728772502,0.26481793686020894},
{0.41395394447237227,-0.007585654348087289,0.47799083717093477},
{0.42869873926239394,-0.009826630394665454,0.50788883698451},
{0.4431967637529991,-0.01643651834047513,0.5372879082014487},
{0.4572012476447715,-0.027262622327755146,0.5656869670259922},
{0.4704654206382946,-0.04215246201865648,0.5925838520628219},
{0.48274035723503045,-0.060953341555417984,0.6174742467174971},
{0.4938460983083303,-0.08325157046665989,0.639994999938038},
{0.503601607131985,-0.10863227292148556,0.6597775726746613},
{0.5118269245793456,-0.13668218948833957,0.6764577362758267},
{0.5183420915237635,-0.16698644433632528,0.6896680292913113},
{0.523080296792471,-0.1989814528951598,0.6992769845747011},
{0.5259758068122612,-0.23210470819412096,0.7051488245813391},
{0.5269628880099269,-0.265791548063365,0.7071510045652506},
{0.5259758068122612,-0.2994783879326091,0.7051488245813391},
{0.523080296792471,-0.33260164323157027,0.6992769845747011},
{0.5183420915237635,-0.3645977293899655,0.6896680292913113},
{0.5118269245793456,-0.3949019842379512,0.6764577362758267},
{0.503601607131985,-0.4229519008048052,0.6597775726746613},
{0.4938460983083303,-0.4483326032596309,0.639994999938038},
{0.48274035723503045,-0.47063029337109247,0.6174742467174971},
{0.4704654206382946,-0.489431172907854,0.5925838520628219},
{0.4572012476447715,-0.5043214436385797,0.5656869670259922},
{0.4431967637529991,-0.5151470088260792,0.5372879082014487},
{0.42869766166283313,-0.5217570045318449,0.5078877593849493},
{0.41395394447237227,-0.5239984116182475,0.477989759571374},
{0.3992123824810329,-0.5217171333480966,0.4480960701560418},
{0.3847197459882316,-0.5150694216577039,0.4187099301338325},
{0.37072603809206695,-0.5042072180851379,0.3903335009000651},
{0.35747910669151617,-0.48928569696714996,0.36347002144961926},
{0.3452257220859957,-0.4704578774413692,0.338622730777375},
{0.33414584340215425,-0.44814294573693525,0.31615477993531166},
{0.3244172745675189,-0.422755777684745,0.29642716477628767},
{0.31621889710917755,-0.39471663711349875,0.2798030363522824},
{0.3097295925542181,-0.36444147745365385,0.26664339051615404},
{0.3050118616771652,-0.3324895728772502,0.2570786168147558},
{0.4447140239345639,-0.007585438828175136,0.4615563662696251},
{0.4613823339405607,-0.009826307114797228,0.4904263361022254},
{0.4777726232598788,-0.0164361950606069,0.5188146189311613},
{0.4936047160067178,-0.027262406807842986,0.5462373725536469},
{0.5085995138948382,-0.04215235425870042,0.5722085995677748},
{0.5224768410384396,-0.06095323379546191,0.5962444577707591},
{0.5350308759214151,-0.08325157046665989,0.6179904169071061},
{0.5460601074259003,-0.10863227292148556,0.6370930243208833},
{0.5553587140357882,-0.13668218948833957,0.653198827356158},
{0.5627241070336539,-0.16698644433632528,0.6659554509565582},
{0.5680808544502438,-0.1989814528951598,0.6752335831747914},
{0.5713535243163035,-0.23210470819412096,0.6809028344640047},
{0.5724699174612616,-0.265791548063365,0.6828360480760268},
{0.5713535243163035,-0.2994783879326091,0.6809028344640047},
{0.5680808544502438,-0.33260164323157027,0.6752335831747914},
{0.5627241070336539,-0.3645977293899655,0.6659554509565582},
{0.5553587140357882,-0.3949019842379512,0.653198827356158},
{0.5460601074259003,-0.4229519008048052,0.6370930243208833},
{0.5350308759214151,-0.4483326032596309,0.6179904169071061},
{0.5224768410384396,-0.47063029337109247,0.5962444577707591},
{0.5085995138948382,-0.489431172907854,0.5722085995677748},
{0.4936047160067178,-0.5043214436385797,0.5462373725536469},
{0.4777726232598788,-0.5151470088260792,0.5188146189311613},
{0.4613823339405607,-0.5217570045318449,0.4904252585026646},
{0.4447140239345639,-0.5239984116182475,0.4615552886700643},
{0.42804786912768855,-0.5217171333480966,0.43268962923570714},
{0.4116651230052959,-0.5150694216577039,0.40431320000193965},
{0.3958448838536254,-0.5042072180851379,0.3769119983706695},
{0.3808684051580381,-0.48928569696714996,0.35097309934336474},
{0.36701694040389515,-0.4704578774413692,0.3269803451228113},
{0.35449092310949976,-0.44814294573693525,0.3052839555662597},
{0.34349294199227687,-0.422755777684745,0.286235228130521},
{0.3342245081700905,-0.39471663711349875,0.2701822274737241},
{0.32688821036036547,-0.36444147745365385,0.2574751734531193},
{0.3215562477336734,-0.3324895728772502,0.24823906761775605},
{0.47432645986453503,-0.007585331068219064,0.443133724178694},
{0.49284716351549623,-0.009826199354841149,0.4708517400808307},
{0.5110585960925162,-0.01643608730065082,0.4981074657713969},
{0.5286504089220934,-0.027262299047886913,0.5244364558397007},
{0.5453111757311648,-0.042152246498744335,0.5493710320763673},
{0.5607305478462288,-0.060953126035505824,0.5724467490707051},
{0.5746800741604018,-0.08325157046665989,0.5933252405606319},
{0.586934536365483,-0.10863227292148556,0.6116649074853837},
{0.5972676385537106,-0.1366811118887788,0.6271284611824393},
{0.6054509296182011,-0.16698644433632528,0.639375380190595},
{0.6114025119923361,-0.1989814528951598,0.6482828181599233},
{0.6150394105099363,-0.23210470819412096,0.6537268511409355},
{0.6162797276043831,-0.265791548063365,0.6555824775845822},
{0.6150394105099363,-0.2994783879326091,0.6537268511409355},
{0.6114025119923361,-0.33260164323157027,0.6482828181599233},
{0.6054509296182011,-0.3645977293899655,0.639375380190595},
{0.5972676385537106,-0.3949019842379512,0.6271284611824393},
{0.586934536365483,-0.4229519008048052,0.6116649074853837},
{0.5746800741604018,-0.4483326032596309,0.5933252405606319},
{0.5607305478462288,-0.47063029337109247,0.5724467490707051},
{0.5453111757311648,-0.489431172907854,0.5493710320763673},
{0.5286504089220934,-0.5043214436385797,0.5244364558397007},
{0.5110585960925162,-0.5151470088260792,0.4981074657713969},
{0.49284716351549623,-0.5217570045318449,0.4708517400808307},
{0.47432645986453503,-0.5239984116182475,0.443133724178694},
{0.4558089890122561,-0.5217171333480966,0.4154200186748004},
{0.43760509963216143,-0.5150694216577039,0.3881761465794027},
{0.42002729559687435,-0.5042072180851379,0.3618687085023144},
{0.4033870031794575,-0.48928569696714996,0.3369643050533493},
{0.38799564865297365,-0.4704578774413692,0.3139295368423208},
{0.37407737272606295,-0.44814294573693525,0.29309953733262856},
{0.3618573937069264,-0.422755777684745,0.274810517587233},
{0.3515587747046435,-0.39471663711349875,0.2593986886690945},
{0.34340781162697603,-0.36444147745365385,0.24719918404161256},
{0.33748209164229953,-0.3324895728772502,0.2383316172560328},
{0.3527279702280794,-0.3324895728772502,0.22740475770982074},
{0.3672292275173669,-0.3324895728772502,0.21550590335979378},
{0.38092120753651587,-0.3324895728772502,0.2026867789848689},
{0.3937414095110015,-0.3324895728772502,0.18899479896571997},
{0.4056391862614677,-0.3324895728772502,0.1744935416764324},
{0.41656604580767975,-0.3324895728772502,0.15924766309065252},
{0.4264745737689638,-0.3324895728772502,0.14332074158246574},
{0.43531304536640275,-0.3324895728772502,0.12677743312551826},
{0.44305236541185594,-0.3324895728772502,0.10969101448994249},
{0.44966236111762165,-0.3324895728772502,0.0921368098850363},
{0.4551096268973161,-0.3324895728772502,0.07418852712075634},
{0.45936614516235924,-0.3324895728772502,0.05592084384666405},
{0.4624189847180219,-0.3324895728772502,0.037413610190212485},
{0.47299346920786195,-0.36444147745365385,0.03880565330281571},
{0.4875399856787019,-0.39471663711349875,0.0407207632422169},
{0.5059173685880807,-0.422755777684745,0.04314018977605865},
{0.5277247508993916,-0.44814294573693525,0.046011238285819274},
{0.5525612655760281,-0.4704578774413692,0.04928110639302103},
{0.5800282007805053,-0.48928569696714996,0.052897207239098326},
{0.6097246894762167,-0.5042072180851379,0.05680673844557341},
{0.6410925350906828,-0.5150694216577039,0.06093642324231389},
{0.6735778514496678,-0.5217171333480966,0.06521320037909953},
{0.7066235195802534,-0.5239984116182475,0.06956379308579794},
{0.7396745757086429,-0.5217570045318449,0.07391492459227675},
{0.7721739008619181,-0.5151470088260792,0.07819364140827176},
{0.8035676088658427,-0.5043214436385797,0.08232666676365062},
{0.8332996583470593,-0.489431172907854,0.08624104716814918},
{0.8608150855317711,-0.47063029337109247,0.08986350585163502},
{0.8862076415817653,-0.4483326032596309,0.09314091715576217},
{0.9095678448601464,-0.4229519008048052,0.09601993990227249},
{0.9309894465287015,-0.3949019842379512,0.09844744843282002},
{0.950565120149657,-0.3645977293899655,0.10036999380919052},
{0.9673465781095348,-0.33251866806539093,0.10175039884653743},
{0.9803866103944177,-0.2991486424670133,0.10255094756023378},
{0.9887347741917061,-0.26496610679981486,0.10273457052538906},
{0.9914438594874829,-0.23045382566702066,0.1022635517573763},
{0.9903910447166102,-0.19385531178457494,0.1007066359119752},
{0.9874502755152678,-0.15341838826666496,0.09763245988500935},
{0.9850677028864043,-0.10753635416818205,0.09200501945875407},
{0.9856916330320904,-0.054604879263051215,0.08278863369535291},
{0.9868608285555263,0.001260360446277078,0.07176963938669499},
{0.9861162072590339,0.055944551037001,0.06073448108462551},
{0.981501925939815,0.10564484365916171,0.050174544188855794},
{0.9710589085963889,0.14655838946280045,0.04058132185905321},
{0.9569800703349233,0.1790296970274955,0.03224490389697717},
{0.9414550934629039,0.20340176629344006,0.025455164584474915},
{0.9263740876099219,0.22046555533823967,0.020469542456614493},
{0.9136293176046901,0.23100878944081743,0.017545691568376116},
{0.902534352526998,0.2362146729188993,0.01600677163563988},
{0.8924038390561952,0.23726641009021124,0.015176050134241966},
{0.8826450974338583,0.2353515156707222,0.01461709924207035},
{0.8839920968848214,0.22870164878120794,0.02368930218424043},
{0.8862776855532154,0.21664007689750467,0.034877802903807535},
{0.88972492654812,0.19763768624287908,0.048888105833208066},
{0.8925525477955816,0.17308996824852896,0.06536481863729993},
{0.8772129180480146,0.16902526270530294,0.06203589807416794},
{0.892982510020329,0.1443902591465304,0.08395287226080926},
{0.9097413383894306,0.11274439284538547,0.10666630028281601},
{0.929217872850795,0.11121075315049701,0.10531186539488367},
{0.9468538672623636,0.10908497249696521,0.09949864680435157},
{0.9455639805881215,0.06590448049733375,0.12036140534069119},
{0.9395940790214534,0.01972820783878248,0.14397484451585338},
{0.9300885732958976,-0.02654440222050166,0.17142561572691903},
{0.9156929207635656,-0.06473657809337077,0.20420403916643365},
{0.8950504235774475,-0.0866718714725452,0.24380690062430732},
{0.8707764158715329,-0.09779162134013515,0.2864378168479459},
{0.845486231779812,-0.10353630459860225,0.32830687018211974},
{0.819064568149282,-0.10608374996026353,0.36929552467514415},
{0.7989910435312507,-0.08048515687425006,0.3592544519678854},
{0.77266636386119,-0.08214487571774866,0.39742949400773825},
{0.7513967037307037,-0.059792120268731784,0.3838064803604786},
{0.7279966292685739,-0.04096042138453224,0.36853473938524023},
{0.7028723955092117,-0.026054848740043657,0.35172957423502554},
{0.6535323444202165,-0.016137699982273494,0.3649344792527062},
{0.6275190910232186,-0.009542359630534215,0.34488035142676876},
{0.5789290492285195,-0.007585223308262983,0.3513998287694298},
{0.5026737939101616,-0.007585223308262983,0.42281666205992857},
{0.5229671488385902,-0.009826091594885067,0.44926311048035616},
{0.5429221375049368,-0.016435979540694746,0.4752698982799895},
{0.5621982384479981,-0.027262191287930834,0.5003908992406695},
{0.5804538526070098,-0.04215213873878825,0.5241821423433588},
{0.5973495361203291,-0.060953126035505824,0.5462007341685807},
{0.6126342082902967,-0.08325049286709911,0.5661212396489828},
{0.626062176417057,-0.10863227292148556,0.5836203789163336},
{0.637383437402511,-0.1366811118887788,0.5983748721024021},
{0.6463501433476816,-0.16698644433632528,0.6100603617393966},
{0.6528717758894642,-0.1989814528951598,0.6185593894751928},
{0.656857816664754,-0.23210470819412096,0.6237534193581062},
{0.6582166697108854,-0.265791548063365,0.625523915436452},
{0.656857816664754,-0.2994783879326091,0.6237534193581062},
{0.6528717758894642,-0.33260164323157027,0.6185593894751928},
{0.6463501433476816,-0.3645977293899655,0.6100603617393966},
{0.637383437402511,-0.3949019842379512,0.5983748721024021},
{0.626062176417057,-0.4229519008048052,0.5836203789163336},
{0.6126342082902967,-0.4483326032596309,0.5661212396489828},
{0.5973495361203291,-0.47063029337109247,0.5462007341685807},
{0.5804538526070098,-0.489431172907854,0.5241821423433588},
{0.5621982384479981,-0.5043214436385797,0.5003908992406695},
{0.5429221375049368,-0.5151470088260792,0.4752698982799895},
{0.5229671488385902,-0.5217570045318449,0.44926311048035616},
{0.5026737939101616,-0.5239984116182475,0.42281666205992857},
{0.48238259418085466,-0.5217171333480966,0.39637344643818323},
{0.4624362263109942,-0.5150694216577039,0.3703785122337184},
{0.4431752117617837,-0.5042072180851379,0.34527798566469303},
{0.42494222719354824,-0.48928569696714996,0.3215147601505838},
{0.4080767164679304,-0.4704578774413692,0.2995360395091103},
{0.39282652748390745,-0.44814294573693525,0.27966187080982147},
{0.3794362753417742,-0.422755777684745,0.26221122352270526},
{0.36815273034094714,-0.39471663711349875,0.2475052223168714},
{0.3592205075817212,-0.36444147745365385,0.2358649918614293},
{0.3742605646513939,-0.36444147745365385,0.22352432169148648},
{0.3884622492627873,-0.36444147745365385,0.2102278207111403},
{0.4017598278426942,-0.36444147745365385,0.19602613609974692},
{0.41410049801263704,-0.36444147745365385,0.1809860790300742},
{0.4254336125932595,-0.36444147745365385,0.16517230547576828},
{0.435710679604327,-0.36444147745365385,0.14865378180871852},
{0.444877819067801,-0.36444147745365385,0.13149408640301039},
{0.4529059357955406,-0.36444147745365385,0.11377296162614084},
{0.45976054660160126,-0.36444147745365385,0.09556486960775915},
{0.4654114786982813,-0.36444147745365385,0.07694879839566977},
{0.46982532649919695,-0.36444147745365385,0.058001473078599576},
{0.5296353349206374,-0.007585223308262983,0.4006946206768726},
{0.5516151331616718,-0.009826091594885067,0.425757431261271},
{0.5732285475520441,-0.016435979540694746,0.45040321081565127},
{0.5941070390419709,-0.027262191287930834,0.47420954031219137},
{0.6138799133825473,-0.04215213873878825,0.4967572335217516},
{0.6321786315239899,-0.060953126035505824,0.5176227938169492},
{0.6487348711756665,-0.08325049286709911,0.5365012605220862},
{0.6632781548478242,-0.10863227292148556,0.5530844401627822},
{0.6755401602498307,-0.1366811118887788,0.5670673720633392},
{0.6852525650910545,-0.16698644433632528,0.5781418627493767},
{0.6923162302119046,-0.1989814528951598,0.5861958418665748},
{0.6966320164527902,-0.23210470819412096,0.5911183166601741},
{0.6981040174528025,-0.265791548063365,0.5927961391762937},
{0.6966320164527902,-0.2994783879326091,0.5911183166601741},
{0.6923162302119046,-0.33260164323157027,0.5861958418665748},
{0.6852525650910545,-0.3645977293899655,0.5781418627493767},
{0.6755401602498307,-0.3949019842379512,0.5670673720633392},
{0.6632781548478242,-0.4229519008048052,0.5530844401627822},
{0.6487348711756665,-0.4483326032596309,0.5365012605220862},
{0.6321786315239899,-0.47063029337109247,0.5176227938169492},
{0.6138799133825473,-0.489431172907854,0.4967572335217516},
{0.5941070390419709,-0.5043214436385797,0.47420954031219137},
{0.5732285475520441,-0.5151470088260792,0.45040321081565127},
{0.5516151331616718,-0.5217570045318449,0.425757431261271},
{0.5296353349206374,-0.5239984116182475,0.4006946206768726},
{0.5076576918787248,-0.5217171333480966,0.3756350428911565},
{0.48605397588439947,-0.5150694216577039,0.351000039332384},
{0.4651927259874449,-0.5042072180851379,0.327212029028377},
{0.44544355883720543,-0.48928569696714996,0.3046934310069575},
{0.4271771686825861,-0.4704578774413692,0.2838645090968261},
{0.4106597226150971,-0.44814294573693525,0.26502914637411995},
{0.396156310126688,-0.422755777684745,0.24849230351453708},
{0.38393525350799074,-0.39471663711349875,0.23455570839509327},
{0.5550936245438386,-0.007585223308262983,0.3768581183926309},
{0.5786661149356916,-0.009826091594885067,0.4004306087844839},
{0.6018452814878632,-0.016435979540694746,0.42361085293621636},
{0.6242356451615511,-0.027262191287930834,0.4460012166099041},
{0.6454417269179522,-0.04215213873878825,0.4672062207667444},
{0.6650658925191423,-0.060953126035505824,0.4868314639674953},
{0.6828215004819564,-0.08325049286709911,0.5045870719303095},
{0.6984186765245475,-0.10863227292148556,0.5201842479729005},
{0.7115686239646289,-0.1366811118887788,0.5333341954129819},
{0.7219847013190358,-0.16698644433632528,0.5437502727673889},
{0.7295602262312518,-0.1989814528951598,0.5513247200800442},
{0.7341895939443216,-0.23210470819412096,0.5559540877931138},
{0.7357671997012893,-0.265791548063365,0.5575327711496424},
{0.7341895939443216,-0.2994783879326091,0.5559540877931138},
{0.7295602262312518,-0.33260164323157027,0.5513247200800442},
{0.7219847013190358,-0.3645977293899655,0.5437502727673889},
{0.7115686239646289,-0.3949019842379512,0.5333341954129819},
{0.6984186765245475,-0.4229519008048052,0.5201842479729005},
{0.6828215004819564,-0.4483326032596309,0.5045870719303095},
{0.6650658925191423,-0.47063029337109247,0.4868314639674953},
{0.6454417269179522,-0.489431172907854,0.4672062207667444},
{0.6242356451615511,-0.5043214436385797,0.4460012166099041},
{0.6018452814878632,-0.5151470088260792,0.42361085293621636},
{0.5786661149356916,-0.5217570045318449,0.4004306087844839},
{0.5550936245438386,-0.5239984116182475,0.3768581183926309},
{0.531524366950668,-0.5217171333480966,0.3532899383990211},
{0.5083548987945433,-0.5150694216577039,0.3301204702428963},
{0.48598177671382786,-0.5042072180851379,0.3077473481621809},
{0.464802634946446,-0.48928569696714996,0.2865682063947991},
{0.4452129525312006,-0.4704578774413692,0.26697852397955363},
{0.4274982933516957,-0.44814294573693525,0.2492638648000487},
{0.41194422129153546,-0.422755777684745,0.23370979273988846},
{0.3988373778338848,-0.39471663711349875,0.2206029492822379},
{0.6039918598129179,-0.009826091594885067,0.3733807046100248},
{0.6286376393672982,-0.016435979540694746,0.3949941190003971},
{0.6524450464633991,-0.027262191287930834,0.4158715328907632},
{0.6749916620733986,-0.04215213873878825,0.43564548483090043},
{0.6958572223685962,-0.060953126035505824,0.45394420297234284},
{0.7147356890737331,-0.08325049286709911,0.4704993650244588},
{0.7313199463139899,-0.10863227292148556,0.48504372629617715},
{0.7453018006149862,-0.1366811118887788,0.49730573169818376},
{0.7563762913010237,-0.16698644433632528,0.5070181365394075},
{0.7644302704182218,-0.1989814528951598,0.5140807240606969},
{0.7693527452118211,-0.23210470819412096,0.5183975879011432},
{0.7710305677279407,-0.265791548063365,0.5198695889011555},
{0.7693527452118211,-0.2994783879326091,0.5183975879011432},
{0.7644302704182218,-0.33260164323157027,0.5140807240606969},
{0.7563762913010237,-0.3645977293899655,0.5070181365394075},
{0.7453018006149862,-0.3949019842379512,0.49730573169818376},
{0.7313199463139899,-0.4229519008048052,0.48504372629617715},
{0.7147356890737331,-0.4483326032596309,0.4704993650244588},
{0.6958572223685962,-0.47063029337109247,0.45394420297234284},
{0.6749916620733986,-0.489431172907854,0.43564548483090043},
{0.6524450464633991,-0.5043214436385797,0.4158715328907632},
{0.6286376393672982,-0.5151470088260792,0.3949941190003971},
{0.6039918598129179,-0.5217570045318449,0.3733807046100248},
{0.5789290492285195,-0.5239984116182475,0.3513998287694298},
{0.5538694714428035,-0.5217171333480966,0.3294232633270779},
{0.529234467884031,-0.5150694216577039,0.3078195473327525},
{0.5054464575800239,-0.5042072180851379,0.2869582974357979},
{0.4829278595586045,-0.48928569696714996,0.2672091302855585},
{0.4620989376484731,-0.4704578774413692,0.24894274013093912},
{0.4432635749257669,-0.44814294573693525,0.23242529406345014},
{0.426726732066184,-0.422755777684745,0.21792188157504105},
{0.4127901369467402,-0.39471663711349875,0.20570082495634376},
{0.4257407284680791,-0.39471663711349875,0.18991722418973944},
{0.4376331172207415,-0.39471663711349875,0.17332434615299652},
{0.44841665602537106,-0.39471663711349875,0.15599007961844355},
{0.4580374649039293,-0.39471663711349875,0.13798339095796985},
{0.4664610606704717,-0.39471663711349875,0.11938725533775472},
{0.47365403773861425,-0.39471663711349875,0.10028109184542695},
{0.47958406812153387,-0.39471663711349875,0.08074625924782473},
{0.4842166686332859,-0.39471663711349875,0.060863900791874044},
{-0.410021783675121,-0.009876846534197356,0.32594477194491095},
{-0.4250295127579706,0.0031374311211830722,0.29316203810715324},
{-0.45115052611104556,-0.02356117559646483,0.33799664543256736},
{-0.4703188670980297,-0.009802599924460278,0.3026718542309522},
{-0.43851998165925543,0.01908690678817679,0.26494509360837987},
{-0.3933534736691241,-0.020270833097608434,0.36003355645032237},
{-0.4300446611137961,-0.0347268312053436,0.37453804653829226},
{-0.4647994021477636,-0.05341822662673083,0.38615133700471505},
{-0.49019088059819704,-0.041670128455255646,0.346254290866751},
{-0.5140047532916625,-0.02722641498251326,0.30663095501722276},
{-0.4871703690293575,0.006788446193029327,0.27214561387344777},
{-0.4506343559214365,0.03828635807448045,0.24455259952036043},
{-0.3748801843988368,-0.02835940316070728,0.3921675753524963},
{-0.4073827423507942,-0.04353933265336802,0.4087184270063692},
{-0.43835726412557907,-0.06272997995126017,0.42280480846476004},
{-0.46626924794865454,-0.08611475249962688,0.43439977973864974},
{-0.4958396574957556,-0.07670213585620943,0.39523334610288813},
{-0.525445627828362,-0.06470963810435151,0.351131506478798},
{-0.5551216421324187,-0.04969512014426904,0.3046363182302367},
{-0.534612767291836,-0.009642684149641947,0.2721089754883816},
{-0.5013224840609555,0.026451826719835425,0.2499966325013726},
{-0.3319744802872018,-0.03882666649425074,0.44239664607912704},
{-0.35445859512267663,-0.034457215795238846,0.4190870899801021},
{-0.3582495903774669,-0.05511479937520778,0.46110054165541925},
{-0.3835473176661133,-0.050238445842809475,0.43695692349635795},
{-0.30731361433897075,-0.04172993523087841,0.46370078939555825},
{-0.3312018414021294,-0.05845934513197094,0.4829919767324703},
{-0.3541202288605947,-0.0788351364267984,0.5005374527809342},
{-0.3834600321016909,-0.0751303491368697,0.4779121724029985},
{-0.41139141271686014,-0.06986465888316505,0.4526963426809707},
{-0.28035746132629874,-0.043429201978257274,0.4846051432749436},
{-0.302116351657375,-0.06056292723455087,0.5044793119742325},
{-0.3229301871736557,-0.0812871064673754,0.5226584165644294},
{-0.3421297785479022,-0.10542210382995049,0.5389366355294274},
{-0.37521424026267564,-0.10273780332407137,0.5160829040446083},
{-0.40654221469339324,-0.09882827211759629,0.49255567283430773},
{-0.43669883840155344,-0.09338854953482721,0.46608336202442163},
{-0.2509939508948656,-0.04418653894956673,0.5067142534632703},
{-0.27070647966003886,-0.061716282044443446,0.5274063202291839},
{-0.2894491688205188,-0.08279359065333244,0.5463602189035748},
{-0.3067047705871355,-0.10718290151224934,0.5633852143641866},
{-0.32195819236984075,-0.134647681517605,0.5782894938892023},
{-0.3590448588533155,-0.13278666707615452,0.5531070697535584},
{-0.3936271839575598,-0.13004848659223686,0.5293740170271507},
{-0.4264282369878506,-0.1261637401756595,0.5047508670635465},
{-0.45817216484902556,-0.12086195033666904,0.47689707361675276},
{-0.23082559751548642,-0.030441541032027876,0.4844747537280904},
{-0.21938687817790845,-0.04426078555930381,0.5292888866618498},
{-0.23713278774467567,-0.062158744424095774,0.5509518706320176},
{-0.2538582105273934,-0.08357485033489101,0.570766771355464},
{-0.26917305548506254,-0.10822062988927127,0.5885342329134466},
{-0.28268723157668435,-0.13580825624455478,0.6040538217876623},
{-0.29400957016169915,-0.16605216551713733,0.6171283372584897},
{-0.3346964967777079,-0.1649497811664692,0.5908823223563655},
{-0.37300731636221784,-0.1632019146788996,0.5649628201211546},
{-0.40850344589399545,-0.16064692612031292,0.5401554006326587},
{-0.4420523530194609,-0.15708976997020976,0.5142197344040362},
{-0.47451827258635204,-0.15233863350677299,0.4849165695480062},
{-0.4895841920454833,-0.11387587238419443,0.44347532323945826},
{-0.5213873878825007,-0.10493610642804303,0.40214614728523035},
{-0.5540461977707697,-0.09359113825225204,0.3544138747409047},
{-0.5880239895214219,-0.07939397955901394,0.3017839121928774},
{-0.5804958789898796,-0.030475916458016453,0.26353128298464906},
{-0.5503866696623934,0.011525789382088245,0.24751599831247909},
{-0.20100949526852968,-0.030168154023460427,0.5059782529632642},
{-0.18569896070910358,-0.043910242422185185,0.551593042370676},
{-0.20155368304671875,-0.06212921819613067,0.5742948323174264},
{-0.21634265941873201,-0.08384640542420516,0.5950009078776299},
{-0.2297727827446137,-0.10873033448151567,0.613489283541768},
{-0.24155094594383442,-0.13644942798321316,0.6295358186012003},
{-0.2513840419358645,-0.16667286286414112,0.6429152947477258},
{-0.2588906004761912,-0.19875731218651957,0.6531007657961279},
{-0.3026680826324895,-0.19825838358988285,0.6271273835828785},
{-0.3443938152250809,-0.19734134636366724,0.6004567944538105},
{-0.3835052912832433,-0.1958564141689256,0.573761420534845},
{-0.4194410814358152,-0.19365380066671084,0.5477115287527808},
{-0.45318287888265857,-0.1906354442969929,0.5202941631280992},
{-0.48571237682363516,-0.18670005070105936,0.489494212482159},
{-0.5067665170419676,-0.14619847120950313,0.45000665417728775},
{-0.5396645540327278,-0.1384763927570223,0.4072507364045998},
{-0.5731250979942101,-0.1292284333264906,0.35789021092395007},
{-0.607060863361992,-0.11850739529638568,0.3031675500289066},
{-0.6400655827092684,-0.11025621545956658,0.2448532497978154},
{-0.6276731877604087,-0.0595156082214381,0.24084350183218867},
{-0.5971922065844565,-0.005869146007736091,0.23559882476991903},
{-0.169071599486416,-0.029520408927481326,0.5271218339451404},
{-0.1500972264203705,-0.04339364119275186,0.572888564890621},
{-0.16413188309984442,-0.0618671459829513,0.5966129968205425},
{-0.17708462982030485,-0.08382808623167205,0.6181886952262878},
{-0.18873779147047617,-0.10890921600860357,0.6373591914123936},
{-0.19886830494127888,-0.13674792306154657,0.6538669390838356},
{-0.20725741752187657,-0.1669756683407176,0.6674576247442722},
{-0.2136206429282259,-0.19898684089296365,0.6777045189676381},
{-0.21767349487628346,-0.232174752165571,0.6841852027261114},
{-0.2636880737207411,-0.23205729381344703,0.6595631303620682},
{-0.30819293558055944,-0.2317350915447767,0.6334205650177777},
{-0.35052643432542535,-0.23107344541446365,0.6063038496705508},
{-0.3900280014245866,-0.22993657787785085,0.5787582496981375},
{-0.42603383554860863,-0.22818978898984202,0.5513290304782872},
{-0.4595881306718779,-0.22582445795395095,0.5223081967071791},
{-0.4917318479700988,-0.22282873117500918,0.4899834426827488},
{-0.5180101908590462,-0.18174848071931926,0.45329548803675906},
{-0.5510590917883141,-0.1756815951921818,0.4096850338123802},
{-0.5839765255711682,-0.16905435789344372,0.3599344172907315},
{-0.6158799381673372,-0.16242173259690182,0.3053173611526436},
{-0.6455570300709544,-0.15731067788016773,0.24723690002623955},
{-0.6717965793757142,-0.1552459971217316,0.18709930133832478},
{-0.6707297558105515,-0.10841352021064918,0.18471996150814368},
{-0.670454967922555,-0.06518054911240818,0.1786207479941831},
{-0.6397164404515788,-0.02104110126364713,0.21017070793441944},
{-0.1352037228909625,-0.02877277035221881,0.5472718681319866},
{-0.11274557820490229,-0.042969390245676545,0.5924362209229963},
{-0.12502471743992513,-0.06161153936713655,0.6170841556764982},
{-0.13626839125700368,-0.08373649026900656,0.639450812159849},
{-0.14630407596645859,-0.10895663038927744,0.6592473936907624},
{-0.1549604332381274,-0.1368815454070821,0.676184025987391},
{-0.16206827994096906,-0.16712329948054314,0.689969757168327},
{-0.16742071695931574,-0.199097833647723,0.7002694537701707},
{-0.170813000376621,-0.23222216654624492,0.7067425943317186},
{-0.17204254147546008,-0.26591439441329284,0.7090529677900104},
{-0.21913471988068814,-0.26593271360582593,0.6864740241931878},
{-0.26539499142500145,-0.2659316360062652,0.6617732870612083},
{-0.31011106279873074,-0.265791548063365,0.6353785634196976},
{-0.3525717182917676,-0.2653982242236838,0.6077155050951601},
{-0.39206466459444267,-0.2646320509359761,0.5792119191132218},
{-0.42787976359620833,-0.2633755698481178,0.5502934573003868},
{-0.4610353468819926,-0.2616826609381474,0.5195915682144768},
{-0.49255297883540583,-0.25960612658454285,0.4857387780128741},
{-0.5235081038180969,-0.21919291025696977,0.45264785070073604},
{-0.5559589369911373,-0.21490837440334662,0.40859019265863744},
{-0.5878957551736902,-0.21050638019759943,0.3589236289027289},
{-0.6181245780524219,-0.20652033942230966,0.30476131977928606},
{-0.6454557357122421,-0.20348366386005862,0.24721534803502415},
{-0.6686984806384992,-0.20192761009430613,0.18739887401621896},
{-0.6867364196862353,-0.20139958630952862,0.12587871509183574},
{-0.6926686052682764,-0.15494211404559433,0.125483236053033},
{-0.695627693662152,-0.10955793094418734,0.12347782327043923},
{-0.6984014349315751,-0.06801485147714655,0.1196760520200412},
{-0.6759334840895118,-0.029297884618182238,0.1671615542649505},
{-0.09960069548275649,-0.0281997029058011,0.5657979597807516},
{-0.07387968708663951,-0.04263425678227694,0.6099741537745349},
{-0.08444490422025701,-0.06137726922262507,0.6354378313955399},
{-0.09406431221938631,-0.08360502312259258,0.6585092379916346},
{-0.10259954730042449,-0.10891352640684665,0.6788683264932702},
{-0.10991246119968079,-0.1368998645996152,0.6961939722313368},
{-0.11586469013355227,-0.16715886026604856,0.7101628953376039},
{-0.12031302112041256,-0.19912261843762075,0.7205100063201214},
{-0.12311467221845958,-0.23222108894668417,0.7269637500895755},
{-0.12412707700580339,-0.2658842216255913,0.7292590371540165},
{-0.17090244114016495,-0.29959153588649,0.706862207882964},
{-0.21771875405783583,-0.2996540366610147,0.6841464091419236},
{-0.2636288057448987,-0.2997337790285117,0.6592042897083316},
{-0.3079504756793861,-0.2997359342276332,0.6323709830455874},
{-0.3500037985384517,-0.2995656734970315,0.6039837778162123},
{-0.3891044986010063,-0.2991292456749195,0.5743778074836057},
{-0.42457368814376467,-0.2983307444003886,0.5438882055111675},
{-0.45729499880655844,-0.29723805844576734,0.5114783211214363},
{-0.4881542174283409,-0.29591692138426284,0.47611258113651195},
{-0.5234531462404975,-0.2571987691657817,0.4473665352534002},
{-0.5547552582817566,-0.2545133910603418,0.40310521089431606},
{-0.5852642570462888,-0.251846332147435,0.3538449021728179},
{-0.6137840070216387,-0.24949608750539476,0.30047355112698054},
{-0.6391183726953512,-0.24775791941387204,0.24387909979487893},
{-0.6600744513536536,-0.24693032295120038,0.18495164541370934},
{-0.675946415284241,-0.24671803583772858,0.1242730917462878},
{-0.6860316695734915,-0.24682579579380562,0.06242835983420053},
{-0.6984531597104922,-0.201444845491081,0.0632231972702248},
{-0.7062420493357406,-0.1551102195770745,0.06296694409467359},
{-0.7113358624595024,-0.1102669914551743,0.06183858959459088},
{-0.7156678126937995,-0.0693603422887245,0.060016584257240255},
{-0.7037743463415764,-0.033082090995739714,0.11389041997826482},
{-0.06250713236209282,-0.027779546837056714,0.58244040739729},
{-0.12320572938134468,-0.29954412150581605,0.7271275452228125},
{-0.16761037448201133,-0.33269323919423577,0.7004957496779324},
{-0.2137445668777145,-0.33278160235821885,0.6776215438014587},
{-0.2588453412946388,-0.3329109143055113,0.6523949380838233},
{-0.302313552376996,-0.33301220866422376,0.625083177216097},
{-0.3435500547689977,-0.3330175966620276,0.595953505889351},
{-0.3819578583139769,-0.3328548791283513,0.5652742463942172},
{-0.41693674005658476,-0.33245724489042694,0.5333115658222057},
{-0.4491688205187887,-0.33187103072936786,0.49934023966891833},
{-0.4793394530212389,-0.33114365102584786,0.4626339658303955},
{-0.518039286047187,-0.2944341443886427,0.4367554123784939},
{-0.5478349139024891,-0.2928543834325533,0.39237016406992115},
{-0.5764635014334768,-0.2913360456514278,0.34368421591431364},
{-0.6028452938802581,-0.29003646058113863,0.2914238700156306},
{-0.6259048468811844,-0.28911403535711916,0.23631758367695288},
{-0.6445613280768027,-0.2887250219156811,0.17909273660180058},
{-0.6584106376318241,-0.28868407313237177,0.1202773525749511},
{-0.6670454429122775,-0.28880799708186045,0.06040376577942507},
{-0.7211732688497756,-0.03483609980080572,0.05767991736966568},
{0.6786759749716726,-0.026960355650959042,0.38429140016282526},
{0.7025146324550359,-0.041854182460235236,0.40258365270690316},
{0.7246140442473156,-0.06066282071383429,0.4194416202355956},
{0.7446326112877477,-0.08297462737954188,0.43464547243850543},
{0.7622287345155678,-0.10837688182558299,0.44797430140567474},
{0.7770618924695727,-0.1364591263792601,0.4592082768267064},
{0.7887915636885587,-0.16680864040879817,0.46812649079164237},
{0.7973013674199626,-0.19885429614698888,0.4746276489417703},
{0.8024727677120999,-0.23202604342618469,0.4786104569183778},
{0.8041904614119679,-0.2657516768796165,0.4799757755618739},
{0.8023380677670037,-0.2994622239391975,0.4786201553144247},
{0.7970470539236209,-0.3325973328333272,0.47463626973825646},
{0.7884531974264768,-0.3645977293899655,0.46811571479603464},
{0.7766879654219854,-0.3949019842379512,0.45914900885086396},
{0.7618871354548036,-0.4229519008048052,0.44782774786540996},
{0.744363211397555,-0.4483326032596309,0.43439977973864974},
{0.7244351627202277,-0.47063029337109247,0.41911402996912134},
{0.7024176484945664,-0.489431172907854,0.40221942405536276},
{0.6786253277923164,-0.5043214436385797,0.3839638098963511},
{0.6535043268316364,-0.5151470088260792,0.36468770895328984},
{0.6274986166315638,-0.5217570045318449,0.34473164268738243},
{0.6010510906115755,-0.5239984116182475,0.3244382877589539},
{0.5746078749898302,-0.5217171333480966,0.3041481656292077},
{0.5486129407853654,-0.5150694216577039,0.2842017977593473},
{0.52351241421634,-0.5042072180851379,0.26494078321013675},
{0.4997502663017915,-0.48928569696714996,0.2467067210423405},
{0.47777046806075724,-0.4704578774413692,0.22984228791628344},
{0.4578962993614684,-0.44814294573693525,0.2145920989322605},
{0.44044565207435227,-0.422755777684745,0.20120184679012723},
{0.4530460237384407,-0.422755777684745,0.18362188755571862},
{0.464469656682168,-0.422755777684745,0.16525743584106914},
{0.4746615933279346,-0.422755777684745,0.1461817684163112},
{0.4835862728902352,-0.422755777684745,0.1264810932463064},
{0.49120705698400363,-0.422755777684745,0.10623924757688269},
{0.49748838482373436,-0.422755777684745,0.08554384025233072},
{0.5023957732234828,-0.422755777684745,0.06448010939790741},
{0.7913939666278192,-0.10761286373699674,0.40928847717401673},
{0.8071743345957413,-0.13579101465158241,0.41926920430587233},
{0.8195969023323026,-0.16627415102665605,0.42725637225030266},
{0.8285452890849403,-0.1984706707033546,0.4331271346573799},
{0.8338998813024084,-0.23178789392325444,0.4367564899780547},
{0.835544298232144,-0.2656331409279317,0.4380205142628384},
{0.8333589263229018,-0.2994148095585236,0.43679528356224245},
{0.8275301902986946,-0.3325854792381586,0.4331648506420069},
{0.8182412820848535,-0.3645977293899655,0.42721542346699337},
{0.8056786264053919,-0.3949019842379512,0.41903213240250287},
{0.7900254151856408,-0.4229519008048052,0.4087001078138361},
{0.7715909194995413,-0.4483326032596309,0.39644564560875484},
{0.7506822552219128,-0.47063029337109247,0.38249611929458177},
{0.7276054606280142,-0.489431172907854,0.3670767471795178},
{0.7026708843913475,-0.5043214436385797,0.3504159803704464},
{0.6763429719226046,-0.5151470088260792,0.3328241675408693},
{0.6490861686324777,-0.5217570045318449,0.3146127349638492},
{0.6213692303299018,-0.5239984116182475,0.296092031312888},
{0.5936544472264473,-0.5217171333480966,0.27757456046060913},
{0.5664105751310495,-0.5150694216577039,0.2593706710805145},
{0.5401042146535221,-0.5042072180851379,0.2417928670452274},
{0.5151998112045569,-0.48928569696714996,0.22515149702824983},
{0.49216396539396773,-0.4704578774413692,0.20976014250176592},
{0.4713350434838363,-0.44814294573693525,0.19584294417441597},
{0.8359613292621623,-0.1344558687957879,0.3777158876430042},
{0.8637483115361883,-0.1322295481032362,0.3347746227458638},
{0.8491576134833567,-0.16520732746149336,0.3845920504402803},
{0.8907281717391973,-0.1273695740841616,0.2900046713940959},
{0.9170948777921278,-0.11813239064923758,0.24296314016822407},
{0.9315379447051338,-0.15458004059317546,0.24581877900426566},
{0.9053824481661141,-0.16014799752367623,0.2941448089065759},
{0.8778368481937007,-0.1634271329871006,0.34031240688866293},
{0.8585359624607417,-0.19770341981608608,0.3897451315398844},
{0.9450855263831395,-0.09921620795947364,0.1888978150052506},
{0.9534864925589056,-0.042611411671588606,0.15383703569602425},
{0.9703423048884766,-0.10410096676844596,0.13833684361390253},
{0.9548065520208494,-0.15027934074614072,0.19639251995040888},
{0.9615480148730292,-0.19143933356932763,0.2005876150404881},
{0.9400940852176509,-0.1926677970686059,0.2497778797905362},
{0.9150959306068988,-0.1947195466323128,0.29794873535609545},
{0.8876483921945154,-0.19642538673701238,0.3446454347225208},
{0.8930773387816767,-0.23051740404110613,0.34750215115812316},
{0.8639843058399971,-0.23131159491739392,0.392999482213411},
{0.8653884180676809,-0.2653949914250015,0.3941751433342116},
{0.8626319183912301,-0.2993199807971758,0.39309538857431964},
{0.8559982154951274,-0.3325617720478217,0.3898399603012322},
{0.8457685628647338,-0.3645977293899655,0.38448967848200705},
{0.8322231363858497,-0.3949019842379512,0.37712428548414123},
{0.815643189543836,-0.4229519008048052,0.36782567887425327},
{0.7963035102266892,-0.4483326032596309,0.356796447369768},
{0.774478886322406,-0.47063029337109247,0.3442413348872319},
{0.7504441057189826,-0.489431172907854,0.3303650853431912},
{0.7244718011052939,-0.5043214436385797,0.3153702874550708},
{0.6970490474828084,-0.5151470088260792,0.29953819470823184},
{0.6686607646538724,-0.5217570045318449,0.283146827789353},
{0.6397907948212721,-0.5239984116182475,0.26647959538291693},
{0.610924057787354,-0.5217171333480966,0.24981344057604163},
{0.5825476285535867,-0.5150694216577039,0.23343069445364895},
{0.5551475045218771,-0.5042072180851379,0.21761045530197842},
{0.5292075278950116,-0.48928569696714996,0.20263397660639113},
{0.5052147736744582,-0.4704578774413692,0.18878251185224817},
{0.4835194617174674,-0.44814294573693525,0.1762564945578528},
{0.9205410411874717,-0.26457601575881595,0.3015436074908256},
{0.9202253045161659,-0.22967364358502287,0.3005037239146821},
{0.9444777602308649,-0.22904540304109372,0.2522455827847005},
{0.9440564188026037,-0.264261356687071,0.2532024911946646},
{0.9381996651898165,-0.29886631138209147,0.252628130628774},
{0.9158157671134934,-0.29899239053070165,0.30080114139345476},
{0.8940191607977901,-0.264998434786638,0.3486088459070344},
{0.890372563884143,-0.29916157366174256,0.3476928862803796},
{0.8825728982632868,-0.33252190086407324,0.34483401464565566},
{0.8710598245560156,-0.3645977293899655,0.3401076629721166},
{0.8562697705844415,-0.3949019842379512,0.33359249602769864},
{0.8386434745689197,-0.4229519008048052,0.32536717858033803},
{0.8183867580255575,-0.4483326032596309,0.31561166975668337},
{0.7957097528687048,-0.47063029337109247,0.30450592868338344},
{0.7708182806144689,-0.489431172907854,0.29223099208664766},
{0.7439213955776391,-0.5043214436385797,0.27896681909312454},
{0.7155223367530955,-0.5151470088260792,0.26496233520135215},
{0.6861232655361571,-0.5217570045318449,0.2504632331111862},
{0.6562252657225818,-0.5239984116182475,0.23571951592072532},
{0.6263304987076888,-0.5217171333480966,0.2209768763298252},
{0.5969443586854793,-0.5150694216577039,0.20648531743658463},
{0.568567929451712,-0.5042072180851379,0.19249160954041997},
{0.5417044500012662,-0.48928569696714996,0.17924360054030844},
{0.5168571593290219,-0.4704578774413692,0.16699129353434874},
{0.49438920848695866,-0.44814294573693525,0.15591033725094655},
{0.5039076454072438,-0.44814294573693525,0.13489822341548413},
{0.5120349012945743,-0.44814294573693525,0.11330959381500956},
{0.5187354153634447,-0.44814294573693525,0.09123679873188084},
{0.5239693164301066,-0.44814294573693525,0.06877132636880737},
{0.9648831855136136,-0.22889992710038973,0.20296695487066918},
{0.9636676532090646,-0.26418915751649935,0.20380748252807013},
{0.956761317624087,-0.29883721619395065,0.20338829629893043},
{0.9450790607857749,-0.3324410808970154,0.20177297455733556},
{0.927697379870548,-0.33244862409394077,0.250595777857161},
{0.9066669468425526,-0.3324798744812032,0.29835067999226283},
{-0.5627348830292617,-0.32863068885013125,0.3301765054200564},
{-0.5867825948274142,-0.3279367147329951,0.27928147816486953},
{-0.5453219517267724,-0.3633865074836595,0.31505993878156896},
{-0.5670668332635588,-0.3629877956461745,0.2657123444956484},
{-0.6074811271906925,-0.32746149332669533,0.22603405106852079},
{-0.536222701035627,-0.3294561301136814,0.3781092114826854},
{-0.5209423392639025,-0.3638423320978655,0.36204651242984154},
{-0.5030175481700473,-0.3955399231779273,0.34590730380818296},
{-0.5254661022200167,-0.3952575920930055,0.30006945129169166},
{-0.5451700101887038,-0.3949817266054482,0.25238459312803985},
{-0.5855174929430698,-0.36271193015861725,0.21453067575729656},
{-0.6239468484792646,-0.3272944653947759,0.17104737828108862},
{-0.4782704742569547,-0.39576621908568915,0.3894444812624294},
{-0.46004718808476613,-0.42417174350759734,0.3740143331517578},
{-0.48347096973723275,-0.42407044914888486,0.33141682251450316},
{-0.5044098068025628,-0.4238991108187225,0.28694105584282564},
{-0.5225652042024228,-0.42371053089558763,0.24096634818211649},
{-0.5616809906588283,-0.3947726722906587,0.20331070913055496},
{-0.6000144398341143,-0.36262248939507336,0.16204187875173023},
{-0.6359728595774624,-0.3273203277842344,0.11475573242556347},
{-0.4945853316070188,-0.3642916911147068,0.40614511925524943},
{-0.5081296804863422,-0.33032359776010156,0.42246536460311734},
{-0.46691149728687364,-0.36466992856053715,0.446827735473015},
{-0.4516753170971407,-0.3958782894400093,0.4302251590402252},
{-0.43443480172437476,-0.4241523467155035,0.41435211751007694},
{-0.4152255119540813,-0.4493056756630066,0.3988045110472813},
{-0.4399079298935277,-0.4493595556410451,0.35935466872703703},
{-0.46221747360015775,-0.4493142964594928,0.3180071735802761},
{-0.4819601751530326,-0.44920653650341574,0.2750712966809395},
{-0.49894098903165285,-0.4490761469565625,0.2308573867025292},
{-0.5376408220576009,-0.42355427895927594,0.19387632497600993},
{-0.5745507622131093,-0.39469077472404024,0.15330039111476057},
{-0.6104768539696342,-0.36264835178453186,0.1085724661458628},
{-0.6433544165687398,-0.32742808774031146,0.05759554132405736},
{-0.43746393408970047,-0.36496195804150594,0.48454910809778357},
{-0.4229853063911891,-0.3958922982342992,0.46847778824845354},
{-0.40653574909602863,-0.42404350915986566,0.45249914196134977},
{-0.38817021978181837,-0.44918067411395723,0.43632113975550346},
{-0.3679415208270361,-0.4710710315914476,0.4196539073490674},
{-0.3940819309722049,-0.4711496963593838,0.3831814726152318},
{-0.4178451564863142,-0.4711820243462069,0.3449665593916304},
{-0.4391697741944,-0.4711475411602622,0.3051093844374149},
{-0.45792754974873073,-0.4710721091910083,0.2638567180520017},
{-0.4739891712020138,-0.4709794356287821,0.22145533053480726},
{-0.5129648697155191,-0.4489608438035601,0.18567363711942553},
{-0.5493403204888853,-0.4234820797887043,0.14605030126989718},
{-0.5837642384576964,-0.39468969712447943,0.10259006442428975},
{-0.616819604984329,-0.3627216285546642,0.0544495971663442},
{-0.645883542737868,-0.32750136451044376,7.526946724016515e-10},
{-0.4057900501999755,-0.3651559259624446,0.5197607513455177},
{-0.3919558270388048,-0.39582871986021384,0.5044329751931194},
{-0.37625412383881907,-0.42387432602882474,0.4885254504770264},
{-0.3587442085758606,-0.4490147237815986,0.4718657612675157},
{-0.3394831940266501,-0.4709675820336135,0.45428149163486403},
{-0.31852927056746927,-0.48945272489906927,0.43560238084846953},
{-0.34590353220972025,-0.4894818200872101,0.4022075704601943},
{-0.3710406971638118,-0.48949798408062173,0.36707782477907863},
{-0.3938502470666393,-0.48949151848325706,0.33034892134977967},
{-0.41424058595553714,-0.4894505696999478,0.2921555601173937},
{-0.4321211954674007,-0.4893902241245446,0.25269494180154173},
{-0.4473983244404429,-0.48932341295177684,0.2121610343231624},
{-0.48722317140783533,-0.47089646046260275,0.17814983698612644},
{-0.5238389268832534,-0.44890049822815686,0.1398325518042519},
{-0.5576787858901269,-0.42346699339485355,0.09767330090836256},
{-0.5893052553991779,-0.3947263355095457,0.05141195176448846},
{-0.6189618729111406,-0.3627690429353381,5.017960890679141e-10},
{-0.616819604984329,-0.3627216285546642,-0.0544495971663442},
{-0.6433544165687398,-0.32742808774031146,-0.05759554132405736},
{-0.6359728595774624,-0.3273203277842344,-0.11475573242556347},
{-0.6104768539696342,-0.36264835178453186,-0.1085724661458628},
{-0.371434021003493,-0.3652378235290631,0.5529152570317412},
{-0.3583422639396932,-0.39570264071160366,0.5383191709811059},
{-0.3434929419922768,-0.4236771253092037,0.5225010870285569},
{-0.3269474783362078,-0.4488379974536322,0.5054017371982519},
{-0.30876514094732854,-0.47086089967709727,0.4869629311139093},
{-0.2890084306001636,-0.4894225521113678,0.4671254007996867},
{-0.26773553767099484,-0.5041996748882125,0.44582987827974163},
{-0.29594062857459974,-0.5041899764921656,0.4156538577794876},
{-0.3221101339079094,-0.504179200496558,0.3836911772074762},
{-0.3461373713144074,-0.504164114102707,0.3500916229026545},
{-0.36791673603713837,-0.5041393293128094,0.31500390360440894},
{-0.38734370091870746,-0.5041005357286217,0.2785788832512472},
{-0.40434714438810393,-0.5040552765470694,0.2409803569764065},
{-0.41886025527255993,-0.5040100173655169,0.20237319751268468},
{-0.4599825321111199,-0.4892652225754952,0.170749960802316},
{-0.4975002384189028,-0.47084796848236804,0.13418808530493642},
{-0.5315804021278281,-0.4488778686373808,0.0934960939709921},
{-0.5626702270556154,-0.42347884699002203,0.04892862357669303},
{-0.5911565714445814,-0.3947532754985649,1.2544875286708835e-10},
{-0.5893052553991779,-0.3947263355095457,-0.05141195176448846},
{-0.5837642384576964,-0.39468969712447943,-0.10259006442428975},
{-0.33394002188604704,-0.36519364194707155,0.5844662945715383},
{-0.2937983606477882,-0.36506864039802217,0.6141951112540727},
{-0.3218989243939984,-0.39553453518012344,0.5703659043188574},
{-0.2830072786462332,-0.395349188055671,0.6003921384801644},
{-0.2514993450888669,-0.3649080780634674,0.6418851095676293},
{-0.2420466417417888,-0.3951703065285831,0.6282157591392565},
{-0.2705394517281194,-0.42330104306249483,0.5843563794163398},
{-0.30815629719549326,-0.4234820797887043,0.5544960955873914},
{-0.20753112781031227,-0.36475721412495954,0.6673186144009328},
{-0.19939740632561714,-0.39502483058787907,0.6536568071694854},
{-0.23094305586761038,-0.42314479112618314,0.6119267641786509},
{-0.25648432065699084,-0.4485438127735419,0.5662063700142836},
{-0.29278218426198166,-0.44867959031819904,0.5368935067622066},
{-0.12049664408556784,-0.33263935921619725,0.7208214325931841},
{-0.11614368065983574,-0.36460850538557327,0.7105971679605942},
{-0.1623840166122748,-0.3646623853636118,0.6902779506427072},
{-0.155441042642231,-0.3949364674238959,0.6765331682450807},
{-0.11029134520524767,-0.39489228584190433,0.6967058320227029},
{-0.10308414382290294,-0.42292819361446826,0.679403893474973},
{-0.14699805008359476,-0.4229594440017307,0.659586837552405},
{-0.18966344949317795,-0.42302733277405913,0.6370553083362563},
{-0.21829311462372644,-0.4484349752179041,0.5932056270093864},
{-0.24093024859683063,-0.47069925974298177,0.5460628014248021},
{-0.2758498623635961,-0.47077145891355343,0.5175969314274907},
{0.8937163553212136,-0.3645977293899655,0.2942698104556253},
{0.8775825346973589,-0.3949019842379512,0.28863288715323515},
{0.8588851047184314,-0.4229519008048052,0.28151641965390733},
{0.8377490669334803,-0.4483326032596309,0.27307558229439266},
{0.8142983452919945,-0.47063029337109247,0.2634666270110028},
{0.7886579413430231,-0.489431172907854,0.2528458057400496},
{0.7609517790360549,-0.5043214436385797,0.24136937041784462},
{0.7316981837598203,-0.5151470088260792,0.22925176335698125},
{0.7014133257039286,-0.5217570045318449,0.21670742687005282},
{0.6706155302571098,-0.5239984116182475,0.20395080326965256},
{0.6398209676089737,-0.5217171333480966,0.19119525726881315},
{0.6095501183473717,-0.5150694216577039,0.17865630877968855},
{0.5803191526619134,-0.5042072180851379,0.16654840011487212},
{0.5526474735408897,-0.48928569696714996,0.15508705118651792},
{0.5270523287734707,-0.4704578774413692,0.1444845491080978},
{0.5357571780253743,-0.4704578774413692,0.12136249533264691},
{0.5429339911001052,-0.4704578774413692,0.09772082304899252},
{0.548539664015233,-0.4704578774413692,0.07365877917668161},
{0.9133415985219645,-0.3645977293899655,0.24717655445083642},
{0.8959200464229892,-0.3949019842379512,0.24244158198081117},
{0.8762258368503489,-0.4229519008048052,0.23646413721721765},
{0.8542977633882317,-0.4483326032596309,0.22937353210734832},
{0.8301735420212643,-0.47063029337109247,0.22130231139717788},
{0.8038930439331954,-0.489431172907854,0.21238194223312037},
{0.7754950627082126,-0.5043214436385797,0.2027417365624682},
{0.7455108549297755,-0.5151470088260792,0.19256380871099157},
{0.7144705995817836,-0.5217570045318449,0.18202704020577842},
{0.682903398048575,-0.5239984116182475,0.17131139017347738},
{0.6513415845131703,-0.5217171333480966,0.16059789534029786},
{0.6203142603599074,-0.5150694216577039,0.15006543723332777},
{0.5903537597718075,-0.5042072180851379,0.13989505257877657},
{0.5619913393323301,-0.48928569696714996,0.13026777810285364},
{0.9110452338579627,-0.3949019842379512,0.19521362603092604},
{0.9295346871216615,-0.3645977293899655,0.19902617327693178},
{0.9419001420815021,-0.3645977293899655,0.15001910045221467},
{0.922717792300228,-0.3949019842379512,0.1471462200232007},
{0.9016356344933154,-0.4229519008048052,0.14351794230208673},
{0.8905234278226509,-0.4229519008048052,0.19040106639252535},
{-0.25743153067090807,-0.48940100012015236,0.49664300796830996},
{-0.22396559871162194,-0.48938806892542314,0.5240442095995802},
{-0.20420242276709244,-0.47064645736450406,0.5722409275545979},
{-0.18877658505466388,-0.4893826809276192,0.5492201681378595},
{-0.20567981176490868,-0.5042309252754749,0.5002712856894239},
{-0.2375993883544893,-0.5042136836825026,0.47407052996885196},
{-0.17844456046599713,-0.44835846564908943,0.6177587330015405},
{-0.16586143039488094,-0.4706119741785593,0.5960116962656327},
{-0.1520304400323926,-0.48938375852718,0.5720588132288278},
{-0.1721212062433963,-0.5042481668684472,0.5243308510827451},
{-0.18640047802316514,-0.5150543352638529,0.47518045751644555},
{-0.2167058104707116,-0.5150284728743945,0.45028036446572345},
{-0.2453246996056524,-0.515002610484936,0.42343628180737153},
{-0.27212567828157347,-0.514978903294599,0.3947484263005414},
{-0.2969988313432763,-0.5149541185047013,0.36436227388593717},
{-0.31983532123512304,-0.5149293337148035,0.33242976610162733},
{-0.34052738800103666,-0.5149023937257844,0.2990996116869983},
{-0.35896727168494,-0.5148722209380828,0.2645215969809971},
{-0.3750946267114301,-0.5148409705508203,0.22884012032476694},
{-0.38885449550290757,-0.5148107977631189,0.19220389045769423},
{-0.4001876100835301,-0.5147860129732212,0.15475730572092217},
{-0.4308129896006254,-0.5039701461817684,0.16291904479419733},
{-0.4401363810004111,-0.5039432061927492,0.12278600435242464},
{-0.46978114491720535,-0.4892285841904291,0.12865784435906263},
{-0.4767887748608953,-0.48920810979877444,0.08605580780365274},
{-0.504831148230824,-0.4708253388915919,0.08973225422513317},
{-0.5362108474404585,-0.4488778686373808,0.04683042947191695},
{-0.5643286527796411,-0.42349285578431195,7.664286788036705e-17},
{-0.5626702270556154,-0.42347884699002203,-0.04892862357669303},
{-0.5576787858901269,-0.42346699339485355,-0.09767330090836256},
{-0.13717680768673315,-0.4483164392662194,0.6397299104460885},
{-0.1261012394011348,-0.4705979653842693,0.6172544164070999},
{-0.11389300621721064,-0.4893902241245446,0.5924523849164078},
{-0.10067420016519597,-0.5042826500543919,0.5656147678554206},
{-0.13707120292977765,-0.5042664860609803,0.5461468541905422},
{-0.15454232460854847,-0.5150791200537507,0.4980406545986292},
{-0.1664594981511085,-0.5216891157595164,0.4492070753031961},
{-0.19510317207594705,-0.5216675637683011,0.4256733784955309},
{-0.22215523144952762,-0.5216438565779641,0.4003045296358737},
{-0.24749067472280095,-0.5216223045867487,0.37319320228645075},
{-0.2710071299374938,-0.5216007525955333,0.3444794843901621},
{-0.29260006993621146,-0.5215792006043178,0.3143045414894689},
{-0.31216604516111995,-0.5215587262126633,0.2828063063281495},
{-0.32960052845482457,-0.5215382518210087,0.25012594444866504},
{-0.34485071743884754,-0.5215199326284755,0.21640031099523324},
{-0.35786273213515035,-0.5215026910355032,0.18176626111207198},
{-0.3685826925656945,-0.5214886822412133,0.14636280514252062},
{-0.37695564115288066,-0.5214779062456054,0.11032679823079704},
{-0.40903685767657677,-0.5147687713802489,0.11664907485383709},
{-0.415381763890393,-0.5147569177850804,0.07804202315007137},
{-0.44681534307806614,-0.5039281197988984,0.08214078083941773},
{-0.45083478943973976,-0.503920576601973,0.04115546690503169},
{-0.4809978787452646,-0.4892005666018491,0.04311303426712723},
{-0.5092212888414026,-0.4708188732942272,0.04494829407907533},
{-0.5377475044141171,-0.44888325663518464,8.178355658502233e-17},
{-0.5362108474404585,-0.4488778686373808,-0.04683042947191695},
{-0.5315804021278281,-0.4488778686373808,-0.0934960939709921},
{-0.0946412590242228,-0.44830135287236855,0.6590200201834397},
{-0.08508198108058448,-0.4705979653842693,0.6358828800141381},
{-0.07452538474345313,-0.48940100012015236,0.610321140833103},
{-0.06309065252425,-0.5042966588486819,0.5826667033050517},
{-0.08669741058213543,-0.5151179136379385,0.5372523474159432},
{-0.12126389497283638,-0.5151006720449661,0.5187628941522443},
{-0.13634705602493996,-0.5217095901511711,0.470812946496643},
{-0.1461833848156523,-0.5239617732331813,0.4227897220709093},
{-0.17314277062700667,-0.5239488420384519,0.4006525942940026},
{-0.1986021378497686,-0.523934833244162,0.37679238481942395},
{-0.22244510573137485,-0.5239219020494328,0.35129961201027815},
{-0.2445746903113562,-0.5239089708547036,0.32430035501517535},
{-0.26489606282836475,-0.523897117259535,0.29592177058228636},
{-0.28331547212061353,-0.5238852636643666,0.2662910154597821},
{-0.2997348566280724,-0.5238755652683197,0.23553416879627279},
{-0.3141024915718244,-0.5238658668722727,0.20378377533773318},
{-0.32636557457339177,-0.5238572460757865,0.17117345742969875},
{-0.33647130325429675,-0.5238497028788611,0.13783360461902275},
{-0.3443647200369401,-0.5238443148810572,0.10389740821141642},
{-0.3500296609279102,-0.523841082082375,0.06951357694626605},
{-0.3829632587041757,-0.5214703630486801,0.073814600073169},
{-0.38658291562880354,-0.521466052650437,0.03698644972432309},
{-0.41920508713200644,-0.5147515297872765,0.039103932861236965},
{-0.42048527541020175,-0.514749374588155,8.972815934680225e-17},
{-0.45217963369158126,-0.5039184214028514,8.78588473887338e-17},
{-0.4824030685725092,-0.48919948900228827,8.587757283630131e-17},
{-0.5106825138458073,-0.47081995089378803,8.598953543066536e-17},
{-0.5092212888414026,-0.4708188732942272,-0.04494829407907533},
{-0.504831148230824,-0.4708253388915919,-0.08973225422513317},
{-0.05099739921346005,-0.5151308448326677,0.5534411256173972},
{-0.07221468800529314,-0.5217397629388726,0.5078715953915377},
{-0.10489117052635887,-0.5217268317441434,0.49039939611320615},
{-0.11784186980765383,-0.5239747044279105,0.44311648258572167},
{-0.1259040386815138,-0.521700969354685,0.3963637480421363},
{-0.1511780587798232,-0.5216934261577595,0.37561780129818423},
{-0.17504581145132722,-0.5216858829608341,0.3532608432108803},
{-0.19739414874214495,-0.5216783397639088,0.32937692654596473},
{-0.21813794028697553,-0.5216718741665441,0.3040824320560007},
{-0.23718882292183574,-0.5216654085691795,0.2774926628939906},
{-0.2544573558831817,-0.5216600205713756,0.2497229222129369},
{-0.26985733120615174,-0.5216557101731325,0.2208895907654028},
{-0.2833370241118289,-0.5216524773744502,0.19111874769999845},
{-0.29484363222173543,-0.5216492445757679,0.16053647216533395},
{-0.3043275859560759,-0.5216460117770857,0.12926884331001948},
{-0.3117371605359333,-0.5216438565779641,0.09744107820301652},
{-0.31705403676877464,-0.5216427789784034,0.06519391134696174},
{-0.3202588178625058,-0.5216417013788426,0.03266689188497487},
{-0.3534434963364309,-0.5238389268832535,0.03483135836273833},
{-0.354587907069969,-0.5238378492836927,6.272459195345632e-11},
{-0.3877973703337918,-0.5214649750508762,8.972815934680225e-17},
{-0.41920508713200644,-0.5147515297872765,-0.039103932861236965},
{-0.45083478943973976,-0.503920576601973,-0.04115546690503169},
{-0.4809978787452646,-0.4892005666018491,-0.04311303426712723},
{-0.4767887748608953,-0.48920810979877444,-0.08605580780365274},
{-0.46978114491720535,-0.4892285841904291,-0.12865784435906263},
{-0.44681534307806614,-0.5039281197988984,-0.08214078083941773},
{-0.415381763890393,-0.5147569177850804,-0.07804202315007137},
{-0.3829632587041757,-0.5214703630486801,-0.073814600073169},
{-0.37695564115288066,-0.5214779062456054,-0.11032679823079704},
{-0.3443647200369401,-0.5238443148810572,-0.10389740821141642},
{-0.3117371605359333,-0.5216438565779641,-0.09744107820301652},
{-0.2846053587948557,-0.515040326469563,-0.06093265164385119},
{-0.25325044437511884,-0.5041985972886517,-0.05680738500530987},
{0.8164513892144137,-0.489431172907854,0.17100966229646164},
{0.8432588334876995,-0.47063029337109247,0.17819294096855728},
{0.8679390962280245,-0.4483326032596309,0.18469194391956364},
{0.8534809429211677,-0.47063029337109247,0.13431524205310735},
{0.826260778016107,-0.489431172907854,0.12890138185979677},
{0.7874833578217834,-0.5043214436385797,0.1632477126602323},
{-0.08823439083566226,-0.5239844028239575,0.46154343507489587},
{-0.05747851401175765,-0.523990868421322,0.4779822163744486},
{-0.0715751326659759,-0.5217128229498534,0.4326853188374641},
{-0.09933301975186111,-0.5217074349520495,0.41541355307743577},
{-0.10596359760923758,-0.5150629560603391,0.3703774346341577},
{-0.12958080838286246,-0.5150597232616568,0.3509957289341409},
{-0.1518817312930063,-0.5150554128634137,0.33011184944641014},
{-0.17276453318117627,-0.5150521800647315,0.30780338333934093},
{-0.19214516128163225,-0.5150489472660491,0.2841759353698887},
{-0.20994602842599877,-0.5150457144673668,0.25933834309369136},
{-0.22608308184853582,-0.515044636867806,0.23339513366814352},
{-0.2404765791817463,-0.5150424816686845,0.20645191185020073},
{-0.25307802844539556,-0.5150414040691237,0.1786293687906693},
{-0.26383678246012743,-0.5150414040691237,0.15004604044123393},
{-0.272705426845268,-0.5150414040691237,0.12082046275357938},
{-0.279633314421461,-0.515040326469563,0.09107246479886334},
{-0.2846053587948557,-0.515040326469563,0.06093265164385119},
{-0.2876010855737975,-0.515040326469563,0.030531628355308284},
{-0.2886064859639963,-0.515040326469563,3.7634733620082576e-10},
{-0.32133318462459387,-0.5216417013788426,2.5089858333373744e-10},
{-0.3534434963364309,-0.5238389268832535,-0.03483135836273833},
{-0.38658291562880354,-0.521466052650437,-0.03698644972432309},
{-0.03846491632170008,-0.5217483837353588,0.5231691987562346},
{-0.025712700103503405,-0.5239951788195651,0.49237679130721984},
{-0.042740831378837094,-0.5217160557485357,0.44809391495692025},
{-0.05519518830244121,-0.5150694216577039,0.40431320000193965},
{-0.08113387180983382,-0.5150661888590214,0.3881761465794027},
{-0.08670484601910472,-0.5042061404855771,0.34527906326425384},
{-0.10872149816511732,-0.5042039852864556,0.327212029028377},
{-0.1295107644114124,-0.504201830087334,0.3077462705626201},
{-0.14897652287716925,-0.5042007524877733,0.2869539870375549},
{-0.16704355711304608,-0.5041985972886517,0.26493324001321134},
{-0.183636435149789,-0.5041985972886517,0.24178209104961967},
{-0.19867972501814404,-0.5041975196890909,0.21759860170680995},
{-0.21210014994797885,-0.5041975196890909,0.19248083354481224},
{-0.22384921795905874,-0.5041975196890909,0.1665408569179467},
{-0.2338827474693921,-0.5041975196890909,0.13989074218053346},
{-0.24215332409830506,-0.5041985972886517,0.11264255968689267},
{-0.2486146110646845,-0.5041985972886517,0.08490708667187147},
{-0.25325044437511884,-0.5041985972886517,0.05680738500530987},
{-0.25604573763575733,-0.5041985972886517,0.028464469117882387},
{-0.25698217165406684,-0.5041985972886517,2.5089858333373744e-10},
{-0.2876010855737975,-0.515040326469563,-0.030531628355308284},
{-0.3202588178625058,-0.5216417013788426,-0.03266689188497487},
{-0.3500296609279102,-0.523841082082375,-0.06951357694626605},
{-0.01296009594946486,-0.5217182109476572,0.4615854614577659},
{-0.028250888884937656,-0.5150704992572646,0.4187099301338325},
{-0.03937613451028754,-0.5042082956846987,0.3769130759702302},
{-0.06355746865397575,-0.5042072180851379,0.3618697861018752},
{-0.06847121489113278,-0.48928461936758916,0.32151583775014453},
{-0.08897254653479,-0.48928461936758916,0.3046923534073967},
{-0.10833097608429412,-0.48928354176802835,0.2865660511956775},
{-0.12645576965662825,-0.48928354176802835,0.2672058974868762},
{-0.14327925399937602,-0.48928246416846755,0.24670241064409743},
{-0.15872879890214153,-0.48928246416846755,0.22514503143088518},
{-0.172737593192157,-0.48928246416846755,0.20262643340946576},
{-0.18523451529841153,-0.48928246416846755,0.17923605734338302},
{-0.19617646123847438,-0.48928246416846755,0.15507950798959255},
{-0.20552140462947543,-0.48928246416846755,0.13026131250548903},
{-0.2132240862898624,-0.48928246416846755,0.10488675236815972},
{-0.2192424798367652,-0.48928246416846755,0.07906024697504334},
{-0.22356042127677225,-0.48928246416846755,0.052895052039976784},
{-0.22616282421603282,-0.48928246416846755,0.026503992236972765},
{-0.22703567986025686,-0.48928246416846755,6.272459195345632e-11},
{-0.25604573763575733,-0.5041985972886517,-0.028464469117882387},
{-0.31705403676877464,-0.5216427789784034,-0.06519391134696174},
{0.7252336639947585,-0.5217570045318449,0.146567549059067},
{0.693032833919817,-0.5239984116182475,0.13794028697553903},
{0.6608373918426791,-0.5217171333480966,0.12931302489201105},
{0.6291872151432912,-0.5150694216577039,0.12083231634874785},
{0.5986254140002812,-0.5042072180851379,0.11264363728645345},
{0.569694020992717,-0.48928569696714996,0.10489117052635889},
{0.7568967718888758,-0.5151470088260792,0.15505256800057327},
{0.7657923562630357,-0.5151470088260792,0.11687321556247733},
{0.7336421733674502,-0.5217570045318449,0.11047766216930491},
{0.7009467250941149,-0.5239984116182475,0.10397456433996757},
{0.6682555872190227,-0.5217171333480966,0.09747189755045456},
{0.6361194131177272,-0.5150694216577039,0.09107957695596443},
{0.6050877785662215,-0.5042072180851379,0.08490697891191538},
{0.5757113369400592,-0.48928569696714996,0.07906347977372565},
{-0.04691685295669071,-0.48928569696714996,0.33696538265291},
{-0.03152517515033858,-0.47045895504093,0.3139306144418816},
{-0.05160581192547103,-0.47045895504093,0.2995360395091103},
{-0.0707054020604781,-0.47045895504093,0.2838623538977046},
{-0.08874032382944397,-0.47045895504093,0.2669742135813105},
{-0.1056265244666286,-0.47045895504093,0.24893735213313525},
{-0.12129924023842964,-0.47045895504093,0.22983474471935805},
{-0.13569403069111305,-0.47045895504093,0.20975152170527975},
{-0.14874483897160362,-0.47045895504093,0.1887706582570797},
{-0.16038830222572797,-0.47045895504093,0.16697836233961952},
{-0.17058347167017693,-0.47045895504093,0.14447161791336854},
{-0.17929047612120189,-0.47045895504093,0.12134848653835689},
{-0.18646836679549364,-0.4704578774413692,0.09770746081443897},
{-0.19207619490974293,-0.4704578774413692,0.07364746438129352},
{-0.19610102926922043,-0.4704578774413692,0.04927302439631526},
{-0.024399720470673906,-0.48928569696714996,0.3509741769429255},
{-0.014257558148619268,-0.5042082956846987,0.3903335009000651},
{-0.0010098185483979275,-0.48928569696714996,0.36347109904918007},
{-0.010547512172834006,-0.4704578774413692,0.32698142272237213},
{0.001979119353310982,-0.4481418681373746,0.3052839555662597},
{-0.017606252663691382,-0.4481418681373746,0.293097382133507},
{-0.03635411430206297,-0.44814294573693525,0.27965648281201766},
{-0.05418633959364795,-0.44814294573693525,0.2650205255776338},
{-0.07102480257029045,-0.44814402333649606,0.24925093360531947},
{-0.08679148502379068,-0.44814402333649606,0.23240805247047783},
{-0.10142561033892118,-0.44814402333649606,0.2145694693414843},
{-0.11486683294027886,-0.44814402333649606,0.19581600418539669},
{-0.12705383741285584,-0.44814402333649606,0.1762252441705905},
{-0.13792789458059015,-0.44814402333649606,0.15587585406500187},
{-0.14744848669999677,-0.44814510093605686,0.13485942983129642},
{-0.15558113058513112,-0.44814510093605686,0.11327080023082182},
{-0.1622848774526839,-0.44814510093605686,0.09119983706694641},
{-0.16752524411671046,-0.44814510093605686,0.0687401837415011},
{-0.17128606658379922,-0.44814402333649606,0.04598882421495525},
{-0.14952609865316213,-0.42276547608079196,0.04308986587657067},
{-0.13123492370864506,-0.39474249950295726,0.040623671521791485},
{-0.11682321494285755,-0.3644985902303746,0.03863765553129161},
{-0.00042231126786589605,-0.5150704992572646,0.4313156897957248},
{0.011685274117082301,-0.5042082956846987,0.40208472411026647},
{0.023147592885041167,-0.48928569696714996,0.3744130449892429},
{0.011243350537210352,-0.4704578774413692,0.3386238083769357},
{0.022323768020832187,-0.4481418681373746,0.31615585753487246},
{0.012978716869875036,-0.4227547000851843,0.28623091773227793},
{-0.005383902925521137,-0.4227547000851843,0.27480189679074685},
{-0.022961534544878492,-0.4227547000851843,0.26219505952929373},
{-0.03968120294594165,-0.4227547000851843,0.24846751872463937},
{-0.055470083950393746,-0.4227547000851843,0.23367638715350458},
{-0.07025518096398821,-0.4227547000851843,0.21787769999304948},
{-0.08397948896996027,-0.4227547000851843,0.20114581161296718},
{-0.09658611071150124,-0.422755777684745,0.18355615398251163},
{-0.10801793341189031,-0.422755777684745,0.16518200387181523},
{-0.1182180598143188,-0.4227579328838666,0.1460977156505711},
{-0.12715082137332517,-0.42275901048342734,0.12639057488320168},
{-0.1347813038631405,-0.42276116568254885,0.10614872921377798},
{-0.14107448529803976,-0.42276224328210965,0.0854593564467663},
{-0.14599372729295673,-0.42276439848123115,0.06440963438663302},
{-0.12789005467201367,-0.39473818910471414,0.0607274766874805},
{-0.1136195114486871,-0.3644867366352062,0.057765047734966546},
{-0.10327143062656484,-0.3325671600456256,0.05561038741320609},
{-0.09693428312958617,-0.2995355007093299,0.05435175112622624},
{-0.09469664764164638,-0.26594995519879827,0.054077178758141935},
{0.033749340643768784,-0.4704578774413692,0.3488189778213846},
{0.043336312896118896,-0.4481418681373746,0.32567429445515755},
{0.032053414455028295,-0.4227547000851843,0.29642608717672686},
{0.040254054872447265,-0.39471340431481644,0.279795493155357},
{0.022249952450919416,-0.39471232671525563,0.27016929627899483},
{0.0049179488754440715,-0.39471124911569483,0.25937605907831834},
{-0.011673571385852273,-0.394710171516134,0.24746966153136596},
{-0.02745626696882555,-0.394710171516134,0.23450398361617628},
{-0.042361731853358064,-0.3947090939165734,0.22053182771122704},
{-0.05632181864322669,-0.3947090939165734,0.2056081513941175},
{-0.0692822163205686,-0.3947090939165734,0.18980299863629777},
{-0.08118915266730134,-0.394710171516134,0.17318749100877867},
{-0.09198842442551818,-0.39471232671525563,0.1558349052816926},
{-0.10162625937713665,-0.39471555951393794,0.13781313022736813},
{-0.11006882089594858,-0.3947209475117418,0.11920837381066683},
{-0.117282595635614,-0.3947263355095457,0.10010328791789984},
{-0.12323417800974902,-0.3947317235073495,0.08058170979489508},
{-0.1091641760646818,-0.3644727278409161,0.07666269571228523},
{-0.09896114014343924,-0.33254884085309244,0.07381169055435494},
{-0.09272205420649067,-0.2995236471141614,0.0721385017163467},
{0.0588492206530577,-0.39471448191437714,0.2882233993201424},
{0.05175430514494525,-0.4227547000851843,0.3053518443385882},
{0.06446674716335389,-0.36443824465497143,0.2746628864474075},
{-0.10347380382407753,-0.3644597966461869,0.09525408989443297},
{-0.09345859350627726,-0.3325305216605594,0.09172549013269021},
{-0.08679611870190199,-0.33251220246802626,0.1092718282608028},
{-0.09658104599356562,-0.3644468654514576,0.11345722495483511},
{-0.08851833831992527,-0.36443608945584993,0.13119235852599467},
{-0.07900636699700478,-0.33249711607417554,0.1263722556906686},
{-0.07012166637840875,-0.33248526247900706,0.1429468145348784},
{-0.07931833206984781,-0.36442854625892457,0.14837683872160054},
{-0.06901335523015638,-0.3644231582611207,0.16492876797503417},
{-0.04921429522025324,-0.3324755640829601,0.17421121059151057},
{-0.057655132579767926,-0.3644220806615599,0.18077917991440626},
{-0.04529538889759945,-0.3644220806615599,0.1958591081678275},
{-0.03729033280046032,-0.3324755640829601,0.18876419265971506},
{-0.06017456035284917,-0.3324787968816424,0.158916840025496},
{-0.03198563344265578,-0.3644231582611207,0.21009850876384784},
{-0.024451973273375664,-0.3324755640829601,0.20250681985822022},
{-0.01777754788987145,-0.3644253134602423,0.22342733773101714},
{0.0037575896684064816,-0.3324744864833993,0.22730238575154757},
{-0.0027355942449717543,-0.36442746865936376,0.23579602548954},
{0.013075485310432221,-0.3644296238584854,0.24715284726049946},
{0.019004114813922834,-0.3324734088838385,0.2382594180854612},
{-0.010748570698882551,-0.3324744864833993,0.21536904821557595},
{0.02959142273853612,-0.3644328566571677,0.2574460782649785},
{0.03492877336303201,-0.3324744864833993,0.24819165323708214},
{0.04674745430573765,-0.3644350118562891,0.26662722652274246},
{0.06855171157832239,-0.332480952080764,0.2648006952672366},
{0.051469280061121475,-0.3324777192820816,0.25704844402705423},
{-0.3205249849540161,0.18125601772004718,0.18870169188519037},
{-0.37432845342372234,0.17851999243525107,0.21562012891323545},
{-0.4340447106833759,0.17333781614750612,0.23530679528895024},
{-0.3761679158739575,0.21212062433963352,0.22312884265268373},
{-0.3200508411472771,0.21430707384843672,0.19454766950236993},
{-0.2743616973701722,0.21518962788870766,0.1604578073973977},
{-0.2763455581615505,0.1826676731446564,0.1563672394647132},
{-0.32233319701698887,0.25365669940952934,0.19676967979667853},
{-0.38002572230151554,0.25213620642928225,0.22609655184304547},
{-0.4386212760179679,0.20719383914779116,0.24390280698521588},
{-0.4443034585019103,0.24753593390435333,0.2471075880789471},
{-0.3875355136405246,0.3004428395394986,0.22121179303407315},
{-0.3295315620829352,0.3012144008250103,0.19269850865608787},
{-0.28289951869015617,0.30091482814711606,0.15842653222534547},
{-0.2757033088233313,0.2539498064900589,0.16181773804308996},
{-0.49596034864656185,0.16458770771405035,0.24594809095155812},
{-0.5033181984475023,0.19809027805840268,0.25457319783596455},
{-0.5106879018436111,0.23800241059021743,0.2571131000007004},
{-0.5183323931277165,0.2861721885562159,0.24931451197940493},
{-0.45208049453199045,0.2962229596595216,0.24105471134609965},
{-0.39741710161278937,0.3518648129799022,0.20888728685754188},
{-0.340863599063997,0.35076027343011257,0.1831024845674273},
{-0.29601067254604985,0.3491912884696308,0.15153528303421862},
{-0.267598682526777,0.35112881247989597,0.11675144681211028},
{-0.2524702622931211,0.30192777173424024,0.12130969295416914},
{-0.24461348389554394,0.2548700765149568,0.12393041508596281},
{-0.556364114425987,0.15114680839256092,0.2457293382407217},
{-0.5661659600307547,0.18337457845652183,0.2528425729413673},
{-0.5747027037511779,0.22168108764278868,0.2534223215050618},
{-0.5814603305967692,0.2679111863994004,0.2430784433212265},
{-0.5869442347615298,0.3179128836187086,0.22349630410290644},
{-0.5259370132280734,0.33810817698710705,0.23225287813372686},
{-0.46093513012284093,0.34853718553624313,0.22632715814905033},
{-0.408388142740993,0.40122426086099133,0.18953683154478745},
{-0.35554589307949397,0.396076567759191,0.16874993601752605},
{-0.31510034876509785,0.3918868606669156,0.14239508355976396},
{-0.2908295738578657,0.39622850929725956,0.11171797926375165},
{-0.2783434277472188,0.40352170312455377,0.0772284354816897},
{-0.2518969793267912,0.35446937111828425,0.07941229875154703},
{-0.23496034703016253,0.3035517142723213,0.0820587755128431},
{-0.22615204822042512,0.256028496042785,0.083843388145435},
{-0.2431942852740093,0.21620149387627108,0.1231545434022081},
{-0.2455035811327403,0.18387673985184083,0.12042821651345895},
{-0.6130339977273426,0.13437580314842262,0.2353412784748949},
{-0.6637512210550023,0.11563311398794272,0.2154692649747276},
{-0.6261225219924601,0.1642073150690984,0.24059888673189378},
{-0.6366355833073363,0.19995883569677855,0.23937473363085857},
{-0.6422757394084085,0.24398093295337173,0.22722048818492901},
{-0.6450484030782709,0.29183174144938223,0.2061178559863619},
{-0.6469589870995168,0.3390640077975104,0.17804746502785326},
{-0.5916576552403398,0.3675320329939434,0.19636126956314653},
{-0.5331892582720583,0.3893157081149174,0.20700579802443672},
{-0.4698511888886554,0.3997587254583435,0.20351006504929747},
{-0.4177179997381433,0.4440480674060078,0.16292335519244042},
{-0.3669943108131189,0.43375483640152873,0.147806788553953},
{-0.3343398113230929,0.42056070737945567,0.1338831246292384},
{-0.3239205011700037,0.4337925523861557,0.11076107085378752},
{-0.3159096260352364,0.4461472313503885,0.07760505652817896},
{-0.27324961462345704,0.4081866316231289,0.039439281844548715},
{-0.24518030126450915,0.35711272284085416,0.04017948498284193},
{-0.22708309424093073,0.3050862160468583,0.041385103371431864},
{-0.21740517258565162,0.2570349740325446,0.04228845508322571},
{-0.22409167786023207,0.21716055748535676,0.08344144350926762},
{-0.22601842587488957,0.18481963946751492,0.08178711266357289},
{-0.6821458455573534,0.14174582982439976,0.21972901603845307},
{-0.7047237115546151,0.09631250818302166,0.18622752329366152},
{-0.726921184906925,0.11728625947412064,0.18982455062751316},
{-0.6967774923934941,0.1742214477873379,0.21830873981735763},
{-0.701588974432334,0.21692348558198726,0.20661355178431628},
{-0.7013422041329176,0.2637430312983405,0.18617795371386608},
{-0.7007990939542893,0.3085733282255114,0.1585342921814225},
{-0.7013389713342353,0.3489024917873444,0.12717183456476022},
{-0.6491680661990963,0.38213458464194333,0.1454791735026889},
{-0.5961027534285177,0.412612333019213,0.16335978301455245},
{-0.5397733915883656,0.4353011917712342,0.17465087121230488},
{-0.4778114168440664,0.44517200374789134,0.17318856860833942},
{-0.42267388011812645,0.475860961639072,0.12880763069800974},
{-0.3686247189485645,0.46038878714553033,0.11843465732603368},
{-0.7596521939657657,0.1427318334225047,0.1909312453764244},
{-0.7531327166231047,0.0921231243706145,0.15047492506642055},
{-0.7824154070874801,0.10233090172992446,0.15135209110888767},
{-0.8164513892144137,0.13888911338879736,0.17563903000953138},
{-0.8129405698454237,0.17897904984813928,0.17869617996343706},
{-0.7587082167505308,0.19312577688193336,0.18814457291227207},
{-0.7565400864342607,0.2384916407908072,0.17024025621007158},
{-0.7548805831106743,0.28071953477871764,0.1442938139858414},
{-0.7549861878676297,0.31794521160553174,0.11460271328793406},
{-0.7581123041934248,0.3483044240311167,0.08546614532399917},
{-0.7043368533122986,0.38221540460900116,0.09557995600160994},
{-0.6528319047057156,0.41749816942774615,0.11088391720371535},
{-0.6007838459205044,0.44900071498730854,0.12617828776972992},
{-0.5453779869039325,0.4715721153872058,0.1362656972581018},
{-0.4837996376032677,0.4800571343287121,0.13594672778811376},
{-0.42497132238168894,0.4975832135850821,0.08904043530711857},
{-0.36620766313375647,0.47778986485285113,0.08263981719601052},
{-0.7321637067700731,0.07780742972569164,0.14773027898513827},
{-0.7663527080346362,0.07047813631311163,0.10412068684040804},
{-0.7920944063423199,0.07624027668446322,0.10527673564920255},
{-0.8226993114677607,0.10519699328170554,0.14805571405249093},
{-0.8625931248070422,0.13618649369038516,0.16756349890111785},
{-0.8618592795061577,0.1714304649249425,0.17319718940482562},
{-0.8625995904044069,0.20871972012584206,0.16389858279493766},
{-0.8113608088893343,0.2209181471537632,0.1648694999991918},
{-0.8109071394742499,0.2601600127587788,0.1417959382039756},
{-0.8124782796338532,0.2942951340453034,0.11393352396069564},
{-0.8169729474018267,0.32091830879369737,0.08574071769208347},
{-0.8225484475292527,0.33998643302153,0.057298662645065106},
{-0.7625477039855558,0.3710062139778672,0.05674617735025811},
{-0.708343368479243,0.40741722553673887,0.06381576926869244},
{-0.6568578166647538,0.44410518018272854,0.07476730584484614},
{-0.6050123465969676,0.4759525576017375,0.08586087004310937},
{-0.5497293339303234,0.49784291507922784,0.09335665258782841},
{-0.4879300767197007,0.5046598099006615,0.09351462868343735},
{-0.4263215546313343,0.5101297052711322,0.04547071434613683},
{-0.36551584421574185,0.48777274718382824,0.042424879187619245},
{-0.31284385528484454,0.45338223480140105,0.03993185260377688},
{-0.27255133010807786,0.4098622989401269,-4.4864133553379167e-17},
{-0.24406714091823334,0.35825928877351393,-3.7386777961149303e-17},
{-0.225551825265076,0.3058308373433507,-2.990942236891944e-17},
{-0.21546118297802178,0.2574994194432366,-1.2544875286708835e-10},
{-0.21224993628692593,0.21818535466764943,-5.017960890679141e-10},
{-0.21459587053072315,0.21788362679063372,0.04212228923095491},
{-0.21591161959442381,0.18543602641627563,0.04134404682816651},
{-0.8635618868121749,0.24442167117372685,0.1442765723928691},
{-0.8665942519761829,0.27504489549170064,0.11870836761446936},
{-0.8735458467427129,0.2971001257019888,0.09157128563554398},
{-0.8814985315011985,0.3116186245842486,0.06267459133383657},
{-0.8875330890415128,0.31963381011725894,0.03182539438796925},
{-0.8273674727650181,0.35145963554505255,0.028690765025644178},
{-0.766579003942398,0.38525962336817754,0.02830369126341544},
{-0.7119069902267108,0.42341526861593654,0.031936602662640756},
{-0.6601488057233468,0.46090819013382167,0.037637104339116274},
{-0.6081007469381355,0.49272000676732525,0.0434530169285503},
{-0.5525580327773459,0.5138323373619393,0.04743216106665115},
{-0.49031695974680717,0.5192257231635952,0.04762235738912713},
{-0.4267601376525678,0.514110358048618,-6.449217851298804e-17},
{-0.36560097458104274,0.4909096395052309,-5.981884473783888e-17},
{-0.3125475154056327,0.4557195482487121,-5.292026786969882e-17},
{-0.31284385528484454,0.45338223480140105,-0.03993185260377688},
{-0.27324961462345704,0.4081866316231289,-0.039439281844548715},
{-0.24518030126450915,0.35711272284085416,-0.04017948498284193},
{-0.22708309424093073,0.3050862160468583,-0.041385103371431864},
{-0.21740517258565162,0.2570349740325446,-0.04228845508322571},
{-0.21459587053072315,0.21788362679063372,-0.04212228923095491},
{-0.21591161959442381,0.18543602641627563,-0.04134404682816651},
{-0.213202534298647,0.1856623223240374,-7.526946724016515e-10},
{-0.2186120840937145,0.15749710260418098,-0.040411061128451484},
{-0.21995369554687366,0.13187049192958747,-0.03978098866526902},
{-0.9075290264911688,0.23103034143203283,0.14497054651000527},
{-0.9101109550387747,0.2572828219315218,0.12246487968331504},
{-0.9204602212204138,0.273892941561237,0.09812578496393005},
{-0.932545500294454,0.28316245298298415,0.0700755451172078},
{-0.940337622718385,0.28739634165725114,0.036435365308945096},
{-0.8900708360071272,0.3220142275470008,-1.2544875286708835e-10},
{-0.8295862502606444,0.3552980451805168,-4.11254018772862e-17},
{-0.7684928207623263,0.3902736941244423,-4.627891401671465e-17},
{-0.7135783471454656,0.4291125374937298,-5.3276091244665206e-17},
{-0.6616111083273123,0.46685869490839593,-5.841677994932049e-17},
{-0.6093593832251154,0.4985573635880186,-6.542678061204423e-17},
{-0.5535914507561247,0.5192558959512968,-6.670395161146932e-17},
{-0.4910745122380288,0.5239994892178083,-6.729609257011267e-17},
{-0.49031695974680717,0.5192257231635952,-0.04762235738912713},
{-0.4263215546313343,0.5101297052711322,-0.04547071434613683},
{-0.36551584421574185,0.48777274718382824,-0.042424879187619245},
{-0.3159096260352364,0.4461472313503885,-0.07760505652817896},
{-0.2783434277472188,0.40352170312455377,-0.0772284354816897},
{-0.2518969793267912,0.35446937111828425,-0.07941229875154703},
{-0.23496034703016253,0.3035517142723213,-0.0820587755128431},
{-0.22615204822042512,0.256028496042785,-0.083843388145435},
{-0.22409167786023207,0.21716055748535676,-0.08344144350926762},
{-0.22601842587488957,0.18481963946751492,-0.08178711266357289},
{-0.22917363738882537,0.156877482856738,-0.07981445890762656},
{-0.23079542472778483,0.1312044276410753,-0.07845743778074836},
{-0.9426900225595468,0.2214181533499607,0.13797369256192293},
{-0.9070548826844298,0.19959245184611663,0.16116579030882386},
{-0.9365293858706223,0.24286238460929205,0.12298536027116715},
{-0.9536211925040019,0.24822236482456408,0.10639690039262341},
{-0.9696623395656304,0.25184740974699577,0.07815948150219534},
{-0.9790417661425761,0.2523668127352871,0.04124824822721402},
{-0.9431598559680427,0.2882551885071852,-5.017960890679141e-10},
{-0.940337622718385,0.28739634165725114,-0.036435365308945096},
{-0.8875330890415128,0.31963381011725894,-0.03182539438796925},
{-0.8273674727650181,0.35145963554505255,-0.028690765025644178},
{-0.766579003942398,0.38525962336817754,-0.02830369126341544},
{-0.7119069902267108,0.42341526861593654,-0.031936602662640756},
{-0.6601488057233468,0.46090819013382167,-0.037637104339116274},
{-0.6081007469381355,0.49272000676732525,-0.0434530169285503},
{-0.5525580327773459,0.5138323373619393,-0.04743216106665115},
{-0.9431706319636504,0.19183373500856962,0.15072277296539774},
{-0.9030343587231954,0.16742933775580193,0.16657102970564827},
{-0.9354259239203935,0.162420654997341,0.15375298293028417},
{-0.9579876259242437,0.1518461705075009,0.12968048634223378},
{-0.9693897068767554,0.18373772950850145,0.12662118118920654},
{-0.968931727063428,0.2170172367437743,0.11737753215691789},
{-0.986815569373974,0.21490514160466428,0.08558414247590353},
{-0.9969051340614674,0.2121615731229428,0.04499172134137438},
{-1.0,0.21063245934620956,-1.003593255735389e-09},
{-0.9820655105100978,0.25185064254567807,-8.781434252687399e-10},
{-0.9790417661425761,0.2523668127352871,-0.04124824822721402},
{-0.9696623395656304,0.25184740974699577,-0.07815948150219534},
{-0.9005213965474788,0.1374397419795612,0.15897287520265604},
{-0.924674713102587,0.14147858513332867,0.14929172074869462},
{-0.9359679564994609,0.12641654503261623,0.13128395448866015},
{-0.9464648538209255,0.11123111978219558,0.0973276069692674},
{-0.972597720769169,0.14034387279583746,0.09490818043542566},
{-0.986847897360797,0.17638634530492564,0.09146266359981832},
{-0.9966820709523878,0.17086149235685572,0.04784585153803091},
{-0.9996939617247411,0.16855650689636778,-8.781434252687399e-10},
{-0.9969051340614674,0.2121615731229428,-0.04499172134137438},
{0.9596719140377278,0.010279545490057253,0.12846172123900243},
{0.9721925433343194,-0.05091668700635838,0.1222148765852163},
{0.9736893291242295,-0.15079982133399283,0.14692638971280356},
{0.9783628784192908,-0.19220335165791388,0.15083268812059633},
{0.9804889823526909,-0.22950338285442115,0.15290814487464013},
{0.962938118306423,0.06102381656669236,0.10708052955397615},
{0.9618389667544373,0.1071178144987788,0.08849182937073034},
{0.9764566047962879,0.05781364747515729,0.08660527581968958},
{0.9754835323929122,0.004479689134078706,0.10336776802729775},
{0.9423160955119595,0.14636980953966564,0.08030196494891909},
{0.9549315535698988,0.146058383266603,0.07149345061926954},
{0.9733638940568767,0.10605950397014617,0.07155638243361853},
{0.9344097475345869,0.1768357043217669,0.06332578474841014},
{0.9273169872255961,0.1465680878588474,0.08489922019507784},
{0.9448355232850407,0.176891739498927,0.05678163037580746},
{0.9644596888862309,0.14619092801257774,0.05785039362017957},
{0.9217199351069545,0.17671393557139986,0.06646289258972497},
{0.9106379012239915,0.14609502165166915,0.08590839218373934},
{0.9075775184714036,0.17555874884225398,0.06699156293423894},
{0.9145916140124581,0.20087910572167653,0.05035536539515306},
{0.9255906727292418,0.1995568910606112,0.04912442341688501},
{0.9341672876334136,0.19866356102473254,0.045052282436689677},
{0.9521836746899341,0.17785080310801266,0.04603182043742999},
{0.9182435989239092,0.21547411417275106,0.03714291718054696},
{0.9260745149320277,0.21057534656948873,0.03740057123552717},
{0.9389787696722535,0.20067974980293396,0.03664506618347103},
{0.9080775246676009,0.21875756003441854,0.03665142402087957},
{0.9025128005357825,0.2001474156199134,0.05023920016250202},
{0.8973909698234407,0.2188707079882994,0.035974583736759665},
{0.9043242453974376,0.23004649303304944,0.02542617715629019},
{0.9147500211478915,0.2255270404751783,0.02682641002555527},
{0.9260863685271963,0.2160991219179979,0.030105006689199274},
{0.8941635591389333,0.23073831195106403,0.024521101285199114},
{-0.13982231460842454,-0.10640702982849465,-0.025286735773126498},
{-0.15359188179594896,-0.07933643574246879,-0.028521689654559295},
{-0.13874794784633643,-0.10686393204226131,-0.050192216821652424},
{-0.15299704683840368,-0.07995379253083416,-0.05652117456196925},
{-0.1665985084944479,-0.05475315696261322,-0.03185750685488021},
{-0.16671057884876803,-0.05552202424922292,-0.06307125573215616},
{-0.13667033589317104,-0.10753312136949973,-0.07433529618093328},
{-0.17856848441548573,-0.03388985962649322,-0.06919008155812276},
{-0.1872528592757345,-0.015377992291930343,-0.07422527326577862},
{-0.19007724772451381,-0.017000318430670208,-0.10957571133694005},
{-0.19989956772093614,-0.00035862513382440046,-0.11617708624621965},
{-0.21089108324079445,0.01597487468864107,-0.12224828217160019},
{-0.22210673946929296,0.03397282401667692,-0.125140559392708},
{-0.2151249719150614,0.057487889127936384,-0.08175834075530031},
{-0.22246450252346875,0.08089432142747459,-0.0799109040683155},
{-0.228124055416635,0.10567156812826883,-0.07865011258221412},
{-0.17746610006481756,-0.032999223589516465,-0.034952588313325005},
{-0.1848174842683934,-0.014416773483723134,-0.03746511944921731},
{-0.18995978937238983,0.002506604338308069,-0.039358785157359175},
{-0.19414949646466523,0.0014849321947416345,-0.07824288770819898},
{-0.20064634421655006,0.01817031137778108,-0.08130887397850296},
{-0.20741474705774907,0.03629796058895127,-0.08271632676482521},
{-0.20518627116607585,0.0584463061772856,-0.04096527058255571},
{-0.21178872367491622,0.08165435239768595,-0.040430026880721046},
{-0.21719504067130138,0.10635929216795252,-0.039911270452166164},
{-0.19419906604446066,0.01928334241210963,-0.04059748585246477},
{-0.19883920975313807,0.0374257978412448,-0.041145014189292214},
{-0.7272617063681285,-0.035205500930237825,2.0562754818621136e-17},
{-0.7274955454728156,-0.006445769532704342,-0.05525402523845931},
{-0.7342779571083047,0.01605881969442509,-0.05316488296999371},
{-0.7188553521945584,0.019217447198968517,-0.10350052829318467},
{-0.2908295738578657,0.39622850929725956,-0.11171797926375165},
{-0.3239205011700037,0.4337925523861557,-0.11076107085378752},
{-0.9150398954297385,0.08121663145610102,-0.05287015949012299},
{-0.9464648538209255,0.11123111978219558,-0.0973276069692674},
{-0.952996184758755,0.10130750542706078,-0.0516051653657346},
{-0.9552699198319806,0.09766123179328193,-1.2544875286708835e-10},
{-0.9166099579897811,0.07675601583424796,3.73867779611493e-18},
{-0.8726191111204503,0.06948739127693931,0.05372383386216532},
{-0.8701147697412199,0.08398056656952108,0.1027522431581857},
{-0.8286056346603433,0.07948363584247002,0.10464461574685463},
{-0.748742576012526,0.06226618110030458,0.10231042733826981},
{-0.972597720769169,0.14034387279583746,-0.09490818043542566},
{-0.9811279988922277,0.13254991845265324,-0.04999038242392013},
{-0.9838737225730707,0.1295803773430382,-5.017960890679141e-10},
{-0.952996184758755,0.10130750542706078,0.0516051653657346},
{-0.9150398954297385,0.08121663145610102,0.05287015949012299},
{-0.9108523435365847,0.09350320612809318,0.10012774942792933},
{-0.9045699380972932,0.11252079093652562,0.1361600925011463},
{-0.8660586849944799,0.1066254592594628,0.1423896955619601},
{-0.986847897360797,0.17638634530492564,-0.09146266359981832},
{-0.9966820709523878,0.17086149235685572,-0.04784585153803091},
{-0.9811279988922277,0.13254991845265324,0.04999038242392013},
{-0.986815569373974,0.21490514160466428,-0.08558414247590353},
{0.9863252615738234,0.10560842079400767,-0.025828337312369713},
{0.9710589085963889,0.14655838946280045,-0.04058132185905321},
{0.9521836746899341,0.17785080310801266,-0.04603182043742999},
{0.9389787696722535,0.20067974980293396,-0.03664506618347103},
{0.9260745149320277,0.21057534656948873,-0.03740057123552717},
{0.9260863685271963,0.2160991219179979,-0.030105006689199274},
{0.9147500211478915,0.2255270404751783,-0.02682641002555527},
{0.9136293176046901,0.23100878944081743,-0.017545691568376116},
{0.902534352526998,0.2362146729188993,-0.01600677163563988},
{0.9019125775804334,0.23872763509461595,-0.007720192653249474},
{0.9748908526344885,0.14694740290423858,-0.020894978763206656},
{0.9569800703349233,0.1790296970274955,-0.03224490389697717},
{0.9414550934629039,0.20340176629344006,-0.025455164584474915},
{0.9597473460069817,0.17974091273760395,-0.016589537478104523},
{0.943027311222068,0.20462484179491447,-0.013035075326903296},
{0.9263740876099219,0.22046555533823967,-0.020469542456614493},
{0.9268676282087548,0.22223605141658542,-0.010354654179442957},
{0.9134008664978068,0.2332092477439106,-0.008671271249589838},
{0.9784771039727324,-0.2644908853935151,0.15358272219968244},
{0.9707367063277186,-0.29895790734475697,0.15329069271871365},
{0.958225775427174,-0.332471253684717,0.15208593640977233},
{0.8785814694901931,-0.4483326032596309,0.13921400965636965},
{0.7968487756044391,-0.5043214436385797,0.12305109384437415}
};


// texture array: 44kb.
const tgx::fVec2 bob_tex_array[5647] PROGMEM = {
{0.80372,0.728518},
{0.79918,0.735578},
{0.799687,0.728214},
{0.804029,0.721347},
{0.800135,0.721034},
{0.795714,0.727849},
{0.795075,0.735224},
{0.794366,0.742802},
{0.798598,0.743177},
{0.803348,0.735886},
{0.807828,0.728757},
{0.807991,0.721569},
{0.808106,0.714514},
{0.804286,0.7143},
{0.800536,0.713988},
{0.796288,0.720689},
{0.791781,0.727428},
{0.791022,0.734784},
{0.790185,0.742364},
{0.789301,0.750067},
{0.793617,0.750512},
{0.797972,0.750905},
{0.802901,0.743489},
{0.807601,0.736128},
{0.812005,0.728918},
{0.812006,0.721753},
{0.811969,0.71467},
{0.811913,0.707652},
{0.808197,0.707526},
{0.80448,0.707399},
{0.800914,0.707009},
{0.79683,0.713612},
{0.792481,0.720251},
{0.787871,0.726947},
{0.786993,0.734294},
{0.786031,0.741859},
{0.785019,0.749541},
{0.788402,0.75779},
{0.792836,0.758271},
{0.797331,0.758655},
{0.801902,0.758963},
{0.802415,0.751215},
{0.807296,0.743733},
{0.811938,0.736284},
{0.816244,0.728991},
{0.816056,0.721872},
{0.815848,0.714811},
{0.81563,0.707778},
{0.788684,0.719787},
{0.793141,0.713206},
{0.789464,0.712749},
{0.7849,0.719246},
{0.783966,0.726402},
{0.782968,0.733732},
{0.781884,0.741282},
{0.780746,0.748953},
{0.783997,0.75724},
{0.78751,0.765456},
{0.792077,0.765934},
{0.796696,0.766337},
{0.801397,0.766641},
{0.806186,0.766896},
{0.806565,0.759216},
{0.806942,0.751465},
{0.811773,0.74389},
{0.816352,0.736302},
{0.820514,0.729019},
{0.820125,0.721981},
{0.819735,0.714943},
{0.819346,0.707905},
{0.797348,0.706618},
{0.793782,0.706227},
{0.790216,0.705836},
{0.785791,0.712219},
{0.781107,0.718681},
{0.780068,0.725801},
{0.778945,0.733125},
{0.777747,0.740641},
{0.776477,0.748285},
{0.779588,0.756647},
{0.782975,0.764889},
{0.786646,0.772987},
{0.79134,0.773474},
{0.79609,0.77386},
{0.800913,0.774165},
{0.805825,0.774413},
{0.810807,0.774579},
{0.811053,0.767049},
{0.8113,0.759388},
{0.811559,0.751615},
{0.816321,0.743938},
{0.820904,0.736056},
{0.774948,0.732444},
{0.776178,0.725152},
{0.777339,0.718028},
{0.772301,0.724447},
{0.770962,0.731717},
{0.769523,0.739183},
{0.773624,0.739944},
{0.773561,0.717347},
{0.778455,0.711032},
{0.774781,0.710367},
{0.769792,0.716586},
{0.76844,0.723675},
{0.767003,0.730918},
{0.76545,0.738349},
{0.768007,0.746754},
{0.772236,0.74756},
{0.782122,0.711639},
{0.783105,0.704678},
{0.779549,0.704099},
{0.775993,0.70352},
{0.771089,0.709613},
{0.766014,0.715798},
{0.764598,0.722853},
{0.763059,0.730074},
{0.761407,0.737452},
{0.76381,0.745884},
{0.766451,0.754344},
{0.770809,0.755201},
{0.775187,0.755979},
{0.77843,0.764291},
{0.781976,0.772423},
{0.785831,0.780308},
{0.790679,0.780698},
{0.795524,0.781167},
{0.800475,0.781439},
{0.805491,0.78171},
{0.810606,0.781785},
{0.815734,0.781946},
{0.815842,0.77464},
{0.815961,0.767108},
{0.816088,0.759454},
{0.816213,0.751717},
{0.820904,0.743935},
{0.825486,0.743938},
{0.825456,0.736302},
{0.821293,0.729019},
{0.825563,0.728991},
{0.821682,0.721981},
{0.825751,0.721872},
{0.822072,0.714943},
{0.825959,0.714811},
{0.822461,0.707905},
{0.826178,0.707778},
{0.829838,0.71467},
{0.829894,0.707652},
{0.833701,0.714514},
{0.83361,0.707526},
{0.837521,0.7143},
{0.837327,0.707399},
{0.841271,0.713988},
{0.840893,0.707009},
{0.844977,0.713611},
{0.844459,0.706618},
{0.848666,0.713206},
{0.848025,0.706227},
{0.852344,0.712749},
{0.851591,0.705836},
{0.856016,0.712219},
{0.855147,0.705257},
{0.859685,0.711639},
{0.858703,0.704678},
{0.863352,0.711032},
{0.862258,0.704099},
{0.867026,0.710367},
{0.865814,0.70352},
{0.870719,0.709613},
{0.86945,0.7027},
{0.874417,0.708806},
{0.873086,0.70188},
{0.878109,0.70798},
{0.876723,0.70106},
{0.881796,0.707137},
{0.880359,0.70024},
{0.885482,0.70628},
{0.884026,0.699409},
{0.889159,0.705413},
{0.887693,0.698577},
{0.892823,0.704538},
{0.89136,0.697746},
{0.896473,0.703662},
{0.895027,0.696915},
{0.898714,0.69611},
{0.90011,0.702789},
{0.902401,0.695304},
{0.903737,0.701917},
{0.906088,0.694499},
{0.907354,0.701044},
{0.909775,0.693693},
{0.910967,0.700169},
{0.908667,0.707589},
{0.912159,0.706645},
{0.910071,0.714133},
{0.913352,0.713121},
{0.911841,0.720642},
{0.914544,0.719597},
{0.914249,0.727079},
{0.917549,0.72579},
{0.917055,0.733472},
{0.920554,0.731983},
{0.920016,0.739847},
{0.923559,0.738175},
{0.923293,0.746157},
{0.926565,0.744368},
{0.927047,0.752357},
{0.930963,0.750261},
{0.931068,0.758492},
{0.935362,0.756154},
{0.935146,0.764605},
{0.93976,0.762046},
{0.939273,0.770731},
{0.944158,0.767939},
{0.948756,0.774048},
{0.943438,0.776904},
{0.953353,0.780156},
{0.947593,0.783103},
{0.95795,0.786265},
{0.951692,0.789309},
{0.962548,0.792374},
{0.955621,0.795606},
{0.966416,0.799097},
{0.959265,0.802076},
{0.970285,0.80582},
{0.962706,0.808645},
{0.974153,0.812543},
{0.966022,0.815241},
{0.969036,0.821958},
{0.978022,0.819266},
{0.971568,0.828892},
{0.980554,0.826737},
{0.973761,0.83594},
{0.983087,0.834208},
{0.975753,0.842998},
{0.98562,0.841679},
{0.977147,0.850065},
{0.988152,0.84915},
{0.977545,0.857139},
{0.987711,0.856698},
{0.977346,0.864199},
{0.98727,0.864246},
{0.97695,0.87122},
{0.986829,0.871793},
{0.976197,0.878095},
{0.986387,0.879341},
{0.984447,0.886119},
{0.974928,0.884714},
{0.982508,0.892897},
{0.973336,0.891174},
{0.980568,0.899674},
{0.971614,0.897573},
{0.978628,0.906452},
{0.969618,0.903813},
{0.975491,0.912441},
{0.967204,0.909796},
{0.972354,0.918429},
{0.964527,0.915624},
{0.969217,0.924417},
{0.961743,0.921396},
{0.96608,0.930405},
{0.958753,0.927016},
{0.9621,0.93562},
{0.955456,0.932391},
{0.951967,0.937618},
{0.95812,0.940835},
{0.9484,0.942798},
{0.954139,0.946049},
{0.944715,0.947854},
{0.950159,0.951264},
{0.940873,0.952713},
{0.945796,0.955862},
{0.936933,0.957456},
{0.941432,0.96046},
{0.932955,0.962166},
{0.937068,0.965057},
{0.928966,0.966818},
{0.932705,0.969655},
{0.928474,0.974017},
{0.924994,0.971387},
{0.924244,0.97838},
{0.921028,0.975909},
{0.920013,0.982742},
{0.917053,0.980419},
{0.913074,0.984923},
{0.915783,0.987104},
{0.786661,0.705257},
{0.75916,0.72917},
{0.760774,0.721995},
{0.762274,0.714943},
{0.756976,0.721099},
{0.755286,0.72823},
{0.753426,0.735497},
{0.757396,0.736504},
{0.758531,0.714082},
{0.763699,0.70798},
{0.760011,0.707137},
{0.754819,0.713186},
{0.753213,0.720161},
{0.751458,0.727233},
{0.749507,0.734426},
{0.751415,0.742833},
{0.755511,0.743924},
{0.75963,0.744931},
{0.767391,0.708806},
{0.768721,0.70188},
{0.765085,0.70106},
{0.761448,0.70024},
{0.756325,0.70628},
{0.751102,0.712285},
{0.749486,0.719195},
{0.747661,0.7262},
{0.745642,0.733301},
{0.747387,0.741683},
{0.749307,0.750179},
{0.753532,0.751361},
{0.757802,0.75246},
{0.762111,0.753443},
{0.772357,0.7027},
{0.745795,0.718211},
{0.743942,0.725132},
{0.741836,0.732133},
{0.743383,0.740446},
{0.745128,0.748946},
{0.747103,0.757501},
{0.751489,0.758769},
{0.755916,0.759925},
{0.76038,0.760966},
{0.76487,0.761901},
{0.743807,0.71042},
{0.747456,0.711352},
{0.752648,0.705413},
{0.748984,0.704538},
{0.745334,0.703662},
{0.741697,0.702789},
{0.740217,0.709477},
{0.742153,0.717207},
{0.74027,0.724037},
{0.738104,0.730919},
{0.739502,0.739169},
{0.74101,0.74763},
{0.742759,0.756185},
{0.744841,0.764775},
{0.749409,0.766102},
{0.75401,0.76732},
{0.758642,0.768397},
{0.763292,0.769373},
{0.767949,0.770288},
{0.769371,0.762798},
{0.773892,0.763594},
{0.777295,0.77181},
{0.78103,0.779727},
{0.785083,0.787345},
{0.790025,0.78783},
{0.795012,0.788203},
{0.800062,0.788493},
{0.805195,0.78873},
{0.810392,0.788884},
{0.815636,0.788927},
{0.820905,0.781945},
{0.820904,0.774644},
{0.820904,0.7671},
{0.820904,0.75946},
{0.820904,0.751731},
{0.825595,0.751717},
{0.830248,0.751614},
{0.830034,0.74389},
{0.829869,0.736283},
{0.829803,0.728918},
{0.829801,0.721753},
{0.833816,0.721569},
{0.837778,0.721346},
{0.841672,0.721034},
{0.845519,0.720689},
{0.849327,0.720251},
{0.853123,0.719785},
{0.856907,0.719246},
{0.8607,0.71868},
{0.864468,0.718028},
{0.868246,0.717346},
{0.872015,0.716586},
{0.875793,0.715798},
{0.879533,0.714943},
{0.883276,0.71408},
{0.886988,0.713186},
{0.890706,0.712285},
{0.894352,0.711352},
{0.897998,0.710419},
{0.90159,0.709477},
{0.905168,0.708534},
{0.906723,0.715151},
{0.908596,0.721766},
{0.910874,0.728368},
{0.913531,0.734938},
{0.916405,0.741499},
{0.919588,0.747991},
{0.923064,0.754422},
{0.926736,0.760753},
{0.930504,0.767097},
{0.934304,0.773376},
{0.938103,0.779679},
{0.941818,0.785926},
{0.945467,0.792251},
{0.948925,0.798549},
{0.952171,0.804946},
{0.955184,0.811332},
{0.957999,0.817833},
{0.960531,0.824332},
{0.962721,0.830954},
{0.964589,0.837578},
{0.966103,0.844273},
{0.967166,0.85092},
{0.967605,0.857565},
{0.96761,0.864153},
{0.967243,0.870695},
{0.966582,0.87712},
{0.965565,0.883385},
{0.964306,0.889546},
{0.962787,0.895573},
{0.96105,0.901508},
{0.959024,0.90727},
{0.956778,0.912964},
{0.954342,0.9185},
{0.95171,0.923977},
{0.948865,0.929287},
{0.945829,0.934549},
{0.94268,0.939659},
{0.939377,0.944731},
{0.935956,0.949666},
{0.932406,0.954563},
{0.928823,0.959347},
{0.925163,0.964118},
{0.921493,0.968816},
{0.917785,0.973492},
{0.914084,0.978117},
{0.910366,0.982741},
{0.74678,0.696915},
{0.750447,0.697746},
{0.754114,0.698577},
{0.757781,0.699409},
{0.73857,0.716182},
{0.736676,0.722907},
{0.734459,0.729656},
{0.735659,0.737808},
{0.736966,0.746198},
{0.738471,0.754756},
{0.740309,0.763367},
{0.737833,0.770435},
{0.742578,0.771902},
{0.747338,0.773297},
{0.752144,0.774472},
{0.756934,0.775666},
{0.761758,0.776649},
{0.766569,0.777595},
{0.771405,0.778335},
{0.772616,0.77111},
{0.776209,0.779131},
{0.780152,0.786783},
{0.784404,0.794103},
{0.789465,0.794558},
{0.794552,0.794946},
{0.799705,0.795219},
{0.804932,0.795451},
{0.810226,0.795566},
{0.81555,0.795608},
{0.820904,0.78892},
{0.826171,0.788927},
{0.826073,0.781946},
{0.825965,0.77464},
{0.825846,0.767108},
{0.825719,0.759454},
{0.736639,0.708535},
{0.735084,0.715151},
{0.733141,0.707589},
{0.731736,0.714133},
{0.733211,0.721767},
{0.729966,0.720642},
{0.728456,0.713121},
{0.727263,0.719597},
{0.727558,0.727079},
{0.730933,0.728368},
{0.729648,0.706645},
{0.734453,0.701044},
{0.73807,0.701917},
{0.739406,0.695304},
{0.735719,0.694499},
{0.732032,0.693693},
{0.73084,0.700169},
{0.743093,0.69611},
{0.138914,0.159632},
{0.148795,0.155836},
{0.141242,0.164408},
{0.150688,0.160135},
{0.15966,0.155469},
{0.157245,0.150886},
{0.16832,0.150561},
{0.165695,0.145937},
{0.17683,0.145564},
{0.174145,0.140987},
{0.184967,0.140378},
{0.182595,0.136038},
{0.192508,0.134899},
{0.189395,0.130198},
{0.199674,0.129263},
{0.196195,0.124358},
{0.206687,0.123605},
{0.202994,0.118518},
{0.213449,0.117946},
{0.209794,0.112679},
{0.219865,0.112305},
{0.215703,0.10681},
{0.226063,0.106702},
{0.221611,0.100941},
{0.232173,0.101153},
{0.22752,0.0950715},
{0.238196,0.0957419},
{0.233428,0.0892025},
{0.244133,0.0905526},
{0.239199,0.0838935},
{0.250012,0.0855199},
{0.244969,0.0785845},
{0.255863,0.0805783},
{0.25074,0.0732755},
{0.261729,0.0758436},
{0.25651,0.0679665},
{0.267655,0.0714316},
{0.262547,0.0635464},
{0.268583,0.0591262},
{0.273614,0.067232},
{0.274619,0.0547061},
{0.27958,0.0631346},
{0.280655,0.0502859},
{0.285606,0.0592742},
{0.287087,0.0469392},
{0.291749,0.055786},
{0.293519,0.0435925},
{0.297962,0.0525347},
{0.299951,0.0402458},
{0.304198,0.049385},
{0.306382,0.0368991},
{0.310505,0.0464775},
{0.316928,0.043953},
{0.31317,0.0346862},
{0.323426,0.0416671},
{0.319958,0.0324732},
{0.329955,0.0394753},
{0.326745,0.0302603},
{0.336545,0.0375086},
{0.333533,0.0280473},
{0.343229,0.0358981},
{0.340562,0.026904},
{0.349976,0.0345044},
{0.347592,0.0257606},
{0.356756,0.0331881},
{0.354622,0.0246173},
{0.36358,0.0320453},
{0.361652,0.023474},
{0.370461,0.0311724},
{0.36878,0.0231465},
{0.377384,0.030457},
{0.375909,0.0228191},
{0.384334,0.0297868},
{0.383038,0.0224916},
{0.391304,0.0291915},
{0.390167,0.0221642},
{0.398287,0.0287005},
{0.397261,0.0221561},
{0.40528,0.0282609},
{0.404355,0.022148},
{0.41228,0.0278196},
{0.41145,0.0221399},
{0.419264,0.027319},
{0.418544,0.0221317},
{0.425504,0.0217662},
{0.426207,0.0267013},
{0.432465,0.0214006},
{0.433128,0.026018},
{0.439425,0.021035},
{0.440045,0.0253208},
{0.446385,0.0206694},
{0.44696,0.0246166},
{0.440694,0.0295996},
{0.447535,0.0285638},
{0.44811,0.032511},
{0.4414,0.0338646},
{0.448685,0.0364582},
{0.442286,0.0380817},
{0.443473,0.0422165},
{0.450003,0.0401871},
{0.444867,0.0462898},
{0.451321,0.0439159},
{0.452639,0.0476448},
{0.446372,0.0503223},
{0.453957,0.0513736},
{0.448074,0.0542557},
{0.450057,0.0580314},
{0.455969,0.054688},
{0.452235,0.0616937},
{0.45798,0.0580023},
{0.459992,0.0613166},
{0.45452,0.0652867},
{0.462004,0.064631},
{0.456989,0.0687219},
{0.459722,0.0719107},
{0.464647,0.0672981},
{0.462638,0.074922},
{0.467289,0.0699652},
{0.469931,0.0726324},
{0.465658,0.0778248},
{0.472574,0.0752995},
{0.468846,0.0804918},
{0.472268,0.0827956},
{0.47575,0.0770437},
{0.475853,0.0848374},
{0.478925,0.078788},
{0.482101,0.0805323},
{0.479528,0.0867181},
{0.485277,0.0822765},
{0.483327,0.088277},
{0.487286,0.0893533},
{0.488772,0.0828486},
{0.491345,0.0901409},
{0.492268,0.0834206},
{0.495763,0.0839927},
{0.495443,0.0908337},
{0.499258,0.0845647},
{0.49956,0.0914791},
{0.499863,0.0983934},
{0.495109,0.0977036},
{0.500165,0.105308},
{0.49475,0.104631},
{0.500467,0.112222},
{0.494314,0.111654},
{0.493751,0.118808},
{0.500467,0.119005},
{0.506619,0.111654},
{0.506184,0.104631},
{0.500769,0.105308},
{0.505824,0.0977036},
{0.501071,0.0983934},
{0.505491,0.0908337},
{0.501373,0.0914791},
{0.501675,0.0845647},
{0.505171,0.0839927},
{0.509589,0.0901409},
{0.508666,0.0834206},
{0.512161,0.0828486},
{0.513647,0.0893533},
{0.515657,0.0822765},
{0.517606,0.088277},
{0.521406,0.0867181},
{0.518832,0.0805323},
{0.525081,0.0848374},
{0.522008,0.078788},
{0.525184,0.0770437},
{0.528665,0.0827956},
{0.52836,0.0752995},
{0.532088,0.0804918},
{0.535276,0.0778248},
{0.531002,0.0726324},
{0.538295,0.074922},
{0.533645,0.0699652},
{0.536287,0.0672981},
{0.541212,0.0719107},
{0.538929,0.064631},
{0.543944,0.0687219},
{0.546414,0.0652867},
{0.540941,0.0613166},
{0.548699,0.0616937},
{0.542953,0.0580023},
{0.544965,0.054688},
{0.550876,0.0580314},
{0.546977,0.0513736},
{0.55286,0.0542557},
{0.554562,0.0503223},
{0.548295,0.0476448},
{0.556067,0.0462898},
{0.549612,0.0439159},
{0.55093,0.0401871},
{0.55746,0.0422165},
{0.552248,0.0364582},
{0.558647,0.0380817},
{0.559533,0.0338646},
{0.552823,0.032511},
{0.56024,0.0295996},
{0.553398,0.0285638},
{0.553973,0.0246166},
{0.560889,0.0253208},
{0.554548,0.0206694},
{0.561509,0.021035},
{0.567806,0.026018},
{0.568469,0.0214006},
{0.574727,0.0267013},
{0.575429,0.0217662},
{0.58167,0.027319},
{0.582389,0.0221317},
{0.588653,0.0278196},
{0.589484,0.0221399},
{0.595654,0.0282609},
{0.596578,0.022148},
{0.602647,0.0287005},
{0.603673,0.0221561},
{0.60963,0.0291915},
{0.610767,0.0221642},
{0.6166,0.0297868},
{0.617896,0.0224916},
{0.623549,0.030457},
{0.625024,0.0228191},
{0.630472,0.0311724},
{0.632153,0.0231465},
{0.639282,0.023474},
{0.637353,0.0320453},
{0.646312,0.0246173},
{0.644178,0.0331881},
{0.653342,0.0257606},
{0.650957,0.0345044},
{0.660371,0.026904},
{0.657704,0.0358981},
{0.667401,0.0280473},
{0.664388,0.0375086},
{0.674188,0.0302603},
{0.670979,0.0394753},
{0.680976,0.0324732},
{0.677507,0.0416671},
{0.687764,0.0346862},
{0.684005,0.0439531},
{0.694551,0.0368991},
{0.690429,0.0464776},
{0.696735,0.049385},
{0.700983,0.0402458},
{0.702971,0.0525347},
{0.707415,0.0435925},
{0.709184,0.055786},
{0.713846,0.0469392},
{0.715328,0.0592742},
{0.720278,0.0502859},
{0.721354,0.0631346},
{0.726314,0.0547061},
{0.727319,0.067232},
{0.732351,0.0591262},
{0.733279,0.0714316},
{0.738387,0.0635464},
{0.744423,0.0679665},
{0.739205,0.0758436},
{0.750194,0.0732755},
{0.745071,0.0805783},
{0.755964,0.0785845},
{0.750921,0.0855199},
{0.761735,0.0838935},
{0.7568,0.0905526},
{0.767505,0.0892025},
{0.762737,0.0957419},
{0.773414,0.0950715},
{0.768761,0.101153},
{0.779323,0.100941},
{0.774871,0.106702},
{0.785231,0.10681},
{0.781069,0.112305},
{0.79114,0.112679},
{0.787485,0.117946},
{0.797939,0.118518},
{0.794247,0.123605},
{0.804739,0.124358},
{0.801259,0.129263},
{0.811538,0.130198},
{0.808425,0.134899},
{0.818338,0.136038},
{0.815966,0.140378},
{0.826788,0.140987},
{0.824103,0.145564},
{0.835238,0.145937},
{0.832613,0.150561},
{0.843689,0.150886},
{0.841273,0.155469},
{0.852139,0.155836},
{0.850245,0.160135},
{0.859692,0.164408},
{0.86202,0.159632},
{0.869405,0.168456},
{0.8719,0.163427},
{0.879176,0.172451},
{0.881781,0.167223},
{0.888976,0.17642},
{0.891662,0.171018},
{0.134033,0.173481},
{0.131529,0.168456},
{0.129033,0.163427},
{0.121758,0.172451},
{0.124366,0.177677},
{0.136586,0.178534},
{0.146098,0.174106},
{0.14362,0.16922},
{0.153006,0.164779},
{0.162122,0.1601},
{0.17093,0.155212},
{0.179552,0.150195},
{0.187789,0.145014},
{0.195648,0.139659},
{0.203091,0.134225},
{0.210372,0.128728},
{0.217305,0.12327},
{0.224007,0.117837},
{0.230419,0.112524},
{0.236774,0.107244},
{0.242924,0.102151},
{0.249008,0.0972102},
{0.254945,0.09248},
{0.260913,0.0878523},
{0.266787,0.0834549},
{0.272693,0.0792715},
{0.278549,0.0753069},
{0.284476,0.0714935},
{0.290382,0.0678988},
{0.296359,0.0645484},
{0.302355,0.061396},
{0.308415,0.0584258},
{0.31451,0.055645},
{0.320675,0.0531147},
{0.326911,0.0507558},
{0.33318,0.0485854},
{0.339529,0.0465724},
{0.345931,0.0447906},
{0.352443,0.0431504},
{0.358947,0.0416729},
{0.365566,0.0403106},
{0.372212,0.0391224},
{0.378982,0.0380265},
{0.38571,0.0370333},
{0.392552,0.0360845},
{0.399393,0.0352064},
{0.406324,0.0343377},
{0.413186,0.0334913},
{0.420105,0.0325909},
{0.426976,0.0316326},
{0.433862,0.0306191},
{0.434665,0.0352144},
{0.435678,0.0397574},
{0.43692,0.0442463},
{0.438437,0.0486477},
{0.440085,0.0530068},
{0.441996,0.0572492},
{0.444122,0.0613827},
{0.446502,0.0653691},
{0.449017,0.0692744},
{0.451781,0.0729983},
{0.454758,0.0765485},
{0.457975,0.0798798},
{0.461338,0.0830657},
{0.464933,0.0859827},
{0.468737,0.0886217},
{0.472757,0.0909386},
{0.476912,0.0930108},
{0.481258,0.0946884},
{0.485763,0.095962},
{0.490403,0.0969095},
{0.155475,0.169557},
{0.164676,0.16483},
{0.173651,0.159947},
{0.182349,0.15493},
{0.190752,0.149791},
{0.19884,0.144539},
{0.206606,0.139232},
{0.214042,0.133926},
{0.221194,0.128652},
{0.228112,0.123441},
{0.234802,0.118329},
{0.241272,0.113354},
{0.247576,0.108528},
{0.253765,0.103865},
{0.259844,0.099375},
{0.265817,0.0950686},
{0.27172,0.0909491},
{0.277589,0.0870204},
{0.283428,0.083277},
{0.289243,0.0797132},
{0.29505,0.0763333},
{0.300866,0.0731419},
{0.306702,0.0701252},
{0.31257,0.0672699},
{0.31847,0.0645816},
{0.3244,0.0620658},
{0.330381,0.0597061},
{0.336435,0.057486},
{0.342547,0.0554092},
{0.348704,0.0534795},
{0.354931,0.051678},
{0.361253,0.0499858},
{0.367651,0.0484006},
{0.374104,0.0469204},
{0.380629,0.045522},
{0.387244,0.0441822},
{0.393928,0.0428903},
{0.40066,0.0416355},
{0.407434,0.0403952},
{0.414243,0.0391468},
{0.421065,0.037873},
{0.427879,0.0365564},
{0.148637,0.17903},
{0.139154,0.183559},
{0.12698,0.182896},
{0.129613,0.188061},
{0.132278,0.193125},
{0.141759,0.188558},
{0.151198,0.183956},
{0.158019,0.174404},
{0.114643,0.181822},
{0.117328,0.187224},
{0.120014,0.192626},
{0.122777,0.197675},
{0.12554,0.202724},
{0.134959,0.198132},
{0.144367,0.193513},
{0.153768,0.18888},
{0.16058,0.17928},
{0.169888,0.174492},
{0.167279,0.169635},
{0.119152,0.167223},
{0.111957,0.17642},
{0.165701,0.18909},
{0.156338,0.193799},
{0.146986,0.198472},
{0.158898,0.198713},
{0.168244,0.194016},
{0.175079,0.184328},
{0.172492,0.179392},
{0.16314,0.184172},
{0.181689,0.174548},
{0.179058,0.169613},
{0.176331,0.16474},
{0.149592,0.203396},
{0.137642,0.203127},
{0.140311,0.208081},
{0.142949,0.212966},
{0.152175,0.208292},
{0.161441,0.203624},
{0.170769,0.198957},
{0.180177,0.194285},
{0.177643,0.189293},
{0.184385,0.179534},
{0.128303,0.207773},
{0.131066,0.212822},
{0.133745,0.217644},
{0.136424,0.222466},
{0.145566,0.217811},
{0.154744,0.213163},
{0.16396,0.208525},
{0.17327,0.203903},
{0.182671,0.199293},
{0.19206,0.194747},
{0.18957,0.189633},
{0.186981,0.184572},
{0.193532,0.174734},
{0.19082,0.169659},
{0.188023,0.164668},
{0.185185,0.159759},
{0.175719,0.208837},
{0.166446,0.213408},
{0.157271,0.218012},
{0.168892,0.218274},
{0.178129,0.213764},
{0.185117,0.204306},
{0.159777,0.222841},
{0.148169,0.222644},
{0.150738,0.227446},
{0.153254,0.2322},
{0.162229,0.227635},
{0.171295,0.223122},
{0.180487,0.21868},
{0.18984,0.21433},
{0.187509,0.20932},
{0.194546,0.199843},
{0.139102,0.227288},
{0.141781,0.23211},
{0.144323,0.236792},
{0.146864,0.241473},
{0.155733,0.236923},
{0.164663,0.232415},
{0.173655,0.227947},
{0.182805,0.223588},
{0.192109,0.219327},
{0.201486,0.215254},
{0.199257,0.210095},
{0.196926,0.204982},
{0.203909,0.195475},
{0.201443,0.190223},
{0.198853,0.185024},
{0.196196,0.179864},
{0.20249,0.169935},
{0.199654,0.164757},
{0.196748,0.15967},
{0.193752,0.154685},
{0.185053,0.228451},
{0.175972,0.232743},
{0.167032,0.237147},
{0.178241,0.237506},
{0.187252,0.233291},
{0.194314,0.224304},
{0.169384,0.241865},
{0.158194,0.241631},
{0.160623,0.24631},
{0.163009,0.250948},
{0.171679,0.246532},
{0.180456,0.242229},
{0.189384,0.238089},
{0.198503,0.23416},
{0.196448,0.229251},
{0.203666,0.220328},
{0.149406,0.246154},
{0.151947,0.250836},
{0.154393,0.255421},
{0.156838,0.260006},
{0.165366,0.255553},
{0.173963,0.251191},
{0.182626,0.246909},
{0.191468,0.242859},
{0.200484,0.239022},
{0.209622,0.235528},
{0.207732,0.230464},
{0.205737,0.225435},
{0.213019,0.21655},
{0.210903,0.211266},
{0.208643,0.206004},
{0.206294,0.200747},
{0.21316,0.191207},
{0.210637,0.18581},
{0.207988,0.180467},
{0.205238,0.175187},
{0.211231,0.165148},
{0.208276,0.159836},
{0.205199,0.15463},
{0.202039,0.149531},
{0.193479,0.247542},
{0.184757,0.25154},
{0.176182,0.25576},
{0.186846,0.25611},
{0.195443,0.252174},
{0.202395,0.243831},
{0.1784,0.260316},
{0.167707,0.260136},
{0.170041,0.264681},
{0.172375,0.269172},
{0.180582,0.264787},
{0.188888,0.260607},
{0.197337,0.256722},
{0.205975,0.253221},
{0.204228,0.248569},
{0.211432,0.240427},
{0.159283,0.264591},
{0.161729,0.269175},
{0.164217,0.27366},
{0.166706,0.278144},
{0.174706,0.273629},
{0.182759,0.26923},
{0.190876,0.264981},
{0.199157,0.26112},
{0.207638,0.257742},
{0.216264,0.254866},
{0.214739,0.250119},
{0.213133,0.245341},
{0.22052,0.237353},
{0.218831,0.232198},
{0.216986,0.227026},
{0.215033,0.221817},
{0.222325,0.212964},
{0.220213,0.2075},
{0.217951,0.202057},
{0.215568,0.196641},
{0.222255,0.18704},
{0.219674,0.181472},
{0.216938,0.175975},
{0.214104,0.170537},
{0.219693,0.160421},
{0.216478,0.154999},
{0.21335,0.149599},
{0.209983,0.144369},
{0.78041,0.965407},
{0.778128,0.965262},
{0.780433,0.961509},
{0.777991,0.960952},
{0.775847,0.965117},
{0.775516,0.960593},
{0.773566,0.964972},
{0.773025,0.960352},
{0.771285,0.964826},
{0.770452,0.960314},
{0.76859,0.965361},
{0.767735,0.96056},
{0.765896,0.965896},
{0.764921,0.960997},
{0.763202,0.966431},
{0.762057,0.961532},
{0.760508,0.966966},
{0.759105,0.962237},
{0.757542,0.968133},
{0.756026,0.963181},
{0.754576,0.9693},
{0.752868,0.964285},
{0.75161,0.970467},
{0.749678,0.965471},
{0.748644,0.971633},
{0.746472,0.966802},
{0.745698,0.973319},
{0.743266,0.968344},
{0.742751,0.975006},
{0.740066,0.970034},
{0.739805,0.976692},
{0.736881,0.971807},
{0.736859,0.978378},
{0.733748,0.973727},
{0.73415,0.980559},
{0.730708,0.975859},
{0.731441,0.982741},
{0.727723,0.978117},
{0.724754,0.980419},
{0.728733,0.984923},
{0.721794,0.982742},
{0.726024,0.987104},
{0.777891,0.956709},
{0.775235,0.956204},
{0.772528,0.955767},
{0.769775,0.955655},
{0.766923,0.955761},
{0.763981,0.956138},
{0.760952,0.956621},
{0.757814,0.957332},
{0.754554,0.958213},
{0.751201,0.959286},
{0.747781,0.960459},
{0.744333,0.961825},
{0.740866,0.963352},
{0.737427,0.965076},
{0.733976,0.966902},
{0.730596,0.968932},
{0.727275,0.971134},
{0.724022,0.973492},
{0.72078,0.975909},
{0.717563,0.97838},
{0.716813,0.971387},
{0.713333,0.974017},
{0.712842,0.966818},
{0.709102,0.969655},
{0.708852,0.962166},
{0.704739,0.965057},
{0.704874,0.957456},
{0.700375,0.96046},
{0.700934,0.952713},
{0.696012,0.955862},
{0.697092,0.947854},
{0.691648,0.951264},
{0.693407,0.942798},
{0.687668,0.946049},
{0.68984,0.937618},
{0.683688,0.940835},
{0.686351,0.932391},
{0.679707,0.93562},
{0.683054,0.927016},
{0.675727,0.930405},
{0.680064,0.921396},
{0.67259,0.924417},
{0.67728,0.915624},
{0.669453,0.918429},
{0.674603,0.909796},
{0.666316,0.912441},
{0.672189,0.903813},
{0.663179,0.906452},
{0.670193,0.897573},
{0.661239,0.899674},
{0.668471,0.891174},
{0.6593,0.892897},
{0.666879,0.884714},
{0.65736,0.886119},
{0.66561,0.878095},
{0.65542,0.879341},
{0.654979,0.871793},
{0.664857,0.87122},
{0.654537,0.864246},
{0.664461,0.864199},
{0.654096,0.856698},
{0.664262,0.857139},
{0.653655,0.84915},
{0.66466,0.850065},
{0.656188,0.841679},
{0.666054,0.842998},
{0.65872,0.834208},
{0.668046,0.83594},
{0.661253,0.826737},
{0.670239,0.828892},
{0.663785,0.819266},
{0.672772,0.821958},
{0.667654,0.812543},
{0.675785,0.815241},
{0.679102,0.808646},
{0.671523,0.80582},
{0.682542,0.802076},
{0.675391,0.799097},
{0.686187,0.795606},
{0.67926,0.792374},
{0.690115,0.789309},
{0.683857,0.786265},
{0.694214,0.783103},
{0.688454,0.780156},
{0.698369,0.776904},
{0.693051,0.774048},
{0.702534,0.770731},
{0.697649,0.767939},
{0.702047,0.762046},
{0.706661,0.764605},
{0.706446,0.756154},
{0.710739,0.758492},
{0.710844,0.750261},
{0.71476,0.752357},
{0.715243,0.744368},
{0.718514,0.746157},
{0.718248,0.738175},
{0.721791,0.739847},
{0.721253,0.731983},
{0.724753,0.733472},
{0.724258,0.72579},
{0.775,0.951781},
{0.77212,0.951249},
{0.769196,0.950986},
{0.766197,0.950967},
{0.763111,0.951199},
{0.759926,0.951686},
{0.75662,0.952375},
{0.753167,0.953213},
{0.7496,0.95422},
{0.745951,0.955416},
{0.74225,0.956788},
{0.738529,0.958325},
{0.734809,0.960043},
{0.731112,0.961958},
{0.727456,0.964066},
{0.72386,0.966364},
{0.720315,0.968816},
{0.716644,0.964118},
{0.712985,0.959347},
{0.709401,0.954563},
{0.705851,0.949666},
{0.70243,0.944731},
{0.699128,0.939659},
{0.695979,0.934548},
{0.692942,0.929287},
{0.690097,0.923977},
{0.687465,0.9185},
{0.68503,0.912964},
{0.682783,0.90727},
{0.680758,0.901508},
{0.67902,0.895573},
{0.677502,0.889546},
{0.676242,0.883385},
{0.675225,0.87712},
{0.674564,0.870695},
{0.674197,0.864153},
{0.674202,0.857565},
{0.674641,0.85092},
{0.675704,0.844273},
{0.677219,0.837578},
{0.679087,0.830954},
{0.681277,0.824332},
{0.683809,0.817833},
{0.686624,0.811332},
{0.689636,0.804946},
{0.692882,0.798549},
{0.69634,0.792251},
{0.699989,0.785926},
{0.703704,0.779679},
{0.707503,0.773376},
{0.711303,0.767097},
{0.715072,0.760753},
{0.718743,0.754422},
{0.722219,0.747991},
{0.725402,0.741499},
{0.728276,0.734938},
{0.731941,0.736401},
{0.733008,0.744681},
{0.734261,0.753199},
{0.73583,0.76184},
{0.733152,0.768742},
{0.730452,0.775652},
{0.735385,0.777332},
{0.740351,0.778857},
{0.745321,0.780288},
{0.7503,0.781584},
{0.755293,0.782704},
{0.760285,0.783705},
{0.765262,0.784647},
{0.770231,0.785487},
{0.775198,0.786182},
{0.771812,0.94684},
{0.768717,0.946368},
{0.765563,0.946188},
{0.762329,0.94633},
{0.758999,0.946732},
{0.755532,0.947384},
{0.751889,0.948184},
{0.748111,0.949177},
{0.744225,0.950348},
{0.740274,0.951724},
{0.73629,0.95327},
{0.732308,0.955029},
{0.728317,0.956976},
{0.724372,0.959155},
{0.72048,0.961544},
{0.717153,0.956674},
{0.713905,0.951764},
{0.710758,0.946823},
{0.707723,0.941826},
{0.704811,0.936745},
{0.70204,0.931605},
{0.699429,0.926435},
{0.696987,0.921197},
{0.694722,0.915854},
{0.69264,0.910438},
{0.69075,0.904978},
{0.689063,0.899437},
{0.687594,0.893778},
{0.686337,0.888026},
{0.68529,0.882208},
{0.684479,0.876297},
{0.683928,0.870263},
{0.683659,0.86414},
{0.68369,0.857959},
{0.684089,0.851728},
{0.684922,0.845459},
{0.686131,0.839156},
{0.687659,0.832828},
{0.689492,0.826503},
{0.691616,0.820213},
{0.694001,0.813923},
{0.696617,0.8076},
{0.699453,0.801277},
{0.702498,0.794987},
{0.705717,0.788677},
{0.709074,0.782295},
{0.712518,0.775876},
{0.716002,0.769457},
{0.719467,0.762989},
{0.72286,0.756423},
{0.726109,0.749788},
{0.729147,0.743112},
{0.780738,0.953701},
{0.780558,0.957568},
{0.783212,0.95861},
{0.783639,0.955063},
{0.784108,0.951839},
{0.78101,0.950156},
{0.777866,0.952603},
{0.777937,0.948739},
{0.774883,0.947673},
{0.774872,0.943724},
{0.771611,0.942578},
{0.768334,0.941808},
{0.76503,0.941433},
{0.761661,0.941427},
{0.758191,0.941764},
{0.754568,0.94236},
{0.750744,0.943129},
{0.746755,0.944091},
{0.742641,0.945264},
{0.738438,0.946635},
{0.734182,0.948192},
{0.729901,0.949958},
{0.72562,0.951958},
{0.721364,0.954195},
{0.718467,0.949229},
{0.715665,0.94422},
{0.712998,0.939196},
{0.710454,0.934102},
{0.708059,0.929005},
{0.705809,0.923876},
{0.703729,0.918733},
{0.701811,0.913501},
{0.700056,0.908249},
{0.698479,0.902957},
{0.697078,0.897635},
{0.695871,0.892207},
{0.694829,0.886721},
{0.693983,0.88119},
{0.693322,0.875601},
{0.692891,0.869905},
{0.692672,0.864123},
{0.692712,0.858309},
{0.693027,0.852438},
{0.693702,0.846515},
{0.694677,0.840513},
{0.695919,0.834492},
{0.69742,0.82842},
{0.699201,0.822347},
{0.701234,0.8162},
{0.703473,0.810009},
{0.705931,0.803748},
{0.708602,0.797495},
{0.711469,0.791158},
{0.714468,0.78473},
{0.717584,0.778208},
{0.720759,0.771678},
{0.723947,0.765062},
{0.727091,0.75834},
{0.730135,0.751524},
{0.428974,0.0414465},
{0.422246,0.0431172},
{0.415516,0.0447556},
{0.423697,0.048295},
{0.43032,0.0462769},
{0.431915,0.0510342},
{0.433759,0.0557049},
{0.425441,0.0533829},
{0.427405,0.0584018},
{0.435838,0.0602799},
{0.417074,0.0502873},
{0.418913,0.0557327},
{0.421032,0.0610824},
{0.429643,0.063312},
{0.432112,0.0681182},
{0.438138,0.0647496},
{0.440673,0.0690951},
{0.443455,0.0732971},
{0.446474,0.0773472},
{0.449716,0.0812366},
{0.453195,0.0849329},
{0.456926,0.0884032},
{0.460899,0.0916302},
{0.465105,0.0945963},
{0.469543,0.0972444},
{0.474212,0.0995172},
{0.479092,0.101375},
{0.484165,0.102779},
{0.489396,0.10383},
{0.437831,0.0773386},
{0.441086,0.0817286},
{0.432141,0.0813824},
{0.435607,0.0861281},
{0.444582,0.0859664},
{0.448358,0.0900014},
{0.452399,0.0938369},
{0.456736,0.0974182},
{0.461347,0.100745},
{0.466244,0.103711},
{0.471397,0.10628},
{0.476817,0.108339},
{0.482469,0.109843},
{0.488321,0.110896},
{0.434853,0.072787},
{0.428953,0.0764963},
{0.423135,0.0801063},
{0.426424,0.0853865},
{0.430102,0.0904739},
{0.439344,0.090729},
{0.443377,0.0951526},
{0.447734,0.0993659},
{0.452419,0.103351},
{0.457434,0.107092},
{0.462776,0.110463},
{0.46844,0.113341},
{0.474405,0.11562},
{0.48065,0.117194},
{0.487118,0.118208},
{0.781378,0.947027},
{0.778127,0.945226},
{0.781959,0.94404},
{0.778479,0.941809},
{0.775032,0.939955},
{0.779034,0.938235},
{0.775225,0.935935},
{0.771515,0.938359},
{0.768061,0.937321},
{0.764601,0.936703},
{0.761099,0.936678},
{0.757498,0.936832},
{0.753716,0.937389},
{0.749727,0.938104},
{0.745526,0.939108},
{0.74119,0.940202},
{0.736741,0.941583},
{0.732204,0.943121},
{0.727656,0.94496},
{0.723037,0.946923},
{0.720582,0.941893},
{0.718253,0.93685},
{0.716053,0.931777},
{0.713992,0.926702},
{0.712081,0.921651},
{0.710321,0.91659},
{0.708712,0.911483},
{0.707254,0.906358},
{0.705947,0.901242},
{0.704796,0.896096},
{0.703808,0.89088},
{0.702972,0.885619},
{0.702279,0.880337},
{0.701747,0.875006},
{0.701398,0.869596},
{0.701231,0.864124},
{0.701251,0.858604},
{0.701504,0.853032},
{0.702038,0.847401},
{0.702823,0.841701},
{0.70383,0.835925},
{0.70507,0.830086},
{0.706557,0.8242},
{0.708271,0.818231},
{0.710194,0.812146},
{0.712326,0.805977},
{0.714666,0.799755},
{0.717191,0.793433},
{0.719876,0.786965},
{0.722684,0.780392},
{0.725576,0.773755},
{0.728504,0.767021},
{0.73142,0.760155},
{0.771522,0.934075},
{0.775531,0.931579},
{0.771598,0.929589},
{0.767886,0.932737},
{0.767792,0.928118},
{0.77171,0.924761},
{0.767735,0.92334},
{0.764042,0.927292},
{0.76428,0.932},
{0.782759,0.940958},
{0.784172,0.937018},
{0.77957,0.934032},
{0.779866,0.928728},
{0.775762,0.92662},
{0.776181,0.921338},
{0.771936,0.91974},
{0.767809,0.91854},
{0.763861,0.92255},
{0.760273,0.927056},
{0.760644,0.931777},
{0.756918,0.931982},
{0.756436,0.927196},
{0.752399,0.927677},
{0.753012,0.932487},
{0.748836,0.933166},
{0.744438,0.934057},
{0.739865,0.935201},
{0.735157,0.936557},
{0.730354,0.938087},
{0.725486,0.939847},
{0.723478,0.934826},
{0.721588,0.929768},
{0.719844,0.924828},
{0.718224,0.91976},
{0.71675,0.914805},
{0.715419,0.909794},
{0.714202,0.904875},
{0.713155,0.899824},
{0.712212,0.894843},
{0.711423,0.889793},
{0.710705,0.884765},
{0.710196,0.879644},
{0.709752,0.874523},
{0.709477,0.869348},
{0.709282,0.864113},
{0.709344,0.858853},
{0.709532,0.853513},
{0.70996,0.84814},
{0.71056,0.842619},
{0.711414,0.837134},
{0.712442,0.831477},
{0.713686,0.825785},
{0.715143,0.819869},
{0.716784,0.814004},
{0.718643,0.807904},
{0.720681,0.801751},
{0.722944,0.795347},
{0.7253,0.788972},
{0.727834,0.782348},
{0.738661,0.930257},
{0.733704,0.931585},
{0.732375,0.926626},
{0.728631,0.933075},
{0.743448,0.929166},
{0.737574,0.925364},
{0.7366,0.920541},
{0.731162,0.921739},
{0.727038,0.928072},
{0.748056,0.928306},
{0.742587,0.924318},
{0.741792,0.91964},
{0.735736,0.915803},
{0.730061,0.916905},
{0.724221,0.918201},
{0.725569,0.923105},
{0.408841,0.0463609},
{0.402152,0.0479743},
{0.410476,0.0522576},
{0.395547,0.0495813},
{0.388999,0.05121},
{0.397447,0.0561516},
{0.40393,0.0542094},
{0.412519,0.0580136},
{0.414685,0.0637331},
{0.423417,0.0663314},
{0.417236,0.0693013},
{0.408406,0.0663399},
{0.411078,0.0722404},
{0.419996,0.0747925},
{0.426051,0.0714744},
{0.40601,0.0603337},
{0.399685,0.0625825},
{0.402186,0.0689076},
{0.404994,0.0751115},
{0.413989,0.0780471},
{0.391038,0.0580929},
{0.393374,0.0648351},
{0.396019,0.0714407},
{0.398936,0.0779332},
{0.408022,0.0812308},
{0.417186,0.0837425},
{0.420716,0.0893087},
{0.424553,0.0947633},
{0.434031,0.0954672},
{0.438363,0.10022},
{0.442935,0.104907},
{0.447943,0.109299},
{0.45331,0.113513},
{0.459138,0.117317},
{0.465293,0.120769},
{0.471912,0.123406},
{0.47884,0.124946},
{0.486043,0.125746},
{0.493219,0.126132},
{0.500467,0.126229},
{0.507183,0.118808},
{0.512612,0.110897},
{0.511537,0.10383},
{0.51053,0.0969094},
{0.415008,0.0931346},
{0.418994,0.0989315},
{0.40929,0.0968493},
{0.413375,0.102982},
{0.423255,0.104668},
{0.428674,0.100124},
{0.433138,0.105344},
{0.438002,0.110377},
{0.443264,0.115224},
{0.448919,0.119884},
{0.455092,0.124354},
{0.461911,0.128631},
{0.469297,0.131867},
{0.477172,0.133215},
{0.485158,0.133529},
{0.492879,0.133663},
{0.500467,0.133686},
{0.507714,0.126132},
{0.513816,0.118208},
{0.518464,0.109843},
{0.516768,0.102779},
{0.515171,0.095962},
{0.411363,0.0872278},
{0.40552,0.0906437},
{0.399849,0.0938814},
{0.403605,0.100429},
{0.407785,0.10686},
{0.417755,0.109072},
{0.427883,0.110259},
{0.402086,0.0843363},
{0.396224,0.0873508},
{0.390478,0.0902618},
{0.394075,0.0970943},
{0.397997,0.103849},
{0.402218,0.110574},
{0.412223,0.113299},
{0.422479,0.115064},
{0.432902,0.115726},
{0.438341,0.120999},
{0.427595,0.120906},
{0.43309,0.12659},
{0.438947,0.132109},
{0.444163,0.126113},
{0.457713,0.136329},
{0.466544,0.142285},
{0.458799,0.149578},
{0.471092,0.152572},
{0.476673,0.141756},
{0.485022,0.141486},
{0.49285,0.141322},
{0.500467,0.14129},
{0.508084,0.141322},
{0.508055,0.133663},
{0.51489,0.125746},
{0.520283,0.117194},
{0.524116,0.108339},
{0.521842,0.101375},
{0.519674,0.0946867},
{0.450583,0.131181},
{0.452117,0.143266},
{0.445922,0.149707},
{0.452458,0.155993},
{0.464582,0.157074},
{0.475295,0.16101},
{0.478375,0.150326},
{0.485929,0.149442},
{0.493255,0.149028},
{0.500467,0.148939},
{0.507679,0.149028},
{0.515005,0.149442},
{0.515912,0.141487},
{0.515776,0.133529},
{0.522093,0.124946},
{0.526528,0.11562},
{0.529536,0.10628},
{0.526722,0.0995172},
{0.524022,0.0930108},
{0.528177,0.0909384},
{0.532197,0.0886217},
{0.535998,0.0859811},
{0.539596,0.0830657},
{0.542958,0.0798796},
{0.546175,0.0765485},
{0.549151,0.0729969},
{0.551917,0.0692744},
{0.554431,0.065369},
{0.556812,0.0613827},
{0.558935,0.0572481},
{0.560848,0.0530068},
{0.562496,0.0486477},
{0.564014,0.0442463},
{0.565254,0.0397569},
{0.566269,0.0352144},
{0.567072,0.0306191},
{0.573957,0.0316326},
{0.58083,0.0325913},
{0.587747,0.0334913},
{0.59461,0.0343378},
{0.60154,0.0352064},
{0.608385,0.0360854},
{0.615224,0.0370333},
{0.621952,0.0380266},
{0.628721,0.0391224},
{0.635372,0.0403119},
{0.641986,0.0416729},
{0.648491,0.0431506},
{0.655002,0.0447906},
{0.661407,0.0465741},
{0.667754,0.0485854},
{0.674023,0.0507561},
{0.680258,0.0531147},
{0.686424,0.0556466},
{0.692519,0.0584258},
{0.698579,0.0613962},
{0.704574,0.0645484},
{0.71055,0.0678997},
{0.716458,0.0714935},
{0.722384,0.075307},
{0.728241,0.0792715},
{0.734144,0.0834543},
{0.740021,0.0878523},
{0.745989,0.0924799},
{0.751925,0.0972102},
{0.758006,0.102149},
{0.764159,0.107244},
{0.770514,0.112523},
{0.776926,0.117837},
{0.783625,0.123268},
{0.790562,0.128728},
{0.797842,0.134225},
{0.805286,0.139659},
{0.81314,0.145013},
{0.821381,0.150195},
{0.830003,0.155212},
{0.838811,0.1601},
{0.847928,0.164779},
{0.857314,0.16922},
{0.866901,0.173481},
{0.876568,0.177677},
{0.886291,0.181822},
{0.445259,0.137617},
{0.439608,0.143715},
{0.439923,0.155918},
{0.446515,0.162223},
{0.458727,0.162793},
{0.469831,0.164848},
{0.479353,0.168546},
{0.484231,0.16621},
{0.481239,0.158589},
{0.487601,0.157333},
{0.493976,0.156664},
{0.50047,0.156529},
{0.506958,0.156664},
{0.513333,0.157332},
{0.519694,0.158589},
{0.522559,0.150326},
{0.52426,0.141756},
{0.523762,0.133215},
{0.52902,0.123404},
{0.532493,0.113341},
{0.538158,0.110463},
{0.53469,0.103712},
{0.53139,0.0972444},
{0.535828,0.0945963},
{0.540035,0.0916302},
{0.544008,0.0884032},
{0.547739,0.0849329},
{0.551218,0.0812366},
{0.55446,0.0773472},
{0.557478,0.0732971},
{0.560261,0.0690951},
{0.562796,0.0647496},
{0.565096,0.0602799},
{0.567175,0.0557049},
{0.569018,0.0510342},
{0.570614,0.0462769},
{0.571959,0.0414465},
{0.573054,0.0365564},
{0.783781,0.930292},
{0.784104,0.924207},
{0.780236,0.92294},
{0.780994,0.917284},
{0.776736,0.915954},
{0.772352,0.914675},
{0.768003,0.913658},
{0.763781,0.917811},
{0.759993,0.922288},
{0.756038,0.922456},
{0.751872,0.922912},
{0.747371,0.923517},
{0.773005,0.90968},
{0.768418,0.908878},
{0.763851,0.913116},
{0.75982,0.917714},
{0.755747,0.917794},
{0.751428,0.918251},
{0.746798,0.918819},
{0.784933,0.918441},
{0.782151,0.911896},
{0.777665,0.910773},
{0.773942,0.904868},
{0.76905,0.904187},
{0.764499,0.903873},
{0.764085,0.908469},
{0.759857,0.908451},
{0.759759,0.912995},
{0.755588,0.913242},
{0.751174,0.913706},
{0.746353,0.914236},
{0.741186,0.914909},
{0.734992,0.911103},
{0.729084,0.912125},
{0.723004,0.913323},
{0.751017,0.909205},
{0.746027,0.909686},
{0.740642,0.910289},
{0.73438,0.906391},
{0.728247,0.90732},
{0.721929,0.90843},
{0.75556,0.908729},
{0.755662,0.904183},
{0.750972,0.90463},
{0.745813,0.905089},
{0.740259,0.905646},
{0.733863,0.901692},
{0.727508,0.902542},
{0.720971,0.903547},
{0.38257,0.0528521},
{0.376188,0.0545489},
{0.384722,0.0600376},
{0.369924,0.0562862},
{0.363714,0.058099},
{0.366368,0.0659847},
{0.372406,0.0639669},
{0.378518,0.0619901},
{0.387285,0.0670157},
{0.389946,0.0739294},
{0.392991,0.0806733},
{0.384007,0.0763641},
{0.387143,0.0833517},
{0.381117,0.0692574},
{0.375166,0.0714445},
{0.378161,0.0787702},
{0.381406,0.0859631},
{0.384807,0.0930918},
{0.39243,0.107134},
{0.396688,0.114108},
{0.386868,0.110308},
{0.391119,0.117512},
{0.395601,0.124783},
{0.401177,0.121141},
{0.406708,0.117318},
{0.417082,0.11957},
{0.388476,0.100141},
{0.382876,0.103111},
{0.377429,0.105947},
{0.381348,0.113357},
{0.38559,0.120756},
{0.390025,0.128235},
{0.400343,0.132084},
{0.405962,0.128141},
{0.411502,0.124015},
{0.422151,0.125877},
{0.427633,0.131929},
{0.433415,0.137876},
{0.416635,0.130601},
{0.411043,0.135097},
{0.422054,0.13707},
{0.416388,0.141966},
{0.405373,0.13938},
{0.410633,0.146691},
{0.4219,0.148783},
{0.427708,0.143414},
{0.433648,0.149681},
{0.42779,0.155483},
{0.434082,0.162042},
{0.440977,0.168444},
{0.453408,0.168691},
{0.464973,0.169684},
{0.474907,0.17199},
{0.483283,0.175336},
{0.48721,0.173199},
{0.489444,0.164794},
{0.783717,0.906913},
{0.78627,0.913013},
{0.778917,0.905811},
{0.775005,0.900229},
{0.769831,0.899658},
{0.765011,0.899359},
{0.760439,0.899467},
{0.760099,0.903885},
{0.755852,0.899662},
{0.750966,0.900062},
{0.745687,0.900498},
{0.739876,0.901061},
{0.733401,0.897032},
{0.726838,0.897787},
{0.720104,0.898696},
{0.788056,0.908058},
{0.789766,0.913929},
{0.791647,0.909132},
{0.790317,0.903434},
{0.78564,0.902192},
{0.780394,0.901194},
{0.776039,0.895753},
{0.770536,0.895202},
{0.765543,0.894955},
{0.760809,0.894975},
{0.756087,0.895223},
{0.781875,0.896564},
{0.787867,0.897589},
{0.78306,0.892082},
{0.776873,0.891359},
{0.771158,0.890867},
{0.766,0.890622},
{0.761121,0.890626},
{0.756297,0.890824},
{0.751204,0.891145},
{0.751112,0.89559},
{0.745623,0.895969},
{0.739695,0.896427},
{0.733004,0.892378},
{0.726257,0.893049},
{0.719351,0.893839},
{0.793199,0.898936},
{0.789649,0.892971},
{0.78361,0.887538},
{0.777341,0.886965},
{0.771535,0.886541},
{0.766293,0.886318},
{0.761343,0.886284},
{0.756414,0.886428},
{0.751222,0.886667},
{0.745483,0.886921},
{0.745572,0.891457},
{0.739444,0.891845},
{0.732681,0.887696},
{0.7258,0.888265},
{0.718733,0.888943},
{0.35761,0.0599697},
{0.351575,0.0619397},
{0.354572,0.0701457},
{0.360418,0.0680441},
{0.363504,0.075853},
{0.369243,0.0736679},
{0.372364,0.0811734},
{0.375688,0.0885541},
{0.379171,0.0958632},
{0.345635,0.063987},
{0.339729,0.0661486},
{0.343071,0.0745447},
{0.3488,0.0723067},
{0.352097,0.0803867},
{0.357724,0.0781294},
{0.366651,0.0835615},
{0.370064,0.0910956},
{0.361057,0.0859227},
{0.36454,0.0935884},
{0.368141,0.101189},
{0.373603,0.0985658},
{0.355532,0.0882872},
{0.359098,0.0960517},
{0.362736,0.103766},
{0.366529,0.111439},
{0.371914,0.108744},
{0.375911,0.116271},
{0.380112,0.12383},
{0.384496,0.131485},
{0.394779,0.13575},
{0.370512,0.119083},
{0.374679,0.126769},
{0.365108,0.12183},
{0.369213,0.129624},
{0.373436,0.137534},
{0.378978,0.134572},
{0.3891,0.139256},
{0.399665,0.143416},
{0.404846,0.151152},
{0.416065,0.154041},
{0.421898,0.161269},
{0.428362,0.168217},
{0.435619,0.174776},
{0.443828,0.180837},
{0.448488,0.174721},
{0.460417,0.17506},
{0.470904,0.176258},
{0.479738,0.178429},
{0.486979,0.181417},
{0.490035,0.179568},
{0.491447,0.171881},
{0.494896,0.164113},
{0.361142,0.114086},
{0.355823,0.116677},
{0.35972,0.124508},
{0.363762,0.132392},
{0.367896,0.140373},
{0.377822,0.145613},
{0.383482,0.142529},
{0.393959,0.147168},
{0.399039,0.155293},
{0.4102,0.159057},
{0.416203,0.16686},
{0.422635,0.174535},
{0.430433,0.181461},
{0.43945,0.187272},
{0.449327,0.191964},
{0.452541,0.186299},
{0.456346,0.180624},
{0.467359,0.181065},
{0.476599,0.182177},
{0.484256,0.184088},
{0.490193,0.18654},
{0.492521,0.185115},
{0.495019,0.184155},
{0.493354,0.178418},
{0.495897,0.171224},
{0.500467,0.163957},
{0.38822,0.15066},
{0.39318,0.159086},
{0.382415,0.153915},
{0.387191,0.162543},
{0.398306,0.167909},
{0.404306,0.163704},
{0.410102,0.172325},
{0.416771,0.181085},
{0.424974,0.188794},
{0.435373,0.194261},
{0.44661,0.198161},
{0.457328,0.201171},
{0.458946,0.196051},
{0.461308,0.191063},
{0.464188,0.186103},
{0.473951,0.186445},
{0.481891,0.187343},
{0.48826,0.18881},
{0.492754,0.19052},
{0.494479,0.189641},
{0.496471,0.189298},
{0.497738,0.183821},
{0.496863,0.177846},
{0.500467,0.171067},
{0.505037,0.171224},
{0.506038,0.164113},
{0.51149,0.164794},
{0.516702,0.16621},
{0.525638,0.161006},
{0.529841,0.152573},
{0.534389,0.142285},
{0.531637,0.131867},
{0.539023,0.128631},
{0.53564,0.120769},
{0.541796,0.117317},
{0.5435,0.107092},
{0.539587,0.100745},
{0.544197,0.0974182},
{0.548534,0.0938369},
{0.552576,0.0900023},
{0.556352,0.0859664},
{0.559848,0.0817286},
{0.563102,0.0773386},
{0.566082,0.072788},
{0.568821,0.0681182},
{0.571291,0.063312},
{0.573529,0.0584018},
{0.575494,0.0533836},
{0.577237,0.048295},
{0.578687,0.0431172},
{0.579869,0.037873},
{0.372199,0.148555},
{0.376583,0.156947},
{0.381151,0.165702},
{0.392125,0.171601},
{0.403999,0.177161},
{0.410331,0.186923},
{0.418762,0.198081},
{0.407799,0.201499},
{0.420995,0.21061},
{0.432741,0.202045},
{0.445075,0.204665},
{0.456546,0.206571},
{0.467034,0.203378},
{0.467898,0.199122},
{0.46958,0.195032},
{0.471641,0.190815},
{0.479909,0.19094},
{0.486466,0.191403},
{0.491555,0.192435},
{0.494293,0.192961},
{0.495778,0.193297},
{0.497417,0.193397},
{0.498468,0.18899},
{0.500468,0.183664},
{0.500467,0.177705},
{0.504071,0.177846},
{0.50758,0.178418},
{0.509486,0.171875},
{0.513724,0.173199},
{0.52158,0.168546},
{0.531103,0.164848},
{0.536351,0.157074},
{0.542135,0.149578},
{0.543221,0.136329},
{0.550353,0.131182},
{0.545841,0.124354},
{0.547623,0.113513},
{0.548515,0.103351},
{0.553199,0.0993659},
{0.557556,0.0951526},
{0.56159,0.090729},
{0.565326,0.0861281},
{0.568792,0.0813824},
{0.57198,0.0764964},
{0.574883,0.0714744},
{0.577517,0.0663314},
{0.579901,0.0610825},
{0.582021,0.0557327},
{0.58386,0.0502873},
{0.585418,0.0447556},
{0.586691,0.0391468},
{0.5935,0.0403952},
{0.600273,0.0416355},
{0.607005,0.0428903},
{0.61369,0.0441822},
{0.620305,0.045522},
{0.62683,0.0469204},
{0.633282,0.0484006},
{0.63968,0.0499858},
{0.646003,0.051678},
{0.65223,0.0534795},
{0.658387,0.0554092},
{0.664499,0.057486},
{0.670552,0.0597061},
{0.676534,0.0620658},
{0.682464,0.0645816},
{0.688363,0.0672699},
{0.694232,0.0701252},
{0.700068,0.0731419},
{0.705884,0.0763333},
{0.711691,0.0797132},
{0.717506,0.083277},
{0.723345,0.0870204},
{0.729213,0.0909491},
{0.735116,0.0950686},
{0.74109,0.099375},
{0.747169,0.103865},
{0.753358,0.108528},
{0.759661,0.113354},
{0.766132,0.118329},
{0.772822,0.123441},
{0.779739,0.128652},
{0.786892,0.133926},
{0.794328,0.139232},
{0.802093,0.144539},
{0.810181,0.149791},
{0.818584,0.15493},
{0.827283,0.159947},
{0.836257,0.16483},
{0.845458,0.169557},
{0.854836,0.174106},
{0.864348,0.178534},
{0.873953,0.182896},
{0.883605,0.187224},
{0.87132,0.188061},
{0.88092,0.192626},
{0.878157,0.197675},
{0.868655,0.193125},
{0.875394,0.202724},
{0.865974,0.198132},
{0.863291,0.203127},
{0.872631,0.207773},
{0.860623,0.208081},
{0.869867,0.212822},
{0.867189,0.217644},
{0.857984,0.212966},
{0.86451,0.222466},
{0.855367,0.217811},
{0.852765,0.222644},
{0.861831,0.227288},
{0.850196,0.227446},
{0.859152,0.23211},
{0.856611,0.236792},
{0.84768,0.2322},
{0.854069,0.241473},
{0.8452,0.236923},
{0.84274,0.241631},
{0.851528,0.246154},
{0.84031,0.24631},
{0.848986,0.250836},
{0.846541,0.255421},
{0.837925,0.250948},
{0.844096,0.260006},
{0.835568,0.255553},
{0.833226,0.260136},
{0.84165,0.264591},
{0.830892,0.264681},
{0.839205,0.269175},
{0.836716,0.27366},
{0.828559,0.269172},
{0.834228,0.278144},
{0.826227,0.273629},
{0.823902,0.278073},
{0.831739,0.282628},
{0.821579,0.282509},
{0.829251,0.287112},
{0.402877,0.191104},
{0.399374,0.204376},
{0.402569,0.214734},
{0.41109,0.212225},
{0.413232,0.22298},
{0.42267,0.221169},
{0.432699,0.210868},
{0.444999,0.211848},
{0.456694,0.212399},
{0.466763,0.207756},
{0.475237,0.20487},
{0.475759,0.2015},
{0.476807,0.19811},
{0.478238,0.194617},
{0.485158,0.194556},
{0.490605,0.194867},
{0.494208,0.194922},
{0.496284,0.196234},
{0.497925,0.196735},
{0.498996,0.193324},
{0.500467,0.188845},
{0.502466,0.18899},
{0.503196,0.183821},
{0.505915,0.184153},
{0.510898,0.179568},
{0.51765,0.175336},
{0.526027,0.17199},
{0.535961,0.169683},
{0.542207,0.162793},
{0.54847,0.155991},
{0.555012,0.149707},
{0.548817,0.143266},
{0.555674,0.137617},
{0.556771,0.126113},
{0.552015,0.119884},
{0.552987,0.109296},
{0.557999,0.104907},
{0.56257,0.10022},
{0.566902,0.0954672},
{0.570828,0.0904718},
{0.57451,0.0853865},
{0.577798,0.0801063},
{0.580937,0.0747925},
{0.583694,0.0692999},
{0.586248,0.0637331},
{0.588415,0.0580136},
{0.590458,0.0522576},
{0.592091,0.0463604},
{0.598782,0.0479743},
{0.605386,0.0495813},
{0.611934,0.05121},
{0.618362,0.0528516},
{0.624745,0.0545489},
{0.63101,0.0562862},
{0.63722,0.058099},
{0.643323,0.0599692},
{0.649359,0.0619397},
{0.655299,0.063987},
{0.661204,0.0661486},
{0.667052,0.068403},
{0.672833,0.0707829},
{0.678568,0.0732701},
{0.684291,0.0759006},
{0.690014,0.078661},
{0.695693,0.0815575},
{0.701385,0.0845953},
{0.707092,0.0877995},
{0.712862,0.0911746},
{0.718633,0.0946902},
{0.724487,0.0983832},
{0.730402,0.102256},
{0.736453,0.106329},
{0.742578,0.110542},
{0.748876,0.114948},
{0.755308,0.119518},
{0.76197,0.124273},
{0.768806,0.129135},
{0.775924,0.134138},
{0.783276,0.139218},
{0.790952,0.144369},
{0.798894,0.149531},
{0.807182,0.154685},
{0.815749,0.159759},
{0.824603,0.16474},
{0.833654,0.169635},
{0.842914,0.174404},
{0.852296,0.17903},
{0.861779,0.183559},
{0.859175,0.188558},
{0.856567,0.193514},
{0.853948,0.198472},
{0.851341,0.203396},
{0.848759,0.208292},
{0.84619,0.213163},
{0.843663,0.218012},
{0.841157,0.222841},
{0.838704,0.227635},
{0.83627,0.232415},
{0.833901,0.237147},
{0.831551,0.241864},
{0.829255,0.246532},
{0.826971,0.251191},
{0.824752,0.25576},
{0.822535,0.260315},
{0.820351,0.264787},
{0.818174,0.26923},
{0.81604,0.273573},
{0.813906,0.277906},
{0.79689,0.888566},
{0.797119,0.894078},
{0.797054,0.900715},
{0.800807,0.897458},
{0.803994,0.892296},
{0.803236,0.888209},
{0.80291,0.883597},
{0.796649,0.883668},
{0.790237,0.888207},
{0.790217,0.883418},
{0.783841,0.883003},
{0.777601,0.882573},
{0.771827,0.882237},
{0.766506,0.882034},
{0.761487,0.882003},
{0.756482,0.88204},
{0.751144,0.882189},
{0.745375,0.882382},
{0.738987,0.882667},
{0.739276,0.887245},
{0.732395,0.883006},
{0.725401,0.883471},
{0.718213,0.884025},
{0.783901,0.878463},
{0.77781,0.878184},
{0.77204,0.877934},
{0.766729,0.877758},
{0.761644,0.877666},
{0.756548,0.877667},
{0.751179,0.877739},
{0.74527,0.877862},
{0.738891,0.878053},
{0.732112,0.878329},
{0.772378,0.873582},
{0.778102,0.873746},
{0.784139,0.873901},
{0.778613,0.869205},
{0.772888,0.869096},
{0.767456,0.868977},
{0.767025,0.873427},
{0.796493,0.878897},
{0.790177,0.878725},
{0.796489,0.874175},
{0.790264,0.874069},
{0.784552,0.869303},
{0.779257,0.864626},
{0.773532,0.864546},
{0.767975,0.864465},
{0.762487,0.864379},
{0.762144,0.868872},
{0.761845,0.873308},
{0.75116,0.873282},
{0.756638,0.873269},
{0.756777,0.868807},
{0.751153,0.868779},
{0.745069,0.868781},
{0.745167,0.873336},
{0.724723,0.873883},
{0.731867,0.873639},
{0.738683,0.87345},
{0.738568,0.868823},
{0.731698,0.868913},
{0.724536,0.869034},
{0.71739,0.874163},
{0.725032,0.878682},
{0.717753,0.879107},
{0.333882,0.0684033},
{0.3281,0.0707829},
{0.337393,0.0768572},
{0.340972,0.0850422},
{0.346493,0.0827113},
{0.350029,0.0906854},
{0.353653,0.0985349},
{0.357341,0.106328},
{0.322366,0.0732701},
{0.316642,0.0759006},
{0.326189,0.0817174},
{0.331774,0.0792421},
{0.335451,0.0874817},
{0.344564,0.0931065},
{0.348244,0.101016},
{0.339156,0.0955397},
{0.34289,0.103481},
{0.346652,0.111372},
{0.351974,0.108866},
{0.329975,0.0899488},
{0.33377,0.098012},
{0.337559,0.105962},
{0.341341,0.113875},
{0.345149,0.121776},
{0.350469,0.11924},
{0.354369,0.127115},
{0.358343,0.135047},
{0.362384,0.143088},
{0.366516,0.151307},
{0.34902,0.129673},
{0.352933,0.137634},
{0.347477,0.140181},
{0.356869,0.145708},
{0.36086,0.153969},
{0.364938,0.162431},
{0.370765,0.159772},
{0.375108,0.168555},
{0.379522,0.177727},
{0.385839,0.174851},
{0.39732,0.181113},
{0.395192,0.194257},
{0.391849,0.207007},
{0.395019,0.217155},
{0.397806,0.227438},
{0.40523,0.225162},
{0.407392,0.235615},
{0.41471,0.233462},
{0.423492,0.231331},
{0.433859,0.220114},
{0.445988,0.219333},
{0.457814,0.218537},
{0.46717,0.212481},
{0.475252,0.208346},
{0.481841,0.205763},
{0.482017,0.202991},
{0.482979,0.20041},
{0.483877,0.197485},
{0.489624,0.197299},
{0.493771,0.197162},
{0.496243,0.198616},
{0.497869,0.199116},
{0.49927,0.196792},
{0.500467,0.193181},
{0.501937,0.193324},
{0.503516,0.193391},
{0.504463,0.189298},
{0.506454,0.189641},
{0.508413,0.185115},
{0.513955,0.181417},
{0.521195,0.178429},
{0.53003,0.176258},
{0.540517,0.17506},
{0.547526,0.168691},
{0.554418,0.162223},
{0.561011,0.155918},
{0.561325,0.143715},
{0.343636,0.132209},
{0.341974,0.142705},
{0.351321,0.148262},
{0.355185,0.156506},
{0.359082,0.164963},
{0.36298,0.173688},
{0.36906,0.1712},
{0.373187,0.180324},
{0.377225,0.189762},
{0.383882,0.187232},
{0.390619,0.184377},
{0.388064,0.197013},
{0.38481,0.209355},
{0.387892,0.219411},
{0.390662,0.22961},
{0.39346,0.239965},
{0.400442,0.237844},
{0.403002,0.24831},
{0.409429,0.246058},
{0.415855,0.243806},
{0.422282,0.241554},
{0.43572,0.238132},
{0.434835,0.22917},
{0.447426,0.227006},
{0.459951,0.224864},
{0.468437,0.217432},
{0.475814,0.212053},
{0.481815,0.208431},
{0.486529,0.208048},
{0.486748,0.206171},
{0.487482,0.204234},
{0.488087,0.202045},
{0.488741,0.199701},
{0.493229,0.199278},
{0.495897,0.200605},
{0.497843,0.201377},
{0.499345,0.199533},
{0.500467,0.196709},
{0.501664,0.196792},
{0.503009,0.196735},
{0.50465,0.196234},
{0.505156,0.193297},
{0.506641,0.192961},
{0.50818,0.19052},
{0.510751,0.18653},
{0.516678,0.184088},
{0.524338,0.182173},
{0.533575,0.181065},
{0.544593,0.180616},
{0.552446,0.174721},
{0.559957,0.168444},
{0.566851,0.162042},
{0.567286,0.149681},
{0.567519,0.137876},
{0.561986,0.132109},
{0.562593,0.120999},
{0.557669,0.115224},
{0.562931,0.110377},
{0.567796,0.105344},
{0.572259,0.100124},
{0.57638,0.0947633},
{0.580218,0.0893087},
{0.583747,0.0837425},
{0.586944,0.0780471},
{0.589856,0.0722404},
{0.592528,0.0663399},
{0.594923,0.0603337},
{0.597003,0.0542094},
{0.603486,0.0561516},
{0.609895,0.0580929},
{0.616212,0.0600376},
{0.622416,0.0619901},
{0.628527,0.0639669},
{0.634565,0.0659847},
{0.640515,0.0680441},
{0.646361,0.0701457},
{0.652134,0.0723067},
{0.657863,0.0745447},
{0.663541,0.0768572},
{0.669159,0.0792421},
{0.674744,0.0817174},
{0.680323,0.0843012},
{0.685899,0.0869914},
{0.691476,0.0897862},
{0.697072,0.0927028},
{0.702702,0.0957583},
{0.708387,0.0989543},
{0.714147,0.102293},
{0.719989,0.105784},
{0.725923,0.109441},
{0.731982,0.113267},
{0.738202,0.117267},
{0.744587,0.121437},
{0.75114,0.125775},
{0.757907,0.130277},
{0.764931,0.134938},
{0.772213,0.13973},
{0.779753,0.144625},
{0.787583,0.149599},
{0.795735,0.15463},
{0.804185,0.15967},
{0.81291,0.164668},
{0.821876,0.169613},
{0.831046,0.174492},
{0.840354,0.17928},
{0.849736,0.183956},
{0.381196,0.199452},
{0.377672,0.211456},
{0.380637,0.221426},
{0.383366,0.231546},
{0.386043,0.241797},
{0.388695,0.252114},
{0.396576,0.250562},
{0.790626,0.869393},
{0.785186,0.864693},
{0.779949,0.860074},
{0.774187,0.860017},
{0.768532,0.859948},
{0.762881,0.859872},
{0.75713,0.859793},
{0.756948,0.864307},
{0.796749,0.869449},
{0.802662,0.874181},
{0.802835,0.869448},
{0.797162,0.864763},
{0.791145,0.864737},
{0.785795,0.860116},
{0.78056,0.855588},
{0.774789,0.855533},
{0.769035,0.855461},
{0.763219,0.855375},
{0.757326,0.855276},
{0.751253,0.855152},
{0.751182,0.859707},
{0.751127,0.864245},
{0.744988,0.864203},
{0.791704,0.860142},
{0.786338,0.855636},
{0.780961,0.851209},
{0.77519,0.851134},
{0.76939,0.851036},
{0.763519,0.850914},
{0.757536,0.850764},
{0.751404,0.850576},
{0.744964,0.85499},
{0.744942,0.859609},
{0.797615,0.86015},
{0.803134,0.864752},
{0.803471,0.860136},
{0.798003,0.855654},
{0.792187,0.855649},
{0.786718,0.851263},
{0.781217,0.846868},
{0.775445,0.846751},
{0.769652,0.846616},
{0.763731,0.846412},
{0.757757,0.846218},
{0.751605,0.845934},
{0.74509,0.850336},
{0.738406,0.854783},
{0.738395,0.859499},
{0.738389,0.864169},
{0.731591,0.864158},
{0.72443,0.864142},
{0.71716,0.86917},
{0.717044,0.864134},
{0.717028,0.859062},
{0.717162,0.85394},
{0.717499,0.848755},
{0.718017,0.843491},
{0.71869,0.83813},
{0.71954,0.832672},
{0.72059,0.827116},
{0.721828,0.821429},
{0.723244,0.815576},
{0.724845,0.809581},
{0.72664,0.803472},
{0.72861,0.797201},
{0.730741,0.790724},
{0.733008,0.784086},
{0.731531,0.859378},
{0.724393,0.859235},
{0.73157,0.85456},
{0.72447,0.854281},
{0.31092,0.0786608},
{0.320611,0.0843012},
{0.324509,0.0925062},
{0.328371,0.10055},
{0.332201,0.108496},
{0.336005,0.116403},
{0.339808,0.1243},
{0.338214,0.134731},
{0.336446,0.145189},
{0.345737,0.150763},
{0.349464,0.159017},
{0.3532,0.167398},
{0.356873,0.176075},
{0.360513,0.185004},
{0.366847,0.182736},
{0.370634,0.192071},
{0.37429,0.201658},
{0.305241,0.0815575},
{0.315035,0.0869914},
{0.319009,0.0951299},
{0.322952,0.103151},
{0.326806,0.111077},
{0.330638,0.118956},
{0.334419,0.126842},
{0.332751,0.13725},
{0.330853,0.147671},
{0.340113,0.153223},
{0.343736,0.161399},
{0.347297,0.169765},
{0.350786,0.178346},
{0.354194,0.187171},
{0.357468,0.196243},
{0.363994,0.19425},
{0.367395,0.203679},
{0.370481,0.213366},
{0.299549,0.0845953},
{0.309458,0.0897862},
{0.313539,0.0978601},
{0.317508,0.105811},
{0.321396,0.113685},
{0.325231,0.121529},
{0.329016,0.129374},
{0.327226,0.139776},
{0.325181,0.150155},
{0.33443,0.155656},
{0.337923,0.163789},
{0.341354,0.172074},
{0.344669,0.180564},
{0.347873,0.189261},
{0.350907,0.198204},
{0.353774,0.207363},
{0.360556,0.205567},
{0.363428,0.215124},
{0.366054,0.2249},
{0.373331,0.223241},
{0.375893,0.233284},
{0.378402,0.243442},
{0.380813,0.253666},
{0.293841,0.0877995},
{0.303862,0.0927028},
{0.307996,0.100682},
{0.312025,0.108549},
{0.315932,0.116356},
{0.319771,0.124145},
{0.323524,0.131951},
{0.32162,0.142321},
{0.319373,0.152674},
{0.328668,0.158078},
{0.332065,0.166127},
{0.33535,0.174337},
{0.338511,0.182722},
{0.341537,0.191297},
{0.344394,0.200087},
{0.347048,0.209113},
{0.349487,0.218379},
{0.356415,0.216783},
{0.358833,0.226436},
{0.36105,0.236319},
{0.368477,0.234867},
{0.370744,0.245001},
{0.372932,0.255218},
{0.792476,0.851297},
{0.786912,0.846939},
{0.781392,0.842496},
{0.775663,0.842338},
{0.769872,0.842143},
{0.76399,0.8419},
{0.757984,0.841594},
{0.751852,0.84123},
{0.745304,0.84562},
{0.738556,0.850042},
{0.798213,0.851312},
{0.803758,0.85564},
{0.803908,0.851306},
{0.798294,0.847039},
{0.79263,0.84701},
{0.78707,0.84262},
{0.781537,0.838025},
{0.775849,0.837816},
{0.770093,0.837562},
{0.764237,0.837227},
{0.758261,0.836858},
{0.752169,0.836401},
{0.745589,0.840811},
{0.738781,0.845179},
{0.731765,0.84969},
{0.724739,0.849265},
{0.792706,0.842713},
{0.787169,0.838172},
{0.781703,0.833388},
{0.776065,0.833129},
{0.770353,0.832816},
{0.764547,0.832434},
{0.75863,0.831973},
{0.75261,0.831434},
{0.745977,0.835886},
{0.739163,0.840308},
{0.732095,0.844742},
{0.725163,0.84415},
{0.79833,0.842773},
{0.803963,0.847053},
{0.80397,0.8428},
{0.798343,0.838413},
{0.792758,0.838323},
{0.787287,0.833597},
{0.787439,0.828731},
{0.7819,0.828549},
{0.776318,0.828214},
{0.770662,0.827871},
{0.764919,0.827354},
{0.759087,0.826898},
{0.753164,0.826256},
{0.746497,0.830822},
{0.739641,0.835253},
{0.732537,0.839692},
{0.725713,0.838965},
{0.733117,0.83453},
{0.726414,0.833659},
{0.288073,0.0911737},
{0.298231,0.0957583},
{0.302438,0.103612},
{0.306487,0.111383},
{0.31041,0.119107},
{0.31424,0.126822},
{0.317977,0.134552},
{0.315902,0.144905},
{0.313451,0.155219},
{0.322795,0.160508},
{0.326025,0.168509},
{0.329249,0.176579},
{0.332246,0.184864},
{0.33514,0.1933},
{0.33776,0.201994},
{0.340311,0.210821},
{0.342546,0.219932},
{0.344587,0.229253},
{0.351701,0.227887},
{0.353727,0.237604},
{0.355608,0.247501},
{0.363127,0.246384},
{0.365051,0.25677},
{0.282301,0.0946902},
{0.292546,0.0989543},
{0.296728,0.106685},
{0.300863,0.114322},
{0.30477,0.121958},
{0.308606,0.129571},
{0.312252,0.137243},
{0.310039,0.147548},
{0.307364,0.157816},
{0.316778,0.162965},
{0.31998,0.170823},
{0.323014,0.17883},
{0.325895,0.186985},
{0.328637,0.19529},
{0.331188,0.203781},
{0.333498,0.212491},
{0.335575,0.221413},
{0.337425,0.230539},
{0.3391,0.239855},
{0.346387,0.238799},
{0.348134,0.248453},
{0.349778,0.258203},
{0.357415,0.257486},
{0.276446,0.0983832},
{0.286786,0.102293},
{0.291056,0.109848},
{0.29512,0.117375},
{0.299029,0.124889},
{0.302834,0.132402},
{0.306511,0.139945},
{0.304031,0.150249},
{0.301143,0.16045},
{0.310614,0.16545},
{0.313698,0.173201},
{0.316642,0.181078},
{0.319396,0.189103},
{0.322015,0.197253},
{0.324404,0.205581},
{0.32659,0.214102},
{0.328502,0.222825},
{0.330193,0.231721},
{0.331689,0.240804},
{0.333101,0.250071},
{0.340652,0.249344},
{0.342141,0.258919},
{0.270532,0.102256},
{0.280944,0.105784},
{0.285188,0.113181},
{0.289263,0.120549},
{0.293146,0.127932},
{0.296926,0.135321},
{0.300543,0.142761},
{0.297875,0.153008},
{0.291518,0.155856},
{0.294685,0.163169},
{0.3043,0.167962},
{0.307308,0.175574},
{0.310127,0.183317},
{0.312773,0.191185},
{0.315263,0.199173},
{0.317545,0.207311},
{0.319568,0.215632},
{0.321341,0.224123},
{0.322871,0.232773},
{0.324212,0.241578},
{0.325421,0.250533},
{0.326565,0.259564},
{0.334504,0.259635},
{0.792837,0.833759},
{0.792945,0.828997},
{0.793085,0.824011},
{0.787616,0.823782},
{0.782138,0.823473},
{0.77662,0.823103},
{0.771032,0.822694},
{0.765371,0.822205},
{0.75963,0.821595},
{0.753807,0.820892},
{0.747141,0.825579},
{0.740257,0.830103},
{0.798392,0.833877},
{0.803991,0.833952},
{0.804041,0.829243},
{0.798479,0.829111},
{0.798574,0.82418},
{0.798711,0.818974},
{0.793268,0.818779},
{0.787857,0.818489},
{0.782434,0.818158},
{0.776987,0.817737},
{0.771481,0.817286},
{0.765917,0.816722},
{0.760275,0.816071},
{0.754569,0.815294},
{0.747902,0.820122},
{0.741015,0.824683},
{0.733858,0.829247},
{0.727302,0.828251},
{0.734754,0.823803},
{0.728366,0.822667},
{0.72958,0.816936},
{0.730967,0.81102},
{0.732537,0.804985},
{0.734286,0.798738},
{0.736175,0.79229},
{0.738208,0.785631},
{0.741903,0.81923},
{0.735797,0.818161},
{0.742947,0.813474},
{0.736998,0.81234},
{0.738367,0.806361},
{0.739896,0.800176},
{0.741576,0.79374},
{0.74339,0.787096},
{0.748575,0.78839},
{0.753744,0.789524},
{0.758909,0.790509},
{0.764043,0.791456},
{0.769166,0.792269},
{0.774267,0.792968},
{0.748793,0.814461},
{0.749828,0.808608},
{0.744131,0.807576},
{0.745495,0.801332},
{0.746952,0.795036},
{0.264482,0.106328},
{0.258355,0.110542},
{0.268952,0.113267},
{0.275011,0.109441},
{0.279263,0.116636},
{0.283294,0.123848},
{0.287153,0.13108},
{0.290885,0.138336},
{0.294467,0.145637},
{0.288076,0.148673},
{0.281644,0.151737},
{0.284903,0.15882},
{0.288007,0.165976},
{0.297782,0.170531},
{0.30059,0.17804},
{0.303413,0.18558},
{0.305923,0.193284},
{0.308324,0.201084},
{0.310369,0.209059},
{0.312381,0.217116},
{0.313994,0.225358},
{0.315412,0.233736},
{0.31654,0.242252},
{0.317647,0.250841},
{0.318625,0.259493},
{0.309812,0.251104},
{0.310685,0.259422},
{0.301877,0.251297},
{0.302745,0.25935},
{0.293802,0.251394},
{0.294518,0.258987},
{0.285625,0.251457},
{0.286292,0.258624},
{0.277382,0.251546},
{0.278065,0.258262},
{0.269042,0.251775},
{0.269838,0.257899},
{0.261364,0.25824},
{0.260578,0.252257},
{0.252889,0.258581},
{0.252032,0.252937},
{0.244415,0.258923},
{0.243451,0.253761},
{0.235941,0.259264},
{0.234859,0.255016},
{0.227548,0.261623},
{0.226279,0.256988},
{0.219156,0.263982},
{0.217728,0.259428},
{0.210764,0.266341},
{0.209221,0.262086},
{0.202371,0.2687},
{0.200874,0.265244},
{0.192803,0.269185},
{0.194699,0.273303},
{0.184894,0.273573},
{0.187027,0.277906},
{0.177032,0.278073},
{0.179355,0.282509},
{0.169194,0.282628},
{0.171683,0.287112},
{0.252057,0.114948},
{0.262732,0.117267},
{0.273069,0.120311},
{0.277161,0.127293},
{0.280951,0.134378},
{0.284654,0.141469},
{0.278181,0.144743},
{0.27148,0.148149},
{0.274847,0.154983},
{0.278049,0.161891},
{0.281061,0.168886},
{0.291004,0.173187},
{0.293836,0.180485},
{0.296444,0.1879},
{0.298868,0.195417},
{0.301145,0.20302},
{0.303206,0.210736},
{0.304977,0.21859},
{0.306489,0.226566},
{0.307771,0.23465},
{0.308866,0.242832},
{0.300983,0.243364},
{0.293015,0.243831},
{0.284828,0.244313},
{0.276629,0.244817},
{0.268222,0.245454},
{0.259731,0.246249},
{0.25108,0.247294},
{0.242433,0.248531},
{0.233695,0.250178},
{0.224967,0.252281},
{0.266885,0.124051},
{0.270808,0.130905},
{0.260386,0.128028},
{0.264254,0.134671},
{0.274555,0.137809},
{0.267917,0.141396},
{0.257515,0.13858},
{0.261101,0.145106},
{0.256347,0.121437},
{0.249793,0.125775},
{0.253761,0.132127},
{0.246761,0.136475},
{0.250527,0.142651},
{0.25399,0.14899},
{0.264568,0.151679},
{0.267873,0.158323},
{0.270973,0.16506},
{0.273914,0.171868},
{0.283984,0.175921},
{0.286705,0.183046},
{0.289241,0.190269},
{0.291558,0.197592},
{0.29375,0.204974},
{0.295689,0.212455},
{0.297384,0.220049},
{0.298784,0.227748},
{0.299983,0.235515},
{0.292083,0.23633},
{0.284018,0.237158},
{0.275737,0.23806},
{0.267299,0.239063},
{0.258763,0.240192},
{0.250107,0.241532},
{0.241306,0.243163},
{0.232436,0.245118},
{0.22357,0.247427},
{0.79889,0.813504},
{0.793504,0.813281},
{0.788152,0.812987},
{0.782807,0.812603},
{0.777442,0.81215},
{0.772028,0.811647},
{0.766563,0.811055},
{0.761042,0.810334},
{0.755464,0.80951},
{0.793795,0.807488},
{0.78854,0.807071},
{0.783259,0.806761},
{0.777992,0.80625},
{0.772675,0.805732},
{0.767338,0.804996},
{0.761927,0.804337},
{0.756496,0.803446},
{0.788955,0.801035},
{0.783794,0.800585},
{0.778628,0.80006},
{0.773424,0.799495},
{0.768188,0.798838},
{0.76293,0.798032},
{0.75764,0.797119},
{0.751002,0.802516},
{0.75231,0.796142},
{0.779352,0.793544},
{0.799387,0.801637},
{0.799125,0.807699},
{0.804501,0.807927},
{0.804699,0.801851},
{0.794146,0.801376},
{0.245625,0.119518},
{0.238965,0.124272},
{0.232127,0.129135},
{0.243027,0.130277},
{0.22501,0.134138},
{0.236003,0.134938},
{0.239712,0.140857},
{0.243227,0.146901},
{0.246597,0.153032},
{0.257386,0.155358},
{0.260474,0.161872},
{0.263615,0.168358},
{0.266448,0.174982},
{0.276741,0.178723},
{0.279398,0.185651},
{0.281827,0.192677},
{0.284069,0.199779},
{0.286163,0.206935},
{0.28804,0.214166},
{0.289631,0.221489},
{0.290968,0.228885},
{0.282931,0.230049},
{0.27468,0.231289},
{0.266218,0.232634},
{0.257658,0.234089},
{0.248936,0.235756},
{0.240059,0.237682},
{0.231071,0.239913},
{0.222088,0.242446},
{0.235646,0.151297},
{0.238883,0.157237},
{0.249872,0.159212},
{0.252996,0.165465},
{0.255913,0.171818},
{0.258679,0.178236},
{0.269215,0.181633},
{0.27166,0.188407},
{0.274143,0.195166},
{0.276285,0.202044},
{0.278328,0.208952},
{0.280004,0.21596},
{0.281665,0.222961},
{0.273433,0.224517},
{0.264992,0.226172},
{0.256398,0.227943},
{0.247634,0.229898},
{0.23868,0.232108},
{0.229616,0.234587},
{0.228721,0.13973},
{0.232246,0.145463},
{0.221181,0.144625},
{0.224578,0.150151},
{0.227816,0.155804},
{0.247911,0.175419},
{0.25058,0.181638},
{0.261349,0.184686},
{0.263855,0.191192},
{0.266128,0.197778},
{0.268221,0.204414},
{0.270188,0.211074},
{0.271951,0.21777},
{0.263514,0.219725},
{0.254935,0.221782},
{0.24604,0.224075},
{0.237137,0.226488},
{0.228003,0.229222},
{0.226222,0.223832},
{0.224301,0.218431},
{0.231535,0.209561},
{0.229422,0.203888},
{0.227134,0.198256},
{0.224726,0.192646},
{0.231113,0.183007},
{0.22834,0.17731},
{0.22563,0.171584},
{0.222674,0.165984},
{0.217657,0.139218},
{0.242062,0.163212},
{0.245067,0.169275},
{0.239655,0.179141},
{0.242259,0.185146},
{0.253189,0.18787},
{0.255608,0.19416},
{0.257837,0.200508},
{0.259862,0.206906},
{0.261799,0.213301},
{0.253219,0.215637},
{0.244426,0.218141},
{0.235398,0.220871},
{0.23094,0.161544},
{0.233993,0.167333},
{0.236918,0.173191},
{0.233632,0.188814},
{0.244783,0.191169},
{0.24716,0.197231},
{0.249322,0.203351},
{0.251324,0.209497},
{0.242534,0.212264},
{0.233513,0.215236},
{0.236106,0.19462},
{0.23832,0.20052},
{0.240563,0.206354},
{0.787942,0.935861},
{0.787265,0.93052},
{0.787509,0.924789},
{0.788364,0.919203},
{0.790327,0.930074},
{0.790593,0.92481},
{0.791364,0.919607},
{0.79271,0.914612},
{0.794011,0.919688},
{0.795215,0.914982},
{0.794628,0.910091},
{0.79333,0.924677},
{0.79595,0.924384},
{0.796482,0.919608},
{0.797014,0.914833},
{0.797137,0.910889},
{0.797009,0.906095},
{0.79406,0.904749},
{0.799894,0.902516},
{0.803242,0.899665},
{0.805497,0.895409},
{0.809803,0.891376},
{0.809315,0.887663},
{0.808997,0.883364},
{0.808826,0.878831},
{0.802703,0.878909},
{0.792976,0.929619},
{0.795418,0.929159},
{0.793283,0.934141},
{0.790867,0.93486},
{0.789847,0.940277},
{0.792324,0.938995},
{0.794585,0.937871},
{0.79674,0.936827},
{0.794886,0.933934},
{0.79954,0.907257},
{0.802185,0.903933},
{0.80519,0.901244},
{0.807228,0.89775},
{0.810621,0.894241},
{0.815405,0.891044},
{0.815166,0.887459},
{0.814984,0.883233},
{0.814882,0.878731},
{0.814856,0.874073},
{0.808793,0.874128},
{0.808886,0.869416},
{0.8042,0.905157},
{0.806596,0.901932},
{0.808671,0.899518},
{0.811528,0.896489},
{0.815678,0.893624},
{0.820904,0.891644},
{0.820904,0.887442},
{0.820903,0.883173},
{0.820904,0.878676},
{0.820904,0.87404},
{0.820904,0.869358},
{0.814903,0.869378},
{0.801805,0.908382},
{0.799409,0.911608},
{0.695312,0.346943},
{0.757739,0.377165},
{0.732558,0.39157},
{0.673932,0.365676},
{0.707811,0.405053},
{0.764139,0.444033},
{0.794458,0.4365},
{0.721021,0.31783},
{0.651899,0.316376},
{0.635827,0.335595},
{0.620602,0.353341},
{0.65446,0.380579},
{0.683931,0.41669},
{0.733389,0.452049},
{0.790555,0.498107},
{0.831176,0.495836},
{0.75255,0.500886},
{0.799961,0.550766},
{0.756236,0.549869},
{0.719775,0.504684},
{0.721424,0.550654},
{0.742076,0.596061},
{0.780509,0.598988},
{0.821741,0.602183},
{0.867895,0.555171},
{0.706531,0.458963},
{0.678496,0.466823},
{0.689913,0.508753},
{0.690651,0.551249},
{0.679867,0.590834},
{0.70924,0.593673},
{0.686315,0.633197},
{0.713853,0.637506},
{0.744701,0.643579},
{0.775588,0.649195},
{0.660359,0.427931},
{0.636533,0.440222},
{0.652084,0.474603},
{0.660645,0.512345},
{0.660972,0.550609},
{0.651823,0.586558},
{0.635405,0.619817},
{0.659324,0.626873},
{0.632838,0.661109},
{0.655741,0.668682},
{0.680516,0.675754},
{0.705038,0.685349},
{0.729435,0.696206},
{0.663942,0.718476},
{0.683282,0.743218},
{0.643709,0.705719},
{0.62265,0.697915},
{0.608152,0.726337},
{0.623833,0.73714},
{0.639363,0.749517},
{0.599499,0.692522},
{0.592174,0.673634},
{0.574935,0.687182},
{0.57465,0.70053},
{0.57679,0.714249},
{0.592169,0.718684},
{0.562705,0.733153},
{0.573362,0.739304},
{0.584325,0.7475},
{0.595445,0.755816},
{0.615481,0.411552},
{0.635155,0.395324},
{0.605656,0.371247},
{0.590418,0.390945},
{0.576095,0.411723},
{0.596659,0.428897},
{0.613544,0.452805},
{0.624682,0.483172},
{0.632247,0.515633},
{0.631809,0.549263},
{0.625095,0.581804},
{0.611779,0.61096},
{0.596766,0.638034},
{0.613926,0.650011},
{0.581016,0.659173},
{0.567961,0.674432},
{0.557076,0.683821},
{0.561469,0.694145},
{0.560226,0.703629},
{0.562917,0.713102},
{0.552849,0.727376},
{0.600541,0.489989},
{0.604998,0.518791},
{0.604993,0.54881},
{0.599672,0.577531},
{0.590542,0.60414},
{0.579114,0.627823},
{0.567527,0.647891},
{0.579768,0.548281},
{0.576226,0.574058},
{0.570038,0.598071},
{0.561803,0.61997},
{0.553377,0.639199},
{0.546408,0.655462},
{0.557919,0.663651},
{0.549798,0.675429},
{0.542671,0.68355},
{0.547999,0.690908},
{0.551033,0.698011},
{0.549908,0.704857},
{0.551318,0.712936},
{0.544212,0.723732},
{0.527309,0.737516},
{0.53266,0.74349},
{0.538693,0.749461},
{0.545033,0.755717},
{0.551526,0.762116},
{0.579857,0.52135},
{0.577437,0.495493},
{0.55642,0.498363},
{0.557786,0.522844},
{0.557787,0.547779},
{0.555431,0.571704},
{0.551221,0.594254},
{0.545661,0.615063},
{0.539884,0.633889},
{0.535025,0.650489},
{0.531045,0.664525},
{0.540765,0.668485},
{0.535742,0.677835},
{0.532576,0.683825},
{0.535629,0.688988},
{0.539312,0.695529},
{0.542073,0.70084},
{0.54315,0.704818},
{0.542762,0.711444},
{0.536715,0.719672},
{0.523012,0.731252},
{0.500566,0.734235},
{0.500566,0.746207},
{0.502326,0.751759},
{0.504087,0.757311},
{0.505847,0.762863},
{0.507607,0.768415},
{0.580404,0.445308},
{0.592482,0.464921},
{0.569619,0.457671},
{0.572982,0.473583},
{0.55468,0.475802},
{0.536851,0.475126},
{0.537255,0.499345},
{0.537799,0.52361},
{0.537925,0.547336},
{0.536404,0.570333},
{0.533729,0.591919},
{0.530301,0.612338},
{0.526847,0.63101},
{0.523644,0.647856},
{0.52124,0.662398},
{0.519307,0.675334},
{0.527906,0.675658},
{0.526511,0.684764},
{0.527766,0.692715},
{0.530373,0.699396},
{0.533035,0.70469},
{0.536812,0.708679},
{0.531139,0.716901},
{0.519521,0.725323},
{0.500564,0.727113},
{0.47812,0.731252},
{0.473823,0.737516},
{0.468471,0.74349},
{0.498806,0.751759},
{0.462439,0.749461},
{0.497045,0.757311},
{0.456099,0.755717},
{0.495285,0.762863},
{0.493525,0.768415},
{0.449606,0.762116},
{0.416806,0.7475},
{0.405687,0.755816},
{0.377299,0.73714},
{0.361769,0.749517},
{0.33719,0.718476},
{0.31785,0.743218},
{0.296094,0.685349},
{0.271697,0.696206},
{0.256431,0.643579},
{0.225544,0.649195},
{0.220623,0.598988},
{0.17939,0.602183},
{0.201171,0.550766},
{0.133237,0.555171},
{0.210576,0.498107},
{0.169956,0.495836},
{0.236993,0.444033},
{0.206674,0.4365},
{0.268574,0.39157},
{0.243393,0.377165},
{0.30582,0.346943},
{0.280111,0.31783},
{0.349233,0.316376},
{0.332736,0.296419},
{0.396276,0.293983},
{0.385361,0.275008},
{0.444414,0.27388},
{0.437986,0.253597},
{0.493099,0.254922},
{0.490611,0.232187},
{0.492119,0.203234},
{0.492583,0.201244},
{0.49544,0.2024},
{0.497469,0.203135},
{0.499281,0.201688},
{0.500461,0.199494},
{0.501588,0.199533},
{0.503063,0.199116},
{0.504691,0.198616},
{0.50716,0.197166},
{0.506726,0.194922},
{0.509378,0.192435},
{0.512673,0.18881},
{0.519043,0.187343},
{0.526983,0.186445},
{0.536745,0.186103},
{0.548392,0.186299},
{0.557105,0.180837},
{0.565315,0.174776},
{0.572571,0.168217},
{0.579036,0.161269},
{0.573149,0.15548},
{0.579033,0.148783},
{0.573226,0.143414},
{0.573298,0.131927},
{0.567844,0.12659},
{0.568032,0.115726},
{0.490356,0.206553},
{0.491452,0.205077},
{0.494396,0.205888},
{0.495064,0.204196},
{0.497175,0.204922},
{0.498704,0.205404},
{0.49907,0.203548},
{0.500467,0.203698},
{0.500467,0.201729},
{0.501652,0.201688},
{0.503091,0.201377},
{0.505036,0.200605},
{0.507704,0.199278},
{0.51131,0.197299},
{0.510328,0.194867},
{0.51447,0.191402},
{0.521025,0.19094},
{0.529292,0.190815},
{0.539625,0.191063},
{0.541987,0.196051},
{0.551606,0.191964},
{0.561484,0.187272},
{0.570495,0.181459},
{0.578299,0.174535},
{0.584731,0.16686},
{0.590733,0.159057},
{0.584869,0.154041},
{0.590301,0.146691},
{0.584546,0.141966},
{0.57888,0.13707},
{0.578783,0.125877},
{0.573338,0.120906},
{0.573053,0.110261},
{0.842628,0.735578},
{0.838088,0.728518},
{0.84212,0.728214},
{0.846733,0.735225},
{0.846094,0.727849},
{0.83398,0.728757},
{0.83846,0.735886},
{0.843209,0.743177},
{0.847441,0.742802},
{0.851622,0.742364},
{0.850785,0.734784},
{0.850026,0.727428},
{0.853936,0.726947},
{0.857841,0.726402},
{0.861739,0.725801},
{0.865629,0.725152},
{0.869506,0.724447},
{0.873367,0.723675},
{0.87721,0.722853},
{0.881034,0.721995},
{0.884831,0.721099},
{0.888594,0.720161},
{0.892321,0.719195},
{0.896012,0.718211},
{0.899654,0.717207},
{0.903238,0.716182},
{0.905131,0.722906},
{0.907349,0.729656},
{0.909866,0.736401},
{0.91266,0.743113},
{0.915698,0.749788},
{0.918948,0.756423},
{0.92234,0.762989},
{0.925806,0.769457},
{0.929289,0.775876},
{0.932734,0.782295},
{0.93609,0.788677},
{0.939309,0.794987},
{0.942355,0.801277},
{0.945191,0.8076},
{0.947807,0.813923},
{0.950192,0.820213},
{0.952316,0.826503},
{0.954149,0.832828},
{0.955676,0.839156},
{0.956885,0.845459},
{0.957718,0.851728},
{0.958117,0.857959},
{0.958149,0.86414},
{0.957879,0.870263},
{0.957329,0.876297},
{0.956517,0.882208},
{0.95547,0.888026},
{0.954214,0.893778},
{0.952744,0.899437},
{0.951057,0.904978},
{0.949167,0.910438},
{0.947085,0.915854},
{0.94482,0.921197},
{0.942378,0.926435},
{0.939767,0.931605},
{0.936996,0.936745},
{0.934084,0.941826},
{0.931049,0.946823},
{0.927902,0.951764},
{0.924654,0.956674},
{0.921328,0.961544},
{0.917948,0.966364},
{0.914532,0.971134},
{0.911099,0.975858},
{0.907657,0.980559},
{0.908059,0.973727},
{0.904949,0.978378},
{0.904927,0.971807},
{0.902002,0.976692},
{0.901741,0.970034},
{0.899056,0.975006},
{0.898541,0.968344},
{0.89611,0.973319},
{0.895335,0.966802},
{0.893163,0.971633},
{0.892129,0.965471},
{0.890197,0.970467},
{0.888939,0.964285},
{0.887231,0.9693},
{0.885781,0.963181},
{0.884265,0.968133},
{0.882702,0.962237},
{0.881299,0.966966},
{0.87975,0.961532},
{0.878605,0.966431},
{0.876886,0.960997},
{0.875911,0.965896},
{0.874072,0.96056},
{0.873217,0.965361},
{0.871355,0.960314},
{0.870523,0.964826},
{0.868783,0.960352},
{0.868241,0.964972},
{0.866291,0.960593},
{0.86596,0.965117},
{0.863816,0.960952},
{0.863679,0.965262},
{0.861374,0.961509},
{0.861398,0.965407},
{0.858984,0.962346},
{0.859354,0.966176},
{0.856617,0.963353},
{0.857309,0.966946},
{0.854245,0.964421},
{0.855265,0.967715},
{0.851872,0.96552},
{0.853221,0.968484},
{0.858839,0.733733},
{0.862863,0.733126},
{0.866859,0.732444},
{0.870845,0.731717},
{0.874804,0.730918},
{0.878749,0.730074},
{0.882648,0.72917},
{0.886521,0.72823},
{0.890349,0.727233},
{0.894147,0.7262},
{0.897865,0.725132},
{0.901537,0.724037},
{0.903703,0.730919},
{0.906149,0.737808},
{0.908799,0.744681},
{0.911672,0.751524},
{0.914716,0.75834},
{0.917861,0.76506},
{0.921048,0.771678},
{0.924223,0.778208},
{0.92734,0.78473},
{0.930336,0.791154},
{0.933205,0.797495},
{0.935876,0.803748},
{0.938335,0.810009},
{0.940572,0.816196},
{0.942607,0.822347},
{0.944387,0.828419},
{0.945889,0.834492},
{0.947131,0.84051},
{0.948105,0.846515},
{0.94878,0.852438},
{0.949095,0.858309},
{0.949137,0.864121},
{0.948916,0.869905},
{0.948485,0.875601},
{0.947824,0.88119},
{0.946981,0.886722},
{0.945937,0.892206},
{0.944729,0.897635},
{0.943329,0.902957},
{0.941752,0.908251},
{0.939996,0.913501},
{0.938079,0.918733},
{0.935998,0.923876},
{0.933749,0.929008},
{0.931353,0.934102},
{0.92881,0.939196},
{0.926142,0.94422},
{0.92334,0.949232},
{0.920444,0.954195},
{0.917436,0.959155},
{0.914351,0.964066},
{0.91121,0.968934},
{0.907831,0.966902},
{0.904381,0.965076},
{0.900942,0.963352},
{0.897474,0.961827},
{0.894027,0.960459},
{0.890606,0.959286},
{0.887254,0.958213},
{0.883993,0.957335},
{0.880855,0.956621},
{0.877826,0.956138},
{0.874884,0.955761},
{0.872031,0.955661},
{0.869279,0.955767},
{0.866572,0.956204},
{0.863916,0.956709},
{0.86125,0.957563},
{0.858595,0.95861},
{0.855912,0.95991},
{0.853228,0.961187},
{0.850523,0.962556},
{0.849174,0.959592},
{0.852214,0.958074},
{0.847826,0.956628},
{0.851304,0.955381},
{0.847258,0.955575},
{0.850598,0.953406},
{0.846691,0.954523},
{0.849945,0.951857},
{0.846124,0.953471},
{0.849198,0.950442},
{0.845557,0.952418},
{0.848187,0.949023},
{0.844044,0.95069},
{0.846742,0.94746},
{0.842532,0.948962},
{0.84503,0.945833},
{0.841019,0.947233},
{0.84322,0.94422},
{0.839507,0.945505},
{0.84136,0.942613},
{0.845321,0.941126},
{0.843214,0.93972},
{0.847222,0.937871},
{0.845067,0.936827},
{0.848525,0.934141},
{0.846921,0.933934},
{0.848831,0.929619},
{0.846389,0.929159},
{0.848477,0.924677},
{0.845857,0.924384},
{0.847796,0.919688},
{0.845325,0.919608},
{0.846593,0.914982},
{0.844793,0.914833},
{0.84467,0.910889},
{0.842398,0.911608},
{0.842268,0.907257},
{0.840002,0.908382},
{0.839622,0.903933},
{0.837607,0.905157},
{0.836617,0.901244},
{0.835211,0.901932},
{0.833136,0.899518},
{0.831837,0.901},
{0.829358,0.898371},
{0.828463,0.900068},
{0.825464,0.897418},
{0.825089,0.899135},
{0.821512,0.896564},
{0.821714,0.898203},
{0.854815,0.734294},
{0.855776,0.741859},
{0.859923,0.741282},
{0.86406,0.740641},
{0.868183,0.739944},
{0.872284,0.739183},
{0.876357,0.738349},
{0.8804,0.737452},
{0.884411,0.736504},
{0.888381,0.735497},
{0.8923,0.734426},
{0.896165,0.733301},
{0.899971,0.732133},
{0.902305,0.739169},
{0.904841,0.746198},
{0.907546,0.753199},
{0.910388,0.760155},
{0.913303,0.767021},
{0.916231,0.773755},
{0.919123,0.780392},
{0.921931,0.786965},
{0.924616,0.793433},
{0.927141,0.799755},
{0.929481,0.805977},
{0.931613,0.812146},
{0.933536,0.818231},
{0.93525,0.8242},
{0.936737,0.830086},
{0.937977,0.835925},
{0.938984,0.841701},
{0.939769,0.847401},
{0.940304,0.853032},
{0.940556,0.858604},
{0.940576,0.864124},
{0.94041,0.869596},
{0.94006,0.875006},
{0.939528,0.880337},
{0.938835,0.885619},
{0.937999,0.89088},
{0.937011,0.896096},
{0.935861,0.901242},
{0.934553,0.906358},
{0.933095,0.911483},
{0.931486,0.91659},
{0.929726,0.921651},
{0.927816,0.926702},
{0.925754,0.931777},
{0.923554,0.93685},
{0.921226,0.941893},
{0.91877,0.946923},
{0.916187,0.951958},
{0.913491,0.956976},
{0.910695,0.961958},
{0.906999,0.960043},
{0.903278,0.958325},
{0.899557,0.956788},
{0.895857,0.955416},
{0.892207,0.95422},
{0.88864,0.953213},
{0.885187,0.952375},
{0.881881,0.951686},
{0.878697,0.951199},
{0.875611,0.950967},
{0.872611,0.950986},
{0.869687,0.951249},
{0.866807,0.951781},
{0.863941,0.952603},
{0.861069,0.953701},
{0.858168,0.955063},
{0.855223,0.956563},
{0.847165,0.18888},
{0.844596,0.193799},
{0.842036,0.198713},
{0.839492,0.203624},
{0.836974,0.208525},
{0.834488,0.213408},
{0.832041,0.218274},
{0.829638,0.223122},
{0.827278,0.227947},
{0.824961,0.232743},
{0.822692,0.237506},
{0.820477,0.242229},
{0.818308,0.246909},
{0.816177,0.25154},
{0.814088,0.25611},
{0.812046,0.260607},
{0.810057,0.264981},
{0.808131,0.269185},
{0.806234,0.273303},
{0.835233,0.18909},
{0.832689,0.194016},
{0.830165,0.198957},
{0.827663,0.203903},
{0.825215,0.208837},
{0.822805,0.213764},
{0.820446,0.21868},
{0.818128,0.223588},
{0.815881,0.228451},
{0.813682,0.233291},
{0.81155,0.238089},
{0.809465,0.24286},
{0.807454,0.247542},
{0.805491,0.252174},
{0.803596,0.256722},
{0.801776,0.26112},
{0.800059,0.265244},
{0.798562,0.2687},
{0.837793,0.184172},
{0.828442,0.179392},
{0.825855,0.184328},
{0.823291,0.189293},
{0.820757,0.194285},
{0.818262,0.199293},
{0.815816,0.204306},
{0.813425,0.20932},
{0.811094,0.21433},
{0.808825,0.219327},
{0.80662,0.224304},
{0.804485,0.229251},
{0.80243,0.23416},
{0.800449,0.239022},
{0.798539,0.243831},
{0.796706,0.248569},
{0.794959,0.253221},
{0.793295,0.257742},
{0.791712,0.262086},
{0.79017,0.266341},
{0.783205,0.259428},
{0.781778,0.263982},
{0.774654,0.256988},
{0.773385,0.261623},
{0.766075,0.255016},
{0.764993,0.259264},
{0.757482,0.253761},
{0.756518,0.258923},
{0.748901,0.252937},
{0.748044,0.258581},
{0.740356,0.252257},
{0.73957,0.25824},
{0.731891,0.251775},
{0.731095,0.257899},
{0.722869,0.258262},
{0.723552,0.251546},
{0.714642,0.258624},
{0.715309,0.251457},
{0.706415,0.258987},
{0.707131,0.251394},
{0.698188,0.25935},
{0.699056,0.251297},
{0.690249,0.259422},
{0.691121,0.251104},
{0.682309,0.259493},
{0.683286,0.250841},
{0.674369,0.259564},
{0.675512,0.250533},
{0.667833,0.250071},
{0.666429,0.259635},
{0.660282,0.249344},
{0.658792,0.258919},
{0.6528,0.248453},
{0.651156,0.258203},
{0.645326,0.247501},
{0.643519,0.257486},
{0.637807,0.246384},
{0.635882,0.25677},
{0.63019,0.245001},
{0.628001,0.255218},
{0.622532,0.243442},
{0.62012,0.253666},
{0.61489,0.241797},
{0.612239,0.252114},
{0.607474,0.239965},
{0.604358,0.250562},
{0.600492,0.237844},
{0.597932,0.24831},
{0.593542,0.235615},
{0.591505,0.246058},
{0.586224,0.233462},
{0.585078,0.243806},
{0.577441,0.231331},
{0.578652,0.241554},
{0.565214,0.238132},
{0.566098,0.22917},
{0.553508,0.227006},
{0.551776,0.234709},
{0.540983,0.224864},
{0.538338,0.231286},
{0.529941,0.222552},
{0.5249,0.227863},
{0.5218,0.219882},
{0.519316,0.223887},
{0.515517,0.216995},
{0.513732,0.219912},
{0.510048,0.214036},
{0.508148,0.215937},
{0.505961,0.211316},
{0.502565,0.211961},
{0.503829,0.209149},
{0.50204,0.209895},
{0.502851,0.207267},
{0.501516,0.20783},
{0.502229,0.205404},
{0.500991,0.205764},
{0.501863,0.203548},
{0.86387,0.948739},
{0.860797,0.950156},
{0.857699,0.951839},
{0.854535,0.953669},
{0.866923,0.947674},
{0.869996,0.94684},
{0.866935,0.943724},
{0.86368,0.945226},
{0.86043,0.947027},
{0.857182,0.949071},
{0.853914,0.951237},
{0.87309,0.946368},
{0.870196,0.942578},
{0.866775,0.939955},
{0.863329,0.941809},
{0.85985,0.944041},
{0.856515,0.946554},
{0.853178,0.949206},
{0.876244,0.946188},
{0.879478,0.946329},
{0.882808,0.946732},
{0.880146,0.941427},
{0.876778,0.941433},
{0.873474,0.941808},
{0.886275,0.947384},
{0.889918,0.948184},
{0.891064,0.943129},
{0.887239,0.94236},
{0.883617,0.941764},
{0.880708,0.936678},
{0.877206,0.936703},
{0.873745,0.93732},
{0.870292,0.938359},
{0.893697,0.949176},
{0.897582,0.950348},
{0.899166,0.945264},
{0.895052,0.944091},
{0.896281,0.939109},
{0.892081,0.938104},
{0.888092,0.937393},
{0.88431,0.936832},
{0.881163,0.931777},
{0.877527,0.932},
{0.873921,0.932737},
{0.870285,0.934075},
{0.866582,0.935935},
{0.901533,0.951724},
{0.903369,0.946635},
{0.905067,0.941587},
{0.900617,0.940202},
{0.901943,0.935201},
{0.897369,0.934057},
{0.892971,0.933166},
{0.888796,0.932487},
{0.884889,0.931982},
{0.881533,0.927053},
{0.877765,0.927292},
{0.874015,0.928118},
{0.870209,0.929589},
{0.866275,0.931574},
{0.862237,0.934032},
{0.862774,0.938235},
{0.859048,0.940958},
{0.855593,0.944085},
{0.852334,0.947338},
{0.905518,0.95327},
{0.907625,0.948192},
{0.909603,0.943121},
{0.911453,0.938087},
{0.90665,0.936557},
{0.908103,0.931585},
{0.903147,0.930257},
{0.89836,0.929164},
{0.893752,0.928306},
{0.889408,0.927677},
{0.885371,0.927196},
{0.881814,0.922288},
{0.877947,0.92255},
{0.874072,0.92334},
{0.870097,0.924761},
{0.866045,0.92662},
{0.861941,0.928728},
{0.858026,0.930293},
{0.857635,0.937018},
{0.85416,0.94191},
{0.85109,0.945581},
{0.9095,0.955028},
{0.911906,0.949958},
{0.914152,0.94496},
{0.916322,0.939846},
{0.91833,0.934824},
{0.913176,0.933075},
{0.91477,0.928072},
{0.909432,0.926626},
{0.904234,0.925364},
{0.89922,0.924318},
{0.894436,0.923517},
{0.889935,0.922912},
{0.885769,0.922456},
{0.88606,0.917794},
{0.881986,0.917714},
{0.878026,0.917811},
{0.873996,0.918543},
{0.869872,0.91974},
{0.865627,0.921337},
{0.861571,0.92294},
{0.857705,0.924203},
{0.854299,0.924789},
{0.854542,0.93052},
{0.853865,0.935861},
{0.85196,0.940277},
{0.849395,0.94405},
{0.92022,0.929768},
{0.921964,0.924828},
{0.916238,0.923105},
{0.910647,0.921741},
{0.905207,0.920541},
{0.900015,0.91964},
{0.895009,0.918819},
{0.890378,0.918254},
{0.890633,0.913705},
{0.886219,0.913242},
{0.882048,0.912995},
{0.877956,0.913116},
{0.873804,0.913658},
{0.869455,0.914675},
{0.865071,0.915954},
{0.860813,0.917284},
{0.856874,0.918441},
{0.853443,0.919203},
{0.851214,0.924809},
{0.85148,0.930074},
{0.85094,0.93486},
{0.849483,0.938995},
{0.847357,0.942508},
{0.850443,0.919607},
{0.849097,0.914612},
{0.847179,0.910091},
{0.844798,0.906095},
{0.841913,0.902516},
{0.838565,0.899665},
{0.834579,0.89775},
{0.830279,0.896489},
{0.825818,0.895611},
{0.821309,0.894924},
{0.601251,0.0625841},
{0.60756,0.064835},
{0.613649,0.0670158},
{0.619817,0.0692574},
{0.625771,0.0714462},
{0.631691,0.0736679},
{0.637429,0.0758531},
{0.64321,0.0781294},
{0.648839,0.080388},
{0.654441,0.0827113},
{0.659962,0.0850423},
{0.665483,0.0874817},
{0.67096,0.0899496},
{0.676425,0.0925062},
{0.681925,0.09513},
{0.687394,0.0978601},
{0.692937,0.100682},
{0.698495,0.103612},
{0.704206,0.106685},
{0.709878,0.109848},
{0.715743,0.11318},
{0.721671,0.116636},
{0.727865,0.120311},
{0.734048,0.124051},
{0.740544,0.128026},
{0.747172,0.132127},
{0.754173,0.136475},
{0.761222,0.140857},
{0.768683,0.145461},
{0.776356,0.150151},
{0.784455,0.154998},
{0.792657,0.159836},
{0.801275,0.164755},
{0.810113,0.169659},
{0.819245,0.174548},
{0.598748,0.0689076},
{0.604914,0.0714407},
{0.610988,0.0739294},
{0.616926,0.0763641},
{0.622773,0.0787702},
{0.62857,0.0811734},
{0.634282,0.0835615},
{0.639877,0.0859227},
{0.645401,0.0882872},
{0.650905,0.0906854},
{0.65637,0.0931065},
{0.661778,0.0955397},
{0.667164,0.098012},
{0.672563,0.10055},
{0.677981,0.103151},
{0.683425,0.105811},
{0.688909,0.108549},
{0.694447,0.111383},
{0.700071,0.114322},
{0.705813,0.117375},
{0.711671,0.120549},
{0.717639,0.123848},
{0.723773,0.127293},
{0.730125,0.130905},
{0.73668,0.134671},
{0.743419,0.13858},
{0.750407,0.142651},
{0.757707,0.146901},
{0.765288,0.151297},
{0.773117,0.155804},
{0.78124,0.160421},
{0.789703,0.165148},
{0.798444,0.169935},
{0.807402,0.174734},
{0.816549,0.179534},
{0.59594,0.0751115},
{0.601997,0.0779332},
{0.607939,0.0806718},
{0.61379,0.0833517},
{0.619528,0.0859631},
{0.625246,0.0885541},
{0.630868,0.0910942},
{0.636394,0.0935884},
{0.641836,0.0960517},
{0.64728,0.0985349},
{0.652689,0.101015},
{0.658044,0.103481},
{0.663375,0.105962},
{0.668733,0.108496},
{0.674129,0.111077},
{0.679538,0.113685},
{0.685001,0.116356},
{0.690524,0.119107},
{0.696167,0.12196},
{0.701904,0.124889},
{0.707787,0.127932},
{0.713781,0.13108},
{0.719986,0.13438},
{0.726378,0.137809},
{0.733017,0.141396},
{0.739833,0.145106},
{0.746948,0.148993},
{0.754337,0.153032},
{0.762051,0.157237},
{0.769993,0.161544},
{0.778263,0.165985},
{0.786829,0.170537},
{0.795696,0.175187},
{0.804737,0.179864},
{0.813952,0.184571},
{0.592912,0.0812308},
{0.598848,0.0843363},
{0.604709,0.0873508},
{0.610455,0.0902618},
{0.616126,0.0930918},
{0.621763,0.0958632},
{0.62733,0.0985658},
{0.632793,0.101189},
{0.638198,0.103766},
{0.643593,0.106328},
{0.64896,0.108866},
{0.654281,0.111372},
{0.659593,0.113875},
{0.664928,0.116403},
{0.670296,0.118956},
{0.675702,0.12153},
{0.681163,0.124145},
{0.686693,0.126822},
{0.692328,0.129571},
{0.6981,0.132402},
{0.704007,0.135321},
{0.710049,0.138336},
{0.716279,0.141469},
{0.722753,0.144743},
{0.729454,0.148149},
{0.736365,0.151679},
{0.743548,0.155358},
{0.751062,0.159212},
{0.758871,0.163212},
{0.76694,0.167333},
{0.775304,0.171584},
{0.783996,0.175975},
{0.792945,0.180467},
{0.802081,0.185024},
{0.811364,0.189633},
{0.808873,0.194747},
{0.806388,0.199843},
{0.804008,0.204982},
{0.801676,0.210095},
{0.799447,0.215254},
{0.797268,0.220328},
{0.795196,0.225435},
{0.793202,0.230464},
{0.791311,0.235528},
{0.789501,0.240427},
{0.7878,0.245341},
{0.786194,0.250119},
{0.784669,0.254866},
{0.775966,0.252281},
{0.767239,0.250178},
{0.758501,0.248531},
{0.749854,0.247294},
{0.741203,0.246249},
{0.732712,0.245454},
{0.724305,0.244817},
{0.716106,0.244313},
{0.707919,0.243831},
{0.699951,0.243364},
{0.692068,0.242832},
{0.684394,0.242252},
{0.676721,0.241578},
{0.669245,0.240804},
{0.661834,0.239855},
{0.654547,0.238799},
{0.647206,0.237604},
{0.639884,0.236319},
{0.632457,0.234867},
{0.625041,0.233284},
{0.617567,0.231546},
{0.610272,0.22961},
{0.603127,0.227438},
{0.595703,0.225162},
{0.587701,0.22298},
{0.578263,0.221169},
{0.567074,0.220114},
{0.554945,0.219333},
{0.543119,0.218537},
{0.532496,0.217432},
{0.523872,0.215922},
{0.517303,0.214067},
{0.511852,0.212091},
{0.508087,0.210138},
{0.505734,0.208331},
{0.504629,0.206601},
{0.503758,0.204922},
{0.503464,0.203135},
{0.505493,0.2024},
{0.50835,0.201244},
{0.512192,0.199701},
{0.51707,0.197482},
{0.515775,0.194556},
{0.522695,0.194617},
{0.531353,0.195032},
{0.533036,0.199125},
{0.533899,0.203378},
{0.543606,0.201171},
{0.554323,0.198161},
{0.565561,0.194261},
{0.57596,0.188794},
{0.584163,0.181085},
{0.590831,0.172325},
{0.596628,0.163704},
{0.601895,0.155293},
{0.596086,0.151152},
{0.601269,0.143416},
{0.59556,0.13938},
{0.589891,0.135097},
{0.584299,0.130601},
{0.583852,0.119571},
{0.578455,0.115064},
{0.577679,0.104668},
{0.589573,0.0872298},
{0.595413,0.0906437},
{0.601084,0.0938815},
{0.606858,0.0970943},
{0.612461,0.100143},
{0.618058,0.103111},
{0.623505,0.105947},
{0.62902,0.108744},
{0.634407,0.11144},
{0.639791,0.114086},
{0.645111,0.116677},
{0.650464,0.11924},
{0.655786,0.121776},
{0.661125,0.1243},
{0.666515,0.126842},
{0.671917,0.129374},
{0.67741,0.13195},
{0.682956,0.134552},
{0.688682,0.137243},
{0.694422,0.139945},
{0.700388,0.14276},
{0.706467,0.145637},
{0.712858,0.148673},
{0.71929,0.151737},
{0.726083,0.154981},
{0.73306,0.158323},
{0.740459,0.161873},
{0.747938,0.165465},
{0.755862,0.169273},
{0.764016,0.173191},
{0.772593,0.17731},
{0.78126,0.181472},
{0.790293,0.185808},
{0.79949,0.190223},
{0.797025,0.195475},
{0.79464,0.200747},
{0.79229,0.206004},
{0.79003,0.211266},
{0.787914,0.21655},
{0.785901,0.221817},
{0.783948,0.227026},
{0.782103,0.232198},
{0.780414,0.237353},
{0.778846,0.242446},
{0.777363,0.247427},
{0.585926,0.0931346},
{0.591644,0.0968493},
{0.597328,0.100429},
{0.602936,0.103849},
{0.608503,0.107134},
{0.614066,0.110308},
{0.619585,0.113357},
{0.625023,0.116271},
{0.630422,0.119083},
{0.635826,0.12183},
{0.641214,0.124508},
{0.646564,0.127115},
{0.651914,0.129673},
{0.657298,0.132209},
{0.662719,0.134731},
{0.668183,0.13725},
{0.673708,0.139776},
{0.679313,0.142321},
{0.685032,0.144905},
{0.690894,0.147548},
{0.696903,0.150249},
{0.703058,0.153008},
{0.709416,0.155856},
{0.71603,0.15882},
{0.722885,0.161891},
{0.72996,0.16506},
{0.737319,0.168358},
{0.745021,0.171818},
{0.753022,0.175419},
{0.761279,0.179141},
{0.769821,0.183007},
{0.778679,0.18704},
{0.787773,0.191207},
{0.58194,0.0989315},
{0.587559,0.102982},
{0.593145,0.106859},
{0.598716,0.110574},
{0.604245,0.114108},
{0.609815,0.117512},
{0.615342,0.120755},
{0.620822,0.12383},
{0.626255,0.126769},
{0.63172,0.129624},
{0.637171,0.132392},
{0.64259,0.135047},
{0.648001,0.137634},
{0.653457,0.140181},
{0.658961,0.142706},
{0.664488,0.145189},
{0.670081,0.147671},
{0.675753,0.150155},
{0.681563,0.152675},
{0.687483,0.155219},
{0.693569,0.157816},
{0.699791,0.16045},
{0.706252,0.163171},
{0.712927,0.165976},
{0.719873,0.168886},
{0.72702,0.171868},
{0.73449,0.174984},
{0.742255,0.178236},
{0.750354,0.181638},
{0.758675,0.185146},
{0.767304,0.188815},
{0.776207,0.192646},
{0.785366,0.196641},
{0.583179,0.109072},
{0.58871,0.113299},
{0.594226,0.117318},
{0.599756,0.121141},
{0.605332,0.124783},
{0.610908,0.128235},
{0.616437,0.131485},
{0.621955,0.134572},
{0.627497,0.137534},
{0.633037,0.140373},
{0.63855,0.143088},
{0.644064,0.145708},
{0.649612,0.148262},
{0.655196,0.150763},
{0.66082,0.153223},
{0.666504,0.155656},
{0.672265,0.158078},
{0.678138,0.160508},
{0.684156,0.162965},
{0.69032,0.16545},
{0.696633,0.167962},
{0.703151,0.170531},
{0.70993,0.173187},
{0.716949,0.175921},
{0.724193,0.178723},
{0.731718,0.181633},
{0.739585,0.184686},
{0.747745,0.18787},
{0.756151,0.191169},
{0.764828,0.19462},
{0.7738,0.198256},
{0.782982,0.202057},
{0.780717,0.207498},
{0.778608,0.212964},
{0.776632,0.218431},
{0.774711,0.223832},
{0.772927,0.22922},
{0.771318,0.234587},
{0.769863,0.239913},
{0.768498,0.245118},
{0.864144,0.910764},
{0.859657,0.911896},
{0.86289,0.905811},
{0.85809,0.906913},
{0.855538,0.913013},
{0.868802,0.90968},
{0.867865,0.904868},
{0.866802,0.90023},
{0.861414,0.901192},
{0.856167,0.902192},
{0.853751,0.908058},
{0.852042,0.913929},
{0.873389,0.908878},
{0.872757,0.904187},
{0.871977,0.899659},
{0.871271,0.895202},
{0.865769,0.895753},
{0.859933,0.896564},
{0.85394,0.897589},
{0.851489,0.903432},
{0.85016,0.909132},
{0.881948,0.908449},
{0.877722,0.908469},
{0.881708,0.903885},
{0.877308,0.903873},
{0.886247,0.908729},
{0.886145,0.904183},
{0.885955,0.899662},
{0.881367,0.899467},
{0.876796,0.899359},
{0.89079,0.909205},
{0.890835,0.90463},
{0.890842,0.900064},
{0.890695,0.89559},
{0.885721,0.895223},
{0.880998,0.894975},
{0.876265,0.894955},
{0.89578,0.909686},
{0.895994,0.905089},
{0.89612,0.900498},
{0.896184,0.895969},
{0.896235,0.891457},
{0.890604,0.891145},
{0.88551,0.890824},
{0.880682,0.890625},
{0.875807,0.890622},
{0.895454,0.914236},
{0.901164,0.910286},
{0.901548,0.905646},
{0.901932,0.901061},
{0.902112,0.896427},
{0.902362,0.891842},
{0.902531,0.887245},
{0.896324,0.886921},
{0.890585,0.886667},
{0.885394,0.886428},
{0.880465,0.886284},
{0.875515,0.886318},
{0.870649,0.890867},
{0.864934,0.891359},
{0.858754,0.892079},
{0.852159,0.892971},
{0.848608,0.898936},
{0.847748,0.904749},
{0.900621,0.914909},
{0.906815,0.911103},
{0.907427,0.906391},
{0.907945,0.901692},
{0.908406,0.897032},
{0.908803,0.892378},
{0.909126,0.887696},
{0.909412,0.883006},
{0.90282,0.882667},
{0.896432,0.882382},
{0.890663,0.882188},
{0.885325,0.88204},
{0.880318,0.882002},
{0.875301,0.882034},
{0.870272,0.886541},
{0.864466,0.886965},
{0.858198,0.887538},
{0.851571,0.888207},
{0.844918,0.888566},
{0.844689,0.894078},
{0.844753,0.900715},
{0.906072,0.915803},
{0.912723,0.912125},
{0.91356,0.90732},
{0.914303,0.902543},
{0.914969,0.897787},
{0.91555,0.893049},
{0.916008,0.888265},
{0.916409,0.883471},
{0.916775,0.878682},
{0.909696,0.878329},
{0.902916,0.878053},
{0.896537,0.877862},
{0.890629,0.877739},
{0.885259,0.877667},
{0.880164,0.877666},
{0.875078,0.877758},
{0.869976,0.882237},
{0.864206,0.882573},
{0.857968,0.883003},
{0.85159,0.883418},
{0.845162,0.883668},
{0.838897,0.883597},
{0.838571,0.888209},
{0.837813,0.892296},
{0.841,0.897458},
{0.911746,0.916905},
{0.918803,0.913323},
{0.919878,0.90843},
{0.920837,0.903547},
{0.921703,0.898695},
{0.922456,0.893839},
{0.923074,0.888943},
{0.923594,0.884025},
{0.924054,0.879107},
{0.924417,0.874163},
{0.917085,0.873883},
{0.909941,0.873639},
{0.903122,0.873449},
{0.89664,0.873336},
{0.890647,0.873282},
{0.885169,0.873269},
{0.879957,0.873307},
{0.874782,0.873427},
{0.869767,0.877934},
{0.863998,0.878184},
{0.857906,0.878463},
{0.85163,0.878725},
{0.845315,0.878897},
{0.839104,0.878909},
{0.832981,0.878831},
{0.832811,0.883364},
{0.832492,0.887663},
{0.832004,0.891376},
{0.83631,0.89541},
{0.917587,0.918201},
{0.925058,0.914802},
{0.926388,0.909794},
{0.927606,0.904874},
{0.928652,0.899824},
{0.929594,0.89484},
{0.930384,0.889793},
{0.931103,0.884765},
{0.931611,0.879644},
{0.932053,0.874521},
{0.924648,0.86917},
{0.917271,0.869034},
{0.910109,0.868913},
{0.903239,0.868823},
{0.896739,0.868781},
{0.890654,0.868779},
{0.88503,0.868807},
{0.879664,0.868872},
{0.874351,0.868977},
{0.86943,0.873582},
{0.863705,0.873746},
{0.857674,0.873899},
{0.851543,0.874069},
{0.845318,0.874175},
{0.839145,0.874181},
{0.833014,0.874129},
{0.826952,0.874073},
{0.826925,0.878731},
{0.826823,0.883233},
{0.826641,0.887459},
{0.826402,0.891044},
{0.831186,0.894241},
{0.923583,0.91976},
{0.93233,0.869348},
{0.924763,0.864134},
{0.917379,0.864141},
{0.910216,0.864158},
{0.903418,0.864169},
{0.896819,0.864203},
{0.890681,0.864245},
{0.88486,0.864307},
{0.879319,0.864379},
{0.873832,0.864465},
{0.868919,0.869096},
{0.863194,0.869205},
{0.857255,0.869303},
{0.851182,0.869393},
{0.845058,0.869449},
{0.838972,0.869448},
{0.832921,0.869416},
{0.826904,0.869378},
{0.826129,0.893624},
{0.589432,0.124015},
{0.594974,0.128145},
{0.60059,0.132084},
{0.606155,0.13575},
{0.611834,0.139256},
{0.617454,0.14253},
{0.623112,0.145613},
{0.628735,0.148555},
{0.634417,0.151307},
{0.640075,0.153967},
{0.645749,0.156506},
{0.65147,0.159017},
{0.657198,0.161399},
{0.66301,0.163787},
{0.668869,0.166127},
{0.674909,0.168509},
{0.680954,0.170823},
{0.687233,0.173199},
{0.693626,0.175574},
{0.700344,0.17804},
{0.707098,0.180485},
{0.714225,0.183045},
{0.721536,0.185651},
{0.729274,0.188408},
{0.737079,0.191192},
{0.74532,0.194159},
{0.753774,0.197231},
{0.762614,0.20052},
{0.771512,0.203888},
{0.769399,0.209561},
{0.76742,0.215236},
{0.765536,0.220871},
{0.763797,0.226488},
{0.762254,0.232108},
{0.760875,0.237682},
{0.759627,0.243163},
{0.606975,0.147168},
{0.612713,0.15066},
{0.618518,0.153915},
{0.62435,0.156947},
{0.630169,0.159772},
{0.635995,0.162431},
{0.641852,0.164963},
{0.647734,0.167398},
{0.653637,0.169765},
{0.65958,0.172074},
{0.665584,0.174337},
{0.671685,0.176579},
{0.677919,0.17883},
{0.684292,0.181078},
{0.690807,0.183317},
{0.69752,0.18558},
{0.704489,0.1879},
{0.711692,0.190269},
{0.719106,0.192677},
{0.726791,0.195166},
{0.734806,0.197778},
{0.743097,0.200508},
{0.751611,0.203351},
{0.760371,0.206354},
{0.607754,0.159086},
{0.602628,0.167909},
{0.613742,0.162543},
{0.596946,0.177163},
{0.590602,0.186923},
{0.598057,0.191104},
{0.603614,0.181113},
{0.608808,0.171601},
{0.619782,0.165704},
{0.582172,0.198081},
{0.568192,0.202045},
{0.579938,0.21061},
{0.593135,0.201499},
{0.601561,0.204377},
{0.605741,0.194257},
{0.610316,0.184377},
{0.615095,0.174851},
{0.621412,0.177727},
{0.625826,0.168555},
{0.631873,0.1712},
{0.637954,0.173688},
{0.644062,0.176076},
{0.650147,0.178346},
{0.656265,0.180564},
{0.662422,0.182722},
{0.66869,0.184866},
{0.675038,0.186985},
{0.681538,0.189103},
{0.68816,0.191185},
{0.695015,0.193286},
{0.702066,0.195417},
{0.709376,0.197592},
{0.716864,0.199779},
{0.724653,0.202045},
{0.732712,0.204414},
{0.741072,0.206906},
{0.749609,0.209497},
{0.758403,0.212266},
{0.623712,0.189763},
{0.617052,0.187232},
{0.61287,0.197013},
{0.619738,0.199452},
{0.626643,0.201658},
{0.630299,0.192071},
{0.627747,0.180324},
{0.634086,0.182736},
{0.64042,0.185004},
{0.64674,0.187171},
{0.65306,0.189261},
{0.659397,0.191297},
{0.665794,0.1933},
{0.672297,0.19529},
{0.678918,0.197253},
{0.685671,0.199173},
{0.692609,0.201084},
{0.699788,0.20302},
{0.707183,0.204974},
{0.71477,0.206935},
{0.722606,0.208952},
{0.730746,0.211073},
{0.739134,0.213301},
{0.747714,0.215637},
{0.756508,0.218141},
{0.754894,0.224075},
{0.7533,0.229898},
{0.751999,0.235758},
{0.750827,0.241532},
{0.609084,0.207007},
{0.616123,0.209355},
{0.623261,0.211456},
{0.630455,0.213368},
{0.633539,0.203679},
{0.63694,0.19425},
{0.856622,0.864693},
{0.850663,0.864737},
{0.856012,0.860116},
{0.850103,0.860142},
{0.844643,0.864762},
{0.86255,0.864626},
{0.861858,0.860074},
{0.861247,0.855588},
{0.855471,0.855637},
{0.849621,0.855649},
{0.844192,0.86015},
{0.838673,0.864752},
{0.867019,0.855533},
{0.866617,0.851134},
{0.860846,0.851209},
{0.855089,0.851263},
{0.849331,0.851297},
{0.843805,0.855654},
{0.838336,0.860136},
{0.832732,0.864744},
{0.86762,0.860017},
{0.868277,0.864547},
{0.873275,0.859948},
{0.872772,0.855461},
{0.872417,0.851036},
{0.872156,0.846616},
{0.866363,0.846749},
{0.86059,0.846868},
{0.854896,0.846939},
{0.849177,0.84701},
{0.843594,0.851312},
{0.838049,0.85564},
{0.832514,0.860113},
{0.826812,0.8647},
{0.878926,0.859872},
{0.878585,0.855375},
{0.878288,0.850914},
{0.878076,0.846411},
{0.877818,0.8419},
{0.871935,0.842143},
{0.866144,0.842338},
{0.860415,0.842496},
{0.854738,0.84262},
{0.849101,0.842713},
{0.843514,0.847041},
{0.837899,0.851306},
{0.832339,0.855635},
{0.826706,0.860094},
{0.820904,0.864697},
{0.884677,0.859793},
{0.884482,0.855276},
{0.884272,0.850764},
{0.884051,0.846218},
{0.883823,0.841594},
{0.883546,0.836858},
{0.877569,0.837228},
{0.871715,0.837562},
{0.865958,0.837816},
{0.86027,0.838025},
{0.854637,0.838173},
{0.84905,0.838323},
{0.843477,0.842773},
{0.837844,0.847053},
{0.832229,0.851292},
{0.826613,0.855605},
{0.820904,0.860086},
{0.815101,0.860094},
{0.814995,0.8647},
{0.809075,0.864744},
{0.809293,0.860113},
{0.890625,0.859707},
{0.890554,0.855152},
{0.890403,0.850576},
{0.890203,0.845932},
{0.889955,0.84123},
{0.889638,0.836401},
{0.889197,0.831434},
{0.883178,0.831973},
{0.877261,0.832434},
{0.871455,0.832816},
{0.865742,0.833129},
{0.860104,0.833388},
{0.854521,0.833597},
{0.848971,0.833759},
{0.843464,0.838413},
{0.837838,0.8428},
{0.832203,0.847045},
{0.826565,0.851279},
{0.820904,0.855599},
{0.815194,0.855605},
{0.809468,0.855634},
{0.896865,0.859609},
{0.903412,0.859499},
{0.896843,0.85499},
{0.903399,0.854783},
{0.910277,0.859378},
{0.910237,0.85456},
{0.903251,0.850042},
{0.896717,0.850336},
{0.917414,0.859235},
{0.917337,0.854281},
{0.910042,0.84969},
{0.903026,0.845179},
{0.896503,0.84562},
{0.932525,0.864112},
{0.932463,0.858853},
{0.92478,0.859062},
{0.924645,0.85394},
{0.932273,0.853513},
{0.931847,0.84814},
{0.924308,0.848755},
{0.917068,0.849265},
{0.909712,0.844742},
{0.902645,0.840308},
{0.896218,0.840811},
{0.643466,0.196243},
{0.650024,0.198203},
{0.65654,0.200087},
{0.663174,0.201994},
{0.669746,0.203781},
{0.676526,0.205579},
{0.683389,0.207311},
{0.690565,0.209059},
{0.697728,0.210736},
{0.70524,0.212454},
{0.712893,0.214166},
{0.72093,0.21596},
{0.728983,0.21777},
{0.737415,0.219724},
{0.745999,0.221782},
{0.744535,0.227943},
{0.743275,0.234089},
{0.74217,0.240192},
{0.640377,0.205567},
{0.647159,0.207363},
{0.653886,0.209113},
{0.660622,0.210821},
{0.667435,0.212491},
{0.674343,0.214102},
{0.681365,0.215632},
{0.688552,0.217116},
{0.695957,0.21859},
{0.70355,0.220049},
{0.711303,0.221489},
{0.719268,0.222961},
{0.7275,0.224517},
{0.735942,0.226172},
{0.644519,0.216783},
{0.637505,0.215124},
{0.63488,0.2249},
{0.6421,0.226436},
{0.649233,0.227887},
{0.651446,0.218379},
{0.89583,0.835886},
{0.902166,0.835255},
{0.90927,0.839692},
{0.90869,0.83453},
{0.90155,0.830103},
{0.895311,0.830822},
{0.916645,0.844147},
{0.916094,0.838965},
{0.915393,0.833659},
{0.907949,0.829247},
{0.900792,0.824682},
{0.894666,0.825579},
{0.888643,0.826253},
{0.88272,0.826898},
{0.876889,0.827354},
{0.871145,0.827871},
{0.865488,0.82821},
{0.859907,0.828549},
{0.854369,0.828731},
{0.848862,0.828997},
{0.843329,0.829115},
{0.843415,0.833877},
{0.837816,0.833952},
{0.837841,0.838462},
{0.832195,0.838458},
{0.832191,0.842804},
{0.826547,0.847036},
{0.820904,0.851274},
{0.815242,0.851279},
{0.809578,0.851292},
{0.923791,0.843491},
{0.923117,0.83813},
{0.922267,0.832672},
{0.921218,0.827116},
{0.914505,0.828251},
{0.907053,0.823803},
{0.899905,0.81923},
{0.893905,0.820122},
{0.888,0.820892},
{0.882177,0.821595},
{0.876436,0.822205},
{0.870775,0.822694},
{0.865188,0.823103},
{0.85967,0.823473},
{0.854191,0.823782},
{0.848722,0.824011},
{0.843233,0.82418},
{0.837695,0.82431},
{0.837766,0.829243},
{0.832153,0.829238},
{0.832189,0.833991},
{0.826549,0.834005},
{0.826552,0.838478},
{0.826547,0.842795},
{0.820903,0.847031},
{0.81526,0.847036},
{0.809604,0.847045},
{0.931247,0.842619},
{0.930394,0.837134},
{0.929364,0.83148},
{0.928121,0.825785},
{0.91998,0.821429},
{0.91344,0.822664},
{0.90601,0.818161},
{0.89886,0.813477},
{0.893014,0.814461},
{0.887238,0.815294},
{0.881532,0.816071},
{0.87589,0.816725},
{0.870326,0.817286},
{0.864821,0.817737},
{0.859373,0.818158},
{0.853949,0.818489},
{0.848539,0.818779},
{0.843096,0.818974},
{0.837597,0.81913},
{0.832051,0.819187},
{0.832119,0.824387},
{0.826518,0.824396},
{0.826538,0.829328},
{0.820904,0.829312},
{0.820904,0.834006},
{0.820904,0.838472},
{0.820904,0.842788},
{0.81526,0.842795},
{0.809616,0.842804},
{0.926664,0.819868},
{0.918563,0.815576},
{0.912228,0.816936},
{0.904809,0.81234},
{0.897676,0.807576},
{0.891979,0.808608},
{0.886343,0.80951},
{0.880765,0.810334},
{0.875244,0.811055},
{0.869779,0.811647},
{0.864365,0.81215},
{0.859,0.812603},
{0.853656,0.812987},
{0.848304,0.813281},
{0.842917,0.813504},
{0.837469,0.813678},
{0.831974,0.813786},
{0.826447,0.813814},
{0.826487,0.81922},
{0.820904,0.819198},
{0.820904,0.824383},
{0.815269,0.829328},
{0.815258,0.834005},
{0.815255,0.838478},
{0.809612,0.83846},
{0.803966,0.838462},
{0.809618,0.833991},
{0.809655,0.829238},
{0.809688,0.824387},
{0.804113,0.82431},
{0.80421,0.81913},
{0.804338,0.813678},
{0.809954,0.807955},
{0.810067,0.801987},
{0.672431,0.222825},
{0.665359,0.221413},
{0.658391,0.219934},
{0.663509,0.230539},
{0.670741,0.231721},
{0.679592,0.224123},
{0.91084,0.81102},
{0.916962,0.809581},
{0.909271,0.804985},
{0.90344,0.806361},
{0.896312,0.801332},
{0.890805,0.802516},
{0.88531,0.803442},
{0.87988,0.804337},
{0.874469,0.804995},
{0.869132,0.805732},
{0.863814,0.806246},
{0.858548,0.806761},
{0.853267,0.807071},
{0.848012,0.807488},
{0.842683,0.807703},
{0.837307,0.807927},
{0.831854,0.807954},
{0.826395,0.808104},
{0.820905,0.80809},
{0.820904,0.813807},
{0.81532,0.81922},
{0.81529,0.824396},
{0.925023,0.814004},
{0.923165,0.807908},
{0.915168,0.803472},
{0.90752,0.798735},
{0.901911,0.800176},
{0.894855,0.795036},
{0.889497,0.796142},
{0.884167,0.797119},
{0.878878,0.798032},
{0.873619,0.798838},
{0.868384,0.799495},
{0.863179,0.80006},
{0.858014,0.800585},
{0.852853,0.801035},
{0.847661,0.801376},
{0.84242,0.801637},
{0.837108,0.801851},
{0.83174,0.801987},
{0.826332,0.802018},
{0.820904,0.802007},
{0.815412,0.808104},
{0.815361,0.813814},
{0.809757,0.819194},
{0.921126,0.801751},
{0.913197,0.797201},
{0.905633,0.79229},
{0.900231,0.79374},
{0.893234,0.788393},
{0.888064,0.789524},
{0.882899,0.790509},
{0.877764,0.791456},
{0.872642,0.792273},
{0.867541,0.792968},
{0.862455,0.793544},
{0.857404,0.794103},
{0.852342,0.794558},
{0.847255,0.794946},
{0.842102,0.795219},
{0.836875,0.795451},
{0.831581,0.795558},
{0.826257,0.795608},
{0.820904,0.795582},
{0.815475,0.802018},
{0.809834,0.813786},
{0.694445,0.226566},
{0.702149,0.227748},
{0.709966,0.228885},
{0.718007,0.23005},
{0.726253,0.231289},
{0.734716,0.232634},
{0.686944,0.225359},
{0.685521,0.233736},
{0.693162,0.23465},
{0.70095,0.235515},
{0.708851,0.23633},
{0.716916,0.237158},
{0.725196,0.23806},
{0.733634,0.239063},
{0.898417,0.787096},
{0.896486,0.780288},
{0.891507,0.781584},
{0.886514,0.782704},
{0.881522,0.783705},
{0.876545,0.784647},
{0.871576,0.785487},
{0.86661,0.786182},
{0.861656,0.786783},
{0.856724,0.787345},
{0.851782,0.78783},
{0.846795,0.788203},
{0.841745,0.788493},
{0.836612,0.78873},
{0.831415,0.788884},
{0.9036,0.785631},
{0.911066,0.790724},
{0.908799,0.784086},
{0.901457,0.778857},
{0.899229,0.771899},
{0.894469,0.773297},
{0.889663,0.774472},
{0.884873,0.775666},
{0.880049,0.776647},
{0.875238,0.777595},
{0.870402,0.778336},
{0.865598,0.779131},
{0.860777,0.779724},
{0.855976,0.780308},
{0.851128,0.780698},
{0.846283,0.781167},
{0.841333,0.781442},
{0.836316,0.78171},
{0.831201,0.781784},
{0.831,0.774579},
{0.830755,0.767044},
{0.830507,0.759388},
{0.918863,0.795347},
{0.916507,0.788972},
{0.913975,0.782351},
{0.906422,0.777332},
{0.903974,0.770435},
{0.896967,0.764775},
{0.892398,0.766102},
{0.887797,0.76732},
{0.883165,0.768397},
{0.878515,0.769373},
{0.873859,0.770288},
{0.869192,0.77111},
{0.864512,0.77181},
{0.859831,0.772423},
{0.855161,0.772987},
{0.850467,0.773474},
{0.845717,0.77386},
{0.840895,0.774165},
{0.835983,0.774413},
{0.835622,0.766896},
{0.835243,0.759216},
{0.834865,0.751465},
{0.834511,0.743733},
{0.834206,0.736128},
{0.911355,0.775652},
{0.908655,0.768742},
{0.901498,0.763367},
{0.899048,0.756185},
{0.894704,0.757501},
{0.890319,0.758769},
{0.885892,0.759928},
{0.881427,0.760966},
{0.876937,0.761901},
{0.872436,0.762798},
{0.867916,0.763597},
{0.863377,0.764291},
{0.858832,0.764889},
{0.854297,0.765456},
{0.849729,0.765934},
{0.845111,0.766337},
{0.84041,0.766641},
{0.839905,0.758963},
{0.839392,0.751215},
{0.838906,0.743489},
{0.903337,0.754759},
{0.905977,0.76184},
{0.900797,0.74763},
{0.844476,0.758655},
{0.843835,0.750905},
{0.84819,0.750512},
{0.848971,0.758271},
{0.853405,0.75779},
{0.852506,0.750067},
{0.856789,0.749541},
{0.857811,0.75724},
{0.86222,0.756647},
{0.86533,0.748285},
{0.86662,0.755979},
{0.870998,0.755201},
{0.869572,0.74756},
{0.861061,0.748953},
{0.875356,0.754344},
{0.873801,0.746754},
{0.879696,0.753443},
{0.882177,0.744932},
{0.884006,0.75246},
{0.888275,0.751361},
{0.886296,0.743924},
{0.877997,0.745884},
{0.8925,0.750179},
{0.890392,0.742833},
{0.896679,0.748946},
{0.898424,0.740447},
{0.89442,0.741683},
{0.293321,0.405053},
{0.267738,0.452056},
{0.248582,0.500886},
{0.294601,0.458963},
{0.317201,0.41669},
{0.346672,0.380579},
{0.327122,0.36564},
{0.340773,0.427931},
{0.32259,0.466894},
{0.281357,0.504684},
{0.311219,0.508753},
{0.349048,0.474603},
{0.364599,0.440222},
{0.385651,0.411552},
{0.365976,0.395324},
{0.244972,0.549906},
{0.279708,0.550654},
{0.310481,0.551249},
{0.34016,0.550609},
{0.340487,0.512345},
{0.37644,0.483186},
{0.387588,0.452805},
{0.404479,0.42889},
{0.425037,0.411723},
{0.410714,0.390945},
{0.395476,0.371247},
{0.259056,0.596061},
{0.291892,0.593673},
{0.321265,0.590834},
{0.349309,0.586558},
{0.376037,0.581804},
{0.369314,0.549275},
{0.368884,0.515633},
{0.40059,0.489989},
{0.40865,0.464921},
{0.420728,0.445308},
{0.437239,0.43287},
{0.456859,0.425932},
{0.44875,0.401933},
{0.438864,0.376452},
{0.428577,0.353825},
{0.38053,0.353341},
{0.365305,0.335595},
{0.287292,0.637509},
{0.320616,0.675754},
{0.314817,0.633197},
{0.341811,0.626912},
{0.365727,0.619817},
{0.389353,0.610968},
{0.410589,0.60414},
{0.40146,0.577531},
{0.396138,0.54881},
{0.396134,0.518791},
{0.423647,0.49557},
{0.42815,0.473583},
{0.431513,0.457671},
{0.445112,0.454268},
{0.462274,0.450618},
{0.478266,0.422822},
{0.474127,0.394979},
{0.469174,0.366127},
{0.463533,0.338784},
{0.417755,0.332472},
{0.407447,0.313833},
{0.34539,0.668682},
{0.357474,0.705677},
{0.378482,0.697915},
{0.368294,0.661109},
{0.387206,0.650011},
{0.404366,0.638034},
{0.422017,0.627823},
{0.439329,0.61997},
{0.431098,0.598104},
{0.424906,0.574058},
{0.421364,0.548282},
{0.421275,0.52135},
{0.444712,0.498363},
{0.446452,0.475802},
{0.401633,0.692522},
{0.408963,0.718684},
{0.424342,0.714249},
{0.426481,0.70053},
{0.426197,0.687182},
{0.408958,0.673634},
{0.420117,0.659173},
{0.433605,0.647891},
{0.447755,0.639199},
{0.461248,0.633889},
{0.455471,0.615063},
{0.449911,0.594254},
{0.445701,0.571704},
{0.443345,0.547779},
{0.443346,0.522844},
{0.463874,0.499351},
{0.464281,0.475126},
{0.39298,0.726337},
{0.438427,0.733153},
{0.448284,0.727358},
{0.438215,0.713102},
{0.440917,0.703616},
{0.439663,0.694145},
{0.444053,0.683824},
{0.43317,0.674432},
{0.443212,0.663651},
{0.454724,0.655462},
{0.466107,0.650489},
{0.477488,0.647856},
{0.474285,0.630984},
{0.470831,0.612338},
{0.467403,0.591918},
{0.464728,0.570333},
{0.463207,0.547322},
{0.463333,0.52361},
{0.482508,0.499798},
{0.482361,0.475104},
{0.481156,0.449561},
{0.500566,0.422223},
{0.50056,0.393059},
{0.500566,0.362007},
{0.500566,0.323128},
{0.498077,0.300393},
{0.457329,0.315467},
{0.450857,0.294418},
{0.451333,0.675429},
{0.460355,0.668499},
{0.470087,0.664524},
{0.479893,0.662392},
{0.490214,0.66197},
{0.488995,0.646687},
{0.487488,0.629611},
{0.485797,0.611027},
{0.484173,0.591053},
{0.482868,0.569806},
{0.482135,0.54741},
{0.482223,0.523986},
{0.500579,0.499748},
{0.500566,0.475257},
{0.500566,0.449561},
{0.519976,0.449561},
{0.522866,0.422822},
{0.527005,0.394979},
{0.531957,0.366127},
{0.537598,0.338784},
{0.503055,0.300393},
{0.543803,0.315467},
{0.550275,0.294418},
{0.505544,0.277658},
{0.556718,0.27388},
{0.508032,0.254922},
{0.563146,0.253597},
{0.510521,0.232187},
{0.458461,0.68355},
{0.46539,0.677834},
{0.473226,0.675658},
{0.481825,0.675334},
{0.491041,0.675175},
{0.500574,0.661773},
{0.500566,0.646469},
{0.500566,0.629281},
{0.500566,0.610725},
{0.500566,0.590766},
{0.500566,0.569754},
{0.500566,0.547469},
{0.500566,0.524077},
{0.518909,0.523986},
{0.518624,0.499797},
{0.518771,0.475104},
{0.538857,0.450618},
{0.544273,0.425932},
{0.552381,0.401933},
{0.562268,0.376452},
{0.572554,0.353819},
{0.583377,0.332472},
{0.593677,0.313836},
{0.604856,0.293983},
{0.615771,0.275008},
{0.465503,0.688988},
{0.453133,0.690908},
{0.468556,0.683825},
{0.474621,0.684764},
{0.48254,0.685955},
{0.491372,0.686526},
{0.500566,0.675136},
{0.510091,0.675175},
{0.510918,0.66197},
{0.512137,0.646687},
{0.513643,0.629611},
{0.515335,0.611027},
{0.516959,0.591052},
{0.518263,0.569806},
{0.518997,0.54741},
{0.461791,0.695556},
{0.450099,0.698011},
{0.459059,0.70084},
{0.468096,0.70469},
{0.470759,0.699396},
{0.473366,0.692715},
{0.481938,0.695035},
{0.491103,0.696248},
{0.500566,0.696578},
{0.500566,0.686578},
{0.50976,0.686526},
{0.518592,0.686002},
{0.451223,0.704857},
{0.457982,0.704818},
{0.46432,0.708679},
{0.474622,0.712917},
{0.477828,0.708325},
{0.480357,0.7019},
{0.490261,0.704267},
{0.500557,0.704693},
{0.510029,0.696248},
{0.555853,0.204673},
{0.568235,0.210868},
{0.589844,0.212225},
{0.598365,0.214734},
{0.605914,0.217155},
{0.544387,0.206571},
{0.53417,0.207756},
{0.54424,0.212399},
{0.555935,0.211848},
{0.525696,0.20487},
{0.525681,0.208346},
{0.533764,0.212481},
{0.519093,0.205763},
{0.525175,0.2015},
{0.519105,0.208435},
{0.52512,0.212053},
{0.518917,0.202992},
{0.524127,0.19811},
{0.517955,0.20041},
{0.513451,0.204234},
{0.514185,0.206171},
{0.514404,0.208048},
{0.518342,0.211213},
{0.510577,0.206553},
{0.511647,0.207748},
{0.513465,0.210059},
{0.509488,0.205084},
{0.512847,0.202045},
{0.508814,0.203234},
{0.506537,0.205888},
{0.507872,0.20737},
{0.510104,0.20873},
{0.505869,0.204196},
{0.789935,0.96552},
{0.786542,0.967715},
{0.787562,0.964421},
{0.791284,0.962556},
{0.788579,0.961187},
{0.78519,0.963353},
{0.784498,0.966946},
{0.788586,0.968484},
{0.785895,0.95991},
{0.789593,0.958074},
{0.786585,0.956563},
{0.782823,0.962346},
{0.782454,0.966176},
{0.787272,0.953669},
{0.787894,0.951237},
{0.784625,0.949071},
{0.785292,0.946554},
{0.786214,0.944085},
{0.787647,0.94191},
{0.792412,0.94405},
{0.79445,0.942508},
{0.796486,0.941126},
{0.798593,0.93972},
{0.792633,0.959592},
{0.793982,0.956628},
{0.790503,0.955381},
{0.791209,0.953406},
{0.791862,0.951857},
{0.788629,0.949206},
{0.789473,0.947338},
{0.790717,0.945581},
{0.795065,0.94746},
{0.796777,0.945833},
{0.798587,0.94422},
{0.800447,0.942613},
{0.794549,0.955575},
{0.795116,0.954523},
{0.795683,0.953471},
{0.792609,0.950442},
{0.79362,0.949023},
{0.797763,0.95069},
{0.799275,0.948962},
{0.800788,0.947233},
{0.8023,0.945505},
{0.796251,0.952418},
{0.820701,0.893284},
{0.815989,0.895611},
{0.820498,0.894924},
{0.816343,0.897418},
{0.820295,0.896564},
{0.816719,0.899135},
{0.820093,0.898203},
{0.812449,0.898371},
{0.813344,0.900068},
{0.80997,0.901},
{0.668396,0.296419},
{0.563893,0.43287},
{0.55602,0.454268},
{0.516585,0.720354},
{0.52651,0.712946},
{0.514175,0.715649},
{0.500566,0.716518},
{0.500566,0.721581},
{0.481611,0.725323},
{0.464417,0.719666},
{0.45692,0.723732},
{0.427774,0.739298},
{0.523303,0.708325},
{0.512262,0.71051},
{0.500566,0.711241},
{0.486957,0.715649},
{0.484547,0.720354},
{0.469993,0.716901},
{0.45837,0.711444},
{0.449813,0.712936},
{0.52077,0.701905},
{0.510871,0.704267},
{0.48887,0.71051},
{0.519194,0.695035},
{0.449158,0.234709},
{0.462596,0.231286},
{0.470993,0.222552},
{0.477061,0.215922},
{0.482592,0.211213},
{0.487468,0.210059},
{0.489287,0.207748},
{0.49083,0.20873},
{0.493062,0.20737},
{0.4952,0.208331},
{0.496305,0.206601},
{0.498083,0.207267},
{0.499418,0.20783},
{0.499942,0.205764},
{0.479133,0.219882},
{0.476033,0.227863},
{0.483629,0.214067},
{0.489082,0.212091},
{0.481617,0.223887},
{0.485416,0.216995},
{0.490886,0.214036},
{0.492846,0.210138},
{0.494972,0.211316},
{0.497105,0.209149},
{0.498893,0.209895},
{0.487201,0.219912},
{0.492785,0.215937},
{0.498369,0.211961},
{0.613042,0.219411},
{0.620297,0.221426},
{0.627602,0.223241},
{0.656346,0.229253},
{0.678063,0.232773},
{0.821106,0.893284},
{0.495588,0.277658},
{0.109272,0.171018}
};


// normal array: 62kb.
const tgx::fVec3 bob_norm_array[5344] PROGMEM = {
{0.9591726113917748,0.12422894966871335,0.25407689706089304},
{0.9461868623930072,0.001093039841035707,0.3236189529350568},
{0.9392952000130715,0.1291140274934794,0.3178900676913593},
{0.9411645862981911,0.23913714897041377,0.2387941487567419},
{0.9198692305583526,0.24957506255412545,0.3025770758386842},
{0.9155685299664642,0.13312593165595984,0.37948880517846667},
{0.9230012011548993,0.0024786305401820453,0.3847890838592727},
{0.9152483286799201,-0.1284920461434937,0.3818511371286867},
{0.9380557394006475,-0.12874796423279053,0.3216759106358711},
{0.9655040308895131,-0.0007564580242014733,0.26038700833059997},
{0.9746016721957065,0.11889296001071631,0.1897789361684349},
{0.9575991612166204,0.22830803843680306,0.17572502958418984},
{0.9329187987857629,0.32598992968968454,0.15294796701180366},
{0.9144205196980049,0.34407581927319114,0.21318288802507793},
{0.8903253767563984,0.362196153269492,0.27592511676242854},
{0.8947062034857391,0.25856705880668857,0.36420308283180913},
{0.8881828804643591,0.13618798167120982,0.43884394093841167},
{0.8960469368213636,0.0034443997571416505,0.4439459686981788},
{0.8886680574861612,-0.12838400830490498,0.4402120284764366},
{0.8712011566358836,-0.25500304584776673,0.4195020754235434},
{0.8965818329896831,-0.2546069525732217,0.36237593249861066},
{0.9182703755464897,-0.25420910396429985,0.3035741241531903},
{0.9570325904193285,-0.12920094470594815,0.2596068888961933},
{0.9805944672528573,-0.0029416914017147337,0.19602509340587576},
{0.985425513343296,0.11409294365470027,0.1261719376894362},
{0.9689107945124517,0.21890395357463555,0.11529497554812888},
{0.9454131322507278,0.310782043474276,0.09802311371213038},
{0.9170932957195321,0.39155712625879036,0.07498602417947235},
{0.9025895464032861,0.41287579250911616,0.12192493872657648},
{0.8808095060406208,0.4390902522651065,0.17712810176322347},
{0.8522831455235242,0.46629207961728103,0.23703404047249918},
{0.8621471443087875,0.3783010633211722,0.3370320564134414},
{0.8660672676364787,0.26569008210489026,0.42348113086627664},
{0.8572630843726942,0.13834201361575998,0.49594504881141005},
{0.8653600517473612,0.004082260244113643,0.5011340299671374},
{0.8628540772077549,-0.11535001032146171,0.4921150440342101},
{0.8410852699779015,-0.2464800791170371,0.48148015454913595},
{0.830159085875811,-0.3772900390287701,0.41047304246138605},
{0.8551971531341814,-0.376792067469524,0.3559010637287179},
{0.8766916606134366,-0.37621185436014265,0.2997938839432145},
{0.8946130046676435,-0.37558600195962,0.24208000126305243},
{0.9362175814855567,-0.25385688651914295,0.24300889136848858},
{0.9719472534474287,-0.12982103385246174,0.1961250511420653},
{0.9913419857424517,-0.005000369928084337,0.13120999811292883},
{0.9918340794089968,0.11077200886871533,0.06320380506027254},
{0.9754784456279201,0.21251609708375083,0.05726002615810373},
{0.9525342571284419,0.30064908115763733,0.04783951291386564},
{0.9252630818986289,0.37767603342957257,0.03534180312824026},
{0.8342715324268108,0.2707828482378998,0.4802787308244988},
{0.8306438847888705,0.3913709457164622,0.39605494506678685},
{0.7965060060247715,0.4008500030320294,0.45265600342389},
{0.7993556053418482,0.27388386477795473,0.5348067359550162},
{0.822877853981572,0.13968297521346776,0.5507819022645862},
{0.8310906913143721,0.004488918332715565,0.5561187934450708},
{0.8302187244093554,-0.1282969574118962,0.5424728199264486},
{0.803586734407396,-0.2556319155113652,0.537494822353153},
{0.8015467966067247,-0.37767290416513505,0.4635578823717387},
{0.7789741550435259,-0.49508709853991795,0.384822076593262},
{0.8025251210617261,-0.49473207463083374,0.33345705030233325},
{0.8227269502307801,-0.49430897009776836,0.2806759830210683},
{0.8395572063741009,-0.49383512139110763,0.2264300556594581},
{0.8528501677556445,-0.49334209704040005,0.17105603364672514},
{0.9087855324925878,-0.3749672197077946,0.1830531072578945},
{0.9502087612149438,-0.2535829362752501,0.18110495448878342},
{0.9826761198702798,-0.1304390159114087,0.13165601605986263},
{0.9978003539489041,-0.00646448229314052,0.06597472340315971},
{0.9958000117823008,0.09155510108327951,1.2440100147191202e-09},
{0.980856086564477,0.1947340171860567,1.5543801371802707e-09},
{0.9589335394641273,0.28363086378389957,1.2430694030054964e-09},
{0.9325828667222605,0.3609559484148867,3.106789556000969e-10},
{0.8190860880431589,0.49111205278939185,0.2964910318696745},
{0.7825170031069837,0.5116810020316295,0.35475300140854676},
{0.7438589618184642,0.5268439729576263,0.41122897889202825},
{0.7599288506424585,0.4066309200801569,0.5071089003320659},
{0.7611140167943614,0.27504800606907187,0.5874130129615619},
{0.7849289359863006,0.14017498856823954,0.6035209507807562},
{0.7932993496805628,0.004618272035700604,0.6088142683608856},
{0.7934308990299738,-0.12833498366841187,0.5949769242847288},
{0.7670992339856302,-0.2557650780151385,0.5883391794590681},
{0.7695749014924949,-0.3779179516255604,0.5147159341150778},
{0.7520448914193903,-0.49535592848026855,0.43479993722337223},
{0.7142230921083585,-0.6045490779644678,0.35271204548680646},
{0.7358009737021057,-0.6043739783993721,0.3054979890813493},
{0.754281044542937,-0.6041640356780019,0.25699401517639653},
{0.7696448933714798,-0.6039259163305996,0.20717197129787915},
{0.7817478750563742,-0.6036679035181814,0.15638197500609646},
{0.7904679253209415,-0.6034379429905048,0.10499099008102918},
{0.8624593807491644,-0.49290921760418743,0.1149100507292364},
{0.9190473511064838,-0.37444614305081075,0.12305304701033369},
{0.9601238386295998,-0.2533999574104393,0.11811298014845782},
{0.9891809016210182,-0.1308819869831326,0.0662649934096154},
{0.9996134048725197,-0.027803611261271705,6.222972520484971e-10},
{0.7519427172479108,0.004402158344661847,0.6592137521166688},
{0.743382900656546,0.13978698131928843,0.6540959125885905},
{0.7195271419231452,0.27440905412581923,0.637950125832485},
{0.698178802928239,0.1385609608890266,0.7023868017404662},
{0.706943635453269,0.003808488036092562,0.7072596352903187},
{0.7094767898427187,-0.12867596188431996,0.6928817947583961},
{0.7532097550980307,-0.12844995823520935,0.6451167902438579},
{0.6745537242785825,0.272223888729461,0.6862007195179148},
{0.679044616724918,0.40810376965283,0.6102046555804529},
{0.6346961648299807,0.40478110512126186,0.6582651709508288},
{0.6271892620720287,0.2689001123603388,0.7309763054396095},
{0.6500450212600478,0.1366500044692068,0.7475080244476241},
{0.6588083261025255,0.002866381418825754,0.7523053723824855},
{0.6624649723030025,-0.12902799460546868,0.7378969691492663},
{0.6841792003567768,-0.2559050749398929,0.6829431999948233},
{0.727323669060169,-0.2558458835874631,0.6368227102390461},
{0.7207762859947169,0.40891516225225266,0.5597052220838},
{0.6626948364966366,0.5401558667300602,0.5187168720195955},
{0.620464562215871,0.5394296193920806,0.5692445983553842},
{0.5770639386012657,0.5350259430740452,0.617044934347348},
{0.5889610520138031,0.3997250353015182,0.7023850620307883},
{0.5786522299379251,0.26509610534073014,0.7712883064853526},
{0.5999651919810925,0.13444004301907292,0.7886492523575487},
{0.6082701095728823,0.0017631903176185087,0.7937281429810195},
{0.6128493475233688,-0.12945007340617362,0.7795244420384247},
{0.6380213234555192,-0.25595112975868134,0.7262353681770961},
{0.6550171209512151,-0.3780300698045819,0.6542521208099551},
{0.6963547489230734,-0.3780728636824509,0.6100417800439855},
{0.7345179929633177,-0.3780439963783385,0.5635299946013826},
{0.7219546981298671,-0.4955227928075935,0.4829477980655623},
{0.689521225334539,-0.6046811976089407,0.39864913027795906},
{0.6382609056312173,-0.702318896160052,0.3152319533920135},
{0.6575220847292876,-0.7022470904926192,0.27297203517558816},
{0.6739982436069362,-0.7021592537853268,0.22956208297190123},
{0.6876760039995237,-0.7020560040831578,0.184984001075867},
{0.6984300720706536,-0.701936072432436,0.1395750144026767},
{0.7061601448806851,-0.7018261439914916,0.09369051922219303},
{0.719573909400725,-0.6924359128175843,0.05240129340231888},
{0.79576621192506,-0.6032791606627304,0.053013114118226214},
{0.8683154554810307,-0.4926072584006313,0.05802033043497584},
{0.9253050153342659,-0.37410000619963024,0.06212740102958275},
{0.965871771451585,-0.25330794006126905,0.05409998719864615},
{0.988455558405391,-0.15151108559272725,1.866861054640513e-09},
{0.9891809016210182,-0.1308819869831326,-0.0662649934096154},
{0.9978003539489041,-0.00646448229314052,-0.06597472340315971},
{0.9918340794089968,0.11077200886871533,-0.06320380506027254},
{0.9754784456279201,0.21251609708375083,-0.05726002615810373},
{0.9525342571284419,0.30064908115763733,-0.04783951291386564},
{0.9252630818986289,0.37767603342957257,-0.03534180312824026},
{0.9454131322507278,0.310782043474276,-0.09802311371213038},
{0.9170932957195321,0.39155712625879036,-0.07498602417947235},
{0.9329187987857629,0.32598992968968454,-0.15294796701180366},
{0.9025895464032861,0.41287579250911616,-0.12192493872657648},
{0.9144208343275343,0.3440749376613686,-0.2131829613760475},
{0.8808095060406208,0.4390902522651065,-0.17712810176322347},
{0.8903253767563984,0.362196153269492,-0.27592511676242854},
{0.8522831455235242,0.46629207961728103,-0.23703404047249918},
{0.8621471443087875,0.3783010633211722,-0.3370320564134414},
{0.8190858451911518,0.4911119071788761,-0.2964919439624349},
{0.8306438847888705,0.3913709457164622,-0.39605494506678685},
{0.7825170031069837,0.5116810020316295,-0.35475300140854676},
{0.7965060060247715,0.4008500030320294,-0.45265600342389},
{0.7438589618184642,0.5268439729576263,-0.41122897889202825},
{0.7599288506424585,0.4066309200801569,-0.5071089003320659},
{0.7038295515139701,0.536213658320208,-0.46593870309999247},
{0.7207762859947169,0.40891516225225266,-0.5597052220838},
{0.6626948364966366,0.5401558667300602,-0.5187168720195955},
{0.679044616724918,0.40810376965283,-0.6102046555804529},
{0.620464896912558,0.5394289103763215,-0.5692449054225284},
{0.6346961648299807,0.40478110512126186,-0.6582651709508288},
{0.5770639386012657,0.5350259430740452,-0.617044934347348},
{0.5889610520138031,0.3997250353015182,-0.7023850620307883},
{0.5338731862141991,0.5281571842204658,-0.6603252303204901},
{0.5432040511912806,0.39393603712433695,-0.7414470698736044},
{0.4922586877931486,0.5202346700498491,-0.6978805573809119},
{0.49727986294919135,0.3883288929761835,-0.775830786180289},
{0.4518238888468188,0.5124898739223817,-0.7302118203606122},
{0.4510216863330181,0.3836547331839557,-0.8058464395670358},
{0.41222389166386547,0.5059108670420884,-0.7577108008668083},
{0.4032228908022157,0.38040989698025873,-0.8322857746066391},
{0.37130199360803623,0.5011489913727202,-0.7816549865438095},
{0.3522662000238505,0.3784482148905264,-0.8559704860372994},
{0.32646792355019905,0.49803588337370563,-0.8033548118764172},
{0.3020969764332647,0.38951596961366564,-0.8700659321257243},
{0.2776941096097744,0.4962101958611499,-0.8225943246895604},
{0.24439211648598638,0.3855521837679017,-0.8897314240776832},
{0.22868910744068352,0.506899238146894,-0.8311163904677142},
{0.17942002184537578,0.4948000602446324,-0.8502831035266507},
{0.18193999014312837,0.3768069795859172,-0.9082479507943062},
{0.11780502406374022,0.5028161027089988,-0.8563281749200333},
{0.12199099833244405,0.3768329948488814,-0.9182129874484876},
{0.05808069423730669,0.4946069509257215,-0.8671739139600968},
{0.061544113991723264,0.3769290856928001,-0.9241952101108096},
{0.0008721015287299589,0.49471729993280494,-0.8690535268820434},
{0.0006062857906278131,0.3770328697970533,-0.926199680150095},
{0.06391362592356495,0.25529510354848595,-0.9647483913049404},
{0.00036866105761528857,0.25538203991175534,-0.9668401511002401},
{0.06526248199838287,0.12971896421908796,-0.9894007270895538},
{0.0001675799232101998,0.12978194053029093,-0.9915425456475185},
{0.06559830724134569,-5.042510556638786e-05,-0.9978461101514495},
{-0.0046995918269233244,-0.009441043670119347,-0.9999443887192323},
{0.06489138608761408,-0.12983597216382234,-0.9894097878755311},
{-2.672190177509511e-05,-0.15107001003534998,-0.988523065666077},
{0.06316796943387976,-0.2554498763912833,-0.9647565331674507},
{-2.45775119655148e-05,-0.27599013436527026,-0.9611604679391397},
{0.06041980939129218,-0.377138058620074,-0.9241841436496309},
{-1.4419394092570694e-05,-0.3970138373488398,-0.9178126239846724},
{0.05658768506605097,-0.4948748693985084,-0.8671197711600598},
{-5.659631950487696e-06,-0.514023177148601,-0.8577762956167688},
{0.05178517769553221,-0.6044217396686499,-0.7949796575931771},
{-1.6402598381550034e-06,-0.621546938671752,-0.7833769227039324},
{0.046169188521818526,-0.7022368254159975,-0.7104448233753966},
{-3.2229798425169834e-07,-0.7174189649450794,-0.6966419659602965},
{0.039742992341784446,-0.7885828480452257,-0.6136428817550168},
{1.8665495923866774e-09,-0.8018198249002094,-0.5975658695047749},
{0.027613798820732862,-0.8630249631438983,-0.5044059784589799},
{-0.002941668616941895,-0.869771591067246,-0.49344576800100287},
{0.000666187867651317,-0.922440816742644,-0.3861379232876369},
{0.025970694957264288,-0.9224388208898455,-0.38526892519224565},
{0.0006924559246676162,-0.9649768950200188,-0.2623339714606479},
{0.017882395258959554,-0.964975744162403,-0.2617289306095505},
{0.0007205100507816726,-0.9910010698459263,-0.1338520094339127},
{0.009489525774212528,-0.9910005586968365,-0.133520940541695},
{0.0007515326493929235,-0.9999995334774701,-0.0006068307168996666},
{0.0007875516308769619,-0.9999995313032816,-0.0005631657360459438},
{0.0007335048118231843,-0.9911637457221352,0.13264196597139874},
{-0.007964846052378268,-0.9911645087485018,0.13239893437903164},
{0.0007134622046966076,-0.9653022769510425,0.2611340749209403},
{-0.016410602654231724,-0.9653011561266825,0.2606230421528667},
{-0.001514369194328168,-0.9192755109287829,0.39361179059140033},
{-0.029431007270592786,-0.9229092279941394,0.38389109483589196},
{-0.03374200513187257,-0.8636781313581124,0.5029130764888101},
{-3.818060909878847e-05,-0.8521902030847224,0.5232321246910026},
{-0.04099269903734202,-0.789354981463068,0.6125669856146945},
{-0.004499159070719698,-0.7813228386214153,0.6241108710928132},
{-0.04745261388293425,-0.7030452056858321,0.7095602075918881},
{-0.000707384782722009,-0.7031837840123739,0.7110077816091804},
{-0.05312242184055089,-0.605139248794654,0.7943453265841226},
{-0.0007754547818058765,-0.6053148296791228,0.7959857760289538},
{-0.057957076173810025,-0.4953557963589248,0.8667546436766282},
{-0.0008631765266393485,-0.4955543023464921,0.8685765299339865},
{-0.061739682392428843,-0.37733689238710133,0.9240157364794861},
{-0.0009417892727838774,-0.3775511093555199,0.9259882682072068},
{-0.06441957067949833,-0.2554468837336123,0.9646745609293609},
{-0.0010214400116047467,-0.25565700290456095,0.9667670109835979},
{-0.06605099792104487,-0.12970699591747237,0.9893499688602102},
{-0.0010711702383578087,-0.1298870289025838,0.991528220635792},
{-0.06199317924979336,0.009572646795866877,0.9980306659415955},
{0.009987521228938775,2.9144703586180746e-05,0.9999501230412884},
{-0.0011457603390213813,0.12998503846154014,0.9915152933814977},
{-0.059641191130089956,0.14270397877689175,0.9879668530683753},
{-0.0011730604717236277,0.2557381028401421,0.966745388757999},
{-0.06474459496629699,0.25568798012100696,0.9645889250060306},
{-0.0011509895128697005,0.3775938401919406,0.9259706081038667},
{-0.062195428339503894,0.37748317200116005,0.9239254209889499},
{-0.0010915698633217816,0.4955339379529446,0.8685878912419174},
{-0.0584808031679742,0.49536002683423797,0.8667170469510864},
{-0.0009670818366402623,0.6052328977638876,0.7960478655313692},
{-0.05362861026060317,0.6050121157551762,0.794408151991759},
{-0.0008118941584006196,0.7030781371706046,0.711112138738039},
{-0.047864201567992024,0.702862023025184,0.7097140232496498},
{-0.0006502630479273245,0.7893500581786655,0.6139430452503762},
{-0.04125268079631867,0.7891786326266637,0.6127767147441444},
{-0.0005041829207803914,0.8636568642981429,0.5040799207965754},
{-0.03381470302945786,0.8635500773654161,0.5031280450752209},
{-0.0038704017767815717,0.9228754236635214,0.3850791767779224},
{-0.02937828622270498,0.9228165672342491,0.3841178198634023},
{-0.01606009979528183,0.9652589876958391,0.26080099667556844},
{0.0012067805031750988,0.9652804024800373,0.2612131089145304},
{-0.007400243129711273,0.9911484191765496,0.1325520560589236},
{0.0013967002683404435,0.991154190425076,0.1327080254964728},
{0.0015464295260765137,0.9999986935373651,-0.00047061585577363644},
{0.0015812093474965665,0.9999985873395811,-0.0005701717647123483},
{0.010392098980896733,0.9909919028181806,-0.13351798690653188},
{0.0016873906867192047,0.9909984033076873,-0.13386305447839142},
{0.018867600122688837,0.9649320062745862,-0.2618210017025225},
{0.0017488499569360372,0.9649559762387688,-0.26240599353847255},
{0.026987087555293224,0.9223365746777715,-0.3854438222581323},
{0.0017559594624196588,0.922383717615717,-0.386270881744632},
{0.0287129052573419,0.8628621579903301,-0.5046230923966456},
{-0.0019076507334560581,0.8696783343750676,-0.49361518978581614},
{0.0010234598059395675,0.8016648479945904,-0.5977728866549872},
{0.04069810285438983,0.7883370552905692,-0.6138960430560272},
{0.000907167044062027,0.7172250348363503,-0.6968410338462786},
{0.047073794703270104,0.7019469210171335,-0.7106719200353991},
{0.004672832953314983,0.611580386529871,-0.7911685000328085},
{0.06174220201199811,0.6040830196853021,-0.7945260258912836},
{0.7038295515139701,0.536213658320208,0.46593870309999247},
{0.5553651841516839,0.0007171932378117069,0.8316062757495435},
{0.5479698545071733,0.13232996486474488,0.8259647806960553},
{0.5289247926882326,0.26144289752760713,0.8073946835421195},
{0.4940329282617307,0.13066298102649523,0.8595688751824424},
{0.5055729103842546,0.013203697659567621,0.8626828470844364},
{0.5010748802102976,-0.12105897105898002,0.8568947951460418},
{0.5606668036828334,-0.12985095453276113,0.8177967136489397},
{0.47793886696406207,0.25846892805427923,0.8395047663209424},
{0.49727986294919135,0.3883288929761835,0.775830786180289},
{0.4510216863330181,0.3836547331839557,0.8058464395670358},
{0.4252060624308847,0.2565250376642914,0.867983127441632},
{0.4430171526243086,0.14254504910834587,0.8851083049295998},
{0.44693706234274305,0.008900541241526385,0.8945211247757354},
{0.4391571540840236,-0.13031204572168334,0.8889093118854426},
{0.4840099223471483,-0.25593695893837337,0.8367978657470899},
{0.5379356957388152,-0.25598085521496544,0.8031805457139832},
{0.5892690469379332,-0.255981020390041,0.7663130610402862},
{0.5432040511912806,0.39393603712433695,0.7414470698736044},
{0.4922586877931486,0.5202346700498491,0.6978805573809119},
{0.4518238888468188,0.5124898739223817,0.7302118203606122},
{0.41222389166386547,0.5059108670420884,0.7577108008668083},
{0.4032228908022157,0.38040989698025873,0.8322857746066391},
{0.3742560640471942,0.2679620458568847,0.8877661519252101},
{0.38411998790713475,0.13834199564471736,0.9128599712613429},
{0.38364977056165744,-0.000640422617000934,0.9234784477219051},
{0.3801020795559437,-0.13024702726090104,0.9157281916633041},
{0.4279568821573812,-0.25584292955084476,0.8668317613083724},
{0.46331508103613134,-0.3775540660360997,0.8017431402288963},
{0.5149740417589893,-0.3776840306262104,0.7695170623997564},
{0.5641371234712954,-0.3778140826912328,0.7341701606860053},
{0.6108211054332293,-0.37793506523499937,0.6957461200920524},
{0.5338731862141991,0.5281571842204658,0.6603252303204901},
{0.32027484685309215,0.12915893823963323,0.9384785512445338},
{0.3225129674474587,-0.0005171789477990322,0.9465649044593668},
{0.3193578580849043,-0.1301249421755465,0.9386575828827213},
{0.3703041039340081,-0.25572807177571943,0.8930162506446923},
{0.40963018087798114,-0.3774241666569615,0.8305143667253267},
{0.43438798036197146,-0.49512797761600735,0.7524329659836351},
{0.48283499819274867,-0.49522999814635416,0.7222309972966894},
{0.5289531021464079,-0.49534309565596213,0.6890891330703599},
{0.5727592079488596,-0.4954581798835567,0.6530452370979121},
{0.6142499760319664,-0.495555980663406,0.6141019760377414},
{0.25184798900167266,0.25498598886463464,0.9335709592304904},
{0.3157881553236003,0.2638901297970312,0.9113944482785836},
{0.3522662000238505,0.3784482148905264,0.8559704860372994},
{0.3020969764332647,0.38951596961366564,0.8700659321257243},
{0.24439211648598638,0.3855521837679017,0.8897314240776832},
{0.18193999014312837,0.3768069795859172,0.9082479507943062},
{0.1896590029301368,0.25507600394079677,0.9481380146482584},
{0.25781805594433277,0.12933302806417082,0.957498207768995},
{0.2595049256925374,-0.00034219490201482767,0.9657417234664554},
{0.25692606087940806,-0.1300030308046118,0.9576472269174102},
{0.3110691397280895,-0.2556211148215797,0.9153654111698776},
{0.3544280832032428,-0.37731508857604806,0.8555782008500008},
{0.3840531029773245,-0.4950341327350049,0.7793872089794586},
{0.39218204482621416,-0.6118890699386188,0.6868660785084538},
{0.4424569597786731,-0.6045839450406012,0.6623519397892308},
{0.4847439857349542,-0.6046459822064782,0.6320019814014459},
{0.524925340936495,-0.6047123927578031,0.5989793890342446},
{0.5629989685109056,-0.604769966174612,0.563280968495133},
{0.598653306984406,-0.6047983101355121,0.5251982693172774},
{0.653085407287045,-0.4956073090781606,0.5725843570837569},
{0.6889708038259261,-0.49560185888482483,0.5288648494136886},
{0.6619009903091075,-0.604759991145709,0.44289099351563294},
{0.6161909367415336,-0.7023739278939451,0.3563419634177577},
{0.5512206187742982,-0.7886524545657851,0.2723658116310527},
{0.5678438139738292,-0.7886287416444779,0.2358349227402561},
{0.582052843692349,-0.7885987882253724,0.19830894674503188},
{0.5938370467426972,-0.7885610620700093,0.1597780125766072},
{0.603092987128488,-0.7885099831712259,0.12054399742728976},
{0.6097352939736109,-0.7884623801438677,0.08093173901987598},
{0.630863033544247,-0.7747830411967611,0.04150990220716438},
{0.7124469619250543,-0.7017259624980111,0.0},
{0.8105547740197923,-0.585662836718981,0.0},
{0.8811370272755972,-0.4728610146374129,6.223950192662382e-10},
{0.9352689017009055,-0.3539379628002372,6.223359345909409e-10},
{0.967387481580119,-0.25330112609713146,9.336524647863174e-10},
{0.965871771451585,-0.25330794006126905,-0.05409998719864615},
{0.9601238386295998,-0.2533999574104393,-0.11811298014845782},
{0.9826761198702798,-0.1304390159114087,-0.13165601605986263},
{0.9913419857424517,-0.005000369928084337,-0.13120999811292883},
{0.985425513343296,0.11409294365470027,-0.1261719376894362},
{0.9689107945124517,0.21890395357463555,-0.11529497554812888},
{0.9575991612166204,0.22830803843680306,-0.17572502958418984},
{0.9411645862981911,0.23913714897041377,-0.2387941487567419},
{0.9198692305583526,0.24957506255412545,-0.3025770758386842},
{0.8947062034857391,0.25856705880668857,-0.36420308283180913},
{0.8660672676364787,0.26569008210489026,-0.42348113086627664},
{0.8342715324268108,0.2707828482378998,-0.4802787308244988},
{0.7993556053418482,0.27388386477795473,-0.5348067359550162},
{0.7611140167943614,0.27504800606907187,-0.5874130129615619},
{0.7195271419231452,0.27440905412581923,-0.637950125832485},
{0.6745537242785825,0.272223888729461,-0.6862007195179148},
{0.6271892620720287,0.2689001123603388,-0.7309763054396095},
{0.5786522299379251,0.26509610534073014,-0.7712883064853526},
{0.5289247926882326,0.26144289752760713,-0.8073946835421195},
{0.47793886696406207,0.25846892805427923,-0.8395047663209424},
{0.4252060624308847,0.2565250376642914,-0.867983127441632},
{0.3742560640471942,0.2679620458568847,-0.8877661519252101},
{0.3157881553236003,0.2638901297970312,-0.9113944482785836},
{0.25184798900167266,0.25498598886463464,-0.9335709592304904},
{0.1896590029301368,0.25507600394079677,-0.9481380146482584},
{0.12700999920485392,0.2551849984024143,-0.9585139939992232},
{0.12990204330486682,0.12962404321219115,-0.9830173277041175},
{0.13071093615743232,-0.00010995194629665443,-0.9914205157648378},
{0.12939805071421157,-0.1298620508960644,-0.9830523852818985},
{0.1202629353084799,-0.24307086924796087,-0.962524482241376},
{0.12192405739106946,-0.3570951680888418,-0.9260764359149308},
{0.11482296505197097,-0.47548585527900744,-0.8721977345340131},
{0.10566504457892939,-0.5870142476549062,-0.8026513386298421},
{0.09487662031813593,-0.6867291470652739,-0.7206951543392044},
{0.08248960371973843,-0.7749720349461403,-0.6265890282550428},
{0.0649511120853503,-0.858126159670172,-0.509314094767265},
{0.051059092709737054,-0.9224378682934957,-0.3827549453499064},
{0.034925905428327665,-0.964975149980401,-0.2600060404112067},
{0.018182602987922302,-0.9910001628497025,-0.13262002179326693},
{0.000816509619992616,-0.9999995345955542,-0.0005139267608160893},
{-0.01660409171965103,-0.9911645057129211,0.13159493437449046},
{-0.03341758836600682,-0.9652966639417937,0.2590089098286849},
{-0.05448429927668034,-0.9228819877480541,0.38120899493916666},
{-0.06660150418722836,-0.8636070542948693,0.49974703141903437},
{-0.08105099029126718,-0.7892289054618266,0.6087269270833451},
{-0.09386163085623904,-0.7028892310690528,0.7050792317889975},
{-0.10501901293865824,-0.6050080745388143,0.7892630972395874},
{-0.10784302052376894,-0.5067820964464701,0.8553021627738531},
{-0.12043601562272008,-0.39726205153204214,0.9097681180133084},
{-0.12588604399491413,-0.2760820964857401,0.9528543330054962},
{-0.1340040038333186,-0.13884400397177163,0.98120602806838},
{-0.13078495547680036,0.0004401308501659947,0.9914106624934824},
{-0.12536795813657425,0.13945195343358394,0.982260671999151},
{-0.12668603653619487,0.2766130797750854,0.9525942747277522},
{-0.1214840174775424,0.3975770571982226,0.9094911308457699},
{-0.10893902600173323,0.5068041209647823,0.8551502041085578},
{-0.10621195406307427,0.60487473839022,0.7892056586666534},
{-0.09501768632798734,0.7026408988976091,0.7051718985334258},
{-0.08208786379530303,0.7889706520259869,0.6089227314357816},
{-0.06746000156652245,0.8634090200496528,0.49997401161014665},
{-0.055313069313296416,0.9227364880822663,0.3814417883829041},
{-0.033849412085420916,0.9652273446198328,0.2592110925474024},
{-0.016843693165144922,0.991141597813311,0.1317369465436155},
{0.0007089477324324761,0.9999996225851205,-0.0005022178104554541},
{0.01811149853738562,0.9909819199721434,-0.1327659892783336},
{0.034822407506897725,0.9649042080108101,-0.2602830561109475},
{0.050919005403245086,0.9223010978695251,-0.3831030406527898},
{0.060638999163151484,0.8628159880927079,-0.5018679930739707},
{0.07971041870300934,0.7883331849720921,-0.6100631431433537},
{0.09270825108211024,0.7019663867824485,-0.7061503890878277},
{0.10836299449505166,0.6144519687852263,-0.7814769603001899},
{0.22868910744068352,0.506899238146894,0.8311163904677142},
{0.2776941096097744,0.4962101958611499,0.8225943246895604},
{0.32646792355019905,0.49803588337370563,0.8033548118764172},
{0.37130199360803623,0.5011489913727202,0.7816549865438095},
{0.1940890418128009,0.12949602789746179,0.9723992094849567},
{0.19534895581760836,-0.0002044169537666845,0.9807337781858434},
{0.193411079044223,-0.12991505309434434,0.972478397437415},
{0.2502539138174469,-0.2555379119977413,0.9338486784007807},
{0.29772693492672414,-0.3772339175491234,0.8769568083262023},
{0.3322979470202471,-0.494963921085681,0.8028628719959695},
{0.3445030986462371,-0.6044521730809755,0.7183002056806245},
{0.31525810955646805,-0.7022532440425251,0.638320221824933},
{0.3483489748709767,-0.7174429482454612,0.6032649564819758},
{0.3952590858538401,-0.7022951525448443,0.5920741286038433},
{0.433055002503491,-0.7023270040601525,0.5649780032661378},
{0.46898012376738835,-0.7023641853592006,0.5354831413180358},
{0.5030300041427036,-0.7023980057845988,0.5035850041472743},
{0.5349259970161828,-0.7024119960819459,0.4695439973808836},
{0.5644099444042122,-0.7024129308105738,0.4336559572838062},
{0.6316098112124873,-0.6047968192268626,0.4850668550140238},
{0.5915007090441261,-0.7024016544925743,0.3959278052453381},
{0.5244661736497299,-0.7943822630184221,0.3064181014544374},
{0.45052394710443705,-0.8630988986644275,0.22822897320386606},
{0.46447105846808495,-0.8630941086471563,0.19833102496610933},
{0.476430118465793,-0.8630872146092519,0.1676150416779881},
{0.4863979644664412,-0.8630759369484212,0.1360769900589639},
{0.49430900718280424,-0.863056012541067,0.10388900150961108},
{0.5000708208757918,-0.8630356908626171,0.0714042744231545},
{0.5122059611925734,-0.8581179349844569,0.03575839729075512},
{0.5977417754628274,-0.8016886988517096,3.1109488313956234e-10},
{0.630863033544247,-0.7747830411967611,-0.04150990220716438},
{0.719573909400725,-0.6924359128175843,-0.05240129340231888},
{0.79576621192506,-0.6032791606627304,-0.053013114118226214},
{0.8683154554810307,-0.4926072584006313,-0.05802033043497584},
{0.9253050153342659,-0.37410000619963024,-0.06212740102958275},
{0.12700999920485392,0.2551849984024143,0.9585139939992232},
{0.12990204330486682,0.12962404321219115,0.9830173277041175},
{0.06391372551510924,0.2552951019168005,0.9647483851388764},
{0.06526248199838287,0.12971896421908796,0.9894007270895538},
{0.13071093615743232,-0.00010995194629665443,0.9914205157648378},
{0.0655983072413619,-5.042020556585941e-05,0.9978461101516961},
{0.00016757892321068614,0.1297819405303127,0.9915425456476847},
{-0.004699591827367015,-0.009441033671006792,0.9999443888136375},
{0.06489138608761408,-0.12983597216382234,0.9894097878755311},
{0.12939805071421157,-0.1298620508960644,0.9830523852818985},
{0.00036869005761587894,0.25538203990902486,0.9668401510899031},
{0.061544113991723264,0.3769290856928001,0.9241952101108096},
{0.12199099833244405,0.3768329948488814,0.9182129874484876},
{0.11780601018574369,0.5028160434744827,0.8563280740398411},
{0.05808092228981246,0.49460618981584276,0.8671743327969407},
{0.0008721015287299589,0.49471729993280494,0.8690535268820434},
{0.0006062857906278131,0.3770328697970533,0.926199680150095},
{0.17942002184537578,0.4948000602446324,0.8502831035266507},
{-0.06486792196378229,0.1298130439537039,0.989414335008127},
{-0.07641709530214455,2.1427398682718557e-06,0.9970759387032625},
{-0.06491056738392935,-0.12982093476795917,0.9894105028439256},
{-2.672190177509511e-05,-0.15107001003534998,0.988523065666077},
{-0.06320642767449923,-0.25545211184794864,0.9647534224106445},
{-2.45775119655148e-05,-0.27599013436527026,0.9611604679391397},
{-0.06044870076501791,-0.3771460047730298,0.9241790116960908},
{-1.4419394092570694e-05,-0.3970138373488398,0.9178126239846724},
{-0.05660219488030793,-0.49487995523790224,0.8671159215690043},
{-5.659631950487696e-06,-0.514023177148601,0.8577762956167688},
{-0.05179098187468735,-0.6044237884695416,0.794977721781298},
{-1.6402598381550034e-06,-0.621546938671752,0.7833769227039324},
{-0.04617071812562351,-0.7022372756831384,0.71044427890503},
{-3.2229798425169834e-07,-0.7174189649450794,0.6966419659602965},
{-0.03974391530856007,-0.7885833037464927,0.6136422363626977},
{1.8665495923866774e-09,-0.8018198249002094,0.5975658695047749},
{-0.03247611088818292,-0.8630372893483123,0.5040951690067024},
{-0.002941668616941895,-0.869771591067246,0.49344576800100287},
{-0.02464880310467174,-0.9224391161870069,0.3853550485378915},
{0.000666187867651317,-0.922440816742644,0.3861379232876369},
{-0.016508905234609753,-0.9649763059727043,0.26181708301642276},
{0.0006924559246676162,-0.9649768950200188,0.2623339714606479},
{-0.008060771651998923,-0.9910012030987839,0.13361002738244313},
{0.0007205100507816726,-0.9910010698459263,0.1338520094339127},
{0.0007019756790573353,-0.9999995428010863,0.0006493287031274866},
{0.0007515326493929235,-0.9999995334774701,0.0006068307168996666},
{0.009414477582872399,-0.9911627455231257,-0.1323169660281744},
{0.0007335048118231843,-0.9911637457221352,-0.13264196597139874},
{0.017813606895239205,-0.9653013736460514,-0.26053010084523454},
{0.0007134573910054751,-0.9653025290274916,-0.2611331431122446},
{0.025901292452161283,-0.9229427310472869,-0.38406488808049494},
{-0.0015146697896712947,-0.9192758723483458,-0.39361094534275315},
{0.03365959048932989,-0.8637507559433025,-0.5027938579333128},
{-3.84928091727279e-05,-0.8521902030745226,-0.5232321246847401},
{0.038043909479245935,-0.7837151952751225,-0.619954154471451},
{-0.004499379066220598,-0.7813228378480316,-0.624110870475044},
{-0.000707384782722009,-0.7031837840123739,-0.7110077816091804},
{0.042138113661313294,-0.6939892249935605,-0.718751233021484},
{-0.0007754557818049939,-0.6053148296786535,-0.7959857760283366},
{0.05156361786860244,-0.6054342098041924,-0.7942232752262262},
{-0.0008632827767971714,-0.4955538718739341,-0.8685767754284016},
{0.05629128893691392,-0.4957189025749633,-0.8666568296734842},
{-0.0009418362727558001,-0.3775511093388075,-0.9259882681662177},
{0.06002591508836172,-0.37774909495257136,-0.9239602322504569},
{-0.0010214400116047467,-0.25565700290456095,-0.9667670109835979},
{0.06266179882282795,-0.2558519951935338,-0.9646829818773499},
{-0.0010711702383578087,-0.1298870289025838,-0.991528220635792},
{0.06427048108017906,-0.13003096172173492,-0.9894247087350523},
{0.009987521228938775,2.9144703586180746e-05,-0.9999501230412884},
{0.07579552899196666,-6.799322600756756e-06,-0.9971233814020195},
{0.06423839990751083,0.13003699981277533,-0.9894259985754442},
{-0.001145780339001043,0.12998503845856146,-0.9915152933587768},
{0.06259497111183285,0.25585488192056866,-0.9646865547880933},
{-0.001173070471713888,0.25573810283714216,-0.9667453887466585},
{0.059933118847901735,0.37774411879381836,-0.9239682905716219},
{-0.00115099951285222,0.3775938401875944,-0.9259706080932086},
{0.0561932931916522,0.49569493994187985,-0.8666768949939149},
{-0.0010915198633876142,0.49553393797998946,-0.8685878912893225},
{0.05149038872267516,0.6053898674086882,-0.794261826042319},
{-0.0009670518366733861,0.6052328977814465,-0.796047865554464},
{0.045982124728333226,0.7032143781756406,-0.7094893815502209},
{-0.000811998158352343,0.703078137111235,-0.711112138677991},
{0.03967099249754162,0.7894528507010593,-0.612527884160575},
{-0.0006503540478955451,0.7893500581319535,-0.6139430452140443},
{0.03251780874392874,0.8637192322511789,-0.5029231352343293},
{-0.0005042509207524179,0.8636568642685309,-0.5040799207792921},
{0.024793711202238982,0.9229264169945436,-0.38417717357806885},
{-0.00034279802112879056,0.9228960568838683,-0.3850490237329846},
{0.01674859890401393,0.9652929368336648,-0.26063198294490036},
{-0.00019803705193921877,0.9652792531639903,-0.26122006851024165},
{0.00839601948016534,0.9911589386329709,-0.13241399180166474},
{-5.853271386151183e-05,0.9911542347216665,-0.13271503142910787},
{-0.0002684119484526644,0.9999998079544299,0.0005586108927212321},
{7.669408775589677e-05,0.9999998403514321,0.0005598349106231439},
{-0.008891451170376893,0.9910031304452044,0.13354301757819495},
{0.00024118510487065834,0.9910014309012887,0.13385105820031298},
{-0.017227393961465606,0.9649716617587907,0.2617879082382808},
{0.00036169181944943813,0.9649605183077017,0.26239486901683007},
{-0.02529179723858811,0.9224158992886822,0.3853689579246025},
{0.00042615983931596315,0.9223886522123426,0.38626285435916524},
{-0.02689728573852104,0.8629565424431783,0.504561732471276},
{0.004073008167392217,0.8696626087043285,0.49362977789640095},
{0.0010234598059395675,0.8016648479945904,0.5977728866549872},
{-0.03914910486200965,0.7884870979238706,0.6138040762296189},
{0.000907167044062027,0.7172250348363503,0.6968410338462786},
{-0.04566971812261342,0.7021202786146905,0.7105922819765427},
{0.004672962950558427,0.61158038615835,0.7911684995521917},
{-0.05140199941532796,0.6043079931262987,0.7950909909562375},
{-0.056326702527579445,0.49479202220307755,0.8671840389136316},
{-0.10551202836364176,0.5869571577852574,0.802713215784593},
{-0.11473303938843285,0.4754551632261628,0.8722262994397011},
{-0.16973409835143335,0.49486028674390703,0.8522344938223071},
{-0.15567007366387464,0.6043932860019925,0.781329369729052},
{-0.22201288498692073,0.514017733714724,0.8285505707719737},
{-0.20273397895803866,0.6215349354902707,0.7566989214614662},
{-0.2557779768032406,0.6044229451842812,0.7544869315748288},
{-0.2791009647044756,0.4948809374166183,0.8229188959324486},
{-0.3098109921106632,0.5870199850515363,0.7479469809535304},
{-0.336657853809052,0.4754957935198004,0.8127516470691759},
{-0.3845440369727573,0.49488304758152274,0.7792410749216953},
{-0.3526399938335608,0.6044269894306876,0.7143619875083093},
{-0.42888875580925423,0.51402770733481,0.7428525770518057},
{-0.39169098979194544,0.6215489838015014,0.6784209823193319},
{-0.4423408293602017,0.6044247668338225,0.6625747444015717},
{-0.4825728334453235,0.4948818291970098,0.7226447505871564},
{-0.49283715779194454,0.587019187946257,0.642277205638247},
{-0.5355391036602978,0.4754950920380277,0.6979271350925341},
{-0.5731229794758933,0.4948819822777816,0.653162976609581},
{-0.5255130403830511,0.6044250464470445,0.5987540460112565},
{-0.6065378642516855,0.5140268849564268,0.6065378642516855},
{-0.5539303306677017,0.6215483710321676,0.5539303306677017},
{-0.6012820647962632,0.5940070640122836,0.5344300575920565},
{-0.653162976609581,0.4948819822777816,0.5731229794758933},
{-0.6343339320536416,0.596971936055653,0.4911669473889009},
{-0.6979280217568595,0.47549501482284406,0.5355380166945946},
{-0.7226450993156521,0.49488206801337936,0.4825720663215726},
{-0.6626801167016236,0.6043171064235755,0.44233007789676637},
{-0.7428540442689023,0.5140270306324137,0.42888702555866526},
{-0.6808679702865821,0.6143909731876713,0.39867598260158116},
{-0.71118107356813,0.6038180624619627,0.3600350372438264},
{-0.7792425457710809,0.49488171152809074,0.3845427758458514},
{-0.7405261421510416,0.5961091144288185,0.3102820595615947},
{-0.812753806866555,0.47549488700887665,0.33665392000144345},
{-0.8229205123415636,0.49488170673566195,0.2790948346098455},
{-0.7557670557703204,0.6028100444831632,0.2558050188766205},
{-0.8285460899349545,0.5140270557953268,0.2220080240979733},
{-0.7596900023915042,0.6179980019454578,0.2023600006370293},
{-0.7844061090806977,0.6003960834919858,0.1556650216470129},
{-0.8522179306575864,0.4948809597330226,0.16975698618738386},
{-0.7990502806404913,0.5926912081635609,0.10117203553339563},
{-0.8721922659467257,0.47549514498681295,0.11482603501247286},
{-0.867115070427956,0.49488204019481585,0.0565970045968655},
{-0.7997431760458812,0.5987591318036617,0.04357010959100192},
{-0.857774003514729,0.5140270021062257,6.22348002550071e-10},
{-0.8010809784921776,0.5985559839296698,1.3997899624177398e-09},
{-0.7435359540078414,0.668695958637144,9.325859423139657e-10},
{-0.7300689926142425,0.6818109931024455,0.046184799532770555},
{-0.6770729301311552,0.7359159240589999,6.214769358682446e-10},
{-0.6633878529927905,0.747369834382325,0.03680879184314614},
{-0.6087919367371771,0.7933299175608495,0.00014023798542712164},
{-0.6053482773815284,0.7954463644879098,0.02861021310971706},
{-0.5529688976060924,0.8331268457289123,0.011182897929249506},
{-0.5501702684858961,0.8350474075073924,-0.0029159714230089216},
{-0.6007577459763213,0.7990696621223504,-0.024037589835974583},
{-0.6633878529927905,0.747369834382325,-0.03680879184314614},
{-0.7300689926142425,0.6818109931024455,-0.046184799532770555},
{-0.7997431760458812,0.5987591318036617,-0.04357010959100192},
{-0.867115070427956,0.49488204019481585,-0.0565970045968655},
{-0.7990502806404913,0.5926912081635609,-0.10117203553339563},
{-0.8721922659467257,0.47549514498681295,-0.11482603501247286},
{-0.8522179306575864,0.4948809597330226,-0.16975698618738386},
{-0.7844061090806977,0.6003960834919858,-0.1556650216470129},
{-0.8285459059907011,0.5140269416769644,-0.2220089748101971},
{-0.7596900023915042,0.6179980019454578,-0.2023600006370293},
{-0.7557670557703204,0.6028100444831632,-0.2558050188766205},
{-0.8229205123415636,0.49488170673566195,-0.2790948346098455},
{-0.7405261421510416,0.5961091144288185,-0.3102820595615947},
{-0.812753806866555,0.47549488700887665,-0.33665392000144345},
{-0.7792429314036374,0.49488095643587876,-0.38454296614887645},
{-0.71118107356813,0.6038180624619627,-0.3600350372438264},
{-0.7428540442689023,0.5140270306324137,-0.42888702555866526},
{-0.6808679702865821,0.6143909731876713,-0.39867598260158116},
{-0.6626801167016236,0.6043171064235755,-0.44233007789676637},
{-0.7226450993156521,0.49488206801337936,-0.4825720663215726},
{-0.6343339320536416,0.596971936055653,-0.4911669473889009},
{-0.6979276479898107,0.4754947601771458,-0.5355387298930766},
{-0.653162976609581,0.4948819822777816,-0.5731229794758933},
{-0.6012820647962632,0.5940070640122836,-0.5344300575920565},
{-0.6065378642516855,0.5140268849564268,-0.6065378642516855},
{-0.5539303306677017,0.6215483710321676,-0.5539303306677017},
{-0.5255130403830511,0.6044250464470445,-0.5987540460112565},
{-0.5731229794758933,0.4948819822777816,-0.653162976609581},
{-0.49283715779194454,0.587019187946257,-0.642277205638247},
{-0.5355391036602978,0.4754950920380277,-0.6979271350925341},
{-0.4825728334453235,0.4948818291970098,-0.7226447505871564},
{-0.4423408293602017,0.6044247668338225,-0.6625747444015717},
{-0.42888875580925423,0.51402770733481,-0.7428525770518057},
{-0.39169098979194544,0.6215489838015014,-0.6784209823193319},
{-0.3526399938335608,0.6044269894306876,-0.7143619875083093},
{-0.38454488909823137,0.4948828572770418,-0.779240775268941},
{-0.3098109921106632,0.5870199850515363,-0.7479469809535304},
{-0.336657853809052,0.4754957935198004,-0.8127516470691759},
{-0.2791009647044756,0.4948809374166183,-0.8229188959324486},
{-0.25577793841993407,0.6044218544818296,-0.7544878183525527},
{-0.22201193427681773,0.5140178478330059,-0.8285507547204278},
{-0.20273397895803866,0.6215349354902707,-0.7566989214614662},
{-0.15567007366387464,0.6043932860019925,-0.781329369729052},
{-0.16973409835143335,0.49486028674390703,-0.8522344938223071},
{-0.10551202836364176,0.5869571577852574,-0.802713215784593},
{-0.11473303938843285,0.4754551632261628,-0.8722262994397011},
{-0.056326702527579445,0.49479202220307755,-0.8671840389136316},
{-0.05140199941532796,0.6043079931262987,-0.7950909909562375},
{-0.04566981791408002,0.7021202754081223,-0.710592278731283},
{-0.0391491978700167,0.7884879571008789,-0.6138029666049335},
{-0.0318204028958929,0.862977078537321,-0.5042400458895877},
{-0.023973292278169158,0.9224127028895834,-0.38546087584251487},
{-0.01585329800797862,0.9649688787483438,-0.26188496709325376},
{-0.007460592383136852,0.9910013165555277,-0.13364404268991348},
{0.001218880047075757,0.9999990386221037,-0.0006611250255340638},
{0.009833826774591546,0.991158674908696,0.13231695660120518},
{0.018135904206062977,0.9652932238699569,0.2605380604237582},
{0.021291998050802834,0.9229119155111095,0.38442196480770835},
{0.03251780874392874,0.8637192322511789,0.5029231352343293},
{0.039671123658611404,0.7894524708046434,0.612528365292667},
{0.04598209239303571,0.7032148836649176,0.70948888262699},
{0.051490488457526525,0.6053898642915098,0.7942618219526307},
{0.05619342073064009,0.49569418286941014,0.8666773197309464},
{0.059933118847901735,0.37774411879381836,0.9239682905716219},
{0.06259497111183285,0.25585488192056866,0.9646865547880933},
{0.06423839990751083,0.13003699981277533,0.9894259985754442},
{0.07579552899196666,-6.799322600756756e-06,0.9971233814020195},
{0.06427048108017906,-0.13003096172173492,0.9894247087350523},
{0.06266179882282795,-0.2558519951935338,0.9646829818773499},
{0.06002589241360375,-0.3777499522579223,0.9239598832249634},
{0.05629128893691392,-0.4957189025749633,0.8666568296734842},
{0.05156351813444778,-0.6054342129260283,0.7942232793215263},
{0.042138113661313294,-0.6939892249935605,0.718751233021484},
{0.038043709768661706,-0.7837152012382262,0.6199541591885358},
{0.03365970729988098,-0.8637511873242927,0.5027931090422392},
{0.02590169218368781,-0.9229427214850522,0.38406488410135464},
{0.017814706546575486,-0.9653013547304116,0.26053009573999625},
{0.009415067530422908,-0.9911627400174997,0.13231696529319142},
{0.0007019756790573353,-0.9999995428010863,-0.0006493287031274866},
{-0.008060771651998923,-0.9910012030987839,-0.13361002738244313},
{-0.016508905234609753,-0.9649763059727043,-0.26181708301642276},
{-0.02464880310467174,-0.9224391161870069,-0.3853550485378915},
{-0.03247611088818292,-0.8630372893483123,-0.5040951690067024},
{-0.03974391530856007,-0.7885833037464927,-0.6136422363626977},
{-0.04617071812562351,-0.7022372756831384,-0.71044427890503},
{-0.05179098187468735,-0.6044237884695416,-0.794977721781298},
{-0.05660219488030793,-0.49487995523790224,-0.8671159215690043},
{-0.06044870076501791,-0.3771460047730298,-0.9241790116960908},
{-0.06320642767449923,-0.25545211184794864,-0.9647534224106445},
{-0.06491056738392935,-0.12982093476795917,-0.9894105028439256},
{-0.07641709530214455,2.1427398682718557e-06,-0.9970759387032625},
{-0.06486792196378229,0.1298130439537039,-0.989414335008127},
{-0.06310421423458833,0.2554290576178236,-0.9647662176249258},
{-0.060270370434824236,0.3770948150189819,-0.9242115466349946},
{-0.12686005878036813,0.23479810879325932,0.9637304465426784},
{-0.06310431383639567,0.25542905600595694,0.9647662115368383},
{-0.060270370434824236,0.3770948150189819,0.9242115466349946},
{-0.12187303454528216,0.3570871012174245,0.9260862625019666},
{-0.188667062446261,0.25545708455286026,0.9482333138524777},
{-0.19340004258205246,0.12982802858501916,0.9724922141194693},
{-0.1297539498436204,0.10852195805084523,0.9855896190204064},
{-0.13053201251819538,6.109200585880543e-06,0.9914440950808207},
{-0.12976194187230772,-0.108512951390929,0.9855895584988499},
{-0.12688403928400252,-0.23479807269478598,0.9637272983753183},
{-0.12192393490110985,-0.35710280933196936,0.9260735055412421},
{-0.1148289954567909,-0.47549498118704153,0.8721919654917257},
{-0.10567100669896086,-0.5870190372137796,0.8026470508834102},
{-0.09488088805474315,-0.6867309135423654,0.7206929092666385},
{-0.08249218602723385,-0.7749718687330132,0.6265888938665526},
{-0.06908215815743858,-0.8581264802390239,0.5087696918418931},
{-0.04974710683695903,-0.9224381267746423,0.3829270526273132},
{-0.03356169560724605,-0.9649758736982292,0.2601829659457089},
{-0.01676460328405903,-0.9910011941296412,0.1327990260143251},
{0.0006546787034509978,-0.9999995470314424,0.0006908926870471944},
{0.01802410442446929,-0.9911622433056757,-0.13142503226157623},
{0.034771186459990666,-0.9653006241089018,-0.25881589921627507},
{0.046563813194267174,-0.9279262629360912,-0.3698441047985892},
{0.06323069391191229,-0.8748529157658891,-0.48024395376031587},
{0.07784002593684586,-0.8027192674717235,-0.5912551970104033},
{0.08841723633521044,-0.7098352917079946,-0.6987962871714973},
{0.10339405107470936,-0.6055012991062111,-0.7890993898002019},
{0.11287903707885082,-0.49582816287114917,-0.8610532828414119},
{0.12038505132051948,-0.3778951610978752,-0.9179883913412886},
{0.12571006994962794,-0.255998142446622,-0.9584685333265451},
{0.12896098149713103,-0.13013398132883316,-0.9830738589520135},
{0.14094407951170854,-1.7383709806786298e-05,-0.9900175585051024},
{0.12895602738665235,0.13010602763088022,-0.9830782087783075},
{0.12569797967074167,0.25597295860124075,-0.9584768449845938},
{0.12036797234227178,0.37787291317369454,-0.9179997890652457},
{0.11286497406487345,0.49580788606881476,-0.8610668021363433},
{0.10339504964772987,0.6054802907365684,-0.789115378913568},
{0.09230037769200933,0.7032828300242404,-0.7048928296351211},
{0.07960275975584631,0.7895006008582665,-0.6085656923321336},
{0.06524458154158759,0.8637477556362242,-0.4996828586342028},
{0.04972990153968726,0.9229400285751421,-0.3817180118183697},
{0.03358740206018816,0.9652990592096313,-0.25897801588522507},
{0.016835604264052013,0.9911612510372103,-0.13159003332857783},
{-0.0005343028514067541,0.9999997218932967,0.000520320855295242},
{-0.017854305740887873,0.9910033186480065,0.13264104264950788},
{-0.03456388693289672,0.9649766351842782,0.2600489016868136},
{-0.0506826712333022,0.9224304764427741,0.3828227827157285},
{-0.06457756972372536,0.8580945976945584,0.509414761168138},
{-0.08219090518658285,0.7749180489005038,0.6266950395470247},
{-0.09464842217595944,0.6866661608846781,0.7207851688787019},
{-0.139174954894657,0.702205772421466,0.6982387737071344},
{-0.18026001610298847,0.7174060640873214,0.6729300601141909},
{-0.2284590104700482,0.7022350321827301,0.6742940309022218},
{-0.27817400032699346,0.6867330008072546,0.6715780007894399},
{-0.31523994679758915,0.7022398814843896,0.638343892267987},
{-0.34832522901520524,0.7174204716861796,0.603305396658346},
{-0.3952080025917741,0.7022380046052769,0.5921760038834902},
{-0.44251615345887596,0.6867312381495072,0.5766971999911266},
{-0.4697127648942589,0.7022376485083756,0.5350067322126123},
{-0.4926001129135645,0.717419164446481,0.4926001129135645},
{-0.5466258815513773,0.6867238511934814,0.4791768961669301},
{-0.5654063257677122,0.7020974045244187,0.43286824940382324},
{-0.5929980775508112,0.7017150917685514,0.394904051644568},
{-0.6185618444363549,0.7009448237176561,0.3550459107086275},
{-0.6419500621134862,0.6996570676970719,0.3136560303485748},
{-0.6629539241895658,0.6978419202000363,0.27112496899618377},
{-0.6816252475615635,0.6954902525972373,0.22733308256579926},
{-0.6861930700500232,0.7055590720270015,0.17699001806802692},
{-0.7128161357797254,0.6878041310153507,0.13718102613072447},
{-0.72339235459653,0.6843343354508505,0.09159704489955425},
{-0.18425605191821467,5.989951687801265e-06,0.982878276947676},
{-0.19339507940590858,-0.1298190533022862,0.9724943992955849},
{-0.1886590032839873,-0.25545300444667046,0.9482360165059445},
{-0.18081597782102313,-0.37714795373884624,0.9083308885836859},
{-0.1697570468476889,-0.4948821365721472,0.8522172351855706},
{-0.15572998712315508,-0.6044249500219162,0.7812929353972338},
{-0.13928004086720738,-0.7022372060487156,0.6981862048600808},
{-0.12043297737197044,-0.7885828518339705,0.6030198866992071},
{-0.10387698318699223,-0.8630248603151225,0.4943659199844105},
{-0.07462981004468652,-0.9224391241543003,0.3788620509923653},
{-0.05046882335583021,-0.9649764465692786,0.2574361191356146},
{-0.025394108614231487,-0.9910013361691108,0.13142104458086393},
{0.0006092257236717955,-0.9999995464274266,0.0007321126679336225},
{0.026561705642877055,-0.9911622105665415,-0.12996902761115017},
{0.051586084876530096,-0.9653007170032116,-0.25599492495007997},
{0.0709322103661106,-0.9229351348787472,-0.3783640552945357},
{0.0976227925234201,-0.8637569338479513,-0.49436196213858863},
{0.11910602996874839,-0.7895201986543602,-0.6020561514857755},
{0.1381130599301701,-0.7033173051842145,-0.6973303025863279},
{0.1547270068951771,-0.6055380269848945,-0.7806300347876073},
{0.1689129393417697,-0.49590082191733575,-0.8517926941132065},
{0.18014599556831845,-0.3780019907009621,-0.9081089776600653},
{0.1881330677447545,-0.2561060922211313,-0.9481643414240851},
{0.19301099479661663,-0.13020599648977657,-0.9725189737818613},
{0.20544493222745194,-1.3332195601951058e-05,-0.9786686771549962},
{0.19301998769256343,0.13017799169952607,-0.9725209379896357},
{0.18814899238128302,0.2560809896305127,-0.9481679616058355},
{0.18016798907128034,0.3779819770721809,-0.9081129449152325},
{0.16893997008335254,0.49588791218594486,-0.8517948491603484},
{0.15476201211902674,0.6055290474174677,-0.780630061129191},
{0.1381569959275463,0.7033109792685026,-0.6973279794448635},
{0.11915997608525057,0.7895168415483281,-0.6020498791719125},
{0.09768760214698986,0.8637570189837556,-0.494349010864862},
{0.07447339699821723,0.9229449627990611,-0.3776589847777827},
{0.050324575048624934,0.9653015213948595,-0.25624287295248843},
{0.025264906354819407,0.9911622493045891,-0.13022703275568348},
{-0.0007188307378350453,0.9999996352898599,0.00046119683179677754},
{-0.026647896475757164,0.991002868937694,0.131160982653672},
{-0.051651321928271474,0.9649784096760304,0.2571941091902789},
{-0.07575219909806252,0.922437989017066,0.3786419954917294},
{-0.09892974656874882,0.8630265338855188,0.49537673245055674},
{-0.1202879785415287,0.7885598593268479,0.6030788924152582},
{-0.2558620129051685,0.1510720076197701,0.9548360481600218},
{-0.24878400583721919,0.2759970064757178,0.9284030217831203},
{-0.18081499514855293,0.37714098988093026,0.9083339756284914},
{-0.23756306683279552,0.39701711169145015,0.8865332494053312},
{-0.2975839590790838,0.37714894813806316,0.877041879397541},
{-0.3107439791869905,0.25545598289006977,0.9155219386801735},
{-0.31877095314529547,0.12982298091790562,0.9388988619954913},
{-0.2588241246545283,3.303031590801652e-06,0.9659244652072475},
{-0.3574559176990015,0.35710491777981607,0.8629608013110649},
{-0.37198887750017695,0.2347999226779328,0.8980497042628516},
{-0.3804258691917286,0.10851696268677434,0.9184226842031695},
{-0.33187689621233774,9.462397040830261e-07,0.9433227049952576},
{-0.31876684378340564,-0.1298209363792535,0.9389005398773503},
{-0.2558500145081034,-0.15106700856633049,0.9548400541446842},
{-0.43236002961644276,1.3820100946669907e-07,0.9017010617660655},
{-0.43850294801350537,0.12982198460902045,0.8893038945690277},
{-0.4276530387774411,0.25545502316338525,0.8670960786239406},
{-0.49426207298669717,0.15106802230791438,0.8560861264165355},
{-0.500000174843837,1.382100483303334e-07,0.8660253028382678},
{-0.43850219722495837,-0.12982105838956565,0.8893043999820853},
{-0.38042419992038784,-0.10851605702731902,0.9184234826495763},
{-0.3826849586956275,4.519799512164044e-07,0.9238789002828898},
{-0.37198604590345286,-0.23479902897443677,0.898051110820412},
{-0.3107360569521758,-0.25545404682000517,0.9155251677988414},
{-0.2487659400383357,-0.27599393347539625,0.9284087762196249},
{-0.4805799618013436,0.27599497806267803,0.832387933838064},
{-0.4097500886902114,0.377149081633739,0.830580179778684},
{-0.45890605485029057,0.39702004745342695,0.7948460950031904},
{-0.5144309721914058,0.37714797961251223,0.7701429583683833},
{-0.5371029627629215,0.2554549822894344,0.8039049442656742},
{-0.5509098421706883,0.12982096280779243,0.8244057638172632},
{-0.5647168245667891,1.1329996480257758e-07,0.825284743619552},
{-0.5509091456719665,-0.12982103432741224,0.8244062179903453},
{-0.49426207298669717,-0.15106802230791438,0.8560861264165355},
{-0.4276511429796241,-0.2554540854077668,0.867097289902755},
{-0.5686229684999943,0.35710398021751133,0.7410429589484443},
{-0.59174309268887,0.23479903677821962,0.7711741207944103},
{-0.6051663558270288,0.10851606380551099,0.788668463722997},
{-0.6087613233345313,-1.680920892796155e-08,0.7933534213778812},
{-0.6051663558270288,-0.10851606380551099,0.788668463722997},
{-0.59174309268887,-0.23479903677821962,0.7711741207944103},
{-0.5371029627629215,-0.2554549822894344,0.8039049442656742},
{-0.48057919275794997,-0.27599511070028115,0.8323883338668657},
{-0.4097478983554905,-0.37714790644243906,0.8305817939609224},
{-0.35745106727479936,-0.3571040672094915,0.8629631624157232},
{-0.2975748243349376,-0.37714777736124694,0.8770454822604712},
{-0.2375459951485982,-0.3970189918916812,0.8865369818942554},
{-0.6510041479433134,-1.494060339531227e-08,0.7590741725026615},
{-0.6537289158056047,0.12982098328022681,0.7455099039850401},
{-0.6375004361126038,0.2554541747556221,0.7268674972484078},
{-0.6989915901282274,0.15106791141742834,0.6989915901282274},
{-0.7071067811865474,2.5213992197556526e-08,0.7071067811865474},
{-0.6537289158056047,-0.12982098328022681,0.7455099039850401},
{-0.6796420895928048,0.27599503638263406,0.6796420895928048},
{-0.6107560860127856,0.3771480531137641,0.6962300980500917},
{-0.6489899589315922,0.3970189748764416,0.6489899589315922},
{-0.6962300980500916,0.37714805311376404,0.6107560860127856},
{-0.7268679689118576,0.2554539890742331,0.6374999727341267},
{-0.7455099039850401,0.12982098328022681,0.6537289158056047},
{-0.7590741725026589,8.590861952307932e-08,0.6510041479433111},
{-0.7455099039850401,-0.12982098328022681,0.6537289158056047},
{-0.6989915901282274,-0.15106791141742834,0.6989915901282274},
{-0.6375004361126038,-0.2554541747556221,0.7268674972484078},
{-0.7410429589484443,0.35710398021751133,0.5686229684999943},
{-0.7711739397231193,0.23479998164744717,0.5917429537478932},
{-0.788668463722997,0.10851606380551099,0.6051663558270288},
{-0.7933537919679858,-1.4941496082063818e-08,0.6087608403716663},
{-0.788668463722997,-0.10851606380551099,0.6051663558270288},
{-0.7711739397231193,-0.23479998164744717,0.5917429537478932},
{-0.7268673115666519,-0.2554551094990679,0.6375002732600881},
{-0.6796420895928048,-0.27599503638263406,0.6796420895928048},
{-0.6107560860127856,-0.3771480531137641,0.6962300980500917},
{-0.5686229684999943,-0.35710398021751133,0.7410429589484443},
{-0.5144309721914058,-0.37714797961251223,0.7701429583683833},
{-0.45890508287941273,-0.3970190717026434,0.7948471435513942},
{-0.38454307549792627,-0.494882097160954,0.7792421529897957},
{-0.33665392000144345,-0.47549488700887665,0.812753806866555},
{-0.27909506428271763,-0.49488211398398346,0.822920189539526},
{-0.2220080240979733,-0.5140270557953268,0.8285460899349545},
{-0.8252847436195571,-1.4940595358600184e-08,0.5647168245667926},
{-0.8244057638172632,0.12982096280779243,0.5509098421706883},
{-0.80390514962686,0.25545404754638906,0.5371030999683238},
{-0.8560861264165355,0.15106802230791438,0.49426207298669717},
{-0.866025302838276,-1.400780489835513e-08,0.5000001748438416},
{-0.8244056567917524,-0.12982194595383692,0.550909770650801},
{-0.832387933838064,0.27599497806267803,0.4805799618013436},
{-0.7701429583683833,0.37714797961251223,0.5144309721914058},
{-0.7948471435513942,0.3970190717026434,0.45890508287941273},
{-0.8305817939609222,0.377147906442439,0.4097478983554904},
{-0.8670970683987873,0.2554550201509314,0.42765103373418406},
{-0.8893044936688501,0.12982192608506354,0.4385017503362492},
{-0.9017010617660739,-1.4940601023423733e-08,0.4323600296164469},
{-0.8893046091195845,-0.12982094293916438,0.4385018072631505},
{-0.8560861264165355,-0.15106802230791438,0.49426207298669717},
{-0.8039049442656742,-0.2554549822894344,0.5371029627629215},
{-0.8629634177100209,0.35710375904199865,0.3574507588078584},
{-0.8980516383861098,0.23479890545471777,0.3719848502147504},
{-0.9184239885376094,0.10851599864566608,0.38042299525213086},
{-0.9238797538373535,-1.6809195521282897e-08,0.3826828980362601},
{-0.9184239885376094,-0.10851599864566608,0.38042299525213086},
{-0.8980514448826723,-0.23479911631634123,0.37198518427648414},
{-0.8670972899027551,-0.2554540854077669,0.4276511429796241},
{-0.8323883338668657,-0.27599511070028115,0.48057919275794997},
{-0.7701429583683833,-0.37714797961251223,0.5144309721914058},
{-0.7410429589484443,-0.35710398021751133,0.5686229684999943},
{-0.6962296728233035,-0.3771478227682853,0.6107567129893029},
{-0.6489899589315922,-0.3970189748764416,0.6489899589315922},
{-0.5731229794758933,-0.4948819822777816,0.653162976609581},
{-0.5355387298930766,-0.4754947601771458,0.6979276479898107},
{-0.4825728334453235,-0.4948818291970098,0.7226447505871564},
{-0.42888702555866526,-0.5140270306324137,0.7428540442689023},
{-0.35263791309345494,-0.604424851041327,0.7143648239469539},
{-0.3098100382359828,-0.5870190724484309,0.7479480923098895},
{-0.25577992272250255,-0.6044248173881798,0.7544847720513228},
{-0.2027530144155371,-0.6215480441914459,0.7566830537994104},
{-0.943323754334,-1.6185695784824537e-08,0.33187391357141544},
{-0.9389007172777892,0.12982196090795212,0.3187659040130661},
{-0.9155251677988414,0.25545404682000517,0.3107360569521758},
{-0.9548403984893556,0.1510680630461543,0.25584810677464775},
{-0.9659258492011169,-1.4941597667340367e-08,0.2588189595935754},
{-0.9389007172777892,-0.12982196090795212,0.3187659040130661},
{-0.9284083819263977,0.27599511353820316,0.2487661023367983},
{-0.8770452514690817,0.3771481081370525,0.2975750853216334},
{-0.886536771300582,0.39701889758124675,0.2375469387201429},
{-0.908331052823994,0.37714802193304386,0.18081501051529725},
{-0.9482358898292196,0.255454970319966,0.18865697808089027},
{-0.9724948270952974,0.12982197691830363,0.19339096561605632},
{-0.9828793975055036,-1.494060604242305e-08,0.18425007451618056},
{-0.9724948270952974,-0.12982197691830363,0.19339096561605632},
{-0.9548403984893556,-0.1510680630461543,0.25584810677464775},
{-0.9155254522852491,-0.2554541261987122,0.31073515350848624},
{-0.9260737393783455,0.35710389950151356,0.12191896568877704},
{-0.9637277729876855,0.23479994469135335,0.12687697011330848},
{-0.985590132866922,0.10851601462899066,0.12975501749221022},
{-0.991444888610677,-1.6809198111478286e-08,0.13052598533534107},
{-0.985590132866922,-0.10851601462899066,0.12975501749221022},
{-0.9637277729876855,-0.23479994469135335,0.12687697011330848},
{-0.9482359531685238,-0.2554539873836388,0.18865799068255937},
{-0.9284087762196249,-0.27599393347539625,0.2487659400383357},
{-0.8770457432466503,-0.37714788959072576,0.2975739128858449},
{-0.8629634705831699,-0.3571031947321748,0.357451194921943},
{-0.8305817939609222,-0.377147906442439,0.4097478983554904},
{-0.7948471435513942,-0.3970190717026434,0.45890508287941273},
{-0.7226450993156521,-0.49488206801337936,0.4825720663215726},
{-0.6979276479898107,-0.4754947601771458,0.5355387298930766},
{-0.653162976609581,-0.4948819822777816,0.5731229794758933},
{-0.6065378642516855,-0.5140268849564268,0.6065378642516855},
{-0.5255130403830511,-0.6044250464470445,0.5987540460112565},
{-0.4928368412538292,-0.5870188109171623,0.6422777931178603},
{-0.4423389276063747,-0.6044249010792244,0.662575891562176},
{-0.39168816204593054,-0.6215482571417149,0.6784232806715711},
{-0.3152380047416525,-0.702237010562698,0.6383480096017117},
{-0.2781769634293288,-0.6867309097185835,0.6715789117105484},
{-0.22847303721060697,-0.7022371143709103,0.6742871098187905},
{-0.18030405885188547,-0.7174192341681873,0.6729042196383282},
{0.8482231570188442,0.5125650948834964,0.1333960246936074},
{0.8142659062584572,0.5490639367895669,0.1884139783090304},
{0.7743800045018582,0.5833980033915843,0.24491300142380173},
{0.7304302127067871,0.6126431784063143,0.3018940879138354},
{0.6844807892148579,0.6347808045199161,0.35852388959294373},
{0.6383510383760697,0.6488420390067624,0.4141400248970637},
{0.5933312339781416,0.6553152584213294,0.4674611843417183},
{0.5494398727321582,0.6554998481652767,0.5181078799896495},
{0.5065150096536697,0.6509040124055797,0.5654790107774645},
{0.46599003125535043,0.6432450431443761,0.6075270407486626},
{0.42908782797679335,0.6343127457012168,0.6430637421929036},
{0.3950687786961621,0.6255486495893262,0.6727626231416944},
{0.36336793288576735,0.6180638858433017,0.6971088712436548},
{0.33067597598465814,0.6125449555139242,0.7179429478593953},
{0.29331204520217613,0.6087860938197278,0.737121113597375},
{0.2512650290017651,0.6064520699985213,0.7543750870722408},
{0.204490944696045,0.605141836341228,0.7694067919162696},
{0.15477695217594123,0.6044308132387651,0.7814777585335689},
{0.10836299449505166,0.6144519687852263,0.7814769603001899},
{0.06174230163079048,0.6040830159555574,0.7945260209857008},
{0.7870550176748947,0.6022850135255148,0.13340600299589866},
{0.739675978939206,0.6468629815818705,0.1856009947153829},
{0.6866107380079308,0.6859287382681635,0.24097190805164365},
{0.6306383208045342,0.7163223643918468,0.29862615191056485},
{0.5753978978168226,0.7360968692787769,0.3564809366936255},
{0.5240851442182939,0.7459022052581429,0.41105311311402226},
{0.4767168835118601,0.7479148172432971,0.46191388712904585},
{0.4329889957995738,0.7443589927789734,0.5083799950682057},
{0.39423384793201005,0.737518715516592,0.5483117884994605},
{0.36135109281466615,0.7294311873577071,0.5808231491870587},
{0.3332949276931731,0.7215348434662796,0.6068788683403747},
{0.30931590399067815,0.714851778115404,0.6271448053389862},
{0.2849180247069525,0.7099100615605636,0.6440880558527422},
{0.25535895907030326,0.7064538867674608,0.6600868941993008},
{0.22060404278726126,0.7042431365914907,0.6748151308837814},
{0.18057696979498306,0.70296288241576,0.6879208849318271},
{0.1372300138077416,0.7022560706592538,0.6985730702886794},
{0.0927083502226815,0.7019663802746339,0.7061503825412239},
{0.04707392793576697,0.7019474165668835,0.710671421744097},
{0.04069810285438983,0.7883370552905692,0.6138960430560272},
{0.03347250731800721,0.8628601886448786,0.5043331102610361},
{0.025673287688443434,0.9223385576950073,0.38552881512068604},
{0.017516696035307464,0.9649357815984427,0.26190094072188597},
{0.008989832107695923,0.9909952323421154,0.1335950313217977},
{8.260008733524361e-05,0.9999998466738371,0.0005475669160436529},
{-0.008823464147737773,0.9911474659190217,-0.1324720622725233},
{-0.01744039723339373,0.9652558468794694,-0.26072395864081943},
{-0.02577000286668105,0.9228431026579953,-0.38431304275136957},
{-0.03381470302945786,0.8635500773654161,-0.5031280450752209},
{-0.041252780626093215,0.7891786293710878,-0.6127767122162743},
{-0.047864301338896395,0.7028620196609874,-0.7097140198526567},
{-0.05362861026060317,0.6050121157551762,-0.794408151991759},
{-0.0584808031679742,0.49536002683423797,-0.8667170469510864},
{-0.06219552795272123,0.37748316965338435,-0.923925415242549},
{-0.06474459496629699,0.25568798012100696,-0.9645889250060306},
{-0.059641191130089956,0.14270397877689175,-0.9879668530683753},
{-0.06199317924385897,0.009572656794947173,-0.9980306658460575},
{-0.06605099792104487,-0.12970699591747237,-0.9893499688602102},
{-0.06441957067949833,-0.2554468837336123,-0.9646745609293609},
{-0.061739682392428843,-0.37733689238710133,-0.9240157364794861},
{-0.057957076173810025,-0.4953557963589248,-0.8667546436766282},
{-0.05312242184055089,-0.605139248794654,-0.7943453265841226},
{-0.04745287984594978,-0.7030457014044581,-0.709559698637852},
{-0.0409928987012546,-0.7893549749914943,-0.6125669805925277},
{-0.03374190524570916,-0.8636781342723318,-0.5029130781857374},
{-0.029430907357186082,-0.9229092307103504,-0.38389109596572046},
{-0.01641070262731686,-0.96530115454256,-0.2606230417251672},
{-0.007964846052378268,-0.9911645087485018,-0.13239893437903164},
{0.0007875516308769619,-0.9999995313032816,0.0005631657360459438},
{0.009489525774212528,-0.9910005586968365,0.133520940541695},
{0.017882395258959554,-0.964975744162403,0.2617289306095505},
{0.025970694957264288,-0.9224388208898455,0.38526892519224565},
{0.027613798820732862,-0.8630249631438983,0.5044059784589799},
{0.039742992341784446,-0.7885828480452257,0.6136428817550168},
{0.046169188521818526,-0.7022368254159975,0.7104448233753966},
{0.05178517769553221,-0.6044217396686499,0.7949796575931771},
{0.05658768506605097,-0.4948748693985084,0.8671197711600598},
{0.06041980939129218,-0.377138058620074,0.9241841436496309},
{0.06316796943387976,-0.2554498763912833,0.9647565331674507},
{0.7165309709163669,0.6872929721031226,0.11921299516120425},
{0.6530398154362808,0.737386791597931,0.172625951212029},
{0.5849248779993063,0.7770948379174609,0.23234995153761387},
{0.5182492160607344,0.8031503348374601,0.2938831225213687},
{0.4589178297029677,0.8164696970212152,0.35038786997669175},
{0.4068429230588908,0.8205808448138168,0.40140492408731143},
{0.3614350089793108,0.8186720203386786,0.446252011086462},
{0.32360708133589944,0.8136522045045913,0.48295812138743394},
{0.2870350144042785,0.8121280407550225,0.507995025492715},
{0.2680879800322718,0.8007519403583963,0.5356539601034231},
{0.2517979666047933,0.7964068943749498,0.5498489270751913},
{0.23391703853853704,0.7932711306938093,0.5621420926146038},
{0.21082703756411075,0.7910601409471532,0.574261102318981},
{0.18767997302804387,0.7816998876599631,0.5947449145277277},
{0.15380895956932078,0.7890507925877688,0.5947618436591381},
{0.11742997727542273,0.7885338474060988,0.6036758831790691},
{0.07971051806765637,0.7883331786882499,0.6100631382805107},
{0.0651727253207072,0.8628213352206967,0.5012901947597278},
{0.04962608799293944,0.9222897768514575,0.3832999072603667},
{0.03351108783961243,0.9649026498594658,0.26046090548484807},
{0.016753499270726478,0.990983956862841,0.13292899421365087},
{-0.0007169676611886453,0.9999995274386656,0.0006565666897318225},
{-0.018238498074313363,0.9911378953520736,-0.13157898610741442},
{-0.03520860561288664,0.9652211538736575,-0.25905304129772616},
{-0.05162242070248527,0.9227673700635813,-0.3818841531495607},
{-0.06746000156652245,0.8634090200496528,-0.49997401161014665},
{-0.08208786379530303,0.7889706520259869,-0.6089227314357816},
{-0.09501768632798734,0.7026408988976091,-0.7051718985334258},
{-0.10621195406307427,0.60487473839022,-0.7892056586666534},
{-0.10893902600173323,0.5068041209647823,-0.8551502041085578},
{-0.1214840174775424,0.3975770571982226,-0.9094911308457699},
{-0.12668603653619487,0.2766130797750854,-0.9525942747277522},
{-0.12536795813657425,0.13945195343358394,-0.982260671999151},
{-0.13078495547616717,0.00044014185016011897,-0.9914106624886826},
{-0.1340040038333186,-0.13884400397177163,-0.98120602806838},
{-0.12588604399491413,-0.2760820964857401,-0.9528543330054962},
{-0.12043601562272008,-0.39726205153204214,-0.9097681180133084},
{-0.10784302052376894,-0.5067820964464701,-0.8553021627738531},
{-0.10501901293865824,-0.6050080745388143,-0.7892630972395874},
{-0.09386153173720563,-0.7028892376664844,-0.7050792384069848},
{-0.0810507068918031,-0.7892280671086613,-0.6087280517606081},
{-0.06660163702760466,-0.8636074801280836,-0.4997462778371288},
{-0.05448439897982432,-0.9228819827197918,-0.3812089928621743},
{-0.03341758836600682,-0.9652966639417937,-0.2590089098286849},
{-0.01660409171965103,-0.9911645057129211,-0.13159493437449046},
{0.000816509619992616,-0.9999995345955542,0.0005139267608160893},
{0.018182602987922302,-0.9910001628497025,0.13262002179326693},
{0.034925905428327665,-0.964975149980401,0.2600060404112067},
{0.051059092709737054,-0.9224378682934957,0.3827549453499064},
{0.0649511120853503,-0.858126159670172,0.509314094767265},
{0.08248960371973843,-0.7749720349461403,0.6265890282550428},
{0.09487662031813593,-0.6867291470652739,0.7206951543392044},
{0.10566504457892939,-0.5870142476549062,0.8026513386298421},
{0.11482296505197097,-0.47548585527900744,0.8721977345340131},
{0.12192405739106946,-0.3570951680888418,0.9260764359149308},
{0.1202629353084799,-0.24307086924796087,0.962524482241376},
{0.18359105399468773,-0.2642920777291044,0.946807278458902},
{0.2345439732460396,-0.38570995600283925,0.8923098982160004},
{0.2791381017048233,-0.49491918032532095,0.8228832998200536},
{0.30283096224515776,-0.5940329259401376,0.7452639070857187},
{0.2781791569972669,-0.6867373875771792,0.6715713790178682},
{0.24185312705648535,-0.7749644071241709,0.5838983067484285},
{0.2724131868872241,-0.7885775409982876,0.5513043782186393},
{0.29879492817120185,-0.801818807246791,0.5175018755951516},
{0.3412590304875712,-0.7885990704522612,0.511521045698525},
{0.37716492520461964,-0.7804868452220594,0.4985849011258873},
{0.4003309028032716,-0.7886148085314453,0.46671388668608255},
{0.4273250646040765,-0.7943691200947185,0.43170706526655833},
{0.4619489129425019,-0.7886678513700368,0.4057169235398129},
{0.4932750322823856,-0.780546051082838,0.38396302512846103},
{0.5074187006958694,-0.7886535348077235,0.3472057951984653},
{0.6276537024901944,0.7722776339380014,0.09817375346533574},
{0.5457399506252717,0.8223609255985432,0.1609049854424439},
{0.466320895179002,0.8549548078207151,0.22714994894055876},
{0.39833907565515364,0.8715511655306781,0.28587505429525367},
{0.3413229880376535,0.8775979692428246,0.33663098820209403},
{0.2864700510849197,0.8811681571347663,0.3761350670744799},
{0.2514451351349496,0.8743784699199705,0.4150152230429363},
{0.21963087492058178,0.8772495004078676,0.42684375691318993},
{0.20956391208366126,0.869368635282112,0.4475278122529478},
{0.20398605565801084,0.861028234933308,0.4658541271092476},
{0.1888430480081579,0.86582522011228,0.4633411177917523},
{0.17420297723045294,0.8646208869880051,0.47125793840329266},
{0.15499799266944764,0.8588189593825878,0.48826797690761076},
{0.12451499389023617,0.8631039576487844,0.48943597598411137},
{0.09552282811023083,0.8628832539272331,0.4962941460482618},
{0.0723017070829326,0.9222630903481753,0.3797410372007838},
{0.0483792267065587,0.9648595326269042,0.2582741425738694},
{0.023572695180818844,0.9909617974086381,0.1320569730023881},
{-0.002290219569877096,0.9999968121920108,0.0010632498003125563},
{-0.02828720848197957,0.9911242971907266,-0.1298940389490036},
{-0.05350191068313927,0.9651711927231783,-0.2560900511354762},
{-0.07791192341804448,0.9226642773258847,-0.3776511135108747},
{-0.10145905951331456,0.8632395063544304,-0.49449329005723947},
{-0.12317397932611153,0.7887608676120208,-0.602232898919432},
{-0.1422789570441397,0.7025037879050059,-0.6973127894722355},
{-0.15869996810115092,0.6050008783942307,-0.7802488431692179},
{-0.16261100060409986,0.495600001841154,-0.853193003169612},
{-0.18206296768573776,0.3787689327724975,-0.9074068389448281},
{-0.18882289427535315,0.25738985588372787,-0.9476794693806722},
{-0.19253006710752177,0.13155804585535424,-0.9724323389471854},
{-0.1935068913811448,0.0009569664628377267,-0.9810984492920142},
{-0.20214892034596263,-0.13024394867914044,-0.9706556175263331},
{-0.1875678947961984,-0.2562498562735959,-0.9482374681489251},
{-0.18032796128494333,-0.37799491884733466,-0.9080758050429562},
{-0.16071703907947782,-0.495389120457347,-0.8536742075768845},
{-0.15645203156380943,-0.6050351220643356,-0.780676157499479},
{-0.1399399958833852,-0.7027529793271159,-0.6975349794806138},
{-0.12085698171083521,-0.7890718805905504,-0.6022949088553207},
{-0.09925950826919831,-0.8635090719379723,-0.49446904119366125},
{-0.07938032076438284,-0.9228392413972017,-0.3769170985943475},
{-0.050313593445221946,-0.9652858742440317,-0.2563039666091109},
{-0.025187806119669913,-0.9911622408143733,-0.13024203164381362},
{0.0008387806183079342,-0.999999544944311,0.00045448679318310506},
{0.026799290351044676,-0.9910006431949947,0.13114695278117175},
{0.051824414451204746,-0.9649752690827352,0.25717107171198844},
{0.0759328934552527,-0.9224379204939674,0.37860596736749685},
{0.09910055524890678,-0.8630356102767845,0.4953267763240107},
{0.12042908008018643,-0.7885815243729791,0.6030224009841},
{0.13927200213079202,-0.70223601074386,0.6981890106819428},
{0.15572502574718858,-0.6044220999336473,0.7812961291775594},
{0.16976603951423866,-0.4948791151865916,0.8522171983595416},
{0.17382792463083566,-0.38908083130042437,0.904654607755417},
{0.818106629600573,0.5740907400792593,0.033486784838790605},
{0.8265868512840447,0.5563038999121923,0.08532378464891123},
{0.8561801455346737,0.5145980874720876,0.046307307871379606},
{0.8525288145155434,0.5226558862859044,0.005044298902513293},
{0.8667100388132005,0.49722102226666176,-0.03981160178285195},
{0.8245896596173584,0.5652737666604527,-0.022747790609931897},
{0.7722628802185615,0.63112790210923,0.0727159887214238},
{0.7696671681695081,0.6384101394903194,0.0067040314648067634},
{0.7033211235683242,0.709331124624237,0.0467841082196221},
{0.6709822624520759,0.7406742897118387,-0.034415113461336425},
{0.5850888574278347,0.810805802426012,0.016278196033392832},
{0.49467304378809124,0.8650700765753621,0.08338070738079843},
{0.4080579979546093,0.8997939954897826,0.1544649992257442},
{0.33533708306736515,0.9172022272029435,0.21514905329522407},
{0.27610891392954806,0.9238757120035028,0.2649859173968803},
{0.21830007443935573,0.9319723177984207,0.289435098696083},
{0.19285197882167185,0.9243478984913546,0.32922496384566874},
{0.16714294330161325,0.9232516868136926,0.3459328826523215},
{0.15718193753669635,0.9177286352993015,0.3647848550363514},
{0.14648799353387362,0.9187169594469156,0.36674298381159826},
{0.13613893128178164,0.92231253444857,0.3616708174410951},
{0.1262939731485149,0.9223348039014958,0.3651689223610785},
{0.1122679949308195,0.9222999583558522,0.3698089833022003},
{0.09373439417551552,0.9222729426916396,0.37500197669806035},
{0.06218261091700523,0.9648011693840007,0.25552304486055466},
{0.02951639755506893,0.9909209179190708,0.1311659891351307},
{-0.004580348314917819,0.9999876321106551,0.0019380492870034992},
{-0.03893510448343575,0.9911031141270119,-0.1272740146557939},
{-0.07230469843293703,0.9650979790833883,-0.251709994544678},
{-0.10463398463821502,0.922522864560277,-0.3714879454601871},
{-0.13580596355783264,0.8630397684119396,-0.48653786944244565},
{-0.16449294555983499,0.7885787390139952,-0.5925248038995047},
{-0.1896040303187297,0.7025381123397171,-0.6859231096828866},
{-0.21101298240035743,0.605578949491387,-0.7672989360030512},
{-0.2189969430001401,0.4967188707155194,-0.8398277814121732},
{-0.2410430473412207,0.38114807485806096,-0.8925381752958537},
{-0.24935101227729606,0.2601290128079725,-0.9328220459293601},
{-0.25376203758748955,0.13380501981933482,-0.9579671418950616},
{-0.25913188200562676,-0.008030736343245401,-0.9658085602240265},
{-0.25840506281143066,-0.14434203508572793,-0.9551922321819473},
{-0.247445885536385,-0.25799788065523893,-0.9339205679866566},
{-0.23837900191489855,-0.3796220030495036,-0.8939030071807229},
{-0.21994206680103462,-0.5044851532227584,-0.8349372535880161},
{-0.2002589776309733,-0.615403931259077,-0.7623479148453616},
{-0.18567805690392725,-0.7026672153432925,-0.6868642105002158},
{-0.16042101240583864,-0.7888820610066187,-0.5932370458768023},
{-0.1317270379588639,-0.8633722487919732,-0.48706914035532484},
{-0.10412802155570017,-0.9227731910246822,-0.37100807680294645},
{-0.06710516885676544,-0.9652645520246671,-0.2525098828111956},
{-0.03372190733094769,-0.9911562154716309,-0.12834402790124966},
{0.0008492766329505505,-0.9999995678095022,0.0003782988365027669},
{0.03533959743900731,-0.9910019281839955,0.1290979906445168},
{0.06857700589210232,-0.9649760829102662,0.2532160217561949},
{0.10059203009452451,-0.92243827596959,0.3728121115357073},
{0.12487495445873678,-0.869768682799768,0.47739782589543156},
{0.15465698267640834,-0.8018159101861995,0.5772109353448751},
{0.18029198771842003,-0.7174159511292683,0.6729109541609708},
{0.20273996253396248,-0.621548885138709,0.7566858601656009},
{0.22201398889785773,-0.5140359742948608,0.8285389585676677},
{-0.15459600821731914,0.8018110426190644,0.5772340306820098},
{-0.12478897289402859,0.8697678110738403,0.4774218962970528},
{-0.10050503160431468,0.9224412900663215,0.37282811723768405},
{-0.15718296481978428,0.8630238068406223,0.480086892548404},
{-0.19718507497470938,0.7885812998383818,0.5824582214652194},
{-0.24184701588584265,0.7749740509045596,0.5838880383529789},
{-0.27240511325803374,0.7885853278705842,0.5512972292131724},
{-0.19454693459391523,0.8581277115000864,0.47515084025573984},
{-0.22392592500206998,0.8630387109485343,0.4527928483492863},
{-0.29878807395170076,0.8018211984551812,0.5175021280846388},
{-0.12476203341845085,0.9224402470825717,0.3654290978829377},
{-0.14837100650146928,0.9224390404203572,0.35650001562147454},
{-0.17133496109591714,0.9224397905466941,0.3460479214248107},
{-0.24418114065460417,0.8697725010112841,0.4288022470010999},
{-0.2761211124379205,0.8630253514283098,0.42301817225514987},
{-0.34124211164675927,0.7885842580070683,0.5115551673693681},
{-0.38473508328861405,0.7749721677683179,0.5013951085435291},
{-0.40580782345557675,0.7885836569310918,0.46201279900391656},
{-0.42254289730138384,0.8018198051185218,0.42254289730138384},
{-0.47539402079468573,0.7749440338976027,0.41648801821801934},
{-0.48921595427151926,0.7882509263198247,0.37326696510961865},
{-0.5143118783979139,0.7873798138346947,0.3398769196407002},
{-0.5384679543893431,0.7856439334524263,0.30465697419418447},
{-0.5615843032755419,0.7827884227336515,0.268077144771214},
{-0.5832529902570505,0.7788499869897004,0.23066999614677303},
{-0.6035050510209227,0.7738820654247665,0.19206301623720018},
{-0.6110676434635215,0.7782945458925054,0.1444089157424766},
{-0.6409683472200188,0.75927341130725,0.11253206095992804},
{-0.6545092576086766,0.7524372961522299,0.07386302907179226},
{-0.33348511119012403,0.8630372877526459,0.3794131265033766},
{-0.346838840123633,0.8697715990762644,0.3509988382060698},
{-0.25505805367174433,0.9224391941084388,0.2899160610068982},
{-0.2735119155497902,0.9224407151849426,0.27256991584064433},
{-0.38509591283586064,0.8580838057779011,0.33969592311187474},
{-0.40361596833552127,0.8624819323365701,0.30531797604719507},
{-0.42679004972659196,0.8610431003227206,0.2765050322164327},
{-0.45073114592851404,0.858178277843415,0.24570607954969034},
{-0.4752447496138053,0.8534825503364358,0.2137988873584824},
{-0.4993938724955218,0.8470987837200368,0.1817399535984336},
{-0.5231131973010725,0.839191316515331,0.14869605608325595},
{-0.5357408961439587,0.8379768375540159,0.1038099798759183},
{-0.5705347467841809,0.8172846372711742,0.08084506411918951},
{-0.5885821787941772,0.8068632451016275,0.05042541531777713},
{-0.31090701741405796,0.8581270480641263,0.40860102288594824},
{-0.23559509295476905,0.9224383639508956,0.3059451207115891},
{-0.16024696836332555,0.9649758094901523,0.20770795899336414},
{-0.1734590601128548,0.9649763344159841,0.19680606820384358},
{-0.1859870246654149,0.9649771279743102,0.18500802453558085},
{-0.29176100283445816,0.9223680089608052,0.25320500245988664},
{-0.31141481228092055,0.9217594443686442,0.23104186072927907},
{-0.33311091466049225,0.9200427642947345,0.20629694714889504},
{-0.3575000270346893,0.9166060693151286,0.1789610135333008},
{-0.38391110777749193,0.9109682557411646,0.15082804234279182},
{-0.41146505187237375,0.9030061138397304,0.12359801558169381},
{-0.4406738717151636,0.8925017401832805,0.09616227200614304},
{-0.461764071447375,0.8853651369899022,0.05387500833591906},
{-0.5046051128622906,0.8623451928760754,0.04164670931489375},
{-0.529099048326322,0.8482810774794524,0.021758001987310722},
{0.821246048575962,0.5636970333421704,-0.08832090522410176},
{0.7505588528210188,0.6572638711154674,-0.06830528660584383},
{0.7813019843938837,0.6012109879911113,-0.16766799665091564},
{0.6883458894279112,0.7093518860536236,-0.15165697563865949},
{0.5933197321233212,0.7962236405146623,-0.11831994657997602},
{0.5726520591549608,0.7824860808308164,-0.24451002525788693},
{0.4604311494667954,0.8669442814305326,-0.19081606194338793},
{0.5014511566492915,0.862935269574009,-0.062365519482484616},
{0.41350701844081295,0.9104600406029948,0.008629030384821363},
{0.3314549308921513,0.9400958039914555,0.07973398337558579},
{0.2620170748956264,0.9550012729799903,0.13899503973069532},
{0.19734909220654984,0.9633384500963943,0.1817480849173597},
{0.15153103561138861,0.9654672268949623,0.21192304980414775},
{0.12923097545244933,0.9621898172310993,0.23977095445527175},
{0.10637695100645767,0.9621505568667499,0.25089888444465647},
{0.10155998744535823,0.9566398817420984,0.27299396625303396},
{0.08786824201121189,0.9632114605268052,0.25397412142908954},
{0.0861312456813358,0.9640255112891698,0.2514681333708825},
{0.08151228629096774,0.9644698377919609,0.251303957734788},
{0.07365208331841595,0.9646927815051118,0.252869942727062},
{0.03376190256918618,0.9908330753996206,0.13080500995389474},
{-0.007929098831956796,0.9999618526946541,0.0036636794602998416},
{-0.05003738768020224,0.9910787559846664,-0.12352796958595014},
{-0.09099482840749609,0.9650143012659124,-0.2459010767673724},
{-0.130695066604118,0.9223654700509377,-0.3635391852648874},
{-0.1689259725734347,0.8628598599073787,-0.4763789226558389},
{-0.2040029128113157,0.7885126629980392,-0.5801987520291985},
{-0.22746789223745276,0.711671662846697,-0.6646666851152295},
{-0.2564840247254459,0.6233460600914981,-0.7386850712103524},
{-0.2763849702318202,0.507504945338929,-0.8161189120995092},
{-0.2962658682166752,0.3852478286362178,-0.8739626112488446},
{-0.30599496435082374,0.26467596916458974,-0.9145018934582494},
{-0.31118096446158,0.13738498430994878,-0.940367892605291},
{-0.32174810345367116,0.002383640766426858,-0.9468223044376713},
{-0.3104290914941766,-0.13333303929785248,-0.9411992774039393},
{-0.3044459342412076,-0.2612429435728365,-0.9160048021475642},
{-0.2939669410474346,-0.38268492325579917,-0.875862824353173},
{-0.2780159000776283,-0.4982118209364761,-0.8212747048236582},
{-0.24851108837726854,-0.6055162153379534,-0.7560372688673136},
{-0.23024706365860184,-0.7027041942833311,-0.6731961861249707},
{-0.19913803069025954,-0.7886811215479947,-0.5816580896425343},
{-0.16358302605076255,-0.8632031374659739,-0.47762007606148077},
{-0.1283820434442341,-0.9226883122359324,-0.36354412302262495},
{-0.08366311729456488,-0.9652281995288039,-0.24765905119526582},
{-0.04215638069638776,-0.9911445461500804,-0.12591794234156034},
{0.0008248526853734232,-0.9999996185664879,0.0002872018904515325},
{0.04370761074381807,-0.991004243599893,0.12649203109315166},
{0.08502308196870588,-0.9649757953524856,0.24817894736737964},
{0.12481306672502089,-0.9224344931331506,0.3654261953567135},
{0.15722700861203104,-0.8630190472714382,0.4800810262961989},
{0.1972050747836296,-0.7885762990419894,0.5824582208783923},
{0.22846011870882238,-0.7022343648838798,0.6742943503661326},
{0.2557759892721158,-0.6044349746484866,0.7544779683553086},
{0.37742491224985036,0.9176877866403674,-0.12409497114829483},
{0.299895092008878,0.9244782836332166,-0.23537807221482746},
{0.2356229204988372,0.9577476768478475,-0.16492794435191904},
{0.3038339073980916,0.9511747101028185,-0.05432888344174838},
{0.18072608966293421,0.9777564850905344,-0.10644405280967525},
{0.10990004956482365,0.9741694393495421,-0.19727108896908394},
{0.06716106614619004,0.9855205032296872,-0.1556879215225485},
{0.13114998846422063,0.9895049129644579,-0.0606605946643744},
{0.23650701489378848,0.9715960611852728,0.00809480050976182},
{0.7127499612221266,0.6501259646292477,-0.26329398567522777},
{0.5579812740486642,0.7258083564757811,-0.40231719759532386},
{0.38508605535111834,0.8638031241604787,-0.32488904669858026},
{0.2347590045681755,0.9016990175461613,-0.36308000706517396},
{0.16361493859941545,0.9509346431380687,-0.2625899014565932},
{0.05828088814377996,0.9539338059389714,-0.29430194012945465},
{0.00910704035581407,0.9716790379637137,-0.23612900922561234},
{-0.02744379651239536,0.9772578758083962,-0.21027097327840477},
{0.030794313158035748,0.9910964234834563,-0.1295360553491821},
{0.08551808682540227,0.9960778465479593,-0.022706396501937183},
{0.1775499031935659,0.9822934644191529,0.059796167397032404},
{0.11704994881250244,0.9896685672047884,0.08279756379152543},
{0.03395608826716759,0.9993456546965305,-0.012459795694772211},
{0.015311401846869289,0.999599120572168,0.023815102872590147},
{0.09142337360605025,0.9878567148055309,0.12562196373290913},
{0.06280729241020111,0.9879758806103885,0.1412759829278376},
{0.04383351575770793,0.9881473552290331,0.14711705288710045},
{0.042746293860420996,0.9852328584926452,0.16579797618671277},
{0.03245219515153142,0.9894788521684866,0.14099097893546714},
{0.03486460865063985,0.9902242456953814,0.13505703351047957},
{0.03542489632718219,0.9906328972921722,0.13187698632712597},
{-0.012796695171886861,0.9998936227463832,0.006999127359272976},
{-0.061615874538390854,0.9910885904511539,-0.11809695119864101},
{-0.10915604791209294,0.9650304235828269,-0.23833010461073242},
{-0.1482809736031717,0.927318834919643,-0.34364593882449906},
{-0.19204306515311745,0.8740912965468858,-0.44618815137515644},
{-0.23351088739138653,0.8020486132189669,-0.5497187349028766},
{-0.2697269965233539,0.7100849908473595,-0.6504049916166049},
{-0.30414189804724284,0.6087707959312362,-0.7327317543777326},
{-0.32784099866142524,0.5040659979418985,-0.7990229967375891},
{-0.3450170599932967,0.39132106804486977,-0.8531301483465488},
{-0.3562469120544044,0.2710499330867244,-0.8942147792479073},
{-0.3625489257715593,0.1420479709170304,-0.9210758114184971},
{-0.37298910979901656,0.0025292107445387684,-0.9278322731314895},
{-0.3629359070519447,-0.1372359648538053,-0.9216527639642966},
{-0.3567230243340403,-0.26692201820821954,-0.8952660610710241},
{-0.345404941664219,-0.3880509344616952,-0.8544658556884194},
{-0.3278008608869168,-0.5016177871219838,-0.8005786602480985},
{-0.29810291402444905,-0.6141798228650369,-0.7306967892605001},
{-0.26535096876792746,-0.7119009162085551,-0.6502199234684692},
{-0.23642106191927528,-0.7886452065481783,-0.5675771486498936},
{-0.19442793206912834,-0.8630916984457389,-0.46612283714206965},
{-0.15194200812357966,-0.9226250493281495,-0.3545090189538252},
{-0.09980899808192059,-0.9651849814515577,-0.24177699535365063},
{-0.0504110795916782,-0.9911275987538622,-0.12298295021182555},
{0.0007672317616039859,-0.9999996892778011,0.00018110694372603473},
{0.051833373859462725,-0.9910085002159282,0.12335093779182123},
{0.10102403266582317,-0.9649773120225693,0.24210107828267002},
{0.1483910481836199,-0.9224322995202733,0.35650911576102423},
{0.19456401825458072,-0.8581170805111226,0.4751630445812244},
{-0.02472311030410686,0.9989814163558363,0.0377478157325483},
{-0.019779791221014087,0.9992915564783065,0.0320178857893056},
{-0.08197239002752162,0.9925738792468836,-0.08987558906604567},
{-0.018887402794247433,0.9997421479042387,0.012605701864917608},
{-0.02272660908531822,0.999141399422436,0.034640513848088396},
{-0.08665937624599185,0.9933947277027891,-0.07521347938340109},
{-0.1505300243191811,0.9690691565599184,-0.19556503159490235},
{-0.14085306254398522,0.9655344287331062,-0.21886909718599887},
{-0.07347849482008777,0.9911699301268588,-0.11037699221890523},
{-0.008309957251934149,0.9993996695029805,0.03363398887738968},
{-0.09103988924627743,0.9925748827560642,-0.08066499047177081},
{-0.1571200149645823,0.9687170922635264,-0.1920950182957067},
{-0.2147439744607154,0.9257908898966218,-0.3111209629986972},
{-0.19928589407000974,0.9238535089276456,-0.32677182630513546},
{-0.1727800029551428,0.9263030158430238,-0.3348280057267309},
{-0.11990996986848698,0.9684897566335664,-0.21828694514788105},
{-0.06849292565970098,0.9649783615126084,0.253230094868316},
{-0.035274110707390734,0.9910023008169061,0.12911303919202302},
{-0.08497729880418715,0.9649769864207041,0.24818999650743442},
{-0.0008219946573763004,0.9999995831803118,0.00039744683433626536},
{0.03368471781445253,0.9911625241848199,-0.1283050678552379},
{-0.0008688226228014252,0.9999995658510712,0.00033681585377169437},
{-0.04368928856951853,0.9910017407230146,0.12651796689895112},
{-0.10101703037941172,0.9649762902026708,0.2421080728105033},
{-0.11661596081319543,0.9649766757360473,0.2349909210353091},
{-0.19365200733853977,0.9224410349563649,0.3340680126596746},
{-0.13177200337619643,0.9649770247241591,0.22683800581193006},
{-0.05982752210847964,0.9910013662116157,0.11973704424726132},
{-0.06755176836540483,0.991001535912484,0.11555394588591261},
{-0.14635203023047852,0.9649761993255044,0.21772004497225714},
{-0.21512808970832456,0.9224393846568424,0.3206641337168113},
{-0.051873315382569944,0.9910012938726127,0.12339203659081013},
{-0.0009053975950908689,0.999999552783272,0.000273291877779246},
{-0.0009319505750302868,0.9999995439999386,0.0002084899049285472},
{-0.0009490035628216804,0.9999995393293183,0.00014399093366756788},
{-0.0749749278411945,0.9910013679985114,0.1108830411753156},
{0.042003708191612484,0.9911621932976147,-0.1258300245395191},
{0.05011259748167267,0.9911619501907633,-0.12282799382747833},
{0.05801190747812374,0.9911621277674423,-0.11929901537844279},
{0.0657005202190672,0.9911623050261578,-0.1152420354652665},
{-0.0009503575673474887,0.9999995447478621,8.558366103783761e-05},
{-0.08204921656284052,0.9910012000481604,0.10575702134860944},
{-0.08877582860168387,0.9910013192795483,0.10017603227458703},
{-0.09515275773990595,0.9910015598675213,0.09413745819082986},
{-0.19924498395350698,0.9649179222888908,0.1709819862297098},
{-0.2154279471179389,0.9644137632610428,0.15328696237196418},
{-0.23512910118242247,0.9629524143845127,0.1320490568242867},
{-0.25898297556638183,0.9599159094372177,0.10718798988740318},
{-0.28633903982346237,0.9546911327765378,0.08108511127715548},
{-0.3191330979017456,0.9460742902310199,0.05565521707357507},
{-0.3585539504505653,0.932962871071612,0.031927195587903884},
{-0.39303609953232227,0.9194882328508736,-0.008000882026140523},
{-0.446202192955086,0.8949003869895396,-0.007543233261985812},
{-0.4798679058851365,0.8772528279473806,-0.012420497564009972},
{-0.5031429504490343,0.8641719148938631,-0.007353429275813125},
{-0.5099010392551784,0.8602330662257964,-4.4025603389349654e-05},
{-0.5447267680154891,0.8385726428744176,-0.008286786470880048},
{-0.5885821758262232,0.8068632410329808,-0.05042551506353442},
{-0.6545092576086766,0.7524372961522299,-0.07386302907179226},
{-0.72339235459653,0.6843343354508505,-0.09159704489955425},
{-0.0009510695692027639,0.9999995470394019,-3.725138312658357e-05},
{-0.0009497575666462544,0.9999995437219317,-0.0001025499532086841},
{0.08691470335299159,0.9911620382370053,-0.10021800386620573},
{0.0932923239340998,0.9911622542821886,-0.09430762419457459},
{-0.0033487292833301726,0.9999907859895012,-0.002685879425188308},
{-0.10315200723085487,0.9909690694659631,0.08567360600563603},
{-0.11532594366027739,0.9906675160331555,0.07264846450933582},
{-0.13205601542650466,0.9897151156164283,0.0550018064251948},
{-0.15383793599056725,0.9875605890922956,0.032526486466264416},
{-0.18187291983184262,0.983304566567055,0.005862627415799791},
{-0.22170692107065962,0.9748056529618163,-0.024494491279775883},
{-0.2708270801429163,0.9613882844931931,-0.04883911445242869},
{-0.33366897531583584,0.938402930578826,-0.08980509335639861},
{-0.40723895233759266,0.9111698933585544,-0.06265669266678987},
{-0.4422308182084361,0.8956076318349936,-0.0481546802046482},
{-0.46181589300858217,0.8863487946547193,-0.033345092274759805},
{-0.4712119930863776,0.8820199870590028,-2.3288499658311135e-10},
{-0.49921009114701176,0.8664381581964196,0.008614111572785773},
{-0.529099048326322,0.8482810774794524,-0.021758001987310722},
{-0.5705347467841809,0.8172846372711742,-0.08084506411918951},
{-0.6409683472200188,0.75927341130725,-0.11253206095992804},
{-0.7128161357797254,0.6878041310153507,-0.13718102613072447},
{-0.0009511495694489035,0.9999995473362808,2.53323885329416e-05},
{0.08018989363953795,0.9911619213835124,-0.10567699161796501},
{0.15843003413359608,0.9652992079727715,-0.2075990447270114},
{0.1716389507244382,0.9652997228735903,-0.1968159434964141},
{0.1841650793787575,0.9653004160633923,-0.1851440798007259},
{0.09663875354138025,0.9911625235033453,-0.09087245631350013},
{-0.010818796660314527,0.9998856913424088,-0.010562096739555965},
{0.0731192029887972,0.9911620405144234,-0.11068600452436582},
{0.14454094936030407,0.9652996618087707,-0.21749592380064267},
{0.2173939896862859,0.9229319562138018,-0.31770498492728166},
{0.22860394199758646,0.9279227645632904,-0.2944479252913568},
{0.25327199973051867,0.9229399990179921,-0.2898879996915592},
{0.27939297232026017,0.9192819089258265,-0.27723697253385726},
{0.19308995136209559,0.9653017568477579,-0.1758089557150482},
{0.0942737701658974,0.9911756863301735,-0.09318377051084129},
{-0.02341319259108965,0.9994366837365617,-0.02404449239132007},
{-0.034959110889595184,0.9981083109059464,-0.05057331575334503},
{0.0864501119512529,0.991045137006544,-0.1017640140683157},
{0.09189676513160601,0.9873306253770936,-0.12935695091808594},
{0.04900811195585848,0.9877252409622148,-0.1483140361822065},
{-0.07581981698980772,0.9940162227405072,-0.07863271762012632},
{-0.191527939785732,0.9678046957328973,-0.16331294865621346},
{-0.28156790136649984,0.9375566715730178,-0.20422292846051646},
{-0.15451793863128135,0.9302246305497335,-0.3328758677942144},
{-0.3302211280865262,0.8997863490100966,-0.2851991106233377},
{-0.3759689781296972,0.9159159467207131,-0.14051799182599842},
{-0.4271880926554221,0.900077195223214,-0.08585671862198559},
{-0.4480137920358071,0.8929555854976098,-0.043748879692142036},
{-0.4497849444529121,0.8931368897002803,-3.1051596165221265e-10},
{-0.4480137939958141,0.8929555894041841,0.04374877988358415},
{-0.46181589300858217,0.8863487946547193,0.033345092274759805},
{-0.4798679058851365,0.8772528279473806,0.012420497564009972},
{-0.5046051107607733,0.8623451892846863,-0.041646809141470606},
{-0.5445730617518658,0.8320400943491919,-0.10559101197349349},
{-0.6110676434635215,0.7782945458925054,-0.1444089157424766},
{-0.6861929486003759,0.7055589471497562,-0.17699098674240213},
{-0.12321105493236736,0.98507043918341,-0.12023005360331893},
{-0.06072861738408663,0.966560276686154,-0.24914507131990962},
{0.027170198807866253,0.9415759586869245,-0.33570298527052156},
{-0.059161485047905304,0.889947775080301,-0.4522088857116235},
{-0.253636019962931,0.8718170686181087,-0.419051032982251},
{-0.4180048846714232,0.8500017654824202,-0.3205759115523168},
{-0.412983877825965,0.8916967362071642,-0.18525994519409536},
{-0.44613515244396146,0.8884363035778483,-0.10790903687241628},
{-0.459802927929113,0.8866268610274524,-0.04974009220358909},
{-0.4690008486991781,0.8831977150782551,-3.105708998090674e-10},
{-0.459802927929113,0.8866268610274524,0.04974009220358909},
{-0.44613515244396146,0.8884363035778483,0.10790903687241628},
{-0.4271880926554221,0.900077195223214,0.08585671862198559},
{-0.44223082033798145,0.8956076361477573,0.04815458043657582},
{-0.4462021932243493,0.8949003875295722,0.007543153266503177},
{-0.4747781445644097,0.8774612671767259,-0.06817212075761597},
{-0.5210727721938078,0.8416576320383052,-0.1417589380248487},
{-0.6035050510209227,0.7738820654247665,-0.19206301623720018},
{-0.6816252475615635,0.6954902525972373,-0.22733308256579926},
{-0.6629539241895658,0.6978419202000363,-0.27112496899618377},
{-0.6419500621134862,0.6996570676970719,-0.3136560303485748},
{-0.6185618444363549,0.7009448237176561,-0.3550459107086275},
{-0.5929980775508112,0.7017150917685514,-0.394904051644568},
{-0.5654063257677122,0.7020974045244187,-0.43286824940382324},
{-0.5466258815513773,0.6867238511934814,-0.4791768961669301},
{-0.4926001129135645,0.717419164446481,-0.4926001129135645},
{-0.4697127648942589,0.7022376485083756,-0.5350067322126123},
{-0.44251615345887596,0.6867312381495072,-0.5766971999911266},
{-0.3952080025917741,0.7022380046052769,-0.5921760038834902},
{-0.34832501886859263,0.7174200388622858,-0.603306032680787},
{-0.31523994679758915,0.7022398814843896,-0.638343892267987},
{-0.27817400032699346,0.6867330008072546,-0.6715780007894399},
{-0.2284579086152556,0.7022347191012529,-0.6742947302774417},
{-0.18026001610298847,0.7174060640873214,-0.6729300601141909},
{-0.139174954894657,0.702205772421466,-0.6982387737071344},
{-0.09464842217595944,0.6866661608846781,-0.7207851688787019},
{-0.08219090518658285,0.7749180489005038,-0.6266950395470247},
{-0.06874491403602828,0.8580981752026375,-0.5088631038973866},
{-0.04937491160471003,0.9224282168006308,-0.3829990900172423},
{-0.03320240259286271,0.9649750753574349,-0.2602320203222011},
{-0.01643780624773321,0.9910023766633071,-0.13283105048684438},
{0.0009365742862056648,0.9999993055875761,-0.0007152992185867061},
{0.018256598358973232,0.9911609109077412,0.13140298818860902},
{0.03495770751929375,0.965299207632846,0.25879605566622366},
{0.046251786903733466,0.9229297386709864,0.3821798917851598},
{0.0652446811158729,0.8637477500007353,0.49968285537404133},
{0.07960275975584631,0.7895006008582665,0.6085656923321336},
{0.09230037769200933,0.7032828300242404,0.7048928296351211},
{0.1033949680571118,0.6054798129427927,0.7891157562102213},
{0.11286497406487345,0.49580788606881476,0.8610668021363433},
{0.12036797234227178,0.37787291317369454,0.9179997890652457},
{0.12569797967074167,0.25597295860124075,0.9584768449845938},
{0.12895602738665235,0.13010602763088022,0.9830782087783075},
{0.14094407951170854,-1.7383709806786298e-05,0.9900175585051024},
{0.12896098149713103,-0.13013398132883316,0.9830738589520135},
{0.12571006994962794,-0.255998142446622,0.9584685333265451},
{0.12038505132051948,-0.3778951610978752,0.9179883913412886},
{0.11287903707885082,-0.49582816287114917,0.8610532828414119},
{0.10339405107470936,-0.6055012991062111,0.7890993898002019},
{0.08841713711692911,-0.7098352979841612,0.6987962933500601},
{0.07784002593684586,-0.8027192674717235,0.5912551970104033},
{0.06323072427805806,-0.874853335908537,0.4802431843940908},
{0.046564411893498504,-0.9279262370112468,0.36984409446570904},
{0.034771710420911234,-0.9653002892957667,0.25881707756621},
{0.01802399971928522,-0.991161984563148,0.13142699795309026},
{0.0006546787034509978,-0.9999995470314424,-0.0006908926870471944},
{-0.01676460328405903,-0.9910011941296412,-0.1327990260143251},
{-0.03356169560724605,-0.9649758736982292,-0.2601829659457089},
{-0.04974710683695903,-0.9224381267746423,-0.3829270526273132},
{-0.06908215815743858,-0.8581264802390239,-0.5087696918418931},
{-0.08249218602723385,-0.7749718687330132,-0.6265888938665526},
{-0.09488088805474315,-0.6867309135423654,-0.7206929092666385},
{-0.10567100669896086,-0.5870190372137796,-0.8026470508834102},
{-0.1148289954567909,-0.47549498118704153,-0.8721919654917257},
{-0.12192393490110985,-0.35710280933196936,-0.9260735055412421},
{-0.12688403928400252,-0.23479807269478598,-0.9637272983753183},
{-0.12976194187230772,-0.108512951390929,-0.9855895584988499},
{-0.13053201251819538,6.109200585880543e-06,-0.9914440950808207},
{-0.1297539498436204,0.10852195805084523,-0.9855896190204064},
{-0.1268599365215237,0.23479788251127795,-0.9637305177662348},
{-0.12187303454528216,0.3570871012174245,-0.9260862625019666},
{0.005074879105684547,0.9799398273110921,-0.19922896489107655},
{0.11648601014465058,0.9546350831382184,-0.27404902386665647},
{0.15454097953112592,0.8942328815593098,-0.42007694436102244},
{0.052724768614640725,0.835224502817712,-0.5473756741648632},
{-0.16681492233874712,0.8281106144702949,-0.535168750850373},
{-0.3517518824501686,0.8142597278874726,-0.46179184567657966},
{-0.5276981723610268,0.763476249372761,-0.37234212161738234},
{-0.5612487325240715,0.7910836229909943,-0.24328288405797371},
{-0.4705418360187867,0.8593327005273323,-0.20034393018125438},
{-0.5081979822115463,0.85216897017153,-0.12467099563614122},
{-0.5211913176754925,0.8516725191097355,-0.05489563345987704},
{-0.5387888855068351,0.8424408209805021,-6.217658678741453e-10},
{-0.5211913205366044,0.8516725237850442,0.0548955337611685},
{-0.5081979822115463,0.85216897017153,0.12467099563614122},
{-0.4705418360187867,0.8593327005273323,0.20034393018125438},
{-0.412983877825965,0.8916967362071642,0.18525994519409536},
{-0.3759689781296972,0.9159159467207131,0.14051799182599842},
{-0.40723895233759266,0.9111698933585544,0.06265669266678987},
{-0.3944540760744312,0.9189111772212518,-0.0028688405532847207},
{-0.42997716535293407,0.8990623457453297,-0.08250173172704159},
{-0.42405179148254796,0.8962175593061845,-0.1302849359354602},
{-0.4993938724955218,0.8470987837200368,-0.1817399535984336},
{-0.5832529902570505,0.7788499869897004,-0.23066999614677303},
{-0.5615843032755419,0.7827884227336515,-0.268077144771214},
{-0.5384679543893431,0.7856439334524263,-0.30465697419418447},
{-0.5143118783979139,0.7873798138346947,-0.3398769196407002},
{-0.48921595427151926,0.7882509263198247,-0.37326696510961865},
{-0.47539402079468573,0.7749440338976027,-0.41648801821801934},
{-0.42254289730138384,0.8018198051185218,-0.42254289730138384},
{-0.40580782345557675,0.7885836569310918,-0.46201279900391656},
{-0.38473508328861405,0.7749721677683179,-0.5013951085435291},
{-0.34124211164675927,0.7885842580070683,-0.5115551673693681},
{-0.29878807395170076,0.8018211984551812,-0.5175021280846388},
{-0.27240511325803374,0.7885853278705842,-0.5512972292131724},
{-0.24184687467425647,0.7749735984064605,-0.5838886974272037},
{-0.19718507497470938,0.7885812998383818,-0.5824582214652194},
{-0.15459600821731914,0.8018110426190644,-0.5772340306820098},
{-0.12028896407197727,0.7885597644722161,-0.6030788198718419},
{0.352743872340252,0.7699047213676822,-0.5318068075364922},
{0.2074750587766551,0.82153623273714,-0.5310671504486897},
{0.12092197110618215,0.9117477821415405,-0.3925479062022592},
{0.021066398849490676,0.9112669502325419,-0.4112769775387336},
{-0.036047491849784674,0.941870787046218,-0.33403592447561337},
{-0.07885651783985989,0.9551702160899733,-0.2853620645580022},
{-0.10963504548216287,0.9556053964334588,-0.27349311345877836},
{-0.055837177276958125,0.9778136020769582,-0.20189791783727143},
{-0.01196250195484494,0.9932861623172506,-0.11506301880295283},
{-0.04549878872787122,0.9936087538377143,-0.1033029744071334},
{-0.06131691318481723,0.9947362138955549,-0.08209811765334586},
{-0.08084869764191921,0.9937009710171315,-0.07760069773665229},
{-0.17282299399837603,0.9234449679315272,-0.34260998810218324},
{-0.19247092520908501,0.9171456436128637,-0.3489968643857778},
{-0.1380569711741216,0.9474368021780587,-0.28862393973619355},
{-0.09352518087353945,0.9724508011279773,-0.21352395633306998},
{-0.10910698712352146,0.9753918848871828,-0.191588977389245},
{-0.13267597749364513,0.9734658348671105,-0.18644396837276653},
{-0.14993603191021437,0.9710582066659703,-0.1859170395678911},
{0.08446548702883674,0.818673874278207,-0.5680129127716127},
{-0.08674339145870134,0.8864079127187146,-0.4547049552268968},
{-0.13888297107331893,0.9172528089536877,-0.3733079222470607},
{-0.2582888884952903,0.8759166218620584,-0.407500824079691},
{-0.2684419708245202,0.8683139056277425,-0.4170969546680285},
{-0.2696499237337095,0.8550797581539784,-0.44286287474311803},
{-0.20855802002073667,0.9034880867312466,-0.3744500359457074},
{-0.21510091828726358,0.9016556574782123,-0.3751648574820259},
{-0.16202695565120298,0.9406857425225891,-0.2980899184090744},
{-0.17507703095729843,0.9413301664469561,-0.28852305101693887},
{-0.19741095137156894,0.9371297691559153,-0.28777892911113734},
{-0.21412100579004623,0.932851025225225,-0.2897260078344811},
{-0.219711910517509,0.9288516217048194,-0.29826387852549835},
{-0.27101007708814984,0.8691222472196856,-0.41373911768707444},
{-0.2527730480453361,0.8657031645468132,-0.4320460821203027},
{-0.22712306335893995,0.8637642409582975,-0.44980712547956264},
{-0.2548901253335837,0.8871084362055192,-0.3847981892114729},
{-0.2721920392364853,0.8805301269284269,-0.38804405593655467},
{-0.2774360125767296,0.8741980396291464,-0.39850601806507524},
{-0.3209450266816054,0.7993050664498298,-0.5080410422357398},
{-0.3008030293995871,0.7937940775830555,-0.5285910516629061},
{-0.27199998166053785,0.7904599467036352,-0.5488069629969662},
{-0.2330580094402479,0.8938300362054802,-0.3830820155171204},
{-0.28581710716743025,0.8326723122113746,-0.47430517784123405},
{-0.3057840133277494,0.8241780359222126,-0.4766830207764683},
{-0.32324892882010886,0.8156788203863201,-0.47976889435418146},
{-0.3282628993884216,0.8068807526935079,-0.4911078494769406},
{-0.3635160070891075,0.719070014022944,-0.5922790115503292},
{-0.3417791155018791,0.7114432404273036,-0.6140322075079213},
{-0.31055202823880773,0.7064850642413962,-0.63595305782785},
{0.0669618956046009,0.9653019366372886,-0.25240498343206047},
{0.10338297480334938,0.9192847759505628,-0.37977290744118863},
{0.08334602204748445,0.9653002553504276,-0.24748506546710927},
{0.13545694315760531,0.852223642377633,-0.5053377879428745},
{0.16331799683048767,0.7759409849413135,-0.6092969881753735},
{0.19792098265212768,0.7895119307988875,-0.5809459490797992},
{0.16267097057908694,0.863750843780741,-0.4769409137397588},
{0.1277769975266207,0.9229329821347865,-0.3631359929707767},
{0.09930794830938558,0.9652994695799789,-0.24152611749289493},
{0.11484896669627373,0.9652997200838755,-0.23453393199021202},
{0.12996794426787292,0.9653005860652006,-0.22650190287272062},
{0.16961203646760947,0.9229401984377017,-0.34556207429792735},
{0.19811599249180023,0.9192819651610526,-0.3401039871107393},
{0.14461105225275478,0.9279233352893831,-0.34357812414613675},
{0.1853799306322333,0.8748466726389977,-0.44752383253996963},
{0.22224598285672342,0.8637489333734331,-0.45226596511378775},
{0.2615919912596885,0.8522179715256937,-0.45309398486122404},
{0.280548968799169,0.8637489039394667,-0.41860495344548065},
{0.33172887593375533,0.863748676958919,-0.37933385812954296},
{0.3699491701415122,0.8522173919391298,-0.3699501701419721},
{0.4041779659445722,0.7895079334772485,-0.4618629610841213},
{0.4460529710123565,0.7759339495743821,-0.4460529710123565},
{0.4452002941027504,0.8026925302648807,-0.3968392621550795},
{0.3610920203552994,0.8748480493164982,-0.32288301820140053},
{0.2781049076061953,0.9279376917145598,-0.24817191755072612},
{0.19567001861594863,0.965390091846735,-0.1724390164057626},
{0.2948848947047322,0.874845687616719,-0.38430186277639755},
{0.36304804256302886,0.802708094107897,-0.47313405546929366},
{0.4234287912672296,0.7184696458243685,-0.5518237279738698},
{0.46826790983174477,0.7033128645721978,-0.5348608970088002},
{0.513268111838824,0.6878311498753287,-0.513268111838824},
{0.5197882137450142,0.7184232954268555,-0.46226419009023917},
{0.474376171292997,0.7895692851064141,-0.3892911405695526},
{0.3873529794249723,0.8639119541115899,-0.3218909829021171},
{0.2933650546725434,0.9230921720307039,-0.2486720463433972},
{0.19238893199110174,0.9654666587104929,-0.17567193790050795},
{0.1956570349141205,0.9617321716167935,-0.1918060342269267},
{0.17204799946716737,0.9607789970244675,-0.21749299932642419},
{0.2944498566397609,0.9233285504545213,-0.24650287998393952},
{0.39278314927372915,0.8642023284323795,-0.31444511950206033},
{0.28967299080418624,0.9233689706871907,-0.25195099200168986},
{0.39231002928888714,0.8643160645276791,-0.314723023496435},
{0.48410898642897304,0.7897039778622288,-0.37683698943612887},
{0.4879751388411461,0.7895772246544919,-0.3720861058678143},
{0.37784715956224424,0.8618663639602093,-0.33825714284365377},
{0.2853871030129192,0.9162333307222683,-0.28119510149978033},
{0.23885804015765308,0.9136331536032164,-0.3289700553076017},
{0.3392878811730922,0.8508627020070877,-0.40114385950961695},
{0.27390792857071056,0.8210217858951983,-0.5008968693768828},
{0.1783020178283305,0.7483210748242539,-0.6389240638857009},
{-0.05714512524169285,0.7662893384792672,-0.6399492826733367},
{-0.26708599466829586,0.7672999846827742,-0.5830229883614036},
{-0.453675829456029,0.737365722812479,-0.5004698118654256},
{-0.6357439460526783,0.6384569458224614,-0.4338229631870864},
{-0.6858069606000484,0.667385961658344,-0.2902839833230405},
{-0.6154091063854737,0.7746861339196163,-0.1453720251303915},
{-0.21004804542699068,0.8371941810595865,-0.5049611092076984},
{-0.04250640445528862,0.791671082978629,-0.6094670638810011},
{-0.23600206995184989,0.869017257579795,-0.43487012889704735},
{-0.3658541155254065,0.8037652538041905,-0.46916114814657},
{-0.36092922254018445,0.7947924900497281,-0.48788830082006573},
{-0.34615312672287524,0.7799472855301741,-0.5214021908796417},
{-0.33648008992011,0.7667942049161937,-0.5466331460808949},
{-0.27427485783322986,0.8429675630588356,-0.4627947601164146},
{-0.3378099619610803,0.7562149148468025,-0.5603779368989262},
{-0.3528949406780126,0.7479438742698975,-0.5621789054971718},
{-0.36854713730778976,0.7390692753513958,-0.5638702100783439},
{-0.3721420747786081,0.7287551464368026,-0.574827115506347},
{-0.3992070371889317,0.629521058644296,-0.6665860620971606},
{-0.3758869048784478,0.6198568431396669,-0.6888298256854353},
{-0.3427831620559199,0.6130102898098782,-0.7118413365337489},
{-0.1776390104648032,0.7514870442704789,-0.6353830374307335},
{0.009107108408726233,0.6252568907496383,-0.7803658636476397},
{-0.136551906193652,0.5898945947631989,-0.7958504532787812},
{-0.32855400665716133,0.6779720137370691,-0.6575760133238053},
{-0.3469039747228428,0.7656669442096801,-0.5416749605308554},
{-0.35774607521146956,0.7978171677307055,-0.4852891020257357},
{-0.4865709273009565,0.6976298957664273,-0.5258909214261174},
{-0.46497300391739754,0.6913610058247164,-0.5530100046591092},
{-0.43168630046564105,0.6797754731425878,-0.5929184126876641},
{-0.40445708219984344,0.6702001362081385,-0.62229112647135},
{-0.3919012015981449,0.6633233412205793,-0.6375073279405478},
{-0.4941457890294418,0.6894197056592136,-0.5296417738747892},
{-0.49734183965975215,0.6541907890925216,-0.569811816295834},
{-0.6374061864410181,0.529926155003158,-0.5593671636146395},
{-0.6132010888715468,0.5466430792252606,-0.5702330826441717},
{-0.5758318119042815,0.5490808206425047,-0.6057458021328631},
{-0.5247526956293566,0.5483136819633523,-0.6511426223198078},
{-0.47906205256628426,0.5497260603200697,-0.6843250750892838},
{-0.4500429486021729,0.5527099368769361,-0.7014079198946609},
{-0.4442380987896794,0.5551361234511848,-0.7031901563754444},
{-0.398470905822608,0.6583028444121161,-0.6386378490598782},
{-0.4095662074738015,0.651149329852474,-0.6389523236738411},
{-0.40999301764056495,0.6406730275659187,-0.6491870279322463},
{-0.42827390123876496,0.5312568774905844,-0.7309908314313407},
{-0.40312197144969364,0.5196009632003022,-0.7533309466468443},
{-0.36850987814098934,0.5104938311896725,-0.7769147430894867},
{-0.49923807882820115,0.5587610882267064,-0.6622291045639971},
{-0.6880692234095764,0.45523314780990237,-0.5650871834784699},
{-0.7676103063533344,0.32376812921588616,-0.5531262207527188},
{-0.7321837524556709,0.34750988251022996,-0.585784801951757},
{-0.6743620745062237,0.37741204169799436,-0.634662070120008},
{-0.614044745717676,0.3907638381806251,-0.685749716023901},
{-0.5555828526700031,0.4072318920098539,-0.7249068077685131},
{-0.5117608536310433,0.4238758787670653,-0.7472817862695932},
{-0.4914088843474241,0.43656389725513545,-0.7536108226384673},
{-0.48327518656117263,0.43991916982422946,-0.7569122921946931},
{-0.447377019439203,0.552238023995571,-0.7034820305673501},
{-0.44242695675409444,0.5431659469071608,-0.7136029302474578},
{-0.4512848409358858,0.4227948509777365,-0.7858667230059979},
{-0.4235411305205726,0.4102451264232089,-0.8076582488920426},
{-0.387382818918331,0.3995748132191968,-0.8308276116305546},
{0.18792300503079287,0.6878330184136341,-0.7011210187693605},
{0.20936804996056155,0.5881491403473994,-0.781182186410012},
{0.256342962023562,0.6055609102879744,-0.7533818883887415},
{0.22909693190106162,0.7033167909394665,-0.6729487999663354},
{0.2661890286778766,0.7184720774045934,-0.6426050692310609},
{0.2282299751343456,0.80270991254476,-0.5509699399718283},
{0.27086804464867326,0.7895091301391429,-0.550732090780207},
{0.3154049651712509,0.7759349143170038,-0.5463009396744488},
{0.3415149487377563,0.7895078814929022,-0.5099459234558478},
{0.22756587969073008,0.4765387480640378,-0.8491905510509073},
{0.2416499069505464,0.35799286215165305,-0.9019126527104827},
{0.29795904327766026,0.37810405491848365,-0.876503127309459},
{0.2795968724571626,0.4959697737550079,-0.8220946249876468},
{0.32801397669034354,0.5151309633932496,-0.7918629437278456},
{0.2994538646886576,0.6226777186365984,-0.7229106733452956},
{0.31388094031774205,0.703314866269614,-0.6378298787211248},
{0.36293407849103576,0.6878321487560992,-0.6286221359508668},
{0.35148901033746766,0.6055630178099113,-0.7139670209981274},
{0.40437200367291093,0.5881630053422846,-0.7003910063616515},
{0.4425730168503041,0.60556002305579,-0.6613820251811291},
{0.3954390687617193,0.7033131222970195,-0.5907441027227288},
{0.38362592282866625,0.4959789002274065,-0.7789968432946738},
{0.4395681538207484,0.47658016677258636,-0.7613482664232135},
{0.48282422060702357,0.4959742266153877,-0.7217273297641487},
{0.5217782824918822,0.5151262788904731,-0.6799943681504106},
{0.47634416880020763,0.622674220654612,-0.6207842199848599},
{0.5243002205411669,0.605559254721893,-0.5986712518245296},
{0.571868177059279,0.5881611821038467,-0.571868177059279},
{0.5852398033301971,0.6225917907780638,-0.5194938254241293},
{0.5516471916149611,0.7031672442455362,-0.44859915582116816},
{0.5721720695549576,0.4959730602919768,-0.6531690794011976},
{0.6216410778487387,0.47657605968210026,-0.6216410778487387},
{0.6100959245531022,0.37811595324067165,-0.6962839138947514},
{0.6602270324636941,0.358051017605548,-0.6602270324636941},
{0.6869922378583941,0.39788713776108436,-0.6080522105268654},
{0.6415069328772087,0.5150159461123394,-0.5685309405129052},
{0.6194590242251845,0.60516402366615,-0.5000470195553391},
{0.5654467849484714,0.7029527326520132,-0.43142483591989045},
{0.573384840991805,0.7023288052337144,-0.42185788301249744},
{0.47828482697523406,0.7863087155442242,-0.39110385851390267},
{0.4475919050735998,0.772473836171835,-0.4504949044579245},
{0.3970140354025371,0.7358840656202568,-0.5485020489110269},
{0.3472029992689641,0.6448989986421652,-0.6808489985664725},
{0.23478601349726133,0.5893020338775017,-0.7730450444404282},
{0.05299557296451779,0.6784726538798557,-0.7327116262100583},
{-0.15617801486744495,0.7060700672146963,-0.6907050657520173},
{-0.3614450080634768,0.6986190155854918,-0.6174860137754956},
{-0.5402482079175341,0.6295962423036233,-0.5583372148791893},
{-0.6961289993021308,0.5133799994853365,-0.5018419994969034},
{-0.7933551652439979,0.5035711048863185,-0.34205807124557275},
{-0.7509060148026104,0.6356730125310223,-0.17905300352967188},
{-0.6307039890255585,0.7734429865418563,-0.06323309889972481},
{0.5584682870770666,0.398005204592041,-0.7278083741252601},
{0.5849768521629136,0.2768009300460474,-0.762353807335683},
{0.6370987698232641,0.2562239074291374,-0.726948737361465},
{0.6872138129088138,0.2355299358779258,-0.6872138129088138},
{0.7251470859578529,0.26482503139196384,-0.6356330753469958},
{0.7237651198623896,0.3773700624960725,-0.5777160956752817},
{0.6775791487960586,0.49536610878216175,-0.5435981193738884},
{0.6369961920553363,0.6044901822547241,-0.4783591442260212},
{0.6486393869790223,0.6031813598587098,-0.4641542769149884},
{0.569194827917915,0.698050788961478,-0.4344448686562577},
{0.5511059066079477,0.6803388847077414,-0.4831369181261754},
{0.5237781572012999,0.6342561903590218,-0.5686611706720184},
{0.5017678842592226,0.5310518775044017,-0.682797842501771},
{0.4107950801563979,0.4749070926662555,-0.7782741518607588},
{0.34663498605730125,0.4437609821506024,-0.826389966760117},
{0.13078305966651502,0.5525942521073702,-0.8231253755304601},
{-0.04405300264077935,0.6391780383158483,-0.7677960460259193},
{-0.24498089705684387,0.6494907270782084,-0.7198236975236675},
{-0.4349060162467844,0.6124710228800804,-0.6601030246594691},
{-0.5826958707542826,0.5252058835059341,-0.6201808624398688},
{-0.7096987628460364,0.437090853941089,-0.5525208153688463},
{-0.8101045672981529,0.4190137761918125,-0.4100707809685422},
{-0.8839785474800056,0.3943407981318707,-0.2511518714321249},
{-0.8480173769293915,0.49203621870178316,-0.19689308751564968},
{-0.7726959329484016,0.6298999453396913,-0.07853059318541541},
{-0.6567411042455089,0.7541161197019923,-9.346991483662095e-10},
{0.6984198124757023,0.49423586729867586,-0.5176298610174362},
{0.7133068133097987,0.4921508711918301,-0.4989798694045108},
{0.7473540331025529,0.3757930166450005,-0.5479430242700409},
{0.764956567346425,0.37279378915068845,-0.5252297029341032},
{0.7218030395266574,0.4860900266187767,-0.4926630269787208},
{0.6507050273572667,0.5979490251392724,-0.46801701967660597},
{0.6471490783377242,0.5773270698857347,-0.49788706026948126},
{0.6399320498107128,0.5258490409307763,-0.5603300436146914},
{0.657840909056461,0.4072729436963522,-0.6335409124158259},
{0.5990638750589518,0.3482469273694543,-0.7210038496270923},
{0.5454171057209349,0.3404750659959908,-0.7658961484574943},
{0.5310449759484426,0.339690984615056,-0.7762739648417767},
{0.28321885587633333,0.4456127732377437,-0.8492445678386574},
{0.05332380514309618,0.5244220505806562,-0.8497870819622059},
{-0.09872352504057126,0.5902901497232048,-0.801131203201648},
{-0.31412798362450867,0.5886739693124269,-0.7448399611714939},
{-0.4701438585758121,0.5316408400768772,-0.7045017880784967},
{-0.5901050975024832,0.45996607599974104,-0.6634811096263293},
{-0.6922706944878568,0.412973817746848,-0.5917887388324432},
{-0.8096450463238426,0.38374102195574317,-0.44409202540872594},
{-0.8941661635591013,0.3619520662075541,-0.2635480482076863},
{-0.9210277467524036,0.3759658966236794,-0.1017719720165789},
{-0.8770219716719453,0.47128498477736336,-0.09339659698326383},
{-0.8029880930787717,0.5959950690850705,-6.251760724676012e-10},
{-0.7726959329484016,0.6298999453396913,0.07853059318541541},
{-0.6307039890255585,0.7734429865418563,0.06323309889972481},
{-0.6154091063854737,0.7746861339196163,0.1453720251303915},
{-0.5612487325240715,0.7910836229909943,0.24328288405797371},
{-0.4180050186735386,0.8500020379721419,0.3205750143210479},
{-0.3302211280865262,0.8997863490100966,0.2851991106233377},
{-0.28156790136649984,0.9375566715730178,0.20422292846051646},
{-0.33366897531583584,0.938402930578826,0.08980509335639861},
{-0.2708270814656108,0.9613882891885249,0.04883901469092434},
{-0.34496383533091607,0.938329552086764,-0.023186288931984843},
{-0.33451100570880504,0.9396410160360265,-0.07195240122794833},
{-0.3912612236350022,0.9084515192478713,-0.14707308406324854},
{-0.47524397547123326,0.8534829559491852,-0.21379898896519303},
{-0.46227802188331757,0.8507420402724277,-0.2500740118380039},
{-0.43153485919408224,0.860110719353659,-0.27200591124693374},
{-0.4076968183437922,0.8620586158952143,-0.3010618658567975},
{-0.38823701712552344,0.8579950378470199,-0.3363280148357654},
{-0.3509989599459315,0.8697719007464202,-0.3468379604207618},
{-0.3371429610433017,0.8630249002779101,-0.3761949565308634},
{-0.3142129148918301,0.8581267675665281,-0.4060648900126697},
{-0.28017502224687824,0.8630380685282459,-0.4203180333747243},
{-0.24927606886489168,0.8697722402828775,-0.42586111764819573},
{-0.22829301498903498,0.8630260566637037,-0.4506310295870825},
{-0.19839898357157282,0.8581279289427197,-0.47355496078728304},
{-0.16180395708466125,0.863036771096356,-0.4785258730803602},
{-0.1304819563863481,0.8697687092794226,-0.47589584093160375},
{-0.10373095066629771,0.8630155895559244,-0.4944127648608059},
{0.7620189650362846,0.2547169883128207,-0.5953539726833743},
{0.7868711456459282,0.2517880466047128,-0.5634151042853284},
{0.8059709595027812,0.24642598761795692,-0.5382239729561299},
{0.7798782066408463,0.3652070967672938,-0.5083441346936757},
{0.7428260012891745,0.44893800077913193,-0.4966530008619413},
{0.7672269380337681,0.38375996900505177,-0.5138979584942622},
{0.8167428302620724,0.262993945343815,-0.513580893266089},
{0.8911797863160554,0.2104679495347377,-0.40187290364033323},
{0.9226863228383126,0.12507504376245218,-0.36470012760476767},
{0.7938730917169575,0.20740302396148014,-0.5716200660398417},
{0.7547989345506325,0.21211498160729864,-0.6207139461772754},
{0.7384341701201145,0.24284905594745052,-0.6290781449267252},
{0.4784411384479676,0.39671311479808075,-0.7833982266943279},
{0.21507790042702055,0.4795997779633392,-0.8507206061483524},
{-0.01533890388008966,0.5266461332190507,-0.8499462150002076},
{-0.1680270996379153,0.5583643311028877,-0.8124014817436603},
{-0.35109488990192617,0.5346968323271201,-0.7686557589611216},
{-0.4762650916898499,0.4805630925172947,-0.7363631417635411},
{-0.5860682194380481,0.4339681624881257,-0.684248256199017},
{-0.6960000446257842,0.4108020263395998,-0.5889190377600176},
{-0.7714109492187903,0.4212759722678249,-0.47691896860490224},
{-0.8549692748756584,0.42774413752125945,-0.29336409431759825},
{-0.9302807130521674,0.3516238915405725,-0.10458696773984101},
{-0.9319390289152727,0.36261501125085616,6.21665019288401e-10},
{-0.894717202752783,0.4466331012119852,1.2455702822599593e-09},
{-0.8770219716719453,0.47128498477736336,0.09339659698326383},
{-0.8480173769293915,0.49203621870178316,0.19689308751564968},
{-0.7509060148026104,0.6356730125310223,0.17905300352967188},
{-0.6858069606000484,0.667385961658344,0.2902839833230405},
{-0.5276977694760713,0.7634766664764363,0.3723418373430624},
{-0.3517518824501686,0.8142597278874726,0.46179184567657966},
{-0.253636019962931,0.8718170686181087,0.419051032982251},
{-0.15451793863128135,0.9302246305497335,0.3328758677942144},
{-0.191527939785732,0.9678046957328973,0.16331294865621346},
{-0.12452300723073993,0.9861560572636185,0.1095000063583918},
{-0.23821703934474123,0.9711851604042637,0.0072129311913123936},
{-0.28852390320981997,0.954157679911811,-0.07960577329490887},
{-0.36720798910383745,0.912008972937958,-0.1827509945772298},
{-0.3335389204046151,0.9198737804822671,-0.20635895075471222},
{-0.311359892746499,0.9216896825074532,-0.23139392029221278},
{-0.29125196298056727,0.9223518827649326,-0.25384896773465593},
{-0.27256991584064433,0.9224407151849426,-0.2735119155497902},
{-0.25406206972912304,0.9224392531699448,-0.29078907980910945},
{-0.23454710460169922,0.9224384113827173,-0.3067491368018633},
{-0.21402708288735459,0.9224393572377713,-0.32140012447025734},
{-0.19249802606028832,0.9224411248796268,-0.33473404531613077},
{-0.1701470006892655,0.9224400037368045,-0.34663300140421033},
{-0.14715004405334534,0.9224392761571445,-0.3570051068791339},
{-0.12350896051314181,0.9224397050882328,-0.36585588303278316},
{-0.09921803245675379,0.9224403017537943,-0.3731751220751183},
{-0.07445483072200383,0.9224363806212941,-0.37890315634531846},
{-0.05030177389861147,0.9649774992770497,-0.2574648664025145},
{-0.02524549047135334,0.991002625956411,-0.13143995038936376},
{0.0007362033296929555,0.9999994478284192,-0.0007498983358259718},
{0.026669298607762775,0.9911619482576358,0.1299489932161761},
{0.05167811717531269,0.9653013208195834,0.25597408507343516},
{0.07101802288751456,0.9229362974416505,0.3783451219321397},
{0.09768760214698986,0.8637570189837556,0.494349010864862},
{0.11915997608525057,0.7895168415483281,0.6020498791719125},
{0.1381569959275463,0.7033109792685026,0.6973279794448635},
{0.15476201211902674,0.6055290474174677,0.780630061129191},
{0.16893997008335254,0.49588791218594486,0.8517948491603484},
{0.18016798907128034,0.3779819770721809,0.9081129449152325},
{0.18814899238128302,0.2560809896305127,0.9481679616058355},
{0.19301998769256343,0.13017799169952607,0.9725209379896357},
{0.20544493222745194,-1.3332195601951058e-05,0.9786686771549962},
{0.19301099479661663,-0.13020599648977657,0.9725189737818613},
{0.1881330677447545,-0.2561060922211313,0.9481643414240851},
{0.18014599556831845,-0.3780019907009621,0.9081089776600653},
{0.1689130832206251,-0.4959012443221729,0.8517924196637481},
{0.15472798295454743,-0.6055379332915228,0.780629914002691},
{0.1381130599301701,-0.7033173051842145,0.6973303025863279},
{0.11910595826021754,-0.7895197233187828,0.6020567890137506},
{0.09762239633551109,-0.8637569675768272,0.49436198144294685},
{0.07093151388792186,-0.9229351807046117,0.37836407408118633},
{0.05158572253108831,-0.9653004216141208,0.2559961118113835},
{0.026561902049574742,-0.9911620764802443,0.12997001002877165},
{0.0006092257236717955,-0.9999995464274266,-0.0007321126679336225},
{-0.025394108614231487,-0.9910013361691108,-0.13142104458086393},
{-0.05046882335583021,-0.9649764465692786,-0.2574361191356146},
{-0.07462981004468652,-0.9224391241543003,-0.3788620509923653},
{-0.10387698318699223,-0.8630248603151225,-0.4943659199844105},
{-0.12043297737197044,-0.7885828518339705,-0.6030198866992071},
{-0.13928004086720738,-0.7022372060487156,-0.6981862048600808},
{-0.15572998712315508,-0.6044249500219162,-0.7812929353972338},
{-0.1697570468476889,-0.4948821365721472,-0.8522172351855706},
{-0.18081597782102313,-0.37714795373884624,-0.9083308885836859},
{-0.1886590032839873,-0.25545300444667046,-0.9482360165059445},
{-0.19339507940590858,-0.1298190533022862,-0.9724943992955849},
{-0.18425605191821467,5.989951687801265e-06,-0.982878276947676},
{-0.19340004258205246,0.12982802858501916,-0.9724922141194693},
{-0.188667062446261,0.25545708455286026,-0.9482333138524777},
{-0.18081499514855293,0.37714098988093026,-0.9083339756284914},
{-0.23756306683279552,0.39701711169145015,-0.8865332494053312},
{-0.2975839590790838,0.37714894813806316,-0.877041879397541},
{-0.3574559176990015,0.35710491777981607,-0.8629608013110649},
{-0.4097500886902114,0.377149081633739,-0.830580179778684},
{-0.45890605485029057,0.39702004745342695,-0.7948460950031904},
{-0.5144309721914058,0.37714797961251223,-0.7701429583683833},
{-0.5686229684999943,0.35710398021751133,-0.7410429589484443},
{-0.6107560860127856,0.3771480531137641,-0.6962300980500917},
{-0.6489899589315922,0.3970189748764416,-0.6489899589315922},
{-0.6962300980500916,0.37714805311376404,-0.6107560860127856},
{-0.7410429589484443,0.35710398021751133,-0.5686229684999943},
{-0.7701429583683833,0.37714797961251223,-0.5144309721914058},
{-0.7948467787917877,0.39701888950846737,-0.45890587228513674},
{-0.8305817939609222,0.377147906442439,-0.4097478983554904},
{-0.8629634177100209,0.35710375904199865,-0.3574507588078584},
{-0.8770452514690817,0.3771481081370525,-0.2975750853216334},
{-0.886536771300582,0.39701889758124675,-0.2375469387201429},
{-0.908331052823994,0.37714802193304386,-0.18081501051529725},
{-0.9260737393783455,0.35710389950151356,-0.12191896568877704},
{-0.9241785469914048,0.37714881513133425,-0.06043827037471163},
{-0.9178099648937694,0.3970199848139858,9.334749642945832e-10},
{0.8390616316125887,0.29989486833208673,-0.4539148007101123},
{0.921054672043345,0.14960194673176794,-0.3595518719756462},
{0.9553713397750113,0.10518103740732707,-0.2760480981756954},
{0.9487710804168914,0.12137901028796397,-0.2917200247258986},
{0.9735776722798838,0.08423307164594791,-0.21225292855264002},
{0.9697859204570517,0.055197695472622,-0.2376309805092357},
{0.9106908822408963,0.08740828869745823,-0.40373494779406877},
{0.9003499236404258,0.10305099126014275,-0.42278896414284667},
{0.8870193177113056,0.15613905592566285,-0.4345311556397454},
{0.6966833421363966,0.33371016388276575,-0.635035311861473},
{0.4112940009184195,0.47866700106886345,-0.7757030017321448},
{0.1485399837430424,0.5202629430598253,-0.840988907957974},
{-0.04554440586793344,0.5303570683311136,-0.8465501090693708},
{-0.20836800375958392,0.5322610096035855,-0.8205370148049494},
{-0.3618421960662372,0.501314271639969,-0.7859734258841391},
{-0.47001797059003647,0.4657779708553417,-0.749755953086272},
{-0.6044060937657554,0.4559190707299224,-0.6533231013545938},
{-0.6701353226015466,0.5096082453241942,-0.5396462597844228},
{-0.7554047765324151,0.5553398357166174,-0.34779489711358985},
{-0.8973768185526692,0.42657891374681883,-0.11289497717292017},
{-0.9362220381206215,0.35140901430849686,1.2426100505959757e-09},
{-0.9302807130521674,0.3516238915405725,0.10458696773984101},
{-0.9210277467524036,0.3759658966236794,0.1017719720165789},
{-0.8839785474800056,0.3943407981318707,0.2511518714321249},
{-0.7933551652439979,0.5035711048863185,0.34205807124557275},
{-0.6357439460526783,0.6384569458224614,0.4338229631870864},
{-0.453675829456029,0.737365722812479,0.5004698118654256},
{-0.26708599466829586,0.7672999846827742,0.5830229883614036},
{-0.16681501161282744,0.8281110576489533,0.5351680372557241},
{-0.05916158469787112,0.8899477698152349,0.45220888303628703},
{0.027170098881692206,0.9415759612452004,0.33570298618263156},
{-0.06072871701531774,0.9665602708163605,0.24914506980688436},
{0.005074789108018241,0.979939827758665,0.1992289649820714},
{-0.06811710293768568,0.9948340429041986,0.0752681032460868},
{-0.183280952767487,0.9830567466608512,-0.002743209293059826},
{-0.2594059571492523,0.9598558414433463,-0.10670198237411439},
{-0.2352370083392697,0.9629370341365999,-0.13196900467836728},
{-0.21520708329656335,0.9644143732795487,-0.15359305944866594},
{-0.19866492669851624,0.9649196439731823,-0.17164593666772462},
{-0.18500899030747178,0.9649769494453415,-0.18598699025623486},
{-0.17242604819343207,0.9649762697128351,-0.19771205526092261},
{-0.159158964133054,0.9649757825398371,-0.20854295300422523},
{-0.1452090613111993,0.9649764074391796,-0.2184830922494801},
{-0.13057402442739904,0.9649771805250529,-0.2275290425654547},
{-0.1153829575379833,0.9649766448794928,-0.23559891329737767},
{-0.09974952912610618,0.9649762817657574,-0.24263307084701696},
{-0.08367470262014408,0.9649770302167653,-0.2486320077855273},
{-0.06715520865321647,0.96497812434128,-0.2535890326759583},
{-0.033885507516835674,0.9910022198344185,-0.12948502872371564},
{0.000617011693938313,0.9999995039615324,-0.0007819036121455381},
{0.03507251229543855,0.9911623474737035,0.12793404485008583},
{0.06829867070227759,0.9653015859196435,0.25204789188033827},
{0.1004420291187009,0.9192852665058935,0.38056011032648507},
{0.13545694315760531,0.852223642377633,0.5053377879428745},
{0.16331799683048767,0.7759409849413135,0.6092969881753735},
{0.18792300503079287,0.6878330184136341,0.7011210187693605},
{0.20936804996056155,0.5881491403473994,0.781182186410012},
{0.22756587969073008,0.4765387480640378,0.8491905510509073},
{0.2416499069505464,0.35799286215165305,0.9019126527104827},
{0.2446978713979663,0.2437438718993449,0.938462506786936},
{0.25643809436205584,0.13023604792322782,0.9577463524239056},
{0.26504900181628005,0.013242400090745135,0.9641440066069126},
{0.25717990487881504,-0.10888495972754403,0.960209644854526},
{0.2514670579754854,-0.23548305429038893,0.9387822164353261},
{0.24162802201279707,-0.35800403261488484,0.9019140821661804},
{0.22753799076241282,-0.4765459806531867,0.849193965524424},
{0.2093360190934345,-0.5881540536452395,0.7811870712516854},
{0.18788806010981543,-0.6878352200546862,0.7011282243074314},
{0.16328001517442892,-0.7759410721120868,0.609307056625954},
{0.13541697101278172,-0.8522228175740555,0.5053498918253191},
{0.10039997172330575,-0.919283741092504,0.380574892814712},
{0.06825659194952588,-0.9653008861482887,0.2520619702707342},
{0.03502661037207159,-0.9911622935027442,0.12794703788764664},
{0.0005636387427820453,-0.9999995436476987,-0.0007713726479821563},
{-0.033948987161615804,-0.9910016252359594,-0.1294729510376118},
{-0.06722861473933892,-0.9649772115635763,-0.253573055593875},
{-0.0992962843566814,-0.9224408546769773,-0.37315294121280185},
{-0.1305540041907836,-0.8697720279196826,-0.47587001527542777},
{-0.1546609265866514,-0.801819619397966,-0.577204726016566},
{-0.18030405885188547,-0.7174192341681873,-0.6729042196383282},
{-0.2027530144155371,-0.6215480441914459,-0.7566830537994104},
{-0.2220080240979733,-0.5140270557953268,-0.8285460899349545},
{-0.2375459951485982,-0.3970189918916812,-0.8865369818942554},
{-0.2487659400383357,-0.27599393347539625,-0.9284087762196249},
{-0.2558500145081034,-0.15106700856633049,-0.9548400541446842},
{-0.2588241246545283,3.303031590801652e-06,-0.9659244652072475},
{-0.2558620129051685,0.1510720076197701,-0.9548360481600218},
{-0.24878400583721919,0.2759970064757178,-0.9284030217831203},
{-0.3107439791869905,0.25545598289006977,-0.9155219386801735},
{-0.37198887750017695,0.2347999226779328,-0.8980497042628516},
{-0.4276530387774411,0.25545502316338525,-0.8670960786239406},
{-0.4805799618013436,0.27599497806267803,-0.832387933838064},
{-0.5371029627629215,0.2554549822894344,-0.8039049442656742},
{-0.59174309268887,0.23479903677821962,-0.7711741207944103},
{-0.6375004361126038,0.2554541747556221,-0.7268674972484078},
{-0.6796420895928048,0.27599503638263406,-0.6796420895928048},
{-0.7268679689118576,0.2554539890742331,-0.6374999727341267},
{-0.7711739397231193,0.23479998164744717,-0.5917429537478932},
{-0.80390514962686,0.25545404754638906,-0.5371030999683238},
{-0.832387933838064,0.27599497806267803,-0.4805799618013436},
{-0.8670970683987873,0.2554550201509314,-0.42765103373418406},
{-0.8980516383861098,0.23479890545471777,-0.3719848502147504},
{-0.9155251677988414,0.25545404682000517,-0.3107360569521758},
{-0.9284083819263977,0.27599511353820316,-0.2487661023367983},
{-0.9482358898292196,0.255454970319966,-0.18865697808089027},
{-0.9637277729876855,0.23479994469135335,-0.12687697011330848},
{-0.9647539377188644,0.25545398350878545,-0.0631909959206106},
{-0.961159065692341,0.2759950188634322,2.4892701701341544e-09},
{-0.8511528742085517,0.1781209736755923,-0.4937729270255514},
{-0.7073392390032496,0.33820311427563865,-0.6207172097344837},
{-0.47787696282427994,0.4001429688714792,-0.7819969391657235},
{-0.6856726410391528,0.21049788980091033,-0.6968096352087542},
{-0.8672112444531129,0.08794742479098594,-0.4901121381548483},
{-0.9170132592823261,0.03331300941913815,-0.3974631123813198},
{-0.9313917165713831,-0.005019828472433225,-0.3639838892373118},
{-0.8996252314936455,0.06457881661757048,-0.4318611111275001},
{-0.8187348998503062,0.2601119681824557,-0.5118739373863042},
{-0.8649208419707599,0.11957297815288294,-0.4874569109369996},
{-0.8293912897126486,0.15789805515498456,-0.5358901871904943},
{-0.8004258167901555,0.14857596599237674,-0.5807268670771522},
{-0.7445260129886286,0.1965370034286863,-0.6380080111303688},
{-0.6860105921304656,0.2194268695391352,-0.6937155875494387},
{-0.6244559919844829,0.24750999682296168,-0.7408059904910143},
{-0.571672911192621,0.27592995713525026,-0.7726918799650303},
{-0.5379260466863347,0.2983990258979034,-0.7884120684258922},
{-0.5170661160190496,0.3087670692810084,-0.7983141791253564},
{-0.49492777341098126,0.30782985906859656,-0.8125806279823905},
{-0.47048310498619944,0.4339980968447331,-0.7683041714436376},
{-0.46937703613029874,0.299825023079032,-0.830536063930516},
{-0.4382071558795154,0.2890531028222771,-0.8511303027649764},
{-0.40023106785798257,0.27918804733549984,-0.8728511479893061},
{-0.8569400234737771,-0.034621700948376855,-0.5142520140866768},
{-0.8225938831715234,-0.022777996764966627,-0.5681729193055309},
{-0.7840957842066768,0.010026997240440389,-0.6205588292141665},
{-0.7341587919323762,0.035506089937234496,-0.6780488078344824},
{-0.6774340614328364,0.0682109061856787,-0.732414066418676},
{-0.6224991489783817,0.10345702475964849,-0.7757521856553625},
{-0.579028806829653,0.13394095531583142,-0.8042297317001597},
{-0.546305039888464,0.15246401113216018,-0.8235930601346495},
{-0.5149007869531498,0.15941093404166734,-0.8422976514884689},
{-0.4827547788959481,0.15837692746259194,-0.8613156055132364},
{-0.7910185335198969,-0.17925989428670705,-0.5849406550483137},
{-0.8231292843603495,-0.19570306760808265,-0.533065184154063},
{-0.8475114976067746,-0.22596986604815372,-0.4802727153009025},
{-0.7957978107258796,-0.3587839146661263,-0.48783188397310284},
{-0.7703432145151938,-0.343499095653176,-0.537196149591421},
{-0.738965034921641,-0.326178015414358,-0.5895240278594325},
{-0.7514632117961788,-0.15715404429308785,-0.6407851806021247},
{-0.9161512140367273,-0.0797897186409514,-0.39281109177087714},
{-0.8886810198103487,-0.04663730103963196,-0.4561480101683854},
{-0.8975669581688929,-0.2431949886658978,-0.3677359828616649},
{-0.8741165036131904,-0.22166112770776808,-0.43218824900079345},
{-0.8186039696068723,-0.37423198610551506,-0.43570398382318276},
{-0.7599941831867401,-0.47694711496191566,-0.4415091064200433},
{-0.739009949361562,-0.4630999682674651,-0.4892879664730111},
{-0.7125110225313802,-0.44982501422459176,-0.538503017028812},
{-0.6788329350156657,-0.43428095842650294,-0.5921029433182841},
{-0.6996450360660028,-0.3042140156819287,-0.6464910333259671},
{-0.7037480510607936,-0.12793300928224377,-0.6988360507044009},
{-0.6058551395298937,-0.05905451360039631,-0.7933801827173614},
{-0.6528436147126216,-0.09340744487391966,-0.7517115563639312},
{-0.6554150497895892,-0.2762590209864317,-0.7029310533992138},
{-0.6133306851437068,-0.23427487973384994,-0.7542816127858619},
{-0.5716022377597151,-0.2073210862358457,-0.7939073302282044},
{-0.5669426954700985,-0.016767890993226942,-0.8235865576153721},
{-0.4593751690257464,-0.0018910006957881611,-0.8882403268254238},
{-0.49720689344396934,-0.008454848188047924,-0.8675908140672735},
{-0.5345471979185715,-0.020853307721033602,-0.8448813128212124},
{-0.5304742097824334,-0.18972807503025885,-0.8261963267293164},
{-0.49159909744330793,-0.16954603360690945,-0.8541571693084884},
{-0.45238502177894646,-0.15447100743662065,-0.878343042285631},
{-0.4187738156790894,0.0013300794145731187,-0.9080896003095328},
{-0.4478750436763285,0.15322401494225343,-0.8808690859014766},
{-0.4080119710236028,0.14743798952917553,-0.9009929360128355},
{0.2446978713979663,0.2437438718993449,-0.938462506786936},
{0.25643809436205584,0.13023604792322782,-0.9577463524239056},
{0.3073529880917623,0.24734399041678093,-0.9188879643981459},
{0.36773211313464066,0.2768050851604816,-0.8877792731297742},
{0.3510741517181317,0.398010172001725,-0.8475463662706315},
{0.40909895071564784,0.3781239544472209,-0.8304578999543276},
{0.4668550615814547,0.3580560472301021,-0.8086051066606809},
{0.5146558884357392,0.3781179180336862,-0.7695168331883913},
{0.26504900181628005,0.013242400090745135,-0.9641440066069126},
{0.25717990487881504,-0.10888495972754403,-0.960209644854526},
{0.3152938638025139,-0.013249594276572936,-0.9489015901029928},
{0.3196179830683976,0.10889899423113038,-0.9412679501368023},
{0.3782560771396609,0.1515870309139043,-0.9132051862345186},
{0.42724617841184626,0.25623210699883486,-0.8670673620748335},
{0.485940069676036,0.23553603377210108,-0.8416561206800298},
{0.43831825375522177,0.1302830754246724,-0.8893275148576378},
{0.4970350586389571,0.1089140128494037,-0.8608681015630725},
{0.5510319332234747,0.1302789842122074,-0.8242519001134516},
{0.5372892105177446,0.2562251003927292,-0.8035353148368493},
{0.38267380182598154,-1.2905893316467632e-06,-0.9238835215514906},
{0.4519209851758621,0.0,-0.8920579707382688},
{0.5000098398718743,0.0,-0.8660197226572282},
{0.5465980656931658,0.0,-0.8373951006427549},
{0.6087636945224547,0.0,-0.793351601896266},
{0.6017289866557572,0.15158399663839753,-0.7841839826095441},
{0.6535532870426274,0.13027705721808694,-0.7455843274629453},
{0.7029005650723266,0.10891093261012881,-0.7029005650723266},
{0.7433069482279295,0.1300769909400078,-0.6561819542962722},
{0.7778372318476448,0.1287840383862777,-0.6151291833497377},
{0.6673970585931263,0.0,-0.7447020653800037},
{0.7071067811865475,0.0,-0.7071067811865475},
{0.7029005650723266,-0.10891093261012881,-0.7029005650723266},
{0.7471121062652655,-0.009712151381404927,-0.6646270945330346},
{0.7855826849574208,-0.002208429114352674,-0.6187527518613043},
{0.814517242385139,-0.007476182224772384,-0.5800911726243131},
{0.8055068329503855,0.12525397402426994,-0.5791978798833497},
{0.8272530220405024,0.11831200315218673,-0.549231014633162},
{0.8491374687027837,0.1072160591806006,-0.517175285467907},
{0.8268701819147676,0.23579605187608033,-0.5105741123283594},
{0.8137978526090153,0.3231049414808538,-0.4830489125126041},
{0.8825682389492051,0.19167105189360265,-0.42934311624165905},
{0.9391699005258296,0.04145449560925924,-0.34094196388840936},
{0.9665760142158976,0.011210200164873797,-0.25613500376710047},
{0.9851683204672481,-0.017214405599706238,-0.17072505553547304},
{0.9800750830146124,0.06492710549947509,-0.18771601589997802},
{0.9948079147537944,0.038286496719187164,-0.0942939919198421},
{0.9936929451210977,0.0538168970278422,-0.0983771945669007},
{0.9927802876536179,0.022525306526606136,-0.11781303413579614},
{0.9666252231082434,0.03195400737535323,-0.2541940586709187},
{0.9636767808663381,0.04947868874887673,-0.2624479403210917},
{0.9578782025117574,0.1065390225241629,-0.2666810563809148},
{0.8591083965675342,0.2643251220134296,-0.43825220229879713},
{0.6353858330736797,0.44495388310328854,-0.6311108341967923},
{0.34999296210468905,0.5511959403195383,-0.7574219179905249},
{0.09346001774759176,0.5538131051663496,-0.82737915711518},
{-0.09454743434555495,0.5404881963391939,-0.8360223036957076},
{-0.24564089903559302,0.5207477859599455,-0.8176076639432878},
{-0.35819019366095345,0.49922326991262217,-0.7889714265693517},
{-0.4806761322664678,0.506385139340752,-0.7159081969946959},
{-0.5304537990903965,0.590331776411587,-0.608380769575523},
{-0.605181817879637,0.6798547954079279,-0.4141888753560895},
{-0.8066375245583035,0.5746256613088395,-0.1383519184537431},
{-0.8945309669036967,0.44700598346144954,0.0},
{-0.8973768185526692,0.42657891374681883,0.11289497717292017},
{-0.8549692748756584,0.42774413752125945,0.29336409431759825},
{-0.8941661635591013,0.3619520662075541,0.2635480482076863},
{-0.8096450463238426,0.38374102195574317,0.44409202540872594},
{-0.8101045672981529,0.4190137761918125,0.4100707809685422},
{-0.6961289993021308,0.5133799994853365,0.5018419994969034},
{-0.5402482079175341,0.6295962423036233,0.5583372148791893},
{-0.3614450080634768,0.6986190155854918,0.6174860137754956},
{-0.15617801486744495,0.7060700672146963,0.6907050657520173},
{-0.05714512524169285,0.7662893384792672,0.6399492826733367},
{0.052724697752871065,0.8352249644026754,0.5473749766708544},
{0.1371280072747781,0.897317047603568,0.4195450222572836},
{0.11648502371338289,0.9546351943394022,0.2740490557894052},
{0.6535532870426274,-0.13027705721808694,-0.7455843274629453},
{0.6872138129088138,-0.2355299358779258,-0.6872138129088138},
{0.7416682891720723,-0.15191205922961196,-0.6533382547327151},
{0.7800917495714763,-0.13295295731885018,-0.6113758037334197},
{0.8097851678178711,-0.13952202891419946,-0.569896118103859},
{0.8331891614266663,-0.15259202956402196,-0.5315181029792507},
{0.8374368882320962,-0.017866597615447573,-0.5462419270962194},
{0.8594368479544623,-0.0345089938949109,-0.5100759097609484},
{0.884853160481408,-0.05618101018926984,-0.4624700838758944},
{0.8760741722408598,0.09124061793839265,-0.4734650930857653},
{0.8568700754019994,0.20700901821617337,-0.47214504154734904},
{0.9067996053781766,0.06901166996744276,-0.41587481901924256},
{0.9396611119653264,-0.10738801279581943,-0.3248150387033383},
{0.9616275505372193,-0.13255407588795923,-0.24021213752280926},
{0.9754240065821612,-0.1541020010398803,-0.15748200106268856},
{0.9824935409590771,-0.16933992088095207,-0.07765586371760438},
{0.9956471913769892,-0.03760440722808069,-0.08527941639186863},
{0.9996221581650235,-0.027487104349141794,-1.2445601969202975e-09},
{0.9993218404243039,0.036821994120117156,-3.1086195036032424e-09},
{0.9988908443828575,0.04580329286430785,0.010915098299537514},
{0.9996086262458547,0.026114890235630003,-0.010030296249667416},
{0.9999988200445085,0.0015361997235520974,-9.329148321166547e-10},
{0.9906919918844604,0.009624239921160259,-0.13578199888770257},
{0.9918339094508796,0.025777697646634356,-0.12490398859693523},
{0.9885297160481963,0.08312227612340847,-0.12609396377993715},
{0.9377681870688299,0.22163904421322586,-0.2673330533284048},
{0.8083208549286485,0.39814792854340236,-0.43369992216279774},
{0.6006277908992792,0.5300988154530207,-0.5985327916286257},
{0.5123560125043048,0.6215980151704105,-0.5925430144613087},
{0.2816339321817124,0.6246008495942598,-0.7283928246008439},
{0.065454064810045,0.5975166787581473,-0.7991805703379401},
{-0.11589099534662896,0.5638929773580057,-0.8176759671678575},
{-0.24877286112333538,0.5358467008652703,-0.8068335495877172},
{-0.36040491785471845,0.5504038745492112,-0.7531028283490574},
{-0.38599892797762475,0.6519778783494149,-0.6526328782272006},
{-0.43090013752567896,0.7752312474220692,-0.46188914741610193},
{-0.6581530416199542,0.7324540463185643,-0.17420001101597354},
{-0.7977057819690913,0.6030468351737539,0.0},
{-0.8066375245583035,0.5746256613088395,0.1383519184537431},
{-0.7554047765324151,0.5553398357166174,0.34779489711358985},
{-0.6701353226015466,0.5096082453241942,0.5396462597844228},
{-0.7714109492187903,0.4212759722678249,0.47691896860490224},
{-0.6960000446257842,0.4108020263395998,0.5889190377600176},
{-0.6922709803772332,0.41297298829407436,0.5917889832254457},
{-0.7096987628460364,0.437090853941089,0.5525208153688463},
{-0.5826958707542826,0.5252058835059341,0.6201808624398688},
{-0.4349060162467844,0.6124710228800804,0.6601030246594691},
{-0.24498089705684387,0.6494907270782084,0.7198236975236675},
{-0.04405300264077935,0.6391780383158483,0.7677960460259193},
{0.05299557296451779,0.6784726538798557,0.7327116262100583},
{0.1783020178283305,0.7483210748242539,0.6389240638857009},
{0.2724410658607285,0.8291132004323367,0.48820811802090935},
{0.24002605134349805,0.9086981943778342,0.34154807305987306},
{0.1618119675112346,0.9629128066654232,0.21590695664998968},
{0.04900801219601291,0.9877252458028658,0.14831403690906503},
{-0.04055201191144133,0.9982202932096805,0.04372391284313153},
{-0.15361407275484956,0.9876104677530496,-0.03206681518751683},
{-0.1317260643359371,0.9897594834054989,-0.05499462685976288},
{-0.11484596328703543,0.990693683303609,-0.07305087664772736},
{-0.10244800650423153,0.9909770629152727,-0.08642260548680893},
{-0.09413745819082986,0.9910015598675213,-0.09515275773990595},
{-0.08770333085895343,0.9910013486898864,-0.10111603557829563},
{-0.08091992118702258,0.9910012594709158,-0.10662302791679065},
{-0.0737888259005303,0.9910013478502351,-0.11167603919927714},
{-0.0663083686395122,0.99100153130665,-0.11627194500928031},
{-0.05854772135234938,0.9910013614181187,-0.12036804389821616},
{-0.05055742111299177,0.9910014138463598,-0.12393605175621665},
{-0.04233718812364054,0.9910017220058017,-0.12697696438062755},
{0.0005324627490574393,0.9999995287136184,-0.0008118226173988759},
{0.043355201690960424,0.9911620386577784,0.12537200488981923},
{0.0846479168947351,0.9653001926626389,0.24704304930690593},
{0.1244350636339302,0.9229414719762379,0.3642731862829803},
{0.16267097057908694,0.863750843780741,0.4769409137397588},
{0.19792098265212768,0.7895119307988875,0.5809459490797992},
{0.22909693190106162,0.7033167909394665,0.6729487999663354},
{0.256342962023562,0.6055609102879744,0.7533818883887415},
{0.2795968724571626,0.4959697737550079,0.8220946249876468},
{0.29795904327766026,0.37810405491848365,0.876503127309459},
{0.3073529880917623,0.24734399041678093,0.9188879643981459},
{0.3196179830683976,0.10889899423113038,0.9412679501368023},
{0.3152938638025139,-0.013249594276572936,0.9489015901029928},
{0.31888001486602724,-0.13026900607307607,0.9388000437663897},
{0.3109839576959222,-0.25621296514658415,0.9152288754986789},
{0.2979459632608814,-0.37810795337626735,0.8765058919198181},
{0.2795810651140183,-0.4959711155109423,0.8220991914656909},
{0.25632483082400137,-0.6055616003255395,0.7533875027595152},
{0.22907895157786906,-0.703316851334658,0.6729548577524996},
{0.19790111744138553,-0.7895114685234825,0.58095334475786},
{0.16265109718365298,-0.8637505160889283,0.476948284975493},
{0.12441496533612924,-0.9229407428549007,0.36428189850561293},
{0.08462767341374285,-0.9652996967456987,0.24705192238725612},
{0.043333698608995025,-0.991161968183855,0.12537999597532165},
{0.000507382770274859,-0.9999995472352423,-0.0008050416355053539},
{-0.042367019665694734,-0.9910014599977139,-0.12696905893581312},
{-0.08370932831001872,-0.9649763263495049,-0.24862308408291292},
{-0.12354600698887427,-0.9224390521814563,-0.3658450206954875},
{-0.1618390472198666,-0.8630372518088472,-0.47851313961603836},
{-0.19721197745453078,-0.7885829098484183,-0.5824469334140879},
{-0.22847303721060697,-0.7022371143709103,-0.6742871098187905},
{-0.25577992272250255,-0.6044248173881798,-0.7544847720513228},
{-0.27909506428271763,-0.49488211398398346,-0.822920189539526},
{-0.2975748243349376,-0.37714777736124694,-0.8770454822604712},
{-0.3107360569521758,-0.25545404682000517,-0.9155251677988414},
{-0.31876684378340564,-0.1298209363792535,-0.9389005398773503},
{-0.33187689621233774,9.462397040830261e-07,-0.9433227049952576},
{-0.31877095314529547,0.12982298091790562,-0.9388988619954913},
{0.9122819486826093,-0.08112439543661659,-0.4014479774178775},
{0.9179108774469732,-0.25766296559864676,-0.3017439597132614},
{0.9339155000791972,-0.28103815048613356,-0.22095111831162226},
{0.9435858895075142,-0.29839896505793084,-0.14353998319168426},
{0.94836949211508,-0.3093128343521956,-0.07014896243278546},
{0.9561623447859887,-0.2928371055951759,-6.224152244389248e-10},
{0.9887686868189388,-0.1494539526621867,-6.230998026403344e-10},
{-0.838840182650759,-0.39145008523513375,-0.37830408237269647},
{-0.7780371574797939,-0.49195709957532474,-0.3906870790776123},
{-0.7251961055635414,-0.560842081639264,-0.3994330581436771},
{-0.7063293258799426,-0.5494362534940123,-0.4463392059280133},
{-0.6820269394022502,-0.5397989520391352,-0.4934129561605075},
{-0.6516417049842727,-0.5293067603685925,-0.5433207540240808},
{-0.6173521296013635,-0.5150471081243658,-0.5946451248344587},
{-0.640394190833655,-0.4136701232712331,-0.6471261928397515},
{-0.8558776815690561,-0.4113758469468219,-0.3134378833848303},
{-0.9161014821678289,-0.2720298462334047,-0.2945468335055349},
{-0.8681271603044697,-0.43347608004374966,-0.2417720446445419},
{-0.8062231527010982,-0.5244920993403864,-0.27370105183980525},
{-0.7934539325294412,-0.5079839568040941,-0.3352359714935456},
{-0.7403378634350692,-0.5739208941328399,-0.3500209354340941},
{-0.6942618051884292,-0.6205198258806099,-0.3646308976836729},
{-0.6752963534312956,-0.6127823207131927,-0.41045421482029953},
{-0.6513577439031207,-0.606629761488997,-0.4557778208000463},
{-0.6226688952481093,-0.6000638990509588,-0.5022019155143278},
{-0.5909750804609673,-0.5909260804542958,-0.5491400747651516},
{-0.5601878654863054,-0.565189864285213,-0.6055988545821065},
{-0.5823252306442203,-0.4794851899118945,-0.6564992600226678},
{-0.5998379208561903,-0.3666339516255864,-0.7111779061657708},
{-0.5612769843305501,-0.35889098998066093,-0.7457649791801064},
{-0.7524926954579904,-0.587721762142586,-0.29721687971308375},
{-0.7091081809484759,-0.629755160699368,-0.31713408092549233},
{-0.657740582026054,-0.6751865709396637,-0.33391678780613326},
{-0.637960882736102,-0.6712118766242208,-0.377465930617805},
{-0.6141032446111884,-0.668025266089547,-0.4202611673995122},
{-0.5868121601008637,-0.6643131812455865,-0.4629681263123056},
{-0.5572132858666481,-0.6588673380181382,-0.5053782592737694},
{-0.5313170876309316,-0.6380481052342397,-0.557312091918327},
{-0.5242329938976659,-0.560435993476245,-0.6411639925365306},
{-0.5453497827760452,-0.4715788121605292,-0.692969723976008},
{-0.7623064362452291,-0.6010203439460107,-0.2401321374204576},
{-0.8152321130445764,-0.5405090749499664,-0.20795802883660605},
{-0.7693737732755844,-0.6126868194491859,-0.18077294672857053},
{-0.7297568023534242,-0.6490548242106644,-0.21490194179618088},
{-0.7206533355431173,-0.6396462978254622,-0.267416124511517},
{-0.6735939123341156,-0.6801559114800944,-0.2892389623565638},
{-0.6038300154625773,-0.7384060189087324,-0.3002430076884729},
{-0.5843249475892682,-0.7367919339138188,-0.3401499694904199},
{-0.5616819229223609,-0.7353268990936701,-0.37921994796097735},
{-0.5365928965196796,-0.7333008585851428,-0.4175379194790726},
{-0.5096546519459995,-0.7301725013496705,-0.45508268921435346},
{-0.4889592078304441,-0.7128013029737634,-0.5028252137241426},
{-0.4940209510778487,-0.6403799365841386,-0.588095941761744},
{-0.4899429054346591,-0.5439238950156273,-0.6812508685097388},
{-0.5096546775627381,-0.4483537163453,-0.7343235354241204},
{-0.5232799865137667,-0.3321309914401541,-0.7847719797744644},
{-0.48529506302090625,-0.3086180400774499,-0.8180731062357985},
{-0.44636108260068824,-0.28977405362370773,-0.8466361566729985},
{-0.41023303164927455,-0.14396401110675192,-0.9005460694766817},
{-0.4040808295793502,-0.2760958835568618,-0.8720606322093781},
{-0.3923772490784101,-0.39668625181373574,-0.8298675267942641},
{-0.37383606604001607,-0.5073870896324743,-0.7764051371558617},
{-0.34717802435731665,-0.6099360427918944,-0.7123520499771968},
{-0.30754803153074844,-0.710227072814614,-0.6332390649215719},
{-0.26416002435951774,-0.7967010734677928,-0.5435870501268821},
{-0.22416592367510266,-0.8631437061134285,-0.4524738459399213},
{-0.1747579421672764,-0.9226236946757299,-0.34383888621324427},
{-0.11553104098221789,-0.9651453423651029,-0.2348340833024743},
{-0.0584855826403014,-0.9911067058195727,-0.11952796452169331},
{0.0006723928467041798,-0.9999997720145508,6.211848583788588e-05},
{0.059716924384019356,-0.9910154046581275,0.11967604886693549},
{0.1165820522693417,-0.9649824326480407,0.2349841053546773},
{0.1713309793756063,-0.9224348889596009,0.3460629583418088},
{0.22393097500191486,-0.8630279036576115,0.45281094945135814},
{-0.47300764857815203,-0.4270436827271597,-0.7706474274461652},
{-0.4345539394740279,-0.4095089429623699,-0.8021628882723542},
{-0.45401199991464575,-0.5286939999006055,-0.717185999865169},
{-0.4157439005037659,-0.5162588764484243,-0.748754820807269},
{0.2514670579754854,-0.23548305429038893,-0.9387822164353261},
{0.31888001486602724,-0.13026900607307607,-0.9388000437663897},
{0.3782531036056197,-0.15158804152080402,-0.9132062501322489},
{0.4383178639468136,-0.13028295956037106,-0.8893277239540514},
{0.4970351127728066,-0.10891302471138789,-0.8608681953232679},
{0.5510319332234747,-0.1302789842122074,-0.8242519001134516},
{0.6017289866557572,-0.15158399663839753,-0.7841839826095441},
{0.6370987698232641,-0.2562239074291374,-0.726948737361465},
{0.6602270324636941,-0.358051017605548,-0.6602270324636941},
{0.7214239442768561,-0.2771119785957331,-0.6346309509807899},
{0.761844915827569,-0.2588869713968745,-0.5937759343966694},
{0.7919029101134815,-0.2655739698554971,-0.549872937585576},
{0.8154753476033725,-0.27897311891468857,-0.5071232161656275},
{0.8346211528333357,-0.30052205503070223,-0.4616210845306759},
{0.8539496338896677,-0.17359392557578662,-0.4905457896903108},
{0.8756557342726755,-0.20034493920313362,-0.4394188666535316},
{0.8973562139135944,-0.22956405472394498,-0.37689808984573114},
{0.24162802201279707,-0.35800403261488484,-0.9019140821661804},
{0.3109839576959222,-0.25621296514658415,-0.9152288754986789},
{0.36772693275396584,-0.2768069493804562,-0.8877808376519769},
{0.4272449904995669,-0.2562319943022973,-0.867067980719443},
{0.4859401841322465,-0.23553508924885516,-0.841656318920052},
{0.5372892105177446,-0.2562251003927292,-0.8035353148368493},
{0.5849770140847842,-0.27680000666465226,-0.7623540183555791},
{0.6100959245531022,-0.37811595324067165,-0.6962839138947514},
{0.6216410778487387,-0.47657605968210026,-0.6216410778487387},
{0.6891147836727766,-0.39824587498247543,-0.6054098099494796},
{0.7309650522574244,-0.38028702718710083,-0.5666320405090927},
{0.7610582774955976,-0.38588214069960003,-0.5214261901214092},
{0.784863911791897,-0.39720095535997735,-0.47562594654606755},
{0.8030756872402269,-0.4154768381915382,-0.42713983364935637},
{0.8178593418971729,-0.4381551831659929,-0.3729961559269726},
{0.8522096153855304,-0.32749985219460137,-0.4080228158534285},
{0.8681366672385046,-0.3558808635889338,-0.3459588673920888},
{0.8825052742553242,-0.3814691185487949,-0.27507408548451173},
{0.22753809919468712,-0.4765452077487372,-0.8491943702042434},
{0.2979459632608814,-0.37810795337626735,-0.8765058919198181},
{0.35106785884512115,-0.3980108399706197,-0.8475486592236364},
{0.40909811807718865,-0.3781241091372211,-0.8304582396935354},
{0.4668550615814547,-0.3580560472301021,-0.8086051066606809},
{0.5146558884357392,-0.3781179180336862,-0.7695168331883913},
{0.558468752916445,-0.39800582391012335,-0.7278076779957564},
{0.5721720695549576,-0.4959730602919768,-0.6531690794011976},
{0.571868177059279,-0.5881611821038467,-0.571868177059279},
{0.6441515008943343,-0.5152524006619683,-0.5653174395927079},
{0.6868288734497312,-0.4972569083789313,-0.5300959023282487},
{0.7166062204779114,-0.5007451540640349,-0.48552014937976457},
{0.7409871270248406,-0.5079370870738845,-0.43924707529859525},
{0.7598128077620652,-0.5197578684976376,-0.39055890118587655},
{0.7744298785210026,-0.5345729161455625,-0.33836394692338956},
{0.7858131780994693,-0.5498201246131715,-0.2831880641827413},
{0.8299201687709228,-0.4614720938440516,-0.31349006375071886},
{0.8403087064054326,-0.48164083172002087,-0.24880391307066482},
{0.8491784845734425,-0.4955696992036554,-0.18250088922728638},
{0.893981048887355,-0.4005650219048988,-0.20086201098413936},
{0.9013472880967784,-0.4130131320109955,-0.13035804166621717},
{0.9053581647239531,-0.41985207638931915,-0.06364611157999067},
{0.9138908713785509,-0.40595994286499865,-9.32949868696178e-10},
{0.2093360190934345,-0.5881540536452395,-0.7811870712516854},
{0.2795810651140183,-0.4959711155109423,-0.8220991914656909},
{0.32800695060773305,-0.5151309224300461,-0.791865880758469},
{0.3836251516934711,-0.49597719611983765,-0.7789983080323508},
{0.4395680286453307,-0.4765790310572267,-0.7613490496148352},
{0.4828249874875906,-0.49597398714683427,-0.7217269812964455},
{0.5217782824918822,-0.5151262788904731,-0.6799943681504106},
{0.5242999066575852,-0.6055588921908461,-0.5986718934169556},
{0.513268111838824,-0.6878311498753287,-0.513268111838824},
{0.5882408914383889,-0.6227278850737112,-0.5159289047837816},
{0.630259844059553,-0.6061378500278763,-0.4851488799632661},
{0.6588861808006989,-0.6077661667731863,-0.44327112163516397},
{0.6833680709045663,-0.6111690634133773,-0.3993500414355641},
{0.703294332293288,-0.6168412914458591,-0.35338916696970646},
{0.7192697542252073,-0.6240487867622541,-0.3053098956754739},
{0.7320167047359976,-0.6315557452576206,-0.25551689693549173},
{0.7423849830639716,-0.6380799854434814,-0.2042509953404221},
{0.7951942674532992,-0.5629211893312559,-0.22535707579593556},
{0.8033060531563699,-0.571734037832786,-0.1667920110369613},
{0.8095990526814216,-0.5765840375189011,-0.11000100715787578},
{0.855628460567068,-0.5036796824539851,-0.11919192485517668},
{0.8596580433852232,-0.5075020256126128,-0.05856400295560817},
{0.8685515893901617,-0.49559876570449984,-1.2433894121846858e-09},
{-0.6860707052088597,-0.6857437053493651,-0.24302789557567475},
{-0.619965838464822,-0.7404648070682174,-0.25952693237896896},
{-0.5317400894884083,-0.8055371355666754,-0.2614620440023663},
{-0.5137861225048657,-0.8050971919637745,-0.29638207066801564},
{-0.49355323704652015,-0.8044643863726727,-0.3305181587431172},
{-0.47156003934390617,-0.8033470670260603,-0.36368203034326596},
{-0.44800505032777016,-0.8015920900488565,-0.39590604447509775},
{-0.433074936508404,-0.786867884640062,-0.4396419355456393},
{-0.4512031843451899,-0.7196802940351599,-0.5277082156023596},
{-0.46074212865857145,-0.6305741760828186,-0.624574174407366},
{-0.6958397305917837,-0.6912477323696673,-0.19489392454293386},
{-0.7364645943241134,-0.6570056380934713,-0.1611319112417196},
{-0.7031079295468312,-0.6959499302640806,-0.14592098537835319},
{-0.6433309322926396,-0.7454249215477582,-0.17454798162969865},
{-0.6329940556677152,-0.742914065334466,-0.217709019146094},
{-0.5470509942958993,-0.8060429915953897,-0.2258979976445616},
{-0.4425019009579081,-0.8702788052116087,-0.216348951576134},
{-0.4272589176112436,-0.8702548321879067,-0.24516595272440872},
{-0.41035317688893036,-0.8700193750349827,-0.2732701177972087},
{-0.3921128079467227,-0.8694775741378137,-0.3004268528536673},
{-0.372535976973552,-0.8686179463107264,-0.32667997980791114},
{-0.3639079155107813,-0.8564458011572886,-0.36615791498839445},
{-0.39589103168692147,-0.7960380637144912,-0.457814036643208},
{-0.4198928611049231,-0.7143337637077163,-0.5598368148132902},
{-0.4255407140626942,-0.6216935822599764,-0.6575805581461258},
{-0.3879340663776581,-0.6146681051731024,-0.6867971175147742},
{-0.5597541924278513,-0.8067042773223905,-0.18948206513863972},
{-0.4557489749278823,-0.8702519521248306,-0.18696098971471534},
{-0.34358604124046316,-0.9247881110018612,-0.16344901961870528},
{-0.3318900793009953,-0.9248752209873995,-0.18562004435159465},
{-0.3188999980462592,-0.924861994333833,-0.20720299873057083},
{-0.30486703323005115,-0.9247171007927825,-0.22793502484457717},
{-0.28975307951738316,-0.9244482536977559,-0.24786806802281505},
{-0.27759604626416096,-0.9204501534022353,-0.27515804585784376},
{-0.32843399489679265,-0.8660039865440302,-0.3770519941413662},
{-0.3676722094585053,-0.7933924519862879,-0.4851242763695575},
{-0.386598094966094,-0.7096391743196913,-0.5890281446921308},
{-0.35103305580214966,-0.7061021122458843,-0.6149760977599906},
{-0.5700208830254566,-0.8074338343057125,-0.15207496879254678},
{-0.651176748535449,-0.7475767113087309,-0.13075894950489156},
{-0.5723500701867211,-0.8125410996411087,-0.11041901354057405},
{-0.46912718129657993,-0.8746443380107429,-0.12213504719970879},
{-0.4669329164456306,-0.8702658442720329,-0.15687897192760863},
{-0.35378299165266736,-0.9246739781827801,-0.14076799667864956},
{-0.24194411077365258,-0.9651324418840593,-0.09991204574454078},
{-0.23460295228059136,-0.9652238036686721,-0.11534497653825744},
{-0.22628394472675897,-0.9652927642127916,-0.13040496814663433},
{-0.2171370692088691,-0.9653203076799693,-0.14494204619789305},
{-0.20722999348240956,-0.9653109696400052,-0.15884099500429194},
{-0.1965129597399028,-0.9652758022415535,-0.17211996473735613},
{-0.18492499995238185,-0.9652269997514542,-0.18476899995242202},
{-0.25267911940746257,-0.9234784364041522,-0.28868813642408575},
{-0.3044731165226452,-0.8648653309861877,-0.39912915274775385},
{-0.337597915368602,-0.7911708016637901,-0.509976872155444},
{-0.29985287425822277,-0.7951546665559361,-0.5270837789700991},
{-0.27895208878084016,-0.8639492749652917,-0.41925813343542073},
{-0.24269103931036964,-0.8745131416510267,-0.4199140680164265},
{0.18788806010981543,-0.6878352200546862,-0.7011282243074314},
{0.2563249860443865,-0.6055609670302341,-0.7533879589817937},
{0.2994470294155815,-0.6226770611674388,-0.7229140710140214},
{0.3514889722343055,-0.6055619521639383,-0.7139679436004616},
{0.4043730779926562,-0.5881621134406022,-0.7003911350865525},
{0.4425738209789256,-0.6055597550511286,-0.6613817324711433},
{0.4763449418961621,-0.6226739240471735,-0.6207839242777128},
{0.46826790983174477,-0.7033128645721978,-0.5348608970088002},
{0.4460529710123565,-0.7759339495743821,-0.4460529710123565},
{0.5229800968993302,-0.7184851331230933,-0.45855308496209907},
{0.5634139773890707,-0.7034979717672201,-0.4331919826151398},
{0.5898478699134906,-0.7040588447251194,-0.39544991278649727},
{0.6132316492628719,-0.7052545966304541,-0.3557567965253142},
{0.6331783554170407,-0.7072863970155264,-0.314374176465191},
{0.6498008964119983,-0.7099248868273332,-0.27159795670321524},
{0.6634741154106689,-0.7127251239778334,-0.22765103959967412},
{0.6746216736366654,-0.7152056540032564,-0.1826649116317604},
{0.6835367459219198,-0.7169167335142136,-0.13714194902283844},
{0.7509553497793134,-0.6425112992683403,-0.15246407101457907},
{0.7574503083133937,-0.6449732625306152,-0.1013830412670629},
{0.7616231461225593,-0.6460311239454469,-0.050734309733720964},
{0.8137581588791187,-0.5786351129734133,-0.054580810656422916},
{0.8227971746658711,-0.5683351206478973,-3.107680659707843e-10},
{0.16328001517442892,-0.7759410721120868,-0.609307056625954},
{0.22907895157786906,-0.703316851334658,-0.6729548577524996},
{0.26618203169615967,-0.7184710855533866,-0.6426090765199656},
{0.31388096087191575,-0.7033139123255965,-0.6378309204886403},
{0.3629358150472298,-0.687831649479705,-0.6286216796532164},
{0.39543991238930853,-0.7033128441792983,-0.5907438691192335},
{0.4234299161953944,-0.7184688578017354,-0.551823890783854},
{0.40417880258416644,-0.7895076143753635,-0.46186277440918716},
{0.3699500332790417,-0.8522170766616167,-0.3699500332790417},
{0.45125301440986276,-0.7974700254656107,-0.40051501278964613},
{0.47911573409251823,-0.7952285586510557,-0.37156379378345217},
{0.5097920610848178,-0.789627094615493,-0.34146904091584734},
{0.5377279916286507,-0.7818039878288757,-0.31564399508605434},
{0.5466220387825618,-0.7902010560643719,-0.27710401966039233},
{0.5576650738811468,-0.7962451054889473,-0.2345280310709792},
{0.5787090824935388,-0.7913001127978608,-0.1973320281291893},
{0.5981417943896907,-0.7842217304250029,-0.164992943283933},
{0.5972300193499543,-0.7921740256660427,-0.12560500406953937},
{0.5975307739854466,-0.7976616982864141,-0.08180946905576847},
{0.690103959431812,-0.7178799577989827,-0.09167819461064064},
{0.694197963924532,-0.7183039626718128,-0.046136797602403565},
{0.7082243971918295,-0.7059873959372573,-1.5545708718463402e-09},
{0.7729039881185337,-0.6345229902457955,-1.2433199808870639e-09},
{0.13541697101278172,-0.8522228175740555,-0.5053498918253191},
{0.19790111744138553,-0.7895114685234825,-0.58095334475786},
{0.2282239678737131,-0.8027088870054875,-0.5509739224413348},
{0.270868109325506,-0.7895083186547011,-0.5507332222823068},
{0.31540701094367724,-0.7759340269225834,-0.5463010189550068},
{0.3415160062591347,-0.7895080144697083,-0.5099450093460173},
{0.3630489107587767,-0.8027078026860179,-0.47313388369873777},
{0.33172916246423123,-0.8637484230204618,-0.3793341857787733},
{0.27723697253385726,-0.9192819089258265,-0.27939297232026017},
{0.3793341857787733,-0.8637484230204618,-0.33172916246423123},
{0.384302198981354,-0.874845452971472,-0.2948851526836097},
{0.41860389379643814,-0.8637487808591884,-0.2805509288217134},
{0.4530937478089963,-0.8522175256575617,-0.26159385439742433},
{0.45226705069868695,-0.8637480968253033,-0.22224702491367065},
{0.44752919490012566,-0.8748453809974335,-0.1853730807304577},
{0.47695312665158096,-0.8637482293623265,-0.1626490431903206},
{0.5053610772366134,-0.852217130248189,-0.13541102069547722},
{0.494378087875357,-0.8637481535306261,-0.09761881735167605},
{0.4802581952818083,-0.8748453557281993,-0.06322712570931129},
{0.5027969224055467,-0.8637488667014094,-0.03366229480504505},
{0.6085180890133601,-0.7925051159267811,-0.04051390592632982},
{0.6256877125528739,-0.7800736416264505,-1.2440494284713833e-09},
{0.10039997172330575,-0.919283741092504,-0.380574892814712},
{0.16265101960741893,-0.8637501041242176,-0.4769490574957354},
{0.18537388419391204,-0.8748454534697809,-0.44752872042151143},
{0.2222469334630563,-0.8637487414083493,-0.45226586459930895},
{0.26159385439742433,-0.8522175256575617,-0.4530937478089963},
{0.2805509288217134,-0.8637487808591884,-0.41860389379643814},
{0.2948851526836097,-0.874845452971472,-0.384302198981354},
{0.2506130051854337,-0.9229320190963866,-0.29221500604622075},
{0.1726719960401995,-0.9652999778632586,-0.19590899550731702},
{0.18514293535966972,-0.9653006629773987,-0.184164935701126},
{0.28988708372621425,-0.9229402665668766,-0.2532720731509372},
{0.2944470119907659,-0.9279230377878106,-0.22860400930944125},
{0.31770401679621757,-0.9229320487931114,-0.2173950114931311},
{0.3401029006399724,-0.9192817314346393,-0.19811894212015388},
{0.3455619570742963,-0.9229398853524146,-0.16961397893055283},
{0.34358101842865557,-0.9279230497710099,-0.14460600775623264},
{0.36314406192333076,-0.9229321573784048,-0.12776002178564078},
{0.37979092881693227,-0.9192818277017811,-0.10334298063073699},
{0.37768604949742,-0.9229401209553671,-0.07439610974993781},
{0.3693009631272191,-0.9279229073517228,-0.050753094932567376},
{0.38383705481524405,-0.9229321318026735,-0.02941760420108776},
{0.3849390059501947,-0.9229420142663762,-3.5003000541058883e-10},
{0.523188131206967,-0.8522172137220424,-6.222261560440727e-10},
{-0.362414151598415,-0.9245763867517703,-0.11753504916509766},
{-0.2482509158607236,-0.9650396729206839,-0.08408277150196394},
{-0.12856700508155375,-0.9907310391582043,-0.04384670173302141},
{-0.1251670519121093,-0.9907734109159464,-0.05197362155567525},
{-0.12123497320030836,-0.990816780974223,-0.05986808676581335},
{-0.1167959843492568,-0.9908568672244901,-0.0675378909498756},
{-0.11192304109255824,-0.9908903638055184,-0.07489672749834267},
{-0.10663798866605448,-0.9909198946807584,-0.08189079129629338},
{-0.10092495752254074,-0.9909475829283796,-0.08852706274058673},
{-0.09476727416382663,-0.9909747298329499,-0.09480637415316691},
{-0.17251897620178525,-0.9651768668582038,-0.196648972873161},
{-0.2338489399763633,-0.9231117630584723,-0.30525292164860585},
{-0.3577940238241523,-0.929185061870923,-0.09272840617443424},
{-0.3739271001394408,-0.9244812475804378,-0.07424921988429123},
{-0.25753788218185414,-0.9649045585765283,-0.05131697652356627},
{-0.25346899183909827,-0.9649609689313017,-0.06785129781540232},
{-0.1313980395050729,-0.990694297854143,-0.035487510669388225},
{-0.00215864002348959,-0.999997010881629,-0.0011482600124949765},
{-0.001926160858265372,-0.9999974455822971,-0.001182680526982852},
{-0.0016649598423597433,-0.9999979053190818,-0.0011904898872830882},
{-0.0013911104831315405,-0.9999983472986135,-0.001170560406534678},
{-0.0011173497090612892,-0.99999873961747,-0.0011279597062986276},
{-0.0008633800665821097,-0.9999990771178892,-0.001048970080894433},
{-0.0006241692228251424,-0.999999356994531,-0.0009467963380013321},
{-0.0004016498316492648,-0.9999995808521469,-0.0008227836551318528},
{-0.00019488795162475494,-0.9999997517792524,-0.0006770968319304764},
{-0.08820888128718422,-0.9910017897668165,-0.10067097864344893},
{-0.1593680094490889,-0.9651370572239429,-0.20763501231088785},
{-0.21385094740913993,-0.9228287730552076,-0.3203979212067917},
{-0.18901399427391563,-0.9276769718964903,-0.3220079902449291},
{-0.14546303703125738,-0.9651162456944996,-0.2176950554197258},
{-0.13080292779301053,-0.9651194672262128,-0.22679287480379068},
{-0.06637898397282943,-0.9910827607035919,-0.11553697210365922},
{0.0005363219217176673,-0.9999998540385577,-6.543439044910059e-05},
{0.06735331970752059,-0.9910252899731058,0.11546603378525731},
{0.1316919629542659,-0.964991728542075,0.2268219361936374},
{0.19362692515797994,-0.9224416434514677,0.33408087086874816},
{0.24417708578980285,-0.8697653055855705,0.42881915066241894},
{-0.08128852123117244,-0.9910292588399048,-0.1060810277065514},
{-0.07401192982971463,-0.991056399434654,-0.11103804475269319},
{0.00018189498578304397,-0.9999999218397645,-0.00035104797256200565},
{0.0003622679690092381,-0.9999999144534932,-0.00019963698292175204},
{0.07467659906353454,-0.9910379875721061,0.11075699861107623},
{0.14621998515779494,-0.965003902046319,0.21768597790356828},
{0.21507910528490415,-0.9224504515552883,0.32066515697108405},
{0.2761140574161295,-0.8630261794607029,0.4230210879644947},
{0.31089120419449806,-0.858144563632538,0.4085762683544112},
{0.3334458151043468,-0.863071521426974,0.37936978963950996},
{0.34677711058966565,-0.8698162773905439,0.35094911192014633},
{0.3761240803954024,-0.8630791844806062,0.33708307205050314},
{0.40597998802359053,-0.8581899746833961,0.3141499907325754},
{0.42021927151615546,-0.8631065576787886,0.2801121809888019},
{-4.805549369645858e-06,-0.9999998688278883,-0.000512172932817186},
{0.08828216487389799,-0.9910696056687993,0.0999364602368349},
{0.08165261229587349,-0.9910531492403463,0.10557701589859275},
{0.16006606076573013,-0.9650193663494065,0.2076450788281086},
{0.23552200845735993,-0.9224630331247256,0.3059270109855332},
{0.06825629334724063,-0.9653009059146882,-0.2520619754321897},
{0.03502641061738303,-0.9911623004461376,-0.12794703878395458},
{0.08462739646969376,-0.9652999597316635,-0.24705098969405076},
{0.12441503484156448,-0.922940258462995,-0.36428310201494707},
{0.14069701549510386,-0.9279231021931049,-0.3452000380172275},
{0.16644296406854647,-0.9229318007588888,-0.3471219250638476},
{0.19547799500192095,-0.919281976495339,-0.34162699126511037},
{0.21445806581032786,-0.9229402832208824,-0.31967009809653874},
{0.22524700366398043,-0.9279230150940599,-0.2970230048315247},
{0.15951908012597552,-0.9652994848671571,-0.20676210385601057},
{0.08131990151006953,-0.9911620184053784,-0.10480900194625027},
{0.08798711393197003,-0.9911621569416345,-0.09927661571956135},
{0.09430723127127162,-0.9911623286588525,-0.09329193093460887},
{0.1968149822329219,-0.9652999128594849,-0.17163898450563467},
{0.20759709803038298,-0.9652994558285074,-0.1584310748134684},
{0.21749398697211053,-0.9652999421785352,-0.14454199134193496},
{0.22649991716423895,-0.9653006469693466,-0.129970952466902},
{0.23453198812975,-0.9652999511437573,-0.11485099418710418},
{0.241528144732329,-0.965299578442137,-0.09930195950529654},
{0.24749299208088765,-0.9652999691129885,-0.08332579733379784},
{0.25242091903927966,-0.9653006903923828,-0.0669197785363531},
{0.2562659976296407,-0.9652999910713563,-0.050236099535335914},
{0.2590001121989454,-0.9652994181680687,-0.033406214471584594},
{0.2606260043664812,-0.9653000161724629,-0.01643060027527532},
{0.24006307237686667,-0.9707572926746311,-3.8879911721945233e-10},
{0.13241502842961958,-0.9911622128033726,-0.007982991713955131},
{0.11081401795868744,-0.9938411610634025,-1.1664201890318208e-10},
{-0.0005495977510920989,-0.9999995471091577,0.0007769966481051742},
{-0.02320119573048805,-0.9997308160283325,3.8884392844447247e-11},
{-0.13351505352101206,-0.9910013972540649,0.009484783802082349},
{-0.15562195079444785,-0.9878166876657483,1.9440393853210883e-10},
{-0.2617270760367832,-0.9649762803442935,0.017880605194662016},
{-0.2832861290338866,-0.959035436830671,3.888041770962606e-10},
{-0.3852680836295567,-0.9224392002324737,0.02596970563720449},
{-0.4062851515970038,-0.913746340945779,3.11066116067966e-10},
{-0.5044059756732571,-0.863024958377602,0.0276139986682183},
{-0.5051358938972269,-0.8630398187202313,0.0},
{-0.5975658695047749,-0.8018198249002094,3.110919320643735e-10},
{-0.613642871999768,-0.7885828355089083,0.03974339170989578},
{-0.6966419659603327,-0.7174189649451166,0.0},
{-0.7104437832847127,-0.7022377857878878,0.04617058591602598},
{-0.7833755625722169,-0.621548652934477,0.0},
{-0.7949769309076995,-0.6044249474687774,0.051789595498910525},
{-0.857774003514729,-0.5140270021062257,0.0},
{-0.8671150606127149,-0.49488203459303737,0.056597203956234125},
{-0.917810329282412,-0.3970191424383848,9.334753349025393e-10},
{-0.9241788787870352,-0.37714795053422845,0.0604385920730271},
{-0.961159065692341,-0.2759950188634322,1.5557901063335901e-09},
{-0.964753660786281,-0.25545491018037697,0.06319147778146167},
{-0.9885233646895668,-0.15106805573256615,2.4894109184023585e-09},
{-0.9894113055571654,-0.12982104009227385,0.06489812004230747},
{-1.0,-1.40078e-08,1.8677e-09},
{-0.9970760301372167,-1.6185700489222434e-08,0.07641590230971615},
{-0.9894113055571654,0.12982104009227385,0.06489812004230747},
{-0.9885235140234642,0.15106707855354168,2.4894112944718047e-09},
{-0.9647539377188644,0.25545398350878545,0.0631909959206106},
{-0.9241785469914048,0.37714881513133425,0.06043827037471163},
{0.0005636387427820453,-0.9999995436476987,0.0007713726479821563},
{0.04333340460546235,-0.9911621053404367,-0.12537901332524715},
{0.10056896682381186,-0.9652996815621672,-0.2410029204967647},
{0.11608399867478508,-0.9652999889801355,-0.23392399732952365},
{0.13116896195930136,-0.9653007200502829,-0.225807934512773},
{0.14568499256096026,-0.9652999507093726,-0.21672998893322523},
{0.07430740996389018,-0.9911621329050583,-0.10989101473530034},
{0.0002817528724350899,-0.9999995472456014,0.0009089135884851885},
{0.0002205039004139122,-0.9999995483706065,0.000924465582483981},
{0.00016081292716795244,-0.9999995471009959,0.0009380495751580892},
{0.000102413953259325,-0.9999995436104927,0.0009498895664801709},
{0.10021701565173188,-0.9911621547981068,-0.08691451357416856},
{0.1056759968535839,-0.9911619704889655,-0.08019059761239075},
{0.11068401283993066,-0.9911621149800455,-0.07312120848244676},
{0.11523904426181807,-0.9911623806925791,-0.06570462523629199},
{0.11929801023194682,-0.9911620850099488,-0.05801470497580283},
{0.1228299962747327,-0.991161969939401,-0.05010729848031356},
{0.12583702519787524,-0.9911621984724398,-0.041982608406687355},
{0.12831804862894647,-0.9911623756227796,-0.03363961274847105},
{0.1302480160966858,-0.9911621224926546,-0.025161503109581408},
{0.13161300257570005,-0.9911620193972936,-0.016609300325048246},
{-0.0004978017751704286,-0.9999995483554277,0.000809618634339973},
{-0.13261204577123784,-0.9910013420455349,0.018176506273647218},
{-0.26000396103950013,-0.9649758554024271,0.03492189476710097},
{-0.3827549883438458,-0.9224379719087155,0.05105689844514873},
{-0.5093129204201171,-0.8581268659181167,0.0649509898514411},
{-0.626588904204276,-0.7749718815188206,0.08249198738825472},
{-0.7206928887526147,-0.6867308939950462,0.09488118535397816},
{-0.8026470508834102,-0.5870190372137796,0.10567100669896086},
{-0.8721921657958966,-0.47549509038734583,0.11482702182758547},
{-0.9260736264719823,-0.35710385596361716,0.12191995082408544},
{0.05142240013650694,-0.9911620026311585,-0.12228500032462022},
{0.05929430648841356,-0.9911621084601547,-0.1186670129854062},
{0.00045223879574282216,-0.9999995483424077,0.0008359396224413523},
{0.00039811181969213674,-0.9999995470926191,0.0008644776084715331},
{0.0669480266322985,-0.9911623942899302,-0.11452104555711085},
{0.000344794842641774,-0.9999995436180165,0.0008909995933636527},
{-0.05854342199521973,-0.9910013723269361,0.12037004522396375},
{-0.06630227233159379,-0.9910015864480435,0.11627495147764208},
{0.000507382770274859,-0.9999995472352423,0.0008050416355053539},
{-0.042367019665694734,-0.9910014599977139,0.12696905893581312},
{-0.050564814730644086,-0.9910012887004996,0.12393403610471404},
{-0.09975858698095859,-0.9649758740653687,0.24263096833533113},
{-0.11537805388940947,-0.9649764507097262,0.23560211004223205},
{-0.1305670249313188,-0.9649771842590336,0.22753304344664244},
{-0.07378552738567881,-0.9910013678125795,0.111678041449578},
{-0.08091832303535042,-0.9910012821123936,0.10662403035309939},
{-0.08770263624295703,-0.991001409529554,0.10111604178602279},
{-0.0941371644324631,-0.9910016255730977,0.09515236404889356},
{3.685498331253158e-05,-0.9999995472129043,0.0009509025694433923},
{-2.6351088097572073e-05,-0.9999995483138113,0.0009500935708556622},
{-8.743386040142604e-05,-0.9999995471027376,0.0009477075707856413},
{-0.00014687793297048964,-0.999999543638187,0.0009440075691907976},
{-0.00021049690468969088,-0.9999995472129811,0.0009280435797937239},
{-0.0002712848774772123,-0.9999995483613627,0.0009108685886163662},
{-0.00032977085064510113,-0.9999995470951089,0.0008927825956542125},
{-0.00038620282375668644,-0.9999995436511018,0.0008738106012373129},
{-0.0004435187991756998,-0.9999995472024868,0.0008419536187653226},
{-0.13114205810358756,-0.9910014390714903,0.02679381187122283},
{-0.25716812190728405,-0.9649764574348415,0.0518169245631554},
{-0.3786040370505923,-0.922439090270867,0.07592830743042464},
{-0.495324119243102,-0.8630372077654405,0.0990999238570703},
{-0.6030192503317348,-0.788583327365059,0.12043304999544263},
{-0.6981858118106725,-0.7022378107184949,0.13927896245868385},
{-0.7812928137261427,-0.604424855894554,0.15573096287101756},
{-0.8522172351855706,-0.4948821365721472,0.1697570468476889},
{-0.9083308885836859,-0.37714795373884624,0.18081597782102313},
{0.12792903032409367,-0.9912142349558443,0.03359320796288053},
{0.1255320051314968,-0.9912020405183529,0.04195510171504048},
{0.12261904457565481,-0.9911873603259655,0.05012171822072923},
{0.119186994556391,-0.9911709547304037,0.05809129734680524},
{0.11522695679598961,-0.9911536283698464,0.0658576753068573},
{0.11075998978698795,-0.9911359086088488,0.07336099323549317},
{0.10582698964358028,-0.9911189030073199,0.08052309211986525},
{0.10042995870076853,-0.991102592434609,0.08734686408085392},
{0.09456454082887865,-0.9910864279082534,0.09383624051443007},
{0.24797806721433524,-0.9651612616064934,0.08349022262998448},
{0.2420349093500664,-0.9651496385201173,0.09952526272455704},
{0.23506294317471568,-0.9651357666832824,0.11514497216428207},
{0.22705492426118803,-0.9651196780646001,0.13034595652044134},
{0.21806600645900617,-0.9651020285858399,0.1450010042948573},
{0.2081819395033781,-0.9650847195512468,0.1589709538038424},
{0.19740200779649117,-0.965069038115885,0.17226200680357423},
{0.18571804328939517,-0.9650542249464455,0.18487604309313166},
{0.356764934313695,-0.922547830143738,0.1470519729253079},
{0.34641289268234177,-0.9225437141987695,0.17003294732431118},
{0.33453300217413,-0.9225370059955681,0.19238800125032962},
{0.32121905803995254,-0.9225251666878587,0.21392903865409274},
{0.30659201344191395,-0.9225130404457402,0.23445901027938662},
{0.29065210778704625,-0.9225033421062766,0.25398609418961754},
{0.27339391601982665,-0.9224937166316522,0.2725089162916777},
{0.17323298952616054,-0.9650369416529032,0.19670798810683868},
{0.25496207938194587,-0.9224782872118145,0.289876090252355},
{0.4257528790227623,-0.8698447528345183,0.2492079291878262},
{0.37290518867023276,-0.922549466761064,0.09921795019901661},
{0.25288613231296725,-0.9651705049884398,0.0670410350766497},
{0.2567168903600081,-0.9651755877877634,0.05032417850728671},
{0.37861702098547556,-0.9225440511335323,0.0745763041335152},
{0.3655980800818918,-0.9225502020786474,0.12344702704027183},
{-0.033948987161615804,-0.9910016252359594,0.1294729510376118},
{-0.06722861473933892,-0.9649772115635763,0.253573055593875},
{-0.0992962843566814,-0.9224408546769773,0.37315294121280185},
{-0.08370932831001872,-0.9649763263495049,0.24862308408291292},
{-0.1305540041907836,-0.8697720279196826,0.47587001527542777},
{-0.12354600698887427,-0.9224390521814563,0.3658450206954875},
{-0.14716104666668836,-0.9224382925172206,0.3570031132103462},
{-0.17014303752173326,-0.9224392034260012,0.34663707644405617},
{-0.19249199064594819,-0.922440955174444,0.3347379837335754},
{-0.14520505047350216,-0.96497633542728,0.21848607594610098},
{-0.15915698160455757,-0.9649758884676108,0.20854397589638443},
{-0.17242507792365203,-0.9649764360994869,0.19771208935155046},
{-0.18500802453558085,-0.9649771279743102,0.1859870246654149},
{-0.10017603761049731,-0.9910013720655692,0.08877523333013318},
{-0.10575703436441661,-0.9910013220134006,0.08204772666037562},
{-0.11088504401956599,-0.9910013934114977,0.07497162976252238},
{-0.11555695422025193,-0.9910016073987564,0.06754557324073356},
{-0.11973904924138656,-0.9910014075385909,0.05982282460148841},
{-0.12338904065854396,-0.9910013265498361,0.051879817095179706},
{-0.1265110461827134,-0.991001361763919,0.04371791595917545},
{-0.12910095797979843,-0.9910016774455365,0.03533578849879212},
{-0.253215051622197,-0.9649771967270214,0.0685649139781244},
{-0.3728079733006124,-0.9224409339375501,0.10058299279654809},
{-0.4773928985977013,-0.869771815253093,0.12487197347613423},
{-0.5772040591816011,-0.80182008221182,0.15466101585762676},
{-0.6729042196383282,-0.7174192341681873,0.18030405885188547},
{-0.7566830537994103,-0.6215480441914459,0.20275301441553706},
{-0.8285460899349545,-0.5140270557953268,0.2220080240979733},
{-0.886536771300582,-0.39701889758124675,0.2375469387201429},
{-0.22828890609999813,-0.8630246450199129,0.4506358146440641},
{-0.24927001706141153,-0.8697720595319856,0.42586502914854585},
{-0.2140240139430229,-0.9224390600941395,0.3214030209384433},
{-0.23454601571915723,-0.9224380618213398,0.3067510205583007},
{-0.25406206972912304,-0.9224392531699448,0.29078907980910945},
{-0.27256991584064433,-0.9224407151849426,0.2735119155497902},
{-0.19680606820384358,-0.9649763344159841,0.1734590601128548},
{-0.2077089824193048,-0.9649759183234768,0.1602449864367047},
{-0.21772207762185353,-0.9649763440314976,0.1463480521757242},
{-0.22684103078618625,-0.9649771309638101,0.13176601788288986},
{-0.23499411914992094,-0.9649764892755308,0.11661105912572846},
{-0.24210596991978775,-0.9649758801075442,0.101025987448128},
{-0.24818107737540054,-0.9649763008506069,0.08501112650391414},
{-0.36541903758663874,-0.9224390948811678,0.12480001283680518},
{-0.4800719165783903,-0.8630248500330479,0.15722297267952362},
{-0.582447048279329,-0.7885830653660473,0.1972110163469204},
{-0.6742860909716513,-0.7022380947428101,0.22847303082455528},
{-0.7544847720513228,-0.6044248173881798,0.25577992272250255},
{-0.822920189539526,-0.49488211398398346,0.27909506428271763},
{-0.1618390472198666,-0.8630372518088472,0.47851313961603836},
{-0.19840693286962086,-0.8581267096554513,0.4735538397745061},
{-0.19721197745453078,-0.7885829098484183,0.5824469334140879},
{-0.2418539812993672,-0.7749719400776219,0.5838879548526172},
{-0.2724029404115909,-0.7885828274967369,0.5513018794021758},
{-0.3371429610433017,-0.8630249002779101,0.3761949565308634},
{-0.3509988382060698,-0.8697715990762644,0.346838840123633},
{-0.2899160610068982,-0.9224391941084388,0.25505805367174433},
{-0.30594700558521565,-0.9224380168395674,0.2355940043008864},
{-0.32066703218936,-0.922439092596747,0.21512502159478858},
{-0.334071954402355,-0.9224408740955924,0.19364597356916605},
{-0.34605199879124043,-0.9224389967779207,0.17133099940154084},
{-0.35649806969377523,-0.922438180332531,0.14838102900782632},
{-0.47514909041113995,-0.858126163283833,0.19455803702040955},
{-0.5838879548526172,-0.7749719400776219,0.2418539812993672},
{-0.6715779015342626,-0.6867318993124063,0.27817695921411445},
{-0.7479480923098895,-0.5870190724484309,0.3098100382359828},
{-0.812753806866555,-0.47549488700887665,0.33665392000144345},
{-0.779242845422781,-0.4948819018310292,0.384541923719003},
{-0.7428540442689023,-0.5140270306324137,0.42888702555866526},
{-0.662575891562176,-0.6044249010792244,0.4423389276063747},
{-0.6422777931178603,-0.5870188109171623,0.4928368412538292},
{-0.5987540460112564,-0.6044250464470444,0.5255130403830511},
{-0.5539303306677017,-0.6215483710321676,0.5539303306677017},
{-0.4697119855241814,-0.7022379783580792,0.5350069835118876},
{-0.44251589826096027,-0.6867308421133869,0.5766978674111203},
{-0.39520584690439825,-0.7022377279657972,0.5921777706010353},
{-0.34832112363956547,-0.7174192546541076,0.6033092141497716},
{-0.1546609265866514,-0.801819619397966,0.577204726016566},
{-0.28017306775440126,-0.8630372087087449,0.4203211016464744},
{-0.3142118860308135,-0.8581266887450635,0.40606585271405393},
{-0.4058079559801872,-0.7885829144588672,0.46201394988327044},
{-0.42254289730138384,-0.8018198051185218,0.42254289730138384},
{-0.3794131265033766,-0.8630372877526459,0.33348511119012403},
{-0.40860316664454516,-0.8581263499778928,0.31090612679982516},
{-0.4230218068836094,-0.8630246060151174,0.27611787394766335},
{-0.4288069558633311,-0.8697719104752517,0.24417497486731532},
{-0.452797113990103,-0.8630372172666262,0.2239230563718528},
{-0.5513011833355146,-0.7885832622438017,0.27240309058779905},
{-0.6383469688177088,-0.7022379656967296,0.3152379846010977},
{-0.7143648239469539,-0.604424851041327,0.35263791309345494},
{-0.2987829867731762,-0.8018199645042327,0.5175069770904841},
{-0.34124008994185673,-0.7885832078496636,0.5115581348331858},
{-0.38473403840492315,-0.7749720773592665,0.5013960500503589},
{-0.4926001129135645,-0.717419164446481,0.4926001129135645},
{-0.46201394988327044,-0.7885829144588672,0.4058079559801872},
{-0.5013960500503589,-0.7749720773592665,0.38473403840492315},
{-0.5115581348331858,-0.7885832078496636,0.34124008994185673},
{-0.5175069770904841,-0.8018199645042327,0.2987829867731762},
{-0.6033092141497717,-0.7174192546541077,0.3483211236395655},
{-0.6784232806715712,-0.621548257141715,0.3916881620459306},
{-0.5350067322126123,-0.7022376485083756,0.4697127648942589},
{-0.5766981226089174,-0.6867311460024907,0.44251509408093154},
{-0.5921768872430174,-0.7022378662861984,0.3952069247482614},
{0.6029730735572927,0.5539920675820504,-0.5740350700271164},
{0.43555904566706166,0.5703360597980279,-0.6964230730178738},
{0.2818119768805691,0.6363819477921817,-0.7180529410920162},
{0.14188499809519392,0.6357389914652041,-0.7587519898137545},
{0.46155405562095947,0.39367204744063394,-0.7949780958012261},
{0.3217249097558537,0.4038308867250483,-0.8563957597801667},
{0.1908090502391709,0.40477210657468826,-0.8942882354620991},
{0.05691077739328971,0.3932988437696088,-0.9176476354821497},
{0.228104058067431,0.1447130368389513,-0.9628222451013574},
{0.0983033517768327,0.12728693755879966,-0.9869825158311278},
{-0.09244176007869988,0.3653378422275643,-0.926273599985479},
{0.3548339123723568,0.16092396025918923,-0.9209757725613772},
{0.37318704670618114,-0.07537550943361306,-0.924689115729358},
{0.2523310514963571,-0.10426502127866838,-0.9620071963288537},
{0.1301310264982583,-0.12707202587536157,-0.9833202002310545},
{-0.04955137875319193,0.1063849543838988,-0.9930895741796877},
{-0.2599409089503838,0.3089818917727772,-0.9148556795530998},
{-0.29645815725375135,0.5191072753561148,-0.801648425227706},
{-0.4512251332303318,0.2151280635194744,-0.8660922557254684},
{-0.6548476652004549,0.07145256346893024,-0.7523756153379982},
{-0.8331641178158258,0.012206901726149957,-0.5528910781830585},
{-0.9328546868029349,-0.05233018243064029,-0.3564318803313953},
{-0.9481161937576662,-0.03440370703076483,-0.31605706458963534},
{-0.9593713290952133,-0.07728912651265553,-0.271354093083179},
{-0.9572018046169447,-0.17263496476192722,-0.23229695258378316},
{-0.9391429611730132,-0.12470099484448686,-0.32009398676635453},
{0.4918861282669489,0.17462804553697553,-0.8529672224244532},
{0.5068518827127926,-0.04630128928572803,-0.8607888008106154},
{0.6514038732042484,0.18332796431521522,-0.7362498566889794},
{0.6410112300993555,0.37461213447191977,-0.6699032404705201},
{0.7596888694660914,0.421880927510105,-0.49486291496993956},
{0.813002457468075,0.3005561691198481,-0.49869128060842627},
{0.8055510177599835,0.17978400396369798,-0.5645930124475823},
{0.8194327468145718,-0.002276229296698733,-0.5731708229037089},
{0.6655740751353837,-0.021637202442582378,-0.7460180842165539},
{-0.22158591552682952,0.067402174304886,-0.9728086291450702},
{-0.4171690761938936,-0.004617430843351184,-0.9088171659910151},
{-0.6188588370609878,-0.11608696943552388,-0.7768767954565239},
{-0.8086401547042419,-0.08319671591670261,-0.5823911114196159},
{-0.9169062169982601,-0.10836602564628595,-0.3841090909046126},
{-0.9748192397616956,-0.11492702826688071,-0.19110004700201783},
{-0.9803876982848696,-0.09557237058752338,-0.17235394695792933},
{-0.9802972117138313,-0.1294270279522288,-0.14921803222647267},
{-0.9694934254443476,-0.20969809202214845,-0.1269220556974083},
{-0.9320660553665894,-0.3450620204973747,-0.11038600655714975},
{-0.9286236752622148,-0.3040558936722807,-0.21262192564655086},
{-0.8752812828029906,-0.4543261467925746,-0.1657420535511833},
{-0.3649490580599328,-0.22833703632625618,-0.9025931435940059},
{-0.5612369393788371,-0.3142969660516865,-0.7656569172987211},
{-0.7749237741496612,-0.22663593394730663,-0.5900248280381739},
{-0.8987758392665384,-0.185585966810551,-0.3971899289681482},
{-0.9649876263911205,-0.16778893503809345,-0.20160792194458485},
{-0.9897916418202042,-0.14252194842502178,0.0},
{-0.9934603043545586,-0.1141780349793598,-1.2471903820868095e-09},
{-0.9902890118354393,-0.13902400166154538,0.0},
{-0.9781379702191229,-0.20795699366843753,0.0},
{-0.9465026983378069,-0.3226958971528003,-2.495069204790383e-09},
{-0.8804559435099485,-0.4741279695799504,-2.802319820203166e-09},
{-0.8730871518781462,-0.47900008332460803,-0.09098211582682217},
{-0.17621802056526095,-0.17225002010218138,-0.9691631131047339},
{-0.010426595931811233,-0.1440559437930868,-0.9895146139169234},
{0.6661889932251911,-0.1563629984098665,-0.7292069925843296},
{0.5100358718127005,-0.18555795336372544,-0.8398997889080125},
{0.6740748471518605,-0.16000196371915884,-0.7211258364829323},
{0.5177361629932067,-0.18667905877012386,-0.8349252628503777},
{0.3799171532234682,-0.21812008796948515,-0.8989363625478503},
{0.8194044028414273,-0.12944306363772068,-0.5584092745291439},
{0.827196849779825,-0.1320129760262477,-0.5461849008120119},
{0.8408912634494873,-0.0423935132817997,-0.5395411690371282},
{0.6869832769870108,-0.06707132704270542,-0.7235712917390508},
{0.5276640362822437,-0.08770740603077197,-0.8449130580963252},
{0.3859278715460519,-0.21461192856761183,-0.8972187013657396},
{0.2623741004244933,-0.24907309533349273,-0.932267356828196},
{0.26248594936909014,-0.24082795354670053,-0.9343998197636362},
{0.14260301762901395,-0.2719870336238551,-0.9516761176490639},
{0.13048403385369553,-0.2604650675768892,-0.956625248193583},
{0.25254496853681335,-0.12395998455650827,-0.9596118804472411},
{0.07494913103659862,-0.12001904970015022,-0.9899384099356544},
{-0.033597391648634234,-0.2646439342169679,-0.9637607604362056},
{0.005326541305126964,-0.2858410700377349,-0.9582622347966174},
{0.3895339756788627,-0.10691099332485199,-0.9147859428839693},
{0.3795919624815327,0.05852669421528357,-0.9233009087419168},
{0.20721209301097634,0.07207453235198548,-0.9756374379328896},
{-0.0016581691932795357,0.08342695941172004,-0.9965125151839498},
{-0.16378596398416165,0.07379658377244444,-0.9837317836815559},
{-0.10324996654412524,-0.11296596339587073,-0.9882196797892053},
{-0.2196459243372636,-0.17764393880593707,-0.9592696695546782},
{-0.17997098300480097,-0.3058199711205041,-0.9349249117122401},
{-0.15148596287677876,-0.3085449243878359,-0.9390697698711209},
{0.5256558038040963,0.06565917549335291,-0.8481596834326676},
{0.5058411710509797,0.2122600717760738,-0.8361042827299652},
{0.3523451357617781,0.21512608289003188,-0.9108093509431079},
{0.1676390374456198,0.24718305521340883,-0.9543572131752717},
{-0.0436663165234314,0.23467608880195454,-0.9710923674635141},
{-0.25298105744011457,0.2526220573586025,-0.9339072120464583},
{-0.3808461689081697,0.2741381215823399,-0.883065391646211},
{-0.30195515124940936,0.08023764019105367,-0.9499394758249167},
{-0.36849899039849365,-0.030246199211913516,-0.9291359757906935},
{-0.3465379354427609,-0.2960179448542301,-0.8901038341807919},
{-0.3092989357168624,-0.3787869212748284,-0.8722698187118211},
{-0.32233411809727935,-0.36414513341606464,-0.8737843201384686},
{-0.4937061930596481,-0.45890017944904965,-0.7386912888590061},
{-0.4302089284676616,-0.524078912859572,-0.735024877784851},
{-0.3910301269518616,-0.48546615761146833,-0.7819322538621667},
{-0.45967592845121746,-0.6957658917036995,-0.5519129140944856},
{-0.6186183337855099,-0.5747603101212052,-0.5356882890392654},
{-0.7184089144109223,-0.39252695323551917,-0.5742919315805862},
{-0.28666604490437614,-0.32441405081735636,-0.9014311412033401},
{-0.31305217198386687,0.22843512549715264,-0.9218545064462632},
{-0.1730759950239787,0.13598999609021967,-0.9754749719546073},
{-0.15439894906240553,-0.3753358761733369,-0.9139386984834477},
{-0.17078291404036985,-0.7501336224375892,-0.6388526784482789},
{-0.3506250071790471,-0.7045550144257641,-0.6169800126326658},
{-0.2816650713532357,-0.8734392212653289,-0.3972011006215774},
{-0.4735010000364596,-0.8077810000621992,-0.3511220000270364},
{-0.7075617626070543,-0.6272017895685037,-0.32553689077962444},
{-0.8202369005979567,-0.4302769478560307,-0.37692595432147713},
{0.6697238498097555,0.21919695084355492,-0.7095228408845542},
{0.6880399991770182,0.07724349990760712,-0.7215499991369361},
{0.8424882994117635,0.09440573355083647,-0.5303781884910079},
{0.8235201196307177,0.23438403404838515,-0.5166030750456427},
{0.7816669973556206,0.3712739987439801,-0.5011509983046063},
{0.633985140348476,0.35037507756429137,-0.6894201526204032},
{0.4755897705220462,0.33960483613646103,-0.811469608455865},
{0.3159831757784878,0.3444971916405683,-0.8840114917673315},
{0.1158019708337719,0.37813090476282796,-0.9184807686687073},
{-0.11412500871994988,0.3630450277391825,-0.9247560706578398},
{-0.33251812669874087,0.3687961405216826,-0.8679983307317309},
{-0.44447609562993123,0.38900808369587625,-0.8069161736096473},
{-0.44994989439654726,0.4146149026896865,-0.7909738143580721},
{-0.4102078487838779,0.28078889649196576,-0.8676906801406403},
{-0.3258929750799428,0.4333539668627235,-0.8402369357496046},
{-0.17125098950830842,0.4138769746438279,-0.8940799452241938},
{-0.12631707590970115,0.36762222092098573,-0.9213565536852412},
{-0.1402810656757659,0.041455919408529905,-0.9892434631367877},
{-0.16143996817429287,-0.41969691726242686,-0.8931918239193074},
{-0.10339198543941111,-0.7499948943789765,-0.6533129079946031},
{-0.12820897735483494,-0.8921018424307418,-0.4332629234740764},
{0.27664602090600227,0.4806210363202928,-0.8321480628850154},
{0.06404248889646634,0.514854910735686,-0.8548818517826277},
{-0.17907399871236843,0.48130399653918365,-0.8580669938300693},
{-0.40062802325225083,0.45948902666851416,-0.7926960460076835},
{-0.49940595098480656,0.46301695455627717,-0.7322629281305939},
{-0.48778216441188404,0.4945161666816473,-0.719390242477716},
{-0.3506191266276983,0.5424491959080034,-0.7634232757138012},
{-0.22813304923180175,0.6121671321075179,-0.7571041633853675},
{-0.4476019860578697,0.5497029828775769,-0.7053219780302786},
{-0.5368209256068244,0.5207109278393639,-0.6638399080044081},
{-0.5164281047419588,0.539774109476996,-0.6647901348327488},
{-0.3799829276381481,0.6017858853992168,-0.7024718662251342},
{-0.22970904730835348,0.6564051351859952,-0.7185861479921138},
{-0.19006704235958125,0.5629531254634068,-0.804337179259832},
{-0.1486580154939568,0.557011058054759,-0.8170920851618355},
{-0.23030593256666315,0.5367988428258587,-0.8116687623442329},
{-0.22739693085337917,0.29860690919992344,-0.9268897181523442},
{-0.25834200037058647,-0.06869520009854188,-0.9636080013822764},
{-0.29514793370919123,-0.46791989490426755,-0.833029812899859},
{-0.16088007605945243,-0.7521033555727396,-0.6391073021514698},
{-0.09914911656009455,-0.90573015127696,-0.41209506882898744},
{-0.11885196945683055,-0.9688207510276312,-0.21739494413276744},
{-0.22469008382278596,-0.9568553569640477,-0.1842340687302824},
{-0.4526740979632122,-0.8749301893436627,-0.17199803722209928},
{-0.7507240895234777,-0.6445570768631138,-0.14477401726423023},
{-0.8833240315938512,-0.43059301540102063,-0.18527900662687433},
{0.02435050555182763,0.677471154460985,-0.7351461676106804},
{0.24309100671830625,0.6439710177974272,-0.7254020200479359},
{0.2275009540510682,0.7995198385189957,-0.555887887725945},
{0.03331619911244914,0.8197769781609613,-0.5717129847694405},
{-0.20127398507140845,0.7687919429783193,-0.6069989549785856},
{-0.453183722355718,0.674248586919707,-0.5831066427580756},
{-0.553200008905967,0.5947910095755405,-0.5832610093899191},
{-0.5351450935021643,0.5925481035317913,-0.602085105198125},
{-0.41676003441896237,0.652101053855072,-0.6333050523027665},
{-0.29403595923250514,0.7266198992556112,-0.6209399139079288},
{-0.28566802080391723,0.7693550560286687,-0.571390041611767},
{-0.20233502535156858,0.6795990851503727,-0.7051280883490294},
{-0.2811949581577715,0.6680369005951146,-0.6889528974827831},
{-0.4190669182423571,0.601611882628842,-0.6800338673291456},
{-0.4823731471891939,0.4293101309977815,-0.7635502329863175},
{-0.4881230843715943,0.14465802500399713,-0.8607031487716914},
{-0.5093299383023216,-0.23043097208674593,-0.8291468995612965},
{-0.4556988919512992,-0.4891628840168036,-0.7436788236696815},
{-0.3096108832231564,-0.7238197269947936,-0.6166247674258304},
{-0.17613995388867978,-0.9003497642992667,-0.3979258958277892},
{-0.12485097291995176,-0.9712687893327937,-0.2026059560549755},
{-0.11542995609299252,-0.9933156221646622,0.0},
{-0.11687704614043719,-0.9931463920719272,0.0},
{-0.22283408776411412,-0.9748563839511619,0.0},
{-0.5035930097873302,-0.8639410167906939,0.0},
{-0.7655026675813044,-0.6434327205900452,0.0},
{-0.8983218679790347,-0.4393379354331444,0.0},
{0.5767521934458902,0.4854661628280484,-0.6570232203692387},
{0.4433680701379523,0.4713580745657895,-0.762395120605962},
{0.5168922953221037,0.5883583361536304,-0.6218173552701619},
{0.41014982686184953,0.6006617464403079,-0.6862817102972176},
{0.4332640611036681,0.7325911033180632,-0.5249690740369187},
{0.43510987789665495,0.8403477641761812,-0.32325690928555767},
{0.23303199304527678,0.9022679730722638,-0.36277898917304263},
{0.01480670325127188,0.9145472008172613,-0.4042080887564483},
{-0.2451390500973568,0.8681931774265804,-0.4314480881720346},
{-0.4533949416152036,0.7881078985133821,-0.4163159463899582},
{-0.5574608217209918,0.6905527791574585,-0.46084085262058433},
{-0.5535342034000551,0.6730692473240519,-0.49048718023298093},
{-0.46433806953904233,0.7219891081247359,-0.5129540768197518},
{-0.376420998192991,0.7929419961934819,-0.4791139977000132},
{-0.3618341617730143,0.823575368213629,-0.43680619529238074},
{-0.46862207124344735,0.8040501222377393,-0.36591905562976346},
{-0.3456100453376471,0.7535990988582667,-0.5591440733493631},
{-0.5547459495408654,0.6359009421590889,-0.5365509511958643},
{-0.7362378407760681,0.348926924538629,-0.5798308746017298},
{-0.7600410506761035,0.019579801305492694,-0.6495800433110627},
{-0.7090117116187621,-0.36710685068409127,-0.6021087551001411},
{-0.531953999734821,-0.6294199996862342,-0.5664409997176292},
{-0.3391719744450885,-0.8604449351697788,-0.3802589713493889},
{-0.2232039904216474,-0.9564369589564218,-0.18817099192501843},
{-0.19420903327956568,-0.9809601680968584,0.0},
{-0.12485097291995176,-0.9712687893327937,0.2026059560549755},
{-0.11885196945683055,-0.9688207510276312,0.21739494413276744},
{-0.22469008382278596,-0.9568553569640477,0.1842340687302824},
{-0.4526740979632122,-0.8749301893436627,0.17199803722209928},
{-0.7507240895234777,-0.6445570768631138,0.14477401726423023},
{-0.8833240315938512,-0.43059301540102063,0.18527900662687433},
{-0.7075617626070543,-0.6272017895685037,0.32553689077962444},
{-0.8202369005979567,-0.4302769478560307,0.37692595432147713},
{-0.6186183337855099,-0.5747603101212052,0.5356882890392654},
{-0.7184089144109223,-0.39252695323551917,0.5742919315805862},
{-0.4937061930596481,-0.45890017944904965,0.7386912888590061},
{-0.5612369393788371,-0.3142969660516865,0.7656569172987211},
{-0.32233411809727935,-0.36414513341606464,0.8737843201384686},
{-0.3649490580599328,-0.22833703632625618,0.9025931435940059},
{-0.15148596287677876,-0.3085449243878359,0.9390697698711209},
{-0.17621802056526095,-0.17225002010218138,0.9691631131047339},
{0.005326541305126964,-0.2858410700377349,0.9582622347966174},
{-0.010426595931811233,-0.1440559437930868,0.9895146139169234},
{0.14260301762901395,-0.2719870336238551,0.9516761176490639},
{0.1301310264982583,-0.12707202587536157,0.9833202002310545},
{0.2623741004244933,-0.24907309533349273,0.932267356828196},
{0.2523310514963571,-0.10426502127866838,0.9620071963288537},
{0.3799171532234682,-0.21812008796948515,0.8989363625478503},
{0.37318704670618114,-0.07537550943361306,0.924689115729358},
{0.5100358718127005,-0.18555795336372544,0.8398997889080125},
{0.5068518827127926,-0.04630128928572803,0.8607888008106154},
{0.6661889932251911,-0.1563629984098665,0.7292069925843296},
{0.6655740751353837,-0.021637202442582378,0.7460180842165539},
{0.8194044028414273,-0.12944306363772068,0.5584092745291439},
{0.8194327468518758,-0.0022762092968085347,0.5731708229298021},
{0.9274790405002281,-0.10239200447115175,0.35958101570182455},
{0.9277165765160268,0.013879408625157422,0.37302723181236924},
{0.9829072278098303,-0.07875961825423068,0.16640403856770478},
{0.9841032995317194,0.026801308157519563,0.17556305343616194},
{0.9981170886688534,-0.06133740544897735,2.4911002212996876e-09},
{0.9982970636743838,0.05833500372078166,0.0},
{-0.11553295481628327,0.6301127535695663,-0.7678606996978015},
{-0.2490079099800462,0.6042307815618506,-0.7569017263691002},
{-0.25528205143065896,0.7217381454057119,-0.6433701296172196},
{-0.2672569973431982,0.8615519914353116,-0.431626995709196},
{-0.45080007759171603,0.8742161504700967,-0.1803480310415058},
{-0.6390228166410559,0.7691877792919825,6.259458203933228e-10},
{-0.6581530416199542,0.7324540463185643,0.17420001101597354},
{-0.605181817879637,0.6798547954079279,0.4141888753560895},
{-0.5304537990903965,0.590331776411587,0.608380769575523},
{-0.4806761322664678,0.506385139340752,0.7159081969946959},
{-0.6044060937657554,0.4559190707299224,0.6533231013545938},
{-0.5860682194380481,0.4339681624881257,0.684248256199017},
{-0.5901050975024832,0.45996607599974104,0.6634811096263293},
{-0.4701438585758121,0.5316408400768772,0.7045017880784967},
{-0.31412798362450867,0.5886739693124269,0.7448399611714939},
{-0.09872362406596147,0.5902901438956479,0.8011311952925925},
{0.13078305966651502,0.5525942521073702,0.8231253755304601},
{0.23478601349726133,0.5893020338775017,0.7730450444404282},
{0.3472029992689641,0.6448989986421652,0.6808489985664725},
{0.3970140354025371,0.7358840656202568,0.5485020489110269},
{0.4475917034356826,0.7724734881762307,0.450495701511558},
{0.35641588150795606,0.844481719248299,0.3997728670937335},
{0.37784715956224424,0.8618663639602093,0.33825714284365377},
{0.2769188895175542,0.9216316322962401,0.27186589153355095},
{0.1840820773283869,0.9652104054613289,0.18569507800596913},
{0.07383943406050103,0.9903944568471014,0.11690405392525957},
{-0.02263569971063676,0.9994599872234132,0.02381929969550622},
{0.30302395551851086,0.6926918983183784,-0.6544879039264188},
{0.08018627733131495,0.6724328099030396,-0.735801791988609},
{0.13582298995663727,0.7831919420872655,-0.6067639551331443},
{-0.0958031966114295,0.7482289735350518,-0.6564869767799772},
{-0.06424230762385064,0.887262105294377,-0.456770054206438},
{-0.03957529106449213,0.9799877787334401,-0.19508395595296518},
{-0.25668396130540916,0.9502058567583784,-0.17669797336313592},
{-0.303118008770265,0.9529530275722669,6.243340180641685e-10},
{-0.4718799103501397,0.8816628324977435,1.87986964285394e-09},
{-0.45080007759171603,0.8742161504700967,0.1803480310415058},
{-0.43090013752567896,0.7752312474220692,0.46188914741610193},
{-0.38599892797762475,0.6519778783494149,0.6526328782272006},
{-0.36040491785471845,0.5504038745492112,0.7531028283490574},
{-0.35819019366095345,0.49922326991262217,0.7889714265693517},
{-0.47001797059003647,0.4657779708553417,0.749755953086272},
{-0.4762650916898499,0.4805630925172947,0.7363631417635411},
{-0.35109488990192617,0.5346968323271201,0.7686557589611216},
{-0.1680270996379153,0.5583643311028877,0.8124014817436603},
{0.05332380514309618,0.5244220505806562,0.8497870819622059},
{0.2832190963984506,0.4456131516720374,0.8492442890547802},
{0.34663498605730125,0.4437609821506024,0.826389966760117},
{0.4107950801563979,0.4749070926662555,0.7782741518607588},
{0.5017678842592226,0.5310518775044017,0.682797842501771},
{0.5237781572012999,0.6342561903590218,0.5686611706720184},
{0.5511059066079477,0.6803388847077414,0.4831369181261754},
{0.569194827917915,0.698050788961478,0.4344448686562577},
{0.4782850159952861,0.7863080262964998,0.3911050130797252},
{0.4879751388411461,0.7895772246544919,0.3720861058678143},
{0.39231002928888714,0.8643160645276791,0.314723023496435},
{0.2914900027247028,0.923286008630416,0.25015300233830523},
{0.19306605654702902,0.965467282775271,0.1749240512334254},
{0.0871718659735754,0.9910416131595631,0.10118096050530427},
{-0.010058297082593917,0.9998997099793859,0.009969987108208199},
{0.9461868623930072,0.001093039841035707,-0.3236189529350568},
{0.9591726113917748,0.12422894966871335,-0.25407689706089304},
{0.9392952000130715,0.1291140274934794,-0.3178900676913593},
{0.9230012011548993,0.0024786305401820453,-0.3847890838592727},
{0.9155685299664642,0.13312593165595984,-0.37948880517846667},
{0.9746016721957065,0.11889296001071631,-0.1897789361684349},
{0.9655040309099628,-0.000756430024216599,-0.2603870083361151},
{0.9380557394006475,-0.12874796423279053,-0.3216759106358711},
{0.9152483286799201,-0.1284920461434937,-0.3818511371286867},
{0.8886680574861612,-0.12838400830490498,-0.4402120284764366},
{0.8960469368213636,0.0034443997571416505,-0.4439459686981788},
{0.8881828804643591,0.13618798167120982,-0.43884394093841167},
{0.8572630843726942,0.13834201361575998,-0.49594504881141005},
{0.822877853981572,0.13968297521346776,-0.5507819022645862},
{0.7849289359863006,0.14017498856823954,-0.6035209507807562},
{0.743382900656546,0.13978698131928843,-0.6540959125885905},
{0.698178802928239,0.1385609608890266,-0.7023868017404662},
{0.6500450212600478,0.1366500044692068,-0.7475080244476241},
{0.5999651919810925,0.13444004301907292,-0.7886492523575487},
{0.5479698545071733,0.13232996486474488,-0.8259647806960553},
{0.4940329282617307,0.13066298102649523,-0.8595688751824424},
{0.4430171526243086,0.14254504910834587,-0.8851083049295998},
{0.38411998790713475,0.13834199564471736,-0.9128599712613429},
{0.32027484685309215,0.12915893823963323,-0.9384785512445338},
{0.25781805594433277,0.12933302806417082,-0.957498207768995},
{0.1940890418128009,0.12949602789746179,-0.9723992094849567},
{0.19534895581760836,-0.0002044169537666845,-0.9807337781858434},
{0.193411079044223,-0.12991505309434434,-0.972478397437415},
{0.18359105399468773,-0.2642920777291044,-0.946807278458902},
{0.17382792463083566,-0.38908083130042437,-0.904654607755417},
{0.16976603951423866,-0.4948791151865916,-0.8522171983595416},
{0.15572502574718858,-0.6044220999336473,-0.7812961291775594},
{0.13927200213079202,-0.70223601074386,-0.6981890106819428},
{0.12042908008018643,-0.7885815243729791,-0.6030224009841},
{0.09910055524890678,-0.8630356102767845,-0.4953267763240107},
{0.0759328934552527,-0.9224379204939674,-0.37860596736749685},
{0.051824414451204746,-0.9649752690827352,-0.25717107171198844},
{0.026799290351044676,-0.9910006431949947,-0.13114695278117175},
{0.0008387806183079342,-0.999999544944311,-0.00045448679318310506},
{-0.025187806119669913,-0.9911622408143733,0.13024203164381362},
{-0.050313593445221946,-0.9652858742440317,0.2563039666091109},
{-0.07938032076438284,-0.9228392413972017,0.3769170985943475},
{-0.09925916214426807,-0.863508670672691,0.49446981141774493},
{-0.12085698171083521,-0.7890718805905504,0.6022949088553207},
{-0.1399399958833852,-0.7027529793271159,0.6975349794806138},
{-0.15645203156380943,-0.6050351220643356,0.780676157499479},
{-0.16071703907947782,-0.495389120457347,0.8536742075768845},
{-0.18032796128494333,-0.37799491884733466,0.9080758050429562},
{-0.1875678947961984,-0.2562498562735959,0.9482374681489251},
{-0.20214892034596263,-0.13024394867914044,0.9706556175263331},
{-0.1935068913820707,0.0009569614628451123,0.9810984492967085},
{-0.19253006710752177,0.13155804585535424,0.9724323389471854},
{-0.18882289427535315,0.25738985588372787,0.9476794693806722},
{-0.18206296768573776,0.3787689327724975,0.9074068389448281},
{-0.16261100060409986,0.495600001841154,0.853193003169612},
{-0.15869996810115092,0.6050008783942307,0.7802488431692179},
{-0.1422789570441397,0.7025037879050059,0.6973127894722355},
{-0.12317397932611153,0.7887608676120208,0.602232898919432},
{-0.10145905951331456,0.8632395063544304,0.49449329005723947},
{-0.08168414820682057,0.922629544500223,0.3769382224543398},
{-0.052159278900493905,0.9651826095636907,0.25632389631168745},
{-0.026915888907347956,0.9911325915316413,0.1301219463737765},
{-0.000897386218853578,0.9999992438787312,-0.0008407972050527106},
{0.02488609912163009,0.9909629650233632,-0.13180699534779244},
{0.04964602243807102,0.9648714360843577,-0.2579891166010455},
{0.07356440080139735,0.9222970100473377,-0.37941600413328963},
{0.09121419839432728,0.8628619848107645,-0.49714099124866806},
{0.11742997727542273,0.7885338474060988,-0.6036758831790691},
{0.1372300138077416,0.7022560706592538,-0.6985730702886794},
{0.15477695217594123,0.6044308132387651,-0.7814777585335689},
{0.204490944696045,0.605141836341228,-0.7694067919162696},
{0.2512650290017651,0.6064520699985213,-0.7543750870722408},
{0.29331204520217613,0.6087860938197278,-0.737121113597375},
{0.33067597598465814,0.6125449555139242,-0.7179429478593953},
{0.36336793288576735,0.6180638858433017,-0.6971088712436548},
{0.3950687786961621,0.6255486495893262,-0.6727626231416944},
{0.42908782797679335,0.6343127457012168,-0.6430637421929036},
{0.46599003125535043,0.6432450431443761,-0.6075270407486626},
{0.5065150096536697,0.6509040124055797,-0.5654790107774645},
{0.5494398727321582,0.6554998481652767,-0.5181078799896495},
{0.5933312339781416,0.6553152584213294,-0.4674611843417183},
{0.6383510383760697,0.6488420390067624,-0.4141400248970637},
{0.6844807892148579,0.6347808045199161,-0.35852388959294373},
{0.7304302127067871,0.6126431784063143,-0.3018940879138354},
{0.7743800045018582,0.5833980033915843,-0.24491300142380173},
{0.8142654158674392,0.5490642804220244,-0.18841509622870142},
{0.8482231570188442,0.5125650948834964,-0.1333960246936074},
{0.8739021838715687,0.4785451006872851,-0.08537891796397339},
{0.8908440631694697,0.4517300320320332,-0.04834080342783103},
{0.9014123113292745,0.4322211492802962,-0.02531250874241996},
{0.9045082444166284,0.42645611523716503,0.00013251103580719226},
{0.8310906913143721,0.004488918332715565,-0.5561187934450708},
{0.7932993496805628,0.004618272035700604,-0.6088142683608856},
{0.7519427172479108,0.004402158344661847,-0.6592137521166688},
{0.706943635453269,0.003808488036092562,-0.7072596352903187},
{0.6588083261025255,0.002866381418825754,-0.7523053723824855},
{0.6082701095728823,0.0017631903176185087,-0.7937281429810195},
{0.5553651841516839,0.0007171932378117069,-0.8316062757495435},
{0.5055729103842546,0.013203697659567621,-0.8626828470844364},
{0.44693706234274305,0.008900541241526385,-0.8945211247757354},
{0.38364977056165744,-0.000640422617000934,-0.9234784477219051},
{0.3225129674474587,-0.0005171789477990322,-0.9465649044593668},
{0.2595049256925374,-0.00034219490201482767,-0.9657417234664554},
{0.25692606087940806,-0.1300030308046118,-0.9576472269174102},
{0.2502539138174469,-0.2555379119977413,-0.9338486784007807},
{0.2345439732460396,-0.38570995600283925,-0.8923098982160004},
{0.22201398889785773,-0.5140359742948608,-0.8285389585676677},
{0.20273996253396248,-0.621548885138709,-0.7566858601656009},
{0.18029198771842003,-0.7174159511292683,-0.6729109541609708},
{0.15465698267640834,-0.8018159101861995,-0.5772109353448751},
{0.12487495445873678,-0.869768682799768,-0.47739782589543156},
{0.10059203009452451,-0.92243827596959,-0.3728121115357073},
{0.06857700589210232,-0.9649760829102662,-0.2532160217561949},
{0.03533959743900731,-0.9910019281839955,-0.1290979906445168},
{0.0008492766329505505,-0.9999995678095022,-0.0003782988365027669},
{-0.03372190733094769,-0.9911562154716309,0.12834402790124966},
{-0.0671058309294322,-0.9652644448954854,0.2525101163832475},
{-0.10412904934577895,-0.9227734372936691,0.3710071758168177},
{-0.1317270379588639,-0.8633722487919732,0.48706914035532484},
{-0.16042101240583864,-0.7888820610066187,0.5932370458768023},
{-0.18567805690392725,-0.7026672153432925,0.6868642105002158},
{-0.20025801773445032,-0.6154040544989546,0.7623480675120232},
{-0.21994206680103462,-0.5044851532227584,0.8349372535880161},
{-0.23837900191489855,-0.3796220030495036,0.8939030071807229},
{-0.247445885536385,-0.25799788065523893,0.9339205679866566},
{-0.25840506281143066,-0.14434203508572793,0.9551922321819473},
{-0.2591318819848166,-0.00803074634259592,0.965808560146465},
{-0.25376203758748955,0.13380501981933482,0.9579671418950616},
{-0.24935101227729606,0.2601290128079725,0.9328220459293601},
{-0.2410430473412207,0.38114807485806096,0.8925381752958537},
{-0.2189969430001401,0.4967188707155194,0.8398277814121732},
{-0.21101298240035743,0.605578949491387,0.7672989360030512},
{-0.1896040303187297,0.7025381123397171,0.6859231096828866},
{-0.16449294555983499,0.7885787390139952,0.5925248038995047},
{-0.13580596355783264,0.8630397684119396,0.48653786944244565},
{-0.10848400895502985,0.9224830761482137,0.37048103058209886},
{-0.07097407463213813,0.9651166550438154,0.252016909923022},
{-0.03758060440601871,0.9911181162004986,0.12756401495583816},
{-0.0032141814900817417,0.9999934635929882,-0.0016558407676411872},
{0.030784892022142293,0.9909267432028492,-0.1308299660956143},
{0.0633977135406978,0.9648282060712672,-0.25512205448983016},
{0.0949537799104201,0.922338804858752,-0.3745329207592468},
{0.12043001266460143,0.8630590907605934,-0.4905360515855097},
{0.15380895956932078,0.7890507925877688,-0.5947618436591381},
{0.18057696979498306,0.70296288241576,-0.6879208849318271},
{0.22060404278726126,0.7042431365914907,-0.6748151308837814},
{0.25535895907030326,0.7064538867674608,-0.6600868941993008},
{0.2849180247069525,0.7099100615605636,-0.6440880558527422},
{0.30931590399067815,0.714851778115404,-0.6271448053389862},
{0.3332949276931731,0.7215348434662796,-0.6068788683403747},
{0.36135109281466615,0.7294311873577071,-0.5808231491870587},
{0.3942341386868635,0.7375182594501191,-0.5483121928896836},
{0.4329889957995738,0.7443589927789734,-0.5083799950682057},
{0.4767168835118601,0.7479148172432971,-0.46191388712904585},
{0.5240851442182939,0.7459022052581429,-0.41105311311402226},
{0.5753978978168226,0.7360968692787769,-0.3564809366936255},
{0.6306383208045342,0.7163223643918468,-0.29862615191056485},
{0.6866109034614839,0.6859289035573741,-0.2409709661191231},
{0.739675978939206,0.6468629815818705,-0.1856009947153829},
{0.7870550176748947,0.6022850135255148,-0.13340600299589866},
{0.8265868442312901,0.556303895165595,-0.08532388392087727},
{0.8561808530779698,0.514596911694331,-0.04630729205359319},
{0.8757259824090471,0.48238199031025797,-0.020288399592461242},
{0.8878018917630831,0.4601859438961459,-0.0060578892614486825},
{0.891417342562969,0.45318117415309433,0.001394550535912136},
{0.8915278342025834,0.4529659157619361,-3.773419298257276e-08},
{0.8891367600160167,0.457535876507994,0.00983583734524144},
{0.9129686001832914,0.4080298213113352,-3.372728522979632e-08},
{0.913411164244477,0.40612407302695497,0.02726320490231673},
{0.9462503492965526,0.3234351193920533,-1.927640711564604e-08},
{0.943511416534582,0.32786214474220343,0.047881321138298634},
{0.9673186373247422,0.2535639049316833,-1.3365994988708485e-08},
{0.9603556210830444,0.26920289378357487,0.07243537141997212},
{0.9740910912640597,0.22615602118889783,-9.32662087382514e-09},
{0.9620696903574388,0.25352391840321326,0.10073496757840553},
{0.9686601028232753,0.24839002636660268,-7.467240792647652e-09},
{0.9520847670087006,0.27786493200173573,0.12777196873203095},
{0.960755696232155,0.27739591229408384,-3.7349788190895235e-09},
{0.9423390444868851,0.2915690137646819,0.16427000775502298},
{0.9678182885918428,0.25165007503904374,0.0},
{0.959446267166965,0.23753706614446188,0.15178604226627132},
{0.9837044512917354,0.17979308248324188,0.0},
{0.9708481916289474,0.1637810323275947,0.17501303454460118},
{0.9140249724777945,0.16943399489817307,0.36857898890171825},
{0.8055510177599835,0.17978400396369798,0.5645930124475823},
{0.6514037537834327,0.18332893070561884,0.7362497217134871},
{0.4918861282669489,0.17462804553697553,0.8529672224244532},
{0.3548339123723568,0.16092396025918923,0.9209757725613772},
{0.228104058067431,0.1447130368389513,0.9628222451013574},
{0.0983033517768327,0.12728693755879966,0.9869825158311278},
{-0.04955137875319193,0.1063849543838988,0.9930895741796877},
{-0.22158591552682952,0.067402174304886,0.9728086291450702},
{-0.4171690761938936,-0.004617430843351184,0.9088171659910151},
{-0.6188588370609878,-0.11608696943552388,0.7768767954565239},
{-0.7749237741496612,-0.22663593394730663,0.5900248280381739},
{-0.8714260144630577,-0.29237900485261437,0.3938670065370108},
{-0.9277458992254628,-0.3163529656367937,0.1980109784914547},
{-0.9432335521742709,-0.3321301944308994,0.0},
{0.8653600517473612,0.004082260244113643,-0.5011340299671374},
{0.8628540772077549,-0.11535001032146171,-0.4921150440342101},
{0.8302187244093554,-0.1282969574118962,-0.5424728199264486},
{0.7934308990299738,-0.12833498366841187,-0.5949769242847288},
{0.7532097550980307,-0.12844995823520935,-0.6451167902438579},
{0.7094767898427187,-0.12867596188431996,-0.6928817947583961},
{0.6624649723030025,-0.12902799460546868,-0.7378969691492663},
{0.6128493475233688,-0.12945007340617362,-0.7795244420384247},
{0.5606668036828334,-0.12985095453276113,-0.8177967136489397},
{0.5010748802102976,-0.12105897105898002,-0.8568947951460418},
{0.4391571540840236,-0.13031204572168334,-0.8889093118854426},
{0.3801020795559437,-0.13024702726090104,-0.9157281916633041},
{0.3193578580849043,-0.1301249421755465,-0.9386575828827213},
{0.3110691397280895,-0.2556211148215797,-0.9153654111698776},
{0.29772693492672414,-0.3772339175491234,-0.8769568083262023},
{0.2791381017048233,-0.49491918032532095,-0.8228832998200536},
{0.2557759892721158,-0.6044349746484866,-0.7544779683553086},
{0.22846011870882238,-0.7022343648838798,-0.6742943503661326},
{0.1972050747836296,-0.7885762990419894,-0.5824582208783923},
{0.15722700861203104,-0.8630190472714382,-0.4800810262961989},
{0.12481306672502089,-0.9224344931331506,-0.3654261953567135},
{0.08502308196870588,-0.9649757953524856,-0.24817894736737964},
{0.04370761074381807,-0.991004243599893,-0.12649203109315166},
{0.0008248526853734232,-0.9999996185664879,-0.0002872018904515325},
{-0.042156916282804095,-0.9911443828223515,0.12591904863532208},
{-0.08366331589469751,-0.9652281833779817,0.24765904705127448},
{-0.1283820434442341,-0.9226883122359324,0.36354412302262495},
{-0.16358393621593656,-0.8632036634227143,0.4776188137685801},
{-0.19913803069025954,-0.7886811215479947,0.5816580896425343},
{-0.23024706365860184,-0.7027041942833311,0.6731961861249707},
{-0.24851093789973377,-0.6055168486877164,0.7560368110743629},
{-0.2780159000776283,-0.4982118209364761,0.8212747048236582},
{-0.2939669410474346,-0.38268492325579917,0.875862824353173},
{-0.3044459342412076,-0.2612429435728365,0.9160048021475642},
{-0.3104290914941766,-0.13333303929785248,0.9411992774039393},
{-0.32174810345367116,0.002383640766426858,0.9468223044376713},
{-0.31118096446158,0.13738498430994878,0.940367892605291},
{-0.30599496435082374,0.26467596916458974,0.9145018934582494},
{-0.2962658682166752,0.3852478286362178,0.8739626112488446},
{-0.2763849702318202,0.507504945338929,0.8161189120995092},
{-0.2564840247254459,0.6233460600914981,0.7386850712103524},
{-0.22746789223745276,0.711671662846697,0.6646666851152295},
{-0.2040029128113157,0.7885126629980392,0.5801987520291985},
{-0.1689259725734347,0.8628598599073787,0.4763789226558389},
{-0.13438996148290183,0.9223547356467141,0.36221689618611685},
{-0.08990096221526284,0.9650385944011194,0.24620789652056632},
{-0.04892848437889274,0.9910996835774772,0.12380396047384319},
{-0.006815330214960633,0.9999710315398374,-0.003389300106901071},
{0.03477991036870998,0.9908472953949028,-0.13043003888426483},
{0.0746438891306484,0.9647448595176216,-0.2523799632494155},
{0.11331899976962248,0.9224169981247263,-0.36919599924942453},
{0.15222592651097278,0.8587645854203325,-0.4892347638156147},
{0.18767997302804387,0.7816998876599631,-0.5947449145277277},
{0.21082703756411075,0.7910601409471532,-0.574261102318981},
{0.23391703853853704,0.7932711306938093,-0.5621420926146038},
{0.2517979666047933,0.7964068943749498,-0.5498489270751913},
{0.2680879800322718,0.8007519403583963,-0.5356539601034231},
{0.2870350144042785,0.8121280407550225,-0.507995025492715},
{0.32360708133589944,0.8136522045045913,-0.48295812138743394},
{0.3614350089793108,0.8186720203386786,-0.446252011086462},
{0.40684325690654466,0.8205805181663993,-0.4014052534726456},
{0.4589178297029677,0.8164696970212152,-0.35038786997669175},
{0.5182492160607344,0.8031503348374601,-0.2938831225213687},
{0.5849248779993063,0.7770948379174609,-0.23234995153761387},
{0.6530398154362808,0.737386791597931,-0.172625951212029},
{0.7165309709163669,0.6872929721031226,-0.11921299516120425},
{0.7722628746029725,0.6311278975199185,-0.07271608819264579},
{0.818106296159192,0.5740912078243243,-0.03348691212245509},
{0.8525288140424933,0.5226558859958939,-0.005044408899690326},
{0.875737305732869,0.48270216851847914,0.009098783176520022},
{-0.3804258691917286,0.10851696268677434,-0.9184226842031695},
{-0.43850294801350537,0.12982198460902045,-0.8893038945690277},
{-0.49426207298669717,0.15106802230791438,-0.8560861264165355},
{-0.5509098421706883,0.12982096280779243,-0.8244057638172632},
{-0.6051663558270288,0.10851606380551099,-0.788668463722997},
{-0.6537289158056047,0.12982098328022681,-0.7455099039850401},
{-0.6989915901282274,0.15106791141742834,-0.6989915901282274},
{-0.7455099039850401,0.12982098328022681,-0.6537289158056047},
{-0.788668463722997,0.10851606380551099,-0.6051663558270288},
{-0.8244057638172632,0.12982096280779243,-0.5509098421706883},
{-0.8560861264165355,0.15106802230791438,-0.49426207298669717},
{-0.8893044936688501,0.12982192608506354,-0.4385017503362492},
{-0.9184239885376094,0.10851599864566608,-0.38042299525213086},
{-0.9389007172777892,0.12982196090795212,-0.3187659040130661},
{-0.9548403984893556,0.1510680630461543,-0.25584810677464775},
{-0.9724948270952974,0.12982197691830363,-0.19339096561605632},
{-0.985590132866922,0.10851601462899066,-0.12975501749221022},
{-0.9894113055571654,0.12982104009227385,-0.06489812004230747},
{-0.43236002961644276,1.3820100946669907e-07,-0.9017010617660655},
{-0.500000174843837,1.382100483303334e-07,-0.8660253028382678},
{-0.5647168245667891,1.1329996480257758e-07,-0.825284743619552},
{-0.6087613233345313,-1.680920892796155e-08,-0.7933534213778812},
{-0.6510041479433134,-1.494060339531227e-08,-0.7590741725026615},
{-0.7071067811865474,2.5213992197556526e-08,-0.7071067811865474},
{-0.7590741725026589,8.590861952307932e-08,-0.6510041479433111},
{-0.7933537919679858,-1.4941496082063818e-08,-0.6087608403716663},
{-0.8252847436195571,-1.4940595358600184e-08,-0.5647168245667926},
{-0.866025302838276,-1.400780489835513e-08,-0.5000001748438416},
{-0.9017010617660739,-1.4940601023423733e-08,-0.4323600296164469},
{-0.9238797538373535,-1.6809195521282897e-08,-0.3826828980362601},
{-0.943323754334,-1.6185695784824537e-08,-0.33187391357141544},
{-0.9659258492011169,-1.4941597667340367e-08,-0.2588189595935754},
{-0.9828793975055036,-1.6185706545978528e-08,-0.18425007451618056},
{-0.991444888610677,-1.8676897901641293e-08,-0.13052598533534107},
{-0.9970760301372166,-1.74307005268533e-08,-0.07641590230971614},
{-0.3826849586956275,4.519799512164044e-07,-0.9238789002828898},
{-0.38042419992038784,-0.10851605702731902,-0.9184234826495763},
{-0.43850219722495837,-0.12982105838956565,-0.8893043999820853},
{-0.49426207298669717,-0.15106802230791438,-0.8560861264165355},
{-0.5509091456719665,-0.12982103432741224,-0.8244062179903453},
{-0.6051663558270288,-0.10851606380551099,-0.788668463722997},
{-0.6537289158056047,-0.12982098328022681,-0.7455099039850401},
{-0.6989915901282274,-0.15106791141742834,-0.6989915901282274},
{-0.7455099039850401,-0.12982098328022681,-0.6537289158056047},
{-0.788668463722997,-0.10851606380551099,-0.6051663558270288},
{-0.8244056567917524,-0.12982194595383692,-0.550909770650801},
{-0.8560861264165355,-0.15106802230791438,-0.49426207298669717},
{-0.8893046091195845,-0.12982094293916438,-0.4385018072631505},
{-0.9184239885376094,-0.10851599864566608,-0.38042299525213086},
{-0.9389007172777892,-0.12982196090795212,-0.3187659040130661},
{-0.9548403984893556,-0.1510680630461543,-0.25584810677464775},
{-0.9724948270952974,-0.12982197691830363,-0.19339096561605632},
{-0.985590132866922,-0.10851601462899066,-0.12975501749221022},
{-0.9894113055571654,-0.12982104009227385,-0.06489812004230747},
{-0.964753660786281,-0.25545491018037697,-0.06319147778146167},
{-0.9241788787870352,-0.37714795053422845,-0.0604385920730271},
{-0.8671150606127149,-0.49488203459303737,-0.056597203956234125},
{-0.7949769309076995,-0.6044249474687774,-0.051789595498910525},
{-0.7104437832847127,-0.7022377857878878,-0.04617058591602598},
{-0.613642871999768,-0.7885828355089083,-0.03974339170989578},
{-0.5044059756732571,-0.863024958377602,-0.0276139986682183},
{-0.3852680836295567,-0.9224392002324737,-0.02596970563720449},
{-0.2617270760367832,-0.9649762803442935,-0.017880605194662016},
{-0.13351505352101206,-0.9910013972540649,-0.009484783802082349},
{-0.0005495957510936087,-0.9999995471102568,-0.0007769966481060282},
{0.13241502842961958,-0.9911622128033726,0.007982991713955131},
{0.2606260043664812,-0.9653000161724629,0.01643060027527532},
{0.38383705481524405,-0.9229321318026735,0.02941760420108776},
{0.5027969224055467,-0.8637488667014094,0.03366229480504505},
{0.6085180890133601,-0.7925051159267811,0.04051390592632982},
{0.694197963924532,-0.7183039626718128,0.046136797602403565},
{0.7616231461225593,-0.6460311239454469,0.050734309733720964},
{0.8137581588791187,-0.5786351129734133,0.054580810656422916},
{0.8596580433852232,-0.5075020256126128,0.05856400295560817},
{0.9053581647239531,-0.41985207638931915,0.06364611157999067},
{0.94836949211508,-0.3093128343521956,0.07014896243278546},
{0.9824935409590771,-0.16933992088095207,0.07765586371760438},
{0.9956471913769892,-0.03760440722808069,0.08527941639186863},
{0.9948079147537944,0.038286496719187164,0.0942939919198421},
{0.9928360780495825,0.05577070438428889,0.1056700083070108},
{0.9938118728313986,0.025251696768781848,0.10816798615877724},
{0.9906919917891139,0.009624249920233918,0.13578199887463457},
{0.9918339094508796,0.025777697646634356,0.12490398859693523},
{0.9996954885126913,0.024676512058461258,-1.866370912023599e-09},
{0.9885297160481963,0.08312227612340847,0.12609396377993715},
{0.9959692421489555,0.08969542180755367,-4.357431059417636e-09},
{0.9715139699564168,0.20104699378272237,0.12546199612015058},
{0.9751287986544512,0.2216389542357718,0.0},
{0.927270289587484,0.3543731106710941,0.12078703772191857},
{0.92647189471574,0.3763639572300024,0.0},
{0.8600198905839764,0.497946936648705,0.111420985824466},
{0.8544085823288748,0.5196017459966457,0.0},
{0.7741368513459983,0.6246988800418968,0.10229098035752525},
{0.7651802011444763,0.6438161692412664,0.0},
{0.673682930053526,0.7318769240114185,0.10250598935711118},
{0.6642227442895698,0.7475347122163845,0.0},
{0.5210829316761315,0.8446068892559965,0.1229299838815445},
{0.500215103037819,0.8659011783644044,0.0},
{0.2660859543820948,0.950221837093507,0.16210097220933065},
{0.22818707191795898,0.9736173068559886,0.0},
{-0.03957529106449213,0.9799877787334401,0.19508395595296518},
{-0.08440851972487007,0.9964312328494406,0.0},
{-0.25668396130540916,0.9502058567583784,0.17669797336313592},
{0.7696671679115134,0.6384101392763225,-0.006704081462570461},
{0.8245896614931126,0.5652737679463221,0.022747690661719007},
{0.8667100422637078,0.4972210242461759,0.039811501941343246},
{0.8960411450103825,0.4420390715371779,0.041373006695580396},
{0.7033211235683242,0.709331124624237,-0.0467841082196221},
{0.6276536963282825,0.7722776263562621,-0.09817385250147878},
{0.6709822647612665,0.740674292260875,0.03441501357973685},
{0.7505588579477278,0.6572638756049229,0.06830518707242354},
{0.821246048575962,0.5636970333421704,0.08832090522410176},
{0.8796617677261149,0.4663338768649664,0.09342317533169602},
{0.9207714142381918,0.381860171791896,0.07976723588581817},
{0.5457400384372909,0.8223610579201249,-0.16090401133271126},
{0.5850888583802506,0.8108058037458532,-0.016278096059914916},
{0.5933197321233212,0.7962236405146623,0.11831994657997602},
{0.6883458894279112,0.7093518860536236,0.15165697563865949},
{0.7813019843938837,0.6012109879911113,0.16766799665091564},
{0.8667253305803716,0.4708851796017633,0.16448206273560895},
{0.9291580008957083,0.34601200033355556,0.1301580001254723},
{0.46632178364772714,0.8549546033396291,-0.22714889461315907},
{0.39833907565515364,0.8715511655306781,-0.28587505429525367},
{0.3413229880376535,0.8775979692428246,-0.33663098820209403},
{0.33533708306736515,0.9172022272029435,-0.21514905329522407},
{0.4080579979546093,0.8997939954897826,-0.1544649992257442},
{0.494673047912708,0.865070083788374,-0.08338060807602263},
{0.2864700510849197,0.8811681571347663,-0.3761350670744799},
{0.25144607191044377,0.8743782500612856,-0.41501511868915325},
{0.19285197882167185,0.9243478984913546,-0.32922496384566874},
{0.21830007443935573,0.9319723177984207,-0.289435098696083},
{0.27610891392954806,0.9238757120035028,-0.2649859173968803},
{0.2620170748956264,0.9550012729799903,-0.13899503973069532},
{0.3314549335349713,0.9400958114872076,-0.07973388401135613},
{0.41350701844081295,0.9104600406029948,-0.008629030384821363},
{0.5014511535219619,0.8629352641922625,0.062365619093569},
{0.21963087492058178,0.8772495004078676,-0.42684375691318993},
{0.20956391208366126,0.869368635282112,-0.4475278122529478},
{0.1505269714891406,0.9226178252497421,-0.35513093273572177},
{0.16714294330161325,0.9232516868136926,-0.3459328826523215},
{0.10637695100645767,0.9621505568667499,-0.25089888444465647},
{0.12923097545244933,0.9621898172310993,-0.23977095445527175},
{0.15153103561138861,0.9654672268949623,-0.21192304980414775},
{0.19734909220654984,0.9633384500963943,-0.1817480849173597},
{0.1775499021318852,0.9822934585454128,-0.05979626703941902},
{0.23650701485549888,0.9715960610279751,-0.00809482050845256},
{0.3038339073980916,0.9511747101028185,0.05432888344174838},
{0.37742491224985036,0.9176877866403674,0.12409497114829483},
{0.4604311494667954,0.8669442814305326,0.19081606194338793},
{0.19776693400933826,0.8672347106220373,-0.4569378475294615},
{0.14245998440455018,0.9225428990069279,-0.3586359607392269},
{0.0880711579657847,0.9634285401790594,-0.25307887921162453},
{0.09276264650100985,0.962585482534713,-0.25460612763156826},
{0.03382459291939453,0.9886987930326582,-0.14604996942691328},
{0.04383371537350165,0.9881473465662157,-0.14711705159736554},
{0.06280739201571255,0.9879758744051755,-0.14127598204052083},
{0.09142347277019695,0.9878567057742095,-0.1256219625844305},
{0.11704994881250244,0.9896685672047884,-0.08279756379152543},
{0.08551808701958256,0.9960778488096877,0.022706296553510277},
{0.13114999005534514,0.9895049249692284,0.060660395400329845},
{0.18072591295690915,0.9777565290827475,0.10644394873336009},
{0.2356229204988372,0.9577476768478475,0.16492794435191904},
{0.299895092008878,0.9244782836332166,0.23537807221482746},
{0.38508605535111834,0.8638031241604787,0.32488904669858026},
{0.5726520591549608,0.7824860808308164,0.24451002525788693},
{0.7127494692341346,0.650126428006649,0.26329417333806465},
{0.8407656981311176,0.4802578275680204,0.2499309102646971},
{0.9200162807388709,0.3409981040540529,0.19310705892575905},
{0.18715798160386857,0.865713914907252,-0.4642319543697149},
{0.13676195649322495,0.9226107064986675,-0.3606738852622616},
{0.08662252209886996,0.9641742459771518,-0.25072806396496833},
{0.03536820826809351,0.9902732314980621,-0.13456603145775783},
{0.03267701168012216,0.9895523537071409,-0.14042205019267723},
{-0.02546868920536668,0.9994575763905252,-0.020878191151000508},
{-0.02844718761856213,0.999155565124584,-0.029646487096575486},
{-0.0227265091369278,0.9991414016931414,-0.034640513926814394},
{-0.008309867258178795,0.9993996702504235,-0.03363398890254427},
{0.015311601800004682,0.9995991175110949,-0.02381510279966114},
{0.03395608830947599,0.9993456559416891,0.012459695710331222},
{-0.01196250195484494,0.9932861623172506,0.11506301880295283},
{0.03079421325282157,0.9910964265354659,0.12953605574807903},
{0.06716107660232042,0.9855206566627916,0.1556869457615414},
{0.10990004956482365,0.9741694393495421,0.19727108896908394},
{0.16361498156296506,0.9509348928434322,0.26258897041003226},
{0.2347590045681755,0.9016990175461613,0.36308000706517396},
{0.352743872340252,0.7699047213676822,0.5318068075364922},
{0.5579812740486642,0.7258083564757811,0.40231719759532386},
{0.7814437423654644,0.49654583629358195,0.37787287541892334},
{0.9027285986140048,0.3478858453172897,0.25309388746524475},
{0.17176706772132688,0.864531340852355,-0.4723151862162028},
{0.1271479828067331,0.9225298752532124,-0.3643789507277707},
{0.08226473083134243,0.9645633615010101,-0.25069909395751416},
{0.03619029454505378,0.9906618506780012,-0.13145098018645507},
{-0.011922803038511499,0.9999062548248631,-0.0067326317158028035},
{-0.018248204996283938,0.999757273729455,-0.012344903379984087},
{-0.07281212628403881,0.991195357806022,0.11059003992127478},
{-0.08491858038255129,0.9913657709798365,0.09991367691846209},
{-0.09238859823697057,0.9917609810744634,0.08873839830662646},
{-0.09103988998065007,0.9925748907626627,0.08066489112246542},
{-0.08084849957661218,0.9937009947961816,0.0776005995936208},
{-0.061316814064170576,0.9947362281615607,0.0820980188307328},
{-0.04549879342800824,0.9936088564799477,0.10330198507872972},
{-0.10910698712352146,0.9753918848871828,0.191588977389245},
{-0.0938574373032817,0.9737383870086207,0.20742308243951568},
{-0.0634940820403265,0.9757237240108221,0.20959894071371035},
{-0.02744379651239536,0.9772578758083962,0.21027097327840477},
{0.009107020357472047,0.9716790381406959,0.23612900926862102},
{0.05828088814377996,0.9539338059389714,0.29430194012945465},
{0.12092197110618215,0.9117477821415405,0.3925479062022592},
{0.2074750587766551,0.82153623273714,0.5310671504486897},
{0.2818119768805691,0.6363819477921817,0.7180529410920162},
{0.43555904566706166,0.5703360597980279,0.6964230730178738},
{0.6029730735572927,0.5539920675820504,0.5740350700271164},
{0.7596888694660914,0.421880927510105,0.49486291496993956},
{0.8743198559453239,0.35457994157870454,0.33141794539492103},
{-0.060734118663967704,0.9911133045752062,0.11834603636846389},
{-0.10828600665628689,0.9650560593215153,0.23862301466803787},
{-0.12605103230278705,0.9652922473730627,0.2287400586186505},
{-0.1430350095676836,0.9658630646070654,0.21598501444734608},
{-0.15478899082271577,0.9669389426711585,0.20265598798472945},
{-0.15711903965095864,0.9687172444679364,0.19209504847759276},
{-0.14993603191021437,0.9710582066659703,0.1859170395678911},
{-0.13267597749364513,0.9734658348671105,0.18644396837276653},
{-0.19741095137156894,0.9371297691559153,0.28777892911113734},
{-0.17507703095729843,0.9413301664469561,0.28852305101693887},
{-0.1532999757193553,0.9458218501945994,0.2862169546671019},
{-0.1412240433133501,0.945752290061799,0.29258908973694125},
{-0.11703099974223923,0.952311997902533,0.2817899993793575},
{-0.07885654034249394,0.955170488659019,0.2853611459889091},
{-0.032235013125697085,0.9460203852077541,0.322500131318049},
{0.007024939719086704,0.9128149634983544,0.40831298367238},
{0.08446553500631536,0.8186743392954545,0.5680122354098086},
{0.14188499809519392,0.6357389914652041,0.7587519898137545},
{0.3217249097558537,0.4038308867250483,0.8563957597801667},
{0.46155405562095947,0.39367204744063394,0.7949780958012261},
{0.6410112300993555,0.37461213447191977,0.6699032404705201},
{0.813002457468075,0.3005561691198481,0.49869128060842627},
{0.9122850207462738,0.2577020058604014,0.31831700723884715},
{0.1908090502391709,0.40477210657468826,0.8942882354620991},
{0.05691077739328971,0.3932988437696088,0.9176476354821497},
{-0.09244176007869988,0.3653378422275643,0.926273599985479},
{-0.2599409089503838,0.3089818917727772,0.9148556795530998},
{-0.4512259296259071,0.21512796644821475,0.8660918649225912},
{-0.6548476652004549,0.07145256346893024,0.7523756153379982},
{-0.8086401547042419,-0.08319671591670261,0.5823911114196159},
{-0.8987758392665384,-0.185585966810551,0.3971899289681482},
{-0.9510141693756387,-0.23233004137798405,0.20394803632314848},
{-0.9668101053262322,-0.2554960278342498,0.0},
{0.00045839979094150957,0.9999995439387207,-0.0008378496178890572},
{0.05142799790387199,0.991161959601726,0.12228299501592864},
{0.10057505169423209,0.9652994961510369,0.24100112387135597},
{0.14070394063645716,0.9279236085054005,0.345195854360519},
{0.1853799306322333,0.8748466726389977,0.44752383253996963},
{0.2282299751343456,0.80270991254476,0.5509699399718283},
{0.2661890286778766,0.7184720774045934,0.6426050692310609},
{0.2994538646886576,0.6226777186365984,0.7229106733452956},
{0.32801397669034354,0.5151309633932496,0.7918629437278456},
{0.3510741517181317,0.398010172001725,0.8475463662706315},
{0.36773211313464066,0.2768050851604816,0.8877792731297742},
{0.3782560771396609,0.1515870309139043,0.9132051862345186},
{0.38267380182598154,-1.2905893316467632e-06,0.9238835215514906},
{0.3782531036056197,-0.15158804152080402,0.9132062501322489},
{0.36772693275396584,-0.2768069493804562,0.8877808376519769},
{0.35106785884512115,-0.3980108399706197,0.8475486592236364},
{0.32800695060773305,-0.5151309224300461,0.791865880758469},
{0.2994470294155815,-0.6226770611674388,0.7229140710140214},
{0.26618203169615967,-0.7184710855533866,0.6426090765199656},
{0.2282239678737131,-0.8027088870054875,0.5509739224413348},
{0.18537396715396043,-0.8748458449878281,0.4475279207034298},
{0.14069701549510386,-0.9279231021931049,0.3452000380172275},
{0.10057002955165267,-0.965299283645031,0.24100407081700806},
{0.05142279279052907,-0.9911618610391961,0.1222859828555162},
{0.00045223879574282216,-0.9999995483424077,-0.0008359396224413523},
{-0.050564814730644086,-0.9910012887004996,-0.12393403610471404},
{-0.09975858698095859,-0.9649758740653687,-0.24263096833533113},
{-0.14716104666668836,-0.9224382925172206,-0.3570031132103462},
{-0.19840693286962086,-0.8581267096554513,-0.4735538397745061},
{-0.2418539812993672,-0.7749719400776219,-0.5838879548526172},
{-0.2781769634293288,-0.6867309097185835,-0.6715789117105484},
{-0.3098100382359828,-0.5870190724484309,-0.7479480923098895},
{-0.33665392000144345,-0.47549488700887665,-0.812753806866555},
{-0.35745106727479936,-0.3571040672094915,-0.8629631624157232},
{-0.37198604590345286,-0.23479902897443677,-0.898051110820412},
{0.0003943858226447368,0.999999550300307,-0.0008624726121461566},
{0.059291402611224266,0.9911620436512928,0.11866900522624481},
{0.11608197131614842,0.9652997614744583,0.2339259421969068},
{0.1664410772498158,0.9229324283579586,0.34712116110834057},
{0.22224598285672342,0.8637489333734331,0.45226596511378775},
{0.27086804464867326,0.7895091301391429,0.550732090780207},
{0.31388094031774205,0.703314866269614,0.6378298787211248},
{0.35148901033746766,0.6055630178099113,0.7139670209981274},
{0.38362592282866625,0.4959789002274065,0.7789968432946738},
{0.40909895071564784,0.3781239544472209,0.8304578999543276},
{0.42724617841184626,0.25623210699883486,0.8670673620748335},
{0.43831825375522177,0.1302830754246724,0.8893275148576378},
{0.4519209851758621,0.0,0.8920579707382688},
{0.4383178639468136,-0.13028295956037106,0.8893277239540514},
{0.4272449904995669,-0.2562319943022973,0.867067980719443},
{0.40909811807718865,-0.3781241091372211,0.8304582396935354},
{0.38362496142401853,-0.4959779501261958,0.7789979216666995},
{0.3514889722343055,-0.6055619521639383,0.7139679436004616},
{0.31388096087191575,-0.7033139123255965,0.6378309204886403},
{0.2708678954729119,-0.7895086953310219,0.5507327874739105},
{0.2222469334630563,-0.8637487414083493,0.45226586459930895},
{0.16644296406854647,-0.9229318007588888,0.3471219250638476},
{0.11608397151990388,-0.9652997631729026,0.23392494260874463},
{0.05929470508211708,-0.9911620849519658,0.11866701017088521},
{0.00039811181969213674,-0.9999995470926191,-0.0008644776084715331},
{-0.05854342199521973,-0.9910013723269361,-0.12037004522396375},
{-0.11537805388940947,-0.9649764507097262,-0.23560211004223205},
{-0.17014303752173326,-0.9224392034260012,-0.34663707644405617},
{-0.22828890609999813,-0.8630246450199129,-0.4506358146440641},
{-0.2724029404115909,-0.7885828274967369,-0.5513018794021758},
{-0.3152380047416525,-0.702237010562698,-0.6383480096017117},
{-0.35263791309345494,-0.604424851041327,-0.7143648239469539},
{-0.38454307549792627,-0.494882097160954,-0.7792421529897957},
{-0.4097478983554905,-0.37714790644243906,-0.8305817939609224},
{-0.4276511429796241,-0.2554540854077668,-0.867097289902755},
{0.0003396748464794604,0.9999995480369777,-0.0008880015986559323},
{0.06694392200556833,0.9911623258113602,0.11452403764593498},
{0.13116592471878194,0.9653004459765863,0.22581087039837205},
{0.19547497607484177,0.9192818874845002,0.3416289581863262},
{0.26159094116428006,0.8522178083234531,0.4530948980921724},
{0.31540520990507565,0.7759345163915758,0.5463013635685952},
{0.36293407849103576,0.6878321487560992,0.6286221359508668},
{0.40437200367291093,0.5881630053422846,0.7003910063616515},
{0.4395681538207484,0.47658016677258636,0.7613482664232135},
{0.4668550615814547,0.3580560472301021,0.8086051066606809},
{0.485940069676036,0.23553603377210108,0.8416561206800298},
{0.4970350586389571,0.1089140128494037,0.8608681015630725},
{0.5000098398718743,0.0,0.8660197226572282},
{0.4970351127728066,-0.10891302471138789,0.8608681953232679},
{0.4859401841322465,-0.23553508924885516,0.841656318920052},
{0.4668550615814547,-0.3580560472301021,0.8086051066606809},
{0.4395680286453307,-0.4765790310572267,0.7613490496148352},
{0.4043728401556938,-0.5881627675054797,0.7003907231429559},
{0.3629358150472298,-0.687831649479705,0.6286216796532164},
{0.31540701094367724,-0.7759340269225834,0.5463010189550068},
{0.26159397292384806,-0.8522179117916159,0.4530929531028429},
{0.19547799500192095,-0.919281976495339,0.34162699126511037},
{0.13117004175267705,-0.965300307264307,0.22580907187718421},
{0.06694851672440268,-0.9911622476021481,0.11452202860873723},
{0.000344794842641774,-0.9999995436180165,-0.0008909995933636527},
{-0.06630227233159379,-0.9910015864480435,-0.11627495147764208},
{-0.1305670249313188,-0.9649771842590336,-0.22753304344664244},
{-0.19249199064594819,-0.922440955174444,-0.3347379837335754},
{-0.24927001706141153,-0.8697720595319856,-0.42586502914854585},
{-0.2987829867731762,-0.8018199645042327,-0.5175069770904841},
{-0.34832112363956547,-0.7174192546541076,-0.6033092141497716},
{-0.39168816204593054,-0.6215482571417149,-0.6784232806715711},
{-0.42888702555866526,-0.5140270306324137,-0.7428540442689023},
{-0.45890508287941273,-0.3970190717026434,-0.7948471435513942},
{-0.48057919275794997,-0.27599511070028115,-0.8323883338668657},
{0.00027904787433157604,0.9999995496530204,-0.0009070975914911555},
{0.07430530522733791,0.9911620697277139,0.10989300773091348},
{0.14568395063645853,0.9652996729179143,0.21673192656256646},
{0.21445704324633943,0.922940186115522,0.319671064463275},
{0.280548968799169,0.8637489039394667,0.41860495344548065},
{0.3415149487377563,0.7895078814929022,0.5099459234558478},
{0.3954388351583901,0.7033127068188845,0.5907447537436702},
{0.4425730168503041,0.60556002305579,0.6613820251811291},
{0.48282422060702357,0.4959742266153877,0.7217273297641487},
{0.5146558884357392,0.3781179180336862,0.7695168331883913},
{0.5372892105177446,0.2562251003927292,0.8035353148368493},
{0.5510319332234747,0.1302789842122074,0.8242519001134516},
{0.5465980656931658,0.0,0.8373951006427549},
{0.5510319332234747,-0.1302789842122074,0.8242519001134516},
{0.5372892105177446,-0.2562251003927292,0.8035353148368493},
{0.5146558884357392,-0.3781179180336862,0.7695168331883913},
{0.4828249874875906,-0.49597398714683427,0.7217269812964455},
{0.4425738209789256,-0.6055597550511286,0.6613817324711433},
{0.39543991238930853,-0.7033128441792983,0.5907438691192335},
{0.3415160062591347,-0.7895080144697083,0.5099450093460173},
{0.2805509288217134,-0.8637487808591884,0.41860389379643814},
{0.21445806581032786,-0.9229402832208824,0.31967009809653874},
{0.1456859397620086,-0.9652996008694514,0.2167309103864468},
{0.07430789903732594,-0.9911619871592934,0.10989199857632664},
{0.0002817528724350899,-0.9999995472456014,-0.0009089135884851885},
{-0.07378552738567881,-0.9910013678125795,-0.111678041449578},
{-0.14520505047350216,-0.96497633542728,-0.21848607594610098},
{-0.2140240139430229,-0.9224390600941395,-0.3214030209384433},
{-0.28017306775440126,-0.8630372087087449,-0.4203211016464744},
{-0.34124008994185673,-0.7885832078496636,-0.5115581348331858},
{-0.39520584690439825,-0.7022377279657972,-0.5921777706010353},
{-0.4423389276063747,-0.6044249010792244,-0.662575891562176},
{-0.4825728334453235,-0.4948818291970098,-0.7226447505871564},
{-0.5144309721914058,-0.37714797961251223,-0.7701429583683833},
{-0.5371029627629215,-0.2554549822894344,-0.8039049442656742},
{-0.59174309268887,-0.23479903677821962,-0.7711741207944103},
{-0.6375004361126038,-0.2554541747556221,-0.7268674972484078},
{-0.6796420895928048,-0.27599503638263406,-0.6796420895928048},
{-0.7268673115666519,-0.2554551094990679,-0.6375002732600881},
{-0.7711739397231193,-0.23479998164744717,-0.5917429537478932},
{-0.8039049442656742,-0.2554549822894344,-0.5371029627629215},
{-0.8323883338668657,-0.27599511070028115,-0.48057919275794997},
{-0.8670972899027551,-0.2554540854077669,-0.4276511429796241},
{-0.8980514448826723,-0.23479911631634123,-0.37198518427648414},
{-0.9155254522852491,-0.2554541261987122,-0.31073515350848624},
{-0.9284087762196249,-0.27599393347539625,-0.2487659400383357},
{-0.9482359531685238,-0.2554539873836388,-0.18865799068255937},
{-0.9637277729876855,-0.23479994469135335,-0.12687697011330848},
{-0.9260736264719823,-0.35710385596361716,-0.12191995082408544},
{-0.8721921657958966,-0.47549509038734583,-0.11482702182758547},
{-0.8026470508834102,-0.5870190372137796,-0.10567100669896086},
{-0.7206928887526147,-0.6867308939950462,-0.09488118535397816},
{-0.626588904204276,-0.7749718815188206,-0.08249198738825472},
{-0.5093129204201171,-0.8581268659181167,-0.0649509898514411},
{-0.3827549883438458,-0.9224379719087155,-0.05105689844514873},
{-0.26000396103950013,-0.9649758554024271,-0.03492189476710097},
{-0.13261204577123784,-0.9910013420455349,-0.018176506273647218},
{-0.0004977997751718275,-0.9999995483564234,-0.0008096186343407791},
{0.13161300257570005,-0.9911620193972936,0.016609300325048246},
{0.2590001121989454,-0.9652994181680687,0.033406214471584594},
{0.3693009631272191,-0.9279229073517228,0.050753094932567376},
{0.4802581952818083,-0.8748453557281993,0.06322712570931129},
{0.5975307739854466,-0.7976616982864141,0.08180946905576847},
{0.690103959431812,-0.7178799577989827,0.09167819461064064},
{0.7574503083133937,-0.6449732625306152,0.1013830412670629},
{0.8095990526814216,-0.5765840375189011,0.11000100715787578},
{0.855628460567068,-0.5036796824539851,0.11919192485517668},
{0.9013472880967784,-0.4130131320109955,0.13035804166621717},
{0.9435858895075142,-0.29839896505793084,0.14353998319168426},
{0.9754240065821612,-0.1541020010398803,0.15748200106268856},
{0.9851683204672481,-0.017214405599706238,0.17072505553547304},
{0.9800750830146124,0.06492710549947509,0.18771601589997802},
{0.9735776722798838,0.08423307164594791,0.21225292855264002},
{0.9697859204570517,0.055197695472622,0.2376309805092357},
{0.9666252231082434,0.03195400737535323,0.2541940586709187},
{0.9636767808663381,0.04947868874887673,0.2624479403210917},
{0.9578782025117574,0.1065390225241629,0.2666810563809148},
{0.9377681870688299,0.22163904421322586,0.2673330533284048},
{0.8923392412466234,0.3681620995337415,0.2611270705964964},
{0.8272813050637602,0.5045271860467044,0.2470990911189186},
{0.7406618951426513,0.6275259111595943,0.24006496601340502},
{0.6331577901876887,0.7289757584360625,0.2602029137754039},
{0.4686461191378256,0.8245052096032676,0.3171150806160547},
{0.21177496427843737,0.8926748494262972,0.3978479328922099},
{-0.06424230762385064,0.887262105294377,0.456770054206438},
{-0.2672569973431982,0.8615519914353116,0.431626995709196},
{-0.25528205143065896,0.7217381454057119,0.6433701296172196},
{-0.2490079099800462,0.6042307815618506,0.7569017263691002},
{-0.24877286112333538,0.5358467008652703,0.8068335495877172},
{-0.24564089903559302,0.5207477859599455,0.8176076639432878},
{-0.3618421960662372,0.501314271639969,0.7859734258841391},
{-0.20836800375958392,0.5322610096035855,0.8205370148049494},
{-0.015339003856586523,0.5266461324112305,0.8499462136964787},
{0.21507790042702055,0.4795997779633392,0.8507206061483524},
{0.4784411384479676,0.39671311479808075,0.7833982266943279},
{0.5310449759484426,0.339690984615056,0.7762739648417767},
{0.5454171057209349,0.3404750659959908,0.7658961484574943},
{0.5990638750589518,0.3482469273694543,0.7210038496270923},
{0.657840909056461,0.4072729436963522,0.6335409124158259},
{0.6399320498107128,0.5258490409307763,0.5603300436146914},
{0.6471490783377242,0.5773270698857347,0.49788706026948126},
{0.6507050273572667,0.5979490251392724,0.46801701967660597},
{0.6486393869790223,0.6031813598587098,0.4641542769149884},
{0.5733852436965211,0.7023282984990717,0.42185817929545943},
{0.5654467849484714,0.7029527326520132,0.43142483591989045},
{0.48410898642897304,0.7897039778622288,0.37683698943612887},
{0.39278314927372915,0.8642023284323795,0.31444511950206033},
{0.295211896715265,0.9232326769918712,0.24594991395037952},
{0.19639802749670776,0.9653951351601554,0.17158102402220296},
{0.09502926343280634,0.9911776185955502,0.09239246444744473},
{-0.0025017105655517975,0.9999952260649595,0.0018136404100025033},
{0.00021934190118851006,0.9999995495094878,-0.000923509583967507},
{0.08131919761602041,0.9911619709427789,0.10480999692735664},
{0.15951901416066303,0.9652990856905689,0.20676401835464947},
{0.22524598749648292,0.9279229484905345,0.29702398351205056},
{0.2948848947047322,0.874845687616719,0.38430186277639755},
{0.36304804256302886,0.802708094107897,0.47313405546929366},
{0.4234287912672296,0.7184696458243685,0.5518237279738698},
{0.47634464618895295,0.6226735375013069,0.6207845389043848},
{0.5217782824918822,0.5151262788904731,0.6799943681504106},
{0.5584682870770666,0.398005204592041,0.7278083741252601},
{0.5849768521629136,0.2768009300460474,0.762353807335683},
{0.6017289866557572,0.15158399663839753,0.7841839826095441},
{0.6087636945224547,0.0,0.793351601896266},
{0.6017289866557572,-0.15158399663839753,0.7841839826095441},
{0.5849770140847842,-0.27680000666465226,0.7623540183555791},
{0.558468752916445,-0.39800582391012335,0.7278076779957564},
{0.5217780137099783,-0.5151270135352201,0.679994017867183},
{0.4763449418961621,-0.6226739240471735,0.6207839242777128},
{0.4234299161953944,-0.7184688578017354,0.551823890783854},
{0.36304804256302886,-0.802708094107897,0.47313405546929366},
{0.2948848947047322,-0.874845687616719,0.38430186277639755},
{0.22524700366398043,-0.9279230150940599,0.2970230048315247},
{0.1595190471433888,-0.9652992852792838,0.2067630611056269},
{0.08132048901912232,-0.9911618661613162,0.10480998584728586},
{0.0002205039004139122,-0.9999995483706065,-0.000924465582483981},
{-0.08091832303535042,-0.9910012821123936,-0.10662403035309939},
{-0.15915698160455757,-0.9649758884676108,-0.20854397589638443},
{-0.23454601571915723,-0.9224380618213398,-0.3067510205583007},
{-0.3142118860308135,-0.8581266887450635,-0.40606585271405393},
{-0.38473403840492315,-0.7749720773592665,-0.5013960500503589},
{-0.44251589826096027,-0.6867308421133869,-0.5766978674111203},
{-0.4928368412538292,-0.5870188109171623,-0.6422777931178603},
{-0.5355387298930766,-0.4754947601771458,-0.6979276479898107},
{-0.5686229684999943,-0.35710398021751133,-0.7410429589484443},
{-0.6107560860127856,-0.3771480531137641,-0.6962300980500917},
{-0.6489899589315922,-0.3970189748764416,-0.6489899589315922},
{-0.6962296728233035,-0.3771478227682853,-0.6107567129893029},
{-0.7410429589484443,-0.35710398021751133,-0.5686229684999943},
{-0.7701429583683833,-0.37714797961251223,-0.5144309721914058},
{-0.7948471435513942,-0.3970190717026434,-0.45890508287941273},
{-0.8305817939609222,-0.377147906442439,-0.4097478983554904},
{-0.8629634705831699,-0.3571031947321748,-0.357451194921943},
{-0.8770457432466503,-0.37714788959072576,-0.2975739128858449},
{-0.886536771300582,-0.39701889758124675,-0.2375469387201429},
{-0.9083308885836859,-0.37714795373884624,-0.18081597782102313},
{0.00016055992734267133,0.9999995474755314,-0.000937693575670521},
{0.08798720704323851,0.9911620793409764,0.09927730794699345},
{0.17267293239605644,0.9652996220712752,0.19590992329843937},
{0.2506130051854337,0.9229320190963866,0.29221500604622075},
{0.33172887593375533,0.863748676958919,0.37933385812954296},
{0.40417815261931594,0.7895082981215478,0.46186217440103744},
{0.46826790983174477,0.7033128645721978,0.5348608970088002},
{0.5243009456501804,0.6055589372268555,0.5986709379408758},
{0.5721720695549576,0.4959730602919768,0.6531690794011976},
{0.6100959245531022,0.37811595324067165,0.6962839138947514},
{0.6370987698232641,0.2562239074291374,0.726948737361465},
{0.6535532870426274,0.13027705721808694,0.7455843274629453},
{0.6673970585931263,0.0,0.7447020653800037},
{0.6535532870426274,-0.13027705721808694,0.7455843274629453},
{0.6370987698232641,-0.2562239074291374,0.726948737361465},
{0.6100959245531022,-0.37811595324067165,0.6962839138947514},
{0.5721720695549576,-0.4959730602919768,0.6531690794011976},
{0.5243002205411669,-0.605559254721893,0.5986712518245296},
{0.46826790983174477,-0.7033128645721978,0.5348608970088002},
{0.40417815261931594,-0.7895082981215478,0.46186217440103744},
{0.33172887593375533,-0.863748676958919,0.37933385812954296},
{0.2506130051854337,-0.9229320190963866,0.29221500604622075},
{0.17267296622430775,-0.9652998111825489,0.1959089616792313},
{0.08798770317237119,-0.9911620357360604,0.09927730357941446},
{0.00016081292716795244,-0.9999995471009959,-0.0009380495751580892},
{-0.08770263624295703,-0.991001409529554,-0.10111604178602279},
{-0.17242507792365203,-0.9649764360994869,-0.19771208935155046},
{-0.25406206972912304,-0.9224392531699448,-0.29078907980910945},
{-0.3371429610433017,-0.8630249002779101,-0.3761949565308634},
{-0.4058079559801872,-0.7885829144588672,-0.46201394988327044},
{-0.4697119855241814,-0.7022379783580792,-0.5350069835118876},
{-0.5255130403830511,-0.6044250464470445,-0.5987540460112565},
{-0.5731229794758933,-0.4948819822777816,-0.653162976609581},
{0.00010249595322980191,0.9999995436875772,-0.0009497995665944608},
{0.09430752508394055,0.9911622636296019,0.0932923248139173},
{0.1851440798007259,0.9653004160633923,0.1841650793787575},
{0.27723697253385726,0.9192819089258265,0.27939297232026017},
{0.3699491701415122,0.8522173919391298,0.3699501701419721},
{0.4460529710123565,0.7759339495743821,0.4460529710123565},
{0.513268111838824,0.6878311498753287,0.513268111838824},
{0.571868177059279,0.5881611821038467,0.571868177059279},
{0.6216410778487387,0.47657605968210026,0.6216410778487387},
{0.6602270324636941,0.358051017605548,0.6602270324636941},
{0.6872138129088138,0.2355299358779258,0.6872138129088138},
{0.7029005650723266,0.10891093261012881,0.7029005650723266},
{0.7071067811865475,0.0,0.7071067811865475},
{0.7029005650723266,-0.10891093261012881,0.7029005650723266},
{0.6872138129088138,-0.2355299358779258,0.6872138129088138},
{0.6602270324636941,-0.358051017605548,0.6602270324636941},
{0.6216410778487387,-0.47657605968210026,0.6216410778487387},
{0.571868177059279,-0.5881611821038467,0.571868177059279},
{0.513268111838824,-0.6878311498753287,0.513268111838824},
{0.4460529710123565,-0.7759339495743821,0.4460529710123565},
{0.3699491701415122,-0.8522173919391298,0.3699501701419721},
{0.27723697253385726,-0.9192819089258265,0.27939297232026017},
{0.1851440798007259,-0.9653004160633923,0.1841650793787575},
{0.09430781977637075,-0.9911622078469351,0.09329261956348305},
{0.000102413953259325,-0.9999995436104927,-0.0009498895664801709},
{-0.0941371644324631,-0.9910016255730977,-0.09515236404889356},
{-0.18500802453558085,-0.9649771279743102,-0.1859870246654149},
{-0.27256991584064433,-0.9224407151849426,-0.2735119155497902},
{-0.3509988382060698,-0.8697715990762644,-0.346838840123633},
{-0.42254289730138384,-0.8018198051185218,-0.42254289730138384},
{-0.4926001129135645,-0.717419164446481,-0.4926001129135645},
{-0.5539303306677017,-0.6215483710321676,-0.5539303306677017},
{-0.6065378642516855,-0.5140268849564268,-0.6065378642516855},
{0.0974904850996285,0.9911638485112724,0.08994348625310605},
{0.19391991831076685,0.9653035933635339,0.17488292633014563},
{0.27649011153046543,0.9279103743000983,0.2500711008735759},
{0.3610920203552994,0.8748480493164982,0.32288301820140053},
{0.4452002941027504,0.8026925302648807,0.3968392621550795},
{0.5197882137450142,0.7184232954268555,0.46226419009023917},
{0.5852398033301971,0.6225917907780638,0.5194938254241293},
{0.6415069328772087,0.5150159461123394,0.5685309405129052},
{0.6869922378583941,0.39788713776108436,0.6080522105268654},
{0.7251470859578529,0.26482503139196384,0.6356330753469958},
{0.7433069482279295,0.1300769909400078,0.6561819542962722},
{0.7471121062652655,-0.009712151381404927,0.6646270945330346},
{0.7416682891720723,-0.15191205922961196,0.6533382547327151},
{0.7214239442768561,-0.2771119785957331,0.6346309509807899},
{0.6891147836727766,-0.39824587498247543,0.6054098099494796},
{0.6441511689934034,-0.5152531351769354,0.5653171483112559},
{0.5882408914383889,-0.6227278850737112,0.5159289047837816},
{0.5229800968993302,-0.7184851331230933,0.45855308496209907},
{0.4512531951433583,-0.7974703448641316,0.4005141732013903},
{0.37933385812954296,-0.863748676958919,0.33172887593375533},
{0.28988708372621425,-0.9229402665668766,0.2532720731509372},
{0.1968159434964141,-0.9652997228735903,0.1716389507244382},
{0.10021799951098428,-0.9911619951636053,0.08691519957589555},
{3.685498331253158e-05,-0.9999995472129043,-0.0009509025694433923},
{-0.10017603761049731,-0.9910013720655692,-0.08877523333013318},
{-0.19680606820384358,-0.9649763344159841,-0.1734590601128548},
{-0.2899160610068982,-0.9224391941084388,-0.25505805367174433},
{-0.3794131265033766,-0.8630372877526459,-0.33348511119012403},
{-0.46201394988327044,-0.7885829144588672,-0.4058079559801872},
{-0.5350067322126123,-0.7022376485083756,-0.4697127648942589},
{-0.5987540460112564,-0.6044250464470444,-0.5255130403830511},
{-0.653162976609581,-0.4948819822777816,-0.5731229794758933},
{-0.6979276479898107,-0.4754947601771458,-0.5355387298930766},
{-0.7226450993156521,-0.49488206801337936,-0.4825720663215726},
{-0.7428540442689023,-0.5140270306324137,-0.42888702555866526},
{-0.779242845422781,-0.4948819018310292,-0.384541923719003},
{-0.812753806866555,-0.47549488700887665,-0.33665392000144345},
{-0.822920189539526,-0.49488211398398346,-0.27909506428271763},
{-0.8285460899349545,-0.5140270557953268,-0.2220080240979733},
{-0.8522172351855706,-0.4948821365721472,-0.1697570468476889},
{-0.12760597731127643,0.9183068367223041,0.3747389333702994},
{-0.0903044907887505,0.8801219102256994,0.4660799524588568},
{-0.23600206995184989,0.869017257579795,0.43487012889704735},
{-0.21004804542699068,0.8371941810595865,0.5049611092076984},
{-0.04250640445528862,0.791671082978629,0.6094670638810011},
{-0.17282299399837603,0.9234449679315272,0.34260998810218324},
{-0.25828899374811504,0.8759169787984299,0.4074999901364629},
{-0.3658541155254065,0.8037652538041905,0.46916114814657},
{-0.35774607521146956,0.7978171677307055,0.4852891020257357},
{-0.3469039747228428,0.7656669442096801,0.5416749605308554},
{-0.1776390104648032,0.7514870442704789,0.6353830374307335},
{0.009107098409557375,0.6252568908065811,0.7803658637187085},
{-0.19635189763549918,0.9133055238647286,0.3568178139795039},
{-0.2684419708245202,0.8683139056277425,0.4170969546680285},
{-0.36092922254018445,0.7947924900497281,0.48788830082006573},
{-0.46497300391739754,0.6913610058247164,0.5530100046591092},
{-0.4865711831841102,0.6976302626435419,0.525890197986916},
{-0.4941457890294418,0.6894197056592136,0.5296417738747892},
{-0.49734183965975215,0.6541907890925216,0.569811816295834},
{-0.32855400665716133,0.6779720137370691,0.6575760133238053},
{-0.13655201486853524,0.5898950642310224,0.7958500866565393},
{-0.21510091828726358,0.9016556574782123,0.3751648574820259},
{-0.20019295947684515,0.9104938156974053,0.36183392675740306},
{-0.27427485783322986,0.8429675630588356,0.4627947601164146},
{-0.269648996444678,0.8550799887257703,0.44286299416085145},
{-0.2330580094402479,0.8938300362054802,0.3830820155171204},
{-0.28581686917550386,0.8326726188679271,0.474304782900553},
{-0.3378099619610803,0.7562149148468025,0.5603779368989262},
{-0.33648008992011,0.7667942049161937,0.5466331460808949},
{-0.34615312672287524,0.7799472855301741,0.5214021908796417},
{-0.2548901253335837,0.8871084362055192,0.3847981892114729},
{-0.3057840133277494,0.8241780359222126,0.4766830207764683},
{-0.3528949406780126,0.7479438742698975,0.5621789054971718},
{-0.398470905822608,0.6583028444121161,0.6386378490598782},
{-0.3919012015981449,0.6633233412205793,0.6375073279405478},
{-0.40445708219984344,0.6702001362081385,0.62229112647135},
{-0.43168630046564105,0.6797754731425878,0.5929184126876641},
{-0.2721920392364853,0.8805301269284269,0.38804405593655467},
{-0.32324892882010886,0.8156788203863201,0.47976889435418146},
{-0.36854713730778976,0.7390692753513958,0.5638702100783439},
{-0.4095662074738015,0.651149329852474,0.6389523236738411},
{-0.447377019439203,0.552238023995571,0.7034820305673501},
{-0.4442380987896794,0.5551361234511848,0.7031901563754444},
{-0.4500429486021729,0.5527099368769361,0.7014079198946609},
{-0.47906205256628426,0.5497260603200697,0.6843250750892838},
{-0.5247526956293566,0.5483136819633523,0.6511426223198078},
{-0.21412100579004623,0.932851025225225,0.2897260078344811},
{-0.2774360125767296,0.8741980396291464,0.39850601806507524},
{-0.3282628993884216,0.8068807526935079,0.4911078494769406},
{-0.3721420747786081,0.7287551464368026,0.574827115506347},
{-0.40999301764056495,0.6406730275659187,0.6491870279322463},
{-0.44242695675409444,0.5431659469071608,0.7136029302474578},
{-0.47048310498619944,0.4339980968447331,0.7683041714436376},
{-0.48327518656117263,0.43991916982422946,0.7569122921946931},
{-0.4914088843474241,0.43656389725513545,0.7536108226384673},
{-0.5117608536310433,0.4238758787670653,0.7472817862695932},
{-0.5555828526700031,0.4072318920098539,0.7249068077685131},
{-0.614044745717676,0.3907638381806251,0.685749716023901},
{-0.5758318119042815,0.5490808206425047,0.6057458021328631},
{-0.6132010888715468,0.5466430792252606,0.5702330826441717},
{-0.6374061864410181,0.529926155003158,0.5593671636146395},
{-0.6880692234095764,0.45523314780990237,0.5650871834784699},
{-0.49923807882820115,0.5587610882267064,0.6622291045639971},
{-0.29645815725375135,0.5191072753561148,0.801648425227706},
{-0.219711910517509,0.9288516217048194,0.29826387852549835},
{-0.27101007708814984,0.8691222472196856,0.41373911768707444},
{-0.3209450266816054,0.7993050664498298,0.5080410422357398},
{-0.3635160070891075,0.719070014022944,0.5922790115503292},
{-0.3992070371889317,0.629521058644296,0.6665860620971606},
{-0.42827390123876496,0.5312568774905844,0.7309908314313407},
{-0.4512848409358858,0.4227948509777365,0.7858667230059979},
{-0.46937703613029874,0.299825023079032,0.830536063930516},
{-0.4949279257642812,0.3078289538278152,0.8125808781185655},
{-0.5170661160190496,0.3087670692810084,0.7983141791253564},
{-0.5379260466863347,0.2983990258979034,0.7884120684258922},
{-0.571672911192621,0.27592995713525026,0.7726918799650303},
{-0.6244559919844829,0.24750999682296168,0.7408059904910143},
{-0.6860105921304656,0.2194268695391352,0.6937155875494387},
{-0.6743620745062237,0.37741204169799436,0.634662070120008},
{-0.7321837524556709,0.34750988251022996,0.585784801951757},
{-0.7676103063533344,0.32376812921588616,0.5531262207527188},
{-0.8187348998503062,0.2601119681824557,0.5118739373863042},
{-0.8511528742085517,0.1781209736755923,0.4937729270255514},
{-0.7073392390032496,0.33820311427563865,0.6207172097344837},
{-0.47787696282427994,0.4001429688714792,0.7819969391657235},
{-0.2147439744607154,0.9257908898966218,0.3111209629986972},
{-0.2527730480453361,0.8657031645468132,0.4320460821203027},
{-0.3008030293995871,0.7937940775830555,0.5285910516629061},
{-0.3417791155018791,0.7114432404273036,0.6140322075079213},
{-0.3758869048784478,0.6198568431396669,0.6888298256854353},
{-0.4031228089418041,0.5196007537376194,0.7533306429624164},
{-0.4235411305205726,0.4102451264232089,0.8076582488920426},
{-0.4382071558795154,0.2890531028222771,0.8511303027649764},
{-0.4478750436763285,0.15322401494225343,0.8808690859014766},
{-0.4827547788959481,0.15837692746259194,0.8613156055132364},
{-0.5149007869531498,0.15941093404166734,0.8422976514884689},
{-0.546305039888464,0.15246401113216018,0.8235930601346495},
{-0.579028806829653,0.13394095531583142,0.8042297317001597},
{-0.6224991489783817,0.10345702475964849,0.7757521856553625},
{-0.6774340614328364,0.0682109061856787,0.732414066418676},
{-0.7341587893256625,0.03550618981113742,0.6780488054269934},
{-0.7445260129886286,0.1965370034286863,0.6380080111303688},
{-0.8004258167901555,0.14857596599237674,0.5807268670771522},
{-0.8293912897126486,0.15789805515498456,0.5358901871904943},
{-0.8649208419707599,0.11957297815288294,0.4874569109369996},
{-0.8996252373033159,0.06457871703458624,0.4318611139164066},
{-0.9313917165713831,-0.005019828472433225,0.3639838892373118},
{-0.9170132592823261,0.03331300941913815,0.3974631123813198},
{-0.8672112444531129,0.08794742479098594,0.4901121381548483},
{-0.6856726410391528,0.21049788980091033,0.6968096352087542},
{-0.19928589407000974,0.9238535089276456,0.32677182630513546},
{-0.22712306335893995,0.8637642409582975,0.44980712547956264},
{-0.27199998166053785,0.7904599467036352,0.5488069629969662},
{-0.31055202823880773,0.7064850642413962,0.63595305782785},
{-0.3427831620559199,0.6130102898098782,0.7118413365337489},
{-0.36850987814098934,0.5104938311896725,0.7769147430894867},
{-0.387382818918331,0.3995748132191968,0.8308276116305546},
{-0.40023106785798257,0.27918804733549984,0.8728511479893061},
{-0.4080119710236028,0.14743798952917553,0.9009929360128355},
{-0.4187738156790894,0.0013300794145731187,0.9080896003095328},
{-0.4593751690257464,-0.0018910006957881611,0.8882403268254238},
{-0.49720689357008346,-0.008454818190198877,0.8675908142873335},
{-0.5345471979185715,-0.020853307721033602,0.8448813128212124},
{-0.5669426945194527,-0.016767990965056778,0.8235865562343877},
{-0.6058551395298937,-0.05905451360039631,0.7933801827173614},
{-0.6528436147126216,-0.09340744487391966,0.7517115563639312},
{-0.7037480510607936,-0.12793300928224377,0.6988360507044009},
{-0.7514632117961788,-0.15715404429308785,0.6407851806021247},
{-0.7840957834204604,0.010027097230358653,0.6205588285919293},
{-0.822593885045223,-0.022777896816864193,0.568172920599712},
{-0.8569400234737771,-0.034621700948376855,0.5142520140866768},
{-0.8886810198103487,-0.04663730103963196,0.4561480101683854},
{-0.9161512140367273,-0.0797897186409514,0.39281109177087714},
{-0.9391429611730132,-0.12470099484448686,0.32009398676635453},
{-0.9572018046169447,-0.17263496476192722,0.23229695258378316},
{-0.9593713290952133,-0.07728912651265553,0.271354093083179},
{-0.9481161937576662,-0.03440370703076483,0.31605706458963534},
{-0.9328546868029349,-0.05233018243064029,0.3564318803313953},
{-0.8331641178158258,0.012206901726149957,0.5528910781830585},
{-0.1776739533782719,0.9228017578563891,0.341860910295538},
{-0.19204306515311745,0.8740912965468858,0.44618815137515644},
{-0.23351088739138653,0.8020486132189669,0.5497187349028766},
{-0.2697269965233539,0.7100849908473595,0.6504049916166049},
{-0.3041421209016875,0.6087712419969659,0.7327312912732027},
{-0.32784099866142524,0.5040659979418985,0.7990229967375891},
{-0.3450170599932967,0.39132106804486977,0.8531301483465488},
{-0.3562469120544044,0.2710499330867244,0.8942147792479073},
{-0.3625489257715593,0.1420479709170304,0.9210758114184971},
{-0.37298910979901656,0.0025292107445387684,0.9278322731314895},
{-0.41023303164927455,-0.14396401110675192,0.9005460694766817},
{-0.45238502177894646,-0.15447100743662065,0.878343042285631},
{-0.49159909744330793,-0.16954603360690945,0.8541571693084884},
{-0.5304742097824334,-0.18972807503025885,0.8261963267293164},
{-0.5716022377597151,-0.2073210862358457,0.7939073302282044},
{-0.6133306851437068,-0.23427487973384994,0.7542816127858619},
{-0.6554150497895892,-0.2762590209864317,0.7029310533992138},
{-0.6996450360660028,-0.3042140156819287,0.6464910333259671},
{-0.738965034921641,-0.326178015414358,0.5895240278594325},
{-0.7910185335198969,-0.17925989428670705,0.5849406550483137},
{-0.8231292843603495,-0.19570306760808265,0.533065184154063},
{-0.8475114976067746,-0.22596986604815372,0.4802727153009025},
{-0.8741165036131904,-0.22166112770776808,0.43218824900079345},
{-0.8975669581688929,-0.2431949886658978,0.3677359828616649},
{-0.9161014821678289,-0.2720298462334047,0.2945468335055349},
{-0.9286236752622148,-0.3040558936722807,0.21262192564655086},
{-0.9320660553665894,-0.3450620204973747,0.11038600655714975},
{-0.9694934254443476,-0.20969809202214845,0.1269220556974083},
{-0.9802972117138313,-0.1294270279522288,0.14921803222647267},
{-0.9803876982848696,-0.09557237058752338,0.17235394695792933},
{-0.9748192397616956,-0.11492702826688071,0.19110004700201783},
{-0.9169062169982601,-0.10836602564628595,0.3841090909046126},
{-0.15249501800036047,0.9274241094722209,0.34151104031162405},
{-0.3629359070519447,-0.1372359648538053,0.9216527639642966},
{-0.4040808295793502,-0.2760958835568618,0.8720606322093781},
{-0.44636108260068824,-0.28977405362370773,0.8466361566729985},
{-0.48529506302090625,-0.3086180400774499,0.8180731062357985},
{-0.5232799865137667,-0.3321309914401541,0.7847719797744644},
{-0.5612769843305501,-0.35889098998066093,0.7457649791801064},
{-0.5998379208561903,-0.3666339516255864,0.7111779061657708},
{-0.640394190833655,-0.4136701232712331,0.6471261928397515},
{-0.6788329350156657,-0.43428095842650294,0.5921029433182841},
{-0.7125110225313802,-0.44982501422459176,0.538503017028812},
{-0.7703432145151938,-0.343499095653176,0.537196149591421},
{-0.7957978107258796,-0.3587839146661263,0.48783188397310284},
{-0.8186039696068723,-0.37423198610551506,0.43570398382318276},
{-0.838840182650759,-0.39145008523513375,0.37830408237269647},
{-0.8558774133043652,-0.4113757180059501,0.3134387851407641},
{-0.8681271603044697,-0.43347608004374966,0.2417720446445419},
{-0.8752808851395228,-0.45432694038004257,0.16574197825017886},
{-0.8730871518781462,-0.47900008332460803,0.09098211582682217},
{-0.9649876263911205,-0.16778893503809345,0.20160792194458485},
{0.29309711209413264,0.9230243530079622,0.2492390953207625},
{0.3873529794249723,0.8639119541115899,0.3218909829021171},
{0.474376171292997,0.7895692851064141,0.3892911405695526},
{0.5516471916149611,0.7031672442455362,0.44859915582116816},
{0.6194590242251845,0.60516402366615,0.5000470195553391},
{0.6775791487960586,0.49536610878216175,0.5435981193738884},
{0.7237651198623896,0.3773700624960725,0.5777160956752817},
{0.7620189650362846,0.2547169883128207,0.5953539726833743},
{0.7778372318476448,0.1287840383862777,0.6151291833497377},
{0.7855826849574208,-0.002208429114352674,0.6187527518613043},
{0.7800917495714763,-0.13295295731885018,0.6113758037334197},
{0.761844915827569,-0.2588869713968745,0.5937759343966694},
{0.7309650522574244,-0.38028702718710083,0.5666320405090927},
{0.6868288734497312,-0.4972569083789313,0.5300959023282487},
{0.630259844059553,-0.6061378500278763,0.4851488799632661},
{0.5634139773890707,-0.7034979717672201,0.4331919826151398},
{0.47911573409251823,-0.7952285586510557,0.37156379378345217},
{0.38430186277639755,-0.874845687616719,0.2948848947047322},
{0.2944470119907659,-0.9279230377878106,0.22860400930944125},
{0.20759805493398176,-0.9652992554346268,0.15843104192355253},
{0.10567599176903261,-0.9911619227996696,0.08019119375401082},
{-2.6351088097572073e-05,-0.9999995483138113,-0.0009500935708556622},
{-0.10575703436441661,-0.9910013220134006,-0.08204772666037562},
{-0.2077089824193048,-0.9649759183234768,-0.1602449864367047},
{-0.30594700558521565,-0.9224380168395674,-0.2355940043008864},
{-0.40860316664454516,-0.8581263499778928,-0.31090612679982516},
{-0.5013960500503589,-0.7749720773592665,-0.38473403840492315},
{-0.5766981226089174,-0.6867311460024907,-0.44251509408093154},
{-0.6422777931178603,-0.5870188109171623,-0.4928368412538292},
{-0.662575891562176,-0.6044249010792244,-0.4423389276063747},
{-0.6784232806715712,-0.621548257141715,-0.3916881620459306},
{-0.7143648239469539,-0.604424851041327,-0.35263791309345494},
{-0.7479480923098895,-0.5870190724484309,-0.3098100382359828},
{-0.7544847720513228,-0.6044248173881798,-0.25577992272250255},
{-0.7566830537994103,-0.6215480441914459,-0.20275301441553706},
{-0.7812928137261427,-0.604424855894554,-0.15573096287101756},
{0.6369961920553363,0.6044901822547241,0.4783591442260212},
{0.6984198124757023,0.49423586729867586,0.5176298610174362},
{0.7473540331025529,0.3757930166450005,0.5479430242700409},
{0.7868711456459282,0.2517880466047128,0.5634151042853284},
{0.8055068329503855,0.12525397402426994,0.5791978798833497},
{0.8145172424460337,-0.007476172225328341,0.5800911726676817},
{0.8097851678178711,-0.13952202891419946,0.569896118103859},
{0.7919029101134815,-0.2655739698554971,0.549872937585576},
{0.7610582774955976,-0.38588214069960003,0.5214261901214092},
{0.7166062204779114,-0.5007451540640349,0.48552014937976457},
{0.6588857803518963,-0.6077667973930709,0.4432708522299236},
{0.5898478699134906,-0.7040588447251194,0.39544991278649727},
{0.5097922351628791,-0.7896273642484752,0.3414681575163949},
{0.41860389379643814,-0.8637487808591884,0.2805509288217134},
{0.31770401679621757,-0.9229320487931114,0.2173950114931311},
{0.21749392409767865,-0.9652996631239906,0.14454394955619404},
{0.11068400798390123,-0.9911620714948818,0.07312180527445003},
{-8.743386040142604e-05,-0.9999995471027376,-0.0009477075707856413},
{-0.11088504401956599,-0.9910013934114977,-0.07497162976252238},
{-0.21772207762185353,-0.9649763440314976,-0.1463480521757242},
{-0.32066703218936,-0.922439092596747,-0.21512502159478858},
{-0.4230218068836094,-0.8630246060151174,-0.27611787394766335},
{-0.5115581348331858,-0.7885832078496636,-0.34124008994185673},
{-0.5921768872430174,-0.7022378662861984,-0.3952069247482614},
{0.7133068133097987,0.4921508711918301,0.4989798694045108},
{0.7218030395266574,0.4860900266187767,0.4926630269787208},
{0.7649561525047336,0.3727940743217253,0.5252301047119851},
{0.7428260012891745,0.44893800077913193,0.4966530008619413},
{0.7672269380337681,0.38375996900505177,0.5138979584942622},
{0.8390616316125887,0.29989486833208673,0.4539148007101123},
{0.8137978526090153,0.3231049414808538,0.4830489125126041},
{0.7798782066408463,0.3652070967672938,0.5083441346936757},
{0.8059709595027812,0.24642598761795692,0.5382239729561299},
{0.8167428302620724,0.262993945343815,0.513580893266089},
{0.7938730917169575,0.20740302396148014,0.5716200660398417},
{0.9226863228383126,0.12507504376245218,0.36470012760476767},
{0.8911797863160554,0.2104679495347377,0.40187290364033323},
{0.921054672043345,0.14960194673176794,0.3595518719756462},
{0.8825682389492051,0.19167105189360265,0.42934311624165905},
{0.8568700754019994,0.20700901821617337,0.47214504154734904},
{0.8268701819147676,0.23579605187608033,0.5105741123283594},
{0.8491374687027837,0.1072160591806006,0.517175285467907},
{0.8272530220405024,0.11831200315218673,0.549231014633162},
{0.8374368882320962,-0.017866597615447573,0.5462419270962194},
{0.8331891614266663,-0.15259202956402196,0.5315181029792507},
{0.8154753476033725,-0.27897311891468857,0.5071232161656275},
{0.784863911791897,-0.39720095535997735,0.47562594654606755},
{0.7409867506498495,-0.5079378290733619,0.4392468521886274},
{0.6833671202422139,-0.6111701075387513,0.39935007026784747},
{0.6132316492628719,-0.7052545966304541,0.3557567965253142},
{0.5377279916286507,-0.7818039878288757,0.31564399508605434},
{0.4530937478089963,-0.8522175256575617,0.26159385439742433},
{0.3401029006399724,-0.9192817314346393,0.19811894212015388},
{0.22649988772573224,-0.9653005215078898,0.1299719355739023},
{0.11523904426181807,-0.9911623806925791,0.06570462523629199},
{-0.00014687793297048964,-0.999999543638187,-0.0009440075691907976},
{-0.11555695422025193,-0.9910016073987564,-0.06754557324073356},
{-0.22684103078618625,-0.9649771309638101,-0.13176601788288986},
{-0.334071954402355,-0.9224408740955924,-0.19364597356916605},
{-0.4288069558633311,-0.8697719104752517,-0.24417497486731532},
{-0.5175069770904841,-0.8018199645042327,-0.2987829867731762},
{-0.6033092141497717,-0.7174192546541077,-0.3483211236395655},
{0.884853160481408,-0.05618101018926984,0.4624700838758944},
{0.8760741722408598,0.09124061793839265,0.4734650930857653},
{0.906799611636145,0.06901157044374612,0.4158748218892609},
{0.9122819486826093,-0.08112439543661659,0.4014479774178775},
{0.8973562139135944,-0.22956405472394498,0.37689808984573114},
{0.8756557342726755,-0.20034493920313362,0.4394188666535316},
{0.8594368479544623,-0.0345089938949109,0.5100759097609484},
{0.8539496338896677,-0.17359392557578662,0.4905457896903108},
{0.8346211528333357,-0.30052205503070223,0.4616210845306759},
{0.8030756872402269,-0.4154768381915382,0.42713983364935637},
{0.7598123850771933,-0.5197582634164133,0.3905591979375997},
{0.7032938984721485,-0.6168419109523997,0.35338894898459833},
{0.6331783554170407,-0.7072863970155264,0.314374176465191},
{0.5466220387825618,-0.7902010560643719,0.27710401966039233},
{0.45226705069868695,-0.8637480968253033,0.22224702491367065},
{0.3455619570742963,-0.9229398853524146,0.16961397893055283},
{0.2345329331241163,-0.9652997247496492,0.1148509672508256},
{0.11929801023194682,-0.9911620850099488,0.05801470497580283},
{-0.00021049690468969088,-0.9999995472129811,-0.0009280435797937239},
{-0.11973904924138656,-0.9910014075385909,-0.05982282460148841},
{-0.23499411914992094,-0.9649764892755308,-0.11661105912572846},
{-0.34605199879124043,-0.9224389967779207,-0.17133099940154084},
{-0.452797113990103,-0.8630372172666262,-0.2239230563718528},
{-0.5513011833355146,-0.7885832622438017,-0.27240309058779905},
{-0.6383469688177088,-0.7022379656967296,-0.3152379846010977},
{-0.6715779015342626,-0.6867318993124063,-0.27817695921411445},
{-0.6742860909716513,-0.7022380947428101,-0.22847303082455528},
{-0.6729042196383282,-0.7174192341681873,-0.18030405885188547},
{-0.6981858118106725,-0.7022378107184949,-0.13927896245868385},
{0.9391699044191057,0.04145439578111671,0.3409419653017652},
{0.9396611119653264,-0.10738801279581943,0.3248150387033383},
{0.9179108774469732,-0.25766296559864676,0.3017439597132614},
{0.8825052742553242,-0.3814691185487949,0.27507408548451173},
{0.8681366672385046,-0.3558808635889338,0.3459588673920888},
{0.8522096153855304,-0.32749985219460137,0.4080228158534285},
{-0.7780371574797939,-0.49195709957532474,0.3906870790776123},
{-0.7934539325294412,-0.5079839568040941,0.3352359714935456},
{-0.7403378634350692,-0.5739208941328399,0.3500209354340941},
{-0.7524926954579904,-0.587721762142586,0.29721687971308375},
{-0.8062231527010982,-0.5244920993403864,0.27370105183980525},
{-0.7599941831867401,-0.47694711496191566,0.4415091064200433},
{-0.7251961055635414,-0.560842081639264,0.3994330581436771},
{-0.6942618051884292,-0.6205198258806099,0.3646308976836729},
{-0.7091081809484759,-0.629755160699368,0.31713408092549233},
{-0.7206533355431173,-0.6396462978254622,0.267416124511517},
{-0.7623064362452291,-0.6010203439460107,0.2401321374204576},
{-0.8152321130445764,-0.5405090749499664,0.20795802883660605},
{-0.6752963534312956,-0.6127823207131927,0.41045421482029953},
{-0.637960882736102,-0.6712118766242208,0.377465930617805},
{-0.657740582026054,-0.6751865709396637,0.33391678780613326},
{-0.6735939123341156,-0.6801559114800944,0.2892389623565638},
{-0.6860707052088597,-0.6857437053493651,0.24302789557567475},
{-0.7297568023534242,-0.6490548242106644,0.21490194179618088},
{-0.7693737732755844,-0.6126868194491859,0.18077294672857053},
{-0.8202542024699319,-0.5544681368638228,0.14052803468766328},
{-0.7063293258799426,-0.5494362534940123,0.4463392059280133},
{-0.739009949361562,-0.4630999682674651,0.4892879664730111},
{-0.6820269394022502,-0.5397989520391352,0.4934129561605075},
{-0.6513577439031207,-0.606629761488997,0.4557778208000463},
{-0.6141032446111884,-0.668025266089547,0.4202611673995122},
{-0.5616819229223609,-0.7353268990936701,0.37921994796097735},
{-0.5843249475892682,-0.7367919339138188,0.3401499694904199},
{-0.6038300154625773,-0.7384060189087324,0.3002430076884729},
{-0.619965838464822,-0.7404648070682174,0.25952693237896896},
{-0.6329940556677152,-0.742914065334466,0.217709019146094},
{-0.6958397305917837,-0.6912477323696673,0.19489392454293386},
{-0.7364645943241134,-0.6570056380934713,0.1611319112417196},
{-0.7735020129805242,-0.6221270104402246,0.12104800203136708},
{-0.8224939538287233,-0.5643409683203228,0.07087289602150013},
{-0.6516417049842727,-0.5293067603685925,0.5433207540240808},
{-0.6226688952481093,-0.6000638990509588,0.5022019155143278},
{-0.5868121601008637,-0.6643131812455865,0.4629681263123056},
{-0.5365928965196796,-0.7333008585851428,0.4175379194790726},
{-0.47155966051772075,-0.8033474216591524,0.3636817381805194},
{-0.49355307391796877,-0.804464120482187,0.3305190495008502},
{-0.5137861225048657,-0.8050971919637745,0.29638207066801564},
{-0.5317400894884083,-0.8055371355666754,0.2614620440023663},
{-0.5470509942958993,-0.8060429915953897,0.2258979976445616},
{-0.5597541924278513,-0.8067042773223905,0.18948206513863972},
{-0.6433309322926396,-0.7454249215477582,0.17454798162969865},
{-0.7031079295468312,-0.6959499302640806,0.14592098537835319},
{-0.7406739639706567,-0.6632239677381341,0.10740599477534292},
{-0.7754539956678643,-0.6284949964888625,0.060540399661786225},
{-0.8140961505605843,-0.5807301074013974,-6.218271150019609e-10},
{-0.6173521296013635,-0.5150471081243658,0.5946451248344587},
{-0.5909750804609673,-0.5909260804542958,0.5491400747651516},
{-0.5572132858666481,-0.6588673380181382,0.5053782592737694},
{-0.5096546519459995,-0.7301725013496705,0.45508268921435346},
{-0.4480042510356684,-0.801592449166042,0.3959062218429463},
{-0.372535976973552,-0.8686179463107264,0.32667997980791114},
{-0.39211314888009735,-0.8694773301288671,0.3004271140681411},
{-0.41035317688893036,-0.8700193750349827,0.2732701177972087},
{-0.4272589176112436,-0.8702548321879067,0.24516595272440872},
{-0.4425019009579081,-0.8702788052116087,0.216348951576134},
{-0.4557489749278823,-0.8702519521248306,0.18696098971471534},
{-0.4669329164456306,-0.8702658442720329,0.15687897192760863},
{-0.5700208830254566,-0.8074338343057125,0.15207496879254678},
{-0.651176748535449,-0.7475767113087309,0.13075894950489156},
{-0.7079131826522433,-0.6996001805073638,0.09704902504010741},
{-0.7428641338578146,-0.6673001202418205,0.05351100964222997},
{-0.7691437590611404,-0.6390757998057026,-3.107129026673342e-10},
{-0.7754539956678643,-0.6284949964888625,-0.060540399661786225},
{-0.8224939538287233,-0.5643409683203228,-0.07087289602150013},
{-0.8202542024699319,-0.5544681368638228,-0.14052803468766328},
{-0.7735020129805242,-0.6221270104402246,-0.12104800203136708},
{-0.5823252306442203,-0.4794851899118945,0.6564992600226678},
{-0.5601878654863054,-0.565189864285213,0.6055988545821065},
{-0.5313170876309316,-0.6380481052342397,0.557312091918327},
{-0.4889592078304441,-0.7128013029737634,0.5028252137241426},
{-0.433074936508404,-0.786867884640062,0.4396419355456393},
{-0.3639079155107813,-0.8564458011572886,0.36615791498839445},
{-0.2775968928212484,-0.9204496446190632,0.27515889376254743},
{-0.28975307951738316,-0.9244482536977559,0.24786806802281505},
{-0.30486703323005115,-0.9247171007927825,0.22793502484457717},
{-0.3188999980462592,-0.924861994333833,0.20720299873057083},
{-0.3318900793009953,-0.9248752209873995,0.18562004435159465},
{-0.34358604124046316,-0.9247881110018612,0.16344901961870528},
{-0.35378299165266736,-0.9246739781827801,0.14076799667864956},
{-0.362414151598415,-0.9245763867517703,0.11753504916509766},
{-0.46912718129657993,-0.8746443380107429,0.12213504719970879},
{-0.5723500701867211,-0.8125410996411087,0.11041901354057405},
{-0.6565987669074004,-0.7492087340308567,0.08697316912452001},
{-0.7106010116929397,-0.701940011550423,0.04823300079367403},
{-0.739479764682417,-0.6731787857807443,-3.105899011639421e-10},
{-0.7428641338578146,-0.6673001202418205,-0.05351100964222997},
{-0.7406739639706567,-0.6632239677381341,-0.10740599477534292},
{-0.5453497827760452,-0.4715788121605292,0.692969723976008},
{-0.5096546775627381,-0.4483537163453,0.7343235354241204},
{-0.5242329938976659,-0.560435993476245,0.6411639925365306},
{-0.4899429054346591,-0.5439238950156273,0.6812508685097388},
{-0.47300764857815203,-0.4270436827271597,0.7706474274461652},
{-0.45401199991464575,-0.5286939999006055,0.717185999865169},
{-0.46074212865857145,-0.6305741760828186,0.624574174407366},
{-0.4940209510778487,-0.6403799365841386,0.588095941761744},
{-0.4345539394740279,-0.4095089429623699,0.8021628882723542},
{-0.4157439005037659,-0.5162588764484243,0.748754820807269},
{-0.42554017497449614,-0.62169425562954,0.6575802703852264},
{-0.4198928611049231,-0.7143337637077163,0.5598368148132902},
{-0.4512031843451899,-0.7196802940351599,0.5277082156023596},
{-0.3567230243340403,-0.26692201820821954,0.8952660610710241},
{-0.345404941664219,-0.3880509344616952,0.8544658556884194},
{-0.3923772490784101,-0.39668625181373574,0.8298675267942641},
{-0.37383606604001607,-0.5073870896324743,0.7764051371558617},
{-0.3278008608869168,-0.5016177871219838,0.8005786602480985},
{-0.29810291402444905,-0.6141798228650369,0.7306967892605001},
{-0.34717802435731665,-0.6099360427918944,0.7123520499771968},
{-0.3879340663776581,-0.6146681051731024,0.6867971175147742},
{-0.386598094966094,-0.7096391743196913,0.5890281446921308},
{-0.3676719177501467,-0.7933928225144752,0.4851238914756146},
{-0.39589089778672376,-0.7960387944743523,0.45781288179936747},
{0.8178593418971729,-0.4381551831659929,0.3729961559269726},
{0.7744290642725813,-0.5345740443661728,0.33836402808201615},
{0.7192699738250469,-0.624048977290234,0.3053089888895008},
{0.6498008964119983,-0.7099248868273332,0.27159795670321524},
{0.557664629843254,-0.7962454714822907,0.2345278443292634},
{0.44752919490012566,-0.8748453809974335,0.1853730807304577},
{0.3435819003803321,-0.9279227309539467,0.14460595807230386},
{0.24152908399827486,-0.9652993357089654,0.09930203453496968},
{0.1228299962747327,-0.991161969939401,0.05010729848031356},
{-0.0002712848774772123,-0.9999995483613627,-0.0009108685886163662},
{-0.12338904065854396,-0.9910013265498361,-0.051879817095179706},
{-0.24210596991978775,-0.9649758801075442,-0.101025987448128},
{-0.35649806969377523,-0.922438180332531,-0.14838102900782632},
{-0.47514909041113995,-0.858126163283833,-0.19455803702040955},
{-0.5838879548526172,-0.7749719400776219,-0.2418539812993672},
{-0.582447048279329,-0.7885830653660473,-0.1972110163469204},
{-0.5772040591816011,-0.80182008221182,-0.15466101585762676},
{-0.6030192503317348,-0.788583327365059,-0.12043304999544263},
{0.8299201687709228,-0.4614720938440516,0.31349006375071886},
{0.7858131780994693,-0.5498201246131715,0.2831880641827413},
{0.7320162405841312,-0.6315562075669815,0.25551708397813083},
{0.6634739643697903,-0.7127249617248888,0.22765198777451942},
{0.5787083031989592,-0.7913004145809913,0.19733310338747728},
{0.4769519421681497,-0.8637488952678617,0.1626489802783244},
{0.36314493004939613,-0.9229318222207363,0.127759975390301},
{0.24749298795637273,-0.9652999530260922,0.0833259959451488},
{0.12583702519787524,-0.9911621984724398,0.041982608406687355},
{-0.00032977085064510113,-0.9999995470951089,-0.0008927825956542125},
{-0.1265110461827134,-0.991001361763919,-0.04371791595917545},
{-0.24818107526558336,-0.9649762926472274,-0.08501122578125464},
{-0.36541903758663874,-0.9224390948811678,-0.12480001283680518},
{-0.4800719165783903,-0.8630248500330479,-0.15722297267952362},
{0.7951942674532992,-0.5629211893312559,0.22535707579593556},
{0.8403087064054326,-0.48164083172002087,0.24880391307066482},
{0.8491784845734425,-0.4955696992036554,0.18250088922728638},
{0.8033060531563699,-0.571734037832786,0.1667920110369613},
{0.7509553497793134,-0.6425112992683403,0.15246407101457907},
{0.7423849830639716,-0.6380799854434814,0.2042509953404221},
{-0.32843399489679265,-0.8660039865440302,0.3770519941413662},
{-0.3044731165226452,-0.8648653309861877,0.39912915274775385},
{-0.3375970293407279,-0.7911710687610761,0.5099770443223619},
{-0.27895208878084016,-0.8639492749652917,0.41925813343542073},
{-0.2338489399763633,-0.9231117630584723,0.30525292164860585},
{-0.2526800555608128,-0.9234782030599505,0.2886880634784705},
{-0.35103280793701513,-0.7061026136652401,0.6149756635241524},
{-0.29985287425822277,-0.7951546665559361,0.5270837789700991},
{-0.24269103931036964,-0.8745131416510267,0.4199140680164265},
{-0.2138499931412962,-0.9228289704025683,0.32039798972403566},
{-0.1593670017567025,-0.9651370106387054,0.20763600228877166},
{-0.17251897620178525,-0.9651768668582038,0.196648972873161},
{-0.18492499995238185,-0.9652269997514542,0.18476899995242202},
{-0.1965129597399028,-0.9652758022415535,0.17211996473735613},
{-0.20722999348240956,-0.9653109696400052,0.15884099500429194},
{-0.2171370692088691,-0.9653203076799693,0.14494204619789305},
{-0.22628394472675897,-0.9652927642127916,0.13040496814663433},
{-0.23460295228059136,-0.9652238036686721,0.11534497653825744},
{-0.24194411077365258,-0.9651324418840593,0.09991204574454078},
{-0.2482509158607236,-0.9650396729206839,0.08408277150196394},
{-0.25346899183909827,-0.9649609689313017,0.06785129781540232},
{-0.3577940238241523,-0.929185061870923,0.09272840617443424},
{-0.3739271001394408,-0.9244812475804378,0.07424921988429123},
{-0.4730590341142537,-0.8763830631996263,0.09037630651741121},
{-0.488138164862972,-0.8703912939645082,0.06434382173137536},
{-0.5842970996009164,-0.8085021378195337,0.07015121195817162},
{-0.6597937971935903,-0.7502027694038185,0.04321978671516797},
{-0.7046615693884932,-0.7095435664051545,-3.1063981017117645e-10},
{-0.7106010116929397,-0.701940011550423,-0.04823300079367403},
{-0.7079131826522433,-0.6996001805073638,-0.09704902504010741},
{-0.30754803153074844,-0.710227072814614,0.6332390649215719},
{-0.26416016795348446,-0.7967015065441739,0.5435863456131238},
{-0.22416592367510266,-0.8631437061134285,0.4524738459399213},
{-0.17475897171517532,-0.9226238506728804,0.34383794434966125},
{-0.18901309086362347,-0.927677445959239,0.3220071547974097},
{-0.14546202652383927,-0.9651161759812299,0.2176960396951349},
{-0.08128841326872666,-0.9910291617659213,0.10608201731579242},
{-0.08820888128718422,-0.9910017897668165,0.10067097864344893},
{-0.09476727416382663,-0.9909747298329499,0.09480637415316691},
{-0.10092495752254074,-0.9909475829283796,0.08852706274058673},
{-0.10663798866605448,-0.9909198946807584,0.08189079129629338},
{-0.11192304109255824,-0.9908903638055184,0.07489672749834267},
{-0.1167959843492568,-0.9908568672244901,0.0675378909498756},
{-0.12123497320030836,-0.990816780974223,0.05986808676581335},
{-0.1251670519121093,-0.9907734109159464,0.05197362155567525},
{-0.12856700508155375,-0.9907310391582043,0.04384670173302141},
{-0.1313980395050729,-0.990694297854143,0.035487510669388225},
{-0.13361904630465896,-0.9906663433078476,0.02694710933831473},
{-0.25753788218185414,-0.9649045585765283,0.05131697652356627},
{-0.2604439663737223,-0.9648688754244561,0.03459759553305699},
{-0.3780029340324381,-0.9244578386673115,0.049914791289070046},
{-0.38047216038754794,-0.9244443896983389,0.025367410693599223},
{-0.49904510171452465,-0.866041176515041,0.030441206204474925},
{-0.5956521555900697,-0.8024912096184191,0.034732809072543655},
{-0.650584149175059,-0.7594341741337195,0.0},
{-0.6597937971935903,-0.7502027694038185,-0.04321978671516797},
{-0.6565987669074004,-0.7492087340308567,-0.08697316912452001},
{-0.26535096876792746,-0.7119009162085551,0.6502199234684692},
{-0.23642106191927528,-0.7886452065481783,0.5675771486498936},
{-0.19442793206912834,-0.8630916984457389,0.46612283714206965},
{-0.15194293117184304,-0.9226245820631532,0.3545098394116878},
{-0.11553202763497547,-0.965145230860354,0.23483405617172584},
{-0.13080305403351017,-0.9651193986817374,0.22679309368609182},
{-0.07401251832501148,-0.9910562453789911,0.11103902749253097},
{0.00018189498578304397,-0.9999999218397645,0.00035104797256200565},
{-4.805549369645858e-06,-0.9999998688278883,0.000512172932817186},
{-0.00019488795162475494,-0.9999997517792524,0.0006770968319304764},
{-0.0004016498316492648,-0.9999995808521469,0.0008227836551318528},
{-0.0006241692228251424,-0.999999356994531,0.0009467963380013321},
{-0.0008633800665821097,-0.9999990771178892,0.001048970080894433},
{-0.0011173497090612892,-0.99999873961747,0.0011279597062986276},
{-0.0013911104831315405,-0.9999983472986135,0.001170560406534678},
{-0.0016649598423597433,-0.9999979053190818,0.0011904898872830882},
{-0.001926170858232727,-0.9999974455630355,0.0011826805269600717},
{-0.002158630023536078,-0.9999970109032152,0.0011482600125197633},
{-0.002352909181321228,-0.9999966520579553,0.0010768896253035675},
{-0.0025035409618865767,-0.9999963842090517,0.0009817593772022033},
{-0.1352119669769149,-0.9906477580521462,0.018295995531532966},
{-0.13618505854654286,-0.9906374258792935,0.009545694103734985},
{-0.26220492083621794,-0.9648497086967253,0.017709294653285915},
{-0.28315596349949973,-0.9590738763696309,-3.110089599090816e-10},
{-0.4003570912153682,-0.916359208778724,-1.5549903542812676e-10},
{-0.492327137105988,-0.8704102423966653,0.0},
{-0.5738849525623848,-0.8189359323063491,0.0},
{-0.5956521555900697,-0.8024912096184191,-0.034732809072543655},
{-0.5842970996009164,-0.8085021378195337,-0.07015121195817162},
{-0.09980889907810465,-0.9651849910849676,0.24177699776680142},
{-0.05848608092984996,-0.9911066768367321,0.11952796102634823},
{-0.06637947410028587,-0.9910826133028063,0.11553795491979948},
{0.0003622679690092381,-0.9999999144534932,0.00019963698292175204},
{0.08165261229587349,-0.9910531492403463,-0.10557701589859275},
{0.08828216487389799,-0.9910696056687993,-0.0999364602368349},
{0.09456454082887865,-0.9910864279082534,-0.09383624051443007},
{0.10042995870076853,-0.991102592434609,-0.08734686408085392},
{0.10582698964358028,-0.9911189030073199,-0.08052309211986525},
{0.11075998978698795,-0.9911359086088488,-0.07336099323549317},
{0.11522695679598961,-0.9911536283698464,-0.0658576753068573},
{0.119186994556391,-0.9911709547304037,-0.05809129734680524},
{0.12261904457565481,-0.9911873603259655,-0.05012171822072923},
{0.1255320051314968,-0.9912020405183529,-0.04195510171504048},
{0.12792903032409367,-0.9912142349558443,-0.03359320796288053},
{0.12979398956172378,-0.9912229202839925,-0.02511259798039774},
{0.13111299273660199,-0.9912289450878954,-0.01656989908206067},
{0.13188795628372307,-0.9912326714407957,-0.007959777361610253},
{-0.0026127105451082657,-0.9999962086362763,0.0008697451814610839},
{-0.02559291146416286,-0.9996724477961707,0.0},
{-0.15820796993257816,-0.9874058123435432,0.0},
{-0.26220492083621794,-0.9648497086967253,-0.017709294653285915},
{-0.38047216038754794,-0.9244443896983389,-0.025367410693599223},
{-0.49904510171452465,-0.866041176515041,-0.030441206204474925},
{-0.488138164862972,-0.8703912939645082,-0.06434382173137536},
{-0.4730590341142537,-0.8763830631996263,-0.09037630651741121},
{-0.3780029340324381,-0.9244578386673115,-0.049914791289070046},
{-0.2604439663737223,-0.9648688754244561,-0.03459759553305699},
{-0.1352119669769149,-0.9906477580521462,-0.018295995531532966},
{-0.13361904630465896,-0.9906663433078476,-0.02694710933831473},
{-0.002352909181321228,-0.9999966520579553,-0.0010768896253035675},
{0.12979398956172378,-0.9912229202839925,0.02511259798039774},
{0.25944099992354797,-0.9651789997155812,0.03346439999013871},
{0.38268681386232706,-0.922539551279639,0.049714975818790794},
{0.5053603326257536,-0.852217560925522,0.13541108912693114},
{0.5981417943896907,-0.7842217304250029,0.164992943283933},
{0.6746215504067131,-0.7152055233600203,0.182665878264558},
{0.5972300193499543,-0.7921740256660427,0.12560500406953937},
{0.49437808304929326,-0.8637481450988129,0.09761891639874884},
{0.37979092881693227,-0.9192818277017811,0.10334298063073699},
{0.0005363219217176673,-0.9999998540385577,6.543439044910059e-05},
{0.0006723928467041798,-0.9999997720145508,-6.211848583788588e-05},
{0.06735331970752059,-0.9910252899731058,-0.11546603378525731},
{0.07467659906353454,-0.9910379875721061,-0.11075699861107623},
{0.16006606076573013,-0.9650193663494065,-0.2076450788281086},
{0.17323298952616054,-0.9650369416529032,-0.19670798810683868},
{0.18571804328939517,-0.9650542249464455,-0.18487604309313166},
{0.19740200779649117,-0.965069038115885,-0.17226200680357423},
{0.2081819395033781,-0.9650847195512468,-0.1589709538038424},
{0.21806600645900617,-0.9651020285858399,-0.1450010042948573},
{0.22705492426118803,-0.9651196780646001,-0.13034595652044134},
{0.23506294317471568,-0.9651357666832824,-0.11514497216428207},
{0.2420349093500664,-0.9651496385201173,-0.09952526272455704},
{0.24797806721433524,-0.9651612616064934,-0.08349022262998448},
{0.25288613231296725,-0.9651705049884398,-0.0670410350766497},
{0.2567168903600081,-0.9651755877877634,-0.05032417850728671},
{0.25944099992354797,-0.9651789997155812,-0.03346439999013871},
{0.26106286137258206,-0.9651814874773963,-0.01645839126040268},
{0.24037808366060187,-0.9706793378328689,3.1104610825572876e-10},
{0.11006998224153064,-0.9939238396423286,7.776378745374706e-11},
{-0.0026127105451082657,-0.9999962086362763,-0.0008697451814610839},
{-0.13618505854654286,-0.9906374258792935,-0.009545694103734985},
{-0.05041092386393687,-0.9911274691880556,0.12298405821920282},
{0.0007672317616039859,-0.9999996892778011,-0.00018110694372603473},
{0.059716924384019356,-0.9910154046581275,-0.11967604886693549},
{0.1316919629542659,-0.964991728542075,-0.2268219361936374},
{0.14621998515779494,-0.965003902046319,-0.21768597790356828},
{0.23552200845735993,-0.9224630331247256,-0.3059270109855332},
{0.25496207938194587,-0.9224782872118145,-0.289876090252355},
{0.27339391601982665,-0.9224937166316522,-0.2725089162916777},
{0.29065210778704625,-0.9225033421062766,-0.25398609418961754},
{0.30659201344191395,-0.9225130404457402,-0.23445901027938662},
{0.32121905803995254,-0.9225251666878587,-0.21392903865409274},
{0.33453300217413,-0.9225370059955681,-0.19238800125032962},
{0.34641289268234177,-0.9225437141987695,-0.17003294732431118},
{0.356764934313695,-0.922547830143738,-0.1470519729253079},
{0.3655980800818918,-0.9225502020786474,-0.12344702704027183},
{0.37290518867023276,-0.922549466761064,-0.09921795019901661},
{0.37861702098547556,-0.9225440511335323,-0.0745763041335152},
{0.38268681386232706,-0.922539551279639,-0.049714975818790794},
{0.3851190346888361,-0.922538083095795,-0.024633602218823047},
{0.3655122134994014,-0.9308065436935691,4.665972725442124e-10},
{0.26106286137258206,-0.9651814874773963,0.01645839126040268},
{0.13188795628372307,-0.9912326714407957,0.007959777361610253},
{-0.0025035409618865767,-0.9999963842090517,-0.0009817593772022033},
{0.051833373859462725,-0.9910085002159282,-0.12335093779182123},
{0.1165820522693417,-0.9649824326480407,-0.2349841053546773},
{0.19362692515797994,-0.9224416434514677,-0.33408087086874816},
{0.21507910528490415,-0.9224504515552883,-0.32066515697108405},
{0.31089120419449806,-0.858144563632538,-0.4085762683544112},
{0.3334458151043468,-0.863071521426974,-0.37936978963950996},
{0.34677711058966565,-0.8698162773905439,-0.35094911192014633},
{0.3761240803954024,-0.8630791844806062,-0.33708307205050314},
{0.40597998802359053,-0.8581899746833961,-0.3141499907325754},
{0.42021927151615546,-0.8631065576787886,-0.2801121809888019},
{0.4257528790227623,-0.8698447528345183,-0.2492079291878262},
{0.45052394710443705,-0.8630988986644275,-0.22822897320386606},
{0.46447105846808495,-0.8630941086471563,-0.19833102496610933},
{0.476430118465793,-0.8630872146092519,-0.1676150416779881},
{0.4863979644664412,-0.8630759369484212,-0.1360769900589639},
{0.49430900718280424,-0.863056012541067,-0.10388900150961108},
{0.5000708208757918,-0.8630356908626171,-0.0714042744231545},
{0.5122059611925734,-0.8581179349844569,-0.03575839729075512},
{0.48559810034205936,-0.8741821806375277,7.777741607161581e-10},
{0.3851190346888361,-0.922538083095795,0.024633602218823047},
{0.13111299273660199,-0.9912289450878954,0.01656989908206067},
{0.12831804862894647,-0.9911623756227796,0.03363961274847105},
{-0.00038620782375332153,-0.9999995436482971,-0.0008738116012344057},
{-0.12910095797979843,-0.9910016774455365,-0.03533578849879212},
{-0.253215051622197,-0.9649771967270214,-0.0685649139781244},
{-0.3728079733006124,-0.9224409339375501,-0.10058299279654809},
{-0.4773928985977013,-0.869771815253093,-0.12487197347613423},
{0.2524209156608853,-0.9653006774728261,0.06691997764063387},
{0.2562659976296407,-0.9652999910713563,0.050236099535335914},
{0.1302480160966858,-0.9911621224926546,0.025161503109581408},
{-0.00044352079917440074,-0.9999995472015998,-0.0008419536187645757},
{-0.13114205810358756,-0.9910014390714903,-0.02679381187122283},
{-0.25716812190728405,-0.9649764574348415,-0.0518169245631554},
{-0.3786040370505923,-0.922439090270867,-0.07592830743042464},
{-0.495324119243102,-0.8630372077654405,-0.0990999238570703},
{0.2761140574161295,-0.8630261794607029,-0.4230210879644947},
{0.3412590304875712,-0.7885990704522612,-0.511521045698525},
{0.37716492520461964,-0.7804868452220594,-0.4985849011258873},
{0.4003309028032716,-0.7886148085314453,-0.46671388668608255},
{0.4273250646040765,-0.7943691200947185,-0.43170706526655833},
{0.4619489129425019,-0.7886678513700368,-0.4057169235398129},
{0.4932750322823856,-0.780546051082838,-0.38396302512846103},
{0.5074187006958694,-0.7886535348077235,-0.3472057951984653},
{0.5244661736497299,-0.7943822630184221,-0.3064181014544374},
{0.5512206187742982,-0.7886524545657851,-0.2723658116310527},
{0.5678438139738292,-0.7886287416444779,-0.2358349227402561},
{0.582052843692349,-0.7885987882253724,-0.19830894674503188},
{0.5938370467426972,-0.7885610620700093,-0.1597780125766072},
{0.603092987128488,-0.7885099831712259,-0.12054399742728976},
{0.6097352939736109,-0.7884623801438677,-0.08093173901987598},
{0.24417708578980285,-0.8697653055855705,-0.42881915066241894},
{0.1713309793756063,-0.9224348889596009,-0.3460629583418088},
{0.22393097500191486,-0.8630279036576115,-0.45281094945135814},
{0.29879492817120185,-0.801818807246791,-0.5175018755951516},
{0.3483489748709767,-0.7174429482454612,-0.6032649564819758},
{0.3952590858538401,-0.7022951525448443,-0.5920741286038433},
{0.433055002503491,-0.7023270040601525,-0.5649780032661378},
{0.46898012376738835,-0.7023641853592006,-0.5354831413180358},
{0.5030300041427036,-0.7023980057845988,-0.5035850041472743},
{0.5349259970161828,-0.7024119960819459,-0.4695439973808836},
{0.5644099444042122,-0.7024129308105738,-0.4336559572838062},
{0.5915007090441261,-0.7024016544925743,-0.3959278052453381},
{0.6161909367415336,-0.7023739278939451,-0.3563419634177577},
{0.6382609056312173,-0.702318896160052,-0.3152319533920135},
{0.6575220847292876,-0.7022470904926192,-0.27297203517558816},
{0.6739982436069362,-0.7021592537853268,-0.22956208297190123},
{0.6876760039995237,-0.7020560040831578,-0.184984001075867},
{0.6984300720706536,-0.701936072432436,-0.1395750144026767},
{0.7061601448806851,-0.7018261439914916,-0.09369051922219303},
{0.7904679253209415,-0.6034379429905048,-0.10499099008102918},
{0.8624593807491644,-0.49290921760418743,-0.1149100507292364},
{0.9190473511064838,-0.37444614305081075,-0.12305304701033369},
{0.10102403266582317,-0.9649773120225693,-0.24210107828267002},
{0.1483910481836199,-0.9224322995202733,-0.35650911576102423},
{0.19456401825458072,-0.8581170805111226,-0.4751630445812244},
{0.2724131868872241,-0.7885775409982876,-0.5513043782186393},
{0.31525810955646805,-0.7022532440425251,-0.638320221824933},
{0.39218204482621416,-0.6118890699386188,-0.6868660785084538},
{0.4424569597786731,-0.6045839450406012,-0.6623519397892308},
{0.4847439857349542,-0.6046459822064782,-0.6320019814014459},
{0.524925340936495,-0.6047123927578031,-0.5989793890342446},
{0.5629989685109056,-0.604769966174612,-0.563280968495133},
{0.598653306984406,-0.6047983101355121,-0.5251982693172774},
{0.6316098112124873,-0.6047968192268626,-0.4850668550140238},
{0.6619009903091075,-0.604759991145709,-0.44289099351563294},
{0.689521225334539,-0.6046811976089407,-0.39864913027795906},
{0.7142230921083585,-0.6045490779644678,-0.35271204548680646},
{0.7358009737021057,-0.6043739783993721,-0.3054979890813493},
{0.754281044542937,-0.6041640356780019,-0.25699401517639653},
{0.7696448933714798,-0.6039259163305996,-0.20717197129787915},
{0.7817478750563742,-0.6036679035181814,-0.15638197500609646},
{0.8528501677556445,-0.49334209704040005,-0.17105603364672514},
{0.9087855324925878,-0.3749672197077946,-0.1830531072578945},
{0.9502087612149438,-0.2535829362752501,-0.18110495448878342},
{0.9719472534474287,-0.12982103385246174,-0.1961250511420653},
{0.9805944673105491,-0.002941671401878273,-0.19602509341740865},
{0.24185312705648535,-0.7749644071241709,-0.5838983067484285},
{0.2781791569972669,-0.6867373875771792,-0.6715713790178682},
{0.3445030986462371,-0.6044521730809755,-0.7183002056806245},
{0.3840531029773245,-0.4950341327350049,-0.7793872089794586},
{0.43438798036197146,-0.49512797761600735,-0.7524329659836351},
{0.48283499819274867,-0.49522999814635416,-0.7222309972966894},
{0.5289531021464079,-0.49534309565596213,-0.6890891330703599},
{0.5727592079488596,-0.4954581798835567,-0.6530452370979121},
{0.6142499760319664,-0.495555980663406,-0.6141019760377414},
{0.653085407287045,-0.4956073090781606,-0.5725843570837569},
{0.6889708038259261,-0.49560185888482483,-0.5288648494136886},
{0.7219546981298671,-0.4955227928075935,-0.4829477980655623},
{0.7520448914193903,-0.49535592848026855,-0.43479993722337223},
{0.7789741550435259,-0.49508709853991795,-0.384822076593262},
{0.8025251210617261,-0.49473207463083374,-0.33345705030233325},
{0.8227269502307801,-0.49430897009776836,-0.2806759830210683},
{0.8395572063741009,-0.49383512139110763,-0.2264300556594581},
{0.8946130046676435,-0.37558600195962,-0.24208000126305243},
{0.9362175814855567,-0.25385688651914295,-0.24300889136848858},
{0.9570325904193285,-0.12920094470594815,-0.2596068888961933},
{0.3322979470202471,-0.494963921085681,-0.8028628719959695},
{0.30283096224515776,-0.5940329259401376,-0.7452639070857187},
{0.3544280832032428,-0.37731508857604806,-0.8555782008500008},
{0.8766916606134366,-0.37621185436014265,-0.2997938839432145},
{0.9182701421133347,-0.2542100393420571,-0.3035740469817303},
{0.8965816047133961,-0.25460788774799,-0.36237584023505004},
{0.8551971531341814,-0.376792067469524,-0.3559010637287179},
{0.830159085875811,-0.3772900390287701,-0.41047304246138605},
{0.8712011566358836,-0.25500304584776673,-0.4195020754235434},
{0.8410852699779015,-0.2464800791170371,-0.48148015454913595},
{0.8015467966067247,-0.37767290416513505,-0.4635578823717387},
{0.7695749014924949,-0.3779179516255604,-0.5147159341150778},
{0.7670992339856302,-0.2557650780151385,-0.5883391794590681},
{0.7345179929633177,-0.3780439963783385,-0.5635299946013826},
{0.6963547489230734,-0.3780728636824509,-0.6100417800439855},
{0.727323669060169,-0.2558458835874631,-0.6368227102390461},
{0.803586734407396,-0.2556319155113652,-0.537494822353153},
{0.6550171209512151,-0.3780300698045819,-0.6542521208099551},
{0.6841792003567768,-0.2559050749398929,-0.6829431999948233},
{0.6108211054332293,-0.37793506523499937,-0.6957461200920524},
{0.5892690469379332,-0.255981020390041,-0.7663130610402862},
{0.5641371234712954,-0.3778140826912328,-0.7341701606860053},
{0.5149740417589893,-0.3776840306262104,-0.7695170623997564},
{0.5379356957388152,-0.25598085521496544,-0.8031805457139832},
{0.6380213234555192,-0.25595112975868134,-0.7262353681770961},
{0.46331508103613134,-0.3775540660360997,-0.8017431402288963},
{0.4840099223471483,-0.25593695893837337,-0.8367978657470899},
{0.40963018087798114,-0.3774241666569615,-0.8305143667253267},
{0.3703041039340081,-0.25572807177571943,-0.8930162506446923},
{0.4279568821573812,-0.25584292955084476,-0.8668317613083724},
{0.5177361629932067,-0.18667905877012386,0.8349252628503777},
{0.3859278715460519,-0.21461192856761183,0.8972187013657396},
{0.26248594936909014,-0.24082795354670053,0.9343998197636362},
{0.3895339756788627,-0.10691099332485199,0.9147859428839693},
{0.5276640362822437,-0.08770740603077197,0.8449130580963252},
{0.6869832769870108,-0.06707132704270542,0.7235712917390508},
{0.6740748471518605,-0.16000196371915884,0.7211258364829323},
{0.5256558038040963,0.06565917549335291,0.8481596834326676},
{0.3795919624815327,0.05852669421528357,0.9233009087419168},
{0.25254496853681335,-0.12395998455650827,0.9596118804472411},
{0.20721209301097634,0.07207453235198548,0.9756374379328896},
{0.3523451357617781,0.21512608289003188,0.9108093509431079},
{0.5058411710509797,0.2122600717760738,0.8361042827299652},
{0.6697238498097555,0.21919695084355492,0.7095228408845542},
{0.6880399991770182,0.07724349990760712,0.7215499991369361},
{0.13048403385369553,-0.2604650675768892,0.956625248193583},
{0.07494913103659862,-0.12001904970015022,0.9899384099356544},
{-0.0016581691932795357,0.08342695941172004,0.9965125151839498},
{-0.0436663165234314,0.23467608880195454,0.9710923674635141},
{0.1676390374456198,0.24718305521340883,0.9543572131752717},
{0.3159831757784878,0.3444971916405683,0.8840114917673315},
{0.4755897705220462,0.33960483613646103,0.811469608455865},
{0.633985140348476,0.35037507756429137,0.6894201526204032},
{0.7816669973556206,0.3712739987439801,0.5011509983046063},
{0.8235201196307177,0.23438403404838515,0.5166030750456427},
{0.8424882994117635,0.09440573355083647,0.5303781884910079},
{-0.033597391648634234,-0.2646439342169679,0.9637607604362056},
{-0.10324996654412524,-0.11296596339587073,0.9882196797892053},
{-0.16378596398416165,0.07379658377244444,0.9837317836815559},
{-0.25298105744011457,0.2526220573586025,0.9339072120464583},
{-0.33251812669874087,0.3687961405216826,0.8679983307317309},
{-0.11412500871994988,0.3630450277391825,0.9247560706578398},
{0.1158019708337719,0.37813090476282796,0.9184807686687073},
{0.27664602090600227,0.4806210363202928,0.8321480628850154},
{0.4433680701379523,0.4713580745657895,0.762395120605962},
{0.5767521934458902,0.4854661628280484,0.6570232203692387},
{0.7010933347420002,0.5006462390371085,0.5077612424342174},
{0.7874974642684794,0.5386633175685138,0.2994821765594698},
{0.8840358205672677,0.3668879255327653,0.28960994121787614},
{0.9245118249876167,0.22902995664406073,0.30466894232541303},
{0.9355605516016479,0.09773705315628314,0.3393728373443378},
{0.8408912634494873,-0.0423935132817997,0.5395411690371282},
{0.827196849779825,-0.1320129760262477,0.5461849008120119},
{-0.17997098300480097,-0.3058199711205041,0.9349249117122401},
{-0.3092989357168624,-0.3787869212748284,0.8722698187118211},
{-0.2196459243372636,-0.17764393880593707,0.9592696695546782},
{-0.30195515124940936,0.08023764019105367,0.9499394758249167},
{-0.3808461689081697,0.2741381215823399,0.883065391646211},
{-0.44447609562993123,0.38900808369587625,0.8069161736096473},
{-0.49940595098480656,0.46301695455627717,0.7322629281305939},
{-0.40062802325225083,0.45948902666851416,0.7926960460076835},
{-0.17907399871236843,0.48130399653918365,0.8580669938300693},
{0.06404248889646634,0.514854910735686,0.8548818517826277},
{0.24309100671830625,0.6439710177974272,0.7254020200479359},
{0.4242449506227695,0.6073359293130864,0.6716839218237205},
{0.5242091475664684,0.5671771596620945,0.6352281788186631},
{0.5896417433979929,0.6321507248988109,0.5027007812332134},
{0.6321012604415756,0.7150822946318431,0.29850512299159865},
{0.8138788650466873,0.5705329053970941,0.10996998176532899},
{0.9075133481158345,0.40565415560612433,0.10892304178212438},
{0.9575893489235977,0.263646096066591,0.11624704235775626},
{0.9824255134525485,0.12235806394892935,0.14095607366894922},
{0.9437171427911905,-0.014120802136578911,0.3304520499997716},
{0.9333808587967544,-0.10131098467352344,0.34429094791515297},
{-0.3465379354427609,-0.2960179448542301,0.8901038341807919},
{-0.4302089284676616,-0.524078912859572,0.735024877784851},
{-0.3910301269518616,-0.48546615761146833,0.7819322538621667},
{-0.36849899039849365,-0.030246199211913516,0.9291359757906935},
{-0.4102078487838779,0.28078889649196576,0.8676906801406403},
{-0.44994989439654726,0.4146149026896865,0.7909738143580721},
{-0.48778216441188404,0.4945161666816473,0.719390242477716},
{-0.5164281047419588,0.539774109476996,0.6647901348327488},
{-0.5368209256068244,0.5207109278393639,0.6638399080044081},
{-0.4476019860578697,0.5497029828775769,0.7053219780302786},
{-0.22813304923180175,0.6121671321075179,0.7571041633853675},
{0.02435050555182763,0.677471154460985,0.7351461676106804},
{0.2275009540510682,0.7995198385189957,0.555887887725945},
{0.42129910176839136,0.7469191804246986,0.5144111242603945},
{-0.28666604490437614,-0.32441405081735636,0.9014311412033401},
{-0.3506250071790471,-0.7045550144257641,0.6169800126326658},
{-0.17078291404036985,-0.7501336224375892,0.6388526784482789},
{-0.15439894906240553,-0.3753358761733369,0.9139386984834477},
{-0.1730759950239787,0.13598999609021967,0.9754749719546073},
{-0.31305217198386687,0.22843512549715264,0.9218545064462632},
{-0.3258929750799428,0.4333539668627235,0.8402369357496046},
{-0.3506191266276983,0.5424491959080034,0.7634232757138012},
{-0.3799829276381481,0.6017858853992168,0.7024718662251342},
{-0.41676003441896237,0.652101053855072,0.6333050523027665},
{-0.5351450935021643,0.5925481035317913,0.602085105198125},
{-0.553200008905967,0.5947910095755405,0.5832610093899191},
{-0.453183722355718,0.674248586919707,0.5831066427580756},
{-0.20127398507140845,0.7687919429783193,0.6069989549785856},
{0.03331619911244914,0.8197769781609613,0.5717129847694405},
{0.23303199304527678,0.9022679730722638,0.36277898917304263},
{0.43510987789665495,0.8403477641761812,0.32325690928555767},
{-0.45967592845121746,-0.6957658917036995,0.5519129140944856},
{-0.2816650713532357,-0.8734392212653289,0.3972011006215774},
{-0.12820897735483494,-0.8921018424307418,0.4332629234740764},
{-0.10339198543941111,-0.7499948943789765,0.6533129079946031},
{-0.16143996817429287,-0.41969691726242686,0.8931918239193074},
{-0.1402810656757659,0.041455919408529905,0.9892434631367877},
{-0.12631707590970115,0.36762222092098573,0.9213565536852412},
{-0.17125098950830842,0.4138769746438279,0.8940799452241938},
{-0.19006704235958125,0.5629531254634068,0.804337179259832},
{-0.22970904730835348,0.6564051351859952,0.7185861479921138},
{-0.29403595923250514,0.7266198992556112,0.6209399139079288},
{-0.376420998192991,0.7929419961934819,0.4791139977000132},
{-0.46433806953904233,0.7219891081247359,0.5129540768197518},
{-0.5535342034000551,0.6730692473240519,0.49048718023298093},
{-0.5574608217209918,0.6905527791574585,0.46084085262058433},
{-0.4533949416152036,0.7881078985133821,0.4163159463899582},
{-0.2451390500973568,0.8681931774265804,0.4314480881720346},
{0.01480670325127188,0.9145472008172613,0.4042080887564483},
{0.24593408981305556,0.9531703480897726,0.17601906428067784},
{0.4489432502816668,0.8813174913262659,0.14740908217918586},
{0.6528110867631689,0.7473040993219525,0.12399301647954095},
{0.7978908806814119,0.6028019098555021,0.0},
{0.9008800887258825,0.43406804275049554,0.0},
{0.9571835031357443,0.28948184973290564,0.0},
{0.98685208201728,0.16162601343273855,0.0},
{0.9997908605783544,0.02045079714811977,2.335689674286182e-09},
{0.9869759471976862,-0.003253489825941259,0.16083499139547452},
{0.9852490869466151,-0.07391270652267505,0.15434101362034117},
{-0.1486580154939568,0.557011058054759,0.8170920851618355},
{-0.20233502535156858,0.6795990851503727,0.7051280883490294},
{-0.28566802080391723,0.7693550560286687,0.571390041611767},
{-0.3618341617730143,0.823575368213629,0.43680619529238074},
{-0.45643802168605563,0.8600220408609381,0.22809301083704134},
{-0.44374497118786177,0.8394549454946117,0.3136969796318126},
{-0.513769126827521,0.8003631975752822,0.3089660762704481},
{-0.5747170620070893,0.7639680824256668,0.29334803164976087},
{-0.5525769500998171,0.7960559281125708,0.24688797770490564},
{-0.42548196619886297,0.8776959302740825,0.22048798248399434},
{-0.22811705521277437,0.9461712290084735,0.22961405557510392},
{0.027815198923050594,0.9784089621179429,0.2047979920706274},
{0.2178929285117387,0.9759726797941519,0.0},
{0.4209600770691675,0.9070791660676154,2.503800458394578e-09},
{0.6233660951082192,0.7819301193006514,1.2536801912765088e-09},
{0.6528110867631689,0.7473040993219525,-0.12399301647954095},
{0.8138788650466873,0.5705329053970941,-0.10996998176532899},
{0.9075133481158345,0.40565415560612433,-0.10892304178212438},
{0.9575893489235977,0.263646096066591,-0.11624704235775626},
{0.9824255134525485,0.12235806394892935,-0.14095607366894922},
{0.9869759472297973,-0.0032534798260476457,-0.16083499140070728},
{0.9852490869466151,-0.07391270652267505,-0.15434101362034117},
{0.9974691915335538,-0.07110001365259037,2.4903904782035802e-09},
{0.982907220068484,-0.07875971763394479,-0.1664040372571118},
{0.9841032995317194,0.026801308157519563,-0.17556305343616194},
{-0.23030593256666315,0.5367988428258587,0.8116687623442329},
{-0.2811949581577715,0.6680369005951146,0.6889528974827831},
{-0.34560997813170213,0.7535999523163415,0.5591429646205096},
{-0.46862207124344735,0.8040501222377393,0.36591905562976346},
{-0.5785116566765741,0.8026735236455119,0.14504991391870364},
{-0.5112218678785594,0.8594487778819379,2.4949593551965496e-09},
{-0.48139098485616194,0.8765059724264372,4.711169851793665e-09},
{-0.5521919886930409,0.8337169829283944,0.0},
{-0.5881232371401588,0.8087713261087961,5.036392030749222e-09},
{-0.5536652285680025,0.832739343777356,7.543823114294508e-09},
{-0.4682167986469207,0.8836136200086716,2.5189389167494438e-09},
{-0.26438598587055234,0.9644169484591485,3.787889797565705e-09},
{-0.003399920748846216,0.9999942202527481,1.2562002766831622e-09},
{0.027815198923050594,0.9784089621179429,-0.2047979920706274},
{0.24593408981305556,0.9531703480897726,-0.17601906428067784},
{0.4489432502816668,0.8813174913262659,-0.14740908217918586},
{0.6321012604415756,0.7150822946318431,-0.29850512299159865},
{0.7874974642684794,0.5386633175685138,-0.2994821765594698},
{0.8840358205672677,0.3668879255327653,-0.28960994121787614},
{0.9245118249876167,0.22902995664406073,-0.30466894232541303},
{0.9355605516016479,0.09773705315628314,-0.3393728373443378},
{0.9437171427911905,-0.014120802136578911,-0.3304520499997716},
{0.9333808587967544,-0.10131098467352344,-0.34429094791515297},
{0.9274790405002281,-0.10239200447115175,-0.35958101570182455},
{0.9277165778036386,0.013879308644358879,-0.3730272323301074},
{-0.4823731471891939,0.4293101309977815,0.7635502329863175},
{-0.22739693085337917,0.29860690919992344,0.9268897181523442},
{-0.4190669182423571,0.601611882628842,0.6800338673291456},
{-0.5547459495408654,0.6359009421590889,0.5365509511958643},
{-0.7362908162766888,0.6095488479020379,0.2938129266861917},
{-0.8029742252965323,0.5863601645194921,0.10683702997607097},
{-0.6235739879651948,0.7817229849129629,0.008040919844812476},
{-0.594765209972973,0.7932732800532818,-0.130276045992012},
{-0.45643802168605563,0.8600220408609381,-0.22809301083704134},
{-0.44374497118786177,0.8394549454946117,-0.3136969796318126},
{-0.513769126827521,0.8003631975752822,-0.3089660762704481},
{-0.5747170620070893,0.7639680824256668,-0.29334803164976087},
{-0.5525769500998171,0.7960559281125708,-0.24688797770490564},
{-0.42548196619886297,0.8776959302740825,-0.22048798248399434},
{-0.22811705521277437,0.9461712290084735,-0.22961405557510392},
{-0.5279830356781882,0.09110510615638175,0.844354057056801},
{-0.25834200037058647,-0.06869520009854188,0.9636080013822764},
{-0.4815378759623599,-0.24442493703944407,0.8416517832018908},
{-0.6854600862442507,-0.37218104682763614,0.625800078737858},
{-0.7927858418970146,-0.011281497750163563,0.6093958784699441},
{-0.7362378407760681,0.348926924538629,0.5798308746017298},
{-0.900091284352833,0.26336808320207283,0.3470921096517947},
{-0.9654154737516859,0.21757088140203606,0.14365192169528698},
{-0.9621107562964142,0.27265893093522886,3.807699035506149e-09},
{-0.7899099216626622,0.6130619392011178,-0.014048998606725755},
{-0.8245687679618462,0.5541908440476703,-0.11383696796565561},
{-0.7362908162766888,0.6095488479020379,-0.2938129266861917},
{-0.29514793370919123,-0.46791989490426755,0.833029812899859},
{-0.455699230844985,-0.4891632477969567,0.7436783767274817},
{-0.5005370025980374,-0.6396650033201813,0.5833450030278523},
{-0.5828190503564423,-0.723910062546918,0.3691560318956362},
{-0.8078752213020975,-0.4659371276346408,0.36088809885845136},
{-0.9258798227273627,-0.12666797574764502,0.35595193184802587},
{-0.9751944388761165,-0.1389140625168293,0.17233307755670949},
{-0.9812714453300305,-0.1926300874212361,3.802821725833074e-09},
{-0.9654154737516859,0.21757088140203606,-0.14365192169528698},
{0.7547989345506325,0.21211498160729864,0.6207139461772754},
{0.9106908822408963,0.08740828869745823,0.40373494779406877},
{0.9487710804168914,0.12137901028796397,0.2917200247258986},
{0.9553713397750113,0.10518103740732707,0.2760480981756954},
{0.9665760142158976,0.011210200164873797,0.25613500376710047},
{0.7384341701201145,0.24284905594745052,0.6290781449267252},
{0.6966833421363966,0.33371016388276575,0.635035311861473},
{0.8870193177113056,0.15613905592566285,0.4345311556397454},
{0.9003499236404258,0.10305099126014275,0.42278896414284667},
{0.4112940009184195,0.47866700106886345,0.7757030017321448},
{0.6353858330736797,0.44495388310328854,0.6311108341967923},
{0.8591083965675342,0.2643251220134296,0.43825220229879713},
{0.3499932271971272,0.5511963578075783,0.7574214916780487},
{0.1485399837430424,0.5202629430598253,0.840988907957974},
{0.6006277908992792,0.5300988154530207,0.5985327916286257},
{0.8083208549286485,0.39814792854340236,0.43369992216279774},
{0.09346001774759176,0.5538131051663496,0.82737915711518},
{-0.04554450566051632,0.5303570659156309,0.8465501052138039},
{-0.09454743434555495,0.5404881963391939,0.8360223036957076},
{0.065454064810045,0.5975166787581473,0.7991805703379401},
{0.2816339321817124,0.6246008495942598,0.7283928246008439},
{0.5123560125043048,0.6215980151704105,0.5925430144613087},
{0.7439203978052158,0.5201062781224857,0.41960922438252607},
{0.30302395551851086,0.6926918983183784,0.6544879039264188},
{0.4612212439189948,0.6836513615521946,0.5655932991166405},
{0.6591197008582621,0.6316737133146344,0.40810481478146776},
{0.08018627733131495,0.6724328099030396,0.735801791988609},
{-0.11589099534662896,0.5638929773580057,0.8176759671678575},
{-0.11553295481628327,0.6301127535695663,0.7678606996978015},
{0.13582298995663727,0.7831919420872655,0.6067639551331443},
{0.37914787912729625,0.7676427552747609,0.5166928352778336},
{0.5487649359972748,0.7119439169656299,0.43816994889602273},
{-0.09580329569359931,0.7482289663667757,0.6564869704906192},
{0.9003498209466566,0.43466191355841133,0.02095759583214489},
{0.8867666101370686,0.46217979680474164,0.00590038740592135},
{0.8908436607482513,0.45173082797152847,0.04834078159082743},
{0.8757259841857508,0.48238199128893144,0.02028829963362486},
{0.8891367594038364,0.4575358761929756,-0.009835907338450417},
{0.875737305732869,0.48270216851847914,-0.009098783176520022},
{0.8739021838715687,0.4785451006872851,0.08537891796397339},
{0.8960411450103825,0.4420390715371779,-0.041373006695580396},
{0.9207714142381918,0.381860171791896,-0.07976723588581817},
{0.8796621779419364,0.4663330943319104,-0.09342321889805982},
{0.8667253305803716,0.4708851796017633,-0.16448206273560895},
{0.8407656981311176,0.4802578275680204,-0.2499309102646971},
{0.7814437423654644,0.49654583629358195,-0.37787287541892334},
{0.8743198559453239,0.35457994157870454,-0.33141794539492103},
{0.9122850207462738,0.2577020058604014,-0.31831700723884715},
{0.9140249724777945,0.16943399489817307,-0.36857898890171825},
{0.913411164244477,0.40612407302695497,-0.02726320490231673},
{0.943511416534582,0.32786214474220343,-0.047881321138298634},
{0.9603556210830444,0.26920289378357487,-0.07243537141997212},
{0.9291580008957083,0.34601200033355556,-0.1301580001254723},
{0.9200162807388709,0.3409981040540529,-0.19310705892575905},
{0.9027285986140048,0.3478858453172897,-0.25309388746524475},
{0.9423390444868851,0.2915690137646819,-0.16427000775502298},
{0.959446267166965,0.23753706614446188,-0.15178604226627132},
{0.9708481916289474,0.1637810323275947,-0.17501303454460118},
{0.9620696903574388,0.25352391840321326,-0.10073496757840553},
{0.9520847670087006,0.27786493200173573,-0.12777196873203095},
{-0.9809163806172096,-0.19443007544316135,0.0},
{-0.9510141693756387,-0.23233004137798405,-0.20394803632314848},
{-0.9277458992254628,-0.3163529656367937,-0.1980109784914547},
{-0.8714260144630577,-0.29237900485261437,-0.3938670065370108},
{0.7010933347420002,0.5006462390371085,-0.5077612424342174},
{0.6023458152376776,0.6295758068852058,-0.490727849475144},
{-0.39975315969222486,-0.8998893594851735,-0.17434606964725877},
{-0.5896450981414227,-0.7366741226131562,-0.3311040551094602},
{-0.6393446876450324,-0.754152631555051,-0.1499739267295061},
{-0.5711321092038966,-0.8208581569530198,2.5260604829979668e-09},
{-0.34243187612991405,-0.939542660133188,0.0},
{-0.2232039904216474,-0.9564369589564218,0.18817099192501843},
{-0.17613995388867978,-0.9003497642992667,0.3979258958277892},
{-0.09914911656009455,-0.90573015127696,0.41209506882898744},
{-0.4735010000364596,-0.8077810000621992,0.3511220000270364},
{-0.8076088374852938,-0.4670869060083449,-0.35999692755800555},
{-0.8408829744312718,-0.5163779842984948,-0.16207899507166407},
{-0.8162673813744943,-0.5776742698995913,2.5243011793979618e-09},
{-0.6563178044143699,-0.7357607807400092,0.16704195022075458},
{-0.39975315969222486,-0.8998893594851735,0.17434606964725877},
{-0.3391719744450885,-0.8604449351697788,0.3802589713493889},
{-0.3096108832231564,-0.7238197269947936,0.6166247674258304},
{-0.16088007605945243,-0.7521033555727396,0.6391073021514698},
{-0.9134553715457643,-0.11032604487485206,-0.39169815932227947},
{-0.9676908313223097,-0.17323296980385028,-0.18320696806528777},
{-0.8702290532989204,-0.46506702848396114,0.16252400995410834},
{-0.900091284352833,0.26336808320207283,-0.3470921096517947},
{0.9715139699564168,0.20104699378272237,-0.12546199612015058},
{0.8923392412466234,0.3681620995337415,-0.2611270705964964},
{0.7439203978052158,0.5201062781224857,-0.41960922438252607},
{0.6591197008582621,0.6316737133146344,-0.40810481478146776},
{0.4612212439189948,0.6836513615521946,-0.5655932991166405},
{0.5487649359972748,0.7119439169656299,-0.43816994889602273},
{0.37914787912729625,0.7676427552747609,-0.5166928352778336},
{0.4686461191378256,0.8245052096032676,-0.3171150806160547},
{0.21177496427843737,0.8926748494262972,-0.3978479328922099},
{0.2660859543820948,0.950221837093507,-0.16210097220933065},
{0.927270289587484,0.3543731106710941,-0.12078703772191857},
{0.8272813050637602,0.5045271860467044,-0.2470990911189186},
{0.7406618951426513,0.6275259111595943,-0.24006496601340502},
{0.8600198905839764,0.497946936648705,-0.111420985824466},
{0.7741368513459983,0.6246988800418968,-0.10229098035752525},
{0.6331577901876887,0.7289757584360625,-0.2602029137754039},
{0.673682930053526,0.7318769240114185,-0.10250598935711118},
{0.5210829316761315,0.8446068892559965,-0.1229299838815445},
{0.9616275505372193,-0.13255407588795923,0.24021213752280926},
{0.9339155000791972,-0.28103815048613356,0.22095111831162226},
{0.893981048887355,-0.4005650219048988,0.20086201098413936},
{0.6835367459219198,-0.7169167335142136,0.13714194902283844},
{0.37768604106789033,-0.9229401003563772,0.07439640808953256}
};


// face array: 69kb.
const uint16_t bob_face[35383] PROGMEM = {
73, // chain 0
0,0,0, 1,1,1, 2,2,2, 
3,3,3, 32772,4,4, 32773,5,5, 32774,6,6, 32769,1,1, 7,7,7, 32776,8,8, 32777,9,9, 32768,0,0, 10,10,10, 32779,11,11, 32771,3,3, 12,12,12, 32781,13,13, 32772,4,4, 14,14,14, 
32783,15,15, 32773,5,5, 16,16,16, 32785,17,17, 32774,6,6, 18,18,18, 32775,7,7, 19,19,19, 32788,20,20, 32776,8,8, 21,21,21, 32790,22,22, 32777,9,9, 23,23,23, 32778,10,10, 24,24,24, 
32793,25,25, 32779,11,11, 26,26,26, 32780,12,12, 27,27,27, 32796,28,28, 32781,13,13, 29,29,29, 32782,14,14, 30,30,30, 32799,31,31, 32783,15,15, 32,32,32, 32784,16,16, 33,33,33, 32802,34,34, 
32785,17,17, 35,35,35, 32786,18,18, 36,36,36, 32787,19,19, 37,37,37, 32806,38,38, 32788,20,20, 39,39,39, 32789,21,21, 40,40,40, 32809,41,41, 32790,22,22, 42,42,42, 32791,23,23, 43,43,43, 
32792,24,24, 44,44,44, 32813,45,45, 32793,25,25, 46,46,46, 32794,26,26, 47,47,47, 32795,27,27, 
37, // chain 1
32,32,32, 33,33,33, 48,48,48, 
49,49,49, 32818,50,50, 32819,51,51, 32820,52,52, 32801,33,33, 53,53,53, 32802,34,34, 54,54,54, 32803,35,35, 36,36,36, 55,55,55, 32824,56,56, 32805,37,37, 57,57,57, 32826,58,58, 32806,38,38, 
59,59,59, 32807,39,39, 60,60,60, 32808,40,40, 61,61,61, 32830,62,62, 32809,41,41, 63,63,63, 32810,42,42, 64,64,64, 32811,43,43, 65,65,65, 32812,44,44, 66,66,66, 32835,67,67, 32813,45,45, 
68,68,68, 32814,46,46, 69,69,69, 32815,47,47, 
40, // chain 2
31,31,31, 32,32,32, 49,49,49, 
70,70,70, 32839,71,71, 32818,50,50, 72,72,72, 32841,73,73, 32819,51,51, 74,74,74, 32843,75,75, 32820,52,52, 76,76,76, 32821,53,53, 77,77,77, 32822,54,54, 55,55,55, 78,78,78, 32847,79,79, 
32824,56,56, 80,80,80, 32825,57,57, 81,81,81, 32850,82,82, 32826,58,58, 83,83,83, 32827,59,59, 84,84,84, 32828,60,60, 85,85,85, 32829,61,61, 86,86,86, 32855,87,87, 32830,62,62, 88,88,88, 
32831,63,63, 89,89,89, 32832,64,64, 90,90,90, 32833,65,65, 91,91,91, 32834,66,66, 
1, // chain 3
70,70,70, 30,30,30, 31,31,31, 
10, // chain 4
75,75,75, 92,92,92, 93,93,93, 
74,74,74, 32862,94,94, 32863,95,95, 32864,96,96, 32860,92,92, 97,97,97, 32866,98,98, 32844,76,76, 32843,75,75, 
16, // chain 5
94,94,94, 95,95,95, 99,99,99, 
100,100,100, 32869,101,101, 32870,102,102, 32871,103,103, 32863,95,95, 104,104,104, 32864,96,96, 105,105,105, 32865,97,97, 106,106,106, 32875,107,107, 32866,98,98, 78,78,78, 32845,77,77, 32844,76,76, 
198, // chain 6
108,108,108, 94,94,94, 100,100,100, 
109,109,109, 32878,110,110, 32869,101,101, 111,111,111, 32880,112,112, 32870,102,102, 113,113,113, 32882,114,114, 32871,103,103, 115,115,115, 32872,104,104, 116,116,116, 32873,105,105, 117,117,117, 32874,106,106, 118,118,118, 
32887,119,119, 32875,107,107, 120,120,120, 32846,78,78, 79,79,79, 121,121,121, 32848,80,80, 122,122,122, 32849,81,81, 123,123,123, 32892,124,124, 32850,82,82, 125,125,125, 32851,83,83, 126,126,126, 32852,84,84, 
127,127,127, 32853,85,85, 128,128,128, 32854,86,86, 129,129,129, 32898,130,130, 32855,87,87, 131,131,131, 32856,88,88, 132,132,132, 32857,89,89, 133,133,133, 32858,90,90, 134,134,134, 32859,91,91, 135,135,135, 
32904,136,136, 32834,137,66, 137,138,137, 32835,139,67, 138,140,138, 32836,141,68, 139,142,139, 32837,143,69, 140,144,140, 141,145,141, 32910,146,142, 143,147,143, 32912,148,144, 145,149,145, 32914,150,146, 147,151,147, 
32916,152,148, 149,153,149, 32918,154,150, 151,155,151, 32920,156,152, 153,157,153, 32922,158,154, 155,159,155, 32924,160,156, 157,161,157, 32926,162,158, 159,163,159, 32928,164,160, 161,165,161, 32930,166,162, 163,167,163, 
32932,168,164, 165,169,165, 32934,170,166, 167,171,167, 32936,172,168, 169,173,169, 32938,174,170, 171,175,171, 32940,176,172, 173,177,173, 32942,178,174, 175,179,175, 32944,180,176, 177,181,177, 32946,182,178, 179,183,179, 
180,184,180, 32949,185,181, 182,186,182, 32951,187,183, 184,188,184, 32953,189,185, 186,190,186, 187,191,187, 32956,192,188, 189,193,189, 32958,194,190, 191,195,191, 32960,196,192, 193,197,193, 32962,198,194, 195,199,195, 
32964,200,196, 197,201,197, 32966,202,198, 199,203,199, 32968,204,200, 201,205,201, 32970,206,202, 203,207,203, 32972,208,204, 205,209,205, 32974,210,206, 207,211,207, 32976,212,208, 209,213,209, 210,214,210, 32979,215,211, 
212,216,212, 32981,217,213, 214,218,214, 32983,219,215, 216,220,216, 32985,221,217, 218,222,218, 32987,223,219, 220,224,220, 32989,225,221, 222,226,222, 32991,227,223, 32992,228,224, 225,229,225, 32994,230,226, 227,231,227, 
32996,232,228, 229,233,229, 32998,234,230, 231,235,231, 33000,236,232, 233,237,233, 33002,238,234, 235,239,235, 33004,240,236, 237,241,237, 33006,242,238, 239,243,239, 33008,244,240, 241,245,241, 242,246,242, 33011,247,243, 
244,248,244, 33013,249,245, 246,250,246, 33015,251,247, 248,252,248, 33017,253,249, 250,254,250, 33019,255,251, 252,256,252, 33021,257,253, 254,258,254, 33023,259,255, 256,260,256, 33025,261,257, 258,262,258, 33027,263,259, 
33028,264,260, 261,265,261, 33030,266,262, 263,267,263, 33032,268,264, 265,269,265, 33034,270,266, 267,271,267, 33036,272,268, 269,273,269, 33038,274,270, 271,275,271, 33040,276,272, 273,277,273, 274,278,274, 33043,279,275, 
276,280,276, 33045,281,277, 278,282,278, 32951,283,183, 32953,284,185, 
4, // chain 7
74,74,74, 94,94,94, 108,108,108, 
73,73,73, 33047,285,279, 32877,109,109, 
10, // chain 8
114,114,114, 280,286,280, 281,287,281, 
113,113,113, 33050,288,282, 33051,289,283, 33052,290,284, 33048,286,280, 285,291,285, 33054,292,286, 32883,115,115, 32882,114,114, 
16, // chain 9
282,288,282, 283,289,283, 287,293,287, 
288,294,288, 33057,295,289, 33058,296,290, 33059,297,291, 33051,289,283, 292,298,292, 33052,290,284, 285,291,285, 293,299,293, 33062,300,294, 33063,301,295, 33054,292,286, 296,302,296, 32884,116,116, 32883,115,115, 
24, // chain 10
297,303,297, 282,288,282, 288,294,288, 
298,304,298, 33067,305,299, 33057,295,289, 300,306,300, 33069,307,301, 33058,296,290, 302,308,302, 33071,309,303, 33059,297,291, 292,298,292, 304,310,304, 33061,299,293, 305,311,305, 33074,312,306, 33062,300,294, 307,313,307, 
33076,314,308, 33063,301,295, 309,315,309, 33064,302,296, 310,316,310, 32885,117,117, 32884,116,116, 
4, // chain 11
113,113,113, 282,288,282, 297,303,297, 
112,112,112, 33079,317,311, 33066,304,298, 
18, // chain 12
303,309,303, 304,310,304, 312,318,312, 
33081,319,313, 33073,311,305, 314,320,314, 33083,321,315, 33074,312,306, 316,322,316, 33075,313,307, 317,323,317, 33086,324,318, 33076,314,308, 319,325,319, 33077,315,309, 320,326,320, 33078,316,310, 321,327,321, 32886,118,118, 
32885,117,117, 
210, // chain 13
312,318,312, 322,328,322, 323,329,323, 
303,309,303, 33070,308,302, 33092,330,324, 33093,331,325, 33094,332,326, 33090,328,322, 327,333,327, 33096,334,328, 33097,335,329, 33080,318,312, 313,319,313, 330,336,330, 33082,320,314, 331,337,331, 33100,338,332, 33083,321,315, 
333,339,333, 33084,322,316, 334,340,334, 33085,323,317, 335,341,335, 33104,342,336, 33086,324,318, 337,343,337, 33087,325,319, 338,344,338, 33088,326,320, 339,345,339, 33089,327,321, 340,346,340, 33109,347,341, 32886,118,118, 
119,119,119, 342,348,342, 32888,120,120, 121,121,121, 343,349,343, 32890,122,122, 344,350,344, 32891,123,123, 345,351,345, 33114,352,346, 32892,124,124, 347,353,347, 32893,125,125, 348,354,348, 32894,126,126, 349,355,349, 
32895,127,127, 350,356,350, 32896,128,128, 351,357,351, 32897,129,129, 352,358,352, 32898,130,130, 353,359,353, 32899,131,131, 354,360,354, 32900,132,132, 355,361,355, 32901,133,133, 356,362,356, 32902,134,134, 357,363,357, 
32903,135,135, 358,364,358, 33127,365,359, 32904,136,136, 360,366,360, 32905,138,137, 361,367,361, 32906,140,138, 362,368,362, 32907,142,139, 141,145,141, 363,369,363, 32911,147,143, 364,370,364, 32913,149,145, 365,371,365, 
32915,151,147, 366,372,366, 32917,153,149, 367,373,367, 32919,155,151, 368,374,368, 32921,157,153, 369,375,369, 32923,159,155, 370,376,370, 32925,161,157, 371,377,371, 32927,163,159, 372,378,372, 32929,165,161, 373,379,373, 
32931,167,163, 374,380,374, 32933,169,165, 375,381,375, 32935,171,167, 376,382,376, 32937,173,169, 377,383,377, 32939,175,171, 378,384,378, 32941,177,173, 379,385,379, 32943,179,175, 177,181,177, 380,386,380, 32948,184,180, 
381,387,381, 32950,186,182, 382,388,382, 32952,188,184, 187,191,187, 383,389,383, 32957,193,189, 384,390,384, 32959,195,191, 385,391,385, 32961,197,193, 386,392,386, 32963,199,195, 387,393,387, 32965,201,197, 388,394,388, 
32967,203,199, 389,395,389, 32969,205,201, 390,396,390, 32971,207,203, 391,397,391, 32973,209,205, 392,398,392, 32975,211,207, 210,214,210, 393,399,393, 32980,216,212, 394,400,394, 32982,218,214, 395,401,395, 32984,220,216, 
396,402,396, 32986,222,218, 397,403,397, 32988,224,220, 398,404,398, 32990,226,222, 399,405,399, 33168,406,400, 32991,227,223, 401,407,401, 32993,229,225, 402,408,402, 32995,231,227, 403,409,403, 32997,233,229, 404,410,404, 
32999,235,231, 405,411,405, 33001,237,233, 406,412,406, 33003,239,235, 407,413,407, 33005,241,237, 408,414,408, 33007,243,239, 409,415,409, 33010,246,242, 244,248,244, 410,416,410, 33014,250,246, 411,417,411, 33016,252,248, 
412,418,412, 33018,254,250, 413,419,413, 33020,256,252, 414,420,414, 33022,258,254, 415,421,415, 33024,260,256, 416,422,416, 33026,262,258, 417,423,417, 33186,424,418, 33027,263,259, 419,425,419, 33029,265,261, 420,426,420, 
33031,267,263, 421,427,421, 33033,269,265, 422,428,422, 33035,271,267, 423,429,423, 33037,273,269, 424,430,424, 33039,275,271, 274,278,274, 425,431,425, 33044,280,276, 426,432,426, 33046,282,278, 427,433,427, 32949,434,181, 
32951,283,183, 
7, // chain 14
428,435,428, 429,436,429, 326,332,326, 
33093,331,325, 33198,437,430, 324,330,324, 33199,438,431, 301,307,301, 33068,306,300, 
58, // chain 15
329,335,329, 330,336,330, 432,439,432, 
33201,440,433, 33099,337,331, 434,441,434, 33203,442,435, 33100,338,332, 436,443,436, 33101,339,333, 437,444,437, 33102,340,334, 438,445,438, 33103,341,335, 439,446,439, 33208,447,440, 33209,448,441, 33104,342,336, 442,449,442, 
33105,343,337, 443,450,443, 33106,344,338, 444,451,444, 33107,345,339, 445,452,445, 33108,346,340, 446,453,446, 33215,454,447, 33109,347,341, 342,348,342, 343,349,343, 448,455,448, 33112,350,344, 449,456,449, 33113,351,345, 
450,457,450, 33219,458,451, 33114,352,346, 452,459,452, 33115,353,347, 453,460,453, 33116,354,348, 454,461,454, 33117,355,349, 455,462,455, 33118,356,350, 456,463,456, 33119,357,351, 457,464,457, 33120,358,352, 458,465,458, 
33227,466,459, 33228,467,460, 33121,359,353, 461,468,461, 33122,360,354, 462,469,462, 33123,361,355, 357,363,357, 33124,362,356, 
2, // chain 16
432,439,432, 463,470,463, 328,334,328, 
329,335,329, 
6, // chain 17
463,470,463, 432,439,432, 464,471,464, 
465,472,465, 33234,473,466, 33235,474,467, 33201,440,433, 33200,439,432, 
8, // chain 18
466,473,466, 467,474,467, 468,475,468, 
469,476,469, 33238,477,470, 33239,478,471, 33240,479,472, 33235,474,467, 434,441,434, 33201,440,433, 
2, // chain 19
465,472,465, 466,473,466, 473,480,473, 
33237,476,469, 
10, // chain 20
463,470,463, 474,481,474, 475,482,475, 
328,334,328, 33095,333,327, 33244,483,476, 33245,484,477, 33242,481,474, 478,485,478, 33247,486,479, 33233,472,465, 33231,470,463, 
3, // chain 21
327,333,327, 476,483,476, 480,487,480, 
326,332,326, 33196,435,428, 
293, // chain 22
469,488,469, 470,489,470, 481,490,481, 
33250,491,482, 33251,492,483, 33252,493,484, 485,494,485, 33254,495,486, 487,496,487, 33256,497,488, 489,498,489, 33258,499,490, 491,500,491, 33260,501,492, 493,502,493, 33262,503,494, 495,504,495, 33264,505,496, 497,506,497, 
33266,507,498, 499,508,499, 33268,509,500, 501,510,501, 33270,511,502, 503,512,503, 33272,513,504, 505,514,505, 33274,515,506, 507,516,507, 33276,517,508, 509,518,509, 33278,519,510, 511,520,511, 33280,521,512, 513,522,513, 
33282,523,514, 515,524,515, 33284,525,516, 517,526,517, 518,527,518, 33287,528,519, 520,529,520, 33289,530,521, 522,531,522, 33291,532,523, 524,533,524, 33293,534,525, 526,535,526, 33295,536,527, 528,537,528, 33297,538,529, 
530,539,530, 33299,540,531, 33300,541,532, 533,542,533, 33302,543,534, 535,544,535, 33304,545,536, 537,546,537, 33306,547,538, 539,548,539, 33308,549,540, 541,550,541, 33310,551,542, 543,552,543, 33312,553,544, 545,554,545, 
33314,555,546, 547,556,547, 33316,557,548, 549,558,549, 33318,559,550, 551,560,551, 33320,561,552, 553,562,553, 33322,563,554, 555,564,555, 33324,565,556, 557,566,557, 33326,567,558, 559,568,559, 33328,569,560, 561,570,561, 
33330,571,562, 563,572,563, 564,573,564, 33333,574,565, 566,575,566, 33335,576,567, 568,577,568, 33246,578,478, 569,579,569, 570,580,570, 33339,581,571, 572,582,572, 573,583,573, 33342,584,574, 575,585,575, 33344,586,576, 
33345,587,577, 578,588,578, 33347,589,579, 580,590,580, 581,591,581, 33350,592,582, 583,593,583, 33352,594,584, 33353,595,585, 586,596,586, 33355,597,587, 588,598,588, 589,599,589, 33358,600,590, 591,601,591, 33360,602,592, 
33361,603,593, 594,604,594, 33363,605,595, 596,606,596, 597,607,597, 33366,608,598, 599,609,599, 33368,610,600, 33369,611,601, 602,612,602, 33371,613,603, 604,614,604, 605,615,605, 33374,616,606, 607,617,607, 33376,618,608, 
33377,619,609, 610,620,610, 33379,621,611, 612,622,612, 613,623,613, 33382,624,614, 615,625,615, 616,626,616, 617,627,617, 33386,628,618, 619,629,619, 33388,630,620, 621,631,621, 33390,632,622, 33391,633,623, 33392,634,624, 
33393,635,625, 33386,636,618, 626,637,626, 33384,638,616, 627,639,627, 33383,640,615, 614,641,614, 628,642,628, 629,643,629, 33398,644,630, 631,645,631, 632,646,632, 33401,647,633, 634,648,634, 33403,649,635, 33404,650,636, 
637,651,637, 33406,652,638, 639,653,639, 640,654,640, 33409,655,641, 642,656,642, 33411,657,643, 33412,658,644, 645,659,645, 33414,660,646, 647,661,647, 648,662,648, 33417,663,649, 650,664,650, 33419,665,651, 33420,666,652, 
653,667,653, 33422,668,654, 655,669,655, 656,670,656, 33425,671,657, 658,672,658, 33427,673,659, 33428,674,660, 661,675,661, 33430,676,662, 663,677,663, 664,678,664, 33433,679,665, 666,680,666, 33435,681,667, 33436,682,668, 
669,683,669, 33438,684,670, 671,685,671, 672,686,672, 32953,687,185, 277,688,277, 673,689,673, 33043,690,275, 674,691,674, 33041,692,273, 675,693,675, 33040,694,272, 676,695,676, 33038,696,270, 677,697,677, 33036,698,268, 
678,699,678, 33034,700,266, 679,701,679, 33032,702,264, 680,703,680, 33030,704,262, 681,705,681, 33028,706,260, 682,707,682, 33025,708,257, 255,709,255, 683,710,683, 33021,711,253, 684,712,684, 33019,713,251, 685,714,685, 
33017,715,249, 686,716,686, 33015,717,247, 687,718,687, 33013,719,245, 688,720,688, 33011,721,243, 689,722,689, 33009,723,241, 690,724,690, 33008,725,240, 691,726,691, 33460,727,692, 33006,728,238, 693,729,693, 33004,730,236, 
694,731,694, 33002,732,234, 695,733,695, 33000,734,232, 696,735,696, 32998,736,230, 697,737,697, 32996,738,228, 698,739,698, 32994,740,226, 224,741,224, 699,742,699, 32989,743,221, 700,744,700, 32987,745,219, 701,746,701, 
32985,747,217, 702,748,702, 32983,749,215, 703,750,703, 32981,751,213, 704,752,704, 32979,753,211, 705,754,705, 32977,755,209, 706,756,706, 32976,757,208, 707,758,707, 32974,759,206, 708,760,708, 32972,761,204, 709,762,709, 
32970,763,202, 710,764,710, 32968,765,200, 711,766,711, 32966,767,198, 712,768,712, 32964,769,196, 713,770,713, 32962,771,194, 714,772,714, 32960,773,192, 715,774,715, 33484,775,716, 32958,776,190, 717,777,717, 32956,778,188, 
718,779,718, 32954,780,186, 671,781,671, 32953,782,185, 
140, // chain 23
481,490,481, 719,783,719, 720,784,720, 
469,488,469, 33241,785,473, 33489,786,721, 33490,787,722, 33487,783,719, 723,788,723, 33492,789,724, 33493,790,725, 33249,490,481, 482,491,482, 726,791,726, 33495,792,727, 33251,492,483, 728,793,728, 33253,494,485, 729,794,729, 
33255,496,487, 730,795,730, 33257,498,489, 731,796,731, 33259,500,491, 732,797,732, 33261,502,493, 733,798,733, 33263,504,495, 734,799,734, 33265,506,497, 735,800,735, 33267,508,499, 736,801,736, 33269,510,501, 737,802,737, 
33271,512,503, 738,803,738, 33273,514,505, 739,804,739, 33275,516,507, 740,805,740, 33277,518,509, 741,806,741, 33279,520,511, 742,807,742, 33281,522,513, 743,808,743, 33283,524,515, 744,809,744, 33286,527,518, 520,529,520, 
745,810,745, 33290,531,522, 746,811,746, 33292,533,524, 747,812,747, 33294,535,526, 748,813,748, 33296,537,528, 749,814,749, 33298,539,530, 750,815,750, 33519,816,751, 33299,540,531, 752,817,752, 33301,542,533, 753,818,753, 
33303,544,535, 754,819,754, 33305,546,537, 755,820,755, 33307,548,539, 756,821,756, 33309,550,541, 757,822,757, 33311,552,543, 758,823,758, 33313,554,545, 759,824,759, 33315,556,547, 760,825,760, 33317,558,549, 761,826,761, 
33319,560,551, 762,827,762, 33321,562,553, 763,828,763, 33323,564,555, 764,829,764, 33325,566,557, 765,830,765, 33327,568,559, 766,831,766, 33329,570,561, 564,573,564, 767,832,767, 33334,575,566, 768,833,768, 33336,577,568, 
570,580,570, 573,583,573, 769,834,769, 33343,585,575, 770,835,770, 33539,836,771, 33344,586,576, 772,837,772, 33346,588,578, 581,591,581, 773,838,773, 33351,593,583, 774,839,774, 33543,840,775, 33352,594,584, 776,841,776, 
33354,596,586, 589,599,589, 777,842,777, 33359,601,591, 778,843,778, 33547,844,779, 33360,602,592, 594,604,594, 780,845,780, 33365,607,597, 781,846,781, 33367,609,599, 782,847,782, 33368,610,600, 783,848,783, 33370,612,602, 
784,849,784, 33373,615,605, 785,850,785, 33375,617,607, 786,851,786, 33555,852,787, 33376,618,608, 788,853,788, 33378,620,610, 617,627,617, 33381,623,613, 
86, // chain 24
724,789,724, 725,790,725, 789,854,789, 
33494,791,726, 727,792,727, 790,855,790, 33496,793,728, 791,856,791, 33497,794,729, 792,857,792, 33498,795,730, 793,858,793, 33499,796,731, 794,859,794, 33500,797,732, 795,860,795, 33501,798,733, 796,861,796, 33502,799,734, 
797,862,797, 33566,863,798, 33503,800,735, 799,864,799, 33504,801,736, 800,865,800, 33505,802,737, 801,866,801, 33506,803,738, 802,867,802, 33507,804,739, 803,868,803, 33508,805,740, 804,869,804, 33509,806,741, 742,807,742, 
805,870,805, 33511,808,743, 806,871,806, 33512,809,744, 807,872,807, 33513,810,745, 808,873,808, 33514,811,746, 809,874,809, 33515,812,747, 810,875,810, 33516,813,748, 811,876,811, 33517,814,749, 812,877,812, 33518,815,750, 
813,878,813, 33582,879,814, 33519,816,751, 815,880,815, 33520,817,752, 816,881,816, 33521,818,753, 817,882,817, 33522,819,754, 818,883,818, 33523,820,755, 819,884,819, 33524,821,756, 820,885,820, 33525,822,757, 821,886,821, 
33526,823,758, 822,887,822, 33527,824,759, 823,888,823, 33528,825,760, 824,889,824, 33529,826,761, 825,890,825, 33530,827,762, 826,891,826, 33531,828,763, 827,892,827, 33532,829,764, 828,893,828, 33533,830,765, 829,894,829, 
33534,831,766, 830,895,830, 33535,832,767, 769,834,769, 33536,833,768, 
10, // chain 25
723,788,723, 831,896,831, 832,897,832, 
833,898,833, 33602,899,834, 33603,900,835, 33604,901,836, 33599,896,831, 837,902,837, 33606,903,838, 33492,789,724, 33491,788,723, 
20, // chain 26
722,787,722, 723,788,723, 833,898,833, 
571,904,571, 33340,905,572, 33602,899,834, 574,906,574, 33345,907,577, 33603,900,835, 579,908,579, 33607,909,839, 33604,901,836, 840,910,840, 33605,902,837, 841,911,841, 33610,912,842, 33606,903,838, 843,913,843, 33612,914,844, 
33558,855,790, 33557,854,789, 33492,789,724, 
4, // chain 27
479,915,479, 473,785,473, 721,786,721, 
569,916,569, 33339,904,571, 33490,787,722, 
19, // chain 28
841,911,841, 845,917,845, 846,918,846, 
840,910,840, 33615,919,847, 33616,920,848, 33617,921,849, 33613,917,845, 850,922,850, 33619,923,851, 33620,924,852, 33609,911,841, 842,912,842, 851,923,851, 33611,913,843, 853,925,853, 33622,926,854, 33612,914,844, 855,927,855, 
33559,856,791, 33558,855,790, 
15, // chain 29
847,919,847, 848,920,848, 856,928,856, 
857,929,857, 33626,930,858, 33627,931,859, 33628,932,860, 33616,920,848, 861,933,861, 33617,921,849, 862,934,862, 33631,935,863, 33632,936,864, 33618,922,850, 865,937,865, 33621,925,853, 33619,923,851, 
31, // chain 30
839,909,839, 847,919,847, 857,929,857, 
579,908,579, 33348,938,580, 33626,930,858, 582,939,582, 33353,940,585, 33627,931,859, 587,941,587, 33634,942,866, 33628,932,860, 867,943,867, 33629,933,861, 868,944,868, 33630,934,862, 869,945,869, 33638,946,870, 33631,935,863, 
871,947,871, 33640,948,872, 33632,936,864, 873,949,873, 33633,937,865, 874,950,874, 33643,951,875, 33621,925,853, 854,926,854, 876,952,876, 33623,927,855, 877,953,877, 33560,857,792, 33559,856,791, 
1, // chain 31
840,910,840, 847,919,847, 839,909,839, 
10, // chain 32
868,944,868, 878,954,878, 879,955,879, 
867,943,867, 33648,956,880, 33649,957,881, 33650,958,882, 33646,954,878, 883,959,883, 33638,946,870, 33637,945,869, 33636,944,868, 
15, // chain 33
880,956,880, 881,957,881, 884,960,884, 
885,961,885, 33654,962,886, 33655,963,887, 33656,964,888, 33649,957,881, 889,965,889, 33650,958,882, 890,966,890, 33659,967,891, 33660,968,892, 33651,959,883, 893,969,893, 33639,947,871, 33638,946,870, 
39, // chain 34
866,942,866, 880,956,880, 885,961,885, 
587,941,587, 33356,970,588, 33654,962,886, 590,971,590, 33361,972,593, 33655,963,887, 595,973,595, 33662,974,894, 33656,964,888, 895,975,895, 33657,965,889, 896,976,896, 33658,966,890, 897,977,897, 33666,978,898, 33659,967,891, 
899,979,899, 33668,980,900, 33660,968,892, 901,981,901, 33661,969,893, 902,982,902, 33671,983,903, 33639,947,871, 872,948,872, 904,984,904, 33641,949,873, 905,985,905, 33642,950,874, 906,986,906, 33675,987,907, 33643,951,875, 
876,952,876, 908,988,908, 33645,953,877, 909,989,909, 33561,858,793, 33560,857,792, 
1, // chain 35
867,943,867, 880,956,880, 866,942,866, 
10, // chain 36
896,976,896, 910,990,910, 911,991,911, 
895,975,895, 33680,992,912, 33681,993,913, 33682,994,914, 33678,990,910, 915,995,915, 33666,978,898, 33665,977,897, 33664,976,896, 
15, // chain 37
912,992,912, 913,993,913, 916,996,916, 
917,997,917, 33686,998,918, 33687,999,919, 33688,1000,920, 33681,993,913, 921,1001,921, 33682,994,914, 922,1002,922, 33691,1003,923, 33692,1004,924, 33683,995,915, 925,1005,925, 33667,979,899, 33666,978,898, 
47, // chain 38
894,974,894, 912,992,912, 917,997,917, 
595,973,595, 33364,1006,596, 33686,998,918, 598,1007,598, 33369,1008,601, 33687,999,919, 603,1009,603, 33694,1010,926, 33688,1000,920, 927,1011,927, 33689,1001,921, 928,1012,928, 33690,1002,922, 929,1013,929, 33698,1014,930, 33691,1003,923, 
931,1015,931, 33700,1016,932, 33692,1004,924, 933,1017,933, 33693,1005,925, 934,1018,934, 33703,1019,935, 33667,979,899, 900,980,900, 936,1020,936, 33669,981,901, 937,1021,937, 33670,982,902, 938,1022,938, 33707,1023,939, 33671,983,903, 
904,984,904, 940,1024,940, 33673,985,905, 941,1025,941, 33674,986,906, 942,1026,942, 33711,1027,943, 33675,987,907, 908,988,908, 944,1028,944, 33677,989,909, 945,1029,945, 33562,859,794, 33561,858,793, 
1, // chain 39
895,975,895, 912,992,912, 894,974,894, 
10, // chain 40
928,1012,928, 946,1030,946, 947,1031,947, 
927,1011,927, 33716,1032,948, 33717,1033,949, 33718,1034,950, 33714,1030,946, 951,1035,951, 33698,1014,930, 33697,1013,929, 33696,1012,928, 
15, // chain 41
948,1032,948, 949,1033,949, 952,1036,952, 
953,1037,953, 33722,1038,954, 33723,1039,955, 33724,1040,956, 33717,1033,949, 957,1041,957, 33718,1034,950, 958,1042,958, 33727,1043,959, 33728,1044,960, 33719,1035,951, 961,1045,961, 33699,1015,931, 33698,1014,930, 
55, // chain 42
926,1010,926, 948,1032,948, 953,1037,953, 
603,1009,603, 33372,1046,604, 33722,1038,954, 606,1047,606, 33377,1048,609, 33723,1039,955, 611,1049,611, 33730,1050,962, 33724,1040,956, 963,1051,963, 33725,1041,957, 964,1052,964, 33726,1042,958, 965,1053,965, 33734,1054,966, 33727,1043,959, 
967,1055,967, 33736,1056,968, 33728,1044,960, 969,1057,969, 33729,1045,961, 970,1058,970, 33739,1059,971, 33699,1015,931, 932,1016,932, 972,1060,972, 33701,1017,933, 973,1061,973, 33702,1018,934, 974,1062,974, 33743,1063,975, 33703,1019,935, 
936,1020,936, 976,1064,976, 33705,1021,937, 977,1065,977, 33706,1022,938, 978,1066,978, 33747,1067,979, 33707,1023,939, 940,1024,940, 980,1068,980, 33709,1025,941, 981,1069,981, 33710,1026,942, 982,1070,982, 33751,1071,983, 33711,1027,943, 
944,1028,944, 984,1072,984, 33713,1029,945, 985,1073,985, 33563,860,795, 33562,859,794, 
1, // chain 43
927,1011,927, 948,1032,948, 926,1010,926, 
40, // chain 44
29,1074,29, 30,1075,30, 986,1076,986, 
33755,1077,987, 32838,1078,70, 988,1079,988, 32839,1080,71, 989,1081,989, 32840,1082,72, 990,1083,990, 33047,1084,279, 991,1085,991, 32877,1086,109, 992,1087,992, 32878,1088,110, 993,1089,993, 32879,1090,111, 994,1091,994, 33079,1092,311, 
995,1093,995, 33066,1094,298, 996,1095,996, 33067,1096,299, 997,1097,997, 33068,1098,300, 998,1099,998, 33199,1100,431, 999,1101,999, 33198,1102,430, 1000,1103,1000, 33197,1104,429, 1001,1105,1001, 33196,1106,428, 1002,1107,1002, 33248,1108,480, 
1003,1109,1003, 33244,1110,476, 1004,1111,1004, 33773,1112,1005, 33245,1113,477, 567,1114,567, 33246,1115,478, 
121, // chain 45
987,1077,987, 988,1079,988, 1006,1116,1006, 
33775,1117,1007, 33757,1081,989, 1008,1118,1008, 33758,1083,990, 1009,1119,1009, 33759,1085,991, 1010,1120,1010, 33760,1087,992, 1011,1121,1011, 33761,1089,993, 1012,1122,1012, 33762,1091,994, 1013,1123,1013, 33763,1093,995, 1014,1124,1014, 33764,1095,996, 
1015,1125,1015, 33765,1097,997, 1016,1126,1016, 33766,1099,998, 1017,1127,1017, 33767,1101,999, 1018,1128,1018, 33768,1103,1000, 1019,1129,1019, 33769,1105,1001, 1020,1130,1020, 33770,1107,1002, 1021,1131,1021, 33771,1109,1003, 1022,1132,1022, 33772,1111,1004, 
1023,1133,1023, 33773,1112,1005, 1024,1134,1024, 33335,1114,567, 565,1135,565, 1025,1136,1025, 33331,1137,563, 1026,1138,1026, 33330,1139,562, 1027,1140,1027, 33328,1141,560, 1028,1142,1028, 33326,1143,558, 1029,1144,1029, 33324,1145,556, 1030,1146,1030, 
33322,1147,554, 1031,1148,1031, 33320,1149,552, 1032,1150,1032, 33318,1151,550, 1033,1152,1033, 33316,1153,548, 1034,1154,1034, 33314,1155,546, 1035,1156,1035, 33312,1157,544, 1036,1158,1036, 33310,1159,542, 1037,1160,1037, 33308,1161,540, 1038,1162,1038, 
33306,1163,538, 1039,1164,1039, 33304,1165,536, 1040,1166,1040, 33302,1167,534, 1041,1168,1041, 33300,1169,532, 1042,1170,1042, 33297,1171,529, 527,1172,527, 1043,1173,1043, 33293,1174,525, 1044,1175,1044, 33291,1176,523, 1045,1177,1045, 33289,1178,521, 
1046,1179,1046, 33287,1180,519, 1047,1181,1047, 33285,1182,517, 1048,1183,1048, 33284,1184,516, 1049,1185,1049, 33282,1186,514, 1050,1187,1050, 33280,1188,512, 1051,1189,1051, 33820,1190,1052, 33278,1191,510, 1053,1192,1053, 33276,1193,508, 1054,1194,1054, 
33274,1195,506, 1055,1196,1055, 33272,1197,504, 1056,1198,1056, 33270,1199,502, 1057,1200,1057, 33268,1201,500, 1058,1202,1058, 33266,1203,498, 496,1204,496, 1059,1205,1059, 33262,1206,494, 1060,1207,1060, 33260,1208,492, 1061,1209,1061, 33258,1210,490, 
1062,1211,1062, 33256,1212,488, 1063,1213,1063, 33254,1214,486, 1064,1215,1064, 33252,1216,484, 471,478,471, 33238,477,470, 
144, // chain 46
1007,1117,1007, 1008,1118,1008, 1065,1217,1065, 
33834,1218,1066, 33777,1119,1009, 1067,1219,1067, 33778,1120,1010, 1068,1220,1068, 33779,1121,1011, 1069,1221,1069, 33780,1122,1012, 1070,1222,1070, 33781,1123,1013, 1071,1223,1071, 33782,1124,1014, 1072,1224,1072, 33783,1125,1015, 1073,1225,1073, 33784,1126,1016, 
1074,1226,1074, 33785,1127,1017, 1075,1227,1075, 33786,1128,1018, 1076,1228,1076, 33787,1129,1019, 1077,1229,1077, 33788,1130,1020, 1078,1230,1078, 33789,1131,1021, 1079,1231,1079, 33790,1132,1022, 1080,1232,1080, 33791,1133,1023, 1081,1233,1081, 33792,1134,1024, 
1025,1136,1025, 1082,1234,1082, 33794,1138,1026, 1083,1235,1083, 33795,1140,1027, 1084,1236,1084, 33796,1142,1028, 1085,1237,1085, 33797,1144,1029, 1086,1238,1086, 33798,1146,1030, 1087,1239,1087, 33799,1148,1031, 1088,1240,1088, 33800,1150,1032, 1089,1241,1089, 
33801,1152,1033, 1090,1242,1090, 33802,1154,1034, 1091,1243,1091, 33803,1156,1035, 1092,1244,1092, 33804,1158,1036, 1093,1245,1093, 33805,1160,1037, 1094,1246,1094, 33806,1162,1038, 1095,1247,1095, 33807,1164,1039, 1096,1248,1096, 33808,1166,1040, 1097,1249,1097, 
33809,1168,1041, 1042,1170,1042, 1098,1250,1098, 33811,1173,1043, 1099,1251,1099, 33812,1175,1044, 1100,1252,1100, 33813,1177,1045, 1101,1253,1101, 33814,1179,1046, 1102,1254,1102, 33815,1181,1047, 1103,1255,1103, 33816,1183,1048, 1104,1256,1104, 33817,1185,1049, 
1105,1257,1105, 33818,1187,1050, 1106,1258,1106, 33819,1189,1051, 1107,1259,1107, 33876,1260,1108, 33820,1190,1052, 1109,1261,1109, 33821,1192,1053, 1110,1262,1110, 33822,1194,1054, 1111,1263,1111, 33823,1196,1055, 1112,1264,1112, 33824,1198,1056, 1113,1265,1113, 
33825,1200,1057, 1114,1266,1114, 33826,1202,1058, 1059,1205,1059, 1115,1267,1115, 33828,1207,1060, 1116,1268,1116, 33829,1209,1061, 1117,1269,1117, 33830,1211,1062, 1118,1270,1118, 33831,1213,1063, 1119,1271,1119, 33832,1215,1064, 1120,1272,1120, 33239,478,471, 
472,479,472, 1121,1273,1121, 33202,441,434, 435,442,435, 1122,1274,1122, 33204,443,436, 1123,1275,1123, 33205,444,437, 1124,1276,1124, 33206,445,438, 1125,1277,1125, 33207,446,439, 1126,1278,1126, 33895,1279,1127, 33208,447,440, 1128,1280,1128, 
33897,1281,1129, 33209,448,441, 1130,1282,1130, 33210,449,442, 1131,1283,1131, 33211,450,443, 1132,1284,1132, 33212,451,444, 1133,1285,1133, 33213,452,445, 1134,1286,1134, 33214,453,446, 1135,1287,1135, 33216,455,448, 33215,454,447, 
106, // chain 47
1066,1218,1066, 1067,1219,1067, 1136,1288,1136, 
33905,1289,1137, 33836,1220,1068, 1138,1290,1138, 33837,1221,1069, 1139,1291,1139, 33838,1222,1070, 1140,1292,1140, 33839,1223,1071, 1141,1293,1141, 33840,1224,1072, 1142,1294,1142, 33841,1225,1073, 1143,1295,1143, 33912,1296,1144, 33842,1226,1074, 1145,1297,1145, 
33843,1227,1075, 1146,1298,1146, 33844,1228,1076, 1147,1299,1147, 33845,1229,1077, 1148,1300,1148, 33846,1230,1078, 1079,1231,1079, 1149,1301,1149, 33848,1232,1080, 1150,1302,1150, 33849,1233,1081, 1082,1234,1082, 1151,1303,1151, 33851,1235,1083, 1152,1304,1152, 
33852,1236,1084, 1153,1305,1153, 33853,1237,1085, 1154,1306,1154, 33854,1238,1086, 1155,1307,1155, 33855,1239,1087, 1156,1308,1156, 33856,1240,1088, 1157,1309,1157, 33857,1241,1089, 1158,1310,1158, 33858,1242,1090, 1159,1311,1159, 33859,1243,1091, 1160,1312,1160, 
33860,1244,1092, 1161,1313,1161, 33861,1245,1093, 1162,1314,1162, 33862,1246,1094, 1095,1247,1095, 1163,1315,1163, 33864,1248,1096, 1164,1316,1164, 33865,1249,1097, 1165,1317,1165, 33866,1250,1098, 1166,1318,1166, 33867,1251,1099, 1167,1319,1167, 33936,1320,1168, 
33868,1252,1100, 1169,1321,1169, 33869,1253,1101, 1170,1322,1170, 33870,1254,1102, 1103,1255,1103, 1171,1323,1171, 33872,1256,1104, 1172,1324,1172, 33873,1257,1105, 1173,1325,1173, 33874,1258,1106, 1174,1326,1174, 33875,1259,1107, 1175,1327,1175, 33944,1328,1176, 
33876,1260,1108, 1177,1329,1177, 33877,1261,1109, 1178,1330,1178, 33878,1262,1110, 1179,1331,1179, 33879,1263,1111, 1180,1332,1180, 33880,1264,1112, 1181,1333,1181, 33881,1265,1113, 1182,1334,1182, 33882,1266,1114, 1183,1335,1183, 33883,1267,1115, 1184,1336,1184, 
33884,1268,1116, 1185,1337,1185, 33885,1269,1117, 1186,1338,1186, 33886,1270,1118, 1187,1339,1187, 33887,1271,1119, 1121,1273,1121, 33888,1272,1120, 
119, // chain 48
1006,1116,1006, 1188,1340,1188, 1189,1341,1189, 
987,1077,987, 33754,1076,986, 33958,1342,1190, 33959,1343,1191, 33956,1340,1188, 1192,1344,1192, 33961,1345,1193, 33962,1346,1194, 33774,1116,1006, 1007,1117,1007, 1065,1217,1065, 1195,1347,1195, 33964,1348,1196, 33834,1218,1066, 1136,1288,1136, 1197,1349,1197, 
33966,1350,1198, 33905,1289,1137, 1199,1351,1199, 33906,1290,1138, 1200,1352,1200, 33907,1291,1139, 1201,1353,1201, 33908,1292,1140, 1202,1354,1202, 33909,1293,1141, 1203,1355,1203, 33972,1356,1204, 33910,1294,1142, 1205,1357,1205, 33911,1295,1143, 1206,1358,1206, 
33912,1296,1144, 1207,1359,1207, 33913,1297,1145, 1146,1298,1146, 1208,1360,1208, 33915,1299,1147, 1209,1361,1209, 33916,1300,1148, 1210,1362,1210, 33917,1301,1149, 1211,1363,1211, 33918,1302,1150, 1151,1303,1151, 1212,1364,1212, 33920,1304,1152, 1213,1365,1213, 
33921,1305,1153, 1214,1366,1214, 33922,1306,1154, 1215,1367,1215, 33923,1307,1155, 1216,1368,1216, 33924,1308,1156, 1217,1369,1217, 33925,1309,1157, 1218,1370,1218, 33926,1310,1158, 1219,1371,1219, 33927,1311,1159, 1220,1372,1220, 33928,1312,1160, 1221,1373,1221, 
33929,1313,1161, 1222,1374,1222, 33930,1314,1162, 1163,1315,1163, 1223,1375,1223, 33932,1316,1164, 1224,1376,1224, 33933,1317,1165, 1225,1377,1225, 33934,1318,1166, 1226,1378,1226, 33935,1319,1167, 1227,1379,1227, 33996,1380,1228, 33936,1320,1168, 1229,1381,1229, 
33937,1321,1169, 1230,1382,1230, 33938,1322,1170, 1171,1323,1171, 1231,1383,1231, 33940,1324,1172, 1232,1384,1232, 33941,1325,1173, 1233,1385,1233, 33942,1326,1174, 1234,1386,1234, 33943,1327,1175, 1235,1387,1235, 34004,1388,1236, 33944,1328,1176, 1237,1389,1237, 
33945,1329,1177, 1238,1390,1238, 33946,1330,1178, 1239,1391,1239, 33947,1331,1179, 1240,1392,1240, 33948,1332,1180, 1241,1393,1241, 33949,1333,1181, 1242,1394,1242, 33950,1334,1182, 1243,1395,1243, 33951,1335,1183, 1244,1396,1244, 33952,1336,1184, 1245,1397,1245, 
33953,1337,1185, 1246,1398,1246, 33954,1338,1186, 1122,1274,1122, 33955,1339,1187, 1121,1273,1121, 
9, // chain 49
829,894,829, 1247,1399,1247, 1248,1400,1248, 
828,893,828, 34017,1401,1249, 34018,1402,1250, 34015,1399,1247, 1251,1403,1251, 33538,835,770, 33598,895,830, 33597,894,829, 
6, // chain 50
1252,1404,1252, 773,838,773, 1253,1405,1253, 
1254,1406,1254, 34023,1407,1255, 34024,1408,1256, 33542,839,774, 33541,838,773, 
43, // chain 51
772,837,772, 773,838,773, 1252,1404,1252, 
771,836,771, 34019,1403,1251, 34022,1406,1254, 1250,1402,1250, 34025,1409,1257, 34026,1410,1258, 34023,1407,1255, 1259,1411,1259, 34028,1412,1260, 34024,1408,1256, 1261,1413,1261, 34030,1414,1262, 33542,839,774, 775,840,775, 1263,1415,1263, 33544,841,776, 
777,842,777, 1264,1416,1264, 33546,843,778, 1265,1417,1265, 34034,1418,1266, 33547,844,779, 780,845,780, 1267,1419,1267, 33549,846,781, 1268,1420,1268, 33550,847,782, 1269,1421,1269, 33551,848,783, 1270,1422,1270, 33552,849,784, 1271,1423,1271, 
33553,850,785, 1272,1424,1272, 33554,851,786, 1273,1425,1273, 34042,1426,1274, 33555,852,787, 1275,1427,1275, 33556,853,788, 619,629,619, 33385,627,617, 
1, // chain 52
771,836,771, 1251,1403,1251, 770,835,770, 
26, // chain 53
1276,1428,1276, 1265,1417,1265, 1277,1429,1277, 
1278,1430,1278, 34047,1431,1279, 34048,1432,1280, 34033,1417,1265, 1266,1418,1266, 1267,1419,1267, 1281,1433,1281, 34036,1420,1268, 1282,1434,1282, 34037,1421,1269, 1283,1435,1283, 34038,1422,1270, 1284,1436,1284, 34039,1423,1271, 1285,1437,1285, 34040,1424,1272, 
1286,1438,1286, 34041,1425,1273, 1287,1439,1287, 34056,1440,1288, 34042,1426,1274, 1289,1441,1289, 34043,1427,1275, 621,631,621, 33387,629,619, 
30, // chain 54
1264,1416,1264, 1265,1417,1265, 1276,1428,1276, 
1290,1442,1290, 34059,1443,1291, 34046,1430,1278, 1292,1444,1292, 34061,1445,1293, 34047,1431,1279, 1294,1446,1294, 34063,1447,1295, 34048,1432,1280, 1281,1433,1281, 1296,1448,1296, 34050,1434,1282, 1297,1449,1297, 34051,1435,1283, 1298,1450,1298, 34052,1436,1284, 
1299,1451,1299, 34053,1437,1285, 1300,1452,1300, 34054,1438,1286, 1301,1453,1301, 34055,1439,1287, 1302,1454,1302, 34071,1455,1303, 34056,1440,1288, 1304,1456,1304, 34057,1441,1289, 622,632,622, 33389,631,621, 
3, // chain 55
1261,1413,1261, 1262,1414,1262, 1290,1442,1290, 
34031,1415,1263, 1264,1416,1264, 
2, // chain 56
1195,1347,1195, 1305,1457,1305, 1193,1345,1193, 
1194,1346,1194, 
6, // chain 57
1305,1457,1305, 1195,1347,1195, 1306,1458,1306, 
1307,1459,1307, 34076,1460,1308, 33965,1349,1197, 33964,1348,1196, 33963,1347,1195, 
6, // chain 58
1308,1460,1308, 1197,1349,1197, 1309,1461,1309, 
1310,1462,1310, 34079,1463,1311, 34080,1464,1312, 33966,1350,1198, 33965,1349,1197, 
95, // chain 59
1198,1350,1198, 1199,1351,1199, 1312,1464,1312, 
34081,1465,1313, 33968,1352,1200, 1314,1466,1314, 33969,1353,1201, 1315,1467,1315, 33970,1354,1202, 1316,1468,1316, 33971,1355,1203, 1317,1469,1317, 34086,1470,1318, 33972,1356,1204, 1319,1471,1319, 33973,1357,1205, 1320,1472,1320, 33974,1358,1206, 1207,1359,1207, 
1321,1473,1321, 33976,1360,1208, 1322,1474,1322, 33977,1361,1209, 1323,1475,1323, 33978,1362,1210, 1324,1476,1324, 33979,1363,1211, 1212,1364,1212, 1325,1477,1325, 33981,1365,1213, 1326,1478,1326, 33982,1366,1214, 1327,1479,1327, 33983,1367,1215, 1328,1480,1328, 
33984,1368,1216, 1329,1481,1329, 33985,1369,1217, 1330,1482,1330, 33986,1370,1218, 1331,1483,1331, 33987,1371,1219, 1332,1484,1332, 33988,1372,1220, 1333,1485,1333, 33989,1373,1221, 1334,1486,1334, 33990,1374,1222, 1223,1375,1223, 1335,1487,1335, 33992,1376,1224, 
1336,1488,1336, 33993,1377,1225, 1337,1489,1337, 33994,1378,1226, 1338,1490,1338, 34107,1491,1339, 33995,1379,1227, 1340,1492,1340, 33996,1380,1228, 1341,1493,1341, 33997,1381,1229, 1342,1494,1342, 33998,1382,1230, 1343,1495,1343, 33999,1383,1231, 1232,1384,1232, 
1344,1496,1344, 34001,1385,1233, 1345,1497,1345, 34002,1386,1234, 1346,1498,1346, 34003,1387,1235, 1347,1499,1347, 34116,1500,1348, 34004,1388,1236, 1349,1501,1349, 34005,1389,1237, 1350,1502,1350, 34006,1390,1238, 1351,1503,1351, 34007,1391,1239, 1352,1504,1352, 
34008,1392,1240, 1353,1505,1353, 34009,1393,1241, 1354,1506,1354, 34010,1394,1242, 1243,1395,1243, 1355,1507,1355, 34012,1396,1244, 1356,1508,1356, 34013,1397,1245, 1357,1509,1357, 34014,1398,1246, 1123,1275,1123, 33890,1274,1122, 
6, // chain 60
1311,1463,1311, 1312,1464,1312, 1358,1510,1358, 
1359,1511,1359, 34128,1512,1360, 34129,1513,1361, 34081,1465,1313, 34080,1464,1312, 
8, // chain 61
1360,1512,1360, 1361,1513,1361, 1362,1514,1362, 
1363,1515,1363, 34132,1516,1364, 34133,1517,1365, 34134,1518,1366, 34129,1513,1361, 1314,1466,1314, 34081,1465,1313, 
21, // chain 62
1307,1459,1307, 1308,1460,1308, 1367,1519,1367, 
34078,1462,1310, 1368,1520,1368, 34137,1521,1369, 34079,1463,1311, 1359,1511,1359, 1370,1522,1370, 34139,1523,1371, 34128,1512,1360, 1363,1515,1363, 1372,1524,1372, 34141,1525,1373, 34132,1516,1364, 1374,1526,1374, 34143,1527,1375, 34133,1517,1365, 1376,1528,1376, 
34145,1529,1377, 34134,1518,1366, 1315,1467,1315, 34082,1466,1314, 
86, // chain 63
1377,1529,1377, 1316,1468,1316, 1378,1530,1378, 
1376,1528,1376, 34147,1531,1379, 34148,1532,1380, 34149,1533,1381, 34084,1468,1316, 1317,1469,1317, 1382,1534,1382, 34086,1470,1318, 1383,1535,1383, 34087,1471,1319, 1384,1536,1384, 34088,1472,1320, 1321,1473,1321, 1385,1537,1385, 34090,1474,1322, 1386,1538,1386, 
34091,1475,1323, 1387,1539,1387, 34092,1476,1324, 1325,1477,1325, 1388,1540,1388, 34094,1478,1326, 1389,1541,1389, 34095,1479,1327, 1390,1542,1390, 34096,1480,1328, 1391,1543,1391, 34097,1481,1329, 1392,1544,1392, 34098,1482,1330, 1393,1545,1393, 34099,1483,1331, 
1394,1546,1394, 34100,1484,1332, 1333,1485,1333, 1395,1547,1395, 34102,1486,1334, 1396,1548,1396, 34103,1487,1335, 1397,1549,1397, 34104,1488,1336, 1398,1550,1398, 34105,1489,1337, 1399,1551,1399, 34106,1490,1338, 1400,1552,1400, 34169,1553,1401, 34107,1491,1339, 
1402,1554,1402, 34108,1492,1340, 1403,1555,1403, 34109,1493,1341, 1404,1556,1404, 34110,1494,1342, 1405,1557,1405, 34111,1495,1343, 1344,1496,1344, 1406,1558,1406, 34113,1497,1345, 1407,1559,1407, 34114,1498,1346, 1408,1560,1408, 34115,1499,1347, 1409,1561,1409, 
34178,1562,1410, 34116,1500,1348, 1411,1563,1411, 34117,1501,1349, 1412,1564,1412, 34118,1502,1350, 1413,1565,1413, 34119,1503,1351, 1414,1566,1414, 34120,1504,1352, 1415,1567,1415, 34121,1505,1353, 1416,1568,1416, 34122,1506,1354, 1355,1507,1355, 1126,1278,1126, 
34124,1508,1356, 1125,1277,1125, 34125,1509,1357, 1124,1276,1124, 33891,1275,1123, 
1, // chain 64
1315,1467,1315, 1316,1468,1316, 1377,1529,1377, 
5, // chain 65
1417,1569,1417, 1385,1537,1385, 1418,1570,1418, 
1419,1571,1419, 34188,1572,1420, 34154,1538,1386, 34153,1537,1385, 
12, // chain 66
1384,1536,1384, 1385,1537,1385, 1417,1569,1417, 
1383,1535,1383, 34189,1573,1421, 34190,1574,1422, 34187,1571,1419, 1423,1575,1423, 34192,1576,1424, 34193,1577,1425, 34188,1572,1420, 1388,1540,1388, 34155,1539,1387, 34154,1538,1386, 
14, // chain 67
1383,1535,1383, 1421,1573,1421, 1382,1534,1382, 
34194,1578,1426, 34195,1579,1427, 34190,1574,1422, 1423,1575,1423, 1428,1580,1428, 34197,1581,1429, 34198,1582,1430, 34192,1576,1424, 1431,1583,1431, 34200,1584,1432, 34193,1577,1425, 1389,1541,1389, 34156,1540,1388, 
7, // chain 68
827,892,827, 1249,1401,1249, 1433,1585,1433, 
826,891,826, 34202,1586,1434, 34203,1587,1435, 34025,1409,1257, 34017,1401,1249, 1250,1402,1250, 
1, // chain 69
828,893,828, 1249,1401,1249, 827,892,827, 
10, // chain 70
825,890,825, 1434,1586,1434, 1436,1588,1436, 
824,889,824, 34205,1589,1437, 34206,1590,1438, 34207,1591,1439, 34202,1586,1434, 1435,1587,1435, 1440,1592,1440, 34026,1410,1258, 34025,1409,1257, 
1, // chain 71
826,891,826, 1434,1586,1434, 825,890,825, 
24, // chain 72
1441,1593,1441, 1442,1594,1442, 1443,1595,1443, 
1444,1596,1444, 34213,1597,1445, 34214,1598,1446, 34215,1599,1447, 34210,1594,1442, 1261,1413,1261, 34028,1412,1260, 34027,1411,1259, 34209,1593,1441, 1440,1592,1440, 34216,1600,1448, 34212,1596,1444, 1449,1601,1449, 34218,1602,1450, 34213,1597,1445, 1451,1603,1451, 
34220,1604,1452, 34214,1598,1446, 1292,1444,1292, 34059,1443,1291, 34215,1599,1447, 1290,1442,1290, 34029,1413,1261, 
48, // chain 73
1438,1590,1438, 1448,1600,1448, 1449,1601,1449, 
1453,1605,1453, 34222,1606,1454, 34218,1602,1450, 1455,1607,1455, 34219,1603,1451, 1456,1608,1456, 34225,1609,1457, 34220,1604,1452, 1458,1610,1458, 34060,1444,1292, 1293,1445,1293, 1459,1611,1459, 34062,1446,1294, 1460,1612,1460, 34229,1613,1461, 34063,1447,1295, 
1296,1448,1296, 1462,1614,1462, 34065,1449,1297, 1463,1615,1463, 34066,1450,1298, 1464,1616,1464, 34067,1451,1299, 1465,1617,1465, 34068,1452,1300, 1466,1618,1466, 34069,1453,1301, 1467,1619,1467, 34070,1454,1302, 1468,1620,1468, 34237,1621,1469, 34071,1455,1303, 
1470,1622,1470, 34072,1456,1304, 1471,1623,1471, 33390,632,622, 623,633,623, 1472,1624,1472, 34241,1625,1473, 33392,634,624, 1474,1626,1474, 34243,1627,1475, 33393,635,625, 1476,1628,1476, 33394,637,626, 629,643,629, 33395,639,627, 
2, // chain 74
1448,1600,1448, 1438,1590,1438, 1439,1591,1439, 
1440,1592,1440, 
40, // chain 75
1477,1629,1477, 1460,1612,1460, 1478,1630,1478, 
1479,1631,1479, 34248,1632,1480, 34249,1633,1481, 34250,1634,1482, 34228,1612,1460, 1461,1613,1461, 1462,1614,1462, 1483,1635,1483, 34231,1615,1463, 1484,1636,1484, 34232,1616,1464, 1485,1637,1485, 34233,1617,1465, 1486,1638,1486, 34234,1618,1466, 1487,1639,1487, 
34235,1619,1467, 1488,1640,1488, 34236,1620,1468, 1489,1641,1489, 34258,1642,1490, 34237,1621,1469, 1491,1643,1491, 34238,1622,1470, 1492,1644,1492, 34239,1623,1471, 1493,1645,1493, 34240,1624,1472, 1494,1646,1494, 34241,1625,1473, 1495,1647,1495, 34242,1626,1474, 
1496,1648,1496, 34265,1649,1497, 34243,1627,1475, 1498,1650,1498, 34244,1628,1476, 632,646,632, 33397,643,629, 
13, // chain 76
1459,1611,1459, 1460,1612,1460, 1477,1629,1477, 
1499,1651,1499, 34268,1652,1500, 34247,1631,1479, 1501,1653,1501, 34270,1654,1502, 34248,1632,1480, 1503,1655,1503, 34272,1656,1504, 34249,1633,1481, 1505,1657,1505, 34251,1635,1483, 34250,1634,1482, 
18, // chain 77
1457,1609,1457, 1458,1610,1458, 1499,1651,1499, 
1506,1658,1506, 34268,1652,1500, 1507,1659,1507, 34269,1653,1501, 1508,1660,1508, 34277,1661,1509, 34270,1654,1502, 1510,1662,1510, 34271,1655,1503, 1511,1663,1511, 34280,1664,1512, 34272,1656,1504, 1513,1665,1513, 34273,1657,1505, 1514,1666,1514, 34252,1636,1484, 
34251,1635,1483, 
7, // chain 78
1514,1666,1514, 1485,1637,1485, 1515,1667,1515, 
1516,1668,1516, 34285,1669,1517, 34286,1670,1518, 34287,1671,1519, 34254,1638,1486, 34253,1637,1485, 
1, // chain 79
1484,1636,1484, 1485,1637,1485, 1514,1666,1514, 
26, // chain 80
1520,1672,1520, 1489,1641,1489, 1521,1673,1521, 
1522,1674,1522, 34291,1675,1523, 34292,1676,1524, 34257,1641,1489, 1490,1642,1490, 1525,1677,1525, 34259,1643,1491, 1492,1644,1492, 1526,1678,1526, 34261,1645,1493, 1527,1679,1527, 34296,1680,1528, 34297,1681,1529, 34262,1646,1494, 1530,1682,1530, 34263,1647,1495, 
1531,1683,1531, 34264,1648,1496, 1532,1684,1532, 34301,1685,1533, 34265,1649,1497, 1534,1686,1534, 34266,1650,1498, 634,648,634, 33400,646,632, 
163, // chain 81
1488,1640,1488, 1489,1641,1489, 1520,1672,1520, 
1535,1687,1535, 34304,1688,1536, 34290,1674,1522, 1537,1689,1537, 34306,1690,1538, 34307,1691,1539, 34291,1675,1523, 1540,1692,1540, 34309,1693,1541, 34292,1676,1524, 1525,1677,1525, 1542,1694,1542, 34294,1678,1526, 1543,1695,1543, 34295,1679,1527, 1544,1696,1544, 
34313,1697,1545, 34296,1680,1528, 1546,1698,1546, 34315,1699,1547, 34297,1681,1529, 1548,1700,1548, 34298,1682,1530, 1549,1701,1549, 34299,1683,1531, 1550,1702,1550, 34300,1684,1532, 1551,1703,1551, 34301,1685,1533, 1552,1704,1552, 34302,1686,1534, 1553,1705,1553, 
33402,648,634, 635,649,635, 1554,1706,1554, 33405,651,637, 1555,1707,1555, 33408,654,640, 1556,1708,1556, 33410,656,642, 1557,1709,1557, 33411,657,643, 1558,1710,1558, 33413,659,645, 1559,1711,1559, 33416,662,648, 650,664,650, 1560,1712,1560, 
34329,1713,1561, 33419,665,651, 1562,1714,1562, 33421,667,653, 656,670,656, 1563,1715,1563, 33426,672,658, 1564,1716,1564, 34333,1717,1565, 33427,673,659, 1566,1718,1566, 33429,675,661, 664,678,664, 1567,1719,1567, 33434,680,666, 1568,1720,1568, 
34337,1721,1569, 33435,681,667, 1570,1722,1570, 33437,683,669, 672,686,672, 673,689,673, 1571,1723,1571, 33442,691,674, 1572,1724,1572, 33443,693,675, 1573,1725,1573, 33444,695,676, 1574,1726,1574, 33445,697,677, 1575,1727,1575, 33446,699,678, 
1576,1728,1576, 33447,701,679, 1577,1729,1577, 33448,703,680, 1578,1730,1578, 33449,705,681, 1579,1731,1579, 33450,707,682, 683,710,683, 1580,1732,1580, 33452,712,684, 1581,1733,1581, 33453,714,685, 1582,1734,1582, 33454,716,686, 1583,1735,1583, 
33455,718,687, 1584,1736,1584, 33456,720,688, 1585,1737,1585, 33457,722,689, 1586,1738,1586, 33458,724,690, 1587,1739,1587, 33459,726,691, 1588,1740,1588, 34357,1741,1589, 33460,727,692, 1590,1742,1590, 33461,729,693, 1591,1743,1591, 33462,731,694, 
1592,1744,1592, 33463,733,695, 1593,1745,1593, 33464,735,696, 1594,1746,1594, 33465,737,697, 698,739,698, 1595,1747,1595, 33467,742,699, 1596,1748,1596, 33468,744,700, 1597,1749,1597, 33469,746,701, 1598,1750,1598, 33470,748,702, 1599,1751,1599, 
33471,750,703, 1600,1752,1600, 33472,752,704, 1601,1753,1601, 33473,754,705, 1602,1754,1602, 33474,756,706, 1603,1755,1603, 33475,758,707, 1604,1756,1604, 33476,760,708, 1605,1757,1605, 33477,762,709, 1606,1758,1606, 33478,764,710, 1607,1759,1607, 
33479,766,711, 1608,1760,1608, 33480,768,712, 1609,1761,1609, 33481,770,713, 1610,1762,1610, 33482,772,714, 1611,1763,1611, 33483,774,715, 1612,1764,1612, 34381,1765,1613, 33484,775,716, 1614,1766,1614, 33485,777,717, 1615,1767,1615, 33486,779,718, 
670,1768,670, 33439,781,671, 
75, // chain 82
1519,1671,1519, 1487,1639,1487, 1535,1687,1535, 
1616,1769,1616, 34304,1688,1536, 1537,1689,1537, 1617,1770,1617, 34386,1771,1618, 34306,1690,1538, 1619,1772,1619, 34388,1773,1620, 34307,1691,1539, 1621,1774,1621, 34308,1692,1540, 1622,1775,1622, 34391,1776,1623, 34392,1777,1624, 34309,1693,1541, 1542,1694,1542, 
1625,1778,1625, 34311,1695,1543, 1626,1779,1626, 34312,1696,1544, 1627,1780,1627, 34396,1781,1628, 34313,1697,1545, 1629,1782,1629, 34314,1698,1546, 1630,1783,1630, 34399,1784,1631, 34315,1699,1547, 1632,1785,1632, 34401,1786,1633, 34316,1700,1548, 1549,1701,1549, 
1634,1787,1634, 34318,1702,1550, 1635,1788,1635, 34319,1703,1551, 1636,1789,1636, 34405,1790,1637, 34320,1704,1552, 1638,1791,1638, 34321,1705,1553, 1554,1706,1554, 1639,1792,1639, 34323,1707,1555, 1640,1793,1640, 34324,1708,1556, 1641,1794,1641, 34325,1709,1557, 
1642,1795,1642, 34326,1710,1558, 1643,1796,1643, 34327,1711,1559, 1560,1712,1560, 1644,1797,1644, 34413,1798,1645, 34329,1713,1561, 1646,1799,1646, 34330,1714,1562, 1563,1715,1563, 1647,1800,1647, 34332,1716,1564, 1648,1801,1648, 34417,1802,1649, 34333,1717,1565, 
1650,1803,1650, 34334,1718,1566, 1567,1719,1567, 1651,1804,1651, 34336,1720,1568, 1652,1805,1652, 34421,1806,1653, 34337,1721,1569, 1571,1723,1571, 34338,1722,1570, 
1, // chain 83
1486,1638,1486, 1487,1639,1487, 1519,1671,1519, 
24, // chain 84
1368,1520,1368, 1369,1521,1369, 1654,1807,1654, 
34138,1522,1370, 1655,1808,1655, 34424,1809,1656, 34139,1523,1371, 1372,1524,1372, 1657,1810,1657, 34426,1811,1658, 34141,1525,1373, 1659,1812,1659, 34142,1526,1374, 1660,1813,1660, 34429,1814,1661, 34143,1527,1375, 1662,1815,1662, 34144,1528,1376, 1379,1531,1379, 
1663,1816,1663, 34432,1817,1664, 34148,1532,1380, 1665,1818,1665, 34194,1578,1426, 34149,1533,1381, 1382,1534,1382, 
15, // chain 85
1659,1812,1659, 1660,1813,1660, 1666,1819,1666, 
34435,1820,1667, 34436,1821,1668, 34429,1814,1661, 1669,1822,1669, 34430,1815,1662, 1670,1823,1670, 34431,1816,1663, 1671,1824,1671, 34432,1817,1664, 1672,1825,1672, 34433,1818,1665, 1428,1580,1428, 34195,1579,1427, 34194,1578,1426, 
35, // chain 86
1655,1808,1655, 1656,1809,1656, 1673,1826,1673, 
34425,1810,1657, 1674,1827,1674, 34426,1811,1658, 1675,1828,1675, 34427,1812,1659, 1666,1819,1666, 1676,1829,1676, 34445,1830,1677, 34435,1820,1667, 1678,1831,1678, 34447,1832,1679, 34436,1821,1668, 1680,1833,1680, 34449,1834,1681, 34437,1822,1669, 1682,1835,1682, 
34438,1823,1670, 1683,1836,1683, 34439,1824,1671, 1684,1837,1684, 34440,1825,1672, 1685,1838,1685, 34196,1580,1428, 1429,1581,1429, 1686,1839,1686, 34455,1840,1687, 34198,1582,1430, 1688,1841,1688, 34199,1583,1431, 1392,1544,1392, 34159,1543,1391, 34158,1542,1390, 
34200,1584,1432, 1389,1541,1389, 
13, // chain 87
1689,1842,1689, 1682,1835,1682, 1683,1836,1683, 
1690,1843,1690, 34452,1837,1684, 1691,1844,1691, 34453,1838,1685, 1686,1839,1686, 1692,1845,1692, 34461,1846,1693, 34455,1840,1687, 1694,1847,1694, 34456,1841,1688, 1393,1545,1393, 34160,1544,1392, 
18, // chain 88
1682,1835,1682, 1689,1842,1689, 1695,1848,1695, 
1681,1834,1681, 34448,1833,1680, 34464,1849,1696, 34465,1850,1697, 34457,1842,1689, 1698,1851,1698, 34458,1843,1690, 1699,1852,1699, 34459,1844,1691, 1692,1845,1692, 1700,1853,1700, 34469,1854,1701, 34461,1846,1693, 1702,1855,1702, 34462,1847,1694, 1394,1546,1394, 
34161,1545,1393, 
7, // chain 89
823,888,823, 1437,1589,1437, 1703,1856,1703, 
822,887,822, 34472,1857,1704, 34473,1858,1705, 34221,1605,1453, 34205,1589,1437, 1438,1590,1438, 
1, // chain 90
824,889,824, 1437,1589,1437, 823,888,823, 
11, // chain 91
821,886,821, 1704,1857,1704, 1706,1859,1706, 
820,885,820, 34475,1860,1707, 34476,1861,1708, 34477,1862,1709, 34472,1857,1704, 1710,1863,1710, 34473,1858,1705, 1711,1864,1711, 34222,1606,1454, 34221,1605,1453, 
1, // chain 92
822,887,822, 1704,1857,1704, 821,886,821, 
7, // chain 93
1712,1865,1712, 1456,1608,1456, 1713,1866,1713, 
1714,1867,1714, 34483,1868,1715, 34275,1659,1507, 34274,1658,1506, 34224,1608,1456, 1457,1609,1457, 
11, // chain 94
1455,1607,1455, 1456,1608,1456, 1712,1865,1712, 
1711,1864,1711, 34484,1869,1716, 34482,1867,1714, 1717,1870,1717, 34486,1871,1718, 34483,1868,1715, 1719,1872,1719, 34488,1873,1720, 34276,1660,1508, 34275,1659,1507, 
3, // chain 95
1709,1862,1709, 1710,1863,1710, 1717,1870,1717, 
34484,1869,1716, 34479,1864,1711, 
12, // chain 96
1721,1874,1721, 1511,1663,1511, 1722,1875,1722, 
1723,1876,1723, 34492,1877,1724, 34493,1878,1725, 34494,1879,1726, 34279,1663,1511, 1727,1880,1727, 34280,1664,1512, 1728,1881,1728, 34281,1665,1513, 1516,1668,1516, 34282,1666,1514, 
25, // chain 97
1510,1662,1510, 1511,1663,1511, 1721,1874,1721, 
1729,1882,1729, 34498,1883,1730, 34491,1876,1723, 1731,1884,1731, 34500,1885,1732, 34492,1877,1724, 1733,1886,1733, 34502,1887,1734, 34493,1878,1725, 1735,1888,1735, 34504,1889,1736, 34494,1879,1726, 1737,1890,1737, 34495,1880,1727, 1728,1881,1728, 1738,1891,1738, 
34284,1668,1516, 1517,1669,1517, 1739,1892,1739, 34508,1893,1740, 34286,1670,1518, 1617,1770,1617, 34384,1769,1616, 34287,1671,1519, 
3, // chain 98
1720,1873,1720, 1508,1660,1508, 1729,1882,1729, 
34277,1661,1509, 1510,1662,1510, 
6, // chain 99
1737,1890,1737, 1738,1891,1738, 1741,1894,1741, 
1736,1889,1736, 34510,1895,1742, 34511,1896,1743, 34507,1892,1739, 34506,1891,1738, 
8, // chain 100
1742,1895,1742, 1743,1896,1743, 1744,1897,1744, 
1745,1898,1745, 34514,1899,1746, 34515,1900,1747, 34516,1901,1748, 34511,1896,1743, 1740,1893,1740, 34507,1892,1739, 
21, // chain 101
1617,1770,1617, 1618,1771,1618, 1749,1902,1749, 
1740,1893,1740, 34516,1901,1748, 34515,1900,1747, 34518,1903,1750, 34386,1771,1618, 1751,1904,1751, 34387,1772,1619, 1752,1905,1752, 34521,1906,1753, 34388,1773,1620, 1754,1907,1754, 34389,1774,1621, 1755,1908,1755, 34390,1775,1622, 1756,1909,1756, 34525,1910,1757, 
34391,1776,1623, 1758,1911,1758, 34393,1778,1625, 34392,1777,1624, 
29, // chain 102
1759,1912,1759, 1760,1913,1760, 1674,1827,1674, 
1761,1914,1761, 34443,1828,1675, 1676,1829,1676, 1762,1915,1762, 34531,1916,1763, 34445,1830,1677, 1764,1917,1764, 34446,1831,1678, 1765,1918,1765, 34534,1919,1766, 34447,1832,1679, 1680,1833,1680, 1696,1849,1696, 1767,1920,1767, 34536,1921,1768, 34465,1850,1697, 
1769,1922,1769, 34466,1851,1698, 1770,1923,1770, 34467,1852,1699, 1700,1853,1700, 1771,1924,1771, 34540,1925,1772, 34469,1854,1701, 1773,1926,1773, 34470,1855,1702, 1395,1547,1395, 34162,1546,1394, 
19, // chain 103
1760,1913,1760, 1759,1912,1759, 1774,1927,1774, 
1775,1928,1775, 34544,1929,1776, 34545,1930,1777, 34546,1931,1778, 34527,1912,1759, 1779,1932,1779, 34529,1914,1761, 1762,1915,1762, 1780,1933,1780, 34549,1934,1781, 34531,1916,1763, 1782,1935,1782, 34532,1917,1764, 1783,1936,1783, 34533,1918,1765, 1784,1937,1784, 
34535,1920,1767, 34534,1919,1766, 
30, // chain 104
1779,1932,1779, 1780,1933,1780, 1785,1938,1785, 
1778,1931,1778, 34554,1939,1786, 34555,1940,1787, 34556,1941,1788, 34548,1933,1780, 1789,1942,1789, 34549,1934,1781, 1790,1943,1790, 34550,1935,1782, 1791,1944,1791, 34551,1936,1783, 1792,1945,1792, 34552,1937,1784, 1793,1946,1793, 34562,1947,1794, 34535,1920,1767, 
1768,1921,1768, 1795,1948,1795, 34537,1922,1769, 1796,1949,1796, 34538,1923,1770, 1771,1924,1771, 1797,1950,1797, 34566,1951,1798, 34540,1925,1772, 1799,1952,1799, 34541,1926,1773, 1396,1548,1396, 34163,1547,1395, 
31, // chain 105
1778,1931,1778, 1786,1939,1786, 1777,1930,1777, 
34568,1953,1800, 34569,1954,1801, 34555,1940,1787, 1802,1955,1802, 34571,1956,1803, 34556,1941,1788, 1804,1957,1804, 34557,1942,1789, 1805,1958,1805, 34558,1943,1790, 1806,1959,1806, 34559,1944,1791, 1807,1960,1807, 34560,1945,1792, 1808,1961,1808, 34561,1946,1793, 
1809,1962,1809, 34578,1963,1810, 34562,1947,1794, 1795,1948,1795, 1811,1964,1811, 34564,1949,1796, 1797,1950,1797, 1812,1965,1812, 34581,1966,1813, 34566,1951,1798, 1814,1967,1814, 34567,1952,1799, 1397,1549,1397, 34164,1548,1396, 
19, // chain 106
819,884,819, 1707,1860,1707, 1815,1968,1815, 
818,883,818, 34584,1969,1816, 34585,1970,1817, 34586,1971,1818, 34475,1860,1707, 1708,1861,1708, 1819,1972,1819, 34588,1973,1820, 34477,1862,1709, 1717,1870,1717, 1718,1871,1718, 1821,1974,1821, 34487,1872,1719, 1822,1975,1822, 34591,1976,1823, 34488,1873,1720, 
1730,1883,1730, 34497,1882,1729, 
1, // chain 107
820,885,820, 1707,1860,1707, 819,884,819, 
14, // chain 108
817,882,817, 1816,1969,1816, 1824,1977,1824, 
816,881,816, 34593,1978,1825, 34594,1979,1826, 34595,1980,1827, 34584,1969,1816, 1817,1970,1817, 1828,1981,1828, 34597,1982,1829, 34586,1971,1818, 1819,1972,1819, 1830,1983,1830, 34589,1974,1821, 34588,1973,1820, 
1, // chain 109
818,883,818, 1816,1969,1816, 817,882,817, 
9, // chain 110
1830,1983,1830, 1822,1975,1822, 1831,1984,1831, 
1832,1985,1832, 34601,1986,1833, 34602,1987,1834, 34603,1988,1835, 34590,1975,1822, 1823,1976,1823, 1731,1884,1731, 34498,1883,1730, 
1, // chain 111
1821,1974,1821, 1822,1975,1822, 1830,1983,1830, 
22, // chain 112
1829,1982,1829, 1830,1983,1830, 1832,1985,1832, 
1828,1981,1828, 34604,1989,1836, 34601,1986,1833, 1837,1990,1837, 34606,1991,1838, 34602,1987,1834, 1839,1992,1839, 34608,1993,1840, 34603,1988,1835, 1731,1884,1731, 1732,1885,1732, 1841,1994,1841, 34501,1886,1733, 1842,1995,1842, 34611,1996,1843, 34502,1887,1734, 
1844,1997,1844, 34503,1888,1735, 1745,1898,1745, 34510,1895,1742, 34504,1889,1736, 
38, // chain 113
1845,1998,1845, 1842,1995,1842, 1846,1999,1846, 
1847,2000,1847, 34616,2001,1848, 34617,2002,1849, 34618,2003,1850, 34610,1995,1842, 1843,1996,1843, 1851,2004,1851, 34612,1997,1844, 1852,2005,1852, 34513,1898,1745, 1746,1899,1746, 1853,2006,1853, 34622,2007,1854, 34515,1900,1747, 1750,1903,1750, 1855,2008,1855, 
34519,1904,1751, 1856,2009,1856, 34520,1905,1752, 1857,2010,1857, 34626,2011,1858, 34627,2012,1859, 34521,1906,1753, 1860,2013,1860, 34522,1907,1754, 1861,2014,1861, 34523,1908,1755, 1862,2015,1862, 34524,1909,1756, 1863,2016,1863, 34632,2017,1864, 34525,1910,1757, 
1865,2018,1865, 34526,1911,1758, 1866,2019,1866, 34394,1779,1626, 34393,1778,1625, 
50, // chain 114
1841,1994,1841, 1842,1995,1842, 1845,1998,1845, 
1839,1992,1839, 34635,2020,1867, 34615,2000,1847, 1868,2021,1868, 34637,2022,1869, 34616,2001,1848, 1870,2023,1870, 34639,2024,1871, 34617,2002,1849, 1872,2025,1872, 34641,2026,1873, 34618,2003,1850, 1851,2004,1851, 1874,2027,1874, 34620,2005,1852, 1853,2006,1853, 
1875,2028,1875, 34644,2029,1876, 34622,2007,1854, 1855,2008,1855, 1877,2030,1877, 34624,2009,1856, 1878,2031,1878, 34625,2010,1857, 1879,2032,1879, 34648,2033,1880, 34626,2011,1858, 1881,2034,1881, 34650,2035,1882, 34627,2012,1859, 1883,2036,1883, 34628,2013,1860, 
1884,2037,1884, 34629,2014,1861, 1885,2038,1885, 34630,2015,1862, 1886,2039,1886, 34631,2016,1863, 1887,2040,1887, 34656,2041,1888, 34632,2017,1864, 1889,2042,1889, 34658,2043,1890, 34633,2018,1865, 1891,2044,1891, 34634,2019,1866, 1892,2045,1892, 34395,1780,1627, 
34394,1779,1626, 
97, // chain 115
1893,2046,1893, 1875,2028,1875, 1894,2047,1894, 
1895,2048,1895, 34664,2049,1896, 34665,2050,1897, 34666,2051,1898, 34643,2028,1875, 1876,2029,1876, 1877,2030,1877, 1899,2052,1899, 34646,2031,1878, 1900,2053,1900, 34647,2032,1879, 1901,2054,1901, 34670,2055,1902, 34648,2033,1880, 1903,2056,1903, 34649,2034,1881, 
1904,2057,1904, 34673,2058,1905, 34650,2035,1882, 1906,2059,1906, 34675,2060,1907, 34651,2036,1883, 1884,2037,1884, 1908,2061,1908, 34653,2038,1885, 1909,2062,1909, 34654,2039,1886, 1910,2063,1910, 34655,2040,1887, 1911,2064,1911, 34680,2065,1912, 34656,2041,1888, 
1889,2042,1889, 1913,2066,1913, 34682,2067,1914, 34683,2068,1915, 34658,2043,1890, 1891,2044,1891, 1916,2069,1916, 34660,2045,1892, 1917,2070,1917, 34686,2071,1918, 34395,1780,1627, 1628,1781,1628, 1919,2072,1919, 34397,1782,1629, 1920,2073,1920, 34398,1783,1630, 
1921,2074,1921, 34399,1784,1631, 1922,2075,1922, 34400,1785,1632, 1923,2076,1923, 34692,2077,1924, 34401,1786,1633, 1634,1787,1634, 1925,2078,1925, 34694,2079,1926, 34403,1788,1635, 1927,2080,1927, 34404,1789,1636, 1928,2081,1928, 34405,1790,1637, 1929,2082,1929, 
34406,1791,1638, 1639,1792,1639, 1930,2083,1930, 34408,1793,1640, 1931,2084,1931, 34409,1794,1641, 1932,2085,1932, 34410,1795,1642, 1933,2086,1933, 34411,1796,1643, 1644,1797,1644, 1934,2087,1934, 34703,2088,1935, 34413,1798,1645, 1936,2089,1936, 34414,1799,1646, 
1647,1800,1647, 1937,2090,1937, 34416,1801,1648, 1938,2091,1938, 34707,2092,1939, 34417,1802,1649, 1940,2093,1940, 34418,1803,1650, 1651,1804,1651, 1941,2094,1941, 34420,1805,1652, 1942,2095,1942, 34711,2096,1943, 34421,1806,1653, 1572,1724,1572, 34339,1723,1571, 
13, // chain 116
1874,2027,1874, 1875,2028,1875, 1893,2046,1893, 
1873,2026,1873, 34640,2025,1872, 34663,2048,1895, 1944,2097,1944, 34713,2098,1945, 34664,2049,1896, 1946,2099,1946, 34715,2100,1947, 34665,2050,1897, 1948,2101,1948, 34667,2052,1899, 34666,2051,1898, 
218, // chain 117
1949,2102,1949, 1901,2054,1901, 1950,2103,1950, 
1951,2104,1951, 34720,2105,1952, 34721,2106,1953, 34669,2054,1901, 1902,2055,1902, 1954,2107,1954, 34671,2056,1903, 1904,2057,1904, 1955,2108,1955, 34724,2109,1956, 34673,2058,1905, 1957,2110,1957, 34674,2059,1906, 1958,2111,1958, 34727,2112,1959, 34675,2060,1907, 
1908,2061,1908, 1960,2113,1960, 34677,2062,1909, 1961,2114,1961, 34678,2063,1910, 1962,2115,1962, 34679,2064,1911, 1963,2116,1963, 34680,2065,1912, 1964,2117,1964, 34681,2066,1913, 1965,2118,1965, 34734,2119,1966, 34682,2067,1914, 1967,2120,1967, 34736,2121,1968, 
34683,2068,1915, 1916,2069,1916, 1969,2122,1969, 34685,2070,1917, 1970,2123,1970, 34739,2124,1971, 34686,2071,1918, 1919,2072,1919, 1972,2125,1972, 34688,2073,1920, 1973,2126,1973, 34689,2074,1921, 1974,2127,1974, 34743,2128,1975, 34690,2075,1922, 1976,2129,1976, 
34691,2076,1923, 1977,2130,1977, 34692,2077,1924, 1925,2078,1925, 1978,2131,1978, 34747,2132,1979, 34694,2079,1926, 1927,2080,1927, 1980,2133,1980, 34696,2081,1928, 1981,2134,1981, 34697,2082,1929, 1930,2083,1930, 1931,2084,1931, 1982,2135,1982, 34700,2085,1932, 
1983,2136,1983, 34701,2086,1933, 1984,2137,1984, 34702,2087,1934, 1985,2138,1985, 34703,2088,1935, 1986,2139,1986, 34704,2089,1936, 1987,2140,1987, 34705,2090,1937, 1988,2141,1988, 34706,2091,1938, 1989,2142,1989, 34707,2092,1939, 1990,2143,1990, 34708,2093,1940, 
1991,2144,1991, 34709,2094,1941, 1992,2145,1992, 34710,2095,1942, 1993,2146,1993, 34711,2096,1943, 1994,2147,1994, 34340,1724,1572, 1573,1725,1573, 1995,2148,1995, 34342,1726,1574, 1996,2149,1996, 34343,1727,1575, 1997,2150,1997, 34344,1728,1576, 1998,2151,1998, 
34345,1729,1577, 1999,2152,1999, 34346,1730,1578, 2000,2153,2000, 34347,1731,1579, 1580,1732,1580, 2001,2154,2001, 34349,1733,1581, 2002,2155,2002, 34350,1734,1582, 2003,2156,2003, 34351,1735,1583, 2004,2157,2004, 34352,1736,1584, 2005,2158,2005, 34353,1737,1585, 
2006,2159,2006, 34354,1738,1586, 2007,2160,2007, 34355,1739,1587, 2008,2161,2008, 34356,1740,1588, 2009,2162,2009, 34778,2163,2010, 34357,1741,1589, 2011,2164,2011, 34358,1742,1590, 2012,2165,2012, 34359,1743,1591, 2013,2166,2013, 34360,1744,1592, 2014,2167,2014, 
34361,1745,1593, 2015,2168,2015, 34362,1746,1594, 2016,2169,2016, 34363,1747,1595, 2017,2170,2017, 34364,1748,1596, 2018,2171,2018, 34365,1749,1597, 1598,1750,1598, 2019,2172,2019, 34367,1751,1599, 2020,2173,2020, 34368,1752,1600, 2021,2174,2021, 34369,1753,1601, 
2022,2175,2022, 34370,1754,1602, 2023,2176,2023, 34371,1755,1603, 2024,2177,2024, 34372,1756,1604, 2025,2178,2025, 34794,2179,2026, 34373,1757,1605, 2027,2180,2027, 34374,1758,1606, 2028,2181,2028, 34375,1759,1607, 2029,2182,2029, 34376,1760,1608, 2030,2183,2030, 
34377,1761,1609, 2031,2184,2031, 34378,1762,1610, 2032,2185,2032, 34379,1763,1611, 2033,2186,2033, 34380,1764,1612, 1613,1765,1613, 2034,2187,2034, 34382,1766,1614, 2035,2188,2035, 34383,1767,1615, 2036,2189,2036, 33438,1768,670, 668,2190,668, 2037,2191,2037, 
33433,2192,665, 663,2193,663, 2038,2194,2038, 33430,2195,662, 2039,2196,2039, 34808,2197,2040, 33428,2198,660, 2041,2199,2041, 33425,2200,657, 655,2201,655, 2042,2202,2042, 33422,2203,654, 2043,2204,2043, 34812,2205,2044, 33420,2206,652, 2045,2207,2045, 
33417,2208,649, 647,2209,647, 2046,2210,2046, 33414,2211,646, 2047,2212,2047, 34816,2213,2048, 33412,2214,644, 2049,2215,2049, 33409,2216,641, 639,2217,639, 2050,2218,2050, 33406,2219,638, 2051,2220,2051, 34820,2221,2052, 33404,2222,636, 2053,2223,2053, 
33401,2224,633, 631,2225,631, 2054,2226,2054, 33398,2227,630, 2055,2228,2055, 34824,2229,2056, 33396,2230,628, 2057,2231,2057, 33382,2232,614, 
217, // chain 118
1900,2053,1900, 1901,2054,1901, 1949,2102,1949, 
1948,2101,1948, 34826,2233,2058, 34719,2104,1951, 2059,2234,2059, 34828,2235,2060, 34829,2236,2061, 34720,2105,1952, 2062,2237,2062, 34831,2238,2063, 34832,2239,2064, 34721,2106,1953, 1954,2107,1954, 2065,2240,2065, 34723,2108,1955, 2066,2241,2066, 34835,2242,2067, 
34724,2109,1956, 2068,2243,2068, 34725,2110,1957, 2069,2244,2069, 34726,2111,1958, 2070,2245,2070, 34839,2246,2071, 34727,2112,1959, 1960,2113,1960, 2072,2247,2072, 34729,2114,1961, 2073,2248,2073, 34730,2115,1962, 2074,2249,2074, 34731,2116,1963, 1964,2117,1964, 
2075,2250,2075, 34733,2118,1965, 2076,2251,2076, 34845,2252,2077, 34734,2119,1966, 2078,2253,2078, 34735,2120,1967, 2079,2254,2079, 34848,2255,2080, 34736,2121,1968, 1969,2122,1969, 2081,2256,2081, 34738,2123,1970, 2082,2257,2082, 34739,2124,1971, 1972,2125,1972, 
2083,2258,2083, 34741,2126,1973, 2084,2259,2084, 34742,2127,1974, 2085,2260,2085, 34854,2261,2086, 34743,2128,1975, 2087,2262,2087, 34744,2129,1976, 2088,2263,2088, 34857,2264,2089, 34745,2130,1977, 1978,2131,1978, 2090,2265,2090, 34859,2266,2091, 34860,2267,2092, 
34747,2132,1979, 1980,2133,1980, 2093,2268,2093, 34749,2134,1981, 1982,2135,1982, 2094,2269,2094, 34751,2136,1983, 2095,2270,2095, 34752,2137,1984, 2096,2271,2096, 34753,2138,1985, 2097,2272,2097, 34754,2139,1986, 2098,2273,2098, 34755,2140,1987, 2099,2274,2099, 
34756,2141,1988, 2100,2275,2100, 34757,2142,1989, 2101,2276,2101, 34758,2143,1990, 2102,2277,2102, 34759,2144,1991, 2103,2278,2103, 34760,2145,1992, 2104,2279,2104, 34761,2146,1993, 2105,2280,2105, 34762,2147,1994, 1995,2148,1995, 2106,2281,2106, 34764,2149,1996, 
2107,2282,2107, 34765,2150,1997, 2108,2283,2108, 34766,2151,1998, 2109,2284,2109, 34767,2152,1999, 2110,2285,2110, 34768,2153,2000, 2001,2154,2001, 2111,2286,2111, 34770,2155,2002, 2112,2287,2112, 34771,2156,2003, 2113,2288,2113, 34772,2157,2004, 2114,2289,2114, 
34773,2158,2005, 2115,2290,2115, 34774,2159,2006, 2116,2291,2116, 34775,2160,2007, 2117,2292,2117, 34776,2161,2008, 2118,2293,2118, 34777,2162,2009, 2119,2294,2119, 34888,2295,2120, 34778,2163,2010, 2121,2296,2121, 34779,2164,2011, 2122,2297,2122, 34780,2165,2012, 
2123,2298,2123, 34781,2166,2013, 2124,2299,2124, 34782,2167,2014, 2125,2300,2125, 34783,2168,2015, 2126,2301,2126, 34784,2169,2016, 2127,2302,2127, 34785,2170,2017, 2128,2303,2128, 34786,2171,2018, 2019,2172,2019, 2129,2304,2129, 34788,2173,2020, 2130,2305,2130, 
34789,2174,2021, 2131,2306,2131, 34790,2175,2022, 2132,2307,2132, 34791,2176,2023, 2133,2308,2133, 34792,2177,2024, 2134,2309,2134, 34793,2178,2025, 2135,2310,2135, 34904,2311,2136, 34794,2179,2026, 2137,2312,2137, 34795,2180,2027, 2138,2313,2138, 34796,2181,2028, 
2139,2314,2139, 34797,2182,2029, 2140,2315,2140, 34798,2183,2030, 2141,2316,2141, 34799,2184,2031, 2142,2317,2142, 34800,2185,2032, 2143,2318,2143, 34801,2186,2033, 2034,2187,2034, 2144,2319,2144, 34803,2188,2035, 2145,2320,2145, 34804,2189,2036, 2037,2191,2037, 
2038,2194,2038, 2146,2321,2146, 34807,2196,2039, 2147,2322,2147, 34916,2323,2148, 34808,2197,2040, 2149,2324,2149, 34809,2199,2041, 2042,2202,2042, 2150,2325,2150, 34811,2204,2043, 2151,2326,2151, 34920,2327,2152, 34812,2205,2044, 2153,2328,2153, 34813,2207,2045, 
2046,2210,2046, 2154,2329,2154, 34815,2212,2047, 2155,2330,2155, 34924,2331,2156, 34816,2213,2048, 2157,2332,2157, 34817,2215,2049, 2050,2218,2050, 2158,2333,2158, 34819,2220,2051, 2159,2334,2159, 34928,2335,2160, 34820,2221,2052, 2161,2336,2161, 34821,2223,2053, 
2054,2226,2054, 2162,2337,2162, 34823,2228,2055, 2163,2338,2163, 34932,2339,2164, 34824,2229,2056, 2165,2340,2165, 34825,2231,2057, 
40, // chain 119
1801,1954,1801, 2166,2341,2166, 2167,2342,2167, 
1800,1953,1800, 34936,2343,2168, 34937,2344,2169, 34938,2345,2170, 34934,2341,2166, 2171,2346,2171, 34940,2347,2172, 34941,2348,2173, 34942,2349,2174, 34569,1954,1801, 1802,1955,1802, 2175,2350,2175, 34944,2351,2176, 34571,1956,1803, 2177,2352,2177, 34946,2353,2178, 
34572,1957,1804, 2179,2354,2179, 34573,1958,1805, 2180,2355,2180, 34574,1959,1806, 2181,2356,2181, 34575,1960,1807, 2182,2357,2182, 34576,1961,1808, 2183,2358,2183, 34577,1962,1809, 2184,2359,2184, 34953,2360,2185, 34578,1963,1810, 1811,1964,1811, 1812,1965,1812, 
2186,2361,2186, 34955,2362,2187, 34581,1966,1813, 2188,2363,2188, 34582,1967,1814, 1398,1550,1398, 34165,1549,1397, 
19, // chain 120
2176,2351,2176, 2177,2352,2177, 2189,2364,2189, 
34958,2365,2190, 34959,2366,2191, 34946,2353,2178, 2192,2367,2192, 34947,2354,2179, 2193,2368,2193, 34948,2355,2180, 2194,2369,2194, 34949,2356,2181, 2195,2370,2195, 34950,2357,2182, 2196,2371,2196, 34951,2358,2183, 2197,2372,2197, 34952,2359,2184, 2198,2373,2198, 
34954,2361,2186, 34953,2360,2185, 
10, // chain 121
2190,2365,2190, 2199,2374,2199, 2200,2375,2200, 
2189,2364,2189, 34969,2376,2201, 34970,2377,2202, 34971,2378,2203, 34967,2374,2199, 2204,2379,2204, 34973,2380,2205, 34959,2366,2191, 34958,2365,2190, 
2, // chain 122
2175,2350,2175, 2206,2381,2206, 2173,2348,2173, 
2174,2349,2174, 
6, // chain 123
2206,2381,2206, 2175,2350,2175, 2207,2382,2207, 
2208,2383,2208, 34977,2384,2209, 34957,2364,2189, 34944,2351,2176, 34943,2350,2175, 
14, // chain 124
2209,2384,2209, 2189,2364,2189, 2201,2376,2201, 
2210,2385,2210, 34970,2377,2202, 2211,2386,2211, 34980,2387,2212, 34971,2378,2203, 2213,2388,2213, 34972,2379,2204, 2214,2389,2214, 34983,2390,2215, 34973,2380,2205, 2216,2391,2216, 34960,2367,2192, 34959,2366,2191, 
10, // chain 125
2194,2369,2194, 2217,2392,2217, 2218,2393,2218, 
2193,2368,2193, 34984,2391,2216, 34987,2394,2219, 34988,2395,2220, 34985,2392,2217, 2221,2396,2221, 34990,2397,2222, 34963,2370,2195, 34962,2369,2194, 
1, // chain 126
2193,2368,2193, 2216,2391,2216, 2192,2367,2192, 
16, // chain 127
2198,2373,2198, 2223,2398,2223, 2224,2399,2224, 
2197,2372,2197, 34993,2400,2225, 34994,2401,2226, 34995,2402,2227, 34991,2398,2223, 2228,2403,2228, 34997,2404,2229, 34998,2405,2230, 34966,2373,2198, 2186,2361,2186, 2187,2362,2187, 2231,2406,2231, 34956,2363,2188, 1399,1551,1399, 34166,1550,1398, 
2, // chain 128
2196,2371,2196, 2225,2400,2225, 2222,2397,2222, 
2195,2370,2195, 
1, // chain 129
2197,2372,2197, 2225,2400,2225, 2196,2371,2196, 
2, // chain 130
2231,2406,2231, 1400,1552,1400, 2229,2404,2229, 
2230,2405,2230, 
1, // chain 131
1399,1551,1399, 1400,1552,1400, 2231,2406,2231, 
18, // chain 132
815,880,815, 1825,1978,1825, 2232,2407,2232, 
814,879,814, 35001,2408,2233, 35002,2409,2234, 34593,1978,1825, 1826,1979,1826, 2235,2410,2235, 35004,2411,2236, 34595,1980,1827, 1828,1981,1828, 1836,1989,1836, 2237,2412,2237, 34605,1990,1837, 2238,2413,2238, 35007,2414,2239, 34606,1991,1838, 1867,2020,1867, 
34607,1992,1839, 
1, // chain 133
816,881,816, 1825,1978,1825, 815,880,815, 
11, // chain 134
813,878,813, 2233,2408,2233, 2240,2415,2240, 
2241,2416,2241, 35010,2417,2242, 35011,2418,2243, 35001,2408,2233, 2234,2409,2234, 2244,2419,2244, 35003,2410,2235, 2245,2420,2245, 35005,2412,2237, 35004,2411,2236, 
1, // chain 135
814,879,814, 2233,2408,2233, 813,878,813, 
9, // chain 136
2245,2420,2245, 2238,2413,2238, 2246,2421,2246, 
2247,2422,2247, 35016,2423,2248, 35017,2424,2249, 35018,2425,2250, 35006,2413,2238, 2239,2414,2239, 1868,2021,1868, 34635,2020,1867, 
1, // chain 137
2237,2412,2237, 2238,2413,2238, 2245,2420,2245, 
20, // chain 138
2244,2419,2244, 2245,2420,2245, 2247,2422,2247, 
2251,2426,2251, 35020,2427,2252, 35016,2423,2248, 2253,2428,2253, 35022,2429,2254, 35017,2424,2249, 2255,2430,2255, 35024,2431,2256, 35018,2425,2250, 1868,2021,1868, 1869,2022,1869, 2257,2432,2257, 34638,2023,1870, 2258,2433,2258, 35027,2434,2259, 34639,2024,1871, 
2260,2435,2260, 34712,2097,1944, 34640,2025,1872, 
2, // chain 139
2242,2417,2242, 2243,2418,2243, 2251,2426,2251, 
35012,2419,2244, 
87, // chain 140
2261,2436,2261, 2258,2433,2258, 2262,2437,2262, 
2263,2438,2263, 35032,2439,2264, 35026,2433,2258, 2259,2434,2259, 2265,2440,2265, 35028,2435,2260, 2266,2441,2266, 35035,2442,2267, 34712,2097,1944, 1945,2098,1945, 2268,2443,2268, 34714,2099,1946, 2269,2444,2269, 35038,2445,2270, 34715,2100,1947, 2271,2446,2271, 
34716,2101,1948, 2058,2233,2058, 2272,2447,2272, 34827,2234,2059, 2273,2448,2273, 35042,2449,2274, 34828,2235,2060, 2275,2450,2275, 35044,2451,2276, 34829,2236,2061, 2062,2237,2062, 2277,2452,2277, 35046,2453,2278, 34831,2238,2063, 2279,2454,2279, 35048,2455,2280, 
34832,2239,2064, 2065,2240,2065, 2281,2456,2281, 34834,2241,2066, 2282,2457,2282, 35051,2458,2283, 34835,2242,2067, 2284,2459,2284, 34836,2243,2068, 2285,2460,2285, 34837,2244,2069, 2286,2461,2286, 34838,2245,2070, 2287,2462,2287, 34839,2246,2071, 2288,2463,2288, 
34840,2247,2072, 2289,2464,2289, 34841,2248,2073, 2290,2465,2290, 34842,2249,2074, 2075,2250,2075, 2291,2466,2291, 34844,2251,2076, 2292,2467,2292, 35061,2468,2293, 34845,2252,2077, 2294,2469,2294, 34846,2253,2078, 2295,2470,2295, 34847,2254,2079, 2296,2471,2296, 
35065,2472,2297, 34848,2255,2080, 2081,2256,2081, 2298,2473,2298, 35067,2474,2299, 34850,2257,2082, 2300,2475,2300, 34851,2258,2083, 2301,2476,2301, 34852,2259,2084, 2302,2477,2302, 34853,2260,2085, 2303,2478,2303, 35072,2479,2304, 34854,2261,2086, 2305,2480,2305, 
34855,2262,2087, 2306,2481,2306, 34856,2263,2088, 2307,2482,2307, 34858,2265,2090, 34857,2264,2089, 
210, // chain 141
2257,2432,2257, 2258,2433,2258, 2261,2436,2261, 
2255,2430,2255, 35076,2483,2308, 35031,2438,2263, 2309,2484,2309, 35078,2485,2310, 35032,2439,2264, 2311,2486,2311, 35033,2440,2265, 2312,2487,2312, 35034,2441,2266, 2313,2488,2313, 35082,2489,2314, 35035,2442,2267, 2268,2443,2268, 2315,2490,2315, 35037,2444,2269, 
2316,2491,2316, 35085,2492,2317, 35038,2445,2270, 2318,2493,2318, 35039,2446,2271, 2272,2447,2272, 2319,2494,2319, 35041,2448,2273, 2320,2495,2320, 35089,2496,2321, 35042,2449,2274, 2322,2497,2322, 35043,2450,2275, 2323,2498,2323, 35092,2499,2324, 35044,2451,2276, 
2277,2452,2277, 2325,2500,2325, 35094,2501,2326, 35046,2453,2278, 2327,2502,2327, 35096,2503,2328, 35047,2454,2279, 2329,2504,2329, 35098,2505,2330, 35048,2455,2280, 2281,2456,2281, 2331,2506,2331, 35050,2457,2282, 2332,2507,2332, 35101,2508,2333, 35051,2458,2283, 
2334,2509,2334, 35052,2459,2284, 2335,2510,2335, 35053,2460,2285, 2336,2511,2336, 35105,2512,2337, 35054,2461,2286, 2338,2513,2338, 35055,2462,2287, 2339,2514,2339, 35056,2463,2288, 2340,2515,2340, 35057,2464,2289, 2341,2516,2341, 35058,2465,2290, 2291,2466,2291, 
2342,2517,2342, 35060,2467,2292, 2343,2518,2343, 35112,2519,2344, 35061,2468,2293, 2345,2520,2345, 35062,2469,2294, 2346,2521,2346, 35063,2470,2295, 2347,2522,2347, 35064,2471,2296, 2348,2523,2348, 35117,2524,2349, 35065,2472,2297, 2298,2473,2298, 2350,2525,2350, 
35119,2526,2351, 35120,2527,2352, 35067,2474,2299, 2300,2475,2300, 2353,2528,2353, 35069,2476,2301, 2354,2529,2354, 35070,2477,2302, 2355,2530,2355, 35071,2478,2303, 2356,2531,2356, 35125,2532,2357, 35072,2479,2304, 2358,2533,2358, 35073,2480,2305, 2359,2534,2359, 
35074,2481,2306, 2360,2535,2360, 35075,2482,2307, 2361,2536,2361, 35130,2537,2362, 34858,2265,2090, 2091,2266,2091, 2363,2538,2363, 35132,2539,2364, 34860,2267,2092, 2093,2268,2093, 2094,2269,2094, 2365,2540,2365, 34863,2270,2095, 2366,2541,2366, 34864,2271,2096, 
2367,2542,2367, 34865,2272,2097, 2368,2543,2368, 34866,2273,2098, 2369,2544,2369, 34867,2274,2099, 2370,2545,2370, 34868,2275,2100, 2371,2546,2371, 34869,2276,2101, 2372,2547,2372, 34870,2277,2102, 2373,2548,2373, 34871,2278,2103, 2374,2549,2374, 34872,2279,2104, 
2375,2550,2375, 34873,2280,2105, 2106,2281,2106, 2376,2551,2376, 34875,2282,2107, 2377,2552,2377, 34876,2283,2108, 2378,2553,2378, 34877,2284,2109, 2379,2554,2379, 34878,2285,2110, 2380,2555,2380, 34879,2286,2111, 2381,2556,2381, 34880,2287,2112, 2382,2557,2382, 
34881,2288,2113, 2383,2558,2383, 34882,2289,2114, 2384,2559,2384, 34883,2290,2115, 2385,2560,2385, 34884,2291,2116, 2386,2561,2386, 34885,2292,2117, 2118,2293,2118, 2387,2562,2387, 34887,2294,2119, 2388,2563,2388, 34888,2295,2120, 2389,2564,2389, 34889,2296,2121, 
2390,2565,2390, 34890,2297,2122, 2391,2566,2391, 34891,2298,2123, 2392,2567,2392, 34892,2299,2124, 2393,2568,2393, 34893,2300,2125, 2394,2569,2394, 34894,2301,2126, 2395,2570,2395, 34895,2302,2127, 2396,2571,2396, 34896,2303,2128, 2397,2572,2397, 34897,2304,2129, 
2398,2573,2398, 34898,2305,2130, 2399,2574,2399, 34899,2306,2131, 2400,2575,2400, 34900,2307,2132, 2401,2576,2401, 34901,2308,2133, 2402,2577,2402, 34902,2309,2134, 2403,2578,2403, 34903,2310,2135, 2404,2579,2404, 34904,2311,2136, 2405,2580,2405, 34905,2312,2137, 
2406,2581,2406, 34906,2313,2138, 2407,2582,2407, 34907,2314,2139, 2408,2583,2408, 34908,2315,2140, 2409,2584,2409, 34909,2316,2141, 2410,2585,2410, 34910,2317,2142, 2411,2586,2411, 34911,2318,2143, 2412,2587,2412, 35181,2588,2413, 34912,2319,2144, 2146,2321,2146, 
34913,2320,2145, 
14, // chain 142
2317,2492,2317, 2318,2493,2318, 2319,2494,2319, 
2414,2589,2414, 35088,2495,2320, 2415,2590,2415, 35184,2591,2416, 35089,2496,2321, 2417,2592,2417, 35090,2497,2322, 2418,2593,2418, 35091,2498,2323, 2419,2594,2419, 35188,2595,2420, 35092,2499,2324, 2325,2500,2325, 
16, // chain 143
2421,2596,2421, 2208,2383,2208, 2209,2384,2209, 
2210,2385,2210, 2422,2597,2422, 34979,2386,2211, 2423,2598,2423, 35192,2599,2424, 34980,2387,2212, 2425,2600,2425, 34981,2388,2213, 2426,2601,2426, 34982,2389,2214, 2427,2602,2427, 35196,2603,2428, 34983,2390,2215, 2219,2394,2219, 34984,2391,2216, 
29, // chain 144
2208,2383,2208, 2421,2596,2421, 2429,2604,2429, 
2430,2605,2430, 35199,2606,2431, 35200,2607,2432, 35201,2608,2433, 35189,2596,2421, 2422,2597,2422, 2434,2609,2434, 35191,2598,2423, 2435,2610,2435, 35204,2611,2436, 35192,2599,2424, 2437,2612,2437, 35193,2600,2425, 2438,2613,2438, 35194,2601,2426, 2439,2614,2439, 
35195,2602,2427, 2440,2615,2440, 35209,2616,2441, 35196,2603,2428, 2442,2617,2442, 34987,2394,2219, 2220,2395,2220, 2221,2396,2221, 2443,2618,2443, 34994,2401,2226, 34993,2400,2225, 34990,2397,2222, 
20, // chain 145
2444,2619,2444, 2432,2607,2432, 2433,2608,2433, 
2434,2609,2434, 2445,2620,2445, 35203,2610,2435, 2446,2621,2446, 35215,2622,2447, 35204,2611,2436, 2448,2623,2448, 35205,2612,2437, 2449,2624,2449, 35206,2613,2438, 2450,2625,2450, 35207,2614,2439, 2451,2626,2451, 35208,2615,2440, 2452,2627,2452, 35221,2628,2453, 
35209,2616,2441, 2443,2618,2443, 35210,2617,2442, 
68, // chain 146
2432,2607,2432, 2444,2619,2444, 2454,2629,2454, 
2455,2630,2455, 35224,2631,2456, 35225,2632,2457, 35226,2633,2458, 35212,2619,2444, 2445,2620,2445, 2459,2634,2459, 35214,2621,2446, 2460,2635,2460, 35229,2636,2461, 35215,2622,2447, 2462,2637,2462, 35216,2623,2448, 2463,2638,2463, 35217,2624,2449, 2464,2639,2464, 
35218,2625,2450, 2465,2640,2465, 35219,2626,2451, 2466,2641,2466, 35220,2627,2452, 2467,2642,2467, 35236,2643,2468, 35221,2628,2453, 2469,2644,2469, 35211,2618,2443, 2226,2401,2226, 2227,2402,2227, 2470,2645,2470, 34996,2403,2228, 2471,2646,2471, 35240,2647,2472, 
34997,2404,2229, 1400,1552,1400, 1401,1553,1401, 2473,2648,2473, 34170,1554,1402, 2474,2649,2474, 34171,1555,1403, 2475,2650,2475, 34172,1556,1404, 2476,2651,2476, 34173,1557,1405, 2477,2652,2477, 34174,1558,1406, 1407,1559,1407, 2478,2653,2478, 34176,1560,1408, 
2479,2654,2479, 34177,1561,1409, 2480,2655,2480, 35249,2656,2481, 34178,1562,1410, 2482,2657,2482, 34179,1563,1411, 2483,2658,2483, 34180,1564,1412, 2484,2659,2484, 34181,1565,1413, 2485,2660,2485, 34182,1566,1414, 2486,2661,2486, 34183,1567,1415, 2487,2662,2487, 
34184,1568,1416, 1127,1279,1127, 33894,1278,1126, 
6, // chain 147
2469,2644,2469, 2470,2645,2470, 2468,2643,2468, 
35256,2663,2488, 35239,2646,2471, 2489,2664,2489, 35241,2648,2473, 35240,2647,2472, 
4, // chain 148
2488,2663,2488, 2489,2664,2489, 2490,2665,2490, 
35259,2666,2491, 35242,2649,2474, 35241,2648,2473, 
34, // chain 149
2492,2667,2492, 812,877,812, 2241,2416,2241, 
2493,2668,2493, 35010,2417,2242, 2251,2426,2251, 2494,2669,2494, 35263,2670,2495, 35020,2427,2252, 2496,2671,2496, 35021,2428,2253, 2254,2429,2254, 2497,2672,2497, 35023,2430,2255, 2498,2673,2498, 35076,2483,2308, 2499,2674,2499, 35077,2484,2309, 2500,2675,2500, 
35269,2676,2501, 35078,2485,2310, 2502,2677,2502, 35079,2486,2311, 2503,2678,2503, 35080,2487,2312, 2504,2679,2504, 35081,2488,2313, 2505,2680,2505, 35274,2681,2506, 35082,2489,2314, 2315,2490,2315, 2507,2682,2507, 35084,2491,2316, 2508,2683,2508, 35182,2589,2414, 
35085,2492,2317, 
37, // chain 150
811,876,811, 812,877,812, 2492,2667,2492, 
2509,2684,2509, 35278,2685,2510, 35261,2668,2493, 2494,2669,2494, 2511,2686,2511, 35280,2687,2512, 35263,2670,2495, 2513,2688,2513, 35264,2671,2496, 2497,2672,2497, 2514,2689,2514, 35266,2673,2498, 2515,2690,2515, 35267,2674,2499, 2516,2691,2516, 35268,2675,2500, 
2517,2692,2517, 35286,2693,2518, 35269,2676,2501, 2519,2694,2519, 35270,2677,2502, 2520,2695,2520, 35271,2678,2503, 2521,2696,2521, 35272,2679,2504, 2522,2697,2522, 35273,2680,2505, 2523,2698,2523, 35292,2699,2524, 35274,2681,2506, 2507,2682,2507, 2525,2700,2525, 
35276,2683,2508, 2526,2701,2526, 35183,2590,2415, 35182,2589,2414, 
45, // chain 151
2527,2702,2527, 810,875,810, 2509,2684,2509, 
2528,2703,2528, 35278,2685,2510, 2511,2686,2511, 2529,2704,2529, 35298,2705,2530, 35280,2687,2512, 2531,2706,2531, 35281,2688,2513, 2514,2689,2514, 2532,2707,2532, 35283,2690,2515, 2533,2708,2533, 35284,2691,2516, 2534,2709,2534, 35285,2692,2517, 2535,2710,2535, 
35304,2711,2536, 35286,2693,2518, 2537,2712,2537, 35287,2694,2519, 2538,2713,2538, 35288,2695,2520, 2539,2714,2539, 35289,2696,2521, 2540,2715,2540, 35290,2697,2522, 2541,2716,2541, 35291,2698,2523, 2542,2717,2542, 35311,2718,2543, 35292,2699,2524, 2525,2700,2525, 
2544,2719,2544, 35294,2701,2526, 2545,2720,2545, 35314,2721,2546, 35183,2590,2415, 2416,2591,2416, 2547,2722,2547, 35185,2592,2417, 2548,2723,2548, 35186,2593,2418, 2549,2724,2549, 35187,2594,2419, 
46, // chain 152
809,874,809, 810,875,810, 2527,2702,2527, 
2550,2725,2550, 35319,2726,2551, 35296,2703,2528, 2529,2704,2529, 2552,2727,2552, 35321,2728,2553, 35298,2705,2530, 2554,2729,2554, 35299,2706,2531, 2532,2707,2532, 2555,2730,2555, 35301,2708,2533, 2556,2731,2556, 35302,2709,2534, 2557,2732,2557, 35303,2710,2535, 
2558,2733,2558, 35327,2734,2559, 35304,2711,2536, 2560,2735,2560, 35305,2712,2537, 2561,2736,2561, 35306,2713,2538, 2562,2737,2562, 35307,2714,2539, 2563,2738,2563, 35308,2715,2540, 2564,2739,2564, 35309,2716,2541, 2565,2740,2565, 35310,2717,2542, 2566,2741,2566, 
35335,2742,2567, 35311,2718,2543, 2544,2719,2544, 2568,2743,2568, 35313,2720,2545, 2569,2744,2569, 35338,2745,2570, 35314,2721,2546, 2547,2722,2547, 2571,2746,2571, 35316,2723,2548, 2572,2747,2572, 35317,2724,2549, 
22, // chain 153
2573,2748,2573, 2457,2632,2457, 2458,2633,2458, 
2459,2634,2459, 2574,2749,2574, 35228,2635,2460, 2575,2750,2575, 35344,2751,2576, 35229,2636,2461, 2577,2752,2577, 35230,2637,2462, 2578,2753,2578, 35231,2638,2463, 2579,2754,2579, 35232,2639,2464, 2580,2755,2580, 35233,2640,2465, 2581,2756,2581, 35234,2641,2466, 
2582,2757,2582, 35235,2642,2467, 2490,2665,2490, 35256,2663,2488, 35236,2643,2468, 
30, // chain 154
2457,2632,2457, 2573,2748,2573, 2583,2758,2583, 
2584,2759,2584, 35353,2760,2585, 35354,2761,2586, 35355,2762,2587, 35341,2748,2573, 2574,2749,2574, 2588,2763,2588, 35343,2750,2575, 2589,2764,2589, 35358,2765,2590, 35344,2751,2576, 2591,2766,2591, 35345,2752,2577, 2592,2767,2592, 35346,2753,2578, 2593,2768,2593, 
35347,2754,2579, 2594,2769,2594, 35348,2755,2580, 2595,2770,2595, 35349,2756,2581, 2596,2771,2596, 35350,2757,2582, 2597,2772,2597, 35258,2665,2490, 2491,2666,2491, 2598,2773,2598, 35243,2650,2475, 35242,2649,2474, 
25, // chain 155
2599,2774,2599, 2586,2761,2586, 2587,2762,2587, 
2588,2763,2588, 2600,2775,2600, 35357,2764,2589, 2601,2776,2601, 35370,2777,2602, 35358,2765,2590, 2603,2778,2603, 35359,2766,2591, 2604,2779,2604, 35360,2767,2592, 2605,2780,2605, 35361,2768,2593, 2606,2781,2606, 35362,2769,2594, 2607,2782,2607, 35363,2770,2595, 
2608,2783,2608, 35364,2771,2596, 2609,2784,2609, 35365,2772,2597, 2598,2773,2598, 2610,2785,2610, 35244,2651,2476, 35243,2650,2475, 
31, // chain 156
2586,2761,2586, 2599,2774,2599, 2611,2786,2611, 
2612,2787,2612, 35381,2788,2613, 35382,2789,2614, 35383,2790,2615, 35367,2774,2599, 2600,2775,2600, 2616,2791,2616, 35369,2776,2601, 2617,2792,2617, 35386,2793,2618, 35370,2777,2602, 2619,2794,2619, 35371,2778,2603, 2620,2795,2620, 35372,2779,2604, 2621,2796,2621, 
35373,2780,2605, 2622,2797,2622, 35374,2781,2606, 2623,2798,2623, 35392,2799,2624, 35375,2782,2607, 2625,2800,2625, 35376,2783,2608, 2626,2801,2626, 35377,2784,2609, 2610,2785,2610, 2627,2802,2627, 35245,2652,2477, 35244,2651,2476, 
5, // chain 157
2626,2801,2626, 2627,2802,2627, 2628,2803,2628, 
35397,2804,2629, 35247,2654,2479, 35246,2653,2478, 35245,2652,2477, 
45, // chain 158
2630,2805,2630, 808,873,808, 2550,2725,2550, 
2631,2806,2631, 35319,2726,2551, 2552,2727,2552, 2632,2807,2632, 35401,2808,2633, 35321,2728,2553, 2634,2809,2634, 35322,2729,2554, 2555,2730,2555, 2635,2810,2635, 35324,2731,2556, 2636,2811,2636, 35325,2732,2557, 2637,2812,2637, 35326,2733,2558, 2638,2813,2638, 
35407,2814,2639, 35327,2734,2559, 2640,2815,2640, 35328,2735,2560, 2641,2816,2641, 35329,2736,2561, 2642,2817,2642, 35330,2737,2562, 2643,2818,2643, 35331,2738,2563, 2644,2819,2644, 35332,2739,2564, 2645,2820,2645, 35333,2740,2565, 2646,2821,2646, 35334,2741,2566, 
2647,2822,2647, 35416,2823,2648, 35335,2742,2567, 2568,2743,2568, 2649,2824,2649, 35337,2744,2569, 2650,2825,2650, 35419,2826,2651, 35338,2745,2570, 2571,2746,2571, 2652,2827,2652, 35340,2747,2572, 
46, // chain 159
807,872,807, 808,873,808, 2630,2805,2630, 
2653,2828,2653, 35422,2829,2654, 35399,2806,2631, 2632,2807,2632, 2655,2830,2655, 35424,2831,2656, 35401,2808,2633, 2657,2832,2657, 35402,2809,2634, 2635,2810,2635, 2658,2833,2658, 35404,2811,2636, 2659,2834,2659, 35405,2812,2637, 2660,2835,2660, 35406,2813,2638, 
2661,2836,2661, 35430,2837,2662, 35407,2814,2639, 2663,2838,2663, 35408,2815,2640, 2664,2839,2664, 35409,2816,2641, 2665,2840,2665, 35410,2817,2642, 2666,2841,2666, 35411,2818,2643, 2667,2842,2667, 35412,2819,2644, 2668,2843,2668, 35413,2820,2645, 2669,2844,2669, 
35414,2821,2646, 2670,2845,2670, 35415,2822,2647, 2671,2846,2671, 35440,2847,2672, 35416,2823,2648, 2649,2824,2649, 2673,2848,2673, 35418,2825,2650, 2674,2849,2674, 35443,2850,2675, 35419,2826,2651, 2652,2827,2652, 
43, // chain 160
2676,2851,2676, 806,871,806, 2653,2828,2653, 
2677,2852,2677, 35422,2829,2654, 2655,2830,2655, 2678,2853,2678, 35447,2854,2679, 35424,2831,2656, 2680,2855,2680, 35425,2832,2657, 2658,2833,2658, 2681,2856,2681, 35427,2834,2659, 2682,2857,2682, 35428,2835,2660, 2683,2858,2683, 35429,2836,2661, 2684,2859,2684, 
35453,2860,2685, 35430,2837,2662, 2663,2838,2663, 2686,2861,2686, 35455,2862,2687, 35432,2839,2664, 2688,2863,2688, 35433,2840,2665, 2666,2841,2666, 2689,2864,2689, 35435,2842,2667, 2690,2865,2690, 35459,2866,2691, 35436,2843,2668, 2692,2867,2692, 35437,2844,2669, 
2670,2845,2670, 2693,2868,2693, 35439,2846,2671, 2694,2869,2694, 35463,2870,2695, 35464,2871,2696, 35440,2847,2672, 2673,2848,2673, 2697,2872,2697, 35442,2849,2674, 
45, // chain 161
805,870,805, 806,871,806, 2676,2851,2676, 
2698,2873,2698, 35467,2874,2699, 35445,2852,2677, 2678,2853,2678, 2700,2875,2700, 35469,2876,2701, 35447,2854,2679, 2702,2877,2702, 35448,2855,2680, 2681,2856,2681, 2703,2878,2703, 35450,2857,2682, 2704,2879,2704, 35451,2858,2683, 2705,2880,2705, 35452,2859,2684, 
2706,2881,2706, 35475,2882,2707, 35476,2883,2708, 35453,2860,2685, 2686,2861,2686, 2709,2884,2709, 35478,2885,2710, 35455,2862,2687, 2711,2886,2711, 35456,2863,2688, 2689,2864,2689, 2712,2887,2712, 35458,2865,2690, 2713,2888,2713, 35482,2889,2714, 35459,2866,2691, 
2715,2890,2715, 35460,2867,2692, 2693,2868,2693, 2716,2891,2716, 35462,2869,2694, 2717,2892,2717, 35486,2893,2718, 35463,2870,2695, 2719,2894,2719, 35488,2895,2720, 35464,2871,2696, 2697,2872,2697, 
24, // chain 162
2721,2896,2721, 2614,2789,2614, 2615,2790,2615, 
2616,2791,2616, 2722,2897,2722, 35385,2792,2617, 2723,2898,2723, 35492,2899,2724, 35386,2793,2618, 2725,2900,2725, 35387,2794,2619, 2726,2901,2726, 35388,2795,2620, 2727,2902,2727, 35389,2796,2621, 2728,2903,2728, 35390,2797,2622, 2729,2904,2729, 35391,2798,2623, 
2730,2905,2730, 35499,2906,2731, 35392,2799,2624, 2732,2907,2732, 35393,2800,2625, 2628,2803,2628, 35394,2801,2626, 
34, // chain 163
2614,2789,2614, 2721,2896,2721, 2733,2908,2733, 
2734,2909,2734, 35503,2910,2735, 35504,2911,2736, 35489,2896,2721, 2722,2897,2722, 2737,2912,2737, 35491,2898,2723, 2738,2913,2738, 35507,2914,2739, 35492,2899,2724, 2740,2915,2740, 35493,2900,2725, 2741,2916,2741, 35494,2901,2726, 2742,2917,2742, 35495,2902,2727, 
2743,2918,2743, 35496,2903,2728, 2744,2919,2744, 35497,2904,2729, 2745,2920,2745, 35498,2905,2730, 2746,2921,2746, 35515,2922,2747, 35499,2906,2731, 2748,2923,2748, 35500,2907,2732, 2749,2924,2749, 35396,2803,2628, 2629,2804,2629, 2750,2925,2750, 35248,2655,2480, 
35247,2654,2479, 
18, // chain 164
2749,2924,2749, 2750,2925,2750, 2751,2926,2751, 
35520,2927,2752, 35248,2655,2480, 2481,2656,2481, 2753,2928,2753, 35250,2657,2482, 2754,2929,2754, 35251,2658,2483, 2755,2930,2755, 35252,2659,2484, 2756,2931,2756, 35253,2660,2485, 2757,2932,2757, 35254,2661,2486, 2758,2933,2758, 35255,2662,2487, 1128,1280,1128, 
33895,1279,1127, 
2, // chain 165
2751,2926,2751, 2759,2934,2759, 2748,2923,2748, 
2749,2924,2749, 
6, // chain 166
2759,2934,2759, 2751,2926,2751, 2760,2935,2760, 
2761,2936,2761, 35530,2937,2762, 35521,2928,2753, 35520,2927,2752, 35519,2926,2751, 
25, // chain 167
2762,2937,2762, 2753,2928,2753, 2754,2929,2754, 
2763,2938,2763, 35523,2930,2755, 2764,2939,2764, 35524,2931,2756, 2765,2940,2765, 35525,2932,2757, 2766,2941,2766, 35526,2933,2758, 1128,1280,1128, 1129,1281,1129, 2767,2942,2767, 33898,1282,1130, 1131,1283,1131, 2768,2943,2768, 33900,1284,1132, 2769,2944,2769, 
35538,2945,2770, 33901,1285,1133, 2771,2946,2771, 33902,1286,1134, 1135,1287,1135, 2772,2947,2772, 33217,456,449, 33216,455,448, 
2, // chain 168
2759,2934,2759, 2773,2948,2773, 2747,2922,2747, 
2748,2923,2748, 
11, // chain 169
2773,2948,2773, 2759,2934,2759, 2761,2936,2761, 
2774,2949,2774, 35543,2950,2775, 35530,2937,2762, 2763,2938,2763, 2776,2951,2776, 35532,2939,2764, 2777,2952,2777, 35533,2940,2765, 2767,2942,2767, 35534,2941,2766, 
2, // chain 170
2698,2873,2698, 803,868,803, 804,869,804, 
805,870,805, 
84, // chain 171
803,868,803, 2698,2873,2698, 2778,2953,2778, 
802,867,802, 35547,2954,2779, 35548,2955,2780, 35549,2956,2781, 35466,2873,2698, 2699,2874,2699, 2700,2875,2700, 2782,2957,2782, 35551,2958,2783, 35469,2876,2701, 2784,2959,2784, 35470,2877,2702, 2703,2878,2703, 2785,2960,2785, 35472,2879,2704, 2786,2961,2786, 
35473,2880,2705, 2787,2962,2787, 35474,2881,2706, 2788,2963,2788, 35557,2964,2789, 35475,2882,2707, 2790,2965,2790, 35559,2966,2791, 35476,2883,2708, 2709,2884,2709, 2792,2967,2792, 35478,2885,2710, 2793,2968,2793, 35479,2886,2711, 2794,2969,2794, 35480,2887,2712, 
2795,2970,2795, 35481,2888,2713, 2796,2971,2796, 35482,2889,2714, 2797,2972,2797, 35483,2890,2715, 2798,2973,2798, 35484,2891,2716, 2799,2974,2799, 35485,2892,2717, 2800,2975,2800, 35486,2893,2718, 2801,2976,2801, 35487,2894,2719, 2802,2977,2802, 2803,2978,2803, 
35572,2979,2804, 2805,2980,2805, 35574,2981,2806, 2807,2982,2807, 35576,2983,2808, 2809,2984,2809, 35578,2985,2810, 2811,2986,2811, 35580,2987,2812, 2813,2988,2813, 35582,2989,2814, 2815,2990,2815, 2816,2991,2816, 35585,2992,2817, 2818,2993,2818, 35587,2994,2819, 
2820,2995,2820, 35589,2996,2821, 2822,2997,2822, 35591,2998,2823, 2824,2999,2824, 35593,3000,2825, 2826,3001,2826, 35595,3002,2827, 2828,3003,2828, 35597,3004,2829, 2830,3005,2830, 35599,3006,2831, 35600,3007,2832, 2833,3008,2833, 34933,3009,2165, 2834,3010,2834, 
34825,3011,2057, 612,3012,612, 33382,3013,614, 
7, // chain 172
802,867,802, 2779,2954,2779, 801,866,801, 
35603,3014,2835, 35604,3015,2836, 35548,2955,2780, 2837,3016,2837, 35550,2957,2782, 35549,2956,2781, 
70, // chain 173
2783,2958,2783, 2784,2959,2784, 2838,3017,2838, 
35607,3018,2839, 35553,2960,2785, 2840,3019,2840, 35554,2961,2786, 2787,2962,2787, 2841,3020,2841, 35556,2963,2788, 2842,3021,2842, 35611,3022,2843, 35557,2964,2789, 2844,3023,2844, 35558,2965,2790, 2845,3024,2845, 35614,3025,2846, 35559,2966,2791, 2792,2967,2792, 
2847,3026,2847, 35561,2968,2793, 2848,3027,2848, 35562,2969,2794, 2849,3028,2849, 35563,2970,2795, 2850,3029,2850, 35564,2971,2796, 2851,3030,2851, 35565,2972,2797, 2852,3031,2852, 35566,2973,2798, 2853,3032,2853, 35567,2974,2799, 2854,3033,2854, 35568,2975,2800, 
2855,3034,2855, 35569,2976,2801, 2803,2978,2803, 2856,3035,2856, 35573,2980,2805, 2857,3036,2857, 35575,2982,2807, 2858,3037,2858, 35577,2984,2809, 2859,3038,2859, 35579,2986,2811, 2860,3039,2860, 35581,2988,2813, 2816,2991,2816, 2861,3040,2861, 35586,2993,2818, 
2862,3041,2862, 35588,2995,2820, 2863,3042,2863, 35590,2997,2822, 2864,3043,2864, 35592,2999,2824, 2865,3044,2865, 35594,3001,2826, 967,1055,967, 35596,3003,2828, 966,1054,966, 35598,3005,2830, 965,1053,965, 33732,1052,964, 35599,3006,2831, 963,1051,963, 
35601,3008,2833, 962,1050,962, 35602,3010,2834, 611,1049,611, 33380,3012,612, 
3, // chain 174
2838,3017,2838, 2866,3045,2866, 2837,3016,2837, 
2783,2958,2783, 35550,2957,2782, 
6, // chain 175
2866,3045,2866, 2838,3017,2838, 2867,3046,2867, 
2868,3047,2868, 35637,3048,2869, 35638,3049,2870, 35607,3018,2839, 35606,3017,2838, 
8, // chain 176
2869,3048,2869, 2870,3049,2870, 2871,3050,2871, 
2872,3051,2872, 35641,3052,2873, 35610,3021,2842, 35609,3020,2841, 35638,3049,2870, 2840,3019,2840, 35607,3018,2839, 
2, // chain 177
2866,3045,2866, 2874,3053,2874, 2836,3015,2836, 
2837,3016,2837, 
57, // chain 178
2874,3053,2874, 2866,3045,2866, 2868,3047,2868, 
2875,3054,2875, 35644,3055,2876, 35637,3048,2869, 2872,3051,2872, 2877,3056,2877, 35646,3057,2878, 35641,3052,2873, 2879,3058,2879, 35648,3059,2880, 35610,3021,2842, 2843,3022,2843, 2881,3060,2881, 35612,3023,2844, 2882,3061,2882, 35613,3024,2845, 2883,3062,2883, 
35652,3063,2884, 35614,3025,2846, 2847,3026,2847, 2885,3064,2885, 35616,3027,2848, 2886,3065,2886, 35617,3028,2849, 2887,3066,2887, 35618,3029,2850, 2888,3067,2888, 35619,3030,2851, 2889,3068,2889, 35620,3031,2852, 2890,3069,2890, 35621,3032,2853, 2891,3070,2891, 
35622,3033,2854, 2892,3071,2892, 35623,3034,2855, 2856,3035,2856, 2893,3072,2893, 35625,3036,2857, 2894,3073,2894, 35626,3037,2858, 2895,3074,2895, 35627,3038,2859, 2896,3075,2896, 35628,3039,2860, 2897,3076,2897, 35629,3040,2861, 2898,3077,2898, 35630,3041,2862, 
2899,3078,2899, 35631,3042,2863, 2900,3079,2900, 35632,3043,2864, 2901,3080,2901, 35633,3044,2865, 968,1056,968, 33735,1055,967, 
18, // chain 179
2738,2913,2738, 2739,2914,2739, 2902,3081,2902, 
35671,3082,2903, 35508,2915,2740, 2904,3083,2904, 35509,2916,2741, 2905,3084,2905, 35510,2917,2742, 2906,3085,2906, 35511,2918,2743, 2907,3086,2907, 35512,2919,2744, 2908,3087,2908, 35513,2920,2745, 2909,3088,2909, 35514,2921,2746, 2910,3089,2910, 35541,2948,2773, 
35515,2922,2747, 
16, // chain 180
2903,3082,2903, 2904,3083,2904, 2911,3090,2911, 
35680,3091,2912, 35673,3084,2905, 2913,3092,2913, 35674,3085,2906, 2914,3093,2914, 35675,3086,2907, 2915,3094,2915, 35676,3087,2908, 2916,3095,2916, 35677,3088,2909, 2917,3096,2917, 35678,3089,2910, 2918,3097,2918, 35542,2949,2774, 35541,2948,2773, 
20, // chain 181
2912,3091,2912, 2913,3092,2913, 2919,3098,2919, 
35688,3099,2920, 35682,3093,2914, 2921,3100,2921, 35683,3094,2915, 2922,3101,2922, 35684,3095,2916, 2923,3102,2923, 35685,3096,2917, 2924,3103,2924, 35686,3097,2918, 2925,3104,2925, 35694,3105,2926, 35542,2949,2774, 2775,2950,2775, 2776,2951,2776, 2927,3106,2927, 
35545,2952,2777, 2768,2943,2768, 35535,2942,2767, 
12, // chain 182
2920,3099,2920, 2921,3100,2921, 450,457,450, 
35696,3107,2928, 35690,3101,2922, 2772,2947,2772, 35691,3102,2923, 2771,2946,2771, 35692,3103,2924, 2770,2945,2770, 35693,3104,2925, 2769,2944,2769, 35695,3106,2927, 35694,3105,2926, 
16, // chain 183
2911,3090,2911, 2929,3108,2929, 2930,3109,2930, 
2903,3082,2903, 35670,3081,2902, 35699,3110,2931, 35700,3111,2932, 35697,3108,2929, 454,461,454, 33221,460,453, 35701,3112,2933, 35679,3090,2911, 2912,3091,2912, 2919,3098,2919, 452,459,452, 33219,458,451, 35688,3099,2920, 450,457,450, 
3, // chain 184
2934,3113,2934, 799,864,799, 800,865,800, 
2835,3014,2835, 33569,866,801, 
9, // chain 185
799,864,799, 2934,3113,2934, 2935,3114,2935, 
798,863,798, 35704,3115,2936, 35705,3116,2937, 35643,3054,2875, 35702,3113,2934, 2874,3053,2874, 35603,3014,2835, 2836,3015,2836, 
7, // chain 186
798,863,798, 2936,3115,2936, 797,862,797, 
35706,3117,2938, 35707,3118,2939, 35705,3116,2937, 2877,3056,2877, 35644,3055,2876, 35643,3054,2875, 
48, // chain 187
2877,3056,2877, 2878,3057,2878, 2940,3119,2940, 
35709,3120,2941, 35647,3058,2879, 2942,3121,2942, 35711,3122,2943, 35648,3059,2880, 2881,3060,2881, 2944,3123,2944, 35650,3061,2882, 2945,3124,2945, 35651,3062,2883, 2946,3125,2946, 35715,3126,2947, 35652,3063,2884, 2885,3064,2885, 2948,3127,2948, 35654,3065,2886, 
2949,3128,2949, 35655,3066,2887, 2950,3129,2950, 35656,3067,2888, 2951,3130,2951, 35657,3068,2889, 2952,3131,2952, 35658,3069,2890, 2953,3132,2953, 35659,3070,2891, 2954,3133,2954, 35660,3071,2892, 2893,3072,2893, 2955,3134,2955, 35662,3073,2894, 2956,3135,2956, 
35663,3074,2895, 2957,3136,2957, 35664,3075,2896, 2958,3137,2958, 35665,3076,2897, 2959,3138,2959, 35666,3077,2898, 2960,3139,2960, 35667,3078,2899, 2961,3140,2961, 35668,3079,2900, 2962,3141,2962, 35669,3080,2901, 969,1057,969, 33736,1056,968, 
41, // chain 188
2941,3120,2941, 2942,3121,2942, 2963,3142,2963, 
35732,3143,2964, 35733,3144,2965, 35711,3122,2943, 2944,3123,2944, 2966,3145,2966, 35713,3124,2945, 2967,3146,2967, 35714,3125,2946, 2968,3147,2968, 35737,3148,2969, 35715,3126,2947, 2948,3127,2948, 2970,3149,2970, 35717,3128,2949, 2971,3150,2971, 35718,3129,2950, 
2972,3151,2972, 35719,3130,2951, 2973,3152,2973, 35720,3131,2952, 2974,3153,2974, 35721,3132,2953, 2975,3154,2975, 35722,3133,2954, 2955,3134,2955, 2976,3155,2976, 35724,3135,2956, 2977,3156,2977, 35725,3136,2957, 2958,3137,2958, 2978,3157,2978, 35727,3138,2959, 
2979,3158,2979, 35728,3139,2960, 2980,3159,2980, 35729,3140,2961, 2981,3160,2981, 35730,3141,2962, 970,1058,970, 33737,1057,969, 
2, // chain 189
2940,3119,2940, 2982,3161,2982, 2939,3118,2939, 
2877,3056,2877, 
7, // chain 190
2982,3161,2982, 2940,3119,2940, 2983,3162,2983, 
2984,3163,2984, 35753,3164,2985, 35754,3165,2986, 35731,3142,2963, 35709,3120,2941, 35708,3119,2940, 
58, // chain 191
2967,3146,2967, 2968,3147,2968, 2987,3166,2987, 
35756,3167,2988, 35757,3168,2989, 35737,3148,2969, 2970,3149,2970, 2990,3169,2990, 35739,3150,2971, 2991,3170,2991, 35740,3151,2972, 2992,3171,2992, 35741,3152,2973, 2993,3172,2993, 35742,3153,2974, 2994,3173,2994, 35743,3154,2975, 2976,3155,2976, 2995,3174,2995, 
35745,3156,2977, 2978,3157,2978, 2996,3175,2996, 35747,3158,2979, 2997,3176,2997, 35748,3159,2980, 2998,3177,2998, 35749,3160,2981, 2999,3178,2999, 33738,1058,970, 971,1059,971, 972,1060,972, 3000,3179,3000, 33741,1061,973, 3001,3180,3001, 33742,1062,974, 
3002,3181,3002, 35771,3182,3003, 33743,1063,975, 976,1064,976, 3004,3183,3004, 33745,1065,977, 3005,3184,3005, 33746,1066,978, 3006,3185,3006, 35775,3186,3007, 33747,1067,979, 980,1068,980, 3008,3187,3008, 33749,1069,981, 3009,3188,3009, 33750,1070,982, 
2986,3165,2986, 35753,3164,2985, 33751,1071,983, 984,1072,984, 2984,3163,2984, 33753,1073,985, 3010,3189,3010, 33564,861,796, 33563,860,795, 
27, // chain 192
2965,3144,2965, 2966,3145,2966, 3011,3190,3011, 
35780,3191,3012, 35735,3146,2967, 2987,3166,2987, 3013,3192,3013, 35782,3193,3014, 35756,3167,2988, 3015,3194,3015, 35757,3168,2989, 2990,3169,2990, 3016,3195,3016, 35759,3170,2991, 3017,3196,3017, 35760,3171,2992, 3018,3197,3018, 35761,3172,2993, 3019,3198,3019, 
35762,3173,2994, 2995,3174,2995, 3020,3199,3020, 35764,3175,2996, 3021,3200,3021, 35765,3176,2997, 3022,3201,3022, 35766,3177,2998, 3000,3179,3000, 35767,3178,2999, 
2, // chain 193
2928,3107,2928, 2772,2947,2772, 449,456,449, 
450,457,450, 
2, // chain 194
2982,3161,2982, 3010,3189,3010, 2938,3117,2938, 
2939,3118,2939, 
1, // chain 195
2984,3163,2984, 3010,3189,3010, 2982,3161,2982, 
6, // chain 196
3009,3188,3009, 2986,3165,2986, 3023,3202,3023, 
3024,3203,3024, 35779,3190,3011, 35732,3143,2964, 35731,3142,2963, 35754,3165,2986, 
3, // chain 197
3025,3204,3025, 3008,3187,3008, 3024,3203,3024, 
3012,3191,3012, 35779,3190,3011, 
4, // chain 198
3007,3186,3007, 3008,3187,3008, 3025,3204,3025, 
3006,3185,3006, 35781,3192,3013, 35780,3191,3012, 
17, // chain 199
3026,3205,3026, 3013,3192,3013, 3014,3193,3014, 
3027,3206,3027, 35783,3194,3015, 3016,3195,3016, 3028,3207,3028, 35797,3208,3029, 35785,3196,3017, 3030,3209,3030, 35786,3197,3018, 3019,3198,3019, 3020,3199,3020, 3031,3210,3031, 35789,3200,3021, 3032,3211,3032, 35790,3201,3022, 3001,3180,3001, 35768,3179,3000, 
10, // chain 200
3006,3185,3006, 3013,3192,3013, 3026,3205,3026, 
3005,3184,3005, 35801,3212,3033, 35795,3206,3027, 3028,3207,3028, 3034,3213,3034, 35803,3214,3035, 35797,3208,3029, 3031,3210,3031, 35798,3209,3030, 
3, // chain 201
3002,3181,3002, 3034,3213,3034, 3035,3214,3035, 
3032,3211,3032, 35799,3210,3031, 
4, // chain 202
3034,3213,3034, 3002,3181,3002, 3003,3182,3003, 
3004,3183,3004, 3033,3212,3033, 35773,3184,3005, 
1, // chain 203
3032,3211,3032, 3001,3180,3001, 3002,3181,3002, 
8, // chain 204
1368,1520,1368, 1654,1807,1654, 3036,3215,3036, 
35805,3216,3037, 35806,3217,3038, 34423,1808,1655, 1673,1826,1673, 3039,3218,3039, 34528,1913,1760, 34442,1827,1674, 
6, // chain 205
3037,3216,3037, 3038,3217,3038, 3040,3219,3040, 
35809,3220,3041, 35807,3218,3039, 3042,3221,3042, 34543,1928,1775, 34528,1913,1760, 
6, // chain 206
3042,3221,3042, 1775,1928,1775, 3043,3222,3043, 
3044,3223,3044, 35813,3224,3045, 35814,3225,3046, 34544,1929,1776, 34543,1928,1775, 
30, // chain 207
3047,3226,3047, 3042,3221,3042, 3044,3223,3044, 
3048,3227,3048, 35817,3228,3049, 35813,3224,3045, 3050,3229,3050, 35819,3230,3051, 35814,3225,3046, 3052,3231,3052, 35821,3232,3053, 34544,1929,1776, 1777,1930,1777, 1800,1953,1800, 2168,2343,2168, 3052,3231,3052, 35822,3233,3054, 34937,2344,2169, 3055,3234,3055, 
35824,3235,3056, 34938,2345,2170, 3057,3236,3057, 35826,3237,3058, 34939,2346,2171, 3059,3238,3059, 34940,2347,2172, 3060,3239,3060, 35829,3240,3061, 34941,2348,2173, 2206,2381,2206, 2430,2605,2430, 34976,2383,2208, 
4, // chain 208
3041,3220,3041, 3042,3221,3042, 3047,3226,3047, 
3062,3241,3062, 35831,3242,3063, 35816,3227,3048, 
12, // chain 209
3040,3219,3040, 3064,3243,3064, 3065,3244,3065, 
3037,3216,3037, 35804,3215,3036, 35834,3245,3066, 35835,3246,3067, 35836,3247,3068, 35832,3243,3064, 3069,3248,3069, 35838,3249,3070, 35830,3241,3062, 35808,3219,3040, 3041,3220,3041, 
23, // chain 210
3052,3231,3052, 3054,3233,3054, 3071,3250,3071, 
35840,3251,3072, 35823,3234,3055, 3073,3252,3073, 35842,3253,3074, 35824,3235,3056, 3075,3254,3075, 35825,3236,3057, 3076,3255,3076, 35845,3256,3077, 35826,3237,3058, 3078,3257,3078, 35827,3238,3059, 3079,3258,3079, 35828,3239,3060, 3080,3259,3080, 35849,3260,3081, 
35829,3240,3061, 2430,2605,2430, 2431,2606,2431, 3082,3261,3082, 35223,2630,2455, 35200,2607,2432, 
21, // chain 211
3072,3251,3072, 3073,3252,3073, 3083,3262,3083, 
35852,3263,3084, 35853,3264,3085, 35842,3253,3074, 3086,3265,3086, 35843,3254,3075, 3087,3266,3087, 35844,3255,3076, 3088,3267,3088, 35857,3268,3089, 35845,3256,3077, 3090,3269,3090, 35846,3257,3078, 3091,3270,3091, 35847,3258,3079, 3092,3271,3092, 35848,3259,3080, 
3093,3272,3093, 35862,3273,3094, 35850,3261,3082, 35849,3260,3081, 
3, // chain 212
3095,3274,3095, 3096,3275,3096, 3071,3250,3071, 
35819,3230,3051, 35818,3229,3050, 
6, // chain 213
3097,3276,3097, 3063,3277,3063, 3098,3278,3098, 
3099,3279,3099, 35868,3280,3100, 35869,3281,3101, 35816,3282,3048, 35831,3277,3063, 
13, // chain 214
3070,3283,3070, 3063,3277,3063, 3097,3276,3097, 
3102,3284,3102, 35871,3285,3103, 35867,3279,3099, 3104,3286,3104, 35873,3287,3105, 35868,3280,3100, 3106,3288,3106, 35875,3289,3107, 35869,3281,3101, 3108,3290,3108, 35817,3291,3049, 35816,3282,3048, 
26, // chain 215
3109,3292,3109, 3110,3293,3110, 3111,3294,3111, 
3112,3295,3112, 35881,3296,3113, 35882,3297,3114, 35883,3298,3115, 35878,3293,3110, 3096,3299,3096, 35818,3300,3050, 35876,3290,3108, 35877,3292,3109, 3107,3289,3107, 35884,3301,3116, 35880,3295,3112, 3117,3302,3117, 35886,3303,3118, 35881,3296,3113, 3119,3304,3119, 
35888,3305,3120, 35889,3306,3121, 35882,3297,3114, 3122,3307,3122, 35891,3308,3123, 35892,3309,3124, 35883,3298,3115, 3095,3310,3095, 35864,3299,3096, 
21, // chain 216
3125,3311,3125, 3116,3301,3116, 3117,3302,3117, 
3126,3312,3126, 35895,3313,3127, 35886,3303,3118, 3128,3314,3128, 35897,3315,3129, 35887,3304,3119, 3130,3316,3130, 35888,3305,3120, 3131,3317,3131, 35900,3318,3132, 35889,3306,3121, 3122,3307,3122, 3133,3319,3133, 35902,3320,3134, 35903,3321,3135, 35891,3308,3123, 
3136,3322,3136, 35892,3309,3124, 3083,3323,3083, 35863,3310,3095, 
2, // chain 217
3116,3301,3116, 3125,3311,3125, 3106,3288,3106, 
3107,3289,3107, 
3, // chain 218
3137,3324,3137, 3135,3321,3135, 3136,3322,3136, 
3084,3325,3084, 35851,3323,3083, 
8, // chain 219
3135,3321,3135, 3137,3324,3137, 3138,3326,3138, 
3134,3320,3134, 35907,3327,3139, 35908,3328,3140, 35909,3329,3141, 35905,3324,3137, 3142,3330,3142, 35852,3325,3084, 
14, // chain 220
3133,3319,3133, 3139,3327,3139, 3143,3331,3143, 
3144,3332,3144, 35913,3333,3145, 35914,3334,3146, 35915,3335,3147, 35916,3336,3148, 35907,3327,3139, 3140,3328,3140, 3149,3337,3149, 35918,3338,3150, 35909,3329,3141, 3151,3339,3151, 35920,3340,3152, 35910,3330,3142, 
1, // chain 221
3134,3320,3134, 3139,3327,3139, 3133,3319,3133, 
10, // chain 222
3125,3311,3125, 3153,3341,3153, 3154,3342,3154, 
3106,3288,3106, 35873,3287,3105, 35923,3343,3155, 35924,3344,3156, 35921,3341,3153, 3157,3345,3157, 35926,3346,3158, 35894,3312,3126, 35893,3311,3125, 
27, // chain 223
3126,3312,3126, 3127,3313,3127, 3159,3347,3159, 
35928,3348,3160, 35896,3314,3128, 3161,3349,3161, 35930,3350,3162, 35897,3315,3129, 3163,3351,3163, 35898,3316,3130, 3164,3352,3164, 35899,3317,3131, 3165,3353,3165, 35934,3354,3166, 35900,3318,3132, 3133,3319,3133, 3144,3332,3144, 3167,3355,3167, 35936,3356,3168, 
35913,3333,3145, 3169,3357,3169, 35938,3358,3170, 35914,3334,3146, 3171,3359,3171, 35940,3360,3172, 35915,3335,3147, 3173,3361,3173, 35917,3337,3149, 35916,3336,3148, 
13, // chain 224
3160,3348,3160, 3161,3349,3161, 3174,3362,3174, 
35943,3363,3175, 35944,3364,3176, 35930,3350,3162, 3177,3365,3177, 35931,3351,3163, 3178,3366,3178, 35932,3352,3164, 3179,3367,3179, 35933,3353,3165, 3180,3368,3180, 35935,3355,3167, 35934,3354,3166, 
34, // chain 225
3181,3369,3181, 3175,3363,3175, 3176,3364,3176, 
3182,3370,3182, 35945,3365,3177, 3183,3371,3183, 35946,3366,3178, 3184,3372,3184, 35947,3367,3179, 3185,3373,3185, 35948,3368,3180, 3186,3374,3186, 35955,3375,3187, 35935,3355,3167, 3168,3356,3168, 3188,3376,3188, 35937,3357,3169, 3189,3377,3189, 35958,3378,3190, 
35938,3358,3170, 3191,3379,3191, 35939,3359,3171, 3192,3380,3192, 35961,3381,3193, 35940,3360,3172, 3194,3382,3194, 35941,3361,3173, 3195,3383,3195, 35917,3337,3149, 3196,3384,3196, 35918,3338,3150, 3197,3385,3197, 35919,3339,3151, 3198,3386,3198, 35967,3387,3199, 
35920,3340,3152, 
46, // chain 226
3175,3363,3175, 3181,3369,3181, 3200,3388,3200, 
3201,3389,3201, 35970,3390,3202, 35971,3391,3203, 35972,3392,3204, 35949,3369,3181, 3205,3393,3205, 35950,3370,3182, 3206,3394,3206, 35951,3371,3183, 3207,3395,3207, 35952,3372,3184, 3208,3396,3208, 35953,3373,3185, 3209,3397,3209, 35954,3374,3186, 3210,3398,3210, 
35979,3399,3211, 35955,3375,3187, 3188,3376,3188, 3212,3400,3212, 35957,3377,3189, 3213,3401,3213, 35982,3402,3214, 35958,3378,3190, 3215,3403,3215, 35959,3379,3191, 3216,3404,3216, 35960,3380,3192, 3217,3405,3217, 35986,3406,3218, 35961,3381,3193, 3219,3407,3219, 
35962,3382,3194, 3220,3408,3220, 35963,3383,3195, 3221,3409,3221, 35990,3410,3222, 35964,3384,3196, 3223,3411,3223, 35965,3385,3197, 3224,3412,3224, 35966,3386,3198, 3225,3413,3225, 35994,3414,3226, 35967,3387,3199, 
2, // chain 227
3159,3347,3159, 3227,3415,3227, 3158,3346,3158, 
3126,3312,3126, 
6, // chain 228
3227,3415,3227, 3159,3347,3159, 3228,3416,3228, 
3229,3417,3229, 35998,3418,3230, 35942,3362,3174, 35928,3348,3160, 35927,3347,3159, 
83, // chain 229
3230,3418,3230, 3174,3362,3174, 3201,3389,3201, 
3231,3419,3231, 35970,3390,3202, 3232,3420,3232, 36001,3421,3233, 35971,3391,3203, 3234,3422,3234, 35972,3392,3204, 3235,3423,3235, 35973,3393,3205, 3236,3424,3236, 36005,3425,3237, 35974,3394,3206, 3238,3426,3238, 35975,3395,3207, 3239,3427,3239, 35976,3396,3208, 
3240,3428,3240, 35977,3397,3209, 3241,3429,3241, 35978,3398,3210, 3242,3430,3242, 36011,3431,3243, 35979,3399,3211, 3212,3400,3212, 3244,3432,3244, 35981,3401,3213, 3245,3433,3245, 35982,3402,3214, 3246,3434,3246, 35983,3403,3215, 3216,3404,3216, 3247,3435,3247, 
35985,3405,3217, 3248,3436,3248, 35986,3406,3218, 3249,3437,3249, 35987,3407,3219, 3250,3438,3250, 35988,3408,3220, 3251,3439,3251, 35989,3409,3221, 3252,3440,3252, 36021,3441,3253, 35990,3410,3222, 3254,3442,3254, 35991,3443,3223, 3255,3444,3255, 35992,3445,3224, 
3256,3446,3256, 35993,3447,3225, 3226,3448,3226, 3257,3449,3257, 3258,3450,3258, 36027,3451,3259, 3260,3452,3260, 36029,3453,3261, 3262,3454,3262, 36031,3455,3263, 3264,3456,3264, 36033,3457,3265, 3266,3458,3266, 36035,3459,3267, 3268,3460,3268, 36037,3461,3269, 
3270,3462,3270, 36039,3463,3271, 3272,3464,3272, 36041,3465,3273, 3274,3466,3274, 36043,3467,3275, 3276,3468,3276, 36045,3469,3277, 3278,3470,3278, 36047,3471,3279, 3280,3472,3280, 36049,3473,3281, 3282,3474,3282, 36051,3475,3283, 3284,3476,3284, 36053,3477,3285, 
3286,3478,3286, 36055,3479,3287, 
52, // chain 230
2339,2514,2339, 2340,2515,2340, 3288,3480,3288, 
36057,3481,3289, 35109,2516,2341, 2342,2517,2342, 3290,3482,3290, 35111,2518,2343, 3291,3483,3291, 36060,3484,3292, 35112,2519,2344, 3293,3485,3293, 35113,2520,2345, 3294,3486,3294, 35114,2521,2346, 3295,3487,3295, 35115,2522,2347, 3296,3488,3296, 35116,2523,2348, 
3297,3489,3297, 36066,3490,3298, 35117,2524,2349, 2350,2525,2350, 3299,3491,3299, 35119,2526,2351, 3300,3492,3300, 35120,2527,2352, 2353,2528,2353, 3301,3493,3301, 35122,2529,2354, 3302,3494,3302, 35123,2530,2355, 3303,3495,3303, 35124,2531,2356, 3304,3496,3304, 
35125,2532,2357, 3305,3497,3305, 35126,2533,2358, 3306,3498,3306, 36075,3499,3307, 35127,2534,2359, 3308,3500,3308, 36077,3501,3309, 35128,2535,2360, 3310,3502,3310, 36079,3503,3311, 35129,2536,2361, 3312,3504,3312, 36081,3505,3313, 35130,2537,2362, 2363,2538,2363, 
3314,3506,3314, 35133,2540,2365, 35132,2539,2364, 
63, // chain 231
2337,2512,2337, 2338,2513,2338, 3315,3507,3315, 
36084,3508,3316, 35107,2514,2339, 3288,3480,3288, 3317,3509,3317, 36086,3510,3318, 36057,3481,3289, 3290,3482,3290, 3319,3511,3319, 36059,3483,3291, 3320,3512,3320, 36089,3513,3321, 36060,3484,3292, 3322,3514,3322, 36091,3515,3323, 36061,3485,3293, 3324,3516,3324, 
36062,3486,3294, 3325,3517,3325, 36063,3487,3295, 3326,3518,3326, 36064,3488,3296, 3327,3519,3327, 36065,3489,3297, 3328,3520,3328, 36097,3521,3329, 36066,3490,3298, 3299,3491,3299, 3330,3522,3330, 36068,3492,3300, 3301,3493,3301, 3331,3523,3331, 36070,3494,3302, 
3332,3524,3332, 36071,3495,3303, 3333,3525,3333, 36072,3496,3304, 3334,3526,3334, 36103,3527,3335, 36073,3497,3305, 3336,3528,3336, 36074,3498,3306, 3337,3529,3337, 36106,3530,3338, 36075,3499,3307, 3339,3531,3339, 36076,3500,3308, 3340,3532,3340, 36109,3533,3341, 
36077,3501,3309, 3310,3502,3310, 3342,3534,3342, 36111,3535,3343, 36079,3503,3311, 3344,3536,3344, 36080,3504,3312, 3345,3537,3345, 36114,3538,3346, 36081,3505,3313, 3314,3506,3314, 3347,3539,3347, 35134,2541,2366, 35133,2540,2365, 
19, // chain 232
3348,3540,3348, 3349,3541,3349, 3350,3542,3350, 
3351,3543,3351, 36120,3544,3352, 33133,371,365, 33132,370,364, 36117,3541,3349, 363,369,363, 36121,3545,3353, 36122,3546,3354, 36116,3540,3348, 3355,3547,3355, 36124,3548,3356, 36119,3543,3351, 3357,3549,3357, 36126,3550,3358, 36120,3544,3352, 3359,3551,3359, 
33134,372,366, 33133,371,365, 
161, // chain 233
3360,3552,3360, 367,373,367, 368,374,368, 
3361,3553,3361, 33137,375,369, 3362,3554,3362, 33138,376,370, 3363,3555,3363, 33139,377,371, 3364,3556,3364, 33140,378,372, 3365,3557,3365, 33141,379,373, 3366,3558,3366, 33142,380,374, 3367,3559,3367, 33143,381,375, 3368,3560,3368, 33144,382,376, 
3369,3561,3369, 33145,383,377, 3370,3562,3370, 33146,384,378, 379,385,379, 3371,3563,3371, 33148,386,380, 3372,3564,3372, 33149,387,381, 3373,3565,3373, 33150,388,382, 383,389,383, 3374,3566,3374, 33152,390,384, 3375,3567,3375, 33153,391,385, 
3376,3568,3376, 33154,392,386, 387,393,387, 3377,3569,3377, 33156,394,388, 3378,3570,3378, 33157,395,389, 3379,3571,3379, 33158,396,390, 3380,3572,3380, 33159,397,391, 3381,3573,3381, 33160,398,392, 3382,3574,3382, 33161,399,393, 3383,3575,3383, 
33162,400,394, 3384,3576,3384, 33163,401,395, 3385,3577,3385, 33164,402,396, 3386,3578,3386, 33165,403,397, 3387,3579,3387, 33166,404,398, 3388,3580,3388, 33167,405,399, 3389,3581,3389, 36158,3582,3390, 33168,406,400, 3391,3583,3391, 33169,407,401, 
3392,3584,3392, 33170,408,402, 3393,3585,3393, 33171,409,403, 3394,3586,3394, 33172,410,404, 405,411,405, 3395,3587,3395, 33174,412,406, 3396,3588,3396, 33175,413,407, 3397,3589,3397, 36166,3590,3398, 33176,414,408, 3399,3591,3399, 33177,415,409, 
3400,3592,3400, 33178,416,410, 3401,3593,3401, 33179,417,411, 3402,3594,3402, 33180,418,412, 413,419,413, 3403,3595,3403, 33182,420,414, 3404,3596,3404, 33183,421,415, 3405,3597,3405, 33184,422,416, 3406,3598,3406, 33185,423,417, 3407,3599,3407, 
36176,3600,3408, 33186,424,418, 3409,3601,3409, 33187,425,419, 3410,3602,3410, 33188,426,420, 3411,3603,3411, 33189,427,421, 3412,3604,3412, 33190,428,422, 3413,3605,3413, 33191,429,423, 3414,3606,3414, 33192,430,424, 425,431,425, 3415,3607,3415, 
33194,432,426, 3416,3608,3416, 33195,433,427, 3417,3609,3417, 32949,434,181, 179,3610,179, 3418,3611,3418, 32946,3612,178, 3419,3613,3419, 32944,3614,176, 3420,3615,3420, 32942,3616,174, 3421,3617,3421, 32940,3618,172, 3422,3619,3422, 32938,3620,170, 
3423,3621,3423, 32936,3622,168, 3424,3623,3424, 32934,3624,166, 3425,3625,3425, 32932,3626,164, 3426,3627,3426, 32930,3628,162, 3427,3629,3427, 32928,3630,160, 3428,3631,3428, 32926,3632,158, 3429,3633,3429, 32924,3634,156, 3430,3635,3430, 32922,3636,154, 
3431,3637,3431, 32920,3638,152, 3432,3639,3432, 32918,3640,150, 3433,3641,3433, 32916,3642,148, 3434,3643,3434, 32914,3644,146, 3435,3645,3435, 32912,3646,144, 3436,3647,3436, 32910,3648,142, 3437,3649,3437, 32908,3650,140, 3438,3651,3438, 32837,3652,69, 
2, // chain 234
367,373,367, 3360,3552,3360, 3359,3551,3359, 
366,372,366, 
201, // chain 235
3439,3653,3439, 3360,3552,3360, 3361,3553,3361, 
3440,3654,3440, 36130,3554,3362, 3441,3655,3441, 36131,3555,3363, 3442,3656,3442, 36132,3556,3364, 3443,3657,3443, 36133,3557,3365, 3444,3658,3444, 36134,3558,3366, 3445,3659,3445, 36135,3559,3367, 3446,3660,3446, 36136,3560,3368, 3447,3661,3447, 36137,3561,3369, 
3370,3562,3370, 3448,3662,3448, 36139,3563,3371, 3449,3663,3449, 36140,3564,3372, 3450,3664,3450, 36141,3565,3373, 3374,3566,3374, 3451,3665,3451, 36143,3567,3375, 3452,3666,3452, 36144,3568,3376, 3453,3667,3453, 36145,3569,3377, 3378,3570,3378, 3454,3668,3454, 
36147,3571,3379, 3455,3669,3455, 36148,3572,3380, 3456,3670,3456, 36149,3573,3381, 3457,3671,3457, 36150,3574,3382, 3458,3672,3458, 36151,3575,3383, 3459,3673,3459, 36152,3576,3384, 3460,3674,3460, 36153,3577,3385, 3461,3675,3461, 36154,3578,3386, 3462,3676,3462, 
36155,3579,3387, 3463,3677,3463, 36156,3580,3388, 3464,3678,3464, 36157,3581,3389, 3465,3679,3465, 36234,3680,3466, 36158,3582,3390, 3467,3681,3467, 36159,3583,3391, 3468,3682,3468, 36160,3584,3392, 3469,3683,3469, 36161,3585,3393, 3470,3684,3470, 36162,3586,3394, 
3395,3587,3395, 3471,3685,3471, 36164,3588,3396, 3472,3686,3472, 36165,3589,3397, 3473,3687,3473, 36242,3688,3474, 36166,3590,3398, 3475,3689,3475, 36167,3591,3399, 3476,3690,3476, 36168,3592,3400, 3477,3691,3477, 36169,3593,3401, 3478,3692,3478, 36170,3594,3402, 
3403,3595,3403, 3479,3693,3479, 36172,3596,3404, 3480,3694,3480, 36173,3597,3405, 3481,3695,3481, 36174,3598,3406, 3482,3696,3482, 36175,3599,3407, 3483,3697,3483, 36252,3698,3484, 36176,3600,3408, 3485,3699,3485, 36177,3601,3409, 3486,3700,3486, 36178,3602,3410, 
3487,3701,3487, 36179,3603,3411, 3488,3702,3488, 36180,3604,3412, 3489,3703,3489, 36181,3605,3413, 3490,3704,3490, 36182,3606,3414, 3415,3607,3415, 3491,3705,3491, 36184,3608,3416, 3492,3706,3492, 36185,3609,3417, 3418,3611,3418, 3493,3707,3493, 36187,3613,3419, 
3494,3708,3494, 36188,3615,3420, 3495,3709,3495, 36189,3617,3421, 3496,3710,3496, 36190,3619,3422, 3497,3711,3497, 36191,3621,3423, 3498,3712,3498, 36192,3623,3424, 3499,3713,3499, 36193,3625,3425, 3500,3714,3500, 36194,3627,3426, 3501,3715,3501, 36195,3629,3427, 
3502,3716,3502, 36196,3631,3428, 3503,3717,3503, 36197,3633,3429, 3504,3718,3504, 36198,3635,3430, 3505,3719,3505, 36199,3637,3431, 3506,3720,3506, 36200,3639,3432, 3507,3721,3507, 36201,3641,3433, 3508,3722,3508, 36202,3643,3434, 3509,3723,3509, 36203,3645,3435, 
3510,3724,3510, 36204,3647,3436, 3511,3725,3511, 36205,3649,3437, 3438,3651,3438, 3512,3726,3512, 3513,3727,3513, 3514,3728,3514, 36283,3729,3515, 3516,3730,3516, 36285,3731,3517, 3518,3732,3518, 36287,3733,3519, 3520,3734,3520, 36289,3735,3521, 3522,3736,3522, 
36291,3737,3523, 3524,3738,3524, 36293,3739,3525, 3526,3740,3526, 36295,3741,3527, 3528,3742,3528, 36297,3743,3529, 3530,3744,3530, 36055,3745,3287, 3285,3746,3285, 3531,3747,3531, 36051,3748,3283, 3532,3749,3532, 36049,3750,3281, 3533,3751,3533, 36047,3752,3279, 
3534,3753,3534, 36045,3754,3277, 3535,3755,3535, 36043,3756,3275, 3536,3757,3536, 36041,3758,3273, 3537,3759,3537, 36039,3760,3271, 3538,3761,3538, 36037,3762,3269, 3539,3763,3539, 36035,3764,3267, 3540,3765,3540, 36033,3766,3265, 3541,3767,3541, 36031,3768,3263, 
3542,3769,3542, 36029,3770,3261, 3543,3771,3543, 36027,3772,3259, 3544,3773,3544, 36025,3774,3257, 3545,3775,3545, 35994,3776,3226, 
146, // chain 236
3360,3552,3360, 3439,3653,3439, 3546,3777,3546, 
3359,3551,3359, 36126,3550,3358, 36315,3778,3547, 36316,3779,3548, 36207,3653,3439, 3549,3780,3549, 36208,3654,3440, 3550,3781,3550, 36209,3655,3441, 3551,3782,3551, 36210,3656,3442, 3552,3783,3552, 36211,3657,3443, 3553,3784,3553, 36212,3658,3444, 3554,3785,3554, 
36213,3659,3445, 3555,3786,3555, 36214,3660,3446, 3447,3661,3447, 3556,3787,3556, 36216,3662,3448, 3557,3788,3557, 36217,3663,3449, 3558,3789,3558, 36218,3664,3450, 3451,3665,3451, 3559,3790,3559, 36220,3666,3452, 3560,3791,3560, 36221,3667,3453, 3561,3792,3561, 
36222,3668,3454, 3562,3793,3562, 36223,3669,3455, 3563,3794,3563, 36224,3670,3456, 3564,3795,3564, 36225,3671,3457, 3565,3796,3565, 36226,3672,3458, 3459,3673,3459, 3566,3797,3566, 36228,3674,3460, 3567,3798,3567, 36229,3675,3461, 3568,3799,3568, 36230,3676,3462, 
3569,3800,3569, 36231,3677,3463, 3570,3801,3570, 36232,3678,3464, 3571,3802,3571, 36233,3679,3465, 3572,3803,3572, 36341,3804,3573, 36234,3680,3466, 3574,3805,3574, 36235,3681,3467, 3575,3806,3575, 36236,3682,3468, 3576,3807,3576, 36237,3683,3469, 3470,3684,3470, 
3577,3808,3577, 36239,3685,3471, 3578,3809,3578, 36240,3686,3472, 3579,3810,3579, 36241,3687,3473, 3580,3811,3580, 36242,3688,3474, 3581,3812,3581, 36350,3813,3582, 36243,3689,3475, 3583,3814,3583, 36244,3690,3476, 3584,3815,3584, 36245,3691,3477, 3585,3816,3585, 
36246,3692,3478, 3479,3693,3479, 3586,3817,3586, 36248,3694,3480, 3587,3818,3587, 36249,3695,3481, 3588,3819,3588, 36250,3696,3482, 3589,3820,3589, 36251,3697,3483, 3590,3821,3590, 36359,3822,3591, 36252,3698,3484, 3592,3823,3592, 36253,3699,3485, 3593,3824,3593, 
36254,3700,3486, 3594,3825,3594, 36255,3701,3487, 3595,3826,3595, 36256,3702,3488, 3596,3827,3596, 36257,3703,3489, 3597,3828,3597, 36258,3704,3490, 3491,3705,3491, 3598,3829,3598, 36260,3706,3492, 3493,3707,3493, 3599,3830,3599, 36262,3708,3494, 3600,3831,3600, 
36263,3709,3495, 3601,3832,3601, 36264,3710,3496, 3602,3833,3602, 36265,3711,3497, 3603,3834,3603, 36266,3712,3498, 3604,3835,3604, 36267,3713,3499, 3605,3836,3605, 36268,3714,3500, 3606,3837,3606, 36269,3715,3501, 3607,3838,3607, 36270,3716,3502, 3608,3839,3608, 
36271,3717,3503, 3609,3840,3609, 36272,3718,3504, 3610,3841,3610, 36273,3719,3505, 3611,3842,3611, 36274,3720,3506, 3612,3843,3612, 36275,3721,3507, 3613,3844,3613, 36276,3722,3508, 3614,3845,3614, 36277,3723,3509, 3615,3846,3615, 36278,3724,3510, 3514,3728,3514, 
36279,3725,3511, 
38, // chain 237
2146,2321,2146, 2147,2322,2147, 2413,2588,2413, 
36384,3847,3616, 36385,3848,3617, 34916,2323,2148, 3618,3849,3618, 34917,2324,2149, 2150,2325,2150, 3619,3850,3619, 34919,2326,2151, 3620,3851,3620, 36389,3852,3621, 34920,2327,2152, 3622,3853,3622, 34921,2328,2153, 2154,2329,2154, 3623,3854,3623, 34923,2330,2155, 
3624,3855,3624, 36393,3856,3625, 34924,2331,2156, 3626,3857,3626, 34925,2332,2157, 2158,2333,2158, 3627,3858,3627, 34927,2334,2159, 3628,3859,3628, 36397,3860,3629, 34928,2335,2160, 3630,3861,3630, 34929,2336,2161, 2162,2337,2162, 3631,3862,3631, 34931,2338,2163, 
3632,3863,3632, 36401,3864,3633, 34932,2339,2164, 2832,3865,2832, 34933,2340,2165, 
35, // chain 238
3634,3866,3634, 3616,3847,3616, 3617,3848,3617, 
3635,3867,3635, 36386,3849,3618, 3619,3850,3619, 3636,3868,3636, 36388,3851,3620, 3637,3869,3637, 36406,3870,3638, 36389,3852,3621, 3639,3871,3639, 36390,3853,3622, 3623,3854,3623, 3640,3872,3640, 36392,3855,3624, 3641,3873,3641, 36410,3874,3642, 36393,3856,3625, 
3643,3875,3643, 36394,3857,3626, 3627,3858,3627, 3644,3876,3644, 36396,3859,3628, 3645,3877,3645, 36414,3878,3646, 36397,3860,3629, 3647,3879,3647, 36398,3861,3630, 3631,3862,3631, 3648,3880,3648, 36400,3863,3632, 3649,3881,3649, 36418,3882,3650, 36401,3864,3633, 
2829,3883,2829, 35600,3865,2832, 
119, // chain 239
3616,3847,3616, 3634,3866,3634, 3651,3884,3651, 
2412,2587,2412, 36420,3885,3652, 36402,3866,3634, 3653,3886,3653, 36403,3867,3635, 3654,3887,3654, 36423,3888,3655, 36404,3868,3636, 3656,3889,3656, 36405,3869,3637, 3638,3870,3638, 3657,3890,3657, 36407,3871,3639, 3658,3891,3658, 36427,3892,3659, 36408,3872,3640, 
3660,3893,3660, 36409,3873,3641, 3642,3874,3642, 3661,3894,3661, 36411,3875,3643, 3662,3895,3662, 36431,3896,3663, 36412,3876,3644, 3664,3897,3664, 36413,3877,3645, 3646,3878,3646, 3665,3898,3665, 36415,3879,3647, 3666,3899,3666, 36435,3900,3667, 36416,3880,3648, 
3668,3901,3668, 36417,3881,3649, 3650,3882,3650, 3669,3902,3669, 35597,3883,2829, 2827,3903,2827, 3670,3904,3670, 35593,3905,2825, 3671,3906,3671, 35591,3907,2823, 3672,3908,3672, 35589,3909,2821, 3673,3910,3673, 35587,3911,2819, 3674,3912,3674, 35585,3913,2817, 
3675,3914,3675, 35583,3915,2815, 3676,3916,3676, 35582,3917,2814, 2812,3918,2812, 3677,3919,3677, 35578,3920,2810, 3678,3921,3678, 35576,3922,2808, 3679,3923,3679, 35574,3924,2806, 3680,3925,3680, 35572,3926,2804, 3681,3927,3681, 35570,3928,2802, 3682,3929,3682, 
35487,3930,2719, 3683,3931,3683, 36452,3932,3684, 35488,3933,2720, 3685,3934,3685, 35465,3935,2697, 3686,3936,3686, 35442,3937,2674, 3687,3938,3687, 35443,3939,2675, 3688,3940,3688, 35420,3941,2652, 3689,3942,3689, 35340,3943,2572, 3690,3944,3690, 35317,3945,2549, 
3691,3946,3691, 35187,3947,2419, 3692,3948,3692, 35188,3949,2420, 3693,3950,3693, 35093,3951,2325, 3694,3952,3694, 35094,3953,2326, 3695,3954,3695, 35095,3955,2327, 3696,3956,3696, 35096,3957,2328, 2329,3958,2329, 3697,3959,3697, 36466,3960,3698, 36467,3961,3699, 
3700,3962,3700, 36469,3963,3701, 3702,3964,3702, 36471,3965,3703, 3704,3966,3704, 36473,3967,3705, 3706,3968,3706, 36475,3969,3707, 3708,3970,3708, 36477,3971,3709, 3710,3972,3710, 36479,3973,3711, 3712,3974,3712, 36481,3975,3713, 3714,3976,3714, 36483,3977,3715, 
3716,3978,3716, 36485,3979,3717, 3718,3980,3718, 36090,3514,3322, 3324,3516,3324, 36091,3515,3323, 
9, // chain 240
3719,3981,3719, 3611,3842,3611, 3612,3843,3612, 
3720,3982,3720, 36381,3844,3613, 3721,3983,3721, 36382,3845,3614, 3722,3984,3722, 36383,3846,3615, 3516,3730,3516, 36282,3728,3514, 
14, // chain 241
3611,3842,3611, 3719,3981,3719, 3723,3985,3723, 
3610,3841,3610, 36492,3986,3724, 36493,3987,3725, 36494,3988,3726, 36487,3981,3719, 3727,3989,3727, 36488,3982,3720, 3728,3990,3728, 36489,3983,3721, 3729,3991,3729, 36490,3984,3722, 3518,3732,3518, 36284,3730,3516, 
15, // chain 242
3610,3841,3610, 3724,3986,3724, 3609,3840,3609, 
36498,3992,3730, 36499,3993,3731, 36493,3987,3725, 3732,3994,3732, 36501,3995,3733, 36494,3988,3726, 3734,3996,3734, 36495,3989,3727, 3735,3997,3735, 36496,3990,3728, 3736,3998,3736, 36497,3991,3729, 3520,3734,3520, 36286,3732,3518, 
10, // chain 243
3607,3838,3607, 3737,3999,3737, 3738,4000,3738, 
3606,3837,3606, 36507,4001,3739, 36508,4002,3740, 36509,4003,3741, 36505,3999,3737, 3742,4004,3742, 36498,3992,3730, 36376,3839,3608, 36375,3838,3607, 
16, // chain 244
3605,3836,3605, 3739,4001,3739, 3743,4005,3743, 
3604,3835,3604, 36512,4006,3744, 36513,4007,3745, 36514,4008,3746, 36515,4009,3747, 36507,4001,3739, 3740,4002,3740, 3748,4010,3748, 36517,4011,3749, 36509,4003,3741, 3750,4012,3750, 36510,4004,3742, 3751,4013,3751, 36499,3993,3731, 36498,3992,3730, 
1, // chain 245
3606,3837,3606, 3739,4001,3739, 3605,3836,3605, 
23, // chain 246
3603,3834,3603, 3744,4006,3744, 3752,4014,3752, 
3753,4015,3753, 36522,4016,3754, 36523,4017,3755, 36512,4006,3744, 3745,4007,3745, 3756,4018,3756, 36525,4019,3757, 36514,4008,3746, 3758,4020,3758, 36527,4021,3759, 36515,4009,3747, 3748,4010,3748, 3760,4022,3760, 36529,4023,3761, 36517,4011,3749, 3762,4024,3762, 
36518,4012,3750, 3763,4025,3763, 36519,4013,3751, 3764,4026,3764, 36500,3994,3732, 36499,3993,3731, 
1, // chain 247
3604,3835,3604, 3744,4006,3744, 3603,3834,3603, 
37, // chain 248
3765,4027,3765, 3602,3833,3602, 3753,4015,3753, 
3766,4028,3766, 36522,4016,3754, 3767,4029,3767, 36536,4030,3768, 36523,4017,3755, 3756,4018,3756, 3769,4031,3769, 36538,4032,3770, 36525,4019,3757, 3771,4033,3771, 36526,4020,3758, 3772,4034,3772, 36527,4021,3759, 3773,4035,3773, 36528,4022,3760, 3774,4036,3774, 
36543,4037,3775, 36529,4023,3761, 3776,4038,3776, 36530,4024,3762, 3777,4039,3777, 36531,4025,3763, 3778,4040,3778, 36532,4026,3764, 3779,4041,3779, 36548,4042,3780, 36500,3994,3732, 3733,3995,3733, 3781,4043,3781, 36502,3996,3734, 3782,4044,3782, 36503,3997,3735, 
3783,4045,3783, 36504,3998,3736, 3522,3736,3522, 36288,3734,3520, 
42, // chain 249
3601,3832,3601, 3602,3833,3602, 3765,4027,3765, 
3784,4046,3784, 36553,4047,3785, 36534,4028,3766, 3786,4048,3786, 36535,4029,3767, 3787,4049,3787, 36556,4050,3788, 36536,4030,3768, 3769,4031,3769, 3789,4051,3789, 36558,4052,3790, 36538,4032,3770, 3791,4053,3791, 36539,4033,3771, 3792,4054,3792, 36540,4034,3772, 
3793,4055,3793, 36541,4035,3773, 3794,4056,3794, 36542,4036,3774, 3795,4057,3795, 36564,4058,3796, 36543,4037,3775, 3797,4059,3797, 36544,4038,3776, 3798,4060,3798, 36545,4039,3777, 3799,4061,3799, 36546,4040,3778, 3800,4062,3800, 36547,4041,3779, 3801,4063,3801, 
36570,4064,3802, 36548,4042,3780, 3781,4043,3781, 3803,4065,3803, 36550,4044,3782, 3804,4066,3804, 36551,4045,3783, 3524,3738,3524, 36290,3736,3522, 
48, // chain 250
3805,4067,3805, 3600,3831,3600, 3784,4046,3784, 
3806,4068,3806, 36553,4047,3785, 3807,4069,3807, 36554,4048,3786, 3808,4070,3808, 36555,4049,3787, 3809,4071,3809, 36578,4072,3810, 36556,4050,3788, 3789,4051,3789, 3811,4073,3811, 36580,4074,3812, 36558,4052,3790, 3813,4075,3813, 36559,4053,3791, 3814,4076,3814, 
36560,4054,3792, 3815,4077,3815, 36561,4055,3793, 3816,4078,3816, 36562,4056,3794, 3817,4079,3817, 36563,4057,3795, 3818,4080,3818, 36587,4081,3819, 36588,4082,3820, 36564,4058,3796, 3821,4083,3821, 36565,4059,3797, 3822,4084,3822, 36566,4060,3798, 3823,4085,3823, 
36567,4061,3799, 3824,4086,3824, 36568,4062,3800, 3825,4087,3825, 36569,4063,3801, 3826,4088,3826, 36595,4089,3827, 36596,4090,3828, 36570,4064,3802, 3803,4065,3803, 3829,4091,3829, 36598,4092,3830, 36572,4066,3804, 3526,3740,3526, 36292,3738,3524, 
87, // chain 251
3599,3830,3599, 3600,3831,3600, 3805,4067,3805, 
3597,3828,3597, 36364,3827,3596, 36574,4068,3806, 3595,3826,3595, 36575,4069,3807, 3594,3825,3594, 36576,4070,3808, 3593,3824,3593, 36577,4071,3809, 3592,3823,3592, 36599,4093,3831, 36578,4072,3810, 3811,4073,3811, 3832,4094,3832, 36601,4095,3833, 36580,4074,3812, 
3834,4096,3834, 36581,4075,3813, 3835,4097,3835, 36582,4076,3814, 3836,4098,3836, 36583,4077,3815, 3837,4099,3837, 36584,4078,3816, 3838,4100,3838, 36585,4079,3817, 3818,4080,3818, 3839,4101,3839, 36608,4102,3840, 36587,4081,3819, 3841,4103,3841, 36588,4082,3820, 
3842,4104,3842, 36611,4105,3843, 36589,4083,3821, 3844,4106,3844, 36590,4084,3822, 3845,4107,3845, 36591,4085,3823, 3846,4108,3846, 36592,4086,3824, 3847,4109,3847, 36593,4087,3825, 3826,4088,3826, 3848,4110,3848, 36617,4111,3849, 36618,4112,3850, 36595,4089,3827, 
3851,4113,3851, 36596,4090,3828, 3829,4091,3829, 3852,4114,3852, 36598,4092,3830, 3853,4115,3853, 36294,3740,3526, 3528,3742,3528, 3530,3744,3530, 3531,3747,3531, 3852,4114,3852, 36300,3749,3532, 3851,4113,3851, 36301,3751,3533, 3850,4112,3850, 36302,3753,3534, 
3849,4111,3849, 36303,3755,3535, 3854,4116,3854, 36304,3757,3536, 3855,4117,3855, 36305,3759,3537, 3856,4118,3856, 36306,3761,3538, 3857,4119,3857, 36307,3763,3539, 3858,4120,3858, 36308,3765,3540, 3859,4121,3859, 36309,3767,3541, 3860,4122,3860, 36310,3769,3542, 
3861,4123,3861, 36311,3771,3543, 3862,4124,3862, 36312,3773,3544, 3863,4125,3863, 36313,3775,3545, 
72, // chain 252
3864,4126,3864, 2375,2550,2375, 2376,2551,2376, 
3865,4127,3865, 35145,2552,2377, 3866,4128,3866, 35146,2553,2378, 3867,4129,3867, 35147,2554,2379, 3868,4130,3868, 35148,2555,2380, 3869,4131,3869, 35149,2556,2381, 3870,4132,3870, 35150,2557,2382, 3871,4133,3871, 35151,2558,2383, 3872,4134,3872, 35152,2559,2384, 
3873,4135,3873, 35153,2560,2385, 3874,4136,3874, 35154,2561,2386, 3875,4137,3875, 35155,2562,2387, 3876,4138,3876, 35156,2563,2388, 2389,2564,2389, 3877,4139,3877, 35158,2565,2390, 3878,4140,3878, 35159,2566,2391, 3879,4141,3879, 35160,2567,2392, 3880,4142,3880, 
35161,2568,2393, 3881,4143,3881, 35162,2569,2394, 3882,4144,3882, 35163,2570,2395, 3883,4145,3883, 35164,2571,2396, 3884,4146,3884, 35165,2572,2397, 3885,4147,3885, 35166,2573,2398, 3886,4148,3886, 35167,2574,2399, 3887,4149,3887, 35168,2575,2400, 3888,4150,3888, 
35169,2576,2401, 3889,4151,3889, 35170,2577,2402, 3890,4152,3890, 35171,2578,2403, 3891,4153,3891, 35172,2579,2404, 3892,4154,3892, 35173,2580,2405, 3893,4155,3893, 35174,2581,2406, 3894,4156,3894, 35175,2582,2407, 3895,4157,3895, 35176,2583,2408, 3896,4158,3896, 
35177,2584,2409, 3897,4159,3897, 35178,2585,2410, 3898,4160,3898, 35179,2586,2411, 3652,3885,3652, 35180,2587,2412, 
72, // chain 253
2374,2549,2374, 2375,2550,2375, 3864,4126,3864, 
3899,4161,3899, 36668,4162,3900, 36633,4127,3865, 3901,4163,3901, 36634,4128,3866, 3902,4164,3902, 36635,4129,3867, 3868,4130,3868, 3903,4165,3903, 36637,4131,3869, 3904,4166,3904, 36638,4132,3870, 3905,4167,3905, 36639,4133,3871, 3906,4168,3906, 36640,4134,3872, 
3907,4169,3907, 36641,4135,3873, 3908,4170,3908, 36642,4136,3874, 3909,4171,3909, 36643,4137,3875, 3910,4172,3910, 36644,4138,3876, 3911,4173,3911, 36680,4174,3912, 36645,4139,3877, 3913,4175,3913, 36646,4140,3878, 3914,4176,3914, 36647,4141,3879, 3915,4177,3915, 
36648,4142,3880, 3916,4178,3916, 36649,4143,3881, 3917,4179,3917, 36650,4144,3882, 3918,4180,3918, 36651,4145,3883, 3919,4181,3919, 36652,4146,3884, 3920,4182,3920, 36653,4147,3885, 3886,4148,3886, 3921,4183,3921, 36655,4149,3887, 3922,4184,3922, 36656,4150,3888, 
3923,4185,3923, 36657,4151,3889, 3924,4186,3924, 36658,4152,3890, 3925,4187,3925, 36659,4153,3891, 3926,4188,3926, 36660,4154,3892, 3927,4189,3927, 36696,4190,3928, 36661,4155,3893, 3929,4191,3929, 36662,4156,3894, 3930,4192,3930, 36663,4157,3895, 3931,4193,3931, 
36664,4158,3896, 3932,4194,3932, 36665,4159,3897, 3933,4195,3933, 36666,4160,3898, 3653,3886,3653, 36420,3885,3652, 
71, // chain 254
3934,4196,3934, 2373,2548,2373, 3899,4161,3899, 
3935,4197,3935, 36668,4162,3900, 3936,4198,3936, 36669,4163,3901, 3937,4199,3937, 36670,4164,3902, 3903,4165,3903, 3938,4200,3938, 36672,4166,3904, 3939,4201,3939, 36673,4167,3905, 3940,4202,3940, 36674,4168,3906, 3941,4203,3941, 36675,4169,3907, 3942,4204,3942, 
36676,4170,3908, 3943,4205,3943, 36677,4171,3909, 3944,4206,3944, 36678,4172,3910, 3945,4207,3945, 36679,4173,3911, 3946,4208,3946, 36715,4209,3947, 36680,4174,3912, 3948,4210,3948, 36681,4175,3913, 3949,4211,3949, 36682,4176,3914, 3950,4212,3950, 36683,4177,3915, 
3951,4213,3951, 36684,4178,3916, 3952,4214,3952, 36685,4179,3917, 3953,4215,3953, 36686,4180,3918, 3954,4216,3954, 36687,4181,3919, 3955,4217,3955, 36688,4182,3920, 3921,4183,3921, 3956,4218,3956, 36690,4184,3922, 3957,4219,3957, 36691,4185,3923, 3958,4220,3958, 
36692,4186,3924, 3959,4221,3959, 36693,4187,3925, 3960,4222,3960, 36694,4188,3926, 3961,4223,3961, 36695,4189,3927, 3962,4224,3962, 36731,4225,3963, 36696,4190,3928, 3964,4226,3964, 36697,4191,3929, 3965,4227,3965, 36698,4192,3930, 3966,4228,3966, 36699,4193,3931, 
3967,4229,3967, 36700,4194,3932, 3968,4230,3968, 36701,4195,3933, 3654,3887,3654, 36421,3886,3653, 
227, // chain 255
2372,2547,2372, 2373,2548,2373, 3934,4196,3934, 
3969,4231,3969, 36738,4232,3970, 36703,4197,3935, 3971,4233,3971, 36704,4198,3936, 3972,4234,3972, 36705,4199,3937, 3973,4235,3973, 36706,4200,3938, 3974,4236,3974, 36707,4201,3939, 3975,4237,3975, 36708,4202,3940, 3976,4238,3976, 36709,4203,3941, 3977,4239,3977, 
36710,4204,3942, 3978,4240,3978, 36711,4205,3943, 3979,4241,3979, 36712,4206,3944, 3980,4242,3980, 36713,4207,3945, 3981,4243,3981, 36714,4208,3946, 3947,4209,3947, 3982,4244,3982, 36716,4210,3948, 3983,4245,3983, 36717,4211,3949, 3984,4246,3984, 36718,4212,3950, 
3985,4247,3985, 36719,4213,3951, 3986,4248,3986, 36720,4214,3952, 3987,4249,3987, 36721,4215,3953, 3988,4250,3988, 36722,4216,3954, 3989,4251,3989, 36723,4217,3955, 3990,4252,3990, 36724,4218,3956, 3991,4253,3991, 36725,4219,3957, 3992,4254,3992, 36726,4220,3958, 
3993,4255,3993, 36727,4221,3959, 3994,4256,3994, 36728,4222,3960, 3995,4257,3995, 36729,4223,3961, 3996,4258,3996, 36730,4224,3962, 3997,4259,3997, 36731,4225,3963, 3998,4260,3998, 36732,4226,3964, 3999,4261,3999, 36733,4227,3965, 4000,4262,4000, 36734,4228,3966, 
4001,4263,4001, 36735,4229,3967, 4002,4264,4002, 36736,4230,3968, 4003,4265,4003, 36422,3887,3654, 3655,3888,3655, 4004,4266,4004, 36424,3889,3656, 3657,3890,3657, 4005,4267,4005, 36426,3891,3658, 4006,4268,4006, 36775,4269,4007, 36427,3892,3659, 4008,4270,4008, 
36428,3893,3660, 3661,3894,3661, 4009,4271,4009, 36430,3895,3662, 4010,4272,4010, 36779,4273,4011, 36431,3896,3663, 4012,4274,4012, 36432,3897,3664, 3665,3898,3665, 4013,4275,4013, 36434,3899,3666, 4014,4276,4014, 36783,4277,4015, 36435,3900,3667, 4016,4278,4016, 
36436,3901,3668, 3669,3902,3669, 3670,3904,3670, 4017,4279,4017, 36439,3906,3671, 4018,4280,4018, 36440,3908,3672, 4019,4281,4019, 36441,3910,3673, 4020,4282,4020, 36442,3912,3674, 4021,4283,4021, 36443,3914,3675, 4022,4284,4022, 36444,3916,3676, 3677,3919,3677, 
4023,4285,4023, 36446,3921,3678, 4024,4286,4024, 36447,3923,3679, 4025,4287,4025, 36448,3925,3680, 4026,4288,4026, 36449,3927,3681, 4027,4289,4027, 36450,3929,3682, 4028,4290,4028, 36451,3931,3683, 4029,4291,4029, 36798,4292,4030, 36452,3932,3684, 4031,4293,4031, 
36453,3934,3685, 4032,4294,4032, 36454,3936,3686, 4033,4295,4033, 36455,3938,3687, 4034,4296,4034, 36456,3940,3688, 4035,4297,4035, 36457,3942,3689, 4036,4298,4036, 36458,3944,3690, 4037,4299,4037, 36459,3946,3691, 4038,4300,4038, 36460,3948,3692, 4039,4301,4039, 
36461,3950,3693, 4040,4302,4040, 36462,3952,3694, 4041,4303,4041, 36463,3954,3695, 4042,4304,4042, 36464,3956,3696, 4043,4305,4043, 36465,3959,3697, 4044,4306,4044, 36466,3960,3698, 4045,4307,4045, 36468,3962,3700, 4046,4308,4046, 36470,3964,3702, 4047,4309,4047, 
36472,3966,3704, 4048,4310,4048, 36474,3968,3706, 4049,4311,4049, 36476,3970,3708, 4050,4312,4050, 36478,3972,3710, 4051,4313,4051, 36480,3974,3712, 4052,4314,4052, 36482,3976,3714, 4053,4315,4053, 36484,3978,3716, 4054,4316,4054, 36486,3980,3718, 3324,3516,3324, 
3325,3517,3325, 4055,4317,4055, 36094,3518,3326, 4056,4318,4056, 36095,3519,3327, 4057,4319,4057, 36096,3520,3328, 4058,4320,4058, 36827,4321,4059, 36097,3521,3329, 3330,3522,3330, 3331,3523,3331, 4060,4322,4060, 36100,3524,3332, 4061,4323,4061, 36101,3525,3333, 
4062,4324,4062, 36102,3526,3334, 4063,4325,4063, 36832,4326,4064, 36103,3527,3335, 4065,4327,4065, 36104,3528,3336, 4066,4328,4066, 36105,3529,3337, 4067,4329,4067, 36836,4330,4068, 36106,3530,3338, 4069,4331,4069, 36107,3531,3339, 4070,4332,4070, 36108,3532,3340, 
4071,4333,4071, 36840,4334,4072, 36109,3533,3341, 3342,3534,3342, 4073,4335,4073, 36842,4336,4074, 36111,3535,3343, 4075,4337,4075, 36112,3536,3344, 4076,4338,4076, 36113,3537,3345, 4077,4339,4077, 36846,4340,4078, 36114,3538,3346, 3347,3539,3347, 4079,4341,4079, 
35135,2542,2367, 35134,2541,2366, 
93, // chain 256
4080,4342,4080, 2371,2546,2371, 3969,4231,3969, 
4081,4343,4081, 36738,4232,3970, 4082,4344,4082, 36739,4233,3971, 4083,4345,4083, 36740,4234,3972, 4084,4346,4084, 36741,4235,3973, 4085,4347,4085, 36742,4236,3974, 4086,4348,4086, 36743,4237,3975, 4087,4349,4087, 36744,4238,3976, 4088,4350,4088, 36745,4239,3977, 
4089,4351,4089, 36746,4240,3978, 4090,4352,4090, 36747,4241,3979, 4091,4353,4091, 36748,4242,3980, 4092,4354,4092, 36749,4243,3981, 3982,4244,3982, 4093,4355,4093, 36751,4245,3983, 4094,4356,4094, 36752,4246,3984, 4095,4357,4095, 36753,4247,3985, 4096,4358,4096, 
36754,4248,3986, 4097,4359,4097, 36755,4249,3987, 4098,4360,4098, 36756,4250,3988, 4099,4361,4099, 36757,4251,3989, 4100,4362,4100, 36758,4252,3990, 4101,4363,4101, 36759,4253,3991, 4102,4364,4102, 36760,4254,3992, 4103,4365,4103, 36761,4255,3993, 4104,4366,4104, 
36762,4256,3994, 4105,4367,4105, 36763,4257,3995, 4106,4368,4106, 36764,4258,3996, 4107,4369,4107, 36765,4259,3997, 4108,4370,4108, 36766,4260,3998, 4109,4371,4109, 36767,4261,3999, 4110,4372,4110, 36768,4262,4000, 4111,4373,4111, 36769,4263,4001, 4112,4374,4112, 
36770,4264,4002, 4113,4375,4113, 36771,4265,4003, 4004,4266,4004, 4005,4267,4005, 4114,4376,4114, 36774,4268,4006, 4115,4377,4115, 36884,4378,4116, 36775,4269,4007, 4117,4379,4117, 36776,4270,4008, 4009,4271,4009, 4118,4380,4118, 36778,4272,4010, 4119,4381,4119, 
36888,4382,4120, 36779,4273,4011, 4121,4383,4121, 36780,4274,4012, 4013,4275,4013, 4122,4384,4122, 36782,4276,4014, 4123,4385,4123, 36892,4386,4124, 36783,4277,4015, 4017,4279,4017, 36784,4278,4016, 
68, // chain 257
2370,2545,2370, 2371,2546,2371, 4080,4342,4080, 
4125,4387,4125, 36894,4388,4126, 36849,4343,4081, 4127,4389,4127, 36850,4344,4082, 4128,4390,4128, 36851,4345,4083, 4084,4346,4084, 4129,4391,4129, 36853,4347,4085, 4130,4392,4130, 36854,4348,4086, 4131,4393,4131, 36855,4349,4087, 4132,4394,4132, 36856,4350,4088, 
4133,4395,4133, 36857,4351,4089, 4134,4396,4134, 36858,4352,4090, 4135,4397,4135, 36859,4353,4091, 4136,4398,4136, 36860,4354,4092, 4137,4399,4137, 36906,4400,4138, 36861,4355,4093, 4139,4401,4139, 36862,4356,4094, 4140,4402,4140, 36863,4357,4095, 4141,4403,4141, 
36864,4358,4096, 4142,4404,4142, 36865,4359,4097, 4143,4405,4143, 36866,4360,4098, 4144,4406,4144, 36867,4361,4099, 4145,4407,4145, 36868,4362,4100, 4146,4408,4146, 36869,4363,4101, 4102,4364,4102, 4147,4409,4147, 36871,4365,4103, 4148,4410,4148, 36872,4366,4104, 
4149,4411,4149, 36873,4367,4105, 4150,4412,4150, 36874,4368,4106, 4151,4413,4151, 36875,4369,4107, 4152,4414,4152, 36876,4370,4108, 4153,4415,4153, 36922,4416,4154, 36877,4371,4109, 4155,4417,4155, 36878,4372,4110, 4156,4418,4156, 36879,4373,4111, 4157,4419,4157, 
36880,4374,4112, 4114,4376,4114, 36881,4375,4113, 
67, // chain 258
4158,4420,4158, 2369,2544,2369, 4125,4387,4125, 
4159,4421,4159, 36894,4388,4126, 4160,4422,4160, 36895,4389,4127, 4161,4423,4161, 36896,4390,4128, 4129,4391,4129, 4162,4424,4162, 36898,4392,4130, 4163,4425,4163, 36899,4393,4131, 4164,4426,4164, 36900,4394,4132, 4165,4427,4165, 36901,4395,4133, 4166,4428,4166, 
36902,4396,4134, 4167,4429,4167, 36903,4397,4135, 4168,4430,4168, 36904,4398,4136, 4169,4431,4169, 36905,4399,4137, 4170,4432,4170, 36939,4433,4171, 36906,4400,4138, 4172,4434,4172, 36907,4401,4139, 4173,4435,4173, 36908,4402,4140, 4174,4436,4174, 36909,4403,4141, 
4175,4437,4175, 36910,4404,4142, 4176,4438,4176, 36911,4405,4143, 4177,4439,4177, 36912,4406,4144, 4178,4440,4178, 36913,4407,4145, 4179,4441,4179, 36914,4408,4146, 4147,4409,4147, 4180,4442,4180, 36916,4410,4148, 4181,4443,4181, 36917,4411,4149, 4182,4444,4182, 
36918,4412,4150, 4183,4445,4183, 36919,4413,4151, 4184,4446,4184, 36920,4414,4152, 4185,4447,4185, 36921,4415,4153, 4186,4448,4186, 36955,4449,4187, 36922,4416,4154, 4188,4450,4188, 36923,4417,4155, 4189,4451,4189, 36924,4418,4156, 4190,4452,4190, 36925,4419,4157, 
4115,4377,4115, 36882,4376,4114, 
86, // chain 259
2368,2543,2368, 2369,2544,2369, 4158,4420,4158, 
4079,4341,4079, 36959,4453,4191, 36927,4421,4159, 4192,4454,4192, 36928,4422,4160, 4193,4455,4193, 36929,4423,4161, 4194,4456,4194, 36930,4424,4162, 4195,4457,4195, 36931,4425,4163, 4196,4458,4196, 36932,4426,4164, 4197,4459,4197, 36933,4427,4165, 4198,4460,4198, 
36934,4428,4166, 4199,4461,4199, 36935,4429,4167, 4200,4462,4200, 36936,4430,4168, 4201,4463,4201, 36937,4431,4169, 4202,4464,4202, 36938,4432,4170, 4171,4433,4171, 4203,4465,4203, 36940,4434,4172, 4204,4466,4204, 36941,4435,4173, 4205,4467,4205, 36942,4436,4174, 
4206,4468,4206, 36943,4437,4175, 4207,4469,4207, 36944,4438,4176, 4208,4470,4208, 36945,4439,4177, 4209,4471,4209, 36946,4440,4178, 4210,4472,4210, 36947,4441,4179, 4211,4473,4211, 36948,4442,4180, 4212,4474,4212, 36949,4443,4181, 4213,4475,4213, 36950,4444,4182, 
4214,4476,4214, 36951,4445,4183, 4215,4477,4215, 36952,4446,4184, 4216,4478,4216, 36953,4447,4185, 4217,4479,4217, 36954,4448,4186, 4218,4480,4218, 36955,4449,4187, 4219,4481,4219, 36956,4450,4188, 4220,4482,4220, 36957,4451,4189, 4221,4483,4221, 36958,4452,4190, 
4222,4484,4222, 36883,4377,4115, 4116,4378,4116, 4223,4485,4223, 36885,4379,4117, 4118,4380,4118, 4224,4486,4224, 36887,4381,4119, 4225,4487,4225, 36994,4488,4226, 36888,4382,4120, 4227,4489,4227, 36889,4383,4121, 4122,4384,4122, 4228,4490,4228, 36891,4385,4123, 
4229,4491,4229, 36998,4492,4230, 36892,4386,4124, 4018,4280,4018, 36785,4279,4017, 
6, // chain 260
4231,4493,4231, 3846,4108,3846, 4232,4494,4232, 
4233,4495,4233, 37002,4496,4234, 37003,4497,4235, 36615,4109,3847, 36614,4108,3846, 
14, // chain 261
3845,4107,3845, 3846,4108,3846, 4231,4493,4231, 
3844,4106,3844, 37004,4498,4236, 37005,4499,4237, 37001,4495,4233, 4238,4500,4238, 37007,4501,4239, 37002,4496,4234, 4240,4502,4240, 37009,4503,4241, 37003,4497,4235, 4242,4504,4242, 36616,4110,3848, 36615,4109,3847, 
20, // chain 262
3844,4106,3844, 4236,4498,4236, 3843,4105,3843, 
37011,4505,4243, 37012,4506,4244, 37005,4499,4237, 4245,4507,4245, 37006,4500,4238, 4246,4508,4246, 37015,4509,4247, 37007,4501,4239, 4248,4510,4248, 37008,4502,4240, 4249,4511,4249, 37018,4512,4250, 37009,4503,4241, 4251,4513,4251, 37010,4504,4242, 3855,4117,3855, 
36622,4116,3854, 36616,4110,3848, 3849,4111,3849, 
6, // chain 263
4252,4514,4252, 3842,4104,3842, 4253,4515,4253, 
4254,4516,4254, 37023,4517,4255, 37011,4505,4243, 36611,4105,3843, 36610,4104,3842, 
10, // chain 264
3841,4103,3841, 3842,4104,3842, 4252,4514,4252, 
4256,4518,4256, 37025,4519,4257, 37022,4516,4254, 4258,4520,4258, 37027,4521,4259, 37023,4517,4255, 4260,4522,4260, 37012,4506,4244, 37011,4505,4243, 
13, // chain 265
4261,4523,4261, 3840,4102,3840, 4256,4518,4256, 
4262,4524,4262, 37025,4519,4257, 4263,4525,4263, 37026,4520,4258, 4264,4526,4264, 37033,4527,4265, 37027,4521,4259, 4266,4528,4266, 37028,4522,4260, 4267,4529,4267, 37013,4507,4245, 37012,4506,4244, 
18, // chain 266
3839,4101,3839, 3840,4102,3840, 4261,4523,4261, 
4268,4530,4268, 37037,4531,4269, 37030,4524,4262, 4270,4532,4270, 37031,4525,4263, 4271,4533,4271, 37032,4526,4264, 4272,4534,4272, 37041,4535,4273, 37033,4527,4265, 4274,4536,4274, 37034,4528,4266, 4275,4537,4275, 37035,4529,4267, 4276,4538,4276, 37014,4508,4246, 
37013,4507,4245, 
35, // chain 267
4277,4539,4277, 3838,4100,3838, 3839,4101,3839, 
4268,4530,4268, 4278,4540,4278, 37047,4541,4279, 37037,4531,4269, 4280,4542,4280, 37038,4532,4270, 4281,4543,4281, 37039,4533,4271, 4282,4544,4282, 37040,4534,4272, 4283,4545,4283, 37052,4546,4284, 37041,4535,4273, 4285,4547,4285, 37042,4536,4274, 4286,4548,4286, 
37043,4537,4275, 4287,4549,4287, 37044,4538,4276, 4288,4550,4288, 37057,4551,4289, 37014,4508,4246, 4247,4509,4247, 4290,4552,4290, 37016,4510,4248, 4291,4553,4291, 37017,4511,4249, 4292,4554,4292, 37061,4555,4293, 37018,4512,4250, 4294,4556,4294, 37019,4513,4251, 
3856,4118,3856, 36623,4117,3855, 
41, // chain 268
3837,4099,3837, 3838,4100,3838, 4277,4539,4277, 
4295,4557,4295, 37046,4540,4278, 4296,4558,4296, 37065,4559,4297, 37047,4541,4279, 4298,4560,4298, 37048,4542,4280, 4299,4561,4299, 37049,4543,4281, 4300,4562,4300, 37050,4544,4282, 4301,4563,4301, 37051,4545,4283, 4302,4564,4302, 37071,4565,4303, 37052,4546,4284, 
4304,4566,4304, 37053,4547,4285, 4305,4567,4305, 37054,4548,4286, 4306,4568,4306, 37055,4549,4287, 4307,4569,4307, 37056,4550,4288, 4308,4570,4308, 37077,4571,4309, 37057,4551,4289, 4290,4552,4290, 4310,4572,4310, 37059,4553,4291, 4311,4573,4311, 37060,4554,4292, 
4312,4574,4312, 37081,4575,4313, 37082,4576,4314, 37061,4555,4293, 4315,4577,4315, 37062,4556,4294, 3857,4119,3857, 36624,4118,3856, 
47, // chain 269
4316,4578,4316, 3836,4098,3836, 4295,4557,4295, 
4296,4558,4296, 4317,4579,4317, 37086,4580,4318, 37065,4559,4297, 4319,4581,4319, 37066,4560,4298, 4320,4582,4320, 37067,4561,4299, 4321,4583,4321, 37068,4562,4300, 4322,4584,4322, 37069,4563,4301, 4323,4585,4323, 37070,4564,4302, 4324,4586,4324, 37093,4587,4325, 
37071,4565,4303, 4326,4588,4326, 37072,4566,4304, 4327,4589,4327, 37073,4567,4305, 4328,4590,4328, 37074,4568,4306, 4329,4591,4329, 37075,4569,4307, 4330,4592,4330, 37076,4570,4308, 4331,4593,4331, 37100,4594,4332, 37077,4571,4309, 4310,4572,4310, 4333,4595,4333, 
37102,4596,4334, 37079,4573,4311, 4335,4597,4335, 37080,4574,4312, 4336,4598,4336, 37081,4575,4313, 4337,4599,4337, 37106,4600,4338, 37107,4601,4339, 37082,4576,4314, 4340,4602,4340, 37083,4577,4315, 3858,4120,3858, 36625,4119,3857, 
56, // chain 270
3835,4097,3835, 3836,4098,3836, 4316,4578,4316, 
4341,4603,4341, 37085,4579,4317, 4342,4604,4342, 37111,4605,4343, 37086,4580,4318, 4344,4606,4344, 37087,4581,4319, 4345,4607,4345, 37088,4582,4320, 4346,4608,4346, 37089,4583,4321, 4347,4609,4347, 37090,4584,4322, 4348,4610,4348, 37091,4585,4323, 4349,4611,4349, 
37092,4586,4324, 4350,4612,4350, 37119,4613,4351, 37093,4587,4325, 4352,4614,4352, 37094,4588,4326, 4353,4615,4353, 37095,4589,4327, 4354,4616,4354, 37096,4590,4328, 4355,4617,4355, 37097,4591,4329, 4356,4618,4356, 37098,4592,4330, 4357,4619,4357, 37099,4593,4331, 
4358,4620,4358, 37127,4621,4359, 37100,4594,4332, 4333,4595,4333, 4360,4622,4360, 37129,4623,4361, 37102,4596,4334, 4362,4624,4362, 37103,4597,4335, 4363,4625,4363, 37104,4598,4336, 4364,4626,4364, 37105,4599,4337, 4365,4627,4365, 37134,4628,4366, 37106,4600,4338, 
4367,4629,4367, 37107,4601,4339, 4368,4630,4368, 37137,4631,4369, 37108,4602,4340, 3859,4121,3859, 36626,4120,3858, 
62, // chain 271
4370,4632,4370, 3834,4096,3834, 4341,4603,4341, 
4342,4604,4342, 4371,4633,4371, 37140,4634,4372, 37111,4605,4343, 4373,4635,4373, 37112,4606,4344, 4374,4636,4374, 37113,4607,4345, 4375,4637,4375, 37114,4608,4346, 4376,4638,4376, 37115,4609,4347, 4377,4639,4377, 37116,4610,4348, 4378,4640,4378, 37117,4611,4349, 
4379,4641,4379, 37118,4612,4350, 4380,4642,4380, 37149,4643,4381, 37119,4613,4351, 4382,4644,4382, 37120,4614,4352, 4383,4645,4383, 37121,4615,4353, 4384,4646,4384, 37122,4616,4354, 4355,4617,4355, 4385,4647,4385, 37124,4618,4356, 4386,4648,4386, 37125,4619,4357, 
4387,4649,4387, 37126,4620,4358, 4388,4650,4388, 37157,4651,4389, 37127,4621,4359, 4360,4622,4360, 4390,4652,4390, 37129,4623,4361, 4391,4653,4391, 37160,4654,4392, 37130,4624,4362, 4393,4655,4393, 37131,4625,4363, 4394,4656,4394, 37132,4626,4364, 4395,4657,4395, 
37133,4627,4365, 4396,4658,4396, 37165,4659,4397, 37134,4628,4366, 4398,4660,4398, 37135,4629,4367, 4399,4661,4399, 37136,4630,4368, 4400,4662,4400, 37169,4663,4401, 37137,4631,4369, 3860,4122,3860, 36627,4121,3859, 
70, // chain 272
3833,4095,3833, 3834,4096,3834, 4370,4632,4370, 
4402,4664,4402, 37139,4633,4371, 3590,3821,3590, 36357,3820,3589, 37140,4634,4372, 3588,3819,3588, 37141,4635,4373, 3587,3818,3587, 36354,3817,3586, 37142,4636,4374, 3585,3816,3585, 37143,4637,4375, 3584,3815,3584, 37144,4638,4376, 3583,3814,3583, 37145,4639,4377, 
3582,3813,3582, 37146,4640,4378, 3581,3812,3581, 37147,4641,4379, 4403,4665,4403, 37148,4642,4380, 4404,4666,4404, 37173,4667,4405, 37149,4643,4381, 4406,4668,4406, 37150,4644,4382, 4407,4669,4407, 37151,4645,4383, 4408,4670,4408, 37152,4646,4384, 4409,4671,4409, 
37153,4647,4385, 4386,4648,4386, 4410,4672,4410, 37155,4649,4387, 4411,4673,4411, 37156,4650,4388, 4412,4674,4412, 37181,4675,4413, 37157,4651,4389, 4390,4652,4390, 4414,4676,4414, 37159,4653,4391, 4415,4677,4415, 37160,4654,4392, 4416,4678,4416, 37161,4655,4393, 
4417,4679,4417, 37162,4656,4394, 4418,4680,4418, 37163,4657,4395, 4419,4681,4419, 37164,4658,4396, 4420,4682,4420, 35861,3272,3093, 35860,3271,3092, 37165,4659,4397, 3091,3270,3091, 37166,4660,4398, 3090,3269,3090, 37167,4661,4399, 3089,3268,3089, 37168,4662,4400, 
3088,3267,3088, 37189,4683,4421, 37169,4663,4401, 3861,4123,3861, 36628,4122,3860, 
4, // chain 273
4402,4664,4402, 3590,3821,3590, 3832,4094,3832, 
36359,3822,3591, 3831,4093,3831, 36360,3823,3592, 
77, // chain 274
4077,4339,4077, 4191,4453,4191, 4192,4454,4192, 
4422,4684,4422, 36961,4455,4193, 4194,4456,4194, 4423,4685,4423, 36963,4457,4195, 4424,4686,4424, 36964,4458,4196, 4425,4687,4425, 36965,4459,4197, 4426,4688,4426, 36966,4460,4198, 4427,4689,4427, 36967,4461,4199, 4428,4690,4428, 36968,4462,4200, 4429,4691,4429, 
37198,4692,4430, 36969,4463,4201, 4431,4693,4431, 36970,4464,4202, 4432,4694,4432, 36971,4465,4203, 4433,4695,4433, 36972,4466,4204, 4434,4696,4434, 36973,4467,4205, 4435,4697,4435, 36974,4468,4206, 4436,4698,4436, 36975,4469,4207, 4437,4699,4437, 36976,4470,4208, 
4438,4700,4438, 36977,4471,4209, 4210,4472,4210, 4439,4701,4439, 36979,4473,4211, 4440,4702,4440, 36980,4474,4212, 4441,4703,4441, 36981,4475,4213, 4442,4704,4442, 36982,4476,4214, 4443,4705,4443, 36983,4477,4215, 4444,4706,4444, 36984,4478,4216, 4445,4707,4445, 
36985,4479,4217, 4446,4708,4446, 36986,4480,4218, 4447,4709,4447, 36987,4481,4219, 4448,4710,4448, 36988,4482,4220, 4449,4711,4449, 36989,4483,4221, 4450,4712,4450, 36990,4484,4222, 4223,4485,4223, 4224,4486,4224, 4451,4713,4451, 36993,4487,4225, 4452,4714,4452, 
37221,4715,4453, 36994,4488,4226, 4454,4716,4454, 36995,4489,4227, 4228,4490,4228, 4455,4717,4455, 36997,4491,4229, 4456,4718,4456, 37225,4719,4457, 36998,4492,4230, 4019,4281,4019, 36786,4280,4018, 
2, // chain 275
4191,4453,4191, 4077,4339,4077, 4078,4340,4078, 
4079,4341,4079, 
57, // chain 276
4076,4338,4076, 4077,4339,4077, 4422,4684,4422, 
4423,4685,4423, 4075,4337,4075, 37192,4686,4424, 4074,4336,4074, 37193,4687,4425, 4073,4335,4073, 37194,4688,4426, 4458,4720,4458, 37195,4689,4427, 4459,4721,4459, 37196,4690,4428, 4460,4722,4460, 37197,4691,4429, 4461,4723,4461, 37230,4724,4462, 37198,4692,4430, 
4463,4725,4463, 37199,4693,4431, 4464,4726,4464, 37200,4694,4432, 4465,4727,4465, 37201,4695,4433, 4466,4728,4466, 37202,4696,4434, 4467,4729,4467, 37203,4697,4435, 4468,4730,4468, 37204,4698,4436, 4469,4731,4469, 37205,4699,4437, 4470,4732,4470, 37206,4700,4438, 
4471,4733,4471, 37207,4701,4439, 4472,4734,4472, 37208,4702,4440, 4441,4703,4441, 4473,4735,4473, 37210,4704,4442, 4474,4736,4474, 37211,4705,4443, 4475,4737,4475, 37212,4706,4444, 4476,4738,4476, 37213,4707,4445, 4477,4739,4477, 37214,4708,4446, 4478,4740,4478, 
37215,4709,4447, 4479,4741,4479, 37248,4742,4480, 37216,4710,4448, 4481,4743,4481, 37217,4711,4449, 4451,4713,4451, 37218,4712,4450, 
6, // chain 277
4071,4333,4071, 4459,4721,4459, 4482,4744,4482, 
4070,4332,4070, 37251,4745,4483, 37252,4746,4484, 37228,4722,4460, 37227,4721,4459, 
3, // chain 278
4458,4720,4458, 4459,4721,4459, 4071,4333,4071, 
4072,4334,4072, 4073,4335,4073, 
11, // chain 279
4069,4331,4069, 4483,4745,4483, 4485,4747,4485, 
4068,4330,4068, 37254,4748,4486, 37255,4749,4487, 37256,4750,4488, 37257,4751,4489, 37251,4745,4483, 4484,4746,4484, 4490,4752,4490, 37229,4723,4461, 37228,4722,4460, 
1, // chain 280
4070,4332,4070, 4483,4745,4483, 4069,4331,4069, 
57, // chain 281
4067,4329,4067, 4486,4748,4486, 4491,4753,4491, 
4492,4754,4492, 37261,4755,4493, 37262,4756,4494, 37254,4748,4486, 4487,4749,4487, 4495,4757,4495, 37264,4758,4496, 37256,4750,4488, 4497,4759,4497, 37266,4760,4498, 37257,4751,4489, 4490,4752,4490, 4499,4761,4499, 37268,4762,4500, 37229,4723,4461, 4462,4724,4462, 
4501,4763,4501, 37231,4725,4463, 4502,4764,4502, 37232,4726,4464, 4503,4765,4503, 37233,4727,4465, 4504,4766,4504, 37234,4728,4466, 4505,4767,4505, 37235,4729,4467, 4506,4768,4506, 37236,4730,4468, 4507,4769,4507, 37237,4731,4469, 4508,4770,4508, 37238,4732,4470, 
4509,4771,4509, 37239,4733,4471, 4510,4772,4510, 37240,4734,4472, 4473,4735,4473, 4511,4773,4511, 37242,4736,4474, 4512,4774,4512, 37243,4737,4475, 4513,4775,4513, 37244,4738,4476, 4514,4776,4514, 37245,4739,4477, 4515,4777,4515, 37246,4740,4478, 4516,4778,4516, 
37247,4741,4479, 4517,4779,4517, 37286,4780,4518, 37248,4742,4480, 4519,4781,4519, 37249,4743,4481, 4452,4714,4452, 37219,4713,4451, 
1, // chain 282
4068,4330,4068, 4486,4748,4486, 4067,4329,4067, 
60, // chain 283
4499,4761,4499, 4520,4782,4520, 4521,4783,4521, 
4498,4760,4498, 37265,4759,4497, 37290,4784,4522, 37291,4785,4523, 37288,4782,4520, 4524,4786,4524, 37293,4787,4525, 37294,4788,4526, 37267,4761,4499, 4500,4762,4500, 4501,4763,4501, 4527,4789,4527, 37270,4764,4502, 4528,4790,4528, 37271,4765,4503, 4529,4791,4529, 
37272,4766,4504, 4530,4792,4530, 37273,4767,4505, 4531,4793,4531, 37274,4768,4506, 4532,4794,4532, 37275,4769,4507, 4533,4795,4533, 37276,4770,4508, 4509,4771,4509, 4534,4796,4534, 37278,4772,4510, 4535,4797,4535, 37279,4773,4511, 4536,4798,4536, 37280,4774,4512, 
4537,4799,4537, 37281,4775,4513, 4538,4800,4538, 37282,4776,4514, 4539,4801,4539, 37283,4777,4515, 4540,4802,4540, 37284,4778,4516, 4541,4803,4541, 37285,4779,4517, 4542,4804,4542, 37286,4780,4518, 4543,4805,4543, 37287,4781,4519, 4544,4806,4544, 37220,4714,4452, 
4453,4715,4453, 4545,4807,4545, 37222,4716,4454, 4455,4717,4455, 4546,4808,4546, 37224,4718,4456, 4547,4809,4547, 37316,4810,4548, 37225,4719,4457, 4020,4282,4020, 36787,4281,4019, 
12, // chain 284
4496,4758,4496, 4497,4759,4497, 4522,4784,4522, 
4549,4811,4549, 37318,4812,4550, 37291,4785,4523, 4551,4813,4551, 37292,4786,4524, 4552,4814,4552, 37321,4815,4553, 37293,4787,4525, 4554,4816,4554, 37295,4789,4527, 37294,4788,4526, 
6, // chain 285
4555,4817,4555, 4416,4678,4416, 4556,4818,4556, 
4557,4819,4557, 37326,4820,4558, 37327,4821,4559, 37185,4679,4417, 37184,4678,4416, 
13, // chain 286
4415,4677,4415, 4416,4678,4416, 4555,4817,4555, 
4560,4822,4560, 37329,4823,4561, 37325,4819,4557, 4562,4824,4562, 37331,4825,4563, 37326,4820,4558, 4564,4826,4564, 37333,4827,4565, 37327,4821,4559, 4566,4828,4566, 37186,4680,4418, 37185,4679,4417, 
14, // chain 287
4567,4829,4567, 4561,4823,4561, 4562,4824,4562, 
4568,4830,4568, 37337,4831,4569, 37331,4825,4563, 4570,4832,4570, 37332,4826,4564, 4571,4833,4571, 37340,4834,4572, 37333,4827,4565, 4573,4835,4573, 37334,4828,4566, 4574,4836,4574, 37187,4681,4419, 37186,4680,4418, 
25, // chain 288
4561,4823,4561, 4567,4829,4567, 4575,4837,4575, 
4560,4822,4560, 37344,4838,4576, 37345,4839,4577, 37346,4840,4578, 37335,4829,4567, 4579,4841,4579, 37336,4830,4568, 4580,4842,4580, 37349,4843,4581, 37337,4831,4569, 4582,4844,4582, 37338,4832,4570, 4583,4845,4583, 37339,4833,4571, 4584,4846,4584, 37353,4847,4585, 
37340,4834,4572, 4586,4848,4586, 37341,4835,4573, 4587,4849,4587, 37342,4836,4574, 4588,4850,4588, 37188,4682,4420, 37187,4681,4419, 
32, // chain 289
4560,4822,4560, 4576,4838,4576, 4414,4676,4414, 
37181,4675,4413, 37180,4674,4412, 37345,4839,4577, 4589,4851,4589, 37358,4852,4590, 37346,4840,4578, 4591,4853,4591, 37347,4841,4579, 4592,4854,4592, 37348,4842,4580, 4593,4855,4593, 37362,4856,4594, 37349,4843,4581, 4595,4857,4595, 37350,4844,4582, 4596,4858,4596, 
37351,4845,4583, 4597,4859,4597, 37352,4846,4584, 4598,4860,4598, 37367,4861,4599, 37353,4847,4585, 4600,4862,4600, 37354,4848,4586, 4601,4863,4601, 37355,4849,4587, 4602,4864,4602, 37356,4850,4588, 4603,4865,4603, 35861,3272,3093, 37188,4682,4420, 
42, // chain 290
4604,4866,4604, 4411,4673,4411, 4589,4851,4589, 
4605,4867,4605, 37358,4852,4590, 4606,4868,4606, 37359,4853,4591, 4607,4869,4607, 37360,4854,4592, 4608,4870,4608, 37361,4855,4593, 4609,4871,4609, 37378,4872,4610, 37362,4856,4594, 4611,4873,4611, 37363,4857,4595, 4612,4874,4612, 37364,4858,4596, 4613,4875,4613, 
37365,4859,4597, 4614,4876,4614, 37366,4860,4598, 4615,4877,4615, 37384,4878,4616, 37367,4861,4599, 4617,4879,4617, 37368,4862,4600, 4618,4880,4618, 37369,4863,4601, 4619,4881,4619, 37370,4864,4602, 4620,4882,4620, 37371,4865,4603, 4621,4883,4621, 37390,4884,4622, 
35861,3272,3093, 3094,3273,3094, 4623,4885,4623, 35850,3261,3082, 2455,2630,2455, 2456,2631,2456, 4624,4886,4624, 35352,2759,2584, 35225,2632,2457, 
42, // chain 291
4410,4672,4410, 4411,4673,4411, 4604,4866,4604, 
4625,4887,4625, 37394,4888,4626, 37373,4867,4605, 4627,4889,4627, 37374,4868,4606, 4628,4890,4628, 37375,4869,4607, 4629,4891,4629, 37376,4870,4608, 4630,4892,4630, 37377,4871,4609, 4631,4893,4631, 37400,4894,4632, 37378,4872,4610, 4633,4895,4633, 37379,4873,4611, 
4634,4896,4634, 37380,4874,4612, 4635,4897,4635, 37381,4875,4613, 4636,4898,4636, 37382,4876,4614, 4637,4899,4637, 37383,4877,4615, 4638,4900,4638, 37407,4901,4639, 37384,4878,4616, 4640,4902,4640, 37385,4879,4617, 4641,4903,4641, 37386,4880,4618, 4642,4904,4642, 
37387,4881,4619, 4643,4905,4643, 37388,4882,4620, 4644,4906,4644, 37389,4883,4621, 4645,4907,4645, 37392,4886,4624, 37390,4884,4622, 4623,4885,4623, 
2, // chain 292
4625,4887,4625, 4408,4670,4408, 4409,4671,4409, 
4410,4672,4410, 
6, // chain 293
4408,4670,4408, 4625,4887,4625, 4646,4908,4646, 
4407,4669,4407, 37415,4909,4647, 37416,4910,4648, 37394,4888,4626, 37393,4887,4625, 
8, // chain 294
4647,4909,4647, 4648,4910,4648, 4649,4911,4649, 
4650,4912,4650, 37419,4913,4651, 37420,4914,4652, 37421,4915,4653, 37416,4910,4648, 4627,4889,4627, 37394,4888,4626, 
13, // chain 295
4407,4669,4407, 4647,4909,4647, 4406,4668,4406, 
37418,4912,4650, 4405,4667,4405, 37422,4916,4654, 37419,4913,4651, 4655,4917,4655, 37424,4918,4656, 37420,4914,4652, 4657,4919,4657, 37426,4920,4658, 37421,4915,4653, 4628,4890,4628, 37395,4889,4627, 
8, // chain 296
4403,4665,4403, 4404,4666,4404, 4659,4921,4659, 
3580,3811,3580, 36347,3810,3579, 37428,4922,4660, 37429,4923,4661, 37172,4666,4404, 4654,4916,4654, 37173,4667,4405, 
3, // chain 297
4662,4924,4662, 4660,4922,4660, 4661,4923,4661, 
4655,4917,4655, 37422,4916,4654, 
16, // chain 298
4660,4922,4660, 4662,4924,4662, 4663,4925,4663, 
3578,3809,3578, 36345,3808,3577, 37432,4926,4664, 37433,4927,4665, 37430,4924,4662, 4666,4928,4666, 37423,4917,4655, 4656,4918,4656, 4667,4929,4667, 37425,4919,4657, 4668,4930,4668, 37437,4931,4669, 37426,4920,4658, 4629,4891,4629, 37396,4890,4628, 
1, // chain 299
3578,3809,3578, 3579,3810,3579, 4660,4922,4660, 
1, // chain 300
3580,3811,3580, 3581,3812,3581, 4403,4665,4403, 
41, // chain 301
4554,4816,4554, 4527,4789,4527, 4528,4790,4528, 
4670,4932,4670, 37297,4791,4529, 4671,4933,4671, 37298,4792,4530, 4672,4934,4672, 37299,4793,4531, 4673,4935,4673, 37300,4794,4532, 4674,4936,4674, 37301,4795,4533, 4534,4796,4534, 4675,4937,4675, 37303,4797,4535, 4676,4938,4676, 37304,4798,4536, 4677,4939,4677, 
37305,4799,4537, 4678,4940,4678, 37306,4800,4538, 4679,4941,4679, 37307,4801,4539, 4680,4942,4680, 37308,4802,4540, 4681,4943,4681, 37309,4803,4541, 4682,4944,4682, 37310,4804,4542, 4683,4945,4683, 37311,4805,4543, 4684,4946,4684, 37312,4806,4544, 4545,4807,4545, 
4546,4808,4546, 4685,4947,4685, 37315,4809,4547, 4686,4948,4686, 37455,4949,4687, 37316,4810,4548, 4021,4283,4021, 36788,4282,4020, 
30, // chain 302
4553,4815,4553, 4554,4816,4554, 4688,4950,4688, 
37438,4932,4670, 4689,4951,4689, 37439,4933,4671, 4690,4952,4690, 37440,4934,4672, 4691,4953,4691, 37441,4935,4673, 4692,4954,4692, 37442,4936,4674, 4693,4955,4693, 37443,4937,4675, 4694,4956,4694, 37444,4938,4676, 4677,4939,4677, 4695,4957,4695, 37446,4940,4678, 
4696,4958,4696, 37447,4941,4679, 4697,4959,4697, 37448,4942,4680, 4698,4960,4698, 37449,4943,4681, 4699,4961,4699, 37450,4944,4682, 4700,4962,4700, 37451,4945,4683, 4701,4963,4701, 37453,4947,4685, 37452,4946,4684, 
10, // chain 303
4688,4950,4688, 4702,4964,4702, 4703,4965,4703, 
4553,4815,4553, 37320,4814,4552, 37472,4966,4704, 37473,4967,4705, 37470,4964,4702, 4706,4968,4706, 37475,4969,4707, 37457,4951,4689, 37456,4950,4688, 
3, // chain 304
4708,4970,4708, 4668,4930,4668, 4669,4931,4669, 
4630,4892,4630, 37397,4891,4629, 
8, // chain 305
4668,4930,4668, 4708,4970,4708, 4709,4971,4709, 
4710,4972,4710, 37479,4973,4711, 37480,4974,4712, 37481,4975,4713, 37476,4970,4708, 4631,4893,4631, 37398,4892,4630, 
46, // chain 306
4667,4929,4667, 4668,4930,4668, 4710,4972,4710, 
4714,4976,4714, 37483,4977,4715, 37479,4973,4711, 4716,4978,4716, 37485,4979,4717, 37480,4974,4712, 4718,4980,4718, 37487,4981,4719, 37481,4975,4713, 4720,4982,4720, 37399,4893,4631, 4721,4983,4721, 37400,4894,4632, 4722,4984,4722, 37401,4895,4633, 4723,4985,4723, 
37402,4896,4634, 4724,4986,4724, 37403,4897,4635, 4725,4987,4725, 37404,4898,4636, 4726,4988,4726, 37405,4899,4637, 4727,4989,4727, 37406,4900,4638, 4728,4990,4728, 37497,4991,4729, 37407,4901,4639, 4730,4992,4730, 37499,4993,4731, 37408,4902,4640, 4732,4994,4732, 
37501,4995,4733, 37409,4903,4641, 4734,4996,4734, 37410,4904,4642, 4735,4997,4735, 37411,4905,4643, 4736,4998,4736, 37412,4906,4644, 4737,4999,4737, 37413,4907,4645, 2585,2760,2585, 35352,2759,2584, 37392,4886,4624, 
55, // chain 307
4666,4928,4666, 4667,4929,4667, 4714,4976,4714, 
4665,4927,4665, 37506,5000,4738, 37483,4977,4715, 4739,5001,4739, 37508,5002,4740, 37484,4978,4716, 4741,5003,4741, 37510,5004,4742, 37485,4979,4717, 4743,5005,4743, 37486,4980,4718, 4744,5006,4744, 37513,5007,4745, 37487,4981,4719, 4746,5008,4746, 37488,4982,4720, 
4747,5009,4747, 37489,4983,4721, 4748,5010,4748, 37490,4984,4722, 4749,5011,4749, 37491,4985,4723, 4750,5012,4750, 37492,4986,4724, 4751,5013,4751, 37493,4987,4725, 4752,5014,4752, 37494,4988,4726, 4753,5015,4753, 37495,4989,4727, 4754,5016,4754, 37496,4990,4728, 
4755,5017,4755, 37524,5018,4756, 37497,4991,4729, 4730,4992,4730, 4757,5019,4757, 37526,5020,4758, 37499,4993,4731, 4732,4994,4732, 4759,5021,4759, 37528,5022,4760, 37501,4995,4733, 4761,5023,4761, 37502,4996,4734, 4762,5024,4762, 37503,4997,4735, 4763,5025,4763, 
37504,4998,4736, 4764,5026,4764, 37505,4999,4737, 2612,2787,2612, 35353,2760,2585, 2586,2761,2586, 
58, // chain 308
4665,4927,4665, 4738,5000,4738, 4664,4926,4664, 
37533,5027,4765, 37534,5028,4766, 37507,5001,4739, 4767,5029,4767, 37508,5002,4740, 4768,5030,4768, 37509,5003,4741, 4769,5031,4769, 37538,5032,4770, 37510,5004,4742, 4743,5005,4743, 4771,5033,4771, 37512,5006,4744, 4772,5034,4772, 37541,5035,4773, 37513,5007,4745, 
4774,5036,4774, 37514,5008,4746, 4775,5037,4775, 37515,5009,4747, 4776,5038,4776, 37516,5010,4748, 4777,5039,4777, 37517,5011,4749, 4778,5040,4778, 37518,5012,4750, 4779,5041,4779, 37519,5013,4751, 4780,5042,4780, 37520,5014,4752, 4781,5043,4781, 37521,5015,4753, 
4782,5044,4782, 37522,5016,4754, 4783,5045,4783, 37523,5017,4755, 4784,5046,4784, 37553,5047,4785, 37524,5018,4756, 4757,5019,4757, 4786,5048,4786, 37555,5049,4787, 37526,5020,4758, 4759,5021,4759, 4788,5050,4788, 37557,5051,4789, 37528,5022,4760, 4790,5052,4790, 
37559,5053,4791, 37529,5023,4761, 4762,5024,4762, 4792,5054,4792, 37531,5025,4763, 4793,5055,4793, 37532,5026,4764, 2613,2788,2613, 35380,2787,2612, 
4, // chain 309
4765,5027,4765, 3574,3805,3574, 3575,3806,3575, 
4664,4926,4664, 36344,3807,3576, 3577,3808,3577, 
76, // chain 310
3574,3805,3574, 4765,5027,4765, 4766,5028,4766, 
3573,3804,3573, 37535,5029,4767, 3572,3803,3572, 37536,5030,4768, 4794,5056,4794, 37537,5031,4769, 4795,5057,4795, 37564,5058,4796, 37538,5032,4770, 4771,5033,4771, 4797,5059,4797, 37540,5034,4772, 4798,5060,4798, 37567,5061,4799, 37541,5035,4773, 4800,5062,4800, 
37542,5036,4774, 4801,5063,4801, 37543,5037,4775, 4802,5064,4802, 37544,5038,4776, 4803,5065,4803, 37545,5039,4777, 4804,5066,4804, 37546,5040,4778, 4805,5067,4805, 37547,5041,4779, 4806,5068,4806, 37548,5042,4780, 4807,5069,4807, 37549,5043,4781, 4808,5070,4808, 
37550,5044,4782, 4809,5071,4809, 37551,5045,4783, 4810,5072,4810, 37552,5046,4784, 4811,5073,4811, 37580,5074,4812, 37553,5047,4785, 4786,5048,4786, 4813,5075,4813, 37582,5076,4814, 37555,5049,4787, 4788,5050,4788, 4815,5077,4815, 37584,5078,4816, 37557,5051,4789, 
4817,5079,4817, 37558,5052,4790, 4791,5053,4791, 4792,5054,4792, 4793,5055,4793, 4818,5080,4818, 35381,2788,2613, 4819,5081,4819, 35382,2789,2614, 2734,2909,2734, 4820,5082,4820, 37589,5083,4821, 35503,2910,2735, 4822,5084,4822, 37591,5085,4823, 35504,2911,2736, 
2737,2912,2737, 4824,5086,4824, 35506,2913,2738, 4825,5087,4825, 35670,3081,2902, 2931,3110,2931, 4826,5088,4826, 37595,5089,4827, 35700,3111,2932, 455,462,455, 33222,461,454, 
9, // chain 311
4692,4954,4692, 4828,5090,4828, 4829,5091,4829, 
4691,4953,4691, 37598,5092,4830, 37599,5093,4831, 37596,5090,4828, 4832,5094,4832, 37601,5095,4833, 37461,4955,4693, 37460,4954,4692, 
2, // chain 312
4690,4952,4690, 4830,5092,4830, 4707,4969,4707, 
4689,4951,4689, 
1, // chain 313
4691,4953,4691, 4830,5092,4830, 4690,4952,4690, 
47, // chain 314
4796,5058,4796, 4797,5059,4797, 4834,5096,4834, 
4795,5057,4795, 37603,5097,4835, 37604,5098,4836, 37605,5099,4837, 37565,5059,4797, 4798,5060,4798, 4838,5100,4838, 37607,5101,4839, 37567,5061,4799, 4840,5102,4840, 37568,5062,4800, 4841,5103,4841, 37569,5063,4801, 4842,5104,4842, 37570,5064,4802, 4843,5105,4843, 
37571,5065,4803, 4844,5106,4844, 37572,5066,4804, 4845,5107,4845, 37573,5067,4805, 4846,5108,4846, 37574,5068,4806, 4847,5109,4847, 37575,5069,4807, 4848,5110,4848, 37576,5070,4808, 4849,5111,4849, 37577,5071,4809, 4850,5112,4850, 37578,5072,4810, 4851,5113,4851, 
37579,5073,4811, 4852,5114,4852, 37621,5115,4853, 37580,5074,4812, 4813,5075,4813, 4854,5116,4854, 37623,5117,4855, 37582,5076,4814, 4815,5077,4815, 4821,5083,4821, 37588,5082,4820, 37584,5078,4816, 4818,5080,4818, 37585,5079,4817, 
45, // chain 315
4795,5057,4795, 4835,5097,4835, 4856,5118,4856, 
37625,5119,4857, 37626,5120,4858, 37604,5098,4836, 4859,5121,4859, 37628,5122,4860, 37605,5099,4837, 4838,5100,4838, 4861,5123,4861, 37630,5124,4862, 37607,5101,4839, 4863,5125,4863, 37608,5102,4840, 4864,5126,4864, 37609,5103,4841, 4865,5127,4865, 37610,5104,4842, 
4866,5128,4866, 37611,5105,4843, 4867,5129,4867, 37612,5106,4844, 4868,5130,4868, 37613,5107,4845, 4869,5131,4869, 37614,5108,4846, 4870,5132,4870, 37615,5109,4847, 4871,5133,4871, 37616,5110,4848, 4872,5134,4872, 37617,5111,4849, 4873,5135,4873, 37618,5112,4850, 
4874,5136,4874, 37619,5113,4851, 4875,5137,4875, 37620,5114,4852, 4876,5138,4876, 37645,5139,4877, 37621,5115,4853, 4854,5116,4854, 4878,5140,4878, 37590,5084,4822, 37623,5117,4855, 4821,5083,4821, 
2, // chain 316
4856,5118,4856, 3571,3802,3571, 4794,5056,4794, 
4795,5057,4795, 
49, // chain 317
3570,3801,3570, 3571,3802,3571, 4856,5118,4856, 
4857,5119,4857, 3569,3800,3569, 37647,5141,4879, 37626,5120,4858, 4880,5142,4880, 37627,5121,4859, 4881,5143,4881, 37650,5144,4882, 37628,5122,4860, 4861,5123,4861, 4883,5145,4883, 37652,5146,4884, 37630,5124,4862, 4885,5147,4885, 37631,5125,4863, 4886,5148,4886, 
37632,5126,4864, 4887,5149,4887, 37633,5127,4865, 4888,5150,4888, 37634,5128,4866, 4889,5151,4889, 37635,5129,4867, 4890,5152,4890, 37636,5130,4868, 4891,5153,4891, 37637,5131,4869, 4892,5154,4892, 37638,5132,4870, 4893,5155,4893, 37639,5133,4871, 4894,5156,4894, 
37640,5134,4872, 4895,5157,4895, 37641,5135,4873, 4896,5158,4896, 37642,5136,4874, 4897,5159,4897, 37643,5137,4875, 4898,5160,4898, 37644,5138,4876, 4826,5088,4826, 37667,5161,4899, 37645,5139,4877, 4878,5140,4878, 4824,5086,4824, 37591,5085,4823, 37590,5084,4822, 
12, // chain 318
4696,4958,4696, 4697,4959,4697, 4900,5162,4900, 
37669,5163,4901, 37466,4960,4698, 4902,5164,4902, 37467,4961,4699, 4903,5165,4903, 37468,4962,4700, 4904,5166,4904, 37469,4963,4701, 4905,5167,4905, 37454,4948,4686, 37453,4947,4685, 
20, // chain 319
4694,4956,4694, 4695,4957,4695, 4833,5095,4833, 
37674,5168,4906, 37464,4958,4696, 4900,5162,4900, 4907,5169,4907, 37676,5170,4908, 37669,5163,4901, 4909,5171,4909, 37670,5164,4902, 4910,5172,4910, 37671,5165,4903, 4911,5173,4911, 37672,5166,4904, 4912,5174,4912, 37673,5167,4905, 4913,5175,4913, 37454,4948,4686, 
4687,4949,4687, 4022,4284,4022, 36789,4283,4021, 
36, // chain 320
4914,5176,4914, 4881,5143,4881, 4882,5144,4882, 
4883,5145,4883, 4915,5177,4915, 37684,5178,4916, 37685,5179,4917, 37652,5146,4884, 4918,5180,4918, 37653,5147,4885, 4886,5148,4886, 4919,5181,4919, 37655,5149,4887, 4920,5182,4920, 37689,5183,4921, 37656,5150,4888, 4922,5184,4922, 37657,5151,4889, 4890,5152,4890, 
4923,5185,4923, 37659,5153,4891, 4924,5186,4924, 37660,5154,4892, 4925,5187,4925, 37661,5155,4893, 4926,5188,4926, 37662,5156,4894, 4927,5189,4927, 37663,5157,4895, 4928,5190,4928, 37664,5158,4896, 458,465,458, 33225,464,457, 37665,5159,4897, 456,463,456, 
37666,5160,4898, 4827,5089,4827, 37594,5088,4826, 
44, // chain 321
4881,5143,4881, 4914,5176,4914, 4929,5191,4929, 
4930,5192,4930, 37699,5193,4931, 37700,5194,4932, 37682,5176,4914, 4915,5177,4915, 4933,5195,4933, 37702,5196,4934, 37684,5178,4916, 4935,5197,4935, 37685,5179,4917, 4936,5198,4936, 37686,5180,4918, 4937,5199,4937, 37687,5181,4919, 4938,5200,4938, 37688,5182,4920, 
4939,5201,4939, 37689,5183,4921, 4940,5202,4940, 37690,5184,4922, 4941,5203,4941, 37691,5185,4923, 4942,5204,4942, 37692,5186,4924, 4943,5205,4943, 37693,5187,4925, 4944,5206,4944, 37694,5188,4926, 4945,5207,4945, 37695,5189,4927, 4946,5208,4946, 37696,5190,4928, 
4947,5209,4947, 33226,465,458, 459,466,459, 4948,5210,4948, 33228,467,460, 4949,5211,4949, 33229,468,461, 4950,5212,4950, 33230,469,462, 358,364,358, 33125,363,357, 
7, // chain 322
4879,5141,4879, 4880,5142,4880, 4951,5213,4951, 
3568,3799,3568, 36335,3798,3567, 37720,5214,4952, 37698,5192,4930, 37648,5142,4880, 4881,5143,4881, 
49, // chain 323
4930,5192,4930, 4931,5193,4931, 4952,5214,4952, 
37721,5215,4953, 37722,5216,4954, 37700,5194,4932, 4933,5195,4933, 4955,5217,4955, 37724,5218,4956, 37702,5196,4934, 4957,5219,4957, 37703,5197,4935, 4958,5220,4958, 37704,5198,4936, 4959,5221,4959, 37705,5199,4937, 4960,5222,4960, 37706,5200,4938, 4961,5223,4961, 
37707,5201,4939, 4962,5224,4962, 37708,5202,4940, 4963,5225,4963, 37709,5203,4941, 4964,5226,4964, 37710,5204,4942, 4965,5227,4965, 37711,5205,4943, 4966,5228,4966, 37712,5206,4944, 4967,5229,4967, 37713,5207,4945, 4968,5230,4968, 37714,5208,4946, 4969,5231,4969, 
37715,5209,4947, 4948,5210,4948, 4970,5232,4970, 37717,5211,4949, 4971,5233,4971, 37718,5212,4950, 4972,5234,4972, 33126,364,358, 359,365,359, 4973,5235,4973, 33128,366,360, 4974,5236,4974, 33129,367,361, 3353,3545,3353, 33130,368,362, 363,369,363, 
47, // chain 324
3566,3797,3566, 3567,3798,3567, 4952,5214,4952, 
4953,5215,4953, 3565,3796,3565, 36332,3795,3564, 37743,5237,4975, 37722,5216,4954, 4955,5217,4955, 4976,5238,4976, 37745,5239,4977, 37724,5218,4956, 4978,5240,4978, 37747,5241,4979, 37725,5219,4957, 4980,5242,4980, 37726,5220,4958, 4981,5243,4981, 37727,5221,4959, 
4982,5244,4982, 37728,5222,4960, 4983,5245,4983, 37729,5223,4961, 4984,5246,4984, 37730,5224,4962, 4985,5247,4985, 37731,5225,4963, 4986,5248,4986, 37732,5226,4964, 4987,5249,4987, 37733,5227,4965, 4988,5250,4988, 37734,5228,4966, 4989,5251,4989, 37735,5229,4967, 
4990,5252,4990, 37736,5230,4968, 4991,5253,4991, 37737,5231,4969, 4970,5232,4970, 4992,5254,4992, 37739,5233,4971, 4993,5255,4993, 37740,5234,4972, 4973,5235,4973, 4994,5256,4994, 37742,5236,4974, 3354,3546,3354, 36121,3545,3353, 
1, // chain 325
3568,3799,3568, 3569,3800,3569, 4879,5141,4879, 
9, // chain 326
4977,5239,4977, 4995,5257,4995, 4996,5258,4996, 
4976,5238,4976, 36330,3793,3562, 36329,3792,3561, 37763,5257,4995, 3560,3791,3560, 37765,5259,4997, 37746,5240,4978, 37745,5239,4977, 
3, // chain 327
4976,5238,4976, 3562,3793,3562, 3563,3794,3563, 
4975,5237,4975, 36332,3795,3564, 
7, // chain 328
4990,5252,4990, 4991,5253,4991, 4998,5260,4998, 
37760,5254,4992, 4999,5261,4999, 37761,5255,4993, 4994,5256,4994, 3355,3547,3355, 36122,3546,3354, 
10, // chain 329
4998,5260,4998, 5000,5262,5000, 5001,5263,5001, 
4990,5252,4990, 37757,5251,4989, 37770,5264,5002, 37771,5265,5003, 37768,5262,5000, 3356,3548,3356, 36123,3547,3355, 37767,5261,4999, 37766,5260,4998, 
4, // chain 330
5003,5265,5003, 3356,3548,3356, 3357,3549,3357, 
5004,5266,5004, 36315,3778,3547, 36126,3550,3358, 
4, // chain 331
4988,5250,4988, 4989,5251,4989, 5002,5264,5002, 
5005,5267,5005, 37772,5266,5004, 37771,5265,5003, 
3, // chain 332
4986,5248,4986, 4987,5249,4987, 5006,5268,5006, 
37773,5267,5005, 37756,5250,4988, 
14, // chain 333
5006,5268,5006, 5007,5269,5007, 5008,5270,5008, 
4986,5248,4986, 37753,5247,4985, 37777,5271,5009, 37778,5272,5010, 37775,5269,5007, 3550,3781,3550, 36317,3780,3549, 37779,5273,5011, 37774,5268,5006, 5005,5267,5005, 5004,5266,5004, 3548,3779,3548, 36315,3778,3547, 
6, // chain 334
4984,5246,4984, 4985,5247,4985, 5009,5271,5009, 
5012,5274,5012, 37781,5275,5013, 37778,5272,5010, 3551,3782,3551, 36318,3781,3550, 
3, // chain 335
4982,5244,4982, 4983,5245,4983, 5014,5276,5014, 
37780,5274,5012, 37752,5246,4984, 
14, // chain 336
5014,5276,5014, 5015,5277,5015, 5016,5278,5016, 
4982,5244,4982, 37749,5243,4981, 37785,5279,5017, 37786,5280,5018, 37783,5277,5015, 3554,3785,3554, 36321,3784,3553, 37787,5281,5019, 37782,5276,5014, 5012,5274,5012, 5013,5275,5013, 3552,3783,3552, 36319,3782,3551, 
6, // chain 337
4980,5242,4980, 4981,5243,4981, 5017,5279,5017, 
5020,5282,5020, 37789,5283,5021, 37786,5280,5018, 3555,3786,3555, 36322,3785,3554, 
3, // chain 338
4978,5240,4978, 4979,5241,4979, 5022,5284,5022, 
37788,5282,5020, 37748,5242,4980, 
2, // chain 339
5022,5284,5022, 5023,5285,5023, 4997,5259,4997, 
4978,5240,4978, 
6, // chain 340
5023,5285,5023, 5022,5284,5022, 5024,5286,5024, 
3557,3788,3557, 36324,3787,3556, 37789,5283,5021, 37788,5282,5020, 37790,5284,5022, 
1, // chain 341
3555,3786,3555, 3556,3787,3556, 5021,5283,5021, 
3, // chain 342
5023,5285,5023, 3558,3789,3558, 3559,3790,3559, 
4997,5259,4997, 36328,3791,3560, 
1, // chain 343
3557,3788,3557, 3558,3789,3558, 5023,5285,5023, 
10, // chain 344
3274,3466,3274, 5025,5287,5025, 5026,5288,5026, 
3272,3464,3272, 37795,5289,5027, 37796,5290,5028, 37797,5291,5029, 37793,5287,5025, 5030,5292,5030, 37799,5293,5031, 36044,3468,3276, 36042,3466,3274, 
10, // chain 345
5028,5290,5028, 5032,5294,5032, 5033,5295,5033, 
5034,5296,5034, 37803,5297,5035, 37804,5298,5036, 37805,5299,5037, 37800,5294,5032, 5038,5300,5038, 37807,5301,5039, 37797,5291,5029, 37796,5290,5028, 
19, // chain 346
5027,5289,5027, 5028,5290,5028, 5034,5296,5034, 
5040,5302,5040, 37809,5303,5041, 37803,5297,5035, 5042,5304,5042, 37811,5305,5043, 37812,5306,5044, 37804,5298,5036, 5045,5307,5045, 37814,5308,5046, 37805,5299,5037, 5047,5309,5047, 37806,5300,5038, 5048,5310,5048, 37817,5311,5049, 37807,5301,5039, 5050,5312,5050, 
37798,5292,5030, 37797,5291,5029, 
33, // chain 347
3270,3462,3270, 5027,5289,5027, 5040,5302,5040, 
3268,3460,3268, 37819,5313,5051, 37809,5303,5041, 5052,5314,5052, 37821,5315,5053, 37810,5304,5042, 5054,5316,5054, 37811,5305,5043, 5055,5317,5055, 37824,5318,5056, 37812,5306,5044, 5057,5319,5057, 37813,5307,5045, 5058,5320,5058, 37827,5321,5059, 37814,5308,5046, 
5060,5322,5060, 37815,5309,5047, 5061,5323,5061, 37816,5310,5048, 5062,5324,5062, 37831,5325,5063, 37817,5311,5049, 5064,5326,5064, 37818,5312,5050, 5065,5327,5065, 37834,5328,5066, 37798,5292,5030, 5031,5293,5031, 5067,5329,5067, 36046,3470,3278, 36044,3468,3276, 
1, // chain 348
3272,3464,3272, 5027,5289,5027, 3270,3462,3270, 
41, // chain 349
3266,3458,3266, 5051,5313,5051, 5068,5330,5068, 
3264,3456,3264, 37837,5331,5069, 37838,5332,5070, 37819,5313,5051, 5052,5314,5052, 5071,5333,5071, 37821,5315,5053, 5072,5334,5072, 37822,5316,5054, 5073,5335,5073, 37823,5317,5055, 5074,5336,5074, 37843,5337,5075, 37824,5318,5056, 5076,5338,5076, 37825,5319,5057, 
5077,5339,5077, 37826,5320,5058, 5078,5340,5078, 37847,5341,5079, 37827,5321,5059, 5080,5342,5080, 37828,5322,5060, 5081,5343,5081, 37829,5323,5061, 5062,5324,5062, 5082,5344,5082, 37851,5345,5083, 37852,5346,5084, 37831,5325,5063, 5085,5347,5085, 37832,5326,5064, 
5086,5348,5086, 37833,5327,5065, 5087,5349,5087, 37834,5328,5066, 5067,5329,5067, 5088,5350,5088, 36048,3472,3280, 36046,3470,3278, 
1, // chain 350
3268,3460,3268, 5051,5313,5051, 3266,3458,3266, 
26, // chain 351
5069,5331,5069, 5070,5332,5070, 5089,5351,5089, 
5090,5352,5090, 37859,5353,5091, 37860,5354,5092, 37838,5332,5070, 5071,5333,5071, 5093,5355,5093, 37840,5334,5072, 5094,5356,5094, 37841,5335,5073, 5095,5357,5095, 37842,5336,5074, 5096,5358,5096, 37865,5359,5097, 37843,5337,5075, 5098,5360,5098, 37844,5338,5076, 
5099,5361,5099, 37845,5339,5077, 5100,5362,5100, 37846,5340,5078, 5101,5363,5101, 37870,5364,5102, 37847,5341,5079, 5081,5343,5081, 37848,5342,5080, 
30, // chain 352
5091,5353,5091, 5092,5354,5092, 5103,5365,5103, 
5104,5366,5104, 37873,5367,5105, 37874,5368,5106, 37875,5369,5107, 37876,5370,5108, 37860,5354,5092, 5093,5355,5093, 5109,5371,5109, 37862,5356,5094, 5110,5372,5110, 37863,5357,5095, 5111,5373,5111, 37864,5358,5096, 5112,5374,5112, 37881,5375,5113, 37865,5359,5097, 
5114,5376,5114, 37866,5360,5098, 5115,5377,5115, 37867,5361,5099, 5116,5378,5116, 37868,5362,5100, 5117,5379,5117, 37869,5363,5101, 5118,5380,5118, 37887,5381,5119, 37870,5364,5102, 5082,5344,5082, 37849,5343,5081, 
57, // chain 353
3264,3456,3264, 5069,5331,5069, 3262,3454,3262, 
37858,5352,5090, 3260,3452,3260, 37888,5382,5120, 37859,5353,5091, 5104,5366,5104, 5121,5383,5121, 37873,5367,5105, 5122,5384,5122, 37891,5385,5123, 37874,5368,5106, 5124,5386,5124, 37893,5387,5125, 37875,5369,5107, 5126,5388,5126, 37895,5389,5127, 37876,5370,5108, 
5109,5371,5109, 5128,5390,5128, 37878,5372,5110, 5129,5391,5129, 37879,5373,5111, 5130,5392,5130, 37880,5374,5112, 5131,5393,5131, 37900,5394,5132, 37881,5375,5113, 5133,5395,5133, 37882,5376,5114, 5134,5396,5134, 37883,5377,5115, 5135,5397,5135, 37904,5398,5136, 
37884,5378,5116, 5137,5399,5137, 37885,5379,5117, 5118,5380,5118, 5138,5400,5138, 37907,5401,5139, 37887,5381,5119, 5140,5402,5140, 37850,5344,5082, 5083,5345,5083, 5141,5403,5141, 37910,5404,5142, 37852,5346,5084, 5143,5405,5143, 37853,5347,5085, 5144,5406,5144, 
37854,5348,5086, 5145,5407,5145, 37914,5408,5146, 37855,5349,5087, 5088,5350,5088, 5147,5409,5147, 36050,3474,3282, 36048,3472,3280, 
44, // chain 354
5148,5410,5148, 5127,5389,5127, 5128,5390,5128, 
5149,5411,5149, 37897,5391,5129, 5150,5412,5150, 37898,5392,5130, 5151,5413,5151, 37899,5393,5131, 5152,5414,5152, 37921,5415,5153, 37900,5394,5132, 5154,5416,5154, 37901,5395,5133, 5155,5417,5155, 37902,5396,5134, 5156,5418,5156, 37903,5397,5135, 5157,5419,5157, 
37926,5420,5158, 37904,5398,5136, 5159,5421,5159, 37905,5399,5137, 5138,5400,5138, 5160,5422,5160, 37929,5423,5161, 37907,5401,5139, 5162,5424,5162, 37908,5402,5140, 5141,5403,5141, 5163,5425,5163, 37932,5426,5164, 37910,5404,5142, 5165,5427,5165, 37911,5405,5143, 
5166,5428,5166, 37912,5406,5144, 5167,5429,5167, 37913,5430,5145, 5168,5431,5168, 37937,5432,5169, 37938,5433,5170, 5171,5434,5171, 36054,5435,3286, 5172,5436,5172, 36055,5437,3287, 
50, // chain 355
5126,5388,5126, 5127,5389,5127, 5148,5410,5148, 
5173,5438,5173, 37942,5439,5174, 37917,5411,5149, 5175,5440,5175, 37918,5412,5150, 5176,5441,5176, 37919,5413,5151, 5152,5414,5152, 5177,5442,5177, 37946,5443,5178, 37947,5444,5179, 37921,5415,5153, 5154,5416,5154, 5180,5445,5180, 37923,5417,5155, 5181,5446,5181, 
37924,5418,5156, 5182,5447,5182, 37951,5448,5183, 37925,5419,5157, 5184,5449,5184, 37926,5420,5158, 5185,5450,5185, 37927,5421,5159, 5160,5422,5160, 5186,5451,5186, 37955,5452,5187, 37929,5423,5161, 5188,5453,5188, 37930,5424,5162, 5163,5425,5163, 3232,3420,3232, 
37957,5454,5189, 37932,5426,5164, 5190,5455,5190, 37933,5427,5165, 5191,5456,5191, 37934,5428,5166, 5192,5457,5192, 37935,5429,5167, 5193,5458,5193, 37962,5459,5194, 37936,5431,5168, 5195,5460,5195, 37937,5432,5169, 5196,5461,5196, 37939,5434,5171, 5197,5462,5197, 
37940,5436,5172, 
33, // chain 356
5198,5463,5198, 5199,5464,5199, 5173,5438,5173, 
5200,5465,5200, 37942,5439,5174, 5201,5466,5201, 37943,5440,5175, 5176,5441,5176, 5202,5467,5202, 37945,5442,5177, 5203,5468,5203, 37972,5469,5204, 37946,5443,5178, 5205,5470,5205, 37974,5471,5206, 37947,5444,5179, 5207,5472,5207, 37976,5473,5208, 37948,5445,5180, 
5209,5474,5209, 37949,5446,5181, 5210,5475,5210, 37950,5447,5182, 5183,5448,5183, 5211,5476,5211, 37952,5449,5184, 5212,5477,5212, 37953,5450,5185, 5186,5451,5186, 3235,3423,3235, 36002,3422,3234, 37955,5452,5187, 3233,3421,3233, 37956,5453,5188, 3232,3420,3232, 
34, // chain 357
5199,5464,5199, 5198,5463,5198, 5213,5478,5213, 
5214,5479,5214, 37983,5480,5215, 37984,5481,5216, 37985,5482,5217, 37966,5463,5198, 5218,5483,5218, 37968,5465,5200, 5201,5466,5201, 5219,5484,5219, 37970,5467,5202, 5220,5485,5220, 37971,5468,5203, 5221,5486,5221, 37990,5487,5222, 37972,5469,5204, 5205,5470,5205, 
5223,5488,5223, 37992,5489,5224, 36010,3430,3242, 37974,5471,5206, 3241,3429,3241, 36008,3428,3240, 37975,5472,5207, 3239,3427,3239, 37976,5473,5208, 3238,3426,3238, 37977,5474,5209, 3237,3425,3237, 37978,5475,5210, 3236,3424,3236, 37979,5476,5211, 5212,5477,5212, 
3235,3423,3235, 
2, // chain 358
5199,5464,5199, 5125,5387,5125, 5126,5388,5126, 
5173,5438,5173, 
20, // chain 359
5125,5387,5125, 5199,5464,5199, 5214,5479,5214, 
5124,5386,5124, 37993,5490,5225, 37983,5480,5215, 5226,5491,5226, 37984,5481,5216, 5227,5492,5227, 37996,5493,5228, 37997,5494,5229, 37985,5482,5217, 5230,5495,5230, 37986,5483,5218, 5219,5484,5219, 5231,5496,5231, 37988,5485,5220, 5232,5497,5232, 37989,5486,5221, 
5233,5498,5233, 37991,5488,5223, 37990,5487,5222, 
13, // chain 360
4066,4328,4066, 4067,4329,4067, 4492,4754,4492, 
5234,5499,5234, 38003,5500,5235, 37261,4755,4493, 4042,4304,4042, 36809,4303,4041, 38004,5501,5236, 37262,4756,4494, 5237,5502,5237, 37263,4757,4495, 5238,5503,5238, 37317,4811,4549, 37264,4758,4496, 
2, // chain 361
5234,5499,5234, 4064,4326,4064, 4065,4327,4065, 
4066,4328,4066, 
9, // chain 362
4064,4326,4064, 5234,5499,5234, 5239,5504,5239, 
4063,4325,4063, 38008,5505,5240, 38009,5506,5241, 38010,5507,5242, 38002,5499,5234, 5235,5500,5235, 4043,4305,4043, 36810,4304,4042, 
8, // chain 363
4063,4325,4063, 5240,5505,5240, 5243,5508,5243, 
38012,5509,5244, 38013,5510,5245, 38009,5506,5241, 4045,4307,4045, 36812,4306,4044, 38010,5507,5242, 4043,4305,4043, 
7, // chain 364
5246,5511,5246, 5247,5512,5247, 5243,5508,5243, 
5244,5509,5244, 5248,5513,5248, 38017,5514,5249, 38013,5510,5245, 4046,4308,4046, 36813,4307,4045, 
12, // chain 365
5247,5512,5247, 5246,5511,5246, 5250,5515,5250, 
5251,5516,5251, 38020,5517,5252, 38021,5518,5253, 38022,5519,5254, 38014,5511,5246, 5255,5520,5255, 38016,5513,5248, 5256,5521,5256, 38017,5514,5249, 4047,4309,4047, 36814,4308,4046, 
7, // chain 366
5257,5522,5257, 5253,5518,5253, 5254,5519,5254, 
5258,5523,5258, 38023,5520,5255, 5259,5524,5259, 38024,5521,5256, 4048,4310,4048, 36815,4309,4047, 
11, // chain 367
5253,5518,5253, 5257,5522,5257, 5260,5525,5260, 
5261,5526,5261, 38030,5527,5262, 38031,5528,5263, 38032,5529,5264, 38025,5522,5257, 5265,5530,5265, 38026,5523,5258, 5259,5524,5259, 4049,4311,4049, 36816,4310,4048, 
13, // chain 368
5252,5517,5252, 5253,5518,5253, 5261,5526,5261, 
4058,4320,4058, 36825,4319,4057, 38030,5527,5262, 4056,4318,4056, 38034,5531,5266, 38031,5528,5263, 4052,4314,4052, 36819,4313,4051, 38032,5529,5264, 4050,4312,4050, 38033,5530,5265, 4049,4311,4049, 
3, // chain 369
5247,5512,5247, 4061,4323,4061, 4062,4324,4062, 
5243,5508,5243, 36831,4325,4063, 
5, // chain 370
4061,4323,4061, 5247,5512,5247, 5251,5516,5251, 
4060,4322,4060, 38020,5517,5252, 4058,4320,4058, 4059,4321,4059, 
6, // chain 371
3438,5532,3438, 47,5533,47, 5267,5534,5267, 
3512,5535,3512, 38036,5536,5268, 38037,5537,5269, 32795,5538,27, 32815,5533,47, 
1, // chain 372
69,5539,69, 47,5533,47, 3438,5532,3438, 
8, // chain 373
5268,5536,5268, 5269,5537,5269, 5270,5540,5270, 
5271,5541,5271, 38040,5542,5272, 33958,1342,1190, 38041,5543,5273, 38037,5537,5269, 28,5544,28, 32795,5538,27, 
3, // chain 374
986,1076,986, 1190,1342,1190, 5273,5543,5273, 
29,1074,29, 32796,5544,28, 
22, // chain 375
5272,5542,5272, 1190,1342,1190, 1191,1343,1191, 
5274,5545,5274, 33960,1344,1192, 5275,5546,5275, 38044,5547,5276, 33961,1345,1193, 1305,1457,1305, 5277,5548,5277, 34075,1459,1307, 5278,5549,5278, 34135,1519,1367, 5279,5550,5279, 34136,1520,1368, 3036,3215,3036, 3066,3245,3066, 5280,5551,5280, 35835,3246,3067, 
5281,5552,5281, 38050,5553,5282, 35836,3247,3068, 5197,5554,5197, 35837,3248,3069, 
23, // chain 376
3513,5555,3513, 5268,5536,5268, 5271,5541,5271, 
3515,5556,3515, 38051,5557,5283, 38040,5542,5272, 5274,5545,5274, 5284,5558,5284, 38043,5546,5275, 5285,5559,5285, 38054,5560,5286, 38044,5547,5276, 5277,5548,5277, 5287,5561,5287, 38046,5549,5278, 5288,5562,5288, 38047,5550,5279, 5280,5551,5280, 5289,5563,5289, 
38049,5552,5281, 5290,5564,5290, 38059,5565,5291, 38050,5553,5282, 5172,5566,5172, 37965,5554,5197, 
1, // chain 377
3512,5535,3512, 5268,5536,5268, 3513,5555,3513, 
17, // chain 378
3517,5567,3517, 5283,5557,5283, 5284,5558,5284, 
3519,5568,3519, 38053,5559,5285, 3521,5569,3521, 38060,5570,5292, 38054,5560,5286, 5287,5561,5287, 5293,5571,5293, 38056,5562,5288, 5289,5563,5289, 3525,5572,3525, 36295,5573,3527, 38058,5564,5290, 3529,5574,3529, 38059,5565,5291, 3287,5575,3287, 37940,5566,5172, 
1, // chain 379
3515,5556,3515, 5283,5557,5283, 3517,5567,3517, 
1, // chain 380
4818,5080,4818, 4819,5081,4819, 4820,5082,4820, 
2, // chain 381
4899,5161,4899, 4824,5086,4824, 4825,5087,4825, 
4826,5088,4826, 
1, // chain 382
455,462,455, 456,463,456, 4827,5089,4827, 
3, // chain 383
5293,5571,5293, 3525,5572,3525, 3523,5576,3523, 
5292,5570,5292, 36289,5569,3521, 
2, // chain 384
5294,5577,5294, 5295,5578,5295, 3087,3266,3087, 
3088,3267,3088, 
5, // chain 385
5295,5578,5295, 5294,5577,5294, 3863,5579,3863, 
5296,5580,5296, 36313,5581,3545, 3199,5582,3199, 35994,5583,3226, 
2, // chain 386
5295,5578,5295, 5297,5584,5297, 3086,3265,3086, 
3087,3266,3087, 
3, // chain 387
5297,5584,5297, 5295,5578,5295, 5296,5580,5296, 
3152,5585,3152, 35967,5582,3199, 
2, // chain 388
5297,5584,5297, 3142,5586,3142, 3085,3264,3085, 
3086,3265,3086, 
1, // chain 389
3152,5585,3152, 3142,5586,3142, 5297,5584,5297, 
8, // chain 390
5196,5461,5196, 3069,5587,3069, 3102,3284,3102, 
5195,5460,5195, 35871,3285,3103, 5194,5459,5194, 35872,3286,3104, 5193,5458,5193, 35923,3343,3155, 35873,3287,3105, 
1, // chain 391
5197,5462,5197, 3069,5587,3069, 5196,5461,5196, 
12, // chain 392
5193,5458,5193, 3155,3343,3155, 5192,5457,5192, 
35924,3344,3156, 5191,5456,5191, 35925,3345,3157, 5190,5455,5190, 38066,5588,5298, 35926,3346,3158, 3227,3415,3227, 5299,5589,5299, 35997,3417,3229, 3231,3419,3231, 35998,3418,3230, 
4, // chain 393
3232,3420,3232, 5189,5454,5189, 3231,3419,3231, 
38067,5589,5299, 37958,5455,5190, 5298,5588,5298, 
19, // chain 394
3249,3437,3249, 3250,3438,3250, 5300,5590,5300, 
5301,5591,5301, 38070,5592,5302, 38071,5593,5303, 38072,5594,5304, 36018,3438,3250, 3251,3439,3251, 5305,5595,5305, 36020,3440,3252, 5306,5596,5306, 38075,5597,5307, 36021,3441,3253, 5122,5384,5122, 37889,5383,5121, 36022,3442,3254, 5308,5598,5308, 36023,3444,3255, 
3258,3450,3258, 36024,3446,3256, 
17, // chain 395
3248,3436,3248, 3249,3437,3249, 5301,5591,5301, 
5309,5599,5309, 38078,5600,5310, 38070,5592,5302, 5311,5601,5311, 38071,5593,5303, 5312,5602,5312, 38081,5603,5313, 38072,5594,5304, 5305,5595,5305, 5314,5604,5314, 38074,5596,5306, 5315,5605,5315, 38084,5606,5316, 38075,5597,5307, 5123,5385,5123, 37890,5384,5122, 
18, // chain 396
5317,5607,5317, 3247,3435,3247, 5309,5599,5309, 
5318,5608,5318, 38078,5600,5310, 5232,5497,5232, 38079,5601,5311, 5319,5609,5319, 38080,5602,5312, 5229,5494,5229, 37996,5493,5228, 38081,5603,5313, 5314,5604,5314, 5227,5492,5227, 38083,5605,5315, 5226,5491,5226, 37993,5490,5225, 38084,5606,5316, 5124,5386,5124, 
37891,5385,5123, 
6, // chain 397
3246,3434,3246, 3247,3435,3247, 5317,5607,5317, 
3245,3433,3245, 38088,5610,5320, 38086,5608,5318, 5233,5498,5233, 38000,5497,5232, 
4, // chain 398
3245,3433,3245, 5320,5610,5320, 3244,3432,3244, 
37992,5489,5224, 38001,5498,5233, 5223,5488,5223, 
27, // chain 399
2331,2506,2331, 2332,2507,2332, 3699,5611,3699, 
36469,5612,3701, 38089,5613,5321, 35101,2508,2333, 5322,5614,5322, 35102,2509,2334, 5323,5615,5323, 35103,2510,2335, 2336,2511,2336, 5324,5616,5324, 38093,5617,5325, 35105,2512,2337, 3315,3507,3315, 5326,5618,5326, 38095,5619,5327, 36084,3508,3316, 3317,3509,3317, 
5328,5620,5328, 38097,5621,5329, 36086,3510,3318, 3319,3511,3319, 5330,5622,5330, 36088,3512,3320, 3715,5623,3715, 36485,5624,3717, 36089,3513,3321, 3322,3514,3322, 
8, // chain 400
5331,5625,5331, 3703,5626,3703, 5321,5613,5321, 
5322,5614,5322, 5332,5627,5332, 38091,5615,5323, 5324,5616,5324, 5333,5628,5333, 38094,5618,5326, 38093,5617,5325, 
15, // chain 401
3705,5629,3705, 3703,5626,3703, 5331,5625,5331, 
5334,5630,5334, 38100,5627,5332, 5333,5628,5333, 5335,5631,5335, 38104,5632,5336, 38094,5618,5326, 5327,5619,5327, 5328,5620,5328, 5337,5633,5337, 38106,5634,5338, 38097,5621,5329, 5330,5622,5330, 3713,5635,3713, 36483,5623,3715, 
4, // chain 402
5334,5630,5334, 5335,5631,5335, 3707,5636,3707, 
36477,5637,3709, 38105,5633,5337, 38104,5632,5336, 
2, // chain 403
5337,5633,5337, 5338,5634,5338, 3711,5638,3711, 
36481,5635,3713, 
43, // chain 404
4040,4302,4040, 5236,5501,5236, 5237,5502,5237, 
4039,4301,4039, 38006,5503,5238, 4038,4300,4038, 38107,5639,5339, 37317,4811,4549, 4550,4812,4550, 5340,5640,5340, 37319,4813,4551, 5341,5641,5341, 37320,4814,4552, 4704,4966,4704, 4035,4297,4035, 36802,4296,4034, 37473,4967,4705, 4033,4295,4033, 37474,4968,4706, 
4032,4294,4032, 38110,5642,5342, 37475,4969,4707, 4830,5092,4830, 4831,5093,4831, 4031,4293,4031, 37600,5094,4832, 4030,4292,4030, 38111,5643,5343, 37601,5095,4833, 4906,5168,4906, 4907,5169,4907, 4029,4291,4029, 36796,4290,4028, 37676,5170,4908, 4027,4289,4027, 
37677,5171,4909, 4026,4288,4026, 37678,5172,4910, 4025,4287,4025, 37679,5173,4911, 4024,4286,4024, 37680,5174,4912, 4023,4285,4023, 37681,5175,4913, 4022,4284,4022, 
1, // chain 405
4041,4303,4041, 5236,5501,5236, 4040,4302,4040, 
3, // chain 406
5340,5640,5340, 4036,4298,4036, 4037,4299,4037, 
5339,5639,5339, 36806,4300,4038, 
2, // chain 407
4036,4298,4036, 5340,5640,5340, 5341,5641,5341, 
4035,4297,4035, 
2, // chain 408
3862,4124,3862, 5294,5644,5294, 4421,4683,4421, 
3861,4123,3861, 
1, // chain 409
3863,4125,3863, 5294,5644,5294, 3862,4124,3862, 
2, // chain 410
5308,5598,5308, 3260,3452,3260, 5120,5382,5120, 
5121,5383,5121, 
1, // chain 411
3258,3450,3258, 3260,3452,3260, 5308,5598,5308, 
3, // chain 412
5147,5409,5147, 3282,3474,3282, 3284,3476,3284, 
5170,5645,5170, 36054,3478,3286, 
2, // chain 413
5146,5408,5146, 5147,5409,5147, 5145,5407,5145, 
37938,5645,5170, 
3, // chain 414
5231,5496,5231, 5232,5497,5232, 5319,5609,5319, 
5230,5495,5230, 37997,5494,5229, 
3, // chain 415
4055,4317,4055, 4056,4318,4056, 5266,5531,5266, 
4053,4315,4053, 36820,4314,4052, 
1, // chain 416
279,285,279, 72,72,72, 73,73,73, 
1, // chain 417
311,317,311, 111,111,111, 112,112,112, 
1, // chain 418
324,330,324, 301,307,301, 302,308,302, 
1, // chain 419
473,480,473, 479,486,479, 465,472,465, 
1, // chain 420
478,5646,478, 479,915,479, 569,916,569, 
1, // chain 421
769,834,769, 770,835,770, 830,895,830, 
1, // chain 422
1258,1410,1258, 1259,1411,1259, 1440,1592,1440, 
1, // chain 423
1458,1610,1458, 1459,1611,1459, 1499,1651,1499, 
1, // chain 424
1487,1639,1487, 1488,1640,1488, 1535,1687,1535, 
1, // chain 425
1454,1606,1454, 1455,1607,1455, 1711,1864,1711, 
1, // chain 426
1840,1993,1840, 1841,1994,1841, 1839,1992,1839, 
1, // chain 427
1899,2052,1899, 1900,2053,1900, 1948,2101,1948, 
1, // chain 428
2256,2431,2256, 2257,2432,2257, 2255,2430,2255, 
1, // chain 429
812,877,812, 813,878,813, 2241,2416,2241, 
1, // chain 430
810,875,810, 811,876,811, 2509,2684,2509, 
1, // chain 431
808,873,808, 809,874,809, 2550,2725,2550, 
1, // chain 432
806,871,806, 807,872,807, 2653,2828,2653, 
1, // chain 433
452,459,452, 453,460,453, 2933,3112,2933, 
1, // chain 434
2768,2943,2768, 2769,2944,2769, 2927,3106,2927, 
1, // chain 435
3011,3190,3011, 2964,3143,2964, 2965,3144,2965, 
2, // chain 436
2938,3117,2938, 3010,3189,3010, 797,862,797, 
33564,861,796, 
1, // chain 437
3008,3187,3008, 3009,3188,3009, 3024,3203,3024, 
1, // chain 438
3063,3242,3063, 3070,3249,3070, 3062,3241,3062, 
2, // chain 439
3083,3262,3083, 3095,3274,3095, 3072,3251,3072, 
35839,3250,3071, 
1, // chain 440
3071,3250,3071, 3051,3230,3051, 3052,3231,3052, 
1, // chain 441
3049,3291,3049, 3050,3300,3050, 3108,3290,3108, 
1, // chain 442
3174,3362,3174, 3175,3363,3175, 3201,3389,3201, 
1, // chain 443
2413,2588,2413, 3616,3847,3616, 2412,2587,2412, 
1, // chain 444
3609,3840,3609, 3730,3992,3730, 3608,3839,3608, 
1, // chain 445
3602,3833,3602, 3603,3834,3603, 3753,4015,3753, 
1, // chain 446
3600,3831,3600, 3601,3832,3601, 3784,4046,3784, 
1, // chain 447
3598,3829,3598, 3599,3830,3599, 3597,3828,3597, 
1, // chain 448
2373,2548,2373, 2374,2549,2374, 3899,4161,3899, 
1, // chain 449
2371,2546,2371, 2372,2547,2372, 3969,4231,3969, 
1, // chain 450
2369,2544,2369, 2370,2545,2370, 4125,4387,4125, 
1, // chain 451
2367,2542,2367, 2368,2543,2368, 4079,4341,4079, 
1, // chain 452
3840,4102,3840, 3841,4103,3841, 4256,4518,4256, 
1, // chain 453
3836,4098,3836, 3837,4099,3837, 4295,4557,4295, 
1, // chain 454
3834,4096,3834, 3835,4097,3835, 4341,4603,4341, 
1, // chain 455
3832,4094,3832, 3833,4095,3833, 4402,4664,4402, 
1, // chain 456
4414,4676,4414, 4415,4677,4415, 4560,4822,4560, 
1, // chain 457
4411,4673,4411, 4412,4674,4412, 4589,4851,4589, 
1, // chain 458
3571,3802,3571, 3572,3803,3572, 4794,5056,4794, 
1, // chain 459
4694,4956,4694, 4833,5095,4833, 4693,4955,4693, 
1, // chain 460
3548,3779,3548, 3549,3780,3549, 5011,5273,5011, 
1, // chain 461
3552,3783,3552, 3553,3784,3553, 5019,5281,5019, 
1, // chain 462
3142,5586,3142, 3084,3263,3084, 3085,3264,3085, 
1, // chain 463
3069,5587,3069, 3070,3283,3070, 3102,3284,3102, 
2, // chain 464
5224,5489,5224, 3242,3430,3242, 3244,3432,3244, 
36011,3431,3243, 
1, // chain 465
3247,3435,3247, 3248,3436,3248, 5309,5599,5309, 
2, // chain 466
2330,2505,2330, 2331,2506,2331, 2329,2504,2329, 
36467,5611,3699, 
1, // chain 467
3703,5626,3703, 3701,5612,3701, 5321,5613,5321, 
1, // chain 468
3707,5636,3707, 3705,5629,3705, 5334,5630,5334, 
1, // chain 469
3711,5638,3711, 3709,5637,3709, 5337,5633,5337, 
1, // chain 470
4032,4294,4032, 5342,5642,5342, 4031,4293,4031, 
1, // chain 471
4029,4291,4029, 4030,4292,4030, 5343,5643,5343, 
1, // chain 472
5294,5644,5294, 3088,3267,3088, 4421,4683,4421, 
1, // chain 473
4054,4316,4054, 4055,4317,4055, 4053,4315,4053, 

 0};


// mesh info for object bob (with tag [ | o Mesh | usemtl feathers | g Default])
const tgx::Mesh3D<tgx::RGB565> bob = 
    {
    1, // version/id
    
    5344, // number of vertices
    5647, // number of texture coords
    5344, // number of normal vectors
    10688, // number of triangles
    35383, // size of face
    
    bob_vert_array, // array of vertices
    bob_tex_array, // array of texture coords
    bob_norm_array, // array of normal vectors        
    bob_face, // array of face vertex indexes   
    
    &bob_texture, // pointer to texture image 
    
    { 0.75f , 0.75f, 0.75f }, // default color
    
    0.1f, // ambiant light strength 
    0.7f, // diffuse light strength
    0.6f, // specular light strength
    32, // specular exponent
    
    nullptr, // next mesh to draw after this one    
    
    { // mesh bounding box
    -1.0f, 1.0f, 
    -0.5239994892178083f, 0.5239994892178083f, 
    -0.788369683460517f, 0.788369683460517f
    },
    
    "bob" // model name    
    };
    
                
/** end of bob.h */
    
    
    