// 3D model [blub]
//
// - vertices   : 7106
// - textures   : 7317
// - normals    : 7106
// - triangles  : 14208
//
// - memory size: 321kb
//
// - model bounding box: [-0.49,0.49]x[-0.6,0.6]x[-1.0,1.0]
//
// object [blub] (tagged []) with 14208 triangles (1082 chains)

#pragma once

#include <tgx.h>

#include "blub_texture.h" // texture for object [blub]


// vertex array: 83kb.
const tgx::fVec3 blub_vert_array[7106] PROGMEM = {
{0.1379455471588342,-0.41132106352969,0.5916924035460159},
{0.10643067822264585,-0.42624810970615595,0.5557157878304618},
{0.14094869885203545,-0.418134717520127,0.5555418017122159},
{0.1706191773963837,-0.4014513055491944,0.5909854559983605},
{0.17464561503405107,-0.4081074780333929,0.5547908418658739},
{0.14343470603566785,-0.42394434094677325,0.5216640224902847},
{0.10824618554347279,-0.4322826084714047,0.5215505532827329},
{0.07129579771947524,-0.43227160539673304,0.5555424894043829},
{0.06993966876619084,-0.4249745038129092,0.5919110896551154},
{0.10430502173451094,-0.4191999526867789,0.5919454742634644},
{0.13456485246596095,-0.40352400974047187,0.6291901943349294},
{0.16606046602147387,-0.3938811901750795,0.6286819898235313},
{0.19575432609949944,-0.3821230295040571,0.6280995145580992},
{0.20168704642403512,-0.3894689572317364,0.590008933121249},
{0.20728417297108462,-0.39603848050289553,0.5532820452515199},
{0.17785644976168027,-0.4138091337898234,0.5211592564397214},
{0.06677037064544723,-0.40731594434919904,0.6672910911542844},
{0.03435634420093265,-0.42002587097932176,0.6293531773785036},
{0.06842660846040165,-0.416660993206289,0.6294233219795357},
{0.09934469813408485,-0.40206541465430745,0.6672498296242656},
{0.10192491914459346,-0.41113882510544036,0.6294026912145262},
{0.0350905243584004,-0.4285305600083623,0.591756358917545},
{0.0,-0.4211695030530093,0.6292954112364774},
{0.0,-0.41155556655863024,0.6672580819302694},
{0.03354727436648078,-0.41048895600764435,0.6672780250031118},
{0.06498333378033325,-0.39692491570613264,0.7047276773403368},
{0.09662074946067742,-0.3919790336412131,0.704649968125468},
{0.12723267858162116,-0.38505809967272725,0.7045227450745767},
{0.13094690397547964,-0.3947634992253148,0.6671081650378677},
{0.2558414291893691,-0.3585571943259895,0.5886039780241091},
{0.23862711886552798,-0.3817970634169085,0.5508366119057394},
{0.266011020954668,-0.3647876853588274,0.5497376798229054},
{0.27643574651391645,-0.3391505213738164,0.5897778685531437},
{0.2867710720914576,-0.34441686798854854,0.5522670116130576},
{0.2995710863954546,-0.34731755354886973,0.518744081549288},
{0.2799010273433282,-0.3709459687141325,0.5089644112426666},
{0.24475101761248408,-0.388116266739287,0.5160999051672501},
{0.21160012901105052,-0.4018687346945512,0.5194874767817932},
{0.23050960052649713,-0.37525023398725976,0.588948511799766},
{0.24710980174522515,-0.3519085864556277,0.6275940608153691},
{0.2674565498896598,-0.33327763026780793,0.6281125807092719},
{0.29296992928461446,-0.3176085642431707,0.5915968143348056},
{0.3024807119539466,-0.3218158649207538,0.555984675467751},
{0.3133586266512348,-0.32457282281817623,0.5238907697269656},
{0.1897507734817648,-0.37404195884987607,0.6664968067014226},
{0.21593327735519094,-0.36052605700005297,0.6662568021351467},
{0.22299037437273878,-0.3681615031300309,0.627662830032067},
{0.16125212238995032,-0.3854383934410672,0.6668193343277362},
{0.15647816336677578,-0.3761634891850091,0.7043363804973252},
{0.18394046236295156,-0.3652670067992124,0.7041458897670717},
{0.20920352180912552,-0.3523397694443241,0.7040056005650078},
{0.23185266332860888,-0.3373528940493309,0.7039705282644919},
{0.23928936642232962,-0.34484117405557513,0.6662134775286268},
{0.22453149251894075,-0.32941555105804876,0.7401603285518096},
{0.24366377629648883,-0.31326716359302653,0.7402249716155057},
{0.2514704577760448,-0.3202781852353867,0.7040956882388821},
{0.2593094607874488,-0.3269391715647541,0.6664816774737491},
{0.28431944951617416,-0.3126227960325664,0.6289687574571619},
{0.3061192912094373,-0.2945082966621485,0.5931908847778651},
{0.3147133802201853,-0.29811524207795814,0.558447988809873},
{0.3240357352357649,-0.3009031461228947,0.5268595368118179},
{0.20257279393510524,-0.34357857123700003,0.7402022777739954},
{0.17815009431698067,-0.3557809810478916,0.740319873134549},
{0.1958093414728578,-0.3342177054600695,0.7741405739066209},
{0.21705627866386915,-0.32099819893421466,0.7740786816115928},
{0.23561365178982202,-0.30587791125882735,0.7741405739066209},
{0.25153166237890595,-0.28909203315501475,0.7742946169520244},
{0.26003703910011355,-0.29538304109854696,0.7403638854332357},
{0.26816280974514817,-0.30138728140844856,0.7043198758853176},
{0.27617029733746223,-0.30712676023406293,0.6669314281509539},
{0.29798664364273286,-0.29029962060023146,0.6299115834180914},
{0.31629713528074,-0.27016330625889273,0.5943455199262243},
{0.32398484601540845,-0.2733885825220285,0.559850193138345},
{0.3320294689847394,-0.2762390665541602,0.5282335457614437},
{0.16594011989225238,-0.33461037768741503,0.8053439182911675},
{0.14658915000560468,-0.35508159811407297,0.7745105522924562},
{0.1722077463021073,-0.34556806467607293,0.7742946169520244},
{0.18868347523861198,-0.3242317275033542,0.8051128537230623},
{0.1516271828208995,-0.36604753740873464,0.7404835438702901},
{0.12336578552669311,-0.3744023095453735,0.740662343833705},
{0.1192891463608362,-0.3627920026902517,0.7747574337804021},
{0.14125334648200755,-0.34325741899502044,0.805667821301815},
{0.15917460435350403,-0.3228927908542443,0.832742949607981},
{0.18096619374076342,-0.3135972558331769,0.8324121696756637},
{0.2005716097291937,-0.3026086226970049,0.8322801327796036},
{0.20915950951043882,-0.3120726422989824,0.8050200152805199},
{0.22704431969708536,-0.29808429593044405,0.8051128537230623},
{0.2423853565580732,-0.28249156373634154,0.8053439182911675},
{0.2552321339294249,-0.26552069643961135,0.805667821301815},
{0.2648605119593106,-0.27087575534388386,0.7745105522924562},
{0.2737172993778449,-0.2760135035233908,0.7405447484731513},
{0.2820356238296339,-0.2809518209744735,0.7045818866009369},
{0.2900479252671168,-0.28570858769347357,0.6674341311250163},
{0.30874765067163457,-0.2666636408211319,0.6306900509511126},
{0.32391607679871043,-0.24488580527721215,0.5948475352081196},
{0.3308143169256859,-0.2477074062383307,0.5603845299520884},
{0.3377668847338528,-0.2505118148952748,0.528597334917776},
{0.09372831620635991,-0.3808707420679866,0.7408260145694462},
{0.06305868971260657,-0.3854693395885813,0.7409614899263413},
{0.09064332914528804,-0.3687315999364572,0.7750043152683478},
{0.05876886597498588,-0.3592950880211589,0.8067323687762998},
{0.030662887110516943,-0.37542559548983967,0.775374293654183},
{0.06098949275138071,-0.37293133600020356,0.7752202506087794},
{0.08734309443595145,-0.35555060417195333,0.8064084657656524},
{0.03170130228265661,-0.38821460671916513,0.7410536406767166},
{0.0,-0.3891237357639125,0.7410894006693995},
{0.0,-0.3762466999372137,0.775436185949211},
{0.0,-0.3622219058838254,0.8070562717869475},
{0.029546418877425058,-0.3615025798771644,0.8069641210365721},
{0.056389863692535576,-0.3445413402707719,0.8347262538175511},
{0.08380423054467283,-0.341320190160638,0.8342634369891737},
{0.11028106666556636,-0.3366844572630264,0.8337346017127661},
{0.11494637032635806,-0.350220989877859,0.8060384873798171},
{0.1355083661190574,-0.3305653723612392,0.8332057664363586},
{0.15208174734327323,-0.3107082610396943,0.8567337785452422},
{0.17283148309755808,-0.3025852411633275,0.8562682109481968},
{0.19146175159321083,-0.2928509585397269,0.8560811586787782},
{0.20766996827676032,-0.28140707318901426,0.8562682109481968},
{0.21767864007498594,-0.2898581222290304,0.8324121696756637},
{0.23233748630632972,-0.27556031438535106,0.832742949607981},
{0.2445997253357485,-0.2599318221985656,0.8332057664363586},
{0.2545169340757658,-0.24318858100910573,0.8337346017127661},
{0.2656327902628291,-0.24739725707102278,0.8060384873798171},
{0.2756504020592254,-0.25146426854654197,0.7747574337804021},
{0.284770575577713,-0.25540749543200475,0.7407373022799058},
{0.2931934292388829,-0.2592441300315857,0.7048225788593799},
{0.3011190814633264,-0.26298998926512523,0.6678584371920427},
{0.31689130131301063,-0.24206901816126244,0.6310552154917789},
{0.3290600142077202,-0.21884634137451783,0.5948550998219565},
{0.33528362831888836,-0.22120925166026079,0.5602593699776981},
{0.34131950246847104,-0.22383348496945615,0.528190221154924},
{0.10543008611969007,-0.3225118093937374,0.8581181028773727},
{0.1295137534994935,-0.3173176704565382,0.8573822722587042},
{0.08013401744950105,-0.3263883301390032,0.8588456811900375},
{0.0539282008116143,-0.3290393834427107,0.859477670291492},
{0.07644317358931986,-0.3111057471122086,0.8804302752350359},
{0.1005309671221252,-0.3080324508179755,0.8794592538952604},
{0.12342561474522036,-0.30382583783255934,0.8784552233314696},
{0.14483140882680404,-0.2983497451068983,0.877557785053561},
{0.04905913396174643,-0.29726594225173797,0.9003547803889448},
{0.025878887781704496,-0.3143007649199973,0.8818462334068475},
{0.05145938593215641,-0.3131585082306437,0.8812616950649147},
{0.07283966663434513,-0.2958224763932471,0.8992943590674618},
{0.02711570214401787,-0.3305571200552354,0.8599267332765299},
{0.0,-0.3146446110034873,0.8820766102827858},
{0.0,-0.29824590358968434,0.9013732524882421},
{0.024679415104058137,-0.29803203132575357,0.9010878602389454},
{0.04680309103875214,-0.28173166389182874,0.9170320031303746},
{0.06943215194695967,-0.28088717791077744,0.9157136972462742},
{0.09113502904467867,-0.27947259512329975,0.9141017468068733},
{0.09572056041410072,-0.29357578608372376,0.8980303808645528},
{0.11740280674681032,-0.29040208673311146,0.8966831919094391},
{0.13759551184584143,-0.2861122629954908,0.895458412160048},
{0.1560084696167285,-0.28051719952494225,0.8945602861899722},
{0.1644540171194088,-0.29146800959193037,0.8769079159557648},
{0.18199910737556724,-0.28304309285425944,0.8766445298558114},
{0.19717097196347805,-0.2729381441526566,0.8769079159557648},
{0.21006176163351645,-0.2613656603667187,0.877557785053561},
{0.22151940082756877,-0.2684633312221184,0.8567337785452422},
{0.2330733169249982,-0.2542301664421352,0.8573822722587042},
{0.24239635963274486,-0.23891663726782653,0.8581181028773727},
{0.24955179663017085,-0.22273386519445526,0.8588456811900375},
{0.26213862636240415,-0.22554583846523613,0.8342634369891737},
{0.2736361517021413,-0.2283461209691783,0.8064084657656524},
{0.28395290959117386,-0.23109482656059702,0.7750043152683478},
{0.29326426153208185,-0.23381602446533653,0.7409085376294837},
{0.3017421305666102,-0.2365351592935751,0.7049800603656184},
{0.3095598151208378,-0.23927767565549096,0.6680764356089754},
{0.3224966801660639,-0.216718621809882,0.6311040416356345},
{0.3318142213364747,-0.1922127802087696,0.5945243198896392},
{0.3374753032550533,-0.1940295941447138,0.5596823962496019},
{0.34275815448179303,-0.1963173396766059,0.5272522090391634},
{0.15341999630021613,-0.25587443841338414,0.9210020500103496},
{0.14766951439993012,-0.27000513706048734,0.909453635450256},
{0.16268871132677137,-0.2642539674680343,0.9089474940153589},
{0.16427659254032798,-0.2495978720053585,0.9217653883156973},
{0.17531130105168763,-0.2567787536129627,0.909453635450256},
{0.17235147396500608,-0.2734291563598803,0.8941923708806379},
{0.13054391636562943,-0.2742880838764382,0.9106777275074803},
{0.13992266213890145,-0.2602137759870274,0.9217653883156973},
{0.14495313034035948,-0.24864816912275925,0.9304468142316519},
{0.15340211630387465,-0.24341964557721096,0.931670906288876},
{0.1597605180797709,-0.2364113747035187,0.9342635057583903},
{0.17298896460379645,-0.24175405514878562,0.9235135018041603},
{0.1857525312229436,-0.24782775236755222,0.9106777275074803},
{0.18633363110404164,-0.26465970584655246,0.8945602861899722},
{0.11522488565398493,-0.24313631640441527,0.9432763992988291},
{0.10206864680749227,-0.25327564971436706,0.9371442482458692},
{0.1187933203084437,-0.2526636036857549,0.9342635057583903},
{0.12907431820479334,-0.24344784095605715,0.9395470446772969},
{0.1332520481191963,-0.2514250700930241,0.931670906288876},
{0.12412706075553986,-0.26307320001732987,0.9235135018041603},
{0.10637497515712045,-0.26491071348750017,0.9257038013559913},
{0.08700818835063222,-0.2660048317251652,0.9279786870443609},
{0.08357247828440059,-0.25345238660128083,0.9399644738226537},
{0.09903317358244294,-0.24266868573086892,0.9469693062355111},
{0.11410394742180767,-0.23456767200384557,0.9509001546619683},
{0.12880267979883628,-0.23609091015370604,0.9457692834041312},
{0.14185507712811496,-0.2387495280712504,0.9395470446772969},
{0.13867450085583288,-0.24360532246229555,0.9365610852882702},
{0.11160281101050175,-0.2773586294020035,0.9123247502473971},
{0.06636944611209794,-0.2666320069814509,0.9299778081737715},
{0.06379768371524318,-0.2533863681532508,0.9423755225600853},
{0.08106033879842299,-0.24209927661660952,0.9503630670795571},
{0.09761859079496527,-0.23330644456960442,0.9555035660277318},
{0.11461902885487563,-0.22667159054258224,0.957341767190069},
{0.13073096863504793,-0.22892309469727448,0.9509001546619683},
{0.14577285940339954,-0.2320507186726991,0.9432763992988291},
{0.041752267149151485,-0.24091300762856918,0.9553598383648331},
{0.02169201156148071,-0.2529820051590666,0.9454818280783336},
{0.04306445257296586,-0.25319106357782856,0.9442556729446083},
{0.06186451226464595,-0.2414810413584946,0.9531963588075142},
{0.044776462222662336,-0.2669187746150815,0.9315725663089979},
{0.022547294309553625,-0.2669902946004474,0.9326329876304809},
{0.0,-0.2669724146041059,0.9330297860108283},
{0.0,-0.2528740374888508,0.9459308910633715},
{0.02102887000486198,-0.24049351540671143,0.9567455380812975},
{0.04092511101070805,-0.23044839592363592,0.9651649532816325},
{0.060717097884039964,-0.23124749422166657,0.9627291476261898},
{0.0797042098451386,-0.232226080175279,0.9594791144450427},
{0.3374718647942184,-0.16630542197135212,0.558862667186562},
{0.3421543607591846,-0.16807636683975877,0.5260233031367701},
{0.3322625966293456,-0.16515477543756132,0.594013364609573},
{0.32564493490649793,-0.19081614618685006,0.6309348693625575},
{0.3264158378256824,-0.16456370402004208,0.6306467263445928},
{0.32488847352282,-0.1381643501756022,0.630337264869452},
{0.33049041391503836,-0.13784140305706677,0.5934790277958296},
{0.3353565236885882,-0.13817324203532125,0.5580099288995067},
{0.3395803289781788,-0.13922334109737788,0.5247428203218536},
{0.31544233391718396,-0.21480133604834198,0.668131450982334},
{0.30774430780001083,-0.21306697640321867,0.70506395880999},
{0.3188388455298977,-0.18978914670468228,0.6680688709951387},
{0.3039434331931129,-0.16554311520425488,0.7411567945017635},
{0.311265291694948,-0.1890810988495598,0.7050832141906653},
{0.3123669745464498,-0.16481842519869147,0.7050467665058154},
{0.30275647651290555,-0.1424270031957055,0.7411031545127391},
{0.31111399941821244,-0.14052063385962416,0.7049635557536109},
{0.31982086994434505,-0.1644718283465336,0.6679340833304106},
{0.3027942995820895,-0.18864131970877612,0.7411327252759192},
{0.29444021513761753,-0.16658517514487955,0.775436185949211},
{0.2932972707560969,-0.14473420353900143,0.775374293654183},
{0.2898182360833455,-0.12299415667965717,0.7752773290586388},
{0.2991763510916081,-0.1194125183355924,0.7410687699043902},
{0.30743690940137086,-0.11630133020295859,0.7049456757572693},
{0.3184606148380588,-0.1390785887731503,0.6677704125946694},
{0.27928966900688307,-0.20859340131858098,0.8067323687762998},
{0.2898182360833455,-0.21000055703065526,0.7752202506087794},
{0.28264354370524414,-0.1883641797654832,0.8069641210365721},
{0.2932972707560969,-0.1884192639080583,0.775374293654183},
{0.2992533726143099,-0.21147978288182903,0.7410453883707128},
{0.267517754492521,-0.20721966744582188,0.8347262538175511},
{0.2707038323021389,-0.18842559067599451,0.8350570337498684},
{0.2717491243959484,-0.16937947472696901,0.8351890706459285},
{0.28374522655674594,-0.1678841568790879,0.8070562717869475},
{0.3105521549177898,-0.05571200552354348,0.5935202893258484},
{0.3241553936728194,-0.08132888258962864,0.5570182767947218},
{0.31475189098153616,-0.0529385430141135,0.5572899152006788},
{0.2986014404400129,-0.028720087969581996,0.5946776752428756},
{0.3026010580831681,-0.024785113390122963,0.5583448349848261},
{0.30572868205859277,-0.02171938170972651,0.5237147205322187},
{0.318109891832899,-0.05100612802489996,0.5228977422378466},
{0.3277506483217904,-0.08048680353116174,0.522950006842537},
{0.3309711107397573,-0.10979404307291118,0.5573263628855288},
{0.3197644791866527,-0.08298580809675003,0.593054034036636},
{0.30547492364897716,-0.05927356325633244,0.6308207124628388},
{0.2937105737484518,-0.033476166996415056,0.6319643445365264},
{0.28378236193376283,-0.002144224176643367,0.5967043040589655},
{0.28754472577930995,0.002971517853520187,0.5603879684129234},
{0.2904144651921171,0.007172629301600462,0.5256313186015916},
{0.31467349407450046,-0.11372227826913384,0.6677098956839751},
{0.3209590004806968,-0.11173697975227952,0.6301612156747051},
{0.3083756092092984,-0.08851567834986888,0.6678831941100541},
{0.31452288948993185,-0.0854005016026666,0.6302705587292549},
{0.3263670116818268,-0.11040698310134038,0.5931001094118237},
{0.24807944770066684,0.05664864225497011,0.5682558544953404},
{0.26596563327164735,0.023881485882711353,0.5997782880453656},
{0.26942403717938934,0.030169743057575645,0.5636235600585638},
{0.25021541957130644,0.06296440711651362,0.5336835061847595},
{0.27197399973455083,0.035467035819821906,0.5288772256297369},
{0.2791253105789749,-0.008125770645034617,0.633855497995721},
{0.26161529262333244,0.016657967360754367,0.6366475281936596},
{0.24502128063410716,0.04922225454375405,0.604079114857658},
{0.2233527881447372,0.08224729547863031,0.5744897839890134},
{0.22494617089562963,0.08946187400241654,0.5402791617582638},
{0.27357288402277913,-0.014922232331297074,0.6711160349870265},
{0.2563888321542851,0.008557641325897994,0.6735346483382949},
{0.24107461528780946,0.040756076276064396,0.6404937904835782},
{0.22082070558591715,0.07374398183392371,0.6097842090749234},
{0.19580659070418988,0.10634884285477524,0.5818315855636909},
{0.19681405972881544,0.11433088583691103,0.5481546124545178},
{0.28790989031997627,-0.03900246125026563,0.6694552584037702},
{0.2994823741059142,-0.06357163929995689,0.6684216570767993},
{0.28118013477391085,-0.045251519971612066,0.7064008323825989},
{0.26712439457300846,-0.022483407707241193,0.7077610874888851},
{0.2503020687843459,-0.0003624137719984126,0.7097457670827891},
{0.23627108550145481,0.031323690513767946,0.6768424476614684},
{0.2173994370551921,0.0640502730481749,0.6455490156030476},
{0.1938576711029688,0.09685800325828547,0.616434880021786},
{0.16600269987944755,0.1283357368174569,0.5897881839356485},
{0.166466892092159,0.13694289197937748,0.5567975276091213},
{0.23064576357555913,0.02099799262656459,0.7124649019110276},
{0.24337219481768937,-0.010045119483075557,0.7445842522619914},
{0.21313780869641757,0.053263821409095,0.6811694067761059},
{0.19103056860451442,0.08599177932783592,0.6513985251753787},
{0.16462662785332074,0.11797565432190459,0.6235710616385366},
{0.13450227247876578,0.14759111749289439,0.5978651284368275},
{0.1345524740069553,0.1566693417891962,0.5656990150185093},
{0.22422959565763656,0.00985050259982024,0.7467037195206235},
{0.21705627866386915,-0.0020451965045982564,0.7789000913942888},
{0.2022929032231444,0.02880948795128938,0.7495232574052412},
{0.20808533434561619,0.041483654588729144,0.7160319611811525},
{0.1873892385803558,0.07388083257515271,0.6861558626788773},
{0.1624108836913115,0.10603319215013146,0.6576283285160497},
{0.1336213388128645,0.13650689514551223,0.6307333755576323},
{0.1018692160790681,0.16349881269947372,0.6055686560913366},
{0.10171861149449948,0.1728809969335806,0.5743467440182816},
{0.2423853565580732,-0.04925732684427004,0.8067502487726413},
{0.2648605119593106,-0.05971850008836844,0.7756583105191457},
{0.25153166237890595,-0.03970115649191721,0.7763033657717727},
{0.22704431969708536,-0.03147085663750164,0.8073629824934204},
{0.23561365178982202,-0.02043408504964107,0.7773548470950851},
{0.2597770914609951,-0.030759782936844424,0.7430658279572998},
{0.2735034271139141,-0.05217314163226488,0.7420521697031713},
{0.28460690484197176,-0.07416622482444937,0.7414456252118952},
{0.2756504020592254,-0.08035854894201998,0.7753316567398302},
{0.2552321339294249,-0.06783808150390025,0.8064717334450145},
{0.23233748630632972,-0.059378092465713385,0.8336802740315746},
{0.21767864007498594,-0.04309973118113193,0.8339127139840139},
{0.2005716097291937,-0.027792391236326104,0.8345302615499618},
{0.20915950951043882,-0.014616897009157994,0.8083952084360573},
{0.29253874629591803,-0.06855328135755935,0.7055529079407126},
{0.301268310663561,-0.09227425988849759,0.7051052203400087},
{0.2931452907871943,-0.09661909899947667,0.7411506052722607},
{0.28395290959117386,-0.10149297969451339,0.775234004452119},
{0.2656327902628291,-0.08707778279793059,0.8064400996053335},
{0.2445997253357485,-0.0764831285042214,0.8337414786344358},
{0.22151940082756877,-0.06977599803044963,0.8573196922715091},
{0.20766996827676032,-0.05499680566988438,0.8572055353717905},
{0.19146175159321083,-0.04122783310261261,0.8574874891602522},
{0.18096619374076342,-0.01359980029419472,0.8356271305562948},
{0.18868347523861198,0.0011690766838658526,0.8099342635057584},
{0.1958093414728578,0.015338286092319915,0.7810284986510917},
{0.17791421590370657,0.04645635664816087,0.7527904828905627},
{0.18299557332552113,0.060658575280629984,0.7201416095710245},
{0.15942767507095262,0.09267958565171552,0.6914407769821178},
{0.13198119299461744,0.12362710855014548,0.6638251226327055},
{0.10133556695749167,0.1518637489263406,0.6374610680271968},
{0.06838493431508266,0.1755348010059561,0.6121003562933116},
{0.0681956814307298,0.18508890828180796,0.5817710686529967},
{0.27928966900688307,-0.1269846967862082,0.8067729426141517},
{0.2736361517021413,-0.10683882352374842,0.8065693857327256},
{0.28264354370524414,-0.14737875815173102,0.8069641210365721},
{0.2707038323021389,-0.15029718616996035,0.8350570337498684},
{0.267517754492521,-0.13132252143708406,0.8347530738120632},
{0.26213862636240415,-0.11259934572967233,0.8343707169672224},
{0.2545169340757658,-0.09427159301827405,0.8340028016578882},
{0.24239635963274486,-0.10174054887462614,0.8582852120739488},
{0.2330733169249982,-0.08540909775475385,0.8577171783440234},
{0.24955179663017085,-0.1186148641911124,0.8589123873302345},
{0.25459326790630055,-0.1358839148114451,0.8594941749034996},
{0.23596368710281476,-0.12472569678689589,0.8804687859963868},
{0.2293666561449765,-0.10928501333091264,0.8795548431064705},
{0.22076293944389086,-0.09437206484386981,0.8786464017538901},
{0.21006176163351645,-0.08016489482779844,0.87789269113888},
{0.22565311844328498,-0.14518329403172597,0.9003595942341137},
{0.24335156405267996,-0.15659527734281248,0.8818462334068475},
{0.2406076723064301,-0.14054537771148426,0.8812713227552523},
{0.22146438545421035,-0.13077202385741665,0.8993136144481374},
{0.25757441345015847,-0.15339936553520675,0.8599267332765299},
{0.25855093632726994,-0.17101301870041308,0.8601055332399447},
{0.24424831463842178,-0.17272654127287695,0.8820766102827858},
{0.22813087332091359,-0.15979476514968652,0.9010878602389454},
{0.20981969399073955,-0.14967406829745986,0.9170340662068756},
{0.20614260397389797,-0.13659416328150195,0.915721949552278},
{0.20095259118970057,-0.12380233251429197,0.9141210021875488},
{0.21552066205500298,-0.11670541812027599,0.8980778316240744},
{0.2077779359469762,-0.10312796782150811,0.8967787811206493},
{0.19809591792806602,-0.0902571899935288,0.895626209048791},
{0.18633363110404164,-0.0783108767456206,0.8948277984429274},
{0.19717097196347805,-0.06684161555394635,0.8774436281538421},
{0.18199910737556724,-0.054580064216694556,0.8774477543068441},
{0.17283148309755808,-0.028623123374037825,0.8582769597679452},
{0.15917460435350403,-0.0007041967789874262,0.8370554671871121},
{0.16594011989225238,0.015642933722292016,0.8118130385059474},
{0.1722077463021073,0.031407588958139485,0.7835358242919005},
{0.15144494439664982,0.06242044261243252,0.7562557637199745},
{0.15574783428544314,0.07808469479190089,0.7244891994506714},
{0.12965541808589137,0.10916356689422402,0.6966637989903303},
{0.10018299488563336,0.13822612556296202,0.6695756045329917},
{0.06809053329839858,0.1635153173114812,0.643103582257267},
{0.034334200513155895,0.1831750609811029,0.6166590676682214},
{0.03421275407646724,0.19280481439532257,0.5870016552750459},
{0.16268871132677137,-0.0796635672380701,0.909108413982432},
{0.16427659254032798,-0.09875328287048211,0.9217922083102096},
{0.17531130105168763,-0.08908268054154382,0.9095609154283049},
{0.17235147396500608,-0.06750661387941592,0.8945946707983211},
{0.1857525312229436,-0.09976590958636004,0.9107444336476774},
{0.17298896460379645,-0.10838461797668586,0.9235300064161678},
{0.1597605180797709,-0.11580681076568333,0.9342635057583903},
{0.15340211630387465,-0.10691900843041827,0.931670906288876},
{0.15341999630021613,-0.09061877853492685,0.9210419361560346},
{0.14766951439993012,-0.07178921684928331,0.9096833246340273},
{0.1560084696167285,-0.05806184965811384,0.8951345091494004},
{0.1644540171194088,-0.043559109548674514,0.8780556741824543},
{0.16518847235374334,-0.12571611104578034,0.9371442482458692},
{0.14577285940339954,-0.12165157526206229,0.9432763992988291},
{0.14957579708679844,-0.1312084333065821,0.9469693062355111},
{0.16968597912579195,-0.1362289643562273,0.9399644738226537},
{0.15300325484702632,-0.14116056993176032,0.9503630670795571},
{0.1331530204471512,-0.13527699896639866,0.9555035660277318},
{0.13073096863504793,-0.12553799877453256,0.9509001546619683},
{0.12880267979883628,-0.11592956381748924,0.9457692834041312},
{0.14185507712811496,-0.11287827367259938,0.9395470446772969},
{0.18005156315868015,-0.1190430901034908,0.925713429046329},
{0.18567138354723997,-0.1303765320921865,0.9279835008895296},
{0.19005404572740295,-0.14203251546103915,0.9299798712502725},
{0.17325372608808373,-0.14692754956713217,0.9423755225600853},
{0.1557966604292987,-0.15111973477088503,0.9531963588075142},
{0.13563352609344773,-0.14497224130567984,0.9594791144450427},
{0.11595865319615249,-0.1381679536825572,0.9628082322253924},
{0.11461902885487563,-0.1279873519656649,0.957341767190069},
{0.11410394742180767,-0.11722772032109721,0.9509001546619683},
{0.11522488565398493,-0.10570344375606458,0.9432763992988291},
{0.12907431820479334,-0.10611488997956865,0.9395470446772969},
{0.13867450085583288,-0.10634746747044127,0.9365610852882702},
{0.14495313034035948,-0.09994003324303935,0.9304468142316519},
{0.19422764948880403,-0.11143267596839092,0.9123632610087481},
{0.19319198508533228,-0.15389409128013207,0.9315732540011649},
{0.17585251478710082,-0.15771992911269142,0.9442556729446083},
{0.15788311846391576,-0.16102793474351487,0.9553598383648331},
{0.13773786412440625,-0.15444940270496837,0.9627291476261898},
{0.11763043285408066,-0.14782713344460194,0.967341498990124},
{0.09803120609515321,-0.14012748918775988,0.9689458848156881},
{0.09741984775870807,-0.1295210430364635,0.9628082322253924},
{0.09761859079496527,-0.11792758463943268,0.9555035660277318},
{0.09903317358244294,-0.10520569216560452,0.9469693062355111},
{0.10206864680749227,-0.09121390733623128,0.9371442482458692},
{0.1187933203084437,-0.09322912046234921,0.9342635057583903},
{0.1332520481191963,-0.09575728317581743,0.931670906288876},
{0.13992266213890145,-0.08445072995085064,0.9218224667655567},
{0.17744314676932535,-0.16851422044247488,0.9454818280783336},
{0.1591924843498455,-0.17082734181532852,0.9567455380812975},
{0.13936769456014864,-0.16369459865941288,0.9651649532816325},
{0.11914060485276855,-0.15702274679380718,0.9709835167064497},
{0.09904899050228347,-0.1498884907151242,0.9739791037858141},
{0.07940918990550422,-0.14140178483625016,0.9739791037858141},
{0.07924208070892809,-0.13042013177557304,0.967341498990124},
{0.0797042098451386,-0.11822377365575093,0.9594791144450427},
{0.08106033879842299,-0.10466172766152342,0.9503630670795571},
{0.08357247828440059,-0.08958325166988851,0.9399644738226537},
{0.08700818835063222,-0.07320132394495987,0.9280962824049144},
{0.10637497515712045,-0.07609513258361132,0.9258014536437025},
{0.12412706075553986,-0.079769471831785,0.9235905233268621},
{0.13054391636562943,-0.06528880664090572,0.9109858135982873},
{0.19809591792806602,-0.25443234793922725,0.895458412160048},
{0.2077779359469762,-0.24296920720783916,0.8966831919094391},
{0.22076293944389086,-0.2485353876073745,0.8784552233314696},
{0.2293666561449765,-0.23465982275422084,0.8794592538952604},
{0.23596368710281476,-0.21994871191818663,0.8804302752350359},
{0.2406076723064301,-0.20459522782897643,0.8812616950649147},
{0.25459326790630055,-0.20588506325736394,0.859477670291492},
{0.25757441345015847,-0.1885765391066466,0.8599267332765299},
{0.24335156405267996,-0.18879048013979405,0.8818462334068475},
{0.22565311844328498,-0.20335559392877847,0.9003547803889448},
{0.22813087332091359,-0.18904059378092467,0.9010878602389454},
{0.22146438545421035,-0.217232327858616,0.8992943590674618},
{0.21552066205500298,-0.23049515899099055,0.8980303808645528},
{0.20614260397389797,-0.21462253608492723,0.9157136972462742},
{0.20981969399073955,-0.20217166309410586,0.9170320031303746},
{0.21200793046606958,-0.1893001288047429,0.9179260029474485},
{0.21273000724139848,-0.1761612198008581,0.9182670982622706},
{0.22894166238578292,-0.17446200122546746,0.9013732524882421},
{0.21200793046606958,-0.16290781005117116,0.9179260029474485},
{0.1950803877758591,-0.16584432437339208,0.9326329876304809},
{0.19571168918514667,-0.17776608701093913,0.9330297860108283},
{0.17798642358123948,-0.179218424098384,0.9459308910633715},
{0.15965255040955506,-0.1804600523058662,0.957243427210191},
{0.14042467742079676,-0.17269373835651197,0.9666964437374969},
{0.12037157383166258,-0.1657888276155168,0.9736689546185062},
{0.10006746260158073,-0.1589456028618997,0.9779684060464645},
{0.0799435267192476,-0.1513195093453927,0.9794194365187922},
{0.06013111538855639,-0.14223702135765562,0.9779684060464645},
{0.060193351529668065,-0.13096595304850497,0.9709835167064497},
{0.060717097884039964,-0.11831062917644049,0.9627291476261898},
{0.06186451226464595,-0.10411150515872278,0.9531963588075142},
{0.06379768371524318,-0.08820917395104594,0.9423755225600853},
{0.06636944611209794,-0.07086186396211092,0.9301139712228335},
{0.06943215194695967,-0.05232718467766836,0.9162576617503553},
{0.09113502904467867,-0.05572851013555101,0.9145728159412545},
{0.11160281101050175,-0.05999220157082645,0.9127153593982418},
{0.11740280674681032,-0.04304884196077542,0.8976590270943836},
{0.13759551184584143,-0.0499264513227415,0.8962286273870653},
{0.14483140882680404,-0.03382070077207199,0.8790982155075958},
{0.15208174734327323,-0.01730233492121456,0.8594288441476363},
{0.1950803877758591,-0.1895424027551699,0.9326329876304809},
{0.19319198508533228,-0.20104948701602804,0.9315725663089979},
{0.17744314676932535,-0.1897406644069102,0.9454818280783336},
{0.15788311846391576,-0.1990146058939345,0.9553598383648331},
{0.17325372608808373,-0.20989602782127428,0.9423755225600853},
{0.17585251478710082,-0.19999504861639772,0.9442556729446083},
{0.1591924843498455,-0.18986809376545158,0.9567455380812975},
{0.19005404572740295,-0.21216334889580704,0.9299778081737715},
{0.18567138354723997,-0.2227599974968005,0.9279786870443609},
{0.16968597912579195,-0.21935729665458392,0.9399644738226537},
{0.1557966604292987,-0.20786252208351472,0.9531963588075142},
{0.13936769456014864,-0.19811400423205758,0.9651649532816325},
{0.14042467742079676,-0.1898980771439319,0.9666964437374969},
{0.14080978503430552,-0.1814329304144927,0.967236969780743},
{0.19422764948880403,-0.23765197137275043,0.9123247502473971},
{0.20095259118970057,-0.22650035519300424,0.9141017468068733},
{0.18005156315868015,-0.23271640469033564,0.9257038013559913},
{0.16518847235374334,-0.22829316867232086,0.9371442482458692},
{0.15300325484702632,-0.21637477572639202,0.9503630670795571},
{0.13773786412440625,-0.2061055373660977,0.9627291476261898},
{0.11914060485276855,-0.20460664351894833,0.9709835167064497},
{0.12037157383166258,-0.19730073947538715,0.9736689546185062},
{0.12120436904587524,-0.18985248315326114,0.9753324819704305},
{0.121521395134853,-0.18216951749454488,0.9759087680063596},
{0.12120436904587524,-0.17415976051807977,0.9753324819704305},
{0.14957579708679844,-0.22451498790693322,0.9469693062355111},
{0.0,0.18589625888584238,0.6184450042258683},
{0.034205258231847155,0.17093070194802557,0.6470103614578798},
{2.9823902666801453e-19,0.19553976614340168,0.5890681702368206},
{0.0,0.1735796921752322,0.6485294734547384},
{0.033850477842902224,0.15638051107906467,0.677641545959499},
{0.0,0.15890640440838186,0.6789117133919108},
{-0.033850477842902224,0.15638051107906467,0.677641545959499},
{-0.034205258231847155,0.17093070194802557,0.6470103614578798},
{-0.034334200513155895,0.1831750609811029,0.6166590676682214},
{-0.03421275407646724,0.19280481439532257,0.5870016552750459},
{-0.06838493431508266,0.1755348010059561,0.6121003562933116},
{-0.0681956814307298,0.18508890828180796,0.5817710686529967},
{-0.1018692160790681,0.16349881269947372,0.6055686560913366},
{-0.10171861149449948,0.1728809969335806,0.5743467440182816},
{-0.13450227247876578,0.14759111749289439,0.5978651284368275},
{-0.1345524740069553,0.1566693417891962,0.5656990150185093},
{-0.16600269987944755,0.1283357368174569,0.5897881839356485},
{-0.166466892092159,0.13694289197937748,0.5567975276091213},
{-0.19580659070418988,0.10634884285477524,0.5818315855636909},
{-0.19681405972881544,0.11433088583691103,0.5481546124545178},
{-0.2233527881447372,0.08224729547863031,0.5744897839890134},
{-0.22494617089562963,0.08946187400241654,0.5402791617582638},
{-0.24807944770066684,0.05664864225497011,0.5682558544953404},
{-0.25021541957130644,0.06296440711651362,0.5336835061847595},
{-0.26942403717938934,0.030169743057575645,0.5636235600585638},
{-0.27197399973455083,0.035467035819821906,0.5288772256297369},
{-0.28754472577930995,0.002971517853520187,0.5603879684129234},
{-0.2904144651921171,0.007172629301600462,0.5256313186015916},
{-0.3026010580831681,-0.024785113390122963,0.5583448349848261},
{-0.30572868205859277,-0.02171938170972651,0.5237147205322187},
{-0.31475189098153616,-0.0529385430141135,0.5572899152006788},
{-0.318109891832899,-0.05100612802489996,0.5228977422378466},
{-0.3241553936728194,-0.08132888258962864,0.5570182767947218},
{-0.3277506483217904,-0.08048680353116174,0.522950006842537},
{-0.3309711107397573,-0.10979404307291118,0.5573263628855288},
{-0.3348435053320212,-0.10995963934671994,0.5236418251625188},
{-0.3353565236885882,-0.13817324203532125,0.5580099288995067},
{-0.3395803289781788,-0.13922334109737788,0.5247428203218536},
{-0.3374718647942184,-0.16630542197135212,0.558862667186562},
{-0.3421543607591846,-0.16807636683975877,0.5260233031367701},
{-0.3374753032550533,-0.1940295941447138,0.5596823962496019},
{-0.34275815448179303,-0.1963173396766059,0.5272522090391634},
{-0.33528362831888836,-0.22120925166026079,0.5602593699776981},
{-0.34131950246847104,-0.22383348496945615,0.528190221154924},
{-0.3308143169256859,-0.2477074062383307,0.5603845299520884},
{-0.3377668847338528,-0.2505118148952748,0.528597334917776},
{-0.32398484601540845,-0.2733885825220285,0.559850193138345},
{-0.3320294689847394,-0.2762390665541602,0.5282335457614437},
{-0.3147133802201853,-0.29811524207795814,0.558447988809873},
{-0.3240357352357649,-0.3009031461228947,0.5268595368118179},
{-0.3024807119539466,-0.3218158649207538,0.555984675467751},
{-0.3133586266512348,-0.32457282281817623,0.5238907697269656},
{-0.2867710720914576,-0.34441686798854854,0.5522670116130576},
{-0.2995710863954546,-0.34731755354886973,0.518744081549288},
{-0.266011020954668,-0.3647876853588274,0.5497376798229054},
{-0.2799010273433282,-0.3709459687141325,0.5089644112426666},
{-0.24475101761248408,-0.388116266739287,0.5160999051672501},
{-0.23862711886552798,-0.3817970634169085,0.5508366119057394},
{-0.21160012901105052,-0.4018687346945512,0.5194874767817932},
{-0.20728417297108462,-0.39603848050289553,0.5532820452515199},
{-0.17785644976168027,-0.4138091337898234,0.5211592564397214},
{-0.17464561503405107,-0.4081074780333929,0.5547908418658739},
{-0.14343470603566785,-0.42394434094677325,0.5216640224902847},
{-0.14094869885203545,-0.418134717520127,0.5555418017122159},
{-0.10824618554347279,-0.4322826084714047,0.5215505532827329},
{-0.10643067822264585,-0.42624810970615595,0.5557157878304618},
{-0.07129579771947524,-0.43227160539673304,0.5555424894043829},
{-0.07248344209184954,-0.4385681148776011,0.5211042410663629},
{-0.035750571300267715,-0.43602778001277726,0.5552536586942513},
{-0.036337379026351674,-0.44254366329491196,0.5206091027061374},
{0.0,-0.43733920897520806,0.5550803602681724},
{0.0,-0.44395411992938777,0.5203491550670191},
{0.036337379026351674,-0.44254366329491196,0.5206091027061374},
{0.035750571300267715,-0.43602778001277726,0.5552536586942513},
{0.07248344209184954,-0.4385681148776011,0.5211042410663629},
{0.06735889760194864,0.14931516175551307,0.674355065093502},
{0.09847407985068826,0.12283626255811857,0.7014645780080171},
{0.06623644644700404,0.13321903889518125,0.7054270602741554},
{0.0962720895320186,0.10594516755275801,0.7326809885437362},
{0.06476980536248597,0.11551234097978252,0.7358938863478663},
{0.03329434118746557,0.1398325744650271,0.7081372551042232},
{0.0,0.12376808544437634,0.738921107266912},
{0.03167606398012845,0.10197993451795186,0.7670621584318968},
{0.032561330106681684,0.12159635358105378,0.7380821228231964},
{0.0,0.142196860135104,0.7091791087371977},
{0.06300532480044893,0.09647839718211257,0.7653271110946065},
{0.030662887110516943,0.0812927787508622,0.7946606204771345},
{0.0,0.10393779411734366,0.7677257813730324},
{-0.03167606398012845,0.10197993451795186,0.7670621584318968},
{-0.032561330106681684,0.12159635358105378,0.7380821228231964},
{-0.03329434118746557,0.1398325744650271,0.7081372551042232},
{0.05876886597498588,0.05556896555281167,0.8193893431095651},
{0.09064332914528804,0.0686605613356082,0.7913060580866065},
{0.06098949275138071,0.07640191205930107,0.7933010530630152},
{0.029546418877425058,0.05984366006275879,0.8204642059665547},
{0.09364097930115346,0.08780316049566102,0.7627771485394449},
{0.12323649939930088,0.07632695361310024,0.7596680922525287},
{0.1192891463608362,0.05837612497842365,0.7888778170450005},
{0.08734309443595145,0.04876906540571431,0.81781934189235},
{0.056389863692535576,0.03426357452760704,0.8431642367063946},
{0.028351141121997277,0.037939976852281655,0.8440568611391346},
{0.0,0.06134901821627781,0.8208781966510766},
{0.0,0.08302576301165154,0.7951818911397053},
{-0.030662887110516943,0.0812927787508622,0.7946606204771345},
{-0.06300532480044893,0.09647839718211257,0.7653271110946065},
{-0.06476980536248597,0.11551234097978252,0.7358938863478663},
{-0.06623644644700404,0.13321903889518125,0.7054270602741554},
{0.12671622176421923,0.09332601628867664,0.7287707708822884},
{0.14658915000560468,0.0458560013863874,0.7862205745117901},
{0.11494637032635806,0.03968602726424366,0.8159226868958194},
{0.08380423054467283,0.02837830496259298,0.8418706877403054},
{0.08013401744950105,0.0077805491772107,0.8636003848325366},
{0.0539282008116143,0.012777320462486726,0.864750893827894},
{0.02711570214401787,0.01587881213556613,0.8655520552024255},
{0.0,0.03922664889670108,0.8444034579912925},
{-0.028351141121997277,0.037939976852281655,0.8440568611391346},
{-0.029546418877425058,0.05984366006275879,0.8204642059665547},
{-0.06098949275138071,0.07640191205930107,0.7933010530630152},
{-0.09364097930115346,0.08780316049566102,0.7627771485394449},
{-0.0962720895320186,0.10594516755275801,0.7326809885437362},
{-0.09847407985068826,0.12283626255811857,0.7014645780080171},
{-0.06735889760194864,0.14931516175551307,0.674355065093502},
{-0.06809053329839858,0.1635153173114812,0.643103582257267},
{-0.10133556695749167,0.1518637489263406,0.6374610680271968},
{-0.1336213388128645,0.13650689514551223,0.6307333755576323},
{-0.16462662785332074,0.11797565432190459,0.6235710616385366},
{-0.1938576711029688,0.09685800325828547,0.616434880021786},
{-0.22082070558591715,0.07374398183392371,0.6097842090749234},
{-0.24502128063410716,0.04922225454375405,0.604079114857658},
{-0.26596563327164735,0.023881485882711353,0.5997782880453656},
{-0.28378236193376283,-0.002144224176643367,0.5967043040589655},
{-0.2986014404400129,-0.028720087969581996,0.5946776752428756},
{-0.3105521549177898,-0.05571200552354348,0.5935202893258484},
{-0.3197644791866527,-0.08298580809675003,0.593054034036636},
{-0.3263670116818268,-0.11040698310134038,0.5931001094118237},
{-0.33049041391503836,-0.13784140305706677,0.5934790277958296},
{-0.3322625966293456,-0.16515477543756132,0.594013364609573},
{-0.3318142213364747,-0.1922127802087696,0.5945243198896392},
{-0.3290600142077202,-0.21884634137451783,0.5948550998219565},
{-0.32391607679871043,-0.24488580527721215,0.5948475352081196},
{-0.31629713528074,-0.27016330625889273,0.5943455199262243},
{-0.3061192912094373,-0.2945082966621485,0.5931908847778651},
{-0.29296992928461446,-0.3176085642431707,0.5915968143348056},
{-0.27643574651391645,-0.3391505213738164,0.5897778685531437},
{-0.2558414291893691,-0.3585571943259895,0.5886039780241091},
{-0.23050960052649713,-0.37525023398725976,0.588948511799766},
{-0.20168704642403512,-0.3894689572317364,0.590008933121249},
{-0.1706191773963837,-0.4014513055491944,0.5909854559983605},
{-0.1379455471588342,-0.41132106352969,0.5916924035460159},
{-0.10430502173451094,-0.4191999526867789,0.5919454742634644},
{-0.06993966876619084,-0.4249745038129092,0.5919110896551154},
{-0.0350905243584004,-0.4285305600083623,0.591756358917545},
{0.0,-0.42975396437341956,0.5916490789394961},
{0.11028106666556636,0.020467094273656082,0.8403240680567676},
{0.1295137534994935,-0.0073823754125293345,0.8607973515599265},
{0.1355083661190574,0.01071218088504607,0.8386701683951809},
{0.14125334648200755,0.028563294155510573,0.8138651119322156},
{0.12342561474522036,-0.025407474801239775,0.8804068937013585},
{0.10543008611969007,0.0010177844071302545,0.8622360035732485},
{0.0,0.01695505037688968,0.8658642674462345},
{0.025878887781704496,-0.0060461895320873685,0.8850605065953118},
{0.0,-0.005167318942687042,0.8853672173017847},
{-0.025878887781704496,-0.0060461895320873685,0.8850605065953118},
{-0.02711570214401787,0.01587881213556613,0.8655520552024255},
{-0.0539282008116143,0.012777320462486726,0.864750893827894},
{-0.056389863692535576,0.03426357452760704,0.8431642367063946},
{-0.05876886597498588,0.05556896555281167,0.8193893431095651},
{-0.09064332914528804,0.0686605613356082,0.7913060580866065},
{-0.12323649939930088,0.07632695361310024,0.7596680922525287},
{-0.12671622176421923,0.09332601628867664,0.7287707708822884},
{-0.12965541808589137,0.10916356689422402,0.6966637989903303},
{-0.10018299488563336,0.13822612556296202,0.6695756045329917},
{-0.13198119299461744,0.12362710855014548,0.6638251226327055},
{-0.1624108836913115,0.10603319215013146,0.6576283285160497},
{-0.19103056860451442,0.08599177932783592,0.6513985251753787},
{-0.2173994370551921,0.0640502730481749,0.6455490156030476},
{-0.24107461528780946,0.040756076276064396,0.6404937904835782},
{-0.26161529262333244,0.016657967360754367,0.6366475281936596},
{-0.2791253105789749,-0.008125770645034617,0.633855497995721},
{-0.2937105737484518,-0.033476166996415056,0.6319643445365264},
{-0.30547492364897716,-0.05927356325633244,0.6308207124628388},
{-0.31452288948993185,-0.0854005016026666,0.6302705587292549},
{-0.3209590004806968,-0.11173697975227952,0.6301612156747051},
{-0.32488847352282,-0.1381643501756022,0.630337264869452},
{-0.3264158378256824,-0.16456370402004208,0.6306467263445928},
{-0.32564493490649793,-0.19081614618685006,0.6309348693625575},
{-0.3224966801660639,-0.216718621809882,0.6311040416356345},
{-0.31689130131301063,-0.24206901816126244,0.6310552154917789},
{-0.30874765067163457,-0.2666636408211319,0.6306900509511126},
{-0.29798664364273286,-0.29029962060023146,0.6299115834180914},
{-0.28431944951617416,-0.3126227960325664,0.6289687574571619},
{-0.2674565498896598,-0.33327763026780793,0.6281125807092719},
{-0.24710980174522515,-0.3519085864556277,0.6275940608153691},
{-0.22299037437273878,-0.3681615031300309,0.627662830032067},
{-0.19575432609949944,-0.3821230295040571,0.6280995145580992},
{-0.16606046602147387,-0.3938811901750795,0.6286819898235313},
{-0.13456485246596095,-0.40352400974047187,0.6291901943349294},
{-0.10192491914459346,-0.41113882510544036,0.6294026912145262},
{-0.06842660846040165,-0.416660993206289,0.6294233219795357},
{-0.03435634420093265,-0.42002587097932176,0.6293531773785036},
{0.05145938593215641,-0.008596152087248888,0.8842751621406207},
{0.07283966663434513,-0.03286412096780294,0.9006532387894142},
{0.07644317358931986,-0.012730557395132102,0.8831473469867736},
{0.1005309671221252,-0.01836344393486455,0.8818125364906656},
{0.09572056041410072,-0.03737882004402606,0.8992070221622553},
{0.04905913396174643,-0.02956457395063333,0.9018615139267978},
{0.0,-0.04777603791659532,0.9189259073582374},
{0.022547294309553625,-0.0680450768461612,0.9327939075975542},
{0.023556001180079757,-0.0483034978086689,0.9185689951235747},
{0.0,-0.026843376045893833,0.9030188998438251},
{0.024679415104058137,-0.02753863282671051,0.9026956845253445},
{0.04680309103875214,-0.049836363648867135,0.9176344214686492},
{0.044776462222662336,-0.06912612893265362,0.9317231708935665},
{0.04306445257296586,-0.08715102201371396,0.9442556729446083},
{0.02169201156148071,-0.08646848753798639,0.9454818280783336},
{0.0,-0.0676682215386562,0.9331941444387366},
{-0.022547294309553625,-0.0680450768461612,0.9327939075975542},
{-0.023556001180079757,-0.0483034978086689,0.9185689951235747},
{-0.024679415104058137,-0.02753863282671051,0.9026956845253445},
{0.041752267149151485,-0.10362654464256855,0.9553598383648331},
{0.02102887000486198,-0.10327843486764333,0.9567455380812975},
{0.0,-0.08622112466552372,0.9459308910633715},
{-0.02169201156148071,-0.08646848753798639,0.9454818280783336},
{-0.04306445257296586,-0.08715102201371396,0.9442556729446083},
{-0.044776462222662336,-0.06912612893265362,0.9317231708935665},
{-0.04680309103875214,-0.049836363648867135,0.9176344214686492},
{-0.04905913396174643,-0.02956457395063333,0.9018615139267978},
{0.0,-0.11812268290720487,0.967236969780743},
{0.020354725373571577,-0.13134308343287676,0.9753324819704305},
{0.02059665547791511,-0.11817941751098072,0.9666964437374969},
{0.0,-0.1031385582808796,0.957243427210191},
{0.04092511101070805,-0.1182689550311215,0.9651649532816325},
{0.040491727407077314,-0.13124488099143203,0.9736689546185062},
{0.040360790818484336,-0.1427208815663427,0.9808732177597876},
{0.020262437084762875,-0.142941053090523,0.9826495266270968},
{0.0,-0.13134707204744525,0.9759087680063596},
{-0.020354725373571577,-0.13134308343287676,0.9753324819704305},
{-0.02059665547791511,-0.11817941751098072,0.9666964437374969},
{-0.02102887000486198,-0.10327843486764333,0.9567455380812975},
{0.060368094109297665,-0.15228324114819833,0.9836934433365723},
{0.0404409757251542,-0.1528637221063461,0.9867756796289763},
{0.06074226741735143,-0.1612640882336558,0.9881661931906096},
{0.04064109414574535,-0.16184003042350148,0.9913770279182389},
{0.020279148004420485,-0.15314485066420747,0.9886441392466607},
{0.02047747842537749,-0.17005643889614402,0.9966516268389748},
{0.0,-0.16219673635051393,0.9939613750817493},
{0.0,-0.17011709334527167,0.9973138743957763},
{0.02057781271253986,-0.17710741545340575,0.998657624890055},
{0.0,-0.17714523852258965,0.9993274370606936},
{-0.02057781271253986,-0.17710741545340575,0.998657624890055},
{-0.02047747842537749,-0.17005643889614402,0.9966516268389748},
{-0.020364421833125992,-0.1621261103649651,0.9933121936761203},
{0.0,-0.15321059403537074,0.9892747529637812},
{0.020364421833125992,-0.1621261103649651,0.9933121936761203},
{0.04088357440382247,-0.16981340848433332,0.9946703857059056},
{0.04109098236138361,-0.1769475270245829,0.9966516268389748},
{0.04118595264964353,-0.18340598801077473,0.9973138743957763},
{0.020624782087544587,-0.18345061923241177,0.9993274370606936},
{0.0,-0.18345460784698026,1.0},
{-0.020624782087544587,-0.18345061923241177,0.9993274370606936},
{-0.04118595264964353,-0.18340598801077473,0.9973138743957763},
{-0.04109098236138361,-0.1769475270245829,0.9966516268389748},
{-0.04088357440382247,-0.16981340848433332,0.9946703857059056},
{-0.04064109414574535,-0.16184003042350148,0.9913770279182389},
{-0.020279148004420485,-0.15314485066420747,0.9886441392466607},
{0.0,-0.14298521668148645,0.9832560711183731},
{0.06114676794996902,-0.16932700381462845,0.9913770279182389},
{0.061474865882835135,-0.17661922278406672,0.9933121936761203},
{0.061619831391634496,-0.1832881863425711,0.9939613750817493},
{0.061474865882835135,-0.18948119815230868,0.9933121936761203},
{0.04109098236138361,-0.18935239340943333,0.9966516268389748},
{0.02057781271253986,-0.1892575606596068,0.998657624890055},
{0.0,-0.18921870605217245,0.9993274370606936},
{-0.02057781271253986,-0.1892575606596068,0.998657624890055},
{-0.04109098236138361,-0.18935239340943333,0.9966516268389748},
{-0.061474865882835135,-0.18948119815230868,0.9933121936761203},
{-0.061619831391634496,-0.1832881863425711,0.9939613750817493},
{-0.061474865882835135,-0.17661922278406672,0.9933121936761203},
{-0.06114676794996902,-0.16932700381462845,0.9913770279182389},
{-0.06074226741735143,-0.1612640882336558,0.9881661931906096},
{-0.0404409757251542,-0.1528637221063461,0.9867756796289763},
{-0.020262437084762875,-0.142941053090523,0.9826495266270968},
{0.080580329665871,-0.16032408181061095,0.9836934433365723},
{0.10095871164998668,-0.16737973467460812,0.9808732177597876},
{0.08119581415531801,-0.16853608905338485,0.9867756796289763},
{0.10159620228877707,-0.1752716899828696,0.9826495266270968},
{0.08166482021319832,-0.17607608351058598,0.9886441392466607},
{0.10159620228877707,-0.18975318040434921,0.9826495266270968},
{0.08119581415531801,-0.19596531005632886,0.9867756796289763},
{0.10095871164998668,-0.19658210116089314,0.9808732177597876},
{0.10006746260158073,-0.2033478230072916,0.9779684060464645},
{0.080580329665871,-0.2023107832194859,0.9836934433365723},
{0.06074226741735143,-0.20147743785153965,0.9881661931906096},
{0.06114676794996902,-0.1954577932370977,0.9913770279182389},
{0.08166482021319832,-0.18962210627732287,0.9886441392466607},
{0.08186287555728854,-0.1830645488498692,0.9892747529637812},
{0.1018513360827266,-0.18270254769317099,0.9832560711183731},
{0.11763043285408066,-0.21186213972666984,0.967341498990124},
{0.13563352609344773,-0.21389702084876341,0.9594791144450427},
{0.1331530204471512,-0.2215138992902329,0.9555035660277318},
{0.11595865319615249,-0.21916061669482767,0.9628082322253924},
{0.09803120609515321,-0.2173237909168243,0.9689458848156881},
{0.09904899050228347,-0.21020892775725014,0.9739791037858141},
{0.0,-0.19474726969017403,0.9973138743957763},
{0.02047747842537749,-0.19483316244182985,0.9966516268389748},
{0.04088357440382247,-0.19507523008460675,0.9946703857059056},
{0.020364421833125992,-0.20048207220905293,0.9933121936761203},
{0.0,-0.20035017285142617,0.9939613750817493},
{-0.02047747842537749,-0.19483316244182985,0.9966516268389748},
{0.0404409757251542,-0.2070038008746069,0.9867756796289763},
{0.060368094109297665,-0.20779959825023603,0.9836934433365723},
{0.0799435267192476,-0.20887514879939262,0.9794194365187922},
{0.06013111538855639,-0.21468374068778845,0.9779684060464645},
{0.040360790818484336,-0.21378630240987967,0.9808732177597876},
{0.020262437084762875,-0.2132189563721212,0.9826495266270968},
{0.020279148004420485,-0.20650907512968153,0.9886441392466607},
{0.04064109414574535,-0.2008628473619097,0.9913770279182389},
{0.0,-0.22070173484102965,0.9759087680063596},
{0.020354725373571577,-0.22091629479712735,0.9753324819704305},
{0.040491727407077314,-0.22150358390772823,0.9736689546185062},
{0.02059665547791511,-0.22990649449605574,0.9666964437374969},
{0.0,-0.22969949915379478,0.967236969780743},
{-0.020354725373571577,-0.22091629479712735,0.9753324819704305},
{-0.020262437084762875,-0.2132189563721212,0.9826495266270968},
{0.0,-0.21301746256719611,0.9832560711183731},
{0.0,-0.20633708331871986,0.9892747529637812},
{0.07924208070892809,-0.2235714742538368,0.967341498990124},
{0.07940918990550422,-0.21587482352099766,0.9739791037858141},
{0.060193351529668065,-0.2224072114151398,0.9709835167064497},
{0.09741984775870807,-0.22494066935829382,0.9628082322253924},
{0.2381099743559591,-0.04870029618901631,0.016570630455547887},
{0.24152161519634643,-0.020556494255363482,0.04407900482691129},
{0.24947133664663418,-0.04749202105163262,0.04471718315786868},
{0.24390928240010065,-0.07603977336416945,0.01700869036591409},
{0.25568807383613257,-0.07573320019612981,0.04543307070369473},
{0.2601023698559766,-0.046943242702382655,0.07345446343162516},
{0.2515956177504351,-0.018979616116478557,0.07248963132135236},
{0.2411667660381848,0.007339050806009595,0.0716932837919896},
{0.23184028486960323,0.004644672895782302,0.04355567108783961},
{0.2307599204752778,-0.022771550725205775,0.016186898226373134},
{0.22610286912048985,-0.05058663580304222,-0.01077819933307617},
{0.23147168186810202,-0.0770206287019329,-0.010542320919802034},
{0.23541353336923088,-0.1045456452237372,-0.010284436357184557},
{0.24812345999935356,-0.10437372218199224,0.017476321039460438},
{0.26017251445700856,-0.10485214962256016,0.046190219779539625},
{0.2667165931179894,-0.07610097796703066,0.07453276474944964},
{0.2113676890586113,-0.0026400502290358824,-0.011132360799070814},
{0.19220445913354914,0.012238857495741471,-0.03732449236283465},
{0.20214367402290978,0.018047793230220762,-0.011222448472945177},
{0.21154786440636006,0.023186916794061638,0.015675255254140066},
{0.19177602691352064,0.03599518340406247,-0.011235514624117789},
{0.18326721173147822,0.028958029459357052,-0.03733893389834126},
{0.17415666590332834,0.02126963103252164,-0.06255866873799548},
{0.18172265512444133,0.005734664980445463,-0.062446574914777744},
{0.20029859593890267,-0.007297101583823836,-0.03728116775631489},
{0.2193779274195933,-0.025655043981352543,-0.010979693138001274},
{0.22189419305857278,0.0013299966509391407,0.015880187519900092},
{0.22042597028207067,0.027683048181776283,0.04318362962550347},
{0.19975531912698855,0.042383843635305854,0.015596170654937392},
{0.25165613466112935,-0.162358619086621,0.01840401777271633},
{0.2629232831249282,-0.13442004512636,0.0469508073162194},
{0.2639410675320585,-0.16400846136442251,0.04767907332105115},
{0.2509058625069543,-0.19117656565156424,0.018815945380737307},
{0.2632251799862324,-0.19318889047058085,0.048337194724850915},
{0.2754977343981559,-0.16622076706559688,0.07790520713631913},
{0.2743843607798154,-0.13619100374861,0.07681315197515505},
{0.27146717060748665,-0.1060005955414166,0.0756708952858014},
{0.2507174348532018,-0.13328546995851154,0.017949453250342633},
{0.23873027269057495,-0.161218494242985,-0.009761790310279838},
{0.23796418361655933,-0.18954150875535283,-0.009524536512671778},
{0.23546648566608833,-0.21745582781288447,-0.009316165786076868},
{0.2483586507204607,-0.2194968981644808,0.019172857615399875},
{0.2606532112817275,-0.221750465395674,0.04890660383911028},
{0.27483686222568815,-0.1956385875077967,0.07889273308810228},
{0.22213557300918277,-0.10534831952103615,-0.036906375525310904},
{0.22443108946256166,-0.13277252037116122,-0.036784654011755395},
{0.23785690363851048,-0.1327490700682672,-0.010019674872897314},
{0.21846879837484587,-0.07867555990177004,-0.03702190780936349},
{0.21353667015326594,-0.05316754450571781,-0.03712506163441047},
{0.20049665128299288,-0.05646090229338461,-0.062264336490528094},
{0.20499347036287452,-0.08100449819446422,-0.062232014958680026},
{0.20838379274608546,-0.10676193953948007,-0.062203819579833876},
{0.21053076769139675,-0.13331765395192618,-0.06217218574015281},
{0.2112996075340803,-0.16025620659373005,-0.06213092421013398},
{0.22524944314126777,-0.16053527207509047,-0.03665949403736512},
{0.19624671369105703,-0.13434609758764465,-0.08601172240067836},
{0.19696603969771803,-0.16032855180969632,-0.08601722393801421},
{0.2105527738407401,-0.18716230016525243,-0.06207315806810768},
{0.22448472945158612,-0.1882234779481191,-0.03653708483164268},
{0.22205992687081497,-0.2155646743536897,-0.036421552547590025},
{0.21789732618408555,-0.24228495350169413,-0.03632114949121097},
{0.23114502808878654,-0.24469944069996058,-0.00914424274433187},
{0.2439085947079337,-0.2470781679055441,0.01946237601769842},
{0.25610275221282147,-0.2494809643369719,0.04936735759098682},
{0.27226420582901634,-0.2242770464171582,0.07974615906732434},
{0.17983012628091263,-0.11134348229433362,-0.10808113942339766},
{0.1626605159479252,-0.09203356763005462,-0.12827315683026178},
{0.17699683455295537,-0.0876836395970399,-0.10805569481321936},
{0.19425103102248134,-0.10876690605230999,-0.08599109163566898},
{0.19113853627473026,-0.0840072372723653,-0.08597596240799538},
{0.17333556145595433,-0.06525304664822276,-0.10809489326673727},
{0.15938710123310082,-0.0707869055159101,-0.12837493527097477},
{0.14530591642202018,-0.07710191391606992,-0.14662490999828767},
{0.14822310659434895,-0.09705688383297606,-0.14643029311503233},
{0.16521529234825555,-0.11447200026957532,-0.12828897375010231},
{0.18166695205891595,-0.1358196843630492,-0.10812996556725318},
{0.1870673986462092,-0.06048390147021708,-0.08598902855916798},
{0.16901891772382144,-0.044464800132587044,-0.108239308621803},
{0.15556284509252552,-0.051134038767958225,-0.12866582905760732},
{0.14189702635030074,-0.05864845107654771,-0.14712073605068016},
{0.1282435860670816,-0.06678109864325212,-0.16388048185214757},
{0.13129143775113658,-0.08398426835398817,-0.16317903584182805},
{0.13387372183814614,-0.10256818639758648,-0.1628963943611993},
{0.15049936766705246,-0.11813272321284278,-0.1464289177306984},
{0.16688294585318184,-0.1377001235782824,-0.12835499219813237},
{0.1823360765373874,-0.16069942419534858,-0.10815953633043333},
{0.18219647502749048,-0.03861253979158801,-0.0860502331620292},
{0.19502812317116863,-0.033546311597447004,-0.06230559802054685},
{0.20744440524599092,-0.02923723247915089,-0.03721308623178391},
{0.18872473676863077,-0.012676229713940692,-0.06236473954690715},
{0.1766846223091465,-0.018809756151234522,-0.0861815823659224},
{0.16421607562963375,-0.025732065504054293,-0.10853157779276948},
{0.14693849762643046,-0.018216277811130856,-0.13008866415108875},
{0.15909758283080228,-0.009466770370645448,-0.10901296230965543},
{0.17068932199741566,-0.0014922920023464092,-0.08640439462802389},
{0.15383398698473805,0.0039170945831175745,-0.10972472370247964},
{0.14247468777056388,-0.005755295745454881,-0.1313608946600016},
{0.13021726258631394,-0.01609818593683273,-0.1514917074640045},
{0.13420312638612952,-0.02776625893398086,-0.14944719865157322},
{0.1513569197992764,-0.033476166996415056,-0.12921323202252333},
{0.13814635327159233,-0.04207644523666583,-0.1480257389424257},
{0.12484913753086876,-0.05131008796270509,-0.16514927390022552},
{0.11173209713789398,-0.060956345988932285,-0.18076469993583835},
{0.11482464881280263,-0.07530463043766793,-0.1792194556366345},
{0.11754240825670723,-0.09121995902730069,-0.17837290657908217},
{0.11980216471740321,-0.10838227982331812,-0.17804075126243094},
{0.13587146758322277,-0.12218082315377002,-0.16288470359436066},
{0.15198478274772906,-0.13994916373194036,-0.14651419155940393},
{0.16749499188179395,-0.16131607776147946,-0.12839969218898606},
{0.18166695205891595,-0.18556967387574366,-0.10812996556725318},
{0.19625152753622588,-0.18629780234214197,-0.08598696548266707},
{0.20822562354768007,-0.21376017010753443,-0.06200576423574362},
{0.24945208126595875,-0.27617029733746223,0.049699512907638126},
{0.26082926047647437,-0.27854764915871183,0.08093586651619959},
{0.2676408513904104,-0.25196903459710523,0.08043728969513918},
{0.23744910218349138,-0.27367672553999306,0.019672809820794293},
{0.22490834782644575,-0.27100985531644495,-0.009017019693440594},
{0.22887289316908493,-0.2990511911172178,0.01979040518134784},
{0.24057810154324996,-0.3016073429018821,0.0498845021005557},
{0.2516912069616453,-0.3038450932132348,0.08121369415165948},
{0.1993935930471571,-0.3682901015652561,0.04936116836148398},
{0.20494395652685193,-0.3451582001445529,0.01970031750747348},
{0.2156712666395716,-0.34787871035712536,0.04973458520815408},
{0.20894151109350617,-0.37037999806070804,0.08042834969696844},
{0.2258855583957242,-0.3499280330147256,0.08098881881305704},
{0.22935840383897274,-0.3255802918428018,0.049903069789064156},
{0.2180733753788324,-0.3229588093022744,0.019803471332520455},
{0.20632553009031462,-0.3197816714908272,-0.008928307403900193},
{0.19379577880794063,-0.3417183639253194,-0.008982635085091601},
{0.1893780443272617,-0.3654059206169424,0.019467189862867305},
{0.18040297385600687,-0.3866054070484321,0.048762188484044504},
{0.18911947207247723,-0.3888809804289686,0.07953022372689265},
{0.20404789363327713,-0.29277462470919213,-0.03618567413431593},
{0.21666566951302454,-0.2961243732545513,-0.008942061247239804},
{0.21191921817652917,-0.26811260821695865,-0.03624000181550737},
{0.19856905013894818,-0.2649299688681756,-0.06186891349451465},
{0.19110896551155013,-0.2889503685686169,-0.06181321042898928},
{0.19420633103162765,-0.31599798918810373,-0.036163667984972545},
{0.182316821156712,-0.3375103755555693,-0.03618017259698008},
{0.1789849526076943,-0.3616731275345754,-0.009113984288984764},
{0.1712690464941797,-0.38346059076883293,0.01909239763186324},
{0.159039128996609,-0.4027414160544487,0.048009853253368456},
{0.16677910433596788,-0.4053120093746196,0.07840172088087863},
{0.1574161754825364,-0.35144783270375113,-0.06177538735980537},
{0.15873104290580198,-0.32659257471259623,-0.08558672864148478},
{0.17059785893920731,-0.3324847211992801,-0.061759570439964835},
{0.16830096710149442,-0.3570380823291308,-0.036241377199841295},
{0.18180724126097988,-0.31156031163458237,-0.06177401197547144},
{0.1692190361444126,-0.30641912499424057,-0.08563074094017147},
{0.15653455412446815,-0.30052422773888876,-0.10760456875168055},
{0.1468071484225373,-0.3197851099516621,-0.10752961030547971},
{0.14641929004036064,-0.344847363285078,-0.08557503787464608},
{0.142196860135104,-0.3681731938968695,-0.061829027348829814},
{0.15208312272760718,-0.3743087834106643,-0.036354158715226036},
{0.16180158843136727,-0.3793832639108091,-0.009329919629416442},
{0.1438431951828539,-0.2938281691090054,-0.12756758466694035},
{0.16462937862198868,-0.2796678996987221,-0.10770978565322852},
{0.1349162631632877,-0.31201281308045514,-0.1274548031515557},
{0.12444133607584969,-0.3284060189569223,-0.127410103160702},
{0.13539764768017362,-0.3371850971605878,-0.10750003954229964},
{0.1322280744825632,-0.36091185230572864,-0.08560460863782623},
{0.12519504669085965,-0.38266355554730325,-0.06190948733236649},
{0.1339369895175083,-0.389312163417665,-0.036501324838959695},
{0.1425420816029279,-0.3948212653673411,-0.009604308804041452},
{0.15093467680875075,-0.3992713213798681,0.01862064080531501},
{0.15126958289406994,-0.2741058454521885,-0.12772506617317878},
{0.17114113575112144,-0.25747951193111523,-0.10782944409028303},
{0.15724012628778952,-0.25309960051962016,-0.12790455382876056},
{0.13794967331183608,-0.26785953749951,-0.14561469020499415},
{0.13123848545427913,-0.2862800598842339,-0.14538981486639174},
{0.12315053787842839,-0.30322685795511983,-0.14522889489931848},
{0.1136376921325953,-0.3184571763772239,-0.14516493952778933},
{0.10265318514942517,-0.3317289475077692,-0.14522889489931848},
{0.11237233854535225,-0.34275402832879115,-0.1274548031515557},
{0.12225860113785544,-0.3524601155735456,-0.10752961030547971},
{0.11639258695351683,-0.37479635715705306,-0.08566443785635353},
{0.10666380586725202,-0.3949202930393862,-0.06200645192791062},
{0.11413833203015668,-0.4020365315832942,-0.03666912172770281},
{0.12150351513851151,-0.40796031190965926,-0.009909644126180532},
{0.12869333674428649,-0.41278859861402517,0.01809730706624329},
{0.1356410907072845,-0.41661973167627026,0.04717568265482185},
{0.19029748875451383,-0.23710800686866934,-0.08585561627877394},
{0.20425282589903715,-0.23977487709221745,-0.06193561963471171},
{0.19404747414105528,-0.21198179816372437,-0.08592988703280777},
{0.17961075247964603,-0.21016629084289742,-0.10805500712105243},
{0.17611865165572205,-0.23422451361252258,-0.10794979021950446},
{0.18494724369541013,-0.2614041711280696,-0.08577515629523727},
{0.17793966051388485,-0.284598652535968,-0.08569675938820152},
{0.16688294585318184,-0.18491787923988007,-0.12835499219813237},
{0.16500073239215785,-0.20825161831159195,-0.12824221068274763},
{0.15198478274772906,-0.18428210783150714,-0.14651419155940393},
{0.15030200001512922,-0.20617602581321315,-0.14635395928449757},
{0.14743363598665601,-0.22756490266748913,-0.14612908394589516},
{0.16180158843136727,-0.23106319272091597,-0.1280847291765093},
{0.12957427041018774,-0.24297058259217308,-0.16213099297935069},
{0.14333223990278782,-0.24820735844372513,-0.14587188707544463},
{0.12480925138518395,-0.261150412718454,-0.16178508381935977},
{0.1331874050555002,-0.22384448804412782,-0.16247690213934154},
{0.13570023223364477,-0.20400119933513922,-0.1627794866928127},
{0.11923619406397876,-0.22001610575055067,-0.177523606752862},
{0.11612438700839466,-0.23755775754587424,-0.17708279607382785},
{0.1119872309318435,-0.25419784491028713,-0.17664267308696074},
{0.10676420892363109,-0.2697190571190237,-0.17625756547345198},
{0.11883870799146436,-0.2781536015470323,-0.16148249926588862},
{0.11161037562433852,-0.2937504598941367,-0.1612672516176239},
{0.10307130198694898,-0.30771061088382884,-0.1611812900967514},
{0.09316922247460524,-0.3198050530245045,-0.1612686270019579},
{0.08207399705255136,-0.330092927842524,-0.16148593772672354},
{0.0903806307375017,-0.3430868713376094,-0.14538981486639174},
{0.09890938899238656,-0.3550877873435758,-0.12756758466694035},
{0.10760525644384752,-0.3656307959555448,-0.10760456875168055},
{0.09914733048216161,-0.3865132562980568,-0.08574489783989013},
{0.08685964684256457,-0.4049447817574523,-0.0621096057529576},
{0.09296291482451127,-0.41247226021721445,-0.03684173246161477},
{0.09898228436208643,-0.41877289585108435,-0.010219793293488457},
{0.10486205238976466,-0.4239622209431148,0.0175670964055018},
{0.11054720353418758,-0.42815783085385917,0.04633050898160351},
{0.1159827224219968,-0.4314752578673703,0.07588201678106424},
{0.14228007088730857,-0.4195499879997717,0.0771494334448082},
{0.12138179362495606,-0.20178909994161492,-0.17790940205853772},
{0.10854533163610906,-0.1825588200302722,-0.19247059600217037},
{0.12262101490985386,-0.18309384453618255,-0.17818585430966366},
{0.13716570424147898,-0.18367123087957893,-0.1629961097254114},
{0.12301437482936638,-0.16414730641293576,-0.1782965727485474},
{0.10885960695641887,-0.16527072033691415,-0.19260607135906543},
{0.09537052510110794,-0.16641029502681653,-0.20639773776784748},
{0.09513189591916592,-0.18207482228315175,-0.20623819318510814},
{0.09433692377413713,-0.19750078912676158,-0.20584345788126168},
{0.10753167338198068,-0.19960161992766853,-0.19213431453251714},
{0.10575261374600364,-0.21619597576297728,-0.19166393309030297},
{0.09513602207216779,-0.26124944039049913,-0.19012556571276887},
{0.08961110320265119,-0.27401300700964626,-0.18979478578045156},
{0.10039686714956411,-0.28390477113948526,-0.17598386399099397},
{0.0928246886989483,-0.29653767624690625,-0.17587658401294515},
{0.08398715666108948,-0.3074011494086879,-0.17599005322049682},
{0.07404381561872696,-0.31657014907103104,-0.17626994393245768},
{0.06315228461653254,-0.32412032137230345,-0.1766605530833022},
{0.06995686107036535,-0.3386326891720805,-0.16178989766452861},
{0.07700433039757547,-0.35257427247326417,-0.14561469020499415},
{0.08425054276104278,-0.36543755445662346,-0.12772506617317878},
{0.09165354893858152,-0.37671845676376187,-0.10770978565322852},
{0.08072680809743772,-0.39607355280341155,-0.08583498551376449},
{0.06603619048797947,-0.4127390847780026,-0.06220863342500273},
{0.07068581476736406,-0.42060765855258675,-0.03700334012085504},
{0.07527478459762099,-0.42723082181277033,-0.010508624003620041},
{0.07975922521849699,-0.4327419868389473,0.017074708813944187},
{0.08409718740780626,-0.4372752536036788,0.04554585221907943},
{0.08824603425119606,-0.440965409771693,0.07470537548336159},
{0.09962252576954472,-0.24722327095277685,-0.1905925086941482},
{0.10313869581931301,-0.23213736788573855,-0.19112753320005862},
{0.08785404971601751,-0.24044606464718984,-0.20404101671160735},
{0.08407311818196198,-0.25301638976741564,-0.20349705220752626},
{0.0793548622243128,-0.26439700743876615,-0.20311400767051843},
{0.07362432339686921,-0.274398802315322,-0.2029702800076196},
{0.08298106302079787,-0.28530972623662526,-0.1896668750373933},
{0.07517644461774287,-0.29493604119001,-0.1898099150081251},
{0.06634455165565327,-0.3029834149280089,-0.19015651186028293},
{0.0566323439506127,-0.30954124743232936,-0.1906372086850019},
{0.046186368703404555,-0.31470168945334664,-0.19118461164991793},
{0.051470182699178,-0.330126624758706,-0.17710548991533823},
{0.056988087108591406,-0.3454855416160353,-0.16213649451668655},
{0.06270748532292993,-0.3602358509055874,-0.14587188707544463},
{0.06859591827191211,-0.3738356511997821,-0.12790455382876056},
{0.07462078934682309,-0.38574304107103924,-0.10782944409028303},
{0.06136758590478626,-0.40348962513212283,-0.08592438549547192},
{0.04444870813587972,-0.41830388979320404,-0.062292531869374244},
{0.04758300272532406,-0.4264330988990736,-0.03713812778558308},
{0.05067734239986686,-0.4333079574923718,-0.010749316262062984},
{0.05370263778084488,-0.43907769477333314,0.016664844282424172},
{0.056629937028028265,-0.44389222763435954,0.04489392004478248},
{0.059430425839620556,-0.4479000975835185,0.07372747722191618},
{0.06483713042563331,-0.2641762582531656,-0.21620285268464703},
{0.058937556863546056,-0.27150293060016956,-0.216411223411242},
{0.06680372371554576,-0.28283059597466265,-0.2031449538180325},
{0.05903039530608834,-0.28979691762616916,-0.20355894450255446},
{0.05044008860225879,-0.2954029841713894,-0.20413041669331472},
{0.04116896665311913,-0.29975194943537037,-0.2047802857911108},
{0.03135333004616478,-0.3029490303196599,-0.20542877950457278},
{0.03515337942246236,-0.3185534532806011,-0.19173201461483394},
{0.039155885372718836,-0.33466470536860643,-0.1775504267473742},
{0.04333746636325688,-0.3507092513164147,-0.16248377906101139},
{0.04767467209118248,-0.3661163066254326,-0.14612908394589516},
{0.05214425856125171,-0.38031233602839887,-0.1280847291765093},
{0.05672270670135386,-0.39272517964238635,-0.10794979021950446},
{0.041303272933330304,-0.40877110097452857,-0.08600140701817367},
{0.022351714657264536,-0.4216412598795576,-0.06235167339573454},
{0.023929211719099754,-0.4299362027976692,-0.03723165392029237},
{0.025486903246525947,-0.43697541981887567,-0.010914362382138174},
{0.027010278934819845,-0.442919143218083,0.016383578186129354},
{0.02848455340239138,-0.4479269175780307,0.044445544751911585},
{0.029895078806083872,-0.4521582874814581,0.07305422659044283},
{0.06972854727092802,-0.25537998774532555,-0.21635689573005054},
{0.07369515569006814,-0.24529154365573028,-0.21678395256574512},
{0.06083338662947627,-0.24728447555563807,-0.2299381283357368},
{0.05670352008989511,-0.25501482320465924,-0.22978202221383237},
{0.051645681740191275,-0.2613739126727225,-0.23002546524094325},
{0.04577574771050086,-0.2664841531655502,-0.2305687420528574},
{0.05215594932809037,-0.27747622476255707,-0.21689123254379394},
{0.044618361793473664,-0.2822102976400468,-0.2175507293319277},
{0.036450710695469964,-0.28582068151669127,-0.21829825071743483},
{0.02777905000828669,-0.2884242840608773,-0.21904233364210712},
{0.021129135522807655,-0.3050987560336391,-0.20599406246583027},
{0.02368012961621963,-0.3211886896644681,-0.19220996067088497},
{0.026367355527910332,-0.3378088339560386,-0.17793966051388488},
{0.029175615260989492,-0.35436433518391297,-0.16278705130664953},
{0.03208984835700026,-0.3702596519314866,-0.14635395928449757},
{0.035094856819052375,-0.38489855508998794,-0.12824221068274763},
{0.03817564895790567,-0.39768619093497937,-0.10805500712105243},
{0.020769059904176972,-0.41193104648180123,-0.08605642239153205},
{0.0,-0.4227539458057311,-0.062374367237244835},
{0.0,-0.43110803025020306,-0.03726810160514228},
{0.0,-0.43820776418210367,-0.010979005445834274},
{0.0,-0.44421613064500715,0.016274235131579575},
{0.0,-0.4492981757589886,0.04427224632583267},
{0.0,-0.4536175702597895,0.07279427895132444},
{0.05547708987930315,-0.23245439397471632,-0.24474620376731523},
{0.066662265436798,-0.22836606404202076,-0.23105769118358013},
{0.06412351226395825,-0.2383465404614002,-0.23039613131894546},
{0.05277026474085352,-0.24043162311168326,-0.24427307155643305},
{0.07682071658899184,-0.2340869751791266,-0.2173939355178563},
{0.07918844071990366,-0.22194370689459533,-0.21809813229684374},
{0.0685380145914524,-0.217506029341074,-0.23182446794976272},
{0.05751705992343235,-0.22350339272930578,-0.24543802208729698},
{0.047876165896107596,-0.2278853672173018,-0.2602433467502075},
{0.0456404098920392,-0.2351453334241087,-0.25977571607666117},
{0.042729752795296734,-0.24135931984493916,-0.25964642994926895},
{0.04930663437264251,-0.24728516324780503,-0.24412384235619838},
{0.04499604233157903,-0.25286165902984514,-0.24440442076032623},
{0.039944324442161304,-0.2572862704321939,-0.2450040883299327},
{0.03920986920782676,-0.2704686415810318,-0.2313086988245278},
{0.09290996252765382,-0.2124982549811263,-0.20529330414767774},
{0.09077399065701422,-0.22687652280834228,-0.20466612889139213},
{0.08088085114284121,-0.20903833815061695,-0.21880576753666603},
{0.06983926570981178,-0.2059316200170685,-0.23259674625328117},
{0.058980400085548904,-0.2137326624208552,-0.2462453726913314},
{0.04952435771270835,-0.2197203981187493,-0.2609413542996921},
{0.041292338627875326,-0.2245844448157982,-0.27666406031335383},
{0.03941961531875563,-0.23133345574253905,-0.27622737578732154},
{0.036952794746581995,-0.23711488379033915,-0.27614003888211514},
{0.03905651385459024,-0.24638634958556233,-0.2599634560382467},
{0.03471607597347984,-0.2503474564673666,-0.2606126374438757},
{0.03425738529810424,-0.2606848451214086,-0.24581418970263505},
{0.03206392236230511,-0.2734497871248897,-0.23214493249957535},
{0.06053740392080812,-0.19233697741412617,-0.24778236468453158},
{0.07107023468870581,-0.18129491059657984,-0.23376719832148096},
{0.070653493235516,-0.19380650680574552,-0.2332775614985913},
{0.05995719803952717,-0.2032929451723666,-0.2470616632935366},
{0.08198184630217606,-0.19554843106470565,-0.21942812894778288},
{0.08257532464227972,-0.18165058498534184,-0.21987512885631977},
{0.07117751466675469,-0.16856105227904622,-0.23396800443423907},
{0.06086880277607574,-0.16948379762869986,-0.24851819530320002},
{0.060811242941699525,-0.18101653280738636,-0.2483029476549353},
{0.051818980166270213,-0.19120166641565903,-0.2633324599642813},
{0.0514082216349331,-0.2012374332852636,-0.26259387857694483},
{0.050672528554698,-0.21079071533051516,-0.2617610833627322},
{0.09589454653234664,-0.05929006786833996,-0.19767092416887244},
{0.10834658859985187,-0.04849605161542328,-0.18319225328527738},
{0.12122775057955257,-0.03792347224027414,-0.16713326580196255},
{0.10474995856654694,-0.03824393679008677,-0.1866864171857023},
{0.09240863493792546,-0.04977034520083705,-0.2014752372366053},
{0.08090767113735345,-0.06141572435647487,-0.21420648232390438},
{0.0842058427701891,-0.07011296719226978,-0.21061260305926738},
{0.09906068126912214,-0.0707937824375799,-0.1950521923970129},
{0.10186302684956527,-0.08399183296782495,-0.19341135888659886},
{0.10425688328282233,-0.09859490736442665,-0.19254074060320228},
{0.10619755057803965,-0.11431369353273656,-0.19223265451239527},
{0.12152277051918696,-0.1264711282759076,-0.17804006357026395},
{0.13716570424147898,-0.1424701077407318,-0.1629961097254114},
{0.15252943494397714,-0.1621257665188816,-0.14657883462309998},
{0.1376367733758602,-0.1630842030920015,-0.16308207124628393},
{0.12262101490985386,-0.14516626677367156,-0.17818654200183068},
{0.10764170412869746,-0.13085881060888951,-0.19227941757974995},
{0.09324968245814189,-0.12017716325605736,-0.20584139480476077},
{0.09441875914200774,-0.1351988014900914,-0.2059871855441605},
{0.1085439562517751,-0.1479409464982371,-0.1924733467708383},
{0.08257051079711086,-0.15333898616294592,-0.21988338116232353},
{0.09512914515049799,-0.15069742301114267,-0.20624300703027706},
{0.08203823705986842,-0.13934174793468848,-0.219558790459509},
{0.07068650245953104,-0.14313823506556111,-0.2333924060904769},
{0.07106267007486904,-0.15576901520418612,-0.23378095216482056},
{0.0827438092231898,-0.1675218118763062,-0.2200566795884025},
{0.060058495095723315,-0.13532969681715434,-0.24736768630784267},
{0.07000843798288885,-0.13088817506441958,-0.23298804309629276},
{0.08112910801512097,-0.1257696134963714,-0.219286464361385},
{0.06898721511492367,-0.119238188371263,-0.2327542277595196},
{0.05927287556416546,-0.12476468893276364,-0.24693787870348025},
{0.05083613052122252,-0.12918359249012645,-0.262281666333136},
{0.05145127116458605,-0.13889127518070832,-0.26284419852572555},
{0.06054875084156328,-0.14643887551327625,-0.24788483081741156},
{0.060800102328594445,-0.15789075184696924,-0.24832357841994476},
{0.09163291817357212,-0.10589503479378519,-0.20601881938384156},
{0.0781087640177452,-0.10085906505499129,-0.21970939504407766},
{0.08958015705513708,-0.09261521766488623,-0.20673126846883277},
{0.08710033910100752,-0.08060034150793012,-0.20819192663149813},
{0.07596247676460091,-0.08999985558464493,-0.2208124532799134},
{0.06575540577620158,-0.09861615705238633,-0.2335402599063776},
{0.06758308524838409,-0.10840772443349637,-0.232875949273075},
{0.07982524366652706,-0.11286225044510875,-0.21926858436504354},
{0.054580270524344644,-0.0983496075684649,-0.2478318785205541},
{0.06346380916817443,-0.0900829975676328,-0.2349328365445119},
{0.07336781421858571,-0.08052400767739536,-0.22277994056964293},
{0.06066779035566751,-0.08302761978050241,-0.2372393560725625},
{0.05204956334985857,-0.0919762141033285,-0.24941081973593995},
{0.04451259473819215,-0.09900800404913147,-0.2632664415162512},
{0.046802403346585156,-0.10488343961615774,-0.26223834172661625},
{0.056590119651560127,-0.10607314706503297,-0.2470038971515103},
{0.058135570258414086,-0.1149453387881076,-0.24676114181656636},
{0.0,-0.4129811524207796,-0.08607842854087543},
{0.019195964072210428,-0.4006460180216609,-0.10812996556725318},
{0.0,-0.4016252916674403,-0.10815953633043333},
{-0.019195964072210428,-0.4006460180216609,-0.10812996556725318},
{-0.020769059904176972,-0.41193104648180123,-0.08605642239153205},
{-0.022351714657264536,-0.4216412598795576,-0.06235167339573454},
{-0.023929211719099754,-0.4299362027976692,-0.03723165392029237},
{-0.025486903246525947,-0.43697541981887567,-0.010914362382138174},
{-0.027010278934819845,-0.442919143218083,0.016383578186129354},
{-0.02848455340239138,-0.4479269175780307,0.044445544751911585},
{-0.029895078806083872,-0.4521582874814581,0.07305422659044283},
{-0.056629937028028265,-0.44389222763435954,0.04489392004478248},
{-0.059430425839620556,-0.4479000975835185,0.07372747722191618},
{-0.08409718740780626,-0.4372752536036788,0.04554585221907943},
{-0.08824603425119606,-0.440965409771693,0.07470537548336159},
{-0.11054720353418758,-0.42815783085385917,0.04633050898160351},
{-0.1159827224219968,-0.4314752578673703,0.07588201678106424},
{-0.1356410907072845,-0.41661973167627026,0.04717568265482185},
{-0.14228007088730857,-0.4195499879997717,0.0771494334448082},
{-0.159039128996609,-0.4027414160544487,0.048009853253368456},
{-0.16677910433596788,-0.4053120093746196,0.07840172088087863},
{-0.18040297385600687,-0.3866054070484321,0.048762188484044504},
{-0.18911947207247723,-0.3888809804289686,0.07953022372689265},
{-0.1993935930471571,-0.3682901015652561,0.04936116836148398},
{-0.20894151109350617,-0.37037999806070804,0.08042834969696844},
{-0.2156712666395716,-0.34787871035712536,0.04973458520815408},
{-0.2258855583957242,-0.3499280330147256,0.08098881881305704},
{-0.22935840383897274,-0.3255802918428018,0.049903069789064156},
{-0.24008915241252726,-0.3276942575640981,0.08124051414617171},
{-0.24057810154324996,-0.3016073429018821,0.0498845021005557},
{-0.2516912069616453,-0.3038450932132348,0.08121369415165948},
{-0.24945208126595875,-0.27617029733746223,0.049699512907638126},
{-0.26082926047647437,-0.27854764915871183,0.08093586651619959},
{-0.25610275221282147,-0.2494809643369719,0.04936735759098682},
{-0.2676408513904104,-0.25196903459710523,0.08043728969513918},
{-0.27226420582901634,-0.2242770464171582,0.07974615906732434},
{-0.2606532112817275,-0.221750465395674,0.04890660383911028},
{-0.27483686222568815,-0.1956385875077967,0.07889273308810228},
{-0.2632251799862324,-0.19318889047058085,0.048337194724850915},
{-0.2754977343981559,-0.16622076706559688,0.07790520713631913},
{-0.2639410675320585,-0.16400846136442251,0.04767907332105115},
{-0.2743843607798154,-0.13619100374861,0.07681315197515505},
{-0.2629232831249282,-0.13442004512636,0.0469508073162194},
{-0.27146717060748665,-0.1060005955414166,0.0756708952858014},
{-0.26017251445700856,-0.10485214962256016,0.046190219779539625},
{-0.2667165931179894,-0.07610097796703066,0.07453276474944964},
{-0.25568807383613257,-0.07573320019612981,0.04543307070369473},
{-0.2601023698559766,-0.046943242702382655,0.07345446343162516},
{-0.24947133664663418,-0.04749202105163262,0.04471718315786868},
{-0.2515956177504351,-0.018979616116478557,0.07248963132135236},
{-0.24152161519634643,-0.020556494255363482,0.04407900482691129},
{-0.2411667660381848,0.007339050806009595,0.0716932837919896},
{-0.23184028486960323,0.004644672895782302,0.04355567108783961},
{-0.22878624395604547,0.03156231969570996,0.07111974852472834},
{-0.22042597028207067,0.027683048181776283,0.04318362962550347},
{-0.21442379304867004,0.05323700141458277,0.07082404089292699},
{-0.20728004681808274,0.048129511690423,0.04300070350908682},
{-0.19975531912698855,0.042383843635305854,0.015596170654937392},
{-0.21154786440636006,0.023186916794061638,0.015675255254140066},
{-0.19177602691352064,0.03599518340406247,-0.011235514624117789},
{-0.20214367402290978,0.018047793230220762,-0.011222448472945177},
{-0.18326721173147822,0.028958029459357052,-0.03733893389834126},
{-0.19220445913354914,0.012238857495741471,-0.03732449236283465},
{-0.17415666590332834,0.02126963103252164,-0.06255866873799548},
{-0.18172265512444133,0.005734664980445463,-0.062446574914777744},
{-0.16437011867503726,0.01292379889405346,-0.08673861302117611},
{-0.17068932199741566,-0.0014922920023464092,-0.08640439462802389},
{-0.15383398698473805,0.0039170945831175745,-0.10972472370247964},
{-0.15909758283080228,-0.009466770370645448,-0.10901296230965543},
{-0.14247468777056388,-0.005755295745454881,-0.1313608946600016},
{-0.14693849762643046,-0.018216277811130856,-0.13008866415108875},
{-0.13021726258631394,-0.01609818593683273,-0.1514917074640045},
{-0.13420312638612952,-0.02776625893398086,-0.14944719865157322},
{-0.11749770826585354,-0.026974037557620012,-0.16997962368109243},
{-0.12122775057955257,-0.03792347224027414,-0.16713326580196255},
{-0.10474995856654694,-0.03824393679008677,-0.1866864171857023},
{-0.10834658859985187,-0.04849605161542328,-0.18319225328527738},
{-0.09240863493792546,-0.04977034520083705,-0.2014752372366053},
{-0.09589454653234664,-0.05929006786833996,-0.19767092416887244},
{-0.08090767113735345,-0.06141572435647487,-0.21420648232390438},
{-0.0842058427701891,-0.07011296719226978,-0.21061260305926738},
{-0.07030689638335812,-0.07267118205343506,-0.22581610148685927},
{-0.07336781421858571,-0.08052400767739536,-0.22277994056964293},
{-0.06066779035566751,-0.08302761978050241,-0.2372393560725625},
{-0.06346380916817443,-0.0900829975676328,-0.2349328365445119},
{-0.05204956334985857,-0.0919762141033285,-0.24941081973593995},
{-0.054580270524344644,-0.0983496075684649,-0.2478318785205541},
{-0.04451259473819215,-0.09900800404913147,-0.2632664415162512},
{-0.04894167613962626,-0.08715439170533215,-0.25190645460991},
{-0.0416422364024347,-0.09455340926830241,-0.2650626934564027},
{-0.04506171693352561,-0.08368684149176936,-0.25516405240489387},
{-0.0380859051301148,-0.0913361790035203,-0.267483369884172},
{-0.0402150000790846,-0.08137633334915026,-0.25902957007548794},
{-0.03373824648125111,-0.08917311206150169,-0.2703847431366603},
{-0.03420663361618112,-0.08002543085633491,-0.26334758919195483},
{-0.028493837246645608,-0.08788073217209634,-0.27362239785880166},
{-0.026841863123126468,-0.0794369038998335,-0.267963379016724},
{-0.02224725421710029,-0.08727576937280411,-0.27705191869553053},
{-0.018459720838241735,-0.07935066730209422,-0.2721706796943071},
{-0.015249092418262628,-0.08713307324815578,-0.2801602872902797},
{-0.009399445307498115,-0.07950697973164876,-0.2752604806005478},
{-0.007749809337346704,-0.08722756215189882,-0.2824358606708162},
{1.4911916948792377e-19,-0.0796456872417286,-0.27652652187995785},
{0.0,-0.087334085668564,-0.2833649327884061},
{0.007749809337346704,-0.08722756215189882,-0.2824358606708162},
{0.009399445307498115,-0.07950697973164876,-0.2752604806005478},
{0.015249092418262628,-0.08713307324815578,-0.2801602872902797},
{0.018459720838241735,-0.07935066730209422,-0.2721706796943071},
{0.02224725421710029,-0.08727576937280411,-0.27705191869553053},
{0.026841863123126468,-0.0794369038998335,-0.267963379016724},
{0.028493837246645608,-0.08788073217209634,-0.27362239785880166},
{0.03420663361618112,-0.08002543085633491,-0.26334758919195483},
{0.03373824648125111,-0.08917311206150169,-0.2703847431366603},
{0.0402150000790846,-0.08137633334915026,-0.25902957007548794},
{0.0380859051301148,-0.0913361790035203,-0.267483369884172},
{0.04506171693352561,-0.08368684149176936,-0.25516405240489387},
{0.0416422364024347,-0.09455340926830241,-0.2650626934564027},
{0.04894167613962626,-0.08715439170533215,-0.25190645460991},
{0.0,-0.3572051915257069,-0.1630903235522876},
{0.016136903005833692,-0.372709899122436,-0.14651419155940393},
{0.0,-0.3735117481891346,-0.14657883462309998},
{-0.016136903005833692,-0.372709899122436,-0.14651419155940393},
{0.0,-0.38852406819430607,-0.12839969218898606},
{0.017647075004521576,-0.38762525453206326,-0.12835499219813237},
{0.014673012689983557,-0.3565099347448903,-0.16300367433924817},
{0.013262693593941156,-0.33963534435153725,-0.17821748814934474},
{0.0,-0.34021919500130315,-0.17832889428039547},
{-0.013262693593941156,-0.33963534435153725,-0.17821748814934474},
{-0.014673012689983557,-0.3565099347448903,-0.16300367433924817},
{-0.03208984835700026,-0.3702596519314866,-0.14635395928449757},
{-0.017647075004521576,-0.38762525453206326,-0.12835499219813237},
{0.0,-0.3066721957116892,-0.20655934542708781},
{0.009427709455560988,-0.291069148135082,-0.22015433187611363},
{0.01063261490132649,-0.3063049680945219,-0.20639842546001447},
{0.0,-0.32316993079753725,-0.19268721903476901},
{0.011913441562326573,-0.32269748627882205,-0.19255105598570704},
{0.018729364936914558,-0.2901352621723232,-0.21969151504773612},
{0.0164959470862139,-0.27689306180495815,-0.23369911679694996},
{0.008306014762000056,-0.2776000093526135,-0.23421488592218492},
{0.0,-0.29134216192537304,-0.22033932106903126},
{-0.009427709455560988,-0.291069148135082,-0.22015433187611363},
{-0.01063261490132649,-0.3063049680945219,-0.20639842546001447},
{-0.011913441562326573,-0.32269748627882205,-0.19255105598570704},
{0.021401392851715002,-0.2648997104128285,-0.247629009331295},
{0.024453920842505424,-0.2755499990028464,-0.23297566463728706},
{0.02804112949312273,-0.2631804799953787,-0.24672606951605036},
{0.024414928696637663,-0.25555603694007245,-0.2624480878375451},
{0.01864477880037603,-0.2570462658659179,-0.26340535533398113},
{0.014444079967595945,-0.2659676963481483,-0.24841504147815305},
{0.007274957896047076,-0.2665082223913945,-0.24897413520990774},
{0.0,-0.27779531392803575,-0.23442050588011187},
{-0.008306014762000056,-0.2776000093526135,-0.23421488592218492},
{-0.0164959470862139,-0.27689306180495815,-0.23369911679694996},
{-0.018729364936914558,-0.2901352621723232,-0.21969151504773612},
{-0.021129135522807655,-0.3050987560336391,-0.20599406246583027},
{-0.02368012961621963,-0.3211886896644681,-0.19220996067088497},
{0.05164740097060872,0.2214121208495199,0.4611361087213808},
{0.029187581104694944,0.21677432487540732,0.486631608119994},
{0.05878103812634143,0.21049156923787893,0.4779804406593867},
{0.07708410268894514,0.2134933455467462,0.44702879160795495},
{0.0891861094434576,0.20013767597182938,0.4637197681927243},
{0.09575356963811575,0.1915655931104248,0.4874478987221992},
{0.06329202366486285,0.2030397369164846,0.49970257313778116},
{0.03148289125042379,0.2100273770251675,0.5075525792238568},
{0.0,0.21889791828704136,0.4895556752139925},
{0.025901169007914646,0.22647215981415805,0.46968687312560903},
{0.04341476296282542,0.2361314839915579,0.4476257084088935},
{0.06321899075672958,0.23075716970660987,0.43465996029265425},
{0.079861691351377,0.22500187396115504,0.4169202531532405},
{0.09854284906738627,0.20532012414218992,0.42715998951957135},
{0.12387399003809127,0.18379948546872066,0.4410252389902203},
{0.12890239516304836,0.17528585644150937,0.47422632911984336},
{0.13184640532988937,0.16934419611880291,0.5043926337165842},
{0.09892039206705823,0.18552284203917233,0.5152691730295383},
{0.06593785050810136,0.1973944719177465,0.5249938279628014},
{0.032966174485382756,0.2047624057947693,0.5317318358148705},
{0.0,0.21239922730908115,0.5103755555693094},
{-0.03148289125042379,0.2100273770251675,0.5075525792238568},
{-0.029187581104694944,0.21677432487540732,0.486631608119994},
{-0.025901169007914646,0.22647215981415805,0.46968687312560903},
{0.0,0.228286979442818,0.4725738048425906},
{0.022087984711227745,0.23989522322143889,0.4556242560030368},
{0.03560677486815222,0.25497700013547536,0.43590468311488795},
{0.051364759489979976,0.2510550917071889,0.4238968901872517},
{0.06466830199863974,0.24666417722102219,0.40762471813217305},
{0.07469918625385881,0.2424149273212533,0.38738731304228824},
{0.09170237508243709,0.2200958780419203,0.39460257925824144},
{0.11235652162551173,0.19950087302520594,0.4013233948061361},
{0.13721865653833643,0.1786803049777222,0.4044675233935683},
{0.16271071747611474,0.15660126026466517,0.43253705457318725},
{0.16277467284764385,0.1538835008207606,0.4634770128577804},
{0.1646493216948311,0.14905177565555974,0.49419759734110696},
{0.16594768450608915,0.14362657215025523,0.5251189879371916},
{0.13369836033556626,0.16352907115482082,0.5347122936665614},
{0.10082254860092466,0.1797586062955467,0.544240956332235},
{0.06747614911641872,0.1918929345819072,0.5525420884798495},
{0.03381643708063672,0.19951118840771068,0.5584534903472088},
{0.0,0.20732062065593454,0.5343540060475649},
{-0.032966174485382756,0.2047624057947693,0.5317318358148705},
{-0.06593785050810136,0.1973944719177465,0.5249938279628014},
{-0.06329202366486285,0.2030397369164846,0.49970257313778116},
{-0.05878103812634143,0.21049156923787893,0.4779804406593867},
{-0.05164740097060872,0.2214121208495199,0.4611361087213808},
{-0.04341476296282542,0.2361314839915579,0.4476257084088935},
{-0.022087984711227745,0.23989522322143889,0.4556242560030368},
{0.0,0.24137444907261268,0.4583812139004593},
{0.0,0.25896905316479374,0.44592985952512104},
{0.01821249550421246,0.25781785647726935,0.4433482631302784},
{0.028854738095876662,0.27881928756466884,0.42481702230667073},
{0.04172379669343852,0.2756820358989065,0.413580819990386},
{0.052723020288982,0.27199394280739325,0.3983216184972688},
{0.06122901593313981,0.26814699282530763,0.3792990903895707},
{0.06749072819035869,0.2639782029090754,0.3570265291007256},
{0.08188556939879887,0.23812441589146563,0.3638440341672976},
{0.0997359949770964,0.21561693895838013,0.36897380511766753},
{0.12082132450886746,0.19494560011113105,0.37228628074757636},
{0.14502946417089424,0.17453352121083335,0.37278705818357116},
{0.16684374739966398,0.15568525429824795,0.4009547918046349},
{0.19576532917417108,0.13108581779320957,0.42436589624513193},
{0.1955769015204186,0.12914515049799227,0.4544599931643398},
{0.19625702907356174,0.12555127123335524,0.48487111617252543},
{0.19681681049748337,0.1206720953086328,0.5159685559633569},
{0.0,0.20219112478243137,0.560811586787783},
{-0.03381643708063672,0.19951118840771068,0.5584534903472088},
{-0.06747614911641872,0.1918929345819072,0.5525420884798495},
{-0.10082254860092466,0.1797586062955467,0.544240956332235},
{-0.09892039206705823,0.18552284203917233,0.5152691730295383},
{-0.09575356963811575,0.1915655931104248,0.4874478987221992},
{-0.0891861094434576,0.20013767597182938,0.4637197681927243},
{-0.07708410268894514,0.2134933455467462,0.44702879160795495},
{-0.06321899075672958,0.23075716970660987,0.43465996029265425},
{-0.051364759489979976,0.2510550917071889,0.4238968901872517},
{-0.03560677486815222,0.25497700013547536,0.43590468311488795},
{-0.01821249550421246,0.25781785647726935,0.4433482631302784},
{-0.014739031138013628,0.2810150886538357,0.4317668393461698},
{0.0,0.2818774546312285,0.4341710111619316},
{0.014739031138013628,0.2810150886538357,0.4317668393461698},
{0.02378967897841953,0.3085303399468689,0.41320740314371596},
{0.034498834017930885,0.30593086355568483,0.4025543637850301},
{0.043785222733177497,0.30267601652936893,0.3880605636737615},
{0.05117447506737664,0.2989810465161859,0.3699591304545164},
{0.056773870998577156,0.2946891597020642,0.3486508511222104},
{0.07175723916351875,0.2593232146307884,0.33201647160278347},
{0.08665471457680456,0.2336104045074095,0.33765272783413414},
{0.10495489083230695,0.21114556448867675,0.34130065970309575},
{0.1262313987864984,0.19056706408396995,0.3428155767777358},
{0.15005511852718342,0.17051464818700274,0.34205271985690494},
{0.1722483201399591,0.1528045118107691,0.3694816657829822},
{0.19781052567876936,0.13100467011750594,0.3942188470290667},
{0.22574045534849144,0.10464680474149995,0.41691543930807157},
{0.22551695539422295,0.10286018049168615,0.4464346255756843},
{0.22559741537775962,0.09974768574393506,0.47660161786459193},
{0.22555065231040497,0.09528800204107037,0.5077664514877875},
{0.1759996809108345,0.14962737399932194,0.33886739850867076},
{0.15285815179979356,0.16646139055482315,0.3116755000725515},
{0.17814115431880995,0.14620129162342801,0.308644778800376},
{0.2027096446763342,0.12737159239935109,0.3343924480396991},
{0.20052209589317113,0.1295508888765104,0.3641756393302153},
{0.22669841053709447,0.1051275015662189,0.3876940237487612},
{0.2522764329957452,0.07672925353078348,0.41096140052635954},
{0.2521203268738408,0.07494400466530365,0.44001226842825886},
{0.2519291484514204,0.07207701602116443,0.4699144992328793},
{0.25139618702201094,0.06809527837435073,0.5010201913297146},
{0.15399903310481322,0.1622114529628873,0.2810661154126256},
{0.1307220286368772,0.17636003160633199,0.2515306308406555},
{0.13065119634367828,0.18145101671848426,0.28237555006777204},
{0.12927787508621938,0.18614314037378818,0.31286178969135686},
{0.10932036070829541,0.20140371725123937,0.282074065821768},
{0.10946202529469329,0.195802464551188,0.2513245982674283},
{0.10878052235721618,0.18954309044733686,0.22013920264844006},
{0.1298603503516514,0.17073952352560515,0.2205009287282715},
{0.1538044162215579,0.15764242620547278,0.25034154231473055},
{0.1787153772782382,0.142573715442609,0.27834649919987015},
{0.08921774328313867,0.20201370020335058,0.18654406490713746},
{0.09011862002188235,0.2099565447319685,0.2181861568942171},
{0.09073960604866523,0.2169758186803325,0.2494286309630647},
{0.0746276662684929,0.23289451696158345,0.21429588230561178},
{0.07382100335662546,0.22383967419895892,0.18245092112927305},
{0.07329079269588396,0.21363913628614592,0.15038521076733377},
{0.08846472036029568,0.19303450357909385,0.15481188524618347},
{0.10767952719788135,0.18249837188879467,0.18875843368481277},
{0.12843545218166902,0.16445814327241068,0.18945987969513228},
{0.15260164262151005,0.15263190107685715,0.21961861967803625},
{0.17799467588724321,0.13864286701615183,0.24805187124477093},
{0.20372123985396168,0.1218122889214855,0.27501394295868553},
{0.20392548442755473,0.1247115990974728,0.30472121303396715},
{0.22882956856256517,0.1032136542655138,0.329760703756656},
{0.22789361952330553,0.10456290629712839,0.3586746521481096},
{0.25270417752360674,0.07746921030245389,0.38241014098377113},
{0.2502773118663346,0.07401011870254495,0.2696979449694974},
{0.2257597107291669,0.09673696943689701,0.24283992108044689},
{0.2279355687454913,0.09919959508685207,0.27186534437216797},
{0.2521897837827058,0.07543295379602638,0.29800163533197305},
{0.22900905621814696,0.10133900541832659,0.30085631428632337},
{0.20230872014298493,0.11859595265652043,0.24532867903274722},
{0.1998976714055534,0.11498488108770895,0.21572421893642904},
{0.22263414983024318,0.09389336232643508,0.21383100240073333},
{0.24736424784700775,0.07229982828326591,0.24125203986689026},
{0.17375436598564512,0.12946148889480305,0.18779016311370508},
{0.17625068855178216,0.13430559251900953,0.21784024773422622},
{0.1507173660839851,0.147058156063485,0.18901494286309628},
{0.1484775526961315,0.1407994696518008,0.1586471444614304},
{0.17077803428695607,0.12400671462631839,0.15798145844379388},
{0.1967005905212638,0.11090067730801524,0.18625798496567383},
{0.21870949063328882,0.09060963222910602,0.18489154062988475},
{0.24355030708893718,0.07025325639433366,0.21272106724322776},
{0.23361384296824442,0.06495252517125252,0.15563711584655934},
{0.20906942183656446,0.08249005081357422,0.12742729546487647},
{0.2141377131072064,0.08682801300288348,0.15607311268042462},
{0.23893382957200102,0.06782088919972576,0.18416327462505303},
{0.19292859898537895,0.10626425671823671,0.15698911864684187},
{0.18879144290882785,0.10099859779567152,0.12797538612195944},
{0.18450161917120714,0.09502461594111704,0.09927455353305285},
{0.20365659679026557,0.07753797951915187,0.09900566589576373},
{0.2276893749497125,0.06159865047289152,0.1271996693576061},
{0.16168399307081371,0.10296539739323404,0.0707958455140808},
{0.1644712094235833,0.11086079116233041,0.09940521504477906},
{0.16759333186167208,0.1178408666571765,0.12849390601586227},
{0.1442406812553683,0.12573763581060682,0.09908681357146737},
{0.14289693076108956,0.11669104535398608,0.07012809641994332},
{0.14250494622591098,0.10647125206049766,0.04187357604740675},
{0.15950263351715344,0.09405153152484047,0.04274488202297026},
{0.18026956157561277,0.08826391424753756,0.07094576240648243},
{0.19805053024504535,0.07191265759325619,0.07086048857777695},
{0.22126014088061732,0.057709751268620116,0.09890938899238652},
{0.12537866049944332,0.14939287097038176,0.12803865380132157},
{0.12681868789709924,0.15738660471935625,0.15858112601340035},
{0.10656065204220505,0.17454108582467012,0.15742305240420618},
{0.10582825988437143,0.16554332151190498,0.12637512644939716},
{0.10588465064206379,0.15537785589960795,0.09585466038666177},
{0.12448672375887035,0.14034628051376108,0.09800644917714194},
{0.14621023162159874,0.13373343263608223,0.12863213214142524},
{0.09136265515194902,0.158764052129817,0.062177687277488576},
{0.08911046330508982,0.17152211721162833,0.09231854726405107},
{0.08828660808904787,0.18290823642031467,0.12329976707866303},
{0.0748394754559227,0.189470195077637,0.08708727294983491},
{0.07780480407994009,0.17533537027753193,0.0566005038032815},
{0.0828222061302255,0.15972338270275402,0.027386652857807933},
{0.09547230354182097,0.14452332273599702,0.03318871167061745},
{0.10713349961729932,0.14391609055255378,0.06610234647444294},
{0.12451216836904862,0.13011685952993488,0.06865781056694029},
{0.18033626771580985,0.05078950499230129,-0.011158493101416039},
{0.1633963465665937,0.053458438292350294,-0.037492289251577764},
{0.16813317021275132,0.06314733323293027,-0.011230013086781945},
{0.18655162952097426,0.058504035721481926,0.015666315255969336},
{0.1723480355041712,0.07223724829607073,0.015635369108455227},
{0.1554748204951521,0.07378661874827647,-0.011690079146491526},
{0.15288634717863972,0.06274159485441214,-0.03807820297784462},
{0.149419690964894,0.05129427104286455,-0.06391479769127985},
{0.15787555385007898,0.043258588071704296,-0.0630923178595719},
{0.17359413371073878,0.04244779900683495,-0.037320366209832805},
{0.20728004681808274,0.048129511690423,0.04300070350908682},
{0.1924025144776393,0.06555631889386088,0.04304334042343954},
{0.17630570392514058,0.08063878350006427,0.04304677888427446},
{0.1575571523767673,0.0842746119868871,0.015250261494946475},
{0.14267136773032013,0.08342256139199895,-0.012778008154653726},
{0.14227663242647365,0.07104822853936248,-0.03930091965073494},
{0.14092806808702607,0.05841119727893964,-0.06537476816177819},
{0.13814841634809327,0.04573978141016781,-0.09106075829064485},
{0.14470349808374577,0.039596627282536254,-0.08920330174763214},
{0.1513060305789199,0.032635119476198626,-0.08797302046090505},
{0.16616430753868783,0.03351399006559896,-0.06270721024606314},
{0.14258884467028254,0.09530588203741182,0.014259297082328445},
{0.21442379304867004,0.05323700141458277,0.07082404089292699},
{0.13813397481258669,0.0035037915907626354,-0.1330986927659598},
{0.1434257660374971,0.021678120179707713,-0.11207663091355093},
{0.14859583574885205,0.014006914057046814,-0.11070812350126087},
{0.16437011867503726,0.01292379889405346,-0.08673861302117611},
{0.15788586923258366,0.024021775084775245,-0.08720693138688947},
{0.13836710245719286,0.027804082003164754,-0.11394440283906832},
{0.13397137412585727,0.010474239395271012,-0.13534469538331617},
{0.12633867876454724,-0.007453207705728279,-0.15426723304993537},
{0.12308451943039833,0.026780796058698656,-0.14554592098829616},
{0.12403628538949853,0.04536773994783167,-0.12368418700000482},
{0.1287545413471477,0.038919938190228036,-0.11962886629132426},
{0.12639300644573867,0.021200174123656674,-0.14152704796446558},
{0.13346248192229215,0.0332595439638164,-0.11642353310103096},
{0.13171230535732828,0.051896001688971946,-0.09371181159435243},
{0.1253105789749123,0.05871790798541268,-0.0973270093161658},
{0.11885796337213979,0.06685536939728595,-0.10207827449783002},
{0.11910209409141767,0.05318611219422629,-0.1287132798171289},
{0.11979460010356643,0.03328567626616163,-0.15025523694777465},
{0.11413214280065385,0.015785286000856866,-0.1715846971988235},
{0.11646341924671576,0.009787922612625063,-0.16643319517597696},
{0.11934966327153045,0.004545645223737211,-0.16179333612536353},
{0.13003983800723312,0.016068615173652587,-0.13814016404208948},
{0.13253065903603437,0.06540158815629042,-0.06767097230732418},
{0.12426872534193774,0.07295107276539586,-0.0710097177780116},
{0.11618352853475493,0.08174734327323589,-0.07559318607093272},
{0.11226987241247226,0.07695894271455478,-0.10813753018108996},
{0.11374497211064416,0.06295821788701081,-0.1348406170249199},
{0.11620209622326338,0.041191385417762676,-0.15571344967709416},
{0.1119329032506521,0.022856136861744293,-0.177216896046389},
{0.10222819139023161,0.005745668055117153,-0.19716065658097331},
{0.10390478489332863,-0.0013306843431061214,-0.1907554917377225},
{0.10670437970510384,-0.007031652407369592,-0.1844521053351846},
{0.11015384361467506,-0.012482988215019334,-0.17867274036388547},
{0.12267878105188018,-0.0008871228954040936,-0.15771944772817453},
{0.10831633014450476,0.0924760287702895,-0.08162630945184743},
{0.11179330174075519,0.0974109077605373,-0.04904070381167136},
{0.10263943130608559,0.10900952384882051,-0.05506213642574745},
{0.10070770400903901,0.10582413373136955,-0.08931264480218196},
{0.10546103226720416,0.08968056011151614,-0.11567669940769075},
{0.10775792410491707,0.07526721998378423,-0.1421906709056012},
{0.1119872309318435,0.050972431108717936,-0.16197832531828113},
{0.10944345760618483,0.031321627437267005,-0.18329747018682535},
{0.10096146241865461,0.014070869428575952,-0.20372192754612867},
{0.08770550820794987,-0.003525110047939015,-0.2216892607928128},
{0.08894954333801651,-0.01250980820953156,-0.2141060792675253},
{0.09251316414730641,-0.01892735151178807,-0.20566672099434788},
{0.09700310630551824,-0.02439175347061044,-0.19767505032187435},
{0.10102541779018374,-0.030519778370568428,-0.1914314931378637},
{0.11377935671899315,-0.018811819227735463,-0.17383757673784972},
{0.1300308980090624,0.09277173640209085,-0.014732429293210638},
{0.12156196897270481,0.08768418975077347,-0.04455695088296237},
{0.11784361742584444,0.10253146363586972,-0.017794722512772167},
{0.12785572768490494,0.10602218907545977,0.01241078053748643},
{0.11376491518348658,0.1171084744993429,0.009453016527305836},
{0.10640179515163267,0.11339562448981838,-0.022204204687447375},
{0.13177969918969232,0.07912929919354338,-0.04138600230101798},
{0.12582566040798024,0.11857325881501013,0.04016672408896258},
{0.10997710672776125,0.13103217780418516,0.03736025235551756},
{0.10072283323671259,0.1292503673995402,0.005133622026505031},
{0.09599494958872569,0.12606153882125437,-0.028200880383512195},
{0.08913728329960204,0.14313212148219667,-0.000799785990197653},
{0.08691534990808994,0.14122377571882744,-0.03602612955157658},
{0.09426952994177311,0.12317873325727456,-0.06284681175596003},
{0.09333151782601251,0.12111771983283579,-0.09823063682357742},
{0.09847545523502223,0.10435659864703443,-0.12430310995028675},
{0.10124547928361731,0.08947356476925518,-0.1504154692226809},
{0.10682816429516023,0.06310400862641055,-0.16910694232119486},
{0.10624087518455937,0.041500159200736644,-0.18979478578045156},
{0.09939214889360645,0.02351632134204502,-0.21049156923787896},
{0.08739054519547305,0.00691955858415185,-0.22892653315810935},
{0.07136250385967229,-0.01060421321483023,-0.2440922085165173},
{0.07019755332880831,-0.025376528653725687,-0.23726686375924172},
{0.07857570699912457,-0.031578824307717496,-0.2230618943581047},
{0.08418039816001084,-0.03673238940706495,-0.21371753319318162},
{0.08864764647671233,-0.04252344514520276,-0.2066728146346395},
{0.11749770826585354,-0.026974037557620012,-0.16997962368109243},
{0.07941537913500704,0.15944005352995827,-0.008598215163749848},
{0.07897456845597291,0.15820083224506046,-0.04522676305360082},
{0.08657700536193583,0.13923840843275642,-0.07195391912327499},
{0.08615957621657902,0.13768284875104786,-0.1079566671411743},
{0.09135784130678015,0.12032618614864189,-0.1336234018893655},
{0.0943135422404598,0.10494113698896734,-0.15916497666316634},
{0.10087825166645004,0.07698782578556797,-0.17681322074437178},
{0.10190222530308313,0.05371082131763193,-0.19667858437192043},
{0.09706362321621247,0.03433853297380787,-0.21728046631030462},
{0.0866155161232867,0.017714950221402497,-0.23632403779831226},
{0.07184732683739312,0.0017976273244854895,-0.25186037923472243},
{0.053998276643429544,-0.014070181736408971,-0.26328913535776155},
{0.05116759814570684,-0.027835028150678863,-0.25745062886010206},
{0.058041631508404634,-0.04280471124149754,-0.24446700074752137},
{0.06669149235389464,-0.045423443013357045,-0.23426027360520552},
{0.07263954821375397,-0.04962592984577128,-0.22578928149234703},
{0.07721476420067133,-0.05477124263911497,-0.21918468592067195},
{0.071680217640817,0.013857684856812177,-0.25982247914401585},
{0.0850131933742235,0.029285370930839473,-0.24342514711454685},
{0.07064730400601318,0.026137803882572426,-0.26721929609205175},
{0.05515311809943891,0.011884008337579825,-0.28001449655087995},
{0.0549582949085335,-0.0009015644309106671,-0.2715558828970271},
{0.03607667492584959,-0.015314904558642614,-0.278197613845719},
{0.033986915968831036,-0.028961467920191955,-0.2710717476114732},
{0.04536093179537857,-0.04240860055331712,-0.25627673833106734},
{0.048781994018453526,-0.057193294451218214,-0.24986951041131553},
{0.0565293276639991,-0.05909201252424975,-0.2422684488896866},
{0.06231185601926638,-0.062254021108023375,-0.2356315317861635},
{0.06676314987769394,-0.06668069558687306,-0.23012380522082138},
{0.07030689638335812,-0.07267118205343506,-0.22581610148685927},
{0.047757951612603745,-0.07121258696727066,-0.2500909472890831},
{0.053128139744549864,-0.07380044136083277,-0.24498483294925724},
{0.0573269818084791,-0.07766939749226175,-0.24064549537561405},
{0.040903173630581394,-0.0696982888155809,-0.25579604150634844},
{0.03843594044310757,-0.056557866888928776,-0.2582703579231421},
{0.03225049324720677,-0.06904910740995188,-0.26193438178881107},
{0.015332371939683894,-0.04342294649961249,-0.2741959331260629},
{0.016956013145923463,-0.029464858586421238,-0.27972704122508235},
{0.018061684611993763,-0.015730270627498474,-0.2877331534330625},
{0.0,-0.029560447797631447,-0.2828127159783212},
{0.0,-0.04357217569984712,-0.2768497371984384},
{0.0,-0.05705988217082411,-0.27359626555645644},
{0.013395280643734882,-0.05689139758991404,-0.27142109523229896},
{0.026353120300053844,-0.05663970225679939,-0.2659580686578106},
{0.03050568068114534,-0.043019958889762254,-0.2670625022779803},
{0.03740508988480468,0.3372524909929518,0.37708307115069467},
{0.04401614976284935,0.33350456868291134,0.3596656165607277},
{0.049165313632328136,0.32889428039547797,0.33907178062069715},
{0.060690621735611246,0.2896435622729326,0.3245367189794098},
{0.07427694326333315,0.25401835725470534,0.304781592406228},
{0.08943505400790433,0.2286913424370022,0.30947207935417453},
{0.10795254098817238,0.20647613467488318,0.312146397283891},
{0.02933254661349431,0.3402969042161719,0.39100526153276954},
{0.02016395956645135,0.3425649129828716,0.4012216163654231},
{0.017729804372209258,0.3793791377578072,0.3890054527111919},
{0.025867609630166027,0.3772761751111826,0.37912283488717374},
{0.03313287106665869,0.3742647711119776,0.36562976441729433},
{0.03923483243348813,0.3703050396145073,0.3487164569549403},
{0.04409605959265243,0.3652312468065295,0.3286440979851307},
{0.05285216887794083,0.3232634569322465,0.31562019861925167},
{0.06303193848731103,0.2836888357990536,0.2980176585594637},
{0.06390510123172544,0.27666956185068964,0.2694947319341548},
{0.07530022920779925,0.24790133542941906,0.27583449725232595},
{0.09065433221995971,0.22318361587166008,0.27996065025420536},
{0.008242265698121018,0.4185686512774913,0.3826031761750424},
{0.00901034907942088,0.3806107944288682,0.3950874022359623},
{0.010264699591992237,0.3439836219233512,0.40752018892279207},
{0.0,0.3810082805013825,0.3971779864235812},
{0.0,0.4189083712079794,0.3846248536075299},
{0.0,0.4565973404193134,0.3721352635477076},
{0.007833639012501555,0.45628719125200545,0.3701841433315522},
{0.016239506677147096,0.4174284576646386,0.3767047029204223},
{0.023746698217983284,0.41536400577936494,0.367095580271212},
{0.03051895313996805,0.4122521987237809,0.35394181711652045},
{0.03631117795478974,0.40797131498433087,0.3374096974223234},
{0.04099690607294076,0.40233705306026446,0.3177227005121243},
{0.04444980844334689,0.395166486835165,0.2951044570017034},
{0.0476394622522331,0.3588742204149672,0.30567380422366774},
{0.049787606274228256,0.35106616355107734,0.28006682992478704},
{0.05507623411517056,0.3164539290948114,0.2896296708911596},
{0.05583709672871713,0.30830821537693437,0.2614188189712262},
{0.05559330985552276,0.298838694237621,0.2314441741814228},
{0.06376426187592796,0.26854379120565497,0.23938908178654172},
{0.07526859536811818,0.24088756301839095,0.24554825914166387},
{0.04369747321267086,0.45349997489923594,0.24882256785630533},
{0.04268072034379106,0.43083295338341104,0.2843188993624406},
{0.044720827926353665,0.420837347736358,0.25921400911467196},
{0.04418098957527444,0.4399881992024146,0.22130346548713703},
{0.04526788704518619,0.4086583194591438,0.23154870339080375},
{0.04654334970728383,0.3862760025004487,0.26977854249146743},
{0.03929871903580056,0.43885006866606285,0.306662430482918},
{0.04172964207685785,0.4645642541737756,0.27372403876108126},
{0.042850511539818406,0.48301709809034754,0.2390534880090555},
{0.0432578316103206,0.4682922334109737,0.21170878437343332},
{0.04260603697445705,0.45120995998319274,0.18221435502383196},
{0.04359617615647472,0.42430125318143586,0.19168250077881138},
{0.0447574819188537,0.3945042392783633,0.20183283716343486},
{0.04715113204446067,0.37548198624753204,0.24196861510488332},
{0.03349322176215616,0.5120377075368998,0.3043237957306694},
{0.03691779121528272,0.5311981866932941,0.27619649840902416},
{0.0328073175948104,0.5390413158577,0.29456661295790837},
{0.027650176496194653,0.5447849208363162,0.30966585725298607},
{0.026581090253407685,0.5657719103882091,0.3004212114522752},
{0.03138255696326142,0.559850880830512,0.2859417841072964},
{0.035131579580769096,0.5517086055734698,0.26812890652131605},
{0.03775890750471585,0.5410610677521199,0.24715188850584432},
{0.03987129153402804,0.5209866457058094,0.25473369464679785},
{0.037828295644364116,0.5046429536653648,0.28554450434243217},
{0.03395968335901863,0.48024982481042044,0.31491535540962723},
{0.02812881024441267,0.5174828541150468,0.31988133183966594},
{0.021556880050669157,0.548696513882098,0.32131618779222615},
{0.02079622374477268,0.5697536480350227,0.31139790625242836},
{0.019743435806343135,0.5844908911734022,0.3018553934665118},
{0.025034401800653167,0.5804816458399094,0.29198075287163056},
{0.02927663724031884,0.574808185462325,0.2784682207134256},
{0.03248939750601559,0.5668653409337071,0.2614483897344064},
{0.03469228182450233,0.5560548200687829,0.2410519214462991},
{0.03583639528270681,0.5421985105963048,0.2175080924175749},
{0.039195427672320184,0.5276221874249986,0.22318017741082524},
{0.04155737518902938,0.5081405560266247,0.2303562451732606},
{0.04099401776583944,0.49505171101249607,0.26372664511439414},
{0.038432226905405875,0.47340591236463636,0.29581807516337844},
{0.03472590997146765,0.44509018738923856,0.3260433149788294},
{0.028466673406049903,0.4853201791575633,0.33082655784625814},
{0.021874937677897367,0.5212252748877514,0.33203387021460806},
{0.014761312364223778,0.551089682623188,0.32957014425718584},
{0.014273876156268416,0.5721468167761129,0.3190322176903308},
{0.01364085551656341,0.5869940906612092,0.3085046752751972},
{0.01301161718377679,0.5958928273019292,0.2973538980798947},
{0.01854884574308233,0.5930182740439531,0.29226497604424334},
{0.023123305268615998,0.588981521023781,0.2841779224682097},
{0.02654698072192548,0.5842708296799686,0.2721646967724543},
{0.029011119294647898,0.5773732772451601,0.2562616778726105},
{0.030706693101553564,0.5667484332653205,0.23650558853039494},
{0.03155214185163866,0.5526094823122136,0.21332279788933517},
{0.03146563017703259,0.5351544797299295,0.187140981708076},
{0.03587311804442354,0.5251293033196964,0.191044322447854},
{0.039371958251583926,0.511105884650642,0.19638287674011906},
{0.04186566758748648,0.49239103001845075,0.20324260610574366},
{0.029113447889094507,0.4497575541265312,0.3422604028913329},
{0.022107652707203367,0.4888432261290014,0.34336229205048485},
{0.014953866170978151,0.5235427974904737,0.3407520876614959},
{0.007497701388931869,0.5522725131503934,0.33448040386785577},
{0.007259828668373518,0.5733090165383089,0.3234844811947138},
{0.00696398349813876,0.5881425365800655,0.3123412204747964},
{0.006699510844561627,0.5971237962808232,0.30037300423136987},
{0.006555803812427835,0.6005760109590623,0.286902352526134},
{0.012662888485901278,0.5993106573718193,0.2847588848108743},
{0.017872638035290985,0.5961679041687211,0.28145328610263526},
{0.02138289393242324,0.5921724126785678,0.27812801939842063},
{0.02298329114341889,0.5902606284543637,0.2683259990963725},
{0.024649431725577816,0.5843258450533271,0.25299438361807225},
{0.025837626251685706,0.573921062566921,0.2335828968207303},
{0.026414324902915058,0.5595895578070597,0.21060847690626547},
{0.026246046629655073,0.5418739198934902,0.18458826838424663},
{0.0255195686244575,0.5212809779532768,0.1560909926767661},
{0.030680698337641723,0.514871686957024,0.1585212967948731},
{0.03508089666806268,0.5053079519908344,0.16221282834722126},
{0.03860917009996981,0.49194196703341286,0.1673010626907056},
{0.04115452511761255,0.47412523837129733,0.17392285056655515},
{0.02261248752698332,0.4530543503750329,0.35511240672315364},
{0.015445222224285298,0.45516831609632913,0.3644650889632972},
{0.015099244295077705,0.49105484413800876,0.3524323328099996},
{0.0075881329088897265,0.5247118741743396,0.3460065372017393},
{0.0,0.552561343860525,0.3360996438442267},
{0.0,0.5735772164834311,0.32491515597889886},
{0.0,0.5883832288385086,0.3135563147677079},
{0.0,0.5973232270092473,0.3013651377206718},
{0.0,0.6007410570791375,0.2876835020586065},
{0.0,0.5989805651316689,0.2718535160668959},
{0.006622269260366443,0.5988430266982729,0.2712516478823551},
{0.012871603058579682,0.5976945807794166,0.2698986135438221},
{0.018375065932486508,0.5947856429130914,0.2682470520356032},
{0.019357227885367215,0.5888508595120548,0.2520721884221522},
{0.020120359883064824,0.5783566770439414,0.23235467861050418},
{0.020494808267985384,0.5638738800073446,0.20934656177985733},
{0.02031078184410156,0.5459821928990282,0.18330090864766022},
{0.019708432275043857,0.5251843186930548,0.15478437755950425},
{0.01882791122444278,0.5019932757459912,0.12436293916881397},
{0.024421736849090766,0.49830999649964686,0.1256826204372484},
{0.029430817824155738,0.492245239279051,0.12802627534231598},
{0.0337383840196845,0.4831965857459294,0.13156582692576152},
{0.03722787161337396,0.47055955448550646,0.13647526130583112},
{0.039782372936837535,0.4537296640830072,0.14292718921643663},
{0.053926275273546743,0.27597980660720883,0.1680272656190364},
{0.06306364109620882,0.2592716377182649,0.20812109433829915},
{0.06225752833807497,0.24881321524283445,0.1761124624262192},
{0.05342027137708293,0.2626165724184552,0.13549873842871965},
{0.06180007550859993,0.2371279499415118,0.14378336596432664},
{0.05480349540174632,0.2880584318280439,0.20016174519767363},
{0.048225169670849895,0.30438561925648094,0.15869528291311902},
{0.04758059580273962,0.28922269466674094,0.12602302805990348},
{0.04774825515304933,0.27281092110176536,0.09338103166203506},
{0.05374410561851377,0.24798179541295573,0.10303072814909714},
{0.062145434514857247,0.22417526797644516,0.1115560479431471},
{0.0467224247475654,0.3629240395863119,0.21217228889397777},
{0.05046333259750271,0.34163927932611665,0.25208422303507433},
{0.050123475128581244,0.33066715080195225,0.22220709299454863},
{0.04570642834006927,0.34874176402668516,0.18088848452589468},
{0.04922514285085538,0.3182247364247847,0.19091709939696272},
{0.04362499045827118,0.3785807271519435,0.17057516509769696},
{0.042306065651220415,0.3610947784221454,0.13828457939715524},
{0.044552412114660295,0.3330747610785489,0.1486144034373605},
{0.05871570737047834,0.21494712678774178,0.04010345640960044},
{0.06374789480235382,0.20991390781761574,0.07985000058453831},
{0.06706167704737993,0.19430467101150578,0.04908746687902601},
{0.06428071869332987,0.1965733674703725,0.010556762455308608},
{0.07254120823387585,0.1773069837202633,0.01968862674063483},
{0.07348265881047135,0.2022103801631068,0.118473543450798},
{0.05535639990399817,0.232087166357549,0.07107986237904351},
{0.05234843436562805,0.23653653467790903,0.030113352299883274},
{0.057694759579379966,0.216821775634929,0.0004511260615388143},
{0.06448675126655705,0.1965795566998753,-0.02796225120157014},
{0.07128823310563846,0.1774850959915111,-0.01780503789527686},
{0.043627397380855616,0.29784429136416807,0.08309040607534765},
{0.04475486868861917,0.2785600276177174,0.050835580367488926},
{0.049185256705170544,0.2552245693155881,0.061250678236399646},
{0.04370964536402641,0.3160626322517998,0.11584931014160267},
{0.04123622294704977,0.3422527007390627,0.10547065995754186},
{0.040850977795107615,0.32226217713712374,0.0726422989824219},
{0.04158577687552565,0.3013288275742552,0.04030838867536047},
{0.04387627317608564,0.27966033508488525,0.00897919662425668},
{0.04754139734922177,0.2583494425223448,0.01958340983908689},
{0.04093480747026247,0.2997430094371996,-0.0012350951318959326},
{0.03919845351785489,0.32276488011118604,0.03014292306306342},
{0.03888844188898035,0.3452441616654253,0.06252015797664458},
{0.03711330209835511,0.34210278384666115,0.02081231574147998},
{0.038298470778928284,0.31787470111179195,-0.01059321014015856},
{0.04115507527134613,0.2936218614589114,-0.04048718863877527},
{0.044513282430359125,0.27645225112592403,-0.031097439790831537},
{0.038196898645865354,0.38915193114275864,0.0860674254662037},
{0.035283353242021566,0.3836270122732421,0.045187564600082906},
{0.036488396226220465,0.4080937241900533,0.07802899172637552},
{0.03968547711051007,0.4113066219941835,0.1188710295233124},
{0.038107567433374664,0.43159010245925594,0.11078583271612959},
{0.033892427065088,0.42285366116994316,0.07175586377918476},
{0.03257976025675675,0.3973884202266771,0.0389440074160723},
{0.031931404081728086,0.37142116400151565,0.0065509555826506125},
{0.0348507948689912,0.3585764497066649,0.012790386613659338},
{0.0372094414632989,0.36597257896253377,0.053207430651402626},
{0.039589062668699486,0.36691059107829443,0.09537877740711169},
{0.04088439963442284,0.3874897791751682,0.12820369992139677},
{0.04235867410199438,0.40671077524225674,0.16047709331776397},
{0.04128525539855543,0.4321038085079899,0.15109422139149006},
{0.035548664880042415,0.4473863915347845,0.10444668632090877},
{0.030516890063467108,0.43395094966849795,0.06703554474503468},
{0.029195008180098327,0.4077395627240587,0.034256697605937234},
{0.028437171412086466,0.3810853020240843,0.001871210386352318},
{0.028522032625491783,0.3544502967047854,-0.029568700103635215},
{0.03226802939746475,0.3453796370223204,-0.02488139029350015},
{0.03554900872612591,0.33332851948816444,-0.018630268495652774},
{0.05874259613420726,0.21603436810373697,-0.03861322748375503},
{0.06576400192828884,0.1948658278197614,-0.06594830342903944},
{0.07198692834729004,0.17630845469380851,-0.05535165482804599},
{0.05243618388613468,0.2373514498957802,-0.010167528688798009},
{0.04815798214613596,0.2574623196269407,-0.02083707265949132},
{0.053787086378950015,0.2351625257282832,-0.04929858837428884},
{0.060119699698584515,0.2131893856089411,-0.07656489510287534},
{0.06651207346752959,0.191968580720275,-0.10279416204365609},
{0.07280390664166218,0.17431345971739975,-0.09236874879224068},
{0.07945664066502584,0.15650979720645686,-0.08194127246432427},
{0.07916505918622635,0.1548448944701985,-0.11806918045661387},
{0.08415151508899768,0.13692707505953694,-0.1432449029975814},
{0.08706664218482552,0.12102969523546234,-0.16809190868273258},
{0.09428947301461553,0.09202559040091765,-0.18480832987768023},
{0.09661043407817271,0.06741721389770855,-0.20374118292680413},
{0.09351857009543103,0.046793325809981016,-0.22390156649398718},
{0.07960999601826235,0.13710106117778284,-0.17684691766055377},
{0.07221042830155851,0.1380762086705604,-0.20765277597258586},
{0.07204813295015125,0.15251843186930547,-0.18508134366797124},
{0.07690117657252848,0.15349770551508485,-0.15277631643192296},
{0.06964946267172532,0.16937445457415007,-0.1618235945807106},
{0.06448558218987317,0.16664156590257187,-0.19244652677632607},
{0.0645877044766697,0.15174340279711912,-0.2139293423806115},
{0.06223146480494643,0.13954236837056153,-0.2345209089364909},
{0.06955524884484908,0.12643151720708953,-0.22965754993160903},
{0.07683722120099935,0.11212545705740645,-0.22394145263967202},
{0.0798032375171837,0.12316841787476987,-0.20051590666366836},
{0.07232045904827529,0.1719292309744804,-0.12814455839503652},
{0.06559813057761328,0.1882619199402533,-0.13776124565808356},
{0.062441279685092,0.1838971377564318,-0.16999475290876595},
{0.057028110792709634,0.1788336603309587,-0.19859449474912644},
{0.05708690847298641,0.16357239576134053,-0.21905746286978064},
{0.05504824504397447,0.15092092296541113,-0.23832590969639078},
{0.0511107947727143,0.1406866881364161,-0.2560367337647914},
{0.057681693428207344,0.12980395959395905,-0.2537597849999209},
{0.06440842312873804,0.1173037790747652,-0.25052281796994647},
{0.0710949916067171,0.10365033879154607,-0.24643930188241975},
{0.07754554413298866,0.08930851864918003,-0.24162270594489244},
{0.08389569360288114,0.0971619631960906,-0.21757892471077386},
{0.08721380830855921,0.10761832259502016,-0.1928048143953226},
{0.09054705224191086,0.0820801862820542,-0.21077627379500857},
{0.0889529817988514,0.06041581994568608,-0.23024071288920797},
{0.08221634933111621,0.04205443908732247,-0.24977392120010533},
{0.06853409474610062,0.039199141210021854,-0.27329230561865137},
{0.05452381099743559,0.02469296263974764,-0.2876520057573588},
{0.037432047417750296,0.011216259243442333,-0.29582247639324716},
{0.03711254563697143,-0.0019619857523936806,-0.28694574590187044},
{0.01869841878940046,-0.002166918018153708,-0.2969640453904338},
{0.0,-0.015730270627498474,-0.2911571727324554},
{-0.018061684611993763,-0.015730270627498474,-0.2877331534330625},
{-0.016956013145923463,-0.029464858586421238,-0.27972704122508235},
{-0.015332371939683894,-0.04342294649961249,-0.2741959331260629},
{-0.013395280643734882,-0.05689139758991404,-0.27142109523229896},
{-0.011349465216186348,-0.06915707508016772,-0.27168241825575135},
{0.0,-0.06931937043157498,-0.27337964252385777},
{0.011349465216186348,-0.06915707508016772,-0.27168241825575135},
{0.022249454832034627,-0.06896795973424824,-0.2675487006400351},
{0.058970978702861276,0.20316971073604378,-0.1464963115630624},
{0.05532029606523173,0.19640281981296145,-0.1768971191887433},
{0.0524117020449902,0.21597660196171067,-0.1539275131194473},
{0.05459106729136622,0.22411818952658585,-0.12187418121651372},
{0.04875070402485594,0.23725310991590207,-0.12964647808772062},
{0.045892861686537535,0.22601003067794756,-0.15963191964454568},
{0.04833045534161452,0.2062292531869374,-0.18213802119329717},
{0.04978031673725826,0.1884558491313416,-0.20317589996554664},
{0.060476336856380306,0.2087970957384404,-0.11277601384736945},
{0.05486655677345838,0.2305955620473696,-0.0867496160958478},
{0.04981758965270858,0.2464035418897368,-0.0960506526542511},
{0.04478560852848318,0.2599290714298977,-0.1040148156400454},
{0.04284982384765142,0.24752172935324612,-0.13565209378195625},
{0.03939437701622747,0.23359527527973595,-0.16385572493413628},
{0.04142891429223754,0.21367902243183076,-0.1859767188693791},
{0.042673637114471176,0.1957790830175107,-0.20646857006104646},
{0.04281000647118329,0.18014990313855828,-0.22530789697546108},
{0.049860295336278025,0.1729635199936182,-0.22274968211429585},
{0.04818810306304968,0.16002803033272608,-0.24086555686904762},
{0.04489178819906488,0.14948846018159198,-0.2572415704413402},
{0.04009946779503197,0.14118251418880864,-0.2715937059662109},
{0.045472956849379596,0.1326771374676011,-0.27182683361081716},
{0.0512032205999564,0.1222916103618705,-0.27118315374252394},
{0.05709632985567405,0.11041104048512555,-0.2696777955890049},
{0.06295835542544419,0.09742053545087503,-0.26732726376226756},
{0.06859529934896183,0.08370520287262773,-0.2641459997978185},
{0.07381343874278869,0.06964877497955835,-0.2601491329233313},
{0.08356353828622985,0.07474251086037854,-0.2361858116727493},
{0.049351334363496195,0.25327564971436706,-0.05956308165863098},
{0.045166865065856834,0.26968467251067474,-0.06894732896923887},
{0.040964722079526096,0.28370190195022615,-0.07699470270723777},
{0.03958362990058034,0.27048996003820813,-0.110192354376026},
{0.036888495528969376,0.2552699569986088,-0.14012621902032746},
{0.03289589234591741,0.2390576141620574,-0.166843747399664},
{0.034572692156664524,0.21905402440894578,-0.1886731598561073},
{0.03563937147686706,0.20107568808758997,-0.20875033267108575},
{0.03583818328234096,0.18536467284076694,-0.22703400431458065},
{0.03491151808733552,0.1721630463112536,-0.24348085018007223},
{0.041519620889062185,0.167047991973257,-0.24247338115544662},
{0.03889992634816892,0.15635988031405523,-0.25768100573604036},
{0.035048643905431325,0.14797416202990224,-0.2706474415444466},
{0.02994693079547416,0.14176086330123872,-0.28121933322742876},
{0.03393925890165933,0.13494858469513576,-0.283640009655198},
{0.038333336771794166,0.12669834176787775,-0.2853331077703026},
{0.04306101411213095,0.11677081764535575,-0.2863295737202564},
{0.047945554035755865,0.10547341072620979,-0.286551698290191},
{0.05281015088653835,0.09311420710124685,-0.28591970918873644},
{0.057478136546781286,0.07999991747693998,-0.2843558972010241},
{0.061772636591137436,0.06643794025192913,-0.2817825531121853},
{0.06551684536347625,0.052734986132687435,-0.27812128001518427},
{0.07841822549288616,0.055637047077342655,-0.25535385544298034},
{0.037736419970855604,0.30826901692341646,-0.04854625314361287},
{0.03391044459986287,0.31969433458562074,-0.05481181647696681},
{0.03647643038251501,0.2946389581738747,-0.08324719988941912},
{0.03422980884220834,0.27844930917883365,-0.11481089496946303},
{0.030866581530376393,0.2608437020119809,-0.14330610760044263},
{0.02637725829511484,0.2427237011042273,-0.16884286852907462},
{0.027718876943675946,0.22265615597958652,-0.1904852287160994},
{0.028608819376964648,0.2046166150553695,-0.21029970312329155},
{0.028846760866739696,0.1888395813605164,-0.22823058868512566},
{0.028232514223193242,0.17555680715529945,-0.2442208069517426},
{0.026991642477094693,0.16478067089872425,-0.25776421648824493},
{0.03301053063015296,0.16145361619487544,-0.25766243804753186},
{0.03028637564909544,0.15321712711095703,-0.2691517110812653},
{0.02642415890090287,0.14737449446029577,-0.27803944464731367},
{0.021108917373098442,0.14384732133585576,-0.2844184771882193},
{0.02357573794527208,0.13759344876934046,-0.2892419500474163},
{0.02653927856965531,0.13062506404133303,-0.2930978400276727},
{0.029890333730131714,0.1225577472304917,-0.2961931424712493},
{0.033519835449018286,0.11300639072330775,-0.29873829118124196},
{0.03728240560221547,0.10221031139389011,-0.3005716784984104},
{0.0410330099117072,0.09040813842418088,-0.3015337598400153},
{0.04462640779182733,0.07784056407262303,-0.3014629275468164},
{0.047917358656909693,0.06474552982899158,-0.30020032472824126},
{0.05076069069050483,0.05136304025956253,-0.29758434372504966},
{0.053011232076163275,0.03793309993061185,-0.2934547522623353},
{0.0,0.03829757677911122,-0.3232847753894229},
{0.017538557180572144,0.05121862490449676,-0.32264866013496646},
{0.018284015489578368,0.03801837375931737,-0.31950315616320035},
{1.4911916948792377e-19,0.02493227951385664,-0.3179475964814918},
{0.018760586161295445,0.024655139570563745,-0.3140992711150722},
{0.03610782738101378,0.037717852282347135,-0.30920909211567804},
{0.03461333476373304,0.05102400802124142,-0.3127562083129604},
{0.032701000385795306,0.06411972995703988,-0.3145063848779243},
{0.016577369838784325,0.06410666380586723,-0.32380604605199365},
{0.0,0.05144968947260201,-0.32627554862361846},
{-0.017538557180572144,0.05121862490449676,-0.32264866013496646},
{-0.018284015489578368,0.03801837375931737,-0.31950315616320035},
{-0.018760586161295445,0.024655139570563745,-0.3140992711150722},
{0.0,0.011489960725900344,-0.30997793195836165},
{0.018915041821999136,0.01127746384630355,-0.3061694927376269},
{0.03708166825867403,0.02438693962544158,-0.30363947325530777},
{0.030473634226164073,0.07682071658899181,-0.31468587253350605},
{0.015453680837939151,0.0765339489553612,-0.3232442015515711},
{0.0,0.06425382992960096,-0.3272046207412083},
{-0.016577369838784325,0.06410666380586723,-0.32380604605199365},
{-0.032701000385795306,0.06411972995703988,-0.3145063848779243},
{-0.03461333476373304,0.05102400802124142,-0.3127562083129604},
{-0.03610782738101378,0.037717852282347135,-0.30920909211567804},
{-0.03708166825867403,0.02438693962544158,-0.30363947325530777},
{-0.018915041821999136,0.01127746384630355,-0.3061694927376269},
{0.0,-0.0020555118871029465,-0.30063013233260366},
{0.0,0.08827354193787525,-0.3240178552394235},
{0.012931569815540328,0.09940659042911303,-0.31803630877103223},
{0.014220648782544172,0.08834987576841004,-0.32123132657882086},
{0.0,0.07657383510104603,-0.3263566962993222},
{0.02803411503301954,0.08894060333984577,-0.3135202343104751},
{0.025485046477675105,0.10029577640101804,-0.3112350332396009},
{0.011639602541435172,0.10955486373723557,-0.3139280357654942},
{0.0,0.09921816277536052,-0.32047142673430806},
{-0.012931569815540328,0.09940659042911303,-0.31803630877103223},
{-0.014220648782544172,0.08834987576841004,-0.32123132657882086},
{-0.015453680837939151,0.0765339489553612,-0.3232442015515711},
{0.020469913811540712,0.11996927391397932,-0.3042075069852332},
{0.022929444846744362,0.1107005588874241,-0.3080551446594858},
{0.010397905564736245,0.118645466492543,-0.3091760828916631},
{0.018209469658677743,0.12791761997993314,-0.29991699555544554},
{0.009259706259167796,0.1265291694948007,-0.30404865009466087},
{0.0,0.12616469264630134,-0.30544260211712915},
{-1.4911916948792377e-19,0.11829955733255211,-0.31089875176994775},
{0.0,0.10927222225660684,-0.3160034907254396},
{-0.011639602541435172,0.10955486373723557,-0.3139280357654942},
{-0.025485046477675105,0.10029577640101804,-0.3112350332396009},
{-0.02803411503301954,0.08894060333984577,-0.3135202343104751},
{-0.030473634226164073,0.07682071658899181,-0.31468587253350605},
{0.023690376229507634,-0.09346493010640661,-0.2863055044944121},
{0.02825988437143904,-0.09481452598410468,-0.28387863883714004},
{0.03214823342197685,-0.09697277908095445,-0.28169796697564675},
{0.03539585968053948,-0.10010459797859764,-0.27989621349815935},
{0.03804326821576204,-0.10437489125867609,-0.27860472760857113},
{0.04013075778862956,-0.10994863627204828,-0.27795348312644114},
{0.048576374060526534,-0.11199458923803018,-0.2618305402715972},
{0.04989935625136249,-0.12015632618339786,-0.2618944956431262},
{0.018399203927547503,-0.09275908286621844,-0.2888492778200708},
{0.012566817890174184,-0.09250360522618538,-0.29113929273611394},
{0.015230112114453982,-0.09608015464821451,-0.3030061087695193},
{0.019721773503083267,-0.09697876200280715,-0.3010833214706435},
{0.023712038532767498,-0.09851204045830556,-0.29923205415713355},
{0.02719629966598791,-0.10082089813972392,-0.29756371296004025},
{0.03016981182679235,-0.104046105633643,-0.2961903917025814},
{0.032627967477662036,-0.10832863983429368,-0.2952255595923086},
{0.034566227850294916,-0.11380927132825677,-0.2947799350681056},
{0.04172400300108861,-0.11665349736166901,-0.27781525700087817},
{0.0428883346090023,-0.12431713887049312,-0.27806145079665695},
{0.008585011474143806,-0.09676337681610905,-0.32054982364134377},
{0.005243845327028571,-0.09552553091554522,-0.30597968969954037},
{0.010362351879703384,-0.09565082842836896,-0.304728777647804},
{0.0126724474070223,-0.09743208867928031,-0.319174439307384},
{0.006373606649708177,-0.09250504937973604,-0.29280900931754117},
{0.0,-0.09256996752029895,-0.2934877614863503},
{0.0,-0.09553894091280132,-0.3064872065187716},
{0.004333512820988914,-0.09647530256736117,-0.3215490403599656},
{0.007184182530005728,-0.09602974681237487,-0.33822351233272746},
{0.01065860966523833,-0.0970083327659873,-0.3370035464285051},
{0.013991784829373258,-0.09859807074839476,-0.3356625467028943},
{0.016513758313338685,-0.09862289643562273,-0.3176408857750187},
{0.02002697128678895,-0.10047712082545066,-0.31616647376901386},
{0.023177564180590714,-0.10310479259548089,-0.3148344140415737},
{0.02593115238639497,-0.10661608003086362,-0.3137279173449031},
{0.028253213757419335,-0.11112094510909892,-0.3129274436625385},
{0.030109294916098116,-0.11672941857690358,-0.3125175791310184},
{0.036042840471234176,-0.12032281645702371,-0.2947531150735934},
{0.037116190405456426,-0.12770416033130258,-0.29504469655239285},
{0.0436892209066671,-0.13276722514147546,-0.2785627783863854},
{0.04419219895759621,-0.14183151679447425,-0.279190641334838},
{0.05180976509123268,-0.1490942750314791,-0.26343217532849333},
{0.051976186595641814,-0.15960750657261788,-0.26389774292553875},
{0.022647078442982412,-0.10805266896768466,-0.3322901043160248},
{0.022616888756851992,-0.11428639215370745,-0.35091693435084276},
{0.020273027544134365,-0.1085405865601569,-0.35169746496036486},
{0.02003969359187808,-0.10404892517152763,-0.33326662719313627},
{0.01767678330613511,-0.10375314877050955,-0.35249656325839557},
{0.01876423092978044,-0.10826468446276456,-0.37177051162234137},
{0.021420373155523646,-0.11527893825830955,-0.3710862579161965},
{0.02375068683255177,-0.12312818788300155,-0.36917584907632633},
{0.024611058502660335,-0.12096477709489944,-0.34992596993822467},
{0.024905321980911038,-0.11300363995463981,-0.3315109490908366},
{0.017136669878189084,-0.1009211636576696,-0.3344040700373211},
{0.014925464484481881,-0.09994993601024386,-0.35354323073653887},
{0.015982997498863588,-0.1023175226027223,-0.37216043308101915},
{0.01775311713666988,-0.10659572434272102,-0.39147495528281695},
{0.021554885743384915,-0.11650358046926738,-0.39349677025373786},
{0.024676870643040315,-0.1268409003540927,-0.3872318946125509},
{0.02670583761249784,-0.13571106338527472,-0.38427481829453713},
{0.025649061059499812,-0.13140146849785336,-0.3671457817994016},
{0.026230573555898026,-0.1283329172795723,-0.3490354085819857},
{0.026760784216639535,-0.11897322057932563,-0.33096973535542334},
{0.013277341437097828,-0.09766927370767169,-0.37318440671765213},
{0.01477183405437857,-0.09963841145860197,-0.3916812629329109},
{0.012076493375117509,-0.09418473749758449,-0.3929259857551444},
{0.010612534290050676,-0.0941329542774109,-0.37459898950512993},
{0.00955837096728717,-0.08998843989467308,-0.3947552469193111},
{0.011207044168404809,-0.08960223197369716,-0.41236704331566654},
{0.013856584549345009,-0.09561238643623478,-0.4104827667781416},
{0.016871839624685123,-0.10290453663645635,-0.4097813207678221},
{0.012057513071308864,-0.09705213875702391,-0.354772824331099},
{0.009111508597183625,-0.09498080995008042,-0.35611932559404563},
{0.00795398514172304,-0.09152171835017148,-0.3761462968808347},
{0.007108811468504729,-0.08680318731565552,-0.39671516959520386},
{0.008796614353923525,-0.08476644942471112,-0.4148771197251433},
{0.010724834420918495,-0.08384452930565785,-0.43183560856286785},
{0.013324585888969348,-0.09037162197011427,-0.4289541783832221},
{0.0162837940527006,-0.09784057782646638,-0.42722119412243265},
{0.019728787963186462,-0.10605148476177312,-0.42746876330254535},
{0.02044054935601067,-0.11111723157139723,-0.4118581511121014},
{0.026113115733777857,-0.1258304054839324,-0.40835092106050397},
{0.027886605063202344,-0.13348022438020024,-0.40259493762288195},
{0.029617801324357575,-0.14198205260982616,-0.39970663052156635},
{0.02811258070927195,-0.14431901627010899,-0.38283066474387933},
{0.02700910985813598,-0.13968789091001618,-0.36610117739775905},
{0.027450539460120386,-0.13614829806504056,-0.34855746252593456},
{0.029344031072682873,-0.13326277611700119,-0.33060044466175514},
{0.02823361453066041,-0.12578501780091175,-0.33066646310978526},
{0.03154272046895104,-0.12327569785281875,-0.31243849453181577},
{0.006106878365823349,-0.09363327714888328,-0.35736404841627933},
{0.00530004353091417,-0.08975716901891773,-0.3775904504314925},
{0.004710650082282367,-0.08458469238497833,-0.3985100461510214},
{0.006498917916375257,-0.08099727742671092,-0.4174559653513179},
{0.008373614902014182,-0.0783419604315681,-0.43525343863275795},
{0.010685773505834035,-0.07683440166311474,-0.45164801989355907},
{0.013262968670807947,-0.0840483612639507,-0.44749435920500036},
{0.016152238541157344,-0.09205351070289704,-0.44432409831522296},
{0.01943865063793764,-0.10067153140105588,-0.44271489864449},
{0.023207341251420942,-0.10972417354874603,-0.443265052378074},
{0.023786034209934536,-0.11480436189387673,-0.43057025497562473},
{0.024750453704907163,-0.11988908900730948,-0.41830182671670324},
{0.030908874598645657,-0.13504790807481265,-0.42103196461961334},
{0.03239848460154084,-0.14209959295500635,-0.41684391932270576},
{0.03372641817597905,-0.14995519685532127,-0.4145676582500023},
{0.03085379045607057,-0.15047914951734326,-0.3983518769526159},
{0.02898574345368634,-0.1527854627377438,-0.38239741867868204},
{0.02789582013823988,-0.14801095356083566,-0.36577177284977574},
{0.028288561134802104,-0.14427675758644806,-0.3484584348538895},
{0.030112251992416128,-0.1412301093636853,-0.3307730553956671},
{0.033314971952474966,-0.138518133410905,-0.31303266056408635},
{0.03259688379171455,-0.13059391158616887,-0.31262967295423616},
{0.0026492446733083976,-0.08876104691504731,-0.37865637329031127},
{0.002346756396740614,-0.08328894280395478,-0.3998235381899529},
{0.004285670076932122,-0.07829918597878194,-0.4197391033456912},
{0.00615992693958418,-0.073946575946316,-0.4386300071726293},
{0.00833565429439689,-0.07059022555615385,-0.45617991127395674},
{0.0111457020271102,-0.06849482752336607,-0.4721274926262207},
{0.013743459187876811,-0.07657479787007981,-0.4665021707003252},
{0.016578332607818096,-0.08539279945039642,-0.4616539409231168},
{0.019706369198542916,-0.09471591092735977,-0.4581742185581984},
{0.023183684640876834,-0.10431086711793026,-0.4566337881041634},
{0.026786778980551377,-0.11416322648660134,-0.45757592637292593},
{0.02719629966598791,-0.11921253745343463,-0.4463940517378325},
{0.02814868454803839,-0.12410622368288038,-0.43642939223829363},
{0.02943920766859289,-0.12921735817552518,-0.4277713478560165},
{0.03580029144394036,-0.14490757761121872,-0.4344007003457029},
{0.03723110376655876,-0.15175213648763974,-0.4315467778527362},
{0.03837287907139551,-0.1593712155440436,-0.4300201012420409},
{0.034710849513010796,-0.15819746255344228,-0.41359113537289083},
{0.03161032060896517,-0.1589532362449532,-0.39801490779079585},
{0.029413763058414637,-0.16123114777885744,-0.3824730648170499},
{0.02837397250194101,-0.15639412738397085,-0.3658900559024962},
{0.028762656114718056,-0.15258431277890216,-0.3487060040340022},
{0.030558564208786092,-0.14951074140780213,-0.33118360761935417},
{0.03374030955775204,-0.14688259513017668,-0.31358762814283914},
{0.03828671124287293,-0.14440907643629666,-0.2961807640122437},
{0.03784473148715494,-0.1357879611233864,-0.295554276448125},
{0.04446507520945384,-0.15134130918708597,-0.27980956428511994},
{0.04457558734068751,-0.16112792518459376,-0.2802826964960021},
{0.05201545381837637,-0.17024582931893031,-0.2640923598087941},
{0.05199220982313245,-0.18082418530828206,-0.26386817216235864},
{0.044463149671386294,-0.19050118317437328,-0.27970778584440686},
{0.04415623265726316,-0.19982560126645388,-0.27897195522573837},
{0.04357953400603381,-0.20870068129662983,-0.27814603693319556},
{0.04265190604199461,-0.21699644944534188,-0.27734006171349507},
{0.04459174810661154,-0.1710227151599675,-0.2804731872262555},
{0.038582556413107684,-0.1626607222555753,-0.29725700225356727},
{0.03857217226138629,-0.17199002296204147,-0.2974426791386518},
{0.04458129518567344,-0.180856988224647,-0.2802448734268182},
{0.0385100048894913,-0.15341690168546473,-0.29679281004085584},
{0.033940084132259705,-0.15555789370892328,-0.31415634956493155},
{0.033981345662278506,-0.16441461235824084,-0.31460128639696755},
{0.03393107536487227,-0.17332338930459879,-0.31478283712905025},
{0.03854665888199134,-0.18125419922029462,-0.29721642841571544},
{0.0384348401356404,-0.1903358619774313,-0.29668896852364185},
{0.030750567861806882,-0.1580011952089862,-0.33167599521091173},
{0.03075613816835942,-0.16659824129605216,-0.33209273666410155},
{0.030643012806891225,-0.17519831322865284,-0.33227635047268517},
{0.03385652953397165,-0.18215486965138822,-0.3145634633277837},
{0.03369884172008315,-0.19080624341964558,-0.3140559465085525},
{0.0333992830121467,-0.1991747006304074,-0.31337031741807353},
{0.038165264806184276,-0.19911789725741486,-0.2959717055934818},
{0.03766668798512384,-0.20748291600734178,-0.29517398267978506},
{0.03686779599474328,-0.21531366671274202,-0.2944072059136025},
{0.035697206388110074,-0.22249317293601228,-0.29378140604165076},
{0.028891392088376693,-0.16942018610325424,-0.34951197925370275},
{0.028682264900398106,-0.1777904313136502,-0.3497052207526241},
{0.03047886068663312,-0.1836981884125245,-0.33206935513042424},
{0.030219875816548485,-0.1920126617881784,-0.33158728292137135},
{0.0298223209748174,-0.20005652829612575,-0.3309449784374121},
{0.029242321401186544,-0.20774472041531106,-0.3302572862704322},
{0.032899193268318916,-0.2071575000739269,-0.3126200452638984},
{0.0321398435775397,-0.21465210684810737,-0.31191584848491105},
{0.03106250502874897,-0.2215551608202517,-0.31137050859649595},
{0.02960837994166995,-0.2277643333959133,-0.311094744037537},
{0.034083674256725115,-0.22890383931659902,-0.2934066138106467},
{0.03195581715365588,-0.23442807049394865,-0.29339492304380804},
{0.033810798004867484,-0.24179875513963933,-0.27651139265228425},
{0.03007793615328383,-0.24549578822932333,-0.27722246635294145},
{0.02980382205552564,-0.2533636743117405,-0.2614784418821034},
{0.028510204320219733,-0.16477461920765485,-0.3662469681371589},
{0.02894083715518255,-0.16099183090474845,-0.34911793164202315},
{0.029457981664751443,-0.16959458483680032,-0.38283066474387933},
{0.031903277472098604,-0.16738613021176105,-0.39818683083254086},
{0.03178341272739401,-0.1756966149728465,-0.39863383074107767},
{0.029179810183208067,-0.17781415669341102,-0.3832501569657371},
{0.028371152964056394,-0.17308929889095886,-0.3666375772880034},
{0.02422161842849961,-0.23323767535290643,-0.32935228337868666},
{0.023142904495374927,-0.22898980083747153,-0.34711674743611165},
{0.02596952560931245,-0.2278234749222736,-0.3290717049745588},
{0.02771880817445925,-0.23317647075004522,-0.3112020240155859},
{0.027359695324862342,-0.2217133300186571,-0.32920580494711993},
{0.024560513128387314,-0.22291128977353608,-0.34706173206275337},
{0.02263648798361092,-0.22509127394286238,-0.3647141022969606},
{0.02110430983557968,-0.23117047269896482,-0.36501118531309595},
{0.021444304842934546,-0.2344872120203089,-0.34763595502218153},
{0.022072236560603906,-0.23786996978968308,-0.3301623847513889},
{0.025334992046840088,-0.23768979444193436,-0.3118030669695263},
{0.02924239017040324,-0.23894964649184156,-0.2938549891035176},
{0.023148406032710768,-0.22183161307137764,-0.38182663418008866},
{0.023972398787186093,-0.218601522963073,-0.3648220699671765},
{0.025724225813350717,-0.21631494650786479,-0.34735056277288484},
{0.025120982244475936,-0.2117376674444465,-0.3652051145041842},
{0.02458705804603274,-0.21518438058534983,-0.38206044951686186},
{0.02502449903344866,-0.2196241212153721,-0.39820746159755027},
{0.02322020109494347,-0.2259873368364372,-0.39813869238085225},
{0.02155928697325359,-0.22819689176894367,-0.38193666492680556},
{0.01982953486564902,-0.2342754028328791,-0.382534957112078},
{0.019366786806488238,-0.23680404693086426,-0.3658446682194756},
{0.019437619099687168,-0.23934094333485312,-0.3487410763345182},
{0.01957151276459816,-0.2417588689939545,-0.3313520922002642},
{0.022518823853840655,-0.24137238599611177,-0.31276308523463026},
{0.026016563753533877,-0.24256140575282004,-0.29466302739971906},
{0.02739834362464661,-0.2018238971652641,-0.3484728763893961},
{0.026661137621644144,-0.20926472641198676,-0.3478608303607839},
{0.0284360023354026,-0.21499182677859544,-0.3296390510123173},
{0.02689254603583289,-0.19703556537579972,-0.36626759890216826},
{0.027902146906176095,-0.19357571731450707,-0.383360187712454},
{0.02753354390467486,-0.18926945773409554,-0.366685715739692},
{0.02796287012452042,-0.19405558890862562,-0.3490649793451658},
{0.02838181219264458,-0.1860233443983003,-0.34951610540670464},
{0.02802338703521465,-0.18127524260060418,-0.3668521372441012},
{0.028640728293512517,-0.1858283836689615,-0.3834977261458499},
{0.030508775295896746,-0.19162535355973534,-0.3994315536547744},
{0.02945564351138371,-0.19908124326491483,-0.39932152290805767},
{0.026973762480753213,-0.20105299424607964,-0.38297508009894515},
{0.026091384661301294,-0.20453718661008335,-0.36573051131975687},
{0.031301684364424584,-0.18380340531407244,-0.3991220921796334},
{0.03433248128273844,-0.1912471916371131,-0.41488399664681297},
{0.03324572135126009,-0.19885870607968012,-0.41520721196529353},
{0.03183767163936872,-0.20597824554598979,-0.41508342737523723},
{0.02817124085111533,-0.20620827857584453,-0.3989707999028979},
{0.02586540901523169,-0.20825691354127768,-0.38249369558205926},
{0.025838589020719477,-0.24831738919044186,-0.27815428923919927},
{0.021177342743712947,-0.25037358876971183,-0.27918720287400306},
{0.022351439580397744,-0.24535756210376036,-0.29569319026585494},
{0.018320394405211608,-0.24743232937153878,-0.296820317727535},
{0.01617837084350258,-0.25177648079035087,-0.28020223651246545},
{0.0,-0.2585117378737521,-0.2650620057642357},
{0.005505333396601013,-0.2530624651426033,-0.2817034685129826},
{0.0063420140715571205,-0.2584030825113693,-0.2648268150431286},
{0.0,-0.26664644851695746,-0.24919694747200924},
{0.012588686501084146,-0.2579547072184984,-0.26423677516385985},
{0.01092625945662691,-0.2526354083069087,-0.2810811071018658},
{0.009453016527305848,-0.2497918011964468,-0.29886551423213326},
{0.004763100363857926,-0.25026424571516204,-0.2995332633262707},
{0.0,-0.2531676820441512,-0.2819503500009284},
{-0.005505333396601013,-0.2530624651426033,-0.2817034685129826},
{-0.0063420140715571205,-0.2584030825113693,-0.2648268150431286},
{-0.007274957896047076,-0.2665082223913945,-0.24897413520990774},
{0.012093341833208517,-0.24814133999569507,-0.3164553044791454},
{0.013996461136108721,-0.2488785459986975,-0.2979192498103689},
{0.01583617522121338,-0.24652870186412715,-0.31522433550025136},
{0.01371684550101469,-0.24746258782688585,-0.3342747839099289},
{0.010463305089816036,-0.24935305359391363,-0.335708622078082},
{0.00816517540620257,-0.249203824393679,-0.3175081611867916},
{0.004113485712163693,-0.24978561196694402,-0.31824743026629504},
{0.0,-0.25039009338171936,-0.299798024810558},
{-0.004763100363857926,-0.25026424571516204,-0.2995332633262707},
{-0.009453016527305848,-0.2497918011964468,-0.29886551423213326},
{-0.01092625945662691,-0.2526354083069087,-0.2810811071018658},
{-0.012588686501084146,-0.2579547072184984,-0.26423677516385985},
{-0.014444079967595945,-0.2659676963481483,-0.24841504147815305},
{0.0,-0.2516410054334558,-0.3381072923565079},
{0.0030848632764818216,-0.2548965401519387,-0.3580455513537564},
{0.003554680811119157,-0.2514037516358477,-0.3377744493476896},
{0.0,-0.24995615962435502,-0.3185383240529275},
{0.00705916009404878,-0.25065347948167266,-0.3369251495214694},
{0.006131215791612769,-0.2539227680434951,-0.35703464386829586},
{0.005377622084271173,-0.2587916285857129,-0.37775549655156765},
{0.00270221072400919,-0.26004116525311544,-0.3789933424521315},
{0.0,-0.2552211308547532,-0.35843959896543587},
{-0.0030848632764818216,-0.2548965401519387,-0.3580455513537564},
{-0.003554680811119157,-0.2514037516358477,-0.3377744493476896},
{-0.004113485712163693,-0.24978561196694402,-0.31824743026629504},
{0.007154267920742103,-0.26255605550776095,-0.3967633080468924},
{0.007999441593960412,-0.2567718766912929,-0.3759606199957501},
{0.009100574291728645,-0.2523005022215895,-0.35557879955079946},
{0.010540876766251369,-0.254030735713711,-0.3738218973564426},
{0.009468420831846198,-0.25926201002792715,-0.3940744316740009},
{0.008729082983126097,-0.26552207182394527,-0.4144851351899646},
{0.006559221642497725,-0.26944054179139687,-0.4178754575731757},
{0.004794699818930652,-0.2650420626913933,-0.3989983075895771},
{0.0024049076463804353,-0.26661550236944337,-0.4005387380436121},
{0.0,-0.2604737236261458,-0.3794678500473477},
{-0.00270221072400919,-0.26004116525311544,-0.3789933424521315},
{-0.005377622084271173,-0.2587916285857129,-0.37775549655156765},
{-0.006131215791612769,-0.2539227680434951,-0.35703464386829586},
{-0.00705916009404878,-0.25065347948167266,-0.3369251495214694},
{-0.00816517540620257,-0.249203824393679,-0.3175081611867916},
{0.014654169924608306,-0.24711324020606007,-0.3520193048945114},
{0.01676964856867191,-0.24494357141923845,-0.33277286421724467},
{0.019331920813622356,-0.24429576539794337,-0.31394866653050363},
{0.017161426796200363,-0.24355030708893718,-0.3502595006392098},
{0.01527536225904126,-0.24657408954714782,-0.3693126998175552},
{0.012975100729710158,-0.2506156564124888,-0.37154013474640313},
{0.011954359246261877,-0.25003043037838885,-0.353849941443012},
{0.015987536267165654,-0.24556043129301947,-0.38578774106189306},
{0.013900184232731533,-0.25066104409550943,-0.3883390790013885},
{0.015139267979195936,-0.2500104873055465,-0.4038671681317949},
{0.01302262025844847,-0.25563993538444396,-0.40717496745496823},
{0.011722125601472762,-0.25526239238477205,-0.3911861245726853},
{0.01741484135973246,-0.2419541735693768,-0.3673465879121597},
{0.01796905247710157,-0.24006439549451603,-0.38376592609097204},
{0.017231090012715427,-0.2441444731212078,-0.40119892252391276},
{0.017053046510684327,-0.2490710998054519,-0.418171165204977},
{0.01480223004815908,-0.25529402622445313,-0.42158211835319737},
{0.012600996190873086,-0.26147018957609963,-0.42575640980676543},
{0.010884722849741324,-0.2608657081613243,-0.41081285901829195},
{0.001995180653293805,-0.05928387863883714,-0.4667634937237774},
{0.0042394640402327426,-0.050991686489393374,-0.4879375355450889},
{0.002104104215621753,-0.04812882399825601,-0.4910802887481871},
{0.0,-0.05844008034995279,-0.4677744012092379},
{0.0,-0.04710416266945595,-0.49229750388374155},
{0.0023464881967954917,-0.03508536666714806,-0.5168206065582451},
{0.004714377373827398,-0.03848119058769485,-0.5130451765615255},
{0.007125041003645456,-0.04375097566326191,-0.5075298853823464},
{0.0064373419597438765,-0.055480940955438235,-0.4833918903213517},
{0.004025853099325442,-0.06167979814859515,-0.46419152501927263},
{0.0020074765892394058,-0.06873758285830997,-0.44362265230490344},
{0.0,-0.06805401684433193,-0.4444478829052794},
{-0.001995180653293805,-0.05928387863883714,-0.4667634937237774},
{-0.002104104215621753,-0.04812882399825601,-0.4910802887481871},
{-0.0023464881967954917,-0.03508536666714806,-0.5168206065582451},
{0.0,-0.033856460764754945,-0.5182716370305728},
{0.002734594148152274,-0.019966454376094723,-0.5442457701774039},
{0.0054763609256061494,-0.023966072019249874,-0.5397757710920346},
{0.008232500469349903,-0.030127106143222906,-0.5332014339757066},
{0.011010157900998461,-0.03807132605617482,-0.525176066387051},
{0.009599907574172757,-0.050604515799383694,-0.5008523944409716},
{0.008729014213909399,-0.06138546590112775,-0.47795224528054053},
{0.006127516007754416,-0.06549373890666572,-0.46051237192593014},
{0.004049330909906137,-0.07072363783654795,-0.4415458219606241},
{0.0021287511028863127,-0.07667678261844295,-0.4213964414681128},
{0.0,-0.07613446857556258,-0.42206350287008326},
{-0.0020074765892394058,-0.06873758285830997,-0.44362265230490344},
{-0.004025853099325442,-0.06167979814859515,-0.46419152501927263},
{-0.0042394640402327426,-0.050991686489393374,-0.4879375355450889},
{-0.004714377373827398,-0.03848119058769485,-0.5130451765615255},
{-0.0054763609256061494,-0.023966072019249874,-0.5397757710920346},
{-0.002734594148152274,-0.019966454376094723,-0.5442457701774039},
{0.0,-0.01850717159776334,-0.5459512467515142},
{0.0032806492364210026,-0.0025857225478444724,-0.5736102257074461},
{0.00655118252106573,-0.007264780051975786,-0.5683906421600686},
{0.009801470148314569,-0.014431907816240402,-0.5606747360465539},
{0.013021382412547907,-0.02361259824542221,-0.5512052149072407},
{0.016200789608146127,-0.03433371912863901,-0.5407247862824668},
{0.013816560865226776,-0.047419813374099735,-0.5163667297280383},
{0.01216039181948906,-0.05874816644075979,-0.49359724207933353},
{0.0,-0.08287178873546476,-0.40035993808019726},
{-0.0021287511028863127,-0.07667678261844295,-0.4213964414681128},
{-0.004049330909906137,-0.07072363783654795,-0.4415458219606241},
{-0.006127516007754416,-0.06549373890666572,-0.46051237192593014},
{-0.0064373419597438765,-0.055480940955438235,-0.4833918903213517},
{-0.007125041003645456,-0.04375097566326191,-0.5075298853823464},
{-0.008232500469349903,-0.030127106143222906,-0.5332014339757066},
{-0.009801470148314569,-0.014431907816240402,-0.5606747360465539},
{-0.00655118252106573,-0.007264780051975786,-0.5683906421600686},
{-0.0032806492364210026,-0.0025857225478444724,-0.5736102257074461},
{0.0,-0.000867867514728656,-0.5755976560700181},
{0.003996921889860598,0.017245256471355205,-0.605175296171824},
{0.00796457560109453,0.011805611430544113,-0.5991511127890801},
{0.011873761724291831,0.0035120438967664027,-0.590217991540011},
{0.015695198326982494,-0.007055033941046914,-0.5792149168683324},
{0.019399658492069878,-0.019315209893964746,-0.5669877501394297},
{0.022957846533240633,-0.032689447157390035,-0.5543617219536784},
{0.019329582660254627,-0.046121450562841664,-0.5299761577125708},
{0.016661337052372573,-0.05779227432865771,-0.5074198546356298},
{0.014837783733191943,-0.06788346918692093,-0.4863695974043747},
{0.017663373308879,-0.07770818333047941,-0.47977462952303734},
{0.02066845054014781,-0.08792295647114891,-0.4744312613856034},
{0.02388444295902936,-0.0982270608243091,-0.4709309082556758},
{0.027124642142188606,-0.1085850802433605,-0.4698856161618662},
{0.030202614743157292,-0.11896173612013707,-0.471879923446108},
{0.03029242734016487,-0.12425834119021635,-0.4615301563330604},
{0.031143790242885994,-0.129137929730239,-0.4525351427889631},
{0.032510028271024984,-0.13396378888125549,-0.44496365203051436},
{0.034144397475069435,-0.13909922641508138,-0.4388913301960817},
{0.038556561649195846,-0.1496726929131259,-0.4525076351022839},
{0.0404409069559375,-0.15559991170032578,-0.44963308184430784},
{0.04194275787940492,-0.16253879443436975,-0.44790697450518824},
{0.04303357519466846,-0.17023283193697436,-0.447095497748152},
{0.03916179952535487,-0.16750317541858104,-0.4294768244301267},
{0.03528720431815665,-0.16661873452262815,-0.41347422770450426},
{0.022504657395200873,-0.08008642915154603,-0.4918092424451858},
{0.02552252570077551,-0.0912466414833795,-0.4864658743077519},
{0.028454913869994547,-0.10222991062064905,-0.4836050748931155},
{0.031149016703355042,-0.1129773013446445,-0.4838457671515585},
{0.03345209777057076,-0.12343008474430572,-0.4878137509550325},
{0.032931721107817065,-0.12932168107725603,-0.47751899921534324},
{0.03347726730388222,-0.13458161152407025,-0.469039754796481},
{0.034787871035712535,-0.13950147131739124,-0.4621146946749933},
{0.03657662713124398,-0.1444191992649946,-0.4566406650258332},
{0.019554114152773562,-0.0688084151515089,-0.4990162563551353},
{0.0223975837248021,-0.058501284952814,-0.519702036737891},
{0.025394752496150644,-0.07100009008767387,-0.5106451308987656},
{0.028310911130228954,-0.08314377098750532,-0.5035412708138631},
{0.031022687652280834,-0.09484939197697055,-0.4990162563551353},
{0.03340664131833339,-0.10603408614994853,-0.4976958873945338},
{0.03533933138441373,-0.11661498660031813,-0.5001990868823407},
{0.03521114556448868,-0.13352931872400092,-0.4961348261754894},
{0.03512539035126628,-0.1396295677373346,-0.48740113565484455},
{0.03611793645586838,-0.14511840339884977,-0.48064112165343204},
{0.0378666688672816,-0.15030433816849698,-0.4755590765394505},
{0.04005497411182837,-0.15551450033318684,-0.4719074311327872},
{0.042366307485047855,-0.16107586688755338,-0.46944549317499906},
{0.04448412428247918,-0.16731550422621222,-0.46792569348597357},
{0.04609181103044482,-0.17456047874377895,-0.46711421672893716},
{0.047184760191425985,-0.1825425904951315,-0.4668460167838151},
{0.04368495721523183,-0.17842551502985615,-0.4469510823930862},
{0.03953404729534109,-0.17588628047249955,-0.42960060902018316},
{0.03539111460458732,-0.175011329728451,-0.41379744302298477},
{0.035060265903053285,-0.18325944080999135,-0.41434071983489895},
{0.043555396010972816,-0.19528091881175044,-0.4477212976201037},
{0.03886196574055162,-0.19246165600399961,-0.4306459011139926},
{0.042762143096361484,-0.20348192297985268,-0.4482233129019991},
{0.04732890046962498,-0.208229749700682,-0.46756121663747413},
{0.04633442882695533,-0.2164992480086154,-0.46776752428756807},
{0.04150462919982202,-0.2112583460040615,-0.4485602820638192},
{0.03786818179004896,-0.2003353874698361,-0.4311547933175577},
{0.039425667009825055,-0.18425886383626325,-0.4300544858503898},
{0.043868433485382066,-0.18686033453473153,-0.4472399131032178},
{0.04780801560235988,-0.19964542591870515,-0.4672311243973237},
{0.050920097734810765,-0.2144210422800021,-0.4903788427378675},
{0.05031451601256826,-0.2232874573888741,-0.4903031965994999},
{0.04915740517240786,-0.23169930797537233,-0.4899593505160098},
{0.04483766682552356,-0.2242055264317923,-0.46771938583587946},
{0.03979901508727845,-0.2184041553111498,-0.4485602820638192},
{0.03646969099927861,-0.20772085749711686,-0.4313954855760007},
{0.047463137980619456,-0.23936707563719833,-0.4892579045056903},
{0.04285181815493567,-0.2311017034822668,-0.46727238592734266},
{0.04524629351114302,-0.24600468043288845,-0.48808882782182456},
{0.04897695474779233,-0.2569341720427002,-0.5137947610235336},
{0.046600772003226654,-0.263306327661936,-0.5115803922458583},
{0.04252138206870182,-0.25132329165231104,-0.4863558435610351},
{0.04039008650479768,-0.2369388345955923,-0.46627523228522166},
{0.037661392755438096,-0.2247151063275244,-0.4480445129385844},
{0.05080951683436039,-0.24926777976520814,-0.5154864837543041},
{0.05086941482210435,-0.26939240333970826,-0.5450228623260913},
{0.04897496044050809,-0.2770952433020502,-0.5419557552613607},
{0.04653330940164592,-0.2831998866683309,-0.5383109867763674},
{0.043565986470344306,-0.28733979351354993,-0.5340954337927806},
{0.04369884859700482,-0.2680589682279342,-0.5087883620479198},
{0.04042247680586244,-0.27153112597901574,-0.5056456088448216},
{0.03942374147175751,-0.25561380308209875,-0.48429276706009533},
{0.03756662877482826,-0.2419576120302117,-0.4649823710112995},
{0.0351827438779924,-0.230376188246103,-0.4472536669465573},
{0.03260362317495095,-0.2206824794603542,-0.43065277803566243},
{0.03469173167076875,-0.21445886534918598,-0.4311547933175577},
{0.05219528532004162,-0.2604585943984722,-0.5474848002838794},
{0.05022717910736181,-0.2829358128762106,-0.5834167160085797},
{0.04891568137571443,-0.29225816789179027,-0.5792493014766813},
{0.04705299837223264,-0.3000407801455019,-0.574366687091124},
{0.044662167784510286,-0.3058765358744934,-0.5688445189902754},
{0.04176636483857458,-0.30935625823941176,-0.5627859509991824},
{0.03851894488766205,-0.3108960010012798,-0.556328521551241},
{0.04023143592187542,-0.2898966329903812,-0.5295085270390244},
{0.036687826954644634,-0.29125138655933164,-0.5247496972435236},
{0.036922811368101674,-0.2740618331535018,-0.5023928248950067},
{0.03608870953877174,-0.25916779620105096,-0.48215404442078785},
{0.03449567063396278,-0.24639666496806703,-0.46363449436401893},
{0.03245425643628291,-0.23557376564413718,-0.44642155942451167},
{0.030274684882256785,-0.2265251121110155,-0.4301026243020784},
{0.028252869911335847,-0.2190739674817882,-0.41427882753987066},
{0.03015715829091992,-0.2126887457113797,-0.4147051966833983},
{0.02668451915532146,-0.21304359486954133,-0.3985444307593703},
{0.05208050949737267,-0.24063655537744325,-0.5166968219681888},
{0.05277198397127097,-0.23136577727438712,-0.5174807910385459},
{0.05293090963106003,-0.25066035640334244,-0.5493484460563949},
{0.05096431634114758,-0.272482891938116,-0.5867726537834417},
{0.04713779081642126,-0.2955590902932938,-0.627291476261898},
{0.04643655111375184,-0.3067444033892221,-0.6221612926962278},
{0.04519994305908857,-0.31650825677600286,-0.6160064478017575},
{0.04345107310924196,-0.32440158746859826,-0.6090057415419021},
{0.04121284141337245,-0.3299753324819704,-0.6013379738800761},
{0.038508285659073854,-0.33278042883108144,-0.5931681909363548},
{0.03547666351015962,-0.3332597502714664,-0.5845926696141153},
{0.03225730139965986,-0.3318582336351614,-0.5757076868167348},
{0.03507319451579251,-0.31091113022895334,-0.5496441536881963},
{0.03158253784541918,-0.3098156366069543,-0.5428635089217744},
{0.03309346630549074,-0.29178572337307507,-0.5200252520563715},
{0.033351075791241414,-0.2759901219897135,-0.4992500716919085},
{0.032651555318989445,-0.2622768524879671,-0.4801872448232254},
{0.03129143775113658,-0.2504946225911003,-0.46248604844516245},
{0.029566843334784362,-0.24049282771454444,-0.44578200570922044},
{0.027774304932334525,-0.23211948788939707,-0.42973127053190924},
{0.02617356387525539,-0.22521643391725274,-0.41398311990806935},
{0.05095950249597871,-0.20538662397473692,-0.4903031965994999},
{0.05286585395206373,-0.22178347461968903,-0.5179002832604037},
{0.047758364227903936,-0.1909936395351476,-0.46694229368719226},
{0.05042289629808429,-0.1964780533360291,-0.4901725350877736},
{0.05234437698184286,-0.2122169888848315,-0.517989683242111},
{0.05254559570990118,-0.22993606525923588,-0.551191461063901},
{0.053054900528766505,-0.24036354158715226,-0.5505862919569587},
{0.0511040553894779,-0.26130583114819145,-0.5892277148195598},
{0.047280762017936385,-0.28340275585758995,-0.6312181985353532},
{0.041852601436313856,-0.30544466519363,-0.6739582667131546},
{0.041717057310202116,-0.3186153455756293,-0.6684223447689664},
{0.04108376159363032,-0.3305584954395694,-0.661387253900762},
{0.03997396397455814,-0.34078516565472766,-0.6531211940536634},
{0.03840912044859535,-0.3488077824747152,-0.6438854882511231},
{0.03641075578056843,-0.35413602138447564,-0.6339345825949239},
{0.03400011965843706,-0.35628162094545296,-0.6235504308735272},
{0.031296320365522136,-0.3557156502920285,-0.6127605407736125},
{0.02841825987749452,-0.35290849086641646,-0.6015924199818588},
{0.0254851152468918,-0.3483325871873321,-0.5900942069499546},
{0.02898931945295463,-0.3290180649855344,-0.5666095194475907},
{0.025812044103074052,-0.3251848688467884,-0.5573806905667203},
{0.02820019269134519,-0.30802557389630564,-0.5361516333720504},
{0.029606729480469197,-0.2918813125842853,-0.5155277452843229},
{0.029858356044367144,-0.27765571241813886,-0.49645116457230026},
{0.029247822938522385,-0.2652311780373128,-0.4786330605258507},
{0.02806794948763495,-0.25449148946558753,-0.46177084859150336},
{0.026611623785621596,-0.24532042672674342,-0.44557569805912633},
{0.02517166515718236,-0.237600394460227,-0.429745024375249},
{0.023967928788100723,-0.23120004346214493,-0.4140243814380881},
{0.05138160794807099,-0.2197444673445936,-0.5511501995338822},
{0.04949856925644659,-0.2384146219859312,-0.591070729827066},
{0.050623152257108846,-0.2498138073457902,-0.5906924991352271},
{0.046842358261486694,-0.27072308768281433,-0.6337764133965185},
{0.041468800437922365,-0.2915367788086283,-0.6777336967098744},
{0.034767859193653425,-0.311127065569385,-0.7198548419373939},
{0.035086948359132106,-0.32622534709542894,-0.7148415660401103},
{0.034967840075811184,-0.34037598881537456,-0.7076964444251891},
{0.03442917080141582,-0.3530535939136492,-0.6987770770194596},
{0.033489439455237774,-0.36373276557468026,-0.6884204329847422},
{0.0321672824950022,-0.37188948236722896,-0.6769772353261966},
{0.030481336378434247,-0.37699697209138877,-0.6648050839706521},
{0.028450168794042382,-0.378531213315921,-0.6522547019232686},
{0.026169368953036815,-0.3769921582462199,-0.6392985814973672},
{0.023734457297411044,-0.372880446779847,-0.6259367226929474},
{0.021241091807591983,-0.3666960311221967,-0.6121553716666702},
{0.01878472415635644,-0.3589395511708303,-0.5979407745751955},
{0.022615788449384822,-0.34245694531265575,-0.5782934093645793},
{0.019898854236080597,-0.3354837467394795,-0.5659080734372712},
{0.02282608471404728,-0.32044460673979586,-0.5477323694639922},
{0.025052556873861438,-0.3056647266870636,-0.5294122501356474},
{0.026364879836109203,-0.2917726572219025,-0.5114634845774717},
{0.026549662721376703,-0.27939626129276496,-0.49441559575803967},
{0.025944080999134193,-0.2684172558469307,-0.47799350681055947},
{0.024885241369635224,-0.2587166701395121,-0.4619496485549181},
{0.02365248439110704,-0.25028625186450537,-0.4461327287143802},
{0.022525356929426966,-0.2431170610237398,-0.4304120857772194},
{0.021681902486626107,-0.23711144532950426,-0.4146020428583512},
{0.021300508410819045,-0.2321703771097536,-0.3985031692293516},
{0.01929444159052195,-0.23821037741233816,-0.3994659382631235},
{0.051189397987400104,-0.20299242369539636,-0.5178108832786962},
{0.04930010129705619,-0.1879880809193619,-0.4901037658710756},
{0.04938303697239397,-0.194437601907383,-0.5174120218218478},
{0.04954134370923275,-0.21015460007605877,-0.5504556304452326},
{0.04770719993068063,-0.22751607652363356,-0.5902798838350392},
{0.04412961897040103,-0.24559412820920146,-0.6340514902633104},
{0.04579967939791175,-0.25797052413833893,-0.6347735670386393},
{0.04054433585785128,-0.27737857247484593,-0.6794735578923337},
{0.03399186735243329,-0.2956058533606485,-0.72238554911188},
{0.026401877674692723,-0.3116194531609427,-0.7607175104993402},
{0.0270050524743508,-0.3283675081955714,-0.7574372188628461},
{0.0272514525777797,-0.34453583873343613,-0.7512686201250361},
{0.027155863366569496,-0.35956672642711596,-0.742644960351108},
{0.02673313899152694,-0.37290520369785835,-0.7319926086845893},
{0.025998064834242118,-0.3839935521982424,-0.7197310573473374},
{0.024965426276305085,-0.3922768043495154,-0.70629355240455},
{0.023650077468522608,-0.39719724180425664,-0.6920995860780847},
{0.02206687256170146,-0.39819989698371333,-0.677575527511469},
{0.02028753784885764,-0.39581910670162895,-0.662686992096354},
{0.018384143469090643,-0.3905905831560807,-0.6473858413810509},
{0.016428346946199778,-0.383048663160812,-0.6316308138355412},
{0.014492218419284539,-0.3737297466060672,-0.6153875248514757},
{0.012641501259508203,-0.36311315493223134,-0.598539066760468},
{0.016445745558024367,-0.3499754837742471,-0.5831141314551086},
{0.014304478457699022,-0.34016899347311363,-0.5675103961863344},
{0.017422887358086125,-0.32761173450406045,-0.5526424915362287},
{0.020131844342253385,-0.3148832401854293,-0.5373413408209257},
{0.022265821905608746,-0.30285756726145163,-0.5225628361525273},
{0.023505111959723244,-0.29169357262269974,-0.5080456545075814},
{0.02353007518538462,-0.2815494254675791,-0.49354222670597525},
{0.02280724194867203,-0.2722195058381626,-0.4787774758809165},
{0.021803073846447966,-0.2634988814686904,-0.46346257132227386},
{0.020753311753553133,-0.2556220553881025,-0.44780382068014135},
{0.019893696544828244,-0.24882215524100512,-0.4319937777612732},
{0.01936162911523589,-0.24303935180887107,-0.4159155348972829},
{0.01733527537601288,-0.2548669693887586,-0.4347307925858533},
{0.014908478487957478,-0.26140210805156866,-0.4388982071177515},
{0.012593362807819608,-0.26811192052479166,-0.44402839068342165},
{0.010441230171255981,-0.26736027298628257,-0.43032956271718187},
{0.01888127613660042,-0.26916821569327276,-0.46677037064544724},
{0.01797792370605561,-0.26155752648130615,-0.4509190661965603},
{0.019879736393838554,-0.27724722327095275,-0.48181019833729793},
{0.02080784574239464,-0.28534342315280725,-0.4955502878335565},
{0.01720420124898651,-0.28410695263657737,-0.48791690478007954},
{0.016179677458619843,-0.2760533896690756,-0.47232004643297515},
{0.015390275620143603,-0.26832510509655544,-0.45582231134712714},
{0.008314954760170796,-0.2727263349652268,-0.43492334639260755},
{0.010369985262756861,-0.27468006841161674,-0.4496468356876475},
{0.00821826524149342,-0.28079021331523324,-0.45529278837855264},
{0.006214062066968839,-0.27732974633099033,-0.4391664070628736},
{0.012958045963969055,-0.2755252420848351,-0.46192901778990875},
{0.0,-0.2751002483256415,-0.42336324106567524},
{0.002062904577897986,-0.2832810343440345,-0.4450736827772311},
{0.0021911385362747304,-0.274396739238821,-0.42262053352533696},
{0.0,-0.26717459610119804,-0.4011301533072148},
{0.004378728580967844,-0.2724546965592698,-0.4206881185361234},
{0.0041321428006538576,-0.2809284394407962,-0.4426736371144712},
{0.004057363154416462,-0.29036151289525963,-0.46479669412621494},
{0.002022206955456115,-0.29316523386003673,-0.4677468935225587},
{0.0,-0.2841461510900952,-0.44600206720265395},
{-0.002062904577897986,-0.2832810343440345,-0.4450736827772311},
{-0.0021911385362747304,-0.274396739238821,-0.42262053352533696},
{-0.0024049076463804353,-0.26661550236944337,-0.4005387380436121},
{0.0062719451166635375,-0.2957372025645416,-0.48172767527726024},
{0.0041568171956050965,-0.300652138481947,-0.4869197511379587},
{0.006674327557406822,-0.30606358814391194,-0.5027297940568267},
{0.004432911846804191,-0.31169785006797834,-0.508884638951297},
{0.0020710606069983682,-0.3039448085774468,-0.4904819965629146},
{0.006118410963463603,-0.28612739222316436,-0.4604917411609208},
{0.0084311747363904,-0.28962980842959307,-0.4754559227144036},
{0.008945706015724768,-0.29915984647960064,-0.4953095955751136},
{0.00977609430735301,-0.30917952135249793,-0.5146474993105886},
{0.00733403065319065,-0.31696350899054354,-0.5233261744578751},
{0.00489028215321919,-0.32338517844580195,-0.5305331883678246},
{0.002211466716730656,-0.3155159169790508,-0.5131139457782234},
{0.0,-0.3051854052466786,-0.4918505039752046},
{0.0,-0.29420915056951225,-0.46888846251974536},
{-0.002022206955456115,-0.29316523386003673,-0.4677468935225587},
{-0.004057363154416462,-0.29036151289525963,-0.46479669412621494},
{-0.0041321428006538576,-0.2809284394407962,-0.4426736371144712},
{-0.004378728580967844,-0.2724546965592698,-0.4206881185361234},
{-0.004794699818930652,-0.2650420626913933,-0.3989983075895771},
{0.002445419591937222,-0.3277754052398017,-0.5354845719700799},
{0.0,-0.3169710736043803,-0.5147437762139658},
{0.0,-0.3294616264332364,-0.537396356194284},
{0.0027749410475889857,-0.3406187441503185,-0.5574425828617484},
{0.0,-0.34255459760036694,-0.559650074717754},
{-0.0027749410475889857,-0.3406187441503185,-0.5574425828617484},
{-0.002445419591937222,-0.3277754052398017,-0.5354845719700799},
{-0.002211466716730656,-0.3155159169790508,-0.5131139457782234},
{0.005533563160055537,-0.33560202979220005,-0.551707230189136},
{0.006367369281753669,-0.34823355951528706,-0.5722485952168259},
{0.0032020253909701892,-0.35394277988555434,-0.578822932333154},
{0.0,-0.35614545789639085,-0.5813467625859701},
{-0.0032020253909701892,-0.35394277988555434,-0.578822932333154},
{-0.006367369281753669,-0.34823355951528706,-0.5722485952168259},
{-0.005533563160055537,-0.33560202979220005,-0.551707230189136},
{-0.00489028215321919,-0.32338517844580195,-0.5305331883678246},
{-0.004432911846804191,-0.31169785006797834,-0.508884638951297},
{-0.0020710606069983682,-0.3039448085774468,-0.4904819965629146},
{-0.0041568171956050965,-0.300652138481947,-0.4869197511379587},
{-0.0062719451166635375,-0.2957372025645416,-0.48172767527726024},
{-0.006118410963463603,-0.28612739222316436,-0.4604917411609208},
{-0.006214062066968839,-0.27732974633099033,-0.4391664070628736},
{-0.006559221642497725,-0.26944054179139687,-0.4178754575731757},
{-0.007154267920742103,-0.26255605550776095,-0.3967633080468924},
{0.009459343295242064,-0.339915235063498,-0.562627781800777},
{0.008259526771512215,-0.3282946128258715,-0.5433517703603301},
{0.010936574839131609,-0.3194880269355268,-0.5332633262707347},
{0.012441314069700352,-0.32988524480809606,-0.5509507688054581},
{0.010941938838034054,-0.3516816480405243,-0.5809891626591406},
{0.012215957346581034,-0.30070440308663754,-0.5052742550746524},
{0.01125697061972755,-0.2915340280399604,-0.4872979818297975},
{0.010649119513334008,-0.2827597636814637,-0.468661524104642},
{0.013653302744785746,-0.28367026811054513,-0.47939639883119833},
{0.014682365303454483,-0.2921440109920716,-0.4960798108021311},
{0.01604867210081017,-0.3005462338882321,-0.5116216537758771},
{0.01354836092010461,-0.3099724304210258,-0.5223427746590938},
{0.01999403083199061,-0.2986296358188591,-0.5140010686736275},
{0.018391226698410538,-0.29200578486650863,-0.5021315018715543},
{0.02144898114967001,-0.2918063541380845,-0.5057969011215572},
{0.01783687804260803,-0.30831302922210324,-0.5255336663138807},
{0.015276531335725126,-0.31904102702698983,-0.5382147098729901},
{0.014491255650250766,0.023880798190544374,-0.6221062773228695},
{0.022996769909891693,0.03198318730190167,-0.6413822887633164},
{0.017505685494990507,0.0456854537289764,-0.6556519012281495},
{0.009742328621954297,0.033425965468225516,-0.6323185060025212},
{0.011793301740755182,0.056542049969088244,-0.6671982527117422},
{0.020768853596526877,0.06793504609944442,-0.6901671710888712},
{0.027186465668000103,0.05266965537682437,-0.6742058358932675},
{0.033170900443492676,0.03527379432090053,-0.656422116455167},
{0.028192971923591895,0.01626735820990977,-0.6254690920194013},
{0.019093360400897024,0.011776040667363987,-0.6095008799021278},
{0.004895639275199964,0.03971284725875588,-0.6391954276723203},
{0.005933531801292723,0.06372086850019151,-0.674976051120285},
{0.014026375745372346,0.08009550668815017,-0.7031026607497634},
{0.02413263106209241,0.08963998627366433,-0.7249781485813942},
{0.031443348950822445,0.07293663122988929,-0.7073044598900106},
{0.03812537866049944,0.05405260432462096,-0.6876639716010643},
{0.04417755111443954,0.034040074573338595,-0.6674389449701852},
{0.03867628885546705,0.016692351969103358,-0.638005720223445},
{0.03303604400954792,-0.0006402414074583071,-0.6089644800118834},
{0.0234998167300375,-0.002188924167497049,-0.5954444520090584},
{0.007067343630835841,0.08817245118932919,-0.7118225974270685},
{0.016350431423680954,0.10303004045693018,-0.7393371610279347},
{0.00825381892652628,0.11197141401200299,-0.7490336205823515},
{0.0,0.09119004441803705,-0.7151303967502419},
{0.0,0.11533010255553287,-0.7527196505973638},
{0.009449578066470949,0.13402226334621378,-0.7859214284191539},
{0.018674212025122768,0.1242900437991141,-0.7752071844576068},
{0.02744882022970294,0.10980999753118513,-0.7593971415387388},
{0.0,0.06639048949240753,-0.6779262505166288},
{-0.007067343630835841,0.08817245118932919,-0.7118225974270685},
{-0.00825381892652628,0.11197141401200299,-0.7490336205823515},
{-0.009449578066470949,0.13402226334621378,-0.7859214284191539},
{0.0,0.13770141643955633,-0.7900063198910146},
{0.010611502751800206,0.15322744249346176,-0.8217914518488261},
{0.020922896641930377,0.1427985907812114,-0.8100112850284601},
{0.030633935270287092,0.12737296778368504,-0.7926608116555569},
{0.039444578544417006,0.10841810858521778,-0.7714592621475663},
{0.03554845857239232,0.09188667658318772,-0.7400042224299054},
{0.042748114176155094,0.07182532068804975,-0.7185688575851414},
{0.04913484886933092,0.0507619973056221,-0.6966589851451614},
{0.054795793249476143,0.029834149280089456,-0.6758356663290099},
{0.049598697235958875,0.0139491479150205,-0.6479841335663236},
{0.043656830605602354,-0.002133221101971678,-0.6201738623336559},
{0.03746794494886665,-0.01791575633416062,-0.5929274986779118},
{0.027661660955383218,-0.017314713380220188,-0.5808791319124239},
{0.04143049598422159,-0.034736706738489234,-0.5784240708763055},
{0.03152992939464521,-0.032902631729153815,-0.5667539348026565},
{0.03505586467318461,-0.04825329628047938,-0.5539972451051791},
{0.04486558712750294,-0.0502792374044022,-0.5665132425442135},
{0.03819036557027904,-0.06266663640821131,-0.5435512010887542},
{0.029518567344662374,-0.06045776916787185,-0.5312621420648233},
{0.026340535533398112,-0.04659664585022478,-0.5421758167547944},
{0.048066519087927626,-0.02025872354706119,-0.6041231271563448},
{0.05185955400412203,-0.03674201709740266,-0.5910569759837265},
{0.054937251528223915,-0.051477197159281195,-0.5814843010193662},
{0.047693239779690935,-0.06441612528100821,-0.5577933058669082},
{0.04085077148745753,-0.07601996782976043,-0.5360484795470034},
{0.03246257751150337,-0.07369254245983363,-0.5224665592491503},
{0.06412956395502768,0.02491096105668028,-0.6838816646826748},
{0.059818009144930434,0.01017853176346966,-0.6576668392774006},
{0.06873476332042534,0.008538385945222556,-0.6709668057867921},
{0.06428855838403344,-0.007068787784386506,-0.6437273190527177},
{0.05438771671759027,-0.005170757403521945,-0.6306749217234391},
{0.0591823752749909,0.04436233399970703,-0.7023943378177739},
{0.05359136918822754,0.06561683580455513,-0.7244898871428385},
{0.06269263117212316,0.05637287769601117,-0.7263466559936843},
{0.06709447996374487,0.03815178603971145,-0.7081021828037072},
{0.07152204844241163,0.024234959656539018,-0.6980068617924421},
{0.07547490301821215,0.012840588141848883,-0.6933993242736767},
{0.07265055128842565,-0.005314485066420757,-0.6629001766681177},
{0.06797809562909735,-0.02196832627417324,-0.634099628714999},
{0.058543440482649874,-0.022267472366809492,-0.616886693775492},
{0.06136373482865118,0.08438876888660576,-0.7708884776489732},
{0.051060043090791186,0.09958745346902874,-0.7753172152043237},
{0.05758995529313222,0.07736330570873899,-0.7497419435143409},
{0.06602113002952262,0.06321747783396221,-0.7449212214238117},
{0.047054511295,0.08740017288581076,-0.7481258669219379},
{0.04307442410938707,0.12142511823147578,-0.8008168407559388},
{0.05478004509885231,0.10719607960449448,-0.7991388718685078},
{0.06514590420860729,0.08508058720658751,-0.7863821821710305},
{0.0698626472434891,0.06224783187852056,-0.7553672654402364},
{0.07208595601933515,0.04160881456311946,-0.72581025610344},
{0.06852542982479666,0.04767288409154831,-0.7261816098736091},
{0.07593978292309056,0.03314951321709958,-0.7260440714402132},
{0.07890236077844003,0.023857416656867053,-0.7272956711841165},
{0.07845398548556912,0.0021861733988291264,-0.6916319554045384},
{0.07552854300723658,-0.017205370325670388,-0.6589046851779644},
{0.0706569316963509,-0.034582663693085734,-0.6288731682459516},
{0.061919871484087834,-0.03729698467615544,-0.6069770496493114},
{0.02489500659840634,0.16725086116251608,-0.8735334104923945},
{0.011696268375994315,0.16849145783174785,-0.8559353679393786},
{0.023021458058686276,0.1574780677775646,-0.8430205090434959},
{0.036277137192524234,0.15038589845950076,-0.8527032147545729},
{0.033604559123990206,0.14125540955850852,-0.8240195744698409},
{0.0,0.1571933632204349,-0.8262889586208747},
{0.0,0.17269669543283,-0.8608729976982943},
{0.012660550332533547,0.17871744035473913,-0.8876723614455014},
{0.026468515045673074,0.17104142038690937,-0.9008416664431667},
{0.0385683211852512,0.15369094701400624,-0.8779621480477451},
{0.0493067031418592,0.13245638828200054,-0.8498217845749272},
{0.046380848048226474,0.12980602267045996,-0.8272242199679674},
{0.05120604013784102,-0.087961192155633,-0.5522986454527388},
{0.04295442182624907,-0.08818833687838647,-0.5320873726651992},
{0.0444185184497493,-0.09904789019481632,-0.5323074341586327},
{0.051731299414980274,-0.0971138935136187,-0.5567205060864195},
{0.04516040075948723,-0.10847456811212684,-0.5373069562125767},
{0.03990650137297741,-0.11826035887903426,-0.5207817134400494},
{0.03889456234926647,-0.10858480516649373,-0.5149432069423899},
{0.037250152839584105,-0.09786141489912586,-0.5136847302768167},
{0.035072919438925716,-0.08619554251691208,-0.5164011143363875},
{0.049833406572549116,-0.07701939085603234,-0.5528556761079925},
{0.05855176155787032,-0.07528200536537429,-0.5749305946680476},
{0.05889113764227491,-0.084140512014326,-0.5789811015315592},
{0.051347017032071895,-0.10432523988422013,-0.5667401809593168},
{0.04509727061855847,-0.11634451727104492,-0.5477186156206525},
{0.04018639208493823,-0.1267827215967662,-0.5318260496417467},
{0.03735757035606637,-0.13563357423189942,-0.519186267612656},
{0.03669745464498236,-0.12650908888352488,-0.5071585316121774},
{0.06437080636720423,-0.05021184357203816,-0.6012967123500574},
{0.05720085906505499,-0.06435904683114888,-0.575941502153508},
{0.04222519305238357,-0.12691764679992765,-0.5872334075353182},
{0.049991300694087706,-0.10944304499088463,-0.5830109776300615},
{0.04414646742849205,-0.12253354046621402,-0.5641544584114724},
{0.03815164850127808,-0.13994630705867872,-0.5720010260367131},
{0.03963465665937025,-0.13404650449509986,-0.5486882615760943},
{0.05819244240062332,-0.09073149128109485,-0.5887600841460136},
{0.05642885583840334,-0.0948516613611216,-0.6049621116000602},
{0.0476021205675661,-0.11231505378784284,-0.6061655728922751},
{0.039250855660978766,-0.12937277660526264,-0.6175743859424718},
{0.03563772101566631,-0.14437678241213528,-0.6023695121305461},
{0.03391553352189852,-0.1575598343762185,-0.5919716065658098},
{0.036090016153889,-0.15124186889974067,-0.5609773206000251},
{0.037196169004476184,-0.14390545883165226,-0.5369218485990679},
{0.0659121308210563,-0.06951673808349822,-0.6040681117829865},
{0.06489028903014085,-0.07556952946038858,-0.6136476636690166},
{0.07206601294649273,-0.05320399219056776,-0.6319540291540217},
{0.07069750553420272,-0.05884581872847094,-0.6412585041732599},
{0.06271876347446839,-0.07883592971510976,-0.6297052757679975},
{0.06446646434763113,-0.06065719989629602,-0.6799068039575309},
{0.07226475598274992,-0.04342776034478135,-0.6857040489251716},
{0.06812058544609559,-0.06147211511416722,-0.6569447625020717},
{0.05943138860865433,-0.07902545767632943,-0.6530180402286164},
{0.07515581385273347,-0.040780145501908685,-0.6715100825987061},
{0.07780686715644103,-0.021593534043169195,-0.7043061220419781},
{0.07478102162172942,-0.02536827634772192,-0.7150409967685346},
{0.06842014415403204,-0.04221948520739764,-0.7070775214749071},
{0.05986552867366875,-0.05597264085482887,-0.7110523822000511},
{0.055062205194964166,-0.07584770094193197,-0.6843424184345513},
{0.04960041646637633,-0.09486699689644526,-0.6593448081648315},
{0.05357376426875285,-0.09629787798828035,-0.6282611222173397},
{0.04411751558826219,-0.1127890799985421,-0.6368297666179094},
{0.035354941996604175,-0.13027434103617327,-0.6525297787900607},
{0.0322218164838437,-0.1475438730410229,-0.6371942434664086},
{0.030806339696548952,-0.16290072682185128,-0.627325860870247},
{0.03081266646448517,-0.176687235539381,-0.6220100004194923},
{0.03376169678414512,-0.1692632547507494,-0.5856379617079247},
{0.03570160761797875,-0.16114202287401685,-0.5535502451966422},
{0.036488258687787066,-0.1524417541926872,-0.5283600811201681},
{0.08006180977196815,0.0060475649164213295,-0.7344751774073868},
{0.07816171631460266,-0.00138432433213057,-0.7401898993149899},
{0.07573209988866264,0.01974845595916208,-0.7797115681513253},
{0.07295932507139964,0.01005749794208119,-0.7817883984956047},
{0.07517713230990984,-0.007478652315906523,-0.7465372980162144},
{0.07966776216028866,-0.01544006453303295,-0.696954692776963},
{0.07682690581849465,-0.03518508203136015,-0.6628451612947593},
{0.07703321346858863,-0.027154900597535718,-0.6589115620996343},
{0.08000335593777486,-0.007363120031853897,-0.6927872782450646},
{0.08045104353847878,0.014550190868960932,-0.7299776706353382},
{0.07748365183796047,0.029298437082012106,-0.775612922836125},
{0.07070988399320835,0.041336488464995415,-0.82131006733194},
{0.06827256541499815,0.027855658915688242,-0.8200584675880367},
{0.06524630726498636,0.012175589816379314,-0.8123494383961919},
{0.06982963801947406,-0.001759116563134614,-0.7770570763867829},
{0.07215678831253408,-0.011435633044708933,-0.7519425584486764},
{0.07103378700385589,-0.024741101091436242,-0.7326734239298994},
{0.06388804646598434,-0.036249629505845045,-0.7372534537619857},
{0.054262900589283417,-0.04845891623840637,-0.7475825901100238},
{0.04965976430038669,-0.0701844871776357,-0.7208726263445241},
{0.04461396056360499,-0.09127524947752588,-0.6954211392445976},
{0.03966567157610104,-0.11141170135729801,-0.6722940516690633},
{0.07209627140183984,-0.04497438002831917,-0.6281235837839437},
{0.025325226818068973,-0.1289182808521056,-0.7256727176700438},
{0.034374911889441105,-0.1087294268292096,-0.7098420439861665},
{0.03066914510923646,-0.12999775124661397,-0.6894450943135423},
{0.023199364022283973,-0.15091143281350683,-0.7097939055344779},
{0.02803273964868558,-0.14965343753245047,-0.6738688667314473},
{0.038719544692770086,-0.0862391422002986,-0.7337324698670485},
{0.028373559886640823,-0.1052887653793757,-0.7467642364313178},
{0.01945467386542827,-0.12741140977581922,-0.7585650340166931},
{0.017850494347514234,-0.15152382268820241,-0.7423630065626463},
{0.017205851710187264,-0.17347289358170023,-0.7335055314519451},
{0.022318017741082524,-0.17081599489457336,-0.7006888612436637},
{0.026895984496667785,-0.16730567022822437,-0.6644268532788131},
{0.0074574026279468466,-0.09589296484036258,-0.8265227739576478},
{0.0,-0.12407967876523496,-0.8106921002737703},
{0.0,-0.09490041873576048,-0.833667895572569},
{0.008441696426545194,-0.06602119879873933,-0.8534390453732416},
{0.0,-0.06457291909507963,-0.8608042284815963},
{-0.008441696426545194,-0.06602119879873933,-0.8534390453732416},
{-0.0074574026279468466,-0.09589296484036258,-0.8265227739576478},
{-0.0066604086679471495,-0.12461669757842957,-0.8037257786222638},
{0.0,-0.15154624145284595,-0.7939124113994604},
{0.0066604086679471495,-0.12461669757842957,-0.8037257786222638},
{0.014769152054927348,-0.09832134342040204,-0.8078381777808036},
{0.016708856581110883,-0.06963914728922063,-0.8341974185411435},
{0.018862227063575078,-0.04034071020720854,-0.8626403665674327},
{0.009542072662929748,-0.03555849887803023,-0.8824665317414636},
{0.0,-0.03366115618933265,-0.8900792840299311},
{-0.009542072662929748,-0.03555849887803023,-0.8824665317414636},
{-0.018862227063575078,-0.04034071020720854,-0.8626403665674327},
{-0.016708856581110883,-0.06963914728922063,-0.8341974185411435},
{-0.014769152054927348,-0.09832134342040204,-0.8078381777808036},
{-0.013189179301291003,-0.12585241163327576,-0.7854675515889471},
{-0.006121986962731899,-0.15163529758846986,-0.7870286128079915},
{0.0,-0.1767357178371531,-0.7853437669988907},
{0.006121986962731899,-0.15163529758846986,-0.7870286128079915},
{0.013189179301291003,-0.12585241163327576,-0.7854675515889471},
{0.021789732618408556,-0.101636294742112,-0.7803442449449468},
{0.024627219268584365,-0.0746992550230755,-0.8059332704782692},
{0.02773861370886827,-0.04710072420862104,-0.8335784955908617},
{0.03089532706295615,-0.01934202988847697,-0.8615194283352554},
{0.021082922609186604,-0.01096318852599374,-0.891248360713797},
{0.010687286428601393,-0.005062102041139125,-0.9116246796214118},
{0.0,-0.0027301379029102454,-0.9194712472466525},
{-0.010687286428601393,-0.005062102041139125,-0.9116246796214118},
{-0.021082922609186604,-0.01096318852599374,-0.891248360713797},
{-0.03089532706295615,-0.01934202988847697,-0.8615194283352554},
{-0.02773861370886827,-0.04710072420862104,-0.8335784955908617},
{-0.024627219268584365,-0.0746992550230755,-0.8059332704782692},
{-0.021789732618408556,-0.101636294742112,-0.7803442449449468},
{-0.01945467386542827,-0.12741140977581922,-0.7585650340166931},
{-0.01211514167490178,-0.1516964334221144,-0.7689766934247689},
{-0.005913327405426854,-0.17639145913836296,-0.7784324607207427},
{-0.005976361269452233,-0.19921761262162696,-0.7763556303764634},
{0.0,-0.1999793692349906,-0.7833838443229981},
{0.005976361269452233,-0.19921761262162696,-0.7763556303764634},
{0.005913327405426854,-0.17639145913836296,-0.7784324607207427},
{0.01211514167490178,-0.1516964334221144,-0.7689766934247689},
{0.032022248216986134,-0.08047504399510638,-0.7714936467559155},
{0.03594938310574161,-0.05492941183752034,-0.7982998874247923},
{0.039832780772677163,-0.029103820198756788,-0.8256150202972343},
{0.043529470016277674,-0.0035993808019728624,-0.8514791226973487},
{0.033940496747559896,0.008017802974818777,-0.8878374075655766},
{0.023242894936453803,0.017943264020839827,-0.9180889859910228},
{0.011806230353494403,0.02491096105668028,-0.9389123048071746},
{0.0,0.027655540495097098,-0.9469651800825093},
{-0.011806230353494403,0.02491096105668028,-0.9389123048071746},
{-0.023242894936453803,0.017943264020839827,-0.9180889859910228},
{-0.033940496747559896,0.008017802974818777,-0.8878374075655766},
{-0.043529470016277674,-0.0035993808019728624,-0.8514791226973487},
{-0.039832780772677163,-0.029103820198756788,-0.8256150202972343},
{-0.03594938310574161,-0.05492941183752034,-0.7982998874247923},
{-0.032022248216986134,-0.08047504399510638,-0.7714936467559155},
{-0.028373559886640823,-0.1052887653793757,-0.7467642364313178},
{-0.025325226818068973,-0.1289182808521056,-0.7256727176700438},
{-0.017850494347514234,-0.15152382268820241,-0.7423630065626463},
{-0.011693104992026207,-0.17531762781962384,-0.7602842644341429},
{-0.011808568506862136,-0.19705035075738975,-0.757884218771383},
{-0.012346756396740613,-0.2172288893977811,-0.7602911413558125},
{-0.006253012951306581,-0.22044591335491312,-0.7792370605561091},
{0.0,-0.22160880080927617,-0.7864440744660586},
{0.006253012951306581,-0.22044591335491312,-0.7792370605561091},
{0.012346756396740613,-0.2172288893977811,-0.7602911413558125},
{0.011808568506862136,-0.19705035075738975,-0.757884218771383},
{0.011693104992026207,-0.17531762781962384,-0.7602842644341429},
{0.025213683148584833,0.04582849369970821,-0.9412160735665572},
{0.03906847969829569,0.059298320174343694,-0.927909230135496},
{0.036717122640957986,0.034417617573010546,-0.9106068952142814},
{0.0468965484042447,0.020983551091057998,-0.873925395027573},
{0.04979104473506315,0.04404255714206137,-0.8910007915336842},
{0.052069919038001185,0.06497796978143079,-0.9007453895397894},
{0.040837499028634816,0.08209806627839565,-0.9378326281050161},
{0.02686717019487133,0.07214165908486052,-0.9586903315295168},
{0.012827521990676268,0.05380365976017421,-0.9623351000145103},
{0.05164038651050553,-0.015642246030125054,-0.8123494383961919},
{0.05531059960567731,0.006935375503992385,-0.8346237876846712},
{0.047603633490333454,-0.03915581660350215,-0.786705397489511},
{0.04327261699191068,-0.06291764404915899,-0.759796002995587},
{0.0583882283605625,-0.026921772952929544,-0.7733160309984121},
{0.06200046900605787,-0.00639691253724713,-0.7958379494670041},
{0.05854192755988251,0.02788935583187027,-0.8514103534806508},
{0.061262231464804945,0.046529939710027696,-0.8605979208315024},
{0.0632867284351771,0.0629135178961571,-0.8634243356377899},
{0.05365518702132327,0.0835827936669053,-0.9040119273329441},
{0.04200643817406726,0.10244825288366517,-0.9410303966814727},
{0.028075032716954842,0.09633123105837887,-0.9685518372040086},
{0.013680053970081263,0.08105827572192202,-0.979905634880847},
{0.0,0.0569326591199328,-0.9705186368015712},
{0.06700748690462191,-0.017686754842556312,-0.7607312643426797},
{0.05171513864905625,0.13007078415474724,-0.868588903811809},
{0.06116478548474389,0.1060242521519607,-0.8340736339510872},
{0.05822992162372372,0.10903496845899874,-0.8185799294290298},
{0.0404099608084234,0.15173721356761627,-0.8994662821092069},
{0.027713100329473314,0.1693558868856416,-0.9244363846922474},
{0.041734043306726525,0.14508998108158846,-0.916885524698808},
{0.0534695101362387,0.1233451547616837,-0.8835049469136032},
{0.06333988703968466,0.09908406280279944,-0.8460394776565376},
{0.07105923161403414,0.07357205879217871,-0.8063115011701083},
{0.068517383826443,0.08096612497154673,-0.79769471831785},
{0.02909969404575491,0.1515831705222128,-0.9584427623494041},
{0.014533067334003143,0.17456034120534555,-0.961867469340964},
{0.028599810609577215,0.16270040209361003,-0.9438017961144017},
{0.04247255592484625,0.13431453251718026,-0.929896660498068},
{0.014088474348050634,0.18125983829606385,-0.9412298274098968},
{0.0,0.1857834773704577,-0.9475841030327913},
{0.0,0.1790530341322253,-0.968682498715735},
{0.014785244051634677,0.16320448045200628,-0.9776156199648038},
{0.02918386756699325,0.1365103336063471,-0.9678366373503496},
{0.04255741713825157,0.1199768385278161,-0.9381627203451665},
{0.05443296686217755,0.1129733814992927,-0.894535529271961},
{0.06451020156945106,0.08913453253093412,-0.8549175835322482},
{0.07240504518481383,0.06399044382964764,-0.8129821151898134},
{0.07781855792327969,0.0387321982286425,-0.7706890469205488},
{0.07634208284077382,0.0480744963170646,-0.7661227709318023},
{0.07353148495432693,0.05626628541012927,-0.7612470334679147},
{0.07218773446004817,0.05331333524511756,-0.818469898682313},
{0.06443097943181497,0.07709648114795078,-0.861120566878407},
{0.0544688643932939,0.09965003345622392,-0.901653143200203},
{0.028844766559455455,0.11794058202138859,-0.9714057596969754},
{0.014292512613993573,0.10611846597883694,-0.9896227252002732},
{0.0,0.08453524731817245,-0.988123556276257},
{-0.013680053970081263,0.08105827572192202,-0.979905634880847},
{-0.012827521990676268,0.05380365976017421,-0.9623351000145103},
{-0.025213683148584833,0.04582849369970821,-0.9412160735665572},
{-0.036717122640957986,0.034417617573010546,-0.9106068952142814},
{-0.0468965484042447,0.020983551091057998,-0.873925395027573},
{-0.05531059960567731,0.006935375503992385,-0.8346237876846712},
{-0.05164038651050553,-0.015642246030125054,-0.8123494383961919},
{-0.047603633490333454,-0.03915581660350215,-0.786705397489511},
{-0.04327261699191068,-0.06291764404915899,-0.759796002995587},
{-0.038719544692770086,-0.0862391422002986,-0.7337324698670485},
{-0.034374911889441105,-0.1087294268292096,-0.7098420439861665},
{-0.03066914510923646,-0.12999775124661397,-0.6894450943135423},
{-0.023199364022283973,-0.15091143281350683,-0.7097939055344779},
{-0.017205851710187264,-0.17347289358170023,-0.7335055314519451},
{-0.017352467680187382,-0.19359559161813278,-0.73059659358562},
{-0.0181220639842546,-0.21222867965167014,-0.7322608086297115},
{-0.01934643111834563,-0.22970981453629946,-0.7371090384069199},
{-0.01319309914664279,-0.23618787474925027,-0.7659921094200761},
{-0.0066851930936451046,-0.24040892927017293,-0.7855019361972962},
{0.0,-0.24195554895371074,-0.7929083808356698},
{0.0066851930936451046,-0.24040892927017293,-0.7855019361972962},
{0.01319309914664279,-0.23618787474925027,-0.7659921094200761},
{0.01934643111834563,-0.22970981453629946,-0.7371090384069199},
{0.0181220639842546,-0.21222867965167014,-0.7322608086297115},
{0.017352467680187382,-0.19359559161813278,-0.73059659358562},
{0.022463877249698963,-0.18897148071814318,-0.6971059850536985},
{0.026998656937197885,-0.18329602603327466,-0.6600393772534813},
{0.02808019040820719,-0.1979658753392901,-0.6596130081099538},
{0.033906249677644294,-0.20091806904291817,-0.6213429390175218},
{0.029880293424493803,-0.21165651976874286,-0.662068069146072},
{0.02341963182336764,-0.20571740390705429,-0.6978143079856878},
{0.02496797073732291,-0.22139355316101145,-0.7015622302957283},
{0.032138536962422436,-0.22471029248235552,-0.666311129816338},
{0.0364015407055309,-0.21204712891958746,-0.6241487230587998},
{0.03948391453636825,-0.19890691330058544,-0.5833823314002307},
{0.03686848368691026,-0.18959556135967745,-0.5821032239696481},
{0.0319446077713341,-0.1892455948159014,-0.6203182776887216},
{0.026891514497582418,-0.23633847933381882,-0.7071050291615864},
{0.03459442322914109,-0.23746766987199988,-0.6712625134185934},
{0.039134566915542464,-0.22297455745289824,-0.6278141223088027},
{0.04237724179050283,-0.20810328311117438,-0.5856723463162737},
{0.044106237436723726,-0.19354415224404267,-0.5476636002472942},
{0.04118877218752815,-0.18584791412650373,-0.5467833542735598},
{0.038589708411644275,-0.17810731986419456,-0.5470653080620216},
{0.03485354563765912,-0.1798280632044117,-0.5825983623298736},
{0.036987660739447877,-0.25027043494466483,-0.67582878940734},
{0.039057751700490806,-0.2634603707073395,-0.6789302810804194},
{0.03099511119638494,-0.265396224157388,-0.71861699603683},
{0.03274054268539665,-0.28018710728479185,-0.7220898414800786},
{0.04180927682979413,-0.23404227518827292,-0.6314245061854472},
{0.04522586905378371,-0.2175259724139164,-0.588230561177439},
{0.028973021148597213,-0.25089348404794864,-0.7132048586826981},
{0.022486639860425994,-0.26256155704509676,-0.7508353740598389},
{0.024065924921895358,-0.27860679068507205,-0.7569420805026205},
{0.025427074027998698,-0.2948466412083026,-0.7606968797343308},
{0.02085735957841719,-0.24637465881872364,-0.7437658985832853},
{0.014232889703116413,-0.2542604248974823,-0.7735085848051665},
{0.015351489781925937,-0.2717828213121304,-0.7813276447437282},
{0.016434261098835806,-0.28908790700201287,-0.7879638741550842},
{0.01736649660039377,-0.3065105880524489,-0.791911227193549},
{0.008334210140846232,-0.2960274086590071,-0.8088490852662641},
{0.008807754967028599,-0.3142519387761417,-0.8129133459731155},
{0.018033558002364287,-0.3243857705487577,-0.7916842887784454},
{0.01844582945646874,-0.3421316669176743,-0.7877575665049903},
{0.018613420037561744,-0.35916786497026765,-0.7806330756550784},
{0.018546713897364696,-0.37491326482543963,-0.7707853238239261},
{0.018256026418382285,-0.3887874542942593,-0.7587094493717588},
{0.017751535444685825,-0.4002100211877956,-0.7448868368154626},
{0.017043625127996703,-0.4085998656249505,-0.7298126245152631},
{0.01614247331238623,-0.413375887724626,-0.713961320066376},
{0.015058464149575795,-0.413958362990058,-0.697841815672367},
{0.013839598552820602,-0.41091463745900497,-0.6813784651948679},
{0.012533808666159149,-0.4048141202457262,-0.6645231301821903},
{0.01118916417206333,-0.396226220464481,-0.6472207952609758},
{0.009853734753005041,-0.38571828415302806,-0.6294164450578659},
{0.008573939630255429,-0.3738473419666207,-0.6110344334344929},
{0.007396335563519031,-0.36116698609967823,-0.5919991142524889},
{0.03627404257777283,-0.14321868129525445,-0.5094347926848809},
{0.03659904589588753,-0.14985974518254444,-0.5021796403232428},
{0.03799595499467382,-0.15587842702795263,-0.4970425798359029},
{0.04012793825074494,-0.1615965186271739,-0.4936385036093523},
{0.04265967696348148,-0.16734019237500677,-0.49160981171676155},
{0.04525578366304734,-0.17343575820468332,-0.49059202730963136},
{0.047581077187256515,-0.18020966358786883,-0.4902069196961227},
{0.038892705580415625,-0.16687153016320996,-0.5189455753542132},
{0.041319364930037634,-0.17342771220632966,-0.5171231911117163},
{0.044105205898473256,-0.17998657624890055,-0.516586791221472},
{0.04690741394048299,-0.18687938360775688,-0.5168412373232546},
{0.03716804239484671,-0.1599866312642739,-0.5225284515441784},
{0.03664773450130971,-0.16998457506469464,-0.5491146307196217},
{0.04700334699777669,-0.2015337598400153,-0.5490871230329426},
{0.004330865206146042,-0.38112725124627006,-0.6194449086366571},
{0.0,-0.3701303658040944,-0.6023213736788575},
{0.0,-0.383903464524368,-0.6226289233697742},
{0.004984544118547126,-0.3937986671150419,-0.6388034431371415},
{0.0,-0.39686164802677043,-0.6423450577970882},
{-0.004984544118547126,-0.3937986671150419,-0.6388034431371415},
{-0.004330865206146042,-0.38112725124627006,-0.6194449086366571},
{-0.0037286806832084137,-0.36764367092829503,-0.5994674511858907},
{0.0037286806832084137,-0.36764367092829503,-0.5994674511858907},
{0.0056656757022540485,-0.40506375250233984,-0.6576187008257119},
{0.0,-0.40839768412785843,-0.6615179154124882},
{-0.0056656757022540485,-0.40506375250233984,-0.6576187008257119},
{-0.01118916417206333,-0.396226220464481,-0.6472207952609758},
{-0.009853734753005041,-0.38571828415302806,-0.6294164450578659},
{-0.008573939630255429,-0.3738473419666207,-0.6110344334344929},
{-0.007396335563519031,-0.36116698609967823,-0.5919991142524889},
{0.007014185026328294,-0.42099689231909737,-0.6938256934172043},
{0.0,-0.41790709141285665,-0.6802093885110021},
{0.0,-0.4247847007748228,-0.6984882463093282},
{0.007633383053477006,-0.42447661468401576,-0.7113480898318524},
{0.0,-0.4284260307989814,-0.7164163811024944},
{-0.007633383053477006,-0.42447661468401576,-0.7113480898318524},
{-0.007014185026328294,-0.42099689231909737,-0.6938256934172043},
{-0.00635022511603086,-0.4143276536837262,-0.6759388201540568},
{0.00635022511603086,-0.4143276536837262,-0.6759388201540568},
{0.008183949402361123,-0.4241726547462106,-0.7285610247713596},
{0.0,-0.4282245369940562,-0.7340419313421894},
{-0.008183949402361123,-0.4241726547462106,-0.7285610247713596},
{-0.01614247331238623,-0.413375887724626,-0.713961320066376},
{-0.015058464149575795,-0.413958362990058,-0.697841815672367},
{-0.013839598552820602,-0.41091463745900497,-0.6813784651948679},
{-0.012533808666159149,-0.4048141202457262,-0.6645231301821903},
{0.009406253459951214,-0.38514062273276484,-0.7896487199641851},
{0.009440431760650117,-0.3689131506685399,-0.8003354562390528},
{0.009355639316461493,-0.3512910388896797,-0.8081270084909352},
{0.0,-0.3547205597264086,-0.8158154069177705},
{0.0,-0.3725641083830363,-0.8077694085641056},
{0.0,-0.3889745065636779,-0.7967594569707573},
{0.0,-0.4033486482378919,-0.7833357058713095},
{0.00925819333640044,-0.39937722597358294,-0.7765963226349063},
{0.008641814847136347,-0.4194901587812444,-0.745526390530754},
{0.009001615388900236,-0.4110260435900557,-0.761714664141461},
{0.0,-0.423576425637439,-0.7514336662451113},
{0.36079425694517514,-0.39621590508197635,0.37449060921961375},
{0.3556571964578352,-0.40990991920304726,0.34687701794670245},
{0.3699859504490286,-0.4104690129348019,0.34737944584389796},
{0.3712905024897895,-0.3934224994997039,0.37606783120458226},
{0.38146834656109213,-0.40822025954877766,0.34846895654404425},
{0.37998293148041556,-0.43151445632088814,0.31301310259885745},
{0.36564936364405326,-0.4296982613078942,0.31245024031402774},
{0.3487018778810003,-0.42396841017261755,0.3119272297902745},
{0.33815061696302756,-0.4070009813367223,0.3465579287812237},
{0.34704522745074573,-0.39686990033277425,0.374326388330139},
{0.3523686525153372,-0.38781574526231677,0.3943034331656052},
{0.36104595227828973,-0.38444055210677935,0.39698543261682684},
{0.37910199781451426,-0.38827374824552535,0.3781635730834535},
{0.3903437016681348,-0.40297316831472096,0.34973816120742235},
{0.40138047325599546,-0.4238404994295593,0.3150321186626588},
{0.3918724413553312,-0.4295806659473407,0.3139921273000724},
{0.3908257738771878,-0.46029024735599555,0.27143471153720516},
{0.37691444903135113,-0.45768045558230674,0.27066153923386965},
{0.3616064213943784,-0.4502678217144303,0.2696696808214345},
{0.3454442800860165,-0.43789623963046176,0.26800801023836096},
{0.32896855114951185,-0.41415848141064915,0.311067752119983},
{0.3171326812636206,-0.40219951462686854,0.34601836550701137},
{0.3298047848245594,-0.396673220373018,0.37464313934224996},
{0.3399214242930009,-0.3891313003777493,0.3951829914471725},
{0.34598067997626086,-0.38393303528754813,0.4061613092008398},
{0.34957799770173276,-0.38012253299031246,0.4124351248401975},
{0.3671560971819063,-0.37903804244298517,0.40097198410880935},
{0.38479608895710793,-0.38055371597900883,0.37988349119307024},
{0.3968492695677648,-0.39453724850237837,0.3507798085327468},
{0.40856960716960344,-0.41423481524118394,0.31577787955621844},
{0.42046530627402195,-0.4402894083715518,0.27396198025085633},
{0.41271295247565737,-0.451579938369028,0.27338191190800876},
{0.40279574373564014,-0.45825192777306706,0.27244053010062996},
{0.40205097311880084,-0.4932602729175134,0.224863647835592},
{0.3888493465892875,-0.4901642827817698,0.22385342804229855},
{0.37543522318017736,-0.4816258968365472,0.22246566524933312},
{0.3630155026445202,-0.4677544581363955,0.2201680857194532},
{0.3541023244682936,-0.44889312507263746,0.21569602355758286},
{0.33419707469506005,-0.42134280147908826,0.26229782709905997},
{0.3030288026110296,-0.3977618370733471,0.30779118777503384},
{0.29111247274160174,-0.4003248657796813,0.34555183514093213},
{0.30883361219250705,-0.39691528801579484,0.37450897060047217},
{0.32351721534186206,-0.39029212475561137,0.39726463563662073},
{0.33568386516007065,-0.38413315370813933,0.41107418204174423},
{0.33573200361175926,-0.37931518238627804,0.4236300656264635},
{0.3537887368401507,-0.3744607633795669,0.41908029424972437},
{0.3719025485184016,-0.37164122549494927,0.4040047065651908},
{0.3886856758535463,-0.36987316893364386,0.38085953268566486},
{0.40122367944192405,-0.38272132168932954,0.3511864409110821},
{0.4135037984676843,-0.4007044718558543,0.315874211474969},
{0.4259413989996829,-0.42439271623964425,0.273883720882254},
{0.4380399672933605,-0.45093006927123197,0.22758484574033155},
{0.4320900546646503,-0.4695575869982168,0.22767768418287385},
{0.42393402556426857,-0.4828761211961167,0.22706357507776076},
{0.4138332030156676,-0.49080383649706116,0.22602997375078993},
{0.42458045620122975,-0.5238068712825941,0.17697620378794596},
{0.41319777545337827,-0.526887732190664,0.1755203594704495},
{0.40085232567175494,-0.5234575236617682,0.17436847509075817},
{0.3887599466075801,-0.5137686287211882,0.17299584152546627},
{0.3781378533964085,-0.4980754934707067,0.17087706195900115},
{0.3702005104051263,-0.4766311886277721,0.1674867395757902},
{0.3661644450771212,-0.4496880972176663,0.16230085294459468},
{0.3512092035218091,-0.42538368065226223,0.20778481286864595},
{0.33363523019463753,-0.40138528710116433,0.24916049978715923},
{0.31576417385133054,-0.38136106658304325,0.27525917398543054},
{0.2810563501838545,-0.3858805795044352,0.28697428512680007},
{0.25948963613519754,-0.40415943730276127,0.3180265779268694},
{0.25859769939462457,-0.4061963815013558,0.3454517071614199},
{0.2836915865677215,-0.3996536782247089,0.37373545445105316},
{0.30296897339250234,-0.3932031256984373,0.39818889390904166},
{0.31971496535063015,-0.3859225287266211,0.41574223647120384},
{0.31882715476305906,-0.3816306419124994,0.4313989240368355},
{0.33828471693558865,-0.37373593583557,0.43340698516441684},
{0.35766044374024764,-0.36715678487407327,0.42405918553865896},
{0.3754723585571943,-0.36159060447453784,0.40593230770923544},
{0.39108365843980525,-0.35584218565075276,0.38072371348268624},
{0.4037055604725545,-0.3673348971453211,0.3505508758103592},
{0.4162449394452662,-0.3831930785158777,0.3149659145377436},
{0.4290277614450888,-0.40390567889314566,0.2728501883244999},
{0.44152037735044586,-0.4270733403065319,0.22649622904000236},
{0.45318707496326005,-0.45029739247761047,0.17819685738433533},
{0.4493036772963245,-0.477459169996816,0.17934599099535872},
{0.44299822781728565,-0.49889591022591373,0.1792710325491579},
{0.434635203374643,-0.5144102455129805,0.17835365119840674},
{0.4444100598360954,-0.5428683227669432,0.1295275073428331},
{0.43463176491380806,-0.5538315112929368,0.12749400160507351},
{0.4238033640525424,-0.5576365120528367,0.12562347891088815},
{0.41232028024831185,-0.5538672712856199,0.12454930374606553},
{0.40114803330355625,-0.5429494704426467,0.1236566793133256},
{0.3912493922520474,-0.5253087909752782,0.12232874573888737},
{0.38359056458839214,-0.5013716020270415,0.11994864314896991},
{0.3791356947306963,-0.47156289735713025,0.11590088705412616},
{0.37740133508557294,-0.43713702747811595,0.11093368653203028},
{0.365318583711736,-0.41841323284775384,0.15625741418117522},
{0.3524009740471853,-0.39808505239182773,0.19883656239190334},
{0.33873309222845954,-0.3783056502851515,0.23459380430619078},
{0.32513879347160074,-0.36146131834714557,0.25745991270435625},
{0.29991905863194646,-0.36897710604006906,0.27491216451797246},
{0.2667447884968356,-0.3799602376389052,0.2636358009791361},
{0.2520047945897882,-0.4004885365154225,0.29169721739118476},
{0.22214107454651857,-0.41554280574277974,0.31834567396926977},
{0.22268916520360157,-0.41661973167627026,0.3444760095149088},
{0.2539378972711687,-0.40694665365553084,0.37213430077867377},
{0.2784465584101657,-0.3984846015408431,0.3978732432043979},
{0.29944867718973217,-0.39010988633136173,0.4184207974615906},
{0.29818332360248917,-0.3866817408789669,0.43656968144035746},
{0.3201585267983322,-0.3763697968351031,0.44465143978670535},
{0.34156157011124794,-0.36645740194025467,0.4409633466951921},
{0.36116836148401216,-0.35730559458208594,0.42744469407670105},
{0.37805395495203686,-0.3482273702857842,0.4066028075720408},
{0.391947399801532,-0.3389270214195479,0.3796060761729105},
{0.40429903881265816,-0.3489797055164603,0.34898293766964505},
{0.41684116855403786,-0.36247772736994194,0.3131348860047079},
{0.42983373666478925,-0.37980275613266684,0.27089397918630886},
{0.4426915171108126,-0.3991420352524759,0.22443590330773056},
{0.45482859616584104,-0.41868280817721,0.17593710092363932},
{0.4656597477957747,-0.43661163066254327,0.1275723985121092},
{0.4634942051619549,-0.4711777897436214,0.1302447702729931},
{0.4592360152640153,-0.5011260959234296,0.1315376315469154},
{0.452743513515558,-0.5251609371593775,0.13108719317754353},
{0.46087959954309726,-0.5452092269033428,0.08547188404959907},
{0.4528494181092729,-0.5649322382523266,0.08286140458374336},
{0.4435820784670516,-0.5774496110756949,0.07980117444068274},
{0.4334062974722499,-0.5819698116892539,0.07739218877975214},
{0.42265216736501804,-0.5777013064088096,0.07673888122112121},
{0.4121648618185744,-0.5654204996908824,0.07684547350700308},
{0.4027895545061373,-0.5459037959919925,0.07671687507177784},
{0.395372106793092,-0.5199275997686603,0.07536005842632648},
{0.3907570046604898,-0.48826969086174016,0.0717792453128621},
{0.3885653297243248,-0.4521025844159327,0.06694133091815843},
{0.38841816360059117,-0.4126001709602727,0.06181183504465528},
{0.3779054134439692,-0.39934696751823584,0.1057945629681894},
{0.3669504772239793,-0.383970858356732,0.15029718616996035},
{0.3557417825943737,-0.3678554801157248,0.19125338086661586},
{0.34446706951673806,-0.3523865325116787,0.22459682327480382},
{0.3333140779526579,-0.3389469644923903,0.24626139591882204},
{0.3124405576083167,-0.34993766070506327,0.26136352852100103},
{0.28610607376598796,-0.36187187057083264,0.2581872159401542},
{0.2743334715594589,-0.35768451296609194,0.23515221034577846},
{0.254989378594481,-0.3765671644870263,0.23704198842063928},
{0.24089925378522958,-0.39672686036204247,0.2650201253112667},
{0.21752459702958246,-0.41395286145272214,0.2914352066755654},
{0.18544719590080452,-0.4279831570434463,0.3156460764754951},
{0.18648286030427627,-0.4283985231123022,0.34138297645548327},
{0.18608812500042982,-0.4284934246313454,0.3661502098492647},
{0.22094586556030751,-0.4171183084973308,0.36963075744478346},
{0.2501170795914283,-0.4067568506174443,0.3962365358469857},
{0.2752343482982026,-0.3966807849868548,0.4193354280436739},
{0.2739126039532672,-0.394104690129348,0.43949306084218903},
{0.29892740652716143,-0.38186652032577356,0.4535123533582415},
{0.3230165754443007,-0.36909263832412176,0.4559185882505042},
{0.34535625548864307,-0.356448042449862,0.4464346255756843},
{0.36428842084560004,-0.3440015019196927,0.4293076521570496},
{0.3795256161893739,-0.33193938131086503,0.4061723122755115},
{0.39123288764003994,-0.3195932438370747,0.3776368696527635},
{0.40301099138390484,-0.3282567897566876,0.34659265723565624},
{0.4153426873221886,-0.33933619825890093,0.3104630162591059},
{0.42846729232900016,-0.353060470835319,0.2680477588456124},
{0.4417136188493672,-0.36829078925742315,0.22142656238502642},
{0.4544077285596494,-0.3838910860653623,0.1726801908208225},
{0.4658770585205403,-0.3987218553384511,0.12388774388143084},
{0.4754497334849007,-0.4116470296168385,0.07712949037196577},
{0.4746004336586805,-0.45111574615631655,0.08151902947379856},
{0.47190674344062017,-0.487317237210473,0.08493204569851986},
{0.4673418428362075,-0.5190734860972713,0.0865295546024142},
{0.47346230312232873,-0.5308777221434815,0.04636489358995251},
{0.4674023597469018,-0.5577135335755384,0.04420966633863749},
{0.4600468043288846,-0.578509344705011,0.03976511186344633},
{0.4514595922398065,-0.5921256496112133,0.0352813589347373},
{0.4419240526524631,-0.5972255747215363,0.032269954935532294},
{0.43172351473965,-0.5924701833868702,0.03224244724885307},
{0.42169421217641506,-0.5791702168774787,0.03384476999791626},
{0.4126730663299725,-0.5586377918479595,0.035722857305938424},
{0.4055472000957267,-0.5319862819166531,0.03575930499078834},
{0.40120648713774953,-0.5003283730097329,0.03183602117816797},
{0.39912553064046835,-0.4642155942451169,0.02594662546015201},
{0.3987803091726444,-0.4241967239720549,0.02008473742881523},
{0.39987030125730755,-0.38162720345166457,0.015522587593070524},
{0.38993521252094876,-0.3709363410237948,0.05735627749479243},
{0.3801644822124982,-0.3594477556822284,0.10123310082461166},
{0.37034905191319395,-0.3475272996597986,0.14536024410321158},
{0.3604971739290398,-0.3357141236154178,0.18588388042683676},
{0.3506150374895385,-0.32454875359233193,0.2189501828917318},
{0.3407108949006938,-0.31457034024945346,0.24070463690197427},
{0.32247123555588564,-0.3289224757743242,0.2521809813229684},
{0.300619816950099,-0.34244594223798414,0.2512168369048626},
{0.2896545653476043,-0.33769742782498785,0.23193174792781154},
{0.2793549997627462,-0.33472178381846573,0.20636747931250038},
{0.26392181215138305,-0.3553277919098518,0.20766584212375844},
{0.24489818373621777,-0.3747537202427003,0.20791684976470606},
{0.2309270296718539,-0.39441690237315685,0.2365516639055826},
{0.21058096921958627,-0.4122858956399629,0.26350369531385925},
{0.1823745872987383,-0.42742543869602556,0.2885424295751644},
{0.14890117107099113,-0.4402337053060264,0.3114288936614725},
{0.14989351086794314,-0.44020688531151425,0.33722993468987483},
{0.14994096162746476,-0.4398630392280243,0.3621926789667287},
{0.14936330020720165,-0.4390611901613257,0.38676426393900437},
{0.18486953448054141,-0.4280904370214952,0.39034438936030186},
{0.2186895475604464,-0.41697389314226496,0.3936143656142913},
{0.24741926322036611,-0.40562147084976063,0.4187130666325571},
{0.2461270896386109,-0.4035363881994774,0.44051978524749},
{0.2742715792644307,-0.3898650679199169,0.4597194628574022},
{0.3014347321679702,-0.3746120556563024,0.47012768380464315},
{0.32742399454247495,-0.358575762014498,0.4646694710753236},
{0.33340485331869923,-0.3435923250803396,0.47037112683175397},
{0.34946246541768017,-0.3426763191139224,0.4499569848549554},
{0.36677374033706545,-0.32763511603773776,0.4298495535846298},
{0.37976837152431775,-0.31311587131629093,0.40479624024938465},
{0.3888974850409761,-0.29830504511604455,0.37494606774180456},
{0.39984623203146324,-0.30576856820427756,0.3434898589474596},
{0.4117962588170732,-0.31454764640794314,0.30703220256110314},
{0.4250370838001044,-0.32465328280171285,0.2643441239111254},
{0.43874622714884887,-0.33567354977756597,0.21749158780556738},
{0.4521046474924336,-0.3471944566509804,0.16853959628343643},
{0.4642891773069837,-0.3588033881217682,0.11955459553729043},
{0.474480775221626,-0.3700877288897417,0.07260172514457007},
{0.48229570900718566,-0.38067474980039734,0.02886244024814681},
{0.4827385827627207,-0.4230971041970541,0.033602702355139354},
{0.4813157476692393,-0.46303276371791136,0.039060227392291924},
{0.4781619913914694,-0.4991386655608577,0.04398135253920016},
{0.48199725060671644,-0.5070670685539691,0.009113296596817764},
{0.47744060230830754,-0.5361124349185326,0.01308678193762769},
{0.47230835566613644,-0.5613466112936933,0.009084413525804616},
{0.46609436924530595,-0.5815063071687094,0.0016490858164177947},
{0.4582931893030858,-0.5953268566485047,-0.0046776821197973715},
{0.4492754819174783,-0.6007410570791375,-0.008302507531948458},
{0.43941260085865236,-0.5956830811910003,-0.007633383053477005},
{0.42961917670869154,-0.5821878101061866,-0.004060822246016405},
{0.4208125908183468,-0.5622901249467899,0.0010260367131340218},
{0.4141172198806304,-0.5372333731507097,0.0031847024252839628},
{0.41066019135722237,-0.5082609021558462,-0.0020286918925907413},
{0.4093969008464802,-0.47438105985741386,-0.010382776337062688},
{0.40928343163892855,-0.43460288184279494,-0.017648244081205473},
{0.4101760560716685,-0.3911538030408372,-0.022475843093404425},
{0.41192829571313333,-0.3462585076117208,-0.023514258265544097},
{0.4020949854174876,-0.33786109856072905,0.01353378184616462},
{0.39273893348572586,-0.3282849851355338,0.05454224114751065},
{0.38369578148994005,-0.31869305479049803,0.09799750917897117},
{0.3748025463865559,-0.3102481949799847,0.14238597548102347},
{0.36593200512468205,-0.30267876729803683,0.18357529782228518},
{0.3569562469612602,-0.2957138210308643,0.2174345093557081},
{0.34774804884539917,-0.28908171777251,0.23983126784990977},
{0.3307909353920086,-0.3063180342456945,0.24729465339970932},
{0.3119220377144138,-0.3216666357205191,0.24526678673771898},
{0.30164860443190095,-0.31653507677051507,0.2284307071057168},
{0.29163443109633946,-0.3128806805951838,0.2045829181391875},
{0.2818630130957219,-0.3100597673262322,0.17663579616529093},
{0.2695278786966033,-0.3325486765708092,0.17738400524296505},
{0.25419303106511826,-0.3537151537782839,0.17758618674005716},
{0.23557995487363997,-0.3735715774076619,0.17698239301744878},
{0.2218453669147172,-0.3930532088060357,0.20655934542708776},
{0.2030500522989893,-0.41097652975403315,0.23431047513339506},
{0.17780074669615492,-0.4267515003723853,0.2602499485950105},
{0.14664278999462912,-0.44008653918229274,0.28434241843455127},
{0.11199273246917935,-0.4510476646317855,0.30719518560467735},
{0.11283240460506182,-0.45071826008380217,0.33307441723246534},
{0.11307997378517459,-0.4500188771499836,0.35825839207943666},
{0.11287916767241646,-0.44884223585228095,0.3832095831278853},
{0.11237440162185319,-0.44707899313614446,0.4083894318218547},
{0.14848167884913338,-0.43766036121718765,0.411391208130722},
{0.18343294554372036,-0.4270114480115037,0.4143634136764091},
{0.21661546798483503,-0.4160317548735024,0.4169298808435782},
{0.21541957130645692,-0.4141399137221407,0.44008034995278994},
{0.2146087822415876,-0.41117045894512144,0.46414201118324994},
{0.2458733312289953,-0.4000030258455347,0.46300319295473125},
{0.2760980896599293,-0.38307066931015527,0.4813913938076071},
{0.3067567818482277,-0.36324519182829146,0.48391522406042337},
{0.3159450368912463,-0.3460913984151447,0.49237315002210924},
{0.3261077517348754,-0.3252082503804657,0.49707696444425187},
{0.33978113509093694,-0.3251009704024168,0.47367204923325756},
{0.3534311369133212,-0.3256332441396593,0.4518061890919644},
{0.3683753753939616,-0.30859773377923294,0.4292705167800327},
{0.3786604994433132,-0.2921453863764055,0.4026300099233979},
{0.384896492013487,-0.275527992853503,0.3716639193364596},
{0.39481026229266936,-0.28211608381317055,0.33978457355177183},
{0.40625208456688117,-0.2888891639657557,0.30292434217086533},
{0.41965039105615076,-0.29555840260112687,0.2598158085299961},
{0.43395094966849795,-0.3024435765769297,0.21265298571869673},
{0.4480988406197757,-0.3098672135194779,0.16362947421119986},
{0.4610398318180036,-0.3181504656707509,0.11493949340468823},
{0.4717196911712016,-0.32761517296489534,0.0687767813118278},
{0.47984958796923816,-0.3371080756378861,0.026093791583885705},
{0.4851406915019816,-0.3454779770021985,-0.012157022127870875},
{0.48735162181882197,-0.39019034631489835,-0.01048249170127478},
{0.48735987412482573,-0.43350326206779405,-0.005493972722002521},
{0.4854721591264659,-0.4732002924067094,0.0014806012355077199},
{0.48670587887402783,-0.483550747211924,-0.030224758430934053},
{0.48302947654935324,-0.515903225207494,-0.019107526859536813},
{0.4791880281046035,-0.535786468831384,-0.008792832047005148},
{0.47649846403954504,-0.5532201529564917,-0.019243689908598857},
{0.47131120202401555,-0.5714398692284576,-0.0303595460956621},
{0.4641110650357359,-0.5845170234757474,-0.03869024900645678},
{0.455379437591592,-0.5898542023836786,-0.04288242045636631},
{0.4455956411319688,-0.5848512418688997,-0.041583369952941235},
{0.4357011262334618,-0.572076672175081,-0.0359229757265296},
{0.4266380311648336,-0.554100398930226,-0.027033179083980285},
{0.4201599709518829,-0.5368111301601841,-0.01801409631403877},
{0.41986701408874944,-0.5169567696073072,-0.028962843304525938},
{0.41983606794123535,-0.4845974146900674,-0.040643294760679696},
{0.4202198001704101,-0.44428627524603903,-0.0496506867637826},
{0.4210615353827935,-0.39915028755847953,-0.05484551339314881},
{0.4224025351084043,-0.35231363714197883,-0.05508758103592575},
{0.4240426809266514,-0.30760814475094883,-0.0515906663668329},
{0.4144651921171222,-0.3029428410901571,-0.0222310246819596},
{0.4054853078006986,-0.29499655810070424,0.012570325120225776},
{0.39687815263877796,-0.2863742737111101,0.051898064765472866},
{0.3885756451068295,-0.27871200758662,0.09451090989238305},
{0.38051107906465614,-0.273645091700312,0.1391703269082254},
{0.37239356072562524,-0.27011035396203525,0.18204999659592377},
{0.36393288399527146,-0.26704324689730485,0.21932359973840188},
{0.35479826894127725,-0.26329601227943134,0.24433290077496028},
{0.3381801877262077,-0.28251081911701703,0.24663467522705873},
{0.32088197895799503,-0.2995752125484565,0.241399205990624},
{0.31100947020883146,-0.2941252521251407,0.22569919381847264},
{0.30119885375469607,-0.2897515299431485,0.20287400310424242},
{0.2914762618979341,-0.2862367352777142,0.17560357022265405},
{0.28164020083362046,-0.2833504912528995,0.14526946873717023},
{0.27210259816977606,-0.3077965724047013,0.14589114245612006},
{0.2598946868215487,-0.3308631430695415,0.14611395471822153},
{0.2448252883665179,-0.3525055032565662,0.14583406400626073},
{0.22670253669009632,-0.372676889898421,0.14494900418735757},
{0.21341013479454163,-0.39212895053361474,0.17531061335952064},
{0.19542354616718208,-0.4099477422722312,0.2040417044037743},
{0.1722620739832987,-0.4259867866827036,0.23094628505252932},
{0.14340307219598675,-0.43974544386747066,0.256164782046283},
{0.11041585433029442,-0.45111574615631655,0.2801587055982956},
{0.07481265546141048,-0.4597015828610607,0.30348144159533574},
{0.07541782456835282,-0.4591865014279928,0.32943680074600845},
{0.07568396143697403,-0.45822304470205394,0.35482894001192455},
{0.07566057990329672,-0.45673006500754054,0.3801136617613584},
{0.07539856918767737,-0.45462779005308296,0.4057466308241509},
{0.07494813081830554,-0.4518336967786436,0.4321835807993596},
{0.11170940329638362,-0.4446211813313583,0.43426041114363895},
{0.14761724979523966,-0.43551888780921216,0.43652085529650186},
{0.18238490268124297,-0.42507972071445715,0.438603874870284},
{0.18135473981510705,-0.4222594951376725,0.46391644815248056},
{0.21368865012216848,-0.4069961674915534,0.490192478160616},
{0.24629076037435207,-0.39452349465903874,0.4875091033250604},
{0.3343538685091315,-0.30265401038002554,0.4996007946970681},
{0.34537757394581947,-0.30405827778499855,0.47521935660896236},
{0.3568152700670293,-0.3058091420421294,0.45226006592217105},
{0.36884644452834286,-0.2872792766028557,0.4277699724716825},
{0.37608234150930553,-0.26941647256555257,0.3998297274194557},
{0.3793433777651243,-0.2510337732500125,0.3679650294779247},
{0.38774353758478386,-0.25749945500395766,0.3354252929052862},
{0.39845021693249405,-0.263101395396176,0.2976896293958143},
{0.4125437802025803,-0.26684175309237973,0.2534492232173127},
{0.42810075240399986,-0.26987378785659416,0.20550855179594243},
{0.4431962831613759,-0.2733500717606776,0.1566720925578641},
{0.4567706388453924,-0.2783413415086178,0.1089717007796366},
{0.4677640858267332,-0.28591764611223547,0.06443675604601758},
{0.47602533182866286,-0.29446290897912786,0.0238856120357132},
{0.4814051476509467,-0.30236242890122605,-0.011865440649071407},
{0.483721294869335,-0.3070332340993536,-0.042350834411290825},
{0.4873048587514674,-0.3515729926781415,-0.04502389386434172},
{0.489267532196028,-0.3982617892787416,-0.044252990945157285},
{0.48892643688120596,-0.443295310833421,-0.038963950488914795},
{0.4870538511105197,-0.4529051211747983,-0.06560789580638444},
{0.48465243006342584,-0.49601448004626786,-0.05506144873358052},
{0.48087356160587125,-0.530447914539119,-0.04011583486860613},
{0.4760157041383251,-0.5458267744692907,-0.05513090564244551},
{0.4689421025087698,-0.5571633798419546,-0.06536995431660934},
{0.4601533966147665,-0.5619015788724462,-0.0700283810557313},
{0.4501502263538767,-0.5574831566996002,-0.0683002106401108},
{0.439701431568784,-0.5464408835744038,-0.06079405063752506},
{0.4295779151786728,-0.5313082174400108,-0.04811644553925035},
{0.43090172260010906,-0.49686240448815416,-0.06343135009789297},
{0.43188030855372145,-0.4537131594709996,-0.07418616789729184},
{0.43273373453294356,-0.4052508047717584,-0.07979498521117995},
{0.43368206203120885,-0.3548642873893073,-0.07967188831329058},
{0.4344426495678886,-0.3063854280780586,-0.07459190627580997},
{0.43473285566235415,-0.2636439845159232,-0.06532800509442359},
{0.4257797913404427,-0.2688621926789667,-0.045571296829257736},
{0.4177110991452674,-0.264231961318691,-0.020094365119153},
{0.41007152686228754,-0.2551296677965449,0.011086285423883133},
{0.4024030715082945,-0.24693168947397737,0.047952774803509124},
{0.3948790315093674,-0.24113375681416976,0.0891964248259623},
{0.38767408067591885,-0.23923160028030332,0.13350924498964675},
{0.38022912527619435,-0.23937120179020024,0.179028964906381},
{0.3719878223471071,-0.2396985432616827,0.22389262649581637},
{0.362234972034998,-0.23802538821942057,0.25490087261259065},
{0.3446616863999934,-0.2577202041895582,0.25041643199171465},
{0.32837025896423927,-0.276212246559648,0.2406757538309611},
{0.3184331071513796,-0.27039780928783286,0.22478731400505725},
{0.3084863276481822,-0.2652793164890014,0.20180051563158677},
{0.29864545273869963,-0.2610672019662494,0.17454727505417295},
{0.2886993609276692,-0.25757166268149057,0.14435208738641903},
{0.2714919275254979,-0.2808644840692671,0.11325258451908653},
{0.2621221217503966,-0.30581670665596616,0.11364938289943394},
{0.2501748457334546,-0.3293502203021857,0.1136885813529518},
{0.23549605642926846,-0.3513570573377098,0.11332823065745432},
{0.2179337738689355,-0.37172787470798874,0.1125277569750897},
{0.2053359410620305,-0.391332603004252,0.14335493374429814},
{0.18819177533922132,-0.40912319936402225,0.17288443539441553},
{0.16629290597391308,-0.4251581176214928,0.20081023891113572},
{0.1394660345400268,-0.4391911639808849,0.22708970738010598},
{0.10823036862363225,-0.45088880774121315,0.2521538174823727},
{0.0738168772036236,-0.4598494366769614,0.2765069914224156},
{0.03745150910607583,-0.4654726955263562,0.3008239927544753},
{0.03776798504131998,-0.46486477565074585,0.32683780573934124},
{0.03793110562332762,-0.46373627280473184,0.3523859823579451},
{0.03795256161893739,-0.46202460700111886,0.3779098146738379},
{0.03784376871812117,-0.4596678859448787,0.40385066351978727},
{0.037616348918500915,-0.45660352964881623,0.43064933957482743},
{0.03728178667926518,-0.45276895812573625,0.45874844151762656},
{0.07431064017951516,-0.44827488981452246,0.45990307666598584},
{0.11083465885998518,-0.4413890281465527,0.46137611328765676},
{0.14660015308027638,-0.4325659376442004,0.46282714375998435},
{0.14526190412333345,-0.42873136612112045,0.49098332415264284},
{0.17996904009864254,-0.4185143235963,0.491151121041386},
{0.12598314191421864,-0.43595282156657655,0.1365062074533452},
{0.14854494652849556,-0.4216783952565745,0.10784388562578952},
{0.15455537606789996,-0.4231947564847651,0.13891519311427583},
{0.13063606711600473,-0.4373680920462211,0.16702529813174666},
{0.16043101794257633,-0.4242909377989312,0.17001813444244324},
{0.18114636908851214,-0.4082463918511229,0.14127053878618204},
{0.17407826899629267,-0.4070614982474165,0.10963257295210428},
{0.1211135936798339,-0.4340307219598676,0.10603319215013142},
{0.09585190961799388,-0.44629571175795435,0.13426433098899074},
{0.09931306429440376,-0.4480912760059389,0.16421951409046864},
{0.10255071901654518,-0.44941095727437336,0.19399520953636482},
{0.13511569389171188,-0.43840513183402685,0.1973119488577089},
{0.19733464269921924,-0.3903533293584726,0.1112445233915052},
{0.0,-0.4673831043662263,0.2452557836630473},
{0.03555664210917938,-0.46446247573306265,0.21795990617128072},
{0.036335109642200644,-0.46529114479427347,0.24623031223287453},
{0.0,-0.46776683659540114,0.2728634607833226},
{0.03697033089683999,-0.4656212370344238,0.2739033201090129},
{0.07247656517017974,-0.4595984290360137,0.24868606096115983},
{0.07083710704409964,-0.4589189891750376,0.2201914672531305},
{0.0689452658927379,-0.45777948325435186,0.19119492703242258},
{0.03464586260323119,-0.463115974470116,0.18924600743120154},
{0.0,-0.4664739753214789,0.2170810355818804},
{0.1055655614765851,-0.45033177708595945,0.22336998044891165},
{0.06684519155321465,-0.4561489651264425,0.1618689822637313},
{0.06455091294573627,-0.45398754864562463,0.1323958713713063},
{0.033613499122160946,-0.461232385624758,0.16024396567315777},
{0.0,-0.4604711103959112,0.13060993481365946},
{0.031227344841174055,-0.4557727975111045,0.10199368836129144},
{0.03247041720220694,-0.4587910784319793,0.1311085116347199},
{0.0,-0.4630300129492435,0.15961266426387022},
{0.06207508360617519,-0.4512512215132116,0.10295439431856236},
{0.0,-0.45733798488315075,0.1016223345911223},
{0.1096972160158004,-0.43730276129035806,0.4902887550639931},
{0.07348884803997417,-0.4438777860988529,0.4893837521722476},
{0.03685156645960255,-0.44810365446494455,0.4885874046428849},
{0.0,-0.454418731634321,0.4582498646965661},
{0.0,-0.4583777754396243,0.4300180381655398},
{0.0,-0.46156110248057436,0.40308938829094054},
{0.0,-0.46402372813052944,0.3770308753152209},
{0.0,-0.4658206677628479,0.35141110994203445},
{0.0,-0.4670069367508883,0.32579794641365095},
{0.0,-0.467636862775842,0.2997593765107737},
{0.0,-0.449628955691306,0.4882160508727157},
{0.4446239321000262,-0.40950486851669615,-0.09725961548380173},
{0.44372718151428436,-0.46179904397034943,-0.09126087671123602},
{0.44218812644458333,-0.5085813667056588,-0.07909835304602934},
{0.45522126839318655,-0.46745943819676106,-0.10088512858811985},
{0.4561627189697821,-0.4119633680136493,-0.1071761365316521},
{0.4563236389368554,-0.35425017828419425,-0.10708192270477582},
{0.44518371352394787,-0.35510979349291916,-0.09706981244571532},
{0.46362555436584807,-0.5205857211724602,-0.09000240004566279},
{0.4532874780196391,-0.5171596387965661,-0.08799708968674935},
{0.46582479391584986,-0.46960985160290725,-0.10306580044961318},
{0.4726246940629472,-0.5168508650135922,-0.08498774876404523},
{0.4749999828076958,-0.4671657936414607,-0.0978118322938866},
{0.46677999833578493,-0.41267581709864043,-0.1094812806753687},
{0.46651867531233254,-0.3534854645945126,-0.10951153913071585},
{0.45554723448033513,-0.2979660128777235,-0.10086105936227556},
{0.44512457199758754,-0.3021973827811509,-0.09106969828881561},
{0.43342348977642436,-0.22927037924159932,-0.05067053424741374},
{0.44416730450115155,-0.25435120026352365,-0.0796368160127746},
{0.4271895602827515,-0.24272576418072822,-0.03941095039745168},
{0.4224307304872505,-0.23144279879708887,-0.02114103259729644},
{0.41609364716853064,-0.21993151961401214,0.006890675513138684},
{0.4093638916224652,-0.211686090531923,0.04123608540861636},
{0.4026822745280884,-0.20758827044732314,0.08047786353299097},
{0.39649098194876825,-0.20851885548768034,0.12320005171445093},
{0.39013326786503905,-0.21229263502319928,0.16923278998775218},
{0.38295169856526784,-0.2167254987315518,0.2184062183876507},
{0.37189635928889875,-0.21481371450734765,0.28012624652801416},
{0.35170984341937045,-0.20310568659529796,0.2679254871783234},
{0.3502574375627089,-0.23216625095675172,0.258855583957242},
{0.3341014854838499,-0.2512999101186338,0.24236541348523077},
{0.32369670299744385,-0.24501715448110528,0.22496955242930697},
{0.31347553431962144,-0.23927836334765798,0.2010364896340721},
{0.3034668625213958,-0.23448789971247588,0.17337269683297124},
{0.29342586919132213,-0.23049240822232264,0.14315412763154003},
{0.2784355553354941,-0.2546028955966383,0.11254013543409536},
{0.24008915241252726,-0.3276942575640981,0.08124051414617171},
{0.4418174603665812,-0.21485497603736645,-0.06265288256487177},
{0.4536773994783167,-0.24675701566356448,-0.08877074337460178},
{0.4505573401167289,-0.2042688491265278,-0.0710688593043719},
{0.4375840273866528,-0.1869917525078414,-0.04000030258455346},
{0.42938673675625233,-0.20589324679415105,-0.029409155520895867},
{0.46506695714783797,-0.295792905630067,-0.10340827114876917},
{0.47303937243963606,-0.297778960608305,-0.09815361530087567},
{0.4696662423605996,-0.24662154030666944,-0.08629986541864292},
{0.46244891306814545,-0.243350876360513,-0.09142592283131122},
{0.47023565147485896,-0.21468992991729124,-0.05826746961604083},
{0.47507837971473155,-0.25409194031657223,-0.07485941852876514},
{0.4790766219735527,-0.3018404705464883,-0.08581435474875511},
{0.47843775595042837,-0.2632829461282587,-0.058571429553845984},
{0.4735427631058654,-0.22903037467532333,-0.04447717859159269},
{0.4686573979516401,-0.20575282005365372,-0.023354025990637788},
{0.4649239171771061,-0.1869101922168376,-0.03578750036963456},
{0.46526776326059616,-0.20418501945137293,-0.06879878746117121},
{0.45869067537560027,-0.19991218171027667,-0.07381687720362362},
{0.48279153505957817,-0.30589235279433397,-0.06710706473040062},
{0.48605188362323,-0.35424055059385656,-0.0715536822820927},
{0.4818555860203185,-0.3546614182000483,-0.09138603668562638},
{0.487659707909629,-0.4045156618452569,-0.07126829003279608},
{0.4822441320946622,-0.46122963485609014,-0.08527451639767586},
{0.4759077364681093,-0.41169172960769224,-0.10411246792775654},
{0.48303704116319,-0.4089822224697913,-0.09129801208825293},
{0.47518703507711435,-0.35401636294742106,-0.10415854330294422},
{0.4797966356723806,-0.5079844499047202,-0.07324334193636237},
{0.30854821994321036,-0.05365649363644054,0.24648352048875652},
{0.30112595838499623,-0.019443808329189984,0.2719187092843256},
{0.3139651711425111,-0.05494385337302693,0.27394465040824845},
{0.3190795377883407,-0.08958483336187256,0.24863689097122077},
{0.3253898011125484,-0.09181281844445408,0.27580238202812796},
{0.318248805650629,-0.05551601325595421,0.3008992950467596},
{0.30485875146736313,-0.01958547291558785,0.2990878451097178},
{0.28967725918911463,0.014517869337112882,0.29764761140441176},
{0.2864877429186618,0.014204281708970054,0.27021123840293115},
{0.2964193931941857,-0.018980991500812516,0.24425794232875947},
{0.30218087816914335,-0.05198127551767748,0.21851968759520235},
{0.3117122916034849,-0.08667630811084774,0.22093555017780278},
{0.31916893777004807,-0.12152971621007345,0.22313135126696965},
{0.3278359221504959,-0.12584677255750654,0.2501238877438814},
{0.33584134666630905,-0.1295853422540761,0.27613852595934774},
{0.33028616934144533,-0.09282090639202992,0.3025516817855789},
{0.32121619735114726,-0.05504425642940599,0.32734367209737164},
{0.3075311232282471,-0.019220308374921516,0.3257005004335899},
{0.29190263104146164,0.014960055400480968,0.3245977860438376},
{0.27387684396058426,0.04705327344909942,0.3245583125134529},
{0.27226695659768424,0.046342199748442205,0.2971088733607997},
{0.26966679251433323,0.04551696914806629,0.2693087799722034},
{0.2823849714504597,0.013918201767506412,0.2423709150225666},
{0.29082501741580413,-0.01838476239204093,0.21617121884496596},
{0.29504744732106075,-0.05024760356472111,0.19005679649607085},
{0.30364635017697755,-0.08362666842715862,0.19257856367238615},
{0.3101416026941028,-0.11721217847812349,0.19507488623852326},
{0.31444655565939705,-0.15023969510480084,0.1973291411618834},
{0.32429912133571825,-0.15560224985369348,0.22481894784473835},
{0.3346385730662612,-0.16152286679609032,0.2503500696976011},
{0.34575924309849326,-0.1677975764352651,0.2735996352480746},
{0.3419439269560888,-0.13138180050187775,0.302251779231559},
{0.3449044417349373,-0.12987259127222364,0.32954029841713894},
{0.3334089794717011,-0.09206974023803777,0.32900444868062817},
{0.32304958466831574,-0.0538971858948835,0.3535424055059386},
{0.30927854902454305,-0.01859244542646886,0.35206572411578263},
{0.29331583844460535,0.015346538398323683,0.3513595330295109},
{0.27472201763380255,0.04747895490046001,0.35190494168714265},
{0.253003323616243,0.07661922278406672,0.3261050009662074},
{0.26613618092905833,0.04451981550594545,0.24123209679404783},
{0.2774191463126977,0.013557851072008922,0.21420992078473924},
{0.28443016795505793,-0.017840110195792833,0.18772345697350803},
{0.28733154120754617,-0.04878350694122088,0.1610987670367138},
{0.2952400011278151,-0.08097520250815086,0.1634465480947832},
{0.3010544383996303,-0.11347257724330342,0.16586722452255248},
{0.3047851684054963,-0.14563912390768693,0.16820262712161627},
{0.3064418188357509,-0.17683804643159973,0.17029458669356914},
{0.3164766229363218,-0.18194450461750905,0.1991274561785359},
{0.32685252235171464,-0.18795486538769676,0.22571088458531127},
{0.3383397323089471,-0.19497372672076055,0.24899428459040018},
{0.3541992890638378,-0.17108103145572742,0.298206361290083},
{0.3564954932093837,-0.1680280908496368,0.3278084832330334},
{0.3554185672758931,-0.16200067531370796,0.35859082247295476},
{0.34572279541364337,-0.12644190135881095,0.3570844327811853},
{0.3350649422097888,-0.090127353712403,0.3553084677599596},
{0.3355587051856803,-0.08756184931426775,0.38161138653182397},
{0.32393189371855097,-0.05244615542255589,0.37976005044909733},
{0.310236504213146,-0.017948077866008688,0.3784927713237867},
{0.29406954905961535,0.015494392214224358,0.3782309669158175},
{0.2750266652637746,0.04744594567644494,0.379396261292765},
{0.25306040206610236,0.07736468109307296,0.35418292199026363},
{0.27164046903356553,0.013022826566098551,0.1858102973649699},
{0.2617363264447209,0.04328953421921836,0.21295350719566694},
{0.27732011864065265,-0.017535462565820732,0.1589799874702487},
{0.27897401830223933,-0.047683199474053035,0.1318649730183978},
{0.28636602140510636,-0.07879109218582267,0.1338530910731367},
{0.2917114526190412,-0.11033876403837597,0.1359422998764217},
{0.29505913808789946,-0.1417787020360502,0.13801981791286802},
{0.2964599670320375,-0.1725634206908693,0.13997355135925793},
{0.29596414097964496,-0.202145668330194,0.14168934331587282},
{0.3060340173807318,-0.20643267252993008,0.17198699711650675},
{0.31614584300400445,-0.21156161824969966,0.20025389594804896},
{0.3265774454849227,-0.21764838161963884,0.2255190184707239},
{0.3377930170361981,-0.22455968789778694,0.2457353114110824},
{0.2831063605336216,-0.22713990890829555,0.11155329717447916},
{0.2565263705876811,0.04176767145369185,0.18454631916206082},
{0.2505661425764662,0.03989302260650461,0.15608549113943024},
{0.26509982883341965,0.012210662116895286,0.1572545678232961},
{0.26948455409008354,-0.017561594868165976,0.13009141491975662},
{0.2699171124631139,-0.04703814422142588,0.10257685131889041},
{0.27690062641879487,-0.07714331298452211,0.10411040485125561},
{0.2819145900082454,-0.1078387967037539,0.10573267067316122},
{0.285010580143989,-0.1386366090174323,0.10736318880107057},
{0.286241549122883,-0.1690484197177849,0.10892356232794799},
{0.28565769847311706,-0.1985858985970392,0.11033401896242381},
{0.26091315892084593,-0.01801203323753781,0.10121109467526831},
{0.2498365011873005,0.009446827297803028,0.10009153182742501},
{0.23663625004212116,0.0348501759460409,0.0992979350667302},
{0.22878624395604547,0.03156231969570996,0.07111974852472834},
{0.3095068628239804,-0.01823347011530535,0.4613699240581539},
{0.32066398054106243,-0.04996633746842633,0.4911139856643691},
{0.32246779709505075,-0.04970501444497397,0.4614235640471784},
{0.3235770445603893,-0.0501080020548242,0.4333107082610396},
{0.3327659872955749,-0.08132902012806204,0.46245785306631615},
{0.330605258506924,-0.08051678690964206,0.4916352563269399},
{0.3080028800547953,-0.01957240676441524,0.49153760403922864},
{0.2936115460764067,0.012767692772149015,0.46257957457987164},
{0.31032521650268646,-0.01759047793917914,0.4327688068334595},
{0.3240467383104366,-0.051059768013924395,0.40626102456505186},
{0.3342802854472647,-0.08283382812784747,0.43480506333988694},
{0.34066825798634104,-0.11276576723408148,0.464210092707781},
{0.3380584662126523,-0.11096552667936146,0.49284628223299143},
{0.3348435053320212,-0.10995963934671994,0.5236418251625188},
{0.29420846287734526,0.014341820142366022,0.4334943220696233},
{0.27501497449693596,0.04678163504314237,0.4072801843565161},
{0.27491250836405595,0.0453120368823063,0.4358035923663418},
{0.2745102084463727,0.042977321975409516,0.4653337817086262},
{0.2943164305475611,0.015220690731766347,0.4055100647187098},
{0.31054046415095116,-0.01753271179715283,0.40529069091744324},
{0.346420802963128,-0.17052805818425887,0.49632187844490794},
{0.3464400583438034,-0.14367682869381812,0.46641483379511856},
{0.34325329284201855,-0.14105519073486097,0.49449330497290833},
{0.3427265206421119,-0.11531449194334242,0.4370036151977218},
{0.34920733162373063,-0.14709628171722233,0.4396601700387652},
{0.35034821292875024,-0.1737234886073477,0.4688073148440417},
{0.34779206114408595,-0.19912656217871882,0.49807755654720764},
{0.3351956037215149,-0.0849413295427741,0.40806071496603835},
{0.34428689416898933,-0.11856590050882342,0.41049858369798203},
{0.34540095547949673,-0.12247405509377027,0.3839646691272292},
{0.3516190680533291,-0.15132157242189365,0.4133834523384628},
{0.3608630261618731,-0.18840035237346633,0.3898492510000763},
{0.3537412860806291,-0.15636077431387232,0.38673813163665915},
{0.35749264685150456,-0.1825967118686728,0.41652345477289304},
{0.36425885008241987,-0.19523945097408157,0.36063498743930256},
{0.3678121555092051,-0.2032170927263487,0.3270137173956547},
{0.3723488607347716,-0.22459407250613594,0.3640242095150463},
{0.3670501925881914,-0.21777079082536124,0.3932168795417769},
{0.3622074643483188,-0.2117796166666323,0.41972878796318647},
{0.3574369437859792,-0.2067480481577071,0.44535288579702487},
{0.3540136121787532,-0.17772537563465388,0.44252509560640346},
{0.3526588586098028,-0.20256694855168592,0.47112346206243005},
{0.34731892893320376,-0.2267444859122821,0.49952239779003244},
{0.3406483149134986,-0.2786143552989088,0.5005223022008213},
{0.352376904821341,-0.2562739875623995,0.47464582134170114},
{0.34495395557095987,-0.25327564971436706,0.5004163976071063},
{0.3533438000081148,-0.23011486522265065,0.47314321395685},
{0.3594532572195643,-0.23411585825013975,0.44794067142137023},
{0.36003779556149723,-0.25978121761399703,0.4500883340588485},
{0.34973066536280234,-0.2809531963588075,0.4754112227235498},
{0.36570781747824654,-0.2389207634208284,0.4228027719495866},
{0.3721679976948558,-0.24470081608429456,0.39661751730749256},
{0.3679393785600964,-0.2640703536594507,0.4255487267723374},
{0.38813208365912744,-0.23792223439437357,0.2908784510971784},
{0.3784865133250672,-0.23212086327373105,0.33036050886469587},
{0.40395381734483427,-0.23957063251862443,0.24423112233424724},
{0.4382015749526008,-0.23908237108006866,0.14639109466151445},
{0.45212183979660814,-0.24095220608208703,0.10057910557381378},
{0.46320812522049126,-0.24668480798603157,0.058364434211585},
{0.4714459896887437,-0.2548050770937304,0.02082606958481959},
{0.4768237424345265,-0.2638413521678464,-0.010956311604323934},
{0.47920040656360907,-0.2684488896866118,-0.03731211390382904},
{0.475130644319422,-0.2424300565489269,-0.03200656883557901},
{0.4722794725951233,-0.23120692038381477,-0.013446444940958218},
{0.4667868752574547,-0.21977541349210766,0.014837646194758537},
{0.46272261455060343,-0.19101227599287277,0.0038414484447497656},
{0.45867348307142575,-0.16938140026503656,-0.008710996679134553},
{0.45405906863099055,-0.15574742167014294,-0.019369537575156172},
{0.46004611663671763,-0.1741103154512739,-0.045853938309886516},
{0.4538170009882136,-0.16923045183438448,-0.050834892675322006},
{0.44602888719716616,-0.17414751959750754,-0.04801329171420338},
{0.4407446605860925,-0.15574687151640937,-0.021418172540589333},
{0.43229842539124524,-0.16939570426210973,-0.012782821999822608},
{0.4237916732857038,-0.1910719676729666,-0.002206116471671583},
{0.42975190129691865,-0.16419943347919283,0.0866010745877801},
{0.444253266022024,-0.17974725937479152,0.0722406867569056},
{0.44152037735044586,-0.1594969256721675,0.05391781665989288},
{0.42953734134082094,-0.15340115353484088,0.061566328941043455},
{0.4393816547111383,-0.1487997364763616,0.036420177163256025},
{0.45101671848427144,-0.16073394634213098,0.021669180181536966},
{0.45468143004210737,-0.182371698991637,0.03615610337113574},
{0.45864872615341445,-0.21160631824055334,0.04934328836514252},
{0.4477357391556103,-0.20756200060654448,0.08869234646756603},
{0.4311589194705595,-0.18305498992874822,0.11074663426261175},
{0.41656127784207697,-0.17466294487665895,0.11824591734352767},
{0.41855558512631874,-0.16416841856246206,0.08462602268421382},
{0.4219239013601863,-0.15944514245199393,0.050778501917629594},
{0.4311829886964038,-0.14877119725143195,0.03516032511334883},
{0.4377944611897487,-0.14650545786888325,0.024219830428865465},
{0.4473630100011072,-0.14844612516410055,0.008748132056151428},
{0.43392069121315086,-0.20850393256765687,0.13150806078373523},
{0.4158185703017387,-0.19072131343702356,0.15045122921536383},
{0.40279986988864197,-0.1907087974395845,0.14738068368979854},
{0.4071625889959625,-0.18301936747449868,0.1060380059953003},
{0.41206033260919345,-0.17970482876808885,0.0667783478745842},
{0.4178101268173125,-0.18236578483900096,0.030276335343457503},
{0.4267920742102371,-0.16070052450281574,0.017893062492650262},
{0.4353572801499719,-0.1484206117847056,0.006903053972144335},
{0.4425381617575761,-0.14463336723655715,0.002217807238510196},
{0.4482817667361923,-0.1509295191174984,-0.02473766263060134},
{0.39865583689042106,-0.20117237760626736,0.19013175494227166},
{0.3979633308782723,-0.21669730335270562,0.22538423080599582},
{0.421970664427541,-0.23923503874113822,0.1946560817088325},
{0.007065486861984996,0.14838746502225714,-0.2827666406031335},
{0.01469419360872654,0.14191421865447526,-0.28867804247049283},
{0.007533598920048221,0.14085517271732617,-0.29120874964497895},
{0.0,0.14812682969097177,-0.2833814374004136},
{0.0,0.14054433585785125,-0.2920415448591916},
{0.00828497138169047,0.13375062494025675,-0.29818126052598826},
{0.016250097136518583,0.13506067851835346,-0.29485145505347155},
{0.013748410571479066,0.14910335256808321,-0.2809683255864811},
{0.006940670733678141,0.15689284174346468,-0.27248976885978576},
{0.0,0.15668309563253582,-0.27293608107615575},
{-0.007065486861984996,0.14838746502225714,-0.2827666406031335},
{-0.007533598920048221,0.14085517271732617,-0.29120874964497895},
{-0.00828497138169047,0.13375062494025675,-0.29818126052598826},
{0.0,0.13340127731943094,-0.2992760664558202},
{0.020611165782638385,0.16635479826894126,-0.2585626270941086},
{0.02135132886195886,0.17741288831397825,-0.24502746986361001},
{0.021737880629018273,0.1908084440345799,-0.22919885925623343},
{0.014540838255490018,0.19168318847097834,-0.22991887295506142},
{0.014318438608688715,0.17817210046632406,-0.24576948971178136},
{0.013934087456563644,0.1667983597166433,-0.2595831622699068},
{0.019774863338374117,0.15749869854257398,-0.2694893679352524},
{0.02534950235156336,0.1565221756654625,-0.26835054970673367},
{0.013619537059387033,0.15725388013112915,-0.2712931844892407},
{0.019666139206774593,0.15020847388041997,-0.2780318800334769},
{0.007024981793349879,0.1667337166529472,-0.2603499390360894},
{0.0,0.16657485976237485,-0.26066971589373505},
{-0.006940670733678141,0.15689284174346468,-0.27248976885978576},
{-0.013748410571479066,0.14910335256808321,-0.2809683255864811},
{-0.01469419360872654,0.14191421865447526,-0.28867804247049283},
{-0.016250097136518583,0.13506067851835346,-0.29485145505347155},
{-0.018209469658677743,0.12791761997993314,-0.29991699555544554},
{-0.009259706259167796,0.1265291694948007,-0.30404865009466087},
{0.0,0.22612625065416714,-0.19273948363945953},
{0.007192778682092977,0.20790653438220139,-0.21246799652577916},
{0.0,0.20786527285218262,-0.21257115035082613},
{-0.007192778682092977,0.20790653438220139,-0.21246799652577916},
{-0.007285135740118379,0.19187780535423368,-0.2303672482479323},
{0.0,0.1918049099845338,-0.23052404206200375},
{0.007285135740118379,0.19187780535423368,-0.2303672482479323},
{0.014369259059828532,0.20764108520574714,-0.21209664275561002},
{0.01389997792508144,0.22582435379286298,-0.19236262833195447},
{0.006955043499968022,0.2261448183426756,-0.19267621596009732},
{0.0,0.24637259574222273,-0.17108474499342907},
{-0.006955043499968022,0.2261448183426756,-0.19267621596009732},
{-0.01389997792508144,0.22582435379286298,-0.19236262833195447},
{-0.014369259059828532,0.20764108520574714,-0.21209664275561002},
{-0.014540838255490018,0.19168318847097834,-0.22991887295506142},
{-0.014318438608688715,0.17817210046632406,-0.24576948971178136},
{-0.007184526376089218,0.17827456659920407,-0.24631895575319832},
{0.0,0.17816178508381933,-0.24654520647613465},
{0.007184526376089218,0.17827456659920407,-0.24631895575319832},
{0.01322899667775914,0.2460136204310592,-0.17077734659478908},
{0.01864106526267434,0.2668458792453816,-0.1467253130546667},
{0.019818256714110548,0.24491950219339415,-0.17009790673381292},
{0.02082462543126895,0.22478731400505725,-0.19167424847280765},
{0.024784081851872482,0.2645868104768526,-0.14542695024340865},
{0.02313967234219012,0.2880123564528563,-0.12029455230896087},
{0.01743973581617713,0.29034156982241727,-0.12161835973039717},
{0.012452592221238823,0.26798813593473525,-0.14739925137830703},
{0.006619545999385203,0.24637534651089063,-0.17104967269291316},
{0.0,0.29195695872265304,-0.12252405031430971},
{0.0055023694433613286,0.31684591362998993,-0.09572743733577056},
{0.005845624111587682,0.2919425171871465,-0.12251854877697387},
{0.0,0.26838837277591754,-0.1476612620939264},
{0.0062338813552212,0.2683801204699138,-0.14764475748191888},
{0.011666972689680971,0.2915278388104576,-0.12228817190103562},
{0.010968208678812685,0.31641197987262565,-0.09550393738150208},
{0.01045250832279445,0.34241980993563886,-0.06710637703823362},
{0.0052517056484971516,0.3428729990736786,-0.06732781391600118},
{0.0,0.3168631059341645,-0.09572743733577056},
{-0.0055023694433613286,0.31684591362998993,-0.09572743733577056},
{-0.005845624111587682,0.2919425171871465,-0.12251854877697387},
{-0.0062338813552212,0.2683801204699138,-0.14764475748191888},
{0.016360953113835747,0.31517894781723066,-0.09483550059519755},
{0.015551470664083694,0.3411338255833864,-0.06643794025192916},
{0.015157904436921091,0.3679799523979482,-0.03648619561128616},
{0.01021601098657006,0.3693319551982307,-0.03715463239759061},
{0.005141221024950159,0.3698064627934468,-0.037377444659692095},
{0.0,0.34289087907002014,-0.06732712622383419},
{-0.0052517056484971516,0.3428729990736786,-0.06732781391600118},
{-0.01045250832279445,0.34241980993563886,-0.06710637703823362},
{-0.010968208678812685,0.31641197987262565,-0.09550393738150208},
{-0.011666972689680971,0.2915278388104576,-0.12228817190103562},
{-0.012452592221238823,0.26798813593473525,-0.14739925137830703},
{-0.006619545999385203,0.24637534651089063,-0.17104967269291316},
{-0.01322899667775914,0.2460136204310592,-0.17077734659478908},
{-0.019818256714110548,0.24491950219339415,-0.17009790673381292},
{-0.02082462543126895,0.22478731400505725,-0.19167424847280765},
{-0.02151334913649933,0.20667487771114038,-0.2113945090531235},
{-0.021737880629018273,0.1908084440345799,-0.22919885925623343},
{-0.02135132886195886,0.17741288831397825,-0.24502746986361001},
{-0.020611165782638385,0.16635479826894126,-0.2585626270941086},
{-0.013934087456563644,0.1667983597166433,-0.2595831622699068},
{-0.007024981793349879,0.1667337166529472,-0.2603499390360894},
{0.026781071135565444,0.3087916629703213,-0.09127394286240864},
{0.028742437965008846,0.28416884493160555,-0.11810150198846193},
{0.03173685596768947,0.3028761349499601,-0.08793175893088628},
{0.029728038378724456,0.3282946128258715,-0.05951012936177353},
{0.025240159297013558,0.33446940079318416,-0.06286400406013457},
{0.021644079417442213,0.31276652369546515,-0.09349931471475564},
{0.020497627805870004,0.3386168722522399,-0.06509900360281926},
{0.019900504697281347,0.36532889909424066,-0.03514725896217625},
{0.020052966050700793,0.3926715396533619,-0.0037011592426858765},
{0.015327076709998149,0.3954910775379795,-0.005039408199628784},
{0.010354924804300001,0.39692697878263355,-0.005708532678100238},
{0.005218517624518701,0.3974296817566959,-0.005931344940201761},
{0.0,0.3698243427897883,-0.0373767569675251},
{-0.005141221024950159,0.3698064627934468,-0.037377444659692095},
{-0.01021601098657006,0.3693319551982307,-0.03715463239759061},
{-0.015157904436921091,0.3679799523979482,-0.03648619561128616},
{-0.015551470664083694,0.3411338255833864,-0.06643794025192916},
{-0.016360953113835747,0.31517894781723066,-0.09483550059519755},
{-0.01743973581617713,0.29034156982241727,-0.12161835973039717},
{-0.01864106526267434,0.2668458792453816,-0.1467253130546667},
{0.032124232965349254,0.45925664602902466,0.09965622268572673},
{0.026469821660790333,0.44190548496395454,0.06365622543649538},
{0.0207680971351432,0.4201414032633744,0.028672637210060352},
{0.021859189527273528,0.4472385377188838,0.06140609666613711},
{0.027949322588830917,0.4677613350580652,0.09621707415866017},
{0.02313932849610663,0.4734616154301617,0.09393187308778596},
{0.016792961333132527,0.4504700032115224,0.060071973862196086},
{0.01591883581968436,0.4231576211077483,0.027335763637451407},
{0.025225648992290284,0.41516319966660686,0.030906261368411122},
{0.017809370355928836,0.4769186439535697,0.09260325182118077},
{0.011385156439652605,0.4521149628749383,0.059420041687899126},
{0.010775792410491706,0.4246925500244474,0.026670765311981835},
{0.005436853010613153,0.42522894991469173,0.026452079202882235},
{0.0,0.45270912890720894,0.05922680018897779},
{0.005749505377408899,0.45268987352653356,0.059216484806473096},
{0.012089559526290126,0.4786811989775393,0.09197882733356301},
{0.0061097597960029955,0.4792987465434872,0.09180552890748404},
{0.0,0.4793214403849975,0.09183234890199628},
{-0.0061097597960029955,0.4792987465434872,0.09180552890748404},
{-0.005749505377408899,0.45268987352653356,0.059216484806473096},
{-0.005436853010613153,0.42522894991469173,0.026452079202882235},
{0.0,0.42524682991103324,0.026454142279383197},
{0.012795544304911704,0.5038768645913492,0.12378390236421687},
{0.013409790948458159,0.5271903167441351,0.1542734222794382},
{0.0064708738298058155,0.5045425506089858,0.12366218085066144},
{0.007008821027425852,0.5488753138455127,0.1829515610268344},
{0.0,0.5279433396669782,0.1543249991919617},
{0.0,0.5489234522972013,0.18310422868790394},
{0.0070921693180638155,0.566940987072075,0.20927091564148953},
{0.0,0.567002879367103,0.20950060482526084},
{-0.0070921693180638155,0.566940987072075,0.20927091564148953},
{-0.007008821027425852,0.5488753138455127,0.1829515610268344},
{-0.0067861394268360865,0.5279068919821281,0.15423009767291845},
{0.0,0.504570745987832,0.12371582083968588},
{0.0067861394268360865,0.5279068919821281,0.15423009767291845},
{0.013838704553003529,0.5481050986184952,0.18288623027097134},
{0.013988896522271942,0.566115756471699,0.20906048183839368},
{0.013766978259987525,0.5806948304116731,0.23223295709694874},
{0.006989496877533715,0.5815888302287471,0.23263044316946316},
{0.0,0.5816713532887846,0.23295916002527953},
{-0.006989496877533715,0.5815888302287471,0.23263044316946316},
{-0.013766978259987525,0.5806948304116731,0.23223295709694874},
{-0.013988896522271942,0.566115756471699,0.20906048183839368},
{-0.013838704553003529,0.5481050986184952,0.18288623027097134},
{-0.013409790948458159,0.5271903167441351,0.1542734222794382},
{-0.0064708738298058155,0.5045425506089858,0.12366218085066144},
{0.013339096193692626,0.5913815666865408,0.2524857664913739},
{0.006799852008645665,0.592371843406992,0.2532260671091278},
{0.0,0.5924749972320389,0.2536778120936169},
{-0.006799852008645665,0.592371843406992,0.2532260671091278},
{-0.013339096193692626,0.5913815666865408,0.2524857664913739},
{-0.019357227885367215,0.5888508595120548,0.2520721884221522},
{-0.020120359883064824,0.5783566770439414,0.23235467861050418},
{-0.020494808267985384,0.5638738800073446,0.20934656177985733},
{-0.02031078184410156,0.5459821928990282,0.18330090864766022},
{-0.019708432275043857,0.5251843186930548,0.15478437755950425},
{-0.012795544304911704,0.5038768645913492,0.12378390236421687},
{-0.06677037064544723,-0.40731594434919904,0.6672910911542844},
{-0.03354727436648078,-0.41048895600764435,0.6672780250031118},
{-0.030662887110516943,-0.37542559548983967,0.775374293654183},
{-0.05876886597498588,-0.3592950880211589,0.8067323687762998},
{-0.06098949275138071,-0.37293133600020356,0.7752202506087794},
{-0.03170130228265661,-0.38821460671916513,0.7410536406767166},
{-0.06305868971260657,-0.3854693395885813,0.7409614899263413},
{-0.09064332914528804,-0.3687315999364572,0.7750043152683478},
{-0.08734309443595145,-0.35555060417195333,0.8064084657656524},
{-0.08380423054467283,-0.341320190160638,0.8342634369891737},
{-0.056389863692535576,-0.3445413402707719,0.8347262538175511},
{-0.029546418877425058,-0.3615025798771644,0.8069641210365721},
{0.0,-0.4008839595114359,0.7047765034841923},
{-0.032662558393661126,-0.3998936827909849,0.7047668757938546},
{-0.06498333378033325,-0.39692491570613264,0.7047276773403368},
{-0.09372831620635991,-0.3808707420679866,0.7408260145694462},
{-0.1192891463608362,-0.3627920026902517,0.7747574337804021},
{-0.11494637032635806,-0.350220989877859,0.8060384873798171},
{-0.11028106666556636,-0.3366844572630264,0.8337346017127661},
{-0.10543008611969007,-0.3225118093937374,0.8581181028773727},
{-0.08013401744950105,-0.3263883301390032,0.8588456811900375},
{-0.0539282008116143,-0.3290393834427107,0.859477670291492},
{-0.028351141121997277,-0.346418739886627,0.8350570337498684},
{0.0,-0.3470211582249014,0.8351890706459285},
{0.028351141121997277,-0.346418739886627,0.8350570337498684},
{0.0,-0.3310323153426185,0.8601055332399447},
{-0.02711570214401787,-0.3305571200552354,0.8599267332765299},
{-0.025878887781704496,-0.3143007649199973,0.8818462334068475},
{-0.024679415104058137,-0.29803203132575357,0.9010878602389454},
{-0.023556001180079757,-0.282134651501679,0.9179260029474485},
{0.0,-0.28222542686772034,0.9182670982622706},
{0.023556001180079757,-0.282134651501679,0.9179260029474485},
{-0.09662074946067742,-0.3919790336412131,0.704649968125468},
{-0.12336578552669311,-0.3744023095453735,0.740662343833705},
{-0.12723267858162116,-0.38505809967272725,0.7045227450745767},
{-0.09934469813408485,-0.40206541465430745,0.6672498296242656},
{-0.13094690397547964,-0.3947634992253148,0.6671081650378677},
{-0.15647816336677578,-0.3761634891850091,0.7043363804973252},
{-0.1516271828208995,-0.36604753740873464,0.7404835438702901},
{-0.14658915000560468,-0.35508159811407297,0.7745105522924562},
{-0.16125212238995032,-0.3854383934410672,0.6668193343277362},
{-0.18394046236295156,-0.3652670067992124,0.7041458897670717},
{-0.17815009431698067,-0.3557809810478916,0.740319873134549},
{-0.1722077463021073,-0.34556806467607293,0.7742946169520244},
{-0.16594011989225238,-0.33461037768741503,0.8053439182911675},
{-0.14125334648200755,-0.34325741899502044,0.805667821301815},
{-0.1355083661190574,-0.3305653723612392,0.8332057664363586},
{-0.1295137534994935,-0.3173176704565382,0.8573822722587042},
{-0.12342561474522036,-0.30382583783255934,0.8784552233314696},
{-0.1005309671221252,-0.3080324508179755,0.8794592538952604},
{-0.07644317358931986,-0.3111057471122086,0.8804302752350359},
{-0.05145938593215641,-0.3131585082306437,0.8812616950649147},
{-0.20920352180912552,-0.3523397694443241,0.7040056005650078},
{-0.22453149251894075,-0.32941555105804876,0.7401603285518096},
{-0.23185266332860888,-0.3373528940493309,0.7039705282644919},
{-0.21593327735519094,-0.36052605700005297,0.6662568021351467},
{-0.23928936642232962,-0.34484117405557513,0.6662134775286268},
{-0.2514704577760448,-0.3202781852353867,0.7040956882388821},
{-0.24366377629648883,-0.31326716359302653,0.7402249716155057},
{-0.23561365178982202,-0.30587791125882735,0.7741405739066209},
{-0.21705627866386915,-0.32099819893421466,0.7740786816115928},
{-0.20257279393510524,-0.34357857123700003,0.7402022777739954},
{-0.1897507734817648,-0.37404195884987607,0.6664968067014226},
{-0.2593094607874488,-0.3269391715647541,0.6664816774737491},
{-0.27617029733746223,-0.30712676023406293,0.6669314281509539},
{-0.26816280974514817,-0.30138728140844856,0.7043198758853176},
{-0.26003703910011355,-0.29538304109854696,0.7403638854332357},
{-0.25153166237890595,-0.28909203315501475,0.7742946169520244},
{-0.2423853565580732,-0.28249156373634154,0.8053439182911675},
{-0.22704431969708536,-0.29808429593044405,0.8051128537230623},
{-0.20915950951043882,-0.3120726422989824,0.8050200152805199},
{-0.1958093414728578,-0.3342177054600695,0.7741405739066209},
{-0.04905913396174643,-0.29726594225173797,0.9003547803889448},
{-0.04680309103875214,-0.28173166389182874,0.9170320031303746},
{-0.044776462222662336,-0.2669187746150815,0.9315725663089979},
{-0.022547294309553625,-0.2669902946004474,0.9326329876304809},
{-0.041752267149151485,-0.24091300762856918,0.9553598383648331},
{-0.02169201156148071,-0.2529820051590666,0.9454818280783336},
{-0.02102887000486198,-0.24049351540671143,0.9567455380812975},
{-0.04092511101070805,-0.23044839592363592,0.9651649532816325},
{-0.02059665547791511,-0.22990649449605574,0.9666964437374969},
{0.0,-0.2403202169806325,0.957243427210191},
{-0.04306445257296586,-0.25319106357782856,0.9442556729446083},
{-0.06186451226464595,-0.2414810413584946,0.9531963588075142},
{-0.060717097884039964,-0.23124749422166657,0.9627291476261898},
{-0.060193351529668065,-0.2224072114151398,0.9709835167064497},
{-0.040491727407077314,-0.22150358390772823,0.9736689546185062},
{-0.08700818835063222,-0.2660048317251652,0.9279786870443609},
{-0.06943215194695967,-0.28088717791077744,0.9157136972462742},
{-0.06636944611209794,-0.2666320069814509,0.9299778081737715},
{-0.08357247828440059,-0.25345238660128083,0.9399644738226537},
{-0.06379768371524318,-0.2533863681532508,0.9423755225600853},
{-0.07283966663434513,-0.2958224763932471,0.8992943590674618},
{-0.09113502904467867,-0.27947259512329975,0.9141017468068733},
{-0.10637497515712045,-0.26491071348750017,0.9257038013559913},
{-0.10206864680749227,-0.25327564971436706,0.9371442482458692},
{-0.09903317358244294,-0.24266868573086892,0.9469693062355111},
{-0.08106033879842299,-0.24209927661660952,0.9503630670795571},
{-0.11522488565398493,-0.24313631640441527,0.9432763992988291},
{-0.11410394742180767,-0.23456767200384557,0.9509001546619683},
{-0.09761859079496527,-0.23330644456960442,0.9555035660277318},
{-0.0797042098451386,-0.232226080175279,0.9594791144450427},
{-0.07924208070892809,-0.2235714742538368,0.967341498990124},
{-0.07940918990550422,-0.21587482352099766,0.9739791037858141},
{-0.06013111538855639,-0.21468374068778845,0.9779684060464645},
{-0.040360790818484336,-0.21378630240987967,0.9808732177597876},
{-0.0404409757251542,-0.2070038008746069,0.9867756796289763},
{-0.020279148004420485,-0.20650907512968153,0.9886441392466607},
{-0.020364421833125992,-0.20048207220905293,0.9933121936761203},
{-0.1187933203084437,-0.2526636036857549,0.9342635057583903},
{-0.12412706075553986,-0.26307320001732987,0.9235135018041603},
{-0.1332520481191963,-0.2514250700930241,0.931670906288876},
{-0.12907431820479334,-0.24344784095605715,0.9395470446772969},
{-0.12880267979883628,-0.23609091015370604,0.9457692834041312},
{-0.13073096863504793,-0.22892309469727448,0.9509001546619683},
{-0.11461902885487563,-0.22667159054258224,0.957341767190069},
{-0.09741984775870807,-0.22494066935829382,0.9628082322253924},
{-0.09803120609515321,-0.2173237909168243,0.9689458848156881},
{-0.09904899050228347,-0.21020892775725014,0.9739791037858141},
{-0.0799435267192476,-0.20887514879939262,0.9794194365187922},
{-0.060368094109297665,-0.20779959825023603,0.9836934433365723},
{-0.06074226741735143,-0.20147743785153965,0.9881661931906096},
{-0.04064109414574535,-0.2008628473619097,0.9913770279182389},
{-0.04088357440382247,-0.19507523008460675,0.9946703857059056},
{-0.15341999630021613,-0.25587443841338414,0.9210020500103496},
{-0.14766951439993012,-0.27000513706048734,0.909453635450256},
{-0.13992266213890145,-0.2602137759870274,0.9217653883156973},
{-0.14495313034035948,-0.24864816912275925,0.9304468142316519},
{-0.13054391636562943,-0.2742880838764382,0.9106777275074803},
{-0.13759551184584143,-0.2861122629954908,0.895458412160048},
{-0.1560084696167285,-0.28051719952494225,0.8945602861899722},
{-0.16268871132677137,-0.2642539674680343,0.9089474940153589},
{-0.16427659254032798,-0.2495978720053585,0.9217653883156973},
{-0.15340211630387465,-0.24341964557721096,0.931670906288876},
{-0.14185507712811496,-0.2387495280712504,0.9395470446772969},
{-0.13867450085583288,-0.24360532246229555,0.9365610852882702},
{-0.14577285940339954,-0.2320507186726991,0.9432763992988291},
{-0.14957579708679844,-0.22451498790693322,0.9469693062355111},
{-0.1331530204471512,-0.2215138992902329,0.9555035660277318},
{-0.11595865319615249,-0.21916061669482767,0.9628082322253924},
{-0.11763043285408066,-0.21186213972666984,0.967341498990124},
{-0.11914060485276855,-0.20460664351894833,0.9709835167064497},
{-0.10006746260158073,-0.2033478230072916,0.9779684060464645},
{-0.080580329665871,-0.2023107832194859,0.9836934433365723},
{-0.08119581415531801,-0.19596531005632886,0.9867756796289763},
{-0.06114676794996902,-0.1954577932370977,0.9913770279182389},
{-0.11740280674681032,-0.29040208673311146,0.8966831919094391},
{-0.11160281101050175,-0.2773586294020035,0.9123247502473971},
{-0.09572056041410072,-0.29357578608372376,0.8980303808645528},
{-0.14483140882680404,-0.2983497451068983,0.877557785053561},
{-0.15208174734327323,-0.3107082610396943,0.8567337785452422},
{-0.1644540171194088,-0.29146800959193037,0.8769079159557648},
{-0.19146175159321083,-0.2928509585397269,0.8560811586787782},
{-0.18096619374076342,-0.3135972558331769,0.8324121696756637},
{-0.17283148309755808,-0.3025852411633275,0.8562682109481968},
{-0.18199910737556724,-0.28304309285425944,0.8766445298558114},
{-0.15917460435350403,-0.3228927908542443,0.832742949607981},
{-0.18868347523861198,-0.3242317275033542,0.8051128537230623},
{-0.2005716097291937,-0.3026086226970049,0.8322801327796036},
{-0.20766996827676032,-0.28140707318901426,0.8562682109481968},
{-0.19717097196347805,-0.2729381441526566,0.8769079159557648},
{-0.18633363110404164,-0.26465970584655246,0.8945602861899722},
{-0.17235147396500608,-0.2734291563598803,0.8941923708806379},
{-0.17531130105168763,-0.2567787536129627,0.909453635450256},
{-0.17298896460379645,-0.24175405514878562,0.9235135018041603},
{-0.1597605180797709,-0.2364113747035187,0.9342635057583903},
{-0.2900479252671168,-0.28570858769347357,0.6674341311250163},
{-0.2820356238296339,-0.2809518209744735,0.7045818866009369},
{-0.2737172993778449,-0.2760135035233908,0.7405447484731513},
{-0.2648605119593106,-0.27087575534388386,0.7745105522924562},
{-0.2552321339294249,-0.26552069643961135,0.805667821301815},
{-0.2445997253357485,-0.2599318221985656,0.8332057664363586},
{-0.23233748630632972,-0.27556031438535106,0.832742949607981},
{-0.21767864007498594,-0.2898581222290304,0.8324121696756637},
{-0.2931934292388829,-0.2592441300315857,0.7048225788593799},
{-0.284770575577713,-0.25540749543200475,0.7407373022799058},
{-0.2756504020592254,-0.25146426854654197,0.7747574337804021},
{-0.2656327902628291,-0.24739725707102278,0.8060384873798171},
{-0.2545169340757658,-0.24318858100910573,0.8337346017127661},
{-0.24239635963274486,-0.23891663726782653,0.8581181028773727},
{-0.2330733169249982,-0.2542301664421352,0.8573822722587042},
{-0.22151940082756877,-0.2684633312221184,0.8567337785452422},
{-0.28395290959117386,-0.23109482656059702,0.7750043152683478},
{-0.27928966900688307,-0.20859340131858098,0.8067323687762998},
{-0.2898182360833455,-0.21000055703065526,0.7752202506087794},
{-0.29326426153208185,-0.23381602446533653,0.7409085376294837},
{-0.2992533726143099,-0.21147978288182903,0.7410453883707128},
{-0.2932972707560969,-0.1884192639080583,0.775374293654183},
{-0.28264354370524414,-0.1883641797654832,0.8069641210365721},
{-0.2707038323021389,-0.18842559067599451,0.8350570337498684},
{-0.267517754492521,-0.20721966744582188,0.8347262538175511},
{-0.2736361517021413,-0.2283461209691783,0.8064084657656524},
{-0.3017421305666102,-0.2365351592935751,0.7049800603656184},
{-0.30774430780001083,-0.21306697640321867,0.70506395880999},
{-0.3027942995820895,-0.18864131970877612,0.7411327252759192},
{-0.29444021513761753,-0.16658517514487955,0.775436185949211},
{-0.28374522655674594,-0.1678841568790879,0.8070562717869475},
{-0.2717491243959484,-0.16937947472696901,0.8351890706459285},
{-0.25855093632726994,-0.17101301870041308,0.8601055332399447},
{-0.25757441345015847,-0.1885765391066466,0.8599267332765299},
{-0.25459326790630055,-0.20588506325736394,0.859477670291492},
{-0.26213862636240415,-0.22554583846523613,0.8342634369891737},
{-0.311265291694948,-0.1890810988495598,0.7050832141906653},
{-0.3039434331931129,-0.16554311520425488,0.7411567945017635},
{-0.3123669745464498,-0.16481842519869147,0.7050467665058154},
{-0.3188388455298977,-0.18978914670468228,0.6680688709951387},
{-0.31982086994434505,-0.1644718283465336,0.6679340833304106},
{-0.31111399941821244,-0.14052063385962416,0.7049635557536109},
{-0.30275647651290555,-0.1424270031957055,0.7411031545127391},
{-0.2932972707560969,-0.14473420353900143,0.775374293654183},
{-0.31544233391718396,-0.21480133604834198,0.668131450982334},
{-0.3184606148380588,-0.1390785887731503,0.6677704125946694},
{-0.30743690940137086,-0.11630133020295859,0.7049456757572693},
{-0.2991763510916081,-0.1194125183355924,0.7410687699043902},
{-0.2898182360833455,-0.12299415667965717,0.7752773290586388},
{-0.27928966900688307,-0.1269846967862082,0.8067729426141517},
{-0.28264354370524414,-0.14737875815173102,0.8069641210365721},
{-0.2707038323021389,-0.15029718616996035,0.8350570337498684},
{-0.25757441345015847,-0.15339936553520675,0.8599267332765299},
{-0.24335156405267996,-0.15659527734281248,0.8818462334068475},
{-0.24424831463842178,-0.17272654127287695,0.8820766102827858},
{-0.24335156405267996,-0.18879048013979405,0.8818462334068475},
{-0.2406076723064301,-0.20459522782897643,0.8812616950649147},
{-0.24955179663017085,-0.22273386519445526,0.8588456811900375},
{-0.3095598151208378,-0.23927767565549096,0.6680764356089754},
{-0.3011190814633264,-0.26298998926512523,0.6678584371920427},
{-0.31467349407450046,-0.11372227826913384,0.6677098956839751},
{-0.301268310663561,-0.09227425988849759,0.7051052203400087},
{-0.28460690484197176,-0.07416622482444937,0.7414456252118952},
{-0.29253874629591803,-0.06855328135755935,0.7055529079407126},
{-0.3083756092092984,-0.08851567834986888,0.6678831941100541},
{-0.2994823741059142,-0.06357163929995689,0.6684216570767993},
{-0.28118013477391085,-0.045251519971612066,0.7064008323825989},
{-0.2735034271139141,-0.05217314163226488,0.7420521697031713},
{-0.2648605119593106,-0.05971850008836844,0.7756583105191457},
{-0.2756504020592254,-0.08035854894201998,0.7753316567398302},
{-0.2931452907871943,-0.09661909899947667,0.7411506052722607},
{-0.28790989031997627,-0.03900246125026563,0.6694552584037702},
{-0.26712439457300846,-0.022483407707241193,0.7077610874888851},
{-0.2597770914609951,-0.030759782936844424,0.7430658279572998},
{-0.25153166237890595,-0.03970115649191721,0.7763033657717727},
{-0.2423853565580732,-0.04925732684427004,0.8067502487726413},
{-0.2552321339294249,-0.06783808150390025,0.8064717334450145},
{-0.2656327902628291,-0.08707778279793059,0.8064400996053335},
{-0.28395290959117386,-0.10149297969451339,0.775234004452119},
{-0.24337219481768937,-0.010045119483075557,0.7445842522619914},
{-0.23064576357555913,0.02099799262656459,0.7124649019110276},
{-0.2503020687843459,-0.0003624137719984126,0.7097457670827891},
{-0.2563888321542851,0.008557641325897994,0.6735346483382949},
{-0.23627108550145481,0.031323690513767946,0.6768424476614684},
{-0.21313780869641757,0.053263821409095,0.6811694067761059},
{-0.20808533434561619,0.041483654588729144,0.7160319611811525},
{-0.22422959565763656,0.00985050259982024,0.7467037195206235},
{-0.21705627866386915,-0.0020451965045982564,0.7789000913942888},
{-0.23561365178982202,-0.02043408504964107,0.7773548470950851},
{-0.27357288402277913,-0.014922232331297074,0.6711160349870265},
{-0.22565311844328498,-0.14518329403172597,0.9003595942341137},
{-0.2406076723064301,-0.14054537771148426,0.8812713227552523},
{-0.25459326790630055,-0.1358839148114451,0.8594941749034996},
{-0.23596368710281476,-0.12472569678689589,0.8804687859963868},
{-0.22146438545421035,-0.13077202385741665,0.8993136144481374},
{-0.20614260397389797,-0.13659416328150195,0.915721949552278},
{-0.20981969399073955,-0.14967406829745986,0.9170340662068756},
{-0.22813087332091359,-0.15979476514968652,0.9010878602389454},
{-0.22894166238578292,-0.17446200122546746,0.9013732524882421},
{-0.22813087332091359,-0.18904059378092467,0.9010878602389454},
{-0.22565311844328498,-0.20335559392877847,0.9003547803889448},
{-0.23596368710281476,-0.21994871191818663,0.8804302752350359},
{-0.26213862636240415,-0.11259934572967233,0.8343707169672224},
{-0.24239635963274486,-0.10174054887462614,0.8582852120739488},
{-0.2545169340757658,-0.09427159301827405,0.8340028016578882},
{-0.2736361517021413,-0.10683882352374842,0.8065693857327256},
{-0.2445997253357485,-0.0764831285042214,0.8337414786344358},
{-0.2330733169249982,-0.08540909775475385,0.8577171783440234},
{-0.22076293944389086,-0.09437206484386981,0.8786464017538901},
{-0.2293666561449765,-0.10928501333091264,0.8795548431064705},
{-0.24955179663017085,-0.1186148641911124,0.8589123873302345},
{-0.267517754492521,-0.13132252143708406,0.8347530738120632},
{-0.17744314676932535,-0.16851422044247488,0.9454818280783336},
{-0.15788311846391576,-0.16102793474351487,0.9553598383648331},
{-0.17585251478710082,-0.15771992911269142,0.9442556729446083},
{-0.1950803877758591,-0.16584432437339208,0.9326329876304809},
{-0.19319198508533228,-0.15389409128013207,0.9315732540011649},
{-0.17325372608808373,-0.14692754956713217,0.9423755225600853},
{-0.1557966604292987,-0.15111973477088503,0.9531963588075142},
{-0.13773786412440625,-0.15444940270496837,0.9627291476261898},
{-0.13936769456014864,-0.16369459865941288,0.9651649532816325},
{-0.1591924843498455,-0.17082734181532852,0.9567455380812975},
{-0.17798642358123948,-0.179218424098384,0.9459308910633715},
{-0.19571168918514667,-0.17776608701093913,0.9330297860108283},
{-0.21273000724139848,-0.1761612198008581,0.9182670982622706},
{-0.21200793046606958,-0.16290781005117116,0.9179260029474485},
{-0.19005404572740295,-0.14203251546103915,0.9299798712502725},
{-0.16968597912579195,-0.1362289643562273,0.9399644738226537},
{-0.15300325484702632,-0.14116056993176032,0.9503630670795571},
{-0.13563352609344773,-0.14497224130567984,0.9594791144450427},
{-0.11763043285408066,-0.14782713344460194,0.967341498990124},
{-0.11914060485276855,-0.15702274679380718,0.9709835167064497},
{-0.12037157383166258,-0.1657888276155168,0.9736689546185062},
{-0.14042467742079676,-0.17269373835651197,0.9666964437374969},
{-0.15965255040955506,-0.1804600523058662,0.957243427210191},
{-0.17744314676932535,-0.1897406644069102,0.9454818280783336},
{-0.1950803877758591,-0.1895424027551699,0.9326329876304809},
{-0.21200793046606958,-0.1893001288047429,0.9179260029474485},
{-0.18567138354723997,-0.1303765320921865,0.9279835008895296},
{-0.20095259118970057,-0.12380233251429197,0.9141210021875488},
{-0.21552066205500298,-0.11670541812027599,0.8980778316240744},
{-0.19422764948880403,-0.11143267596839092,0.9123632610087481},
{-0.18005156315868015,-0.1190430901034908,0.925713429046329},
{-0.16518847235374334,-0.12571611104578034,0.9371442482458692},
{-0.14577285940339954,-0.12165157526206229,0.9432763992988291},
{-0.14957579708679844,-0.1312084333065821,0.9469693062355111},
{-0.13073096863504793,-0.12553799877453256,0.9509001546619683},
{-0.1331530204471512,-0.13527699896639866,0.9555035660277318},
{-0.1597605180797709,-0.11580681076568333,0.9342635057583903},
{-0.17298896460379645,-0.10838461797668586,0.9235300064161678},
{-0.16427659254032798,-0.09875328287048211,0.9217922083102096},
{-0.15340211630387465,-0.10691900843041827,0.931670906288876},
{-0.14185507712811496,-0.11287827367259938,0.9395470446772969},
{-0.12880267979883628,-0.11592956381748924,0.9457692834041312},
{-0.11410394742180767,-0.11722772032109721,0.9509001546619683},
{-0.11461902885487563,-0.1279873519656649,0.957341767190069},
{-0.11595865319615249,-0.1381679536825572,0.9628082322253924},
{-0.16268871132677137,-0.0796635672380701,0.909108413982432},
{-0.17531130105168763,-0.08908268054154382,0.9095609154283049},
{-0.1857525312229436,-0.09976590958636004,0.9107444336476774},
{-0.18633363110404164,-0.0783108767456206,0.8948277984429274},
{-0.17235147396500608,-0.06750661387941592,0.8945946707983211},
{-0.1560084696167285,-0.05806184965811384,0.8951345091494004},
{-0.14766951439993012,-0.07178921684928331,0.9096833246340273},
{-0.15341999630021613,-0.09061877853492685,0.9210419361560346},
{-0.14495313034035948,-0.09994003324303935,0.9304468142316519},
{-0.13867450085583288,-0.10634746747044127,0.9365610852882702},
{-0.12907431820479334,-0.10611488997956865,0.9395470446772969},
{-0.11522488565398493,-0.10570344375606458,0.9432763992988291},
{-0.09903317358244294,-0.10520569216560452,0.9469693062355111},
{-0.09761859079496527,-0.11792758463943268,0.9555035660277318},
{-0.09741984775870807,-0.1295210430364635,0.9628082322253924},
{-0.09803120609515321,-0.14012748918775988,0.9689458848156881},
{-0.19809591792806602,-0.0902571899935288,0.895626209048791},
{-0.21006176163351645,-0.08016489482779844,0.87789269113888},
{-0.22151940082756877,-0.06977599803044963,0.8573196922715091},
{-0.19717097196347805,-0.06684161555394635,0.8774436281538421},
{-0.2077779359469762,-0.10312796782150811,0.8967787811206493},
{-0.21767864007498594,-0.04309973118113193,0.8339127139840139},
{-0.19146175159321083,-0.04122783310261261,0.8574874891602522},
{-0.2005716097291937,-0.027792391236326104,0.8345302615499618},
{-0.22704431969708536,-0.03147085663750164,0.8073629824934204},
{-0.20915950951043882,-0.014616897009157994,0.8083952084360573},
{-0.18096619374076342,-0.01359980029419472,0.8356271305562948},
{-0.17283148309755808,-0.028623123374037825,0.8582769597679452},
{-0.18199910737556724,-0.054580064216694556,0.8774477543068441},
{-0.20766996827676032,-0.05499680566988438,0.8572055353717905},
{-0.23233748630632972,-0.059378092465713385,0.8336802740315746},
{-0.18868347523861198,0.0011690766838658526,0.8099342635057584},
{-0.16594011989225238,0.015642933722292016,0.8118130385059474},
{-0.15917460435350403,-0.0007041967789874262,0.8370554671871121},
{-0.15208174734327323,-0.01730233492121456,0.8594288441476363},
{-0.1644540171194088,-0.043559109548674514,0.8780556741824543},
{-0.19809591792806602,-0.25443234793922725,0.895458412160048},
{-0.1857525312229436,-0.24782775236755222,0.9106777275074803},
{-0.21006176163351645,-0.2613656603667187,0.877557785053561},
{-0.22076293944389086,-0.2485353876073745,0.8784552233314696},
{-0.2077779359469762,-0.24296920720783916,0.8966831919094391},
{-0.19422764948880403,-0.23765197137275043,0.9123247502473971},
{-0.18005156315868015,-0.23271640469033564,0.9257038013559913},
{-0.18567138354723997,-0.2227599974968005,0.9279786870443609},
{-0.20095259118970057,-0.22650035519300424,0.9141017468068733},
{-0.21552066205500298,-0.23049515899099055,0.8980303808645528},
{-0.20614260397389797,-0.21462253608492723,0.9157136972462742},
{-0.19005404572740295,-0.21216334889580704,0.9299778081737715},
{-0.17325372608808373,-0.20989602782127428,0.9423755225600853},
{-0.16968597912579195,-0.21935729665458392,0.9399644738226537},
{-0.15788311846391576,-0.1990146058939345,0.9553598383648331},
{-0.17585251478710082,-0.19999504861639772,0.9442556729446083},
{-0.19319198508533228,-0.20104948701602804,0.9315725663089979},
{-0.1591924843498455,-0.18986809376545158,0.9567455380812975},
{-0.14042467742079676,-0.1898980771439319,0.9666964437374969},
{-0.13936769456014864,-0.19811400423205758,0.9651649532816325},
{-0.1557966604292987,-0.20786252208351472,0.9531963588075142},
{-0.15300325484702632,-0.21637477572639202,0.9503630670795571},
{-0.16518847235374334,-0.22829316867232086,0.9371442482458692},
{-0.22146438545421035,-0.217232327858616,0.8992943590674618},
{-0.20981969399073955,-0.20217166309410586,0.9170320031303746},
{-0.2293666561449765,-0.23465982275422084,0.8794592538952604},
{-0.1873892385803558,0.07388083257515271,0.6861558626788773},
{-0.15942767507095262,0.09267958565171552,0.6914407769821178},
{-0.18299557332552113,0.060658575280629984,0.7201416095710245},
{-0.1722077463021073,0.031407588958139485,0.7835358242919005},
{-0.1958093414728578,0.015338286092319915,0.7810284986510917},
{-0.2022929032231444,0.02880948795128938,0.7495232574052412},
{-0.17791421590370657,0.04645635664816087,0.7527904828905627},
{-0.15144494439664982,0.06242044261243252,0.7562557637199745},
{-0.14658915000560468,0.0458560013863874,0.7862205745117901},
{-0.15574783428544314,0.07808469479190089,0.7244891994506714},
{-0.1192891463608362,0.05837612497842365,0.7888778170450005},
{-0.11494637032635806,0.03968602726424366,0.8159226868958194},
{-0.14125334648200755,0.028563294155510573,0.8138651119322156},
{-0.1355083661190574,0.01071218088504607,0.8386701683951809},
{-0.1295137534994935,-0.0073823754125293345,0.8607973515599265},
{-0.14483140882680404,-0.03382070077207199,0.8790982155075958},
{-0.08734309443595145,0.04876906540571431,0.81781934189235},
{-0.08380423054467283,0.02837830496259298,0.8418706877403054},
{-0.13759551184584143,-0.0499264513227415,0.8962286273870653},
{-0.12342561474522036,-0.025407474801239775,0.8804068937013585},
{-0.11740280674681032,-0.04304884196077542,0.8976590270943836},
{-0.13054391636562943,-0.06528880664090572,0.9109858135982873},
{-0.11028106666556636,0.020467094273656082,0.8403240680567676},
{-0.10543008611969007,0.0010177844071302545,0.8622360035732485},
{-0.1187933203084437,-0.09322912046234921,0.9342635057583903},
{-0.1332520481191963,-0.09575728317581743,0.931670906288876},
{-0.13992266213890145,-0.08445072995085064,0.9218224667655567},
{-0.12412706075553986,-0.079769471831785,0.9235905233268621},
{-0.10637497515712045,-0.07609513258361132,0.9258014536437025},
{-0.10206864680749227,-0.09121390733623128,0.9371442482458692},
{-0.09113502904467867,-0.05572851013555101,0.9145728159412545},
{-0.11160281101050175,-0.05999220157082645,0.9127153593982418},
{-0.09572056041410072,-0.03737882004402606,0.8992070221622553},
{-0.07283966663434513,-0.03286412096780294,0.9006532387894142},
{-0.06943215194695967,-0.05232718467766836,0.9162576617503553},
{-0.08700818835063222,-0.07320132394495987,0.9280962824049144},
{-0.08357247828440059,-0.08958325166988851,0.9399644738226537},
{-0.06186451226464595,-0.10411150515872278,0.9531963588075142},
{-0.06379768371524318,-0.08820917395104594,0.9423755225600853},
{-0.08106033879842299,-0.10466172766152342,0.9503630670795571},
{-0.06636944611209794,-0.07086186396211092,0.9301139712228335},
{-0.041752267149151485,-0.10362654464256855,0.9553598383648331},
{-0.04092511101070805,-0.1182689550311215,0.9651649532816325},
{-0.060717097884039964,-0.11831062917644049,0.9627291476261898},
{-0.0797042098451386,-0.11822377365575093,0.9594791144450427},
{-0.05145938593215641,-0.008596152087248888,0.8842751621406207},
{-0.07644317358931986,-0.012730557395132102,0.8831473469867736},
{-0.1005309671221252,-0.01836344393486455,0.8818125364906656},
{-0.08013401744950105,0.0077805491772107,0.8636003848325366},
{-0.07924208070892809,-0.13042013177557304,0.967341498990124},
{-0.07940918990550422,-0.14140178483625016,0.9739791037858141},
{-0.09904899050228347,-0.1498884907151242,0.9739791037858141},
{-0.10006746260158073,-0.1589456028618997,0.9779684060464645},
{-0.10095871164998668,-0.16737973467460812,0.9808732177597876},
{-0.12120436904587524,-0.17415976051807977,0.9753324819704305},
{-0.14080978503430552,-0.1814329304144927,0.967236969780743},
{-0.121521395134853,-0.18216951749454488,0.9759087680063596},
{-0.10159620228877707,-0.1752716899828696,0.9826495266270968},
{-0.1018513360827266,-0.18270254769317099,0.9832560711183731},
{-0.12120436904587524,-0.18985248315326114,0.9753324819704305},
{-0.080580329665871,-0.16032408181061095,0.9836934433365723},
{-0.08119581415531801,-0.16853608905338485,0.9867756796289763},
{-0.040360790818484336,-0.1427208815663427,0.9808732177597876},
{-0.060368094109297665,-0.15228324114819833,0.9836934433365723},
{-0.06013111538855639,-0.14223702135765562,0.9779684060464645},
{-0.0799435267192476,-0.1513195093453927,0.9794194365187922},
{-0.060193351529668065,-0.13096595304850497,0.9709835167064497},
{-0.040491727407077314,-0.13124488099143203,0.9736689546185062},
{-0.13773786412440625,-0.2061055373660977,0.9627291476261898},
{-0.13563352609344773,-0.21389702084876341,0.9594791144450427},
{-0.10159620228877707,-0.18975318040434921,0.9826495266270968},
{-0.10095871164998668,-0.19658210116089314,0.9808732177597876},
{-0.12037157383166258,-0.19730073947538715,0.9736689546185062},
{-0.08186287555728854,-0.1830645488498692,0.9892747529637812},
{-0.08166482021319832,-0.18962210627732287,0.9886441392466607},
{-0.08166482021319832,-0.17607608351058598,0.9886441392466607},
{-0.2113676890586113,-0.0026400502290358824,-0.011132360799070814},
{-0.20029859593890267,-0.007297101583823836,-0.03728116775631489},
{-0.18872473676863077,-0.012676229713940692,-0.06236473954690715},
{-0.1766846223091465,-0.018809756151234522,-0.0861815823659224},
{-0.16421607562963375,-0.025732065504054293,-0.10853157779276948},
{-0.1513569197992764,-0.033476166996415056,-0.12921323202252333},
{-0.13814635327159233,-0.04207644523666583,-0.1480257389424257},
{-0.12484913753086876,-0.05131008796270509,-0.16514927390022552},
{-0.11173209713789398,-0.060956345988932285,-0.18076469993583835},
{-0.09906068126912214,-0.0707937824375799,-0.1950521923970129},
{-0.08710033910100752,-0.08060034150793012,-0.20819192663149813},
{-0.07596247676460091,-0.08999985558464493,-0.2208124532799134},
{-0.06575540577620158,-0.09861615705238633,-0.2335402599063776},
{-0.056590119651560127,-0.10607314706503297,-0.2470038971515103},
{-0.046802403346585156,-0.10488343961615774,-0.26223834172661625},
{-0.03804326821576204,-0.10437489125867609,-0.27860472760857113},
{-0.03539585968053948,-0.10010459797859764,-0.27989621349815935},
{-0.03214823342197685,-0.09697277908095445,-0.28169796697564675},
{-0.02825988437143904,-0.09481452598410468,-0.28387863883714004},
{-0.023690376229507634,-0.09346493010640661,-0.2863055044944121},
{-0.018399203927547503,-0.09275908286621844,-0.2888492778200708},
{-0.012566817890174184,-0.09250360522618538,-0.29113929273611394},
{-0.006373606649708177,-0.09250504937973604,-0.29280900931754117},
{-0.2381099743559591,-0.04870029618901631,0.016570630455547887},
{-0.2307599204752778,-0.022771550725205775,0.016186898226373134},
{-0.22610286912048985,-0.05058663580304222,-0.01077819933307617},
{-0.2193779274195933,-0.025655043981352543,-0.010979693138001274},
{-0.22189419305857278,0.0013299966509391407,0.015880187519900092},
{-0.24390928240010065,-0.07603977336416945,0.01700869036591409},
{-0.23147168186810202,-0.0770206287019329,-0.010542320919802034},
{-0.21846879837484587,-0.07867555990177004,-0.03702190780936349},
{-0.21353667015326594,-0.05316754450571781,-0.03712506163441047},
{-0.20744440524599092,-0.02923723247915089,-0.03721308623178391},
{-0.18219647502749048,-0.03861253979158801,-0.0860502331620292},
{-0.20049665128299288,-0.05646090229338461,-0.062264336490528094},
{-0.19502812317116863,-0.033546311597447004,-0.06230559802054685},
{-0.20499347036287452,-0.08100449819446422,-0.062232014958680026},
{-0.1870673986462092,-0.06048390147021708,-0.08598902855916798},
{-0.16901891772382144,-0.044464800132587044,-0.108239308621803},
{-0.1626605159479252,-0.09203356763005462,-0.12827315683026178},
{-0.17983012628091263,-0.11134348229433362,-0.10808113942339766},
{-0.17699683455295537,-0.0876836395970399,-0.10805569481321936},
{-0.15938710123310082,-0.0707869055159101,-0.12837493527097477},
{-0.17333556145595433,-0.06525304664822276,-0.10809489326673727},
{-0.19113853627473026,-0.0840072372723653,-0.08597596240799538},
{-0.19425103102248134,-0.10876690605230999,-0.08599109163566898},
{-0.19624671369105703,-0.13434609758764465,-0.08601172240067836},
{-0.18166695205891595,-0.1358196843630492,-0.10812996556725318},
{-0.16521529234825555,-0.11447200026957532,-0.12828897375010231},
{-0.14822310659434895,-0.09705688383297606,-0.14643029311503233},
{-0.14530591642202018,-0.07710191391606992,-0.14662490999828767},
{-0.14189702635030074,-0.05864845107654771,-0.14712073605068016},
{-0.15556284509252552,-0.051134038767958225,-0.12866582905760732},
{-0.20838379274608546,-0.10676193953948007,-0.062203819579833876},
{-0.21053076769139675,-0.13331765395192618,-0.06217218574015281},
{-0.2112996075340803,-0.16025620659373005,-0.06213092421013398},
{-0.19696603969771803,-0.16032855180969632,-0.08601722393801421},
{-0.1823360765373874,-0.16069942419534858,-0.10815953633043333},
{-0.16688294585318184,-0.1377001235782824,-0.12835499219813237},
{-0.15049936766705246,-0.11813272321284278,-0.1464289177306984},
{-0.13387372183814614,-0.10256818639758648,-0.1628963943611993},
{-0.13129143775113658,-0.08398426835398817,-0.16317903584182805},
{-0.1282435860670816,-0.06678109864325212,-0.16388048185214757},
{-0.22213557300918277,-0.10534831952103615,-0.036906375525310904},
{-0.22443108946256166,-0.13277252037116122,-0.036784654011755395},
{-0.22524944314126777,-0.16053527207509047,-0.03665949403736512},
{-0.2105527738407401,-0.18716230016525243,-0.06207315806810768},
{-0.19625152753622588,-0.18629780234214197,-0.08598696548266707},
{-0.18166695205891595,-0.18556967387574366,-0.10812996556725318},
{-0.16749499188179395,-0.16131607776147946,-0.12839969218898606},
{-0.15198478274772906,-0.13994916373194036,-0.14651419155940393},
{-0.13587146758322277,-0.12218082315377002,-0.16288470359436066},
{-0.11980216471740321,-0.10838227982331812,-0.17804075126243094},
{-0.11754240825670723,-0.09121995902730069,-0.17837290657908217},
{-0.11482464881280263,-0.07530463043766793,-0.1792194556366345},
{-0.23541353336923088,-0.1045456452237372,-0.010284436357184557},
{-0.24812345999935356,-0.10437372218199224,0.017476321039460438},
{-0.23785690363851048,-0.1327490700682672,-0.010019674872897314},
{-0.25165613466112935,-0.162358619086621,0.01840401777271633},
{-0.2507174348532018,-0.13328546995851154,0.017949453250342633},
{-0.23873027269057495,-0.161218494242985,-0.009761790310279838},
{-0.2509058625069543,-0.19117656565156424,0.018815945380737307},
{-0.23796418361655933,-0.18954150875535283,-0.009524536512671778},
{-0.22448472945158612,-0.1882234779481191,-0.03653708483164268},
{-0.22205992687081497,-0.2155646743536897,-0.036421552547590025},
{-0.23546648566608833,-0.21745582781288447,-0.009316165786076868},
{-0.2483586507204607,-0.2194968981644808,0.019172857615399875},
{-0.23114502808878654,-0.24469944069996058,-0.00914424274433187},
{-0.21789732618408555,-0.24228495350169413,-0.03632114949121097},
{-0.20822562354768007,-0.21376017010753443,-0.06200576423574362},
{-0.19404747414105528,-0.21198179816372437,-0.08592988703280777},
{-0.17961075247964603,-0.21016629084289742,-0.10805500712105243},
{-0.16688294585318184,-0.18491787923988007,-0.12835499219813237},
{-0.15252943494397714,-0.1621257665188816,-0.14657883462309998},
{-0.13716570424147898,-0.1424701077407318,-0.1629961097254114},
{-0.12152277051918696,-0.1264711282759076,-0.17804006357026395},
{-0.10619755057803965,-0.11431369353273656,-0.19223265451239527},
{-0.10425688328282233,-0.09859490736442665,-0.19254074060320228},
{-0.10186302684956527,-0.08399183296782495,-0.19341135888659886},
{-0.2439085947079337,-0.2470781679055441,0.01946237601769842},
{-0.23744910218349138,-0.27367672553999306,0.019672809820794293},
{-0.22887289316908493,-0.2990511911172178,0.01979040518134784},
{-0.22490834782644575,-0.27100985531644495,-0.009017019693440594},
{-0.16500073239215785,-0.20825161831159195,-0.12824221068274763},
{-0.17611865165572205,-0.23422451361252258,-0.10794979021950446},
{-0.16180158843136727,-0.23106319272091597,-0.1280847291765093},
{-0.14743363598665601,-0.22756490266748913,-0.14612908394589516},
{-0.15030200001512922,-0.20617602581321315,-0.14635395928449757},
{-0.15198478274772906,-0.18428210783150714,-0.14651419155940393},
{-0.1376367733758602,-0.1630842030920015,-0.16308207124628393},
{-0.12262101490985386,-0.14516626677367156,-0.17818654200183068},
{-0.10764170412869746,-0.13085881060888951,-0.19227941757974995},
{-0.09324968245814189,-0.12017716325605736,-0.20584139480476077},
{-0.09163291817357212,-0.10589503479378519,-0.20601881938384156},
{-0.08958015705513708,-0.09261521766488623,-0.20673126846883277},
{-0.19029748875451383,-0.23710800686866934,-0.08585561627877394},
{-0.19856905013894818,-0.2649299688681756,-0.06186891349451465},
{-0.20425282589903715,-0.23977487709221745,-0.06193561963471171},
{-0.21191921817652917,-0.26811260821695865,-0.03624000181550737},
{-0.20404789363327713,-0.29277462470919213,-0.03618567413431593},
{-0.19110896551155013,-0.2889503685686169,-0.06181321042898928},
{-0.18494724369541013,-0.2614041711280696,-0.08577515629523727},
{-0.1438431951828539,-0.2938281691090054,-0.12756758466694035},
{-0.16462937862198868,-0.2796678996987221,-0.10770978565322852},
{-0.15126958289406994,-0.2741058454521885,-0.12772506617317878},
{-0.13123848545427913,-0.2862800598842339,-0.14538981486639174},
{-0.13794967331183608,-0.26785953749951,-0.14561469020499415},
{-0.15724012628778952,-0.25309960051962016,-0.12790455382876056},
{-0.17114113575112144,-0.25747951193111523,-0.10782944409028303},
{-0.17793966051388485,-0.284598652535968,-0.08569675938820152},
{-0.1692190361444126,-0.30641912499424057,-0.08563074094017147},
{-0.15653455412446815,-0.30052422773888876,-0.10760456875168055},
{-0.1349162631632877,-0.31201281308045514,-0.1274548031515557},
{-0.12315053787842839,-0.30322685795511983,-0.14522889489931848},
{-0.11161037562433852,-0.2937504598941367,-0.1612672516176239},
{-0.11883870799146436,-0.2781536015470323,-0.16148249926588862},
{-0.12480925138518395,-0.261150412718454,-0.16178508381935977},
{-0.14333223990278782,-0.24820735844372513,-0.14587188707544463},
{-0.18180724126097988,-0.31156031163458237,-0.06177401197547144},
{-0.17059785893920731,-0.3324847211992801,-0.061759570439964835},
{-0.15873104290580198,-0.32659257471259623,-0.08558672864148478},
{-0.1468071484225373,-0.3197851099516621,-0.10752961030547971},
{-0.12444133607584969,-0.3284060189569223,-0.127410103160702},
{-0.1136376921325953,-0.3184571763772239,-0.14516493952778933},
{-0.10307130198694898,-0.30771061088382884,-0.1611812900967514},
{-0.0928246886989483,-0.29653767624690625,-0.17587658401294515},
{-0.10039686714956411,-0.28390477113948526,-0.17598386399099397},
{-0.10676420892363109,-0.2697190571190237,-0.17625756547345198},
{-0.1119872309318435,-0.25419784491028713,-0.17664267308696074},
{-0.12957427041018774,-0.24297058259217308,-0.16213099297935069},
{-0.1574161754825364,-0.35144783270375113,-0.06177538735980537},
{-0.14641929004036064,-0.344847363285078,-0.08557503787464608},
{-0.13539764768017362,-0.3371850971605878,-0.10750003954229964},
{-0.12225860113785544,-0.3524601155735456,-0.10752961030547971},
{-0.11237233854535225,-0.34275402832879115,-0.1274548031515557},
{-0.10265318514942517,-0.3317289475077692,-0.14522889489931848},
{-0.09316922247460524,-0.3198050530245045,-0.1612686270019579},
{-0.08398715666108948,-0.3074011494086879,-0.17599005322049682},
{-0.07517644461774287,-0.29493604119001,-0.1898099150081251},
{-0.08298106302079787,-0.28530972623662526,-0.1896668750373933},
{-0.08961110320265119,-0.27401300700964626,-0.18979478578045156},
{-0.09513602207216779,-0.26124944039049913,-0.19012556571276887},
{-0.09962252576954472,-0.24722327095277685,-0.1905925086941482},
{-0.11612438700839466,-0.23755775754587424,-0.17708279607382785},
{-0.1331874050555002,-0.22384448804412782,-0.16247690213934154},
{-0.13570023223364477,-0.20400119933513922,-0.1627794866928127},
{-0.13716570424147898,-0.18367123087957893,-0.1629961097254114},
{-0.12301437482936638,-0.16414730641293576,-0.1782965727485474},
{-0.1085439562517751,-0.1479409464982371,-0.1924733467708383},
{-0.09441875914200774,-0.1351988014900914,-0.2059871855441605},
{-0.08112910801512097,-0.1257696134963714,-0.219286464361385},
{-0.07982524366652706,-0.11286225044510875,-0.21926858436504354},
{-0.0781087640177452,-0.10085906505499129,-0.21970939504407766},
{-0.20632553009031462,-0.3197816714908272,-0.008928307403900193},
{-0.21666566951302454,-0.2961243732545513,-0.008942061247239804},
{-0.2180733753788324,-0.3229588093022744,0.019803471332520455},
{-0.20494395652685193,-0.3451582001445529,0.01970031750747348},
{-0.19379577880794063,-0.3417183639253194,-0.008982635085091601},
{-0.19420633103162765,-0.31599798918810373,-0.036163667984972545},
{-0.182316821156712,-0.3375103755555693,-0.03618017259698008},
{-0.16830096710149442,-0.3570380823291308,-0.036241377199841295},
{-0.15208312272760718,-0.3743087834106643,-0.036354158715226036},
{-0.142196860135104,-0.3681731938968695,-0.061829027348829814},
{-0.1322280744825632,-0.36091185230572864,-0.08560460863782623},
{-0.11639258695351683,-0.37479635715705306,-0.08566443785635353},
{-0.10760525644384752,-0.3656307959555448,-0.10760456875168055},
{-0.09890938899238656,-0.3550877873435758,-0.12756758466694035},
{-0.0903806307375017,-0.3430868713376094,-0.14538981486639174},
{-0.08207399705255136,-0.330092927842524,-0.16148593772672354},
{-0.07404381561872696,-0.31657014907103104,-0.17626994393245768},
{-0.06634455165565327,-0.3029834149280089,-0.19015651186028293},
{-0.05903039530608834,-0.28979691762616916,-0.20355894450255446},
{-0.06680372371554576,-0.28283059597466265,-0.2031449538180325},
{-0.07362432339686921,-0.274398802315322,-0.2029702800076196},
{-0.0793548622243128,-0.26439700743876615,-0.20311400767051843},
{-0.08407311818196198,-0.25301638976741564,-0.20349705220752626},
{-0.08785404971601751,-0.24044606464718984,-0.20404101671160735},
{-0.10313869581931301,-0.23213736788573855,-0.19112753320005862},
{-0.11923619406397876,-0.22001610575055067,-0.177523606752862},
{-0.12138179362495606,-0.20178909994161492,-0.17790940205853772},
{-0.12262101490985386,-0.18309384453618255,-0.17818585430966366},
{-0.10885960695641887,-0.16527072033691415,-0.19260607135906543},
{-0.09512914515049799,-0.15069742301114267,-0.20624300703027706},
{-0.08203823705986842,-0.13934174793468848,-0.219558790459509},
{-0.07000843798288885,-0.13088817506441958,-0.23298804309629276},
{-0.06898721511492367,-0.119238188371263,-0.2327542277595196},
{-0.06758308524838409,-0.10840772443349637,-0.232875949273075},
{-0.1893780443272617,-0.3654059206169424,0.019467189862867305},
{-0.1712690464941797,-0.38346059076883293,0.01909239763186324},
{-0.1789849526076943,-0.3616731275345754,-0.009113984288984764},
{-0.10854533163610906,-0.1825588200302722,-0.19247059600217037},
{-0.09537052510110794,-0.16641029502681653,-0.20639773776784748},
{-0.08257051079711086,-0.15333898616294592,-0.21988338116232353},
{-0.07068650245953104,-0.14313823506556111,-0.2333924060904769},
{-0.060058495095723315,-0.13532969681715434,-0.24736768630784267},
{-0.05927287556416546,-0.12476468893276364,-0.24693787870348025},
{-0.058135570258414086,-0.1149453387881076,-0.24676114181656636},
{-0.10753167338198068,-0.19960161992766853,-0.19213431453251714},
{-0.10575261374600364,-0.21619597576297728,-0.19166393309030297},
{-0.09290996252765382,-0.2124982549811263,-0.20529330414767774},
{-0.09433692377413713,-0.19750078912676158,-0.20584345788126168},
{-0.09513189591916592,-0.18207482228315175,-0.20623819318510814},
{-0.0827438092231898,-0.1675218118763062,-0.2200566795884025},
{-0.07106267007486904,-0.15576901520418612,-0.23378095216482056},
{-0.06054875084156328,-0.14643887551327625,-0.24788483081741156},
{-0.05145127116458605,-0.13889127518070832,-0.26284419852572555},
{-0.05083613052122252,-0.12918359249012645,-0.262281666333136},
{-0.04989935625136249,-0.12015632618339786,-0.2618944956431262},
{-0.048576374060526534,-0.11199458923803018,-0.2618305402715972},
{-0.04013075778862956,-0.10994863627204828,-0.27795348312644114},
{-0.032627967477662036,-0.10832863983429368,-0.2952255595923086},
{-0.03016981182679235,-0.104046105633643,-0.2961903917025814},
{-0.02719629966598791,-0.10082089813972392,-0.29756371296004025},
{-0.023712038532767498,-0.09851204045830556,-0.29923205415713355},
{-0.019721773503083267,-0.09697876200280715,-0.3010833214706435},
{-0.015230112114453982,-0.09608015464821451,-0.3030061087695193},
{-0.010362351879703384,-0.09565082842836896,-0.304728777647804},
{-0.005243845327028571,-0.09552553091554522,-0.30597968969954037},
{-0.004333512820988914,-0.09647530256736117,-0.3215490403599656},
{0.0,-0.09642640765428888,-0.32195477873848377},
{0.0036156309678785866,-0.09554038506635198,-0.33911819984196834},
{0.0030632078501436244,-0.09290693668211909,-0.3582862436121994},
{0.0,-0.09269897857082439,-0.35866722507270626},
{0.0,-0.08845509266995796,-0.37909649627717856},
{-0.002346756396740614,-0.08328894280395478,-0.3998235381899529},
{-0.004285670076932122,-0.07829918597878194,-0.4197391033456912},
{-0.00615992693958418,-0.073946575946316,-0.4386300071726293},
{-0.00833565429439689,-0.07059022555615385,-0.45617991127395674},
{-0.008729014213909399,-0.06138546590112775,-0.47795224528054053},
{-0.009599907574172757,-0.050604515799383694,-0.5008523944409716},
{-0.011010157900998461,-0.03807132605617482,-0.525176066387051},
{-0.013021382412547907,-0.02361259824542221,-0.5512052149072407},
{-0.015695198326982494,-0.007055033941046914,-0.5792149168683324},
{-0.011873761724291831,0.0035120438967664027,-0.590217991540011},
{-0.00796457560109453,0.011805611430544113,-0.5991511127890801},
{-0.003996921889860598,0.017245256471355205,-0.605175296171824},
{0.0,0.019251942214602587,-0.6074653110878672},
{0.0,0.04204137293614986,-0.6418086579068438},
{-0.005933531801292723,0.06372086850019151,-0.674976051120285},
{-0.014026375745372346,0.08009550668815017,-0.7031026607497634},
{-0.016350431423680954,0.10303004045693018,-0.7393371610279347},
{-0.018674212025122768,0.1242900437991141,-0.7752071844576068},
{-0.020922896641930377,0.1427985907812114,-0.8100112850284601},
{-0.010611502751800206,0.15322744249346176,-0.8217914518488261},
{-0.07107023468870581,-0.18129491059657984,-0.23376719832148096},
{-0.06053740392080812,-0.19233697741412617,-0.24778236468453158},
{-0.070653493235516,-0.19380650680574552,-0.2332775614985913},
{-0.08257532464227972,-0.18165058498534184,-0.21987512885631977},
{-0.08198184630217606,-0.19554843106470565,-0.21942812894778288},
{-0.06983926570981178,-0.2059316200170685,-0.23259674625328117},
{-0.05995719803952717,-0.2032929451723666,-0.2470616632935366},
{-0.0514082216349331,-0.2012374332852636,-0.26259387857694483},
{-0.051818980166270213,-0.19120166641565903,-0.2633324599642813},
{-0.060811242941699525,-0.18101653280738636,-0.2483029476549353},
{-0.06086880277607574,-0.16948379762869986,-0.24851819530320002},
{-0.07117751466675469,-0.16856105227904622,-0.23396800443423907},
{-0.08088085114284121,-0.20903833815061695,-0.21880576753666603},
{-0.0685380145914524,-0.217506029341074,-0.23182446794976272},
{-0.058980400085548904,-0.2137326624208552,-0.2462453726913314},
{-0.050672528554698,-0.21079071533051516,-0.2617610833627322},
{-0.04357953400603381,-0.20870068129662983,-0.27814603693319556},
{-0.04415623265726316,-0.19982560126645388,-0.27897195522573837},
{-0.044463149671386294,-0.19050118317437328,-0.27970778584440686},
{-0.05199220982313245,-0.18082418530828206,-0.26386817216235864},
{-0.05201545381837637,-0.17024582931893031,-0.2640923598087941},
{-0.051976186595641814,-0.15960750657261788,-0.26389774292553875},
{-0.060800102328594445,-0.15789075184696924,-0.24832357841994476},
{-0.07918844071990366,-0.22194370689459533,-0.21809813229684374},
{-0.066662265436798,-0.22836606404202076,-0.23105769118358013},
{-0.05751705992343235,-0.22350339272930578,-0.24543802208729698},
{-0.04952435771270835,-0.2197203981187493,-0.2609413542996921},
{-0.04265190604199461,-0.21699644944534188,-0.27734006171349507},
{-0.03686779599474328,-0.21531366671274202,-0.2944072059136025},
{-0.03766668798512384,-0.20748291600734178,-0.29517398267978506},
{-0.038165264806184276,-0.19911789725741486,-0.2959717055934818},
{-0.0384348401356404,-0.1903358619774313,-0.29668896852364185},
{-0.04458129518567344,-0.180856988224647,-0.2802448734268182},
{-0.04459174810661154,-0.1710227151599675,-0.2804731872262555},
{-0.04457558734068751,-0.16112792518459376,-0.2802826964960021},
{-0.04446507520945384,-0.15134130918708597,-0.27980956428511994},
{-0.05180976509123268,-0.1490942750314791,-0.26343217532849333},
{-0.09077399065701422,-0.22687652280834228,-0.20466612889139213},
{-0.07682071658899184,-0.2340869751791266,-0.2173939355178563},
{-0.06412351226395825,-0.2383465404614002,-0.23039613131894546},
{-0.05547708987930315,-0.23245439397471632,-0.24474620376731523},
{-0.047876165896107596,-0.2278853672173018,-0.2602433467502075},
{-0.041292338627875326,-0.2245844448157982,-0.27666406031335383},
{-0.035697206388110074,-0.22249317293601228,-0.29378140604165076},
{-0.03106250502874897,-0.2215551608202517,-0.31137050859649595},
{-0.0321398435775397,-0.21465210684810737,-0.31191584848491105},
{-0.032899193268318916,-0.2071575000739269,-0.3126200452638984},
{-0.0333992830121467,-0.1991747006304074,-0.31337031741807353},
{-0.03369884172008315,-0.19080624341964558,-0.3140559465085525},
{-0.03854665888199134,-0.18125419922029462,-0.29721642841571544},
{-0.03857217226138629,-0.17199002296204147,-0.2974426791386518},
{-0.038582556413107684,-0.1626607222555753,-0.29725700225356727},
{-0.0385100048894913,-0.15341690168546473,-0.29679281004085584},
{-0.03828671124287293,-0.14440907643629666,-0.2961807640122437},
{-0.04419219895759621,-0.14183151679447425,-0.279190641334838},
{-0.06483713042563331,-0.2641762582531656,-0.21620285268464703},
{-0.06972854727092802,-0.25537998774532555,-0.21635689573005054},
{-0.07369515569006814,-0.24529154365573028,-0.21678395256574512},
{-0.06083338662947627,-0.24728447555563807,-0.2299381283357368},
{-0.05277026474085352,-0.24043162311168326,-0.24427307155643305},
{-0.0456404098920392,-0.2351453334241087,-0.25977571607666117},
{-0.03941961531875563,-0.23133345574253905,-0.27622737578732154},
{-0.034083674256725115,-0.22890383931659902,-0.2934066138106467},
{-0.02960837994166995,-0.2277643333959133,-0.311094744037537},
{-0.027359695324862342,-0.2217133300186571,-0.32920580494711993},
{-0.0284360023354026,-0.21499182677859544,-0.3296390510123173},
{-0.029242321401186544,-0.20774472041531106,-0.3302572862704322},
{-0.0298223209748174,-0.20005652829612575,-0.3309449784374121},
{-0.030219875816548485,-0.1920126617881784,-0.33158728292137135},
{-0.03047886068663312,-0.1836981884125245,-0.33206935513042424},
{-0.03385652953397165,-0.18215486965138822,-0.3145634633277837},
{-0.03393107536487227,-0.17332338930459879,-0.31478283712905025},
{-0.033981345662278506,-0.16441461235824084,-0.31460128639696755},
{-0.033940084132259705,-0.15555789370892328,-0.31415634956493155},
{-0.03374030955775204,-0.14688259513017668,-0.31358762814283914},
{-0.033314971952474966,-0.138518133410905,-0.31303266056408635},
{-0.03784473148715494,-0.1357879611233864,-0.295554276448125},
{-0.0436892209066671,-0.13276722514147546,-0.2785627783863854},
{-0.0428883346090023,-0.12431713887049312,-0.27806145079665695},
{-0.04172400300108861,-0.11665349736166901,-0.27781525700087817},
{-0.034566227850294916,-0.11380927132825677,-0.2947799350681056},
{-0.028253213757419335,-0.11112094510909892,-0.3129274436625385},
{-0.02593115238639497,-0.10661608003086362,-0.3137279173449031},
{-0.023177564180590714,-0.10310479259548089,-0.3148344140415737},
{-0.02002697128678895,-0.10047712082545066,-0.31616647376901386},
{-0.016513758313338685,-0.09862289643562273,-0.3176408857750187},
{-0.0126724474070223,-0.09743208867928031,-0.319174439307384},
{-0.008585011474143806,-0.09676337681610905,-0.32054982364134377},
{-0.007184182530005728,-0.09602974681237487,-0.33822351233272746},
{-0.0036156309678785866,-0.09554038506635198,-0.33911819984196834},
{0.0,-0.09541790709141286,-0.3394840520748017},
{-0.0030632078501436244,-0.09290693668211909,-0.3582862436121994},
{-0.0026492446733083976,-0.08876104691504731,-0.37865637329031127},
{-0.004710650082282367,-0.08458469238497833,-0.3985100461510214},
{-0.006498917916375257,-0.08099727742671092,-0.4174559653513179},
{-0.008373614902014182,-0.0783419604315681,-0.43525343863275795},
{-0.010685773505834035,-0.07683440166311474,-0.45164801989355907},
{-0.0111457020271102,-0.06849482752336607,-0.4721274926262207},
{-0.01216039181948906,-0.05874816644075979,-0.49359724207933353},
{-0.013816560865226776,-0.047419813374099735,-0.5163667297280383},
{-0.016200789608146127,-0.03433371912863901,-0.5407247862824668},
{-0.019399658492069878,-0.019315209893964746,-0.5669877501394297},
{-0.0234998167300375,-0.002188924167497049,-0.5954444520090584},
{-0.019093360400897024,0.011776040667363987,-0.6095008799021278},
{-0.014491255650250766,0.023880798190544374,-0.6221062773228695},
{-0.009742328621954297,0.033425965468225516,-0.6323185060025212},
{-0.004895639275199964,0.03971284725875588,-0.6391954276723203},
{-0.011793301740755182,0.056542049969088244,-0.6671982527117422},
{-0.020768853596526877,0.06793504609944442,-0.6901671710888712},
{-0.02413263106209241,0.08963998627366433,-0.7249781485813942},
{-0.02744882022970294,0.10980999753118513,-0.7593971415387388},
{-0.030633935270287092,0.12737296778368504,-0.7926608116555569},
{-0.033604559123990206,0.14125540955850852,-0.8240195744698409},
{-0.023021458058686276,0.1574780677775646,-0.8430205090434959},
{-0.011696268375994315,0.16849145783174785,-0.8559353679393786},
{-0.012660550332533547,0.17871744035473913,-0.8876723614455014},
{0.0,0.18310147791923606,-0.8930638680346239},
{0.013461161553331557,0.18280989644043655,-0.9163009863568751},
{0.0,0.18729846321431443,-0.9221738774628836},
{-0.014088474348050634,0.18125983829606385,-0.9412298274098968},
{-0.014533067334003143,0.17456034120534555,-0.961867469340964},
{-0.014785244051634677,0.16320448045200628,-0.9776156199648038},
{0.0,0.1676036472441768,-0.9848570184831025},
{0.014835583118257606,0.14768395593543668,-0.987882864017814},
{0.014674525612750913,0.1284911552471944,-0.9920846631580613},
{-0.1425420816029279,-0.3948212653673411,-0.009604308804041452},
{-0.16180158843136727,-0.3793832639108091,-0.009329919629416442},
{-0.15093467680875075,-0.3992713213798681,0.01862064080531501},
{-0.12869333674428649,-0.41278859861402517,0.01809730706624329},
{-0.12150351513851151,-0.40796031190965926,-0.009909644126180532},
{-0.1339369895175083,-0.389312163417665,-0.036501324838959695},
{-0.12519504669085965,-0.38266355554730325,-0.06190948733236649},
{-0.10666380586725202,-0.3949202930393862,-0.06200645192791062},
{-0.09914733048216161,-0.3865132562980568,-0.08574489783989013},
{-0.09165354893858152,-0.37671845676376187,-0.10770978565322852},
{-0.08425054276104278,-0.36543755445662346,-0.12772506617317878},
{-0.07700433039757547,-0.35257427247326417,-0.14561469020499415},
{-0.06995686107036535,-0.3386326891720805,-0.16178989766452861},
{-0.06315228461653254,-0.32412032137230345,-0.1766605530833022},
{-0.0566323439506127,-0.30954124743232936,-0.1906372086850019},
{-0.05044008860225879,-0.2954029841713894,-0.20413041669331472},
{-0.044618361793473664,-0.2822102976400468,-0.2175507293319277},
{-0.05215594932809037,-0.27747622476255707,-0.21689123254379394},
{-0.058937556863546056,-0.27150293060016956,-0.216411223411242},
{-0.051645681740191275,-0.2613739126727225,-0.23002546524094325},
{-0.05670352008989511,-0.25501482320465924,-0.22978202221383237},
{-0.10486205238976466,-0.4239622209431148,0.0175670964055018},
{-0.07975922521849699,-0.4327419868389473,0.017074708813944187},
{-0.09898228436208643,-0.41877289585108435,-0.010219793293488457},
{-0.08685964684256457,-0.4049447817574523,-0.0621096057529576},
{-0.08072680809743772,-0.39607355280341155,-0.08583498551376449},
{-0.07462078934682309,-0.38574304107103924,-0.10782944409028303},
{-0.06859591827191211,-0.3738356511997821,-0.12790455382876056},
{-0.06270748532292993,-0.3602358509055874,-0.14587188707544463},
{-0.056988087108591406,-0.3454855416160353,-0.16213649451668655},
{-0.051470182699178,-0.330126624758706,-0.17710548991533823},
{-0.046186368703404555,-0.31470168945334664,-0.19118461164991793},
{-0.04116896665311913,-0.29975194943537037,-0.2047802857911108},
{-0.036450710695469964,-0.28582068151669127,-0.21829825071743483},
{-0.03920986920782676,-0.2704686415810318,-0.2313086988245278},
{-0.04577574771050086,-0.2664841531655502,-0.2305687420528574},
{-0.039944324442161304,-0.2572862704321939,-0.2450040883299327},
{-0.04499604233157903,-0.25286165902984514,-0.24440442076032623},
{-0.04930663437264251,-0.24728516324780503,-0.24412384235619838},
{-0.042729752795296734,-0.24135931984493916,-0.25964642994926895},
{-0.036952794746581995,-0.23711488379033915,-0.27614003888211514},
{-0.03195581715365588,-0.23442807049394865,-0.29339492304380804},
{-0.02771880817445925,-0.23317647075004522,-0.3112020240155859},
{-0.02596952560931245,-0.2278234749222736,-0.3290717049745588},
{-0.024560513128387314,-0.22291128977353608,-0.34706173206275337},
{-0.025724225813350717,-0.21631494650786479,-0.34735056277288484},
{-0.026661137621644144,-0.20926472641198676,-0.3478608303607839},
{-0.02739834362464661,-0.2018238971652641,-0.3484728763893961},
{-0.02796287012452042,-0.19405558890862562,-0.3490649793451658},
{-0.02838181219264458,-0.1860233443983003,-0.34951610540670464},
{-0.028682264900398106,-0.1777904313136502,-0.3497052207526241},
{-0.030643012806891225,-0.17519831322865284,-0.33227635047268517},
{-0.03075613816835942,-0.16659824129605216,-0.33209273666410155},
{-0.030750567861806882,-0.1580011952089862,-0.33167599521091173},
{-0.030558564208786092,-0.14951074140780213,-0.33118360761935417},
{-0.030112251992416128,-0.1412301093636853,-0.3307730553956671},
{-0.029344031072682873,-0.13326277611700119,-0.33060044466175514},
{-0.03259688379171455,-0.13059391158616887,-0.31262967295423616},
{-0.037116190405456426,-0.12770416033130258,-0.29504469655239285},
{-0.036042840471234176,-0.12032281645702371,-0.2947531150735934},
{-0.030109294916098116,-0.11672941857690358,-0.3125175791310184},
{-0.026760784216639535,-0.11897322057932563,-0.33096973535542334},
{-0.024905321980911038,-0.11300363995463981,-0.3315109490908366},
{-0.022647078442982412,-0.10805266896768466,-0.3322901043160248},
{-0.02003969359187808,-0.10404892517152763,-0.33326662719313627},
{-0.017136669878189084,-0.1009211636576696,-0.3344040700373211},
{-0.013991784829373258,-0.09859807074839476,-0.3356625467028943},
{-0.01065860966523833,-0.0970083327659873,-0.3370035464285051},
{-0.009111508597183625,-0.09498080995008042,-0.35611932559404563},
{-0.006106878365823349,-0.09363327714888328,-0.35736404841627933},
{-0.05214425856125171,-0.38031233602839887,-0.1280847291765093},
{-0.03817564895790567,-0.39768619093497937,-0.10805500712105243},
{-0.05672270670135386,-0.39272517964238635,-0.10794979021950446},
{-0.06136758590478626,-0.40348962513212283,-0.08592438549547192},
{-0.041303272933330304,-0.40877110097452857,-0.08600140701817367},
{-0.035094856819052375,-0.38489855508998794,-0.12824221068274763},
{-0.04767467209118248,-0.3661163066254326,-0.14612908394589516},
{-0.04333746636325688,-0.3507092513164147,-0.16248377906101139},
{-0.039155885372718836,-0.33466470536860643,-0.1775504267473742},
{-0.03515337942246236,-0.3185534532806011,-0.19173201461483394},
{-0.03135333004616478,-0.3029490303196599,-0.20542877950457278},
{-0.02777905000828669,-0.2884242840608773,-0.21904233364210712},
{-0.03206392236230511,-0.2734497871248897,-0.23214493249957535},
{-0.03425738529810424,-0.2606848451214086,-0.24581418970263505},
{-0.07068581476736406,-0.42060765855258675,-0.03700334012085504},
{-0.05067734239986686,-0.4333079574923718,-0.010749316262062984},
{-0.07527478459762099,-0.42723082181277033,-0.010508624003620041},
{-0.09296291482451127,-0.41247226021721445,-0.03684173246161477},
{-0.05370263778084488,-0.43907769477333314,0.016664844282424172},
{-0.04758300272532406,-0.4264330988990736,-0.03713812778558308},
{-0.06603619048797947,-0.4127390847780026,-0.06220863342500273},
{-0.11413833203015668,-0.4020365315832942,-0.03666912172770281},
{-0.021401392851715002,-0.2648997104128285,-0.247629009331295},
{-0.024453920842505424,-0.2755499990028464,-0.23297566463728706},
{-0.02804112949312273,-0.2631804799953787,-0.24672606951605036},
{-0.026367355527910332,-0.3378088339560386,-0.17793966051388488},
{-0.029175615260989492,-0.35436433518391297,-0.16278705130664953},
{-0.06466830199863974,0.24666417722102219,0.40762471813217305},
{-0.052723020288982,0.27199394280739325,0.3983216184972688},
{-0.04172379669343852,0.2756820358989065,0.413580819990386},
{-0.028854738095876662,0.27881928756466884,0.42481702230667073},
{-0.02378967897841953,0.3085303399468689,0.41320740314371596},
{-0.012131990132992787,0.3102612611311573,0.4197851787208787},
{0.0,0.31090975484461936,0.42205593825624643},
{0.012131990132992787,0.3102612611311573,0.4197851787208787},
{0.0,0.3444808233600777,0.4096898577096137},
{-0.010264699591992237,0.3439836219233512,0.40752018892279207},
{-0.00901034907942088,0.3806107944288682,0.3950874022359623},
{-0.008242265698121018,0.4185686512774913,0.3826031761750424},
{-0.007833639012501555,0.45628719125200545,0.3701841433315522},
{0.0,0.49249212076699683,0.35981470822252887},
{0.007657864894621491,0.4921915992900266,0.35794652368171126},
{-0.079861691351377,0.22500187396115504,0.4169202531532405},
{-0.09854284906738627,0.20532012414218992,0.42715998951957135},
{-0.09170237508243709,0.2200958780419203,0.39460257925824144},
{-0.07469918625385881,0.2424149273212533,0.38738731304228824},
{-0.06122901593313981,0.26814699282530763,0.3792990903895707},
{-0.05117447506737664,0.2989810465161859,0.3699591304545164},
{-0.043785222733177497,0.30267601652936893,0.3880605636737615},
{-0.034498834017930885,0.30593086355568483,0.4025543637850301},
{-0.02933254661349431,0.3402969042161719,0.39100526153276954},
{-0.02016395956645135,0.3425649129828716,0.4012216163654231},
{-0.14502946417089424,0.17453352121083335,0.37278705818357116},
{-0.1262313987864984,0.19056706408396995,0.3428155767777358},
{-0.15005511852718342,0.17051464818700274,0.34205271985690494},
{-0.1722483201399591,0.1528045118107691,0.3694816657829822},
{-0.1759996809108345,0.14962737399932194,0.33886739850867076},
{-0.15285815179979356,0.16646139055482315,0.3116755000725515},
{-0.12927787508621938,0.18614314037378818,0.31286178969135686},
{-0.10795254098817238,0.20647613467488318,0.312146397283891},
{-0.10495489083230695,0.21114556448867675,0.34130065970309575},
{-0.12082132450886746,0.19494560011113105,0.37228628074757636},
{-0.13721865653833643,0.1786803049777222,0.4044675233935683},
{-0.16684374739966398,0.15568525429824795,0.4009547918046349},
{-0.19781052567876936,0.13100467011750594,0.3942188470290667},
{-0.20052209589317113,0.1295508888765104,0.3641756393302153},
{-0.2027096446763342,0.12737159239935109,0.3343924480396991},
{-0.17814115431880995,0.14620129162342801,0.308644778800376},
{-0.15399903310481322,0.1622114529628873,0.2810661154126256},
{-0.13065119634367828,0.18145101671848426,0.28237555006777204},
{-0.10932036070829541,0.20140371725123937,0.282074065821768},
{-0.09065433221995971,0.22318361587166008,0.27996065025420536},
{-0.08943505400790433,0.2286913424370022,0.30947207935417453},
{-0.08665471457680456,0.2336104045074095,0.33765272783413414},
{-0.0997359949770964,0.21561693895838013,0.36897380511766753},
{-0.11235652162551173,0.19950087302520594,0.4013233948061361},
{-0.12387399003809127,0.18379948546872066,0.4410252389902203},
{-0.16271071747611474,0.15660126026466517,0.43253705457318725},
{-0.19576532917417108,0.13108581779320957,0.42436589624513193},
{-0.22574045534849144,0.10464680474149995,0.41691543930807157},
{-0.22669841053709447,0.1051275015662189,0.3876940237487612},
{-0.22789361952330553,0.10456290629712839,0.3586746521481096},
{-0.22882956856256517,0.1032136542655138,0.329760703756656},
{-0.20392548442755473,0.1247115990974728,0.30472121303396715},
{-0.1787153772782382,0.142573715442609,0.27834649919987015},
{-0.1538044162215579,0.15764242620547278,0.25034154231473055},
{-0.1307220286368772,0.17636003160633199,0.2515306308406555},
{-0.10946202529469329,0.195802464551188,0.2513245982674283},
{-0.09073960604866523,0.2169758186803325,0.2494286309630647},
{-0.07526859536811818,0.24088756301839095,0.24554825914166387},
{-0.07530022920779925,0.24790133542941906,0.27583449725232595},
{-0.07427694326333315,0.25401835725470534,0.304781592406228},
{-0.07175723916351875,0.2593232146307884,0.33201647160278347},
{-0.08188556939879887,0.23812441589146563,0.3638440341672976},
{-0.12890239516304836,0.17528585644150937,0.47422632911984336},
{-0.16277467284764385,0.1538835008207606,0.4634770128577804},
{-0.1955769015204186,0.12914515049799227,0.4544599931643398},
{-0.22551695539422295,0.10286018049168615,0.4464346255756843},
{-0.2521203268738408,0.07494400466530365,0.44001226842825886},
{-0.2522764329957452,0.07672925353078348,0.41096140052635954},
{-0.25270417752360674,0.07746921030245389,0.38241014098377113},
{-0.25306040206610236,0.07736468109307296,0.35418292199026363},
{-0.253003323616243,0.07661922278406672,0.3261050009662074},
{-0.22900905621814696,0.10133900541832659,0.30085631428632337},
{-0.20372123985396168,0.1218122889214855,0.27501394295868553},
{-0.17799467588724321,0.13864286701615183,0.24805187124477093},
{-0.15260164262151005,0.15263190107685715,0.21961861967803625},
{-0.1298603503516514,0.17073952352560515,0.2205009287282715},
{-0.10878052235721618,0.18954309044733686,0.22013920264844006},
{-0.09011862002188235,0.2099565447319685,0.2181861568942171},
{-0.0746276662684929,0.23289451696158345,0.21429588230561178},
{-0.06306364109620882,0.2592716377182649,0.20812109433829915},
{-0.06376426187592796,0.26854379120565497,0.23938908178654172},
{-0.06390510123172544,0.27666956185068964,0.2694947319341548},
{-0.06303193848731103,0.2836888357990536,0.2980176585594637},
{-0.060690621735611246,0.2896435622729326,0.3245367189794098},
{-0.056773870998577156,0.2946891597020642,0.3486508511222104},
{-0.06749072819035869,0.2639782029090754,0.3570265291007256},
{-0.13184640532988937,0.16934419611880291,0.5043926337165842},
{-0.16594768450608915,0.14362657215025523,0.5251189879371916},
{-0.13369836033556626,0.16352907115482082,0.5347122936665614},
{-0.19681681049748337,0.1206720953086328,0.5159685559633569},
{-0.1646493216948311,0.14905177565555974,0.49419759734110696},
{-0.08921774328313867,0.20201370020335058,0.18654406490713746},
{-0.07382100335662546,0.22383967419895892,0.18245092112927305},
{-0.06225752833807497,0.24881321524283445,0.1761124624262192},
{-0.053926275273546743,0.27597980660720883,0.1680272656190364},
{-0.05480349540174632,0.2880584318280439,0.20016174519767363},
{-0.05559330985552276,0.298838694237621,0.2314441741814228},
{-0.05583709672871713,0.30830821537693437,0.2614188189712262},
{-0.05507623411517056,0.3164539290948114,0.2896296708911596},
{-0.05285216887794083,0.3232634569322465,0.31562019861925167},
{-0.049165313632328136,0.32889428039547797,0.33907178062069715},
{-0.04401614976284935,0.33350456868291134,0.3596656165607277},
{-0.10767952719788135,0.18249837188879467,0.18875843368481277},
{-0.12843545218166902,0.16445814327241068,0.18945987969513228},
{-0.10656065204220505,0.17454108582467012,0.15742305240420618},
{-0.08846472036029568,0.19303450357909385,0.15481188524618347},
{-0.07329079269588396,0.21363913628614592,0.15038521076733377},
{-0.06180007550859993,0.2371279499415118,0.14378336596432664},
{-0.05342027137708293,0.2626165724184552,0.13549873842871965},
{-0.04758059580273962,0.28922269466674094,0.12602302805990348},
{-0.048225169670849895,0.30438561925648094,0.15869528291311902},
{-0.04922514285085538,0.3182247364247847,0.19091709939696272},
{-0.050123475128581244,0.33066715080195225,0.22220709299454863},
{-0.05046333259750271,0.34163927932611665,0.25208422303507433},
{-0.049787606274228256,0.35106616355107734,0.28006682992478704},
{-0.0476394622522331,0.3588742204149672,0.30567380422366774},
{-0.04409605959265243,0.3652312468065295,0.3286440979851307},
{-0.03923483243348813,0.3703050396145073,0.3487164569549403},
{-0.03313287106665869,0.3742647711119776,0.36562976441729433},
{-0.03740508988480468,0.3372524909929518,0.37708307115069467},
{-0.025867609630166027,0.3772761751111826,0.37912283488717374},
{-0.017729804372209258,0.3793791377578072,0.3890054527111919},
{-0.09136265515194902,0.158764052129817,0.062177687277488576},
{-0.10588465064206379,0.15537785589960795,0.09585466038666177},
{-0.08911046330508982,0.17152211721162833,0.09231854726405107},
{-0.07780480407994009,0.17533537027753193,0.0566005038032815},
{-0.0748394754559227,0.189470195077637,0.08708727294983491},
{-0.08828660808904787,0.18290823642031467,0.12329976707866303},
{-0.10582825988437143,0.16554332151190498,0.12637512644939716},
{-0.12537866049944332,0.14939287097038176,0.12803865380132157},
{-0.12448672375887035,0.14034628051376108,0.09800644917714194},
{-0.10713349961729932,0.14391609055255378,0.06610234647444294},
{-0.09547230354182097,0.14452332273599702,0.03318871167061745},
{-0.0828222061302255,0.15972338270275402,0.027386652857807933},
{-0.07254120823387585,0.1773069837202633,0.01968862674063483},
{-0.06706167704737993,0.19430467101150578,0.04908746687902601},
{-0.06374789480235382,0.20991390781761574,0.07985000058453831},
{-0.07348265881047135,0.2022103801631068,0.118473543450798},
{-0.12681868789709924,0.15738660471935625,0.15858112601340035},
{-0.1484775526961315,0.1407994696518008,0.1586471444614304},
{-0.14621023162159874,0.13373343263608223,0.12863213214142524},
{-0.1442406812553683,0.12573763581060682,0.09908681357146737},
{-0.12451216836904862,0.13011685952993488,0.06865781056694029},
{-0.10997710672776125,0.13103217780418516,0.03736025235551756},
{-0.10072283323671259,0.1292503673995402,0.005133622026505031},
{-0.08913728329960204,0.14313212148219667,-0.000799785990197653},
{-0.07941537913500704,0.15944005352995827,-0.008598215163749848},
{-0.07128823310563846,0.1774850959915111,-0.01780503789527686},
{-0.06428071869332987,0.1965733674703725,0.010556762455308608},
{-0.05871570737047834,0.21494712678774178,0.04010345640960044},
{-0.05535639990399817,0.232087166357549,0.07107986237904351},
{-0.062145434514857247,0.22417526797644516,0.1115560479431471},
{-0.16168399307081371,0.10296539739323404,0.0707958455140808},
{-0.18450161917120714,0.09502461594111704,0.09927455353305285},
{-0.1644712094235833,0.11086079116233041,0.09940521504477906},
{-0.14289693076108956,0.11669104535398608,0.07012809641994332},
{-0.16759333186167208,0.1178408666571765,0.12849390601586227},
{-0.18879144290882785,0.10099859779567152,0.12797538612195944},
{-0.20906942183656446,0.08249005081357422,0.12742729546487647},
{-0.20365659679026557,0.07753797951915187,0.09900566589576373},
{-0.18026956157561277,0.08826391424753756,0.07094576240648243},
{-0.15950263351715344,0.09405153152484047,0.04274488202297026},
{-0.14250494622591098,0.10647125206049766,0.04187357604740675},
{-0.12582566040798024,0.11857325881501013,0.04016672408896258},
{-0.23361384296824442,0.06495252517125252,0.15563711584655934},
{-0.2141377131072064,0.08682801300288348,0.15607311268042462},
{-0.19292859898537895,0.10626425671823671,0.15698911864684187},
{-0.21870949063328882,0.09060963222910602,0.18489154062988475},
{-0.23893382957200102,0.06782088919972576,0.18416327462505303},
{-0.2276893749497125,0.06159865047289152,0.1271996693576061},
{-0.22126014088061732,0.057709751268620116,0.09890938899238652},
{-0.19805053024504535,0.07191265759325619,0.07086048857777695},
{-0.17630570392514058,0.08063878350006427,0.04304677888427446},
{-0.1575571523767673,0.0842746119868871,0.015250261494946475},
{-0.14258884467028254,0.09530588203741182,0.014259297082328445},
{-0.12785572768490494,0.10602218907545977,0.01241078053748643},
{-0.11376491518348658,0.1171084744993429,0.009453016527305836},
{-0.17375436598564512,0.12946148889480305,0.18779016311370508},
{-0.1998976714055534,0.11498488108770895,0.21572421893642904},
{-0.17625068855178216,0.13430559251900953,0.21784024773422622},
{-0.1507173660839851,0.147058156063485,0.18901494286309628},
{-0.20230872014298493,0.11859595265652043,0.24532867903274722},
{-0.2257597107291669,0.09673696943689701,0.24283992108044689},
{-0.22263414983024318,0.09389336232643508,0.21383100240073333},
{-0.1967005905212638,0.11090067730801524,0.18625798496567383},
{-0.17077803428695607,0.12400671462631839,0.15798145844379388},
{-0.2502773118663346,0.07401011870254495,0.2696979449694974},
{-0.2279355687454913,0.09919959508685207,0.27186534437216797},
{-0.2521897837827058,0.07543295379602638,0.29800163533197305},
{-0.24736424784700775,0.07229982828326591,0.24125203986689026},
{-0.24355030708893718,0.07025325639433366,0.21272106724322776},
{-0.1633963465665937,0.053458438292350294,-0.037492289251577764},
{-0.18033626771580985,0.05078950499230129,-0.011158493101416039},
{-0.16813317021275132,0.06314733323293027,-0.011230013086781945},
{-0.15288634717863972,0.06274159485441214,-0.03807820297784462},
{-0.1554748204951521,0.07378661874827647,-0.011690079146491526},
{-0.1723480355041712,0.07223724829607073,0.015635369108455227},
{-0.18655162952097426,0.058504035721481926,0.015666315255969336},
{-0.17359413371073878,0.04244779900683495,-0.037320366209832805},
{-0.15787555385007898,0.043258588071704296,-0.0630923178595719},
{-0.149419690964894,0.05129427104286455,-0.06391479769127985},
{-0.14092806808702607,0.05841119727893964,-0.06537476816177819},
{-0.14227663242647365,0.07104822853936248,-0.03930091965073494},
{-0.14267136773032013,0.08342256139199895,-0.012778008154653726},
{-0.1924025144776393,0.06555631889386088,0.04304334042343954},
{-0.12156196897270481,0.08768418975077347,-0.04455695088296237},
{-0.1300308980090624,0.09277173640209085,-0.014732429293210638},
{-0.11784361742584444,0.10253146363586972,-0.017794722512772167},
{-0.11179330174075519,0.0974109077605373,-0.04904070381167136},
{-0.10640179515163267,0.11339562448981838,-0.022204204687447375},
{-0.13177969918969232,0.07912929919354338,-0.04138600230101798},
{-0.12426872534193774,0.07295107276539586,-0.0710097177780116},
{-0.11618352853475493,0.08174734327323589,-0.07559318607093272},
{-0.10831633014450476,0.0924760287702895,-0.08162630945184743},
{-0.10263943130608559,0.10900952384882051,-0.05506213642574745},
{-0.09599494958872569,0.12606153882125437,-0.028200880383512195},
{-0.11226987241247226,0.07695894271455478,-0.10813753018108996},
{-0.10546103226720416,0.08968056011151614,-0.11567669940769075},
{-0.10070770400903901,0.10582413373136955,-0.08931264480218196},
{-0.09426952994177311,0.12317873325727456,-0.06284681175596003},
{-0.08691534990808994,0.14122377571882744,-0.03602612955157658},
{-0.11885796337213979,0.06685536939728595,-0.10207827449783002},
{-0.1253105789749123,0.05871790798541268,-0.0973270093161658},
{-0.12403628538949853,0.04536773994783167,-0.12368418700000482},
{-0.11910209409141767,0.05318611219422629,-0.1287132798171289},
{-0.11374497211064416,0.06295821788701081,-0.1348406170249199},
{-0.10775792410491707,0.07526721998378423,-0.1421906709056012},
{-0.10124547928361731,0.08947356476925518,-0.1504154692226809},
{-0.09847545523502223,0.10435659864703443,-0.12430310995028675},
{-0.09333151782601251,0.12111771983283579,-0.09823063682357742},
{-0.08657700536193583,0.13923840843275642,-0.07195391912327499},
{-0.07897456845597291,0.15820083224506046,-0.04522676305360082},
{-0.12308451943039833,0.026780796058698656,-0.14554592098829616},
{-0.1287545413471477,0.038919938190228036,-0.11962886629132426},
{-0.13171230535732828,0.051896001688971946,-0.09371181159435243},
{-0.13346248192229215,0.0332595439638164,-0.11642353310103096},
{-0.12639300644573867,0.021200174123656674,-0.14152704796446558},
{-0.11646341924671576,0.009787922612625063,-0.16643319517597696},
{-0.11413214280065385,0.015785286000856866,-0.1715846971988235},
{-0.11979460010356643,0.03328567626616163,-0.15025523694777465},
{-0.11620209622326338,0.041191385417762676,-0.15571344967709416},
{-0.1119872309318435,0.050972431108717936,-0.16197832531828113},
{-0.10682816429516023,0.06310400862641055,-0.16910694232119486},
{-0.10087825166645004,0.07698782578556797,-0.17681322074437178},
{-0.0943135422404598,0.10494113698896734,-0.15916497666316634},
{-0.09135784130678015,0.12032618614864189,-0.1336234018893655},
{-0.08615957621657902,0.13768284875104786,-0.1079566671411743},
{-0.07945664066502584,0.15650979720645686,-0.08194127246432427},
{-0.07198692834729004,0.17630845469380851,-0.05535165482804599},
{-0.13814841634809327,0.04573978141016781,-0.09106075829064485},
{-0.13253065903603437,0.06540158815629042,-0.06767097230732418},
{-0.14470349808374577,0.039596627282536254,-0.08920330174763214},
{-0.1513060305789199,0.032635119476198626,-0.08797302046090505},
{-0.1434257660374971,0.021678120179707713,-0.11207663091355093},
{-0.13836710245719286,0.027804082003164754,-0.11394440283906832},
{-0.13813397481258669,0.0035037915907626354,-0.1330986927659598},
{-0.14859583574885205,0.014006914057046814,-0.11070812350126087},
{-0.15788586923258366,0.024021775084775245,-0.08720693138688947},
{-0.12633867876454724,-0.007453207705728279,-0.15426723304993537},
{-0.13397137412585727,0.010474239395271012,-0.13534469538331617},
{-0.13003983800723312,0.016068615173652587,-0.13814016404208948},
{-0.11934966327153045,0.004545645223737211,-0.16179333612536353},
{-0.10670437970510384,-0.007031652407369592,-0.1844521053351846},
{-0.10390478489332863,-0.0013306843431061214,-0.1907554917377225},
{-0.10222819139023161,0.005745668055117153,-0.19716065658097331},
{-0.1119329032506521,0.022856136861744293,-0.177216896046389},
{-0.10944345760618483,0.031321627437267005,-0.18329747018682535},
{-0.10624087518455937,0.041500159200736644,-0.18979478578045156},
{-0.10190222530308313,0.05371082131763193,-0.19667858437192043},
{-0.09661043407817271,0.06741721389770855,-0.20374118292680413},
{-0.09428947301461553,0.09202559040091765,-0.18480832987768023},
{-0.08706664218482552,0.12102969523546234,-0.16809190868273258},
{-0.08415151508899768,0.13692707505953694,-0.1432449029975814},
{-0.07916505918622635,0.1548448944701985,-0.11806918045661387},
{-0.07280390664166218,0.17431345971739975,-0.09236874879224068},
{-0.06576400192828884,0.1948658278197614,-0.06594830342903944},
{-0.06448675126655705,0.1965795566998753,-0.02796225120157014},
{-0.057694759579379966,0.216821775634929,0.0004511260615388143},
{-0.05234843436562805,0.23653653467790903,0.030113352299883274},
{-0.049185256705170544,0.2552245693155881,0.061250678236399646},
{-0.05374410561851377,0.24798179541295573,0.10303072814909714},
{-0.07184732683739312,0.0017976273244854895,-0.25186037923472243},
{-0.0866155161232867,0.017714950221402497,-0.23632403779831226},
{-0.071680217640817,0.013857684856812177,-0.25982247914401585},
{-0.0549582949085335,-0.0009015644309106671,-0.2715558828970271},
{-0.05515311809943891,0.011884008337579825,-0.28001449655087995},
{-0.07064730400601318,0.026137803882572426,-0.26721929609205175},
{-0.0850131933742235,0.029285370930839473,-0.24342514711454685},
{-0.09706362321621247,0.03433853297380787,-0.21728046631030462},
{-0.09939214889360645,0.02351632134204502,-0.21049156923787896},
{-0.08739054519547305,0.00691955858415185,-0.22892653315810935},
{-0.07136250385967229,-0.01060421321483023,-0.2440922085165173},
{-0.053998276643429544,-0.014070181736408971,-0.26328913535776155},
{-0.03607667492584959,-0.015314904558642614,-0.278197613845719},
{-0.03711254563697143,-0.0019619857523936806,-0.28694574590187044},
{-0.037432047417750296,0.011216259243442333,-0.29582247639324716},
{-0.05452381099743559,0.02469296263974764,-0.2876520057573588},
{-0.06853409474610062,0.039199141210021854,-0.27329230561865137},
{-0.08221634933111621,0.04205443908732247,-0.24977392120010533},
{-0.09351857009543103,0.046793325809981016,-0.22390156649398718},
{-0.10096146241865461,0.014070869428575952,-0.20372192754612867},
{-0.08770550820794987,-0.003525110047939015,-0.2216892607928128},
{-0.07019755332880831,-0.025376528653725687,-0.23726686375924172},
{-0.05116759814570684,-0.027835028150678863,-0.25745062886010206},
{-0.033986915968831036,-0.028961467920191955,-0.2710717476114732},
{-0.01869841878940046,-0.002166918018153708,-0.2969640453904338},
{-0.053011232076163275,0.03793309993061185,-0.2934547522623353},
{-0.06551684536347625,0.052734986132687435,-0.27812128001518427},
{-0.07841822549288616,0.055637047077342655,-0.25535385544298034},
{-0.0889529817988514,0.06041581994568608,-0.23024071288920797},
{-0.040903173630581394,-0.0696982888155809,-0.25579604150634844},
{-0.03843594044310757,-0.056557866888928776,-0.2582703579231421},
{-0.03225049324720677,-0.06904910740995188,-0.26193438178881107},
{-0.022249454832034627,-0.06896795973424824,-0.2675487006400351},
{-0.026353120300053844,-0.05663970225679939,-0.2659580686578106},
{-0.03050568068114534,-0.043019958889762254,-0.2670625022779803},
{-0.04536093179537857,-0.04240860055331712,-0.25627673833106734},
{-0.048781994018453526,-0.057193294451218214,-0.24986951041131553},
{-0.047757951612603745,-0.07121258696727066,-0.2500909472890831},
{-0.08418039816001084,-0.03673238940706495,-0.21371753319318162},
{-0.07721476420067133,-0.05477124263911497,-0.21918468592067195},
{-0.08864764647671233,-0.04252344514520276,-0.2066728146346395},
{-0.09700310630551824,-0.02439175347061044,-0.19767505032187435},
{-0.10102541779018374,-0.030519778370568428,-0.1914314931378637},
{-0.06676314987769394,-0.06668069558687306,-0.23012380522082138},
{-0.07263954821375397,-0.04962592984577128,-0.22578928149234703},
{-0.07857570699912457,-0.031578824307717496,-0.2230618943581047},
{-0.09251316414730641,-0.01892735151178807,-0.20566672099434788},
{-0.11015384361467506,-0.012482988215019334,-0.17867274036388547},
{-0.11377935671899315,-0.018811819227735463,-0.17383757673784972},
{-0.0565293276639991,-0.05909201252424975,-0.2422684488896866},
{-0.058041631508404634,-0.04280471124149754,-0.24446700074752137},
{-0.06669149235389464,-0.045423443013357045,-0.23426027360520552},
{-0.06231185601926638,-0.062254021108023375,-0.2356315317861635},
{-0.053128139744549864,-0.07380044136083277,-0.24498483294925724},
{-0.016239506677147096,0.4174284576646386,0.3767047029204223},
{-0.015445222224285298,0.45516831609632913,0.3644650889632972},
{-0.007657864894621491,0.4921915992900266,0.35794652368171126},
{0.0,0.5250089571904749,0.3477677856105915},
{-0.007497701388931869,0.5522725131503934,0.33448040386785577},
{-0.014953866170978151,0.5235427974904737,0.3407520876614959},
{-0.0075881329088897265,0.5247118741743396,0.3460065372017393},
{-0.015099244295077705,0.49105484413800876,0.3524323328099996},
{-0.022107652707203367,0.4888432261290014,0.34336229205048485},
{-0.021874937677897367,0.5212252748877514,0.33203387021460806},
{-0.014761312364223778,0.551089682623188,0.32957014425718584},
{-0.007259828668373518,0.5733090165383089,0.3234844811947138},
{-0.029113447889094507,0.4497575541265312,0.3422604028913329},
{-0.02261248752698332,0.4530543503750329,0.35511240672315364},
{-0.023746698217983284,0.41536400577936494,0.367095580271212},
{-0.03051895313996805,0.4122521987237809,0.35394181711652045},
{-0.03631117795478974,0.40797131498433087,0.3374096974223234},
{-0.03472590997146765,0.44509018738923856,0.3260433149788294},
{-0.028466673406049903,0.4853201791575633,0.33082655784625814},
{-0.02812881024441267,0.5174828541150468,0.31988133183966594},
{-0.021556880050669157,0.548696513882098,0.32131618779222615},
{-0.014273876156268416,0.5721468167761129,0.3190322176903308},
{-0.00696398349813876,0.5881425365800655,0.3123412204747964},
{-0.03691779121528272,0.5311981866932941,0.27619649840902416},
{-0.03349322176215616,0.5120377075368998,0.3043237957306694},
{-0.0328073175948104,0.5390413158577,0.29456661295790837},
{-0.035131579580769096,0.5517086055734698,0.26812890652131605},
{-0.03138255696326142,0.559850880830512,0.2859417841072964},
{-0.026581090253407685,0.5657719103882091,0.3004212114522752},
{-0.027650176496194653,0.5447849208363162,0.30966585725298607},
{-0.03395968335901863,0.48024982481042044,0.31491535540962723},
{-0.037828295644364116,0.5046429536653648,0.28554450434243217},
{-0.03987129153402804,0.5209866457058094,0.25473369464679785},
{-0.03775890750471585,0.5410610677521199,0.24715188850584432},
{-0.03469228182450233,0.5560548200687829,0.2410519214462991},
{-0.03248939750601559,0.5668653409337071,0.2614483897344064},
{-0.02927663724031884,0.574808185462325,0.2784682207134256},
{-0.025034401800653167,0.5804816458399094,0.29198075287163056},
{-0.019743435806343135,0.5844908911734022,0.3018553934665118},
{-0.02079622374477268,0.5697536480350227,0.31139790625242836},
{-0.04369747321267086,0.45349997489923594,0.24882256785630533},
{-0.04268072034379106,0.43083295338341104,0.2843188993624406},
{-0.04172964207685785,0.4645642541737756,0.27372403876108126},
{-0.042850511539818406,0.48301709809034754,0.2390534880090555},
{-0.04099401776583944,0.49505171101249607,0.26372664511439414},
{-0.038432226905405875,0.47340591236463636,0.29581807516337844},
{-0.03929871903580056,0.43885006866606285,0.306662430482918},
{-0.04099690607294076,0.40233705306026446,0.3177227005121243},
{-0.04444980844334689,0.395166486835165,0.2951044570017034},
{-0.044720827926353665,0.420837347736358,0.25921400911467196},
{-0.04418098957527444,0.4399881992024146,0.22130346548713703},
{-0.0432578316103206,0.4682922334109737,0.21170878437343332},
{-0.04186566758748648,0.49239103001845075,0.20324260610574366},
{-0.04155737518902938,0.5081405560266247,0.2303562451732606},
{-0.04654334970728383,0.3862760025004487,0.26977854249146743},
{-0.04526788704518619,0.4086583194591438,0.23154870339080375},
{-0.04359617615647472,0.42430125318143586,0.19168250077881138},
{-0.04260603697445705,0.45120995998319274,0.18221435502383196},
{-0.04115452511761255,0.47412523837129733,0.17392285056655515},
{-0.03860917009996981,0.49194196703341286,0.1673010626907056},
{-0.039371958251583926,0.511105884650642,0.19638287674011906},
{-0.039195427672320184,0.5276221874249986,0.22318017741082524},
{-0.03583639528270681,0.5421985105963048,0.2175080924175749},
{-0.03155214185163866,0.5526094823122136,0.21332279788933517},
{-0.030706693101553564,0.5667484332653205,0.23650558853039494},
{-0.029011119294647898,0.5773732772451601,0.2562616778726105},
{-0.02654698072192548,0.5842708296799686,0.2721646967724543},
{-0.023123305268615998,0.588981521023781,0.2841779224682097},
{-0.01854884574308233,0.5930182740439531,0.29226497604424334},
{-0.01301161718377679,0.5958928273019292,0.2973538980798947},
{-0.01364085551656341,0.5869940906612092,0.3085046752751972},
{-0.0467224247475654,0.3629240395863119,0.21217228889397777},
{-0.04715113204446067,0.37548198624753204,0.24196861510488332},
{-0.0447574819188537,0.3945042392783633,0.20183283716343486},
{-0.04570642834006927,0.34874176402668516,0.18088848452589468},
{-0.04362499045827118,0.3785807271519435,0.17057516509769696},
{-0.04235867410199438,0.40671077524225674,0.16047709331776397},
{-0.04088439963442284,0.3874897791751682,0.12820369992139677},
{-0.03968547711051007,0.4113066219941835,0.1188710295233124},
{-0.04128525539855543,0.4321038085079899,0.15109422139149006},
{-0.039782372936837535,0.4537296640830072,0.14292718921643663},
{-0.03722787161337396,0.47055955448550646,0.13647526130583112},
{-0.0337383840196845,0.4831965857459294,0.13156582692576152},
{-0.03508089666806268,0.5053079519908344,0.16221282834722126},
{-0.03587311804442354,0.5251293033196964,0.191044322447854},
{-0.03146563017703259,0.5351544797299295,0.187140981708076},
{-0.026246046629655073,0.5418739198934902,0.18458826838424663},
{-0.026414324902915058,0.5595895578070597,0.21060847690626547},
{-0.025837626251685706,0.573921062566921,0.2335828968207303},
{-0.024649431725577816,0.5843258450533271,0.25299438361807225},
{-0.02298329114341889,0.5902606284543637,0.2683259990963725},
{-0.02138289393242324,0.5921724126785678,0.27812801939842063},
{-0.017872638035290985,0.5961679041687211,0.28145328610263526},
{-0.012662888485901278,0.5993106573718193,0.2847588848108743},
{-0.006555803812427835,0.6005760109590623,0.286902352526134},
{-0.006699510844561627,0.5971237962808232,0.30037300423136987},
{-0.042306065651220415,0.3610947784221454,0.13828457939715524},
{-0.044552412114660295,0.3330747610785489,0.1486144034373605},
{-0.04123622294704977,0.3422527007390627,0.10547065995754186},
{-0.039589062668699486,0.36691059107829443,0.09537877740711169},
{-0.038196898645865354,0.38915193114275864,0.0860674254662037},
{-0.036488396226220465,0.4080937241900533,0.07802899172637552},
{-0.038107567433374664,0.43159010245925594,0.11078583271612959},
{-0.035548664880042415,0.4473863915347845,0.10444668632090877},
{-0.032124232965349254,0.45925664602902466,0.09965622268572673},
{-0.027949322588830917,0.4677613350580652,0.09621707415866017},
{-0.029430817824155738,0.492245239279051,0.12802627534231598},
{-0.030680698337641723,0.514871686957024,0.1585212967948731},
{-0.0255195686244575,0.5212809779532768,0.1560909926767661},
{-0.018375065932486508,0.5947856429130914,0.2682470520356032},
{-0.012871603058579682,0.5976945807794166,0.2698986135438221},
{-0.006622269260366443,0.5988430266982729,0.2712516478823551},
{-0.035283353242021566,0.3836270122732421,0.045187564600082906},
{-0.03257976025675675,0.3973884202266771,0.0389440074160723},
{-0.033892427065088,0.42285366116994316,0.07175586377918476},
{-0.030516890063467108,0.43395094966849795,0.06703554474503468},
{-0.026469821660790333,0.44190548496395454,0.06365622543649538},
{-0.021859189527273528,0.4472385377188838,0.06140609666613711},
{-0.02313932849610663,0.4734616154301617,0.09393187308778596},
{-0.024421736849090766,0.49830999649964686,0.1256826204372484},
{-0.01882791122444278,0.5019932757459912,0.12436293916881397},
{-0.012089559526290126,0.4786811989775393,0.09197882733356301},
{-0.011385156439652605,0.4521149628749383,0.059420041687899126},
{-0.010775792410491706,0.4246925500244474,0.026670765311981835},
{-0.005218517624518701,0.3974296817566959,-0.005931344940201761},
{0.0,0.39744756175303736,-0.005932032632368723},
{-0.010354924804300001,0.39692697878263355,-0.005708532678100238},
{-0.015327076709998149,0.3954910775379795,-0.005039408199628784},
{-0.020052966050700793,0.3926715396533619,-0.0037011592426858765},
{-0.019900504697281347,0.36532889909424066,-0.03514725896217625},
{-0.020497627805870004,0.3386168722522399,-0.06509900360281926},
{-0.021644079417442213,0.31276652369546515,-0.09349931471475564},
{-0.02313967234219012,0.2880123564528563,-0.12029455230896087},
{-0.024784081851872482,0.2645868104768526,-0.14542695024340865},
{-0.0372094414632989,0.36597257896253377,0.053207430651402626},
{-0.03888844188898035,0.3452441616654253,0.06252015797664458},
{-0.03711330209835511,0.34210278384666115,0.02081231574147998},
{-0.0348507948689912,0.3585764497066649,0.012790386613659338},
{-0.031931404081728086,0.37142116400151565,0.0065509555826506125},
{-0.028437171412086466,0.3810853020240843,0.001871210386352318},
{-0.029195008180098327,0.4077395627240587,0.034256697605937234},
{-0.025225648992290284,0.41516319966660686,0.030906261368411122},
{-0.0207680971351432,0.4201414032633744,0.028672637210060352},
{-0.01591883581968436,0.4231576211077483,0.027335763637451407},
{-0.016792961333132527,0.4504700032115224,0.060071973862196086},
{-0.017809370355928836,0.4769186439535697,0.09260325182118077},
{-0.04093480747026247,0.2997430094371996,-0.0012350951318959326},
{-0.04158577687552565,0.3013288275742552,0.04030838867536047},
{-0.03919845351785489,0.32276488011118604,0.03014292306306342},
{-0.038298470778928284,0.31787470111179195,-0.01059321014015856},
{-0.040850977795107615,0.32226217713712374,0.0726422989824219},
{-0.043627397380855616,0.29784429136416807,0.08309040607534765},
{-0.04475486868861917,0.2785600276177174,0.050835580367488926},
{-0.04387627317608564,0.27966033508488525,0.00897919662425668},
{-0.044513282430359125,0.27645225112592403,-0.031097439790831537},
{-0.04115507527134613,0.2936218614589114,-0.04048718863877527},
{-0.037736419970855604,0.30826901692341646,-0.04854625314361287},
{-0.03554900872612591,0.33332851948816444,-0.018630268495652774},
{-0.03226802939746475,0.3453796370223204,-0.02488139029350015},
{-0.028522032625491783,0.3544502967047854,-0.029568700103635215},
{-0.024377380704320564,0.3609593030652503,-0.032916385572493406},
{-0.024450344843237132,0.3880193021437428,-0.001472348929503991},
{-0.04370964536402641,0.3160626322517998,0.11584931014160267},
{-0.04774825515304933,0.27281092110176536,0.09338103166203506},
{-0.05874259613420726,0.21603436810373697,-0.03861322748375503},
{-0.05243618388613468,0.2373514498957802,-0.010167528688798009},
{-0.053787086378950015,0.2351625257282832,-0.04929858837428884},
{-0.04815798214613596,0.2574623196269407,-0.02083707265949132},
{-0.04754139734922177,0.2583494425223448,0.01958340983908689},
{-0.060119699698584515,0.2131893856089411,-0.07656489510287534},
{-0.05486655677345838,0.2305955620473696,-0.0867496160958478},
{-0.049351334363496195,0.25327564971436706,-0.05956308165863098},
{-0.040964722079526096,0.28370190195022615,-0.07699470270723777},
{-0.03647643038251501,0.2946389581738747,-0.08324719988941912},
{-0.03391044459986287,0.31969433458562074,-0.05481181647696681},
{-0.029728038378724456,0.3282946128258715,-0.05951012936177353},
{-0.025240159297013558,0.33446940079318416,-0.06286400406013457},
{-0.045166865065856834,0.26968467251067474,-0.06894732896923887},
{-0.04981758965270858,0.2464035418897368,-0.0960506526542511},
{-0.04478560852848318,0.2599290714298977,-0.1040148156400454},
{-0.03958362990058034,0.27048996003820813,-0.110192354376026},
{-0.03422980884220834,0.27844930917883365,-0.11481089496946303},
{-0.03173685596768947,0.3028761349499601,-0.08793175893088628},
{-0.026781071135565444,0.3087916629703213,-0.09127394286240864},
{-0.060476336856380306,0.2087970957384404,-0.11277601384736945},
{-0.05459106729136622,0.22411818952658585,-0.12187418121651372},
{-0.06651207346752959,0.191968580720275,-0.10279416204365609},
{-0.07232045904827529,0.1719292309744804,-0.12814455839503652},
{-0.06559813057761328,0.1882619199402533,-0.13776124565808356},
{-0.058970978702861276,0.20316971073604378,-0.1464963115630624},
{-0.0524117020449902,0.21597660196171067,-0.1539275131194473},
{-0.04875070402485594,0.23725310991590207,-0.12964647808772062},
{-0.04284982384765142,0.24752172935324612,-0.13565209378195625},
{-0.036888495528969376,0.2552699569986088,-0.14012621902032746},
{-0.030866581530376393,0.2608437020119809,-0.14330610760044263},
{-0.028742437965008846,0.28416884493160555,-0.11810150198846193},
{-0.05532029606523173,0.19640281981296145,-0.1768971191887433},
{-0.04833045534161452,0.2062292531869374,-0.18213802119329717},
{-0.045892861686537535,0.22601003067794756,-0.15963191964454568},
{-0.03939437701622747,0.23359527527973595,-0.16385572493413628},
{-0.03289589234591741,0.2390576141620574,-0.166843747399664},
{-0.02637725829511484,0.2427237011042273,-0.16884286852907462},
{-0.062441279685092,0.1838971377564318,-0.16999475290876595},
{-0.06964946267172532,0.16937445457415007,-0.1618235945807106},
{-0.06448558218987317,0.16664156590257187,-0.19244652677632607},
{-0.057028110792709634,0.1788336603309587,-0.19859449474912644},
{-0.04978031673725826,0.1884558491313416,-0.20317589996554664},
{-0.042673637114471176,0.1957790830175107,-0.20646857006104646},
{-0.04142891429223754,0.21367902243183076,-0.1859767188693791},
{-0.034572692156664524,0.21905402440894578,-0.1886731598561073},
{-0.027718876943675946,0.22265615597958652,-0.1904852287160994},
{-0.07221042830155851,0.1380762086705604,-0.20765277597258586},
{-0.07960999601826235,0.13710106117778284,-0.17684691766055377},
{-0.07204813295015125,0.15251843186930547,-0.18508134366797124},
{-0.0645877044766697,0.15174340279711912,-0.2139293423806115},
{-0.07690117657252848,0.15349770551508485,-0.15277631643192296},
{-0.0798032375171837,0.12316841787476987,-0.20051590666366836},
{-0.07683722120099935,0.11212545705740645,-0.22394145263967202},
{-0.06955524884484908,0.12643151720708953,-0.22965754993160903},
{-0.06223146480494643,0.13954236837056153,-0.2345209089364909},
{-0.05504824504397447,0.15092092296541113,-0.23832590969639078},
{-0.05708690847298641,0.16357239576134053,-0.21905746286978064},
{-0.049860295336278025,0.1729635199936182,-0.22274968211429585},
{-0.04281000647118329,0.18014990313855828,-0.22530789697546108},
{-0.03583818328234096,0.18536467284076694,-0.22703400431458065},
{-0.03563937147686706,0.20107568808758997,-0.20875033267108575},
{-0.028608819376964648,0.2046166150553695,-0.21029970312329155},
{-0.08389569360288114,0.0971619631960906,-0.21757892471077386},
{-0.08356353828622985,0.07474251086037854,-0.2361858116727493},
{-0.09054705224191086,0.0820801862820542,-0.21077627379500857},
{-0.08721380830855921,0.10761832259502016,-0.1928048143953226},
{-0.07381343874278869,0.06964877497955835,-0.2601491329233313},
{-0.07754554413298866,0.08930851864918003,-0.24162270594489244},
{-0.0511107947727143,0.1406866881364161,-0.2560367337647914},
{-0.04489178819906488,0.14948846018159198,-0.2572415704413402},
{-0.04818810306304968,0.16002803033272608,-0.24086555686904762},
{-0.041519620889062185,0.167047991973257,-0.24247338115544662},
{-0.03491151808733552,0.1721630463112536,-0.24348085018007223},
{-0.028232514223193242,0.17555680715529945,-0.2442208069517426},
{-0.028846760866739696,0.1888395813605164,-0.22823058868512566},
{-0.057681693428207344,0.12980395959395905,-0.2537597849999209},
{-0.06440842312873804,0.1173037790747652,-0.25052281796994647},
{-0.05709632985567405,0.11041104048512555,-0.2696777955890049},
{-0.0512032205999564,0.1222916103618705,-0.27118315374252394},
{-0.045472956849379596,0.1326771374676011,-0.27182683361081716},
{-0.04009946779503197,0.14118251418880864,-0.2715937059662109},
{-0.035048643905431325,0.14797416202990224,-0.2706474415444466},
{-0.03889992634816892,0.15635988031405523,-0.25768100573604036},
{-0.03301053063015296,0.16145361619487544,-0.25766243804753186},
{-0.026991642477094693,0.16478067089872425,-0.25776421648824493},
{-0.05281015088653835,0.09311420710124685,-0.28591970918873644},
{-0.06295835542544419,0.09742053545087503,-0.26732726376226756},
{-0.0710949916067171,0.10365033879154607,-0.24643930188241975},
{-0.06859529934896183,0.08370520287262773,-0.2641459997978185},
{-0.057478136546781286,0.07999991747693998,-0.2843558972010241},
{-0.04462640779182733,0.07784056407262303,-0.3014629275468164},
{-0.0410330099117072,0.09040813842418088,-0.3015337598400153},
{-0.047945554035755865,0.10547341072620979,-0.286551698290191},
{-0.04306101411213095,0.11677081764535575,-0.2863295737202564},
{-0.038333336771794166,0.12669834176787775,-0.2853331077703026},
{-0.03393925890165933,0.13494858469513576,-0.283640009655198},
{-0.02994693079547416,0.14176086330123872,-0.28121933322742876},
{-0.02642415890090287,0.14737449446029577,-0.27803944464731367},
{-0.03028637564909544,0.15321712711095703,-0.2691517110812653},
{-0.02534950235156336,0.1565221756654625,-0.26835054970673367},
{-0.019774863338374117,0.15749869854257398,-0.2694893679352524},
{-0.013619537059387033,0.15725388013112915,-0.2712931844892407},
{-0.020469913811540712,0.11996927391397932,-0.3042075069852332},
{-0.033519835449018286,0.11300639072330775,-0.29873829118124196},
{-0.029890333730131714,0.1225577472304917,-0.2961931424712493},
{-0.02653927856965531,0.13062506404133303,-0.2930978400276727},
{-0.03728240560221547,0.10221031139389011,-0.3005716784984104},
{-0.022929444846744362,0.1107005588874241,-0.3080551446594858},
{-0.010397905564736245,0.118645466492543,-0.3091760828916631},
{-0.047917358656909693,0.06474552982899158,-0.30020032472824126},
{-0.061772636591137436,0.06643794025192913,-0.2817825531121853},
{-0.05076069069050483,0.05136304025956253,-0.29758434372504966},
{-0.00530004353091417,-0.08975716901891773,-0.3775904504314925},
{-0.00795398514172304,-0.09152171835017148,-0.3761462968808347},
{-0.007108811468504729,-0.08680318731565552,-0.39671516959520386},
{-0.008796614353923525,-0.08476644942471112,-0.4148771197251433},
{-0.010724834420918495,-0.08384452930565785,-0.43183560856286785},
{-0.013262968670807947,-0.0840483612639507,-0.44749435920500036},
{-0.013743459187876811,-0.07657479787007981,-0.4665021707003252},
{-0.014837783733191943,-0.06788346918692093,-0.4863695974043747},
{-0.016661337052372573,-0.05779227432865771,-0.5074198546356298},
{-0.019329582660254627,-0.046121450562841664,-0.5299761577125708},
{-0.022957846533240633,-0.032689447157390035,-0.5543617219536784},
{-0.027661660955383218,-0.017314713380220188,-0.5808791319124239},
{-0.03303604400954792,-0.0006402414074583071,-0.6089644800118834},
{-0.028192971923591895,0.01626735820990977,-0.6254690920194013},
{-0.022996769909891693,0.03198318730190167,-0.6413822887633164},
{-0.017505685494990507,0.0456854537289764,-0.6556519012281495},
{-0.012057513071308864,-0.09705213875702391,-0.354772824331099},
{-0.010612534290050676,-0.0941329542774109,-0.37459898950512993},
{-0.01477183405437857,-0.09963841145860197,-0.3916812629329109},
{-0.013277341437097828,-0.09766927370767169,-0.37318440671765213},
{-0.012076493375117509,-0.09418473749758449,-0.3929259857551444},
{-0.013856584549345009,-0.09561238643623478,-0.4104827667781416},
{-0.011207044168404809,-0.08960223197369716,-0.41236704331566654},
{-0.00955837096728717,-0.08998843989467308,-0.3947552469193111},
{-0.014925464484481881,-0.09994993601024386,-0.35354323073653887},
{-0.015982997498863588,-0.1023175226027223,-0.37216043308101915},
{-0.01775311713666988,-0.10659572434272102,-0.39147495528281695},
{-0.016871839624685123,-0.10290453663645635,-0.4097813207678221},
{-0.0162837940527006,-0.09784057782646638,-0.42722119412243265},
{-0.013324585888969348,-0.09037162197011427,-0.4289541783832221},
{-0.022616888756851992,-0.11428639215370745,-0.35091693435084276},
{-0.020273027544134365,-0.1085405865601569,-0.35169746496036486},
{-0.021420373155523646,-0.11527893825830955,-0.3710862579161965},
{-0.01876423092978044,-0.10826468446276456,-0.37177051162234137},
{-0.01767678330613511,-0.10375314877050955,-0.35249656325839557},
{-0.024611058502660335,-0.12096477709489944,-0.34992596993822467},
{-0.02375068683255177,-0.12312818788300155,-0.36917584907632633},
{-0.024676870643040315,-0.1268409003540927,-0.3872318946125509},
{-0.021554885743384915,-0.11650358046926738,-0.39349677025373786},
{-0.03154272046895104,-0.12327569785281875,-0.31243849453181577},
{-0.02823361453066041,-0.12578501780091175,-0.33066646310978526},
{-0.02670583761249784,-0.13571106338527472,-0.38427481829453713},
{-0.027886605063202344,-0.13348022438020024,-0.40259493762288195},
{-0.026113115733777857,-0.1258304054839324,-0.40835092106050397},
{-0.02044054935601067,-0.11111723157139723,-0.4118581511121014},
{-0.019728787963186462,-0.10605148476177312,-0.42746876330254535},
{-0.01943865063793764,-0.10067153140105588,-0.44271489864449},
{-0.016152238541157344,-0.09205351070289704,-0.44432409831522296},
{-0.025649061059499812,-0.13140146849785336,-0.3671457817994016},
{-0.026230573555898026,-0.1283329172795723,-0.3490354085819857},
{-0.027450539460120386,-0.13614829806504056,-0.34855746252593456},
{-0.02700910985813598,-0.13968789091001618,-0.36610117739775905},
{-0.02811258070927195,-0.14431901627010899,-0.38283066474387933},
{-0.029617801324357575,-0.14198205260982616,-0.39970663052156635},
{-0.03239848460154084,-0.14209959295500635,-0.41684391932270576},
{-0.030908874598645657,-0.13504790807481265,-0.42103196461961334},
{-0.024750453704907163,-0.11988908900730948,-0.41830182671670324},
{-0.023786034209934536,-0.11480436189387673,-0.43057025497562473},
{-0.023207341251420942,-0.10972417354874603,-0.443265052378074},
{-0.023183684640876834,-0.10431086711793026,-0.4566337881041634},
{-0.019706369198542916,-0.09471591092735977,-0.4581742185581984},
{-0.016578332607818096,-0.08539279945039642,-0.4616539409231168},
{-0.017663373308879,-0.07770818333047941,-0.47977462952303734},
{-0.019554114152773562,-0.0688084151515089,-0.4990162563551353},
{-0.0223975837248021,-0.058501284952814,-0.519702036737891},
{-0.026340535533398112,-0.04659664585022478,-0.5421758167547944},
{-0.03152992939464521,-0.032902631729153815,-0.5667539348026565},
{-0.03746794494886665,-0.01791575633416062,-0.5929274986779118},
{-0.043656830605602354,-0.002133221101971678,-0.6201738623336559},
{-0.03867628885546705,0.016692351969103358,-0.638005720223445},
{-0.033170900443492676,0.03527379432090053,-0.656422116455167},
{-0.027186465668000103,0.05266965537682437,-0.6742058358932675},
{-0.028288561134802104,-0.14427675758644806,-0.3484584348538895},
{-0.028762656114718056,-0.15258431277890216,-0.3487060040340022},
{-0.02789582013823988,-0.14801095356083566,-0.36577177284977574},
{-0.029413763058414637,-0.16123114777885744,-0.3824730648170499},
{-0.028510204320219733,-0.16477461920765485,-0.3662469681371589},
{-0.02837397250194101,-0.15639412738397085,-0.3658900559024962},
{-0.02898574345368634,-0.1527854627377438,-0.38239741867868204},
{-0.02894083715518255,-0.16099183090474845,-0.34911793164202315},
{-0.028891392088376693,-0.16942018610325424,-0.34951197925370275},
{-0.028371152964056394,-0.17308929889095886,-0.3666375772880034},
{-0.029457981664751443,-0.16959458483680032,-0.38283066474387933},
{-0.031903277472098604,-0.16738613021176105,-0.39818683083254086},
{-0.03161032060896517,-0.1589532362449532,-0.39801490779079585},
{-0.03085379045607057,-0.15047914951734326,-0.3983518769526159},
{-0.02802338703521465,-0.18127524260060418,-0.3668521372441012},
{-0.029179810183208067,-0.17781415669341102,-0.3832501569657371},
{-0.03178341272739401,-0.1756966149728465,-0.39863383074107767},
{-0.03539111460458732,-0.175011329728451,-0.41379744302298477},
{-0.03528720431815665,-0.16661873452262815,-0.41347422770450426},
{-0.034710849513010796,-0.15819746255344228,-0.41359113537289083},
{-0.03372641817597905,-0.14995519685532127,-0.4145676582500023},
{-0.027902146906176095,-0.19357571731450707,-0.383360187712454},
{-0.02689254603583289,-0.19703556537579972,-0.36626759890216826},
{-0.02753354390467486,-0.18926945773409554,-0.366685715739692},
{-0.028640728293512517,-0.1858283836689615,-0.3834977261458499},
{-0.026091384661301294,-0.20453718661008335,-0.36573051131975687},
{-0.026973762480753213,-0.20105299424607964,-0.38297508009894515},
{-0.02945564351138371,-0.19908124326491483,-0.39932152290805767},
{-0.030508775295896746,-0.19162535355973534,-0.3994315536547744},
{-0.031301684364424584,-0.18380340531407244,-0.3991220921796334},
{-0.023148406032710768,-0.22183161307137764,-0.38182663418008866},
{-0.02263648798361092,-0.22509127394286238,-0.3647141022969606},
{-0.023972398787186093,-0.218601522963073,-0.3648220699671765},
{-0.02458705804603274,-0.21518438058534983,-0.38206044951686186},
{-0.025120982244475936,-0.2117376674444465,-0.3652051145041842},
{-0.023142904495374927,-0.22898980083747153,-0.34711674743611165},
{-0.02110430983557968,-0.23117047269896482,-0.36501118531309595},
{-0.02155928697325359,-0.22819689176894367,-0.38193666492680556},
{-0.02322020109494347,-0.2259873368364372,-0.39813869238085225},
{-0.02502449903344866,-0.2196241212153721,-0.39820746159755027},
{-0.02668451915532146,-0.21304359486954133,-0.3985444307593703},
{-0.02586540901523169,-0.20825691354127768,-0.38249369558205926},
{-0.02422161842849961,-0.23323767535290643,-0.32935228337868666},
{-0.021444304842934546,-0.2344872120203089,-0.34763595502218153},
{-0.022072236560603906,-0.23786996978968308,-0.3301623847513889},
{-0.019437619099687168,-0.23934094333485312,-0.3487410763345182},
{-0.019366786806488238,-0.23680404693086426,-0.3658446682194756},
{-0.025334992046840088,-0.23768979444193436,-0.3118030669695263},
{-0.026016563753533877,-0.24256140575282004,-0.29466302739971906},
{-0.02924239017040324,-0.23894964649184156,-0.2938549891035176},
{-0.033810798004867484,-0.24179875513963933,-0.27651139265228425},
{-0.03007793615328383,-0.24549578822932333,-0.27722246635294145},
{-0.025838589020719477,-0.24831738919044186,-0.27815428923919927},
{-0.022351439580397744,-0.24535756210376036,-0.29569319026585494},
{-0.022518823853840655,-0.24137238599611177,-0.31276308523463026},
{-0.024414928696637663,-0.25555603694007245,-0.2624480878375451},
{-0.02980382205552564,-0.2533636743117405,-0.2614784418821034},
{-0.03471607597347984,-0.2503474564673666,-0.2606126374438757},
{-0.01864477880037603,-0.2570462658659179,-0.26340535533398113},
{-0.021177342743712947,-0.25037358876971183,-0.27918720287400306},
{-0.018320394405211608,-0.24743232937153878,-0.296820317727535},
{-0.019331920813622356,-0.24429576539794337,-0.31394866653050363},
{-0.01957151276459816,-0.2417588689939545,-0.3313520922002642},
{-0.017161426796200363,-0.24355030708893718,-0.3502595006392098},
{-0.01741484135973246,-0.2419541735693768,-0.3673465879121597},
{-0.01796905247710157,-0.24006439549451603,-0.38376592609097204},
{-0.01982953486564902,-0.2342754028328791,-0.382534957112078},
{-0.021300508410819045,-0.2321703771097536,-0.3985031692293516},
{-0.023967928788100723,-0.23120004346214493,-0.4140243814380881},
{-0.02617356387525539,-0.22521643391725274,-0.41398311990806935},
{-0.028252869911335847,-0.2190739674817882,-0.41427882753987066},
{-0.03015715829091992,-0.2126887457113797,-0.4147051966833983},
{-0.02817124085111533,-0.20620827857584453,-0.3989707999028979},
{-0.01527536225904126,-0.24657408954714782,-0.3693126998175552},
{-0.015987536267165654,-0.24556043129301947,-0.38578774106189306},
{-0.013900184232731533,-0.25066104409550943,-0.3883390790013885},
{-0.012975100729710158,-0.2506156564124888,-0.37154013474640313},
{-0.011722125601472762,-0.25526239238477205,-0.3911861245726853},
{-0.01302262025844847,-0.25563993538444396,-0.40717496745496823},
{-0.015139267979195936,-0.2500104873055465,-0.4038671681317949},
{-0.017231090012715427,-0.2441444731212078,-0.40119892252391276},
{-0.014654169924608306,-0.24711324020606007,-0.3520193048945114},
{-0.011954359246261877,-0.25003043037838885,-0.353849941443012},
{-0.010540876766251369,-0.254030735713711,-0.3738218973564426},
{-0.009468420831846198,-0.25926201002792715,-0.3940744316740009},
{-0.010884722849741324,-0.2608657081613243,-0.41081285901829195},
{-0.012600996190873086,-0.26147018957609963,-0.42575640980676543},
{-0.01480223004815908,-0.25529402622445313,-0.42158211835319737},
{-0.017053046510684327,-0.2490710998054519,-0.418171165204977},
{-0.01936162911523589,-0.24303935180887107,-0.4159155348972829},
{-0.01929444159052195,-0.23821037741233816,-0.3994659382631235},
{-0.021681902486626107,-0.23711144532950426,-0.4146020428583512},
{-0.02517166515718236,-0.237600394460227,-0.429745024375249},
{-0.027774304932334525,-0.23211948788939707,-0.42973127053190924},
{-0.030274684882256785,-0.2265251121110155,-0.4301026243020784},
{-0.03260362317495095,-0.2206824794603542,-0.43065277803566243},
{-0.03469173167076875,-0.21445886534918598,-0.4311547933175577},
{-0.03183767163936872,-0.20597824554598979,-0.41508342737523723},
{-0.01371684550101469,-0.24746258782688585,-0.3342747839099289},
{-0.01676964856867191,-0.24494357141923845,-0.33277286421724467},
{-0.01583617522121338,-0.24652870186412715,-0.31522433550025136},
{-0.012093341833208517,-0.24814133999569507,-0.3164553044791454},
{-0.010463305089816036,-0.24935305359391363,-0.335708622078082},
{-0.007999441593960412,-0.2567718766912929,-0.3759606199957501},
{-0.009100574291728645,-0.2523005022215895,-0.35557879955079946},
{-0.013996461136108721,-0.2488785459986975,-0.2979192498103689},
{-0.01617837084350258,-0.25177648079035087,-0.28020223651246545},
{-0.022504657395200873,-0.08008642915154603,-0.4918092424451858},
{-0.02066845054014781,-0.08792295647114891,-0.4744312613856034},
{-0.02388444295902936,-0.0982270608243091,-0.4709309082556758},
{-0.02552252570077551,-0.0912466414833795,-0.4864658743077519},
{-0.028310911130228954,-0.08314377098750532,-0.5035412708138631},
{-0.025394752496150644,-0.07100009008767387,-0.5106451308987656},
{-0.026786778980551377,-0.11416322648660134,-0.45757592637292593},
{-0.027124642142188606,-0.1085850802433605,-0.4698856161618662},
{-0.02719629966598791,-0.11921253745343463,-0.4463940517378325},
{-0.02814868454803839,-0.12410622368288038,-0.43642939223829363},
{-0.032510028271024984,-0.13396378888125549,-0.44496365203051436},
{-0.031143790242885994,-0.129137929730239,-0.4525351427889631},
{-0.03029242734016487,-0.12425834119021635,-0.4615301563330604},
{-0.030202614743157292,-0.11896173612013707,-0.471879923446108},
{-0.031149016703355042,-0.1129773013446445,-0.4838457671515585},
{-0.028454913869994547,-0.10222991062064905,-0.4836050748931155},
{-0.031022687652280834,-0.09484939197697055,-0.4990162563551353},
{-0.035072919438925716,-0.08619554251691208,-0.5164011143363875},
{-0.03246257751150337,-0.07369254245983363,-0.5224665592491503},
{-0.029518567344662374,-0.06045776916787185,-0.5312621420648233},
{-0.038556561649195846,-0.1496726929131259,-0.4525076351022839},
{-0.034144397475069435,-0.13909922641508138,-0.4388913301960817},
{-0.02943920766859289,-0.12921735817552518,-0.4277713478560165},
{-0.03580029144394036,-0.14490757761121872,-0.4344007003457029},
{-0.0404409069559375,-0.15559991170032578,-0.44963308184430784},
{-0.042366307485047855,-0.16107586688755338,-0.46944549317499906},
{-0.04005497411182837,-0.15551450033318684,-0.4719074311327872},
{-0.03657662713124398,-0.1444191992649946,-0.4566406650258332},
{-0.034787871035712535,-0.13950147131739124,-0.4621146946749933},
{-0.03347726730388222,-0.13458161152407025,-0.469039754796481},
{-0.032931721107817065,-0.12932168107725603,-0.47751899921534324},
{-0.03345209777057076,-0.12343008474430572,-0.4878137509550325},
{-0.03533933138441373,-0.11661498660031813,-0.5001990868823407},
{-0.03340664131833339,-0.10603408614994853,-0.4976958873945338},
{-0.037250152839584105,-0.09786141489912586,-0.5136847302768167},
{-0.04295442182624907,-0.08818833687838647,-0.5320873726651992},
{-0.04085077148745753,-0.07601996782976043,-0.5360484795470034},
{-0.03819036557027904,-0.06266663640821131,-0.5435512010887542},
{-0.03505586467318461,-0.04825329628047938,-0.5539972451051791},
{-0.03990650137297741,-0.11826035887903426,-0.5207817134400494},
{-0.03735757035606637,-0.13563357423189942,-0.519186267612656},
{-0.03669745464498236,-0.12650908888352488,-0.5071585316121774},
{-0.03889456234926647,-0.10858480516649373,-0.5149432069423899},
{-0.03521114556448868,-0.13352931872400092,-0.4961348261754894},
{-0.03627404257777283,-0.14321868129525445,-0.5094347926848809},
{-0.036488258687787066,-0.1524417541926872,-0.5283600811201681},
{-0.037196169004476184,-0.14390545883165226,-0.5369218485990679},
{-0.04018639208493823,-0.1267827215967662,-0.5318260496417467},
{-0.04516040075948723,-0.10847456811212684,-0.5373069562125767},
{-0.0444185184497493,-0.09904789019481632,-0.5323074341586327},
{-0.03664773450130971,-0.16998457506469464,-0.5491146307196217},
{-0.03570160761797875,-0.16114202287401685,-0.5535502451966422},
{-0.03485354563765912,-0.1798280632044117,-0.5825983623298736},
{-0.03376169678414512,-0.1692632547507494,-0.5856379617079247},
{-0.036090016153889,-0.15124186889974067,-0.5609773206000251},
{-0.03716804239484671,-0.1599866312642739,-0.5225284515441784},
{-0.03659904589588753,-0.14985974518254444,-0.5021796403232428},
{-0.038892705580415625,-0.16687153016320996,-0.5189455753542132},
{-0.038589708411644275,-0.17810731986419456,-0.5470653080620216},
{-0.03686848368691026,-0.18959556135967745,-0.5821032239696481},
{-0.0319446077713341,-0.1892455948159014,-0.6203182776887216},
{-0.03081266646448517,-0.176687235539381,-0.6220100004194923},
{-0.03391553352189852,-0.1575598343762185,-0.5919716065658098},
{-0.03815164850127808,-0.13994630705867872,-0.5720010260367131},
{-0.03963465665937025,-0.13404650449509986,-0.5486882615760943},
{-0.04509727061855847,-0.11634451727104492,-0.5477186156206525},
{-0.051731299414980274,-0.0971138935136187,-0.5567205060864195},
{-0.05120604013784102,-0.087961192155633,-0.5522986454527388},
{-0.03611793645586838,-0.14511840339884977,-0.48064112165343204},
{-0.04012793825074494,-0.1615965186271739,-0.4936385036093523},
{-0.0378666688672816,-0.15030433816849698,-0.4755590765394505},
{-0.04265967696348148,-0.16734019237500677,-0.49160981171676155},
{-0.041319364930037634,-0.17342771220632966,-0.5171231911117163},
{-0.03799595499467382,-0.15587842702795263,-0.4970425798359029},
{-0.03512539035126628,-0.1396295677373346,-0.48740113565484455},
{-0.04690741394048299,-0.18687938360775688,-0.5168412373232546},
{-0.044106237436723726,-0.19354415224404267,-0.5476636002472942},
{-0.04700334699777669,-0.2015337598400153,-0.5490871230329426},
{-0.04938303697239397,-0.194437601907383,-0.5174120218218478},
{-0.04954134370923275,-0.21015460007605877,-0.5504556304452326},
{-0.04522586905378371,-0.2175259724139164,-0.588230561177439},
{-0.04237724179050283,-0.20810328311117438,-0.5856723463162737},
{-0.03948391453636825,-0.19890691330058544,-0.5833823314002307},
{-0.04118877218752815,-0.18584791412650373,-0.5467833542735598},
{-0.044105205898473256,-0.17998657624890055,-0.516586791221472},
{-0.04525578366304734,-0.17343575820468332,-0.49059202730963136},
{-0.047581077187256515,-0.18020966358786883,-0.4902069196961227},
{-0.04930010129705619,-0.1879880809193619,-0.4901037658710756},
{-0.051189397987400104,-0.20299242369539636,-0.5178108832786962},
{-0.05138160794807099,-0.2197444673445936,-0.5511501995338822},
{-0.04770719993068063,-0.22751607652363356,-0.5902798838350392},
{-0.04180927682979413,-0.23404227518827292,-0.6314245061854472},
{-0.039134566915542464,-0.22297455745289824,-0.6278141223088027},
{-0.0364015407055309,-0.21204712891958746,-0.6241487230587998},
{-0.033906249677644294,-0.20091806904291817,-0.6213429390175218},
{-0.04448412428247918,-0.16731550422621222,-0.46792569348597357},
{-0.04609181103044482,-0.17456047874377895,-0.46711421672893716},
{-0.047184760191425985,-0.1825425904951315,-0.4668460167838151},
{-0.05042289629808429,-0.1964780533360291,-0.4901725350877736},
{-0.05234437698184286,-0.2122169888848315,-0.517989683242111},
{-0.05254559570990118,-0.22993606525923588,-0.551191461063901},
{-0.04949856925644659,-0.2384146219859312,-0.591070729827066},
{-0.04412961897040103,-0.24559412820920146,-0.6340514902633104},
{-0.036987660739447877,-0.25027043494466483,-0.67582878940734},
{-0.03459442322914109,-0.23746766987199988,-0.6712625134185934},
{-0.032138536962422436,-0.22471029248235552,-0.666311129816338},
{-0.029880293424493803,-0.21165651976874286,-0.662068069146072},
{-0.02808019040820719,-0.1979658753392901,-0.6596130081099538},
{-0.037661392755438096,-0.2247151063275244,-0.4480445129385844},
{-0.0351827438779924,-0.230376188246103,-0.4472536669465573},
{-0.03245425643628291,-0.23557376564413718,-0.44642155942451167},
{-0.03756662877482826,-0.2419576120302117,-0.4649823710112995},
{-0.04039008650479768,-0.2369388345955923,-0.46627523228522166},
{-0.04285181815493567,-0.2311017034822668,-0.46727238592734266},
{-0.03979901508727845,-0.2184041553111498,-0.4485602820638192},
{-0.04369884859700482,-0.2680589682279342,-0.5087883620479198},
{-0.04023143592187542,-0.2898966329903812,-0.5295085270390244},
{-0.04042247680586244,-0.27153112597901574,-0.5056456088448216},
{-0.04252138206870182,-0.25132329165231104,-0.4863558435610351},
{-0.03942374147175751,-0.25561380308209875,-0.48429276706009533},
{-0.036922811368101674,-0.2740618331535018,-0.5023928248950067},
{-0.036687826954644634,-0.29125138655933164,-0.5247496972435236},
{-0.03507319451579251,-0.31091113022895334,-0.5496441536881963},
{-0.03851894488766205,-0.3108960010012798,-0.556328521551241},
{-0.043565986470344306,-0.28733979351354993,-0.5340954337927806},
{-0.046600772003226654,-0.263306327661936,-0.5115803922458583},
{-0.04524629351114302,-0.24600468043288845,-0.48808882782182456},
{-0.03449567063396278,-0.24639666496806703,-0.46363449436401893},
{-0.03608870953877174,-0.25916779620105096,-0.48215404442078785},
{-0.033351075791241414,-0.2759901219897135,-0.4992500716919085},
{-0.03309346630549074,-0.29178572337307507,-0.5200252520563715},
{-0.03158253784541918,-0.3098156366069543,-0.5428635089217744},
{-0.02898931945295463,-0.3290180649855344,-0.5666095194475907},
{-0.03225730139965986,-0.3318582336351614,-0.5757076868167348},
{-0.03547666351015962,-0.3332597502714664,-0.5845926696141153},
{-0.04176636483857458,-0.30935625823941176,-0.5627859509991824},
{-0.04653330940164592,-0.2831998866683309,-0.5383109867763674},
{-0.04897496044050809,-0.2770952433020502,-0.5419557552613607},
{-0.04897695474779233,-0.2569341720427002,-0.5137947610235336},
{-0.047463137980619456,-0.23936707563719833,-0.4892579045056903},
{-0.03129143775113658,-0.2504946225911003,-0.46248604844516245},
{-0.032651555318989445,-0.2622768524879671,-0.4801872448232254},
{-0.029858356044367144,-0.27765571241813886,-0.49645116457230026},
{-0.029606729480469197,-0.2918813125842853,-0.5155277452843229},
{-0.02820019269134519,-0.30802557389630564,-0.5361516333720504},
{-0.025812044103074052,-0.3251848688467884,-0.5573806905667203},
{-0.022615788449384822,-0.34245694531265575,-0.5782934093645793},
{-0.0254851152468918,-0.3483325871873321,-0.5900942069499546},
{-0.02841825987749452,-0.35290849086641646,-0.6015924199818588},
{-0.031296320365522136,-0.3557156502920285,-0.6127605407736125},
{-0.038508285659073854,-0.33278042883108144,-0.5931681909363548},
{-0.044662167784510286,-0.3058765358744934,-0.5688445189902754},
{-0.04705299837223264,-0.3000407801455019,-0.574366687091124},
{-0.04891568137571443,-0.29225816789179027,-0.5792493014766813},
{-0.05086941482210435,-0.26939240333970826,-0.5450228623260913},
{-0.05080951683436039,-0.24926777976520814,-0.5154864837543041},
{-0.04915740517240786,-0.23169930797537233,-0.4899593505160098},
{-0.04483766682552356,-0.2242055264317923,-0.46771938583587946},
{-0.04150462919982202,-0.2112583460040615,-0.4485602820638192},
{-0.03646969099927861,-0.20772085749711686,-0.4313954855760007},
{-0.03324572135126009,-0.19885870607968012,-0.41520721196529353},
{-0.03433248128273844,-0.1912471916371131,-0.41488399664681297},
{-0.035060265903053285,-0.18325944080999135,-0.41434071983489895},
{-0.026364879836109203,-0.2917726572219025,-0.5114634845774717},
{-0.026549662721376703,-0.27939626129276496,-0.49441559575803967},
{-0.025944080999134193,-0.2684172558469307,-0.47799350681055947},
{-0.02280724194867203,-0.2722195058381626,-0.4787774758809165},
{-0.02353007518538462,-0.2815494254675791,-0.49354222670597525},
{-0.023505111959723244,-0.29169357262269974,-0.5080456545075814},
{-0.022265821905608746,-0.30285756726145163,-0.5225628361525273},
{-0.025052556873861438,-0.3056647266870636,-0.5294122501356474},
{-0.01888127613660042,-0.26916821569327276,-0.46677037064544724},
{-0.021803073846447966,-0.2634988814686904,-0.46346257132227386},
{-0.024885241369635224,-0.2587166701395121,-0.4619496485549181},
{-0.020753311753553133,-0.2556220553881025,-0.44780382068014135},
{-0.01797792370605561,-0.26155752648130615,-0.4509190661965603},
{-0.015390275620143603,-0.26832510509655544,-0.45582231134712714},
{-0.016179677458619843,-0.2760533896690756,-0.47232004643297515},
{-0.019879736393838554,-0.27724722327095275,-0.48181019833729793},
{-0.02080784574239464,-0.28534342315280725,-0.4955502878335565},
{-0.02144898114967001,-0.2918063541380845,-0.5057969011215572},
{-0.01999403083199061,-0.2986296358188591,-0.5140010686736275},
{-0.01783687804260803,-0.30831302922210324,-0.5255336663138807},
{-0.020131844342253385,-0.3148832401854293,-0.5373413408209257},
{-0.02282608471404728,-0.32044460673979586,-0.5477323694639922},
{-0.026611623785621596,-0.24532042672674342,-0.44557569805912633},
{-0.022525356929426966,-0.2431170610237398,-0.4304120857772194},
{-0.029566843334784362,-0.24049282771454444,-0.44578200570922044},
{-0.02365248439110704,-0.25028625186450537,-0.4461327287143802},
{-0.019893696544828244,-0.24882215524100512,-0.4319937777612732},
{-0.02806794948763495,-0.25449148946558753,-0.46177084859150336},
{-0.012593362807819608,-0.26811192052479166,-0.44402839068342165},
{-0.014908478487957478,-0.26140210805156866,-0.4388982071177515},
{-0.01733527537601288,-0.2548669693887586,-0.4347307925858533},
{-0.010441230171255981,-0.26736027298628257,-0.43032956271718187},
{-0.010369985262756861,-0.27468006841161674,-0.4496468356876475},
{-0.012958045963969055,-0.2755252420848351,-0.46192901778990875},
{-0.013653302744785746,-0.28367026811054513,-0.47939639883119833},
{-0.01720420124898651,-0.28410695263657737,-0.48791690478007954},
{-0.018391226698410538,-0.29200578486650863,-0.5021315018715543},
{-0.01604867210081017,-0.3005462338882321,-0.5116216537758771},
{-0.01354836092010461,-0.3099724304210258,-0.5223427746590938},
{-0.015276531335725126,-0.31904102702698983,-0.5382147098729901},
{-0.017422887358086125,-0.32761173450406045,-0.5526424915362287},
{-0.019898854236080597,-0.3354837467394795,-0.5659080734372712},
{-0.008729082983126097,-0.26552207182394527,-0.4144851351899646},
{-0.008314954760170796,-0.2727263349652268,-0.43492334639260755},
{-0.00821826524149342,-0.28079021331523324,-0.45529278837855264},
{-0.012215957346581034,-0.30070440308663754,-0.5052742550746524},
{-0.008945706015724768,-0.29915984647960064,-0.4953095955751136},
{-0.01125697061972755,-0.2915340280399604,-0.4872979818297975},
{-0.014682365303454483,-0.2921440109920716,-0.4960798108021311},
{-0.010649119513334008,-0.2827597636814637,-0.468661524104642},
{-0.0084311747363904,-0.28962980842959307,-0.4754559227144036},
{-0.006674327557406822,-0.30606358814391194,-0.5027297940568267},
{-0.00977609430735301,-0.30917952135249793,-0.5146474993105886},
{-0.009459343295242064,-0.339915235063498,-0.562627781800777},
{-0.008259526771512215,-0.3282946128258715,-0.5433517703603301},
{-0.012441314069700352,-0.32988524480809606,-0.5509507688054581},
{-0.010936574839131609,-0.3194880269355268,-0.5332633262707347},
{-0.00733403065319065,-0.31696350899054354,-0.5233261744578751},
{-0.010941938838034054,-0.3516816480405243,-0.5809891626591406},
{-0.014304478457699022,-0.34016899347311363,-0.5675103961863344},
{-0.02489500659840634,0.16725086116251608,-0.8735334104923945},
{-0.026468515045673074,0.17104142038690937,-0.9008416664431667},
{-0.013461161553331557,0.18280989644043655,-0.9163009863568751},
{-0.039444578544417006,0.10841810858521778,-0.7714592621475663},
{-0.03554845857239232,0.09188667658318772,-0.7400042224299054},
{-0.031443348950822445,0.07293663122988929,-0.7073044598900106},
{-0.042748114176155094,0.07182532068804975,-0.7185688575851414},
{-0.047054511295,0.08740017288581076,-0.7481258669219379},
{-0.051060043090791186,0.09958745346902874,-0.7753172152043237},
{-0.04307442410938707,0.12142511823147578,-0.8008168407559388},
{-0.06136373482865118,0.08438876888660576,-0.7708884776489732},
{-0.05758995529313222,0.07736330570873899,-0.7497419435143409},
{-0.05359136918822754,0.06561683580455513,-0.7244898871428385},
{-0.06269263117212316,0.05637287769601117,-0.7263466559936843},
{-0.06602113002952262,0.06321747783396221,-0.7449212214238117},
{-0.0698626472434891,0.06224783187852056,-0.7553672654402364},
{-0.06514590420860729,0.08508058720658751,-0.7863821821710305},
{-0.05478004509885231,0.10719607960449448,-0.7991388718685078},
{-0.046380848048226474,0.12980602267045996,-0.8272242199679674},
{-0.054795793249476143,0.029834149280089456,-0.6758356663290099},
{-0.06412956395502768,0.02491096105668028,-0.6838816646826748},
{-0.059818009144930434,0.01017853176346966,-0.6576668392774006},
{-0.049598697235958875,0.0139491479150205,-0.6479841335663236},
{-0.05438771671759027,-0.005170757403521945,-0.6306749217234391},
{-0.06428855838403344,-0.007068787784386506,-0.6437273190527177},
{-0.06873476332042534,0.008538385945222556,-0.6709668057867921},
{-0.07152204844241163,0.024234959656539018,-0.6980068617924421},
{-0.06709447996374487,0.03815178603971145,-0.7081021828037072},
{-0.0591823752749909,0.04436233399970703,-0.7023943378177739},
{-0.04913484886933092,0.0507619973056221,-0.6966589851451614},
{-0.04417755111443954,0.034040074573338595,-0.6674389449701852},
{-0.048066519087927626,-0.02025872354706119,-0.6041231271563448},
{-0.058543440482649874,-0.022267472366809492,-0.616886693775492},
{-0.06797809562909735,-0.02196832627417324,-0.634099628714999},
{-0.07265055128842565,-0.005314485066420757,-0.6629001766681177},
{-0.07547490301821215,0.012840588141848883,-0.6933993242736767},
{-0.07593978292309056,0.03314951321709958,-0.7260440714402132},
{-0.07208595601933515,0.04160881456311946,-0.72581025610344},
{-0.06852542982479666,0.04767288409154831,-0.7261816098736091},
{-0.03812537866049944,0.05405260432462096,-0.6876639716010643},
{-0.04143049598422159,-0.034736706738489234,-0.5784240708763055},
{-0.061919871484087834,-0.03729698467615544,-0.6069770496493114},
{-0.05185955400412203,-0.03674201709740266,-0.5910569759837265},
{-0.0706569316963509,-0.034582663693085734,-0.6288731682459516},
{-0.07552854300723658,-0.017205370325670388,-0.6589046851779644},
{-0.07845398548556912,0.0021861733988291264,-0.6916319554045384},
{-0.07890236077844003,0.023857416656867053,-0.7272956711841165},
{-0.07634208284077382,0.0480744963170646,-0.7661227709318023},
{-0.07353148495432693,0.05626628541012927,-0.7612470334679147},
{-0.054937251528223915,-0.051477197159281195,-0.5814843010193662},
{-0.04486558712750294,-0.0502792374044022,-0.5665132425442135},
{-0.047693239779690935,-0.06441612528100821,-0.5577933058669082},
{-0.05720085906505499,-0.06435904683114888,-0.575941502153508},
{-0.06437080636720423,-0.05021184357203816,-0.6012967123500574},
{-0.07209627140183984,-0.04497438002831917,-0.6281235837839437},
{-0.07703321346858863,-0.027154900597535718,-0.6589115620996343},
{-0.08000335593777486,-0.007363120031853897,-0.6927872782450646},
{-0.08045104353847878,0.014550190868960932,-0.7299776706353382},
{-0.07781855792327969,0.0387321982286425,-0.7706890469205488},
{-0.07105923161403414,0.07357205879217871,-0.8063115011701083},
{-0.068517383826443,0.08096612497154673,-0.79769471831785},
{-0.049833406572549116,-0.07701939085603234,-0.5528556761079925},
{-0.05855176155787032,-0.07528200536537429,-0.5749305946680476},
{-0.07780686715644103,-0.021593534043169195,-0.7043061220419781},
{-0.08006180977196815,0.0060475649164213295,-0.7344751774073868},
{-0.07816171631460266,-0.00138432433213057,-0.7401898993149899},
{-0.07478102162172942,-0.02536827634772192,-0.7150409967685346},
{-0.07517713230990984,-0.007478652315906523,-0.7465372980162144},
{-0.07295932507139964,0.01005749794208119,-0.7817883984956047},
{-0.07573209988866264,0.01974845595916208,-0.7797115681513253},
{-0.07748365183796047,0.029298437082012106,-0.775612922836125},
{-0.07966776216028866,-0.01544006453303295,-0.696954692776963},
{-0.07515581385273347,-0.040780145501908685,-0.6715100825987061},
{-0.07226475598274992,-0.04342776034478135,-0.6857040489251716},
{-0.06842014415403204,-0.04221948520739764,-0.7070775214749071},
{-0.07103378700385589,-0.024741101091436242,-0.7326734239298994},
{-0.07215678831253408,-0.011435633044708933,-0.7519425584486764},
{-0.06982963801947406,-0.001759116563134614,-0.7770570763867829},
{-0.06524630726498636,0.012175589816379314,-0.8123494383961919},
{-0.06827256541499815,0.027855658915688242,-0.8200584675880367},
{-0.07070988399320835,0.041336488464995415,-0.82131006733194},
{-0.07218773446004817,0.05331333524511756,-0.818469898682313},
{-0.06446646434763113,-0.06065719989629602,-0.6799068039575309},
{-0.06812058544609559,-0.06147211511416722,-0.6569447625020717},
{-0.07069750553420272,-0.05884581872847094,-0.6412585041732599},
{-0.06271876347446839,-0.07883592971510976,-0.6297052757679975},
{-0.05943138860865433,-0.07902545767632943,-0.6530180402286164},
{-0.055062205194964166,-0.07584770094193197,-0.6843424184345513},
{-0.05986552867366875,-0.05597264085482887,-0.7110523822000511},
{-0.0659121308210563,-0.06951673808349822,-0.6040681117829865},
{-0.05819244240062332,-0.09073149128109485,-0.5887600841460136},
{-0.05889113764227491,-0.084140512014326,-0.5789811015315592},
{-0.051347017032071895,-0.10432523988422013,-0.5667401809593168},
{-0.049991300694087706,-0.10944304499088463,-0.5830109776300615},
{-0.05642885583840334,-0.0948516613611216,-0.6049621116000602},
{-0.06489028903014085,-0.07556952946038858,-0.6136476636690166},
{-0.07206601294649273,-0.05320399219056776,-0.6319540291540217},
{-0.06575024808494924,-0.060967349063603966,-0.6002032818045592},
{-0.07682690581849465,-0.03518508203136015,-0.6628451612947593},
{-0.04222519305238357,-0.12691764679992765,-0.5872334075353182},
{-0.04414646742849205,-0.12253354046621402,-0.5641544584114724},
{-0.03563772101566631,-0.14437678241213528,-0.6023695121305461},
{-0.039250855660978766,-0.12937277660526264,-0.6175743859424718},
{-0.0476021205675661,-0.11231505378784284,-0.6061655728922751},
{-0.05357376426875285,-0.09629787798828035,-0.6282611222173397},
{-0.04461396056360499,-0.09127524947752588,-0.6954211392445976},
{-0.04960041646637633,-0.09486699689644526,-0.6593448081648315},
{-0.04411751558826219,-0.1127890799985421,-0.6368297666179094},
{-0.03966567157610104,-0.11141170135729801,-0.6722940516690633},
{-0.04965976430038669,-0.0701844871776357,-0.7208726263445241},
{-0.054262900589283417,-0.04845891623840637,-0.7475825901100238},
{-0.06388804646598434,-0.036249629505845045,-0.7372534537619857},
{-0.06700748690462191,-0.017686754842556312,-0.7607312643426797},
{-0.06200046900605787,-0.00639691253724713,-0.7958379494670041},
{-0.05854192755988251,0.02788935583187027,-0.8514103534806508},
{-0.061262231464804945,0.046529939710027696,-0.8605979208315024},
{-0.0632867284351771,0.0629135178961571,-0.8634243356377899},
{-0.06443097943181497,0.07709648114795078,-0.861120566878407},
{-0.07240504518481383,0.06399044382964764,-0.8129821151898134},
{-0.06333988703968466,0.09908406280279944,-0.8460394776565376},
{-0.06116478548474389,0.1060242521519607,-0.8340736339510872},
{-0.05822992162372372,0.10903496845899874,-0.8185799294290298},
{-0.0493067031418592,0.13245638828200054,-0.8498217845749272},
{-0.036277137192524234,0.15038589845950076,-0.8527032147545729},
{-0.0385683211852512,0.15369094701400624,-0.8779621480477451},
{-0.0404099608084234,0.15173721356761627,-0.8994662821092069},
{-0.027713100329473314,0.1693558868856416,-0.9244363846922474},
{-0.03906847969829569,0.059298320174343694,-0.927909230135496},
{-0.04979104473506315,0.04404255714206137,-0.8910007915336842},
{-0.02686717019487133,0.07214165908486052,-0.9586903315295168},
{-0.028075032716954842,0.09633123105837887,-0.9685518372040086},
{-0.040837499028634816,0.08209806627839565,-0.9378326281050161},
{-0.052069919038001185,0.06497796978143079,-0.9007453895397894},
{-0.02909969404575491,0.1515831705222128,-0.9584427623494041},
{-0.02918386756699325,0.1365103336063471,-0.9678366373503496},
{-0.014835583118257606,0.14768395593543668,-0.987882864017814},
{0.0,0.15193045506653766,-0.9955024932279514},
{0.0,0.13253065903603437,-1.0},
{0.0,0.10990008520505949,-0.997744369692306},
{-0.028599810609577215,0.16270040209361003,-0.9438017961144017},
{-0.041734043306726525,0.14508998108158846,-0.916885524698808},
{-0.04247255592484625,0.13431453251718026,-0.929896660498068},
{-0.04255741713825157,0.1199768385278161,-0.9381627203451665},
{-0.028844766559455455,0.11794058202138859,-0.9714057596969754},
{-0.014674525612750913,0.1284911552471944,-0.9920846631580613},
{-0.05171513864905625,0.13007078415474724,-0.868588903811809},
{-0.0534695101362387,0.1233451547616837,-0.8835049469136032},
{-0.014292512613993573,0.10611846597883694,-0.9896227252002732},
{-0.04200643817406726,0.10244825288366517,-0.9410303966814727},
{-0.05365518702132327,0.0835827936669053,-0.9040119273329441},
{-0.0544688643932939,0.09965003345622392,-0.901653143200203},
{-0.06451020156945106,0.08913453253093412,-0.8549175835322482},
{-0.05443296686217755,0.1129733814992927,-0.894535529271961},
{-0.022318017741082524,-0.17081599489457336,-0.7006888612436637},
{-0.022463877249698963,-0.18897148071814318,-0.6971059850536985},
{-0.02341963182336764,-0.20571740390705429,-0.6978143079856878},
{-0.02496797073732291,-0.22139355316101145,-0.7015622302957283},
{-0.026891514497582418,-0.23633847933381882,-0.7071050291615864},
{-0.02085735957841719,-0.24637465881872364,-0.7437658985832853},
{-0.014232889703116413,-0.2542604248974823,-0.7735085848051665},
{-0.007214853600653032,-0.25943874691484103,-0.7935685653159705},
{0.0,-0.26135053113904516,-0.8011813176044381},
{0.007214853600653032,-0.25943874691484103,-0.7935685653159705},
{-0.01736649660039377,-0.3065105880524489,-0.791911227193549},
{-0.008334210140846232,-0.2960274086590071,-0.8088490852662641},
{-0.008807754967028599,-0.3142519387761417,-0.8129133459731155},
{-0.018033558002364287,-0.3243857705487577,-0.7916842887784454},
{-0.009146512128482902,-0.33287189188928984,-0.8124938537512577},
{0.0,-0.31714162126179135,-0.8208561905017334},
{0.0,-0.29861175582251764,-0.8167575451865331},
{0.0,-0.28012521498976367,-0.8096605620233004},
{-0.00778385009961221,-0.27786752160556866,-0.8018758866930878},
{-0.016434261098835806,-0.28908790700201287,-0.7879638741550842},
{-0.025427074027998698,-0.2948466412083026,-0.7606968797343308},
{-0.026401877674692723,-0.3116194531609427,-0.7607175104993402},
{-0.0270050524743508,-0.3283675081955714,-0.7574372188628461},
{-0.01844582945646874,-0.3421316669176743,-0.7877575665049903},
{-0.009355639316461493,-0.3512910388896797,-0.8081270084909352},
{0.0,-0.3360449035477351,-0.8203610521415078},
{0.009146512128482902,-0.33287189188928984,-0.8124938537512577},
{0.00778385009961221,-0.27786752160556866,-0.8018758866930878},
{-0.015351489781925937,-0.2717828213121304,-0.7813276447437282},
{-0.024065924921895358,-0.27860679068507205,-0.7569420805026205},
{-0.03274054268539665,-0.28018710728479185,-0.7220898414800786},
{-0.03399186735243329,-0.2956058533606485,-0.72238554911188},
{-0.034767859193653425,-0.311127065569385,-0.7198548419373939},
{-0.035086948359132106,-0.32622534709542894,-0.7148415660401103},
{-0.0272514525777797,-0.34453583873343613,-0.7512686201250361},
{-0.018613420037561744,-0.35916786497026765,-0.7806330756550784},
{-0.009440431760650117,-0.3689131506685399,-0.8003354562390528},
{-0.028973021148597213,-0.25089348404794864,-0.7132048586826981},
{-0.022486639860425994,-0.26256155704509676,-0.7508353740598389},
{-0.03099511119638494,-0.265396224157388,-0.71861699603683},
{-0.039057751700490806,-0.2634603707073395,-0.6789302810804194},
{-0.04579967939791175,-0.25797052413833893,-0.6347735670386393},
{-0.04054433585785128,-0.27737857247484593,-0.6794735578923337},
{-0.041468800437922365,-0.2915367788086283,-0.6777336967098744},
{-0.041852601436313856,-0.30544466519363,-0.6739582667131546},
{-0.041717057310202116,-0.3186153455756293,-0.6684223447689664},
{-0.034967840075811184,-0.34037598881537456,-0.7076964444251891},
{-0.027155863366569496,-0.35956672642711596,-0.742644960351108},
{-0.018546713897364696,-0.37491326482543963,-0.7707853238239261},
{-0.009406253459951214,-0.38514062273276484,-0.7896487199641851},
{-0.04194275787940492,-0.16253879443436975,-0.44790697450518824},
{-0.03837287907139551,-0.1593712155440436,-0.4300201012420409},
{-0.03723110376655876,-0.15175213648763974,-0.4315467778527362},
{-0.03916179952535487,-0.16750317541858104,-0.4294768244301267},
{-0.04303357519466846,-0.17023283193697436,-0.447095497748152},
{-0.04780801560235988,-0.19964542591870515,-0.4672311243973237},
{-0.05095950249597871,-0.20538662397473692,-0.4903031965994999},
{-0.050920097734810765,-0.2144210422800021,-0.4903788427378675},
{-0.04732890046962498,-0.208229749700682,-0.46756121663747413},
{-0.05031451601256826,-0.2232874573888741,-0.4903031965994999},
{-0.05277198397127097,-0.23136577727438712,-0.5174807910385459},
{-0.05286585395206373,-0.22178347461968903,-0.5179002832604037},
{-0.047758364227903936,-0.1909936395351476,-0.46694229368719226},
{-0.043868433485382066,-0.18686033453473153,-0.4472399131032178},
{-0.043555396010972816,-0.19528091881175044,-0.4477212976201037},
{-0.042762143096361484,-0.20348192297985268,-0.4482233129019991},
{-0.04633442882695533,-0.2164992480086154,-0.46776752428756807},
{-0.05208050949737267,-0.24063655537744325,-0.5166968219681888},
{-0.05293090963106003,-0.25066035640334244,-0.5493484460563949},
{-0.053054900528766505,-0.24036354158715226,-0.5505862919569587},
{-0.05219528532004162,-0.2604585943984722,-0.5474848002838794},
{-0.03886196574055162,-0.19246165600399961,-0.4306459011139926},
{-0.03786818179004896,-0.2003353874698361,-0.4311547933175577},
{-0.039425667009825055,-0.18425886383626325,-0.4300544858503898},
{-0.03953404729534109,-0.17588628047249955,-0.42960060902018316},
{-0.016445745558024367,-0.3499754837742471,-0.5831141314551086},
{-0.04121284141337245,-0.3299753324819704,-0.6013379738800761},
{-0.03400011965843706,-0.35628162094545296,-0.6235504308735272},
{-0.03641075578056843,-0.35413602138447564,-0.6339345825949239},
{-0.04345107310924196,-0.32440158746859826,-0.6090057415419021},
{-0.023734457297411044,-0.372880446779847,-0.6259367226929474},
{-0.026169368953036815,-0.3769921582462199,-0.6392985814973672},
{-0.023650077468522608,-0.39719724180425664,-0.6920995860780847},
{-0.02206687256170146,-0.39819989698371333,-0.677575527511469},
{-0.030481336378434247,-0.37699697209138877,-0.6648050839706521},
{-0.028450168794042382,-0.378531213315921,-0.6522547019232686},
{-0.02028753784885764,-0.39581910670162895,-0.662686992096354},
{-0.024965426276305085,-0.3922768043495154,-0.70629355240455},
{-0.0321672824950022,-0.37188948236722896,-0.6769772353261966},
{-0.03840912044859535,-0.3488077824747152,-0.6438854882511231},
{-0.018384143469090643,-0.3905905831560807,-0.6473858413810509},
{-0.016428346946199778,-0.383048663160812,-0.6316308138355412},
{-0.014492218419284539,-0.3737297466060672,-0.6153875248514757},
{-0.021241091807591983,-0.3666960311221967,-0.6121553716666702},
{-0.01878472415635644,-0.3589395511708303,-0.5979407745751955},
{-0.012641501259508203,-0.36311315493223134,-0.598539066760468},
{-0.017043625127996703,-0.4085998656249505,-0.7298126245152631},
{-0.008641814847136347,-0.4194901587812444,-0.745526390530754},
{-0.009001615388900236,-0.4110260435900557,-0.761714664141461},
{-0.017751535444685825,-0.4002100211877956,-0.7448868368154626},
{-0.025998064834242118,-0.3839935521982424,-0.7197310573473374},
{-0.03442917080141582,-0.3530535939136492,-0.6987770770194596},
{-0.02673313899152694,-0.37290520369785835,-0.7319926086845893},
{-0.018256026418382285,-0.3887874542942593,-0.7587094493717588},
{-0.04108376159363032,-0.3305584954395694,-0.661387253900762},
{-0.033489439455237774,-0.36373276557468026,-0.6884204329847422},
{-0.03997396397455814,-0.34078516565472766,-0.6531211940536634},
{-0.04519994305908857,-0.31650825677600286,-0.6160064478017575},
{-0.05022717910736181,-0.2829358128762106,-0.5834167160085797},
{-0.05096431634114758,-0.272482891938116,-0.5867726537834417},
{-0.04713779081642126,-0.2955590902932938,-0.627291476261898},
{-0.04643655111375184,-0.3067444033892221,-0.6221612926962278},
{-0.047280762017936385,-0.28340275585758995,-0.6312181985353532},
{-0.046842358261486694,-0.27072308768281433,-0.6337764133965185},
{-0.0511040553894779,-0.26130583114819145,-0.5892277148195598},
{-0.050623152257108846,-0.2498138073457902,-0.5906924991352271},
{-0.31971496535063015,-0.3859225287266211,0.41574223647120384},
{-0.30296897339250234,-0.3932031256984373,0.39818889390904166},
{-0.29944867718973217,-0.39010988633136173,0.4184207974615906},
{-0.31882715476305906,-0.3816306419124994,0.4313989240368355},
{-0.29818332360248917,-0.3866817408789669,0.43656968144035746},
{-0.2752343482982026,-0.3966807849868548,0.4193354280436739},
{-0.2784465584101657,-0.3984846015408431,0.3978732432043979},
{-0.2836915865677215,-0.3996536782247089,0.37373545445105316},
{-0.30883361219250705,-0.39691528801579484,0.37450897060047217},
{-0.32351721534186206,-0.39029212475561137,0.39726463563662073},
{-0.33568386516007065,-0.38413315370813933,0.41107418204174423},
{-0.33573200361175926,-0.37931518238627804,0.4236300656264635},
{-0.33828471693558865,-0.37373593583557,0.43340698516441684},
{-0.3201585267983322,-0.3763697968351031,0.44465143978670535},
{-0.29892740652716143,-0.38186652032577356,0.4535123533582415},
{-0.2739126039532672,-0.394104690129348,0.43949306084218903},
{-0.24741926322036611,-0.40562147084976063,0.4187130666325571},
{-0.2501170795914283,-0.4067568506174443,0.3962365358469857},
{-0.2539378972711687,-0.40694665365553084,0.37213430077867377},
{-0.25859769939462457,-0.4061963815013558,0.3454517071614199},
{-0.29111247274160174,-0.4003248657796813,0.34555183514093213},
{-0.3171326812636206,-0.40219951462686854,0.34601836550701137},
{-0.3298047848245594,-0.396673220373018,0.37464313934224996},
{-0.3399214242930009,-0.3891313003777493,0.3951829914471725},
{-0.34598067997626086,-0.38393303528754813,0.4061613092008398},
{-0.34957799770173276,-0.38012253299031246,0.4124351248401975},
{-0.3537887368401507,-0.3744607633795669,0.41908029424972437},
{-0.35766044374024764,-0.36715678487407327,0.42405918553865896},
{-0.34156157011124794,-0.36645740194025467,0.4409633466951921},
{-0.3230165754443007,-0.36909263832412176,0.4559185882505042},
{-0.3014347321679702,-0.3746120556563024,0.47012768380464315},
{-0.2742715792644307,-0.3898650679199169,0.4597194628574022},
{-0.2461270896386109,-0.4035363881994774,0.44051978524749},
{-0.21541957130645692,-0.4141399137221407,0.44008034995278994},
{-0.21661546798483503,-0.4160317548735024,0.4169298808435782},
{-0.2186895475604464,-0.41697389314226496,0.3936143656142913},
{-0.22094586556030751,-0.4171183084973308,0.36963075744478346},
{-0.22268916520360157,-0.41661973167627026,0.3444760095149088},
{-0.22214107454651857,-0.41554280574277974,0.31834567396926977},
{-0.25948963613519754,-0.40415943730276127,0.3180265779268694},
{-0.3030288026110296,-0.3977618370733471,0.30779118777503384},
{-0.32896855114951185,-0.41415848141064915,0.311067752119983},
{-0.33815061696302756,-0.4070009813367223,0.3465579287812237},
{-0.34704522745074573,-0.39686990033277425,0.374326388330139},
{-0.3523686525153372,-0.38781574526231677,0.3943034331656052},
{-0.36104595227828973,-0.38444055210677935,0.39698543261682684},
{-0.3671560971819063,-0.37903804244298517,0.40097198410880935},
{-0.3719025485184016,-0.37164122549494927,0.4040047065651908},
{-0.3754723585571943,-0.36159060447453784,0.40593230770923544},
{-0.36116836148401216,-0.35730559458208594,0.42744469407670105},
{-0.34535625548864307,-0.356448042449862,0.4464346255756843},
{-0.32742399454247495,-0.358575762014498,0.4646694710753236},
{-0.3067567818482277,-0.36324519182829146,0.48391522406042337},
{-0.2760980896599293,-0.38307066931015527,0.4813913938076071},
{-0.2458733312289953,-0.4000030258455347,0.46300319295473125},
{-0.2146087822415876,-0.41117045894512144,0.46414201118324994},
{-0.18135473981510705,-0.4222594951376725,0.46391644815248056},
{-0.18238490268124297,-0.42507972071445715,0.438603874870284},
{-0.18343294554372036,-0.4270114480115037,0.4143634136764091},
{-0.18486953448054141,-0.4280904370214952,0.39034438936030186},
{-0.18608812500042982,-0.4284934246313454,0.3661502098492647},
{-0.18648286030427627,-0.4283985231123022,0.34138297645548327},
{-0.18544719590080452,-0.4279831570434463,0.3156460764754951},
{-0.21752459702958246,-0.41395286145272214,0.2914352066755654},
{-0.2520047945897882,-0.4004885365154225,0.29169721739118476},
{-0.2810563501838545,-0.3858805795044352,0.28697428512680007},
{-0.31576417385133054,-0.38136106658304325,0.27525917398543054},
{-0.33419707469506005,-0.42134280147908826,0.26229782709905997},
{-0.3454442800860165,-0.43789623963046176,0.26800801023836096},
{-0.3487018778810003,-0.42396841017261755,0.3119272297902745},
{-0.3556571964578352,-0.40990991920304726,0.34687701794670245},
{-0.36079425694517514,-0.39621590508197635,0.37449060921961375},
{-0.3712905024897895,-0.3934224994997039,0.37606783120458226},
{-0.37910199781451426,-0.38827374824552535,0.3781635730834535},
{-0.38479608895710793,-0.38055371597900883,0.37988349119307024},
{-0.3886856758535463,-0.36987316893364386,0.38085953268566486},
{-0.39108365843980525,-0.35584218565075276,0.38072371348268624},
{-0.37805395495203686,-0.3482273702857842,0.4066028075720408},
{-0.36428842084560004,-0.3440015019196927,0.4293076521570496},
{-0.34946246541768017,-0.3426763191139224,0.4499569848549554},
{-0.33340485331869923,-0.3435923250803396,0.47037112683175397},
{-0.3159450368912463,-0.3460913984151447,0.49237315002210924},
{-0.24629076037435207,-0.39452349465903874,0.4875091033250604},
{-0.21368865012216848,-0.4069961674915534,0.490192478160616},
{-0.17996904009864254,-0.4185143235963,0.491151121041386},
{-0.14526190412333345,-0.42873136612112045,0.49098332415264284},
{-0.14660015308027638,-0.4325659376442004,0.46282714375998435},
{-0.14761724979523966,-0.43551888780921216,0.43652085529650186},
{-0.14848167884913338,-0.43766036121718765,0.411391208130722},
{-0.14936330020720165,-0.4390611901613257,0.38676426393900437},
{-0.14994096162746476,-0.4398630392280243,0.3621926789667287},
{-0.14989351086794314,-0.44020688531151425,0.33722993468987483},
{-0.14890117107099113,-0.4402337053060264,0.3114288936614725},
{-0.1823745872987383,-0.42742543869602556,0.2885424295751644},
{-0.21058096921958627,-0.4122858956399629,0.26350369531385925},
{-0.24089925378522958,-0.39672686036204247,0.2650201253112667},
{-0.2667447884968356,-0.3799602376389052,0.2636358009791361},
{-0.28610607376598796,-0.36187187057083264,0.2581872159401542},
{-0.29991905863194646,-0.36897710604006906,0.27491216451797246},
{-0.32513879347160074,-0.36146131834714557,0.25745991270435625},
{-0.33363523019463753,-0.40138528710116433,0.24916049978715923},
{-0.3512092035218091,-0.42538368065226223,0.20778481286864595},
{-0.3541023244682936,-0.44889312507263746,0.21569602355758286},
{-0.3630155026445202,-0.4677544581363955,0.2201680857194532},
{-0.3616064213943784,-0.4502678217144303,0.2696696808214345},
{-0.36564936364405326,-0.4296982613078942,0.31245024031402774},
{-0.3699859504490286,-0.4104690129348019,0.34737944584389796},
{-0.38146834656109213,-0.40822025954877766,0.34846895654404425},
{-0.3903437016681348,-0.40297316831472096,0.34973816120742235},
{-0.3968492695677648,-0.39453724850237837,0.3507798085327468},
{-0.40122367944192405,-0.38272132168932954,0.3511864409110821},
{-0.4037055604725545,-0.3673348971453211,0.3505508758103592},
{-0.40429903881265816,-0.3489797055164603,0.34898293766964505},
{-0.391947399801532,-0.3389270214195479,0.3796060761729105},
{-0.3795256161893739,-0.33193938131086503,0.4061723122755115},
{-0.36677374033706545,-0.32763511603773776,0.4298495535846298},
{-0.3534311369133212,-0.3256332441396593,0.4518061890919644},
{-0.33978113509093694,-0.3251009704024168,0.47367204923325756},
{-0.3261077517348754,-0.3252082503804657,0.49707696444425187},
{-0.12598314191421864,-0.43595282156657655,0.1365062074533452},
{-0.14854494652849556,-0.4216783952565745,0.10784388562578952},
{-0.1211135936798339,-0.4340307219598676,0.10603319215013142},
{-0.09585190961799388,-0.44629571175795435,0.13426433098899074},
{-0.09216381652648062,-0.443946555315551,0.10435247249403252},
{-0.17407826899629267,-0.4070614982474165,0.10963257295210428},
{-0.15455537606789996,-0.4231947564847651,0.13891519311427583},
{-0.13063606711600473,-0.4373680920462211,0.16702529813174666},
{-0.09931306429440376,-0.4480912760059389,0.16421951409046864},
{-0.06684519155321465,-0.4561489651264425,0.1618689822637313},
{-0.06455091294573627,-0.45398754864562463,0.1323958713713063},
{-0.06207508360617519,-0.4512512215132116,0.10295439431856236},
{-0.19542354616718208,-0.4099477422722312,0.2040417044037743},
{-0.21341013479454163,-0.39212895053361474,0.17531061335952064},
{-0.18819177533922132,-0.40912319936402225,0.17288443539441553},
{-0.16629290597391308,-0.4251581176214928,0.20081023891113572},
{-0.16043101794257633,-0.4242909377989312,0.17001813444244324},
{-0.18114636908851214,-0.4082463918511229,0.14127053878618204},
{-0.2053359410620305,-0.391332603004252,0.14335493374429814},
{-0.22670253669009632,-0.372676889898421,0.14494900418735757},
{-0.23557995487363997,-0.3735715774076619,0.17698239301744878},
{-0.2218453669147172,-0.3930532088060357,0.20655934542708776},
{-0.2030500522989893,-0.41097652975403315,0.23431047513339506},
{-0.1722620739832987,-0.4259867866827036,0.23094628505252932},
{-0.1394660345400268,-0.4391911639808849,0.22708970738010598},
{-0.13511569389171188,-0.43840513183402685,0.1973119488577089},
{-0.19733464269921924,-0.3903533293584726,0.1112445233915052},
{-0.2179337738689355,-0.37172787470798874,0.1125277569750897},
{-0.23549605642926846,-0.3513570573377098,0.11332823065745432},
{-0.2448252883665179,-0.3525055032565662,0.14583406400626073},
{-0.25419303106511826,-0.3537151537782839,0.17758618674005716},
{-0.24489818373621777,-0.3747537202427003,0.20791684976470606},
{-0.2309270296718539,-0.39441690237315685,0.2365516639055826},
{-0.17780074669615492,-0.4267515003723853,0.2602499485950105},
{-0.14340307219598675,-0.43974544386747066,0.256164782046283},
{-0.10823036862363225,-0.45088880774121315,0.2521538174823727},
{-0.1055655614765851,-0.45033177708595945,0.22336998044891165},
{-0.10255071901654518,-0.44941095727437336,0.19399520953636482},
{-0.0689452658927379,-0.45777948325435186,0.19119492703242258},
{-0.03464586260323119,-0.463115974470116,0.18924600743120154},
{-0.033613499122160946,-0.461232385624758,0.16024396567315777},
{-0.03247041720220694,-0.4587910784319793,0.1311085116347199},
{-0.031227344841174055,-0.4557727975111045,0.10199368836129144},
{0.0,-0.4650270710021531,0.18848473220235476},
{-0.03555664210917938,-0.46446247573306265,0.21795990617128072},
{-0.036335109642200644,-0.46529114479427347,0.24623031223287453},
{-0.03697033089683999,-0.4656212370344238,0.2739033201090129},
{-0.03745150910607583,-0.4654726955263562,0.3008239927544753},
{-0.03776798504131998,-0.46486477565074585,0.32683780573934124},
{-0.03793110562332762,-0.46373627280473184,0.3523859823579451},
{-0.03795256161893739,-0.46202460700111886,0.3779098146738379},
{-0.03784376871812117,-0.4596678859448787,0.40385066351978727},
{-0.037616348918500915,-0.45660352964881623,0.43064933957482743},
{-0.03728178667926518,-0.45276895812573625,0.45874844151762656},
{-0.03685156645960255,-0.44810365446494455,0.4885874046428849},
{-0.07348884803997417,-0.4438777860988529,0.4893837521722476},
{-0.1096972160158004,-0.43730276129035806,0.4902887550639931},
{-0.07481265546141048,-0.4597015828610607,0.30348144159533574},
{-0.11041585433029442,-0.45111574615631655,0.2801587055982956},
{-0.0738168772036236,-0.4598494366769614,0.2765069914224156},
{-0.07247656517017974,-0.4595984290360137,0.24868606096115983},
{-0.14664278999462912,-0.44008653918229274,0.28434241843455127},
{-0.11199273246917935,-0.4510476646317855,0.30719518560467735},
{-0.07541782456835282,-0.4591865014279928,0.32943680074600845},
{-0.07539856918767737,-0.45462779005308296,0.4057466308241509},
{-0.11287916767241646,-0.44884223585228095,0.3832095831278853},
{-0.07566057990329672,-0.45673006500754054,0.3801136617613584},
{-0.07568396143697403,-0.45822304470205394,0.35482894001192455},
{-0.11307997378517459,-0.4500188771499836,0.35825839207943666},
{-0.11237440162185319,-0.44707899313614446,0.4083894318218547},
{-0.07494813081830554,-0.4518336967786436,0.4321835807993596},
{-0.434635203374643,-0.5144102455129805,0.17835365119840674},
{-0.452743513515558,-0.5251609371593775,0.13108719317754353},
{-0.4444100598360954,-0.5428683227669432,0.1295275073428331},
{-0.42458045620122975,-0.5238068712825941,0.17697620378794596},
{-0.43463176491380806,-0.5538315112929368,0.12749400160507351},
{-0.4528494181092729,-0.5649322382523266,0.08286140458374336},
{-0.46087959954309726,-0.5452092269033428,0.08547188404959907},
{-0.4673418428362075,-0.5190734860972713,0.0865295546024142},
{-0.4592360152640153,-0.5011260959234296,0.1315376315469154},
{-0.44299822781728565,-0.49889591022591373,0.1792710325491579},
{-0.42393402556426857,-0.4828761211961167,0.22706357507776076},
{-0.4138332030156676,-0.49080383649706116,0.22602997375078993},
{-0.40205097311880084,-0.4932602729175134,0.224863647835592},
{-0.41319777545337827,-0.526887732190664,0.1755203594704495},
{-0.4238033640525424,-0.5576365120528367,0.12562347891088815},
{-0.4435820784670516,-0.5774496110756949,0.07980117444068274},
{-0.4600468043288846,-0.578509344705011,0.03976511186344633},
{-0.4674023597469018,-0.5577135335755384,0.04420966633863749},
{-0.47346230312232873,-0.5308777221434815,0.04636489358995251},
{-0.4781619913914694,-0.4991386655608577,0.04398135253920016},
{-0.47190674344062017,-0.487317237210473,0.08493204569851986},
{-0.4634942051619549,-0.4711777897436214,0.1302447702729931},
{-0.4493036772963245,-0.477459169996816,0.17934599099535872},
{-0.4320900546646503,-0.4695575869982168,0.22767768418287385},
{-0.41271295247565737,-0.451579938369028,0.27338191190800876},
{-0.40279574373564014,-0.45825192777306706,0.27244053010062996},
{-0.3908257738771878,-0.46029024735599555,0.27143471153720516},
{-0.3888493465892875,-0.4901642827817698,0.22385342804229855},
{-0.40085232567175494,-0.5234575236617682,0.17436847509075817},
{-0.41232028024831185,-0.5538672712856199,0.12454930374606553},
{-0.42265216736501804,-0.5777013064088096,0.07673888122112121},
{-0.4334062974722499,-0.5819698116892539,0.07739218877975214},
{-0.4514595922398065,-0.5921256496112133,0.0352813589347373},
{-0.46609436924530595,-0.5815063071687094,0.0016490858164177947},
{-0.47230835566613644,-0.5613466112936933,0.009084413525804616},
{-0.47744060230830754,-0.5361124349185326,0.01308678193762769},
{-0.48199725060671644,-0.5070670685539691,0.009113296596817764},
{-0.4854721591264659,-0.4732002924067094,0.0014806012355077199},
{-0.4813157476692393,-0.46303276371791136,0.039060227392291924},
{-0.4746004336586805,-0.45111574615631655,0.08151902947379856},
{-0.4656597477957747,-0.43661163066254327,0.1275723985121092},
{-0.45318707496326005,-0.45029739247761047,0.17819685738433533},
{-0.4380399672933605,-0.45093006927123197,0.22758484574033155},
{-0.42046530627402195,-0.4402894083715518,0.27396198025085633},
{-0.40138047325599546,-0.4238404994295593,0.3150321186626588},
{-0.3918724413553312,-0.4295806659473407,0.3139921273000724},
{-0.37998293148041556,-0.43151445632088814,0.31301310259885745},
{-0.37691444903135113,-0.45768045558230674,0.27066153923386965},
{-0.37543522318017736,-0.4816258968365472,0.22246566524933312},
{-0.3887599466075801,-0.5137686287211882,0.17299584152546627},
{-0.40114803330355625,-0.5429494704426467,0.1236566793133256},
{-0.4121648618185744,-0.5654204996908824,0.07684547350700308},
{-0.42169421217641506,-0.5791702168774787,0.03384476999791626},
{-0.43172351473965,-0.5924701833868702,0.03224244724885307},
{-0.4419240526524631,-0.5972255747215363,0.032269954935532294},
{-0.4582931893030858,-0.5953268566485047,-0.0046776821197973715},
{-0.47131120202401555,-0.5714398692284576,-0.0303595460956621},
{-0.47649846403954504,-0.5532201529564917,-0.019243689908598857},
{-0.4791880281046035,-0.535786468831384,-0.008792832047005148},
{-0.48302947654935324,-0.515903225207494,-0.019107526859536813},
{-0.48670587887402783,-0.483550747211924,-0.030224758430934053},
{-0.48892643688120596,-0.443295310833421,-0.038963950488914795},
{-0.48735987412482573,-0.43350326206779405,-0.005493972722002521},
{-0.4827385827627207,-0.4230971041970541,0.033602702355139354},
{-0.4754497334849007,-0.4116470296168385,0.07712949037196577},
{-0.4658770585205403,-0.3987218553384511,0.12388774388143084},
{-0.45482859616584104,-0.41868280817721,0.17593710092363932},
{-0.44152037735044586,-0.4270733403065319,0.22649622904000236},
{-0.4259413989996829,-0.42439271623964425,0.273883720882254},
{-0.40856960716960344,-0.41423481524118394,0.31577787955621844},
{-0.3781378533964085,-0.4980754934707067,0.17087706195900115},
{-0.3912493922520474,-0.5253087909752782,0.12232874573888737},
{-0.4027895545061373,-0.5459037959919925,0.07671687507177784},
{-0.4126730663299725,-0.5586377918479595,0.035722857305938424},
{-0.4208125908183468,-0.5622901249467899,0.0010260367131340218},
{-0.42961917670869154,-0.5821878101061866,-0.004060822246016405},
{-0.43941260085865236,-0.5956830811910003,-0.007633383053477005},
{-0.4492754819174783,-0.6007410570791375,-0.008302507531948458},
{-0.4641110650357359,-0.5845170234757474,-0.03869024900645678},
{-0.4689421025087698,-0.5571633798419546,-0.06536995431660934},
{-0.4760157041383251,-0.5458267744692907,-0.05513090564244551},
{-0.48087356160587125,-0.530447914539119,-0.04011583486860613},
{-0.48465243006342584,-0.49601448004626786,-0.05506144873358052},
{-0.4870538511105197,-0.4529051211747983,-0.06560789580638444},
{-0.487659707909629,-0.4045156618452569,-0.07126829003279608},
{-0.489267532196028,-0.3982617892787416,-0.044252990945157285},
{-0.48735162181882197,-0.39019034631489835,-0.01048249170127478},
{-0.48229570900718566,-0.38067474980039734,0.02886244024814681},
{-0.474480775221626,-0.3700877288897417,0.07260172514457007},
{-0.4642891773069837,-0.3588033881217682,0.11955459553729043},
{-0.4544077285596494,-0.3838910860653623,0.1726801908208225},
{-0.4426915171108126,-0.3991420352524759,0.22443590330773056},
{-0.4290277614450888,-0.40390567889314566,0.2728501883244999},
{-0.4135037984676843,-0.4007044718558543,0.315874211474969},
{-0.4357011262334618,-0.572076672175081,-0.0359229757265296},
{-0.4455956411319688,-0.5848512418688997,-0.041583369952941235},
{-0.4501502263538767,-0.5574831566996002,-0.0683002106401108},
{-0.4601533966147665,-0.5619015788724462,-0.0700283810557313},
{-0.455379437591592,-0.5898542023836786,-0.04288242045636631},
{-0.4266380311648336,-0.554100398930226,-0.027033179083980285},
{-0.439701431568784,-0.5464408835744038,-0.06079405063752506},
{-0.4532874780196391,-0.5171596387965661,-0.08799708968674935},
{-0.46362555436584807,-0.5205857211724602,-0.09000240004566279},
{-0.4055472000957267,-0.5319862819166531,0.03575930499078834},
{-0.4141172198806304,-0.5372333731507097,0.0031847024252839628},
{-0.395372106793092,-0.5199275997686603,0.07536005842632648},
{-0.38359056458839214,-0.5013716020270415,0.11994864314896991},
{-0.3907570046604898,-0.48826969086174016,0.0717792453128621},
{-0.40120648713774953,-0.5003283730097329,0.03183602117816797},
{-0.41066019135722237,-0.5082609021558462,-0.0020286918925907413},
{-0.4201599709518829,-0.5368111301601841,-0.01801409631403877},
{-0.4295779151786728,-0.5313082174400108,-0.04811644553925035},
{-0.44218812644458333,-0.5085813667056588,-0.07909835304602934},
{-0.45522126839318655,-0.46745943819676106,-0.10088512858811985},
{-0.46582479391584986,-0.46960985160290725,-0.10306580044961318},
{-0.4726246940629472,-0.5168508650135922,-0.08498774876404523},
{-0.4797966356723806,-0.5079844499047202,-0.07324334193636237},
{-0.4822441320946622,-0.46122963485609014,-0.08527451639767586},
{-0.48303704116319,-0.4089822224697913,-0.09129801208825293},
{-0.4818555860203185,-0.3546614182000483,-0.09138603668562638},
{-0.48605188362323,-0.35424055059385656,-0.0715536822820927},
{-0.4873048587514674,-0.3515729926781415,-0.04502389386434172},
{-0.4851406915019816,-0.3454779770021985,-0.012157022127870875},
{-0.47984958796923816,-0.3371080756378861,0.026093791583885705},
{-0.4717196911712016,-0.32761517296489534,0.0687767813118278},
{-0.4610398318180036,-0.3181504656707509,0.11493949340468823},
{-0.4521046474924336,-0.3471944566509804,0.16853959628343643},
{-0.4417136188493672,-0.36829078925742315,0.22142656238502642},
{-0.42983373666478925,-0.37980275613266684,0.27089397918630886},
{-0.4162449394452662,-0.3831930785158777,0.3149659145377436},
{-0.4446239321000262,-0.40950486851669615,-0.09725961548380173},
{-0.43188030855372145,-0.4537131594709996,-0.07418616789729184},
{-0.44372718151428436,-0.46179904397034943,-0.09126087671123602},
{-0.4561627189697821,-0.4119633680136493,-0.1071761365316521},
{-0.43090172260010906,-0.49686240448815416,-0.06343135009789297},
{-0.41983606794123535,-0.4845974146900674,-0.040643294760679696},
{-0.4202198001704101,-0.44428627524603903,-0.0496506867637826},
{-0.43273373453294356,-0.4052508047717584,-0.07979498521117995},
{-0.44518371352394787,-0.35510979349291916,-0.09706981244571532},
{-0.4563236389368554,-0.35425017828419425,-0.10708192270477582},
{-0.46651867531233254,-0.3534854645945126,-0.10951153913071585},
{-0.46677999833578493,-0.41267581709864043,-0.1094812806753687},
{-0.4749999828076958,-0.4671657936414607,-0.0978118322938866},
{-0.4759077364681093,-0.41169172960769224,-0.10411246792775654},
{-0.47518703507711435,-0.35401636294742106,-0.10415854330294422},
{-0.4790766219735527,-0.3018404705464883,-0.08581435474875511},
{-0.48279153505957817,-0.30589235279433397,-0.06710706473040062},
{-0.483721294869335,-0.3070332340993536,-0.042350834411290825},
{-0.4814051476509467,-0.30236242890122605,-0.011865440649071407},
{-0.47602533182866286,-0.29446290897912786,0.0238856120357132},
{-0.4677640858267332,-0.28591764611223547,0.06443675604601758},
{-0.4567706388453924,-0.2783413415086178,0.1089717007796366},
{-0.4480988406197757,-0.3098672135194779,0.16362947421119986},
{-0.43874622714884887,-0.33567354977756597,0.21749158780556738},
{-0.42846729232900016,-0.353060470835319,0.2680477588456124},
{-0.41684116855403786,-0.36247772736994194,0.3131348860047079},
{-0.47023565147485896,-0.21468992991729124,-0.05826746961604083},
{-0.4696662423605996,-0.24662154030666944,-0.08629986541864292},
{-0.47507837971473155,-0.25409194031657223,-0.07485941852876514},
{-0.4735427631058654,-0.22903037467532333,-0.04447717859159269},
{-0.47843775595042837,-0.2632829461282587,-0.058571429553845984},
{-0.47303937243963606,-0.297778960608305,-0.09815361530087567},
{-0.46506695714783797,-0.295792905630067,-0.10340827114876917},
{-0.46244891306814545,-0.243350876360513,-0.09142592283131122},
{-0.46526776326059616,-0.20418501945137293,-0.06879878746117121},
{-0.4649239171771061,-0.1869101922168376,-0.03578750036963456},
{-0.4686573979516401,-0.20575282005365372,-0.023354025990637788},
{-0.4722794725951233,-0.23120692038381477,-0.013446444940958218},
{-0.475130644319422,-0.2424300565489269,-0.03200656883557901},
{-0.47920040656360907,-0.2684488896866118,-0.03731211390382904},
{-0.45554723448033513,-0.2979660128777235,-0.10086105936227556},
{-0.44416730450115155,-0.25435120026352365,-0.0796368160127746},
{-0.43342348977642436,-0.22927037924159932,-0.05067053424741374},
{-0.43473285566235415,-0.2636439845159232,-0.06532800509442359},
{-0.44512457199758754,-0.3021973827811509,-0.09106969828881561},
{-0.4344426495678886,-0.3063854280780586,-0.07459190627580997},
{-0.4240426809266514,-0.30760814475094883,-0.0515906663668329},
{-0.4257797913404427,-0.2688621926789667,-0.045571296829257736},
{-0.4271895602827515,-0.24272576418072822,-0.03941095039745168},
{-0.4224307304872505,-0.23144279879708887,-0.02114103259729644},
{-0.42938673675625233,-0.20589324679415105,-0.029409155520895867},
{-0.4418174603665812,-0.21485497603736645,-0.06265288256487177},
{-0.4536773994783167,-0.24675701566356448,-0.08877074337460178},
{-0.43368206203120885,-0.3548642873893073,-0.07967188831329058},
{-0.4224025351084043,-0.35231363714197883,-0.05508758103592575},
{-0.41192829571313333,-0.3462585076117208,-0.023514258265544097},
{-0.4144651921171222,-0.3029428410901571,-0.0222310246819596},
{-0.4177110991452674,-0.264231961318691,-0.020094365119153},
{-0.41007152686228754,-0.2551296677965449,0.011086285423883133},
{-0.41609364716853064,-0.21993151961401214,0.006890675513138684},
{-0.4237916732857038,-0.1910719676729666,-0.002206116471671583},
{-0.4375840273866528,-0.1869917525078414,-0.04000030258455346},
{-0.4505573401167289,-0.2042688491265278,-0.0710688593043719},
{-0.27164046903356553,0.013022826566098551,0.1858102973649699},
{-0.2617363264447209,0.04328953421921836,0.21295350719566694},
{-0.2565263705876811,0.04176767145369185,0.18454631916206082},
{-0.26509982883341965,0.012210662116895286,0.1572545678232961},
{-0.2505661425764662,0.03989302260650461,0.15608549113943024},
{-0.26613618092905833,0.04451981550594545,0.24123209679404783},
{-0.2774191463126977,0.013557851072008922,0.21420992078473924},
{-0.28443016795505793,-0.017840110195792833,0.18772345697350803},
{-0.27732011864065265,-0.017535462565820732,0.1589799874702487},
{-0.26948455409008354,-0.017561594868165976,0.13009141491975662},
{-0.2578226703224382,0.011044336201697355,0.1286465736769318},
{-0.24391615932177046,0.03760713384346339,0.1276446061896421},
{-0.30854821994321036,-0.05365649363644054,0.24648352048875652},
{-0.30112595838499623,-0.019443808329189984,0.2719187092843256},
{-0.2964193931941857,-0.018980991500812516,0.24425794232875947},
{-0.30218087816914335,-0.05198127551767748,0.21851968759520235},
{-0.29082501741580413,-0.01838476239204093,0.21617121884496596},
{-0.2823849714504597,0.013918201767506412,0.2423709150225666},
{-0.2864877429186618,0.014204281708970054,0.27021123840293115},
{-0.28967725918911463,0.014517869337112882,0.29764761140441176},
{-0.30485875146736313,-0.01958547291558785,0.2990878451097178},
{-0.3139651711425111,-0.05494385337302693,0.27394465040824845},
{-0.3190795377883407,-0.08958483336187256,0.24863689097122077},
{-0.3117122916034849,-0.08667630811084774,0.22093555017780278},
{-0.30364635017697755,-0.08362666842715862,0.19257856367238615},
{-0.29504744732106075,-0.05024760356472111,0.19005679649607085},
{-0.26966679251433323,0.04551696914806629,0.2693087799722034},
{-0.27226695659768424,0.046342199748442205,0.2971088733607997},
{-0.27387684396058426,0.04705327344909942,0.3245583125134529},
{-0.29190263104146164,0.014960055400480968,0.3245977860438376},
{-0.3075311232282471,-0.019220308374921516,0.3257005004335899},
{-0.318248805650629,-0.05551601325595421,0.3008992950467596},
{-0.3253898011125484,-0.09181281844445408,0.27580238202812796},
{-0.3278359221504959,-0.12584677255750654,0.2501238877438814},
{-0.31916893777004807,-0.12152971621007345,0.22313135126696965},
{-0.3101416026941028,-0.11721217847812349,0.19507488623852326},
{-0.3010544383996303,-0.11347257724330342,0.16586722452255248},
{-0.2952400011278151,-0.08097520250815086,0.1634465480947832},
{-0.28733154120754617,-0.04878350694122088,0.1610987670367138},
{-0.27897401830223933,-0.047683199474053035,0.1318649730183978},
{-0.2699171124631139,-0.04703814422142588,0.10257685131889041},
{-0.26091315892084593,-0.01801203323753781,0.10121109467526831},
{-0.2498365011873005,0.009446827297803028,0.10009153182742501},
{-0.23663625004212116,0.0348501759460409,0.0992979350667302},
{-0.27690062641879487,-0.07714331298452211,0.10411040485125561},
{-0.2819145900082454,-0.1078387967037539,0.10573267067316122},
{-0.285010580143989,-0.1386366090174323,0.10736318880107057},
{-0.286241549122883,-0.1690484197177849,0.10892356232794799},
{-0.28565769847311706,-0.1985858985970392,0.11033401896242381},
{-0.2831063605336216,-0.22713990890829555,0.11155329717447916},
{-0.2784355553354941,-0.2546028955966383,0.11254013543409536},
{-0.2714919275254979,-0.2808644840692671,0.11325258451908653},
{-0.2621221217503966,-0.30581670665596616,0.11364938289943394},
{-0.2501748457334546,-0.3293502203021857,0.1136885813529518},
{-0.2964599670320375,-0.1725634206908693,0.13997355135925793},
{-0.3047851684054963,-0.14563912390768693,0.16820262712161627},
{-0.29505913808789946,-0.1417787020360502,0.13801981791286802},
{-0.2917114526190412,-0.11033876403837597,0.1359422998764217},
{-0.31444655565939705,-0.15023969510480084,0.1973291411618834},
{-0.3064418188357509,-0.17683804643159973,0.17029458669356914},
{-0.29596414097964496,-0.202145668330194,0.14168934331587282},
{-0.3383397323089471,-0.19497372672076055,0.24899428459040018},
{-0.34575924309849326,-0.1677975764352651,0.2735996352480746},
{-0.3346385730662612,-0.16152286679609032,0.2503500696976011},
{-0.32685252235171464,-0.18795486538769676,0.22571088458531127},
{-0.32429912133571825,-0.15560224985369348,0.22481894784473835},
{-0.33584134666630905,-0.1295853422540761,0.27613852595934774},
{-0.3419439269560888,-0.13138180050187775,0.302251779231559},
{-0.3541992890638378,-0.17108103145572742,0.298206361290083},
{-0.35170984341937045,-0.20310568659529796,0.2679254871783234},
{-0.3377930170361981,-0.22455968789778694,0.2457353114110824},
{-0.3265774454849227,-0.21764838161963884,0.2255190184707239},
{-0.31614584300400445,-0.21156161824969966,0.20025389594804896},
{-0.3164766229363218,-0.18194450461750905,0.1991274561785359},
{-0.27501497449693596,0.04678163504314237,0.4072801843565161},
{-0.29420846287734526,0.014341820142366022,0.4334943220696233},
{-0.27491250836405595,0.0453120368823063,0.4358035923663418},
{-0.2745102084463727,0.042977321975409516,0.4653337817086262},
{-0.2936115460764067,0.012767692772149015,0.46257957457987164},
{-0.31032521650268646,-0.01759047793917914,0.4327688068334595},
{-0.31054046415095116,-0.01753271179715283,0.40529069091744324},
{-0.2943164305475611,0.015220690731766347,0.4055100647187098},
{-0.2750266652637746,0.04744594567644494,0.379396261292765},
{-0.32246779709505075,-0.04970501444497397,0.4614235640471784},
{-0.3080028800547953,-0.01957240676441524,0.49153760403922864},
{-0.3095068628239804,-0.01823347011530535,0.4613699240581539},
{-0.3235770445603893,-0.0501080020548242,0.4333107082610396},
{-0.29239158017218436,0.01040753325507397,0.4931605575533013},
{-0.32066398054106243,-0.04996633746842633,0.4911139856643691},
{-0.3327659872955749,-0.08132902012806204,0.46245785306631615},
{-0.3342802854472647,-0.08283382812784747,0.43480506333988694},
{-0.3240467383104366,-0.051059768013924395,0.40626102456505186},
{-0.32393189371855097,-0.05244615542255589,0.37976005044909733},
{-0.310236504213146,-0.017948077866008688,0.3784927713237867},
{-0.29406954905961535,0.015494392214224358,0.3782309669158175},
{-0.27472201763380255,0.04747895490046001,0.35190494168714265},
{-0.32304958466831574,-0.0538971858948835,0.3535424055059386},
{-0.30927854902454305,-0.01859244542646886,0.35206572411578263},
{-0.32121619735114726,-0.05504425642940599,0.32734367209737164},
{-0.29331583844460535,0.015346538398323683,0.3513595330295109},
{-0.3355587051856803,-0.08756184931426775,0.38161138653182397},
{-0.3350649422097888,-0.090127353712403,0.3553084677599596},
{-0.3334089794717011,-0.09206974023803777,0.32900444868062817},
{-0.33028616934144533,-0.09282090639202992,0.3025516817855789},
{-0.3449044417349373,-0.12987259127222364,0.32954029841713894},
{-0.3564954932093837,-0.1680280908496368,0.3278084832330334},
{-0.3678121555092051,-0.2032170927263487,0.3270137173956547},
{-0.37189635928889875,-0.21481371450734765,0.28012624652801416},
{-0.362234972034998,-0.23802538821942057,0.25490087261259065},
{-0.3502574375627089,-0.23216625095675172,0.258855583957242},
{-0.3341014854838499,-0.2512999101186338,0.24236541348523077},
{-0.32369670299744385,-0.24501715448110528,0.22496955242930697},
{-0.31347553431962144,-0.23927836334765798,0.2010364896340721},
{-0.3034668625213958,-0.23448789971247588,0.17337269683297124},
{-0.3060340173807318,-0.20643267252993008,0.17198699711650675},
{-0.34572279541364337,-0.12644190135881095,0.3570844327811853},
{-0.3554185672758931,-0.16200067531370796,0.35859082247295476},
{-0.36425885008241987,-0.19523945097408157,0.36063498743930256},
{-0.3723488607347716,-0.22459407250613594,0.3640242095150463},
{-0.3784865133250672,-0.23212086327373105,0.33036050886469587},
{-0.38813208365912744,-0.23792223439437357,0.2908784510971784},
{-0.40395381734483427,-0.23957063251862443,0.24423112233424724},
{-0.3979633308782723,-0.21669730335270562,0.22538423080599582},
{-0.38295169856526784,-0.2167254987315518,0.2184062183876507},
{-0.3719878223471071,-0.2396985432616827,0.22389262649581637},
{-0.35479826894127725,-0.26329601227943134,0.24433290077496028},
{-0.3446616863999934,-0.2577202041895582,0.25041643199171465},
{-0.32837025896423927,-0.276212246559648,0.2406757538309611},
{-0.3184331071513796,-0.27039780928783286,0.22478731400505725},
{-0.3084863276481822,-0.2652793164890014,0.20180051563158677},
{-0.29864545273869963,-0.2610672019662494,0.17454727505417295},
{-0.2886993609276692,-0.25757166268149057,0.14435208738641903},
{-0.29342586919132213,-0.23049240822232264,0.14315412763154003},
{-0.3608630261618731,-0.18840035237346633,0.3898492510000763},
{-0.3537412860806291,-0.15636077431387232,0.38673813163665915},
{-0.34540095547949673,-0.12247405509377027,0.3839646691272292},
{-0.3516190680533291,-0.15132157242189365,0.4133834523384628},
{-0.35749264685150456,-0.1825967118686728,0.41652345477289304},
{-0.3622074643483188,-0.2117796166666323,0.41972878796318647},
{-0.3670501925881914,-0.21777079082536124,0.3932168795417769},
{-0.3427265206421119,-0.11531449194334242,0.4370036151977218},
{-0.3351956037215149,-0.0849413295427741,0.40806071496603835},
{-0.34428689416898933,-0.11856590050882342,0.41049858369798203},
{-0.34920733162373063,-0.14709628171722233,0.4396601700387652},
{-0.34066825798634104,-0.11276576723408148,0.464210092707781},
{-0.3464400583438034,-0.14367682869381812,0.46641483379511856},
{-0.35034821292875024,-0.1737234886073477,0.4688073148440417},
{-0.3540136121787532,-0.17772537563465388,0.44252509560640346},
{-0.3574369437859792,-0.2067480481577071,0.44535288579702487},
{-0.3594532572195643,-0.23411585825013975,0.44794067142137023},
{-0.36570781747824654,-0.2389207634208284,0.4228027719495866},
{-0.3721679976948558,-0.24470081608429456,0.39661751730749256},
{-0.346420802963128,-0.17052805818425887,0.49632187844490794},
{-0.34325329284201855,-0.14105519073486097,0.49449330497290833},
{-0.3380584662126523,-0.11096552667936146,0.49284628223299143},
{-0.34779206114408595,-0.19912656217871882,0.49807755654720764},
{-0.352376904821341,-0.2562739875623995,0.47464582134170114},
{-0.3406483149134986,-0.2786143552989088,0.5005223022008213},
{-0.34495395557095987,-0.25327564971436706,0.5004163976071063},
{-0.3533438000081148,-0.23011486522265065,0.47314321395685},
{-0.34731892893320376,-0.2267444859122821,0.49952239779003244},
{-0.3343538685091315,-0.30265401038002554,0.4996007946970681},
{-0.34973066536280234,-0.2809531963588075,0.4754112227235498},
{-0.36003779556149723,-0.25978121761399703,0.4500883340588485},
{-0.3526588586098028,-0.20256694855168592,0.47112346206243005},
{-0.38774353758478386,-0.25749945500395766,0.3354252929052862},
{-0.39845021693249405,-0.263101395396176,0.2976896293958143},
{-0.4125437802025803,-0.26684175309237973,0.2534492232173127},
{-0.42810075240399986,-0.26987378785659416,0.20550855179594243},
{-0.421970664427541,-0.23923503874113822,0.1946560817088325},
{-0.4172984838450794,-0.21226994118168896,0.17725128065473794},
{-0.39865583689042106,-0.20117237760626736,0.19013175494227166},
{-0.39013326786503905,-0.21229263502319928,0.16923278998775218},
{-0.38022912527619435,-0.23937120179020024,0.179028964906381},
{-0.37239356072562524,-0.27011035396203525,0.18204999659592377},
{-0.36393288399527146,-0.26704324689730485,0.21932359973840188},
{-0.34774804884539917,-0.28908171777251,0.23983126784990977},
{-0.3381801877262077,-0.28251081911701703,0.24663467522705873},
{-0.32088197895799503,-0.2995752125484565,0.241399205990624},
{-0.31100947020883146,-0.2941252521251407,0.22569919381847264},
{-0.30119885375469607,-0.2897515299431485,0.20287400310424242},
{-0.2914762618979341,-0.2862367352777142,0.17560357022265405},
{-0.28164020083362046,-0.2833504912528995,0.14526946873717023},
{-0.384896492013487,-0.275527992853503,0.3716639193364596},
{-0.3786604994433132,-0.2921453863764055,0.4026300099233979},
{-0.37608234150930553,-0.26941647256555257,0.3998297274194557},
{-0.3793433777651243,-0.2510337732500125,0.3679650294779247},
{-0.3679393785600964,-0.2640703536594507,0.4255487267723374},
{-0.36884644452834286,-0.2872792766028557,0.4277699724716825},
{-0.3683753753939616,-0.30859773377923294,0.4292705167800327},
{-0.37976837152431775,-0.31311587131629093,0.40479624024938465},
{-0.3888974850409761,-0.29830504511604455,0.37494606774180456},
{-0.39481026229266936,-0.28211608381317055,0.33978457355177183},
{-0.4153426873221886,-0.33933619825890093,0.3104630162591059},
{-0.40301099138390484,-0.3282567897566876,0.34659265723565624},
{-0.4117962588170732,-0.31454764640794314,0.30703220256110314},
{-0.39984623203146324,-0.30576856820427756,0.3434898589474596},
{-0.39123288764003994,-0.3195932438370747,0.3776368696527635},
{-0.3568152700670293,-0.3058091420421294,0.45226006592217105},
{-0.35916648958593367,-0.2836950250285564,0.45159506759670154},
{-0.34537757394581947,-0.30405827778499855,0.47521935660896236},
{-0.40625208456688117,-0.2888891639657557,0.30292434217086533},
{-0.3307909353920086,-0.3063180342456945,0.24729465339970932},
{-0.3407108949006938,-0.31457034024945346,0.24070463690197427},
{-0.32247123555588564,-0.3289224757743242,0.2521809813229684},
{-0.3119220377144138,-0.3216666357205191,0.24526678673771898},
{-0.30164860443190095,-0.31653507677051507,0.2284307071057168},
{-0.29163443109633946,-0.3128806805951838,0.2045829181391875},
{-0.2818630130957219,-0.3100597673262322,0.17663579616529093},
{-0.27210259816977606,-0.3077965724047013,0.14589114245612006},
{-0.2598946868215487,-0.3308631430695415,0.14611395471822153},
{-0.2896545653476043,-0.33769742782498785,0.23193174792781154},
{-0.2793549997627462,-0.33472178381846573,0.20636747931250038},
{-0.2743334715594589,-0.35768451296609194,0.23515221034577846},
{-0.26392181215138305,-0.3553277919098518,0.20766584212375844},
{-0.2695278786966033,-0.3325486765708092,0.17738400524296505},
{-0.300619816950099,-0.34244594223798414,0.2512168369048626},
{-0.254989378594481,-0.3765671644870263,0.23704198842063928},
{-0.4382015749526008,-0.23908237108006866,0.14639109466151445},
{-0.45212183979660814,-0.24095220608208703,0.10057910557381378},
{-0.46320812522049126,-0.24668480798603157,0.058364434211585},
{-0.4477357391556103,-0.20756200060654448,0.08869234646756603},
{-0.43392069121315086,-0.20850393256765687,0.13150806078373523},
{-0.4431962831613759,-0.2733500717606776,0.1566720925578641},
{-0.43395094966849795,-0.3024435765769297,0.21265298571869673},
{-0.4250370838001044,-0.32465328280171285,0.2643441239111254},
{-0.41965039105615076,-0.29555840260112687,0.2598158085299961},
{-0.4768237424345265,-0.2638413521678464,-0.010956311604323934},
{-0.4714459896887437,-0.2548050770937304,0.02082606958481959},
{-0.37740133508557294,-0.43713702747811595,0.11093368653203028},
{-0.3661644450771212,-0.4496880972176663,0.16230085294459468},
{-0.3791356947306963,-0.47156289735713025,0.11590088705412616},
{-0.3885653297243248,-0.4521025844159327,0.06694133091815843},
{-0.3702005104051263,-0.4766311886277721,0.1674867395757902},
{-0.365318583711736,-0.41841323284775384,0.15625741418117522},
{-0.3779054134439692,-0.39934696751823584,0.1057945629681894},
{-0.38841816360059117,-0.4126001709602727,0.06181183504465528},
{-0.3987803091726444,-0.4241967239720549,0.02008473742881523},
{-0.39912553064046835,-0.4642155942451169,0.02594662546015201},
{-0.4093969008464802,-0.47438105985741386,-0.010382776337062688},
{-0.41986701408874944,-0.5169567696073072,-0.028962843304525938},
{-0.3604971739290398,-0.3357141236154178,0.18588388042683676},
{-0.34446706951673806,-0.3523865325116787,0.22459682327480382},
{-0.3557417825943737,-0.3678554801157248,0.19125338086661586},
{-0.37034905191319395,-0.3475272996597986,0.14536024410321158},
{-0.3669504772239793,-0.383970858356732,0.15029718616996035},
{-0.3524009740471853,-0.39808505239182773,0.19883656239190334},
{-0.33873309222845954,-0.3783056502851515,0.23459380430619078},
{-0.3333140779526579,-0.3389469644923903,0.24626139591882204},
{-0.3506150374895385,-0.32454875359233193,0.2189501828917318},
{-0.36593200512468205,-0.30267876729803683,0.18357529782228518},
{-0.3748025463865559,-0.3102481949799847,0.14238597548102347},
{-0.38369578148994005,-0.31869305479049803,0.09799750917897117},
{-0.3801644822124982,-0.3594477556822284,0.10123310082461166},
{-0.40928343163892855,-0.43460288184279494,-0.017648244081205473},
{-0.4210615353827935,-0.39915028755847953,-0.05484551339314881},
{-0.39987030125730755,-0.38162720345166457,0.015522587593070524},
{-0.4101760560716685,-0.3911538030408372,-0.022475843093404425},
{-0.38993521252094876,-0.3709363410237948,0.05735627749479243},
{-0.39273893348572586,-0.3282849851355338,0.05454224114751065},
{-0.4020949854174876,-0.33786109856072905,0.01353378184616462},
{-0.4093638916224652,-0.211686090531923,0.04123608540861636},
{-0.4024030715082945,-0.24693168947397737,0.047952774803509124},
{-0.39687815263877796,-0.2863742737111101,0.051898064765472866},
{-0.3885756451068295,-0.27871200758662,0.09451090989238305},
{-0.3948790315093674,-0.24113375681416976,0.0891964248259623},
{-0.4026822745280884,-0.20758827044732314,0.08047786353299097},
{-0.41206033260919345,-0.17970482876808885,0.0667783478745842},
{-0.4178101268173125,-0.18236578483900096,0.030276335343457503},
{-0.38051107906465614,-0.273645091700312,0.1391703269082254},
{-0.38767408067591885,-0.23923160028030332,0.13350924498964675},
{-0.39649098194876825,-0.20851885548768034,0.12320005171445093},
{-0.4071625889959625,-0.18301936747449868,0.1060380059953003},
{-0.41855558512631874,-0.16416841856246206,0.08462602268421382},
{-0.4219239013601863,-0.15944514245199393,0.050778501917629594},
{-0.4267920742102371,-0.16070052450281574,0.017893062492650262},
{-0.444253266022024,-0.17974725937479152,0.0722406867569056},
{-0.42975190129691865,-0.16419943347919283,0.0866010745877801},
{-0.44152037735044586,-0.1594969256721675,0.05391781665989288},
{-0.45468143004210737,-0.182371698991637,0.03615610337113574},
{-0.45101671848427144,-0.16073394634213098,0.021669180181536966},
{-0.4393816547111383,-0.1487997364763616,0.036420177163256025},
{-0.42953734134082094,-0.15340115353484088,0.061566328941043455},
{-0.41656127784207697,-0.17466294487665895,0.11824591734352767},
{-0.4311589194705595,-0.18305498992874822,0.11074663426261175},
{-0.45864872615341445,-0.21160631824055334,0.04934328836514252},
{-0.4667868752574547,-0.21977541349210766,0.014837646194758537},
{-0.46272261455060343,-0.19101227599287277,0.0038414484447497656},
{-0.45867348307142575,-0.16938140026503656,-0.008710996679134553},
{-0.4473630100011072,-0.14844612516410055,0.008748132056151428},
{-0.4377944611897487,-0.14650545786888325,0.024219830428865465},
{-0.4311829886964038,-0.14877119725143195,0.03516032511334883},
{-0.4482817667361923,-0.1509295191174984,-0.02473766263060134},
{-0.44602888719716616,-0.17414751959750754,-0.04801329171420338},
{-0.4538170009882136,-0.16923045183438448,-0.050834892675322006},
{-0.46004611663671763,-0.1741103154512739,-0.045853938309886516},
{-0.45869067537560027,-0.19991218171027667,-0.07381687720362362},
{-0.4407446605860925,-0.15574687151640937,-0.021418172540589333},
{-0.4425381617575761,-0.14463336723655715,0.002217807238510196},
{-0.45405906863099055,-0.15574742167014294,-0.019369537575156172},
{-0.019666139206774593,0.15020847388041997,-0.2780318800334769},
{-0.021108917373098442,0.14384732133585576,-0.2844184771882193},
{-0.02357573794527208,0.13759344876934046,-0.2892419500474163},
{-0.023843181429010568,0.1513170336535916,-0.27495927143141063},
{0.06575024808494924,-0.060967349063603966,-0.6002032818045592},
{0.09216381652648062,-0.443946555315551,0.10435247249403252},
{0.2578226703224382,0.011044336201697355,0.1286465736769318},
{0.24391615932177046,0.03760713384346339,0.1276446061896421},
{0.29239158017218436,0.01040753325507397,0.4931605575533013},
{0.27359970401729133,0.039716285719590766,0.49623660461620245},
{0.35916648958593367,-0.2836950250285564,0.45159506759670154},
{0.4172984838450794,-0.21226994118168896,0.17725128065473794},
{-0.19625702907356174,0.12555127123335524,0.48487111617252543},
{-0.22555065231040497,0.09528800204107037,0.5077664514877875},
{-0.22559741537775962,0.09974768574393506,0.47660161786459193},
{-0.16616430753868783,0.03351399006559896,-0.06270721024606314},
{-0.0573269818084791,-0.07766939749226175,-0.24064549537561405},
{-0.12267878105188018,-0.0008871228954040936,-0.15771944772817453},
{-0.029247822938522385,-0.2652311780373128,-0.4786330605258507},
{-0.02803273964868558,-0.14965343753245047,-0.6738688667314473},
{-0.035354941996604175,-0.13027434103617327,-0.6525297787900607},
{-0.0322218164838437,-0.1475438730410229,-0.6371942434664086},
{-0.026895984496667785,-0.16730567022822437,-0.6644268532788131},
{-0.0583882283605625,-0.026921772952929544,-0.7733160309984121},
{-0.026998656937197885,-0.18329602603327466,-0.6600393772534813},
{-0.030806339696548952,-0.16290072682185128,-0.627325860870247},
{-0.04368495721523183,-0.17842551502985615,-0.4469510823930862},
{-0.07083710704409964,-0.4589189891750376,0.2201914672531305},
{-0.11170940329638362,-0.4446211813313583,0.43426041114363895},
{-0.07431064017951516,-0.44827488981452246,0.45990307666598584},
{-0.28636602140510636,-0.07879109218582267,0.1338530910731367},
{-0.330605258506924,-0.08051678690964206,0.4916352563269399},
{-0.3124405576083167,-0.34993766070506327,0.26136352852100103},
{-0.4054853078006986,-0.29499655810070424,0.012570325120225776},
{-0.40279986988864197,-0.1907087974395845,0.14738068368979854},
{-0.4158185703017387,-0.19072131343702356,0.15045122921536383},
{-0.43229842539124524,-0.16939570426210973,-0.012782821999822608},
{-0.4353572801499719,-0.1484206117847056,0.006903053972144335},
{0.024450344843237132,0.3880193021437428,-0.001472348929503991},
{0.024377380704320564,0.3609593030652503,-0.032916385572493406},
{-0.04444870813587972,-0.41830388979320404,-0.062292531869374244},
{-0.2519291484514204,0.07207701602116443,0.4699144992328793},
{-0.08894954333801651,-0.01250980820953156,-0.2141060792675253},
{-0.11083465885998518,-0.4413890281465527,0.46137611328765676},
{0.032662558393661126,-0.3998936827909849,0.7047668757938546},
{0.023843181429010568,0.1513170336535916,-0.27495927143141063},
{0.02151334913649933,0.20667487771114038,-0.2113945090531235},
{-0.03905651385459024,-0.24638634958556233,-0.2599634560382467},
{-0.00925819333640044,-0.39937722597358294,-0.7765963226349063},
{0.0,-0.4150834273752371,-0.768048308999346},
{-0.11283240460506182,-0.45071826008380217,0.33307441723246534},
{-0.27359970401729133,0.039716285719590766,0.49623660461620245},
{-0.25139618702201094,0.06809527837435073,0.5010201913297146},
{-0.3569562469612602,-0.2957138210308643,0.2174345093557081}
};


// texture array: 57kb.
const tgx::fVec2 blub_tex_array[7317] PROGMEM = {
{0.573583,0.418104},
{0.55643,0.390276},
{0.581714,0.398452},
{0.59639,0.425951},
{0.606833,0.40696},
{0.589952,0.378524},
{0.562464,0.369358},
{0.531022,0.382737},
{0.527101,0.404838},
{0.55047,0.410884},
{0.565691,0.437159},
{0.586274,0.444385},
{0.606044,0.452703},
{0.618427,0.434757},
{0.63154,0.415987},
{0.61744,0.387691},
{0.519598,0.445824},
{0.501704,0.422526},
{0.523292,0.425874},
{0.539068,0.449986},
{0.544659,0.43087},
{0.503596,0.40029},
{0.480005,0.421265},
{0.480012,0.442039},
{0.499875,0.443049},
{0.516093,0.464374},
{0.533766,0.467985},
{0.551003,0.4728},
{0.558127,0.455459},
{0.658435,0.456569},
{0.655585,0.425717},
{0.677064,0.437955},
{0.674716,0.47101},
{0.694073,0.454509},
{0.714143,0.437321},
{0.699904,0.415192},
{0.672416,0.406025},
{0.644928,0.396858},
{0.639432,0.444701},
{0.641676,0.473331},
{0.656781,0.486134},
{0.688869,0.487278},
{0.708456,0.473527},
{0.728382,0.45945},
{0.594337,0.469769},
{0.611041,0.478554},
{0.624637,0.462269},
{0.576644,0.462046},
{0.56766,0.47872},
{0.583549,0.485698},
{0.598482,0.493684},
{0.612259,0.502723},
{0.626391,0.488605},
{0.599294,0.515624},
{0.61043,0.524571},
{0.624676,0.512858},
{0.640143,0.500033},
{0.670182,0.50032},
{0.701784,0.504541},
{0.722055,0.493159},
{0.742621,0.481579},
{0.586982,0.507606},
{0.57361,0.500397},
{0.576557,0.520263},
{0.587559,0.527316},
{0.597458,0.535139},
{0.606241,0.543634},
{0.620353,0.534206},
{0.635754,0.523911},
{0.652361,0.512588},
{0.682106,0.515527},
{0.713557,0.522488},
{0.735057,0.513175},
{0.75686,0.503708},
{0.556506,0.52614},
{0.551795,0.508516},
{0.56459,0.513992},
{0.567218,0.531628},
{0.559363,0.49426},
{0.544372,0.488984},
{0.5383,0.503888},
{0.544986,0.521445},
{0.549341,0.537036},
{0.558973,0.541675},
{0.567734,0.546928},
{0.577031,0.537745},
{0.585801,0.544552},
{0.593569,0.551903},
{0.600252,0.559857},
{0.613897,0.552705},
{0.629004,0.544653},
{0.645513,0.535707},
{0.663266,0.525966},
{0.692723,0.531473},
{0.724563,0.54073},
{0.747649,0.533345},
{0.771098,0.525836},
{0.528804,0.48475},
{0.512788,0.481538},
{0.524235,0.500162},
{0.506975,0.51178},
{0.49497,0.495661},
{0.509743,0.4974},
{0.520096,0.51421},
{0.496492,0.479593},
{0.480038,0.478891},
{0.480051,0.495047},
{0.480057,0.509771},
{0.493584,0.510309},
{0.504516,0.524856},
{0.516427,0.526878},
{0.527953,0.529607},
{0.532814,0.517431},
{0.538963,0.533003},
{0.543086,0.546408},
{0.551736,0.550468},
{0.559568,0.554873},
{0.566431,0.559956},
{0.575501,0.552805},
{0.582294,0.559223},
{0.588134,0.566101},
{0.592994,0.573399},
{0.605884,0.56823},
{0.620364,0.562299},
{0.636397,0.555591},
{0.653916,0.548145},
{0.672756,0.540056},
{0.702204,0.547872},
{0.734078,0.559283},
{0.759434,0.553678},
{0.785337,0.547965},
{0.523693,0.540346},
{0.53368,0.543203},
{0.513205,0.538166},
{0.502363,0.536362},
{0.510407,0.54807},
{0.519984,0.549754},
{0.52909,0.552057},
{0.537608,0.554867},
{0.498861,0.555978},
{0.490308,0.54609},
{0.500476,0.546889},
{0.508003,0.556798},
{0.49126,0.535497},
{0.48002,0.545787},
{0.479996,0.555209},
{0.489486,0.555447},
{0.497487,0.564034},
{0.505962,0.564554},
{0.514092,0.565361},
{0.5168,0.557983},
{0.525135,0.559783},
{0.532885,0.56201},
{0.539945,0.564602},
{0.545423,0.558075},
{0.552415,0.561776},
{0.558465,0.566067},
{0.563637,0.570834},
{0.572438,0.565378},
{0.577422,0.571461},
{0.581614,0.577778},
{0.584858,0.584479},
{0.596846,0.581077},
{0.610374,0.577044},
{0.625585,0.572362},
{0.642447,0.567049},
{0.660923,0.561123},
{0.680885,0.554694},
{0.710069,0.56466},
{0.741685,0.578129},
{0.770011,0.574186},
{0.799576,0.570094},
{0.536107,0.576574},
{0.535213,0.570156},
{0.540749,0.572558},
{0.539909,0.579093},
{0.545323,0.575576},
{0.54618,0.567616},
{0.528841,0.568221},
{0.531258,0.574796},
{0.532285,0.579735},
{0.535122,0.581809},
{0.537109,0.584525},
{0.542843,0.582055},
{0.549059,0.579074},
{0.551472,0.57124},
{0.52103,0.58182},
{0.516769,0.577532},
{0.522853,0.577972},
{0.526092,0.581807},
{0.52811,0.578581},
{0.525474,0.57337},
{0.518969,0.572519},
{0.51185,0.571761},
{0.510053,0.577238},
{0.515171,0.581863},
{0.520131,0.585338},
{0.525527,0.584774},
{0.530487,0.583708},
{0.529633,0.581759},
{0.52176,0.566603},
{0.504267,0.571317},
{0.502901,0.577065},
{0.508707,0.581896},
{0.514186,0.585731},
{0.519839,0.588439},
{0.525783,0.587631},
{0.531508,0.586322},
{0.494708,0.58203},
{0.487725,0.576906},
{0.495422,0.576969},
{0.501853,0.581994},
{0.496347,0.57079},
{0.488199,0.570787},
{0.479946,0.570629},
{0.479926,0.576883},
{0.487357,0.582144},
{0.49418,0.586513},
{0.501113,0.586299},
{0.507808,0.586026},
{0.775952,0.595183},
{0.813815,0.592223},
{0.745777,0.597367},
{0.715838,0.581775},
{0.718949,0.599208},
{0.718838,0.616951},
{0.745088,0.617075},
{0.773827,0.616984},
{0.80381,0.616786},
{0.687383,0.569767},
{0.666431,0.574522},
{0.692159,0.585135},
{0.652131,0.603315},
{0.670335,0.588221},
{0.672446,0.602158},
{0.652274,0.615768},
{0.672576,0.616268},
{0.694723,0.600782},
{0.650378,0.590999},
{0.633752,0.604256},
{0.633878,0.615172},
{0.632671,0.626115},
{0.650911,0.628258},
{0.67085,0.630445},
{0.69477,0.616665},
{0.613815,0.586153},
{0.629562,0.582779},
{0.616073,0.5955},
{0.632299,0.593434},
{0.647187,0.578839},
{0.599729,0.589036},
{0.601677,0.597173},
{0.60268,0.605431},
{0.617289,0.60496},
{0.726782,0.677137},
{0.759018,0.661496},
{0.750122,0.683761},
{0.718037,0.696979},
{0.740736,0.705937},
{0.763792,0.715035},
{0.773796,0.690473},
{0.783801,0.66591},
{0.767046,0.639214},
{0.734619,0.657125},
{0.704188,0.670698},
{0.696051,0.688302},
{0.707712,0.716262},
{0.730521,0.727793},
{0.753787,0.739598},
{0.69254,0.63266},
{0.716014,0.634872},
{0.688464,0.648652},
{0.710986,0.652838},
{0.740837,0.637062},
{0.703532,0.768031},
{0.695577,0.734666},
{0.719138,0.749097},
{0.733778,0.788723},
{0.743783,0.764161},
{0.686182,0.70534},
{0.674184,0.721501},
{0.680112,0.751363},
{0.680649,0.782779},
{0.702056,0.800593},
{0.665794,0.695048},
{0.654681,0.70942},
{0.659617,0.736427},
{0.660293,0.765617},
{0.653605,0.79508},
{0.670334,0.812464},
{0.675096,0.68002},
{0.682575,0.664487},
{0.655487,0.672248},
{0.647019,0.685519},
{0.636789,0.698241},
{0.641335,0.722836},
{0.64204,0.749761},
{0.63727,0.777977},
{0.625515,0.806675},
{0.638611,0.824334},
{0.624684,0.710234},
{0.620496,0.687948},
{0.625578,0.735049},
{0.622044,0.761646},
{0.612643,0.789232},
{0.596779,0.817718},
{0.606889,0.836204},
{0.609585,0.698622},
{0.596092,0.687955},
{0.597048,0.708575},
{0.610595,0.721319},
{0.607769,0.746036},
{0.60022,0.772224},
{0.586809,0.799438},
{0.567799,0.828364},
{0.575167,0.848074},
{0.599952,0.661277},
{0.62082,0.658352},
{0.614019,0.668625},
{0.592651,0.669933},
{0.605789,0.678525},
{0.629709,0.676761},
{0.637352,0.665016},
{0.643402,0.652984},
{0.626189,0.647788},
{0.605937,0.652248},
{0.587485,0.654548},
{0.581064,0.662136},
{0.573433,0.66938},
{0.584048,0.678226},
{0.662256,0.658559},
{0.667394,0.644583},
{0.647905,0.640686},
{0.630123,0.637015},
{0.610662,0.643005},
{0.592751,0.64669},
{0.5766,0.648646},
{0.570893,0.655142},
{0.564136,0.661471},
{0.564536,0.676206},
{0.574068,0.686036},
{0.584889,0.696819},
{0.582967,0.717721},
{0.594815,0.731414},
{0.588474,0.755882},
{0.577156,0.781633},
{0.560526,0.808921},
{0.538635,0.838198},
{0.543445,0.859944},
{0.616367,0.624057},
{0.614096,0.633582},
{0.61737,0.614496},
{0.602729,0.613753},
{0.601799,0.622092},
{0.599869,0.630402},
{0.596874,0.638622},
{0.584732,0.634697},
{0.581128,0.641706},
{0.587284,0.627508},
{0.589095,0.620278},
{0.576185,0.624932},
{0.574012,0.63122},
{0.570935,0.637321},
{0.566938,0.643235},
{0.567441,0.617004},
{0.578268,0.612177},
{0.577566,0.618553},
{0.566304,0.622624},
{0.58976,0.612971},
{0.589809,0.605699},
{0.578281,0.605831},
{0.568007,0.6114},
{0.558267,0.61559},
{0.557374,0.62053},
{0.555945,0.625399},
{0.564524,0.628155},
{0.561932,0.633474},
{0.558517,0.638632},
{0.554254,0.643566},
{0.562002,0.648962},
{0.556039,0.654392},
{0.556198,0.667332},
{0.554533,0.682514},
{0.56289,0.69328},
{0.572368,0.704989},
{0.567712,0.725915},
{0.577634,0.740438},
{0.567947,0.764501},
{0.553443,0.790011},
{0.53386,0.816837},
{0.509348,0.846804},
{0.511722,0.871815},
{0.542996,0.642869},
{0.541639,0.635089},
{0.54751,0.638926},
{0.549032,0.648219},
{0.551088,0.634626},
{0.54444,0.63142},
{0.538356,0.628706},
{0.53651,0.6321},
{0.537896,0.638432},
{0.5374,0.646317},
{0.542726,0.652424},
{0.54896,0.659417},
{0.539796,0.62501},
{0.532492,0.626826},
{0.533309,0.623286},
{0.540886,0.621141},
{0.533993,0.619662},
{0.526838,0.622051},
{0.526553,0.625614},
{0.526462,0.629185},
{0.531619,0.63009},
{0.546564,0.627269},
{0.548123,0.623061},
{0.549223,0.618711},
{0.541679,0.617225},
{0.534506,0.616038},
{0.527187,0.618537},
{0.520349,0.621256},
{0.520448,0.625102},
{0.520903,0.628969},
{0.522016,0.633346},
{0.527224,0.632853},
{0.53087,0.632586},
{0.533732,0.634874},
{0.553875,0.630107},
{0.549979,0.614401},
{0.542192,0.613301},
{0.534848,0.612472},
{0.527469,0.615113},
{0.520438,0.617806},
{0.513811,0.620853},
{0.514128,0.624687},
{0.514804,0.629026},
{0.515991,0.633866},
{0.51784,0.639204},
{0.524102,0.638012},
{0.529498,0.636707},
{0.532988,0.641084},
{0.542439,0.609408},
{0.535018,0.608925},
{0.527672,0.611787},
{0.52054,0.614456},
{0.513712,0.617366},
{0.507198,0.620661},
{0.50761,0.624663},
{0.508287,0.629227},
{0.509362,0.634448},
{0.510926,0.640255},
{0.513005,0.646864},
{0.520358,0.645204},
{0.527072,0.643427},
{0.530871,0.649347},
{0.55592,0.575301},
{0.559627,0.579734},
{0.567997,0.575961},
{0.571539,0.581441},
{0.574262,0.58727},
{0.576253,0.593338},
{0.587433,0.591344},
{0.588917,0.598502},
{0.577601,0.599538},
{0.566424,0.594898},
{0.567488,0.600334},
{0.564801,0.589578},
{0.562587,0.584478},
{0.556218,0.591534},
{0.557482,0.596187},
{0.558335,0.600942},
{0.558759,0.605777},
{0.568042,0.60584},
{0.558733,0.610666},
{0.550269,0.609995},
{0.5503,0.605682},
{0.542441,0.60556},
{0.53502,0.60547},
{0.527779,0.608567},
{0.520646,0.611387},
{0.51369,0.614069},
{0.506993,0.617134},
{0.500484,0.620502},
{0.500872,0.624631},
{0.501474,0.629441},
{0.502355,0.634941},
{0.503576,0.64114},
{0.505161,0.648163},
{0.507131,0.656136},
{0.515595,0.654316},
{0.523555,0.652033},
{0.527442,0.659704},
{0.535479,0.656268},
{0.540909,0.664031},
{0.547248,0.672883},
{0.54997,0.601407},
{0.549382,0.597202},
{0.542219,0.601771},
{0.534532,0.598754},
{0.541031,0.594439},
{0.541755,0.598058},
{0.534861,0.602079},
{0.548349,0.593151},
{0.546979,0.589225},
{0.540029,0.590945},
{0.534035,0.595491},
{0.527453,0.599371},
{0.527671,0.602377},
{0.527782,0.605436},
{0.552082,0.582918},
{0.554449,0.58708},
{0.545179,0.585534},
{0.538733,0.587605},
{0.533358,0.592313},
{0.527134,0.596399},
{0.520307,0.597148},
{0.520493,0.599889},
{0.520625,0.602663},
{0.520704,0.605468},
{0.520696,0.608321},
{0.532499,0.589235},
{0.48,0.8508},
{0.507,0.822906},
{0.48,0.883685},
{0.480002,0.82531},
{0.504704,0.801232},
{0.480005,0.802912},
{0.455306,0.801232},
{0.453003,0.822906},
{0.450652,0.846804},
{0.448278,0.871815},
{0.421366,0.838198},
{0.416556,0.859944},
{0.392202,0.828364},
{0.384834,0.848074},
{0.363221,0.817718},
{0.353112,0.836204},
{0.334486,0.806675},
{0.321389,0.824334},
{0.306396,0.79508},
{0.289667,0.812464},
{0.279352,0.782779},
{0.257945,0.800593},
{0.256469,0.768031},
{0.226223,0.788723},
{0.240863,0.749097},
{0.216218,0.764161},
{0.22948,0.727793},
{0.206214,0.739598},
{0.219265,0.705937},
{0.196209,0.715035},
{0.209878,0.683761},
{0.186204,0.690473},
{0.200982,0.661496},
{0.176199,0.66591},
{0.192954,0.639214},
{0.166194,0.641348},
{0.186173,0.616984},
{0.15619,0.616786},
{0.184048,0.595183},
{0.146185,0.592223},
{0.189989,0.574186},
{0.160424,0.570094},
{0.200566,0.553678},
{0.174663,0.547965},
{0.212351,0.533345},
{0.188902,0.525836},
{0.224943,0.513175},
{0.20314,0.503708},
{0.237945,0.493159},
{0.217379,0.481579},
{0.251544,0.473527},
{0.231618,0.45945},
{0.265927,0.454509},
{0.245857,0.437321},
{0.282936,0.437955},
{0.260096,0.415192},
{0.287584,0.406025},
{0.304415,0.425717},
{0.315072,0.396858},
{0.32846,0.415987},
{0.34256,0.387691},
{0.353167,0.40696},
{0.370048,0.378524},
{0.378286,0.398452},
{0.397536,0.369358},
{0.40357,0.390276},
{0.428978,0.382737},
{0.425024,0.360191},
{0.454468,0.376136},
{0.452512,0.351024},
{0.48,0.373071},
{0.48,0.341857},
{0.507488,0.351024},
{0.505532,0.376136},
{0.534976,0.360191},
{0.529239,0.796747},
{0.546648,0.771917},
{0.524755,0.777636},
{0.540241,0.754921},
{0.520519,0.759996},
{0.502489,0.781452},
{0.480033,0.764393},
{0.498401,0.746404},
{0.500381,0.763234},
{0.480014,0.782813},
{0.516522,0.743385},
{0.496567,0.73079},
{0.480052,0.747349},
{0.461698,0.746404},
{0.45968,0.763234},
{0.457539,0.781452},
{0.509541,0.713867},
{0.528781,0.724091},
{0.512865,0.72818},
{0.494899,0.716259},
{0.534269,0.73899},
{0.551383,0.733027},
{0.544128,0.718738},
{0.523827,0.710223},
{0.506599,0.700609},
{0.493419,0.702678},
{0.480078,0.717107},
{0.480071,0.731726},
{0.463562,0.73079},
{0.443552,0.743385},
{0.43953,0.759996},
{0.435271,0.777626},
{0.559346,0.748303},
{0.558719,0.712332},
{0.537595,0.705433},
{0.519457,0.697384},
{0.515639,0.685581},
{0.504037,0.688318},
{0.492117,0.690071},
{0.480071,0.703424},
{0.46671,0.702678},
{0.465242,0.716259},
{0.447234,0.72818},
{0.42578,0.738991},
{0.419792,0.754921},
{0.413368,0.771917},
{0.430771,0.796747},
{0.426144,0.816836},
{0.399476,0.808921},
{0.373196,0.799436},
{0.347358,0.789232},
{0.322731,0.777977},
{0.299706,0.765618},
{0.279892,0.751364},
{0.264423,0.734667},
{0.252288,0.716263},
{0.241963,0.696979},
{0.23322,0.677136},
{0.225381,0.657124},
{0.219163,0.637061},
{0.21491,0.617074},
{0.214223,0.597365},
{0.218314,0.578128},
{0.225921,0.55928},
{0.235436,0.540729},
{0.246446,0.522484},
{0.258216,0.504537},
{0.271132,0.487268},
{0.285284,0.471001},
{0.301567,0.456559},
{0.320568,0.444692},
{0.341573,0.434746},
{0.36361,0.425946},
{0.386418,0.418102},
{0.409531,0.410883},
{0.432902,0.404838},
{0.456406,0.40029},
{0.48,0.398454},
{0.531837,0.693187},
{0.537387,0.6777},
{0.543581,0.688202},
{0.550671,0.699744},
{0.53203,0.66823},
{0.526815,0.682014},
{0.480053,0.690679},
{0.490987,0.678464},
{0.480033,0.678985},
{0.469073,0.678464},
{0.467981,0.690071},
{0.456037,0.688321},
{0.4535,0.700609},
{0.450567,0.713862},
{0.43128,0.724094},
{0.408641,0.733039},
{0.400671,0.748303},
{0.392061,0.764502},
{0.406564,0.790011},
{0.382847,0.781634},
{0.359782,0.772224},
{0.337955,0.761646},
{0.317955,0.749763},
{0.300376,0.736431},
{0.285812,0.721503},
{0.273817,0.70534},
{0.263948,0.688301},
{0.255811,0.670696},
{0.249013,0.652836},
{0.243984,0.634869},
{0.241156,0.616945},
{0.241043,0.599199},
{0.244156,0.581769},
{0.24993,0.564656},
{0.257796,0.547865},
{0.267276,0.53146},
{0.277894,0.515508},
{0.289818,0.500293},
{0.303218,0.486102},
{0.318323,0.473296},
{0.335362,0.462237},
{0.353956,0.452676},
{0.373727,0.444365},
{0.394311,0.437147},
{0.415346,0.430864},
{0.436715,0.425872},
{0.458305,0.422526},
{0.5018,0.677032},
{0.509515,0.665031},
{0.512338,0.674822},
{0.522461,0.671874},
{0.518741,0.662686},
{0.499899,0.666778},
{0.479996,0.658704},
{0.488534,0.649873},
{0.489206,0.658378},
{0.480012,0.668303},
{0.490019,0.667888},
{0.498292,0.657491},
{0.496974,0.64933},
{0.495896,0.641834},
{0.487992,0.642315},
{0.479985,0.650169},
{0.471438,0.649873},
{0.470787,0.658378},
{0.470003,0.667888},
{0.495065,0.635398},
{0.487566,0.635652},
{0.479978,0.642501},
{0.471968,0.642315},
{0.464073,0.641845},
{0.463006,0.649346},
{0.461702,0.657498},
{0.460118,0.666794},
{0.479978,0.629919},
{0.487012,0.624789},
{0.487245,0.629833},
{0.479976,0.635783},
{0.494437,0.629649},
{0.494005,0.624856},
{0.493695,0.620417},
{0.486855,0.620449},
{0.479983,0.624897},
{0.472957,0.624789},
{0.472715,0.629833},
{0.472389,0.635652},
{0.500259,0.616883},
{0.493519,0.616745},
{0.500143,0.613604},
{0.493415,0.613456},
{0.486757,0.616702},
{0.486682,0.610586},
{0.480001,0.613464},
{0.480004,0.610625},
{0.48668,0.608072},
{0.480005,0.608086},
{0.473329,0.608072},
{0.473324,0.610586},
{0.473297,0.613439},
{0.479996,0.616742},
{0.486704,0.613439},
{0.493389,0.610681},
{0.493373,0.608055},
{0.493379,0.605738},
{0.486682,0.605783},
{0.480005,0.605808},
{0.473327,0.605783},
{0.466627,0.60574},
{0.466634,0.608055},
{0.466615,0.610684},
{0.466585,0.613458},
{0.473236,0.616702},
{0.47999,0.620494},
{0.500102,0.610664},
{0.500102,0.60806},
{0.50011,0.605668},
{0.50009,0.603366},
{0.493367,0.603509},
{0.486678,0.603606},
{0.480005,0.603643},
{0.473331,0.603606},
{0.46664,0.603509},
{0.459914,0.603366},
{0.459895,0.605667},
{0.459902,0.60806},
{0.4599,0.610669},
{0.459857,0.613613},
{0.466474,0.616757},
{0.473126,0.620449},
{0.506898,0.613828},
{0.513711,0.610994},
{0.506883,0.610818},
{0.513741,0.608174},
{0.506886,0.608096},
{0.513697,0.602935},
{0.506824,0.600735},
{0.513616,0.600359},
{0.513531,0.597723},
{0.506793,0.59819},
{0.500079,0.598617},
{0.50007,0.60105},
{0.506861,0.603175},
{0.506894,0.605598},
{0.513748,0.605517},
{0.520099,0.594342},
{0.526723,0.593454},
{0.526227,0.590528},
{0.519895,0.59151},
{0.513476,0.592211},
{0.513473,0.595011},
{0.480002,0.60145},
{0.486676,0.601418},
{0.49337,0.601237},
{0.486687,0.599097},
{0.479997,0.599133},
{0.473328,0.601418},
{0.493451,0.59637},
{0.500149,0.59602},
{0.506826,0.595528},
{0.500314,0.59321},
{0.493583,0.593558},
{0.486789,0.593726},
{0.486722,0.59656},
{0.49338,0.59894},
{0.479945,0.590443},
{0.486905,0.590461},
{0.493824,0.59015},
{0.487089,0.586631},
{0.479926,0.586666},
{0.472991,0.590461},
{0.473148,0.593726},
{0.479966,0.593765},
{0.479986,0.596591},
{0.507262,0.589592},
{0.506955,0.592741},
{0.50062,0.590024},
{0.51367,0.589169},
{0.548301,0.110687},
{0.57204,0.0968793},
{0.567396,0.116259},
{0.543596,0.12932},
{0.562658,0.135572},
{0.586653,0.121946},
{0.591396,0.101941},
{0.596139,0.0819358},
{0.576613,0.0774487},
{0.552803,0.0919056},
{0.529522,0.105333},
{0.524915,0.123319},
{0.519803,0.140967},
{0.538473,0.147692},
{0.557675,0.15474},
{0.58191,0.141951},
{0.53786,0.0687108},
{0.522271,0.0464429},
{0.541798,0.0502111},
{0.561433,0.0540682},
{0.545676,0.0316602},
{0.525693,0.0282384},
{0.505711,0.0248167},
{0.502888,0.0427932},
{0.518774,0.0645765},
{0.533802,0.0871079},
{0.557176,0.07303},
{0.58114,0.0579846},
{0.565659,0.0350819},
{0.525697,0.183001},
{0.552297,0.173682},
{0.545361,0.191827},
{0.517066,0.199446},
{0.535704,0.208601},
{0.567681,0.201967},
{0.572424,0.181962},
{0.577167,0.161957},
{0.532662,0.165668},
{0.507292,0.174841},
{0.49941,0.190806},
{0.490582,0.206107},
{0.507252,0.215142},
{0.524474,0.224539},
{0.554834,0.218015},
{0.501841,0.134671},
{0.496306,0.151233},
{0.514009,0.158185},
{0.506761,0.117678},
{0.511159,0.100291},
{0.493306,0.0956438},
{0.489284,0.112506},
{0.484703,0.1289},
{0.479518,0.144817},
{0.473622,0.160216},
{0.489986,0.167266},
{0.463692,0.13902},
{0.458265,0.153785},
{0.466909,0.175054},
{0.482702,0.182678},
{0.474618,0.197429},
{0.4659,0.21154},
{0.481023,0.220768},
{0.496707,0.230358},
{0.512817,0.240177},
{0.541987,0.234062},
{0.453225,0.119312},
{0.442359,0.101208},
{0.456963,0.104144},
{0.468562,0.123799},
{0.472633,0.107947},
{0.460083,0.0883689},
{0.445095,0.0861096},
{0.431378,0.0849802},
{0.428912,0.0992488},
{0.43907,0.115718},
{0.448874,0.133925},
{0.476239,0.0916247},
{0.462587,0.0719349},
{0.447201,0.0703154},
{0.433286,0.0700776},
{0.420681,0.0709736},
{0.418926,0.0848497},
{0.4166,0.0981477},
{0.425906,0.112942},
{0.435093,0.129602},
{0.443889,0.14802},
{0.479203,0.0746868},
{0.496814,0.0783217},
{0.515114,0.0825565},
{0.499958,0.0606636},
{0.481784,0.0573222},
{0.464353,0.0547124},
{0.448514,0.035571},
{0.465263,0.0365723},
{0.483825,0.0394428},
{0.465745,0.0179732},
{0.445762,0.0145515},
{0.434874,0.0207986},
{0.434895,0.0378283},
{0.448458,0.0535785},
{0.434504,0.0544055},
{0.42217,0.056715},
{0.410621,0.0597477},
{0.409223,0.0727557},
{0.407538,0.0854733},
{0.405405,0.0977856},
{0.414032,0.111057},
{0.422376,0.126119},
{0.430576,0.143016},
{0.43825,0.161632},
{0.452076,0.168013},
{0.459487,0.189272},
{0.500868,0.255555},
{0.516294,0.266158},
{0.52914,0.25011},
{0.485647,0.245061},
{0.470853,0.234819},
{0.474275,0.259362},
{0.488761,0.270714},
{0.503447,0.282205},
{0.449602,0.311582},
{0.450004,0.28544},
{0.463669,0.299604},
{0.464906,0.330348},
{0.477753,0.3143},
{0.476396,0.285461},
{0.462452,0.272855},
{0.448978,0.260893},
{0.43718,0.272337},
{0.436585,0.296241},
{0.433216,0.319833},
{0.445042,0.335441},
{0.446613,0.237658},
{0.460186,0.24829},
{0.45656,0.224951},
{0.44286,0.215613},
{0.433674,0.227626},
{0.436118,0.24942},
{0.425143,0.260158},
{0.424631,0.28237},
{0.421791,0.304754},
{0.415513,0.325904},
{0.425179,0.340535},
{0.403215,0.257657},
{0.403362,0.23813},
{0.413841,0.248761},
{0.413567,0.269599},
{0.423978,0.238718},
{0.412774,0.228596},
{0.402258,0.219337},
{0.393797,0.22825},
{0.393697,0.246469},
{0.392055,0.265312},
{0.401281,0.277635},
{0.411169,0.290735},
{0.392913,0.210701},
{0.410375,0.209457},
{0.3852,0.219117},
{0.377259,0.226511},
{0.384999,0.236134},
{0.383562,0.253748},
{0.380474,0.271781},
{0.388461,0.284323},
{0.39701,0.297649},
{0.406066,0.311447},
{0.400215,0.201389},
{0.418078,0.198674},
{0.407206,0.191174},
{0.391089,0.194057},
{0.384496,0.202851},
{0.377627,0.210729},
{0.370481,0.217631},
{0.363059,0.223494},
{0.369027,0.232844},
{0.375874,0.242927},
{0.373219,0.259784},
{0.368585,0.277119},
{0.375268,0.289909},
{0.382368,0.303328},
{0.389805,0.317199},
{0.397497,0.331345},
{0.437883,0.19463},
{0.451468,0.202811},
{0.445363,0.181652},
{0.43203,0.174671},
{0.425301,0.187049},
{0.429995,0.206822},
{0.421538,0.218218},
{0.425459,0.15597},
{0.419873,0.168387},
{0.413729,0.151091},
{0.408671,0.162839},
{0.403208,0.173976},
{0.413738,0.18014},
{0.388575,0.178307},
{0.397346,0.184411},
{0.382982,0.187399},
{0.393726,0.168484},
{0.398722,0.158004},
{0.385304,0.163593},
{0.380801,0.172812},
{0.37588,0.18135},
{0.370641,0.189098},
{0.377266,0.195595},
{0.370986,0.203027},
{0.364623,0.209405},
{0.357884,0.214831},
{0.351053,0.219217},
{0.355406,0.228372},
{0.360611,0.238128},
{0.366472,0.248666},
{0.362414,0.264948},
{0.356425,0.281436},
{0.361766,0.294437},
{0.36738,0.30804},
{0.373233,0.322055},
{0.379292,0.336333},
{0.385452,0.350721},
{0.405316,0.345628},
{0.389475,0.153761},
{0.384706,0.140389},
{0.393398,0.143384},
{0.403047,0.146919},
{0.39698,0.132542},
{0.387812,0.130267},
{0.379525,0.128419},
{0.376895,0.137839},
{0.374025,0.146885},
{0.381355,0.150081},
{0.377778,0.159267},
{0.364958,0.183101},
{0.360097,0.189474},
{0.365184,0.19595},
{0.359458,0.201865},
{0.353413,0.206808},
{0.347117,0.210834},
{0.34064,0.214001},
{0.343827,0.222833},
{0.347564,0.232319},
{0.35189,0.242493},
{0.356845,0.253388},
{0.351485,0.268989},
{0.344026,0.28484},
{0.348005,0.298138},
{0.352182,0.312056},
{0.356531,0.326417},
{0.361023,0.341048},
{0.365588,0.355814},
{0.369591,0.175882},
{0.373919,0.167887},
{0.363922,0.17097},
{0.359876,0.177693},
{0.355601,0.183576},
{0.351034,0.188571},
{0.354989,0.194913},
{0.349528,0.199412},
{0.343816,0.203004},
{0.337894,0.205808},
{0.331796,0.207858},
{0.333983,0.216394},
{0.336551,0.225572},
{0.339545,0.235414},
{0.343036,0.245928},
{0.347008,0.257154},
{0.340324,0.272142},
{0.331464,0.287295},
{0.33408,0.300863},
{0.336847,0.315166},
{0.339743,0.329948},
{0.342708,0.345339},
{0.345725,0.360907},
{0.347541,0.182734},
{0.343097,0.186418},
{0.34611,0.192632},
{0.340902,0.195832},
{0.335482,0.198244},
{0.329857,0.199972},
{0.324033,0.201122},
{0.325492,0.209276},
{0.32715,0.218102},
{0.329081,0.227592},
{0.33136,0.237735},
{0.333991,0.248543},
{0.336979,0.260028},
{0.32906,0.27428},
{0.318814,0.288763},
{0.320081,0.302593},
{0.321446,0.317164},
{0.322882,0.332606},
{0.324361,0.349053},
{0.325862,0.366001},
{0.351629,0.178194},
{0.355453,0.172674},
{0.348112,0.173266},
{0.344448,0.177446},
{0.340425,0.180721},
{0.336088,0.183203},
{0.338361,0.18919},
{0.333358,0.191308},
{0.328145,0.192763},
{0.322751,0.193658},
{0.318076,0.201812},
{0.319061,0.210194},
{0.320195,0.219222},
{0.32155,0.228958},
{0.323055,0.239324},
{0.324824,0.250351},
{0.326812,0.262033},
{0.317642,0.275641},
{0.306112,0.28925},
{0.306046,0.303176},
{0.306014,0.317884},
{0.306004,0.333638},
{0.305998,0.350766},
{0.305998,0.371094},
{0.347911,0.164137},
{0.354477,0.162507},
{0.351446,0.168259},
{0.344952,0.168765},
{0.358882,0.166536},
{0.362085,0.159611},
{0.357211,0.156106},
{0.350575,0.158862},
{0.344694,0.16045},
{0.342048,0.164666},
{0.339072,0.168149},
{0.341659,0.172577},
{0.338002,0.175528},
{0.334011,0.177714},
{0.331477,0.185002},
{0.370983,0.15547},
{0.367654,0.163523},
{0.364935,0.152125},
{0.359651,0.149154},
{0.35294,0.152949},
{0.347041,0.155577},
{0.341741,0.157007},
{0.339366,0.160936},
{0.336638,0.164088},
{0.335733,0.170823},
{0.332075,0.172794},
{0.329763,0.179299},
{0.326641,0.186206},
{0.356866,0.139691},
{0.363827,0.133946},
{0.361842,0.141737},
{0.355006,0.146532},
{0.367677,0.144112},
{0.369942,0.135702},
{0.365626,0.125886},
{0.359933,0.125108},
{0.358464,0.132516},
{0.352416,0.137947},
{0.350873,0.144236},
{0.349098,0.150141},
{0.401067,0.0514741},
{0.411891,0.0465642},
{0.423117,0.0419556},
{0.413098,0.0332929},
{0.40221,0.03954},
{0.391322,0.0457871},
{0.390493,0.0565052},
{0.399906,0.0633619},
{0.398635,0.0751327},
{0.39713,0.0867118},
{0.395191,0.0980003},
{0.402907,0.109723},
{0.410721,0.123386},
{0.418319,0.138821},
{0.407178,0.135378},
{0.400124,0.121315},
{0.392998,0.109033},
{0.38582,0.0986294},
{0.383929,0.108762},
{0.390522,0.119793},
{0.3741,0.118015},
{0.381851,0.118709},
{0.376007,0.108918},
{0.368684,0.109311},
{0.36726,0.117662},
{0.372187,0.126976},
{0.363245,0.10231},
{0.369852,0.100868},
{0.377353,0.0996072},
{0.370683,0.0923615},
{0.36374,0.0946366},
{0.357676,0.0969275},
{0.357463,0.103832},
{0.362432,0.109974},
{0.361258,0.117579},
{0.387422,0.0883125},
{0.379403,0.0807309},
{0.388639,0.0778134},
{0.389615,0.0671913},
{0.380028,0.071207},
{0.37103,0.0752748},
{0.371096,0.083818},
{0.378604,0.0902239},
{0.361706,0.0719678},
{0.370423,0.0667688},
{0.38025,0.061617},
{0.369546,0.0582814},
{0.358658,0.0645285},
{0.351867,0.072293},
{0.354792,0.0772215},
{0.363152,0.0793928},
{0.363754,0.0869718},
{0.306184,0.27604},
{0.31656,0.263196},
{0.306243,0.263567},
{0.295882,0.263196},
{0.294697,0.275641},
{0.293393,0.288763},
{0.292009,0.302593},
{0.290583,0.317164},
{0.289122,0.332606},
{0.287635,0.349052},
{0.286135,0.366},
{0.269288,0.345338},
{0.266271,0.360907},
{0.250973,0.341048},
{0.246408,0.355814},
{0.232705,0.336332},
{0.226544,0.35072},
{0.2145,0.331344},
{0.206681,0.345626},
{0.196484,0.325903},
{0.186818,0.340533},
{0.178781,0.319831},
{0.166954,0.33544},
{0.162395,0.311581},
{0.147091,0.330346},
{0.148329,0.299603},
{0.134244,0.314299},
{0.135602,0.28546},
{0.121398,0.298251},
{0.123237,0.270713},
{0.108551,0.282204},
{0.11113,0.255554},
{0.0957049,0.266156},
{0.0991817,0.240177},
{0.0828583,0.250109},
{0.0700118,0.234062},
{0.087525,0.224539},
{0.0571652,0.218014},
{0.0762946,0.208601},
{0.0443187,0.201967},
{0.0666379,0.191828},
{0.0395757,0.181962},
{0.0597022,0.173683},
{0.0348327,0.161957},
{0.0543245,0.154741},
{0.0300897,0.141952},
{0.0493415,0.135574},
{0.0253466,0.121948},
{0.0446031,0.116261},
{0.0206036,0.101943},
{0.0399591,0.0968812},
{0.0158606,0.081938},
{0.0353858,0.077451},
{0.0111176,0.0619331},
{0.0308597,0.0579872},
{0.00637457,0.0419283},
{0.0263571,0.0385066},
{0.0463397,0.0350849},
{0.0505658,0.0540709},
{0.0663222,0.0316632},
{0.0702003,0.0502138},
{0.0863048,0.0282414},
{0.0897271,0.0464456},
{0.106287,0.0248197},
{0.10911,0.042796},
{0.12627,0.021398},
{0.128172,0.0394456},
{0.146252,0.0179763},
{0.146735,0.0365751},
{0.166235,0.0145546},
{0.163483,0.0355739},
{0.177123,0.0208015},
{0.177102,0.0378311},
{0.18801,0.0270485},
{0.18888,0.0419583},
{0.198898,0.0332954},
{0.200106,0.0465668},
{0.209786,0.0395424},
{0.210931,0.0514767},
{0.220674,0.0457893},
{0.221507,0.0565079},
{0.231561,0.0520363},
{0.231752,0.0616198},
{0.242449,0.0582833},
{0.241584,0.0667721},
{0.253337,0.0645302},
{0.250316,0.0719726},
{0.260174,0.0723001},
{0.25992,0.0639232},
{0.264695,0.0696384},
{0.266502,0.0633163},
{0.270158,0.0682765},
{0.273085,0.0627093},
{0.275901,0.0672462},
{0.279667,0.0621023},
{0.281819,0.0664303},
{0.28625,0.0614953},
{0.287808,0.0657115},
{0.292832,0.0608884},
{0.293849,0.0650992},
{0.299415,0.0602814},
{0.299924,0.0646027},
{0.305997,0.0596744},
{0.306018,0.0643831},
{0.312112,0.0646016},
{0.31258,0.0602812},
{0.318188,0.0650969},
{0.319162,0.0608879},
{0.324229,0.0657082},
{0.325745,0.0614947},
{0.330218,0.0664261},
{0.332327,0.0621015},
{0.336136,0.0672412},
{0.33891,0.0627082},
{0.34188,0.0682707},
{0.345493,0.063315},
{0.347343,0.069632},
{0.352075,0.0639217},
{0.306184,0.22994},
{0.314678,0.240224},
{0.306243,0.240501},
{0.297763,0.240224},
{0.306268,0.251727},
{0.315571,0.2514},
{0.31388,0.229697},
{0.313176,0.219851},
{0.306115,0.220043},
{0.299033,0.219852},
{0.298459,0.229698},
{0.289284,0.239327},
{0.296915,0.2514},
{0.306,0.202257},
{0.311617,0.194368},
{0.312054,0.202165},
{0.306047,0.210827},
{0.312567,0.210677},
{0.31723,0.194263},
{0.316478,0.187233},
{0.311239,0.187338},
{0.305975,0.194462},
{0.300334,0.194368},
{0.299947,0.202165},
{0.299518,0.210677},
{0.320605,0.180847},
{0.321626,0.186903},
{0.325274,0.180312},
{0.323979,0.17504},
{0.319636,0.175482},
{0.315796,0.18111},
{0.310902,0.18109},
{0.305961,0.187334},
{0.300692,0.187338},
{0.295475,0.187239},
{0.294743,0.194271},
{0.293928,0.201816},
{0.293009,0.210206},
{0.820748,0.160054},
{0.804746,0.15055},
{0.825016,0.153365},
{0.838867,0.164746},
{0.846336,0.158264},
{0.849566,0.148774},
{0.827284,0.144521},
{0.805914,0.141937},
{0.785,0.149689},
{0.802825,0.157376},
{0.815475,0.165534},
{0.829818,0.169397},
{0.842397,0.175242},
{0.854872,0.171605},
{0.871669,0.16657},
{0.872914,0.153504},
{0.873006,0.141476},
{0.85036,0.137636},
{0.828222,0.134287},
{0.806518,0.131821},
{0.785,0.141062},
{0.764087,0.141937},
{0.765255,0.15055},
{0.767176,0.157376},
{0.785,0.156541},
{0.800437,0.162896},
{0.810294,0.169755},
{0.821849,0.173394},
{0.832058,0.178423},
{0.840446,0.184757},
{0.852278,0.18265},
{0.866453,0.180781},
{0.884042,0.180364},
{0.900214,0.170038},
{0.897478,0.157523},
{0.896313,0.145121},
{0.895127,0.132894},
{0.872683,0.129542},
{0.850518,0.126214},
{0.828562,0.123124},
{0.806747,0.120487},
{0.784997,0.13086},
{0.763483,0.131821},
{0.741778,0.134288},
{0.742717,0.144521},
{0.744986,0.153379},
{0.749253,0.160054},
{0.754525,0.165536},
{0.769564,0.162896},
{0.785,0.162165},
{0.785,0.166882},
{0.797866,0.167593},
{0.805472,0.173932},
{0.814933,0.177057},
{0.823392,0.181513},
{0.830487,0.18705},
{0.836401,0.193676},
{0.847233,0.192187},
{0.860005,0.191586},
{0.874765,0.191175},
{0.892266,0.192314},
{0.906117,0.182609},
{0.925834,0.173877},
{0.922493,0.161281},
{0.92002,0.148781},
{0.917781,0.136263},
{0.915716,0.123805},
{0.89393,0.120753},
{0.872144,0.117701},
{0.850359,0.114648},
{0.828573,0.111596},
{0.806787,0.108544},
{0.785001,0.119282},
{0.763255,0.120487},
{0.741439,0.123123},
{0.719483,0.126213},
{0.719641,0.137636},
{0.720434,0.148774},
{0.723665,0.158265},
{0.731134,0.164747},
{0.740184,0.169396},
{0.748155,0.173391},
{0.759707,0.169755},
{0.772135,0.167593},
{0.774605,0.171892},
{0.785,0.171267},
{0.795396,0.171892},
{0.8014,0.177885},
{0.80904,0.180707},
{0.815971,0.184598},
{0.821933,0.189477},
{0.827016,0.195276},
{0.841219,0.200997},
{0.852639,0.200505},
{0.865808,0.200662},
{0.880961,0.201685},
{0.898307,0.203742},
{0.912843,0.195007},
{0.930557,0.186459},
{0.950979,0.178035},
{0.947195,0.16523},
{0.943766,0.152434},
{0.940575,0.139644},
{0.937502,0.126857},
{0.918049,0.207002},
{0.902453,0.214932},
{0.921552,0.218631},
{0.939923,0.211262},
{0.935662,0.199076},
{0.955238,0.190852},
{0.97589,0.182395},
{0.971739,0.169274},
{0.967589,0.156152},
{0.963438,0.143031},
{0.959288,0.129909},
{0.904922,0.225885},
{0.890067,0.233054},
{0.888349,0.222659},
{0.885378,0.212212},
{0.873405,0.220215},
{0.875603,0.230292},
{0.876619,0.240042},
{0.890722,0.243427},
{0.905997,0.236723},
{0.92317,0.229927},
{0.86436,0.246924},
{0.863737,0.237358},
{0.862308,0.227855},
{0.852071,0.235325},
{0.852969,0.244548},
{0.853159,0.253793},
{0.864212,0.256451},
{0.876847,0.249969},
{0.890404,0.253661},
{0.905927,0.247401},
{0.923244,0.240973},
{0.94301,0.234678},
{0.942685,0.223241},
{0.963665,0.216313},
{0.959593,0.203629},
{0.98004,0.195517},
{0.986457,0.245675},
{0.960795,0.251033},
{0.964357,0.240027},
{0.992491,0.234882},
{0.965804,0.22856},
{0.941601,0.245866},
{0.939072,0.256705},
{0.95659,0.261899},
{0.980423,0.256469},
{0.920017,0.262492},
{0.922114,0.25185},
{0.90486,0.257905},
{0.90291,0.268057},
{0.917191,0.272837},
{0.93574,0.267413},
{0.951939,0.272653},
{0.974389,0.267262},
{0.962322,0.288849},
{0.941917,0.29383},
{0.94704,0.283323},
{0.968356,0.278055},
{0.931937,0.277939},
{0.927693,0.288185},
{0.923092,0.298016},
{0.936595,0.304092},
{0.956288,0.299642},
{0.905626,0.301576},
{0.909902,0.292474},
{0.913774,0.282844},
{0.897106,0.287431},
{0.893497,0.296549},
{0.889496,0.305109},
{0.900998,0.309999},
{0.91814,0.307166},
{0.930981,0.313445},
{0.950254,0.310436},
{0.887276,0.273369},
{0.889202,0.26364},
{0.876244,0.259725},
{0.875004,0.269432},
{0.87306,0.278765},
{0.884786,0.282849},
{0.900254,0.277885},
{0.860193,0.284298},
{0.862046,0.275213},
{0.863404,0.265895},
{0.851844,0.272218},
{0.850475,0.281238},
{0.848668,0.28996},
{0.857902,0.293043},
{0.870687,0.287889},
{0.881806,0.291974},
{0.91237,0.334812},
{0.895528,0.337184},
{0.901509,0.330114},
{0.918738,0.328116},
{0.907297,0.322901},
{0.890877,0.325566},
{0.885412,0.333047},
{0.879652,0.340523},
{0.889369,0.344263},
{0.905897,0.341416},
{0.923344,0.339584},
{0.930303,0.333466},
{0.937261,0.327347},
{0.924985,0.321223},
{0.91285,0.315355},
{0.896066,0.317933},
{0.880535,0.32121},
{0.875584,0.329018},
{0.870257,0.336799},
{0.864645,0.344711},
{0.873646,0.348142},
{0.883067,0.351493},
{0.899335,0.348034},
{0.916386,0.345702},
{0.885157,0.313274},
{0.94422,0.321229},
{0.879169,0.368814},
{0.876554,0.358926},
{0.885958,0.361553},
{0.89551,0.364057},
{0.902468,0.357938},
{0.892688,0.354725},
{0.867447,0.356052},
{0.869941,0.366777},
{0.872347,0.376808},
{0.888551,0.370175},
{0.84497,0.358061},
{0.843187,0.345887},
{0.850678,0.349454},
{0.852662,0.361459},
{0.858776,0.352903},
{0.856102,0.34115},
{0.848207,0.33767},
{0.840756,0.334194},
{0.836336,0.342385},
{0.838002,0.354425},
{0.838963,0.367047},
{0.846256,0.37045},
{0.854388,0.373121},
{0.861035,0.364347},
{0.861259,0.333074},
{0.852768,0.329467},
{0.844899,0.3261},
{0.834066,0.331081},
{0.830139,0.339111},
{0.831648,0.35073},
{0.832461,0.363222},
{0.832536,0.376313},
{0.83943,0.379977},
{0.847475,0.382441},
{0.856375,0.384052},
{0.863153,0.375196},
{0.837669,0.323026},
{0.848712,0.318012},
{0.840985,0.314968},
{0.8311,0.320298},
{0.827981,0.328263},
{0.824608,0.336224},
{0.825999,0.347261},
{0.826701,0.359288},
{0.82672,0.371986},
{0.825566,0.385761},
{0.831959,0.390165},
{0.840263,0.392372},
{0.849538,0.393295},
{0.858843,0.393849},
{0.865551,0.385248},
{0.870544,0.317089},
{0.8571,0.32141},
{0.861038,0.313274},
{0.874642,0.308965},
{0.864686,0.305087},
{0.852147,0.309837},
{0.866092,0.325096},
{0.878411,0.300636},
{0.867845,0.296607},
{0.855209,0.301529},
{0.843911,0.306782},
{0.846501,0.298476},
{0.836369,0.304115},
{0.833913,0.312269},
{0.8252,0.317928},
{0.822663,0.325911},
{0.819701,0.333701},
{0.820991,0.344208},
{0.821617,0.355531},
{0.821498,0.367676},
{0.820465,0.380449},
{0.817961,0.394242},
{0.822829,0.40232},
{0.833636,0.402768},
{0.843111,0.402769},
{0.852305,0.402562},
{0.861367,0.402233},
{0.868163,0.394219},
{0.874959,0.386204},
{0.881755,0.37819},
{0.838472,0.29582},
{0.829536,0.301839},
{0.827554,0.309959},
{0.819977,0.315927},
{0.817784,0.323743},
{0.815375,0.331516},
{0.816617,0.341578},
{0.817141,0.35224},
{0.817041,0.363588},
{0.816039,0.375514},
{0.81391,0.387912},
{0.809631,0.400606},
{0.811209,0.408773},
{0.819462,0.415363},
{0.828478,0.413486},
{0.837356,0.41242},
{0.846017,0.411338},
{0.854571,0.410248},
{0.810306,0.382462},
{0.81219,0.37108},
{0.807146,0.377745},
{0.804281,0.388182},
{0.806903,0.393901},
{0.80113,0.405044},
{0.801909,0.41303},
{0.810385,0.418877},
{0.816186,0.426748},
{0.824121,0.424233},
{0.832054,0.422125},
{0.839919,0.42016},
{0.847775,0.418262},
{0.819897,0.434718},
{0.826917,0.431809},
{0.833946,0.429014},
{0.840979,0.426277},
{0.812891,0.437797},
{0.808252,0.429971},
{0.805902,0.441104},
{0.809592,0.448664},
{0.81574,0.445071},
{0.821887,0.441478},
{0.828035,0.437884},
{0.834183,0.434291},
{0.793145,0.425024},
{0.793297,0.415692},
{0.793014,0.40775},
{0.785036,0.416592},
{0.785013,0.42593},
{0.785005,0.436606},
{0.792665,0.435593},
{0.800385,0.433112},
{0.801522,0.422581},
{0.809767,0.187886},
{0.814711,0.192109},
{0.819199,0.19753},
{0.831308,0.201925},
{0.845118,0.209056},
{0.856848,0.209389},
{0.870269,0.210488},
{0.804121,0.184415},
{0.798059,0.18222},
{0.795227,0.186042},
{0.800126,0.188254},
{0.80469,0.191292},
{0.808747,0.195015},
{0.812371,0.199523},
{0.822811,0.203246},
{0.834863,0.209243},
{0.837733,0.217051},
{0.848178,0.217491},
{0.860041,0.218519},
{0.789021,0.188923},
{0.790162,0.184797},
{0.791579,0.18053},
{0.785012,0.184416},
{0.785024,0.188618},
{0.785033,0.192558},
{0.788117,0.192816},
{0.793001,0.190024},
{0.796883,0.191998},
{0.800558,0.194723},
{0.803846,0.197964},
{0.80689,0.201985},
{0.809626,0.206826},
{0.815632,0.204918},
{0.818467,0.211042},
{0.826071,0.210013},
{0.828634,0.217149},
{0.830922,0.225113},
{0.839968,0.225287},
{0.850526,0.226345},
{0.802331,0.215797},
{0.804643,0.208857},
{0.806733,0.214069},
{0.803738,0.221217},
{0.808474,0.219884},
{0.812095,0.212473},
{0.802302,0.20437},
{0.800561,0.21091},
{0.798649,0.217414},
{0.79982,0.222577},
{0.800817,0.228332},
{0.805132,0.227442},
{0.809963,0.226318},
{0.81413,0.218688},
{0.794013,0.205806},
{0.793336,0.210997},
{0.791986,0.207992},
{0.790615,0.205694},
{0.789244,0.207626},
{0.790293,0.209728},
{0.791309,0.212491},
{0.792265,0.215909},
{0.794548,0.214607},
{0.79569,0.209007},
{0.79656,0.203331},
{0.792263,0.2033},
{0.789223,0.204095},
{0.78819,0.206197},
{0.787415,0.207985},
{0.788217,0.209243},
{0.788958,0.211116},
{0.789762,0.213742},
{0.790385,0.216864},
{0.791062,0.220791},
{0.793118,0.219969},
{0.795653,0.218886},
{0.797254,0.212884},
{0.798766,0.2069},
{0.79981,0.200727},
{0.794413,0.20064},
{0.790479,0.201508},
{0.787844,0.203092},
{0.787137,0.205324},
{0.786657,0.207286},
{0.786268,0.209024},
{0.786937,0.209631},
{0.787551,0.210676},
{0.788005,0.212259},
{0.788411,0.214509},
{0.788884,0.217552},
{0.789352,0.221316},
{0.789745,0.225725},
{0.791559,0.225283},
{0.793823,0.224662},
{0.796566,0.223786},
{0.797129,0.197789},
{0.792097,0.198571},
{0.788675,0.200343},
{0.786442,0.202571},
{0.786094,0.204893},
{0.785829,0.206886},
{0.785651,0.208755},
{0.785568,0.210683},
{0.786085,0.21087},
{0.786693,0.211281},
{0.787169,0.211639},
{0.787277,0.212975},
{0.787446,0.215083},
{0.787728,0.218005},
{0.78806,0.221688},
{0.788337,0.226017},
{0.788646,0.231039},
{0.790116,0.230778},
{0.792142,0.230542},
{0.794431,0.229954},
{0.797396,0.229311},
{0.79422,0.195419},
{0.791182,0.193725},
{0.789832,0.197265},
{0.786867,0.199715},
{0.785057,0.202434},
{0.785052,0.204788},
{0.785051,0.206812},
{0.785055,0.208705},
{0.785089,0.210656},
{0.785166,0.21284},
{0.785589,0.212853},
{0.786051,0.212923},
{0.78662,0.21308},
{0.786692,0.21531},
{0.786882,0.218253},
{0.78711,0.221887},
{0.787293,0.226191},
{0.787479,0.231153},
{0.787717,0.236764},
{0.788974,0.236687},
{0.790519,0.236475},
{0.792483,0.236169},
{0.794996,0.23581},
{0.798064,0.235325},
{0.833566,0.241612},
{0.841617,0.233894},
{0.842674,0.242747},
{0.834171,0.250254},
{0.843136,0.251726},
{0.832384,0.233065},
{0.825601,0.24104},
{0.826294,0.24938},
{0.826595,0.257863},
{0.834494,0.25919},
{0.843072,0.260766},
{0.815912,0.225584},
{0.820808,0.217736},
{0.82275,0.225002},
{0.817419,0.233018},
{0.824383,0.232842},
{0.811299,0.233386},
{0.812379,0.240882},
{0.818632,0.240903},
{0.833602,0.276706},
{0.842555,0.269804},
{0.841601,0.278714},
{0.832568,0.285233},
{0.840229,0.287369},
{0.852787,0.263072},
{0.834159,0.267914},
{0.826349,0.275097},
{0.825672,0.283513},
{0.824675,0.291785},
{0.831313,0.293669},
{0.819724,0.257087},
{0.819915,0.265457},
{0.826635,0.266491},
{0.81933,0.248899},
{0.813102,0.248606},
{0.813581,0.256555},
{0.813931,0.26473},
{0.814071,0.272959},
{0.819879,0.273882},
{0.808976,0.272295},
{0.808673,0.26425},
{0.808387,0.256372},
{0.804133,0.263957},
{0.804488,0.27181},
{0.804693,0.279631},
{0.80899,0.280248},
{0.803105,0.248653},
{0.799821,0.256208},
{0.799265,0.248861},
{0.802452,0.241432},
{0.798705,0.241873},
{0.796022,0.248993},
{0.796502,0.256166},
{0.796976,0.263597},
{0.800253,0.263768},
{0.803661,0.256196},
{0.807673,0.248518},
{0.806997,0.241075},
{0.806047,0.233931},
{0.801692,0.234637},
{0.795524,0.242175},
{0.793358,0.2491},
{0.79392,0.256207},
{0.794246,0.263453},
{0.794722,0.270932},
{0.797413,0.271166},
{0.800667,0.271465},
{0.818826,0.290314},
{0.817945,0.298403},
{0.82343,0.299962},
{0.819475,0.282146},
{0.813916,0.281072},
{0.813532,0.289103},
{0.81298,0.297085},
{0.812196,0.304978},
{0.816817,0.306395},
{0.821882,0.308017},
{0.81532,0.314223},
{0.813559,0.321962},
{0.811576,0.329631},
{0.81273,0.339236},
{0.813228,0.349375},
{0.813079,0.360026},
{0.808251,0.328008},
{0.803895,0.333986},
{0.805318,0.32661},
{0.809789,0.320411},
{0.806493,0.319123},
{0.802697,0.325401},
{0.80161,0.33265},
{0.800188,0.339705},
{0.802158,0.341198},
{0.804366,0.342858},
{0.806458,0.335502},
{0.811118,0.312744},
{0.80737,0.311489},
{0.8035,0.317992},
{0.800296,0.32433},
{0.799497,0.331436},
{0.798362,0.338312},
{0.79692,0.344681},
{0.798479,0.346347},
{0.800148,0.347918},
{0.802028,0.349832},
{0.804208,0.351858},
{0.806896,0.344739},
{0.809375,0.337239},
{0.809831,0.346893},
{0.80973,0.356895},
{0.808824,0.36727},
{0.80438,0.373717},
{0.801863,0.383301},
{0.79804,0.392484},
{0.799682,0.398105},
{0.792424,0.400985},
{0.785085,0.40867},
{0.777144,0.40775},
{0.776774,0.415692},
{0.776881,0.425024},
{0.777344,0.435593},
{0.77804,0.447248},
{0.785001,0.448609},
{0.791962,0.447247},
{0.798928,0.44435},
{0.804071,0.310456},
{0.800816,0.317032},
{0.80113,0.309597},
{0.80445,0.302829},
{0.801269,0.302057},
{0.798452,0.308863},
{0.798334,0.316191},
{0.798023,0.323348},
{0.808078,0.303793},
{0.80855,0.296001},
{0.804675,0.295145},
{0.801279,0.294464},
{0.798422,0.301416},
{0.796026,0.308252},
{0.796032,0.315448},
{0.795869,0.322475},
{0.795474,0.329222},
{0.79746,0.330285},
{0.796586,0.336952},
{0.795437,0.343143},
{0.794047,0.348648},
{0.79526,0.350473},
{0.796531,0.352358},
{0.797923,0.354271},
{0.799501,0.356177},
{0.801319,0.358316},
{0.803435,0.360927},
{0.806719,0.354214},
{0.808953,0.288188},
{0.804754,0.287411},
{0.801215,0.286835},
{0.79829,0.293902},
{0.79591,0.300898},
{0.793843,0.307758},
{0.793899,0.31486},
{0.793824,0.32173},
{0.793584,0.328338},
{0.793144,0.334656},
{0.794851,0.335707},
{0.793938,0.341513},
{0.792884,0.346835},
{0.791596,0.351143},
{0.792466,0.353354},
{0.793404,0.355446},
{0.794408,0.35761},
{0.79553,0.359696},
{0.796806,0.361814},
{0.798282,0.364095},
{0.799988,0.366927},
{0.802012,0.370149},
{0.805915,0.363936},
{0.800973,0.279155},
{0.797778,0.278756},
{0.798071,0.286342},
{0.795678,0.293452},
{0.793676,0.300484},
{0.791851,0.307384},
{0.791917,0.314397},
{0.791893,0.321163},
{0.791751,0.32767},
{0.791471,0.333908},
{0.791082,0.339461},
{0.792529,0.340323},
{0.791762,0.344982},
{0.790797,0.348692},
{0.789588,0.351512},
{0.790123,0.354523},
{0.790742,0.357144},
{0.79143,0.359564},
{0.792173,0.361974},
{0.793007,0.36435},
{0.793968,0.366665},
{0.795085,0.36917},
{0.796387,0.372111},
{0.797925,0.375441},
{0.799747,0.379113},
{0.785182,0.386784},
{0.789464,0.382019},
{0.790109,0.38585},
{0.7852,0.391132},
{0.790839,0.390189},
{0.794974,0.383232},
{0.793757,0.379209},
{0.792678,0.376108},
{0.788903,0.37855},
{0.785139,0.382805},
{0.780792,0.382019},
{0.780222,0.38585},
{0.779525,0.390189},
{0.785182,0.396131},
{0.791655,0.395182},
{0.79641,0.387443},
{0.791788,0.373022},
{0.788428,0.375429},
{0.785089,0.379382},
{0.781261,0.37855},
{0.777453,0.376099},
{0.776437,0.379189},
{0.775281,0.38322},
{0.773864,0.387406},
{0.778676,0.395182},
{0.785137,0.401841},
{0.785021,0.373405},
{0.787719,0.370006},
{0.78804,0.372645},
{0.785044,0.376198},
{0.79103,0.370389},
{0.790399,0.367516},
{0.787447,0.367322},
{0.785015,0.370633},
{0.782305,0.370006},
{0.782001,0.372645},
{0.781655,0.375429},
{0.789357,0.362535},
{0.789846,0.365272},
{0.787206,0.364536},
{0.788904,0.359922},
{0.78698,0.361593},
{0.785012,0.362151},
{0.785013,0.365177},
{0.785012,0.368035},
{0.782574,0.367322},
{0.779624,0.36749},
{0.779004,0.370377},
{0.778282,0.372986},
{0.328129,0.0707093},
{0.333407,0.0717162},
{0.338353,0.073136},
{0.342872,0.0750467},
{0.34658,0.0779631},
{0.349211,0.0822056},
{0.356511,0.0834695},
{0.357415,0.0900892},
{0.322727,0.06988},
{0.317212,0.069269},
{0.321253,0.0739681},
{0.326097,0.0748964},
{0.330767,0.0760754},
{0.335097,0.0776764},
{0.338922,0.0798703},
{0.3421,0.0827969},
{0.34449,0.0865964},
{0.350967,0.0874508},
{0.351965,0.093156},
{0.315347,0.0772123},
{0.31119,0.0729084},
{0.316272,0.0733017},
{0.319836,0.0779118},
{0.311647,0.0688385},
{0.306037,0.0686892},
{0.306057,0.0727807},
{0.310742,0.0768041},
{0.314469,0.0809239},
{0.318505,0.0816505},
{0.322362,0.0827162},
{0.324158,0.0789241},
{0.328275,0.0802421},
{0.332053,0.0819921},
{0.335413,0.0842253},
{0.338229,0.0870591},
{0.340429,0.0905357},
{0.346188,0.0911047},
{0.34729,0.096158},
{0.352443,0.0992381},
{0.352429,0.105426},
{0.356878,0.110766},
{0.356024,0.117694},
{0.332265,0.0882344},
{0.33162,0.0946492},
{0.32939,0.0919511},
{0.329316,0.0859638},
{0.326761,0.0896834},
{0.326704,0.0954292},
{0.328689,0.0981336},
{0.330559,0.100876},
{0.333573,0.0975813},
{0.334785,0.090964},
{0.325991,0.0841392},
{0.32389,0.0877493},
{0.324493,0.0929929},
{0.324195,0.0983948},
{0.325578,0.101872},
{0.327864,0.104133},
{0.329439,0.106654},
{0.332175,0.103766},
{0.335118,0.100886},
{0.336827,0.0941659},
{0.321948,0.0910547},
{0.322344,0.095943},
{0.320167,0.0940065},
{0.319123,0.0895598},
{0.317682,0.0925478},
{0.318552,0.0965561},
{0.320407,0.0983381},
{0.321853,0.100574},
{0.32068,0.0862722},
{0.317252,0.0851693},
{0.316073,0.0884535},
{0.314989,0.0914571},
{0.316389,0.0951732},
{0.317083,0.0987829},
{0.318584,0.100407},
{0.319753,0.102283},
{0.320233,0.104508},
{0.322494,0.103217},
{0.323878,0.106193},
{0.325569,0.107435},
{0.326982,0.109472},
{0.330668,0.109399},
{0.3334,0.106914},
{0.336358,0.104372},
{0.339607,0.101766},
{0.338423,0.0977849},
{0.342067,0.0945822},
{0.313619,0.0844511},
{0.312852,0.0877075},
{0.312132,0.0907148},
{0.314021,0.0941342},
{0.31521,0.0975087},
{0.315743,0.100766},
{0.31706,0.102168},
{0.317966,0.103838},
{0.318388,0.105743},
{0.318252,0.107852},
{0.31998,0.106953},
{0.321935,0.106217},
{0.322146,0.109572},
{0.323505,0.110594},
{0.324642,0.112249},
{0.328093,0.111836},
{0.331561,0.112373},
{0.334295,0.110271},
{0.337216,0.108155},
{0.340405,0.106013},
{0.343933,0.103831},
{0.343226,0.0990447},
{0.30951,0.0872934},
{0.309163,0.0903009},
{0.311497,0.0934219},
{0.313147,0.0965392},
{0.314132,0.0996223},
{0.314552,0.102547},
{0.315665,0.103792},
{0.316443,0.10527},
{0.316808,0.106963},
{0.316736,0.108826},
{0.316279,0.110815},
{0.317672,0.110085},
{0.319103,0.109574},
{0.32068,0.109273},
{0.320415,0.1125},
{0.321505,0.113426},
{0.322482,0.114774},
{0.325652,0.114196},
{0.328949,0.114432},
{0.332224,0.115487},
{0.334919,0.113791},
{0.337765,0.112099},
{0.340843,0.110433},
{0.344247,0.10877},
{0.348066,0.107086},
{0.347886,0.101553},
{0.352173,0.111719},
{0.351466,0.117985},
{0.354966,0.124574},
{0.353771,0.131359},
{0.348595,0.136458},
{0.347202,0.142222},
{0.345659,0.147621},
{0.343841,0.152613},
{0.350681,0.124263},
{0.347496,0.118425},
{0.34687,0.124125},
{0.349668,0.130446},
{0.347909,0.112722},
{0.344257,0.113836},
{0.344001,0.118983},
{0.343542,0.124147},
{0.346073,0.129751},
{0.345099,0.135219},
{0.34098,0.114984},
{0.340871,0.119626},
{0.340539,0.124282},
{0.342886,0.129239},
{0.34205,0.134187},
{0.34101,0.138912},
{0.343939,0.140446},
{0.342563,0.14537},
{0.340944,0.149928},
{0.339055,0.154019},
{0.338021,0.120348},
{0.337783,0.124532},
{0.340003,0.128877},
{0.339269,0.133345},
{0.33834,0.137621},
{0.337202,0.141659},
{0.33977,0.143373},
{0.338295,0.147527},
{0.336552,0.15125},
{0.334543,0.154481},
{0.336871,0.157544},
{0.33438,0.160455},
{0.333596,0.166563},
{0.330187,0.168329},
{0.328141,0.174172},
{0.335275,0.117431},
{0.338011,0.116212},
{0.332626,0.118716},
{0.329598,0.117168},
{0.330026,0.120008},
{0.332799,0.122007},
{0.335365,0.121146},
{0.330231,0.154188},
{0.330289,0.149285},
{0.332361,0.151739},
{0.332241,0.157145},
{0.334229,0.148804},
{0.331985,0.146576},
{0.3299,0.144661},
{0.328289,0.147085},
{0.3283,0.151519},
{0.327837,0.156117},
{0.329655,0.159229},
{0.331572,0.162705},
{0.329115,0.140484},
{0.33129,0.141914},
{0.33352,0.143557},
{0.332476,0.138886},
{0.330214,0.137781},
{0.32797,0.136862},
{0.326962,0.139262},
{0.327815,0.142939},
{0.326339,0.145129},
{0.326459,0.149144},
{0.326098,0.153322},
{0.325196,0.157583},
{0.32678,0.160783},
{0.32847,0.164371},
{0.335855,0.136536},
{0.334785,0.140175},
{0.335837,0.145415},
{0.334274,0.132167},
{0.332414,0.128603},
{0.334853,0.12857},
{0.336688,0.132676},
{0.33735,0.128656},
{0.335215,0.124879},
{0.332716,0.125323},
{0.330185,0.125845},
{0.329938,0.128741},
{0.331873,0.131802},
{0.333477,0.135622},
{0.330218,0.122917},
{0.327653,0.123857},
{0.327638,0.126427},
{0.32746,0.128966},
{0.329482,0.131567},
{0.33115,0.134873},
{0.326592,0.169592},
{0.322725,0.170376},
{0.325097,0.165529},
{0.321517,0.166256},
{0.318703,0.170758},
{0.305978,0.175598},
{0.310292,0.170901},
{0.310588,0.175636},
{0.305963,0.181062},
{0.315157,0.175635},
{0.314526,0.171011},
{0.313947,0.166772},
{0.310009,0.166811},
{0.306001,0.170931},
{0.301717,0.1709},
{0.301378,0.175635},
{0.301035,0.181089},
{0.316916,0.162998},
{0.317791,0.166629},
{0.320353,0.162619},
{0.319268,0.159353},
{0.316093,0.15977},
{0.313368,0.163192},
{0.309733,0.163248},
{0.306027,0.166804},
{0.302048,0.166809},
{0.298121,0.166773},
{0.297501,0.171018},
{0.29683,0.175639},
{0.296167,0.181126},
{0.306058,0.160122},
{0.309185,0.157292},
{0.309456,0.160095},
{0.306048,0.163267},
{0.312815,0.159987},
{0.312265,0.157195},
{0.311754,0.154616},
{0.308928,0.154779},
{0.306066,0.157339},
{0.302955,0.157289},
{0.302666,0.160092},
{0.302366,0.163246},
{0.313766,0.151921},
{0.314521,0.154298},
{0.315301,0.156889},
{0.3172,0.153794},
{0.316199,0.1514},
{0.31524,0.149178},
{0.313046,0.149683},
{0.311253,0.152266},
{0.308689,0.152454},
{0.306079,0.154821},
{0.303242,0.154776},
{0.300446,0.154611},
{0.299902,0.157192},
{0.299321,0.159983},
{0.29874,0.163194},
{0.321026,0.155711},
{0.322321,0.158643},
{0.32367,0.161905},
{0.323624,0.154676},
{0.322174,0.152095},
{0.31976,0.153077},
{0.318221,0.156426},
{0.322777,0.148528},
{0.320718,0.149739},
{0.32118,0.146486},
{0.319328,0.147612},
{0.318529,0.150689},
{0.324414,0.150799},
{0.324652,0.147},
{0.322881,0.145094},
{0.321161,0.143403},
{0.319643,0.144662},
{0.317971,0.145676},
{0.317341,0.148498},
{0.308364,0.0977245},
{0.30994,0.10012},
{0.308152,0.0997757},
{0.306267,0.0976107},
{0.306308,0.0996694},
{0.307953,0.101667},
{0.309524,0.101977},
{0.310995,0.102511},
{0.311621,0.100712},
{0.310407,0.0980901},
{0.308597,0.0954824},
{0.306221,0.095365},
{0.304176,0.0977301},
{0.304469,0.0997811},
{0.304725,0.101672},
{0.306337,0.101568},
{0.307771,0.103422},
{0.309137,0.103721},
{0.310441,0.10417},
{0.311608,0.104832},
{0.312339,0.103247},
{0.313165,0.101531},
{0.312342,0.0987265},
{0.310913,0.0958802},
{0.308861,0.0930192},
{0.306176,0.0928966},
{0.303852,0.0954881},
{0.302145,0.0981015},
{0.302688,0.100131},
{0.303167,0.101988},
{0.303604,0.10373},
{0.304952,0.103426},
{0.306357,0.10334},
{0.307608,0.105066},
{0.308807,0.105314},
{0.309933,0.105735},
{0.310951,0.106325},
{0.311826,0.107083},
{0.312629,0.105664},
{0.313525,0.104166},
{0.306138,0.0901775},
{0.3035,0.093025},
{0.301555,0.095892},
{0.300227,0.0987438},
{0.301024,0.100728},
{0.301713,0.102527},
{0.302324,0.104185},
{0.302882,0.105749},
{0.30398,0.105323},
{0.305156,0.10507},
{0.306377,0.104986},
{0.307463,0.10662},
{0.308499,0.106848},
{0.309475,0.107218},
{0.310354,0.107749},
{0.31111,0.108429},
{0.3117,0.109267},
{0.312522,0.108003},
{0.313406,0.106707},
{0.314481,0.105282},
{0.315135,0.10661},
{0.315455,0.108122},
{0.315412,0.10979},
{0.315059,0.111569},
{0.314451,0.113413},
{0.315557,0.112846},
{0.316758,0.112365},
{0.318001,0.112075},
{0.319233,0.112085},
{0.317699,0.114652},
{0.318672,0.115116},
{0.319581,0.115961},
{0.320403,0.117135},
{0.323321,0.116454},
{0.326434,0.116443},
{0.314266,0.109244},
{0.314249,0.110744},
{0.313923,0.112373},
{0.313437,0.114031},
{0.312762,0.115719},
{0.313665,0.115263},
{0.314627,0.114878},
{0.315646,0.114601},
{0.31668,0.11451},
{0.314002,0.107876},
{0.313005,0.109084},
{0.313245,0.110315},
{0.313214,0.111685},
{0.312955,0.113151},
{0.312512,0.114671},
{0.311927,0.116209},
{0.311987,0.117374},
{0.312778,0.117062},
{0.31361,0.116827},
{0.314473,0.116703},
{0.315339,0.116737},
{0.316183,0.116973},
{0.31699,0.117456},
{0.317745,0.11823},
{0.31843,0.119254},
{0.32111,0.118566},
{0.324016,0.118371},
{0.327043,0.11882},
{0.327417,0.121318},
{0.322183,0.121971},
{0.324938,0.12259},
{0.322525,0.123834},
{0.319947,0.123412},
{0.32025,0.125017},
{0.322715,0.125751},
{0.325138,0.124807},
{0.324559,0.12043},
{0.321704,0.120201},
{0.319534,0.121891},
{0.317535,0.123409},
{0.317875,0.124728},
{0.318153,0.126095},
{0.320426,0.126671},
{0.322753,0.127687},
{0.325162,0.127043},
{0.318293,0.127539},
{0.320476,0.128341},
{0.318356,0.128969},
{0.316336,0.128325},
{0.316393,0.129558},
{0.318295,0.13039},
{0.320399,0.129992},
{0.322647,0.129606},
{0.316198,0.127095},
{0.314484,0.127927},
{0.314587,0.129002},
{0.314641,0.130066},
{0.314622,0.131111},
{0.316359,0.130771},
{0.316251,0.131957},
{0.318161,0.131768},
{0.320198,0.131609},
{0.322389,0.131485},
{0.324697,0.131426},
{0.325015,0.129259},
{0.314301,0.126888},
{0.31283,0.127706},
{0.312974,0.128618},
{0.313074,0.129545},
{0.313125,0.130472},
{0.313117,0.131385},
{0.313073,0.132287},
{0.314568,0.132131},
{0.314453,0.133137},
{0.316087,0.13311},
{0.317899,0.133116},
{0.319875,0.133171},
{0.321987,0.133296},
{0.324208,0.133514},
{0.326498,0.13384},
{0.327036,0.131449},
{0.328818,0.134286},
{0.315988,0.125891},
{0.315701,0.12475},
{0.314068,0.125891},
{0.312636,0.126836},
{0.311413,0.127572},
{0.311563,0.12835},
{0.311721,0.129123},
{0.311773,0.129967},
{0.311835,0.130777},
{0.311818,0.1316},
{0.31183,0.132411},
{0.311758,0.133237},
{0.313013,0.133181},
{0.312942,0.134073},
{0.314322,0.13412},
{0.315868,0.134229},
{0.317584,0.134412},
{0.319444,0.134667},
{0.321447,0.135024},
{0.323563,0.135501},
{0.32574,0.136109},
{0.317095,0.122209},
{0.315334,0.123708},
{0.319027,0.12049},
{0.316611,0.121124},
{0.314904,0.122779},
{0.313408,0.124157},
{0.313759,0.124984},
{0.312383,0.126035},
{0.311197,0.126867},
{0.310193,0.127488},
{0.310365,0.128127},
{0.310488,0.128823},
{0.31058,0.129551},
{0.310656,0.130282},
{0.310701,0.131018},
{0.310699,0.131762},
{0.310682,0.13252},
{0.310681,0.133298},
{0.310691,0.134104},
{0.311744,0.134078},
{0.311717,0.13493},
{0.312865,0.134972},
{0.314157,0.135091},
{0.315598,0.135312},
{0.317187,0.13564},
{0.318921,0.136082},
{0.320788,0.136652},
{0.322774,0.137363},
{0.324844,0.138228},
{0.312997,0.12345},
{0.311761,0.124654},
{0.312087,0.125306},
{0.310993,0.126172},
{0.309993,0.126895},
{0.309161,0.127392},
{0.309322,0.127942},
{0.309465,0.128523},
{0.309557,0.129168},
{0.309629,0.129838},
{0.309687,0.130513},
{0.309728,0.13119},
{0.309725,0.131885},
{0.309721,0.132607},
{0.309731,0.133357},
{0.309763,0.134148},
{0.309793,0.134984},
{0.310708,0.134943},
{0.310788,0.135834},
{0.311806,0.135829},
{0.31283,0.135856},
{0.314009,0.136011},
{0.315289,0.136318},
{0.316734,0.136784},
{0.31829,0.137388},
{0.32,0.138151},
{0.321841,0.139072},
{0.323753,0.140161},
{0.325781,0.141454},
{0.324418,0.143407},
{0.314426,0.121976},
{0.316019,0.120234},
{0.313905,0.121325},
{0.312564,0.122851},
{0.311405,0.124096},
{0.310424,0.125069},
{0.310698,0.125609},
{0.309787,0.126336},
{0.308999,0.126869},
{0.308304,0.127244},
{0.308418,0.12775},
{0.308539,0.128271},
{0.308646,0.128824},
{0.30872,0.129424},
{0.308776,0.130051},
{0.30883,0.13068},
{0.308863,0.131322},
{0.30886,0.131982},
{0.30885,0.132673},
{0.308861,0.133404},
{0.308888,0.134185},
{0.308927,0.135027},
{0.309009,0.135948},
{0.309885,0.135895},
{0.310065,0.136883},
{0.310985,0.136794},
{0.311925,0.136727},
{0.312883,0.136704},
{0.313884,0.136829},
{0.314953,0.137205},
{0.316151,0.137793},
{0.317536,0.138555},
{0.319082,0.139491},
{0.320763,0.140603},
{0.322551,0.141904},
{0.319544,0.141933},
{0.318189,0.143041},
{0.316715,0.143946},
{0.316206,0.146495},
{0.316651,0.139556},
{0.318029,0.140652},
{0.315455,0.138642},
{0.314472,0.137911},
{0.314573,0.139291},
{0.315624,0.140367},
{0.316842,0.141612},
{0.314325,0.147121},
{0.315136,0.144671},
{0.313469,0.14523},
{0.312366,0.147588},
{0.315541,0.142393},
{0.306148,0.150273},
{0.30828,0.148083},
{0.308474,0.150216},
{0.306104,0.152508},
{0.310783,0.150025},
{0.31034,0.147905},
{0.309932,0.145915},
{0.308106,0.146072},
{0.306205,0.148138},
{0.304138,0.148079},
{0.303834,0.150212},
{0.303533,0.152451},
{0.311135,0.143839},
{0.309557,0.144075},
{0.310597,0.142189},
{0.309217,0.142384},
{0.307952,0.144205},
{0.311727,0.145639},
{0.31267,0.143492},
{0.311943,0.141903},
{0.311313,0.140464},
{0.310123,0.140685},
{0.308926,0.140865},
{0.307817,0.142499},
{0.306336,0.144246},
{0.306268,0.14612},
{0.304436,0.146068},
{0.302623,0.145908},
{0.302105,0.147899},
{0.301555,0.150019},
{0.301006,0.152261},
{0.307698,0.140944},
{0.306403,0.142535},
{0.306464,0.140984},
{0.307595,0.139532},
{0.306517,0.13956},
{0.305428,0.139528},
{0.305225,0.140941},
{0.304987,0.142495},
{0.308664,0.139451},
{0.308459,0.138193},
{0.307506,0.138251},
{0.306553,0.138275},
{0.305588,0.138248},
{0.304601,0.13819},
{0.304331,0.139446},
{0.303972,0.140861},
{0.303577,0.142378},
{0.304721,0.144201},
{0.303119,0.144071},
{0.301542,0.143832},
{0.300844,0.145632},
{0.300103,0.147581},
{0.299331,0.149677},
{0.298534,0.151915},
{0.309409,0.13809},
{0.309727,0.139325},
{0.31078,0.139155},
{0.310365,0.137971},
{0.30917,0.136967},
{0.312462,0.140165},
{0.313246,0.141518},
{0.314145,0.143015},
{0.31448,0.141012},
{0.31358,0.139792},
{0.312809,0.138686},
{0.311817,0.138944},
{0.313142,0.137537},
{0.313725,0.138373},
{0.313826,0.137425},
{0.312265,0.137685},
{0.31132,0.137829},
{0.309071,0.108632},
{0.309354,0.110402},
{0.308712,0.109984},
{0.308234,0.108299},
{0.307992,0.109708},
{0.308387,0.111279},
{0.308931,0.111638},
{0.309401,0.1121},
{0.309908,0.110933},
{0.309827,0.109103},
{0.307341,0.108106},
{0.307235,0.109524},
{0.307786,0.111026},
{0.308099,0.112513},
{0.308554,0.112818},
{0.308954,0.113204},
{0.309269,0.113686},
{0.309772,0.11267},
{0.310326,0.111608},
{0.310474,0.109711},
{0.307144,0.110879},
{0.307597,0.112297},
{0.307061,0.112169},
{0.306483,0.110832},
{0.306508,0.11213},
{0.306984,0.113397},
{0.307431,0.113501},
{0.307849,0.113679},
{0.306454,0.109476},
{0.305827,0.110881},
{0.305956,0.112172},
{0.306064,0.113399},
{0.306524,0.113364},
{0.306913,0.114559},
{0.307282,0.114638},
{0.307632,0.114777},
{0.307954,0.114964},
{0.308231,0.113925},
{0.308569,0.114236},
{0.308839,0.114626},
{0.30902,0.115111},
{0.309483,0.114267},
{0.310022,0.113353},
{0.31064,0.112374},
{0.310987,0.110455},
{0.310772,0.113277},
{0.311338,0.111334},
{0.311507,0.11234},
{0.310749,0.11428},
{0.311475,0.113463},
{0.312326,0.111353},
{0.312124,0.110237},
{0.310138,0.114146},
{0.310108,0.115045},
{0.309955,0.116016},
{0.310562,0.115367},
{0.311273,0.114669},
{0.312294,0.112597},
{0.308701,0.116354},
{0.309101,0.115698},
{0.308668,0.116955},
{0.309071,0.116395},
{0.309579,0.114957},
{0.30863,0.115878},
{0.308466,0.115504},
{0.308311,0.116559},
{0.308384,0.116901},
{0.308339,0.117414},
{0.308218,0.118031},
{0.308556,0.117628},
{0.308951,0.117162},
{0.30955,0.115751},
{0.307897,0.117089},
{0.307952,0.116115},
{0.308155,0.11632},
{0.308059,0.117198},
{0.308237,0.115204},
{0.30771,0.115944},
{0.307709,0.116974},
{0.307687,0.117832},
{0.307866,0.117836},
{0.308074,0.117723},
{0.308173,0.117275},
{0.307943,0.118308},
{0.307799,0.118931},
{0.308068,0.118684},
{0.308387,0.11836},
{0.308764,0.117961},
{0.309415,0.116615},
{0.30704,0.116707},
{0.306849,0.115651},
{0.307152,0.115712},
{0.307276,0.116776},
{0.307441,0.11581},
{0.306533,0.11453},
{0.30654,0.115629},
{0.306794,0.116667},
{0.306943,0.117634},
{0.307137,0.117676},
{0.307326,0.117728},
{0.307501,0.116864},
{0.309892,0.117644},
{0.310933,0.115922},
{0.310488,0.117192},
{0.309444,0.118781},
{0.309968,0.11845},
{0.310567,0.118094},
{0.311165,0.116708},
{0.311677,0.115309},
{0.312057,0.113932},
{0.310277,0.116498},
{0.309375,0.118049},
{0.308992,0.119071},
{0.308988,0.119829},
{0.309416,0.119648},
{0.309938,0.119403},
{0.310518,0.11917},
{0.311245,0.117726},
{0.309203,0.117508},
{0.309703,0.117024},
{0.308376,0.121683},
{0.308505,0.120843},
{0.308872,0.120739},
{0.308728,0.121656},
{0.309302,0.120617},
{0.30859,0.120043},
{0.308201,0.120917},
{0.308095,0.121675},
{0.307971,0.122436},
{0.308255,0.122488},
{0.308588,0.12254},
{0.309137,0.121626},
{0.309797,0.120486},
{0.308604,0.119329},
{0.308275,0.120184},
{0.30827,0.119562},
{0.308003,0.120307},
{0.307951,0.120961},
{0.307511,0.121549},
{0.307584,0.120963},
{0.307748,0.120972},
{0.30766,0.121624},
{0.307793,0.120375},
{0.307594,0.120476},
{0.307454,0.120948},
{0.307401,0.121444},
{0.307298,0.122031},
{0.307407,0.122173},
{0.307551,0.122286},
{0.307848,0.121672},
{0.307737,0.122373},
{0.307645,0.123019},
{0.307882,0.123116},
{0.308138,0.123251},
{0.308466,0.123342},
{0.308964,0.122602},
{0.30961,0.121584},
{0.310347,0.120366},
{0.307537,0.120082},
{0.30743,0.12056},
{0.307264,0.120696},
{0.307201,0.121096},
{0.307334,0.120975},
{0.307746,0.119934},
{0.307986,0.119765},
{0.308194,0.119074},
{0.307905,0.119333},
{0.307661,0.119533},
{0.307347,0.120226},
{0.307121,0.120816},
{0.307065,0.121261},
{0.307045,0.121616},
{0.307168,0.121423},
{0.307272,0.121252},
{0.307317,0.121346},
{0.307222,0.121863},
{0.307117,0.122414},
{0.307205,0.12259},
{0.30731,0.122762},
{0.307481,0.122862},
{0.30853,0.118769},
{0.307174,0.123758},
{0.307236,0.12329},
{0.307385,0.123449},
{0.307315,0.123946},
{0.307567,0.123604},
{0.307126,0.123103},
{0.30706,0.123564},
{0.30699,0.123977},
{0.307091,0.124193},
{0.307199,0.124436},
{0.307466,0.124165},
{0.307771,0.123782},
{0.306668,0.123942},
{0.306568,0.124196},
{0.306568,0.123952},
{0.306648,0.123699},
{0.306569,0.123707},
{0.306489,0.123699},
{0.306468,0.123942},
{0.306442,0.124181},
{0.306568,0.124444},
{0.306694,0.124181},
{0.306785,0.123868},
{0.306737,0.123648},
{0.306708,0.123396},
{0.306633,0.123444},
{0.30657,0.12345},
{0.306506,0.123445},
{0.306428,0.123395},
{0.306398,0.123649},
{0.30635,0.123869},
{0.306304,0.124116},
{0.306412,0.124427},
{0.306568,0.12471},
{0.306724,0.124427},
{0.306831,0.124115},
{0.306906,0.123764},
{0.306848,0.123529},
{0.306804,0.123283},
{0.306763,0.123039},
{0.306682,0.123135},
{0.306622,0.123173},
{0.30657,0.123177},
{0.306518,0.123173},
{0.306455,0.123135},
{0.306371,0.123039},
{0.306329,0.123284},
{0.306286,0.12353},
{0.306228,0.123765},
{0.306143,0.123977},
{0.306239,0.124347},
{0.306376,0.124691},
{0.306337,0.124973},
{0.30657,0.124991},
{0.3068,0.124972},
{0.30676,0.12469},
{0.306896,0.124346},
{0.306978,0.123346},
{0.306919,0.123112},
{0.306862,0.122889},
{0.306822,0.122633},
{0.306733,0.122768},
{0.306672,0.12282},
{0.306615,0.122871},
{0.306571,0.12287},
{0.306525,0.122871},
{0.306465,0.12282},
{0.306402,0.122768},
{0.306309,0.122634},
{0.30627,0.12289},
{0.306213,0.123112},
{0.306154,0.123347},
{0.306072,0.123566},
{0.305955,0.123757},
{0.306041,0.124191},
{0.306169,0.124609},
{0.306079,0.124864},
{0.305999,0.125172},
{0.306296,0.125273},
{0.306571,0.125294},
{0.306845,0.125272},
{0.307138,0.12517},
{0.307056,0.124862},
{0.306966,0.124607},
{0.30666,0.122504},
{0.306724,0.122061},
{0.306721,0.122442},
{0.306803,0.12233},
{0.306807,0.121963},
{0.306823,0.121548},
{0.306736,0.121629},
{0.306663,0.122107},
{0.306612,0.122528},
{0.30693,0.122452},
{0.306912,0.122158},
{0.306976,0.122691},
{0.307043,0.122899},
{0.307077,0.122167},
{0.30704,0.121934},
{0.306916,0.121812},
{0.306936,0.121418},
{0.306975,0.120965},
{0.306861,0.121059},
{0.306762,0.121132},
{0.306669,0.121671},
{0.306613,0.122135},
{0.306571,0.12253},
{0.307177,0.121669},
{0.307185,0.11852},
{0.307345,0.118544},
{0.307508,0.117788},
{0.307023,0.118503},
{0.306868,0.118464},
{0.306934,0.119248},
{0.307074,0.119238},
{0.307219,0.119231},
{0.30738,0.119195},
{0.307527,0.118516},
{0.306753,0.119949},
{0.306676,0.11924},
{0.306801,0.119252},
{0.306864,0.119929},
{0.306707,0.118461},
{0.306552,0.118446},
{0.306555,0.119231},
{0.306652,0.119949},
{0.306713,0.120591},
{0.306806,0.120561},
{0.306988,0.119892},
{0.307119,0.119859},
{0.307273,0.119794},
{0.30745,0.119691},
{0.307572,0.119098},
{0.307712,0.118471},
{0.30718,0.12035},
{0.307036,0.120442},
{0.306914,0.120509},
{0.306692,0.121142},
{0.306616,0.121685},
{0.30657,0.122136},
{0.306527,0.122135},
{0.306529,0.122528},
{0.306478,0.122504},
{0.306413,0.122442},
{0.306327,0.12233},
{0.306214,0.122157},
{0.306198,0.122452},
{0.306153,0.122691},
{0.306086,0.1229},
{0.306003,0.123105},
{0.305892,0.123292},
{0.30574,0.123449},
{0.305812,0.123943},
{0.305933,0.124437},
{0.305809,0.124697},
{0.30566,0.124956},
{0.305507,0.125243},
{0.305904,0.125482},
{0.306252,0.125595},
{0.306573,0.125616},
{0.306891,0.125593},
{0.307234,0.125478},
{0.307625,0.125238},
{0.307473,0.124952},
{0.307324,0.124694},
{0.307643,0.12439},
{0.308003,0.123971},
{0.308267,0.124163},
{0.30911,0.123716},
{0.30854,0.124391},
{0.307849,0.124617},
{0.308062,0.124872},
{0.308798,0.124685},
{0.309439,0.123975},
{0.310211,0.123017},
{0.309797,0.122813},
{0.308764,0.123537},
{0.308251,0.125203},
{0.309052,0.125029},
{0.309801,0.124239},
{0.310618,0.123296},
{0.311621,0.122038},
{0.311117,0.121806},
{0.310616,0.121654},
{0.309374,0.122684},
{0.309313,0.125403},
{0.309565,0.125831},
{0.308637,0.125959},
{0.308832,0.126381},
{0.310099,0.124645},
{0.31102,0.123649},
{0.308441,0.125567},
{0.307896,0.125959},
{0.308041,0.126349},
{0.308182,0.12677},
{0.307762,0.125581},
{0.307325,0.125826},
{0.307428,0.126175},
{0.307511,0.126592},
{0.307604,0.12701},
{0.307031,0.126712},
{0.307075,0.127137},
{0.307681,0.127478},
{0.30777,0.127949},
{0.307832,0.128484},
{0.307904,0.129021},
{0.307963,0.129593},
{0.308026,0.130172},
{0.308058,0.130789},
{0.308083,0.131411},
{0.308078,0.132051},
{0.308079,0.132729},
{0.308059,0.133441},
{0.308074,0.134224},
{0.308107,0.135068},
{0.308194,0.136023},
{0.308294,0.137039},
{0.311178,0.118914},
{0.311851,0.118752},
{0.312571,0.118629},
{0.313292,0.118629},
{0.314028,0.118739},
{0.314719,0.119043},
{0.315401,0.119521},
{0.311553,0.120254},
{0.312158,0.120337},
{0.312755,0.120533},
{0.313343,0.120853},
{0.310941,0.120277},
{0.310099,0.121599},
{0.312096,0.122393},
{0.307373,0.136047},
{0.306571,0.137113},
{0.306576,0.136071},
{0.307331,0.135104},
{0.306576,0.13512},
{0.305816,0.135102},
{0.305771,0.136044},
{0.305698,0.13709},
{0.307432,0.137092},
{0.307311,0.13425},
{0.30658,0.134265},
{0.305847,0.134248},
{0.305073,0.134221},
{0.305026,0.135065},
{0.304924,0.136021},
{0.304808,0.137035},
{0.307335,0.132755},
{0.306601,0.133484},
{0.306627,0.132768},
{0.307353,0.132089},
{0.306648,0.1321},
{0.305928,0.132089},
{0.305907,0.132754},
{0.305879,0.13347},
{0.307317,0.133471},
{0.307359,0.131458},
{0.306658,0.131471},
{0.30594,0.131458},
{0.305171,0.13141},
{0.305165,0.13205},
{0.305131,0.132727},
{0.305119,0.133439},
{0.307229,0.129117},
{0.307189,0.128585},
{0.307152,0.128077},
{0.306576,0.1281},
{0.306579,0.128608},
{0.306589,0.129137},
{0.30661,0.129691},
{0.307272,0.129673},
{0.307344,0.130845},
{0.307312,0.13025},
{0.306651,0.13086},
{0.13935,0.908058},
{0.134195,0.901237},
{0.139096,0.903949},
{0.144132,0.910537},
{0.144029,0.906639},
{0.139456,0.900376},
{0.134741,0.897372},
{0.130241,0.893971},
{0.129129,0.898373},
{0.134577,0.905902},
{0.140086,0.912228},
{0.144405,0.914555},
{0.149129,0.913086},
{0.149052,0.909116},
{0.149222,0.905584},
{0.144248,0.903151},
{0.140457,0.89769},
{0.136213,0.89472},
{0.132485,0.891376},
{0.129554,0.887578},
{0.125564,0.889706},
{0.123699,0.895227},
{0.129698,0.90423},
{0.135889,0.910954},
{0.140827,0.915509},
{0.144043,0.918207},
{0.149009,0.917325},
{0.154201,0.915372},
{0.154222,0.911191},
{0.1543,0.907493},
{0.154603,0.904388},
{0.149654,0.902633},
{0.144939,0.900364},
{0.142148,0.895798},
{0.138448,0.893043},
{0.136036,0.890326},
{0.134367,0.887351},
{0.135546,0.884898},
{0.129725,0.883978},
{0.120639,0.883074},
{0.11689,0.892871},
{0.123818,0.902577},
{0.131293,0.91039},
{0.138365,0.91609},
{0.142239,0.921006},
{0.148473,0.921539},
{0.154065,0.919928},
{0.15949,0.917049},
{0.159521,0.912655},
{0.159564,0.908772},
{0.159707,0.905499},
{0.159998,0.902756},
{0.155128,0.901813},
{0.150621,0.900264},
{0.14611,0.898197},
{0.147772,0.896569},
{0.144323,0.894454},
{0.141289,0.892103},
{0.139229,0.889727},
{0.138703,0.887534},
{0.140044,0.885674},
{0.143585,0.884294},
{0.139714,0.882944},
{0.135305,0.881226},
{0.131838,0.878135},
{0.119555,0.874052},
{0.107914,0.883317},
{0.107686,0.892374},
{0.117015,0.901716},
{0.125781,0.910193},
{0.134417,0.916914},
{0.139023,0.923355},
{0.147147,0.9256},
{0.153633,0.924761},
{0.159392,0.922002},
{0.164908,0.917961},
{0.164931,0.913298},
{0.164914,0.909241},
{0.164889,0.905837},
{0.164886,0.903014},
{0.164934,0.900704},
{0.16036,0.900525},
{0.155872,0.899706},
{0.151625,0.898352},
{0.153077,0.896863},
{0.149715,0.895351},
{0.146828,0.89357},
{0.144355,0.891615},
{0.142872,0.889691},
{0.142594,0.887918},
{0.143938,0.886455},
{0.146963,0.885372},
{0.151444,0.884714},
{0.148855,0.883424},
{0.146553,0.881808},
{0.143899,0.879469},
{0.142382,0.876212},
{0.130793,0.872665},
{0.120269,0.866429},
{0.108181,0.874745},
{0.096786,0.883912},
{0.0971181,0.892942},
{0.108312,0.901672},
{0.119001,0.91038},
{0.129384,0.917933},
{0.134421,0.925656},
{0.14469,0.929454},
{0.15272,0.92977},
{0.159112,0.927356},
{0.16481,0.923184},
{0.170476,0.91806},
{0.170462,0.913177},
{0.17035,0.908948},
{0.170124,0.905446},
{0.169841,0.902589},
{0.169522,0.900302},
{0.169228,0.898485},
{0.16506,0.898855},
{0.160903,0.898721},
{0.156834,0.898023},
{0.15801,0.896721},
{0.154658,0.895716},
{0.151731,0.894412},
{0.149258,0.892906},
{0.147269,0.891292},
{0.146096,0.889709},
{0.146072,0.888294},
{0.147301,0.887123},
{0.149892,0.886273},
{0.1536,0.885746},
{0.15818,0.885549},
{0.156831,0.884468},
{0.155382,0.883094},
{0.154067,0.881274},
{0.153115,0.878852},
{0.152681,0.875564},
{0.141911,0.871418},
{0.131392,0.865971},
{0.132855,0.859206},
{0.121683,0.859031},
{0.108883,0.866605},
{0.0967947,0.875132},
{0.0854873,0.884541},
{0.0862133,0.893782},
{0.0877784,0.903305},
{0.0985762,0.902431},
{0.110604,0.910968},
{0.122814,0.919083},
{0.128039,0.927803},
{0.140991,0.933351},
{0.151261,0.935128},
{0.158545,0.933098},
{0.164591,0.92893},
{0.170366,0.923597},
{0.176222,0.917525},
{0.176123,0.912347},
{0.175836,0.90793},
{0.175386,0.904373},
{0.174788,0.901559},
{0.174055,0.899375},
{0.173289,0.897692},
{0.172593,0.896381},
{0.16898,0.897078},
{0.165294,0.897417},
{0.161613,0.897323},
{0.162386,0.896229},
{0.159314,0.895721},
{0.156544,0.894823},
{0.153887,0.893703},
{0.15179,0.892423},
{0.150127,0.891088},
{0.149399,0.889835},
{0.149186,0.888644},
{0.150263,0.887713},
{0.152405,0.887035},
{0.155701,0.886656},
{0.159441,0.886434},
{0.163773,0.886424},
{0.163261,0.8856},
{0.162871,0.88458},
{0.162567,0.883249},
{0.162473,0.881465},
{0.162634,0.879165},
{0.1631,0.876},
{0.152923,0.871145},
{0.142759,0.865735},
{0.143978,0.859495},
{0.145903,0.852994},
{0.134933,0.852384},
{0.123864,0.851854},
{0.110412,0.858839},
{0.0977722,0.86684},
{0.085518,0.875598},
{0.0741371,0.885296},
{0.0748939,0.894749},
{0.0764646,0.904478},
{0.0788375,0.91443},
{0.0902652,0.913092},
{0.100917,0.911893},
{0.114385,0.920297},
{0.119479,0.929692},
{0.135046,0.93676},
{0.149189,0.941006},
{0.157862,0.939514},
{0.163817,0.942052},
{0.164202,0.935165},
{0.170134,0.92964},
{0.176107,0.923367},
{0.1822,0.916402},
{0.181969,0.910859},
{0.181457,0.906228},
{0.180693,0.902656},
{0.17969,0.899996},
{0.178503,0.897995},
{0.177253,0.89654},
{0.176104,0.895413},
{0.174978,0.894532},
{0.171875,0.895352},
{0.16869,0.895947},
{0.165519,0.896296},
{0.165617,0.895398},
{0.163056,0.895395},
{0.160663,0.894943},
{0.158405,0.894161},
{0.156251,0.893169},
{0.154394,0.892067},
{0.153028,0.890956},
{0.152207,0.889896},
{0.151987,0.888948},
{0.152664,0.88819},
{0.154534,0.887699},
{0.15729,0.8874},
{0.160621,0.887219},
{0.164346,0.887158},
{0.168282,0.887219},
{0.16824,0.886555},
{0.168468,0.885821},
{0.168984,0.884939},
{0.169807,0.883834},
{0.170879,0.882315},
{0.172139,0.880194},
{0.173454,0.877172},
{0.163844,0.871704},
{0.153756,0.865875},
{0.155102,0.860032},
{0.156818,0.853795},
{0.158766,0.847345},
{0.148121,0.846381},
{0.137378,0.84552},
{0.126431,0.844697},
{0.112575,0.851304},
{0.0990923,0.858667},
{0.0862863,0.86694},
{0.0741334,0.876091},
{0.0623407,0.886006},
{0.063082,0.895697},
{0.0645932,0.905625},
{0.0668206,0.915777},
{0.0695712,0.92607},
{0.0819002,0.924564},
{0.0936168,0.923053},
{0.104491,0.921619},
{0.109229,0.931423},
{0.114897,0.941377},
{0.126058,0.939316},
{0.144276,0.946157},
{0.157299,0.947012},
{0.163607,0.949759},
{0.16899,0.95067},
{0.169382,0.943223},
{0.169795,0.936242},
{0.175825,0.929761},
{0.182094,0.92262},
{0.188433,0.914725},
{0.188053,0.908764},
{0.187258,0.903875},
{0.186061,0.900335},
{0.184557,0.897875},
{0.182838,0.89623},
{0.181086,0.895118},
{0.179481,0.894259},
{0.177983,0.893585},
{0.176552,0.893027},
{0.173812,0.893813},
{0.171044,0.894517},
{0.168296,0.895068},
{0.167626,0.894269},
{0.165296,0.894634},
{0.16354,0.894808},
{0.162249,0.894352},
{0.160551,0.893621},
{0.158751,0.892741},
{0.157141,0.89178},
{0.155926,0.890828},
{0.155123,0.88993},
{0.154598,0.889115},
{0.154445,0.888544},
{0.156155,0.888344},
{0.158739,0.888138},
{0.1617,0.887953},
{0.16502,0.887847},
{0.168546,0.887843},
{0.171946,0.887898},
{0.172093,0.88736},
{0.172551,0.886801},
{0.173465,0.886184},
{0.17474,0.885491},
{0.176596,0.884712},
{0.178704,0.883641},
{0.18134,0.882035},
{0.183628,0.879378},
{0.17469,0.872951},
{0.164872,0.866541},
{0.166179,0.860875},
{0.167691,0.854773},
{0.169322,0.848399},
{0.171065,0.841846},
{0.160902,0.840754},
{0.150672,0.839697},
{0.140223,0.83866},
{0.129484,0.837611},
{0.115176,0.843851},
{0.101196,0.850787},
{0.0877733,0.858551},
{0.0749071,0.867161},
{0.0624228,0.876561},
{0.0500999,0.886673},
{0.0508158,0.896618},
{0.0523764,0.906836},
{0.0543934,0.917147},
{0.0568249,0.927608},
{0.0594861,0.938115},
{0.0726519,0.936422},
{0.0854682,0.934755},
{0.0977763,0.9331},
{0.102573,0.943229},
{0.121426,0.95145},
{0.134297,0.949331},
{0.143367,0.959541},
{0.158383,0.957471},
{0.163485,0.957875},
{0.168586,0.958278},
{0.174325,0.951168},
{0.174919,0.943769},
{0.175424,0.936598},
{0.18174,0.929392},
{0.188387,0.921483},
{0.194952,0.912947},
{0.194373,0.906084},
{0.193006,0.90076},
{0.191198,0.897382},
{0.18879,0.89557},
{0.186685,0.894304},
{0.184449,0.893608},
{0.182488,0.893038},
{0.180602,0.892628},
{0.179058,0.892228},
{0.177643,0.891861},
{0.175225,0.892514},
{0.172633,0.893176},
{0.170083,0.89378},
{0.168978,0.89305},
{0.16656,0.893514},
{0.164266,0.893912},
{0.162835,0.893169},
{0.161311,0.892345},
{0.159892,0.891486},
{0.158778,0.890637},
{0.157888,0.889819},
{0.157143,0.889053},
{0.159777,0.888873},
{0.162655,0.888686},
{0.165736,0.888533},
{0.168982,0.888456},
{0.172162,0.888416},
{0.175047,0.888376},
{0.174897,0.887958},
{0.175441,0.88754},
{0.176505,0.887111},
{0.177916,0.886664},
{0.179835,0.886208},
{0.182425,0.88575},
{0.185768,0.885279},
{0.189947,0.884782},
{0.193824,0.882843},
{0.185487,0.875022},
{0.175905,0.867824},
{0.17716,0.862083},
{0.178456,0.855922},
{0.179794,0.849534},
{0.181178,0.842995},
{0.172908,0.83523},
{0.163183,0.834096},
{0.153396,0.832973},
{0.143503,0.831854},
{0.133095,0.830647},
{0.118232,0.836498},
{0.103734,0.843021},
{0.0898102,0.850349},
{0.0763631,0.858462},
{0.0632565,0.867351},
{0.0503828,0.876998},
{0.037346,0.887254},
{0.0381335,0.897502},
{0.0397903,0.907988},
{0.0417345,0.918557},
{0.043877,0.929186},
{0.046129,0.93985},
{0.048463,0.95054},
{0.0623125,0.948689},
{0.0760116,0.946835},
{0.0894549,0.945022},
{0.0938029,0.955364},
{0.107837,0.953436},
{0.12835,0.961612},
{0.0831936,0.833131},
{0.0979736,0.82631},
{0.0949692,0.834236},
{0.08064,0.841498},
{0.0922284,0.842246},
{0.106719,0.835381},
{0.109916,0.827785},
{0.113318,0.820253},
{0.10111,0.818426},
{0.0859812,0.824842},
{0.0713718,0.832036},
{0.0689497,0.84075},
{0.0667415,0.849528},
{0.0783608,0.849946},
{0.121761,0.82926},
{0.125525,0.822081},
{0.0275564,0.867992},
{0.0413637,0.85824},
{0.0395431,0.867776},
{0.0254706,0.877775},
{0.0380099,0.877397},
{0.0515326,0.867595},
{0.053076,0.858287},
{0.0550607,0.849129},
{0.0433827,0.848763},
{0.0296423,0.858208},
{0.0647699,0.858368},
{0.0572193,0.840018},
{0.0595703,0.830974},
{0.0455111,0.839321},
{0.0358998,0.828857},
{0.0499867,0.820507},
{0.0477215,0.829905},
{0.0338139,0.838641},
{0.0619869,0.821944},
{0.0644869,0.812945},
{0.0522792,0.811117},
{0.0379856,0.819074},
{0.0795992,0.957313},
{0.0682843,0.969893},
{0.065268,0.959275},
{0.0508518,0.961248},
{0.0532679,0.971964},
{0.0833008,0.967823},
{0.0345347,0.952415},
{0.0326764,0.941606},
{0.030818,0.930797},
{0.0289597,0.919987},
{0.0271014,0.909178},
{0.025243,0.898368},
{0.0233847,0.887559},
{0.0363931,0.963225},
{0.166525,0.889217},
{0.163553,0.889416},
{0.160744,0.889636},
{0.164463,0.890141},
{0.167344,0.889883},
{0.170275,0.889653},
{0.169566,0.889059},
{0.162687,0.891182},
{0.161613,0.890402},
{0.165451,0.890866},
{0.163926,0.891968},
{0.166588,0.891594},
{0.168263,0.890549},
{0.171087,0.890242},
{0.173199,0.889438},
{0.172603,0.888931},
{0.177599,0.888277},
{0.175548,0.888797},
{0.176895,0.888004},
{0.178084,0.887768},
{0.179625,0.887454},
{0.181522,0.887164},
{0.183834,0.886914},
{0.186824,0.88674},
{0.190576,0.886863},
{0.19569,0.88736},
{0.204227,0.889538},
{0.207199,0.881175},
{0.196262,0.878048},
{0.186793,0.869587},
{0.188049,0.863576},
{0.189118,0.857223},
{0.190197,0.850747},
{0.191249,0.844167},
{0.182613,0.836384},
{0.174805,0.82857},
{0.165537,0.827404},
{0.156269,0.826239},
{0.147001,0.825073},
{0.137733,0.823908},
{0.17829,0.888625},
{0.176059,0.889223},
{0.178835,0.888992},
{0.180821,0.888387},
{0.179779,0.888059},
{0.173898,0.889945},
{0.174671,0.890451},
{0.177324,0.890086},
{0.176632,0.889654},
{0.180527,0.890144},
{0.178059,0.890514},
{0.175532,0.890952},
{0.178765,0.890932},
{0.180913,0.890542},
{0.183059,0.890301},
{0.18298,0.889852},
{0.179955,0.88975},
{0.179339,0.889369},
{0.176508,0.891425},
{0.174036,0.891975},
{0.172963,0.891413},
{0.171482,0.892532},
{0.167792,0.892323},
{0.16928,0.891217},
{0.170374,0.891878},
{0.171982,0.890832},
{0.165291,0.892733},
{0.251616,0.881396},
{0.261794,0.891202},
{0.251152,0.889321},
{0.241054,0.879608},
{0.240537,0.887434},
{0.25047,0.897416},
{0.261113,0.899336},
{0.27191,0.90129},
{0.272519,0.893097},
{0.262173,0.883167},
{0.251838,0.873616},
{0.2414,0.871986},
{0.2309,0.870351},
{0.230277,0.877863},
{0.229722,0.885518},
{0.239911,0.895495},
{0.24962,0.905675},
{0.260111,0.907566},
{0.270743,0.909505},
{0.281552,0.9115},
{0.282944,0.903285},
{0.283383,0.895026},
{0.272684,0.884973},
{0.262268,0.875239},
{0.251896,0.865945},
{0.241612,0.864496},
{0.231259,0.863052},
{0.22079,0.861631},
{0.220281,0.868713},
{0.219553,0.875974},
{0.218481,0.883549},
{0.229037,0.893625},
{0.228821,0.902115},
{0.239234,0.903823},
{0.248529,0.914103},
{0.258797,0.915892},
{0.269141,0.917796},
{0.279614,0.919704},
{0.29245,0.913524},
{0.294795,0.90538},
{0.294317,0.896973},
{0.283276,0.886757},
{0.272672,0.876865},
{0.262194,0.86738},
{0.251895,0.858314},
{0.241725,0.857066},
{0.23151,0.855821},
{0.221207,0.85459},
{0.210866,0.85334},
{0.210245,0.860192},
{0.209583,0.867035},
{0.208557,0.874023},
{0.217801,0.891691},
{0.21825,0.900655},
{0.218837,0.909908},
{0.228391,0.911003},
{0.2384,0.912359},
{0.237302,0.921049},
{0.247153,0.922635},
{0.257185,0.924317},
{0.267333,0.926085},
{0.277534,0.927929},
{0.290106,0.921668},
{0.272469,0.868821},
{0.283028,0.878508},
{0.262066,0.859557},
{0.251812,0.850729},
{0.24174,0.849691},
{0.23161,0.848663},
{0.221508,0.84761},
{0.211384,0.846521},
{0.201317,0.845361},
{0.200542,0.852037},
{0.199706,0.85869},
{0.198848,0.865275},
{0.197767,0.871743},
{0.192304,0.837547},
{0.184072,0.829736},
{0.282692,0.87028},
{0.293361,0.880159},
{0.292883,0.871752},
{0.282321,0.862071},
{0.272215,0.860805},
{0.261873,0.85177},
{0.251644,0.84319},
{0.241662,0.842366},
{0.231669,0.841541},
{0.22167,0.840707},
{0.211749,0.839788},
{0.201988,0.838708},
{0.19334,0.830901},
{0.23165,0.834455},
{0.221763,0.833843},
{0.211876,0.833232},
{0.202608,0.832067},
{0.241537,0.835066},
{0.251424,0.835678},
{0.26161,0.84402},
{0.26131,0.836289},
{0.271563,0.844854},
{0.271197,0.8369},
{0.281508,0.845691},
{0.281084,0.837512},
{0.291449,0.84653},
{0.290971,0.838123},
{0.251454,0.949771},
{0.239758,0.956997},
{0.241832,0.948396},
{0.243758,0.939817},
{0.232324,0.947102},
{0.230215,0.955744},
{0.228013,0.964386},
{0.237618,0.965614},
{0.249361,0.9583},
{0.261169,0.951233},
{0.25346,0.941274},
{0.245537,0.931241},
{0.234245,0.938458},
{0.223078,0.945992},
{0.220819,0.954568},
{0.218407,0.963157},
{0.263284,0.942818},
{0.275367,0.936174},
{0.273164,0.944439},
{0.270935,0.952718},
{0.283073,0.946099},
{0.285417,0.937955},
{0.287762,0.929811},
{0.265347,0.934443},
{0.255372,0.932794},
{0.203372,0.952649},
{0.214217,0.945011},
{0.211655,0.953493},
{0.199197,0.960699},
{0.208802,0.961928},
{0.225023,0.937297},
{0.216194,0.936433},
{0.206054,0.944354},
{0.196618,0.952164},
{0.194095,0.960296},
{0.235923,0.929784},
{0.226614,0.928591},
{0.227739,0.919747},
{0.217632,0.927742},
{0.209998,0.918704},
{0.218572,0.918919},
{0.209232,0.927376},
{0.209827,0.909849},
{0.208595,0.900534},
{0.202078,0.910979},
{0.202218,0.91924},
{0.201605,0.927541},
{0.200497,0.935798},
{0.207954,0.935917},
{0.198849,0.944006},
{0.190752,0.951885},
{0.188993,0.959892},
{0.179683,0.951437},
{0.186283,0.943888},
{0.185133,0.951659},
{0.17879,0.959085},
{0.183892,0.959489},
{0.192365,0.94393},
{0.193652,0.935946},
{0.187251,0.936235},
{0.180518,0.943883},
{0.173688,0.958681},
{0.194594,0.928087},
{0.195069,0.920256},
{0.187973,0.92875},
{0.198821,0.896537},
{0.200928,0.902842},
{0.19581,0.893769},
{0.189667,0.892441},
{0.187134,0.892133},
{0.184893,0.89187},
{0.182904,0.891654},
{0.181127,0.891487},
{0.1797,0.891277},
{0.181071,0.890877},
{0.182535,0.890834},
{0.184424,0.890832},
{0.185222,0.890147},
{0.185199,0.889657},
{0.184968,0.889209},
{0.182579,0.889453},
{0.18203,0.889086},
{0.181508,0.88873},
{0.18392,0.888497},
{0.183023,0.888154},
{0.181827,0.887802},
{0.191317,0.888886},
{0.189672,0.889872},
{0.18948,0.889201},
{0.189732,0.888483},
{0.188451,0.888818},
{0.187501,0.889418},
{0.187421,0.89002},
{0.186577,0.890836},
{0.188908,0.890855},
{0.191993,0.889656},
{0.192233,0.888511},
{0.190201,0.888032},
{0.187679,0.887908},
{0.187758,0.888341},
{0.187443,0.888627},
{0.186894,0.889029},
{0.191523,0.890829},
{0.194249,0.889291},
{0.19263,0.887824},
{0.189324,0.887476},
{0.186428,0.887461},
{0.183986,0.887586},
{0.185414,0.88797},
{0.185911,0.888357},
{0.186173,0.888719},
{0.18442,0.88885},
{0.196303,0.888694},
{0.198107,0.890529},
{0.192542,0.892938},
{0.786539,0.350223},
{0.788183,0.353462},
{0.786631,0.354562},
{0.785002,0.350449},
{0.785005,0.3549},
{0.786783,0.358323},
{0.788497,0.356608},
{0.787996,0.349408},
{0.786524,0.345221},
{0.785001,0.345381},
{0.783466,0.350223},
{0.783379,0.354562},
{0.783234,0.358324},
{0.785008,0.358654},
{0.789604,0.339249},
{0.789836,0.333574},
{0.790008,0.32732},
{0.788318,0.327173},
{0.788221,0.333507},
{0.788089,0.339284},
{0.789354,0.344006},
{0.79061,0.343802},
{0.787993,0.344758},
{0.789283,0.348032},
{0.786557,0.33964},
{0.785001,0.339684},
{0.783479,0.345221},
{0.78201,0.349388},
{0.781827,0.353449},
{0.781517,0.356582},
{0.781113,0.359904},
{0.783041,0.361593},
{0.785007,0.313785},
{0.786665,0.32057},
{0.785002,0.320556},
{0.783339,0.32057},
{0.783349,0.32715},
{0.785002,0.32716},
{0.786656,0.32715},
{0.788351,0.320648},
{0.788331,0.313885},
{0.786649,0.313822},
{0.785017,0.306887},
{0.783363,0.313822},
{0.781684,0.313864},
{0.781653,0.320632},
{0.781687,0.327144},
{0.781783,0.333492},
{0.783394,0.333561},
{0.785002,0.333618},
{0.78661,0.333561},
{0.78826,0.30698},
{0.78986,0.299983},
{0.789998,0.307132},
{0.790072,0.314092},
{0.791689,0.300181},
{0.791434,0.292848},
{0.789661,0.292685},
{0.788169,0.299859},
{0.786615,0.306905},
{0.785121,0.292547},
{0.786538,0.285188},
{0.78656,0.292554},
{0.785051,0.299806},
{0.78658,0.299817},
{0.788051,0.292594},
{0.787948,0.285224},
{0.787777,0.277816},
{0.786495,0.277788},
{0.785198,0.285179},
{0.783827,0.285188},
{0.783664,0.292554},
{0.78352,0.299817},
{0.789431,0.285299},
{0.789204,0.277887},
{0.788956,0.270503},
{0.787613,0.270453},
{0.78642,0.270422},
{0.785261,0.277784},
{0.78398,0.277788},
{0.782589,0.277818},
{0.782328,0.285223},
{0.782132,0.292592},
{0.781923,0.299852},
{0.783422,0.306905},
{0.781777,0.306969},
{0.780031,0.30709},
{0.779938,0.314033},
{0.779923,0.320761},
{0.779997,0.327259},
{0.780169,0.333512},
{0.7804,0.339187},
{0.781915,0.339261},
{0.783446,0.33964},
{0.793103,0.285654},
{0.793416,0.293102},
{0.795476,0.285969},
{0.795061,0.278433},
{0.792774,0.278187},
{0.791153,0.285443},
{0.790846,0.278008},
{0.790535,0.2706},
{0.790172,0.263259},
{0.788665,0.263201},
{0.787401,0.263168},
{0.786302,0.263158},
{0.785287,0.27042},
{0.784102,0.270422},
{0.782778,0.270458},
{0.78129,0.270511},
{0.781025,0.277893},
{0.780753,0.2853},
{0.780463,0.292677},
{0.780205,0.299961},
{0.79296,0.242438},
{0.791256,0.249234},
{0.789855,0.256137},
{0.789573,0.249328},
{0.790912,0.242674},
{0.789317,0.242857},
{0.788166,0.24932},
{0.788384,0.256101},
{0.791602,0.256131},
{0.787962,0.24287},
{0.786998,0.249287},
{0.787233,0.256157},
{0.786164,0.256089},
{0.785148,0.249332},
{0.786028,0.249308},
{0.786851,0.242863},
{0.785927,0.242872},
{0.785124,0.24291},
{0.78431,0.242872},
{0.784249,0.249308},
{0.784214,0.256089},
{0.785206,0.256117},
{0.786706,0.236788},
{0.786645,0.231378},
{0.785896,0.23684},
{0.785895,0.226348},
{0.785258,0.231375},
{0.785331,0.22637},
{0.785863,0.222034},
{0.785364,0.222053},
{0.784798,0.222034},
{0.784706,0.226348},
{0.784575,0.231302},
{0.785175,0.236874},
{0.785898,0.231302},
{0.786512,0.226287},
{0.786418,0.222041},
{0.78626,0.218367},
{0.785776,0.218416},
{0.785331,0.218424},
{0.784825,0.218416},
{0.784203,0.218372},
{0.78408,0.222053},
{0.783952,0.226293},
{0.783718,0.231386},
{0.784431,0.23684},
{0.786158,0.215503},
{0.785672,0.215389},
{0.785253,0.215435},
{0.784795,0.215389},
{0.784195,0.21551},
{0.783545,0.215329},
{0.783407,0.218274},
{0.783203,0.221909},
{0.782997,0.226212},
{0.782761,0.231172},
{0.783561,0.236791},
{0.44042,0.445824},
{0.460147,0.443049},
{0.465123,0.495661},
{0.453102,0.511766},
{0.450328,0.497392},
{0.46358,0.479593},
{0.447266,0.481528},
{0.435809,0.50013},
{0.439951,0.514174},
{0.443617,0.526845},
{0.455556,0.524848},
{0.466519,0.510309},
{0.480025,0.461234},
{0.461914,0.462064},
{0.443943,0.464369},
{0.431231,0.484723},
{0.421719,0.503804},
{0.427205,0.517339},
{0.432066,0.529522},
{0.436324,0.540262},
{0.446829,0.538137},
{0.457688,0.536349},
{0.467744,0.523579},
{0.480051,0.523127},
{0.492349,0.523579},
{0.480038,0.535072},
{0.46881,0.535497},
{0.469727,0.54609},
{0.470507,0.555447},
{0.47116,0.563656},
{0.47997,0.563503},
{0.488784,0.563656},
{0.426258,0.467966},
{0.415645,0.488915},
{0.409009,0.472753},
{0.420944,0.449974},
{0.40188,0.455432},
{0.392345,0.478631},
{0.400644,0.494124},
{0.408212,0.508343},
{0.383359,0.462},
{0.376453,0.485562},
{0.386393,0.500192},
{0.395413,0.513721},
{0.403499,0.525849},
{0.415022,0.521255},
{0.421044,0.53283},
{0.426327,0.543059},
{0.430914,0.551934},
{0.440025,0.54969},
{0.44961,0.548044},
{0.45955,0.546882},
{0.361518,0.493512},
{0.360705,0.515326},
{0.347741,0.502534},
{0.348958,0.47847},
{0.333607,0.488514},
{0.335325,0.512685},
{0.349572,0.524301},
{0.362545,0.534789},
{0.372444,0.526931},
{0.37302,0.507335},
{0.36566,0.469691},
{0.319856,0.499949},
{0.307638,0.512518},
{0.324247,0.523776},
{0.339648,0.534002},
{0.353761,0.543365},
{0.366434,0.551615},
{0.374202,0.544168},
{0.382972,0.537322},
{0.383445,0.519913},
{0.461132,0.555962},
{0.462468,0.564025},
{0.463577,0.570771},
{0.4717,0.570787},
{0.465181,0.582005},
{0.47214,0.576906},
{0.472495,0.582144},
{0.465716,0.5865},
{0.472776,0.586631},
{0.479919,0.582154},
{0.464474,0.576956},
{0.458077,0.581943},
{0.458823,0.586247},
{0.459328,0.589976},
{0.466099,0.590132},
{0.448123,0.57163},
{0.454009,0.564515},
{0.455682,0.571267},
{0.449916,0.577093},
{0.457034,0.577013},
{0.451992,0.55677},
{0.445893,0.565266},
{0.441018,0.572259},
{0.443217,0.577213},
{0.444815,0.581517},
{0.451261,0.581746},
{0.438958,0.581274},
{0.439859,0.584839},
{0.4458,0.585411},
{0.452162,0.585881},
{0.452711,0.589468},
{0.453027,0.592659},
{0.459652,0.593177},
{0.466366,0.59355},
{0.466524,0.596352},
{0.473251,0.59656},
{0.473306,0.599097},
{0.437137,0.577472},
{0.434518,0.572979},
{0.431881,0.577974},
{0.433899,0.581165},
{0.434464,0.584167},
{0.43421,0.587135},
{0.440153,0.58806},
{0.446317,0.588914},
{0.446515,0.592047},
{0.446522,0.594936},
{0.453165,0.59549},
{0.459834,0.596005},
{0.459916,0.598614},
{0.466613,0.59894},
{0.466632,0.601235},
{0.423885,0.576029},
{0.424783,0.569812},
{0.428735,0.574291},
{0.427706,0.579092},
{0.431154,0.567941},
{0.427116,0.561808},
{0.420055,0.564386},
{0.419247,0.57219},
{0.420084,0.578587},
{0.424869,0.581202},
{0.429504,0.583065},
{0.430358,0.581105},
{0.428486,0.58579},
{0.427497,0.588906},
{0.433768,0.590221},
{0.4401,0.591261},
{0.439899,0.594231},
{0.439692,0.59713},
{0.446467,0.597707},
{0.453204,0.598182},
{0.453177,0.600739},
{0.459931,0.601052},
{0.434864,0.559653},
{0.438233,0.566417},
{0.443197,0.557914},
{0.422393,0.554686},
{0.416918,0.546186},
{0.414578,0.557859},
{0.400435,0.55456},
{0.40103,0.541325},
{0.408266,0.550187},
{0.407587,0.561548},
{0.410662,0.536766},
{0.392785,0.531243},
{0.392269,0.546543},
{0.393571,0.559675},
{0.401536,0.565851},
{0.408528,0.571024},
{0.41382,0.567394},
{0.414674,0.575232},
{0.417153,0.581667},
{0.422884,0.584029},
{0.296734,0.525919},
{0.314487,0.535617},
{0.330997,0.544517},
{0.346106,0.552537},
{0.359751,0.559676},
{0.371869,0.565933},
{0.377708,0.558954},
{0.384502,0.552455},
{0.306084,0.548095},
{0.323605,0.555516},
{0.339639,0.562219},
{0.35412,0.568148},
{0.36701,0.573319},
{0.378386,0.577696},
{0.38258,0.571317},
{0.387564,0.565157},
{0.334417,0.572322},
{0.346188,0.586119},
{0.330439,0.58275},
{0.317554,0.567013},
{0.312812,0.578812},
{0.327702,0.593406},
{0.343927,0.595469},
{0.358324,0.597144},
{0.360272,0.589007},
{0.349629,0.577005},
{0.299077,0.561096},
{0.293568,0.574505},
{0.309621,0.590976},
{0.326248,0.604225},
{0.342712,0.604926},
{0.35732,0.6054},
{0.370196,0.605675},
{0.371084,0.59848},
{0.372568,0.591318},
{0.363156,0.581038},
{0.28966,0.588203},
{0.30786,0.603287},
{0.287546,0.602137},
{0.267833,0.585122},
{0.265264,0.600765},
{0.287419,0.61625},
{0.307725,0.615745},
{0.326122,0.615144},
{0.272605,0.569754},
{0.265222,0.616652},
{0.289148,0.630433},
{0.309087,0.628241},
{0.327329,0.626093},
{0.343633,0.624032},
{0.342631,0.614465},
{0.357272,0.613725},
{0.370241,0.61295},
{0.381732,0.612166},
{0.381718,0.605816},
{0.382399,0.599526},
{0.383748,0.593325},
{0.375143,0.584443},
{0.279114,0.554679},
{0.287243,0.540028},
{0.267456,0.632653},
{0.292605,0.644575},
{0.316591,0.652974},
{0.297743,0.658554},
{0.271535,0.648647},
{0.277423,0.664484},
{0.304514,0.672245},
{0.32265,0.665011},
{0.339181,0.658346},
{0.33381,0.647779},
{0.312095,0.640674},
{0.284904,0.680018},
{0.312982,0.685518},
{0.330291,0.676758},
{0.345985,0.668621},
{0.36005,0.661271},
{0.354063,0.65224},
{0.349335,0.642994},
{0.329876,0.636999},
{0.339508,0.687945},
{0.33531,0.710236},
{0.323209,0.698242},
{0.305313,0.709423},
{0.318654,0.722841},
{0.334415,0.735052},
{0.349402,0.72132},
{0.350411,0.698622},
{0.363915,0.68795},
{0.354217,0.67852},
{0.2942,0.695054},
{0.392557,0.617012},
{0.382434,0.618548},
{0.370906,0.620264},
{0.383815,0.624933},
{0.393695,0.622641},
{0.402625,0.620573},
{0.401732,0.615621},
{0.391992,0.611404},
{0.391957,0.605842},
{0.392511,0.600338},
{0.393575,0.594895},
{0.385739,0.587241},
{0.36013,0.630386},
{0.375264,0.634696},
{0.363125,0.638612},
{0.345902,0.633565},
{0.36725,0.646684},
{0.378874,0.641709},
{0.389065,0.637345},
{0.385988,0.63123},
{0.372716,0.627498},
{0.358201,0.62207},
{0.417559,0.609482},
{0.425147,0.612541},
{0.417805,0.613365},
{0.40973,0.61005},
{0.410019,0.614454},
{0.418315,0.61729},
{0.425485,0.616099},
{0.432524,0.615179},
{0.432325,0.611851},
{0.42498,0.609006},
{0.417556,0.605641},
{0.409698,0.605739},
{0.401239,0.605807},
{0.401266,0.610695},
{0.410775,0.618774},
{0.419106,0.621257},
{0.425995,0.619774},
{0.432805,0.618654},
{0.439561,0.617917},
{0.439458,0.61452},
{0.439352,0.61144},
{0.432219,0.60864},
{0.424977,0.605558},
{0.417778,0.601844},
{0.410028,0.601462},
{0.401663,0.600972},
{0.411876,0.623174},
{0.404054,0.625474},
{0.395475,0.62819},
{0.406124,0.630247},
{0.413435,0.627482},
{0.420198,0.625267},
{0.427503,0.627273},
{0.426682,0.623558},
{0.433445,0.626025},
{0.433156,0.622308},
{0.421642,0.629117},
{0.415559,0.631737},
{0.41836,0.635501},
{0.423489,0.632603},
{0.42838,0.630621},
{0.433537,0.629687},
{0.439095,0.629382},
{0.439549,0.625418},
{0.439648,0.62147},
{0.417005,0.643149},
{0.41249,0.639187},
{0.408912,0.634837},
{0.405748,0.643679},
{0.41097,0.648335},
{0.417275,0.652537},
{0.4226,0.646578},
{0.422106,0.638877},
{0.426266,0.635406},
{0.429128,0.633128},
{0.432774,0.633385},
{0.437982,0.633784},
{0.444006,0.63415},
{0.445193,0.62929},
{0.445869,0.624899},
{0.446186,0.620994},
{0.401485,0.638739},
{0.393064,0.643271},
{0.383402,0.648658},
{0.398001,0.648999},
{0.398068,0.633542},
{0.378941,0.662131},
{0.395867,0.661486},
{0.386574,0.669375},
{0.367355,0.669928},
{0.375959,0.67822},
{0.39547,0.676201},
{0.403806,0.667338},
{0.403964,0.654426},
{0.389111,0.655149},
{0.372519,0.654544},
{0.385938,0.686031},
{0.397117,0.69328},
{0.405474,0.682511},
{0.412758,0.672896},
{0.411043,0.659454},
{0.404084,0.575109},
{0.410938,0.578795},
{0.396363,0.570653},
{0.392004,0.575838},
{0.400373,0.579607},
{0.407916,0.582736},
{0.414818,0.585281},
{0.413025,0.589109},
{0.40555,0.586995},
{0.397413,0.584415},
{0.403782,0.591513},
{0.41165,0.593131},
{0.418968,0.594429},
{0.419969,0.590827},
{0.425465,0.598796},
{0.418243,0.598103},
{0.410617,0.597225},
{0.425137,0.60216},
{0.432327,0.60245},
{0.432546,0.599416},
{0.425964,0.595489},
{0.42664,0.592195},
{0.421262,0.587298},
{0.3952,0.589557},
{0.402518,0.596202},
{0.388462,0.581377},
{0.352231,0.746039},
{0.37153,0.755882},
{0.365188,0.731414},
{0.387638,0.704986},
{0.375117,0.696815},
{0.362956,0.708572},
{0.377038,0.717721},
{0.392299,0.725914},
{0.401293,0.712333},
{0.382374,0.740438},
{0.4159,0.718741},
{0.422434,0.705438},
{0.409341,0.699745},
{0.416432,0.688202},
{0.422624,0.677706},
{0.419095,0.664068},
{0.436239,0.710226},
{0.440604,0.697386},
{0.424524,0.65637},
{0.427978,0.668257},
{0.432562,0.659773},
{0.429129,0.649557},
{0.428192,0.69319},
{0.43321,0.682024},
{0.435896,0.638426},
{0.430501,0.63721},
{0.427011,0.641496},
{0.432927,0.643741},
{0.439639,0.645415},
{0.442157,0.639467},
{0.444404,0.654386},
{0.436444,0.652171},
{0.441265,0.662721},
{0.450497,0.665046},
{0.452865,0.656164},
{0.446988,0.646965},
{0.449065,0.640372},
{0.457625,0.634981},
{0.456405,0.641181},
{0.45063,0.634569},
{0.454826,0.648203},
{0.464901,0.635424},
{0.465532,0.62966},
{0.458506,0.629482},
{0.451704,0.629345},
{0.458247,0.677034},
{0.447693,0.674827},
{0.437556,0.671888},
{0.44441,0.685583},
{0.452381,0.624775},
{0.452796,0.620731},
{0.446286,0.617443},
{0.446309,0.614114},
{0.446289,0.611028},
{0.439303,0.608376},
{0.432215,0.605516},
{0.439295,0.605523},
{0.446258,0.608204},
{0.446252,0.605548},
{0.439374,0.602718},
{0.453101,0.613849},
{0.453118,0.61083},
{0.46629,0.620423},
{0.459736,0.616897},
{0.459505,0.620529},
{0.453004,0.617171},
{0.459113,0.62467},
{0.465972,0.624872},
{0.432864,0.596389},
{0.433275,0.593336},
{0.446302,0.602965},
{0.446383,0.600378},
{0.439506,0.599914},
{0.453107,0.605604},
{0.45314,0.603184},
{0.453115,0.608105},
{0.0741383,0.0687133},
{0.0932253,0.0645784},
{0.11204,0.0606664},
{0.130215,0.0573249},
{0.147645,0.0547153},
{0.163544,0.0535793},
{0.177494,0.0544083},
{0.189828,0.0567177},
{0.201377,0.0597507},
{0.2121,0.0633625},
{0.222388,0.0671948},
{0.231983,0.0712107},
{0.240988,0.0752798},
{0.248888,0.0793983},
{0.257258,0.0772296},
{0.265506,0.0779776},
{0.26921,0.0750585},
{0.273729,0.0731469},
{0.278673,0.0717254},
{0.28395,0.0707181},
{0.289351,0.0698858},
{0.294865,0.069273},
{0.30043,0.0688405},
{0.0636966,0.110689},
{0.059196,0.0919077},
{0.0824769,0.105336},
{0.078196,0.0871104},
{0.0548234,0.0730323},
{0.0684031,0.129321},
{0.0870839,0.123321},
{0.105237,0.117682},
{0.100839,0.100295},
{0.0968839,0.0825594},
{0.132795,0.0746902},
{0.118693,0.095648},
{0.115184,0.078325},
{0.122715,0.112512},
{0.135762,0.0916297},
{0.149413,0.0719381},
{0.169643,0.101217},
{0.158776,0.119325},
{0.155039,0.104152},
{0.166908,0.0861142},
{0.151918,0.0883737},
{0.139367,0.107954},
{0.143436,0.12381},
{0.148308,0.139033},
{0.163127,0.133942},
{0.17293,0.115732},
{0.183089,0.0992578},
{0.180624,0.0849851},
{0.178713,0.0700808},
{0.1648,0.0703183},
{0.127296,0.128908},
{0.132478,0.144828},
{0.138371,0.160228},
{0.153732,0.153802},
{0.168113,0.148037},
{0.176908,0.12962},
{0.186095,0.112956},
{0.1954,0.0981562},
{0.193069,0.0848564},
{0.191318,0.0709773},
{0.110149,0.13468},
{0.115686,0.151241},
{0.122003,0.167275},
{0.145086,0.175064},
{0.159924,0.168026},
{0.173751,0.161648},
{0.181426,0.143036},
{0.189625,0.126135},
{0.197969,0.111069},
{0.206596,0.0977937},
{0.204463,0.085479},
{0.202776,0.0727597},
{0.0921943,0.14097},
{0.0735242,0.147694},
{0.0979852,0.158189},
{0.0862986,0.183003},
{0.0793363,0.16567},
{0.104701,0.174846},
{0.0949317,0.199447},
{0.112584,0.19081},
{0.12929,0.182685},
{0.137381,0.197436},
{0.121416,0.206109},
{0.104746,0.215143},
{0.130974,0.22077},
{0.146098,0.211546},
{0.152511,0.189281},
{0.166637,0.181665},
{0.179971,0.174686},
{0.186543,0.155988},
{0.193683,0.138839},
{0.201281,0.123401},
{0.209095,0.109734},
{0.216814,0.0980091},
{0.214875,0.0867182},
{0.213367,0.0751371},
{0.115292,0.230359},
{0.126349,0.24506},
{0.137723,0.259363},
{0.141145,0.234822},
{0.192133,0.168406},
{0.186702,0.187066},
{0.198267,0.180159},
{0.208795,0.173993},
{0.20333,0.162854},
{0.198272,0.151107},
{0.204829,0.135394},
{0.21188,0.121328},
{0.219002,0.109046},
{0.226191,0.098641},
{0.224587,0.0883203},
{0.223367,0.0778186},
{0.174117,0.194643},
{0.169139,0.215627},
{0.160531,0.202819},
{0.155438,0.224958},
{0.165385,0.237669},
{0.178328,0.227648},
{0.182011,0.206849},
{0.219102,0.210771},
{0.201635,0.2095},
{0.211797,0.201436},
{0.227517,0.202914},
{0.220921,0.194101},
{0.204803,0.191203},
{0.193928,0.198699},
{0.190468,0.218251},
{0.199234,0.228644},
{0.209755,0.2194},
{0.22682,0.219206},
{0.23439,0.21081},
{0.241027,0.203094},
{0.234742,0.195651},
{0.229024,0.187437},
{0.21466,0.184438},
{0.188025,0.238749},
{0.198159,0.248798},
{0.208649,0.238192},
{0.218221,0.22833},
{0.234763,0.226608},
{0.241538,0.21772},
{0.247387,0.209476},
{0.252548,0.201925},
{0.246822,0.196008},
{0.241365,0.189151},
{0.236125,0.181388},
{0.223422,0.178331},
{0.208782,0.257697},
{0.21831,0.246537},
{0.227021,0.236222},
{0.236144,0.243007},
{0.242992,0.232932},
{0.248958,0.223575},
{0.254128,0.214898},
{0.258593,0.206867},
{0.262474,0.199489},
{0.257012,0.19499},
{0.251906,0.189551},
{0.247048,0.183171},
{0.242415,0.175934},
{0.231201,0.172836},
{0.218275,0.168499},
{0.213279,0.158019},
{0.208954,0.146934},
{0.215025,0.132557},
{0.221486,0.119808},
{0.228082,0.108778},
{0.234666,0.0996226},
{0.233423,0.0902316},
{0.23261,0.080737},
{0.163019,0.260898},
{0.151811,0.248295},
{0.149544,0.272856},
{0.161991,0.28544},
{0.174812,0.272342},
{0.175872,0.249435},
{0.186848,0.260173},
{0.198418,0.269614},
{0.21071,0.27765},
{0.219945,0.265349},
{0.228449,0.25381},
{0.2388,0.259831},
{0.245549,0.248729},
{0.251416,0.238198},
{0.256615,0.228435},
{0.260966,0.219271},
{0.264894,0.210886},
{0.268194,0.203076},
{0.271105,0.195949},
{0.265895,0.192775},
{0.260971,0.188724},
{0.256405,0.183719},
{0.252133,0.177811},
{0.248087,0.171051},
{0.238086,0.167918},
{0.226697,0.163609},
{0.222527,0.153774},
{0.218605,0.143397},
{0.224198,0.130284},
{0.230162,0.118729},
{0.236015,0.108939},
{0.242181,0.100887},
{0.241347,0.0923729},
{0.240929,0.0838253},
{0.175409,0.296238},
{0.190205,0.304754},
{0.187357,0.282374},
{0.227302,0.140404},
{0.232489,0.12844},
{0.237921,0.118041},
{0.243351,0.109337},
{0.248806,0.102331},
{0.248308,0.0946498},
{0.248289,0.0869807},
{0.230651,0.150099},
{0.234226,0.159286},
{0.241027,0.155497},
{0.237985,0.146904},
{0.235118,0.137858},
{0.239838,0.127004},
{0.244775,0.117694},
{0.249615,0.110005},
{0.254611,0.103853},
{0.254396,0.0969426},
{0.254652,0.0901007},
{0.25555,0.0834791},
{0.262878,0.0822186},
{0.270031,0.082816},
{0.273207,0.0798882},
{0.277029,0.0776923},
{0.281358,0.076089},
{0.286025,0.0749074},
{0.290866,0.0739764},
{0.295844,0.0733074},
{0.300925,0.0729113},
{0.301405,0.0768077},
{0.306073,0.0766809},
{0.310307,0.0805182},
{0.309894,0.0840236},
{0.306096,0.0839047},
{0.306113,0.0871707},
{0.303123,0.0903065},
{0.300887,0.0934335},
{0.299343,0.0965571},
{0.298456,0.0996462},
{0.299496,0.101554},
{0.300389,0.10327},
{0.301177,0.104854},
{0.301892,0.106347},
{0.302538,0.107769},
{0.303387,0.107231},
{0.304332,0.106857},
{0.305343,0.106624},
{0.306398,0.10655},
{0.306425,0.108044},
{0.30568,0.109527},
{0.305195,0.111031},
{0.305422,0.112301},
{0.305619,0.113505},
{0.305784,0.11464},
{0.306155,0.114561},
{0.248207,0.133977},
{0.255182,0.139728},
{0.25019,0.141768},
{0.242078,0.135728},
{0.244343,0.144141},
{0.252377,0.149195},
{0.257038,0.146576},
{0.261195,0.144277},
{0.259657,0.137977},
{0.253588,0.132551},
{0.252119,0.125147},
{0.246409,0.12592},
{0.247083,0.15216},
{0.254815,0.156183},
{0.2591,0.15303},
{0.262967,0.150216},
{0.266437,0.147683},
{0.264897,0.142255},
{0.263507,0.136485},
{0.258303,0.13139},
{0.25711,0.124609},
{0.256052,0.117729},
{0.250795,0.117615},
{0.249933,0.159683},
{0.257548,0.162653},
{0.261466,0.15902},
{0.265024,0.155721},
{0.268253,0.152725},
{0.271185,0.150001},
{0.269569,0.145411},
{0.268195,0.14047},
{0.267037,0.135236},
{0.262435,0.130471},
{0.261422,0.124293},
{0.260639,0.118014},
{0.259933,0.111746},
{0.255198,0.110795},
{0.244356,0.163569},
{0.253135,0.166653},
{0.260581,0.168485},
{0.26413,0.164381},
{0.267371,0.160673},
{0.270354,0.157173},
{0.273071,0.154128},
{0.275615,0.151309},
{0.273874,0.147566},
{0.272403,0.143396},
{0.271165,0.138926},
{0.270128,0.134201},
{0.266066,0.12977},
{0.265272,0.124148},
{0.264645,0.118449},
{0.264231,0.112744},
{0.264075,0.107107},
{0.259675,0.105447},
{0.264477,0.182977},
{0.260386,0.178419},
{0.256564,0.172847},
{0.263915,0.173556},
{0.267092,0.169083},
{0.270017,0.164953},
{0.272726,0.161156},
{0.275255,0.157678},
{0.277622,0.154543},
{0.27798,0.148834},
{0.276376,0.145436},
{0.275015,0.141671},
{0.273879,0.137629},
{0.272954,0.133354},
{0.272224,0.12889},
{0.269295,0.129254},
{0.268643,0.124165},
{0.268182,0.119003},
{0.26793,0.113858},
{0.267937,0.10879},
{0.268251,0.103852},
{0.264254,0.101572},
{0.25966,0.0992574},
{0.260134,0.0931706},
{0.261129,0.0874647},
{0.267642,0.0866152},
{0.273951,0.0870858},
{0.276765,0.0842503},
{0.280122,0.0820146},
{0.283896,0.0802604},
{0.288008,0.0789387},
{0.292323,0.0779227},
{0.296804,0.0772194},
{0.297714,0.0809326},
{0.301866,0.0805225},
{0.306084,0.0803966},
{0.302305,0.0840285},
{0.302725,0.0872988},
{0.300179,0.0907253},
{0.298391,0.0941518},
{0.297304,0.0975344},
{0.296862,0.100797},
{0.298126,0.102577},
{0.29922,0.104197},
{0.300178,0.105696},
{0.301037,0.107116},
{0.301802,0.108461},
{0.30248,0.10974},
{0.303109,0.109121},
{0.303838,0.108644},
{0.304648,0.108306},
{0.305519,0.108109},
{0.304941,0.109715},
{0.304606,0.111288},
{0.304928,0.11252},
{0.305202,0.113683},
{0.305436,0.11478},
{0.305638,0.115811},
{0.305928,0.115714},
{0.306231,0.115652},
{0.306295,0.116668},
{0.306545,0.116651},
{0.306746,0.117604},
{0.306548,0.117592},
{0.306395,0.118462},
{0.306433,0.119241},
{0.306464,0.119949},
{0.306558,0.11994},
{0.306634,0.120593},
{0.306623,0.121172},
{0.214988,0.297654},
{0.200822,0.29074},
{0.205931,0.311447},
{0.222193,0.317199},
{0.229634,0.303332},
{0.223542,0.28434},
{0.231535,0.271811},
{0.243439,0.277139},
{0.249622,0.26498},
{0.255195,0.25343},
{0.260148,0.242541},
{0.264475,0.232362},
{0.268209,0.222869},
{0.271386,0.214037},
{0.27412,0.205857},
{0.276525,0.198322},
{0.27865,0.191421},
{0.273653,0.189359},
{0.268917,0.186643},
{0.2716,0.181011},
{0.267578,0.177765},
{0.238766,0.32205},
{0.255471,0.326417},
{0.244628,0.308043},
{0.25563,0.281446},
{0.260599,0.269008},
{0.265087,0.257178},
{0.269061,0.245956},
{0.272549,0.235438},
{0.275532,0.225589},
{0.278072,0.216414},
{0.280231,0.207885},
{0.28215,0.200013},
{0.283856,0.192812},
{0.280541,0.185143},
{0.275935,0.183426},
{0.278028,0.177951},
{0.274039,0.175845},
{0.270383,0.172927},
{0.272992,0.168465},
{0.275453,0.164321},
{0.277745,0.160599},
{0.279923,0.157209},
{0.279846,0.151772},
{0.280276,0.146601},
{0.278743,0.143571},
{0.277483,0.140186},
{0.276417,0.136543},
{0.27559,0.132687},
{0.27493,0.12867},
{0.274504,0.12455},
{0.271692,0.124299},
{0.271359,0.119645},
{0.27125,0.115005},
{0.271387,0.110455},
{0.271826,0.106037},
{0.272624,0.101793},
{0.268957,0.0990669},
{0.264848,0.0961761},
{0.265946,0.0911229},
{0.271751,0.0905617},
{0.275404,0.0941999},
{0.277447,0.0909993},
{0.279964,0.0882676},
{0.282908,0.0859929},
{0.286228,0.0841631},
{0.289848,0.0827346},
{0.293692,0.0816639},
{0.294985,0.0851847},
{0.298599,0.0844607},
{0.278234,0.248556},
{0.285527,0.262036},
{0.27523,0.260038},
{0.271843,0.272149},
{0.283194,0.274282},
{0.287539,0.250353},
{0.280849,0.237745},
{0.283085,0.2276},
{0.284957,0.218111},
{0.286555,0.209288},
{0.287973,0.201138},
{0.289232,0.19368},
{0.285365,0.186273},
{0.282271,0.179452},
{0.264048,0.298141},
{0.275181,0.315166},
{0.259837,0.312057},
{0.25026,0.294443},
{0.272265,0.329947},
{0.278,0.300858},
{0.268083,0.284844},
{0.236743,0.289919},
{0.291388,0.180873},
{0.290354,0.186928},
{0.286747,0.180383},
{0.291968,0.219225},
{0.290702,0.228962},
{0.737949,0.178419},
{0.746618,0.181508},
{0.755074,0.177053},
{0.764528,0.173929},
{0.768602,0.177885},
{0.776688,0.176216},
{0.785,0.17567},
{0.793312,0.176216},
{0.785007,0.180155},
{0.778426,0.18053},
{0.779857,0.184797},
{0.781016,0.188923},
{0.78194,0.192816},
{0.785045,0.196215},
{0.787411,0.196429},
{0.7276,0.175251},
{0.715129,0.171605},
{0.717724,0.182649},
{0.72956,0.184753},
{0.73952,0.187045},
{0.748072,0.189474},
{0.754036,0.184594},
{0.760965,0.180704},
{0.765882,0.184415},
{0.771946,0.18222},
{0.677733,0.192318},
{0.689037,0.201696},
{0.67169,0.20376},
{0.657156,0.19501},
{0.651949,0.207015},
{0.667541,0.214959},
{0.684619,0.21223},
{0.699741,0.210468},
{0.704193,0.200664},
{0.695235,0.191177},
{0.685958,0.180364},
{0.663883,0.18261},
{0.639444,0.186459},
{0.634337,0.199078},
{0.630076,0.211265},
{0.648445,0.218649},
{0.665075,0.225903},
{0.681649,0.22267},
{0.696595,0.220217},
{0.70996,0.218517},
{0.713154,0.209386},
{0.717362,0.200502},
{0.709996,0.191585},
{0.703548,0.180781},
{0.698332,0.166572},
{0.669786,0.170039},
{0.644162,0.173885},
{0.619021,0.178035},
{0.614762,0.190852},
{0.610407,0.203629},
{0.606335,0.216313},
{0.627309,0.223253},
{0.646828,0.22994},
{0.664001,0.236731},
{0.679933,0.233057},
{0.694399,0.230291},
{0.707693,0.227854},
{0.719478,0.226337},
{0.721824,0.217488},
{0.724884,0.209053},
{0.728783,0.200994},
{0.722769,0.192185},
{0.697087,0.153504},
{0.672523,0.157523},
{0.647507,0.161281},
{0.622805,0.165229},
{0.598261,0.169273},
{0.59411,0.182395},
{0.58996,0.195517},
{0.58581,0.208638},
{0.581659,0.22176},
{0.604197,0.22856},
{0.62699,0.234681},
{0.646756,0.240977},
{0.664073,0.247403},
{0.679278,0.243429},
{0.693382,0.240042},
{0.706266,0.237357},
{0.717932,0.235324},
{0.728386,0.233893},
{0.730034,0.225286},
{0.732269,0.217049},
{0.735139,0.209241},
{0.738694,0.201923},
{0.742987,0.195273},
{0.733596,0.193682},
{0.696991,0.141479},
{0.674873,0.132893},
{0.697318,0.129541},
{0.697856,0.1177},
{0.67607,0.120752},
{0.654284,0.123804},
{0.652219,0.136262},
{0.673687,0.145121},
{0.705643,0.246924},
{0.717034,0.244547},
{0.727328,0.242747},
{0.736429,0.241623},
{0.737618,0.233068},
{0.73908,0.225118},
{0.741367,0.217153},
{0.743923,0.210027},
{0.747191,0.203249},
{0.750802,0.197538},
{0.755292,0.192111},
{0.69315,0.249972},
{0.679595,0.253664},
{0.693757,0.259726},
{0.70579,0.256451},
{0.716844,0.253793},
{0.726866,0.251726},
{0.73583,0.250255},
{0.743708,0.249385},
{0.744402,0.241048},
{0.74562,0.232855},
{0.747254,0.225019},
{0.749194,0.217755},
{0.751533,0.211061},
{0.754369,0.204937},
{0.757634,0.19954},
{0.761259,0.195027},
{0.765318,0.191298},
{0.760233,0.187894},
{0.769882,0.188257},
{0.774784,0.186043},
{0.709808,0.284299},
{0.696939,0.278768},
{0.707955,0.275214},
{0.719526,0.281239},
{0.718157,0.272219},
{0.706597,0.265896},
{0.694996,0.269434},
{0.682723,0.273372},
{0.68521,0.282858},
{0.699308,0.287895},
{0.712099,0.293044},
{0.721333,0.28996},
{0.729773,0.28737},
{0.7284,0.278714},
{0.727446,0.269804},
{0.717216,0.263071},
{0.680798,0.263643},
{0.66709,0.26806},
{0.669743,0.277889},
{0.672887,0.287443},
{0.688187,0.291987},
{0.702154,0.296609},
{0.714793,0.301522},
{0.723504,0.298462},
{0.73153,0.295812},
{0.738689,0.293657},
{0.737432,0.285235},
{0.736393,0.276713},
{0.735841,0.267916},
{0.726929,0.260766},
{0.664367,0.301589},
{0.646907,0.298019},
{0.660094,0.292483},
{0.676491,0.296567},
{0.656225,0.282847},
{0.642307,0.288187},
{0.628083,0.293831},
{0.633405,0.304093},
{0.651859,0.30717},
{0.668997,0.310008},
{0.680497,0.305121},
{0.691585,0.300645},
{0.607678,0.288849},
{0.62296,0.283324},
{0.638063,0.27794},
{0.618061,0.272653},
{0.601645,0.278056},
{0.613712,0.299643},
{0.619746,0.310436},
{0.639019,0.313446},
{0.657149,0.315358},
{0.673934,0.317934},
{0.684843,0.313272},
{0.695357,0.308962},
{0.705315,0.305077},
{0.649983,0.262495},
{0.630928,0.256706},
{0.647886,0.251852},
{0.665139,0.25791},
{0.628399,0.245869},
{0.609205,0.251034},
{0.61341,0.261899},
{0.63426,0.267415},
{0.652809,0.272839},
{0.583543,0.245676},
{0.605643,0.240027},
{0.577509,0.234882},
{0.589577,0.256469},
{0.595611,0.267263},
{0.674471,0.337183},
{0.657631,0.334813},
{0.668491,0.330114},
{0.684588,0.333037},
{0.679123,0.325563},
{0.662703,0.322902},
{0.651263,0.328117},
{0.639697,0.333467},
{0.646656,0.339585},
{0.664103,0.341417},
{0.680632,0.344258},
{0.69035,0.340502},
{0.699745,0.336744},
{0.694417,0.328991},
{0.689466,0.3212},
{0.645015,0.321224},
{0.632739,0.327348},
{0.712907,0.321322},
{0.699457,0.317068},
{0.708965,0.313243},
{0.721297,0.317918},
{0.717858,0.309804},
{0.703911,0.325042},
{0.717239,0.3293},
{0.725113,0.325891},
{0.732345,0.3228},
{0.729027,0.314871},
{0.726096,0.30675},
{0.735951,0.330715},
{0.742033,0.327924},
{0.738912,0.320089},
{0.736096,0.312175},
{0.733637,0.304082},
{0.729258,0.333855},
{0.721803,0.337416},
{0.726825,0.345548},
{0.733681,0.341944},
{0.739879,0.338625},
{0.745409,0.335783},
{0.750312,0.333347},
{0.747348,0.325635},
{0.744809,0.317749},
{0.742448,0.30987},
{0.740467,0.301806},
{0.725034,0.35784},
{0.719327,0.349248},
{0.713904,0.340983},
{0.711224,0.352815},
{0.717335,0.36137},
{0.723743,0.370361},
{0.731042,0.36684},
{0.73201,0.354064},
{0.73837,0.350245},
{0.744021,0.346727},
{0.749027,0.343722},
{0.753395,0.341194},
{0.754633,0.331246},
{0.752224,0.323516},
{0.75003,0.315774},
{0.748123,0.307939},
{0.746574,0.299931},
{0.705354,0.344631},
{0.708746,0.332964},
{0.696355,0.348112},
{0.686933,0.351484},
{0.693447,0.358919},
{0.702552,0.356022},
{0.690832,0.368815},
{0.684043,0.361554},
{0.677313,0.354726},
{0.667533,0.357939},
{0.674491,0.364058},
{0.68145,0.370176},
{0.697655,0.376809},
{0.700057,0.366769},
{0.708962,0.36432},
{0.715611,0.373092},
{0.722528,0.382411},
{0.730574,0.379889},
{0.737475,0.376145},
{0.737552,0.362884},
{0.743316,0.358846},
{0.748401,0.355045},
{0.752876,0.351799},
{0.756786,0.349021},
{0.757278,0.338952},
{0.75843,0.329364},
{0.756449,0.321716},
{0.754686,0.314063},
{0.753188,0.306313},
{0.752061,0.298373},
{0.745328,0.291781},
{0.744326,0.283519},
{0.743645,0.275105},
{0.743362,0.266498},
{0.735506,0.259194},
{0.756158,0.387827},
{0.753995,0.37529},
{0.759769,0.382347},
{0.763225,0.393866},
{0.765878,0.388134},
{0.762931,0.377616},
{0.757843,0.370832},
{0.752983,0.363225},
{0.748522,0.367333},
{0.749566,0.380277},
{0.752082,0.394188},
{0.760453,0.400584},
{0.768998,0.405039},
{0.77051,0.39809},
{0.772215,0.392472},
{0.768309,0.383248},
{0.765695,0.373602},
{0.761209,0.367046},
{0.756941,0.359684},
{0.743298,0.371731},
{0.744455,0.385652},
{0.747188,0.402299},
{0.758833,0.408763},
{0.768156,0.413018},
{0.777831,0.400985},
{0.770412,0.379065},
{0.768055,0.37005},
{0.764117,0.363752},
{0.760289,0.356618},
{0.757111,0.437798},
{0.761754,0.42997},
{0.764099,0.441105},
{0.76041,0.448665},
{0.766558,0.452258},
{0.771074,0.444351},
{0.769626,0.43311},
{0.768503,0.42258},
{0.759632,0.418874},
{0.753822,0.426744},
{0.750105,0.434719},
{0.754262,0.445072},
{0.772705,0.455851},
{0.778853,0.459445},
{0.785001,0.463038},
{0.791149,0.459445},
{0.797297,0.455851},
{0.803444,0.452258},
{0.726891,0.402767},
{0.723984,0.411338},
{0.717697,0.402563},
{0.720464,0.393291},
{0.711159,0.39385},
{0.708634,0.402234},
{0.715431,0.410248},
{0.722227,0.418263},
{0.730083,0.420161},
{0.732646,0.412419},
{0.736369,0.402758},
{0.729741,0.39235},
{0.713626,0.384041},
{0.704451,0.385249},
{0.701838,0.394219},
{0.745882,0.424233},
{0.750547,0.415357},
{0.741526,0.413482},
{0.737949,0.422125},
{0.743085,0.43181},
{0.748114,0.441478},
{0.777025,0.190025},
{0.778858,0.193729},
{0.782664,0.196429},
{0.785052,0.199536},
{0.783661,0.202571},
{0.7814,0.200347},
{0.783227,0.199715},
{0.780228,0.19727},
{0.777944,0.198588},
{0.779577,0.201525},
{0.782242,0.203094},
{0.784,0.204893},
{0.772892,0.19782},
{0.775809,0.195432},
{0.773133,0.192005},
{0.769456,0.194738},
{0.766166,0.197995},
{0.770208,0.200788},
{0.775625,0.200676},
{0.777778,0.203349},
{0.780839,0.20411},
{0.782938,0.205328},
{0.784258,0.206886},
{0.776706,0.211197},
{0.776023,0.20592},
{0.778056,0.208114},
{0.77873,0.212678},
{0.779744,0.209842},
{0.780797,0.207676},
{0.779433,0.205743},
{0.773467,0.203424},
{0.774349,0.209194},
{0.775503,0.214876},
{0.777781,0.216152},
{0.779662,0.217053},
{0.780285,0.213883},
{0.781079,0.21121},
{0.781825,0.209285},
{0.782637,0.208003},
{0.781866,0.206213},
{0.767712,0.215992},
{0.765376,0.208975},
{0.769474,0.211097},
{0.771401,0.217682},
{0.772792,0.213127},
{0.771265,0.207039},
{0.767717,0.204463},
{0.763118,0.202034},
{0.760381,0.206881},
{0.763287,0.214196},
{0.766297,0.221405},
{0.770226,0.222821},
{0.773485,0.224054},
{0.774403,0.219181},
{0.75791,0.21253},
{0.761546,0.220002},
{0.764899,0.227582},
{0.769221,0.22852},
{0.772651,0.229507},
{0.775606,0.230142},
{0.776224,0.224906},
{0.776933,0.220237},
{0.778996,0.220988},
{0.780716,0.221445},
{0.781184,0.217671},
{0.781653,0.214603},
{0.782054,0.212323},
{0.782506,0.210711},
{0.783131,0.209646},
{0.783817,0.209028},
{0.783419,0.207291},
{0.754104,0.225623},
{0.755877,0.218742},
{0.760055,0.226412},
{0.752588,0.23305},
{0.758715,0.233449},
{0.763974,0.234026},
{0.763026,0.241125},
{0.76757,0.241488},
{0.768337,0.234754},
{0.771968,0.235449},
{0.775032,0.235927},
{0.777548,0.236264},
{0.777904,0.230683},
{0.778488,0.225472},
{0.780323,0.225844},
{0.781801,0.226073},
{0.782083,0.221749},
{0.78241,0.218061},
{0.782681,0.215135},
{0.782825,0.21301},
{0.782916,0.211666},
{0.783414,0.211294},
{0.784056,0.210874},
{0.784597,0.210683},
{0.784451,0.208755},
{0.757631,0.240919},
{0.751373,0.240923},
{0.756909,0.248628},
{0.762343,0.248549},
{0.766917,0.248686},
{0.770759,0.248893},
{0.771321,0.24193},
{0.774499,0.242231},
{0.777062,0.242497},
{0.77913,0.24271},
{0.779533,0.236539},
{0.779947,0.230872},
{0.781488,0.231087},
{0.78355,0.213095},
{0.784192,0.212927},
{0.784716,0.212853},
{0.770203,0.256248},
{0.773522,0.256198},
{0.774,0.249026},
{0.776666,0.249131},
{0.778788,0.249256},
{0.780513,0.249341},
{0.780763,0.242876},
{0.781125,0.23672},
{0.782463,0.236777},
{0.783364,0.242868},
{0.783229,0.249288},
{0.783059,0.256159},
{0.784173,0.263158},
{0.785261,0.263158},
{0.782965,0.26317},
{0.781564,0.263208},
{0.779936,0.263271},
{0.779577,0.270615},
{0.779262,0.278021},
{0.778944,0.285444},
{0.778633,0.292829},
{0.778348,0.300128},
{0.766363,0.256228},
{0.761631,0.2564},
{0.765896,0.263993},
{0.769779,0.263807},
{0.773052,0.263633},
{0.775785,0.263481},
{0.776112,0.256235},
{0.778446,0.256148},
{0.780247,0.256152},
{0.781809,0.256106},
{0.781989,0.249325},
{0.782181,0.242878},
{0.761047,0.272323},
{0.756077,0.26475},
{0.761348,0.264278},
{0.765544,0.27185},
{0.75643,0.256573},
{0.750274,0.257102},
{0.750083,0.26547},
{0.755936,0.272982},
{0.761031,0.280276},
{0.765336,0.279666},
{0.769059,0.279194},
{0.769368,0.271508},
{0.772619,0.271206},
{0.775316,0.270961},
{0.777637,0.27076},
{0.778045,0.263362},
{0.750676,0.248911},
{0.743407,0.257868},
{0.751184,0.290309},
{0.750523,0.282159},
{0.756479,0.289106},
{0.756092,0.281093},
{0.750115,0.273898},
{0.75703,0.297046},
{0.761464,0.295955},
{0.761065,0.288186},
{0.768814,0.286842},
{0.771953,0.286354},
{0.772251,0.278791},
{0.774971,0.278461},
{0.777276,0.278207},
{0.76527,0.287423},
{0.765343,0.2951},
{0.76874,0.294421},
{0.771728,0.293857},
{0.774342,0.293407},
{0.774555,0.285969},
{0.776944,0.285658},
{0.761932,0.303634},
{0.765564,0.302661},
{0.757811,0.304866},
{0.758889,0.312516},
{0.76264,0.311172},
{0.765941,0.310067},
{0.768884,0.309177},
{0.768746,0.301884},
{0.771592,0.301249},
{0.774105,0.300747},
{0.776345,0.300384},
{0.776618,0.293068},
{0.769195,0.316352},
{0.77168,0.315559},
{0.771561,0.308475},
{0.773985,0.30794},
{0.77617,0.307553},
{0.778167,0.30728},
{0.766514,0.31736},
{0.763518,0.318636},
{0.767319,0.324579},
{0.769722,0.323426},
{0.771993,0.322526},
{0.774144,0.321842},
{0.77398,0.314974},
{0.77611,0.314547},
{0.778091,0.314238},
{0.766121,0.333293},
{0.761757,0.327586},
{0.764695,0.32597},
{0.768407,0.331745},
{0.76022,0.320066},
{0.763549,0.33505},
{0.765642,0.342436},
{0.767855,0.340558},
{0.769828,0.338883},
{0.771656,0.337407},
{0.770522,0.330441},
{0.772557,0.32938},
{0.774539,0.328548},
{0.776426,0.327915},
{0.776185,0.321338},
{0.778113,0.320987},
{0.76311,0.344472},
{0.763294,0.353986},
{0.760177,0.346623},
{0.760629,0.336965},
{0.766589,0.36077},
{0.765805,0.35162},
{0.773094,0.344008},
{0.774576,0.342508},
{0.77343,0.33613},
{0.775163,0.335074},
{0.776865,0.334264},
{0.778535,0.333732},
{0.778255,0.327487},
{0.771535,0.345712},
{0.769865,0.347434},
{0.772087,0.353948},
{0.773479,0.351957},
{0.774751,0.350035},
{0.775964,0.348247},
{0.777126,0.346516},
{0.776074,0.341037},
{0.777479,0.340007},
{0.778925,0.339309},
{0.77321,0.361693},
{0.770511,0.355945},
{0.767981,0.349487},
{0.768697,0.358151},
{0.771747,0.364005},
{0.774963,0.369131},
{0.776058,0.366615},
{0.774484,0.359549},
{0.775601,0.357419},
{0.776607,0.355242},
{0.777544,0.353163},
{0.778414,0.350974},
{0.779209,0.348572},
{0.778245,0.344765},
{0.779395,0.343682},
{0.78065,0.343953},
{0.782011,0.344745},
{0.780662,0.362489},
{0.77784,0.361902},
{0.778583,0.359489},
{0.779271,0.357072},
{0.777008,0.364286},
{0.780172,0.365254},
{0.782817,0.364537},
{0.7737,0.372075},
{0.770059,0.366844},
{0.772204,0.375402},
{0.299405,0.0877183},
{0.296211,0.0884698},
{0.297353,0.091474},
{0.296052,0.0951979},
{0.29545,0.0988159},
{0.295564,0.102206},
{0.29703,0.103828},
{0.29828,0.105321},
{0.299415,0.106748},
{0.300356,0.108048},
{0.301224,0.109311},
{0.30198,0.110496},
{0.302672,0.11164},
{0.303081,0.110957},
{0.30362,0.110419},
{0.304242,0.109994},
{0.291573,0.086291},
{0.293189,0.0895829},
{0.290063,0.0959865},
{0.290381,0.0910868},
{0.292225,0.0940405},
{0.292071,0.0983819},
{0.293909,0.0965902},
{0.294691,0.0925717},
{0.288381,0.0877781},
{0.287848,0.0930344},
{0.288229,0.0984483},
{0.290645,0.100626},
{0.292821,0.102331},
{0.293968,0.100448},
{0.280671,0.0946918},
{0.282896,0.0919927},
{0.28367,0.0981863},
{0.285649,0.0954784},
{0.28552,0.0897183},
{0.278716,0.0976236},
{0.281797,0.100926},
{0.284568,0.104187},
{0.286872,0.101931},
{0.270115,0.094605},
{0.273807,0.0978158},
{0.282984,0.106698},
{0.286944,0.107486},
{0.288662,0.106249},
{0.290039,0.103272},
{0.292376,0.104559},
{0.294289,0.105789},
{0.294681,0.103881},
{0.280176,0.103809},
{0.277171,0.100923},
{0.275928,0.104404},
{0.278949,0.106949},
{0.281752,0.109435},
{0.285519,0.109516},
{0.289091,0.11064},
{0.290479,0.10962},
{0.290656,0.10627},
{0.292674,0.107002},
{0.294464,0.107896},
{0.296041,0.108869},
{0.295935,0.107006},
{0.296273,0.105311},
{0.297646,0.106654},
{0.298837,0.107926},
{0.299887,0.109138},
{0.300815,0.110291},
{0.301639,0.111383},
{0.302368,0.112413},
{0.30301,0.113379},
{0.303254,0.112693},
{0.303617,0.112118},
{0.304076,0.111651},
{0.275071,0.108182},
{0.274519,0.112124},
{0.278054,0.110299},
{0.280192,0.115514},
{0.277069,0.117456},
{0.277428,0.113817},
{0.280858,0.112402},
{0.274275,0.116236},
{0.274263,0.12037},
{0.276979,0.121171},
{0.279787,0.118744},
{0.28289,0.117194},
{0.283543,0.114461},
{0.284402,0.111871},
{0.277128,0.1249},
{0.279612,0.122032},
{0.28246,0.120033},
{0.285523,0.118845},
{0.286135,0.116471},
{0.286921,0.11423},
{0.287941,0.112289},
{0.279993,0.12862},
{0.278062,0.132178},
{0.277488,0.128585},
{0.279694,0.125346},
{0.278854,0.135629},
{0.28053,0.131813},
{0.282543,0.128756},
{0.282299,0.125865},
{0.282268,0.122941},
{0.283271,0.140501},
{0.282417,0.144686},
{0.28103,0.141929},
{0.282176,0.13779},
{0.279848,0.138895},
{0.281967,0.149314},
{0.284024,0.147118},
{0.284568,0.142966},
{0.285498,0.139275},
{0.284494,0.136869},
{0.283653,0.134291},
{0.281247,0.134881},
{0.281975,0.154221},
{0.283954,0.151554},
{0.284364,0.156149},
{0.286151,0.15335},
{0.285849,0.149181},
{0.282506,0.159291},
{0.283647,0.164478},
{0.28055,0.162839},
{0.278492,0.166781},
{0.281899,0.168492},
{0.285487,0.1697},
{0.287014,0.165598},
{0.285372,0.160837},
{0.288062,0.175105},
{0.283913,0.174311},
{0.279984,0.173015},
{0.29238,0.175505},
{0.289344,0.170428},
{0.290585,0.166289},
{0.288479,0.16194},
{0.287001,0.157611},
{0.288621,0.154697},
{0.287892,0.150831},
{0.287722,0.147041},
{0.286038,0.145165},
{0.286675,0.141476},
{0.287696,0.138235},
{0.286805,0.136111},
{0.286051,0.133841},
{0.285519,0.131455},
{0.282995,0.131576},
{0.290128,0.152117},
{0.289594,0.148563},
{0.291647,0.149762},
{0.292533,0.153087},
{0.29383,0.1507},
{0.293112,0.147632},
{0.291265,0.146516},
{0.289566,0.145128},
{0.29121,0.155721},
{0.293998,0.156425},
{0.295075,0.153794},
{0.296141,0.1514},
{0.29509,0.148506},
{0.294548,0.145688},
{0.29288,0.144681},
{0.291366,0.143426},
{0.28998,0.141924},
{0.288034,0.143437},
{0.288782,0.140175},
{0.289846,0.137365},
{0.289062,0.1355},
{0.288422,0.133514},
{0.287938,0.131428},
{0.287624,0.129266},
{0.285099,0.128977},
{0.292909,0.159359},
{0.289868,0.15866},
{0.291787,0.162635},
{0.295208,0.163002},
{0.296064,0.15977},
{0.297718,0.154293},
{0.296892,0.156885},
{0.294294,0.16664},
{0.293344,0.170777},
{0.298591,0.109296},
{0.297348,0.108169},
{0.297419,0.109836},
{0.298632,0.110794},
{0.299713,0.11174},
{0.299662,0.110373},
{0.296535,0.110855},
{0.297804,0.111611},
{0.295091,0.110126},
{0.29361,0.109618},
{0.294771,0.112114},
{0.296056,0.112401},
{0.2973,0.112881},
{0.298448,0.113448},
{0.299502,0.114067},
{0.298985,0.112416},
{0.299994,0.113198},
{0.300927,0.113978},
{0.300673,0.112652},
{0.300625,0.111412},
{0.295104,0.114684},
{0.293501,0.112125},
{0.291982,0.109321},
{0.292287,0.11254},
{0.294106,0.115148},
{0.296685,0.117001},
{0.297553,0.116765},
{0.296153,0.114542},
{0.297221,0.114632},
{0.298275,0.114907},
{0.299272,0.115291},
{0.300209,0.115749},
{0.301072,0.116234},
{0.300462,0.114707},
{0.301328,0.115344},
{0.302098,0.115954},
{0.301742,0.114711},
{0.301525,0.113513},
{0.30148,0.112393},
{0.302478,0.11811},
{0.30253,0.119184},
{0.301779,0.117745},
{0.30186,0.116731},
{0.301013,0.117395},
{0.301851,0.118931},
{0.302708,0.120379},
{0.303272,0.120496},
{0.303126,0.119415},
{0.303095,0.118465},
{0.30256,0.117214},
{0.302968,0.121612},
{0.303468,0.121595},
{0.303715,0.122694},
{0.304132,0.12261},
{0.303951,0.121633},
{0.302099,0.120292},
{0.301158,0.118771},
{0.301471,0.120273},
{0.30244,0.12167},
{0.303285,0.122826},
{0.304342,0.123545},
{0.304643,0.123348},
{0.304514,0.122546},
{0.304369,0.121662},
{0.30378,0.120625},
{0.303663,0.119658},
{0.303634,0.118794},
{0.303172,0.117661},
{0.299336,0.116851},
{0.299675,0.118652},
{0.298446,0.11673},
{0.298918,0.118763},
{0.300851,0.120357},
{0.300418,0.118653},
{0.300195,0.117085},
{0.299638,0.120876},
{0.301415,0.122058},
{0.30093,0.122413},
{0.299064,0.121347},
{0.300454,0.12287},
{0.302041,0.123666},
{0.30245,0.123311},
{0.302864,0.123031},
{0.301929,0.121824},
{0.300239,0.120555},
{0.298209,0.119068},
{0.297511,0.119546},
{0.296881,0.120258},
{0.298534,0.121997},
{0.300015,0.123469},
{0.301651,0.124112},
{0.30299,0.124658},
{0.30329,0.124252},
{0.303658,0.123986},
{0.303988,0.123723},
{0.295858,0.117484},
{0.295087,0.118256},
{0.29439,0.119279},
{0.296279,0.121145},
{0.29805,0.122798},
{0.299597,0.124172},
{0.301291,0.124669},
{0.302662,0.125082},
{0.303797,0.125414},
{0.30406,0.125039},
{0.304315,0.124694},
{0.304575,0.124398},
{0.304851,0.12417},
{0.290073,0.129611},
{0.290326,0.131486},
{0.290724,0.133294},
{0.292598,0.13161},
{0.2924,0.129997},
{0.292326,0.12835},
{0.289968,0.127695},
{0.296584,0.130779},
{0.298426,0.132136},
{0.296687,0.131961},
{0.294579,0.130396},
{0.294708,0.131771},
{0.296844,0.133111},
{0.298533,0.133138},
{0.300016,0.133183},
{0.299965,0.132291},
{0.298378,0.13112},
{0.296552,0.129571},
{0.29452,0.12898},
{0.292915,0.13317},
{0.294966,0.133117},
{0.297053,0.134235},
{0.298653,0.134127},
{0.300076,0.134081},
{0.301308,0.134085},
{0.301305,0.133239},
{0.301241,0.132413},
{0.299926,0.131393},
{0.298362,0.130079},
{0.298417,0.129017},
{0.29661,0.12834},
{0.294586,0.127553},
{0.293339,0.134668},
{0.295272,0.134416},
{0.297314,0.135334},
{0.298807,0.135117},
{0.300139,0.134996},
{0.301318,0.13495},
{0.302351,0.134954},
{0.302385,0.134107},
{0.30241,0.133298},
{0.30242,0.13252},
{0.301259,0.131605},
{0.299922,0.130483},
{0.299973,0.129558},
{0.300073,0.128631},
{0.298517,0.12794},
{0.296748,0.12711},
{0.294724,0.12611},
{0.292377,0.126684},
{0.290008,0.125764},
{0.287479,0.127055},
{0.284923,0.126444},
{0.28491,0.123877},
{0.285148,0.121341},
{0.298941,0.136058},
{0.297613,0.136359},
{0.296105,0.136813},
{0.296682,0.137833},
{0.297936,0.137258},
{0.299049,0.136887},
{0.30008,0.136759},
{0.300157,0.135899},
{0.296109,0.139579},
{0.295229,0.138576},
{0.294482,0.137404},
{0.293606,0.139498},
{0.294654,0.140659},
{0.29584,0.141619},
{0.297135,0.140387},
{0.297371,0.138687},
{0.29841,0.137967},
{0.29909,0.137484},
{0.299788,0.137594},
{0.300681,0.137731},
{0.30106,0.13677},
{0.301206,0.135861},
{0.291912,0.136654},
{0.290775,0.139079},
{0.291258,0.135023},
{0.292693,0.138158},
{0.291847,0.140612},
{0.293857,0.13609},
{0.295886,0.143952},
{0.294413,0.143049},
{0.29306,0.141943},
{0.296304,0.146498},
{0.297458,0.14467},
{0.297141,0.142399},
{0.29828,0.141027},
{0.298255,0.139331},
{0.29916,0.138426},
{0.300086,0.138727},
{0.301089,0.138966},
{0.301639,0.137855},
{0.302019,0.136819},
{0.30225,0.135853},
{0.297173,0.149176},
{0.298169,0.147118},
{0.299116,0.145224},
{0.300378,0.14018},
{0.300827,0.141901},
{0.299518,0.141524},
{0.29925,0.13982},
{0.298536,0.143015},
{0.300008,0.143487},
{0.302186,0.142183},
{0.301542,0.140466},
{0.303612,0.138087},
{0.303232,0.139321},
{0.302617,0.137976},
{0.302146,0.139159},
{0.302755,0.140681},
{0.303895,0.136965},
{0.302963,0.136889},
{0.306049,0.116708},
{0.306152,0.117635},
{0.30635,0.117605},
{0.305114,0.114964},
{0.304822,0.113929},
{0.304479,0.112826},
{0.304488,0.114238},
{0.304831,0.1152},
{0.305125,0.116106},
{0.305368,0.115942},
{0.305185,0.11707},
{0.304921,0.116304},
{0.304603,0.115495},
{0.304765,0.116539},
{0.305023,0.117175},
{0.305221,0.117814},
{0.305402,0.117814},
{0.305374,0.116963},
{0.305584,0.116861},
{0.304043,0.115109},
{0.304372,0.116338},
{0.303966,0.115695},
{0.303567,0.114279},
{0.303477,0.114968},
{0.304002,0.116393},
{0.304411,0.116942},
{0.304744,0.117394},
{0.304694,0.116879},
{0.304441,0.115864},
{0.304221,0.114626},
{0.303775,0.113697},
{0.302901,0.114173},
{0.303513,0.115763},
{0.304129,0.117162},
{0.304529,0.117621},
{0.304871,0.118015},
{0.305149,0.118291},
{0.305011,0.1177},
{0.304909,0.117252},
{0.304086,0.113214},
{0.302245,0.113319},
{0.303656,0.116628},
{0.302939,0.115071},
{0.304323,0.117965},
{0.304706,0.118357},
{0.305029,0.118678},
{0.305301,0.118923},
{0.305529,0.119089},
{0.305382,0.118453},
{0.303102,0.116039},
{0.302278,0.11432},
{0.302476,0.1154},
{0.303364,0.117043},
{0.303876,0.11752},
{0.304564,0.118774},
{0.304907,0.119076},
{0.3052,0.119334},
{0.305446,0.119535},
{0.305659,0.119691},
{0.305722,0.119187},
{0.305569,0.118503},
{0.302775,0.116524},
{0.303703,0.118064},
{0.305519,0.120477},
{0.305575,0.120085},
{0.305683,0.12056},
{0.305662,0.120947},
{0.305783,0.120974},
{0.305917,0.121095},
{0.305851,0.120695},
{0.305765,0.120227},
{0.305364,0.119937},
{0.305318,0.120378},
{0.305531,0.120964},
{0.305718,0.121445},
{0.305802,0.121345},
{0.305847,0.12125},
{0.305951,0.121421},
{0.306078,0.121616},
{0.306054,0.12126},
{0.305996,0.120815},
{0.305934,0.120349},
{0.305607,0.121549},
{0.305366,0.120974},
{0.305106,0.120311},
{0.305159,0.120964},
{0.305456,0.121626},
{0.305715,0.122175},
{0.305824,0.122032},
{0.304492,0.119338},
{0.304509,0.120051},
{0.304096,0.119082},
{0.304101,0.119838},
{0.304595,0.120849},
{0.304905,0.120922},
{0.30483,0.12019},
{0.304832,0.119568},
{0.304162,0.118429},
{0.30512,0.119768},
{0.304727,0.121688},
{0.304221,0.120746},
{0.304853,0.122492},
{0.305142,0.12244},
{0.305014,0.121678},
{0.305266,0.121675},
{0.305815,0.122764},
{0.305569,0.122289},
{0.305381,0.122376},
{0.305642,0.122864},
{0.305922,0.122593},
{0.306009,0.122415},
{0.3059,0.121862},
{0.305944,0.121668},
{0.306084,0.121933},
{0.306208,0.12181},
{0.306186,0.121417},
{0.306144,0.120965},
{0.306078,0.120441},
{0.305835,0.11979},
{0.305886,0.119226},
{0.305752,0.118536},
{0.305583,0.117777},
{0.305766,0.117725},
{0.30581,0.116777},
{0.305957,0.117676},
{0.306078,0.118503},
{0.306234,0.118465},
{0.306408,0.122061},
{0.306321,0.121962},
{0.306472,0.122106},
{0.306463,0.121671},
{0.306392,0.121629},
{0.306302,0.121547},
{0.306362,0.119949},
{0.306408,0.120592},
{0.306488,0.120594},
{0.306562,0.120587},
{0.306565,0.121164},
{0.306568,0.121684},
{0.306307,0.119253},
{0.306173,0.119248},
{0.306249,0.119929},
{0.306313,0.120562},
{0.306435,0.121143},
{0.306507,0.121173},
{0.305914,0.118517},
{0.306032,0.119237},
{0.306519,0.121685},
{0.306362,0.121133},
{0.306261,0.12106},
{0.306203,0.12051},
{0.305991,0.119858},
{0.306124,0.119892},
{0.305661,0.124165},
{0.305484,0.124393},
{0.305278,0.124622},
{0.305063,0.124878},
{0.304874,0.12521},
{0.305372,0.125586},
{0.305814,0.125829},
{0.306207,0.125943},
{0.306573,0.125967},
{0.306938,0.125941},
{0.30554,0.127014},
{0.306117,0.126714},
{0.306074,0.127139},
{0.305461,0.127481},
{0.306033,0.127595},
{0.306575,0.127166},
{0.306574,0.126741},
{0.306574,0.126339},
{0.306161,0.126316},
{0.305632,0.126596},
{0.304954,0.126777},
{0.304832,0.127249},
{0.304717,0.127755},
{0.305374,0.127952},
{0.305996,0.128078},
{0.306574,0.127622},
{0.307114,0.127593},
{0.306984,0.126314},
{0.305713,0.126179},
{0.305095,0.126355},
{0.304293,0.12639},
{0.304124,0.126878},
{0.30396,0.127398},
{0.3038,0.127948},
{0.304599,0.128275},
{0.305318,0.128486},
{0.305966,0.128586},
{0.304686,0.125577},
{0.305239,0.125964},
{0.304489,0.125968},
{0.303544,0.125843},
{0.302385,0.125621},
{0.303319,0.126346},
{0.303111,0.126904},
{0.302911,0.127496},
{0.30274,0.128134},
{0.303661,0.128528},
{0.304502,0.128827},
{0.305263,0.129024},
{0.305946,0.129118},
{0.293177,0.115992},
{0.290182,0.114808},
{0.291174,0.113464},
{0.289333,0.116484},
{0.292341,0.117165},
{0.293274,0.12191},
{0.295789,0.122228},
{0.295345,0.123426},
{0.292858,0.123429},
{0.295004,0.124744},
{0.297243,0.124764},
{0.297613,0.123724},
{0.293785,0.120512},
{0.291026,0.120223},
{0.290544,0.12199},
{0.290198,0.123849},
{0.292554,0.125033},
{0.296957,0.125905},
{0.298931,0.125903},
{0.299243,0.124997},
{0.298699,0.126901},
{0.287706,0.122609},
{0.287505,0.124823},
{0.288086,0.120452},
{0.288633,0.118396},
{0.303175,0.135901},
{0.301247,0.130785},
{0.302408,0.131764},
{0.302409,0.131023},
{0.301309,0.129976},
{0.303386,0.133355},
{0.303414,0.132604},
{0.304337,0.131322},
{0.304332,0.131981},
{0.303417,0.131191},
{0.303418,0.131885},
{0.304325,0.132671},
{0.304368,0.130681},
{0.303461,0.130516},
{0.302456,0.130288},
{0.304288,0.133401},
{0.304236,0.134182},
{0.304182,0.135025},
{0.303335,0.134147},
{0.303289,0.134986},
{0.304083,0.135946},
{0.30519,0.13079},
{0.305942,0.130845},
{0.30594,0.130251},
{0.305194,0.130173},
{0.304409,0.130053},
{0.303579,0.129173},
{0.304446,0.129427},
{0.30523,0.129594},
{0.302621,0.12883},
{0.303518,0.129843},
{0.302533,0.129558},
{0.30136,0.129133},
{0.300214,0.127717},
{0.300408,0.126846},
{0.301665,0.12758},
{0.301517,0.128359},
{0.301882,0.126877},
{0.302086,0.126183},
{0.300662,0.126046},
{0.300962,0.12532},
{0.864881,0.915134},
{0.875831,0.907596},
{0.870917,0.916429},
{0.858775,0.922343},
{0.864243,0.925127},
{0.878765,0.918061},
{0.883888,0.908072},
{0.886811,0.898001},
{0.878741,0.898798},
{0.869182,0.907723},
{0.860123,0.914144},
{0.855005,0.919642},
{0.848664,0.924684},
{0.851399,0.929046},
{0.855668,0.933626},
{0.871918,0.927946},
{0.888825,0.920011},
{0.893754,0.909239},
{0.896901,0.898405},
{0.898072,0.887477},
{0.887533,0.887595},
{0.879407,0.890203},
{0.871546,0.900675},
{0.863541,0.908363},
{0.857142,0.913505},
{0.852994,0.916523},
{0.847332,0.920178},
{0.840804,0.923576},
{0.84158,0.929099},
{0.842972,0.935112},
{0.845052,0.941862},
{0.862819,0.937916},
{0.882307,0.93075},
{0.894787,0.933604},
{0.900601,0.9223},
{0.90504,0.910984},
{0.907976,0.899946},
{0.909928,0.888801},
{0.910484,0.878218},
{0.89815,0.87682},
{0.883748,0.875855},
{0.877527,0.883697},
{0.872666,0.893909},
{0.86551,0.90264},
{0.858289,0.909841},
{0.852805,0.912482},
{0.846946,0.915547},
{0.84057,0.918296},
{0.83394,0.920299},
{0.833984,0.926105},
{0.834318,0.932396},
{0.834691,0.939529},
{0.834781,0.948},
{0.850858,0.948146},
{0.873929,0.941614},
{0.887838,0.945032},
{0.903217,0.948347},
{0.908736,0.936573},
{0.913512,0.924859},
{0.917357,0.913192},
{0.920208,0.901703},
{0.922005,0.890522},
{0.922871,0.879687},
{0.910641,0.867949},
{0.898017,0.866798},
{0.885137,0.865357},
{0.870664,0.869547},
{0.872851,0.876702},
{0.872798,0.881164},
{0.871554,0.888814},
{0.86628,0.89732},
{0.859497,0.90517},
{0.853406,0.908036},
{0.847069,0.910863},
{0.840667,0.913341},
{0.83409,0.914941},
{0.827467,0.915548},
{0.827323,0.921131},
{0.827304,0.927316},
{0.827443,0.934089},
{0.827502,0.941651},
{0.827242,0.950204},
{0.826823,0.959252},
{0.83238,0.960024},
{0.863423,0.952757},
{0.879827,0.956504},
{0.897146,0.960192},
{0.915022,0.963875},
{0.919578,0.951716},
{0.923713,0.939632},
{0.92738,0.927625},
{0.930499,0.915661},
{0.932877,0.90391},
{0.934401,0.892441},
{0.935119,0.881337},
{0.922933,0.869236},
{0.909597,0.858288},
{0.897302,0.857303},
{0.88436,0.856498},
{0.871526,0.85543},
{0.872076,0.863204},
{0.858103,0.866852},
{0.866322,0.87312},
{0.860834,0.875122},
{0.86567,0.877744},
{0.866901,0.880874},
{0.868961,0.885788},
{0.865831,0.892894},
{0.860047,0.900547},
{0.853766,0.903699},
{0.847393,0.90653},
{0.840885,0.908794},
{0.834301,0.910232},
{0.827701,0.910583},
{0.821071,0.909931},
{0.820822,0.915046},
{0.820673,0.92095},
{0.820711,0.927397},
{0.820826,0.934512},
{0.821028,0.942059},
{0.821139,0.950179},
{0.821265,0.95848},
{0.926354,0.820716},
{0.910191,0.811659},
{0.923598,0.811096},
{0.939422,0.820519},
{0.936984,0.810563},
{0.920698,0.801529},
{0.906955,0.802411},
{0.893212,0.803293},
{0.896806,0.812276},
{0.913283,0.820952},
{0.928841,0.830431},
{0.94165,0.830555},
{0.954452,0.830724},
{0.952433,0.820381},
{0.950354,0.810053},
{0.93444,0.800647},
{0.906008,0.839499},
{0.890498,0.83056},
{0.903329,0.830351},
{0.918565,0.839808},
{0.916088,0.830336},
{0.900162,0.821321},
{0.887247,0.821763},
{0.874492,0.822443},
{0.877737,0.830954},
{0.893281,0.839376},
{0.908259,0.848725},
{0.920671,0.84937},
{0.933021,0.850099},
{0.931057,0.840232},
{0.883486,0.812968},
{0.870659,0.813876},
{0.858755,0.81514},
{0.862205,0.823365},
{0.865186,0.831524},
{0.880476,0.839424},
{0.895636,0.848227},
{0.922197,0.85914},
{0.934443,0.860192},
{0.946833,0.861224},
{0.945459,0.850849},
{0.943664,0.840667},
{0.956272,0.841149},
{0.9688,0.841696},
{0.96718,0.830954},
{0.965475,0.820245},
{0.963714,0.809558},
{0.948183,0.799765},
{0.977069,0.809072},
{0.978471,0.820142},
{0.979872,0.831213},
{0.981273,0.842283},
{0.982674,0.853354},
{0.970307,0.852482},
{0.984075,0.864425},
{0.971655,0.863357},
{0.985477,0.875495},
{0.972794,0.874365},
{0.986878,0.886566},
{0.973524,0.885817},
{0.987039,0.899765},
{0.97364,0.898022},
{0.9872,0.912963},
{0.973346,0.910671},
{0.987361,0.926162},
{0.972845,0.923453},
{0.987522,0.93936},
{0.972183,0.936323},
{0.987682,0.952559},
{0.971409,0.949238},
{0.987843,0.965758},
{0.97055,0.962187},
{0.988004,0.978956},
{0.969635,0.975157},
{0.988165,0.992155},
{0.968692,0.988139},
{0.951315,0.971369},
{0.949219,0.984122},
{0.933095,0.967605},
{0.929746,0.980106},
{0.910272,0.976089},
{0.890799,0.972073},
{0.871326,0.968057},
{0.851853,0.96404},
{0.960535,0.884471},
{0.947585,0.871912},
{0.960151,0.873187},
{0.959159,0.862335},
{0.935158,0.870581},
{0.947713,0.882947},
{0.960335,0.896235},
{0.95696,0.933342},
{0.94426,0.918188},
{0.958441,0.920782},
{0.959556,0.908435},
{0.946073,0.906118},
{0.94194,0.930443},
{0.955239,0.945958},
{0.844952,0.894487},
{0.83882,0.894191},
{0.843362,0.892764},
{0.849745,0.892323},
{0.847473,0.890905},
{0.841605,0.891451},
{0.837639,0.892714},
{0.833441,0.893497},
{0.833995,0.895041},
{0.839757,0.896099},
{0.846038,0.896642},
{0.851674,0.894198},
{0.856696,0.891284},
{0.854096,0.889731},
{0.851077,0.888696},
{0.84513,0.889818},
{0.839552,0.890433},
{0.836312,0.891589},
{0.832802,0.892294},
{0.829275,0.892502},
{0.829218,0.893691},
{0.829144,0.895216},
{0.834355,0.897039},
{0.840443,0.898471},
{0.847043,0.899338},
{0.852993,0.896661},
{0.858698,0.893451},
{0.861443,0.887927},
{0.857966,0.886836},
{0.854205,0.886265},
{0.850652,0.8859},
{0.848163,0.887929},
{0.842663,0.88901},
{0.837525,0.889711},
{0.834935,0.890736},
{0.83224,0.891387},
{0.829428,0.891541},
{0.826527,0.891315},
{0.825755,0.892201},
{0.825049,0.893359},
{0.824356,0.894757},
{0.828942,0.897187},
{0.834525,0.899486},
{0.840868,0.901338},
{0.847398,0.90262},
{0.853692,0.899798},
{0.859801,0.896501},
{0.864141,0.889855},
{0.864608,0.884565},
{0.860669,0.883877},
{0.856168,0.883841},
{0.852191,0.883887},
{0.848223,0.884067},
{0.847224,0.885688},
{0.845203,0.887388},
{0.84002,0.888435},
{0.835254,0.889177},
{0.833307,0.890141},
{0.831834,0.890751},
{0.829977,0.890679},
{0.82752,0.890424},
{0.824934,0.890047},
{0.823567,0.890828},
{0.82226,0.891633},
{0.821012,0.892567},
{0.819745,0.893759},
{0.823592,0.896601},
{0.828656,0.899651},
{0.83459,0.902497},
{0.84102,0.904758},
{0.861518,0.881095},
{0.856668,0.881572},
{0.852373,0.88205},
{0.84858,0.882508},
{0.845237,0.882925},
{0.844872,0.884184},
{0.843837,0.885576},
{0.842198,0.887019},
{0.837295,0.888027},
{0.834584,0.887725},
{0.832864,0.88882},
{0.831226,0.889788},
{0.828855,0.889522},
{0.826357,0.889187},
{0.823762,0.888757},
{0.822246,0.889496},
{0.820597,0.890128},
{0.818869,0.890732},
{0.817127,0.891427},
{0.815296,0.89231},
{0.818377,0.895343},
{0.822842,0.898906},
{0.828329,0.902654},
{0.834503,0.906046},
{0.841529,0.884287},
{0.840554,0.885497},
{0.837436,0.885384},
{0.836177,0.886561},
{0.839141,0.886767},
{0.842206,0.883177},
{0.838461,0.884232},
{0.834417,0.885233},
{0.833243,0.886366},
{0.847461,0.881246},
{0.844564,0.881899},
{0.851061,0.880479},
{0.855225,0.87963},
{0.848117,0.879264},
{0.845045,0.880286},
{0.842485,0.881209},
{0.842467,0.882394},
{0.839354,0.883142},
{0.835393,0.884093},
{0.831432,0.88504},
{0.830372,0.886145},
{0.831869,0.887475},
{0.830331,0.888503},
{0.827777,0.888246},
{0.825123,0.887894},
{0.822454,0.887483},
{0.821098,0.888211},
{0.819509,0.888805},
{0.817665,0.889265},
{0.815616,0.889658},
{0.813411,0.890054},
{0.81102,0.890548},
{0.813312,0.893519},
{0.817061,0.897452},
{0.822107,0.901875},
{0.827997,0.906273},
{0.829246,0.883719},
{0.833363,0.882756},
{0.832401,0.883909},
{0.828429,0.884831},
{0.836474,0.882956},
{0.837676,0.881849},
{0.834405,0.881596},
{0.830023,0.882571},
{0.825992,0.883548},
{0.825357,0.884633},
{0.824558,0.885665},
{0.827474,0.885908},
{0.829135,0.887223},
{0.826378,0.886947},
{0.823599,0.886624},
{0.819697,0.886949},
{0.818477,0.8876},
{0.81692,0.888041},
{0.814983,0.888328},
{0.812779,0.888478},
{0.81014,0.88858},
{0.807327,0.888675},
{0.808408,0.891237},
{0.811427,0.895292},
{0.815948,0.900225},
{0.821514,0.905494},
{0.814133,0.885875},
{0.817883,0.885797},
{0.816981,0.886449},
{0.813537,0.8864},
{0.816009,0.886977},
{0.820775,0.886245},
{0.821579,0.885362},
{0.818619,0.885017},
{0.814878,0.885284},
{0.811167,0.885333},
{0.810902,0.885924},
{0.811305,0.886583},
{0.813164,0.886766},
{0.814695,0.887319},
{0.822238,0.884405},
{0.81942,0.883135},
{0.816786,0.881964},
{0.819714,0.882197},
{0.822667,0.883355},
{0.822938,0.882308},
{0.822936,0.881265},
{0.819617,0.881297},
{0.817379,0.881361},
{0.815857,0.880831},
{0.814148,0.88148},
{0.816258,0.882785},
{0.819093,0.884102},
{0.826462,0.882427},
{0.826765,0.881299},
{0.826903,0.880193},
{0.822555,0.880254},
{0.818767,0.880445},
{0.817329,0.879611},
{0.813858,0.880161},
{0.811559,0.880887},
{0.813236,0.882291},
{0.815921,0.883699},
{0.715063,0.854684},
{0.704026,0.864481},
{0.704744,0.8559},
{0.715796,0.846334},
{0.705511,0.847343},
{0.694494,0.857128},
{0.693711,0.865897},
{0.692927,0.874665},
{0.703416,0.873089},
{0.7144,0.863075},
{0.72551,0.853492},
{0.726186,0.84534},
{0.726938,0.837235},
{0.71662,0.838024},
{0.706315,0.838803},
{0.695278,0.84836},
{0.735119,0.868441},
{0.72445,0.878398},
{0.724481,0.869973},
{0.735477,0.860298},
{0.724888,0.861687},
{0.713984,0.871544},
{0.713753,0.88004},
{0.714053,0.888634},
{0.724798,0.886947},
{0.735114,0.876776},
{0.745835,0.866894},
{0.746152,0.858888},
{0.746644,0.851054},
{0.736051,0.852292},
{0.702969,0.881726},
{0.703107,0.890374},
{0.70425,0.899013},
{0.714958,0.897271},
{0.725531,0.895606},
{0.735432,0.885308},
{0.7458,0.875152},
{0.757035,0.865409},
{0.757073,0.857454},
{0.757484,0.849792},
{0.757933,0.842259},
{0.747203,0.843316},
{0.736661,0.844341},
{0.737356,0.836453},
{0.738167,0.828634},
{0.72779,0.82918},
{0.717453,0.829728},
{0.707143,0.830275},
{0.696062,0.839591},
{0.707984,0.821753},
{0.718338,0.821452},
{0.728692,0.821151},
{0.739046,0.82085},
{0.7494,0.820548},
{0.748597,0.828087},
{0.759754,0.820247},
{0.759099,0.827517},
{0.770108,0.819946},
{0.769689,0.826899},
{0.780462,0.819645},
{0.780425,0.826021},
{0.79112,0.817822},
{0.791362,0.824667},
{0.801778,0.815998},
{0.802439,0.82306},
{0.812436,0.814174},
{0.813596,0.821421},
{0.823094,0.812351},
{0.824807,0.819782},
{0.836051,0.818174},
{0.833753,0.810528},
{0.847357,0.816619},
{0.844411,0.808704},
{0.855069,0.80688},
{0.865727,0.805057},
{0.87947,0.804175},
{0.780347,0.832881},
{0.768976,0.841164},
{0.769301,0.833942},
{0.758534,0.834847},
{0.768685,0.848527},
{0.780304,0.839966},
{0.791615,0.831573},
{0.780369,0.861978},
{0.76855,0.871911},
{0.768295,0.863732},
{0.780138,0.854443},
{0.768399,0.855994},
{0.756836,0.873529},
{0.757058,0.882183},
{0.768563,0.880699},
{0.780811,0.869811},
{0.79266,0.859766},
{0.792299,0.852737},
{0.792132,0.845676},
{0.780258,0.84718},
{0.709865,0.92505},
{0.721885,0.932451},
{0.711912,0.933781},
{0.699814,0.926571},
{0.701928,0.935163},
{0.713996,0.942528},
{0.72394,0.941353},
{0.731835,0.931227},
{0.72995,0.92226},
{0.719907,0.923596},
{0.707867,0.916344},
{0.6977,0.917979},
{0.743668,0.939186},
{0.735957,0.949236},
{0.733836,0.940212},
{0.741688,0.930121},
{0.726042,0.950245},
{0.728182,0.959167},
{0.738139,0.95828},
{0.745838,0.948278},
{0.753406,0.938268},
{0.751366,0.929146},
{0.73988,0.921055},
{0.738241,0.911941},
{0.728176,0.913291},
{0.718028,0.914763},
{0.705976,0.907664},
{0.695586,0.909387},
{0.736919,0.902909},
{0.726655,0.904385},
{0.735998,0.894013},
{0.716383,0.906017},
{0.748152,0.910728},
{0.747068,0.90152},
{0.746387,0.892485},
{0.746,0.883677},
{0.756899,0.891182},
{0.767733,0.890264},
{0.777815,0.890932},
{0.78288,0.87934},
{0.795696,0.872243},
{0.793489,0.866745},
{0.805616,0.857693},
{0.804825,0.851067},
{0.804323,0.844163},
{0.803715,0.837173},
{0.791888,0.838598},
{0.75727,0.900642},
{0.766997,0.900088},
{0.77646,0.900815},
{0.784721,0.902928},
{0.786072,0.894389},
{0.788671,0.888049},
{0.792562,0.885924},
{0.7902,0.881929},
{0.793249,0.877827},
{0.800189,0.874827},
{0.808177,0.868744},
{0.806429,0.863732},
{0.818548,0.856005},
{0.81766,0.849623},
{0.816754,0.842827},
{0.815773,0.835804},
{0.81472,0.82864},
{0.803117,0.83012},
{0.776269,0.91019},
{0.767295,0.909654},
{0.757855,0.909887},
{0.768367,0.919},
{0.777176,0.919372},
{0.785293,0.920429},
{0.784576,0.911654},
{0.760808,0.928445},
{0.749598,0.91998},
{0.759096,0.919266},
{0.769956,0.928162},
{0.762942,0.937612},
{0.772111,0.937152},
{0.78067,0.937186},
{0.778598,0.928364},
{0.786527,0.92912},
{0.793933,0.930253},
{0.792914,0.921977},
{0.792384,0.91371},
{0.78355,0.945761},
{0.774884,0.945983},
{0.765381,0.946608},
{0.777964,0.954733},
{0.787921,0.953846},
{0.793478,0.954618},
{0.79075,0.946193},
{0.802014,0.939675},
{0.809245,0.948792},
{0.803248,0.947888},
{0.795361,0.938654},
{0.797108,0.946997},
{0.804593,0.956163},
{0.810151,0.956935},
{0.815708,0.957707},
{0.815174,0.949632},
{0.808423,0.940754},
{0.801004,0.931585},
{0.78833,0.937712},
{0.799036,0.95539},
{0.793366,0.898913},
{0.795238,0.893612},
{0.797722,0.890605},
{0.801102,0.889403},
{0.796908,0.886035},
{0.795027,0.88336},
{0.792722,0.880034},
{0.79971,0.877889},
{0.805364,0.875918},
{0.813911,0.874202},
{0.810694,0.871983},
{0.820556,0.866642},
{0.819473,0.861787},
{0.831778,0.85489},
{0.830703,0.848503},
{0.829419,0.84166},
{0.828002,0.834513},
{0.826466,0.827173},
{0.799916,0.908943},
{0.807041,0.918214},
{0.799863,0.91602},
{0.792636,0.906053},
{0.800269,0.92368},
{0.807327,0.92536},
{0.814085,0.926699},
{0.813945,0.919917},
{0.807091,0.911706},
{0.800561,0.902785},
{0.815055,0.90381},
{0.814399,0.908361},
{0.808518,0.901248},
{0.807593,0.905952},
{0.814016,0.913766},
{0.814336,0.933998},
{0.807789,0.932904},
{0.814698,0.941685},
{0.801789,0.897878},
{0.83259,0.860769},
{0.833146,0.865733},
{0.845748,0.860536},
{0.84508,0.854481},
{0.843849,0.847807},
{0.842216,0.840695},
{0.840343,0.833322},
{0.838273,0.825784},
{0.850134,0.824513},
{0.85698,0.847505},
{0.855005,0.83999},
{0.869978,0.847563},
{0.867756,0.839596},
{0.852752,0.832303},
{0.858126,0.85473},
{0.882858,0.847848},
{0.800873,0.886404},
{0.804439,0.886836},
{0.807587,0.887137},
{0.802639,0.88524},
{0.798986,0.884393},
{0.804113,0.888773},
{0.805844,0.892459},
{0.809796,0.897764},
{0.803594,0.894554},
{0.812764,0.887409},
{0.81035,0.887323},
{0.846507,0.877058},
{0.855981,0.876751},
{0.851747,0.8781},
{0.84383,0.878427},
{0.860094,0.878662},
{0.849747,0.875417},
{0.840148,0.876514},
{0.83849,0.877985},
{0.836982,0.879253},
{0.841289,0.879681},
{0.839377,0.880757},
{0.84055,0.882129},
{0.833524,0.872294},
{0.844998,0.869518},
{0.843672,0.872435},
{0.833362,0.874587},
{0.841965,0.874716},
{0.852675,0.873444},
{0.856081,0.870649},
{0.845753,0.865655},
{0.833475,0.869469},
{0.823351,0.872913},
{0.824664,0.87497},
{0.825732,0.87658},
{0.832992,0.876399},
{0.835616,0.880443},
{0.830721,0.881411},
{0.831981,0.879081},
{0.831394,0.880258},
{0.832543,0.877845},
{0.826436,0.87791},
{0.826813,0.879075},
{0.811408,0.879505},
{0.815471,0.878769},
{0.820601,0.878208},
{0.818914,0.877069},
{0.812972,0.877887},
{0.808402,0.878867},
{0.805589,0.879851},
{0.808775,0.880331},
{0.816529,0.875781},
{0.809614,0.876937},
{0.804506,0.87824},
{0.80179,0.879491},
{0.801078,0.880676},
{0.804392,0.880828},
{0.807387,0.881208},
{0.802021,0.884044},
{0.79985,0.882163},
{0.802494,0.883227},
{0.805141,0.884833},
{0.805248,0.884056},
{0.803854,0.88274},
{0.801977,0.881783},
{0.798338,0.880991},
{0.798749,0.883007},
{0.805878,0.885848},
{0.808793,0.88628},
{0.808103,0.885438},
{0.808268,0.884737},
{0.806074,0.883478},
{0.805136,0.882481},
{0.804567,0.881788},
{0.809275,0.883405},
{0.812718,0.883166},
{0.812306,0.884005},
{0.811712,0.884711},
{0.815534,0.884563},
{0.809695,0.8826},
{0.806913,0.882895},
{0.80868,0.8841},
{0.780723,0.347986},
{0.78042,0.351459},
{0.779888,0.354459},
{0.779777,0.346753},
{0.600882,0.0619306},
{0.605625,0.0419254},
{0.585642,0.0385037},
{0.308925,0.118418},
{0.0889022,0.816599},
{0.0739853,0.823388},
{0.0766946,0.814772},
{0.0317281,0.848424},
{0.0400715,0.80929},
{0.271896,0.852825},
{0.281923,0.853876},
{0.25901,0.959641},
{0.247223,0.966843},
{0.256828,0.968072},
{0.268689,0.961007},
{0.181204,0.936505},
{0.194424,0.890782},
{0.64998,0.148781},
{0.629425,0.139643},
{0.626234,0.152433},
{0.719643,0.114648},
{0.741429,0.111596},
{0.763215,0.108544},
{0.785001,0.105492},
{0.653615,0.345703},
{0.670665,0.348035},
{0.736056,0.429015},
{0.741967,0.437885},
{0.706848,0.375189},
{0.695042,0.386205},
{0.295663,0.135656},
{0.305556,0.123604},
{0.305476,0.123021},
{0.305233,0.123117},
{0.30535,0.123783},
{0.306048,0.122168},
{0.305117,0.123976},
{0.304976,0.123256},
{0.291625,0.118591},
{0.957912,0.851638},
{0.939277,0.942758},
{0.953347,0.95866},
{0.747847,0.835663},
{0.748095,0.957393},
{0.755672,0.947388},
{0.693473,0.900794},
{0.858919,0.861283},
{0.821848,0.879279},
{0.797471,0.879476},
{0.795568,0.881683},
{0.81044,0.881733},
{0.807059,0.882101},
{0.0983172,0.965752},
{0.113334,0.963682},
{0.293839,0.888566},
{0.291927,0.854937},
{0.792006,0.263341},
{0.792414,0.270736},
{0.280703,0.287296},
{0.602411,0.156152},
{0.738051,0.39011},
{0.975668,0.798001},
{0.961925,0.798883},
{0.936315,0.955143},
{0.69763,0.822054},
{0.696846,0.830823},
{0.691359,0.892202},
{0.692143,0.883434},
{0.498133,0.462064},
{0.4906,0.298253},
{0.909427,0.35182},
{0.0382514,0.974034},
{0.790229,0.346845},
{0.790081,0.320824},
{0.62578,0.32123},
{0.276329,0.171109},
{0.30594,0.129674},
{0.306632,0.130265},
{0.947217,0.89436},
{0.716105,0.951288},
{0.704041,0.943756},
{0.706155,0.952348},
{0.718225,0.960053},
{0.821915,0.870244},
{0.793806,0.641348},
{0.485728,0.021395},
{0.423986,0.0270457},
{0.380434,0.0520343},
{0.98419,0.208639},
{0.988341,0.22176},
{0.280728,0.954242},
{0.278383,0.962386},
{0.266434,0.969301},
{0.276039,0.97053},
{0.768008,0.955619},
{0.758052,0.956506},
{0.292405,0.863344},
{0.610712,0.129908},
{0.632498,0.126856},
{0.606562,0.14303},
{0.660574,0.351821},
{0.735819,0.434292},
{0.729023,0.426277},
{0.688246,0.37819},
{0.708269,0.96094}
};


// normal array: 83kb.
const tgx::fVec3 blub_norm_array[7106] PROGMEM = {
{0.25597672753565065,-0.9436629363324351,0.20970497741490512},
{0.19466358437555323,-0.9617028835607199,0.19296023597896675},
{0.25541868755335195,-0.947682675678524,0.1914649844418469},
{0.3220058583440772,-0.9219844221649447,0.21507429524996058},
{0.31699282075721896,-0.9275393344577526,0.19795538543331181},
{0.2597543544938506,-0.9495208455388409,0.17589155525120556},
{0.20103169195297635,-0.9639599377797727,0.17426272460322742},
{0.1331322423779635,-0.9724361404364251,0.19142559602238263},
{0.13415686865725895,-0.9682688186841393,0.21084930485088219},
{0.1990950980145989,-0.9571586149318083,0.21025824076211458},
{0.2551771367289349,-0.9391748179434479,0.22985928354476798},
{0.32422077987200865,-0.9167709005433226,0.23326380305605038},
{0.40203287347321615,-0.8836097762173606,0.24000694160789376},
{0.39656190857231377,-0.8897004826095322,0.2262116352309255},
{0.38444103648085226,-0.8981774131247129,0.21326608737004313},
{0.3102836433443632,-0.9333676718924653,0.18041299769968705},
{0.12227906829512282,-0.9587749705645282,0.2565119593232738},
{0.0679015957785403,-0.9698210496039129,0.23417195612603225},
{0.13220798890034646,-0.9634303517658398,0.23307296060949667},
{0.18578384802730302,-0.9490821705770484,0.25441579216889504},
{0.19019402555609213,-0.9545157269649587,0.22962133964273634},
{0.06614627625170483,-0.9751341593642625,0.21151369076016402},
{-1.061667109924326e-18,-0.9732556738611843,0.2297246031599838},
{0.0,-0.9659107689901946,0.25887523316990163},
{0.06640108510545675,-0.9630528179617107,0.26099840174381533},
{0.11735592836983168,-0.9506263482869489,0.2872927636037415},
{0.17959771298251806,-0.9417199867919829,0.2844435409144609},
{0.2455786107846159,-0.9276027043578864,0.28150376337277255},
{0.2519702708677774,-0.9340478922038828,0.2531116703518479},
{0.5882826593505773,-0.7639486912930115,0.2651526160140753},
{0.46623171882177616,-0.8514480291493043,0.2401337919207906},
{0.5840580531050235,-0.7596158524202083,0.2861117742335852},
{0.7045500576442223,-0.6534435338956653,0.2768045597230429},
{0.7185504022396829,-0.6250645024101269,0.3049257077846509},
{0.6802704101032493,-0.6327042468867276,0.3700236547971712},
{0.5409006343039032,-0.7752579678470101,0.32619256137956254},
{0.4326646132917667,-0.8674416261878467,0.2456549563140748},
{0.36754884722386155,-0.908704616847937,0.1978983684209006},
{0.4826086289397286,-0.8409208787287981,0.24482848484378106},
{0.591669484390978,-0.7635023723646717,0.2588268700000687},
{0.6988955128861225,-0.6655156422750145,0.2619808999811222},
{0.7937128173684018,-0.5472191275023847,0.26565238572360467},
{0.8004728674481396,-0.522470608139361,0.29371355452181525},
{0.7973594744881689,-0.48372128945497683,0.3608761318956486},
{0.4014793476292028,-0.8792784690368073,0.25628832848086924},
{0.48968561238819786,-0.832311610721495,0.259740993449602},
{0.49046741344922723,-0.8349543491346214,0.2495855588883412},
{0.32278508192573985,-0.9118278242004412,0.25373176762101096},
{0.3168358202465159,-0.9064474241474413,0.2792277390682849},
{0.39550154460392645,-0.8754538285011998,0.27777530915922033},
{0.48280902881242405,-0.830874769260377,0.2766632601263115},
{0.5789907676749835,-0.7676500213502007,0.2747419437730069},
{0.5880303240030088,-0.7652195139893783,0.26202945151790885},
{0.5649663471721066,-0.7694263334402588,0.2979868184529085},
{0.6599367817710122,-0.6925252847507815,0.2913626160758592},
{0.6839752637952535,-0.6785885036771189,0.26776011875083633},
{0.6908882719476597,-0.6748834128183693,0.2592407660608325},
{0.7845320432930826,-0.5661376215730495,0.252977600759418},
{0.863501254595454,-0.4384216415451253,0.24930312380103575},
{0.8707468693402622,-0.40862910809903574,0.27353636238774287},
{0.8736110945880714,-0.36773205290291205,0.3187111430126685},
{0.47011111619013474,-0.8289327360243429,0.3030941398009247},
{0.38384465283696717,-0.8706008227138591,0.30776206715321425},
{0.45126823681059114,-0.8244907789371808,0.34142632278929685},
{0.5451158023822193,-0.7689075468427675,0.3341106798673554},
{0.6397647768481545,-0.695881386617402,0.32626695521286436},
{0.7250292395824431,-0.6109293311840265,0.31795904461037505},
{0.7528058348972826,-0.5958787587799544,0.2796638692778638},
{0.7712951721034607,-0.5816914114932709,0.2583386523245394},
{0.773951077799426,-0.5809101867548929,0.252077535884304},
{0.8541706078073231,-0.4618011351812352,0.2390236061634719},
{0.9141221950889034,-0.33529159095345384,0.22794771655304347},
{0.9203930688803036,-0.3037710762992981,0.24617012808434424},
{0.9231625119465661,-0.26218890692574437,0.2811191093141655},
{0.34305300738478395,-0.8478857907422493,0.4042330020936515},
{0.29062559645148506,-0.8882350530784372,0.35577416034608883},
{0.3664711137174199,-0.8626218327166965,0.3486868172604197},
{0.42543909811586056,-0.8140445999534791,0.39538963451378334},
{0.3061046345407465,-0.8992742858109907,0.31241912808246697},
{0.23581948318827958,-0.9186051739369487,0.31710204314239426},
{0.22260871897926554,-0.905047456658223,0.3624009649971871},
{0.2702556168486733,-0.8697150307498966,0.4129862792508356},
{0.3148390344336836,-0.8258595264342915,0.4677952810734559},
{0.39377105433605997,-0.7968697359527017,0.4581953521040332},
{0.48354400236584566,-0.7510410279938616,0.44958044001707037},
{0.517749297123348,-0.763043516882572,0.3869111741365906},
{0.6120255427036906,-0.6943205404285198,0.37860760982487024},
{0.6979985167982723,-0.6127467516749125,0.37059342797634054},
{0.7724945420305008,-0.5207683579388422,0.36339028592240713},
{0.8056711832567551,-0.5076440124040852,0.3052728306612643},
{0.8262896068768081,-0.49497017970261786,0.26879361371232047},
{0.8317371220428911,-0.49516053661450904,0.2510565728983015},
{0.8436343396059828,-0.4803616597381028,0.23986199551248755},
{0.9062450990312618,-0.3598638417838841,0.2218509316148166},
{0.9493042375434306,-0.2379012708982533,0.20548588731852555},
{0.9537968255779635,-0.20844063688831282,0.21638880842362065},
{0.9557410369541636,-0.1700428554629695,0.24009268541082188},
{0.171390084194961,-0.9312598977262452,0.3215282910204756},
{0.11134649242346917,-0.9390632674740411,0.3252109135714359},
{0.16089853402116824,-0.9157174549730582,0.3682026675724986},
{0.09509304701368995,-0.8961023955822388,0.43354101194861006},
{0.04680347832905465,-0.9238870184997071,0.3797923267576949},
{0.10399731481711798,-0.9220800171799276,0.37276400098224843},
{0.14788770880514202,-0.8915458396331918,0.4281065771710504},
{0.05433280222394629,-0.9432172389100864,0.32770289413632947},
{-1.2224276204766341e-18,-0.9419041094163392,0.3358818968992122},
{-9.780064527695289e-19,-0.9259626370907781,0.37761514099926136},
{0.0,-0.9042144795898907,0.42707865188976973},
{0.04567707995970879,-0.8923447367391709,0.44903727593625725},
{0.08510834743022463,-0.8615148915392374,0.5005483601549726},
{0.13303578778869413,-0.8589273922775111,0.4945151301656967},
{0.18613726875779835,-0.8535150919790385,0.48668768727326606},
{0.2057345400057411,-0.8833657310652866,0.42111552361331683},
{0.24613829644309618,-0.843415377303223,0.4775630223882001},
{0.2843525011623973,-0.8002110157142731,0.5280208191086979},
{0.359004740164642,-0.7762049172857339,0.5182871047216635},
{0.44539603440809106,-0.7356852386568143,0.5102838446943161},
{0.5363612434837048,-0.6768520435154638,0.5041705343210318},
{0.5765888426013976,-0.6872274300172256,0.4418865985968569},
{0.6626100120677891,-0.609636505210177,0.435076204155831},
{0.7379521669304346,-0.5205117857943523,0.42952774086413814},
{0.800107017161408,-0.42281805075670703,0.4255040035573971},
{0.8334655193856011,-0.4213398106106747,0.35750243634114026},
{0.860554807735267,-0.4075798170057339,0.30548995998770584},
{0.8770428848203632,-0.40048125401123563,0.2653498508979487},
{0.8871635238072105,-0.39430878342318526,0.2397112123812742},
{0.8973270498423455,-0.37917402351442947,0.22590091968186388},
{0.9434777450600836,-0.2607997246575798,0.20453177795851293},
{0.9722197671430919,-0.14444027691005648,0.1841893883544286},
{0.9750360181062052,-0.11874939717010244,0.18762554215067045},
{0.9759500797260553,-0.08567857709532559,0.20045104965957755},
{0.16570735223350833,-0.8200726687709907,0.5477425411181652},
{0.2205391650222147,-0.8134482448876281,0.5382048212163673},
{0.11783804405754424,-0.8228933537061631,0.555842355168186},
{0.07509994247223703,-0.8237331060614993,0.5619820002624117},
{0.10351474359853416,-0.7851787573559954,0.6105563175126638},
{0.14594903413873103,-0.7844316280223035,0.6027983911659435},
{0.19512551481979515,-0.7808003102344392,0.5935291981057995},
{0.2532721556504588,-0.7715253542774172,0.5836110373179004},
{0.05818284779396635,-0.7468420313579235,0.6624513087161611},
{0.031218877214769673,-0.7771935752982482,0.6284866969320635},
{0.06588361485042603,-0.784714300695657,0.6163463438505713},
{0.09120276789738045,-0.7479576366975442,0.6574507044894553},
{0.035600085773598994,-0.8168262445793982,0.5757842652063612},
{-5.077320414434861e-19,-0.7900155128981047,0.6130868530480363},
{2.2290770545076514e-19,-0.7458383999308985,0.6661269257345159},
{0.030581240982221373,-0.7422034079448472,0.6694765783319401},
{0.05256567392082547,-0.7129075406898854,0.6992851266491721},
{0.08189871982983055,-0.7138440941264764,0.6954992515962799},
{0.11488007233673919,-0.7143567583469739,0.6902876145375264},
{0.12848506583820415,-0.7484319716804365,0.6506467333531203},
{0.17183700379770056,-0.7468394044656317,0.6424196043578133},
{0.2236334922732045,-0.7406945979344259,0.6335294576611652},
{0.28652068864442093,-0.7257090487952755,0.6255016158855095},
{0.32263193019949776,-0.7523036215245072,0.5744109144652958},
{0.40449549592649514,-0.717014701059523,0.5676912120507955},
{0.49221221366837614,-0.663087262515283,0.5639524971180331},
{0.5752429037389906,-0.5936088606310878,0.5627824822062218},
{0.6215107284498163,-0.60332314542244,0.49972552128078485},
{0.6967203189656634,-0.5172847134647982,0.496988251728374},
{0.7590908422650752,-0.4218789546476174,0.4957814446051127},
{0.8071969176848466,-0.32013530705693194,0.4959299559974644},
{0.8477677698039335,-0.319648730209579,0.4232192076891934},
{0.8799533081769187,-0.31748268171239663,0.3533934383109027},
{0.9024077619054066,-0.312502506336652,0.2966520095771911},
{0.9237412563243553,-0.28648770826220976,0.254218182628561},
{0.9283771800408003,-0.2924585240235349,0.22931162924166526},
{0.9366031883104988,-0.27863943082837267,0.21244890028957286},
{0.9681923943453888,-0.16437379168167818,0.18863919036067608},
{0.9845810372356624,-0.05603457831108803,0.16571151785390664},
{0.9861142107309012,-0.03545180998217997,0.16224035430052228},
{0.9861730516581395,-0.009086064907232962,0.16546950053642534},
{0.28254307811941326,-0.6503908089624018,0.7050965924070545},
{0.2530331349817344,-0.6980758687772135,0.6698240918571486},
{0.3207992997271353,-0.672638814252014,0.6668169425383733},
{0.3484302534452503,-0.6106729357587694,0.7111082364983862},
{0.39634494998093134,-0.6282928098123112,0.6694466563982258},
{0.362236089397775,-0.6954777603236819,0.6205607951143564},
{0.19777702451777615,-0.7093828037008749,0.6765059396534379},
{0.2247532095342196,-0.6710653727305945,0.7065106229392559},
{0.24978107413842623,-0.6310938921436035,0.7343908457363093},
{0.30057611785535265,-0.5981092518917388,0.7429127271601352},
{0.3533051163475842,-0.5517550829143469,0.7554745682290054},
{0.4119651352417943,-0.555765467035442,0.7220868874284362},
{0.4694864675757474,-0.5675755621985614,0.6763434319620718},
{0.4450716226318023,-0.6464752081178314,0.6196620498440267},
{0.1683269925630603,-0.6424466428353376,0.7476150979509976},
{0.1342935425212642,-0.6609930736321155,0.7382773198788231},
{0.16815901196326655,-0.6548026223073,0.7368555302873294},
{0.2026219714171864,-0.6302265561998983,0.7495057201645823},
{0.205530540432164,-0.6465499572576854,0.7346634261481565},
{0.1782535496981766,-0.6797280512664056,0.711474137507172},
{0.13988132651720633,-0.683440419287147,0.7164791746983267},
{0.10632555150791155,-0.685314076045963,0.7204439563698251},
{0.10297035625051029,-0.6657264679139605,0.7390570855167046},
{0.134917951402015,-0.653328238323448,0.7449559446025406},
{0.17897587993658867,-0.6347538166985734,0.7517015542005467},
{0.22002939067424984,-0.6152433702912452,0.7570090240890053},
{0.2520157854393379,-0.6023400294338055,0.7574130529843516},
{0.22698998202551096,-0.6204867236543223,0.7506475696548833},
{0.15277869766604787,-0.7134634305013261,0.6838337538296467},
{0.07620897823013803,-0.6860805163867236,0.7235231279452269},
{0.07397415875108038,-0.6689969575202658,0.7395748066731977},
{0.10327156527863335,-0.6621181426816083,0.7422496540496051},
{0.14210415777357807,-0.651524648544296,0.7451993294969432},
{0.2013955031472801,-0.6130779324217335,0.7639210038279785},
{0.24993880722788805,-0.5861614547109633,0.7706784943493804},
{0.28887886996994616,-0.5690763690802318,0.7698708233459344},
{0.04779599049519869,-0.6730247458347045,0.7380740035976842},
{0.0235390827253675,-0.672093791749004,0.740091782603276},
{0.04796796866665748,-0.6709600548639543,0.7399403210793112},
{0.07391131835304415,-0.6686297431130637,0.7399130919532869},
{0.049248243998818025,-0.6861992012824214,0.7257446290689308},
{0.02402005068414769,-0.6861962843702031,0.7270197359643399},
{0.0,-0.6826733157879172,0.7307237124324971},
{4.708045672533401e-19,-0.671491434081941,0.741012317005985},
{0.02342741829331417,-0.6756375109455162,0.7368616626446634},
{0.049352434335448954,-0.6829713982259777,0.7287759644982936},
{0.07673179380113451,-0.675644394084006,0.733223625207833},
{0.10782143499028718,-0.6651721468411893,0.7388643672713677},
{0.989000202469933,0.04139874016438563,0.1420026190858216},
{0.9886977092116703,0.06034125920860384,0.13724347793871802},
{0.98798379464667,0.03145264212072154,0.1513233386467292},
{0.982254207476212,-0.06698108949150045,0.17518620249839953},
{0.9857270064817236,0.023473303614650807,0.16670714654745475},
{0.9813755390299581,0.10384516436709394,0.16161136479601396},
{0.9828349312551173,0.1159261562647884,0.14351524030018803},
{0.9843382276699749,0.12118821756187374,0.12802995536868927},
{0.9848864106064884,0.12806265818440749,0.11661352314981009},
{0.9630409146406607,-0.17970451758302516,0.20064516711930067},
{0.9572624213101935,-0.18569042366510694,0.22173796090525166},
{0.9768843039998419,-0.08720506912620916,0.1951725711196061},
{0.9689716839096782,0.0007037338143738878,0.2471707517890435},
{0.9724790845612735,-0.08458549164648244,0.21709381542040795},
{0.9771391228273262,0.003850191407104154,0.21256601484332383},
{0.9631284728331242,0.09952725093152709,0.24995573836210805},
{0.9719523387664523,0.09925889548911142,0.21320488463612972},
{0.9824303573712526,0.009192560282553308,0.18640303042291081},
{0.9637447456309637,-0.09921209838382784,0.24769542749713178},
{0.9560914971354428,-0.0008399917649347562,0.2930671314206735},
{0.9494017419058318,0.100683932688157,0.297487946250968},
{0.9309648787840614,0.2008925955596765,0.30487138192994406},
{0.9462512316354263,0.19757574825428315,0.2560711431032374},
{0.9564903000402438,0.19437924406662863,0.21758450175738717},
{0.9776990130297986,0.10052216933186774,0.18439070853319325},
{0.9119695807369397,-0.21173288929307427,0.3513981607836006},
{0.933311485292329,-0.20767365941249458,0.2929186279628692},
{0.9300691255479768,-0.1060007870484235,0.35176022351530356},
{0.9509215117896089,-0.10344910227104268,0.29162743638944527},
{0.9480089738559404,-0.19243848662718352,0.25346876405830826},
{0.8806152749711701,-0.21376797536993855,0.4228711271695996},
{0.8990072518584981,-0.10729568983882373,0.4245863823155921},
{0.9035658828537705,-0.0016122555653510016,0.4284461412764482},
{0.9350114184013112,-0.0014817540859846916,0.35461451163763286},
{0.9227071588429255,0.35603311374940305,0.14782395250405425},
{0.9507869966465178,0.28590129584074614,0.11943423313471156},
{0.9229049912350045,0.36414768151565174,0.12507135243648568},
{0.8889434565958604,0.4313162663556881,0.15409675321820734},
{0.8913050763502101,0.4340074100798621,0.13119767097062585},
{0.8997274196267302,0.4234914058408814,0.10557272162230097},
{0.9322889389884131,0.3479350186846445,0.09888658661706702},
{0.9571445130241683,0.2725761183151699,0.09786031326315135},
{0.9709482334651727,0.20739629481853553,0.11935788548061498},
{0.9510768736782298,0.2747884916155265,0.14122345849790097},
{0.915926409089403,0.3616997929180572,0.17393123047810083},
{0.8758312258701013,0.44521779853915483,0.18628144205696995},
{0.8441582552389475,0.5073358703735347,0.17322573349321985},
{0.8529368452446675,0.5014673839274871,0.14501448507303086},
{0.8596574233716537,0.4974132333853581,0.11648686490387049},
{0.9634866363826647,0.19205126406844908,0.18657388209963757},
{0.9682500990874001,0.1911603976921796,0.1610883235104506},
{0.9398164813540589,0.2820098546249296,0.19291299404058318},
{0.9463414940830203,0.2777125997908821,0.16526792941797952},
{0.9713704840974441,0.1921543282532831,0.13970002418692237},
{0.754491263892231,0.6317204281959834,0.177966944431226},
{0.7962164991869344,0.5740669817832074,0.19101410117795248},
{0.8058954014607775,0.5698056416949892,0.16079220315964915},
{0.7602682740325722,0.6334830331917943,0.14384504912459736},
{0.8127875335912691,0.5678972740839678,0.12988114307558446},
{0.8303216711149148,0.5191889451269283,0.20250620171965739},
{0.783560717646746,0.5802397860331938,0.22215848501704835},
{0.7448114009710726,0.6330789136388225,0.21087215579444482},
{0.7012492968228433,0.6855608101250409,0.1955908978612386},
{0.7056087787783578,0.6910258747358882,0.1568422511838407},
{0.8235175297624829,0.5189534782021723,0.22914223887307505},
{0.7675859382340553,0.5877370379738709,0.25568926770407424},
{0.7311515750970843,0.6369728778028175,0.2443008947520449},
{0.6916736218588436,0.683818445926921,0.23233582124752128},
{0.6452937275580922,0.7331935791496207,0.2145301392997067},
{0.6489227686721988,0.7416345680535401,0.16993353926416901},
{0.8665836177395098,0.4491849627956553,0.2174067677506129},
{0.9071798392044638,0.3683844701896327,0.20326736448349694},
{0.85257841366835,0.4575152951663637,0.25256643331130746},
{0.8008267327485606,0.5341520386250731,0.27084708554448905},
{0.7456067375151268,0.5985279484420781,0.29297591693817754},
{0.713277551686809,0.64263177610943,0.27974905646688203},
{0.6770189908608804,0.6850589114558512,0.2689601714913187},
{0.6352863275361813,0.7286010476528484,0.2560308485412716},
{0.5835617418592336,0.777055702669383,0.23588159823777843},
{0.5871406175009137,0.7881114748048191,0.184786900405896},
{0.6907861865317758,0.6490090737087714,0.3187501635145763},
{0.7224989307816481,0.6041670115542446,0.33612128342160774},
{0.6572235141087931,0.6883256570821896,0.3070261264206369},
{0.6193224448614421,0.7270068922961548,0.2964805016265547},
{0.5726831348015187,0.7695619970560693,0.28250373413634705},
{0.512191317179781,0.8184787268597823,0.26029335044067264},
{0.5163301451765984,0.8320657755404918,0.20265667113646416},
{0.6617383955691393,0.6560379425952949,0.3629276976271083},
{0.6295186682292144,0.6573704615453909,0.41421048108240327},
{0.6013849553159745,0.6953389050215968,0.3934970682012385},
{0.6321060412338012,0.6923411465346542,0.3480024273633912},
{0.5976042034790243,0.727297810449201,0.337501275404996},
{0.5553003660451736,0.7647170278011519,0.32687822023051444},
{0.500194344674423,0.8078241523392706,0.3118104495572004},
{0.42424184604349363,0.858691292632749,0.2875206427759704},
{0.428852856942156,0.8751990670915073,0.22385669535376013},
{0.7207733091241335,0.5453458611884819,0.4278828444081852},
{0.8116587750298014,0.4714529419224584,0.3448799160139384},
{0.7553061803532108,0.5446168761697299,0.364561424332537},
{0.6564581518672961,0.6050955002382387,0.45046878963853854},
{0.6940612770639026,0.6065775019327377,0.38774047741945133},
{0.7817664913796349,0.5390026361640665,0.3135559139358756},
{0.8348092044260598,0.4653652230788257,0.29415778309323004},
{0.8810236794087504,0.3826498927865765,0.27816602213694086},
{0.8609135072425402,0.3884981604666953,0.3284769586460251},
{0.7802114257796102,0.4736693974212473,0.4085430614140206},
{0.6777805147046485,0.5406165259408355,0.49834460543519843},
{0.6115118136129007,0.5972251890140707,0.5190138489664496},
{0.5570018735096701,0.6379332759554911,0.5317800751583428},
{0.5898074540126778,0.6520505966034845,0.47640023788839864},
{0.8958720554102088,0.3756073270395962,0.23734446740814807},
{0.9309095668118572,0.287201814922287,0.2256601336601235},
{0.9186149544872664,0.2926896580197038,0.2654794332536256},
{0.9011631616280817,0.29760034950387576,0.3151808815579566},
{0.8323957547317333,0.3914595667255869,0.3922712264793376},
{0.739453516139309,0.47140128747530424,0.4806134867394363},
{0.6298904908201708,0.531697223115429,0.5661590169781507},
{0.5763148828328144,0.5816297530925902,0.574080121710247},
{0.504442928670714,0.6237249418646735,0.5970800018506922},
{0.4859896776794054,0.669933666454924,0.5612512055571288},
{0.5344568966406903,0.6853384248270714,0.4946383214923316},
{0.5642607013318387,0.695273176911064,0.44520228031816916},
{0.5371725050720266,0.727390969021069,0.4270223389721356},
{0.5701967292396046,0.7280591957303743,0.3805331752645195},
{0.531929685771394,0.761336805443309,0.3706980955879368},
{0.48161029374871395,0.7991969225479488,0.35963287383825915},
{0.41182615838346315,0.8442037098453866,0.34310247966810886},
{0.31231161043313416,0.8963736639383664,0.3146040568498295},
{0.31659406489068664,0.9161506752753188,0.24583762581950125},
{0.9072573330254151,0.20326578099890905,0.3681944512706764},
{0.8752715923417709,0.30057850599236274,0.37888283330721134},
{0.9273373859484975,0.10182054035026908,0.36010824787136797},
{0.8947878305038823,0.1026209784807628,0.4345384599293902},
{0.8730547696638316,0.2043363565038864,0.44274374369148456},
{0.8390440056447698,0.30121276824054927,0.45307397281287853},
{0.7939422581178075,0.3909612420528989,0.4656232360903515},
{0.7477754149459276,0.38737712923439194,0.539231757733692},
{0.692300316619182,0.4652896964174053,0.5515666505661662},
{0.7941660197700512,0.29977559268687376,0.5286160488216641},
{0.8297316984881905,0.2042659189364634,0.5194427233920451},
{0.7408377558429841,0.29663688548252126,0.6026325395203621},
{0.6944715211981421,0.3809669734215387,0.610387967940695},
{0.6398021872316856,0.4554995354179597,0.6190099631246447},
{0.5785663465609151,0.5187866148222983,0.6293817846969956},
{0.7167650812260058,0.20304040459267333,0.667100001827253},
{0.8018482489114716,0.1034896431919039,0.5884974761794812},
{0.7772556287764172,0.20355450089978339,0.595348009737848},
{0.6802868856913417,0.29290599607112844,0.6718748623233016},
{0.8530078935283036,0.10307203873484165,0.5116186943510271},
{0.862969243834668,-0.0016718781629137874,0.5052536877835033},
{0.8130100478955827,-0.0016314259803666242,0.5822473705136786},
{0.7423740946279208,0.10440811883006225,0.6618003085128796},
{0.6505679348213151,0.20409715453681063,0.7315092027393136},
{0.6144726404922358,0.2904691670310716,0.7335196228396178},
{0.571675755224243,0.36542177459399455,0.7346112969056271},
{0.6353359654899923,0.3728737665529679,0.6762494844149622},
{0.58336016437745,0.443130635068738,0.680680658518436},
{0.5370065145228832,0.4992302900186038,0.6799949418105441},
{0.47104267207158174,0.5492681420009972,0.6902342423195451},
{0.5227058312796856,0.5699813582981977,0.633955728058951},
{0.44457977161069157,0.6066610132677457,0.6590229447109845},
{0.4273170522603134,0.651631421885959,0.626718937689328},
{0.4094088613069481,0.6900719788346833,0.5968124062974334},
{0.4551381826481998,0.7101292507533369,0.5371830990641817},
{0.4986941991699581,0.7226671490961802,0.4785982525369615},
{0.46885545938963535,0.7526665068649413,0.46224202280219107},
{0.502968912408972,0.7579453522304072,0.41538068826374186},
{0.45731714651194194,0.7914322918560391,0.4055810090643696},
{0.3933162273883086,0.8310094009223461,0.3933519045990648},
{0.3013072303195701,0.8774895984055132,0.37312994740074223},
{0.17109919558257866,0.926127009338907,0.336175293327702},
{0.17411367045701484,0.9487491282051526,0.26374139130964824},
{0.3555132573851672,0.5624293396283828,0.7465142743099887},
{0.3661568261066162,0.5124244137702313,0.7767563317204206},
{0.41127047925017407,0.5318660320974263,0.7402534139051786},
{0.39809968590957157,0.5849872488134376,0.7066162740868525},
{0.47948591955286873,0.4874816833484167,0.7296950468177332},
{0.4254880665419469,0.47127050800429965,0.7725697466997818},
{0.36676692591896487,0.4630632340739631,0.8068794602051256},
{0.3249001453741071,0.49933640026916565,0.8031830768275162},
{0.31844090092618477,0.5405479709429775,0.7787190017758329},
{0.30354271023029666,0.5796865677069107,0.7561913159288642},
{0.34002486721955455,0.6046184342330336,0.7202913567841275},
{0.38188953708635925,0.6291095686147489,0.6770387966293592},
{0.40315963380359393,0.4195828256731239,0.8132727476508166},
{0.3202828303336967,0.46576572262278115,0.824912844016333},
{0.3511230071411799,0.42982357391658615,0.8318439331759943},
{0.4416826993489042,0.3674648130444965,0.81846564025012},
{0.38556840919230223,0.38119368330859743,0.8402549480000353},
{0.30549553214547664,0.4467809573874457,0.8408681561071922},
{0.28002796547226916,0.47981782962742053,0.8314801193805499},
{0.2603275272570306,0.5032379427877037,0.8240031258988281},
{0.2947686738896782,0.492102484529394,0.8191132849693734},
{0.4628395350934651,0.42064717408569713,0.7802791293429437},
{0.5057159873415177,0.36247933218356904,0.7828538010937597},
{0.5464408779623497,0.29220246009455914,0.7848694727191421},
{0.4804800210273494,0.3004646932136219,0.8239295585944238},
{0.421707318679589,0.31571331748326764,0.8499929638154547},
{0.33539527441666966,0.40009734799281643,0.8528963137615745},
{0.26066109464687587,0.46504625910697905,0.8460424165655628},
{0.24023286044321068,0.4953424723600141,0.8348197457173264},
{0.2257002217657485,0.5153796372672017,0.8267062594327078},
{0.21897170477458783,0.5263410241251715,0.8215938892366329},
{0.24896718585350897,0.5174904910087845,0.8186690003192203},
{0.26923256171660326,0.5108598006994728,0.8164166165266423},
{0.2884036017935057,0.5216097904576288,0.8029611378960265},
{0.5239093832275713,0.4302200116093365,0.7351392383603043},
{0.5821072089358607,0.20856482963526454,0.785908333804977},
{0.5156074404136927,0.21777980136588249,0.8286862648234716},
{0.4555577952727726,0.23202542822267905,0.8594366153616525},
{0.3679079404840374,0.3354514436022008,0.8672462604785295},
{0.28576841090285704,0.4204364528157782,0.8611443575114115},
{0.21734176758652538,0.48210518668281005,0.8487267787903819},
{0.20190158091010738,0.5095706468977353,0.8364051096485619},
{0.19168041035439184,0.526338918790451,0.8283875680216785},
{0.18719670388130985,0.5346480342286652,0.8240806232107373},
{0.18855864364457633,0.5458425076985183,0.8163954891450044},
{0.2212372392764343,0.5401318359414502,0.8119801005935184},
{0.2540132150689867,0.5333261196604946,0.8068708302189369},
{0.2740219633454936,0.5554325849238064,0.7851156648603691},
{0.5431244288936796,0.11760701254233374,0.831375032906198},
{0.48277988057358373,0.1271149831700364,0.8664671765087455},
{0.3995688234485602,0.24968715968446553,0.882043693711733},
{0.31407367416355125,0.3568282055053312,0.8797905199269043},
{0.23736385754986666,0.4399746096754838,0.8660720189279597},
{0.17500457285143087,0.49653974544595436,0.8501892028681352},
{0.16384521604683105,0.5212980025539119,0.8374981419154726},
{0.15691922490618973,0.535458576952047,0.8298556918063101},
{0.1541338975253463,0.5417606408612983,0.8262797042449981},
{0.15518107032232473,0.5508095499423282,0.8200778469791435},
{0.16119103761679549,0.5688315578493377,0.8065036318496752},
{0.19720923050240935,0.5660771970107366,0.8004155960681396},
{0.23406957509482873,0.5623651356821199,0.7930680224193618},
{0.2567577102518836,0.5877141169256606,0.7672467627774656},
{0.5244558875785259,-0.5811742311057329,0.6222399336934915},
{0.5951379279324528,-0.5023855086748589,0.6272317334205678},
{0.6489445522068185,-0.5109628921739265,0.563726787533064},
{0.7102575571354774,-0.4185846542994425,0.5659691596871338},
{0.7578797310454757,-0.3192575947266702,0.5689401563255829},
{0.7910858773469741,-0.2153165820512711,0.5725573370029646},
{0.8404536317067626,-0.21481630854461267,0.49748532293343006},
{0.8589214392571959,-0.1081504441680382,0.500557132214299},
{0.8095037848721568,-0.10890377904647112,0.5769259824163325},
{0.7332357525141968,-0.21611844107093756,0.6447155579509519},
{0.7516222864502259,-0.1100782821132149,0.6503435325413318},
{0.7003828498456708,-0.31802323247624353,0.6390031981511658},
{0.6540595535882627,-0.41395254176386415,0.6331266804733149},
{0.6362600603989551,-0.31837362837220745,0.7027171324923235},
{0.6688796661401613,-0.2186161300776143,0.7104976987254173},
{0.687499725266002,-0.1123812132023176,0.7174361230648669},
{0.6903280213118811,-0.0012386357083915278,0.7234954656203486},
{0.7546836586710539,-0.0014733781034893313,0.6560871927509608},
{0.6769947299816886,0.10658634015066719,0.7282290077100106},
{0.6092157700374488,0.11079545203601372,0.7852264089712049},
{0.6233689270007444,-0.0009444929999782646,0.7819272912380751},
{0.5577651399378929,-0.0006071052659764901,0.8299986024646419},
{0.49729743797929693,-0.0002757412615785325,0.8675800724693854},
{0.4257306570959134,0.1384825053984833,0.8941901382296948},
{0.3428027806474002,0.26892865013284134,0.9000909035859314},
{0.26092579024906976,0.3777711600280772,0.8883730537527235},
{0.19018893829422895,0.4570290249390092,0.8688801057187423},
{0.13319715206343175,0.5078422391399317,0.8510903470416824},
{0.12560931765246244,0.5303753107142785,0.8384058260196046},
{0.12108068391861646,0.5426109820181578,0.8312116398217066},
{0.1193585840762609,0.5474947564891349,0.8282529927650204},
{0.12020098430992868,0.5549930775386217,0.823124782311366},
{0.12442943035210562,0.5711304276881839,0.8113737433704412},
{0.13323310975944036,0.593186892161047,0.7939636323107924},
{0.17355071988425422,0.592407857958528,0.786722999191358},
{0.2140890269436632,0.5910153206668173,0.7777318170676923},
{0.23848313177434807,0.6182690399494789,0.7489120042428541},
{0.2871530948209434,0.6143464987610493,0.73492957458167},
{0.32375029102097963,0.6410903442195177,0.695836848415152},
{0.36503894397759584,0.6667055932450855,0.6498078341444032},
{0.6204629710333317,-0.11669339654175884,0.7755052242119579},
{0.6010880368984615,-0.22481541923379628,0.7669101636908239},
{0.5544096762077698,-0.12380785473459095,0.8229833084778904},
{0.470731409962615,-0.25518493470630427,0.8445665093842805},
{0.4992948956479359,-0.33678589658038866,0.79829810662713},
{0.5337127907867888,-0.23667624419974764,0.8118713028442863},
{0.49307291834087896,-0.13415706459745513,0.8595818630109661},
{0.5679678953190223,-0.32354436498835304,0.7567902706636519},
{0.523798830874735,-0.41180573374958174,0.7456881536039239},
{0.4548000659912942,-0.42330733738391835,0.7835609727974281},
{0.4347040705586825,-0.3597044669943134,0.825617991242953},
{0.4029187874421651,-0.2923237919407448,0.8672965187244323},
{0.4344058072037404,-0.14732979282485753,0.8885862517582923},
{0.43961940240265984,-9.838827650418436e-05,0.8981841522487887},
{0.5354940700000675,-0.4937523673315337,0.6851676442661817},
{0.591425638662424,-0.41024318234747803,0.6942018764524895},
{0.47086494392863965,-0.4893869125570271,0.7340208814447856},
{0.40463423825659617,-0.4948328232704263,0.7690329058270023},
{0.3898561220820676,-0.4467680102365782,0.8052394358849925},
{0.3643897715486419,-0.40681404448488845,0.8376887414789432},
{0.3131620817274172,-0.4262961891642973,0.8486466105936842},
{0.3381110927325961,-0.31909678692593213,0.8853576280490929},
{0.3740575621431137,-0.1625173600761851,0.9130547890884851},
{0.3801546205996896,4.5407655121789486e-05,0.9249229494259783},
{0.36725163637471847,0.15087617890967595,0.9178031456786946},
{0.3337359016411352,-0.5216105751187428,0.7852023661961754},
{2.5932015484999768e-18,0.934488875718343,0.3559923330054554},
{0.16397552489113498,0.9032924039396667,0.3964528474126208},
{-2.7396313312238966e-18,0.958642252239916,0.2846138299879},
{2.5041371798916587e-18,0.9097704770375875,0.41511164656126004},
{0.1540304229094277,0.8805054318981422,0.448313298058633},
{2.4650655459935286e-18,0.8849213920423064,0.4657404104282846},
{-0.1540304229094277,0.8805054318981422,0.448313298058633},
{-0.163975524891135,0.9032924039396667,0.3964528474126209},
{-0.17109919558257866,0.926127009338907,0.3361752933277021},
{-0.17411367045701487,0.9487491282051526,0.2637413913096483},
{-0.31231161043313416,0.8963736639383664,0.3146040568498295},
{-0.3165940648906867,0.9161506752753188,0.2458376258195013},
{-0.42424184604349363,0.858691292632749,0.2875206427759704},
{-0.428852856942156,0.8751990670915073,0.22385669535376013},
{-0.512191317179781,0.8184787268597823,0.26029335044067264},
{-0.5163301451765985,0.8320657755404917,0.20265667113646418},
{-0.5835617418592336,0.777055702669383,0.2358815982377784},
{-0.5871406175009137,0.7881114748048191,0.184786900405896},
{-0.6452937275580922,0.7331935791496207,0.2145301392997067},
{-0.648922768672199,0.7416345680535401,0.16993353926416901},
{-0.7012492968228434,0.6855608101250409,0.1955908978612385},
{-0.7056087787783578,0.6910258747358883,0.15684225118384074},
{-0.754491263892231,0.6317204281959834,0.177966944431226},
{-0.7602682740325721,0.6334830331917943,0.14384504912459734},
{-0.8058954014607775,0.5698056416949892,0.1607922031596492},
{-0.8127875335912691,0.5678972740839678,0.12988114307558446},
{-0.8529368452446675,0.5014673839274871,0.14501448507303083},
{-0.8633563189820569,0.4917247003537262,0.11323729745888053},
{-0.8913050763502101,0.4340074100798621,0.13119767097062585},
{-0.9056113478108365,0.41127513425539225,0.10354154074307116},
{-0.9229049912350045,0.36414768151565174,0.12507135243648568},
{-0.9367757141316093,0.3358606526504832,0.09822873008649219},
{-0.9507869966465178,0.28590129584074614,0.11943423313471156},
{-0.9602545767421837,0.2609580412855413,0.09905578496031203},
{-0.9709482334651727,0.20739629481853553,0.11935788548061498},
{-0.9758666955513559,0.19051741740773895,0.10671132169532316},
{-0.9843382276699749,0.12118821756187374,0.1280299553686893},
{-0.9848864106064884,0.12806265818440749,0.11661352314981006},
{-0.9890002024699333,0.04139874016438563,0.14200261908582157},
{-0.9886977092116703,0.06034125920860384,0.137243477938718},
{-0.9861142107309012,-0.03545180998217997,0.16224035430052228},
{-0.9861730516581395,-0.009086064907232962,0.16546950053642534},
{-0.9750360181062052,-0.11874939717010244,0.18762554215067045},
{-0.9759500797260553,-0.0856785770953256,0.20045104965957755},
{-0.9537968255779635,-0.2084406368883128,0.21638880842362063},
{-0.9557410369541636,-0.1700428554629695,0.24009268541082185},
{-0.9203930688803036,-0.30377107629929806,0.24617012808434424},
{-0.9231625119465661,-0.26218890692574437,0.2811191093141655},
{-0.8707468693402624,-0.40862910809903563,0.27353636238774287},
{-0.8736110945880714,-0.36773205290291205,0.3187111430126685},
{-0.8004728674481396,-0.5224706081393609,0.29371355452181525},
{-0.7973594744881689,-0.48372128945497683,0.3608761318956486},
{-0.7185504022396829,-0.6250645024101269,0.30492570778465095},
{-0.6802704101032493,-0.6327042468867276,0.3700236547971712},
{-0.5840580531050235,-0.7596158524202083,0.2861117742335852},
{-0.5224821930168491,-0.7929849434061588,0.3133484282893964},
{-0.4373250115855987,-0.8680554740720838,0.23500325141398742},
{-0.46623171882177616,-0.8514480291493044,0.24013379192079062},
{-0.36754884722386155,-0.908704616847937,0.1978983684209006},
{-0.3844410364808522,-0.8981774131247129,0.2132660873700431},
{-0.3102836433443632,-0.9333676718924653,0.18041299769968705},
{-0.3169928207572189,-0.9275393344577526,0.19795538543331187},
{-0.2597543544938506,-0.9495208455388409,0.1758915552512056},
{-0.25541868755335195,-0.947682675678524,0.1914649844418469},
{-0.20103169195297635,-0.9639599377797727,0.17426272460322745},
{-0.19466358437555317,-0.9617028835607198,0.1929602359789667},
{-0.1331322423779635,-0.9724361404364251,0.1914255960223826},
{-0.13646685318661078,-0.974979870580674,0.17547378705617594},
{-0.06846546768320953,-0.9786850823856109,0.19361815320570827},
{-0.07107282311579721,-0.9813683912274918,0.1785069592870693},
{-2.2023279728288224e-18,-0.9813826178939914,0.19206289932086332},
{-2.329562378306467e-18,-0.9840656529700234,0.1778054854178621},
{0.07107282311579721,-0.9813683912274918,0.17850695928706933},
{0.06846546768320953,-0.9786850823856109,0.19361815320570827},
{0.13646685318661078,-0.974979870580674,0.17547378705617597},
{0.28541138058436066,0.859197033582311,0.4246419683878247},
{0.36990361204391464,0.8181114542028534,0.44030099511465753},
{0.26589602062012285,0.8408353259318138,0.4714819836255927},
{0.3425829658487632,0.8043246887799719,0.4854881116250597},
{0.24374362836928673,0.821518623699437,0.5154572674280167},
{0.14216267512681263,0.85749998112321,0.4944527845755174},
{0.0,0.8339027859418636,0.5519113548373491},
{0.10769148115315084,0.8101694981984814,0.576218646935225},
{0.12904375963577644,0.8336868417964705,0.5369487479401464},
{2.471934583120453e-18,0.8598000822103783,0.5106308046240716},
{0.20542849793797174,0.7995643041614122,0.5643545479092247},
{0.1082727613676113,0.7846341958431687,0.610431149155559},
{-1.3113127541408738e-18,0.80646981527927,0.5912752633447641},
{-0.10769148115315086,0.8101694981984814,0.576218646935225},
{-0.1290437596357764,0.8336868417964703,0.5369487479401464},
{-0.14216267512681263,0.85749998112321,0.4944527845755173},
{0.1863819548092997,0.7486069150759666,0.6362778116686992},
{0.2838365399995597,0.7675062388673337,0.5747790809178756},
{0.1997886329521744,0.7749158718902164,0.599658147310388},
{0.09758678152288826,0.7506447585258893,0.6534594605402949},
{0.2990648643169946,0.7877437270006247,0.5385350754614068},
{0.38497426876275875,0.7725800279627211,0.5048909909908279},
{0.3449600581952591,0.7560702887144872,0.5562016511779834},
{0.2513175311814096,0.7414128569872956,0.6222109561995971},
{0.15774252517061102,0.7150123107109568,0.6810834686619383},
{0.07611033451724877,0.712753940170593,0.697272570628565},
{-1.4939905437778996e-18,0.7422270334568253,0.6701485139921454},
{-2.774168245570041e-18,0.7764276803649561,0.6302063607764471},
{-0.10827276136761131,0.7846341958431687,0.6104311491555588},
{-0.20542849793797174,0.7995643041614122,0.5643545479092247},
{-0.2437436283692867,0.821518623699437,0.5154572674280167},
{-0.2658960206201229,0.8408353259318139,0.4714819836255927},
{0.428048839743992,0.7831366113094804,0.45107786336787387},
{0.4205658069742649,0.7430396491666538,0.5205924334547916},
{0.3225498192576204,0.7347085865139181,0.5967955319869583},
{0.22988833598159134,0.7123584315349365,0.6630963866593604},
{0.18900194146504312,0.6790751591430523,0.7093202339968054},
{0.12918599239539552,0.6792252366225139,0.7224708003123079},
{0.06602364442669328,0.6792227723009633,0.7309564309617991},
{0.0,0.7070544044915527,0.7071591540021919},
{-0.07611033451724877,0.712753940170593,0.697272570628565},
{-0.09758678152288826,0.7506447585258893,0.6534594605402949},
{-0.1997886329521744,0.7749158718902164,0.599658147310388},
{-0.2990648643169945,0.7877437270006247,0.5385350754614068},
{-0.3425829658487632,0.8043246887799719,0.4854881116250596},
{-0.36990361204391464,0.8181114542028534,0.44030099511465753},
{-0.28541138058436066,0.859197033582311,0.42464196838782464},
{-0.3013072303195701,0.8774895984055132,0.37312994740074223},
{-0.4118261583834631,0.8442037098453866,0.3431024796681088},
{-0.500194344674423,0.8078241523392706,0.3118104495572004},
{-0.5726831348015187,0.7695619970560693,0.28250373413634705},
{-0.6352863275361813,0.7286010476528484,0.2560308485412716},
{-0.6916736218588435,0.683818445926921,0.23233582124752128},
{-0.7448114009710726,0.6330789136388225,0.21087215579444482},
{-0.7962164991869344,0.5740669817832074,0.19101410117795248},
{-0.8441582552389475,0.5073358703735346,0.17322573349321987},
{-0.8889434565958604,0.4313162663556881,0.15409675321820734},
{-0.9227071588429255,0.35603311374940294,0.14782395250405422},
{-0.9510768736782298,0.27478849161552654,0.14122345849790094},
{-0.9713704840974441,0.1921543282532831,0.13970002418692237},
{-0.9828349312551173,0.1159261562647884,0.14351524030018803},
{-0.9879837946466699,0.03145264212072154,0.15132333864672923},
{-0.9845810372356624,-0.05603457831108803,0.16571151785390664},
{-0.9722197671430919,-0.14444027691005645,0.1841893883544286},
{-0.9493042375434305,-0.23790127089825336,0.20548588731852552},
{-0.9141221950889034,-0.3352915909534538,0.22794771655304347},
{-0.863501254595454,-0.4384216415451253,0.24930312380103575},
{-0.7937128173684018,-0.5472191275023848,0.2656523857236047},
{-0.7045500576442223,-0.6534435338956653,0.2768045597230429},
{-0.5882826593505773,-0.7639486912930115,0.2651526160140753},
{-0.4826086289397286,-0.8409208787287981,0.24482848484378106},
{-0.3965619085723138,-0.8897004826095322,0.22621163523092552},
{-0.32200585834407713,-0.9219844221649447,0.21507429524996058},
{-0.2559767275356506,-0.9436629363324351,0.2097049774149051},
{-0.19909509801459885,-0.9571586149318084,0.21025824076211455},
{-0.13415686865725895,-0.9682688186841393,0.21084930485088219},
{-0.06614627625170483,-0.9751341593642625,0.21151369076016402},
{0.0,-0.9778750902453179,0.20918964572299298},
{0.2822170970032788,0.7064759140879802,0.6490341231188039},
{0.30537964173349924,0.6745634817196368,0.6720917969630347},
{0.34544334225285406,0.701335373563472,0.6235363590695917},
{0.38790749499376953,0.7251693898395726,0.5689087197146487},
{0.2692926233335789,0.6464760358911741,0.7138278630290026},
{0.24717498077217323,0.6779905616814799,0.6922668034443853},
{0.0,0.6736078681383807,0.7390889256253714},
{0.05785194009478825,0.6478195006530444,0.7595940018199914},
{0.0,0.6426530148385242,0.7661573614597432},
{-0.057851940094788244,0.6478195006530444,0.7595940018199915},
{-0.06602364442669328,0.6792227723009633,0.7309564309617991},
{-0.12918599239539552,0.6792252366225138,0.722470800312308},
{-0.15774252517061102,0.7150123107109568,0.6810834686619383},
{-0.18638195480929975,0.7486069150759666,0.6362778116686995},
{-0.2838365399995597,0.7675062388673337,0.5747790809178756},
{-0.3849742687627588,0.7725800279627211,0.504890990990828},
{-0.428048839743992,0.7831366113094804,0.45107786336787387},
{-0.45731714651194194,0.7914322918560391,0.4055810090643697},
{-0.39331622738830857,0.8310094009223461,0.3933519045990648},
{-0.48161029374871395,0.7991969225479488,0.35963287383825915},
{-0.5553003660451736,0.7647170278011517,0.32687822023051444},
{-0.6193224448614421,0.7270068922961548,0.2964805016265547},
{-0.6770189908608804,0.6850589114558512,0.2689601714913187},
{-0.7311515750970843,0.6369728778028175,0.2443008947520449},
{-0.783560717646746,0.5802397860331937,0.22215848501704832},
{-0.8303216711149148,0.5191889451269284,0.20250620171965744},
{-0.8758312258701013,0.44521779853915483,0.1862814420569699},
{-0.915926409089403,0.3616997929180572,0.17393123047810083},
{-0.9463414940830203,0.27771259979088203,0.16526792941797952},
{-0.9682500990874001,0.1911603976921796,0.1610883235104506},
{-0.9813755390299581,0.10384516436709394,0.16161136479601396},
{-0.9857270064817236,0.023473303614650807,0.16670714654745475},
{-0.982254207476212,-0.06698108949150043,0.17518620249839947},
{-0.9681923943453888,-0.16437379168167818,0.18863919036067608},
{-0.9434777450600836,-0.26079972465757983,0.20453177795851293},
{-0.9062450990312618,-0.3598638417838841,0.2218509316148166},
{-0.8541706078073231,-0.46180113518123517,0.23902360616347185},
{-0.7845320432930825,-0.5661376215730495,0.252977600759418},
{-0.6988955128861224,-0.6655156422750146,0.26198089998112223},
{-0.5916694843909779,-0.7635023723646717,0.25882687000006865},
{-0.49046741344922723,-0.8349543491346214,0.2495855588883412},
{-0.40203287347321615,-0.8836097762173606,0.24000694160789382},
{-0.3242207798720087,-0.9167709005433226,0.2332638030560504},
{-0.2551771367289349,-0.9391748179434477,0.22985928354476798},
{-0.19019402555609213,-0.9545157269649587,0.22962133964273634},
{-0.13220798890034646,-0.9634303517658398,0.23307296060949667},
{-0.0679015957785403,-0.9698210496039129,0.23417195612603225},
{0.11317267267147182,0.6479961282789451,0.7531885314420904},
{0.14703866616932873,0.6193467582556836,0.7712257929357137},
{0.16571469069470202,0.6483128236672211,0.7431212040822102},
{0.21717049790840015,0.6482064379127436,0.7298392896293608},
{0.19240028995433126,0.6193301887786004,0.7611913331698886},
{0.10065178302510895,0.619237238658006,0.7787261783406758},
{0.0,0.5910704151984276,0.806619962731619},
{0.04478922421079147,0.5745005949703716,0.8172777935153288},
{0.0473606091347209,0.5945656006719022,0.8026510569357324},
{1.093132061603208e-18,0.6148774869227659,0.7886226449167838},
{0.05165114644506794,0.619327127826478,0.7834322356203602},
{0.09167026281217255,0.5938718087855327,0.7993202347280762},
{0.08611209571183052,0.5730343097386732,0.8149947158322186},
{0.08348728973816998,0.5582284538411327,0.8254761448850677},
{0.043627181357136446,0.5604664142682881,0.8270272471473229},
{0.0,0.5721807139928516,0.8201275696711033},
{-0.04478922421079147,0.5745005949703716,0.8172777935153288},
{-0.047360609134720885,0.5945656006719022,0.8026510569357324},
{-0.05165114644506794,0.619327127826478,0.7834322356203602},
{0.08290799413550337,0.5517433026859924,0.8298828787543341},
{0.043358182925321974,0.554462296153047,0.8310785944290138},
{0.0,0.5595633785986823,0.8287875634511099},
{-0.04362718135713644,0.5604664142682881,0.827027247147323},
{-0.08348728973816998,0.5582284538411327,0.8254761448850677},
{-0.08611209571183054,0.5730343097386733,0.8149947158322186},
{-0.09167026281217255,0.5938718087855327,0.7993202347280762},
{-0.10065178302510891,0.619237238658006,0.7787261783406759},
{-5.251487224441507e-19,0.550695673487558,0.8347061010931242},
{0.04479489883041793,0.5404127715964773,0.8402067920066977},
{0.04371739000719283,0.5508044173372393,0.8334886223894982},
{1.8172141835235476e-18,0.5552332512080002,0.8316946776029013},
{0.08381043123352407,0.5477231323223075,0.8324513090478569},
{0.08638259308027615,0.5367393058705758,0.8393145805633904},
{0.09085888525585513,0.5156828164424857,0.8519482940859784},
{0.04673045349427781,0.5200891864772562,0.8528326347095572},
{-1.21409992939788e-18,0.5390418947252601,0.8422789536317535},
{-0.04479489883041793,0.5404127715964773,0.8402067920066977},
{-0.04371739000719283,0.5508044173372393,0.8334886223894982},
{-0.043358182925321974,0.554462296153047,0.8310785944290138},
{0.1438409487201834,0.4704596111252842,0.8706190531863658},
{0.0973484875237796,0.47974717304056813,0.8719896340762405},
{0.15722339722409318,0.4111399996956384,0.8979113007505727},
{0.1057561519824842,0.4214528433855286,0.9006626100378048},
{0.049636644862615216,0.48492702495716605,0.8731448814217344},
{0.05811479288380999,0.3355706426433474,0.9402207265552077},
{-9.582952732833894e-19,0.41656084231264723,0.9091078399462728},
{-5.611834373384265e-19,0.3177932482522725,0.9481600346804696},
{0.058488401761946016,0.18374775093648626,0.9812318130213249},
{0.0,0.1974320946879355,0.9803165651906194},
{-0.05848840176194603,0.18374775093648626,0.9812318130213248},
{-0.05811479288380999,0.3355706426433474,0.9402207265552077},
{-0.053508641663295796,0.42722527923207865,0.9025604611617005},
{0.0,0.47878204754232634,0.8779337964511774},
{0.05350864166329579,0.4272252792320786,0.9025604611617005},
{0.1155034447975335,0.32980688369663635,0.9369559080907791},
{0.12471664354836239,0.1916329907762209,0.9735104291522467},
{0.129349188762971,0.00015199654526477745,0.9915990945253085},
{0.07130153462196273,-0.022070686040665203,0.9972105976062666},
{0.0,6.4216021034437484e-18,1.0},
{-0.07130153462196273,-0.022070686040665203,0.9972105976062666},
{-0.12934918876297102,0.00015199654526478024,0.9915990945253085},
{-0.12471664354836239,0.1916329907762209,0.9735104291522467},
{-0.11550344479753351,0.3298068836966364,0.9369559080907791},
{-0.1057561519824842,0.4214528433855286,0.9006626100378048},
{-0.04963664486261521,0.48492702495716594,0.8731448814217343},
{7.035052426864688e-19,0.5168602463973164,0.8560697902006036},
{0.17232847329899695,0.3197343176315006,0.9317042789529065},
{0.18629810149162665,0.1845824098829003,0.9649986276375923},
{0.1934952815471557,0.00019904995386073248,0.9811011856063078},
{0.17709339308182834,-0.21448261357416776,0.9605389833844118},
{0.11450862041129853,-0.22437026232119794,0.9677529443186509},
{0.05203096398897375,-0.22975950919647845,0.971855620305903},
{0.0,-0.23140827206267192,0.972856727180816},
{-0.05203096398897376,-0.2297595091964785,0.971855620305903},
{-0.11450862041129853,-0.22437026232119794,0.9677529443186509},
{-0.17709339308182837,-0.2144826135741678,0.9605389833844118},
{-0.1934952815471557,0.0001990499538607298,0.9811011856063078},
{-0.1862981014916267,0.1845824098829003,0.9649986276375923},
{-0.17232847329899695,0.3197343176315006,0.9317042789529065},
{-0.15722339722409315,0.4111399996956384,0.8979113007505727},
{-0.0973484875237796,0.4797471730405682,0.8719896340762405},
{-0.04673045349427779,0.520089186477256,0.8528326347095573},
{0.20871827099087203,0.39635147705256335,0.8940593884037191},
{0.2858374915960498,0.2881332220600178,0.9139344477277299},
{0.22900492026010025,0.30556576670351016,0.9242220018564593},
{0.30768242188003775,0.1633826753548322,0.9373567243370754},
{0.24730813178778582,0.1749541834755627,0.9530108717302413},
{0.30643823692239297,-0.1939471918115574,0.9319227938731331},
{0.2276331606920614,-0.37006671631149185,0.9006851667657084},
{0.27713191940323345,-0.36085364777609585,0.8904956732823383},
{0.2530670589603809,-0.4636866336144221,0.8490887877462919},
{0.19585242626990837,-0.49871245489553206,0.8443504689737917},
{0.14240031683307625,-0.5284139978140706,0.8369592562843134},
{0.16843844888657386,-0.3963829087628939,0.9025015670775052},
{0.23967989331806006,-0.2010240525729678,0.9498120229951735},
{0.2568287776833703,0.00019435032174295593,0.9664569008401865},
{0.3191435751106039,0.00014982434912940912,0.9477063659268553},
{0.271971789568186,-0.5142709094271717,0.8133614063846577},
{0.3195829342539866,-0.49113268246182357,0.8103427894116573},
{0.273505358433451,-0.5547819562513728,0.785755559907844},
{0.23321451562845974,-0.5749784258776197,0.7842262425317565},
{0.1832548145809417,-0.6056898998315892,0.7743109311994143},
{0.21593146949384667,-0.5502644780583171,0.8065870099805946},
{7.129618481146575e-19,-0.40374402827513,0.9148719908447143},
{0.055375638335639424,-0.42888335824953644,0.90166102482891},
{0.11110066607434588,-0.41650862401979394,0.902317686912417},
{0.04583732531151941,-0.5640998242719357,0.824433337429205},
{6.336894897863187e-19,-0.5509162676460342,0.8345605226962052},
{-0.055375638335639424,-0.42888335824953644,0.90166102482891},
{0.0758394348651607,-0.6286771294176381,0.7739595900733651},
{0.11774335060443877,-0.6091775674913946,0.7842443462682455},
{0.16430314165919024,-0.5825716642226806,0.7959992045760701},
{0.09816342732326853,-0.6529069142811347,0.7510502665068672},
{0.0629064532211074,-0.6681184194415539,0.7413909601189242},
{0.030845826934571358,-0.6772524126988038,0.7351038732413071},
{0.03730327170642339,-0.6404247062328692,0.7671145035563725},
{0.09267136915471587,-0.5506227048085156,0.8295942708868864},
{-7.786936013191825e-19,-0.6914562205331785,0.7224183656898352},
{0.026550185933629653,-0.6897736106157475,0.7235381494606935},
{0.05420377799382536,-0.6831727508461836,0.7282423655298107},
{0.024170837292793495,-0.6873569709067388,0.725917464434131},
{-6.582934566142801e-19,-0.6903175099720579,0.7235065552059482},
{-0.026550185933629653,-0.6897736106157475,0.7235381494606935},
{-0.03084582693457136,-0.6772524126988038,0.7351038732413071},
{0.0,-0.6765317038996976,0.7364135072217047},
{-5.433170024451187e-19,-0.635193040407446,0.7723534174313885},
{0.11926011756806862,-0.6567866621812646,0.7445859955293573},
{0.13811823634162218,-0.6318875040971632,0.7626542696109014},
{0.08459078522087823,-0.672179987518974,0.7355395729902688},
{0.15829914703201273,-0.6370857036221954,0.754362768360919},
{0.8956840461631457,0.2159320621859595,-0.38874597614500744},
{0.889901246232766,0.2938258952261666,-0.3489156276922999},
{0.9066342441477698,0.22457006677500793,-0.35718711125581065},
{0.9052390444640176,0.15706680421791222,-0.3948066506413546},
{0.9174364509123886,0.16230680224296465,-0.363272432869525},
{0.9167450982382802,0.23129035155994482,-0.32570415737500663},
{0.8981367141873017,0.3032513989588563,-0.3184164437624633},
{0.869658749325181,0.3844171145737213,-0.30970492689813056},
{0.8641560512826898,0.3724125267842109,-0.3384423568729374},
{0.8811482318167281,0.28135176772732506,-0.38002496807836594},
{0.8835553004203675,0.20550734358203332,-0.4208286620858071},
{0.8917388031440501,0.1508010065143486,-0.4266860243803123},
{0.8972820714155025,0.09942481076298414,-0.43011578827223934},
{0.9113806156752595,0.1023684369422064,-0.39863025034409333},
{0.924107646475327,0.10481390833626814,-0.36747666911670535},
{0.9286250026833458,0.16652193844331623,-0.3315509740725192},
{0.8503608471949793,0.3471839937571793,-0.39541080414760027},
{0.8229546228530552,0.3835595692287764,-0.41907964109202583},
{0.821604867328591,0.4196850720755006,-0.38578476156912955},
{0.8256141155347783,0.43472920580040797,-0.35968298521597086},
{0.7741225045156989,0.513256658404173,-0.37054277837535016},
{0.7800980295894151,0.4777154154171068,-0.40402357122273574},
{0.7861975619501951,0.4335082165244033,-0.4404134645868584},
{0.8199034848810264,0.347146361387868,-0.45524463671207854},
{0.8469338834274976,0.30807771257575517,-0.43334872806610186},
{0.8705991667597033,0.267970386194374,-0.4126123640417823},
{0.8586909361225048,0.3560837892364908,-0.36858406268318034},
{0.8221384234894284,0.4665811410059774,-0.32617549184430983},
{0.7690741195444857,0.5411162681953212,-0.3401737540452577},
{0.9156862080985781,-0.0027889346793698033,-0.4018842994462483},
{0.9275828522196645,0.05006743765131672,-0.3702476251849071},
{0.9282113277054889,-0.003825852478080467,-0.37203372692812325},
{0.9136870349259186,-0.05777872515204042,-0.40229046860208895},
{0.9258493638941206,-0.06034977250078194,-0.37304270578039145},
{0.9395646716326697,-0.0046849218119026665,-0.34233942122900535},
{0.9391952720168645,0.050465217201217785,-0.33965497622440616},
{0.9357325087410444,0.1068947530651754,-0.336122275150467},
{0.9148228836552378,0.04971039002937534,-0.4007841921331761},
{0.901717851464581,-0.0017441855887781988,-0.4323214939911404},
{0.9000405087655858,-0.055226836534279004,-0.4322928163957869},
{0.8951661071927746,-0.11311504776238282,-0.4311410749430495},
{0.9083146401579589,-0.11788689525293658,-0.4013317759688867},
{0.9198961604861238,-0.12281891534447258,-0.3724333067228214},
{0.9368010548869946,-0.06284124039582599,-0.34417257599658946},
{0.8810234707733136,0.10292770996390117,-0.46173967824752893},
{0.8833725613148594,0.05137792238814401,-0.4658467849058343},
{0.9006465330101315,0.049209339373037696,-0.4317571811739778},
{0.8761597719266442,0.15063153041132096,-0.45788011105899135},
{0.8694122227734531,0.2010809369677703,-0.45131900434203653},
{0.8545147523552745,0.1773629280207337,-0.4882078755726048},
{0.8596048827123824,0.13304910054300806,-0.49333293267501194},
{0.8636378833397016,0.08986434842511148,-0.49603831035782925},
{0.8642193064592171,0.05044882770552824,-0.5005795702246425},
{0.8676783722647603,0.007528264511044416,-0.49706897663948785},
{0.8859215799724046,-0.0008028436395419203,-0.4638343557578382},
{0.845257915645242,0.043904687132691876,-0.5325518138987432},
{0.8465829016261093,-0.0009328586740805757,-0.5322560666155076},
{0.8681249470975636,-0.04793164304223287,-0.49402594448280157},
{0.8863023542771582,-0.04802517263208655,-0.46061016010985384},
{0.880806902776832,-0.09951225068462519,-0.46290011015808213},
{0.8733984744026435,-0.1666793811419517,-0.4575948959650563},
{0.8882162751991394,-0.1793043523544679,-0.42299148655512114},
{0.9002628343613899,-0.18702296479966476,-0.39312751074573776},
{0.9106275044494051,-0.19519915513523511,-0.36421811867991827},
{0.930180966031292,-0.12794475845861117,-0.3440835788236054},
{0.8173462795734188,0.07919766427987109,-0.5706774826818591},
{0.7844159705916387,0.10247883100752622,-0.611710449703214},
{0.8146259790864593,0.11358439171593379,-0.568755747360806},
{0.8425379370596552,0.08487466726158586,-0.5319079953079251},
{0.8391712349975977,0.1237763885008009,-0.529595169919728},
{0.8122666689936542,0.14644122444558957,-0.5646041323129243},
{0.7833994265979065,0.12913454901346938,-0.6079552669869381},
{0.7529136866547683,0.11156806063308004,-0.6485935154582558},
{0.7525993739670578,0.09130594635995853,-0.6521176323821531},
{0.7865410215109453,0.07287100704486008,-0.613223481132928},
{0.8198867983905065,0.041616580194523585,-0.5710111190492507},
{0.8354605418119695,0.1624919818282831,-0.5249781318462393},
{0.8103733805815454,0.1796678496076208,-0.557686693280565},
{0.783986361537547,0.15420725989312645,-0.6013198033653742},
{0.7560010594241123,0.12815388573050196,-0.6419026247974013},
{0.7335387338262488,0.10396927873975124,-0.6716482078103981},
{0.7284340288809823,0.09551976474763814,-0.6784245279401211},
{0.7270539658552666,0.08130807301130787,-0.6817488745845618},
{0.7541786948027985,0.06654990600103224,-0.6532883026021519},
{0.7889488140714586,0.03890410609920548,-0.6132260915061107},
{0.8213037160947145,-0.0008374553961560037,-0.5704905823915695},
{0.831152101122108,0.20333956186939162,-0.5175318418987077},
{0.8477477978534983,0.22530535189986192,-0.480167855691969},
{0.8594048233999123,0.2486481796032944,-0.4467632844101376},
{0.8375340874095007,0.2802453651279087,-0.46904071012169074},
{0.8250534299271747,0.24939569490579305,-0.5070390765294737},
{0.8083819442349367,0.21576923553366692,-0.5476881131010246},
{0.7894312868742803,0.2069974367819341,-0.5778843348540667},
{0.8044379773567107,0.2586883440061465,-0.5347521680756439},
{0.814148355526145,0.3054512600967286,-0.4938238379213731},
{0.7937009126284598,0.31562900665085897,-0.520016529980867},
{0.7914155057978052,0.24149381534195982,-0.5615534118268605},
{0.7810579420967338,0.1736894006680622,-0.5998170414244534},
{0.7724622295695716,0.15310460548894964,-0.6163287139720813},
{0.7862251039181806,0.17936300179584097,-0.5913366211859632},
{0.762450448076206,0.14179983718010505,-0.6313177649995986},
{0.7433311117036574,0.10650967325749018,-0.660389693950464},
{0.729531101531618,0.07700032681595517,-0.6795993831429662},
{0.718338903956469,0.08398998906505042,-0.6906047355756195},
{0.7125077970693372,0.08250074553739727,-0.6967971484594164},
{0.7108285423771502,0.0733776544591976,-0.6995273426879343},
{0.7282154995262766,0.061041483870993306,-0.6826244381037956},
{0.7565308851945612,0.036239216513422365,-0.652953090913296},
{0.790494730211102,-0.0009059187111631477,-0.6124681712707737},
{0.8205003667149019,-0.04731905351898442,-0.5696841716203627},
{0.8455748712694853,-0.049519556517324995,-0.5315552187683994},
{0.8623921970812971,-0.10546652902589859,-0.4951328202296051},
{0.8922704401161953,-0.27047593438184475,-0.36151933643322476},
{0.9015047884173563,-0.27802162904377303,-0.3316520620234768},
{0.9203788236103642,-0.19471079960467025,-0.3391025295790524},
{0.8830127054220985,-0.25909226685038894,-0.3913563073740769},
{0.871804822434869,-0.24832568693118448,-0.42224483986126055},
{0.8597890231842142,-0.34038465661769474,-0.38065879886216825},
{0.8670331634508872,-0.3553072978128445,-0.3492996100731891},
{0.8721441432621575,-0.3712317404266647,-0.31867159941436035},
{0.7126181463327105,-0.6427443276083408,-0.28116740003889784},
{0.778287924193243,-0.5249021133333818,-0.34459494841497973},
{0.7799461184930744,-0.5444862517025266,-0.3085753942791292},
{0.7095726161478259,-0.6608567416908347,-0.24448940544511022},
{0.779045252284347,-0.5641436748623823,-0.2735514741433226},
{0.8306021183269154,-0.447335533258494,-0.3316489736380612},
{0.8259868764565581,-0.4294147477719247,-0.36516935018907704},
{0.8188093640521271,-0.4119652374229251,-0.3997947829769968},
{0.7739109263799372,-0.5051540828247092,-0.3819440150536126},
{0.7135286617945463,-0.6235806931749177,-0.31941190944793063},
{0.6328424204362698,-0.7318480447862088,-0.2528021167612467},
{0.6291654285549105,-0.7467187527933626,-0.21578222294257882},
{0.8382920423345114,-0.3122768762960579,-0.4469335569068518},
{0.8502987188430555,-0.32613897643911777,-0.4130683439590874},
{0.858352821586836,-0.23791625734250238,-0.454561643967079},
{0.8421932102624431,-0.22762028444213395,-0.4887735699670372},
{0.8233305240037805,-0.29850192672072484,-0.48272502316295485},
{0.8088080948367536,-0.3946891509866415,-0.4359471754926106},
{0.7664722616443685,-0.4850131935373733,-0.4210492539174544},
{0.7119259179598751,-0.6032249792811211,-0.35955682681362083},
{0.6352190718432376,-0.7148911000757653,-0.2922797389472591},
{0.5478227429908494,-0.8052197403899553,-0.2269612564917523},
{0.5447179710820154,-0.8166170854982151,-0.19083728056303254},
{0.6990581008431322,-0.5580529213042877,-0.4470958607159583},
{0.7401893920546362,-0.44234059539047504,-0.5064133307481037},
{0.7554815859868089,-0.46419250540121393,-0.4623558058078215},
{0.7073267200604348,-0.5814659898877036,-0.4019778771182069},
{0.7955457590589391,-0.3772774360577344,-0.47409775519932434},
{0.7783469229983829,-0.3593795455517165,-0.5148032728120434},
{0.752179960813702,-0.35182929626016857,-0.5571727316042774},
{0.7134698949555291,-0.43150386512311684,-0.5520553626004886},
{0.6861884845322502,-0.5326385231861684,-0.4954205963758382},
{0.6280805084313829,-0.6492193698292371,-0.42898611255739255},
{0.6336514637410119,-0.6738645319076599,-0.3799900197843932},
{0.6357277647530687,-0.6956463197584243,-0.3345540418656258},
{0.728809851848499,-0.3172675237579526,-0.6067763329407845},
{0.7789520784710208,-0.27994165614012223,-0.5611295114349291},
{0.6933556929450494,-0.39013845422719556,-0.6058464075934632},
{0.6404072169667401,-0.479912230690731,-0.5996355954163838},
{0.6637085986178455,-0.5164135992441867,-0.5411172614474614},
{0.6178464969640318,-0.6212516483016474,-0.481987650953591},
{0.5484012400224932,-0.7287477520350533,-0.4101009556751218},
{0.5518215886349102,-0.7533538974104323,-0.3577021660165839},
{0.5521731007828138,-0.773959948894111,-0.3099852646170744},
{0.5505492316404018,-0.7911063701471717,-0.26654503306707716},
{0.7532939275340615,-0.25148354289401076,-0.60770411089097},
{0.7970817738095749,-0.2153542141217775,-0.5641659404116606},
{0.7697919553263645,-0.19224218990751524,-0.6086569525885459},
{0.7221641354736518,-0.23632426555564104,-0.6500998407515416},
{0.6979022377688977,-0.29767402702464285,-0.6514005220692544},
{0.6627802369325425,-0.36541427610860694,-0.653601380313464},
{0.6132764677714833,-0.43900211608282796,-0.6566346900313235},
{0.5505455372672063,-0.5117428664004657,-0.6595595879701835},
{0.566894929554645,-0.563615238090571,-0.6008061269971728},
{0.6014171543776828,-0.589331683604817,-0.5394307862179932},
{0.5405241356882624,-0.699418522341506,-0.4675974650744818},
{0.46242490940514624,-0.7952534801247381,-0.39209068531544505},
{0.46439702191159843,-0.8190270826929921,-0.33694219660803115},
{0.46388390295211446,-0.8378655547843354,-0.2877377915530929},
{0.462065489000459,-0.852618253713108,-0.24400327315422818},
{0.45989925521286523,-0.8639328619122295,-0.20521375480897092},
{0.8344305872585885,-0.15644169504637026,-0.5284426090866495},
{0.8546339523822067,-0.16368942770171027,-0.492754075269048},
{0.8417208494944096,-0.10097113777208179,-0.5303874441042327},
{0.8169317792093764,-0.09629963144653526,-0.5686377134002493},
{0.8077984732069678,-0.15153114574361082,-0.5696489608119375},
{0.8226523237419056,-0.21719413784674668,-0.5254235060663458},
{0.8047460688878566,-0.2844952846265555,-0.5210049881093234},
{0.7899222980785244,-0.045011706318746306,-0.6115527036099324},
{0.7841429346886244,-0.09366563462743262,-0.6134709503047003},
{0.7579424916990032,-0.042618439612553544,-0.6509276825286335},
{0.7500414878610856,-0.08409527188843974,-0.656022676233938},
{0.7489657284854399,-0.1305674399758696,-0.6496171804781812},
{0.7761800173904285,-0.14303854965188137,-0.6140721080763075},
{0.7132322271892804,-0.1716268841953023,-0.6795910555032572},
{0.7384657452084052,-0.1809220680817229,-0.6495656613729108},
{0.6970084543856754,-0.22396617567723998,-0.6811889361017276},
{0.7236143585718391,-0.1239985043960323,-0.6789746909688261},
{0.7259430742693385,-0.0801099774052611,-0.6830732350491493},
{0.7079150355980396,-0.11910085742508596,-0.6961833724923597},
{0.6976576152716201,-0.16478483613620137,-0.6972229267838813},
{0.6815148122232778,-0.21501980558735645,-0.6995027118785501},
{0.6572858467567042,-0.2705853044707201,-0.7033910069497692},
{0.6727870751539727,-0.2818015323963456,-0.6840653827265593},
{0.6377284806990601,-0.3455055929814191,-0.6884244839659805},
{0.5884836984528801,-0.4144058657526954,-0.6942295838445512},
{0.5264062970304849,-0.4820832128740247,-0.7003514734129648},
{0.4568429604137586,-0.5411836965200894,-0.7059849262847223},
{0.4797998981489246,-0.5758053216965531,-0.6619971973069151},
{0.4928977556399636,-0.6319576161843432,-0.5980646903401747},
{0.5264690506307272,-0.6644081104352819,-0.5304641378225289},
{0.45646319165955124,-0.765435593987624,-0.4535964132538851},
{0.37237478170517335,-0.8483783265663758,-0.37628611050962296},
{0.3735619958995773,-0.8709978364985984,-0.3190833810061015},
{0.37290556453385365,-0.8879955834162555,-0.26908229925603055},
{0.37155261935958944,-0.9005614675155563,-0.22569380645745557},
{0.3704172031223873,-0.9095794548850156,-0.18829846224031047},
{0.37025653025393923,-0.9156902457483493,-0.15627372026556838},
{0.45813061786185766,-0.8723035175329961,-0.1708885902483683},
{0.7120831479985302,-0.07716350659379217,-0.6978419474255277},
{0.7133613922835006,-0.040189063391906754,-0.6996430255373285},
{0.7163695542348059,-0.03913613665165643,-0.6966225840248135},
{0.7323100067838558,-0.04062620847781612,-0.6797584608880907},
{0.7163588894003983,-0.0008732331968259664,-0.697731451950399},
{0.7129470199327679,-0.0008869373353375165,-0.7012173415647596},
{0.7243283657536395,-0.0009270472366088865,-0.6894545374048118},
{0.7279295686031217,-0.035963755857577925,-0.6847080775176307},
{0.7223599731302606,-0.07311025725952368,-0.6876415923304054},
{0.7107980668768351,-0.07887654642655154,-0.698959654449364},
{0.7049665154030704,-0.11578899745782263,-0.6997250318719239},
{0.6548917308027754,-0.2643520851782891,-0.7079793753973599},
{0.619565665272276,-0.3248791877927779,-0.7145571354026403},
{0.6221377412798443,-0.33172363081991363,-0.7091572911779638},
{0.572801278372433,-0.39774720578359574,-0.7167257884199845},
{0.5107898487046676,-0.4623421729671167,-0.7247989000793996},
{0.44161334288790705,-0.5183699662307251,-0.7323047408649795},
{0.3681359626048383,-0.5643484661534045,-0.7389091431206606},
{0.3823801207534748,-0.5901732340051733,-0.7109718680204112},
{0.40338240979583134,-0.6295567164745889,-0.6640338637517234},
{0.4128483157315113,-0.6893205390796656,-0.595309551914442},
{0.4446721306542966,-0.7281461280044298,-0.5216032136514545},
{0.36788513356222907,-0.8185750276979317,-0.44112974569080177},
{0.2800370860535686,-0.8884705213763484,-0.36359230338370163},
{0.28090982414761956,-0.9099857380935827,-0.3049846343074203},
{0.28054395302216323,-0.9254294237570596,-0.25470663922908443},
{0.27995625242868377,-0.9363035155682973,-0.21203825942629861},
{0.2799262544004232,-0.9437032341762865,-0.17625407201697874},
{0.281095316548348,-0.9484069322491019,-0.1466619032892713},
{0.6790373778989458,-0.20958985839572739,-0.7035483854531849},
{0.6949596914476862,-0.160360419978486,-0.7009390579552978},
{0.6922205699198793,-0.2070507467162398,-0.691346997436197},
{0.6684078142435158,-0.2626335504481562,-0.6958840507133363},
{0.6328828410803744,-0.32485122734548405,-0.7028022407179464},
{0.5818992812540862,-0.3929286995809608,-0.7120395098037698},
{0.5696997782259449,-0.39039433261917095,-0.7232111916640542},
{0.5068582535510179,-0.45451729998465945,-0.7324675657132316},
{0.43680291440827873,-0.5099756092807118,-0.7410317752318054},
{0.3627667846695047,-0.5551403776606351,-0.748478069839963},
{0.287671195528792,-0.5898157157989321,-0.7545612663393404},
{0.29300842438342994,-0.6000095831694647,-0.7444021516258165},
{0.30553527555772786,-0.6286131908589517,-0.7151878436243101},
{0.32369188702760404,-0.6723165092353597,-0.6657432490698568},
{0.32903861864641815,-0.7349875348091892,-0.5928970493385576},
{0.35827766306971165,-0.7796039018304881,-0.513668056624105},
{0.2766494068662797,-0.8588830995144493,-0.43102775670365867},
{0.18657206642130728,-0.9162425130959957,-0.3545285901402278},
{0.18734899444693387,-0.9369327408641488,-0.29505489891970355},
{0.18741504614913668,-0.9512887430497708,-0.24479650288291274},
{0.1875178570367302,-0.9610682000099882,-0.2029407997961814},
{0.1882505535095296,-0.9675304795014932,-0.16866090340967113},
{0.19009094690729622,-0.9715580548009867,-0.14121040349496303},
{0.6110991000990796,-0.40466209466524955,-0.6802988159619474},
{0.5423233383210194,-0.479035952931563,-0.6902245667254204},
{0.5169127370674222,-0.4599930674852905,-0.7219470895591582},
{0.4441230334812702,-0.518024920423344,-0.7310300356016726},
{0.36731741086860503,-0.5650662591137334,-0.7387679219375969},
{0.29639448709320776,-0.5960297174440132,-0.7462565805032234},
{0.2169519313594084,-0.623521528139664,-0.7511010340998079},
{0.22034191142783843,-0.6130168927409679,-0.7587224336228204},
{0.21812837430793802,-0.62600081196692,-0.7486941937390278},
{0.22819724906152128,-0.6569740263991278,-0.7185479414469657},
{0.23699542051608682,-0.7106853184108263,-0.6623892728975203},
{0.24969051223504707,-0.7732143113770541,-0.5829187565874921},
{0.26920700467299435,-0.8186774144683066,-0.5072424269266944},
{0.18416114881087067,-0.8868558973065901,-0.4237585263816921},
{0.09272206910908816,-0.9324417846793808,-0.3492204691653406},
{0.09331308734421741,-0.9526779387706471,-0.2893050513039855},
{0.09359596948104495,-0.966456613508533,-0.23916815988446571},
{0.09397446384252794,-0.9756969266350692,-0.19795026521929668},
{0.09478262571798,-0.981768708824922,-0.16476181667562098},
{0.09629091410844481,-0.985625526013805,-0.13881780264134214},
{0.6637789653584779,-0.33027433370691534,-0.671056144925357},
{0.6992961858886934,-0.2637765959154721,-0.6643844909754982},
{0.711666036059845,-0.3378205348936361,-0.6159616378663894},
{0.6571931277954851,-0.42266834863212605,-0.6240582183121851},
{0.5830961316419935,-0.5097234755069308,-0.6325985138943012},
{0.4884270250760799,-0.5795970619634299,-0.6523084293021902},
{0.4688566851784171,-0.5354542550421261,-0.7024686110573116},
{0.39422508120844285,-0.5887139940280183,-0.7056928641992741},
{0.3018043380239127,-0.6298006567596527,-0.7157270948448564},
{0.2161152557324422,-0.6632008219271626,-0.7165604412991532},
{0.13774516659905914,-0.6434286065919048,-0.7530112199016673},
{0.14398902135277117,-0.6310239268247498,-0.7622833892356201},
{0.15160981296780673,-0.6443053229366873,-0.7495899648790114},
{0.15156252149671554,-0.6761587717959924,-0.7209980009687216},
{0.1463832173199221,-0.729509408058267,-0.6681227261825071},
{0.16966406415746482,-0.7894553744318936,-0.5898934794640218},
{0.17895980810298573,-0.8457602732215581,-0.5026558935533711},
{0.09132589113340937,-0.9031495479574944,-0.41950026893061987},
{-1.2595411968785639e-18,-0.9334354575494652,-0.3587453784920727},
{0.0,-0.954906834775311,-0.2969056026743126},
{0.0,-0.9694786711421213,-0.24517566396464957},
{-1.9123188326706476e-18,-0.9792398773058537,-0.20270486598504892},
{1.77877286132372e-18,-0.9856866886903596,-0.16858751952215884},
{0.0,-0.9898667528599345,-0.14199933655665165},
{0.80504476744306,-0.2611362897808969,-0.5326450605910251},
{0.767893558540169,-0.2030020240081972,-0.6075604175726815},
{0.7465056646829674,-0.26467940253842864,-0.610470397700119},
{0.7721755360788068,-0.34215617218207284,-0.5354195507441983},
{0.7222819542276869,-0.20576336563872544,-0.6602804070681318},
{0.7366180143874362,-0.15529217334054754,-0.6582387422349737},
{0.7805454224390307,-0.15096839792937067,-0.6065949112349315},
{0.8239278683067816,-0.19569442871413084,-0.5318332054297596},
{0.8597927728051276,-0.2491825046755444,-0.44571792335028715},
{0.8304658661003848,-0.33545808228427987,-0.44474073376776635},
{0.7764492719006476,-0.4374106333311298,-0.4536501581767761},
{0.7169826174857115,-0.4406993314209557,-0.5401111232963645},
{0.6380287399368388,-0.5346337267144703,-0.554153503349033},
{0.541652489675549,-0.6302182560934474,-0.5562710940852608},
{0.4024750305182558,-0.6485070820234337,-0.6461055752543701},
{0.7170766316277185,-0.11344623814439046,-0.6876998294491075},
{0.7076077484234395,-0.15769534276505523,-0.6887840396244109},
{0.7451247977577395,-0.11087287046354281,-0.6576444650125646},
{0.7876546651475379,-0.10641708204724598,-0.6068570944793096},
{0.8343995719727213,-0.14253618402177903,-0.5324103591556507},
{0.875643166571033,-0.1822292192254253,-0.4472600546638899},
{0.9014608888050178,-0.23101564468612368,-0.3660601560742737},
{0.8765819376682077,-0.3174714353244412,-0.3616849379043722},
{0.8168132978698962,-0.4435088376692015,-0.36893894797407606},
{0.6939408302022898,-0.5619791881429098,-0.45013944092069164},
{0.5866744757953026,-0.6834309996965326,-0.4344365639585425},
{0.4335819965333054,-0.7159636880153057,-0.5471769820868881},
{0.3110450515051128,-0.6939661186663985,-0.6493550662598052},
{0.8424489034288611,-0.06120385263571792,-0.5352886450636278},
{0.80067253492194,-0.032234107319655404,-0.598234447476054},
{0.7912317188744457,-0.06736147369543927,-0.6077950303421119},
{0.8398906888991037,-0.09853243198040702,-0.5337368176813508},
{0.7496916594676253,-0.0710198916348005,-0.6579654935609157},
{0.7575039980530439,-0.03462560174036733,-0.6519116202659462},
{0.792288998916615,-0.001102865290621064,-0.6101450039817248},
{0.8431344366744804,-0.001087342087073491,-0.5377017197115815},
{0.8524677817633813,-0.02837361636245557,-0.5220092134722684},
{0.8900193513151735,-0.053141635047556375,-0.45281510675880754},
{0.8881545052067756,-0.08761355763878487,-0.451115771613876},
{0.883982152737779,-0.12967442589586636,-0.4491771331108245},
{0.7366891409879154,0.03140871419332157,-0.6755017410956167},
{0.7470365397310791,0.05957871779437093,-0.6621078346406987},
{0.7585109620719637,0.1022189846040451,-0.6435933495641343},
{0.7712237816475943,0.04251386715951651,-0.6351428577259819},
{0.7625598731797136,-0.006355929309954889,-0.6468864212354021},
{0.752439309277581,-0.026262287223043718,-0.6581378108904633},
{0.7311203032114255,0.02697611821406872,-0.681715036711186},
{0.7208341646317223,0.058040700983693516,-0.6906731384157114},
{0.7114227524186922,0.07155470160411757,-0.6991120024855514},
{0.7071169639268065,0.07457807164694953,-0.7031526936280326},
{0.706500581171084,0.06859161392093965,-0.7043806636362481},
{0.711932625666957,0.05677604586471232,-0.6999488675088492},
{0.730543348684606,0.033988999981674636,-0.6820199143521603},
{0.7582656873515409,-0.0009018313940115492,-0.6519450391600752},
{0.7324435706444375,-0.0008816296239308803,-0.6808271723064767},
{0.7143312189369948,0.032292214694288585,-0.6990623166228639},
{0.7081932506160267,0.05414718225156258,-0.7039392036505154},
{0.7167049687956708,0.06770549994507775,-0.6940820938338517},
{0.7193293112302492,0.053222921839797224,-0.6926273620034443},
{0.7108244190249303,0.031183537972731504,-0.7026779008033291},
{0.7492905048425275,0.02986168666641177,-0.6615678491449442},
{0.7222074213104335,0.030527397584218914,-0.691002546016199},
{0.74638696629674,0.05320469535071682,-0.6633820595516484},
{0.7881408900160582,0.05269799445106812,-0.6132347502103338},
{0.7907089339208709,0.02850028147414867,-0.6115285077358323},
{0.7512343306442194,-0.0010105425210732804,-0.6600348167069254},
{0.8369918485794894,0.07287501335800364,-0.5423411083806574},
{0.7845572354248116,0.07235316262168762,-0.6158205616908355},
{0.7430073345571608,0.069693825481641,-0.6656447036400109},
{0.7798092020319578,0.08774172213087854,-0.6198378809203169},
{0.832203837652981,0.09479087398702772,-0.5463071139976361},
{0.8821255446881676,0.09627945872791427,-0.461069180531147},
{0.8862359468041733,0.06961241103066987,-0.4579737534210968},
{0.8400903127129544,0.0501945853545477,-0.5401192184017668},
{0.8420222666115782,0.025900063738963017,-0.53882064662429},
{0.7152884996931516,0.07377325872408856,-0.6949243617142438},
{0.7366677635146786,0.0807386337066369,-0.6714178127108834},
{0.7162146586075968,0.07053803445825939,-0.694306091353352},
{0.7209021417858265,0.05606576738108343,-0.6907653231717545},
{0.7353541463776297,0.07228359193317484,-0.6738170090925769},
{0.7667879729650375,0.10272567011109072,-0.6336273677930875},
{0.7738095678944444,0.09837322733413241,-0.6257327390978359},
{0.73956806293796,0.07920092305111168,-0.6684057854851687},
{0.8006495936345582,0.15893866880376673,-0.5776666233838541},
{0.7597505930047957,0.09760469833364145,-0.6428470730213056},
{0.7374137988552332,0.0500782148303728,-0.6735822604977781},
{0.7577636658495998,0.05257493024102067,-0.6504076440420484},
{0.7817696277268888,0.14757899528491863,-0.6058520358259559},
{0.8162146403352223,0.24760344806360152,-0.522002100962687},
{0.8467313937184372,0.20971802560234656,-0.48894201765555645},
{0.8147429080037236,0.13817419779203732,-0.5631180026621089},
{0.825045255247627,0.1165246124560828,-0.5529216413609959},
{0.0,-0.9022423828113588,-0.43122926925115057},
{0.08848812408710884,-0.8614688142473582,-0.5000413322664385},
{-1.5673307631858704e-18,-0.8577829830340945,-0.5140120173859075},
{-0.08848812408710884,-0.8614688142473582,-0.5000413322664385},
{-0.09132589113340937,-0.9031495479574944,-0.41950026893061987},
{-0.09272206910908816,-0.9324417846793808,-0.3492204691653406},
{-0.09331308734421741,-0.9526779387706471,-0.2893050513039855},
{-0.09359596948104497,-0.966456613508533,-0.23916815988446583},
{-0.09397446384252794,-0.9756969266350692,-0.19795026521929668},
{-0.09478262571798,-0.981768708824922,-0.16476181667562098},
{-0.09629091410844481,-0.985625526013805,-0.13881780264134214},
{-0.18825055350952957,-0.9675304795014932,-0.16866090340967113},
{-0.19009094690729622,-0.9715580548009867,-0.14121040349496303},
{-0.27992625440042324,-0.9437032341762865,-0.17625407201697876},
{-0.28109531654834796,-0.9484069322491019,-0.14666190328927128},
{-0.3704172031223874,-0.9095794548850157,-0.18829846224031052},
{-0.37025653025393923,-0.9156902457483495,-0.15627372026556835},
{-0.45989925521286523,-0.8639328619122295,-0.20521375480897092},
{-0.45813061786185766,-0.872303517532996,-0.1708885902483683},
{-0.5478227429908494,-0.8052197403899553,-0.2269612564917523},
{-0.5447179710820155,-0.816617085498215,-0.19083728056303262},
{-0.6328424204362697,-0.7318480447862087,-0.25280211676124664},
{-0.6291654285549105,-0.7467187527933625,-0.21578222294257876},
{-0.7126181463327105,-0.6427443276083408,-0.2811674000388979},
{-0.7095726161478259,-0.6608567416908347,-0.24448940544511027},
{-0.7799461184930744,-0.5444862517025266,-0.3085753942791292},
{-0.779045252284347,-0.5641436748623823,-0.2735514741433226},
{-0.8306021183269154,-0.447335533258494,-0.3316489736380612},
{-0.8327515721703932,-0.46602765655272327,-0.2989030651828709},
{-0.8670331634508873,-0.3553072978128444,-0.3492996100731891},
{-0.8721441432621575,-0.3712317404266647,-0.31867159941436035},
{-0.8922704401161953,-0.27047593438184475,-0.36151933643322476},
{-0.9015047884173563,-0.27802162904377303,-0.3316520620234768},
{-0.9106275044494053,-0.19519915513523511,-0.36421811867991816},
{-0.9203788236103643,-0.19471079960467028,-0.33910252957905235},
{-0.930180966031292,-0.12794475845861114,-0.3440835788236053},
{-0.9198961604861238,-0.12281891534447259,-0.3724333067228214},
{-0.9368010548869946,-0.06284124039582599,-0.34417257599658946},
{-0.9258493638941206,-0.060349772500781954,-0.37304270578039145},
{-0.9395646716326697,-0.0046849218119026665,-0.34233942122900535},
{-0.9282113277054889,-0.003825852478080467,-0.3720337269281232},
{-0.9391952720168645,0.050465217201217785,-0.33965497622440616},
{-0.9275828522196645,0.05006743765131672,-0.3702476251849071},
{-0.9357325087410444,0.1068947530651754,-0.336122275150467},
{-0.924107646475327,0.10481390833626814,-0.3674766691167054},
{-0.9286250026833458,0.16652193844331623,-0.3315509740725192},
{-0.9174364509123886,0.16230680224296468,-0.3632724328695251},
{-0.9167450982382802,0.23129035155994482,-0.32570415737500674},
{-0.9066342441477698,0.22457006677500796,-0.35718711125581065},
{-0.8981367141873016,0.3032513989588562,-0.3184164437624632},
{-0.889901246232766,0.29382589522616653,-0.34891562769229995},
{-0.869658749325181,0.38441711457372124,-0.3097049268981305},
{-0.8641560512826898,0.3724125267842109,-0.3384423568729374},
{-0.8264784465807805,0.47639209270329397,-0.2999732510528164},
{-0.8221384234894284,0.4665811410059774,-0.32617549184430983},
{-0.7701277597927487,0.5660979275097014,-0.2940006293629711},
{-0.7519777005434594,0.5820131608767798,-0.30949994903326083},
{-0.7690741195444856,0.5411162681953212,-0.3401737540452576},
{-0.8256141155347783,0.43472920580040797,-0.35968298521597086},
{-0.7741225045156989,0.513256658404173,-0.37054277837535016},
{-0.821604867328591,0.41968507207550054,-0.38578476156912955},
{-0.7800980295894152,0.4777154154171067,-0.40402357122273563},
{-0.8229546228530552,0.3835595692287764,-0.41907964109202583},
{-0.7861975619501951,0.4335082165244033,-0.4404134645868584},
{-0.8199034848810264,0.34714636138786786,-0.45524463671207843},
{-0.7912672685818961,0.37966814448207375,-0.47932057095067876},
{-0.814148355526145,0.3054512600967286,-0.4938238379213731},
{-0.7937009126284598,0.31562900665085897,-0.520016529980867},
{-0.8044379773567107,0.2586883440061465,-0.5347521680756439},
{-0.7914155057978052,0.24149381534195982,-0.5615534118268605},
{-0.7894312868742802,0.20699743678193414,-0.5778843348540668},
{-0.7810579420967338,0.17368940066806218,-0.5998170414244534},
{-0.7724622295695714,0.1531046054889496,-0.6163287139720813},
{-0.7770505759714791,0.10976017954221809,-0.6197944057260056},
{-0.7585109620719637,0.1022189846040451,-0.6435933495641343},
{-0.7712237816475943,0.04251386715951651,-0.6351428577259819},
{-0.7470365397310791,0.05957871779437093,-0.6621078346406987},
{-0.7625598731797136,-0.006355929309954889,-0.6468864212354021},
{-0.7366891409879154,0.03140871419332157,-0.6755017410956167},
{-0.752439309277581,-0.026262287223043718,-0.6581378108904633},
{-0.7311203032114254,0.02697611821406872,-0.681715036711186},
{-0.7494562479470342,-0.006937520139306618,-0.6620175248643122},
{-0.7374137988552332,0.0500782148303728,-0.6735822604977781},
{-0.7577636658495998,0.05257493024102067,-0.6504076440420484},
{-0.7597505930047957,0.09760469833364145,-0.6428470730213056},
{-0.7817696277268888,0.14757899528491863,-0.6058520358259559},
{-0.8006495936345582,0.15893866880376673,-0.577666623383854},
{-0.8162146403352223,0.24760344806360152,-0.522002100962687},
{-0.7588118946195388,0.19022173781336055,-0.622912673692847},
{-0.7736401257778949,0.3402985573805473,-0.5344883980322503},
{-0.7112329148136224,0.23295317015627554,-0.6632349217282365},
{-0.6959315663668175,0.4434411478210673,-0.5648355542574869},
{-0.6431935394458188,0.2879738188721148,-0.7094879494814342},
{-0.587749317928813,0.5542244349084885,-0.5893946174038083},
{-0.5607906241327066,0.3407376926267312,-0.7545937322216905},
{-0.46508442983060183,0.6478614047489297,-0.6033009807433495},
{-0.4645785851329816,0.38768033309424177,-0.796159969835067},
{-0.345000128819674,0.7142026936413045,-0.6090069158145195},
{-0.34385400622737317,0.4295710272861772,-0.8350048831699632},
{-0.22932528692795418,0.7569147161686308,-0.6119559013709832},
{-0.18688961023451897,0.4627489619194118,-0.8665654457851965},
{-0.11314633543794035,0.7811930301685148,-0.6139506139691523},
{7.83681913974e-18,0.542641450397026,-0.8399644375275729},
{0.0,0.826922828016395,-0.5623154243886324},
{0.11314633543794035,0.7811930301685148,-0.6139506139691522},
{0.18688961023451894,0.4627489619194118,-0.8665654457851965},
{0.2293252869279541,0.7569147161686308,-0.6119559013709831},
{0.3438540062273731,0.42957102728617713,-0.8350048831699632},
{0.34500012881967407,0.7142026936413045,-0.6090069158145195},
{0.46457858513298167,0.3876803330942417,-0.796159969835067},
{0.46508442983060183,0.6478614047489297,-0.6033009807433495},
{0.5607906241327066,0.34073769262673115,-0.7545937322216905},
{0.587749317928813,0.5542244349084885,-0.5893946174038083},
{0.6431935394458188,0.2879738188721148,-0.7094879494814342},
{0.6959315663668175,0.4434411478210673,-0.5648355542574869},
{0.7112329148136224,0.23295317015627554,-0.6632349217282365},
{0.773640125777895,0.34029855738054726,-0.5344883980322503},
{0.7588118946195388,0.19022173781336055,-0.622912673692847},
{0.0,-0.6912946187919378,-0.7225730067123387},
{0.0661527683087015,-0.7404570441543814,-0.6688401729914643},
{1.4163796311185729e-18,-0.7422579778207241,-0.6701142397841502},
{-0.0661527683087015,-0.7404570441543814,-0.6688401729914643},
{1.751774030660367e-18,-0.7961154802916726,-0.6051447281766235},
{0.0835901384789194,-0.8035968663367582,-0.5892747789977248},
{0.08321939948329579,-0.6905178616006122,-0.7185120836563276},
{0.07539198937358597,-0.6549508009818297,-0.7519012543090701},
{0.0,-0.6525877523631273,-0.7577131551356633},
{-0.07539198937358597,-0.6549508009818297,-0.7519012543090701},
{-0.08321939948329579,-0.6905178616006122,-0.7185120836563276},
{-0.1463832173199221,-0.729509408058267,-0.6681227261825071},
{-0.0835901384789194,-0.8035968663367582,-0.589274778997725},
{8.320813592609013e-19,-0.6597348045489195,-0.7514984947867819},
{0.06767715218095517,-0.6903165790487853,-0.720335216245227},
{0.06711641773913184,-0.6525648748586662,-0.754754576382654},
{0.0,-0.6438414026513067,-0.7651589692554075},
{0.06740778976699702,-0.641129027697873,-0.7644669775221872},
{0.14001213430180745,-0.6807312623892385,-0.7190281987893147},
{0.1430272864217304,-0.7446023648866645,-0.6520049950299633},
{0.06810098548543027,-0.7549428823666073,-0.6522449694247647},
{-9.89211481790113e-19,-0.7023557479827064,-0.711826104660157},
{-0.06767715218095517,-0.6903165790487853,-0.720335216245227},
{-0.06711641773913184,-0.6525648748586661,-0.7547545763826541},
{-0.06740778976699702,-0.641129027697873,-0.7644669775221872},
{0.2322630648589863,-0.8078541099270369,-0.5416877382554504},
{0.22398584672522648,-0.7251303728579382,-0.6511653267993398},
{0.3294343636731603,-0.7711708787778145,-0.5447646058219212},
{0.34944921653677824,-0.8416649517386746,-0.41168598965299574},
{0.24033677335504824,-0.8841900516363482,-0.4005573466566258},
{0.14477710011573583,-0.8298306139585309,-0.5389069895810278},
{0.06714941565467397,-0.8409463368614745,-0.5369359500876276},
{-1.188174275944621e-18,-0.7715710728925484,-0.6361431281366181},
{-0.06810098548543025,-0.7549428823666073,-0.6522449694247647},
{-0.1430272864217304,-0.7446023648866645,-0.6520049950299633},
{-0.14001213430180745,-0.6807312623892385,-0.7190281987893147},
{-0.13774516659905914,-0.6434286065919048,-0.7530112199016673},
{-0.14398902135277114,-0.6310239268247498,-0.7622833892356201},
{0.40387481181734625,0.7925576540402087,0.4568779940003502},
{0.23164412184347868,0.9062408974210722,0.35365016139797417},
{0.3827886872876938,0.8755671308712009,0.29471175786272535},
{0.5211194948104996,0.7796980510496937,0.3471389078132255},
{0.491233919829395,0.8426481364315757,0.22052971268615998},
{0.44053263899263084,0.8821278742233656,0.16667755547869806},
{0.3313879563252841,0.9210109885742495,0.20474565032751046},
{0.18359134829910276,0.9540299055517396,0.23689904208893772},
{1.7813847478484263e-18,0.9242231864238815,0.3818527224945337},
{0.22654974702272557,0.808332685876927,0.5433907259669899},
{0.4522064413687531,0.6691510389294495,0.589700111484004},
{0.5840248492726278,0.6790566757522678,0.44474375380477676},
{0.6665472986240467,0.6856265910144501,0.2926275386748314},
{0.5957001173866987,0.7708728934282212,0.22560219928687686},
{0.5695052397372864,0.8109047873640937,0.1345258627244961},
{0.5224251997865095,0.8429933003629793,0.12819596784282003},
{0.5128573373506462,0.8492185192929791,0.1257189644224208},
{0.42792191068314256,0.891582979804661,0.14819793682750826},
{0.3174455202742929,0.9325367184200118,0.1720569976961677},
{0.17476835392235882,0.9658639490038143,0.19121415868608263},
{1.8781819398509187e-18,0.9720340910734286,0.23483978749575923},
{-0.18359134829910276,0.9540299055517396,0.23689904208893772},
{-0.2316441218434787,0.9062408974210722,0.3536501613979742},
{-0.2265497470227255,0.808332685876927,0.5433907259669899},
{2.9946331636735604e-18,0.7909696462103144,0.611855390410128},
{0.24226434029242616,0.6534471238778077,0.7171574762341228},
{0.5069498910390763,0.5377250902681054,0.6736865259685892},
{0.6563156159090092,0.5550475314957553,0.5110499487275647},
{0.7478246264939256,0.5675069871980176,0.34452016993298085},
{0.7965698143752419,0.5700595168227816,0.20126767774774332},
{0.7132739297167607,0.6820903458854805,0.16122363733719428},
{0.6473242562136049,0.753264417724334,0.11646469124985091},
{0.6181337710923623,0.7821646931629485,0.07828814600209728},
{0.604344676949339,0.7936550969010094,0.06985054477989747},
{0.5881287457064379,0.8039724360236328,0.08793691254528886},
{0.5819652256210801,0.8062374666719263,0.10629027943438556},
{0.5843854941219976,0.7996366371824166,0.13811170383202448},
{0.5138789118156861,0.8442078137707096,0.1524520618411078},
{0.42718359870741074,0.8880141480602374,0.17013243617910395},
{0.315509204276444,0.9299107463073246,0.1889972114053528},
{0.1735372597129103,0.9634263747352669,0.2041921642859854},
{3.263182382718307e-18,0.980715773920359,0.1954394299617948},
{-0.17476835392235882,0.9658639490038143,0.19121415868608263},
{-0.3174455202742929,0.9325367184200118,0.1720569976961677},
{-0.33138795632528417,0.9210109885742495,0.20474565032751046},
{-0.38278868728769383,0.8755671308712009,0.2947117578627253},
{-0.40387481181734625,0.7925576540402087,0.4568779940003502},
{-0.4522064413687531,0.6691510389294495,0.589700111484004},
{-0.2548452506616734,0.6639147304468542,0.7030441870258723},
{-0.027549108786184842,0.6433803015207596,0.765050870347942},
{0.02279278374122261,0.5133257170007075,0.8578911336964822},
{0.31701646685113466,0.5120276416039558,0.7983284123584194},
{0.5625088662521278,0.4256831831974988,0.7087860064438283},
{0.7226181763257981,0.4312912046002672,0.5401952129351282},
{0.8203271853441757,0.4338011648502024,0.3726658803270162},
{0.862060738516227,0.44527148404673866,0.24204253469932172},
{0.8932561965983346,0.4285303168779023,0.13584967705225567},
{0.8167742837774735,0.5691666688796202,0.09449376908702417},
{0.7323873500687198,0.6776193971174537,0.06663874330670577},
{0.6669494688695526,0.7438665268104422,0.042906832388227456},
{0.6323744112206852,0.7742076984671694,0.02655265838782002},
{0.6222215416556538,0.7814471548066336,0.046697937259353145},
{0.6442432899275984,0.7631867262673487,0.049966030786839054},
{0.6415872897535366,0.7641342735894717,0.0668173746311681},
{0.6429832581059378,0.7602030644398244,0.09307970032060268},
{0.6467232297599661,0.75202422528609,0.12731311272486448},
{0.0,0.9763073158740352,0.21638859713681108},
{-0.17353725971291026,0.9634263747352669,0.20419216428598538},
{-0.315509204276444,0.9299107463073246,0.1889972114053528},
{-0.4271835987074108,0.8880141480602373,0.17013243617910395},
{-0.42792191068314267,0.891582979804661,0.14819793682750826},
{-0.44053263899263084,0.8821278742233658,0.16667755547869806},
{-0.491233919829395,0.8426481364315757,0.22052971268615998},
{-0.5211194948104996,0.7796980510496936,0.3471389078132255},
{-0.5840248492726278,0.6790566757522678,0.44474375380477676},
{-0.6563156159090092,0.5550475314957551,0.5110499487275647},
{-0.5069498910390763,0.5377250902681054,0.6736865259685892},
{-0.2858736986701254,0.524153105481818,0.8022092934031795},
{-0.32072250180142314,0.4220409678767104,0.8479495847465965},
{1.0450234200798385e-17,0.41019800149148244,0.9119964909868863},
{0.3207225018014232,0.42204096787671036,0.8479495847465965},
{0.612125600598868,0.34660585751322365,0.7107507500024168},
{0.7723537404860528,0.33523206790635635,0.53952679285132},
{0.8550675064650036,0.3340837410529628,0.39654459188315505},
{0.9130928594627687,0.3223338005990047,0.24972455023386417},
{0.9425879614571617,0.30539215075161913,0.13514277330043353},
{0.9033046891324318,0.42620482646299307,0.048888490373613716},
{0.8216787234117722,0.5697673148026862,0.014466598595981},
{0.7354959404339703,0.6775200559274924,-0.0035064827330844968},
{0.6684190357482241,0.7436150062711262,-0.015897015374187643},
{0.6330102514880814,0.7738226954908528,-0.02228132523586935},
{0.6296216721493453,0.7767553346283363,0.015089734466975634},
{0.6503194127652813,0.7589220320549829,0.033496427304346404},
{0.6986249861940674,0.7142140152702063,0.04267867215540235},
{0.6989511406656643,0.7126159359592124,0.06038071529174164},
{0.7018785519902874,0.7070398182531719,0.08637820130414363},
{0.7049954786991305,0.6991534143240209,0.11902049509579385},
{0.6304384117733136,0.7758527829600947,-0.024492205572754548},
{0.6277173494329477,0.7756857559210071,-0.06544109780658211},
{0.6261093446765709,0.7771917029866192,-0.06292968550241965},
{0.656728971462602,0.7537188245318145,-0.024799023933465246},
{0.6556190805578036,0.7550565417661503,0.0072965707480817646},
{0.7013644843781539,0.7123425713539154,0.025610956441691392},
{0.763664100028567,0.6446337017477306,0.035560271351282875},
{0.7622330165064808,0.6450060814915637,0.054479201410532495},
{0.7623577695924163,0.6422059917675985,0.07988801712316808},
{0.7623158007964042,0.6377584391007578,0.11017619167452698},
{0.6199815558399497,0.777871770669653,-0.102656606282957},
{0.6438176558537633,0.7524676286350802,-0.13889310230268592},
{0.6540039022817735,0.7492153865375755,-0.1046670930883427},
{0.6628849148761158,0.745916328929462,-0.06474889857039551},
{0.7205695168116736,0.6856675785726879,-0.1031481610890769},
{0.7089270834448235,0.6914421652368462,-0.13903281084333302},
{0.697017780504552,0.6970272399215885,-0.16828321505070037},
{0.6335643203826474,0.755147919735418,-0.1683682608372048},
{0.6114854899210487,0.7795289322519544,-0.13572081416696238},
{0.6198587204437183,0.7784490311465749,-0.09895591238948327},
{0.7739360055874772,0.6065528484606447,-0.181979947465589},
{0.7854963829576531,0.5975017293813278,-0.16120519764190727},
{0.7975947575528475,0.5883109740049214,-0.1331645620636175},
{0.8797425576160295,0.45361148349101393,-0.14244175779696272},
{0.8703039108023712,0.4663784454109044,-0.1583106076616676},
{0.8613826698631765,0.4799523677746369,-0.1663298551881331},
{0.7636163317314129,0.6149947186523965,-0.19665094442366782},
{0.6858813371112933,0.7018817224181166,-0.19216877773926347},
{0.6240502712906366,0.7569294524964489,-0.19395634262768743},
{0.6030550713447567,0.7803978842896632,-0.16523838271294033},
{0.6130633248398379,0.7789849014032784,-0.13166580088256882},
{0.650537152584085,0.7534088931833471,-0.0957938034532235},
{0.6544714923251436,0.7536915844379396,-0.060133695056329},
{0.7073532679906889,0.7063563429965194,-0.02668465797937587},
{0.7048549408896845,0.70934820651826,0.002152722166718212},
{0.7673922386808361,0.6409482288567439,0.017161583196723496},
{0.7884934294286154,0.6061374135405914,-0.10428589384103285},
{0.7047234332240429,0.6977318088469777,-0.12858929033182606},
{0.70722284712482,0.7004591013179635,-0.09587956969811005},
{0.7813098304902292,0.6204791225505972,-0.06753226827354682},
{0.7082331260833518,0.703360818115425,-0.060740420299855276},
{0.6457724142819615,0.7526172778302703,-0.12862823198582904},
{0.6406313787081364,0.7512431824325769,-0.1588241715328193},
{0.7011886562438104,0.6950315765730433,-0.1589514892078376},
{0.7817272158642239,0.6082392856090351,-0.13765003239730755},
{0.5999641396262653,0.7774649140368358,-0.18865666859194494},
{0.6062868325055459,0.7786866700557752,-0.16144146495817108},
{0.595266138224815,0.7803094308686545,-0.1917691757826375},
{0.5885255587461843,0.7791368658466453,-0.21583190445612557},
{0.5944456753680227,0.7752353565134769,-0.21364569044957993},
{0.635550444808385,0.7491599070909502,-0.1866415433694832},
{0.6971152291996092,0.6921041828240388,-0.1871420779393182},
{0.7787072576367183,0.6046707470742333,-0.16729702488863998},
{0.7704404246689459,0.5977367951010889,-0.22165801546123495},
{0.6895967358294243,0.6840884810518851,-0.23765372293639317},
{0.6930445398852246,0.6886092586857493,-0.2133226537138988},
{0.7747315980375284,0.6013916933608836,-0.19524083117715482},
{0.6309479342201805,0.7462158425929001,-0.21228900246281018},
{0.6272612521609716,0.7422054624384852,-0.23595417577132344},
{0.6249999607285208,0.7368508722353391,-0.25773211126161094},
{0.6875147797560841,0.6779286444196205,-0.26026175418666275},
{0.766559807915632,0.5928826606380361,-0.2467310511530979},
{0.5858504529489308,0.7615591694546888,-0.2771405387145971},
{0.5870298475038369,0.7674138461379096,-0.2578215407902192},
{0.5900330401228823,0.7719156652687759,-0.23665844011150847},
{0.5792596044020556,0.7733014317762045,-0.2578045894099757},
{0.5772452581641315,0.768538140938518,-0.27592940736679666},
{0.5773636189282781,0.7616920116732917,-0.2940689220083209},
{0.5867663813691603,0.7534075846314192,-0.2967864975277552},
{0.6248605452674203,0.7297111399971609,-0.2776165541392409},
{0.6930086361938221,0.6627263584885235,-0.28378302261643457},
{0.7639815870681028,0.5857362541343203,-0.27063845848954615},
{0.6092188497894152,0.7570300699788823,-0.23613103609866784},
{0.6158097815969165,0.7576018134067185,-0.21637422492619074},
{0.6761812072966786,0.7056834308607994,-0.21163617438268326},
{0.6684051300287639,0.7082094021131875,-0.22731921368356184},
{0.6629681021915503,0.7093225108660688,-0.23944701095480367},
{0.6045816961514623,0.7551377275314908,-0.25347186261436744},
{0.5831077800563653,0.7768196447466041,-0.23777417095533568},
{0.7449824707409565,0.6338074602668987,-0.20806062000946612},
{0.7486835173109346,0.6288289414910286,-0.2098741366872059},
{0.7550526022283669,0.6224965034251644,-0.20589723429812248},
{0.8460754123627873,0.5081831769645215,-0.1609542023228507},
{0.8400391588013388,0.5222261638302013,-0.1470171605341721},
{0.8360284528262247,0.5323006237154454,-0.13308821156337228},
{0.7447763982480761,0.6349863947646134,-0.20518380802700184},
{0.6603386282910276,0.7089115376033461,-0.24778484182771066},
{0.6022211603973346,0.751872867058805,-0.26835958293018014},
{0.705521670570422,0.6118905501176405,-0.3575319944176359},
{0.6559208117103655,0.6526940763471388,-0.37915475925612574},
{0.6413722406914172,0.6832381853656321,-0.34903757810406144},
{0.6967606067503735,0.6376511437523549,-0.3285204342992457},
{0.6324092066251974,0.7045486351314537,-0.32197797457294164},
{0.598566834527706,0.7236228376103928,-0.34363895805360123},
{0.6143475413692557,0.6969281777474389,-0.3699570427430529},
{0.6425639677477774,0.6550495480845495,-0.39751935412814915},
{0.6785497006127784,0.6081020365742658,-0.4120463771379858},
{0.7175951731674383,0.5770025222974398,-0.3900323790522867},
{0.7519777005434594,0.5820131608767798,-0.30949994903326083},
{0.6848053201642562,0.6623845116185288,-0.3037901121541213},
{0.6272581291955794,0.7194884855272735,-0.2981334576187853},
{0.5904022458309474,0.7413589790031898,-0.319080009353644},
{0.5897224200731754,0.7349515149877963,-0.33477415951680056},
{0.6087220431516651,0.7092948259949576,-0.3554691604036071},
{0.6440602018067529,0.666728888524974,-0.3750453914593503},
{0.6946067590394049,0.5941129469163962,-0.40564917922151583},
{0.6868489815229925,0.5820414355109692,-0.4352772035486791},
{0.7046481768480541,0.5489623070427413,-0.44956793959425617},
{0.7333216532755575,0.5300704213343603,-0.42575192455656224},
{0.5806716751157087,0.7511645953948063,-0.31396203009866275},
{0.7701277597927487,0.5660979275097014,-0.2940006293629711},
{0.7804452294848688,0.3157897495439675,-0.5396128963037012},
{0.7442179312287828,0.45804665120922883,-0.48614086040319837},
{0.767702316802213,0.39341182502657335,-0.5058263424395523},
{0.7912672685818961,0.3796681444820737,-0.4793205709506787},
{0.7525864576024484,0.46722849959998564,-0.4640163283710442},
{0.7501033222357455,0.48032151792700845,-0.4545725963882905},
{0.7962548247149357,0.31446478235755826,-0.516807657426823},
{0.796424328443389,0.18399308764461061,-0.5760684271529726},
{0.9028776958921143,0.23698269738950398,-0.358679616647701},
{0.8699582340182453,0.4032838232117604,-0.28378659059152467},
{0.8297789628117729,0.43614736760653194,-0.3481987171212888},
{0.8633242248131217,0.2772429853983474,-0.42167239641484006},
{0.7817202053808755,0.47072141055616246,-0.40906585550898583},
{0.737192838495298,0.5724588745137655,-0.35893948774365625},
{0.7916517887526773,0.5336917391155946,-0.29742322196570115},
{0.8433340721512382,0.4863157223310268,-0.22865839359722104},
{0.8987306851325,0.3765645334432024,-0.22468268236330607},
{0.9254276448976195,0.22611895750641064,-0.30406231452690674},
{0.925288428907953,0.014157943503215371,-0.3789998363651517},
{0.8996785167373644,0.0544619661364803,-0.4331425409328953},
{0.8632179538642457,0.11714717876205959,-0.491051222006946},
{0.8206593841804364,0.3137343676241528,-0.47758655940893063},
{0.6823406537663099,0.6488470516699962,-0.33676213527788135},
{0.7430985345174026,0.6078013716010555,-0.27996796366363835},
{0.8086977455610849,0.5497199724889793,-0.20932249800519462},
{0.884186839378661,0.43769299934790384,-0.16321296330686993},
{0.9177087980336369,0.35552743337901915,-0.17723094009394794},
{0.9361756895753947,0.2359889100889692,-0.2605461812482667},
{0.9395895220465381,0.02725440918137108,-0.34121654010398184},
{0.8974882284877825,-0.16351783643569162,-0.40960566023097394},
{0.884529294654224,-0.12075143585515345,-0.45058519464960195},
{0.8636768446930266,-0.04347520410791328,-0.5021675164413492},
{0.8365397386372649,0.019681695019357688,-0.5475526427311458},
{0.8284879501186269,0.15746576949116212,-0.5374125491154742},
{0.8650446121748566,0.48282439512210634,-0.13630268677551452},
{0.7792215715581836,0.5914169392429316,-0.2074602284654027},
{0.8489712735133516,0.5128039453164,-0.12759267383769635},
{0.9005804125466227,0.4269660851941414,-0.08157746399186462},
{0.9124471307781928,0.39303442116473974,-0.11386034127096817},
{0.9281627434051488,0.33757221652820346,-0.15671285966015586},
{0.9393626812496974,0.2552637935177469,-0.2289937745754424},
{0.9461371987392092,0.07475833145546208,-0.31501681390033354},
{0.9101329439922718,-0.14254675027795108,-0.3890224264038716},
{0.8434931243250523,-0.27325438046125,-0.462440691089247},
{0.8430642870851833,-0.21858706059403396,-0.49138814066113956},
{0.8414762940429241,-0.1398650125449627,-0.5218768291748387},
{0.82558841382848,-0.07400171112340476,-0.559399247141952},
{0.8013897877409863,-0.01890298171635537,-0.5978436964514118},
{0.8063788273192676,0.06460276537942634,-0.5878602466203455},
{0.6185991094230023,0.7205168530436366,-0.31335380371261345},
{0.7040551951796765,0.6538599432061593,-0.2770802353307534},
{0.6800371718166908,0.6811015471565092,-0.27138556963951904},
{0.6070978429606988,0.7365296510834436,-0.29825539751589997},
{0.6669239080473357,0.6969478021763864,-0.2635835008424723},
{0.7600189783883996,0.6163415130917024,-0.2061414362259176},
{0.6416133643431196,0.6940158623594095,-0.3266102776855448},
{0.6026002170794527,0.746253308182235,-0.28280554874836994},
{0.6612069996073752,0.7054731841753122,-0.2551722752960406},
{0.7492119739020194,0.6297893970708021,-0.20505300168257823},
{0.839339691632875,0.5291929427749973,-0.12435317192081924},
{0.8353821581963639,0.5350396334642252,-0.12597317329357452},
{0.8931252773321184,0.44644801110535887,-0.054876337072510946},
{0.8945042378744908,0.4424904131186946,-0.06375266835688603},
{0.9189763240411462,0.3907798151174079,-0.05266547207257135},
{0.9228418488264402,0.3748761195830774,-0.08849190370272196},
{0.9294303201231255,0.34185324697733965,-0.13890873826680109},
{0.9379515744861127,0.27511823194521695,-0.21108482269068984},
{0.9450006846854719,0.13667852493455224,-0.2971408534108095},
{0.9225129475734646,-0.07498082037186388,-0.37861291332399183},
{0.8533532050499704,-0.26160266184500497,-0.4509460663389263},
{0.7651560246606155,-0.3443789616486541,-0.5440031146044647},
{0.7716825073061475,-0.26236688596393865,-0.579370110609171},
{0.8056967556434849,-0.18283107881757402,-0.5634053022149903},
{0.8037275388580701,-0.1268157880364827,-0.5813258975702317},
{0.7880989741033658,-0.07174221679760845,-0.6113534667818504},
{0.7770505759714792,0.10976017954221809,-0.6197944057260056},
{0.8960047264662349,0.4406384628940821,-0.05489330713764898},
{0.9221339169221662,0.3866247028925489,-0.013797767030648935},
{0.918638959492499,0.3941025208488004,-0.02802971928435249},
{0.9295429641630565,0.3662158126505465,-0.04284689416583792},
{0.9288423049431646,0.3610146398847811,-0.08318895561750354},
{0.9304621389962695,0.3407720761269803,-0.134590490104592},
{0.9349215812034531,0.29092837222885515,-0.20318050898721518},
{0.9388526269836706,0.19120468642476754,-0.28635033210224725},
{0.927956088860736,0.01801809951093957,-0.37225373770628495},
{0.8704283201911942,-0.19715239490504763,-0.45109364060285756},
{0.774242868491909,-0.34827158190192425,-0.528445726474301},
{0.6582085077741967,-0.41868973005039856,-0.6256680191954751},
{0.6727852738765053,-0.33169297087838084,-0.6613166777911995},
{0.6973869880977583,-0.21587625266820112,-0.6834097104708654},
{0.7543845442709577,-0.18312410935686313,-0.630372524732285},
{0.7742475025774969,-0.13580625910874694,-0.6181403277083585},
{0.7701396052767455,-0.0843733183446958,-0.6322706157458872},
{0.7930923638731362,-0.2948327451466612,-0.5329898261274832},
{0.8861020282479405,-0.09095102270365496,-0.45447894011059015},
{0.8174593640126512,-0.18707204208531275,-0.5447607174329503},
{0.6835613436737531,-0.37897614141958336,-0.6237956185079029},
{0.6645396332925589,-0.42465639002349026,-0.6148609811946182},
{0.5099644960428059,-0.47719703413009484,-0.7156949094364499},
{0.5226335952172088,-0.39048291563645465,-0.7578767826938547},
{0.6134887349112995,-0.2552964789591331,-0.7472986551359518},
{0.6545258501869595,-0.11296977893549365,-0.7475518313028894},
{0.7096430499792092,-0.10245598433488834,-0.6970721002092785},
{0.7446703515733784,-0.08329230916302459,-0.6622148131247685},
{0.755392082619831,-0.04615305041099781,-0.6536456971884955},
{0.7494562479470342,-0.006937520139306618,-0.6620175248643122},
{0.6773967939019004,0.04638080496934424,-0.7341542103276545},
{0.7232393312608775,0.0392961201380981,-0.6894785599708023},
{0.7498436005795901,0.046137944868576565,-0.6600044429495457},
{0.6161334081465256,0.05787193365383652,-0.7855128660059697},
{0.5791799413658378,-0.1248994071043137,-0.8055747846255215},
{0.5357152453398814,0.07214244462012767,-0.841311264393068},
{0.31639874119149425,-0.2948969492467279,-0.9016249918327524},
{0.3042662759148404,-0.44146745128219644,-0.8441140460857857},
{0.2949172651569591,-0.5229027148890174,-0.7997478086709803},
{-0.0202519370824902,-0.4658675132794674,-0.8846226987338796},
{0.01041025217850788,-0.31813503591665776,-0.9479882518111112},
{0.03056821891832149,-0.11976791813129611,-0.9923312097171271},
{0.29115165332640053,-0.11291334539847356,-0.9499901532101418},
{0.4579333027900151,-0.13539672992490062,-0.8786152831139872},
{0.5043878707120765,-0.2642799294339011,-0.8220395335851859},
{0.8889161191124046,0.2548907361322775,0.38060326564033437},
{0.9426230207036334,0.23109957716117766,0.2409456915478726},
{0.9657669991419027,0.21572046673203593,0.14407908800848546},
{0.9532121040619579,0.2974191632122428,0.0541158574163262},
{0.9091003829217483,0.41580788719399225,-0.02530404550262837},
{0.8180393602248153,0.5731659231869015,-0.04787932351529291},
{0.7302733387861596,0.6805924411016465,-0.05911666240085587},
{0.7895765633998503,0.2710440071925414,0.5505488140888977},
{0.6204201381500405,0.29689581231696366,0.7259006328737665},
{0.6893608940866836,0.2602099292724307,0.676071261341617},
{0.8349523642476995,0.22441233834560936,0.5024874643565078},
{0.9134295897551035,0.1954776113484031,0.35698023477686563},
{0.9550674376282534,0.17204732161524103,0.2413418917370629},
{0.9782774830801192,0.14827139579982712,0.14487497812251252},
{0.9784481461216504,0.19706931285381188,0.061667749127334644},
{0.9621878445725791,0.27212426950948204,-0.011955488308931445},
{0.9543132693035545,0.292048719780678,-0.06319595956727278},
{0.8977167270538218,0.43304583572221855,-0.0810924295567681},
{0.809093185980309,0.5797630213789258,-0.0961408104907203},
{0.4406823036850106,0.2881724154919874,0.8501504373746951},
{0.4211272311920407,0.29988669179076377,0.8559905532395302},
{0.3331508454663268,0.3243168311221415,0.885341237724734},
{0.0,0.3223552815171349,0.9466187577256266},
{0.0,0.3152749718530716,0.9490003646590686},
{0.0,0.3179733755221867,0.94809964268479},
{0.4484297579787629,0.2877765675414997,0.8462242015761193},
{0.7100143878579893,0.23787416492113292,0.6627936712867125},
{0.8497113333422438,0.19355154330138497,0.4904369990889739},
{0.9226403693730721,0.15902536577635062,0.35134837674709496},
{0.9634208782186658,0.1281346077130603,0.2353757288222278},
{0.9833706881159859,0.10521395569433796,0.14802740719691826},
{0.992084837887772,0.09303078213281724,0.0843382950322669},
{0.989016328325919,0.13043293445565432,0.0695266273740138},
{0.9921324276675045,0.12454386050998217,0.012730780802998744},
{0.9827997885433105,0.18460679532911992,-0.004990667043270891},
{0.9806796713118214,0.18959622306743573,-0.04817317172764527},
{0.9780774498285814,0.19243440557151523,-0.07958330031580994},
{0.949481453434902,0.29840458731270775,-0.09715797370200033},
{0.8892032119958049,0.4421902887691063,-0.11741122729380721},
{0.9987982413450612,0.03945264009527373,0.02907855353220719},
{0.993815294105827,0.06627201910744347,0.08910208013717234},
{0.9983027037619303,0.050919359794977526,0.0282653579437631},
{0.9994726269551886,0.028428268684312773,-0.015693995887183773},
{0.9990373098516626,0.04031477110302416,-0.017296611091886883},
{0.9966507193651346,0.0787290694573098,0.02211509012746087},
{0.9835746253221618,0.08444705870821384,0.15952946655054198},
{0.994528048582201,0.0547875742215156,0.08895101064181879},
{0.9987118164540802,0.04630053296040584,0.02075977655404311},
{0.9990686721351997,0.03602967021942584,-0.023741339934557286},
{0.9982417512350763,0.030933288498539123,-0.05056221666218807},
{0.9988339792681206,0.023265730457821206,-0.042301154188456244},
{0.9983697989135237,0.0360049204095834,-0.044287586564066735},
{0.9972769174843489,0.0695495932653782,-0.024527615651256784},
{0.9671949126655864,0.10279270786200016,0.23230940601750505},
{0.986088271624029,0.10549071057272154,0.1284586725308871},
{0.9686702347035161,0.13318273135752373,0.20961950402475588},
{0.92996295975601,0.16272935081113293,0.3296787100593988},
{0.9292885926488522,0.2168534952614206,0.2989937677705353},
{0.9677970488337364,0.1870646839518433,0.16845081266265075},
{0.9833465860591929,0.15981348024286263,0.0865398360201498},
{0.9884400668185551,0.15124900944005756,0.010486727379492149},
{0.9942457097780241,0.09120392620322443,0.05618996737060856},
{0.9855619245733551,0.07761412250767526,0.1504783732588439},
{0.9658064314938464,0.09580935163848911,0.24091182001664938},
{0.9292923448133619,0.1355411194255244,0.34357581814813365},
{0.8511571639655262,0.22133964130427022,0.47596244118360775},
{0.8434432938034073,0.2894980346190476,0.4525420401352429},
{0.8229989378078093,0.4064027605562949,0.3968747215173076},
{0.9205504921156797,0.3063602139798937,0.24234316733874203},
{0.9558617043058307,0.267503838743491,0.12153229405820071},
{0.9683590603837213,0.24864101715255468,0.02140968851010087},
{0.9682963135360293,0.24259263501587947,-0.05959079315286777},
{0.9614973873753812,0.24433896491690868,-0.12578252777572044},
{0.9878413728454584,0.14623880483043053,-0.052760155956624234},
{0.996742883064954,0.08051620538469373,-0.004556943033804429},
{0.9949395152645919,0.060318636259991266,0.08035560394144055},
{0.9846262232242433,0.07311045080502063,0.15863814964329734},
{0.9644772834564026,0.10414680144260878,0.2427694656373241},
{0.9286544854654536,0.1291441374211959,0.3477393253496488},
{0.8552135554985468,0.18652604909171086,0.4835471099094384},
{0.6966743969028418,0.300523462733829,0.651406503687621},
{0.6744254186046846,0.3892274258034762,0.6274172182386257},
{0.6279263445753324,0.542862841414673,0.5576813079164914},
{0.5277553410641096,0.7647455843978574,0.3696464407001438},
{0.7620549634508021,0.5916369097166247,0.2631311455167539},
{0.8840744009812606,0.44402169732183117,0.145798442505623},
{0.9228089376185362,0.38413723124909754,0.0293641315149234},
{0.9075300950003459,0.4075251336476579,-0.10154994886321521},
{0.9084554458879442,0.3841170647857199,-0.16481135694162408},
{0.8910122346613414,0.38972098559871765,-0.23284061301192005},
{0.8753068766529649,0.39257274680732906,-0.2823552906325291},
{0.9535039619132027,0.24536575793014886,-0.17500239841553433},
{0.984690770728402,0.1427231072241118,-0.10007097834337476},
{0.9961005719699619,0.07270952338488541,-0.04996974815083235},
{0.9270037405386107,0.13735908089375484,0.34899362160854336},
{0.8575384079382595,0.17404422778167075,0.4840831392298196},
{0.7097478224034046,0.2544638633621814,0.6568912930130968},
{0.4162114107504031,0.38378786564340733,0.8243026966752185},
{0.3872109207561576,0.487177054408544,0.7827683057616625},
{0.33466495430384646,0.6587213533289468,0.6738586996019904},
{0.2415685685643015,0.8729865970155956,0.4237204598705667},
{0.13144642645880078,0.9897624286951906,0.055607299112695525},
{0.37867765949852417,0.9242853111412533,0.047957208063400356},
{0.6341227008581503,0.7726049378770571,0.03114498714646656},
{0.793342002438838,0.6085592176465339,0.01625256237562515},
{0.7936985466412387,0.5984393095423118,-0.10914673542578597},
{0.7533111881107113,0.6119081050154546,-0.24102017526261962},
{0.752501583498141,0.5828546173308292,-0.3066298450720723},
{0.7254467507314634,0.580003567573189,-0.3705710100042032},
{0.7046732203543432,0.5759013411464956,-0.41445542315321054},
{0.6912743602921454,0.5711197212177581,-0.44267597951417614},
{0.8636151796869098,0.39399948050935113,-0.31453653328780123},
{0.9467009554644096,0.24684517205278214,-0.20694144572077983},
{0.9813046798916065,0.14172788100705974,-0.13020880526324036},
{0.9945580554037783,0.06900531519998933,-0.07805473019366276},
{0.856456157340831,0.17696280233668513,0.4849402201737084},
{0.7188061770047913,0.22879990390754107,0.6564817467924428},
{0.7178207939638065,0.2334000367215772,0.6559403407410896},
{0.4338831387975831,0.32852485844923196,0.8389379233579022},
{0.0,0.41168302494049597,0.9113271020746848},
{-8.80961210834815e-18,0.5082050217074177,0.8612361208817029},
{0.0,0.6684297005005372,0.743775325947804},
{-3.6183576450590126e-18,0.8705475709869254,0.49208426783302484},
{0.0,0.992917636340532,0.11880474503962848},
{3.993695218253109e-19,0.9802682476994616,-0.19767185574134477},
{0.0622417814981481,0.9691686052867172,-0.23840758201562354},
{0.26193148165691993,0.9371779284277559,-0.23041143501326192},
{0.5384947306321614,0.8205412787124514,-0.1916649029173861},
{0.4991636374961627,0.7962826886800396,-0.34171558745554304},
{0.47320470462001263,0.7662743973582119,-0.4346272603953825},
{0.45246557805436294,0.7458319380937583,-0.4888861020679965},
{0.4396120897155311,0.7301722463216319,-0.5230580285948835},
{0.4337092126547899,0.7171467632152648,-0.5455243705539021},
{0.4320011749650854,0.7061645085063724,-0.5609872295825807},
{0.6835214658986134,0.5659600020905152,-0.4609638615873425},
{0.8556664272843039,0.39439768473406517,-0.33509018412201247},
{0.9416148243991468,0.248663244902869,-0.22699804648088873},
{0.9785515047939467,0.1428023839062004,-0.1484736731417686},
{0.9931743275821725,0.0688640154926865,-0.09414086467588223},
{0.9715317225684945,0.21277713690793673,-0.1041729429955544},
{0.9437757926522747,0.30871194102963034,-0.11825477017561971},
{0.9378248029298264,0.3222871192282292,-0.12890171367829684},
{0.9678778072307876,0.22996469456771618,-0.10163065247502442},
{0.9317606199666901,0.338785948461691,-0.13056120482058187},
{0.9748876901241808,0.2002877921914516,-0.09735908762623664},
{0.9874306588282192,0.13354430547200305,-0.08453763943989161},
{0.9854325713924293,0.1501519296288713,-0.07985640404896259},
{0.9825748882307624,0.17336638840630175,-0.06701256889017039},
{0.9634410299292359,0.2521316461998458,-0.0906146502142383},
{0.9254210666570098,0.35808518921515514,-0.12397921863017475},
{0.9963836306150632,0.06687742118045782,-0.05241250975288982},
{0.9924137204645752,0.11779531343243754,-0.03520328915050144},
{0.990970668653611,0.11752095653839771,-0.06454423787229177},
{0.9953280088245025,0.0699278283236769,-0.06657517311570003},
{0.9891990783342026,0.12280774384716243,-0.08002150632132482},
{0.9976235945126696,0.037291905662027815,-0.05793511408217778},
{0.9971197706292719,0.04442906521745625,-0.06146723667232122},
{0.9944226843472038,0.07879844637810582,-0.0701022803059799},
{0.9489225711410685,0.31242866930328156,-0.04398045675529708},
{0.9184647660495979,0.38009225920031603,-0.1093267946180499},
{0.9104359425934683,0.4045780907544757,-0.08615661852351268},
{0.9385323379110784,0.3446130467463724,-0.019972448706853604},
{0.9022273370138807,0.4263641935091123,-0.06480283047958141},
{0.8532445216730309,0.49398873933019627,-0.16717927996592316},
{0.9574574578906112,0.27958700418015947,-0.07145854338854073},
{0.9699706062212857,0.2425229233237682,-0.018429724067522968},
{0.959218287842705,0.2826218233581123,0.005018090258805956},
{0.9484902959092913,0.3165740955057812,0.012124381246127153},
{0.9290754000736942,0.3697389886790585,-0.010582118336713565},
{0.9917299751030118,0.117231786074572,-0.05223375169318688},
{0.9882712787375352,0.1491567940291082,-0.032743402655122135},
{0.9778692823163675,0.20397850581158838,-0.046523498029967816},
{0.9934345792049498,0.09419775555973366,-0.06491933215454965},
{0.9966697175512517,0.05834236794647335,-0.05697053816409607},
{0.9957055438169414,0.08043336389444812,-0.0458360555112698},
{0.993248381911516,0.11233354154413089,-0.028962514985897515},
{0.9878090611714626,0.15552446123245187,-0.006737998657554029},
{0.981570427147644,0.19098444475736406,-0.006666214061432305},
{0.9905136164619923,0.13618793018649156,-0.01832002387838212},
{0.9950297455184205,0.0930516654466897,-0.03545691880500471},
{0.9968847362469077,0.06207072500176942,-0.048662590721088},
{0.9940008100855744,0.09445859188844158,-0.05513586824993919},
{0.9896653080788259,0.1365225480923104,-0.04386538324949926},
{0.9815341106097312,0.18719367170936888,-0.03936138947660587},
{0.9824146600941897,0.18656099537238463,-0.0075120328595483215},
{0.9965116909671978,0.045921310051839075,-0.06968273135303311},
{0.9898637804664785,0.09973571426681944,-0.10110629762927038},
{0.9912207482443434,0.08248809757169014,-0.10333025698665185},
{0.9968881612170105,0.035012129925424025,-0.07062679932895785},
{0.9921405179470641,0.0728853252775131,-0.10170998971056118},
{0.9743853404604346,0.1551257885691821,-0.16281645499332154},
{0.9716244839187008,0.17035135793166054,-0.16409228226993938},
{0.9668725420074227,0.19518513746250163,-0.16449999886276387},
{0.987149733235802,0.12711644452821763,-0.09683394912420648},
{0.9958281388287664,0.06499620155464282,-0.06404538781444968},
{0.9974977507321855,0.041368225217697716,-0.05733155524288982},
{0.9977569923687687,0.029001433989407098,-0.060331592103863775},
{0.998154252485957,0.023331286187967846,-0.056069058570798046},
{0.997417707543473,0.03043196212327354,-0.0650523816631682},
{0.9764094426359954,0.1467215940578017,-0.1584215079097613},
{0.9343524161089553,0.2583012239466976,-0.24549142595821083},
{0.9297462164934026,0.2706232255010559,-0.24966986749627548},
{0.9220892450728952,0.2918631727865732,-0.2541009887659885},
{0.9089586763382053,0.3248909596591995,-0.26122784890057593},
{0.9583583458655361,0.23239954875924046,-0.1659509886875478},
{0.9816424380660669,0.167150920914199,-0.0918623613088805},
{0.9606795848477339,0.277093516318233,0.017717744528659644},
{0.9505289477082147,0.3105539636699599,0.007138292344191498},
{0.9394342387820999,0.3426883432794,0.005292483756858853},
{0.9715336228004413,0.23648728474355446,0.014006567133693545},
{0.9788616673651492,0.2042992079007046,0.009574435454087284},
{0.9682934041129895,0.24965127843828538,0.009062158981640289},
{0.9573811768101249,0.2887768075626717,-0.005407189988534951},
{0.9470292392960237,0.319630914611619,-0.031172076333387942},
{0.942020964280446,0.3352041948271719,-0.015318310168106815},
{0.9329925883891582,0.3596457274139422,-0.01340823492467662},
{0.9355946070973319,0.3497801001527838,-0.0481312030547503},
{0.9311247690978478,0.35315407478272065,-0.09104319764178032},
{0.9276082268714408,0.34277989641688933,-0.14847531799207667},
{0.9302145651798547,0.30477663078138817,-0.2044799942703423},
{0.9317175989429884,0.2302301529938122,-0.28088501646111036},
{0.9245898052099192,0.10318427476654331,-0.3667242800017283},
{0.9222163493090277,0.3500272627848041,-0.1643104390308392},
{0.8985055382149407,0.3549625137897285,-0.2582429313672623},
{0.9117549262189218,0.36228185787668016,-0.1935324519788585},
{0.9297520550210987,0.35120604241824555,-0.11052344526369648},
{0.9233503152315814,0.3569532794783145,-0.14145158758888282},
{0.8925492755709558,0.38520260994860706,-0.23446692723397755},
{0.8757468635372923,0.3855168100244665,-0.2905928770516487},
{0.855761571545514,0.37651874759751786,-0.35483202416572923},
{0.8804052973042725,0.33991117995888226,-0.33067643130035074},
{0.8994914990742486,0.31300897371608916,-0.30486132169621255},
{0.9152841854356332,0.3335475457543356,-0.22583377650982367},
{0.9377894717810165,0.3407940230173006,-0.06641039446024807},
{0.9351368249440296,0.3406934539455402,-0.09719613712621167},
{0.9084278591390834,0.3745832630130823,-0.1855968852390938},
{0.8557529705711772,0.42709208396661885,-0.2920260350921754},
{0.8354437070691587,0.4320902457461613,-0.33960540609590373},
{0.8134770296636715,0.4298334475967879,-0.39178862864640335},
{0.7857198267353258,0.4248325052020231,-0.4496239499835198},
{0.8206618944784461,0.3715151002830209,-0.4341550244011289},
{0.856837908996481,0.32700279677230176,-0.39862008053989284},
{0.8782532861862826,0.2897794462841752,-0.380393267309284},
{0.8944561496255602,0.2533127671900495,-0.3684845157880274},
{0.9129293059911952,0.2872150234287048,-0.2899441542423014},
{0.9227170546142418,0.3163308429345947,-0.22029079629504936},
{0.9232981465301738,0.26077637675145454,-0.2819861945952838},
{0.9172371097201651,0.16525358843555274,-0.36244632162759033},
{0.8907270087275755,0.01642057474859505,-0.45424196266764194},
{0.831862250031932,-0.06543530481006228,-0.5511110757880173},
{0.7135209879183243,-0.27320762968947393,-0.6451708230224905},
{0.5261537354734037,-0.45350820728395036,-0.7193695521590283},
{0.5109960736200543,-0.4920378561215721,-0.704827468880275},
{0.29165939145484476,-0.544769633096989,-0.7862320562223101},
{0.0,-0.5519562460406274,-0.8338730733491388},
{-0.2949172651569591,-0.5229027148890173,-0.7997478086709804},
{-0.33957627110910016,-0.4339152746286483,-0.834509131492031},
{-0.2846396952442348,-0.30996096856208055,-0.9071408059718877},
{-0.26693195443016937,-0.13711588788092846,-0.9539111934528888},
{-0.2394299106095615,0.11349239372046727,-0.9642576390535342},
{5.948156261598884e-18,0.17935554570952505,-0.9837843199722379},
{0.23942991060956148,0.11349239372046722,-0.9642576390535342},
{0.416957440176319,0.09158058916591828,-0.9043005522334013},
{0.9244474972079502,0.3537461558275275,-0.1423393204395876},
{0.876208701794688,0.41278568660254744,-0.24872934655028334},
{0.8973577328779074,0.3890536257746901,-0.20829396418473023},
{0.940567953349157,0.3231603830231307,-0.10439967421846515},
{0.9186991890993312,0.35618005834707583,-0.1706679992971872},
{0.8425322956874561,0.44936506112112723,-0.29700231071025485},
{0.8152233594295512,0.47406802956845673,-0.3326715761550387},
{0.7898068214040647,0.49062327883547674,-0.36809507349098547},
{0.9474464242795426,0.31419100135447925,-0.0602435705098776},
{0.9599358527402847,0.2784487238115817,-0.031455791700161925},
{0.9561014639916888,0.28382618888199135,-0.07288816815967897},
{0.9391055409590219,0.31505272731669665,-0.13719534230568511},
{0.870804459457608,0.41644233151515603,-0.2612955757584962},
{0.7532779673371793,0.5235964241952835,-0.3980189549434551},
{0.7200200998965339,0.5469156194827073,-0.4271467674123637},
{0.6901247909460212,0.5640922533391698,-0.4533516324493036},
{0.6640152301669308,0.5758734306779902,-0.47692092210923215},
{0.7662996057892463,0.49939069557031307,-0.4042200481730773},
{0.743360635957555,0.5011230768652949,-0.4430469802874624},
{0.7164674617344194,0.49835406689107276,-0.48817783674493703},
{0.6759351423276251,0.4953745748152182,-0.5456333145924788},
{0.7445762472877376,0.42088704333785176,-0.5181315554231677},
{0.7780175355099069,0.3651323043512734,-0.5112407600712405},
{0.8203356604828559,0.31294871884156134,-0.4786569789688458},
{0.8448709598775854,0.2666239295734644,-0.4637938565077504},
{0.8634485253490924,0.21865052821673198,-0.45458617509007215},
{0.877375244449945,0.16443369084340528,-0.45074853493052497},
{0.9071933388644476,0.2132964244616283,-0.3626360175601157},
{0.9718889657918041,0.23508534179368984,-0.012912019434670869},
{0.970077720815551,0.23755904919046295,-0.05014891549205454},
{0.957183631127411,0.26756083380858714,-0.1105020204041441},
{0.8984538306024936,0.37581142793189304,-0.22703850975439666},
{0.7888707503881419,0.49343188412094635,-0.3663439844120588},
{0.6204294502968005,0.6023148650651979,-0.5022789071082941},
{0.5844698769209433,0.6209369697561805,-0.5223334591638081},
{0.5531467141200074,0.6361612805199621,-0.5378917528884793},
{0.5268107838733168,0.6492488213999348,-0.54858578718882},
{0.5050034040024893,0.6586696055284963,-0.5577866193257361},
{0.6409933159928195,0.5817530211160123,-0.5006905144646958},
{0.6170842503234789,0.5815315295481133,-0.530120842963321},
{0.5804445175600107,0.579106063329619,-0.5724686274804915},
{0.5098710605504431,0.5855501543176239,-0.6302083134898914},
{0.6059154274336761,0.5010378469661725,-0.6179219778462067},
{0.6780427869256862,0.424464316475309,-0.6000733481310406},
{0.7111245739237736,0.37044611469102406,-0.5975546137986519},
{0.7546640654198975,0.3090140569001591,-0.5787853324005525},
{0.7911929944411872,0.24690866166377654,-0.5595084971138423},
{0.8122765453235382,0.1860937330711986,-0.5527892332787276},
{0.8266263290467153,0.11685541400669222,-0.5504849901169659},
{0.8337799622953925,0.03458100315863317,-0.5510128208084061},
{0.8868290264642426,0.09903425245420214,-0.45136071457463056},
{0.9716556782988565,0.2168485294540678,-0.0941379737576576},
{0.9439149139511295,0.2798487332283036,-0.17524075362525093},
{0.9234749606447022,0.329193340038398,-0.1970424876432217},
{0.8249275941899769,0.4563619409677332,-0.3335089851564722},
{0.6602839619791578,0.5790888467753068,-0.4782062286227054},
{0.45111861719940255,0.6684880537886211,-0.5912831091431586},
{0.41970808526216496,0.6802053417777735,-0.6009707282243866},
{0.39305696892328884,0.6916116028449476,-0.6059534718038004},
{0.3711831322778119,0.7042162787496111,-0.6052293078300839},
{0.3537125978105837,0.715306062890318,-0.6026812047363355},
{0.35168771981839897,0.7162442254519977,-0.6027519865048999},
{0.48484090198844015,0.661685338005337,-0.5719281539037913},
{0.4609546212804625,0.6581171605978919,-0.5953172599939919},
{0.4023782133120175,0.6614221595374823,-0.6329395708316884},
{0.2971288812072832,0.6835405887036644,-0.6666983512407662},
{0.3991278553577029,0.608667547461785,-0.6857264554794545},
{0.4966785516836924,0.5235663086989009,-0.6922345965731538},
{0.574818628810867,0.44292320520057094,-0.6880425700978446},
{0.6324106159169053,0.37257151588645554,-0.6791518817066393},
{0.6511719516139985,0.3112470027385315,-0.6921707829123509},
{0.7036629332414355,0.2349478689210082,-0.670565414610339},
{0.7274679662130062,0.15895705046888733,-0.6674751038354496},
{0.7417074496395474,0.07298365481249462,-0.6667409131584838},
{0.7455231783211651,-0.026567903982554014,-0.665949950870095},
{0.7369311201105513,-0.14208446033579672,-0.6608664996379328},
{0.0,-0.2748549077871907,-0.9614857147484277},
{0.35640556519676103,-0.13050373963531114,-0.9251723336967964},
{0.34391710853758967,-0.2735945054613756,-0.8982577965353203},
{0.0,-0.4208778128216307,-0.9071173389779739},
{0.3214607729121147,-0.41611105636769186,-0.8505965907804413},
{0.5847639958616557,-0.21372961568477541,-0.782541194138141},
{0.5986685736241184,-0.0834765534403808,-0.7966351762134151},
{0.5984395445354718,0.03454425580012928,-0.8004228919311294},
{0.3577141211105411,0.005310272706015855,-0.9338160464255799},
{6.3387613164436515e-18,-0.12560514729919417,-0.992080312763008},
{-0.35640556519676103,-0.13050373963531114,-0.9251723336967964},
{-0.34391710853758967,-0.2735945054613756,-0.8982577965353203},
{-0.3214607729121147,-0.41611105636769186,-0.8505965907804413},
{0.0,-0.529882842298792,-0.8480708540194939},
{0.3000840889229402,-0.5132893498946368,-0.8040420280433294},
{0.5563672003307801,-0.3516999510223862,-0.7528364250266726},
{0.5853669498553649,0.13956097760992925,-0.7986665559202962},
{0.3480999703730684,0.12931481915729676,-0.9284956048213608},
{0.0,0.017803127778125503,-0.999841511761397},
{-0.35771412111054113,0.005310272706015852,-0.9338160464255799},
{-0.5984395445354718,0.03454425580012928,-0.8004228919311294},
{-0.5986685736241184,-0.0834765534403808,-0.7966351762134151},
{-0.5847639958616557,-0.21372961568477541,-0.782541194138141},
{-0.5563672003307801,-0.3516999510223862,-0.7528364250266726},
{-0.30008408892294025,-0.5132893498946368,-0.8040420280433292},
{0.0,-0.5680512158086637,-0.8229932054508707},
{-4.427206007677095e-18,0.2655549490234733,-0.9640957260817727},
{0.2808281359923895,0.3351143832729022,-0.8993519378745243},
{0.32853507758345846,0.24016451566646485,-0.9134471567703976},
{0.0,0.1490754876142912,-0.9888258183282642},
{0.5604657726743879,0.23323499130244982,-0.794656879723977},
{0.4969893532354848,0.32634612346287784,-0.8040521068135614},
{0.28344423588868134,0.4136916081365502,-0.86516970502837},
{-5.0941720344434644e-18,0.3675337827979995,-0.9300101711821183},
{-0.2808281359923895,0.3351143832729022,-0.8993519378745243},
{-0.3285350775834584,0.24016451566646477,-0.9134471567703976},
{-0.3480999703730684,0.12931481915729676,-0.9284956048213608},
{0.4303086859608239,0.47474968098738946,-0.7677546321508202},
{0.488691875085171,0.39747152534337915,-0.7766573490072356},
{0.22676737547391296,0.5048362630410476,-0.8328966952386254},
{0.3555831119826213,0.5582006691282666,-0.7496483598711532},
{0.19289752687772369,0.5900356775437721,-0.7839951806930445},
{-1.9385416479138012e-18,0.5912396774614528,-0.8064959043884088},
{-5.156765465578936e-18,0.5301106378338434,-0.8479284826301071},
{0.0,0.4571614408659532,-0.8893837287613066},
{-0.2834442358886814,0.4136916081365502,-0.8651697050283699},
{-0.4969893532354848,0.32634612346287784,-0.8040521068135614},
{-0.5604657726743879,0.23323499130244982,-0.794656879723977},
{-0.5853669498553649,0.13956097760992922,-0.7986665559202962},
{0.38490851141246735,0.8295781229949316,-0.40453130372128776},
{0.54245618177011,0.7235527804550235,-0.42686375432355217},
{0.6862590353635422,0.5832610482957232,-0.4345746034029999},
{0.7898467886679535,0.44051404071939526,-0.42671938128000675},
{0.8469855856082026,0.3157018655509739,-0.4277239178016177},
{0.8853132880921606,0.23820173279348963,-0.39934986718618803},
{0.864329910531892,0.16399216439266248,-0.4754370366071006},
{0.8753287670515224,0.12705312278083933,-0.466537301363673},
{0.24707506617835248,0.8921021998015748,-0.37829562088683194},
{0.13995708155093706,0.9231594991384269,-0.3580342923160199},
{0.21799212802157175,0.956423623515963,-0.1942505714308763},
{0.37065330679443664,0.8981202124936846,-0.23663518350542911},
{0.5461781457187483,0.7895829395604765,-0.27972882349566025},
{0.7031635660451592,0.6401542567378974,-0.3094568256914124},
{0.81466136057674,0.4830911385303931,-0.32085794279815405},
{0.8756623339379017,0.3481309737703773,-0.3346943411892642},
{0.9164774689229215,0.2472294198062184,-0.3145578848779924},
{0.9039642358599482,0.1756826557908837,-0.38985159322542445},
{0.9145360851724712,0.12898453722744652,-0.3833884949677441},
{0.12824900158775382,0.9913398164614263,-0.02824113825556629},
{0.038054497978474974,0.9884970035191544,-0.1463746194436013},
{0.10792001563694927,0.9806317399093648,-0.16344620187466094},
{0.2572892746174326,0.9641655867908664,-0.06470664892466307},
{0.058832957354556625,0.9362108621849657,-0.34647929902924957},
{0.0,0.9536451155767611,-0.3009335367428928},
{0.0,0.9937106401660368,-0.11197840693993283},
{0.0456377797326959,0.9989261567025038,-0.007982888990507775},
{0.1909582348690563,0.9793187741797413,0.06685574825535304},
{0.34993511672982597,0.936414596220616,0.025944518963815444},
{0.5288597442755949,0.8482297257928093,-0.02852548275153091},
{0.4260857183222739,0.897376971414769,-0.11474115136361705},
{0.602379198999185,0.7806374264562301,-0.16656683051824625},
{0.7476636934495877,0.6312157105727624,-0.20631463405062608},
{0.8474220353199693,0.47917838885421427,-0.2286131354695963},
{0.9089528094047274,0.33888010303156874,-0.24282723497286418},
{0.9397942646930268,0.2379898609157024,-0.24525000744427652},
{0.9344046758664238,0.17689516992525978,-0.30918602907647175},
{0.9441277555431333,0.12569714030947948,-0.30466868912164985},
{0.9206156678473737,0.0928223825920602,-0.37927667658830166},
{0.9240849770306301,0.06373521463435536,-0.376835212847489},
{0.8886404658775372,0.04539563258573414,-0.4563522312283513},
{0.8899778876962711,0.02227226559195672,-0.4554594445140917},
{0.8807082376487763,0.44873783461026834,-0.15161581687566147},
{0.943503302661843,0.31646733637442936,-0.09823412275919476},
{0.9063854302301196,0.4131818919129518,-0.0880123631190255},
{0.8036774807069899,0.5816273199045066,-0.1257464422763795},
{0.8532271743055313,0.51765619155982,-0.06352524196239773},
{0.9165614316984231,0.3978882198513418,-0.04000133030871707},
{0.9464066735240378,0.32128490834164186,-0.0330214472891175},
{0.9686442501640115,0.24601795580669827,-0.034691238733913436},
{0.9664214048083193,0.23699138409941117,-0.09932145886443641},
{0.9295207400237466,0.3306908954507234,-0.16320148752908287},
{0.6875420625377427,0.7213552187226319,-0.08326200011392082},
{0.7704237419855101,0.6371371641136147,-0.02243862496466648},
{0.8870225735484882,0.4614917356116656,-0.014708228226046139},
{0.9259929370223541,0.37739146499241744,0.010618979969442803},
{0.9400303088877044,0.33974970912230307,0.03021843020074969},
{0.9594358984346257,0.2793833303474612,0.0377850700529181},
{0.9772626891441669,0.20654507942407474,0.047924592563880174},
{0.9819391205573763,0.18547948018193772,-0.03732192318791335},
{0.9788608479715003,0.17440380907866723,-0.1068398412923153},
{0.9569495637831935,0.23453608410039636,-0.17099812171485265},
{0.8313707295900444,0.555273085170559,0.022237600277152228},
{0.9050684660813145,0.42442574492762647,0.026718135186532134},
{0.8677357893023461,0.4937212782061634,0.05721799900649038},
{0.7347232779973719,0.6743880352367241,0.07336540532394988},
{0.7975268777080758,0.5944821042445857,0.10267378957717198},
{0.8853431153767837,0.45577897473034945,0.09183188035035697},
{0.9112261864994595,0.4063244175583802,0.0675818373048212},
{0.9202663544777002,0.3869592190452129,0.058072365306079454},
{0.6418416177699428,0.7661729940687048,0.03191051328730221},
{0.46970231680692837,0.8783142832174362,0.08912773688614123},
{0.5852517545542921,0.8001274957265442,0.13143962254012873},
{0.6754145682205472,0.7200342182950382,0.15926671190083966},
{0.8329855033419876,0.5375795620447155,0.13093267618859405},
{0.8891978473974551,0.43814242512929447,0.13175129405646338},
{0.9099861247263509,0.3995381391010554,0.11088069358181317},
{0.9182258585153028,0.38308730484325004,0.10052556700546313},
{0.9183367981409938,0.3838517908607143,0.09651594600463752},
{0.9248115094891997,0.3751074405591901,0.0633883266338677},
{0.936047541168211,0.341788649846266,0.08363922231353595},
{0.957141237741107,0.26714999130441475,0.1118549648494556},
{0.9708608641079929,0.199624082324285,0.13258736101027274},
{0.9877303954086587,0.13804708640248387,0.07301827114935025},
{0.990961275038219,0.13360533850247894,-0.012056736634154583},
{0.9882416568110247,0.12549318715253835,-0.08734922851232674},
{0.9798523571857171,0.12096642408725755,-0.15892288180477923},
{0.9711464291248508,0.1660617093076862,-0.17116694160923798},
{0.9565226375578618,0.17356181457576914,-0.23439441196521207},
{0.2832205223223777,0.9494874452648371,0.13512855738108387},
{0.38739115369832894,0.9034366190585041,0.18365829515820142},
{0.48483047248663214,0.8471788893145656,0.21731852762276874},
{0.7337744499500041,0.6539672610440019,0.18412462649839934},
{0.8456943601106444,0.5072993896134727,0.16567552195434845},
{0.8809597720541915,0.4387082519467804,0.17732723901315053},
{0.902466908102665,0.40081544923909385,0.15779878146196047},
{0.9134042403910743,0.38040026857937176,0.14487349412624256},
{0.9178710499476691,0.3730077518455011,0.1355653079926006},
{0.9243426011080127,0.3616041790715093,0.12179151635025032},
{0.9213434525527984,0.37707361085511626,0.09456074468178531},
{0.9219771634153571,0.3763077166721469,0.09138168587614894},
{0.9392750523932357,0.3239332453454123,0.11326795006387787},
{0.9569344607662057,0.24856028387126708,0.14998074236356593},
{0.9681743746404002,0.17519669163791954,0.1787302423452668},
{0.9797971392080311,0.1279524368832734,0.15370666835043315},
{0.9930491431316918,0.07709044582300992,0.0889407807938649},
{0.9966785580696029,0.0814354426469612,0.0003472249855417899},
{0.9936449471064558,0.080640180380912,-0.07852948744225015},
{0.9850000026729423,0.07986122850797824,-0.1529613641266976},
{0.9706066225143648,0.08195122943773925,-0.22628915202656197},
{0.9654733788625546,0.12165299542835611,-0.23035126092780717},
{0.1816268591429197,0.959269193656723,0.2163661205897501},
{0.24438213546299983,0.9344126826432633,0.2591337692813582},
{0.560371450918345,0.7910272058747582,0.24547870897827745},
{0.7610090345491242,0.6122525759406388,0.2145041551780815},
{0.8394492868937447,0.5022127431468169,0.20762286809148167},
{0.8600305976928324,0.4564806526732308,0.2279754038643878},
{0.8857567785249107,0.4145402657522172,0.20878529011224284},
{0.9018730762499331,0.3857318646341571,0.1945144800299936},
{0.9123681746258931,0.3666290736575239,0.18211929134180638},
{0.9251412710397203,0.34242664602763495,0.16388294819558083},
{0.943031976881519,0.30468975090109873,0.13362202765547582},
{0.9358529379015726,0.3404049825950922,0.09112478502268344},
{0.9285130665250853,0.3628803514532938,0.07862147175750654},
{0.9288451405429083,0.35971834870670194,0.08859692146766948},
{0.9478441922788318,0.3022511490208222,0.10117129078390558},
{0.9639155644613213,0.21975402061726704,0.1502496423015983},
{0.9716179992635736,0.14501043038962014,0.18689686617294413},
{0.9735705174036119,0.10361218301950083,0.20353123389887048},
{0.9830900126796284,0.061570762490785864,0.17246178758168798},
{0.9946003696842428,0.02439270927268597,0.1008717024655861},
{0.9992896477463743,0.036328406108518244,0.010022315927055978},
{0.996564988213959,0.04212482776466291,-0.0713002324814543},
{0.9879219700680092,0.04606581102945898,-0.14794634875907492},
{0.9734944404875135,0.05074040743339777,-0.2230111777319599},
{0.9526186107713223,0.05694100750536353,-0.298790066897128},
{0.949576250949934,0.08706236160699635,-0.3012060570826563},
{0.9259848163127885,0.03936212278527072,-0.37550331988946345},
{0.9269134194212992,0.018072380984889214,-0.37483983505258833},
{0.8906642789571344,-0.0009515167875617274,-0.45466057318132497},
{0.8977285493013447,-0.023950244273243344,-0.4398975307597842},
{0.9262233556084749,-0.04571041649445251,-0.37419360409991037},
{0.9245767488335558,-0.07679849390806803,-0.3731753299051591},
{0.9211590757760232,-0.11584390707733401,-0.37154561807202185},
{0.9144316556949227,-0.1658070401835759,-0.36921913884386387},
{0.9272491502788178,-0.0013343265216902774,-0.3744425628583694},
{0.9548458742893053,0.013175554464002719,-0.29680930092781477},
{0.9548638146234262,-0.003241130055217405,-0.29702624563961444},
{0.9323098465178394,-0.02080274621517348,-0.3610617618023123},
{0.9542019229097314,0.03284334819033415,-0.2973550147467158},
{0.9749186354214979,0.02623774973450749,-0.22100958078045818},
{0.9753533293550615,0.007043137772904904,-0.22053633969554498},
{0.9750927989079079,-0.007911832016599878,-0.22165612202707907},
{0.9581785643973911,-0.020762422216508102,-0.28541681897368637},
{0.9531852268418224,-0.04151788145766007,-0.299523269296012},
{0.9892444771204956,0.019365722402484464,-0.14498390697738547},
{0.9894946898531386,-0.0012450465537015788,-0.14456385651856457},
{0.9890195711962532,-0.01667811381003463,-0.14684048593803714},
{0.9761598172437905,-0.02248552956032891,-0.21588518281475655},
{0.9740874890100762,-0.04263699132286489,-0.22211629999839866},
{0.9706143627480189,-0.06842117945681729,-0.23070825955954577},
{0.951399746903921,-0.06943566215608882,-0.3000286826490102},
{0.9482342971382741,-0.10515411215591944,-0.2996570213216828},
{0.9425076158584559,-0.15136823687123294,-0.2979379984414609},
{0.9318643602101042,-0.2122615438729974,-0.2942343473540518},
{0.9976830939291124,-0.013070964045804986,-0.06676521539654443},
{0.9970437788902382,-0.03093328261795065,-0.07033374014476818},
{0.9879859019012166,-0.03198034144858875,-0.1511989266009232},
{0.9876172332389241,-0.051876290481432524,-0.1480575938457012},
{0.984442552368138,-0.07162476474474042,-0.1604454865746198},
{0.981006489241707,-0.10143560808345241,-0.16533930409434053},
{0.9673363285467893,-0.10115082968651982,-0.23244125521805917},
{0.9620314317391013,-0.14325092520615662,-0.23232455051843973},
{0.9522087788056189,-0.1939124712353141,-0.23600083700047683},
{0.9351475309018714,-0.2725862815786295,-0.22626492115056135},
{0.9100936081546455,-0.29010373363644326,-0.2959213546303378},
{0.8693775144759911,-0.40516854259092877,-0.28288016794800386},
{0.7465517653228014,-0.5696855470790809,-0.34368421427615375},
{0.6376055263395277,-0.6979528601918159,-0.32606900762163404},
{0.4681566311650267,-0.7754010678062563,-0.4237718168320431},
{0.9998799452311088,-0.0009110367110570446,0.015468197592026544},
{0.9976812921945635,0.011048380286892883,-0.06715632880095584},
{0.994020723371735,-0.019740849311343418,0.10739227335334517},
{0.9824145740636443,0.002550898451663388,0.18669519968236345},
{0.9796876358861172,-0.04730998674462384,0.19486893350684187},
{0.9926576866908292,-0.05489944066381723,0.10778111369071773},
{0.9994163937917159,-0.03023008050081208,0.015906415475405798},
{0.9255882833481446,-0.34947897612262147,-0.14543306012361495},
{0.9603417987904163,-0.2586918151704531,-0.10402967970633997},
{0.9516319114318006,-0.26203486447722796,-0.1604195591038029},
{0.902194833779266,-0.3789829228957604,-0.2059524849458939},
{0.9661331721423844,-0.19244812383232918,-0.17190233657373782},
{0.9728918994123567,-0.2043478054252856,-0.10827431124549611},
{0.9730427413278634,-0.22566290838639605,-0.047582300572266784},
{0.9618375091503419,-0.26945743205625383,-0.047553110320097146},
{0.9399535152366834,-0.3289626730189947,-0.09094475770708386},
{0.880618346520456,-0.4585320977337102,-0.11941374761517753},
{0.8435513176126876,-0.5053302692019901,-0.18183094781181414},
{0.7977393213163687,-0.5457611891824068,-0.2564306916262261},
{0.9728407858646418,-0.2294249691145339,0.030740671838156316},
{0.9813828520437669,-0.18748364120960376,-0.04168431351516401},
{0.9812500729871884,-0.16059170025222141,-0.1065767332617117},
{0.9876440081157145,-0.15339993081949294,-0.032058921655309165},
{0.9794939799105126,-0.19627089470218492,0.045489330747636614},
{0.9585981077274961,-0.25402535581450975,0.12868871925920905},
{0.9515586864944255,-0.2873319414954821,0.10943683819190189},
{0.9646638966941296,-0.26278856608347173,0.019124224185327145},
{0.954942500259307,-0.2965091038044461,0.012929522790408866},
{0.9458708817835494,-0.32220779803561694,-0.038863992062701004},
{0.9069010301325243,-0.41606107650561797,-0.06651091761171583},
{0.8093484152842716,-0.5815693730905086,-0.08205002717824751},
{0.7536452770064574,-0.6404899343025212,-0.14761924164217893},
{0.6940900053439781,-0.6824319830903687,-0.229184757208989},
{0.9911700598282025,-0.09413014290295772,-0.09338858975927611},
{0.9870703162664956,-0.12441674704925045,-0.1010577250844447},
{0.9758873178234013,-0.13875360524341832,-0.16849741820989872},
{0.9953609746810659,-0.09581630656770156,-0.008704336716999474},
{0.9902250801511262,-0.106074961800819,0.09056706420465795},
{0.9973842021912799,-0.07224904460526191,0.0021974469028871223},
{0.9940060139924931,-0.06881566109706959,-0.08494968472295127},
{0.9958859742964979,-0.04790182710178746,-0.07691905589530863},
{0.9985820688202465,-0.05207377808089595,0.01105321071263846},
{0.991470792444609,-0.08157890866577988,0.10163931026015184},
{0.9742905361744504,-0.1199828263662999,0.1906884173148863},
{0.9722348531061763,-0.15016879444303663,0.17946789011167602},
{0.9880353748222317,-0.13372750539707287,0.07683132434214669},
{0.992208737303121,-0.12287967137653483,-0.020552566305477114},
{0.9765758388356677,-0.08792449965096476,0.19638969770214454},
{0.9573677816513438,-0.1249562608757249,0.26044742948230976},
{0.951845295538116,-0.16345096075180418,0.2593729299508117},
{0.9463900463431895,-0.20120611968841476,0.25270927482478217},
{0.9690851359673838,-0.18347582018460556,0.1649564265333832},
{0.984537411340448,-0.16406532956790715,0.061389358237593145},
{0.5091893168553017,-0.8052559945854367,-0.3037910841098705},
{0.37692347251389213,-0.882749923144727,-0.280501816493312},
{0.5632880159751936,-0.8026857759191546,-0.19596468099072076},
{0.4208775279219942,-0.8925766494226178,-0.1617684499393008},
{0.25493389245559805,-0.9313464796952483,-0.2600047023357578},
{-1.6603844244073156e-18,-0.9339449083569755,-0.357416994775123},
{0.06655011557839345,-0.9696377096873428,-0.2353163701674556},
{0.06543804072911227,-0.9199266934191903,-0.38659118143119886},
{-7.105277347458713e-19,-0.8600051134233222,-0.5102854151215168},
{0.14543962473012956,-0.9084040927385846,-0.391981274876936},
{0.1509866803229283,-0.957779321742091,-0.2446666982004743},
{0.16854910464603767,-0.9795599994501525,-0.10978800845373074},
{0.07442147245514423,-0.992552813019361,-0.09643836272439284},
{0.0,-0.9785235321252008,-0.20613514275159656},
{-0.06655011557839345,-0.9696377096873428,-0.2353163701674556},
{-0.06543804072911227,-0.9199266934191903,-0.38659118143119886},
{-0.06714941565467397,-0.8409463368614745,-0.5369359500876276},
{0.33771910536799016,-0.9409517555659064,-0.023571159642305283},
{0.28524931693996597,-0.9493303253391774,-0.13192710326803372},
{0.4858234655070222,-0.8718429385336277,-0.0621727503959433},
{0.5679189746801317,-0.8229402370399119,0.015407934935005767},
{0.4129626670276738,-0.9086308429879818,0.062063087357463145},
{0.20383791667351137,-0.9789908222496284,0.005203237184572177},
{0.09245239270369636,-0.9954621386407498,0.022531879995821482},
{1.0611471438536724e-18,-0.9976134676830057,-0.06904613745524395},
{-0.07442147245514423,-0.9925528130193609,-0.0964383627243928},
{-0.16854910464603767,-0.9795599994501525,-0.10978800845373074},
{-0.1509866803229283,-0.957779321742091,-0.2446666982004743},
{-0.14543962473012956,-0.9084040927385846,-0.391981274876936},
{-0.14477710011573583,-0.8298306139585309,-0.5389069895810277},
{1.2946032336450468e-18,-0.9898349348362534,0.1422209611052809},
{0.16575776480537247,-0.9665207798786378,0.1958620572482493},
{0.12272057653061937,-0.9852091432366215,0.11959349555454453},
{1.1761008600349075e-18,-0.9988755579700498,0.04740906759283316},
{0.25980491788042115,-0.9606923719925202,0.09783440622057608},
{0.33483343575533087,-0.9271350425937815,0.1682473865916124},
{0.42147241135931673,-0.8802896467166516,0.21783283578569118},
{0.22017351317967032,-0.9419201690031034,0.253594202061653},
{-2.833088077520554e-18,-0.9760838899004604,0.2173942038711841},
{-0.16575776480537247,-0.9665207798786378,0.1958620572482493},
{-0.12272057653061937,-0.9852091432366215,0.11959349555454453},
{-0.09245239270369636,-0.9954621386407498,0.022531879995821482},
{0.6751242664474422,-0.7123466599021752,0.19175364658857963},
{0.5962758405963242,-0.7853770673328309,0.16624675644603987},
{0.503931105223968,-0.854700429426099,0.12466201156162902},
{0.731068074869514,-0.6735211891921121,0.10912688768505188},
{0.7872122796432153,-0.6016391249916726,0.13537795262961666},
{0.8203131045590311,-0.5494421706187288,0.15874417039533767},
{0.7299894836740333,-0.6502278051682926,0.21052115122082943},
{0.5076336463965628,-0.8246776420794864,0.24942908350941795},
{0.2810651643383102,-0.9131726965486724,0.2951575844756573},
{0.0,-0.9611710490199906,0.2759532832307138},
{-0.2201735131796703,-0.9419201690031034,0.253594202061653},
{-0.42147241135931673,-0.8802896467166516,0.21783283578569118},
{-0.33483343575533087,-0.9271350425937815,0.1682473865916124},
{-0.25980491788042115,-0.9606923719925202,0.09783440622057608},
{-0.20383791667351137,-0.9789908222496284,0.005203237184572179},
{0.7722940526472156,-0.6350347740824659,0.017109411204698395},
{0.7046404228919154,-0.7086865763146217,-0.035287547069219674},
{0.6309509252154397,-0.7685722304168078,-0.10581898034811041},
{0.8541364536847853,-0.5191736767347463,-0.030159772421282025},
{0.8846006779518155,-0.46617986028164093,0.012568947250185014},
{0.8244170947815077,-0.5632032110267099,0.0560231819983635},
{0.6546683906188541,-0.7525482246266176,0.07127740129834426},
{0.9268210908743757,-0.37452173891786883,0.027131763458497965},
{0.900747828478997,-0.43128920525211817,0.05140983294436833},
{0.9208742204078904,-0.38242661276418194,0.07576645720815078},
{0.9036983665207445,-0.4183236029184436,0.0912941706193252},
{0.8577479988864307,-0.5065388974516434,0.08767391730039915},
{0.9221474828370951,-0.38636495862393855,-0.01913474966471978},
{0.9430495021858413,-0.3323252122581397,0.014750922839581605},
{0.9300287379927665,-0.36032035877922214,0.07222039571197887},
{0.9052209171681278,-0.4032163193005073,0.13413310915297932},
{0.9038582511816554,-0.4079772492010772,0.12882090632021614},
{0.894391368327735,-0.42623099124910846,0.13561424099129218},
{0.8731581425704055,-0.4727200469614301,0.11887226448496174},
{0.3611332480431709,0.855074707626761,0.37206185175962186},
{0.5980796615273788,0.7202243191692423,0.3515361269407418},
{0.35393597784727787,0.8407973526003109,0.40962072145534767},
{0.0,0.9134594360244157,0.4069297958345594},
{0.0,0.8962882893003332,0.44347187336186494},
{0.3269280683897223,0.8330414388509426,0.44627345793371603},
{0.5566290075626007,0.7305404747676353,0.3955689101359612},
{0.6951025554273305,0.6296069344898021,0.34702672156586},
{0.7385430026445682,0.6053319443552923,0.29686271303042866},
{0.615835999936509,0.7238713779055483,0.31105666594902465},
{0.34348580260486256,0.8775267351574397,0.33461071783912993},
{0.0,0.9303165506478979,0.36675757059752334},
{-0.36113324804317093,0.855074707626761,0.3720618517596219},
{-0.35393597784727787,0.8407973526003109,0.40962072145534767},
{-0.32692806838972227,0.8330414388509427,0.44627345793371603},
{4.661664385539601e-18,0.8795905608719605,0.4757314843742737},
{0.28894414862671136,0.8282711254921297,0.4800814739712269},
{0.4995623270500667,0.7466541307456244,0.43925515413346994},
{0.635107715093734,0.6616382754933678,0.39858873871520617},
{0.7198128795526143,0.589540209925226,0.3664856877307683},
{0.7759984360643537,0.5492608362632123,0.31006283391131234},
{0.8160651392949974,0.5181158165539324,0.25611264916846366},
{0.7614493517010186,0.5971974608108099,0.252091407222102},
{0.6042479477342781,0.7474830809957341,0.2759591659721379},
{0.30207873419255066,0.9058232350231774,0.2970399051319065},
{0.0,0.9460365296755042,0.32406000141876296},
{-0.34348580260486256,0.8775267351574397,0.33461071783912993},
{-0.615835999936509,0.7238713779055483,0.31105666594902465},
{-0.5980796615273788,0.7202243191692422,0.3515361269407419},
{-0.5566290075626007,0.7305404747676353,0.3955689101359612},
{-0.4995623270500667,0.7466541307456244,0.43925515413346994},
{-0.28894414862671136,0.8282711254921297,0.4800814739712269},
{3.6307061557815796e-18,0.8639341053077515,0.5036048666227274},
{0.24874918785057457,0.8237158680803929,0.509525279271053},
{0.43698910037854943,0.7615551273179232,0.4786170851590318},
{0.5661650344268226,0.6928886926527248,0.4465001829635377},
{0.6523868425654006,0.6307824441659858,0.4201248811716965},
{0.7117144677962672,0.5771943962185423,0.40038624514759324},
{0.7746872696838508,0.5312291385708803,0.34300909102095395},
{0.8250465286912574,0.4886229947331477,0.2838059099323276},
{0.0,0.9598073060606548,0.2806598211938939},
{-0.30207873419255066,0.9058232350231774,0.2970399051319065},
{-0.6042479477342781,0.747483080995734,0.2759591659721379},
{-0.7614493517010186,0.5971974608108099,0.252091407222102},
{-0.7385430026445682,0.6053319443552923,0.29686271303042866},
{-0.6951025554273306,0.629606934489802,0.34702672156586006},
{-0.635107715093734,0.6616382754933677,0.39858873871520617},
{-0.5661650344268225,0.6928886926527248,0.44650018296353766},
{-0.43698910037854943,0.7615551273179232,0.4786170851590318},
{-0.24874918785057457,0.8237158680803929,0.509525279271053},
{-2.7535869337982762e-18,0.8496523728335166,0.5273431950242413},
{0.21256989421380365,0.818253055165244,0.5341123269375802},
{0.37814647726591266,0.7716906647534554,0.5113694942639332},
{0.4976883216493141,0.7177337229748989,0.4869955209224004},
{0.581942194387542,0.666161611473635,0.46644612742551755},
{0.6426710547488589,0.61933200856401,0.45100086314336285},
{0.6892718008888266,0.5756271364033857,0.4399520250385396},
{0.7553491879108714,0.5296572299654629,0.38588965141306875},
{0.8129043759674859,0.4827450239377658,0.3257970493976861},
{0.8568127213098072,0.44231626214845493,0.26500619774016987},
{0.8792316531972629,0.40529240193672306,0.25037925023525703},
{0.8965629778528503,0.37408337882431436,0.23714226200956678},
{0.9165752557837453,0.3350933737084471,0.21817935599330443},
{0.9415776524915883,0.2795576947828218,0.18782710032405953},
{0.9655704912589873,0.22043639771071472,0.13813551670081567},
{0.956700949241678,0.2782174196482153,0.08554742032557941},
{0.9463748365066952,0.3196293129619397,0.04702947078592499},
{0.9374664503840013,0.345082681256303,0.04554774968515697},
{0.9366113619262874,0.34448359184724714,0.06395476259516746},
{0.9418250534683026,0.33577219002769515,0.014919955208861024},
{0.9585657981009051,0.27790033888830645,0.06263395530332852},
{0.9737300846674455,0.1954092474369061,0.116897169468177},
{0.9800775221408311,0.1192409983537328,0.15883839241787195},
{0.9734574476621531,0.07446695255814487,0.2164145803031514},
{0.9736403458105702,0.035975832638153474,0.2252336930298502},
{0.8669743137228534,0.39828261569083934,0.29954381546486736},
{0.8952624851603728,0.3454125788916263,0.2814164760775555},
{0.9287759435011832,0.27163426031244087,0.2521707266872981},
{0.959812868027901,0.1848974760241182,0.21112124887837677},
{0.9821611411012205,0.11420349864569344,0.14938893469006026},
{0.9815924500076122,0.1723074874725024,0.08237955965509114},
{0.9697825759265879,0.24085127967767778,0.038889799521429146},
{0.9525926938155171,0.3042450291899364,0.0014566751563424366},
{0.9425490845898212,0.33406369856908524,-0.0016335351950620247},
{0.8421701027960486,0.4396616408468747,0.31216527597464594},
{0.7907428997413873,0.48415805744979346,0.37458863025327505},
{0.8228464898647918,0.43635062428700294,0.3640354197073877},
{0.8599847266739247,0.3730565840254175,0.34821696541504354},
{0.9036609374644353,0.28338680408117184,0.3210744919384868},
{0.944647304299739,0.17166306326679975,0.2795948196749984},
{0.9748877611088316,0.06362106811054753,0.21341558737046987},
{0.994159548281356,0.040026901442632386,0.1002229500758781},
{0.9898922300943583,0.13639191516952007,0.03886667306586174},
{0.9720312159055843,0.23416436085021514,-0.017954593081476764},
{0.953042719668102,0.29912047587837814,-0.04729181110848151},
{0.9359680397218815,0.3465800460785769,-0.062016935423720505},
{0.9396934045597867,0.33905362674052547,-0.04493265650875401},
{0.9628691383959018,0.2698890967787923,0.006549638513770234},
{0.9815504011721133,0.18082054357148974,0.062150953181543116},
{0.9889499795181719,0.10354053367642031,0.10610040479192163},
{0.9799368378755546,0.04942334840440228,0.19308321109551713},
{0.9702401171905904,0.00727602774400925,0.24203548172583655},
{0.9697262170434222,-0.02603778702202844,0.24280258982483913},
{0.9637465181240085,-0.079553775469541,0.2546838149792642},
{0.9647417332268045,-0.07714360320161509,0.25163913180507724},
{0.9530610278071087,-0.11033940943814102,0.2819572520792822},
{0.9514081221083859,-0.13411844308626433,0.27719096018865985},
{0.9732167667111533,-0.08924310686324569,0.21186031452276263},
{0.9579500975173233,-0.1484457777063974,0.24555134238625845},
{0.9348443574119164,-0.18924236961736146,0.3004219581800023},
{0.9419238649053345,-0.1602743251417049,0.29511281473729334},
{0.9629099842365371,-0.05490046513839654,0.264178540357046},
{0.9745595444079532,-0.015981108894768305,0.22355826659252886},
{0.9835905980635338,-0.02875688531560077,0.17810832924926698},
{0.9924331633428551,-0.033601121196441604,0.11809903027390052},
{0.9834045915480983,-0.09368365722456892,0.1553666041694526},
{0.9683797968062107,-0.15508031759995558,0.19542431842188787},
{0.9368685849526033,-0.20947711933075536,0.27999391244417277},
{0.9149263960089774,-0.24486247354873253,0.3208614326054477},
{0.9303254008679616,-0.20664451537370218,0.3029730891776271},
{0.9452095846288708,-0.22140025410159114,0.23991825401471284},
{0.9081749870120723,-0.2753250317233378,0.3153003645290714},
{0.9096273306745098,-0.2971428520652303,0.29031748958081477},
{0.9554671229384315,-0.22757178530501931,0.1878660680294409},
{0.9132347039595184,-0.3186001998261257,0.2539611941906155},
{0.855306710521611,-0.38664835840540845,0.344896329176035},
{0.8716255648173796,-0.3448207598432609,0.3483784125601066},
{0.8912999916702835,-0.30291303286967786,0.33738408285846255},
{0.9780103025289819,-0.15775588127612158,0.13641455226611093},
{0.9839962375009755,-0.16062597461640774,0.07714078598544988},
{0.9626681091210113,-0.2361338901061254,0.13232874829274505},
{0.9184200976489774,-0.3332955957518226,0.21311632993949675},
{0.8580507175371276,-0.42183026493802633,0.292930356426805},
{0.8475691172809964,-0.4163103246480629,0.32910834845524223},
{0.7886600475908336,-0.4823257974267879,0.3812835617629446},
{0.797110482445151,-0.46215214933745463,0.3886261309264082},
{0.8327424705442465,-0.4092041595297726,0.37295030979394117},
{0.8659654068182051,-0.359745674346899,0.3474002935849012},
{0.9035342240716983,-0.30239921498028033,0.3036126161911987},
{0.9176343908762333,-0.253830230837182,0.3058060473475743},
{0.9944862264561678,-0.09924990391138606,0.03386151152197053},
{0.9942786672939201,-0.10616051650535718,-0.011826939567869916},
{0.9852605155310467,-0.16848964946369013,0.029545804424642212},
{0.9665274660880656,-0.24111070143230953,0.08769428118299898},
{0.9312673679422714,-0.32557287900730786,0.16353406330415368},
{0.8675256681879686,-0.42716978605683714,0.25480421683161825},
{0.7859388389071501,-0.5167852928412596,0.3394600162025777},
{0.7825406970354705,-0.505083913178124,0.36403337502475436},
{0.7071911705862054,-0.5701243628944531,0.41813736867099816},
{0.7259836231706944,-0.5435774310607061,0.42127349231751415},
{0.747860402342098,-0.5195128246784702,0.4132931690740997},
{0.7950483257924751,-0.46620042567508535,0.38801459090471274},
{0.8408326260177341,-0.4127822274286749,0.3501590035157497},
{0.888789573085926,-0.34995828690846964,0.2959430556675165},
{0.9318046884415355,-0.28292877947325323,0.22735727026894928},
{0.9396819488231701,-0.24169551082653112,0.2420353591981787},
{0.9645481078508239,-0.2187020941589379,0.1477035600515124},
{0.9910668225140641,-0.09548260918604509,0.09311081921507207},
{0.9978188747742238,-0.036235468132134505,0.055176842910289056},
{0.9991207016139805,-0.04186832126453352,-0.0022061914869758044},
{0.997640831605188,-0.051996636360051,-0.04482321855187809},
{0.994943938776239,-0.06544846773726833,-0.07617779704918788},
{0.9916774018678144,-0.12022639764499032,-0.04606022073340555},
{0.9842569919818034,-0.1766366169784482,-0.006138344837276201},
{0.9704001740659051,-0.2370898366533776,0.04595553860565814},
{0.9382269638939449,-0.32392380383313457,0.12166977246885623},
{0.8778466215915314,-0.42667054206732513,0.21757195934290244},
{0.7941958079495847,-0.5211702227945817,0.312465386095088},
{0.698673350388674,-0.5974293316713424,0.39361623837870113},
{0.6992366202176741,-0.5872606474910518,0.40766785604822314},
{0.623723460855008,-0.6362207348996554,0.45408393592241697},
{0.6449954683506278,-0.6157228521857613,0.4526214920917758},
{0.6759290649768451,-0.5877765522265614,0.4445656574367664},
{0.7096099244076512,-0.562214559463496,0.4246981802520875},
{0.7635028025233749,-0.5125351793807907,0.39290095499508915},
{0.8188869743958924,-0.4585035951609771,0.34525146833750026},
{0.8749355182502224,-0.3931150307879778,0.28275150127414334},
{0.9232558883997662,-0.32225030540602834,0.20917290742560288},
{0.9962364819484157,0.02848204524950639,0.08186357635388766},
{0.9995085670611012,0.024057991401224568,0.020095706536544227},
{0.989038870988808,0.03486129174808835,0.14348101620367237},
{0.9943993077816667,0.09594012525962774,0.04433406194461578},
{0.9958617244043944,0.08967750868104897,-0.014743483410187936},
{0.9948065015075627,0.07879918487726331,-0.06442602751188739},
{0.999291729088105,0.015959173953410982,-0.03407851145267404},
{0.997329126411695,0.002325822514258404,-0.07300139834631628},
{0.9947602057986847,-0.014806378920053376,-0.10115781780284885},
{0.9912930233930944,-0.03482597515103137,-0.12698540556677315},
{0.990639637376547,-0.08772085728375104,-0.10458565893977631},
{0.9877041319492074,-0.13649955473270736,-0.07621298634901709},
{0.9824682992544871,-0.18209791400301353,-0.039954857974302926},
{0.9696690928369645,-0.24421679524812973,0.010000365766883715},
{0.9411675522768014,-0.32736444721354757,0.08388180518957988},
{0.8846219763066431,-0.42928861244221106,0.18208582114698024},
{0.8007179600147839,-0.5268674809827099,0.2850638630073913},
{0.6988563152790161,-0.607477378997966,0.3775858638778706},
{0.5990208303235914,-0.664032250339434,0.4474764969778661},
{0.6101784102251128,-0.6506533079453221,0.4520316145525266},
{0.542127878941534,-0.6842725569366832,0.4877175726767357},
{0.5672193558353749,-0.6683372193416538,0.4812354554772212},
{0.5998888677687919,-0.6466773910046787,0.47110688626941016},
{0.6429364386385513,-0.6180220945405811,0.4524173145785309},
{0.6909791608380496,-0.5864816045567791,0.4225957013553859},
{0.7404171150735139,-0.5480022747085938,0.3891991811661758},
{0.8028077224616051,-0.4942332271781553,0.33351653318700153},
{0.863967130247569,-0.42825655658913564,0.264871892790074},
{0.9151119243664496,-0.3563329916377937,0.18867157961069148},
{0.9836513632189795,0.15234044128949834,-0.09603325249706077},
{0.9835809327313109,0.1301946448366025,-0.12497160966905833},
{0.9932080555403549,0.061262219182684326,-0.09891763700453204},
{0.9915305155112315,0.040052673513949213,-0.12354359616919275},
{0.9890250150278259,0.016926212536776557,-0.14677541680529654},
{0.9845178547824014,-0.00811426007298442,-0.17509640886701944},
{0.9853190003119794,-0.06475654339172364,-0.15796536871149117},
{0.9842012935400146,-0.1128386863069788,-0.13643769518237},
{0.9824492726901589,-0.15157095609885382,-0.10871831427067366},
{0.9766119270439658,-0.20203219410139409,-0.07356722437368661},
{0.9646819913496308,-0.262263874398475,-0.02462347967310106},
{0.9380617443000576,-0.343005832496152,0.04885859959469745},
{0.8834749346002079,-0.4439045478995463,0.14973574151570412},
{0.7987153843077472,-0.5426329211909422,0.2600062455209723},
{0.691446452750306,-0.6247464773628246,0.36275837964375185},
{0.5831140845878574,-0.6813233634798007,0.44246631366900296},
{0.4980249969058611,-0.7135047381496682,0.49283069211940395},
{0.5210935194827078,-0.698084834688881,0.4910591690728547},
{0.47943323109188407,-0.7141178159103541,0.5100779567127183},
{0.5040015396246648,-0.7019980875511117,0.5031710773986804},
{0.5329283100928107,-0.6877382061494984,0.49295392898717316},
{0.569919177688476,-0.6678541881941962,0.47870963455351767},
{0.6087952589823382,-0.6487486695521664,0.45661088072331524},
{0.6630847819500637,-0.61539304693812,0.42615721245387017},
{0.7265554246914687,-0.5732760572835568,0.3787766848643402},
{0.7943895135608723,-0.5184500304750709,0.31647253695213245},
{0.8577786335565701,-0.4525051226140022,0.24383381599341425},
{0.9086902301214652,-0.3823062022854883,0.16770221637129945},
{0.9441007387131661,-0.31657167795132674,0.09195742428067247},
{0.9368860752815658,-0.340666968107618,0.07867972282530984},
{0.9846955831901687,0.16617591361583478,-0.05253735984721896},
{0.9848184628642623,0.17357646186556872,0.0019511760305801252},
{0.9602833954278169,0.26137310191756014,-0.09767242220614492},
{0.960449180889994,0.2449382889917675,-0.13244850136383193},
{0.9639315990318641,0.21709844399886397,-0.15396148219975567},
{0.9682228353264858,0.18440343669696327,-0.1689376029387476},
{0.9838881875175467,0.10404289569385641,-0.1453929514078114},
{0.9831922783131802,0.07700766669949104,-0.16553779971607074},
{0.9801467788751406,0.050215985251588456,-0.19180888062313114},
{0.9720628220315362,0.023151556773952878,-0.23357627328782418},
{0.9752954772663476,-0.037331963013274426,-0.2177270230389023},
{0.9732164036749494,-0.0976954282063868,-0.20809957934981177},
{0.9742720595921691,-0.13817720266175645,-0.17804778730050225},
{0.9708375005780137,-0.1866094098863254,-0.15050407174994596},
{0.9643733904960571,-0.23871257939083848,-0.1140187183918151},
{0.951768693424125,-0.30030778503156197,-0.0628616613459364},
{0.924105205446506,-0.38186769393143455,0.014374755586065944},
{0.8669535222284692,-0.4832521022919632,0.12189748121289909},
{0.7772467256868985,-0.5810326782559911,0.24143022637537542},
{0.6634289493137877,-0.6593777315240414,0.35367080227608944},
{0.5491642638859102,-0.7099579574298166,0.4408835560017284},
{0.46058576432953896,-0.7360866927685401,0.4960213044074289},
{0.41580077679100685,-0.7455947307855806,0.520766945422588},
{0.4540545383991307,-0.7270067875826931,0.5150685458925298},
{0.4630659650498439,-0.7247566819430975,0.5101937514232102},
{0.4870614275696127,-0.7130836595483683,0.5042646728246566},
{0.5081558826541048,-0.7029836160176162,0.49758580620313553},
{0.5305988146806913,-0.6925854468410166,0.4886617405562611},
{0.5650554843378643,-0.6757406909627818,0.47337809222316535},
{0.6083159755247294,-0.6559612580432929,0.4468405776870061},
{0.6597715519570055,-0.6270480258014369,0.4141404019976377},
{0.728404755116483,-0.5824133740473925,0.3608617109841783},
{0.79774979947449,-0.5260748792551344,0.2946870863392332},
{0.8586973400430411,-0.4621718456670969,0.22144087986565417},
{0.9052888991004964,-0.3979597215307532,0.1485936378334442},
{0.8668734673361512,-0.45642182512692975,0.2005230888860455},
{0.8743658302680335,-0.44770407497710113,0.18720431647959052},
{0.8723578055292459,-0.45214526326403764,0.18589384078041044},
{0.872936085206502,-0.4627333264924218,0.15446831292405702},
{0.7482600682729799,-0.5714804491157858,0.3369227901263658},
{0.8134167041364727,-0.5149624738108255,0.27049383726508974},
{0.6792872363582508,-0.6194228499182387,0.3935532791375739},
{0.6165633424678119,-0.6549490928680534,0.4369111242303564},
{0.7047753709312365,-0.602750527156849,0.37414366029759016},
{0.7713127678205303,-0.5526443615738077,0.3156910258745271},
{0.8297774690497977,-0.49827032824579565,0.2513882094433613},
{0.8324077381685813,-0.5220407103040264,0.1859323915361016},
{0.8581009270235422,-0.4743533653222089,0.19660031497643277},
{0.8261020236583689,-0.5188358905492708,0.21991990629657165},
{0.7588270853200411,-0.608910499822201,0.23110486319194673},
{0.8351591926869655,-0.4932413158181585,0.24335596816274654},
{6.901654361092817e-18,-0.9337372183224687,0.35795922549840564},
{0.38400571623761814,-0.8533587263108243,0.35258827848639773},
{0.33903951186563064,-0.8824390983963426,0.32611876213331353},
{0.0,-0.9471731956607352,0.320722524032583},
{0.5783123689084201,-0.769645486676663,0.27055614723338667},
{0.6244674287260432,-0.7252887338072845,0.2898218126237398},
{0.643714886925507,-0.6986947408882573,0.3121807223477654},
{0.4088386168152931,-0.8307312835667735,0.3778048701433837},
{-7.036657663945722e-18,-0.9203658880078219,0.3910583488324644},
{-0.38400571623761814,-0.8533587263108243,0.35258827848639773},
{-0.3390395118656307,-0.8824390983963426,0.3261187621333135},
{-0.2810651643383102,-0.9131726965486724,0.2951575844756573},
{0.7470382547490638,-0.5969135264940244,0.29262277394273406},
{0.6366003881022059,-0.6917386592190289,0.34093631840855687},
{0.7085339163596415,-0.6206328172047645,0.3358490666602277},
{0.6051218762913991,-0.7013553588109267,0.3767335603590061},
{0.41149999215970673,-0.8167855633927827,0.4043873141997603},
{0.7640962836054448,-0.5914061169524912,0.2576735807402924},
{0.8013845315392196,-0.53748244840865,0.26247942826497517},
{0.7571924688682783,-0.5733031456702803,0.31302247244203235},
{0.694099418924295,-0.618449126836665,0.3684381551412973},
{0.6500398559086848,-0.6551853138370805,0.3849420609162145},
{0.5530617041079035,-0.7208673194267284,0.41769972376311787},
{0.39226475816634127,-0.8112855810802402,0.43352516124441826},
{-6.572346008040028e-18,-0.8936608132807685,0.4487430788395019},
{-1.385446760945032e-17,-0.9070264797232491,0.4210735863015515},
{-0.4088386168152931,-0.8307312835667735,0.37780487014338376},
{-0.643714886925507,-0.6986947408882573,0.3121807223477654},
{-0.6244674287260432,-0.7252887338072845,0.2898218126237398},
{-0.5783123689084201,-0.769645486676663,0.27055614723338667},
{-0.5076336463965628,-0.8246776420794862,0.2494290835094179},
{0.35534959905456726,-0.8110093541599894,0.4647477702117089},
{0.0,-0.8801717437381852,0.47465535025414235},
{0.0,-0.8663771941843804,0.49939018552350456},
{0.306987190328756,-0.8118335001084658,0.4966741719434321},
{0.0,-0.8520439489970115,0.523470256058143},
{-0.30698719032875604,-0.8118335001084657,0.4966741719434321},
{-0.35534959905456726,-0.8110093541599894,0.4647477702117089},
{-0.39226475816634127,-0.8112855810802403,0.43352516124441826},
{0.48485410789899436,-0.7432458715901199,0.46097946637319276},
{0.4064141571976401,-0.7624210317550867,0.5035292475783715},
{0.25285140871156914,-0.8106197614689823,0.528168313540812},
{4.155832914879045e-18,-0.8368939747371588,0.547365029069852},
{-0.25285140871156914,-0.8106197614689823,0.528168313540812},
{-0.40641415719764007,-0.7624210317550867,0.5035292475783715},
{-0.48485410789899436,-0.7432458715901199,0.46097946637319276},
{-0.5530617041079035,-0.7208673194267284,0.41769972376311787},
{-0.6051218762913991,-0.7013553588109267,0.3767335603590061},
{-0.41149999215970673,-0.8167855633927827,0.4043873141997603},
{-0.6366003881022059,-0.6917386592190289,0.3409363184085569},
{-0.7470382547490638,-0.5969135264940244,0.29262277394273406},
{-0.7640962836054448,-0.5914061169524912,0.2576735807402924},
{-0.7588270853200411,-0.608910499822201,0.23110486319194673},
{-0.7299894836740332,-0.6502278051682926,0.21052115122082943},
{-0.6751242664474422,-0.7123466599021752,0.19175364658857963},
{0.4880303420604548,-0.7250685390105344,0.4859032814928137},
{0.5746415499200795,-0.6924071088537835,0.43630205673844064},
{0.6150573579148505,-0.6644189934430123,0.42456077024023064},
{0.5271576079023437,-0.7034958573574356,0.4766533699782322},
{0.42439243119412773,-0.7428612476892208,0.5177337453042363},
{0.7119763116651115,-0.6010755192192889,0.3630398763538327},
{0.7781481734600251,-0.5498311314197695,0.30359701425159474},
{0.8270683808384784,-0.5050031864852963,0.24683937096199793},
{0.7819226059896449,-0.5439003723796272,0.3045807334150756},
{0.7154991573896128,-0.5958785686246068,0.3646775112735141},
{0.6382417483149156,-0.644582180795553,0.4209053134717702},
{0.631876997132579,-0.6508954434348015,0.4207928019946727},
{0.5687559276810877,-0.6783055134299315,0.4652078300912208},
{0.6362274031965623,-0.6446275099257979,0.42387505808743264},
{0.57478706398511,-0.6758650535961079,0.46133096623021863},
{0.5601215152893868,-0.6833858650594121,0.4682388787220899},
{0.5469777537884579,-0.691529330805545,0.4718077166560211},
{0.4491632585821632,0.732458725097894,0.5116215233625541},
{0.5009406828208347,0.701677387152445,0.506662882648723},
{0.4274455406792518,0.7401889807640373,0.5190477651516454},
{0.33989081499811724,0.7766078005763477,0.5304286549234342},
{0.32555960712081805,0.7800319418977255,0.5343791835678123},
{0.4256639095764332,0.7451220747832067,0.5134231488303537},
{0.4943239600128435,0.708401177601154,0.5037971755880722},
{0.5455779648731324,0.6746088958117569,0.49723990380553046},
{0.5559431412249789,0.6657172802792972,0.49774263074649233},
{0.5283463559581408,0.6892417907556158,0.4957780572209157},
{0.19096105226068638,0.8143366875012307,0.5480781293839544},
{0.18465756733510005,0.8148764290394971,0.5494342437650936},
{0.3279885818306116,0.78442166333715,0.5264087235942458},
{0.4403831678220448,0.7486380904056611,0.4955841755875444},
{0.5056840717589287,0.7111736608063148,0.4883806340802792},
{0.5539542492543174,0.6774534255611051,0.4839334106347794},
{0.5935541616977731,0.6454319087576686,0.48074016712636625},
{0.5871669108314242,0.6421189620016269,0.49286738324080226},
{0.6001367913567438,0.6308888991509158,0.4917469151791171},
{0.5871185700960597,0.6488902835138735,0.48397642980794336},
{0.18876511014569852,0.8200877829146241,0.5402071468481869},
{0.3444498651580217,0.7902996917129687,0.5067353230938294},
{0.20150694096355468,0.8300508580314975,0.5200101208867819},
{2.131954221105107e-18,0.8383399624574486,0.545147784868327},
{0.0,0.852112662363194,0.5233583959776601},
{0.22383108038816396,0.844712930970091,0.4861683985042484},
{0.3754787477738032,0.7970585264252394,0.4729835255302686},
{0.47183663045711527,0.7498968498309856,0.4637077838169634},
{0.0,0.8311102672007076,0.5561076548237476},
{-0.18876511014569855,0.8200877829146241,0.540207146848187},
{-0.20150694096355468,0.8300508580314975,0.5200101208867819},
{-0.22383108038816393,0.844712930970091,0.4861683985042484},
{0.0,0.8729873035603464,0.48774293210915465},
{0.2593290401839532,0.8631414979460332,0.43328420631353226},
{0.42507438458714164,0.8018660121275543,0.41990792581531},
{0.5234584375006682,0.7453102620944504,0.4129211515847311},
{0.583252447182579,0.6997062593295821,0.4125866375811711},
{0.5344924267519671,0.7094379386827065,0.4593644053498543},
{0.5792089083475983,0.6744270456846837,0.45789212762375925},
{0.6154925398741539,0.6420351784538896,0.4571211688239183},
{0.6513751212122666,0.6077525673187849,0.45425462945701606},
{0.6311724353216261,0.611455403452271,0.4772249432701399},
{0.6256071122524121,0.6075038239048856,0.4894434033063881},
{0.6397808994200124,0.5940228402043728,0.4876651167069982},
{0.6334850877044211,0.6101018598550171,0.47589112647492265},
{0.6808353217377688,0.5498924133672286,0.48381979950741355},
{0.6738832122216187,0.5697106371147808,0.4704372500601365},
{0.7141092334609458,0.5225782875263004,0.465789583494414},
{0.734371171974789,0.4844270106626768,0.47542554949518406},
{0.7646142849017861,0.4543936783998987,0.4570463656505097},
{0.7662284944940913,0.4822162939473166,0.42468969857654143},
{0.7285871597696353,0.5316409577882967,0.4318780413736714},
{0.6669683834207865,0.5655268829290837,0.4851108329047882},
{0.7227216700819311,0.5021671278868651,0.4748700488174015},
{0.7990274980445189,0.39884012093542287,0.44997957209292677},
{0.8059101377177029,0.37978918691074376,0.4541684967382802},
{0.8291238775279555,0.34949037444384823,0.43636002782576977},
{0.811438895883551,0.41364259710593526,0.41287615589513116},
{0.7247542651606809,0.5532306694236371,0.41069098059304393},
{0.6932819589216792,0.5659094147071925,0.4462136929538155},
{0.7853032520257882,0.486143939603939,0.38335736897062933},
{0.7523566078011418,0.5020727853767203,0.42647679055491516},
{0.6728367290011473,0.5702165743901397,0.47132132818047917},
{0.6843292213663377,0.5960377482688521,0.4200387118144454},
{0.6526109081871267,0.6304947054961518,0.4202087919790526},
{0.730037260022309,0.5729366660392929,0.3725441929313881},
{0.763777354046445,0.5323913945740373,0.36497062406353104},
{0.8262578312409447,0.46019633810450056,0.32483430654445816},
{0.898173128388281,0.3545222923862279,0.25999803007411887},
{0.863512173951451,0.38072099952969085,0.330754056596064},
{0.8318138935551107,0.3987750141231543,0.3860882471660659},
{0.7301390261886926,0.5075554601907694,0.4574761821852195},
{0.7901356299077036,0.5456980972845012,0.279104412309142},
{0.6887197733987526,0.634263785158777,0.3512470990138305},
{0.7094905362218641,0.6034904746911146,0.3638989227363896},
{0.7945955293583532,0.525310147825259,0.3044128665406949},
{0.6224577686798509,0.6628819428760698,0.41609356642340434},
{0.6565256406080628,0.67308308639109,0.34048970915200494},
{0.7791289479306186,0.5726801441928877,0.25494221883348533},
{0.8741855012398556,0.4528346062901682,0.17532977148234324},
{0.8685004394009038,0.44521088026888045,0.21793177567909994},
{0.8633324069244551,0.4350014041171037,0.25579470981663266},
{0.7916223465644285,0.5155665394981881,0.32791035935098345},
{0.9249720453695869,0.3331958087903656,0.1827765528981688},
{0.9722821086755453,0.21121436480002692,0.10027957544563208},
{0.9596698656263812,0.21854731645088077,0.176835571876141},
{0.9395768334383638,0.2324102441901857,0.25135801650513395},
{0.9170556106632768,0.2436661892969213,0.3156513822946472},
{0.8088366685094189,0.40488804952364865,0.42643746438079294},
{0.6038248122475133,0.7672639692721636,0.21610552415655648},
{0.3142834868948959,0.8820127963955683,0.3511115447541647},
{0.49963212877612856,0.7973791433830469,0.33845862020689044},
{0.7035547882686796,0.6754653131058562,0.22081048592632807},
{0.6003672060197068,0.726094998298157,0.3351794614568295},
{0.0,0.9017591576138452,0.43223884792966977},
{0.0,0.9385916664735766,0.34502997496790677},
{0.3974563205662255,0.8901663142204377,0.2227833168555467},
{0.7110086632583007,0.699854713294782,0.06833784493765577},
{0.8026322719649922,0.5899258984405698,0.08814119552968008},
{0.8458031362357927,0.5214211951801728,0.11285828259625898},
{0.7540110987072909,0.6134862456230048,0.2347379165316384},
{0.9459029663627971,0.02236502200923987,0.3236779016500617},
{0.8971883736655097,0.2003666641800242,0.393581277558787},
{0.9500608251961663,0.00526095659631209,0.3120204332464001},
{0.961128269296121,-0.17202137198715559,0.21596550080857732},
{0.9629453124673182,-0.16685856264786542,0.2118833293780027},
{0.9731050726537783,-0.10920384572458292,0.20283253598583859},
{0.9611640875685348,0.031698945081385335,0.27415100519471614},
{0.9206018960757985,0.17820481095716806,0.34746970269847216},
{0.8663521569333461,0.3128058932961138,0.38934099873524664},
{0.8850985985393269,0.22422586038346526,0.40782745665172426},
{0.95217361508697,0.03047144646296415,0.30403436924575733},
{0.9654290823770072,-0.17951141312741217,0.18900354350564272},
{0.9411975000597128,-0.3244430412538116,0.09425486121852936},
{0.9517503740644045,-0.28363760465635257,0.1171363935464667},
{0.9707232138709032,-0.21109730591604117,0.11460527687298659},
{0.9901715863201177,-0.11083122066403392,0.0853034006967},
{0.9867842452675745,-0.04253337224372845,0.15635781252396605},
{0.8972819144317118,0.24730923470247554,0.3656819772215174},
{0.8854200364964127,0.2409485463069471,0.3974608873880047},
{0.9321378165653724,-0.36005640157974184,-0.03845098971662191},
{0.9150020556014368,-0.4034416567092728,-0.0024633060757218656},
{0.9367744933468886,-0.34885525775240717,0.027451006414735725},
{0.9651758862851358,-0.2606883493512753,-0.0218424597106239},
{0.9653410519632594,-0.2583108130222917,0.03731189180717651},
{0.9371406157649268,-0.34426949881880486,0.056973489157524905},
{0.9004905387083696,-0.4328908315025451,-0.04150081562747113},
{0.903164629015281,-0.42345063290456164,-0.0705918861372609},
{0.937728415729943,-0.3376420072066038,-0.08162899792418554},
{0.9694486723333122,-0.23734443913903433,-0.061942626041808176},
{0.9916698700546852,-0.11370487039929635,-0.06051504997273828},
{0.9908187197926367,-0.13253736660772988,-0.026685407270052672},
{0.9902753293698006,-0.1373134447247167,0.022355982182962805},
{0.973120162515322,-0.17794486203119725,0.14619430694405117},
{0.9381628175213569,-0.3459946365183825,0.011757521886072842},
{0.981000750749496,-0.1706198396000227,0.09233849340219763},
{0.9421264263212928,-0.33342773677127524,-0.03498201221563221},
{0.8944658288679987,-0.4393544691218761,-0.08305739852727274},
{0.8653437655581763,-0.46869831221540975,-0.17748819548359346},
{0.9011814772132358,-0.4061961741094941,-0.15125016782331172},
{0.8949893479002153,-0.42931991002919845,-0.12115478528588308},
{0.8689477534993276,-0.4729927854999261,-0.1456283851228622},
{0.9488365961318015,-0.30657122114627405,-0.07565183544302727},
{0.9584694231481788,-0.26281350402476206,-0.11074938822505379},
{0.9145651227958186,-0.3648241868720684,-0.1745678917745279},
{0.8684034454936903,-0.4528230648959274,-0.2020562489826679},
{0.8558542564741353,-0.47157042216243633,-0.2124495907660137},
{0.8637334132526715,-0.46918610426798985,-0.18392658968381057},
{0.8804094530265522,-0.4499143085423742,-0.14985429586876914},
{0.8809188778675859,-0.46067654678226316,-0.10843915280599706},
{0.9067387303487173,-0.4060592005754157,-0.11375763936391453},
{0.9466724848833632,-0.30234549926921445,-0.11134812722451978},
{0.9744100961872224,-0.2057942256461224,-0.09040852359772646},
{0.9920065234510992,-0.09280113229419171,-0.08550442839631081},
{0.9956538607897863,0.015107932356657083,-0.09189744215319338},
{0.9975181954035812,-0.004828821414104165,-0.07024337920781895},
{0.9987963434955659,0.002182598461804311,-0.04900102533459864},
{0.999934319190232,-0.005078203646999173,-0.010274685069944046},
{0.9916090555831282,-0.10160261668740364,-0.0799273993559723},
{0.9602588713040079,-0.23314835828024846,-0.15344296371348418},
{0.9692176224416906,-0.17000484688616702,-0.17808860823670714},
{0.9334347441224012,-0.2818204114991415,-0.22198386006104578},
{0.9219457093480532,-0.3313985501686118,-0.20047720558920681},
{0.991136584772455,-0.13148509210758152,-0.018972107923338078},
{0.987034656817166,-0.1564788479342429,0.035734526595317236},
{0.9890881939546642,0.03839899981326001,0.14223242032969066},
{0.9962414618488988,0.04536671586425207,0.07378896113146599},
{0.9980696055030416,0.06161006010866677,0.007827072531244064},
{0.991296614577582,-0.05075837031593235,-0.1214685546546733},
{0.9676355603344338,-0.13505829634867403,-0.2131681940713955},
{0.9339810329605274,-0.2513472103174665,-0.25397639641433933},
{0.8914660367783235,-0.3582107380872089,-0.27744075473831487},
{0.8918301635030064,-0.37795063099224474,-0.2485805302085524},
{0.8899974986807199,-0.39459635540098115,-0.22846918533212465},
{0.8797676154514643,-0.42216085296748956,-0.21860731237679587},
{0.8559324814220092,-0.4608949609270407,-0.23442572861958524},
{0.8546407545140177,-0.4605295250608345,-0.23979519859862197},
{0.8673779060885658,-0.45045620121350194,-0.21152961688074862},
{0.8883665863183072,-0.4230927966013717,-0.17831795696784947},
{0.9166275802865587,-0.3732562114076314,-0.1430862666492844},
{0.9775135458310665,0.036892035973134014,0.20762043588850418},
{0.9552854354712318,-0.24474942488664525,-0.16591400120000527},
{0.9249085100305271,-0.3406886332897464,-0.16874686136421904},
{0.9533410054007855,-0.2689843328444029,-0.13707062451769514},
{0.9769294346295995,-0.15825139216233863,-0.14340633400576508},
{0.9772577567066407,-0.17788278275703454,-0.11543393155964883},
{0.8955593276339527,-0.39535244795596713,-0.204132144903851},
{0.927471324993947,-0.31690754437517266,-0.1984100542615469},
{0.9494973671512998,-0.23569978017049592,-0.20712402902688448},
{0.9715821995553908,-0.15028286438702024,-0.18287452031035234},
{0.9829400851763153,-0.06241123260985722,-0.17301337230889546},
{0.9886406957926073,-0.06610536869399626,-0.13498020170580577},
{0.991155149193632,-0.07645194365230513,-0.10847382420996197},
{0.7475782935934201,-0.4462792377415465,-0.49189585982072886},
{0.0,-0.5967686855238319,-0.802413319915714},
{1.847110137411121e-17,-0.6572703605548907,-0.7536548766750228},
{0.6744768788043295,-0.5172342356468757,-0.5268298448580546},
{1.537554130793735e-17,-0.6851117411602399,-0.728437987837252},
{-0.6744768788043296,-0.5172342356468757,-0.5268298448580547},
{-0.7475782935934201,-0.4462792377415465,-0.49189585982072886},
{-0.8172183905896119,-0.35033019100738805,-0.4576274241682328},
{0.0,-0.4734342390568624,-0.8808291669152707},
{0.8172183905896119,-0.35033019100738805,-0.45762742416823293},
{0.8859278115651238,-0.3362389093435547,-0.31949226679043},
{0.839665683384943,-0.4047232898228768,-0.36216101228686165},
{0.7935005451928459,-0.4547640977428618,-0.4044088280228031},
{0.6095123397099419,-0.5613205533732634,-0.5598338540156764},
{-1.3431820961606619e-17,-0.6919008859520674,-0.7219924958188583},
{-0.6095123397099419,-0.5613205533732634,-0.5598338540156764},
{-0.793500545192846,-0.45476409774286186,-0.4044088280228031},
{-0.839665683384943,-0.4047232898228768,-0.36216101228686165},
{-0.8859278115651238,-0.33623890934355477,-0.3194922667904301},
{-0.9251605115261278,-0.254977889245929,-0.2811837547021599},
{-0.8727157752232441,-0.22914038224514027,-0.43111699212747706},
{0.0,-0.2179598854716938,-0.9759577287593794},
{0.8727157752232441,-0.22914038224514027,-0.4311169921274771},
{0.9251605115261278,-0.254977889245929,-0.2811837547021599},
{0.9195011247478171,-0.3098988250294437,-0.2418272106957144},
{0.884244144663734,-0.3727219857003561,-0.2814082692521401},
{0.8491169848366441,-0.4193683414648747,-0.32113944049108406},
{0.8209033659517062,-0.4450050422228832,-0.35789408512207777},
{0.7564472514434094,-0.48068248114448897,-0.4435447081236449},
{0.5621588309958104,-0.5774124127149977,-0.5920915084478656},
{1.237786525192868e-17,-0.6801341071881238,-0.7330877138783694},
{-0.5621588309958104,-0.5774124127149977,-0.5920915084478656},
{-0.7564472514434094,-0.48068248114448897,-0.4435447081236449},
{-0.8209033659517062,-0.4450050422228831,-0.35789408512207777},
{-0.8491169848366441,-0.4193683414648747,-0.32113944049108406},
{-0.884244144663734,-0.3727219857003561,-0.2814082692521401},
{-0.9195011247478171,-0.3098988250294437,-0.2418272106957144},
{-0.9494973671512998,-0.23569978017049592,-0.2071240290268845},
{-0.9535843715849678,-0.16220281892292074,-0.25370670429131414},
{-0.9144878550119122,-0.10534646743673348,-0.3906585271491112},
{-0.9143941483991697,0.008753021748376335,-0.40473043619627824},
{0.0,0.06611775905798928,-0.9978118269178562},
{0.9143941483991697,0.008753021748376335,-0.40473043619627824},
{0.9144878550119122,-0.10534646743673348,-0.3906585271491112},
{0.9535843715849678,-0.16220281892292074,-0.25370670429131414},
{0.8964251997647599,-0.3756073718302199,-0.23524660136440967},
{0.867286948102183,-0.41713600234589254,-0.27168162469789653},
{0.8450051271563087,-0.43941051023712474,-0.3047699764948974},
{0.8351559128096776,-0.4378579981047172,-0.33285879107327715},
{0.8073475464016546,-0.4432314154162087,-0.3895328634497637},
{0.7379157012110352,-0.4760092788566739,-0.4784303338507869},
{0.5394193048283598,-0.5624601189366201,-0.6266302164628611},
{-1.2105563235021314e-17,-0.6455953900725817,-0.7636796398471227},
{-0.5394193048283598,-0.5624601189366202,-0.6266302164628611},
{-0.7379157012110352,-0.4760092788566738,-0.4784303338507869},
{-0.8073475464016546,-0.4432314154162087,-0.3895328634497637},
{-0.8351559128096776,-0.43785799810471726,-0.3328587910732771},
{-0.8450051271563087,-0.43941051023712474,-0.3047699764948974},
{-0.867286948102183,-0.41713600234589254,-0.27168162469789653},
{-0.8964251997647598,-0.37560737183021986,-0.2352466013644096},
{-0.927471324993947,-0.3169075443751727,-0.19841005426154693},
{-0.9552854354712318,-0.24474942488664525,-0.16591400120000527},
{-0.9715821995553906,-0.15028286438702027,-0.1828745203103524},
{-0.9678779809203074,-0.06844715397409779,-0.24192395739668898},
{-0.9730805425303336,0.01604223171152536,-0.2299062951521456},
{-0.9609543504086244,0.09071094054434155,-0.26141587881438916},
{-0.8878412681805593,0.11780236334279147,-0.4448151140714414},
{2.083427940371947e-17,0.25511060053992124,-0.9669118788659908},
{0.8878412681805593,0.11780236334279147,-0.4448151140714414},
{0.9609543504086244,0.09071094054434152,-0.2614158788143891},
{0.9730805425303336,0.01604223171152536,-0.2299062951521456},
{0.9678779809203074,-0.06844715397409779,-0.24192395739668898},
{0.7465838777169114,-0.43075185407755684,-0.5070161276941071},
{0.8527571058195353,-0.31267599111644934,-0.41837667603923123},
{0.8165003183946262,-0.4040169276424669,-0.41242884506277655},
{0.8449107705061992,-0.40258818914535216,-0.35220525243568823},
{0.8788559865938107,-0.31928744038035745,-0.35449638255358756},
{0.9205921701250821,-0.20015659278349163,-0.33533176805917986},
{0.8970883891078739,-0.18333009756748647,-0.4020230061249426},
{0.7875371940649507,-0.32779946921648506,-0.5218550334582344},
{0.5476568343677896,-0.5068151315718126,-0.6657405006307623},
{0.8464808581381928,-0.444527668334086,-0.2930278295505215},
{0.8565283290673122,-0.41266999131623316,-0.30993983250337176},
{0.853308901117897,-0.4472115473838495,-0.26807788263769505},
{0.8706944022607666,-0.43030945751588456,-0.2381701674100927},
{0.8509829142120432,-0.4549057888270165,-0.2624667655358449},
{0.8610702686237979,-0.4260789092665105,-0.27751532492891495},
{0.8890490321912158,-0.3364907287098919,-0.3104284262952549},
{0.9306666319291703,-0.2240887904442103,-0.28921243785644013},
{0.9624310576060923,-0.10353237183212967,-0.25101296249005217},
{0.9516087187580725,-0.07365631396604062,-0.2983548119212356},
{0.9297056995076172,-0.0454624560725568,-0.36548663093320266},
{0.8390899983811988,-0.17943826734147902,-0.5135463784607266},
{0.5935790034613339,-0.3867661789847187,-0.7057449181137689},
{0.0,-0.5742214537516778,-0.8187000195745142},
{0.8666127373128842,-0.43287003667134144,-0.24820534820833587},
{0.9103402262214821,0.4138594323887187,0.0010211493076238052},
{0.9276724560031939,0.3714443096982339,0.0381174391296783},
{0.8663664718596171,0.47873857967888256,0.1421918027333695},
{0.8750292351178012,0.48277318756276383,-0.03541026771494856},
{0.7970905439269261,0.5989451504810738,-0.07688544398962052},
{0.9214239584347014,0.3609170177976715,-0.14393330082562952},
{0.9497832665709312,0.29781999540303433,-0.0959947752744294},
{0.9647386105739462,0.2577400916773194,-0.053380318564233614},
{0.9726214348585698,0.23218871183248277,-0.009795231045223991},
{0.9350579181020927,0.34578677757764414,0.07809093575472821},
{0.8910423018201297,0.31743441674176365,-0.3244672671239756},
{0.6677917966772088,0.6714726378960852,-0.32121427871048674},
{0.8579034810114351,0.4688044738952629,-0.21029498929895554},
{0.9393824605846557,0.25106771099797986,-0.2335071674277962},
{0.5878373430729971,0.7983182928353862,-0.13090134228980965},
{0.0,0.9764881561187339,-0.21557105779727326},
{0.0,0.8743056690858809,-0.4853757276629004},
{0.7200748927597711,0.4858473418341959,-0.4954235654968889},
{0.8828967431744738,0.16827886909507572,-0.4383783333012589},
{0.944351884026531,0.10882257083771546,-0.31041450870056253},
{0.965017784126676,0.1850593290065915,-0.18572485312114306},
{0.979525939974628,0.14543257958871547,-0.13920595429432378},
{0.9886513984752615,0.11435501640493104,-0.09742352136900899},
{0.994416526215339,0.09594089680867032,-0.0439444730241025},
{0.9702265774052022,0.23630460757955782,0.053108576833296825},
{0.9270337273889603,0.3486927120794546,0.13791976227504707},
{0.9870872516622446,-0.015443061806626425,-0.15943735273740983},
{0.9799103152882837,0.01848795947519064,-0.19857988152393521},
{0.9679433172871967,0.053194565491364025,-0.24547112400696386},
{0.8777746282197867,-0.01623134860702221,-0.4787987524795909},
{0.6561712613523479,-0.20249488160244714,-0.7269354157695713},
{-1.4223157793586223e-17,-0.4296605103117085,-0.9029905015439986},
{-0.5935790034613339,-0.3867661789847187,-0.7057449181137689},
{-0.5476568343677894,-0.5068151315718125,-0.6657405006307624},
{-0.7465838777169114,-0.4307518540775568,-0.5070161276941072},
{-0.8165003183946262,-0.4040169276424669,-0.4124288450627766},
{-0.8449107705061992,-0.40258818914535216,-0.35220525243568823},
{-0.8565283290673122,-0.41266999131623316,-0.30993983250337176},
{-0.8464808581381928,-0.444527668334086,-0.2930278295505215},
{-0.853308901117897,-0.44721154738384944,-0.268077882637695},
{-0.8706944022607666,-0.43030945751588456,-0.2381701674100927},
{-0.8955593276339527,-0.39535244795596697,-0.20413214490385098},
{-0.9249085100305271,-0.34068863328974647,-0.16874686136421907},
{-0.9533410054007855,-0.26898433284440293,-0.13707062451769514},
{-0.9769294346295995,-0.15825139216233866,-0.1434063340057651},
{-0.9829400851763153,-0.06241123260985724,-0.1730133723088955},
{-0.9854072126415663,0.018235715886688424,-0.16923381441094726},
{-0.9772688822759568,0.0904655986982345,-0.19173290585413974},
{-0.9654675186186567,0.1507467046927219,-0.21248035560168632},
{-0.9467979927989221,0.1521543926712605,-0.28358878966343587},
{-0.8605975392601474,0.19804867101869905,-0.46919995665718717},
{-1.9654339342467417e-17,0.369717887106307,-0.9291440598495198},
{0.8605975392601474,0.19804867101869905,-0.46919995665718717},
{0.9467979927989221,0.1521543926712605,-0.2835887896634359},
{0.9654675186186567,0.1507467046927219,-0.21248035560168632},
{0.9772688822759568,0.09046559869823449,-0.1917329058541397},
{0.9854072126415663,0.018235715886688427,-0.16923381441094726},
{0.9906196305560617,0.019796767714910287,-0.13520664016613182},
{0.9935517820656362,0.019297423876980965,-0.11172495596736888},
{0.9849484813079719,0.11024443840334906,-0.13312645480989138},
{0.9666593221810643,0.2119105906555162,-0.14374858750080144},
{0.9698907723924436,0.18652587025653727,-0.15658859905188086},
{0.9828848190689495,0.09864156822525046,-0.15558686789656062},
{0.9703321054617016,0.16476943686531487,-0.1769368186255996},
{0.9544986225770491,0.23800935521396202,-0.1796772838428665},
{0.9472031559347791,0.2724274250328462,-0.16908423781407778},
{0.9378302512579675,0.3068525235844189,-0.16222191157575222},
{0.9624635859228052,0.23607134990103518,-0.1339184958417545},
{0.9856003753325883,0.12227967029508319,-0.1167886226341728},
{0.9574946190538564,0.20910356766741595,-0.1986951244285293},
{0.9477704797766446,0.2520333575602936,-0.19547456187656218},
{0.9388411156821971,0.2903554753477085,-0.18512443771748105},
{0.9272970384442282,0.3291280397693419,-0.17831134548915883},
{0.9175197760190111,0.35998224499295045,-0.1690273466154485},
{0.9304561899209766,0.33262163583630566,-0.1536688843303012},
{0.9601076424504522,0.2516563840080163,-0.12191135835616182},
{0.9873829015818836,0.1235777731302736,-0.09901282569396123},
{0.9547203724177974,0.22184455258773966,-0.19822715499539362},
{0.9709254486509484,0.1518353257175557,-0.18506703387204892},
{0.9571851225422282,0.18948577913970446,-0.21884190797842792},
{0.9703681513587572,0.12210778254818541,-0.2085074105871374},
{0.947751680435602,0.2592227800462932,-0.18593090796466213},
{0.9383943282202805,0.29723472315748667,-0.17626004684414676},
{0.9517002849706936,0.21965562451971402,-0.21451800438088015},
{0.9475930563119277,0.19787419336604223,-0.2508250450596157},
{0.952148767330779,0.16569744752666468,-0.2568211065189667},
{0.9637671143977844,0.09675636907850065,-0.24857826584018344},
{0.9533500020168083,0.19046968840101589,-0.234190246284877},
{0.9322327848136673,0.19125720436041735,-0.3071851505180424},
{0.9248396812798073,0.19568624775360416,-0.32615710381713187},
{0.9291217911488651,0.15712986149017436,-0.3347281043479969},
{0.9413823313986248,0.07784393461095811,-0.32823715203306064},
{0.8251264677047422,0.18752129725682443,-0.5329184509549401},
{0.8441408262458234,0.07292644652347947,-0.5311383989719407},
{0.9495176423075119,-0.00727107068755613,-0.31362936482070747},
{0.9517629139719254,-0.07804809567949507,-0.2967420602955942},
{0.9433501827353168,-0.15287578822245596,-0.2944816227009882},
{0.9478665442252643,-0.1962946896583856,-0.251032685422383},
{0.942550849899156,-0.25259332749859587,-0.21861954683322787},
{0.9336339117434833,-0.3123251094162679,-0.17544442103035898},
{0.9172629838466465,-0.38135089171517855,-0.11489175711418449},
{0.8827267690881119,-0.4692716467591923,-0.024032741898895614},
{0.8135116825539688,-0.5727491582252,0.10078265773701184},
{0.7101929170096463,-0.6633038389254438,0.23591108048605636},
{0.5874965283588178,-0.7258922944256625,0.357670527245095},
{0.4722591850250872,-0.7587684723597081,0.448599673999386},
{0.3872462841082423,-0.7714092948214629,0.5049435763601827},
{0.34497500705427897,-0.7741587081955831,0.530726425790959},
{0.35091981462451516,-0.7718336916105568,0.5302150848464386},
{0.9991610581795265,0.0032466065083990346,0.04082449465392637},
{0.9917940871959808,0.1270971785146994,-0.013812885893032803},
{0.9721930661650587,0.2270755167601581,-0.05724815969696094},
{0.9419010995347759,0.3209811296133023,-0.09896177609233164},
{0.9225945772135418,0.36775072012550036,-0.11652748149403275},
{0.9331009697425962,0.3460745008255947,-0.09774978334370968},
{0.9622673424031775,0.2674228760644647,-0.050264968932011767},
{0.9652627470489691,0.24299923637644874,-0.09601666667793063},
{0.9303193537503406,0.3404392050234643,-0.1364076527198544},
{0.9154233587054015,0.3734304689201055,-0.1501657724604118},
{0.9284864685912216,0.3451439944878848,-0.1370711520048962},
{0.9924792096444297,0.1133795785083556,-0.04615289374281712},
{0.9879542179856299,0.13300784370447222,-0.07909093928819531},
{0.9303850029061144,0.32868021625974786,-0.16233626152783892},
{0.2152536198913124,-0.8099436871416538,0.5455796026090686},
{-3.653305422136765e-18,-0.8288935438576968,0.5594063755008771},
{3.2686728329652895e-18,-0.8327521939263143,0.5536459008345588},
{0.245482626280031,-0.8174749521949228,0.5210306926934029},
{0.0,-0.8495697306548511,0.5274763243549834},
{-0.24548262628003095,-0.8174749521949228,0.5210306926934029},
{-0.2152536198913124,-0.8099436871416539,0.5455796026090686},
{-0.21726033745896373,-0.808147531473247,0.5474445297387802},
{0.21726033745896373,-0.808147531473247,0.5474445297387803},
{0.30800786113884343,-0.8278777392172674,0.46877457949976487},
{0.0,-0.8796081187858299,0.4756990197236624},
{-0.30800786113884343,-0.8278777392172674,0.46877457949976487},
{-0.4722591850250872,-0.758768472359708,0.448599673999386},
{-0.3872462841082423,-0.7714092948214629,0.5049435763601827},
{-0.34497500705427897,-0.7741587081955831,0.530726425790959},
{-0.35091981462451516,-0.7718336916105568,0.5302150848464386},
{0.517618509213497,-0.8173500396411951,0.25300195971204203},
{0.0,-0.92129451291394,0.38886555578331433},
{1.0572527546897082e-17,-0.967115646534318,0.25433703275085207},
{0.6364682206285449,-0.7658535867891167,0.0915231540768716},
{1.0268906930967177e-17,-0.9980457375201424,0.06248764532189481},
{-0.6364682206285449,-0.7658535867891167,0.09152315407687159},
{-0.517618509213497,-0.8173500396411951,0.2530019597120421},
{-0.4015026634004376,-0.8327369876570431,0.38124102700290363},
{0.4015026634004376,-0.8327369876570431,0.3812410270029036},
{0.7329559592139004,-0.6758954389126621,-0.07707734757950095},
{0.0,-0.9842533424254661,-0.17676356503617427},
{-0.7329559592139004,-0.6758954389126621,-0.07707734757950095},
{-0.8827267690881119,-0.4692716467591923,-0.024032741898895614},
{-0.8135116825539688,-0.5727491582252,0.10078265773701184},
{-0.7101929170096462,-0.6633038389254438,0.23591108048605638},
{-0.5874965283588178,-0.7258922944256625,0.357670527245095},
{0.844049716696807,-0.3317777472587738,-0.42131176362396167},
{0.8082220360258354,-0.2828705471276035,-0.5164894907449555},
{0.8555737477942769,-0.15801771429263042,-0.4929746079211257},
{6.295936452251452e-17,-0.3512917599497233,-0.936266040926096},
{0.0,-0.48614931382343407,-0.8738757604310835},
{-3.0923845756664524e-17,-0.5988339006396972,-0.8008732480515535},
{1.5801129494588933e-17,-0.7204516826610268,-0.6935051354899221},
{0.8328573174497895,-0.4113815983366132,-0.370288899807102},
{0.7874364125033303,-0.5793582177966846,-0.2104470283357179},
{0.8159472338043774,-0.492351372696927,-0.3030185430801822},
{0.0,-0.9199584154737893,-0.3920159611533116},
{0.07355361500526003,-0.8885698767723088,0.4528061834963186},
{-0.13136528978203268,-0.8945615113408063,0.4272035382205245},
{0.009940135876945005,-0.8668617735188276,0.49844945512111943},
{0.2506817276349469,-0.8204723766700639,0.5137934901799895},
{0.2334778326510035,-0.8017891707310368,0.550111104558912},
{-0.040182940243247055,-0.841075180337188,0.539423648289704},
{-0.23847220738913635,-0.8533077759086654,0.4636775235837507},
{-0.39312381095099114,-0.8503878871013365,0.3497057487870256},
{-0.22036058128840627,-0.9216189175569228,0.319467971814768},
{-0.010895556069998764,-0.9237709353765985,0.38279047246681824},
{0.1386671894599991,-0.9033505443795036,0.4058684571835058},
{0.27918189728171283,-0.8337101010984049,0.47642936051073803},
{0.5103601017711317,-0.6704456992712958,0.5385490978998881},
{0.5221717051543348,-0.6535649630118769,0.5478955643728999},
{0.543109815495336,-0.6293907424429913,0.5557868491064558},
{0.2360195869194723,-0.777423961182279,0.583015213497912},
{-0.06830024359960737,-0.8261415100125524,0.5593078599111709},
{-0.3238403830180519,-0.8205365967158897,0.4710064753022264},
{-0.5336495544769904,-0.7768345403205053,0.33428468402177647},
{-0.7316023554014517,-0.6706556723983339,0.12238857238723944},
{-0.5313554315350942,-0.8330268277230388,0.15403801372338094},
{-0.2192228605671903,-0.9666057602884786,0.13272016268024472},
{-0.03143904851451123,-0.9586400332004551,0.2828796086216403},
{0.0918794099444191,-0.9361659451703893,0.3393397959737363},
{0.17705019263950905,-0.9095989615037724,0.37587625426138793},
{0.2889639839657877,-0.852441642953042,0.4357098361640902},
{0.4916493072065644,-0.6910805096911007,0.5298006114080972},
{0.7263671149716912,-0.4433202477689317,0.5252218314253465},
{0.7534692540029237,-0.42723405599738423,0.49975508468478996},
{0.7755470226881724,-0.41031085793746735,0.47976224888806196},
{0.7997370308324465,-0.38959413832794215,0.4567680909343501},
{0.5801754503513447,-0.6009512417352807,0.5497763653217903},
{0.266884159788699,-0.7592687465187393,0.5935350165017583},
{-0.049056203154149346,-0.8280052061422697,0.558570378317179},
{-0.40087688453827863,-0.8010032390429526,0.44462516177740335},
{-0.6552371740222731,-0.7030723450176019,0.27632141330478854},
{-0.8338507235333708,-0.5480147686427234,0.06612703087494995},
{-0.9327142249275054,-0.32767454920572575,-0.15057743662550213},
{-0.8711615902090313,-0.44184092657988316,-0.2141356564038368},
{-0.35274125258519634,-0.9057650565994712,-0.2348686249118502},
{0.08503370948430547,-0.9963552079306492,0.006750398566857123},
{0.04522044068325893,-0.9850452608284801,0.16625566415543144},
{0.11087054398774676,-0.9588567323071945,0.26134553637862373},
{0.1797336927468713,-0.9278102595590243,0.32690047713117376},
{0.2752586480708991,-0.8875427363656067,0.36945983244032365},
{0.44776768315195853,-0.7351632682670194,0.5089588106278167},
{0.682133907030708,-0.4759857389575647,0.5550954054827354},
{0.8470365393102649,-0.22664254400406625,0.4807933634324156},
{0.8771812630632924,-0.2107512662690086,0.4314358996382853},
{0.8961101251370235,-0.2040735350633988,0.39413276432394695},
{0.9095916442915826,-0.19867178943496752,0.3649281582964558},
{0.9217550305241344,-0.19325842046910563,0.3361827577691014},
{0.8271788950943536,-0.36838599158144136,0.4243428292277868},
{0.6301593171107309,-0.5735826500560023,0.5233566457142499},
{0.3513564584689147,-0.7357873283013323,0.5789349243251518},
{0.36851122039302586,-0.7467131703004077,0.5537318139174928},
{-0.06956438154612236,-0.8491325509840179,0.5235787502176531},
{-0.4712161685725809,-0.7894494296966592,0.3933508871572512},
{-0.7421549533132246,-0.6384129284264739,0.20404646061762322},
{-0.8907552013597277,-0.454218101032442,0.01552700695797898},
{-0.9527254019912608,-0.2707515853226567,-0.13786909532545236},
{-0.9656709704275782,-0.1270612328504358,-0.2265723283633434},
{-0.9512981792823183,-0.13098742393042026,-0.27905925690831074},
{-0.9145326180567684,-0.11875439427245436,-0.3866878383802821},
{-0.6804988105625247,-0.4226267983594743,-0.5985883043723869},
{0.15752446621966784,-0.8517030500907256,-0.49978791202705536},
{0.2062419885794384,-0.9598634390917021,-0.19006951476196607},
{0.24293870326000352,-0.9699581640144874,-0.012725820994839042},
{0.18043061355093545,-0.9803683998230776,0.07951474279636064},
{0.17040817573976708,-0.9697258266719504,0.17490818942075664},
{0.2046178040805572,-0.944533009070606,0.25688314275031204},
{0.28102772995445313,-0.9151695426872358,0.2889431140108424},
{0.397700509869963,-0.7990863434665917,0.4508828230642233},
{0.6147117763200195,-0.5445483311748346,0.5706106790695291},
{0.7996446747689456,-0.26756574303140507,0.5375657794816548},
{0.8980326935222761,-0.07514244048442079,0.43346383355843054},
{0.9249202829400639,-0.057305358938164554,0.3758171976414067},
{0.9415107638559612,-0.0560443521002234,0.33228980143999376},
{0.9511503751129327,-0.061737846401469884,0.3024919870744282},
{0.9578727475280314,-0.06890196208690644,0.2788051634451462},
{0.9637675842924234,-0.07618612046820399,0.25563199822234883},
{0.9334338324304828,-0.188776916738922,0.30506483930582273},
{0.8549410030653046,-0.34899485428104676,0.38376877538830806},
{0.6849902868393978,-0.54788634918814,0.48021750833239196},
{0.7427801834592773,-0.5228252314086319,0.4182479844096237},
{0.4428807887480991,-0.7460090784939114,0.49731987871241046},
{-0.05923129648094017,-0.8835731871517123,0.46453210487947133},
{-0.5380782201400472,-0.7823472300919376,0.31369513955174944},
{-0.801565353753589,-0.5855878889668457,0.12074687555890266},
{-0.9173415023400073,-0.3964943551245546,-0.03573226047904218},
{-0.9598988551581688,-0.239715456138911,-0.1453639843776674},
{-0.970215135919112,-0.12540720637393815,-0.20725738255353787},
{-0.9712886329972171,-0.04989035925064899,-0.23261415147028022},
{-0.9654220883255734,-0.03513558905638036,-0.25831314669360095},
{-0.9488828839399525,-0.015393199581791348,-0.3152527905862751},
{-0.9173601745907043,-0.0016418053063823844,-0.3980547883774899},
{-0.7758566093562416,-0.13098374883138553,-0.617162684598083},
{0.07033647672073573,-0.6394842331038195,-0.7655799733888898},
{0.4875449623066897,-0.7684713560536096,-0.414429348206054},
{0.37518171117357385,-0.8890552217461263,-0.2623347027878989},
{0.31149578635502023,-0.9460002824504118,-0.08974319298313928},
{0.29732566224737583,-0.9547120604686734,-0.011060387191213522},
{0.2695186176083569,-0.9622496730911444,0.03788510787190625},
{0.2447283634537526,-0.9636834649248436,0.10687472831168121},
{0.2440927784196336,-0.9517298980146196,0.1860884648452591},
{0.2996258850306496,-0.9288020156266742,0.21806224979905947},
{0.3704674931679409,-0.8539178263145462,0.3654834912935224},
{0.5425463269124399,-0.6430432332650857,0.5404987357115689},
{0.7357274577659101,-0.3455176387008971,0.5825140935941959},
{0.8583541230391879,-0.12093842226307325,0.4986001378681571},
{0.9208768520779171,0.029679235025061652,0.3887222225643823},
{0.941141910808266,0.05071393702318229,0.33418557765375617},
{0.9547314367303975,0.049243426005799146,0.29336490709340546},
{0.9629989716104826,0.03503619269861002,0.2672179744671729},
{0.9684109468833254,0.017533305156838066,0.24874247961861762},
{0.9729090933576244,0.0007439781657967778,0.2311868131155708},
{0.9775883380565409,-0.014172686586605449,0.2100480331989995},
{0.9699284354571862,-0.08351212451760673,0.22861442463267873},
{0.9454138392482464,-0.18561680935068567,0.267841506574993},
{0.8829722376485328,-0.33137731696603157,0.33248924996507334},
{0.9093574212517722,-0.31402525421337085,0.27286850336848084},
{0.8000789189990166,-0.49554140090580195,0.3381012324166834},
{0.5321715901177954,-0.7428601492172202,0.4061430750074001},
{-0.04063571205384261,-0.9324798797979694,0.358928979991644},
{-0.6036712394970456,-0.7724733823471629,0.19714438406719728},
{-0.8438202490477797,-0.5359801984038015,0.026317564780284852},
{-0.930760756817142,-0.3543148361580124,-0.09025192766640447},
{-0.9609691370446043,-0.2207294185232651,-0.16678381649947246},
{-0.9696524688258203,-0.12549493318279042,-0.20982161815560954},
{-0.9716409226410075,-0.06045302340144533,-0.22860303893639647},
{-0.9721466218352107,-0.010620989918638657,-0.2341327406142423},
{-0.9713502922728975,0.005556014312878003,-0.2375873321671673},
{-0.965055576495065,0.02873815947806566,-0.26046468564009},
{-0.9486753283225484,0.05761358263836597,-0.31095947730802054},
{-0.9087401946131801,0.07665574031142905,-0.4102623016701709},
{-0.7676960067509605,0.018575458545237566,-0.6405449192355394},
{-0.06380125618579897,-0.46495355979519887,-0.8830331743161671},
{0.49059323444409714,-0.6635793192824632,-0.5647838217745812},
{0.6575475486818713,-0.6475700569765716,-0.38507693066427945},
{0.6044312725384826,-0.7388005338375448,-0.29805470635249026},
{0.47280588574991034,-0.841094795198656,-0.2627054241731099},
{0.37067026206599546,-0.9172527717881148,-0.14577691678364924},
{0.32746650251746134,-0.9435500330682812,-0.049789806444963905},
{0.3102481946767171,-0.9505388112539925,-0.014900536892487203},
{0.30252230062481933,-0.9529852091793491,0.017304586387963443},
{0.3031061768735155,-0.9526057752988731,0.02586276103500195},
{0.29243147688199383,-0.9537616412822383,0.06944467544187168},
{0.28571598822625466,-0.949401294802902,0.13039768210542568},
{0.31830862432892,-0.9334945439632034,0.16512890742919983},
{0.3617856802569438,-0.8884731561189383,0.282358942513024},
{0.49060248193322725,-0.7404180514716845,0.45944565921970726},
{0.6760482690093121,-0.4607079067809983,0.5750712674086437},
{0.8082896435080318,-0.19998860360525725,0.5537801103557966},
{0.8928738576106264,-0.020754499883754246,0.449828328509993},
{0.932567844183219,0.10911114909875454,0.344110408354372},
{0.9442519292366179,0.13428633828809844,0.30059187194949166},
{0.9538699520410787,0.13216913216582507,0.2695615608644578},
{0.9616901813624251,0.11132241156813617,0.25051809466336084},
{0.9677561979121094,0.08481060961417572,0.23718158001744138},
{0.9729556364152862,0.05959323573959033,0.2231725247914966},
{0.9781579949871474,0.03834677612851719,0.20429503567946294},
{0.9838210458321621,0.021057308096772354,0.17791216808703197},
{0.982884405280057,-0.02756314213198426,0.1821497160389781},
{0.9763958867574748,-0.09090613266559447,0.19592638251871497},
{0.9569769525697098,-0.183138163257975,0.22506782401953124},
{0.9672979089292436,-0.18170625516023178,0.17696777168952982},
{0.9321423419328483,-0.2980838385433934,0.20556429547754942},
{0.851615287720836,-0.46669047649042733,0.2386449263514638},
{0.6299643616322362,-0.7292217002605058,0.26717150847810506},
{-0.008751663163085082,-0.9853324572314136,0.17042111699605905},
{-0.6578823352162085,-0.7523817282351284,0.03335517993340145},
{-0.8669890826833906,-0.49193776216226615,-0.07954350172449405},
{-0.9347374870450952,-0.32293628795424933,-0.14824973603669825},
{-0.9583544581603151,-0.2079256758741321,-0.1957642608765301},
{-0.9660693586651786,-0.12617890631178505,-0.22536387876102085},
{-0.968050314957157,-0.06830041573607275,-0.24127503169957057},
{-0.9683428211370247,-0.02231359464273329,-0.24862478606628843},
{-0.9677992093936854,0.01881334569104368,-0.25101941821474044},
{-0.9720525226698168,0.030979090351067065,-0.2327105264749877},
{-0.9717468509562325,0.04925708340210148,-0.23082850212086878},
{-0.9661024642836737,0.07711085092742624,-0.24637358862966804},
{-0.9506548165658378,0.11296993631532017,-0.28895192200275455},
{-0.9124383760446119,0.14694189392013518,-0.3819218372026341},
{-0.7751737899526608,0.1328288209726875,-0.6176261811884546},
{-0.12205324765319633,-0.2597103048477208,-0.9579423585441931},
{0.5371291280492798,-0.558089775751122,-0.6324777482276216},
{0.7070726052991714,-0.5419241236200448,-0.4542758799166962},
{0.7758787517227542,-0.5293581282610554,-0.3432085876971793},
{0.7177680914235871,-0.6317828033444759,-0.2926763679088838},
{0.6492712330866162,-0.720523574320777,-0.24350081054114936},
{0.5413378676193368,-0.811259961133094,-0.22093118508639772},
{0.4342703500030711,-0.8869588552373768,-0.1572044917431173},
{0.3562826761052708,-0.9311980483892233,-0.07702499194007495},
{0.3033575358435875,-0.9525992359762865,-0.022997849123374697},
{0.2907835385333807,-0.9567888618245284,-8.72154199175672e-05},
{0.28046769207418143,-0.9595405104689643,0.024897439055885935},
{0.27173311843207787,-0.9609994405606631,0.051392485727690916},
{0.29819090641286017,-0.9533429461029959,0.047110619273548086},
{0.3081080590374388,-0.9496269826332836,0.05725397637708112},
{0.3118722264550208,-0.945198951996195,0.09661602098659983},
{0.32950642608333774,-0.9340282413478354,0.1379012673417317},
{0.3564231729536807,-0.9077259401315737,0.2213507158196725},
{0.45205930330328165,-0.811270376671398,0.37078668022516625},
{0.6121363234227374,-0.6049164095978516,0.5092791562058455},
{0.7326598637736724,-0.42193169137489805,0.5340254411810934},
{0.7815636032602509,-0.28719941075737404,0.5537822970441275},
{0.8587274551668324,-0.1006807316462489,0.502444572085192},
{0.9175603639655429,0.05450897813758236,0.3938422904943261},
{0.9387221936755482,0.1746689169933813,0.29713870925432445},
{0.940626145416983,0.20501167666839384,0.2705414330330989},
{0.9449366616761429,0.20430947196506213,0.255641047341197},
{0.9524038537977857,0.17834482007102506,0.24722464364411528},
{0.960320338391706,0.14335866919082352,0.239234486726047},
{0.9676687564824439,0.10970547479570711,0.22711646027439125},
{0.9748168647521501,0.08210466900585975,0.20734247881759907},
{0.981795773269936,0.06183376580360819,0.17959299818153526},
{0.988851164301703,0.04592220641601372,0.14164930574150875},
{0.9899952886653214,0.0056015838948428156,0.14098918638795016},
{0.988599303588898,-0.040117026535367306,0.14512767181177558},
{0.9827506757803977,-0.09838396567883041,0.15659407571960882},
{0.988643809856538,-0.10858395059734809,0.10388908944168466},
{0.9758102533464141,-0.18229705430040022,0.12067366513620134},
{0.9515754069497158,-0.28072309086329006,0.12529481691053249},
{0.8991094265800507,-0.4239354351211748,0.10899993524545198},
{0.7293637148269404,-0.6814496032372327,0.06045667656813155},
{0.042898357492927246,-0.9866805599400867,-0.15691145133713513},
{-0.6888079339325733,-0.6981334467601761,-0.19532875022969864},
{-0.8721454131967314,-0.44099590137190026,-0.2118607873418006},
{-0.9276429220940983,-0.3066149795514132,-0.21322725764641184},
{-0.9496182950241405,-0.2084721048715488,-0.23401810879902096},
{-0.956482434099329,-0.13166942249460897,-0.26039300382183683},
{-0.9581237979021944,-0.07639772945225726,-0.27597495326209337},
{-0.9577068926020239,-0.03244051241657089,-0.28591103689211766},
{-0.9566721543824115,0.00959586211973827,-0.29100912092148307},
{-0.9552055617758579,0.04708211861454776,-0.29217393596834307},
{-0.966543074100127,0.054477758563744275,-0.2506524680328263},
{-0.9714263574784696,0.06625984186752548,-0.22790450928361014},
{-0.972219501471693,0.08541438375065781,-0.2179303191541462},
{-0.9675607995556346,0.12425208056547173,-0.21997163371310546},
{-0.9487605312665697,0.16251078001939478,-0.2710049827738678},
{-0.9181726820809093,0.20672233509267715,-0.3379715994786843},
{-0.7779774079407153,0.23905058052086167,-0.581038701539308},
{-0.09652948113456447,-0.0922257845444394,-0.9910481642872129},
{0.5682464813519801,-0.4309057352562994,-0.7010108299836186},
{0.7633377804699641,-0.44282179872321525,-0.4703448601640344},
{0.8232000742095384,-0.4227172686134409,-0.37901417999515863},
{0.8522609235981092,-0.4112538458298716,-0.3232979931856024},
{0.8046384862914623,-0.5170184556212831,-0.2919740107022672},
{0.7451561479181378,-0.6153279654787475,-0.2571260588108246},
{0.6748275046561909,-0.705333138117142,-0.21705529994294842},
{0.5772343795528765,-0.7934764026828608,-0.19286178845917665},
{0.477902956584826,-0.8648256339366821,-0.15390057496155718},
{0.3875812710953051,-0.9170214822987764,-0.09408697730665123},
{0.3184093850788734,-0.9470086261389641,-0.042309874876738866},
{0.2555602406241237,-0.9667770590317311,-0.005575082250232242},
{0.24607786604728346,-0.9691541057063242,0.01363830026762881},
{0.23670059333882956,-0.9709204190604112,0.03586598617913352},
{0.2275044342407946,-0.9719128988485722,0.06022499026601008},
{0.21878175970768876,-0.9720147553629054,0.08556785013074816},
{0.264326045257754,-0.961240891106855,0.07840721307695624},
{0.2951634395900117,-0.9524122491626815,0.07608844573439262},
{0.3108225550924248,-0.9469587774536142,0.08159909956226839},
{0.3145145306013887,-0.9426749434330043,0.11155519290544137},
{0.3309940578741549,-0.9308884714935585,0.1545625675653289},
{0.3523455180639449,-0.9164761432099958,0.18953657912704253},
{0.42992341601228323,-0.8601175446357441,0.274524435659393},
{0.57605465573942,-0.7066945580282923,0.41078441457062975},
{0.7179874729456074,-0.5235956136970624,0.458630158199804},
{0.7966591947587276,-0.40356571978402156,0.44996537335841785},
{0.8250408388785682,-0.2884111305059064,0.4859286305445006},
{0.8433056125092964,-0.17059601427192617,0.5096397196303024},
{0.8988255503123386,-0.025358380784415425,0.4375723741619373},
{0.9363549135740967,0.11633919699440702,0.33121694864294415},
{0.9422067467344479,0.22920424005365359,0.24436010875246206},
{0.9319508933438028,0.27339289410962203,0.23816770949491242},
{0.9299720063134242,0.27661139072305635,0.24215326963648642},
{0.9327103838889038,0.2603961855506779,0.24948981208953275},
{0.9436394131229702,0.21479152602607174,0.2518119503683808},
{0.9554987788830064,0.16415009044229048,0.24510575546255875},
{0.9685857585742876,0.12054315313638365,0.21751086528955269},
{0.9778356776571987,0.09683994822011972,0.18563246464293806},
{0.9860778478496706,0.08044695533998582,0.1455292594521401},
{0.993522202088984,0.06868293503097575,0.0905333551338224},
{0.9957069334388958,0.03191308467864022,0.08688646458456155},
{0.996144448947822,-0.01003368190485304,0.08715252181017065},
{0.9942414663757543,-0.0543807450237404,0.0923398132424633},
{0.9970022536507739,-0.07641776038048911,0.012117430161059263},
{0.9913692992938289,-0.12766673340275858,0.02980130198383319},
{0.9815042338668754,-0.18315664659786302,0.05570531131250655},
{0.9686211809284693,-0.2482000977723526,0.013027636874437495},
{0.926165696466457,-0.37043404776661504,-0.07068039999917834},
{0.7502434728097186,-0.611091620868257,-0.2523920807216806},
{0.09626563282066328,-0.8500156173080399,-0.5178864530667597},
{-0.6092904327060996,-0.61812231737378,-0.4966789399373422},
{-0.8385056571950387,-0.3815136715429562,-0.38904444640391617},
{-0.911934216077381,-0.257179673044468,-0.31974146012063115},
{-0.9389625382656113,-0.17893841557263895,-0.2938203450514513},
{-0.933711808793469,-0.139389302575091,-0.3297770162507659},
{-0.9342461560803937,-0.09226435092257401,-0.34448716869840695},
{-0.9320751377704507,-0.04585925247427708,-0.3593506177992406},
{-0.9304463812929837,0.0003410284723471159,-0.36642791274461145},
{-0.929910782121551,0.04277141091940905,-0.36528967094902715},
{-0.9307894191251245,0.07757133813301438,-0.3572306604212002},
{-0.9537095045416659,0.07892619819612999,-0.29018758792407945},
{-0.9648369210552268,0.08591767010367762,-0.2484106876376818},
{-0.9702568199331634,0.0985802036962357,-0.22109646494775462},
{-0.9721157167949166,0.1270547688660579,-0.19709926146157428},
{-0.9682144682875633,0.1658145363346471,-0.187259934152389},
{-0.9528897577319242,0.20839579809189188,-0.22039124516921751},
{-0.9068323360935113,0.283738723861041,-0.311684858145039},
{-0.7698060023751028,0.35321374182521925,-0.531637819660237},
{0.00013160794853573623,0.06411820965409153,-0.9979423018742626},
{0.6226402103579272,-0.2977400373426958,-0.7236504947891672},
{0.8060813424117037,-0.33097197420184216,-0.49060210120695663},
{0.862186959736911,-0.3280730623945166,-0.3860073991398426},
{0.8869169464909747,-0.3108877051691075,-0.3416535742558704},
{0.8965468904629273,-0.31083447829986655,-0.31557186234090234},
{0.8659022064478045,-0.4018596875533528,-0.29786265356426533},
{0.8209617794550704,-0.5009549033495705,-0.2739816444289413},
{0.7626945077761806,-0.5992340934368491,-0.24334253444674853},
{0.6919618265370596,-0.6910969554453412,-0.20874345208814707},
{0.5995267076223584,-0.7805849451150841,-0.17679047006888216},
{0.5051628733371164,-0.8504959315908583,-0.1465166944385051},
{0.4135955225845634,-0.9043990299393695,-0.10488631151265451},
{0.33468184843174426,-0.94050423692964,-0.05865015471170133},
{0.26498539275692745,-0.9639969285405315,-0.022196021938138185},
{0.18999176763960082,-0.9817672572990054,0.0060150415433803985},
{0.18352856845842533,-0.9827028794797507,0.024745003976718326},
{0.17611105462102394,-0.9832737821520625,0.046449604655463106},
{0.16816771082476575,-0.9832662919656516,0.07005012576773642},
{0.1602122797839749,-0.9825664756097315,0.0943140838596866},
{0.15276878562757987,-0.9811984137203201,0.11794647536320049},
{0.2109729312983341,-0.9712115267675082,0.11062817242146719},
{0.2583081896423464,-0.9603146484988094,0.10522668407919061},
{0.29328146678020045,-0.9502998944403416,0.1044801027465493},
{0.2981359832564963,-0.9446395851252107,0.13700726149424383},
{0.3473184478262086,-0.9207713144119308,0.17762342851020094},
{0.36835592367907044,-0.9078008703969492,0.20052803593782156},
{0.8692664499093798,-0.2992801024999378,0.39345553663606025},
{0.887211234070836,-0.19007477877623286,0.4203900624558938},
{0.8830692064701758,-0.12143441296631179,0.45325760879621346},
{0.9307400977090217,0.038290118380969025,0.3636711940076809},
{0.9505257665133261,0.16433948139539784,0.26361582283494567},
{0.9464807362939728,0.26849046386886094,0.1791286873616365},
{0.9206392881904042,0.3392167169456498,0.193275244107673},
{0.9085411448831842,0.34708318700963986,0.23256450578191046},
{0.9074768995578876,0.32473216595235255,0.2665233520063437},
{0.9249039778606691,0.25924512903810176,0.27810896211292613},
{0.9385822921930301,0.21328866902119611,0.27124016009589036},
{0.9564138713808165,0.16728727614479347,0.2393480183131141},
{0.9706776754748958,0.1342547690026402,0.19940036944474454},
{0.9822400167916547,0.11050281918646195,0.15163665904053011},
{0.9902920338154813,0.09942637280976271,0.09713950870522227},
{0.9952970094827519,0.09453616910765217,0.021137068035567395},
{0.9981563533915907,0.06022922754042642,0.007505620153299381},
{0.9998422263380169,0.017751075491182718,0.0006494230857464916},
{0.9995740530178068,-0.029097919266817547,0.002241345108760133},
{0.9906272451469802,-0.05379537107079862,-0.12555365077870045},
{0.9885640294555766,-0.11027712614743856,-0.10285968654052863},
{0.9832735414444079,-0.17099695559277345,-0.06271510084003167},
{0.9482738409516771,-0.2510877639967338,-0.1942463830753976},
{0.8031114600403536,-0.398506778900632,-0.44294957943550894},
{0.1321896853295593,-0.6129204444165332,-0.7790086109336093},
{-0.6018257415054343,-0.40019414957351146,-0.6911225792206243},
{-0.8181839015729813,-0.25860843027290953,-0.5135141507286785},
{-0.8959354479313322,-0.18208977841838137,-0.4051456352172981},
{-0.8862358708350125,-0.1215414523185321,-0.44700520870970717},
{-0.8788305413364611,-0.06591877145172069,-0.4725585627036701},
{-0.8753381836074461,-0.011139540338817838,-0.4833828451236731},
{-0.8775506599308546,0.04018127914885451,-0.47779734622628817},
{-0.8885349605747155,0.0789308959139285,-0.4519685138443973},
{-0.8917729397883475,0.11718015328370847,-0.43704672008568485},
{-0.9337537989730977,0.10681683718222251,-0.34160504416313064},
{-0.9514705985691467,0.10906196803409006,-0.2877658547969173},
{-0.9621769361421192,0.12179431956558641,-0.24368358023822653},
{-0.9683064852318839,0.13868040200915882,-0.20772649507574542},
{-0.9701162551820343,0.16994221863399103,-0.17318803006369463},
{-0.9663931142616136,0.2015404489224556,-0.15958006189958351},
{-0.9513099995929822,0.26313474326397357,-0.16052847585958926},
{-0.914373153646076,0.32451183568361414,-0.2421028797692842},
{-0.6072736325312565,0.5526713290087554,-0.5707653960463867},
{0.19440148109604322,0.19485396956627044,-0.9613740139466699},
{0.6898140382127459,-0.16957354352228507,-0.7038475730027915},
{0.8431324938023448,-0.2229893274432456,-0.48928862416885205},
{0.8910910956808266,-0.22992610347009756,-0.3912679978498139},
{0.9117958415157144,-0.225725124576599,-0.34304010192618767},
{0.9211982058660257,-0.21812436708782648,-0.3222043233598056},
{0.9019468531596702,-0.29862761857022607,-0.3119509889428849},
{0.8724592808524021,-0.3869440859031417,-0.29847793492834845},
{0.830145752955537,-0.48407330485757133,-0.276642484759939},
{0.7738278126936765,-0.5824498468895405,-0.24888288844368384},
{0.7032695753101031,-0.6767719501074733,-0.2176961919530857},
{0.6142639322185784,-0.7694397537231927,-0.1750493843627058},
{0.5232823577760048,-0.8404098861610104,-0.14102055624348783},
{0.4335394387892957,-0.8945798568092602,-0.10849163472538356},
{0.3501347043425418,-0.9339340015075682,-0.0719233595087341},
{0.27389425646136084,-0.9610142396049712,-0.037862482142052296},
{0.19508934188078553,-0.9807265922318278,-0.010747091414335677},
{0.10521539515687633,-0.9943725982082015,0.012363517082655621},
{0.10197179454568754,-0.9942701155783937,0.03207320353285081},
{0.09772616552202272,-0.9937308555968642,0.054300858253678204},
{0.092890732500658,-0.9926212535571176,0.07793817294617389},
{0.08784146173200387,-0.9909284149572324,0.10170916394864211},
{0.08293714353683931,-0.98875421705115,0.12444488131505073},
{0.07842248372271793,-0.9862970831745467,0.14514812354330087},
{0.14624292562185254,-0.9793238554464895,0.1397776550775717},
{0.20463842408189464,-0.9695890351735865,0.13423940651102495},
{0.25427416435080047,-0.9582096998840145,0.13106799911453942},
{0.25654724695902764,-0.953827403952164,0.15619472957695701},
{0.30788862261146754,-0.9373464710948564,0.16305271905869198},
{0.37141316110859307,-0.9220914532425323,-0.1086260356102409},
{0.45679579067769094,-0.8780230452432789,-0.14287455211080097},
{0.4536681196860473,-0.8825370786622607,-0.12374789681771917},
{0.3689485632542893,-0.9247962513286689,-0.09289160996041014},
{0.44654795743091036,-0.8876605189266135,-0.11248877656556334},
{0.534567014744015,-0.8323946688406001,-0.14614110316204573},
{0.5410547251084065,-0.8251666121148846,-0.16235715779943388},
{0.37120459433450537,-0.9194782576323349,-0.12948699890861995},
{0.286299517652682,-0.9528766151406264,-0.10029328247686432},
{0.2875067748294299,-0.9542487503839611,-0.08215337374586933},
{0.2861268315319913,-0.9558661471955687,-0.06671840018288004},
{0.36219282097848854,-0.9285121208260086,-0.08174106624477202},
{0.6236431784022255,-0.758839132667964,-0.18770284165164378},
{-2.818145878632049e-18,-0.999669067254134,-0.025724618077814152},
{0.10746509223980205,-0.9933663626660272,-0.040920941748180076},
{0.10780030562603579,-0.9938999269344913,-0.023281523716161396},
{1.4148570019245653e-18,-0.9999717392195857,-0.0075180291404605155},
{0.10707181628217959,-0.9942354435727804,-0.005613279048106495},
{0.19885734727385715,-0.9796502026483596,-0.027225647581511254},
{0.20105726722565365,-0.9786066354097952,-0.043646631343920404},
{0.2013790837178405,-0.9776587823199667,-0.060247572512117605},
{0.1061512255520019,-0.9926107155376996,-0.05878677328739583},
{0.0,-0.999039153097458,-0.0438265967001078},
{0.281336876552655,-0.9581619471514254,-0.052680593415273605},
{0.1997620760573196,-0.9767473321484956,-0.07784447385695253},
{0.1967753258947163,-0.9756420606860516,-0.09696411985524808},
{0.10400013877305755,-0.991574310004186,-0.07722926177885621},
{-3.045727967296762e-18,-0.9949716106107601,-0.10015734660338285},
{0.09861669520210023,-0.9882300086747329,-0.11694527515959435},
{0.10134617946388638,-0.9901569353233948,-0.09653079995035949},
{0.0,-0.9967307246674969,-0.08079518861792864},
{0.1932161536883698,-0.9740401256208633,-0.11795487117692481},
{1.588526041986108e-18,-0.9927180627158853,-0.1204609810586792},
{0.19997017254077268,-0.9674200022319002,0.15527546288980681},
{0.1408126586834647,-0.9771726279513794,0.15907686927108322},
{0.07443841606574782,-0.983773430242589,0.16324447973010486},
{0.0,-0.989514805319228,0.1444314718267816},
{-1.3725028048102015e-18,-0.9923209764805409,0.12368944836446644},
{-2.843636308262365e-18,-0.9948931730524194,0.10093351382810696},
{1.4542412156825101e-18,-0.9970231760730043,0.07710244077394086},
{1.4672195846221536e-18,-0.9985747357773791,0.05337131314795776},
{1.4602492860732693e-18,-0.9995197307887236,0.03098883289247242},
{0.0,-0.9999388797944689,0.011056069617290373},
{-1.2395982738865235e-18,-0.98670151991357,0.16254264240577193},
{-0.7630752620247531,-0.025158442303106425,-0.6458197869891689},
{-0.7704695527014785,-0.09546496057386619,-0.6302881163901264},
{-0.7891842174460717,-0.17142082933028926,-0.5897483956788246},
{-0.5016179028060468,-0.1413392369516772,-0.8534651133364392},
{-0.48818207539363706,-0.04335097320753351,-0.8716644735139324},
{-0.5700328062822689,0.044670424847868886,-0.8204066996958717},
{-0.7830949269029379,0.035196808943769635,-0.620905403502867},
{0.14864127635457022,-0.3741921365401181,-0.9153611396138827},
{-0.5408624952438251,-0.2570033690878458,-0.800885153761836},
{0.15341209396432498,-0.20377402966908434,-0.9669234066139387},
{0.7787249009771334,-0.2562061129911829,-0.5726656583593108},
{0.7567240118020716,-0.13906986715560327,-0.6387709620916568},
{0.1539898136953406,-0.07458707049904087,-0.9852532193261007},
{0.15224673752369092,0.05491638403191374,-0.9868156472605466},
{-0.5450014490808371,0.12673732916744254,-0.8288009832856684},
{-0.7931884743017404,0.09157043678881724,-0.6020522397111254},
{-0.9051194936656887,0.1536280040200644,-0.3964304965150617},
{-0.813506764082047,0.14847388884744872,-0.5622830685013307},
{-0.9297536605663985,0.1305966120417067,-0.3442421467319338},
{-0.9450998461268406,0.13976776666844756,-0.2953832294690012},
{-0.954751120694663,0.1611946774583192,-0.24993313804174452},
{-0.9628283359305649,0.17672041422109497,-0.20428286939120416},
{-0.9634535204329908,0.21601036826957992,-0.15841980547051934},
{-0.9524017771162899,0.28170113043364353,-0.11651320980103563},
{-0.9171407792794004,0.38831174597697915,-0.08981524881156996},
{-0.776351613654911,0.6216459008254871,-0.10408912509135737},
{0.7022207927493942,0.7095864471277523,-0.05807781231267203},
{0.7464533601017831,0.3055269788809333,-0.5911519655457873},
{0.48084724794839323,0.1824157864688796,-0.8576190325473173},
{0.7618492274008118,-0.06414477423280338,-0.644570556764276},
{0.8742088756761954,-0.1255530147929867,-0.4690365467267496},
{0.9129062826948726,-0.13935735045523956,-0.38364260437329517},
{0.9292228511798517,-0.1407786939339453,-0.3416522386571465},
{0.9360731310019464,-0.13776524868042211,-0.32370948344500844},
{0.9232320322907894,-0.20955973472616823,-0.3220672788932723},
{0.8327515721703932,-0.46602765655272327,-0.2989030651828709},
{-0.8519923030970643,0.19661221794066194,-0.48523473826573227},
{-0.6091162873256092,0.20897410749814593,-0.7650537045920497},
{-0.6894630612607959,0.29556295725963405,-0.6612739413078604},
{-0.8870504049019545,0.2468805570065092,-0.39011737943269637},
{-0.9278328628556982,0.17733835672742423,-0.32814217320883315},
{0.1482900628537038,0.18819069210998818,-0.970872968344473},
{0.7928368131858877,0.13846098180724742,-0.5934967094889565},
{0.8350155543041905,0.22499874075829013,-0.5021200959205369},
{0.14161685083595768,0.330026821154688,-0.9332882539054255},
{0.9694998987261373,0.21207207576884013,-0.12286326159232779},
{0.9624591245447185,0.16249856205755614,-0.21740894855051543},
{0.9573373492797584,0.1043138010098274,-0.2694880898906074},
{0.9891715385750994,0.13149812450695217,-0.0651759965334262},
{0.9856239349816399,0.16810786767381225,-0.01688797256843966},
{0.978943917167567,0.19435327761489832,0.062414826131022734},
{0.964374184125351,0.2642926609101408,-0.01148139284236879},
{0.8768996603593112,0.3156108821962628,-0.3625420757664158},
{0.12684213019348434,0.5292342198469124,-0.8389411269874717},
{0.9919341061226801,0.09349038993552639,-0.08559366857602825},
{0.9913489099979347,0.05406617507758943,-0.11960011437446984},
{0.9537096335331678,0.04651017247306086,-0.29711065070535053},
{0.9912780989650588,0.001995922853066842,-0.1317715705460924},
{0.9435456733259967,-0.0878650559816973,-0.3193764147289598},
{0.7492357217917623,-0.038576387254820196,-0.6611790192811197},
{0.9426631057065328,-0.015945484496284475,-0.33336468118847434},
{0.8144835719794007,0.05342903612233896,-0.5777212555157671},
{0.9469263886496408,-0.16468068509959216,-0.2760628305912954},
{0.9391222383682314,0.28907156473153095,-0.18570689773378693},
{0.9229305318898992,0.3591173121680184,-0.1386866590795451},
{0.9389216458620354,0.30544694518637433,-0.15851910486764173},
{0.9463346501816362,0.24036269665420398,-0.2160474575705986},
{0.9452534992603627,0.2677579005349495,-0.18655167873046774},
{0.9389451352353542,0.3193127846884033,-0.12814592678817324},
{0.9218931996305844,0.3710554976799583,-0.11149325592322529},
{0.893262969328457,0.43948008487858287,-0.09454376035266317},
{0.8949631263859046,0.42895826528428255,-0.12262058984471638},
{0.9232177249285232,0.3471824542282071,-0.16472211707563955},
{0.9392230795624747,0.272190652544838,-0.20921820065280272},
{0.9470290896075101,0.2156526965916133,-0.23797020378597028},
{0.9474923458248133,0.15944324800320642,-0.27719326339141115},
{0.9431253897413525,0.19767795984399253,-0.2672787373083363},
{0.9378283266008938,0.2511153947353079,-0.2396228043235825},
{0.9465540090143416,0.28936111339697174,-0.14249790901112366},
{0.9393068466242744,0.3294302913419302,-0.09580360656641657},
{0.9201743384613756,0.38249896753101975,-0.08350884189637466},
{0.894473319522462,0.4410884422030809,-0.07320154928228394},
{0.8485655079047567,0.5263563376936509,-0.05371763736492451},
{0.8497089398571199,0.5204083954937765,-0.08467478624999476},
{0.8562063679584011,0.5036999467104663,-0.11487827971969533},
{0.8950493236884395,0.4200122532613299,-0.14992136363843325},
{0.9226176110697384,0.3359904558234487,-0.1894390596986799},
{0.9388655671126723,0.2576537621635385,-0.22835495556955845},
{0.9479425767989789,0.19586926896437662,-0.2510778774943601},
{0.9504816587633018,0.1358229894345903,-0.2795294830525278},
{0.9475565748748679,0.07547355207163757,-0.3105483542849625},
{0.9389283668077617,0.10163393165250414,-0.32876141187883284},
{0.9219075539872438,0.15510422276972805,-0.35500583372707484},
{0.9136193786883634,0.2338817427803496,-0.3325642212853258},
{0.9419856034107251,0.29057501584182055,-0.16801572288169325},
{0.9546774650046499,0.28564965988679064,-0.08363736975094527},
{0.9506904435125669,0.29638850305141445,-0.09133200902651994},
{0.940914638962044,0.3328669942907818,-0.062283274630892595},
{0.9178635321479013,0.39295583578867316,-0.05578752076050488},
{0.8871631441429951,0.4593219797081189,-0.044326906403779606},
{0.8380351085695006,0.5451876674779778,-0.02162322905643787},
{0.7775511823399165,0.627868492973909,-0.034573318794562005},
{0.8499711596724869,0.5080404708098393,-0.13944141330438575},
{0.893666330524047,0.4125752504550567,-0.17647139258143765},
{0.9209059946067337,0.3266565676197954,-0.2126679005591501},
{0.9367125391315456,0.24754640593369398,-0.24756897209271486},
{0.9474324442988706,0.18251365353078425,-0.26279370191218865},
{0.9520026809419817,0.12114922445070539,-0.28109386491752497},
{0.9518178844059597,0.06149132946874266,-0.30043556934079796},
{0.9479430466951997,0.0013390600029785126,-0.3184371007601515},
{0.9401636480264488,0.012447934389709602,-0.34049576188115593},
{0.921877692267599,0.03671302412828848,-0.3857378311220222},
{0.880624579496771,0.0937389466043197,-0.4644495234959854},
{0.9123867340440077,0.352557723762625,-0.20797475557342499},
{0.9542474520201996,0.2937942206090028,-0.05564850626661602},
{0.9656124672489311,0.25991722624350544,-0.005966455841977759},
{0.9623095569997979,0.26859452072366047,-0.04262980112643929},
{0.9553514256980041,0.28989126872455273,-0.0571551024324162},
{0.9565553211674962,0.2901205688483844,-0.02884394351051916},
{0.9395492136695317,0.34111145897622164,-0.02983701808288279},
{0.9151364799326419,0.40210219916788237,-0.02896626522087403},
{0.882084446236508,0.47071903387626524,-0.018724872609136963},
{0.8318189068018931,0.5550406485056913,0.0026804464712204775},
{0.7724201872797364,0.6350810263981549,-0.006256531930946242},
{0.8908884341268927,0.40665761690491786,-0.20235459113186974},
{0.8478751865026042,0.502870894057034,-0.16801348762362334},
{0.9175172574646729,0.3198492827049213,-0.23634406827261895},
{0.9322653867488355,0.24090078983560173,-0.26990379420568944},
{0.9440835697799371,0.17446028743875777,-0.27976744159811845},
{0.9501191078453781,0.11283196215194126,-0.2907621523239326},
{0.9518082581759721,0.054108492901690425,-0.3018829419889929},
{0.950095135335059,-0.0037399907026836915,-0.31193788850057935},
{0.9451895011174402,-0.06632143069304836,-0.319715928299157},
{0.9407545493003118,-0.06498903227538745,-0.33280219899314945},
{0.9288743454035617,-0.05847691847228867,-0.3657497784785248},
{0.8999032620275053,-0.039541848152174895,-0.4342931742923961},
{0.8260625092120272,0.01746302369873716,-0.5633078853323704},
{0.9363014181055828,-0.1331873022387354,-0.3249627624449336},
{0.8443475044169068,0.4988370048996354,-0.19554778016562244},
{0.839817772334841,0.49526443856729213,-0.22230439752998604},
{0.8867230876931996,0.4020097043646549,-0.2282769444084984},
{0.9124347784489618,0.3146491732454291,-0.2616460831978224},
{0.9255978024424721,0.23616529536914216,-0.29579496509723124},
{0.9378937701418301,0.16990304714204926,-0.3024702142376848},
{0.9448507754197105,0.10887709272463436,-0.30887342208193164},
{0.9477822992031115,0.05117404445410063,-0.31478553094364603},
{0.9474441019909474,-0.005155081242126207,-0.31987981921333275},
{0.9439121363109773,-0.06517740454514251,-0.32370014652700685},
{0.9058846660071702,0.3096963637031911,-0.28889640738870104},
{0.8756228823779031,0.3923344356288622,-0.2817059787721861},
{0.8301368479964706,0.48541039112492396,-0.2743165430418531},
{0.8264784465807805,0.476392092703294,-0.2999732510528164},
{0.9126682297813582,0.4058260254742164,0.0483935883724543},
{0.9350854271793927,0.3466505874428282,0.07381472822055758},
{0.9394281466367418,0.3391746196141704,0.04934911059217982},
{0.9380527345909013,0.3456669881897066,0.02390398298169723},
{0.959068604539719,0.27850216909040154,0.05122454097576069},
{0.9584389154486463,0.27501443646734075,0.07590721367678613},
{0.9038578849320057,0.4206098819897615,0.07828314645439274},
{0.8717269519752003,0.4868244908424736,0.05562406238304644},
{0.9096392944973405,0.4147946139073461,0.022400495080160125},
{0.9390116840413368,0.34387001762912095,-0.0032354612655206816},
{0.9589895172494393,0.28233758870618547,0.02499183485188684},
{0.9739850383432096,0.21709100920699972,0.06499722151802115},
{0.9745363712290459,0.20709170262640456,0.08597608885626418},
{0.9745249738225621,0.19894147102181234,0.10355368899180689},
{0.8727990995247537,0.4872983842607549,0.027604647536907806},
{0.8263940726339144,0.5626131015497152,0.02322358026107521},
{0.8226247492762806,0.566874124588857,0.04407095131436805},
{0.819909939267913,0.5682174199089839,0.06983305235821151},
{0.8770241361708978,0.480424102719837,0.004620183928151488},
{0.9123102598423638,0.40948309475322453,-0.0036857696184720025},
{0.9874955996164979,0.08462681892815456,0.13300654967389722},
{0.9827404242342704,0.16207934677782135,0.08917142997575472},
{0.9840598805879819,0.1436111787513496,0.1048903272700335},
{0.9726861433624746,0.22835980414296017,0.04163491758637677},
{0.9806550313193033,0.18281867815122815,0.0699502713874214},
{0.9857899148329313,0.11324092174837544,0.12407553125117109},
{0.9850201117131269,0.024616639620129898,0.17067337394705626},
{0.9581356036912181,0.28631260942953357,-0.001120098619001379},
{0.970441834122122,0.24070121053828572,0.017480670213000035},
{0.9672080779609972,0.2537909853244511,-0.009933262054219918},
{0.9774670354469747,0.20544068451297043,0.048500719183792035},
{0.9734298536970126,0.2187019986462626,0.0678509817139192},
{0.9729101403837764,0.23003862396532546,0.02298021371876503},
{0.9793585373132357,0.1803870400434461,0.09119962267489534},
{0.9630977313548,0.2656802731929428,0.04309004868134565},
{0.9424112896392892,0.3344426222910559,0.003015552270151677},
{0.9547014390752936,0.2780451359824522,0.10600030464136916},
{0.9691507516515403,0.21214531686434468,0.12546387968567405},
{0.9764632967666539,0.15850207750140022,0.14627549861592562},
{0.9806291948963201,0.10961868349541108,0.1623272199778214},
{0.9832474044421651,0.1453914798309098,0.10993570507493679},
{0.9832772708247254,0.06455076302458286,0.17029095006025344},
{0.975173044782558,-0.042712250375015616,0.2172859783727825},
{0.9227749654678226,-0.20493710009005772,0.326323686104053},
{0.9545757508805985,-0.056044199124287375,0.29265027520106407},
{0.9553531545866577,-0.11883706710448076,0.2705145125558461},
{0.9737809430165622,0.008862464687130301,0.22731504951816178},
{0.9717018333322317,0.0672313855143757,0.22644091481134151},
{0.9540038372792756,0.015546616961343771,0.2993910171622966},
{0.9226871235489305,-0.13252351568346588,0.36205799235467095},
{0.9684856903327048,0.12971563563211566,0.2126248374328371},
{0.961375001698593,0.19574932359485836,0.19349498293543835},
{0.9537510349885735,0.09091198126938192,0.28652046160771905},
{0.8531413774210277,0.4775512446167327,0.20998713983756526},
{0.9140564164098718,0.39312856544216973,0.0997536899233538},
{0.8461665905037563,0.4407809048663142,0.29952344652878427},
{0.9232851784807956,0.24959491792044405,0.29197064260978733},
{0.9475076237445792,0.1961392278732668,0.25250486378519477},
{0.9632231879820761,0.16837595178147707,0.20940541777931118},
{0.977571173773047,0.14067793645835228,0.15673008135583602},
{0.9863094420949323,0.12827005492483107,0.10363627474955114},
{0.9914788107874474,0.12356544733145303,0.04124739973970454},
{0.9884718001978963,0.14589811374703293,0.04046283008624546},
{0.9825972452594176,0.15760856497993872,0.09829645900828995},
{0.9706801583998079,0.18028392723819217,0.15898973447521045},
{0.9637478696390888,0.2310194394263239,0.13349180638999955},
{0.9454461869333979,0.31062429333947705,0.09820415470054696},
{0.8785116253397334,0.4773168169457614,-0.019646383985520634},
{0.8606502447473806,0.44453255274589637,-0.24833840976677554},
{0.10460232334397356,0.7149242090700427,-0.6913332982264173},
{-0.7130390393359282,0.42157774199802156,-0.5602209705417553},
{-0.8076081447418587,0.458814378698615,-0.3704840758332496},
{-0.9104722746160157,0.2926903903471902,-0.29218585276147047},
{-0.9401339118618571,0.21146590056659145,-0.2672646640782922},
{0.6081203660649747,0.6907711137390342,0.39118395774972115},
{0.9010224682844502,0.32699039907041,0.2850189301824895},
{0.8333788235958646,0.4699898796028617,0.2908423102866231},
{-0.041817518281615555,0.960129266905884,0.2764110815353404},
{0.621106026805004,0.7405568491597455,0.2565206748570017},
{0.914533914413684,0.3558462375226042,0.19235689389307203},
{0.9425070148347919,0.25900580247744937,0.2111788845273638},
{0.9522135641362711,0.21185832467575486,0.22001222361605707},
{0.9302982420349177,0.24830057907861147,0.26998519088269973},
{0.8173692588161227,0.4505515294406413,0.3590415213608049},
{-0.07016086689914008,0.9283174920706607,0.3651083218328501},
{-0.7160000489744223,0.6917755737118687,0.09375758894212098},
{-0.8850924734841272,0.4564382174863476,-0.09096959381922692},
{-0.6687891740397693,0.7430348401007366,-0.02490516178778807},
{-0.009838698004898035,0.9966663396427532,0.08099016881501576},
{0.8177631676200657,0.5598737939090287,0.13343439053672215},
{0.889519020719738,0.3235782312306272,0.3225725345584418},
{0.6107268111055141,0.6792673471320543,0.4069504064589088},
{-0.7470829097133195,0.6604940389627791,0.0749316389045042},
{-0.9043759129811391,0.4245149491210182,-0.04348868809599289},
{-0.9443953537735817,0.3018437470726396,-0.1304138340975366},
{-0.9507516190605438,0.23670999964008174,-0.2000993126528601},
{-0.918745496194877,0.33830166179798266,-0.20361409294631946},
{-0.8080792521166071,0.5483776883833992,-0.21515072201120866},
{0.023052921198549924,0.9895577614093436,-0.1422814100954234},
{0.07006733198684625,0.8845895565325255,-0.46107687586977864},
{-0.08888960055630708,0.9486705871149678,0.3035173076710493},
{0.6621897859006917,0.6739871937032558,0.32748427469545177},
{0.8907429096356188,0.328231034999656,0.31439061149615555},
{0.062536948586778,0.7581477221461279,-0.649077161411563},
{0.19069101097725025,0.7065164839700857,-0.6815213835317436},
{0.09461374356194938,0.7237191456174402,-0.6835779676057121},
{0.0,0.7585671244618853,-0.6515949030537505},
{0.0,0.7236949252459633,-0.6901200295406876},
{0.14033135917926678,0.6665446940059225,-0.7321374737871643},
{0.2699397140113602,0.6403181952218415,-0.7191141492609562},
{0.1367076844342104,0.7475245796783899,-0.6500138550779382},
{0.044513409822669416,0.7727777630475464,-0.6331138012120644},
{0.0,0.7744131514468983,-0.632680227971511},
{-0.062536948586778,0.7581477221461279,-0.649077161411563},
{-0.09461374356194936,0.7237191456174402,-0.6835779676057121},
{-0.14033135917926678,0.6665446940059225,-0.7321374737871643},
{0.0,0.6667379253413597,-0.7452922506718418},
{0.21118293865713048,0.7517920449733649,-0.6246683020090781},
{0.21480442372608552,0.745591690087311,-0.6308344404203465},
{0.23961383504959888,0.7317149906795465,-0.6381053067226874},
{0.11501327787668782,0.74679776515935,-0.6550305671226802},
{0.1025470211865977,0.7609895602287623,-0.6406083028408158},
{0.10232786052485504,0.7678290942856356,-0.6324298308341461},
{0.19637892667476736,0.7509977168830355,-0.6304266383922354},
{0.3207769456396804,0.7199972517149401,-0.6153910209525411},
{0.1104307202454865,0.7653283298479108,-0.6340958946076456},
{0.22032975313027392,0.7325000571508585,-0.6441261259718795},
{0.03642655519557998,0.7735106910293942,-0.6327355821666841},
{0.0,0.7759608556867135,-0.6307810637946762},
{-0.04451340982266942,0.7727777630475462,-0.6331138012120645},
{-0.1367076844342104,0.7475245796783899,-0.6500138550779382},
{-0.19069101097725025,0.7065164839700857,-0.6815213835317436},
{-0.2699397140113602,0.6403181952218415,-0.7191141492609562},
{-0.3555831119826213,0.5582006691282666,-0.7496483598711532},
{-0.1928975268777237,0.5900356775437721,-0.7839951806930445},
{0.0,0.7337506220346328,-0.6794188874794322},
{0.03760290175469773,0.739041869081012,-0.6726092011895696},
{0.0,0.7417570629903416,-0.6706686659625171},
{-0.03760290175469773,0.739041869081012,-0.6726092011895697},
{-0.03278946549302901,0.7520255471917062,-0.6583178771108197},
{0.0,0.7553735162305838,-0.6552944765351255},
{0.03278946549302901,0.7520255471917062,-0.6583178771108197},
{0.1259754827135578,0.7347442362270181,-0.6665441358876859},
{0.12210812461409107,0.7293339477072448,-0.6731727851190923},
{0.03476800379391861,0.731834780752988,-0.6805946220713267},
{0.0,0.72949566646951,-0.6839854330336321},
{-0.03476800379391861,0.731834780752988,-0.6805946220713267},
{-0.12210812461409107,0.7293339477072448,-0.6731727851190924},
{-0.1259754827135578,0.7347442362270181,-0.6665441358876859},
{-0.11501327787668782,0.74679776515935,-0.6550305671226802},
{-0.1025470211865977,0.7609895602287623,-0.6406083028408158},
{-0.033435596105146924,0.7655354202399374,-0.6425243818495573},
{0.0,0.7685419777964807,-0.6397993657113717},
{0.03343559610514693,0.7655354202399374,-0.6425243818495574},
{0.13064226849268804,0.7256266037544329,-0.6755728159176416},
{0.299896014420034,0.7038596400498295,-0.6439285578726132},
{0.2759459199169611,0.7090028475051365,-0.6489752009983047},
{0.25578127914187593,0.7151081961466305,-0.6505353219037826},
{0.48713015683604977,0.6551261701778913,-0.5775066332510251},
{0.5268856975867383,0.639095085774841,-0.5603114607225029},
{0.3271894612441766,0.6988833974525868,-0.636010261879378},
{0.14126323576727906,0.7243374231939159,-0.6748184908413195},
{0.04297136339531694,0.7290348266369714,-0.6831264037338541},
{0.0,0.7314974000505474,-0.6818442298056715},
{0.04474372575000632,0.7344541305802639,-0.6771817548336612},
{0.041386784190095095,0.7307371865968518,-0.6814031833055375},
{0.0,0.7292159778602993,-0.6842836090637036},
{0.03854430008718552,0.7289035025028573,-0.6835305559884328},
{0.15380177165649903,0.7248204423060671,-0.6715506990917062},
{0.16769966160347538,0.7266338167886953,-0.6662432887445643},
{0.18147325272080414,0.7296090979095667,-0.6593466635955014},
{0.048234686026584504,0.7397783803670275,-0.6711194848947946},
{0.0,0.7356816439447375,-0.6773274826572213},
{-0.04474372575000632,0.7344541305802639,-0.6771817548336612},
{-0.041386784190095095,0.7307371865968518,-0.6814031833055375},
{-0.038544300087185526,0.7289035025028573,-0.6835305559884328},
{0.3565564841814838,0.6935937541085272,-0.6259354422380785},
{0.3853140230257986,0.6881590027685582,-0.6147928842856409},
{0.40933396140727263,0.6836886742634746,-0.6041651303430894},
{0.1929939915320702,0.7338492536042018,-0.6513206523802811},
{0.05115527270546824,0.7465522853920821,-0.6633572365251534},
{0.0,0.7415089654909056,-0.6709429588993442},
{-0.048234686026584504,0.7397783803670275,-0.6711194848947946},
{-0.18147325272080414,0.7296090979095667,-0.6593466635955014},
{-0.16769966160347535,0.7266338167886952,-0.6662432887445642},
{-0.15380177165649903,0.7248204423060671,-0.6715506990917062},
{-0.14126323576727906,0.7243374231939158,-0.6748184908413195},
{-0.04297136339531694,0.7290348266369714,-0.683126403733854},
{-0.13064226849268806,0.7256266037544329,-0.6755728159176416},
{-0.2759459199169611,0.7090028475051365,-0.6489752009983047},
{-0.25578127914187593,0.7151081961466305,-0.6505353219037826},
{-0.23926507197872704,0.7233046289674733,-0.6477519888392781},
{-0.23961383504959896,0.7317149906795465,-0.6381053067226874},
{-0.21480442372608555,0.745591690087311,-0.6308344404203465},
{-0.21118293865713048,0.7517920449733649,-0.6246683020090781},
{-0.10232786052485504,0.7678290942856356,-0.632429830834146},
{-0.036426555195579975,0.7735106910293942,-0.6327355821666841},
{0.744068889487511,0.5170335793023942,-0.42312854497253777},
{0.7024223594692941,0.5505326937371736,-0.45112812153985826},
{0.8588413583302362,0.41359181211854495,-0.30221405356133424},
{0.8876961626945005,0.36815167395603304,-0.27651377488441625},
{0.7814281651212239,0.48080529322091486,-0.3977389756687511},
{0.5681230612861639,0.6201490552545514,-0.5409725838725334},
{0.6071065349285552,0.5992987544618551,-0.52178794365864},
{0.6387936281540236,0.5794396134985372,-0.50615455637432},
{0.6591683279668161,0.5657731264234247,-0.49537650814556744},
{0.42439212581874697,0.6823114227767154,-0.5952667014804868},
{0.1998153438990455,0.7392651284643057,-0.6430870066943971},
{0.045180875391780305,0.7547728937489261,-0.6544284279894211},
{-5.2102921787094565e-20,0.7488033579844354,-0.6627922231523492},
{-0.05115527270546824,0.7465522853920822,-0.6633572365251534},
{-0.1929939915320702,0.733849253604202,-0.6513206523802811},
{-0.4093339614072726,0.6836886742634745,-0.6041651303430893},
{-0.3853140230257986,0.6881590027685582,-0.6147928842856409},
{-0.35655648418148383,0.6935937541085273,-0.6259354422380785},
{-0.3271894612441765,0.6988833974525869,-0.636010261879378},
{-0.299896014420034,0.7038596400498295,-0.6439285578726132},
{0.9378283009735029,0.2518459874049312,-0.23885492777246214},
{0.8456365652850032,0.3978688719959871,-0.35580775729264713},
{0.6703117595922545,0.5593261348306222,-0.4876847545779673},
{0.6758265807181496,0.5585098752308725,-0.48096273459012356},
{0.8502684677114979,0.39504068064625225,-0.34783098402828794},
{0.6792255615190171,0.5613097552408889,-0.4728466931792897},
{0.4333185855367221,0.6893982082183369,-0.5804869627595448},
{0.4315174094232838,0.684337942072589,-0.5877706239720318},
{0.8394316655706946,0.4054523737859649,-0.36188789898052104},
{0.4326267192234518,0.6968459625119061,-0.5720487971710171},
{0.20113589024547934,0.7529814643716474,-0.626548695607842},
{0.20215998046515185,0.745555622129159,-0.6350418542190207},
{0.051686970606880475,0.7626689726569547,-0.6447204783593188},
{0.0,0.7706480623428295,-0.6372609857878029},
{0.060669131706016996,0.7695398594582038,-0.6357103594901423},
{0.19810735607458047,0.7617166292122296,-0.6168802576276032},
{0.048938584449471016,0.7779371039460746,-0.6264334579634744},
{2.171449877718281e-20,0.7808155366913238,-0.6247616326739663},
{-0.048938584449471016,0.7779371039460746,-0.6264334579634744},
{-0.06066913170601699,0.7695398594582037,-0.6357103594901424},
{-0.051686970606880475,0.7626689726569547,-0.6447204783593188},
{4.85741662636047e-20,0.7613937393722414,-0.6482897297079103},
{0.1944165614650102,0.772003762160712,-0.6051548494706364},
{0.19100220589479486,0.7843919695583519,-0.5901248981662202},
{0.04582900340872673,0.787953608554461,-0.6140267202757271},
{0.03825618395648689,0.8149746686843043,-0.5782324392422098},
{-1.7749765806505852e-19,0.8033743842304055,-0.5954742637280109},
{-3.813873016371999e-19,0.8188870396036656,-0.573954716305341},
{0.034696191633859785,0.8346350396218383,-0.5497094913875499},
{0.0,0.8394107736141723,-0.5434975189827982},
{-0.034696191633859785,0.8346350396218383,-0.5497094913875499},
{-0.038256183956486896,0.8149746686843043,-0.5782324392422098},
{-0.04215972550578693,0.799978883788891,-0.5985451888012772},
{0.0,0.7910359338986013,-0.6117696881026126},
{0.04215972550578693,0.799978883788891,-0.5985451888012772},
{0.1889540616997841,0.7997576154178512,-0.5698105993646544},
{0.18965984954229306,0.8196542303695281,-0.5405516479569101},
{0.19499173385161947,0.8488015649659859,-0.49144086830546807},
{0.0332013626875009,0.8648312045044266,-0.5009637284585737},
{0.0,0.8724667641719263,-0.4886734547889506},
{-0.0332013626875009,0.8648312045044267,-0.5009637284585737},
{-0.19499173385161947,0.8488015649659859,-0.49144086830546807},
{-0.18965984954229306,0.8196542303695281,-0.5405516479569101},
{-0.1889540616997841,0.7997576154178512,-0.5698105993646544},
{-0.19100220589479486,0.7843919695583519,-0.5901248981662202},
{-0.04582900340872675,0.7879536085544611,-0.6140267202757272},
{0.2098820637947928,0.8923007074490387,-0.39968608530093164},
{0.03714806740620012,0.9118684867828926,-0.40879809674246537},
{0.0,0.9225312643664204,-0.38592235782148426},
{-0.03714806740620012,0.9118684867828926,-0.40879809674246537},
{-0.2098820637947928,0.8923007074490387,-0.39968608530093164},
{-0.4991636374961627,0.7962826886800394,-0.34171558745554304},
{-0.47320470462001263,0.7662743973582119,-0.4346272603953825},
{-0.45246557805436294,0.7458319380937583,-0.4888861020679965},
{-0.43961208971553106,0.7301722463216319,-0.5230580285948835},
{-0.4337092126547899,0.7171467632152648,-0.5455243705539021},
{-0.1944165614650102,0.772003762160712,-0.6051548494706364},
{-0.12227906829512282,-0.9587749705645282,0.2565119593232738},
{-0.06640108510545678,-0.9630528179617107,0.26099840174381533},
{-0.04680347832905465,-0.9238870184997071,0.3797923267576949},
{-0.09509304701368995,-0.8961023955822388,0.43354101194861006},
{-0.10399731481711798,-0.9220800171799277,0.3727640009822484},
{-0.05433280222394629,-0.9432172389100864,0.32770289413632947},
{-0.11134649242346917,-0.9390632674740411,0.3252109135714359},
{-0.16089853402116822,-0.9157174549730582,0.36820266757249853},
{-0.147887708805142,-0.8915458396331918,0.4281065771710504},
{-0.13303578778869415,-0.8589273922775111,0.49451513016569676},
{-0.08510834743022463,-0.8615148915392374,0.5005483601549726},
{-0.04567707995970879,-0.8923447367391707,0.44903727593625725},
{-1.1458623485675803e-18,-0.9551852591999644,0.29600864954777345},
{-0.057617663966722577,-0.9554764673480561,0.2893871544196404},
{-0.11735592836983168,-0.9506263482869489,0.28729276360374156},
{-0.17139008419496096,-0.931259897726245,0.32152829102047564},
{-0.22260871897926554,-0.905047456658223,0.3624009649971871},
{-0.20573454000574104,-0.8833657310652865,0.4211155236133167},
{-0.18613726875779837,-0.8535150919790385,0.48668768727326606},
{-0.1657073522335083,-0.8200726687709907,0.5477425411181653},
{-0.11783804405754424,-0.8228933537061631,0.555842355168186},
{-0.07509994247223703,-0.8237331060614993,0.5619820002624117},
{-0.04056067820469684,-0.8559293145334159,0.5154996022364439},
{-3.9759400032726937e-19,-0.8687057086198195,0.4953285695488775},
{0.04056067820469684,-0.8559293145334159,0.5154996022364439},
{1.3457818722089504e-18,-0.8299487051167589,0.5578397143221476},
{-0.035600085773598994,-0.8168262445793982,0.5757842652063612},
{-0.031218877214769673,-0.7771935752982481,0.6284866969320635},
{-0.030581240982221366,-0.7422034079448472,0.66947657833194},
{-0.025388863248991946,-0.7121847123318418,0.7015328510795028},
{0.0,-0.7067061060574239,0.7075072294055752},
{0.025388863248991943,-0.7121847123318418,0.7015328510795028},
{-0.17959771298251806,-0.9417199867919829,0.2844435409144609},
{-0.2358194831882796,-0.9186051739369487,0.31710204314239426},
{-0.2455786107846159,-0.9276027043578864,0.28150376337277255},
{-0.18578384802730302,-0.9490821705770484,0.25441579216889504},
{-0.2519702708677774,-0.9340478922038828,0.2531116703518479},
{-0.3168358202465159,-0.9064474241474413,0.2792277390682849},
{-0.3061046345407465,-0.8992742858109907,0.31241912808246697},
{-0.29062559645148506,-0.8882350530784372,0.35577416034608883},
{-0.3227850819257398,-0.9118278242004412,0.2537317676210109},
{-0.39550154460392645,-0.8754538285011998,0.27777530915922033},
{-0.38384465283696717,-0.8706008227138591,0.30776206715321425},
{-0.3664711137174199,-0.8626218327166965,0.3486868172604197},
{-0.34305300738478395,-0.8478857907422493,0.40423300209365154},
{-0.2702556168486733,-0.8697150307498966,0.4129862792508356},
{-0.24613829644309615,-0.843415377303223,0.4775630223882001},
{-0.2205391650222147,-0.8134482448876281,0.5382048212163673},
{-0.1951255148197952,-0.7808003102344392,0.5935291981057995},
{-0.14594903413873103,-0.7844316280223035,0.6027983911659435},
{-0.10351474359853413,-0.7851787573559953,0.6105563175126637},
{-0.06588361485042603,-0.784714300695657,0.6163463438505713},
{-0.48280902881242393,-0.8308747692603771,0.2766632601263114},
{-0.5649663471721066,-0.7694263334402588,0.2979868184529084},
{-0.5789907676749834,-0.7676500213502006,0.2747419437730069},
{-0.48968561238819786,-0.832311610721495,0.259740993449602},
{-0.5880303240030089,-0.7652195139893782,0.2620294515179089},
{-0.6839752637952535,-0.6785885036771189,0.26776011875083633},
{-0.6599367817710121,-0.6925252847507815,0.2913626160758592},
{-0.6397647768481545,-0.695881386617402,0.32626695521286436},
{-0.5451158023822193,-0.7689075468427675,0.3341106798673554},
{-0.47011111619013474,-0.8289327360243429,0.3030941398009247},
{-0.4014793476292028,-0.8792784690368073,0.25628832848086924},
{-0.6908882719476597,-0.6748834128183693,0.2592407660608325},
{-0.773951077799426,-0.5809101867548929,0.252077535884304},
{-0.7712951721034607,-0.5816914114932709,0.2583386523245394},
{-0.7528058348972826,-0.5958787587799544,0.2796638692778638},
{-0.7250292395824431,-0.6109293311840265,0.317959044610375},
{-0.6979985167982722,-0.6127467516749125,0.37059342797634054},
{-0.6120255427036906,-0.6943205404285198,0.37860760982487024},
{-0.5177492971233479,-0.763043516882572,0.3869111741365906},
{-0.45126823681059114,-0.8244907789371808,0.34142632278929685},
{-0.058182847793966354,-0.7468420313579234,0.6624513087161612},
{-0.05256567392082547,-0.7129075406898855,0.6992851266491721},
{-0.04924824399881804,-0.6861992012824214,0.7257446290689307},
{-0.02402005068414769,-0.6861962843702031,0.7270197359643398},
{-0.04779599049519869,-0.6730247458347045,0.738074003597684},
{-0.023539082725367495,-0.6720937917490041,0.7400917826032759},
{-0.02342741829331417,-0.6756375109455162,0.7368616626446634},
{-0.049352434335448954,-0.6829713982259777,0.7287759644982936},
{-0.024170837292793495,-0.6873569709067388,0.725917464434131},
{-2.778858212930008e-19,-0.679243864240371,0.7339126466356934},
{-0.04796796866665748,-0.6709600548639543,0.7399403210793111},
{-0.07391131835304415,-0.6686297431130638,0.7399130919532869},
{-0.07673179380113453,-0.675644394084006,0.733223625207833},
{-0.08459078522087823,-0.672179987518974,0.7355395729902688},
{-0.05420377799382536,-0.6831727508461836,0.7282423655298107},
{-0.10632555150791155,-0.6853140760459632,0.7204439563698251},
{-0.08189871982983053,-0.7138440941264765,0.6954992515962798},
{-0.07620897823013802,-0.6860805163867235,0.723523127945227},
{-0.10297035625051029,-0.6657264679139605,0.7390570855167046},
{-0.07397415875108038,-0.6689969575202657,0.7395748066731979},
{-0.09120276789738045,-0.7479576366975442,0.6574507044894553},
{-0.11488007233673918,-0.7143567583469739,0.6902876145375264},
{-0.13988132651720636,-0.683440419287147,0.7164791746983267},
{-0.1342935425212642,-0.6609930736321155,0.7382773198788232},
{-0.13491795140201504,-0.653328238323448,0.7449559446025406},
{-0.10327156527863335,-0.6621181426816083,0.7422496540496051},
{-0.1683269925630603,-0.6424466428353376,0.7476150979509976},
{-0.17897587993658864,-0.6347538166985734,0.7517015542005467},
{-0.14210415777357807,-0.6515246485442959,0.7451993294969432},
{-0.10782143499028717,-0.6651721468411893,0.7388643672713676},
{-0.11926011756806859,-0.6567866621812644,0.7445859955293573},
{-0.13811823634162218,-0.6318875040971632,0.7626542696109014},
{-0.09816342732326853,-0.6529069142811347,0.7510502665068673},
{-0.06290645322110741,-0.6681184194415539,0.7413909601189242},
{-0.0758394348651607,-0.6286771294176381,0.773959590073365},
{-0.03730327170642339,-0.6404247062328692,0.7671145035563725},
{-0.04583732531151941,-0.5640998242719357,0.824433337429205},
{-0.16815901196326655,-0.6548026223073,0.7368555302873294},
{-0.1782535496981766,-0.6797280512664056,0.711474137507172},
{-0.20553054043216404,-0.6465499572576854,0.7346634261481565},
{-0.20262197141718644,-0.6302265561998983,0.7495057201645825},
{-0.22002939067424984,-0.6152433702912452,0.7570090240890053},
{-0.24993880722788805,-0.5861614547109633,0.7706784943493804},
{-0.20139550314728014,-0.6130779324217336,0.7639210038279783},
{-0.15829914703201273,-0.6370857036221954,0.754362768360919},
{-0.18325481458094173,-0.6056898998315893,0.7743109311994143},
{-0.21593146949384667,-0.5502644780583172,0.8065870099805945},
{-0.16430314165919024,-0.5825716642226806,0.7959992045760701},
{-0.11774335060443877,-0.6091775674913946,0.7842443462682455},
{-0.14240031683307625,-0.5284139978140706,0.8369592562843134},
{-0.09267136915471584,-0.5506227048085156,0.8295942708868864},
{-0.11110066607434588,-0.41650862401979394,0.902317686912417},
{-0.28254307811941326,-0.6503908089624016,0.7050965924070545},
{-0.25303313498173446,-0.6980758687772135,0.6698240918571488},
{-0.2247532095342196,-0.6710653727305945,0.7065106229392559},
{-0.2497810741384263,-0.6310938921436035,0.7343908457363094},
{-0.19777702451777612,-0.7093828037008748,0.676505939653438},
{-0.2236334922732045,-0.7406945979344258,0.6335294576611652},
{-0.286520688644421,-0.7257090487952755,0.6255016158855095},
{-0.3207992997271353,-0.672638814252014,0.6668169425383733},
{-0.3484302534452503,-0.6106729357587694,0.7111082364983862},
{-0.30057611785535276,-0.5981092518917389,0.7429127271601352},
{-0.25201578543933795,-0.6023400294338055,0.7574130529843516},
{-0.22698998202551096,-0.6204867236543223,0.7506475696548832},
{-0.28887886996994616,-0.5690763690802318,0.7698708233459344},
{-0.3337359016411352,-0.5216105751187428,0.7852023661961754},
{-0.2735053584334509,-0.5547819562513728,0.785755559907844},
{-0.23321451562845968,-0.5749784258776197,0.7842262425317565},
{-0.2719717895681861,-0.5142709094271717,0.8133614063846577},
{-0.3131620817274172,-0.4262961891642973,0.8486466105936842},
{-0.2530670589603809,-0.463686633614422,0.8490887877462919},
{-0.1958524262699083,-0.49871245489553195,0.8443504689737918},
{-0.2276331606920614,-0.37006671631149185,0.9006851667657084},
{-0.16843844888657386,-0.3963829087628939,0.9025015670775052},
{-0.17183700379770056,-0.7468394044656317,0.6424196043578133},
{-0.15277869766604787,-0.7134634305013261,0.6838337538296467},
{-0.12848506583820415,-0.7484319716804365,0.6506467333531203},
{-0.25327215565045885,-0.7715253542774172,0.5836110373179004},
{-0.28435250116239724,-0.800211015714273,0.5280208191086978},
{-0.3226319301994978,-0.7523036215245072,0.5744109144652958},
{-0.44539603440809106,-0.7356852386568143,0.5102838446943161},
{-0.39377105433606,-0.7968697359527017,0.4581953521040332},
{-0.359004740164642,-0.776204917285734,0.5182871047216636},
{-0.4044954959264951,-0.717014701059523,0.5676912120507956},
{-0.3148390344336836,-0.8258595264342915,0.4677952810734559},
{-0.42543909811586056,-0.8140445999534791,0.39538963451378334},
{-0.48354400236584577,-0.7510410279938616,0.44958044001707037},
{-0.5363612434837048,-0.6768520435154637,0.5041705343210318},
{-0.49221221366837614,-0.663087262515283,0.5639524971180331},
{-0.44507162263180233,-0.6464752081178314,0.6196620498440268},
{-0.362236089397775,-0.6954777603236819,0.6205607951143564},
{-0.3963449499809314,-0.6282928098123111,0.6694466563982256},
{-0.4119651352417943,-0.555765467035442,0.7220868874284362},
{-0.3533051163475842,-0.5517550829143469,0.7554745682290054},
{-0.8436343396059828,-0.4803616597381028,0.23986199551248755},
{-0.8317371220428911,-0.49516053661450904,0.2510565728983015},
{-0.8262896068768081,-0.49497017970261786,0.26879361371232047},
{-0.8056711832567551,-0.5076440124040852,0.3052728306612643},
{-0.7724945420305007,-0.5207683579388424,0.36339028592240724},
{-0.7379521669304347,-0.5205117857943523,0.42952774086413803},
{-0.6626100120677891,-0.609636505210177,0.435076204155831},
{-0.5765888426013978,-0.6872274300172256,0.44188659859685697},
{-0.8871635238072106,-0.39430878342318537,0.23971121238127427},
{-0.877042884820363,-0.40048125401123563,0.26534985089794866},
{-0.8605548077352669,-0.40757981700573387,0.3054899599877059},
{-0.8334655193856011,-0.4213398106106747,0.35750243634114026},
{-0.800107017161408,-0.42281805075670703,0.4255040035573971},
{-0.7590908422650752,-0.4218789546476174,0.4957814446051128},
{-0.6967203189656634,-0.5172847134647982,0.496988251728374},
{-0.6215107284498163,-0.60332314542244,0.49972552128078485},
{-0.9024077619054066,-0.312502506336652,0.2966520095771911},
{-0.9119695807369397,-0.21173288929307427,0.3513981607836006},
{-0.933311485292329,-0.20767365941249458,0.2929186279628692},
{-0.9237412563243553,-0.28648770826220976,0.254218182628561},
{-0.9480089738559404,-0.19243848662718352,0.25346876405830826},
{-0.950921511789609,-0.10344910227104268,0.2916274363894452},
{-0.9300691255479768,-0.1060007870484235,0.35176022351530356},
{-0.8990072518584981,-0.10729568983882373,0.4245863823155921},
{-0.8806152749711701,-0.21376797536993855,0.4228711271695996},
{-0.8799533081769187,-0.31748268171239663,0.35339343831090275},
{-0.9283771800408003,-0.2924585240235349,0.22931162924166526},
{-0.9572624213101935,-0.18569042366510694,0.22173796090525166},
{-0.9637447456309637,-0.09921209838382784,0.24769542749713178},
{-0.9560914971354428,-0.0008399917649347581,0.2930671314206735},
{-0.9350114184013112,-0.0014817540859846927,0.35461451163763286},
{-0.9035658828537705,-0.0016122555653510025,0.42844614127644814},
{-0.862969243834668,-0.0016718781629137874,0.5052536877835033},
{-0.8589214392571959,-0.1081504441680382,0.500557132214299},
{-0.8404536317067626,-0.21481630854461267,0.49748532293343006},
{-0.8477677698039335,-0.31964873020957896,0.42321920768919336},
{-0.9724790845612735,-0.08458549164648245,0.21709381542040798},
{-0.9689716839096782,0.0007037338143738878,0.2471707517890435},
{-0.9771391228273262,0.003850191407104154,0.21256601484332383},
{-0.9768843039998419,-0.08720506912620915,0.1951725711196061},
{-0.9824303573712526,0.009192560282553308,0.18640303042291081},
{-0.9719523387664523,0.09925889548911143,0.21320488463612974},
{-0.9631284728331242,0.09952725093152709,0.24995573836210805},
{-0.9494017419058318,0.10068393268815702,0.297487946250968},
{-0.9630409146406607,-0.17970451758302514,0.2006451671193006},
{-0.9776990130297986,0.10052216933186774,0.18439070853319325},
{-0.9564903000402438,0.19437924406662863,0.21758450175738714},
{-0.9462512316354263,0.19757574825428315,0.2560711431032374},
{-0.9309648787840614,0.2008925955596765,0.30487138192994406},
{-0.9072573330254151,0.20326578099890902,0.3681944512706764},
{-0.9273373859484975,0.10182054035026908,0.36010824787136797},
{-0.8947878305038823,0.10262097848076282,0.4345384599293902},
{-0.8530078935283036,0.10307203873484165,0.5116186943510271},
{-0.8018482489114718,0.1034896431919039,0.5884974761794812},
{-0.8130100478955827,-0.0016314259803666242,0.5822473705136785},
{-0.8095037848721568,-0.1089037790464711,0.5769259824163325},
{-0.7910858773469741,-0.21531658205127108,0.5725573370029646},
{-0.8071969176848467,-0.32013530705693194,0.4959299559974644},
{-0.9366031883104988,-0.27863943082837267,0.21244890028957286},
{-0.8973270498423455,-0.3791740235144295,0.22590091968186393},
{-0.9634866363826647,0.19205126406844905,0.1865738820996376},
{-0.9309095668118572,0.287201814922287,0.22566013366012355},
{-0.8810236794087504,0.38264989278657646,0.27816602213694097},
{-0.8958720554102088,0.3756073270395962,0.23734446740814807},
{-0.9398164813540589,0.2820098546249296,0.19291299404058318},
{-0.9071798392044639,0.3683844701896327,0.20326736448349697},
{-0.85257841366835,0.45751529516636363,0.2525664333113074},
{-0.8348092044260598,0.4653652230788257,0.2941577830932301},
{-0.8116587750298014,0.4714529419224584,0.3448799160139384},
{-0.8609135072425402,0.3884981604666953,0.3284769586460251},
{-0.9186149544872664,0.2926896580197038,0.2654794332536256},
{-0.8665836177395099,0.4491849627956553,0.21740676775061293},
{-0.8008267327485606,0.534152038625073,0.27084708554448905},
{-0.7817664913796349,0.5390026361640665,0.3135559139358756},
{-0.7553061803532108,0.5446168761697298,0.364561424332537},
{-0.7207733091241335,0.5453458611884819,0.42788284440818525},
{-0.7802114257796102,0.47366939742124736,0.40854306141402064},
{-0.8323957547317333,0.3914595667255869,0.3922712264793376},
{-0.9011631616280817,0.29760034950387576,0.31518088155795665},
{-0.7224989307816481,0.6041670115542446,0.33612128342160774},
{-0.6907861865317757,0.6490090737087714,0.3187501635145763},
{-0.7456067375151268,0.598527948442078,0.2929759169381775},
{-0.7675859382340553,0.5877370379738709,0.25568926770407424},
{-0.713277551686809,0.6426317761094301,0.27974905646688203},
{-0.6572235141087931,0.6883256570821896,0.307026126420637},
{-0.6321060412338012,0.6923411465346542,0.3480024273633912},
{-0.6617383955691394,0.656037942595295,0.3629276976271084},
{-0.6295186682292144,0.6573704615453909,0.41421048108240327},
{-0.6940612770639027,0.6065775019327377,0.38774047741945133},
{-0.8235175297624829,0.5189534782021723,0.22914223887307503},
{-0.7167650812260058,0.20304040459267333,0.667100001827253},
{-0.7772556287764172,0.2035545008997834,0.595348009737848},
{-0.8297316984881905,0.20426591893646337,0.5194427233920451},
{-0.7408377558429841,0.2966368854825212,0.602632539520362},
{-0.6802868856913417,0.29290599607112844,0.6718748623233016},
{-0.6144726404922357,0.2904691670310716,0.7335196228396178},
{-0.6505679348213151,0.20409715453681063,0.7315092027393136},
{-0.7423740946279208,0.10440811883006225,0.6618003085128796},
{-0.7546836586710539,-0.0014733781034893313,0.6560871927509608},
{-0.7516222864502259,-0.1100782821132149,0.6503435325413318},
{-0.7332357525141969,-0.21611844107093753,0.6447155579509518},
{-0.7578797310454757,-0.3192575947266702,0.5689401563255829},
{-0.8390440056447696,0.30121276824054927,0.45307397281287853},
{-0.7477754149459276,0.38737712923439194,0.539231757733692},
{-0.7939422581178075,0.39096124205289895,0.4656232360903515},
{-0.8752715923417709,0.30057850599236274,0.37888283330721134},
{-0.7394535161393089,0.4714012874753042,0.4806134867394363},
{-0.692300316619182,0.4652896964174053,0.5515666505661662},
{-0.6398021872316857,0.45549953541795957,0.6190099631246447},
{-0.6944715211981421,0.3809669734215387,0.610387967940695},
{-0.7941660197700512,0.29977559268687376,0.5286160488216641},
{-0.8730547696638316,0.2043363565038864,0.44274374369148456},
{-0.5431244288936795,0.1176070125423337,0.831375032906198},
{-0.4555577952727726,0.23202542822267905,0.8594366153616525},
{-0.5156074404136927,0.21777980136588249,0.8286862648234716},
{-0.6092157700374488,0.11079545203601372,0.7852264089712049},
{-0.5821072089358607,0.20856482963526454,0.785908333804977},
{-0.4804800210273495,0.3004646932136219,0.8239295585944238},
{-0.421707318679589,0.31571331748326764,0.8499929638154547},
{-0.36790794048403747,0.33545144360220075,0.8672462604785295},
{-0.3995688234485602,0.24968715968446553,0.882043693711733},
{-0.48277988057358373,0.1271149831700364,0.8664671765087455},
{-0.557765139937893,-0.0006071052659764918,0.829998602464642},
{-0.6233689270007444,-0.0009444929999782673,0.7819272912380751},
{-0.6903280213118811,-0.0012386357083915326,0.7234954656203486},
{-0.6769947299816886,0.10658634015066717,0.7282290077100106},
{-0.5464408779623497,0.2922024600945592,0.7848694727191421},
{-0.4416826993489042,0.3674648130444965,0.81846564025012},
{-0.38556840919230223,0.38119368330859743,0.8402549480000353},
{-0.33539527441666966,0.40009734799281643,0.8528963137615744},
{-0.28576841090285704,0.4204364528157782,0.8611443575114115},
{-0.31407367416355125,0.3568282055053312,0.8797905199269043},
{-0.3428027806474002,0.26892865013284134,0.9000909035859314},
{-0.42573065709591346,0.1384825053984833,0.8941901382296948},
{-0.497297437979297,-0.0002757412615785256,0.8675800724693854},
{-0.5544096762077697,-0.12380785473459094,0.8229833084778903},
{-0.6204629710333317,-0.11669339654175884,0.7755052242119579},
{-0.687499725266002,-0.1123812132023176,0.7174361230648669},
{-0.5057159873415177,0.36247933218356904,0.7828538010937597},
{-0.571675755224243,0.36542177459399455,0.7346112969056271},
{-0.6353359654899923,0.3728737665529679,0.6762494844149622},
{-0.5239093832275713,0.4302200116093366,0.735139238360304},
{-0.46283953509346515,0.4206471740856971,0.7802791293429437},
{-0.40315963380359393,0.4195828256731239,0.8132727476508167},
{-0.3202828303336967,0.46576572262278115,0.824912844016333},
{-0.3511230071411799,0.42982357391658615,0.8318439331759943},
{-0.28002796547226916,0.47981782962742053,0.8314801193805499},
{-0.30549553214547664,0.44678095738744567,0.8408681561071922},
{-0.36676692591896487,0.4630632340739631,0.8068794602051256},
{-0.42548806654194693,0.47127050800429965,0.7725697466997818},
{-0.3661568261066162,0.5124244137702313,0.7767563317204206},
{-0.3249001453741071,0.49933640026916565,0.8031830768275161},
{-0.2947686738896782,0.492102484529394,0.8191132849693734},
{-0.2603275272570306,0.5032379427877037,0.8240031258988281},
{-0.22570022176574847,0.5153796372672016,0.8267062594327077},
{-0.24023286044321068,0.4953424723600141,0.8348197457173264},
{-0.26066109464687587,0.46504625910697905,0.8460424165655628},
{-0.3555132573851672,0.5624293396283828,0.7465142743099887},
{-0.41127047925017407,0.5318660320974263,0.7402534139051786},
{-0.47948591955286873,0.4874816833484167,0.7296950468177332},
{-0.47104267207158174,0.5492681420009972,0.6902342423195451},
{-0.39809968590957157,0.5849872488134376,0.7066162740868525},
{-0.34002486721955455,0.6046184342330336,0.7202913567841275},
{-0.3035427102302967,0.5796865677069107,0.7561913159288642},
{-0.3184409009261848,0.5405479709429776,0.7787190017758329},
{-0.2884036017935057,0.5216097904576288,0.8029611378960265},
{-0.26923256171660326,0.5108598006994728,0.8164166165266423},
{-0.24896718585350897,0.5174904910087845,0.8186690003192203},
{-0.2189717047745878,0.5263410241251714,0.8215938892366328},
{-0.18719670388130985,0.5346480342286652,0.8240806232107373},
{-0.19168041035439184,0.5263389187904511,0.8283875680216785},
{-0.20190158091010738,0.5095706468977353,0.8364051096485619},
{-0.21734176758652538,0.48210518668281005,0.8487267787903819},
{-0.5370065145228832,0.4992302900186037,0.6799949418105443},
{-0.5785663465609151,0.5187866148222983,0.6293817846969956},
{-0.6298904908201708,0.531697223115429,0.5661590169781507},
{-0.5227058312796856,0.5699813582981976,0.633955728058951},
{-0.58336016437745,0.443130635068738,0.680680658518436},
{-0.6115118136129007,0.5972251890140707,0.5190138489664496},
{-0.5044429286707138,0.6237249418646736,0.5970800018506921},
{-0.5570018735096701,0.6379332759554911,0.5317800751583428},
{-0.6564581518672961,0.6050955002382385,0.45046878963853854},
{-0.5898074540126778,0.6520505966034845,0.47640023788839864},
{-0.4859896776794054,0.669933666454924,0.5612512055571288},
{-0.4273170522603134,0.651631421885959,0.626718937689328},
{-0.4445797716106916,0.6066610132677457,0.6590229447109845},
{-0.5763148828328144,0.5816297530925902,0.574080121710247},
{-0.6777805147046485,0.5406165259408355,0.49834460543519843},
{-0.5344568966406903,0.6853384248270714,0.4946383214923316},
{-0.4551381826481998,0.7101292507533369,0.5371830990641817},
{-0.4094088613069481,0.6900719788346833,0.5968124062974334},
{-0.36503894397759584,0.6667055932450855,0.6498078341444032},
{-0.38188953708635914,0.6291095686147489,0.6770387966293592},
{-0.5244558875785259,-0.581174231105733,0.6222399336934915},
{-0.4694864675757474,-0.5675755621985614,0.6763434319620719},
{-0.5752429037389906,-0.5936088606310878,0.5627824822062218},
{-0.6489445522068183,-0.5109628921739265,0.563726787533064},
{-0.5951379279324528,-0.5023855086748589,0.6272317334205678},
{-0.5354940700000677,-0.4937523673315337,0.6851676442661817},
{-0.47086494392863965,-0.489386912557027,0.7340208814447856},
{-0.5237988308747349,-0.4118057337495817,0.745688153603924},
{-0.591425638662424,-0.41024318234747803,0.6942018764524895},
{-0.6540595535882627,-0.41395254176386415,0.6331266804733149},
{-0.636260060398955,-0.31837362837220745,0.7027171324923234},
{-0.5679678953190223,-0.32354436498835304,0.7567902706636519},
{-0.4992948956479359,-0.33678589658038866,0.79829810662713},
{-0.4548000659912942,-0.42330733738391835,0.7835609727974281},
{-0.470731409962615,-0.25518493470630427,0.8445665093842805},
{-0.5337127907867888,-0.23667624419974764,0.8118713028442863},
{-0.6010880368984615,-0.22481541923379622,0.7669101636908239},
{-0.49307291834087896,-0.13415706459745513,0.8595818630109661},
{-0.43440580720374034,-0.14732979282485753,0.8885862517582923},
{-0.4029187874421651,-0.2923237919407448,0.8672965187244324},
{-0.4347040705586825,-0.3597044669943134,0.825617991242953},
{-0.3898561220820676,-0.4467680102365782,0.8052394358849925},
{-0.40463423825659617,-0.4948328232704263,0.7690329058270023},
{-0.7003828498456706,-0.3180232324762434,0.6390031981511658},
{-0.6688796661401613,-0.21861613007761427,0.7104976987254172},
{-0.7102575571354774,-0.4185846542994424,0.5659691596871338},
{-0.5976042034790242,0.727297810449201,0.337501275404996},
{-0.531929685771394,0.761336805443309,0.3706980955879368},
{-0.5701967292396046,0.7280591957303745,0.3805331752645195},
{-0.4986941991699581,0.7226671490961802,0.4785982525369615},
{-0.5642607013318387,0.695273176911064,0.44520228031816916},
{-0.6013849553159745,0.6953389050215968,0.3934970682012385},
{-0.5371725050720266,0.727390969021069,0.4270223389721356},
{-0.46885545938963535,0.7526665068649413,0.46224202280219107},
{-0.4205658069742648,0.7430396491666538,0.5205924334547916},
{-0.5029689124089721,0.757945352230407,0.41538068826374186},
{-0.3449600581952591,0.7560702887144872,0.5562016511779834},
{-0.3225498192576204,0.7347085865139181,0.5967955319869583},
{-0.38790749499376953,0.7251693898395726,0.5689087197146487},
{-0.345443342252854,0.701335373563472,0.6235363590695918},
{-0.30537964173349924,0.6745634817196368,0.6720917969630347},
{-0.32375029102097963,0.6410903442195177,0.695836848415152},
{-0.2513175311814096,0.7414128569872956,0.6222109561995971},
{-0.22988833598159142,0.7123584315349367,0.6630963866593604},
{-0.28715309482094337,0.6143464987610492,0.73492957458167},
{-0.26929262333357895,0.6464760358911741,0.7138278630290027},
{-0.23848313177434813,0.6182690399494789,0.7489120042428541},
{-0.2567577102518836,0.5877141169256606,0.7672467627774656},
{-0.28221709700327885,0.7064759140879802,0.6490341231188039},
{-0.24717498077217326,0.67799056168148,0.6922668034443853},
{-0.2212372392764343,0.5401318359414502,0.8119801005935184},
{-0.25401321506898666,0.5333261196604945,0.8068708302189369},
{-0.2740219633454936,0.5554325849238064,0.7851156648603693},
{-0.2340695750948287,0.5623651356821199,0.7930680224193617},
{-0.19720923050240935,0.5660771970107366,0.8004155960681396},
{-0.1885586436445764,0.5458425076985183,0.8163954891450044},
{-0.17355071988425422,0.592407857958528,0.786722999191358},
{-0.2140890269436632,0.5910153206668173,0.7777318170676923},
{-0.19240028995433126,0.6193301887786004,0.7611913331698886},
{-0.14703866616932873,0.6193467582556836,0.7712257929357137},
{-0.13323310975944036,0.593186892161047,0.7939636323107924},
{-0.1611910376167955,0.5688315578493377,0.8065036318496752},
{-0.15518107032232473,0.5508095499423282,0.8200778469791435},
{-0.1193585840762609,0.5474947564891349,0.8282529927650204},
{-0.12020098430992866,0.5549930775386217,0.823124782311366},
{-0.15413389752534626,0.5417606408612982,0.8262797042449981},
{-0.12442943035210562,0.5711304276881839,0.8113737433704412},
{-0.08290799413550337,0.5517433026859924,0.8298828787543341},
{-0.08381043123352407,0.5477231323223075,0.8324513090478569},
{-0.12108068391861641,0.5426109820181578,0.8312116398217066},
{-0.15691922490618973,0.535458576952047,0.8298556918063101},
{-0.11317267267147182,0.6479961282789451,0.7531885314420904},
{-0.165714690694702,0.6483128236672211,0.7431212040822103},
{-0.2171704979084002,0.6482064379127435,0.729839289629361},
{-0.18900194146504312,0.6790751591430523,0.7093202339968054},
{-0.16384521604683103,0.521298002553912,0.8374981419154723},
{-0.17500457285143087,0.4965397454459545,0.8501892028681352},
{-0.23736385754986666,0.4399746096754838,0.8660720189279597},
{-0.2609257902490697,0.3777711600280772,0.8883730537527235},
{-0.2858374915960498,0.2881332220600178,0.9139344477277299},
{-0.36725163637471847,0.15087617890967595,0.9178031456786946},
{-0.43961940240265984,-9.838827650418436e-05,0.8981841522487887},
{-0.3801546205996897,4.540765512178951e-05,0.9249229494259784},
{-0.30768242188003786,0.16338267535483225,0.9373567243370754},
{-0.3191435751106039,0.00014982434912940912,0.9477063659268553},
{-0.3740575621431137,-0.1625173600761851,0.9130547890884853},
{-0.20871827099087203,0.39635147705256335,0.8940593884037191},
{-0.22900492026010028,0.3055657667035102,0.9242220018564593},
{-0.09085888525585513,0.5156828164424857,0.8519482940859784},
{-0.14384094872018344,0.47045961112528434,0.8706190531863658},
{-0.13319715206343175,0.5078422391399315,0.8510903470416824},
{-0.19018893829422895,0.4570290249390092,0.8688801057187423},
{-0.12560931765246244,0.5303753107142785,0.8384058260196046},
{-0.08638259308027615,0.5367393058705758,0.8393145805633905},
{-0.3643897715486419,-0.40681404448488845,0.8376887414789432},
{-0.3195829342539866,-0.49113268246182357,0.8103427894116573},
{-0.30643823692239297,-0.19394719181155742,0.9319227938731331},
{-0.27713191940323345,-0.36085364777609585,0.8904956732823383},
{-0.3381110927325961,-0.31909678692593213,0.8853576280490929},
{-0.2568287776833705,0.00019435032174295604,0.9664569008401867},
{-0.23967989331806008,-0.20102405257296782,0.9498120229951735},
{-0.24730813178778582,0.1749541834755627,0.9530108717302413},
{-0.8503608471949793,0.3471839937571793,-0.39541080414760027},
{-0.8469338834274976,0.30807771257575517,-0.43334872806610186},
{-0.8375340874095007,0.28024536512790876,-0.46904071012169074},
{-0.8250534299271746,0.2493956949057931,-0.5070390765294737},
{-0.8083819442349367,0.21576923553366692,-0.5476881131010246},
{-0.7862251039181808,0.17936300179584094,-0.5913366211859632},
{-0.762450448076206,0.14179983718010505,-0.6313177649995986},
{-0.7433311117036574,0.10650967325749018,-0.660389693950464},
{-0.729531101531618,0.07700032681595517,-0.6795993831429662},
{-0.7208341646317223,0.05804070098369351,-0.6906731384157114},
{-0.7209021417858265,0.05606576738108343,-0.6907653231717545},
{-0.7353541463776297,0.07228359193317484,-0.6738170090925769},
{-0.7667879729650375,0.10272567011109072,-0.6336273677930873},
{-0.8147429080037236,0.13817419779203735,-0.5631180026621088},
{-0.8467313937184372,0.20971802560234648,-0.4889420176555563},
{-0.8469855856082025,0.3157018655509739,-0.4277239178016178},
{-0.7898467886679535,0.44051404071939526,-0.42671938128000675},
{-0.6862590353635422,0.5832610482957232,-0.4345746034029999},
{-0.54245618177011,0.7235527804550235,-0.42686375432355217},
{-0.38490851141246735,0.8295781229949316,-0.40453130372128776},
{-0.24707506617835248,0.8921021998015748,-0.37829562088683194},
{-0.13995708155093703,0.9231594991384269,-0.3580342923160198},
{-0.058832957354556625,0.9362108621849657,-0.34647929902924957},
{-0.8956840461631457,0.21593206218595956,-0.38874597614500755},
{-0.8811482318167281,0.28135176772732506,-0.380024968078366},
{-0.8835553004203675,0.20550734358203335,-0.42082866208580716},
{-0.8705991667597033,0.267970386194374,-0.41261236404178236},
{-0.8586909361225048,0.3560837892364908,-0.36858406268318034},
{-0.9052390444640176,0.15706680421791222,-0.3948066506413546},
{-0.89173880314405,0.1508010065143486,-0.4266860243803123},
{-0.8761597719266442,0.15063153041132096,-0.45788011105899135},
{-0.8694122227734531,0.2010809369677703,-0.45131900434203653},
{-0.8594048233999122,0.24864817960329444,-0.4467632844101377},
{-0.831152101122108,0.20333956186939162,-0.5175318418987077},
{-0.8545147523552745,0.1773629280207337,-0.4882078755726048},
{-0.8477477978534983,0.22530535189986195,-0.48016785569196907},
{-0.8596048827123824,0.13304910054300806,-0.49333293267501194},
{-0.8354605418119695,0.1624919818282831,-0.5249781318462394},
{-0.8103733805815454,0.1796678496076208,-0.557686693280565},
{-0.7844159705916387,0.10247883100752622,-0.611710449703214},
{-0.8173462795734188,0.07919766427987109,-0.5706774826818591},
{-0.8146259790864593,0.11358439171593379,-0.568755747360806},
{-0.7833994265979065,0.12913454901346938,-0.6079552669869381},
{-0.8122666689936542,0.14644122444558957,-0.5646041323129243},
{-0.8391712349975977,0.1237763885008009,-0.529595169919728},
{-0.8425379370596552,0.08487466726158586,-0.5319079953079251},
{-0.845257915645242,0.043904687132691876,-0.5325518138987432},
{-0.8198867983905065,0.041616580194523585,-0.5710111190492508},
{-0.7865410215109453,0.07287100704486006,-0.613223481132928},
{-0.7525993739670577,0.09130594635995856,-0.6521176323821533},
{-0.7529136866547682,0.11156806063308006,-0.6485935154582558},
{-0.7560010594241122,0.12815388573050188,-0.6419026247974011},
{-0.783986361537547,0.15420725989312645,-0.6013198033653742},
{-0.8636378833397016,0.08986434842511153,-0.49603831035782925},
{-0.8642193064592171,0.05044882770552824,-0.5005795702246425},
{-0.8676783722647604,0.007528264511044417,-0.4970689766394878},
{-0.8465829016261093,-0.0009328586740805751,-0.5322560666155075},
{-0.8213037160947145,-0.0008374553961560032,-0.5704905823915695},
{-0.7889488140714586,0.03890410609920548,-0.6132260915061107},
{-0.7541786948027985,0.06654990600103224,-0.6532883026021519},
{-0.7270539658552666,0.08130807301130787,-0.6817488745845618},
{-0.7284340288809823,0.09551976474763815,-0.6784245279401211},
{-0.7335387338262488,0.10396927873975126,-0.6716482078103981},
{-0.8810234707733136,0.10292770996390116,-0.4617396782475289},
{-0.8833725613148596,0.051377922388144016,-0.4658467849058343},
{-0.8859215799724046,-0.0008028436395419203,-0.4638343557578382},
{-0.8681249470975636,-0.04793164304223287,-0.49402594448280157},
{-0.8455748712694853,-0.049519556517325,-0.5315552187683995},
{-0.8205003667149019,-0.047319053518984425,-0.5696841716203629},
{-0.790494730211102,-0.0009059187111631472,-0.6124681712707737},
{-0.756530885194561,0.036239216513422365,-0.652953090913296},
{-0.7282154995262766,0.061041483870993306,-0.6826244381037956},
{-0.7108285423771502,0.07337765445919758,-0.6995273426879343},
{-0.7125077970693372,0.08250074553739727,-0.6967971484594164},
{-0.718338903956469,0.08398998906505042,-0.6906047355756195},
{-0.8972820714155025,0.09942481076298414,-0.4301157882722393},
{-0.9113806156752595,0.1023684369422064,-0.39863025034409333},
{-0.9006465330101315,0.0492093393730377,-0.4317571811739778},
{-0.9156862080985781,-0.0027889346793698033,-0.4018842994462483},
{-0.9148228836552378,0.04971039002937534,-0.4007841921331761},
{-0.901717851464581,-0.0017441855887781988,-0.43232149399114045},
{-0.9136870349259186,-0.05777872515204043,-0.402290468602089},
{-0.9000405087655858,-0.055226836534279,-0.4322928163957869},
{-0.8863023542771581,-0.048025172632086534,-0.46061016010985373},
{-0.880806902776832,-0.09951225068462519,-0.46290011015808213},
{-0.8951661071927746,-0.11311504776238282,-0.4311410749430495},
{-0.9083146401579589,-0.11788689525293658,-0.4013317759688866},
{-0.8882162751991394,-0.17930435235446793,-0.42299148655512125},
{-0.8733984744026435,-0.16667938114195172,-0.4575948959650563},
{-0.8623921970812971,-0.10546652902589859,-0.4951328202296051},
{-0.8417208494944096,-0.10097113777208179,-0.5303874441042327},
{-0.8169317792093764,-0.09629963144653526,-0.5686377134002493},
{-0.7899222980785244,-0.045011706318746306,-0.6115527036099324},
{-0.7582656873515409,-0.0009018313940115492,-0.6519450391600752},
{-0.7305433486846061,0.03398899998167464,-0.6820199143521603},
{-0.711932625666957,0.05677604586471232,-0.6999488675088492},
{-0.706500581171084,0.06859161392093965,-0.7043806636362481},
{-0.7071169639268066,0.07457807164694955,-0.7031526936280326},
{-0.7114227524186924,0.07155470160411757,-0.6991120024855514},
{-0.9002628343613899,-0.18702296479966476,-0.39312751074573776},
{-0.8830127054220985,-0.25909226685038894,-0.3913563073740769},
{-0.8597890231842142,-0.34038465661769474,-0.38065879886216825},
{-0.871804822434869,-0.24832568693118448,-0.42224483986126055},
{-0.7841429346886244,-0.0936656346274326,-0.6134709503047003},
{-0.8077984732069678,-0.15153114574361082,-0.5696489608119375},
{-0.7761800173904285,-0.14303854965188137,-0.6140721080763075},
{-0.7489657284854399,-0.1305674399758696,-0.6496171804781812},
{-0.7500414878610856,-0.08409527188843974,-0.656022676233938},
{-0.7579424916990032,-0.04261843961255355,-0.6509276825286336},
{-0.7324435706444375,-0.0008816296239308814,-0.6808271723064767},
{-0.7143312189369948,0.032292214694288585,-0.699062316622864},
{-0.7081932506160267,0.05414718225156258,-0.7039392036505153},
{-0.7167049687956708,0.06770549994507777,-0.6940820938338516},
{-0.7152884996931516,0.07377325872408856,-0.6949243617142438},
{-0.7162146586075968,0.07053803445825937,-0.6943060913533519},
{-0.8344305872585885,-0.15644169504637026,-0.5284426090866495},
{-0.8421932102624432,-0.22762028444213395,-0.4887735699670372},
{-0.8546339523822067,-0.1636894277017103,-0.4927540752690481},
{-0.858352821586836,-0.23791625734250232,-0.4545616439670789},
{-0.8382920423345114,-0.3122768762960579,-0.4469335569068519},
{-0.8233305240037805,-0.29850192672072484,-0.48272502316295485},
{-0.8226523237419056,-0.21719413784674668,-0.5254235060663458},
{-0.728809851848499,-0.3172675237579526,-0.6067763329407845},
{-0.7789520784710208,-0.2799416561401223,-0.5611295114349292},
{-0.7532939275340615,-0.2514835428940108,-0.6077041108909699},
{-0.6979022377688978,-0.29767402702464285,-0.6514005220692543},
{-0.722164135473652,-0.23632426555564107,-0.6500998407515417},
{-0.7697919553263645,-0.19224218990751518,-0.6086569525885458},
{-0.7970817738095749,-0.2153542141217775,-0.5641659404116606},
{-0.8047460688878566,-0.2844952846265555,-0.5210049881093234},
{-0.7783469229983829,-0.3593795455517165,-0.5148032728120434},
{-0.752179960813702,-0.3518292962601685,-0.5571727316042774},
{-0.6933556929450494,-0.39013845422719556,-0.6058464075934633},
{-0.6627802369325424,-0.36541427610860694,-0.6536013803134642},
{-0.6377284806990601,-0.3455055929814191,-0.6884244839659805},
{-0.6727870751539728,-0.2818015323963456,-0.6840653827265591},
{-0.6970084543856755,-0.22396617567723995,-0.6811889361017275},
{-0.7384657452084052,-0.18092206808172293,-0.6495656613729108},
{-0.7955457590589391,-0.3772774360577344,-0.47409775519932434},
{-0.7554815859868089,-0.46419250540121393,-0.4623558058078215},
{-0.7401893920546362,-0.442340595390475,-0.5064133307481036},
{-0.7134698949555293,-0.4315038651231169,-0.5520553626004886},
{-0.6404072169667401,-0.479912230690731,-0.5996355954163838},
{-0.6132764677714833,-0.43900211608282785,-0.6566346900313235},
{-0.5884836984528801,-0.41440586575269533,-0.6942295838445511},
{-0.572801278372433,-0.39774720578359585,-0.7167257884199845},
{-0.6221377412798443,-0.33172363081991363,-0.7091572911779636},
{-0.6572858467567042,-0.2705853044707201,-0.7033910069497692},
{-0.6815148122232778,-0.21501980558735653,-0.6995027118785502},
{-0.7132322271892804,-0.17162688419530236,-0.679591055503257},
{-0.6990581008431322,-0.5580529213042877,-0.4470958607159583},
{-0.6861884845322502,-0.5326385231861686,-0.4954205963758383},
{-0.6637085986178455,-0.5164135992441867,-0.5411172614474614},
{-0.6014171543776828,-0.589331683604817,-0.5394307862179931},
{-0.5668949295546449,-0.563615238090571,-0.6008061269971728},
{-0.5505455372672062,-0.5117428664004657,-0.6595595879701835},
{-0.5264062970304849,-0.48208321287402467,-0.7003514734129648},
{-0.5107898487046677,-0.4623421729671168,-0.7247989000793995},
{-0.5068582535510179,-0.45451729998465945,-0.7324675657132316},
{-0.5696997782259448,-0.39039433261917095,-0.7232111916640542},
{-0.6195656652722759,-0.32487918779277797,-0.7145571354026402},
{-0.6548917308027753,-0.2643520851782891,-0.7079793753973598},
{-0.6790373778989458,-0.20958985839572733,-0.7035483854531848},
{-0.6976576152716201,-0.16478483613620137,-0.6972229267838812},
{-0.7236143585718392,-0.12399850439603233,-0.6789746909688262},
{-0.7259430742693385,-0.08010997740526109,-0.6830732350491493},
{-0.7323100067838558,-0.04062620847781612,-0.6797584608880907},
{-0.7163588894003983,-0.0008732331968259668,-0.697731451950399},
{-0.7108244190249303,0.031183537972731504,-0.7026779008033291},
{-0.7193293112302492,0.05322292183979722,-0.6926273620034442},
{-0.7430073345571608,0.069693825481641,-0.6656447036400109},
{-0.7395680629379601,0.07920092305111168,-0.6684057854851687},
{-0.7366677635146786,0.0807386337066369,-0.6714178127108834},
{-0.8188093640521271,-0.4119652374229251,-0.3997947829769968},
{-0.8502987188430555,-0.32613897643911777,-0.4130683439590874},
{-0.8259868764565581,-0.4294147477719247,-0.36516935018907704},
{-0.778287924193243,-0.5249021133333818,-0.3445949484149798},
{-0.7739109263799372,-0.5051540828247092,-0.38194401505361264},
{-0.8088080948367536,-0.3946891509866414,-0.4359471754926106},
{-0.7664722616443685,-0.4850131935373733,-0.4210492539174544},
{-0.7073267200604347,-0.5814659898877036,-0.40197787711820687},
{-0.6336514637410119,-0.6738645319076599,-0.3799900197843932},
{-0.6280805084313827,-0.6492193698292372,-0.42898611255739266},
{-0.6178464969640318,-0.6212516483016474,-0.481987650953591},
{-0.5405241356882623,-0.699418522341506,-0.46759746507448174},
{-0.5264690506307272,-0.6644081104352819,-0.5304641378225289},
{-0.4928977556399636,-0.6319576161843431,-0.5980646903401746},
{-0.47979989814892465,-0.5758053216965531,-0.6619971973069151},
{-0.4568429604137586,-0.5411836965200895,-0.7059849262847223},
{-0.44161334288790705,-0.5183699662307251,-0.7323047408649795},
{-0.43680291440827873,-0.5099756092807118,-0.7410317752318054},
{-0.4441230334812702,-0.5180249204233439,-0.7310300356016726},
{-0.5169127370674222,-0.4599930674852905,-0.7219470895591582},
{-0.5818992812540861,-0.3929286995809608,-0.71203950980377},
{-0.6328828410803744,-0.32485122734548405,-0.7028022407179464},
{-0.6684078142435159,-0.2626335504481562,-0.6958840507133363},
{-0.6922205699198792,-0.20705074671623977,-0.6913469974361972},
{-0.6949596914476863,-0.16036041997848602,-0.7009390579552978},
{-0.7079150355980396,-0.11910085742508597,-0.6961833724923597},
{-0.7120831479985302,-0.07716350659379217,-0.6978419474255277},
{-0.7163695542348057,-0.03913613665165643,-0.6966225840248136},
{-0.7129470199327679,-0.0008869373353375166,-0.7012173415647597},
{-0.7222074213104335,0.030527397584218914,-0.6910025460161989},
{-0.7463869662967398,0.053204695350716785,-0.6633820595516483},
{-0.7845572354248117,0.0723531626216876,-0.6158205616908355},
{-0.7798092020319578,0.08774172213087854,-0.6198378809203169},
{-0.7738095678944444,0.0983732273341324,-0.6257327390978359},
{-0.7135286617945463,-0.6235806931749177,-0.31941190944793074},
{-0.6352190718432376,-0.7148911000757653,-0.2922797389472591},
{-0.7119259179598753,-0.6032249792811211,-0.3595568268136209},
{-0.7133613922835006,-0.040189063391906754,-0.6996430255373285},
{-0.7243283657536395,-0.0009270472366088865,-0.6894545374048118},
{-0.7492905048425275,0.02986168666641177,-0.661567849144944},
{-0.7881408900160582,0.05269799445106812,-0.6132347502103338},
{-0.8369918485794894,0.07287501335800364,-0.5423411083806574},
{-0.832203837652981,0.09479087398702772,-0.5463071139976362},
{-0.825045255247627,0.1165246124560828,-0.5529216413609959},
{-0.710798066876835,-0.07887654642655152,-0.698959654449364},
{-0.7049665154030702,-0.11578899745782263,-0.6997250318719239},
{-0.7170766316277185,-0.11344623814439046,-0.6876998294491075},
{-0.7223599731302606,-0.07311025725952368,-0.6876415923304054},
{-0.7279295686031215,-0.03596375585757792,-0.6847080775176307},
{-0.7512343306442194,-0.0010105425210732812,-0.6600348167069253},
{-0.7907089339208709,0.028500281474148677,-0.6115285077358322},
{-0.8400903127129544,0.0501945853545477,-0.5401192184017668},
{-0.8862359468041733,0.06961241103066987,-0.4579737534210968},
{-0.8821255446881676,0.09627945872791427,-0.461069180531147},
{-0.8753287670515224,0.12705312278083933,-0.466537301363673},
{-0.864329910531892,0.16399216439266248,-0.4754370366071006},
{-0.8853132880921606,0.23820173279348963,-0.39934986718618803},
{-0.8756623339379017,0.3481309737703773,-0.3346943411892643},
{-0.81466136057674,0.4830911385303931,-0.32085794279815405},
{-0.7031635660451592,0.6401542567378974,-0.3094568256914124},
{-0.5461781457187483,0.7895829395604765,-0.27972882349566025},
{-0.37065330679443664,0.8981202124936846,-0.23663518350542911},
{-0.21799212802157175,0.956423623515963,-0.1942505714308763},
{-0.10792001563694928,0.9806317399093648,-0.16344620187466097},
{-0.038054497978474974,0.9884970035191544,-0.14637461944360128},
{-0.0456377797326959,0.9989261567025038,-0.007982888990507775},
{6.472799149440399e-19,0.9998288104958706,0.0185026944635751},
{0.07561962577256662,0.9930910948326193,0.08973154162370367},
{0.12290461520206326,0.9791710483532341,0.1616122322996042},
{-2.999625441527372e-18,0.9835275402927967,0.18075834001672372},
{-4.867523637257723e-18,0.9718911632842505,0.23543059854230125},
{-0.24438213546299983,0.9344126826432633,0.2591337692813582},
{-0.560371450918345,0.7910272058747582,0.2454787089782774},
{-0.7610090345491242,0.6122525759406388,0.2145041551780815},
{-0.8394492868937447,0.5022127431468169,0.20762286809148167},
{-0.8160651392949974,0.5181158165539324,0.25611264916846366},
{-0.7759984360643537,0.5492608362632123,0.31006283391131234},
{-0.7198128795526142,0.589540209925226,0.3664856877307683},
{-0.6523868425654006,0.6307824441659858,0.4201248811716965},
{-0.581942194387542,0.666161611473635,0.46644612742551755},
{-0.4976883216493141,0.7177337229748989,0.4869955209224004},
{-0.37814647726591266,0.7716906647534553,0.5113694942639332},
{-0.21256989421380365,0.818253055165244,0.5341123269375802},
{0.0,0.8368608940631033,0.5474156044431903},
{0.0,0.8303703337702539,0.5572119065438901},
{-0.18465756733510005,0.8148764290394971,0.5494342437650936},
{-0.3279885818306116,0.78442166333715,0.5264087235942458},
{-0.3444498651580216,0.7902996917129685,0.5067353230938294},
{-0.37547874777380325,0.7970585264252397,0.4729835255302686},
{-0.42507438458714164,0.8018660121275543,0.41990792581531},
{-0.25932904018395314,0.863141497946033,0.43328420631353226},
{-0.80067253492194,-0.032234107319655404,-0.598234447476054},
{-0.8424489034288613,-0.061203852635717926,-0.5352886450636278},
{-0.7912317188744457,-0.06736147369543927,-0.6077950303421119},
{-0.757503998053044,-0.034625601740367336,-0.6519116202659463},
{-0.7496916594676253,-0.07101989163480052,-0.6579654935609157},
{-0.787654665147538,-0.10641708204724598,-0.6068570944793095},
{-0.8398906888991037,-0.09853243198040702,-0.5337368176813508},
{-0.8881545052067756,-0.08761355763878488,-0.451115771613876},
{-0.8900193513151735,-0.053141635047556375,-0.45281510675880754},
{-0.8524677817633813,-0.02837361636245557,-0.5220092134722684},
{-0.8431344366744804,-0.0010873420870734917,-0.5377017197115814},
{-0.792288998916615,-0.0011028652906210647,-0.6101450039817248},
{-0.7451247977577395,-0.1108728704635428,-0.6576444650125646},
{-0.7805454224390308,-0.15096839792937067,-0.6065949112349315},
{-0.8343995719727213,-0.14253618402177903,-0.5324103591556507},
{-0.883982152737779,-0.12967442589586636,-0.4491771331108245},
{-0.9211590757760232,-0.11584390707733398,-0.37154561807202185},
{-0.9245767488335558,-0.07679849390806803,-0.37317532990515917},
{-0.9262233556084749,-0.04571041649445251,-0.37419360409991037},
{-0.8977285493013447,-0.023950244273243337,-0.4398975307597842},
{-0.8906642789571344,-0.0009515167875617271,-0.45466057318132497},
{-0.8899778876962711,0.02227226559195672,-0.45545944451409165},
{-0.8420222666115782,0.025900063738963017,-0.53882064662429},
{-0.736618014387436,-0.15529217334054754,-0.6582387422349738},
{-0.767893558540169,-0.20300202400819722,-0.6075604175726815},
{-0.8239278683067816,-0.19569442871413084,-0.5318332054297596},
{-0.8756431665710331,-0.1822292192254253,-0.44726005466388996},
{-0.9144316556949227,-0.1658070401835759,-0.36921913884386387},
{-0.9425076158584559,-0.15136823687123294,-0.2979379984414609},
{-0.9482342971382742,-0.10515411215591944,-0.2996570213216828},
{-0.951399746903921,-0.06943566215608882,-0.3000286826490103},
{-0.9531852268418224,-0.04151788145766007,-0.299523269296012},
{-0.9323098465178394,-0.02080274621517348,-0.3610617618023123},
{-0.9272491502788178,-0.0013343265216902772,-0.37444256285836935},
{-0.9269134194212992,0.018072380984889214,-0.37483983505258833},
{-0.9259848163127885,0.03936212278527072,-0.37550331988946345},
{-0.8886404658775372,0.04539563258573414,-0.4563522312283513},
{-0.7076077484234395,-0.1576953427650552,-0.6887840396244108},
{-0.722281954227687,-0.20576336563872538,-0.6602804070681315},
{-0.7465056646829673,-0.2646794025384287,-0.6104703977001191},
{-0.8050447674430599,-0.261136289780897,-0.5326450605910253},
{-0.8597927728051276,-0.24918250467554443,-0.44571792335028726},
{-0.9014608888050178,-0.23101564468612373,-0.3660601560742738},
{-0.9318643602101042,-0.2122615438729974,-0.2942343473540518},
{-0.9522087788056188,-0.1939124712353141,-0.23600083700047686},
{-0.9620314317391013,-0.14325092520615662,-0.23232455051843973},
{-0.9673363285467893,-0.10115082968651982,-0.23244125521805917},
{-0.9706143627480189,-0.06842117945681728,-0.23070825955954577},
{-0.9740874890100762,-0.04263699132286489,-0.2221162999983987},
{-0.9581785643973911,-0.020762422216508102,-0.28541681897368637},
{-0.9548638146234262,-0.003241130055217406,-0.29702624563961444},
{-0.9548458742893053,0.013175554464002716,-0.29680930092781477},
{-0.9542019229097314,0.03284334819033415,-0.29735501474671583},
{-0.9526186107713223,0.05694100750536353,-0.29879006689712806},
{-0.9240849770306301,0.06373521463435536,-0.376835212847489},
{-0.6110991000990796,-0.40466209466524955,-0.6802988159619474},
{-0.6637789653584778,-0.3302743337069154,-0.671056144925357},
{-0.6992961858886934,-0.2637765959154721,-0.6643844909754981},
{-0.7116660360598449,-0.33782053489363617,-0.6159616378663894},
{-0.7721755360788068,-0.34215617218207284,-0.5354195507441983},
{-0.8304658661003848,-0.33545808228427987,-0.44474073376776624},
{-0.8765819376682077,-0.3174714353244412,-0.3616849379043722},
{-0.9100936081546455,-0.29010373363644326,-0.2959213546303378},
{-0.9351475309018714,-0.27258628157862946,-0.22626492115056135},
{-0.9661331721423844,-0.19244812383232915,-0.17190233657373782},
{-0.9758873178234013,-0.13875360524341834,-0.16849741820989875},
{-0.981006489241707,-0.10143560808345241,-0.16533930409434053},
{-0.984442552368138,-0.07162476474474042,-0.16044548657461977},
{-0.9876172332389241,-0.051876290481432524,-0.1480575938457012},
{-0.9879859019012166,-0.03198034144858874,-0.1511989266009232},
{-0.9761598172437905,-0.02248552956032891,-0.21588518281475655},
{-0.975092798907908,-0.007911832016599884,-0.22165612202707916},
{-0.9753533293550615,0.007043137772904904,-0.22053633969554498},
{-0.9749186354214979,0.026237749734507494,-0.22100958078045815},
{-0.9734944404875135,0.05074040743339777,-0.2230111777319599},
{-0.9706066225143648,0.08195122943773925,-0.22628915202656197},
{-0.949576250949934,0.08706236160699635,-0.3012060570826563},
{-0.9206156678473737,0.09282238259206022,-0.37927667658830166},
{-0.9145360851724712,0.12898453722744652,-0.3833884949677441},
{-0.9039642358599482,0.1756826557908837,-0.38985159322542445},
{-0.9164774689229215,0.24722941980621835,-0.3145578848779924},
{-0.9089528094047274,0.33888010303156874,-0.24282723497286418},
{-0.8474220353199695,0.47917838885421415,-0.22861313546959627},
{-0.7476636934495877,0.6312157105727622,-0.20631463405062606},
{-0.602379198999185,0.7806374264562301,-0.16656683051824625},
{-0.4260857183222739,0.897376971414769,-0.11474115136361705},
{-0.2572892746174326,0.9641655867908664,-0.06470664892466307},
{-0.12824900158775382,0.9913398164614263,-0.028241138255566282},
{-0.1909582348690563,0.9793187741797413,0.06685574825535304},
{-0.07561962577256662,0.9930910948326193,0.08973154162370367},
{-1.3877148891677443e-18,0.9937808716625913,0.11135339742253164},
{-0.12290461520206324,0.9791710483532341,0.1616122322996042},
{-0.1816268591429197,0.959269193656723,0.21636612058975016},
{-0.48483047248663214,0.8471788893145656,0.21731852762276874},
{-0.7337744499500041,0.6539672610440019,0.18412462649839934},
{-0.8456943601106444,0.5072993896134727,0.16567552195434845},
{-0.8809597720541917,0.4387082519467804,0.17732723901315053},
{-0.8600305976928324,0.4564806526732308,0.2279754038643878},
{-0.8250465286912573,0.4886229947331478,0.2838059099323277},
{-0.7746872696838508,0.5312291385708803,0.34300909102095395},
{-0.7117144677962672,0.5771943962185423,0.40038624514759324},
{-0.6426710547488589,0.61933200856401,0.45100086314336285},
{-0.5871185700960597,0.6488902835138735,0.48397642980794336},
{-0.5283463559581408,0.6892417907556158,0.4957780572209157},
{-0.4491632585821632,0.732458725097894,0.5116215233625541},
{-0.33989081499811724,0.7766078005763477,0.530428654923434},
{-0.19096105226068638,0.8143366875012307,0.5480781293839544},
{-0.32555960712081805,0.7800319418977257,0.5343791835678123},
{-0.4256639095764332,0.7451220747832067,0.5134231488303537},
{-0.4403831678220448,0.7486380904056611,0.4955841755875444},
{-0.47183663045711527,0.7498968498309856,0.4637077838169635},
{-0.5234584375006682,0.7453102620944504,0.4129211515847311},
{-0.6003672060197068,0.7260949982981572,0.3351794614568296},
{-0.49963212877612856,0.7973791433830469,0.3384586202068904},
{-0.3142834868948959,0.8820127963955683,0.3511115447541647},
{-0.3974563205662255,0.8901663142204377,0.2227833168555467},
{0.0,0.9788805477582954,0.20443305315046184},
{0.4944710109769644,0.8674874260510168,0.05444249210681218},
{0.0,0.9998767241364381,0.01570148178310708},
{-0.5878373430729971,0.7983182928353862,-0.13090134228980962},
{-0.6677917966772088,0.6714726378960851,-0.3212142787104867},
{-0.7200748927597711,0.4858473418341959,-0.49542356549688893},
{-2.0429549741421867e-17,0.6565187978754567,-0.7543096632260289},
{0.6741168992859569,0.2858281175462415,-0.6810790653933352},
{0.7071380437274682,0.018384553115970998,-0.7068364699985529},
{-0.5521731007828138,-0.7739599488941111,-0.30998526461707443},
{-0.6357277647530687,-0.6956463197584244,-0.3345540418656259},
{-0.5505492316404017,-0.7911063701471718,-0.2665450330670771},
{-0.462065489000459,-0.8526182537131081,-0.2440032731542282},
{-0.46388390295211446,-0.8378655547843354,-0.2877377915530929},
{-0.5518215886349102,-0.7533538974104323,-0.3577021660165839},
{-0.5484012400224932,-0.7287477520350533,-0.4101009556751218},
{-0.46242490940514624,-0.7952534801247381,-0.39209068531544505},
{-0.45646319165955124,-0.765435593987624,-0.4535964132538851},
{-0.4446721306542965,-0.7281461280044298,-0.5216032136514545},
{-0.4128483157315113,-0.6893205390796656,-0.595309551914442},
{-0.40338240979583134,-0.6295567164745889,-0.6640338637517234},
{-0.3823801207534748,-0.5901732340051733,-0.7109718680204112},
{-0.3681359626048383,-0.5643484661534045,-0.7389091431206605},
{-0.3627667846695047,-0.5551403776606352,-0.748478069839963},
{-0.36731741086860503,-0.5650662591137334,-0.7387679219375969},
{-0.3942250812084428,-0.5887139940280183,-0.7056928641992741},
{-0.4688566851784171,-0.5354542550421261,-0.7024686110573116},
{-0.5423233383210194,-0.479035952931563,-0.6902245667254204},
{-0.5830961316419935,-0.5097234755069308,-0.6325985138943012},
{-0.6571931277954851,-0.42266834863212605,-0.6240582183121851},
{-0.3715526193595894,-0.9005614675155563,-0.22569380645745554},
{-0.27995625242868377,-0.9363035155682973,-0.21203825942629864},
{-0.37290556453385365,-0.8879955834162555,-0.26908229925603055},
{-0.37237478170517335,-0.8483783265663758,-0.37628611050962296},
{-0.3678851335622289,-0.8185750276979316,-0.4411297456908016},
{-0.35827766306971165,-0.7796039018304881,-0.513668056624105},
{-0.32903861864641815,-0.7349875348091892,-0.5928970493385576},
{-0.3236918870276041,-0.6723165092353596,-0.6657432490698568},
{-0.30553527555772786,-0.6286131908589516,-0.71518784362431},
{-0.29300842438343,-0.6000095831694645,-0.7444021516258166},
{-0.287671195528792,-0.5898157157989321,-0.7545612663393404},
{-0.29639448709320776,-0.5960297174440132,-0.7462565805032234},
{-0.30180433802391265,-0.6298006567596526,-0.7157270948448564},
{-0.4024750305182558,-0.6485070820234337,-0.6461055752543702},
{-0.4884270250760799,-0.5795970619634299,-0.6523084293021901},
{-0.5416524896755491,-0.6302182560934474,-0.5562710940852609},
{-0.6380287399368388,-0.5346337267144703,-0.5541535033490331},
{-0.7169826174857113,-0.4406993314209557,-0.5401111232963643},
{-0.7764492719006476,-0.4374106333311298,-0.4536501581767761},
{-0.8168132978698963,-0.4435088376692015,-0.3689389479740761},
{-0.8693775144759911,-0.40516854259092877,-0.28288016794800386},
{-0.902194833779266,-0.3789829228957604,-0.2059524849458939},
{-0.9516319114318006,-0.26203486447722796,-0.16041955910380284},
{-0.9728918994123567,-0.2043478054252856,-0.1082743112454961},
{-0.9812500729871884,-0.16059170025222141,-0.1065767332617117},
{-0.9870703162664956,-0.12441674704925047,-0.1010577250844447},
{-0.9911700598282025,-0.09413014290295772,-0.09338858975927611},
{-0.9940060139924931,-0.0688156610970696,-0.08494968472295127},
{-0.9958859742964979,-0.04790182710178746,-0.07691905589530863},
{-0.9970437788902382,-0.030933282617950645,-0.07033374014476816},
{-0.9890195711962532,-0.016678113810034634,-0.1468404859380372},
{-0.9894946898531386,-0.0012450465537015788,-0.14456385651856457},
{-0.9892444771204956,0.019365722402484464,-0.14498390697738547},
{-0.9879219700680092,0.04606581102945898,-0.14794634875907492},
{-0.9850000026729423,0.07986122850797824,-0.1529613641266976},
{-0.9798523571857171,0.12096642408725754,-0.15892288180477923},
{-0.9654733788625546,0.12165299542835611,-0.23035126092780717},
{-0.9441277555431333,0.12569714030947948,-0.3046686891216499},
{-0.9344046758664238,0.17689516992525978,-0.30918602907647175},
{-0.9397942646930268,0.2379898609157024,-0.24525000744427652},
{-0.9569495637831935,0.2345360841003963,-0.17099812171485265},
{-0.9295207400237466,0.3306908954507234,-0.16320148752908287},
{-0.8807082376487763,0.44873783461026834,-0.15161581687566147},
{-0.8036774807069899,0.5816273199045066,-0.12574644227637952},
{-0.6875420625377427,0.7213552187226319,-0.08326200011392083},
{-0.5288597442755949,0.8482297257928093,-0.02852548275153091},
{-0.3499351167298261,0.936414596220616,0.025944518963815447},
{-0.46970231680692837,0.8783142832174362,0.08912773688614123},
{-0.2832205223223777,0.9494874452648371,0.13512855738108387},
{-0.24969051223504707,-0.7732143113770541,-0.5829187565874921},
{-0.17895980810298573,-0.8457602732215581,-0.5026558935533711},
{-0.26920700467299435,-0.8186774144683066,-0.5072424269266944},
{-0.2766494068662797,-0.8588830995144493,-0.43102775670365867},
{-0.18416114881087073,-0.8868558973065901,-0.423758526381692},
{-0.16966406415746482,-0.7894553744318936,-0.5898934794640219},
{-0.23699542051608694,-0.7106853184108264,-0.6623892728975203},
{-0.22819724906152128,-0.6569740263991278,-0.7185479414469657},
{-0.21812837430793802,-0.62600081196692,-0.7486941937390278},
{-0.22034191142783843,-0.6130168927409679,-0.7587224336228204},
{-0.2169519313594084,-0.623521528139664,-0.7511010340998079},
{-0.2161152557324422,-0.6632008219271626,-0.7165604412991532},
{-0.3110450515051128,-0.6939661186663985,-0.6493550662598052},
{-0.4335819965333054,-0.7159636880153057,-0.5471769820868881},
{-0.28090982414761956,-0.9099857380935827,-0.3049846343074203},
{-0.18741504614913668,-0.9512887430497708,-0.24479650288291274},
{-0.28054395302216323,-0.9254294237570596,-0.25470663922908443},
{-0.3735619958995773,-0.8709978364985984,-0.3190833810061015},
{-0.1875178570367302,-0.9610682000099882,-0.2029407997961814},
{-0.18734899444693387,-0.9369327408641488,-0.2950548989197035},
{-0.28003708605356853,-0.8884705213763484,-0.36359230338370163},
{-0.46439702191159843,-0.8190270826929921,-0.33694219660803115},
{-0.2322630648589863,-0.8078541099270369,-0.5416877382554504},
{-0.22398584672522648,-0.7251303728579381,-0.6511653267993398},
{-0.3294343636731603,-0.7711708787778145,-0.5447646058219212},
{-0.15160981296780673,-0.6443053229366873,-0.7495899648790114},
{-0.15156252149671554,-0.6761587717959924,-0.7209980009687216},
{-0.7478246264939253,0.5675069871980176,0.34452016993298096},
{-0.8203271853441757,0.4338011648502024,0.3726658803270162},
{-0.722618176325798,0.43129120460026715,0.5401952129351283},
{-0.5625088662521277,0.4256831831974988,0.7087860064438283},
{-0.612125600598868,0.34660585751322365,0.7107507500024168},
{-0.35569850098459777,0.35952659048716384,0.8626814053461365},
{-7.215457119713179e-18,0.3604928792391326,0.9327619653576578},
{0.3556985009845978,0.3595265904871639,0.8626814053461366},
{-1.1192619853881325e-17,0.3344609677149856,0.9424096036624178},
{-0.3331508454663268,0.3243168311221415,0.885341237724734},
{-0.42112723119204054,0.2998866917907637,0.8559905532395302},
{-0.4406823036850106,0.2881724154919874,0.8501504373746951},
{-0.448429757978763,0.2877765675414997,0.8462242015761193},
{0.0,0.33142323871173573,0.9434821868174426},
{0.44533855958290897,0.29991733852265295,0.8436368634679902},
{-0.6665472986240467,0.6856265910144501,0.2926275386748314},
{-0.5957001173866988,0.7708728934282213,0.22560219928687686},
{-0.7132739297167607,0.6820903458854803,0.16122363733719425},
{-0.7965698143752419,0.5700595168227816,0.20126767774774332},
{-0.862060738516227,0.44527148404673866,0.24204253469932172},
{-0.9130928594627686,0.32233380059900474,0.24972455023386417},
{-0.8550675064650036,0.33408374105296285,0.3965445918831551},
{-0.7723537404860528,0.33523206790635635,0.53952679285132},
{-0.7895765633998503,0.2710440071925414,0.5505488140888977},
{-0.6204201381500405,0.29689581231696366,0.7259006328737665},
{-0.6323744112206852,0.7742076984671694,0.026552658387820016},
{-0.6684190357482241,0.7436150062711262,-0.015897015374187643},
{-0.6330102514880814,0.7738226954908528,-0.022281325235869356},
{-0.6296216721493453,0.7767553346283363,0.015089734466975634},
{-0.6304384117733136,0.7758527829600946,-0.024492205572754545},
{-0.6277173494329475,0.775685755921007,-0.06544109780658208},
{-0.6628849148761157,0.745916328929462,-0.0647488985703955},
{-0.7302733387861596,0.6805924411016465,-0.059116662400855884},
{-0.7354959404339703,0.6775200559274924,-0.0035064827330844968},
{-0.6669494688695526,0.743866526810442,0.04290683238822745},
{-0.6181337710923622,0.7821646931629486,0.07828814600209727},
{-0.6222215416556538,0.7814471548066336,0.046697937259353145},
{-0.6503194127652813,0.7589220320549829,0.033496427304346404},
{-0.6556190805578036,0.7550565417661504,0.007296570748081764},
{-0.656728971462602,0.7537188245318145,-0.024799023933465246},
{-0.6261093446765709,0.7771917029866192,-0.06292968550241965},
{-0.6199815558399497,0.7778717706696531,-0.10265660628295702},
{-0.6540039022817736,0.7492153865375755,-0.10466709308834272},
{-0.7205695168116736,0.6856675785726879,-0.1031481610890769},
{-0.809093185980309,0.5797630213789258,-0.0961408104907203},
{-0.8180393602248154,0.5731659231869014,-0.04787932351529291},
{-0.8216787234117722,0.5697673148026862,0.014466598595981},
{-0.7323873500687198,0.6776193971174537,0.06663874330670577},
{-0.647324256213605,0.753264417724334,0.11646469124985091},
{-0.5723529753610421,0.8072866636967642,0.14387603765988993},
{-0.5976280059027318,0.797942427020831,0.07828569295107622},
{-0.6442432899275984,0.7631867262673487,0.049966030786839054},
{-0.6986249861940677,0.7142140152702064,0.042678672155402365},
{-0.7013644843781539,0.7123425713539154,0.025610956441691392},
{-0.7048549408896845,0.70934820651826,0.002152722166718212},
{-0.7073532679906888,0.7063563429965194,-0.02668465797937587},
{-0.6544714923251436,0.7536915844379396,-0.06013369505632901},
{-0.6198587204437183,0.778449031146575,-0.09895591238948329},
{-0.6114854899210486,0.7795289322519544,-0.13572081416696238},
{-0.6438176558537633,0.7524676286350802,-0.13889310230268592},
{-0.7089270834448235,0.6914421652368462,-0.13903281084333302},
{-0.7975947575528475,0.5883109740049214,-0.13316456206361751},
{-0.889203211995805,0.4421902887691063,-0.1174112272938072},
{-0.8977167270538218,0.4330458357222185,-0.0810924295567681},
{-0.9091003829217481,0.4158078871939921,-0.02530404550262836},
{-0.9033046891324317,0.42620482646299307,0.048888490373613716},
{-0.8167742837774735,0.5691666688796202,0.09449376908702417},
{-0.5324876557185789,0.8380623355793113,0.11877886255846218},
{-0.5884210651108615,0.804544873422157,0.08042510045952489},
{-0.6415872897535366,0.7641342735894717,0.0668173746311681},
{-0.6989511406656643,0.7126159359592125,0.060380715291741646},
{-0.7622330165064808,0.6450060814915637,0.054479201410532495},
{-0.763664100028567,0.6446337017477306,0.035560271351282875},
{-0.7673922386808361,0.6409482288567439,0.017161583196723496},
{-0.7724201872797364,0.6350810263981549,-0.006256531930946242},
{-0.7775511823399165,0.6278684929739091,-0.034573318794562005},
{-0.7082331260833518,0.703360818115425,-0.060740420299855276},
{-0.6505371525840848,0.7534088931833471,-0.0957938034532235},
{-0.6130633248398379,0.7789849014032784,-0.13166580088256882},
{-0.6030550713447566,0.7803978842896632,-0.16523838271294033},
{-0.6335643203826473,0.755147919735418,-0.16836826083720477},
{-0.6970177805045521,0.6970272399215887,-0.1682832150507004},
{-0.7854963829576531,0.5975017293813278,-0.16120519764190727},
{-0.8797425576160295,0.45361148349101393,-0.14244175779696272},
{-0.9437757926522747,0.3087119410296304,-0.11825477017561971},
{-0.949481453434902,0.2984045873127077,-0.0971579737020003},
{-0.9543132693035545,0.2920487197806779,-0.06319595956727277},
{-0.9621878445725791,0.27212426950948204,-0.011955488308931445},
{-0.953212104061958,0.29741916321224293,0.05411585741632621},
{-0.9425879614571617,0.30539215075161913,0.13514277330043353},
{-0.8932561965983346,0.4285303168779023,0.13584967705225565},
{-0.5128573373506462,0.849218519292979,0.1257189644224208},
{-0.5843854941219977,0.7996366371824166,0.13811170383202448},
{-0.5138789118156861,0.8442078137707096,0.15245206184110782},
{-0.6467232297599661,0.75202422528609,0.12731311272486448},
{-0.58196522562108,0.8062374666719263,0.10629027943438556},
{-0.7739360055874772,0.6065528484606447,-0.18197994746558893},
{-0.870303910802371,0.4663784454109044,-0.15831060766166757},
{-0.9378248029298264,0.3222871192282292,-0.1289017136782968},
{-0.9715317225684945,0.21277713690793673,-0.1041729429955544},
{-0.9748876901241808,0.20028779219145157,-0.09735908762623663},
{-0.9780774498285814,0.19243440557151528,-0.07958330031580996},
{-0.9806796713118214,0.18959622306743573,-0.04817317172764527},
{-0.9827997885433105,0.18460679532911997,-0.004990667043270891},
{-0.9784481461216504,0.19706931285381188,0.061667749127334644},
{-0.9657669991419027,0.21572046673203604,0.14407908800848548},
{-0.9426230207036334,0.23109957716117766,0.2409456915478726},
{-0.6858813371112934,0.7018817224181166,-0.1921687777392635},
{-0.6240502712906367,0.7569294524964489,-0.19395634262768743},
{-0.6761812072966786,0.7056834308607994,-0.21163617438268326},
{-0.7636163317314129,0.6149947186523965,-0.19665094442366776},
{-0.8613826698631767,0.4799523677746369,-0.16632985518813312},
{-0.9317606199666901,0.33878594846169097,-0.13056120482058187},
{-0.9678778072307876,0.22996469456771618,-0.10163065247502442},
{-0.9854325713924293,0.1501519296288713,-0.0798564040489626},
{-0.9874306588282192,0.13354430547200308,-0.08453763943989163},
{-0.9891990783342026,0.12280774384716239,-0.08002150632132479},
{-0.990970668653611,0.11752095653839771,-0.06454423787229177},
{-0.9924137204645752,0.11779531343243754,-0.03520328915050144},
{-0.9921324276675045,0.1245438605099822,0.012730780802998744},
{-0.989016328325919,0.13043293445565432,0.0695266273740138},
{-0.9782774830801192,0.14827139579982712,0.14487497812251252},
{-0.9550674376282534,0.17204732161524103,0.2413418917370629},
{-0.9134295897551034,0.19547761134840305,0.3569802347768656},
{-0.8889161191124048,0.25489073613227753,0.38060326564033437},
{-0.8349523642476995,0.22441233834560936,0.5024874643565079},
{-0.6893608940866836,0.2602099292724307,0.676071261341617},
{-0.7449824707409565,0.6338074602668987,-0.20806062000946612},
{-0.6629681021915503,0.7093225108660688,-0.23944701095480367},
{-0.7486835173109346,0.6288289414910286,-0.2098741366872059},
{-0.8400391588013388,0.5222261638302014,-0.14701716053417208},
{-0.8460754123627873,0.5081831769645215,-0.1609542023228507},
{-0.7550526022283669,0.6224965034251643,-0.20589723429812248},
{-0.6684051300287639,0.7082094021131875,-0.22731921368356184},
{-0.6092188497894152,0.7570300699788823,-0.23613103609866784},
{-0.6045816961514624,0.7551377275314908,-0.2534718626143675},
{-0.6603386282910276,0.7089115376033461,-0.24778484182771066},
{-0.7447763982480761,0.6349863947646134,-0.20518380802700184},
{-0.8360284528262246,0.5323006237154454,-0.13308821156337228},
{-0.9022273370138807,0.4263641935091123,-0.0648028304795814},
{-0.9104359425934683,0.4045780907544757,-0.08615661852351268},
{-0.918464766049598,0.3800922592003161,-0.10932679461804992},
{-0.8532445216730309,0.49398873933019627,-0.16717927996592313},
{-0.6158097815969165,0.7576018134067184,-0.21637422492619068},
{-0.5885255587461843,0.7791368658466453,-0.21583190445612557},
{-0.5831077800563653,0.7768196447466041,-0.23777417095533568},
{-0.5792596044020557,0.7733014317762045,-0.2578045894099757},
{-0.6022211603973348,0.751872867058805,-0.26835958293018014},
{-0.6612069996073752,0.7054731841753122,-0.25517227529604064},
{-0.7492119739020194,0.6297893970708021,-0.20505300168257823},
{-0.8353821581963639,0.5350396334642252,-0.12597317329357452},
{-0.8960047264662349,0.4406384628940821,-0.05489330713764898},
{-0.9290754000736942,0.3697389886790584,-0.010582118336713563},
{-0.9385323379110784,0.3446130467463724,-0.019972448706853604},
{-0.9489225711410685,0.31242866930328167,-0.04398045675529709},
{-0.9574574578906112,0.27958700418015947,-0.07145854338854071},
{-0.9254210666570098,0.35808518921515514,-0.12397921863017475},
{-0.5858504529489308,0.7615591694546888,-0.27714053871459715},
{-0.6249999607285208,0.7368508722353391,-0.257732111261611},
{-0.587029847503837,0.7674138461379096,-0.25782154079021924},
{-0.5772452581641315,0.768538140938518,-0.2759294073667967},
{-0.5900330401228823,0.7719156652687759,-0.23665844011150847},
{-0.6272612521609716,0.7422054624384852,-0.23595417577132344},
{-0.6895967358294243,0.6840884810518851,-0.23765372293639317},
{-0.687514779756084,0.6779286444196205,-0.26026175418666275},
{-0.6248605452674203,0.7297111399971609,-0.27761655413924086},
{-0.5867663813691603,0.7534075846314192,-0.2967864975277552},
{-0.5773636189282781,0.7616920116732917,-0.2940689220083209},
{-0.6026002170794527,0.746253308182235,-0.28280554874836994},
{-0.7704404246689459,0.5977367951010889,-0.22165801546123495},
{-0.6930445398852246,0.6886092586857494,-0.21332265371389886},
{-0.6309479342201805,0.7462158425929001,-0.21228900246281018},
{-0.6971152291996092,0.6921041828240388,-0.1871420779393182},
{-0.7747315980375284,0.6013916933608835,-0.19524083117715482},
{-0.766559807915632,0.5928826606380362,-0.2467310511530979},
{-0.7639815870681027,0.5857362541343203,-0.27063845848954615},
{-0.6930086361938221,0.6627263584885235,-0.2837830226164346},
{-0.6272581291955794,0.7194884855272735,-0.2981334576187853},
{-0.5904022458309474,0.7413589790031898,-0.319080009353644},
{-0.5806716751157087,0.7511645953948063,-0.31396203009866275},
{-0.6070978429606988,0.7365296510834436,-0.29825539751589997},
{-0.6669239080473357,0.6969478021763864,-0.2635835008424723},
{-0.5999641396262653,0.7774649140368358,-0.18865666859194494},
{-0.6406313787081364,0.7512431824325769,-0.1588241715328193},
{-0.6062868325055459,0.7786866700557752,-0.16144146495817108},
{-0.5952661382248149,0.7803094308686546,-0.1917691757826375},
{-0.6457724142819615,0.7526172778302703,-0.12862823198582904},
{-0.7047234332240429,0.6977318088469777,-0.12858929033182606},
{-0.7011886562438104,0.6950315765730433,-0.1589514892078376},
{-0.6355504448083851,0.7491599070909503,-0.18664154336948321},
{-0.5944456753680226,0.7752353565134769,-0.2136456904495799},
{-0.7884934294286154,0.6061374135405914,-0.10428589384103282},
{-0.70722284712482,0.7004591013179634,-0.09587956969811005},
{-0.7813098304902292,0.6204791225505973,-0.06753226827354683},
{-0.7817272158642239,0.6082392856090351,-0.13765003239730755},
{-0.7787072576367183,0.6046707470742333,-0.16729702488863998},
{-0.6559208117103654,0.6526940763471388,-0.3791547592561257},
{-0.705521670570422,0.6118905501176405,-0.3575319944176359},
{-0.6413722406914172,0.6832381853656321,-0.34903757810406144},
{-0.6143475413692557,0.6969281777474389,-0.3699570427430529},
{-0.5985668345277061,0.7236228376103929,-0.34363895805360123},
{-0.6324092066251974,0.7045486351314538,-0.3219779745729417},
{-0.6967606067503735,0.6376511437523549,-0.3285204342992457},
{-0.7175951731674383,0.5770025222974398,-0.3900323790522867},
{-0.6785497006127784,0.6081020365742658,-0.4120463771379858},
{-0.6425639677477772,0.6550495480845496,-0.3975193541281491},
{-0.6440602018067529,0.6667288885249741,-0.3750453914593503},
{-0.6087220431516651,0.7092948259949576,-0.3554691604036071},
{-0.5897224200731754,0.7349515149877963,-0.33477415951680056},
{-0.6848053201642561,0.6623845116185288,-0.3037901121541213},
{-0.7040551951796765,0.6538599432061593,-0.2770802353307534},
{-0.6185991094230023,0.7205168530436366,-0.31335380371261345},
{-0.6800371718166908,0.6811015471565092,-0.27138556963951904},
{-0.7792215715581836,0.5914169392429316,-0.2074602284654027},
{-0.7600189783883997,0.6163415130917025,-0.20614143622591763},
{-0.6416133643431196,0.6940158623594095,-0.3266102776855448},
{-0.7430985345174026,0.6078013716010555,-0.27996796366363835},
{-0.8086977455610848,0.5497199724889792,-0.20932249800519456},
{-0.8650446121748566,0.48282439512210634,-0.13630268677551452},
{-0.8489712735133516,0.5128039453164,-0.12759267383769635},
{-0.839339691632875,0.5291929427749973,-0.12435317192081924},
{-0.884186839378661,0.43769299934790384,-0.16321296330686993},
{-0.9124471307781928,0.39303442116473974,-0.11386034127096817},
{-0.9005804125466227,0.4269660851941414,-0.08157746399186462},
{-0.8945042378744911,0.4424904131186946,-0.06375266835688603},
{-0.8931252773321184,0.4464480111053588,-0.05487633707251095},
{-0.8433340721512383,0.4863157223310268,-0.22865839359722107},
{-0.7916517887526772,0.5336917391155945,-0.2974232219657011},
{-0.8699582340182453,0.4032838232117604,-0.28378659059152467},
{-0.8987306851325,0.37656453344320245,-0.22468268236330619},
{-0.9177087980336369,0.35552743337901915,-0.17723094009394794},
{-0.9281627434051487,0.33757221652820346,-0.15671285966015583},
{-0.9294303201231255,0.34185324697733965,-0.13890873826680109},
{-0.9228418488264403,0.3748761195830774,-0.08849190370272196},
{-0.9189763240411462,0.3907798151174079,-0.05266547207257135},
{-0.9186389594924991,0.39410252084880043,-0.0280297192843525},
{-0.9221339169221662,0.3866247028925489,-0.013797767030648934},
{-0.9028776958921143,0.23698269738950398,-0.358679616647701},
{-0.8297789628117728,0.43614736760653183,-0.3481987171212888},
{-0.737192838495298,0.5724588745137655,-0.35893948774365625},
{-0.7817202053808756,0.47072141055616246,-0.40906585550898583},
{-0.8633242248131217,0.2772429853983474,-0.42167239641484006},
{-0.8996785167373644,0.0544619661364803,-0.4331425409328953},
{-0.9252884289079529,0.014157943503215375,-0.3789998363651517},
{-0.9254276448976195,0.22611895750641064,-0.30406231452690674},
{-0.9361756895753947,0.2359889100889692,-0.2605461812482667},
{-0.9393626812496974,0.2552637935177469,-0.2289937745754424},
{-0.9379515744861127,0.27511823194521695,-0.21108482269068984},
{-0.9349215812034531,0.29092837222885515,-0.20318050898721518},
{-0.9304621389962695,0.3407720761269803,-0.13459049010459198},
{-0.9288423049431646,0.36101463988478116,-0.08318895561750356},
{-0.9295429641630565,0.3662158126505465,-0.042846894165837916},
{-0.9329925883891582,0.35964572741394224,-0.01340823492467662},
{-0.9394342387820999,0.34268834327940007,0.005292483756858853},
{-0.6946067590394048,0.5941129469163963,-0.40564917922151583},
{-0.6823406537663099,0.6488470516699962,-0.33676213527788135},
{-0.6868489815229925,0.5820414355109692,-0.4352772035486792},
{-0.7046481768480541,0.5489623070427413,-0.44956793959425617},
{-0.7442179312287828,0.45804665120922866,-0.48614086040319837},
{-0.7501033222357456,0.48032151792700845,-0.45457259638829045},
{-0.7804452294848688,0.3157897495439675,-0.5396128963037012},
{-0.767702316802213,0.39341182502657335,-0.5058263424395523},
{-0.7525864576024484,0.46722849959998564,-0.4640163283710442},
{-0.796424328443389,0.18399308764461061,-0.5760684271529726},
{-0.7962548247149357,0.31446478235755826,-0.516807657426823},
{-0.8206593841804364,0.3137343676241528,-0.47758655940893063},
{-0.8632179538642457,0.11714717876205959,-0.49105122200694595},
{-0.8636768446930269,-0.043475204107913286,-0.5021675164413492},
{-0.884529294654224,-0.12075143585515344,-0.45058519464960195},
{-0.8974882284877828,-0.16351783643569165,-0.40960566023097394},
{-0.9395895220465381,0.02725440918137108,-0.34121654010398184},
{-0.9461371987392093,0.07475833145546207,-0.31501681390033354},
{-0.9450006846854719,0.1366785249345522,-0.29714085341080954},
{-0.9388526269836706,0.19120468642476754,-0.28635033210224725},
{-0.9317175989429884,0.2302301529938122,-0.28088501646111036},
{-0.9302145651798547,0.30477663078138817,-0.2044799942703423},
{-0.9276082268714408,0.34277989641688933,-0.14847531799207667},
{-0.9311247690978478,0.35315407478272065,-0.09104319764178032},
{-0.9355946070973319,0.3497801001527838,-0.0481312030547503},
{-0.942020964280446,0.3352041948271719,-0.015318310168106815},
{-0.9505289477082147,0.3105539636699599,0.007138292344191499},
{-0.9484902959092913,0.3165740955057812,0.012124381246127157},
{-0.9592182878427049,0.28262182335811237,0.005018090258805955},
{-0.9699706062212857,0.24252292332376815,-0.018429724067522964},
{-0.9778692823163675,0.20397850581158838,-0.046523498029967816},
{-0.9634410299292361,0.2521316461998458,-0.0906146502142383},
{-0.774242868491909,-0.3482715819019243,-0.528445726474301},
{-0.8704283201911941,-0.19715239490504766,-0.4510936406028576},
{-0.7930923638731362,-0.2948327451466612,-0.5329898261274832},
{-0.6645396332925589,-0.42465639002349026,-0.6148609811946182},
{-0.6835613436737532,-0.37897614141958336,-0.6237956185079029},
{-0.8174593640126512,-0.18707204208531275,-0.5447607174329502},
{-0.8861020282479405,-0.09095102270365496,-0.45447894011059015},
{-0.927956088860736,0.01801809951093957,-0.37225373770628495},
{-0.9225129475734646,-0.07498082037186388,-0.37861291332399183},
{-0.8533532050499704,-0.26160266184500497,-0.45094606633892637},
{-0.7651560246606155,-0.34437896164865417,-0.5440031146044647},
{-0.6582085077741967,-0.4186897300503986,-0.6256680191954751},
{-0.5099644960428059,-0.47719703413009484,-0.7156949094364499},
{-0.5109960736200543,-0.4920378561215721,-0.7048274688802751},
{-0.5261537354734037,-0.45350820728395036,-0.7193695521590283},
{-0.7135209879183243,-0.27320762968947393,-0.6451708230224905},
{-0.831862250031932,-0.06543530481006228,-0.5511110757880173},
{-0.8907270087275755,0.016420574748595054,-0.45424196266764194},
{-0.9245898052099192,0.10318427476654334,-0.3667242800017283},
{-0.9101329439922718,-0.14254675027795105,-0.3890224264038715},
{-0.8434931243250523,-0.27325438046124995,-0.462440691089247},
{-0.7716825073061475,-0.2623668859639387,-0.5793701106091711},
{-0.6727852738765053,-0.3316929708783809,-0.6613166777911995},
{-0.5381213871601289,-0.39164769598629773,-0.7463494187774806},
{-0.29165939145484476,-0.544769633096989,-0.7862320562223101},
{-0.7369311201105513,-0.14208446033579672,-0.6608664996379325},
{-0.8337799622953924,0.03458100315863316,-0.5510128208084061},
{-0.8868290264642426,0.09903425245420212,-0.4513607145746305},
{-0.9172371097201651,0.1652535884355527,-0.3624463216275903},
{-0.6161334081465256,0.057871933653836534,-0.7855128660059698},
{-0.5791799413658378,-0.1248994071043137,-0.8055747846255215},
{-0.5357152453398814,0.07214244462012766,-0.8413112643930679},
{-0.416957440176319,0.0915805891659183,-0.9043005522334013},
{-0.4579333027900151,-0.1353967299249006,-0.8786152831139872},
{-0.4905052108736099,-0.2860961299667648,-0.8231364665253723},
{-0.6134887349112995,-0.25529647895913316,-0.7472986551359518},
{-0.6545258501869595,-0.11296977893549365,-0.7475518313028893},
{-0.6773967939019004,0.04638080496934424,-0.7341542103276545},
{-0.8037275388580701,-0.12681578803648272,-0.5813258975702317},
{-0.7701396052767455,-0.0843733183446958,-0.6322706157458872},
{-0.7880989741033659,-0.07174221679760845,-0.6113534667818504},
{-0.82558841382848,-0.07400171112340476,-0.559399247141952},
{-0.8013897877409863,-0.018902981716355374,-0.5978436964514118},
{-0.755392082619831,-0.04615305041099781,-0.6536456971884955},
{-0.7742475025774969,-0.13580625910874694,-0.6181403277083585},
{-0.805696755643485,-0.18283107881757402,-0.5634053022149903},
{-0.8414762940429241,-0.1398650125449627,-0.5218768291748387},
{-0.8365397386372647,0.01968169501935768,-0.5475526427311458},
{-0.8063788273192676,0.06460276537942634,-0.5878602466203455},
{-0.7096430499792092,-0.10245598433488837,-0.6970721002092785},
{-0.6973869880977583,-0.21587625266820118,-0.6834097104708654},
{-0.7543845442709577,-0.18312410935686313,-0.6303725247322849},
{-0.7446703515733784,-0.0832923091630246,-0.6622148131247685},
{-0.7232393312608775,0.0392961201380981,-0.6894785599708023},
{-0.7100143878579892,0.23787416492113286,0.6627936712867123},
{-0.7188061770047913,0.22879990390754107,0.6564817467924428},
{-0.44533855958290886,0.2999173385226529,0.8436368634679902},
{-1.1314034842200472e-17,0.359475401346009,0.9331545615958409},
{-0.4162114107504032,0.3837878656434073,0.8243026966752185},
{-0.7097478224034046,0.2544638633621814,0.6568912930130968},
{-0.4338831387975831,0.32852485844923196,0.8389379233579022},
{-0.7178207939638064,0.23340003672157716,0.6559403407410898},
{-0.8575384079382595,0.17404422778167075,0.4840831392298196},
{-0.8552135554985469,0.18652604909171086,0.4835471099094384},
{-0.6966743969028418,0.300523462733829,0.651406503687621},
{-0.38721092075615765,0.4871770544085439,0.7827683057616625},
{-0.9270037405386107,0.13735908089375487,0.34899362160854336},
{-0.856456157340831,0.1769628023366851,0.4849402201737084},
{-0.8497113333422438,0.19355154330138497,0.4904369990889739},
{-0.9226403693730724,0.15902536577635068,0.351348376747095},
{-0.9634208782186658,0.1281346077130603,0.23537572882222785},
{-0.9644772834564026,0.10414680144260874,0.24276946563732407},
{-0.9286544854654536,0.12914413742119588,0.34773932534964874},
{-0.9292923448133619,0.1355411194255244,0.34357581814813365},
{-0.8511571639655262,0.2213396413042702,0.47596244118360775},
{-0.6744254186046846,0.3892274258034762,0.6274172182386257},
{-0.3346649543038464,0.6587213533289468,0.6738586996019904},
{-0.986088271624029,0.10549071057272154,0.1284586725308871},
{-0.9671949126655864,0.10279270786200019,0.23230940601750505},
{-0.9686702347035161,0.13318273135752376,0.20961950402475588},
{-0.9833465860591929,0.15981348024286265,0.0865398360201498},
{-0.9677970488337364,0.1870646839518433,0.16845081266265075},
{-0.9292885926488522,0.21685349526142056,0.2989937677705353},
{-0.9299629597560098,0.16272935081113288,0.3296787100593987},
{-0.9658064314938464,0.09580935163848911,0.24091182001664938},
{-0.9855619245733551,0.07761412250767527,0.1504783732588439},
{-0.9942457097780241,0.09120392620322443,0.05618996737060856},
{-0.9884400668185551,0.1512490094400576,0.010486727379492149},
{-0.9682963135360293,0.24259263501587947,-0.05959079315286777},
{-0.9683590603837213,0.24864101715255468,0.021409688510100864},
{-0.9558617043058307,0.267503838743491,0.12153229405820071},
{-0.9205504921156797,0.30636021397989377,0.24234316733874206},
{-0.8229989378078093,0.4064027605562949,0.3968747215173076},
{-0.8434432938034073,0.2894980346190476,0.4525420401352429},
{-0.9987982413450612,0.03945264009527374,0.02907855353220719},
{-0.993815294105827,0.06627201910744347,0.08910208013717236},
{-0.994528048582201,0.05478757422151562,0.0889510106418188},
{-0.9987118164540802,0.04630053296040584,0.02075977655404311},
{-0.9949395152645919,0.060318636259991266,0.08035560394144056},
{-0.9846262232242433,0.07311045080502063,0.15863814964329734},
{-0.9835746253221618,0.08444705870821384,0.15952946655054198},
{-0.9833706881159859,0.10521395569433797,0.14802740719691823},
{-0.992084837887772,0.09303078213281724,0.0843382950322669},
{-0.9983027037619303,0.05091935979497753,0.02826535794376311},
{-0.9994726269551886,0.02842826868431278,-0.015693995887183777},
{-0.9990686721351997,0.03602967021942584,-0.023741339934557286},
{-0.9961005719699619,0.07270952338488544,-0.04996974815083236},
{-0.996742883064954,0.08051620538469373,-0.004556943033804429},
{-0.9966507193651346,0.07872906945730981,0.022115090127460876},
{-0.9990373098516626,0.040314771103024165,-0.017296611091886883},
{-0.9988339792681206,0.023265730457821203,-0.04230115418845623},
{-0.9982417512350763,0.030933288498539116,-0.05056221666218806},
{-0.9945580554037783,0.06900531519998933,-0.07805473019366277},
{-0.9813046798916065,0.14172788100705971,-0.13020880526324036},
{-0.984690770728402,0.1427231072241118,-0.10007097834337476},
{-0.9878413728454584,0.14623880483043053,-0.052760155956624234},
{-0.9614973873753812,0.2443389649169087,-0.12578252777572044},
{-0.8910122346613414,0.38972098559871765,-0.23284061301192005},
{-0.9084554458879442,0.3841170647857198,-0.16481135694162408},
{-0.9075300950003459,0.4075251336476579,-0.10154994886321521},
{-0.9228089376185362,0.38413723124909754,0.0293641315149234},
{-0.8840744009812607,0.44402169732183117,0.14579844250562296},
{-0.7620549634508021,0.5916369097166247,0.2631311455167539},
{-0.5277553410641095,0.7647455843978574,0.3696464407001438},
{-0.6279263445753324,0.542862841414673,0.5576813079164914},
{-0.9963836306150632,0.06687742118045784,-0.05241250975288984},
{-0.9972769174843489,0.06954959326537818,-0.024527615651256777},
{-0.9983697989135237,0.0360049204095834,-0.044287586564066735},
{-0.9953280088245026,0.06992782832367689,-0.06657517311570003},
{-0.9976235945126696,0.037291905662027815,-0.05793511408217778},
{-0.998154252485957,0.023331286187967846,-0.056069058570798046},
{-0.9977569923687687,0.029001433989407098,-0.06033159210386377},
{-0.9968881612170105,0.035012129925424025,-0.07062679932895785},
{-0.997417707543473,0.03043196212327354,-0.06505238166316821},
{-0.9931743275821725,0.0688640154926865,-0.09414086467588222},
{-0.9785515047939467,0.1428023839062004,-0.1484736731417686},
{-0.9416148243991468,0.248663244902869,-0.22699804648088873},
{-0.9467009554644096,0.24684517205278214,-0.20694144572077983},
{-0.9535039619132027,0.24536575793014886,-0.17500239841553433},
{-0.875306876652965,0.39257274680732895,-0.28235529063252907},
{-0.7046732203543432,0.5759013411464956,-0.41445542315321054},
{-0.7254467507314634,0.580003567573189,-0.3705710100042033},
{-0.7525015834981409,0.5828546173308293,-0.3066298450720723},
{-0.7533111881107113,0.6119081050154546,-0.24102017526261962},
{-0.7936985466412386,0.5984393095423117,-0.10914673542578596},
{-0.7933420024388379,0.6085592176465336,0.01625256237562514},
{-0.6341227008581503,0.7726049378770572,0.03114498714646655},
{-0.37867765949852417,0.9242853111412533,0.047957208063400356},
{-0.13144642645880078,0.9897624286951906,0.05560729911269552},
{-0.24156856856430145,0.8729865970155956,0.4237204598705667},
{-0.9971197706292719,0.04442906521745623,-0.0614672366723212},
{-0.9944226843472038,0.07879844637810583,-0.0701022803059799},
{-0.9966697175512517,0.05834236794647333,-0.056970538164096064},
{-0.9974977507321855,0.041368225217697716,-0.057331555242889805},
{-0.9965116909671978,0.045921310051839075,-0.06968273135303311},
{-0.9912207482443434,0.08248809757169012,-0.10333025698665184},
{-0.9921405179470641,0.0728853252775131,-0.10170998971056118},
{-0.9764094426359954,0.1467215940578017,-0.1584215079097613},
{-0.9378283009735029,0.2518459874049312,-0.23885492777246214},
{-0.8502684677114979,0.39504068064625225,-0.3478309840282879},
{-0.8556664272843039,0.39439768473406517,-0.33509018412201247},
{-0.8636151796869098,0.3939994805093511,-0.3145365332878012},
{-0.6912743602921453,0.5711197212177582,-0.44267597951417614},
{-0.5384947306321615,0.8205412787124514,-0.19166490291738614},
{-0.26193148165691993,0.9371779284277559,-0.23041143501326192},
{-0.0622417814981481,0.9691686052867172,-0.23840758201562354},
{-0.9898637804664785,0.09973571426681944,-0.10110629762927038},
{-0.9716244839187008,0.17035135793166054,-0.16409228226993938},
{-0.9743853404604346,0.1551257885691821,-0.1628164549933215},
{-0.9343524161089553,0.2583012239466976,-0.24549142595821083},
{-0.8456365652850032,0.39786887199598714,-0.35580775729264713},
{-0.6758265807181495,0.5585098752308725,-0.4809627345901235},
{-0.6792255615190171,0.5613097552408889,-0.4728466931792897},
{-0.6835214658986134,0.5659600020905152,-0.4609638615873425},
{-0.4320011749650854,0.7061645085063724,-0.5609872295825807},
{-0.19810735607458047,0.7617166292122297,-0.6168802576276031},
{-0.20113589024547934,0.7529814643716474,-0.626548695607842},
{-0.20215998046515185,0.745555622129159,-0.6350418542190207},
{-0.045180875391780305,0.7547728937489261,-0.6544284279894211},
{7.567065009724991e-20,0.7550893931062601,-0.6556218486432707},
{-0.1998153438990455,0.7392651284643057,-0.6430870066943971},
{-0.42439212581874697,0.6823114227767154,-0.5952667014804869},
{-0.6591683279668161,0.5657731264234247,-0.49537650814556744},
{-0.6387936281540236,0.5794396134985371,-0.5061545563743199},
{-0.6071065349285552,0.5992987544618551,-0.5217879436586399},
{-0.5681230612861639,0.6201490552545514,-0.5409725838725334},
{-0.5268856975867383,0.639095085774841,-0.5603114607225029},
{-0.48713015683604977,0.6551261701778913,-0.5775066332510251},
{-0.9958281388287664,0.06499620155464282,-0.06404538781444968},
{-0.9968847362469077,0.06207072500176942,-0.048662590721088},
{-0.9940008100855744,0.09445859188844155,-0.055135868249939185},
{-0.987149733235802,0.12711644452821763,-0.09683394912420648},
{-0.9668725420074227,0.19518513746250163,-0.16449999886276387},
{-0.9220892450728952,0.29186317278657326,-0.2541009887659886},
{-0.9297462164934026,0.27062322550105583,-0.24966986749627543},
{-0.8394316655706946,0.4054523737859648,-0.36188789898052104},
{-0.6703117595922545,0.5593261348306223,-0.4876847545779673},
{-0.4315174094232838,0.684337942072589,-0.5877706239720318},
{-0.4333185855367221,0.6893982082183369,-0.5804869627595447},
{-0.4326267192234518,0.6968459625119061,-0.5720487971710171},
{-0.9905136164619923,0.13618793018649153,-0.018320023878382122},
{-0.993248381911516,0.11233354154413089,-0.028962514985897515},
{-0.9950297455184205,0.0930516654466897,-0.03545691880500471},
{-0.9896653080788259,0.13652254809231043,-0.04386538324949927},
{-0.9957055438169414,0.0804333638944481,-0.04583605551126981},
{-0.9917299751030118,0.117231786074572,-0.05223375169318688},
{-0.9882712787375352,0.14915679402910817,-0.03274340265512213},
{-0.9878090611714626,0.15552446123245187,-0.006737998657554028},
{-0.9824146600941897,0.18656099537238466,-0.007512032859548322},
{-0.9815341106097312,0.18719367170936888,-0.03936138947660587},
{-0.9716556782988565,0.2168485294540678,-0.0941379737576576},
{-0.9816424380660669,0.167150920914199,-0.0918623613088805},
{-0.9583583458655361,0.23239954875924052,-0.1659509886875478},
{-0.9089586763382053,0.32489095965919945,-0.2612278489005759},
{-0.8103624636420604,0.44627872898449794,-0.3796682414634534},
{-0.8287692633017862,0.42072522448928434,-0.36896042292454007},
{-0.9934345792049498,0.09419775555973363,-0.06491933215454965},
{-0.9825748882307624,0.17336638840630178,-0.0670125688901704},
{-0.9606795848477339,0.27709351631823304,0.017717744528659644},
{-0.9715336228004413,0.2364872847435545,0.014006567133693547},
{-0.9682934041129895,0.24965127843828538,0.009062158981640289},
{-0.9788616673651492,0.20429920790070463,0.009574435454087288},
{-0.981570427147644,0.19098444475736406,-0.006666214061432306},
{-0.9573811768101249,0.2887768075626717,-0.005407189988534951},
{-0.9599358527402847,0.2784487238115817,-0.031455791700161925},
{-0.9718889657918041,0.23508534179368987,-0.012912019434670869},
{-0.957183631127411,0.26756083380858714,-0.1105020204041441},
{-0.9234749606447022,0.329193340038398,-0.1970424876432217},
{-0.9439149139511295,0.27984873322830356,-0.17524075362525093},
{-0.8876961626945005,0.36815167395603304,-0.27651377488441625},
{-0.7814281651212239,0.48080529322091486,-0.3977389756687511},
{-0.970077720815551,0.23755904919046295,-0.050148915492054524},
{-0.9561014639916888,0.28382618888199135,-0.07288816815967897},
{-0.9391055409590219,0.3150527273166967,-0.13719534230568511},
{-0.8984538306024935,0.3758114279318931,-0.22703850975439666},
{-0.8249275941899769,0.4563619409677332,-0.3335089851564722},
{-0.8588413583302363,0.41359181211854495,-0.30221405356133424},
{-0.744068889487511,0.5170335793023942,-0.42312854497253777},
{-0.9474464242795426,0.3141910013544792,-0.0602435705098776},
{-0.940567953349157,0.3231603830231307,-0.10439967421846515},
{-0.9470292392960237,0.319630914611619,-0.031172076333387942},
{-0.9377894717810163,0.3407940230173006,-0.06641039446024806},
{-0.9351368249440296,0.3406934539455402,-0.09719613712621167},
{-0.9244474972079502,0.3537461558275275,-0.1423393204395876},
{-0.8973577328779074,0.3890536257746901,-0.20829396418473023},
{-0.9186991890993312,0.35618005834707583,-0.1706679992971872},
{-0.8708044594576079,0.41644233151515603,-0.2612955757584962},
{-0.788870750388142,0.49343188412094646,-0.3663439844120589},
{-0.6602839619791578,0.5790888467753068,-0.4782062286227054},
{-0.7024223594692941,0.5505326937371736,-0.45112812153985826},
{-0.876208701794688,0.41278568660254744,-0.24872934655028334},
{-0.8152233594295512,0.47406802956845673,-0.3326715761550387},
{-0.842532295687456,0.44936506112112723,-0.29700231071025485},
{-0.7532779673371793,0.5235964241952835,-0.3980189549434551},
{-0.6204294502968007,0.6023148650651978,-0.502278907108294},
{-0.45111861719940255,0.6684880537886211,-0.5912831091431586},
{-0.9084278591390834,0.3745832630130823,-0.1855968852390938},
{-0.9233503152315814,0.35695327947831446,-0.14145158758888282},
{-0.8925492755709559,0.38520260994860706,-0.23446692723397755},
{-0.8557529705711772,0.42709208396661885,-0.2920260350921754},
{-0.7898068214040647,0.49062327883547674,-0.36809507349098547},
{-0.6901247909460211,0.5640922533391697,-0.4533516324493035},
{-0.7200200998965339,0.5469156194827073,-0.4271467674123637},
{-0.5844698769209433,0.6209369697561805,-0.522333459163808},
{-0.41970808526216513,0.6802053417777735,-0.6009707282243867},
{-0.8985055382149407,0.3549625137897285,-0.25824293136726234},
{-0.9222163493090277,0.3500272627848041,-0.16431043903083917},
{-0.9117549262189221,0.36228185787668016,-0.1935324519788585},
{-0.8757468635372923,0.3855168100244665,-0.29059287705164866},
{-0.9297520550210987,0.3512060424182456,-0.11052344526369648},
{-0.9152841854356332,0.3335475457543356,-0.22583377650982367},
{-0.8994914990742486,0.3130089737160892,-0.3048613216962126},
{-0.8804052973042725,0.33991117995888226,-0.33067643130035074},
{-0.855761571545514,0.37651874759751786,-0.3548320241657292},
{-0.8134770296636716,0.429833447596788,-0.3917886286464033},
{-0.8354437070691588,0.43209024574616123,-0.3396054060959038},
{-0.7662996057892463,0.49939069557031296,-0.4042200481730773},
{-0.6640152301669305,0.5758734306779901,-0.47692092210923215},
{-0.5268107838733168,0.6492488213999348,-0.54858578718882},
{-0.5531467141200074,0.6361612805199621,-0.5378917528884793},
{-0.39305696892328884,0.6916116028449476,-0.6059534718038004},
{-0.9129293059911952,0.2872150234287048,-0.2899441542423014},
{-0.9071933388644476,0.2132964244616283,-0.3626360175601157},
{-0.9232981465301738,0.26077637675145454,-0.2819861945952838},
{-0.9227170546142418,0.3163308429345947,-0.22029079629504936},
{-0.8773752444499451,0.16443369084340526,-0.4507485349305249},
{-0.8944561496255603,0.2533127671900496,-0.36848451578802743},
{-0.7857198267353258,0.4248325052020232,-0.44962394998351984},
{-0.7164674617344194,0.4983540668910728,-0.4881778367449371},
{-0.7433606359575551,0.501123076865295,-0.44304698028746253},
{-0.6409933159928195,0.5817530211160123,-0.5006905144646958},
{-0.5050034040024894,0.6586696055284963,-0.5577866193257361},
{-0.3537125978105837,0.715306062890318,-0.6026812047363354},
{-0.37118313227781186,0.704216278749611,-0.6052293078300839},
{-0.8206618944784461,0.3715151002830209,-0.4341550244011288},
{-0.856837908996481,0.32700279677230176,-0.39862008053989284},
{-0.8203356604828559,0.31294871884156134,-0.4786569789688458},
{-0.778017535509907,0.36513230435127353,-0.5112407600712405},
{-0.7445762472877376,0.42088704333785176,-0.5181315554231677},
{-0.6759351423276251,0.4953745748152181,-0.5456333145924789},
{-0.5804445175600107,0.579106063329619,-0.5724686274804915},
{-0.6170842503234789,0.5815315295481133,-0.530120842963321},
{-0.48484090198844015,0.661685338005337,-0.5719281539037913},
{-0.35168771981839897,0.7162442254519977,-0.6027519865048999},
{-0.7911929944411872,0.24690866166377654,-0.5595084971138423},
{-0.8448709598775853,0.26662392957346437,-0.4637938565077504},
{-0.8782532861862826,0.2897794462841752,-0.3803932673092841},
{-0.8634485253490924,0.21865052821673198,-0.45458617509007215},
{-0.8122765453235381,0.1860937330711986,-0.5527892332787276},
{-0.7274679662130062,0.15895705046888733,-0.6674751038354496},
{-0.7036629332414356,0.2349478689210082,-0.670565414610339},
{-0.7546640654198975,0.3090140569001591,-0.5787853324005525},
{-0.7111245739237736,0.37044611469102406,-0.5975546137986519},
{-0.6780427869256862,0.42446431647530897,-0.6000733481310406},
{-0.605915427433676,0.5010378469661723,-0.6179219778462067},
{-0.5098710605504432,0.5855501543176239,-0.6302083134898913},
{-0.4023782133120175,0.6614221595374824,-0.6329395708316884},
{-0.4609546212804625,0.6581171605978919,-0.5953172599939919},
{-0.32077694563968034,0.71999725171494,-0.6153910209525411},
{-0.19637892667476736,0.7509977168830355,-0.6304266383922354},
{-0.11043072024548649,0.7653283298479108,-0.6340958946076456},
{-0.43030868596082383,0.47474968098738946,-0.7677546321508202},
{-0.6324106159169053,0.37257151588645554,-0.6791518817066393},
{-0.574818628810867,0.44292320520057094,-0.6880425700978446},
{-0.4966785516836924,0.5235663086989008,-0.6922345965731538},
{-0.6511719516139985,0.31124700273853156,-0.6921707829123509},
{-0.488691875085171,0.39747152534337915,-0.7766573490072356},
{-0.22676737547391299,0.5048362630410478,-0.8328966952386253},
{-0.7417074496395475,0.07298365481249464,-0.6667409131584838},
{-0.8266263290467153,0.11685541400669222,-0.5504849901169659},
{-0.7455231783211651,-0.026567903982554014,-0.665949950870095},
{-0.3873911536983289,0.9034366190585041,0.1836582951582014},
{-0.5852517545542921,0.8001274957265442,0.13143962254012875},
{-0.6754145682205472,0.7200342182950382,0.15926671190083966},
{-0.8329855033419876,0.5375795620447155,0.13093267618859405},
{-0.8891978473974551,0.4381424251292945,0.13175129405646338},
{-0.902466908102665,0.40081544923909385,0.15779878146196047},
{-0.8857567785249107,0.4145402657522172,0.20878529011224278},
{-0.8568127213098072,0.44231626214845493,0.26500619774016987},
{-0.8129043759674859,0.4827450239377658,0.32579704939768606},
{-0.7553491879108714,0.5296572299654629,0.38588965141306875},
{-0.6892718008888266,0.5756271364033857,0.4399520250385396},
{-0.6334850877044211,0.6101018598550171,0.47589112647492265},
{-0.6001367913567438,0.6308888991509158,0.4917469151791171},
{-0.5559431412249788,0.6657172802792972,0.4977426307464923},
{-0.5009406828208347,0.701677387152445,0.506662882648723},
{-0.4274455406792518,0.7401889807640373,0.5190477651516454},
{-0.6418416177699428,0.7661729940687048,0.03191051328730221},
{-0.7347232779973719,0.6743880352367241,0.07336540532394988},
{-0.9050684660813145,0.42442574492762647,0.026718135186532134},
{-0.8313707295900444,0.5552730851705591,0.02223760027715223},
{-0.8677357893023461,0.4937212782061634,0.05721799900649038},
{-0.9112261864994595,0.4063244175583802,0.0675818373048212},
{-0.8853431153767838,0.4557789747303494,0.09183188035035698},
{-0.7975268777080758,0.5944821042445856,0.10267378957717198},
{-0.7704237419855101,0.6371371641136147,-0.02243862496466648},
{-0.8870225735484882,0.4614917356116656,-0.014708228226046139},
{-0.9259929370223541,0.37739146499241744,0.010618979969442803},
{-0.9202663544777002,0.3869592190452129,0.058072365306079454},
{-0.9182258585153028,0.38308730484325004,0.10052556700546313},
{-0.9099861247263509,0.3995381391010554,0.11088069358181317},
{-0.943503302661843,0.3164673363744293,-0.09823412275919473},
{-0.9063854302301196,0.4131818919129518,-0.08801236311902552},
{-0.9464066735240378,0.32128490834164186,-0.0330214472891175},
{-0.9165614316984232,0.3978882198513418,-0.04000133030871707},
{-0.8532271743055313,0.51765619155982,-0.06352524196239773},
{-0.9664214048083194,0.23699138409941117,-0.09932145886443641},
{-0.9686442501640115,0.24601795580669825,-0.03469123873391343},
{-0.9594358984346257,0.2793833303474612,0.0377850700529181},
{-0.9400303088877044,0.33974970912230307,0.03021843020074969},
{-0.9565226375578618,0.17356181457576914,-0.23439441196521207},
{-0.9711464291248508,0.1660617093076862,-0.17116694160923798},
{-0.9772626891441669,0.20654507942407474,0.047924592563880174},
{-0.957141237741107,0.26714999130441475,0.1118549648494556},
{-0.936047541168211,0.341788649846266,0.08363922231353595},
{-0.9248115094891997,0.3751074405591901,0.0633883266338677},
{-0.9183367981409938,0.3838517908607143,0.09651594600463752},
{-0.9178710499476691,0.3730077518455011,0.13556530799260055},
{-0.9134042403910743,0.38040026857937165,0.14487349412624256},
{-0.9819391205573763,0.18547948018193772,-0.03732192318791335},
{-0.9788608479715003,0.17440380907866723,-0.1068398412923153},
{-0.9882416568110247,0.12549318715253835,-0.08734922851232674},
{-0.990961275038219,0.13360533850247894,-0.012056736634154583},
{-0.9877303954086587,0.13804708640248387,0.07301827114935025},
{-0.9708608641079929,0.199624082324285,0.13258736101027274},
{-0.9569344607662057,0.24856028387126708,0.14998074236356593},
{-0.9392750523932357,0.32393324534541224,0.11326795006387788},
{-0.9219771634153571,0.3763077166721468,0.09138168587614891},
{-0.9201805970378077,0.3796608286951344,0.09552656169708684},
{-0.9242007747876787,0.3631515478908019,0.11821117183400641},
{-0.9251412710397203,0.34242664602763495,0.16388294819558083},
{-0.9123681746258931,0.3666290736575239,0.18211929134180638},
{-0.9018730762499331,0.38573186463415704,0.1945144800299936},
{-0.879231653197263,0.40529240193672306,0.25037925023525703},
{-0.8421701027960486,0.4396616408468747,0.3121652759746459},
{-0.7907428997413873,0.48415805744979357,0.37458863025327505},
{-0.7285871597696353,0.5316409577882966,0.4318780413736714},
{-0.6738832122216187,0.5697106371147808,0.4704372500601366},
{-0.6397808994200124,0.5940228402043728,0.4876651167069982},
{-0.6256071122524121,0.6075038239048856,0.4894434033063881},
{-0.5871669108314242,0.6421189620016269,0.49286738324080226},
{-0.5455779648731324,0.6746088958117569,0.49723990380553057},
{-0.4943239600128435,0.708401177601154,0.5037971755880722},
{-0.9936449471064558,0.080640180380912,-0.07852948744225015},
{-0.9965649882139588,0.04212482776466291,-0.0713002324814543},
{-0.9966785580696029,0.0814354426469612,0.0003472249855417887},
{-0.9946003696842428,0.02439270927268597,0.1008717024655861},
{-0.9998799452311088,-0.0009110367110570446,0.015468197592026544},
{-0.9992896477463743,0.036328406108518244,0.010022315927055978},
{-0.9930491431316918,0.07709044582300992,0.0889407807938649},
{-0.9976812921945635,0.011048380286892883,-0.06715632880095584},
{-0.9976830939291124,-0.013070964045804986,-0.06676521539654445},
{-0.9994163937917159,-0.030230080500812072,0.015906415475405798},
{-0.994020723371735,-0.01974084931134342,0.10739227335334518},
{-0.9824145740636443,0.0025508984516633883,0.18669519968236348},
{-0.9830900126796284,0.061570762490785864,0.17246178758168798},
{-0.9797971392080311,0.12795243688327343,0.15370666835043315},
{-0.9985820688202465,-0.05207377808089595,0.01105321071263846},
{-0.9926576866908292,-0.05489944066381724,0.10778111369071774},
{-0.9796876358861172,-0.04730998674462384,0.19486893350684187},
{-0.9697262170434222,-0.02603778702202844,0.24280258982483907},
{-0.9736403458105702,0.03597583263815347,0.2252336930298501},
{-0.9735705174036119,0.10361218301950083,0.20353123389887048},
{-0.9681743746404002,0.17519669163791954,0.1787302423452668},
{-0.9902250801511262,-0.106074961800819,0.09056706420465796},
{-0.9953609746810659,-0.09581630656770156,-0.008704336716999474},
{-0.9973842021912799,-0.07224904460526192,0.002197446902887121},
{-0.991470792444609,-0.08157890866577988,0.10163931026015184},
{-0.992208737303121,-0.12287967137653481,-0.02055256630547711},
{-0.9880353748222317,-0.13372750539707287,0.07683132434214669},
{-0.9722348531061763,-0.1501687944430366,0.17946789011167605},
{-0.9742905361744504,-0.1199828263662999,0.1906884173148863},
{-0.9765758388356676,-0.08792449965096476,0.19638969770214454},
{-0.9728407858646418,-0.2294249691145339,0.030740671838156316},
{-0.9730427413278634,-0.22566290838639608,-0.047582300572266784},
{-0.9813828520437669,-0.18748364120960376,-0.04168431351516401},
{-0.9794939799105126,-0.19627089470218492,0.045489330747636614},
{-0.9876440081157145,-0.15339993081949294,-0.032058921655309165},
{-0.9603417987904163,-0.2586918151704531,-0.10402967970633997},
{-0.961837509150342,-0.2694574320562539,-0.04755311032009715},
{-0.9646638966941293,-0.2627885660834718,0.019124224185327148},
{-0.9515586864944254,-0.28733194149548213,0.10943683819190189},
{-0.9585981077274961,-0.25402535581450975,0.12868871925920905},
{-0.9645481078508239,-0.21870209415893788,0.1477035600515124},
{-0.984537411340448,-0.16406532956790715,0.061389358237593145},
{-0.9255882833481446,-0.34947897612262147,-0.14543306012361495},
{-0.9399535152366834,-0.3289626730189947,-0.09094475770708385},
{-0.880618346520456,-0.4585320977337102,-0.11941374761517753},
{-0.9069010301325243,-0.41606107650561797,-0.06651091761171583},
{-0.9458708817835494,-0.32220779803561694,-0.038863992062701004},
{-0.8435513176126876,-0.5053302692019901,-0.18183094781181414},
{-0.6940900053439781,-0.6824319830903687,-0.229184757208989},
{-0.7977393213163687,-0.5457611891824068,-0.2564306916262261},
{-0.7465517653228013,-0.569685547079081,-0.3436842142761537},
{-0.6376055263395277,-0.6979528601918159,-0.32606900762163404},
{-0.5091893168553017,-0.8052559945854367,-0.3037910841098705},
{-0.5632880159751936,-0.8026857759191546,-0.19596468099072076},
{-0.7536452770064573,-0.6404899343025213,-0.14761924164217896},
{-0.34944921653677824,-0.8416649517386745,-0.41168598965299574},
{-0.46815663116502665,-0.7754010678062564,-0.4237718168320431},
{-0.5866744757953026,-0.6834309996965326,-0.4344365639585425},
{-0.24033677335504824,-0.8841900516363482,-0.40055734665662573},
{-0.3769234725138922,-0.882749923144727,-0.280501816493312},
{-0.4208775279219942,-0.8925766494226178,-0.1617684499393008},
{-0.6309509252154396,-0.768572230416808,-0.1058189803481104},
{-0.8093484152842716,-0.5815693730905086,-0.08205002717824751},
{-0.8541364536847853,-0.5191736767347463,-0.03015977242128203},
{-0.9221474828370952,-0.38636495862393866,-0.019134749664719782},
{-0.9430495021858413,-0.3323252122581397,0.014750922839581605},
{-0.954942500259307,-0.2965091038044461,0.012929522790408866},
{-0.9441007387131661,-0.31657167795132674,0.09195742428067247},
{-0.9151119243664496,-0.3563329916377937,0.18867157961069148},
{-0.9232558883997664,-0.3222503054060284,0.2091729074256029},
{-0.9318046884415355,-0.2829287794732533,0.22735727026894928},
{-0.9396819488231701,-0.24169551082653112,0.2420353591981787},
{-0.9690851359673838,-0.18347582018460556,0.1649564265333832},
{-0.8846006779518155,-0.46617986028164093,0.012568947250185014},
{-0.9268210908743757,-0.37452173891786883,0.027131763458497965},
{-0.900747828478997,-0.43128920525211817,0.05140983294436832},
{-0.8244170947815077,-0.56320321102671,0.056023181998363494},
{-0.8577479988864307,-0.5065388974516434,0.08767391730039915},
{-0.9036983665207445,-0.4183236029184436,0.0912941706193252},
{-0.9208742204078904,-0.3824266127641821,0.07576645720815078},
{-0.9300287379927665,-0.36032035877922214,0.07222039571197887},
{-0.7722940526472156,-0.6350347740824659,0.017109411204698395},
{-0.6546683906188541,-0.7525482246266176,0.07127740129834424},
{-0.731068074869514,-0.6735211891921121,0.10912688768505188},
{-0.7872122796432153,-0.6016391249916726,0.13537795262961666},
{-0.8731581425704055,-0.4727200469614301,0.11887226448496176},
{-0.894391368327735,-0.42623099124910846,0.13561424099129218},
{-0.9038582511816552,-0.4079772492010773,0.12882090632021617},
{-0.9052209171681278,-0.4032163193005073,0.1341331091529793},
{-0.9052888991004963,-0.3979597215307533,0.14859363783344423},
{-0.9368860752815658,-0.340666968107618,0.07867972282530984},
{-0.9086902301214652,-0.38230620228548834,0.16770221637129945},
{-0.8639671302475691,-0.42825655658913564,0.26487189279007395},
{-0.8749355182502224,-0.3931150307879779,0.2827515012741434},
{-0.8887895730859261,-0.34995828690846964,0.2959430556675165},
{-0.9035342240716983,-0.30239921498028033,0.3036126161911987},
{-0.9176343908762333,-0.253830230837182,0.3058060473475743},
{-0.9463900463431895,-0.20120611968841473,0.25270927482478217},
{-0.5679189746801317,-0.8229402370399119,0.015407934935005767},
{-0.7046404228919155,-0.7086865763146217,-0.035287547069219674},
{-0.4858234655070222,-0.8718429385336277,-0.0621727503959433},
{-0.33771910536799016,-0.9409517555659064,-0.023571159642305283},
{-0.41296266702767376,-0.9086308429879818,0.06206308735746314},
{-0.5962758405963242,-0.7853770673328309,0.16624675644603987},
{-0.503931105223968,-0.854700429426099,0.12466201156162902},
{-0.2852493169399659,-0.9493303253391775,-0.13192710326803367},
{-0.25493389245559805,-0.9313464796952483,-0.2600047023357578},
{-0.8669743137228534,0.39828261569083934,0.2995438154648673},
{-0.8965629778528503,0.37408337882431436,0.23714226200956678},
{-0.9165752557837451,0.3350933737084471,0.21817935599330443},
{-0.8952624851603727,0.3454125788916263,0.2814164760775555},
{-0.8599847266739247,0.3730565840254176,0.34821696541504354},
{-0.8228464898647918,0.43635062428700294,0.3640354197073877},
{-0.9431485784799255,0.3070375856937567,0.1272740345971827},
{-0.9415776524915884,0.27955769478282183,0.1878271003240596},
{-0.9358015707909655,0.3406181306445679,0.0908554301148907},
{-0.9285626557337058,0.3618681946877262,0.08260026664735015},
{-0.9374664503840013,0.345082681256303,0.04554774968515697},
{-0.9475021332191913,0.3147985582816919,0.05604975690268416},
{-0.9592275266025077,0.2707944622934395,0.08095005496750578},
{-0.9635094243647463,0.22964404489165688,0.13752527697159406},
{-0.9618045754135097,0.1836382128047909,0.2029999150529399},
{-0.9287759435011832,0.27163426031244087,0.2521707266872981},
{-0.9036609374644353,0.28338680408117184,0.32107449193848686},
{-0.8663521569333461,0.3128058932961138,0.38934099873524664},
{-0.811438895883551,0.41364259710593526,0.41287615589513116},
{-0.7662284944940913,0.4822162939473166,0.42468969857654143},
{-0.9418250534683026,0.33577219002769515,0.014919955208861019},
{-0.9366113619262875,0.3444835918472472,0.06395476259516747},
{-0.9288451405429083,0.359718348706702,0.0885969214676695},
{-0.9478441922788319,0.30225114902082223,0.10117129078390559},
{-0.9585657981009051,0.27790033888830645,0.06263395530332852},
{-0.9396934045597867,0.33905362674052547,-0.04493265650875401},
{-0.9359680397218815,0.3465800460785769,-0.062016935423720505},
{-0.9425490845898212,0.33406369856908513,-0.0016335351950620247},
{-0.9525926938155171,0.3042450291899364,0.001456675156342436},
{-0.9697825759265879,0.24085127967767775,0.03888979952142914},
{-0.9809119320813735,0.16949304807917653,0.09530943370525725},
{-0.9837787985801406,0.10295578073240319,0.1468992262675217},
{-0.9748877611088317,0.06362106811054755,0.21341558737046992},
{-0.9446473042997391,0.1716630632667998,0.27959481967499844},
{-0.9206018960757985,0.17820481095716806,0.3474697026984722},
{-0.8971883736655097,0.20036666418002422,0.393581277558787},
{-0.8291238775279555,0.34949037444384823,0.43636002782576977},
{-0.7646142849017861,0.4543936783998987,0.4570463656505097},
{-0.7141092334609458,0.5225782875263004,0.465789583494414},
{-0.9731050726537783,-0.10920384572458292,0.20283253598583859},
{-0.9901715863201177,-0.11083122066403396,0.08530340069670003},
{-0.9867842452675745,-0.04253337224372846,0.15635781252396608},
{-0.9611640875685348,0.03169894508138534,0.27415100519471614},
{-0.994159548281356,0.0400269014426324,0.10022295007587811},
{-0.9991610581795266,0.003246606508399034,0.04082449465392635},
{-0.999934319190232,-0.00507820364699917,-0.010274685069944044},
{-0.9902753293698006,-0.1373134447247167,0.0223559821829628},
{-0.9707232138709032,-0.21109730591604126,0.11460527687298659},
{-0.9629453124673182,-0.16685856264786542,0.2118833293780027},
{-0.9500608251961663,0.005260956596312095,0.31202043324640005},
{-0.9879542179856299,0.13300784370447222,-0.07909093928819531},
{-0.9987963434955659,0.002182598461804311,-0.04900102533459864},
{-0.9873829015818836,0.1235777731302736,-0.09901282569396122},
{-0.9975181954035812,-0.004828821414104165,-0.07024337920781895},
{-0.9908187197926367,-0.1325373666077299,-0.026685407270052672},
{-0.9924792096444297,0.1133795785083556,-0.04615289374281712},
{-0.9917940871959807,0.1270971785146994,-0.013812885893032804},
{-0.9652627470489691,0.24299923637644874,-0.09601666667793063},
{-0.9601076424504522,0.2516563840080163,-0.12191135835616182},
{-0.9624635859228052,0.23607134990103518,-0.1339184958417545},
{-0.985600375332588,0.12227967029508319,-0.1167886226341728},
{-0.9956538607897863,0.015107932356657085,-0.09189744215319338},
{-0.9916698700546852,-0.11370487039929633,-0.06051504997273828},
{-0.9651758862851357,-0.26068834935127533,-0.0218424597106239},
{-0.9653410519632594,-0.2583108130222917,0.03731189180717651},
{-0.9517503740644045,-0.28363760465635257,0.1171363935464667},
{-0.961128269296121,-0.17202137198715559,0.21596550080857732},
{-0.9459029663627971,0.02236502200923987,0.3236779016500617},
{-0.9720312159055843,0.23416436085021514,-0.01795459308147676},
{-0.9419010995347759,0.3209811296133021,-0.0989617760923316},
{-0.953042719668102,0.29912047587837814,-0.04729181110848151},
{-0.9225945772135418,0.36775072012550036,-0.11652748149403273},
{-0.9303193537503406,0.34043920502346425,-0.1364076527198544},
{-0.9721930661650587,0.2270755167601581,-0.05724815969696094},
{-0.9898922300943583,0.13639191516952007,0.03886667306586174},
{-0.9284864685912216,0.3451439944878848,-0.13707115200489622},
{-0.9175197760190111,0.3599822449929504,-0.1690273466154484},
{-0.9303850029061144,0.32868021625974786,-0.1623362615278389},
{-0.9602833954278169,0.2613731019175602,-0.09767242220614492},
{-0.960449180889994,0.2449382889917675,-0.13244850136383196},
{-0.9383943282202805,0.2972347231574868,-0.17626004684414676},
{-0.9272970384442282,0.32912803976934185,-0.17831134548915883},
{-0.9378302512579675,0.3068525235844189,-0.16222191157575222},
{-0.9304561899209766,0.3326216358363056,-0.1536688843303012},
{-0.9154233587054015,0.3734304689201055,-0.1501657724604118},
{-0.9331009697425962,0.3460745008255947,-0.09774978334370968},
{-0.9622673424031775,0.2674228760644647,-0.050264968932011767},
{-0.9848184628642623,0.1735764618655687,0.0019511760305801252},
{-0.9846955831901687,0.16617591361583475,-0.05253735984721896},
{-0.9836513632189794,0.15234044128949828,-0.09603325249706074},
{-0.9639315990318641,0.21709844399886397,-0.15396148219975567},
{-0.947751680435602,0.2592227800462932,-0.18593090796466213},
{-0.9388411156821971,0.2903554753477085,-0.18512443771748105},
{-0.9472031559347791,0.2724274250328462,-0.16908423781407778},
{-0.9666593221810643,0.21191059065551615,-0.14374858750080147},
{-0.9628691383959018,0.2698890967787923,0.0065496385137702355},
{-0.9815504011721133,0.18082054357148972,0.06215095318154313},
{-0.9889499795181719,0.10354053367642031,0.10610040479192163},
{-0.9943993077816667,0.09594012525962775,0.04433406194461578},
{-0.9958617244043944,0.089677508681049,-0.014743483410187936},
{-0.9948065015075627,0.07879918487726331,-0.06442602751188739},
{-0.9835809327313109,0.1301946448366025,-0.12497160966905833},
{-0.9682228353264858,0.1844034366969633,-0.1689376029387476},
{-0.9547203724177974,0.22184455258773966,-0.19822715499539362},
{-0.9477704797766446,0.2520333575602936,-0.19547456187656218},
{-0.9544986225770491,0.23800935521396205,-0.1796772838428665},
{-0.9698907723924436,0.18652587025653727,-0.15658859905188086},
{-0.9849484813079719,0.11024443840334906,-0.13312645480989138},
{-0.8912999916702835,-0.30291303286967786,0.3373840828584626},
{-0.8659654068182051,-0.35974567434689897,0.3474002935849012},
{-0.8408326260177341,-0.4127822274286749,0.3501590035157497},
{-0.8327424705442465,-0.4092041595297728,0.3729503097939412},
{-0.8716255648173797,-0.3448207598432608,0.3483784125601066},
{-0.9081749870120723,-0.2753250317233378,0.3153003645290714},
{-0.9149263960089774,-0.24486247354873253,0.3208614326054477},
{-0.8475691172809964,-0.41631032464806283,0.3291083484552422},
{-0.7825406970354705,-0.505083913178124,0.36403337502475436},
{-0.7886600475908336,-0.4823257974267879,0.3812835617629446},
{-0.855306710521611,-0.38664835840540845,0.344896329176035},
{-0.797110482445151,-0.4621521493374547,0.38862613092640824},
{-0.7259836231706944,-0.5435774310607061,0.42127349231751415},
{-0.7071911705862054,-0.5701243628944531,0.41813736867099816},
{-0.6992366202176741,-0.5872606474910519,0.40766785604822314},
{-0.7859388389071501,-0.5167852928412596,0.3394600162025777},
{-0.8580507175371276,-0.42183026493802633,0.292930356426805},
{-0.9132347039595184,-0.31860019982612564,0.25396119419061547},
{-0.9096273306745098,-0.29714285206523033,0.2903174895808147},
{-0.7950483257924751,-0.46620042567508524,0.38801459090471274},
{-0.747860402342098,-0.5195128246784702,0.4132931690740997},
{-0.6759290649768451,-0.5877765522265614,0.4445656574367664},
{-0.6449954683506278,-0.6157228521857613,0.4526214920917758},
{-0.623723460855008,-0.6362207348996554,0.45408393592241697},
{-0.6101784102251128,-0.6506533079453221,0.45203161455252666},
{-0.698673350388674,-0.5974293316713424,0.39361623837870113},
{-0.7941958079495848,-0.5211702227945817,0.31246538609508806},
{-0.8675256681879688,-0.4271697860568372,0.2548042168316182},
{-0.9184200976489774,-0.3332955957518226,0.21311632993949675},
{-0.9626681091210113,-0.2361338901061254,0.13232874829274505},
{-0.9554671229384315,-0.22757178530501937,0.18786606802944092},
{-0.9452095846288708,-0.22140025410159112,0.23991825401471284},
{-0.7635028025233749,-0.5125351793807907,0.39290095499508915},
{-0.7096099244076514,-0.562214559463496,0.42469818025208744},
{-0.6429364386385513,-0.6180220945405812,0.4524173145785309},
{-0.5998888677687919,-0.6466773910046787,0.47110688626941016},
{-0.5672193558353748,-0.6683372193416539,0.4812354554772212},
{-0.542127878941534,-0.6842725569366833,0.4877175726767356},
{-0.5210935194827077,-0.698084834688881,0.4910591690728545},
{-0.5990208303235914,-0.664032250339434,0.4474764969778661},
{-0.6988563152790161,-0.607477378997966,0.3775858638778706},
{-0.8007179600147839,-0.5268674809827099,0.2850638630073913},
{-0.8778466215915314,-0.42667054206732513,0.21757195934290244},
{-0.9312673679422714,-0.32557287900730786,0.16353406330415368},
{-0.9665274660880656,-0.24111070143230953,0.08769428118299898},
{-0.9852605155310467,-0.16848964946369013,0.029545804424642212},
{-0.9839962375009755,-0.16062597461640774,0.07714078598544988},
{-0.9780103025289819,-0.15775588127612158,0.13641455226611093},
{-0.9683797968062107,-0.15508031759995558,0.19542431842188787},
{-0.9368685849526033,-0.20947711933075536,0.2799939124441728},
{-0.9348443574119164,-0.18924236961736146,0.3004219581800023},
{-0.9303254008679614,-0.20664451537370218,0.3029730891776271},
{-0.951845295538116,-0.16345096075180415,0.25937292995081174},
{-0.9573677816513438,-0.1249562608757249,0.26044742948230976},
{-0.9637465181240085,-0.079553775469541,0.2546838149792642},
{-0.569919177688476,-0.6678541881941962,0.4787096345535176},
{-0.6087952589823382,-0.6487486695521664,0.45661088072331524},
{-0.6630847819500637,-0.61539304693812,0.4261572124538703},
{-0.6597715519570055,-0.6270480258014369,0.4141404019976377},
{-0.6083159755247294,-0.6559612580432929,0.4468405776870061},
{-0.5650554843378643,-0.6757406909627818,0.47337809222316535},
{-0.5305988146806913,-0.6925854468410169,0.4886617405562611},
{-0.5329283100928107,-0.6877382061494984,0.49295392898717316},
{-0.7482600682729799,-0.5714804491157858,0.3369227901263658},
{-0.728404755116483,-0.5824133740473924,0.3608617109841783},
{-0.7265554246914687,-0.5732760572835568,0.3787766848643402},
{-0.79774979947449,-0.5260748792551344,0.2946870863392332},
{-0.8134167041364727,-0.5149624738108254,0.27049383726508974},
{-0.8297774690497977,-0.49827032824579565,0.2513882094433613},
{-0.7713127678205303,-0.5526443615738076,0.315691025874527},
{-0.6792872363582508,-0.6194228499182388,0.3935532791375739},
{-0.6165633424678119,-0.6549490928680534,0.4369111242303564},
{-0.57478706398511,-0.6758650535961079,0.46133096623021863},
{-0.5687559276810877,-0.6783055134299315,0.4652078300912207},
{-0.5601215152893868,-0.6833858650594121,0.4682388787220899},
{-0.5081558826541048,-0.7029836160176162,0.49758580620313553},
{-0.5040015396246648,-0.7019980875511117,0.5031710773986804},
{-0.8028077224616051,-0.4942332271781553,0.33351653318700153},
{-0.8577786335565701,-0.4525051226140022,0.24383381599341425},
{-0.8188869743958924,-0.4585035951609771,0.3452514683375003},
{-0.7943895135608723,-0.5184500304750708,0.31647253695213245},
{-0.8586973400430411,-0.46217184566709696,0.22144087986565422},
{-0.740417115073514,-0.5480022747085936,0.3891991811661759},
{-0.8723578055292459,-0.45214526326403764,0.18589384078041044},
{-0.8743658302680335,-0.44770407497710113,0.18720431647959052},
{-0.8668734673361513,-0.4564218251269297,0.20052308888604553},
{-0.872936085206502,-0.4627333264924218,0.15446831292405708},
{-0.8581009270235421,-0.4743533653222088,0.1966003149764327},
{-0.8351591926869655,-0.4932413158181585,0.24335596816274654},
{-0.7819226059896449,-0.5439003723796272,0.30458073341507563},
{-0.7047753709312365,-0.602750527156849,0.37414366029759016},
{-0.6362274031965622,-0.6446275099257979,0.4238750580874326},
{-0.6382417483149156,-0.644582180795553,0.4209053134717702},
{-0.631876997132579,-0.6508954434348015,0.4207928019946728},
{-0.5469777537884579,-0.6915293308055449,0.4718077166560211},
{-0.4870614275696127,-0.7130836595483682,0.5042646728246566},
{-0.47943323109188407,-0.7141178159103541,0.5100779567127183},
{-0.8203131045590311,-0.5494421706187288,0.15874417039533767},
{-0.8324077381685813,-0.5220407103040264,0.18593239153610164},
{-0.8261020236583689,-0.5188358905492708,0.21991990629657165},
{-0.7119763116651115,-0.601075519219289,0.3630398763538328},
{-0.7571924688682783,-0.5733031456702803,0.31302247244203235},
{-0.778148173460025,-0.5498311314197697,0.30359701425159485},
{-0.7154991573896128,-0.5958785686246068,0.3646775112735141},
{-0.8270683808384784,-0.5050031864852963,0.24683937096199793},
{-0.8013845315392196,-0.53748244840865,0.26247942826497517},
{-0.7085339163596414,-0.6206328172047645,0.3358490666602276},
{-0.694099418924295,-0.618449126836665,0.3684381551412973},
{-0.4880303420604548,-0.7250685390105344,0.4859032814928138},
{-0.5746415499200795,-0.6924071088537835,0.4363020567384405},
{-0.5271576079023437,-0.7034958573574355,0.4766533699782322},
{-0.6150573579148505,-0.6644189934430123,0.42456077024023064},
{-0.6500398559086848,-0.6551853138370803,0.38494206091621447},
{-0.42439243119412773,-0.7428612476892208,0.5177337453042363},
{-0.4630659650498439,-0.7247566819430975,0.5101937514232102},
{-0.6038248122475133,0.7672639692721636,0.21610552415655648},
{-0.7110086632583007,0.6998547132947819,0.06833784493765577},
{-0.4944710109769644,0.8674874260510168,0.05444249210681218},
{-0.583252447182579,0.6997062593295821,0.4125866375811711},
{-0.5344924267519672,0.7094379386827067,0.4593644053498543},
{-0.5056840717589287,0.7111736608063148,0.4883806340802792},
{-0.5792089083475983,0.6744270456846837,0.45789212762375925},
{-0.622457768679851,0.6628819428760699,0.4160935664234044},
{-0.6887197733987527,0.6342637851587771,0.3512470990138306},
{-0.6565256406080628,0.67308308639109,0.34048970915200494},
{-0.7901356299077036,0.5456980972845012,0.27910441230914207},
{-0.7094905362218641,0.6034904746911146,0.3638989227363896},
{-0.6526109081871267,0.6304947054961518,0.4202087919790526},
{-0.730037260022309,0.5729366660392929,0.3725441929313882},
{-0.7945955293583532,0.525310147825259,0.3044128665406949},
{-0.8685004394009038,0.44521088026888045,0.21793177567909994},
{-0.8741855012398556,0.4528346062901682,0.17532977148234324},
{-0.7791289479306187,0.5726801441928877,0.25494221883348533},
{-0.7540110987072909,0.6134862456230048,0.23473791653163842},
{-0.6513751212122666,0.6077525673187849,0.45425462945701606},
{-0.7247542651606809,0.5532306694236371,0.41069098059304393},
{-0.6932819589216792,0.5659094147071925,0.4462136929538155},
{-0.6311724353216261,0.611455403452271,0.4772249432701399},
{-0.6728367290011473,0.5702165743901397,0.47132132818047917},
{-0.7523566078011418,0.5020727853767203,0.42647679055491516},
{-0.7853032520257882,0.486143939603939,0.38335736897062933},
{-0.8262578312409447,0.46019633810450056,0.32483430654445816},
{-0.763777354046445,0.5323913945740373,0.36497062406353104},
{-0.6843292213663376,0.596037748268852,0.4200387118144454},
{-0.6154925398741539,0.6420351784538896,0.4571211688239183},
{-0.5935541616977731,0.6454319087576685,0.48074016712636614},
{-0.6669683834207865,0.5655268829290837,0.4851108329047882},
{-0.7301390261886926,0.5075554601907694,0.4574761821852195},
{-0.8318138935551107,0.3987750141231543,0.3860882471660659},
{-0.863512173951451,0.38072099952969085,0.330754056596064},
{-0.898173128388281,0.3545222923862279,0.2599980300741188},
{-0.9249720453695869,0.3331958087903657,0.1827765528981688},
{-0.8633324069244551,0.4350014041171037,0.25579470981663266},
{-0.7916223465644285,0.515566539498188,0.32791035935098334},
{-0.5539542492543174,0.6774534255611051,0.4839334106347794},
{-0.6808353217377688,0.5498924133672285,0.4838197995074136},
{-0.8088366685094187,0.4048880495236485,0.426437464380793},
{-0.7227216700819311,0.502167127886865,0.47487004881740147},
{-0.9170556106632768,0.24366618929692127,0.3156513822946471},
{-0.9395768334383638,0.23241024419018577,0.25135801650513395},
{-0.9596698656263812,0.2185473164508808,0.176835571876141},
{-0.9722821086755453,0.21121436480002695,0.10027957544563207},
{-0.9702265774052022,0.23630460757955787,0.053108576833296825},
{-0.9270337273889603,0.3486927120794546,0.13791976227504707},
{-0.7990274980445189,0.39884012093542287,0.44997957209292677},
{-0.7343711719747891,0.4844270106626768,0.4754255494951841},
{-0.8059101377177029,0.37978918691074376,0.4541684967382802},
{-0.8854200364964127,0.2409485463069471,0.3974608873880047},
{-0.8972819144317118,0.2473092347024755,0.36568197722151735},
{-0.9775135458310665,0.036892035973134014,0.20762043588850418},
{-0.9890881939546642,0.03839899981326001,0.14223242032969066},
{-0.9962414618488988,0.045366715864252075,0.07378896113146599},
{-0.9980696055030416,0.06161006010866677,0.007827072531244064},
{-0.994416526215339,0.09594089680867032,-0.0439444730241025},
{-0.9726214348585698,0.23218871183248277,-0.009795231045223991},
{-0.9350579181020927,0.34578677757764414,0.07809093575472821},
{-0.8850985985393269,0.22422586038346531,0.40782745665172426},
{-0.95217361508697,0.03047144646296415,0.30403436924575733},
{-0.9584694231481788,-0.262813504024762,-0.11074938822505377},
{-0.9916090555831282,-0.10160261668740361,-0.07992739935597228},
{-0.9602588713040079,-0.23314835828024846,-0.15344296371348418},
{-0.9145651227958186,-0.36482418687206836,-0.1745678917745279},
{-0.9219457093480532,-0.33139855016861175,-0.20047720558920681},
{-0.9334347441224011,-0.2818204114991415,-0.22198386006104576},
{-0.9692176224416906,-0.17000484688616702,-0.17808860823670714},
{-0.991296614577582,-0.050758370315932354,-0.12146855465467332},
{-0.991136584772455,-0.1314850921075815,-0.018972107923338078},
{-0.9488365961318015,-0.306571221146274,-0.07565183544302727},
{-0.9011814772132357,-0.40619617410949405,-0.15125016782331172},
{-0.8684034454936904,-0.45282306489592744,-0.2020562489826679},
{-0.8797676154514643,-0.42216085296748956,-0.21860731237679587},
{-0.8899974986807199,-0.39459635540098115,-0.22846918533212465},
{-0.8918301635030064,-0.37795063099224474,-0.2485805302085523},
{-0.8914660367783235,-0.3582107380872089,-0.27744075473831487},
{-0.9339810329605274,-0.2513472103174665,-0.25397639641433933},
{-0.9676355603344338,-0.13505829634867403,-0.2131681940713955},
{-0.9870872516622446,-0.015443061806626425,-0.15943735273740983},
{-0.8653437655581763,-0.4686983122154098,-0.17748819548359349},
{-0.8949893479002152,-0.42931991002919845,-0.12115478528588308},
{-0.9421264263212928,-0.3334277367712753,-0.03498201221563221},
{-0.8944658288679987,-0.4393544691218761,-0.08305739852727274},
{-0.8689477534993276,-0.4729927854999261,-0.1456283851228622},
{-0.8637334132526715,-0.46918610426798985,-0.18392658968381057},
{-0.8558542564741353,-0.4715704221624363,-0.21244959076601366},
{-0.973120162515322,-0.17794486203119725,0.14619430694405117},
{-0.9371406157649268,-0.3442694988188048,0.056973489157524905},
{-0.9654290823770072,-0.17951141312741214,0.1890035435056427},
{-0.9411975000597128,-0.3244430412538116,0.09425486121852936},
{-0.9150020556014367,-0.4034416567092728,-0.0024633060757218665},
{-0.9004905387083697,-0.4328908315025451,-0.04150081562747113},
{-0.9381628175213569,-0.34599463651838264,0.011757521886072842},
{-0.981000750749496,-0.17061983960002272,0.09233849340219762},
{-0.9639253478018543,0.035613909184020236,0.2637794027927628},
{-0.987034656817166,-0.15647884793424294,0.035734526595317236},
{-0.9321378165653724,-0.36005640157974184,-0.03845098971662191},
{-0.9367744933468884,-0.3488552577524073,0.027451006414735725},
{-0.9694486723333122,-0.23734443913903433,-0.061942626041808176},
{-0.937728415729943,-0.3376420072066037,-0.08162899792418556},
{-0.903164629015281,-0.42345063290456164,-0.0705918861372609},
{-0.8809188778675859,-0.46067654678226316,-0.10843915280599703},
{-0.8883665863183072,-0.4230927966013717,-0.17831795696784944},
{-0.8804094530265522,-0.4499143085423742,-0.14985429586876914},
{-0.9067387303487173,-0.4060592005754158,-0.11375763936391453},
{-0.9166275802865587,-0.3732562114076314,-0.1430862666492844},
{-0.8673779060885658,-0.450456201213502,-0.21152961688074864},
{-0.8546407545140177,-0.4605295250608345,-0.23979519859862197},
{-0.8559324814220092,-0.4608949609270407,-0.23442572861958522},
{-0.8666127373128842,-0.43287003667134144,-0.2482053482083359},
{-0.8610702686237979,-0.4260789092665105,-0.27751532492891495},
{-0.8890490321912158,-0.3364907287098919,-0.3104284262952549},
{-0.9306666319291703,-0.2240887904442103,-0.2892124378564401},
{-0.9624310576060923,-0.10353237183212967,-0.2510129624900521},
{-0.9799103152882837,0.018487959475190642,-0.1985798815239353},
{-0.9886513984752615,0.11435501640493104,-0.09742352136900899},
{-0.9647386105739462,0.2577400916773194,-0.05338031856423362},
{-0.9276724560031939,0.3714443096982339,0.0381174391296783},
{-0.8663664718596171,0.47873857967888245,0.14219180273336948},
{-0.8458031362357927,0.5214211951801728,0.11285828259625898},
{-0.7035547882686796,0.6754653131058562,0.22081048592632807},
{-0.8026322719649922,0.5899258984405698,0.0881411955296801},
{-0.8750292351178012,0.48277318756276383,-0.03541026771494856},
{-0.7970905439269261,0.5989451504810738,-0.07688544398962052},
{-0.8527571058195355,-0.31267599111644934,-0.41837667603923123},
{-0.8788559865938106,-0.31928744038035745,-0.35449638255358756},
{-0.7875371940649507,-0.3277994692164851,-0.5218550334582344},
{-0.8390899983811986,-0.17943826734147902,-0.5135463784607266},
{-0.8970883891078739,-0.1833300975674865,-0.40202300612494263},
{-0.9205921701250821,-0.20015659278349163,-0.33533176805917986},
{-0.8910423018201297,0.3174344167417637,-0.3244672671239756},
{-0.8828967431744738,0.16827886909507572,-0.4383783333012589},
{-0.6741168992859569,0.28582811754624154,-0.6810790653933352},
{0.0,0.39638808550228616,-0.9180830494415155},
{0.0,0.10363734017872483,-0.9946151525694144},
{0.0,-0.20142623492933626,-0.9795036865077088},
{-0.8579034810114351,0.4688044738952629,-0.21029498929895554},
{-0.9214239584347014,0.3609170177976715,-0.14393330082562952},
{-0.9393824605846557,0.25106771099797986,-0.2335071674277962},
{-0.944351884026531,0.10882257083771543,-0.31041450870056253},
{-0.8777746282197867,-0.016231348607022213,-0.4787987524795909},
{-0.7071380437274682,0.018384553115970998,-0.7068364699985529},
{-0.9103402262214821,0.41385943238871864,0.0010211493076238065},
{-0.9497832665709312,0.29781999540303433,-0.0959947752744294},
{-0.656171261352348,-0.20249488160244716,-0.7269354157695714},
{-0.9297056995076172,-0.0454624560725568,-0.36548663093320266},
{-0.9516087187580725,-0.07365631396604062,-0.2983548119212356},
{-0.9679433172871967,0.053194565491364025,-0.24547112400696386},
{-0.979525939974628,0.14543257958871547,-0.13920595429432378},
{-0.965017784126676,0.1850593290065915,-0.18572485312114306},
{-0.9886406957926073,-0.06610536869399626,-0.13498020170580577},
{-0.9906196305560616,0.019796767714910287,-0.13520664016613182},
{-0.9828848190689495,0.09864156822525044,-0.1555868678965606},
{-0.9703321054617016,0.16476943686531487,-0.1769368186255996},
{-0.9574946190538564,0.20910356766741597,-0.19869512442852932},
{-0.9533500020168083,0.1904696884010159,-0.23419024628487697},
{-0.9322327848136673,0.19125720436041732,-0.3071851505180424},
{-0.8335768613192679,0.2450422083963569,-0.495079723254098},
{1.8534524028567e-17,0.41199259149460316,-0.9111871951215957},
{0.833576861319268,0.24504220839635693,-0.495079723254098},
{-0.9413823313986248,0.07784393461095811,-0.32823715203306064},
{-0.8251264677047422,0.1875212972568244,-0.53291845095494},
{-0.8441408262458234,0.07292644652347947,-0.5311383989719407},
{-0.9495176423075118,-0.007271070687556126,-0.31362936482070747},
{-0.8550132557170923,-0.05245081015616586,-0.5159469401615053},
{3.404549520031432e-17,0.060888474173304216,-0.9981445755564907},
{1.7483270286845663e-17,0.2718229802387192,-0.9623472696558872},
{3.565136702938042e-17,0.3832089538450678,-0.9236616792381119},
{-0.8195355776641589,0.2449242115070867,-0.5180478429260228},
{-0.9291217911488651,0.1571298614901744,-0.33472810434799694},
{-0.9637671143977844,0.09675636907850063,-0.24857826584018344},
{-0.9720628220315362,0.023151556773952885,-0.23357627328782424},
{-0.9752954772663476,-0.037331963013274426,-0.2177270230389023},
{-0.9517629139719254,-0.07804809567949507,-0.2967420602955942},
{-0.8555737477942769,-0.1580177142926304,-0.49297460792112563},
{3.2632230544445517e-17,-0.16296154835857918,-0.9866324207913373},
{0.8550132557170923,-0.05245081015616586,-0.5159469401615054},
{0.8195355776641589,0.2449242115070867,-0.5180478429260228},
{-0.9248396812798073,0.19568624775360416,-0.32615710381713187},
{-0.952148767330779,0.16569744752666468,-0.2568211065189667},
{-0.9703681513587572,0.12210778254818538,-0.2085074105871374},
{-0.9801467788751406,0.050215985251588456,-0.19180888062313114},
{-0.9845178547824014,-0.008114260072984422,-0.17509640886701944},
{-0.9853190003119794,-0.06475654339172364,-0.15796536871149117},
{-0.9732164036749494,-0.09769542820638676,-0.2080995793498118},
{-0.9433501827353168,-0.15287578822245596,-0.2944816227009882},
{-0.8082220360258354,-0.28287054712760346,-0.5164894907449554},
{-0.9517002849706934,0.21965562451971402,-0.21451800438088015},
{-0.9475930563119277,0.19787419336604223,-0.2508250450596157},
{-0.9571851225422282,0.18948577913970446,-0.21884190797842792},
{-0.9709254486509484,0.1518353257175557,-0.18506703387204892},
{-0.9838881875175467,0.10404289569385641,-0.1453929514078114},
{-0.9831922783131802,0.07700766669949104,-0.16553779971607074},
{-0.9890250150278259,0.016926212536776557,-0.14677541680529654},
{-0.9912930233930944,-0.03482597515103137,-0.12698540556677315},
{-0.990639637376547,-0.08772085728375104,-0.10458565893977631},
{-0.9842012935400146,-0.1128386863069788,-0.13643769518237},
{-0.9742720595921691,-0.13817720266175645,-0.17804778730050225},
{-0.9478665442252643,-0.1962946896583856,-0.25103268542238294},
{-0.8440497166968072,-0.33177774725877374,-0.4213117636239616},
{-0.9737300846674455,0.1954092474369061,0.116897169468177},
{-0.9716179992635736,0.14501043038962014,0.18689686617294413},
{-0.9639155644613213,0.21975402061726704,0.1502496423015983},
{-0.9734574476621531,0.07446695255814485,0.2164145803031514},
{-0.9800775221408311,0.11924099835373281,0.15883839241787198},
{-0.9835905980635338,-0.02875688531560077,0.17810832924926698},
{-0.9962364819484157,0.02848204524950639,0.08186357635388769},
{-0.9924331633428551,-0.033601121196441604,0.11809903027390052},
{-0.9732167667111533,-0.0892431068632457,0.2118603145227626},
{-0.9834045915480983,-0.09368365722456891,0.1553666041694526},
{-0.9978188747742238,-0.036235468132134505,0.05517684291028906},
{-0.999508567061101,0.024057991401224558,0.02009570653654422},
{-0.989038870988808,0.03486129174808836,0.1434810162036724},
{-0.9745595444079532,-0.015981108894768305,0.22355826659252886},
{-0.9647417332268045,-0.07714360320161508,0.25163913180507724},
{-0.9514081221083859,-0.13411844308626436,0.27719096018865985},
{-0.9579500975173233,-0.14844577770639744,0.24555134238625848},
{-0.9910668225140639,-0.09548260918604505,0.09311081921507207},
{-0.9991207016139805,-0.04186832126453353,-0.0022061914869758057},
{-0.999291729088105,0.01595917395341098,-0.03407851145267404},
{-0.9944862264561678,-0.09924990391138608,0.03386151152197053},
{-0.9530610278071089,-0.11033940943814104,0.28195725207928213},
{-0.9419238649053345,-0.1602743251417049,0.2951128147372933},
{-0.9629099842365373,-0.05490046513839657,0.26417854035704613},
{-0.9702401171905904,0.00727602774400925,0.24203548172583655},
{-0.4540545383991308,-0.7270067875826931,0.5150685458925298},
{-0.9382269638939449,-0.32392380383313457,0.12166977246885624},
{-0.8846219763066431,-0.4292886124422111,0.18208582114698021},
{-0.9411675522768014,-0.32736444721354757,0.08388180518957988},
{-0.9704001740659051,-0.2370898366533776,0.04595553860565814},
{-0.691446452750306,-0.6247464773628246,0.36275837964375185},
{-0.7987153843077475,-0.5426329211909422,0.26000624552097235},
{-0.924105205446506,-0.38186769393143455,0.014374755586065944},
{-0.8669535222284691,-0.4832521022919632,0.12189748121289908},
{-0.9380617443000576,-0.343005832496152,0.04885859959469745},
{-0.8834749346002079,-0.4439045478995463,0.14973574151570412},
{-0.7772467256868985,-0.5810326782559911,0.24143022637537542},
{-0.951768693424125,-0.300307785031562,-0.0628616613459364},
{-0.9646819913496308,-0.262263874398475,-0.02462347967310106},
{-0.9696690928369645,-0.24421679524812967,0.010000365766883713},
{-0.6634289493137877,-0.6593777315240414,0.35367080227608944},
{-0.5491642638859102,-0.7099579574298166,0.4408835560017284},
{-0.46058576432953885,-0.73608669276854,0.4960213044074289},
{-0.5831140845878574,-0.6813233634798007,0.44246631366900296},
{-0.4980249969058611,-0.7135047381496682,0.49283069211940395},
{-0.41580077679100685,-0.7455947307855806,0.520766945422588},
{-0.9172629838466465,-0.38135089171517855,-0.11489175711418449},
{-0.7874364125033304,-0.5793582177966846,-0.21044702833571793},
{-0.8159472338043774,-0.492351372696927,-0.3030185430801822},
{-0.9336339117434833,-0.3123251094162679,-0.17544442103035898},
{-0.9643733904960571,-0.23871257939083848,-0.1140187183918151},
{-0.9824492726901589,-0.15157095609885382,-0.10871831427067366},
{-0.9708375005780137,-0.1866094098863254,-0.15050407174994596},
{-0.942550849899156,-0.25259332749859587,-0.21861954683322787},
{-0.9877041319492074,-0.13649955473270733,-0.07621298634901708},
{-0.9766119270439658,-0.20203219410139409,-0.07356722437368662},
{-0.9824682992544871,-0.18209791400301353,-0.039954857974302926},
{-0.9842569919818034,-0.17663661697844824,-0.006138344837276201},
{-0.9942786672939201,-0.10616051650535721,-0.011826939567869918},
{-0.997640831605188,-0.051996636360051,-0.04482321855187809},
{-0.994943938776239,-0.06544846773726833,-0.07617779704918788},
{-0.9916774018678144,-0.12022639764499032,-0.04606022073340555},
{-0.9947602057986847,-0.014806378920053376,-0.10115781780284885},
{-0.9915305155112315,0.040052673513949213,-0.1235435961691928},
{-0.9973291264116948,0.0023258225142584023,-0.07300139834631626},
{-0.9932080555403549,0.06126221918268433,-0.09891763700453204},
{-0.2046178040805572,-0.9445330090706059,0.25688314275031204},
{-0.17040817573976708,-0.9697258266719503,0.17490818942075664},
{-0.24409277841963364,-0.9517298980146196,0.1860884648452591},
{-0.28102772995445313,-0.9151695426872358,0.2889431140108424},
{-0.2996258850306496,-0.9288020156266742,0.21806224979905947},
{-0.28571598822625466,-0.949401294802902,0.13039768210542568},
{-0.2447283634537526,-0.9636834649248436,0.10687472831168121},
{-0.18043061355093543,-0.9803683998230774,0.07951474279636064},
{-0.045220440683258936,-0.9850452608284801,0.16625566415543147},
{-0.11087054398774676,-0.9588567323071944,0.2613455363786237},
{-0.1797336927468713,-0.9278102595590244,0.32690047713117387},
{-0.275258648070899,-0.8875427363656067,0.36945983244032354},
{-0.397700509869963,-0.7990863434665917,0.4508828230642233},
{-0.370467493167941,-0.853917826314546,0.3654834912935225},
{-0.3617856802569438,-0.8884731561189383,0.282358942513024},
{-0.31830862432892,-0.9334945439632034,0.1651289074291998},
{-0.3118722264550208,-0.945198951996195,0.09661602098659983},
{-0.29243147