// 3D model [bunny]
//
// - vertices   : 2503
// - textures   : 0
// - normals    : 2503
// - triangles  : 4968
//
// - memory size: 81kb
//
// - model bounding box: [-1.0,1.0]x[-0.99,0.99]x[-0.78,0.78]
//
// object [bunny] (tagged []) with 4968 triangles (363 chains)

#pragma once

#include <tgx.h>

// vertex array: 29kb.
const tgx::fVec3 bunny_vert_array[2503] PROGMEM = {
{-0.939647794007703,0.3810234907114758,0.19666316918365134},
{-0.9369756997973694,0.43533158201382854,0.1800827794935782},
{-0.8992196402146957,0.41684863031003,0.12780357207307072},
{-0.9229024124898814,0.3717091864356095,0.15626466235969247},
{-0.9022204290818723,0.3654807449381025,0.07785358522085702},
{-0.881006089229643,0.38028360548391615,0.051084950167312},
{-0.8498574367488362,0.4101020113535002,0.03525604669268722},
{-0.8553601720039806,0.47164267410504845,0.05875320316165588},
{-0.8869457950285901,0.4765705159603814,0.1041556027615507},
{-0.9253076839787782,0.46282463431108184,0.1464334696234577},
{-0.9544944805077625,0.46536911765464145,0.2099952822649253},
{-0.9584993993266272,0.40333605741715634,0.2211425426271855},
{-0.9557783231674308,0.37124127992410405,0.24301942778771737},
{-0.9466522126950901,0.33007324090353674,0.2014891801452959},
{-0.9273739488215976,0.33646538523013797,0.11124122836415756},
{-0.910525447411433,0.3041488999685485,0.05000992528963798},
{-0.8590879561121739,0.30652452448839657,-0.0026430917406122544},
{-0.8112764180274198,0.3340510907506614,-0.03436405962392178},
{-0.8245350581853994,0.42357849228405425,-0.0006322538399270152},
{-0.8154927326255873,0.5187388179366743,0.026907202408880657},
{-0.8560381852961347,0.5229254855657932,0.07341040685953522},
{-0.9114561044398269,0.5215552799962878,0.14997177092947114},
{-0.9461881731795472,0.5068954983011,0.18712844613790222},
{-0.9604200073215124,0.4941112096478973,0.22882755260403506},
{-0.9627479388911518,0.45474390174736684,0.30625899076561364},
{-0.9661921432954025,0.42785667881762734,0.24842806614109897},
{-0.9569964268957305,0.41048999994844027,0.2992004341347468},
{-0.9537893982438683,0.3660672393258022,0.2841578198392361},
{-0.9506171725556719,0.3218081815322586,0.2985688247941469},
{-0.9723148869032582,0.2810152411200884,0.2180076978999634},
{-0.9635999670016345,0.28112609500435704,0.15623243739333534},
{-0.9436565798225309,0.2916726819937201,0.09544197185858137},
{-0.9054003887619944,0.26342427648505556,0.030856694285611136},
{-0.897685731816096,0.22585125471129017,-5.349344415287992e-05},
{-0.8469455887888054,0.22559861097505027,-0.04121379847279442},
{-0.8230295077571941,0.27127685628696224,-0.03812277969981804},
{-0.77455026836952,0.2612291117768075,-0.07056945382549025},
{-0.7413546860257079,0.35401639090688813,-0.06686873868903684},
{-0.796318877643092,0.39118982309782474,-0.0402277145022661},
{-0.7809733486638242,0.4693405225084946,-0.03702068585040401},
{-0.7917596894028843,0.5087916153215539,-0.013143274778421164},
{-0.7758031750614854,0.5612396815657728,-0.010503405534444645},
{-0.8001497816436282,0.5583574805747904,0.07050629289143019},
{-0.8605367905995909,0.5466185698302133,0.11811030219284449},
{-0.8787052266317436,0.5551736538987054,0.18222251725969196},
{-0.9436926717848507,0.524370453057247,0.22215956256541666},
{-0.9564730934420907,0.4988972616512591,0.29633112313030746},
{-0.9361997226074896,0.47889586953271246,0.37609435985748835},
{-0.9359071199129668,0.4302052343657353,0.41772643839359835},
{-0.9533137577404369,0.41352043578466524,0.3543502415583478},
{-0.890833414969915,-0.005994488241754135,0.11782156649428456},
{-0.9055872935668655,-0.058331700601704506,0.14497819014276947},
{-0.896713826830765,-0.01401979386333515,0.17353595532846264},
{-0.9238047115478814,0.014049440832383853,0.18254089992730047},
{-0.9189116726562138,0.015491830326529196,0.25777975137793957},
{-0.8940572006042826,-0.02277725072055015,0.2542826980288633},
{-0.910087187868976,-0.0543061578043712,0.19500164991827748},
{-0.9347573331133444,-0.13671055277418273,0.19206531098381532},
{-0.9292571758555086,-0.14106607922701314,0.14246722076422152},
{-0.8970863474418533,-0.06908323837709898,0.0962153710511526},
{-0.8702455284636683,-0.0074807036901452986,0.06692416563117107},
{-0.9224796209312759,0.044672181862242255,0.09416199619487595},
{-0.951190776956829,0.046119727351004745,0.15157399625674792},
{-0.9507280264399405,0.033603550417893466,0.2271634553413526},
{-0.9727827934147637,0.05927524761664165,0.23846023954750992},
{-0.9588590299511728,0.07393631831048385,0.33756103408628046},
{-0.9284257717234945,0.04432544122423953,0.3268378542812801},
{-0.8821365410494513,0.007998881149168191,0.33539680534573524},
{-0.8677874080299463,-0.02362025584045286,0.3378884397444689},
{-0.8825696445972913,-0.05974831012276412,0.3193255701241048},
{-0.9202638322445593,-0.09031562421048824,0.24479695693197698},
{-0.9356106502224812,-0.1434520157360955,0.2449619487597255},
{-0.9370324157381582,-0.18716969409483922,0.20259256299336423},
{-0.9258928893678237,-0.19685265198583127,0.12137275778684085},
{-0.9194350061098538,-0.16257431077241938,0.09230583813270497},
{-0.9012962170467494,-0.1319386797560182,0.06491332773048583},
{-0.882564488602674,-0.09635329390716109,0.03706966779926679},
{-0.8596190235577396,-0.03745378939824378,0.02887550335397447},
{-0.826999623612393,-0.011423750573604253,-0.006918700276876944},
{-0.8301860282857866,0.024464549959009894,0.007724324435805269},
{-0.8949040727201483,0.05820408973493045,0.04759563081016141},
{-0.9461082552629815,0.08278013807753601,0.09226330117711355},
{-0.978013549953854,0.08850844809718036,0.17236167755440862},
{-0.13640570459244444,0.1687241233520153,0.298289112086167},
{-0.11666082320610062,0.15051057236696255,0.3552731645948162},
{-0.1224922531180878,0.19381061516171783,0.24330171849300591},
{-0.18007955699694253,0.19963688907908797,0.2330129312344998},
{-0.1937107177660107,0.2093095349808456,0.14817877380136013},
{-0.15785593119840788,0.19864049311932533,0.11915568010146996},
{-0.08583055339290231,0.20625074117422637,0.233257840978814},
{-0.04266327745953837,0.19196348009012695,0.32315905212194956},
{0.007340847336155353,0.17628925645401636,0.4003533145311396},
{-0.048230462647397034,0.12428847274283457,0.44452343141753764},
{-0.15203996927027214,0.11418659028919988,0.4043646783432758},
{-0.18765242409086932,0.14509935601627238,0.3538733120562622},
{-0.19529360811347318,0.19374874322631222,0.2691796554764397},
{-0.2673086739297445,0.2228453098494966,0.21659237737755802},
{-0.2503596306245457,0.22715056535480987,0.14607512799756636},
{-0.2186231947573847,0.20657170183914336,0.041189307498362956},
{-0.1771419290638261,0.188527009677802,0.033264543771816285},
{-0.11099438512186198,0.18783739539775937,0.02076770181851927},
{-0.11420785876699549,0.19945642926748797,0.07780460327199416},
{-0.08644024975637929,0.21354905155479026,0.16085607556625708},
{0.006802045898664052,0.2357855673398678,0.23415756203950522},
{0.02028626082114367,0.228099268364364,0.29682352061624445},
{0.07649691413722162,0.21608837890373256,0.37455400646561726},
{0.05678812471319778,0.1610507143630543,0.4520589175504901},
{0.03621055019618557,0.1221036200238208,0.4863888187100733},
{0.0013959855425910586,0.07131449504766736,0.5070334211571084},
{-0.052602746082733125,0.05081554944856656,0.5072886428906568},
{-0.10441920298635213,0.025244394144852664,0.503256655100052},
{-0.10478270060686061,0.07443644978834651,0.4585864067357914},
{-0.1800640890130911,0.07502165517739216,0.44265567236747805},
{-0.25330370355093357,0.1526915580900135,0.37578113318449696},
{-0.23725695930373455,0.1920511319986183,0.2979900643983728},
{-0.3000814647149509,0.20792643942479735,0.2718440156948476},
{-0.338295118819896,0.22813020433206677,0.23620320290385616},
{-0.3368127703674678,0.24660284404663102,0.13859764680405673},
{-0.28859004171199654,0.23368192153607406,0.08400210880179838},
{-0.2610608974524231,0.2191033467561061,0.023679549778550014},
{-0.23847506303203425,0.19754097726721986,-0.02155270199897915},
{-0.20650918540441052,0.16566275154808743,-0.057058169931270615},
{-0.12064640704515109,0.16688601127100441,-0.03855717224631219},
{-0.054132787485369906,0.1673564957798185,-0.059767645102578565},
{0.007223548458615371,0.192948275062001,-0.027942268328271888},
{0.033914843592903254,0.2259092596507331,0.035967573949852776},
{0.04262718549721831,0.24067473923557242,0.0960478012260955},
{0.07816874539182979,0.25457530072338624,0.16081611660797426},
{0.11235943469675015,0.25976352030688493,0.23658990250014178},
{0.1006965748727758,0.24967581683844733,0.303031338135283},
{0.161858272019964,0.2448588288673828,0.3520442229658312},
{0.13166347854332838,0.20964467463095984,0.408724071792069},
{0.15724365683762226,0.18216709031755782,0.4505598121155562},
{0.13368978442786503,0.15284881592583627,0.4798059025826377},
{0.12060644808686818,0.08740893224507491,0.5254751249039696},
{0.04959422322363092,0.07454085867934362,0.5207870367983336},
{-0.05576079278573237,-0.010699333329895918,0.5439258516414109},
{-0.11689284296387199,-0.07586981629191174,0.5631602895606578},
{-0.1591952008002104,-0.10543042243063891,0.5686462678332964},
{-0.19799534929285537,-0.015312659513583382,0.5102494727995504},
{-0.7125958370499462,0.8358569778653154,-0.5213748201846878},
{-0.6565811115293197,0.8653776250457597,-0.6302384905310159},
{-0.7215350427174155,0.8815674481435842,-0.6023046006939969},
{-0.7386903258072999,0.8172812182584082,-0.47054315825294285},
{-0.7707528783339951,0.8685189147662533,-0.588245492371706},
{-0.7393425591263684,0.8986866392711489,-0.6356368168951632},
{-0.6906545019567001,0.9095026269792578,-0.6662879158954159},
{-0.6479731785160017,0.9096959767774004,-0.710706809522091},
{-0.6186278351525403,0.8855388529974377,-0.7012275134184761},
{-0.6131792378408758,0.8096090982681016,-0.615411139010771},
{-0.6624370324157383,0.8281216969409485,-0.565658368952663},
{-0.6746000237175753,0.803374211777323,-0.4837747294391826},
{-0.6975918927140641,0.7890469917349408,-0.4032174695409618},
{-0.7213017339609898,0.7670321837184002,-0.3290961799235882},
{-0.7557231540250273,0.7837504962644821,-0.40471528597724155},
{-0.7916578585091959,0.7551824190895545,-0.41353590376851657},
{-0.7849047945593947,0.8188589526112536,-0.5155537022619349},
{-0.7978746990188145,0.8118906258861868,-0.5315591985521968},
{-0.7965612093900974,0.8283459827067943,-0.5816651542415789},
{-0.7835345889898893,0.8639610155247001,-0.6282431206141822},
{-0.7552243115458189,0.8942460389071355,-0.6563548922654925},
{-0.7044055396006168,0.9139006903876795,-0.6960109358645831},
{-0.6572204548618452,0.9117854435959971,-0.7309750243620746},
{-0.621896735739808,0.9002179696724398,-0.7511813672666526},
{-0.6099967001634451,0.8943491587994784,-0.73792788310329},
{-0.5895995854580328,0.8590099716935898,-0.726216041330453},
{-0.5892438218294501,0.7988988084496442,-0.6613317160696884},
{-0.591406761571341,0.7384409045676957,-0.5701453732682303},
{-0.6074470608252686,0.7446732130611659,-0.5059081253319172},
{-0.6412226925635091,0.793483725102991,-0.5239193035282472},
{-0.6317034375016114,0.7410511268426239,-0.3747950492139687},
{-0.6597481812228989,0.7681768145234057,-0.38857186683097106},
{-0.6903735002500659,0.759438692646005,-0.3178922036205395},
{-0.6784979556481343,0.7043907161160924,-0.20284262873229564},
{-0.7199276613955217,0.7157326152751498,-0.215652697358584},
{-0.7554176613439616,0.7506838137860985,-0.3262552268895432},
{-0.7747281501838114,0.7337927754203425,-0.32803791202841986},
{-0.7812453273798784,0.6761075076437622,-0.2484203321491733},
{-0.7971154788114401,0.692442987589521,-0.3468121774280868},
{-0.7963034096592404,0.6967482430948344,-0.39112795116241905},
{-0.8034212602282045,0.7374715775796732,-0.4385682576347391},
{-0.516891038365756,-0.8341877246080155,0.576430530706526},
{-0.5617507695321967,-0.8279438151266569,0.5358489860736585},
{-0.5684677415196779,-0.860064372592795,0.569231473222342},
{-0.5587164667000089,-0.8887768176170023,0.5900526684850141},
{-0.5945828542555003,-0.9163665448133271,0.5696078608293933},
{-0.6155986883149694,-0.9089122655955947,0.5271198871868378},
{-0.6024431680493326,-0.8588462688644952,0.5085905315314851},
{-0.5933492825433491,-0.8374656481858633,0.4653948976277269},
{-0.5492874415439112,-0.810457259382621,0.45958795869017116},
{-0.5124994199506057,-0.7965682988826959,0.4909699199274036},
{-0.4946313206049014,-0.7962022232648789,0.5156001062134892},
{-0.4621666004980691,-0.794780457749202,0.5183508293417343},
{-0.41745252617956274,-0.8216302997179671,0.5497869285224466},
{-0.4630289405977861,-0.8433937529969218,0.5881114365116603},
{-0.4640549835265973,-0.8872583772022541,0.6142342832394083},
{-0.5204937896044837,-0.8924272618059387,0.6159293164697937},
{-0.5609412783773055,-0.9243402904887367,0.6023252246724654},
{-0.5826415707222002,-0.9502233834667876,0.5852202125300981},
{-0.6231767114035134,-0.9565317428808604,0.5318066862938196},
{-0.6435480461358399,-0.9571749532093488,0.4554244930368293},
{-0.6445418640982938,-0.9380719931528391,0.4482950414799767},
{-0.6275825088038609,-0.8921823520616244,0.4743225023073076},
{-0.618613656167343,-0.8820417996483612,0.42664759807990765},
{-0.5885993225023074,-0.8562940515290102,0.3863844361146487},
{-0.5217312283125978,-0.8101788356732954,0.404387880319053},
{-0.4665904438795767,-0.7860822948300841,0.45694808944619464},
{-0.4247714605385953,-0.7787440254912373,0.4965139031394851},
{-0.3941512975060455,-0.7952651212432134,0.5234501080180872},
{-0.3582062810326426,-0.8553144125517532,0.569321703128142},
{-0.4274255087677689,-0.8642871321842339,0.5922284982134479},
{-0.4403722112514115,-0.9260250117298877,0.6157333886743422},
{-0.5112619812424917,-0.9341353912626514,0.6226101964949549},
{-0.5583001201346747,-0.9616258655625963,0.5979645422250179},
{-0.5731210266616483,-0.9727112539894509,0.560419878421647},
{-0.6111323079778705,-0.9688171890548546,0.5269961433160264},
{-0.6251153653795586,-0.9715704901804082,0.4540697554511753},
{-0.6327024114586826,-0.9683969754935576,0.39828447169101155},
{-0.6392299006439838,-0.9337590036556002,0.4009320749269138},
{0.1726059427993957,0.2599465581157934,0.2995201058010095},
{0.19339104609974786,0.2709455836328108,0.22999538538481762},
{0.14436656028131103,0.2657109600977578,0.15465857003645286},
{0.24740782370623207,0.27680150451922947,0.17320726067161984},
{0.29274964036937545,0.27399406545019583,0.23596473815281332},
{0.2632650851512511,0.26572642808160923,0.2919691516842056},
{0.2486839323739746,0.25370909362770644,0.33938496718209427},
{-0.5133669160449397,0.5485082418573956,0.4010235938313681},
{-0.4853505302940464,0.552001428210509,0.30919790769738437},
{-0.5054150833466531,0.5628238609118894,0.3461161181547727},
{-0.5513665963732735,0.5745202347008752,0.35905766464379807},
{-0.5215804154700463,0.5788834951456312,0.2681716585287885},
{-0.4971435789821036,0.5706622617285989,0.2274173880762468},
{-0.47077066651542426,0.5488846294644468,0.2281031353603267},
{-0.4558595300826507,0.5153887104341865,0.24402097974209716},
{-0.47732909166842835,0.511267781736436,0.3422143192282508},
{-0.5061794595486443,0.5137181681782327,0.4041004336191473},
{-0.5456189513738149,0.5187465519286,0.46367666242156447},
{-0.5575176979515234,0.5497650155453238,0.4430269039799123},
{-0.5838970554114742,0.5660502245435657,0.41659985356975293},
{-0.6308217624220801,0.5865001881938037,0.35447269643050494},
{-0.5712867815766002,0.5870570356124549,0.3093512985372443},
{-0.5841136071853942,0.5910683994245911,0.25156935586159246},
{-0.5269903428220821,0.5860297036849895,0.18645816683767383},
{-0.48777642576141156,0.5810374118969421,0.1816798488262378},
{-0.4591322976658813,0.5535997865418231,0.18574019458723684},
{-0.437194829568598,0.5492429710903383,0.17142328653408886},
{-0.4195574609820108,0.5024806779101726,0.16442917983593627},
{-0.4422219243203111,0.4517843608371275,0.20316874539182977},
{-0.45847361935354153,0.4727550799436968,0.26317421074612396},
{-0.4710142872610842,0.4364426988538225,0.3318353020639446},
{-0.4912360981495136,0.4700997427158687,0.3856845098453717},
{-0.5156187966939763,0.4510689665839989,0.42823822241929577},
{-0.5388336624576565,0.46686693409092095,0.4549011595831894},
{-0.5735386622256368,0.45175471386807875,0.49781192478435055},
{-0.6078028244538514,0.4742786763530619,0.5151670026656492},
{-0.6302043320666774,0.5087065414103709,0.5110009590149988},
{-0.6076043186610914,0.5474899329205103,0.4635670975359502},
{-0.6576187554460194,0.57219359212989,0.4088181686938319},
{-0.7246518414634775,0.5912385472469568,0.3080919468520075},
{-0.6668041598564571,0.5948400094870302,0.2897662529840319},
{-0.6571276469587367,0.5928304605849994,0.2031274974348927},
{-0.5779973085708099,0.5886528159464604,0.16218245518151678},
{-0.5514542482817649,0.593976380388659,0.12120776595909231},
{-0.5113728351267602,0.6139635935220086,0.12452951549118581},
{-0.45164966047775457,0.6505247513521598,0.1111677554408633},
{-0.4310591959741995,0.6133629201491114,0.14020116112998776},
{-0.3848009012678591,0.6319348127600555,0.1196725685618384},
{-0.37760055478502086,0.5518918633248949,0.1351547313984604},
{-0.36196886810450174,0.5204544751455282,0.11765270767057318},
{-0.40819751584179353,0.4568604375377034,0.12694638796797095},
{-0.42049456300367627,0.4212737626901918,0.1347654538048662},
{-0.43428684860453015,0.40533916132591563,0.229107265312015},
{-0.4552111637595451,0.40791715863448647,0.2834836735430448},
{-0.8773324430649295,-0.40939692908960595,0.23130114102160876},
{-0.8946140480229339,-0.37667440925191664,0.15490734677672996},
{-0.8628002722365158,-0.4302825742849924,0.1345824159959577},
{-0.8428852430278064,-0.4452555826531716,0.2323400739369628},
{-0.8356140016189824,-0.4728349978602622,0.16298034534851946},
{-0.8308447065981264,-0.4785761978664494,0.11065086698049485},
{-0.8628505431840331,-0.42424490458831954,0.0792676167446081},
{-0.894302110348597,-0.355516785340476,0.10113676791321427},
{-0.901984542328138,-0.3326667061959586,0.17918692542884984},
{-0.9006723416980754,-0.35431930559064484,0.2147027053503756},
{-0.8927694909486515,-0.38955923980015356,0.2052479002211922},
{-0.8924214613119944,-0.3545680823309219,0.27101132256417926},
{-0.8705200851770312,-0.3792627185497217,0.30501252906691967},
{-0.837057680111782,-0.42912892048940693,0.3196181728186276},
{-0.7891404441373764,-0.5047441595470973,0.29394905361718804},
{-0.8184303605587037,-0.4956270720653367,0.22528538430205877},
{-0.7967133112313032,-0.521994828537399,0.1713459466148317},
{-0.7781375516243964,-0.5198086868197309,0.0843372484519126},
{-0.8128154824206364,-0.4820590722303285,0.058317521616507405},
{-0.8412353247503211,-0.4403135618126414,0.04181318284703709},
{-0.8647879081614241,-0.37849447535176767,0.04868999066764972},
{-0.879629438666866,-0.3394597291040427,0.01810591959741991},
{-0.918934874631991,-0.2888819999071921,0.08160972729944468},
{-0.9214200640374531,-0.3001285131658322,0.12355245451123748},
{-0.9282298439280432,-0.28857392922881775,0.20248557610505855},
{-0.917769619848517,-0.30325691289978285,0.2184717374155061},
{-0.9047520224388886,-0.30559902345461937,0.30811257083047605},
{-0.6781705499899459,0.5293343868749002,-0.5549944830857598},
{-0.6432090394897628,0.5441488484086023,-0.5643771042903032},
{-0.6677245048956171,0.5126328313113244,-0.49715453547066507},
{-0.7125945480512921,0.5091873379084193,-0.4870294510412532},
{-0.7090871827129813,0.4957521049348027,-0.42739650629804754},
{-0.671130039340239,0.47796650150297243,-0.3513507416898257},
{-0.6402069616239321,0.49706946155948223,-0.38795056947960554},
{-0.6186690831094773,0.5407755389303376,-0.44732442549329987},
{-0.6178260779895747,0.5664859060887143,-0.5024845449061353},
{-0.6249426395598844,0.5899946635455715,-0.6236645973941604},
{-0.6433753203161656,0.5598797879855015,-0.6137547757400141},
{-0.6528365704386205,0.5790665329545399,-0.6459423611361751},
{-0.6806531613980996,0.5768868362301431,-0.6278254850501936},
{-0.6992482559848209,0.5343924175943162,-0.5568093931909937},
{-0.7154226110987941,0.5376935431479412,-0.5163992853791461},
{-0.73838354412758,0.5120476259222786,-0.4012362786093252},
{-0.7258274082361859,0.4939281718389887,-0.3514615955740943},
{-0.7008040773605434,0.4801333082408263,-0.3365401471520864},
{-0.7079528638972101,0.46431600575409016,-0.2589024692058222},
{-0.6567525483503396,0.46273956039989916,-0.28165974044723097},
{-0.6113720617275676,0.4978763747170649,-0.31474060191081166},
{-0.5990505235912534,0.545302502204188,-0.39623109683473495},
{-0.5833814559497601,0.6035755533671224,-0.41637685680256153},
{-0.5964067873513141,0.629311700498585,-0.5345419414382132},
{-0.6052660751022176,0.6312065285203844,-0.6274001154942795},
{-0.6135569144465813,0.6211819859860068,-0.6802567943119069},
{-0.9385392551650178,-0.23914856482889826,0.2487064898504246},
{-0.935785954039464,-0.26571353809506615,0.1692178098366065},
{-0.9284090147409887,-0.2535415238026491,0.2924344801984027},
{0.9557409422064564,-0.5242389751945098,0.2917745128874086},
{0.9692393361141333,-0.5595768733017442,0.30242164177180597},
{0.969852899473573,-0.5149826758580863,0.24828498729047324},
{0.9172540203868029,-0.498658796900216,0.29471085182187073},
{0.9493268849027321,-0.49157059330030056,0.2400328179057381},
{0.9690098943536705,-0.5022783051214493,0.18761310963191352},
{0.98850084300512,-0.5367383951451155,0.22755788892956397},
{0.9911677812208366,-0.5730830012013467,0.2580001701478224},
{0.9786168013240595,-0.6061406606891502,0.29703749439285587},
{0.9489801442647295,-0.5988926212561034,0.34504367127440716},
{0.9437223187538992,-0.5477348426648242,0.328070136994777},
{0.9195471489927766,-0.5330815059629077,0.3351390056148781},
{0.8662174076690264,-0.5524706237206688,0.365221656208591},
{0.857969105280254,-0.5145392603210122,0.3250113431881577},
{0.8711375155324337,-0.48979177515738664,0.2856736822566757},
{0.9128340440012581,-0.4803988419636089,0.2598653512005733},
{0.924472412850801,-0.47681800370200406,0.21533818168693833},
{0.936964098809481,-0.4843251318645622,0.15663847196943526},
{0.9536153834255398,-0.503292747062372,0.1226230864814977},
{0.9689918483725105,-0.5424795951513026,0.09289877751367626},
{0.9909757204213478,-0.5416855719802628,0.1667545334082671},
{0.999358078670166,-0.5716238547246956,0.19924116649222218},
{0.9976308204734234,-0.6248517651547572,0.22008169673470857},
{0.9782584596981682,-0.6728050930914827,0.28038749877545127},
{0.9600500647077324,-0.6285163883288906,0.3310670588659905},
{0.9184424771460539,-0.6678308472845953,0.3755529804226885},
{0.9119008089755555,-0.6285344343100505,0.3834867671398151},
{0.9218376996014417,-0.5859252947939921,0.3668741524833848},
{0.8910602787330691,-0.5906958788135025,0.38365949295948937},
{0.8418566221016865,-0.6235176515475717,0.4102824711651001},
{0.8118680684097368,-0.6218496872889264,0.40868540183244045},
{0.8106177397150798,-0.5630223667046491,0.36467383178051965},
{0.8058832476578894,-0.5241526122846727,0.3226563426467783},
{0.8379483781818933,-0.4827860674713455,0.23816634785433283},
{0.8678002980164888,-0.47377209988192764,0.2274973059928125},
{0.88087590036556,-0.47249856921149364,0.1827922546648861},
{0.8835711965516708,-0.4802261161439347,0.1359500435681545},
{0.9092080907867532,-0.49143911543756336,0.10677098103109578},
{0.9442701431819707,-0.5181961495032198,0.08251460435475302},
{0.9423366452005425,-0.5463169441451102,0.05329687185806576},
{0.9608904918303266,-0.5928691305446276,0.05297848919045726},
{0.9842651934271383,-0.6065222042908186,0.09576422152215272},
{0.987864077669903,-0.5636758890223718,0.1288502389803505},
{1.0,-0.6252474877416228,0.15398700173757016},
{0.9873600791960774,-0.6872006300625423,0.19109340599848412},
{0.9748297232777691,-0.7044268080784123,0.2594773626056334},
{0.9378522188822835,-0.7348007723679937,0.3181242233783108},
{0.9470608252684984,-0.6855171978200455,0.33222844665350165},
{0.884570170508742,-0.7331340971080026,0.3790848367354305},
{0.871391448267328,-0.6811694053591407,0.4058238248199269},
{0.8663759545035036,-0.6424414407911357,0.40896511454042045},
{-0.29284889326575547,0.8211636822051158,-0.07853804350628261},
{-0.24137144300821356,0.8481952729841352,-0.04363711594285097},
{-0.217495320934885,0.8712541699106469,-0.08633261836874646},
{-0.20556306039216501,0.8693748098726988,-0.1307708469752358},
{-0.11754120928697756,0.9354939958442684,-0.1554384142222956},
{-0.14949677492536703,0.9094343100505805,-0.08204025284997606},
{-0.17008852842757635,0.8759835059732198,-0.04838320898792985},
{-0.22199263723968676,0.8483899117809323,-0.028936086290725947},
{-0.2639495434366767,0.8086887532289418,0.00794087620972522},
{-0.3773608010353237,0.7481896013900564,0.028612547628500254},
{-0.32782716074844426,0.7986990136582298,-0.03477396119598453},
{-0.34793167275933373,0.7656916251179435,-0.0750242331747006},
{-0.2236438445158264,0.828503240542617,-0.15249176329859918},
{-0.08375913255546565,0.9421297609165299,-0.2119210462544278},
{-0.052723911956235964,0.9770667804422816,-0.17472441208771383},
{-0.09417553068074601,0.9494229153024767,-0.12970484508814178},
{-0.12460878890842442,0.9137653455289795,-0.0850590876983125},
{-0.1595329184476332,0.8513404297005915,-0.05338839076252008},
{-0.20361409442688547,0.8357126100160353,-0.014347199521523721},
{-0.22676579925650564,0.8019369782777949,0.006446926769408425},
{-0.26031843422755474,0.7584474526808596,0.03619314871435272},
{-0.2714167126409521,0.7727295577703419,0.03745636739555241},
{-0.3469868367457425,0.7485788789836504,0.049300976029781},
{-0.45133514480610887,0.6931313128709095,0.04164948001794284},
{-0.40963346034266745,0.7313668799529774,-0.013448767459486807},
{-0.41040557053658444,0.7034291231199956,-0.04610554836580752},
{-0.37318057839947616,0.6864504328457484,-0.08630812739431505},
{-0.2872829970765511,0.7549310643519689,-0.13460303997442633},
{-0.213443998164466,0.7696733419610313,-0.18003121954740683},
{-0.09975689485380182,0.9010828877694655,-0.2222833064362281},
{-0.059493732888542906,0.8974479115643806,-0.2610254499894303},
{-0.01244399300847133,0.9741020835374249,-0.2779989842690605},
{-0.024295046635971356,0.9892194597548843,-0.2418992879571434},
{-0.006057004676487147,0.9905058804118609,-0.23840481260537572},
{-0.020395825706758006,0.9704052353969345,-0.20178049384116448},
{-0.06763375939035524,0.9452594496491347,-0.13679820468267434},
{-0.0974972802128395,0.9128089085274997,-0.10761785314696136},
{-0.09752048218861664,0.8607887898365036,-0.13195930373448694},
{-0.17106043341290755,0.804725082367014,-0.06287026486344352},
{-0.6207572609294197,0.6234532016148578,-0.14324706495006423},
{-0.599482338140439,0.5987804783731807,-0.15927576321610323},
{-0.6067935385075458,0.6605853858488575,-0.23952108543998685},
{-0.6498589835472214,0.6646135066434992,-0.1579210256304493},
{-0.6419780457749203,0.7040607324605956,-0.24733886227822782},
{-0.6024908609995412,0.6853367380084457,-0.3149120387318316},
{-0.5810651253680092,0.642585808640416,-0.3135353881690548},
{-0.5847439275273397,0.5995848135334548,-0.21082153040232235},
{-0.5933106125837205,0.5380518847738325,-0.09996249013916034},
{-0.6142877766835613,0.557826413129225,-0.046864768573181635},
{-0.6487697796843501,0.6050746588020564,-0.06085298196948685},
{-0.6776485055349603,0.6504899483884942,-0.09935923876895476},
{-0.6664561302198001,0.7368850831919732,-0.2897327390190205},
{-0.40050734987032677,-0.9798535955328463,-0.17963549696054124},
{-0.4472696430504927,-0.9851023980530964,-0.1366370798508887},
{-0.4367952399857696,-0.9566567757503261,-0.14048216283662202},
{-0.39793837555233597,-0.9543275551820324,-0.15234610645066493},
{-0.3902997695270407,-0.8952385678709351,-0.1338953797132236},
{-0.44990306730119783,-0.9349448824175427,-0.13252517414371826},
{-0.5531054555579045,-0.9489240728232679,-0.10328295067259953},
{-0.515725783582282,-0.9832359280016911,-0.1248272741803258},
{-0.5048285889589532,-0.987670083372433,-0.0985097886557807},
{-0.46312690449551175,-0.9880825629418043,-0.004247895065197579},
{-0.39599069858571073,-0.9864738926212561,-0.1459449391334836},
{-0.3703550933492826,-0.9721170256098253,-0.25626517795915427},
{-0.38234020283682835,-0.9455159603813373,-0.2100610211962939},
{-0.389144826732801,-0.918547530536378,-0.16157146981938555},
{-0.36589129100949225,-0.8726462884572748,-0.16384913044150787},
{-0.3406307843814612,-0.8235328617316923,-0.13263087203336965},
{-0.43761891012585785,-0.864187879287854,-0.11003472562374647},
{-0.48063279521936186,-0.9070909104970893,-0.11681485854528773},
{-0.5874418017107591,-0.9023873544076019,-0.07633127781014602},
{-0.6311685030600829,-0.9497786789310592,-0.0737958174571666},
{-0.6047350076566521,-0.984486256696348,-0.08409878370086983},
{-0.573567020196031,-0.9828969213556141,-0.10105040500337722},
{-0.5388426854482364,-0.9885427354613843,0.016312922469308908},
{-0.4693205430293531,-0.9869559781179588,0.199398424328045},
{-0.44534903505560747,-0.9861774229307705,0.12265015545323768},
{-0.372199650423565,-0.9854310927099392,0.10198879602369694},
{-0.39003552480291215,-0.9880322919942871,0.06505382858380293},
{-0.38127677894704287,-0.9866994673857561,0.007577378589216729},
{-0.3642400837333527,-0.9867600503225075,-0.1423731238624587},
{-0.35402348039948656,-0.9859466921716533,-0.2633701385415754},
{-0.33082279362100353,-0.9791730042433835,-0.33228387359563605},
{-0.3533789810723438,-0.9541367833811981,-0.29350434908145956},
{-0.36339707861344994,-0.9169414382131384,-0.25284417553068084},
{-0.35100077855518724,-0.8791467086708361,-0.21283623529897042},
{-0.6968674754703557,0.6601252133292774,-0.10634432247652739},
{-0.7143952791713286,0.6292163145981677,-0.050811682452603556},
{-0.7410865743056165,0.6885257206791476,-0.18112944640085799},
{-0.7631181393046628,0.6891044810749221,-0.2131855539342817},
{-0.7571062495810756,0.6395708407880423,-0.1154472309730909},
{-0.780841870801087,0.612140949424849,-0.16307573124893662},
{-0.7914387287379674,0.6519645628489966,-0.2902496274793889},
{-0.7584455191828782,0.6335563730671468,-0.32774273133658854},
{-0.7846959767774004,0.721284332479157,-0.45495271952936084},
{-0.8028773027960961,0.7771624241424293,-0.5141938086816639},
{-0.784947331514986,0.7750226863763156,-0.5366829682029812},
{-0.7779390458316364,0.8202394701699934,-0.5979065372855752},
{-0.737353634202806,0.8769347869800826,-0.6758741988873364},
{-0.6617113261733755,0.9011151127358226,-0.7390312659513585},
{-0.6289385353881691,0.8572375985439473,-0.760798586226276},
{-0.5957790450066771,0.8759590149987885,-0.7593652197227108},
{-0.5763976612408418,0.8381269044955119,-0.7624356145172185},
{-0.5749720287292021,0.8060785309540137,-0.7319379063568259},
{-0.5820280073627604,0.7540674352535978,-0.6591790883170319},
{-0.586637466550485,0.6903638327601589,-0.5045366307637575},
{-0.599545499074499,0.7073979499765405,-0.4049112137726929},
{-0.20943134535367547,-0.18296498048456025,-0.28286108719302505},
{-0.14594171663684788,-0.13960564375170786,-0.2848409891260074},
{-0.16276830506988957,-0.21895382291220883,-0.30226567293463746},
{-0.1992405219928951,-0.2830686159763649,-0.30483206925531975},
{-0.1773275448700432,-0.2774833848073462,-0.33602196969306375},
{-0.11575465715213797,-0.21107030714259928,-0.34681733342270393},
{-0.10353881690547519,-0.18426171313077144,-0.3052329478368025},
{-0.06354376666030764,-0.1513548664855193,-0.29420814234669945},
{-0.08931729475274432,-0.10687667892074708,-0.2881446926769409},
{-0.14294221676832572,-0.07406521817591208,-0.27518381120810115},
{-0.19197185858137972,-0.09719501002840948,-0.2690146636486912},
{-0.2890850171952421,-0.14138188389731313,-0.26334822556445253},
{-0.2529556739142765,-0.21297158015767026,-0.28425449473830755},
{-0.2572261264559241,-0.27700129931064343,-0.2885623282409293},
{-0.23082227802154182,-0.3366484230390463,-0.2941501374072566},
{-0.20352902051570262,-0.36363103186920265,-0.3559950038412161},
{-0.17959876049889406,-0.3187107177660106,-0.3741247699137403},
{-0.15936792661988466,-0.31915026630712184,-0.41485841638781334},
{-0.1405975282161806,-0.25872329839287644,-0.39223262300914163},
{-0.08467818859597115,-0.21603939695486943,-0.393783288390247},
{-0.028959932765830233,-0.1751858736059478,-0.336398357300115},
{-0.004399352407076122,-0.15591147672841815,-0.3021677090369118},
{-0.04107780911476733,-0.09499726732285278,-0.2824279836451851},
{-0.06432489984480459,-0.046051410422327375,-0.26868854698915695},
{-0.13474031833110772,-0.03452518445570727,-0.25518886408282593},
{-0.21141511428262075,-0.056326018695636415,-0.24704110358908793},
{-0.2844033740828775,-0.08782012281579163,-0.2469611856725222},
{-0.3218758539616085,-0.07973681225476796,-0.24942961809547876},
{-0.37032544638023407,-0.15006715682988822,-0.2609867800298017},
{-0.3283840081670955,-0.19554560735038579,-0.27172284982134487},
{-0.3520306884799613,-0.22259653310921937,-0.26928406436743685},
{-0.32396016478558803,-0.27957800762055995,-0.2661015266900062},
{-0.25460945918772465,-0.3201453732682303,-0.2719007316356362},
{-0.24064702576450517,-0.3861433933662972,-0.2686743680039599},
{-0.21214082052498343,-0.39354740163651264,-0.33080668113782496},
{-0.2115259681668893,-0.428975529649547,-0.3380547205708718},
{-0.1859367668820154,-0.3833462662864979,-0.3957232313649465},
{-0.15635811476212824,-0.39836954560219434,-0.4326852677765805},
{-0.13100480023098862,-0.33050118845675913,-0.4495956411221507},
{-0.11612717776322647,-0.27408429535599554,-0.43310290334056895},
{-0.08359027373175427,-0.2666287271396088,-0.4452839406235661},
{-0.03745701189487962,-0.2221672965573423,-0.4273629923330361},
{-0.005460198299553016,-0.19256157546571515,-0.39447290267028967},
{0.08649180970255063,-0.1536918210457387,-0.33835119026135746},
{0.10652155979149154,-0.13188711980984685,-0.2947791687505479},
{0.0131297402925511,-0.12146685468860353,-0.2866971471881784},
{-0.0019670119464395633,-0.044605153932219206,-0.2645121913492723},
{-0.06550175561616718,0.009296902794033569,-0.234765969404328},
{-0.14709537043243331,0.013091714832249876,-0.21293806619265895},
{-0.20514284683086798,-0.015295902531077618,-0.2250482085496703},
{-0.27309756688614023,-0.03400958499399317,-0.23838161062959856},
{-0.3779769423920722,-0.06560036401321984,-0.24459200614594562},
{-0.439678729975406,-0.12125932590526363,-0.25956759251143346},
{-0.44262538089910247,-0.17447047935281945,-0.2656993591098692},
{-0.9820713177175444,0.26772566499440587,0.2758656914962181},
{-0.9600616656956211,0.29603078644385916,0.33734190431505195},
{-0.9770687139402627,0.2582321899055939,0.3437224476537647},
{-0.9981605989203349,0.20625589716884352,0.3052832187843196},
{-0.9989262641209804,0.20655494485663775,0.2669123068435516},
{-0.985831326792095,0.21600974998582118,0.19318545081438931},
{-0.9735948625669637,0.19445640348751492,0.13716556929914564},
{-0.9378599528742094,0.2367072013776819,0.07770148337965133},
{-0.9185881339939882,0.19096063913709285,0.026506323827397905},
{-0.88723453072715,0.18636278093725683,-0.016129884660400447},
{-0.862358145698096,0.15610869352252404,-0.028974756250354512},
{-0.8060624184708352,0.19919605153932227,-0.05974959912141855},
{-0.7537007151364535,0.21459314046476155,-0.08432564746402409},
{-0.6934078030822537,0.25516179511108605,-0.09384748052323037},
{-0.7134014612088746,0.31852896895575644,-0.08090980103016777},
{-0.6668582977999372,0.3756238753486742,-0.08149500641921333},
{-0.6910631145301086,0.4013819354572596,-0.0899315026115113},
{-0.7608765706448603,0.416256979927713,-0.055771749274293785},
{-0.7455310416655926,0.43609209121985704,-0.07306237722287821},
{-0.7692808418708011,0.4913811104981207,-0.09609936117226697},
{-0.7777057370752107,0.5331201759225365,-0.05284958932502878},
{-0.7685409566432413,0.6085343311901585,-0.0973600018561581},
{-0.7435949656868559,0.5973406668763439,-0.014348488520178008},
{-0.7340486416532181,0.5831371907047732,0.04938733893961813},
{-0.7715224105306034,0.5793359336732854,0.12182132931853218},
{0.17650774172591763,0.26522500760509227,0.09184308761581651},
{0.1158100840942722,0.2327822004753829,-0.005939061299620022},
{0.060201393149745513,0.20073253793523058,-0.04793205945892994},
{0.10032147626437876,0.1949913379290433,-0.08132228059953908},
{0.16007558688108725,0.20952093076014847,-0.07047277892641883},
{0.1772850079144517,0.24544532325508264,0.005329364936142988},
{0.22904474887728216,0.2641164687624067,0.05244742174489168},
{0.2626644117783541,0.27374271071261014,0.11202493954596308},
{-0.6907021949069085,-0.9371361801298279,0.007094004093859701},
{-0.6702200062903135,-0.9672033627396892,-0.04800811037953279},
{-0.6981345611475183,-0.9771544323507726,0.009004300099510669},
{-0.7176267987976221,-0.9525319800566128,0.03912819865016059},
{-0.7050474609304509,-0.9757726257933788,0.07327763999814382},
{-0.6736990136582298,-0.9852506328983393,0.016559121212277435},
{-0.6480762984083445,-0.9836716095468395,-0.060409566432412694},
{-0.6660230266719603,-0.9367829944985537,-0.044772723757276436},
{-0.6423595893765888,-0.8987240202321228,-0.04557705891755051},
{-0.6357534712733761,-0.8740925449473831,-0.016391551387220378},
{-0.6759676512897721,-0.8852707412773461,0.02159266095726193},
{-0.7012887408545546,-0.9222057087172401,0.02905983016153729},
{-0.711723184960995,-0.9355584457769826,0.07039415000850738},
{-0.7184736709134877,-0.9635748315278759,0.10972149895075507},
{-0.6816817823242194,-0.9754387751419188,0.1454074266946465},
{-0.6513310200104153,-0.9835904026316197,0.13159193911801556},
{-0.6190390257232572,-0.9879807320481157,0.05548430257438809},
{-0.6118361012431104,-0.9872498698111358,-0.04695886547494449},
{-0.9788101511222024,0.13634963315098317,0.44051464560271003},
{-0.9757513573155832,0.1438786742906642,0.39621820684819203},
{-0.9656443188673314,0.0895409360192629,0.4162389339465529},
{-0.9695680307709759,0.07685461126378591,0.4811181032127002},
{-0.94125001933498,0.04793850445220152,0.4424816575491495},
{-0.9303811826820454,0.05614555888403671,0.38577473975117177},
{-0.9769849290277342,0.11968674754703572,0.3645964918612625},
{-0.9982353608422834,0.15366604107265325,0.3229038303884011},
{-0.9896274278289654,0.18810808511515922,0.35699526679694144},
{-0.9729361842546239,0.2251564844366304,0.40260519518017623},
{-0.9670222584287624,0.22326036741617655,0.4890583349230983},
{-0.9810117608237219,0.16650317867068165,0.4898897390551124},
{-0.984653182022078,0.12949602730614765,0.507813265342951},
{-0.9724192957942553,0.10331904263491966,0.5501955410958551},
{-0.9574411314314589,0.06325567546107495,0.5365334443590841},
{-0.9468094705309129,0.04524449726474498,0.5053190529469088},
{-0.9148358589113634,0.02141220114566215,0.4978957096968791},
{-0.88739694455759,0.015007166832517972,0.4603922938504453},
{-0.8820463111436513,0.023899968548432966,0.41117961422848276},
{-0.8638469391437956,0.01209016287787008,0.38678660369478574},
{-0.2682792899164214,-0.7813671377527082,-0.13075408999273008},
{-0.24183934951971914,-0.7831059969373393,-0.14672349432067197},
{-0.265734806572862,-0.8052484158206538,-0.20192228369313586},
{-0.31086007146208544,-0.825360661823469,-0.21217368999066769},
{-0.2241529989842691,-0.8074152225585076,-0.2683598523323142},
{-0.18474573212545572,-0.7804339027270054,-0.2310484972853689},
{-0.18796565076386065,-0.752280883118758,-0.15989448257016026},
{-0.20720266668041604,-0.7537464745886805,-0.12124772491737523},
{-0.2345655301135866,-0.7453177123883081,-0.11427166420038261},
{-0.27759359419228774,-0.7173206616172292,-0.12146298769264088},
{-0.30871259970404596,-0.7845857673924588,-0.126372783566814},
{-0.3267560028667331,-0.861166466442209,-0.2581406710011395},
{-0.26578378852172485,-0.8342972894936297,-0.2931769434232711},
{-0.1816469793605536,-0.8087686711455073,-0.3025505416372346},
{-0.1573699787057423,-0.7590610160402992,-0.2667395810238774},
{-0.1736358527241698,-0.7482231153550676,-0.2087385085769971},
{-0.18675914802344953,-0.7082319321058629,-0.16635236582813012},
{-0.20225806784257722,-0.6826105058546319,-0.13692323755214003},
{-0.22036849893528718,-0.6848146935534599,-0.12329723277768903},
{-0.23797106455820866,-0.707248426132643,-0.11682001453990487},
{-0.2812943093287411,-0.6683412907516924,-0.12920213561297048},
{-0.3416993642658638,-0.7024546401373556,-0.12786673300713078},
{-0.38245105672109686,-0.7585583065651279,-0.10760238516310991},
{-0.38134122887975713,-0.8077142702463018,-0.11090222171808056},
{-0.44491077551315045,-0.79766136974153,-0.08312558971688438},
{-0.4849200047435151,-0.8032582018984371,-0.05718578079804489},
{-0.554661276933627,-0.8676346616894133,-0.06657226899855119},
{-0.8022611614393474,0.5829038819483475,0.21428378078773286},
{-0.7333860963449156,0.5926448447787821,0.20420381131122095},
{-0.833927991379177,0.5746104646066752,0.2730054034823588},
{-0.9026097066754665,0.549819153488804,0.21917810867805454},
{-0.9290406240815887,0.5354687314706444,0.27802218624483754},
{-0.92240872600529,0.5132025687165184,0.35481557007254483},
{-0.8917962969646662,0.47120699255990006,0.4680257438811234},
{-0.9155551201604548,0.4300312195474068,0.479377955029415},
{-0.9320684819205051,0.36557226384255664,0.5045276077731775},
{-0.938910486777452,0.36435158211694835,0.45919352510195977},
{-0.9384735162336492,0.3810028667330072,0.39689364214303763},
{-0.9368442219346326,0.36410022737936276,0.34214858029688217},
{-0.9325338104347021,0.3396775698766171,0.35363742530252795},
{-0.9483962278743382,0.2883741344374038,0.419761767268715},
{-1.0,0.15063560523642827,0.24989365761102147},
{-0.9827196840406501,0.1303325874327789,0.1636905836070307},
{-0.9541271158912911,0.16261942572531968,0.09773381146590082},
{-0.9380958396279434,0.13702249044852005,0.06451631614496592},
{-0.9079654960840222,0.12270171539940926,0.01681047594986309},
{-0.8464957282584599,0.07847874956818557,-0.010844990177830279},
{-0.8048082227802157,0.13407197252886077,-0.05403804608427993},
{-0.7345951770826351,0.12907581374485055,-0.08253265033591307},
{-0.7037223703138454,0.18736175489432796,-0.09167551779075947},
{-0.6073761658992829,0.22672777379620426,-0.09109546839633104},
{-0.6659688887284803,0.32003838637992466,-0.08834474526808599},
{-0.6220565715729394,0.31410383657559476,-0.08517380857854387},
{-0.6232991662756705,0.3891789851971395,-0.07995078603137941},
{-0.6364727325224673,0.412873358460214,-0.10175806526457991},
{-0.6317369514666228,0.43101859251658947,-0.14311945408329},
{-0.6627219011183354,0.4351188972358715,-0.17403995380228826},
{-0.719486823855756,0.4321799803041007,-0.12251738859184633},
{-0.6969809073519329,0.07686879024898303,-0.08345170637641856},
{-0.6521031302043323,0.11270939783138882,-0.09342468896462476},
{-0.659251916740999,0.06165345013379821,-0.10348661245997662},
{-0.763738147657374,0.0114108605870616,-0.06174239104094378},
{-0.7461110910600209,-0.029543204656894174,-0.0975185486906352},
{-0.697559667747707,-0.03357261445019044,-0.1290848367354305},
{-0.5927563431623778,0.03337153066012215,-0.1562672403570011},
{-0.5627471654919594,0.09543037087069296,-0.12725445864634521},
{-0.558478001948966,0.13226350741689843,-0.10179029023093704},
{-0.645986831589748,0.16287851445483104,-0.09571395057463565},
{-0.7630266204002083,0.09007973745675422,-0.0654224821989286},
{-0.7762955725474223,0.04917078716569831,-0.0404043073179032},
{-0.8119376743370682,-0.08554246219366936,-0.06632220325961982},
{-0.7584764551505808,-0.138084625339651,-0.1346404209354006},
{-0.6838756580338131,-0.12727637162346792,-0.17228175963784298},
{-0.6306786835714545,-0.03937568639178335,-0.16544877777147604},
{-0.5634200227894963,-0.03439628459027875,-0.2005688351061362},
{-0.4998388751682144,0.07120364116339876,-0.16968056035349502},
{-0.45776982608830163,0.14750591650382333,-0.12007989213659266},
{-0.47421358192102053,0.18331558811852608,-0.07559654857720331},
{-0.512650232793157,0.1888350803561762,-0.07355477470881523},
{-0.5812971451257806,0.1652193360110134,-0.09397122439404175},
{-0.857159614125363,0.5085711965516709,0.4540259294969296},
{-0.8989077025403588,0.5335816374407707,0.3526397403441111},
{-0.8433505715420034,0.4509529567051134,0.5424409251916741},
{-0.890928800870332,0.4186815863964239,0.5327695682885707},
{-0.9047455774456175,0.36053614610026374,0.5645665870924831},
{-0.9405887630253316,0.24356467421848024,0.5736720735863552},
{-0.9478793394139696,0.27127427828965356,0.5107148013137475},
{-0.9346825711913958,0.3399998195401886,0.41171970466462837},
{0.2687394624360012,-0.1847863355830655,0.7014608221749017},
{0.25626582245848134,-0.15269026909135905,0.6705093864882006},
{0.2008517703107518,-0.17983142475599248,0.7127924093447248},
{0.21498435155633697,-0.21850911837648032,0.7331908130487912},
{0.14409329256660253,-0.2180721478326776,0.7395739343848127},
{0.10223950626195544,-0.19016274897009,0.7209143898653769},
{0.1409984067976633,-0.16502727521152463,0.6989717657734766},
{0.18883056886088612,-0.13812329529927966,0.6616694337171112},
{0.24762050848418912,-0.12870844912837895,0.624137659900283},
{0.28288235567082065,-0.10974470092653214,0.604608041289205},
{0.3092874931038572,-0.1455737075210493,0.6432328859648672},
{0.33915230292499576,-0.18908514609510732,0.6753431314417708},
{0.2784211313283389,-0.23844090456769554,0.7243843742427134},
{0.20052823164852615,-0.27145989409587046,0.7480619905232818},
{0.13121748500894562,-0.25441933188621735,0.7522860391133752},
{0.07201635481492555,-0.2292696791424549,0.7423027445359347},
{0.0310236196113411,-0.20063715203481314,0.7150816709547356},
{0.06570541740354419,-0.1649563802855389,0.6841276572707259},
{0.11943990430473987,-0.12812582173664194,0.6312348864907785},
{0.19011698951786293,-0.11882311844866428,0.60722341955875},
{0.2043217546880881,-0.11268232885964863,0.5900049755348056},
{0.2713651526947806,-0.06336137335072611,0.567750413768568},
{0.34180635115416935,-0.06339230931842899,0.5811585777704449},
{0.34096334603426676,-0.11684966150895325,0.6297448040464246},
{0.3872641776961985,-0.1729159469757512,0.6474956045145889},
{0.3894735213896437,-0.22015130266203992,0.6825254319434491},
{0.3378259233097361,-0.25554333871275436,0.7179252019860891},
{0.26177886970286,-0.3069550500389277,0.7544580018458462},
{0.1670000876519085,-0.3269564421574743,0.7563876328313114},
{0.1276675827150436,-0.33153109838153316,0.7560086672269515},
{0.10702298026800856,-0.3372349174267461,0.7616364353515616},
{0.07641441822334735,-0.27489507550954106,0.7495237149972416},
{0.040921840277598716,-0.2625052204445498,0.749638435877473},
{0.020104512010889426,-0.23628956581369315,0.7385891394129385},
{-0.032489211081263666,-0.2323942118804427,0.7128542812801304},
{-0.04538177562142629,-0.20821775312066565,0.6840812533191716},
{0.012090807377197062,-0.16926292478950636,0.6654023738199217},
{0.06704210900803817,-0.11697469437841895,0.5887366008589887},
{0.13594037607824735,-0.11519072024088803,0.5904161661055226},
{0.11818184161815731,-0.09161751285131643,0.5825352283332216},
{0.21690882654718505,-0.07328795198737796,0.58337694445447},
{0.23172199908223293,-0.010668397362193037,0.5690291004336192},
{0.2846830867908574,-0.009233741859973343,0.556296371726588},
{0.3318037215969146,-0.03926998850213191,0.5507330535346922},
{0.4099763339847073,-0.03717407669026382,0.5580622998829589},
{0.3709635007141053,-0.0788435361873481,0.6042638786485107},
{0.3904106234113091,-0.12102086115422084,0.6307914709537044},
{0.4353502724943155,-0.1681672759333639,0.6306187451340302},
{0.4197160078164878,-0.21847818240877742,0.6628230875126966},
{0.3781316222305864,-0.2650058778338634,0.7073618580142202},
{0.31504931708851297,-0.30582459821911934,0.7424651583663748},
{0.29584710413562326,-0.3447652475650815,0.7469199377155851},
{0.23274804201104413,-0.3391026764768057,0.7595895054885564},
{0.19003707160129724,-0.37580304616161975,0.7609738900432588},
{0.13998783185270353,-0.4010687087842679,0.7663361244450861},
{0.06989208503266318,-0.39025529907346773,0.7628442270906269},
{0.056648912858534926,-0.32135316500729566,0.7572873538920026},
{0.0015145734187853093,-0.2950034545163933,0.7504994869785356},
{-0.041522513650495786,-0.28513745881649294,0.7356528004784764},
{-0.07799473057350133,-0.25158611284409815,0.6930011240068265},
{-0.08149178392257762,-0.20156136406993574,0.6295617662375161},
{-0.018343739849135628,-0.1631672501533907,0.6229749831141177},
{0.021671934374500473,-0.13177368792826963,0.5927144507061135},
{0.01659585767392455,-0.07465429056092057,0.5723366709805155},
{0.05131503642710194,-0.07195126038288405,0.5793784706288767},
{-0.776022304832714,0.5808208601230223,0.33535942438476096},
{-0.8309310695079635,0.5627606999778294,0.352928476042671},
{-0.8833378877952451,0.5574422915302477,0.2817821953193881},
{-0.8367960133849622,0.5458709506107277,0.4013729124666794},
{0.3004913662870136,0.25615174607757724,0.031078402054148233},
{0.32510995158521055,0.2675555171720402,0.09999729310282598},
{0.3163176917643298,0.27484093756606126,0.16969989533330926},
{0.35544653491381756,0.2660319207626749,0.2039717915534496},
{0.3391187889599843,0.2612239557821904,0.28612225378836703},
{0.3284278341213412,0.24223829460322063,0.35626827155592455},
{0.2721901118335232,0.2278002206765698,0.3883643380476311},
{0.19653233582024138,0.2242103594243849,0.39591787016174357},
{0.21696167549201076,0.1676271854972185,0.46702934792136075},
{0.17536697791687503,0.11565089276046812,0.5134320104769811},
{0.18891048677745179,0.016497249276871816,0.5661133854776256},
{0.11921819653620278,0.02172156082269067,0.5609973498187668},
{0.06692738812780676,-0.004072591248214571,0.566612227956834},
{0.02089209018865781,-0.026752522570366307,0.5650022686376315},
{-0.016204002083021862,-0.06591616868351984,0.5708336985496187},
{-0.0782344843231984,-0.09416973018680151,0.5803980685644164},
{-0.11371159428509561,-0.1474556455563059,0.5889840886006116},
{-0.1487659126883872,-0.15945235603174024,0.5831887506509443},
{-0.18132086270101938,-0.1706408643509376,0.5946621276727387},
{-0.24659446555537803,-0.13332177531206643,0.5648140748341058},
{-0.2163094421729424,-0.0813867305322532,0.5442184543359337},
{-0.2503854105976314,-0.049117938220872376,0.5172384235030859},
{-0.24043562998520235,0.029579296619214487,0.47096981680751127},
{-0.2514643024712683,0.1110659245471749,0.4144936297686505},
{-0.30744422502822916,0.16128015612351712,0.3579877957607412},
{-0.2681851930146586,0.18140142511691232,0.33250687036282733},
{-0.34370504617193187,0.18508022727624288,0.30937450051302146},
{-0.35428643612496075,0.20512157835307238,0.28715603070910395},
{-0.3663940004846636,0.24750901010059354,0.2817718833301538},
{-0.38344745268085945,0.2971754172488646,0.23681289926733315},
{-0.3644862824763211,0.2718685066692792,0.16277539456248807},
{-0.3677977200191804,0.2418412830177006,0.03949685226528621},
{-0.32638348225564456,0.2332836209518999,0.03296549608402206},
{-0.3214079474501029,0.2155598894554755,-0.034699199274035995},
{-0.2761653836833395,0.18693380734110523,-0.07532199186384053},
{-0.24908867795142028,0.16388264440651934,-0.08778789784943467},
{-0.24599508118113528,0.13208949259856992,-0.11804971925609312},
{-0.21684437661447084,0.10635979046037894,-0.13463913193674631},
{-0.14128972049353186,0.13576184976462902,-0.09710091312664673},
{-0.1646025501549377,0.09004622349174285,-0.15717082841365518},
{-0.03629046811275133,0.1410029182929535,-0.10397772094725938},
{-0.019590201547829627,0.12288346420966344,-0.12410930192988882},
{0.4129500538801437,-0.19560619028713722,-0.29588770759323335},
{0.3514467720895699,-0.1801059814693553,-0.3147315789202317},
{0.3628389421961444,-0.15351007223548452,-0.2776754456068349},
{0.40735451072189083,-0.14323417496352128,-0.2753384910466154},
{0.3519920185203327,-0.11956687067218688,-0.26588497491608626},
{0.29741194850192576,-0.1320263316645097,-0.26830055839421707},
{0.306576728933895,-0.1601303693238944,-0.3005693507055979},
{0.31123517007048246,-0.20164257098515578,-0.36350986599569995},
{0.3931433005583942,-0.2093172689727711,-0.3215465148054386},
{0.4324332685396677,-0.2583030848315794,-0.330563060392165},
{0.4624592031925919,-0.23565924547174763,-0.3017281604958005},
{0.47228008393959237,-0.1757427210245991,-0.2746037618136727},
{0.45709825778941887,-0.12690385101237944,-0.26611441667654906},
{0.3910087187868976,-0.09795165223847502,-0.259050704051065},
{0.30812094932172884,-0.10623089059495013,-0.25456112173818896},
{0.2729106620812688,-0.08035553160882486,-0.2582231669150138},
{0.20788712496584152,-0.1154201620013507,-0.275530551846104},
{0.22790527406689384,-0.14073351757420755,-0.294838462688645},
{0.2501288998654285,-0.17028123372639192,-0.34706095416836386},
{0.2059355810032534,-0.19319318480631498,-0.3940990930605469},
{0.31381316737905324,-0.23808900793507567,-0.3887729506210396},
{0.38538223966094176,-0.24525068445828538,-0.3581811455588841},
{0.42569438357506356,-0.30513885093503956,-0.3540847078355651},
{0.5088309297805093,-0.30351986862525704,-0.30218317702076325},
{0.5141660952105966,-0.20822806510989994,-0.2671894415542231},
{0.5247784211313283,-0.15637164924799812,-0.24909963443998173},
{0.5291416815760844,-0.09656468968646383,-0.2169584529953751},
{0.4404985331195314,-0.09915686598023175,-0.2578699812837396},
{0.46168967099598346,-0.07912453789398238,-0.23009721627850624},
{0.377917648453975,-0.06959497084285027,-0.23761078943433592},
{0.34474655708459445,-0.01231960463833261,-0.23189794739854294},
{0.24984660916013998,-0.03450842747320165,-0.24650488014890515},
{0.1806351154169395,-0.05642784958932488,-0.2703900252128137},
{0.13097773125924855,-0.1022285497733939,-0.2840572779442019},
{0.17677198645004613,-0.15146314237247924,-0.33412069667799277},
{0.11075463137216482,-0.1724106595032714,-0.37803172483487935},
{0.0823631470128745,-0.2005765690980617,-0.4163794347998701},
{0.13391149219640214,-0.22269707500425368,-0.4296922129013298},
{0.19418635826944194,-0.23084354649933742,-0.4231557007254485},
{0.24873678131880025,-0.26160678838251283,-0.4143634409045677},
{0.3022933864057046,-0.2836886243290761,-0.4055647360904156},
{0.3677306920891575,-0.28541201552985573,-0.37868009115798484},
{0.37451727000397006,-0.34411430324466735,-0.3775393273489423},
{0.465404565117634,-0.4013303755110879,-0.33851360409179737},
{0.5221321068940804,-0.38557236696244884,-0.30894526396114447},
{0.556188740338955,-0.3298644231215422,-0.2793189188910487},
{0.549833976973328,-0.26479061505859774,-0.2735197139454187},
{0.5876802664618018,-0.24485367287276535,-0.2434654213221002},
{0.6233120562622133,-0.22774350473578103,-0.21554699946893258},
{0.5868037473768877,-0.15738351319161206,-0.2064337789831348},
{0.5916967862685552,-0.09896867217670612,-0.18414828124919444},
{0.5816348627732033,-0.021569458981484768,-0.14360927357191844},
{0.5429262331850125,-0.010772806253190152,-0.15593467870419547},
{0.4964423637141723,-0.007599291566339531,-0.17528899349829083},
{0.4473547169616755,-0.04995965434212077,-0.20942296686242268},
{-0.6720761643524845,0.5977699034282209,-0.006307714914745659},
{-0.6181985986006632,0.5537918473413116,-0.007152009033302603},
{-0.6741823881535869,0.5857448349823924,0.040208379522451765},
{-0.9905103919071511,0.09977945233025191,0.25966040041454197},
{-0.984480456202404,0.10385655507375668,0.3202472041619189},
{-0.8017958329251506,0.23656412252705625,0.7041999443152581},
{-0.8333969239336115,0.25740207477223415,0.6909026341976499},
{-0.8262442704009818,0.19894598580039102,0.6913885866903156},
{-0.7899061093380219,0.1722933606257316,0.691151410937927},
{-0.863663901334887,0.1992540564787652,0.6692835487679751},
{-0.8681405936612203,0.25002900246972154,0.6698403961866264},
{-0.8646822102717725,0.29855335681029566,0.6521798256242621},
{-0.811788150493171,0.3136900680075691,0.6763704633692362},
{-0.776696451128905,0.28076646437981134,0.6953458125589717},
{-0.7594444931399493,0.19430816864227213,0.7034007651496013},
{-0.7357514088755294,0.13874072565468254,0.7073773259980717},
{-0.7703700457336723,0.0849108528530698,0.6828038556527747},
{-0.7998017520069711,0.10983235283502378,0.6716346823133917},
{-0.8152852038422473,0.0844429463415642,0.647654151349066},
{-0.8456230761695086,0.15097590088115967,0.6554203682411356},
{-0.8969922505400906,0.1486441023155573,0.6431413670604128},
{-0.8939566587092483,0.2217483719946998,0.6450954890203096},
{-0.8997764876333469,0.28506269689454466,0.6221384229874865},
{-0.864102160877344,0.3754292365518771,0.5977879494093808},
{-0.8268165858034844,0.37229825882061784,0.6295643442348247},
{-0.7944820545607353,0.37544857153169153,0.6420714981773559},
{-0.7628603395738057,0.3616292169590977,0.653507494238176},
{-0.743378413912936,0.32124102212437305,0.67248542142522},
{-0.7201003872151959,0.2565474686644428,0.6851085852466371},
{-0.69645370690233,0.15972304574914037,0.7058189266250406},
{-0.7244211107043605,0.10459128430669931,0.7027214628587928},
{-0.7488747041748091,0.05717546880881074,0.6736145842463741},
{-0.7852657141825946,0.0439013606669796,0.6398363745108251},
{-0.8009167358429279,0.49006890986805823,0.5277850104924491},
{-0.8008664648954109,0.5256233597492125,0.4722137005088967},
{-0.7792667144455502,0.4576660616966319,0.5749597832419864},
{-0.3932786454170943,0.680686030863784,0.09739996081444088},
{-0.3470371076932596,0.6671953709480328,0.09349945088657326},
{-0.36737106146461196,0.6032197897385397,0.11196177861190311},
{-0.32229220052694274,0.5886579719410774,0.10230846768995971},
{-0.2703790687242523,0.5847729299970613,0.07543671274407188},
{-0.3205030703947946,0.5131303847918786,0.0776331664509742},
{-0.3708333118500225,0.470267312540926,0.09195265250143078},
{-0.4024614718302235,0.43972320042897883,0.07388733636162081},
{-0.4246812306327953,0.39923188570191154,0.08734319331370616},
{-0.41071106321765005,0.3381333494887832,0.10684058695842719},
{-0.4077553893033736,0.35314373881793687,0.1898340543132473},
{-0.41639554728304873,0.3417889496723367,0.26806338264182855},
{-0.44717812414603847,0.35848148224533266,0.32411162212746647},
{-0.4676139088110793,0.35310764685561674,0.38346098716672944},
{-0.4889249235623799,0.41917398388236105,0.39266443755832714},
{-0.5344020850842233,0.3975523204553776,0.43726636899391075},
{-0.5569698735234521,0.4213949285636947,0.4760523385013586},
{-0.588313164801056,0.39565620343492375,0.4955961360976339},
{-0.6267588386637726,0.38618206332592603,0.5515786366519033},
{-0.6557857993596256,0.4041043006151102,0.5845666902123754},
{-0.6689890125754709,0.4444770274659836,0.5739118273360523},
{-0.7377325998071659,0.4371761390881109,0.5990911270488634},
{-0.7188255675461077,0.4818193184806317,0.5568003702004135},
{-0.6886011271004233,0.5321276469587367,0.492412309421549},
{-0.6798153122728141,0.5533974137531004,0.45563459981747784},
{-0.7180328333737221,0.5728612934328098,0.4005054163723453},
{-0.6951659972466989,0.5870957055720835,0.1081218516207869},
{-0.635414464627299,0.5822709836090934,0.11134950425111755},
{-0.5970190617120997,0.5684670970203509,0.057429401543704774},
{-0.5630694151555307,0.5868391948398809,0.07497654022449199},
{-0.5248776740277084,0.6267504601725197,0.07275559554315823},
{-0.49849187157448616,0.6489998659441399,0.036847960030729696},
{-0.44239207214267673,0.6907518213550986,-0.015232741597017803},
{-0.4802293386405705,0.6001970878942404,-0.012946057984315498},
{-0.43235077262579347,0.5840317557708472,-0.04782893956658711},
{-0.33537295887063096,0.6709089760710292,-0.11414405333360837},
{-0.26413644824154814,0.7004102882716591,-0.15654566406632675},
{-0.18277098618709048,0.7243341032951964,-0.19024137788800152},
{-0.13916287271396094,0.7688264698451657,-0.21511002892512984},
{-0.1329292752218367,0.8142417594316034,-0.21985998896617154},
{-0.056226121299929405,0.8348270679405414,-0.2641783406978124},
{-0.020685850403972205,0.8800967006790446,-0.29308413552016255},
{0.008624689995823612,0.9388492593413735,-0.3165129750604541},
{0.017393747840927228,0.9773580941381499,-0.3005126347648094},
{-0.7198554774708817,0.397481425529392,0.6246352133808373},
{-0.7003709738127034,0.3612231823829977,0.6359435985748831},
{-0.6826498203135878,0.3129115128203808,0.6412439610413048},
{-0.6618273360522613,0.22343180423719644,0.6655261176907331},
{-0.6647172710351691,0.16421649505797928,0.6950300078886719},
{-0.6447107229220054,0.1206792765108354,0.682814167642009},
{-0.6871909625726352,0.0999044851997176,0.6985915111704624},
{-0.7147897127595401,0.06757639895023966,0.6851356542183771},
{-0.7025300465586315,0.03996733677410047,0.6564451221712925},
{-0.7523176195804052,0.017915147796585748,0.6211613620075381},
{-0.8502364023531961,0.018954080711939894,0.5891207224579658},
{-0.8206835302063947,0.044169472387070946,0.620338980866104},
{-0.8495803020381647,0.08168062222543057,0.6445089946326096},
{-0.8607533423735108,0.13371105290566093,0.6530034957643506},
{-0.8813541188663,0.08913619044181723,0.6396224007342137},
{-0.9276008125847518,0.11983111539631569,0.6192652449870842},
{-0.9210062954694276,0.2162211457651239,0.613866918622937},
{-0.18525617559255275,-0.9004770584019509,0.6805236170333439},
{-0.12466034885459583,-0.8393759441915143,0.6793248482848584},
{-0.18583493598832687,-0.8546763582178819,0.6607813136443085},
{-0.22600142305451437,-0.8923653898705329,0.6433140928800871},
{-0.22754693244100258,-0.8454419718585814,0.604608041289205},
{-0.16811249349055685,-0.8168468257119139,0.6345630810161434},
{-0.12462167889496728,-0.8035172906279485,0.6548738328117185},
{-0.07335820241403673,-0.8203103650959789,0.6879070013250906},
{-0.12086553681637961,-0.8720597940695749,0.7063383930827177},
{-0.15661462549433103,-0.913475320831765,0.7062597641648062},
{-0.16689825675821998,-0.9488725128770965,0.695744113143146},
{-0.2157796637260311,-0.9514144182233474,0.6518756219418507},
{-0.23646809212731187,-0.9224983114117629,0.6343800432072348},
{-0.26682658843304174,-0.9014102934276537,0.5900874714486798},
{-0.2668304554290046,-0.8689945552696843,0.5732260800519725},
{-0.24942639559884303,-0.8204199299815931,0.544255835296908},
{-0.20019695899437487,-0.7924783061526484,0.567239970301471},
{-0.1893139433562432,-0.8149403967022258,0.6024193215742283},
{-0.140748341058732,-0.7688986537698054,0.57776722231102},
{-0.07667479595151307,-0.7768672434505978,0.6198504503761298},
{-0.07173277511098282,-0.8002019860891264,0.665236092993519},
{-0.009443204141294912,-0.8016121506169147,0.6485190694460916},
{0.01663710563086169,-0.8361714935369607,0.6720226709083317},
{-0.06530196082475294,-0.8524154545782654,0.7054180480435578},
{-0.074005279738488,-0.8963329277284234,0.7149849960556641},
{-0.11403255495001269,-0.9189561431097866,0.7172458996952807},
{-0.13070317454588581,-0.953458770089044,0.706810166590186},
{-0.15283399244131196,-0.9676454892781092,0.6706872683024919},
{-0.21953709480327308,-0.9665446844273494,0.6243928816338317},
{-0.25906037154097217,-0.9568024325982603,0.5965028177510583},
{-0.2925240656048756,-0.935831713491691,0.571711506633187},
{-0.2884624308452222,-0.8732482508288261,0.5537325534032143},
{-0.28529278315433443,-0.8222361290854813,0.5394079113581406},
{-0.2751148497800969,-0.7676418800818772,0.5257110116577038},
{-0.2256044114689945,-0.7686666340120341,0.5126122073328556},
{-0.1964781978767615,-0.7694181202274825,0.526217588128838},
{-0.4932353350623103,-0.41330130601343645,-0.2355419465942078},
{-0.44115592243321705,-0.4440336119289091,-0.21532271370308698},
{-0.4644378161269201,-0.5137181681782323,-0.17250346740638006},
{-0.5309217887176526,-0.46578030822535815,-0.2067560286467061},
{-0.5287704499636503,-0.5235261589386899,-0.16672230844191005},
{-0.4495073447143322,-0.5581667087739559,-0.13712432134220856},
{-0.4016081547210865,-0.4847917493774136,-0.1885128306926048},
{-0.44216263038221393,-0.4779742354948981,-0.19026715786108725},
{-0.41433443843484635,-0.40044870043155667,-0.2332243270138026},
{-0.4362873745159811,-0.35890298480528376,-0.25629998092281997},
{-0.49912348091508596,-0.3638243816673455,-0.25614401208565146},
{-0.5614182078793911,-0.39167964258645305,-0.23064375170792323},
{-0.6291473531701633,-0.4420356640147667,-0.19680238103831424},
{-0.6134563725515472,-0.4774019200923954,-0.17856562807748433},
{-0.6145919803659725,-0.5151566906764149,-0.1389469654393681},
{-0.6064932018210973,-0.5746439785716864,-0.07034130106368172},
{-0.5324118711620066,-0.563125486596992,-0.11036470927924354},
{-0.47942629247895074,-0.5866780700080948,-0.10109938695224005},
{-0.40797709707191077,-0.5846749660993353,-0.14884905310158858},
{-0.3733159232581762,-0.5247210606912126,-0.18621583509066822},
{-0.3551603772125662,-0.474103372536079,-0.21129459290844502},
{-0.3535761978664495,-0.4187808392928037,-0.2261464354031215},
{-0.3617368483467304,-0.36291821561338283,-0.24479695693197703},
{-0.3645030394588269,-0.2950756384410334,-0.2627398181996299},
{-0.44850450376129813,-0.331670310236196,-0.25933041675904495},
{-0.5268923789243565,-0.3080017169462075,-0.25285062052395224},
{-0.5901164739184014,-0.30624610077907066,-0.22798583648278678},
{-0.6062843840391031,-0.3666988486664019,-0.22462928398702758},
{-0.658858772151442,-0.3869142145615599,-0.20167608495016737},
{-0.6880262337006121,-0.4445711243677461,-0.1592809192107204},
{-0.6806879643617654,-0.4876288354154958,-0.12183808630103793},
{-0.6467937447473305,-0.5480042433835698,-0.068666891811765},
{-0.6471495083759133,-0.6040267028961221,-0.003443559904923487},
{-0.5842425070508227,-0.6097949718740493,-0.03916042361651779},
{-0.5071823005016783,-0.621702741442338,-0.0550640890130911},
{-0.46179021289101785,-0.6459075581725092,-0.09634555991523548},
{-0.4144401363244978,-0.6944074215386519,-0.11264108090271159},
{-0.38475836431226773,-0.6485216474433999,-0.1373241161336228},
{-0.3635955844062099,-0.6113598162403517,-0.1534958932502875},
{-0.3165974044723098,-0.625366075617817,-0.14606352700967784},
{-0.3191212638374006,-0.5204841221145764,-0.19711174071534274},
{-0.2796160330808615,-0.4809647123728402,-0.20649693991719473},
{-0.2888143274778422,-0.36886694440290996,-0.24605373061990532},
{-0.41485132689521476,-0.2503396511454041,-0.26211723184961},
{-0.46242697822623485,-0.2827064073545106,-0.2630079299197212},
{-0.4869256866495832,-0.23962549433098382,-0.26574576306142345},
{-0.5344807140021347,-0.24782997076551036,-0.2509222785371413},
{-0.5692102047445463,-0.20598134045548042,-0.22600593454980436},
{-0.6092632599291568,-0.257551598616131,-0.22394095870563915},
{-0.6790470690748599,-0.31576019984635134,-0.2025809620054757},
{-0.7365918359981233,-0.33227871760101874,-0.17623511851053633},
{-0.7277969981799339,-0.38887993750934513,-0.15812984341244352},
{-0.7410517713419508,-0.45559206286188625,-0.10146417357140283},
{-0.7124398682127776,-0.4977448968543276,-0.07720006290313436},
{-0.7118843097927806,-0.5556402714115566,0.00979187827727905},
{-0.6797908212983826,-0.6068380089611186,0.0651981964330829},
{-0.6167007821643835,-0.6242588257737859,0.022012874518558982},
{-0.5506589361120708,-0.6330626865825552,-0.011512691480750124},
{-0.5245038644179657,-0.6525278552609192,0.005203043068023018},
{-0.5010737358790198,-0.6853496279949882,-0.02408816235195854},
{-0.480353082511382,-0.6469954730367261,-0.0788474031833111},
{-0.4929942923139589,-0.7396976782556239,-0.03175899334361098},
{-0.4499249802783207,-0.7435234262615429,-0.07634030080072599},
{-0.27479775611114265,-0.5928188595971104,-0.15915073034663754},
{-0.2395591109002883,-0.5585946563271788,-0.1798494707371526},
{-0.23797750955148006,-0.5038096355227405,-0.21306696605808748},
{-0.2747758431340198,-0.43520268214839974,-0.2212198825464427},
{-0.24425235500054146,-0.42414049569732243,-0.23062441672810896},
{-0.28345467107332345,-0.3212216871445585,-0.26341138649851253},
{0.7507089492598571,-0.22928514712630635,-0.07703636007404012},
{0.7465751305755636,-0.1632097871089822,-0.03214053694527946},
{0.7774672723241678,-0.2401797637523266,-0.015011033828480706},
{0.7807091039396956,-0.28052413263280546,-0.026922670392732134},
{0.7926542544689584,-0.22511652547834726,0.04806611531897559},
{0.7710261460487035,-0.1606356567963742,0.03232873074880507},
{0.7346725170018922,-0.1010194690356742,-0.0067369514666226985},
{0.6895717430871002,-0.08281236304389293,-0.08352517929971283},
{0.6894196412458945,-0.11803682926955018,-0.10784213891280703},
{0.719234180119516,-0.16840445168575235,-0.08117662375160484},
{0.6938421956287476,-0.2088609634491541,-0.1313715203481328},
{0.7147368638147141,-0.2577952193617909,-0.14265928156371008},
{0.7459963701797895,-0.2762150101315294,-0.1070597167296558},
{0.7512052137417569,-0.3176550278681508,-0.09893386921304059},
{0.786348473052194,-0.3215890517610298,-0.008181918958076633},
{0.8032008414583215,-0.29904704329488674,0.06920440425060194},
{0.7983374495357026,-0.21297158015767026,0.09945849166533469},
{0.7736441023155572,-0.13748781896271686,0.0837533320615213},
{0.7483887516821434,-0.0843282254613325,0.05360107554047712},
{0.6988886253602752,-0.021200805366359134,0.02348491098175292},
{0.705802814141862,-0.06787673563668793,-0.0221830223409247},
{0.6487053297516359,-0.006327049894559744,-0.070988378388133},
{0.6599802009806703,-0.06603475655971407,-0.11269264084888299},
{0.6429808867279543,-0.09563274365941558,-0.14572065336763793},
{0.6729629954266327,-0.15421773249668724,-0.1356896658399889},
{0.6643975993689062,-0.23045813590170602,-0.18268140078061765},
{0.6723378310793042,-0.292783798833714,-0.20142859720854453},
{0.7102756394722325,-0.33003328194525355,-0.16752535460352982},
{0.7593207492691378,-0.3689094813585014,-0.06685842669980255},
{0.7960997478718632,-0.3765210184120567,0.026984542328137788},
{0.79185765330061,-0.3348115999566896,0.02976233442812284},
{0.8127600554785022,-0.4225228023861942,0.10822883850909258},
{0.8084522219758804,-0.2979745964145212,0.12768627319553078},
{0.7929752151338754,-0.19786580492809955,0.1741044037350025},
{0.7692731078788756,-0.11878315949038143,0.14124267204265037},
{0.7418470835116447,-0.05936676652109569,0.11587646752496789},
{0.6900112916282115,0.013077535847052757,0.06895304951301628},
{0.6590224749805361,0.022946109544261815,-0.009775121294773396},
{-0.9317578332448223,-0.22913046728779207,0.1553520513124584},
{-0.9275595646278146,-0.16905926300212928,0.2908142088899659},
{-0.9204146450871106,-0.20195064166352997,0.3251660230266719},
{-0.8964508711052905,-0.23757340847336142,0.3647009007522596},
{-0.9044839107187972,-0.2737942706587813,0.33980775874069985},
{-0.8804556868042631,-0.32194481538961267,0.35011330298171167},
{-0.4316817823242193,-0.7869858828867382,0.2403602235639266},
{-0.4393745262929946,-0.7402081217227209,0.20544125001933497},
{-0.4603375114076381,-0.8065915524184192,0.21063075860148803},
{-0.45874173107363286,-0.8340317557708469,0.24708235154602498},
{-0.49693347220145506,-0.8664230029543849,0.2657625200439291},
{-0.5291623055545531,-0.8212010631660901,0.16170294768212262},
{-0.47491093019298897,-0.7836447983748305,0.1763885093503962},
{-0.47032338398238716,-0.7505484689273985,0.17031088069544054},
{-0.4854729851662036,-0.7063139021082862,0.1522184955838906},
{-0.4467372866062729,-0.699602086115422,0.22406212457914196},
{-0.43011178196329974,-0.7307430046043031,0.22863806980185514},
{-0.4356080722251727,-0.7763606669794636,0.2662600735244832},
{-0.4524797756111143,-0.8256416635301033,0.26944647819787676},
{-0.4855993070343235,-0.8277362863433171,0.323472278794941},
{-0.5577097587510119,-0.8859732455439316,0.31497391066723723},
{-0.5713460755146973,-0.9327574517012204,0.2731794183006873},
{-0.5880991910244446,-0.879963933817653,0.2079032374490201},
{-0.5703922165105261,-0.8476551825479893,0.17922430638982412},
{-0.5858318423915566,-0.8199700694512474,0.11178905279222888},
{-0.5273589964372077,-0.7918982567582199,0.1129001696322229},
{-0.5061472345822872,-0.7306347287173431,0.11412858534975688},
{-0.5209977880783093,-0.6851356542183769,0.08249398037628447},
{-0.5237614011930972,-0.6763305044109534,0.13158420512608984},
{-0.49290019541219604,-0.6811487813806721,0.2381186549041243},
{-0.4654445240759169,-0.6845865407916514,0.2896463761091833},
{-0.4397444689067745,-0.7262134633331442,0.2737233757327957},
{-0.4577479131111788,-0.7613812136180129,0.3347265260455068},
{-0.4515259166069432,-0.7938201537517594,0.29813572124630705},
{-0.46177861190312924,-0.769768727861448,0.39351775466746414},
{-0.5193800947671812,-0.8269757771372885,0.36539953802288233},
{-0.6137554202393414,-0.887722416717797,0.38316451747624375},
{-0.5966284951198512,-0.9092448272484003,0.34369666768067897},
{-0.5687358532397693,-0.9220355608948744,0.3087287121872245},
{-0.6122666267936417,-0.9676068193184806,0.3319719359212989},
{-0.5928233710924007,-0.9739190457285163,0.32209305023485557},
{-0.6104697626695679,-0.9571105032766345,0.2470991085285307},
{-0.6052338501358605,-0.9268267688928533,0.23299617425199404},
{-0.6503333350519983,-0.9282188874394816,0.1935592604241321},
{-0.6490842953559958,-0.8788412159897705,0.15111124573985943},
{-0.6510165043387695,-0.8504316856493201,0.1170159423353562},
{-0.6273814250137923,-0.8317308931729475,0.07785229622220273},
{-0.5377070776338111,-0.8046142284827454,0.02184530469350187},
{-0.5263574444828281,-0.7698860267389881,0.07853933250493685},
{-0.5190604231009184,-0.7183402595527689,0.04926359506880673},
{-0.5439741890909466,-0.6563368462843324,0.05280189637482016},
{-0.5728426029523226,-0.659265451226869,0.1234080866619575},
{-0.538551371752368,-0.6748107749975508,0.19221225683040385},
{-0.5716515681957629,-0.6614954188987825,0.23229882598002566},
{-0.533217495320935,-0.6466616223852661,0.3104985073395583},
{-0.49801494207240055,-0.6539444647819788,0.31582078278310277},
{-0.466330066151411,-0.6522236515785076,0.3569772208157814},
{-0.455400646561725,-0.6941264198320177,0.36291434861742},
{-0.45226580183450293,-0.7325166667525999,0.3891209802576966},
{-0.424887470417481,-0.6949217320017117,0.4525216680673786},
{-0.43308421286008186,-0.7517652836570439,0.45784781050688583},
{0.047716152184337085,-0.2497686247415557,-0.45343170111730413},
{0.09595177082635124,-0.3187596997148734,-0.47216342956137963},
{0.025478347400605287,-0.29471858581379634,-0.4748007208080475},
{-0.02541003047192822,-0.26185943211875273,-0.4577163326441488},
{-0.05542178613965531,-0.3037557553789913,-0.46876691810733756},
{-0.021928445106703345,-0.3455682937267012,-0.4837412154741711},
{0.01214881231663991,-0.37364784041165455,-0.4859956741205163},
{0.0721426766830455,-0.35369671924062507,-0.47702424348668987},
{0.15971595625654164,-0.3526500523333453,-0.4638455212452759},
{0.1722772481425529,-0.2982104831682555,-0.45087561678585614},
{0.1121776858864959,-0.27175765278501035,-0.4520511835585644},
{0.022206868816028933,-0.20997208028914802,-0.42324335263394},
{-0.08224713713398887,-0.36692571242955613,-0.47495668964521603},
{-0.04414175891600373,-0.4261139526370334,-0.484174319022011},
{0.026673249153127854,-0.4190824649779065,-0.47703842247188705},
{0.10571851362987175,-0.39719526782814035,-0.469491335351046},
{0.14768702081475027,-0.4110404023738199,-0.46397055411474153},
{0.21387452371499724,-0.40231645948161626,-0.4421246049219126},
{0.2110567726567293,-0.3506791733909429,-0.44984055086646496},
{0.2404730109461765,-0.32818099087904545,-0.42996161362007546},
{-0.26027331927465475,0.5218685066692791,-0.00715329803195689},
{-0.2358828867382663,0.5398513268952149,0.01739439234025437},
{-0.29823690764066846,0.5036833136546206,0.03975207399883472},
{-0.36146100263471326,0.4658563591459613,0.041167394521240096},
{-0.22824556971162524,0.5713067610557415,0.040381105342126},
{-0.1631782066419523,0.5845563782231414,0.0037477635873347888},
{-0.18764340110028932,0.5603154695306499,-0.041140325549500145},
{-0.3474482982639767,0.48441922876632526,-0.008520925604153694},
{-0.4314355835812508,0.42811061155252156,0.03863837916153213},
{-0.753544746299285,0.5057147755337744,0.5240842953559957},
{-0.7536568891822077,0.543655161924011,0.4621878689758648},
{-0.5765626530685903,0.38957857477996805,-0.0617591480234495},
{-0.570812430071823,0.3056080464451996,-0.07402268122032084},
{-0.51229318016592,0.23661439347457341,-0.06083106899236401},
{-0.5168265884330417,0.30722573975632783,-0.053427060722148645},
{-0.507587046079124,0.35564826320321347,-0.033322548711259184},
{-0.5080497965960125,0.4026722231101993,-0.017020582730511657},
{-0.5601060072493285,0.42843801721071034,-0.029754600436197175},
{-0.5962366395289485,0.42876671186755294,-0.07745012864206573},
{-0.6052441621250948,0.4400093581302301,-0.1277842370932565},
{-0.630270070998046,0.45712210426452327,-0.22547744510154738},
{-0.6971781241460385,0.4368835363935881,-0.17306418182099423},
{-0.7451585210545041,0.4785426839014381,-0.16357586272679936},
{-0.5692810996705321,0.7716996478455679,-0.7651128647221693},
{-0.5770666515424159,0.7823674007084338,-0.7759365864222039},
{-0.5872471629139621,0.841654893812291,-0.7734475300207787},
{-0.601035581518853,0.7953244151813106,-0.7724949600152619},
{-0.6049309354521035,0.716908182047858,-0.7556284126239373},
{-0.5922136747289237,0.693769367204781,-0.7465371051152623},
{-0.5838532294572285,0.6925821994441839,-0.733487282739277},
{-0.5707647371216146,0.7500006444993274,-0.7438779008914715},
{-0.9082838787516309,-0.23257338269338837,0.07332017695373524},
{-0.897839122655956,-0.29920816812667245,0.0309224332169797},
{-0.889108734770481,-0.23784152019345275,0.018500353185631247},
{-0.9103643225796475,-0.18926947290267013,0.07106829630469864},
{-0.8869883319841817,-0.17885951977066125,0.010533052503493167},
{-0.8683468334459059,-0.15978620668320018,-0.023123991358553055},
{-0.8547169616754922,-0.09665620859091814,-0.023344410128435848},
{-0.832874879478626,-0.16824977184723808,-0.06950731893435906},
{-0.7985436893203884,-0.19222385781829238,-0.11753669779168756},
{-0.7309086409313791,-0.20971556955694529,-0.1710430319310747},
{-0.7192328911208619,-0.15971015576259728,-0.1669543281996814},
{-0.6754417398388237,-0.22059600719776842,-0.19339942459100076},
{-0.6258256036380699,-0.13996398537759921,-0.19770468009631403},
{-0.6052686530995263,-0.09849947666654618,-0.20626749815673198},
{-0.5290810986393331,-0.07499458620565183,-0.21968984114380594},
{-0.4941879050678272,0.004679709614383282,-0.20869468262275137},
{-0.4148461709005976,0.059967439893992926,-0.18670436558064238},
{-0.4267358944877262,0.09964410747155192,-0.16654184863031007},
{-0.39885227559822434,0.13523336031637198,-0.14605321502044358},
{-0.3645520214076897,0.15508651758967582,-0.1300232277557503},
{-0.403055700209849,0.19047855364039012,-0.08926766830455433},
{-0.4381564225646949,0.21928251756905176,-0.04300163960628828},
{-0.08578286044269375,0.7488341007171991,-0.22352074514434211},
{-0.15126141408308375,0.6694008476455151,-0.1714851584694946},
{-0.033617084903763396,0.7767254535986268,-0.2515165069167668},
{0.8978520126424989,-0.7508977875627098,0.011105367905995887},
{0.8795430757570288,-0.7948964676280877,0.032513057556367894},
{0.8651630067698209,-0.7394553465086181,-0.02493374546916977},
{0.9197095628232164,-0.6974559033560369,0.010578167456393148},
{0.9013310200104152,-0.6592010012941546,-0.01808658461760568},
{0.829799328689501,-0.7374277516254273,-0.04701944841169589},
{0.7795090461925559,-0.7732799601957215,-0.0580313639152561},
{0.8087525586623288,-0.7993615589665324,-0.03079868934616836},
{0.844938617884083,-0.8364048022933864,0.04878279857075827},
{0.8995766928419329,-0.8044028327034426,0.08409749470221552},
{0.9288356732955569,-0.7571159170709826,0.06043534640549833},
{0.9567283151756392,-0.6978735389200253,0.0709832223935158},
{0.9552420997272478,-0.647184955838906,0.04345021113797954},
{0.9365838442064668,-0.6089597007460724,0.028005429262331828},
{0.8985248699400358,-0.579051064970688,0.01251811043109269},
{0.8610730140397735,-0.6256909032786969,-0.0255576208178439},
{0.8611451979644132,-0.6710159629593346,-0.04046102325869174},
{0.7898210354268391,-0.7329239903273541,-0.06252352422544076},
{0.7149366586061285,-0.7535015648443663,-0.06714071740509105},
{0.6920852904629566,-0.8094879323945985,-0.05959620828155857},
{0.7282120557466137,-0.831331303590119,-0.039251942520972034},
{0.7808805407607156,-0.8458699194118041,0.0028351525401007216},
{0.7746134293035797,-0.8802423575269787,0.04570338078567044},
{0.8184380945506293,-0.8724928976174148,0.10372765520832794},
{0.8971778663463076,-0.8199713584499018,0.15351909522606458},
{0.9478187564772184,-0.7687233499528227,0.15608935854270967},
{0.9501054400899206,-0.7550290282496944,0.1126075669377001},
{0.9801468427266963,-0.6933543096381007,0.14095651434139903},
{0.9839248977824069,-0.6399665633749078,0.09437983696745018},
{0.9004583679214639,-0.5213245492371705,0.05944023944439},
{0.845670769119717,-0.537449922402281,0.04095857673924587},
{0.8065303249823407,-0.5868056808748691,0.0034242249251091508},
{0.8112287250772111,-0.6557671088791384,-0.042469283162068404},
{0.7879919463364081,-0.7003767743066476,-0.0587016432154845},
{0.7123547943015949,-0.7117612104212963,-0.06058229225208693},
{0.644583112055231,-0.7622151957473355,-0.07419540703999508},
{0.6500188193803524,-0.7918995457568742,-0.06326727644896343},
{0.5902479517811383,-0.8437160026604933,-0.060635141196912615},
{0.6206928109967054,-0.8701211400935297,-0.04114805954142587},
{0.6722218212004186,-0.8880678683571455,-0.01708245466591735},
{0.6977053245956412,-0.9015701292607851,0.008040129106105187},
{0.7107113210173809,-0.919341553707418,0.05898522291942725},
{0.767211999030673,-0.9045670511319985,0.13424212035122632},
{0.8555921917617518,-0.8550836817926362,0.207080856307586},
{0.9140946846851491,-0.8040754270452541,0.24447470726840562},
{0.9451672862453533,-0.77375173370319,0.21973237809939727},
{0.9664679890074195,-0.7390041969796183,0.21480711424137272},
{-0.22260491160047233,0.6617300166538629,-0.15860677291452913},
{-0.28190013869625524,0.6515765742540566,-0.14018440414748212},
{-0.2882226770955252,0.6062914735317019,-0.11727632006352189},
{-0.21679410566695376,0.6027583282203054,-0.12300463008316624},
{-0.14717786634630758,0.6113520822484262,-0.12267722442497773},
{-0.09091952008002108,0.6637344095612767,-0.16785276026171833},
{-0.038903268384987845,0.7082009961381603,-0.20787359047997156},
{0.03744927790295383,0.7439939107703575,-0.26314843077303834},
{0.02764773213576761,0.8302756136922593,-0.31568157092844},
{0.0400839911523132,0.8893323760369996,-0.34344273494578476},
{0.059666458708217074,0.9164529077231645,-0.3554910053673905},
{0.04615388581534318,0.9515252721076161,-0.3356185131142724},
{0.039859705386467555,0.9636367034632817,-0.31022652862350414},
{0.020496367601792187,0.9600906681653426,-0.265210828619895},
{-0.015056793280707848,0.910385591057443,-0.2142463998267586},
{-0.049186899648876806,0.9309528535852211,-0.16520902402177895},
{-0.0783144022397641,0.8220608252684986,-0.15402051570258166},
{-0.1718699245677988,0.7728868156061647,-0.07575251741437186},
{-0.25581982892409866,0.7250404745577448,0.015475073344023397},
{-0.3093790120083115,0.6987358790197424,0.06737789315747952},
{-0.31842004856946937,0.7390106419728899,0.06134151245946097},
{-0.603456320991601,0.4880245580023615,-0.2408874240135294},
{-0.5941768196794004,0.4742851213463334,-0.14973459517708268},
{-0.7221279820983868,0.450544344131705,-0.18268268977927193},
{-0.7331630995777242,0.4860420780720707,-0.24173945212401202},
{-0.7620160454552487,0.5133301795832926,-0.19798697080160255},
{-0.7613096741927003,0.5228184986774874,-0.09717309705128671},
{-0.7749730599281255,0.5589220619853673,-0.0979155602761551},
{0.3023230333747532,0.08485026991631837,0.5181587685422456},
{0.22699137402100547,0.07966333933147386,0.5368660060118897},
{0.2651160872188049,0.02903405018845168,0.5539723071529113},
{0.32467427004006205,0.041367189312654463,0.5320322610583195},
{0.2614591980365973,0.12726734863288822,0.49490136582297406},
{0.3112132570933596,0.13958501977323942,0.48280282445385125},
{0.34733486638239947,0.15550286415500997,0.46663362533449515},
{0.41168039020567265,0.07169346065202714,0.4964481642081166},
{0.38389215721658787,0.04525352025532495,0.5128313371040841},
{0.342911023000892,-0.0014572129786695515,0.5340018510020675},
{0.47605427199934003,-0.03641614548154396,0.5388794219098836},
{0.4828344049208813,-0.07714205796369138,0.573436186832621},
{0.43353665138773595,-0.0873702622854461,0.6028588701153397},
{0.4784763004707423,-0.12546275051688843,0.6089584117474182},
{0.48260238516310994,-0.1746664071482709,0.624561740457543},
{0.492945310365096,-0.24230661153189742,0.6383849620260997},
{0.4468997004367128,-0.2481883123914017,0.6470148080165404},
{0.43274133921804186,-0.2772410530603406,0.6703469726577607},
{0.386570696420193,-0.33438880839808394,0.7031236304389299},
{0.35753084573779703,-0.31097930383760664,0.7246099490072133},
{0.32206533676378846,-0.37892500090229897,0.7328827423704171},
{0.25185744706082525,-0.40019863469262534,0.7502159072745929},
{0.2152202383100712,-0.4288633867666241,0.7691835224724026},
{0.17469669861664663,-0.4439601390056148,0.7759365864222039},
{0.08838405972704161,-0.43580851151591393,0.7588444642663793},
{0.028912239815621608,-0.43272780473217176,0.7473040593145621},
{0.020047796070100866,-0.35076553630078006,0.7529924103759236},
{-0.0024787444121908623,-0.35572689212112457,0.7605884794456276},
{-0.030091673584292815,-0.34388099448824166,0.7566376985702427},
{-0.07235020546638553,-0.3463468489138896,0.7356695574609821},
{-0.09264677827676351,-0.31138791641101515,0.7115098556837106},
{-0.11134885975179047,-0.251034421420064,0.6488116721406143},
{-0.12581400265018128,-0.217369643566092,0.5988384833126235},
{-0.09769449700694517,-0.18415343724381136,0.5918662895915937},
{-0.0716825041634657,-0.15397540074968147,0.5961380311318956},
{-0.026678405147745055,-0.1441068270524724,0.5925726608541422},
{0.09547870832022849,-0.03512327983129573,0.579235391778251},
{0.1159596079381693,-0.06427914039257737,0.5840162877869955},
{0.16631562936648292,-0.05789215206059314,0.5868739978035463},
{-0.43263821932569907,0.34808957509448374,0.0442751702767222},
{-0.43488881097608145,0.29922363611052405,0.0050921891837544695},
{-0.4691684411881475,0.3425636378635623,-0.002265415134906629},
{-0.46716533727938797,0.39665775538930353,0.012995039933178285},
{-0.4845010801808724,0.30802234092467623,-0.03235064372592798},
{-0.41481523493289474,0.2533339950193093,0.002054019355603772},
{-0.3930053777023858,0.2629628149668213,0.040901860798457305},
{-0.4794069574991365,0.4490039907398339,0.004807320481157396},
{-0.5180666051384644,0.42492678487643665,-0.009771254298810535},
{-0.5499615878401024,0.4806231277294548,-0.005236557033034489},
{-0.582568097798906,0.48288274237041723,-0.03665203223527837},
{-0.5870718590969792,0.4808229225208689,-0.07963111436511662},
{-0.6916264069420313,-0.11813994916189298,0.5320515960381338},
{-0.7300798147966735,-0.19000291313695858,0.5374215644318867},
{-0.6775969455887888,-0.19219163285193516,0.5621484256170437},
{-0.6500562003413268,-0.14151980675332163,0.5552509938179625},
{-0.6635971312045952,-0.2291343342837549,0.5654959551222228},
{-0.7133859932250232,-0.23970927924351235,0.5539735961515657},
{-0.7514411004954911,-0.2588238402879106,0.5293047399058516},
{-0.800564839210308,-0.19750101830893674,0.4758693006924501},
{-0.7387599317346314,-0.1380575563679111,0.5132786196371211},
{-0.7133460342667404,-0.06169340909208077,0.5027797255979665},
{-0.6559739931631512,-0.036240841664561256,0.5091628469339878},
{-0.6210872445849167,-0.08297864387029566,0.5430557775497682},
{-0.6087579724566768,-0.15873180578399473,0.5677723267456909},
{-0.6289217784056634,-0.24633473232653938,0.5874527581993204},
{-0.6587028033142734,-0.2879075169245522,0.5801686268039536},
{-0.6849274809357099,-0.3103412495037355,0.5627503879885949},
{-0.7787511149838361,-0.31655422301739106,0.5014597909759783},
{-0.8155365585798329,-0.25221643318604364,0.46501077602874985},
{-0.8586961005212713,-0.20656912384183457,0.41738743174752124},
{-0.8195260094148463,-0.1592216252726231,0.4528000917767042},
{-0.7595888609892292,-0.08523825851125799,0.4840608871404339},
{-0.7608095427148375,-0.028408885841123027,0.49769591490546483},
{-0.7346634940113124,-0.015424802396506145,0.5246166518002155},
{-0.6777761164017346,-0.019272463379548098,0.5025812198052065},
{-0.6055921917617518,0.0028325745427922734,0.503509298836292},
{-0.5652465338826187,-0.07065066074071003,0.5463891280697504},
{-0.5447037623292722,-0.12555298042268828,0.569832146595239},
{-0.558346524086229,-0.1881944480249961,0.5886347699653002},
{-0.5905457104702784,-0.24524552846366823,0.6003246987610145},
{-0.6211852084826425,-0.33001007996947646,0.5878136778225204},
{-0.6920672444817968,-0.36523583519378794,0.5425672470597941},
{-0.7842796302120661,-0.3601210885335835,0.48053805381827186},
{-0.8279625056071444,-0.32811138495171405,0.44584723303548873},
{-0.8637760442178101,-0.30697825201470474,0.3957941262909322},
{-0.8901244657100579,-0.16921394284064353,0.37248516362548917},
{-0.8636033183981356,-0.0934014869888475,0.38051949223765014},
{-0.8366013745881651,-0.10931675337330939,0.4179184991930869},
{-0.8033800122712673,-0.05096894028842621,0.43223927424219766},
{-0.7786583070807274,-0.03859455320728639,0.4668824020747722},
{-0.8138698833198419,-0.01271146022923548,0.458909945398017},
{-0.8261669304817247,-0.006196861030477039,0.507768150390051},
{-0.7946547803804094,-0.0034113349385661764,0.5671613413835597},
{-0.711980984691852,0.011939350035318645,0.6038140181181652},
{-0.6712550722097047,0.0008861865748212973,0.5218749516625505},
{-0.6046963376970235,0.033379264652047796,0.5090133230900907},
{-0.5464722684829518,0.03937826438909214,0.4861709779374991},
{-0.5308212468226184,-0.009299480791341928,0.5088947352138965},
{-0.4963688907908781,-0.08377266704133556,0.5542558868568541},
{-0.492312412025842,-0.13550147203646304,0.5727981324987498},
{-0.5133166450974226,-0.17827947037623287,0.5819848259078418},
{-0.5004266585545686,-0.23157569773497141,0.5998645262414346},
{-0.543912317155541,-0.23359684762489094,0.6034775894693966},
{-0.5503740674094737,-0.27465403276118966,0.6005644525107116},
{-0.5882010219181332,-0.3366574460296262,0.5888835467055773},
{-0.6076210756435971,-0.4064360991807124,0.5615619312293438},
{-0.7042173457970912,-0.4199486720735863,0.5097093823634048},
{-0.768756219418507,-0.42075429623251465,0.45412131539734674},
{-0.8303806670825837,-0.37573988522755974,0.421993023939283},
{-0.8602648118835364,-0.37359628046548315,0.367317568020459},
{0.2431889311107559,-0.7740211344219357,0.6931261568762922},
{0.26333340207992817,-0.7341408050569995,0.7077240666360745},
{0.2343167533733095,-0.7456889440007425,0.7041960773192953},
{0.2134349751738859,-0.7169017370545864,0.7234305152385421},
{0.2835668139562462,-0.6849087904552227,0.7077343786253087},
{0.31730119773754956,-0.7102685499796337,0.6990555506860051},
{0.3206152132777173,-0.7550805881958659,0.6864671898282538},
{0.2937254123506695,-0.8180481724577079,0.6516642261625479},
{0.20839499043562998,-0.8115529082387637,0.6524801623107105},
{0.1819614950321992,-0.7592917467994164,0.7046833188106152},
{0.1610178448973699,-0.7177847011327719,0.7139821551026302},
{0.19724644107471548,-0.6989911007532907,0.7232964593784964},
{0.21088791383301794,-0.667824402291324,0.7213964753620797},
{0.2584738771532722,-0.6486801942778772,0.7340402631619652},
{0.29983010997736514,-0.6426373685865872,0.7252196453706903},
{0.3506965748727758,-0.6572675033127264,0.6956293922629146},
{0.3679601338496203,-0.6892875188838302,0.6882782329375249},
{0.39773471376495884,-0.7428376789774631,0.6454808996179409},
{0.3338712754383884,-0.7950343904840962,0.65526826639993},
{0.35357877586375797,-0.8177555697631851,0.6181296371726588},
{0.33544900979123377,-0.8510980979535857,0.5998954622091375},
{0.22142161083583828,-0.8406481858632939,0.6187470675280615},
{0.1263167121253525,-0.8215619827892899,0.6311936385338414},
{0.11597378692336642,-0.7731884412912672,0.6763498393907676},
{0.08190684148925745,-0.7278595146146666,0.6888518373386818},
{0.15694976514444517,-0.6753495764350422,0.7150455789924156},
{-0.6432296634682314,0.2829745190746022,0.6053543715100361},
{-0.6128853461476987,0.20788776946516882,0.6204266327745954},
{-0.6380362878901156,0.17038306462008068,0.6715444524075918},
{-0.611039500074762,0.1583657301661779,0.6379338124970998},
{-0.59538590041712,0.12685873605947973,0.6021911688124197},
{-0.6264211210163497,0.09495473036726157,0.6473074107110632},
{-0.6611170977937499,0.08143313448380768,0.6784444622039815},
{-0.6535674326756004,0.05269233148920598,0.6382908651243369},
{-0.6739697033756299,0.024454237969775743,0.6032816616739453},
{-0.7441324781256929,-0.5603567174875869,0.079628536367808},
{-0.7516692532572997,-0.5619512088229379,0.15115249369679656},
{-0.7624427040098173,-0.5411519265373886,0.25264695873657506},
{-0.7217013235438182,-0.5897561987945283,0.2151113179237841},
{-0.7218456913930984,-0.5899791955617198,0.1749345188683623},
{-0.7000822381141434,-0.611004052611769,0.1325329081356439},
{-0.7489172411304004,-0.5121662137984727,-0.010352592691893262},
{-0.8025357181527102,-0.46956480827434005,0.00821156592712514},
{-0.8220601807691713,-0.4323965320780204,-0.01940780823824822},
{-0.8449798658410201,-0.37737562451984796,-0.011880056097221457},
{-0.8504233071580676,-0.34444686489747295,-0.037206301656621095},
{-0.8786343317057577,-0.2602546287941675,-0.019651428983908172},
{0.2509087440512712,-0.611667886918726,0.7477152498852793},
{0.3062054973214608,-0.5858866248343636,0.7357791223465964},
{0.3453485194561457,-0.6112141593924175,0.7152840437434583},
{0.38309555604823947,-0.5922865031528907,0.6950725448442633},
{0.40374531448989165,-0.6286452881943191,0.6700621039551635},
{0.4086847573331133,-0.6935141454712321,0.6574544081175979},
{0.46411041046873147,-0.7087746005393171,0.6342434093498807},
{0.46690238155391367,-0.7583391767938994,0.5965634006878097},
{0.4323855755894591,-0.7954919850063676,0.5821227487638503},
{0.8131222641003563,-0.40540232225997547,0.20970139057174825},
{0.8202581606504803,-0.4614466947496506,0.14980420110441403},
{0.8046032719941839,-0.45718913219454593,0.05271553346498304},
{0.841890136066698,-0.4943922113545313,0.09645254680354112},
{0.8281519884093241,-0.4699888888316,0.17932871528082123},
{0.8140348751475903,-0.4649862850543183,0.25569286255665147},
{0.8035978530438413,-0.345639188652687,0.27305051843525874},
{0.80432227028755,-0.2835958164259676,0.18827565494021625},
{0.20648727242728757,0.23300261924526558,-0.022773383724587416},
{0.26250328694656844,0.2255212710557932,-0.03847596533109224},
{0.2944330726118722,0.19065127946006433,0.4400016241383044},
{0.3572627340177057,0.20860316371829718,0.40396251076313877},
{0.3946217820148596,0.1684585896292326,0.43806425916091346},
{0.43020072287044536,0.11276869176948594,0.4708009579837999},
{0.46996890935245866,0.0284772027698004,0.5030645943005636},
{0.5357980706268143,0.008483544643179559,0.4925347642937061},
{0.5240630268782,-0.05138915384972331,0.5266893616363064},
{0.5531325245296443,-0.11940058984578415,0.5570478579420364},
{0.5312298593960268,-0.15643352118340373,0.5951261671882815},
{-0.35500311937674345,0.5282980319568548,-0.054186280929522754},
{-0.42660183862768053,0.47120183656528275,-0.004887238397723135},
{-0.42892590320135715,0.5133250235886757,-0.02783914843592906},
{-0.4992240228101203,0.5014507679853986,-0.006160769068157119},
{0.37535898612521845,0.24342417336516312,0.03629626860669555},
{0.39286745484637714,0.2516080258212212,0.10846988125744395},
{0.42022129528896773,0.24311996968275174,0.18972964542225015},
{0.3870489149209328,0.25042343605793294,0.2729048615873245},
{0.39581539476872785,0.22886751156231802,0.34277761164017345},
{-0.01751878071039298,-0.9130061253216052,0.5270090333025692},
{-0.051732671991090474,-0.9248829589221909,0.37832948352401924},
{0.02411329782571704,-0.9217558481868945,0.3977920742050745},
{0.07103671583766863,-0.9103391871058887,0.5198061088224224},
{0.15261099567412048,-0.9124570118948796,0.49219704664628333},
{0.18247838349256762,-0.9206795343105661,0.34304830135757336},
{-0.013787129606236724,-0.9274222862711331,0.2800407581374485},
{-0.11597378692336649,-0.9317907027105063,0.2766674486591836},
{-0.08403240027017417,-0.9149757152653533,0.5150265018123321},
{0.2801161645587242,-0.8787148941216505,0.6084801932466783},
{0.13255288761478531,-0.8393540312143913,0.6314166353010328},
{0.044179139876977934,-0.8025376516506917,0.6363277201738602},
{0.059388034998891434,-0.7821985418847223,0.6569607216330066},
{0.03153019608247525,-0.7182912776039061,0.6727612671372373},
{0.06204208322806509,-0.6787834688500585,0.6990839086563994},
{0.10660018870940295,-0.644416186729501,0.7320371592532057},
{0.1610294458852585,-0.6281864046733935,0.7369301981448733},
{0.20554372541235064,-0.6388206435712481,0.7386871033106642},
{0.1424459522864258,-0.5757190034493603,0.743180552619503},
{0.21983227549510434,-0.5724681488432526,0.748283698291819},
{0.2847887846805088,-0.5432736183223423,0.7366981783871018},
{0.3610871930249705,-0.5616018901876266,0.7149360141068013},
{0.43012724994715107,-0.5656519239593913,0.6766231071054762},
{0.4759988450572058,-0.5968276454119381,0.6367904706907487},
{0.44567901871110444,-0.6691082449509922,0.6489715079737457},
{0.46839504199557613,-0.6464218686355692,0.645251457857478},
{0.5154035339187106,-0.6638169054751506,0.6103840442590578},
{0.4986723313860861,-0.7247452938659131,0.6004768006022202},
{0.5217711872708806,-0.7563657198541884,0.5482826670928956},
{0.4954072977947811,-0.7995110828104295,0.5436564509226652},
{0.4105344704020129,-0.8300783968981537,0.5836089642122414},
{0.4066159144929853,-0.8692497770032328,0.592843350571542},
{0.3871571908078928,-0.9242113906233081,0.5927299186899648},
{0.2793234303863386,-0.9305365070198867,0.6103389293061579},
{0.1942069822479105,-0.9110146224007342,0.628324327529402},
{0.1708812625999618,-0.869987084233484,0.6319154777802413},
{0.023455908512031488,-0.871125270045218,0.6817094957952865},
{-0.015483451835276314,-0.7764302729067951,0.6242652707670573},
{-0.001423054514331115,-0.7516080258212209,0.6437459074292726},
{0.0071101165770382675,-0.7200456047723887,0.6675614465658498},
{0.01398434640034232,-0.6358636806583173,0.694095483864315},
{0.053895611732981304,-0.6253957225868656,0.7206320991600884},
{0.06977349715646895,-0.5853413784036009,0.7269984635136041},
{-0.611613104475919,0.648330875642566,-0.7161566958324096},
{-0.5819197314758005,0.7043004862102927,-0.7110806191318337},
{-0.6278544875199151,0.624136370901629,-0.6975809362255028},
{-0.6567409473624511,0.6083461373866326,-0.6767223600018563},
{-0.6648887078561893,0.6399820313587593,-0.6796445199511213},
{-0.6829076200444448,0.6346094849676978,-0.6178937504189247},
{-0.6993642658637066,0.575097706097995,-0.5709780663988988},
{-0.7031564999046143,0.6073497414268701,-0.5246334087827212},
{-0.7275327534558054,0.5434463441420168,-0.4411114519796442},
{-0.7447408854905156,0.5347726721973303,-0.35016615192653744},
{-0.7482882097871091,0.5127398181996299,-0.33862832497202877},
{0.46560307091039393,0.222101557625974,0.16471533753718762},
{0.4648593186868713,0.21579062021459264,0.0907126357960082},
{0.46163037705788634,0.22182313391664837,0.24837521719627326},
{0.4354546813853126,0.2190917457682176,0.31469290896060303},
{0.4335147384106131,0.18972062243167026,0.38551178402569747},
{0.4270465431634089,0.1593969290896061,0.4235346663298083},
{0.4623483493083233,0.14560851048471515,0.43117971734837507},
{0.47633656270462854,0.10755727021021003,0.46086277835925943},
{0.5190810470793868,0.08262030224440461,0.4514015282368046},
{0.5911850538028038,0.017311896426380292,0.45486248962356085},
{0.5935941922876633,-0.04683769960144147,0.49075465715213795},
{0.5869481152261676,-0.08446099232272386,0.5093793987079078},
{0.6054362229245832,-0.12459654342120863,0.5270322352783464},
{0.5879831811455588,-0.17324464163259398,0.563807366885109},
{0.5881430169786902,-0.23227304600693982,0.5852356805139496},
{0.5230872548969059,-0.19244814358413806,0.6165222558507649},
{0.5500634187337908,-0.27933438687490003,0.6204923717059639},
{0.527324193473542,-0.33076156618492486,0.6415932796766161},
{0.48628763231571187,-0.30731725866078186,0.656298176324704},
{0.4491657600709465,-0.34196940948393645,0.6801794543926497},
{0.40248854080196345,-0.3875690258779369,0.7120151431561906},
{0.3469301208049539,-0.4341972631980572,0.731365590954323},
{0.774239619693837,-0.44267371834863795,-0.030963681173916877},
{0.7414616729140135,-0.40832190421193193,-0.08675927692331492},
{0.7357926568324662,-0.483578801643731,-0.10061730145553732},
{0.7550090487705532,-0.5231394593424044,-0.06029097855621842},
{0.7752424606468711,-0.49596607871141374,-0.009644932430690565},
{0.7889883422961707,-0.5206800499100278,0.03132202279980817},
{0.8094679529154573,-0.5199633666582452,0.057960468989270354},
{0.7986932131642855,-0.5042891430221346,0.30952660235422713},
{0.7949692960520549,-0.44646079639492847,0.3175776879488938},
{0.7895245657363533,-0.3648646035813538,0.3355927331411866},
{0.7879313633996565,-0.24922595630810154,0.30394266018386273},
{0.7919143692413985,-0.2237527649021133,0.2489617115839731},
{0.31576728933894993,-0.48694953312468736,0.7417471861159377},
{0.28833610897710227,-0.4351124522425998,0.745163032549794},
{0.2706162444766408,-0.47999538538481756,0.7447956679333227},
{0.21510809542714837,-0.5267460775770949,0.748419043150519},
{0.21684437661447079,-0.4725075922020737,0.7628158691202327},
{0.36875544601931437,-0.5056993075499229,0.7182654976308205},
{-0.19053075808588862,0.7252621823262819,-0.05477922031049403},
{-0.1746670516475981,0.7002955673914277,-0.04958584473237813},
{-0.10490257748170916,0.775440321940304,-0.12693349798142814},
{0.012701792739328348,0.836514367179001,-0.2213449154159083},
{-0.03752146182759389,0.7494038381223933,-0.14873304322270292},
{-0.04028765293969037,0.7056552237959466,-0.10966478300996658},
{-0.1606607922701329,0.6606279228044488,-0.008013060134365256},
{-0.26136123413887163,0.640770898535182,0.039855193891177546},
{-0.27178021026146054,0.6682716848243613,0.022288720230576046},
{-0.23720668835621742,0.7061463322832292,-0.015451871368246326},
{-0.3196794002547062,0.6396920066615451,0.0647045099484916},
{-0.39913585530216716,0.294752099778808,0.313951734734389},
{-0.3861169688938846,0.29247315015803144,0.123789630263626},
{-0.3822989548798912,0.220245399563803,-0.04385237871811663},
{0.7809553026826639,-0.7907910069141887,0.423122186760437},
{0.8318759055215545,-0.7399103630335809,0.4160829651093845},
{0.7748995870048313,-0.7477152498852792,0.4379289143022135},
{0.7127917648453975,-0.8003463539384064,0.42820084145832155},
{0.7062887666345277,-0.7780363652300346,0.4303225332432753},
{0.7421577321873277,-0.7166246023439151,0.43177523472665497},
{0.8048211127667583,-0.679951301630841,0.4314852100294408},
{0.8180243259826037,-0.7145402915199356,0.4312867042366808},
{0.836245610959582,-0.7886486911507664,0.38215909852590113},
{0.7983786974926398,-0.8446492376861958,0.34801352417388076},
{0.7617646907176628,-0.8342044815905212,0.3934429927455156},
{0.7270674249416083,-0.8406004929130854,0.40570781494104124},
{0.665629882082403,-0.8636232978772771,0.3923267199109044},
{0.6346359094401105,-0.8355166822205837,0.40988932657554306},
{0.674355113973261,-0.7695766670619596,0.42436478146316814},
{0.7152279723019969,-0.6922225688196381,0.4211306838395661},
{0.7619760864969657,-0.6580834394608891,0.4167416434217242},
{-0.6424627092689316,0.6477959412010375,-0.7135954555063446},
{-0.6558889192519685,0.7113126388896052,-0.6958549670274145},
{-0.700644241527412,0.6857247266033856,-0.5655900520239858},
{0.6467524967903935,0.027403466890780694,0.37729441760462806},
{0.7006197505529805,-0.04253760009074535,0.35815794358310693},
{0.6551309880432485,0.043643560936122545,0.33613926857060356},
{0.6071338341522771,0.06939259805412779,0.3888554465349139},
{0.5861914730161021,0.12172078742349805,0.3355025032353866},
{0.6089925702117568,0.11229047326874604,0.28749890435114384},
{0.6492570211756699,0.06553462508185154,0.3000872652088951},
{0.6957679596182502,0.006329627891868533,0.2615835864067358},
{0.7220918901360667,-0.044605153932219206,0.28270898535181926},
{0.7491608618760603,-0.13735891909728834,0.33202091787016175},
{0.7230302811563865,-0.1146338728222366,0.3742317568020459},
{0.6903773672460287,-0.1412426720426503,0.4423836936514239},
{0.6425065352231772,-0.03210186698565072,0.4305055710521839},
{0.5591676162290087,0.0885716090312403,0.4169942871579642},
{0.5536107430303843,0.12882574800591914,0.37110593506540374},
{0.5579933384549547,0.15661140299769538,0.2820374170529366},
{0.5936354402446005,0.13436586422203786,0.1776439940396702},
{0.6504854368932038,0.07204406828599284,0.2405729083418837},
{0.6819163800792993,0.03232873074880518,0.1543453433634615},
{0.72067012462039,-0.024004377439429795,0.18851025269529617},
{0.7503892775935943,-0.09423675811682442,0.2328079804484684},
{0.7778926418800819,-0.1645219877390447,0.2422924325467004},
{0.7762788155649165,-0.23579201233313898,0.33540711733496953},
{0.7427932085238902,-0.19312744587494637,0.3885061278996025},
{0.7165079479657023,-0.1959103939695486,0.43829112292406763},
{0.6709560245219104,-0.2489849135597501,0.5241861262496842},
{0.6564522116638909,-0.1688452892255179,0.5036459326936463},
{0.590472237546984,-0.9383233478904247,0.015565303249823376},
{0.5026295572547422,-0.9458369210462544,-0.007858380295850996},
{0.5447024733306178,-0.9109231034962799,-0.03277730228049645},
{0.5384985228075422,-0.8701817230302812,-0.07134285301806148},
{0.49525906294953825,-0.9344692419141114,-0.04150511216866293},
{0.47970987218289346,-0.9614041577940593,-0.029626989569422918},
{0.47395191519420055,-0.9707313520564685,-0.005365456898463033},
{0.5227405142589031,-0.9729651867243451,0.07051789387931877},
{0.5914879684865609,-0.9584085249215,0.06503449360398865},
{-0.5551240274505154,-0.3817040820009383,0.5769474191668944},
{-0.5429429901675183,-0.4203095916967862,0.5728780504153154},
{-0.4954588577409526,-0.36289888063356857,0.5989596491861263},
{-0.4795023433995536,-0.3813444513763927,0.5940189173442503},
{-0.49382182945001013,-0.4571453062403002,0.5597083511644814},
{-0.5439458311205524,-0.46921420064037445,0.550136247157758},
{-0.6283172380368036,-0.4604644777750851,0.5239824644623071},
{-0.7025648495222973,-0.46731292762530346,0.482756420502297},
{-0.7419734053797649,-0.4861580879509561,0.4242384595950482},
{-0.801780364941299,-0.4358574934647767,0.3961137979571949},
{-0.8345222197588026,-0.41508785814827603,0.3636207198799684},
{-0.5292770264347845,-0.3378291458063717,0.5886631279356945},
{-0.4745564555630605,-0.31975093968001894,0.6034414975070767},
{-0.4282852708701773,-0.3717684803737064,0.5896711248833457},
{-0.46817075622973053,-0.415580255634213,0.5776924603890714},
{-0.43754930419852645,-0.43831819189580756,0.5751492660441663},
{-0.42143939901726746,-0.473277124398682,0.5562783257454279},
{-0.42956782453119124,-0.5055433387127543,0.5280157412515661},
{-0.49080041660436513,-0.5139321419548437,0.5196011580363911},
{-0.5641740870022532,-0.5026894956921664,0.5173531443833173},
{-0.6352159588345391,-0.514958184883655,0.4773825851125812},
{-0.6968159155241843,-0.4981058164775275,0.4560135654218377},
{-0.6812963717265881,-0.5339631810424389,0.420344394660452},
{-0.7386825918153742,-0.522907439584633,0.37054393165213534},
{-0.7764760323590223,-0.4922163816260975,0.3594675662158609},
{-0.6350806139758391,0.7144307266343215,-0.7368154772646418},
{-0.6669678626855514,0.8375545890930093,-0.7180450788609378},
{-0.717387045047925,0.8501442389494146,-0.6709644030131634},
{-0.6873043944542123,0.7562986919241658,-0.6405208327962506},
{-0.7402165002139739,0.6988583338918996,-0.47381076984155635},
{-0.7314758003392646,0.6581014854420495,-0.4357608185657055},
{-0.7230676621173608,0.6212541699106469,-0.4205635244316806},
{-0.7293902005166307,0.5733627139093268,-0.36686899648876775},
{-0.7605594769759061,0.5309611031766085,-0.23716221790264458},
{-0.5172777379620417,-0.2842428937504189,0.5951970621142672},
{-0.46577708572872256,-0.24799625159191324,0.5935987037829532},
{-0.43273489422477046,-0.27466434475042395,0.6015788944516341},
{-0.4150575666799005,-0.3084734904536759,0.6036928522446623},
{-0.37226538935493353,-0.32437586685159486,0.5883215432923088},
{-0.3683390994539802,-0.3579478368024583,0.5770118690996087},
{-0.3944464781978768,-0.4460276928470886,0.5686075978736679},
{0.7403582900659453,-0.6261716997767454,0.403760137974416},
{0.7711292659410464,-0.5975430396650665,0.3805310932255387},
{-0.5601266312277972,-0.8430483013575734,-0.0341500858473104},
{-0.5986264430339936,-0.8327350231246358,0.0253488030358496},
{-0.6511286472216924,-0.8522723757276397,0.03939759936890624},
{-0.6810604849728539,-0.8800219387570959,0.06012985372443269},
{-0.7075674532995789,-0.9112182841881112,0.09663300661514107},
{-0.7083228065109901,-0.9456564612346544,0.1312065285203842},
{-0.6755409927352037,-0.9628581482760933,0.17432868950084815},
{-0.6188546989156944,-0.974771073838999,0.2190092498543431},
{-0.5797477687433295,-0.9813810589381745,0.23695468911930456},
{-0.5269387828759108,-0.9864738926212561,0.20008546061077911},
{-0.39847717698982726,-0.6214062717518523,0.4922434505978376},
{-0.3569056813904687,-0.6325793120871981,0.5288445673862716},
{-0.38346034266740237,-0.5478353845598585,0.5300111111683999},
{-0.4439633615022507,-0.5918276196319651,0.46069134153823943},
{-0.4431035993998423,-0.5425530680745969,0.501169766278764},
{-0.36335067466189575,-0.4972396093818477,0.5595730063057814},
{-0.32455052616925073,-0.5223402801767474,0.5582285807093618},
{-0.32325894951765677,-0.6959116829682029,0.5320851100031452},
{-0.3515215340115186,-0.7617305322533243,0.521529500023202},
{-0.3852211148291562,-0.7164544545215494,0.5036072627340178},
{-0.44479605463291905,-0.6397474336036792,0.42430162052910814},
{-0.4886129858880428,-0.6018521621663426,0.4273397903572589},
{-0.5339689815363834,-0.5613028424998324,0.4709040778761427},
{-0.48188699090998155,-0.5520813461270746,0.49520556950538547},
{-0.4923472149895077,-0.03107711305549384,0.5272887460105492},
{-0.437596997148735,-0.011164661844092878,0.5127617311767527},
{-0.447216794105667,-0.06684166971729674,0.5391810475949863},
{-0.4536695213690198,-0.1346378429380919,0.5697225817096248},
{-0.45244110565148576,-0.18942286374253023,0.5854625442771038},
{-0.48209194169601294,0.05625641276830515,0.46824487365235196},
{-0.425325729959938,0.04212512052137432,0.47177544096643964},
{-0.37594805851022695,-0.014198964676280823,0.5186460100335656},
{-0.39567231591810226,-0.04893490041196388,0.536840226038804},
{-0.4174615491701427,-0.0726073606979153,0.5385906862113237},
{-0.3968775296598592,-0.12040729779478095,0.5649868006537802},
{-0.41012327983129593,-0.1765960381337361,0.5886257469747201},
{-0.41258526726098105,-0.24579979788501086,0.5921524472928451},
{-0.3561928651346489,-0.29000471773507464,0.5795318614687366},
{-0.32554434413170474,-0.3021599750449859,0.5673766041588253},
{-0.3247670779431707,-0.3747035303095143,0.5663660292138655},
{-0.36420399177103263,-0.40418679652898437,0.5648849697600916},
{-0.33435851692970836,-0.42740166229266446,0.5708504555321244},
{-0.2928192462967069,-0.41280375253288226,0.5723263589912813},
{-0.2559641967733786,-0.45199575661643004,0.5605745582601612},
{-0.2776515991317306,-0.5324756765953936,0.5585070044186874},
{-0.2885397707644794,-0.6068405869584272,0.5525312066574203},
{-0.28588830053261427,-0.6722998056190029,0.5366571882298955},
{-0.3465550221965569,-0.8120491727206637,0.5383960474145265},
{0.6967089286358784,-0.9363679369318738,0.2100816451747624},
{0.6755242357526978,-0.9490426606994623,0.1456278454645293},
{0.7950195669995721,-0.8884030080072596,0.22545166512846157},
{0.848375088296408,-0.8453169389891156,0.28540685953523864},
{0.8953887362141595,-0.8053579807062681,0.29239065424415694},
{0.9451067033086017,-0.760161820891059,0.2761402482095809},
{0.769746170384998,-0.5600086878509298,0.3670675022815277},
{0.7599549366070462,-0.5212111173555934,0.384127399470995},
{-0.44057458404013433,0.31855217093153365,0.3746764613377744},
{-0.39772955777034175,0.26582052498337205,0.348105043078335},
{-0.4694004609459188,0.2844401105445248,0.4441973147580034},
{-0.5056986630505959,0.35006432103284907,0.4312067863201151},
{-0.5349060835580488,0.36996903825232424,0.4436701143084007},
{-0.5924534284786207,0.3561135917174103,0.4918928429638719},
{0.1520812172272092,-0.5220180305131761,0.7524497419424695},
{-0.5862069409999537,0.5351026558528275,-0.17002472299418922},
{-0.5812739431500035,0.5683124171818368,-0.22604331551077864},
{-0.5773502312463586,0.6014822195525631,-0.3153322522931286},
{-0.5860084352071937,0.5419768856761316,-0.2719355345993019},
{-0.7808998757405299,0.5583046316299647,0.4173423167946213},
{0.1779759111931487,-0.4893883185785954,0.7688806077886454},
{0.1344090456769563,-0.48941538755033537,0.7663773724020233},
{-0.3687915379816344,-0.2468541987842163,0.576634192493903},
{-0.3572292200526943,-0.19712076370592263,0.5730211292659411},
{-0.3504787341002017,-0.13827797513779377,0.5654276381935458},
{-0.3178670681467809,-0.14962889728743117,0.5576317743324276},
{-0.353732166703618,-0.07522273896746046,0.5519782262347319},
{-0.329000149523844,-0.03583609608711559,0.527698647582612},
{-0.2956627773280605,-0.10311280285023365,0.5421096525375227},
{-0.25132895761256835,-0.1863550469453309,0.5808556630866877},
{-0.29169395047151575,-0.2649581848836549,0.5756687325018432},
{-0.2907607154458131,-0.34186242259563077,0.5798515331349995},
{-0.3744631320604902,0.1363354541657859,0.37570894925985693},
{-0.41530505442152327,0.09744765376464953,0.4261900035576363},
{-0.3366039525854736,0.10578747505787621,0.41412110915756206},
{-0.3034470402012901,0.08433338145594994,0.4375177237314965},
{-0.3182576347390294,0.027000010311989352,0.4815151147982202},
{0.08451190776956828,0.8869000355763631,-0.3616498409375661},
{0.07352577223909376,0.9264065553315564,-0.34235997607618507},
{0.07358764417449945,0.89930664762386,-0.3159870636095056},
{-0.3150828310535244,-0.8643258021438625,0.5621561596089694},
{-0.36618131570670653,-0.9192345668191122,0.5927595656590136},
{-0.4225157128935958,-0.9545866439115438,0.6114706701246204},
{-0.5043516594568676,-0.9568965295000231,0.6168934874631992},
{-0.4847008749722866,-0.9686264172540203,0.5975391726691038},
{-0.47209446813337536,-0.974392108234639,0.5705707428241446},
{-0.529631501064713,-0.97620315134391,0.4865718565189818},
{-0.582861989492083,-0.9771866573171297,0.43008149049492395},
{-0.6234950940711219,-0.9392088899659189,0.35365031528907087},
{0.6126791063630129,-0.3632907362244713,-0.23921559275892124},
{0.6515785077520381,-0.3416987197665365,-0.2210394227348427},
{0.6530750351896634,-0.40598623865036676,-0.20817650516372863},
{0.6120900339780044,-0.4437513212236206,-0.24872324683293037},
{0.6484475300207788,-0.4813527009677801,-0.20047216020706482},
{0.6746477166677837,-0.43942028574522163,-0.16695690619698997},
{0.7039943490298995,-0.39256260666463855,-0.1521965826067678},
{0.6873546654017294,-0.36299813352994853,-0.19009314304275868},
{0.6051358862381349,-0.30767044429205603,-0.24395395181207433},
{0.5793855601214752,-0.40432729738230144,-0.2700471515707738},
{0.5449087131153035,-0.46479293525617554,-0.3023507468458203},
{0.5989435367029476,-0.4981483534331189,-0.2552223780478374},
{0.5931636667371321,-0.545281878225719,-0.2440892966707743},
{0.667477017153994,-0.5466920427535074,-0.18305005439574323},
{0.6983717368999066,-0.4776971007842267,-0.1437639534104327},
{0.013891538497233768,0.6827883876689234,-0.19224448179676104},
{0.08143893497775187,0.7286690057695583,-0.26120075380641306},
{0.09044001258062684,0.7622100397527186,-0.3000060582936752},
{0.06894080402580058,0.7998668464390125,-0.32692550618977156},
{0.0759761586808903,0.8551223517522649,-0.357878230875127},
{0.09302832187843195,0.8263519017886148,-0.34684955838906106},
{0.09734388937297947,0.8649896364508196,-0.3452963150106472},
{0.09759266611325655,0.8119615208121723,-0.2928005558162198},
{0.06900525395851484,0.7883212854925783,-0.23357622364642255},
{0.050363755420239305,0.8847358068358179,-0.2725258959829646},
{-0.09622117154509695,0.6022710867289855,-0.0820918127961475},
{-0.18882283486896045,0.5729811703076583,-0.0798914920932823},
{-0.28961995163677057,0.5400820576543319,-0.06623068435516558},
{-0.12606535738776695,0.5868031028775607,-0.03498406797663307},
{-0.06175979252277664,0.6120352515351977,-0.06934877209988197},
{-0.021531433521183436,0.6383656270462855,-0.12486852213726293},
{-0.588100480023099,0.6897876503616932,-0.6211046460667496},
{-0.34187853507880944,-0.9521388354670557,0.5868121258681407},
{-0.37320893636987046,-0.9660522869414124,0.5800539059237223},
{0.10077133679472436,0.7619470840272445,-0.2732838271916845},
{0.09150988146368373,0.7377667582715046,-0.2304465349138176},
{0.10447076293252348,0.8090135808898217,-0.3251698900226349},
{-0.28587541054607146,-0.04282891378661393,0.5121185208482643},
{-0.160363033580993,-0.20446805603534934,0.5968508473877153},
{-0.24286539244853034,-0.2260330035215442,0.5893398522291943},
{-0.2570791806093355,-0.27411909831966125,0.5773985686958943},
{-0.2570778916106812,-0.3102523085965897,0.5812758766479849},
{-0.25399202883232197,-0.3738192772326745,0.5754676487117748},
{-0.2096337181423983,-0.43179070271050635,0.5511777580704206},
{-0.2374013271530145,-0.5361351437749098,0.5525131606762603},
{-0.22747990451097974,-0.6364102160877343,0.5288278104037659},
{-0.22666912435743422,-0.7225733311334422,0.5097029373701334},
{-0.17806227410298592,-0.7184923613939747,0.4920952157525948},
{-0.15950069348127605,-0.7461813414866795,0.5042504730625061},
{-0.10294974452046676,-0.7417768330849862,0.5455306549659963},
{-0.07925537125739245,-0.7622151957473355,0.5853168874291695},
{-0.039635419620621955,-0.754647484648026,0.613875941613517},
{-0.27390448004372286,0.06596772862969144,0.4467766010652285},
{-0.38912291375567815,0.20437138113627817,0.36694891440533334},
{0.6396114442456522,0.08253780633053026,0.07641377372402021},
{0.6140351329473213,0.06946864897473053,-0.021864639673316207},
{0.6100946640611706,0.02654112679106372,-0.08641124728665787},
{0.6158319970713951,-0.029008270215365804,-0.12343644463235184},
{0.6279189374526294,-0.13254708712084093,-0.16935831068992369},
{-0.234878756786578,-0.3514435495929341,0.5722515970693327},
{-0.20956024521910405,-0.3089401079665272,0.5677091658116309},
{-0.21195649371742062,-0.359454676229318,0.5585804773419817},
{-0.18045723360264815,-0.3877894446478197,0.5578831290700133},
{-0.16054091539528437,-0.4509400667185703,0.5499983243017494},
{-0.16041072653120156,-0.5233521441203615,0.5265720627587666},
{-0.20480899617940804,-0.546835121604133,0.5363091585932385},
{-0.17365003170936696,-0.6145732898854853,0.5086962294211365},
{-0.1443742942732368,-0.6326089590562467,0.5021094462977381},
{-0.1450561745613538,-0.7167083872564436,0.4932875395078088},
{-0.11686319599482342,-0.689147018030513,0.5241642132725614},
{-0.06171725556718523,-0.6872431670181336,0.6051752006970905},
{-0.2118868877900892,-0.27815753110353736,0.5823599245162389},
{-0.16990549061866786,-0.31903554542689055,0.5829799328689501},
{-0.1937906356825764,-0.25045308302698116,0.5885020031039088},
{-0.16036561157830156,-0.25392822339893467,0.5893153612547629},
{-0.13441935766619065,-0.2856607922701328,0.63666157082532},
{-0.13657069642019298,-0.33571518801334366,0.6474375995751461},
{-0.13840751950254968,-0.38912484725365937,0.6339224486849636},
{-0.13678595919545866,-0.47542846315268444,0.5687532547216021},
{-0.1320643571248112,-0.5560553289782365,0.5304790176799056},
{0.1222628113576249,-0.4670473939025207,0.7663606154195176},
{0.06360950559167614,-0.476533134999407,0.74416921458734},
{0.039003810280022026,-0.5061259661044913,0.7241317305064734},
{0.02009033302569229,-0.5058423864005486,0.728117314345524},
{-0.01282038061552267,-0.42107396789877743,0.7420694357795091},
{-0.04872157113467977,-0.39418158897442107,0.7411245997659178},
{-0.09207961886887794,-0.40413781458012155,0.7091677451288741},
{-0.10545555790439759,-0.3657578796487736,0.7077034426576059},
{-0.04405024001154946,-0.10323654672104517,0.5824140624597188},
{0.6581498228915849,-0.7504827299960298,0.44135507272530405},
{0.6855655352695813,-0.685185925165894,0.45222906537285573},
{0.7001840690078319,-0.632772661885341,0.46208346008486767},
{0.7309627788748588,-0.5902550412737368,0.4275473191405988},
{0.43202207796895065,0.21584991415268975,0.02198451654816469},
{0.4881515243698086,0.1910882500038672,0.03328258975297628},
{0.5291017226178016,0.1756215551510965,0.08196420192937316},
{0.5432394598580039,0.1752335665561566,0.14777273922526024},
{0.5259256299336423,0.18735144290509367,0.21913170472650026},
{0.4937432005320987,0.19962657708985368,0.29305191055380536},
{0.4789880329364936,0.18477086759921438,0.35303932992693954},
{0.4968857792512465,0.14219653104682176,0.41713349901262703},
{0.22749537249483112,0.08439396439270123,-0.2043688031389696},
{0.1924152741184538,0.07458339563493512,-0.20220715239573292},
{0.21055793017752086,0.12482211818570876,-0.15633426828702393},
{0.2741184538203342,0.132605092060284,-0.16046937596997154},
{0.2740913848485942,0.18200596548577208,-0.10243478955807975},
{0.1858194680044754,0.16437761988976501,-0.11472281372938249},
{0.13035643390788298,0.09434374500513032,-0.17887498775451283},
{0.18820540451355766,0.025855379506983914,-0.2342941958968595},
{0.2404446529757823,0.037130250736018285,-0.23604207807207053},
{0.3085282728964831,0.05838326054787612,-0.21736835456743792},
{0.29925779457486246,0.0998825722225947,-0.19077760132818425},
{0.3379032632289932,0.14264123558255012,-0.14766188534099176},
{0.3378774832559075,0.17207938684912025,-0.10759078417522137},
{0.30953755884278855,0.21998759983294597,-0.04801713337011279},
{0.12535254113194705,0.1578797776735122,-0.1273807805144652},
{0.02107512799756634,0.10089959216082593,-0.16735391778250988},
{0.057314036164146216,0.06979605463291913,-0.19340973658023505},
{0.10885078035978527,0.046185466282373334,-0.21600459399120395},
{0.1474614460502503,0.035332097613290245,-0.233708990507814},
{0.17521358707701506,-0.006856828341471111,-0.2583353097979366},
{0.26562781968455623,-0.009147378950136313,-0.2413205275613693},
{0.3126620915807764,0.023394681075953012,-0.23294848130178555},
{0.36635533052503494,0.06879063568257651,-0.19210526994209823},
{0.38328117185445654,0.11239488215974315,-0.1610880953240285},
{0.4202264512835849,0.12648492644973694,-0.1280407478254593},
{0.3902301635997092,0.18234110513588633,-0.06901105445245918},
{0.36698049487236334,0.2197555800751745,-0.02194971358449904},
{-0.587418599734982,0.553978752146183,-0.3546660462286478},
{-0.5796343368617524,0.6512865495568425,-0.41975016628082645},
{-0.11023903191045073,-0.613379677131617,0.5429835936251283},
{-0.044696028337346455,-0.6172518290890904,0.6405595027558791},
{-0.019840267286760995,-0.6788260058056499,0.6605505828851915},
{-0.09381332205889181,-0.5445535939860479,0.6014551505808228},
{-0.04146966470567009,-0.5489026754456068,0.6837822056313774},
{-0.007987924660606683,-0.5219600255737332,0.7163191096628495},
{-0.9777493052297255,0.137758508680117,0.5557124553361966},
{-0.9723806258346268,0.18989850424596175,0.5448436186832621},
{-0.9581294567128474,0.16329099402420236,0.5877505168884605},
{-0.9250202372788724,0.07853030951435704,0.6042187636956107},
{-0.9410089765866286,0.06223349952822658,0.570432819968136},
{-0.9095058494758933,0.030035602142831477,0.5611236716868868},
{-0.8758256036380699,0.008127781014596719,0.5281111271519833},
{-0.8309903634460606,-0.017511691217794265,0.3985964093653486},
{-0.8952340563756453,-0.11709972724788464,0.34668972255592967},
{-0.9100936328622475,-0.10441984748567915,0.3029488422214087},
{0.03323425230344056,0.6641082191710194,-0.15296224780741333},
{0.07163481121325709,0.7015007811331847,-0.21601748397774675},
{0.07240434340986544,0.7005327431438164,-0.1890890130910704},
{0.07494238176015341,0.7226004001051823,-0.187745876493305},
{-0.30602117051389804,-0.9186300264502524,-0.3336282991920557},
{-0.22114705412247554,-0.8910583452350875,-0.36321468530386863},
{-0.25948831909419495,-0.9415561565153726,-0.3639094555785284},
{-0.3286443858952611,-0.9520679405410701,-0.3321923546911818},
{-0.2851303693238945,-0.984608711568505,-0.35525254061634765},
{-0.24586360331839818,-0.9716078711413825,-0.3784880303584964},
{-0.19223223630954533,-0.9672832806562549,-0.37608791486421694},
{-0.17792177324966876,-0.9295555790439755,-0.3691891940664815},
{-0.1111774229307705,-0.8859539105641173,-0.3573432964335986},
{-0.123947532598776,-0.8440227843402132,-0.3445164708248045},
{-0.18993395170895447,-0.8431668892337676,-0.3428369055782706},
{-0.22928450262697933,-0.8431088842943248,-0.33050763345003076},
{-0.2751934786980083,-0.8724761406349092,-0.3275571155303714},
{-0.3125899076561365,-0.8845669480121062,-0.2910397836544659},
{0.5558510226915323,-0.5144696543936808,-0.28868993910770363},
{0.5386931616043393,-0.5704547329452587,-0.28468888728480174},
{0.5801215783530722,-0.5898670526787969,-0.24769075891084777},
{0.6278738224997293,-0.5864421832543606,-0.21901569484761466},
{0.6644375583271892,-0.604432737472222,-0.16968958334407502},
{0.7078136520425472,-0.5844468133375268,-0.12451404750733445},
{0.7309975818385246,-0.5411377475521915,-0.1042484106646593},
{0.026486344348256464,-0.5744944547277893,0.7116967604885821},
{0.0840156432876684,-0.5314109637069538,0.7317883825129288},
{0.04421007584468078,-0.9769494815647413,-0.2261090544421472},
{-0.08856194154133308,-0.9863669057329504,-0.2801709470015314},
{0.06757317645360375,-0.9829587932910199,-0.25228346111606664},
{0.19025877936983435,-0.9809157304239774,-0.2300714363054205},
{0.14761870388607315,-0.9838146883974653,-0.2722126693099733},
{0.0010737358790197072,-0.9866169714718817,-0.2983148920592527},
{-0.11811352468948028,-0.9882230637951214,-0.3201724422399703},
{-0.21191524576048348,-0.9870410520291416,-0.3253078128786434},
{-0.23715383941139168,-0.9837347704808996,-0.24524552846366832},
{-0.13554078649541895,-0.9827693104888399,-0.25614401208565146},
{-0.11954946919035421,-0.9568797725175175,-0.23102658430824605},
{0.02345075251741434,-0.9574005279738488,-0.2128156113205018},
{0.18630413149848668,-0.9570795673089317,-0.1862274360785568},
{0.2388926985960227,-0.9756862628835415,-0.19496942495192038},
{0.29752924737946573,-0.9794733409298321,-0.22276410293427656},
{0.30014591464766505,-0.977833734641581,-0.24971319779942155},
{0.2347189209534465,-0.9715305312221254,-0.28078193236366267},
{0.14063619817580908,-0.9714196773378568,-0.29314729645422255},
{0.12829403606102635,-0.9501009285946306,-0.30542629763494533},
{0.025194767696662502,-0.9678066141098948,-0.3169602575934911},
{-0.059277181114622955,-0.971361672398414,-0.34128237320120247},
{-0.1259106775492527,-0.9726416480621195,-0.3561703076581989},
{-0.2109265837926466,-0.9866827104032503,-0.3640087084749084},
{-0.29235907377712705,-0.986531897560699,-0.28525862468999585},
{-0.31310679611650494,-0.9815331607793801,-0.13554143099474605},
{-0.25998716157340335,-0.9599514563106797,-0.17434415748469964},
{-0.1906300109822686,-0.9610857751264508,-0.22843569701313238},
{-0.14244208529046298,-0.9248391329679452,-0.20273564184398996},
{-0.04235005078654702,-0.9292204393938613,-0.20286969770403562},
{0.07331308746113667,-0.9263085914338306,-0.18257570289096625},
{0.18469932817390136,-0.9247811280285023,-0.16340313690712513},
{0.24562256057004675,-0.9505262981505447,-0.17145937849640888},
{0.32321512356341103,-0.9604038948383338,-0.14393539023145266},
{0.3401615888713012,-0.9789396954869579,-0.1797102588824898},
{0.3977360027636131,-0.9753794812038217,-0.16774319537610405},
{0.3963825541766134,-0.9702673125409257,-0.22081384797034279},
{0.37136180129827945,-0.9563216361002119,-0.2610679869450217},
{0.26586628443559907,-0.9541651413515924,-0.2886822051157779},
{-0.11050198763592495,0.621905114231061,2.771347106711026e-05},
{-0.12233757327957354,0.6378074906289798,0.012424013529329852},
{-0.18761246513258648,0.6180226502843533,0.043763437810970904},
{-0.25717198851244405,0.6170146533367021,0.07306624421884102},
{-0.20622947269643055,0.6359152406044891,0.04741645999721574},
{-0.08433660395258552,0.6558624947795556,-0.021963892569696195},
{-0.056923469571897804,0.6280832847810507,-0.04137879030054297},
{0.09439079345601159,-0.9561192633114891,0.6563123553099012},
{-0.011945150529262882,-0.9520988765087728,0.6922496377913782},
{0.019262795889641054,-0.965544421471624,0.6653301898952818},
{0.11175876132385315,-0.9686135272674775,0.6314114793064156},
{-0.015863706438290513,-0.9705264012704371,0.6541287915895415},
{-0.0790555764659782,-0.9605624416728109,0.7005417661343963},
{-0.08731032384802195,-0.9424649005666438,0.7170306369200151},
{-0.010533697002820364,-0.9183064877880268,0.6945853033529433},
{0.06909548386431483,-0.9346819266920685,0.6671592789857128},
{0.12146621018927656,-0.9173100918282642,0.6498054901030683},
{0.17552552475135214,-0.952867119706727,0.6361897973178516},
{0.1801324059417682,-0.9701989956122485,0.6070365147538787},
{0.004245961567216096,-0.9711335196366055,0.5822013776817617},
{-0.12274231885701917,-0.9731288895534393,0.579479012523911},
{0.2589791646257521,-0.9579779993709686,0.612362657193386},
{0.2801342105398842,-0.9711077396635198,0.5793320666773224},
{0.37413185940633875,-0.9664325415444266,0.5684851430015108},
{0.3264982031358759,-0.9701641926485828,0.4865628335284018},
{0.4156994880097345,-0.9706230761695084,0.49584104584194816},
{0.3866712383152272,-0.9708370499461197,0.42682934689016183},
{0.3465898251602225,-0.942325688711981,0.41640779277026435},
{0.33232576605190023,-0.9346986836745742,0.456087038345132},
{0.3055867779674038,-0.917106430040887,0.3999859499146683},
{0.28423064826320316,-0.9106240558084857,0.44797150281775105},
{0.2580974895462209,-0.9209192880602632,0.3529400770305596},
{0.4499971642029606,-0.44272398929615514,0.6956796632104316},
{0.3979796235092731,-0.4318306616687892,0.718019298887852},
{0.4379708067584777,-0.47804770841819233,0.6871503591150251},
{0.4871473944181202,-0.5261376702122722,0.6507606381058938},
{0.4133058175087265,-0.4973092153091791,0.6986327591273995},
{0.4472606200599127,-0.39490342822082086,0.6991754275608537},
{0.4968019943387179,-0.3854408890997117,0.669088909971178},
{0.5090036556001836,-0.45119786644942733,0.6547436439476357},
{0.5180176231896014,-0.5165913461786344,0.6250979638977258},
{0.533231674306132,-0.8510336480208714,-0.12037378382976971},
{0.5006599673109942,-0.8399173236263141,-0.2068359465632718},
{0.5599165244471485,-0.8062151648113679,-0.1926466493768981},
{0.5833466529860943,-0.8002819040056921,-0.14649405256020917},
{0.5999193086842417,-0.7711853373825077,-0.16123633016927133},
{0.5999102856936618,-0.7426507741725918,-0.19003256010600728},
{0.5616979205873709,-0.7570231091678741,-0.24171109415361777},
{0.5331723803680349,-0.796387839071096,-0.23447594470711375},
{0.46301991760720607,-0.811879024898298,-0.2659520028461091},
{0.4789609639647536,-0.8570622947269643,-0.24457524916343995},
{0.49985305415341147,-0.8674658028657017,-0.16826523983108968},
{0.4962361239294866,-0.8987639791904056,-0.10287176010188251},
{0.5930502348555547,-0.8082376036999416,-0.09056440095076546},
{0.6367808032008414,-0.727581090905341,-0.12276229833616059},
{0.6118051652754075,-0.6812686582555209,-0.19381577115633494},
{0.5911837648041495,-0.7082061521327772,-0.2134562436516817},
{0.5447952812337264,-0.7234279372412334,-0.2604905155479018},
{0.4780290179377053,-0.7579795461693537,-0.30179518842582337},
{0.41865645092266524,-0.7602984547484132,-0.3211611042078073},
{0.39655914699225053,-0.8323547685216216,-0.2993602699678782},
{0.4389504457357346,-0.848384755786315,-0.27822971502817756},
{0.43103470499976804,-0.9275228281661674,-0.23720991085285315},
{0.4551003098752765,-0.9262596094849678,-0.20178307183847305},
{0.46967115066331877,-0.9270342976761932,-0.14211790212891023},
{0.615384714538358,-0.6397925485565793,-0.21462407643246423},
{0.564859834286333,-0.6291247956937133,-0.2682386864588114},
{0.5162014240857132,-0.610475563163512,-0.30376220037226287},
{0.5045243852765418,-0.6659063722937473,-0.3162152163713141},
{0.5291687505478244,-0.6921336279124923,-0.29353786304647106},
{0.634348462740205,-0.21161297557605344,0.5461803102877562},
{0.638792930100181,-0.27305954142583866,0.5632634094530006},
{0.6423196304183059,-0.3399263466168941,0.5558052632393052},
{0.6089977262063739,-0.32474323146806633,0.5735186827464952},
{0.5829393294113401,-0.2854081485338929,0.58928442528706},
{0.8830233721235996,-0.7900988146368374,0.33037357758998503},
{-0.6032771501786554,0.07168830465741,0.5678625566514909},
{-0.6290197423033891,0.040500982216974665,0.5645936560642231},
{-0.33466658760808254,0.6074000123743871,0.08615473655445502},
{-0.5763164543256217,0.17508017571629667,0.5741838060521065},
{-0.5487847320687398,0.1267001892250025,0.5417719348901},
{-0.5709645319130288,0.088471067136206,0.5302457089234799},
{0.6802381038314196,-0.5604997963382126,0.5061079201233314},
{0.6721174123094216,-0.6254601725195799,0.5038470164837148},
{0.7077079541528959,-0.5732763509994895,0.4719636347699653},
{0.7308686819730961,-0.5137710171230581,0.44086654223532995},
{0.6493292051003099,-0.6656099026032617,0.5129344569964269},
{0.6424523972796973,-0.6236065924547174,0.5318878932090395},
{0.6466235969249647,-0.5555358625205595,0.5312189029074654},
{0.6843964134901442,-0.5018361785830295,0.49751287709655634},
{0.7121330865330577,-0.4447502951806918,0.4709079448721056},
{0.7606484178830519,-0.4033463694063903,0.39532879777673513},
{-0.6121016349658932,0.31558876302533156,0.5340057179980304},
{-0.6002312463585789,0.26060652542678764,0.5562306327952194},
{-0.5560263265085152,0.22053413526236296,0.5446476908878107},
{-0.5224891595213175,0.17076718621905776,0.5376896761519782},
{-0.4888527396377399,0.13611374639724888,0.5018555135628439},
{-0.5034712733759906,0.09783693135824376,0.49930329622735875},
{-0.5185718926109443,0.07047020092911033,0.4895249524359497},
{0.693170627329865,-0.39026303306539345,0.4985930579688475},
{0.6737969775559555,-0.47791365255814666,0.5151425116912178},
{0.7117128729717607,-0.29212640952002844,0.47265196005135374},
{0.7686556775234726,-0.3170543544952539,0.37839908945135065},
{0.5875281646205962,-0.35576040608613596,0.5930637693414248},
{0.614670609283884,-0.40156755126347643,0.5783872306637312},
{0.5423126698255727,-0.40510714156814415,0.6381684102521797},
{0.5345851228931316,-0.5988487953018576,0.6017928682282456},
{0.49888372716538887,-0.6351805113715461,0.6285756822669878},
{0.5647721823778415,-0.6470792579492547,0.5792328137809425},
{0.5897619992884727,-0.6964169704406828,0.5397198490324776},
{0.5296108770862443,-0.7114557177402306,0.5744944547277893},
{0.5645504746093045,-0.7583842917467993,0.5186189410618256},
{0.5494047404214509,-0.8227207925794925,0.5124987754512784},
{0.46054504019097803,-0.8494932946290004,0.5735019257639895},
{0.46775440966439635,-0.8938387153323811,0.5687493877256393},
{0.43167662632960213,-0.9432421667551779,0.5733833378877953},
{0.36283120820421866,-0.9530849604793011,0.5946737286606273},
{0.660038205920113,-0.2993074210230524,0.5421083635388685},
{0.6824564705154449,-0.3314498914663132,0.5081123130307452},
{0.7458958282847552,-0.25383283749851754,0.4043698343378929},
{0.04572593826212043,0.7233673543044823,-0.16290558342657094},
{0.0034790073679162813,0.6844202599652487,-0.10009396800189743},
{-0.07477223393778781,0.674810774997551,-0.05915794873910157},
{-0.014060397320945234,0.6571966083867409,-0.0673508241857396},
{0.007003129688732579,0.6465559244956149,-0.10583130101212178},
{-0.5844938617884083,0.3331384797034274,0.4921815786624319},
{-0.5713873234716343,0.2788149204172232,0.5207316098561994},
{-0.5336750898432063,0.29075620395052326,0.49498772873281127},
{-0.4990487189931374,0.25016563632707584,0.4908603550417893},
{-0.5170908331571703,0.20729869708016035,0.5273145259836349},
{-0.48172071008357875,0.17048618451242345,0.5034654728820463},
{-0.42362940773089836,0.13515215340115194,0.4336906867269231},
{-0.45729160758756177,0.09793489525596955,0.4543945831120553},
{0.6198420718848769,-0.738456372551547,0.49492198980144264},
{0.5680552619503065,-0.8456495006419212,0.4851114210436765},
{0.5082018984372181,-0.8575869171792585,0.5463659260939732},
{0.49616394000484665,-0.9021888486148419,0.545615728877179},
{0.4775894693965939,-0.9425138825155066,0.5260332613212751},
{0.4284657306817772,-0.9605340837024167,0.5512177170287035},
{-0.20851486731047858,-0.5644235082418574,-0.21788266503049777},
{-0.22190498533119538,-0.49048525643339225,-0.24930458522601306},
{0.04294685716348109,0.6811139784170067,-0.13557365596110318},
{-0.4529644391051257,0.1998830878220564,0.46494374809872696},
{-0.42196659946687026,0.19026200186647024,0.4287306199052328},
{-0.40013998525385547,0.15464954704587294,0.3907657425405648},
{-0.4215915008584732,0.24931876421121033,0.40914815234932894},
{0.4562720096520219,-0.9649321471108384,-0.09275569866305061},
{0.4383961763143919,-0.9653768516465668,-0.1701858478259749},
{0.42113261733754753,-0.9762456882995013,-0.019134540523539727},
{0.42748738070317455,-0.9765215340115184,0.04868741267034115},
{0.49143847093823634,-0.9735671490958964,0.0918624225956308},
{0.5404977597203389,-0.9745609670583504,0.1610584483549799},
{0.6014454830909156,-0.968977024887986,0.1458779112034607},
{0.6338006383121336,-0.9582022851368143,0.10965318202207795},
{-0.3881355407864954,-0.9735259011389592,0.5313503807702025},
{-0.4517540693687517,-0.9755496290261872,0.465553444462204},
{-0.5019334979814282,-0.9799605824211519,0.3629388395918514},
{0.5879303322007332,-0.8610594795539034,0.4336185028022831},
{0.5897065723463385,-0.9150981701375103,0.3701623880504669},
{0.5386712486272164,-0.9287022619348385,0.3984533305147229},
{0.5218253252143605,-0.9073319532454408,0.497953714636322},
{0.5950494717683515,-0.5625596161877606,0.5642159794585174},
{0.6039293834977236,-0.6185047357810558,0.5546309854652511},
{0.5531028775605958,-0.5432529943438739,0.5850113947481039},
{0.5999334876694389,-0.5092298748640106,0.5560243930105336},
{0.6416557961113489,-0.47244700926532224,0.5409766227204059},
{-0.022258428762200418,0.8556237722287819,-0.20058430308998765},
{-0.11249735755275876,-0.7563876328313113,-0.32743723865552293},
{-0.11921432954024,-0.8051143599606081,-0.3179605205492166},
{-0.1385041944016211,-0.7235323461322306,-0.30504346503462254},
{-0.165588634125466,-0.6709076870723746,-0.25559618765758013},
{-0.18057066548422532,-0.6851665901860797,-0.21078672743865665},
{-0.203724948311154,-0.6301701736023387,-0.18008277949357823},
{-0.22309215309179223,-0.6275676853193365,-0.14914810078938281},
{0.5901448318887955,-0.4648715641740869,0.5791400058778339},
{0.6200031967166626,-0.4414246786526354,0.5694970069451247},
{0.5504604303193107,-0.4462120196546514,0.6174168209168389},
{0.5473010946176572,-0.5104763365627045,0.5932248941732106},
{-0.2324554393165214,-0.9723116644066223,0.4648187152292613},
{-0.16760076102480553,-0.9779110745608381,0.229897421487092},
{-0.15546226069739988,-0.963607056494233,0.24274744907166315},
{-0.1828302801251876,-0.9275769661096473,0.43661413567484236},
{-0.12606020139314977,-0.9333684370633517,0.22154728820463107},
{-0.14166224110462033,-0.9292397743736756,0.1214217397357037},
{-0.06305652516898776,-0.9266218181068219,0.07724131086007144},
{-0.1968739204636271,-0.925881932879262,0.013678209219949552},
{-0.0896627463920928,-0.9225008894090715,-0.12388630516269744},
{-0.17986687221898545,-0.921803541137103,-0.16200844036318832},
{-0.21091369380610372,-0.9275318511567474,0.012336361620838445},
{-0.27411587582302566,-0.923365807506097,-0.075093839102032},
{-0.21405756152390581,-0.9355030188348483,-0.18917279800359893},
{-0.29478754724180073,-0.9535876699544725,-0.07550374067409478},
{-0.3154205487009472,-0.983474392752734,-0.005128281146074515},
{-0.2644200279454909,-0.9863411257598647,0.07804564602034553},
{-0.2814966821174639,-0.9824187028548742,0.12932330148647322},
{-0.23062119423147331,-0.9838185553934282,0.1794395691650898},
{-0.17409602524374973,-0.9816697946367344,0.20867148064697422},
{-0.23823917627830002,-0.9792928811182321,0.31228763747170646},
{-0.05671594078855786,-0.8184606520270792,-0.341185698302131},
{-0.0675744654522581,-0.7288120846201835,-0.3693412959076871},
{-0.11143135566566473,-0.6437832883902469,-0.37873938509608207},
{-0.14984480456202406,-0.6181180361847701,-0.34102070647438254},
{-0.15795389509613356,-0.6324968161733239,-0.3020890801190004},
{-0.1838898370190102,-0.5812629866614419,-0.2741551902819814},
{-0.44184553671325977,-0.20959311468478822,-0.2614018375964816},
{0.0031503127110734963,-0.9263588623813477,0.1507877070776338},
{0.032857864696389225,-0.9216978432474516,-0.03635942954075559},
{0.08219686618647166,-0.9237537961010368,0.09940177572454612},
{0.09402471783819456,-0.9255055452722107,0.21981229601596294},
{0.198648871610578,-0.9216553062918602,0.0499983243017494},
{0.17646778276763478,-0.9178540492603725,-0.016720246044063164},
{0.0949992008208343,-0.9186081134731295,-0.07737407772146287},
{0.1069134153823943,-0.9167880473732786,-0.14847395449319156},
{-0.03206899751996663,-0.9202206507896405,-0.16396514032039355},
{-0.03509556636022876,-0.9235385333257712,-0.03945947130431198},
{0.16892971863737372,-0.9278231648526158,0.18727925898045364},
{0.20610315082831052,-0.9374738977772507,0.0806184873342992},
{0.26778044743721285,-0.927362992333036,-0.02982936235814573},
{0.2657373845701705,-0.9168460523127213,-0.08507971167678105},
{0.20188039123687154,-0.9148829073622448,-0.11470992374283966},
{0.6494619719617012,-0.9261332876168477,0.3146568169982831},
{0.668326467267168,-0.8917170235474273,0.3667542756085363},
{0.7177647216536308,-0.8909552253427447,0.3410542204393939},
{0.7484209766485004,-0.8967299393139433,0.2865978942917983},
{0.6480659864191102,-0.9500648366323104,0.22878759364575224},
{0.6015666489644185,-0.952623498961067,0.27525857313004964},
{0.5206304234618379,-0.9572406921407174,0.34570879458001846},
{0.5039005099278677,-0.942253504787341,0.4457776271081573},
{-0.32369849805876805,-0.9755818539925444,0.44705373577589985},
{-0.2172684571717308,-0.9771750563292412,0.49492843479471404},
{-0.30883763257351166,-0.9729974116907022,0.5410539626396631},
{-0.29057123264363316,-0.9630476310782731,0.5668352247240255},
{-0.20373654929904259,-0.4923633274726861,-0.3014239568133892},
{-0.22817596378429383,-0.4385553676481961,-0.26928277536878253},
{0.676820968398909,-0.6969609278727912,-0.09689467334196107},
{0.6795072415944398,-0.6475484534594145,-0.13514184141191762},
{0.3887710171230581,-0.9122958870630938,-0.2708708217108622},
{0.27317490680539724,-0.9213575476027204,-0.2924486591835999},
{0.15737384570170507,-0.9248352659719823,-0.30846575646175034},
{0.045380486622771936,-0.9339227064846944,-0.3210837642885501},
{-3.8669959628600825e-05,-0.9074440961283635,-0.3362114524952436},
{-0.10509592727985195,-0.9372560570046765,-0.35667172813471587},
{0.05634084218016073,-0.09400602735770727,-0.2879655218639952},
{0.05541405214772953,-0.049096025243749467,-0.26911649454237974},
{-0.002186141717668087,0.013469391437955483,-0.2333622498698112},
{-0.010144419409226176,0.061359558440621124,-0.20266603591665855},
{-0.08764417449948186,0.06425980541276326,-0.18168629381950926},
{-0.16151539837792414,0.05941445947130447,-0.1851304982237599},
{-0.21802896637775915,0.01756582916127452,-0.2139241501631873},
{-0.26556208075318777,0.017462709268931585,-0.21604970894410389},
{-0.3710936895781882,-0.02081410577007341,-0.22318302749691935},
{-0.4579077489443102,-0.05162246260614896,-0.2292993261115036},
{-0.49580688737760964,-0.10294136602921378,-0.23736716868867597},
{-0.48998061346023963,-0.15533013833533546,-0.2570669351221198},
{-0.5340514774502576,-0.1864220748753538,-0.24663378001433367},
{-0.5444884995540066,-0.14334631784644405,-0.22867673976148373},
{-0.6098768232885966,-0.1887487174463389,-0.2143907676760386},
{-0.6479589995308046,-0.24501737570185975,-0.20551343394397503},
{-0.7636788537192769,-0.24640176025656216,-0.15675319284966668},
{-0.7858986125218486,-0.2875517532959695,-0.13163963206822415},
{-0.7756536512175883,-0.35082740823618574,-0.12849189735445918},
{-0.8054320981288897,-0.3880420883840596,-0.07128484807861865},
{-0.7839432015632976,-0.4660226399723638,-0.04954975277005813},
{0.7412644561199079,-0.5887842938091972,-0.05297462219449445},
{0.7170725293762795,-0.6485358264285971,-0.06371455898200044},
{0.7589817426230606,-0.6016059634233741,-0.013640828258975328},
{0.46312561549685743,-0.9604631887764309,0.49142493645236635},
{0.7171924062511279,-0.6747231230890594,-0.04867581168245265},
{0.7661305291597276,-0.6361923753151602,-0.02547254690666105},
{0.510866258655626,-0.5551762318960138,-0.31986823855755897},
{0.4681797792203105,-0.6198556063707469,-0.33269377516769877},
{0.4113336495676699,-0.6487936261594542,-0.3501377939561432},
{0.43365781726123875,-0.7037578177768382,-0.3454819308168643},
{0.47400734213633483,-0.7185297423549489,-0.3303181506478508},
{0.2739521729939314,-0.9338505225600544,-0.1479183960731945},
{0.29977081603926803,-0.9279211287503416,-0.11191924165631176},
{0.35156793796307273,-0.9720383966919138,-0.12607244688036548},
{0.37080624287828245,-0.977287199212164,-0.05768075628129048},
{0.33964341141227844,-0.9786122898287694,0.04122797745799152},
{0.3972062243167018,-0.9596485416269225,0.06922116123310765},
{0.4140727717080263,-0.952740797838607,0.06631962526231121},
{0.48593573568309195,-0.9566413077664747,0.13234342533346394},
{0.5034016674486592,-0.9483117984624824,0.19930432742628215},
{0.525029775868914,-0.9710832486890884,0.24776423183414195},
{0.5806874487623035,-0.9681237077788489,0.22556123001407585},
{-0.5825332948352403,0.5172448684963574,-0.0019006285157438523},
{-0.6254157020660072,0.5639401337465005,0.03088634125465971},
{0.640351329473212,0.08715757750748919,0.13892891945820807},
{0.5920551278944465,0.13046535429417025,0.09788720230576077},
{0.6226211529835163,0.09150279197108531,0.0408322548711259},
{0.5481698797106456,0.14274435547489306,0.018640854038948353},
{0.5468086971317202,0.11155316603849477,-0.045770408715693336},
{0.5509489608092849,0.07231991399800998,-0.0868417728371892},
{0.560289045058237,0.03265226941103082,-0.11636113101897927},
{0.5173782798570759,0.17248799942252874,0.3397342858174056},
{0.4929698013395274,0.162223703138454,-0.01868339099453983},
{0.45375072828423973,0.14568456140531805,-0.07989407009059087},
{0.4977584313401977,0.09734968986692388,-0.10999089966950079},
{0.4803118345544447,0.06445960020417751,-0.1498016231071055},
{-0.5168510794074732,-0.7798113163769858,-0.0006399878318527354},
{-0.6857021691269355,-0.8775483503395222,0.1053376145275304},
{-0.7007654074009149,-0.9124389659137196,0.12369811135917173},
{-0.67285085254371,-0.9240219078211281,0.15791715863448638},
{-0.12209781952987646,-0.4192062088487179,0.6424169498167044},
{-0.06032900401651985,-0.46350522560054436,0.700441224239362},
{-0.09521446359610006,-0.4883223166915013,0.6337149199016237},
{-0.5052952064718045,-0.6228744412190833,0.37913897467891045},
{-0.553126079536373,-0.605670176180336,0.39019858313267924},
{-0.5181207430819443,0.6092342574594355,0.026872399445214953},
{-0.5400556331819191,0.5313284677930797,0.010624571407947432},
{-0.3717768588649594,0.5738177304342896,-0.07495076025140633},
{-0.361604081485339,0.6097911048780867,-0.09268995973168206},
{-0.3876018953436213,-0.9758860576749558,0.4124196309339053},
{-0.32347034529695956,-0.9858861092349018,0.3663624200176335},
{0.11571083119789222,-0.011753734229101361,-0.2668671918906517},
{0.1341512459460992,-0.06326727644896328,-0.27532560106007253},
{0.04854240032173403,-0.00160415882525802,-0.24077141413464367},
{-0.2631800112400683,0.07462593259052647,-0.1764735832615791},
{-0.33074029770712926,0.048619095741664176,-0.18955691960257595},
{-0.40034493603988686,0.01900435165945704,-0.20623785118768342},
{-0.4291695239470171,-0.0031419342198205076,-0.21941657342909734},
{-0.11963454310153705,-0.4377652114731192,-0.4549901004903351},
{-0.12012565158881978,-0.5023930260016808,-0.43786317537084496},
{-0.13447349560967062,-0.3813122264100356,-0.45293414763674994},
{-0.08248689088368595,-0.43290310854915465,-0.4756952858741216},
{-0.015148312185162114,-0.5096591114158876,-0.47643517110168143},
{0.010079969476511842,-0.46228841087089895,-0.4818554104429516},
{0.08763644050755608,-0.48313538610665685,-0.4663487566318982},
{0.12138887027001942,-0.4557042057448091,-0.4607080985207452},
{0.1875235242254407,-0.46702548092539786,-0.4434793425075665},
{0.2787098670268988,-0.4690530758085888,-0.42627507746881915},
{0.28037138629227265,-0.4141004851790934,-0.42443438739049966},
{0.4322463637347963,-0.003101975261537656,-0.20028138840623053},
{0.4277915843855859,0.04989004841478964,-0.18064864990280952},
{0.09915106548628759,0.016289720493531907,-0.24569538899401397},
{-0.7443980118484758,0.7996232256933525,-0.5938255675461076},
{-0.7308854389556019,0.7549194633640804,-0.5582595166770646},
{-0.7402629041655282,0.5977583024403323,-0.30529739776951675},
{-0.749958752043063,0.5661920143955371,-0.2254748671042388},
{-0.7492085548262688,0.5488188905330785,-0.23092604241321177},
{-0.75569995204925,0.5395638801953091,-0.16642841674873296},
{-0.7700091261104723,0.5580816348627734,-0.14715788686716616},
{-0.7843505251380517,0.5984453387230666,-0.19485599307034326},
{-0.7786312381089876,0.5961174071534272,-0.22544908713115308},
{-0.7636105367905996,0.5990975720421349,-0.2570037741880598},
{0.31213875812713654,-0.9731134215695879,-0.019714589917968147},
{0.2677069745139186,-0.9790299253927579,0.08323902159846143},
{0.338105636017716,-0.9554386720220264,0.0774655966259171},
{-0.15837410865743062,-0.4798729305126605,-0.41083287359048004},
{-0.12554202393412706,-0.5809381590005619,-0.3890539523276738},
{-0.1531304621317976,-0.5396966470567004,-0.37545888352092566},
{-0.17432417800555822,-0.5472862711331329,-0.3373651062908291},
{-0.06587427622725565,-0.5543744747330482,-0.4518397877792616},
{-0.0803716440920036,-0.4817561575465715,-0.47164911909831975},
{-0.1827529402059305,-0.42707296763582175,-0.40389806083042457},
{-0.1853992544431784,-0.4661463838431752,-0.3719747201583922},
{0.24654806160382367,-0.9642322208415613,0.04907024527066391},
{0.3135063856993333,-0.9463770114823999,-0.06804817245770799},
{-0.815197551933756,-0.23295879329101976,-0.10231491268323119},
{-0.8240233257196482,-0.28292038113112195,-0.08143957947707907},
{-0.8110753342373512,-0.334190302605324,-0.09382170055014467},
{-0.8525694899174527,-0.2173412855956978,-0.06062611820633264},
{-0.8568193184806315,-0.266516584256686,-0.05372610840994284},
{0.0608123785118768,0.15518705948470995,-0.10608265574970743},
{-0.007239016442466865,-0.8625405390076772,-0.3374978731522205},
{0.013565421837699574,-0.8392560673166657,-0.34023828429123126},
{-0.004943309839184571,-0.7984373469314098,-0.3642665082057655},
{-0.03224172333964087,-0.6693531546953065,-0.4181182939845011},
{-0.5711952626721459,0.5529694661998776,0.03199359109869087},
{0.21258681405936608,-0.9627588953797132,0.12558649438769984},
{-0.4553181506478508,0.24678330385823086,-0.033983805020907594},
{-0.32672506689903025,0.17972830486364982,-0.10412466679384792},
{-0.3207144661740974,0.20105994359341905,-0.07137249998711004},
{-0.29701106992044307,0.1470508999788605,-0.1300348287436388},
{-0.3595867985913824,0.10005787603957755,-0.17070918127961476},
{-0.30228049641916177,0.10469698219635075,-0.15715278243249517},
{-0.2560505596832157,-0.9647993802494469,0.3159883526081599},
{-0.2768614429566536,-0.9631907099288989,0.3333717884598529},
{0.5014887934456996,-0.48286340739060263,-0.32763574444828286},
{0.3536818957561009,-0.8506289024434259,-0.3021922000113432},
{0.2833592851729063,-0.8844676951157262,-0.2911003665912173},
{0.11412794085042974,-0.8850657904913147,-0.31489012575470876},
{0.11203976303048736,-0.8599419177206379,-0.3178393546757138},
{0.11021196293871066,-0.8379039077283202,-0.34749921371082093},
{0.10319852126074378,-0.8133085244059005,-0.3660672393258022},
{0.03927707799473054,-0.7513308911105496,-0.39651209854136915},
{-0.00014178985197142903,-0.6300335397449844,-0.4440220109410206},
{-0.012097252370468568,-0.5657692228369313,-0.46629590768707246},
{0.41919009636553944,-0.46915232870496876,-0.3643425591263683},
{0.4454637559358388,-0.5157857220197062,-0.35992000474351515},
{0.46944686489747306,-0.5561455588840365,-0.3464035648546784},
{0.4037130895235345,-0.5872349174267462,-0.36573338867434224},
{0.3148753022701844,-0.6194237918215613,-0.38223386044784974},
{0.3494887831337104,-0.6775808331056102,-0.3675315417970704},
{0.35462802076834626,-0.7149476150946897,-0.36459649186126253},
{0.4167745128874085,-0.4326659327967661,-0.3625263600224802},
{0.3657520791548294,-0.454917916565695,-0.3854318661091318},
{0.37478924872002434,-0.5184230132663741,-0.387614140830837},
{0.19840138386895523,-0.953341471211504,0.18596061335711966},
{0.25715652052859256,-0.9799953853848177,0.17072078226750328},
{0.27994472773770424,-0.9816478816596115,0.13726353319687135},
{0.2967313572124631,-0.9669919669603865,0.10352657141825942},
{0.38898112390370665,-0.7930261305807196,-0.323142295139444},
{0.32185651898179424,-0.8391374794404715,-0.3054469216134139},
{0.21362059098010303,-0.8605103661271777,-0.3047469953441369},
{0.2041503178670681,-0.8349456558167353,-0.33289743695507584},
{0.19460657183073898,-0.8034811986656285,-0.36667693568927917},
{0.16953812600219645,-0.7512793311643783,-0.38638572511330305},
{0.11112586298459903,-0.7773583519378805,-0.38140374531448995},
{0.07988182460337509,-0.7289293834977236,-0.41146319393242564},
{0.057780653676997536,-0.6542512464616986,-0.4355043078335027},
{0.03008393959236703,-0.6060478527860417,-0.4560947723370577},
{0.04595151302662037,-0.5266867836389978,-0.46964988218552306},
{0.08071967372866061,-0.5433612702308338,-0.45159874503091024},
{0.14018891564277203,-0.52381489463725,-0.4440761488845006},
{0.2263378517032828,-0.5119715750016757,-0.4251162676786166},
{0.3003225074633022,-0.5073634048126053,-0.4130344832919995},
{0.3293533351551181,-0.4621247080418047,-0.4113961660024028},
{0.31454660761334163,-0.39594236113617487,-0.4154745577445618},
{0.3110908022212025,-0.3207408906465101,-0.40406434165682736},
{0.3544359599688578,-0.3900993302362991,-0.3934971306889956},
{0.2865108868826341,-0.540155530577626,-0.4027895219877391},
{0.36442827753687823,-0.5487467066084383,-0.3792098696048962},
{0.34212731181908645,-0.6054626473969961,-0.3823060443724897},
{0.29761561028930283,-0.5766548164723715,-0.40063044924181107},
{0.25923051936333774,-0.6405827047316561,-0.39957475934395126},
{0.286135788274237,-0.667319114818844,-0.3792433835699076},
{0.3046548319403554,-0.7107893054359652,-0.3748259851816715},
{0.29317500992528966,-0.7627823551552212,-0.3562424915828389},
{0.3473928713218423,-0.7849286410344987,-0.3385986780029802},
{0.2730769429076716,-0.8294222965831224,-0.3262036669433717},
{0.2646533367019165,-0.7995007708211952,-0.3550385668397363},
{0.2331489205925269,-0.7704248281764794,-0.37220029492289214},
{0.22420455893044045,-0.7384035236067213,-0.3742162888181945},
{0.2013183878236031,-0.6530138077535846,-0.4109153695043543},
{0.1491139423250442,-0.7020408715693299,-0.4042035535114902},
{0.09508040773605429,-0.7057751006707949,-0.41469342456006486},
{0.2053980685644164,-0.5876976679436346,-0.4254810542977794},
{0.24417888207724708,-0.7044396980649552,-0.3847938117752605},
{0.1597378692336645,-0.5611494516599724,-0.43037022619348386},
{0.10665690465019154,-0.5948889914358929,-0.4430062800014437},
{0.13747815147280984,-0.643160702040227,-0.42812221254041016},
{0.09795487473511076,-0.6527856549917762,-0.42478757302177383},
{0.401181496166518,-0.9761258114246529,0.29744223997030145},
{0.4754097726721973,-0.9664944134798323,0.38026813750006444},
{0.44200923954235394,-0.9732797023959906,0.3032130869455372},
{0.4936942185832358,-0.9583170060170457,0.2533095040448778},
{0.23850599899973704,-0.9518230307967558,0.292110941536177},
{0.20241661467705427,-0.9281454145161873,0.28240993766402506},
{0.19838333788779525,-0.9429418300687293,0.2380039340238929},
{0.228384781566288,-0.9712546855101083,0.2206372551547056},
{0.27433113859829134,-0.9414221006553269,0.33820166641746024},
{0.302417130276516,-0.966081933910461,0.3325378063305302},
{0.2537986790341791,-0.9734098912600735,0.26207985088863567},
{0.3877307952090498,-0.9767187508056241,0.2952573872512877},
{0.32462271009389065,-0.9719597677740025,0.32920445581054814},
{0.33259387777199156,-0.9443468386019005,0.38624135726402303},
{-0.24375995751460441,-0.9572278021541746,0.21893835492835745},
{-0.2890089662746393,-0.9516258140026502,0.15818784835188632},
{-0.3906117072013778,-0.9616374665504849,0.12326242981402326},
{-0.8705961360976341,0.048042913343198636,0.6186645716141873},
{-0.7079348179160501,-0.5559444750939679,0.3408376686654739},
{-0.6899365297062631,-0.6030612429040624,0.27444650397784986},
{-0.7233280398455265,-0.5812810326426019,0.2613683236314701},
{-0.6665463601256001,-0.6308146729294815,0.2170203249307808},
{-0.6669627066909344,-0.6324143202594495,0.15519608247528988},
{-0.614580379378084,-0.6380743133504168,0.0736862525715523},
{-0.6156309132813266,-0.6531207946418903,0.18747131977994214},
{-0.6423402543967744,-0.633558951064455,0.2524304069626551},
{-0.5855250607118367,-0.6430524261532671,0.28269738436393077},
{-0.6002299573599246,-0.6105052101325605,0.34970340140964895},
{-0.6040776183429666,-0.5685147899705593,0.4293699632377584},
{-0.6449917246286396,-0.6184931347931673,0.29723084419099866},
{-0.647491093019299,-0.5801402688335593,0.37091129626860664},
{0.3210276928470887,-0.9707455310416656,0.2528609325131864},
{-0.47974209714925065,-0.9905058804118608,0.22338668928429636}
};


// normal array: 29kb.
const tgx::fVec3 bunny_norm_array[2503] PROGMEM = {
{-0.9008042721233714,-0.02517856663031564,-0.4334947555700364},
{-0.8626268876152444,-0.12577004539118258,-0.48995586377298944},
{-0.8653099068122371,0.09372404784778356,-0.49239675875012007},
{-0.9116439184177995,0.26945566073710614,-0.310320822550744},
{-0.8469094275438009,0.3651928084886631,-0.38649532230752015},
{-0.7395739858541431,0.39604916711223503,-0.5442199708550951},
{-0.7943962191630721,0.22819568065874413,-0.5629044131183454},
{-0.8085013458185735,0.14365728036575923,-0.570690949295211},
{-0.79611705227957,0.05929782321577989,-0.6022303606026173},
{-0.8194324992538854,-0.032380414884932075,-0.5722603322775489},
{-0.9510870067924821,-0.02053917291046358,-0.3082395949365871},
{-0.9278827317073023,-0.15036965616699235,-0.34120756542552644},
{-0.9857534835326931,-0.13296973968180376,-0.10300057296983345},
{-0.9483278215120294,0.27070637091926925,-0.1655065064883169},
{-0.8706508388273211,0.40102167716171766,-0.28486616383081564},
{-0.7797934968852666,0.2631972305351357,-0.5680222883427042},
{-0.6454800997353468,0.270826915887787,-0.7141485997160228},
{-0.5861152837711029,0.16934910453497473,-0.7923318464653064},
{-0.7880119294767617,0.15464169598838814,-0.5959220963046648},
{-0.762349606564294,0.4067957310792946,-0.5033292267958701},
{-0.6802140004207166,0.47185879305041606,-0.560944019535506},
{-0.700908202051677,0.5387585284637868,-0.46740447184876244},
{-0.8459346068411018,0.3572285466114342,-0.39595758161004185},
{-0.9747491501648393,0.19150756593682502,-0.11484313841878459},
{-0.9884174372848755,0.06045788307596366,0.1391970331766175},
{-0.9981540261583133,-0.00021400343599570305,-0.06073297511631326},
{-0.9767828176798434,-0.17545240423305902,0.12292998386994496},
{-0.9881769834812256,-0.07184230743258396,0.13544346488741255},
{-0.9563797508262196,0.26777480998138353,0.11676653351458262},
{-0.9276378282790768,0.36409692257178766,-0.08319549578812349},
{-0.9296182904117324,0.30824505427276977,-0.20197727755454362},
{-0.8754492348319247,0.2682050373753234,-0.40206304873576565},
{-0.7926242563393389,0.22581405006707173,-0.5663521899443985},
{-0.7509927540410466,0.18864096674900405,-0.6327910152979778},
{-0.47311135140373833,0.1479581754426962,-0.8684895091436607},
{-0.5079587523088365,0.20380651165822977,-0.8369234204863393},
{-0.41231383001065425,0.13660392547576525,-0.9007422900733355},
{-0.357652418094464,0.07239129906627852,-0.9310447076540843},
{-0.5971204266606005,0.09827418472426867,-0.7961089000139634},
{-0.839034134702913,-0.03750785539031145,-0.5427843785402758},
{-0.8787518551715114,0.19090013746061635,-0.4374383551429215},
{-0.8367493817259452,0.5460222577857484,-0.041354155580815},
{-0.47477892448457,0.8418581855740574,-0.25663158076750975},
{-0.48595845914908453,0.8097687610949631,-0.3288144302432243},
{-0.4190267309372544,0.8903944275520936,-0.17780428044402466},
{-0.7252571252993338,0.678868157853453,-0.11463039062659365},
{-0.8921680277964712,0.4167093544824284,0.1743259133479383},
{-0.8511405311467372,0.3991864701253001,0.34089581738142954},
{-0.9563505702908967,0.1648038894437262,0.24131569515573767},
{-0.9764699606427911,-0.13428512021739653,0.16874217744969752},
{-0.9245977035597638,-0.2670085134440041,-0.27170855768715524},
{-0.9573286396524859,0.24772511716336398,-0.14884267542448473},
{-0.9746888498195716,-0.21274911442320452,-0.06869832857896016},
{-0.6909225853287667,-0.7205251673922544,-0.058902158169092736},
{-0.7112427123181906,-0.6823103579133253,0.16907507107333652},
{-0.9747524001840239,-0.10797637056528396,0.19544529090012097},
{-0.9504301281118203,0.3105635573663646,-0.015259371327082256},
{-0.984344368043655,0.16520226449077446,-0.06143595777602643},
{-0.9713918638950132,0.14740671080920484,-0.18619642415197873},
{-0.9251272025423991,0.22941276184061396,-0.3025052789964774},
{-0.861339005943038,-0.0988817226823444,-0.49831468146185587},
{-0.7352691037141273,-0.5200780979748323,-0.4346241101576218},
{-0.7918105030394654,-0.5648113520404802,-0.2324312024720289},
{-0.679472850350172,-0.730683517385412,0.06646986579116125},
{-0.8253302413662529,-0.5629564424068519,0.043703965940673765},
{-0.7558280619276875,-0.6332039162136113,0.16666355718747197},
{-0.6399007180759003,-0.7466568408559702,0.18174331627030918},
{-0.7343445035632504,-0.6103470676976129,0.29700943931021595},
{-0.8954674892490746,-0.07049984930054952,0.43950852886668573},
{-0.8896480409305434,0.2921338496549104,0.35097603501414243},
{-0.9398944757954177,0.3063500441945689,0.15082448339458218},
{-0.9807785162306792,0.13333574992543396,0.1424608012478143},
{-0.9992441366001288,0.010437074541570763,-0.037446267441186044},
{-0.9735031590939226,-0.04172003535180457,-0.224835579667447},
{-0.9474001237942662,0.09668444136687797,-0.3050985483940947},
{-0.9127795346231847,0.20466407071544077,-0.3534772118981186},
{-0.8958040342447915,0.23673861592517573,-0.3761515119743487},
{-0.8444646634915116,0.3038793561812122,-0.4410632256276417},
{-0.7551103926729583,0.2833110263497775,-0.5912217496218543},
{-0.7081295124721392,-0.1430727198867163,-0.6914353117900385},
{-0.6680973230693551,-0.4307795248798619,-0.6066918227995515},
{-0.8455999041174542,-0.2954883531091533,-0.4445755676298379},
{-0.9267463178186456,-0.2967998272457841,-0.23032829821030393},
{-0.08810973988236563,0.9203146183320591,0.38112685161528337},
{-0.22324607005675062,0.877480067014674,0.4244878375126191},
{-0.1380698149431612,0.9578194650663827,0.25202896369566274},
{0.1671814115165264,0.9605171096681856,0.22238987764288357},
{0.2638671116762593,0.9641250233575694,-0.028932450836295857},
{0.02755868978105921,0.9952339102372508,-0.09354134129583053},
{-0.2883155476132504,0.940818629039986,0.1781416634473604},
{-0.3335787530921881,0.8728907548529898,0.3560715455882968},
{-0.3196595540401332,0.817917887355925,0.478359800834146},
{-0.31874800067470493,0.7127580710398348,0.6248004835413078},
{-0.20316653104469914,0.7745462740252596,0.5990003589788997},
{0.1170710477355848,0.8542589421780052,0.5064938592826252},
{0.3755668421818376,0.8581323487961644,0.35008344577134837},
{0.17743727517539146,0.9613453267742248,0.21054969975683008},
{0.2610624145637293,0.9652364141603977,0.01284836491281452},
{0.3462987442967257,0.9246926683000466,-0.15817916705638327},
{0.17652466375380363,0.9618518607988215,-0.2089977056439883},
{-0.13041105657411553,0.9544420076500985,-0.26839040660215885},
{-0.20878316200088332,0.9631924275443119,-0.16932199734886297},
{-0.2460759885962695,0.9691956481006623,0.010315209115948323},
{-0.26402011710029016,0.9593339597468837,0.09985855718321494},
{-0.30864177821464905,0.9091689123581177,0.2795570452377416},
{-0.2596856811946224,0.8655472696328105,0.428242070578863},
{-0.26020842347413087,0.7538895076790484,0.6032762108392384},
{-0.2556603513763954,0.6323597097278173,0.7312721670124256},
{-0.27018676018757215,0.5571899411291388,0.785199646028862},
{-0.27534309536722074,0.5699435471018393,0.7741773265541759},
{-0.25962608131183923,0.5699141541626491,0.779610258262249},
{-0.2769290871826657,0.6453235242978956,0.7119465075832023},
{-0.0813039245190703,0.6739032404396819,0.734332414089623},
{0.07419171976767419,0.7759819873002228,0.6263765194381984},
{0.18784659981108237,0.9002008354850181,0.39287671187217316},
{0.045289995943984966,0.9113330405551188,0.4091709978235946},
{0.5175154824918216,0.7986598069607187,0.3071160010919732},
{0.40474420952220186,0.9139565379958842,-0.029420596744898355},
{0.22385998668586232,0.9700302747128091,-0.09448794897550492},
{0.27378691648932835,0.9404748884430706,-0.20136461597624258},
{0.3437934836224311,0.8767423337353094,-0.3363464298236515},
{0.23634026439078049,0.8469688659139423,-0.47622160765776533},
{-0.04837306306815262,0.9288204121744017,-0.3673590732479314},
{-0.12054932265338829,0.8793086476739695,-0.4607430552201348},
{-0.21977114456077956,0.8768865067858068,-0.42751689818699584},
{-0.21912736303073083,0.9373646638071012,-0.27079639180941584},
{-0.2135405269779547,0.9663194351497786,-0.1436216995784069},
{-0.20368295123152513,0.9783413722646709,-0.03689735346738077},
{-0.17291984046361397,0.9824314564597331,0.07019374710361245},
{-0.20481678677801532,0.9514465269879667,0.22978161400874808},
{-0.11139418665795767,0.9217608193168254,0.3714139565918151},
{-0.14798742678073834,0.8330222893734146,0.5330793439272343},
{-0.06381510138999995,0.7677672509571258,0.6375430034062972},
{-0.10278839387063522,0.6798158324407781,0.72614391138971},
{-0.10480408858589606,0.5184632791593653,0.8486530098803619},
{-0.19428805716992062,0.5058623745557276,0.8404495278420819},
{-0.21268747120353437,0.4614187001337746,0.8613111068364924},
{-0.2227879802011635,0.440021886106314,0.8699116366765811},
{-0.13983876002792076,0.40352396443996164,0.9042198467831317},
{-0.17698181144956784,0.5327454832850581,0.8275624982171434},
{0.33564758599050637,0.853736664699532,0.39808843912686614},
{0.5257569274665831,0.7049980165395513,0.47598051419800425},
{0.14646193108175884,0.8712043833845726,0.46856357638564766},
{-0.19196412151883002,0.8928335183204937,0.4074286251761804},
{-0.5104053433986386,0.7957298025642788,0.3260375235170512},
{-0.2215719085326716,0.930939227873279,0.2902723606475345},
{0.20414312678165872,0.918142057910089,0.3396185290652359},
{0.3421543251450536,0.9139982529064584,0.2180312167293359},
{0.6410855963294955,0.6561309154149917,0.39812244349639475},
{0.7557803586840012,0.5446786721740537,0.363484791299708},
{0.5597270245832014,0.733810630502339,0.3850033980538303},
{0.4922451901201808,0.8256684471222919,0.27561982553911135},
{0.2572449777658563,0.9184692022420203,0.30039864504879327},
{-0.12937083780030972,0.9185051477723816,0.37364619607655775},
{-0.514676763518981,0.8021068915266054,0.30287351098957704},
{-0.8236841326590703,0.4956941158587887,0.2753757307909481},
{-0.5853648068016278,0.7100980273596923,0.3912912399964591},
{-0.8921369161467555,0.41582428289962314,0.17658394207620084},
{-0.9740136066875866,-0.005585089490276337,-0.22642062795342835},
{-0.9163454698584182,0.14707340891110696,-0.37239816361150474},
{-0.7057055096609632,0.6192442617645861,-0.34426193211825346},
{-0.4197568738570496,0.8262065932028263,-0.3757483628679392},
{-0.07742597461000268,0.9215175997283196,-0.38053979009644656},
{0.17606693950737082,0.7563355145024715,-0.6300452541800386},
{0.659194298075521,0.7473356807008876,0.0833801999041865},
{0.8759250683367241,0.42226029989936786,0.2333484814353872},
{0.9185380082501705,0.2920079965368682,0.26649438522853325},
{0.9225012498631521,0.3410507470146646,0.18076457606970883},
{0.8557961181180722,0.486296841336682,0.17643238455568333},
{0.6556203235828557,0.6984697172287859,0.28688333067547106},
{0.6929989684868475,0.6871698425801746,0.21805970999820995},
{0.5196793177412848,0.819041261289505,0.24311482681492208},
{0.25505254945513023,0.9000246979398459,0.3534172323398048},
{0.3012585607280342,0.8599201448123451,0.41204444436733834},
{-0.15079700860797382,0.8930016603711044,0.4240380841025219},
{-0.5148597189089584,0.782178322651413,0.3508796680048736},
{-0.7370407412072094,0.6030003328758561,0.30522376112015603},
{-0.9219486467208223,0.3212121030000577,0.21641043804753157},
{-0.9951909286247578,0.057222743386374994,0.07950203281884936},
{-0.8971079393826653,-0.39393999933655793,-0.2000215538868276},
{-0.9902333061620886,-0.1360250256891241,-0.030580905048289714},
{-0.20728333012730182,0.7159685943365248,0.6666502778632262},
{-0.538795236272774,0.7583538900379662,0.36687746024258544},
{-0.6115360926971731,0.5107630887018181,0.6042720203256586},
{-0.5318595671327541,0.37404454145090804,0.7597473802917253},
{-0.7702295846502816,0.20835096966589828,0.6027738053106944},
{-0.8797208361379067,0.2810529346414875,0.38353682795036786},
{-0.7831314688362863,0.5202665843413196,0.3406285128055744},
{-0.6847984113314205,0.7282889616595465,-0.025422906262310446},
{-0.44802103877294064,0.8907009697896464,-0.07699955345713705},
{-0.30647501261398247,0.9480817870562716,0.08493522058278175},
{-0.17356089294690805,0.9354022019912204,0.3080573598365214},
{-0.060153487294351514,0.9024243124317961,0.4266285483864486},
{0.08984804666459809,0.7279445819788033,0.6797234835418454},
{0.07507828588022804,0.6721294640720626,0.7366174275127413},
{0.1322992321004817,0.33350910596458944,0.9334176929029807},
{-0.24086012156978218,0.3463056770916835,0.9066745721875409},
{-0.524413315011305,0.0479152165817156,0.8501145846641976},
{-0.6550436754497364,-0.3234781854007661,0.6828467227885977},
{-0.855884775420186,-0.3241460043749778,0.40297719420790373},
{-0.9105211537479686,-0.39342789334149375,0.1271444899252124},
{-0.9894053584073399,0.13651249880817032,0.04941026638253074},
{-0.9178410015208538,0.3784711340593871,0.11969752132353294},
{-0.8524539358291664,0.5077425136486048,-0.12457859817464635},
{-0.6178055199417334,0.7028022054637875,-0.3526831432387445},
{-0.4839440239762649,0.8466960368401016,-0.22114249446211307},
{-0.459892577554662,0.8748922201854763,0.15186316264669703},
{-0.42153920408661133,0.6754635673854376,0.605023692555064},
{-0.17472286804330772,0.5996447070082792,0.7809597587197922},
{0.1909887645553321,0.47536536986655725,0.85880792785422},
{0.25352413405489865,0.47781144539877984,0.8410836677154315},
{0.19251327482826347,0.07565589398596587,0.9783735609265419},
{-0.14292107746201044,-0.08215776907015863,0.9863182379934544},
{-0.3808246591132537,-0.5888776677139125,0.7128784408853287},
{-0.26185825585014044,-0.9262997417272627,0.2709225762448171},
{-0.43022413305174684,-0.8735724226892584,0.22754871490890172},
{-0.3826500429242359,-0.9213447735529798,0.06857662062750587},
{-0.7173002309869958,-0.6798830191670023,-0.15244493718836324},
{-0.9682457186648957,0.1377022354814002,-0.20865838739558146},
{-0.09171097768051473,0.9771427259604987,0.19178422686803498},
{-0.08823096056167982,0.9933080720904544,0.07452765606342301},
{-0.14228104757903448,0.9890111351648986,-0.04016314255198791},
{-0.03744635595289632,0.9992774988073173,-0.006500061787475994},
{0.06167975655271498,0.9931002820992537,0.09973684036493524},
{0.01352023857876124,0.9792342796138199,0.20228056945237333},
{0.006592088164013863,0.9388535564306643,0.34425360412221},
{0.6680023013040716,0.616730280372348,0.4164332920460486},
{0.7690182643678947,0.6171256444566593,0.16663387417492298},
{0.5534654486511084,0.8044860946556616,0.21558784904328263},
{0.23481253712177164,0.9476442749328368,0.21641025991725715},
{0.3449290737283601,0.934318578249926,0.08984836355734153},
{0.48830784037179653,0.8586898213055404,0.15558677263087392},
{0.7516603970983902,0.6247919543892645,0.2112857334614282},
{0.9275175481462989,0.25419709801718143,0.27403472998932354},
{0.9330239468169342,0.20823066626988354,0.29343875730883107},
{0.859309501614799,0.1521093991981852,0.48831333292271767},
{0.6344860685948182,0.3387892403778906,0.6947296447995174},
{0.3499393760436964,0.7765749028823322,0.5239025227152896},
{0.146065601927139,0.9359040790703451,0.32054390450163234},
{0.03921631914752745,0.9806899809831577,0.19159655923782437},
{0.16175075273056883,0.9810036950620875,0.10709082250886492},
{0.09680659947503528,0.9951024414566908,0.01999033028775327},
{0.084842162877943,0.9786504137431372,0.1872035658810458},
{0.2660073700630265,0.8100474885739904,0.5225544424527676},
{0.5576536514614541,0.6237589809832489,0.5476742997936328},
{0.6154216258676158,0.33736056575608936,0.7123510869558574},
{0.8072042814637609,-0.05395835573418222,0.5878007688265107},
{0.947955241982605,0.0769086422541168,0.308975597651868},
{0.9720105888963478,0.06494477653407414,0.2257821761661322},
{0.9581695922885098,0.12024432926638198,0.2597158710840537},
{0.9010398287302858,0.08673513864729243,0.4249755790225271},
{0.7782045739135307,-0.007996139473487346,0.6279599532562413},
{0.790320195150317,-0.010254171203179714,0.6126082280793336},
{0.5913696458000939,-0.025056535806910463,0.8060112356782805},
{0.5476680234950719,0.2497999402195324,0.7985359891121498},
{0.27955792058061807,0.6065111839907757,0.7443060880677708},
{0.13187181797598468,0.8229433450414274,0.5526066181975519},
{-6.100203358344366e-05,0.9517207268687526,0.30696523309190077},
{-0.08826185822947244,0.9903468503621179,0.10687825017146042},
{0.005219099724845947,0.998493078878297,0.05462904383385407},
{0.019227097089452277,0.9986010425515518,-0.049257248730178955},
{-0.02465972648948653,0.99911343444674,-0.03412100522410805},
{-0.38796105336774983,0.915059712255961,0.11023585657953495},
{-0.3807624917840278,0.8252192404845763,0.4171727819315126},
{-0.2060033174641719,0.6997092680730396,0.6840830164288884},
{0.19068428707163695,0.5189486672964866,0.8332657339499699},
{0.37544390110464554,0.3020149425512935,0.8762584388176037},
{0.5526438782878296,0.052798421439994164,0.8317433922096594},
{0.6178160799467969,-0.2903061342923206,0.7307705794238177},
{0.8276190083864811,-0.3830153341345418,0.4102999278274165},
{0.9921585389636918,-0.0343041250426574,0.1201859416341618},
{0.9051555653055374,0.3435188711365401,0.25037609264762073},
{0.9227454960047523,0.27079642798858483,0.2742444971035282},
{-0.8143807620852834,-0.5638461443223642,0.1373371758781887},
{-0.9428285896627631,-0.3271351440369623,-0.06369339094789257},
{-0.8495070738853719,-0.5273439442165404,-0.015687444561032805},
{-0.8007554875592949,-0.5824836288351322,0.1396548290705758},
{-0.8344873275791163,-0.5500477396676436,0.032838760579246916},
{-0.7641071339484098,-0.6341565601401146,-0.11826134229072546},
{-0.8680481511841387,-0.4410591578621778,-0.22794566565676402},
{-0.9128893877088532,-0.3724559101223471,-0.16706154800997472},
{-0.9437807588926393,-0.33040236785519933,0.010590300265400785},
{-0.9943787657147847,-0.05307332182906194,0.09161928184378143},
{-0.8687575773393932,-0.49508101684162203,-0.012452251943078623},
{-0.9238903338200131,-0.34081266535678767,0.17399246594708354},
{-0.8652573383776648,-0.43792383649314426,0.24403371040642144},
{-0.7952424753990943,-0.5621051795627592,0.22721613593633497},
{-0.7176055214403361,-0.6559865017121528,0.23393166773610424},
{-0.7943235719669062,-0.5887467654047154,0.1497575014589258},
{-0.7028851588383418,-0.711094312523371,-0.017243322815319897},
{-0.6980341691052131,-0.68661992106015,-0.20322741637128605},
{-0.683506390194271,-0.6838113961694737,-0.255384003086239},
{-0.8230425895825614,-0.4876056057059395,-0.2912759327808859},
{-0.8644634191570105,-0.3944940562654026,-0.31157252207253466},
{-0.8591760723073892,-0.3746533166925275,-0.3484987361034996},
{-0.9535823652868899,-0.12833422117670326,-0.272416960354581},
{-0.9287163833975016,-0.3636618911520746,-0.07235957526659031},
{-0.915716796710373,-0.39814782475358385,0.0542315209678197},
{-0.8402502844392735,-0.5335640707063213,0.09637863845800926},
{-0.8943272161428476,-0.3720874986155456,0.24845467160069798},
{0.03405980907765641,-0.9180188071834567,-0.3950713847686984},
{0.6089800213600567,-0.7638655874972273,-0.21366491949269698},
{0.35032970473019887,-0.9024218467807928,-0.2508065159368769},
{-0.5212954490150252,-0.80045197350814,-0.2958507950693172},
{-0.29932977454037674,-0.9350077904229974,-0.19016339795531487},
{0.06360213821732288,-0.9737104254216092,-0.21872991436804712},
{0.5276819076704146,-0.8144430959021651,-0.24131773215950977},
{0.7290038191134571,-0.6331127906101601,-0.26023379120285167},
{0.8355227992039452,-0.5187950519293356,-0.18097885540593292},
{0.7950963668295368,-0.559881975033479,-0.23313931776318095},
{0.4344461153101734,-0.797415743800393,-0.41878957058547356},
{0.08700931917843098,-0.8106452904740834,-0.5790367789772036},
{-0.7221855219348441,-0.46905557635814404,-0.5083649655464332},
{-0.630433702407867,-0.6203014982573128,-0.46666840275300603},
{-0.9569587084100258,-0.13019481739184577,-0.2593826129919256},
{-0.904954740477212,-0.39858069454876127,-0.14896424947231124},
{-0.6384652431337725,-0.7550185734607084,-0.1493622677903945},
{-0.27244421452182843,-0.9432230530799965,-0.19001163678057686},
{-0.4348396021936976,-0.8738593159192415,-0.2174498018973166},
{0.17579188561014128,-0.9540045137046048,-0.24284274908852344},
{0.7324418867611666,-0.6555019573745849,-0.18397300453009469},
{0.8456154822714956,-0.48738588891170936,-0.21769118363518705},
{0.9691547329913685,-0.2032548315162985,-0.13937925593756872},
{0.9574794604858131,-0.2683252943558749,-0.1059934863877457},
{0.933133911723383,-0.34844154274691896,-0.08859793496444991},
{0.7373717674902471,-0.607726346876735,-0.294875505629354},
{-0.9910589656746723,-0.09296190459820697,0.09570899043100718},
{-0.9890133698570324,-0.1288529567168584,-0.07245322483754711},
{-0.9485707372901568,-0.1893719385337402,0.2536766155024575},
{0.6666045370824107,0.6010496157755058,0.4408829215531739},
{0.831658623349062,0.29149238284262735,0.4726268347796917},
{0.7551126917884705,0.5898495066280735,0.28615097803535283},
{0.3065674224563628,0.802478664460879,0.51190273350857},
{0.5610069261162033,0.7968306207850031,0.22434836890210588},
{0.7172649025634471,0.6954743283018164,-0.0429711324470981},
{0.9056105061706079,0.39524696668463094,0.15378376520300727},
{0.9517714478910961,0.14173119387098426,0.27210913189967},
{0.9180364067628587,0.009674099126740167,0.39637806153220045},
{0.7576039965591649,0.13217826749420752,0.6391909652050869},
{0.6314997712692882,0.4477146365109436,0.6330557978098852},
{0.33543678987227166,0.6463360099068253,0.6853699163939936},
{0.05139383538508572,0.6349783213044016,0.7708185293296049},
{-0.04455847972323277,0.7919512995673208,0.6089562225631544},
{-0.09189437090600693,0.9078983038881063,0.40899400288132465},
{0.20734564029616745,0.9334508863690323,0.2927067272664575},
{0.28571852195868574,0.9575331545140834,0.03866761197762973},
{0.37229969665265816,0.914895541633303,-0.15607396891167935},
{0.6259827283870764,0.7218744441256693,-0.29503035552181356},
{0.8257964006919697,0.3972106988169211,-0.40035479933374246},
{0.9176294730022575,0.3708729119301332,-0.1428615885186176},
{0.9912994509319771,0.1299205977438379,0.02111958484072225},
{0.9870860122835676,-0.09488450045335588,0.12906640123533938},
{0.925027379175429,-0.20246249058163035,0.3214549543611363},
{0.8364371418309643,-0.06430324094447015,0.5442775036410055},
{0.6795097897900565,-0.17408178895661258,0.7127145125035261},
{0.5759842646994009,0.07962414251316095,0.8135736738290726},
{0.530631440591728,0.3236219279932416,0.7833895084678404},
{0.3045509472015532,0.399954123471568,0.864456719377394},
{0.12729682767750009,0.35127856256526363,0.9275768912307631},
{-0.13895358855229983,0.4956912341816978,0.8573109707590726},
{-0.06589069947447515,0.6285452116437097,0.7749769884599984},
{0.2993351477169749,0.714368831194677,0.6325153297421399},
{0.21693240963986588,0.9396927648333743,0.26441981273658394},
{-0.13519822488125394,0.9864279369301214,0.0931738441449224},
{0.06415197425478159,0.996978681673515,-0.04379534778665479},
{0.05798590880675983,0.9670551565489182,-0.24787488491576037},
{0.18177317018436864,0.8956824759463771,-0.40584654351576316},
{0.5009693622388639,0.6917745471812041,-0.5200746811470693},
{0.5383980392224705,0.4783356921391041,-0.6937741109231473},
{0.7797968284572135,0.1597068561758634,-0.6053186156219658},
{0.9283248000454959,0.08288914290257053,-0.36241199705496424},
{0.9433756395658279,0.2117109586451408,-0.25538377525465583},
{0.9905295028797669,-0.07001044913989636,-0.11810944473661586},
{0.9561540688483419,-0.2928587776818893,0.0017700167881038599},
{0.9214957791327091,-0.32093988870507506,0.21873069487059993},
{0.7598375578323779,-0.414665127540881,0.5006992287879347},
{0.8008011697329557,-0.25434931199281907,0.5422397200898413},
{0.6264319943566661,-0.383104500642608,0.6788327467305241},
{0.4818413585475458,-0.09589205653029438,0.8709957627264591},
{0.25455854320491167,0.06610392010164513,0.9647954290048167},
{-0.6122551937469941,0.7530115259463616,-0.24107513252461957},
{-0.4297129222472547,0.8487125472575126,0.30827555300638},
{-0.5042747024167703,0.8619032568631652,0.05319586742545503},
{-0.6403912067801106,0.6769844185771933,-0.36275501275986954},
{-0.588145949708356,0.7990685386215206,-0.12479508174172321},
{-0.2546833263142178,0.8004288825918193,0.5426324789490002},
{0.29771667579502403,0.5456559010197809,0.7833418274520082},
{-0.22272847682478938,0.7960610007632292,0.5627423110759978},
{-0.11496453994894491,0.708374488669697,0.6964113284232765},
{-0.480739754944862,0.8018016054800248,0.3549696796420911},
{-0.5833790511906676,0.810444077144152,0.05337865166749965},
{-0.681001232479293,0.5266666868751075,-0.5087823918903652},
{-0.6179534290408418,0.4222338590432719,-0.6632134858505907},
{-0.6654409533848369,0.5940253485767519,-0.45202015752236935},
{0.008820171441014314,0.9322361202266986,0.36174303133636665},
{-0.12412372835671846,0.8507054066854774,0.5107774575046594},
{0.3189245863593569,0.47911989467710037,0.8177598881946444},
{0.7197619431485663,-0.08374462229153869,0.6891513501635527},
{0.33818146947934447,0.40199650157315037,0.8509007617952515},
{0.510041537331858,0.142709627145616,0.8482285025369722},
{0.6232622724799376,0.03567675974288648,0.7811986357626287},
{0.28159637004596966,0.4839970735443901,0.8285229732345383},
{-0.2407070716324551,0.7268533735808861,0.6432295694230894},
{-0.6061789820577844,0.7743415253605991,0.18149998295759942},
{-0.6849191623837839,0.709976009748476,-0.16376753823981047},
{-0.6955177246692928,0.38583259899305405,-0.6061256472259816},
{-0.6150208568498485,0.16889225603611338,-0.7702108487230689},
{-0.5848671026049165,0.23987914351260967,-0.7748473841978089},
{-0.4940407451969387,0.10574844379605589,-0.8629837824200208},
{-0.6245071606835604,0.3375388702663339,-0.7043140757604414},
{-0.6538111082723008,0.17636953603644032,-0.7358157523850902},
{-0.5577062833418407,0.62805270656902,-0.5426909795568368},
{-0.3689445256376442,0.8964358555423866,-0.2455253426838115},
{0.4623990383144842,0.868642493204056,0.1778970161809402},
{0.7560845804742075,0.2865450417290534,0.588411459974767},
{0.608552102800011,0.2838591118007088,0.7410049546564432},
{0.7104481571219955,0.033723387200361825,0.7029410709282075},
{0.740995707933281,-0.179663626421862,0.647028857289535},
{0.7613417180213083,-0.2740966189649572,0.5875626195328814},
{0.7602857176316125,0.5428082239787269,0.35682609145975375},
{0.8547472798545189,0.4292806740182758,0.2917622156752232},
{0.8000556743799724,0.5377445188800962,0.26597321351373227},
{0.5890848595035552,0.710674339372771,0.3846050073266758},
{0.6061140588683347,0.7274282730636901,0.3216735226743577},
{0.8110594958219404,0.5487736338784154,0.20255861620019736},
{0.9556317403604497,0.27424064732929976,0.10751764584506332},
{0.9529254784080142,0.2491880475717776,0.1727378057873339},
{0.9571912523359991,0.24564511780670137,0.15311232004372952},
{0.8440535062721156,0.49924181833153014,0.1957837720005802},
{0.6359668278891004,0.6895896683520988,0.3464278902264042},
{0.3044003807981648,0.7546517771889534,0.5812410028168064},
{0.47224620791823,0.8199465698097832,0.3235291976994073},
{-0.7137959845920716,-0.5221322018408684,-0.46676895374589944},
{-0.24580219122250663,-0.7570310679658424,-0.6053802482115769},
{-0.35487627249612524,0.24433600718927484,-0.9024204933455682},
{-0.6544548743590503,0.4503729241779457,-0.6073327313714337},
{-0.5789437725471622,0.3677529372273858,-0.7277237699769674},
{-0.24000541514545054,0.23902838495937775,-0.9408840693117146},
{-0.34715125433435057,0.21686703299808419,-0.9123895531036592},
{-0.2578570792526607,-0.5372296657561019,-0.803052932820044},
{-0.02786392249609383,-0.9972250153151059,-0.06903528556411173},
{0.0098270998820993,-0.9999491634279528,-0.002258022950420293},
{-0.05090568514888506,-0.9962594088367773,-0.06982693981349668},
{-0.8896564543672256,-0.2983828416926284,-0.34565745035536044},
{-0.92173349873016,0.2652708848757251,-0.282911143216219},
{-0.9144130006310178,0.29048040056856644,-0.2819042411218808},
{-0.8091302715839481,0.5066825728153332,-0.29762556007796237},
{-0.5113249540290904,0.5551814939531395,-0.6559880335487139},
{-0.3150758252109453,0.34751711610438357,-0.8831529190248618},
{-0.27271911297293094,0.3255172964391824,-0.9053522933853888},
{-0.3648882616480893,0.42021966607802025,-0.8308260881512524},
{-0.46965977249346663,0.13468108915354893,-0.8725140126816296},
{-0.28825547982870886,-0.6821700679110407,-0.6719767680470559},
{-0.3642167022023261,-0.5833749385336159,-0.7259613453399306},
{-0.003510019833272171,-0.9999746503297263,-0.006195035004877806},
{0.061130069828557905,-0.9977894621698354,-0.026063456132796294},
{0.166667284627292,-0.9803160835155279,0.10584135598026742},
{-0.0169072513283788,-0.9295158173674073,0.3683944762293807},
{-0.04535196369953521,-0.9972131901273822,0.05923725875296393},
{0.02780211387951272,-0.999455093841913,-0.017792072877645143},
{0.03857509510232733,-0.9992094634325648,0.009613023699771163},
{-0.38066153659724844,-0.9086688292120795,-0.17151604407101528},
{-0.5734029807731572,-0.5656206960199269,-0.5926906865089004},
{-0.8601708864232164,0.17090536824753577,-0.4805178469672822},
{-0.8608821859455046,0.36162079904247313,-0.3579277296069318},
{-0.8263469101461018,0.5039690217239932,-0.25132848870462654},
{0.10928928731789994,0.8701622116440816,0.48049305624975086},
{-0.15714394682153923,0.8799010995633774,0.4484192624815627},
{-0.455011520769783,0.7845588648202303,0.4212266653462965},
{-0.7109617917857172,0.6173304241165709,0.3368033225502639},
{-0.7105517918427872,0.6120960494380849,0.3470656672321448},
{-0.9780950255404656,0.11966385953129856,0.17032522342586176},
{-0.957627125502439,-0.27546492621307406,-0.08407950361628855},
{-0.7140251064275586,-0.6221322909741065,-0.3211223441593924},
{-0.6420904741764658,-0.6562207266845115,-0.3963510828060054},
{-0.9379838466512187,-0.2718060693167994,-0.2151923885827151},
{-0.5636815167814618,-0.6514842203447542,-0.5077710687708963},
{-0.5253644193207271,-0.6074922987310866,-0.5957728878475552},
{-0.6601050587049584,-0.1922728426218233,-0.7261490655934544},
{-0.4913604525716012,0.3001266061230256,-0.8176117207731953},
{-0.44359371408343223,0.06943105088474798,-0.8935345242343496},
{0.5587561183709241,0.5787159442028783,-0.5940365780896231},
{0.9230280605269557,0.2817849558409451,-0.2619473957525886},
{0.9777138736504543,0.14594341435131067,0.15091753072093805},
{0.992159089126349,0.04748858377397925,0.11560785559431205},
{0.9923268776015453,0.12189319600822925,0.02072237333094754},
{0.8741295221498445,0.47200900151720376,0.11447742569090591},
{-0.16660476509148256,0.19608543132335934,-0.9663298380323067},
{-0.15476123481464016,0.20343893774030028,-0.966778960678058},
{-0.4261335456501817,0.3996733254875463,-0.8115857528107122},
{-0.5752777221474965,0.2762557874232705,-0.7698949813552083},
{-0.7801540119718645,0.4476501710440307,-0.4370000480188234},
{-0.5028067472674038,0.7602692986161315,-0.41131006367959044},
{-0.25035332878073535,0.6230307042619209,-0.741050573385717},
{-0.06815046065847867,0.2939036117612002,-0.9534024237989741},
{-0.036775331891494505,0.19562576549127722,-0.9799888442427405},
{-0.16355217945771447,0.3275003666138267,-0.9305880906515195},
{-0.2104013712253547,0.2702801844331808,-0.9395104495902408},
{-0.08523876107434014,0.23340808403901356,-0.9686356486913685},
{-0.09152706423965594,0.12634984960926315,-0.9877542771435548},
{-0.2920084387453123,-0.08081505871666507,-0.9529952770009656},
{-0.7751642511197007,-0.0068362138718867215,-0.6317227635331272},
{-0.8909128784526915,0.1491768261730907,-0.42897612700482907},
{-0.8537481158296072,0.33665911528189674,-0.3972087547058928},
{-0.7776379214205306,0.29268275615076794,-0.5564315478302312},
{-0.6881329568899326,0.5687384122080732,-0.45056592427852116},
{-0.3956182175991893,0.7794872208474812,-0.4856808606884881},
{-0.2395165549213439,0.901484434961421,-0.36049637091224407},
{-0.11798687742578814,0.6888439609936681,-0.7152433810654006},
{0.03872822954518175,0.2746686279819881,-0.9607586944903429},
{-0.0023800428745046963,0.4194845566674817,-0.9077593525342506},
{-0.1712399475846434,0.5425000020137135,-0.822417550983884},
{-0.1398403993400676,0.41207396373228355,-0.9003553249280947},
{0.0024410668583999063,0.2364334756783755,-0.9716446123821384},
{0.019623133470041562,0.22101650328090686,-0.9750726321204477},
{-0.008972092144720818,0.1405694436690945,-0.9900301677570779},
{-0.12928055360593038,0.1169811203870859,-0.9846836831857865},
{-0.12085502390563402,-0.01175019677534856,-0.9926006226436236},
{-0.16425511488280412,-0.20777520513847839,-0.9642871571085554},
{-0.5129077578051813,-0.24314752198409334,-0.8232890832121221},
{-0.7827624859810656,-0.2606668210391185,-0.565097955181314},
{-0.9313473646495295,0.019044293729939387,-0.3636336085082126},
{-0.9248455181490354,-0.14664298487066604,-0.35093675006739306},
{-0.8468485603023046,0.10037743702421723,-0.5222756801253177},
{-0.6985169911436534,-0.029206375937486102,-0.7149972032730025},
{-0.55294127162863,0.2227579294484251,-0.8028915586787321},
{-0.5202914487594793,0.4939228685317367,-0.6966613296926583},
{-0.3357989511824644,0.4983728641103984,-0.7992894048485538},
{-0.21277894544740655,0.6994969704022265,-0.6822236501121874},
{-0.16822300954015218,0.8638217238865358,-0.4748821415919401},
{-0.09241217943849894,0.9033993056681344,-0.4187238751370159},
{0.00836205402474644,0.6341180968486084,-0.7731909953572831},
{-0.009949150225193989,0.3321070145831113,-0.9431892414963656},
{0.0005490099817493741,0.3907051035510327,-0.9205157362300858},
{-0.09082576065130459,0.576847533295443,-0.8117866742766073},
{-0.08652157834172047,0.5609102322222724,-0.8233430195669444},
{0.019257320839025812,0.41298288055343635,-0.9105351700861911},
{-0.020722174092772064,0.32362071882804316,-0.9459599472737149},
{-0.060397743762966555,0.3584193480419412,-0.9316048966689328},
{-0.10763954358871011,0.23716019767886085,-0.965488875799684},
{-0.1070304492152112,0.001404032128958371,-0.9942547518793013},
{-0.9259700566296658,0.3775782852125099,0.003754032662882241},
{-0.8658892444911447,0.47387098457370475,0.16025637663975284},
{-0.9106546943763268,0.3580789915621165,0.20612487334675672},
{-0.9831932242903282,0.15357044079342363,0.09872792626254215},
{-0.9867145336138381,0.15097814186804542,-0.060000248610305396},
{-0.9699862347930488,0.14987850853721557,-0.19147620476357974},
{-0.9330820036885363,0.06415061901546781,-0.35389641489073975},
{-0.8717241264968214,0.08969648250775025,-0.4817173323735515},
{-0.8629916166968294,0.04336798579941343,-0.503353441747143},
{-0.6683112419079564,-0.020356525182447186,-0.7436031843812542},
{-0.518952879559121,-0.17444933801561904,-0.8368126058223603},
{-0.4215900626594139,-0.003113052151198591,-0.9067811907914364},
{-0.3050735051896415,0.016846580111074434,-0.9521797882594795},
{-0.0990037193117364,0.061557069008234634,-0.9931812477174337},
{-0.2313022011602843,0.14481137808050482,-0.9620441551804327},
{-0.01123102775085937,-0.08328520579025223,-0.9964624621691149},
{-0.23078564719296868,-0.6070862245333206,-0.76038431140549},
{-0.5200752224721961,-0.015259270592008012,-0.8539841436651477},
{-0.7053253105894965,-0.42537442438962897,-0.5670738975803966},
{-0.9480412011880961,-0.19095686043928256,-0.25446681178692854},
{-0.9784527974386944,0.09567891377016334,-0.18296357190477805},
{-0.9143585713317022,0.34596691871225865,0.21036942313224605},
{-0.6232391665618267,0.7266396782687946,0.28908081781526496},
{-0.2582191425851942,0.9621959838653646,0.08661271867301083},
{-0.23640259367376182,0.9638628837888286,-0.12280942536548839},
{-0.13257554985969125,0.9814102783657427,-0.13877171576901334},
{-0.17771140663703364,0.9299725940508122,-0.321822358243628},
{-0.2677762888290659,0.8493841201040607,-0.4547993795685998},
{-0.2125336759899986,0.798222050333028,-0.5636230965213501},
{-0.02127181251939101,0.8287926573918957,-0.5591513579035822},
{-0.08292079282223021,0.9404483333400584,-0.3296681277218638},
{-0.038087830206626504,0.9685871124507419,-0.2457403564424965},
{0.00479105084895494,0.9937545470348315,-0.11148518322790492},
{-0.8106185193055313,0.2805317168557485,-0.5140034746933858},
{-0.7682967946377468,-0.16517111545393123,-0.6184161527394543},
{-0.7525042124379585,-0.5742430300979056,-0.32246294771198697},
{-0.9819748023512967,-0.04028444315465703,-0.18466903147753574},
{-0.6599774091599501,-0.7512604021239943,0.006134133925367231},
{-0.18549383150715065,-0.9822476984016598,-0.027955276021512505},
{-0.4306874042227729,-0.6991658899243458,-0.5706797860535691},
{-0.7450586912885754,0.3066233999208261,-0.5923424998734672},
{-0.5913330715689098,0.5468976153236098,-0.5926450850401337},
{-0.5460523046730597,0.6929724225283465,-0.4707611944249812},
{-0.735081859571685,0.5410724655582463,-0.4085281468189848},
{-0.8404706481224317,0.40886653123359645,-0.3555801587288951},
{-0.9770627961490855,0.20899373709635488,-0.040864535184316285},
{-0.9243780782680009,-0.34703841854397577,0.15839666812169367},
{-0.4244359670672734,-0.8628194259709245,0.27458468279726167},
{-0.13459036143504197,-0.9872676573087678,0.08478211745906258},
{-0.03564670059776321,-0.9992566393201796,0.014679288505710772},
{-0.026582431846423962,-0.9983682190482679,-0.050539821047566796},
{-0.9946694498203739,-0.0675077092239893,-0.07794481887440743},
{-0.9900474844635058,-0.09467062812790769,0.10413189077968162},
{-0.8997407852335683,-0.43010884824389256,-0.07397903790665464},
{-0.8983537726608293,-0.43635923262678455,-0.0505086056768441},
{-0.6509839433364882,-0.7375371267821271,-0.179607606008321},
{-0.6246618271330364,-0.7808880347747695,0.00338804787670391},
{-0.9357710526431451,-0.3039069142924724,0.17881030305988557},
{-0.9811208215121111,-0.1120043495389615,0.15766089965414437},
{-0.9642200183371544,0.058413091562877766,0.25858783221946896},
{-0.9656821108757884,0.21070329705947144,0.15186237632392657},
{-0.9606221463955708,0.2722619933656872,0.055484221386887425},
{-0.9842428942904666,0.1710596313898186,-0.044771950454550374},
{-0.9957623207714484,-0.08298036006501056,0.03964417202238225},
{-0.8945557511220326,-0.2960391837982213,0.33485938808786475},
{-0.7981145284133031,-0.5618022658405286,0.2176956904306075},
{-0.6979680425299707,-0.7146622827306638,0.04580865910586726},
{-0.4727989725920244,-0.8811411309389319,-0.007172090600812616},
{-0.3835647533017084,-0.9129494541788626,-0.1392888155564408},
{-0.48375196175844176,-0.87045432933334,-0.09106755755868438},
{-0.6084068258915014,-0.7705273753114432,0.19007550632389925},
{-0.17896645680857884,0.6261370913443363,-0.7588961392576966},
{-0.32011577547526715,0.8735494892886035,-0.36665676054791096},
{-0.33165712964522237,0.9054871162411168,-0.2647576829420414},
{-0.5675651640793934,0.771799541238768,-0.2866971445047165},
{-0.3936348203340279,0.8547768103345148,-0.3382428605823788},
{-0.6281276263507826,0.7517328659809641,-0.20088151537405724},
{-0.8418307779150532,0.39628666140567675,-0.3664393856381691},
{-0.5817525868150347,0.3913747767905012,-0.7130145242743663},
{-0.029481246523199407,0.16208535536332733,-0.9863362477776949},
{0.11508669141310653,-0.027863409504656444,-0.9929645934626069},
{-0.1484472850744657,0.14817227528346666,-0.9777568104551054},
{-0.6983178396295195,0.5779187293662266,-0.42232941775690547},
{-0.46364416508548467,0.7529946366630865,-0.4669402160221479},
{-0.28846576823591125,0.7376141924986206,-0.6105020913810807},
{-0.8115159418018559,0.30574490404756777,-0.49795775910250706},
{-0.9506305390953432,0.17334673944661674,-0.2573955828341344},
{-0.9418355383094661,-0.11710043992563268,-0.3150131834487908},
{-0.7763769434432278,-0.24152827104853253,-0.5821537047670979},
{-0.3084593900161075,-0.2756504976226692,-0.910422763265103},
{-0.03762937121554044,-0.1379453608375591,-0.9897247636819636},
{0.047823365506077666,-0.2815661519635584,-0.9583493245054783},
{-0.0816079821266572,-0.19031762250901296,-0.978324761935285},
{-0.3272832964241083,-0.07553376078221148,-0.9419024869188237},
{-0.32887450440046273,0.22117304682209385,-0.9181089498064933},
{-0.47149085628092585,0.16727585159884414,-0.865860936822629},
{-0.5775852835158771,0.35601173510263845,-0.7346093415789732},
{-0.3848117773361406,0.5899587910718803,-0.709836967803457},
{-0.2255370483221688,0.9732877856460455,-0.04294096117160282},
{-0.08551477955016494,0.9955957182025593,-0.03842379959369906},
{-0.2636500886147816,0.9630459764298612,0.05505522732377821},
{-0.4413673074607611,0.8921947929819646,-0.09582980371840115},
{-0.6095322219327745,0.7834618508508961,0.12107022213155225},
{-0.684701395930207,0.642737268476452,0.34361723199318017},
{-0.6341397968151349,0.6222973150628242,0.45892566910215377},
{-0.8117176969608328,0.4393530374529046,0.3848159156291592},
{-0.9176238526459177,0.2702180240271426,0.2914595761784634},
{-0.9959391085206973,0.07922823606894669,0.04275720674228012},
{-0.9930842425255402,-0.09586018174337385,0.067782835611986},
{-0.9742197211383657,-0.16275628991828753,0.15622523815670517},
{-0.9865915781920228,0.12055039223482114,0.11002118329033071},
{-0.943995759071186,0.31969040079286143,0.08167040159393711},
{-0.9944240878480836,-0.06637860662115927,-0.08194274885882419},
{-0.9512176879642107,-0.08719252968750822,-0.29594319196547586},
{-0.8951546637187614,0.012574234075192547,-0.44557829464637694},
{-0.8859395001760998,-0.05206602847278726,-0.4608691036582875},
{-0.7285304573426788,-0.24101276016822396,-0.6412146459339192},
{-0.5486391144316861,-0.3638163808835195,-0.7527501332556727},
{-0.4386223621190978,-0.17289108442013548,-0.881883833833625},
{-0.2629566630246116,-0.11093907674411685,-0.9584082191958309},
{-0.10376556163963792,-0.03680590862009458,-0.9939205367172266},
{0.13590218225134038,0.08554500310029073,-0.987022111861682},
{-0.024964744184502168,0.112433351572808,-0.9933456110548371},
{0.14508861721734181,0.0876511852395685,-0.9855285703012665},
{0.26725972132932063,-0.17859982814316389,-0.9469289005739587},
{0.2827319460996549,-0.7879209311026472,-0.5470313089623293},
{0.3169792344810252,-0.8975593063971583,-0.3064497616374913},
{0.022004351421309173,-0.9395880057250375,-0.3415994555267536},
{-0.5868898050426357,-0.7417757678774126,-0.3245443990071186},
{-0.34410239060489195,0.020631383162168483,-0.9387054334607924},
{-0.1600099796050551,0.06790441572100109,-0.9847770289524321},
{-0.39330557115437775,0.3426428230174924,-0.8531744390999604},
{-0.5981146243484061,0.31276060140822365,-0.737861573973961},
{-0.547576083627406,0.3655897352972912,-0.752664983963336},
{-0.46297443006749067,0.35542547176284534,-0.8119897851117592},
{-0.3820673918875335,0.4409083762818121,-0.8121725874349576},
{-0.32203547121870035,0.5602967792965721,-0.7631255954211194},
{-0.12561499079836538,0.44117947983870937,-0.8885840087779953},
{-0.05829118132073641,0.024201490463941357,-0.9980062254513029},
{-0.3849408442995248,-0.27797083081087165,-0.8800867932245562},
{-0.5640247887878255,-0.09134390919616668,-0.820690153398718},
{-0.6834451977262072,0.2858115191874778,-0.6717249714017869},
{-0.5776064440764062,0.26957627452146543,-0.7705189342102743},
{-0.41606420809530986,0.25617520668028265,-0.8725049216046504},
{-0.4455153745537618,0.34083587677136307,-0.8278568451983214},
{-0.3348890111035974,0.32899885261279416,-0.8829547583095747},
{-0.2335598453087409,0.5282791738260951,-0.8163154495420109},
{-0.20399061022887174,0.6707811597892962,-0.713050115076198},
{-0.09906480722827231,0.678347375015799,-0.7280322814120264},
{0.15644050310874963,0.3517616283225389,-0.922924767154375},
{0.10721305252117083,0.20322499507993413,-0.9732445544383249},
{-0.4828072676725195,0.7476486086814247,0.4559810305476819},
{-0.5046659702401765,0.8083631736750827,0.30308618894217115},
{-0.47447578884258856,0.651546576002538,0.5919119741157232},
{-0.6571200660294569,0.538245350617474,0.527716932985966},
{-0.7657287133858609,0.3908610625649916,0.5107711496032248},
{-0.8651997665013232,0.27870491074586157,0.4168368227162723},
{-0.9580009381150254,0.25492763612576974,0.13132441855975852},
{-0.9975215342291314,0.06265654104937281,-0.03201478740969789},
{0.2575209347376003,0.5832834421466715,0.7703657535803388},
{0.154303487767609,0.786652584768511,0.5978027639111182},
{0.09369295547888605,0.6441305688306579,0.7591557418550718},
{0.1571102277048862,0.36741487108636456,0.9166911632906193},
{0.03668386408199566,0.42378998229883375,0.9050173175244592},
{-0.08807829316371614,0.6388606330655465,0.7642638980041224},
{-0.04596200026649888,0.7746068576929868,0.6307707274014063},
{0.03103815142362544,0.8753034711701538,0.4825769021758955},
{-0.06476162427995359,0.8797180641225766,0.4710648147304661},
{-0.1392897160439449,0.696756588436929,0.7036537724436138},
{0.10590153299157776,0.6573537228266343,0.7461038455845126},
{0.24290258909328946,0.5956127048146914,0.765665617665508},
{0.22739842382692227,0.39195834885215614,0.8914362622230055},
{0.08673707814565695,0.21446161086366036,0.9728735255625564},
{0.018738487005280226,0.2056393444788021,0.9784484294571082},
{-0.0830735917684349,0.39031317717147873,0.9169266067014291},
{-0.23805114121749998,0.6670630110027762,0.7059451774160342},
{-0.18378517525541563,0.8208091811155003,0.5408283438881861},
{-0.08816985062660013,0.9130721647782544,0.39815235695351014},
{0.007691086685453668,0.9437036363874436,0.3307027273167134},
{-0.011231330278009759,0.6480800579910322,0.7614893930019818},
{0.05719254591186171,0.38868771008543246,0.9195927776579492},
{-0.1388022050888543,0.7182747605274201,0.68177365470642},
{-0.08862737628177038,0.5277951960556354,0.8447351177700634},
{0.23148871531084,0.462244412523924,0.8560041342038887},
{0.37496129692951496,0.46420098556559747,0.8024471763330369},
{0.2580732054123931,0.4058789048801904,0.8767328756362625},
{0.14051126058106794,0.18250653396133631,0.9731125067079031},
{0.003967127288136351,0.10773345670555307,0.9941718987214195},
{0.11707218461120208,0.09860768233766053,0.9882158815635153},
{0.05212756851773933,0.10843526281539945,0.9927358714071853},
{-0.02618570862847317,0.15140609729876248,0.9881247402855484},
{-0.06561608988249482,0.20679643488639413,0.9761812143586915},
{-0.2321925131910733,0.44054925511393705,0.8671810598926665},
{-0.418415133131502,0.519218610709474,0.7452119233207901},
{-0.47670453054686496,0.6790748783716096,0.5582204762642415},
{-0.30989242140698303,0.8187706081913895,0.4833025742911152},
{-0.10812972322936118,0.603427197215083,0.7900528973527602},
{-0.024201927702536555,0.7151374124772082,0.6985647772188951},
{-0.03903418380049958,0.13718516045234375,0.989776017211315},
{0.1534503770606563,0.12833282428587084,0.9797875626842557},
{0.1489651045372093,0.20551766276844916,0.9672496512898893},
{0.25813088981046717,0.1879675606964608,0.9476479514310568},
{0.040803863142427135,0.5353063235748727,0.8436718465691548},
{0.09109924849396632,0.6127893981358666,0.7849777579372023},
{-0.040162439681397905,0.6644562741861747,0.7462471695982941},
{0.12000063354650285,0.4032774897421254,0.9071753492107949},
{0.2362175130586588,0.24293164133557765,0.9408429752952321},
{0.5442151255002231,0.3475808282998351,0.7635558034454174},
{0.46264509935439374,0.2241043140955441,0.8577509944308598},
{0.29343621493012056,0.13827957252652937,0.9459249164650249},
{0.2773603026152229,-0.07968638536441569,0.9574556608641185},
{0.07791590341756933,0.02874870230572533,0.9965453447336758},
{0.06738711050991614,0.1011721686306701,0.9925840869325337},
{-0.04199330755460966,0.09192267323208222,0.9948802863995707},
{-0.1426483151952762,-0.04785444762513357,0.988615906211529},
{-0.0705291086415957,0.09317446460219199,0.9931486112260928},
{-0.15116229785184754,0.19410351875817292,0.9692645581645111},
{-0.41338421291402694,0.32637385278594977,0.8500550574704592},
{-0.626040624527072,0.46044375612654004,0.629336701524579},
{-0.5429622533516942,0.6441326048713184,0.5387811974975931},
{-0.36921946413201645,0.8010030236087021,0.47124425033710865},
{-0.16837463088770538,0.6427028594626657,0.7473841168448403},
{-0.06332702969941502,0.23414180715285407,0.9701377744695056},
{-0.13599195848291376,0.15564624153330855,0.9784070904917526},
{-0.17963761845907758,0.9699693373707317,0.1639811287768644},
{-0.3089111137851974,0.9248423222943578,0.2219022367466537},
{-0.3779225596013386,0.9201611451734892,0.10236213097325407},
{-0.36964891487031254,0.8617107819895021,0.3475833827130421},
{0.09326831277255897,0.9459245980458755,-0.3106890352817571},
{0.158426158830529,0.9771676515381749,-0.14157871656987123},
{0.13709270634278017,0.9903527744867942,-0.020173545397901397},
{0.25574650342686295,0.9660076787556215,0.037721221747305696},
{0.178687832461963,0.9629908755697344,0.2017900693777609},
{0.14502843903625243,0.9055117159387549,0.3987672054825466},
{0.03836258794574957,0.853036073647024,0.5204399762729353},
{-0.030366696116538236,0.8464804044490901,0.5315531851571116},
{0.03158743283320692,0.7026676284457374,0.7108167401105933},
{-0.024018397764665435,0.5785185807493896,0.8153155023035747},
{0.01837211170817101,0.34150407645132896,0.9397007136735117},
{-0.069216867236956,0.4067860967336483,0.9108974128814422},
{-0.1619660256142036,0.36272101531580875,0.9177148095105625},
{-0.16227279945867695,0.30977407099852805,0.9368604824053809},
{-0.04812867198866419,0.304182247094579,0.9513972837280439},
{-0.11652242345640913,0.33320793012443345,0.9356254593233534},
{-0.17392869877694772,0.15589231521425673,0.9723406778485082},
{0.02807741281150542,0.2263283276191888,0.9736463151508938},
{-0.034151022636179695,0.20435811940698664,0.9783002947384524},
{-0.20594175263606768,0.378831063490213,0.9022610597028218},
{-0.19416526716512333,0.4743343103152268,0.8586657155636729},
{-0.1309903222990853,0.4910319512365422,0.8612369931260593},
{-0.01196331020692505,0.5672317082371818,0.823471352494561},
{-0.0004580093941960355,0.654971434069535,0.7556534991517552},
{-0.10407084818740088,0.8018349444371418,0.5884131035565411},
{0.04538209471269477,0.8788632000505521,0.47491045585077535},
{0.30637761991945406,0.8090829186909905,0.5015152885954315},
{0.6971590464571925,0.5719985498835116,0.43218852700419746},
{0.864940151271602,0.38908681568546966,0.31700155295834054},
{0.8554546586342626,0.5042081762763236,0.11820085446831967},
{0.7443653144775332,0.6672433133483441,-0.026582689756432878},
{0.39352129521445917,0.8798221965462752,-0.2665593605132294},
{0.17109271339865126,0.9685983449688058,-0.1804010242364978},
{0.17926904601294974,0.9332108564594214,-0.31141629136556115},
{0.292005437486902,0.810339314394296,-0.5080187201521863},
{0.3501172362649382,0.6902862100898189,-0.633184703723989},
{0.2960974577987482,0.6718486528221533,-0.6789298072600557},
{0.0932973280737753,0.7260231166536388,-0.6813120009649257},
{-0.015229132173313177,0.8277611841216544,-0.560873867812331},
{-0.050326732515056684,0.7234969066295696,-0.6884907015289325},
{-0.0010680322366957721,0.7995781338755162,-0.6005611268932483},
{-0.10428655805578957,0.778531027279473,-0.6188810494529986},
{0.28684657995672336,0.5087193490150521,-0.811741130844577},
{0.2910685351248527,0.7435265751045231,-0.602035995579675},
{0.09668611459596299,0.538882359274677,-0.8368139566874433},
{0.0484025370824441,0.33650073386701357,-0.9404384352582278},
{-0.05469041260151482,0.3854589560394464,-0.921102791211956},
{0.12634972762118082,0.5608511075794077,-0.8182186635961105},
{0.18656499473779128,0.8044895378790816,-0.56390609695373},
{0.3064741734403685,0.678777887709709,-0.6673336198412221},
{0.4406637468249111,0.608945323316262,-0.659546098044317},
{0.49273385662435615,0.4123467591295287,-0.7662789940820921},
{0.3854523565163895,0.38227832887697927,-0.8398153131057962},
{0.28474867946471405,0.29884820826583297,-0.9108281604997744},
{0.2337493768066739,0.33809611624964186,-0.911620669477936},
{0.014191360275456616,0.5066808630854099,-0.8620168839857815},
{0.12439747656267723,0.33477004702168695,-0.9340526127804235},
{0.1638570009839038,0.24485448442460267,-0.9556135017284566},
{0.12732729375444002,0.40297958935189776,-0.9063085627041965},
{0.14356272129122943,0.801100765343713,-0.5810570615879084},
{0.2007565107340478,0.8350699225355509,-0.5122060599742636},
{0.19123713237869294,0.6869702134788747,-0.7010708131083219},
{0.3250335022749025,0.4081694442868878,-0.8530831888798678},
{0.46142010201726197,0.4335564316022788,-0.7740286235473971},
{0.4673704544403568,0.1653836994080499,-0.8684544261423982},
{0.4768378004811495,0.21464456259659803,-0.8523810320390843},
{0.40606376265431543,0.28569438656451673,-0.8680385579826189},
{0.4352942163427179,0.3186190140542135,-0.8420218934812206},
{0.39140198159477296,0.4497532770164301,-0.8028240645475616},
{0.13422369407856635,0.5684536448713462,-0.8116923392396806},
{0.23911947815555284,0.6585768419728025,-0.7135113302420266},
{0.14310361780969522,0.418843661951639,-0.896711403637044},
{0.2270624505597216,0.21836428007038206,-0.9490836026057755},
{0.1392877739207695,0.2767755249170715,-0.9507861088820535},
{0.15424172653808377,0.2154010146219439,-0.9642675420724209},
{0.10773346336455503,0.2190080405671671,-0.9697571752961708},
{0.08032773479219527,0.8917503600236086,-0.44534116183092626},
{0.005890164126550255,0.8483776396291028,-0.5293587503233648},
{0.004395099631930936,0.7201613252416165,-0.6937927274953696},
{0.12018609037549866,0.5151085310413038,-0.8486568829207258},
{0.25788436415300114,0.4331246501975085,-0.8636542665422826},
{0.28905038255498866,0.2835262032405185,-0.9143646802128955},
{0.27827632852760936,0.1243357212417336,-0.9524195049475268},
{0.4072868590781746,0.1529953330309398,-0.9003942705798316},
{0.41744064455390045,0.06897342833364864,-0.9060827635808592},
{0.43559960595679087,0.05359205879559123,-0.8985437521480735},
{0.5136432684797206,0.09457999560577333,-0.8527750097046005},
{0.5439680255138819,0.10513716460051895,-0.8324932214969033},
{0.45715261456427947,0.24891750205863936,-0.8538451640466967},
{0.5078672785110677,0.2732064534128188,-0.8169633169435155},
{0.5636910485794848,0.3242370807925066,-0.759685933258287},
{0.555446869965874,0.32289173759724543,-0.7663026167491176},
{0.49596943332654597,0.361653795388997,-0.7894433820651601},
{0.45784597159814305,0.496879565960769,-0.7372162255552913},
{0.3707523951409907,0.5211528290506395,-0.7687277738378739},
{0.35863156930444995,0.4298942720876077,-0.8285977988894815},
{0.2552304663806907,0.45195690897591456,-0.8547469575611439},
{0.4944097292621887,0.8168440742997067,0.29719484836104487},
{0.701238532459452,0.7106387272689835,-0.057071182742548646},
{0.24867143612043574,0.9637379434899704,0.09680750557432201},
{-0.9491771826695081,-0.31437801593520553,0.015137337818091382},
{-0.8866653864136572,-0.41298130343918427,0.2080166713164893},
{-0.15201692684229232,0.04681620933816131,0.9872685027370369},
{-0.41277003424023057,0.1880282042916137,0.8912161877031801},
{-0.38652638135147444,-0.30934350805201244,0.8688520878408528},
{-0.3518298959949127,-0.23799172336344554,0.9053041830758908},
{-0.5032077305381631,-0.17490851049324568,0.8462795004510422},
{-0.6542410712282573,0.1418234838497328,0.7428692483518394},
{-0.6000462268721641,0.37569691654003046,0.7062551610563937},
{-0.2754657358965217,0.4428632215374945,0.8532237662866758},
{0.05112074206336278,0.2951850591473446,0.9540715123024426},
{-0.05884090940866944,0.02304135611293597,0.9980014244921886},
{-0.14359498196211193,-0.09485529096086247,0.9850801769054287},
{-0.405082300586185,-0.38597781479008336,0.8288120753474071},
{-0.6633988277555808,-0.17774477659938545,0.7268485328623535},
{-0.3521965444876775,-0.40029525766097285,0.8460031328222577},
{-0.28065041823123893,-0.259562236524402,0.9240469620734008},
{-0.5069201548777063,-0.07406919155885427,0.8588048156831564},
{-0.7181212785856463,0.07056099252852262,0.6923315503253527},
{-0.7537062575616129,0.2818769500688407,0.5936937445622583},
{-0.5772022138539165,0.5186666851038727,0.6307316973844725},
{-0.43432634423484745,0.5587243118993568,0.7065322144079369},
{-0.2026477649095719,0.5797436316627079,0.7891965565837761},
{0.03555502279622129,0.5161438476905804,0.8557636173880747},
{0.24919044157331616,0.38866304694038967,0.8870429300611714},
{0.3440158624126611,0.262009273027949,0.9016674704434218},
{0.21180292543115278,0.0990353030445205,0.9722816101982417},
{-0.08105854902020614,-0.2764722833557784,0.9575972995820221},
{-0.21497813779686512,-0.6399002696617868,0.7377750640650337},
{-0.35704480298440444,-0.6380967323549775,0.6821668189084896},
{-0.33247437832691934,0.7507671449092286,0.5707972335961116},
{-0.30192188023266664,0.8258361429333045,0.476274966024684},
{-0.2320690466644731,0.6901029809467814,0.6854938608540627},
{0.007599069999269685,0.540639980136224,0.8412197489440256},
{0.37722043016929746,0.22611885163514178,0.8980952132141085},
{0.5365639572017956,0.2508403948829006,0.8057159649199837},
{0.36677790656691306,0.3070217813364398,0.8781865365851336},
{0.5240149393694244,-0.2188839871417535,0.8231027539077895},
{0.5846524027391077,-0.5653340920501674,0.5818753580769693},
{0.6561047110712261,-0.6409973032576999,0.39830775202913055},
{0.7021785860513969,-0.7116397017393817,0.02267527726720798},
{0.9814009366605403,-0.10828186868911996,-0.15851573560693083},
{0.9357307849294162,0.3006178539262999,-0.1844906611081562},
{0.9352646853123376,0.3492022168195021,0.05777352487047643},
{0.8473660363635772,0.4735061962739801,0.24033868291980792},
{0.8305769266970013,0.4584887917347927,0.3161170616909724},
{0.8079102914270272,0.3690100950211807,0.45946981487226685},
{0.8482340258161759,0.13126511077991096,0.51309697732458},
{0.6886088727968508,0.020753598935145702,0.7248359182854349},
{0.7414738988720341,-0.18827583018980315,0.6440253636758766},
{0.740335335018228,-0.1273259813492659,0.6600694555854666},
{0.8235010810119433,0.08417205252917222,0.5610356808128937},
{0.6536940300696855,0.27342254149074324,0.7056374627639861},
{0.39401056381763355,0.5007990531009784,0.7706853988582332},
{0.04687738217448875,0.636054754004888,0.7702187098144581},
{0.05240092690154791,0.7141766328190279,0.6980013467000863},
{0.005615101423084619,0.8216648413673157,0.5699432946327491},
{-0.024995749080308376,0.9011160049220241,0.43285697199107814},
{-0.07651116390815488,0.9558545407132502,0.2837043157854338},
{-0.01297027842606555,0.9988924426925613,-0.04522897090625232},
{0.09323600425639464,0.9873862254393795,-0.12796675084910317},
{-0.0075380906205265216,0.9307951897235549,-0.36546339348461154},
{-0.5587991004740812,0.8009963111444178,-0.21482196080101457},
{-0.6811252631691767,0.7319702532450726,0.016968330414754974},
{-0.7539137641603204,0.6118169814286859,-0.2393616875047212},
{-0.7358504810602494,0.46953879257870784,-0.4879112540074564},
{-0.6171873398164706,0.1716701541606836,-0.767860108184242},
{-0.5019207674937601,-0.10098877008315259,-0.8589975619730053},
{-0.525359706945956,0.0018620485819505054,-0.8508781999162616},
{-0.4269015670428719,-0.06537231188883298,-0.9019320999358265},
{-0.2927718308090603,-0.23969841124689262,-0.9256507585101557},
{-0.36046422104337456,-0.16724574229032002,-0.9176570203694586},
{-0.5087502244006947,0.07178087821670992,-0.8579164963413867},
{-0.49205590340205946,-0.15152581791910102,-0.8572752850929103},
{-0.6057815371182461,-0.06055095283456651,-0.7933235855547729},
{-0.6119733442986834,0.2341752542434818,-0.7554141752495023},
{0.039187045742292044,0.9254066953272522,-0.3769440590982777},
{0.23463380117166194,0.5187402472239564,0.8221043335597773},
{0.4546483604280142,0.36821763044505557,0.8109936158747164},
{0.6228372985399661,0.2784578396648675,0.7311189582254123},
{0.577847573279463,0.35536450235177636,0.7347164436184275},
{0.429256990989525,0.18088889580297932,0.8848828414325806},
{0.6411494256514829,-0.13889355832367775,0.7547423357961051},
{0.2471736914701487,-0.29139653083994393,0.9241175401752016},
{0.046389004927641406,-0.5776665140224146,0.8149536543871772},
{0.18244761182991065,-0.7889979174927947,0.5866814767227575},
{-0.08258486723960383,-0.8630525135729752,0.49831726692779416},
{-0.2606364391035255,-0.8381571385493417,0.4791255135246025},
{-0.2867924005099348,-0.5430046920339735,0.7892376216570258},
{-0.12155708293729967,-0.37990050977238715,0.9170057133205086},
{-0.16047044594014512,-0.08823144451069426,0.9830892371393999},
{-0.36998142359725605,-0.3322598706329771,0.8675927181344395},
{-0.6667239349223486,-0.14609571086050657,0.7308455636246436},
{-0.7641108526578685,0.15122273106912545,0.6271094724674953},
{-0.5957063331559146,0.20081716892433413,0.7776930173938493},
{-0.3738315470651376,0.524963811022647,0.7646325728972474},
{-0.5189265163817874,0.47860992241692335,0.7082710023429798},
{-0.7805184628892019,0.23121021070514905,0.5808035533248381},
{-0.6584208957778345,0.5289589668973219,0.5354291132746068},
{-0.5072608442443339,0.7045988409979281,0.49621256449318374},
{-0.31575145552645073,0.7333463157803681,0.6020832163947839},
{-0.024079164287774197,0.6196822279795398,0.7844833523877457},
{-0.2933231629467674,0.39242059643606714,0.8717612044428598},
{-0.454794674833819,0.1045277639459346,0.8844409252783726},
{-0.4776928989467471,-0.47354175209505694,0.7399781775962021},
{-0.600434150034361,-0.4567810039045021,0.656376375218144},
{-0.7575742228120935,0.022980401103306413,0.652344386115021},
{-0.7246130348188635,0.27601358420333355,0.6314684878169501},
{-0.6749917469500176,0.43538586711249533,0.5956721315187273},
{-0.373956299632362,0.5303388613265504,0.7608530594879205},
{-0.49072683850503845,0.7307645424560467,0.47452118336261306},
{-0.5030227969025308,0.7175749612135998,0.48172008556386353},
{-0.31438328116831554,0.842343905589781,0.43774410017451754},
{-0.15922041298818115,0.846642783164752,0.5077842630516584},
{0.012085010932426088,0.8175917396154884,0.5756715207679486},
{0.15729520000669686,0.7101804478800949,0.6862229604900151},
{0.27470505322002137,0.48132111035129177,0.8323864021388053},
{0.10339859192730821,0.3476723527722416,0.9318973475148773},
{0.1335205781154512,0.10562703952609036,0.9854010268619926},
{-0.14191375806832318,0.012879250305909577,0.9897952364921156},
{-0.19498539528998754,-0.6061354460457044,0.7710904724288727},
{-0.1563796063139051,-0.9462117701183151,0.28324672075537394},
{-0.28441392512804553,-0.9108321900797924,0.29915454318413304},
{-0.6454148672753753,-0.3385771762585638,0.6846934677771412},
{-0.25156910937999477,0.03125163472211531,0.9673346466104435},
{-0.13535476423146806,0.3598866673294078,0.9231254922698082},
{-0.028321662740241702,0.3047341309221297,0.9520162776290972},
{0.10168848968118589,0.1386156675041065,0.9851117438081582},
{0.03949186482250549,0.41207002381875457,0.9102959343438001},
{-0.3490189350366269,0.8001544843030184,0.4877894876231649},
{-0.03723371332340592,-0.4320592773907784,-0.901076262817254},
{0.07663241975400269,-0.4915646925451126,-0.8674627515263552},
{0.04709120404697096,-0.5732746577185511,-0.818008915183132},
{-0.09311380517079619,-0.49273055242675345,-0.8651857731099382},
{-0.13117311778339522,-0.6818354041607989,-0.7196485911914672},
{-0.28208818903810196,-0.5471150642317714,-0.7880934970521384},
{-0.18918844766751033,-0.4166177943476517,-0.8891779038539226},
{0.10446790361196727,-0.5437021118181176,-0.8327511457328893},
{0.0685152884156317,-0.42699202949557874,-0.9016559554511742},
{0.061648415864509386,-0.2798614275108647,-0.9580590035133418},
{-0.13190208044325255,-0.20575768541316497,-0.969672942835964},
{-0.24006744475400352,-0.2515728494749047,-0.9375919812884282},
{-0.344162113710529,-0.41490516484158335,-0.8422625147031533},
{-0.31959411724024195,-0.6012527457683572,-0.7323624348172437},
{-0.3635779741921378,-0.7030152197235385,-0.6112124487601721},
{-0.3568670253261726,-0.7215773589042954,-0.593272316353587},
{-0.1916009815574762,-0.7618877852412905,-0.6187213157523612},
{-0.40807134050090854,-0.5231286921386018,-0.7482072924819348},
{-0.4020627869648237,-0.31538724596479595,-0.8595791996208494},
{-0.2614317015352978,-0.36348848878649226,-0.894164181765335},
{-0.17927193237168637,-0.2840754004724569,-0.9418931686290833},
{-0.050326158607112634,-0.3412658566109497,-0.9386186088457048},
{0.027863984930726296,-0.3013806531447793,-0.9530966898766392},
{-0.011689242523970531,-0.14136493298601438,-0.9898885378319497},
{-0.023316175970455502,-0.0744045615416783,-0.996955524163393},
{-0.27992025944995214,-0.04232964411558118,-0.9590895941352506},
{-0.2856573146907914,0.003204048395323332,-0.9583264749747482},
{-0.2566398562215898,-0.12531381266130692,-0.9583488052660413},
{-0.4055031779609104,-0.24134248658834206,-0.8816580838573183},
{-0.5162628655511232,-0.4891312419702148,-0.7030101576660313},
{-0.47911788119989807,-0.665527947532952,-0.5722924138647102},
{-0.4880619889697186,-0.6911971464558224,-0.5329559077956174},
{-0.46572664749547465,-0.783098629111707,-0.4121349619918104},
{-0.2928633099411412,-0.8038780649966736,-0.5176979218690403},
{-0.5457505752564811,-0.5684573481079422,-0.6156399540228896},
{-0.6239938205571121,-0.24393901196315046,-0.7423782528798784},
{-0.39995467291954595,-0.2616113270802681,-0.8784052442654927},
{-0.24912663292682422,-0.29817034811422255,-0.9214284368696175},
{-0.10785501272745854,-0.3135867594578774,-0.9434143525102144},
{0.04144469026134509,-0.33775362528686376,-0.940321661057918},
{0.0016790410888721647,-0.3768822229222867,-0.9262596670837923},
{-0.11368376449848243,-0.32856998998205844,-0.9376128003459869},
{-0.23887379422885757,-0.34053426015027527,-0.9093820583751441},
{-0.02816927152884654,-0.03283831653463959,-0.999063630160114},
{-0.022950297349363893,-0.07995903596777508,-0.9965339113239848},
{-0.1231449828977422,0.017060413248408193,-0.9922420347308958},
{-0.46431978415768344,0.0003050070840067572,-0.8856675702601066},
{-0.37752426255404536,0.11191404225190528,-0.9192119876991721},
{-0.2545944779744733,0.068272541631743,-0.9646349111679752},
{-0.36656643756977597,-0.005005115206970599,-0.9303784153070022},
{-0.5655900690447111,-0.14216029567577237,-0.8123412608820114},
{-0.600225441457231,-0.36406557908210535,-0.712169694353167},
{-0.6022922648353353,-0.5246520705254334,-0.6016512549749217},
{-0.5096771526947279,-0.7012489757292776,-0.4984767537805893},
{-0.5899377467552248,-0.7017295412301306,-0.39943598475640457},
{-0.5145512848725287,-0.8196507902713089,-0.2518125438568313},
{-0.31975135972772345,-0.9067315417490522,-0.27494904827923766},
{-0.30366308183332885,-0.8606945694399144,-0.40864849304521517},
{-0.6563111127515423,-0.6753244057173385,-0.33644118404463486},
{-0.9003859403481094,-0.16132618537191062,-0.40407798793896066},
{-0.6723665757665339,-0.3251505651213483,-0.6649814266528453},
{-0.7863995338185648,0.0,-0.6177181988657482},
{-0.5845367297308721,-0.07932013448412173,-0.8074807290957217},
{-0.027802656619564194,-0.40526457119493153,-0.9137765808002978},
{-0.47332358006433733,-0.4116440710487024,-0.7787900534325858},
{-0.6309232512919452,-0.3544190056151197,-0.6901615893672951},
{-0.039736305040425426,-0.3086441366514826,-0.9503472117980856},
{-0.609586718774004,-0.3426974637004037,-0.7148163964737055},
{-0.28977908802397423,-0.26923965650715104,-0.9184432957498819},
{0.8383051313888569,0.28239579215900673,-0.4663658684530833},
{0.863193867734621,0.309185818129341,-0.39912463789277125},
{0.9252003364896798,0.21180517383077166,-0.31486966461998195},
{0.945092558278084,0.07385699732572178,-0.31834760912156174},
{0.9623879870841623,0.17981817396569375,-0.203653594684056},
{0.9183188718871926,0.29563843164081793,-0.2632268361561781},
{0.8431866205454828,0.4033433423167128,-0.35545811446902004},
{0.7966973683008559,0.4116698742342699,-0.44249431407695017},
{0.7687243760672045,0.26039225697656165,-0.5841735240035615},
{0.7907248105769268,0.2753452466341765,-0.546753389650259},
{0.6968467664274722,0.357076103818811,-0.6220138585282112},
{0.7392026007913906,0.29487542549382817,-0.6054981407263591},
{0.8564575295868507,0.1378856611862624,-0.4974616009836499},
{0.8931008755077368,-0.05783344522887729,-0.4461234344665976},
{0.9589760037161498,-0.023072553459595,-0.28254677767310904},
{0.9853466872361221,0.05401940824474546,-0.16178321756500938},
{0.9774864804561729,0.20081394765643076,-0.06476062810106198},
{0.9374861860715481,0.330888418825737,-0.10785409223588284},
{0.877794119503938,0.434716459167779,-0.2012438418758073},
{0.8100064792005632,0.5064640532542558,-0.2956072841023675},
{0.7914567840507247,0.4969760508394871,-0.3558243441251202},
{0.7181870896646819,0.5165740463695232,-0.4662172871702546},
{0.6659068355332705,0.4415578051625155,-0.601327523975186},
{0.6070011667275095,0.3369340839834054,-0.7197395408352286},
{0.6897385525765657,0.19034967196975258,-0.6985898163232783},
{0.6008388098766038,0.4759224834361404,-0.6422542442880723},
{0.6333542661562035,0.16831086796539454,-0.7553368952106552},
{0.7960286589167552,-0.022858420939228696,-0.6048271379289765},
{0.8926580064317114,-0.09430432485640648,-0.440758865896921},
{0.9619842105387255,0.01858619727463814,-0.27247189202751426},
{0.9718282559562885,0.039217099885245854,-0.2324045180317056},
{0.9924198226976818,0.050233952760600456,-0.11215812724340384},
{0.9962871037643898,0.08365184834839606,-0.020356206440807045},
{0.9730308768309,0.22538105612131215,0.04913544825614042},
{0.9296647430630667,0.3680268569913559,0.016724175272533063},
{0.8767407530840217,0.4793265985784154,-0.039644214923606376},
{0.8079223590189074,0.5683105757434339,-0.1558350130602564},
{0.7623983463041815,0.5698834711753233,-0.3065641708253165},
{-0.9866384192403574,0.025452139799201502,-0.16092488390093915},
{-0.9580897882916962,0.11658365127405804,0.26167195078338384},
{-0.9209092981363277,0.04480164694580671,0.3871935911620948},
{-0.8445195114937851,-0.07678604665681117,0.5299912242151906},
{-0.8819010113512873,-0.22446603909085946,0.41456676600089093},
{-0.8785545496851422,-0.32298381943785825,0.351885429662653},
{-0.9486268311458936,0.2787928281940469,0.14960512751127494},
{-0.8572219911927718,-0.028535598899078567,0.5141557909923514},
{-0.6643489486467951,0.5293004869388442,0.5277134345060779},
{-0.6522598310426806,0.7040502468544029,0.280838677379787},
{-0.5931946106041003,0.803011948823854,0.057375639398319335},
{-0.4500319284275502,0.766330095133615,0.45848603979650776},
{-0.7112252718741624,0.3947383611511771,0.5816702148840067},
{-0.7799816083460809,0.12558715719808686,0.6130714123075419},
{-0.8008383374830842,-0.4475720727540806,0.397916067667474},
{-0.695468909698515,-0.6900668094215868,0.20032671858109735},
{-0.9658188376746484,-0.2218158527025842,0.13413314386316566},
{-0.9596988382377224,0.11682668456537501,-0.25559668553920734},
{-0.8074554823692582,0.5469716166002577,-0.2209925216506865},
{-0.6629373501711137,0.6384918210147367,-0.39095046264889816},
{-0.6424872475120087,0.5921003654290358,-0.4864435157788057},
{-0.7492818137494918,0.6276012712787914,0.21140815469966373},
{-0.5056693680469972,0.6356195185212699,0.5833406533868006},
{-0.3913493853840716,0.781996752138414,0.4851048734082984},
{-0.3964121689573051,0.8600575538007305,0.32118280846407177},
{-0.7046298771005403,0.631413915638061,0.3237486732573419},
{-0.9061691318197514,0.1105096014583991,0.4082219157793268},
{-0.8440732940677855,-0.5361337957968452,-0.010041277111231128},
{-0.4665770371012845,-0.8812099567700201,0.07599263476920509},
{-0.33540452537377835,-0.9255220062479007,0.1758204206275577},
{-0.6804227468502255,-0.7193954769544965,0.13962461568866152},
{-0.9544666242088438,-0.24192776228956522,-0.17454060016207534},
{-0.9598826442195513,0.2202553602731257,-0.1735306474287405},
{-0.8552688024232289,0.3309498887231358,-0.39873229961426476},
{-0.8384504237782402,0.5439410061079535,0.03360161812110974},
{-0.5070539668731611,0.7515771135120008,-0.4219337828654637},
{-0.7867904828759814,0.5109562502127527,-0.3462433341225543},
{-0.683020825728264,0.4161912525730664,-0.6002227860579291},
{-0.8404421208614463,0.42836978460502134,-0.33189813063553364},
{-0.7545265464162916,-0.4414302654031687,-0.4856222930830007},
{-0.5711964538392297,-0.7954823439613553,-0.20234241168681552},
{-0.7989976412337079,-0.14658415376205375,0.5831945260106902},
{-0.6090839636682183,0.48135851906408395,0.6303258691555063},
{-0.6927303866469182,0.37709864215641264,0.6147529792524806},
{-0.5937251894838212,0.5652503171219284,0.5726975452767018},
{-0.5537746004470978,0.7718061363571498,0.31248836743326275},
{-0.477199522657858,0.8783760503221956,-0.02713171198970287},
{-0.6746975468615504,0.7176691102539506,-0.1724362735804414},
{-0.9674901163830312,0.2407357519345746,0.07751885216928683},
{-0.9946600232187458,0.08286058440268566,-0.061526919010538944},
{-0.4469209073997806,-0.8615222429673399,-0.24091726256430968},
{-0.33858125531536937,-0.9358455818828165,-0.09775367215343464},
{-0.22480449510348796,-0.9742358141440096,0.018097442372465276},
{-0.27247696298612045,-0.9434765725726315,0.18870151469572313},
{-0.2673454114699229,-0.8930743961052275,0.3618626175598423},
{-0.32649535840155053,-0.8227390624233333,0.46529691177249144},
{-0.7277318466325166,-0.5830092975090819,0.3612568593325171},
{-0.9881115273275469,-0.10818948112283665,0.109227495333336},
{-0.977183805991736,0.12418150031729704,0.17231008178992444},
{-0.8494408358878907,0.03598179787677055,0.5264556738678356},
{-0.7985876670269054,0.40702992716005976,0.44337836716353335},
{0.04715276131428701,0.48282103499017437,-0.8744486635997877},
{0.14417225383429172,0.19211833593297534,-0.9707239083398972},
{0.03332691306077983,0.2870648647448922,-0.9573312280996771},
{-0.12439792452745968,0.47036962047233516,-0.8736575853902785},
{-0.21928205557537542,0.2881952729132146,-0.9321259918986894},
{-0.0780972567621008,0.11804638810375495,-0.9899322546224526},
{-0.04437520595032721,-0.10428483406751751,-0.9935570011229231},
{0.12277810263279199,0.009674165674640236,-0.9923869950943489},
{0.22721160700737433,0.040620287296507844,-0.9729978817556982},
{0.24873081595701207,0.2541019199529961,-0.9346470967534003},
{0.15415171396616992,0.3478561242896951,-0.9247882816490726},
{-0.059390955368600645,0.7141565126579819,-0.6974619630120303},
{-0.2886766410519828,0.09860556054708847,-0.952335413780323},
{-0.08691732488878898,-0.040407151038131736,-0.9953957206956229},
{0.12354171195497655,-0.03833184145044242,-0.991598767313802},
{0.12375408875106193,-0.08075271043793486,-0.9890217011139448},
{0.20664206217237593,-0.10080351814577945,-0.9732100024509517},
{0.2967064007710117,-0.04443580883872958,-0.9539343639026533},
{0.41539443871385384,0.034700621404547397,-0.9089792776294412},
{0.35967172251590307,0.1398401689083159,-0.92254050273261},
{0.4635569742059607,-0.884965950604026,-0.044161045464603775},
{0.5632560942419856,-0.7509161246605609,0.34477173031446234},
{0.5340262929209652,-0.7869395884095816,0.309098694049085},
{0.5361297267651719,-0.8440368873036403,0.01290925828558884},
{0.5060693447552701,-0.46721847382003695,0.7249832522343168},
{0.4805568561803606,-0.713084076905026,0.5104666563474596},
{0.4090789880075474,-0.9101739977290471,-0.06509743027682134},
{0.2483024171252496,-0.8410105739447916,-0.48067361500586936},
{0.6251540093246042,-0.5060985318049372,-0.5941773647070877},
{-0.13721466725876907,0.8046115043963895,0.5777304406745798},
{-0.15012231732363482,0.8779337038700076,0.45463798944926687},
{0.4905931249051227,0.16809878394987923,-0.8550211603407243},
{0.2988739757954768,0.11368327302489928,-0.9474969446001137},
{0.32063860198641786,0.1934029980936268,-0.9272465514870315},
{0.4334650583372982,0.18973884051956827,-0.8809694748394705},
{0.56177173459762,0.2700665257425209,-0.7819696860368346},
{0.4830213233870527,0.28477113846805124,-0.8280071254820397},
{0.5906071010705731,0.32121412529347676,-0.7402734210256103},
{0.8076007290909285,-0.2293526029151468,-0.543303272498747},
{0.6925747316104517,-0.6623599580381997,-0.2856913143978045},
{0.4534830483901582,-0.8598432604470212,-0.23456916311954892},
{-0.2658839251181089,-0.9431995662403004,-0.19919918827118022},
{-0.7805816331904469,-0.6016494249806128,-0.16944109107956234},
{0.8909201408239307,-0.16657451358749184,-0.4225094485302763},
{0.3922878523959534,-0.09472968879670715,-0.9149516527790141},
{0.28898291610635257,0.2566935902770287,-0.9222783066457529},
{-0.35777399408551447,-0.07336722918225737,-0.9309215965043546},
{-0.19352284213319937,-0.28404310703988994,-0.9390784966741674},
{0.32551698817719726,-0.5040238203500775,-0.7999991743294234},
{0.8704002112657621,-0.44887229744667606,-0.20227983788173154},
{0.9922702245448385,-0.12387777457398942,-0.007355164738580765},
{-0.9478649202504112,0.019074420990011377,-0.3181010207820425},
{-0.9128267479225103,-0.14050973190486524,-0.3834114545983685},
{-0.9503164129611734,0.021149699108915596,-0.31056626585031877},
{-0.9409303676360629,-0.04641970881066791,-0.335403121473543},
{-0.91565921916145,0.0858191452273609,-0.39268724027791985},
{-0.8438586740082366,0.15796805731561556,-0.5127851705821759},
{-0.7993364768410418,0.24592614594061793,-0.548253160076752},
{-0.7387774848655955,0.21235245093310087,-0.6396204065212192},
{-0.6857657570951884,0.17603478811875317,-0.7062131971066873},
{-0.4617552127356629,0.14295216170256367,-0.8754123616764883},
{-0.4371867658316155,0.24235185928613634,-0.8661023658218727},
{-0.34602916908664827,0.12787675803530144,-0.9294683151649575},
{-0.36344924736195966,0.09033605569052436,-0.9272238357776958},
{-0.37712476343339213,0.19123293669233726,-0.9062046549920898},
{-0.24571262367798805,0.2300561379072362,-0.9416472163058127},
{-0.21320449575136263,0.38169946813733624,-0.8993605278280128},
{-0.04519858978331917,0.4381297170278979,-0.8977747148024684},
{-0.13401099981618286,0.5204475337582044,-0.8433121702746081},
{-0.09525029915108477,0.6419414951795234,-0.7608143645320499},
{-0.00030500366239540267,0.6668980079176069,-0.7451489475321652},
{-0.08945162995638374,0.7709730484018295,-0.6305544897438576},
{0.12180108667962165,0.682649695061565,-0.7205233439077569},
{-0.20942510084251048,-0.42333635379410184,-0.8814348862470893},
{-0.07706193538178334,-0.5308892222088523,-0.8439301463140736},
{-0.3423077576441613,-0.43172982912844177,-0.8345266644615693},
{0.6679686756227275,-0.42543416247528026,-0.6105928445255285},
{0.6198504380927055,-0.6034609241285744,-0.5016177303945386},
{0.5675875484255996,-0.3300296447290623,-0.7542710444344437},
{0.7493656404124989,-0.23597329533049483,-0.6186822616335728},
{0.5960334951355453,0.059053742602234394,-0.8007850698915253},
{0.43246043873984624,-0.23841840886953888,-0.8695600216414374},
{0.26011736761946225,-0.3156321534540901,-0.9125323549160628},
{0.4503153930651582,-0.5434303692235124,-0.7084486435685858},
{0.5555461485688585,-0.7335969651288563,-0.39141278666395074},
{0.6760238985601289,-0.6917721058551223,-0.2538563415326352},
{0.7833318696714152,-0.4652316434760481,-0.41225077303221663},
{0.8681316833071769,-0.2904249338796272,-0.40249315300916827},
{0.8166042727005502,-0.08237104491157263,-0.5712901826282165},
{0.6406565379222884,0.1895844143259455,-0.7440544000690512},
{0.3032958323325595,0.4846075255144542,-0.8204676619492431},
{0.19077535111065022,0.44814422105361995,-0.8733679193471973},
{0.35432711836211184,0.09851597916664338,-0.929917681863314},
{0.19196175605227123,-0.031434123805080684,-0.9808988633258452},
{0.06695942720273726,-0.02029543258579337,-0.9975492622045473},
{0.12244052354259485,-0.31580735035848345,-0.9408900231451969},
{0.27742024666256543,-0.5544444829807044,-0.7846204955479693},
{0.4278204052652453,-0.6902880158894418,-0.5834999194156749},
{0.4722547894772334,-0.7942948289588825,-0.38219254114254203},
{0.5332667930682328,-0.8304041502004931,-0.16141708317436396},
{0.6576357637743027,-0.7493779393895821,-0.07712266956747238},
{0.8140494937749798,-0.5750808357168619,-0.08127394463107342},
{0.8467632985777329,-0.4856876579557792,-0.2170239965791508},
{0.9306855328259385,-0.324847213916164,-0.16822225357961723},
{0.9269046449016484,-0.13419385755121194,-0.3504850750820553},
{0.1424624017454391,0.7342263781772134,-0.6637891906906084},
{0.016022470530877995,0.6814680126279957,-0.7316724869796165},
{0.10403886835998113,0.5266013952763507,-0.843722042122508},
{-0.008362148779332498,0.41145832066552684,-0.9113902154526878},
{0.0483421757643929,0.2559652255120548,-0.9654764820392714},
{0.313800572122363,0.09705196045744845,-0.9445158113589436},
{0.46090003644538285,-0.43187546738720906,-0.7752772001508392},
{0.11844536516128946,-0.21876321530021614,-0.9685625179116318},
{0.3342792838067354,-0.5092476665543963,-0.793047397402298},
{0.175514170871944,-0.548973790060272,-0.8172041077050424},
{0.2300590328320698,-0.6439380820212132,-0.7296688207229456},
{0.3376023176496,-0.7705154188773993,-0.5406761178282286},
{0.37742791713518853,-0.8820288280280252,-0.2820874224323049},
{0.4571512918923514,-0.8868647259966644,-0.06696009336922643},
{0.5674226956566092,-0.8222018862624227,0.044894795692830725},
{0.6784726027041278,-0.7229086245907882,0.13068300529197197},
{0.787885613003467,-0.6134072696771059,0.05447735611636607},
{0.8988493772707954,-0.43614891720788973,0.04294087794035581},
{-0.18030594275953196,-0.3971134812588224,-0.899883686932981},
{-0.33470913821035364,-0.2712588371883232,-0.9024347267507613},
{-0.18802858604262207,-0.49520244439943706,-0.8481861764327657},
{-0.0010070157169467429,-0.6317738603784925,-0.7751520981470688},
{0.1427999976445009,-0.758009220248186,-0.6364198163881039},
{0.02807753357347487,-0.7038923764705601,-0.7097514878146136},
{-0.14518074875042217,-0.5887782029973399,-0.7951495317658749},
{-0.2936291565378947,-0.6229955492152701,-0.7250230783146205},
{-0.5238380687605888,-0.3439558640788668,-0.7792868799633013},
{-0.560274064421837,-0.09375552086042435,-0.8229841280634917},
{-0.11954232748875591,0.301343346345285,-0.9459925050189333},
{0.07733528726136461,0.7096278118972316,-0.7003196569611261},
{0.6765920236755063,0.733480295842711,0.06503759765837214},
{0.8129170831370153,0.37557305058122253,0.4450962812932964},
{0.7385933824671385,0.0407738491849644,0.672917014644743},
{0.7927337303342222,-0.14697991654451265,0.5915827388649508},
{0.6338961272289474,0.05023514978503715,0.771785028107061},
{0.7034036210610709,-0.07727438652222182,0.7065776780126779},
{0.7670646217686622,-0.20893343792353922,0.606595981315694},
{0.580662161402966,0.02755881449757242,0.8136780481605266},
{0.11163752273259281,0.46455517523754836,0.8784791133989132},
{0.8217299261002873,-0.5460495766248993,-0.16306375568772094},
{0.931170539816363,-0.3267382072112335,-0.1617515679259164},
{-0.6292421668728382,-0.7770757904085168,0.014405255643481066},
{-0.7505735872176817,-0.6431130648377706,-0.1518053885939186},
{-0.9751087196261733,-0.20780349754643737,-0.07733492947221711},
{-0.9797272696645809,-0.027528625738693364,-0.19843551053308134},
{-0.9923605620618107,-0.11472137706750594,-0.0453819403298537},
{0.19092915672668911,0.47488082585997254,0.8590892027852438},
{0.06656263422628556,0.5001802802796351,0.8633591969419468},
{0.1987432583053203,0.3083077084237643,0.930294294406169},
{0.27986006874692926,0.302657481647266,0.9110855013246005},
{0.08765058569188586,0.604795941398843,0.7915423198385267},
{0.08325603982156711,0.584413318467389,0.807173776228616},
{0.1762472450030281,0.6202084190618858,0.7643810735186989},
{0.2044193237872118,0.44680482207204114,0.8709639435909794},
{0.13077534077610534,0.39717814628027565,0.9083762053038694},
{0.1854623205288793,0.3015251469194562,0.9352466591435885},
{0.30052928373946036,0.5345246266023282,0.7899149151463647},
{0.39116679931367165,0.5988505330359325,0.6988322933274316},
{0.21845654455797545,0.5831318002344369,0.7824538591477034},
{0.3547230630530788,0.4236042403947232,0.8335052465688809},
{0.24198546230691004,0.26151782249129873,0.9343722301906883},
{0.2755253011032373,0.2100622791890452,0.9380616436641432},
{0.4226266568742718,0.2569390470966614,0.8691196896724502},
{0.5832564521112891,0.2154674471843455,0.7831894344757293},
{0.4356618150064175,0.09714218851221479,0.8948531601086133},
{0.4796026623811465,0.004028039157943232,0.8774765302487914},
{0.32334801395301743,-0.00463905758798075,0.9462687467190992},
{0.2425360900806022,-0.00021400449129079942,0.9701423602804342},
{0.29603842658360685,0.04849538039639709,0.9539441535363121},
{0.024751535672752057,0.02618556670805271,0.9993506279469776},
{-0.1994723924419627,-0.11319492511459466,0.973343553726936},
{-0.19144949346094997,-0.18537528743993165,0.9638376908277183},
{0.02362105281393404,-0.025636057319250373,0.9993922345251065},
{0.0923210501059236,-0.10327841211561407,0.9903587195043101},
{-0.2841354104765094,0.04559634966291991,0.9576993481311148},
{-0.5457370151535679,0.04232938899392994,0.8368866907286044},
{-0.6940370812704747,0.24882276537810197,0.6755736534613784},
{-0.7255271961920883,0.44514986946467716,0.5248350991513696},
{-0.4022405922984607,0.3580188675510992,0.8426298098125962},
{-0.4016034065431429,0.354237179166381,0.8445298838698299},
{-0.16358507886037235,0.3648925594941515,0.9165660598124136},
{-0.1289737869443224,0.5292024353292827,0.8386361217612779},
{-0.08337713444694667,0.20477933020990546,0.9752505726069574},
{-0.17435437163093262,-0.009980135753399486,0.9846323933242936},
{0.026276080545506952,0.07828023995670133,0.9965850548866803},
{0.8556734303622617,0.23457224555561335,-0.46130124884621415},
{0.6860733453375956,0.36690327606535295,-0.6282398831893689},
{0.6717378098635622,0.29173720928055114,-0.6809241628264492},
{0.6308045582394788,0.059390653119491064,-0.7736655347282416},
{0.5752928398074058,0.2918275568284288,-0.7641170234603342},
{0.5411052764257201,0.6136499222957479,-0.5750120456917991},
{0.7033707307067771,0.5842549134618286,-0.40486517667085864},
{0.24619622011140618,-0.14410988487818308,-0.9584465359545377},
{0.29365279239451947,0.3453824604600539,-0.8913355111996046},
{0.32771975516303187,0.3136192493841105,-0.8912029670572408},
{0.8764874811702525,0.30015906865593706,-0.37639637200088255},
{0.9949730685815773,-0.06695861028749307,-0.07446567870991026},
{-0.3716658222690442,0.3164560661092037,0.872765761690823},
{-0.5373838067350949,0.19807008891636407,0.8197480613795691},
{-0.20566750596272096,0.1584247006263915,0.9657134622767316},
{-0.2454024985051653,0.2641107652138097,0.9327502974674402},
{-0.3147451158020946,0.12906632801598075,0.9403602474856098},
{-0.4206201815263053,0.029237985780717794,0.906765572284405},
{-0.6107745798945521,-0.015137187857012305,0.7916598247343457},
{-0.6777769627792615,0.1068484623324803,0.7274625727987003},
{-0.5465642415750731,0.24665471927621938,0.8002680671439005},
{-0.2459255955878476,0.021332658874421415,0.9690539299234641},
{-0.20664791098430527,0.3239038324071195,0.9232458763719464},
{-0.2213574429648952,0.3685827281939425,0.9028552790570333},
{-0.2192179849012814,0.25782468668628994,0.9409941052052015},
{-0.34962517377307223,0.16098738230037765,0.922954657935167},
{-0.4438752695378137,0.00811826098284817,0.8960518059416809},
{-0.4707566949449205,-0.14816973671668077,0.869732064078268},
{-0.6415998006891368,-0.16147521492146397,0.7498502855382047},
{-0.7422806157372169,-0.004700060886071151,0.6700726803328467},
{-0.7684340686750046,0.02365224835221766,0.6394917147606084},
{-0.6917181425441892,0.16288080112992284,0.7035594188826496},
{-0.6040340785828132,0.08765075271050558,0.7921238397245052},
{-0.4295960782177805,-0.699206796356967,0.5714517175651233},
{0.05154731516141903,-0.8276521164466766,0.5588692588083426},
{0.09366203243089376,-0.30186232741009766,0.948739457897411},
{0.10379597891836963,0.13217979352667736,0.9857762915304984},
{-0.06930937343636945,0.4341346028227236,0.8981777983149071},
{-0.06796716184992595,0.31270294622730666,0.9474161347216059},
{-0.09042775203147364,0.3018648486106717,0.9490523878247136},
{-0.20926963697317494,0.11765160691112732,0.9707545098696916},
{-0.2424709063427874,-0.2227248325330597,0.9442465295411087},
{-0.4599895415436637,-0.3252152809559371,0.8262231192015876},
{-0.6309826333137136,-0.3398608045742251,0.6973919629380969},
{-0.7796393974755514,-0.15305263008626332,0.6072374348865823},
{-0.8394068194172377,-0.1704512429306721,0.5160838742871413},
{-0.8257864829481709,0.12256444642345173,0.5505039882262464},
{-0.7754434447646574,0.2685731981320052,0.5714506988504506},
{-0.7255629583588465,0.21818179878885594,0.6526523547301565},
{-0.7695408050385175,0.0712015548816443,0.6346158585814781},
{-0.7524294100333911,-0.35982562976535787,0.5517023645778277},
{-0.49074517073641577,-0.8601765688439011,0.13880002813695502},
{-0.2880692263093554,-0.9533852968371527,0.08984763006481318},
{-0.13019258331452963,-0.9340841850684821,0.3324704895999627},
{0.16278815978686562,-0.919901204760729,0.35676573337831247},
{0.31389294249841837,-0.7971072482183625,0.5158403391432608},
{0.48169021116065763,-0.48031616491748336,0.7329876685122076},
{0.2749760129883823,-0.03784355228721234,0.9607060205033057},
{0.002319020229445505,0.5024613831075896,0.8645965421112808},
{0.04214704440742832,0.4150922860229716,0.9088025202055404},
{0.024689589496231824,0.2838597775233461,0.958547886584131},
{0.04477174864691341,0.2581303163037049,0.965072137370076},
{0.18360207507528326,0.15979767638524658,0.9699252448771121},
{0.0014040099937042902,0.12662190129119014,0.9919500606730873},
{0.01614419295537685,-0.12064144190638398,0.9925648631341774},
{-0.059237518470767025,-0.24296422804748152,0.9682248190863095},
{-0.2826421802908873,-0.37682557261658206,0.8821087720585249},
{-0.4869655488134375,-0.41521469983660536,0.7684148015937909},
{-0.6330307447405618,-0.48232699643696286,0.6055020600471214},
{-0.7608372842569785,-0.3891167711336326,0.5193407025325494},
{-0.8639121551029241,-0.3859792388133696,0.3235364206244378},
{0.07086585443326135,-0.560944678923703,0.824814583929399},
{0.05252255597615207,-0.17224782332485986,0.9836524124270625},
{0.3281137607517705,-0.2348769871375184,0.9149722186594149},
{0.09543151496177309,-0.20645911408219286,0.9737902547081158},
{0.20789997184025272,-0.256639840750794,0.9438821927805552},
{0.24427545339397266,-0.15726551091678442,0.9568683618686804},
{0.3218508342457308,-0.40245154402241384,0.8569975467930477},
{0.14069378689282616,-0.7071330330864587,0.692941651113354},
{-0.0701946659367896,-0.7389625378693171,0.6700799030710893},
{-0.12787834025664657,-0.5240858860608513,0.8420101627207464},
{-0.23725360889464875,-0.1868060541618622,0.9533174828958821},
{-0.17466082928634882,0.051181122101463625,0.9832975579413589},
{-0.01779249376113237,-0.2772686945090671,0.960627658466587},
{0.11554462407319965,-0.43431510465027967,0.8933195563293125},
{0.3168836867278122,-0.34316048997598025,0.8842090291357778},
{0.3943072967059335,-0.18396987095022752,0.9003759450068708},
{0.43554025912223976,-0.17273906885743825,0.8834398093667714},
{0.45086359244957624,-0.4493685473775742,0.7712262506108252},
{0.3982459815198359,-0.5745253997351883,0.7150669222264617},
{0.4208012378492775,-0.5693695585511971,0.706218538428248},
{0.21360411846692212,-0.28395080414220913,0.9347433986934391},
{0.057315396117630486,-0.44573385741247534,0.8933287601572414},
{-0.006287142031195187,-0.35918011414481277,0.933247082742828},
{-0.18641437823304735,-0.5664154185762895,0.8027597730249274},
{-0.27186181865878156,-0.36271576063092986,0.8913632416391568},
{-0.0807547034311711,-0.27534721781914734,0.9579470692647891},
{0.7745246362843142,0.30110596642043674,0.5562794125029844},
{0.7792563908580561,0.32613246355438535,0.5351608108996995},
{0.7050658656277048,0.21141005550817482,0.6768957922433008},
{0.84253502417615,0.04028452710416798,0.5371330281340814},
{0.8477696044373269,-0.21326969276197816,0.4855952387960469},
{0.7962096988632907,-0.3545396546040715,0.490256819176698},
{0.4886764919108741,-0.5083620756953009,0.7090580274197921},
{0.5627172541881493,-0.6918762144950099,0.4523898713001924},
{0.40972157883020155,-0.848466907040793,0.3350106498270127},
{-0.6952083979182905,-0.6851370010080827,-0.21742256854690675},
{-0.7036821187271091,-0.7094502590507261,-0.03888194589503347},
{-0.6741529785931162,-0.7155078175820857,0.18321114713070857},
{-0.6627259894466986,-0.7452201042413326,0.07376489101484486},
{-0.6878696285101351,-0.7258043249483532,0.0065921210239029485},
{-0.5829062730646395,-0.8069121465838547,-0.0954623722590626},
{-0.60987280572327,-0.7060712452544832,-0.3598868675903722},
{-0.6935155241570171,-0.662385961990042,-0.2833391168048361},
{-0.8094507413927722,-0.42991864276270847,-0.39994931911901316},
{-0.835894713912507,-0.3974842764289536,-0.3785317387549945},
{-0.7936355366708404,-0.2989412556926797,-0.5298837236395085},
{-0.8980419400289076,-0.04641920365753104,-0.4374539192656944},
{0.11087685878787742,-0.13462047098010077,0.9846743883022594},
{0.2903307510456713,-0.03726399484785859,0.9562005279674527},
{0.45436771808465115,-0.22269778283991398,0.8625286512810653},
{0.5045164991458676,-0.23780730562850683,0.8300064984560711},
{0.48137977337112103,-0.17704233002209646,0.8584459954880769},
{0.43978004532838044,-0.22336908631011912,0.8698849136592439},
{0.44649617507683415,-0.3422727999593999,0.8267348402297496},
{0.460593489865725,-0.6054981608135919,0.6490189630085317},
{0.4666098222853659,-0.4423781564071097,0.765883046215717},
{0.9931839790640513,0.10498611191913959,0.050631018502495975},
{0.918557508168392,0.3866748444644821,-0.0820650281535502},
{0.936298038313039,0.06433444557411187,-0.34526375796458375},
{0.39812446129540124,0.7921588151173194,-0.4625811549881502},
{0.6423662397757895,0.7658765931669543,-0.02826053848199562},
{0.9095316991475515,0.28718490426139565,0.300461177209537},
{0.984033409532476,0.07544394809996367,0.16120316255886702},
{0.991913779650568,0.11215959345011717,0.05939090280866835},
{-0.0037231016788671317,0.9096598430449376,-0.41533734296996244},
{0.0018310264394463896,0.8708885753573533,-0.49147709677483187},
{0.06866795809918477,0.7470124227941694,0.6612542262410682},
{0.21153187417984948,0.8062680129678593,0.5524365642051764},
{0.32313943287420516,0.692332210107408,0.6451798336661873},
{0.23731963165032874,0.5439484921251136,0.8048598824318226},
{0.28023296737993947,0.47586532188132685,0.8336796023798441},
{0.3700209517984437,0.4684479290335648,0.8022724182061465},
{0.3843576041849227,0.45067591623573966,0.8057049401799041},
{0.48104335799987674,0.4717351575723326,0.7389609115740893},
{0.5192279615326207,0.3991040374645667,0.7557236870987709},
{-0.09726354542380265,-0.5994235242608957,-0.7945006238476087},
{-0.008057176436587528,-0.5950320300511199,-0.8036615986353416},
{-0.24165092556325998,-0.397237096871325,-0.8853290456342553},
{-0.19165950165520387,-0.09561574691771019,-0.9767928461893276},
{0.27745179620244603,0.9174117786327228,-0.28526501574847946},
{0.33405863809753833,0.9359793915314472,-0.11111887751790796},
{0.37922734384922024,0.9252095977879895,0.013184151017496617},
{0.3268923171891147,0.9319977130113679,0.15659398425326254},
{0.3378714500395941,0.8742367519533091,0.34864449627417116},
{0.025391822217642385,-0.9967052745116101,0.07703149437213089},
{0.016419238091597375,-0.9980614726599968,0.060030870493854104},
{0.02417151834005625,-0.9978853989028956,0.06033629386650506},
{0.018952540503459292,-0.9961224082024474,0.08591245011883643},
{0.023103641537263405,-0.9972506914562795,0.07040795507391107},
{-0.0037840302711220873,-0.9974439792565883,0.07135257079944586},
{0.030091549236721343,-0.9994082413906797,0.016663304141819407},
{0.03198320702262787,-0.9992434679570276,0.02212614321929351},
{0.031373093835009046,-0.9970119820019934,0.07058921112802262},
{0.17023354967429405,0.016297148356607276,0.9852689691250468},
{0.21247528995425186,0.23231278384431867,0.9491496307860839},
{-0.01724315306523504,0.06189254941213982,0.9979338585295293},
{-0.26350786939914367,-0.5269547362820032,0.8080113295459961},
{-0.290668121841339,-0.3598865322114995,0.8865628724901634},
{-0.36989445121408737,-0.3424276751517378,0.8636674025637446},
{-0.14838553070899757,-0.2863637436476031,0.9465609016858552},
{-0.05438474019168422,-0.2747617395849289,0.9599730655047289},
{-0.08304202027256982,-0.37950266265338445,0.9214563212155211},
{-0.13071535443248117,-0.09912730216099076,0.9864518610058346},
{0.029176765138881105,-0.0034790912365700354,0.9995682129300623},
{0.1778965940224477,-0.039889030098978,0.9832403913148479},
{0.41637934911892216,-0.12400157110773023,0.900695202601922},
{0.49404490963892317,-0.22059287119394777,0.8409865709024601},
{0.5129987710969065,-0.08466010761214128,0.8542042654026989},
{0.3331844703535202,-0.12766416134915715,0.9341787680215498},
{0.2906975007394164,0.0014040410577563676,0.9568139796912278},
{0.5902484338192294,-0.2142164159612613,0.7782789432502067},
{0.5927973498014798,-0.43864695864480374,0.6754110953634133},
{0.522977376852179,-0.4766492804452859,0.7066117227670407},
{0.4916989864046447,-0.13214902774636103,0.8606792324869564},
{0.3562453395524072,-0.04339728500084441,0.933384129767453},
{0.24986183363857123,0.03058083637576798,0.967798468968271},
{0.24778799240360116,-0.11154859800088664,0.9623710412853399},
{0.17877744144486515,-0.015564038431385924,0.9837664291579248},
{0.254586101551892,0.04077317641878073,0.9661901805448723},
{0.2631943876880757,0.20182083090982914,0.9433965584526822},
{0.31700725029415644,0.16993303076611413,0.9330751139729218},
{-0.2615189215016355,0.21531287527072895,0.9408763040056184},
{-0.49767498299993546,-0.3595152116149233,0.7893468337261452},
{-0.3898540933792581,-0.3983083339464306,0.8302796257793247},
{-0.5304489703797265,-0.23331706590951604,0.8149767092245414},
{-0.3767587233432632,-0.20783526050668408,0.9026945047328434},
{-0.2744872238542512,-0.02649040763872122,0.9612257914995418},
{0.4452113827197528,-0.6078470796269269,-0.657501903028259},
{0.9637231292353062,-0.2605697387245539,0.05780260753570738},
{0.14896347805704255,-0.7235450364125251,-0.6740122124175101},
{-0.4890394352137742,-0.5423255722432059,-0.6831715776412776},
{-0.888826861140078,-0.08557456429944954,-0.4501819686091791},
{-0.9603129410868729,0.009552178458975429,-0.27876120796798104},
{-0.9656370922429909,0.018097582718335847,-0.25926334793845174},
{-0.9822844892819677,0.044832706950427195,-0.18195386916348097},
{-0.973298715723278,0.17490248801745076,-0.14865641478497765},
{-0.9818016223133531,0.07178158085279032,-0.17582087212029865},
{-0.8820153566588232,-0.3508530754440702,-0.3145648264975702},
{0.46054056999676135,0.8870829167561238,-0.03140512993932628},
{0.4560457346578004,0.8792529123648799,-0.13761033390811864},
{0.4312090426733763,0.8972101376933638,0.09525088102986516},
{0.3990683422427484,0.8766323253816084,0.2688126193385618},
{0.3524332012022753,0.8027398468189249,0.4810400991803548},
{0.3145961342377573,0.7036599040462335,0.6370965482250742},
{0.24635475139961924,0.7170603832250372,0.6520228088587045},
{0.34309570645267495,0.5370754981535575,0.7706070629684417},
{0.44036183436849874,0.5226406718583636,0.7300193031359166},
{0.5709003023964225,0.48159997027158813,0.6649318110589076},
{0.5311608732408929,0.39016139414934775,0.7520918914955866},
{0.47652575268109637,0.4213476233933393,0.7716147920384233},
{0.59161172902273,0.4753036197468537,0.6512158099572478},
{0.4578242848686968,0.3419721639938567,0.8206411903126879},
{0.5430020229167973,0.19196701809650604,0.8174946281605779},
{0.43391892375150215,0.2746403822512803,0.8580716916710449},
{0.5501133317770064,0.11969777117760719,0.8264670385298584},
{0.5330803632093416,0.13138529355441197,0.8358009517811148},
{0.35231437783534314,0.24238376374792028,0.9039494954044099},
{0.3807599844507914,0.2595364873040492,0.8875036033723515},
{0.2592898776092168,0.1933686375374827,0.9462438001838084},
{0.28410599094994354,0.029389930087357102,0.9583423281457472},
{0.9133399960351216,-0.044099627499409114,-0.40480275999179827},
{0.8334220349090814,-0.07233099915279351,-0.5478831429142207},
{0.8256000381649271,0.004852076625693267,-0.5642349105953027},
{0.9174953406326738,-0.14676677388734524,-0.36967798690216136},
{0.9280860075110249,-0.1269594633750729,-0.35005379204025105},
{0.8288965137003712,0.1090447777833899,-0.5486709451151405},
{0.5349756819269091,0.42486124827376215,-0.7302697717022794},
{0.8096003428475802,0.3343632065846007,0.48244018379851417},
{0.9356866867059798,0.0006410134868265452,0.3528314235196396},
{0.9430698450057567,0.028443538215812848,0.3313762703854693},
{0.9610302684361836,0.16041055300745583,0.22514279387384165},
{0.9746577949231681,0.18665459937495243,0.1232973776188435},
{0.21931038306093292,-0.07580951510256538,0.9727054401521464},
{0.16129140567806466,0.02154618777816096,0.9866715989865231},
{0.1564095610643948,-0.0832553632308984,0.9841771150056958},
{0.1230211197933984,-0.15686642786856966,0.9799279197433519},
{0.28535622234568514,-0.15430644623541748,0.9459182559919204},
{0.4091420849918719,-0.09222949879756208,0.9077975951940247},
{0.5327413686581023,0.2843765347739726,0.7970675131946099},
{0.34453376896040044,0.5870723498961721,0.7325588973136071},
{0.5188645276196698,0.27635540071708825,0.8089544452393561},
{0.5548990044660919,0.2947228447889181,0.7779624281429455},
{0.37633726846173954,0.526890576495184,0.7620738683141741},
{0.26777607994078506,0.6933373316868837,0.6690136885750981},
{0.18027825848683843,0.7914900867562117,0.583989034215196},
{0.1676432365737694,0.7239526136845397,0.6691699024690179},
{0.5780017488979675,0.26081630154817176,0.7732327173093648},
{0.6730141042828206,0.08344049253507459,0.7349079531763804},
{0.6012024176612611,0.1282119277351276,0.7887441629480988},
{0.827444750670349,0.4867857374190624,0.2799550507375492},
{0.8503378195060121,0.5051603089483044,-0.14744034380390716},
{0.08523914054462316,0.8838278260821073,-0.4599811547902701},
{0.3472175541870714,-0.46468644819655425,0.8145590677948525},
{0.5045072829157773,-0.3303671142493374,0.7977029342477718},
{0.11362353281774953,-0.1093513999872846,0.9874877032706962},
{-0.02578852933184984,-0.3012241828866583,0.9532045653474208},
{-0.1527777466731985,-0.05597163991101739,0.9866742804224358},
{-0.14621568389794107,0.1648938990062463,0.9754132333799738},
{0.08304265017674455,0.2130842342898174,0.9734983448104804},
{0.3405913902961046,-0.08545310150881488,0.9363200693666086},
{0.5455357354311068,-0.5699825301992885,0.614418974833345},
{0.47314332363768025,-0.7485212422702371,0.46459804688279793},
{0.41881198847859197,-0.689117853508559,0.5913654557736391},
{0.19425193217870268,-0.6302742691912823,0.7516784767706441},
{0.08444794651376993,-0.5735850132295629,0.8147814289292862},
{0.3159664675046605,-0.4757357491208313,0.8208779984998184},
{0.13827927535178508,-0.20184940193726064,0.9696059307500937},
{0.28099221068299185,0.02749780349468378,0.9593160315237377},
{-0.11463140210909228,0.37038399250925463,0.9217783571680386},
{-0.5075355505323359,-0.36934413328235427,-0.7784552499378146},
{-0.9042933098397552,-0.09558720386405632,-0.4160729458118033},
{-0.938538478282918,-0.15891566862610054,-0.30641693009281334},
{0.7338939750644949,0.501521233512023,0.4581223479602509},
{0.8199889801996366,0.4276653775758604,0.3804213416385267},
{0.77446288722263,0.565618176036196,0.28334310517864136},
{0.6509400882853661,0.5926490953411987,0.4743880808518471},
{0.6213046127271379,0.7287921027537744,0.2878239899100024},
{0.6973346053098515,0.7049957987287396,0.1292492631011105},
{0.7603192073907228,0.6221901713168444,0.186531749548057},
{0.8361032675296473,0.5368627295987354,0.11273746313467506},
{0.8817869287491232,0.44051195748295624,0.16852604428313986},
{0.905188580011745,0.3200513872456155,0.27964395959590793},
{0.8353964102404249,0.3356483880116389,0.4352619870636536},
{0.7586553041904601,0.35002913625346815,0.5494740514322143},
{0.7063174461518182,0.4087198820768137,0.5779824592984537},
{0.5355457602898194,0.6061666517499502,0.5880074225227552},
{0.5680878230827289,0.7122298379039106,0.41231648434727375},
{0.6097933312521375,0.7803012627233131,0.13885975857974148},
{0.673489668011776,0.7391664157739157,0.006684076101500427},
{0.7716463067965117,0.6341274006816261,0.04944104481165783},
{0.8131807464440337,0.5818455513477744,-0.013886251817122029},
{0.8605510201422033,0.5079014061903752,0.03857594227044437},
{0.9116878376552723,0.39479082699547974,0.11386610378720753},
{0.9408171207613514,0.3088855909226937,0.13947342758625766},
{0.9261017117821845,0.18476253360080147,0.3289352909183208},
{0.8738971776596174,0.23439009402370894,0.425869706250764},
{0.8160651988093232,0.24556138800347402,0.5231990023061084},
{0.7606886469156499,0.17862843945672913,0.6240550160609971},
{0.7027945535514294,0.3443471307804707,0.6224988907794973},
{0.22944301704565237,-0.8297551435874112,-0.5087851251945394},
{0.4836370997952719,-0.7797942844468103,-0.3975123012507982},
{0.33538072234607064,-0.6655422467068709,-0.666763293026092},
{0.57408837844495,-0.6379028651439105,-0.5133249150154684},
{0.6703524370318592,-0.6430678901205543,-0.3702584217291294},
{0.6736303389163896,-0.7057975489008532,-0.21925324731218418},
{0.3451737008087766,-0.9273610626818173,-0.14441805874482463},
{0.1340109319935072,-0.978055696977127,-0.1595246805883593},
{0.21576924050633986,-0.9354980496734092,-0.27979820211817824},
{-0.18473489801098283,-0.2166269162239773,0.9586166056480357},
{-0.17441658556482492,-0.33113280725483885,0.9273240634424611},
{-0.12357064903375817,-0.1467349581583604,0.9814270970131403},
{0.04422155355182455,-0.3079048542583915,0.9503888966762931},
{-0.05850586528608759,-0.4880675605874063,0.8708427642401265},
{-0.16434755774683243,-0.5278658508570542,0.8332751788944693},
{-0.3442233412777485,-0.511162931661992,0.7875422202106377},
{-0.49469054653039074,-0.53286974637966,0.6865355756016873},
{-0.6135599375042908,-0.6137429422579244,0.4968539060109289},
{-0.717076570009042,-0.5551725061247893,0.4214079747550917},
{-0.7560304425512989,-0.5759343818121987,0.31099446583868245},
{-0.15079264834577022,-0.11401749022786144,0.9819682220555859},
{-0.07074423396393763,-0.030091950244675682,0.9970404845799028},
{0.14252500036440258,-0.2267593646383998,0.9634660423802783},
{-0.012299304707204351,-0.3407174410510519,0.9400852899962547},
{-0.018189114037862834,-0.34385415581654905,0.9388468861631305},
{0.1277531734850954,-0.6132842344425125,0.7794623624324323},
{-0.2030445907616691,-0.5181247146045148,0.8308547853135447},
{-0.05981749894442208,-0.5755634228293965,0.815566436975519},
{-0.23639929801259116,-0.6290567759870067,0.7405423313248115},
{-0.3459325090872229,-0.6694646614415115,0.6573794689809083},
{-0.4757648379850078,-0.6688906433430458,0.5711682118126196},
{-0.4587600743986367,-0.7494529234350817,0.4773463204973586},
{-0.5838594004207521,-0.733859815500502,0.3472145903240369},
{-0.7057840913470451,-0.6287536625360405,0.32640105430120925},
{-0.7026509425921869,-0.16013622868463748,-0.6932806366378429},
{-0.7194667871947826,-0.22172433070648487,-0.6581837610397105},
{-0.6510680762336571,-0.517088562214816,-0.5556345732007855},
{-0.8611296218107377,-0.28608751882713895,-0.4202495758610914},
{-0.7179757452462481,-0.5726411289775322,-0.3957182920227873},
{-0.8677943995584553,-0.4044456341280115,-0.28871544664214055},
{-0.9636937462021339,-0.17777198234518338,-0.19922722159373998},
{-0.9803563510216918,0.13290940331433088,-0.14572753865368662},
{-0.9829326252315491,0.1668788412321726,-0.07742678221663499},
{0.016419310170414265,-0.06531123376757146,0.9977298477029167},
{0.026307393870370125,0.14050910368130518,0.989729818086949},
{0.04080411160146366,0.17478476155439104,0.9837607999939771},
{0.18042869682096277,-0.0375997703853201,0.9828691381005206},
{0.3671430274505608,-0.13132279826069515,0.9208476095703445},
{0.27409220143264856,-0.18900458672965886,0.9429478942703861},
{0.09528168941518678,-0.2586212998291241,0.9612681326960143},
{0.5565170632288314,0.1426770927109555,0.8184937419129765},
{0.12018478958684131,0.43209102918466974,0.8937857454950261},
{-0.4862940210245768,0.7154936867631952,-0.5015843989975756},
{-0.41487999108117646,0.8456904041941826,-0.33568189294980283},
{-0.5795266418756004,0.7809223401144946,-0.2330432793849489},
{-0.772777233999826,0.6210966550335616,-0.1305920813744043},
{-0.9302212893851838,0.3666558147801861,0.01587029497028917},
{-0.8733961173285265,0.12738649659515172,0.47005521241729487},
{-0.740448327495611,-0.28989826035781446,0.6063788196750157},
{-0.4069809046118518,-0.8166789220833924,0.4091479946254498},
{-0.23429698520382897,-0.9650196517867479,0.11765200546433825},
{-0.04162783340801601,-0.9987079945848776,0.02914558350773841},
{-0.7124275777789585,-0.16516682946032063,0.6820314251308596},
{-0.4943750159030054,-0.11792543499965817,0.8612124798393509},
{-0.4373704583123465,-0.31746086521909284,0.8413831952505308},
{-0.45699257113485464,-0.5959761778451405,0.6602803839041809},
{-0.19053358629841227,-0.5713257493888043,0.7983005953759439},
{-0.19431655022649355,-0.27317880275394324,0.9421329099622817},
{-0.12357094010951196,-0.16165953811460296,0.9790793719086439},
{-0.1361442606130596,-0.11761908908123697,0.9836821082981144},
{-0.21521901499218768,0.1419433289471608,0.9661950460197933},
{-0.6283101383841455,0.061009440958166385,0.775567030061018},
{-0.8883526110538574,-0.1796969669460673,0.4225383278522528},
{-0.23102958262407222,-0.8278314205819558,0.5111951398925932},
{-0.23231200672186683,-0.7499781633146857,0.6193253475226006},
{-0.08957481681783096,-0.6426792100358418,0.7608809270705623},
{-0.026490540915016517,0.5096084057837141,0.8599985604619411},
{-0.010376238749618929,0.5223360185674593,0.8526766194616255},
{0.09442543533677816,0.4284865133133812,0.8986006593977112},
{0.0175792239741444,0.3480074339083095,0.9373269423360349},
{-0.05011119085091341,0.17386466217204222,0.9834937456838783},
{0.2798310881892699,0.28105211911827915,0.9179892528902143},
{0.055971212415100155,0.6287753862514476,0.7755699433481978},
{0.014069334684512299,0.5619203670886526,0.8270716745678631},
{-0.1375486247228094,0.4056877919796396,0.9036026733446225},
{-0.08804851078271161,0.4203739873434594,0.9030687518200969},
{0.028169073877732567,0.3262738557034129,0.9448554780289414},
{0.11292167233358902,0.20856978291247033,0.9714665931328933},
{0.1803687527312738,0.1336135207271157,0.9744816776712988},
{0.38325758528594495,0.12787519720305918,0.9147467175459365},
{0.030305547680184734,0.02743649583083809,0.9991640568376788},
{-0.0789516833066431,-0.04229936609020401,0.9959806199577452},
{0.1363273149936522,-0.11163807684481573,0.9843534949320861},
{-0.10300324740588539,-0.030854972771467846,0.994202344434529},
{0.0071410923451721425,-0.10135331065227376,0.9948248645967497},
{0.1706644975505587,-0.1202761696583754,0.977960772366727},
{0.05853596553114405,-0.06586008634006349,0.996110430507891},
{0.04281793344210849,-0.16944269389488803,0.9846094647429459},
{0.14307381404329464,-0.18781469402803647,0.971728112407097},
{0.0028080273535629236,0.4402032881093466,0.8978937465647598},
{0.37443461127470934,-0.918705406972332,0.12561487602731963},
{0.3491692101796273,-0.9364493372374669,-0.03381569827823216},
{0.4602908156998131,-0.8802046826408366,0.11563771720137284},
{0.5316718122603047,-0.7935861533919922,0.2958819041312677},
{0.6300685427414564,-0.6885427995916062,0.3590577176140494},
{0.7960565341665851,-0.527245639330593,0.29716330563775695},
{0.568548146560449,0.21205014105017916,0.7948507675804793},
{0.8661655478095829,-0.026002586831948397,0.49908026335026745},
{0.7710990239062214,0.4836993061366477,0.4140546782416522},
{0.8557472862025813,0.3559404465720134,0.37550363600241343},
{0.664306761812536,0.4081006112563151,0.6262191447906752},
{0.6150469312289533,0.3639071010259654,0.6994918828755091},
{0.5504761906232049,0.2219977228379552,0.8047937466281204},
{0.75918889575983,0.06888098856913277,0.647215288732203},
{-0.088324063394584,-0.32311020661820744,0.9422306799317293},
{0.9982781710337864,-0.036134657736596514,0.04620584105605363},
{0.9984098718075255,-0.035035942978573,0.044161188580955725},
{0.9993219647006055,-0.03665387899522594,0.003479083431762504},
{0.9611547772428394,-0.26768796419882324,-0.06726550383634608},
{-0.21610613241351864,0.9149014948820908,0.34095951987851303},
{0.07574748063178778,-0.28104678329387034,0.9567000704390615},
{-0.18171094981743496,-0.28215013304545433,0.9420044761777293},
{0.30449044441984857,0.06299154006629684,0.9504302368596441},
{0.2858712461065973,0.07870816906922434,0.9550301852670583},
{0.17368497861281096,0.16193470944865063,0.971396251835495},
{0.07419130528738313,0.2073466479606669,0.9754501616173066},
{0.15824215172174497,0.3408089416370953,0.9267193138802466},
{0.20689316001577038,0.44427552254772507,0.8716733794281174},
{0.014832240504178513,0.367631961137347,0.9298530775299583},
{-0.23649181843139253,0.18836304133713802,0.9532003905125286},
{-0.22987241494362953,0.035738152797687724,0.9725643717937609},
{-0.15888222905061214,-0.03967480633283182,0.9865000491811245},
{0.3169459311286452,0.5808480328319332,0.7497738589043162},
{0.5223352394785805,0.3297900963405179,0.7863869212763942},
{-0.0655562901844608,0.720292163137124,0.6905661246690961},
{0.017487060401022984,0.6415622159821758,0.76687164880609},
{0.06430322594584073,0.6012264624277416,0.7964871850881102},
{0.5455565585499897,0.2514144832849322,-0.799474076513843},
{0.799234330034523,0.5460474736825086,-0.25111081653170025},
{0.8636688464460719,0.34248924944914066,0.3698340677794246},
{0.26411065554456625,0.3189534146209069,0.9102275984222206},
{0.30760212596579767,0.16950337569800228,0.936295646539224},
{0.188182798592821,-0.48467893471142054,0.8542093212794954},
{-0.060885483596632095,-0.5817581757019766,0.8110797635813092},
{0.009461246048078131,-0.9233000112340539,0.3839629852972986},
{0.018250339588724664,-0.9914124474643342,0.129492409498299},
{-0.005676154652888125,-0.9995392335125997,0.02981781241810522},
{-0.08044827455496618,-0.9965977892592304,0.017914283818882795},
{-0.8610207850801924,0.16819340429864565,-0.47995227513818667},
{0.561492946800958,0.008576197748388217,-0.8274370788917772},
{0.5483672302310295,-0.023133431572742585,-0.8359175947139875},
{0.7049998321503318,-0.13132506682167913,-0.69694258263668},
{0.6813789300443065,-0.015503521730896745,-0.7317666257117879},
{0.7465649121188271,-0.053530499449206875,-0.6631555757299539},
{0.7849887327445207,-0.0999507671791927,-0.6113939266990165},
{0.7994563605623427,-0.2645420609695368,-0.5393394344329028},
{0.7210816160574134,-0.1600435757199632,-0.6741122731821441},
{0.5310042771665803,0.09976730668545644,-0.8414754554635135},
{0.6010415712809691,0.08697938510241739,-0.794470651540577},
{0.5676675659450939,0.011383472569344527,-0.8231791731611262},
{0.6963578500492715,-0.15937185638451895,-0.6997759327579853},
{0.6427895834795556,-0.1368158269677727,-0.7537260648679359},
{0.7278327008698972,-0.061070324299397336,-0.6830299957061894},
{0.7537313340673707,0.05121104184810996,-0.6551843292065622},
{-0.0018620243637129075,-0.8076525677539312,-0.5896557153676629},
{0.3918136265183245,-0.775477907221092,-0.49509200911199785},
{0.3582358405066823,-0.6817407269765356,-0.6378845222749769},
{-0.3008897644207875,-0.534026780490817,-0.79011438879786},
{-0.16254372456645158,-0.24964364868460795,-0.9545981281541995},
{0.40199947790849977,-0.3537183395880879,-0.84455891209574},
{0.956419609921877,0.2117437767958733,-0.2010624349427408},
{0.8981906690562762,0.2615219297640888,0.35335506544084777},
{0.6490199078762002,0.4230564138556452,0.6322945752384483},
{0.7315015690553359,0.2999984637167752,0.6122959874416591},
{0.2784903618112407,-0.9193709058339566,-0.27784934026247793},
{0.25312898104123305,-0.8614121599322163,-0.4403348835578904},
{0.06378474484174504,-0.718353388519744,-0.6927480895157166},
{0.44943089524488916,-0.8630616039835753,0.23051363978878905},
{0.451076038874701,-0.8877766940813996,0.09155844362487833},
{0.23847875661515427,-0.8992834786315811,-0.36662938739764517},
{0.9818435524249961,-0.18848229801553418,-0.0213930338252264},
{0.26457531924165845,-0.3048308893312536,0.9149196846487082},
{0.11304373641032939,-0.9075509687700023,0.404440790157252},
{0.97597273264745,-0.21772384820474608,-0.00857619097186696},
{0.9732791534091698,-0.09302125713846059,0.2099398372379811},
{0.9267967009264593,-0.20172932919551206,-0.3167856576522365},
{0.19010185428980989,0.39601186277537637,0.8983517626947433},
{-0.018983038010107266,0.05182010376040449,0.9984759992679683},
{-0.18915543346039462,0.0036320275242826125,0.9819404413550106},
{-0.03152663146949352,-0.09396788215004848,0.99507593108889},
{0.11237028468281449,0.02215625330324589,0.9934193573510965},
{0.20173201470172072,-0.12876120077611902,0.9709401358575496},
{0.14694916048852302,-0.14264609722365804,0.9788043906616771},
{0.28013739828342993,-0.1138684136792076,0.9531825756113945},
{0.3377287869166444,-0.19709529514155155,0.9203763964383683},
{0.3317137473199383,-0.05874937211733203,0.9415489902892911},
{0.12476382968047406,0.08551562493961509,0.9884943422673944},
{-0.27427777163060735,0.6486893805425227,0.7099111152536679},
{-0.6179733523145126,0.47139231996133424,0.6292044314136976},
{-0.3672683403146814,0.7714945199067405,0.5195287980048532},
{-0.5179405691717571,0.1609882851507256,0.8401311438402131},
{0.07309465302628988,0.5789270125983332,0.8120964756621811},
{0.8445788331144471,0.23438472885345113,0.481404604813179},
{0.7516882605369235,0.6437717825198369,-0.14325728952554567},
{0.6541464862628771,0.652650457706879,-0.38228229695466265},
{0.5814005012609871,0.5814615036218899,-0.5691010252488077},
{0.5561209200258159,0.4886433523597115,-0.6722776186251502},
{0.607151531262743,0.19358427082989865,-0.770643982765429},
{0.35887434699372217,-0.1492690558852303,0.9213728626484293},
{-0.10348908905018425,-0.26285876615042547,0.959268094697952},
{0.16767106915130842,-0.15802695013768503,0.9730950085165573},
{-0.48119973965022017,-0.1937069334455299,0.8549411877408232},
{-0.481168778018216,-0.3082758273183099,0.8206354984715617},
{-0.09784454560275065,-0.24128527747272205,0.9655091194653227},
{0.3592105306220237,-0.1625454076618652,0.918992266092747},
{0.250527818207729,-0.19119938763114952,0.9490408876721533},
{-0.34870804587021537,-0.1571718235793732,0.9239587201916059},
{-0.4058158515142518,0.16791749011301627,0.8983970231328172},
{-0.7732926532439206,-0.02884054650404469,0.633393002263465},
{-0.7783707820008549,-0.12763239154564704,0.6146941502533732},
{-0.14652166260917884,-0.26740785936760586,0.9523783067325068},
{-0.6572027167216696,-0.11121182880326141,0.7454639617499231},
{-0.051516577063685974,-0.16550706662514136,0.984862149330952},
{-0.3898877833655082,0.03955339829707182,0.9200125244068603},
{-0.813647595730711,0.23768518497889554,0.5305500379824525},
{-0.8784160079472607,0.04202553133706406,0.47604534626213435},
{-0.8671950389212951,-0.21375496747457534,0.4497572437996264},
{-0.8029296779911025,-0.3209094650922714,0.5023156850181933},
{-0.6628527767000588,-0.25004621476745853,0.7057641864684606},
{-0.24195531057230402,-0.08203546150868724,0.9668132243307993},
{-0.30714745128672505,-0.27397343048326034,0.9113720439849485},
{-0.07574911298117404,-0.2551721178903623,0.9639238881436192},
{-0.03680628757054009,-0.25029075575954124,0.9674708444064826},
{-0.24338708145485585,-0.25324516576153855,0.9362850071422154},
{-0.38801747172031026,-0.2674377713370964,0.8819974376958389},
{-0.6865394876673473,-0.3326033478454492,0.6465590033983406},
{-0.776598700976148,-0.0730943248830744,0.6257409027001887},
{0.028291819418863776,0.26533568494462156,0.9637409129267777},
{0.6179828632272577,-0.37636244294945437,0.690252484453739},
{0.7178977972920658,-0.33009296464839644,0.6129122182929889},
{0.7979273208039174,-0.25685086311490496,0.5452885702376411},
{0.8602126012696782,-0.11490435111932593,0.4968211657233419},
{0.39147012808370985,0.8577430003763948,-0.33320876957760853},
{0.4903544653545421,0.8237786213320855,-0.2845018125479515},
{0.5614562583543887,0.8109484837222817,-0.1647101293279259},
{0.5775148955162347,0.814649190564337,-0.05313418645037437},
{0.5586547668940226,0.8283534130606711,0.04165902660075289},
{0.47072027728389454,0.861726999580119,0.18933831822538966},
{0.38952250277821593,0.8412743224905642,0.37487295734346726},
{0.4381658259307688,0.7023409559181233,0.5610061413446595},
{-0.11408034521403286,0.6249098466243579,-0.7723168769538631},
{-0.1487803885914566,0.6081827640567283,-0.7797295181502961},
{-0.1143554031700281,0.7142400096990312,-0.6904955107102059},
{-0.04541349989177484,0.7292940867188108,-0.6826915475561093},
{-0.01968427618704647,0.7901660866986234,-0.6125765949678258},
{0.015198227952605003,0.7167987509995943,-0.6971144557621238},
{-0.038697936764747344,0.6356853880984816,-0.7709776631318409},
{0.03930828423066168,0.5164077340452481,-0.8554401855238588},
{-0.024720742462346994,0.35283459702811965,-0.9353590925586358},
{0.17853843527779237,0.4920339790791849,-0.8520719397797711},
{0.1081611542620704,0.6119138450077093,-0.7834938487292531},
{0.1627279779444443,0.7164661114286738,-0.678377414400264},
{0.17740894551572922,0.7972882254940328,-0.5769380829340125},
{0.10938217396114483,0.8585187605844629,-0.5009801171144935},
{-0.047854191073145494,0.6977923677943724,-0.7146997886138334},
{-0.11438580980554075,0.7257788282374047,-0.6783516632230444},
{-0.028687616899667392,0.5987858763155626,-0.8003952117308185},
{-0.08914643648181529,0.6604616425021189,-0.7455490135772408},
{0.11923985072112069,0.8386450831296318,-0.5314661631209439},
{0.18070519749477704,0.4074647196172628,-0.8951637469567224},
{0.06463996355142285,0.14002325345008626,-0.9880360133139499},
{0.19047144076584424,0.2740948294456121,-0.9426519266005688},
{0.27260038889063365,0.4710082224445316,-0.8389518951443629},
{0.28092610956949465,0.5924925582967276,-0.7550053571499655},
{0.35460141195449635,0.6838713658618704,-0.637634529800651},
{0.313983050387143,0.7945109013357173,-0.5197759822541735},
{0.26634593543214996,0.8531490279545054,-0.44854941620634786},
{0.9413117987561,-0.3203631416163413,-0.10629936507930506},
{0.9938841935565926,0.10687795645545213,-0.027772508389917447},
{-0.7939656327479316,-0.14319780342075974,0.5908578197084694},
{-0.7647199662479007,-0.19358354803087005,0.6145964392620489},
{-0.6802704749344213,-0.1938875555483145,0.7068519623909919},
{-0.8209105522570912,-0.27537690067510256,0.5002733530456447},
{-0.6166718830072714,-0.37407402805305856,0.6926647170488951},
{-0.41267979419550205,-0.27397083831131996,0.8686975119210085},
{-0.9333334477958772,-0.038118671751487705,0.3569812909514487},
{-0.937302660107863,0.2439998576237491,0.24885295424068},
{-0.802972461379865,0.09216949652096494,0.588846338340176},
{-0.6294243186349174,-0.4440822801809317,0.637664453721763},
{-0.6882126641139755,-0.5598178089598072,0.46148385640733436},
{-0.4868463870960073,-0.7997932779855834,0.35115709854798605},
{-0.31309979816069966,-0.9410094534584756,0.12833442598737926},
{-0.7938393933546165,-0.4421344721374445,0.41753577823477317},
{-0.8493832286406157,0.2534326324159888,0.46294711547945266},
{-0.9015122482943725,0.30577390286674316,0.3062319162021902},
{0.5051749292498153,-0.8497302450975366,-0.15085357610585362},
{0.5384837530010909,-0.7891386202677626,-0.29545809475414986},
{0.8634129117982238,-0.4169197176468039,0.28407057710615163},
{0.7903208122172982,0.14505653511277006,0.5952744034453925},
{-0.588445150591086,0.4038024552870188,-0.7004826063864893},
{-0.18561506968667318,0.3122977997503922,-0.9316743691742708},
{-0.3273162548017205,0.2319747241693982,-0.9159977056134512},
{-0.6689571289671227,0.2340537424506704,-0.7054893374452229},
{-0.31733471228092497,-0.6782509343920116,-0.6627777533818904},
{-0.1752130065993985,-0.32366009561769066,-0.9298088754271743},
{0.09851439622628952,-0.21860487923190403,-0.9708279046835099},
{0.05734565565259004,0.13868000389366938,-0.9886755445027586},
{0.1209776565469808,0.16913771409313536,-0.9781394789536662},
{-0.004791074280783007,0.4124643948451675,-0.9109611235350528},
{-0.1323628193856482,0.5923200916490573,-0.7947559330216634},
{-0.31999217449161477,0.6673587916466298,-0.6724858745550558},
{-0.5240993373025771,0.5273343702473806,-0.6687588104801296},
{-0.6758530527743779,0.48913523652772245,-0.5513341740201879},
{0.6435791553303809,-0.1562252514277044,-0.7492660019249399},
{0.6880237178416764,-0.14176103247748265,-0.7117072244667996},
{0.6226268513020355,-0.03909518368668853,-0.7815416627731481},
{0.6450225849937147,-0.11331738660788108,-0.7557149163146021},
{0.7484553210168704,-0.21494754876837585,-0.6273851956493715},
{0.8132139475789975,-0.2227289156126993,-0.5376568660521082},
{0.8465459434794247,-0.1343768006775497,-0.5150755682598397},
{-0.2794041792626173,-0.14920883390615794,0.9485093718540413},
{-0.2781483232640166,-0.18784256897541632,0.9419918680891741},
{-0.069798787091863,-0.8572382298454544,0.5101673711753201},
{0.0028380424790649538,-0.9950708939564683,0.09912548368387404},
{-0.006226180569572276,-0.990415723700125,0.13797800159109627},
{0.0039980100335984805,-0.9944174956380274,0.10544126462047458},
{0.02328646362589236,-0.9628171693756726,-0.26914835865599707},
{0.08899435179688323,-0.9602593761610974,-0.26454099085577026},
{0.056887950721140286,-0.9828044247952611,-0.1756679357925204},
{-0.034822830007012986,-0.9990778131591049,-0.02511759868146991},
{0.12256307804279558,-0.9683605175249848,0.2173849120785972},
{0.02038646951390314,-0.8882924579639835,0.45882556705687566},
{-0.024232852305098838,-0.6632513275258375,0.7480043084129754},
{-0.11572912819546323,-0.6046493438657478,0.7880393009551229},
{-0.12336044191193987,-0.6233934468942562,0.7721158020275125},
{-0.09796632716346898,-0.8896971345135605,0.4459165926274326},
{0.0168162779943334,-0.9998335285121572,-0.007080117043284995},
{0.11157812519791005,-0.9366618403408552,-0.33198632325233185},
{0.11520971223070882,-0.7610579165854388,-0.6383710283294102},
{-0.4267192693973527,-0.7164075621431613,-0.5519699901526189},
{0.11182163383055947,-0.4277532499205895,-0.896952105404652},
{0.19129446050415477,-0.53390344928132,-0.8236222047916953},
{0.1956285971926314,-0.574585502526094,-0.794720675613312},
{0.2269104719093302,-0.590852248306405,-0.7742126700133184},
{-0.07623639100914904,-0.904951511744793,-0.4186296383161539},
{-0.020051594075794054,-0.9996636173937616,-0.01644948735488187},
{0.3108340155114595,-0.9435191534152549,0.11469011264961916},
{0.5420466468105996,-0.7381924138963099,0.4015686650466198},
{0.1894009236942042,-0.7340123306078711,0.6521910675709869},
{0.058322120568743745,-0.8894480893602359,0.45329970944816483},
{-0.07190232615181225,-0.8134746899535601,0.577138617923734},
{-0.07641989213387237,-0.8157491977082831,0.5733351956094617},
{-0.1194221490180652,-0.8313769224069335,0.5427253110120097},
{-0.231973946698742,-0.6271019658970342,0.7435934456550058},
{-0.4054765198890674,-0.8139740958060552,0.41597471458655455},
{-0.054446130909417405,-0.993611638468527,0.09885105325126277},
{0.14774101316849744,-0.9874027713450771,-0.05664238843840552},
{0.36634958126335154,-0.8661891962209419,-0.33985917768729684},
{0.3217096138818822,-0.6218103133328741,-0.7140412162955604},
{0.1851618755701454,-0.4561134734260178,-0.8704456210439566},
{0.557563976595654,-0.4475708384488575,0.6991443031113304},
{0.4403591379725475,0.3065939697148312,0.8438506783421911},
{0.44042131326549183,-0.1610800405003159,0.8832226714560243},
{0.2855965013811934,0.3755669194347964,0.8816938966699719},
{0.2193756012944005,0.6290726647264177,0.7457492393899736},
{0.4289159403443358,0.5557845848004171,0.7121338437518344},
{0.6065757807463008,-0.46884106207744475,0.6420699967465456},
{0.26027195387503976,-0.5075424105190992,0.821376412828206},
{0.2381093388311154,-0.5420798777857783,0.8058866848764563},
{0.09561524605429299,-0.8962186794881477,0.43318564525904824},
{0.088170712056031,-0.9482091661066087,0.3051643865967033},
{0.03527995693716317,-0.9789995544841248,0.2007864461521176},
{0.06552412664128247,-0.842172480563606,0.5352122025974742},
{0.07892227986098711,-0.3330844015384717,0.9395882370449847},
{0.31233364363911387,-0.02407958929191365,0.9496672408958033},
{0.3193240541846372,-0.05078443995320743,0.9462838311403856},
{0.2825455382689307,-0.02450648035966028,0.9589407965170227},
{0.23914763347599877,-0.4443276088299566,0.8633547274639101},
{0.06280842172083141,-0.9585166968221425,0.27803029344678826},
{0.01376436070529742,-0.9997822000352606,0.015687411100261596},
{-0.021516606934893656,-0.9982881594546822,0.05438553409310544},
{0.17722336742713976,-0.5608154916182585,0.8087508036464359},
{0.056673424879028586,-0.9983904849046141,0.002136016013650328},
{0.13724694594051165,-0.9401868813250306,0.3117882358497756},
{-0.17148808075542893,-0.9825363805792886,-0.07220871828921215},
{0.10553390501014673,-0.9917995052156049,0.07208561817304944},
{-0.20747129172809084,-0.9782396658777901,-0.0016790509185234351},
{-0.6348546133401543,-0.7710304608952813,0.04971567451351314},
{-0.8205498128841858,-0.5289955752138434,-0.2164756013501348},
{-0.3636413141235333,-0.9038080914340928,0.2256012600159235},
{-0.15955248453276347,-0.9866721803470363,0.03195329730478274},
{-0.2546236147266349,-0.914972362993924,0.31303736163732465},
{0.4346285578791812,-0.17451084523900867,0.8835405941833289},
{0.3042777645670204,-0.06879075540408441,0.9500962445779019},
{0.4203729168268372,-0.23362506709971137,0.8767587688875158},
{0.5808377150273679,-0.2233377355222582,0.7827820927266897},
{0.45051853252441554,-0.1463984728687163,0.8806818602615559},
{0.4122232904848701,0.13175096933825797,0.9015063177040169},
{0.513905369715595,0.07712065575366982,0.8543732646996872},
{0.5998038848926845,-0.1726198739254076,0.7813051124839896},
{0.7002089414428582,-0.2611245554092675,0.6644707705277821},
{0.6622369709119508,-0.6887276097764047,-0.29512111732142204},
{0.7077742397137846,-0.5597552160527214,-0.43096371506119335},
{0.6493848261128725,-0.6507278505710338,-0.3935131663687465},
{0.7195840677153408,-0.650672241672851,-0.24253742681629775},
{0.8058031812502657,-0.49160614246715056,-0.330158497960478},
{0.8247797681930485,-0.3108063188508693,-0.4723746036164442},
{0.6891639245443564,-0.31954102029743486,-0.6503434642201725},
{0.5212962683586209,-0.6058947724731187,-0.6009506845699771},
{0.5285009210577728,-0.38448067248499784,-0.7568760723702194},
{0.7724707036715045,-0.2808980740545019,-0.5695483157395185},
{0.8001129344945644,-0.5252298650012662,-0.28974623546346295},
{0.7765963485721494,-0.5643032392878624,-0.2801070608064531},
{0.6709109928287113,-0.6079498350833009,-0.4245885510983312},
{0.7612982124032185,-0.4638596596295802,-0.45305545792981455},
{0.7541503066244118,-0.2984128911887941,-0.5849846676543332},
{0.7634397942860542,-0.10925868971971842,-0.6365706710344086},
{0.6811920276290219,-0.2114379060615429,-0.7009075783403773},
{0.4252251326075237,-0.4955119727522974,-0.757397829055537},
{0.3449551077742007,-0.4210080134229552,-0.8389029897754248},
{0.30787752455821926,-0.35274047529645325,-0.8836207257412737},
{0.4757410557999173,-0.23649697576953574,-0.8471951535969995},
{0.5895043400383393,-0.5495237744115449,-0.5920373758745742},
{0.7531303166939989,-0.5585687764514019,-0.3475566832186957},
{0.8267263830619768,-0.5217205524179962,-0.210549644345277},
{0.6772532218334497,-0.2735139551707253,-0.6830213685113217},
{0.6918114785551978,-0.014466365491431684,-0.7219332395787988},
{0.605442550541416,-0.021119577330481618,-0.7956087489760822},
{0.5215114921734205,-0.01858640957533115,-0.8530417978681645},
{0.6716370950550189,-0.2255064040165537,-0.7057269119805326},
{0.618715935766652,0.29664668157823904,0.7274553849804227},
{0.5601906134625179,0.05853746750349178,0.8262928303493656},
{0.6358051198223716,-0.02136344083405473,0.7715539209954088},
{0.532226019462406,0.04971630958635565,0.8451412620197384},
{0.6253423779644279,0.03308297226368923,0.7796489128242241},
{0.6099645410704395,-0.6084074860826018,0.5077239304143314},
{0.7560450091427544,-0.5213549021229926,0.3957082387096039},
{0.6050080476886346,-0.7266258664415598,0.32554586842723016},
{0.3691356953324229,0.540595521166851,0.7559730953716473},
{0.7434506605231044,0.12964642849463748,0.6561043506534191},
{0.5998135081725138,-0.3419004296864751,0.7234140250188583},
{0.582165101643347,-0.521064572080569,0.6241598402261115},
{0.6859135368964037,-0.024598377876431123,0.7272671721644766},
{0.7295884659626423,-0.19275829352477208,0.6561592113288482},
{0.812892891667335,-0.09305476522714513,0.5749312631482472},
{0.8432698797770745,-0.0419326404628865,0.5358521843984297},
{0.6467145029193562,-0.3315981019194939,0.6868792110095915},
{0.5808432011591041,-0.14029767170903498,0.8018339846752994},
{0.5729662478307767,-0.028779615198291524,0.8190735086643686},
{0.7590821272362746,-0.053225832007155575,0.6488153319070059},
{0.8082424728645266,-0.034608876646386184,0.587831889841909},
{0.8782104769235798,-0.014740159063646667,0.4780471586908942},
{0.794017775234521,0.2629228859084818,0.5480942698817213},
{0.6934508481116869,0.3911299906375494,0.605097720766698},
{0.5089501143749744,0.33736732180573314,0.7919299661304194},
{0.5787251983342252,-0.031617174732830614,0.8149095036106313},
{0.6439969638273798,-0.23487946956328265,0.7280793537512154},
{0.5537406271344059,-0.42110360256757023,0.718361381037016},
{0.4419229807385377,-0.4232143465349103,0.7909448122228218},
{0.7680472223415862,-0.020020474996749544,0.6400801862534714},
{0.7067327213643879,-0.06070235033194292,0.7048716799652718},
{0.8318656910408847,0.06216769576620545,0.5514840429896335},
{0.8981124394829412,0.07275708874747758,0.4337054900309566},
{0.6250618146509782,0.0931137599964513,0.7750016487495683},
{0.6392250479742184,-0.051638215613405175,0.7672840626069471},
{0.6201506320233723,-0.061282445916741285,0.7820854527629788},
{0.5469358244310865,-0.0007930200444923618,0.8371741605383534},
{0.5488581645618453,-0.045596093638818495,0.8346710198866871},
{0.5850531973968379,-0.18006306179077883,0.7907528374873318},
{0.5380508555446475,-0.3742858558407168,0.7552558341153381},
{0.596005041667409,-0.4160343114296217,0.6867994190593866},
{0.47754225918487725,-0.3330314310917578,0.8130457899759271},
{0.5909053230676486,-0.18894202180135952,0.7843033925515892},
{0.38554816537414077,0.1255256584589362,0.9141093595654104},
{0.46099382463011607,-0.15735703625526082,0.8733404014437086},
{0.4163447298163711,-0.5111694013428847,0.7519061836990635},
{0.2053982191116399,-0.5375435100702416,0.8178377261823588},
{0.7518203237243626,-0.027436997154405014,0.6587969429362465},
{0.7738238393141603,-0.015137525030076938,0.6332199626078258},
{0.8725432874435589,0.13919807695342043,0.46828635140227665},
{0.5413233830030394,0.48516768346626515,0.6867177833245056},
{0.5366581589576809,0.45532395217323035,0.7104070093977835},
{0.25276065682188964,0.7768994607845288,0.5766621872428219},
{0.6695991466919013,0.09406125150774051,0.7367424677010788},
{0.7088742346333394,-0.6442342983161766,0.2871576019297778},
{0.6111452815788939,0.36552734563952083,0.7020621086439437},
{0.5087003202867891,0.4626166606340871,0.7260921494162322},
{0.4445686609346369,0.5125345263809798,0.7346203543206576},
{0.6168869926120958,0.35374917084220653,0.703073226964628},
{0.5713882907787382,0.27168564792848826,0.7744045001616594},
{0.7016221903065637,0.021943037226503946,0.7122112082709008},
{0.7771073292339697,-0.015320282493684046,0.6291816016025582},
{0.6132608072843135,-0.16587389840279973,0.7722674614909331},
{0.6191100840803555,-0.3946117022158763,0.6789582522249095},
{0.7259561728857998,-0.40849684970482625,0.5532792774270833},
{0.6115964843711152,-0.01843316529578226,0.7909550927341391},
{0.6668171811700058,-0.3791723383610079,0.6415474921767936},
{0.5971143554360748,-0.7077469415865827,0.37755623846918396},
{0.3235964184586811,-0.8757207821409636,0.35832732199363915},
{-0.8470364728255159,-0.3123053919223214,-0.4301099346441025},
{-0.892873310098668,-0.2545616457995928,-0.37145069740310166},
{0.8364352303994819,-0.1422184195835503,0.5292920049251859},
{0.7360356043104508,0.1796980304006818,0.6526562702199874},
{0.8207562481664834,0.09570859436433907,0.5632042667278725},
{0.758814240200127,0.15314245211294478,0.6330468689049321},
{0.7926769242760522,0.3093437754890916,0.5253282043507776},
{0.5787705486949953,-0.795092107703688,-0.18125449575279817},
{0.5622148749985296,-0.7989790857398101,-0.21341709135110276},
{0.06848608568564471,-0.9975583797942555,-0.013672416381842977},
{-0.05130367219028472,-0.9511710024378661,0.30437092065625604},
{-0.16520129152033622,-0.9716432408845561,0.16916839457584676},
{-0.1413940544614171,-0.9878983542036507,0.06375392634716763},
{0.18341874582036255,-0.9828027127802508,-0.021363319813758917},
{0.260844478308204,-0.9515150404349221,-0.16303154897825695},
{0.01858640297039081,-0.9973666238300025,0.07010251988740807},
{0.01583933347395574,-0.9995940449878377,0.023682498600304303},
{-0.016938164332216694,-0.9989716919140308,0.042055408016966174},
{0.6707215741980141,-0.5665289994957365,0.4787248297672657},
{0.38319612930080554,-0.7640432210282726,0.5190363020922741},
{0.5622256638368311,-0.7577014145071285,0.33134705276662857},
{0.7260891062710755,-0.587316690128432,0.357566378804068},
{0.5210227536975782,0.026490546754103256,0.8531316082891675},
{0.5432660746195319,-0.12799643121328091,0.8297462779453421},
{0.6059611608085128,0.0035710952400749233,0.7954862153867821},
{0.5126027828956559,-0.11530210025007606,0.8508488776777874},
{0.6022003272878338,-0.11914584541180732,0.7894042268290254},
{0.5737835875021804,0.1403861224121022,0.8068854511931802},
{-0.662868710858135,-0.20639908957669395,-0.7197252864719885},
{-0.35866455667958064,0.36849084589964665,-0.8576562436489359},
{-0.8154712336830097,-0.13962477952712188,-0.5617041819120745},
{-0.9241314740045639,-0.15983044349397188,-0.3470378193895767},
{-0.9438948109458392,-0.15390806724465858,-0.2921898230714618},
{-0.8629813086684236,-0.3156254045375113,-0.39451725551548117},
{-0.4731642606444161,-0.4351678381998568,-0.765992516311541},
{0.557642032431552,-0.2741209485146884,0.7835132859441603},
{0.6061157795888844,-0.16053170898116284,0.7790078511446121},
{0.6429823789427481,-0.2518761996036031,0.7232786741238609},
{0.6435882421436766,-0.20457052699823694,0.7375263209256168},
{0.21305605498774685,-0.9768637621685553,-0.01855552734239682},
{0.385856828980579,-0.9135976399015294,0.12827259994015716},
{0.7166769470007501,-0.6647951545237162,0.21076421935298323},
{0.44413941663888024,-0.8824797886673509,0.15482119099562172},
{0.8591194555373585,-0.5078418650146499,-0.06332772896318777},
{0.024598305856387892,-0.9992804250955776,-0.028871358987713428},
{0.019990479648247305,-0.9995659834201305,-0.021638519191034277},
{0.048464041980325424,-0.9986174703461413,-0.020356437664847498},
{0.015076185415410514,-0.9998292964632193,-0.010681131362562993},
{0.0926546722265397,-0.9891731766317413,0.11380482567475904},
{0.07092683014229749,-0.9972787330263883,-0.02011251896823246},
{0.38939832846271455,-0.9048716484958061,0.1719774448552078},
{0.37001837157496587,-0.7994587299257799,0.47323582265343084},
{0.7782503737650671,-0.6101182439362706,0.1486004177337831},
{0.1332155040709686,-0.9905276190899616,-0.0332966258814603},
{-0.0014040331797902025,-0.9994746193550553,0.032380765214819626},
{-0.1868388428933424,-0.9227819186581395,0.3369937349326835},
{-0.2608813005141,-0.9554770631079353,0.1378569146495972},
{0.06747778936505984,-0.9967604319312579,0.0437651605574201},
{-0.23255603320760104,-0.9695639842623646,-0.07657265726115656},
{-0.18286955582645426,-0.13452788019221393,-0.9738896113024436},
{-0.46288182760988955,-0.36656419882090135,-0.8070756481342496},
{-0.6518093429409624,-0.30754695770584867,-0.6932239531787314},
{-0.8465440370111595,-0.27546717088875894,-0.45550085747821795},
{-0.908095699520692,-0.25977906330435074,-0.32844640168639266},
{-0.9073364873094276,-0.27976962543234424,-0.31379843129377627},
{-0.04684687418813868,-0.016388305814695314,-0.9987676375470546},
{0.01712130776689385,-0.9997739716020515,-0.01260422656935518},
{0.028809836672147968,-0.9992970207818375,-0.02398869666047018},
{0.01712145717898161,-0.9995996914179186,-0.022523601427615374},
{0.006561188404726972,-0.999967714103686,0.004639133212852984},
{-0.24155527351838849,-0.9565470430703957,-0.16330586097485628},
{0.002014029868924902,-0.9992828197918814,-0.03781256077645898},
{0.031129913858635578,-0.9992663347477092,-0.022309654928597163},
{-0.005951129663286652,-0.9896145617343014,0.14362312926251536},
{0.004944088937163078,-0.9948908966792563,0.10083481387559966},
{0.02291952389517039,-0.9994738460034008,-0.02295052460378553},
{-0.34673052766255535,-0.9379507735554011,0.005127140886551207},
{-0.6790505023302912,-0.6847576158112929,-0.2645702607501704},
{-0.47158032869051575,-0.8313086819371244,-0.2941731954616297},
{-0.23960770643549237,-0.970851173377951,-0.0060121682759678805},
{-0.056825968841305044,-0.9924179200014072,0.10898385809525923},
{0.2779074820163461,-0.8937526302073359,0.35209894552072074},
{0.24003430900018918,-0.7655461214178297,0.5969276894942296},
{0.3519466706546378,-0.8332651609596122,0.4263832929959468},
{0.40461748408370074,-0.8743015284430966,0.2681073086207115},
{0.2940268992944636,-0.9412290916240853,0.16624072777686802},
{0.26539396888589406,-0.928329380812325,0.2603278740350301},
{0.3352200375385279,-0.9148367477622087,0.22516938374595463},
{0.5719936478698922,-0.7967377961325592,0.1950183350619277},
{-0.010712317630229349,-0.9979545902862793,0.06302286868695704},
{-0.015870310209764954,-0.9992875326207566,0.034242669325946544},
{0.03918693855895207,-0.9835435566656596,0.17637022420987444},
{-0.08389728614624271,-0.796981717231177,0.5981482991504196},
{-0.9101814250505582,-0.2764453296878343,-0.30846029434389094},
{-0.9298320064320719,-0.2313672222731498,-0.28614969556530107},
{0.7123125878231876,-0.402941989334754,-0.5746725419398292},
{0.7689929715469075,-0.34355502896196294,-0.539091598697663},
{0.328109952728936,-0.358263499789123,-0.874065857724156},
{0.1643463446686669,-0.08005211626198286,-0.9831489905787555},
{0.12518803149391433,-0.12640904155449625,-0.984047108112184},
{0.17399200480729177,-0.1907475830753488,-0.9660963418904205},
{0.21106997681607878,-0.08804765892539998,-0.9734973418785572},
{0.20673564412741188,-0.06109907699290198,-0.9764872125316539},
{-0.09940098467945556,0.26594330992952697,-0.9588501447820104},
{-0.09164769171457171,0.37730284770814,-0.9215439553893883},
{0.006226149095265177,0.5166293715304546,-0.8561865027781571},
{-0.06378611204435634,0.6358740546491303,-0.7691524676774688},
{-0.08862769451089281,0.6742888920184456,-0.7331300170271443},
{-0.03390655380770859,0.6127000074454367,-0.7895878966177525},
{0.044435722297205264,0.48613690209560245,-0.8727521864795392},
{-0.022401547270268295,0.4835168123258369,-0.875048377450161},
{-0.04226912034281309,0.4163440351964702,-0.9082240724742795},
{-0.15161767260194475,0.29990830850099087,-0.9418423901305589},
{-0.2888613143215876,0.2873962975123557,-0.9132154780031899},
{-0.25664023693122334,0.18275228966993884,-0.9490718568202727},
{-0.43767128307419056,0.14777278374640987,-0.8869087057617759},
{-0.3687361664297798,0.18024745843009388,-0.91189061476482},
{-0.2676834174038475,0.19474294122717536,-0.9436210970983991},
{-0.35957712801821334,0.11038749524094256,-0.9265629443813326},
{-0.6025122508961078,0.057071539327465864,-0.7960664714198802},
{-0.7431690838517692,-0.08343946899227607,-0.6638806879411459},
{-0.7139047987020356,-0.2759241061961569,-0.6435882425977482},
{-0.7514050411698663,-0.3328690051970034,-0.5697268551540017},
{-0.664837463991185,-0.5799015941188697,-0.4708559096073487},
{0.8784301623870019,-0.22788619291709236,-0.42003372827250346},
{0.8363542634343503,-0.2927118418350011,-0.4634990007375923},
{0.6101111407858645,0.11893395151714427,-0.7833384396705478},
{0.392849490237439,-0.9074117796669494,0.14924188467666863},
{0.6004968201201307,0.02942072609659282,-0.799085721247452},
{0.049471420928509965,0.4200905743485065,-0.9061327098471041},
{0.607052941459109,-0.12842389159280335,-0.7842155509386456},
{0.42150371916652707,-0.11456945721268626,-0.899560144850124},
{0.306744722876249,-0.08026471248456113,-0.94840141866055},
{0.2927999395423876,-0.18366309840111647,-0.9383688303059069},
{0.3849369189866903,-0.3272248816509646,-0.86298751163012},
{-0.28007234835945655,-0.7915712898119852,0.5431154323252189},
{-0.4411797593171282,-0.8884625706387,0.12647007765852605},
{-0.7631848512845422,-0.625545254964556,0.16199387877669838},
{-0.03595105229548128,-0.9991474533899181,-0.02029502952175997},
{0.03985759692517382,-0.9769736315934691,0.2096041391252066},
{0.0725141152147281,-0.7343884218873323,0.674844685014603},
{-0.013916316005647708,-0.6437416178045116,0.7651163739296533},
{-0.4031275775812445,-0.8698875091053003,0.28422504762257234},
{-0.47710110696481484,-0.8782404008225101,-0.032685349869093376},
{-0.12289897965815612,-0.9914019027097108,-0.04492335809519559},
{0.17322847601701824,-0.9784849314049264,0.11206754262638986},
{0.5570927889929637,0.5796771047555799,-0.5946613142573086},
{0.22681636375206052,0.9524009253846265,-0.20368312267048524},
{0.7481764703623125,0.6629067072032415,-0.028047579951710633},
{0.6450563015486632,0.7544682361698841,-0.1211612497585928},
{0.719986384435162,0.6442678200055216,-0.25795073625271137},
{0.5722330670530489,0.7614207259640381,-0.30461089120952006},
{0.5383058278050358,0.7022271701509353,-0.4659440280258397},
{0.528592976379523,0.617433989258496,-0.5825501988932598},
{0.46414285860463755,0.5450209705133908,-0.6982288654208999},
{0.515990051869526,0.7968907015892548,0.31419655646150724},
{0.4598366774360456,0.7747977306156674,-0.43386484844636797},
{0.39970945894053217,0.7584920517571363,-0.5147058925781953},
{0.47262632837203933,0.6360279735989235,-0.6099940741754892},
{0.4179330365659848,0.5028686859597893,-0.7566076008260888},
{-0.866389918322677,0.3593378234672877,-0.3467633747306908},
{-0.7385622397612762,0.6481034956822377,0.18570858053216285},
{-0.7967061298899405,0.4020611586351216,0.4512274008887057},
{-0.7057359116268423,0.373590716665232,0.6019691017500715},
{-0.8144696154682238,-0.3603120048234348,0.454768627610965},
{-0.6399219825392287,-0.34199533499698526,0.6881417347489999},
{-0.8053666497511269,-0.3257295206245412,0.49526239395127936},
{-0.2855653903421074,-0.8556881590588166,0.43156712373082046},
{-0.24314289649633736,-0.860597712597544,0.4474964904390271},
{-0.7065848273045758,0.4523576934989539,-0.5441602695486593},
{-0.3690712435295771,0.25862187875726994,-0.8926931953519033},
{-0.33125307516028674,-0.3794728139395514,-0.8638702354391267},
{-0.42513459299300516,-0.2216010428376846,-0.8775839308316455},
{-0.019135162340028572,-0.9957964481971451,0.08957275992270913},
{-0.02963359150717709,-0.9989519397782008,0.03488369630293451},
{-0.05169902562361211,0.3845716292684198,-0.9216462839459627},
{0.04611423261776998,0.21152965411578462,-0.9762830957154439},
{-0.09015541568011583,0.5402894697187028,-0.8366356972629295},
{0.09317446266727031,0.6164836776570765,-0.7818352733722567},
{-0.0066230903611270995,0.46498634397053884,-0.8852930783616125},
{0.05298162331894446,0.4360313596881753,-0.8983705254286622},
{-0.028474787451777707,0.3510947092964591,-0.9359068818977725},
{-0.5657750643559656,-0.1474100093085429,-0.8112760724369098},
{-0.603907730599568,-0.30076385006644496,-0.7381304487794068},
{-0.5675002195726707,0.015992231628650534,-0.823217923342602},
{-0.32326151267826997,-0.06613594619511931,-0.943995779144077},
{-0.07266572194225705,-0.17755876406662544,-0.9814237505571909},
{0.0938161464431839,-0.038759886797187684,-0.994834761074431},
{0.26560859160657124,-0.14011294966546575,-0.9538450803987073},
{0.188454103524288,-0.1443546112858529,-0.9714148429303349},
{0.22819601613037493,-0.15525413416280703,-0.9611569757576454},
{0.23390199151173566,-0.10794768814823293,-0.9662490129310849},
{0.2559051205495164,0.029786828817293984,-0.9662428856687881},
{0.32957960229250793,0.31822723709667783,-0.8888805945246679},
{0.33024391350837373,0.4311078033591042,-0.8396934080207857},
{-0.19917001784560026,0.6289750042382024,-0.7514797056707098},
{-0.4508600164850203,-0.6556745667263356,-0.6056534554374796},
{-0.6480805017272172,-0.5792894316993749,-0.49438387676219153},
{-0.9037617859539961,-0.34575042177038706,-0.25233168666428474},
{-0.8976063009823912,-0.35506240377058307,-0.2612156539439476},
{-0.9560515723441679,0.28410549071336266,-0.07245316531914747},
{-0.9860142510036182,-0.12598284300626764,-0.10910646216348487},
{-0.9227381339717511,-0.3699494638957996,-0.10812830470113428},
{-0.9737638119112387,-0.22754829283900732,0.0024110242941420487},
{-0.8100797825191839,-0.525973389512365,-0.2590805656133735},
{-0.7050849816154571,-0.6122148766006794,-0.35783811083944833},
{-0.37026242064169035,-0.8991637344560498,-0.2332601948460266},
{-0.0848120519515224,-0.9950373417724538,-0.05203464540266612},
{0.1946508109542902,-0.855175742985301,0.4804014054979187},
{-0.7322322009394286,-0.282491422957073,-0.6197052524088271},
{-0.7067403871945993,-0.30571411657981595,-0.638010112797478},
{-0.7838622834882952,-0.36302970952807023,-0.5037552486321907},
{-0.8650196264101485,-0.30058868495846547,-0.40173061670749904},
{-0.4202504997123048,-0.32570213747691656,-0.8469401603032684},
{-0.3457477807460311,-0.19522913482722887,-0.9177930360510512},
{-0.8080232558267102,-0.13220849615328814,-0.5741248397239829},
{-0.8635296946574369,-0.295421974527551,-0.40870811517643824},
{-0.5495851180930277,-0.7701463760720954,-0.3237757825929718},
{-0.6630309937963677,-0.7036819743892988,-0.2553851604635228},
{-0.7411081984447958,-0.022614829957360413,-0.6710046256650611},
{-0.752541678628333,-0.14984932111988464,-0.6412692124897003},
{-0.8601470415278907,-0.19718298968354872,-0.4703891320282332},
{-0.800763098268122,0.07400867269046814,-0.594391434005095},
{-0.7833475646936235,-0.11710427019595249,-0.6104532601194319},
{-0.2276455728837652,0.7644224293643042,-0.6031880657234507},
{0.11658252888432588,-0.04480158753610523,-0.9921700114966083},
{0.0007630091666446123,-0.4043138573485145,-0.9146199880677094},
{-0.18942986768380032,-0.4677616118956615,-0.8633165118692393},
{-0.34379944750271124,-0.39324066232373345,-0.852738952664895},
{-0.2981134955661223,0.6147215181847928,-0.7302368101115767},
{-0.5743680811198976,-0.8086631933907492,-0.12714223155868598},
{0.47465749876149604,0.38291882254390985,-0.792510841699384},
{0.10574892414313217,0.7608708443433017,-0.6402286492112652},
{0.14899459507279478,0.8709890159899719,-0.4681652963045363},
{0.22490077659741692,0.6100305184624137,-0.7597910286587737},
{0.061037764645192796,0.4865320949877463,-0.8715279179888344},
{0.13492420860398321,0.5527300477594626,-0.8223654614807282},
{-0.6462140537301064,-0.6298246719350515,-0.4309620393765649},
{-0.5326879826094596,-0.20133779680992944,-0.8220137497385234},
{0.478120747830898,0.03509730281105368,-0.8775925762157586},
{0.09671620005450882,-0.247849200600845,-0.9639588945637352},
{0.1102361042128661,-0.19215041089311874,-0.9751544600326534},
{0.14230914247205873,-0.07419059560953734,-0.9870379240393803},
{0.11102840718524883,-0.467432134304968,-0.877029014695072},
{0.030610989560419247,-0.7120810194189157,-0.7014296750932696},
{0.006104156123917117,-0.5129681200104694,-0.8583859546444942},
{-0.1113039361638821,-0.44314068991621736,-0.8895154651466187},
{-0.16831189860191373,-0.3750462306188517,-0.911598283065304},
{-0.14182194219388616,-0.2541614806382296,-0.9567071017151159},
{0.39235522027925795,0.09341919533480002,-0.9150575036917697},
{0.4070076071822197,0.017121530344517213,-0.9132642886341641},
{0.45366950522064586,-0.11383688694410107,-0.8838694152439772},
{0.30638435329938646,-0.17362530043195257,-0.9359395723566938},
{0.2710430081507911,-0.2484283399849749,-0.9299564761992252},
{0.24293579477094523,-0.06067319649338286,-0.9681430487517247},
{0.23734801084636825,-0.21958656103705365,-0.9462809645972979},
{0.4162162789915331,0.031190395596814878,-0.9087305256922739},
{0.4544262380546552,-0.0004270049219761802,-0.8907842678417094},
{0.3035742761307737,-0.09842403483022917,-0.9477105930817775},
{-0.5770301223346979,-0.8158142078244739,0.03851514286783582},
{-0.17771442208131172,-0.9838250165803873,0.022492686253666745},
{0.03463922708432865,-0.9989685489366065,-0.0293591924700137},
{0.3898204669560621,-0.9208216382086021,-0.011292216300810525},
{0.3157473744239569,-0.3860331255748507,-0.8667652632075705},
{0.09595250832284369,-0.4256831279083014,-0.8997705211667915},
{0.12378418971629852,-0.45418036522454297,-0.8822684796708881},
{0.12146649321348493,-0.7135676466439588,-0.6899761624066595},
{0.11731523953298982,-0.5145828233205967,-0.849377214502909},
{0.15412003329365903,-0.3066850460720529,-0.9392503914576475},
{0.08310390427095436,-0.4350509689049633,-0.8965625441372045},
{0.03289903031263766,-0.3799863501133145,-0.9244068517336128},
{0.10422231503742097,-0.3213640548490765,-0.9412028757389134},
{0.06839277811080689,-0.282910218695082,-0.9567048845177842},
{0.20423249836233048,-0.18531026688795346,-0.9612227585729524},
{0.2553856296663841,-0.17103043985340616,-0.951591702781952},
{0.22431426287813755,-0.17557555392425359,-0.9585699433706595},
{0.21134712352363186,-0.23567082827313765,-0.9485734837530196},
{0.2675902267111902,-0.2581910782473002,-0.9282956628586337},
{0.47246880551339626,-0.14313557650906525,-0.8696467297438437},
{0.3611278087940529,0.0767243842922274,-0.929354654892622},
{0.3550027156723734,0.10361341941292766,-0.9291056620120237},
{0.46190970997229513,0.07358186538967798,-0.8838694071632334},
{0.24143731671057828,-0.16986974071522867,-0.9554330396678444},
{0.20390061100326629,-0.20548766245972006,-0.957183034434551},
{0.33534280982510517,-0.44313667735737194,-0.8313694035020004},
{0.2890727705725288,-0.09653059125047549,-0.9524278336264411},
{0.2949683698731034,-0.2291077243251404,-0.9276331771928813},
{0.2567270890066017,-0.2096661561350493,-0.9434677020130311},
{-0.04245176004390621,-0.21415183411185665,-0.9758774718250762},
{0.20365186045886846,-0.3496841945353184,-0.914465354086106},
{0.1864102790830491,-0.45644302914199314,-0.8700063040000696},
{0.21268808187086216,-0.6340371493910081,-0.743478764338443},
{0.3356239003321262,-0.4845901822808462,-0.8077926421816847},
{0.2114392215355053,-0.17576200300897812,-0.961457837814395},
{0.2060965821984353,-0.2025874871533615,-0.9573309296450262},
{0.22199840865176612,-0.2669227055267134,-0.9378000724196938},
{0.1656905761832592,-0.281664479191815,-0.9450988065412331},
{0.20066433090367378,-0.23542625439847142,-0.9509512632321844},
{0.22232992602681811,-0.05084466915357802,-0.9736448138882952},
{0.21329793369830952,-0.3031765912648748,-0.9287561283722667},
{0.23584902450051254,-0.06222753415389381,-0.9697953246099316},
{0.18042817638391007,-0.1635518792817631,-0.9698950747117856},
{0.1122820224934304,-0.28801331805140307,-0.9510210702449269},
{0.16004050953945279,-0.2816276563778104,-0.9460829236750308},
{0.05038682550014558,-0.9978193475275228,0.0426346984950821},
{0.2271202112091972,-0.9688151665936462,0.09906352829581277},
{0.04174933824797494,-0.9990920945205823,0.0084840687368756},
{-0.19107794857881175,-0.9097352773179683,-0.368606758985931},
{-0.5253898061120276,-0.7309372074548341,0.43554144509069953},
{-0.36543248812182066,-0.9037536264983206,0.22290912770954321},
{-0.6675571583495726,-0.7026855348614431,0.24617164628106783},
{-0.43413952975423165,-0.8940678632043998,0.1102974373677532},
{-0.48760642883522104,-0.7016388844116143,0.5195602433213956},
{-0.3351054559555225,-0.840145228413061,0.4264508512872344},
{-0.2975944359854478,-0.9322754274495364,0.2056698301751801},
{-0.025239718004142618,-0.9992964273768211,0.027741789181541278},
{-0.15436564549618118,-0.968643600474398,0.19468133642068086},
{-0.6015133532245609,-0.6805905547908054,0.41830393569997437},
{-0.8921020442903993,-0.45177361865030713,0.007385124541759491},
{-0.4027306637496036,-0.7105772863048103,0.5769644119557941},
{0.1403860915329891,-0.727749658414956,0.6713212196713331},
{-0.3004329130054413,-0.6511623181673303,0.696941676313028},
{-0.559749566664759,-0.7575739476759236,0.33580073916138337},
{-0.548886771132014,-0.7867838729459736,0.2823020540988076},
{-0.6445697793519304,-0.6132258661561901,0.4566003029162314},
{-0.4747905182332584,-0.8729776940751874,0.11173141654415028},
{-0.4477138295339142,-0.8921616092467227,-0.059999915253068},
{-0.34099082199190933,-0.919330088522185,-0.19636050431559157},
{-0.3175491709814527,-0.9481314536263016,0.014466190012179988},
{-0.36152914313011664,-0.9041898650766587,0.2274584941483991},
{-0.26280321598308787,-0.9129595417365491,0.3121527587914877},
{-0.29686091832857964,-0.86424314114238,0.40614946529259954},
{-0.3178011687122837,-0.7920463277169069,0.5212149574938048},
{-0.38067226540610427,-0.8565363481161757,0.3484739742167124},
{-0.4229655762317733,-0.8036621954652664,0.41860147742557247},
{0.2346940659103535,-0.9717082551215294,-0.026490797555745585},
{-0.1425236349299151,-0.9826531669673741,0.11865819371351595}
};


// face array: 22kb.
const uint16_t bunny_face[11752] PROGMEM = {
74, // chain 0
0,0, 1,1, 2,2, 
3,3, 32772,4, 32773,5, 32774,6, 32775,7, 32776,8, 32777,9, 32769,1, 10,10, 32779,11, 32768,0, 12,12, 32781,13, 32771,3, 14,14, 32772,4, 
15,15, 32773,5, 16,16, 32774,6, 17,17, 32786,18, 32775,7, 19,19, 32788,20, 32776,8, 21,21, 32777,9, 22,22, 32778,10, 23,23, 32792,24, 
32793,25, 32779,11, 12,12, 26,26, 32795,27, 32796,28, 32781,13, 29,29, 32798,30, 32782,14, 31,31, 32783,15, 32,32, 32784,16, 33,33, 32802,34, 
32803,35, 32785,17, 36,36, 32805,37, 32806,38, 32786,18, 39,39, 32808,40, 32787,19, 41,41, 32810,42, 32788,20, 43,43, 32789,21, 44,44, 32813,45, 
32790,22, 23,23, 46,46, 32792,24, 47,47, 32816,48, 32817,49, 32794,26, 32793,25, 
45, // chain 1
50,50, 51,51, 52,52, 
53,53, 32822,54, 32823,55, 32824,56, 32819,51, 57,57, 32826,58, 32827,59, 32818,50, 60,60, 32829,61, 32830,62, 32821,53, 63,63, 32822,54, 64,64, 
32833,65, 32834,66, 32835,67, 32823,55, 68,68, 32837,69, 32838,70, 32824,56, 57,57, 71,71, 32840,72, 32826,58, 73,73, 32842,74, 32843,75, 32827,59, 
76,76, 32845,77, 32828,60, 78,78, 32847,79, 32848,80, 32829,61, 81,81, 32830,62, 82,82, 32832,64, 32831,63, 
84, // chain 2
83,83, 84,84, 85,85, 
86,86, 32855,87, 32856,88, 32857,89, 32858,90, 32852,84, 91,91, 32860,92, 32861,93, 32862,94, 32851,83, 86,86, 95,95, 32864,96, 32865,97, 32855,87, 
98,98, 32867,99, 32856,88, 100,100, 32869,101, 32870,102, 32857,89, 103,103, 32872,104, 32858,90, 91,91, 105,105, 32874,106, 32875,107, 32860,92, 108,108, 
32877,109, 32878,110, 32879,111, 32861,93, 112,112, 32862,94, 113,113, 32882,114, 32863,95, 96,96, 115,115, 32884,116, 32885,117, 32865,97, 118,118, 32866,98, 
119,119, 32888,120, 32867,99, 121,121, 32890,122, 32868,100, 123,123, 32892,124, 32893,125, 32869,101, 126,126, 32870,102, 127,127, 32871,103, 128,128, 32897,129, 
32872,104, 105,105, 130,130, 32899,131, 32874,106, 132,132, 32901,133, 32875,107, 134,134, 32903,135, 32876,108, 136,136, 32877,109, 110,110, 137,137, 32906,138, 
32907,139, 32880,112, 32879,111, 
56, // chain 3
140,140, 141,141, 142,142, 
143,143, 32912,144, 32913,145, 32914,146, 32909,141, 147,147, 32916,148, 32917,149, 32918,150, 32908,140, 151,151, 32920,152, 32911,143, 153,153, 32922,154, 32923,155, 
32924,156, 32912,144, 157,157, 32926,158, 32927,159, 32928,160, 32913,145, 161,161, 32914,146, 147,147, 162,162, 32931,163, 32932,164, 32916,148, 165,165, 32917,149, 
166,166, 32935,167, 32936,168, 32937,169, 32918,150, 151,151, 170,170, 32939,171, 32920,152, 172,172, 32921,153, 173,173, 32942,174, 32943,175, 32922,154, 155,155, 
176,176, 32945,177, 32946,178, 32947,179, 32948,180, 32925,157, 32924,156, 
58, // chain 4
181,181, 182,182, 183,183, 
184,184, 32953,185, 32954,186, 32950,182, 187,187, 32956,188, 32957,189, 32958,190, 32959,191, 32949,181, 192,192, 32961,193, 32962,194, 32963,195, 32964,196, 32952,184, 
197,197, 32953,185, 198,198, 32967,199, 32954,186, 200,200, 32969,201, 32970,202, 32955,187, 188,188, 203,203, 32972,204, 32973,205, 32957,189, 206,206, 32958,190, 
191,191, 192,192, 207,207, 32961,193, 208,208, 32977,209, 32978,210, 32962,194, 195,195, 211,211, 32980,212, 32964,196, 197,197, 198,198, 213,213, 32982,214, 
32983,215, 32967,199, 216,216, 32968,200, 217,217, 32986,218, 32969,201, 203,203, 32970,202, 
10, // chain 5
128,128, 219,219, 220,220, 
221,221, 32990,222, 32991,223, 32992,224, 32987,219, 225,225, 32898,130, 32897,129, 32896,128, 
68, // chain 6
226,226, 227,227, 228,228, 
229,229, 32998,230, 32995,227, 231,231, 33000,232, 33001,233, 33002,234, 32994,226, 235,235, 33004,236, 33005,237, 32997,229, 238,238, 33007,239, 33008,240, 32998,230, 
241,241, 33010,242, 32999,231, 243,243, 33000,232, 244,244, 33001,233, 245,245, 33014,246, 33015,247, 33016,248, 33002,234, 249,249, 33018,250, 33003,235, 251,251, 
33020,252, 33004,236, 253,253, 33022,254, 33023,255, 33005,237, 256,256, 33006,238, 257,257, 33007,239, 258,258, 33027,259, 33008,240, 241,241, 260,260, 33029,261, 
33010,242, 262,262, 33031,263, 33011,243, 264,264, 33033,265, 33012,244, 245,245, 266,266, 33035,267, 33014,246, 268,268, 33037,269, 33015,247, 270,270, 33039,271, 
33040,272, 33017,249, 33016,248, 
36, // chain 7
273,273, 274,274, 275,275, 
276,276, 33045,277, 33046,278, 33047,279, 33042,274, 280,280, 33049,281, 33050,282, 33051,283, 33041,273, 284,284, 33053,285, 33054,286, 33044,276, 287,287, 33056,288, 
33045,277, 289,289, 33046,278, 290,290, 33059,291, 33047,279, 292,292, 33061,293, 33048,280, 294,294, 33063,295, 33064,296, 33049,281, 297,297, 33066,298, 33067,299, 
33052,284, 33050,282, 283,283, 
35, // chain 8
300,300, 301,301, 302,302, 
303,303, 33072,304, 33073,305, 33074,306, 33075,307, 33076,308, 33069,301, 309,309, 33078,310, 33068,300, 311,311, 33080,312, 33081,313, 33071,303, 314,314, 33083,315, 
33072,304, 316,316, 33085,317, 33073,305, 318,318, 33087,319, 33074,306, 320,320, 33089,321, 33075,307, 308,308, 322,322, 33091,323, 33077,309, 324,324, 33093,325, 
33079,311, 33078,310, 
4, // chain 9
326,326, 327,327, 297,297, 
328,328, 33067,299, 33066,298, 
77, // chain 10
329,329, 330,330, 331,331, 
332,332, 33101,333, 33102,334, 33103,335, 33098,330, 336,336, 33105,337, 33106,338, 33107,339, 33097,329, 340,340, 33100,332, 341,341, 33110,342, 33111,343, 33112,344, 
33101,333, 345,345, 33102,334, 346,346, 33115,347, 33116,348, 33117,349, 33103,335, 350,350, 33104,336, 351,351, 33105,337, 352,352, 33121,353, 33106,338, 354,354, 
33123,355, 33124,356, 33107,339, 340,340, 357,357, 33109,341, 358,358, 33127,359, 33128,360, 33110,342, 361,361, 33111,343, 362,362, 33131,363, 33112,344, 345,345, 
364,364, 33114,346, 365,365, 33134,366, 33115,347, 367,367, 33116,348, 368,368, 33137,369, 33138,370, 33139,371, 33117,349, 372,372, 33118,350, 351,351, 373,373, 
33142,374, 33120,352, 375,375, 33144,376, 33121,353, 354,354, 377,377, 33146,378, 33123,355, 379,379, 33125,357, 33124,356, 
58, // chain 11
380,380, 381,381, 382,382, 
383,383, 33152,384, 33149,381, 385,385, 33154,386, 33155,387, 33156,388, 33157,389, 33158,390, 33148,380, 391,391, 33160,392, 33151,383, 393,393, 33152,384, 394,394, 
33163,395, 33153,385, 396,396, 33165,397, 33154,386, 398,398, 33155,387, 388,388, 399,399, 33168,400, 33169,401, 33170,402, 33157,389, 264,264, 33031,263, 33171,403, 
33172,404, 33158,390, 391,391, 405,405, 33174,406, 33175,407, 33160,392, 408,408, 33177,409, 33161,393, 410,410, 33179,411, 33180,412, 33162,394, 413,413, 33182,414, 
33183,415, 33163,395, 416,416, 33164,396, 397,397, 417,417, 33186,418, 33167,399, 33166,398, 
21, // chain 12
419,419, 420,420, 421,421, 
422,422, 33191,423, 32938,170, 33192,424, 33193,425, 33194,426, 33188,420, 427,427, 33196,428, 33197,429, 33187,419, 422,422, 430,430, 32941,173, 33191,423, 431,431, 
32938,170, 171,171, 172,172, 173,173, 
46, // chain 13
432,432, 433,433, 434,434, 
435,435, 33204,436, 33205,437, 33206,438, 33207,439, 33201,433, 440,440, 33209,441, 33210,442, 33200,432, 443,443, 33212,444, 33203,435, 445,445, 33204,436, 446,446, 
33215,447, 33216,448, 33205,437, 449,449, 33206,438, 450,450, 33219,451, 33220,452, 33221,453, 33207,439, 440,440, 454,454, 33209,441, 455,455, 33224,456, 33225,457, 
33226,458, 33227,459, 33210,442, 460,460, 33229,461, 33211,443, 462,462, 33231,463, 33232,464, 33212,444, 465,465, 33214,446, 33213,445, 
43, // chain 14
466,466, 429,429, 430,430, 
173,173, 174,174, 467,467, 33236,468, 32943,175, 469,469, 32944,176, 177,177, 470,470, 33239,471, 33240,472, 32946,178, 179,179, 473,473, 33242,474, 32948,180, 
475,475, 32925,157, 158,158, 476,476, 33245,477, 32927,159, 478,478, 32928,160, 161,161, 479,479, 32930,162, 163,163, 480,480, 33249,481, 32932,164, 165,165, 
482,482, 33251,483, 32934,166, 484,484, 32935,167, 485,485, 32936,168, 486,486, 32938,170, 32937,169, 
82, // chain 15
487,487, 488,488, 489,489, 
490,490, 33259,491, 33260,492, 33261,493, 33256,488, 494,494, 33263,495, 33264,496, 33265,497, 33255,487, 498,498, 33267,499, 33268,500, 33258,490, 501,501, 33270,502, 
33259,491, 503,503, 33272,504, 33273,505, 33260,492, 506,506, 33275,507, 33261,493, 508,508, 33262,494, 509,509, 33263,495, 510,510, 33264,496, 511,511, 33280,512, 
33265,497, 498,498, 513,513, 33282,514, 33283,515, 33284,516, 33267,499, 517,517, 33268,500, 518,518, 33287,519, 33269,501, 520,520, 33289,521, 33270,502, 522,522, 
33291,523, 33271,503, 504,504, 524,524, 33293,525, 33294,526, 33273,505, 506,506, 527,527, 33296,528, 33297,529, 33275,507, 530,530, 33276,508, 531,531, 33300,532, 
33277,509, 533,533, 33278,510, 534,534, 33279,511, 535,535, 33280,512, 536,536, 33305,537, 33281,513, 514,514, 538,538, 33307,539, 33283,515, 540,540, 33285,517, 
33284,516, 
41, // chain 16
28,28, 29,29, 541,541, 
542,542, 33311,543, 33312,544, 33313,545, 33314,546, 32797,29, 30,30, 547,547, 32799,31, 548,548, 32800,32, 33,33, 549,549, 33318,550, 32802,34, 551,551, 
33320,552, 32803,35, 36,36, 553,553, 33322,554, 33323,555, 32805,37, 556,556, 33325,557, 33326,558, 32806,38, 39,39, 559,559, 33328,560, 32808,40, 561,561, 
32809,41, 562,562, 33331,563, 33332,564, 32810,42, 565,565, 32812,44, 32811,43, 
13, // chain 17
126,126, 566,566, 567,567, 
125,125, 33336,568, 33337,569, 33338,570, 33339,571, 33334,566, 572,572, 33341,573, 32990,222, 32989,221, 32895,127, 32894,126, 
25, // chain 18
574,574, 575,575, 576,576, 
577,577, 33346,578, 33347,579, 33348,580, 33343,575, 451,451, 33349,581, 33342,574, 582,582, 33351,583, 33352,584, 33353,585, 33345,577, 586,586, 33346,578, 587,587, 
33356,588, 33357,589, 33347,579, 590,590, 33359,591, 33348,580, 452,452, 33219,451, 
27, // chain 19
592,592, 593,593, 594,594, 
595,595, 33364,596, 33365,597, 32833,65, 33366,598, 33361,593, 599,599, 33368,600, 33369,601, 33360,592, 602,602, 33371,603, 33372,604, 33363,595, 605,605, 33374,606, 
33375,607, 33364,596, 608,608, 33377,609, 33365,597, 610,610, 33379,611, 32835,67, 32834,66, 32833,65, 
42, // chain 20
612,612, 613,613, 614,614, 
615,615, 33384,616, 33385,617, 33381,613, 618,618, 33387,619, 33380,612, 620,620, 33389,621, 33390,622, 33215,447, 33383,615, 446,446, 33233,465, 33391,623, 33392,624, 
33384,616, 625,625, 33394,626, 33385,617, 627,627, 33386,618, 628,628, 33397,629, 33387,619, 630,630, 33388,620, 631,631, 33389,621, 632,632, 33401,633, 33390,622, 
634,634, 33403,635, 33215,447, 448,448, 636,636, 33405,637, 33406,638, 33218,450, 33217,449, 
60, // chain 21
639,639, 640,640, 565,565, 
44,44, 641,641, 33410,642, 32813,45, 643,643, 32814,46, 644,644, 32815,47, 645,645, 33414,646, 32816,48, 647,647, 33416,648, 33417,649, 32817,49, 650,650, 
32794,26, 27,27, 28,28, 651,651, 33420,652, 33310,542, 601,601, 33311,543, 544,544, 600,600, 33367,599, 33421,653, 33313,545, 546,546, 654,654, 33315,547, 
655,655, 33316,548, 656,656, 33317,549, 657,657, 33318,550, 551,551, 658,658, 33427,659, 33320,552, 660,660, 33321,553, 661,661, 33322,554, 662,662, 33431,663, 
33323,555, 556,556, 664,664, 33433,665, 33325,557, 666,666, 33435,667, 33436,668, 33437,669, 33327,559, 33326,558, 
35, // chain 22
670,670, 671,671, 672,672, 
673,673, 33442,674, 33443,675, 33444,676, 33445,677, 33446,678, 33439,671, 679,679, 33428,660, 33438,670, 680,680, 33449,681, 33441,673, 79,79, 32846,78, 33450,682, 
33442,674, 683,683, 33443,675, 684,684, 33453,685, 33444,676, 686,686, 33455,687, 33445,677, 688,688, 33446,678, 689,689, 33458,690, 33459,691, 33447,679, 662,662, 
33429,661, 33428,660, 
18, // chain 23
692,692, 693,693, 644,644, 
645,645, 694,694, 33463,695, 33414,646, 696,696, 33415,647, 697,697, 33466,698, 33416,648, 699,699, 33417,649, 650,650, 651,651, 652,652, 698,698, 33370,602, 
33369,601, 
102, // chain 24
700,700, 701,701, 702,702, 
703,703, 33472,704, 33473,705, 33474,706, 33475,707, 33469,701, 708,708, 33477,709, 33478,710, 33479,711, 33468,700, 712,712, 33471,703, 713,713, 33472,704, 714,714, 
33483,715, 33473,705, 716,716, 33485,717, 33474,706, 718,718, 33475,707, 719,719, 33476,708, 720,720, 33477,709, 721,721, 33490,722, 33491,723, 33478,710, 724,724, 
33479,711, 725,725, 33494,726, 33480,712, 727,727, 33481,713, 728,728, 33482,714, 729,729, 33498,730, 33499,731, 33483,715, 732,732, 33501,733, 33484,716, 734,734, 
33503,735, 33504,736, 33485,717, 718,718, 737,737, 33506,738, 33487,719, 720,720, 739,739, 33508,740, 33489,721, 741,741, 33510,742, 33511,743, 33490,722, 744,744, 
33513,745, 33491,723, 746,746, 33492,724, 747,747, 33516,748, 33493,725, 749,749, 33494,726, 750,750, 33495,727, 751,751, 33520,752, 33496,728, 753,753, 33522,754, 
33497,729, 730,730, 755,755, 33524,756, 33499,731, 732,732, 757,757, 33501,733, 758,758, 33502,734, 759,759, 33503,735, 760,760, 33529,761, 33504,736, 762,762, 
33505,737, 763,763, 33532,764, 33507,739, 33506,738, 
7, // chain 25
639,639, 641,641, 765,765, 
33534,766, 33535,767, 33410,642, 643,643, 693,693, 33412,644, 
2, // chain 26
693,693, 768,768, 766,766, 
767,767, 
72, // chain 27
572,572, 573,573, 769,769, 
33538,770, 33539,771, 32990,222, 223,223, 772,772, 33541,773, 32992,224, 774,774, 32993,225, 775,775, 33544,776, 32898,130, 131,131, 132,132, 777,777, 32901,133, 
778,778, 32902,134, 779,779, 33548,780, 32903,135, 781,781, 33550,782, 32904,136, 783,783, 33552,784, 32905,137, 785,785, 32906,138, 786,786, 33555,787, 33556,788, 
33557,789, 32907,139, 790,790, 33559,791, 32880,112, 792,792, 32881,113, 793,793, 33562,794, 32882,114, 115,115, 793,793, 33563,795, 32884,116, 796,796, 33565,797, 
33566,798, 33567,799, 32885,117, 800,800, 33569,801, 32886,118, 119,119, 802,802, 32888,120, 803,803, 32889,121, 804,804, 33573,805, 33574,806, 33575,807, 32890,122, 
123,123, 808,808, 33577,809, 32892,124, 810,810, 33336,568, 32893,125, 
82, // chain 28
811,811, 812,812, 813,813, 
814,814, 33583,815, 33584,816, 33585,817, 33580,812, 818,818, 33587,819, 33579,811, 820,820, 33589,821, 33590,822, 33582,814, 823,823, 33592,824, 33583,815, 825,825, 
33584,816, 826,826, 33595,827, 33596,828, 33585,817, 829,829, 33586,818, 830,830, 33599,831, 33600,832, 33587,819, 820,820, 833,833, 33602,834, 33589,821, 835,835, 
33590,822, 836,836, 33591,823, 837,837, 33606,838, 33592,824, 839,839, 33608,840, 33593,825, 826,826, 841,841, 33610,842, 33611,843, 33595,827, 844,844, 33299,531, 
33596,828, 845,845, 33597,829, 830,830, 846,846, 33615,847, 33616,848, 33617,849, 33618,850, 33599,831, 851,851, 33620,852, 33600,832, 833,833, 853,853, 33622,854, 
33623,855, 33602,834, 856,856, 33625,857, 33603,835, 858,858, 33627,859, 33604,836, 860,860, 33605,837, 861,861, 33630,862, 33631,863, 33632,864, 33633,865, 33607,839, 
33606,838, 
10, // chain 29
466,466, 467,467, 866,866, 
429,429, 33635,867, 33636,868, 33235,467, 564,564, 33331,563, 33238,470, 33236,468, 469,469, 
8, // chain 30
599,599, 869,869, 870,870, 
598,598, 32833,65, 32832,64, 33637,869, 82,82, 33421,653, 33367,599, 
40, // chain 31
871,871, 872,872, 873,873, 
874,874, 33643,875, 33640,872, 876,876, 33645,877, 33646,878, 33647,879, 33639,871, 880,880, 33642,874, 881,881, 33650,882, 33651,883, 33652,884, 33653,885, 33643,875, 
886,886, 33655,887, 33644,876, 877,877, 888,888, 33464,696, 33657,889, 33658,890, 33646,878, 891,891, 33660,892, 33647,879, 893,893, 33662,894, 33648,880, 895,895, 
33649,881, 896,896, 33650,882, 897,897, 33666,898, 33652,884, 33651,883, 
7, // chain 32
899,899, 900,900, 692,692, 
694,694, 901,901, 33658,890, 33657,889, 33463,695, 696,696, 
80, // chain 33
902,902, 264,264, 265,265, 
266,266, 903,903, 33672,904, 33035,267, 905,905, 33036,268, 906,906, 33675,907, 33676,908, 33037,269, 909,909, 33678,910, 33038,270, 911,911, 33680,912, 33039,271, 
913,913, 33682,914, 33040,272, 915,915, 33017,249, 916,916, 33018,250, 251,251, 917,917, 33020,252, 918,918, 33021,253, 919,919, 33022,254, 920,920, 33689,921, 
33023,255, 922,922, 33691,923, 33692,924, 33693,925, 33024,256, 926,926, 33025,257, 927,927, 33026,258, 765,765, 33407,639, 33408,640, 33027,259, 260,260, 928,928, 
33697,929, 33029,261, 930,930, 33699,931, 33030,262, 932,932, 33031,263, 403,403, 933,933, 33172,404, 934,934, 33173,405, 935,935, 33174,406, 936,936, 33705,937, 
33175,407, 938,938, 33176,408, 939,939, 33708,940, 33709,941, 33177,409, 410,410, 942,942, 33711,943, 33712,944, 33179,411, 945,945, 33181,413, 33180,412, 
33, // chain 34
901,901, 890,890, 891,891, 
923,923, 33660,892, 946,946, 33661,893, 947,947, 33662,894, 948,948, 33717,949, 33663,895, 950,950, 33719,951, 33720,952, 33664,896, 953,953, 33665,897, 954,954, 
33723,955, 33666,898, 956,956, 33725,957, 33652,884, 958,958, 33653,885, 959,959, 33654,886, 960,960, 33729,961, 33730,962, 33655,887, 888,888, 697,697, 33464,696, 
52, // chain 35
963,963, 964,964, 965,965, 
966,966, 33735,967, 33736,968, 33737,969, 33732,964, 970,970, 33739,971, 33731,963, 972,972, 33741,973, 33742,974, 33743,975, 33734,966, 967,967, 976,976, 33745,977, 
33746,978, 33747,979, 33748,980, 33736,968, 981,981, 33737,969, 982,982, 33751,983, 33738,970, 984,984, 33753,985, 33754,986, 33739,971, 987,987, 33756,988, 33740,972, 
989,989, 33741,973, 990,990, 33742,974, 991,991, 33760,992, 33743,975, 993,993, 33744,976, 994,994, 33745,977, 978,978, 995,995, 33764,996, 33765,997, 33766,998, 
33747,979, 981,981, 33748,980, 
119, // chain 36
999,999, 1000,1000, 1001,1001, 
1002,1002, 33771,1003, 33772,1004, 33773,1005, 33774,1006, 33768,1000, 1005,1005, 33775,1007, 33767,999, 1008,1008, 33777,1009, 33778,1010, 33770,1002, 1011,1011, 33780,1012, 33771,1003, 
1013,1013, 33782,1014, 33783,1015, 33772,1004, 1016,1016, 33785,1017, 33773,1005, 1018,1018, 33787,1019, 33788,1020, 33775,1007, 1021,1021, 33776,1008, 1022,1022, 33791,1023, 33777,1009, 
1024,1024, 33778,1010, 1025,1025, 33794,1026, 33795,1027, 33779,1011, 1028,1028, 33780,1012, 1029,1029, 33781,1013, 1030,1030, 33782,1014, 1031,1031, 33800,1032, 33783,1015, 1033,1033, 
33784,1016, 1034,1034, 33785,1017, 1035,1035, 33804,1036, 33805,1037, 33786,1018, 1038,1038, 33807,1039, 33787,1019, 1020,1020, 1040,1040, 33809,1041, 33789,1021, 1022,1022, 518,518, 
33285,517, 33810,1042, 33791,1023, 1043,1043, 33792,1024, 1044,1044, 33813,1045, 33814,1046, 33793,1025, 1047,1047, 33816,1048, 33794,1026, 1027,1027, 1049,1049, 33818,1050, 33796,1028, 
1051,1051, 33797,1029, 1052,1052, 33798,1030, 1053,1053, 33799,1031, 1054,1054, 33823,1055, 33800,1032, 1056,1056, 33801,1033, 1057,1057, 33826,1058, 33827,1059, 33802,1034, 1058,1058, 
33828,1060, 33829,1061, 33803,1035, 634,634, 33401,633, 33804,1036, 1037,1037, 1038,1038, 632,632, 33830,1062, 33807,1039, 1040,1040, 1063,1063, 33832,1064, 33833,1065, 33809,1041, 
1066,1066, 33288,520, 33835,1067, 33286,518, 519,519, 520,520, 
60, // chain 37
1068,1068, 1069,1069, 1070,1070, 
1071,1071, 33840,1072, 33841,1073, 33837,1069, 1074,1074, 33843,1075, 33844,1076, 33845,1077, 33836,1068, 1078,1078, 33847,1079, 33848,1080, 33839,1071, 1081,1081, 33850,1082, 33851,1083, 
33840,1072, 1084,1084, 33853,1085, 33841,1073, 1086,1086, 33842,1074, 1087,1087, 33856,1088, 33843,1075, 1089,1089, 33858,1090, 33844,1076, 1091,1091, 33860,1092, 33845,1077, 1078,1078, 
860,860, 33627,859, 33861,1093, 33847,1079, 1094,1094, 33863,1095, 33848,1080, 1081,1081, 1096,1096, 33850,1082, 1097,1097, 33866,1098, 33851,1083, 1097,1097, 33867,1099, 33868,1100, 
33852,1084, 1101,1101, 33870,1102, 33853,1085, 1103,1103, 33854,1086, 1104,1104, 33855,1087, 1105,1105, 33857,1089, 33856,1088, 
10, // chain 38
72,72, 1106,1106, 326,326, 
1107,1107, 33096,328, 1108,1108, 33877,1109, 33878,1110, 33067,299, 1111,1111, 33053,285, 33052,284, 
88, // chain 39
1112,1112, 1113,1113, 1114,1114, 
1115,1115, 33884,1116, 33885,1117, 33886,1118, 33881,1113, 1119,1119, 33888,1120, 33889,1121, 33890,1122, 33880,1112, 1123,1123, 33892,1124, 33883,1115, 1116,1116, 1125,1125, 33894,1126, 
33895,1127, 33896,1128, 33897,1129, 33885,1117, 1130,1130, 33899,1131, 33886,1118, 1119,1119, 1132,1132, 33888,1120, 1133,1133, 33902,1134, 33903,1135, 33889,1121, 1136,1136, 33890,1122, 
1137,1137, 33891,1123, 1138,1138, 33907,1139, 33892,1124, 1125,1125, 1138,1138, 33908,1140, 33909,1141, 33894,1126, 204,204, 33910,1142, 33911,1143, 33912,1144, 33895,1127, 1145,1145, 
33914,1146, 33915,1147, 33916,1148, 33896,1128, 1149,1149, 33918,1150, 33919,1151, 33897,1129, 1130,1130, 1152,1152, 33899,1131, 1153,1153, 33922,1154, 33900,1132, 1155,1155, 33901,1133, 
1058,1058, 33825,1057, 33924,1156, 33925,1157, 33902,1134, 1158,1158, 33903,1135, 1159,1159, 33928,1160, 33904,1136, 1161,1161, 33930,1162, 33931,1163, 33905,1137, 1138,1138, 1164,1164, 
33908,1140, 1165,1165, 33934,1166, 32974,206, 32973,205, 33909,1141, 204,204, 
36, // chain 40
1167,1167, 1168,1168, 1169,1169, 
1170,1170, 33939,1171, 33940,1172, 33941,1173, 33942,1174, 33936,1168, 1175,1175, 33944,1176, 33945,1177, 33935,1167, 848,848, 33615,847, 33946,1178, 33938,1170, 528,528, 33295,527, 
33939,1171, 525,525, 33947,1179, 33940,1172, 1180,1180, 33949,1181, 33941,1173, 1174,1174, 1182,1182, 33943,1175, 1183,1183, 33952,1184, 33953,1185, 33944,1176, 1186,1186, 33618,850, 
33617,849, 33616,848, 33945,1177, 
14, // chain 41
1187,1187, 1188,1188, 1189,1189, 
1190,1190, 33675,907, 33956,1188, 1191,1191, 33960,1192, 33955,1187, 1193,1193, 33962,1194, 33958,1190, 1195,1195, 33677,909, 33676,908, 33675,907, 
5, // chain 42
901,901, 924,924, 1196,1196, 
899,899, 33965,1197, 33693,925, 33692,924, 
3, // chain 43
327,327, 1106,1106, 295,295, 
296,296, 297,297, 
21, // chain 44
665,665, 1198,1198, 1199,1199, 
664,664, 33430,662, 33968,1200, 33969,1201, 33966,1198, 1202,1202, 33971,1203, 33972,1204, 33973,1205, 33433,665, 666,666, 1206,1206, 33435,667, 1207,1207, 33436,668, 1208,1208, 
33437,669, 1209,1209, 33328,560, 33327,559, 
1, // chain 45
923,923, 924,924, 901,901, 
10, // chain 46
482,482, 1210,1210, 1211,1211, 
1212,1212, 33981,1213, 33982,1214, 33978,1210, 1215,1215, 33984,1216, 33985,1217, 33251,483, 33250,482, 
42, // chain 47
1106,1106, 73,73, 1218,1218, 
295,295, 33987,1219, 33988,1220, 33989,1221, 32841,73, 74,74, 1222,1222, 32843,75, 76,76, 1223,1223, 33992,1224, 32845,77, 78,78, 682,682, 1223,1223, 33993,1225, 
33451,683, 1226,1226, 33995,1227, 33996,1228, 33452,684, 1229,1229, 33998,1230, 33999,1231, 33453,685, 686,686, 1232,1232, 34001,1233, 33455,687, 1234,1234, 34003,1235, 33456,688, 
1236,1236, 34005,1237, 34006,1238, 33457,689, 1239,1239, 33458,690, 1200,1200, 33430,662, 33459,691, 
5, // chain 48
1240,1240, 1241,1241, 939,939, 
940,940, 1242,1242, 33710,942, 33709,941, 
74, // chain 49
1243,1243, 1244,1244, 1245,1245, 
1246,1246, 34015,1247, 34016,1248, 34017,1249, 34018,1250, 34012,1244, 1251,1251, 34020,1252, 34021,1253, 34011,1243, 1246,1246, 1254,1254, 34023,1255, 34015,1247, 1256,1256, 34025,1257, 
34026,1258, 34027,1259, 34016,1248, 1260,1260, 34017,1249, 1261,1261, 34030,1262, 34031,1263, 34018,1250, 1264,1264, 34019,1251, 1265,1265, 34034,1266, 34020,1252, 1267,1267, 34036,1268, 
34037,1269, 34021,1253, 1254,1254, 1270,1270, 34039,1271, 34023,1255, 369,369, 34024,1256, 368,368, 34025,1257, 1272,1272, 34041,1273, 34042,1274, 34026,1258, 1275,1275, 34027,1259, 
1276,1276, 34028,1260, 1261,1261, 1277,1277, 34046,1278, 34047,1279, 34030,1262, 1280,1280, 34049,1281, 34031,1263, 1282,1282, 34051,1283, 34032,1264, 1265,1265, 1284,1284, 34034,1266, 
1285,1285, 34054,1286, 34035,1267, 1287,1287, 34056,1288, 34036,1268, 1289,1289, 34038,1270, 34037,1269, 
42, // chain 50
939,939, 1241,1241, 1290,1290, 
938,938, 34059,1291, 34060,1292, 34061,1293, 34009,1241, 1294,1294, 34063,1295, 34064,1296, 34008,1240, 1242,1242, 1297,1297, 34066,1298, 33710,942, 943,943, 1299,1299, 33712,944, 
1300,1300, 34069,1301, 33713,945, 1302,1302, 34071,1303, 33181,413, 414,414, 1304,1304, 34073,1305, 33183,415, 416,416, 417,417, 1304,1304, 34074,1306, 34075,1307, 33186,418, 
1308,1308, 33167,399, 400,400, 1309,1309, 33169,401, 1310,1310, 33170,402, 902,902, 33032,264, 
17, // chain 51
1311,1311, 1312,1312, 1207,1207, 
320,320, 33087,319, 33976,1208, 318,318, 34081,1313, 33977,1209, 1314,1314, 34083,1315, 33328,560, 1316,1316, 33329,561, 1317,1317, 33330,562, 471,471, 33238,470, 33331,563, 
76, // chain 52
1318,1318, 1319,1319, 1320,1320, 
1321,1321, 33510,742, 33509,741, 33547,779, 34087,1319, 778,778, 34090,1322, 34086,1318, 1323,1323, 34092,1324, 34093,1325, 34094,1326, 34089,1321, 1327,1327, 33510,742, 743,743, 
1326,1326, 33512,744, 1325,1325, 34096,1328, 34097,1329, 34098,1330, 33513,745, 746,746, 1331,1331, 34100,1332, 33515,747, 1333,1333, 34102,1334, 33516,748, 1335,1335, 33517,749, 
1336,1336, 34105,1337, 33518,750, 751,751, 1338,1338, 34107,1339, 33520,752, 753,753, 1340,1340, 33522,754, 1341,1341, 34110,1342, 33523,755, 1343,1343, 34112,1344, 33524,756, 
757,757, 1345,1345, 34114,1346, 33526,758, 1347,1347, 34116,1348, 33527,759, 1349,1349, 33528,760, 1350,1350, 34119,1351, 34120,1352, 34121,1353, 33529,761, 762,762, 783,783, 
33531,763, 782,782, 33532,764, 781,781, 34122,1354, 33507,739, 1355,1355, 34124,1356, 33508,740, 779,779, 33509,741, 
24, // chain 53
1357,1357, 1358,1358, 1359,1359, 
1360,1360, 33971,1203, 33970,1202, 34129,1361, 34126,1358, 1362,1362, 34131,1363, 34125,1357, 911,911, 33678,910, 33963,1195, 34128,1360, 1364,1364, 33971,1203, 1365,1365, 33972,1204, 
1366,1366, 34135,1367, 33973,1205, 1368,1368, 34080,1312, 33974,1206, 1207,1207, 
95, // chain 54
1369,1369, 1370,1370, 1371,1371, 
1372,1372, 34141,1373, 34142,1374, 34138,1370, 1375,1375, 34144,1376, 34145,1377, 34137,1369, 1378,1378, 34147,1379, 34148,1380, 34140,1372, 1381,1381, 34141,1373, 1382,1382, 34151,1383, 
34152,1384, 34142,1374, 1375,1375, 1385,1385, 34154,1386, 34144,1376, 1387,1387, 34156,1388, 34145,1377, 1389,1389, 34146,1378, 1390,1390, 34159,1391, 34160,1392, 34147,1379, 1393,1393, 
34148,1380, 1394,1394, 34163,1395, 34149,1381, 1396,1396, 34150,1382, 1397,1397, 34166,1398, 34151,1383, 1384,1384, 1399,1399, 34153,1385, 1400,1400, 34169,1401, 34154,1386, 1402,1402, 
33877,1109, 34155,1387, 1403,1403, 34156,1388, 1404,1404, 34173,1405, 34157,1389, 1406,1406, 34175,1407, 34158,1390, 1408,1408, 34177,1409, 34178,1410, 34159,1391, 955,955, 34179,1411, 
34180,1412, 34160,1392, 1393,1393, 1413,1413, 34182,1414, 34183,1415, 34162,1394, 1416,1416, 34163,1395, 1417,1417, 34186,1418, 34164,1396, 1419,1419, 34188,1420, 34165,1397, 1421,1421, 
34166,1398, 1422,1422, 34191,1423, 34167,1399, 1424,1424, 34168,1400, 1425,1425, 34194,1426, 34169,1401, 1402,1402, 1427,1427, 33879,1111, 33878,1110, 33877,1109, 
36, // chain 55
1428,1428, 1429,1429, 1430,1430, 
1431,1431, 34200,1432, 34197,1429, 1433,1433, 34202,1434, 34196,1428, 1435,1435, 34204,1436, 34205,1437, 34199,1431, 1438,1438, 34207,1439, 34208,1440, 34200,1432, 1441,1441, 34210,1442, 
34211,1443, 34201,1433, 1444,1444, 34202,1434, 1445,1445, 34214,1446, 34203,1435, 1447,1447, 34216,1448, 34217,1449, 34204,1436, 1450,1450, 34219,1451, 34205,1437, 1438,1438, 1452,1452, 
34221,1453, 34208,1440, 34207,1439, 
21, // chain 56
922,922, 923,923, 946,946, 
947,947, 921,921, 33716,948, 1454,1454, 33717,949, 1455,1455, 34224,1456, 33718,950, 951,951, 1457,1457, 34226,1458, 34227,1459, 34228,1460, 33720,952, 953,953, 954,954, 
1461,1461, 34230,1462, 34179,1411, 33723,955, 
22, // chain 57
290,290, 1463,1463, 1464,1464, 
289,289, 34233,1465, 34234,1466, 34235,1467, 34236,1468, 34231,1463, 1054,1054, 33821,1053, 34237,1469, 33058,290, 1470,1470, 33059,291, 292,292, 1471,1471, 33061,293, 1472,1472, 
33062,294, 1473,1473, 34242,1474, 33987,1219, 33063,295, 
14, // chain 58
1475,1475, 1441,1441, 1442,1442, 
1476,1476, 34245,1477, 34211,1443, 1478,1478, 34247,1479, 34212,1444, 1480,1480, 34213,1445, 1481,1481, 34250,1482, 34251,1483, 34215,1447, 34214,1446, 
10, // chain 59
1099,1099, 1484,1484, 1485,1485, 
1486,1486, 34255,1487, 34256,1488, 34252,1484, 1489,1489, 34258,1490, 34259,1491, 33868,1100, 33867,1099, 
5, // chain 60
571,571, 572,572, 1492,1492, 
570,570, 34261,1493, 33537,769, 33340,572, 
15, // chain 61
1494,1494, 1322,1322, 1323,1323, 
1324,1324, 1495,1495, 34264,1496, 34265,1497, 34093,1325, 1498,1498, 34096,1328, 1499,1499, 34268,1500, 34269,1501, 34097,1329, 1502,1502, 34099,1331, 34098,1330, 
6, // chain 62
1503,1503, 1194,1194, 1504,1504, 
1505,1505, 34274,1506, 34132,1364, 33963,1195, 33962,1194, 
16, // chain 63
769,769, 770,770, 1507,1507, 
34276,1508, 33539,771, 772,772, 1509,1509, 34278,1510, 33541,773, 1511,1511, 33542,774, 1495,1495, 33543,775, 1494,1494, 33544,776, 777,777, 1322,1322, 33546,778, 
9, // chain 64
1512,1512, 1513,1513, 1514,1514, 
1515,1515, 34284,1516, 34285,1517, 34286,1518, 34281,1513, 1519,1519, 34288,1520, 34280,1512, 
63, // chain 65
1448,1448, 1449,1449, 1521,1521, 
34290,1522, 34218,1450, 1523,1523, 34292,1524, 34219,1451, 1452,1452, 1525,1525, 34294,1526, 34295,1527, 34221,1453, 1528,1528, 34208,1440, 1529,1529, 34209,1441, 1475,1475, 1528,1528, 
34298,1530, 34299,1531, 34244,1476, 1532,1532, 34301,1533, 34245,1477, 1478,1478, 1534,1534, 34247,1479, 1535,1535, 34304,1536, 34248,1480, 1481,1481, 1537,1537, 34306,1538, 34307,1539, 
34250,1482, 1540,1540, 34251,1483, 1541,1541, 34310,1542, 34215,1447, 1448,1448, 1543,1543, 34289,1521, 1544,1544, 34313,1545, 34314,1546, 34315,1547, 34290,1522, 1548,1548, 33753,985, 
34291,1523, 984,984, 34317,1549, 34318,1550, 34292,1524, 1525,1525, 1551,1551, 34320,1552, 34294,1526, 1553,1553, 34295,1527, 1554,1554, 34298,1530, 34296,1528, 
20, // chain 66
1555,1555, 1556,1556, 325,325, 
1557,1557, 33079,311, 1558,1558, 33080,312, 1559,1559, 34328,1560, 34329,1561, 33081,313, 314,314, 1562,1562, 34331,1563, 33083,315, 1564,1564, 33084,316, 1565,1565, 34083,1315, 
34082,1314, 33086,318, 33085,317, 
40, // chain 67
1566,1566, 1567,1567, 1508,1508, 
1509,1509, 1568,1568, 34278,1510, 1569,1569, 34279,1511, 1570,1570, 34263,1495, 1496,1496, 1571,1571, 34265,1497, 1572,1572, 34341,1573, 34266,1498, 1574,1574, 34267,1499, 1575,1575, 
34344,1576, 34268,1500, 1577,1577, 34269,1501, 1578,1578, 34347,1579, 34348,1580, 34270,1502, 1581,1581, 34099,1331, 1332,1332, 1333,1333, 1582,1582, 34351,1583, 34352,1584, 34102,1334, 
1585,1585, 34103,1335, 1336,1336, 1586,1586, 34355,1587, 34106,1338, 34105,1337, 
27, // chain 68
1097,1097, 1486,1486, 1588,1588, 
1096,1096, 34357,1589, 34358,1590, 34359,1591, 34360,1592, 34254,1486, 1593,1593, 34362,1594, 34255,1487, 1273,1273, 34040,1272, 33134,366, 33133,365, 34256,1488, 364,364, 33130,362, 
34257,1489, 1595,1595, 34364,1596, 34258,1490, 1597,1597, 34366,1598, 34367,1599, 34259,1491, 1101,1101, 33868,1100, 
12, // chain 69
1600,1600, 1601,1601, 1602,1602, 
1532,1532, 34371,1603, 34372,1604, 34107,1339, 34369,1601, 1338,1338, 34355,1587, 34368,1600, 1605,1605, 34301,1533, 34300,1532, 
21, // chain 70
1606,1606, 1607,1607, 1608,1608, 
1307,1307, 34074,1306, 34377,1609, 34378,1610, 34375,1607, 1611,1611, 34380,1612, 34381,1613, 34382,1614, 34383,1615, 34374,1606, 1307,1307, 1308,1308, 1614,1614, 34077,1309, 1616,1616, 
33672,904, 33671,903, 34078,1310, 902,902, 
11, // chain 71
797,797, 798,798, 1617,1617, 
33681,913, 33680,912, 34386,1618, 33567,799, 800,800, 1363,1363, 34130,1362, 34387,1619, 33570,802, 33569,801, 
1, // chain 72
1106,1106, 72,72, 73,73, 
27, // chain 73
1620,1620, 1621,1621, 1622,1622, 
1623,1623, 34392,1624, 34393,1625, 34394,1626, 34395,1627, 34389,1621, 378,378, 33145,377, 34396,1628, 34388,1620, 1629,1629, 34398,1630, 34399,1631, 34391,1623, 1632,1632, 34401,1633, 
34402,1634, 34392,1624, 1625,1625, 1635,1635, 34404,1636, 34394,1626, 359,359, 33126,358, 33146,378, 34395,1627, 
12, // chain 74
1216,1216, 1556,1556, 1555,1555, 
1215,1215, 33982,1214, 34405,1637, 34325,1557, 1558,1558, 1559,1559, 1638,1638, 34328,1560, 1639,1639, 34330,1562, 34329,1561, 
41, // chain 75
1640,1640, 1641,1641, 1642,1642, 
1643,1643, 34412,1644, 34413,1645, 34414,1646, 34415,1647, 34416,1648, 34409,1641, 1649,1649, 34418,1650, 34419,1651, 34420,1652, 34408,1640, 1575,1575, 34411,1643, 1653,1653, 34422,1654, 
34412,1644, 1655,1655, 34413,1645, 1656,1656, 34425,1657, 34414,1646, 1647,1647, 1658,1658, 34427,1659, 34416,1648, 1660,1660, 34417,1649, 1661,1661, 34366,1598, 34430,1662, 34431,1663, 
34418,1650, 1664,1664, 34419,1651, 1665,1665, 34434,1666, 34420,1652, 1576,1576, 34343,1575, 
14, // chain 76
1667,1667, 1668,1668, 1669,1669, 
1281,1281, 34048,1280, 34438,1670, 34439,1671, 34436,1668, 1672,1672, 34441,1673, 34442,1674, 34435,1667, 1675,1675, 34051,1283, 34050,1282, 34049,1281, 
18, // chain 77
1676,1676, 1423,1423, 1677,1677, 
1678,1678, 34447,1679, 34448,1680, 34449,1681, 34191,1423, 1682,1682, 34192,1424, 1683,1683, 34193,1425, 1684,1684, 34453,1685, 34194,1426, 1427,1427, 1686,1686, 33054,286, 33053,285, 
33879,1111, 
25, // chain 78
1422,1422, 1423,1423, 1676,1676, 
1687,1687, 34446,1678, 1688,1688, 34457,1689, 34447,1679, 1690,1690, 34448,1680, 1691,1691, 34460,1692, 34461,1693, 34462,1694, 34449,1681, 1695,1695, 34450,1682, 1696,1696, 34451,1683, 
1697,1697, 34452,1684, 1698,1698, 34467,1699, 34468,1700, 34453,1685, 286,286, 34454,1686, 
1, // chain 79
1486,1486, 1097,1097, 1099,1099, 
18, // chain 80
1701,1701, 1638,1638, 1702,1702, 
480,480, 33247,479, 33246,478, 34471,1703, 34472,1704, 34406,1638, 1639,1639, 1705,1705, 34474,1706, 34475,1707, 34330,1562, 1708,1708, 34331,1563, 1564,1564, 1709,1709, 34083,1315, 
34333,1565, 
12, // chain 81
1421,1421, 1422,1422, 1687,1687, 
1710,1710, 34456,1688, 1711,1711, 34480,1712, 34481,1713, 34457,1689, 1714,1714, 34483,1715, 34484,1716, 34459,1691, 34458,1690, 
4, // chain 82
1717,1717, 1635,1635, 1636,1636, 
1718,1718, 33128,360, 33127,359, 
25, // chain 83
451,451, 581,581, 582,582, 
450,450, 33406,638, 33351,583, 1719,1719, 34488,1720, 34489,1721, 33352,584, 1722,1722, 33353,585, 586,586, 1723,1723, 34492,1724, 33355,587, 1725,1725, 33356,588, 1726,1726, 
33357,589, 1727,1727, 33358,590, 1728,1728, 33222,454, 33359,591, 453,453, 33220,452, 
22, // chain 84
1729,1729, 1730,1730, 1731,1731, 
1732,1732, 34501,1733, 34461,1693, 34484,1716, 34502,1734, 34503,1735, 34498,1730, 1736,1736, 34505,1737, 34506,1738, 34497,1729, 1165,1165, 34507,1739, 34500,1732, 1162,1162, 34508,1740, 
34509,1741, 34510,1742, 34501,1733, 1694,1694, 34461,1693, 
13, // chain 85
1415,1415, 1416,1416, 1743,1743, 
1744,1744, 34513,1745, 34184,1416, 1746,1746, 34185,1417, 1747,1747, 34186,1418, 1711,1711, 34187,1419, 1710,1710, 34189,1421, 34188,1420, 
40, // chain 86
1748,1748, 1414,1414, 1415,1415, 
1744,1744, 1749,1749, 34518,1750, 34519,1751, 34520,1752, 34513,1745, 1753,1753, 34514,1746, 1754,1754, 34515,1747, 1755,1755, 34479,1711, 1712,1712, 1713,1713, 1756,1756, 34482,1714, 
1757,1757, 34483,1715, 1758,1758, 34527,1759, 34484,1716, 1734,1734, 1760,1760, 34503,1735, 1761,1761, 34530,1762, 34531,1763, 34532,1764, 34504,1736, 1765,1765, 33764,996, 34505,1737, 
995,995, 34534,1766, 32976,208, 32975,207, 34506,1738, 1166,1166, 33933,1165, 
16, // chain 87
1767,1767, 1768,1768, 1285,1285, 
1769,1769, 34054,1286, 1770,1770, 34055,1287, 1771,1771, 34540,1772, 34056,1288, 1289,1289, 374,374, 33141,373, 34038,1270, 372,372, 34039,1271, 370,370, 33137,369, 
5, // chain 88
1773,1773, 1718,1718, 360,360, 
361,361, 1774,1774, 34363,1595, 33130,362, 
12, // chain 89
1775,1775, 1776,1776, 1617,1617, 
913,913, 914,914, 915,915, 1777,1777, 34546,1778, 33684,916, 917,917, 1779,1779, 34548,1780, 33687,919, 33686,918, 
3, // chain 90
1603,1603, 1781,1781, 1530,1530, 
1531,1531, 1532,1532, 
9, // chain 91
426,426, 1782,1782, 1783,1783, 
425,425, 34552,1784, 34553,1785, 34080,1312, 34550,1782, 1368,1368, 33195,427, 33194,426, 
8, // chain 92
900,900, 1197,1197, 1786,1786, 
768,768, 33534,766, 33533,765, 33695,927, 33965,1197, 926,926, 33693,925, 
6, // chain 93
1787,1787, 1788,1788, 1781,1781, 
1603,1603, 1604,1604, 1341,1341, 34108,1340, 34107,1339, 
2, // chain 94
1716,1716, 1691,1691, 1692,1692, 
1693,1693, 
9, // chain 95
1755,1755, 1789,1789, 1790,1790, 
1754,1754, 34521,1753, 34559,1791, 34560,1792, 34525,1757, 34557,1789, 1756,1756, 34523,1755, 
14, // chain 96
1751,1751, 1752,1752, 1753,1753, 
1793,1793, 34559,1791, 1792,1792, 1794,1794, 34563,1795, 34564,1796, 34565,1797, 34525,1757, 1798,1798, 34526,1758, 1761,1761, 34528,1760, 34527,1759, 
8, // chain 97
1799,1799, 1800,1800, 1749,1749, 
1801,1801, 34570,1802, 34571,1803, 34518,1750, 1794,1794, 34561,1793, 34519,1751, 
5, // chain 98
1804,1804, 1300,1300, 1805,1805, 
1806,1806, 34070,1302, 34069,1301, 34068,1300, 
24, // chain 99
1766,1766, 208,208, 209,209, 
1807,1807, 34576,1808, 32978,210, 211,211, 1809,1809, 34578,1810, 32980,212, 213,213, 1811,1811, 32982,214, 1812,1812, 34581,1813, 34582,1814, 32983,215, 216,216, 1146,1146, 
32985,217, 1145,1145, 34583,1815, 32986,218, 1142,1142, 32971,203, 204,204, 
26, // chain 100
1816,1816, 1817,1817, 1818,1818, 
1819,1819, 34588,1820, 34589,1821, 34590,1822, 34591,1823, 34585,1817, 1094,1094, 34592,1824, 34584,1816, 856,856, 34593,1825, 34587,1819, 1826,1826, 34595,1827, 34588,1820, 1828,1828, 
34597,1829, 34598,1830, 34589,1821, 1589,1589, 34590,1822, 1096,1096, 33863,1095, 34591,1823, 1094,1094, 
17, // chain 101
1296,1296, 1297,1297, 1831,1831, 
34600,1832, 34601,1833, 34602,1834, 34066,1298, 1835,1835, 34067,1299, 1300,1300, 1804,1804, 1836,1836, 34605,1837, 34574,1806, 1838,1838, 34607,1839, 34608,1840, 34071,1303, 34070,1302, 
12, // chain 102
1294,1294, 1841,1841, 1842,1842, 
1843,1843, 33962,1194, 33961,1193, 34609,1841, 1844,1844, 34613,1845, 34614,1846, 34062,1294, 1295,1295, 1831,1831, 34064,1296, 
4, // chain 103
325,325, 1556,1556, 1847,1847, 
33252,484, 33985,1217, 33984,1216, 
3, // chain 104
1354,1354, 1355,1355, 1356,1356, 
780,780, 33547,779, 
9, // chain 105
995,995, 1766,1766, 1807,1807, 
994,994, 33761,993, 34616,1848, 34576,1808, 1809,1809, 1849,1849, 34579,1811, 34578,1810, 
8, // chain 106
1832,1832, 1833,1833, 1850,1850, 
1851,1851, 34606,1838, 34620,1852, 34601,1833, 1836,1836, 34602,1834, 1835,1835, 
34, // chain 107
1853,1853, 1794,1794, 1795,1795, 
790,790, 33556,788, 34564,1796, 787,787, 34622,1854, 34623,1855, 34565,1797, 1856,1856, 34625,1857, 34566,1798, 1858,1858, 34529,1761, 1762,1762, 1859,1859, 34628,1860, 34531,1763, 
1764,1764, 1861,1861, 34533,1765, 1862,1862, 33764,996, 997,997, 1863,1863, 34632,1864, 33766,998, 981,981, 1865,1865, 34634,1866, 33750,982, 1867,1867, 34317,1549, 33752,984, 
33751,983, 
2, // chain 108
791,791, 1794,1794, 1853,1853, 
790,790, 
13, // chain 109
1794,1794, 791,791, 1803,1803, 
34636,1868, 33560,792, 1802,1802, 34569,1801, 33561,793, 1799,1799, 33563,795, 1869,1869, 33564,796, 797,797, 1776,1776, 34385,1617, 
1, // chain 110
1803,1803, 1868,1868, 1802,1802, 
1, // chain 111
326,326, 1106,1106, 327,327, 
19, // chain 112
1660,1660, 1661,1661, 1102,1102, 
1659,1659, 33871,1103, 1658,1658, 33872,1104, 1870,1870, 34639,1871, 33873,1105, 1089,1089, 1872,1872, 34641,1873, 33858,1090, 1091,1091, 862,862, 33629,861, 34642,1874, 33860,1092, 
860,860, 861,861, 
22, // chain 113
1857,1857, 1858,1858, 1875,1875, 
1876,1876, 34645,1877, 34626,1858, 1859,1859, 1878,1878, 34647,1879, 34648,1880, 34649,1881, 34628,1860, 1861,1861, 1882,1882, 34630,1862, 1863,1863, 1883,1883, 34652,1884, 34632,1864, 
1865,1865, 1885,1885, 34654,1886, 34635,1867, 34634,1866, 
5, // chain 114
1857,1857, 1876,1876, 1856,1856, 
34655,1887, 34656,1888, 34646,1878, 34645,1877, 
15, // chain 115
1856,1856, 1887,1887, 1855,1855, 
34657,1889, 34658,1890, 34656,1888, 1891,1891, 34660,1892, 34661,1893, 34646,1878, 1894,1894, 34647,1879, 1895,1895, 34648,1880, 1883,1883, 34650,1882, 34649,1881, 
1, // chain 116
789,789, 790,790, 788,788, 
31, // chain 117
1788,1788, 1787,1787, 1341,1341, 
1896,1896, 34110,1342, 1897,1897, 34111,1343, 1898,1898, 34667,1899, 34668,1900, 34112,1344, 1345,1345, 1346,1346, 1901,1901, 34115,1347, 1902,1902, 34671,1903, 34116,1348, 1892,1892, 
34659,1891, 34117,1349, 1350,1350, 1890,1890, 34622,1854, 33554,786, 34119,1351, 785,785, 34120,1352, 784,784, 34672,1904, 34121,1353, 783,783, 784,784, 
2, // chain 118
1854,1854, 1855,1855, 1889,1889, 
1890,1890, 
9, // chain 119
1905,1905, 1633,1633, 1634,1634, 
1635,1635, 1906,1906, 34485,1717, 1907,1907, 34676,1908, 34542,1774, 34541,1773, 34486,1718, 
15, // chain 120
1507,1507, 1508,1508, 1567,1567, 
1909,1909, 34678,1910, 34679,1911, 34680,1912, 34334,1566, 1913,1913, 34336,1568, 1914,1914, 34337,1569, 1915,1915, 34338,1570, 1916,1916, 34340,1572, 34339,1571, 
1, // chain 121
1854,1854, 786,786, 787,787, 
44, // chain 122
1917,1917, 1918,1918, 1919,1919, 
1920,1920, 34689,1921, 34690,1922, 34686,1918, 1923,1923, 34692,1924, 34693,1925, 34685,1917, 1926,1926, 34695,1927, 34688,1920, 1928,1928, 34689,1921, 1929,1929, 34698,1930, 34261,1493, 
34690,1922, 570,570, 34699,1931, 34691,1923, 1932,1932, 34701,1933, 34702,1934, 34692,1924, 1935,1935, 34704,1936, 33610,842, 34705,1937, 34693,1925, 1938,1938, 34694,1926, 1939,1939, 
34695,1927, 1928,1928, 1940,1940, 34709,1941, 34710,1942, 34697,1929, 1930,1930, 1943,1943, 34275,1507, 33537,769, 34261,1493, 
12, // chain 123
1785,1785, 1312,1312, 1311,1311, 
320,320, 1944,1944, 33089,321, 322,322, 1784,1784, 34713,1945, 33091,323, 485,485, 34615,1847, 33092,324, 325,325, 
8, // chain 124
1883,1883, 1884,1884, 1885,1885, 
1946,1946, 34654,1886, 1947,1947, 34716,1948, 34318,1550, 34635,1867, 1549,1549, 
8, // chain 125
1949,1949, 1895,1895, 1946,1946, 
1947,1947, 1950,1950, 34719,1951, 34320,1552, 34716,1948, 1551,1551, 34318,1550, 
30, // chain 126
604,604, 605,605, 1952,1952, 
603,603, 34721,1953, 34722,1954, 33729,961, 33373,605, 1955,1955, 34724,1956, 33374,606, 1957,1957, 33375,607, 608,608, 1958,1958, 33377,609, 1409,1409, 34176,1408, 33378,610, 
611,611, 1959,1959, 32835,67, 68,68, 1406,1406, 34172,1404, 32837,69, 1960,1960, 34729,1961, 32838,70, 1107,1107, 32839,71, 72,72, 
1, // chain 127
372,372, 370,370, 371,371, 
8, // chain 128
1846,1846, 1831,1831, 1962,1962, 
34731,1963, 34600,1832, 1851,1851, 1964,1964, 34733,1965, 34607,1839, 34606,1838, 
2, // chain 129
378,378, 379,379, 358,358, 
33125,357, 
18, // chain 130
1966,1966, 1967,1967, 1968,1968, 
1969,1969, 33230,462, 34738,1970, 34739,1971, 34740,1972, 34741,1973, 34735,1967, 1974,1974, 34743,1975, 34744,1976, 34745,1977, 34746,1978, 34734,1966, 1979,1979, 33231,463, 34737,1969, 
462,462, 
12, // chain 131
1980,1980, 1826,1826, 1827,1827, 
1828,1828, 1981,1981, 34750,1982, 34751,1983, 34597,1829, 1984,1984, 34753,1985, 34754,1986, 34358,1590, 34598,1830, 1589,1589, 
11, // chain 132
1899,1899, 1900,1900, 1951,1951, 
1987,1987, 34320,1552, 1553,1553, 1554,1554, 1988,1988, 34298,1530, 1781,1781, 1788,1788, 1897,1897, 34664,1896, 
56, // chain 133
1989,1989, 1990,1990, 1991,1991, 
1992,1992, 34761,1993, 34762,1994, 34758,1990, 1995,1995, 34764,1996, 34765,1997, 34766,1998, 34757,1989, 1999,1999, 34768,2000, 34769,2001, 34770,2002, 34760,1992, 2003,2003, 34772,2004, 
34761,1993, 2005,2005, 34774,2006, 34775,2007, 34776,2008, 34762,1994, 2009,2009, 34763,1995, 2010,2010, 34779,2011, 34764,1996, 1971,1971, 34738,1970, 34780,2012, 34765,1997, 2013,2013, 
34782,2014, 34783,2015, 34766,1998, 1999,1999, 2016,2016, 34785,2017, 34768,2000, 2018,2018, 34769,2001, 2019,2019, 34788,2020, 34770,2002, 2021,2021, 34790,2022, 34771,2003, 2004,2004, 
2023,2023, 34792,2024, 34793,2025, 34794,2026, 34773,2005, 2007,2007, 34774,2006, 
3, // chain 134
1898,1898, 1899,1899, 1987,1987, 
1988,1988, 1897,1897, 
1, // chain 135
780,780, 781,781, 1354,1354, 
13, // chain 136
2027,2027, 2028,2028, 2029,2029, 
1192,1192, 33959,1191, 34798,2030, 34799,2031, 34796,2028, 1612,1612, 34800,2032, 34801,2033, 34795,2027, 1844,1844, 33960,1192, 1193,1193, 
43, // chain 137
2034,2034, 2035,2035, 2036,2036, 
2037,2037, 34806,2038, 34803,2035, 2039,2039, 34808,2040, 34809,2041, 34810,2042, 34802,2034, 2043,2043, 34812,2044, 34805,2037, 2045,2045, 34814,2046, 34806,2038, 2047,2047, 33758,990, 
34807,2039, 989,989, 34808,2040, 988,988, 33755,987, 34809,2041, 1548,1548, 34810,2042, 2043,2043, 1546,1546, 34812,2044, 2048,2048, 34813,2045, 2049,2049, 34814,2046, 2050,2050, 
34819,2051, 2052,2052, 34821,2053, 34822,2054, 34823,2055, 2056,2056, 34825,2057, 2058,2058, 34285,1517, 34284,1516, 
15, // chain 138
2059,2059, 2060,2060, 2061,2061, 
2062,2062, 34302,1534, 34831,2063, 34828,2060, 1587,1587, 34354,1586, 34832,2064, 34827,2059, 2065,2065, 34834,2066, 34830,2062, 2067,2067, 34303,1535, 34302,1534, 
36, // chain 139
2068,2068, 2069,2069, 2070,2070, 
2071,2071, 34840,2072, 34841,2073, 34842,2074, 34843,2075, 34837,2069, 2076,2076, 34845,2077, 34846,2078, 34836,2068, 2079,2079, 34438,1670, 34848,2080, 34839,2071, 2072,2072, 2081,2081, 
34841,2073, 2082,2082, 34851,2083, 34842,2074, 2084,2084, 34853,2085, 34843,2075, 2076,2076, 2086,2086, 34855,2087, 34856,2088, 34845,2077, 2089,2089, 34858,2090, 34846,2078, 2091,2091, 
34847,2079, 1671,1671, 34438,1670, 
8, // chain 140
2092,2092, 2082,2082, 2093,2093, 
1982,1982, 34862,2094, 34863,2095, 34864,2096, 34850,2082, 2084,2084, 34851,2083, 
11, // chain 141
1666,1666, 1576,1576, 1577,1577, 
1578,1578, 2097,2097, 34347,1579, 1580,1580, 2098,2098, 34867,2099, 34868,2100, 34869,2101, 34350,1582, 34349,1581, 
2, // chain 142
377,377, 2102,2102, 375,375, 
376,376, 
6, // chain 143
1459,1459, 1460,1460, 1461,1461, 
2103,2103, 34872,2104, 34230,1462, 1412,1412, 34179,1411, 
5, // chain 144
1612,1612, 1613,1613, 2031,2031, 
34798,2030, 34873,2105, 34384,1616, 34382,1614, 
3, // chain 145
1629,1629, 1770,1770, 2102,2102, 
1628,1628, 33145,377, 
7, // chain 146
1455,1455, 1456,1456, 1457,1457, 
2106,2106, 34226,1458, 2107,2107, 34876,2108, 34871,2103, 34227,1459, 
16, // chain 147
2109,2109, 2110,2110, 2111,2111, 
2112,2112, 34676,1908, 34675,1907, 34878,2110, 1906,1906, 34881,2113, 34882,2114, 34883,2115, 34877,2109, 2116,2116, 34880,2112, 2117,2117, 34886,2118, 34542,1774, 34676,1908, 
17, // chain 148
920,920, 921,921, 1454,1454, 
2119,2119, 34888,2120, 34223,1455, 2106,2106, 2121,2121, 34890,2122, 34875,2107, 2123,2123, 34892,2124, 34893,2125, 34876,2108, 1414,1414, 34181,1413, 34871,2103, 2104,2104, 1412,1412, 
8, // chain 149
2126,2126, 2127,2127, 2117,2117, 
2128,2128, 34886,2118, 2129,2129, 34365,1597, 34364,1596, 34542,1774, 1595,1595, 
6, // chain 150
2101,2101, 1582,1582, 2130,2130, 
2100,2100, 34899,2131, 34900,2132, 34351,1583, 34350,1582, 
19, // chain 151
2133,2133, 2134,2134, 1538,1538, 
2135,2135, 34904,2136, 34905,2137, 34307,1539, 1540,1540, 2138,2138, 34309,1541, 2139,2139, 34908,2140, 34310,1542, 1543,1543, 1544,1544, 2141,2141, 34910,2142, 34911,2143, 34816,2048, 
34313,1545, 1546,1546, 
13, // chain 152
2128,2128, 2144,2144, 2145,2145, 
2126,2126, 34867,2099, 34912,2144, 2098,2098, 34433,1665, 34896,2128, 1664,1664, 34914,2146, 34897,2129, 1662,1662, 34366,1598, 34365,1597, 
12, // chain 153
1839,1839, 1609,1609, 1610,1610, 
2147,2147, 34379,1611, 2148,2148, 34917,2149, 34380,1612, 2032,2032, 2150,2150, 34801,2033, 2151,2151, 34613,1845, 34612,1844, 
17, // chain 154
1780,1780, 920,920, 2119,2119, 
2152,2152, 34921,2153, 34888,2120, 2121,2121, 2154,2154, 34923,2155, 34924,2156, 34890,2122, 2157,2157, 34891,2123, 2158,2158, 34927,2159, 34892,2124, 2125,2125, 1748,1748, 34182,1414, 
14, // chain 155
2160,2160, 2136,2136, 2138,2138, 
2139,2139, 2161,2161, 34930,2162, 34908,2140, 2141,2141, 2163,2163, 34910,2142, 2164,2164, 34933,2165, 34818,2050, 34911,2143, 2049,2049, 34816,2048, 
1, // chain 156
1780,1780, 919,919, 920,920, 
1, // chain 157
2138,2138, 2136,2136, 2137,2137, 
4, // chain 158
1063,1063, 1064,1064, 2166,2166, 
34935,2167, 33834,1066, 33833,1065, 
3, // chain 159
1535,1535, 1536,1536, 1537,1537, 
2134,2134, 34306,1538, 
7, // chain 160
1965,1965, 1839,1839, 2147,2147, 
1964,1964, 34936,2168, 34916,2148, 2151,2151, 34918,2150, 34917,2149, 
4, // chain 161
2153,2153, 2154,2154, 1778,1778, 
2152,2152, 34547,1779, 1780,1780, 
4, // chain 162
1293,1293, 1294,1294, 1843,1843, 
1292,1292, 34271,1503, 33962,1194, 
9, // chain 163
2155,2155, 2156,2156, 2157,2157, 
2169,2169, 34926,2158, 2170,2170, 34939,2171, 34568,1800, 34927,2159, 1748,1748, 1749,1749, 
9, // chain 164
1778,1778, 2154,2154, 2155,2155, 
1777,1777, 34937,2169, 2172,2172, 34938,2170, 1869,1869, 34939,2171, 1799,1799, 34568,1800, 
16, // chain 165
1672,1672, 1673,1673, 2173,2173, 
1671,1671, 34859,2091, 34942,2174, 34791,2023, 34441,1673, 2175,2175, 34944,2176, 34442,1674, 2177,2177, 34946,2178, 34947,2179, 34443,1675, 2180,2180, 34052,1284, 34051,1283, 
13, // chain 166
1849,1849, 1811,1811, 1812,1812, 
2181,2181, 34950,2182, 34581,1813, 2183,2183, 34582,1814, 1727,1727, 33914,1146, 1147,1147, 1726,1726, 34493,1725, 33917,1149, 33916,1148, 
8, // chain 167
1905,1905, 2161,2161, 2184,2184, 
1633,1633, 34953,2185, 34954,2186, 34955,2187, 34929,2161, 2163,2163, 34930,2162, 
2, // chain 168
2127,2127, 2115,2115, 2116,2116, 
2117,2117, 
4, // chain 169
1583,1583, 1584,1584, 2065,2065, 
34353,1585, 2064,2064, 34354,1586, 
15, // chain 170
2115,2115, 2188,2188, 2189,2189, 
2114,2114, 34904,2136, 34903,2135, 34956,2188, 2133,2133, 34958,2190, 34959,2191, 34883,2115, 2192,2192, 34895,2127, 2126,2126, 2131,2131, 34867,2099, 2100,2100, 
3, // chain 171
1304,1304, 1306,1306, 2193,2193, 
1609,1609, 34074,1306, 
12, // chain 172
2194,2194, 2195,2195, 626,626, 
2196,2196, 34965,2197, 34966,2198, 33395,627, 628,628, 2199,2199, 33397,629, 2200,2200, 33398,630, 632,632, 33399,631, 
9, // chain 173
2191,2191, 2192,2192, 2201,2201, 
34970,2202, 34899,2131, 2201,2201, 34971,2203, 34900,2132, 2066,2066, 34833,2065, 34351,1583, 
3, // chain 174
1775,1775, 1777,1777, 2172,2172, 
1776,1776, 34637,1869, 
5, // chain 175
2190,2190, 2191,2191, 2204,2204, 
34969,2201, 2203,2203, 2067,2067, 34834,2066, 
5, // chain 176
2160,2160, 2161,2161, 1905,1905, 
1906,1906, 2113,2113, 2136,2136, 34882,2114, 
2, // chain 177
1665,1665, 1666,1666, 2097,2097, 
2098,2098, 
4, // chain 178
1772,1772, 374,374, 375,375, 
2102,2102, 1771,1771, 34538,1770, 
7, // chain 179
481,481, 482,482, 1212,1212, 
480,480, 33981,1213, 1701,1701, 33982,1214, 1637,1637, 1638,1638, 
2, // chain 180
1548,1548, 985,985, 986,986, 
987,987, 
26, // chain 181
2205,2205, 2206,2206, 2207,2207, 
2208,2208, 34977,2209, 1519,1519, 34978,2210, 2211,2211, 34980,2212, 2213,2213, 34982,2214, 34983,2215, 2216,2216, 2217,2217, 34782,2014, 34986,2218, 2013,2013, 34987,2219, 459,459, 
34988,2220, 458,458, 33225,457, 34989,2221, 34990,2222, 34991,2223, 2224,2224, 34973,2205, 34974,2206, 
4, // chain 182
1916,1916, 1572,1572, 1573,1573, 
1574,1574, 1653,1653, 34343,1575, 
3, // chain 183
2063,2063, 1587,1587, 1605,1605, 
1534,1534, 34301,1533, 
14, // chain 184
625,625, 626,626, 2195,2195, 
1976,1976, 34743,1975, 34993,2225, 34962,2194, 2226,2226, 34995,2227, 34996,2228, 34997,2229, 34964,2196, 2197,2197, 2230,2230, 34967,2199, 34966,2198, 
2, // chain 185
1663,1663, 1664,1664, 2146,2146, 
1662,1662, 
5, // chain 186
2105,2105, 904,904, 905,905, 
2030,2030, 33674,906, 1191,1191, 33675,907, 
4, // chain 187
2231,2231, 540,540, 517,517, 
1042,1042, 1044,1044, 33811,1043, 
23, // chain 188
2232,2232, 2233,2233, 2234,2234, 
2235,2235, 35004,2236, 35005,2237, 35006,2238, 35001,2233, 2239,2239, 35008,2240, 35009,2241, 34979,2211, 35000,2232, 1518,1518, 35003,2235, 1517,1517, 35010,2242, 35004,2236, 2243,2243, 
35012,2244, 35013,2245, 35005,2237, 2246,2246, 35007,2239, 35006,2238, 
1, // chain 189
2105,2105, 1616,1616, 904,904, 
1, // chain 190
1546,1546, 1547,1547, 1548,1548, 
3, // chain 191
2204,2204, 2067,2067, 1535,1535, 
2133,2133, 34902,2134, 
4, // chain 192
1846,1846, 1962,1962, 2151,2151, 
34936,2168, 34732,1964, 34731,1963, 
1, // chain 193
1217,1217, 483,483, 484,484, 
2, // chain 194
1840,1840, 1304,1304, 1609,1609, 
1839,1839, 
1, // chain 195
2133,2133, 2190,2190, 2204,2204, 
2, // chain 196
911,911, 912,912, 1618,1618, 
1363,1363, 
1, // chain 197
1304,1304, 1840,1840, 1303,1303, 
1, // chain 198
1944,1944, 1784,1784, 1785,1785, 
2, // chain 199
486,486, 425,425, 1945,1945, 
485,485, 
1, // chain 200
2151,2151, 1845,1845, 1846,1846, 
15, // chain 201
2185,2185, 2247,2247, 2248,2248, 
1632,1632, 34399,1631, 35017,2249, 35015,2247, 2250,2250, 35019,2251, 35020,2252, 34953,2185, 2186,2186, 2253,2253, 35022,2254, 34955,2187, 2164,2164, 34931,2163, 
6, // chain 202
2255,2255, 2205,2205, 2256,2256, 
2257,2257, 35026,2258, 33759,991, 34815,2047, 990,990, 
2, // chain 203
1837,1837, 1838,1838, 1852,1852, 
1836,1836, 
3, // chain 204
1953,1953, 697,697, 698,698, 
602,602, 603,603, 
9, // chain 205
1063,1063, 2166,2166, 2199,2199, 
34998,2230, 34935,2167, 2259,2259, 35028,2260, 33834,1066, 520,520, 522,522, 33289,521, 
3, // chain 206
2089,2089, 2090,2090, 2024,2024, 
34942,2174, 34859,2091, 
7, // chain 207
2261,2261, 1278,1278, 2081,2081, 
2262,2262, 34850,2082, 2092,2092, 1984,1984, 34751,1983, 34750,1982, 
15, // chain 208
2089,2089, 2024,2024, 2025,2025, 
2263,2263, 34794,2026, 2264,2264, 35033,2265, 34775,2007, 2266,2266, 34776,2008, 2267,2267, 34777,2009, 2268,2268, 34778,2010, 1972,1972, 34779,2011, 1971,1971, 
45, // chain 209
844,844, 531,531, 2269,2269, 
33300,532, 2270,2270, 33301,533, 2271,2271, 33302,534, 2272,2272, 35041,2273, 33303,535, 2274,2274, 35043,2275, 33304,536, 537,537, 2276,2276, 35045,2277, 33306,538, 2278,2278, 
33307,539, 2279,2279, 35048,2280, 33308,540, 2231,2231, 1044,1044, 2281,2281, 33813,1045, 1046,1046, 2282,2282, 33998,1230, 35051,2283, 33815,1047, 2284,2284, 33816,1048, 1229,1229, 
33995,1227, 35053,2285, 33817,1049, 2286,2286, 35055,2287, 33818,1050, 2288,2288, 33819,1051, 2289,2289, 33820,1052, 1469,1469, 33821,1053, 
1, // chain 210
2185,2185, 1632,1632, 1633,1633, 
2, // chain 211
654,654, 656,656, 82,82, 
653,653, 
3, // chain 212
1985,1985, 1986,1986, 2290,2290, 
34359,1591, 34358,1590, 
4, // chain 213
1985,1985, 2290,2290, 2291,2291, 
35060,2292, 34360,1592, 34359,1591, 
4, // chain 214
2254,2254, 2164,2164, 2293,2293, 
34933,2165, 2052,2052, 34818,2050, 
8, // chain 215
1277,1277, 2261,2261, 2294,2294, 
2295,2295, 35060,2292, 35059,2291, 35029,2261, 2262,2262, 1985,1985, 34752,1984, 
3, // chain 216
1815,1815, 1142,1142, 1143,1143, 
1144,1144, 1145,1145, 
1, // chain 217
1277,1277, 1278,1278, 2261,2261, 
9, // chain 218
81,81, 82,82, 656,656, 
657,657, 80,80, 33426,658, 79,79, 33449,681, 33448,680, 33427,659, 660,660, 
10, // chain 219
1981,1981, 1982,1982, 2094,2094, 
2296,2296, 35065,2297, 34863,2095, 2298,2298, 35067,2299, 35068,2300, 34864,2096, 2085,2085, 34852,2084, 
1, // chain 220
654,654, 655,655, 656,656, 
2, // chain 221
845,845, 846,846, 530,530, 
531,531, 
6, // chain 222
2239,2239, 2240,2240, 2018,2018, 
34785,2017, 34784,2016, 34981,2213, 35009,2241, 2211,2211, 
1, // chain 223
1847,1847, 484,484, 485,485, 
23, // chain 224
2020,2020, 2021,2021, 2301,2301, 
35070,2302, 35071,2303, 34790,2022, 2304,2304, 34791,2023, 2175,2175, 2176,2176, 2305,2305, 35074,2306, 35075,2307, 34945,2177, 2308,2308, 34946,2178, 2309,2309, 35078,2310, 35079,2311, 
34947,2179, 2251,2251, 34536,1768, 34948,2180, 1284,1284, 1285,1285, 
3, // chain 225
1102,1102, 1661,1661, 1101,1101, 
34367,1599, 34366,1598, 
2, // chain 226
424,424, 425,425, 486,486, 
170,170, 
1, // chain 227
1784,1784, 1945,1945, 425,425, 
11, // chain 228
428,428, 429,429, 867,867, 
1367,1367, 35080,2312, 33698,930, 35081,2313, 33636,868, 929,929, 33696,928, 33332,564, 565,565, 640,640, 
2, // chain 229
427,427, 428,428, 1367,1367, 
1368,1368, 
1, // chain 230
362,362, 363,363, 364,364, 
1, // chain 231
1197,1197, 900,900, 899,899, 
1, // chain 232
221,221, 127,127, 128,128, 
2, // chain 233
692,692, 900,900, 768,768, 
693,693, 
1, // chain 234
909,909, 910,910, 1195,1195, 
13, // chain 235
2314,2314, 1657,1657, 1658,1658, 
1870,1870, 1656,1656, 35083,2315, 35084,2316, 34639,1871, 2317,2317, 35086,2318, 35087,2319, 34640,1872, 2320,2320, 33630,862, 34641,1873, 
1, // chain 236
2314,2314, 1656,1656, 1657,1657, 
11, // chain 237
1916,1916, 1653,1653, 1654,1654, 
2321,2321, 34423,1655, 1914,1914, 34681,1913, 34424,1656, 1912,1912, 35083,2315, 1911,1911, 35085,2317, 35084,2316, 
2, // chain 238
1915,1915, 1916,1916, 2321,2321, 
1914,1914, 
11, // chain 239
1910,1910, 1911,1911, 2317,2317, 
2322,2322, 35086,2318, 2323,2323, 35092,2324, 35087,2319, 2325,2325, 35088,2320, 864,864, 33631,863, 33630,862, 
23, // chain 240
1061,1061, 634,634, 636,636, 
637,637, 1060,1060, 35094,2326, 33406,638, 1719,1719, 1153,1153, 34488,1720, 1152,1152, 34489,1721, 1722,1722, 2327,2327, 34491,1723, 2328,2328, 34492,1724, 2329,2329, 34493,1725, 
1149,1149, 1150,1150, 2328,2328, 35095,2327, 33919,1151, 1152,1152, 
5, // chain 241
1902,1902, 1893,1893, 2330,2330, 
2331,2331, 35100,2332, 34662,1894, 34661,1893, 
7, // chain 242
2332,2332, 1894,1894, 1949,1949, 
1950,1950, 2331,2331, 34719,1951, 1900,1900, 1901,1901, 1902,1902, 
3, // chain 243
632,632, 1062,1062, 2200,2200, 
33831,1063, 2199,2199, 
2, // chain 244
1903,1903, 1892,1892, 1893,1893, 
1902,1902, 
1, // chain 245
1894,1894, 1895,1895, 1949,1949, 
5, // chain 246
1160,1160, 1161,1161, 2333,2333, 
2334,2334, 34508,1740, 33930,1162, 33929,1161, 
3, // chain 247
1739,1739, 1162,1162, 1163,1163, 
1164,1164, 1165,1165, 
2, // chain 248
2284,2284, 1229,1229, 2283,2283, 
33998,1230, 
4, // chain 249
1960,1960, 1961,1961, 1107,1107, 
1403,1403, 33876,1108, 1109,1109, 
13, // chain 250
931,931, 932,932, 2335,2335, 
33701,933, 934,934, 935,935, 2336,2336, 34274,1506, 33704,936, 1505,1505, 35105,2337, 35106,2338, 33705,937, 1291,1291, 33706,938, 
1, // chain 251
1404,1404, 1960,1960, 1403,1403, 
11, // chain 252
993,993, 1848,1848, 2258,2258, 
34617,1849, 2257,2257, 34949,2181, 2255,2255, 35107,2339, 34950,2182, 2183,2183, 2340,2340, 34496,1728, 34495,1727, 
1, // chain 253
1405,1405, 1406,1406, 1404,1404, 
31, // chain 254
1936,1936, 842,842, 843,843, 
2341,2341, 35110,2342, 33612,844, 2269,2269, 2270,2270, 2341,2341, 35111,2343, 35039,2271, 1933,1933, 35040,2272, 1932,1932, 35041,2273, 810,810, 33576,808, 35042,2274, 2275,2275, 
806,806, 35112,2344, 35044,2276, 2345,2345, 35045,2277, 2346,2346, 35115,2347, 35046,2278, 1233,1233, 34000,1232, 35047,2279, 2282,2282, 35048,2280, 2281,2281, 
19, // chain 255
2348,2348, 2349,2349, 524,524, 
2350,2350, 33293,525, 1179,1179, 2351,2351, 33948,1180, 2352,2352, 35121,2353, 33949,1181, 2354,2354, 35123,2355, 33950,1182, 1183,1183, 2356,2356, 33952,1184, 2357,2357, 35126,2358, 
33954,1186, 33953,1185, 
3, // chain 256
697,697, 1953,1953, 1954,1954, 
962,962, 33729,961, 
3, // chain 257
1280,1280, 1670,1670, 2080,2080, 
1278,1278, 34849,2081, 
10, // chain 258
864,864, 2359,2359, 2360,2360, 
2325,2325, 34709,1941, 34708,1940, 34707,1939, 35127,2359, 1938,1938, 33609,841, 33633,865, 33632,864, 
2, // chain 259
2341,2341, 2361,2361, 1935,1935, 
1936,1936, 
2, // chain 260
367,367, 368,368, 1272,1272, 
366,366, 
29, // chain 261
2362,2362, 478,478, 1703,1703, 
2363,2363, 34472,1704, 1705,1705, 474,474, 33241,473, 34474,1706, 2364,2364, 34475,1707, 1708,1708, 2365,2365, 35134,2366, 34477,1709, 2367,2367, 34083,1315, 1316,1316, 2368,2368, 
34085,1317, 471,471, 2369,2369, 33240,472, 2370,2370, 35139,2371, 33241,473, 2364,2364, 2365,2365, 2370,2370, 35135,2367, 35134,2366, 
5, // chain 262
477,477, 478,478, 2362,2362, 
476,476, 35131,2363, 474,474, 475,475, 
5, // chain 263
2303,2303, 2304,2304, 2372,2372, 
35073,2305, 2373,2373, 35142,2374, 35074,2306, 
11, // chain 264
2375,2375, 2349,2349, 2376,2376, 
2377,2377, 35146,2378, 34996,2228, 34995,2227, 35147,2379, 35117,2349, 2380,2380, 35116,2348, 2351,2351, 35118,2350, 
4, // chain 265
2381,2381, 524,524, 2375,2375, 
2382,2382, 35146,2378, 35145,2377, 
8, // chain 266
523,523, 524,524, 2381,2381, 
522,522, 35150,2382, 2259,2259, 35146,2378, 2230,2230, 34996,2228, 2229,2229, 
1, // chain 267
2259,2259, 2260,2260, 522,522, 
3, // chain 268
1979,1979, 463,463, 464,464, 
623,623, 33233,465, 
5, // chain 269
625,625, 1976,1976, 1977,1977, 
624,624, 34746,1978, 1979,1979, 623,623, 
2, // chain 270
1406,1406, 1407,1407, 1959,1959, 
34176,1408, 
2, // chain 271
2367,2367, 2368,2368, 2370,2370, 
35137,2369, 
10, // chain 272
2383,2383, 2243,2243, 2244,2244, 
2372,2372, 35152,2384, 35013,2245, 2302,2302, 35069,2301, 35014,2246, 2019,2019, 35007,2239, 2018,2018, 
12, // chain 273
2385,2385, 2285,2285, 2286,2286, 
2386,2386, 35155,2387, 35055,2287, 2288,2288, 2386,2386, 34241,1473, 34240,1472, 34239,1471, 35057,2289, 1470,1470, 34237,1469, 
11, // chain 274
2285,2285, 2385,2385, 1226,1226, 
35156,2388, 35157,2389, 35154,2386, 1473,1473, 1474,1474, 2388,2388, 33991,1223, 33990,1222, 33988,1220, 33987,1219, 
3, // chain 275
2343,2343, 1933,1933, 1934,1934, 
2361,2361, 34703,1935, 
2, // chain 276
1225,1225, 1226,1226, 2388,2388, 
1223,1223, 
4, // chain 277
1943,1943, 1507,1507, 1909,1909, 
1942,1942, 35090,2322, 34678,1910, 
5, // chain 278
1931,1931, 1932,1932, 2390,2390, 
569,569, 33336,568, 33578,810, 34700,1932, 
4, // chain 279
1058,1058, 1060,1060, 2326,2326, 
1155,1155, 33922,1154, 33921,1153, 
4, // chain 280
857,857, 858,858, 1824,1824, 
33627,859, 1094,1094, 33861,1093, 
1, // chain 281
1220,1220, 1221,1221, 1222,1222, 
1, // chain 282
569,569, 570,570, 1931,1931, 
1, // chain 283
809,809, 810,810, 808,808, 
4, // chain 284
2292,2292, 1592,1592, 1593,1593, 
1274,1274, 34362,1594, 1273,1273, 
3, // chain 285
1941,1941, 1942,1942, 2323,2323, 
2324,2324, 2325,2325, 
4, // chain 286
2295,2295, 2292,2292, 1274,1274, 
1275,1275, 1276,1276, 1277,1277, 
1, // chain 287
206,206, 207,207, 1166,1166, 
1, // chain 288
1895,1895, 1883,1883, 1946,1946, 
3, // chain 289
530,530, 846,846, 529,529, 
33946,1178, 33615,847, 
12, // chain 290
2268,2268, 1972,1972, 1973,1973, 
1974,1974, 2267,2267, 35159,2391, 34743,1975, 2225,2225, 2392,2392, 35161,2393, 34994,2226, 2394,2394, 35147,2379, 34995,2227, 
1, // chain 291
929,929, 930,930, 2313,2313, 
6, // chain 292
2312,2312, 930,930, 2395,2395, 
1366,1366, 35104,2336, 35103,2335, 33699,931, 33698,930, 
1, // chain 293
2312,2312, 1366,1366, 1367,1367, 
3, // chain 294
2396,2396, 2243,2243, 2383,2383, 
2373,2373, 35140,2372, 
3, // chain 295
1364,1364, 1365,1365, 1366,1366, 
1506,1506, 35104,2336, 
1, // chain 296
806,806, 807,807, 808,808, 
1, // chain 297
2322,2322, 2323,2323, 1942,1942, 
1, // chain 298
529,529, 1178,1178, 528,528, 
13, // chain 299
2397,2397, 1201,1201, 1361,1361, 
1362,1362, 1239,1239, 34387,1619, 1238,1238, 35166,2398, 35167,2399, 33570,802, 803,803, 2398,2398, 35168,2400, 33573,805, 33572,804, 
2, // chain 300
2397,2397, 1239,1239, 1200,1200, 
1201,1201, 
2, // chain 301
2346,2346, 2347,2347, 1234,1234, 
34001,1233, 
6, // chain 302
1235,1235, 1236,1236, 2401,2401, 
1234,1234, 35113,2345, 35170,2402, 34005,1237, 34004,1236, 
7, // chain 303
1238,1238, 2398,2398, 1237,1237, 
35168,2400, 2402,2402, 33573,805, 806,806, 2344,2344, 2345,2345, 
1, // chain 304
2345,2345, 2346,2346, 1234,1234, 
2, // chain 305
839,839, 840,840, 865,865, 
33609,841, 
6, // chain 306
2222,2222, 2224,2224, 2403,2403, 
35172,2404, 35108,2340, 34973,2205, 2255,2255, 2339,2339, 
6, // chain 307
855,855, 856,856, 1825,1825, 
1826,1826, 2405,2405, 35064,2296, 34748,1980, 1981,1981, 
4, // chain 308
2338,2338, 1291,1291, 1292,1292, 
2337,2337, 34271,1503, 1505,1505, 
1, // chain 309
524,524, 2349,2349, 2375,2375, 
1, // chain 310
2341,2341, 2343,2343, 2361,2361, 
2, // chain 311
1230,1230, 1231,1231, 2282,2282, 
34000,1232, 
1, // chain 312
1314,1314, 318,318, 1313,1313, 
1, // chain 313
1280,1280, 1278,1278, 1279,1279, 
1, // chain 314
663,663, 664,664, 662,662, 
23, // chain 315
2088,2088, 2089,2089, 2263,2263, 
2087,2087, 35174,2406, 35175,2407, 35032,2264, 2408,2408, 35033,2265, 2266,2266, 2267,2267, 2391,2391, 2409,2409, 35160,2392, 2410,2410, 35179,2411, 35161,2393, 2412,2412, 35162,2394, 
2413,2413, 35147,2379, 2414,2414, 35120,2352, 35148,2380, 2351,2351, 
1, // chain 316
856,856, 857,857, 1824,1824, 
15, // chain 317
854,854, 855,855, 2405,2405, 
2415,2415, 35184,2416, 35185,2417, 35064,2296, 2297,2297, 2418,2418, 35066,2298, 2419,2419, 35188,2420, 35189,2421, 35067,2299, 2086,2086, 34853,2085, 35068,2300, 
6, // chain 318
2422,2422, 854,854, 2415,2415, 
2423,2423, 35192,2424, 35184,2416, 2418,2418, 35185,2417, 
6, // chain 319
2425,2425, 2242,2242, 2396,2396, 
2426,2426, 35141,2373, 2427,2427, 35196,2428, 35142,2374, 
76, // chain 320
2429,2429, 2086,2086, 2087,2087, 
2430,2430, 35174,2406, 2407,2407, 2431,2431, 35176,2408, 2409,2409, 2432,2432, 35178,2410, 2433,2433, 35179,2411, 2434,2434, 35203,2435, 35180,2412, 2436,2436, 35205,2437, 35181,2413, 
2438,2438, 35182,2414, 2352,2352, 2439,2439, 35121,2353, 2354,2354, 2440,2440, 35123,2355, 2441,2441, 35124,2356, 2442,2442, 35125,2357, 2443,2443, 35212,2444, 35126,2358, 2445,2445, 
33954,1186, 2446,2446, 33618,850, 851,851, 852,852, 853,853, 2447,2447, 33622,854, 2422,2422, 2423,2423, 2444,2444, 35211,2443, 35192,2424, 2448,2448, 35217,2449, 35186,2418, 
2450,2450, 35187,2419, 2451,2451, 35220,2452, 35221,2453, 35188,2420, 2454,2454, 35189,2421, 2455,2455, 35224,2456, 34854,2086, 2429,2429, 2430,2430, 2455,2455, 35225,2457, 35199,2431, 
2432,2432, 2458,2458, 35201,2433, 2459,2459, 35202,2434, 2460,2460, 35229,2461, 35230,2462, 35231,2463, 35204,2436, 35203,2435, 
9, // chain 321
2450,2450, 2451,2451, 2449,2449, 
35216,2448, 35232,2464, 35229,2461, 35220,2452, 2465,2465, 35221,2453, 2455,2455, 35222,2454, 
2, // chain 322
2444,2444, 2445,2445, 2447,2447, 
35214,2446, 
2, // chain 323
841,841, 842,842, 1937,1937, 
1938,1938, 
5, // chain 324
2457,2457, 2458,2458, 2455,2455, 
35227,2459, 2460,2460, 2465,2465, 35229,2461, 
11, // chain 325
2442,2442, 2443,2443, 2448,2448, 
2466,2466, 35232,2464, 2467,2467, 35236,2468, 35229,2461, 2462,2462, 2469,2469, 35231,2463, 2437,2437, 35204,2436, 
1, // chain 326
636,636, 634,634, 635,635, 
7, // chain 327
2441,2441, 2442,2442, 2466,2466, 
2467,2467, 2440,2440, 35206,2438, 35205,2437, 35237,2469, 35236,2468, 
1, // chain 328
1201,1201, 1202,1202, 1361,1361, 
1, // chain 329
2438,2438, 2439,2439, 2440,2440, 
2, // chain 330
992,992, 993,993, 2258,2258, 
991,991, 
1, // chain 331
1227,1227, 1228,1228, 1229,1229, 
1, // chain 332
1226,1226, 1227,1227, 2285,2285, 
1, // chain 333
525,525, 526,526, 527,527, 
7, // chain 334
2052,2052, 2053,2053, 2470,2470, 
2471,2471, 35240,2472, 2310,2310, 35241,2473, 35077,2309, 2310,2310, 
14, // chain 335
2474,2474, 2475,2475, 2476,2476, 
2477,2477, 35193,2425, 35010,2242, 35243,2475, 1517,1517, 34826,2058, 35246,2478, 35242,2474, 2479,2479, 35248,2480, 35245,2477, 2426,2426, 35193,2425, 
6, // chain 336
2250,2250, 1767,1767, 1769,1769, 
1770,1770, 1629,1629, 2249,2249, 34398,1630, 1631,1631, 
12, // chain 337
2470,2470, 2053,2053, 2481,2481, 
35250,2482, 34822,2054, 2483,2483, 34824,2056, 2058,2058, 2478,2478, 2479,2479, 2482,2482, 35248,2480, 2427,2427, 35194,2426, 
3, // chain 338
2253,2253, 2310,2310, 2311,2311, 
2252,2252, 35019,2251, 
4, // chain 339
2471,2471, 2310,2310, 2253,2253, 
2254,2254, 2293,2293, 2052,2052, 
7, // chain 340
2222,2222, 2403,2403, 2484,2484, 
2485,2485, 2221,2221, 33225,457, 35254,2486, 456,456, 33223,455, 
1, // chain 341
2243,2243, 2396,2396, 2242,2242, 
2, // chain 342
2384,2384, 2302,2302, 2303,2303, 
2372,2372, 
6, // chain 343
1955,1955, 1956,1956, 1957,1957, 
2487,2487, 33724,956, 34726,1958, 1410,1410, 34177,1409, 
5, // chain 344
960,960, 961,961, 1955,1955, 
2487,2487, 958,958, 33725,957, 33724,956, 
1, // chain 345
960,960, 958,958, 959,959, 
2, // chain 346
2250,2250, 2251,2251, 1767,1767, 
34536,1768, 
2, // chain 347
1465,1465, 287,287, 288,288, 
289,289, 
1, // chain 348
1518,1518, 1519,1519, 2211,2211, 
1, // chain 349
1520,1520, 2208,2208, 1519,1519, 
12, // chain 350
1700,1700, 286,286, 287,287, 
1699,1699, 35256,2488, 34233,1465, 2489,2489, 35258,2490, 34234,1466, 2489,2489, 35259,2491, 35260,2492, 34236,1468, 34235,1467, 
1, // chain 351
955,955, 956,956, 1410,1410, 
17, // chain 352
2493,2493, 1054,1054, 1055,1055, 
1056,1056, 1057,1057, 1156,1156, 1157,1157, 2492,2492, 35262,2494, 33926,1158, 1159,1159, 2495,2495, 35264,2496, 33928,1160, 2497,2497, 35102,2334, 2498,2498, 34509,1741, 34508,1740, 
2, // chain 353
2493,2493, 2492,2492, 1054,1054, 
34236,1468, 
14, // chain 354
2491,2491, 2492,2492, 2494,2494, 
2495,2495, 2489,2489, 35267,2499, 35264,2496, 2497,2497, 2500,2500, 35266,2498, 1698,1698, 34464,1696, 34509,1741, 1695,1695, 34510,1742, 1694,1694, 
4, // chain 355
1698,1698, 1699,1699, 2488,2488, 
2500,2500, 35257,2489, 2499,2499, 
2, // chain 356
2481,2481, 2482,2482, 2501,2501, 
35195,2427, 
1, // chain 357
1698,1698, 1696,1696, 1697,1697, 
5, // chain 358
1970,1970, 2012,2012, 462,462, 
33229,461, 33228,460, 34781,2013, 459,459, 
3, // chain 359
1728,1728, 454,454, 455,455, 
2502,2502, 2340,2340, 
1, // chain 360
2020,2020, 2301,2301, 2019,2019, 
4, // chain 361
2217,2217, 2014,2014, 2015,2015, 
2016,2016, 2214,2214, 34981,2213, 
1, // chain 362
2174,2174, 2023,2023, 2024,2024, 

 0};


// mesh info for object bunny (with tag [])
const tgx::Mesh3D<tgx::RGB565> bunny = 
    {
    1, // version/id
    
    2503, // number of vertices
    0, // number of texture coords
    2503, // number of normal vectors
    4968, // number of triangles
    11752, // size of faces
    
    bunny_vert_array, // array of vertices
    nullptr, // array of texture coords
    bunny_norm_array, // array of normal vectors        
    bunny_face, // array of face vertex indexes   
    
    nullptr, // pointer to texture image 
    
    { 0.75f , 0.75f, 0.75f }, // default color
    
    0.1f, // ambiant light strength 
    0.7f, // diffuse light strength
    0.6f, // specular light strength
    32, // specular exponent
    
    nullptr, // next mesh to draw after this one    
    
    { // mesh bounding box
    -1.0, 1.0, 
    -0.9905058804118608, 0.9905058804118609, 
    -0.7759365864222039, 0.7759365864222039
    },
    
    "Stanford bunny" // model name    
    };
    
                
/** end of bunny.h */
    
    
    