// 3D model [sinbad]
//
// - vertices   : 4951
// - textures   : 5530
// - normals    : 4556
// - triangles  : 7612
//
// - memory size: 210kb
//
// - model bounding box: [-0.76,0.76]x[-1.0,1.0]x[-0.42,0.42]
//
// object [sinbad_1] (tagged [ | o Sinbad | usemtl Sinbad/Body]) with 2936 triangles (360 chains)
// object [sinbad_2] (tagged [usemtl Sinbad/Teeth]) with 488 triangles (49 chains)
// object [sinbad_3] (tagged [usemtl Sinbad/Eyes]) with 528 triangles (20 chains)
// object [sinbad_4] (tagged [usemtl Sinbad/Gold]) with 802 triangles (78 chains)
// object [sinbad_5] (tagged [usemtl Sinbad/Clothes]) with 1786 triangles (150 chains)
// object [sinbad_6] (tagged [usemtl Sinbad/Spikes]) with 224 triangles (28 chains)
// object [sinbad_7] (tagged [usemtl Sinbad/Sheaths]) with 848 triangles (114 chains)

#pragma once

#include <tgx.h>

#include "sinbad_body_texture.h" // texture for object [sinbad_1]

#include "sinbad_body_texture.h" // texture for object [sinbad_2]

#include "sinbad_body_texture.h" // texture for object [sinbad_3]

#include "sinbad_clothes_texture.h" // texture for object [sinbad_4]

#include "sinbad_clothes_texture.h" // texture for object [sinbad_5]

#include "sinbad_clothes_texture.h" // texture for object [sinbad_6]

#include "sinbad_sword_texture.h" // texture for object [sinbad_7]


// vertex array: 58kb.
const tgx::fVec3 sinbad_vert_array[4951] PROGMEM = {
{0.06367625022716474,0.658657523419327,0.16723619653750987},
{0.038490086075194344,0.6668296853465806,0.11860862669114314},
{0.03321786669938873,0.6927350103990976,0.2021575492700661},
{-0.021832003037295416,0.7021424604267346,0.1943104631587029},
{-0.021832003037295416,0.67187535017766,0.09949350303252467},
{-0.07688187277397958,0.6927350103990976,0.2021575492700661},
{-0.08215409214978518,0.6668296853465806,0.11860862669114314},
{-0.09989058369637165,0.6727458433010305,0.22090454953034866},
{-0.10734025630175557,0.658657523419327,0.16723619653750987},
{-0.07714370858473085,0.6564851737691109,0.2396535468434251},
{-0.08241504038151698,0.6503961598006143,0.21325006806621605},
{-0.021832003037295416,0.6472261713324846,0.2524582055681826},
{-0.021832003037295416,0.6472204020688579,0.2394824659874172},
{0.03347970251014002,0.6564851737691109,0.2396535468434251},
{0.03875103430692614,0.6503961598006143,0.21325006806621605},
{0.056226577621780814,0.6727458433010305,0.22090454953034866},
{0.027127521362362777,0.6925719177542653,0.25364955850710097},
{-0.021832003037295416,0.6993674446222806,0.25294615213415045},
{-0.07079152743695362,0.6925719177542653,0.25364955850710097},
{-0.09121227983325055,0.6736758042187074,0.2584742161623258},
{-0.07103405840403086,0.6557897556073358,0.26523268660627725},
{-0.021832003037295416,0.6470173683681482,0.2707844933732241},
{0.027370052329440026,0.6557897556073358,0.26523268660627725},
{0.047548273758659707,0.6736758042187074,0.2584742161623258},
{0.01976194686907609,0.6787820463178672,0.29243609597480696},
{-0.021832003037295416,0.6847146244841779,0.2941120670583701},
{-0.06342595294366692,0.6787820463178672,0.29243609597480696},
{-0.08075548950981452,0.6641405428122631,0.2907441484688929},
{-0.06352092389875298,0.6494007399302496,0.2913437080965624},
{-0.021832003037295416,0.6433232644890062,0.2910561324942457},
{0.019856917824162146,0.6494007399302496,0.2913437080965624},
{0.037091483435223685,0.6641405428122631,0.2907441484688929},
{0.001383513796639212,0.6611618276228347,0.31766442013020335},
{-0.021832003037295416,0.6651881079500231,0.31808402311167006},
{-0.04504751987123005,0.6611618276228347,0.31766442013020335},
{-0.054673092442908154,0.6514410622013158,0.31665169246895863},
{-0.045054176713876265,0.6417202967797967,0.31563874291295896},
{-0.021832003037295416,0.6376940164526085,0.31521913993149225},
{0.0013901706392854317,0.6417202967797967,0.31563874291295896},
{0.01100908636831732,0.6514410622013158,0.31665169246895863},
{-0.021832003037295416,0.6485677470204525,0.32270919738226317},
{0.5084432063703321,-0.12439486526661435,0.14063811606027637},
{0.4954781177378007,-0.09927127543551843,0.12939781535738035},
{0.5123636428994455,-0.07297918782525614,0.07599728933367446},
{0.5471072579333477,-0.1352042463555451,0.11827001529520545},
{0.5891350120854978,-0.12460544338898977,0.07244053830779953},
{0.5501088282825279,-0.06331478367147508,0.037493223888923045},
{0.6141596368559199,-0.10872421388790458,0.04031350622337125},
{0.5997029716811257,-0.05062284748219355,0.0267297750142512},
{0.6432309562709787,-0.08919237187963278,0.03388366191138811},
{0.6566566984146285,-0.17272509614144999,0.043815449244792304},
{0.6746814312477963,-0.1574864738504798,0.034761255666914674},
{0.673262858079887,-0.19011765081798176,0.049928649741570276},
{0.6897234547859481,-0.18020583401251622,0.0421470225828949},
{0.6962103260499338,-0.23010552648857543,0.06228352779819826},
{0.7126245467522263,-0.22273751115298515,0.054087179342663425},
{-0.5219035640957422,-0.12670345829632318,0.13848396177995984},
{-0.5324451182155401,-0.07522631600786486,0.07331058764166039},
{-0.5109548331007506,-0.10066078039053925,0.12545718640557346},
{-0.5254276965926507,-0.16612594613149798,0.18988876637832922},
{-0.5251447807801864,-0.13252264824289314,0.22721124225337677},
{-0.5340853642435686,-0.19213068003419845,0.24486474516164036},
{-0.5730758229910038,-0.19519194007243978,0.18933447328065403},
{-0.5653574358374674,-0.2079244830018633,0.21798974003032415},
{-0.5972390523230051,-0.2072055439960716,0.21109591378589954},
{-0.6035279934656432,-0.20541507521899352,0.24095029979090854},
{-0.6264370736430969,-0.21042102088895034,0.2381999143042457},
{-0.6328305272152807,-0.18839530373064997,0.2561654012378621},
{-0.6551635686090815,-0.24779209171531524,0.259933396070377},
{-0.665725315151573,-0.23239459277985536,0.27864733401218333},
{0.5476903973491565,-0.09349491117663913,0.24924894172844034},
{0.5112202192275799,-0.07573534257554577,0.18560908224107492},
{0.5165572318718087,-0.13230097538277405,0.2277497808234559},
{0.5540842947108501,-0.13494928928219493,0.2688007542646508},
{0.5571522115917376,-0.17882276400538677,0.2802500798266381},
{0.5295258708204181,-0.19211359413807313,0.24144690025231655},
{-0.5259169745271478,-0.07918536222432632,0.18269715737286374},
{-0.5573896389794527,-0.09513449152040292,0.24922031730506158},
{-0.5795977536262595,-0.049855757314594205,0.20879087107226868},
{-0.6223200383611652,-0.08478687341636491,0.23830109831246818},
{-0.6344954035611002,-0.034215283622547304,0.19324137422972007},
{-0.6621918630749598,-0.06358727043046034,0.1929320529414258},
{-0.6887129460722521,-0.07084167565155515,0.15196650898085737},
{-0.687878399899171,-0.0303259123591163,0.12597575444771394},
{-0.7039779738390521,-0.07676293718536716,0.11350637869757099},
{-0.7027928339532703,-0.08126451607749545,0.0837316529095617},
{-0.6875468891353893,-0.09149009206635278,0.05352600750758714},
{-0.681106837664682,-0.05001197122202549,0.05993321855457314},
{-0.6648073365506594,-0.10431294616100996,0.03925950613771988},
{-0.6235528856192449,-0.05961224779164797,0.028467876629179035},
{0.5166601910380703,-0.16457667695296788,0.18929874822511933},
{0.5651783667702841,-0.1906129199108605,0.18365529892440954},
{0.6658196204223944,-0.07507720273258955,0.04721998046882368},
{0.6657878894724474,-0.014601784344481892,0.12074325423303078},
{0.6819504815227129,-0.0644837252401512,0.07665565107138554},
{0.6961630624671457,-0.1435339535587592,0.042251313117685665},
{0.7135418596688753,-0.161387827430674,0.06462518314638331},
{0.6845255701530253,-0.06073636661983952,0.10637534696018609},
{0.6711490886449575,-0.05660357681031176,0.14592364912137443},
{0.6160597216419058,-0.021813141983131154,0.19049032305879257},
{0.6466512420226062,-0.0525176067940624,0.18837966015043134},
{0.6109847667031831,-0.07795473391379527,0.23522630269417955},
{0.5634229573644761,-0.04167516338665542,0.20879375570408204},
{0.6104932698211373,-0.1807272866864701,0.25537390264722665},
{0.5992310015375087,-0.20117755108516522,0.2328977391365321},
{0.6284163748565728,-0.18313151635552957,0.24712274618723792},
{0.6049694217933045,-0.14349112787106855,0.26163510694550557},
{0.6570123957066916,-0.15845659771878884,0.2512198109412309},
{0.6858702523675616,-0.2093288549054607,0.2684108851803372},
{0.6650037134087228,-0.22604152405305863,0.2656582807461256},
{-0.6146260596306651,-0.18463574089882026,0.26320523423099373},
{-0.5929449450266839,-0.18066182773378228,0.2788614624506367},
{-0.6108720441677071,-0.14708870753184028,0.2673977137295826},
{-0.5601247137280294,-0.17866943472976884,0.28469330039823454},
{-0.5600885448829849,-0.1359400493627072,0.2705250984047764},
{0.6221727002439289,-0.2047296423211878,0.22859431226050622},
{0.5912478939414078,-0.20209464210705938,0.2034110327403492},
{0.5599332185545731,-0.2049444364439058,0.21211418881601618},
{0.6486740346080373,-0.18117706735459962,0.08026432546990099},
{0.6762291471630423,-0.19218681940718157,0.08358875268742286},
{0.6987969532074997,-0.2239308611446974,0.09086801012106356},
{-0.6628677544983059,-0.19502618469054897,0.09090883875596038},
{-0.6734399300942764,-0.1886671248053706,0.054694505286753486},
{-0.6062659528460331,-0.13460623999115975,0.07525372001009178},
{-0.6507070343521927,-0.20031260533066647,0.13611390390315092},
{-0.5611392165473132,-0.1409790573511403,0.11887423471272729},
{-0.572629814533707,-0.06827035923207556,0.03673922551186128},
{-0.6341303866893324,-0.1215117867165368,0.044417671609520266},
{-0.6928148925108523,-0.17487015273681664,0.04613092101190222},
{-0.688625075749322,-0.20666190184663039,0.06251918002787443},
{-0.6894975659254865,-0.20738572253702928,0.0963541360405677},
{-0.6893129494894312,-0.20997434674738905,0.10798519340679677},
{-0.683304039527444,-0.2157121013189203,0.14499856988830487},
{-0.6781141431056967,-0.21612060956264326,0.15727578478072693},
{-0.6615561346022459,-0.21197783448914617,0.19603414161456395},
{-0.6275629676293274,-0.19930098714319602,0.17366382190194427},
{0.6487701150368977,-0.2026793347861523,0.19556439041849571},
{0.6187559648083794,-0.1909062647768039,0.16466421443376564},
{0.6546958144658073,-0.20250492550882135,0.18442438614480278},
{0.6395952107123687,-0.1890226002026787,0.12582042811930216},
{-0.6549904907002799,-0.21132568580457156,0.20679115554134445},
{-0.6751667150767058,-0.25112539472303214,0.22874897290465337},
{-0.6707933913528945,-0.19613299572786033,0.20720942715428187},
{-0.6987938466809316,-0.2371924011697404,0.23342607054788697},
{0.6690712661603175,-0.20407638416283885,0.1446195736469801},
{0.6734747675707916,-0.2028608446956392,0.1320909519972858},
{0.6768954971119288,-0.19526028365694095,0.09508356667415932},
{0.6959433866598205,-0.17843222923680857,0.0897303557128247},
{0.7112210624276484,-0.2149998191557748,0.09493511908314863},
{-0.7095839229261883,-0.19448365201488207,0.10310927806319607},
{-0.7223868064929068,-0.2315718070287827,0.11073935110429253},
{-0.7097243823060234,-0.23997385192208567,0.1062967962169607},
{-0.7084562537819187,-0.24726753251479322,0.07788761075044584},
{-0.7060582371659957,-0.19803485567188514,0.05534976049789633},
{-0.7257203313953785,-0.24119360738962792,0.07040687287937956},
{0.7035841106491508,-0.14041633225277989,0.09043753429660806},
{0.7206984093030707,-0.16137473564013644,0.11993267269347616},
{0.6983773502260331,-0.13746823853952428,0.14185942479110272},
{0.705418514587694,-0.1543440003319546,0.18224582344145007},
{0.6755696759515568,-0.1335402575887452,0.2014472641597145},
{0.6743135297442152,-0.15162800853229716,0.23832106884040688},
{-0.729575308971804,-0.17957920322475213,0.07843768784777844},
{-0.7193608277206904,-0.15695547970206639,0.10270809234638392},
{-0.7334815442366054,-0.1774905078971234,0.1340296464706197},
{-0.7268511070662164,-0.18069156163093536,0.1099953379912001},
{-0.7258561309853614,-0.17984858345716914,0.09754792982178967},
{-0.7453802066772125,-0.22474943089542745,0.09079190022014179},
{-0.7432917332443387,-0.2309041257113669,0.07523219621886901},
{-0.722374158491879,-0.18803539043824438,0.06102028095870073},
{-0.7145956378597719,-0.16180787420165044,0.05432993220449555},
{0.7110118156738022,-0.16266150332365065,0.08388897629076734},
{0.7128067223459779,-0.16395892195539877,0.09620701981808624},
{0.7367172135521777,-0.22283558863463945,0.11273906663521678},
{0.7388312048818622,-0.21682889762020097,0.1322280829557979},
{0.7090660205683124,-0.16459509421762242,0.13832597271448957},
{0.7065128995187324,-0.16237148687903033,0.15441866791696962},
{0.7410949751710864,-0.21628103947041716,0.17773292791682319},
{0.7378721757512967,-0.20477335558789797,0.20029607417142833},
{0.6868425951834193,-0.15915889461796492,0.19981545013237131},
{0.679606607226979,-0.1589314524942191,0.21321744953724958},
{0.7078662356287088,-0.20836694114308202,0.23529353680490633},
{0.7022718250688261,-0.20246320929490505,0.2549130272413534},
{-0.7113424388585645,-0.1514280813581557,0.15355283458345143},
{-0.7206289562447952,-0.17923615393371697,0.1517992003356824},
{-0.7172743513406105,-0.17615758610459548,0.16760143530403243},
{-0.7150254479999627,-0.166845994611064,0.1949550674216118},
{-0.747254551671633,-0.23080382928216384,0.195181843861093},
{-0.7339182331141975,-0.24772774223640182,0.1837589237749357},
{-0.6983416251704985,-0.2005862015634261,0.15579619055522728},
{-0.7357604033691612,-0.234687653176723,0.16487568013516052},
{-0.7476217874909494,-0.23325887285008948,0.14968520900599805},
{-0.6853632228526745,-0.1435834360890961,0.21143075297100436},
{-0.6952082493369229,-0.16983447316970668,0.21154680392780345},
{-0.7433931391473161,-0.2181382985687123,0.21701251552985917},
{-0.6872280263726355,-0.16860761707000851,0.2244635195037723},
{-0.680911348385638,-0.15990734562615486,0.24887571475074227},
{-0.7112388140080383,-0.21849643670307892,0.25024014559846236},
{-0.725927359201676,-0.22338588762672693,0.2339646091179661},
{-0.6625207111016831,-0.16518378100230308,0.26097008836514823},
{-0.7048606711739408,-0.2114206567596576,0.26922257619366624},
{0.7057748775640216,-0.16952049209156003,0.0472974217382747},
{0.7298599999423073,-0.21165519951555942,0.05833424495095128},
{0.7325462578448116,-0.20603793379592478,0.07400511822441593},
{0.7277415707175254,-0.20677440248735146,0.09016327237958383},
{0.7192432235006072,-0.2345589542188961,0.10326992986572484},
{0.6576463490213664,-0.03581891701602151,0.055332452707016165},
{-0.706221551705583,-0.25626691808821694,0.12181434021480743},
{-0.6990350462794795,-0.25035808266067794,0.155425182525078},
{-0.7062035782304382,-0.25995547459848706,0.18199685752648148},
{-0.6898241950046609,-0.2548155044965863,0.21490318399002717},
{-0.728761842800436,-0.25115335346214623,0.12034695020082585},
{-0.746303732646998,-0.24000447339825828,0.13036838301519915},
{0.6863879328306824,-0.24437535627976587,0.19967854106861407},
{0.6637034101451613,-0.1866268025343044,0.19573857780107182},
{0.6724174390638171,-0.24211602388563902,0.21450687995782225},
{0.6954769638850754,-0.22704226939754027,0.21841533417017242},
{0.7010447470743731,-0.22979753656881038,0.21612848682644126},
{-0.704316363340235,-0.2403515167948812,0.23159743587297058},
{0.6917054187364825,-0.23693788788589998,0.1400232456945206},
{0.6882800294054928,-0.1873475166981351,0.14265824590864903},
{0.7009963740178106,-0.2471931977719104,0.1656756107264812},
{0.7280468979002321,-0.23346301602457353,0.16636259688757105},
{0.7079314726866417,-0.2294520464354716,0.1506522263477388},
{-0.7150199006310909,-0.24331492124622311,0.16670276154679284},
{0.6541930009512628,-0.24123887391962223,0.24692281901309646},
{0.6971518254948641,-0.24102652063920782,0.10581972249398167},
{-0.6873292103808579,-0.2167572256143767,0.28197042986117593},
{0.5896171893878389,-0.17866677199271033,0.27243006487536947},
{0.7280127261079815,-0.2195690759481397,0.1480059095011118},
{0.6982395535832563,-0.36179851024299475,0.25197780342388043},
{0.7143173818371599,-0.3497054679971181,0.26189250486115934},
{0.701004362228986,-0.3472779393787968,0.2729231150206995},
{0.6873600537517853,-0.34640123320228977,0.2685557824552699},
{0.6863013938762816,-0.30997876245301104,0.27261556889044414},
{0.7053816800583849,-0.30940849293298495,0.2781289878647977},
{0.7214535171539068,-0.30967654179687265,0.26618195236762815},
{0.7182557918414181,-0.34938216733926664,0.2448736209518353},
{0.7089976769838112,-0.3457430933593335,0.23376423815431494},
{0.7245025729806301,-0.3100209224564371,0.24807245573809855},
{0.7100902867568106,-0.3108261785218748,0.23079284549179752},
{0.7247033877337911,-0.29004307199086865,0.24715713987424337},
{0.7100288219097105,-0.2966735091612578,0.23060578821343883},
{0.7182056436268165,-0.23272743491216633,0.24283707089160197},
{0.7005490341919847,-0.24110085538209058,0.22267771051654658},
{-0.691778422110836,-0.37025980103584916,0.27263287668132424},
{-0.694153583567007,-0.3549929981110099,0.2930897979226657},
{-0.7079243720544859,-0.3586449419867258,0.2829984682605071},
{-0.712861086560922,-0.3593010847768882,0.26625162732065855},
{-0.7171059332216612,-0.3189211210744322,0.28605639987742537},
{-0.7004072434436202,-0.3172296173580279,0.2969831632916844},
{-0.6816802137112763,-0.31698797396997014,0.29034828822619774},
{-0.6808609782762816,-0.35355800473124,0.2878686143404811},
{0.6937208887950027,-0.3453845114354572,0.23284315302683306},
{0.6938631233328769,-0.30904769206155985,0.22943595906574318},
{0.6809444107041143,-0.345263356899296,0.25363003176867205},
{0.6777409161279987,-0.3090505766933732,0.2574625979748553},
{0.6772276735599752,-0.30108899288849506,0.25808235002521834},
{0.6850465790374693,-0.29549413853910267,0.27331520305256174},
{0.6586919171063326,-0.24982553524898038,0.24933925289367406},
{0.6725745405502679,-0.24123066381369188,0.2691857416643571},
{-0.7044934353546244,-0.3556551320595539,0.25445947436239097},
{-0.6893429052813392,-0.35449240354401435,0.25259733357948855},
{-0.707779474779553,-0.32102024545554,0.25011965674656583},
{-0.6917895168485797,-0.31840787850640867,0.24770655128731137},
{-0.7085494495789658,-0.30690840472981984,0.24934480026254588},
{-0.6918793842243036,-0.3103286904814473,0.24684249311183204},
{-0.7027852895316046,-0.2513057951587446,0.23856581875503285},
{-0.6784172513408545,-0.2588699654576435,0.23222850455583216},
{-0.6590085609215377,-0.2564981324227956,0.2629715790541115},
{-0.6721844495711995,-0.24780718055864673,0.28325320343910243},
{-0.6754041424644208,-0.3527345532959027,0.27254633772692344},
{-0.6740865314099792,-0.3162650408585907,0.27467763684748797},
{-0.7211814741844313,-0.3202427262344616,0.2681954253733546},
{-0.718981387689856,-0.29786020231032384,0.2859754082918963},
{-0.7014437138436365,-0.2978082789376833,0.2965733236794322},
{-0.6812284359903529,-0.3024390005771483,0.2903713652807047},
{0.7217865811809726,-0.21172021467873745,0.2179866335037559},
{0.69345261803636,-0.3009480897191501,0.22893003902463058},
{0.6762974907475434,-0.24979624514133703,0.2174409943015208},
{-0.6740004362450881,-0.30826751010342296,0.2749354785526515},
{0.7221511542632306,-0.2885570428174776,0.2669332880076314},
{0.7133323910202742,-0.22925012220853627,0.2616073701011463},
{-0.7225929467201847,-0.3003678349351546,0.26646952796994483},
{-0.7139408264381387,-0.23845298527217948,0.2776776539333841},
{-0.6970630675929145,-0.2399585411839994,0.29022802126905606},
{-0.7196910071159429,-0.24303045217047467,0.25939796402686616},
{0.7053140021581483,-0.289959639563036,0.2785279546340611},
{0.697357965722142,-0.2322483641363934,0.2750411004559715},
{0.582597326922646,-0.2591475557959909,0.24567111070085237},
{0.5835743295283561,-0.2323601990928499,0.24436148785758616},
{0.5767390834992181,-0.2528808041288401,0.27340307337549186},
{0.5708375705985899,-0.28707855806575233,0.2534649420710458},
{0.5652549204607156,-0.28663099634517153,0.27784096847297135},
{0.547633148502399,-0.29536610526554036,0.26732116003915113},
{0.5405325163464317,-0.286068493141566,0.24111228296196657},
{0.5312406734860842,-0.2834268360847913,0.26455790465670553},
{0.5439716631522236,-0.2579222529595768,0.22839726971817814},
{0.5297493188385762,-0.25040046455885884,0.2547900975471532},
{0.5340085886583821,-0.2228548934783135,0.24941846932116404},
{0.5488016462815654,-0.23257144289948994,0.22867596953029984},
{0.578957587258448,-0.22356362532538093,0.2732455280995313},
{-0.5828458490481048,-0.26174549958605536,0.2550730133596175},
{-0.5757525394190485,-0.2539305882141489,0.28211488334659895},
{-0.5854482307332668,-0.2351389871081367,0.25271937569466923},
{-0.5516962633588963,-0.23412448428885288,0.23497156751558423},
{-0.5796716445796326,-0.22481777447992865,0.28088137040425454},
{-0.5454297335865005,-0.2591557659019212,0.23544708797527916},
{-0.5363063088451021,-0.2226860315698544,0.25435718088039405},
{-0.5301516140291628,-0.24968574155340975,0.26059353296612714},
{-0.5291537533164945,-0.28227431472797593,0.2717898985075581},
{-0.539628960904585,-0.2864718978059269,0.24908163308326534},
{-0.5446377912063552,-0.2949678041805416,0.27603541085256184},
{-0.569052205400874,-0.2886058596635499,0.2632846725532387},
{-0.562092254519497,-0.28676058288201794,0.2872368799733549},
{0.5506460354840779,-0.24593771724883348,0.2744087004045807},
{0.5474609581726169,-0.28348075651022575,0.27654177468318425},
{0.5534044091819161,-0.21778437643468831,0.27455825746936574},
{-0.5500915204916478,-0.2455147858460437,0.2812448340127381},
{-0.5446169330993971,-0.2826910330776293,0.284729469243279},
{-0.5544635128469296,-0.21757912378642988,0.28039852741764876},
{0.7066220717381305,-0.25609716860073833,0.1687907911901569},
{0.6898605857444602,-0.25421061939479983,0.20201908694302476},
{0.7037702803484901,-0.3013206510125835,0.21339274639360004},
{0.7157142093190916,-0.30580514400858644,0.18199685752648148},
{0.7341998175581325,-0.247500300112656,0.17123829033641685},
{-0.7111123339977602,-0.26900922438685493,0.18581322541555895},
{-0.6925783527021567,-0.2647137857220045,0.21785504991411564},
{-0.7106325975377227,-0.2554649904441024,0.2361456126636224},
{-0.7389521375232685,-0.26185223096314975,0.1895752290896923},
{-0.7165223500163426,-0.31850440272477887,0.2015899424870985},
{-0.7030471253423559,-0.3119664956671721,0.2319895239048329},
{-0.7152371355961126,-0.30910560659258196,0.24570040080849573},
{0.7503832677153561,-0.23323468632180822,0.20910618351894458},
{0.7509031671260258,-0.24105958295768404,0.1861820144981595},
{0.7562639225090261,-0.3013062278535167,0.1979644040872126},
{0.7547812217569582,-0.2978981463134073,0.21764003389664274},
{0.7335527724529199,-0.23570415304880066,0.2249266138571943},
{0.7084531472553505,-0.24469466283202948,0.2196202226891381},
{0.7383778738976545,-0.2971164110919863,0.23087738739340455},
{0.7165938001274119,-0.2983268469798238,0.2264829836678804},
{0.7342526285097924,-0.3224576796776136,0.23114854278386054},
{0.7138190062177129,-0.31857940315192623,0.22753143638465986},
{0.7163954262165546,-0.3620663372121276,0.22715865319647163},
{0.7023264111785252,-0.35689885216062256,0.22434369633614035},
{0.7065843496298019,-0.37518830543635495,0.20539920974401998},
{0.7276798839756705,-0.3680111195899563,0.21391109254098564},
{0.7312854518476177,-0.3672120765776551,0.19582334159743367},
{0.7231707606618766,-0.36273512800331775,0.18605087469802897},
{0.7511794260958439,-0.3273415832323897,0.19863607951021617},
{0.73284847850095,-0.3237082785160833,0.18213376659023872},
{0.7348799249818213,-0.3053282921803623,0.18045180434829403},
{-0.7536983753531732,-0.2468266276368586,0.22773513576963422},
{-0.7551005283092218,-0.25568533193569226,0.20522790699325727},
{-0.7358587027455703,-0.2476505228617057,0.24259187718746625},
{-0.7538357282064403,-0.31118831076182907,0.2391846832263764},
{-0.7562639225090261,-0.31554943027412213,0.2197933005979398},
{-0.7357408766307323,-0.3191594360411668,0.20119452603391305},
{0.7022964553866171,-0.3139446874068736,0.21433801804936314},
{0.7159445360746507,-0.3177861294032518,0.18364575744994996},
{-0.7367609268188879,-0.3089081202607441,0.2513569418997431},
{-0.7463576530724324,-0.33858587804087353,0.24097071410835694},
{-0.7496483522872135,-0.3412071207801997,0.22122962534623902},
{-0.732552914687458,-0.3373051015157409,0.20350755695871936},
{-0.7311651848904761,-0.33394472734792946,0.2524235899864223},
{-0.7229803749621947,-0.379788849389157,0.23671521649938396},
{-0.7276752241858182,-0.38000009319579714,0.21886245210124347},
{-0.7204174905434002,-0.37552181325293055,0.20843805841201907},
{0.7489547092834774,-0.3257332900490632,0.2186327910299489},
{-0.7159614000760212,-0.330394189375191,0.2037434310831504},
{-0.700791343264307,-0.3244347619435407,0.23336416191127715},
{-0.7112365950604895,-0.32910631221790243,0.2474140940003874},
{0.7042400315445584,-0.35576408238419704,0.18759570598146158},
{0.6934459611937139,-0.35287146235965994,0.21137350412424688},
{-0.7018650919831423,-0.36745105722865434,0.20854012999926108},
{-0.6898878787993097,-0.3629050993855512,0.2314780564948484},
{-0.6977480567012104,-0.36683441170485964,0.24511925844548083},
{-0.7113056043292554,-0.37264206312417614,0.2489955379183742},
{-0.7020368385234147,-0.3861598915910986,0.22724053236102007},
{0.699319515355228,-0.24804482984111673,0.1076567891695833},
{0.6930216984223948,-0.24382061939258087,0.14128050137563652},
{0.6925404086990732,-0.2946990896323892,0.14689887656904554},
{0.6977220950148902,-0.2986530322694886,0.11667547958668109},
{0.7208761470017248,-0.24994757736416104,0.10604738651248237},
{-0.7078680107867479,-0.2633054197128194,0.12406812524006237},
{-0.6998746960319226,-0.25724014848309423,0.15704368286712875},
{-0.7162472005202988,-0.25965791373220104,0.16913206532315309},
{-0.7293352188470305,-0.2664694170225674,0.12385222164357003},
{-0.7028167985867967,-0.31329364819607336,0.1350561316066667},
{-0.696118461621416,-0.3077118856372185,0.16471946622772926},
{-0.7088259304435388,-0.3055737077792529,0.1739398589770075},
{0.7425608119217838,-0.2465965227760543,0.13644563656168754},
{0.7417422421710538,-0.2493025293117424,0.11792053105627893},
{0.733961280696643,-0.29397793167904884,0.12288609188084873},
{0.7355083309276244,-0.29085365353042325,0.14075749543839858},
{0.7335083935019452,-0.24467269525129695,0.15125666766001553},
{0.7102074471873842,-0.24578283470993145,0.15227294563733834},
{0.7249885224938041,-0.2897663692315408,0.15410113652274499},
{0.7056470661852142,-0.29221076185123246,0.15544848147433976},
{0.7201427848368663,-0.3125560700308722,0.15581860192546956},
{0.7028159110077772,-0.30767926710825205,0.15641838344789388},
{0.7044162159799283,-0.3450707522520654,0.1559144604595751},
{0.6925408524885829,-0.3395300402228622,0.1545267306625933},
{0.6921059387690299,-0.35505046885252234,0.13882257317589752},
{0.7109292708249891,-0.349168482690323,0.14352452303167704},
{0.7107424354413853,-0.34831796009489113,0.12744292256694065},
{0.7021852861144253,-0.34425373576461943,0.12104480920490449},
{0.7275616140713227,-0.31612835368958836,0.12495570425955828},
{0.7109945078829221,-0.31266013867090814,0.11556778097035021},
{0.714336464786079,-0.2971299466720336,0.11317619930231851},
{-0.7493672116327882,-0.26296924915918535,0.15534774125562698},
{-0.7494754962731666,-0.26645099975791287,0.13693491449618464},
{-0.7395929695753445,-0.2598866872244761,0.16948887208899047},
{-0.7395219632537847,-0.3065305179622695,0.1610477737188296},
{-0.7388418558300961,-0.3103601995366394,0.1432598025891124},
{-0.7196674862719262,-0.3128511900548546,0.13251343961056583},
{0.6909083727769751,-0.30285616271631133,0.1473231393403646},
{0.6960467896155916,-0.30579560253412685,0.11783132936481963},
{-0.7283222692910307,-0.3042669695678001,0.17367092253410024},
{-0.7321341992850108,-0.33168406358527347,0.16349016928572743},
{-0.7310591191976463,-0.33200736424312477,0.14584975816800141},
{-0.7152970471799285,-0.3280498712899475,0.13533682847158227},
{-0.7220719378357406,-0.3266537094922804,0.17603077325218494},
{-0.7114848952911936,-0.36321242362105166,0.1647225727542975},
{-0.7122863791457984,-0.3630726299254811,0.14863786576299287},
{-0.7043669553443462,-0.3588304460018005,0.14156896455697268},
{0.7296871439282605,-0.316472290559643,0.1425000349484239},
{-0.7006655289382935,-0.32027356960538905,0.1364021451897322},
{-0.6939944850277624,-0.31573870650002966,0.16538049070249883},
{-0.7050515006631325,-0.3208027885957635,0.17537418667251284},
{0.6874798769194173,-0.33814652642622306,0.12329393444030709},
{0.6827628382203064,-0.33600457635742453,0.1461934731433012},
{-0.6899340329083234,-0.35182389722189994,0.14266579033031473},
{-0.6840212033751968,-0.3484025019964981,0.16512819636620713},
{-0.6930756188478292,-0.3520879519801999,0.17417906152276164},
{-0.7045085241979558,-0.35821047205668266,0.1765138381335456},
{-0.6926586786034211,-0.3682469937143873,0.15913193440524773},
{0.7035694655953292,-0.3115076173140927,0.09507957256857158},
{0.7201228143089276,-0.30526216754340985,0.09295204565883992},
{0.7169732401582465,-0.30009557007092424,0.10528584371375488},
{0.7064685205677576,-0.29665997358121055,0.10805043046472972},
{0.7125792802222319,-0.2662015900534345,0.10332007808032635},
{0.7270110931844803,-0.26941551368302913,0.10023485340855862},
{0.7321912262370133,-0.2734562171692842,0.08716281150417796},
{0.716218797991675,-0.30586416801338295,0.07973865679560455},
{0.7072757736859892,-0.30333345833404524,0.07588434490344362},
{0.728457403196749,-0.2750523061410927,0.07297397329851657},
{0.7139934154950439,-0.2735141317003063,0.06710774166391333},
{0.731744552095452,-0.26280016535597134,0.07036471287595351},
{0.7151368391669095,-0.26441866569802214,0.06513576297734833},
{0.7326676342757278,-0.22442036097394938,0.06092863842493778},
{0.7152027419091069,-0.23076610717383525,0.056133714666866084},
{-0.7091594382601144,-0.32740460134277394,0.11440527434956546},
{-0.7225836271404801,-0.31630808844103625,0.12492707983617955},
{-0.7261428190086585,-0.3221871899714222,0.11303152392214068},
{-0.7229879193838603,-0.3231619736295836,0.0996415068340256},
{-0.7403514058475037,-0.29138908557393417,0.10667756761632445},
{-0.734660249174496,-0.28648743043876806,0.11923259474184876},
{-0.7202836880062112,-0.2823444334705161,0.12129932248874493},
{-0.7121523547138545,-0.3121755205262634,0.12690394020735177},
{0.6949832480554807,-0.29832884403261767,0.08311611685954129},
{0.697940883243196,-0.2688791940604987,0.07251598252445669},
{0.6958515222313025,-0.29402785799889547,0.10172642995082147},
{0.7011093184480414,-0.264144181886243,0.09792381953654618},
{0.7017705648175658,-0.2571540533182031,0.09613845433883018},
{0.7125823867488003,-0.25710923057771856,0.10243449611362432},
{0.7006408986205025,-0.2296828169805405,0.0918745247291719},
{0.714542605013357,-0.2250518734463207,0.0973575441221078},
{-0.7144467464792514,-0.32031462013504075,0.0951494694163569},
{-0.7020639096835093,-0.31431858006883623,0.10140756718806757},
{-0.7233820044685165,-0.2913351651484998,0.0855731574802608},
{-0.7073367947435795,-0.28558099036510787,0.08979936498159051},
{-0.7251635974553997,-0.28241410842354653,0.08330028950608669},
{-0.7084527034658408,-0.2794262955491685,0.08835194549554758},
{-0.7277049580829713,-0.24925326867616038,0.072936251190188},
{-0.7097909507324857,-0.25236822724508123,0.07946173214152182},
{-0.7111700266340274,-0.24576841155086462,0.10765035422169195},
{-0.724972989860963,-0.2416742314286849,0.11377243050866488},
{-0.7020929778963978,-0.3092447346038879,0.11984280531775217},
{-0.709286583954657,-0.2798980437980305,0.1151355299878557},
{-0.7373655900259195,-0.2934085497380422,0.09236624350597264},
{-0.7440577139381637,-0.27760365203263365,0.10318649743789222},
{-0.738644813287768,-0.2757592628301212,0.1171201566754485},
{-0.7208652741587359,-0.2733146483156746,0.12004073543909978},
{0.698624097193453,-0.26261554891991623,0.07128246958211228},
{0.6979184718729536,-0.23518114711156274,0.06354744032196041},
{-0.7104548598390685,-0.2730419396619345,0.1131065243492881},
{0.7349089931947097,-0.2593468172858677,0.08408091525373333},
{0.7361988674047921,-0.22031197958745774,0.07686290077243783},
{-0.7415039272043191,-0.28148614455866355,0.08945764705908459},
{-0.7480263016290847,-0.23906186447955366,0.09445360746507211},
{-0.7425086666543885,-0.23616258761237033,0.10918764108345884},
{-0.7451986967677257,-0.24367638780191278,0.07851779185428794},
{-0.7396065051553917,-0.22449580519060652,0.1066447271926031},
{0.7302594105010806,-0.25839644205074247,0.09837515346795984},
{0.7314347870176479,-0.21834843290157796,0.0920085491611158},
{0.2746826294794726,0.4171719025322851,-0.12586014728042458},
{0.3151142946598143,0.4686652431378492,-0.1009946210492471},
{0.2893727279363943,0.39100407598475223,-0.08736384815209375},
{0.23289674061013513,0.35271990824208094,-0.12589986644154705},
{0.2662466346886739,0.3307119426641704,-0.08758197069613488},
{0.2606606561294765,0.3205591481549118,-0.03895173811270967},
{0.2715674490157969,0.32067697426974984,-0.03726422850189308},
{0.2970245466634684,0.38444664218871655,-0.07690794540767724},
{0.32137172674726033,0.43549907791634607,-0.07925270728243052},
{0.36779965388856134,0.47465196362434897,-0.06637327002528047},
{0.34924148606467653,0.5085346270093402,-0.07852555817070851},
{0.25197747058174813,0.554307964623763,-0.0934040452745182},
{0.24776080455487798,0.5045358616317562,-0.1194298591789317},
{0.21298967457137144,0.4443719834794917,-0.14101755609111088},
{0.14884056662157022,0.3786369937166062,-0.12502116321224607},
{0.13430912291438343,0.2784375325214499,-0.1104684176085914},
{0.1971157675971971,0.2733217489478305,-0.0965680425842662},
{0.2403399782676277,0.2716511033383843,-0.07372974683361731},
{0.24582255387105384,0.27467464126829716,-0.028316988195864715},
{0.2415615088932089,0.3096243965294772,0.02489182075963007},
{0.2536845069309936,0.30382917121643366,0.026636135427694378},
{-0.31834663555406345,0.4171719025322851,-0.12586014728042458},
{-0.3330367340109851,0.3910038540899973,-0.08736384815209375},
{-0.3587783007344051,0.4686650212430943,-0.1009946210492471},
{-0.29142481062946884,0.5045358616317562,-0.1194298591789317},
{-0.295641476656339,0.554307964623763,-0.0934040452745182},
{-0.3929054921392674,0.5085346270093402,-0.07852578006546337},
{-0.41146365996315215,0.47465196362434897,-0.06637327002528047},
{-0.365035954716606,0.43549885602159116,-0.07925270728243052},
{-0.3406887746328141,0.38444642029396164,-0.07690816730243212},
{-0.31523145509038775,0.32067697426974984,-0.03726445039664796},
{-0.3043246622040673,0.3205591481549118,-0.03895173811270967},
{-0.30991064076326474,0.3307117207694156,-0.08758197069613488},
{-0.27656074668472597,0.35271990824208094,-0.12589986644154705},
{-0.2566536806459623,0.4443719834794917,-0.14101755609111088},
{-0.21156777298213905,0.4881631352486252,-0.1354839446940637},
{-0.21547489582595997,0.5620900355719481,-0.10113197390251408},
{-0.3218150724674985,0.6136854477647542,-0.03887895663311098},
{-0.4066931446281166,0.5900882719524363,-0.03904804043632496},
{-0.45400865078891345,0.5679342996258189,-0.018749773944718467},
{-0.43779147262894913,0.5003145358150338,-0.04446116298147556},
{0.5146078864502409,0.39440061899760814,0.032810800771572446},
{0.4451628163858625,0.4831017158899499,0.014524010232898522},
{0.5020011578468309,0.380952687378471,0.09249227972674105},
{0.520363392602162,0.3141508276341514,0.09140499542785858},
{0.4982216244870625,0.30325046969572234,0.14090172702906664},
{0.47936722716542096,0.36744262522796906,0.13973966419779166},
{0.44045554105596607,0.4325321231489262,0.13997686969075193},
{0.45696295755530564,0.4578338944681859,0.09073842358421717},
{0.4494081068361114,0.5485289376278253,0.025737683565209665},
{0.46187126953311786,0.5356410683699899,0.09894253835617259},
{0.3991194328547581,0.6392213180504059,0.09903817499552328},
{0.3931830824776147,0.6311791864495085,0.017597696377412812},
{0.30689730999207615,0.67479814788886,0.09766176183104001},
{0.30132464511817114,0.661585868499399,0.01602668151290507},
{0.2255919652796839,0.6656445454607988,0.028108629021038074},
{0.2318755809482051,0.6659778313826196,0.09347039180622553},
{0.168515086957226,0.652245208792979,0.07968074226458242},
{0.16125313731446547,0.661746076512418,0.03575978206384756},
{0.13209749789255457,0.6622444521318648,0.08214421783319328},
{0.11918832673825137,0.6799986952588412,0.04010181862722148},
{-0.5588920883647044,0.3942601596177729,0.03299408583909836},
{-0.5462906852354115,0.38073767136099806,0.09271839048195762},
{-0.4888268224604534,0.483101493995195,0.014524232127653402},
{-0.5374883422043158,0.3810154835941003,-0.03392426865153004},
{-0.4718174800255889,0.46031623109096104,-0.04078037278762607},
{-0.43836373920176913,0.42865229335995475,-0.06734073115653098},
{-0.3968716389878848,0.3877064980325701,-0.08097216973794895},
{-0.3550735459070292,0.35788961224113475,-0.07388817968859733},
{-0.323518558500666,0.3106937073532149,-0.03861845219088896},
{-0.29734851300558446,0.30382917121643366,0.026636135427694378},
{-0.32682989392765033,0.26666401872259177,-0.04453882614568144},
{-0.3117188611207327,0.25995014912437,0.0325613910670941},
{-0.3694379028637959,0.21669598266203138,-0.023036780608883627},
{-0.34559242682077407,0.2087838813874901,0.03507634621883572},
{-0.41110374667074656,0.16000653258158345,-0.013942424080373828},
{-0.38734569716114503,0.15647418997874465,0.03597901408166304},
{-0.4175857362501251,0.09888362529875351,0.040225635900441155},
{-0.4408198922434691,0.09410955964763996,-0.006214495452377944},
{-0.47747246785355213,0.08310113896358724,-0.03798272371817502},
{-0.43403878853452055,0.07333244427501542,0.0309994738875362},
{-0.5006267417351415,0.457833672573431,0.09073864547897204},
{-0.4841191033410472,0.4325319012541713,0.13997709158550684},
{-0.523442848010303,0.3672806420569111,0.13990009410556556},
{-0.5420786789983937,0.3026014275377159,0.14129980621931057},
{-0.5647470033668092,0.3134609568412482,0.09191424389029436},
{-0.579533626042101,0.31588094103790376,0.042429716500604335},
{-0.5614585230995769,0.29765339639878124,-0.018144001263912517},
{-0.48631785846709336,0.35103062347322533,-0.08177942285618046},
{0.42815369584575297,0.4603164529857159,-0.040780594682380954},
{0.49290990784488936,0.38101015811998334,-0.03407471329533458},
{0.3946995112324234,0.42865229335995475,-0.06734095305128586},
{0.4417940102173658,0.3507767758736495,-0.08178075422470969},
{0.5165135186050985,0.2979533981073708,-0.01852787918984449},
{0.5348941706250842,0.31648205392885737,0.04192756867032453},
{0.268035328307713,0.25987093269687994,0.03260288538625554},
{0.2829806057327397,0.266322078905331,-0.04437750865888806},
{0.32534186770146545,0.2154442743497873,-0.02240482434700256},
{0.35908096518005317,0.23027372271276983,-0.07201782879976461},
{0.3260348450209369,0.28742915177845313,-0.08510296249468283},
{0.2798545524260752,0.3106937073532149,-0.03861823029613408},
{0.31140953983243835,0.3578898341358896,-0.07388817968859733},
{0.35320763291329393,0.38770671992732497,-0.08097216973794895},
{0.3941274665543583,0.5003147577097887,-0.04446116298147556},
{0.46702743795212437,0.2689184694321114,-0.07191620100203233},
{0.3855836309126908,0.31615742190247675,-0.09298333281927715},
{0.41225715560658144,0.24741176410546117,-0.08259399850132282},
{0.5030791225660086,0.21783252759649588,-0.03797318224371544},
{0.5268522609189416,0.23568196357331322,0.0022958340813035777},
{-0.4299916501003741,0.316621847624428,-0.09311979809352465},
{-0.5121077982470758,0.26922224335153383,-0.07184963257557013},
{-0.5718982275268876,0.23472115928470894,0.0030684716177747508},
{-0.5482358146566367,0.2176250560006887,-0.037605946424398996},
{-0.4571955032584135,0.24826295238515778,-0.08285938462815208},
{-0.37024981577187976,0.2880289333008775,-0.08534815619881858},
{0.4562118438100572,0.19096528878160027,-0.052795529974541996},
{0.5073226378582185,0.12939659493622852,-0.057355245292447295},
{0.5440380096839309,0.15534297051839713,-0.027982814695024512},
{0.5668893972251173,0.184109628435014,0.012671189029700847},
{0.5420629244707976,0.25677217244506495,0.05544051545263979},
{0.525650922716054,0.2532256285779142,0.09827973872336403},
{-0.4036966778582985,0.23152520913025906,-0.07256258042298021},
{0.3018858169532474,0.20745140338447188,0.03581880606864404},
{0.3674297553321864,0.157616282282081,-0.012599517023876537},
{0.40839263655569635,0.1701262647723659,-0.044115894742891654},
{0.4493355472512676,0.10609254209509916,-0.046452668406469465},
{0.5134185305641163,0.11101350207393929,-0.05544761608479575},
{0.5754884846607484,0.14756422799153512,-0.01047997832532034},
{0.5890258398660998,0.1667166299689724,0.076827397611658},
{0.572418570727067,0.20908432688558948,0.05682624819682775},
{0.5571874928577626,0.21543096066449485,0.09682810323697849},
{0.5055108671846725,0.2373011295996286,0.12376568268916915},
{0.43031250991592185,0.3812196267685844,0.18584007468089872},
{0.45869528990660663,0.32424326677008436,0.19242591100555825},
{0.40618433995519054,0.4219408646040365,0.17853796208750597},
{0.3992847444471392,0.46672543919074094,0.20863776369140563},
{0.43626550239968076,0.5083142855177504,0.1663166646733121},
{-0.4741112061067212,0.3813150415131802,0.18580945320472608},
{-0.502184221019602,0.3241531774996056,0.19244765669153588},
{-0.4680332868759682,0.2969226969709812,0.21838249374645108},
{-0.48716727158875095,0.245806355553948,0.19748888362751768},
{-0.5174133018361126,0.27693375176766905,0.17740873967995233},
{-0.5484286411986222,0.23588832569534599,0.12443602674364344},
{-0.5695095304906692,0.25161711349983273,0.09921768785221632},
{-0.5866972763084524,0.2551507874712008,0.056515817434759065},
{-0.6108509641659942,0.18082558606287916,0.014569276762892809},
{-0.5880721362096515,0.15334347688222774,-0.026795233966938996},
{-0.5511978877394494,0.12899918143024922,-0.05709585032399962},
{-0.5011149101958643,0.19176854779424407,-0.05303961420490337},
{-0.4527407441595636,0.1717727238535308,-0.04492736386146576},
{0.4744280718166812,0.27731407937752306,0.17730799946123954},
{0.4450891473272443,0.245674328174798,0.19782838260247487},
{0.42496950611331147,0.2966981394790488,0.2186090482911774},
{0.38981915799372524,0.3645726384684291,0.2133794327083076},
{0.36606022090510426,0.40458625393058817,0.19593872686996813},
{0.3522288551495449,0.428623668936576,0.22171535296465816},
{0.3057026286318346,0.4729065394825103,0.24694722743613262},
{0.3631474084578736,0.53499823926512,0.23214329696996058},
{0.39424906488002925,0.5978805500593457,0.17893382233020114},
{0.298433800251673,0.6405216213139675,0.18036260265683468},
{0.22939391000969456,0.6357604255586367,0.16047173493517677},
{0.17706225102021658,0.6233178990738335,0.12725320255152342},
{0.14130568643031471,0.6350186313930929,0.11964775982821796},
{0.4855321291400846,0.2214900188410836,0.1477476240064385},
{0.4515740215384363,0.19884543721143969,0.1618492575734344},
{0.39980797227913206,0.21644213506245555,0.18700746298629067},
{0.369409500335172,0.26724826761217496,0.21114406494770718},
{0.33732884425451237,0.3310620925873616,0.2091827372093761},
{0.31363691938186333,0.38139492362493477,0.20328078051923817},
{0.30388131648382904,0.4022082078426038,0.22107696175488573},
{0.29049751244885047,0.42706219554652786,0.23938771692708607},
{0.2230692438115217,0.5037685495694021,0.2424097015937147},
{0.30090859245278245,0.5678060444575017,0.2355977545138386},
{-0.43345409585542755,0.364757698693994,0.21327048238366447},
{-0.41246973078175075,0.2678569249247943,0.21070071922746897},
{-0.4415088754573528,0.21758467115530167,0.18603600774945242},
{-0.49209954820008966,0.19898722795980417,0.1612441505768931},
{-0.5273584028548092,0.22051745413047097,0.1479872703417024},
{-0.5731055568881569,0.2064613089882242,0.13153000205696438},
{-0.5999184314881083,0.2114694736057298,0.09890104403701117},
{-0.6160812454331286,0.20502720318747372,0.05910910143497119},
{-0.6284671887554389,0.1572503778312938,0.08144613693435977},
{-0.6175257802873582,0.14033090277215332,-0.0066822495956522805},
{-0.554843174772519,0.10959825732735308,-0.05502623794529005},
{-0.4921559094678276,0.10789277424139172,-0.04760652113181413},
{0.31401924404451115,0.27497908087198425,0.1761752267376079},
{0.28894824327032037,0.3674719153356124,0.1880057674884687},
{0.27777539857290606,0.3907457904900789,0.2096655801959819},
{0.25205247100889555,0.4419249281227415,0.24373951685967443},
{0.22738642816234972,0.4419868367593513,0.25192543626173014},
{0.18587236036773286,0.4846696242278894,0.24743073610700297},
{0.1792643345675859,0.5292680291152545,0.21621791041265545},
{0.21537726213381542,0.5745984647989488,0.2077745930949459},
{-0.38092184400754353,0.3313217094505641,0.20902497003866072},
{-0.35740055620139255,0.2758520148376584,0.17563668816752878},
{-0.3326118055554015,0.3674719153356124,0.1880057674884687},
{-0.31238032938501203,0.3509298832545126,0.14110453883502147},
{-0.33116083575328054,0.2641579393610451,0.11610942606699756},
{-0.35597199776951394,0.20788853605157362,0.09990644917134514},
{-0.39580166247988247,0.21046096194482758,0.1545628995076377},
{-0.4575285672854794,0.18219733943751007,0.14749488588063706},
{-0.5115548365179299,0.17183330112161138,0.16287441134095218},
{-0.5454321744288041,0.18729159921990676,0.15057789160485605},
{-0.5836406760600634,0.14367374725432971,0.15588162003585376},
{0.3534601491443405,0.20869223885372715,0.15577932655385685},
{0.3127779647857462,0.20634503613667027,0.10085349598514726},
{0.2875183534699125,0.2636921822705647,0.11637525598333659},
{0.26871654520517607,0.3509298832545126,0.14110476072977635},
{0.41704542252200694,0.1807885296388152,0.1488202632514993},
{0.38394737899025017,0.1670270607310411,0.12848183380926062},
{0.36194141046513356,0.15759853070169108,0.09180196514432812},
{0.344654033902412,0.15327446761346197,0.03794189508327822},
{0.2577021333627418,0.3367721103145335,0.07687000140459381},
{-0.3573004816669444,0.38139492362493477,0.20328078051923817},
{-0.3214394046474969,0.3907457904900789,0.2096655801959819},
{-0.34754487876891016,0.4022082078426038,0.22107673986013088},
{-0.33416129662868643,0.42706219554652786,0.23938771692708607},
{-0.29571647708348636,0.4419249281227415,0.24373929496491953},
{-0.29556780759772083,0.38225365632629704,0.21753995936219458},
{-0.27105043423694053,0.4419868367593513,0.25192521436697535},
{-0.2667332498861125,0.5037685495694021,0.24240947969895982},
{-0.2295363664423237,0.4846696242278894,0.24743073610700297},
{-0.22292834064217673,0.5292680291152545,0.21621791041265545},
{-0.2036876245522996,0.5074182744975693,0.22843632319503596},
{-0.1788212107421026,0.5280256403827152,0.19861167108718},
{-0.25904126820840623,0.5745984647989488,0.2077745930949459},
{-0.20637099782299057,0.5743071169857994,0.16967992347293695},
{-0.17562725764044665,0.602750030455055,0.1535546097414904},
{-0.16418658597389943,0.5642761426969665,0.19253020154034903},
{-0.40350163236876424,0.16058767494459839,0.08976785592639841},
{-0.4248565616830806,0.16934186681388638,0.12671821429752225},
{-0.47341312520788764,0.15294695095526797,0.14980125996279714},
{-0.4650088613670359,0.0976738550951806,0.1459937678639146},
{-0.5243852350342527,0.12460100549389219,0.18129988610142234},
{-0.30136591754257774,0.3367721103145335,0.07687000140459381},
{0.4103446447143227,0.5679345215205738,-0.018749995839473333},
{0.36302913855352575,0.5900882719524363,-0.03904804043632496},
{0.27815128828766256,0.6136854477647542,-0.03887895663311098},
{0.17181088975136913,0.5620900355719481,-0.10113197390251408},
{0.1679037669075482,0.4881631352486252,-0.13548372279930884},
{0.09192811231247396,0.46302845067978565,-0.11515705377907845},
{0.047708259876923835,0.36549416738542073,-0.12367337447114159},
{0.05751290151578524,0.27582583125658333,-0.11264032346929785},
{0.04545957843103099,0.2102785644563212,-0.07653982200934133},
{0.12009254786436283,0.20928891384958326,-0.06981286062058194},
{0.18523108452614706,0.21844162869862493,-0.04366101049540001},
{0.21178145763108266,0.21630056620884597,7.622084829922154e-05},
{0.21472422587022127,0.20887019844713609,0.06553450785185685},
{0.2361386229788439,0.27675667975327956,0.03551547593873132},
{-0.003219027208956751,0.3658569653096397,-0.12051647779354956},
{-0.021832003037295416,0.36211115995261206,-0.11538316453429504},
{0.009104341792479128,0.4661587199867928,-0.12220909098372823},
{0.007964468436691529,0.5561727681437239,-0.08862132572796455},
{-0.021832003037295416,0.5527771127098875,-0.0753975078112501},
{-0.021832003037295416,0.46798447002989585,-0.10964296912046022},
{-0.052768347867069965,0.4661587199867928,-0.12220909098372823},
{-0.040444978865634085,0.3658569653096397,-0.12051647779354956},
{-0.021832003037295416,0.2736554786591609,-0.09122770151871426},
{-0.00451400499840126,0.2740719751140594,-0.10113863074516029},
{-0.0037020920903173913,0.22437087844361236,-0.07280222675824409},
{-0.004885900607570043,0.1259811908692083,-0.05705346842581868},
{0.0325872418060369,0.12535056597585648,-0.06369300328115773},
{0.10449867207083945,0.12279899818956064,-0.04786591610026179},
{0.15779002587514734,0.1245242299087058,-0.014974234690537802},
{0.18448840278158388,0.12631270163299002,0.05744111856258353},
{-0.2554454637056735,0.21630056620884597,7.622084829922154e-05},
{-0.2583882319448121,0.20887019844713609,0.06553450785185685},
{-0.28948655994564465,0.27467441937354226,-0.028316988195864715},
{-0.2840039843422185,0.2716511033383843,-0.07372996872837217},
{-0.2852252930730449,0.3096243965294772,0.02489182075963007},
{-0.2798024071586798,0.27675667975327956,0.03551547593873132},
{-0.22889509060073787,0.21844162869862493,-0.04366101049540001},
{-0.22815240885617472,0.12631270163299002,0.05744111856258353},
{-0.20145403194973818,0.1245242299087058,-0.014974234690537802},
{-0.14816267814543027,0.12279899818956064,-0.04786591610026179},
{-0.16375655393895366,0.20928891384958326,-0.06981263872582705},
{-0.17797312898897427,0.2784375325214499,-0.1104684176085914},
{-0.2407797736717879,0.2733217489478305,-0.09656826447902106},
{-0.19250457269616106,0.3786369937166062,-0.12502116321224607},
{-0.13559211838706478,0.46302845067978565,-0.11515705377907845},
{-0.133471914004244,0.5510600910966726,-0.07536111707145075},
{-0.1621242961221007,0.6272452143403479,-0.041605377486247506},
{-0.2404877601743738,0.6255878824161942,-0.03978428723299681},
{-0.34498865119276195,0.661585868499399,0.01602668151290507},
{-0.43684708855220555,0.6311791864495085,0.017597696377412812},
{-0.49307211291070224,0.5485289376278253,0.025737683565209665},
{0.19682375409978295,0.6255878824161942,-0.03978428723299681},
{0.11846029004750987,0.6272452143403479,-0.041605377486247506},
{0.08980790792965314,0.5510600910966726,-0.07536111707145075},
{0.1413815744364816,0.4634127723952273,0.2628672885193207},
{0.1677546536322729,0.39472613860300826,0.2946315226795301},
{0.12450780969684515,0.4894814119873315,0.2327772502846355},
{0.16002361847770877,0.5074182744975693,0.22843632319503596},
{0.13515720466751177,0.5280256403827152,0.19861167108718},
{0.10639498464599241,0.5134245217224979,0.2118512435314905},
{0.09141597921822484,0.5453871297935646,0.2091973822631978},
{0.12052257989930859,0.5642761426969665,0.19253020154034903},
{0.0872947279359505,0.5740315237002458,0.22644881187562974},
{0.109917120090107,0.5986751551765493,0.21007453222921463},
{0.12135135680876287,0.62585038391121,0.17244650727670563},
{0.1319632515658558,0.602750030455055,0.1535546097414904},
{0.12006126070392559,0.6636206434015932,0.12022557376990979},
{0.21830538531913238,0.4289434192783494,0.2643759509577088},
{0.2387165962409697,0.35261938991812297,0.23652039290460455},
{0.17662467456360512,0.30577829474324664,0.284509349646444},
{0.09748391318500851,0.37291565935693566,0.3154583424772464},
{0.0746092266945603,0.4393576058088496,0.2825748711734527},
{0.05949530925582932,0.46382704990257706,0.24551534058293084},
{0.061805677443577144,0.49153371657516093,0.23245949699565593},
{0.06126070392560666,0.5306768389139493,0.23662290828135632},
{0.061046797381908144,0.5698164109366599,0.24681386868845334},
{0.10184370132877235,0.6153558714794456,0.26052252664456743},
{0.11052755256076532,0.615795001199341,0.22768010587042548},
{-0.18504558051107245,0.4634127723952273,0.2628672885193207},
{-0.21141865970686372,0.39472613860300826,0.2946313007847752},
{-0.14114791925959935,0.37291565935693566,0.3154583424772464},
{-0.22028868063819596,0.30577829474324664,0.284509349646444},
{-0.2823806023155605,0.35261938991812297,0.23652039290460455},
{-0.2619693913937232,0.4289434192783494,0.2643759509577088},
{-0.2825694347519583,0.3149221338020934,0.21023185561042027},
{-0.289665629012828,0.33941620821361185,0.17116240233024996},
{-0.30565181473296854,0.3575277018959353,0.16504343256984527},
{0.25190380152312997,0.38225365632629704,0.21753995936219458},
{0.23890542867736744,0.3149221338020934,0.21023185561042027},
{0.1789445842258125,0.2517810937236846,0.25811519044893966},
{0.1103895340232337,0.28188577701219153,0.30817154062193997},
{0.011588453573293266,0.35566711437631704,0.31679148616452923},
{0.00518545852664988,0.42091615462602855,0.2858169754369163},
{0.0068845066647198975,0.44723087550128793,0.261780448009948},
{0.014656592348935703,0.4771358535104082,0.25640349430984183},
{0.024801842436528655,0.5183827600201568,0.27317563125174604},
{0.023490888224733216,0.5672606271500213,0.2714006951075091},
{0.0790486750553239,0.6144656297228911,0.28635617969126004},
{-0.09137226595151467,0.3654943892801756,-0.12367337447114159},
{-0.03915000107618957,0.2740719751140594,-0.10113863074516029},
{-0.021832003037295416,0.23050404946832903,-0.06981263872582705},
{-0.021832003037295416,0.12337880918404635,-0.05602853655305581},
{-0.021832003037295416,0.04472754763470173,-0.06771129539717052},
{-0.005766822784419716,0.03837070669707213,-0.07130310579431554},
{0.03148819708514611,0.03609806061765288,-0.07353958302869032},
{0.10116137495753487,0.041488993687316074,-0.04637456145275382},
{0.15219472773624523,0.04016650094826719,-0.004102279280732588},
{0.17810138415729143,0.03610449556554422,0.06251984571213905},
{-0.10117690759037608,0.27582583125658333,-0.11264032346929785},
{-0.03996191398427344,0.22437087844361236,-0.07280222675824409},
{-0.03877810546702079,0.1259811908692083,-0.05705346842581868},
{-0.037897183290171124,0.03837070669707213,-0.07130310579431554},
{-0.07625124788062773,0.12535056597585648,-0.06369300328115773},
{-0.07515220315973695,0.03609806061765288,-0.07353958302869032},
{-0.1448253810321257,0.041488993687316074,-0.04637456145275382},
{-0.19585873381083604,0.04016650094826719,-0.004102279280732588},
{-0.22176539023188227,0.03610449556554422,0.06251984571213905},
{-0.08912358450562183,0.2102785644563212,-0.07653982200934133},
{0.02538231911527897,0.22006545451479267,0.283026870789131},
{-0.021832003037295416,0.22200792119895943,0.27973550589008533},
{0.026218196656889226,0.19502951311187197,0.27650316499583616},
{0.10576480354215034,0.2103926183603264,0.2611298525886575},
{0.09685328829165668,0.1944339475897902,0.23973986390307103},
{0.06951230417510514,0.15686117443124487,0.2559759031171997},
{0.02742042243879642,0.15845082845516203,0.2754072268015136},
{-0.005295296430312524,0.1580587404232997,0.27620249760298193},
{-0.016198539000554974,0.20476869579804555,0.27759022739996375},
{-0.021832003037295416,0.2046011652581157,0.27666958606199166},
{-0.02746546707403586,0.20476869579804555,0.27759022739996375},
{-0.06988220273148006,0.19502951311187197,0.27650316499583616},
{-0.0690463251898698,0.22006545451479267,0.283026870789131},
{-0.06754897938398023,0.23628884572789352,0.29549580274976417},
{-0.021832003037295416,0.244244660269145,0.28654212749584446},
{0.023884973309389393,0.23628884572789352,0.29549580274976417},
{0.10956208848230864,0.2299612948979073,0.2855873143656218},
{0.17518258055167918,0.23080760149299662,0.2331504772623335},
{0.161461718384047,0.2016812521787291,0.19687445705127168},
{0.1454509023461154,0.11531581947619075,0.18455308510262966},
{0.09201487316162969,0.11352712585715165,0.22197408224884121},
{0.027968724378090008,0.11104900523471913,0.2508243944880455},
{-0.012851700412790825,0.10904152338737427,0.25234681440123585},
{-0.021832003037295416,0.10784928286943642,0.2501718020139612},
{-0.030812305661800012,0.10904152338737427,0.25234681440123585},
{-0.03836870964427831,0.1580587404232997,0.27620249760298193},
{-0.07108442851338725,0.15845082845516203,0.2754072268015136},
{-0.11317631024969596,0.15686117443124487,0.2559759031171997},
{-0.14051729436624752,0.1944339475897902,0.23973986390307103},
{-0.14942880961674118,0.2103926183603264,0.2611298525886575},
{-0.15322609455689948,0.2299612948979073,0.2855873143656218},
{-0.0662311464347837,0.27665771469260586,0.31420330574367916},
{-0.021832003037295416,0.2781426343922225,0.2918305451887559},
{0.022567140360192865,0.27665771469260586,0.31420330574367916},
{0.2341704165031117,0.28070973481135947,0.18166690002598387},
{0.22242641470665175,0.22315822360822613,0.13875866748649382},
{0.18180702656368677,0.1224346470020576,0.1300557333055817},
{0.17285091046746343,0.023746510982348007,0.13988411768321463},
{0.14126685484821178,0.011808795064883096,0.19872239656986213},
{0.09309084082801358,-0.0005496333078228715,0.22594311372927198},
{0.07472527765135939,0.06442226039305102,0.24774294202711064},
{0.030978061043690844,0.06284614194918119,0.26944735558035354},
{-0.00578812468088762,0.06138518688309093,0.2656971123282285},
{-0.012622039341496262,-0.006945527722310283,0.2580681487609064},
{-0.021832003037295416,-0.010314333890806958,0.2565037907390449},
{-0.03104196673309457,-0.006945527722310283,0.2580681487609064},
{-0.03787588139370321,0.06138518688309093,0.2656971123282285},
{-0.07464206711828167,0.06284614194918119,0.26944735558035354},
{-0.07163273045268084,0.11104900523471913,0.2508243944880455},
{-0.13567887923622052,0.11352712585715165,0.22197408224884121},
{-0.18911490842070625,0.11531581947619075,0.18455308510262966},
{-0.20512572445863783,0.2016812521787291,0.19687445705127168},
{-0.21884658662627002,0.23080760149299662,0.2331504772623335},
{-0.22260859030040334,0.2517810937236846,0.25811519044893966},
{-0.15405354009782454,0.28188577701219153,0.30817154062193997},
{-0.0552524596478841,0.35566711437631704,0.31679148616452923},
{-0.021832003037295416,0.3465372546870274,0.29214452626690257},
{-0.11838928372595023,0.06442226039305102,0.24774294202711064},
{-0.13675484690260442,-0.0005496333078228715,0.22594311372927198},
{-0.18493086092280261,0.011808795064883096,0.19872239656986213},
{-0.21651491654205426,0.023746510982348007,0.13988411768321463},
{-0.22547103263827759,0.1224346470020576,0.1300557333055817},
{-0.2660904207812426,0.22315822360822613,0.13875866748649382},
{-0.2778344225777025,0.28070973481135947,0.18166690002598387},
{-0.04884946460124071,0.42091615462602855,0.2858169754369163},
{-0.021832003037295416,0.41321041547352,0.27195365683665507},
{0.0356948778480469,-0.008889103880251435,0.25322840226235016},
{-0.07935888392263774,-0.008889103880251435,0.25322840226235016},
{-0.11827323276915112,0.4393576058088496,0.2825748711734527},
{-0.050548512739310734,0.44723087550128793,0.261780448009948},
{-0.021832003037295416,0.43116414198512815,0.26558483358226226},
{0.24600162293823713,0.33941620821361185,0.17116240233024996},
{0.2384232513750263,0.3091084912243952,0.1056617334285114},
{0.4342171919174391,0.09490394287008878,0.14970872985001468},
{0.49200901514010104,0.12607593992953947,0.18114544735203006},
{0.473627253646341,0.17268360182228842,0.16335681053804818},
{0.5059229257444735,0.18976661331577105,0.14988114207455175},
{0.5489492062935566,0.15067008887550612,0.15344832215390575},
{0.5315977021466763,0.20951613407857422,0.13017222805189052},
{0.43536882569523505,0.1516974615905726,0.15144550009641328},
{0.4063245774402709,0.13104527296494214,0.13409377405477826},
{0.4056466889641309,0.073428302809121,0.0944434003063479},
{0.38537260900080567,0.11191661372627636,0.09959313377746308},
{-0.44430053336842235,0.13369979991749947,0.13164760627704758},
{-0.4374013816498807,0.0793049634972033,0.08914189082289893},
{-0.42340248535439146,0.11603098627114956,0.09633483119689366},
{0.439379795284337,0.0785052548006375,-0.03446369480062866},
{0.400123284725808,0.06628196033364978,0.03659920992153581},
{0.378170792836616,0.09432524134937746,0.04350191195615538},
{0.39990360891848276,0.09043476061217208,-0.0036868922996084997},
{-0.051628474511282364,0.5561727681437239,-0.08862132572796455},
{-0.07109774219867969,0.6257698361151909,-0.04845238393739372},
{-0.1364437504562711,0.6864449597826852,0.020729075158194322},
{-0.2049171433890563,0.661746076512418,0.03575978206384756},
{-0.26925597135427476,0.6656445454607988,0.028108629021038074},
{0.26198780865837773,0.3575277018959353,0.16504343256984527},
{0.24630007138354262,0.34157790691559403,0.09065521305113942},
{-0.2899638555633786,0.34157790691559403,0.09065521305113942},
{-0.2820872574496171,0.3091084912243952,0.1056617334285114},
{-0.4799292865795168,0.5083140636229954,0.1663166646733121},
{-0.4429483067322203,0.46672543919074094,0.20863776369140563},
{-0.40681119263770954,0.5349980173703651,0.23214329696996058},
{-0.34936641281167063,0.4729065394825103,0.24694722743613262},
{-0.3958926393293808,0.42862344704182115,0.22171535296465816},
{-0.4498481241350265,0.4219408646040365,0.17853818398226085},
{-0.4097237831901853,0.40458603203583327,0.19593872686996813},
{-0.5055350537129538,0.535640846475235,0.09894276025092748},
{-0.4427834389293489,0.6392213180504059,0.09903817499552328},
{-0.4379128490598652,0.5978805500593457,0.17893382233020114},
{-0.10315931533042015,0.46382704990257706,0.24551534058293084},
{-0.10546968351816798,0.49153371657516093,0.23245949699565593},
{-0.15005899072058324,0.5134245217224979,0.2118512435314905},
{-0.13507998529281567,0.5453871297935646,0.2091973822631978},
{-0.1049247100001975,0.5306768389139493,0.23662290828135632},
{-0.058320598423526535,0.4771358535104082,0.25640349430984183},
{-0.021832003037295416,0.47173781980858914,0.26232275879086},
{-0.16817181577143597,0.4894814119873315,0.2327772502846355},
{-0.13095873401054134,0.5740315237002458,0.22644881187562974},
{-0.10471080345649898,0.5698164109366599,0.24681386868845334},
{-0.06846584851111948,0.5183827600201568,0.27317563125174604},
{-0.021832003037295416,0.5155387349469371,0.2812297451694067},
{0.16270699174839973,0.5743071169857994,0.16967992347293695},
{-0.3445725985273733,0.5678060444575017,0.2355977545138386},
{-0.2730579160842854,0.6357604255586367,0.16047173493517677},
{-0.22072625709480742,0.6233181209685882,0.12725320255152342},
{-0.18496969250490555,0.6350186313930929,0.11964775982821796},
{0.027433736124088857,0.6257698361151909,-0.04845238393739372},
{0.09277974438168027,0.6864449597826852,0.020729075158194322},
{0.046249745653137206,0.6795047575344919,0.00515650126113885},
{-0.021832003037295416,0.6272057170739803,-0.036722805300000584},
{-0.08991375172772804,0.6795047575344919,0.00515650126113885},
{-0.021832003037295416,0.6782998690155261,0.006430177154115453},
{-0.1628523328128422,0.6799986952588412,0.04010181862722148},
{-0.27553958702279596,0.6659778313826196,0.09347039180622553},
{-0.35056131606666696,0.6747983697836148,0.09766176183104001},
{-0.2121790930318168,0.652245208792979,0.07968074226458242},
{-0.17576150396714538,0.6622444521318648,0.08214421783319328},
{-0.3420978063262638,0.6405216213139675,0.18036260265683468},
{0.08361105311028767,0.7099063360050201,0.06344891905079637},
{0.10738485714748522,0.6899790775435629,0.0935098890725931},
{0.10238468074115509,0.7323152654049879,0.12237506826037398},
{0.07690051193338895,0.7427605172011703,0.08417766136685838},
{0.03958913079608514,0.7113027196974419,0.04116780102963605},
{-0.021832003037295416,0.7150289983160407,0.024302246395929927},
{-0.08325313687067598,0.7113027196974419,0.04116780102963605},
{-0.1272750591848785,0.7099063360050201,0.06344891905079637},
{-0.15104886322207606,0.6899790775435629,0.0935098890725931},
{-0.16372526677851643,0.6636206434015932,0.12022557376990979},
{-0.12056451800797979,0.7427605172011703,0.08417766136685838},
{-0.14604868681574593,0.7323152654049879,0.12237506826037398},
{-0.11676035433042038,0.7839049083341671,0.09674378323012639},
{-0.13722681704622136,0.7674136901519336,0.12540437545391347},
{-0.13628886791736908,0.7930895760279107,0.12517205164556042},
{-0.1115799993831326,0.8470190991472362,0.08726710203896873},
{-0.12259618638360588,0.8434783245437123,0.11277101947991863},
{-0.1561517768999128,0.7974950744911787,0.11043602097437982},
{-0.15127630534582187,0.7800523716000454,0.12549313335586304},
{-0.14512005726659835,0.784604098706775,0.15195275150605517},
{-0.15806983516104348,0.7847379012439643,0.13236232928249667},
{-0.16480034686588083,0.8037593853160259,0.11730211037444518},
{-0.16551373850280066,0.8461084430732334,0.11105777007753669},
{-0.15422617421711649,0.8475816023508417,0.10133012591861655},
{-0.16675612723534003,0.8880236965846624,0.09546855407386566},
{-0.17569715448823192,0.881215743610374,0.1043845072194568},
{-0.1791367450835334,0.9127294585923307,0.09385737625872573},
{-0.188250850245227,0.9077732173474655,0.10004890560397423},
{-0.22059977708452927,0.9678978201281175,0.08808212147362082},
{-0.19630052626779015,0.954150996274165,0.09046038945636008},
{-0.21877779925225907,0.9743687149697523,0.09337364569310048},
{-0.19444260148523035,0.9618653893221136,0.09819120271616932},
{-0.16758912014513694,0.9289810304393005,0.09481152370468382},
{-0.16602897812361803,0.9449472456315025,0.10829429280033621},
{-0.1718914375473884,0.9473022146649799,0.12031677251416298},
{-0.14294304782652978,0.9307808187960832,0.14434220520338764},
{-0.14027010360931788,0.9283446362823219,0.1217542067362366},
{-0.11655088568181936,0.9117917313582332,0.13437535849871335},
{-0.12180712863527406,0.9184585592684218,0.15744353721541166},
{-0.10724417587289514,0.9549591369714161,0.1485431167026617},
{-0.10902865349159163,0.9542637188096412,0.20375275066285511},
{-0.1272657396051738,0.9111462395163049,0.2039063018332279},
{-0.09444794914882282,0.9558245265154247,0.23281830081428714},
{-0.1143525743452829,0.926409714019821,0.24014415614645146},
{-0.07487749745320295,0.9518395186126429,0.25016958306641246},
{-0.09176990135224883,0.9258418853420983,0.26658979492708645},
{-0.05530726765233797,0.9478545107098612,0.26752064342378284},
{-0.05996128824106469,0.9173089225434197,0.28032996193839266},
{-0.021832003037295416,0.9441051550367556,0.2753135872149568},
{-0.033187023328461275,0.9096204911817914,0.29520267977857567},
{-0.021832003037295416,0.9081446691671247,0.2988353188106175},
{-0.010476982746129557,0.9096204911817914,0.29520267977857567},
{0.016297282166473862,0.9173089225434197,0.28032996193839266},
{0.011643261577747137,0.9478545107098612,0.26752064342378284},
{0.048105895277658,0.9258418853420983,0.26658979492708645},
{0.031213491378612127,0.9518395186126429,0.25016958306641246},
{0.07068834637593718,0.926409714019821,0.24014415614645146},
{0.05078372117947712,0.9558245265154247,0.23281830081428714},
{0.08360173353058296,0.9111462395163049,0.2039063018332279},
{0.0653646474170008,0.9542637188096412,0.20375275066285511},
{0.0781431225606832,0.9184585592684218,0.15744353721541166},
{0.0635801697983043,0.9549591369714161,0.1485431167026617},
{0.07288687960722852,0.9117917313582332,0.13437535849871335},
{0.09927904175193894,0.9307808187960832,0.14434220520338764},
{0.09660609753472706,0.9283446362823219,0.1217542067362366},
{0.12236497204902719,0.9449472456315025,0.10829429280033621},
{0.12822743147279755,0.9473022146649799,0.12031677251416298},
{0.1507785954106395,0.9618653893221136,0.09819120271616932},
{0.12392511407054609,0.9289810304393005,0.0948117455994387},
{0.15263652019319932,0.954150996274165,0.09046038945636008},
{0.17511379317766823,0.9743687149697523,0.09337364569310048},
{0.17693577100993843,0.9678978201281175,0.08808212147362082},
{0.13547273900894255,0.9127294585923307,0.09385737625872573},
{0.14458684417063616,0.9077732173474655,0.10004890560397423},
{0.1320331484136411,0.881215743610374,0.1043845072194568},
{0.12309212116074919,0.8880236965846624,0.09546855407386566},
{0.12184951053345494,0.8461084430732334,0.11105799197229158},
{0.11056216814252565,0.8475816023508417,0.10133012591861655},
{0.11248754893056713,0.7974950744911787,0.11043602097437982},
{0.12113634079128999,0.8037593853160259,0.11730211037444518},
{0.11440582908645264,0.7847379012439643,0.13236232928249667},
{0.10761229927123103,0.7800523716000454,0.12549313335586304},
{0.10145605119200751,0.784604098706775,0.15195275150605517},
{0.09262486184277824,0.7930895760279107,0.12517205164556042},
{0.07893218030901505,0.8434783245437123,0.11277101947991863},
{0.06791599330854176,0.8470190991472362,0.08726710203896873},
{0.07309634825582956,0.7839049083341671,0.09674378323012639},
{0.09356281097163052,0.7674136901519336,0.12540437545391347},
{0.037020920903173764,0.7476317727549188,0.060901123475333406},
{-0.021832003037295416,0.7523479238750103,0.038772003361261756},
{-0.0806849269777646,0.7476317727549188,0.060901123475333406},
{-0.15358112616469785,0.5986749332817944,0.21007453222921463},
{-0.1650153628833537,0.62585038391121,0.17244650727670563},
{-0.1455077074033632,0.6153558714794456,0.26052252664456743},
{-0.12271268112991475,0.6144656297228911,0.28635617969126004},
{-0.06715489429932406,0.5672606271500213,0.2714006951075091},
{-0.021832003037295416,0.5660415373667438,0.2805516347985118},
{-0.15419155863535616,0.615795001199341,0.22768010587042548},
{0.13176154923367536,0.624014204814628,0.23956545462574014},
{0.12941789683269644,0.6256460188419711,0.2774690728638025},
{0.1376748225563119,0.638864067495059,0.18790658053304002},
{0.13450261514063355,0.6636233061386518,0.13423711806642688},
{0.12248967690126637,0.7261714434320372,0.14706330058240716},
{0.11072947678770063,0.7583754729964068,0.14861390112946649},
{0.0992668375404209,0.6187695003884266,0.3184483742991731},
{0.1370854700873666,0.6470138180520703,0.28837009648649625},
{0.14174525993972004,0.6547197790993335,0.2377159618438655},
{0.14382064158205632,0.6680356833393207,0.19022715587951203},
{0.14130723969359885,0.680488638877603,0.1560458221544605},
{0.12636307174234643,0.7166155458133895,0.20224763854054495},
{0.10917998571441566,0.7510001351339057,0.17028858078555625},
{0.10111655221705035,0.7838354552758917,0.17677057036493476},
{0.09077803179796214,0.8379897577819044,0.1692001870128994},
{0.10431827163512689,0.809405497353794,0.1478397103297112},
{0.11063650288540842,0.8061017063484756,0.13444614292551815},
{0.11624112060401524,0.8504100947912202,0.12265709649381878},
{0.12732897961031286,0.8803701026995494,0.1154084605363507},
{0.14248638842099912,0.9109687237124057,0.10827165953533907},
{0.1746307282963076,0.9665072056993224,0.09456211400020548},
{0.13363789128088968,0.9432302240182876,0.12595800286732403},
{-0.1754255553082662,0.624014204814628,0.23956545462574014},
{-0.17308190290728728,0.6256460188419711,0.2774690728638025},
{-0.18074947616195744,0.6470138180520703,0.28837009648649625},
{-0.14293084361501174,0.6187695003884266,0.3184483742991731},
{-0.18133882863090273,0.638864067495059,0.18790658053304002},
{-0.18540926601431088,0.6547197790993335,0.2377159618438655},
{-0.17380217328160819,0.6924070499513939,0.2985399768918802},
{-0.14614343587607712,0.6387806350672263,0.3281757965633384},
{-0.08257302944698725,0.611863469932484,0.34776111520753483},
{-0.07194049847769104,0.604815204938667,0.31012687720188936},
{0.09098772234131804,0.8779450149235317,0.15529271135641826},
{0.0944077861981906,0.8811440716045498,0.15287494610731142},
{0.08422547968653371,0.9023592072232954,0.1635494151852788},
{0.08685005084718306,0.8659775651089135,0.165070281835185},
{0.08423169273967017,0.8803148509055857,0.1816990747654406},
{0.10575836859425898,0.9246272334539183,0.14895295631491393},
{0.09576200988718649,0.8959517742815547,0.15346984594512852},
{0.09782785005506316,0.8843433501803227,0.15045740275295946},
{0.10576702248969906,0.8777029277459641,0.13846265988349196},
{0.10469038913905056,0.8740261316577024,0.13929831553034733},
{0.1036139776831569,0.8703495574641956,0.1401339711772027},
{0.09968843757468145,0.8689265464011888,0.13322616556322103},
{0.08639206007312318,0.873481158139732,0.14318458026721012},
{0.08294270610860725,0.8636081729163694,0.1475192943036732},
{0.10249540622383721,0.8581125055224057,0.1598559769904015},
{0.08866071204695468,0.8547246164049898,0.17161262678788924},
{0.09261287952601505,0.8615824956991247,0.19394699955021932},
{0.09511097067638624,0.9054000529440883,0.21596650365538325},
{0.08473916604406695,0.9235013394676876,0.25579971868182977},
{0.058309059896273066,0.9250310819077888,0.2863319931629788},
{0.02313740988021898,0.9158251123175776,0.30742974645639626},
{-0.0073107664888328264,0.9074119726865308,0.3227875262307337},
{-0.021832003037295416,0.9059634437267134,0.3252527769573835},
{-0.03635323958575801,0.9074119726865308,0.3227875262307337},
{-0.0668014159548098,0.9158251123175776,0.3074299683511511},
{-0.1019730659708639,0.9250313038025437,0.2863319931629788},
{-0.12840339401341266,0.9235013394676876,0.25579971868182977},
{-0.13877497675097708,0.9054000529440883,0.21596650365538325},
{-0.13627688560060588,0.8615824956991247,0.19394699955021932},
{-0.12789569881426102,0.8803148509055857,0.1816990747654406},
{-0.12788948576112455,0.9023592072232954,0.1635494151852788},
{-0.1494223746688498,0.9246272334539183,0.14895295631491393},
{-0.17730189735548052,0.9432302240182876,0.12595800286732403},
{-0.1346517284159089,0.8779447930287768,0.15529271135641826},
{-0.13807179227278144,0.8811440716045498,0.15287494610731142},
{-0.14835439521364138,0.8740261316577024,0.13929831553034733},
{-0.1494310285642899,0.8777029277459641,0.13846265988349196},
{-0.14149185612965398,0.8843433501803227,0.15045740275295946},
{-0.1394260159617773,0.8959517742815547,0.15346984594512852},
{-0.1540349009384151,0.91486097960765,0.14376217231414704},
{-0.18009954642493156,0.9356491897180184,0.12305029399945548},
{-0.21829473437089844,0.9665072056993224,0.09456211400020548},
{-0.18615039449558995,0.9109687237124057,0.10827165953533907},
{-0.17099298568490368,0.8803701026995494,0.1154084605363507},
{-0.1599051266786061,0.8504100947912202,0.12265709649381878},
{-0.15430050895999925,0.8061017063484756,0.13444614292551815},
{-0.14798227770971772,0.809405497353794,0.1478394884349563},
{-0.134442037872553,0.8379897577819044,0.1692001870128994},
{-0.14478078018639604,0.7838354552758917,0.17677057036493476},
{-0.15439348286229146,0.7583754729964068,0.14861390112946649},
{-0.14727798375774773,0.8703493355694407,0.1401339711772027},
{-0.15761805744012006,0.8722500860396912,0.12407367260893425},
{-0.1625012953106316,0.8798127030753059,0.1192143993719491},
{-0.144948088831571,0.8798843750811302,0.13369347591698563},
{-0.13641268519058874,0.8853880306862695,0.14044684278157504},
{-0.13423745090855918,0.8949292832510954,0.14042088109525477},
{-0.14532464423059213,0.9122801217137109,0.12613396540793909},
{-0.17175186574657267,0.9348816557609092,0.108724324835282},
{-0.1761269646284228,0.9233693120885377,0.10234573821167472},
{-0.1527350414643634,0.8646876908988312,0.12893316774067426},
{-0.14335244364927227,0.8689265464011888,0.13322616556322103},
{-0.1347378235808,0.8514026300297715,0.1416397489837775},
{-0.14591399669953745,0.8429182621824103,0.13872072348341036},
{0.11883728923604076,0.8798127030753059,0.1192143993719491},
{0.11395405136552922,0.8722500860396912,0.12407367260893425},
{0.13246295855383197,0.9233693120885377,0.10234573821167472},
{0.12808763777722695,0.9348818776556641,0.108724324835282},
{0.13643554035034072,0.9356491897180184,0.12305029399945548},
{0.10907103538977256,0.8646876908988312,0.12893316774067426},
{0.09107381750620916,0.8514026300297715,0.1416397489837775},
{0.10128408275698018,0.8798843750811302,0.13369347591698563},
{0.10584646081194397,0.8963618357885618,0.11164556928319785},
{0.1016606381560013,0.9122801217137109,0.12613396540793909},
{0.11037067296906941,0.91486097960765,0.14376217231414704},
{0.09057344483396834,0.8949292832510954,0.14042088109525477},
{0.0927486791159979,0.8853880306862695,0.1404470646763299},
{-0.13005606614771403,0.873481158139732,0.14318435837245524},
{-0.1266067121831981,0.8636081729163694,0.1475192943036732},
{-0.14436983110036944,0.8577636869677437,0.14826463878529486},
{-0.14615941229842805,0.8581125055224057,0.1598559769904015},
{-0.14772820821538704,0.841380087741624,0.15468538541232818},
{-0.13232471812154553,0.8547246164049898,0.17161262678788924},
{-0.13803850805955034,0.8402058206988309,0.19353383151664402},
{-0.1414423735993171,0.7998553689987732,0.21935860877314167},
{-0.14401457759781622,0.7576780577818378,0.19424899831160283},
{-0.1487293973493784,0.755394316964675,0.18370589092852083},
{-0.14586628932723952,0.7503158117098744,0.17564090416787137},
{-0.15284399178900648,0.7510001351339057,0.17028858078555625},
{-0.1661536829758572,0.7261714434320372,0.14706330058240716},
{0.051638015985741914,0.8097827184370798,0.3048298056135379},
{0.01402463608705462,0.8109822814819285,0.3075193919373653},
{0.050438896730402964,0.7993365790618778,0.2992114304201288},
{0.08529434672076162,0.7863590643230735,0.27603629843158134},
{0.0530747845235509,0.7531356502548128,0.310289526057212},
{0.008978527466465588,0.7589368667262381,0.3270081863631915},
{0.00795248611992833,0.7980032134798399,0.31607920400138373},
{0.001713027507627063,0.8019276441145411,0.31373888002172795},
{0.004733680805726468,0.8076753839500416,0.31196216871945204},
{0.010097320820540162,0.8271743855345921,0.3037074619433853},
{0.04937801790735049,0.8255663142460206,0.3023672176239465},
{0.0904851307215285,0.826068683971055,0.2775447389752146},
{0.09014896016789445,0.8063147253131544,0.2772649296893185},
{0.09777836752472627,0.7998553689987732,0.21935860877314167},
{0.0904553968243754,0.7488151374826616,0.27402970416325595},
{0.055207415012644666,0.7180540895092375,0.311920008716026},
{0.012903623785431311,0.7184559409103143,0.32928970823280573},
{-0.021832003037295416,0.7187535017766002,0.333224567920986},
{-0.018460312236985386,0.7616331098927115,0.3329432053718058},
{-0.016500537761938452,0.7955124448563797,0.323700845041795},
{-0.01638448680513936,0.8021721721344122,0.31895762276160894},
{-0.0158734631846646,0.8061172389813167,0.3180977805864723},
{-0.00549389223592473,0.8080858892465584,0.3149353365400084},
{-0.0023363298740680842,0.8035437036142883,0.3215020899157488},
{-0.00012736758929767438,0.8081637743055192,0.32202198932641846},
{-0.003428939647067531,0.8193892080598388,0.32137805074777426},
{0.0016293731850395776,0.8223685889335315,0.31049966039007765},
{-0.01065072633919588,0.8319713063454577,0.31310670186509193},
{-0.00705469994170826,0.8439782534264433,0.3034567208703777},
{0.012610500814242788,0.8353052750374391,0.29257566777562266},
{0.04990279900262744,0.8337140677502379,0.29071974004585677},
{0.08135970892733634,0.8357075702280257,0.2721112021126155},
{0.1004211340552753,0.8328211632566249,0.2485286713541194},
{0.10435665942772011,0.8182417902823853,0.23213641823255945},
{0.09988548011700954,0.852982964473984,0.21255132148311792},
{0.09437428009020465,0.8402060425935857,0.19353383151664402},
{0.1003503496284705,0.7576780577818378,0.19424899831160283},
{0.09306576672071282,0.7208524042629532,0.26960734169861766},
{0.059077703327156506,0.7071077993565495,0.31722085251521026},
{0.015324273666351486,0.7071685985193851,0.33799752409832506},
{-0.021832003037295416,0.7067853862777176,0.34230472318518385},
{-0.05656762986002215,0.7184559409103143,0.32928970823280573},
{-0.05264253354105642,0.7589368667262381,0.3270081863631915},
{-0.02520369383760545,0.7616331098927115,0.3329432053718058},
{-0.021832003037295416,0.7613526349225509,0.3278762386442585},
{-0.021832003037295416,0.7934115453172329,0.32079846164804343},
{-0.021832003037295416,0.7990126127197617,0.3192414261530927},
{-0.021832003037295416,0.7995997462411583,0.3292499890716833},
{-0.016584413979280812,0.800070163121491,0.3290593814772466},
{-0.014707628142556743,0.8073647312932182,0.3235832408217118},
{-0.006150256920841944,0.8055232267225191,0.31976886998542814},
{-0.011635939050836324,0.8005203875791304,0.32817845930039685},
{-0.010568181490382762,0.8046809142330174,0.33139082966670746},
{-0.012223960151252353,0.8239256244284823,0.32750456492984464},
{-0.09530202206033275,0.8097824965423249,0.3048298056135379},
{-0.0941029028049938,0.7993365790618778,0.2992114304201288},
{-0.05768864216164546,0.8109820595871736,0.3075193919373653},
{-0.05376154878988587,0.8271741636398372,0.3037074619433853},
{-0.0483976868803173,0.8076753839500416,0.31196216871945204},
{-0.0453770335822179,0.8019276441145411,0.31373888002172795},
{-0.051616492194519165,0.7980032134798399,0.31607920400138373},
{-0.09673901249289661,0.7531356502548128,0.310289526057212},
{-0.12895835279535248,0.7863590643230735,0.27603629843158134},
{-0.1338129662424853,0.8063147253131544,0.2772649296893185},
{-0.13414913679611934,0.8260684620763001,0.2775445170804597},
{-0.0930422458766962,0.8255663142460206,0.3023672176239465},
{-0.09356680507721828,0.8337140677502379,0.29071974004585677},
{-0.05627450688883363,0.8353050531426842,0.29257566777562266},
{-0.03660952802763745,0.8439782534264433,0.3034567208703777},
{-0.03301350163014983,0.8319713063454577,0.31310670186509193},
{-0.04529337925963041,0.8223685889335315,0.31049966039007765},
{-0.04023506642752331,0.8193892080598388,0.32137805074777426},
{-0.043536638485293155,0.8081637743055192,0.32202198932641846},
{-0.04132767620052275,0.8035437036142883,0.3215020899157488},
{-0.03817011383866611,0.8080858892465584,0.3149353365400084},
{-0.02779054288992623,0.8061172389813167,0.3180977805864723},
{-0.027279519269451474,0.8021721721344122,0.31895762276160894},
{-0.027163468312652383,0.7955124448563797,0.323700845041795},
{-0.021832003037295416,0.6539875264082495,0.22065513982587032},
{0.10718825839466686,0.6870145636184467,0.19397651155261758},
{0.06303031459572661,0.6802523209636623,0.16862880801909894},
{0.02161743080933226,0.6736653751652283,0.1487374965079313},
{0.02013206732020588,0.7390207030025244,0.13477454716273163},
{0.061288218875211034,0.7375613011997183,0.1580067061032818},
{0.10058378291059791,0.7351599561624722,0.180374363078843},
{0.11012037568557156,0.7107419916518755,0.20543271585200595},
{0.10852450860851796,0.6822784419704165,0.22851687099105522},
{0.10729942766685875,0.6714062646658565,0.275293838581773},
{0.07647181126697244,0.6671895986389862,0.30290065261466353},
{0.027757258676695117,0.6590076733425182,0.32072856480025813},
{-0.021832003037295416,0.6500209357701223,0.3312470418655491},
{-0.07142126475128596,0.6590076733425182,0.32072856480025813},
{-0.12013581734156327,0.6671895986389862,0.30290065261466353},
{-0.15096343374144958,0.6714062646658565,0.275293838581773},
{-0.1521885146831088,0.6822784419704165,0.22851687099105522},
{-0.1508522644692577,0.6870145636184467,0.19397651155261758},
{-0.10669432067031744,0.6802523209636623,0.16862880801909894},
{-0.0652814368839231,0.6736653751652283,0.1487374965079313},
{-0.021832003037295416,0.669531919671436,0.12824773484286855},
{-0.021832003037295416,0.744844330844192,0.11218233269523797},
{-0.021832003037295416,0.7229650642241083,0.21726725070845448},
{0.09123047520315018,0.7247695123707434,0.2138789178015289},
{0.10332795534412435,0.711686375728619,0.20654218962637583},
{0.11022000643050997,0.7118929597454068,0.20950448460394336},
{0.10220228325264868,0.7503158117098744,0.17564090416787137},
{-0.13489470317249588,0.7247692904759885,0.2138789178015289},
{-0.14424778898518875,0.7351597342677173,0.180374363078843},
{-0.10495222494980187,0.7375613011997183,0.1580067061032818},
{-0.1537843817601624,0.7107419916518755,0.20543271585200595},
{-0.15526996714404367,0.7049265739161384,0.24236576643224966},
{-0.1562423099599014,0.6983753531732392,0.2907891931041323},
{-0.1262128489932968,0.6943830227435467,0.31991798326070353},
{-0.07827803457164662,0.6930261363174923,0.3381661641120293},
{-0.021832003037295416,0.6935358285694377,0.3475647383494713},
{0.03461402849705578,0.6930261363174923,0.3381661641120293},
{0.08254884291870596,0.6943830227435467,0.31991798326070353},
{0.11257830388531058,0.6983753531732392,0.2907891931041323},
{0.11160596106945282,0.7049265739161384,0.24236576643224966},
{-0.0637960733947967,0.7390207030025244,0.13477454716273163},
{0.07184020204848798,0.7139694508615174,0.26005388492227355},
{0.08772010018104391,0.692727244082677,0.2622224623616569},
{0.09532620858861397,0.6941072075632383,0.2675829958499024},
{-0.11550443001783368,0.7139694508615174,0.26005388492227355},
{-0.13138410625563474,0.692727244082677,0.2622224623616569},
{-0.0932384008400048,0.6890222673605464,0.30174413715226045},
{-0.0841336152580159,0.7099167650584991,0.2918704862446332},
{-0.04905560482851863,0.7082782941885098,0.3051586536402611},
{-0.021832003037295416,0.7071827997836968,0.30805216124381773},
{0.005391598753927802,0.7082782941885098,0.3051586536402611},
{0.04046960918342507,0.7099167650584991,0.2918704862446332},
{0.04957439476541396,0.6890222673605464,0.30174413715226045},
{0.05608500876817123,0.6905788590659873,0.3112884962436546},
{-0.14699196141871518,0.711686375728619,0.20654218962637583},
{-0.13899021466320483,0.6941072075632383,0.2675829958499024},
{-0.09974901484276207,0.6905788590659873,0.3112884962436546},
{-0.0579908628177838,0.6880133119101343,0.3276789742071756},
{-0.0551510537449067,0.686742520648971,0.3151709887696845},
{-0.021832003037295416,0.6853250569548361,0.3178228529851835},
{0.01148682577556099,0.686742520648971,0.3151709887696845},
{0.014326856743192973,0.6880133119101343,0.3276789742071756},
{-0.1538840125051008,0.7118929597454068,0.20950448460394336},
{0.12087672392808743,0.7106237217475276,0.24117352591431182},
{0.11724430679080049,0.7193461826668687,0.2062186670737696},
{0.11933189264465485,0.702030847365033,0.2941777479058128},
{0.08859902530509972,0.697764698807826,0.32913194106209037},
{0.03954941163496269,0.6960583281428451,0.35034707668083614},
{-0.021832003037295416,0.6965680203947907,0.35974587281303305},
{-0.08321341770955352,0.6960583281428451,0.35034707668083614},
{-0.13226303137969056,0.697764698807826,0.32913194106209037},
{-0.1629958987192457,0.702030847365033,0.2941777479058128},
{-0.16454073000267827,0.7106237217475276,0.24117352591431182},
{-0.1609083128653913,0.7193461826668687,0.2062186670737696},
{0.13225437748425045,0.7035756786484657,0.240745269037405},
{0.13013794531226247,0.6924070499513939,0.2985399768918802},
{0.09831979072661877,0.6889676812508473,0.3378952306163282},
{0.04291355801360702,0.6872775089029722,0.3611566796645218},
{-0.021832003037295416,0.6861695883918866,0.37158462366982414},
{-0.08657756408819785,0.6872775089029722,0.3611566796645218},
{-0.1419837968012096,0.6889676812508473,0.3378952306163282},
{-0.1759183835588413,0.7035756786484657,0.240745269037405},
{-0.17002707781693727,0.7166155458133895,0.20224763854054495},
{-0.18748464765664716,0.6680356833393207,0.19022715587951203},
{-0.18497124576818968,0.680488638877603,0.1560458221544605},
{-0.17816662121522436,0.6636233061386518,0.13423711806642688},
{-0.021832003037295416,0.6867178903311801,0.33204164698275285},
{-0.14951068878128965,0.8963618357885618,0.11164556928319785},
{0.10224999062494661,0.8429182621824103,0.13872072348341036},
{0.10070582502577861,0.8577636869677437,0.14826463878529486},
{0.10406398024604133,0.841380087741624,0.15468538541232818},
{0.09902608173138264,0.8877385618246495,0.23155416639577017},
{0.09696534514286803,0.9133316809570586,0.2666525911427158},
{0.06993634505166929,0.9160581018101951,0.29451236519616275},
{0.031352175600408365,0.9040851046267052,0.3162975484401797},
{-0.0036985417742394075,0.893956496645728,0.3331236058075183},
{-0.021832003037295416,0.8918700202656478,0.33527842577209943},
{-0.03996546430035142,0.893956496645728,0.3331238277022732},
{-0.0750161816749992,0.9040851046267052,0.3162977703349346},
{-0.11360035112626013,0.9160581018101951,0.29451236519616275},
{-0.14062935121745887,0.9133316809570586,0.2666525911427158},
{-0.14269008780597348,0.8877385618246495,0.23155416639577017},
{-0.14354970808635523,0.852982964473984,0.21255132148311792},
{-0.1480208873970658,0.8182417902823853,0.23213641823255945},
{-0.13411940289896623,0.7488149155879067,0.27402970416325595},
{-0.13672977279530366,0.7208524042629532,0.26960734169861766},
{-0.14881793335657312,0.7332032882139935,0.2211914594484007},
{-0.15762737701982474,0.7210756303863564,0.2153445326574715},
{-0.14241649157321384,0.7083075842961531,0.2701010575282123},
{-0.10274170940174734,0.7071077993565495,0.31722085251521026},
{-0.05898827974094232,0.7071685985193851,0.33799752409832506},
{0.09875248549862302,0.7083075842961531,0.2701010575282123},
{0.11396314905047904,0.7210756303863564,0.2153445326574715},
{0.10506539127478756,0.7553945388594299,0.18370611282327567},
{-0.1305140569217739,0.8659775651089135,0.165070281835185},
{0.10139747097672079,0.9074190733186867,0.10079979745446775},
{0.0763100499906693,0.8863204324462497,0.11613694101660194},
{-0.14506147705131162,0.9074190733186867,0.10079979745446775},
{-0.11997405606526014,0.8863204324462497,0.11613694101660194},
{-0.10704713333056705,0.9010089776398874,0.09062326020643757},
{0.06338312725597622,0.9010089776398874,0.09062348210119245},
{0.10515392728198229,0.7332032882139935,0.22119168134315556},
{0.03393037075728906,0.8477557897334178,0.06309277796922365},
{0.030785012606950483,0.9112835923695719,0.07368403651411329},
{-0.021832003037295416,0.8478926987971751,0.0477620693549808},
{-0.021832003037295416,0.7912538407208384,0.04584578625188916},
{0.035490068989298226,0.7900746919934379,0.0650907183421089},
{-0.07915407506388907,0.7900746919934379,0.0650907183421089},
{-0.07759437683187989,0.8477557897334178,0.06309277796922365},
{-0.07444901868154132,0.9112835923695719,0.07368403651411329},
{-0.107004973327141,0.934089935275519,0.11323522330711498},
{-0.0701708878075711,0.9604275113105304,0.09887241961363243},
{-0.06456715766798377,0.9797680800401007,0.16027824270892668},
{-0.07244619662404883,0.979352027374712,0.19408413050873144},
{-0.06670711068398837,0.9771100027714654,0.21491006272742827},
{-0.0543768629451514,0.9745437899313479,0.2275662738611751},
{-0.03973092154444964,0.9725059085025852,0.24108432422285245},
{-0.021832003037295416,0.9695904333182962,0.2459127540889101},
{-0.003933084530141198,0.9725059085025852,0.24108432422285245},
{0.010712856870560564,0.9745437899313479,0.2275662738611751},
{0.02304310460939754,0.9771100027714654,0.21491006272742827},
{0.028782190549457996,0.979352027374712,0.19408413050873144},
{0.02090315159339294,0.9797680800401007,0.16027824270892668},
{0.026506881732980273,0.9604275113105304,0.09887241961363243},
{0.06334096725255017,0.934089935275519,0.11323522330711498},
{-0.021832003037295416,0.916009063069368,0.05629503215365946},
{-0.021832003037295416,0.9627376576035231,0.0838909733435612},
{-0.049682457511037614,0.9808950835001058,0.13853743841588448},
{-0.021832003037295416,0.9845499120076348,0.1759961576704246},
{0.00601845143644678,0.9808950835001058,0.13853743841588448},
{-0.0014012653770291569,0.8455308510262964,0.293994240943532},
{0.037130315017326644,0.8679670734811137,0.31372689770496476},
{0.017130053181515885,0.838328591072597,0.2747899155934542},
{0.04361252649146003,0.8364817610277809,0.26794202156328845},
{0.06448505660868038,0.8394167629504989,0.2589426359898647},
{0.08755789511523104,0.8421278730655491,0.250643994052333},
{0.09726290600915403,0.8520081808158226,0.23404804154579875},
{-0.04226296259231656,0.8455308510262964,0.293994240943532},
{-0.08079432109191748,0.8679670734811137,0.3137271195997196},
{-0.05226043077316344,0.8484323468410285,0.27809570365156666},
{-0.07593504785493232,0.8608706573254891,0.2830566046862841},
{-0.09673923438765147,0.8704185667329615,0.27216867285412794},
{-0.11016542032081102,0.8794479080982932,0.2935269305897674},
{-0.08183966728212876,0.8821863112681929,0.32328035448130876},
{-0.04047271570999333,0.8531795632268023,0.3200413567444134},
{-0.021832003037295416,0.8503319878375046,0.3242023271878101},
{-0.021832003037295416,0.8423233623445933,0.30762168541936225},
{-0.021832003037295416,0.8338225742853712,0.31698031860092696},
{-0.03144004592333848,0.8239256244284823,0.32750456492984464},
{-0.0031912903645975044,0.8531795632268023,0.3200413567444134},
{0.038175439312783055,0.8821863112681929,0.32328035448130876},
{0.06650141424622018,0.8794476862035383,0.2935269305897674},
{0.05307522831306064,0.8704183448382066,0.27216867285412794},
{0.032271041780341486,0.8608706573254891,0.2830566046862841},
{0.00859620280381773,0.8484323468410285,0.27809570365156666},
{0.011436677560959469,0.6003000904664916,0.37116923668870005},
{0.038909023372396406,0.611863469932484,0.34776111520753483},
{0.010621214336797614,0.6177272607247837,0.37756779384024597},
{-0.021832003037295416,0.5925639517325652,0.4072133768809186},
{-0.021832003037295416,0.6327817103692085,0.3813471053052595},
{0.0413969073640434,0.6394274582776839,0.35717255934075953},
{0.10247942980148629,0.6387806350672263,0.3281757965633384},
{0.02827649240310021,0.604815204938667,0.31012687720188936},
{-0.021832003037295416,0.5920702359029708,0.3212045290494628},
{-0.021832003037295416,0.5869480173814597,0.3686201097447079},
{-0.055100683635550304,0.6003000904664916,0.37116923668870005},
{-0.054285220411388446,0.6177272607247837,0.37756779384024597},
{-0.08506091343863424,0.6394274582776839,0.35717255934075953},
{-0.021832003037295416,0.670302782049868,0.36785235389284393},
{-0.021832003037295416,0.9815909454513905,0.13095440706282127},
{-0.0270798139900649,0.800070163121491,0.3290593814772466},
{-0.021832003037295416,0.8041055411336291,0.33373248501489244},
{-0.037513971048503764,0.8055232267225191,0.31976886998542814},
{-0.02895637793203409,0.8073647312932182,0.3235832408217118},
{-0.03202806702375451,0.8005203875791304,0.32817845930039685},
{-0.033095824584208074,0.8046809142330174,0.33139082966670746},
{-0.021832003037295416,0.8251609125288657,0.32961145562737304},
{-0.002214065864132523,0.8677056814598723,0.33716408739901843},
{0.07165203529635485,0.8956258108866448,0.30040100820100823},
{0.08523177239988718,0.8803985052281731,0.2750715000373892},
{0.06707678734560839,0.8699581351165978,0.2597259244745699},
{-0.09887164298199036,0.7180540895092375,0.311920008716026},
{0.08934658873427014,0.8528513808843438,0.24498678727682108},
{0.08842550360678829,0.8666403647417221,0.2512706248400971},
{0.09467516937781374,0.8728851488281404,0.2451856049771881},
{0.09609396444047794,0.8931106338401483,0.27894245403616574},
{-0.133010594808861,0.8528513808843438,0.24498678727682108},
{-0.14092691208374486,0.8520081808158226,0.23404804154579875},
{-0.13122190118982188,0.8421278730655491,0.250643994052333},
{-0.11675147854022541,0.8445167919965224,0.24663502151602495},
{-0.10814906268327121,0.839416541055744,0.2589426359898647},
{-0.12502371500192716,0.8357073483332708,0.27211098021786073},
{-0.14408514012986612,0.83282094136187,0.2485286713541194},
{-0.13833939734715944,0.8728851488281404,0.2451856049771881},
{-0.1320895096813791,0.8666403647417221,0.2512706248400971},
{-0.11749771060086658,0.8640078053698973,0.25059584289052533},
{-0.1182991944554714,0.8528686886752239,0.24306761954191605},
{0.07463518838088055,0.8528686886752239,0.24306761954191605},
{0.07308747246563459,0.8445167919965224,0.24663502151602495},
{0.0738334826315209,0.8640078053698973,0.25059584289052533},
{-0.13975819240982365,0.8931108557349031,0.27894245403616574},
{-0.11531604137094568,0.8956258108866448,0.30040100820100823},
{-0.128895778474478,0.8803985052281731,0.2750715000373892},
{-0.11074079342019921,0.8699581351165978,0.2597259244745699},
{-0.06079405925610672,0.838328591072597,0.2747899155934542},
{-0.021832003037295416,0.8651760812543089,0.339172013035873},
{-0.041449940210458315,0.8677056814598723,0.33716408739901843},
{-0.08727675446080574,0.836481539133026,0.26794202156328845},
{-0.09860204085481848,0.6426833200159497,0.30996689108362524},
{-0.06227565053440025,0.6419441885874645,0.3263407269405306},
{-0.09949383587465699,0.6820015173163337,0.31406351204810856},
{-0.09382420299287209,0.6436312544087714,0.30363113014770865},
{-0.09502154709017205,0.6824435316680426,0.30698839778895193},
{-0.09031027765468784,0.6866863812759879,0.3104646010188076},
{-0.0936892909819087,0.6863704031450474,0.3155222481666501},
{-0.06204177346276308,0.6812712616780435,0.33058135760092716},
{-0.021832003037295416,0.6417269536224429,0.3328049649395193},
{-0.021832003037295416,0.6810549142920413,0.3370327257041331},
{0.018611644459809413,0.6419441885874645,0.3263407269405306},
{0.018377767388172244,0.6812712616780435,0.33058135760092716},
{0.05493803478022765,0.6426833200159497,0.30996689108362524},
{0.055829829800066164,0.6820015173163337,0.31406351204810856},
{0.05135754101558121,0.6824435316680426,0.30698839778895193},
{0.05016019691828125,0.6436314763035261,0.30363113014770865},
{0.01693633906051091,0.6429007768757263,0.3176249228638358},
{0.01638914659499169,0.6820791804805397,0.3215378149712835},
{-0.021172975615319715,0.6427039562281529,0.3237893810489897},
{-0.02117208803630022,0.6818852444647797,0.3276594474687467},
{-0.06060034513510174,0.6429007768757263,0.3176249228638358},
{-0.06005315266958252,0.6820791804805397,0.3215378149712835},
{-0.065491127427279,0.6864260987285208,0.32086525196926047},
{-0.06691502606930529,0.685848284786829,0.3273299337577588},
{-0.054676420864231266,0.6863140418773094,0.32403879075346803},
{-0.05609743487444419,0.6857364498303725,0.3305034725419664},
{-0.027281960111755085,0.6855817891862254,0.3351151112325122},
{-0.01675638241430814,0.6861753576555133,0.32841477721433765},
{-0.016382267857590622,0.6855817891862254,0.3351151112325122},
{0.012433428799853359,0.6857364498303725,0.3305034725419664},
{0.02182712135268816,0.6864260987285208,0.32086525196926047},
{0.02325101999471445,0.685848284786829,0.3273299337577588},
{0.05002528490731787,0.6863704031450474,0.3155222481666501},
{0.04664627158009701,0.6866863812759879,0.3104646010188076},
{0.011012414789640433,0.6863140418773094,0.32403879075346803},
{-0.026907623660282695,0.6861753576555133,0.32841477721433765},
{0.11174220444894545,0.6731947363901406,0.22472801805158207},
{0.11012658873870805,0.6811418970359521,0.1948521082553503},
{0.10823848626948539,0.7011410493979885,0.20366310518188602},
{0.09139867142734466,0.6999947410943095,0.2039225001503337},
{0.09387657015502231,0.6801340510593143,0.19554308852202784},
{0.09208121969333699,0.6930438878978822,0.22926044031463788},
{0.09465497695512022,0.672320914845447,0.22484096248181296},
{0.0921118411695096,0.686355314301716,0.254760585544755},
{0.09299098818832029,0.6672963300160806,0.25281545612352974},
{0.11179057750550796,0.6678965553280148,0.2536795142990089},
{0.10914204171133222,0.6875812828223948,0.25497626724649247},
{0.10974426407606018,0.69412185261706,0.22921295483709486},
{0.1056645071129473,0.703869245409164,0.20981003368140486},
{0.09362494150299523,0.703018722813732,0.21016107118361546},
{0.09437139545839128,0.6987587873096613,0.22547713474403663},
{0.10697124532440014,0.6995294277933388,0.22544318484654094},
{0.09432191292805439,0.6962535955271343,0.23462962769832343},
{0.09408204469803562,0.6923846385811516,0.24892763812338284},
{0.10633618253595081,0.6932788744432938,0.24922830551623704},
{0.10704003269841106,0.6970242360108114,0.23459545590607284},
{-0.15379059481329888,0.6811418970359521,0.1948521082553503},
{-0.1554062105235363,0.6731947363901406,0.22472801805158207},
{-0.1519024923440762,0.7011410493979885,0.20366310518188602},
{-0.13506267750193549,0.6999947410943095,0.2039225001503337},
{-0.13728894757758606,0.703018722813732,0.21016107118361546},
{-0.14932851318753815,0.703869245409164,0.20981003368140486},
{-0.15340827015065103,0.69412185261706,0.22921295483709486},
{-0.15545458358009878,0.6678963334332599,0.2536795142990089},
{-0.15280626968067793,0.6875812828223948,0.25497626724649247},
{-0.13577584724410044,0.686355314301716,0.254760585544755},
{-0.1366549942629111,0.6672963300160806,0.25281545612352974},
{-0.13831898302971105,0.672320914845447,0.22484096248181296},
{-0.13574522576792783,0.6930438878978822,0.22926044031463788},
{-0.13754057622961313,0.6801340510593143,0.19554308852202784},
{-0.13774605077262647,0.6923846385811516,0.24892763812338284},
{-0.15000018861054165,0.6932786525485389,0.24922830551623704},
{-0.13798591900264523,0.6962533736323794,0.23462962769832343},
{-0.15063525139899098,0.6995294277933388,0.22544318484654094},
{-0.1380354015329821,0.6987587873096613,0.22547713474403663},
{-0.1507040387730019,0.6970240141160565,0.23459545590607284},
{0.06473446631315873,0.6985810496110073,0.3042173760900857},
{0.06198053051041784,0.6845948013165459,0.29742096164305076},
{0.06194924334998061,0.6984323801252419,0.3086120017103648},
{0.06665341215330885,0.7063038746596412,0.3097793900157568},
{0.06304540343905804,0.6981570087344432,0.3136263793810068},
{0.05639211110891681,0.6836692782939665,0.3062432752020851},
{0.05479402508431445,0.65453249992622,0.27888786792646675},
{0.07336240006692345,0.6532901111936805,0.2747388797998332},
{0.07213798480952886,0.6843555987707917,0.29506643639908303},
{0.0697648204061517,0.6985158125530743,0.30301670357146265},
{0.0741019752849184,0.6982746129545265,0.3057136124222009},
{0.07520989579600415,0.6979990196689729,0.31072799009284297},
{0.07243110778071737,0.6978503501832073,0.31512261571312206},
{0.06738899326571608,0.6979158091358951,0.31632306633699026},
{0.058656103292895966,0.6821208966944559,0.31636544823517115},
{0.044446185085521554,0.6546847197280634,0.29492020775562106},
{-0.10839847238774956,0.6985810496110073,0.3042173760900857},
{-0.10561324942457144,0.6984323801252419,0.3086120017103648},
{-0.10564453658500868,0.6845948013165459,0.29742096164305076},
{-0.11580199088411969,0.6843555987707917,0.29506643639908303},
{-0.11702640614151429,0.6532901111936805,0.2747388797998332},
{-0.09845803115890528,0.65453249992622,0.27888786792646675},
{-0.10005611718350764,0.6836690563992116,0.3062432752020851},
{-0.10670940951364888,0.6981570087344432,0.3136263793810068},
{-0.11031741822789969,0.7063038746596412,0.3097793900157568},
{-0.11342882648074254,0.6985158125530743,0.30301670357146265},
{-0.12461298781065545,0.6830916862470297,0.3005589972664785},
{-0.13296111227852409,0.6516853683264319,0.28490365662585504},
{-0.08811019116011239,0.6546847197280634,0.29492020775562106},
{-0.1023201093674868,0.6821208966944559,0.31636544823517115},
{-0.11105299934030692,0.6979158091358951,0.31632306633699026},
{-0.11609511385530821,0.6978503501832073,0.31512261571312206},
{-0.11887390187059498,0.6979990196689729,0.31072799009284297},
{-0.11776598135950922,0.6982746129545265,0.3057136124222009},
{-0.12692335599840324,0.681543304647519,0.3106811702995646},
{-0.13692592775861226,0.6506579956113655,0.3034276526574893},
{0.08094898173606462,0.6830916862470297,0.3005589972664785},
{0.08325934992381243,0.681543304647519,0.3106811702995646},
{0.0776802501020161,0.6806177816249396,0.31950348385859895},
{0.0674764197991364,0.6808569841706938,0.3218580091025667},
{0.0483821542474761,0.653657568907752,0.31344420378725535},
{0.08929710620393325,0.6516853683264319,0.28490365662585504},
{0.0932619216840214,0.6506579956113655,0.3034276526574893},
{0.08290809052684692,0.650810215413209,0.3194599924866436},
{0.06431220059463355,0.6520526041457484,0.32360898061327714},
{-0.12134425617660693,0.6806177816249396,0.31950348385859895},
{-0.12657209660143776,0.650810215413209,0.3194599924866436},
{-0.11114042587372724,0.6808569841706938,0.3218580091025667},
{-0.10797620666922438,0.6520526041457484,0.32360898061327714},
{-0.09204616032206693,0.653657568907752,0.31344420378725535},
{0.08365920427209532,0.7438469139210334,0.2825810842265892},
{0.07855029943587695,0.7117118936254295,0.274450416618497},
{0.08319699749769284,0.7429307104781587,0.2934221962654669},
{0.08816854948064422,0.7798318082137006,0.290807388474032},
{0.0902295079639137,0.743435521045497,0.3016260891426674},
{0.07785443748459217,0.7093198681678882,0.2910126411222904},
{0.06742804674257388,0.6588035301680342,0.2587904161880212},
{0.08578872823462085,0.658999241341833,0.24229476011068996},
{0.0906863892641992,0.7134937085070677,0.2634044957208706},
{0.0913172360523059,0.7456473679620808,0.2754531590157725},
{0.10169836026432988,0.747277406831385,0.2762140361302354},
{0.1087499536794699,0.7477822173987233,0.2844179290074359},
{0.10832680038192523,0.7468660139558487,0.2952590410463137},
{0.1006496856527955,0.7450655599148013,0.3023867443623754},
{0.08905146871028775,0.7077186756167175,0.3033897086544058},
{0.06608602726509609,0.6570463456041872,0.28338168050217444},
{-0.12732321034668617,0.7438469139210334,0.2825810842265892},
{-0.12686100357228366,0.7429307104781587,0.2934221962654669},
{-0.12221430551046777,0.7117118936254295,0.274450416618497},
{-0.13435039533879004,0.7134937085070677,0.2634044957208706},
{-0.12945273430921167,0.658999241341833,0.24229476011068996},
{-0.11109205281716474,0.6588035301680342,0.2587904161880212},
{-0.12151844355918302,0.7093198681678882,0.2910126411222904},
{-0.13389351403850452,0.743435521045497,0.3016260891426674},
{-0.13183255555523504,0.7798318082137006,0.290807388474032},
{-0.13498124212689674,0.7456473679620808,0.2754531590157725},
{-0.15085648046960032,0.7136212979911202,0.2643459951658009},
{-0.1540888213638495,0.657518537642559,0.24355734126592288},
{-0.10975003333968693,0.6570463456041872,0.28338168050217444},
{-0.13271547478487858,0.7077186756167175,0.3033897086544058},
{-0.14431369172738634,0.7450655599148013,0.3023867443623754},
{-0.15199080645651605,0.7468660139558487,0.2952590410463137},
{-0.15241395975406072,0.7477822173987233,0.2844179290074359},
{-0.14536236633892072,0.747277406831385,0.2762140361302354},
{-0.16210765401548516,0.7120201054399496,0.2767228408031614},
{-0.17056472880799692,0.6552290275617694,0.2618390282252347},
{0.10719247439500947,0.7136212979911202,0.2643459951658009},
{0.1184436479408943,0.7120201054399496,0.2767228408031614},
{0.11780725378391575,0.7096280799824081,0.29328528720170965},
{0.10561702163540426,0.7078462651007701,0.3043309862045812},
{0.08254995239248032,0.6547566136286427,0.30166336746148625},
{0.11042481528925865,0.6575187595373139,0.24355734126592288},
{0.12690072273340608,0.6552292494565243,0.2618390282252347},
{0.12555515293985028,0.6534718429979223,0.28643029253938795},
{0.10718248913104016,0.6532761318241235,0.3029259486167192},
{-0.1614712598585066,0.7096280799824081,0.29328528720170965},
{-0.16921915901444112,0.6534718429979223,0.28643029253938795},
{-0.1492810277099951,0.7078462651007701,0.3043309862045812},
{-0.15084649520563098,0.6532761318241235,0.3029259486167192},
{-0.12621395846707117,0.6547566136286427,0.30166336746148625},
{-0.1013806069753504,0.6869741787730594,0.285108021695094},
{-0.10389667160086638,0.6822456015466951,0.27963365619759817},
{-0.09980360095246105,0.6880141994891539,0.2816087414107314},
{-0.09579751304796634,0.6966026359765509,0.28341407713638606},
{-0.09837016083597519,0.6978978356607505,0.27669110985321443},
{-0.10124835770144551,0.6891951233745931,0.27801293690799866},
{-0.10486257946883279,0.6898250825836802,0.2764270550949144},
{-0.1085302778721447,0.68953506613906,0.2777801693101359},
{-0.1101092809478279,0.6884948235282109,0.28127944959449847},
{-0.10867317809428353,0.6873138996427716,0.2848752540972312},
{-0.10505718116885726,0.6866841623284392,0.2864611359103154},
{-0.09866794359701607,0.6957853975943502,0.2900540557812349},
{-0.08583687939642853,0.7189842723216692,0.28461763428682246},
{-0.0905015509333892,0.7205934530840152,0.2725341335154054},
{-0.10205339187212828,0.720315862745668,0.26719024213377546},
{-0.10485836346849017,0.6989123384800341,0.27382356393597806},
{-0.1114572915836873,0.6990519102808499,0.2764909607843181},
{-0.11432306234288465,0.6982346718986491,0.28313093942916684},
{-0.11178014845202892,0.6969394722144496,0.28985390671233857},
{-0.10529660560936628,0.6959249693951659,0.2927214526295749},
{-0.09083816527653302,0.7164313731668441,0.2963623017675471},
{0.05771660090075956,0.6869741787730594,0.285108021695094},
{0.056139594877870215,0.6880141994891539,0.2816087414107314},
{0.06023266552627554,0.68224582344145,0.27963365619759817},
{0.06139317509426643,0.6866841623284392,0.2864611359103154},
{0.0650091720196927,0.6873141215375265,0.2848752540972312},
{0.06644527487323706,0.6884948235282109,0.28127944959449847},
{0.06486627179755386,0.68953506613906,0.2777801693101359},
{0.06119835149948708,0.6898250825836802,0.2764270550949144},
{0.05758412973209979,0.6891951233745931,0.27801293690799866},
{0.054705932866629475,0.6978978356607505,0.27669110985321443},
{0.0521335069733755,0.6966026359765509,0.28341407713638606},
{0.05500371562767035,0.6957853975943502,0.2900540557812349},
{0.06163259953477544,0.6959249693951659,0.2927214526295749},
{0.0681159204826832,0.6969394722144496,0.28985390671233857},
{0.07065883437353894,0.698234893793404,0.28313093942916684},
{0.06779328550909645,0.6990519102808499,0.2764909607843181},
{0.06119435739389934,0.6989123384800341,0.27382356393597806},
{0.05838938579753744,0.720315862745668,0.26719024213377546},
{0.04683754485879837,0.7205934530840152,0.2725341335154054},
{0.042172873321837695,0.7189842723216692,0.28461763428682246},
{0.047174159201942185,0.7164313731668441,0.2963623017675471},
{0.058961430475602546,0.714429882477881,0.3008885109774664},
{0.07051393709860623,0.7141525140342884,0.2955446195958365},
{0.07508807557557834,0.7157614729018796,0.2834608969296645},
{0.07006548779900594,0.7183145939514595,0.2717162294489399},
{-0.10262543655019338,0.714429882477881,0.3008885109774664},
{-0.11417794317319706,0.7141525140342884,0.2955446195958365},
{-0.11875208165016919,0.7157614729018796,0.2834608969296645},
{-0.11372949387359678,0.7183145939514595,0.2717162294489399},
{-0.09338906737856423,0.6864467349407241,0.29812081769992327},
{-0.0900479980544268,0.6865117501039021,0.29305385097237613},
{-0.06675770268809963,0.6860801648056722,0.3099342725546588},
{-0.06178370986284464,0.6904000118935587,0.3135205355829319},
{-0.059833920651767035,0.6902739756727904,0.30444193358201815},
{-0.0653624284694521,0.6859898536404385,0.3034445166588597},
{-0.09454292010390888,0.6910037875215709,0.2899062738744888},
{-0.09894997183046088,0.6909130325668275,0.296994479924183},
{-0.06153718479017966,0.712276615776584,0.31282156710507897},
{-0.021832003037295416,0.7120074574389218,0.31928380805127365},
{-0.021832003037295416,0.6901308535558967,0.319969906633344},
{-0.05596962349563679,0.6859532410058843,0.3131073675493566},
{-0.05457279601370512,0.6858631517354055,0.3066176116535575},
{-0.02688743123758916,0.6856725441409687,0.3109916010616332},
{-0.02117097856252585,0.6900072581774319,0.310560681447668},
{-0.05990758971038519,0.7119775016470138,0.304058499445596},
{-0.09249460962166724,0.7123005804101104,0.2900493959913825},
{-0.027256220320189706,0.6857610801481636,0.3177176748713732},
{-0.01640778575440113,0.6857610801481636,0.3177176748713732},
{-0.016776796731756548,0.6856725441409687,0.3109916010616332},
{0.012305617421045951,0.6859532410058843,0.3131073675493566},
{0.018119703788253814,0.6904000118935587,0.3135205355829319},
{0.016169914577176203,0.6902739756727904,0.30444193358201815},
{0.010908789939114281,0.6858631517354055,0.3066176116535575},
{0.017873178715588828,0.712276615776584,0.31282156710507897},
{0.053478632977421524,0.7127698878166687,0.29643841166846885},
{0.05528596575587004,0.6909130325668275,0.296994479924183},
{0.023093474718753934,0.6860801648056722,0.3099342725546588},
{0.021698422394861257,0.6859898536404385,0.3034445166588597},
{0.046383770085081086,0.6865117501039021,0.29305385097237613},
{0.050878914029318045,0.6910037875215709,0.2899062738744888},
{0.01624358363579436,0.7119775016470138,0.304058499445596},
{-0.02116942529924173,0.7117105622569003,0.3102205167884462},
{0.04972506130397339,0.6864467349407241,0.29812081769992327},
{-0.09714263905201236,0.7127698878166687,0.29643841166846885},
{0.04883038165232153,0.7123005804101104,0.2900493959913825},
{0.09345563580502639,0.706916526077848,0.21854891481260655},
{0.0827973650441648,0.7074659374909162,0.21413609382242782},
{0.09511008309736675,0.7262411183850678,0.22005846483001418},
{0.08532119598610138,0.7012213752992529,0.2431104452296067},
{0.08557748442798083,0.7218216405522427,0.24747356179469363},
{0.07632647020252999,0.6950058813204779,0.2671414252877032},
{0.07509340104969531,0.7148008905080301,0.2755197274422347},
{0.06578558176699674,0.6954589904099304,0.2622355541521945},
{0.06517869961241642,0.7151317355875473,0.27038020112984373},
{0.07436270162189532,0.7015901643818533,0.23824384946571067},
{0.07514266168527733,0.7220135795152087,0.24271835719774437},
{0.08326467539792941,0.7261328337446891,0.21581650280108844},
{0.07651596832319235,0.6920817522407487,0.26065366644469795},
{0.06905963887516221,0.6924336773219788,0.25700549477981494},
{0.08228478816040592,0.695944052344085,0.24605853894286228},
{0.07443215468017086,0.6962076633128752,0.24257945108119325},
{0.08533961325075592,0.6981472453652288,0.23735005739307832},
{0.07748742356003062,0.6984110782287739,0.23387119142616422},
{0.08988557109385903,0.7014026633139848,0.22333451899097356},
{0.082136784358905,0.7018127248209919,0.22029056674361236},
{-0.13877408917195758,0.7262411183850678,0.22005846483001418},
{-0.1269289033672751,0.7261328337446891,0.21581650280108844},
{-0.12646137111875566,0.7074659374909162,0.21413609382242782},
{-0.11880688965462304,0.7220135795152087,0.24271835719774437},
{-0.11802670769648614,0.7015901643818533,0.23824384946571067},
{-0.10884270568700724,0.7151317355875473,0.27038020112984373},
{-0.10944958784158758,0.6954589904099304,0.2622355541521945},
{-0.11875740712428615,0.7148008905080301,0.2755197274422347},
{-0.1199906981718757,0.6950058813204779,0.2671414252877032},
{-0.12924149050257167,0.7218216405522427,0.24747356179469363},
{-0.12898520206069222,0.7012213752992529,0.2431104452296067},
{-0.13711964187961723,0.706916526077848,0.2185486929178517},
{-0.13354957716844987,0.7014026633139848,0.22333451899097356},
{-0.12580079043349582,0.7018127248209919,0.22029056674361236},
{-0.12115142963462146,0.6984110782287739,0.23387119142616422},
{-0.12594901612975165,0.695944052344085,0.24605853894286228},
{-0.1180961607547617,0.6962076633128752,0.24257945108119325},
{-0.11272364494975305,0.6924336773219788,0.25700549477981494},
{-0.1201799743977832,0.6920817522407487,0.26065366644469795},
{-0.12900361932534676,0.6981472453652288,0.23735005739307832},
{-0.12823897000005105,0.863506767013392,0.25918228232512863},
{-0.12175320820983969,0.8876016527608922,0.2631353373832085},
{-0.12987766276479534,0.8655947966567561,0.2463310257018476},
{-0.12362599994097602,0.840534668725554,0.24220799926153422},
{-0.12220032614091071,0.8392967178881121,0.25522035147685385},
{-0.10608300062063963,0.8220741345938137,0.23916027480334023},
{-0.10525511129020484,0.8214597080175677,0.2523110893457011},
{-0.08194950518579137,0.8151596721371859,0.23800509070946632},
{-0.08194395781691953,0.8147744628427246,0.25123401220554287},
{-0.05769219247772344,0.8216700642451883,0.2390914874293293},
{-0.058512981176002274,0.8210325606144354,0.25227780513247006},
{-0.03981035986669452,0.839812845087949,0.24207819082993298},
{-0.04124069345661215,0.8385569207753624,0.2551626588405866},
{-0.033095824584208074,0.8647580315361262,0.2461705957940737},
{-0.03475493166640077,0.8626522503123724,0.25911571389866644},
{-0.03934770930278228,0.8898217097834062,0.2502723203379191},
{-0.03475493166640077,0.8668762388661533,0.23317488568536965},
{-0.04124069345661215,0.8427813531186531,0.2292202773640057},
{-0.058512981176002274,0.8252541083259127,0.22635339713103395},
{-0.0819441797116744,0.8189904631853301,0.22534222273307328},
{-0.10525533318495972,0.8256694953070367,0.22645813145533447},
{-0.12220032614091071,0.8435009578087095,0.2294017872734926},
{-0.12823897000005105,0.867707456617911,0.23338457622872555},
{-0.12175320820983969,0.8918023423654112,0.2373391845500895},
{-0.1231631274823089,0.8905399831049333,0.2504252058240272},
{-0.10448069859569468,0.9051262348165741,0.26602019109132496},
{-0.10211308156118938,0.8988013467236463,0.277371439171658},
{-0.11759933839859887,0.8830892010257749,0.2747848120140921},
{-0.12341409045007137,0.8614859714807547,0.27124070898924496},
{-0.11800008032590127,0.8397802265589824,0.26768839585846754},
{-0.10280739024919004,0.8237878277857056,0.265080023014924},
{-0.08190734518236532,0.8177940066670497,0.2641143370417125},
{-0.06089968115942673,0.8234048374387931,0.265050067223016},
{-0.0454136462167721,0.8391169831366643,0.26763669438058185},
{-0.03959867227054475,0.8607202126816845,0.271180797405429},
{-0.040793575525541095,0.8868618556481422,0.26307764474694123},
{-0.05689048672836378,0.9082553946498066,0.25328476353008816},
{-0.057738790376246976,0.9046990874134416,0.2659869068780939},
{-0.08102398216321204,0.9151698571064346,0.25443994762396205},
{-0.08104972195477743,0.9113841106935298,0.2670639840182522},
{-0.10528151676603485,0.9086856485795073,0.2533932700652215},
{-0.10448069859569468,0.9093295871581516,0.24020628667781618},
{-0.08104972195477743,0.9155930104039792,0.2412170172862671},
{-0.057738790376246976,0.9089142001770275,0.24010133045876075},
{-0.040793575525541095,0.8910827376753551,0.2371576746406026},
{-0.03959867227054475,0.868901472293888,0.2211248910219385},
{-0.0454136462167721,0.8472984646436225,0.21757923473380728},
{-0.060899903054181616,0.8315838781034478,0.21500880589334717},
{-0.08190734518236532,0.8259681656470971,0.21410258771444185},
{-0.10280739024919004,0.8319562175021263,0.21510288926941376},
{-0.11799985843114641,0.8479437345907961,0.21774210548388478},
{-0.12341409045007137,0.8696463729859999,0.22131305777407165},
{-0.11759911650384403,0.8912493806362655,0.2248587140622029},
{-0.10211308156118938,0.906964189071195,0.227429142902663},
{-0.11573209403633437,0.8597188016529382,0.2815927649883805},
{-0.11098421196629599,0.8773576595073802,0.28448671638144685},
{-0.11131150672973507,0.8419960675811541,0.27869237864742274},
{-0.09890670235326045,0.8289382269410853,0.27656263279014237},
{-0.0818418862296775,0.8240443381223398,0.27577424072607515},
{-0.06468919978316447,0.8286255772314679,0.27653822436710623},
{-0.05204497096618081,0.8414544224845066,0.27865021864399675},
{-0.04729686700138752,0.8590932803389486,0.2815439481423082},
{-0.045012682394714836,0.8824259576034568,0.2747331105362064},
{-0.06020537247142607,0.8984183563767337,0.27734148337975},
{-0.08110541753825078,0.9044121774953895,0.27830716935296157},
{-0.08118729670279927,0.894767743869547,0.28736247240461354},
{-0.09833976125455746,0.8901865047604189,0.28659848876358246},
{-0.10571620859083296,0.8583248588028201,0.2895332687915456},
{-0.10235894094958974,0.8707975629742861,0.29157958222099345},
{-0.1025903771789233,0.8457931306265575,0.2874825174670004},
{-0.09381887751875512,0.8365598679814965,0.28597651776567073},
{-0.0817522407487084,0.833099419279237,0.28541889624667244},
{-0.06962347344729701,0.8363386389108871,0.2859592099747905},
{-0.06068266808915998,0.8454101402796451,0.28745256167509237},
{-0.057325178553161896,0.8578826225563563,0.28949865320978535},
{-0.051717676202741696,0.8768160144107329,0.2844443344832659},
{-0.06412225868446146,0.8898736331560467,0.2865740803405463},
{-0.06922250962523974,0.8796478352724346,0.2930556261304151},
{-0.08128936829004131,0.8831082839746942,0.2936132476494134},
{-0.0934181355914527,0.879868842448289,0.2930729339212953},
{-0.09404920427431429,0.8573995576749955,0.29452101909160283},
{-0.09231132455414133,0.8638558074628087,0.2955803446513712},
{-0.09243114772177327,0.8509126864110098,0.2934594745842857},
{-0.08789073724754203,0.8461332952857794,0.29267995831041344},
{-0.08164439989783966,0.8443419389296817,0.29239149512907725},
{-0.07536610970343545,0.8460187975922644,0.2926710825202185},
{-0.07073805080102898,0.8507143125001526,0.2934439419514446},
{-0.06900017108085603,0.8571707841827204,0.2945032675112129},
{-0.060451009965071564,0.8704145726273735,0.29154962642908544},
{-0.07061822763339703,0.8636576554467064,0.29556481201852997},
{-0.07515863810762828,0.8684370465719368,0.2963443282924022},
{-0.08140475356257577,0.8702284029280343,0.2966330133684933},
{-0.08768304375698,0.8685515442654518,0.29635320408259724},
{-0.08152590809873697,0.857005916379849,0.29621629501884},
{-0.0043165186665634235,0.8898217097834062,0.2502723203379191},
{-0.0028704305490497377,0.8910827376753551,0.2371576746406026},
{-0.010568181490382762,0.8647580315361262,0.2461705957940737},
{-0.0028704305490497377,0.8868618556481422,0.26307764474694123},
{-0.00890907440819006,0.8626522503123724,0.25911571389866644},
{-0.003853646207896316,0.839812845087949,0.24207819082993298},
{-0.00242331261797868,0.8385569207753624,0.2551626588405866},
{0.014028186403132609,0.8216700642451883,0.2390914874293293},
{0.014848975101411439,0.8210325606144354,0.25227780513247006},
{0.03828549911120054,0.8151596721371859,0.23800509070946632},
{0.0382799517423287,0.8147744628427246,0.25123401220554287},
{0.0624189945460488,0.8220741345938137,0.23916027480334023},
{0.06159110521561401,0.8214597080175677,0.2523110893457011},
{0.07996199386638518,0.840534890620309,0.24220799926153422},
{0.07853632006631989,0.839296939782867,0.25522035147685385},
{0.0862136566902045,0.865595018551511,0.24633124759660244},
{0.08457496392546021,0.863506767013392,0.25918228232512863},
{0.07949912140771806,0.8905399831049333,0.2504252058240272},
{0.07808920213524884,0.8876016527608922,0.2631353373832085},
{0.061617510691444013,0.9086856485795073,0.2533932700652215},
{0.060816692521103846,0.9051262348165741,0.26602019109132496},
{0.037359976088621204,0.9151698571064346,0.25443994762396205},
{0.03738571588018659,0.9113841106935298,0.2670639840182522},
{0.01322648065377294,0.9082553946498066,0.25328476353008816},
{0.014074784301656141,0.9046993093081963,0.2659869068780939},
{0.014074562406901267,0.9089144220717824,0.24010133045876075},
{0.03738571588018659,0.9155930104039792,0.2412170172862671},
{0.060816692521103846,0.9093295871581516,0.24020628667781618},
{0.07808920213524884,0.8918021204706565,0.2373391845500895},
{0.08457496392546021,0.867707456617911,0.23338457622872555},
{0.07853632006631989,0.8435009578087095,0.2294017872734926},
{0.06159110521561401,0.8256694953070367,0.22645813145533447},
{0.0382799517423287,0.8189904631853301,0.22534222273307328},
{0.014848975101411439,0.8252541083259127,0.22635339713103395},
{-0.00242331261797868,0.8427813531186531,0.2292202773640057},
{-0.00890907440819006,0.8668762388661533,0.23317488568536965},
{0.0013486763201240003,0.8906043325838467,0.2246958433121254},
{0.01654114450208036,0.9065916277777616,0.2273350595265964},
{-0.004065333804046087,0.868901472293888,0.2211248910219385},
{0.008053670128150864,0.8883920418777532,0.21370095820811996},
{0.020458252609870622,0.9014454446227245,0.21585577817270113},
{0.037523068733453575,0.9063348955463724,0.2166727946601471},
{0.037441411463659945,0.9125796796327906,0.22833536108156827},
{0.05844907548659854,0.906964189071195,0.227429142902663},
{0.07393511042925317,0.8912493806362655,0.2248587140622029},
{0.07975008437548052,0.8696463729859999,0.22131305777407165},
{0.07433585235655557,0.8479437345907961,0.21774210548388478},
{0.0591433841745992,0.8319562175021263,0.21510288926941376},
{0.038243339107774485,0.8259681656470971,0.21410258771444185},
{0.017235675084835898,0.8315838781034478,0.21500880589334717},
{0.0017496401421812683,0.8472984646436225,0.21757923473380728},
{0.0036328609267966857,0.8706717486482726,0.21078548302383082},
{0.016787225785235598,0.8845969758851437,0.20492235791579583},
{0.025558503550648908,0.8938271320036363,0.20644610919751538},
{0.03762536221545047,0.8972844741793277,0.20702370124445235},
{0.049754129516861874,0.8940423699158642,0.20650047341245953},
{0.05467575517996662,0.9017498842264116,0.2159327756526424},
{0.06731998399695027,0.8889188200258241,0.2138338731662895},
{0.07206808796174355,0.8712799621713821,0.21093903419420362},
{0.06764750065514424,0.8535598908366563,0.2080233371151596},
{0.055242696278669616,0.8405062661969303,0.20586851715057847},
{0.03817788015508666,0.835617037168037,0.20505150066313246},
{0.021025193708573624,0.840202048487998,0.20579174156539204},
{0.008380964891589977,0.8530331126885855,0.20789042215699008},
{0.013661172478571059,0.8720668009721653,0.20286073374826172},
{0.026954221558806203,0.8794776419954463,0.19895849258904802},
{0.031494632033037456,0.8842557017521475,0.19974710654787015},
{0.03774074748798494,0.8860452829502061,0.20004622067744027},
{0.044019037682389156,0.8843668710243393,0.19977528718173912},
{0.04864709658479563,0.8796704685374317,0.19900708754036542},
{0.05869471298024403,0.8849695371785772,0.2050164412918624},
{0.06205198062148726,0.8724968330071111,0.20296946217814996},
{0.058926371104332465,0.8599671018836423,0.2009078380106159},
{0.05015487144416428,0.8507365019756399,0.19938408672889632},
{0.03808823467411758,0.8472793816947034,0.19880649468195935},
{0.025959467372706175,0.8505214859581669,0.1993297225139522},
{0.017018662014569152,0.8595945405902088,0.20081375463454934},
{0.025336165006265187,0.87299165831048,0.19789117881810422},
{0.03786190202414613,0.8733830806580777,0.19621542962929597},
{0.05038519819972346,0.8732142187496186,0.1979475400858422},
{0.04876714164718244,0.8667282350646524,0.19688022631489838},
{0.04422673117295119,0.861950175307951,0.19609161235607628},
{0.03798039382324883,0.8601605941098924,0.19579249822650618},
{0.03170210362884462,0.8618390060357592,0.19606343172220728},
{0.027074044726438144,0.8665354085226669,0.196831631363581},
{0.0017496401421812683,0.8391169831366643,0.26763669438058185},
{-0.004065333804046087,0.8607202126816845,0.271180797405429},
{0.017235675084835898,0.8234048374387931,0.265050067223016},
{0.038243117213019616,0.8177940066670497,0.2641143370417125},
{0.0591433841745992,0.8237878277857056,0.265080023014924},
{0.07433607425131043,0.8397802265589824,0.26768839585846754},
{0.07975008437548052,0.8614859714807547,0.27124070898924496},
{0.07393511042925317,0.8830892010257749,0.2747848120140921},
{0.05844907548659854,0.8988013467236463,0.277371439171658},
{0.037441411463659945,0.9044121774953895,0.27830716935296157},
{0.016541366396835237,0.8984183563767337,0.27734148337975},
{0.0013486763201240003,0.8824259576034568,0.2747331105362064},
{0.008053670128150864,0.8768160144107329,0.2844443344832659},
{0.0036328609267966857,0.8590932803389486,0.2815439481423082},
{0.008380964891589977,0.8414544224845066,0.27865021864399675},
{0.021025193708573624,0.8286255772314679,0.27653822436710623},
{0.03817788015508666,0.8240443381223398,0.27577424072607515},
{0.055242696278669616,0.8289384488358402,0.27656263279014237},
{0.06764727876038938,0.8419960675811541,0.27869237864742274},
{0.07206786606698869,0.8597188016529382,0.2815927649883805},
{0.06731998399695027,0.8773576595073802,0.28448671638144685},
{0.05467575517996662,0.8901865047604189,0.28659848876358246},
{0.037523068733453575,0.894767743869547,0.28736247240461354},
{0.020458252609870622,0.8898736331560467,0.2865740803405463},
{0.017018440119814276,0.8454101402796451,0.28745256167509237},
{0.013661172478571059,0.8578826225563563,0.28949865320978535},
{0.025959467372706175,0.8363386389108871,0.2859592099747905},
{0.03808801277936271,0.833099419279237,0.28541889624667244},
{0.05015487144416428,0.8365598679814965,0.28597651776567073},
{0.05892614920957758,0.8457931306265575,0.2874825174670004},
{0.06205220251624212,0.8583248588028201,0.2895332687915456},
{0.058694934874998904,0.8707975629742861,0.29157958222099345},
{0.049753907622107005,0.879868842448289,0.2930729339212953},
{0.03762536221545047,0.8831082839746942,0.2936132476494134},
{0.025558503550648908,0.8796478352724346,0.2930556261304151},
{0.016787003890480726,0.8704145726273735,0.29154962642908544},
{0.026954221558806203,0.8636576554467064,0.29556481201852997},
{0.025336165006265187,0.8571707841827204,0.2945032675112129},
{0.027074044726438144,0.8507143125001526,0.2934439419514446},
{0.03170210362884462,0.8460187975922644,0.2926710825202185},
{0.03798039382324883,0.8443419389296817,0.29239149512907725},
{0.044226509278196324,0.8461332952857794,0.29267995831041344},
{0.04876691975242757,0.8509129083057647,0.2934594745842857},
{0.05038519819972346,0.8573995576749955,0.2945212409863577},
{0.04864709658479563,0.8638558074628087,0.2955803446513712},
{0.044019037682389156,0.8685517661602067,0.29635342597735204},
{0.03774074748798494,0.8702286248227892,0.2966330133684933},
{0.031494632033037456,0.8684372684666917,0.2963443282924022},
{0.03786190202414613,0.857005916379849,0.29621629501884},
{-0.11573209403633437,0.8712799621713821,0.21093903419420362},
{-0.1109839900715411,0.8889188200258241,0.2138338731662895},
{-0.09833976125455746,0.9017498842264116,0.2159327756526424},
{-0.08118707480804441,0.9063348955463724,0.2166727946601471},
{-0.08110541753825078,0.9125796796327906,0.22833536108156827},
{-0.06020537247142607,0.9065916277777616,0.2273350595265964},
{-0.045012682394714836,0.8906043325838467,0.2246958433121254},
{-0.04729686700138752,0.8706717486482726,0.21078548302383082},
{-0.05204497096618081,0.8530331126885855,0.20789020026223523},
{-0.06468919978316447,0.8402022703827529,0.20579174156539204},
{-0.0818418862296775,0.835617037168037,0.20505150066313246},
{-0.09890670235326045,0.8405062661969303,0.20586851715057847},
{-0.11131150672973507,0.8535598908366563,0.2080233371151596},
{-0.10571620859083296,0.8724968330071111,0.2029692402833951},
{-0.10235894094958974,0.8849695371785772,0.2050164412918624},
{-0.0934181355914527,0.8940423699158642,0.20650047341245953},
{-0.08128936829004131,0.8972844741793277,0.20702370124445235},
{-0.06922273151999461,0.8938271320036363,0.20644610919751538},
{-0.06412225868446146,0.9014454446227245,0.21585577817270113},
{-0.051717676202741696,0.8883920418777532,0.21370095820811996},
{-0.057325178553161896,0.8720668009721653,0.20286073374826172},
{-0.06068266808915998,0.8595945405902088,0.20081375463454934},
{-0.06962347344729701,0.8505214859581669,0.1993297225139522},
{-0.0817522407487084,0.8472793816947034,0.19880649468195935},
{-0.09381887751875512,0.8507365019756399,0.19938408672889632},
{-0.1025903771789233,0.8599668799888874,0.2009078380106159},
{-0.09404920427431429,0.8732142187496186,0.1979475400858422},
{-0.09231110265938647,0.8796704685374317,0.19900708754036542},
{-0.08768304375698,0.8843670929190942,0.19977528718173912},
{-0.08140475356257577,0.8860452829502061,0.20004622067744027},
{-0.07515863810762828,0.8842557017521475,0.19974710654787015},
{-0.07061822763339703,0.8794776419954463,0.19895849258904802},
{-0.06045123185982643,0.8845969758851437,0.20492235791579583},
{-0.06900017108085603,0.87299165831048,0.19789117881810422},
{-0.07073805080102898,0.8665354085226669,0.196831631363581},
{-0.07536633159819034,0.8618390060357592,0.19606343172220728},
{-0.08164439989783966,0.8601605941098924,0.19579249822650618},
{-0.08789073724754203,0.861950175307951,0.19609161235607628},
{-0.09243114772177327,0.8667282350646524,0.19688022631489838},
{-0.08152590809873697,0.8733830806580777,0.19621542962929597},
{-0.12749961667681098,0.807783890485175,0.11136842273436025},
{-0.12304840789403904,0.7893601908827438,0.09618749307965734},
{-0.13217715810955433,0.8139663221454737,0.10452629796782127},
{-0.14348491481793205,0.8234356808097206,0.12689817094372505},
{-0.15178045022889555,0.8204600721468606,0.12192706275028342},
{-0.1416034691913556,0.811937538401661,0.10179233269301904},
{-0.12723134591816834,0.7935105103779068,0.08722006035093544},
{-0.12574731379757118,0.7659718180347624,0.09002791657911069},
{-0.13092722495534925,0.7670520017014889,0.09887863266676888},
{-0.12878616246557026,0.7852427118113026,0.10366934042449798},
{-0.132248164431114,0.7995722312915537,0.11547680412085189},
{-0.1376765977143509,0.8163062023356197,0.13150315279162464},
{-0.1581248650602522,0.8193667966895963,0.14877965651135736},
{-0.16495633887855723,0.8167979211124204,0.14162044414010344},
{-0.16451565589537753,0.8075063001468277,0.13687810943893688},
{-0.15426766853627794,0.8103547631151449,0.12156093640474136},
{-0.1463522388404135,0.8037261011027946,0.10590071407951067},
{-0.1371522604085837,0.7935251554317283,0.08619224384635919},
{-0.13034896722414765,0.7675064421594708,0.08003022650350894},
{-0.13526238278132208,0.743886189292646,0.09454014641947295},
{-0.13825174891898423,0.7498742411476751,0.10238812010985565},
{-0.14682154624697197,0.7549489741916429,0.10150231624839876},
{-0.14053171752531432,0.7696870019156173,0.09838114462634144},
{-0.13870707695598564,0.7852662326553191,0.1025856064416935},
{-0.1416744755129153,0.7975434475477411,0.11274283884604965},
{-0.1401635941269784,0.8062008933039041,0.13113702644608258},
{-0.15085248636401258,0.8126442731959345,0.15119653418144466},
{-0.17217413146509786,0.8028493949262876,0.16430740766792828},
{-0.17760078959029577,0.8019323039043935,0.15559537580206634},
{-0.17435003143139202,0.7959442520493645,0.14774740211168363},
{-0.1656728370420453,0.7908732912162295,0.14861168218191775},
{-0.1572432771991379,0.8007837766531658,0.13929476521426934},
{-0.14845935143269676,0.8032252846410441,0.12616591825264095},
{-0.1428902368748698,0.7894214338350891,0.09377949119976497},
{-0.1399922913762157,0.7701212499509057,0.07980189680074362},
{-0.14087964850095672,0.743028787959813,0.08479874478575064},
{-0.14860979607650135,0.729020572084619,0.1085152999761907},
{-0.14852702933293332,0.7383119711554571,0.11325763467735726},
{-0.15559459917042429,0.7450347165438739,0.11084075700726993},
{-0.1628219332314245,0.7424658409666977,0.10368154463601606},
{-0.1524476877568016,0.7540431998022472,0.09267112689916948},
{-0.14505970189327264,0.7712289485672367,0.08892399017361269},
{-0.150411581486078,0.8033526522303417,0.1464541994802781},
{-0.16349671518099623,0.7977786559879076,0.16517146584340753},
{-0.18186826951603202,0.7783096101952651,0.16932111965430574},
{-0.18632546945718553,0.7798464532675223,0.16010760564242857},
{-0.1811360168249479,0.7787662696007958,0.15125711144952528},
{-0.1714891423568019,0.776149464756567,0.15161968747898935},
{-0.16712580389696008,0.7746126216843099,0.1608332014908665},
{-0.1602461789168474,0.7917906041328784,0.15732371404777973},
{-0.17222161694264088,0.7756928053510364,0.1696836956837698},
{-0.1852592651600161,0.7523228497677094,0.16247699783497285},
{-0.18932016106896465,0.7564583023142956,0.15394802914188194},
{-0.18338292311280177,0.7605755594909822,0.1464661817970413},
{-0.17336326545646746,0.7605573641210825,0.1475133031452916},
{-0.16929637838913728,0.7564219115744962,0.1560422718383825},
{-0.17518968118383516,0.7523046543978097,0.16352411918322318},
{-0.18128535199497808,0.7318521710515659,0.145609224253718},
{-0.18581577720524,0.7380346027118645,0.13876709948717902},
{-0.18062832162579626,0.7462460400107307,0.13465871810068739},
{-0.1709450564178509,0.7482750456492984,0.13739268337548963},
{-0.1664323827879789,0.7420923920942448,0.14423480814202863},
{-0.1715845571013977,0.7338809547953785,0.14834318952852024},
{-0.17079217093174273,0.722382590492564,0.12323735127781422},
{-0.17642097517863084,0.729512068966665,0.11863236942991465},
{-0.17325742165839259,0.7396173779983806,0.11899849577545671},
{-0.16451787484292626,0.7425932085559954,0.12396960396889836},
{-0.15895120112740288,0.7354637300818947,0.12857458581679793},
{-0.16205928095892264,0.7253584210501791,0.12820845947125586},
{-0.15581671582005313,0.726451696507443,0.1013560876049368},
{-0.1629581766109171,0.7331742200011049,0.09893920993484949},
{-0.14949382477991924,0.748071568159079,0.08425510263630939},
{0.08356733984357749,0.7935105103779068,0.08722006035093544},
{0.07938440181944821,0.7893601908827438,0.09618749307965734},
{0.0885131520349635,0.8139663221454737,0.10452629796782127},
{0.09793946311676477,0.811937538401661,0.10179233269301904},
{0.10811644415430471,0.8204600721468606,0.12192706275028342},
{0.09982090874334121,0.8234359027044753,0.12689817094372505},
{0.08383561060222014,0.807783890485175,0.11136842273436025},
{0.08512215639097943,0.7852427118113026,0.10366934042449798},
{0.0872632188807584,0.7670520017014889,0.09887863266676888},
{0.08208330772298035,0.7659718180347624,0.09002791657911069},
{0.08668496114955683,0.7675064421594708,0.08003022650350894},
{0.09348825433399287,0.7935251554317283,0.08619224384635919},
{0.10268823276582269,0.8037261011027946,0.10590071407951067},
{0.11060366246168708,0.8103547631151449,0.12156093640474136},
{0.1208516498207867,0.8075063001468277,0.13687810943893688},
{0.1212923328039664,0.8167979211124204,0.14162044414010344},
{0.11446085898566136,0.8193667966895963,0.14877965651135736},
{0.09401259163976007,0.8163062023356197,0.13150315279162464},
{0.08858415835652317,0.7995722312915537,0.11547680412085189},
{0.0950430708813948,0.7852662326553191,0.1025856064416935},
{0.09686771145072348,0.7696870019156173,0.09838114462634144},
{0.10315754017238114,0.7549489741916429,0.10150231624839876},
{0.09458774284439339,0.7498742411476751,0.10238812010985565},
{0.09159837670673124,0.743886189292646,0.09454014641947295},
{0.09721564242636588,0.743028787959813,0.08479874478575064},
{0.09632828530162486,0.7701212499509057,0.07980189680074362},
{0.09922623080027895,0.7894214338350891,0.09377949119976497},
{0.09801046943832445,0.7975434475477411,0.11274283884604965},
{0.10479512346335107,0.8032252846410441,0.12616614014739583},
{0.1135790492297922,0.8007837766531658,0.13929498710902422},
{0.12200860907269959,0.7908732912162295,0.14861168218191775},
{0.13068602535680118,0.7959442520493645,0.1477476240064385},
{0.13393678351570493,0.8019323039043935,0.15559537580206634},
{0.12851012539050702,0.8028493949262876,0.16430740766792828},
{0.10718848028942175,0.8126442731959345,0.15119653418144466},
{0.09649958805238756,0.8062008933039041,0.13113702644608258},
{0.1013956958186818,0.7712289485672367,0.08892399017361269},
{0.10878368168221075,0.7540431998022472,0.09267112689916948},
{0.11915792715683365,0.7424658409666977,0.10368154463601606},
{0.11193059309583345,0.7450347165438739,0.11084075700726993},
{0.1048630232583425,0.7383119711554571,0.11325763467735726},
{0.1049457900019105,0.729020572084619,0.1085152999761907},
{0.1121527097454623,0.726451696507443,0.1013560876049368},
{0.10582981870532841,0.748071568159079,0.08425510263630939},
{0.10674757541148717,0.8033526522303417,0.1464541994802781},
{0.11658217284225655,0.7917906041328784,0.15732371404777973},
{0.12346179782236924,0.7746126216843099,0.1608332014908665},
{0.12782513628221107,0.776149464756567,0.15161968747898935},
{0.13747201075035706,0.7787664914955507,0.15125711144952528},
{0.1426614633825947,0.7798464532675223,0.16010782753718347},
{0.13820426344144118,0.7783096101952651,0.16932111965430574},
{0.1198327091064054,0.7977786559879076,0.16517146584340753},
{0.12855761086805004,0.7756928053510364,0.16968391757852466},
{0.13152567510924432,0.7523046543978097,0.16352411918322318},
{0.12563237231454644,0.7564219115744962,0.1560422718383825},
{0.12969925938187662,0.7605573641210825,0.1475133031452916},
{0.13971891703821093,0.7605755594909822,0.1464661817970413},
{0.14565615499437384,0.7564583023142956,0.15394802914188194},
{0.14159525908542525,0.7523228497677094,0.16247721972972778},
{0.13762134592038724,0.7318521710515659,0.145609224253718},
{0.12792055102680686,0.7338809547953785,0.14834318952852024},
{0.12276837671338806,0.7420923920942448,0.14423480814202863},
{0.12728105034326007,0.7482750456492984,0.13739268337548963},
{0.13696431555120542,0.7462460400107307,0.13465871810068739},
{0.14215177113064917,0.7380346027118645,0.13876709948717902},
{0.13275696910404,0.729512068966665,0.11863236942991465},
{0.1271281648571519,0.722382590492564,0.12323735127781422},
{0.1183952748843318,0.7253584210501791,0.12820845947125586},
{0.11528719505281206,0.7354637300818947,0.12857458581679793},
{0.12085386876833543,0.7425932085559954,0.12396960396889836},
{0.12959341558380177,0.7396173779983806,0.11899849577545671},
{0.11929417053632627,0.7331742200011049,0.09893920993484949},
{-0.5159947286682032,-0.1178507451558711,0.06965087744952395},
{-0.5709278817638237,-0.11255145461997088,0.007106734261726204},
{-0.5070432723618322,-0.12846263991296406,0.06825138723053378},
{-0.4914911127822252,-0.1146539074224018,0.13285249479601327},
{-0.47385247682253817,-0.10188608322695333,0.1312597342455279},
{-0.4892162477552571,-0.11693720445005497,0.05920385049530239},
{-0.5682300853340658,-0.12206297328764373,-0.0026717237960600707},
{-0.6443947942602928,-0.08488384142424482,-0.0002297720186719925},
{-0.6235526637244901,-0.05961224779164797,0.028467876629179035},
{-0.572629814533707,-0.06827035923207556,0.03673922551186128},
{-0.5324451182155401,-0.07522653790261975,0.07331058764166039},
{-0.5109548331007506,-0.10066100228529411,0.12545718640557346},
{-0.510846770355127,-0.0878605595608792,0.20332360620692885},
{-0.49613181968565945,-0.07224449429186842,0.20803687269520693},
{-0.5024846665177014,-0.0551086718467258,0.19194439938748173},
{-0.4819172416884327,-0.08143759398629714,0.12481125077413532},
{-0.4939104312946161,-0.09460438495100901,0.06028026195119602},
{-0.5566101227055805,-0.10926097729994472,-0.020504517666261844},
{-0.6514104407251432,-0.09141819816577361,-0.011046475634513588},
{-0.681106837664682,-0.050012193116780373,0.05993299665981827},
{0.4993577256320173,-0.11686619812849527,0.07362501250931681},
{0.4912636706584793,-0.12820013841794814,0.07277559938765923},
{0.5507292460171556,-0.10804765678029382,0.008504005533167616},
{0.550108606387773,-0.06331478367147508,0.037493223888923045},
{0.5997029716811257,-0.05062284748219355,0.0267297750142512},
{0.6212303132199791,-0.0745415487943238,-0.0026142530545477096},
{0.5483835965633828,-0.11790244663375678,-0.0010223800830818312},
{0.4721443309995182,-0.1183267094050758,0.06444078860508304},
{0.45891141539785396,-0.10345687619670618,0.13695555070838789},
{0.4776036076536826,-0.11470161479469967,0.1378679819404297},
{0.4954781177378007,-0.09927127543551843,0.12939781535738035},
{0.5123634210046907,-0.07297918782525614,0.07599728933367446},
{-0.6878781780044162,-0.0303259123591163,0.12597575444771394},
{-0.6344954035611002,-0.034215283622547304,0.19324137422972007},
{-0.7123074591475114,-0.02654748847312226,0.13307949313024933},
{-0.7112803083271998,-0.05252626068950249,0.048311702662803636},
{-0.7175091159912671,-0.032419489371352236,0.036712154351766654},
{-0.718246916051223,-0.003967478217146702,0.13098258769669027},
{-0.6465638154891858,-0.03186741522122578,0.21687738162414089},
{-0.5795975317315046,-0.049855757314594205,0.20879087107226868},
{-0.5774540283994221,-0.051647113670691795,0.23691825020009363},
{-0.5259169745271478,-0.07918536222432632,0.18269715737286374},
{0.6160597216419058,-0.021813141983131154,0.19049032305879257},
{0.6657876675776925,-0.01460200623923675,0.12074325423303078},
{0.6901195369233981,-0.008712253760616868,0.12664299197561998},
{0.6873582785937464,-0.036022172611486075,0.042333414176989034},
{0.6576463490213664,-0.03581891701602151,0.055332452707016165},
{0.6282597171596318,-0.08064565160615195,-0.013670603005653202},
{0.6289651205853761,-0.018106390102961428,0.213501918612998},
{0.6940612753489794,0.014244311894379828,0.12399955976080634},
{0.6913568220765755,-0.01565622821964301,0.030214410244792086},
{0.624616205284601,-0.06542833121164969,-0.03270451318398781},
{0.5349338897862066,-0.10638411180300367,-0.018439343182649767},
{0.5112202192275799,-0.07573556447030065,0.18560908224107492},
{0.5634229573644761,-0.0416753852814103,0.20879375570408204},
{0.5627299800450046,-0.04319314540474827,0.23701033652336628},
{0.497886119617693,-0.08529589998404581,0.20702481071822673},
{0.5535364365610662,-0.02478630980368754,0.24674574699870702},
{0.6275219170996758,0.0033523859566359487,0.2198920437638587},
{0.6738555389701554,0.0224293437174161,0.11789989484407566},
{0.671767953116301,-0.0038492083127988725,0.034134624879150574},
{0.6112652416733438,-0.04842298288237298,-0.022615846258887715},
{0.530423878893393,-0.08456697571428479,-0.009700462051448071},
{0.47501276449577406,-0.09566903598489432,0.06502836591598932},
{-0.649933509236702,-0.07572491352206669,-0.029984971068252375},
{-0.6375682021265949,-0.05779137943315213,-0.02025355469849938},
{-0.69879650941799,-0.01907473881323146,0.03991387376984322},
{-0.699093848389521,0.005939013114201867,0.12409098039981442},
{-0.6465939931758486,-0.010440813901085139,0.22353244911232112},
{-0.5693593077416196,-0.03265802623284174,0.24651031666378573},
{-0.5671155079803338,-0.020374154497773442,0.22729179004939598},
{-0.4736017357495305,0.05883361909679511,-0.06424973722113653},
{-0.5731585897345717,0.09251968372896793,-0.08323128023732088},
{-0.4687120629311276,0.08151991694035532,-0.05661611386396209},
{-0.41578994199893005,0.07235788251160893,0.024357720084648416},
{-0.43773156104513317,0.07697995025563381,0.0324932693773478},
{-0.4790599029299205,0.08627534343205945,-0.03314497427241265},
{-0.5595611010506495,0.11289206306870234,-0.07613819250301941},
{-0.6495498532055248,0.13661771594409225,-0.01934067967694785},
{-0.6492767007622751,0.11555235928488641,-0.005204652422946483},
{-0.578977113996877,0.07458126795544616,-0.06636173149802702},
{-0.4866722243906271,0.043944481044751474,-0.050835311709985315},
{-0.41400036080087144,0.04861647510862299,0.023822731830647266},
{-0.4190389249997947,0.07993758544334902,0.09224797360162482},
{-0.4409312834104159,0.08266311871746601,0.08781762292581104},
{0.43633428977369176,0.053589802249613364,-0.06022811668380064},
{0.4299339574641069,0.07591374595846437,-0.052643753962208197},
{0.5317729990030269,0.09505860351423595,-0.08427840158557116},
{0.5398299975525008,0.07792899412222978,-0.06748895685278679},
{0.6092211471914447,0.12551188346264985,-0.010203941250257111},
{0.6070947297554875,0.1463025344153217,-0.024587381155942955},
{0.5168714348447102,0.11435102108199871,-0.07679611045122074},
{0.4398699607978537,0.08288634484086925,-0.030313375305465864},
{0.4022548057411274,0.07117407399435628,0.03777791485942635},
{0.38173242554709813,0.06370287759774959,0.030836381242703832},
{0.3818972933499695,0.039889132504674726,0.0306695163870386},
{0.45119835371843464,0.04004157420127315,-0.0472674659463667},
{-0.6298309539188943,0.1530423656998638,-0.01987455845717464},
{-0.6585885141505613,0.16151719207276544,0.09077880842960422},
{-0.6550805799707586,0.13906898730118503,0.09344664906745401},
{0.5860764147843149,0.16103656803370844,-0.024387897771311257},
{0.5108125985628764,0.11403526484581306,-0.05041992472886124},
{-0.44825336653174724,0.08392814071500256,0.17042881827063658},
{-0.4155931213513568,0.058124665354972765,0.09826886588037521},
{-0.4503822248100081,0.10254688580696794,0.15873673984681716},
{-0.5180263970438294,0.13444603197814065,0.19938386483414144},
{-0.5229773128145774,0.12477585856073288,0.17478660936160656},
{-0.4672005158609261,0.10014154666413407,0.14191378900604684},
{-0.43003136926149654,0.03431935226258311,0.030252354247875528},
{-0.4298172408230432,0.04416792906290956,0.09931754049190962},
{-0.4586486920080832,0.06897443128929058,0.16561813998496885},
{-0.521486845746089,0.11926621179721211,0.21512086274455855},
{-0.5879882599923091,0.15908921966493442,0.17093828862782726},
{-0.5800821498761495,0.1439118403263095,0.1513223485074582},
{0.4198013553775417,0.08021206925512811,0.17506797191078677},
{0.41983774611734104,0.09875603581470098,0.16306723788293767},
{0.3861146250611042,0.05067011106498162,0.10483939146694846},
{0.40148150252039155,0.03795088182085057,0.10538325551114455},
{0.39933844297781873,0.027064503251978535,0.03650712359826311},
{0.38745731022284663,0.07259508800456921,0.09840311220707396},
{0.4349232610274481,0.09859937811775994,0.14615796998252134},
{0.4902986503695324,0.1284679653870809,0.17628018295666328},
{0.4863961873155638,0.13675662206064335,0.20009969731336488},
{0.4918243987040459,0.12216393540111134,0.21583602953951736},
{0.4311701331435097,0.06609135273921304,0.16995174454765757},
{-0.5990699059454703,0.145566065723895,0.18484665186332794},
{-0.6408143004956464,0.17530661971965367,0.08427329800620907},
{-0.622735869131799,0.15683033106031738,0.08049487412021504},
{0.5654828063739712,0.15428408874813854,0.18162962170716504},
{0.5526890204922025,0.16662698448800334,0.16809847955495014},
{0.49716030187450033,0.10525289234265604,0.20791061457968363},
{0.5448576889084353,0.15203385403896158,0.14974112648422627},
{0.5832585732921703,0.16740938539368896,0.07632414030760383},
{0.5999479434905065,0.18577095446475542,0.07885418430267688},
{0.6190854785193672,0.17359692063334972,0.08467914351287356},
{0.5663224561264143,0.13450660924622126,0.17693654764158048},
{-0.5984976393726503,0.12584450370020595,0.17988552893385562},
{-0.5257791778843711,0.10206648366266578,0.207182799783697},
{-0.612324789127867,0.14073097901519108,-0.00336203837847301},
{0.6175799226075473,0.15098096342708456,0.08777679429091424},
{0.5702872716065025,0.14905780158659185,-0.007332401227433021},
{0.4075474394343814,0.07802174612976712,0.09320345241611214},
{-0.5526803665967625,0.11148813495461471,-0.04936259622188675},
{-0.5535060369796485,-0.08725057087973065,-0.011638712735272231},
{0.482157775602716,-0.07087251902248264,0.2122393374577651},
{0.4863196336251323,-0.053527893613003606,0.19566202411064026},
{0.5493998745407055,-0.01303365411178751,0.22750924690917249},
{0.46494584325665167,-0.08251799954777853,0.12989108739746522},
{-0.6364174559278185,-0.000338833290692595,0.20615786791093413},
{0.6157541725644443,0.01230628310531055,0.2028969025933062},
{0.019064753549262063,-0.004417480780031103,0.27701818272189865},
{0.02266122373625943,0.0014900232789786905,0.2766416273228775},
{0.01881157163395086,-0.003383007432808649,0.29082979984427426},
{0.011888011492373129,-0.0032372225788564442,0.2906920032014975},
{0.012141193407684332,-0.004271695926078897,0.2768803860791219},
{0.008561143432547644,0.002815844439350698,0.2901776511596996},
{0.008814325347858849,0.00178137109212822,0.2763658121425691},
{0.012157613619545012,0.00872334849836049,0.28980109576067853},
{0.012410795534856215,0.007688875151138012,0.275989256743548},
{0.01908095186636786,0.008577785539163166,0.2899388924034552},
{0.019334133781679065,0.007543090297185832,0.27612727528107966},
{0.022408041820948226,0.0025244966262011684,0.29045324444525317},
{0.011888011492373129,-0.0032372225788564442,0.2906920032014975},
{0.01881157163395086,-0.003383007432808649,0.29082979984427426},
{0.015484481679370495,0.0026702814801533485,0.29031544780247637},
{0.022408041820948226,0.0025244966262011684,0.29045324444525317},
{0.01908095186636786,0.008577785539163166,0.2899388924034552},
{0.012157613619545012,0.00872334849836049,0.28980109576067853},
{0.008561143432547644,0.002815844439350698,0.2901776511596996},
{-0.05580519948227517,-0.004271695926078897,0.2768803860791219},
{-0.05247833142244968,0.00178137109212822,0.2763658121425691},
{-0.055552017566963964,-0.0032372225788564442,0.2906920032014975},
{-0.062475577708541695,-0.003383007432808649,0.29082979984427426},
{-0.0627287596238529,-0.004417480780031103,0.27701818272189865},
{-0.06607204789553905,0.0025244966262011684,0.29045324444525317},
{-0.06632522981085026,0.0014900232789786905,0.2766416273228775},
{-0.06274495794095869,0.008577785539163166,0.2899388924034552},
{-0.0629981398562699,0.007543090297185832,0.27612727528107966},
{-0.05582161969413585,0.00872334849836049,0.28980109576067853},
{-0.05607480160944705,0.007688875151138012,0.275989256743548},
{-0.05222514950713848,0.002815844439350698,0.2901776511596996},
{-0.062475577708541695,-0.003383007432808649,0.29082979984427426},
{-0.055552017566963964,-0.0032372225788564442,0.2906920032014975},
{-0.05914848775396133,0.0026702814801533485,0.29031544780247637},
{-0.05222514950713848,0.002815844439350698,0.2901776511596996},
{-0.05582161969413585,0.00872334849836049,0.28980109576067853},
{-0.06274495794095869,0.008577785539163166,0.2899388924034552},
{-0.06607204789553905,0.0025244966262011684,0.29045324444525317},
{-0.017115408127694232,0.0246136756843955,0.2889086350565754},
{-0.02671479711829721,0.024447476512994896,0.2889086350565754},
{-0.017221695715278863,0.023543033492128572,0.2786027331664537},
{-0.00854117290460901,0.020903595382902658,0.27884592981779555},
{-0.008434885317024379,0.021974015680414707,0.2891520536026721},
{-0.00525557726919008,0.01891785922153547,0.2791148662607028},
{-0.0053618648567747155,0.019988279519047518,0.2894207681508245},
{0.0007804038528917517,0.019391382628436524,0.2791330616306025},
{0.0008826973348886542,0.020770902319488024,0.2888633685265811},
{-0.026608509530712577,0.023377056215482847,0.2786027331664537},
{-0.033733550109715876,0.02097704254676595,0.2891520536026721},
{-0.03362748441688611,0.019906622249253887,0.27884592981779555},
{-0.03664014950381005,0.01574365475306327,0.28966573996020545},
{-0.0365340838109803,0.014673234455551224,0.27935961617532884},
{-0.035756120800392144,0.011063450583261417,0.2901607871583292},
{-0.03565005510756238,0.009993030285749369,0.2798548852682075},
{-0.03201009354860972,0.00854516701019669,0.2904610107616737},
{-0.03190402785577996,0.007474746712684629,0.280155108871552},
{-0.025847188626739973,0.007057140784011824,0.2906791333057148},
{-0.02574112293391021,0.005986720486499763,0.2803730095208382},
{-0.021181407616004927,0.006857879294134981,0.2907479206797258},
{-0.02107534192317517,0.005787458996622945,0.28044179689484916},
{-0.017816817447850863,0.007057140784011824,0.2906791333057148},
{-0.017922883140680624,0.005986720486499763,0.2803730095208382},
{-0.006978368146031614,0.005001729669614201,0.29115132534408666},
{-0.007084655733616246,0.00393130937210214,0.2808454234539649},
{0.0012956434737091199,-0.000543420254686394,0.29177440581577274},
{0.0014019310612937517,-0.0016138405521984546,0.2814682820308962},
{0.0044512087827719,-0.008643466386605953,0.2926413486230654},
{0.0045572744756016605,-0.009713886684117988,0.2823352248381888},
{0.0020152481637654156,-0.018612975828338717,0.2928408320076971},
{0.0019089605761807838,-0.019683396125850756,0.2825347082228205},
{-0.0038374478907905155,-0.02319909662207399,0.29383026071968016},
{-0.003943513583620276,-0.024269516919586048,0.2835243588295584},
{-0.013057840640068747,-0.026352442983588048,0.2941247150593979},
{-0.012951774947238988,-0.027422863281100083,0.2838188131692762},
{-0.0245928175774374,-0.0265368375248883,0.29409187463567654},
{-0.02448675188460764,-0.027607257822400363,0.28378575085079993},
{-0.03695302110818236,-0.024382239455062016,0.29383026071968016},
{-0.036846733520597724,-0.02545265975257408,0.2835243588295584},
{-0.01600016508969764,0.03097850483320056,0.2778489566841468},
{-0.0278300401562938,0.030812305661799957,0.2778489566841468},
{-0.015894099396867877,0.03204892513071261,0.28815485857426854},
{-0.0057896779441717365,0.028733595598140572,0.28835877985399766},
{-0.0055937448756180185,0.02737249317174361,0.2781434110238646},
{-0.027936105849123562,0.03188294785406688,0.28815485857426854},
{-0.03710346575198691,0.027663175300628524,0.27805287796387596},
{-0.037209531444816674,0.028733595598140572,0.28835877985399766},
{-0.0436096418596467,0.021694428289273503,0.2785574666364594},
{-0.043715929447231336,0.02276484858678555,0.2888633685265811},
{-0.04633584081802834,0.013962727450444764,0.2793325450152342},
{-0.046442128405612966,0.01503336964271168,0.2896384469053559},
{-0.043856610721821426,0.005862681318525217,0.28019926592777195},
{-0.043962898309406064,0.006933323510792134,0.29050538971264855},
{-0.036410266537760624,0.0003814370836283174,0.2808454234539649},
{-0.036516554125345255,0.0014520792758952337,0.29115132534408666},
{-0.02672589185604091,-0.0016839592947386266,0.2811596264268665},
{-0.026831957548870668,-0.0006135389972265905,0.2914657502117431},
{-0.02053436251079242,-0.001707480138755279,0.28122597295857377},
{-0.020640428203622177,-0.0006370598412432184,0.2915318748486955},
{-0.016938114218549925,-0.0016839592947386266,0.2811596264268665},
{-0.016832048525720168,-0.0006135389972265905,0.2914657502117431},
{-0.009705676578187624,-0.0033947678548169632,0.28151266098187094},
{-0.009811742271017386,-0.002324347557304927,0.2918187847667476},
{-0.005959649326405201,-0.005913051427881703,0.2818128845852155},
{-0.006065715019234958,-0.004842631130369642,0.2921187864753372},
{-0.0037233939867852926,-0.01076233940089751,0.28230815367809414},
{-0.0038294596796150534,-0.009691919103385474,0.2926140555682159},
{-0.005808760893090899,-0.016336113748576856,0.2825529035927202},
{-0.005702695200261138,-0.015265693451064821,0.2928588054828419},
{-0.014336398217652584,-0.019474815056269232,0.2830650366869693},
{-0.014442685805237217,-0.018404172864002293,0.293370938577091},
{-0.0241383771194555,-0.019508986848519823,0.28303774363211975},
{-0.024244442812285258,-0.01843856655100776,0.29334386741699636},
{-0.03412053456221608,-0.017721180808500218,0.2827492804507836},
{-0.03422660025504584,-0.01665053861623328,0.2930551823409054},
{-0.037517077575072,-0.016167029945362905,0.2825529035927202},
{-0.03762336516265664,-0.015096609647850845,0.2928588054828419},
{-0.04405165621135566,-0.01664077524701884,0.2825347082228205},
{-0.04415794379894029,-0.015570354949506779,0.2928408320076971},
{-0.0061489255523126994,0.03869511682869787,0.27709806483365323},
{-0.00625499124514246,0.03976553712620993,0.287403966723775},
{0.000279587391141194,0.04023906053311098,0.28742216209367466},
{0.00038565308397095174,0.039168640235598934,0.27711626020355296},
{-0.036125353672502435,-0.035445911933078354,0.2845697050197697},
{-0.03623164126008707,-0.034375491635566316,0.2948756069098914},
{-0.04276621989637073,-0.03484901504246737,0.29485763343474664},
{-0.04265993230878609,-0.035919435339979405,0.28455150964987},
{-0.0245928175774374,-0.0265368375248883,0.29409187463567654},
{-0.013057840640068747,-0.026352442983588048,0.2941247150593979},
{-0.014442685805237217,-0.018404172864002293,0.293370938577091},
{-0.0038374478907905155,-0.02319909662207399,0.29383026071968016},
{-0.005702695200261138,-0.015265693451064821,0.2928588054828419},
{0.0020152481637654156,-0.018612975828338717,0.2928408320076971},
{0.0044512087827719,-0.008643466386605953,0.2926413486230654},
{-0.0038294596796150534,-0.009691919103385474,0.2926140555682159},
{0.0012956434737091199,-0.000543420254686394,0.29177440581577274},
{-0.006065715019234958,-0.004842631130369642,0.2921187864753372},
{-0.006978368146031614,0.005001729669614201,0.29115132534408666},
{-0.009811742271017386,-0.002324347557304927,0.2918187847667476},
{-0.017816817447850863,0.007057140784011824,0.2906791333057148},
{-0.016832048525720168,-0.0006135389972265905,0.2914657502117431},
{-0.017816817447850863,0.007057140784011824,0.2906791333057148},
{-0.016832048525720168,-0.0006135389972265905,0.2914657502117431},
{-0.025847188626739973,0.007057140784011824,0.2906791333057148},
{-0.026831957548870668,-0.0006135389972265905,0.2914657502117431},
{-0.03201009354860972,0.00854516701019669,0.2904610107616737},
{-0.036516554125345255,0.0014520792758952337,0.29115132534408666},
{-0.035756120800392144,0.011063450583261417,0.2901607871583292},
{-0.043962898309406064,0.006933323510792134,0.29050538971264855},
{-0.03664014950381005,0.01574365475306327,0.28966573996020545},
{-0.046442128405612966,0.01503336964271168,0.2896384469053559},
{-0.033733550109715876,0.02097704254676595,0.2891520536026721},
{-0.043715929447231336,0.02276484858678555,0.2888633685265811},
{-0.037209531444816674,0.028733595598140572,0.28835877985399766},
{-0.02671479711829721,0.024447476512994896,0.2889086350565754},
{-0.027936105849123562,0.03188294785406688,0.28815485857426854},
{-0.015894099396867877,0.03204892513071261,0.28815485857426854},
{-0.017115408127694232,0.0246136756843955,0.2889086350565754},
{-0.008434885317024379,0.021974015680414707,0.2891520536026721},
{-0.0057896779441717365,0.028733595598140572,0.28835877985399766},
{-0.0053618648567747155,0.019988279519047518,0.2894207681508245},
{0.0008826973348886542,0.020770902319488024,0.2888633685265811},
{0.000668568896435271,0.029082857942312197,0.2884675082838859},
{0.000279587391141194,0.04023906053311098,0.28742216209367466},
{-0.00625499124514246,0.03976553712620993,0.287403966723775},
{-0.024244442812285258,-0.01843856655100776,0.29334386741699636},
{-0.03422660025504584,-0.01665053861623328,0.2930551823409054},
{-0.03695302110818236,-0.024382239455062016,0.29383026071968016},
{-0.03762336516265664,-0.015096609647850845,0.2928588054828419},
{-0.04415794379894029,-0.015570354949506779,0.2928408320076971},
{-0.04348759974446602,-0.024855762861963095,0.29381206534978044},
{-0.04276621989637073,-0.03484901504246737,0.29485763343474664},
{-0.03623164126008707,-0.034375491635566316,0.2948756069098914},
{-0.04348759974446602,-0.024855762861963095,0.29381206534978044},
{-0.04415794379894029,-0.015570354949506779,0.2928408320076971},
{-0.04338131215688138,-0.025926405054230012,0.2835061634596588},
{-0.04265993230878609,-0.035919435339979405,0.28455150964987},
{-0.04276621989637073,-0.03484901504246737,0.29485763343474664},
{-0.04405165621135566,-0.01664077524701884,0.2825347082228205},
{0.0007748564840199029,0.028012215750045283,0.27816160639376425},
{0.00038565308397095174,0.039168640235598934,0.27711626020355296},
{0.000668568896435271,0.029082857942312197,0.2884675082838859},
{0.0008826973348886542,0.020770902319488024,0.2888633685265811},
{0.0009426089187046286,0.02086365432702534,0.2785574666364594},
{0.000279587391141194,0.04023906053311098,0.28742216209367466},
{-0.036846733520597724,-0.02545265975257408,0.2835243588295584},
{-0.03695302110818236,-0.024382239455062016,0.29383026071968016},
{-0.03623164126008707,-0.034375491635566316,0.2948756069098914},
{-0.036125353672502435,-0.035445911933078354,0.2845697050197697},
{-0.0058959655317563685,0.027663175300628524,0.27805287796387596},
{-0.0057896779441717365,0.028733595598140572,0.28835877985399766},
{-0.00625499124514246,0.03976553712620993,0.287403966723775},
{-0.0061489255523126994,0.03869511682869787,0.27709806483365323},
{0.02617692423248267,0.051507541869875995,0.2869100289994255},
{0.040894759533763606,0.02956814177122158,0.2888695815797176},
{0.02617692423248267,0.04891891765951622,0.24831276775762703},
{0.004150319495162792,0.06357839464026528,0.2470035887038706},
{0.004150097600407918,0.0661667969558702,0.28560084994566903},
{-0.021832003037295416,0.06872590916383173,0.2465438227717717},
{-0.021832003037295416,0.07131453337419151,0.2851410840135702},
{-0.047814325569753624,0.06357839464026528,0.2470035887038706},
{-0.047814103674998755,0.0661667969558702,0.28560084994566903},
{-0.0698409303070735,0.04891891765951622,0.24831276775762703},
{-0.0698409303070735,0.051507541869875995,0.2869100289994255},
{-0.08455876560835444,0.02697951756086181,0.2502723203379191},
{-0.08455876560835444,0.02956814177122158,0.2888695815797176},
{-0.08972691634412416,0.001100376089419997,0.25258379799944125},
{-0.08972691634412416,0.0036887784050249088,0.2911810592412397},
{-0.08455876560835444,-0.024778987276776684,0.2548952756609635},
{-0.08455876560835444,-0.022190363066416918,0.29349253690276195},
{-0.0698409303070735,-0.04671838737543109,0.2568548282412555},
{-0.06984115220182838,-0.04412976316507132,0.295452089483054},
{-0.047814325569753624,-0.0613776424614253,0.25816400729501193},
{-0.047814325569753624,-0.058789240145820404,0.29676126853681045},
{-0.021832003037295416,-0.06652537887974663,0.25862377322711083},
{-0.021832003037295416,-0.06393697656414171,0.29722103446890935},
{0.004150319495162792,-0.0613776424614253,0.25816400729501193},
{0.004150319495162792,-0.058789240145820404,0.29676126853681045},
{0.02617692423248267,-0.04671838737543109,0.2568548282412555},
{0.026177146127237545,-0.04412976316507132,0.295452089483054},
{0.040894759533763606,-0.024778987276776684,0.2548952756609635},
{0.040894759533763606,-0.022190363066416918,0.29349253690276195},
{0.04606291026953333,0.001100376089419997,0.25258379799944125},
{0.04606291026953333,0.0036887784050249088,0.2911810592412397},
{0.040894759533763606,0.02697951756086181,0.2502723203379191},
{0.018175399371727175,0.04353774795906747,0.2876218673730612},
{0.03044018815787633,0.025254951525981287,0.28925479087417877},
{0.02617692423248267,0.051507541869875995,0.2869100289994255},
{0.004150097600407918,0.0661667969558702,0.28560084994566903},
{-0.0001801785409576806,0.055753719899144356,0.2865308108633459},
{-0.021832003037295416,0.07131453337419151,0.2851410840135702},
{-0.021832003037295416,0.06004338930036802,0.28614759862167854},
{-0.047814103674998755,0.0661667969558702,0.28560084994566903},
{-0.043483827533633154,0.055753719899144356,0.2865308108633459},
{-0.0698409303070735,0.051507541869875995,0.2869100289994255},
{-0.06183940544631801,0.04353774795906747,0.2876218673730612},
{-0.08455876560835444,0.02956814177122158,0.2888695815797176},
{-0.07410419423246717,0.025254951525981287,0.28925479087417877},
{-0.08972691634412416,0.0036887784050249088,0.2911810592412397},
{-0.07841117142457099,0.0036887784050249088,0.2911810592412397},
{-0.08455876560835444,-0.022190363066416918,0.29349253690276195},
{-0.07410441612722204,-0.0178771728211766,0.2931073276083007},
{-0.06984115220182838,-0.04412976316507132,0.295452089483054},
{-0.061839627341072886,-0.03615996925426281,0.2947402511094183},
{-0.047814325569753624,-0.058789240145820404,0.29676126853681045},
{-0.04348404942838803,-0.04837638498384943,0.2958313076191336},
{-0.021832003037295416,-0.06393697656414171,0.29722103446890935},
{-0.021832003037295416,-0.052666054385073095,0.296214519860801},
{0.004150319495162792,-0.058789240145820404,0.29676126853681045},
{-0.0001799566462028064,-0.04837638498384943,0.2958313076191336},
{0.026177146127237545,-0.04412976316507132,0.295452089483054},
{0.018175621266482048,-0.03615996925426281,0.2947402511094183},
{0.040894759533763606,-0.022190363066416918,0.29349253690276195},
{0.030440410052631203,-0.0178771728211766,0.2931073276083007},
{0.04606291026953333,0.0036887784050249088,0.2911810592412397},
{0.03474716534998016,0.0036887784050249088,0.2911810592412397},
{0.040894759533763606,0.02956814177122158,0.2888695815797176},
{-0.021832003037295416,0.0030905501458846686,0.2851923417019461},
{0.024569518628175604,0.02223474201739162,0.28348242072088725},
{0.013682030585529208,0.03846412438887407,0.2820327822872956},
{-0.002611923159621558,0.04930834295432004,0.2810642116822707},
{-0.0001801785409576806,0.055753719899144356,0.2865308108633459},
{0.018175399371727175,0.04353774795906747,0.2876218673730612},
{0.03044018815787633,0.025254951525981287,0.28925479087417877},
{0.02839276525465417,0.003090772040639549,0.2851923417019461},
{0.02456974052293048,-0.016053197936112536,0.28690204078825005},
{0.013682252480284082,-0.03228280220234985,0.28835167922184174},
{-0.0026117012648666843,-0.04312702076779582,0.28932024982686666},
{-0.021832003037295416,-0.04693495665618811,0.28966041448608837},
{-0.041052304809724154,-0.04312702076779582,0.28932024982686666},
{-0.05734625855487492,-0.03228280220234985,0.28835167922184174},
{-0.06823374659752131,-0.016053197936112536,0.28690204078825005},
{-0.07205677132924501,0.003090772040639549,0.2851923417019461},
{-0.06823352470276643,0.02223474201739162,0.28348242072088725},
{-0.057346036660120045,0.03846412438887407,0.2820327822872956},
{-0.04105208291496928,0.04930834295432004,0.2810642116822707},
{-0.021832003037295416,0.0531162788427123,0.2807242689178038},
{-0.021832003037295416,0.06004338930036802,0.28614759862167854},
{-0.043483827533633154,0.055753719899144356,0.2865308108633459},
{-0.06183940544631801,0.04353774795906747,0.2876218673730612},
{-0.07410419423246717,0.025254951525981287,0.28925479087417877},
{-0.07841117142457099,0.0036887784050249088,0.2911810592412397},
{-0.07410441612722204,-0.0178771728211766,0.2931073276083007},
{-0.061839627341072886,-0.03615996925426281,0.2947402511094183},
{-0.04348404942838803,-0.04837638498384943,0.2958313076191336},
{-0.021832003037295416,-0.052666054385073095,0.296214519860801},
{-0.0001799566462028064,-0.04837638498384943,0.2958313076191336},
{0.018175621266482048,-0.03615996925426281,0.2947402511094183},
{0.030440410052631203,-0.0178771728211766,0.2931073276083007},
{0.03474716534998016,0.0036887784050249088,0.2911810592412397},
{-0.4819172416884327,-0.08143759398629714,0.12481125077413532},
{-0.4939104312946161,-0.09460438495100901,0.06028026195119602},
{-0.4478481867093474,-0.02268274752748226,0.1091956292946343},
{-0.4740282174683983,0.0060555078605107025,0.17736591399226165},
{-0.4586486920080832,0.06897443128929058,0.16561813998496885},
{-0.4298172408230432,0.04416792906290956,0.09931754049190962},
{-0.453005908391638,-0.036083193669076405,0.036229533259915764},
{-0.5535060369796485,-0.08725057087973065,-0.011638712735272231},
{-0.5167738011525658,-0.025487275334334404,-0.04763447987092826},
{-0.6375682021265949,-0.05779137943315213,-0.02025355469849938},
{-0.6141299029587669,0.005088490518769931,-0.05796634344737023},
{-0.4866722243906271,0.043944481044751474,-0.050835311709985315},
{-0.578977113996877,0.07458126795544616,-0.06636173149802702},
{0.47501276449577406,-0.09566903598489432,0.06502836591598932},
{0.46494584325665167,-0.08251799954777853,0.12989108739746522},
{0.4254352632037919,-0.02702300893281719,0.11519766051922042},
{0.45224392180340073,0.004846625235957292,0.18171150087171356},
{0.4863196336251323,-0.053527893613003606,0.19566202411064026},
{0.5195514796940781,0.046925415181728436,0.22221483805787948},
{0.5493998745407055,-0.01303365411178751,0.22750924690917249},
{0.595032974670048,0.07624281587994247,0.19170652821025683},
{0.6157541725644443,0.01230628310531055,0.2028969025933062},
{0.6536431457486851,0.08944333484739517,0.09979306095160455},
{0.6738555389701554,0.0224293437174161,0.11789989484407566},
{0.6528731709492723,0.062105901046921604,0.006153030605277859},
{0.671767953116301,-0.0038492083127988725,0.034134624879150574},
{0.58097904847535,0.011709386214699555,-0.05993011202800488},
{0.6112652416733438,-0.04842298288237298,-0.022615846258887715},
{0.42832899270210334,-0.041103118708590326,0.042234892905824994},
{0.40148150252039155,0.03795088182085057,0.10538325551114455},
{0.4311701331435097,0.06609135273921304,0.16995174454765757},
{0.49716030187450033,0.10525289234265604,0.20791061457968363},
{0.5663224561264143,0.13450660924622126,0.17693654764158048},
{0.6175799226075473,0.15098096342708456,0.08777679429091424},
{0.6092211471914447,0.12551188346264985,-0.010203941250257111},
{0.5398299975525008,0.07792899412222978,-0.06748895685278679},
{0.530423878893393,-0.08456697571428479,-0.009700462051448071},
{0.48707562905498797,-0.026615388268113705,-0.0446602025765975},
{0.39933844297781873,0.027064503251978535,0.03650712359826311},
{-0.699093848389521,0.005939013114201867,0.12409098039981442},
{-0.6364174559278185,-0.000338833290692595,0.20615786791093413},
{-0.6853459150617944,0.07461077995784439,0.10613459115114783},
{-0.6867380827538737,0.04855057236642542,0.012138197828493558},
{-0.6492767007622751,0.11555235928488641,-0.005204652422946483},
{-0.6550805799707586,0.13906898730118503,0.09344664906745401},
{-0.6215837915644934,0.0652264069847143,0.1950376122704249},
{-0.5671155079803338,-0.020374154497773442,0.22729179004939598},
{-0.5425905901978879,0.04191503161667411,0.2215786657956558},
{-0.5024846665177014,-0.0551086718467258,0.19194439938748173},
{-0.69879650941799,-0.01907473881323146,0.03991387376984322},
{0.45119835371843464,0.04004157420127315,-0.0472674659463667},
{-0.43003136926149654,0.03431935226258311,0.030252354247875528},
{-0.5984976393726503,0.12584450370020595,0.17988552893385562},
{-0.5257791778843711,0.10206648366266578,0.207182799783697},
{-0.021832003037295416,0.6803825731847732,-0.004743998911828109},
{-0.021832003037295416,0.6873849059643312,-0.002358630296932895},
{-0.06642375108201432,0.6881076171809557,0.0009748946055388149},
{-0.06760733770451209,0.6936645275272647,-0.003760783252981539},
{-0.021832003037295416,0.6929187392561332,-0.007123154473586858},
{-0.06881000727592904,0.692232640674063,-0.010917110992422062},
{-0.021832003037295416,0.691450683557887,-0.014273047265136046},
{-0.06882909022484818,0.6852436215797975,-0.013337538978587374},
{-0.021832003037295416,0.6844479069888193,-0.016658637774786142},
{-0.06764550360235042,0.6796867112334886,-0.00860186112006702},
{-0.021832003037295416,0.6789142955917723,-0.011894113598132165},
{-0.06644283403093348,0.6811185980866902,-0.0014457552753813655},
{0.022759745007423476,0.6881076171809557,0.0009748946055388149},
{0.023943331629921252,0.6936645275272647,-0.003760783252981539},
{0.02514600120133819,0.692232640674063,-0.010917110992422062},
{0.02516508415025735,0.6852436215797975,-0.013337538978587374},
{0.023981497527759577,0.6796867112334886,-0.00860186112006702},
{0.02277882795634264,0.6811185980866902,-0.0014457552753813655},
{-0.12223494172267106,0.6831726778325585,0.011166520696900424},
{-0.12535389439717964,0.6824752626179897,0.004493701628330287},
{-0.12747698341181385,0.6884957111072304,0.0007561063772330796},
{-0.12648111975193943,0.6952122434425105,0.0036908864051962476},
{-0.12336216707743085,0.6959083272885503,0.0103628178947469},
{-0.12123907806279666,0.6898881006940646,0.01410019125108924},
{0.0816898883225888,0.6824752626179897,0.004493701628330287},
{0.07857093564808022,0.6831726778325585,0.011166520696900424},
{0.083812977337223,0.6884957111072304,0.0007561063772330796},
{0.08281711367734859,0.6952122434425105,0.0036908864051962476},
{0.07969838289759489,0.6959083272885503,0.0103628178947469},
{0.07757507198820583,0.6898881006940646,0.01410019125108924},
{-0.15914491524840788,0.6862816452430978,0.042519583876328294},
{-0.16070328211188778,0.6805585357253883,0.038106984780904456},
{-0.16622557687643638,0.6810577989238547,0.03320377638245425},
{-0.17018950477750502,0.6872857190089026,0.032719602027319244},
{-0.16863113791402512,0.6930114912636706,0.0371355295440662},
{-0.16310884314947655,0.6925095653281456,0.04203563141594816},
{0.11703927603729695,0.6805585357253883,0.038106984780904456},
{0.11548090917381704,0.6862814233483431,0.042519583876328294},
{0.12256157080184553,0.6810580208186096,0.03320377638245425},
{0.12652549870291419,0.6872857190089026,0.032719602027319244},
{0.12496713183943428,0.6930114912636706,0.0371355295440662},
{0.11944483707488569,0.6925095653281456,0.04203563141594816},
{-0.18452213078432475,0.6613744027980042,0.08392958303090928},
{-0.19109310016040773,0.6609754360287405,0.0805454661243263},
{-0.19636132543062562,0.6659374465372324,0.08209007551300403},
{-0.19505813753525078,0.671299533288762,0.08701724854498062},
{-0.18848716815916777,0.671699387637045,0.09039981218827947},
{-0.18321916478370476,0.6667371552337983,0.08885520279960175},
{0.1474290940858169,0.6609752141339859,0.0805454661243263},
{0.1408581247097339,0.6613744027980042,0.08392958303090928},
{0.15269731935603478,0.6659374465372324,0.08209007551300403},
{0.15139413146065994,0.671299533288762,0.08701724854498062},
{0.14482316208457696,0.671699387637045,0.09039981218827947},
{0.13955515870911395,0.6667371552337983,0.08885542469435663},
{-0.1904948719012675,0.6299545492973592,0.13926991300172345},
{-0.19235457184186625,0.6252048920692816,0.13390782625019387},
{-0.1993983989405857,0.6230576165263663,0.13313829524029094},
{-0.2045823042039515,0.6256715367387816,0.1377348450875053},
{-0.20272238236859783,0.6304178655455359,0.1430958223652605},
{-0.19567877716463325,0.6325593718248247,0.14386335632236957},
{0.1486905657672754,0.6252048920692816,0.13390782625019387},
{0.14683086582667665,0.6299545492973592,0.13926991300172345},
{0.15573439286599486,0.6230576165263663,0.13313829524029094},
{0.16091829812936065,0.6256715367387816,0.1377348450875053},
{0.159058376294007,0.6304178655455359,0.1430958223652605},
{0.15201477109004244,0.6325593718248247,0.14386335632236957},
{-0.17821876648261978,0.5714764055978722,0.1787239098920904},
{-0.18507731146101944,0.5686965081088109,0.1786016458821548},
{-0.1900650617610766,0.5716164211881976,0.1840744581163665},
{-0.18819471087224388,0.5766567605451598,0.1891558480029805},
{-0.18133638778859912,0.5794382112975052,0.1892599166430164},
{-0.17634841559378706,0.5771793226928881,0.18428281729119314},
{0.1414133053864286,0.5694480656435691,0.1791652585595347},
{0.13455476040802894,0.5722297382906691,0.17926688635726698},
{0.14640105568648576,0.5717113921432836,0.18414058275331896},
{0.14453070479765304,0.5767563912900984,0.18921753474483546},
{0.13767238171400828,0.5795380639371984,0.18931916254256775},
{0.13268440951919622,0.5772745155427289,0.18434383834878348},
{-0.153653020065277,0.5305310540599972,0.22593179709677344},
{-0.1536973990162518,0.5251649732028798,0.22083753731437672},
{-0.15896518049695993,0.5197636110797376,0.22079715246898965},
{-0.1641883611319384,0.5200740418418063,0.22616789311595933},
{-0.16414376028620875,0.525504472177837,0.23131829227133913},
{-0.15887620070025546,0.5307008035474757,0.23117228552263203},
{0.11003339294166097,0.5251649732028798,0.22083753731437672},
{0.10998901399068617,0.5305310540599972,0.22593179709677344},
{0.11530117442236909,0.5199686418332412,0.2209835440630838},
{0.12052435505734758,0.5201383913207197,0.22622403248894243},
{0.12047975421161791,0.525504472177837,0.23131829227133913},
{0.11521219462566464,0.5307008035474757,0.23117228552263203},
{-0.11877427112565658,0.4868313229298717,0.26601486561720805},
{-0.1240420526063647,0.4816347696654781,0.26618128668336355},
{-0.12926523324134317,0.4818247115756502,0.2714217751092221},
{-0.12922063239561352,0.4872114286449707,0.2764960643636802},
{-0.12395285091490538,0.4924082038041192,0.27632986519227953},
{-0.11872967027992688,0.4922180399991923,0.27108915487166607},
{0.08037804653177387,0.4816347696654781,0.26618128668336355},
{0.07511026505106573,0.4868313229298717,0.26601486561720805},
{0.08560122716675234,0.4818247115756502,0.2714217751092221},
{0.08555662632102268,0.4872114286449707,0.2764960643636802},
{0.08028884484031454,0.4924082038041192,0.27632986519227953},
{0.07506566420533606,0.4922180399991923,0.27108915487166607},
{-0.09070591600262813,0.4746495227820454,0.3053920869223885},
{-0.08969540728893205,0.4703081519029361,0.2994821420210751},
{-0.09309017514374898,0.46374206421146036,0.29908916641019334},
{-0.09749567360701686,0.46151690360958414,0.3046061357006249},
{-0.09850618232071293,0.46585827448869344,0.31051608060193836},
{-0.09511141446589601,0.4724245840749241,0.31090905621282017},
{0.04603140121434122,0.4703081519029361,0.2994821420210751},
{0.0470419099280373,0.4746495227820454,0.3053920869223885},
{0.04942616906915814,0.46374206421146036,0.29908916641019334},
{0.05383166753242602,0.46151690360958414,0.3046061357006249},
{0.054842176246122094,0.46585827448869344,0.31051608060193836},
{0.05144740839130517,0.4724245840749241,0.31090905621282017},
{-0.08121481165240366,0.45875719854321645,0.3330266377996383},
{-0.08778089934387942,0.46590243154491334,0.3122495224270138},
{-0.0865788954567271,0.44860040992837014,0.32367066735513217},
{-0.0727703848609197,0.4408556172990038,0.3164639695063352},
{-0.082247731736342,0.44589551286645634,0.30662204954865496},
{-0.07424509740181214,0.46089360124314316,0.29711740961838323},
{-0.06940424142948153,0.4754057401066559,0.30670503818697786},
{-0.07480582544737867,0.47618214985395996,0.324135758761348},
{-0.06587833377453409,0.4526258026765389,0.32778592747902485},
{0.03755080557781282,0.45875719854321645,0.3330266377996383},
{0.042914889382136265,0.44860040992837014,0.32367066735513217},
{0.04411689326928858,0.46590243154491334,0.3122495224270138},
{0.031141819372787833,0.47618214985395996,0.324135758761348},
{0.02574023535489069,0.4754057401066559,0.30670503818697786},
{0.030581091327221303,0.46089360124314316,0.29711740961838323},
{0.03858372566175117,0.44589551286645634,0.30662204954865496},
{0.02910637878632887,0.4408556172990038,0.3164639695063352},
{0.02221432769994325,0.4526258026765389,0.32778592747902485},
{0.013771454171743422,0.46317090711241476,0.3143468716500826},
{0.022177271275879297,0.4528554637478334,0.3015073754488099},
{-0.06584127735047013,0.4528554637478334,0.3015073754488099},
{-0.057435460246334266,0.46317090711241476,0.3143468716500826},
{-0.06397336730394101,0.45472093295205895,0.2942500855959017},
{-0.06584127735047013,0.4528554637478334,0.3015073754488099},
{-0.04732105352966878,0.46825917573642983,0.3140406568883565},
{-0.047528303230721075,0.4584332322011005,0.2847813926159195},
{-0.021832003037295416,0.4597444083076508,0.28068610301996544},
{-0.021832003037295416,0.4732143075075206,0.3128233422631179},
{0.003657047455077948,0.46825917573642983,0.3140406568883565},
{0.0038642971561302407,0.4584332322011005,0.2847813926159195},
{0.020309361229350183,0.45472093295205895,0.2942500855959017},
{0.022177271275879297,0.4528554637478334,0.3015073754488099},
{0.013771454171743422,0.46317090711241476,0.3143468716500826},
{-0.057435460246334266,0.46317090711241476,0.3143468716500826},
{-0.07502283851764542,0.42844304660610855,0.31336698441255917},
{-0.0727703848609197,0.4408556172990038,0.3164639695063352},
{-0.06795415920638012,0.4313678413701024,0.2926644256775723},
{-0.05118046900119181,0.4317355209789286,0.2786657512768379},
{-0.021832003037295416,0.43156333064914637,0.2716205928095892},
{0.007516462926600972,0.4317355209789286,0.2786657512768379},
{0.024290153131789276,0.4313678413701024,0.2926644256775723},
{0.03135883244305458,0.42844304660610855,0.31336698441255917},
{0.02910637878632887,0.4408556172990038,0.3164639695063352},
{-0.06308645396870974,0.4525354915113052,0.33429099411291024},
{-0.06587833377453409,0.4526258026765389,0.32778592747902485},
{-0.07136157506222485,0.4267937028931303,0.34234888024140375},
{-0.07112902935911693,0.4102088451243398,0.34421878734072675},
{-0.06977391809110156,0.41163296566112095,0.31623342085602113},
{-0.0667914306908405,0.39966862237307116,0.3536084857879738},
{-0.062349319593018405,0.39461097522522864,0.3221611173377245},
{-0.06081225462600639,0.38325351409175923,0.352743540033475},
{-0.059359953455356225,0.38569235934257906,0.36098071712390667},
{-0.06189399155601701,0.39697437625939136,0.36356224070211046},
{-0.04648295704050978,0.39870604292642786,0.3737294583704359},
{-0.04035888370074298,0.3879485852101376,0.3740456583961314},
{-0.02765851551077622,0.4023519956437621,0.3768279967274961},
{-0.03079499787091984,0.3903390574043949,0.3780650599859186},
{-0.041800977712668934,0.37622987941573327,0.3801002786776227},
{-0.021832003037295416,0.38807129300958293,0.3785749741326189},
{-0.021832003037295416,0.37144494092163094,0.38297004354240777},
{-0.0018630283619218962,0.37622987941573327,0.3801002786776227},
{-0.012869008203670996,0.3903390574043949,0.3780650599859186},
{-0.0033051223738478526,0.3879485852101376,0.3740456583961314},
{-0.016005490563814614,0.4023519956437621,0.3768279967274961},
{0.0028189509659189487,0.39870604292642786,0.3737294583704359},
{0.015695947380765393,0.38569235934257906,0.36098071712390667},
{0.018229985481426177,0.39697437625939136,0.36356224070211046},
{0.02312742461624965,0.39966862237307116,0.3536084857879738},
{0.01714824855141555,0.38325351409175923,0.352743540033475},
{0.01868531351842757,0.39461097522522864,0.3221611173377245},
{0.02610991201651073,0.41163296566112095,0.31623342085602113},
{0.02746502328452609,0.4102088451243398,0.34421878734072675},
{0.02769756898763401,0.4267937028931303,0.34234888024140375},
{0.01942244789411891,0.4525354915113052,0.33429099411291024},
{0.02221432769994325,0.4526258026765389,0.32778592747902485},
{-0.04701372929416833,0.4617028514141685,0.3431980714683064},
{-0.05202966022809451,0.4374615151284515,0.36665234705848543},
{-0.06546938174130135,0.4283660491261673,0.35548593730896244},
{-0.064302659120174,0.41555251461121484,0.3549544993710393},
{-0.059414095775545475,0.40635719596923736,0.3589661346444059},
{-0.04556608791337052,0.4043821107561041,0.3667450990660228},
{-0.028704527385252133,0.41319998642004097,0.372602676805186},
{-0.021832003037295416,0.4090139418693435,0.3766447116599702},
{-0.021832003037295416,0.41364577298258276,0.37359499014898234},
{-0.014959478689338702,0.41319998642004097,0.372602676805186},
{0.00190208183877969,0.4043821107561041,0.3667450990660228},
{0.015750089700954643,0.40635719596923736,0.3589661346444059},
{0.02063865304558316,0.41555251461121484,0.3549544993710393},
{0.021805375666710515,0.4283660491261673,0.35548593730896244},
{0.008365654153503668,0.4374615151284515,0.36665234705848543},
{0.0033497232195774953,0.4617028514141685,0.3431980714683064},
{-0.062174244631422834,0.425054713699183,0.3562499209499936},
{-0.05125191911226123,0.43165497318290935,0.36334589331610834},
{-0.03021873719251213,0.4264664081296912,0.37133099796500324},
{-0.021832003037295416,0.4323128911311107,0.37376673668925486},
{-0.021832003037295416,0.4262316434790346,0.37495542689111466},
{-0.013445268882078705,0.4264664081296912,0.37133099796500324},
{0.007587913037670395,0.43165497318290935,0.36334589331610834},
{0.018510238556832002,0.425054713699183,0.3562499209499936},
{-0.021832003037295416,0.4659692218661304,0.34979367116218046},
{-0.064302659120174,0.41555251461121484,0.3549544993710393},
{-0.059414095775545475,0.40635719596923736,0.3589661346444059},
{-0.043569035119504766,0.40630172228051886,0.3150183251783313},
{-0.04556608791337052,0.4043821107561041,0.3667450990660228},
{-0.028704527385252133,0.41319998642004097,0.372602676805186},
{-0.03021873719251213,0.4264664081296912,0.37133099796500324},
{-0.05125191911226123,0.43165497318290935,0.36334589331610834},
{-0.062174244631422834,0.425054713699183,0.3562499209499936},
{0.015750089700954643,0.40635719596923736,0.3589661346444059},
{0.02063865304558316,0.41555251461121484,0.3549544993710393},
{-9.49709550860726e-05,0.40630172228051886,0.3150183251783313},
{0.00190208183877969,0.4043821107561041,0.3667450990660228},
{-0.014959478689338702,0.41319998642004097,0.372602676805186},
{-0.013445268882078705,0.4264664081296912,0.37133099796500324},
{0.007587913037670395,0.43165497318290935,0.36334589331610834},
{0.018510238556832002,0.425054713699183,0.3562499209499936},
{-0.06785253140864782,0.4135716601344549,0.2922332841688522},
{-0.06473579768168798,0.3930455077295928,0.3056816595774991},
{-0.05098364835361859,0.4128569371290058,0.28275660297769445},
{-0.021832003037295416,0.4116573740841571,0.27498806760955663},
{0.007319642279027758,0.4128569371290058,0.28275660297769445},
{0.024188525334056993,0.4135716601344549,0.2922332841688522},
{-0.051126104786247684,0.3905409816313303,0.2975505481798971},
{-0.021832003037295416,0.3875318668604843,0.2903158915919861},
{0.007462098711656849,0.3905409816313303,0.2975505481798971},
{0.021071791607097157,0.3930455077295928,0.3056816595774991},
{-0.021832003037295416,0.37144494092163094,0.38297004354240777},
{-0.041800977712668934,0.37622987941573327,0.3801002786776227},
{-0.021832003037295416,0.3666719847442918,0.3723834447873705},
{-0.0018630283619218962,0.37622987941573327,0.3801002786776227},
{0.0006483764737417377,0.37136461502036655,0.3691151569428317},
{-0.0033051223738478526,0.3879485852101376,0.3740456583961314},
{-0.0010852872460886194,0.3829295477496432,0.36414959611826186},
{-0.04431238254833257,0.37136461502036655,0.3691151569428317},
{-0.04035888370074298,0.3879485852101376,0.3740456583961314},
{-0.04257871882850221,0.3829295477496432,0.36414959611826186},
{-0.02765851551077622,0.4023519956437621,0.3768279967274961},
{-0.03079499787091984,0.3903390574043949,0.3780650599859186},
{-0.021832003037295416,0.39096879471872725,0.3543518332168016},
{-0.021832003037295416,0.38807129300958293,0.3785749741326189},
{-0.012869008203670996,0.3903390574043949,0.3780650599859186},
{-0.016005490563814614,0.4023519956437621,0.3768279967274961},
{-0.021832003037295416,0.4090139418693435,0.3766447116599702},
{-0.0520800303374509,0.3903122081390552,0.3190213065562578},
{-0.051126104786247684,0.3905409816313303,0.2975505481798971},
{-0.021832003037295416,0.38607091179439407,0.3137750488667724},
{-0.021832003037295416,0.37617218677946607,0.36371912029380643},
{0.008416024262860061,0.3903122081390552,0.3190213065562578},
{0.007462098711656849,0.3905409816313303,0.2975505481798971},
{-0.021832003037295416,0.3875318668604843,0.2903158915919861},
{-0.062349319593018405,0.39461097522522864,0.3221611173377245},
{-0.06473579768168798,0.3930455077295928,0.3056816595774991},
{-0.04257871882850221,0.3829295477496432,0.36414959611826186},
{0.021071791607097157,0.3930455077295928,0.3056816595774991},
{0.01868531351842757,0.39461097522522864,0.3221611173377245},
{-0.0010852872460886194,0.3829295477496432,0.36414959611826186},
{-0.021832003037295416,0.3666719847442918,0.3723834447873705},
{-0.04431238254833257,0.37136461502036655,0.3691151569428317},
{-0.021832003037295416,0.37617218677946607,0.36371912029380643},
{0.0006483764737417377,0.37136461502036655,0.3691151569428317},
{-0.07738690523607272,0.463115877213206,0.3084167343260757},
{-0.08021983557154876,0.4563261196088172,0.30923352891876676},
{-0.07707181468415168,0.4677161992712532,0.3142075217440218},
{-0.07958987636246155,0.4655265418301568,0.32081510375465894},
{-0.08242280669793757,0.4587365623310133,0.3216318983473501},
{-0.08273767535510373,0.454136240272966,0.315841110929404},
{0.036555829496957924,0.4563261196088172,0.30923352891876676},
{0.03372289916148189,0.463115877213206,0.3084167343260757},
{0.03340780860956086,0.4677161992712532,0.3142075217440218},
{0.03592587028787071,0.4655265418301568,0.32081510375465894},
{0.03875880062334673,0.4587365623310133,0.3216318983473501},
{0.0390736692805129,0.454136240272966,0.315841110929404},
{0.1272808284485052,0.049031862089747066,0.19435639537296182},
{0.03940939604463722,0.04230467880623281,0.25624661471814597},
{0.050904653820883425,0.1352608295180379,0.2809490483044911},
{0.13972024840674016,0.13489115285641787,0.21986186607719585},
{0.16490707824297518,0.22239867786229253,0.2524462232514194},
{0.07408178286222486,0.23278446186416887,0.30594282970398573},
{0.1962066647864784,0.31411443689435203,0.2766600445875321},
{0.10259193044220738,0.3309089852064986,0.317902735096938},
{0.2259603105727747,0.40411051157613836,0.2747164684295909},
{0.1276500613206155,0.42067939292257794,0.3023172913040999},
{0.2515281337031283,0.4939142035054489,0.25461835100688074},
{0.14800491097471485,0.5129882766344157,0.25813893318771125},
{0.262087661298071,0.5751467667382424,0.21511376211240257},
{0.15368297585718496,0.5812029402830178,0.20658479341931163},
{0.26488109436717944,0.6450804490528533,0.15537081831013386},
{0.16352223307780672,0.6296090591640204,0.14081940407500843},
{0.26316584791200365,0.6724573801196944,0.06123285613387},
{0.16099329855650804,0.656555292511651,0.05552017566963954},
{0.2520926339595277,0.6384067424052636,-0.026534285735207216},
{0.14635578915649147,0.6387324839054186,-0.021852528302121234},
{0.21713755322423064,0.5596136901075546,-0.093610407396551},
{0.12020127629425108,0.5888791674331281,-0.06967240124074671},
{0.17693732427322253,0.47296800432961034,-0.13659142141563974},
{0.08232228837397963,0.5035723946060935,-0.1055763039478849},
{0.1293448934583429,0.38133900614670657,-0.1418221464722839},
{0.04080844247411763,0.4309300430187361,-0.12698914779322337},
{0.07669104328478793,0.29414657169275293,-0.12114088963376492},
{-0.009059740946749488,0.34301911334850055,-0.1135112603821782},
{0.017356607726242212,0.21086103818786536,-0.09066564210461849},
{-0.06279022447095298,0.2657003298021741,-0.09590701810949662},
{-0.04716594909601188,0.13231428906806642,-0.06907927656096857},
{-0.11848048247020342,0.18940248402302287,-0.07132241063798958},
{-0.07594791775071502,0.08526749745542185,-0.06487326148233238},
{-0.15661797777990305,0.12741063688010645,-0.04455990614739446},
{-0.17261570202729706,0.08969895760501,-0.029456639656897453},
{-0.09456865989547426,0.13525639162294043,0.2809483826202265},
{-0.08307340211922805,0.04230467880623281,0.25624661471814597},
{-0.17094483452309603,0.049031862089747066,0.19435639537296182},
{-0.183384254481331,0.13657755299346006,0.22010373136000846},
{-0.20857108431756602,0.2227774522088624,0.2523441516641774},
{-0.1177457889368157,0.23274097049221357,0.3059537025469746},
{-0.23987067086106928,0.31411443689435203,0.2766600445875321},
{-0.14625593651679822,0.3309089852064986,0.317902735096938},
{-0.2696243166473655,0.40411051157613836,0.2747164684295909},
{-0.17131406739520633,0.42067939292257794,0.3023172913040999},
{-0.29519213977771913,0.4939142035054489,0.25461835100688074},
{-0.1916689170493057,0.5129882766344157,0.25813893318771125},
{-0.30575166737266185,0.5751467667382424,0.21511376211240257},
{-0.1973469819317758,0.5812029402830178,0.20658479341931163},
{-0.3085451004417703,0.6450804490528533,0.15537081831013386},
{-0.20718623915239753,0.6296090591640204,0.14081918218025355},
{-0.30682985398659446,0.6724573801196944,0.06123285613387},
{-0.20465730463109888,0.656555292511651,0.05552017566963954},
{-0.2957564181393637,0.6384067424052636,-0.026534285735207216},
{-0.1900197952310823,0.6387324839054186,-0.021852528302121234},
{-0.2608015592988215,0.5596136901075546,-0.093610407396551},
{-0.1638652823688419,0.5888791674331281,-0.06967240124074671},
{-0.22060133034781337,0.47296800432961034,-0.13659142141563974},
{-0.12598629444857048,0.5035723946060935,-0.1055763039478849},
{-0.17300889953293375,0.38133900614670657,-0.1418221464722839},
{-0.08447244854870846,0.4309300430187361,-0.12698914779322337},
{-0.12035504935937875,0.29414657169275293,-0.12114088963376492},
{-0.029605863879550217,0.3396689463394133,-0.12866955677188396},
{-0.06260072635029061,0.20925917995243018,-0.09997168622927807},
{0.01634343627548765,0.26224786931109,-0.1205448803221734},
{-0.006560540322603923,0.13590498999143702,-0.07831941794343057},
{0.06567885038990236,0.19199421475995088,-0.0928584060722831},
{0.032283911676124176,0.08526749745542185,-0.06487326148233238},
{0.11313925382563197,0.12584583506873517,-0.05316143442532918},
{0.12895169595270622,0.08969895760501,-0.029456639656897453},
{-0.17777630834140107,0.08852513435172667,-0.04091861321991257},
{-0.16035823576805874,0.12262103859615171,-0.05561625609849997},
{-0.07854519585651487,0.08505780691206595,-0.07722592059141165},
{-0.04816935717755198,0.1279176663949935,-0.08086210993953144},
{-0.11948389055174354,0.18690949645201377,-0.08242913069845145},
{0.016174574367028554,0.206104280327632,-0.10229337104952446},
{-0.06397203593541177,0.2609497849950772,-0.10747261652303787},
{0.07870695713281799,0.29526336799403363,-0.13354991001058214},
{-0.008881781353340562,0.3442477446062377,-0.12607338813985847},
{0.1306451967219044,0.385113214032358,-0.1537991377613615},
{0.042108745737679115,0.43470447279914237,-0.138966139082301},
{0.1746835392479676,0.4780156662134835,-0.14794156002219835},
{0.08006872524347956,0.5086202783847216,-0.11692666444919841},
{0.2183124859512883,0.5681779400666704,-0.10281127340740032},
{0.12137643091606364,0.597443417392244,-0.07887348914635091},
{0.25103597113681786,0.6509056301578048,-0.027963509851350488},
{0.1452993482285365,0.6512315935527146,-0.023281530523509637},
{0.26100259594673725,0.684429045934655,0.06460720967123851},
{0.15883004659124167,0.6685267364318569,0.058894751101762934},
{0.26243448279993903,0.6569032234872936,0.15906159376795267},
{0.16107562151056629,0.6414318335984606,0.14451017953282722},
{0.26137071934507317,0.5821730641513269,0.2258366042469325},
{0.15296603390418717,0.5882292376961022,0.21730763555384153},
{0.25224995734073336,0.49611784031610234,0.2672472690857781},
{0.1487267346123199,0.5151916915503143,0.27076762937185367},
{0.22968037613823686,0.4050076320700938,0.2864225262229674},
{0.13136990499132278,0.42157651341653346,0.31402334909747637},
{0.20112939992335754,0.3120630198855422,0.288002638772425},
{0.10751466557908648,0.3288573463029338,0.329245329281831},
{0.17023832162357727,0.2182117457325755,0.26222712215150934},
{0.07941302624282695,0.22823140338890976,0.3158153711378386},
{0.1465541630673488,0.13367184117838538,0.22928129842159606},
{0.0577383465867372,0.1323884019161943,0.29013127515593096},
{0.04655507283584381,0.04076827952348541,0.2655169337872708},
{0.13442672713446666,0.04749546280699967,0.2036267144420867},
{0.11687951181378768,0.12101851467645189,-0.064203139322613},
{0.13411230226681023,0.08852513435172667,-0.04091861321991257},
{0.03488118978192403,0.08505780691206595,-0.07722592059141165},
{-0.006951518880691864,0.130504959236824,-0.08971571065900301},
{0.06528764993705953,0.18637362061899312,-0.10414974256880012},
{-0.06299503332970166,0.20351632180153684,-0.11120044840492065},
{0.0159491292960766,0.25644754041868423,-0.13175145302232857},
{-0.1223709632074088,0.29526336799403363,-0.13354991001058214},
{-0.03162199962233514,0.3407167333719282,-0.14108678725463153},
{-0.17430920279649523,0.385113214032358,-0.1537991377613615},
{-0.08577275181226995,0.43470447279914237,-0.138966139082301},
{-0.21834754532255843,0.4780156662134835,-0.14794156002219835},
{-0.12373273131807039,0.5086202783847216,-0.11692666444919841},
{-0.26197649202587914,0.5681779400666704,-0.10281127340740032},
{-0.16504043699065446,0.597443417392244,-0.07887348914635091},
{-0.2946999772114087,0.6509056301578048,-0.027963509851350488},
{-0.18896335430312733,0.6512315935527146,-0.023281530523509637},
{-0.3046666020213281,0.684429045934655,0.06460720967123851},
{-0.2024940526658325,0.6685267364318569,0.058894751101762934},
{-0.30609848887452984,0.6569032234872936,0.15906159376795267},
{-0.20473962758515712,0.6414318335984606,0.14451017953282722},
{-0.305034725419664,0.5821730641513269,0.2258363823521776},
{-0.19663003997877798,0.5882292376961022,0.21730763555384153},
{-0.2959139634153242,0.49611784031610234,0.2672472690857781},
{-0.19239074068691073,0.5151916915503143,0.27076762937185367},
{-0.2733443822128277,0.4050076320700938,0.2864225262229674},
{-0.17503391106591362,0.42157651341653346,0.31402334909747637},
{-0.24479340599794838,0.3120630198855422,0.288002638772425},
{-0.15117867165367732,0.3288573463029338,0.329245329281831},
{-0.2139023276981681,0.218212633311595,0.26222690025675444},
{-0.12307703231741779,0.22823140338890976,0.3158153711378386},
{-0.19021816914193965,0.1335009822171324,0.22925533673527576},
{-0.10140235266132804,0.1323859610738907,0.29013105326117616},
{-0.09021907891043464,0.04076827952348541,0.2655169337872708},
{-0.1780907332090575,0.04749546280699967,0.2036267144420867},
{-0.17261570202729706,0.08969895760501,-0.029456639656897453},
{-0.15661797777990305,0.1274485808831899,-0.044574551201216145},
{-0.16035823576805874,0.12262103859615171,-0.05561625609849997},
{-0.11948389055174354,0.18690949645201377,-0.08242913069845145},
{-0.11848048247020342,0.19154154946000798,-0.07073416764281866},
{-0.06397203593541177,0.2609497849950772,-0.10747261652303787},
{-0.06279022447095298,0.2657003298021741,-0.09590701810949662},
{-0.008881781353340562,0.3442477446062377,-0.12607338813985847},
{-0.009059740946749488,0.34301911334850055,-0.1135112603821782},
{0.042108745737679115,0.43470447279914237,-0.138966139082301},
{0.04080844247411763,0.4309300430187361,-0.12698914779322337},
{0.08006872524347956,0.5086202783847216,-0.11692666444919841},
{0.08232228837397963,0.5035723946060935,-0.1055763039478849},
{0.12137643091606364,0.597443417392244,-0.07887348914635091},
{0.12020127629425108,0.5888791674331281,-0.06967240124074671},
{0.1452993482285365,0.6512315935527146,-0.023281530523509637},
{0.14635578915649147,0.6387324839054186,-0.021852528302121234},
{0.15883004659124167,0.6685267364318569,0.058894751101762934},
{0.16099329855650804,0.656555292511651,0.05552017566963954},
{0.16107562151056629,0.6414318335984606,0.14451017953282722},
{0.16352223307780672,0.6296090591640204,0.14081940407500843},
{0.15296603390418717,0.5882292376961022,0.21730763555384153},
{0.15368297585718496,0.5812029402830178,0.20658479341931163},
{0.1487267346123199,0.5151916915503143,0.27076762937185367},
{0.14800491097471485,0.5129882766344157,0.25813893318771125},
{0.13136990499132278,0.42157651341653346,0.31402334909747637},
{0.1276500613206155,0.42067939292257794,0.3023172913040999},
{0.10751466557908648,0.3288573463029338,0.329245329281831},
{0.10259193044220738,0.3309089852064986,0.317902735096938},
{0.07941302624282695,0.22823140338890976,0.3158153711378386},
{0.07408178286222486,0.23273941722892946,0.3059541463364843},
{0.0577383465867372,0.1323884019161943,0.29013127515593096},
{0.050904653820883425,0.13525661351769527,0.2809483826202265},
{0.03940939604463722,0.04230467880623281,0.25624661471814597},
{0.04655507283584381,0.04076827952348541,0.2655169337872708},
{-0.17777630834140107,0.08852513435172667,-0.04091861321991257},
{0.11313925382563197,0.12584583506873517,-0.05316143442532918},
{0.12895169595270622,0.08969895760501,-0.029456639656897453},
{0.11687951181378768,0.12101851467645189,-0.064203139322613},
{0.06528764993705953,0.18637362061899312,-0.10414974256880012},
{0.06567885038990236,0.19199421475995088,-0.0928584060722831},
{0.0159491292960766,0.25644754041868423,-0.13175145302232857},
{0.01634343627548765,0.2622432095212376,-0.12054798684874166},
{-0.03162199962233514,0.3407167333719282,-0.14108678725463153},
{-0.029605863879550217,0.3396689463394133,-0.12866955677188396},
{-0.08577275181226995,0.43470447279914237,-0.138966139082301},
{-0.08447244854870846,0.4309300430187361,-0.12698914779322337},
{-0.12373273131807039,0.5086202783847216,-0.11692666444919841},
{-0.12598629444857048,0.5035723946060935,-0.1055763039478849},
{-0.16504043699065446,0.597443417392244,-0.07887348914635091},
{-0.1638652823688419,0.5888791674331281,-0.06967240124074671},
{-0.18896335430312733,0.6512315935527146,-0.023281530523509637},
{-0.1900197952310823,0.6387324839054186,-0.021852528302121234},
{-0.2024940526658325,0.6685267364318569,0.058894751101762934},
{-0.20465730463109888,0.656555292511651,0.05552017566963954},
{-0.20473962758515712,0.6414318335984606,0.14451017953282722},
{-0.20718623915239753,0.6296090591640204,0.14081918218025355},
{-0.19663003997877798,0.5882292376961022,0.21730763555384153},
{-0.1973469819317758,0.5812029402830178,0.20658479341931163},
{-0.19239074068691073,0.5151916915503143,0.27076762937185367},
{-0.1916689170493057,0.5129882766344157,0.25813893318771125},
{-0.17503391106591362,0.42157651341653346,0.31402334909747637},
{-0.17131406739520633,0.42067939292257794,0.3023172913040999},
{-0.15117867165367732,0.3288573463029338,0.329245329281831},
{-0.14625593651679822,0.3309089852064986,0.317902735096938},
{-0.12307703231741779,0.22823140338890976,0.3158153711378386},
{-0.1177457889368157,0.23278446186416887,0.30594282970398573},
{-0.10140235266132804,0.1323884019161943,0.29013127515593096},
{-0.09456865989547426,0.13525661351769527,0.2809483826202265},
{-0.08307340211922805,0.04230467880623281,0.25624661471814597},
{-0.09021907891043464,0.04076827952348541,0.2655169337872708},
{0.13411230226681023,0.08852513435172667,-0.04091861321991257},
{-0.07854519585651487,0.08505780691206595,-0.07722592059141165},
{-0.04816935717755198,0.1279176663949935,-0.08086210993953144},
{-0.04716594909601188,0.13232249917399672,-0.0690814955085173},
{0.017356607726242212,0.21086103818786536,-0.09066564210461849},
{0.016174574367028554,0.206104280327632,-0.10229337104952446},
{0.07669104328478793,0.29414657169275293,-0.12114088963376492},
{0.07870695713281799,0.2952646993625629,-0.13354902243156266},
{0.1293448934583429,0.38133900614670657,-0.1418221464722839},
{0.1306451967219044,0.385113214032358,-0.1537991377613615},
{0.17693732427322253,0.47296800432961034,-0.13659142141563974},
{0.1746835392479676,0.4780156662134835,-0.14794156002219835},
{0.21713755322423064,0.5596136901075546,-0.093610407396551},
{0.2183124859512883,0.5681779400666704,-0.10281127340740032},
{0.2520926339595277,0.6384067424052636,-0.026534285735207216},
{0.25103597113681786,0.6509056301578048,-0.027963509851350488},
{0.26316584791200365,0.6724573801196944,0.06123285613387},
{0.26100259594673725,0.684429045934655,0.06460720967123851},
{0.26488109436717944,0.6450804490528533,0.15537081831013386},
{0.26243448279993903,0.6569032234872936,0.15906159376795267},
{0.262087661298071,0.5751467667382424,0.21511376211240257},
{0.26137071934507317,0.5821730641513269,0.2258366042469325},
{0.2515281337031283,0.4939142035054489,0.25461835100688074},
{0.25224995734073336,0.49611784031610234,0.2672472690857781},
{0.2259603105727747,0.40411051157613836,0.2747164684295909},
{0.22968037613823686,0.4050076320700938,0.2864225262229674},
{0.1962066647864784,0.31411443689435203,0.2766600445875321},
{0.20112939992335754,0.3120630198855422,0.288002638772425},
{0.16490707824297518,0.22277723031410754,0.2523441516641774},
{0.17023832162357727,0.218212633311595,0.26222690025675444},
{0.13972024840674016,0.13657755299346006,0.22010373136000846},
{0.1465541630673488,0.13367161928363047,0.22928107652684118},
{0.13442672713446666,0.04749546280699967,0.2036267144420867},
{0.1272808284485052,0.049031862089747066,0.19435639537296182},
{-0.07594791775071502,0.08526749745542185,-0.06487326148233238},
{-0.006951518880691864,0.130504959236824,-0.08971571065900301},
{0.03488118978192403,0.08505780691206595,-0.07722592059141165},
{-0.006560540322603923,0.13590565567570168,-0.07831963983818546},
{-0.06260072635029061,0.2092596237419399,-0.0999714643345232},
{-0.06299503332970166,0.20351632180153684,-0.11120044840492065},
{-0.12035504935937875,0.29414657169275293,-0.12114088963376492},
{-0.1223709632074088,0.29526336799403363,-0.13354991001058214},
{-0.17300889953293375,0.38133900614670657,-0.1418221464722839},
{-0.17430920279649523,0.385113214032358,-0.1537991377613615},
{-0.22060133034781337,0.47296800432961034,-0.13659142141563974},
{-0.21834754532255843,0.4780156662134835,-0.14794156002219835},
{-0.2608015592988215,0.5596136901075546,-0.093610407396551},
{-0.26197649202587914,0.5681779400666704,-0.10281127340740032},
{-0.2957564181393637,0.6384067424052636,-0.026534285735207216},
{-0.2946999772114087,0.6509056301578048,-0.027963509851350488},
{-0.30682985398659446,0.6724573801196944,0.06123285613387},
{-0.3046666020213281,0.684429045934655,0.06460720967123851},
{-0.3085451004417703,0.6450804490528533,0.15537081831013386},
{-0.30609848887452984,0.6569032234872936,0.15906159376795267},
{-0.30575166737266185,0.5751467667382424,0.21511376211240257},
{-0.305034725419664,0.5821730641513269,0.2258363823521776},
{-0.29519213977771913,0.4939142035054489,0.25461835100688074},
{-0.2959139634153242,0.49611784031610234,0.2672472690857781},
{-0.2696243166473655,0.40411051157613836,0.2747164684295909},
{-0.2733443822128277,0.4050076320700938,0.2864225262229674},
{-0.23987067086106928,0.31411443689435203,0.2766600445875321},
{-0.24479340599794838,0.3120630198855422,0.288002638772425},
{-0.20857108431756602,0.22239867786229253,0.2524462232514194},
{-0.2139023276981681,0.2182117457325755,0.26222712215150934},
{-0.183384254481331,0.13489115285641787,0.21986186607719585},
{-0.19021816914193965,0.13367161928363047,0.22928107652684118},
{-0.1780907332090575,0.04749546280699967,0.2036267144420867},
{-0.17094483452309603,0.049031862089747066,0.19435639537296182},
{0.032283911676124176,0.08526749745542185,-0.06487326148233238},
{0.0870817089712715,0.8814640438410781,-0.024822811490864263},
{0.07758949514727263,0.9034185327830639,0.01038811389680252},
{0.059531034311364035,0.9018672665517399,-0.00613927313047566},
{0.04216843542674021,0.9016331675853478,-0.025651588400318538},
{0.03147443961034392,0.9146665998023804,0.010143807771686284},
{0.0517378686254352,0.9126245023732754,0.03844160207125441},
{-0.0019930586882780455,0.8928689904520906,0.028448793680259876},
{-0.0015155411757892536,0.8980289310819298,0.03548640772584282},
{0.01228764394590116,0.9087102788972985,-0.0188875705874952},
{-0.012581210706599451,0.8990625168501328,0.025979770742777172},
{-0.03685028383667571,0.8829409753295191,-0.08050397180516485},
{-0.02072474821047429,0.9139026161613494,-0.04492336975587804},
{-0.05354342624584476,0.8721027479224548,-0.059594385263880556},
{-0.04425824022814333,0.841987413685714,-0.09020055069840263},
{-0.06410805742014952,0.8521193500880144,-0.0421425846877974},
{-0.06202379998761829,0.8644362841415589,-0.003261298159760224},
{-0.048699463746945906,0.8958643477481344,-0.02514766541199974},
{-0.02104361097322819,0.8910401338824192,0.015180818707325487},
{-0.019408912314071623,0.9010680016446839,0.016210188475185853},
{-0.028307335774027716,0.893535340400977,0.02693746850481324},
{-0.021832003037295416,0.9381044551806987,0.17157534846907044},
{-0.10331907955392942,0.9059563430945575,0.08646228976304081},
{-0.06548180784757429,0.8970106560518133,0.06366659780532774},
{-0.021832003037295416,0.8909500446119404,0.051424886073685484},
{0.021817801772983456,0.8970106560518133,0.06366659780532774},
{0.059655073479338586,0.9059563430945575,0.08646228976304081},
{0.07409664981080141,0.9116563755577601,0.11838362540970093},
{0.08529811893159449,0.9201831253033024,0.16533677743578865},
{0.08082915856843266,0.9237838114906423,0.2013509618360992},
{0.07186505426103387,0.9268910037431425,0.24243832601709345},
{0.04798185610968345,0.9263664445426204,0.2698061593989847},
{0.01625134995221495,0.92116456580411,0.2820749422907216},
{-0.021832003037295416,0.9198520583290305,0.2914495518946373},
{-0.05991535602680579,0.92116456580411,0.2820749422907216},
{-0.09164586218427428,0.9263664445426204,0.2698061593989847},
{-0.1155292822303796,0.9268910037431425,0.24243832601709345},
{-0.12449316464302349,0.9237838114906423,0.2013509618360992},
{-0.1289621250061853,0.9201831253033024,0.16533677743578865},
{-0.11776087778014714,0.9116561536630052,0.11838362540970093},
{-0.037485346625125024,0.9111504555166474,0.019753403921013463},
{-0.008377858365021766,0.9157015169391126,0.026388057091745274},
{-0.013206732020589182,0.9010373801685113,0.014703744984346448},
{-0.02653506236684929,0.8852520092015316,0.01436158327233077},
{0.001033141978693208,0.8852832963619689,0.02309003535005341},
{0.005957652273611305,0.8974145045056838,0.03880462189022823},
{-0.012190232148511511,0.9162469342465929,0.059497195361245765},
{-0.04172353644321792,0.9152552865870611,0.048458153201020454},
{-0.047402932694217276,0.8908945709232219,0.03709403522490476},
{-0.02137933773735251,0.8768304375697997,0.041109664603859064},
{0.00038321224166733866,0.8924990918957155,0.054955453518485284},
{-0.02966422220008207,0.8961084319784955,0.06368590264900177},
{0.029367770807570415,0.9180817819746457,0.01049839558997489},
{-0.011974550446774007,0.909353551791678,0.03304867194879735},
{0.0517378686254352,0.9126245023732754,0.03844160207125441},
{0.07758949514727263,0.9034185327830639,0.01038811389680252},
{0.06335805314867546,0.9047536735231406,-0.0076991932572396905},
{0.0870817089712715,0.881464265735833,-0.024822811490864263},
{0.04216843542674021,0.9016331675853478,-0.025651588400318538},
{0.01228764394590116,0.9087105007920534,-0.0188875705874952},
{-0.012581210706599451,0.8990625168501328,0.025979770742777172},
{-0.0015155411757892536,0.8980291529766847,0.03548640772584282},
{-0.05119200752844525,0.89868906797768,-0.022836853434742194},
{-0.030975620201387253,0.906976615177468,0.02631039392753939},
{-0.02072474821047429,0.9139028380561043,-0.04492336975587804},
{-0.05657850270301097,0.8731352242168835,-0.06420447069114224},
{-0.03685028383667571,0.882941197224274,-0.08050397180516485},
{-0.04425824022814333,0.841987413685714,-0.09020055069840263},
{-0.06410805742014952,0.8521193500880144,-0.0421425846877974},
{-0.06202379998761829,0.8644362841415589,-0.003261298159760224},
{-0.028307335774027716,0.893535340400977,0.02693746850481324},
{-0.019408912314071623,0.9010680016446839,0.016210188475185853},
{-0.1289621250061853,0.9201831253033024,0.16533677743578865},
{-0.12449316464302349,0.9237838114906423,0.2013509618360992},
{-0.11454162867643551,0.9654660755094536,0.19801055819622643},
{-0.10268845466057759,0.9646670324971525,0.2277757425097761},
{-0.1155292822303796,0.9268910037431425,0.24243832601709345},
{-0.07717610521894246,0.965310749181042,0.2523752169298597},
{-0.09164586218427428,0.9263664445426204,0.2698061593989847},
{-0.05035790514487399,0.9648201398780156,0.2654434866234075},
{-0.05991535602680579,0.92116456580411,0.2820749422907216},
{-0.021832003037295416,0.9638051932692219,0.26913759050254943},
{-0.021832003037295416,0.9198520583290305,0.2914495518946373},
{0.01625134995221495,0.92116456580411,0.2820749422907216},
{0.006693899070283154,0.9648201398780156,0.2654434866234075},
{0.04798185610968345,0.9263664445426204,0.2698061593989847},
{0.033512099144351624,0.965310749181042,0.2523752169298597},
{0.07186505426103387,0.9268910037431425,0.24243832601709345},
{0.05902444858598676,0.9646670324971525,0.2277757425097761},
{0.08082915856843266,0.9237838114906423,0.2013509618360992},
{0.07087762260184469,0.9654660755094536,0.19801055819622643},
{0.08529811893159449,0.9201831253033024,0.16533677743578865},
{0.07844112721647896,0.9567635851180514,0.161696815876836},
{0.06891851381106237,0.9493143563021771,0.1156130475003445},
{0.07409664981080141,0.9116563755577601,0.11838362540970093},
{0.05456014801267728,0.921411090876775,0.07771763936821238},
{0.059655073479338586,0.9059563430945575,0.08646228976304081},
{0.021817801772983456,0.8970106560518133,0.06366659780532774},
{0.02030913933459531,0.9088487412243399,0.05364560878046422},
{-0.021832003037295416,0.8909500446119404,0.051424886073685484},
{-0.021832003037295416,0.9082165630677038,0.04056247213833985},
{-0.06397314540918614,0.9088487412243399,0.05364560878046422},
{-0.06548180784757429,0.8970106560518133,0.06366659780532774},
{-0.09822437598202298,0.921411090876775,0.07771763936821238},
{-0.10331907955392942,0.9059563430945575,0.08646228976304081},
{-0.11776087778014714,0.9116561536630052,0.11838362540970093},
{-0.11258251988565321,0.9493143563021771,0.1156130475003445},
{-0.12210513329106977,0.9567635851180514,0.161696815876836},
{-0.09179652872283371,0.9828104790241778,0.1556954503365145},
{-0.08954163422380439,0.9880547396608693,0.1785395153507901},
{-0.06513187981913804,0.9936433809571252,0.21072246491344662},
{-0.021832003037295416,0.9958232750290071,0.22848691519914718},
{0.0214678737445472,0.9936433809571252,0.21072246491344662},
{0.045877628149213555,0.9880547396608693,0.1785395153507901},
{0.04813252264824288,0.9828104790241778,0.1556954503365145},
{0.04751521144018348,0.9736803974401332,0.11845174709944724},
{0.03256838075187261,0.9638367023244141,0.08803152946950955},
{0.046471862302766065,0.9422567717286554,0.0797910239577548},
{0.012707690716877587,0.9256408486941826,0.05660213449440505},
{0.007175632583114553,0.9449456923682182,0.06362909759175404},
{-0.021832003037295416,0.9562123985469443,0.061622059533918944},
{-0.05083986055246026,0.9449456923682182,0.06362909759175404},
{-0.05637169679146842,0.9256408486941826,0.05660213449440505},
{-0.09013586837735689,0.9422567717286554,0.0797910239577548},
{-0.07623238682646345,0.9638367023244141,0.08803152946950955},
{-0.09117921751477431,0.9736803974401332,0.11845174709944724},
{-0.06394074877497453,0.9917093462736437,0.12060035401089192},
{-0.05805299334914853,0.9965641816155313,0.14825376594230605},
{-0.041189879557746015,0.9997705608234602,0.1657133328348098},
{-0.021832003037295416,1.0,0.16842333347608562},
{-0.0024741265168448214,0.9997705608234602,0.1657133328348098},
{0.014388987274557688,0.9965641816155313,0.14825376594230605},
{0.020276742700383706,0.9917093462736437,0.12060035401089192},
{0.013063388008940573,0.9810095811936206,0.09870111686286971},
{-0.021832003037295416,0.9924904158108001,0.125424567876607},
{-0.021832003037295416,0.982132146758528,0.09534562437966548},
{-0.004736343542784983,0.9676115758943301,0.07701512057428138},
{-0.03892766253180585,0.9676115758943301,0.07701512057428138},
{-0.056727394083531404,0.9810095811936206,0.09870111686286971},
{-0.021832003037295416,0.041092689655111155,0.2779401554284},
{-0.09043453871741727,0.04321711003827459,0.2716569835493886},
{-0.09285918270392517,-0.041651864437393646,0.2762832672937561},
{-0.161600846395353,-0.03171763626168585,0.25370858251189743},
{-0.1531313454965683,0.05195155327437881,0.24286636099924536},
{-0.2257153387633939,-0.014876046261506128,0.20799892869212347},
{-0.20360574538775109,0.06699069218071725,0.19506468343051955},
{-0.25329197510962154,-0.0012079950455339634,0.1342147066961846},
{-0.23418195503036518,0.08131111397601891,0.13024123732065634},
{-0.2542248206591118,0.00945804203174822,0.057177951383303005},
{-0.23883198151350418,0.09146146764297396,0.0586120571840535},
{-0.22275881304945302,0.015426123358838612,-0.00977679384712471},
{-0.22356895079949787,0.09886143582326612,-0.006581731271694362},
{-0.17517259528770984,0.019592863065862096,-0.0631724381862234},
{-0.17394729245129578,0.10108881537269106,-0.05921450144353633},
{-0.1073298272482765,0.019314828938005006,-0.09731782496098533},
{-0.1055726426844295,0.09961321525277912,-0.08445103570486309},
{-0.021832003037295416,0.01831474927778801,-0.10739362199030274},
{-0.021832003037295416,0.09730972580243241,-0.0883472857056952},
{0.06190863660983866,0.09961321525277912,-0.08445103570486309},
{0.06366582117368566,0.019314828938005006,-0.09731782496098533},
{0.13028328637670494,0.10108881537269106,-0.05921450144353633},
{0.131508589213119,0.019592863065862096,-0.0631724381862234},
{0.17990494472490706,0.09886143582326612,-0.006581731271694362},
{0.1790948069748622,0.015426123358838612,-0.00977679384712471},
{0.19516797543891334,0.09146146764297396,0.0586120571840535},
{0.21056081458452094,0.00945804203174822,0.057177951383303005},
{0.19051794895577434,0.08131111397601891,0.13024123732065634},
{0.20962796903503073,-0.0012079950455339634,0.1342147066961846},
{0.15994173931316025,0.06699069218071725,0.19506468343051955},
{0.18205133268880302,-0.014876046261506128,0.20799892869212347},
{0.10946733942197746,0.05195155327437881,0.24286636099924536},
{0.11793684032076217,-0.03171763626168585,0.25370858251189743},
{0.046770532642826435,0.04321711003827459,0.2716569835493886},
{0.049195176629334335,-0.041651864437393646,0.2762832672937561},
{-0.021832003037295416,-0.04640107787596132,0.2859059552336208},
{-0.0925937965770959,0.01666518367005489,-0.06607060557963236},
{-0.15590636130102223,0.01895203101378606,-0.0421783097433321},
{-0.1073298272482765,0.019314828938005006,-0.09731782496098533},
{-0.021832003037295416,0.01831474927778801,-0.10739362199030274},
{-0.021832003037295416,0.015840844655698072,-0.07881845924714216},
{-0.17517259528770984,0.019592863065862096,-0.0631724381862234},
{-0.1920022029711264,0.015487588205938709,0.0025925073685700755},
{-0.22275881304945302,0.015426123358838612,-0.00977679384712471},
{-0.2181671448868459,0.010389556212709157,0.059916576447957594},
{-0.2542248206591118,0.00945804203174822,0.057177951383303005},
{-0.2182623377366868,0.002108222066057596,0.1255643615721776},
{-0.25329197510962154,-0.0012079950455339634,0.1342147066961846},
{-0.19173481979150325,-0.011573808519471637,0.18485153354793515},
{-0.2257153387633939,-0.014876046261506128,0.20799892869212347},
{-0.13830611313392838,-0.0256084298704956,0.22294287474862096},
{-0.161600846395353,-0.03171763626168585,0.25370858251189743},
{-0.08102131942615355,-0.0338871012800887,0.24041664290543663},
{-0.09285918270392517,-0.041651864437393646,0.2762832672937561},
{-0.021832003037295416,-0.040953117854295513,0.24761357738501913},
{-0.021832003037295416,-0.04640107787596132,0.2859059552336208},
{0.049195176629334335,-0.041651864437393646,0.2762832672937561},
{0.03735731335156271,-0.0338871012800887,0.24041664290543663},
{0.11793684032076217,-0.03171763626168585,0.25370858251189743},
{0.09464210705933752,-0.0256084298704956,0.22294287474862096},
{0.18205133268880302,-0.014876046261506128,0.20799892869212347},
{0.14807081371691241,-0.011573808519471637,0.18485153354793515},
{0.20962796903503073,-0.0012079950455339634,0.1342147066961846},
{0.17459833166209598,0.002108222066057596,0.1255643615721776},
{0.21056081458452094,0.00945804203174822,0.057177951383303005},
{0.17450313881225507,0.010389556212709157,0.059916576447957594},
{0.1790948069748622,0.015426123358838612,-0.00977679384712471},
{0.14833819689653557,0.015487588205938709,0.0025925073685700755},
{0.131508589213119,0.019592863065862096,-0.0631724381862234},
{0.11224235522643138,0.01895203101378606,-0.0421783097433321},
{0.06366582117368566,0.019314828938005006,-0.09731782496098533},
{0.048929790502505066,0.01666518367005489,-0.06607060557963236},
{-0.14942104330032058,0.0979279245895113,-0.031585276040403475},
{-0.09057388862347812,0.09650247268420088,-0.0527571421819488},
{-0.17394729245129578,0.10108881537269106,-0.05921450144353633},
{-0.22356895079949787,0.09886143582326612,-0.006581731271694362},
{-0.18825528814032447,0.09618494128997625,0.0077122850477772745},
{-0.23883198151350418,0.09146146764297396,0.0586120571840535},
{-0.2026653554165952,0.08999585278703136,0.06126724982087546},
{-0.23418195503036518,0.08131111397601891,0.13024123732065634},
{-0.19879018541747612,0.08153722473123548,0.12095804835574878},
{-0.20360574538775109,0.06699069218071725,0.19506468343051955},
{-0.1733102326100526,0.06960372481411317,0.17497766074555307},
{-0.1531313454965683,0.05195155327437881,0.24286636099924536},
{-0.131248084770897,0.05707088716407626,0.21481242903528372},
{-0.09043453871741727,0.04321711003827459,0.2716569835493886},
{-0.07900074578827114,0.04979229541470018,0.2374658864551226},
{-0.021832003037295416,0.041092689655111155,0.2779401554284},
{-0.021832003037295416,0.046780961696305474,0.24191132597426773},
{0.03533673971368031,0.04979229541470018,0.2374658864551226},
{0.046770532642826435,0.04321711003827459,0.2716569835493886},
{0.08758407869630618,0.05707088716407626,0.21481242903528372},
{0.10946733942197746,0.05195155327437881,0.24286636099924536},
{0.12964622653546176,0.06960372481411317,0.17497766074555307},
{0.15994173931316025,0.06699069218071725,0.19506468343051955},
{0.15512617934288528,0.08153722473123548,0.12095804835574878},
{0.19051794895577434,0.08131111397601891,0.13024123732065634},
{0.15900134934200436,0.08999585278703136,0.06126724982087546},
{0.19516797543891334,0.09146146764297396,0.0586120571840535},
{0.14459128206573363,0.09618494128997625,0.0077122850477772745},
{0.17990494472490706,0.09886143582326612,-0.006581731271694362},
{0.10575703722572975,0.0979279245895113,-0.031585276040403475},
{0.13028328637670494,0.10108881537269106,-0.05921450144353633},
{0.04690988254888728,0.09650247268420088,-0.0527571421819488},
{0.06190863660983866,0.09961321525277912,-0.08445103570486309},
{-0.021832003037295416,0.09462502116321221,-0.06204188441014048},
{-0.021832003037295416,0.09730972580243241,-0.0883472857056952},
{-0.1055726426844295,0.09961321525277912,-0.08445103570486309},
{-0.22176028665252012,0.033448859139212514,0.1414291708614021},
{-0.2272994454184392,0.042063479207684794,0.06476919284229651},
{-0.2695204699020845,-0.045613129601403825,0.05329834348908644},
{-0.269815368031312,-0.05176604925930424,0.14061770174282798},
{-0.2916910843353176,-0.12519302069989605,0.05114929278813201},
{-0.29604909732104245,-0.12310454726702222,0.14368140262337295},
{-0.31804530247694457,-0.22959050876251294,0.050820444761408776},
{-0.3260736766030398,-0.2250159264960311,0.14837447668895748},
{-0.3443189728225523,-0.3313117241865949,0.056482533221527964},
{-0.35526925708082807,-0.3262906896733066,0.15150541168022924},
{-0.392879752347702,-0.432474430512659,0.15209587362294888},
{-0.3806981740946306,-0.4330881914046404,0.05762418173535457},
{-0.41875689676635,-0.5535339957187626,0.14830213899886854},
{-0.4058708026665537,-0.5500072004847958,0.04745474511948035},
{-0.39761432073244796,-0.6615568002865106,0.13486485832796533},
{-0.3872598238910088,-0.6556393109635313,0.05722077707099368},
{0.2258564638274937,-0.045613129601403825,0.05329834348908644},
{0.18363543934384832,0.042063479207684794,0.06476919284229651},
{0.17809628057792928,0.033448859139212514,0.1414291708614021},
{0.2261513619567212,-0.05176604925930424,0.14061770174282798},
{0.14513758695223336,0.018890122377176213,0.2025984541480007},
{0.1855000209690543,-0.06227542863964539,0.21090796892852126},
{0.07748431703346238,0.0074510039739131215,0.24559255995762694},
{0.10276589593002858,-0.07600206007090429,0.24899731307641326},
{0.021774088506273284,0.0027756814887184866,0.25835217404714506},
{0.036546731812008085,-0.080603269707971,0.29011441115456055},
{-0.021832003037295416,-0.08366009185111488,0.30122645668913944},
{-0.021832003037295416,0.0017054830859613312,0.2641318667273475},
{-0.06543809458086412,0.0027756814887184866,0.25835217404714506},
{-0.08021073788659892,-0.080603269707971,0.29011441115456055},
{-0.14642990200461942,-0.07600206007090429,0.24899731307641326},
{-0.12114832310805324,0.0074510039739131215,0.24559255995762694},
{-0.22916402704364516,-0.06227542863964539,0.21090796892852126},
{-0.1888015930268242,0.018890122377176213,0.2025984541480007},
{-0.19890512690050083,0.04561734560174635,-0.012443525011200132},
{-0.21878534367392477,-0.0430753192899102,-0.024468223672575628},
{-0.14525230654050325,0.04399462925935299,-0.056772771560903115},
{-0.15648084682139093,-0.0307759149220007,-0.08506279954405065},
{-0.08253530733865866,0.0480024923218867,-0.07610646155307244},
{-0.08937077526255144,-0.027195421157354273,-0.10399219729283961},
{-0.021832003037295416,0.04993253289978053,-0.07789093917176895},
{-0.021832003037295416,-0.024380464297023022,-0.11343692563929542},
{0.0457067691879606,-0.027195421157354273,-0.10399219729283961},
{0.038871301264067834,0.0480024923218867,-0.07610646155307244},
{0.11281684074680008,-0.0307759149220007,-0.08506279954405065},
{0.1015883004659124,0.04399462925935299,-0.056772771560903115},
{0.17512133759933393,-0.0430753192899102,-0.024468223672575628},
{0.15524112082591002,0.04561734560174635,-0.012443525011200132},
{0.1975786400558642,-0.12729525160757207,-0.02706505798886575},
{0.24802730015548163,-0.12519302069989605,0.05114929278813201},
{0.21961589574141804,-0.24132496908451329,-0.0261814730749576},
{0.27438129640235376,-0.2295902868677581,0.050820444761408776},
{0.24491700137641315,-0.3423143756070209,-0.011900548546023512},
{0.30065518864271634,-0.3313117241865949,0.056482533221527964},
{0.3370343899147946,-0.4330877476151307,0.05762418173535457},
{0.2783487746195004,-0.44071005433980653,-0.010019990498466594},
{0.3622070184867177,-0.550006756695286,0.04745474511948035},
{0.3029151867211078,-0.5541923574564737,-0.022742548163920753},
{0.343595817816418,-0.6556388671740216,0.057220998965748546},
{0.3058861355941154,-0.6543589782279087,-0.0013095118958887447},
{0.21181518563382348,-0.572117681439458,-0.06106000011982317},
{0.23618388950883815,-0.6615767708144491,-0.03520615465043699},
{0.12871693130204956,-0.5904657149304771,-0.05393961933067222},
{0.16448747526150848,-0.6734188500925635,-0.029207895636683717},
{0.05242796131309326,-0.604734657142648,-0.006004583014267164},
{0.11011194368488636,-0.6892872096978658,0.008475381109788875},
{0.0322845773603888,-0.6140320473718675,0.0684422167197254},
{0.09844027957851532,-0.6982717283227131,0.07524883832548455},
{-0.24124264613045507,-0.12729525160757207,-0.02706505798886575},
{-0.15574437812996422,-0.13998763158636335,-0.09101357308026088},
{-0.08183145717619843,-0.1344533545050516,-0.11146738779503403},
{-0.021832003037295416,-0.12784710386294362,-0.1212050172179235},
{0.038167451101607595,-0.1344533545050516,-0.11146738779503403},
{0.11208037205537337,-0.13998763158636335,-0.09101357308026088},
{-0.24973300513619792,-0.12546040387951918,0.21764092147566225},
{-0.1623936763545177,-0.14377182473598413,0.2536105050302431},
{-0.2770861934642675,-0.22719293593609965,0.23067102527137173},
{0.20606899906160708,-0.12546040387951918,0.21764092147566225},
{0.2523850912464516,-0.12310454726702222,0.14368140262337295},
{0.282409670528449,-0.22501570460127623,0.1483742547942026},
{0.23342218738967668,-0.22719293593609965,0.23067080337661686},
{0.11872967027992688,-0.14377160284122922,0.2536105050302431},
{0.043369107945363285,-0.16798875259866497,0.2722205962267684},
{-0.021832003037295416,-0.18370400482310442,0.28407132940032276},
{-0.08703311401995412,-0.16798875259866497,0.2722205962267684},
{0.3116054729009921,-0.3262906896733066,0.15150541168022924},
{0.2660653466739418,-0.32967347521136037,0.24209039504145105},
{0.1423315058820971,-0.24823654690932787,0.2647582756203567},
{0.08350321225941892,-0.18162307581189632,0.2610244525800923},
{0.025492378913696462,-0.226477547246386,0.2363297853101678},
{-0.021832003037295416,-0.23487759508689512,0.2432375909241495},
{-0.06915660688304216,-0.226477547246386,0.2363297853101678},
{-0.12716721833400976,-0.18162307581189632,0.2610244525800923},
{-0.18599551195668793,-0.2482367688040827,0.2647584975151116},
{-0.3097293527485327,-0.32967369710611516,0.24209061693620595},
{-0.26327967992125395,-0.2413251909792682,-0.0261814730749576},
{-0.18109030650544386,-0.25358975787066246,-0.06563857649189273},
{-0.0760084950187956,-0.22450579045457583,-0.08844092529225202},
{-0.021832003037295416,-0.21702372121498034,-0.08850150256033261},
{0.032344488944204774,-0.22450579045457583,-0.08844092529225202},
{0.13742652232560792,-0.25358975787066246,-0.06563835459713785},
{0.15962664876123922,-0.36464874836935096,-0.058267232734979316},
{0.18613153344142563,-0.46069478354277604,-0.056086451084077914},
{0.0948597858138689,-0.4789904498716449,-0.047287214579550485},
{0.01816652358153222,-0.49554934595411526,-0.003056045511501796},
{0.007812692424357727,-0.49931978162893387,0.07401177506706215},
{-0.288581007451004,-0.3423145975017757,-0.011900770440778391},
{-0.20329065483583006,-0.36464897026410587,-0.058267232734979316},
{-0.10096899220505917,-0.28101306494127226,-0.07057151878749604},
{-0.040156959473807666,-0.3019488350636317,-0.009575313409699148},
{-0.03583777807018576,-0.28560517689338916,-0.018037935571082762},
{-0.021832003037295416,-0.28197320354561195,-0.01770442775450717},
{-0.00782622800440507,-0.28560517689338916,-0.018037935571082762},
{-0.0035072684955380416,-0.3019488350636317,-0.009575091514944269},
{0.05730498613046833,-0.28101306494127226,-0.07057151878749604},
{0.07591418974797413,-0.3814037994151298,-0.05326616874962971},
{-0.002449052409544062,-0.3978184639069321,-0.002670170532775958},
{-0.011084974374484247,-0.3988695793607701,0.07468433806908516},
{-0.042799504109601816,-0.2843632319503595,0.15863289310153617},
{-0.0627500615203208,-0.3865340061478161,0.1694788868250211},
{-0.031714307840362714,-0.2923166056493074,0.08578772970822393},
{-0.021832003037295416,-0.28736813072086287,0.16006256100718919},
{-0.021832003037295416,-0.29179692813339253,0.08806392610372116},
{-0.011949920128982997,-0.2923166056493074,0.08578772970822393},
{-0.0008647238597438876,-0.2843632319503595,0.15863289310153617},
{0.019086055445729968,-0.3865340061478161,0.1694788868250211},
{0.0392467471893146,-0.491125208331438,0.17011039929739247},
{0.0644728523971623,-0.6099447459870889,0.16723974685358786},
{0.12296763820326491,-0.702479962348898,0.14519805327293656},
{0.12448029474724077,-0.6018779840684004,0.2601714891423568},
{0.16602143370195227,-0.6997040589654245,0.20393758899366513},
{0.21964895805989426,-0.5878957298795268,0.2904301673907462},
{0.23900128721147298,-0.6863497669328441,0.229770798250848},
{0.3288802014626859,-0.5642595005903509,0.24887638043500687},
{0.3140625135217116,-0.6707845155626996,0.19802786598710656},
{0.37509311258651395,-0.5535335519292529,0.14830236089362345},
{0.353950536552612,-0.6615561346022459,0.1348650802227202},
{-0.03257925359486146,-0.3988698012555249,0.07468433806908516},
{-0.05147692039370343,-0.49932000352368877,0.07401177506706215},
{-0.0829109751586603,-0.4911254302261929,0.17011039929739247},
{-0.12499331542050945,-0.36688167528764776,0.2483030043884126},
{-0.1061251606240657,-0.2713832763692515,0.23299404146014738},
{0.062461154549474866,-0.2713832763692515,0.23299404146014738},
{0.08132908745116373,-0.36688167528764776,0.2483030043884126},
{0.09848465852949013,-0.47892876312979,0.26314465696291317},
{0.19323549401871593,-0.4628795592992653,0.2935491200652548},
{0.30244321657749085,-0.4397920757388929,0.2518908206799699},
{0.34921596816786604,-0.4324742086179041,0.15209587362294888},
{-0.2125026155844231,-0.3493848300763252,0.2818901039599116},
{-0.23689950009330674,-0.4628797811940202,0.2935493419600097},
{-0.34610722265208166,-0.4397922976336478,0.2518910425747247},
{-0.3725442075372767,-0.5642599443798607,0.24887638043500687},
{-0.3577265195963025,-0.6707849593522094,0.19802786598710656},
{0.16883838761507738,-0.3493846081815703,0.2818901039599116},
{-0.14214888649883584,-0.4789289850245449,0.26314465696291317},
{-0.1681445227165865,-0.6018784278579102,0.2601714891423568},
{-0.2633129641344851,-0.5878963955637913,0.2904303892855011},
{-0.2826655151808187,-0.6863504326171088,0.229770798250848},
{-0.3220125587993364,-0.44071049812931623,-0.010019990498466594},
{-0.22979553951601647,-0.46069500543753095,-0.05608667297883279},
{-0.11957819582256497,-0.3814040213098847,-0.05326616874962971},
{-0.04121517555980165,-0.3978186858016869,-0.0026703924275308256},
{-0.06183075155087792,-0.49554956784887016,-0.003056267406256664},
{-0.09609241117719385,-0.6047351009321578,-0.006004804909022032},
{-0.07594902722448937,-0.6140322692666224,0.06844199482497053},
{-0.15377617165423205,-0.6892878753821305,0.008475159215033995},
{-0.14210472944261593,-0.6982721721122229,0.07524883832548455},
{-0.16663208806736549,-0.7024804061384078,0.14519783137818168},
{-0.10813730226126289,-0.6099451897765985,0.16723952495883296},
{-0.20968566167129798,-0.6997047246496892,0.20393736709891025},
{-0.3495499197739514,-0.6543594220174183,-0.0012844377885879914},
{-0.34657897090094375,-0.5541928012459835,-0.022742770058675633},
{-0.2554789698136595,-0.5721179033342129,-0.061060222014578024},
{-0.279847895583429,-0.6615772146039589,-0.03520637654519185},
{-0.17238115927139527,-0.590465936825232,-0.053939841225427096},
{-0.1385240137832146,-0.4789906717663998,-0.04728743647430536},
{-0.2081517032308542,-0.6734192938820731,-0.0292081175314386},
{-0.16965895441860135,-0.7608223064584022,0.07669647970628236},
{-0.19175124000336394,-0.7663161986943269,0.14183501636806659},
{-0.20709082440780174,-0.8641041076935129,0.16663375227802704},
{-0.24530664856597187,-0.8411557521444465,0.22256010629646336},
{-0.22893436597235062,-0.7640069399803534,0.1898798905881343},
{-0.3059633549688116,-0.8249330266156102,0.24417487436873714},
{-0.2917066169681588,-0.7612956079705484,0.20940551954326958},
{-0.3738314190103006,-0.8282390365684776,0.2102913234047265},
{-0.36278505432316444,-0.7488615134864304,0.18294701086685183},
{-0.40733109204837925,-0.8374769590033909,0.1386148796853355},
{-0.39575994626596617,-0.7396158247350965,0.1294666027313913},
{-0.401906874765485,-0.8455978632422685,0.06827135775847244},
{-0.3870157396606475,-0.7343760019935024,0.06120400981573638},
{-0.36457263846842913,-0.8548426644145829,0.0032115937346684654},
{-0.3468867389259539,-0.7290642853513294,0.011833314435296722},
{-0.3130903926006088,-0.8655876960246003,-0.026717127013223353},
{-0.28610222114430683,-0.7321779125517208,-0.01850413645107297},
{-0.2514841985416633,-0.8765291044926808,-0.02827438440292892},
{-0.22889775333779638,-0.742319612323236,-0.016579865136805868},
{-0.2108774583997261,-0.8855919519659987,0.019611613172648992},
{-0.17676846236476346,-0.7512178138884372,0.020565538723852205},
{-0.19704076717004973,-0.8766134244995332,0.09254420309938156},
{-0.20897648603472074,-0.9254300486770525,0.20614078201480882},
{-0.2510526132434334,-0.8782223833671243,0.27700176251003794},
{-0.31620757011707834,-0.8599040837732583,0.2943565950782412},
{-0.39403981812618316,-0.8663996089326842,0.26601597509098235},
{-0.4412967440716933,-0.9141280612323015,0.17966540933702066},
{-0.4175138423495459,-0.9135697740290386,0.06520432845660437},
{-0.3868058272225367,-0.9142778401918414,-0.005413677282037766},
{-0.3238902322150799,-0.9150140869885132,-0.04427055538703881},
{-0.2586746980733544,-0.9229665731084415,-0.042397541761147586},
{-0.20485634422622084,-0.9244073357518382,0.017809605868317455},
{-0.19389208059838803,-0.9266440348809679,0.10443088322322545},
{-0.19924373829643852,-0.9578291237309561,0.10605359956561883},
{-0.21479656356031024,-0.9568556714413241,0.20768161919265368},
{-0.22558331138424384,-0.9241230885708447,0.30042674799257363},
{-0.2604227849522516,-0.9195311985134828,0.3862105945425872},
{-0.33506041417543575,-0.9063670702858293,0.4190432519475148},
{-0.41950113177419723,-0.9147185231750211,0.38134466446295584},
{-0.4436361804723296,-0.9137901155206285,0.2916144196975086},
{-0.44836808612001716,-0.955500116383799,0.2957323425584598},
{-0.4473935243566106,-0.954871488543241,0.18052724856495117},
{-0.4236033001075524,-0.955429553851749,0.06606594578978002},
{-0.3932887043809347,-0.954695526002626,-0.005004059564540407},
{-0.3287710292432879,-0.9548890182288762,-0.046495050304650405},
{-0.2639218433418593,-0.9582993187165342,-0.04435554107815554},
{-0.20993240863871784,-0.958285561241732,0.018834759635835214},
{0.14808679013926335,-0.7663157549048172,0.1418352382628215},
{0.12599450455450079,-0.7608218626688924,0.07669670160103723},
{0.16342637454370115,-0.8641032201144933,0.1666339741727819},
{0.20164219870187128,-0.8411548645654269,0.22256010629646336},
{0.20738816337933283,-0.8782214957881047,0.27700176251003794},
{0.1653118142758653,-0.925429161098033,0.20614078201480882},
{0.15337631730594914,-0.8766125369205136,0.09254420309938156},
{0.13310423439541777,-0.7512171482041725,0.020565760618607085},
{0.1672132304303804,-0.8855910643869791,0.019611835067403872},
{0.1852335253684507,-0.7423189466389712,-0.016579643242051002},
{0.20781997057231757,-0.8765282169136615,-0.02827416250817404},
{0.242438215069716,-0.7321772468674563,-0.018503914556318102},
{0.26942616463126307,-0.8655868084455807,-0.026717127013223353},
{0.303222954746118,-0.7290636196670647,0.01183353633005159},
{0.3209084104990834,-0.8548417768355634,0.0032115937346684654},
{0.34335195548081154,-0.7343753363092379,0.06120400981573638},
{0.35824286869089417,-0.8455969756632491,0.06827135775847244},
{0.3520961620861302,-0.739615159050832,0.1294666027313913},
{0.36366708597378844,-0.8374760714243713,0.1386148796853355},
{0.31912104824857357,-0.7488608478021657,0.18294701086685183},
{0.3301674129357098,-0.8282379270947031,0.2102913234047265},
{0.24804261089356797,-0.7612949422862838,0.20940551954326958},
{0.262298905104711,-0.8249323609313457,0.24417487436873714},
{0.18527013800300488,-0.7640062742960889,0.1898798905881343},
{0.18191863962538837,-0.9241222009918253,0.30042674799257363},
{0.21675833508815098,-0.919530532829218,0.3862105945425872},
{0.2725433421477326,-0.8599031961942387,0.2943565950782412},
{0.2913959643113352,-0.9063661827068099,0.4190430300527599},
{0.22230037848588338,-0.9556248212360382,0.38665527163135477},
{0.18818561318729404,-0.9564010090885873,0.3018286790538674},
{0.17113211369620962,-0.9568547838623047,0.20768161919265368},
{0.3758369038048515,-0.9147176355960016,0.38134466446295584},
{0.39997217439773874,-0.913789006046854,0.29161419780275377},
{0.3503755901568374,-0.8663987213536645,0.2660157531962275},
{0.39763273799710247,-0.9141269517585272,0.17966540933702066},
{0.4047038581506714,-0.9554992288047796,0.295732120663705},
{0.3781375086233849,-0.9549338409693606,0.37732570666267845},
{0.2963096017632645,-0.9526192567812702,0.4106840327419024},
{0.2150104701040087,-0.9229656855294222,-0.04239731986639273},
{0.16119189436212022,-0.9244066700675737,0.01780982776307232},
{0.2202573934777587,-0.9582984311375148,-0.04435531918340066},
{0.2851068012739421,-0.9548881306498566,-0.04649482840989552},
{0.2802262261404891,-0.9150129775147389,-0.044270333492283924},
{0.34314182114794584,-0.9142769526128218,-0.005413677282037766},
{0.3738498362749551,-0.913568886450019,0.06520432845660437},
{0.4037295182820198,-0.9548703790694667,0.18052724856495117},
{0.15022763073428744,-0.9266431473019485,0.10443088322322545},
{0.16626795877461725,-0.9582848955574673,0.018834759635835214},
{0.15557906653758308,-0.9578282361519367,0.10605359956561883},
{-0.38414109311125516,-0.7774537621257163,0.20281236069169922},
{-0.29967352624715393,-0.7881967966829397,0.24057507576041667},
{-0.3557172625909186,-0.6636856585647715,0.19902239827845175},
{-0.3956050637270641,-0.6544572776043178,0.1358593906193105},
{-0.4264022805455327,-0.7663097637464356,0.13175100923281888},
{-0.385250566885625,-0.6485397882813386,0.05821530936233884},
{-0.4156062131418944,-0.7643022818990908,0.04937480043340484},
{-0.34754088466332245,-0.6472601212299803,-0.00031520149929847776},
{-0.37420242704044987,-0.7694722077928995,-0.008833963033665194},
{-0.27783886047280004,-0.654477913816521,-0.03434986279137831},
{-0.29991960753030916,-0.774739323589343,-0.04604970753161832},
{-0.2061424462254704,-0.6663199930946352,-0.028377343569190448},
{-0.23177905672983493,-0.7817935797415414,-0.04283467442824932},
{-0.1517671365436031,-0.6821883526999377,0.009469691506379154},
{-0.17290793741946608,-0.7879751238228206,-0.0031221701484542446},
{-0.14009547243723208,-0.6911726494300301,0.0762433706168297},
{-0.16040261471903355,-0.7952215408327401,0.07084533691501053},
{-0.16462283106198167,-0.6953811053509699,0.14619236366952681},
{-0.18293269865516246,-0.797373254270753,0.1481048745617856},
{-0.20767640466591417,-0.6926052019674964,0.2049318993902554},
{-0.22851054699054132,-0.793349858575378,0.20522391288766956},
{-0.2806562581754349,-0.6792511318296709,0.2307653305421932},
{0.2560092982778082,-0.7881963528934299,0.24057507576041667},
{0.3404773089314192,-0.7774528745466969,0.20281236069169922},
{0.311776331862245,-0.666428055840259,0.19939229683482665},
{0.3516641329983906,-0.6571996748798052,0.13622951107044026},
{0.38273849636569673,-0.7663090980621708,0.13175123112757375},
{0.3413096361569515,-0.6512824074515811,0.05858542981346861},
{0.3719424289620584,-0.7643013943200712,0.04937502232815971},
{0.30359995393464884,-0.6500025185054678,5.514084658619143e-05},
{0.3305386428606139,-0.7694715421086349,-0.008833741138910325},
{0.2338977078493716,-0.6572203110920084,-0.03397952044549364},
{0.25625560145571835,-0.7747386579050783,-0.04604926374210858},
{0.16220129360204194,-0.6690626122648775,-0.02800700122330578},
{0.1881150506552441,-0.7817929140572769,-0.04283423063873958},
{0.1078257620254198,-0.6849309718701801,0.009839811957508932},
{0.12924370945012037,-0.787974680033311,-0.0031219482536993643},
{0.09615409791904879,-0.6939152686002724,0.07661349106795949},
{0.11673838674968784,-0.7952208751484754,0.07084555880976542},
{0.12068145654379835,-0.6981235026264573,0.14656248412065662},
{0.1392682487910619,-0.7973725885864883,0.1481048745617856},
{0.1637352520424857,-0.6953478211377389,0.20530201984138519},
{0.18484631902119558,-0.7933494147858684,0.20522391288766956},
{0.23671510555200645,-0.6819935291051584,0.23113545099332297},
{-0.16040261471903355,-0.7952215408327401,0.07084533691501053},
{-0.18293269865516246,-0.797373254270753,0.1481048745617856},
{-0.19175124000336394,-0.7663161986943269,0.14183501636806659},
{-0.22893436597235062,-0.7640069399803534,0.1898798905881343},
{-0.22851054699054132,-0.793349858575378,0.20522391288766956},
{-0.2917066169681588,-0.7612956079705484,0.20940551954326958},
{-0.29967352624715393,-0.7881967966829397,0.24057507576041667},
{-0.36278505432316444,-0.7488615134864304,0.18294701086685183},
{-0.38414109311125516,-0.7774537621257163,0.20281236069169922},
{-0.39575994626596617,-0.7396158247350965,0.1294666027313913},
{-0.4264022805455327,-0.7663097637464356,0.13175100923281888},
{-0.3870157396606475,-0.7343760019935024,0.06120400981573638},
{-0.4156062131418944,-0.7643022818990908,0.04937480043340484},
{-0.3468867389259539,-0.7290642853513294,0.011833314435296722},
{-0.36512515640806537,-0.7616488644203079,-0.008833963033665194},
{-0.28610222114430683,-0.7321779125517208,-0.01850413645107297},
{-0.29991960753030916,-0.774739323589343,-0.04604970753161832},
{-0.22889775333779638,-0.742319612323236,-0.016579865136805868},
{-0.23177905672983493,-0.7817935797415414,-0.04283467442824932},
{-0.17676846236476346,-0.7512178138884372,0.020565538723852205},
{-0.17290793741946608,-0.7879751238228206,-0.0031221701484542446},
{-0.16965895441860135,-0.7608223064584022,0.07669647970628236},
{0.1392682487910619,-0.7973725885864883,0.1481048745617856},
{0.11673838674968784,-0.7952208751484754,0.07084555880976542},
{0.14808679013926335,-0.7663157549048172,0.1418352382628215},
{0.18527013800300488,-0.7640062742960889,0.1898798905881343},
{0.18484631902119558,-0.7933494147858684,0.20522391288766956},
{0.24804261089356797,-0.7612949422862838,0.20940551954326958},
{0.2560092982778082,-0.7881963528934299,0.24057507576041667},
{0.31912104824857357,-0.7488608478021657,0.18294701086685183},
{0.3404773089314192,-0.7774528745466969,0.20281236069169922},
{0.3520961620861302,-0.739615159050832,0.1294666027313913},
{0.38273849636569673,-0.7663090980621708,0.13175123112757375},
{0.34335195548081154,-0.7343753363092379,0.06120400981573638},
{0.3719424289620584,-0.7643013943200712,0.04937502232815971},
{0.303222954746118,-0.7290636196670647,0.01183353633005159},
{0.3305386428606139,-0.7694715421086349,-0.008833741138910325},
{0.242438215069716,-0.7321772468674563,-0.018503914556318102},
{0.25625560145571835,-0.7747386579050783,-0.04604926374210858},
{0.1852335253684507,-0.7423189466389712,-0.016579643242051002},
{0.1881150506552441,-0.7817929140572769,-0.04283423063873958},
{0.13310423439541777,-0.7512171482041725,0.020565760618607085},
{0.12924370945012037,-0.787974680033311,-0.0031219482536993643},
{0.12599450455450079,-0.7608218626688924,0.07669670160103723},
{-0.3431076493556953,-0.9983868251320662,0.4127997992296258},
{-0.4297016336557538,-0.9989535443360145,0.3838227850853884},
{-0.4592841985860423,-1.0,0.30083747518384535},
{-0.22490564480285868,-0.9980763943699976,0.3063968263724579},
{-0.4586569021140135,-0.9990474058173261,0.17918389771894414},
{-0.20646241846199864,-0.9982922979664899,0.20854368031533907},
{-0.4336642301882932,-0.9990966664529081,0.059299265239898195},
{-0.1892482671683855,-0.9992386790960274,0.10141289266218455},
{-0.20226527917355744,-0.9975520570642303,0.012335906055086264},
{-0.40031477989926423,-0.9973228397824455,-0.01289752167967228},
{-0.2619523054975979,-0.9998271439859533,-0.052874524507277136},
{-0.33144086693393154,-0.998169146377535,-0.05547690619243909},
{0.3860374056864081,-0.9989526567569949,0.3838227850853884},
{0.2994431994915947,-0.9983859375530467,0.41279957733487094},
{0.41562019251145144,-0.9999988905262257,0.30083747518384535},
{0.18124097304400327,-0.998075506790978,0.3063968263724579},
{0.2180175878220608,-0.9984229939771108,0.3949514727265829},
{-0.26168225958091623,-0.9984238815561302,0.39495169462133767},
{0.16279796859789808,-0.9982914103874705,0.20854390221009395},
{0.4149928960394227,-0.9990462963435518,0.17918389771894414},
{0.3900002241137024,-0.9990957788738887,0.059299265239898195},
{0.14558381730428493,-0.999237791517008,0.10141311455693942},
{0.15860082930945685,-0.9975511694852108,0.012336127949841144},
{0.3566507738246734,-0.9973217303086712,-0.0128972997849174},
{0.2182880775282522,-0.9998264783016886,-0.05287430261252226},
{0.2877768608593407,-0.9981682587985153,-0.05547668429768424},
{0.34962469830634385,-0.9546946384236066,-0.005003837669785539},
{0.3799395159277164,-0.9554284443779747,0.0660661676845349},
{-0.23185028494614948,-0.956401674772852,0.3018286790538674},
{-0.265964828349984,-0.9556257088150576,0.38665527163135477},
{-0.33997405162736505,-0.9526201443602897,0.4106840327419024},
{-0.42180173659273057,-0.9549349504431349,0.37732570666267845},
{-0.2619523054975979,-0.9998271439859533,-0.052874524507277136},
{-0.33144086693393154,-0.998169146377535,-0.05547690619243909},
{-0.2602998552580514,-0.9582303094477684,-0.05182851263280123},
{-0.2006667493594453,-0.9563974587725094,0.01334952129535058},
{-0.20226527917355744,-0.9975520570642303,0.012335906055086264},
{-0.1875629765051177,-0.9575038260203109,0.10241962916504777},
{-0.1892482671683855,-0.9992386790960274,0.10141289266218455},
{-0.2046295677867396,-0.956484219621665,0.20957549092550307},
{-0.20646241846199864,-0.9982922979664899,0.20854368031533907},
{-0.22293211285300962,-0.956008921056725,0.30747079698604796},
{-0.22490564480285868,-0.9980763943699976,0.3063968263724579},
{-0.2599368354390776,-0.9551961205696217,0.3963165692585675},
{-0.26168225958091623,-0.9984238815561302,0.39495169462133767},
{-0.34080060958927055,-0.9523565333914994,0.4184219466338676},
{-0.3431076493556953,-0.9983868251320662,0.4127997992296258},
{-0.4289769253863354,-0.9544727436687325,0.3865449899381823},
{-0.4297016336557538,-0.9989535443360145,0.3838227850853884},
{-0.4577941753070635,-0.9550645369799814,0.30108555351979444},
{-0.4592841985860423,-1.0,0.30083747518384535},
{-0.45673684680008897,-0.9544061752422702,0.18042184855638602},
{-0.4586569021140135,-0.9990474058173261,0.17918389771894414},
{-0.43174661571667233,-0.9549906460266084,0.0605372160773401},
{-0.4336642301882932,-0.9990966664529081,0.059299265239898195},
{-0.3982731262596688,-0.9541793988027891,-0.01169684916104921},
{-0.40031477989926423,-0.9973228397824455,-0.01289752167967228},
{-0.3299038019669195,-0.9551912388850143,-0.05434968083767931},
{0.2877768608593407,-0.9981682587985153,-0.05547668429768424},
{0.2182880775282522,-0.9998264783016886,-0.05287430261252226},
{0.21663562728870572,-0.9582294218687489,-0.051828290738046345},
{0.15700229949534475,-0.9563965711934898,0.01334952129535058},
{0.15860082930945685,-0.9975511694852108,0.012336127949841144},
{0.1438985266410171,-0.9575029384412915,0.10241962916504777},
{0.14558381730428493,-0.999237791517008,0.10141311455693942},
{0.16096511792263904,-0.9564835539374005,0.20957549092550307},
{0.16279796859789808,-0.9982914103874705,0.20854390221009395},
{0.17926744109415413,-0.9560082553724604,0.30747057509129305},
{0.18124097304400327,-0.998075506790978,0.3063968263724579},
{0.216272385574977,-0.9551952329906023,0.3963163473638127},
{0.2180175878220608,-0.9984229939771108,0.3949514727265829},
{0.2971363816199249,-0.9523556458124798,0.4184219466338676},
{0.2994431994915947,-0.9983859375530467,0.41279957733487094},
{0.3853129193117446,-0.9544716341949582,0.3865447680434274},
{0.3860374056864081,-0.9989526567569949,0.3838227850853884},
{0.4141299473377178,-0.955063427506207,0.30108533162503953},
{0.41562019251145144,-0.9999988905262257,0.30083747518384535},
{0.41307284072549816,-0.9544050657684959,0.18042184855638602},
{0.4149928960394227,-0.9990462963435518,0.17918389771894414},
{0.3880826096420815,-0.9549897584475888,0.06053743797209496},
{0.3900002241137024,-0.9990957788738887,0.059299265239898195},
{0.35460912018507795,-0.9541785112237697,-0.011696627266294328},
{0.3566507738246734,-0.9973217303086712,-0.0128972997849174},
{0.2862397958923287,-0.955190351305995,-0.054349458942924436},
{-0.3287710292432879,-0.9548890182288762,-0.046495050304650405},
{-0.2639218433418593,-0.9582993187165342,-0.04435554107815554},
{-0.2602998552580514,-0.9582303094477684,-0.05182851263280123},
{-0.2006667493594453,-0.9563974587725094,0.01334952129535058},
{-0.20993240863871784,-0.958285561241732,0.018834759635835214},
{-0.1875629765051177,-0.9575038260203109,0.10241962916504777},
{-0.19924373829643852,-0.9578291237309561,0.10605359956561883},
{-0.2046295677867396,-0.956484219621665,0.20957549092550307},
{-0.21479656356031024,-0.9568556714413241,0.20768161919265368},
{-0.22293211285300962,-0.956008921056725,0.30747079698604796},
{-0.23185028494614948,-0.956401674772852,0.3018286790538674},
{-0.2599368354390776,-0.9551961205696217,0.3963165692585675},
{-0.265964828349984,-0.9556257088150576,0.38665527163135477},
{-0.34080060958927055,-0.9523565333914994,0.4184219466338676},
{-0.33997405162736505,-0.9526201443602897,0.4106840327419024},
{-0.4289769253863354,-0.9544727436687325,0.3865449899381823},
{-0.42180173659273057,-0.9549349504431349,0.37732570666267845},
{-0.4577941753070635,-0.9550645369799814,0.30108555351979444},
{-0.44836808612001716,-0.955500116383799,0.2957323425584598},
{-0.45673684680008897,-0.9544061752422702,0.18042184855638602},
{-0.4473935243566106,-0.954871488543241,0.18052724856495117},
{-0.43174661571667233,-0.9549906460266084,0.0605372160773401},
{-0.4236033001075524,-0.955429553851749,0.06606594578978002},
{-0.3982731262596688,-0.9541793988027891,-0.01169684916104921},
{-0.3932887043809347,-0.954695526002626,-0.005004059564540407},
{-0.3299038019669195,-0.9551912388850143,-0.05434968083767931},
{0.2202573934777587,-0.9582984311375148,-0.04435531918340066},
{0.2851068012739421,-0.9548881306498566,-0.04649482840989552},
{0.21663562728870572,-0.9582294218687489,-0.051828290738046345},
{0.15700229949534475,-0.9563965711934898,0.01334952129535058},
{0.16626795877461725,-0.9582848955574673,0.018834759635835214},
{0.1438985266410171,-0.9575029384412915,0.10241962916504777},
{0.15557906653758308,-0.9578282361519367,0.10605359956561883},
{0.16096511792263904,-0.9564835539374005,0.20957549092550307},
{0.17113211369620962,-0.9568547838623047,0.20768161919265368},
{0.17926744109415413,-0.9560082553724604,0.30747057509129305},
{0.18818561318729404,-0.9564010090885873,0.3018286790538674},
{0.216272385574977,-0.9551952329906023,0.3963163473638127},
{0.22230037848588338,-0.9556248212360382,0.38665527163135477},
{0.2971363816199249,-0.9523556458124798,0.4184219466338676},
{0.2963096017632645,-0.9526192567812702,0.4106840327419024},
{0.3853129193117446,-0.9544716341949582,0.3865447680434274},
{0.3781375086233849,-0.9549338409693606,0.37732570666267845},
{0.4141299473377178,-0.955063427506207,0.30108533162503953},
{0.4047038581506714,-0.9554992288047796,0.295732120663705},
{0.41307284072549816,-0.9544050657684959,0.18042184855638602},
{0.4037295182820198,-0.9548703790694667,0.18052724856495117},
{0.3880826096420815,-0.9549897584475888,0.06053743797209496},
{0.3799395159277164,-0.9554284443779747,0.0660661676845349},
{0.35460912018507795,-0.9541785112237697,-0.011696627266294328},
{0.34962469830634385,-0.9546946384236066,-0.005003837669785539},
{0.2862397958923287,-0.955190351305995,-0.054349458942924436},
{0.60488953968155,0.0982297014561399,0.1531944745543299},
{0.6054063325656515,0.0827221427222625,0.16454971674025068},
{0.6510460895376401,0.09573138841101383,0.16789078606438812},
{0.6151193316707498,0.10103289789446282,0.13715703114581348},
{0.628595443923756,0.09229135402620263,0.12569616705657274},
{0.6373835856905398,0.07471152017655718,0.12745690193649772},
{0.6379001566798864,0.0592037395479249,0.13881214412241843},
{0.6276705865854413,0.056400543109601985,0.15484958753093492},
{0.6141942524376802,0.06514230887261706,0.16631045162017566},
{-0.633722766024629,0.07114544957097754,0.16849189895534167},
{-0.6350208503406417,0.08677682557807462,0.15737097763056787},
{-0.6800710329489302,0.08028019094487443,0.17413157604521862},
{-0.6461908104062427,0.08891211880422688,0.14186696921276845},
{-0.6594257230607009,0.07921931212182196,0.13090093042689666},
{-0.6666432937524867,0.060950716953047684,0.13278592636955108},
{-0.6653452094364738,0.04531934094595061,0.1439068476943249},
{-0.6541754712656278,0.04318404771979836,0.15941085611212433},
{-0.6409403367164147,0.05287707629695816,0.17037689489799612},
{0.6380268585849194,0.10032216899460147,0.06378708665722431},
{0.6454128473956545,0.08825353517176092,0.0768060957151901},
{0.6839331111575117,0.0939642185831975,0.04947531875736275},
{0.6367037001616059,0.09732703359331259,0.044840381117555186},
{0.6408828659749023,0.0839123861874065,0.030985494517979145},
{0.6492653841297765,0.06611820200455279,0.032559172119545364},
{0.6566515948352664,0.054049568181712235,0.04557840307226603},
{0.657974531363825,0.05704470358300113,0.06452510861193515},
{0.6537955874452835,0.07045935098890721,0.07838021710626607},
{-0.6781376639497133,0.07438267214983395,0.08277772735835848},
{-0.6723921430617615,0.08717712371586726,0.06962513765795857},
{-0.718241812471861,0.07720140122099803,0.05733949076485126},
{-0.6717209114282677,0.08452858792169153,0.05059278074290808},
{-0.675428550887457,0.07097947229433181,0.03673434382725405},
{-0.6822333973351772,0.05253313942690349,0.038410758700326925},
{-0.687978918223129,0.03973868786087017,0.05156334840072685},
{-0.6886501498566228,0.0423874455498008,0.07059570531577732},
{-0.6849425103974335,0.055936561177160504,0.08445414223143134},
{0.6093565029919179,0.06245005981173113,-0.023169251777543406},
{0.6233438607601537,0.05534609923444087,-0.012052324558357313},
{0.6384837398852049,0.039071450332964136,-0.05411558187128727},
{0.5973335794885815,0.05237981015128558,-0.03429305773413057},
{0.5930913955649008,0.033873121910531545,-0.039667792486687975},
{0.6014035730824797,0.01679809862822439,-0.0343074808931974},
{0.6153911527454704,0.009694359945688997,-0.023190553674011304},
{0.627414076248807,0.01976460960613455,-0.012066747717424118},
{0.6316562601724877,0.03827129784688858,-0.006692012964866732},
{-0.6576427987052885,0.04448324150958548,-0.007509473241822444},
{-0.6448272671375421,0.052855996295245136,-0.019143859029374644},
{-0.6733553881926695,0.027510733604030106,-0.04908411830451991},
{-0.6325531587716883,0.04395202546641718,-0.030965967779550217},
{-0.6270588227462538,0.025926848843739674,-0.03682132657116463},
{-0.6336746148628213,0.008158182557696486,-0.031354949284844294},
{-0.6464901464305677,-0.0002145722279631686,-0.019720563497292093},
{-0.6587642547964215,0.008689398600864782,-0.00789845474711652},
{-0.664258590821856,0.02671457522354228,-0.002043095955502109},
{0.525133020358178,0.07025010423506106,0.20829648955840946},
{0.5241884143866795,0.051953106537662934,0.21413010266404622},
{0.5565852704930346,0.06783167330168963,0.24514166981572308},
{0.5407397660474841,0.0794141357166013,0.20180384903079698},
{0.5599223457115843,0.07658053969686066,0.19814613589145444},
{0.5711160485159568,0.06049250428423294,0.2004380868145477},
{0.5701714425444582,0.04219572848158968,0.20627169992018446},
{0.5545646968551522,0.033031697000049445,0.2127645623425518},
{0.535382117191052,0.03586507112503521,0.2164222754818944},
{-0.5480014937954898,0.04663650821088252,0.21379592916320603},
{-0.5507239205430385,0.06486005874441736,0.2083013712430167},
{-0.5800996795617845,0.05939945072172374,0.24651009476903088},
{-0.5673209825233472,0.07277349138748788,0.20267811436500047},
{-0.5863557802807013,0.06840105524269624,0.1998616042413851},
{-0.5960658947539864,0.051413014704299674,0.20241139686964194},
{-0.5933432461116828,0.03318946417076483,0.2079057328950764},
{-0.5767466279208838,0.025276031527694302,0.21352921166784752},
{-0.557711608268775,0.029648467672485964,0.21634572179146286},
{0.44951639147648986,0.026022263588335478,0.17742959778691048},
{0.45049050945038666,0.0068219323438453985,0.17711739186680278},
{0.4488220827884892,0.013274409920825686,0.2242234293789987},
{0.4620308118618723,0.037994816982315605,0.18578082878134736},
{0.4787889694342194,0.03803076393260519,0.19619923131219016},
{0.48997712486972,0.023020471344400367,0.20243602718743295},
{0.49095124284361674,0.003820140099910285,0.20212382126732528},
{0.47843660056347953,-0.008152635188824699,0.19377259027288837},
{0.4616784429911324,-0.008188582139114282,0.1833541877420456},
{-0.4726620114626392,0.008224307194648912,0.172727647931131},
{-0.4732591302480051,0.02743395801884371,0.17329791745115708},
{-0.4693138415063459,0.01423077631433252,0.21980328586190911},
{-0.4863100921506728,0.03822580942213942,0.18240336871741059},
{-0.50250463704564,0.03674621519663976,0.19357998562565779},
{-0.5121120142474184,0.020785325478554828,0.20008660552282734},
{-0.5115148954620525,0.0015756746543600438,0.19951655789755607},
{-0.49846393355938495,-0.009216176748935666,0.1904111066313026},
{-0.48226916676966286,-0.007736582523436008,0.17923426782830051},
{0.4182409914612679,-0.006401663678114177,0.08987946898810001},
{0.4248689877893535,-0.024399991035451953,0.08852812993091752},
{0.3923159177755672,-0.03115180463675723,0.12255924090691937},
{0.41848285674408053,0.004751432386116354,0.10554013510284047},
{0.4240584062497989,0.00469529301313325,0.12446864527260991},
{0.4327160739007167,-0.009431192766408546,0.13518616193302285},
{0.43934429212355713,-0.027429520123746297,0.13383482287584034},
{0.4391024268407445,-0.038582616187976856,0.1181741567610999},
{0.4335268773350262,-0.038526698709748605,0.09924564659133045},
{-0.4487570676253112,-0.019704032338054036,0.08257291849960981},
{-0.44357782215179775,-0.001234844310873698,0.0839020680813049},
{-0.4141916340795728,-0.024135270592887302,0.11496134260527965},
{-0.44399964408081316,0.009671948575446723,0.09973137420974958},
{-0.4486536646695399,0.008927491672844541,0.11889287387213669},
{-0.4556040740764574,-0.005995818171449686,0.12977259559836252},
{-0.4607833195499708,-0.024465006198630023,0.12844344601666743},
{-0.46036127572620056,-0.03537179908495046,0.11261413988822273},
{-0.4557072551374738,-0.034627342182348274,0.0934526402258356},
{0.453298143783807,-0.011854283489632349,-0.005051101252573687},
{0.46590354101868775,-0.02634733940422595,-0.005920484902169924},
{0.4256476164842063,-0.05148734944718255,-0.009213181169744818},
{0.43952757719108304,-0.009422982660478219,0.008145867398801021},
{0.4319551967862539,-0.017833237659711572,0.024310900291370015},
{0.4371135841528091,-0.0344123261648754,0.03368639747430515},
{0.44971898138768984,-0.048905160184714115,0.03281723571946379},
{0.4634897698751687,-0.05133668290862312,0.0196200451733342},
{0.471061928385243,-0.042926427909389775,0.003455234175520086},
{-0.49389467676702004,-0.023924470575757025,-0.009909265015784475},
{-0.4824990497357123,-0.008446423844277864,-0.009391362657908619},
{-0.4519044228284437,-0.045594490441994415,-0.015444651570870629},
{-0.46836923553484733,-0.005037676619903857,0.0031956173123175355},
{-0.4593767286988247,-0.012982396423411627,0.018860721322155466},
{-0.4627047062324246,-0.030043218441406856,0.028200715344310772},
{-0.47410033326373235,-0.045521265172886016,0.027682812986434917},
{-0.4882301474645972,-0.04893001239726,0.01509583301620875},
{-0.49722265430061996,-0.04098529259375223,-0.000569270993629167},
{0.5351395862239747,0.012114787931854309,-0.052125185920067735},
{0.5492232463158259,-0.00024874402021375777,-0.04782486557061011},
{0.5276075906645326,-0.025395410905816596,-0.08193963086919948},
{0.5162352625824865,0.008822757348544031,-0.05090432097875113},
{0.5032803811086795,-0.005205429054588601,-0.045928552995457145},
{0.506247779665609,-0.023612264655649334,-0.03946609015450753},
{0.5203314397574601,-0.035975796607717415,-0.03516599169980478},
{0.5392359852937032,-0.032683766024407125,-0.036386634746366525},
{0.5521908667675104,-0.018655579621274516,-0.041362624624415374},
{-0.5809619625792248,-0.0043353797207277365,-0.04752331059873638},
{-0.5681628512233391,0.009205082011191882,-0.05227052698451018},
{-0.5589792930033699,-0.027192092736031168,-0.08298786169122412},
{-0.5490151090357541,0.007479628397291874,-0.05197207853920468},
{-0.5347288590327031,-0.005483019392935943,-0.04781865251747366},
{-0.5358622974405993,-0.02414836238342485,-0.04151817284758204},
{-0.548661408796485,-0.03768882411534448,-0.03677095646180824},
{-0.5678091509840699,-0.03596359239619934,-0.0370696268018686},
{-0.5820956228818759,-0.023000944605971546,-0.04122283092884479},
{-0.2676982701750594,0.6662804958282676,0.029357008911959043},
{-0.2500882586387511,0.667228652115844,0.036940927844041724},
{-0.24478674915530216,0.6991879317655877,0.0022035258632759984},
{-0.23112491099246646,0.6645934300069607,0.03229511736124533},
{-0.2228047452637119,0.6591638872499495,0.01528222461030289},
{-0.22724552499300477,0.654323031277619,-0.0027556000134024306},
{-0.2448553146345582,0.6533748749900424,-0.010339518945485114},
{-0.2638188841755978,0.6560100970989257,-0.005693708462688718},
{-0.2721390499043523,0.6614396398559369,0.011318962393498841},
{0.2064242525641603,0.6672284302210892,0.036940927844041724},
{0.2240342641004686,0.6662802739335127,0.029357008911959043},
{0.20112274308071132,0.6991879317655877,0.0022035258632759984},
{0.18746090491787562,0.6645934300069607,0.03229511736124533},
{0.1791407391891211,0.6591638872499495,0.01528222461030289},
{0.18358151891841396,0.654323031277619,-0.0027556000134024306},
{0.20119153045472227,0.6533748749900424,-0.010339518945485114},
{0.22015487810100692,0.6560100970989257,-0.005693708462688718},
{0.22847504382976144,0.6614396398559369,0.011318962393498841},
{-0.27163046712618116,0.6395162161796335,0.15792527072824306},
{-0.2537273326186843,0.6311751923439208,0.15871654742412364},
{-0.24608194883950152,0.6832261544684831,0.15497229533038023},
{-0.2352093277454317,0.6367997805904664,0.15105940322293257},
{-0.2301021980672523,0.6440126914923997,0.13345183252892787},
{-0.23747997677205707,0.6529648134830354,0.11815640518070998},
{-0.255766767310731,0.6582778614937378,0.11572976414140822},
{-0.27326117167974995,0.6579505667302986,0.12478373582453095},
{-0.28136787465431573,0.6504445328571766,0.14414671592434364},
{0.21006332654409346,0.6311751923439208,0.15871654742412364},
{0.2279664610515903,0.6395162161796335,0.15792527072824306},
{0.20241794276491068,0.6832261544684831,0.15497229533038023},
{0.19154532167084085,0.6367997805904664,0.15105962511768745},
{0.18643819199266146,0.6440124695976448,0.13345183252892787},
{0.19381597069746626,0.6529648134830354,0.11815640518070998},
{0.21210276123614016,0.6582778614937378,0.11572976414140822},
{0.229597387499914,0.6579505667302986,0.12478373582453095},
{0.23770386857972486,0.6504445328571766,0.14414671592434364},
{-0.16741604223633522,0.17812046710621054,0.2601186781906968},
{-0.1500818458803353,0.17545639867919363,0.26800814620024094},
{-0.1757537376507248,0.1792539055141068,0.3078702075448211},
{-0.1370832511398179,0.1841690962293202,0.2800226377028922},
{-0.13800433626729974,0.20158783448692713,0.2893950283592592},
{-0.14950913551800554,0.21688969678303635,0.29181168413459163},
{-0.16684333187400552,0.21939621993409278,0.2839490653903872},
{-0.1798419266145229,0.2106526790130387,0.27194211830940157},
{-0.17892084148704102,0.1933420035010554,0.26255641396774226},
{0.10641783980574444,0.17545639867919363,0.26800814620024094},
{0.12375203616174439,0.17812046710621054,0.2601186781906968},
{0.13208973157613396,0.1792539055141068,0.3078702075448211},
{0.09341924506522704,0.1841690962293202,0.2800226377028922},
{0.09434033019270892,0.20158783448692713,0.2893950283592592},
{0.10584512944341472,0.21688969678303635,0.29181168413459163},
{0.12317932579941468,0.21939621993409278,0.2839490653903872},
{0.13617792053993205,0.2106526790130387,0.27194211830940157},
{0.13525683541245018,0.1933420035010554,0.26255641396774226},
{-0.2129943343612238,0.30119306152853087,0.2922146450094427},
{-0.1945360191770323,0.29447564161423107,0.29587590846486334},
{-0.21263508675308285,0.3118402375516487,0.3394074433707943},
{-0.17926610972562493,0.3019455066423085,0.30664845502448496},
{-0.1729658519504882,0.32008074306340345,0.313263359562033},
{-0.18129489346943767,0.3379563626212959,0.31340004673103533},
{-0.1974954295227865,0.3469854820918728,0.30424045314459264},
{-0.21502289621028167,0.3372041394022732,0.29896601482123825},
{-0.22131516577424296,0.31946565080289285,0.29237840333853976},
{0.15087201310244147,0.29447564161423107,0.29587590846486334},
{0.169330328286633,0.30119306152853087,0.2922146450094427},
{0.168971080678492,0.3118402375516487,0.3394074433707943},
{0.1356021036510341,0.3019455066423085,0.30664845502448496},
{0.12930184587589735,0.32008074306340345,0.313263359562033},
{0.13763088739484683,0.3379563626212959,0.31340004673103533},
{0.15383142344819567,0.3469854820918728,0.30424045314459264},
{0.17135889013569086,0.3372041394022732,0.29896601482123825},
{0.17765115969965212,0.31946565080289285,0.29237840333853976},
{-0.24888581096208906,0.4219433054463402,0.2860193434533614},
{-0.23158600829309453,0.41663158880416695,0.2925157561918067},
{-0.24025543636602073,0.45209880263371316,0.3230167435125185},
{-0.21335935123299152,0.42361017884495344,0.2954263496914886},
{-0.2058335687266858,0.44151309145769535,0.29192884456516505},
{-0.21070327101715003,0.45883397412840293,0.28514907222474567},
{-0.22800329558089935,0.4641456907705761,0.2786528813810552},
{-0.2462297307462476,0.4571671007297896,0.27574228788137334},
{-0.25375573514730815,0.43926441001180255,0.27923979300769686},
{0.18792200221850372,0.41663158880416695,0.2925157561918067},
{0.20522180488749822,0.4219433054463402,0.2860193434533614},
{0.19659165218618477,0.45209880263371316,0.3230167435125185},
{0.16969534515840068,0.42361017884495344,0.2954263496914886},
{0.16216956265209498,0.44151309145769535,0.29192884456516505},
{0.1670394868373141,0.45883397412840293,0.28514907222474567},
{0.18433928950630854,0.4641456907705761,0.2786528813810552},
{0.20256572467165676,0.4571671007297896,0.2757425097761282},
{0.2100917290727173,0.43926441001180255,0.27923979300769686},
{-0.26855256498132424,0.5416586322274173,0.24052004586120793},
{-0.2500769420062526,0.5376636390606663,0.2438684377122562},
{-0.2529491477133413,0.5789318474668828,0.26721110024073363},
{-0.23196544832392907,0.5448610173297583,0.2409851372674238},
{-0.22610432026868793,0.5614585230995768,0.2321361963378046},
{-0.23300924125085623,0.5769390106733595,0.2231248284476176},
{-0.2514848642259279,0.5809342257348655,0.21977643659656937},
{-0.26959635790825137,0.5737368474657731,0.2226597370414018},
{-0.27545726406873766,0.5571391198012,0.23150867797102098},
{0.20641293593166174,0.5376634171659114,0.2438684377122562},
{0.22488855890673337,0.5416586322274173,0.24052004586120793},
{0.20928514163875045,0.5789318474668828,0.26721110024073363},
{0.18830144224933823,0.5448610173297583,0.2409851372674238},
{0.1824403141940971,0.5614585230995768,0.2321361963378046},
{0.18934523517626542,0.5769390106733595,0.2231248284476176},
{0.2078208581513371,0.5809342257348655,0.21977643659656937},
{0.22593235183366056,0.5737368474657731,0.2226597370414018},
{0.23179325799414682,0.5571391198012,0.23150867797102098},
{0.09244135488049746,0.5663086986516122,-0.17731865040947345},
{0.06225545811170669,0.5776943404189506,-0.16877747750486446},
{0.10869470188550628,0.6067925090993491,-0.16338499117191718},
{0.16608045770674876,0.5814341546175965,-0.17034361068476497},
{0.1474282065067974,0.542007672676834,-0.18398192800358404},
{0.22174453212492407,0.5521029964445803,-0.16526799006177773},
{0.20076682389389347,0.5139029268140063,-0.17912354234561836},
{0.250840259963019,0.5346667285013382,-0.15735677636625592},
{0.22864723415954363,0.4971971364038093,-0.1715498305722599},
{0.25831034688585136,0.5249759188717272,-0.1422996639847727},
{0.23580711221506215,0.48791483501792127,-0.15713421592711735},
{0.25887795366881894,0.5195530329573622,-0.12944840736149163},
{0.2363525295225424,0.4827220539643606,-0.14482992987460058},
{0.2216198272726849,0.44123128511900545,-0.17559874416444532},
{0.22220296668849368,0.4356583983503456,-0.16239179024910125},
{0.07719119406227386,0.6186718666962823,-0.15446460013122854},
{0.050927065191125706,0.5773563947072774,-0.15405365104520194},
{0.024005684056040838,0.5384513654404688,-0.17177194722188874},
{0.03582291112160919,0.5381691153122691,-0.18783801505378397},
{0.06819802154198658,0.5259609096886129,-0.1970053749566473},
{0.12717165622910723,0.49990114588670354,-0.20415659911672573},
{0.18437612403561762,0.4697580748056035,-0.19894029721914835},
{0.21427688604439535,0.4518394076652655,-0.19081029529532081},
{0.06536708825930443,0.61831483803569,-0.1390861841446878},
{0.04685041475458106,0.5743996470985817,-0.1416725894074988},
{0.01963191654271994,0.5352767171824869,-0.1584822265629767},
{0.08243612038322998,0.5432187742489362,-0.10737897693648105},
{0.05455548822282492,0.559924564659133,-0.11495268870983953},
{0.057458759195595996,0.501176818832474,-0.12193371959292962},
{0.11466322700210643,0.47103396964612887,-0.11671763959010713},
{0.13577473777032606,0.5151140283861084,-0.1025205912785154},
{0.17363686168922707,0.4449739839494648,-0.12386864185543069},
{0.190761589396626,0.49081300241133025,-0.10918386887262597},
{0.20601219400435933,0.43276600022056333,-0.13303600175829403},
{0.22094748616541673,0.4794273606439918,-0.11772504177723496},
{0.21782942106992767,0.43248352819760877,-0.1491020695901892},
{0.23227565719124288,0.47976530635566483,-0.13244886823689747},
{0.25462201227033615,0.5164638141800068,-0.1165166029421913},
{0.027557997186818284,0.5190954859728121,-0.13006372151675716},
{0.047395832062061286,0.569206866045021,-0.129368525249737},
{0.061678753643789226,0.6098027333439694,-0.11330290120735155},
{0.06914884056662156,0.6001119237143584,-0.0982457888258683},
{0.09824456840471649,0.5826756557711165,-0.09033457513034653},
{0.1539086428228918,0.5533444975981001,-0.08525895450735924},
{0.21129439864413424,0.5279861431163476,-0.09221757402020707},
{0.2427979064673667,0.5161067855194146,-0.10113818695565055},
{0.020215277853283618,0.529703830413827,-0.14527527264763268},
{0.0611111468608216,0.6152253973635796,-0.12615437972538748},
{0.16608045770674876,0.5814341546175965,-0.17034361068476497},
{0.10869470188550628,0.6067925090993491,-0.16338499117191718},
{0.09039681660908866,0.6060990879903679,-0.13923551931471798},
{0.07719119406227386,0.6186718666962823,-0.15446460013122854},
{0.06536708825930443,0.61831483803569,-0.1390861841446878},
{0.08220024625879893,0.605023342218739,-0.126505639122353},
{0.0611111468608216,0.6152253973635796,-0.12615437972538748},
{0.08678525757875986,0.5977640553130368,-0.11398855599991212},
{0.061678753643789226,0.6098027333439694,-0.11330290120735155},
{0.06914884056662156,0.6001119237143584,-0.0982457888258683},
{0.09824456840471649,0.5826756557711165,-0.09033457513034653},
{0.15743876647818184,0.5614913635232981,-0.10993587019689387},
{0.1539086428228918,0.5533444975981001,-0.08525895450735924},
{0.22959206202579702,0.5286793423305739,-0.11636704587740625},
{0.21129439864413424,0.5279861431163476,-0.09221757402020707},
{0.2427979064673667,0.5161067855194146,-0.10113818695565055},
{0.25462201227033615,0.5164638141800068,-0.1165166029421913},
{0.23778885427084162,0.5297553099969579,-0.12909714796452612},
{0.25887795366881894,0.5195530329573622,-0.12944840736149163},
{0.23320384295088067,0.5370143750079049,-0.14161400919221212},
{0.25831034688585136,0.5249759188717272,-0.1422996639847727},
{0.250840259963019,0.5346667285013382,-0.15735677636625592},
{0.22174453212492407,0.5521029964445803,-0.16526799006177773},
{0.16255033405145872,0.5732872886923985,-0.14566669499523033},
{0.06819802154198658,0.5259609096886129,-0.1970053749566473},
{0.12717165622910723,0.49990114588670354,-0.20415659911672573},
{0.12354389888167261,0.49152883489055366,-0.178796691371689},
{0.19615252246628917,0.45425206933501017,-0.17463194871745938},
{0.18437612403561762,0.4697580748056035,-0.19894029721914835},
{0.21427688604439535,0.4518394076652655,-0.19081029529532081},
{0.2216198272726849,0.44123128511900545,-0.17559874416444532},
{0.20086445758603802,0.44679196767614715,-0.16176848788266024},
{0.22220296668849368,0.4356583983503456,-0.16239179024910125},
{0.19244088890151223,0.4456864880073651,-0.1486864607143103},
{0.21782942106992767,0.43248352819760877,-0.1491020695901892},
{0.20601219400435933,0.43276600022056333,-0.13303600175829403},
{0.17363686168922707,0.4449739839494648,-0.12386864185543069},
{0.11829098434954104,0.47940628064227875,-0.14207732544038895},
{0.11466322700210643,0.47103396964612887,-0.11671763959010713},
{0.04568236076492446,0.5166828243030673,-0.14624206809461857},
{0.057458759195595996,0.501176818832474,-0.12193371959292962},
{0.027557997186818284,0.5190954859728121,-0.13006372151675716},
{0.020215277853283618,0.529703830413827,-0.14527527264763268},
{0.040970425645175626,0.5241429259619304,-0.1591055289294177},
{0.01963191654271994,0.5352767171824869,-0.1584822265629767},
{0.049393994329701416,0.5252486275254674,-0.1721875560977677},
{0.024005684056040838,0.5384513654404688,-0.17177194722188874},
{0.03582291112160919,0.5381691153122691,-0.18783801505378397},
{0.11756316955355439,0.6956746721116679,-0.12223704972284234},
{0.10599313324491565,0.695593680526139,-0.1072891095607571},
{0.13054778492451471,0.683087470246687,-0.10761218832385361},
{0.14845158511627615,0.6833506374259675,-0.1310837717049128},
{0.20473496779530473,0.6572664652010222,-0.1382190194426403},
{0.2013195637282845,0.6493840978236339,-0.11434314381820072},
{0.25935280844424924,0.62733818824264,-0.1337107837078658},
{0.27064015083517856,0.612331667865268,-0.11093062438299389},
{0.28791155097554916,0.6096376436463432,-0.12627220584022555},
{0.29526913725766035,0.5999969822313337,-0.11177271497774062},
{0.29585072341018503,0.5946841561153862,-0.09935548449499305},
{0.2751623659395101,0.6051331801224016,-0.09886554087623131},
{0.2917004039150223,0.5917611365094313,-0.086826419055789},
{0.2671457522354232,0.6042673467888833,-0.0865033402926925},
{0.28013036760638355,0.5916801449239022,-0.07187847889370376},
{0.24924195204366176,0.6040044015043575,-0.06303175691163329},
{0.19295856936463318,0.630088573729303,-0.05589628727915092},
{0.19637397343165341,0.6379709411066912,-0.0797721629035905},
{0.13834072871568867,0.6600166287929301,-0.060404523013925446},
{0.1270531644300045,0.6750231491703022,-0.08318468233879732},
{0.10978198618438877,0.6777171733892272,-0.06784310088156567},
{0.10242439990227753,0.6873578348042366,-0.08234281363880548},
{0.10184281374975285,0.692670882814939,-0.09475982222679817},
{0.12253117122042778,0.6822218588079236,-0.09524998774031478},
{0.08315705644181552,0.6512198331307065,-0.12520533585879148},
{0.09472709275045427,0.6513010466109903,-0.14015327602087674},
{0.10771170812141458,0.6387138447460092,-0.125528414621888},
{0.07900673694665272,0.6482970354195063,-0.11267604852483255},
{0.09969509441732766,0.6378480114124909,-0.11316621403834917},
{0.0795883230991774,0.6429842093035589,-0.10025903993683986},
{0.10421708762690436,0.6306493017748696,-0.10110113053158659},
{0.08694590938128863,0.6333433259937944,-0.08575954907435493},
{0.11550465191258855,0.6156427813974975,-0.07832097120671472},
{0.17012249256153306,0.5857147263338703,-0.07381273547194019},
{0.17353789662855326,0.5935970937112586,-0.09768861109637976},
{0.22640587524056163,0.5596305541089249,-0.08094798320966767},
{0.2443096754323231,0.5598934993934507,-0.10441956659072688},
{0.2572942908032834,0.5473062975284696,-0.08979470519173814},
{0.2688643271119221,0.5473875110087534,-0.10474264535382338},
{0.2730146466070849,0.5503103087199533,-0.11727193268778231},
{0.25232628913641,0.5607593327269689,-0.11678176717426571},
{0.2724330604545602,0.555623134835901,-0.12968894127577502},
{0.2478040740320784,0.5679580423645904,-0.12884685068102827},
{0.26507547417244903,0.5652637962509106,-0.14418865403301484},
{0.2365167316411491,0.5829643408472075,-0.15162701000590015},
{0.1818988909922046,0.6128926178055896,-0.15613546763542957},
{0.1784834869251844,0.6050102504282013,-0.13225937011623512},
{0.12561550831317603,0.6389765681357801,-0.1489999980029472},
{0.10771170812141458,0.6387138447460092,-0.125528414621888},
{0.1784834869251844,0.6050102504282013,-0.13225937011623512},
{0.2013195637282845,0.6493840978236339,-0.11434314381820072},
{0.27064015083517856,0.612331667865268,-0.11093062438299389},
{0.2478040740320784,0.5679580423645904,-0.12884685068102827},
{0.2751623659395101,0.6051331801224016,-0.09886554087623131},
{0.25232628913641,0.5607593327269689,-0.11678176717426571},
{0.2671457522354232,0.6042673467888833,-0.0865033402926925},
{0.2443096754323231,0.5598934993934507,-0.10441956659072688},
{0.19637397343165341,0.6379709411066912,-0.0797721629035905},
{0.17353789662855326,0.5935970937112586,-0.09768861109637976},
{0.1270531644300045,0.6750231491703022,-0.08318468233879732},
{0.10421708762690436,0.6306493017748696,-0.10110113053158659},
{0.12253117122042778,0.6822218588079236,-0.09524998774031478},
{0.09969509441732766,0.6378480114124909,-0.11316621403834917},
{0.13054778492451471,0.683087470246687,-0.10761218832385361},
{0.12561550831317603,0.6389765681357801,-0.1489999980029472},
{0.09472709275045427,0.6513010466109903,-0.14015327602087674},
{0.14845158511627615,0.6833506374259675,-0.1310837717049128},
{0.1818988909922046,0.6128926178055896,-0.15613546763542957},
{0.20473496779530473,0.6572664652010222,-0.1382190194426403},
{0.2365167316411491,0.5829643408472075,-0.15162701000590015},
{0.25935280844424924,0.62733818824264,-0.1337107837078658},
{0.28791155097554916,0.6096376436463432,-0.12627220584022555},
{0.26507547417244903,0.5652637962509106,-0.14418865403301484},
{0.29526913725766035,0.5999969822313337,-0.11177271497774062},
{0.2724330604545602,0.555623134835901,-0.12968894127577502},
{0.2730146466070849,0.5503103087199533,-0.11727193268778231},
{0.29585072341018503,0.5946841561153862,-0.09935548449499305},
{0.11756316955355439,0.6956746721116679,-0.12223704972284234},
{0.08315705644181552,0.6512198331307065,-0.12520533585879148},
{0.10599313324491565,0.695593680526139,-0.1072891095607571},
{0.10184281374975285,0.692670882814939,-0.09475982222679817},
{0.07900673694665272,0.6482970354195063,-0.11267604852483255},
{0.13834072871568867,0.6600166287929301,-0.060404523013925446},
{0.10978198618438877,0.6777171733892272,-0.06784310088156567},
{0.11550465191258855,0.6156427813974975,-0.07832097120671472},
{0.19295856936463318,0.630088573729303,-0.05589628727915092},
{0.17012249256153306,0.5857147263338703,-0.07381273547194019},
{0.24924195204366176,0.6040044015043575,-0.06303175691163329},
{0.22640587524056163,0.5596305541089249,-0.08094798320966767},
{0.2572942908032834,0.5473062975284696,-0.08979470519173814},
{0.28013036760638355,0.5916801449239022,-0.07187847889370376},
{0.2688643271119221,0.5473875110087534,-0.10474264535382338},
{0.2917004039150223,0.5917611365094313,-0.086826419055789},
{0.08694590938128863,0.6333433259937944,-0.08575954907435493},
{0.10242439990227753,0.6873578348042366,-0.08234281363880548},
{0.0795883230991774,0.6429842093035589,-0.10025903993683986},
{-0.19299340684114843,-0.06924270204793331,-0.3884741429370566},
{-0.1825767794683446,-0.07446499510389228,-0.3654044109570742},
{-0.20294649607102053,-0.07473348775728979,-0.37617340720061787},
{-0.19220479288232634,-0.07854120175092717,-0.3575531088453684},
{-0.1524561197574868,-0.07662802517440377,-0.3410922902445524},
{-0.07682528961148671,-0.06964721618606856,-0.32071636058874003},
{-0.07514177410625787,-0.0657616171334704,-0.3324858802820104},
{0.0006423853153601405,-0.05842710790586606,-0.3131821460817491},
{0.03601107787374232,-0.04847867846584634,-0.32555544140303166},
{0.04296037780688542,-0.05058401590009059,-0.3146821546246971},
{0.05834811337313089,-0.043669997232972456,-0.3285390382770671},
{0.06358238874585305,-0.03874016146393737,-0.3417000599781522},
{0.052330771410458464,-0.040077521151562816,-0.3437512550922073},
{0.06228408253508543,-0.03458673544220633,-0.3560519908286459},
{0.041914365932409506,-0.034855228095603846,-0.3668209870721897},
{0.05154215745163636,-0.03077902144856895,-0.3746722891838955},
{0.011793484326796819,-0.03269241991984721,-0.3911331077847114},
{-0.06383712392444839,-0.03967322890818244,-0.41150881554576896},
{-0.06552086132443212,-0.04355860606602572,-0.39973951774725336},
{-0.14130502074605011,-0.05089333718838491,-0.4190432519475148},
{-0.1766737133044323,-0.06084176662840466,-0.40666995662623223},
{-0.18362301323757538,-0.058736207299405506,-0.41754324340456667},
{-0.19901074880382086,-0.06565044786127855,-0.4036863597521968},
{-0.20424480228178815,-0.07058050552506849,-0.39052533805111167},
{-0.13872039064127806,0.12508895205986004,-0.2897329740709322},
{-0.19220479288232634,-0.07854120175092717,-0.3575531088453684},
{-0.10542375130390906,0.11418082780501038,-0.28054120574503266},
{-0.0549821918364476,0.2535779974486541,-0.2297947628843744},
{0.0019271559460804495,0.23029679976727674,-0.22400863525628062},
{-0.04213737016105788,0.09653154089708937,-0.27157310733204615},
{-0.1524561197574868,-0.07662802517440377,-0.3410922902445524},
{-0.14780653706385755,0.13205888820520645,-0.30325191201162904},
{-0.20294649607102053,-0.07473348775728979,-0.37617340720061787},
{-0.08490536521546758,0.26740181878254776,-0.23696795462518536},
{0.01265621113374683,0.39922660802136223,-0.17303652542991554},
{0.06528299014720719,0.37080610592234875,-0.16972474621342148},
{0.11921850442491425,0.345405813331925,-0.17556080016136183},
{0.06018673331201663,0.2101318920233495,-0.22766279807954526},
{0.022603087310482446,0.08223863405139212,-0.2727717827978754},
{-0.07682528961148671,-0.06964721618606856,-0.32071636058874003},
{0.06557855396069932,0.08280468757107562,-0.3012879215362395},
{0.052330771410458464,-0.040077521151562816,-0.3437512550922073},
{0.05206294444132557,0.08020119641213928,-0.28563169331659655},
{0.08674797925994104,0.20529125794577377,-0.24069068292770598},
{0.003164662994012601,0.23315302905201452,-0.23266075553832669},
{-0.04080444836852992,0.09960766788390728,-0.28089091187871407},
{0.03601107787374232,-0.04847867846584634,-0.32555544140303166},
{0.07069810974515163,0.07754334103825883,-0.28999192524987016},
{0.05834811337313089,-0.043669997232972456,-0.3285390382770671},
{0.07498733535686555,0.08045726295926385,-0.3007167644371939},
{0.1074378899939001,0.20331217862705278,-0.2555154715008362},
{0.10642760317495889,0.20757766149999518,-0.2656735914842119},
{0.07381417778784685,0.0847342843594597,-0.3117733362830542},
{0.06358238874585305,-0.03874016146393737,-0.3417000599781522},
{-0.07514177410625787,-0.0657616171334704,-0.3324858802820104},
{-0.13072862914973704,0.1258067815918774,-0.29672443400750137},
{-0.1825767794683446,-0.07446499510389228,-0.3654044109570742},
{-0.13957091323671003,0.13398848499359053,-0.31373732675844385},
{-0.19299340684114843,-0.06924270204793331,-0.3884741429370566},
{-0.12605530371733628,0.13659219804728173,-0.3293935549780868},
{-0.1766737133044323,-0.06084176662840466,-0.40666995662623223},
{-0.03318791090748077,0.11718550468075886,-0.33413433641596924},
{-0.06552086132443212,-0.04355860606602572,-0.39973951774725336},
{0.05673626987372633,0.09098639097278878,-0.31830081428718193},
{0.041914365932409506,-0.034855228095603846,-0.3668209870721897},
{-0.14469069091591719,0.13924983152640732,-0.32503332304481325},
{-0.19901074880382086,-0.06565044786127855,-0.4036863597521968},
{-0.14897991652763112,0.1363359096054023,-0.31430826196273454},
{-0.09403611248377673,0.2793157919612411,-0.2592453004355128},
{-0.09302560377008066,0.27505030908829875,-0.24908718045213715},
{-0.20424480228178815,-0.07058050552506849,-0.39052533805111167},
{0.0006423853153601405,-0.05842710790586606,-0.3131821460817491},
{0.05793383586578118,0.07602469333590135,-0.27779903036430015},
{0.04296037780688542,-0.05058401590009059,-0.3146821546246971},
{0.031431392027898374,0.10261234475965576,-0.3344840425496506},
{0.011793484326796819,-0.03269241991984721,-0.3911331077847114},
{-0.03185498911495281,0.12026163166757675,-0.34345214096263715},
{0.011474843458797795,0.2523313927157721,-0.29075213668006833},
{-0.04678473390713839,0.27249607856494446,-0.28709797385680375},
{-0.09659566848124801,0.13455453851327404,-0.3422534654968079},
{-0.06383712392444839,-0.03967322890818244,-0.41150881554576896},
{0.06228408253508543,-0.03458673544220633,-0.3560519908286459},
{0.06472803136526738,0.09170422050480609,-0.3252920523289963},
{0.09830736462034584,0.2152261518057462,-0.2777928173111637},
{0.06838419124132585,0.22904997313963987,-0.2849660090519746},
{0.05154215745163636,-0.03077902144856895,-0.3746722891838955},
{-0.13192619514179188,0.1407684792287648,-0.33722621793038315},
{-0.18362301323757538,-0.058736207299405506,-0.41754324340456667},
{-0.09013231806127892,0.28172756605196636,-0.2693124435693901},
{-0.023299393051277005,0.4285586537733979,-0.19985539118824863},
{-0.02242801234888691,0.42417534478561747,-0.1901095516594288},
{-0.014989212586491813,0.41576353652309994,-0.17875719410532143},
{-0.14130502074605011,-0.05089333718838491,-0.4190432519475148},
{-0.07859667543964563,0.2819609993340938,-0.2810677619983487},
{-0.01962415022629938,0.43064557394298764,-0.20970862777842744},
{0.09144660069439743,0.64828172468142,-0.11090133427535052},
{0.09216975570053172,0.6439734161207871,-0.10115216632520761},
{0.09901476509888406,0.6358613876721042,-0.08978582940154317},
{0.09199867484452387,0.20066697125420013,-0.23369300993800032},
{0.10353431746615714,0.20090062643108245,-0.2454483283669589},
{0.15944247611469384,0.3323189044789678,-0.1944178602200619},
{0.16311771893967145,0.3344058246485575,-0.20427109681024072},
{-0.008876012089713838,0.4298718269327421,-0.22149190494650003},
{0.1051281874904169,0.6499696780817463,-0.1325203183479669},
{0.09497339592836436,0.6504438671729121,-0.12075124244420622},
{-0.07768557557613309,0.26732193667079307,-0.24373485706982204},
{-0.008266023408565285,0.41505147625470934,-0.18556337192157085},
{-0.01546806146750985,0.42460337976776935,-0.20004089520332327},
{-0.08557215895386387,0.27612294833335954,-0.25908864273857174},
{0.09108757498101135,0.2153060339175008,-0.271025914866527},
{0.09897415835874211,0.20650524414968927,-0.25567212919777726},
{0.1552863873559043,0.33836132054894097,-0.20408559279516605},
{0.14387899990258818,0.33820843506283277,-0.1891673865302339},
{0.010237336410865636,0.24947494153627944,-0.28210001639802235},
{0.14808434929695974,0.347913002167246,-0.21856333797167332},
{0.25837491825951964,0.5639723687775441,-0.11485549880720472},
{0.2475750786450485,0.5635126028454452,-0.09995149380658454},
{0.17514419275908596,0.5963701124629186,-0.0890107510227684},
{0.06648233129730101,0.3735740210946467,-0.1781088176315797},
{0.10536162077254431,0.6353394912086406,-0.09658290953284274},
{0.09876690865768982,0.6445847361704647,-0.11107485597366196},
{0.10956674827216101,0.6450442802078087,-0.1259786390795273},
{-0.004060895908948606,0.42475626525387755,-0.21495910146825536},
{-0.07334620174981768,0.2773367126425202,-0.27407008900864305},
{0.07333599459109344,0.38939045732730865,-0.22601767036690965},
{0.2517802061446651,0.5732173918446133,-0.12934744524802397},
{0.1486943379781083,0.3330926514892133,-0.18263458305198924},
{0.2520134175320377,0.5585872049715076,-0.0934100364328998},
{0.2621682090940902,0.5581130158803418,-0.10517911233666048},
{0.2656950043280572,0.560275158371834,-0.11502902050551618},
{0.26497184932192286,0.5645834669324669,-0.12477818845565909},
{0.16224633823728135,0.33878935553109285,-0.2140169363390605},
{0.15480753847488626,0.3472011637936103,-0.22536929389316784},
{0.07453533574118726,0.3921583724996066,-0.23440174178506784},
{0.020599821463480217,0.41755888698478527,-0.2285656878371274},
{0.1327396613131598,0.6385982375787198,-0.13954994418237437},
{0.12716211475464764,0.3637380922953481,-0.2310899625685738},
{0.18319697530821735,0.6149546857626333,-0.14530367517625653},
{0.25812683992357055,0.5726954953811497,-0.1361445253793235},
{0.23234577593378306,0.5882909244379572,-0.14190935111094938},
{0.22440194370929478,0.5699586454745341,-0.0863804105984923},
{0.18199763415812353,0.6121867705903353,-0.13691960375809828},
{0.12479605098342646,0.6202659586152968,-0.08402078177516245},
{0.17394462971423727,0.5936021972906206,-0.08062667960461016},
{-0.12099632520096455,0.5422803813305741,-0.1098724082969999},
{-0.09153535859634705,0.5578991093366433,-0.11124793388246366},
{-0.1395025696522088,0.5835434861574285,-0.1026519529734008},
{-0.19539430808888483,0.5551278657430223,-0.10994874009267655},
{-0.1745515118688176,0.5150523416442534,-0.11686941560244093},
{-0.24946207164049677,0.5291901440562937,-0.1296592073786219},
{-0.22636038681581253,0.49019680067704524,-0.13575132787368685},
{-0.27765779435282284,0.5163555295396282,-0.14557904656705514},
{-0.2533785140640224,0.47789650873011624,-0.15099904784960683},
{-0.28473446187526363,0.514850639312073,-0.1635815899247355},
{-0.26016139293101004,0.4764519738758866,-0.16823671998723658},
{-0.2851263280123711,0.5163457661704137,-0.17745600326274047},
{-0.2605383921195409,0.4778823074658043,-0.1815208932772768},
{-0.24334820545945418,0.4274720351587801,-0.174551622816195},
{-0.24375094443955042,0.4290084344415274,-0.18881013597488683},
{-0.10875572294309666,0.5998440967452254,-0.10409493456434626},
{-0.08033566463359296,0.5653436783626652,-0.12406901281908188},
{-0.05122728879447022,0.5241577929105069,-0.1270213225326801},
{-0.0628703284774625,0.5154941341012075,-0.11333840436813138},
{-0.09446791967676149,0.4987424114767517,-0.1118554817213086},
{-0.15190648644966398,0.46954061794582697,-0.11935419306751967},
{-0.20747026443863625,0.442885288621836,-0.13961007766094527},
{-0.23644616910909919,0.42969519870786244,-0.1559703779378033},
{-0.09706564157207109,0.6076157386399316,-0.11748783628427469},
{-0.07621707608837715,0.5689962879226456,-0.13624881591411428},
{-0.046808254751155035,0.5280773418606008,-0.14009536148985463},
{-0.11039508139210556,0.5566817947114048,-0.18201815942294935},
{-0.08337673224914077,0.5689820866583338,-0.16677043944702938},
{-0.08308893475206923,0.5142004876802923,-0.18929541980379622},
{-0.1386527127410415,0.4875451583563013,-0.20955130439722178},
{-0.16220395633910045,0.5318262537441966,-0.20090029358895017},
{-0.19609127951394398,0.45834336482537663,-0.21705001574343286},
{-0.2157591430069535,0.5045982140578759,-0.2078970789996363},
{-0.22768887071324295,0.44159164220092073,-0.21556731499136494},
{-0.245220109611571,0.4889797079465614,-0.20652155341417253},
{-0.23933213229099015,0.43292798339162136,-0.20188417493206134},
{-0.2564198035743251,0.4815349170257847,-0.1937006963723092},
{-0.28082645145242324,0.5201599151119425,-0.19017789524392997},
{-0.05411303008160624,0.5273905775942659,-0.1729351195269381},
{-0.07659385338215315,0.5704266215125633,-0.14953276730939963},
{-0.0931574092544758,0.6129250144398012,-0.14408436349822404},
{-0.10023429867167144,0.6114201242122458,-0.1620869068559044},
{-0.12842979948924266,0.5985852878008254,-0.1780065241495828},
{-0.1824975630408546,0.5726477880088519,-0.19771721333028303},
{-0.2383895233722855,0.5442321675944456,-0.20501400044955875},
{-0.2691363700813976,0.5279315570066485,-0.2035710188586133},
{-0.047210993731251295,0.5296137411433481,-0.1543538746485464},
{-0.09276554311736836,0.6114298875814603,-0.1302099501602191},
{-0.19539430808888483,0.5551278657430223,-0.10994874009267655},
{-0.1395025696522088,0.5835434861574285,-0.1026519529734008},
{-0.12140793997125575,0.5956185549281604,-0.1237532565828962},
{-0.10875572294309666,0.5998440967452254,-0.10409493456434626},
{-0.09706564157207109,0.6076157386399316,-0.11748783628427469},
{-0.11327838183693797,0.6012906286522489,-0.1352480705696327},
{-0.09276554311736836,0.6114298875814603,-0.1302099501602191},
{-0.11758114302869921,0.6008171052453478,-0.14979660017294474},
{-0.0931574092544758,0.6129250144398012,-0.14408436349822404},
{-0.10023429867167144,0.6114201242122458,-0.1620869068559044},
{-0.12842979948924266,0.5985852878008254,-0.1780065241495828},
{-0.18623804292376517,0.5675663981222379,-0.17226189084065047},
{-0.1824975630408546,0.5726477880088519,-0.19771721333028303},
{-0.2564841530532386,0.5321570988237136,-0.18391269684006334},
{-0.2383895233722855,0.5442321675944456,-0.20501400044955875},
{-0.2691363700813976,0.5279315570066485,-0.2035710188586133},
{-0.28082645145242324,0.5201599151119425,-0.19017789524392997},
{-0.26461371118755633,0.52648524699438,-0.1724178828533269},
{-0.2851263280123711,0.5163457661704137,-0.17745600326274047},
{-0.2603109499957951,0.5269585485065261,-0.1578693532500148},
{-0.28473446187526363,0.514850639312073,-0.1635815899247355},
{-0.27765779435282284,0.5163555295396282,-0.14557904656705514},
{-0.24946207164049677,0.5291901440562937,-0.1296592073786219},
{-0.19165405010072914,0.5602090337348815,-0.13540406258230908},
{-0.09446791967676149,0.4987424114767517,-0.1118554817213086},
{-0.15190648644966398,0.46954061794582697,-0.11935419306751967},
{-0.1480626036109821,0.4747624672122762,-0.14551380950912218},
{-0.21861936639727905,0.44059178443545866,-0.16860084927998478},
{-0.20747026443863625,0.442885288621836,-0.13961007766094527},
{-0.23644616910909919,0.42969519870786244,-0.1559703779378033},
{-0.24334820545945418,0.4274720351587801,-0.174551622816195},
{-0.2230410631776527,0.44010516923802,-0.18355189596863827},
{-0.24375094443955042,0.4290084344415274,-0.18881013597488683},
{-0.21468650376189272,0.4459341225538045,-0.195364907033864},
{-0.23933213229099015,0.43292798339162136,-0.20188417493206134},
{-0.22768887071324295,0.44159164220092073,-0.21556731499136494},
{-0.19609127951394398,0.45834336482537663,-0.21705001574343286},
{-0.14249681747447823,0.482323309089852,-0.18339168795561928},
{-0.1386527127410415,0.4875451583563013,-0.20955130439722178},
{-0.07193983279342642,0.5164939918666696,-0.16030464818475665},
{-0.08308893475206923,0.5142004876802923,-0.18929541980379622},
{-0.05411303008160624,0.5273905775942659,-0.1729351195269381},
{-0.047210993731251295,0.5296137411433481,-0.1543538746485464},
{-0.06751813601305275,0.5169806070641082,-0.1453536014961032},
{-0.046808254751155035,0.5280773418606008,-0.14009536148985463},
{-0.07587269542881274,0.5111516537483238,-0.1335408123256323},
{-0.05122728879447022,0.5241577929105069,-0.1270213225326801},
{-0.0628703284774625,0.5154941341012075,-0.11333840436813138},
{-0.15344976446981243,0.68063464562631,-0.09553423492130833},
{-0.14202418164659666,0.6884247047856706,-0.10842166038963386},
{-0.16587498316373547,0.6761137618905078,-0.11466799773933622},
{-0.18355955133768145,0.6640131752229653,-0.09436107735228966},
{-0.23831052883955037,0.6349343113862409,-0.10183626785448406},
{-0.23469142538755586,0.6398508334699835,-0.12646525427696592},
{-0.2912965554611517,0.6082532422706844,-0.12132239954325183},
{-0.30197035885485446,0.6056766003770878,-0.1487261798754327},
{-0.3189379850758026,0.59498526729775,-0.13694822818147703},
{-0.3258999330099735,0.5932587042100758,-0.15443708518162416},
{-0.32630777556943186,0.5946375582168626,-0.16787902564237975},
{-0.3062096581467217,0.6050393186410897,-0.1628493372336514},
{-0.3221186244921661,0.5983953458906534,-0.1801702199043589},
{-0.2982678229750273,0.6107065106805711,-0.17392410444941145},
{-0.31069304166895034,0.606185405050014,-0.19305764537268444},
{-0.2805832548010813,0.6228068754533587,-0.19423102483645802},
{-0.22583227729921246,0.6518857392900831,-0.1867558343342636},
{-0.2294513807512069,0.6469692172063405,-0.16212662601702685},
{-0.1728462506776111,0.6785668084056395,-0.16726948075074094},
{-0.16217244728390837,0.6811436721939909,-0.13986592231331493},
{-0.14520504295771508,0.6918350052733289,-0.15164387400727056},
{-0.13824287312878927,0.6935613464662482,-0.1341547951123686},
{-0.1378350305693309,0.6921824924594614,-0.12071307654636788},
{-0.15793314799204108,0.6817807320352343,-0.12574276495509626},
{-0.11670266169415316,0.642165195763319,-0.1139350793639875},
{-0.12812824451736893,0.6343751366039584,-0.10104765389566198},
{-0.14055346321129197,0.6298542528681561,-0.12018119481893498},
{-0.11251351061688739,0.6459232053318646,-0.12622649552072154},
{-0.13261162803959758,0.6355212230128826,-0.131255962034695},
{-0.11292135317634576,0.6473018374438966,-0.13966821408672223},
{-0.13685070543670996,0.6348841631716392,-0.14537911939291367},
{-0.11988330111051669,0.6455754962509772,-0.15715707108686935},
{-0.14752473072516759,0.6323072993832879,-0.17278289972509456},
{-0.20051075734676893,0.6056262302677314,-0.19226903141386234},
{-0.20412986079876344,0.6007099300787437,-0.16764004499138047},
{-0.25526173484863784,0.5765475883257619,-0.19974444381081166},
{-0.2729463030225838,0.5644470016582195,-0.1794373015290102},
{-0.2853715217165068,0.5599261179224171,-0.19857106434703803},
{-0.2967971045397226,0.5521360587630565,-0.1856836388787125},
{-0.3009860337222335,0.5483780491945109,-0.17339222272197852},
{-0.28088813819427816,0.558780031513493,-0.16836275620800503},
{-0.30057841305753,0.5469991951877241,-0.1599505041559778},
{-0.27664883890241093,0.5594170913547363,-0.15423959884978636},
{-0.2936162432286042,0.5487257582753984,-0.14246142526107583},
{-0.26597503550870816,0.5619939551430877,-0.12683581851760545},
{-0.21298900888710684,0.5886750242586442,-0.1073496868288377},
{-0.20936990543511233,0.5935913244476319,-0.13197867325131954},
{-0.15823803138523793,0.6177536662006137,-0.09987427443188839},
{-0.14055346321129197,0.6298542528681561,-0.12018119481893498},
{-0.20936990543511233,0.5935913244476319,-0.13197867325131954},
{-0.23469142538755586,0.6398508334699835,-0.12646525427696592},
{-0.30197035885485446,0.6056766003770878,-0.1487261798754327},
{-0.27664883890241093,0.5594170913547363,-0.15423959884978636},
{-0.3062096581467217,0.6050393186410897,-0.1628493372336514},
{-0.28088813819427816,0.558780031513493,-0.16836275620800503},
{-0.2982678229750273,0.6107065106805711,-0.17392410444941145},
{-0.2729463030225838,0.5644470016582195,-0.1794373015290102},
{-0.2294513807512069,0.6469692172063405,-0.16212662601702685},
{-0.20412986079876344,0.6007099300787437,-0.16764004499138047},
{-0.16217244728390837,0.6811436721939909,-0.13986592231331493},
{-0.13685070543670996,0.6348841631716392,-0.14537911939291367},
{-0.15793314799204108,0.6817807320352343,-0.12574276495509626},
{-0.13261162803959758,0.6355212230128826,-0.131255962034695},
{-0.16587498316373547,0.6761137618905078,-0.11466799773933622},
{-0.15823803138523793,0.6177536662006137,-0.09987427443188839},
{-0.12812824451736893,0.6343751366039584,-0.10104765389566198},
{-0.18355955133768145,0.6640131752229653,-0.09436107735228966},
{-0.21298900888710684,0.5886750242586442,-0.1073496868288377},
{-0.23831052883955037,0.6349343113862409,-0.10183626785448406},
{-0.26597503550870816,0.5619939551430877,-0.12683581851760545},
{-0.2912965554611517,0.6082532422706844,-0.12132239954325183},
{-0.3189379850758026,0.59498526729775,-0.13694822818147703},
{-0.2936162432286042,0.5487257582753984,-0.14246142526107583},
{-0.3258999330099735,0.5932587042100758,-0.15443708518162416},
{-0.30057841305753,0.5469991951877241,-0.1599505041559778},
{-0.3009860337222335,0.5483780491945109,-0.17339222272197852},
{-0.32630777556943186,0.5946375582168626,-0.16787902564237975},
{-0.15344976446981243,0.68063464562631,-0.09553423492130833},
{-0.11670266169415316,0.642165195763319,-0.1139350793639875},
{-0.14202418164659666,0.6884247047856706,-0.10842166038963386},
{-0.1378350305693309,0.6921824924594614,-0.12071307654636788},
{-0.11251351061688739,0.6459232053318646,-0.12622649552072154},
{-0.1728462506776111,0.6785668084056395,-0.16726948075074094},
{-0.14520504295771508,0.6918350052733289,-0.15164387400727056},
{-0.14752473072516759,0.6323072993832879,-0.17278289972509456},
{-0.22583227729921246,0.6518857392900831,-0.1867558343342636},
{-0.20051075734676893,0.6056262302677314,-0.19226903141386234},
{-0.2805832548010813,0.6228068754533587,-0.19423102483645802},
{-0.25526173484863784,0.5765475883257619,-0.19974444381081166},
{-0.2853715217165068,0.5599261179224171,-0.19857106434703803},
{-0.31069304166895034,0.606185405050014,-0.19305764537268444},
{-0.2967971045397226,0.5521360587630565,-0.1856836388787125},
{-0.3221186244921661,0.5983953458906534,-0.1801702199043589},
{-0.11988330111051669,0.6455754962509772,-0.15715707108686935},
{-0.13824287312878927,0.6935613464662482,-0.1341547951123686},
{-0.11292135317634576,0.6473018374438966,-0.13966821408672223},
{0.19969684738589116,-0.1002749054118134,-0.22930282221281884},
{0.18936942170454668,-0.09413308049165668,-0.2521854969144424},
{0.2098190204189772,-0.09857319453668491,-0.24253795676203183},
{0.19913101576096254,-0.09337908211459492,-0.26085159656604556},
{0.15919306641021547,-0.0857188313868356,-0.27502379266509136},
{0.08312088759677105,-0.07355544850366387,-0.29080406005270887},
{0.08133707566233919,-0.0759789830163974,-0.27866353232928914},
{0.0051024698883270145,-0.06403638541432526,-0.2933378762586148},
{-0.030634789857900833,-0.06317587755492397,-0.27833357482879156},
{-0.037557906209968815,-0.06007423267129559,-0.28898274790470324},
{-0.05316864600486261,-0.06156780626635229,-0.2737947176178444},
{-0.05854116180987127,-0.06393786414316122,-0.259995082812232},
{-0.047216762994878016,-0.06553129037791122,-0.2586490692291665},
{-0.05733893602796407,-0.06723300125303973,-0.24541393467995345},
{-0.0368895592082884,-0.07167311529806794,-0.23576639452754275},
{-0.04665093136994938,-0.07242689178037483,-0.22710029487593975},
{-0.006712982019202341,-0.08008736440288901,-0.2129280987768939},
{0.06935897489948721,-0.09225074728606075,-0.19714783138927638},
{0.07114300872867396,-0.08982721277332721,-0.2092883591126961},
{0.14737761450268613,-0.10176981037539937,-0.19461401518337046},
{0.1831146523541591,-0.10263009634004579,-0.20961831661319372},
{0.1900377687062271,-0.10573174122367415,-0.19896914353728196},
{0.20564873039587575,-0.10423838952337233,-0.21415717382414082},
{0.2110212462008844,-0.1018683316465634,-0.22795680862975326},
{0.13429292459727765,0.11450368467335201,-0.2220408725700583},
{0.19913101576096254,-0.09337908211459492,-0.26085159656604556},
{0.10154392151493762,0.10777206349474028,-0.23598118865026083},
{0.04331230288811555,0.25148020443607555,-0.21343756913408454},
{-0.012326919317513878,0.23110139014844974,-0.2308492067595355},
{0.03920946887049577,0.09352997054790914,-0.2535492620778979},
{0.15919306641021547,-0.0857188313868356,-0.27502379266509136},
{0.14311457247204734,0.11446574067026857,-0.2066759921635648},
{0.2098190204189772,-0.09857319453668491,-0.24253795676203183},
{0.07251986568266695,0.26156554293985246,-0.19990420803432088},
{-0.03247696011286456,0.40269238219773884,-0.1934186681388644},
{-0.0835444846838255,0.3768451935709988,-0.2110899226275179},
{-0.1359986295779939,0.3491141184753788,-0.21932510266515567},
{-0.06939691890257069,0.20877899970288288,-0.23852299306734215},
{-0.024666042846545812,0.07719452248359694,-0.2606301456006813},
{0.08312088759677105,-0.07355544850366387,-0.29080406005270887},
{-0.0673572623157691,0.0616310462714913,-0.23622505098586732},
{-0.047216762994878016,-0.06553129037791122,-0.2586490692291665},
{-0.05386095764006941,0.06766436465651465,-0.2509224719696998},
{-0.09554699386971362,0.196869464419287,-0.22997871363616493},
{-0.013638317318819062,0.2293200190563215,-0.22192437782374944},
{0.037797108755722925,0.09161146849726876,-0.2439376688757769},
{-0.030634789857900833,-0.06317587755492397,-0.27833357482879156},
{-0.07228931703235293,0.06227875706096842,-0.24874479684536666},
{-0.05316864600486261,-0.06156780626635229,-0.2737947176178444},
{-0.07663246306950122,0.05938369619412769,-0.2380365997646584},
{-0.11597040900306903,0.1868795406601058,-0.218366739218855},
{-0.11509880640592407,0.18570838014388094,-0.2074000347487186},
{-0.07559088909012278,0.05779382027545567,-0.2262763996510927},
{-0.05854116180987127,-0.06393786414316122,-0.259995082812232},
{0.08133707566233919,-0.0759789830163974,-0.27866353232928914},
{0.12633666626651643,0.1113219357832141,-0.21572952005717783},
{0.18936942170454668,-0.09413308049165668,-0.2521854969144424},
{0.13488094569769368,0.11062829277947807,-0.1967273408287902},
{0.19969684738589116,-0.1002749054118134,-0.22930282221281884},
{0.12138486291674884,0.10459497439445471,-0.1820296979502028},
{0.1831146523541591,-0.10263009634004579,-0.20961831661319372},
{0.029726796520956503,0.08064809244845546,-0.1890147229388806},
{0.07114300872867396,-0.08982721277332721,-0.2092883591126961},
{-0.05881276098983701,0.06093740326775526,-0.21722287175747965},
{-0.0368895592082884,-0.07167311529806794,-0.23576639452754275},
{0.1398130004142775,0.10998058199000094,-0.18420737307453602},
{0.20564873039587575,-0.10423838952337233,-0.21415717382414082},
{0.14415636834618065,0.11287564285684168,-0.19491579204999906},
{0.08120016659858194,0.2615799660989193,-0.17448305733693897},
{0.08032856400143698,0.262751348509899,-0.18544976180707537},
{0.2110212462008844,-0.1018683316465634,-0.22795680862975326},
{0.0051024698883270145,-0.06403638541432526,-0.2933378762586148},
{-0.05957053157773163,0.06753522190917799,-0.25990277459420447},
{-0.037557906209968815,-0.06007423267129559,-0.28898274790470324},
{-0.034020238133013046,0.06448727555622909,-0.1969712031643967},
{-0.006712982019202341,-0.08008736440288901,-0.2129280987768939},
{0.02831443640618366,0.07872936850306021,-0.1794031297367596},
{-0.022443544981728087,0.21735811661057533,-0.16200058979625845},
{0.034626454603328714,0.23968072895089712,-0.1543268034884518},
{0.09218994812322524,0.09506481656737242,-0.17232202431922136},
{0.06935897489948721,-0.09225074728606075,-0.19714783138927638},
{-0.05733893602796407,-0.06723300125303973,-0.24541393467995345},
{-0.06676924121535309,0.05775587627237222,-0.21091151924459922},
{-0.10729010808715406,0.18689418571392746,-0.19294536662671818},
{-0.07808254529260264,0.19697952421770445,-0.17941222742170942},
{-0.04665093136994938,-0.07242689178037483,-0.22710029487593975},
{0.1270942149596562,0.10472411714179138,-0.17304961722045306},
{0.1900377687062271,-0.10573174122367415,-0.19896914353728196},
{0.07726286606809815,0.2585868277504243,-0.16458655126955973},
{0.0021028965919406366,0.417050526101369,-0.15507126039105398},
{0.0013797415858063568,0.41792523522508224,-0.16573263767848379},
{-0.005700920042222148,0.4157351339944761,-0.179875987459396},
{0.14737761450268613,-0.10176981037539937,-0.19461401518337046},
{0.0658352861920885,0.25248472199139,-0.15441334244285268},
{-0.0015909853924464064,0.4138896353181893,-0.14551536277240631},
{-0.12495026783806389,0.6461419935601704,-0.12801052934990825},
{-0.12552919125353007,0.647091481216276,-0.13863573779229363},
{-0.1320331484136411,0.6451998284309755,-0.1526346340877829},
{-0.10060575049133047,0.1959747847676351,-0.23843645411294132},
{-0.11203310847258524,0.18987290090335568,-0.2282632452862342},
{-0.17530173803504653,0.3264828505310274,-0.2099476084294267},
{-0.17899562001943356,0.32332195974784766,-0.200391710810779},
{-0.012178471726503189,0.40693567559519384,-0.1357934878771129},
{-0.13851070009792216,0.6364001481369382,-0.10855213450549976},
{-0.12849991823178283,0.6430556594146283,-0.11841846288621614},
{0.06537463268097013,0.25783637968944045,-0.1941629031467117},
{-0.012316268369279928,0.4114612191208485,-0.1743989592248417},
{-0.005504986973668427,0.41311300367613035,-0.15697533928262755},
{0.07291705729389138,0.2584419304754915,-0.17632655896043195},
{-0.10014487508545723,0.1906231270695846,-0.19868689340908227},
{-0.10768729969837847,0.1900177981782884,-0.21652323759536202},
{-0.17138751455906961,0.3272594821730863,-0.19848785381396034},
{-0.16012058648558872,0.33496433374657525,-0.21138726159904905},
{-0.021132146980422904,0.21913970959745846,-0.17092541873204456},
{-0.16457623316345812,0.3289112667283682,-0.18106423387174614},
{-0.2871158363845711,0.5622122995818837,-0.16859286106880933},
{-0.2764387045695453,0.5696116020779112,-0.18164005076064413},
{-0.20595782978941524,0.6072693609275733,-0.1739014711844143},
{-0.08481549783974363,0.37511863048332444,-0.2024415745563048},
{-0.1382828141846666,0.6411151897832553,-0.14706596331946564},
{-0.132061550942265,0.6424616471558307,-0.12979012528399755},
{-0.14273846086253597,0.6350621227650483,-0.11674293559216274},
{-0.016772136941904194,0.40540815210264136,-0.14407570960278396},
{0.060776529570471645,0.25159004233973814,-0.16287086102487416},
{-0.09207722558774929,0.3652538553658922,-0.1530216185402831},
{-0.28089457314216953,0.5635587569544589,-0.15131680113858634},
{-0.16471425170098972,0.33343681025402283,-0.21966948332472008},
{-0.28066646533415907,0.5682735767060211,-0.18983062995255226},
{-0.2906772472002984,0.5616180654283311,-0.17996452346659073},
{-0.2942271194887722,0.558531731282789,-0.17037245700289858},
{-0.29364797417855115,0.5575824655214382,-0.15974724856051326},
{-0.17827246501329927,0.3224470287293796,-0.1897303335233492},
{-0.17119180338527076,0.3246373518547406,-0.17558698374243698},
{-0.09334801684891254,0.3635272922782178,-0.14437304857431507},
{-0.040893871954744136,0.3912583673738378,-0.13613786853667728},
{-0.16541499533688173,0.6216603452549248,-0.10844340607561151},
{-0.14441554141987348,0.3376801036514778,-0.16204452495772348},
{-0.21449034879858414,0.5956780227224666,-0.11583294520242458},
{-0.2871440170184401,0.5594741183067389,-0.1457481303702691},
{-0.2621790819370791,0.5715793647641335,-0.13265878067500825},
{-0.2537621700951995,0.5830136014827895,-0.18993958027719537},
{-0.2132195575374209,0.5974043639153861,-0.12448151516839258},
{-0.15699808349500216,0.6330943600788259,-0.16572398378304373},
{-0.20468703852825199,0.6089957021204927,-0.18255004115038226}
};


// texture array: 43kb.
const tgx::fVec2 sinbad_tex_array[5530] PROGMEM = {
{0.140529,0.822671},
{0.13147,0.870192},
{0.112898,0.842011},
{0.07959,0.856291},
{0.079675,0.891469},
{0.046204,0.842181},
{0.027774,0.870454},
{0.037107,0.814723},
{0.018473,0.822977},
{0.049236,0.787974},
{0.038863,0.78128},
{0.079384,0.77648},
{0.079366,0.7692},
{0.109592,0.787824},
{0.11993,0.781075},
{0.121855,0.814513},
{0.102618,0.828445},
{0.079544,0.838646},
{0.056422,0.828562},
{0.04931,0.811341},
{0.057125,0.79366},
{0.079406,0.78485},
{0.101732,0.793551},
{0.109637,0.811196},
{0.095308,0.819245},
{0.079506,0.82488},
{0.063679,0.819323},
{0.059236,0.808537},
{0.064397,0.799032},
{0.079428,0.79315},
{0.094488,0.798962},
{0.099698,0.808439},
{0.087069,0.812555},
{0.07948,0.814411},
{0.071882,0.812592},
{0.068872,0.807759},
{0.072297,0.803685},
{0.079451,0.802411},
{0.08661,0.803653},
{0.090055,0.807709},
{0.079463,0.807945},
{0.522133,0.747166},
{0.507882,0.739026},
{0.500495,0.767025},
{0.535779,0.769006},
{0.533852,0.802025},
{0.500163,0.793861},
{0.529815,0.821626},
{0.501974,0.814238},
{0.522977,0.836469},
{0.563736,0.842867},
{0.556554,0.851801},
{0.572814,0.851507},
{0.56561,0.858444},
{0.588642,0.869836},
{0.582734,0.874749},
{0.522133,0.747166},
{0.500495,0.767025},
{0.507882,0.739026},
{0.542371,0.730242},
{0.525892,0.712151},
{0.554034,0.709635},
{0.567717,0.741711},
{0.569331,0.725469},
{0.586004,0.734702},
{0.587903,0.720444},
{0.602064,0.72665},
{0.595466,0.708444},
{0.631207,0.710023},
{0.625987,0.699611},
{0.87797,0.568711},
{0.857445,0.562096},
{0.872718,0.592979},
{0.893772,0.579667},
{0.907661,0.59696},
{0.892357,0.614697},
{0.839356,0.585155},
{0.872718,0.592979},
{0.839356,0.585155},
{0.857445,0.562096},
{0.87797,0.568711},
{0.862199,0.531812},
{0.886412,0.536552},
{0.859784,0.503699},
{0.878128,0.504979},
{0.877202,0.477798},
{0.849701,0.462902},
{0.873691,0.457964},
{0.867354,0.440674},
{0.858392,0.424253},
{0.83722,0.429354},
{0.851725,0.410291},
{0.813826,0.407501},
{0.525892,0.712151},
{0.542371,0.730242},
{0.554034,0.709635},
{0.567717,0.741711},
{0.858392,0.424253},
{0.849701,0.462902},
{0.867354,0.440674},
{0.895513,0.408863},
{0.914252,0.411987},
{0.873691,0.457964},
{0.877202,0.477798},
{0.859784,0.503699},
{0.878128,0.504979},
{0.886412,0.536552},
{0.862199,0.531812},
{0.927762,0.57602},
{0.9403,0.585331},
{0.933277,0.564296},
{0.910888,0.56584},
{0.934841,0.548072},
{0.964555,0.563044},
{0.962108,0.572447},
{0.927762,0.57602},
{0.933277,0.564296},
{0.9403,0.585331},
{0.917964,0.584948},
{0.910888,0.56584},
{0.907661,0.59696},
{0.893772,0.579667},
{0.892357,0.614697},
{0.595466,0.708444},
{0.587903,0.720444},
{0.602064,0.72665},
{0.586004,0.734702},
{0.569331,0.725469},
{0.575128,0.8234},
{0.592133,0.83756},
{0.602429,0.861326},
{0.575128,0.8234},
{0.563736,0.842867},
{0.533852,0.802025},
{0.593535,0.795426},
{0.535779,0.769006},
{0.500163,0.793861},
{0.529815,0.821626},
{0.522977,0.836469},
{0.556554,0.851801},
{0.572814,0.851507},
{0.592133,0.83756},
{0.598782,0.831476},
{0.619531,0.805194},
{0.621813,0.794884},
{0.621138,0.762073},
{0.594831,0.766936},
{0.619104,0.752915},
{0.594831,0.766936},
{0.621138,0.762073},
{0.593535,0.795426},
{0.619104,0.752915},
{0.642656,0.728827},
{0.625327,0.755013},
{0.648602,0.734044},
{0.621813,0.794884},
{0.619531,0.805194},
{0.598782,0.831476},
{0.600997,0.839218},
{0.607958,0.859289},
{0.600997,0.839218},
{0.607958,0.859289},
{0.602429,0.861326},
{0.588642,0.869836},
{0.56561,0.858444},
{0.582734,0.874749},
{0.91237,0.432595},
{0.936972,0.442891},
{0.9256,0.465892},
{0.946892,0.488458},
{0.928452,0.511318},
{0.938963,0.53533},
{0.914252,0.411987},
{0.91237,0.432595},
{0.936972,0.442891},
{0.928589,0.427624},
{0.923677,0.421022},
{0.933034,0.392979},
{0.926951,0.385231},
{0.907866,0.401166},
{0.895513,0.408863},
{0.923677,0.421022},
{0.928589,0.427624},
{0.963644,0.419871},
{0.966334,0.431068},
{0.943153,0.455698},
{0.945631,0.468024},
{0.986577,0.473405},
{0.984007,0.485732},
{0.947176,0.506881},
{0.946336,0.518317},
{0.976009,0.540739},
{0.968089,0.550527},
{0.9256,0.465892},
{0.943153,0.455698},
{0.945631,0.468024},
{0.946892,0.488458},
{0.986577,0.473405},
{0.987251,0.466485},
{0.954252,0.459367},
{0.971288,0.438623},
{0.966334,0.431068},
{0.928452,0.511318},
{0.947176,0.506881},
{0.984007,0.485732},
{0.946336,0.518317},
{0.938963,0.53533},
{0.976009,0.540739},
{0.983209,0.535908},
{0.960181,0.516497},
{0.986633,0.497384},
{0.934841,0.548072},
{0.968089,0.550527},
{0.907866,0.401166},
{0.926951,0.385231},
{0.933034,0.392979},
{0.938481,0.39816},
{0.934952,0.418402},
{0.96251,0.412838},
{0.890213,0.397283},
{0.851725,0.410291},
{0.83722,0.429354},
{0.813826,0.407501},
{0.902702,0.393019},
{0.922731,0.378838},
{0.890213,0.397283},
{0.902702,0.393019},
{0.922731,0.378838},
{0.501974,0.814238},
{0.626275,0.845116},
{0.638922,0.827063},
{0.624771,0.801607},
{0.659251,0.790289},
{0.660052,0.770143},
{0.934952,0.418402},
{0.96251,0.412838},
{0.963644,0.419871},
{0.660052,0.770143},
{0.625327,0.755013},
{0.642656,0.728827},
{0.648602,0.734044},
{0.661119,0.761807},
{0.661119,0.761807},
{0.638922,0.827063},
{0.624771,0.801607},
{0.659251,0.790289},
{0.660607,0.796954},
{0.64458,0.821748},
{0.64458,0.821748},
{0.631207,0.710023},
{0.625987,0.699611},
{0.626275,0.845116},
{0.62194,0.851177},
{0.964555,0.563044},
{0.917964,0.584948},
{0.954252,0.459367},
{0.971288,0.438623},
{0.976551,0.444454},
{0.469846,0.86775},
{0.481442,0.875756},
{0.4887,0.864522},
{0.489436,0.854182},
{0.523313,0.864843},
{0.515933,0.881164},
{0.507223,0.894296},
{0.472965,0.88645},
{0.46295,0.892396},
{0.49645,0.907375},
{0.483516,0.919361},
{0.511797,0.920121},
{0.495963,0.933604},
{0.550246,0.951773},
{0.533904,0.96859},
{0.568379,0.968318},
{0.549271,0.982537},
{0.469846,0.86775},
{0.4887,0.864522},
{0.481442,0.875756},
{0.472965,0.88645},
{0.507223,0.894296},
{0.515933,0.881164},
{0.523313,0.864843},
{0.489436,0.854182},
{0.356726,0.875679},
{0.333748,0.888224},
{0.355727,0.890709},
{0.391255,0.888359},
{0.388585,0.904483},
{0.345713,0.906576},
{0.334013,0.914606},
{0.374323,0.929621},
{0.362354,0.941305},
{0.381053,0.934281},
{0.372009,0.949843},
{0.429868,0.965036},
{0.417301,0.9799},
{0.438124,0.970199},
{0.430346,0.988017},
{0.333748,0.888224},
{0.356726,0.875679},
{0.355727,0.890709},
{0.391255,0.888359},
{0.388585,0.904483},
{0.403838,0.892458},
{0.396334,0.908899},
{0.452423,0.918808},
{0.446259,0.936031},
{0.465668,0.926343},
{0.454756,0.941352},
{0.429868,0.965036},
{0.438124,0.970199},
{0.417301,0.9799},
{0.430346,0.988017},
{0.345713,0.906576},
{0.334013,0.914606},
{0.374323,0.929621},
{0.46295,0.892396},
{0.49645,0.907375},
{0.524029,0.905939},
{0.532757,0.891869},
{0.53893,0.87334},
{0.960181,0.516497},
{0.986633,0.497384},
{0.989938,0.50444},
{0.396334,0.908899},
{0.446259,0.936031},
{0.454756,0.941352},
{0.362354,0.941305},
{0.381053,0.934281},
{0.524029,0.905939},
{0.563256,0.935696},
{0.584827,0.949507},
{0.483516,0.919361},
{0.511797,0.920121},
{0.563256,0.935696},
{0.574373,0.918014},
{0.584948,0.897552},
{0.495963,0.933604},
{0.550246,0.951773},
{0.584827,0.949507},
{0.595449,0.928874},
{0.6018,0.906097},
{0.532757,0.891869},
{0.53893,0.87334},
{0.574373,0.918014},
{0.595449,0.928874},
{0.372009,0.949843},
{0.403838,0.892458},
{0.452423,0.918808},
{0.465668,0.926343},
{0.584948,0.897552},
{0.6018,0.906097},
{0.533904,0.96859},
{0.568379,0.968318},
{0.549271,0.982537},
{0.962108,0.572447},
{0.983209,0.535908},
{0.648997,0.944403},
{0.652825,0.921915},
{0.624784,0.942676},
{0.646315,0.965083},
{0.629286,0.975459},
{0.647399,0.988278},
{0.664241,0.973599},
{0.667586,0.99282},
{0.674487,0.957055},
{0.694807,0.974096},
{0.710848,0.951547},
{0.687476,0.937463},
{0.732215,0.930924},
{0.698234,0.906963},
{0.661944,0.886888},
{0.623656,0.916279},
{0.619891,0.872238},
{0.648997,0.944403},
{0.624784,0.942676},
{0.652825,0.921915},
{0.687476,0.937463},
{0.698234,0.906963},
{0.661944,0.886888},
{0.623656,0.916279},
{0.619891,0.872238},
{0.674487,0.957055},
{0.710848,0.951547},
{0.732215,0.930924},
{0.694807,0.974096},
{0.667586,0.99282},
{0.664241,0.973599},
{0.647399,0.988278},
{0.646315,0.965083},
{0.629286,0.975459},
{0.938559,0.964042},
{0.955692,0.942803},
{0.922037,0.944727},
{0.911866,0.983372},
{0.901687,0.971263},
{0.898105,0.93298},
{0.939369,0.924352},
{0.988951,0.915756},
{0.964308,0.896919},
{0.91228,0.911129},
{0.92117,0.883165},
{0.955692,0.942803},
{0.938559,0.964042},
{0.922037,0.944727},
{0.911866,0.983372},
{0.901687,0.971263},
{0.891859,0.98015},
{0.886463,0.961954},
{0.898105,0.93298},
{0.939369,0.924352},
{0.91228,0.911129},
{0.964308,0.896919},
{0.92117,0.883165},
{0.988951,0.915756},
{0.886463,0.961954},
{0.891859,0.98015},
{0.987251,0.466485},
{0.989938,0.50444},
{0.660607,0.796954},
{0.454756,0.941352},
{0.465668,0.926343},
{0.446259,0.936031},
{0.429868,0.965036},
{0.381053,0.934281},
{0.396334,0.908899},
{0.452423,0.918808},
{0.465668,0.926343},
{0.454756,0.941352},
{0.446259,0.936031},
{0.429868,0.965036},
{0.438124,0.970199},
{0.417301,0.9799},
{0.430346,0.988017},
{0.452423,0.918808},
{0.396334,0.908899},
{0.381053,0.934281},
{0.372009,0.949843},
{0.584827,0.949507},
{0.595449,0.928874},
{0.563256,0.935696},
{0.550246,0.951773},
{0.511797,0.920121},
{0.524029,0.905939},
{0.574373,0.918014},
{0.6018,0.906097},
{0.584948,0.897552},
{0.532757,0.891869},
{0.53893,0.87334},
{0.515933,0.881164},
{0.523313,0.864843},
{0.4887,0.864522},
{0.489436,0.854182},
{0.469846,0.86775},
{0.481442,0.875756},
{0.472965,0.88645},
{0.46295,0.892396},
{0.49645,0.907375},
{0.483516,0.919361},
{0.495963,0.933604},
{0.533904,0.96859},
{0.568379,0.968318},
{0.549271,0.982537},
{0.595449,0.928874},
{0.584827,0.949507},
{0.563256,0.935696},
{0.550246,0.951773},
{0.568379,0.968318},
{0.533904,0.96859},
{0.549271,0.982537},
{0.574373,0.918014},
{0.524029,0.905939},
{0.511797,0.920121},
{0.495963,0.933604},
{0.438124,0.970199},
{0.417301,0.9799},
{0.372009,0.949843},
{0.362354,0.941305},
{0.374323,0.929621},
{0.388585,0.904483},
{0.403838,0.892458},
{0.430346,0.988017},
{0.6018,0.906097},
{0.584948,0.897552},
{0.532757,0.891869},
{0.507223,0.894296},
{0.49645,0.907375},
{0.483516,0.919361},
{0.53893,0.87334},
{0.515933,0.881164},
{0.481442,0.875756},
{0.472965,0.88645},
{0.46295,0.892396},
{0.507223,0.894296},
{0.403838,0.892458},
{0.388585,0.904483},
{0.374323,0.929621},
{0.362354,0.941305},
{0.391255,0.888359},
{0.355727,0.890709},
{0.356726,0.875679},
{0.333748,0.888224},
{0.345713,0.906576},
{0.334013,0.914606},
{0.391255,0.888359},
{0.355727,0.890709},
{0.345713,0.906576},
{0.334013,0.914606},
{0.523313,0.864843},
{0.4887,0.864522},
{0.469846,0.86775},
{0.489436,0.854182},
{0.356726,0.875679},
{0.333748,0.888224},
{0.976551,0.444454},
{0.62194,0.851177},
{0.454756,0.941352},
{0.465668,0.926343},
{0.446259,0.936031},
{0.429868,0.965036},
{0.381053,0.934281},
{0.396334,0.908899},
{0.452423,0.918808},
{0.465668,0.926343},
{0.454756,0.941352},
{0.446259,0.936031},
{0.429868,0.965036},
{0.438124,0.970199},
{0.417301,0.9799},
{0.430346,0.988017},
{0.452423,0.918808},
{0.396334,0.908899},
{0.381053,0.934281},
{0.372009,0.949843},
{0.584827,0.949507},
{0.595449,0.928874},
{0.563256,0.935696},
{0.550246,0.951773},
{0.511797,0.920121},
{0.524029,0.905939},
{0.574373,0.918014},
{0.6018,0.906097},
{0.584948,0.897552},
{0.532757,0.891869},
{0.53893,0.87334},
{0.515933,0.881164},
{0.523313,0.864843},
{0.4887,0.864522},
{0.489436,0.854182},
{0.469846,0.86775},
{0.481442,0.875756},
{0.472965,0.88645},
{0.46295,0.892396},
{0.49645,0.907375},
{0.483516,0.919361},
{0.495963,0.933604},
{0.533904,0.96859},
{0.568379,0.968318},
{0.549271,0.982537},
{0.595449,0.928874},
{0.584827,0.949507},
{0.563256,0.935696},
{0.550246,0.951773},
{0.568379,0.968318},
{0.533904,0.96859},
{0.549271,0.982537},
{0.574373,0.918014},
{0.524029,0.905939},
{0.511797,0.920121},
{0.495963,0.933604},
{0.438124,0.970199},
{0.417301,0.9799},
{0.372009,0.949843},
{0.362354,0.941305},
{0.374323,0.929621},
{0.388585,0.904483},
{0.403838,0.892458},
{0.430346,0.988017},
{0.6018,0.906097},
{0.584948,0.897552},
{0.532757,0.891869},
{0.507223,0.894296},
{0.49645,0.907375},
{0.483516,0.919361},
{0.53893,0.87334},
{0.515933,0.881164},
{0.481442,0.875756},
{0.472965,0.88645},
{0.46295,0.892396},
{0.507223,0.894296},
{0.403838,0.892458},
{0.388585,0.904483},
{0.374323,0.929621},
{0.362354,0.941305},
{0.391255,0.888359},
{0.355727,0.890709},
{0.356726,0.875679},
{0.333748,0.888224},
{0.345713,0.906576},
{0.334013,0.914606},
{0.391255,0.888359},
{0.355727,0.890709},
{0.345713,0.906576},
{0.334013,0.914606},
{0.523313,0.864843},
{0.4887,0.864522},
{0.469846,0.86775},
{0.489436,0.854182},
{0.356726,0.875679},
{0.333748,0.888224},
{0.469846,0.86775},
{0.481442,0.875756},
{0.4887,0.864522},
{0.489436,0.854182},
{0.523313,0.864843},
{0.515933,0.881164},
{0.507223,0.894296},
{0.472965,0.88645},
{0.46295,0.892396},
{0.49645,0.907375},
{0.483516,0.919361},
{0.511797,0.920121},
{0.495963,0.933604},
{0.550246,0.951773},
{0.533904,0.96859},
{0.568379,0.968318},
{0.549271,0.982537},
{0.469846,0.86775},
{0.4887,0.864522},
{0.481442,0.875756},
{0.472965,0.88645},
{0.507223,0.894296},
{0.515933,0.881164},
{0.523313,0.864843},
{0.489436,0.854182},
{0.356726,0.875679},
{0.333748,0.888224},
{0.355727,0.890709},
{0.391255,0.888359},
{0.388585,0.904483},
{0.345713,0.906576},
{0.334013,0.914606},
{0.374323,0.929621},
{0.362354,0.941305},
{0.381053,0.934281},
{0.372009,0.949843},
{0.429868,0.965036},
{0.417301,0.9799},
{0.438124,0.970199},
{0.430346,0.988017},
{0.333748,0.888224},
{0.356726,0.875679},
{0.355727,0.890709},
{0.391255,0.888359},
{0.388585,0.904483},
{0.403838,0.892458},
{0.396334,0.908899},
{0.452423,0.918808},
{0.446259,0.936031},
{0.465668,0.926343},
{0.454756,0.941352},
{0.429868,0.965036},
{0.438124,0.970199},
{0.417301,0.9799},
{0.430346,0.988017},
{0.345713,0.906576},
{0.334013,0.914606},
{0.374323,0.929621},
{0.46295,0.892396},
{0.49645,0.907375},
{0.524029,0.905939},
{0.532757,0.891869},
{0.53893,0.87334},
{0.396334,0.908899},
{0.446259,0.936031},
{0.454756,0.941352},
{0.362354,0.941305},
{0.381053,0.934281},
{0.524029,0.905939},
{0.563256,0.935696},
{0.584827,0.949507},
{0.483516,0.919361},
{0.511797,0.920121},
{0.563256,0.935696},
{0.574373,0.918014},
{0.584948,0.897552},
{0.495963,0.933604},
{0.550246,0.951773},
{0.584827,0.949507},
{0.595449,0.928874},
{0.6018,0.906097},
{0.532757,0.891869},
{0.53893,0.87334},
{0.574373,0.918014},
{0.595449,0.928874},
{0.372009,0.949843},
{0.403838,0.892458},
{0.452423,0.918808},
{0.465668,0.926343},
{0.584948,0.897552},
{0.6018,0.906097},
{0.533904,0.96859},
{0.568379,0.968318},
{0.549271,0.982537},
{0.938481,0.39816},
{0.945229,0.401418},
{0.945229,0.401418},
{0.584774,0.225673},
{0.564783,0.251429},
{0.560314,0.209177},
{0.604588,0.198581},
{0.577529,0.183795},
{0.554151,0.163593},
{0.542609,0.166608},
{0.547709,0.205527},
{0.545463,0.23388},
{0.530402,0.262056},
{0.551241,0.275799},
{0.602655,0.296694},
{0.604357,0.268949},
{0.619098,0.239901},
{0.65045,0.21566},
{0.654487,0.165549},
{0.617829,0.159968},
{0.591097,0.157254},
{0.570892,0.144403},
{0.535694,0.131661},
{0.518802,0.136295},
{0.886245,0.225681},
{0.910707,0.209185},
{0.906236,0.251439},
{0.866659,0.268958},
{0.868359,0.296705},
{0.919777,0.275812},
{0.940619,0.262069},
{0.925558,0.23389},
{0.923313,0.205535},
{0.928414,0.166613},
{0.916871,0.163598},
{0.893491,0.183801},
{0.866431,0.198587},
{0.851918,0.239908},
{0.829563,0.264437},
{0.831856,0.302907},
{0.884469,0.336798},
{0.922712,0.32184},
{0.948889,0.31792},
{0.950355,0.281241},
{0.657717,0.518811},
{0.652046,0.565949},
{0.639962,0.506013},
{0.647367,0.479733},
{0.629076,0.467062},
{0.622113,0.496196},
{0.606313,0.524798},
{0.62591,0.540179},
{0.641479,0.585575},
{0.619097,0.566486},
{0.602378,0.605957},
{0.623444,0.62493},
{0.576009,0.634603},
{0.595035,0.654184},
{0.568028,0.670742},
{0.551619,0.654564},
{0.533174,0.669644},
{0.544485,0.683993},
{0.522312,0.67868},
{0.530242,0.696632},
{0.657772,0.518835},
{0.640012,0.506046},
{0.652137,0.566109},
{0.685781,0.527269},
{0.681321,0.572526},
{0.677397,0.598721},
{0.696849,0.602713},
{0.705494,0.577017},
{0.725808,0.610421},
{0.733338,0.580213},
{0.75253,0.605475},
{0.757003,0.584586},
{0.788618,0.598641},
{0.789298,0.585337},
{0.82264,0.587936},
{0.795703,0.552854},
{0.830955,0.55129},
{0.799469,0.519975},
{0.829094,0.516989},
{0.797515,0.481147},
{0.824004,0.482072},
{0.826047,0.451643},
{0.802268,0.446484},
{0.787841,0.430692},
{0.825406,0.437921},
{0.62601,0.540481},
{0.606408,0.525105},
{0.622159,0.496238},
{0.629112,0.467101},
{0.647407,0.479763},
{0.664877,0.487617},
{0.691253,0.492613},
{0.715435,0.536102},
{0.681244,0.572513},
{0.685724,0.527257},
{0.705417,0.577014},
{0.715374,0.536101},
{0.69121,0.492603},
{0.664836,0.487596},
{0.830891,0.551335},
{0.822561,0.587979},
{0.795637,0.552886},
{0.799417,0.520008},
{0.771796,0.517401},
{0.768707,0.549214},
{0.78922,0.585367},
{0.788534,0.598671},
{0.756924,0.584604},
{0.752443,0.605492},
{0.73326,0.58022},
{0.725718,0.610427},
{0.696761,0.602707},
{0.67731,0.598708},
{0.72272,0.500668},
{0.741689,0.541599},
{0.746698,0.508464},
{0.721015,0.468263},
{0.697251,0.463305},
{0.741751,0.541588},
{0.722766,0.500666},
{0.697283,0.463313},
{0.721048,0.468262},
{0.746746,0.508452},
{0.768771,0.549192},
{0.747289,0.471945},
{0.747456,0.434717},
{0.724336,0.43157},
{0.699423,0.431492},
{0.667633,0.459611},
{0.649499,0.451796},
{0.771848,0.517379},
{0.829043,0.517034},
{0.797476,0.481182},
{0.772546,0.477057},
{0.773045,0.44099},
{0.750768,0.421474},
{0.713413,0.415865},
{0.670677,0.413753},
{0.676019,0.434307},
{0.656034,0.433803},
{0.633988,0.441246},
{0.591688,0.497848},
{0.599726,0.471965},
{0.578856,0.518729},
{0.566344,0.533979},
{0.594492,0.54663},
{0.591734,0.497903},
{0.599763,0.472016},
{0.578236,0.461975},
{0.584999,0.442374},
{0.606688,0.453266},
{0.634014,0.44128},
{0.649527,0.451824},
{0.667664,0.459631},
{0.699443,0.4315},
{0.724355,0.431569},
{0.747476,0.434706},
{0.747324,0.471933},
{0.772582,0.477035},
{0.606657,0.453219},
{0.584974,0.442321},
{0.578204,0.461917},
{0.567225,0.491447},
{0.554674,0.51446},
{0.540536,0.526174},
{0.521647,0.545774},
{0.550346,0.556661},
{0.57797,0.57814},
{0.549941,0.610145},
{0.52887,0.631209},
{0.517297,0.650478},
{0.511335,0.661735},
{0.616175,0.433429},
{0.591187,0.424072},
{0.560222,0.432352},
{0.551449,0.453809},
{0.537426,0.482453},
{0.525924,0.509258},
{0.51828,0.521393},
{0.510888,0.53328},
{0.494702,0.575615},
{0.5308,0.577812},
{0.567267,0.491511},
{0.551476,0.453876},
{0.560241,0.432412},
{0.591204,0.42412},
{0.616196,0.433469},
{0.636834,0.428328},
{0.656055,0.433827},
{0.67604,0.434324},
{0.670691,0.413772},
{0.713426,0.415869},
{0.750783,0.421461},
{0.773067,0.44097},
{0.520914,0.461971},
{0.506916,0.503951},
{0.496897,0.514176},
{0.496706,0.544298},
{0.485031,0.551691},
{0.478257,0.577742},
{0.486513,0.600476},
{0.505015,0.605714},
{0.537462,0.482527},
{0.52094,0.46205},
{0.506987,0.504201},
{0.486534,0.497447},
{0.493779,0.45885},
{0.506416,0.431078},
{0.532939,0.429481},
{0.56637,0.414996},
{0.598098,0.414978},
{0.619743,0.421841},
{0.630148,0.406157},
{0.532925,0.429411},
{0.506408,0.430998},
{0.493762,0.45876},
{0.4865,0.497347},
{0.566359,0.41494},
{0.543261,0.409841},
{0.522649,0.405298},
{0.499361,0.399361},
{0.479652,0.425621},
{0.46129,0.447045},
{0.461928,0.485896},
{0.526013,0.509583},
{0.496897,0.514176},
{0.51828,0.521393},
{0.510888,0.53328},
{0.496706,0.544298},
{0.485243,0.517384},
{0.485031,0.551691},
{0.494702,0.575615},
{0.478257,0.577742},
{0.486513,0.600476},
{0.475458,0.59524},
{0.474589,0.61483},
{0.505015,0.605714},
{0.494939,0.629336},
{0.495538,0.648099},
{0.477129,0.632438},
{0.47965,0.425712},
{0.49935,0.399439},
{0.522647,0.405368},
{0.543266,0.409904},
{0.571729,0.406051},
{0.567727,0.391141},
{0.59958,0.398995},
{0.461297,0.447148},
{0.461954,0.486007},
{0.440168,0.474882},
{0.520664,0.281226},
{0.522128,0.317902},
{0.548303,0.321824},
{0.586542,0.336784},
{0.639155,0.302899},
{0.641451,0.26443},
{0.678531,0.257207},
{0.699858,0.208116},
{0.693147,0.162132},
{0.698694,0.122007},
{0.657116,0.121517},
{0.617265,0.123456},
{0.590733,0.112107},
{0.564385,0.088243},
{0.548302,0.120235},
{0.725762,0.207707},
{0.735508,0.205563},
{0.718902,0.25765},
{0.719775,0.303999},
{0.735505,0.3054},
{0.735506,0.259788},
{0.752111,0.257651},
{0.745254,0.207708},
{0.735509,0.156944},
{0.725349,0.158872},
{0.725728,0.128673},
{0.726512,0.074329},
{0.706023,0.074007},
{0.665404,0.070277},
{0.630984,0.066415},
{0.592243,0.053101},
{0.880288,0.11211},
{0.906638,0.088245},
{0.90013,0.144407},
{0.879924,0.157258},
{0.93533,0.131665},
{0.922721,0.120239},
{0.853756,0.123458},
{0.878779,0.053102},
{0.840037,0.066416},
{0.805617,0.070277},
{0.813904,0.121519},
{0.816531,0.165552},
{0.853191,0.159972},
{0.820566,0.215665},
{0.792482,0.25721},
{0.791214,0.304255},
{0.806217,0.345223},
{0.845328,0.343776},
{0.900582,0.370916},
{0.942818,0.353697},
{0.979,0.324322},
{0.991341,0.296307},
{0.492018,0.324302},
{0.47968,0.296287},
{0.528196,0.353678},
{0.570428,0.370899},
{0.625681,0.343765},
{0.66479,0.345216},
{0.679797,0.30425},
{0.363844,0.280037},
{0.370059,0.237846},
{0.391142,0.288597},
{0.358984,0.303842},
{0.381016,0.307807},
{0.372162,0.330174},
{0.353545,0.324088},
{0.348913,0.344418},
{0.368726,0.352313},
{0.343777,0.365377},
{0.363604,0.375939},
{0.389862,0.383519},
{0.395544,0.366511},
{0.418824,0.377591},
{0.421445,0.397864},
{0.401962,0.253838},
{0.415955,0.210853},
{0.372555,0.193116},
{0.332239,0.228668},
{0.324298,0.269377},
{0.318516,0.295513},
{0.323359,0.313455},
{0.323923,0.338877},
{0.323569,0.365676},
{0.343448,0.39805},
{0.359524,0.389564},
{0.165089,0.280036},
{0.13779,0.288596},
{0.158874,0.237845},
{0.196694,0.228668},
{0.156379,0.193115},
{0.112978,0.210852},
{0.12697,0.253837},
{0.117684,0.260636},
{0.097648,0.225708},
{0.106839,0.186656},
{0.083835,0.191561},
{0.084041,0.236203},
{0.0733,0.20412},
{0.057016,0.210225},
{0.065019,0.240691},
{0.411249,0.260637},
{0.431286,0.225709},
{0.422094,0.186657},
{0.376933,0.163717},
{0.337334,0.183864},
{0.288333,0.222258},
{0.283118,0.262587},
{0.283644,0.284738},
{0.289458,0.30527},
{0.292397,0.335863},
{0.295104,0.367613},
{0.325358,0.403069},
{0.771158,0.208118},
{0.745668,0.158873},
{0.735509,0.131285},
{0.73551,0.07277},
{0.73551,0.029967},
{0.727059,0.02642},
{0.708134,0.02472},
{0.670528,0.02636},
{0.637841,0.020523},
{0.603391,0.008417},
{0.777871,0.162134},
{0.74529,0.128673},
{0.744508,0.074329},
{0.743962,0.026419},
{0.764997,0.074007},
{0.762886,0.02472},
{0.800493,0.02636},
{0.833181,0.020523},
{0.867631,0.008417},
{0.772325,0.122008},
{0.2941,0.145377},
{0.264467,0.145692},
{0.295126,0.130114},
{0.341225,0.139417},
{0.341089,0.124134},
{0.320263,0.106409},
{0.294898,0.110166},
{0.277024,0.110032},
{0.269059,0.133608},
{0.264467,0.13321},
{0.259874,0.133608},
{0.233807,0.130114},
{0.234833,0.145377},
{0.236263,0.157335},
{0.264467,0.159972},
{0.292671,0.157336},
{0.339241,0.155966},
{0.38142,0.147686},
{0.385297,0.121541},
{0.374595,0.073728},
{0.337649,0.078761},
{0.296275,0.081741},
{0.27153,0.081046},
{0.264467,0.079739},
{0.257403,0.081046},
{0.251909,0.110032},
{0.234035,0.110166},
{0.20867,0.106409},
{0.187844,0.124134},
{0.187709,0.139416},
{0.189693,0.155966},
{0.236885,0.181374},
{0.264467,0.180201},
{0.292048,0.181374},
{0.427759,0.163209},
{0.434083,0.124193},
{0.4118,0.068588},
{0.390177,0.021216},
{0.35618,0.023004},
{0.327988,0.022153},
{0.318569,0.054575},
{0.294956,0.055494},
{0.277554,0.056154},
{0.271574,0.025194},
{0.264465,0.022623},
{0.257357,0.025195},
{0.251379,0.056154},
{0.233977,0.055494},
{0.232659,0.081742},
{0.191285,0.078761},
{0.154339,0.073728},
{0.143637,0.12154},
{0.147514,0.147685},
{0.152001,0.163716},
{0.1916,0.183864},
{0.2406,0.222258},
{0.264467,0.219576},
{0.210365,0.054576},
{0.200946,0.022154},
{0.172754,0.023005},
{0.138758,0.021217},
{0.117135,0.068588},
{0.094851,0.124192},
{0.101175,0.163207},
{0.245815,0.262587},
{0.264466,0.261401},
{0.295575,0.022},
{0.233357,0.022002},
{0.204635,0.269377},
{0.245289,0.284738},
{0.264466,0.273746},
{0.445099,0.191563},
{0.466185,0.157974},
{0.490224,0.126581},
{0.465174,0.098733},
{0.449451,0.055464},
{0.429337,0.013753},
{0.567728,0.391091},
{0.599573,0.398955},
{0.598085,0.414935},
{0.619726,0.421804},
{0.630136,0.406126},
{0.636814,0.428297},
{0.571722,0.406},
{0.553796,0.397691},
{0.540778,0.37791},
{0.535207,0.389932},
{0.553796,0.397747},
{0.540767,0.377967},
{0.5352,0.389994},
{0.520042,0.362779},
{0.513746,0.374575},
{0.787824,0.430719},
{0.825386,0.437962},
{0.826022,0.451685},
{0.802242,0.446523},
{0.823966,0.482114},
{0.520064,0.362716},
{0.513764,0.374507},
{0.751234,0.304},
{0.760318,0.343013},
{0.793324,0.388103},
{0.830812,0.386645},
{0.863308,0.381357},
{0.455634,0.204121},
{0.477558,0.17147},
{0.471918,0.210227},
{0.444892,0.236205},
{0.463914,0.240693},
{0.492133,0.181861},
{0.499197,0.14178},
{0.051376,0.171468},
{0.06275,0.157972},
{0.038711,0.126579},
{0.029737,0.141778},
{0.036801,0.181859},
{0.063761,0.098732},
{0.079485,0.055463},
{0.099598,0.013753},
{0.51191,0.155051},
{0.017024,0.155049},
{0.952222,0.136299},
{0.440153,0.474764},
{0.594492,0.54663},
{0.566344,0.533979},
{0.550346,0.556661},
{0.521647,0.545774},
{0.540536,0.526174},
{0.57895,0.519043},
{0.554766,0.514779},
{0.619097,0.566486},
{0.641479,0.585575},
{0.602378,0.605957},
{0.57797,0.57814},
{0.485243,0.517384},
{0.210417,0.295513},
{0.205573,0.313456},
{0.175387,0.324088},
{0.180019,0.344418},
{0.20501,0.338877},
{0.239474,0.30527},
{0.264466,0.302294},
{0.169948,0.303842},
{0.15677,0.330174},
{0.160206,0.352313},
{0.185155,0.365378},
{0.205364,0.365677},
{0.236536,0.335863},
{0.264466,0.334899},
{0.475458,0.59524},
{0.474589,0.61483},
{0.494939,0.629336},
{0.495538,0.648099},
{0.477129,0.632438},
{0.5308,0.577812},
{0.52887,0.631209},
{0.517297,0.650478},
{0.511335,0.661735},
{0.147916,0.307807},
{0.710688,0.343011},
{0.677678,0.388095},
{0.640192,0.386633},
{0.661985,0.394391},
{0.701228,0.380165},
{0.735503,0.347022},
{0.769774,0.380169},
{0.7355,0.380731},
{0.809017,0.394401},
{0.551619,0.654564},
{0.576009,0.634603},
{0.533174,0.669644},
{0.522312,0.67868},
{0.544485,0.683993},
{0.530242,0.696632},
{0.549941,0.610145},
{0.623444,0.62493},
{0.595035,0.654184},
{0.568028,0.670742},
{0.607698,0.381342},
{0.740806,0.636146},
{0.77257,0.63567},
{0.735654,0.669288},
{0.720363,0.635445},
{0.702079,0.665836},
{0.704992,0.699414},
{0.738388,0.696197},
{0.771134,0.668202},
{0.815793,0.667948},
{0.81528,0.643977},
{0.857989,0.635664},
{0.858405,0.667941},
{0.894399,0.669267},
{0.889243,0.636137},
{0.909687,0.635433},
{0.927975,0.665824},
{0.938462,0.642242},
{0.952753,0.661178},
{0.968055,0.643061},
{0.890878,0.695913},
{0.924646,0.699827},
{0.889544,0.724993},
{0.916224,0.721669},
{0.913132,0.736995},
{0.87992,0.767772},
{0.901452,0.772322},
{0.926586,0.74592},
{0.9245,0.73564},
{0.922696,0.718654},
{0.930792,0.733131},
{0.934891,0.749269},
{0.93727,0.777202},
{0.927614,0.779462},
{0.941237,0.807625},
{0.948362,0.801197},
{0.952901,0.823587},
{0.959753,0.818558},
{0.987294,0.855289},
{0.96873,0.848108},
{0.98469,0.861123},
{0.96574,0.855134},
{0.946275,0.83488},
{0.943376,0.848654},
{0.941643,0.857435},
{0.914773,0.858585},
{0.921774,0.843701},
{0.897714,0.839544},
{0.896013,0.861138},
{0.868911,0.862287},
{0.872187,0.893573},
{0.902382,0.890531},
{0.86292,0.915091},
{0.884733,0.921375},
{0.850336,0.929716},
{0.866704,0.944025},
{0.837361,0.942432},
{0.84438,0.963508},
{0.815147,0.949064},
{0.823604,0.976606},
{0.815405,0.979701},
{0.806437,0.976607},
{0.78566,0.963254},
{0.792036,0.941793},
{0.762822,0.944612},
{0.779061,0.930143},
{0.745248,0.92163},
{0.767091,0.91492},
{0.727239,0.890659},
{0.75798,0.89344},
{0.733495,0.860757},
{0.760344,0.862082},
{0.733117,0.838833},
{0.714061,0.85831},
{0.708342,0.843527},
{0.686283,0.848488},
{0.687615,0.857014},
{0.663027,0.855419},
{0.684004,0.835252},
{0.661245,0.847902},
{0.644279,0.861577},
{0.642655,0.855503},
{0.677235,0.823446},
{0.669813,0.818433},
{0.681625,0.800801},
{0.688857,0.807741},
{0.691716,0.777506},
{0.701991,0.778981},
{0.703311,0.746046},
{0.695192,0.748914},
{0.698606,0.733702},
{0.70468,0.73544},
{0.70734,0.720396},
{0.716396,0.737024},
{0.728727,0.772461},
{0.74978,0.768035},
{0.74024,0.725151},
{0.713073,0.722386},
{0.77119,0.695253},
{0.815041,0.693846},
{0.858607,0.695774},
{0.165328,0.37594},
{0.139069,0.383521},
{0.185485,0.398052},
{0.203575,0.40307},
{0.233829,0.367614},
{0.264467,0.369844},
{0.133387,0.366513},
{0.110105,0.377593},
{0.107484,0.397866},
{0.169408,0.389566},
{0.384023,0.479893},
{0.360802,0.477666},
{0.394388,0.464287},
{0.429814,0.487512},
{0.414842,0.498616},
{0.452671,0.525235},
{0.440271,0.524697},
{0.443156,0.574681},
{0.423533,0.562918},
{0.418251,0.586407},
{0.436091,0.599998},
{0.413211,0.606043},
{0.430555,0.609928},
{0.368799,0.455782},
{0.343648,0.443912},
{0.332126,0.468614},
{0.354081,0.49015},
{0.381559,0.500377},
{0.407202,0.516621},
{0.42428,0.530293},
{0.390001,0.545516},
{0.402734,0.578942},
{0.395172,0.602989},
{0.395984,0.643365},
{0.415896,0.623991},
{0.429793,0.610924},
{0.426425,0.621962},
{0.440915,0.620218},
{0.446512,0.65096},
{0.437132,0.654922},
{0.457645,0.676581},
{0.448686,0.677464},
{0.467883,0.695724},
{0.462252,0.698809},
{0.481373,0.741744},
{0.488065,0.742253},
{0.483485,0.748738},
{0.441451,0.730729},
{0.439504,0.736875},
{0.462682,0.748954},
{0.119528,0.478875},
{0.109277,0.463097},
{0.142844,0.476852},
{0.149469,0.489391},
{0.171618,0.468108},
{0.16032,0.44332},
{0.135062,0.454868},
{0.088378,0.49742},
{0.073407,0.486118},
{0.121816,0.499458},
{0.159776,0.510266},
{0.175966,0.480341},
{0.2093,0.451034},
{0.206103,0.426357},
{0.691591,0.642256},
{0.677303,0.661192},
{0.662,0.643078},
{0.407457,0.677256},
{0.410605,0.68021},
{0.395839,0.698704},
{0.398997,0.665687},
{0.384013,0.676443},
{0.363668,0.694665},
{0.395007,0.713579},
{0.416041,0.716671},
{0.410227,0.693291},
{0.41373,0.683013},
{0.424678,0.677755},
{0.423615,0.67527},
{0.422521,0.672869},
{0.422416,0.668155},
{0.414207,0.669345},
{0.411279,0.664972},
{0.405179,0.655021},
{0.393995,0.655856},
{0.375074,0.658399},
{0.355464,0.684761},
{0.329918,0.696285},
{0.337223,0.708421},
{0.307501,0.699802},
{0.311933,0.714785},
{0.281457,0.695969},
{0.283972,0.714551},
{0.260356,0.689447},
{0.259838,0.705782},
{0.25164,0.688255},
{0.251428,0.702996},
{0.243015,0.705369},
{0.242512,0.689643},
{0.218861,0.714545},
{0.222006,0.693283},
{0.191479,0.714764},
{0.195314,0.699555},
{0.164299,0.708584},
{0.172447,0.696835},
{0.138603,0.69417},
{0.147127,0.684368},
{0.126945,0.658827},
{0.118605,0.676268},
{0.106708,0.698603},
{0.10753,0.713538},
{0.086406,0.716625},
{0.089568,0.723112},
{0.060876,0.73072},
{0.062825,0.736894},
{0.018648,0.748769},
{0.039539,0.749004},
{0.095066,0.677054},
{0.091901,0.680017},
{0.078842,0.675042},
{0.077771,0.677535},
{0.08876,0.682828},
{0.092266,0.693153},
{0.081188,0.710241},
{0.058403,0.725184},
{0.020774,0.741747},
{0.014053,0.742253},
{0.034362,0.695541},
{0.040014,0.698645},
{0.053659,0.677219},
{0.044661,0.676324},
{0.065287,0.654588},
{0.055869,0.650597},
{0.076086,0.621486},
{0.061529,0.619715},
{0.07222,0.610512},
{0.086662,0.62354},
{0.089388,0.605506},
{0.106636,0.643038},
{0.107533,0.602489},
{0.084387,0.585724},
{0.066367,0.599331},
{0.072351,0.60939},
{0.079943,0.672631},
{0.065975,0.672114},
{0.060548,0.677385},
{0.075925,0.681828},
{0.081306,0.686244},
{0.081993,0.691956},
{0.071325,0.701733},
{0.052255,0.715824},
{0.047315,0.708245},
{0.071891,0.666628},
{0.080054,0.667897},
{0.086252,0.658846},
{0.081915,0.650424},
{0.441827,0.677622},
{0.436429,0.672369},
{0.454974,0.708362},
{0.450048,0.715904},
{0.443918,0.725219},
{0.412887,0.723128},
{0.430545,0.666901},
{0.416256,0.659135},
{0.426512,0.682031},
{0.438322,0.69195},
{0.431072,0.701856},
{0.421243,0.710319},
{0.420459,0.692109},
{0.421149,0.686422},
{0.088297,0.669102},
{0.091243,0.664715},
{0.0919,0.65599},
{0.097383,0.65473},
{0.093117,0.646076},
{0.108612,0.655585},
{0.124654,0.642734},
{0.139158,0.611306},
{0.11955,0.583958},
{0.112072,0.581795},
{0.106177,0.578542},
{0.100029,0.578286},
{0.079188,0.562058},
{0.058718,0.57379},
{0.300101,0.608551},
{0.276848,0.608833},
{0.300617,0.601538},
{0.327649,0.596619},
{0.300481,0.572881},
{0.271435,0.575438},
{0.270267,0.600251},
{0.266596,0.604166},
{0.269472,0.608647},
{0.276255,0.622594},
{0.299277,0.617179},
{0.323293,0.619705},
{0.326201,0.609129},
{0.363674,0.611678},
{0.332998,0.573403},
{0.30219,0.550921},
{0.273501,0.550665},
{0.25162,0.550851},
{0.255022,0.576525},
{0.255379,0.596967},
{0.255735,0.601089},
{0.258726,0.603922},
{0.258726,0.603922},
{0.260263,0.605096},
{0.263848,0.608762},
{0.263528,0.616136},
{0.268595,0.619005},
{0.26007,0.626991},
{0.265333,0.639131},
{0.281826,0.629976},
{0.301757,0.624202},
{0.320842,0.626478},
{0.339824,0.629644},
{0.352929,0.622936},
{0.362087,0.648252},
{0.377837,0.642822},
{0.383283,0.584498},
{0.337927,0.556049},
{0.302709,0.54294},
{0.273701,0.541922},
{0.251658,0.542013},
{0.22977,0.550399},
{0.231712,0.575325},
{0.248125,0.576511},
{0.251573,0.576851},
{0.251536,0.596349},
{0.251529,0.600447},
{0.251518,0.603958},
{0.254222,0.604175},
{0.258726,0.603922},
{0.258726,0.603922},
{0.255551,0.605215},
{0.256632,0.607275},
{0.256446,0.61779},
{0.202911,0.608389},
{0.20242,0.601366},
{0.22617,0.608754},
{0.226728,0.622524},
{0.233556,0.60859},
{0.236448,0.604116},
{0.232282,0.600103},
{0.202706,0.572635},
{0.175362,0.596339},
{0.1766,0.608881},
{0.179149,0.61965},
{0.203707,0.617033},
{0.201201,0.624058},
{0.220929,0.6301},
{0.23698,0.639217},
{0.242908,0.626968},
{0.234065,0.618955},
{0.239143,0.615937},
{0.239346,0.608723},
{0.242015,0.605402},
{0.243898,0.6039},
{0.243898,0.6039},
{0.247151,0.600991},
{0.247691,0.596954},
{0.235213,0.809796},
{0.296654,0.836307},
{0.271244,0.843},
{0.250912,0.844869},
{0.250172,0.869174},
{0.271965,0.871412},
{0.305362,0.873523},
{0.313435,0.842308},
{0.304139,0.818518},
{0.304724,0.791507},
{0.291461,0.772856},
{0.263927,0.76009},
{0.235658,0.756756},
{0.207337,0.759615},
{0.179593,0.771918},
{0.166019,0.790343},
{0.166151,0.81736},
{0.173336,0.835272},
{0.19863,0.842391},
{0.218928,0.844601},
{0.234895,0.847721},
{0.234731,0.867327},
{0.234369,0.91041},
{0.300995,0.898041},
{0.313468,0.896014},
{0.318822,0.896567},
{0.307351,0.862489},
{0.16796,0.896925},
{0.164005,0.872337},
{0.197433,0.870786},
{0.156457,0.840991},
{0.148169,0.813725},
{0.149472,0.779304},
{0.166582,0.756139},
{0.196207,0.737003},
{0.235908,0.726968},
{0.275434,0.737667},
{0.304735,0.757297},
{0.321454,0.780746},
{0.32218,0.815185},
{0.21926,0.868915},
{0.291999,0.930562},
{0.308743,0.936334},
{0.314573,0.939236},
{0.176409,0.929593},
{0.159571,0.935082},
{0.183631,0.965379},
{0.194699,0.952252},
{0.216652,0.962108},
{0.233916,0.964365},
{0.251216,0.962398},
{0.273331,0.952911},
{0.284177,0.966223},
{0.289471,0.972724},
{0.155523,0.894689},
{0.153692,0.937886},
{0.178229,0.971791},
{0.207511,0.986494},
{0.210193,0.977659},
{0.233779,0.980734},
{0.257413,0.978055},
{0.259947,0.986934},
{0.15016,0.895151},
{0.366784,0.536384},
{0.384811,0.549485},
{0.361607,0.541352},
{0.339379,0.523024},
{0.341137,0.518823},
{0.316532,0.51957},
{0.317073,0.513334},
{0.28621,0.520335},
{0.287218,0.512375},
{0.25162,0.51931},
{0.251646,0.512189},
{0.21614,0.512202},
{0.217123,0.520107},
{0.186304,0.513321},
{0.186743,0.519679},
{0.162152,0.517937},
{0.163857,0.522112},
{0.136384,0.535739},
{0.141566,0.540781},
{0.11819,0.548778},
{0.12371,0.552366},
{0.11504,0.564024},
{0.379297,0.553025},
{0.396616,0.579168},
{0.370597,0.529297},
{0.343601,0.511099},
{0.319204,0.505525},
{0.287491,0.504366},
{0.251676,0.503314},
{0.21589,0.504213},
{0.184267,0.505408},
{0.132579,0.528577},
{0.112997,0.544758},
{0.09592,0.515589},
{0.078646,0.529216},
{0.06259,0.523474},
{0.050098,0.523928},
{0.387868,0.564672},
{0.162201,0.861272},
{0.233693,0.990923},
{0.064054,0.691778},
{0.420585,0.650756},
{0.410637,0.656284},
{0.409439,0.646412},
{0.347588,0.669824},
{0.327024,0.685298},
{0.308479,0.689182},
{0.282556,0.685726},
{0.261501,0.679949},
{0.251851,0.678764},
{0.241993,0.679527},
{0.220505,0.683848},
{0.19426,0.68888},
{0.175441,0.685176},
{0.15574,0.669443},
{0.140817,0.648387},
{0.149908,0.622634},
{0.17011,0.573071},
{0.165263,0.555674},
{0.135668,0.566826},
{0.1306,0.559017},
{0.126815,0.553943},
{0.161387,0.538113},
{0.162917,0.547259},
{0.199216,0.531365},
{0.200664,0.542584},
{0.228378,0.527892},
{0.229636,0.541615},
{0.251686,0.527751},
{0.275099,0.528432},
{0.304225,0.531763},
{0.340307,0.547654},
{0.341882,0.538511},
{0.3724,0.559604},
{0.376195,0.554576},
{0.390736,0.582379},
{0.103575,0.665448},
{0.701776,0.822944},
{0.730669,0.810269},
{0.927265,0.823084},
{0.900182,0.810976},
{0.874631,0.806445},
{0.756348,0.806511},
{0.367315,0.567349},
{0.778318,0.761868},
{0.781863,0.803876},
{0.815607,0.759528},
{0.815148,0.720943},
{0.774653,0.72416},
{0.854816,0.724147},
{0.851404,0.762546},
{0.848691,0.804469},
{0.871044,0.835626},
{0.841946,0.837831},
{0.839948,0.875027},
{0.845289,0.891014},
{0.842929,0.905033},
{0.835581,0.914023},
{0.826918,0.922514},
{0.815402,0.925888},
{0.804078,0.922835},
{0.794455,0.914179},
{0.787098,0.905432},
{0.785008,0.891298},
{0.789342,0.875408},
{0.788099,0.837055},
{0.758594,0.835871},
{0.81531,0.801263},
{0.81512,0.831358},
{0.831137,0.862568},
{0.815401,0.886279},
{0.799138,0.8632},
{0.275096,0.640109},
{0.284767,0.663744},
{0.289689,0.636628},
{0.302557,0.635412},
{0.315326,0.636493},
{0.330864,0.635434},
{0.345724,0.644081},
{0.22846,0.639643},
{0.218116,0.663686},
{0.217679,0.639428},
{0.210748,0.650163},
{0.198307,0.653515},
{0.198231,0.66665},
{0.219755,0.671793},
{0.239138,0.654006},
{0.251872,0.653817},
{0.251392,0.638086},
{0.251489,0.626693},
{0.246054,0.617944},
{0.263783,0.654032},
{0.283321,0.67266},
{0.304416,0.666896},
{0.30469,0.654032},
{0.291703,0.650333},
{0.285256,0.63951},
{0.265876,0.445546},
{0.293377,0.450399},
{0.26597,0.458216},
{0.251195,0.448432},
{0.251363,0.465231},
{0.291485,0.472098},
{0.327679,0.480803},
{0.297797,0.426536},
{0.251515,0.415416},
{0.251221,0.438603},
{0.236959,0.44568},
{0.236815,0.458545},
{0.211672,0.472315},
{0.251294,0.493631},
{0.815392,0.859281},
{0.248814,0.604167},
{0.251515,0.607031},
{0.243898,0.6039},
{0.243898,0.6039},
{0.246728,0.605201},
{0.246061,0.607343},
{0.251502,0.61814},
{0.261644,0.666897},
{0.30569,0.677375},
{0.31875,0.66586},
{0.316471,0.652071},
{0.20114,0.550585},
{0.33593,0.643197},
{0.332,0.653017},
{0.337875,0.658081},
{0.320913,0.675667},
{0.167925,0.642641},
{0.15728,0.643175},
{0.171343,0.635026},
{0.179874,0.638522},
{0.187447,0.635595},
{0.181911,0.626773},
{0.163447,0.628785},
{0.164881,0.657931},
{0.171229,0.653154},
{0.179634,0.647982},
{0.177874,0.642498},
{0.325678,0.642375},
{0.323077,0.639388},
{0.323011,0.647923},
{0.182352,0.675658},
{0.196738,0.67706},
{0.184244,0.665961},
{0.186016,0.65219},
{0.213248,0.636533},
{0.251657,0.665448},
{0.241255,0.666675},
{0.200406,0.635406},
{0.29389,0.401868},
{0.264467,0.39803},
{0.235044,0.401869},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.107846,0.951829},
{0.112242,0.962413},
{0.099924,0.951048},
{0.104401,0.943144},
{0.095152,0.945035},
{0.094995,0.961954},
{0.117813,0.978212},
{0.138294,0.960747},
{0.12467,0.949493},
{0.114254,0.945731},
{0.113165,0.938396},
{0.10778,0.933606},
{0.100912,0.934388},
{0.096107,0.938472},
{0.08352,0.948262},
{0.08988,0.978097},
{0.107846,0.951829},
{0.099924,0.951048},
{0.112242,0.962413},
{0.12467,0.949493},
{0.138294,0.960747},
{0.117813,0.978212},
{0.094995,0.961954},
{0.095152,0.945035},
{0.104401,0.943144},
{0.114254,0.945731},
{0.124156,0.932607},
{0.140302,0.930639},
{0.08988,0.978097},
{0.08352,0.948262},
{0.096107,0.938472},
{0.100912,0.934388},
{0.10778,0.933606},
{0.113165,0.938396},
{0.112899,0.92185},
{0.122624,0.907824},
{0.124156,0.932607},
{0.112899,0.92185},
{0.09722,0.921435},
{0.085927,0.930479},
{0.069386,0.957846},
{0.140302,0.930639},
{0.122624,0.907824},
{0.091789,0.906391},
{0.069782,0.92625},
{0.09722,0.921435},
{0.091789,0.906391},
{0.085927,0.930479},
{0.069782,0.92625},
{0.069386,0.957846},
{0.114254,0.945731},
{0.12467,0.949493},
{0.113165,0.938396},
{0.104401,0.943144},
{0.10778,0.933606},
{0.124156,0.932607},
{0.138294,0.960747},
{0.117813,0.978212},
{0.112242,0.962413},
{0.107846,0.951829},
{0.099924,0.951048},
{0.095152,0.945035},
{0.096107,0.938472},
{0.100912,0.934388},
{0.112899,0.92185},
{0.140302,0.930639},
{0.114254,0.945731},
{0.113165,0.938396},
{0.12467,0.949493},
{0.112242,0.962413},
{0.117813,0.978212},
{0.138294,0.960747},
{0.124156,0.932607},
{0.10778,0.933606},
{0.104401,0.943144},
{0.107846,0.951829},
{0.094995,0.961954},
{0.08988,0.978097},
{0.140302,0.930639},
{0.112899,0.92185},
{0.100912,0.934388},
{0.096107,0.938472},
{0.095152,0.945035},
{0.099924,0.951048},
{0.08352,0.948262},
{0.069386,0.957846},
{0.094995,0.961954},
{0.08352,0.948262},
{0.085927,0.930479},
{0.09722,0.921435},
{0.122624,0.907824},
{0.08988,0.978097},
{0.069386,0.957846},
{0.069782,0.92625},
{0.091789,0.906391},
{0.085927,0.930479},
{0.069782,0.92625},
{0.09722,0.921435},
{0.091789,0.906391},
{0.122624,0.907824},
{0.095152,0.945035},
{0.104401,0.943144},
{0.099924,0.951048},
{0.094995,0.961954},
{0.112242,0.962413},
{0.107846,0.951829},
{0.114254,0.945731},
{0.113165,0.938396},
{0.10778,0.933606},
{0.100912,0.934388},
{0.096107,0.938472},
{0.08352,0.948262},
{0.08988,0.978097},
{0.117813,0.978212},
{0.138294,0.960747},
{0.12467,0.949493},
{0.124156,0.932607},
{0.112899,0.92185},
{0.09722,0.921435},
{0.085927,0.930479},
{0.069386,0.957846},
{0.095152,0.945035},
{0.099924,0.951048},
{0.104401,0.943144},
{0.096107,0.938472},
{0.100912,0.934388},
{0.10778,0.933606},
{0.113165,0.938396},
{0.114254,0.945731},
{0.107846,0.951829},
{0.112242,0.962413},
{0.094995,0.961954},
{0.08352,0.948262},
{0.085927,0.930479},
{0.09722,0.921435},
{0.112899,0.92185},
{0.124156,0.932607},
{0.12467,0.949493},
{0.138294,0.960747},
{0.117813,0.978212},
{0.08988,0.978097},
{0.069386,0.957846},
{0.069782,0.92625},
{0.091789,0.906391},
{0.122624,0.907824},
{0.140302,0.930639},
{0.069782,0.92625},
{0.091789,0.906391},
{0.122624,0.907824},
{0.140302,0.930639},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.041118,0.952548},
{0.351962,0.809928},
{0.358697,0.834497},
{0.343723,0.809909},
{0.351013,0.78074},
{0.357985,0.78514},
{0.371312,0.759701},
{0.375199,0.767073},
{0.39834,0.751965},
{0.398447,0.760308},
{0.425559,0.758942},
{0.421874,0.76641},
{0.446438,0.779408},
{0.439607,0.783983},
{0.454537,0.808341},
{0.446342,0.80857},
{0.447254,0.837513},
{0.454515,0.808334},
{0.446636,0.779709},
{0.446636,0.779709},
{0.425434,0.759087},
{0.425434,0.759087},
{0.398292,0.751949},
{0.398292,0.751949},
{0.371294,0.759905},
{0.371294,0.759905},
{0.350987,0.780959},
{0.350987,0.780959},
{0.343735,0.809556},
{0.351797,0.838794},
{0.351825,0.838848},
{0.37642,0.852034},
{0.380279,0.844883},
{0.365744,0.830312},
{0.360343,0.810114},
{0.365143,0.789709},
{0.379249,0.774666},
{0.398593,0.768922},
{0.418101,0.774104},
{0.432652,0.78873},
{0.43806,0.808977},
{0.440321,0.833333},
{0.426956,0.858555},
{0.423106,0.851367},
{0.399923,0.866292},
{0.399852,0.858115},
{0.372704,0.859315},
{0.372996,0.85962},
{0.400176,0.866109},
{0.400176,0.866109},
{0.426943,0.858394},
{0.426943,0.858394},
{0.447254,0.837544},
{0.454515,0.808334},
{0.446636,0.779709},
{0.425434,0.759087},
{0.398292,0.751949},
{0.371294,0.759905},
{0.350987,0.780959},
{0.343735,0.809556},
{0.351797,0.838794},
{0.372996,0.85962},
{0.368989,0.810393},
{0.373065,0.826162},
{0.37258,0.794459},
{0.383511,0.782551},
{0.398773,0.777897},
{0.414171,0.782103},
{0.425464,0.793676},
{0.429552,0.809498},
{0.433258,0.829334},
{0.419149,0.844319},
{0.399789,0.850032},
{0.39974,0.841837},
{0.384342,0.837669},
{0.377643,0.810718},
{0.380429,0.822128},
{0.380068,0.799184},
{0.387827,0.790439},
{0.398965,0.786862},
{0.410216,0.790106},
{0.418269,0.798637},
{0.421046,0.810069},
{0.425952,0.82538},
{0.415014,0.83722},
{0.410848,0.830237},
{0.399698,0.833771},
{0.388453,0.83057},
{0.388276,0.810996},
{0.389487,0.817175},
{0.389284,0.804742},
{0.393346,0.799898},
{0.39919,0.797596},
{0.405112,0.799716},
{0.409337,0.804433},
{0.410558,0.810654},
{0.418613,0.821557},
{0.409543,0.816868},
{0.405472,0.821672},
{0.399619,0.823926},
{0.393702,0.821851},
{0.399697,0.811415},
{0.351797,0.838794},
{0.351797,0.838794},
{0.343674,0.809882},
{0.358631,0.834458},
{0.351926,0.809884},
{0.350976,0.780732},
{0.35797,0.785119},
{0.371283,0.759706},
{0.375194,0.76707},
{0.398303,0.751979},
{0.398444,0.760322},
{0.425537,0.758969},
{0.421884,0.766439},
{0.446409,0.779445},
{0.439606,0.784034},
{0.454492,0.8084},
{0.446315,0.808647},
{0.44719,0.837556},
{0.440264,0.833395},
{0.426876,0.858593},
{0.423023,0.851415},
{0.399849,0.86631},
{0.399761,0.858132},
{0.372623,0.85931},
{0.376334,0.852015},
{0.372996,0.85962},
{0.400176,0.866109},
{0.400176,0.866109},
{0.426943,0.858394},
{0.426943,0.858394},
{0.447254,0.837544},
{0.447254,0.837544},
{0.454515,0.808334},
{0.454515,0.808334},
{0.446636,0.779709},
{0.446636,0.779709},
{0.425434,0.759087},
{0.425434,0.759087},
{0.398292,0.751949},
{0.398292,0.751949},
{0.371294,0.759905},
{0.371294,0.759905},
{0.350987,0.780959},
{0.350987,0.780959},
{0.343735,0.809556},
{0.351797,0.838794},
{0.372996,0.85962},
{0.343735,0.809556},
{0.351797,0.838794},
{0.372996,0.85962},
{0.400176,0.866109},
{0.400176,0.866109},
{0.426943,0.858394},
{0.447254,0.837544},
{0.454515,0.808334},
{0.446636,0.779709},
{0.425434,0.759087},
{0.398292,0.751949},
{0.371294,0.759905},
{0.350987,0.780959},
{0.343735,0.809556},
{0.351797,0.838794},
{0.372996,0.85962},
{0.400176,0.866109},
{0.426943,0.858394},
{0.426943,0.858394},
{0.447254,0.837544},
{0.454515,0.808334},
{0.446636,0.779709},
{0.425434,0.759087},
{0.398292,0.751949},
{0.371294,0.759905},
{0.350987,0.780959},
{0.343735,0.809556},
{0.351797,0.838794},
{0.372996,0.85962},
{0.400176,0.866109},
{0.426943,0.858394},
{0.447254,0.837544},
{0.447254,0.837544},
{0.454515,0.808334},
{0.446636,0.779709},
{0.425434,0.759087},
{0.398292,0.751949},
{0.371294,0.759905},
{0.350987,0.780959},
{0.343735,0.809556},
{0.399697,0.811415},
{0.454515,0.808334},
{0.446636,0.779709},
{0.425434,0.759087},
{0.398292,0.751949},
{0.371294,0.759905},
{0.350987,0.780959},
{0.365145,0.789678},
{0.360321,0.810062},
{0.379263,0.774657},
{0.398622,0.768929},
{0.418136,0.774137},
{0.432673,0.788793},
{0.438048,0.809053},
{0.433216,0.829403},
{0.419072,0.844371},
{0.399707,0.850049},
{0.380204,0.844858},
{0.365688,0.830267},
{0.373021,0.826116},
{0.36898,0.810344},
{0.372596,0.794425},
{0.383543,0.782537},
{0.398817,0.7779},
{0.414222,0.782133},
{0.425499,0.793734},
{0.429552,0.809572},
{0.425922,0.825448},
{0.414956,0.837267},
{0.399673,0.841852},
{0.384277,0.837646},
{0.380094,0.799154},
{0.377645,0.810681},
{0.387872,0.790422},
{0.399018,0.786865},
{0.410268,0.790135},
{0.418269,0.798637},
{0.421056,0.810135},
{0.418593,0.821615},
{0.410805,0.830278},
{0.399641,0.833782},
{0.388405,0.830551},
{0.380405,0.822089},
{0.389485,0.817155},
{0.388287,0.810972},
{0.389315,0.804718},
{0.393391,0.799881},
{0.399244,0.797593},
{0.405163,0.799738},
{0.409375,0.804469},
{0.410573,0.810695},
{0.40954,0.816907},
{0.405456,0.821701},
{0.399597,0.82394},
{0.393689,0.821844},
{0.399697,0.811415},
{0.343735,0.809556},
{0.351797,0.838794},
{0.372996,0.85962},
{0.400176,0.866109},
{0.400176,0.866109},
{0.426943,0.858394},
{0.447254,0.837544},
{0.454515,0.808334},
{0.446636,0.779709},
{0.425434,0.759087},
{0.398292,0.751949},
{0.371294,0.759905},
{0.350987,0.780959},
{0.343735,0.809556},
{0.351797,0.838794},
{0.372996,0.85962},
{0.400176,0.866109},
{0.426943,0.858394},
{0.426943,0.858394},
{0.447254,0.837544},
{0.454515,0.808334},
{0.446636,0.779709},
{0.425434,0.759087},
{0.398292,0.751949},
{0.371294,0.759905},
{0.350987,0.780959},
{0.343735,0.809556},
{0.351797,0.838794},
{0.372996,0.85962},
{0.400176,0.866109},
{0.426943,0.858394},
{0.447254,0.837544},
{0.447254,0.837544},
{0.454515,0.808334},
{0.446636,0.779709},
{0.425434,0.759087},
{0.398292,0.751949},
{0.371294,0.759905},
{0.350987,0.780959},
{0.399697,0.811415},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.148406,0.968394},
{0.331011,0.63327},
{0.334194,0.661496},
{0.339034,0.629319},
{0.322129,0.608496},
{0.326643,0.600007},
{0.347795,0.624457},
{0.344004,0.664525},
{0.317783,0.681685},
{0.312858,0.671893},
{0.32121,0.656639},
{0.319742,0.63894},
{0.316927,0.617297},
{0.293545,0.599236},
{0.292754,0.59043},
{0.291487,0.574975},
{0.333216,0.59049},
{0.358771,0.618344},
{0.353711,0.667204},
{0.32283,0.690597},
{0.291386,0.682025},
{0.331011,0.63327},
{0.339034,0.629319},
{0.334194,0.661496},
{0.32121,0.656639},
{0.312858,0.671893},
{0.317783,0.681685},
{0.344004,0.664525},
{0.347795,0.624457},
{0.326643,0.600007},
{0.322129,0.608496},
{0.316927,0.617297},
{0.319742,0.63894},
{0.269683,0.669859},
{0.26319,0.638174},
{0.261144,0.675224},
{0.287762,0.694281},
{0.285037,0.704404},
{0.253513,0.68084},
{0.253066,0.636347},
{0.272442,0.619084},
{0.265218,0.6118},
{0.29474,0.60879},
{0.26319,0.638174},
{0.269683,0.669859},
{0.261144,0.675224},
{0.287762,0.694281},
{0.291386,0.682025},
{0.32283,0.690597},
{0.253066,0.636347},
{0.253513,0.68084},
{0.285037,0.704404},
{0.328643,0.700961},
{0.353711,0.667204},
{0.29474,0.60879},
{0.272442,0.619084},
{0.265218,0.6118},
{0.293545,0.599236},
{0.258039,0.604592},
{0.243866,0.634954},
{0.244531,0.686268},
{0.28089,0.715889},
{0.336636,0.713512},
{0.365653,0.67039},
{0.358771,0.618344},
{0.328643,0.700961},
{0.336636,0.713512},
{0.28089,0.715889},
{0.244531,0.686268},
{0.243866,0.634954},
{0.258039,0.604592},
{0.248412,0.595885},
{0.353711,0.667204},
{0.328643,0.700961},
{0.344004,0.664525},
{0.339034,0.629319},
{0.331011,0.63327},
{0.334194,0.661496},
{0.32283,0.690597},
{0.285037,0.704404},
{0.28089,0.715889},
{0.336636,0.713512},
{0.365653,0.67039},
{0.347795,0.624457},
{0.322129,0.608496},
{0.316927,0.617297},
{0.353711,0.667204},
{0.344004,0.664525},
{0.328643,0.700961},
{0.336636,0.713512},
{0.28089,0.715889},
{0.285037,0.704404},
{0.32283,0.690597},
{0.334194,0.661496},
{0.331011,0.63327},
{0.339034,0.629319},
{0.347795,0.624457},
{0.365653,0.67039},
{0.287762,0.694281},
{0.253513,0.68084},
{0.244531,0.686268},
{0.287762,0.694281},
{0.317783,0.681685},
{0.292754,0.59043},
{0.326643,0.600007},
{0.293545,0.599236},
{0.265218,0.6118},
{0.272442,0.619084},
{0.29474,0.60879},
{0.358771,0.618344},
{0.333216,0.59049},
{0.291487,0.574975},
{0.258039,0.604592},
{0.253066,0.636347},
{0.26319,0.638174},
{0.292754,0.59043},
{0.293545,0.599236},
{0.326643,0.600007},
{0.333216,0.59049},
{0.358771,0.618344},
{0.322129,0.608496},
{0.29474,0.60879},
{0.272442,0.619084},
{0.265218,0.6118},
{0.258039,0.604592},
{0.291487,0.574975},
{0.243866,0.634954},
{0.261144,0.675224},
{0.269683,0.669859},
{0.243866,0.634954},
{0.253066,0.636347},
{0.248412,0.595885},
{0.26319,0.638174},
{0.269683,0.669859},
{0.261144,0.675224},
{0.253513,0.68084},
{0.232135,0.635338},
{0.232135,0.635338},
{0.248412,0.595885},
{0.291386,0.682025},
{0.244531,0.686268},
{0.291386,0.682025},
{0.316927,0.617297},
{0.317783,0.681685},
{0.365653,0.67039},
{0.292754,0.59043},
{0.291487,0.574975},
{0.248412,0.595885},
{0.333216,0.59049},
{0.232135,0.635338},
{0.232135,0.635338},
{0.334541,0.13923},
{0.33942,0.148106},
{0.334541,0.13923},
{0.324389,0.139016},
{0.324389,0.139016},
{0.319114,0.147679},
{0.319114,0.147679},
{0.323993,0.156556},
{0.323993,0.156556},
{0.334146,0.156769},
{0.334146,0.156769},
{0.33942,0.148106},
{0.324389,0.139016},
{0.334541,0.13923},
{0.329453,0.148651},
{0.33942,0.148106},
{0.334146,0.156769},
{0.323993,0.156556},
{0.319114,0.147679},
{0.223101,0.139232},
{0.227979,0.148109},
{0.223101,0.139232},
{0.212947,0.139018},
{0.212947,0.139018},
{0.207674,0.147681},
{0.207674,0.147681},
{0.212552,0.156558},
{0.212552,0.156558},
{0.222705,0.156771},
{0.222705,0.156771},
{0.227979,0.148109},
{0.212935,0.139016},
{0.223088,0.13923},
{0.217999,0.148651},
{0.227966,0.148106},
{0.222693,0.156769},
{0.21254,0.156556},
{0.207661,0.147679},
{0.279039,0.180112},
{0.264665,0.17907},
{0.279039,0.180112},
{0.293677,0.17749},
{0.293677,0.17749},
{0.298658,0.175212},
{0.298658,0.175212},
{0.30824,0.175906},
{0.30824,0.175906},
{0.264665,0.17907},
{0.255346,0.174712},
{0.255346,0.174712},
{0.251084,0.167038},
{0.251084,0.167038},
{0.252381,0.160175},
{0.252381,0.160175},
{0.257874,0.156482},
{0.257874,0.156482},
{0.266912,0.154299},
{0.266912,0.154299},
{0.273753,0.154007},
{0.273753,0.154007},
{0.282833,0.153973},
{0.282833,0.153973},
{0.297035,0.150944},
{0.297035,0.150944},
{0.307954,0.142906},
{0.307954,0.142906},
{0.31159,0.131028},
{0.31159,0.131028},
{0.307592,0.11969},
{0.307592,0.11969},
{0.298539,0.111668},
{0.298539,0.111668},
{0.285914,0.107537},
{0.285914,0.107537},
{0.268503,0.106275},
{0.268503,0.106275},
{0.250625,0.108195},
{0.250625,0.108195},
{0.279797,0.190749},
{0.262386,0.189487},
{0.279797,0.190749},
{0.297675,0.188828},
{0.297675,0.188828},
{0.262386,0.189487},
{0.249762,0.185356},
{0.249762,0.185356},
{0.240708,0.177334},
{0.240708,0.177334},
{0.23671,0.165996},
{0.23671,0.165996},
{0.240346,0.154118},
{0.240346,0.154118},
{0.251265,0.14608},
{0.251265,0.14608},
{0.265467,0.143051},
{0.265467,0.143051},
{0.274625,0.142232},
{0.274469,0.143801},
{0.281389,0.142724},
{0.281389,0.142724},
{0.290427,0.140542},
{0.290427,0.140542},
{0.29592,0.136849},
{0.29592,0.136849},
{0.297216,0.129986},
{0.297216,0.129986},
{0.292954,0.122312},
{0.292954,0.122312},
{0.283636,0.117953},
{0.283636,0.117953},
{0.269262,0.116912},
{0.269262,0.116912},
{0.254623,0.119533},
{0.254623,0.119533},
{0.249642,0.121812},
{0.249642,0.121812},
{0.24006,0.121118},
{0.24006,0.121118},
{0.29663,0.203485},
{0.29663,0.203485},
{0.306212,0.204179},
{0.306212,0.204179},
{0.251696,0.093543},
{0.251696,0.093543},
{0.242114,0.092849},
{0.242114,0.092849},
{0.268503,0.106275},
{0.285914,0.107537},
{0.283636,0.117953},
{0.298539,0.111668},
{0.292954,0.122312},
{0.307592,0.11969},
{0.31159,0.131028},
{0.297216,0.129986},
{0.307954,0.142906},
{0.29592,0.136849},
{0.297035,0.150944},
{0.290427,0.140542},
{0.282833,0.153973},
{0.281389,0.142724},
{0.273753,0.154007},
{0.274469,0.143801},
{0.266912,0.154299},
{0.265467,0.143051},
{0.257874,0.156482},
{0.251265,0.14608},
{0.252381,0.160175},
{0.240346,0.154118},
{0.251084,0.167038},
{0.23671,0.165996},
{0.255346,0.174712},
{0.240708,0.177334},
{0.249762,0.185356},
{0.264665,0.17907},
{0.262386,0.189487},
{0.279797,0.190749},
{0.279039,0.180112},
{0.293677,0.17749},
{0.297675,0.188828},
{0.298658,0.175212},
{0.30824,0.175906},
{0.307257,0.189523},
{0.3062,0.204177},
{0.296617,0.203483},
{0.269262,0.116912},
{0.254623,0.119533},
{0.250625,0.108195},
{0.249642,0.121812},
{0.24006,0.121118},
{0.241043,0.107501},
{0.242101,0.092847},
{0.251683,0.093541},
{0.241056,0.107503},
{0.240073,0.12112},
{0.241056,0.107503},
{0.242114,0.092849},
{0.242114,0.092849},
{0.240073,0.12112},
{0.30727,0.189525},
{0.306212,0.204179},
{0.30727,0.189525},
{0.308253,0.175908},
{0.308253,0.175908},
{0.306212,0.204179},
{0.250638,0.108198},
{0.250638,0.108198},
{0.251696,0.093543},
{0.251696,0.093543},
{0.297688,0.18883},
{0.297688,0.18883},
{0.29663,0.203485},
{0.29663,0.203485},
{0.483899,0.213119},
{0.49912,0.19043},
{0.483899,0.213119},
{0.46112,0.228279},
{0.46112,0.228279},
{0.43425,0.233603},
{0.43425,0.233603},
{0.407379,0.22828},
{0.407379,0.22828},
{0.3846,0.213119},
{0.3846,0.213119},
{0.369378,0.19043},
{0.369378,0.19043},
{0.364034,0.163666},
{0.364034,0.163666},
{0.369378,0.136902},
{0.369378,0.136902},
{0.384599,0.114213},
{0.384599,0.114213},
{0.407379,0.099052},
{0.407379,0.099052},
{0.434249,0.093729},
{0.434249,0.093729},
{0.46112,0.099052},
{0.46112,0.099052},
{0.483899,0.114213},
{0.483899,0.114213},
{0.49912,0.136902},
{0.49912,0.136902},
{0.504465,0.163666},
{0.504465,0.163666},
{0.49912,0.19043},
{0.475624,0.204818},
{0.488308,0.18591},
{0.483899,0.213119},
{0.46112,0.228279},
{0.456642,0.217451},
{0.43425,0.233603},
{0.43425,0.221888},
{0.407379,0.22828},
{0.411858,0.217451},
{0.3846,0.213119},
{0.392875,0.204818},
{0.369378,0.19043},
{0.38019,0.18591},
{0.364034,0.163666},
{0.375736,0.163607},
{0.369378,0.136902},
{0.38019,0.141304},
{0.384599,0.114213},
{0.392874,0.122396},
{0.407379,0.099052},
{0.411857,0.109762},
{0.434249,0.093729},
{0.434249,0.105326},
{0.46112,0.099052},
{0.456641,0.109762},
{0.483899,0.114213},
{0.475624,0.122396},
{0.49912,0.136902},
{0.488308,0.141303},
{0.504465,0.163666},
{0.492762,0.163607},
{0.49912,0.19043},
{0.434249,0.162368},
{0.481888,0.183564},
{0.470628,0.200349},
{0.453777,0.211563},
{0.456642,0.217451},
{0.475624,0.204818},
{0.488308,0.18591},
{0.485841,0.163766},
{0.481888,0.143968},
{0.470628,0.127183},
{0.453777,0.115969},
{0.4339,0.11203},
{0.414023,0.115969},
{0.397172,0.127184},
{0.385912,0.143968},
{0.381958,0.163766},
{0.385912,0.183564},
{0.397172,0.200349},
{0.414023,0.211564},
{0.4339,0.215502},
{0.43425,0.221888},
{0.411858,0.217451},
{0.392875,0.204818},
{0.38019,0.18591},
{0.375736,0.163607},
{0.38019,0.141304},
{0.392874,0.122396},
{0.411857,0.109762},
{0.434249,0.105326},
{0.456641,0.109762},
{0.475624,0.122396},
{0.488308,0.141303},
{0.492762,0.163607},
{0.236144,0.378034},
{0.262132,0.394974},
{0.252747,0.35156},
{0.223036,0.334029},
{0.234533,0.306632},
{0.265552,0.322866},
{0.281112,0.366972},
{0.298995,0.41966},
{0.320586,0.389711},
{0.331701,0.447519},
{0.3565,0.420118},
{0.336145,0.358688},
{0.375591,0.38633},
{0.262132,0.394974},
{0.236144,0.378034},
{0.252747,0.35156},
{0.223036,0.334029},
{0.20696,0.36024},
{0.188814,0.315235},
{0.175124,0.341747},
{0.154814,0.298702},
{0.144159,0.327297},
{0.112239,0.276857},
{0.101701,0.307341},
{0.072838,0.262688},
{0.063619,0.294356},
{0.027116,0.244752},
{0.021396,0.280989},
{0.281112,0.366972},
{0.265552,0.322866},
{0.234533,0.306632},
{0.199831,0.288855},
{0.167223,0.271633},
{0.126354,0.248207},
{0.083999,0.229338},
{0.040574,0.211098},
{0.298995,0.41966},
{0.320586,0.389711},
{0.29482,0.336572},
{0.101701,0.307341},
{0.144159,0.327297},
{0.112239,0.276857},
{0.072838,0.262688},
{0.083999,0.229338},
{0.126354,0.248207},
{0.154814,0.298702},
{0.175124,0.341747},
{0.188814,0.315235},
{0.20696,0.36024},
{0.063619,0.294356},
{0.027116,0.244752},
{0.040574,0.211098},
{0.021396,0.280989},
{0.331701,0.447519},
{0.3565,0.420118},
{0.336145,0.358688},
{0.29482,0.336572},
{0.167223,0.271633},
{0.199831,0.288855},
{0.375591,0.38633},
{0.165784,0.377818},
{0.165784,0.377818},
{0.144672,0.377753},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.144672,0.377753},
{0.144672,0.377753},
{0.165784,0.377818},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.144672,0.377753},
{0.165784,0.377818},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.165784,0.377818},
{0.165784,0.377818},
{0.144672,0.377753},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.144672,0.377753},
{0.144672,0.377753},
{0.165784,0.377818},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.165784,0.377818},
{0.165784,0.377818},
{0.144672,0.377753},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.144672,0.377753},
{0.144672,0.377753},
{0.165784,0.377818},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.165784,0.377818},
{0.165784,0.377818},
{0.144672,0.377753},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.144672,0.377753},
{0.144672,0.377753},
{0.165784,0.377818},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.165784,0.377818},
{0.165784,0.377818},
{0.144672,0.377753},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.144672,0.377753},
{0.144672,0.377753},
{0.165784,0.377818},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.165784,0.377818},
{0.165784,0.377818},
{0.144672,0.377753},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.144672,0.377753},
{0.144672,0.377753},
{0.165784,0.377818},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.165784,0.377818},
{0.165784,0.377818},
{0.144672,0.377753},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.144672,0.377753},
{0.144672,0.377753},
{0.165784,0.377818},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.165784,0.377818},
{0.165784,0.377818},
{0.144672,0.377753},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.144672,0.377753},
{0.144672,0.377753},
{0.165784,0.377818},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.165784,0.377818},
{0.165784,0.377818},
{0.144672,0.377753},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.165784,0.377818},
{0.144672,0.377753},
{0.094142,0.34288},
{0.103006,0.346561},
{0.094341,0.351526},
{0.088389,0.361664},
{0.102819,0.355811},
{0.111091,0.351411},
{0.110928,0.342592},
{0.102944,0.337603},
{0.088424,0.332167},
{0.094341,0.351526},
{0.094142,0.34288},
{0.103006,0.346561},
{0.102819,0.355811},
{0.111091,0.351411},
{0.110928,0.342592},
{0.102944,0.337603},
{0.088424,0.332167},
{0.088389,0.361664},
{0.117516,0.361532},
{0.117739,0.33253},
{0.117516,0.361532},
{0.117739,0.33253},
{0.198421,0.427242},
{0.193316,0.421876},
{0.21883,0.403852},
{0.212623,0.435065},
{0.2309,0.445882},
{0.250089,0.413869},
{0.273657,0.436715},
{0.249054,0.456903},
{0.262648,0.465741},
{0.269787,0.467713},
{0.279361,0.449182},
{0.205147,0.404698},
{0.16411,0.426386},
{0.174327,0.4155},
{0.18315,0.441015},
{0.198217,0.452559},
{0.21884,0.466001},
{0.240416,0.477854},
{0.2577,0.4857},
{0.279577,0.495598},
{0.284361,0.481456},
{0.077665,0.612716},
{0.071041,0.617827},
{0.036212,0.604117},
{0.06605,0.583407},
{0.06024,0.565452},
{0.028797,0.581167},
{0.06647,0.549029},
{0.026386,0.554765},
{0.060065,0.527963},
{0.071497,0.527668},
{0.077125,0.541366},
{0.096616,0.536436},
{0.10089,0.52204},
{0.119315,0.538775},
{0.11466,0.523654},
{0.100518,0.504854},
{0.126473,0.520371},
{0.126512,0.498085},
{0.1525,0.504878},
{0.138407,0.523533},
{0.152112,0.522064},
{0.133621,0.539092},
{0.156371,0.536464},
{0.181499,0.52772},
{0.175857,0.541413},
{0.186505,0.549084},
{0.192929,0.528026},
{0.226582,0.554858},
{0.224147,0.581256},
{0.19272,0.565514},
{0.216712,0.604199},
{0.186894,0.583463},
{0.175253,0.61276},
{0.181872,0.617878},
{0.203968,0.614806},
{0.048946,0.614736},
{0.090869,0.648763},
{0.077267,0.64203},
{0.100312,0.613848},
{0.098778,0.581915},
{0.080424,0.578434},
{0.076115,0.565539},
{0.079337,0.553074},
{0.096305,0.546601},
{0.118182,0.552975},
{0.126484,0.546937},
{0.126486,0.553106},
{0.134791,0.552983},
{0.156673,0.546629},
{0.173635,0.553117},
{0.176845,0.565585},
{0.172525,0.578477},
{0.154168,0.58194},
{0.152605,0.613872},
{0.162016,0.648796},
{0.175624,0.642074},
{0.082327,0.574113},
{0.09657,0.57616},
{0.117487,0.567739},
{0.126477,0.572584},
{0.12648,0.566727},
{0.135471,0.567747},
{0.15638,0.576188},
{0.170626,0.574154},
{0.126459,0.611785},
{0.064913,0.347552},
{0.055795,0.356752},
{0.045273,0.339234},
{0.036523,0.355635},
{0.02848,0.3393},
{0.035186,0.322856},
{0.062453,0.323182},
{0.067645,0.339309},
{0.055795,0.356752},
{0.064913,0.347552},
{0.045273,0.339234},
{0.036523,0.355635},
{0.02848,0.3393},
{0.035186,0.322856},
{0.062453,0.323182},
{0.067525,0.339293},
{0.172909,0.453993},
{0.149545,0.442899},
{0.133368,0.460548},
{0.151716,0.469781},
{0.187023,0.465547},
{0.209848,0.481003},
{0.234238,0.493848},
{0.25108,0.50085},
{0.271877,0.516227},
{0.16495,0.484248},
{0.193649,0.508027},
{0.228149,0.52213},
{0.247146,0.526983},
{0.263937,0.538813},
{0.06466,0.504335},
{0.041599,0.499892},
{0.064746,0.495655},
{0.089181,0.499856},
{0.085004,0.49129},
{0.095824,0.485203},
{0.091157,0.477788},
{0.045235,0.491045},
{0.034143,0.486025},
{0.038796,0.47802},
{0.035186,0.322856},
{0.062453,0.323182},
{0.045273,0.339234},
{0.064913,0.347552},
{0.055795,0.356752},
{0.036523,0.355635},
{0.02848,0.3393},
{0.027191,0.422347},
{0.029444,0.39632},
{0.064975,0.416897},
{0.065079,0.478846},
{0.10277,0.422274},
{0.100467,0.396252},
{0.064948,0.388293},
{0.013327,0.425171},
{0.012476,0.405127},
{0.016971,0.464449},
{0.038796,0.47802},
{0.117452,0.405026},
{0.116639,0.425072},
{0.113071,0.464356},
{0.091157,0.477788},
{0.095824,0.485203},
{0.111608,0.474656},
{0.034143,0.486025},
{0.018454,0.474745},
{0.064842,0.495782},
{0.045104,0.490921},
{0.065079,0.478846},
{0.085078,0.491098},
{0.126438,0.657428},
{0.159799,0.377753},
{0.159799,0.377753},
{0.165784,0.377818},
{0.165784,0.377818},
{0.159799,0.377753},
{0.165784,0.377818},
{0.159799,0.377753},
{0.165784,0.377818},
{0.159799,0.377753},
{0.165784,0.377818},
{0.159799,0.377753},
{0.165784,0.377818},
{0.165784,0.377818},
{0.165784,0.377818},
{0.159799,0.377753},
{0.159799,0.377753},
{0.165784,0.377818},
{0.159799,0.377753},
{0.165784,0.377818},
{0.159799,0.377753},
{0.165784,0.377818},
{0.159799,0.377753},
{0.165784,0.377818},
{0.159799,0.377753},
{0.882276,0.145533},
{0.86362,0.081798},
{0.81184,0.097568},
{0.832106,0.160799},
{0.779578,0.179082},
{0.755751,0.118386},
{0.724249,0.204293},
{0.699759,0.145183},
{0.673431,0.234178},
{0.649041,0.175329},
{0.624987,0.263602},
{0.595438,0.20595},
{0.573323,0.291301},
{0.54557,0.230223},
{0.521517,0.310686},
{0.50088,0.250521},
{0.462552,0.324214},
{0.446987,0.262521},
{0.403086,0.325961},
{0.396082,0.261374},
{0.33821,0.314243},
{0.353623,0.251546},
{0.274871,0.295757},
{0.293422,0.235034},
{0.216836,0.270078},
{0.244682,0.21355},
{0.159323,0.239475},
{0.187456,0.183373},
{0.102128,0.200843},
{0.13543,0.151498},
{0.050876,0.163922},
{0.086923,0.118648},
{0.019138,0.145676},
{0.041986,0.092891},
{0.016085,0.08192},
{0.81184,0.097568},
{0.86362,0.081798},
{0.882276,0.145533},
{0.832106,0.160799},
{0.779578,0.179082},
{0.755751,0.118386},
{0.724249,0.204293},
{0.699759,0.145183},
{0.673431,0.234178},
{0.649041,0.175329},
{0.624987,0.263602},
{0.595438,0.20595},
{0.573323,0.291301},
{0.54557,0.230223},
{0.521517,0.310686},
{0.50088,0.250521},
{0.462552,0.324214},
{0.446987,0.262521},
{0.403086,0.325961},
{0.396082,0.261374},
{0.33821,0.314243},
{0.353623,0.251546},
{0.274871,0.295757},
{0.293422,0.235034},
{0.216836,0.270078},
{0.244682,0.21355},
{0.159323,0.239475},
{0.187456,0.183373},
{0.102128,0.200843},
{0.13543,0.151498},
{0.050876,0.163922},
{0.086923,0.118648},
{0.019138,0.145676},
{0.041986,0.092891},
{0.016085,0.08192},
{0.016085,0.08192},
{0.041986,0.092891},
{0.019138,0.145676},
{0.050876,0.163922},
{0.086923,0.118648},
{0.102128,0.200843},
{0.13543,0.151498},
{0.159323,0.239475},
{0.187456,0.183373},
{0.216836,0.270078},
{0.244682,0.21355},
{0.274871,0.295757},
{0.293422,0.235034},
{0.33821,0.314243},
{0.353623,0.251546},
{0.403086,0.325961},
{0.396082,0.261374},
{0.462552,0.324214},
{0.446987,0.262521},
{0.521517,0.310686},
{0.50088,0.250521},
{0.573323,0.291301},
{0.54557,0.230223},
{0.624987,0.263602},
{0.595438,0.20595},
{0.673431,0.234178},
{0.649041,0.175329},
{0.724249,0.204293},
{0.699759,0.145183},
{0.779578,0.179082},
{0.755751,0.118386},
{0.832106,0.160799},
{0.81184,0.097568},
{0.86362,0.081798},
{0.882276,0.145533},
{0.041986,0.092891},
{0.016085,0.08192},
{0.019138,0.145676},
{0.050876,0.163922},
{0.086923,0.118648},
{0.102128,0.200843},
{0.13543,0.151498},
{0.159323,0.239475},
{0.187456,0.183373},
{0.216836,0.270078},
{0.244682,0.21355},
{0.274871,0.295757},
{0.293422,0.235034},
{0.33821,0.314243},
{0.353623,0.251546},
{0.403086,0.325961},
{0.396082,0.261374},
{0.462552,0.324214},
{0.446987,0.262521},
{0.521517,0.310686},
{0.50088,0.250521},
{0.573323,0.291301},
{0.54557,0.230223},
{0.624987,0.263602},
{0.595438,0.20595},
{0.673431,0.234178},
{0.649041,0.175329},
{0.724249,0.204293},
{0.699759,0.145183},
{0.779578,0.179082},
{0.755751,0.118386},
{0.832106,0.160799},
{0.81184,0.097568},
{0.86362,0.081798},
{0.882276,0.145533},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.555419,0.159857},
{0.39243,0.950189},
{0.347196,0.981377},
{0.346806,0.950056},
{0.346411,0.917159},
{0.299752,0.948306},
{0.29912,0.989758},
{0.242117,0.946435},
{0.242406,0.96294},
{0.301098,0.904493},
{0.241358,0.930588},
{0.347196,0.981377},
{0.29912,0.989758},
{0.346806,0.950056},
{0.39243,0.950189},
{0.346411,0.917159},
{0.301098,0.904493},
{0.299752,0.948306},
{0.242117,0.946435},
{0.242406,0.96294},
{0.241358,0.930588},
{0.037812,0.670048},
{0.037812,0.670048},
{0.037812,0.670048},
{0.037812,0.670048},
{0.037812,0.670048},
{0.037812,0.670048},
{0.037812,0.670048},
{0.037812,0.670048},
{0.037812,0.670048},
{0.037812,0.670048},
{0.037812,0.670048},
{0.037812,0.670048},
{0.037812,0.670048},
{0.037812,0.670048},
{0.037812,0.670048},
{0.037812,0.670048},
{0.037812,0.670048},
{0.037812,0.670048},
{0.037812,0.670048},
{0.05085,0.960507},
{0.041571,0.95052},
{0.052698,0.945033},
{0.073786,0.952556},
{0.052701,0.922796},
{0.038468,0.93932},
{0.027962,0.951505},
{0.035737,0.963916},
{0.050354,0.986332},
{0.041571,0.95052},
{0.016684,0.931619},
{0.010878,0.970757},
{0.299752,0.948306},
{0.242117,0.946435},
{0.29912,0.989758},
{0.347196,0.981377},
{0.346806,0.950056},
{0.39243,0.950189},
{0.346411,0.917159},
{0.301098,0.904493},
{0.241358,0.930588},
{0.242406,0.96294},
{0.299752,0.948306},
{0.242117,0.946435},
{0.29912,0.989758},
{0.346806,0.950056},
{0.347196,0.981377},
{0.39243,0.950189},
{0.346411,0.917159},
{0.301098,0.904493},
{0.241358,0.930588},
{0.242406,0.96294},
{0.163939,0.92881},
{0.118712,0.927589},
{0.126421,0.881669},
{0.098621,0.874115},
{0.069957,0.90921},
{0.074953,0.851467},
{0.038221,0.879977},
{0.063053,0.827237},
{0.016839,0.845687},
{0.058261,0.801064},
{0.007633,0.800381},
{0.018057,0.75534},
{0.063758,0.775029},
{0.040357,0.721638},
{0.076307,0.751129},
{0.072871,0.69327},
{0.100578,0.729127},
{0.122105,0.676212},
{0.128572,0.722325},
{0.16735,0.676212},
{0.161433,0.715618},
{0.201623,0.726963},
{0.221902,0.694115},
{0.243222,0.736777},
{0.251032,0.720343},
{0.278766,0.758428},
{0.266431,0.767669},
{0.290453,0.804197},
{0.269985,0.803921},
{0.265453,0.840064},
{0.277533,0.849635},
{0.241418,0.870316},
{0.248781,0.886956},
{0.218953,0.912387},
{0.199569,0.879004},
{0.159087,0.88926},
{0.159394,0.855827},
{0.141232,0.853902},
{0.115914,0.835211},
{0.102555,0.801662},
{0.116816,0.768484},
{0.14263,0.750482},
{0.160838,0.749047},
{0.190037,0.751024},
{0.213151,0.763324},
{0.228698,0.74968},
{0.252473,0.775858},
{0.236606,0.781449},
{0.230883,0.803393},
{0.236011,0.825483},
{0.251721,0.8315},
{0.227247,0.857027},
{0.212075,0.842968},
{0.188637,0.854639},
{0.182176,0.832047},
{0.16251,0.828532},
{0.149391,0.816554},
{0.147252,0.80245},
{0.149782,0.788035},
{0.163217,0.776416},
{0.182969,0.773432},
{0.199856,0.778504},
{0.178952,0.80269},
{0.201282,0.802992},
{0.21778,0.79108},
{0.217451,0.815346},
{0.199194,0.827433},
{0.017131,0.025215},
{0.065993,0.024213},
{0.065341,0.071307},
{0.116037,0.0711},
{0.116562,0.024509},
{0.162691,0.07096},
{0.163604,0.024084},
{0.212177,0.071533},
{0.212647,0.02326},
{0.263838,0.071856},
{0.263162,0.023007},
{0.312899,0.071204},
{0.312213,0.022738},
{0.361412,0.071102},
{0.361196,0.022689},
{0.410183,0.071152},
{0.410453,0.022366},
{0.460151,0.071315},
{0.459693,0.022566},
{0.510764,0.021907},
{0.511035,0.070695},
{0.55911,0.022685},
{0.558895,0.070646},
{0.609013,0.023189},
{0.60833,0.071206},
{0.658071,0.022539},
{0.658316,0.071856},
{0.707223,0.023244},
{0.707701,0.072902},
{0.756278,0.023604},
{0.754913,0.073695},
{0.806077,0.023564},
{0.806613,0.073369},
{0.855283,0.023716},
{0.855033,0.073567},
{0.902324,0.023793},
{0.903911,0.072791},
{0.016015,0.071913},
{0.063514,0.011161},
{0.112847,0.011161},
{0.063514,0.011161},
{0.01445,0.011161},
{0.01445,0.011161},
{0.112847,0.011161},
{0.162732,0.011161},
{0.162732,0.011161},
{0.211514,0.011161},
{0.211514,0.011161},
{0.261558,0.011161},
{0.261558,0.011161},
{0.310083,0.011161},
{0.310083,0.011161},
{0.360528,0.011161},
{0.360528,0.011161},
{0.409106,0.011161},
{0.409106,0.011161},
{0.455979,0.011161},
{0.455979,0.011161},
{0.508263,0.011161},
{0.508263,0.011161},
{0.556841,0.011161},
{0.556841,0.011161},
{0.605855,0.011161},
{0.605855,0.011161},
{0.655811,0.011161},
{0.655811,0.011161},
{0.704423,0.011161},
{0.704423,0.011161},
{0.754402,0.011161},
{0.754402,0.011161},
{0.804897,0.011161},
{0.804897,0.011161},
{0.853185,0.011161},
{0.853185,0.011161},
{0.903235,0.011161},
{0.903235,0.011161},
{0.350757,0.012684},
{0.350757,0.012684},
{0.350757,0.012684},
{0.350757,0.012684},
{0.350757,0.012684},
{0.350757,0.012684},
{0.350757,0.012684},
{0.350757,0.012684},
{0.350757,0.012684},
{0.350757,0.012684},
{0.350757,0.012684},
{0.350757,0.012684},
{0.350757,0.012684},
{0.350757,0.012684},
{0.350757,0.012684},
{0.350757,0.012684},
{0.350757,0.012684},
{0.350757,0.012684},
{0.350757,0.012684},
{0.350757,0.012684},
{0.350757,0.012684},
{0.350757,0.012684},
{0.350757,0.012684},
{0.350757,0.012684},
{0.350757,0.012684},
{0.350757,0.012684},
{0.350757,0.012684},
{0.350757,0.012684},
{0.350757,0.012684},
{0.350757,0.012684},
{0.350757,0.012684},
{0.350757,0.012684},
{0.350757,0.012684},
{0.350757,0.012684},
{0.350757,0.012684},
{0.350757,0.012684},
{0.65274,0.759674},
{0.675902,0.782078},
{0.650156,0.811615},
{0.621643,0.786817},
{0.626349,0.834345},
{0.595802,0.807508},
{0.593712,0.864627},
{0.563488,0.833729},
{0.560956,0.895154},
{0.532878,0.862499},
{0.500975,0.893085},
{0.525737,0.926252},
{0.463107,0.921307},
{0.484303,0.956549},
{0.423039,0.944022},
{0.440021,0.973877},
{0.647669,0.516562},
{0.673913,0.545662},
{0.65113,0.568455},
{0.619555,0.541835},
{0.633037,0.59177},
{0.597648,0.570426},
{0.621196,0.622908},
{0.582483,0.605151},
{0.617327,0.64629},
{0.571454,0.637504},
{0.569267,0.664741},
{0.616017,0.66437},
{0.61763,0.682425},
{0.571908,0.691928},
{0.583482,0.724118},
{0.621893,0.705737},
{0.599252,0.758575},
{0.634257,0.736669},
{0.989397,0.402147},
{0.97853,0.435702},
{0.935781,0.423789},
{0.971628,0.465146},
{0.928558,0.459326},
{0.970992,0.493702},
{0.926558,0.490449},
{0.971918,0.520377},
{0.925785,0.520774},
{0.927074,0.551091},
{0.971444,0.547063},
{0.929616,0.582167},
{0.972563,0.575604},
{0.937443,0.617574},
{0.979962,0.604928},
{0.991396,0.638295},
{0.954822,0.655204},
{0.901517,0.633358},
{0.925292,0.670937},
{0.861543,0.658283},
{0.887878,0.695952},
{0.828373,0.688544},
{0.852649,0.724576},
{0.817032,0.757107},
{0.795507,0.72079},
{0.774423,0.788082},
{0.757881,0.752039},
{0.732185,0.807939},
{0.720288,0.780341},
{0.734661,0.719404},
{0.701678,0.75195},
{0.710097,0.693655},
{0.680551,0.728272},
{0.680602,0.670935},
{0.656515,0.71101},
{0.647358,0.658654},
{0.628853,0.700983},
{0.952544,0.38586},
{0.899599,0.408609},
{0.876969,0.45205},
{0.874741,0.489133},
{0.876487,0.521213},
{0.875302,0.553307},
{0.878148,0.590335},
{0.57178,0.775361},
{0.550495,0.73894},
{0.536929,0.799055},
{0.569883,0.554106},
{0.593392,0.521572},
{0.560645,0.4959},
{0.534647,0.53101},
{0.549251,0.590874},
{0.530962,0.631128},
{0.525449,0.665111},
{0.531517,0.699},
{0.62348,0.494236},
{0.590334,0.464508},
{0.557064,0.434538},
{0.529533,0.467636},
{0.503213,0.502931},
{0.505494,0.567656},
{0.523292,0.605279},
{0.491704,0.633923},
{0.491548,0.665384},
{0.492232,0.696857},
{0.524285,0.724974},
{0.507181,0.7629},
{0.505953,0.827665},
{0.922753,0.370627},
{0.859199,0.384374},
{0.83623,0.424309},
{0.826919,0.487165},
{0.829303,0.521625},
{0.827511,0.556136},
{0.8379,0.618795},
{0.799957,0.65118},
{0.769238,0.684893},
{0.741238,0.655199},
{0.708328,0.631839},
{0.672774,0.615244},
{0.884921,0.346248},
{0.825516,0.354695},
{0.797742,0.392583},
{0.804129,0.458249},
{0.759478,0.491314},
{0.77104,0.506713},
{0.772094,0.522131},
{0.771312,0.537567},
{0.760005,0.553149},
{0.805205,0.585441},
{0.771378,0.61947},
{0.732716,0.593437},
{0.69506,0.57656},
{0.443419,0.687244},
{0.414808,0.729717},
{0.404346,0.672791},
{0.443842,0.665807},
{0.405884,0.666146},
{0.404232,0.659527},
{0.44303,0.644378},
{0.413716,0.602422},
{0.374553,0.623423},
{0.347144,0.588468},
{0.383624,0.566273},
{0.317684,0.548639},
{0.353156,0.528373},
{0.301991,0.505571},
{0.327252,0.486548},
{0.38424,0.502473},
{0.351258,0.466559},
{0.409604,0.475055},
{0.375624,0.441933},
{0.436519,0.443639},
{0.399795,0.414531},
{0.458781,0.410044},
{0.418333,0.388009},
{0.479379,0.374447},
{0.434808,0.357871},
{0.375283,0.709392},
{0.34847,0.744804},
{0.385315,0.766374},
{0.448343,0.75916},
{0.475888,0.726265},
{0.474844,0.604813},
{0.446744,0.5724},
{0.416044,0.538017},
{0.442874,0.507769},
{0.471474,0.473115},
{0.49711,0.437617},
{0.521321,0.40404},
{0.476473,0.792138},
{0.44555,0.823866},
{0.474725,0.858036},
{0.440276,0.888093},
{0.404055,0.917819},
{0.474305,0.538946},
{0.41822,0.794058},
{0.387024,0.830139},
{0.412844,0.857133},
{0.379424,0.890831},
{0.849213,0.318223},
{0.813051,0.286298},
{0.792117,0.323014},
{0.766467,0.359368},
{0.769732,0.424802},
{0.731511,0.451441},
{0.70555,0.514201},
{0.704556,0.522639},
{0.705693,0.531058},
{0.694148,0.468885},
{0.706483,0.413448},
{0.671211,0.430584},
{0.678091,0.374785},
{0.645065,0.38761},
{0.653335,0.335107},
{0.625846,0.3456},
{0.330306,0.847041},
{0.304728,0.828449},
{0.355502,0.804779},
{0.31969,0.785123},
{0.354646,0.866621},
{0.715925,0.264705},
{0.727353,0.236909},
{0.753997,0.29242},
{0.731329,0.325445},
{0.769922,0.256048},
{0.697798,0.293408},
{0.707215,0.351612},
{0.738984,0.389568},
{0.677074,0.317439},
{0.716333,0.902061},
{0.710863,0.909296},
{0.718101,0.929186},
{0.695796,0.931038},
{0.702362,0.912816},
{0.677421,0.921261},
{0.692743,0.909264},
{0.667037,0.90089},
{0.687329,0.898525},
{0.671516,0.87853},
{0.690285,0.890495},
{0.685807,0.864779},
{0.697641,0.885144},
{0.706154,0.857935},
{0.705357,0.884168},
{0.723264,0.861089},
{0.712462,0.885946},
{0.737951,0.873174},
{0.71705,0.889535},
{0.74456,0.892102},
{0.718554,0.895069},
{0.735983,0.914098},
{0.719707,0.956128},
{0.682826,0.949593},
{0.662236,0.93486},
{0.646138,0.911034},
{0.640794,0.871914},
{0.675476,0.843504},
{0.704313,0.836816},
{0.73138,0.844664},
{0.751264,0.861406},
{0.758884,0.892695},
{0.750004,0.92665},
{0.762164,0.934791},
{0.726881,0.968717},
{0.683799,0.971737},
{0.651303,0.97514},
{0.630845,0.961388},
{0.61518,0.938944},
{0.619905,0.90821},
{0.603976,0.90438},
{0.627078,0.861487},
{0.666552,0.82767},
{0.702543,0.818628},
{0.739241,0.827934},
{0.764782,0.850521},
{0.775958,0.892545},
{0.710863,0.909296},
{0.716333,0.902061},
{0.718101,0.929186},
{0.695796,0.931038},
{0.682826,0.949593},
{0.719707,0.956128},
{0.735983,0.914098},
{0.718554,0.895069},
{0.74456,0.892102},
{0.71705,0.889535},
{0.737951,0.873174},
{0.712462,0.885946},
{0.723264,0.861089},
{0.705357,0.884168},
{0.706154,0.857935},
{0.697641,0.885144},
{0.685807,0.864779},
{0.690285,0.890495},
{0.671516,0.87853},
{0.687329,0.898525},
{0.667037,0.90089},
{0.692743,0.909264},
{0.677421,0.921261},
{0.702362,0.912816},
{0.683799,0.971737},
{0.651303,0.97514},
{0.662236,0.93486},
{0.630845,0.961388},
{0.647639,0.988548},
{0.686222,0.985835},
{0.726881,0.968717},
{0.61518,0.938944},
{0.619905,0.90821},
{0.646138,0.911034},
{0.640794,0.871914},
{0.603976,0.90438},
{0.599092,0.939681},
{0.616282,0.974953},
{0.751264,0.861406},
{0.758884,0.892695},
{0.764782,0.850521},
{0.739241,0.827934},
{0.73138,0.844664},
{0.704313,0.836816},
{0.675476,0.843504},
{0.627078,0.861487},
{0.750004,0.92665},
{0.775958,0.892545},
{0.762164,0.934791},
{0.925271,0.161557},
{0.876496,0.168386},
{0.916303,0.202719},
{0.93433,0.210373},
{0.961069,0.181692},
{0.942805,0.229374},
{0.984945,0.21601},
{0.941832,0.248232},
{0.99008,0.253868},
{0.932262,0.266379},
{0.970904,0.29839},
{0.916898,0.276069},
{0.936241,0.323785},
{0.900694,0.276736},
{0.88667,0.324876},
{0.887483,0.264874},
{0.848636,0.291368},
{0.879021,0.245128},
{0.834037,0.243738},
{0.880904,0.224197},
{0.845061,0.201429},
{0.895064,0.207376},
{0.876496,0.168386},
{0.925271,0.161557},
{0.916303,0.202719},
{0.93433,0.210373},
{0.961069,0.181692},
{0.942805,0.229374},
{0.984945,0.21601},
{0.941832,0.248232},
{0.99008,0.253868},
{0.932262,0.266379},
{0.970904,0.29839},
{0.916898,0.276069},
{0.936241,0.323785},
{0.900694,0.276736},
{0.88667,0.324876},
{0.887483,0.264874},
{0.848636,0.291368},
{0.879021,0.245128},
{0.834037,0.243738},
{0.880904,0.224197},
{0.845061,0.201429},
{0.895064,0.207376},
{0.889496,0.255921},
{0.885022,0.23956},
{0.891845,0.23938},
{0.892985,0.228475},
{0.887763,0.224885},
{0.899935,0.219114},
{0.896336,0.211971},
{0.91331,0.216101},
{0.914132,0.208158},
{0.923659,0.220815},
{0.929216,0.215377},
{0.929036,0.232138},
{0.937281,0.230068},
{0.927498,0.24364},
{0.93785,0.245042},
{0.921463,0.254003},
{0.929512,0.260485},
{0.912938,0.259341},
{0.916708,0.268226},
{0.90196,0.258892},
{0.900871,0.267596},
{0.895482,0.251515},
{0.885022,0.23956},
{0.889496,0.255921},
{0.891845,0.23938},
{0.892985,0.228475},
{0.887763,0.224885},
{0.899935,0.219114},
{0.896336,0.211971},
{0.91331,0.216101},
{0.914132,0.208158},
{0.923659,0.220815},
{0.929216,0.215377},
{0.929036,0.232138},
{0.937281,0.230068},
{0.927498,0.24364},
{0.93785,0.245042},
{0.921463,0.254003},
{0.929512,0.260485},
{0.912938,0.259341},
{0.916708,0.268226},
{0.90196,0.258892},
{0.900871,0.267596},
{0.895482,0.251515},
{0.781576,0.935703},
{0.790765,0.973127},
{0.824644,0.988445},
{0.83042,0.889673},
{0.875833,0.99239},
{0.872214,0.885304},
{0.92712,0.986027},
{0.91787,0.881772},
{0.95489,0.89033},
{0.958648,0.974501},
{0.980271,0.917689},
{0.978951,0.947013},
{0.790765,0.973127},
{0.781576,0.935703},
{0.824644,0.988445},
{0.83042,0.889673},
{0.791902,0.902075},
{0.791902,0.902075},
{0.872214,0.885304},
{0.875833,0.99239},
{0.92712,0.986027},
{0.91787,0.881772},
{0.95489,0.89033},
{0.958648,0.974501},
{0.980271,0.917689},
{0.978951,0.947013},
{0.702543,0.818628},
{0.666552,0.82767},
{0.686222,0.985835},
{0.647639,0.988548},
{0.616282,0.974953},
{0.599092,0.939681},
{0.819374,0.831571},
{0.832017,0.849656},
{0.801615,0.834325},
{0.806673,0.793648},
{0.822524,0.801594},
{0.832042,0.76164},
{0.843669,0.774831},
{0.870978,0.734136},
{0.879188,0.750395},
{0.912597,0.715332},
{0.916443,0.733263},
{0.953228,0.711617},
{0.949166,0.728215},
{0.982868,0.732594},
{0.968281,0.744395},
{0.993258,0.771313},
{0.97519,0.771842},
{0.980565,0.808164},
{0.964048,0.799117},
{0.944702,0.846416},
{0.932271,0.830933},
{0.895112,0.873211},
{0.889126,0.853049},
{0.856281,0.877704},
{0.859456,0.858228},
{0.819086,0.863851},
{0.832017,0.849656},
{0.819374,0.831571},
{0.801615,0.834325},
{0.806673,0.793648},
{0.822524,0.801594},
{0.832042,0.76164},
{0.843669,0.774831},
{0.870978,0.734136},
{0.879188,0.750395},
{0.912597,0.715332},
{0.916443,0.733263},
{0.953228,0.711617},
{0.949166,0.728215},
{0.982868,0.732594},
{0.968281,0.744395},
{0.993258,0.771313},
{0.97519,0.771842},
{0.980565,0.808164},
{0.964048,0.799117},
{0.944702,0.846416},
{0.932271,0.830933},
{0.895112,0.873211},
{0.889126,0.853049},
{0.856281,0.877704},
{0.859456,0.858228},
{0.819086,0.863851},
{0.833968,0.846868},
{0.823257,0.830707},
{0.819374,0.831571},
{0.822524,0.801594},
{0.825966,0.802862},
{0.843669,0.774831},
{0.846153,0.777451},
{0.879188,0.750395},
{0.880527,0.75368},
{0.916443,0.733263},
{0.917267,0.736751},
{0.949166,0.728215},
{0.94811,0.73159},
{0.968281,0.744395},
{0.965333,0.746926},
{0.97519,0.771842},
{0.97192,0.771668},
{0.964048,0.799117},
{0.961269,0.798095},
{0.932271,0.830933},
{0.930198,0.828636},
{0.889126,0.853049},
{0.888143,0.849707},
{0.859456,0.858228},
{0.860231,0.854492},
{0.832017,0.849656},
{0.823257,0.830707},
{0.833968,0.846868},
{0.819374,0.831571},
{0.822524,0.801594},
{0.825966,0.802862},
{0.843669,0.774831},
{0.846153,0.777451},
{0.879188,0.750395},
{0.880527,0.75368},
{0.916443,0.733263},
{0.917267,0.736751},
{0.949166,0.728215},
{0.94811,0.73159},
{0.968281,0.744395},
{0.965333,0.746926},
{0.97519,0.771842},
{0.97192,0.771668},
{0.964048,0.799117},
{0.961269,0.798095},
{0.932271,0.830933},
{0.930198,0.828636},
{0.889126,0.853049},
{0.888143,0.849707},
{0.859456,0.858228},
{0.860231,0.854492},
{0.832017,0.849656},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.616346,0.125739},
{0.595105,0.774118},
{0.595315,0.735187},
{0.646624,0.772089},
{0.645877,0.84203},
{0.594957,0.84267},
{0.646557,0.911988},
{0.595094,0.911196},
{0.648023,0.950507},
{0.595307,0.950069},
{0.648469,0.972245},
{0.595784,0.971747},
{0.648408,0.988117},
{0.596311,0.987043},
{0.536078,0.976907},
{0.537284,0.993176},
{0.648177,0.733593},
{0.595623,0.713466},
{0.53762,0.709347},
{0.536398,0.731676},
{0.537662,0.771248},
{0.538203,0.84312},
{0.537648,0.914986},
{0.536408,0.954559},
{0.648468,0.711859},
{0.595933,0.698144},
{0.538622,0.693044},
{0.594924,0.774044},
{0.595083,0.735113},
{0.537478,0.771248},
{0.538113,0.84312},
{0.594865,0.842595},
{0.537651,0.914986},
{0.595093,0.911121},
{0.536463,0.954561},
{0.595357,0.949994},
{0.536163,0.97691},
{0.595862,0.971671},
{0.537391,0.993177},
{0.596409,0.986966},
{0.648547,0.972099},
{0.648507,0.987971},
{0.536163,0.731678},
{0.595363,0.713392},
{0.648205,0.711716},
{0.647943,0.73345},
{0.64644,0.771948},
{0.645784,0.841889},
{0.646556,0.911845},
{0.648073,0.950362},
{0.537356,0.709348},
{0.595653,0.698069},
{0.647871,0.695839},
{0.648154,0.695982},
{0.538337,0.693044},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.736403,0.770699},
{0.736403,0.732388},
{0.677219,0.770699},
{0.736403,0.840214},
{0.677219,0.840214},
{0.736403,0.90973},
{0.677219,0.90973},
{0.677219,0.94804},
{0.736403,0.94804},
{0.677219,0.969084},
{0.736403,0.969084},
{0.736403,0.984134},
{0.677219,0.984134},
{0.677219,0.732388},
{0.736403,0.711344},
{0.677219,0.711344},
{0.677219,0.696295},
{0.736403,0.696295},
{0.677373,0.770699},
{0.677373,0.732388},
{0.736402,0.770699},
{0.677373,0.840214},
{0.736403,0.840214},
{0.677373,0.90973},
{0.736403,0.90973},
{0.736403,0.94804},
{0.677373,0.94804},
{0.736403,0.969084},
{0.677373,0.969084},
{0.677373,0.984134},
{0.736402,0.732388},
{0.677373,0.711344},
{0.736402,0.711344},
{0.677373,0.696295},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.186711,0.389033},
{0.030257,0.549068},
{0.213089,0.413328},
{0.333324,0.309908},
{0.373616,0.357438},
{0.262299,0.458651},
{0.06997,0.564231},
{0.178312,0.381297},
{0.017612,0.54424},
{0.311726,0.28443},
{0.472882,0.208668},
{0.506482,0.258905},
{0.540082,0.309142},
{0.413908,0.404969},
{0.311509,0.503974},
{0.144056,0.592519},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.346286,0.536005},
{0.2705,0.640798},
{0.348385,0.537939},
{0.444103,0.440588},
{0.442383,0.43856},
{0.346286,0.536005},
{0.273661,0.642005},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.178312,0.381297},
{0.017612,0.54424},
{0.176213,0.379363},
{0.30313,0.274289},
{0.30485,0.276317},
{0.014451,0.543033},
{0.218143,0.620807},
{0.337887,0.528269},
{0.257856,0.63597},
{0.311509,0.503974},
{0.218143,0.620807},
{0.262299,0.458651},
{0.373616,0.357438},
{0.333324,0.309908},
{0.213089,0.413328},
{0.144056,0.592519},
{0.2705,0.640798},
{0.337887,0.528269},
{0.435507,0.430447},
{0.413908,0.404969},
{0.257856,0.63597},
{0.186711,0.389033},
{0.030257,0.549068},
{0.30485,0.276317},
{0.447703,0.171022},
{0.449136,0.173165},
{0.454871,0.181739},
{0.06997,0.564231},
{0.311726,0.28443},
{0.449136,0.173165},
{0.670131,0.024063},
{0.671471,0.026066},
{0.676832,0.034081},
{0.435507,0.430447},
{0.442383,0.43856},
{0.563828,0.344644},
{0.565261,0.346788},
{0.454871,0.181739},
{0.676832,0.034081},
{0.671471,0.026066},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.558093,0.33607},
{0.773315,0.178337},
{0.778676,0.186352},
{0.780016,0.188355},
{0.778676,0.186352},
{0.563828,0.344644},
{0.558093,0.33607},
{0.506482,0.258905},
{0.472882,0.208668},
{0.693667,0.059251},
{0.540082,0.309142},
{0.725074,0.106209},
{0.773315,0.178337},
{0.75648,0.153166},
{0.75648,0.153166},
{0.094986,0.911216},
{0.693667,0.059251},
{0.725074,0.106209},
{0.595105,0.774118},
{0.595315,0.735187},
{0.646624,0.772089},
{0.645877,0.84203},
{0.594957,0.84267},
{0.646557,0.911988},
{0.595094,0.911196},
{0.648023,0.950507},
{0.595307,0.950069},
{0.648469,0.972245},
{0.595784,0.971747},
{0.648408,0.988117},
{0.596311,0.987043},
{0.536078,0.976907},
{0.537284,0.993176},
{0.648177,0.733593},
{0.595623,0.713466},
{0.53762,0.709347},
{0.536398,0.731676},
{0.537662,0.771248},
{0.538203,0.84312},
{0.537648,0.914986},
{0.536408,0.954559},
{0.648468,0.711859},
{0.595933,0.698144},
{0.538622,0.693044},
{0.594924,0.774044},
{0.595083,0.735113},
{0.537478,0.771248},
{0.538113,0.84312},
{0.594865,0.842595},
{0.537651,0.914986},
{0.595093,0.911121},
{0.536463,0.954561},
{0.595357,0.949994},
{0.536163,0.97691},
{0.595862,0.971671},
{0.537391,0.993177},
{0.596409,0.986966},
{0.648547,0.972099},
{0.648507,0.987971},
{0.536163,0.731678},
{0.595363,0.713392},
{0.648205,0.711716},
{0.647943,0.73345},
{0.64644,0.771948},
{0.645784,0.841889},
{0.646556,0.911845},
{0.648073,0.950362},
{0.537356,0.709348},
{0.595653,0.698069},
{0.647871,0.695839},
{0.648154,0.695982},
{0.538337,0.693044},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.736403,0.770699},
{0.736403,0.732388},
{0.677219,0.770699},
{0.736403,0.840214},
{0.677219,0.840214},
{0.736403,0.90973},
{0.677219,0.90973},
{0.677219,0.94804},
{0.736403,0.94804},
{0.677219,0.969084},
{0.736403,0.969084},
{0.736403,0.984134},
{0.677219,0.984134},
{0.677219,0.732388},
{0.736403,0.711344},
{0.677219,0.711344},
{0.677219,0.696295},
{0.736403,0.696295},
{0.677373,0.770699},
{0.677373,0.732388},
{0.736402,0.770699},
{0.677373,0.840214},
{0.736403,0.840214},
{0.677373,0.90973},
{0.736403,0.90973},
{0.736403,0.94804},
{0.677373,0.94804},
{0.736403,0.969084},
{0.677373,0.969084},
{0.677373,0.984134},
{0.736402,0.732388},
{0.677373,0.711344},
{0.736402,0.711344},
{0.677373,0.696295},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.186711,0.389033},
{0.030257,0.549068},
{0.213089,0.413328},
{0.333324,0.309908},
{0.373616,0.357438},
{0.262299,0.458651},
{0.06997,0.564231},
{0.178312,0.381297},
{0.017612,0.54424},
{0.311726,0.28443},
{0.472882,0.208668},
{0.506482,0.258905},
{0.540082,0.309142},
{0.413908,0.404969},
{0.311509,0.503974},
{0.144056,0.592519},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.346286,0.536005},
{0.2705,0.640798},
{0.348385,0.537939},
{0.444103,0.440588},
{0.442383,0.43856},
{0.346286,0.536005},
{0.273661,0.642005},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.178312,0.381297},
{0.017612,0.54424},
{0.176213,0.379363},
{0.30313,0.274289},
{0.30485,0.276317},
{0.014451,0.543033},
{0.218143,0.620807},
{0.337887,0.528269},
{0.257856,0.63597},
{0.311509,0.503974},
{0.218143,0.620807},
{0.262299,0.458651},
{0.373616,0.357438},
{0.333324,0.309908},
{0.213089,0.413328},
{0.144056,0.592519},
{0.2705,0.640798},
{0.337887,0.528269},
{0.435507,0.430447},
{0.413908,0.404969},
{0.257856,0.63597},
{0.186711,0.389033},
{0.030257,0.549068},
{0.30485,0.276317},
{0.447703,0.171022},
{0.449136,0.173165},
{0.454871,0.181739},
{0.06997,0.564231},
{0.311726,0.28443},
{0.449136,0.173165},
{0.670131,0.024063},
{0.671471,0.026066},
{0.676832,0.034081},
{0.435507,0.430447},
{0.442383,0.43856},
{0.563828,0.344644},
{0.565261,0.346788},
{0.454871,0.181739},
{0.676832,0.034081},
{0.671471,0.026066},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.094986,0.911216},
{0.558093,0.33607},
{0.773315,0.178337},
{0.778676,0.186352},
{0.780016,0.188355},
{0.778676,0.186352},
{0.563828,0.344644},
{0.558093,0.33607},
{0.506482,0.258905},
{0.472882,0.208668},
{0.693667,0.059251},
{0.540082,0.309142},
{0.725074,0.106209},
{0.773315,0.178337},
{0.75648,0.153166},
{0.75648,0.153166},
{0.094986,0.911216},
{0.693667,0.059251},
{0.725074,0.106209}
};


// normal array: 53kb.
const tgx::fVec3 sinbad_norm_array[4556] PROGMEM = {
{0.8025579869094069,0.58934258153983,-0.092606691075154},
{0.3259104455971748,0.9090291348506655,-0.2597083237851681},
{0.41961025120365686,0.9023220439968055,-0.09870241132936351},
{0.0,0.9895923950116664,-0.14389889414124776},
{0.0,0.9554041799024307,-0.2953012919459784},
{-0.41961025120365686,0.9023220439968055,-0.09870241132936351},
{-0.3259104455971748,0.9090291348506655,-0.2597083237851681},
{-0.9791415899223167,0.1160049274139401,0.16680708528142418},
{-0.8025579869094069,0.58934258153983,-0.092606691075154},
{-0.45720144018680486,-0.8745027546880159,0.16190050998740968},
{-0.5845364732911621,-0.7690479862461995,0.25861613685730456},
{0.0,-0.9970309084372497,0.07700238711100123},
{0.0,-0.9846726124357602,0.17441286167864775},
{0.45720144018680486,-0.8745027546880159,0.16190050998740968},
{0.5845364732911621,-0.7690479862461995,0.25861613685730456},
{0.9791415899223167,0.1160049274139401,0.16680708528142418},
{0.3925882303812771,0.8953731571151184,0.2101936984873776},
{0.0,0.9819371915754597,0.18920716635714124},
{-0.3925882303812771,0.8953731571151184,0.2101936984873776},
{-0.9595734681604029,0.07349796780928472,0.2716924878065668},
{-0.44111552533412607,-0.8974315856604959,-0.005800204141777218},
{0.0,-0.9948654245015436,-0.10120665556851248},
{0.44111552533412607,-0.8974315856604959,-0.005800204141777218},
{0.9595734681604029,0.07349796780928472,0.2716924878065668},
{0.3765166536998979,0.755233404712252,0.5365237309694427},
{0.0,0.8692260771734787,0.4944148326674734},
{-0.3765166536998979,0.755233404712252,0.5365237309694427},
{-0.8908348055957952,-0.06990273115306027,0.448917539550912},
{-0.45330868321099116,-0.8912170714265064,0.015600298826586064},
{0.0,-0.9798783596253888,-0.19959559198002613},
{0.45330868321099116,-0.8912170714265064,0.015600298826586064},
{0.8908348055957952,-0.06990273115306027,0.448917539550912},
{0.24829305534036186,0.45518726859014386,0.8550760838563972},
{0.0,0.5662316872118494,0.8242461261038613},
{-0.24829305534036186,0.45518726859014386,0.8550760838563972},
{-0.5952799423802567,-0.19589339948310477,0.7792737428135965},
{-0.3142019904759145,-0.8237052181890859,0.4720029901484139},
{0.0,-0.9387879413463396,0.3444955749827588},
{0.3142019904759145,-0.8237052181890859,0.4720029901484139},
{0.5952799423802567,-0.19589339948310477,0.7792737428135965},
{0.0,-0.1696992923554263,0.985495890490705},
{-0.6377409123918371,-0.6304404440517705,-0.44252838910677106},
{-0.8722339959825031,-0.4180162925025066,-0.25390989633106803},
{-0.49988765542677194,-0.6452840649067731,-0.5776857342269376},
{-0.4446283326200606,-0.7226460484733598,-0.5292337238473596},
{-0.49051313366498317,-0.6546175276189561,-0.5752154015985695},
{-0.3897992671780665,-0.5723989238910346,-0.7213986437718246},
{-0.32853069769992643,-0.3942368372399117,-0.8582801971570071},
{-0.04149909657450126,-0.217495265179615,-0.9751787705892438},
{0.1474002535286541,0.041600071552184606,-0.9882016997083852},
{-0.4172831546190652,-0.549177830138487,-0.7240707698530195},
{0.0735057568287779,-0.11640911693700337,-0.9904775722887297},
{-0.47999689683009295,-0.6557957602941146,-0.5826962328810316},
{0.088800244645011,-0.24320067001876888,-0.9659026610654969},
{-0.7277561194381382,-0.4765367471654155,-0.4932380350513808},
{0.043600596024221505,-0.23870326309590995,-0.9701132615389285},
{0.6520349989178755,-0.6044324437821534,-0.45772456902563136},
{0.5114370575145519,-0.6143445139444452,-0.6008435356956254},
{0.8675097942408657,-0.38340432865930596,-0.3169035778615912},
{0.8326495899230357,-0.5102303876756339,-0.2153128233370521},
{0.9296657470965607,0.10939596937976094,0.3517870386453373},
{0.9747435622632181,-0.20580919781858037,0.0867038748827547},
{0.3251040101826985,-0.8326102703110267,-0.4484055311163397},
{0.25621652393646016,-0.7953512938589647,-0.5493354277841436},
{0.08459847174241182,-0.9820822588442395,-0.16839695793643206},
{-0.32590239376187335,-0.9135067097314246,0.24350178852720514},
{0.4678158849580652,-0.846628747767204,0.2537086148222769},
{0.18749714069040654,-0.271195864294604,0.9440856028043351},
{0.8825186963566255,-0.45530964583702166,0.11770249355373918},
{0.5615386071064035,0.017901230751922747,0.8272568758653909},
{-0.42520640153056294,0.44770674027571267,0.7866118425304346},
{-0.7903108075741908,0.34840476446773133,0.5040068923413794},
{-0.9126002692171191,0.03560001050200465,0.40730012015355316},
{-0.29860522414409496,0.2756048217485351,0.9137159856010033},
{-0.3170000935150414,0.060400017818007884,0.9465002792176236},
{-0.9553675323861083,-0.2644910114257124,0.13159552780198017},
{0.7941404188051988,0.4266217134646742,0.43282202903776607},
{0.4361253592462915,0.5201302438523188,0.7343426995976883},
{0.1169005973635788,0.7049036020666098,0.6996035749834023},
{-0.20780470786898575,0.5624127416049932,0.8003181314126531},
{-0.43058956048265756,0.6021854001919563,0.6722837006792631},
{-0.6220981772550109,0.5672983378183053,0.5395984189789486},
{-0.8356973508435966,0.368398832177553,0.4072987088651393},
{-0.9012604360448765,0.36032416234683645,0.24061613505592241},
{-0.9494441454318365,0.3011140006209458,0.08880412904397207},
{-0.8363313086485699,0.4270159856426394,-0.3438128708757363},
{-0.6441023155519866,0.2572009246389861,-0.7204025898519658},
{-0.8319565292068806,0.2071140728437853,-0.5147349748560903},
{-0.20730001865700254,-0.01230000110700015,-0.978200088038012},
{0.008200045059371403,-0.23440128803861668,-0.9721053417335292},
{-0.8170516188665843,-0.543934364138966,-0.19121208020476246},
{-0.3077010631090095,-0.8282028614458296,-0.468401618330387},
{0.5791116576350034,0.3258065585520361,-0.7473150436032431},
{0.8859656923617305,0.4151307810129296,0.20671532747620464},
{0.7907379958735745,0.4835232338495931,-0.3754180392701908},
{0.6286087817260215,0.20170281780804727,-0.751110493086883},
{0.9306436761326053,0.32471523924377493,-0.1687079176483672},
{0.9343074090871313,0.3533028017023263,0.047400375886471176},
{0.8358830073041426,0.4030400238616529,0.37263700469194005},
{0.44472033752606316,0.5922270831637837,0.6719307280948097},
{0.6244140838184926,0.5688128297180631,0.5353120740999986},
{0.22570936036126532,0.5304219970563363,0.8171338872449707},
{-0.10970567302703214,0.6485335365362839,0.7532389509932598},
{0.4196037743529255,-0.47040423130509096,0.776306982912717},
{0.3902213983770861,-0.9023494816905299,0.18301003563046322},
{-0.11400237982451852,-0.3215067115226553,0.9400196231144509},
{0.2665167617662378,0.1971123967884633,0.9434593360235224},
{0.21931709533727003,0.278121679039192,0.9351728948922993},
{0.10909869355096705,0.3332960088041917,0.936488785613938},
{-0.5103022300256178,-0.048900213694400764,0.8586037521065951},
{-0.3464030119872839,-0.4558039632326905,0.8199071291234817},
{-0.41191380140312794,-0.07970267048271254,0.907730414017041},
{-0.21999815972309084,0.23329804846998678,0.9471920767714165},
{0.36709946770615776,0.1267998161403999,0.9214986638279062},
{0.3363131265574993,0.34051329049309703,0.8780342703463705},
{-0.40392717309493187,-0.882059338127581,0.24251631462124532},
{-0.04010156659829934,-0.9775381882752521,-0.20690808302214797},
{-0.2467153745476123,-0.7838488470629045,-0.5698355104062809},
{-0.5443164549351528,-0.7868237860425836,-0.2909087943057798},
{-0.4535112154710396,-0.8827218299807865,0.12300304190283984},
{-0.7232209664797317,-0.19430563300195228,0.6627192125084599},
{0.5678400540108643,-0.7703543388597548,-0.29002045731446047},
{0.3997183814724177,-0.5625258683468476,-0.7237332816402019},
{0.49761739452004344,-0.63922234440758,-0.5863204951911204},
{0.4421972207992008,-0.8581946062638494,-0.2606983615159468},
{0.4587045618395514,-0.710907070005967,-0.5331053017585892},
{0.3952041872105454,-0.5491058178069598,-0.7364078022819981},
{0.30060777832689756,-0.401710394390934,-0.8650223827437339},
{-0.13069820487248404,-0.1702976609776896,-0.9766865853018758},
{0.48239397976069864,-0.6535918432246945,-0.5831927218002477},
{0.5103294238911761,-0.8498489994566363,0.13160758805424022},
{0.2622994609751615,-0.8270983003147392,-0.49709897846264883},
{0.5399150881379601,-0.8259230807429916,0.16230453566362457},
{0.19209768523683923,-0.9124890045737418,-0.3611956476186691},
{0.44751756540917026,-0.8750343457721206,0.18450724205137856},
{0.2794032005819941,-0.9112104379753508,-0.30270346748808025},
{0.02010127627054691,-0.9049574575730298,-0.42502698582002174},
{-0.24800531481084517,-0.9117195383590627,-0.3275070185506121},
{-0.3862942732298487,-0.9063865629188064,0.17099746498137236},
{-0.4111296620194882,-0.8697627512973702,-0.27291969050138243},
{0.007599719993475166,-0.9227660013130109,-0.38528580440605015},
{0.21080120894839996,-0.5270030223709999,-0.8233047216661182},
{-0.5855095877980009,-0.6540107095130532,0.47900784381766426},
{-0.5959390323051731,-0.11840775536991525,-0.7942520212397525},
{-0.16279928042877076,-0.9063959937385615,-0.38979827709542286},
{-0.4825080941411694,-0.8618144570587768,0.15640262367601845},
{-0.24581664726704844,-0.8196555089506627,-0.517435041887595},
{0.863377970868398,-0.4715425845759871,0.1795162119435624},
{-0.07819890952380999,0.13909806029107377,0.9871862337839541},
{-0.8226519233147618,-0.5101321980097981,0.25101584336494676},
{0.12750152428983438,0.1872022380161333,0.9740116443788133},
{0.7706983430003439,-0.12409973318586047,0.6249986562543336},
{0.7241252796547768,-0.45711595819665585,-0.5164180284680662},
{-0.13070563222704162,-0.2907125270726932,-0.9478408433419283},
{-0.08619764468153818,-0.2838922427504488,-0.9549739056945354},
{0.9654704039583931,0.25549216800763275,-0.05089843973224465},
{0.9396819864689774,0.3224938178527671,0.11399781468283861},
{0.9153860778000336,0.29482772395438644,0.27412577725881043},
{0.8211307847701924,0.46501743383039756,0.3309124061386636},
{0.8239773792291153,0.3353314907822823,0.45674289245531857},
{0.7182623873891028,0.4719409922151456,0.5112444060614165},
{-0.9560008795212137,0.26540024416833696,-0.1250001150001587},
{-0.9794134180557416,0.20180276471681505,-0.005000068501407707},
{-0.9481588540466627,0.27601713291517654,0.15750977693529095},
{-0.9319466078153145,-0.01860093025578372,-0.3621181099795315},
{-0.9554165479579172,0.11580200570810845,0.27160470423421634},
{-0.9639030170211649,0.26620083320991195,-0.005300016589077886},
{-0.7569827220665509,0.026799388310942623,-0.6528850980677029},
{-0.6829599084559205,0.03400298270244736,-0.7296640052854586},
{-0.6852426748164027,0.13040812141864988,-0.716544624206002},
{0.9622803104546034,0.15961332108558998,0.2203183874383175},
{0.9078241983765158,0.050401343465715356,-0.4163110969201846},
{0.8130191021082087,0.08490199479580188,-0.5760135335969596},
{0.9418027500680454,0.27340079833149666,0.19560057115450166},
{0.8195281799609603,0.1273043774362785,0.558719211890407},
{0.9714984018864433,0.16519972824667056,-0.16999972035069003},
{0.8383376673576106,0.2582116017079029,-0.4801215723468792},
{0.786643022683398,0.531529070119789,0.3141171795383363},
{0.5902770888394364,0.17649314955134765,0.787669427204513},
{0.9859938375577727,0.14809907438367764,0.07669952062949409},
{0.8938762187395465,0.3199914867397414,-0.3139916463633713},
{0.7250205691253232,0.5035142849028968,0.46991333163033017},
{-0.9132699180549675,0.26091997549336515,0.3128239491541764},
{-0.7915853518485947,0.10659802742175366,0.6016888658505551},
{-0.9876989431626962,0.10339988936217759,-0.11729987448920146},
{-0.825127605105801,0.43521456034667866,0.36021205109575755},
{-0.8785032241127487,0.18960069583583058,-0.43850160930385923},
{-0.47340298954931853,-0.18590117396962044,-0.8610054372665046},
{-0.734415962704426,-0.575412506726752,0.35990782268153987},
{-0.43002269504661245,0.25941369091881694,0.8647456381553623},
{-0.9430431499265098,0.22931049234162112,0.2410110277118652},
{-0.813606818053703,0.3142026330290972,0.4892040995475314},
{-0.5525338962315784,0.17851095109020224,0.8141499455604126},
{-0.7964994344856023,0.5005996445743786,0.33909975923925645},
{-0.9867586112780566,0.09659594836791678,0.13029453491034737},
{-0.7104486496369828,0.45833138531620105,0.5340365694061779},
{-0.9277013637220071,0.2556003757328285,-0.272100399987882},
{-0.1304059329528826,0.4086185905256736,0.9033410984381814},
{-0.17840251460116507,0.31250440478062824,0.9330131509130438},
{-0.7243488589783628,0.4830325816464851,0.4919331820122278},
{0.6344151246368591,0.10360246991232441,-0.766018262093055},
{0.7132230731396301,0.09750315427806218,-0.6941224552246458},
{0.945573519584371,0.32159099397031904,-0.04969860820996535},
{0.6361265047629929,0.3361140044817512,0.6945289381510747},
{0.2457097622427847,-0.14890591614957527,-0.9578380556619421},
{0.7947126797419588,0.27560439730323877,-0.5408086286705062},
{0.5772023290160964,-0.37150149901157276,-0.7272029342697596},
{0.8995452932458011,-0.15910801129005775,0.40682048392706155},
{0.3502982380042942,-0.5433972667186225,-0.7628961626419528},
{0.8922373810681361,-0.36891545603680276,0.2604109101436255},
{-0.2922075025239422,-0.20500526357771437,-0.9341239839411855},
{-0.8487691859940436,0.013899495387979742,-0.528580810222021},
{-0.8529491909983082,-0.4304248233153616,0.29531703142431753},
{0.648909675315389,-0.6381095142837875,0.41440617884219016},
{-0.23090539054926426,-0.503911763957446,-0.832319430723918},
{0.5522287470156584,-0.05080264460049881,-0.8321433183479342},
{-0.45561288035819414,0.009700274230628804,0.8901251641940927},
{0.5054943132209642,0.07469915963918106,0.8595903296631866},
{-0.8629477309590355,-0.22761258960050582,0.4511249524111959},
{0.7857035003168908,-0.5462024333372608,0.2904012937406454},
{-0.36541356805767766,-0.5307197059885318,-0.7647283948924634},
{0.4297091314160649,-0.12250260320797754,-0.8946190108559731},
{-0.23299838299683298,0.07219949893721606,0.9697932696580628},
{0.2846059696728215,0.12830269117717144,0.9500199268769515},
{-0.8471991104414011,-0.5100994643958436,0.14849984407524558},
{-0.5988911185105683,-0.3738944551863441,-0.7081894976276248},
{-0.07340034167938579,0.36830171444847115,0.9268043142841245},
{0.4716792890171189,-0.09929564002416771,0.8761615285919008},
{0.4667130448119063,0.24800693189062087,0.8489237277497905},
{-0.11490583104434827,-0.9925503682464375,-0.04050205532894782},
{0.7016081632584695,-0.5424063109341418,0.4621053766273358},
{0.112301604801399,-0.4797068550599386,0.870212435424554},
{-0.6020254662158429,-0.4458188585365826,0.662428021297964},
{-0.6199126897426398,-0.09320190786258112,0.7791159486667054},
{0.1899978245373635,-0.09989885616464535,0.9766888169770681},
{0.8468150692082361,-0.10990195572270328,0.5204092607651937},
{0.8031999799200008,-0.5265999868350005,-0.2784999930375003},
{0.3786096527761479,-0.4199107057599168,-0.824821029080208},
{0.9666239677384239,-0.08380207789828255,-0.24210600309277094},
{0.4551148688456518,-0.059701950494584516,-0.8884290254503999},
{0.9623281292623336,0.03810111371183093,-0.2692078690610207},
{0.5032088741667446,-0.0405007142363934,-0.8632152229346859},
{0.948227887792276,0.19750580873125342,-0.2487073145896847},
{0.5354162742249864,-0.044301346559893345,-0.8434256363118295},
{0.16969592480129825,-0.9854763340700026,-0.006299848710949788},
{-0.033300386619733,-0.4458051758281372,0.8945103853258608},
{-0.6408888037703964,-0.5592902292850408,0.525790814514705},
{-0.7862624081240975,-0.5821462067782207,-0.2071164394842287},
{-0.807213831727511,-0.13330228415420864,0.5750098528782444},
{-0.12660279162233323,-0.06650146637350049,0.9897218236068185},
{0.6686758044037686,-0.02379913884374113,0.7431731087675801},
{0.664423753573793,-0.3817136465067983,0.6425229706068061},
{-0.42441768160893145,-0.4054168900194646,-0.8096337300438051},
{-0.4540946916640815,-0.05759932666780686,-0.889089606603248},
{-0.9211353814895176,-0.3834147272425155,-0.06710257745950128},
{-0.9966743110506948,-0.07949795096672042,-0.017899538645337047},
{-0.9781630690971356,-0.1970127028035331,0.066204268657837},
{-0.5671194496950467,-0.07700264085085275,0.8200281233467435},
{-0.9193159364798895,-0.3770065354649389,0.11280195543884644},
{-0.526501213586696,-0.05330012285692478,0.8485019557992622},
{-0.40102391577434704,-0.4767284305477088,-0.7822466506700605},
{0.3991989421242051,-0.41709889468939365,-0.8164978362836008},
{-0.5019078624482484,-0.1245019503383282,-0.8559134079885551},
{0.4040077550032867,-0.07200138207979366,-0.9119175044244978},
{-0.5495121388572225,-0.10690236149924855,-0.8286183043805179},
{0.3528004762809645,-0.1905002571755208,-0.9161012367375044},
{-0.5802027472665126,-0.1115005279562498,-0.8068038202251331},
{0.29199327109260054,-0.3979908284070378,-0.8696799584562833},
{0.9446557363327139,-0.3200188816710443,0.07220426017702937},
{0.5773065062809889,0.013900156655648267,0.8164092009835429},
{0.9363227248283007,-0.3344081161834708,-0.10710259941163196},
{0.9968578039022225,-0.02489894604992009,-0.07519681698610405},
{-0.9726302444076821,-0.14790459916501766,-0.17920557248391591},
{-0.8197170625882385,0.04220087842042658,0.5712118898992338},
{-0.1454013158878632,0.060700549342457326,0.9875089369963198},
{0.6175105162936395,-0.008800149867828384,0.7865133944371618},
{0.16221022524383252,0.37782381687496874,0.9115574618357173},
{-0.3967269981908716,-0.17261174662905077,-0.9015613533377129},
{-0.321895874930794,-0.37789515730458856,-0.86808887551234},
{0.9901403044814076,-0.13930567055273213,0.014700598400037058},
{0.8493305000058926,0.06600237018767093,0.5237188070800495},
{0.803537626530314,0.31331467130298374,0.5061236997971275},
{-0.9769761376492533,-0.027299333221928984,-0.211594831859347},
{-0.7894972486068831,0.2905989872642942,0.5405981160188486},
{-0.15359908762412922,0.2405985708487337,0.9583943071547231},
{-0.9709691063305338,0.13330948797390066,-0.1986141358710928},
{0.20149654436389602,0.02819951638244103,0.9790832088669508},
{0.19799918325505364,0.20929913664284205,0.9575960499244411},
{0.8617006635097664,-0.2594001997382307,-0.43610033579738783},
{0.881337497301501,-0.3061130238556558,-0.35991531292273937},
{0.6671989258105943,-0.087699858803341,0.7396988090858762},
{0.6545224177767198,-0.6907236576904208,-0.30741052899093},
{0.45209165898583686,-0.5031907162169279,0.7364864119510481},
{-0.18539584996034747,-0.9514787013876517,0.24559450242859407},
{-0.3843094637370682,-0.6245153788805597,-0.6799167431559529},
{-0.8960152099872853,-0.35180597195706137,0.27090459864459326},
{-0.3206960153767632,-0.1743978331203851,-0.9309884325405879},
{-0.9901817560692151,0.08089850945869471,0.1139978996080494},
{-0.9992799596413621,0.018899620971902075,0.03289934021034806},
{-0.3149031144072023,-0.20140199187554952,-0.9275091731110833},
{0.6138165057477624,-0.12970348777368,0.7787209400876222},
{-0.8692196923951994,-0.3259073835154113,-0.37180842341524983},
{-0.6166875245375666,-0.09139815103410667,0.7818841826429761},
{-0.8815938553122427,-0.37029741903598395,-0.2926979599023292},
{0.27131284154069235,-0.22491064527276708,-0.935844294558717},
{-0.5587250230604991,-0.1285057552591268,0.8193366948155844},
{0.27541563165777466,-0.1978112270947997,-0.9407533939741055},
{0.9967174078215426,0.07570132213513674,-0.028700501258631758},
{0.9887981163413824,0.14059973215776533,0.050099904559772715},
{0.929180803322903,-0.2891940253131549,0.23019524421538123},
{0.37949885771015746,-0.6320980973875903,-0.6755979664531814},
{0.25430562784581706,-0.9278205328955921,0.2729060394774812},
{-0.6302276865104159,-0.7389324620161002,-0.23831046920887358},
{-0.3784003027203633,-0.49400039520047423,0.7828006262407515},
{-0.37471013791992397,0.10280278136687533,0.9214249294887056},
{-0.35329718246620473,-0.21909825269840208,0.9094927468242661},
{-0.40020245324855763,0.014900091337839852,0.9163056169706482},
{0.4212094141356101,0.16450367669826177,0.8919199346333111},
{0.417891615088864,-0.15839682179965558,0.8945820503912365},
{0.45140244435085425,0.07800042237343073,0.8889048134325971},
{-0.4043288680900927,-0.37442673315095404,-0.8344595783684723},
{-0.9305511956823344,-0.2844156475572874,0.2306126875060143},
{-0.9702458694577436,-0.04900231663927999,0.23711120969741398},
{-0.5454799212536412,-0.1808933414386502,-0.8183698763592666},
{0.4415041280828964,-0.12920120803694274,-0.8879083019814354},
{0.3760115474919379,-0.38831192524233904,-0.8413258375132111},
{0.9573394575588817,-0.2218091420521884,0.18520763348992467},
{0.4980057843707784,0.09540110809030575,0.8619100111429195},
{-0.4843108995394426,-0.193104345862206,-0.853319204164787},
{0.5064000481080069,-0.18690001775550255,-0.8418000799710114},
{0.9836346934074656,0.01550054671392407,0.17950633129995938},
{0.4988036063631111,0.1287009305110914,0.8571061969002055},
{0.8726030192116697,0.30260104700143386,0.3834013265708849},
{0.9102251316628326,0.10450288536449791,-0.40071106378520877},
{0.9338087171450621,-0.09830091764334932,-0.3440032112849661},
{0.8932077307463645,-0.014700127230151768,0.44940388960749694},
{0.2569084961044516,0.24050795372954692,0.936030955055534},
{-0.4492014509230297,0.030700099161480438,0.8929028840809734},
{0.2719079044776764,0.04590133437118554,0.9612279433024736},
{-0.45212455555143616,0.06410348155462743,0.8896483181122706},
{0.2653046044013644,-0.12660219720019877,0.9558165883408373},
{-0.4724039658479399,0.08040067496649952,0.8777073683842864},
{0.06560230891389406,-0.5087179046417364,0.8584302129830282},
{-0.585431927400765,-0.28241540194392895,0.7599414445367976},
{-0.39100367545182396,-0.9192086406018326,-0.04660043804617646},
{0.5513070292094339,-0.7380094096799604,0.3891049611198816},
{0.6228285853739036,-0.7081325004869318,-0.3326152657279389},
{0.16421013454118946,-0.4958306011298522,-0.8527526292525716},
{0.8987297799046439,-0.30000994099409495,-0.3198105970997052},
{0.3086984518811457,-0.15469922418533608,-0.9384952934579049},
{0.35509942296390656,-0.14699976112558225,-0.9231984998036569},
{-0.8648225678393655,0.27060706158340925,0.4229110360074788},
{-0.9365857967840869,0.035899455588883966,-0.3485947136012521},
{-0.21539460981733316,0.2674933060637726,0.9391764974022252},
{-0.8631017132586012,-0.04410008753876065,0.5031009986564735},
{-0.9449955916058476,-0.16519922934739265,-0.2822986830797151},
{-0.3992184842437406,-0.20760961254759658,-0.8930413487716944},
{-0.9716087639505764,0.1526013764706237,0.18080163083806525},
{-0.556022391472566,0.007500302043245044,-0.8311334704187942},
{-0.2174944724482232,0.07369812698590368,0.9732752645234742},
{-0.7835106949939804,-0.31620431621837475,0.5349073015344993},
{-0.8969582548456029,-0.36332359681726784,-0.2519163612393883},
{-0.3534021628278548,-0.2134013060199893,-0.9108055741471708},
{-0.20129898444918515,-0.09819950458474903,0.9745950831802079},
{-0.4839974614399721,-0.7492960699524196,0.4519976292786516},
{-0.5991109188959962,-0.7557137730090208,-0.26450482064428477},
{-0.18461288550603153,-0.5418378188904003,-0.8199572309122171},
{0.830894108981651,-0.29209792903302473,0.47359664221171005},
{0.5052006946514327,0.0011000015125031196,-0.8630011866274474},
{0.9700287035740144,0.21410633550020258,0.11490340004191162},
{0.5173852521435784,0.14559584984944923,0.8432759627612674},
{-0.6223143787398331,-0.21550497930007076,-0.7525173871150962},
{-0.989491698199478,-0.10829909137443502,0.0957991962481152},
{0.5888033532446452,-0.214101219309916,-0.7794044387209178},
{0.9980054690849559,-0.049000268522207256,0.03980021810579284},
{0.6442138700739357,-0.2153046355587059,0.7339158013773074},
{0.014200783833896165,-0.47262608731685407,0.8811486363412613},
{0.4402087668448884,-0.8973178702633312,-0.032200641282156765},
{-0.6463542895767681,-0.20721740492078963,-0.7343616816280687},
{-0.9006172289723869,-0.04470085513553819,0.43230827013631234},
{-0.9051356539956302,0.13350525887572273,0.40361589874338344},
{-0.6862387427018598,-0.027901575227895492,-0.7268410349689765},
{0.22660017108319375,-0.16330012329163962,-0.960200724951821},
{0.6133146614622255,-0.2037048696231132,-0.7631182425596352},
{0.9253974273987278,0.02459993161228518,0.3781989486083843},
{0.28701223272204346,0.14000596718148464,0.9476403892941059},
{-0.2724178003606323,-0.2184142716547801,-0.9370612295811767},
{0.6431282789721533,-0.022300980595675663,-0.7654336568578542},
{0.917872271518559,0.20131585122759418,0.3420269305506071},
{0.30261094714902326,0.15250551698686732,0.9408340352868508},
{0.9663445785036333,0.023101065676740067,0.2562118193238444},
{0.8629264145818317,-0.08210251319639401,-0.4986152628467972},
{0.8249490818057265,-0.23501398257285214,-0.5140305831593447},
{0.9433327625157731,-0.16930588009532532,0.2854099124583925},
{0.5249173986755235,0.0847028075210837,0.8469280718961721},
{-0.2361963992133408,0.0837987224982132,0.9680852416529857},
{0.47328153054864847,-0.0309987902958126,0.8803656444010778},
{-0.2527936587506044,0.0956975994558261,0.9627758490707352},
{0.4539997253302493,-0.1363999174780749,0.8804994672979835},
{-0.28199766929889486,0.08329931153403525,0.9557921004109351},
{0.19520680014732675,-0.5248182823633047,0.8285288623056363},
{-0.443590520571862,-0.2632943734593581,0.8566816929078318},
{-0.41159281982588664,-0.9111841045319434,0.01829968076485356},
{0.6088444168203697,-0.7535549738405857,0.24791808628411574},
{0.5210381700492717,-0.7145523464495289,-0.4668341991919385},
{0.006100195849931694,-0.5107163968131337,-0.8597276019977503},
{0.7845237949675575,-0.34951060081728663,-0.5122155357328018},
{0.14040307626510182,-0.19390424848862708,-0.9709212731181436},
{0.16790511698641142,-0.18000548575076863,-0.9692295377202499},
{-0.9494578000029164,-0.019001156730625038,0.31331907387920127},
{-0.8843334063253978,-0.15200574212536522,-0.44141667482984354},
{-0.4786258823944046,0.09330504560676546,0.8730472113044614},
{-0.9136472733329151,-0.208410783452911,0.3490180586615448},
{-0.8385085109045787,-0.30310307651183993,-0.452804595989974},
{-0.21339882951063022,-0.23209872694197412,-0.948994794777826},
{-0.9024689781620544,0.20749286755526458,0.3774870241065657},
{-0.6988900548652783,0.057799177523555706,-0.7128898556495306},
{-0.418516094345868,-0.017800684538486142,0.908034919154237},
{-0.8639880338485962,-0.3712948576018331,0.340095289712856},
{-0.7914885472435814,-0.41499399508033646,-0.4486935074519204},
{-0.18530943805002595,-0.24461245842976984,-0.9517484737841861},
{-0.3932178583945677,-0.12180553192385134,0.9113413895090782},
{-0.548675491213199,-0.7742654143363951,0.31538591202595767},
{-0.5051204249573331,-0.7624308295138996,-0.40441635290585126},
{-0.026600537203273284,-0.5482110712343765,-0.8359168815118849},
{0.9023024271967938,-0.33430089927062856,0.27220073222095453},
{0.6516076727255198,0.06450075950091472,-0.7558088997021913},
{0.9094255552171575,0.273807694104308,0.3130087956707393},
{0.3320065206720996,0.14140277717781594,0.9326183168036148},
{-0.7348345049642899,-0.22331048579004617,-0.6404300721000697},
{-0.9405817622964417,-0.10509796217027007,0.32289373915109615},
{0.7079255884328493,-0.2107076161644319,-0.6741243666656077},
{0.9623207767298568,-0.03830082692378002,0.2692058122162293},
{0.5072948712747769,-0.19979798005263244,0.8382915249155245},
{-0.11580732388675122,-0.49723144591099055,0.8598543789104378},
{0.4640768640246517,-0.8852558666688733,0.030898459595694327},
{-0.31709379294975387,-0.9242819073587434,0.21249584043463482},
{0.7241144426065881,-0.6741134453267519,0.14570290607344275},
{0.487512682807417,-0.4164108330687353,0.7674199646900755},
{-0.18319628390107123,-0.21319567536958728,0.9596805330778279},
{-0.0839031929967654,0.14520552590143426,0.9858375167605641},
{0.651438631456302,-0.06100361762179064,0.7562448466491489},
{0.9576733866263732,-0.2734923997518149,0.08979750456202185},
{0.46810645523252675,-0.7205099359005246,-0.5116070551099353},
{-0.17980740102494241,-0.5850240800867148,-0.7908325513377334},
{0.7078323451380335,-0.34761588467078336,-0.614928099781544},
{-0.03669979044479484,-0.25669853425555406,-0.9657944853292331},
{0.7546142321586291,-0.23560444354170818,-0.612411550190756},
{-0.000500000512500788,-0.24190024794788123,-0.9703009945590292},
{0.7553615002601674,-0.06720547175623362,-0.6518530727784684},
{0.029998882712419673,-0.24929071534020747,-0.9679639488540748},
{0.38199261806398316,-0.894882706558792,0.23079553991928617},
{-0.41691283068979973,-0.4080125567796553,0.8122249966089119},
{-0.6741070040081577,-0.7060073354543233,0.2171022557041552},
{-0.45461567996520763,-0.7675264724445597,-0.4519155868373897},
{-0.933353608704068,-0.32181848417547315,0.15900913295183416},
{-0.6015330310856303,-0.06320347059785841,0.7963437284347255},
{0.1327109132671154,0.1935159134678736,0.9720799374200162},
{0.2509156751918592,-0.159609971146356,0.9547596456981584},
{-0.873340794701303,-0.3240151351004491,-0.36371698961738685},
{-0.851117682153522,-0.031800660665588065,-0.5240108864392499},
{-0.8327293000958949,-0.10030352924176564,0.5445191592436829},
{-0.8020873030584882,0.1841970841832359,0.5680910071905337},
{-0.8193143094493729,0.11970209061526906,0.5607097928820497},
{-0.11900015410529935,0.14600018907036727,0.9821012718219705},
{-0.7867072495407069,-0.012200112424553992,0.6172056875766166},
{-0.06510211031910955,0.15960517368555888,0.9850319303275407},
{0.16699873415439265,-0.6089953838324857,-0.7753941225348266},
{0.8679619877188585,-0.2910207839914596,-0.4024287404747881},
{-0.004900158130654355,-0.29710958788110386,-0.9548308128875058},
{0.8195109610324063,-0.008000107002146737,-0.5730076640287599},
{-0.04200104058867104,-0.28460705122704233,-0.9577237278992917},
{0.8254381154849941,-0.06680308470365594,-0.5605258828802268},
{-0.07190140892191187,-0.2936057532611033,-0.9532186785030097},
{0.7893738958368899,-0.2596914121469981,-0.556281604071525},
{0.8207537857579288,0.05890386009643232,0.5682372378063302},
{0.11310031328830172,0.20690057311538132,0.9718026918971849},
{0.8674809286414236,-0.029599349265459523,0.49658908260902695},
{0.8218322452207243,0.2535099466578895,0.5102200188751685},
{-0.721220684905869,-0.413411856822083,-0.5558159410297864},
{-0.9778449378967052,-0.16390753254374102,0.13020598375347825},
{-0.6481355868613717,0.016700916989021614,0.7613418026192907},
{0.16739829170914963,0.19609799883013287,0.9661901400799305},
{-0.8530276684011442,-0.0913029614595832,-0.5138166659138428},
{-0.8061320282617369,-0.2818111965812647,-0.5203206727510007},
{0.842265223332951,0.1898146988703326,0.5045390704956942},
{0.9915241240754117,-0.11220272992562903,0.06550159367316134},
{0.9925598964275609,0.11739525674047517,0.0322986949975924},
{-0.7740940046651507,-0.30419764399837085,-0.5551957000259549},
{-0.9941143849392258,0.06360092031197542,0.08770126904654471},
{-0.6585678429173264,0.20568995640463716,0.7238646545518563},
{-0.7869245642336649,-0.1380043078717064,-0.6014187735800306},
{-0.6129194972793176,0.3311105327935749,0.7174228215829377},
{0.691304019944564,0.022800132583156458,0.7222041996296312},
{0.6889151356317965,0.21340468855251182,0.6927152191205479},
{0.47031841567810584,-0.15580610070731213,-0.8686340120306246},
{0.5060060999403023,0.005800069920264335,-0.8625103976255154},
{0.67132047894357,-0.40131224221667605,-0.6231190085352875},
{0.308411263385012,-0.30381109538380885,-0.9014329209314196},
{0.8097539921474497,-0.42302820634601856,-0.40662711276664576},
{0.6934066532687573,-0.6821065448436968,-0.23220222799106638},
{-0.31708484212142496,-0.6787675522927255,-0.6623683362385112},
{0.15090820510217318,-0.3661199064804877,-0.9182499266058013},
{0.4484429157983393,-0.15491482528359224,-0.8802842428316195},
{0.46351222297848205,0.06740177740830569,-0.8835232988165886},
{0.4693245486625435,0.19711031012441363,-0.8607450224458794},
{0.1992050190336826,0.496412507270683,-0.8449212880600323},
{0.2415022858299531,0.3119029521754136,-0.9189086975119831},
{0.06329943853647027,0.03469969221509508,-0.9973911531797068},
{-0.025100364334432492,-0.1100015966847639,-0.9936144224180129},
{0.09159871304712247,-0.37549472433618436,-0.9222870419580901},
{0.26111369054970274,-0.5047264635022404,-0.822843142796995},
{0.6784315545854228,-0.575126749767212,-0.45712126120429947},
{0.9023865139343231,-0.4306935633327937,-0.014199787785757303},
{0.6597957476301097,-0.7293952990624463,0.18069883539975876},
{-0.7339292366534748,-0.6774269858414822,0.04940196796659171},
{-0.47031841567810584,-0.15580610070731213,-0.8686340120306246},
{-0.67132047894357,-0.40131224221667605,-0.6231190085352875},
{-0.5060060999403023,0.005800069920264335,-0.8625103976255154},
{-0.2415022858299531,0.3119029521754136,-0.9189086975119831},
{-0.1992050190336826,0.496412507270683,-0.8449212880600323},
{-0.4693245486625435,0.19711031012441363,-0.8607450224458794},
{-0.46351222297848205,0.06740177740830569,-0.8835232988165886},
{-0.4484429157983393,-0.15491482528359224,-0.8802842428316195},
{-0.15090820510217318,-0.3661199064804877,-0.9182499266058013},
{0.31708484212142496,-0.6787675522927255,-0.6623683362385112},
{-0.6934066532687573,-0.6821065448436968,-0.23220222799106638},
{-0.8097539921474497,-0.42302820634601856,-0.40662711276664576},
{-0.308411263385012,-0.30381109538380885,-0.9014329209314196},
{-0.06329943853647027,0.03469969221509508,-0.9973911531797068},
{0.13259661816637996,0.2391938994373913,-0.9618754676790413},
{0.07620122037231647,0.5288084689354455,-0.8453135378047127},
{-0.15840159035995088,0.6750067771020634,-0.7206072349329583},
{-0.3806189857485255,0.5138256302616722,-0.7688383506134168},
{-0.6803027926486959,0.3181013058085405,-0.6603027105481902},
{-0.6134915492121141,0.23829671748532485,-0.75288962901679},
{0.9014182043244564,0.42620860736973964,-0.07610153688605628},
{0.8886876962040186,0.31199568044970605,-0.33599534817660653},
{0.8525299157996273,0.38691357703563145,0.35141233127506044},
{0.9045964901724272,0.18339928841214143,0.3847985069846893},
{0.8469783472753244,0.10969719562704025,0.5201867015969583},
{0.7720519994533037,0.3441231774765309,0.5343359887408033},
{0.8245132129301067,0.18910303040034343,0.5333085463379331},
{0.9435348595393404,0.24810916656249107,0.21950810987693187},
{0.904447955101903,0.25681361661893926,-0.3406180600483284},
{0.9663116972738937,0.23030278783212016,0.11490139088975512},
{0.6228985735638998,0.7680982410570419,0.14839966016516734},
{0.5593376614726632,0.7353495127495963,-0.3826257630599694},
{0.13940846444188568,0.9789594393268428,0.1490090473589739},
{0.15410637243025269,0.9032373496366272,-0.4005165617022467},
{-0.041901943876265675,0.9619446256462996,-0.2700125261716404},
{-0.17960610311907776,0.9592325952773908,0.2182074148139352},
{0.01990034915468891,0.9449165787068114,0.32670573210235504},
{0.14060627821048627,0.9747435232699927,-0.17350774729387886},
{0.5492998159845925,0.7992997322346347,0.24369991836054106},
{0.4957319212061428,0.8403541121434775,-0.21921411565137483},
{-0.9000374918426003,0.42951789194044093,-0.07380307433109323},
{-0.8504476391587986,0.38902179166600737,0.3541198365782345},
{-0.8881523225945315,0.3139184934831927,-0.3356197719431649},
{-0.7416317425178842,0.3228138167270402,-0.5880251680157981},
{-0.6065020075249674,0.4533015004304496,-0.6532021621027349},
{-0.29430863955692316,0.2544074682408469,-0.9212270430167775},
{-0.0004999938451136498,0.10389872101461643,-0.9945877567000722},
{0.3502861324465192,-0.09149637773010706,-0.932163096393506},
{0.7659027802321383,-0.2468008958888781,-0.5937021551427347},
{0.7332117424800844,-0.6782108616339243,0.049300789558467215},
{0.7676969676029669,-0.37309852626373186,-0.5209979420621932},
{0.9107331649520636,-0.41181499651615217,-0.03120113621006301},
{0.6270862199317238,-0.6026867561040503,-0.49348915569495405},
{0.7897541079074626,-0.6092417405815198,-0.07150489896844824},
{0.6519055216631529,-0.49690420879647285,-0.5728048516776406},
{0.8223934044313446,-0.5607955024381056,-0.09579923169324271},
{0.8743763222097876,-0.47978700754375125,-0.07259803407185565},
{0.7066431878181755,-0.4310263429799514,-0.5611342947704193},
{0.5699027640351083,-0.08500041225299915,-0.8173039639338376},
{0.8104990476641784,-0.543299361623625,-0.2188997427929533},
{-0.9426982560098395,0.2503995367612855,0.22049959207613198},
{-0.8234666211445849,0.19101545377534093,0.5342432220250635},
{-0.7696626184495895,0.3432279244437359,0.5383437987414423},
{-0.841808115069344,0.10120097558210693,0.530205111201908},
{-0.9018812140099661,0.18109622780486181,0.3921918307292479},
{-0.9836402021966125,0.17910732026577197,-0.01930078883936013},
{-0.8546855986689927,0.0943984094002023,-0.5104913982924075},
{-0.3837111412147301,0.16700484905618956,-0.908226370735517},
{0.6076542507549624,0.451240286274916,-0.6535583490262802},
{0.7413938130944445,0.3191973363093427,-0.5902950740081612},
{0.2953067640788977,0.25290579287352943,-0.9213211031015526},
{0.38328790745727653,0.16389482919970683,-0.9089713224071599},
{0.8522961263229087,0.09259957913586925,-0.5147976602499513},
{0.9836390905942057,0.17840709003864,-0.02500099355922646},
{-0.912961085863055,-0.4068826569963604,-0.030798687233934384},
{-0.7709513663459812,-0.36952462039802836,-0.5187345618415624},
{-0.6318726468251655,-0.6008739887280297,-0.48957880659218395},
{-0.28722343120714006,-0.46903826335706367,-0.8351681316193685},
{-0.4158033243608674,-0.18990151826870788,-0.8894071108382768},
{-0.7666867786005036,-0.24559576473755534,-0.59318977053061},
{-0.35001970666424337,-0.09160515751555627,-0.9322524872925935},
{0.0008999922106011258,0.10289910941206205,-0.9946913909832664},
{0.6134915492121141,0.23829671748532485,-0.75288962901679},
{0.5012977667234237,-0.07409966988670598,-0.8620961593701649},
{0.012499992812506201,0.0066999961475033235,-0.999899425057996},
{0.11130749903882386,-0.2589174438558086,-0.9594646413104009},
{0.5927191984857635,0.0988032002874868,-0.7993258905849009},
{0.8256910743277296,0.2487973105156099,-0.5062945269857447},
{-0.013600923466049155,0.008900604327046873,-0.999867888334996},
{-0.504338227764765,-0.07240548818197302,-0.8604652214332815},
{-0.8381381738724633,0.23691079034767518,-0.4913223777873061},
{-0.605832691614083,0.09380506185771044,-0.790042631850653},
{-0.11350253453989474,-0.2570057390022286,-0.959721430818828},
{0.41300216413701013,-0.19040099770384197,-0.890604666780681},
{0.13540624440294427,-0.14950689466942518,-0.9794451681554183},
{0.19780703711052006,0.02010071509565952,-0.9800348653605139},
{0.5331225755534529,0.28291198016145525,-0.7973337638131082},
{0.8048626851469739,0.4062316385520637,-0.4326336948242805},
{0.9427659912151635,0.3334233387834258,-0.0046003220108091145},
{0.8238518136698937,0.3163198939837186,0.4703295799574545},
{0.28331608856089635,-0.46752654924892006,-0.8373475501307396},
{-0.7941926100721447,-0.60389438078893,-0.06759937099077937},
{-0.6518932007893735,-0.5110946693103985,-0.5601941572054104},
{-0.3119150377864663,-0.3831184705867112,-0.8694419168052381},
{-0.2947138489291494,-0.2143100706668365,-0.9312437601724599},
{0.20160135778971708,-0.08910060009456246,-0.9754065693853673},
{0.6705952086143515,0.41079706486545725,-0.6176955865808007},
{0.9068030015229026,0.3865012793213518,0.16830055707576588},
{0.8754853007252003,0.4781919712242042,-0.06969882976647225},
{0.7555077439940641,0.48620498362662345,0.4391045008442006},
{0.7112375187686987,0.24591297225143843,0.6585347386237177},
{0.5255095906375445,0.40350736407659227,0.7490136696242071},
{0.6569013860633869,0.2091004412023964,0.7244015284888378},
{0.6389827476987151,0.053198563658171584,0.7673792810391141},
{0.6258031790882247,-0.14060071425344262,0.7672038974056982},
{0.8514898034706548,0.10429875102993459,0.5138938461580382},
{-0.5245062678873521,0.4024048087661973,0.7503089662457202},
{-0.6539129443348509,0.20160399079049693,0.7292144349426108},
{-0.2725177278548142,-0.04780310969343163,0.9609625126447374},
{-0.3860942182823715,-0.37569437401887323,0.8424873838458896},
{-0.7383863362872694,-0.07939853074378277,0.6696876075454825},
{-0.706189075339506,0.2232965456291584,0.6718896059481932},
{-0.8235368870432745,0.2976133303996096,0.482921630544259},
{-0.9485569056357048,0.31641898254416134,0.010900653949846266},
{-0.8489591193267332,0.34462399872775623,-0.4006278986951223},
{-0.5893026489213604,0.2336010500390799,-0.77340347645644},
{-0.23940695607016438,0.013300386448342465,-0.9708282078233734},
{-0.14669669276034214,-0.145796713050156,-0.9783779427179193},
{0.3054030815326391,-0.37210375454582517,-0.8765088440188545},
{0.7477223946210834,-0.06400191688611653,0.6609197948442879},
{0.3999145711528547,-0.3606131391790933,0.8426307018089407},
{0.2759097866937041,-0.04040143306424663,0.9603340636533674},
{0.1395028975052721,0.2470051303498366,0.9589199169735154},
{0.3142053666734946,-0.10240174903681046,0.9438161205170089},
{0.38581906572021046,-0.3672181465330775,0.846341823014552},
{0.12860723564662194,-0.04540255441956949,0.9906557358595933},
{0.419518906045511,0.21490968512319505,0.8819397455102174},
{0.589813878483843,0.5521129913715324,0.5893138667184278},
{0.0569035932908511,0.7819493777524864,0.620739197814258},
{-0.30859749882740795,0.7614938281175345,0.569995380206165},
{-0.173703260440798,0.7746145396513652,0.6081114143583722},
{0.5197088741047887,0.6760115429956459,0.5224089202084695},
{0.5896091950270953,0.06810106204434394,0.8048125511496036},
{0.19131118246543222,-0.2721159056395405,0.9430551231829721},
{-0.11260374920424568,-0.5932197515804487,0.7971265407700198},
{-0.26520852791732497,-0.32871056985831343,0.9064291466978256},
{-0.3258077445421327,-0.06610157125302325,0.9431224182863271},
{-0.08149912185169306,-0.3782959238833802,0.9220900645330818},
{0.12539818863624763,-0.5616918864193006,0.8177881871349546},
{0.04920154962720864,-0.38661217654225327,0.9209290051157814},
{-0.07280191908388091,0.2738072176533873,0.959025280239585},
{0.03080127689340097,0.4259176567824504,0.9042374859419856},
{-0.13930167929186585,0.24520295593945088,0.9594115657761385},
{0.2690024519685246,-0.33390304354011285,0.9034082346035878},
{0.12600260261063567,-0.6013124202363113,0.789016297299933},
{-0.17049444623386942,-0.2868906546891327,0.9426692930479103},
{-0.5776109487193004,0.042300801819297795,0.8152154525553561},
{-0.562937475995207,0.40892722319140196,0.7182478153486547},
{-0.7699130077901508,0.43360732585765605,0.46820791043947085},
{-0.9080204760926064,0.4177094194536142,-0.03190071936933275},
{-0.9299145951241066,0.29260459246511844,0.22280349692832666},
{-0.7671290517272937,0.2956111950079364,-0.5693215606157586},
{-0.2261141664963104,-0.10650667285208783,-0.9682606634309054},
{0.27961433619453446,-0.16430842430887702,-0.9459485000229262},
{-0.6698430823433059,-0.3867248730100872,0.6338407667799154},
{-0.397709376109064,-0.5950140276210537,0.6984164653622587},
{0.15130202519116084,-0.6635088811258112,0.7327098073864082},
{0.11849979736551976,-0.20339965218689215,0.9718983380552629},
{0.4359153423104637,0.13080460374904485,0.8904313392824887},
{0.02350070056632598,0.4747141514397848,0.8798262280107914},
{-0.3029241228083871,0.5463435070657704,0.7808621825314911},
{-0.3156030518962678,0.5191050197698118,0.794307680992413},
{0.3261958426604777,-0.0688991218862873,0.9427879842437106},
{0.6707189380165761,-0.3898110064691537,0.6310178170395998},
{0.39659029753705466,-0.5963854096094287,0.6978829265030521},
{0.5692393101778933,-0.7285503117789798,0.3810263126805646},
{0.8513541563603839,-0.40032546551281767,0.3390215658477272},
{0.7379503483800859,-0.5933404820353774,0.32152193658246053},
{0.508414495103886,-0.6271178793856156,0.590116824470502},
{0.2587993141827261,-0.4434988247296717,0.858097726044039},
{0.04969932260284936,0.17059767476953924,0.9840865869912284},
{-0.2993009068831218,0.34680105080877593,0.8889026933792414},
{-0.4846056384194047,0.35690415260397346,0.7986092918731668},
{-0.5035055310386378,-0.6233068470633227,0.5983065724337976},
{-0.7394581052035143,-0.5885462468383394,0.3268256813369062},
{-0.8531933024588633,-0.39649688751164947,0.33889733966632535},
{-0.570316091695544,-0.7278205357461281,0.38081074472674586},
{-0.23509420147303012,-0.44058913300305,0.866378631034595},
{-0.5404946464270406,-0.5109949386201994,0.6683933795963626},
{-0.7457292145142291,-0.5440213124523812,0.384615067590415},
{-0.815327032615907,-0.5734190120225207,-0.08020265916324756},
{-0.5930205485180153,-0.7029243567509494,0.3927136077622675},
{0.08120293229082848,-0.3797137117096992,0.9215332771674686},
{-0.15129198627572482,-0.6635648519006675,0.7326611919644652},
{-0.12539818863624763,-0.5616918864193006,0.8177881871349546},
{-0.04920154962720864,-0.38661217654225327,0.9209290051157814},
{-0.11849979736551976,-0.20339965218689215,0.9718983380552629},
{-0.7323934780651167,-0.3456969215826199,0.5865947763967742},
{-0.4359153423104637,0.13080460374904485,0.8904313392824887},
{0.07280191908388091,0.2738072176533873,0.959025280239585},
{-0.02350070056632598,0.4747141514397848,0.8798262280107914},
{0.3029241228083871,0.5463435070657704,0.7808621825314911},
{0.1749080223404212,0.6301289015248679,0.7565346992597406},
{0.023401734600855307,0.5484406519277372,0.835861956384396},
{0.3156030518962678,0.5191050197698118,0.794307680992413},
{0.13840201445598072,0.6232090708740403,0.7697112032280952},
{-0.604296866728869,0.4761975309222033,0.6387966878477603},
{-0.5784995805879561,0.20919984833016494,0.7883994284106216},
{0.7601870579255072,-0.5339909088821637,0.37009369920840596},
{0.5587444247415538,-0.5051401627652745,0.6577522966753534},
{0.44190160189621036,-0.03170011491312484,0.8965032498301709},
{0.6493003278967484,-0.09870004984353777,0.7541003808207886},
{0.15341128688357933,0.24631812229090996,0.9569704069028491},
{0.5924180512530367,-0.7033214305304873,0.39291197221019264},
{0.6803027926486959,0.3181013058085405,-0.6603027105481902},
{0.3806189857485255,0.5138256302616722,-0.7688383506134168},
{0.15840159035995088,0.6750067771020634,-0.7206072349329583},
{-0.07620122037231647,0.5288084689354455,-0.8453135378047127},
{-0.1324983769048243,0.23919706985384132,-0.9618882169415132},
{-0.07979698333206661,0.199892443209024,-0.9765630817305295},
{-0.03350120589760982,-0.060002159816614595,-0.997635910550912},
{-0.04700138562127247,-0.3230095224610853,-0.9452278657282286},
{-0.02790047919484529,-0.33100568507146205,-0.9432161998773505},
{0.23510749299520456,-0.4309137334395306,-0.8712277664713832},
{0.5663134727577772,-0.5772137320780312,-0.5883139961564549},
{0.8646166137678519,-0.4704090389965273,-0.17650339154525313},
{0.9457799591349966,-0.3244931240635509,-0.014299696992631056},
{0.9623015685528351,-0.2648004316250553,0.06210010122324749},
{-0.22611583431571633,-0.08050563760466681,-0.9707679804080754},
{0.0,-0.11450264446911139,-0.9934229433678187},
{-0.1382089804202637,0.20401325619199562,-0.9691629734101126},
{-0.11930201204539986,0.41770704468871356,-0.9007151906897876},
{0.0,0.44092225390774625,-0.8975453002544846},
{0.0,0.21490756810326847,-0.9766343927857236},
{0.1382089804202637,0.20401325619199562,-0.9691629734101126},
{0.22611583431571633,-0.08050563760466681,-0.9707679804080754},
{0.0,-0.3710975563306373,-0.9285938852293986},
{-0.2569035941064225,-0.3265045678308562,-0.9096127255710467},
{-0.19810280713666584,-0.30410430918859205,-0.9318132038866493},
{-0.12630911100477699,-0.00620044725439127,-0.9919715534888227},
{0.03959944521565877,-0.04749933453898463,-0.9980860169128539},
{0.3731338317125979,-0.1559141365960708,-0.9145829244201843},
{0.7327974022378135,-0.2597990790138973,-0.628897770561355},
{0.9555510899048191,-0.2469132015672421,-0.16110861390231956},
{-0.8646166137678519,-0.4704090389965273,-0.17650339154525313},
{-0.9457799591349966,-0.3244931240635509,-0.014299696992631056},
{-0.9023865139343231,-0.4306935633327937,-0.014199787785757303},
{-0.6784315545854228,-0.575126749767212,-0.45712126120429947},
{-0.6597957476301097,-0.7293952990624463,0.18069883539975876},
{-0.9623015685528351,-0.2648004316250553,0.06210010122324749},
{-0.5663134727577772,-0.5772137320780312,-0.5883139961564549},
{-0.9555510899048191,-0.2469132015672421,-0.16110861390231956},
{-0.7327974022378135,-0.2597990790138973,-0.628897770561355},
{-0.3731338317125979,-0.1559141365960708,-0.9145829244201843},
{-0.23510749299520456,-0.4309137334395306,-0.8712277664713832},
{-0.09159871304712247,-0.37549472433618436,-0.9222870419580901},
{-0.26111369054970274,-0.5047264635022404,-0.822843142796995},
{0.025100364334432492,-0.1100015966847639,-0.9936144224180129},
{0.07979698333206661,0.199892443209024,-0.9765630817305295},
{0.047400924090022785,0.44950876325876044,-0.8920173900485301},
{-0.037202020496601235,0.6905375041102999,-0.7223392313090075},
{-0.00010000272711155301,0.7644208460407111,-0.6447175816881823},
{-0.15410637243025269,0.9032373496366272,-0.4005165617022467},
{-0.5593376614726632,0.7353495127495963,-0.3826257630599694},
{-0.904447955101903,0.25681361661893926,-0.3406180600483284},
{0.00010000272711155301,0.7644208460407111,-0.6447175816881823},
{0.037202020496601235,0.6905375041102999,-0.7223392313090075},
{-0.047400924090022785,0.44950876325876044,-0.8920173900485301},
{0.011300348790648217,0.5853180661209205,0.8107250234140274},
{0.3467049423141793,0.17860254599743994,0.9208131262846735},
{-0.10170194201712439,0.6664127252724847,0.7386141039709743},
{-0.1749080223404212,0.6301289015248679,0.7565346992597406},
{-0.023401734600855307,0.5484406519277372,0.835861956384396},
{0.18480835167812276,0.4237191483009774,0.8867400726893477},
{0.5517023888765157,-0.01990008616755966,0.8338036103774494},
{0.5784995805879561,0.20919984833016494,0.7883994284106216},
{0.6931176781918263,-0.39231000599430593,0.6047154234635657},
{0.9001546365437978,-0.21141283209127748,0.38082311476044683},
{0.9586402829110496,-0.2726114553740373,0.08180343745266416},
{0.604296866728869,0.4761975309222033,0.6387966878477603},
{0.941014886973269,0.30600484103487813,-0.14440228446221046},
{0.5481353805399923,0.20311311035882582,0.8113523704289286},
{0.8303145763003316,-0.16660292474001592,0.5318093359948408},
{0.5439852690783673,-0.21539416720492705,0.8109780390120513},
{0.11590084202267595,0.1921013956217088,0.9745070798196525},
{-0.047301942494153607,0.6043248171081822,0.7953326610063501},
{0.04110134855736961,0.5841191652642236,0.8106265970949832},
{0.362703447512653,0.19670186966015674,0.910908658227945},
{0.613517577530398,-0.1046029969187932,0.7827224253187326},
{0.6024464022089161,-0.4252327526879666,0.6754520253185622},
{0.47292645861086124,-0.8461473390371107,0.24571374684011124},
{0.722035478084845,-0.6813334781429431,0.12020590646232461},
{-0.011300348790648217,0.5853180661209205,0.8107250234140274},
{-0.3467049423141793,0.17860254599743994,0.9208131262846735},
{-0.11590084202267595,0.1921013956217088,0.9745070798196525},
{-0.5439852690783673,-0.21539416720492705,0.8109780390120513},
{-0.8303145763003316,-0.16660292474001592,0.5318093359948408},
{-0.5481353805399923,0.20311311035882582,0.8113523704289286},
{-0.8983432922064023,-0.3043146652770881,0.3168152676956343},
{-0.9225120388606612,-0.366904788138728,0.11980156342060404},
{-0.3921969408757917,-0.8273935463555075,0.4019968644366861},
{0.7323934780651167,-0.3456969215826199,0.5865947763967742},
{0.8983432922064023,-0.3043146652770881,0.3168152676956343},
{0.618205869892602,-0.50490479409378,0.6024057198694653},
{0.23650143556807085,-0.2381014452801593,0.9420057179920623},
{-0.28311420844308505,0.15210763371315167,0.9469475237539994},
{-0.2941159635771464,0.5008271831330668,0.8140441834471174},
{-0.011200317981541306,0.4363123870845065,0.899725543570778},
{0.31649384583700096,-0.07299858055640149,0.9457816094554045},
{0.42862356208482955,-0.18010990091338733,0.8853486689540354},
{0.41610385730063587,-0.4200038934541385,0.8065074763589589},
{0.3457083057418194,-0.8889213565921413,0.3005072197726836},
{0.03350120589760982,-0.060002159816614595,-0.997635910550912},
{0.2569035941064225,-0.3265045678308562,-0.9096127255710467},
{0.0,-0.3361970280314083,-0.9417916745983946},
{0.0,0.02109952262870073,-0.9997773802926535},
{0.0,0.15470939888148175,-0.9879600203944138},
{-0.11510080513294786,0.14300100029549562,-0.9830068761571482},
{0.0861972658660894,0.09039713264842786,-0.9921685289133862},
{0.4382171477724951,-0.024500958741273688,-0.8985351603687514},
{0.8006067331309386,-0.0981008250314078,-0.5911049712137119},
{0.9863739156866951,-0.08769768086549387,-0.13919631900201535},
{0.04700138562127247,-0.3230095224610853,-0.9452278657282286},
{0.19810280713666584,-0.30410430918859205,-0.9318132038866493},
{0.12630911100477699,-0.00620044725439127,-0.9919715534888227},
{0.11510080513294786,0.14300100029549562,-0.9830068761571482},
{-0.03959944521565877,-0.04749933453898463,-0.9980860169128539},
{-0.0861972658660894,0.09039713264842786,-0.9921685289133862},
{-0.4382171477724951,-0.024500958741273688,-0.8985351603687514},
{-0.8006067331309386,-0.0981008250314078,-0.5911049712137119},
{-0.9863739156866951,-0.08769768086549387,-0.13919631900201535},
{0.02790047919484529,-0.33100568507146205,-0.9432161998773505},
{0.023700048111146496,-0.5136010426111747,0.8577017411363018},
{0.0,-0.33142825214837096,0.9434804256993761},
{0.18210352009506547,-0.211704092279656,0.9602185612041838},
{0.3066098729968683,-0.722023249522958,0.620219971404624},
{0.48200388496696933,-0.44320357223518836,0.7558060918216503},
{0.5030885875648352,-0.20739529529108888,0.8389809679326112},
{0.2297046366348862,-0.22150447111287458,0.9477191299037077},
{-0.33491238863838785,-0.24240896687353006,0.9105336812638165},
{-0.12480796986738195,-0.1835117185149406,0.9750622645889215},
{0.0,-0.219904809370772,0.9755213348848935},
{0.12480796986738195,-0.1835117185149406,0.9750622645889215},
{-0.18210352009506547,-0.211704092279656,0.9602185612041838},
{-0.023700048111146496,-0.5136010426111747,0.8577017411363018},
{0.09070391214409798,-0.47382043631613696,0.8759377800111954},
{0.0,-0.38061399733713286,0.9247340077184623},
{-0.09070391214409798,-0.47382043631613696,0.8759377800111954},
{0.26271338033319924,-0.5878299389412048,0.7651389695201017},
{0.6033054207235579,-0.6567059005290244,0.4525040657672965},
{0.6530011035727976,-0.486900822863086,0.5801009803714853},
{0.7052692015664368,-0.11179511801379219,0.7000694286355627},
{0.5516073116033733,-0.068200904008974,0.8313110191005878},
{0.22180878269262952,-0.06910273617700946,0.9726385123843619},
{-0.16820584189033502,-0.0953033099414324,0.9811340753781671},
{0.0,-0.09199624478992993,0.9957593539327417},
{0.16820584189033502,-0.0953033099414324,0.9811340753781671},
{0.33491238863838785,-0.24240896687353006,0.9105336812638165},
{-0.2297046366348862,-0.22150447111287458,0.9477191299037077},
{-0.5030885875648352,-0.20739529529108888,0.8389809679326112},
{-0.48200388496696933,-0.44320357223518836,0.7558060918216503},
{-0.3066098729968683,-0.722023249522958,0.620219971404624},
{-0.26271338033319924,-0.5878299389412048,0.7651389695201017},
{0.17510688271129013,-0.21070828205179226,0.961737801847217},
{0.0,-0.1964045949392485,0.9805229396025111},
{-0.17510688271129013,-0.21070828205179226,0.961737801847217},
{0.9061376825190576,-0.3721154747437825,0.2011083632651832},
{0.9091447219288346,-0.362017808093981,0.20591012896837205},
{0.9340944841883563,-0.20139881074353383,0.29479825922141895},
{0.9429522315707001,-0.02950163414077384,0.33161836885019},
{0.6784210245933333,0.04110127374821049,0.7335227322217128},
{0.5407278725365533,-0.04210217021229683,0.8401433063028638},
{0.580039908118565,0.0736050642026317,0.8112558163203103},
{0.20531239816350597,0.0783047285738067,0.9755589109035562},
{-0.4383141599676603,0.058301883472768865,0.8969289757586003},
{-0.15630172401752393,-0.044400489740102765,0.9867108834810676},
{0.0,0.05119940788227174,0.9986884502348591},
{0.15630172401752393,-0.044400489740102765,0.9867108834810676},
{0.4383141599676603,0.058301883472768865,0.8969289757586003},
{-0.20531239816350597,0.0783047285738067,0.9755589109035562},
{-0.22180878269262952,-0.06910273617700946,0.9726385123843619},
{-0.5516073116033733,-0.068200904008974,0.8313110191005878},
{-0.7052692015664368,-0.11179511801379219,0.7000694286355627},
{-0.6530011035727976,-0.486900822863086,0.5801009803714853},
{-0.6033054207235579,-0.6567059005290244,0.4525040657672965},
{-0.618205869892602,-0.50490479409378,0.6024057198694653},
{-0.23650143556807085,-0.2381014452801593,0.9420057179920623},
{0.28311420844308505,0.15210763371315167,0.9469475237539994},
{0.0,0.116707790505033,0.9931662960629671},
{-0.580039908118565,0.0736050642026317,0.8112558163203103},
{-0.5407278725365533,-0.04210217021229683,0.8401433063028638},
{-0.6784210245933333,0.04110127374821049,0.7335227322217128},
{-0.9429522315707001,-0.02950163414077384,0.33161836885019},
{-0.9340944841883563,-0.20139881074353383,0.29479825922141895},
{-0.9091447219288346,-0.362017808093981,0.20591012896837205},
{-0.9061376825190576,-0.3721154747437825,0.2011083632651832},
{0.2941159635771464,0.5008271831330668,0.8140441834471174},
{0.0,0.4588161299645783,0.8885312368647076},
{0.2440151660138663,-0.17331077159919275,0.9541593028435649},
{-0.2440151660138663,-0.17331077159919275,0.9541593028435649},
{0.047301942494153607,0.6043248171081822,0.7953326610063501},
{0.011200317981541306,0.4363123870845065,0.899725543570778},
{0.0,0.42491549907549836,0.9052330189765618},
{0.9225120388606612,-0.366904788138728,0.11980156342060404},
{0.9654082977199785,-0.26070224074538884,0.0046000395375097375},
{-0.5967298521575499,-0.14550727918371628,0.7891394776898318},
{-0.12759921080132178,0.23699853416859923,0.9630940432817633},
{-0.032199482880457375,0.1741972024153936,0.9841841941287623},
{0.3007038355018829,0.3766048036249055,0.876211176144828},
{0.48450483780495834,0.4063040569662633,0.7747077354953587},
{0.5545165220659161,0.45461354541238136,0.6970207680431804},
{-0.40822389608515647,-0.05450319043763113,0.9112533417755869},
{-0.6300863556277017,-0.24129477481822634,0.738084016963667},
{-0.7865935460264322,-0.48809599518878916,0.37819689690719127},
{-0.795954313795716,-0.4236289073047685,0.43242950783423495},
{0.6671401330218392,-0.2012121042782102,0.717243147059306},
{0.8495339395588416,-0.41481657225309887,0.3259130204852578},
{0.8356107084198431,-0.37100475445639275,0.405105191456293},
{-0.5435119954421106,-0.2600057383899701,-0.7981176146501352},
{-0.75564566504735,-0.6383385759657536,-0.1467088658846562},
{-0.8379598073257495,-0.5439388222991708,-0.04420315489175096},
{-0.6825533333883879,-0.5008391345947321,-0.5322415883213187},
{0.11930201204539986,0.41770704468871356,-0.9007151906897876},
{0.03839980761744575,0.5788970997327955,-0.8144959193856658},
{-0.26989786916473435,0.7976937022330812,-0.539295742276922},
{-0.14060627821048627,0.9747435232699927,-0.17350774729387886},
{0.041901943876265675,0.9619446256462996,-0.2700125261716404},
{0.3921969408757917,-0.8273935463555075,0.4019968644366861},
{0.5317093741188993,-0.8212144781388756,0.20710365126955813},
{-0.5317093741188993,-0.8212144781388756,0.20710365126955813},
{-0.9654082977199785,-0.26070224074538884,0.0046000395375097375},
{-0.8514898034706548,0.10429875102993459,0.5138938461580382},
{-0.6258031790882247,-0.14060071425344262,0.7672038974056982},
{-0.419518906045511,0.21490968512319505,0.8819397455102174},
{-0.12860723564662194,-0.04540255441956949,0.9906557358595933},
{-0.38581906572021046,-0.3672181465330775,0.846341823014552},
{-0.6382957553473404,0.05399964090358199,0.7678948935159372},
{-0.3139220553687771,-0.10280722297518409,0.9438663136573808},
{-0.9663116972738937,0.23030278783212016,0.11490139088975512},
{-0.6228985735638998,0.7680982410570419,0.14839966016516734},
{-0.589813878483843,0.5521129913715324,0.5893138667184278},
{-0.04110134855736961,0.5841191652642236,0.8106265970949832},
{-0.362703447512653,0.19670186966015674,0.910908658227945},
{-0.18480835167812276,0.4237191483009774,0.8867400726893477},
{-0.5517023888765157,-0.01990008616755966,0.8338036103774494},
{-0.613517577530398,-0.1046029969187932,0.7827224253187326},
{-0.31649384583700096,-0.07299858055640149,0.9457816094554045},
{0.0,-0.13329679425064694,0.9910761649048476},
{0.10170194201712439,0.6664127252724847,0.7386141039709743},
{-0.6931176781918263,-0.39231000599430593,0.6047154234635657},
{-0.6024464022089161,-0.4252327526879666,0.6754520253185622},
{-0.42862356208482955,-0.18010990091338733,0.8853486689540354},
{0.0,-0.1979043094132567,0.9802213445521689},
{-0.13840201445598072,0.6232090708740403,0.7697112032280952},
{-0.03080127689340097,0.4259176567824504,0.9042374859419856},
{0.30859749882740795,0.7614938281175345,0.569995380206165},
{0.173703260440798,0.7746145396513652,0.6081114143583722},
{-0.5197088741047887,0.6760115429956459,0.5224089202084695},
{-0.03839980761744575,0.5788970997327955,-0.8144959193856658},
{0.26989786916473435,0.7976937022330812,-0.539295742276922},
{0.07020006423308817,0.7178006567879015,-0.6927006338213699},
{0.0,0.6113478765268896,-0.7913619739828689},
{-0.07020006423308817,0.7178006567879015,-0.6927006338213699},
{0.0,0.6558171662389924,-0.7549197602833415},
{-0.4957319212061428,0.8403541121434775,-0.21921411565137483},
{0.17960610311907776,0.9592325952773908,0.2182074148139352},
{-0.13940846444188568,0.9789594393268428,0.1490090473589739},
{-0.01990034915468891,0.9449165787068114,0.32670573210235504},
{-0.5492998159845925,0.7992997322346347,0.24369991836054106},
{-0.0569035932908511,0.7819493777524864,0.620739197814258},
{0.5785069565879797,0.665308000376807,-0.47190567469985756},
{0.8486939488337171,0.5160963202463549,-0.115599175780815},
{0.8292109954106992,0.2910038587367504,-0.47720632779786015},
{0.7022378340824942,0.34541860992892837,-0.6225335398979673},
{0.2594974439627654,0.6131939600692399,-0.746092651023581},
{0.0,0.5363124184578257,-0.8440195434987973},
{-0.2594974439627654,0.6131939600692399,-0.746092651023581},
{-0.5785069565879797,0.665308000376807,-0.47190567469985756},
{-0.8486939488337171,0.5160963202463549,-0.115599175780815},
{-0.941014886973269,0.30600484103487813,-0.14440228446221046},
{-0.7022378340824942,0.34541860992892837,-0.6225335398979673},
{-0.8292109954106992,0.2910038587367504,-0.47720632779786015},
{-0.753923922385592,0.10620336988639059,-0.6483205715381075},
{-0.8518871110455141,0.19839699827612395,-0.4846926666554298},
{-0.366000927813528,-0.30330076886842366,-0.8798022303014807},
{-0.7526189624736422,0.05890148404158587,-0.6558165235054672},
{-0.3933934067817531,-0.03799936313601072,-0.918584604651038},
{-0.21821525377937742,-0.4536317099648286,-0.8640603999330068},
{-0.03040051726920204,-0.9334158822063547,-0.3575060830177543},
{-0.9952259359258397,0.032000833952599346,0.09220240282592687},
{-0.8359680756522133,-0.5113416402452168,0.19921622283756538},
{-0.9710255140305761,-0.1754046088166458,-0.1623042646005793},
{-0.9647116393161429,-0.17770214398930093,-0.19430234427192553},
{-0.07240270936007734,-0.19140716259003868,-0.9788366287519847},
{-0.1260033920569719,-0.1850049804011095,-0.9746262372914666},
{-0.885705535676897,-0.37950237189723657,-0.26740167126566816},
{-0.07860314693998288,-0.1559062418313401,-0.9846394208283352},
{-0.8120302852342423,-0.44751669044621106,-0.3746139714886048},
{-0.74980704821938,0.2160020304286291,-0.6254058788428918},
{0.22781909545776222,0.2167181649942804,-0.9492795672015273},
{-0.46789297931851764,0.8817867688887986,0.059399108723060375},
{0.4722175172337087,0.8556317402481177,-0.21190786086790103},
{0.40719947064103224,0.25299967110064137,-0.8775988591222248},
{0.591420942586372,0.7311258896261356,-0.3401120435806986},
{0.32151772576084525,0.8957493840248495,0.30701692630973404},
{0.2445051371068965,0.8642181574142329,0.43970923838814885},
{0.6362176711912294,0.6900191655484883,-0.34510958555185994},
{-0.3925263570671476,0.7589509614732696,-0.5195348853411036},
{-0.7057785129002572,0.6805792800792222,0.1966940117419674},
{-0.7464099049251579,0.6407085022582378,-0.17990238732051972},
{-0.7603451278225442,0.6411380526726727,0.10400617294955226},
{-0.8883688645816605,0.4378339400133412,-0.13821071381873856},
{-0.5769034008555721,0.7068041666228434,0.4094024134343408},
{-0.5773918299634087,0.8022886476959521,0.15149785632049947},
{-0.38870263735634175,0.6955047190155279,0.60430410021723},
{-0.19819347557817418,0.8953705248874732,0.3987868721522496},
{-0.25179523482027116,0.6393878996984963,0.7264862513777879},
{-0.045801370855544865,0.8389251094042922,0.5423162317677288},
{0.0,0.6189339277931535,0.7854430552411419},
{-0.010600024380084111,0.8648019890468622,0.5020011546039834},
{0.0,0.9021494526776599,0.4314236491355088},
{0.010600024380084111,0.8648019890468622,0.5020011546039834},
{0.045801370855544865,0.8389251094042922,0.5423162317677288},
{0.25179523482027116,0.6393878996984963,0.7264862513777879},
{0.19819347557817418,0.8953705248874732,0.3987868721522496},
{0.38870263735634175,0.6955047190155279,0.60430410021723},
{0.5773918299634087,0.8022886476959521,0.15149785632049947},
{0.5769034008555721,0.7068041666228434,0.4094024134343408},
{0.8883688645816605,0.4378339400133412,-0.13821071381873856},
{0.7603451278225442,0.6411380526726727,0.10400617294955226},
{0.7057785129002572,0.6805792800792222,0.1966940117419674},
{0.7464099049251579,0.6407085022582378,-0.17990238732051972},
{0.3925263570671476,0.7589509614732696,-0.5195348853411036},
{-0.2445051371068965,0.8642181574142329,0.43970923838814885},
{-0.6362176711912294,0.6900191655484883,-0.34510958555185994},
{-0.591420942586372,0.7311258896261356,-0.3401120435806986},
{-0.32151772576084525,0.8957493840248495,0.30701692630973404},
{-0.4722175172337087,0.8556317402481177,-0.21190786086790103},
{-0.40719947064103224,0.25299967110064137,-0.8775988591222248},
{-0.22781909545776222,0.2167181649942804,-0.9492795672015273},
{0.46789297931851764,0.8817867688887986,0.059399108723060375},
{0.74980704821938,0.2160020304286291,-0.6254058788428918},
{0.07860314693998288,-0.1559062418313401,-0.9846394208283352},
{0.8120302852342423,-0.44751669044621106,-0.3746139714886048},
{0.885705535676897,-0.37950237189723657,-0.26740167126566816},
{0.1260033920569719,-0.1850049804011095,-0.9746262372914666},
{0.9647116393161429,-0.17770214398930093,-0.19430234427192553},
{0.07240270936007734,-0.19140716259003868,-0.9788366287519847},
{0.21821525377937742,-0.4536317099648286,-0.8640603999330068},
{0.9710255140305761,-0.1754046088166458,-0.1623042646005793},
{0.8359680756522133,-0.5113416402452168,0.19921622283756538},
{0.03040051726920204,-0.9334158822063547,-0.3575060830177543},
{0.9952259359258397,0.032000833952599346,0.09220240282592687},
{0.366000927813528,-0.30330076886842366,-0.8798022303014807},
{0.3933934067817531,-0.03799936313601072,-0.918584604651038},
{0.7526189624736422,0.05890148404158587,-0.6558165235054672},
{0.753923922385592,0.10620336988639059,-0.6483205715381075},
{0.8518871110455141,0.19839699827612395,-0.4846926666554298},
{0.4312939856473049,0.3177955683716984,-0.8443882250883011},
{0.0,0.2933057356497415,-0.9560186951283767},
{-0.4312939856473049,0.3177955683716984,-0.8443882250883011},
{-0.9001546365437978,-0.21141283209127748,0.38082311476044683},
{-0.9586402829110496,-0.2726114553740373,0.08180343745266416},
{-0.47292645861086124,-0.8461473390371107,0.24571374684011124},
{-0.3457083057418194,-0.8889213565921413,0.3005072197726836},
{-0.41610385730063587,-0.4200038934541385,0.8065074763589589},
{0.0,-0.43999912000263997,0.8979982040053879},
{-0.722035478084845,-0.6813334781429431,0.12020590646232461},
{0.7263134768715962,-0.6872127513509032,0.014400267199436852},
{0.6872033776129015,-0.7003034419998762,0.19320094958500084},
{0.8306403493349772,-0.5360260380972163,-0.15070732078591506},
{0.8421346503430472,-0.2169089249013264,-0.49372031454027127},
{0.8980018229455509,0.34450069933712946,-0.27370055561269185},
{0.926540912317245,0.30601351232496166,-0.21880966175392683},
{0.47002739399480625,-0.7570441218171667,0.4538264497762619},
{0.9220046976259016,-0.1666008488334872,0.3495017807161091},
{0.9975988976538274,-0.052299942208595795,0.04539994983308316},
{0.9989263070706996,0.03660096389907659,-0.02840074794354577},
{0.9648624044940812,0.1444093399761042,-0.21951419753985368},
{0.7897889074926908,0.581691830195617,0.19459726690057944},
{0.8411652012417203,0.40913171302816287,0.3536274107229489},
{0.9863808841236965,0.14939710471216572,0.06879866669475904},
{0.956798847058084,0.03689995553558038,0.28839965247862814},
{0.850929859652672,0.013000456194011911,0.5251184267288965},
{0.8519261800937776,0.07180220651570986,0.5187159403857758},
{0.7847940002728018,0.01799986239157802,0.6194952639768102},
{0.7017016104070439,-0.10560024235283431,0.7046016170625669},
{0.5220386949421568,-0.021001556693075275,0.8526632017388561},
{0.7999539067103167,-0.19311301335887254,0.5681382852883247},
{0.3477081208179937,0.46701090716710686,0.8130189882802095},
{-0.7263134768715962,-0.6872127513509032,0.014400267199436852},
{-0.6872033776129015,-0.7003034419998762,0.19320094958500084},
{-0.9220046976259016,-0.1666008488334872,0.3495017807161091},
{-0.47002739399480625,-0.7570441218171667,0.4538264497762619},
{-0.8306403493349772,-0.5360260380972163,-0.15070732078591506},
{-0.9975988976538274,-0.052299942208595795,0.04539994983308316},
{-0.8070324514273209,0.4313173436190874,0.40331621767117537},
{-0.609699484804153,-0.25819978182127656,0.7493993667578026},
{-0.4722289650518844,-0.7543462692474299,0.4560279713334589},
{-0.2864138369867053,-0.8949432357521041,0.34211652804871473},
{0.8684112329719482,-0.30860399181845144,0.3881050201709041},
{0.6849981744822976,-0.13029965275188812,0.7167980897356363},
{0.8817822190408279,0.175496461149541,0.43779117203002316},
{0.932602480725898,0.3466009219596786,0.10060026759706771},
{0.9808093177327778,0.1570014915212542,-0.11560109821564958},
{0.4114146857093142,0.3173113266299597,0.854430499441026},
{0.8842235914001321,-0.1928051441098682,0.4254113501262341},
{0.9108610615219119,0.15869321601002023,0.38098371329437747},
{0.796191663916918,0.4058957502937415,0.44869530218477904},
{0.788408621295411,-0.17610192568508612,0.5894064451947175},
{0.4298290789208168,-0.67654576986955,0.5979404520399171},
{0.2736962298604004,-0.5804920037777216,0.7668894361707748},
{0.6313012026299365,-0.6159011732928527,0.47130089782906553},
{0.9482613118172374,0.3004194242458322,0.10270664071253983},
{0.8169509548201277,0.4886304768332898,0.3063191057184541},
{0.9524135196058668,0.19520277092300004,0.2341033231202577},
{0.951701703547574,0.15280027351273437,-0.2663004766782799},
{0.8351121843756557,0.47840698000875786,-0.2715039612716927},
{0.527014255928437,0.8491229690869748,0.03530095490374539},
{0.12510039344135607,0.9329029339843411,0.33770106207151035},
{-0.011700076401748357,0.8946058417952205,0.4467029169795719},
{-0.0006999814437378865,0.8617771545904438,0.5072865520117569},
{0.0,0.8479983040050879,0.5299989400031799},
{0.0006999814437378865,0.8617771545904438,0.5072865520117569},
{0.011700076401748357,0.8946058417952205,0.4467029169795719},
{-0.12510039344135607,0.9329029339843411,0.33770106207151035},
{-0.527014255928437,0.8491229690869748,0.03530095490374539},
{-0.8351121843756557,0.47840698000875786,-0.2715039612716927},
{-0.951701703547574,0.15280027351273437,-0.2663004766782799},
{-0.9808093177327778,0.1570014915212542,-0.11560109821564958},
{-0.8817822190408279,0.175496461149541,0.43779117203002316},
{-0.4114146857093142,0.3173113266299597,0.854430499441026},
{-0.3477081208179937,0.46701090716710686,0.8130189882802095},
{-0.8684112329719482,-0.30860399181845144,0.3881050201709041},
{-0.6849981744822976,-0.13029965275188812,0.7167980897356363},
{-0.788408621295411,-0.17610192568508612,0.5894064451947175},
{-0.796191663916918,0.4058957502937415,0.44869530218477904},
{-0.9108610615219119,0.15869321601002023,0.38098371329437747},
{-0.8842235914001321,-0.1928051441098682,0.4254113501262341},
{-0.7895050962718446,-0.48800315007050055,0.3722024025742629},
{-0.7459303525235789,-0.5645229709070388,0.35341438072373343},
{-0.7999539067103167,-0.19311301335887254,0.5681382852883247},
{-0.5220386949421568,-0.021001556693075275,0.8526632017388561},
{-0.7017016104070439,-0.10560024235283431,0.7046016170625669},
{-0.7847940002728018,0.01799986239157802,0.6194952639768102},
{-0.8519261800937776,0.07180220651570986,0.5187159403857758},
{-0.850929859652672,0.013000456194011911,0.5251184267288965},
{-0.956798847058084,0.03689995553558038,0.28839965247862814},
{-0.9863808841236965,0.14939710471216572,0.06879866669475904},
{-0.926540912317245,0.30601351232496166,-0.21880966175392683},
{-0.4298290789208168,-0.67654576986955,0.5979404520399171},
{-0.7171401717318608,-0.06340355164942126,0.6940388776766301},
{-0.39780848534548957,0.3655077963644456,0.8415179497693049},
{-0.5283088281142773,0.7987133466115337,0.28800481260062816},
{-0.8509089430999881,0.5241055083778398,0.03560037416189867},
{-0.9881059978216102,-0.15360093236048913,-0.007300044311403455},
{-0.7928055100174419,-0.5701039622363064,0.21550149774061395},
{-0.6452066456626757,-0.6744069464273225,0.3590036977571304},
{-0.2586983262272439,0.02259985377941907,0.965693751981637},
{-0.6573303496428807,-0.1281059147866317,0.7426342882166488},
{-0.2736962298604004,-0.5804920037777216,0.7668894361707748},
{-0.7641684366745712,0.6448733640557851,0.013599438286802105},
{-0.9031179135214737,0.3224063949942677,0.2836056253733695},
{0.39780848534548957,0.3655077963644456,0.8415179497693049},
{0.7171401717318608,-0.06340355164942126,0.6940388776766301},
{0.2586983262272439,0.02259985377941907,0.965693751981637},
{0.6452066456626757,-0.6744069464273225,0.3590036977571304},
{0.7459303525235789,-0.5645229709070388,0.35341438072373343},
{0.6573303496428807,-0.1281059147866317,0.7426342882166488},
{0.7641684366745712,0.6448733640557851,0.013599438286802105},
{0.5283088281142773,0.7987133466115337,0.28800481260062816},
{0.5342036726628744,0.19310132757619064,0.82300565818335},
{0.7928055100174419,-0.5701039622363064,0.21550149774061395},
{0.7895050962718446,-0.48800315007050055,0.3722024025742629},
{0.9881059978216102,-0.15360093236048913,-0.007300044311403455},
{0.8509089430999881,0.5241055083778398,0.03560037416189867},
{-0.6313012026299365,-0.6159011732928527,0.47130089782906553},
{-0.9482613118172374,0.3004194242458322,0.10270664071253983},
{-0.6525105870701635,0.6197100548772113,-0.43610707589471004},
{-0.8169509548201277,0.4886304768332898,0.3063191057184541},
{-0.9601454831688321,0.01650078166054133,0.27901321716915345},
{-0.9524135196058668,0.19520277092300004,0.2341033231202577},
{-0.9800116769086961,0.06760080546839577,-0.1871022293363439},
{-0.9987975529489929,-0.04149989832537365,0.026099936055234998},
{-0.9428256027768698,0.23810646586887219,0.2332063328039521},
{-0.9884333997288749,0.13550457877707664,-0.06810230121563778},
{-0.8936628356430387,0.2819198224796023,0.34912454780996516},
{-0.8411652012417203,0.40913171302816287,0.3536274107229489},
{-0.8980018229455509,0.34450069933712946,-0.27370055561269185},
{0.3143872990096748,-0.1239949907035613,0.9411619778241284},
{0.2536118325360769,0.2738127750330357,0.9277432848727071},
{0.43040709101523716,-0.07850129331946125,0.8992148146861089},
{0.8391324037234167,-0.08640333652926137,0.5370207374561731},
{0.5318007870657474,0.1236001829284061,0.8378012399467527},
{0.28139959759886307,0.1530997810674696,0.9472986453639056},
{0.26301054035861154,0.3702148366568745,0.890935704963829},
{0.3717175566348096,0.17530828000560164,0.9116430579184622},
{0.5586147224850192,0.23370615940699782,0.7958209741381638},
{0.33190982135692304,0.5055149584089322,0.7964235665220053},
{0.25811720924802994,0.47433162474366763,0.8416561150838513},
{0.7194535365295539,0.3649271552399697,0.590943973777194},
{0.808626001787138,-0.17330557273028815,0.5622180784129718},
{0.9987975529489929,-0.04149989832537365,0.026099936055234998},
{0.871135712940593,0.10620435393673629,0.4794196542115949},
{0.5527172395195551,0.3007093792718115,0.777224242002168},
{0.25220268849498906,0.34780370760728474,0.9030096261339221},
{0.0,0.34761398826833756,0.9376377313014767},
{-0.3116025785220059,0.16080133063651655,0.9365077496336924},
{-0.1583958651299105,0.4045894383305668,0.9006764881471614},
{0.624087537096325,-0.016299674498750354,0.7811843999032994},
{0.6602856950653728,-0.5619878246656665,0.49818920684774914},
{-0.10400284711691027,-0.7611208359680808,0.6402175261946726},
{0.32249923567771716,-0.9292977975668296,0.17999957340151654},
{0.8004196065183955,-0.06210152119539276,0.5962146044556064},
{0.7150163561862238,0.40050916175186385,0.573013107824764},
{0.5910408364221313,0.40092770105183156,0.6999483611029607},
{0.4028870554468594,0.6390794667065968,0.6551789494385264},
{0.5920343567506123,-0.2637153038431359,0.7615441936918771},
{0.3804110739275454,0.8029233734396062,0.45891335916233067},
{0.14560312686072435,0.8940191992684586,0.4237090992506107},
{0.2955037189377044,0.8613108396651262,0.41330520147869115},
{0.8923674381062645,0.291089378342373,0.3448874152878201},
{0.995568228628642,-0.09100623687112648,0.0237016243279747},
{0.9891240805188639,0.049501205121508206,-0.13850337190563408},
{0.9800116769086961,0.06760080546839577,-0.1871022293363439},
{0.9428256027768698,0.23810646586887219,0.2332063328039521},
{0.8283837431285602,0.2989941322977299,0.4736907039111528},
{0.5957004348614762,0.06340004628205068,0.8007005845116401},
{0.2652136615075654,0.0837043117201479,0.9605494791780415},
{0.0,0.08060373808503256,0.9967462251780638},
{-0.25220268849498906,0.34780370760728474,0.9030096261339221},
{-0.28139959759886307,0.1530997810674696,0.9472986453639056},
{0.3116025785220059,0.16080133063651655,0.9365077496336924},
{0.0,0.20980909227402478,0.9777423713837657},
{0.0,0.3641203002726261,0.9313519243172115},
{0.0,-0.3636186886627681,0.9315478781335768},
{0.0,-0.9329119320199164,0.36010460576736186},
{0.3311032216500201,-0.908708841780046,0.25420247340209934},
{0.3623060831702051,-0.8263138739264159,-0.4312072400303407},
{-0.3302266173380794,-0.8650697274301595,-0.3776304382400327},
{0.20590570984450207,-0.9762270711520298,0.06770187739909077},
{0.4580121901566637,-0.20860555211065512,0.8641229989396793},
{0.43031775742864803,0.5193214302409874,0.7383304678353958},
{-0.3143872990096748,-0.1239949907035613,0.9411619778241284},
{-0.43040709101523716,-0.07850129331946125,0.8992148146861089},
{-0.2536118325360769,0.2738127750330357,0.9277432848727071},
{-0.33190982135692304,0.5055149584089322,0.7964235665220053},
{-0.5586147224850192,0.23370615940699782,0.7958209741381638},
{-0.3717175566348096,0.17530828000560164,0.9116430579184622},
{-0.26301054035861154,0.3702148366568745,0.890935704963829},
{-0.5318007870657474,0.1236001829284061,0.8378012399467527},
{-0.8391324037234167,-0.08640333652926137,0.5370207374561731},
{-0.808626001787138,-0.17330557273028815,0.5622180784129718},
{-0.7194535365295539,0.3649271552399697,0.590943973777194},
{-0.25811720924802994,0.47433162474366763,0.8416561150838513},
{-0.14560312686072435,0.8940191992684586,0.4237090992506107},
{-0.3804110739275454,0.8029233734396062,0.45891335916233067},
{-0.5920343567506123,-0.2637153038431359,0.7615441936918771},
{-0.4028870554468594,0.6390794667065968,0.6551789494385264},
{-0.5910408364221313,0.40092770105183156,0.6999483611029607},
{-0.7150163561862238,0.40050916175186385,0.573013107824764},
{-0.8004196065183955,-0.06210152119539276,0.5962146044556064},
{-0.32249923567771716,-0.9292977975668296,0.17999957340151654},
{0.10400284711691027,-0.7611208359680808,0.6402175261946726},
{-0.6602856950653728,-0.5619878246656665,0.49818920684774914},
{-0.624087537096325,-0.016299674498750354,0.7811843999032994},
{0.1583958651299105,0.4045894383305668,0.9006764881471614},
{0.0,0.994096490845581,0.10849961699702801},
{-0.7258134494478286,0.5419100416861096,0.4237078513792298},
{-0.42523338851029985,0.6728528311141337,0.6053475307273858},
{-0.38789394308336783,0.6908892118491848,0.6100904735116337},
{-0.3854192136267109,-0.6883343143208747,0.6145306351157599},
{-0.3713222707210498,-0.7144428499949312,0.5930355683748518},
{-0.5923300615134521,-0.6820346141350233,0.4289217683321283},
{-0.9078432325241237,0.2894137822124712,0.30341444894009595},
{-0.753251203990946,0.6441437871621991,0.1330090415969143},
{-0.6885089954287883,0.7149093403515479,-0.12190159265471211},
{-0.37709313131116917,0.8208850477150326,-0.4288921877999482},
{-0.25139758533778916,0.831792010676106,-0.49489524655398515},
{0.0,0.836257147584837,-0.5483374719215093},
{0.25139758533778916,0.831792010676106,-0.49489524655398515},
{0.37709313131116917,0.8208850477150326,-0.4288921877999482},
{0.6885089954287883,0.7149093403515479,-0.12190159265471211},
{0.753251203990946,0.6441437871621991,0.1330090415969143},
{0.7258134494478286,0.5419100416861096,0.4237078513792298},
{0.42523338851029985,0.6728528311141337,0.6053475307273858},
{0.38789394308336783,0.6908892118491848,0.6100904735116337},
{0.0,0.667239074664352,0.7448436193195584},
{0.0,-0.632480579981933,0.7745762170023799},
{0.0,-0.9816876602636653,-0.19049760546014896},
{-0.4321781301790694,-0.8208584615085565,-0.37338110552722015},
{-0.07309991154916054,-0.8194990084067998,-0.5683993122372484},
{0.7783614190309985,-0.5633444524478498,-0.27712186716367687},
{0.8936628356430387,0.2819198224796023,0.34912454780996516},
{0.43221360629849276,-0.8208258400041714,-0.37341175518708286},
{0.5923300615134521,-0.6820346141350233,0.4289217683321283},
{0.3713222707210498,-0.7144428499949312,0.5930355683748518},
{0.9078432325241237,0.2894137822124712,0.30341444894009595},
{0.8540653811613977,0.5094793486731438,0.10489574813702215},
{0.6443277904569165,0.7415319829641528,-0.18700806583182272},
{0.3675146365618574,0.803732009264666,-0.46791863523072946},
{0.1865974315040329,0.7973890240156262,-0.573892100429606},
{0.0,0.795004547439017,-0.6066034697817707},
{-0.1865974315040329,0.7973890240156262,-0.573892100429606},
{-0.3675146365618574,0.803732009264666,-0.46791863523072946},
{-0.6443277904569165,0.7415319829641528,-0.18700806583182272},
{-0.8540653811613977,0.5094793486731438,0.10489574813702215},
{0.3854192136267109,-0.6883343143208747,0.6145306351157599},
{-0.4067179081837547,-0.8116357371082746,-0.4193184629983977},
{-0.20231543624508497,-0.9236704741273379,-0.32542482923455585},
{0.625541330881142,-0.7519496829568837,0.2080137439221064},
{0.4067179081837547,-0.8116357371082746,-0.4193184629983977},
{0.20231543624508497,-0.9236704741273379,-0.32542482923455585},
{0.15090588695347734,-0.9286362268058254,-0.3389132212626472},
{0.2752142440818132,-0.8023415262603152,-0.5296274115760474},
{0.09620656151125022,-0.790053883512346,-0.6054412925042713},
{0.0,-0.774447196250253,-0.6326385541682723},
{-0.09620656151125022,-0.790053883512346,-0.6054412925042713},
{-0.2752142440818132,-0.8023415262603152,-0.5296274115760474},
{-0.15090588695347734,-0.9286362268058254,-0.3389132212626472},
{0.41733214624664466,-0.7571583223660069,0.5025387095349603},
{0.07309991154916054,-0.8194990084067998,-0.5683993122372484},
{-0.625541330881142,-0.7519496829568837,0.2080137439221064},
{-0.41733214624664466,-0.7571583223660069,0.5025387095349603},
{-0.18680229955046126,-0.8033098888055972,0.5655069614335432},
{0.056701191588061965,-0.8992188972836918,-0.4338091165943789},
{0.0,-0.8836589552738673,-0.4681312324170408},
{-0.056701191588061965,-0.8992188972836918,-0.4338091165943789},
{0.18680229955046126,-0.8033098888055972,0.5655069614335432},
{-0.7783614190309985,-0.5633444524478498,-0.27712186716367687},
{-0.02079941835239855,0.977972651377201,0.2076941919131336},
{-0.1202105910196238,0.8474746658072313,0.5170455537200125},
{0.14910253103694673,0.9710164831447033,0.1868031710107421},
{0.09019898707106275,0.9708890969766609,0.22189750810497585},
{0.05250024412670278,0.9689045054164253,0.2418011243778425},
{0.0,0.9644631744069532,0.26421730680041167},
{-0.05250024412670278,0.9689045054164253,0.2418011243778425},
{-0.09019898707106275,0.9708890969766609,0.22189750810497585},
{-0.14910253103694673,0.9710164831447033,0.1868031710107421},
{0.02079941835239855,0.977972651377201,0.2076941919131336},
{0.1202105910196238,0.8474746658072313,0.5170455537200125},
{0.8269053997098903,0.548203579781064,0.12530081821701444},
{0.8070324514273209,0.4313173436190874,0.40331621767117537},
{0.5356896693243396,0.3757927529066396,0.7561854171048452},
{0.24961395256182856,0.36542042574556155,0.8967501252491654},
{0.0,0.35090425123075564,0.9364113446921618},
{-0.24961395256182856,0.36542042574556155,0.8967501252491654},
{-0.5356896693243396,0.3757927529066396,0.7561854171048452},
{-0.8269053997098903,0.548203579781064,0.12530081821701444},
{-0.7897889074926908,0.581691830195617,0.19459726690057944},
{-0.9989263070706996,0.03660096389907659,-0.02840074794354577},
{-0.9648624044940812,0.1444093399761042,-0.21951419753985368},
{-0.8421346503430472,-0.2169089249013264,-0.49372031454027127},
{0.0,-0.818088702273032,0.5750920580335175},
{-0.5342036726628744,0.19310132757619064,0.82300565818335},
{0.9031179135214737,0.3224063949942677,0.2836056253733695},
{0.6525105870701635,0.6197100548772113,-0.43610707589471004},
{0.9601454831688321,0.01650078166054133,0.27901321716915345},
{0.9917470198408423,0.11900564219124758,-0.04770226161783622},
{0.8632856134651263,0.4337927709037088,0.2579957005374755},
{0.4625160264579799,0.6054209782003482,0.6477224439715321},
{0.2753074857123062,0.5063137668584838,0.8172222205742703},
{0.16350042673667067,0.41220107584621196,0.8963023393521585},
{0.0,0.3647952120942617,0.9310877795530895},
{-0.16350042673667067,0.41220107584621196,0.8963023393521585},
{-0.2753074857123062,0.5063137668584838,0.8172222205742703},
{-0.4625160264579799,0.6054209782003482,0.6477224439715321},
{-0.8632856134651263,0.4337927709037088,0.2579957005374755},
{-0.9917470198408423,0.11900564219124758,-0.04770226161783622},
{-0.9891240805188639,0.049501205121508206,-0.13850337190563408},
{-0.995568228628642,-0.09100623687112648,0.0237016243279747},
{-0.871135712940593,0.10620435393673629,0.4794196542115949},
{-0.8283837431285602,0.2989941322977299,0.4736907039111528},
{-0.8950537495915429,0.3599216139418953,0.26331581258933323},
{-0.9956246917985387,0.056001388851665494,0.07480185510901034},
{-0.8876593952772734,0.02290153239280032,0.4599307749977671},
{-0.5957004348614762,0.06340004628205068,0.8007005845116401},
{-0.2652136615075654,0.0837043117201479,0.9605494791780415},
{0.8876593952772734,0.02290153239280032,0.4599307749977671},
{0.9956246917985387,0.056001388851665494,0.07480185510901034},
{0.9884333997288749,0.13550457877707664,-0.06810230121563778},
{-0.932602480725898,0.3466009219596786,0.10060026759706771},
{-0.4891228596910339,0.20640964678026869,-0.8474396060155024},
{0.3420850751537495,0.2497891019392184,-0.9058604781694874},
{0.4891228596910339,0.20640964678026869,-0.8474396060155024},
{-0.3420850751537495,0.2497891019392184,-0.9058604781694874},
{-0.7496359646481268,0.24651182668858487,-0.6142294683656342},
{0.7496359646481268,0.24651182668858487,-0.6142294683656342},
{0.8950537495915429,0.3599216139418953,0.26331581258933323},
{0.43722855851597964,0.061304004201805935,-0.8972586063598741},
{0.42641544504713447,0.3114112795208201,-0.8492307596951842},
{0.0,0.07650530773984306,-0.9970691740735103},
{0.0,0.07389746905502655,-0.9972658442297426},
{0.46891037944612485,0.0706015627828885,-0.8804194883010628},
{-0.46891037944612485,0.0706015627828885,-0.8804194883010628},
{-0.43722855851597964,0.061304004201805935,-0.8972586063598741},
{-0.42641544504713447,0.3114112795208201,-0.8492307596951842},
{-0.7817538295132106,0.43763013406035683,-0.44423058855029823},
{-0.40470381030431113,0.7168067487673097,-0.5678053459124978},
{-0.3210000385200069,0.9426001131120203,-0.09200001104000198},
{-0.34061268294937885,0.9374349060386016,0.07210268479345336},
{-0.2558128920155479,0.9246465987395448,0.28211421750424576},
{-0.1737985227188353,0.91599221409927,0.3615969264391878},
{-0.09549734425578386,0.8963750721558602,0.43288796155318154},
{0.0,0.8711024303791712,0.4911013701747342},
{0.09549734425578386,0.8963750721558602,0.43288796155318154},
{0.1737985227188353,0.91599221409927,0.3615969264391878},
{0.2558128920155479,0.9246465987395448,0.28211421750424576},
{0.34061268294937885,0.9374349060386016,0.07210268479345336},
{0.3210000385200069,0.9426001131120203,-0.09200001104000198},
{0.40470381030431113,0.7168067487673097,-0.5678053459124978},
{0.7817538295132106,0.43763013406035683,-0.44423058855029823},
{0.0,0.3247946928980767,-0.9457845460067764},
{0.0,0.724195003071718,-0.6895952418092471},
{-0.2157157845014491,0.9546698557491112,-0.20511500881431252},
{0.0,0.9988854912936076,0.047199314434936704},
{0.2157157845014491,0.9546698557491112,-0.20511500881431252},
{0.8499133819915501,-0.1975031097109438,0.4885076916141572},
{0.4961280171402142,-0.7412418591097092,0.45212553224972957},
{0.321291373442433,0.9119755137861779,0.25509315084084866},
{0.034998982769348506,0.9867713199083743,0.15829539921108193},
{0.003000129893435665,0.969641981558407,0.24451058631500672},
{0.33170269011972536,0.7192058327829559,0.6105049512152317},
{0.9401724157459772,0.11419664951945394,0.32099058227447214},
{-0.8499133819915501,-0.1975031097109438,0.4885076916141572},
{-0.4961280171402142,-0.7412418591097092,0.45212553224972957},
{-0.8871403746771983,-0.18310833344988728,0.42361927935211496},
{-0.4454013250709131,-0.8867026379442718,0.12400036890164622},
{-0.3579947285664325,-0.913686546064663,0.19239716697257433},
{-0.5145022277994696,-0.7270031479304458,0.45470196886378783},
{-0.4811316450689785,-0.13900914293200584,0.8655569295514465},
{-0.3063073223640627,-0.7889188593307512,0.5327127346501345},
{0.0,-0.8229725913542599,0.5680810803746721},
{0.0,-0.1719024393129209,0.9851139788665408},
{0.0,0.7667027256330344,0.6420022823221705},
{-0.43031775742864803,0.5193214302409874,0.7383304678353958},
{0.3063073223640627,-0.7889188593307512,0.5327127346501345},
{0.4811316450689785,-0.13900914293200584,0.8655569295514465},
{0.5145022277994696,-0.7270031479304458,0.45470196886378783},
{0.3579947285664325,-0.913686546064663,0.19239716697257433},
{0.4454013250709131,-0.8867026379442718,0.12400036890164622},
{0.8871403746771983,-0.18310833344988728,0.42361927935211496},
{0.6124230612245638,-0.7057265746345112,0.356213413468631},
{0.4722289650518844,-0.7543462692474299,0.4560279713334589},
{0.5506028383649477,0.09180047323265929,0.829704277136573},
{0.0,-0.4191976839391944,0.907894983894071},
{0.0,0.4378284948056931,0.899058512632065},
{0.41139663478929106,-0.13639888426169008,0.9011926282744509},
{0.609699484804153,-0.25819978182127656,0.7493993667578026},
{0.2864138369867053,-0.8949432357521041,0.34211652804871473},
{0.0,-0.9566932553363247,0.29109794776670234},
{0.0,-0.9997535232375881,0.02220118857244619},
{-0.6124230612245638,-0.7057265746345112,0.356213413468631},
{-0.5506028383649477,0.09180047323265929,0.829704277136573},
{-0.41139663478929106,-0.13639888426169008,0.9011926282744509},
{0.0,0.055802338166954825,0.9984418355893852},
{0.0,0.9676215201419145,-0.2524056135632692},
{-0.3311032216500201,-0.908708841780046,0.25420247340209934},
{0.0,-0.26321048519852097,0.9647384311208708},
{0.3302266173380794,-0.8650697274301595,-0.3776304382400327},
{-0.3623060831702051,-0.8263138739264159,-0.4312072400303407},
{-0.20590570984450207,-0.9762270711520298,0.06770187739909077},
{-0.4580121901566637,-0.20860555211065512,0.8641229989396793},
{0.0,0.5626136013482209,0.8267199861972524},
{0.2762936605146884,-0.29219329570174435,0.9155789922810305},
{0.6133871895423182,-0.04349909153095996,0.7885835306049431},
{0.49753558004153864,-0.7292521506860099,0.46973359185027275},
{0.17031164801192494,-0.8972613658032826,0.4073278581048563},
{-0.5527172395195551,0.3007093792718115,0.777224242002168},
{0.4451132044790692,0.06750200247660565,0.8929264890572026},
{0.4736077553904923,-0.594509735176621,0.6498106407363639},
{0.9290310440910161,-0.2241074886768533,0.2944098378691013},
{0.8450170145888848,-0.16480331834822273,0.5087102429838648},
{-0.4451132044790692,0.06750200247660565,0.8929264890572026},
{-0.9401724157459772,0.11419664951945394,0.32099058227447214},
{-0.33170269011972536,0.7192058327829559,0.6105049512152317},
{0.0694007307935429,0.7683080903267869,0.6363067003448322},
{-0.003000129893435665,0.969641981558407,0.24451058631500672},
{-0.2955037189377044,0.8613108396651262,0.41330520147869115},
{-0.8923674381062645,0.291089378342373,0.3448874152878201},
{-0.9290310440910161,-0.2241074886768533,0.2944098378691013},
{-0.4736077553904923,-0.594509735176621,0.6498106407363639},
{-0.027701029250863075,-0.7032261288522353,0.7104263963831455},
{0.10199836599926493,0.0009999839803849504,0.9947840636869486},
{-0.10199836599926493,0.0009999839803849504,0.9947840636869486},
{-0.0694007307935429,0.7683080903267869,0.6363067003448322},
{0.027701029250863075,-0.7032261288522353,0.7104263963831455},
{-0.8450170145888848,-0.16480331834822273,0.5087102429838648},
{-0.6133871895423182,-0.04349909153095996,0.7885835306049431},
{-0.49753558004153864,-0.7292521506860099,0.46973359185027275},
{-0.17031164801192494,-0.8972613658032826,0.4073278581048563},
{-0.321291373442433,0.9119755137861779,0.25509315084084866},
{0.0,-0.3569142018986459,0.9341371700575096},
{-0.2762936605146884,-0.29219329570174435,0.9155789922810305},
{-0.034998982769348506,0.9867713199083743,0.15829539921108193},
{-0.9600057600518405,-0.05360032160289443,0.2748016488148393},
{-0.28659044236811787,-0.1032965551173293,0.9524682357139995},
{-0.9046070016852896,0.342002647110733,0.25440196907886103},
{-0.286600669213344,0.07760018119663464,-0.9549022296993096},
{-0.3220053630439826,0.4138068920111801,-0.851514182086805},
{0.012500048312780095,0.8371032354102573,-0.5469021137807547},
{-0.4526987369722858,0.7929977875392592,0.40769886252176035},
{-0.26340707257484924,0.4007107592283298,0.8775235618239566},
{0.0,-0.10660021053562371,0.9943019637483176},
{0.0004999984975067724,0.3823988508931796,0.9239972233925154},
{0.28659044236811787,-0.1032965551173293,0.9524682357139995},
{0.26340707257484924,0.4007107592283298,0.8775235618239566},
{0.9600057600518405,-0.05360032160289443,0.2748016488148393},
{0.9046070016852896,0.342002647110733,0.25440196907886103},
{0.3220053630439826,0.4138068920111801,-0.851514182086805},
{0.286600669213344,0.07760018119663464,-0.9549022296993096},
{-0.27679924710707177,0.09319974649703429,-0.9563973986026136},
{-0.2429037820413298,0.5949092628093334,-0.7662119300126261},
{-0.0027000329136018268,0.0977011909847772,-0.9952121317098288},
{-0.03280056351852192,0.5972102601604051,-0.8014137684068129},
{0.27430194892227067,0.0933006629035649,-0.9571068002679739},
{0.24061032120109663,0.5972256185423728,-0.7651328210763052},
{0.40411611243061035,0.8344332695176968,-0.3747149401825035},
{0.035801434055162194,0.7831313689552378,0.6208248676381198},
{-0.1486116694464454,0.8560672210373974,-0.4950388719784016},
{-0.32840359275495723,0.7784085158357451,0.5350058529960479},
{0.16490223773854926,0.777710553603819,0.6066082317295572},
{-0.32680161930603546,0.8383041538073732,-0.4364021623780719},
{-0.19130681638330377,0.7789277536903049,0.5972212793732828},
{0.32840359275495723,0.7784085158357451,0.5350058529960479},
{-0.40411611243061035,0.8344332695176968,-0.3747149401825035},
{-0.035801434055162194,0.7831313689552378,0.6208248676381198},
{0.4526987369722858,0.7929977875392592,0.40769886252176035},
{-0.012500048312780095,0.8371032354102573,-0.5469021137807547},
{0.14760614570981762,0.8516354585804924,-0.5029209395492362},
{0.30080085126761363,0.852302412019239,-0.42790121096214057},
{0.9943292436530901,0.10630312642092275,0.0030000882338924576},
{0.6354493954013314,0.3537274963069735,-0.6863533523196943},
{0.586203666715403,0.6189038712558221,-0.5228032701446822},
{-0.7011400432513378,0.5064289229817108,-0.5019286659646933},
{-0.6886289746736769,0.213308975163949,-0.6930291598153617},
{-0.9104318929878269,0.40131405827769656,0.10030351369362812},
{-0.9946081657665616,-0.10010082183112086,-0.027100222493740014},
{-0.6675039049092656,0.24740144730270008,0.7023041084910521},
{-0.7089923960973274,-0.11729874197773839,0.695392541954981},
{0.6809040377729161,0.01570009310182814,0.732204341984622},
{0.5819132823222553,0.3495079776106345,0.734316760971356},
{0.8278234235951607,0.54791550348851,0.12040340686259644},
{0.35809501893292967,0.9329870222407802,-0.03609949785947713},
{-0.4887189602198498,0.8724338467276385,-0.0036001396701278066},
{-0.4619960707401275,0.73989370723078,0.488995841108057},
{0.3931268337878416,0.7948542546287878,0.4622315506912755},
{-0.4755026033838803,0.8772048027094423,-0.0664003635429856},
{-0.5054183621826531,0.7683279138601751,0.39271426756851585},
{0.3631124658649334,0.8298284885010238,0.42371454637006967},
{0.36380780558020404,0.9304199623744415,-0.04430095048708916},
{-0.6354493954013314,0.3537274963069735,-0.6863533523196943},
{-0.9943292436530901,0.10630312642092275,0.0030000882338924576},
{-0.586203666715403,0.6189038712558221,-0.5228032701446822},
{0.7011400432513378,0.5064289229817108,-0.5019286659646933},
{0.4887189602198498,0.8724338467276385,-0.0036001396701278066},
{-0.35809501893292967,0.9329870222407802,-0.03609949785947713},
{-0.8278234235951607,0.54791550348851,0.12040340686259644},
{-0.6809040377729161,0.01570009310182814,0.732204341984622},
{-0.5819132823222553,0.3495079776106345,0.734316760971356},
{0.6675039049092656,0.24740144730270008,0.7023041084910521},
{0.7089923960973274,-0.11729874197773839,0.695392541954981},
{0.9946081657665616,-0.10010082183112086,-0.027100222493740014},
{0.9104227563011942,0.40131003086958394,0.10040250959209128},
{0.6886289746736769,0.213308975163949,-0.6930291598153617},
{0.5054183621826531,0.7683279138601751,0.39271426756851585},
{-0.3631124658649334,0.8298284885010238,0.42371454637006967},
{0.4755026033838803,0.8772048027094423,-0.0664003635429856},
{-0.3931268337878416,0.7948542546287878,0.4622315506912755},
{0.4619960707401275,0.73989370723078,0.488995841108057},
{-0.36380780558020404,0.9304199623744415,-0.04430095048708916},
{-0.5059090811495107,0.5140092265484256,-0.6927124342997946},
{-0.5076305577411626,0.5004301242980255,-0.7013422185655581},
{-0.8910613561420885,0.43773014094656804,-0.12000826345347992},
{-0.13800053406310026,0.9901038317092432,0.02550009868557287},
{-0.7190633235045244,0.4152365673422511,0.5572490735142156},
{-0.9151440835522826,0.38931875393607646,-0.10460503894609197},
{-0.4476250095079413,0.54553047963937,-0.7085395872126373},
{0.18600657265836937,0.5462193010000073,-0.8167288596241412},
{0.18949366817486513,0.5266824012015908,-0.8286723103773653},
{0.15770184985354824,0.5841068516135544,-0.7962093395903305},
{0.681735161397697,0.5980308442362077,-0.4214217353865183},
{0.8059947691109227,0.5626963481125511,0.1836988077986061},
{0.4905138081580522,0.5041141910142184,0.7108200098649204},
{-0.1250994833402007,0.44649815596642384,0.8859963408426685},
{-0.754728646269414,0.25600971703321845,0.6040229261252498},
{-0.8818856915207317,0.4327929779908977,-0.1869969659988398},
{0.5059090811495107,0.5140092265484256,-0.6927124342997946},
{0.8910613561420885,0.43773014094656804,-0.12000826345347992},
{0.5076305577411626,0.5004301242980255,-0.7013422185655581},
{-0.18949366817486513,0.5266824012015908,-0.8286723103773653},
{-0.18600657265836937,0.5462193010000073,-0.8167288596241412},
{0.4476250095079413,0.54553047963937,-0.7085395872126373},
{0.9151440835522826,0.38931875393607646,-0.10460503894609197},
{0.7190633235045244,0.4152365673422511,0.5572490735142156},
{0.13800053406310026,0.9901038317092432,0.02550009868557287},
{-0.15770184985354824,0.5841068516135544,-0.7962093395903305},
{-0.7665038516915321,0.4593023079998965,-0.44890225573950265},
{-0.7397050965856733,0.44780308537388736,-0.5023034608827682},
{0.8818856915207317,0.4327929779908977,-0.1869969659988398},
{0.754728646269414,0.25600971703321845,0.6040229261252498},
{0.1250994833402007,0.44649815596642384,0.8859963408426685},
{-0.4905138081580522,0.5041141910142184,0.7108200098649204},
{-0.8059947691109227,0.5626963481125511,0.1836988077986061},
{-0.681735161397697,0.5980308442362077,-0.4214217353865183},
{-0.917267648540544,0.33298825571132795,0.21849229391268815},
{-0.9520925261030051,0.2744978452003728,0.1347989418324599},
{0.7665038516915321,0.4593023079998965,-0.44890225573950265},
{0.917267648540544,0.33298825571132795,0.21849229391268815},
{0.5505921651292349,0.21769690219512253,0.8058885322877778},
{-0.13609835934416709,0.18489777107080452,0.9732882670806601},
{-0.8098055836287488,0.23310160724112292,0.5384037123063946},
{0.7397050965856733,0.44780308537388736,-0.5023034608827682},
{0.9520925261030051,0.2744978452003728,0.1347989418324599},
{0.6051953944805719,0.1036992108520081,0.7892939934955642},
{-0.16660348454831936,0.07690160841396014,0.9830205600900236},
{-0.5505921651292349,0.21769690219512253,0.8058885322877778},
{-0.6051953944805719,0.1036992108520081,0.7892939934955642},
{0.13609835934416709,0.18489777107080452,0.9732882670806601},
{0.16660348454831936,0.07690160841396014,0.9830205600900236},
{0.8098055836287488,0.23310160724112292,0.5384037123063946},
{-0.8988414824916476,0.21851008447310302,-0.3799175335987727},
{-0.8850324945645678,0.26690979977320134,-0.38141400387223295},
{-0.9270496309305234,0.1323070832493077,0.35081878158622176},
{-0.21340980747305882,0.9753448230012852,0.05620258284904361},
{-0.43261922602561637,0.1400062220147626,0.8906395809024824},
{-0.9241387638134393,0.136305717463231,0.3569149711124515},
{-0.8591172985009596,0.3014060688722957,-0.4136083280875299},
{-0.29750526737738875,0.36950654217124423,-0.8803155861254297},
{-0.3226078620493984,0.35330861023574844,-0.8781214000792831},
{-0.34432141229280583,0.34452142473096603,-0.8733543112265679},
{0.39360534913304235,0.42810581799760017,-0.8135110556903709},
{0.8620434437740511,0.42892161604952495,-0.2700136076786471},
{0.8270230535889327,0.3530098402864489,0.4375121958224402},
{0.29799719883949627,0.2341977985510404,0.9253913013626506},
{-0.42011171917986206,0.03920109352975623,0.9066252906652296},
{-0.9332070504058989,0.1603012110802246,0.3216024297155348},
{0.8988414824916476,0.21851008447310302,-0.3799175335987727},
{0.9270496309305234,0.1323070832493077,0.35081878158622176},
{0.8850324945645678,0.26690979977320134,-0.38141400387223295},
{0.3226078620493984,0.35330861023574844,-0.8781214000792831},
{0.29750526737738875,0.36950654217124423,-0.8803155861254297},
{0.8591172985009596,0.3014060688722957,-0.4136083280875299},
{0.9241387638134393,0.136305717463231,0.3569149711124515},
{0.43261922602561637,0.1400062220147626,0.8906395809024824},
{0.21340980747305882,0.9753448230012852,0.05620258284904361},
{0.34432141229280583,0.34452142473096603,-0.8733543112265679},
{-0.4265916282214435,0.34879315500149904,-0.8344836234195842},
{-0.4211155373443808,0.3376124564413749,-0.8418310599299448},
{0.9332070504058989,0.1603012110802246,0.3216024297155348},
{0.42011171917986206,0.03920109352975623,0.9066252906652296},
{-0.29799719883949627,0.2341977985510404,0.9253913013626506},
{-0.8270230535889327,0.3530098402864489,0.4375121958224402},
{-0.8620434437740511,0.42892161604952495,-0.2700136076786471},
{-0.39360534913304235,0.42810581799760017,-0.8135110556903709},
{-0.9205167857766343,0.2598047375825851,-0.29180532111854635},
{-0.9178223538356448,0.22260542162106617,-0.32870800578097237},
{0.4265916282214435,0.34879315500149904,-0.8344836234195842},
{0.9205167857766343,0.2598047375825851,-0.29180532111854635},
{0.8888552840736429,0.13310827892686977,0.4384272688320039},
{0.3358106974201522,0.038801236033061064,0.9411299801730352},
{-0.4366980195789718,0.023699892521231124,0.8992959217022426},
{0.4211155373443808,0.3376124564413749,-0.8418310599299448},
{0.9178223538356448,0.22260542162106617,-0.32870800578097237},
{0.910503232292212,0.07630027086644237,0.4064014427276825},
{0.34800006090001595,-0.01330000232750061,0.937400164045043},
{-0.8888552840736429,0.13310827892686977,0.4384272688320039},
{-0.910503232292212,0.07630027086644237,0.4064014427276825},
{-0.3358106974201522,0.038801236033061064,0.9411299801730352},
{-0.34800006090001595,-0.01330000232750061,0.937400164045043},
{0.4366980195789718,0.023699892521231124,0.8992959217022426},
{0.5864978006373714,-0.6305976352633017,0.5082980938857219},
{0.09240529451302804,-0.9517545323381903,-0.29261676595792213},
{0.8772491053930501,-0.4714263888306929,-0.09050506616287167},
{0.9105721141559994,-0.41148739839138343,-0.03919879955514515},
{0.651331518694803,-0.3352162215054475,-0.6807329414640755},
{0.6214684616292938,-0.3462381419634077,-0.702777418710822},
{-0.0004999892653457084,-0.3212931019111521,-0.9469796685647716},
{-0.5980849673232671,-0.3864902856887523,-0.7020823533818188},
{-0.846804449969077,-0.5113026869026795,-0.14660077038907263},
{-0.6393947665752532,-0.6423947420205547,0.42249654187995694},
{-0.059200417660419904,-0.7018049512513967,0.7099050083975015},
{0.6291177885569608,-0.4792135499546902,0.6120173050339532},
{0.9102451128657181,-0.40722018233236695,-0.0750037172763446},
{0.6636091412788822,-0.3555048971136868,-0.6582090668923452},
{0.08120089768088581,-0.30210333977088183,-0.9498105002131201},
{0.0023000474619690714,-0.28400586052139837,-0.9588197854504112},
{-0.6657047997489093,-0.26780193085888226,-0.6965050218193111},
{-0.9500836539513495,-0.30659472508313207,-0.05779900557666351},
{-0.7061779358150877,-0.3957876338085694,0.5870816569201897},
{-0.0523015863311705,-0.47611444076998616,0.8778266248853053},
{0.700693438036679,-0.43799589818762014,0.5631947257060905},
{-0.5864978006373714,-0.6305976352633017,0.5082980938857219},
{-0.8772491053930501,-0.4714263888306929,-0.09050506616287167},
{-0.09240529451302804,-0.9517545323381903,-0.29261676595792213},
{0.059200417660419904,-0.7018049512513967,0.7099050083975015},
{0.6393947665752532,-0.6423947420205547,0.42249654187995694},
{0.846804449969077,-0.5113026869026795,-0.14660077038907263},
{0.5980849673232671,-0.3864902856887523,-0.7020823533818188},
{0.0004999892653457084,-0.3212931019111521,-0.9469796685647716},
{-0.6214684616292938,-0.3462381419634077,-0.702777418710822},
{-0.651331518694803,-0.3352162215054475,-0.6807329414640755},
{-0.9105721141559994,-0.41148739839138343,-0.03919879955514515},
{-0.6291177885569608,-0.4792135499546902,0.6120173050339532},
{0.0523015863311705,-0.47611444076998616,0.8778266248853053},
{0.7061779358150877,-0.3957876338085694,0.5870816569201897},
{0.9500836539513495,-0.30659472508313207,-0.05779900557666351},
{0.6657047997489093,-0.26780193085888226,-0.6965050218193111},
{-0.0023000474619690714,-0.28400586052139837,-0.9588197854504112},
{-0.08120089768088581,-0.30210333977088183,-0.9498105002131201},
{-0.6635531726461715,-0.3555284896393579,-0.6582527479061192},
{-0.9102451128657181,-0.40722018233236695,-0.0750037172763446},
{-0.700693438036679,-0.43799589818762014,0.5631947257060905},
{-0.042302729883241894,-0.40472611781910156,0.9134589474078758},
{0.6997488651694418,-0.30682142608830176,0.6451450520520321},
{0.966812061055693,-0.23850297534317622,-0.09160114273138341},
{0.601648299255912,-0.2517202076507863,-0.7580608557778944},
{0.042302729883241894,-0.40472611781910156,0.9134589474078758},
{-0.6997488651694418,-0.30682142608830176,0.6451450520520321},
{-0.966812061055693,-0.23850297534317622,-0.09160114273138341},
{-0.601648299255912,-0.2517202076507863,-0.7580608557778944},
{-0.46211489651378757,-0.8154262856899857,0.3486112376643721},
{0.004200060796320043,-0.7965115295878367,-0.6046087517750234},
{0.03020094696553839,-0.8245258534134571,0.5650177164082513},
{-0.2706039643771174,-0.46030674354318973,0.8455123868472016},
{0.24010521754306643,-0.5377116846018609,-0.8082175627584601},
{0.39980398806467154,-0.8076080559305371,-0.43350432422720137},
{-0.33829130940789054,-0.32679160483150643,-0.8824773294486059},
{-0.9171584156798012,-0.32892094964244534,0.22501433161918574},
{-0.2886129647855738,0.039201760982655896,0.9566429733675672},
{0.0,0.032499081913903716,0.9994717653214389},
{0.0004999916727080361,-0.449092520426358,0.8934851191292604},
{-0.3323908843049952,-0.8149776495444377,0.4746869818880302},
{-0.1531104532074729,-0.8164557413362564,-0.556738009801438},
{0.3014147139183987,-0.8179399287122039,-0.4900239211015771},
{-0.03310095961072887,-0.5321154262498137,-0.8460245266065446},
{0.27659498814422184,-0.01979964123375124,-0.9607825907771812},
{-0.26550032523809763,0.02810003442256325,-0.9637011805346692},
{0.16559861560136033,-0.8205931398700259,0.5469954271373436},
{-0.19221075545374056,-0.8210459429111393,0.5375300783370736},
{-0.3276231375629909,-0.803256727993267,-0.49743513010937623},
{0.3323908843049952,-0.8149776495444377,0.4746869818880302},
{0.2706039643771174,-0.46030674354318973,0.8455123868472016},
{-0.24240646506663616,-0.5353142770221548,-0.8091215795602942},
{0.15210464991022274,-0.8114248056354683,-0.5643172514420689},
{0.2886129647855738,0.039201760982655896,0.9566429733675672},
{0.9536712132883437,0.08790656422823555,0.2877214849654535},
{0.9171584156798012,-0.32892094964244534,0.22501433161918574},
{-0.03020094696553839,-0.8245258534134571,0.5650177164082513},
{-0.39980398806467154,-0.8076080559305371,-0.43350432422720137},
{-0.004200060796320043,-0.7965115295878367,-0.6046087517750234},
{0.33829130940789054,-0.32679160483150643,-0.8824773294486059},
{-0.2792077229924284,-0.019800547690723792,-0.9600265547017596},
{-0.002700167023997064,-0.016401014516130314,-0.9998618483675054},
{0.46211489651378757,-0.8154262856899857,0.3486112376643721},
{-0.9536712132883437,0.08790656422823555,0.2877214849654535},
{0.26550032523809763,0.02810003442256325,-0.9637011805346692},
{0.8109148114942991,-0.3479063545675998,-0.4705085939179525},
{-0.36831698164591725,-0.26831237082704207,-0.8901410408988079},
{0.9029810105090214,-0.02249952683992578,-0.42909097631165116},
{0.8413380377525496,-0.5142232485586128,0.1665075279755135},
{0.9442222555808492,-0.08590202473458478,0.317907493167922},
{0.3635013903954774,-0.5937022709155294,0.7179027459832551},
{0.36228419388542366,-0.3373852802013302,0.8688620923738466},
{-0.8348252371483843,-0.4901148163948528,0.25070757900467167},
{-0.8867051340375891,-0.20520118811831878,0.4143023988178337},
{-0.8311245559377631,-0.4189123769490182,-0.3657108050853568},
{-0.9485322364158412,0.08970304860991139,-0.303710321770681},
{-0.3938244060546882,0.0979060674270035,-0.9139566396479928},
{0.3861157190908928,-0.8984365760975346,0.20910851298084873},
{-0.5156247866792578,-0.8437405595835723,-0.14910716775383506},
{0.5931018564117159,-0.7678024032252833,-0.24230075840256068},
{-0.31770093245360514,-0.7360021601695101,-0.5978017545507244},
{0.3901923054836031,-0.8911824260558356,0.23139543692697528},
{-0.5155408453415223,-0.8513674522584636,-0.09690767781492438},
{0.5692124032734025,-0.7973173737348626,-0.20070437339594496},
{-0.3749038784006832,-0.7629078923229693,-0.5267054487960517},
{-0.9029810105090214,-0.02249952683992578,-0.42909097631165116},
{0.3938244060546882,0.0979060674270035,-0.9139566396479928},
{0.36831698164591725,-0.26831237082704207,-0.8901410408988079},
{0.9485322364158412,0.08970304860991139,-0.303710321770681},
{0.8311245559377631,-0.4189123769490182,-0.3657108050853568},
{0.8867051340375891,-0.20520118811831878,0.4143023988178337},
{0.8348252371483843,-0.4901148163948528,0.25070757900467167},
{-0.36228419388542366,-0.3373852802013302,0.8688620923738466},
{-0.3635013903954774,-0.5937022709155294,0.7179027459832551},
{-0.9442222555808492,-0.08590202473458478,0.317907493167922},
{-0.8413380377525496,-0.5142232485586128,0.1665075279755135},
{-0.8109148114942991,-0.3479063545675998,-0.4705085939179525},
{-0.5692124032734025,-0.7973173737348626,-0.20070437339594496},
{0.3749038784006832,-0.7629078923229693,-0.5267054487960517},
{0.5155408453415223,-0.8513674522584636,-0.09690767781492438},
{-0.5931018564117159,-0.7678024032252833,-0.24230075840256068},
{0.31770093245360514,-0.7360021601695101,-0.5978017545507244},
{0.5156247866792578,-0.8437405595835723,-0.14910716775383506},
{-0.3861157190908928,-0.8984365760975346,0.20910851298084873},
{-0.3901923054836031,-0.8911824260558356,0.23139543692697528},
{-0.9699230747444255,-0.030400723241808987,0.24150574549002862},
{-0.8432021164399683,0.43250108557908723,0.3193008014460174},
{-0.9999603444277816,0.008700525049026601,0.001900114665879373},
{-0.8784332010102601,-0.47171782891227204,-0.07640288770171207},
{-0.8517009283545178,-0.4963005409678845,0.16820018333829975},
{-0.5219944616681425,-0.8418910675831592,-0.1368985475141163},
{-0.5057102407360634,-0.8550173142759229,0.11490232679567666},
{-0.008700557767134066,-0.9869632713085759,-0.16071030266418904},
{-0.008799793867242962,-0.99547668123186,0.09459778407286183},
{0.5069094260684174,-0.8508158210672905,-0.1384025736197849},
{0.4904005247288422,-0.864100924588484,0.11330012123119458},
{0.8697429185232479,-0.4871240377287272,-0.07910390347842809},
{0.8428381603615851,-0.5119231778465774,0.1660075161604451},
{0.9999596693737604,-0.00890053111053752,-0.0012000716104095532},
{0.9696467914349084,-0.04820232605936735,0.23971156756079573},
{0.8783927752491352,0.4716961203153655,0.07699936668281353},
{0.9697175811391205,0.030600554793087643,-0.2423043930184685},
{0.8429361711671738,-0.4324185554783319,-0.3201137363751481},
{0.49052231682046715,-0.7830356250161586,-0.38241739847532447},
{-0.008800067540777565,-0.9136070119607254,-0.40650311992341814},
{-0.505821282878225,-0.7739325638977034,-0.3810160315868006},
{-0.851833537346561,-0.41691641432235416,-0.3171124849643044},
{-0.9700228685586926,0.048101133997601145,-0.23820561576358823},
{-0.8432060162963895,0.5118036517320828,-0.16450117372006176},
{-0.8697369080688075,0.4870206671605258,0.07980338652856253},
{-0.4906132050321225,0.7834210860623009,0.3815102684870664},
{-0.44351732856054693,0.664425959629374,0.6015235019823427},
{-0.764220122180729,0.34970920796467014,0.5419142687905484},
{-0.8803009287179697,-0.06880007258411487,0.4694004952177837},
{-0.7719807007237198,-0.4905877354599183,0.4041898953789217},
{-0.4572040119828078,-0.8135071385564614,0.35940315377651166},
{-0.008300485011509248,-0.939254882266203,0.34312004909021965},
{0.44281584866284057,-0.8217294102218972,0.35871283856224234},
{0.7634835776448654,-0.5045891464041901,0.40309132959874955},
{0.8795340694120307,-0.08480328491886323,0.4682181367807991},
{0.8514447190509977,0.4170219025654992,0.3180167026758483},
{0.5220896914408127,0.8417833791512663,0.13719729106623157},
{0.5054247310371492,0.7743378892799064,0.38071862901828796},
{0.009200104651785624,0.986911226179047,0.16100183140624844},
{0.008700426592373993,0.9140448167160723,0.40551988312731657},
{-0.5065268314369106,0.8509450757545257,0.1390073634150653},
{-0.4906352264206667,0.8641620447413333,-0.11180802754551679},
{0.008600168005923009,0.9956194496159242,-0.09310181876179444},
{0.5053232908872278,0.8553394235025649,-0.11420526384191851},
{0.8514486318774542,0.49662836573918695,-0.16850962470208017},
{0.8795583254464046,0.06920458910846071,-0.47073121522185635},
{0.7634965719080881,-0.3492984316535628,-0.5431975610484263},
{0.44280573658547645,-0.6640086022871643,-0.6025078055391815},
{-0.008300261171826723,-0.7803245532983604,-0.6253196759931625},
{-0.45720729480058325,-0.6560104667304957,-0.6005095812068029},
{-0.7720017756061258,-0.335600771882663,-0.5398012415442833},
{-0.880290594145252,0.08479909392652207,-0.4667950123219399},
{-0.7642054679096845,0.5046036104517493,-0.40170287419434736},
{-0.4435165767418394,0.8218307164970544,-0.3576133660493388},
{-0.7327250559616902,-0.10340353594436846,0.672623000736772},
{-0.6349993237260804,0.24329974088591394,0.7331992191432474},
{-0.6414359951908335,-0.4530254222348731,0.6191347437209932},
{-0.3785849553328066,-0.7185714445381798,0.5833768170659255},
{-0.0071001629151071525,-0.8211188407879554,0.5707130951622045},
{0.36620669431955877,-0.7254132606756089,0.5828106538761301},
{0.6339169448264058,-0.4647124219290595,0.6182165251485787},
{0.7317221788353658,-0.11680354036896369,0.6715203540904033},
{0.7712352578257358,0.33571534757792987,0.5408247243674246},
{0.45651363398327144,0.6561195953043251,0.6009179466824706},
{0.007600402337946921,0.7806413243422851,0.6249330817082935},
{0.006000298792317731,0.5960296800368946,0.8029399833919842},
{-0.36730543065093857,0.5015074148419431,0.783311581347346},
{-0.5326045910713626,-0.13200113785471249,0.836007206413179},
{-0.4608910703220179,0.11869770025433615,0.8794829601827181},
{-0.4655069151565874,-0.38480571633137445,0.7970118396988188},
{-0.27401239523105375,-0.575226020937599,0.770734864980194},
{-0.005400209640207428,-0.6482251645893435,0.7614295592692474},
{0.26452138080469023,-0.5801468922676779,0.7703622670467027},
{0.45953672304686666,-0.3932314243787333,0.7963636399613055},
{0.5313143536511484,-0.14180383088223764,0.8352225638423474},
{0.6403955140451362,0.23159837765904676,0.7322948702924004},
{0.37752763037073006,0.49473620859443745,0.7827572881885309},
{0.27270634595050625,0.2991069602999502,0.9144212788307404},
{0.004000016120097446,0.37130149634804543,0.9285037418776196},
{-0.26581001059350196,0.30401144928677426,0.9148344533142799},
{-0.2902919387047917,-0.15209577635893498,0.9447737639968556},
{-0.2512931875340277,-0.016299558124968767,0.9677737640088817},
{-0.25380110911327025,-0.2889012625012757,0.9231040339734428},
{-0.14950311492984966,-0.39180816340812774,0.9078189146041308},
{-0.003300007557025958,-0.43130098768039266,0.9022020660450968},
{0.1436007919605515,-0.3945021756854984,0.9076050054554077},
{0.24981029489438328,-0.2935120958827121,0.9227380268176438},
{0.28881694105453093,-0.15740923310936,0.9443553927901439},
{0.46421970190223194,0.11020467718575176,0.8788372986464487},
{0.25230569460379154,-0.02090047172897044,0.9674218349572252},
{0.148002225970218,0.08160122729168777,0.9856148237584249},
{0.0018001344390600508,0.12080902235469676,0.9926741356727814},
{-0.14510274682099625,0.08430159584431414,0.9858186617239013},
{-0.0008000312938360995,-0.16170632526662163,0.9868386009468287},
{-0.8783927752491352,0.4716961203153655,0.07699936668281353},
{-0.8514486318774542,0.49662836573918695,-0.16850962470208017},
{-0.9999596693737604,-0.00890053111053752,-0.0012000716104095532},
{-0.8514447190509977,0.4170219025654992,0.3180167026758483},
{-0.9696467914349084,-0.04820232605936735,0.23971156756079573},
{-0.8697429185232479,-0.4871240377287272,-0.07910390347842809},
{-0.8428381603615851,-0.5119231778465774,0.1660075161604451},
{-0.5069094260684174,-0.8508158210672905,-0.1384025736197849},
{-0.4904005247288422,-0.864100924588484,0.11330012123119458},
{0.008700557767134066,-0.9869632713085759,-0.16071030266418904},
{0.008799793867242962,-0.99547668123186,0.09459778407286183},
{0.5219944616681425,-0.8418910675831592,-0.1368985475141163},
{0.5057102407360634,-0.8550173142759229,0.11490232679567666},
{0.8784332010102601,-0.47171782891227204,-0.07640288770171207},
{0.8517009283545178,-0.4963005409678845,0.16820018333829975},
{0.9999603444277816,0.008700525049026601,0.001900114665879373},
{0.9699230747444255,-0.030400723241808987,0.24150574549002862},
{0.8697369080688075,0.4870206671605258,0.07980338652856253},
{0.8431732116925458,0.432537556703862,0.31932772683362576},
{0.5065268314369106,0.8509450757545257,0.1390073634150653},
{0.4906132050321225,0.7834210860623009,0.3815102684870664},
{-0.009200104651785624,0.986911226179047,0.16100183140624844},
{-0.008700426592373993,0.9140448167160723,0.40551988312731657},
{-0.5220896914408127,0.8417833791512663,0.13719729106623157},
{-0.5054247310371492,0.7743378892799064,0.38071862901828796},
{-0.5053232908872278,0.8553394235025649,-0.11420526384191851},
{-0.008600168005923009,0.9956194496159242,-0.09310181876179444},
{0.4906352264206667,0.8641620447413333,-0.11180802754551679},
{0.8432060162963895,0.5118036517320828,-0.16450117372006176},
{0.9700228685586926,0.048101133997601145,-0.23820561576358823},
{0.851833537346561,-0.41691641432235416,-0.3171124849643044},
{0.505821282878225,-0.7739325638977034,-0.3810160315868006},
{0.008800067540777565,-0.9136070119607254,-0.40650311992341814},
{-0.49052231682046715,-0.7830356250161586,-0.38241739847532447},
{-0.8429361711671738,-0.4324185554783319,-0.3201137363751481},
{-0.9697175811391205,0.030600554793087643,-0.2423043930184685},
{-0.771262374510442,0.49093970389934644,-0.40513276441154056},
{-0.45648932283960675,0.8137809658858093,-0.35969158691217207},
{-0.8795583254464046,0.06920458910846071,-0.47073121522185635},
{-0.6404235520091957,0.4535166783825269,-0.619822794402404},
{-0.3775165318108999,0.7189314826989561,-0.5836255575227581},
{-0.006000071851290631,0.8214098364416874,-0.5703068294651745},
{-0.007600101044015074,0.9394124895720738,-0.34270455628736396},
{0.4435165767418394,0.8218307164970544,-0.3576133660493388},
{0.7642054679096845,0.5046036104517493,-0.40170287419434736},
{0.880290594145252,0.08479909392652207,-0.4667950123219399},
{0.7720017756061258,-0.335600771882663,-0.5398012415442833},
{0.45720729480058325,-0.6560104667304957,-0.6005095812068029},
{0.008300261171826723,-0.7803245532983604,-0.6253196759931625},
{-0.44280573658547645,-0.6640086022871643,-0.6025078055391815},
{-0.7634965719080881,-0.3492984316535628,-0.5431975610484263},
{-0.731730345486654,0.10390430900104328,-0.6736279359297666},
{-0.46421300278831473,0.3853107927064577,-0.7975223389135738},
{-0.27270443693728375,0.5756093652405593,-0.7709125428491092},
{-0.0040000576612467835,0.6486093497711658,-0.7611109714937316},
{0.26582685518543475,0.5804586408940043,-0.7696777567746824},
{0.36732440033371516,0.725548196139696,-0.5819386565591855},
{0.6349853923290723,0.46488930534454437,-0.6169858064047836},
{0.7327670549174308,0.11691069840295845,-0.6703613442215829},
{0.6414217541876961,-0.231507851721939,-0.7314248066929857},
{0.3786153190857216,-0.49442000463808966,-0.7824316578253263},
{0.007100283981536876,-0.595623822451178,-0.8032321259113265},
{-0.3661969862112052,-0.5010958759979108,-0.7840935469366631},
{-0.6339536696196987,-0.24282055684439632,-0.734262161594546},
{-0.5313187718238187,0.13260468500628336,-0.8367295621776568},
{-0.2523138095127023,0.28941584016241,-0.9233505363578202},
{-0.1480070948901444,0.39231880625272736,-0.9078435185221155},
{-0.0018000250835243094,0.4317060158652469,-0.9020125696327373},
{0.14509913956465356,0.39489765826382967,-0.9071946203518518},
{0.2513096793787055,0.2938113163607787,-0.9222355205851263},
{0.4609156206950825,0.39351333639295943,-0.7954269574763911},
{0.5326310932476289,0.14200828997589807,-0.8343487065274068},
{0.4654991853771384,-0.10989980767550485,-0.8781984631540342},
{0.2739918721516672,-0.29869113945877,-0.9141728814637012},
{0.005400286411784976,-0.37091967224649025,-0.9286492522191718},
{-0.2645202908071394,-0.30352328264637735,-0.9153702161654997},
{-0.4595367873923051,-0.11810945504032912,-0.8802704684716146},
{-0.28881354422874234,0.15260715668042274,-0.945144323582356},
{0.0007999794847891654,0.16209584310540465,-0.9867746944874356},
{0.29030967182782813,0.15780525736972537,-0.9438314442683574},
{0.2538054403779224,0.021300456580180246,-0.9670207283114693},
{0.14950443885268527,-0.08110240796623931,-0.9854292578290038},
{0.0033001051595263893,-0.12030383354273473,-0.9927316338975293},
{-0.14359857407323914,-0.08369916887137963,-0.9860902081728489},
{-0.24981250467789032,0.016800840987143944,-0.9681484618841698},
{-0.7634835776448654,-0.5045891464041901,0.40309132959874955},
{-0.8795340694120307,-0.08480328491886323,0.4682181367807991},
{-0.44281584866284057,-0.8217294102218972,0.35871283856224234},
{0.008300485011509248,-0.939254882266203,0.34312004909021965},
{0.4572040119828078,-0.8135071385564614,0.35940315377651166},
{0.7719807007237198,-0.4905877354599183,0.4041898953789217},
{0.8803009287179697,-0.06880007258411487,0.4694004952177837},
{0.764220122180729,0.34970920796467014,0.5419142687905484},
{0.44351732856054693,0.664425959629374,0.6015235019823427},
{-0.007600402337946921,0.7806413243422851,0.6249330817082935},
{-0.45651363398327144,0.6561195953043251,0.6009179466824706},
{-0.7712352578257358,0.33571534757792987,0.5408247243674246},
{-0.6403955140451362,0.23159837765904676,0.7322948702924004},
{-0.7317221788353658,-0.11680354036896369,0.6715203540904033},
{-0.6339169448264058,-0.4647124219290595,0.6182165251485787},
{-0.36620669431955877,-0.7254132606756089,0.5828106538761301},
{0.0071001629151071525,-0.8211188407879554,0.5707130951622045},
{0.3785849553328066,-0.7185714445381798,0.5833768170659255},
{0.6414359951908335,-0.4530254222348731,0.6191347437209932},
{0.7327250559616902,-0.10340353594436846,0.672623000736772},
{0.6349993237260804,0.24329974088591394,0.7331992191432474},
{0.36730543065093857,0.5015074148419431,0.783311581347346},
{-0.006000298792317731,0.5960296800368946,0.8029399833919842},
{-0.37752763037073006,0.49473620859443745,0.7827572881885309},
{-0.45953672304686666,-0.3932314243787333,0.7963636399613055},
{-0.5313143536511484,-0.14180383088223764,0.8352225638423474},
{-0.26452138080469023,-0.5801468922676779,0.7703622670467027},
{0.005400209640207428,-0.6482251645893435,0.7614295592692474},
{0.27401239523105375,-0.575226020937599,0.770734864980194},
{0.4655069151565874,-0.38480571633137445,0.7970118396988188},
{0.5326045910713626,-0.13200113785471249,0.836007206413179},
{0.4608910703220179,0.11869770025433615,0.8794829601827181},
{0.26581001059350196,0.30401144928677426,0.9148344533142799},
{-0.004100014862580816,0.37130134596981873,0.9285033658308016},
{-0.27270634595050625,0.2991069602999502,0.9144212788307404},
{-0.46421970190223194,0.11020467718575176,0.8788372986464487},
{-0.25230569460379154,-0.02090047172897044,0.9674218349572252},
{-0.28881694105453093,-0.15740923310936,0.9443553927901439},
{-0.24981029489438328,-0.2935120958827121,0.9227380268176438},
{-0.1436007919605515,-0.3945021756854984,0.9076050054554077},
{0.003300007557025958,-0.43130098768039266,0.9022020660450968},
{0.14950311492984966,-0.39180816340812774,0.9078189146041308},
{0.25380110911327025,-0.2889012625012757,0.9231040339734428},
{0.2902919387047917,-0.15209577635893498,0.9447737639968556},
{0.2512931875340277,-0.016299558124968767,0.9677737640088817},
{0.14510274682099625,0.08430159584431414,0.9858186617239013},
{-0.0018001344390600508,0.12080902235469676,0.9926741356727814},
{-0.148002225970218,0.08160122729168777,0.9856148237584249},
{0.0008000312938360995,-0.16170632526662163,0.9868386009468287},
{-0.7327670549174308,0.11691069840295845,-0.6703613442215829},
{-0.6349853923290723,0.46488930534454437,-0.6169858064047836},
{-0.36732440033371516,0.725548196139696,-0.5819386565591855},
{0.006000071851290631,0.8214098364416874,-0.5703068294651745},
{0.007600101044015074,0.9394124895720738,-0.34270455628736396},
{0.45648932283960675,0.8137809658858093,-0.35969158691217207},
{0.771262374510442,0.49093970389934644,-0.40513276441154056},
{0.731730345486654,0.10390430900104328,-0.6736279359297666},
{0.6339536696196987,-0.24282055684439632,-0.734262161594546},
{0.3661969862112052,-0.5010958759979108,-0.7840935469366631},
{-0.007100283981536876,-0.595623822451178,-0.8032321259113265},
{-0.3786153190857216,-0.49442000463808966,-0.7824316578253263},
{-0.6414217541876961,-0.231507851721939,-0.7314248066929857},
{-0.5326310932476289,0.14200828997589807,-0.8343487065274068},
{-0.4609156206950825,0.39351333639295943,-0.7954269574763911},
{-0.26582685518543475,0.5804586408940043,-0.7696777567746824},
{0.0040000576612467835,0.6486093497711658,-0.7611109714937316},
{0.27270443693728375,0.5756093652405593,-0.7709125428491092},
{0.3775165318108999,0.7189314826989561,-0.5836255575227581},
{0.6404235520091957,0.4535166783825269,-0.619822794402404},
{0.5313187718238187,0.13260468500628336,-0.8367295621776568},
{0.4595367873923051,-0.11810945504032912,-0.8802704684716146},
{0.2645202908071394,-0.30352328264637735,-0.9153702161654997},
{-0.005400286411784976,-0.37091967224649025,-0.9286492522191718},
{-0.2739918721516672,-0.29869113945877,-0.9141728814637012},
{-0.4654991853771384,-0.10989980767550485,-0.8781984631540342},
{-0.29030967182782813,0.15780525736972537,-0.9438314442683574},
{-0.2513096793787055,0.2938113163607787,-0.9222355205851263},
{-0.14509913956465356,0.39489765826382967,-0.9071946203518518},
{0.0018000250835243094,0.4317060158652469,-0.9020125696327373},
{0.1480070948901444,0.39231880625272736,-0.9078435185221155},
{0.2523138095127023,0.28941584016241,-0.9233505363578202},
{0.46421300278831473,0.3853107927064577,-0.7975223389135738},
{0.28881354422874234,0.15260715668042274,-0.945144323582356},
{0.24981250467789032,0.016800840987143944,-0.9681484618841698},
{0.14359857407323914,-0.08369916887137963,-0.9860902081728489},
{-0.0033001051595263893,-0.12030383354273473,-0.9927316338975293},
{-0.14950443885268527,-0.08110240796623931,-0.9854292578290038},
{-0.2538054403779224,0.021300456580180246,-0.9670207283114693},
{-0.0007999794847891654,0.16209584310540465,-0.9867746944874356},
{0.947188472786429,0.23909709020611822,0.21369739931847537},
{0.9987267362725998,0.022600605026294938,0.04510120737548238},
{0.4843253357209847,0.7835409881011594,-0.3892203606496123},
{0.25449982312268443,0.9664993282832004,0.03329997685652413},
{-0.5489253087848057,0.7257334607125769,-0.4147191210658753},
{-0.4234351021077441,0.6301522386350722,-0.6508539547749642},
{0.586324374010852,0.3934163546578018,-0.7081294375525912},
{0.9663377555536786,-0.25641001813511666,-0.021100824425315762},
{0.5175469048137195,-0.16911532677101443,0.8387760175212879},
{0.4942951213312286,-0.38009624846854134,0.781792283748239},
{0.5406912922368573,-0.5475911811150417,0.6385897155954449},
{0.8263329796073373,0.3432136979320321,0.44651782088185415},
{-0.04520202147960186,0.8896397855808367,0.4544203221312188},
{-0.7135318706127672,0.6771302446978342,-0.17990803577188064},
{-0.7324334583245818,-0.17920818641693753,-0.6568300046799364},
{-0.855597929455516,-0.20619950099781137,-0.4747988509881709},
{-0.9480103807705045,-0.12630138300771596,-0.2921031985475363},
{-0.36920888142646535,0.42021010827573335,-0.8289199399089846},
{0.5307356745973424,-0.10620713895277513,-0.8408565200705587},
{0.8529518013358905,-0.5213316614332275,0.026201591270958297},
{0.6061826209933805,0.02669923454391828,0.7948772111970277},
{-0.32731118441426044,0.5781197546895324,0.7474255399670585},
{-0.5333260829498956,0.11290552177956725,0.8383410000691872},
{-0.5903398788057655,-0.3884262390787046,0.7075477964680317},
{-0.4885207870017398,-0.7797331783526233,0.3916166636435646},
{0.642981546694411,-0.6201822010262421,0.44938710277522287},
{0.664197529189787,0.30479886615032686,0.682597460742169},
{-0.3322036044286622,0.5705061900257429,0.7511081495676345},
{-0.8676914185743054,0.49679508672088846,-0.01749982692756753},
{-0.6089084608418456,-0.047600661415785596,-0.7918110022903158},
{0.3364058669694803,-0.5700099410600588,-0.7496130733660002},
{0.0457987165089545,-0.8895750700079895,-0.4544872631729219},
{-0.2575987004178346,-0.9656951280803683,-0.03279983452525224},
{-0.9864430690446122,0.04640202595668086,-0.15740687253408553},
{-0.40641778319916433,0.15030657680815548,-0.9012394345942099},
{0.3195141388134707,-0.5783255914736466,-0.7506332162547452},
{0.6959313941733026,-0.696431416729829,0.17510789929550985},
{0.7342291604901747,0.15130600923748766,0.6618262849528708},
{-0.037400901372584755,0.8870213774727987,0.4602110912209492},
{-0.749721614785736,0.6100175870605561,-0.2565073952148076},
{-0.8722880192063337,0.4722935130931462,-0.12669825981135216},
{-0.9594793618208886,0.26459430863763117,-0.09689791574824815},
{0.7700771925562877,-0.5783579746172743,0.26922698731967876},
{0.5062359845327163,0.12920918451526464,0.852660609270237},
{-0.5242098001938228,0.10640198920378242,0.8449157958484564},
{-0.9678371221047412,0.24970957779453798,0.03060117373052808},
{-0.5162032417665375,0.16200101736958364,-0.8410052815297521},
{0.5350770269610107,-0.10649542771696437,-0.8380640184937824},
{0.9621270890695446,-0.2502070446785158,0.10820304649966192},
{0.8863109858927556,-0.43960544894330966,0.1456018047455548},
{0.3992131063814273,-0.13590446181672336,0.9067297684269542},
{-0.5840831231619809,-0.3772890983890008,0.7186792340635433},
{-0.9993684554325485,0.0030999021531327798,-0.03539888265190336},
{-0.48613464805109396,0.3947281332766237,-0.7796555680325712},
{0.5935337552245167,0.3751213337568933,-0.7120404948944496},
{0.9852239363063023,-0.06340154035913477,0.15910386547536814},
{0.36399564481816443,-0.41629501905989524,0.8331900309409194},
{-0.4939209575108502,-0.7708327071256598,0.4023170706754708},
{-0.957882537960498,-0.20469626842103972,-0.20139632857839473},
{-0.5324299766515519,0.5708321387541432,-0.6250351904718632},
{0.4976089918757255,0.7697139088560007,-0.39990722638887183},
{0.9536101607703948,0.0883009408515372,0.28780306655801136},
{0.4115289170953252,-0.6409450375854044,0.6479455294922508},
{-0.27050227899130086,-0.9621081057949372,-0.034300288981152005},
{-0.8374959590917461,-0.314598482065986,-0.44679784420560253},
{-0.6278058072305754,0.6435059524575905,-0.4379040506312026},
{0.2644085286346389,0.9637310856475094,0.03620116768749595},
{0.8636240781749539,0.17220480113678446,0.4738132100964488},
{0.5323042211892112,-0.7449059071272653,0.40220318948393896},
{0.03090124132779671,-0.8926358579026324,-0.4497180655375463},
{-0.67752676622361,-0.2785110027945024,-0.6807268926471015},
{-0.5248960449232023,-0.10949917492682539,-0.8440936397783864},
{-0.586324374010852,0.3934163546578018,-0.7081294375525912},
{-0.9987267362725998,0.022600605026294938,0.04510120737548238},
{-0.4843253357209847,0.7835409881011594,-0.3892203606496123},
{0.4234351021077441,0.6301522386350722,-0.6508539547749642},
{0.5489253087848057,0.7257334607125769,-0.4147191210658753},
{-0.25449982312268443,0.9664993282832004,0.03329997685652413},
{-0.947188472786429,0.23909709020611822,0.21369739931847537},
{-0.4942951213312286,-0.38009624846854134,0.781792283748239},
{-0.5175469048137195,-0.16911532677101443,0.8387760175212879},
{-0.9663377555536786,-0.25641001813511666,-0.021100824425315762},
{-0.5307356745973424,-0.10620713895277513,-0.8408565200705587},
{0.36920888142646535,0.42021010827573335,-0.8289199399089846},
{0.9480103807705045,-0.12630138300771596,-0.2921031985475363},
{0.855597929455516,-0.20619950099781137,-0.4747988509881709},
{0.7324334583245818,-0.17920818641693753,-0.6568300046799364},
{0.7135318706127672,0.6771302446978342,-0.17990803577188064},
{0.04520202147960186,0.8896397855808367,0.4544203221312188},
{-0.8263329796073373,0.3432136979320321,0.44651782088185415},
{-0.5406912922368573,-0.5475911811150417,0.6385897155954449},
{0.5903398788057655,-0.3884262390787046,0.7075477964680317},
{0.5333260829498956,0.11290552177956725,0.8383410000691872},
{0.32731118441426044,0.5781197546895324,0.7474255399670585},
{-0.6061826209933805,0.02669923454391828,0.7948772111970277},
{-0.8529518013358905,-0.5213316614332275,0.026201591270958297},
{-0.3195141388134707,-0.5783255914736466,-0.7506332162547452},
{0.40641778319916433,0.15030657680815548,-0.9012394345942099},
{0.9864430690446122,0.04640202595668086,-0.15740687253408553},
{0.4885207870017398,-0.7797331783526233,0.3916166636435646},
{0.2575987004178346,-0.9656951280803683,-0.03279983452525224},
{-0.0457987165089545,-0.8895750700079895,-0.4544872631729219},
{-0.3364058669694803,-0.5700099410600588,-0.7496130733660002},
{0.6089084608418456,-0.047600661415785596,-0.7918110022903158},
{0.8676914185743054,0.49679508672088846,-0.01749982692756753},
{0.3322036044286622,0.5705061900257429,0.7511081495676345},
{-0.664197529189787,0.30479886615032686,0.682597460742169},
{-0.642981546694411,-0.6201822010262421,0.44938710277522287},
{0.9594793618208886,0.26459430863763117,-0.09689791574824815},
{0.8722880192063337,0.4722935130931462,-0.12669825981135216},
{0.749721614785736,0.6100175870605561,-0.2565073952148076},
{0.037400901372584755,0.8870213774727987,0.4602110912209492},
{-0.7342291604901747,0.15130600923748766,0.6618262849528708},
{-0.6959313941733026,-0.696431416729829,0.17510789929550985},
{-0.03090124132779671,-0.8926358579026324,-0.4497180655375463},
{0.5248960449232023,-0.10949917492682539,-0.8440936397783864},
{-0.7700564549081399,-0.5783423998355549,0.2693197445542364},
{-0.8863109858927556,-0.43960544894330966,0.1456018047455548},
{-0.9621270890695446,-0.2502070446785158,0.10820304649966192},
{-0.5350770269610107,-0.10649542771696437,-0.8380640184937824},
{0.5162032417665375,0.16200101736958364,-0.8410052815297521},
{0.9678371221047412,0.24970957779453798,0.03060117373052808},
{0.5242098001938228,0.10640198920378242,0.8449157958484564},
{-0.5062359845327163,0.12920918451526464,0.852660609270237},
{-0.3992131063814273,-0.13590446181672336,0.9067297684269542},
{-0.36399564481816443,-0.41629501905989524,0.8331900309409194},
{-0.9852239363063023,-0.06340154035913477,0.15910386547536814},
{-0.5935337552245167,0.3751213337568933,-0.7120404948944496},
{0.48613464805109396,0.3947281332766237,-0.7796555680325712},
{0.9993684554325485,0.0030999021531327798,-0.03539888265190336},
{0.5840831231619809,-0.3772890983890008,0.7186792340635433},
{0.4939209575108502,-0.7708327071256598,0.4023170706754708},
{-0.4115289170953252,-0.6409450375854044,0.6479455294922508},
{-0.9536101607703948,0.0883009408515372,0.28780306655801136},
{-0.4976089918757255,0.7697139088560007,-0.39990722638887183},
{0.5324299766515519,0.5708321387541432,-0.6250351904718632},
{0.957882537960498,-0.20469626842103972,-0.20139632857839473},
{0.8374959590917461,-0.314598482065986,-0.44679784420560253},
{0.27050227899130086,-0.9621081057949372,-0.034300288981152005},
{-0.5323042211892112,-0.7449059071272653,0.40220318948393896},
{-0.8636240781749539,0.17220480113678446,0.4738132100964488},
{-0.2644085286346389,0.9637310856475094,0.03620116768749595},
{0.6278058072305754,0.6435059524575905,-0.4379040506312026},
{0.67752676622361,-0.2785110027945024,-0.6807268926471015},
{-0.7214129963721955,-0.5580100526416484,0.4101073881511469},
{-0.4847259601939659,-0.6106327033101622,0.6262335388352825},
{-0.024399566057576465,-0.996082284834095,0.08499848831532786},
{0.05710171364814025,-0.9594287928901184,0.2761082861340022},
{0.954450004945673,-0.27451438218523394,0.1169061248723273},
{0.8309699859061538,-0.4081852566147918,-0.37798634737969455},
{-0.18299497045235474,-0.9768731510104118,-0.11059696028431933},
{-0.1541010925806196,-0.7749054940994299,0.613004346216222},
{-0.0769015864960943,-0.6967143733657855,0.7132147137713193},
{-0.503417043472515,-0.48831653223605304,0.7128241330695445},
{-0.7922080251079417,-0.38570390720037,0.4729047905497925},
{-0.702103134897496,-0.6795030339878202,0.2129009506048667},
{0.013300297198461387,-0.8641193089616905,0.5031112421463101},
{0.7570599274504298,-0.05100403738437506,0.6513515597734015},
{0.7823590507778703,0.5474413196929645,0.29702241861309914},
{0.93903387625814,0.3373121687559858,-0.06660240272501826},
{0.8721811262046413,0.21379537351817507,-0.43999047870906005},
{0.3617164566645525,-0.35161599713369274,-0.8634392830637948},
{-0.4714229659291915,-0.8706424143783499,-0.14050684495768223},
{-0.026401510077554563,-0.9111521148356047,0.4112235206019105},
{0.7833351764559159,-0.49012200942301076,0.38231716833792495},
{0.11090250587043053,-0.9892223517315589,0.09560216015521335},
{0.562040476802458,-0.5586402319250052,0.6099439266936282},
{0.5744059221555863,-0.433904473578184,0.6941071562816721},
{0.16710548950549686,-0.6767222306904233,0.7170235546106598},
{0.24591125192675375,-0.7498343094537615,0.6142281046499071},
{0.258104662702848,-0.9601173446764988,-0.1075019420401246},
{-0.8106958735685053,-0.4811975507107003,-0.3334983024979604},
{-0.921991199635999,-0.35029665643437136,0.1649984250975486},
{0.03540006849919882,-0.9564018506393716,0.2899005609581282},
{0.7651221467810625,-0.6159178279995509,0.18770543321239763},
{0.8424082219443695,-0.31160304126052407,0.43960429055881384},
{-0.08869790231941495,-0.9819767765238497,0.16689605295502088},
{-0.19399916968533062,-0.9809958013469553,0.003399985448093423},
{-0.6905338024569656,-0.6409313743586811,0.3352164092448586},
{-0.6713187904759219,-0.739220691076719,0.053701503126109044},
{-0.8612260008054524,0.22170669342611335,-0.457313806512231},
{-0.8712856151932388,0.4312928794133409,0.23419613345375476},
{-0.5127953643508593,-0.6699939432821289,0.5367951473938012},
{-0.3754923212605445,-0.9263810557011143,-0.028699413103003002},
{-0.24482668633909555,-0.7389805495749906,0.6276684164477794},
{-0.5560887754613499,-0.8289832671416275,0.0595987970104234},
{0.2747029750493297,-0.9615104132141629,0.006000064981055619},
{0.17751074061230093,-0.9685586044113436,0.17431054697872708},
{0.7560278752616508,-0.5765212567306107,0.30991142664495447},
{0.7321002562351345,-0.6805002381751251,0.03080001078000566},
{0.12089943237849747,-0.8992957778162347,0.42029802670539695},
{0.5351371317781274,-0.8309576579974697,-0.15211055455700465},
{0.5908276927429534,-0.6169289161359648,0.5199243694263059},
{0.8423304844918607,0.5052182841805627,0.1877067932317728},
{0.8179173523006955,0.28460603798114437,-0.5000106078375691},
{0.3247069861459612,-0.07520161798021646,-0.9428202849966499},
{-0.3705062745768904,-0.39380666917241414,-0.8412142460838872},
{0.6251235238408115,-0.7793293267143567,0.043201625707763654},
{0.44941321069549545,-0.8926262391339547,-0.035301037689254536},
{0.33390425062816587,-0.7063089913706906,0.6242079462177333},
{0.08150072780474897,-0.8542076281081787,0.5135045856164244},
{-0.15809950910178636,0.24479923989954017,0.9565970297708339},
{0.45222367679041375,0.4546238024522824,0.7673401751465821},
{0.37529705580614575,0.9267927293395574,0.014399887033329332},
{0.3547132842612481,0.7726289354954616,-0.5265197185326955},
{-0.030501493084630637,0.4913240509009519,-0.8704426092086067},
{-0.5861392110940831,0.20801391555633728,-0.7830523840414043},
{-0.9062322216594718,0.13420477173549009,-0.40091425475974646},
{-0.3615167838062914,-0.09070421104074863,-0.9279430807575595},
{-0.051003155917911644,0.5025310950735412,-0.8630534030815246},
{-0.44160481131062895,0.7467081354294535,-0.49740541926156445},
{-0.449294210881389,0.8921885042251841,0.046199404724505164},
{-0.4514992550268439,0.40629932960665927,0.7943986892432442},
{0.18219455792983077,0.2456926612698102,0.9520715620471563},
{0.34812162076465725,0.775748179336813,0.5263326889067483},
{0.44569536924917014,-0.34269643940249184,-0.8269914076039123},
{-0.2859129321343873,-0.10170460020310314,-0.9528430980680105},
{0.5799117085355943,0.5781116721924936,-0.5740115894109865},
{0.7802267583355236,0.5824199744355408,-0.2281078230919417},
{0.19911463347214053,0.9775718443948638,-0.06860504196980834},
{0.2862054937671798,0.957418377822145,-0.03790072751144694},
{0.17550880110950298,0.7161359115356984,-0.6755338754955514},
{-0.8280014490038036,0.22750039812604508,-0.5125008968773542},
{-0.9211610105141564,-0.2363156517039357,-0.30922048035064287},
{-0.4440186092098762,-0.5377225364237621,-0.7167300387854014},
{0.21041630684357276,-0.7513582287622443,-0.6254484710074638},
{0.88463953984787,-0.38731731153411714,-0.2596116035999401},
{0.7403292361788165,0.6718265309535714,0.023700935968442458},
{0.15079579210213126,0.9725728607329766,-0.17709505823134913},
{-0.45321206919810625,-0.3913104207352581,-0.8009213288189835},
{-0.6540082143947595,0.5028063152869803,-0.5652070990457463},
{0.24929041496781318,-0.09289642820100218,-0.963962936337633},
{0.45371404266693416,-0.5105158007085516,-0.7304226069295322},
{0.9224173554458156,-0.16450309515485328,-0.3494065741465394},
{0.7818240649150828,0.28680882811159597,-0.5536170405947682},
{-0.25710640074352076,0.6782168844195091,-0.6884171383579918},
{-0.39690957158972967,0.9146220563768375,-0.07700185692216979},
{-0.3343113751380619,0.9389319477030402,-0.08150277317903694},
{-0.8467353688750523,0.4926205771912729,-0.20090839211881187},
{-0.8604285796099155,-0.46291537598957444,-0.21300707514750347},
{-0.17579637335822604,-0.7758839936783138,-0.6058875006697904},
{-0.0823049141616044,0.9001537452838412,-0.42772553811565256},
{-0.8873605621362043,0.41578152100093957,0.19929114270198955},
{-0.957397836283335,-0.11239974597686113,0.26599939884203794},
{0.003899899500884776,0.8931769831257134,-0.4496884116789446},
{-0.4729266123292347,0.8792494767601251,-0.057103213288220135},
{0.7156645504344695,-0.09269540844666108,0.6922657094673512},
{0.9215462028771008,-0.2788139786892411,0.27021354749581405},
{0.6283444946490548,0.7593537717444332,0.16901196816121325},
{0.3709031248719906,0.8735073593305037,0.31530265643607075},
{0.3223977754630239,0.8597940674414019,-0.39599726762827997},
{0.17010832615579055,0.9363458305682932,-0.3071150321131292},
{0.6152125719973645,-0.7720157763035849,-0.15970326356953693},
{0.6742072949623975,-0.6706072560097652,0.3094033477623343},
{0.48672200763312395,-0.5542250598526347,0.6752305312387206},
{0.12670043204920994,0.15020051218461983,0.9805033435221021},
{0.10099881327091607,0.9714885850761877,0.21449747966942073},
{0.5647339217617965,0.7507450948584747,-0.34272058613027745},
{-0.6729427298552413,-0.14040891554714796,0.726246114461103},
{-0.6884591480662247,0.6959597924742674,0.20411753649087225},
{-0.8817910145953417,-0.34949643864943514,0.31669677287632647},
{-0.6013088423115397,-0.7189105716576849,0.34870512774660556},
{-0.5556246424993544,-0.82253648030187,-0.12130538001290801},
{-0.8049685424440299,0.5903769285204413,0.0589976944151525},
{-0.2976995787553941,0.9134987074002435,-0.2772996076213328},
{-0.4187067935728391,0.8369135790329806,-0.3525057194516975},
{-0.4255997744321794,0.8400995547473541,0.33629982176114176},
{-0.09350105002268766,0.15480173843328396,0.9835110448910516},
{-0.4075190825278195,-0.5817272400157856,0.7039329624327169},
{-0.5334290700092768,0.3408185734142511,0.7741421880280862},
{-0.06180081454010349,0.997613148627949,-0.03080040595202569},
{0.6678433377603266,0.723746965464433,-0.1737112724902197},
{0.538310623664988,0.3958078113442361,0.744014683274663},
{-0.16011114012012426,0.9622669520523646,0.22001530809760983},
{0.11389879154023261,-0.37989596932514813,0.9179902601750092},
{-0.6233365441761348,0.7231423954656877,-0.2975174424713623},
{-0.703609421393229,0.6951093075759431,-0.14750197506466925},
{-0.005799906593256468,0.9990839098831961,-0.04239931716449556},
{0.8579795588805116,0.4905883118727028,0.15229637158217005},
{0.6955261418413209,-0.13170495022358297,0.7063265477822069},
{-0.6482532950941746,-0.19751623847747532,0.7353604564682915},
{-0.03880105443298152,-0.3990108432670007,0.9161248960323292},
{0.5805117090392582,0.8135164087914496,-0.034600697903115124},
{0.9746173629629832,-0.02890051486725858,0.22200395503568876},
{-0.6177205735263077,0.7851261490618491,-0.044701488807877526},
{-0.2902106378659,0.9427345565685181,-0.16440602641334928},
{0.4044169130689642,0.9144382426069755,-0.015800660797452116},
{0.5295246684812851,0.2653123598641831,-0.8057375361574531},
{-0.7195133470963841,-0.10290190884811387,0.6868127404945054},
{-0.8106381616897135,0.48572286594213404,0.3270153946120606},
{-0.3868199526877527,0.7526388221116926,0.5328274839504515},
{-0.9658624836651678,0.25771667223080735,-0.02630170151210801},
{-0.14959507391532262,0.888070756311484,0.43468568603603436},
{0.09520323220460096,0.9041306957581904,0.41651414089512917},
{0.4803216653973376,-0.8739394199265738,0.07430335152825773},
{0.99958142295188,-0.02099960972587983,0.019899630168809936},
{-0.5192087201836839,-0.852914324816379,0.05440091367101772},
{-0.99958142295188,0.02099960972587983,-0.019899630168809936},
{-0.4803216653973376,0.8739394199265738,-0.07430335152825773},
{0.5192087201836839,0.852914324816379,-0.05440091367101772},
{-0.01830069562266118,0.07470283950889563,0.9970378981307756},
{0.5192087201836839,-0.852914324816379,0.05440091367101772},
{0.99958142295188,0.02099960972587983,-0.019899630168809936},
{-0.4803216653973376,-0.8739394199265738,0.07430335152825773},
{-0.99958142295188,-0.02099960972587983,0.019899630168809936},
{-0.5192087201836839,0.852914324816379,-0.05440091367101772},
{0.4803216653973376,0.8739394199265738,-0.07430335152825773},
{0.01830069562266118,0.07470283950889563,0.9970378981307756},
{-0.13990136124686742,-0.9847095812708389,0.10380100998874081},
{0.23649740090784596,-0.9661893816370434,0.10269887134560583},
{-0.13809509425891314,-0.9849650097395325,0.10379631270148576},
{-0.41499827983569515,-0.9047962496273181,0.09549960415496117},
{-0.41740447877408604,-0.9037096968570713,0.09530102258545854},
{-0.2267995985650658,-0.9676982871755475,0.1100998051235174},
{-0.2344070018417191,-0.9659288527257528,0.10970327688582161},
{0.10629802393810232,-0.9869816521816274,0.12069775624956679},
{0.23621415319499575,-0.9662578950762273,0.10270615382356504},
{0.6905457674374056,-0.7186476299500647,0.08180542183400402},
{0.6913169409292087,-0.7179175927861694,0.08170200213209365},
{0.9872419142452228,-0.1570066658595016,0.026501125129151544},
{0.8360038456265348,0.5466025143773492,-0.048200221721529886},
{0.4051007818452634,0.9098017559190833,-0.09030017427950453},
{0.14110699273029143,0.9848488053918567,-0.1008049955153322},
{-0.46939350129196156,0.8777878471113846,-0.09569867506101559},
{-0.4640902588476991,0.8805815167879419,-0.09589798712237524},
{0.0651021946319722,0.9924334554956866,-0.10410350938845322},
{0.06269928335128692,0.9925886547765135,-0.10409881015739982},
{0.382127825650724,0.9190669242947275,-0.09640702013276575},
{0.3766052461476185,0.9213128339771666,-0.09670134705914686},
{0.7794761094233637,0.623580887538691,-0.05969817027912099},
{0.7801046767415556,0.6228037337195755,-0.05960035730521307},
{0.9976835882399591,0.0679988814276007,-0.0018999687457711958},
{0.998652021138707,0.051902703682254046,-0.0005000260470352028},
{0.8407929205534134,-0.5387954633612977,0.052599557113593653},
{0.8380708314523081,-0.5429811018716184,0.052998155431299765},
{0.48012049918232824,-0.8728372665826621,0.08740373178199436},
{0.48459521949173945,-0.8703914136310565,0.08709914077121442},
{0.1734929172962241,-0.9795600102788538,0.1017958442694848},
{0.1747077030324438,-0.979343180192743,0.10180448865885965},
{-0.07939921553962567,-0.9915902031371892,0.10219899027896404},
{-0.07860419128722212,-0.9916528763410872,0.10220544973987405},
{-0.17290843381454396,-0.9798477932417013,0.1000048778568791},
{0.15460522574494676,0.982033193282909,-0.10820365734542847},
{-0.16970760816261474,0.9800439363545224,-0.10350464021703373},
{0.1559044207325257,0.9818278401231156,-0.10820306814149634},
{0.3202091485060611,0.9409268826650622,-0.11010314569180928},
{-0.17030695292328255,0.9799400068674373,-0.10350422564626978},
{-0.5110111503849535,0.8544186436182079,-0.0940020511471343},
{-0.5101227443295953,0.8549381182657734,-0.09410419572910197},
{-0.8354984543292893,0.5455989906428009,-0.06529987919533523},
{-0.8350280657649434,0.5463183620687289,-0.06530219484365365},
{-0.9997282827131825,0.019800560165770746,-0.012300347981766675},
{-0.8171885226677982,-0.5740919369353683,0.05119928091114937},
{-0.4123006473125244,-0.906601423365352,0.08990014114333239},
{-0.10830137218707847,-0.9889125296011256,0.10160128729646511},
{-0.4296126028705605,-0.8986263615909815,0.08890260799625892},
{-0.4356309091095409,-0.8957635566790996,0.08850627974332959},
{-0.11420513877583144,-0.988144462560412,0.10260461679860162},
{-0.11630006629105667,-0.9879005631034814,0.10260005848204999},
{-0.4044307520613939,-0.9099691921381363,0.09160696560045421},
{-0.4059094273559268,-0.909321119228244,0.0915021251615356},
{-0.7632309878071701,-0.6434261236309399,0.05900239554588973},
{-0.7625827620114949,-0.6441854383527472,0.059098664089797213},
{-0.9993072250173554,-0.037200268958916864,-0.0011000079530862515},
{-0.998631287608369,-0.052301638636008105,0.00030000939944172905},
{-0.705709590658506,0.704709577068229,-0.07320099480827921},
{-0.7159836149024572,0.6943841092014893,-0.0720983500481385},
{-0.17889945793546366,0.9785970348554764,-0.10169969185040052},
{-0.17480643124691056,0.9793360304353518,-0.1017037417494897},
{0.0876017270850744,0.9909195361712354,-0.10200201098947018},
{0.08809786717645318,0.9908760111821505,-0.10199753066967338},
{0.30079818017651494,0.9488942592070977,-0.09549942223024327},
{0.17910980294778037,0.9787535686487584,-0.09980546250244823},
{-0.0716012530328922,0.9920173604557133,-0.10380181654768453},
{0.0716012530328922,-0.9920173604557133,0.10380181654768453},
{-0.0054997923867560255,0.09499641395305863,0.9954624220028407},
{0.0012999682096661441,0.10109752769019013,0.9948756706129591},
{0.0013000975499788997,0.10110758638682057,0.9948746482453918},
{0.028399767690850435,0.11979902004802402,0.9923918822676046},
{0.017799527517812972,0.0819978233966665,0.9964735489607095},
{0.0285001759891301,0.07460046065926686,0.9968061552970136},
{-0.005499835942340723,0.064998061136754,0.9978702339748741},
{-0.004800309533938444,0.0620039981467049,0.9980643572647016},
{-0.012700067945545263,0.09800052430420755,0.9951053238277238},
{-0.01250034313912882,0.09780268472054388,0.995127316619767},
{-0.018400118037135812,0.09810062931755562,0.9950063829864203},
{-0.018000246515064044,0.09810134350709906,0.9950136268049293},
{-0.011100676828900017,0.04420269512048475,0.9989609085034438},
{-0.013799799835355073,0.055099200791888736,0.99838551852308},
{0.0,0.05299970956238739,0.9985945277169821},
{0.0,0.04890017970849064,0.9988036706102342},
{-0.005100048807700636,0.10260098189609514,0.9947095194156514},
{-0.005199993708011419,0.10269987573322553,0.9946987964151843},
{-0.010199979141063985,0.103299788752148,0.9945979660492391},
{-0.011400025080082763,0.09920021824072019,0.9950021890072236},
{-0.010700307477753123,0.10100290236009958,0.994828586810169},
{-0.011900041293214933,0.09710033693875378,0.9952034533619748},
{-0.007100368447678373,0.09910514269928544,0.9950516345690114},
{-0.006900299306973801,0.09920430307997116,0.9950431609331785},
{0.0042001728616712555,0.10330425157396209,0.994640935290055},
{0.004100212786063943,0.10320535598092655,0.99465161878517},
{-9.999723961430016e-05,0.11319687524338777,0.9935725728076864},
{0.005999953050551069,0.09569925115628954,0.9953922110864223},
{0.013200788044564182,0.09940593421436968,0.994959395874008},
{0.02750018878944406,0.08610059108258668,0.9959068369239034},
{0.0057001738864566505,0.08770267541092074,0.9961303874209595},
{-0.015399918303650098,0.08919952679776551,0.9958947167925412},
{-0.0056002897384846255,0.09510492038033712,0.9954515010156421},
{-0.00880024865453865,0.1002028312709969,0.9949281120909662},
{-0.009399821593079229,0.10159807168689888,0.9947811192335336},
{-0.9973793843811849,-0.07229850560533355,-0.0026999441927302984},
{0.9995213999822629,0.03020064660276572,0.006700143451606965},
{0.9993478199373034,0.03550169879693212,0.006600315832669071},
{0.9995153426782661,0.03040046665074466,0.006700102847368067},
{0.9996635956225177,0.025001590526773653,0.006900438985389527},
{0.9973793843811849,0.07229850560533355,0.0026999441927302984},
{-0.999476022857814,-0.032199227549796504,0.00329992083584871},
{0.7084155711453826,0.7042154788263388,-0.047201037490206176},
{0.9247993295207292,0.3795997247902993,-0.025499981512520104},
{0.7056116003500654,0.7070116233666329,-0.04740077927521698},
{0.38162086759957614,0.922250430032309,-0.061803379501189214},
{0.38361032692900326,0.921424805089634,-0.061801663723181445},
{0.0,0.9977594183425962,-0.06690398425089675},
{-0.38162086759957614,0.922250430032309,-0.061803379501189214},
{-0.38361032692900326,0.921424805089634,-0.061801663723181445},
{-0.7056116003500654,0.7070116233666329,-0.04740077927521698},
{-0.7084155711453826,0.7042154788263388,-0.047201037490206176},
{-0.9228760850408054,0.3842316773652768,-0.025802127215055027},
{-0.9247993295207292,0.3795997247902993,-0.025499981512520104},
{-0.9999963350201482,0.0026999901045544,-0.00019999926700402964},
{-0.9999963350201482,-0.0026999901045544,0.00019999926700402964},
{-0.9247993295207292,-0.3795997247902993,0.025499981512520104},
{-0.9228760850408054,-0.3842316773652768,0.025802127215055027},
{-0.7084155711453826,-0.7042154788263388,0.047201037490206176},
{-0.7056116003500654,-0.7070116233666329,0.04740077927521698},
{-0.38361032692900326,-0.921424805089634,0.061801663723181445},
{-0.38162086759957614,-0.922250430032309,0.061803379501189214},
{0.0,-0.9977594183425962,0.06690398425089675},
{0.38361032692900326,-0.921424805089634,0.061801663723181445},
{0.38162086759957614,-0.922250430032309,0.061803379501189214},
{0.7084155711453826,-0.7042154788263388,0.047201037490206176},
{0.7056116003500654,-0.7070116233666329,0.04740077927521698},
{0.9247993295207292,-0.3795997247902993,0.025499981512520104},
{0.9228760850408054,-0.3842316773652768,0.025802127215055027},
{0.9999963350201482,0.0026999901045544,-0.00019999926700402964},
{0.9999963350201482,-0.0026999901045544,0.00019999926700402964},
{0.9228760850408054,0.3842316773652768,-0.025802127215055027},
{0.0,0.08900280363247233,0.9960313754824993},
{0.0,0.08890359133310932,0.9960402358580076},
{-0.376817415019262,-0.07380341090345419,0.9233426732677404},
{-0.2879107133569697,-0.2051076321969937,0.9354348081768304},
{-0.15561325258890973,-0.2926249209994537,0.9434803502080813},
{-0.261712412005466,-0.5649267922884514,0.7825371127026258},
{-0.4841822477833216,-0.4179846748728385,0.7686718171644761},
{-0.6338050260937855,-0.19730156460761103,0.7479059309175484},
{-0.4086217556014177,0.08160434473097329,0.9090483990251804},
{-0.3782043323554408,0.23760272175476665,0.8947102489646033},
{-0.289904297863074,0.3703054898195802,0.8825130833534418},
{-0.15709706309785784,0.45929141362728265,0.8742836554198415},
{0.0,0.4905176074455346,0.8714312805872351},
{0.15709706309785784,0.45929141362728265,0.8742836554198415},
{0.289904297863074,0.3703054898195802,0.8825130833534418},
{0.3782043323554408,0.23760272175476665,0.8947102489646033},
{0.4086217556014177,0.08160434473097329,0.9090483990251804},
{0.376817415019262,-0.07380341090345419,0.9233426732677404},
{0.2879107133569697,-0.2051076321969937,0.9354348081768304},
{0.15561325258890973,-0.2926249209994537,0.9434803502080813},
{0.0,-0.32329893634824913,0.9462968866883643},
{0.0,-0.6164161133278063,0.7874205834430803},
{0.261712412005466,-0.5649267922884514,0.7825371127026258},
{0.484105688275256,-0.4180049115865669,0.7687090323841962},
{0.6338050260937855,-0.19730156460761103,0.7479059309175484},
{0.6876316317826097,0.06400294420315157,0.7232332694956127},
{0.6367582628627629,0.3266298863687425,0.6984639088791481},
{0.48829323962689575,0.5501923826391932,0.6773906215917657},
{0.26460166567272814,0.7001044071711147,0.6632041748834214},
{0.0,0.7527748840849818,0.6582780369196911},
{-0.26460166567272814,0.7001044071711147,0.6632041748834214},
{-0.48829323962689575,0.5501923826391932,0.6773906215917657},
{-0.6367582628627629,0.3266298863687425,0.6984639088791481},
{-0.6876316317826097,0.06400294420315157,0.7232332694956127},
{0.8668348127851362,-0.4480179927638913,0.21880878753736477},
{0.7414347703988559,-0.6125287252081187,-0.27401285013391763},
{0.9141964849212734,-0.3445986750206419,0.21329917986623015},
{0.7355796504704507,-0.14109609663047934,0.6625816699316485},
{0.7398173563187712,-0.05900138418870978,0.6702157234453102},
{0.9467255382658467,-0.22540608041102972,0.23000620450105075},
{0.8255131340184442,-0.4737075367468649,-0.3068048813044926},
{0.2686077467591264,-0.5994172874438584,-0.7540217463007494},
{0.36339800676739936,-0.41899770180390844,-0.8320954359690506},
{-0.4504266187475756,-0.3273193435081738,-0.8306490886583843},
{-0.36350031806291744,-0.15740013772518077,-0.9182008034260545},
{0.47751777593006967,-0.24990930304696213,-0.8423313563683722},
{-0.26241261447757425,0.02010096627667394,-0.9647463764730024},
{-0.6997937263773644,-0.675793941534471,-0.2314979246304085},
{-0.8156837109589365,-0.5143897277397045,0.2646947140993386},
{-0.8716829936306899,-0.41529189773411207,0.260194923646559},
{-0.6901047410358564,-0.19080131080950788,0.6981047959964227},
{-0.6456179452001837,-0.2536070491058962,0.7203200215732534},
{-0.12699626318993262,0.1282962249391209,0.9835710588473838},
{-0.09070241543748507,0.07790207455986865,0.9928264393201233},
{0.5294936831780392,0.3768955036634618,0.7599909333622472},
{0.5293935308505794,0.30979621431339155,0.7897903488209058},
{0.8800130550905091,0.4332064266650097,0.19470288843877515},
{0.9108060386640546,0.3263021633905149,0.25290167674367525},
{0.8410571728045481,0.23991630886541154,-0.4848329576404815},
{0.9034011879733432,0.09340012282124227,-0.4185005503285855},
{0.33272220329346336,-0.14140943656656363,-0.9323622186068408},
{0.43742554421050306,-0.3022176485148926,-0.8469494590577846},
{-0.7965319136904457,-0.5449218327306012,-0.2619104936541466},
{-0.913154055754293,-0.2990177008767206,0.2770163984710756},
{-0.7007321293047098,-0.10910500257905502,0.7050323264732702},
{-0.12080415996287372,0.1955067323902468,0.9732335138730852},
{0.5135134901765827,0.4411115881536332,0.736019335481918},
{0.8291451647672208,0.5312289368283051,0.1741094840018974},
{0.7474460291437557,0.3772232301217884,-0.5468336750545967},
{0.21520275030872354,0.026400337398467942,-0.9762124760751668},
{-0.25230960434788774,-0.6313240318066647,-0.7333279146583673},
{-0.3651991965626513,-0.4605989866833439,-0.8089982202058733},
{-0.8836522209710431,-0.39692345688479735,-0.24821466867928121},
{-0.9216603845582063,0.24651615103471988,0.29961963022313215},
{-0.5153422134096214,0.2553209141926574,0.8180670106133714},
{-0.9025564882655324,0.3563223011290961,0.24171512821471378},
{-0.8798614692694398,0.17501222678125933,-0.4418308673826307},
{-0.8009129308436536,0.32030517136873793,-0.505908167953308},
{-0.8609880667880908,0.4583936467080846,0.22039694531950665},
{-0.5222946700100888,0.32259670791739353,0.7893919442963125},
{0.13070014769125035,0.0734000829421406,0.9887011172328937},
{0.16219840316458126,0.12669875265692013,0.9785903658252725},
{0.6975114462567504,-0.20770340844089902,0.6858112542550243},
{-0.9267317411057087,0.023100791215648935,-0.37501284440988536},
{-0.49329993587101256,-0.3015999607920077,-0.8158998939330208},
{0.9006747049061141,-0.3191910356456441,-0.2947917208907766},
{-0.5129039724566501,0.3881030058694207,0.7657059304153967},
{0.15000372013838972,0.19320479153824596,0.9696240469745512},
{0.0,-0.765657579615062,0.6432483740966665},
{0.0,0.18961143391420793,0.9818592078954079},
{0.15580630327150086,0.16890683326416236,0.9732393731952801},
{0.08100203803691584,0.9462238072904909,0.3132078804094079},
{0.0,0.9530871810636214,0.30269592876713697},
{-0.07980207567898297,0.7525195732886552,-0.6537170034003905},
{0.0,0.738431365538391,-0.6743286427174121},
{-0.1563109687255267,-0.16711172664130206,-0.9734683106681234},
{0.0,-0.19109448031565296,-0.9815716477124279},
{-0.08249877490228899,-0.9306861794128528,-0.35639470757788844},
{0.0,-0.9399918033072125,-0.34119702477491587},
{0.06899953701465995,-0.7798947669236709,0.6220958257510137},
{-0.15580630327150086,0.16890683326416236,0.9732393731952801},
{-0.08100203803691584,0.9462238072904909,0.3132078804094079},
{0.07980207567898297,0.7525195732886552,-0.6537170034003905},
{0.1563109687255267,-0.16711172664130206,-0.9734683106681234},
{0.08249877490228899,-0.9306861794128528,-0.35639470757788844},
{-0.06899953701465995,-0.7798947669236709,0.6220958257510137},
{0.20660011879510248,-0.8555004919129243,0.4748002730102355},
{-0.21580752102316378,-0.8729304221553275,-0.4375152476720767},
{-0.4278987890481405,-0.04899986133058865,-0.902497445935842},
{-0.25010056772893313,0.8087018357552508,-0.5324012085521151},
{0.16910948561707984,0.9274520222429323,0.3335187075889777},
{0.4265109294826038,0.09070232427683977,0.8999230608239043},
{0.21580752102316378,-0.8729304221553275,-0.4375152476720767},
{-0.20660011879510248,-0.8555004919129243,0.4748002730102355},
{0.4278987890481405,-0.04899986133058865,-0.902497445935842},
{0.25010056772893313,0.8087018357552508,-0.5324012085521151},
{-0.16910948561707984,0.9274520222429323,0.3335187075889777},
{-0.4265109294826038,0.09070232427683977,0.8999230608239043},
{0.7569989969769935,0.051299932027635095,0.6513991368967154},
{0.44922344558345345,-0.8773457898716912,0.16870880514231654},
{-0.3272155692871888,-0.8004380857502015,-0.5022238963814982},
{-0.7575048859222713,0.044600287672783234,-0.651304200925644},
{-0.5169044815812831,0.8336072274059927,-0.19470168807095342},
{0.21121364801081358,0.8822570088785026,0.42072718616547955},
{-0.44922344558345345,-0.8773457898716912,0.16870880514231654},
{-0.7569989969769935,0.051299932027635095,0.6513991368967154},
{0.3272155692871888,-0.8004380857502015,-0.5022238963814982},
{0.7575048859222713,0.044600287672783234,-0.651304200925644},
{0.5169044815812831,0.8336072274059927,-0.19470168807095342},
{-0.21121364801081358,0.8822570088785026,0.42072718616547955},
{0.6729085258050332,-0.7184091023009895,-0.17630223376345278},
{-0.29889563914443706,-0.7825885821158798,-0.5460920325753666},
{-0.9322297898789109,-0.05060161700050728,-0.3583114500253312},
{-0.693535128443906,0.6981353614516089,0.17780900625425594},
{0.18340434490039664,0.8191194051685654,0.5435128759725495},
{0.9135617360202878,0.14380971827007927,0.3804257081358703},
{0.29889563914443706,-0.7825885821158798,-0.5460920325753666},
{-0.6729085258050332,-0.7184091023009895,-0.17630223376345278},
{0.9322297898789109,-0.05060161700050728,-0.3583114500253312},
{0.693535128443906,0.6981353614516089,0.17780900625425594},
{-0.18340434490039664,0.8191194051685654,0.5435128759725495},
{-0.9135617360202878,0.14380971827007927,0.3804257081358703},
{0.9397510768590787,0.2800152192407599,0.19611065890397503},
{0.724011453951803,-0.4944078215936069,-0.4810076096005763},
{-0.3012174274384113,-0.7058408376030234,-0.6411370940596463},
{-0.9720516902229779,-0.19621043376723074,-0.12890685480426115},
{-0.7312917583883242,0.4701947009355805,0.49409443158713384},
{0.17759860052854173,0.7333942208763091,0.6561948292051186},
{-0.7213106971169579,-0.49920740330068675,-0.48010712004138567},
{-0.9407063309749113,0.27820187230490095,0.19410130630618716},
{0.29099917792848357,-0.7096979951059958,-0.6415981874876806},
{0.9696496812741627,-0.20291039638049466,-0.13640698899112602},
{0.7314156634341504,0.47051007608117,0.4936105707835612},
{-0.17750649508148472,0.7339268548749388,0.6556239897206838},
{0.703935475722221,-0.28441433342150824,-0.6508327995454205},
{-0.2459065338234067,-0.6794180523774807,-0.6913183685730827},
{-0.9229460100054268,-0.38301909397776407,-0.038301909397776404},
{-0.7227269076236655,0.2664099186259091,0.6377237428969303},
{0.18369780941668395,0.6749919507689803,0.7145914785474271},
{0.9130869840378131,0.40169427388893825,0.07009900074586649},
{0.22969608830892385,-0.6788884386283344,-0.6973881235813824},
{-0.7000300109298666,-0.2901124373867919,-0.6525279744739113},
{0.9170018110803653,-0.39510078032481166,-0.05480010823032063},
{0.722301119567603,0.26690041369596185,0.6380009889022992},
{-0.1839041875460262,0.6750153702749738,0.7145162697206945},
{-0.9138956361587559,0.4002980885811905,0.06749967768980854},
{0.8170386264141172,0.5757272181476222,0.03140148454027329},
{0.7337944635416588,-0.1560988222388293,-0.6611950113024595},
{-0.094806544721681,-0.7317505144815822,-0.6749465931715455},
{-0.8087110713303503,-0.5877080457782204,-0.024200331304803358},
{-0.7638303514020315,0.10970435918932031,0.6360252729663419},
{0.03760160599888905,0.716930620760733,0.6961297323358158},
{-0.7256971915573031,-0.1622993719026461,-0.6685974125330202},
{-0.8176342882128294,0.5749241099480866,0.03060128329172282},
{0.08880633300541797,-0.7265518122571639,-0.6813485887003521},
{0.8033917813441149,-0.5942939204042912,-0.03709962047282383},
{0.7637166148356856,0.10940238007466807,0.6362138409826675},
{-0.03800143420119064,0.7164270384666572,0.6966262911723526},
{0.7554357291777372,-0.03950186828504186,-0.6540309331244906},
{0.09369968048463433,-0.7727973647654793,-0.6276978595539484},
{-0.6508994695171485,-0.7590993813342563,0.009899991931509864},
{-0.7676940004948292,-0.020299841357359686,0.6404949945511763},
{-0.13500202504556363,0.7530112952541438,0.6440096602173554},
{0.6575292376875951,0.7531334888251374,-0.021100938274081},
{-0.09200086757227183,-0.7725072847780433,-0.6283059249528086},
{-0.7535359822022457,-0.04250202952036556,-0.6560313262437601},
{0.6496780997203814,-0.7601743749537231,0.007299753929442487},
{0.7676940004948292,-0.020299841357359686,0.6404949945511763},
{0.13500202504556363,0.7530112952541438,0.6440096602173554},
{-0.6575292376875951,0.7531334888251374,-0.021100938274081},
{0.4823862570113038,0.8758750466753752,0.012099655285731294},
{0.7178332220902953,0.15460715538473063,-0.6788314170449881},
{0.19460630923881994,-0.7210233759567789,-0.6650215603484855},
{-0.5210172355352319,-0.8528282120238883,0.035001157857453204},
{-0.6953142749485985,-0.1567032171500725,0.7014144001854552},
{-0.22220360417168974,0.6844111012380939,0.6944112634420403},
{-0.7178332220902953,0.15460715538473063,-0.6788314170449881},
{-0.4823862570113038,0.8758750466753752,0.012099655285731294},
{-0.19460630923881994,-0.7210233759567789,-0.6650215603484855},
{0.5210172355352319,-0.8528282120238883,0.035001157857453204},
{0.6953142749485985,-0.1567032171500725,0.7014144001854552},
{0.22220360417168974,0.6844111012380939,0.6944112634420403},
{-0.3508256813798499,0.026401932692212193,0.9360685227238869},
{-0.8941185129154668,0.3943081642350616,-0.21230439580802327},
{-0.7375025148878637,-0.5302018079912478,0.4183014264102961},
{-0.14280334092324182,-0.9811229536400037,0.13040305081506112},
{-0.5391975358728915,-0.64129706927909,-0.5458975052541015},
{-0.08350031145674261,0.1373005121318654,-0.9870036815305983},
{0.22699535345267172,0.8494826112689191,-0.4762902504383592},
{-0.031199254814698017,0.8626793951487174,0.5047879432839603},
{0.35660458239832593,-0.15850203676425872,0.9207118312230473},
{0.3508256813798499,0.026401932692212193,0.9360685227238869},
{0.7375025148878637,-0.5302018079912478,0.4183014264102961},
{0.8941185129154668,0.3943081642350616,-0.21230439580802327},
{0.031199254814698017,0.8626793951487174,0.5047879432839603},
{-0.22699535345267172,0.8494826112689191,-0.4762902504383592},
{0.08350031145674261,0.1373005121318654,-0.9870036815305983},
{0.5391975358728915,-0.64129706927909,-0.5458975052541015},
{0.14280334092324182,-0.9811229536400037,0.13040305081506112},
{-0.35660458239832593,-0.15850203676425872,0.9207118312230473},
{-0.8462196155980369,0.5324123414611143,0.021200491433087196},
{-0.39639493806896103,-0.2606966709247683,-0.8802887587843249},
{0.39639493806896103,-0.2606966709247683,-0.8802887587843249},
{0.8462196155980369,0.5324123414611143,0.021200491433087196},
{-0.6908079996029534,0.5496063644785512,-0.46980544037849953},
{-0.8327318317826664,0.5149196831810916,-0.20350777923354463},
{-0.34402914738410184,0.9384795113524453,-0.030002541923032137},
{-0.3453976495769919,0.6361956707031913,-0.6898953052784214},
{0.0,0.6645438314339009,-0.7472492864520854},
{0.0,0.9964743610445314,-0.08389784133631327},
{0.34402914738410184,0.9384795113524453,-0.030002541923032137},
{0.3453976495769919,0.6361956707031913,-0.6898953052784214},
{0.6908079996029534,0.5496063644785512,-0.46980544037849953},
{0.8327318317826664,0.5149196831810916,-0.20350777923354463},
{0.5329138399521377,0.8423218753831593,0.08060209326354344},
{-0.5329138399521377,0.8423218753831593,0.08060209326354344},
{-0.9969811126980195,0.03520286404551137,-0.06920563045310758},
{-0.9739669820126087,0.16351124505499695,0.15701079800388085},
{-0.8248850944610134,0.04129925372922761,-0.5637898124101338},
{-0.41072618462893173,0.05400344282922404,-0.9101580244236445},
{0.0,0.04360213742916645,-0.9990489745811304},
{0.4106888027224385,0.05399852775021106,-0.9101751844118908},
{0.8248850944610134,0.04129925372922761,-0.5637898124101338},
{0.9969811126980195,0.03520286404551137,-0.06920563045310758},
{0.9739669820126087,0.16351124505499695,0.15701079800388085},
{-0.7388971737237159,0.5787977861027023,0.3449986803825713},
{-0.7751274012379592,0.4740167567885339,0.4177147664779971},
{-0.958107406198875,0.12580097244527552,0.2573019889520619},
{-0.9557912641077689,-0.1959982085845603,0.21919799653946742},
{-0.9680500059146167,-0.24631272361236578,-0.04700242797312705},
{-0.9430585346278286,-0.13229418315264735,0.3051865812410278},
{-0.9350810601249387,-0.35229286438029717,-0.03889921210443815},
{-0.561191972206256,-0.826088182893065,0.05139926473877684},
{-0.5932347616093145,-0.5996351366502782,0.537131474140868},
{-0.741123920160541,0.0780025175718826,0.6668215220119399},
{-0.4204163355940854,0.17530681167850423,0.8902345907370477},
{-0.4150876077444535,-0.044898659570527494,0.9086728719763547},
{-0.3280198375995364,0.35122124074682065,0.8769530353385167},
{-0.28148770347825447,0.2603886251713587,0.9235596551776761},
{-0.1971075710472087,0.3134120383875962,0.92893568110478},
{0.0,0.22499096004483446,0.9743608509674965},
{0.1971075710472087,0.3134120383875962,0.92893568110478},
{0.28148770347825447,0.2603886251713587,0.9235596551776761},
{0.4150876077444535,-0.044898659570527494,0.9086728719763547},
{0.3280198375995364,0.35122124074682065,0.8769530353385167},
{0.4204163355940854,0.17530681167850423,0.8902345907370477},
{0.5932347616093145,-0.5996351366502782,0.537131474140868},
{0.741123920160541,0.0780025175718826,0.6668215220119399},
{0.9430585346278286,-0.13229418315264735,0.3051865812410278},
{0.561191972206256,-0.826088182893065,0.05139926473877684},
{0.9350810601249387,-0.35229286438029717,-0.03889921210443815},
{0.9680500059146167,-0.24631272361236578,-0.04700242797312705},
{0.9557912641077689,-0.1959982085845603,0.21919799653946742},
{0.958107406198875,0.12580097244527552,0.2573019889520619},
{0.7388971737237159,0.5787977861027023,0.3449986803825713},
{0.7751274012379592,0.4740167567885339,0.4177147664779971},
{-0.4044138918557819,0.798727436758687,0.4455153037135283},
{-0.4499006523564189,0.2570003726508105,0.8553012401876974},
{-0.7322363051760382,0.12200604920988345,0.6700332210706714},
{-0.8038097703671386,0.01460017746623566,0.5947072287102978},
{-0.6715857994684037,0.3736920983641192,0.6397864718580772},
{-0.39390813625658244,0.5698117695836524,0.7212148968475431},
{-0.3203957643959918,0.288796182139708,0.9021880731525088},
{0.0,0.40938319107125487,0.9123625391631972},
{0.0,0.19569305497671613,0.9806651968097368},
{0.3203957643959918,0.288796182139708,0.9021880731525088},
{0.39390813625658244,0.5698117695836524,0.7212148968475431},
{0.6715857994684037,0.3736920983641192,0.6397864718580772},
{0.8038097703671386,0.01460017746623566,0.5947072287102978},
{0.7322363051760382,0.12200604920988345,0.6700332210706714},
{0.4499006523564189,0.2570003726508105,0.8553012401876974},
{0.4044138918557819,0.798727436758687,0.4455153037135283},
{-0.3323144410378097,-0.22620983016175916,0.9156397899916299},
{-0.3494981651394495,-0.33159825911370944,0.8762953994612291},
{-0.3232205558648961,-0.11210712967962518,0.9396597595626746},
{0.0,0.3004947879631038,0.9537834567694123},
{0.0,0.08080244309880119,0.9967301365912767},
{0.3232205558648961,-0.11210712967962518,0.9396597595626746},
{0.3494981651394495,-0.33159825911370944,0.8762953994612291},
{0.3323144410378097,-0.22620983016175916,0.9156397899916299},
{0.0,0.8434390521321915,0.5372248740875187},
{0.892123828945711,0.1241033148438098,0.43441160328888784},
{0.45791829420128727,0.8737349064067803,0.16400655219264276},
{-0.11330336119406546,0.21630641682503407,0.969728767430585},
{-0.25800009288005016,0.9658003476881878,0.025800009288005018},
{-0.9172288289551482,0.34731091615364473,0.19510613228210794},
{-0.790578828582452,-0.49258680870189203,0.3637902578273413},
{-0.149098036391791,-0.8851883421463005,0.4406941960956559},
{0.49040733654863256,-0.6884102986951033,0.5344079948034038},
{-0.45791829420128727,0.8737349064067803,0.16400655219264276},
{-0.892123828945711,0.1241033148438098,0.43441160328888784},
{0.11330336119406546,0.21630641682503407,0.969728767430585},
{0.25800009288005016,0.9658003476881878,0.025800009288005018},
{0.9172288289551482,0.34731091615364473,0.19510613228210794},
{0.790578828582452,-0.49258680870189203,0.3637902578273413},
{0.149098036391791,-0.8851883421463005,0.4406941960956559},
{-0.49040733654863256,-0.6884102986951033,0.5344079948034038},
{-0.7891945979814652,-0.28559804508807207,-0.5436962784117113},
{-0.8450399713359887,-0.41381957412879544,-0.3386160169164092},
{-0.3921980919609239,-0.33169838629127607,-0.8579958258604607},
{0.0,-0.3672143491810469,-0.9301363457878314},
{0.3921980919609239,-0.33169838629127607,-0.8579958258604607},
{0.7891945979814652,-0.28559804508807207,-0.5436962784117113},
{-0.36850465240060504,-0.5207065739619947,-0.770109722696624},
{0.0,-0.543620263823008,-0.8393312866568261},
{0.36850465240060504,-0.5207065739619947,-0.770109722696624},
{0.8450399713359887,-0.41381957412879544,-0.3386160169164092},
{0.0,-0.9012013518030415,0.4334006501014627},
{-0.7753257916414455,-0.5057168229499278,0.37831258477745244},
{0.7753257916414455,-0.5057168229499278,0.37831258477745244},
{0.8484094258810826,-0.3979044207426718,0.34910387856563646},
{0.9726022321246841,0.19360044431352955,0.12870029536751681},
{-0.8484094258810826,-0.3979044207426718,0.34910387856563646},
{-0.9726022321246841,0.19360044431352955,0.12870029536751681},
{0.7977116745957872,-0.42880627562576606,0.42400620537622385},
{0.8072019615031497,0.497101207957403,0.31830077347181934},
{0.0,0.22179830879434317,0.9750925649475384},
{0.0,0.9929297386910174,0.11870355522471927},
{-0.8072019615031497,0.497101207957403,0.31830077347181934},
{-0.7977116745957872,-0.42880627562576606,0.42400620537622385},
{0.0,-0.7772751467073875,0.6291608270633267},
{-0.23421420200872123,-0.9670586393784519,-0.09970604585939158},
{-0.17339886510814181,-0.9847935545472782,-0.010699929969187527},
{0.0,-0.9957125759292514,-0.09250116829713342},
{0.0,-0.9876784984731298,-0.15649659310625172},
{0.23421420200872123,-0.9670586393784519,-0.09970604585939158},
{0.17339886510814181,-0.9847935545472782,-0.010699929969187527},
{0.0,-0.9991876451211515,-0.0402995016997422},
{-0.3647902638777839,-0.9202754381763283,-0.14149622351619084},
{-0.2546155167423998,-0.9660588734216741,0.04360265722689958},
{-0.17569810686309778,-0.975889484847451,-0.12949860466005217},
{0.2546155167423998,-0.9660588734216741,0.04360265722689958},
{0.3647902638777839,-0.9202754381763283,-0.14149622351619084},
{0.17569810686309778,-0.975889484847451,-0.12949860466005217},
{0.0,-0.5381367425404382,-0.842857548063708},
{-0.08690508496528634,-0.5361313699642118,-0.8396491293078758},
{0.08690508496528634,-0.5361313699642118,-0.8396491293078758},
{0.6474372546114764,0.21541239518583877,-0.7310420653706969},
{0.12760218456809985,-0.7220123609574303,-0.6800116418989648},
{0.42189787785901156,0.9046954493933343,0.0593997012202543},
{-0.2188088903858282,0.6083247167353716,0.7629309985162174},
{-0.6176305858239338,-0.1976097858789011,0.7612376974241878},
{-0.5065094338260583,-0.8537159006067245,0.12090225182541056},
{-0.12760218456809985,-0.7220123609574303,-0.6800116418989648},
{-0.6474372546114764,0.21541239518583877,-0.7310420653706969},
{-0.42189787785901156,0.9046954493933343,0.0593997012202543},
{0.2188088903858282,0.6083247167353716,0.7629309985162174},
{0.6176305858239338,-0.1976097858789011,0.7612376974241878},
{0.5065094338260583,-0.8537159006067245,0.12090225182541056},
{-0.5533215854960836,0.29301143059886586,-0.7797304178769137},
{-0.5188426999170569,0.3334274405403753,-0.7871647823915101},
{-0.5192041406695328,0.33300265570676896,-0.7871062771975911},
{-0.44358661054023824,0.3329899488500887,-0.8320748841986749},
{-0.44471291909795235,0.3341097060279422,-0.8310241416019754},
{-0.37161778976940457,0.14530695601048033,-0.9169438951549168},
{-0.37569427070605727,0.16249752193168568,-0.912386086218277},
{-0.2617994122609792,-0.15249965763865292,-0.9529978605222047},
{-0.2758160750292927,-0.12340719238076403,-0.953255557352871},
{-0.11739752176447305,-0.40649141905671454,-0.9060808728346595},
{-0.11880842559826255,-0.4043286739846595,-0.906864312563169},
{0.03270236544764234,-0.6294455294417763,-0.7763561558717048},
{0.033499601859597834,-0.6305925054526088,-0.7753907845352883},
{0.1435098085130557,-0.8545584067902864,-0.4991341144868717},
{0.14440028519084488,-0.8575016935675173,-0.49380097525788924},
{0.13219832836270673,-0.9908874703071564,-0.025799673765187846},
{0.12269680317643933,-0.9920741518447062,0.027099293937094586},
{0.044400521931202974,-0.8612101235845044,0.5063059516614429},
{0.035698662396179554,-0.8213692238717615,0.5692786695278718},
{0.06010485486519911,-0.5666457698273181,0.8217663767509835},
{0.060198016508033546,-0.566481334747525,0.8218729197334348},
{0.12550315895426684,-0.35100883500356694,0.9279233561248142},
{0.12660144769583165,-0.3426039176981985,0.930910645024089},
{0.1597967553598233,-0.07389849950620113,0.9843800123667714},
{0.15990593421933033,-0.0729027054696009,0.9844365331176286},
{0.15730302182007402,0.139002670266944,0.9777187821582096},
{0.15560184078066472,0.14370170000116658,0.9773115616641621},
{0.12119785481695443,0.2013964353146421,0.9719827960567632},
{0.12070273153372227,0.2015045600997932,0.9720219971066947},
{0.16000002480000575,0.17600002728000633,0.971300150551535},
{0.15520741133084082,0.1789085430869035,0.9715463924478855},
{0.23871982650492102,0.1614134059400681,0.9575795302826221},
{0.28140217665425465,0.18490143021809413,0.9416072833605053},
{0.3444964775415256,0.21939775666940706,0.9127906667631482},
{0.5210983246715792,0.33289892973166135,-0.7858974733436849},
{0.5546112365374796,0.2914059039434215,-0.7794157911238939},
{0.5208103277712006,0.33330660953560126,-0.7859155848605732},
{0.4450053823726499,0.33400403980329235,-0.830910049917831},
{0.4464144618307403,0.33531086257134235,-0.8296268761979887},
{0.37200362147288263,0.1458014193837266,-0.9167089242048159},
{0.3761039058593436,0.1631016938198855,-0.9121094723060551},
{0.2617994122609792,-0.15249965763865292,-0.9529978605222047},
{0.2758160750292927,-0.12340719238076403,-0.953255557352871},
{0.11739752176447305,-0.40649141905671454,-0.9060808728346595},
{0.11880842559826255,-0.4043286739846595,-0.906864312563169},
{-0.03270236544764234,-0.6294455294417763,-0.7763561558717048},
{-0.033499601859597834,-0.6305925054526088,-0.7753907845352883},
{-0.1435098085130557,-0.8545584067902864,-0.4991341144868717},
{-0.14440028519084488,-0.8575016935675173,-0.49380097525788924},
{-0.13219832836270673,-0.9908874703071564,-0.025799673765187846},
{-0.12269680317643933,-0.9920741518447062,0.027099293937094586},
{-0.044400521931202974,-0.8612101235845044,0.5063059516614429},
{-0.035698662396179554,-0.8213692238717615,0.5692786695278718},
{-0.06010485486519911,-0.5666457698273181,0.8217663767509835},
{-0.060198016508033546,-0.566481334747525,0.8218729197334348},
{-0.12550315895426684,-0.35100883500356694,0.9279233561248142},
{-0.12660144769583165,-0.3426039176981985,0.930910645024089},
{-0.10790415924597875,-0.0871033574636214,0.9903381733206001},
{-0.10760721422947103,-0.08600576601983743,0.9904664030935697},
{-0.01840015851804845,0.1295011156569171,0.9914085410213715},
{-0.012400258858105521,0.13680285578942222,0.9905206773349613},
{0.01660026261823195,0.26240415126650984,0.9648152634982038},
{0.01789994003530132,0.25979912967437335,0.9654967655912529},
{-0.09330419411779049,0.31001393543960404,0.946142530062611},
{-0.08600624040916754,0.31082255254847996,0.9465686807822917},
{-0.20539720559002678,0.32429558798853786,0.9233874373993707},
{-0.2583035000361384,0.36240491061980856,0.8955121342716296},
{-0.32999553519061314,0.4124944189882664,0.8490885119101503},
{-0.3419926335580089,-0.21919527858454838,-0.9137803173839429},
{-0.284608223873445,-0.18190525622831918,-0.9412271971527982},
{-0.235805460138645,-0.15020347800180017,-0.960122231887672},
{-0.16371027314196962,-0.17051069988213696,-0.9716609736392039},
{-0.1596998738371495,-0.17349986293516242,-0.9717992322789099},
{-0.12250615118828062,-0.1993100076067292,-0.9722488178387463},
{-0.12230181680698311,-0.19960296512407055,-0.9722144423528125},
{-0.15239743898255667,-0.1347977347431013,-0.979083546639247},
{-0.15090411219308666,-0.13900378790483134,-0.9787266706651684},
{-0.15770227960292763,0.07260104945575488,-0.984814235592664},
{-0.15730687918024308,0.07700336743088823,-0.9845430550092138},
{-0.12489898957126153,0.3520971515455659,-0.9275924958070632},
{-0.1258056676729959,0.34551556582686865,-0.9299418948260642},
{-0.05620148233364508,0.580915321843673,-0.8120214173473276},
{-0.05510061547731234,0.5834065166871872,-0.8103090512026532},
{-0.041000945082676356,0.8709200749390936,-0.48971128797528324},
{-0.033000661669899796,0.8399168405014799,-0.541710861411658},
{-0.1315956600466963,0.9907673250324217,0.032598924905184644},
{-0.12309979442351499,0.9922983428631512,-0.013799976954057732},
{-0.14279869125599193,0.8567921475359516,0.49549545880492996},
{-0.14419871375320994,0.8611923181987824,0.48739565245017014},
{-0.03190278698969154,0.6288549360225092,0.7768678662568147},
{-0.0349014891037996,0.6335270300073652,0.7729329778890175},
{0.11800290526729194,0.39740978434933744,0.910022405027421},
{0.11670666005558954,0.39932278800511484,0.9093518936465087},
{0.2625930820763779,0.14679613270682512,0.9536748757663426},
{0.27410665264919065,0.12360299988121111,0.953723147141675},
{0.37210691939249974,-0.14860276329407543,0.916217037214212},
{0.37529808973758483,-0.1627991713543267,0.9124953554104613},
{0.44429602578982386,-0.33819697484159,0.8295925793275668},
{0.44479126216148146,-0.3387933444701212,0.8290837128104412},
{0.5203375332999642,-0.33582422387493366,0.7851566353907398},
{0.5202296409282119,-0.33601914523621534,0.7851447348956924},
{0.5544025585737117,-0.2929013517428574,0.7790035951098871},
{0.2593119052828635,-0.37801735517517326,-0.8887408030269219},
{0.3231925278751323,-0.43199001250636493,-0.841980533635091},
{0.1985076833885812,-0.32531259146753383,-0.9245357848500924},
{0.08990387224316806,-0.3104133697917616,-0.9463407597743042},
{0.08650523415754384,-0.31071880060981355,-0.9465572731805231},
{-0.016900767058719835,-0.261911887140753,-0.9649437949679746},
{-0.01850013088888906,-0.2586018296144168,-0.9658068331075165},
{0.015900377956476093,-0.12740302840597825,-0.9917235735495182},
{0.011500409076826423,-0.1331047346196171,-0.9910352517508683},
{0.10640245739313056,0.08570197931006851,-0.9906228786995784},
{0.10750052137879303,0.09020043747318263,-0.9901048020199347},
{0.12489898957126153,0.3520971515455659,-0.9275924958070632},
{0.1258056676729959,0.34551556582686865,-0.9299418948260642},
{0.05620148233364508,0.580915321843673,-0.8120214173473276},
{0.05510061547731234,0.5834065166871872,-0.8103090512026532},
{0.041000945082676356,0.8709200749390936,-0.48971128797528324},
{0.033000661669899796,0.8399168405014799,-0.541710861411658},
{0.1315956600466963,0.9907673250324217,0.032598924905184644},
{0.12309979442351499,0.9922983428631512,-0.013799976954057732},
{0.14279869125599193,0.8567921475359516,0.49549545880492996},
{0.14419871375320994,0.8611923181987824,0.48739565245017014},
{0.03190278698969154,0.6288549360225092,0.7768678662568147},
{0.0349014891037996,0.6335270300073652,0.7729329778890175},
{-0.11800290526729194,0.39740978434933744,0.910022405027421},
{-0.11670666005558954,0.39932278800511484,0.9093518936465087},
{-0.2625930820763779,0.14679613270682512,0.9536748757663426},
{-0.27410665264919065,0.12360299988121111,0.953723147141675},
{-0.37210691939249974,-0.14860276329407543,0.916217037214212},
{-0.37529808973758483,-0.1627991713543267,0.9124953554104613},
{-0.4442307840388069,-0.33812343107501264,0.8296574931080464},
{-0.4447411715959702,-0.3386313485549708,0.8291767604457362},
{-0.520223743553496,-0.3358153269612917,0.7852358389815552},
{-0.5200020566122009,-0.33600132888788364,0.7853031058799256},
{-0.5543008037367482,-0.29310042499592437,0.7790011295524568},
{-0.8510487622357885,0.4821276242936235,0.20801191838430552},
{-0.8609739602363531,0.5029847874551517,0.07569771055736578},
{-0.8603441798079788,0.5000256769777862,0.0989050789062061},
{-0.8386126463740616,0.5372081011592487,-0.09020136024676886},
{-0.8369994308405806,0.5389996334803739,-0.09439993580806548},
{-0.8234536991666411,0.5579363842179609,-0.1031067238086965},
{-0.8251214163042938,0.5572144626890712,-0.09320241910018204},
{-0.8531747968472422,0.5215457233100889,0.009100797856417658},
{-0.8477193875640929,0.530412130664144,-0.005900134937629053},
{-0.8803930185110449,0.4542963974438524,0.13609892073983781},
{-0.8773275221960636,0.46661463793079144,0.11210351674248117},
{-0.9027324718710302,0.36691319810510803,0.22460807929792112},
{-0.9029714620379063,0.3660884299580039,0.22499288921210292},
{-0.9334693593711598,0.22439263443266014,0.2797908160171939},
{-0.9306322888474021,0.242008396626984,0.2745095242731699},
{-0.9698687224830835,-0.03200226760100915,0.2415171133013659},
{-0.9640597494545161,0.0354021941189729,0.2633163195346204},
{-0.9836030983546398,-0.16650052447747818,0.06930021829603146},
{-0.9817602672038103,-0.16150991459042005,0.10030615748247139},
{-0.9887844712618172,-0.12059810602161727,-0.08809861642209355},
{-0.9891365740009981,-0.10680394914903103,-0.1010037346821361},
{-0.9966744693150662,0.012600941514519199,-0.08050601523165045},
{-0.9950369464077429,-0.0007000259924476583,-0.09950369464077428},
{-0.9797707983665256,0.18339453400736966,0.08009761272622852},
{-0.9897687220281385,0.13610945040722405,0.04280297191351351},
{-0.9244280429500308,0.2821085578929075,0.2566077843152076},
{-0.9305859761570443,0.2787257512681013,0.2373219259989969},
{-0.8776040282117343,0.23910109747655614,0.4155019071581308},
{-0.8789206812469476,0.24420574622881394,0.4097096405812657},
{-0.8489144741151765,0.11300192669927547,0.5163088031401409},
{-0.8506133504813045,0.12130190384832146,0.5116080297510409},
{-0.8198656533708957,-0.0034002722877055935,0.5725458484445448},
{-0.8186851942121428,-0.007799858940826572,0.5741896158746946},
{-0.8025131573110721,-0.060000983724192304,0.5936097323113425},
{0.8393095891668346,0.5429062027387996,0.02850032561808029},
{0.8288442946226886,0.5272281758265944,0.1872100047699895},
{0.8393143565948553,0.5429092865427702,0.028300484083920417},
{0.8338856114279112,0.5132911432377345,-0.20289649905111307},
{0.8338342295977019,0.5139210968940502,-0.2015082720843571},
{0.8461255406849243,0.4789144562510462,-0.23390706059118754},
{0.8490863892542694,0.4786923266235058,-0.22339641898410526},
{0.8636691913104848,0.4959397313233782,-0.0901072187784561},
{0.8633969737989103,0.4922982744975719,-0.1103996130500344},
{0.8806034255539882,0.462501799135498,0.10310040106134019},
{0.8778857695870116,0.4723923425821896,0.07849872754593964},
{0.9027324718710302,0.36691319810510803,0.22460807929792112},
{0.9029714620379063,0.3660884299580039,0.22499288921210292},
{0.9334693593711598,0.22439263443266014,0.2797908160171939},
{0.9306322888474021,0.242008396626984,0.2745095242731699},
{0.9698687224830835,-0.03200226760100915,0.2415171133013659},
{0.9640597494545161,0.0354021941189729,0.2633163195346204},
{0.9836030983546398,-0.16650052447747818,0.06930021829603146},
{0.9817602672038103,-0.16150991459042005,0.10030615748247139},
{0.9887844712618172,-0.12059810602161727,-0.08809861642209355},
{0.9891365740009981,-0.10680394914903103,-0.1010037346821361},
{0.9966744693150662,0.012600941514519199,-0.08050601523165045},
{0.9950369464077429,-0.0007000259924476583,-0.09950369464077428},
{0.9797707983665256,0.18339453400736966,0.08009761272622852},
{0.9897687220281385,0.13610945040722405,0.04280297191351351},
{0.9244280429500308,0.2821085578929075,0.2566077843152076},
{0.9305993764986267,0.2786998132711877,0.23729984100915982},
{0.8776040282117343,0.23910109747655614,0.4155019071581308},
{0.8788846679906991,0.2441957400424721,0.40979285122606496},
{0.8489240630936075,0.11290320028656883,0.5163146351457527},
{0.8506465443990501,0.12140664294620818,0.5115279890196497},
{0.8198984339954867,-0.0033999935060186055,0.5724989065281328},
{0.8187322013707323,-0.007800306792099318,0.5741225806851563},
{0.8025131573110721,-0.060000983724192304,0.5936097323113425},
{0.8344877414651161,-0.5506919103952539,-0.019199717958214773},
{0.815813750656652,-0.575109693555578,0.060801024809909836},
{0.8094496369736555,-0.5812356424624272,0.08340511455844189},
{0.8093087324883356,-0.5717061687428413,0.13480145451554137},
{0.8057370284959864,-0.575826462713155,0.13860636980208976},
{0.8432869544517212,-0.5320917686040091,0.07579882740121009},
{0.8515892955898311,-0.5216934423546441,0.05129935517115821},
{0.8756750698856356,-0.478286383380495,-0.0665981039789692},
{0.8806268771424418,-0.4584139910085116,-0.11980365646339375},
{0.901275737382452,-0.3705311370397231,-0.22451886711313856},
{0.9026169422790113,-0.365906868136373,-0.22670425527880778},
{0.9337572690895238,-0.23821461015007453,-0.26711638275014654},
{0.9372561245771598,-0.21981316280629504,-0.27061620498354616},
{0.9692443827164501,-0.04070186378101478,-0.24271111399637066},
{0.9770306548176999,0.04400138056497318,-0.20850654199538426},
{0.9839545765541748,0.1585087919339737,-0.08190454296146654},
{0.985217172484976,0.16590289171260406,-0.04270074428045927},
{0.989213483071662,0.1209016479006914,0.08270112722404614},
{0.9879681227506765,0.1385095505627783,0.06880474425067977},
{0.9968552622032328,-0.010800598747787837,0.0785043520093838},
{0.9968770172652973,-0.011699730265828046,0.0780981994667667},
{0.982093449458538,-0.1836987747332588,-0.04179972119678942},
{0.9777959714888962,-0.20119917106112284,-0.05859975856949204},
{0.924997077013855,-0.2883990886603197,-0.24739921821970565},
{0.9267179136304073,-0.28820557106753364,-0.24110466059813448},
{0.882070916942166,-0.22551813125902315,-0.4136332553824035},
{0.8831549471943627,-0.23141439789466148,-0.40802538608911787},
{0.8545145482340266,-0.09690164976463098,-0.5103086880793725},
{0.8549777936937498,-0.09890899964476765,-0.5091463267861599},
{0.8195691499663971,0.019501645423239466,-0.572648316376765},
{0.8223940623363047,0.011799914804922661,-0.5687958933084754},
{0.8026413370933179,0.062003193246680424,-0.5932305521601746},
{-0.7911415716261003,-0.5857307780323688,0.17610925390387597},
{-0.7736962127663077,-0.6288969215571034,0.0766996245562567},
{-0.7929882955791352,-0.5783914630050085,0.19139717499854533},
{-0.8225415846409939,-0.519226250146631,0.23201172964949618},
{-0.8186398687324346,-0.5208253648129146,0.24201178626099334},
{-0.8512424397497769,-0.5107254628526916,0.12060601296266811},
{-0.8565174303070618,-0.509610370676566,0.08170166264575242},
{-0.8756750698856356,-0.478286383380495,-0.0665981039789692},
{-0.8806268771424418,-0.4584139910085116,-0.11980365646339375},
{-0.901275737382452,-0.3705311370397231,-0.22451886711313856},
{-0.9026169422790113,-0.365906868136373,-0.22670425527880778},
{-0.9337572690895238,-0.23821461015007453,-0.26711638275014654},
{-0.9372561245771598,-0.21981316280629504,-0.27061620498354616},
{-0.9692443827164501,-0.04070186378101478,-0.24271111399637066},
{-0.9770306548176999,0.04400138056497318,-0.20850654199538426},
{-0.9839545765541748,0.1585087919339737,-0.08190454296146654},
{-0.985217172484976,0.16590289171260406,-0.04270074428045927},
{-0.989213483071662,0.1209016479006914,0.08270112722404614},
{-0.9879681227506765,0.1385095505627783,0.06880474425067977},
{-0.9968552622032328,-0.010800598747787837,0.0785043520093838},
{-0.9968770172652973,-0.011699730265828046,0.0780981994667667},
{-0.982093449458538,-0.1836987747332588,-0.04179972119678942},
{-0.9777959714888962,-0.20119917106112284,-0.05859975856949204},
{-0.924997077013855,-0.2883990886603197,-0.24739921821970565},
{-0.9267179136304073,-0.28820557106753364,-0.24110466059813448},
{-0.8821849059453879,-0.22569613837210845,-0.41329292861848654},
{-0.8832865608972131,-0.23149647780788504,-0.40769379698606795},
{-0.8559086875172677,-0.09670098151994366,-0.5080051562785045},
{-0.8567303416423334,-0.1008035700216496,-0.5058179138586346},
{-0.8197961920555319,0.022899893630241135,-0.5721973421495187},
{-0.8262178093168218,0.006600142267599883,-0.5633121423240931},
{-0.8036021496386254,0.06130016397815797,-0.5920015836063542},
{-0.3563899321266241,-0.8454761156370951,0.39768876545106174},
{-0.27379798759218676,-0.9104933078987804,0.3098977222601121},
{-0.3033961150376202,-0.8877886319393514,0.3460955682746221},
{-0.2703971054144797,-0.9141902136461442,0.30189676821239436},
{0.04849976089676816,-0.9984950774314023,0.025599873792933298},
{0.006900401546049286,-0.9999581892600987,0.00600034917047764},
{0.3005109237706222,-0.9343339636568797,-0.1916069650397711},
{0.363613857588174,-0.922135143239976,-0.1321050346188058},
{0.036900855002715734,-0.9983231314149354,0.04460103341791658},
{0.24630779576510592,-0.9390297207610006,-0.23990759319548888},
{0.7713883675511253,-0.4871926531901844,0.4093938263876467},
{0.6706457194770982,-0.7389503759642527,0.06470441105005703},
{0.8617386326088692,-0.38671733692683036,0.32841472316206644},
{0.8616204292625697,-0.20590488206263124,0.4639109994601973},
{0.9367262240177172,-0.2884080740970531,0.19840555444124597},
{0.810928147804524,-0.578120066895789,-0.09040313794737818},
{0.7411069330877887,-0.6702062698089812,-0.03980037233422479},
{0.5826897156172782,-0.7623865439962466,-0.2814950316565365},
{0.553128561530681,-0.7796402577640913,-0.2936151612102838},
{0.6069853080984241,-0.7470819171010422,-0.27099344068315145},
{0.0,-0.9934683678781843,0.11410785260207451},
{0.058704523357793796,-0.9511732907256845,0.30302334884857784},
{-0.01660072330927222,-0.9321406142513637,0.36171576029902186},
{0.0,-0.9308912031196955,0.36529654796393257},
{0.01660072330927222,-0.9321406142513637,0.36171576029902186},
{-0.058704523357793796,-0.9511732907256845,0.30302334884857784},
{-0.1417076708438398,-0.9642521963841237,0.2239121206911484},
{-0.15490567739711683,-0.9770358090186129,0.1463053621897882},
{-0.15469881346465109,-0.9861924359330244,0.059099546708215114},
{-0.10100017170043783,-0.9946016908243116,-0.023800040460103172},
{0.013900345219360335,-0.9916246273034324,-0.12840318893279618},
{0.04420004221106047,-0.9851009407718476,-0.16620015872122737},
{0.0,-0.9886097823421947,-0.15050148921960377},
{-0.04420004221106047,-0.9851009407718476,-0.16620015872122737},
{-0.013900345219360335,-0.9916246273034324,-0.12840318893279618},
{0.10100017170043783,-0.9946016908243116,-0.023800040460103172},
{0.15469881346465109,-0.9861924359330244,0.059099546708215114},
{0.15490567739711683,-0.9770358090186129,0.1463053621897882},
{0.1417076708438398,-0.9642521963841237,0.2239121206911484},
{-0.5345957633453632,0.5436956912287204,-0.6469948725859521},
{0.46490960978095225,0.785116228520167,-0.4092084584262544},
{0.3301124025559504,0.23220872424565792,-0.9149343747302},
{-0.25069254576797567,-0.5562834591572593,-0.79227644201024},
{0.7267333033167043,-0.4839221762418511,-0.48752234122319155},
{0.9935916836724115,0.11129906843069584,-0.019699835113070153},
{0.3095129100527231,0.7003292113406203,0.6432268295506025},
{-0.6737756636625348,0.6677758803707936,0.31638857225115175},
{-0.914343290607915,-0.4049191713520122,-0.0041001941282866146},
{-0.056201300513140984,-0.9782226363337101,0.19980462353248343},
{0.6856947578836138,-0.34339737473710513,0.6417950934952652},
{-0.32220563059259233,-0.2570044911927257,0.9111159218898538},
{0.014000732397468067,0.9967521414683159,-0.07930414850851555},
{-0.5696171514306483,0.7879237247405333,0.2339070430471008},
{0.1515082134828854,0.9763529295270034,0.15420835986178832},
{0.38279194422829965,0.9014810285313797,-0.20199574904419157},
{0.3434137574306895,0.8684347901945567,-0.3576143263168741},
{0.4355118787484915,0.7774212044525312,-0.4538123779014132},
{0.21121011615077534,0.8826422751641777,-0.41992011255544776},
{-0.11450827810264688,0.9454683503776625,-0.3049220436113278},
{-0.8545293749521546,0.32741125495533696,-0.4032138607146972},
{-0.09020067966468191,0.12920097353300336,0.9875074408966008},
{-0.7641952008692078,0.6445959519501325,-0.022399859329325117},
{-0.4867097002209891,0.6934138198751465,0.531310589125563},
{-0.5012163273878013,0.84212743274794,-0.19900648274176472},
{-0.8565313239232843,0.34811273071534765,-0.3810139339343506},
{-0.6732174971501294,0.5417140793318851,-0.5033130812769758},
{-0.8341914245562332,0.11939877258692669,-0.5383944653333445},
{-0.9717266985578192,0.18200500065609046,-0.15040413241030773},
{-0.9316262675729265,0.3276092370726607,0.15730443526107915},
{-0.62180853748983,-0.08710119590762977,0.7783106862790843},
{0.5558738439716434,0.8158616105351031,0.15929250466753517},
{-0.9818445865750376,0.17950815165025386,-0.06130278382262152},
{-0.9443302898798297,0.2690086285901453,0.1894060752972993},
{-0.8054624096453428,0.5698441532355554,0.16281261521015866},
{-0.6832087143827283,0.6128078164135479,0.3971050651074084},
{-0.7831112220642188,0.41870600009997244,0.45980658907563243},
{-0.41709819396873016,0.6546971651674122,0.6303972703857288},
{-0.48472977786490945,0.4681287580329361,0.7388453886663815},
{-0.21140502198594663,0.6317150065682237,0.7458177171103074},
{-0.24169322664223367,0.42898797778038167,0.8703756080653711},
{0.0,0.6085260150432266,0.7935339243004113},
{0.0,0.4210231569104626,0.9070498891158898},
{0.24169322664223367,0.42898797778038167,0.8703756080653711},
{0.21140502198594663,0.6317150065682237,0.7458177171103074},
{0.48472977786490945,0.4681287580329361,0.7388453886663815},
{0.41709819396873016,0.6546971651674122,0.6303972703857288},
{0.7831112220642188,0.41870600009997244,0.45980658907563243},
{0.6832087143827283,0.6128078164135479,0.3971050651074084},
{0.9443302898798297,0.2690086285901453,0.1894060752972993},
{0.8054624096453428,0.5698441532355554,0.16281261521015866},
{0.9818445865750376,0.17950815165025386,-0.06130278382262152},
{0.8871297282152971,0.4516151338767086,-0.0951031869611935},
{0.8334108635814106,0.4106053522756506,-0.36990482174077727},
{0.9372822386698643,0.11049790608451936,-0.3305937353080733},
{0.7169419459156046,0.05770337603477526,-0.694740646990613},
{0.8171038771670958,-0.10790051198914408,-0.5663026871126255},
{0.45610065222439905,-0.4508006446453828,-0.7673010972413535},
{0.4302042891581445,-0.12590125524177218,-0.8939089123162839},
{0.0,-0.5730931630393472,-0.8194902235399495},
{0.0,-0.09410587897789537,-0.9955621947130163},
{-0.4302042891581445,-0.12590125524177218,-0.8939089123162839},
{-0.45610065222439905,-0.4508006446453828,-0.7673010972413535},
{-0.7169419459156046,0.05770337603477526,-0.694740646990613},
{-0.8171038771670958,-0.10790051198914408,-0.5663026871126255},
{-0.9372822386698643,0.11049790608451936,-0.3305937353080733},
{-0.8334108635814106,0.4106053522756506,-0.36990482174077727},
{-0.8871297282152971,0.4516151338767086,-0.0951031869611935},
{-0.5685117256752643,0.8087166799535378,-0.15090311240879048},
{-0.48700633112345715,0.8730113492213103,0.026000338006591142},
{-0.28969748398827727,0.9221919907973397,0.256197774931987},
{0.0,0.9268192363328772,0.37550779374513965},
{0.28969748398827727,0.9221919907973397,0.256197774931987},
{0.48700633112345715,0.8730113492213103,0.026000338006591142},
{0.5685117256752643,0.8087166799535378,-0.15090311240879048},
{0.5773001068005297,0.740300136955538,-0.3445000637325176},
{0.4433177441478214,0.6341253813763446,-0.6335253573599026},
{0.5668767982074643,0.4432818568448914,-0.6943715799528368},
{0.3276087849473541,0.3610096806043798,-0.8731234131182384},
{0.2851986538655306,0.4915976796644279,-0.8227961164114957},
{0.0,0.5602952431135788,-0.8282929678225547},
{-0.2851986538655306,0.4915976796644279,-0.8227961164114957},
{-0.3276087849473541,0.3610096806043798,-0.8731234131182384},
{-0.5668767982074643,0.4432818568448914,-0.6943715799528368},
{-0.4433177441478214,0.6341253813763446,-0.6335253573599026},
{-0.5773001068005297,0.740300136955538,-0.3445000637325176},
{-0.27010269293727296,0.9142091147103107,-0.30210301198204426},
{-0.21300373079301751,0.9694169794870948,-0.12190213513459547},
{-0.08760099997112204,0.995411362685558,-0.0385004394850251},
{0.0,0.9994285840662623,-0.03380096672147255},
{0.08760099997112204,0.995411362685558,-0.0385004394850251},
{0.21300373079301751,0.9694169794870948,-0.12190213513459547},
{0.27010269293727296,0.9142091147103107,-0.30210301198204426},
{0.2250938257610379,0.8166775988406915,-0.5313854242977145},
{0.0,0.962829920404672,-0.2701083937487556},
{0.0,0.871498078348856,-0.4903989186715765},
{0.15969548866616687,0.6995802371374473,-0.6964803247087366},
{-0.15969548866616687,0.6995802371374473,-0.6964803247087366},
{-0.2250938257610379,0.8166775988406915,-0.5313854242977145},
{0.0,0.07440211305001634,0.9972283216865095},
{-0.2354957858406182,0.09229834833583464,0.9674826870522213},
{-0.22389620946926023,0.09069846448799421,0.9703835715451994},
{-0.45822267341883505,0.16040793718110244,0.8742432586266817},
{-0.4801352672306148,0.17101256133396195,0.8603631959977043},
{-0.7308143679517123,0.2452048207741651,0.6370125237893278},
{-0.7609379451167235,0.2495124422481568,0.5989298663824493},
{-0.9341101911977793,0.24040262280692232,0.26390287919611816},
{-0.9448045681411305,0.23480113526623353,0.2285011048055126},
{-0.9808473711677134,0.1569075780344762,-0.11540557364677215},
{-0.9780592917514533,0.14760894832567947,-0.14700891195037183},
{-0.8600556086931282,0.06350410599071354,-0.5062327315354204},
{-0.8556382307702453,0.06220277928226888,-0.5138229581226649},
{-0.5812108513078919,0.06790126772850284,-0.8109151399269949},
{-0.5810935469919907,0.06799924487257851,-0.8109909939950173},
{-0.23679985200013878,0.15259990462508943,-0.9594994003130624},
{-0.24350873968550377,0.15060540532499742,-0.9581343880602923},
{0.0,0.19721223444045705,-0.9803608185698786},
{0.24350873968550377,0.15060540532499742,-0.9581343880602923},
{0.23679985200013878,0.15259990462508943,-0.9594994003130624},
{0.5810935469919907,0.06799924487257851,-0.8109909939950173},
{0.5812108513078919,0.06790126772850284,-0.8109151399269949},
{0.8556382307702453,0.06220277928226888,-0.5138229581226649},
{0.8600556086931282,0.06350410599071354,-0.5062327315354204},
{0.9780592917514533,0.14760894832567947,-0.14700891195037183},
{0.9808473711677134,0.1569075780344762,-0.11540557364677215},
{0.9448045681411305,0.23480113526623353,0.2285011048055126},
{0.9341101911977793,0.24040262280692232,0.26390287919611816},
{0.7609379451167235,0.2495124422481568,0.5989298663824493},
{0.7308143679517123,0.2452048207741651,0.6370125237893278},
{0.4801352672306148,0.17101256133396195,0.8603631959977043},
{0.45822267341883505,0.16040793718110244,0.8742432586266817},
{0.2354957858406182,0.09229834833583464,0.9674826870522213},
{0.22389620946926023,0.09069846448799421,0.9703835715451994},
{-0.029299505721507677,-0.9976831692269014,-0.06139896420821063},
{-0.007499821131398999,-0.9988761770872613,-0.04679888385992975},
{-0.030699887792115185,-0.9978963526954964,-0.057099791300644194},
{0.0,-0.9968267153139604,-0.07960213336576169},
{-0.0036001641532269345,-0.9988455434008507,-0.0479021841498806},
{0.02830137066857302,-0.9975483124346851,-0.0640030997451828},
{0.02899956210991819,-0.9973849396011172,-0.06619900040264082},
{0.03920172609000045,-0.9941437731140165,-0.1007044341138532},
{0.04080116509390412,-0.9935283706076898,-0.10600302695965286},
{0.025300448580930043,-0.9858174786988474,-0.16590294148522902},
{0.023400155845556898,-0.9854065628295627,-0.16860112288721765},
{-0.038900408261927075,-0.9732102138947925,-0.22660237820443896},
{-0.0362993760190893,-0.9736832625285744,-0.22499613234972707},
{-0.07000155055151726,-0.9677214352671893,-0.24210536269317612},
{-0.0710016383817087,-0.9673223212200962,-0.24340561664940702},
{-0.06510385003001065,-0.9756576972239385,-0.2094123839674997},
{-0.0651013140832873,-0.9751196829894537,-0.21190427733100733},
{0.0,-0.9826427409755484,-0.1855080688489357},
{0.0651013140832873,-0.9751196829894537,-0.21190427733100733},
{0.06510385003001065,-0.9756576972239385,-0.2094123839674997},
{0.0710016383817087,-0.9673223212200962,-0.24340561664940702},
{0.07000155055151726,-0.9677214352671893,-0.24210536269317612},
{0.0362993760190893,-0.9736832625285744,-0.22499613234972707},
{0.038900408261927075,-0.9732102138947925,-0.22660237820443896},
{-0.023400155845556898,-0.9854065628295627,-0.16860112288721765},
{-0.025300448580930043,-0.9858174786988474,-0.16590294148522902},
{-0.04080116509390412,-0.9935283706076898,-0.10600302695965286},
{-0.03920172609000045,-0.9941437731140165,-0.1007044341138532},
{-0.02899956210991819,-0.9973849396011172,-0.06619900040264082},
{-0.02830137066857302,-0.9975483124346851,-0.0640030997451828},
{0.0036001641532269345,-0.9988455434008507,-0.0479021841498806},
{0.007499821131398999,-0.9988761770872613,-0.04679888385992975},
{0.030699887792115185,-0.9978963526954964,-0.057099791300644194},
{0.029299505721507677,-0.9976831692269014,-0.06139896420821063},
{0.04500205754110724,0.9960455402431736,0.07660350239219589},
{0.041301436695463614,0.9957346372317947,0.08250286991224572},
{0.0441007263449444,0.9960164045252748,0.07750127645653494},
{0.03400105234885555,0.99413076882345,0.1027031787125725},
{0.034900183924453924,0.9944052405294265,0.09970052542315348},
{0.029400886009050026,0.9911298681486218,0.12960390567254704},
{0.02940164756748346,0.9911555409568998,0.12940725153851562},
{0.037501607165813376,0.9852422234602489,0.1670071572450889},
{0.03739930643629315,0.9852817281197763,0.16679690678004538},
{0.057203044999130113,0.9753519193645385,0.21311134421878722},
{0.05759998588800519,0.9751997610760879,0.21369994764351927},
{0.057100977006074936,0.9739166638566792,0.2196037574524353},
{0.05630119050125986,0.9741205979978192,0.2189046287873141},
{0.034699362752054534,0.9807819881041812,0.1919964740171317},
{0.03400068325059495,0.9810197137892249,0.19090383625113458},
{0.0,0.9843904711463588,0.17599829634473702},
{-0.03400068325059495,0.9810197137892249,0.19090383625113458},
{-0.034699362752054534,0.9807819881041812,0.1919964740171317},
{-0.05630119050125986,0.9741205979978192,0.2189046287873141},
{-0.057100977006074936,0.9739166638566792,0.2196037574524353},
{-0.05759998588800519,0.9751997610760879,0.21369994764351927},
{-0.057203044999130113,0.9753519193645385,0.21311134421878722},
{-0.03739930643629315,0.9852817281197763,0.16679690678004538},
{-0.037501607165813376,0.9852422234602489,0.1670071572450889},
{-0.02940164756748346,0.9911555409568998,0.12940725153851562},
{-0.029400886009050026,0.9911298681486218,0.12960390567254704},
{-0.034900183924453924,0.9944052405294265,0.09970052542315348},
{-0.03400105234885555,0.99413076882345,0.1027031787125725},
{-0.04500205754110724,0.9960455402431736,0.07660350239219589},
{-0.0441007263449444,0.9960164045252748,0.07750127645653494},
{-0.041301436695463614,0.9957346372317947,0.08250286991224572},
{-0.043302673156523475,0.9958614764264683,0.07990493268374654},
{0.0,0.9959054924339362,0.09040049856012435},
{0.043302673156523475,0.9958614764264683,0.07990493268374654},
{-0.842010403102796,0.45230558827006484,0.2940036324373183},
{-0.8908027214064709,0.4170012739408378,-0.1805005514300269},
{-0.906895125451801,0.34749813220255904,-0.23829871914782685},
{-0.8827668677089379,0.38592923331695833,0.26792029439132714},
{-0.9170061989828577,0.2532017116493561,-0.3082020834531262},
{-0.9229529697909481,0.300917270137714,0.24001377478581376},
{-0.9090893046272464,0.2153974658637211,-0.3565958046750369},
{-0.9361976875945675,0.28309930074559075,0.2082994855009062},
{-0.8857636222570849,0.25451828143211935,-0.3881278782860728},
{-0.9342367302390883,0.3103122001639789,0.1758069119846197},
{-0.9498942484077388,0.2680983766692439,0.16069902697033756},
{-0.8825519397100229,0.2647155789702471,-0.38862287112896876},
{-0.9868888630220207,-0.011399871353177665,0.16099818314575473},
{-0.9173371207976548,0.033301347566294465,-0.39671605343991023},
{-0.9596460449218795,-0.23581131449831094,0.1532073510650604},
{-0.9148843693340737,-0.1703970887906068,-0.365993747050247},
{0.906895125451801,0.34749813220255904,-0.23829871914782685},
{0.8908027214064709,0.4170012739408378,-0.1805005514300269},
{0.842010403102796,0.45230558827006484,0.2940036324373183},
{0.8827668677089379,0.38592923331695833,0.26792029439132714},
{0.6068461402661334,0.3363255718053735,0.720154755447664},
{0.6186178721284925,0.30250873960373253,0.7251209490468313},
{0.3985191253917523,0.2569123295185475,0.8804422534376379},
{0.3936089802913292,0.16350373038016341,0.9046206391553261},
{0.25181368266818177,0.33471818740683257,0.9080493402013862},
{0.2817165964135565,0.11520678703174195,0.9525561167338039},
{0.0,0.09850363189586324,0.9951366913662285},
{0.0,0.388021233102829,0.921650434091668},
{-0.25181368266818177,0.33471818740683257,0.9080493402013862},
{-0.2817165964135565,0.11520678703174195,0.9525561167338039},
{-0.3936089802913292,0.16350373038016341,0.9046206391553261},
{-0.3985191253917523,0.2569123295185475,0.8804422534376379},
{-0.6186178721284925,0.30250873960373253,0.7251209490468313},
{-0.6068461402661334,0.3363255718053735,0.720154755447664},
{-0.7570426491989978,0.32771846253964537,-0.5652318432328581},
{-0.7485069386914827,0.24450226654651636,-0.6164057141074547},
{-0.48312687467987686,0.33831881950776727,-0.8075449209356254},
{-0.47611841185498655,0.209208090233277,-0.8541330299629153},
{-0.1854072338043431,0.3816148889953469,-0.9055353301501222},
{-0.20640123737912713,0.22090132430740883,-0.9532057144853875},
{0.0,0.39420894076016577,-0.919020843629103},
{0.0,0.23480997493960765,-0.9720412931912207},
{0.2064969748414777,0.22089676388611346,-0.9531860359268598},
{0.1854072338043431,0.3816148889953469,-0.9055353301501222},
{0.47611841185498655,0.209208090233277,-0.8541330299629153},
{0.48312687467987686,0.33831881950776727,-0.8075449209356254},
{0.7485069386914827,0.24450226654651636,-0.6164057141074547},
{0.7570426491989978,0.32771846253964537,-0.5652318432328581},
{0.7111947585139445,0.13609899695408864,-0.6896949169671928},
{0.9170061989828577,0.2532017116493561,-0.3082020834531262},
{0.6509064212235183,0.0839008276857477,-0.7545074432526417},
{0.9090893046272464,0.2153974658637211,-0.3565958046750369},
{0.6150177742705183,0.12940373982212205,-0.7778224793944865},
{0.8857636222570849,0.25451828143211935,-0.3881278782860728},
{0.8825519397100229,0.2647155789702471,-0.38862287112896876},
{0.5911525853613058,0.1920170806790234,-0.7833696838327032},
{0.9173371207976548,0.033301347566294465,-0.39671605343991023},
{0.6054816572110381,0.024699251747502295,-0.7954759014225941},
{0.9148999542550035,-0.17029999148500063,-0.36599998170000136},
{0.6392088914575207,-0.1595022186912931,-0.7523104647113468},
{0.17350188597575086,-0.06760073482398132,-0.9825106799491369},
{0.2293984664763774,-0.22489849655857574,-0.9469936693684804},
{-0.27160187677545283,-0.2069014296938188,-0.9399064947763184},
{-0.22121056858737742,-0.36301734356789334,-0.9051432442515158},
{-0.7293868492736603,-0.36389343906044,-0.5792895555034705},
{-0.6304141151300584,-0.5391120708544013,-0.55851250523499},
{-0.9066526735171464,-0.42132447755655617,0.021601254961361532},
{-0.7987502988900315,-0.6006378233546424,0.035102210455790796},
{-0.7111947585139445,0.13609899695408864,-0.6896949169671928},
{-0.40010335488069604,-0.03210026916188538,-0.9159076799180943},
{-0.17810980254273184,-0.11340624148425486,-0.9774537956500062},
{0.0,-0.1035030321657416,-0.9946291380874067},
{0.17810980254273184,-0.11340624148425486,-0.9774537956500062},
{0.40010335488069604,-0.03210026916188538,-0.9159076799180943},
{-0.6108957145815933,0.2538982189102415,0.7498947395068535},
{-0.31129750651695925,0.10319917337793187,0.944692433043917},
{-0.6048148907259168,0.25740633742204194,0.7536185543172137},
{0.6108957145815933,0.2538982189102415,0.7498947395068535},
{0.9229529697909481,0.300917270137714,0.24001377478581376},
{0.9361976875945675,0.28309930074559075,0.2082994855009062},
{0.6048148907259168,0.25740633742204194,0.7536185543172137},
{0.31129750651695925,0.10319917337793187,0.944692433043917},
{0.23540306496785893,-0.29760387482767553,0.9252120463392655},
{0.0,-0.4182208843813054,0.9083453593580576},
{-0.23540306496785893,-0.29760387482767553,0.9252120463392655},
{0.9342077352720722,0.31040257014392125,0.1758014556420791},
{0.6214427629478282,0.26591829846769804,0.7369507113232292},
{0.02029996244510421,0.09149983072546973,0.9955981581451112},
{0.04130136895656148,-0.14110467699202964,0.9891327853495147},
{-0.06329845110585193,-0.5853856757877681,0.8082802216249623},
{0.0,-0.7335907861575884,0.6795914643848106},
{0.06329845110585193,-0.5853856757877681,0.8082802216249623},
{-0.04130136895656148,-0.14110467699202964,0.9891327853495147},
{-0.02029996244510421,0.09149983072546973,0.9955981581451112},
{-0.6214427629478282,0.26591829846769804,0.7369507113232292},
{-0.6509064212235183,0.0839008276857477,-0.7545074432526417},
{-0.3057070894296068,-0.07430172307693746,-0.9492220127137152},
{0.020701703199186176,-0.3956325500288914,-0.9181755414093155},
{0.0,-0.5144222209477611,-0.8575370421125684},
{-0.020701703199186176,-0.3956325500288914,-0.9181755414093155},
{0.3057070894296068,-0.07430172307693746,-0.9492220127137152},
{0.2156022034657792,-0.011800120597848768,-0.9764099789609778},
{0.17510499669237192,0.06460184343990422,-0.9824280339839303},
{-0.3055036813415404,-0.07270087605083465,-0.949411440476787},
{-0.8081184778402462,-0.1871042781882317,-0.5585127705404993},
{-0.9741346749408927,-0.2114075251847908,0.07980284063266938},
{-0.6150177742705183,0.12940373982212205,-0.7778224793944865},
{-0.21560245680399298,-0.01170013332377884,-0.976411126268176},
{0.23540248821745074,-0.257702723932188,-0.9371099053040489},
{0.8693229591225297,-0.23700625941796793,-0.43371145447077086},
{0.4684992808541559,-0.7120989069290168,-0.5228991973503482},
{0.0,-0.9063133908792761,-0.42260624405338415},
{-0.4684992808541559,-0.7120989069290168,-0.5228991973503482},
{-0.8693229591225297,-0.23700625941796793,-0.43371145447077086},
{-0.23540248821745074,-0.257702723932188,-0.9371099053040489},
{-0.298917215138144,-0.11800679620709598,-0.9469545366821965},
{-0.8563177730598216,-0.13080271483852,-0.4996103695208302},
{-0.9891693757901808,-0.12119624782225022,0.08279743663104223},
{0.48621062381819696,-0.6855149786659276,0.5419118409030871},
{0.8802535518537901,-0.11020670462882035,0.4615280779147059},
{0.6987216816701786,-0.7133221347292663,0.05440168811057351},
{0.0,-0.9469797869321696,0.3212931420710729},
{0.0,-0.9999499937496875,0.010000499987495625},
{-0.6987216816701786,-0.7133221347292663,0.05440168811057351},
{-0.48621062381819696,-0.6855149786659276,0.5419118409030871},
{-0.8802535518537901,-0.11020670462882035,0.4615280779147059},
{-0.8785501095345367,-0.1688096283317357,0.44682548541836203},
{-0.8224392765254981,-0.38721849206064307,0.416719900934065},
{-0.7271002108590917,-0.5674001645460716,0.3865001120850488},
{-0.5241239556328509,-0.35671630409127625,0.7733353460997587},
{-0.4593422752149715,-0.5748529061475411,0.6771623221163885},
{0.07560456892215411,-0.26471599727108724,0.9613580966252216},
{0.12169603581619888,-0.5100833843043799,0.8514722637427555},
{0.6860075598449645,-0.11400125630076668,0.718607919102903},
{0.6751332916434367,-0.3661180537263548,0.6404315804598679},
{0.9868888630220207,-0.011399871353177665,0.16099818314575473},
{0.9596460449218795,-0.23581131449831094,0.1532073510650604},
{0.9891693757901808,-0.12119624782225022,0.08279743663104223},
{0.9741346749408927,-0.2114075251847908,0.07980284063266938},
{0.8785501095345367,-0.1688096283317357,0.44682548541836203},
{0.5912848603449739,-0.01159970299340723,0.8063793529209993},
{0.5177092903765745,-0.18590333606529882,0.8351149862728942},
{-0.5177092903765745,-0.18590333606529882,0.8351149862728942},
{-0.5912848603449739,-0.01159970299340723,0.8063793529209993},
{-0.5915981009731438,-0.08349973196629058,0.8018974259133942},
{0.012499948812814417,0.04949979729874509,0.9986959103486206},
{0.6512135909694667,0.19310403012316343,0.7339153169724995},
{0.9498942484077388,0.2680983766692439,0.16069902697033756},
{0.013900440233913422,0.13730434849757647,0.9904313674581189},
{-0.012499948812814417,0.04949979729874509,0.9986959103486206},
{-0.6512135909694667,0.19310403012316343,0.7339153169724995},
{-0.6860075598449645,-0.11400125630076668,0.718607919102903},
{-0.6751332916434367,-0.3661180537263548,0.6404315804598679},
{-0.013900440233913422,0.13730434849757647,0.9904313674581189},
{0.5915981009731438,-0.08349973196629058,0.8018974259133942},
{0.5241239556328509,-0.35671630409127625,0.7733353460997587},
{-0.07560456892215411,-0.26471599727108724,0.9613580966252216},
{-0.12169603581619888,-0.5100833843043799,0.8514722637427555},
{-0.5911525853613058,0.1920170806790234,-0.7833696838327032},
{-0.17510499669237192,0.06460184343990422,-0.9824280339839303},
{0.298917215138144,-0.11800679620709598,-0.9469545366821965},
{0.8563177730598216,-0.13080271483852,-0.4996103695208302},
{0.8081184778402462,-0.1871042781882317,-0.5585127705404993},
{0.7293868492736603,-0.36389343906044,-0.5792895555034705},
{0.9066526735171464,-0.42132447755655617,0.021601254961361532},
{0.6304141151300584,-0.5391120708544013,-0.55851250523499},
{0.7987502988900315,-0.6006378233546424,0.035102210455790796},
{0.7271002108590917,-0.5674001645460716,0.3865001120850488},
{0.8224392765254981,-0.38721849206064307,0.416719900934065},
{0.4593422752149715,-0.5748529061475411,0.6771623221163885},
{-0.6391986928400097,-0.15959967361900115,-0.7522984615512192},
{-0.6054816572110381,0.024699251747502295,-0.7954759014225941},
{-0.17359887421495107,-0.06759956161826434,-0.9824936285494783},
{-0.2294932002172149,-0.2248933365091574,-0.9469719416370478},
{0.27160187677545283,-0.2069014296938188,-0.9399064947763184},
{0.3055036813415404,-0.07270087605083465,-0.949411440476787},
{0.22121056858737742,-0.36301734356789334,-0.9051432442515158},
{0.9779102583324152,-0.20900219244449816,0.0031000325195116953},
{0.9220996910966553,-0.07249997571251221,0.38009987266656403},
{0.942128137076977,0.06690199805800845,0.3285098110920146},
{0.6755044009255081,0.3724024262097102,0.6364041461865186},
{0.6582235352032593,0.17150613231139317,0.7330262098207065},
{0.03269816012629308,0.6622627355242785,0.7485578798331193},
{0.020900641032490848,0.40691248019715437,0.9132280091325667},
{-0.6428071962668436,0.5596062648272023,0.5231058562028406},
{-0.6798042487898324,0.3175019843936037,0.6611041319137367},
{-0.9509156949930698,0.29830492356339544,0.08230135839513056},
{-0.9745456585336785,0.1631076417720297,0.15380720603640813},
{-0.9233581087542334,0.20861312843727187,-0.3223202842537522},
{-0.9217375062622102,0.12020489123653864,-0.3687150033187338},
{-0.6660979917175825,0.23189930082466204,-0.7088978626761661},
{-0.6475041634651566,0.13050083912309335,-0.7508048276905631},
{-0.22619914496884802,0.22559914723683516,-0.9475964180923094},
{-0.21630669046940593,0.10530325708011301,-0.9706300220508802},
{0.41191815363305473,0.10680470698715767,-0.9049398815793912},
{0.3668019715658958,-0.01900010212582339,-0.9301049993278072},
{0.8863937021951188,-0.027799802483105034,-0.46209671681449055},
{0.8558477533576351,-0.18391026155932355,-0.48342697356050573},
{0.9981775961552787,-0.059798657834187204,0.008099818201620675},
{0.974132288149795,0.055301833009633164,0.21910726243057188},
{0.642199328902052,0.660499309778582,0.3889995934956373},
{0.05660176373843757,0.8914277773223188,0.44961401019083974},
{-0.5243258472797282,0.8074398037262113,0.27041333035368775},
{-0.9436056191881935,0.32880195802149004,-0.03870023046055859},
{-0.9284378624680629,0.21320869482786625,-0.30421240603488237},
{-0.7228023238132065,0.21820070151638307,-0.6557021080856662},
{-0.2391079313416261,0.20580682672566564,-0.9489314765791258},
{0.42399834428969835,0.09659962277920958,-0.9004964835680975},
{0.9115296935634096,-0.01860060592460715,-0.4108133824639042},
{0.9989522765404829,-0.04470233933462767,0.009800512874258416},
{0.9860191289566544,-0.16580321661360378,0.016600322049371667},
{0.9717554548073379,-0.17130977607131523,0.16230926244234944},
{0.9419824321914579,0.2032962085610652,0.26709501872435076},
{0.6739422912057015,0.3460217135438087,0.6527409607804737},
{0.014900367373086431,0.48781202715379607,0.8728215196798549},
{-0.6463227412657342,0.4537159642770595,0.6135215871368218},
{-0.8871570859593532,0.4451286427240537,0.121707831542389},
{-0.9839657950726549,0.1059070817137861,0.14350959608997457},
{-0.9852032462500446,0.13460044350919206,-0.10610034960122791},
{-0.9459154469253734,0.13670223236568194,-0.29420480440368424},
{-0.767797151477852,0.12029955368948371,-0.6292976653099924},
{-0.2723111186899688,0.07680313593606171,-0.9591391624515206},
{0.3985007432045791,-0.022100041216615303,-0.9169017100232838},
{0.9003616048980213,-0.1376941281591043,-0.4127823972699947},
{-0.9220996910966553,-0.07249997571251221,0.38009987266656403},
{-0.9779102583324152,-0.20900219244449816,0.0031000325195116953},
{-0.942128137076977,0.06690199805800845,0.3285098110920146},
{-0.6755044009255081,0.3724024262097102,0.6364041461865186},
{-0.642199328902052,0.660499309778582,0.3889995934956373},
{-0.974132288149795,0.055301833009633164,0.21910726243057188},
{-0.9981775961552787,-0.059798657834187204,0.008099818201620675},
{-0.8558477533576351,-0.18391026155932355,-0.48342697356050573},
{-0.8863937021951188,-0.027799802483105034,-0.46209671681449055},
{-0.3668019715658958,-0.01900010212582339,-0.9301049993278072},
{-0.41191815363305473,0.10680470698715767,-0.9049398815793912},
{0.21630669046940593,0.10530325708011301,-0.9706300220508802},
{0.22619914496884802,0.22559914723683516,-0.9475964180923094},
{0.6475041634651566,0.13050083912309335,-0.7508048276905631},
{0.6660979917175825,0.23189930082466204,-0.7088978626761661},
{0.9217375062622102,0.12020489123653864,-0.3687150033187338},
{0.9233581087542334,0.20861312843727187,-0.3223202842537522},
{0.9745456585336785,0.1631076417720297,0.15380720603640813},
{0.9509156949930698,0.29830492356339544,0.08230135839513056},
{0.6798042487898324,0.3175019843936037,0.6611041319137367},
{0.6428071962668436,0.5596062648272023,0.5231058562028406},
{-0.020900641032490848,0.40691248019715437,0.9132280091325667},
{-0.03269816012629308,0.6622627355242785,0.7485578798331193},
{-0.6582235352032593,0.17150613231139317,0.7330262098207065},
{-0.9419824321914579,0.2032962085610652,0.26709501872435076},
{-0.6739422912057015,0.3460217135438087,0.6527409607804737},
{-0.05660176373843757,0.8914277773223188,0.44961401019083974},
{-0.014900367373086431,0.48781202715379607,0.8728215196798549},
{-0.6687020930408268,-0.15260047764024254,0.7277022777116939},
{-0.9457515212174656,-0.1620088256711742,0.2816153414135966},
{-0.9717554548073379,-0.17130977607131523,0.16230926244234944},
{0.6463227412657342,0.4537159642770595,0.6135215871368218},
{0.8871570859593532,0.4451286427240537,0.121707831542389},
{0.5243258472797282,0.8074398037262113,0.27041333035368775},
{0.9436056191881935,0.32880195802149004,-0.03870023046055859},
{0.9839657950726549,0.1059070817137861,0.14350959608997457},
{0.7683429784665343,-0.0018001006914483428,0.6400358014038553},
{0.046702664696553556,-0.12340704118960834,0.9912565577564002},
{-0.42399834428969835,0.09659962277920958,-0.9004964835680975},
{-0.9115296935634096,-0.01860060592460715,-0.4108133824639042},
{-0.3985007432045791,-0.022100041216615303,-0.9169017100232838},
{0.2723111186899688,0.07680313593606171,-0.9591391624515206},
{0.2391079313416261,0.20580682672566564,-0.9489314765791258},
{0.7228023238132065,0.21820070151638307,-0.6557021080856662},
{0.9284378624680629,0.21320869482786625,-0.30421240603488237},
{0.9852032462500446,0.13460044350919206,-0.10610034960122791},
{-0.9989522765404829,-0.04470233933462767,0.009800512874258416},
{-0.9003426682500965,-0.1377065260669091,-0.4128195639827167},
{-0.9860191289566544,-0.16580321661360378,0.016600322049371667},
{-0.6300276682725916,0.1841080852841018,0.7544331316584811},
{-0.012799844802822645,0.06209924705119423,0.9979878994700779},
{-0.6247942894062921,0.1831983255749563,0.7589930628351083},
{-0.9419380268057287,0.2534102303775047,0.2203088940495828},
{-0.9417699525611862,0.253418823382186,0.22101641660403754},
{-0.9013399753143774,0.2544112833906331,-0.3505155457091859},
{-0.9045742640726887,0.2550209368032456,-0.341628047105838},
{-0.6260831022451027,0.20109457253073013,-0.7533796665571958},
{-0.6412290066501886,0.204009228566186,-0.7397334626000382},
{-0.17600364595328927,0.13110271582088762,-0.9756202101819831},
{-0.1920988531732698,0.13319920480312097,-0.97229419542098},
{0.3382008556492472,0.03810009639336581,-0.9403023789680282},
{0.30891000575713234,0.044901454381661515,-0.9500307719950654},
{0.8300046272886957,-0.10490058482239058,-0.5478030540105392},
{0.8157665379429062,-0.09939592286286453,-0.5697766282420544},
{0.9820258276189041,-0.18320481835008476,0.04540119406710616},
{0.9813249014353149,-0.18340465395214184,0.05800147180602086},
{0.8794695225117869,-0.1664942302424247,0.4458845481387218},
{0.8699237057439767,-0.16430447735801285,0.4650126717679609},
{0.6120056641386326,-0.09180084962079489,0.7855072699034247},
{0.5927461707974352,-0.08620671490254582,0.8007623738105387},
{0.0004000160229627061,0.059302375404221175,0.998239985303433},
{0.014700790556268816,0.060603259027883695,0.9980536717793387},
{0.6302490920137399,0.18771462166134398,0.7533586813931296},
{0.6228974648124773,0.186299241763629,0.7597969076328789},
{0.939599938926006,0.2605999830610017,0.2218999855765014},
{0.9399598491489537,0.2608166067220418,0.22011401510552686},
{0.8992886600414947,0.2631966811107766,-0.3492955954103126},
{0.9022924523552038,0.263797793340688,-0.3409971475707908},
{0.6243374426391862,0.2091125408551239,-0.7526451374823828},
{0.6399374054345534,0.21221240417754683,-0.7385431691098886},
{0.17429548667680803,0.13729644475459404,-0.9750747507662392},
{0.19209649811275883,0.13969745333863826,-0.9713822918622277},
{-0.34001276941933783,0.040801532330320536,-0.9395352849101997},
{-0.3080144369749995,0.04850227335482946,-0.9501445343180096},
{-0.8306167412491314,-0.1083021828524933,-0.5462110089938305},
{-0.8140430925116834,-0.10170538391700025,-0.5718302706365854},
{-0.9806024809274152,-0.190700482472831,0.04530011460943494},
{-0.9799733145460944,-0.19091428283176795,0.05660423472120516},
{-0.8781875781245605,-0.17489752609199002,0.44519370277961096},
{-0.8686179762350292,-0.17270357413745055,0.4644096110563522},
{-0.6116920144128775,-0.0988987088857832,0.7848897533311551},
{-0.5913447871935014,-0.09280702900652278,0.8010606706274219},
{-0.0018999584103655907,0.05689875449989585,0.9983781457415819},
{-0.966258537715376,-0.24541486768304005,-0.07820473778652702},
{-0.8455398300918169,-0.2927137886077762,-0.4465210338687122},
{-0.8503235160220078,-0.2908080424076207,-0.4386121299861845},
{-0.5918623589439129,-0.445446932533996,-0.6717707781389427},
{-0.5329270147550842,-0.48102438374403356,-0.6961352879921451},
{-0.10060100551207517,-0.6638066347804721,-0.7411074074055557},
{-0.05690324044729353,-0.675738481023484,-0.7349418524554661},
{0.374909676543629,-0.7259187362043753,-0.5766148826221832},
{0.36940709637848285,-0.7261139487829354,-0.5799111402000059},
{0.6408042485462518,-0.7389048989557201,-0.2083013810427345},
{0.6437161285096523,-0.7394185263632699,-0.19720494103169708},
{0.6491137418833751,-0.7138151116258714,0.26290556576974167},
{0.652503229898982,-0.7156035422463012,0.24930123404416277},
{0.45768838630454434,-0.6510834789663291,0.6054846360222889},
{0.45864471774674137,-0.6513635077811876,0.6044589345968829},
{0.10000095351363765,-0.5802055322861256,0.8083077072507331},
{0.1089995509227753,-0.5817976029988134,0.805996679300522},
{-0.3481203952307994,-0.5091298282447572,0.7871461163061253},
{-0.3128077295744979,-0.5143127088240544,0.7985197316663573},
{-0.8496270185687926,-0.35301122593547996,0.39181245983433727},
{-0.7659061808878198,-0.39870321754794846,0.5044040705572741},
{-0.9634961797452208,-0.24719901985782938,-0.10279959240042419},
{0.8455398300918169,-0.2927137886077762,-0.4465210338687122},
{0.966258537715376,-0.24541486768304005,-0.07820473778652702},
{0.8503235160220078,-0.2908080424076207,-0.4386121299861845},
{0.5918623589439129,-0.445446932533996,-0.6717707781389427},
{0.5329270147550842,-0.48102438374403356,-0.6961352879921451},
{0.10060100551207517,-0.6638066347804721,-0.7411074074055557},
{0.05690324044729353,-0.675738481023484,-0.7349418524554661},
{-0.374909676543629,-0.7259187362043753,-0.5766148826221832},
{-0.36940709637848285,-0.7261139487829354,-0.5799111402000059},
{-0.6408042485462518,-0.7389048989557201,-0.2083013810427345},
{-0.6437161285096523,-0.7394185263632699,-0.19720494103169708},
{-0.6490313976533105,-0.7140345422564927,0.2625126993590047},
{-0.6498042952205872,-0.7145047228918275,0.2593017139899942},
{-0.4557050241755874,-0.6411070682443912,0.6175068080500883},
{-0.47709806775673835,-0.6479973756159432,0.5936975955296071},
{-0.10820078499954278,-0.5748041702193825,0.8111058845945393},
{-0.12681294953144873,-0.577358957133323,0.8065823643305473},
{0.3481203952307994,-0.5091298282447572,0.7871461163061253},
{0.3128077295744979,-0.5143127088240544,0.7985197316663573},
{0.8496270185687926,-0.35301122593547996,0.39181245983433727},
{0.7659061808878198,-0.39870321754794846,0.5044040705572741},
{0.9634961797452208,-0.24719901985782938,-0.10279959240042419},
{0.0051998672750816835,-0.9999744759772469,0.00489987493228851},
{0.002600073245094986,-0.9999281683732602,0.011700329602927438},
{0.005799891978017855,-0.9999813755203198,0.0018999646134886077},
{0.00519992803349402,-0.9999861602873117,-0.0007999889282298494},
{0.003099984112622134,-0.999994875039398,0.0007999959000315185},
{0.0030999838491262187,-0.9999947900407158,0.0008999953110366441},
{0.001399964329363326,-0.9999745209738042,-0.00699982164681663},
{0.0013999662612196517,-0.9999759008711798,-0.006799836125924023},
{-0.0009999713762290272,-0.9999713762290272,-0.007499785321717704},
{-0.0009000608371680458,-0.9999675900936988,-0.008000540774827074},
{-0.009900555090182133,-0.9995560416805093,0.02810157555900181},
{-0.002600073245094986,-0.9999281683732602,0.011700329602927438},
{-0.0051998672750816835,-0.9999744759772469,0.00489987493228851},
{-0.005799891978017855,-0.9999813755203198,0.0018999646134886077},
{-0.00519992803349402,-0.9999861602873117,-0.0007999889282298494},
{0.0013999844532589694,-0.999988895184978,-0.004499950028332401},
{-0.0013999844532589694,-0.999988895184978,-0.004499950028332401},
{-0.0030999838491262187,-0.9999947900407158,0.0008999953110366441},
{-0.003099984112622134,-0.999994875039398,0.0007999959000315185},
{-0.001399964329363326,-0.9999745209738042,-0.00699982164681663},
{-0.0013999662612196517,-0.9999759008711798,-0.006799836125924023},
{0.0009999713762290272,-0.9999713762290272,-0.007499785321717704},
{0.0009000608371680458,-0.9999675900936988,-0.008000540774827074},
{0.009900555090182133,-0.9995560416805093,0.02810157555900181},
{0.767797151477852,0.12029955368948371,-0.6292976653099924},
{0.9459154469253734,0.13670223236568194,-0.29420480440368424},
{0.9457515212174656,-0.1620088256711742,0.2816153414135966},
{0.6687020930408268,-0.15260047764024254,0.7277022777116939},
{-0.046702664696553556,-0.12340704118960834,0.9912565577564002},
{-0.7683429784665343,-0.0018001006914483428,0.6400358014038553},
{0.40949345839425283,0.007099886580217816,-0.9122854263567202},
{-0.25740662058342323,0.03620093109992199,-0.9656248361901844},
{0.42782043105253903,0.006100291326368603,-0.9038431640609743},
{0.9064237440809684,-0.02530066275954159,-0.4216110442459579},
{0.899606184813781,-0.024700169814251213,-0.4360029975309121},
{0.9991229501177493,-0.041000941802449925,0.008500195251727424},
{0.9991525667993454,-0.040902151918820163,0.004600242025099579},
{0.9840464776127325,-0.04730223413727871,0.1715081005188858},
{0.9841217198060368,-0.04720104173848688,0.17110377630201495},
{0.9566942885521459,-0.05039969911469442,0.2866982884163272},
{0.957228712505854,-0.05040151181602072,0.28490854596000603},
{0.6459042306865667,-0.07720050566496817,0.7595049747738772},
{0.6463335003335059,-0.07720400158710608,0.7591393472120754},
{-0.0378991294669941,-0.0847980522111108,0.9956771295589979},
{-0.05739870395189699,-0.0843980943125454,0.9947775381767792},
{-0.6930385166858769,-0.03720206756235876,0.7199400117780127},
{-0.7196906800660393,-0.03339956747840171,0.6934910193494488},
{-0.986143499749182,0.02560112929072007,0.16390723010738356},
{-0.9865663093500521,0.02580173419283461,0.16131084206605514},
{-0.9935967410080343,0.04319985830469714,-0.10439965756968476},
{-0.9933048721723471,0.04330021238806265,-0.10710052532936512},
{-0.9485573942015068,0.050703067881936105,-0.3125189095286989},
{-0.9482600789205103,0.05070321240378599,-0.313419857344113},
{-0.7470359893256995,0.050902452284709646,-0.662831932697555},
{-0.7501271926036067,0.05100184885053185,-0.6593239009246206},
{-0.2559071629417375,0.03610101048142526,-0.9660270394752576},
{0.25740662058342323,0.03620093109992199,-0.9656248361901844},
{-0.40949345839425283,0.007099886580217816,-0.9122854263567202},
{-0.42782043105253903,0.006100291326368603,-0.9038431640609743},
{-0.9064237440809684,-0.02530066275954159,-0.4216110442459579},
{-0.899606184813781,-0.024700169814251213,-0.4360029975309121},
{-0.9991229501177493,-0.041000941802449925,0.008500195251727424},
{-0.9991525667993454,-0.040902151918820163,0.004600242025099579},
{-0.9840464776127325,-0.04730223413727871,0.1715081005188858},
{-0.9841217198060368,-0.04720104173848688,0.17110377630201495},
{-0.9566942885521459,-0.05039969911469442,0.2866982884163272},
{-0.957228712505854,-0.05040151181602072,0.28490854596000603},
{-0.6459042306865667,-0.07720050566496817,0.7595049747738772},
{-0.6463335003335059,-0.07720400158710608,0.7591393472120754},
{0.0378991294669941,-0.0847980522111108,0.9956771295589979},
{0.05739870395189699,-0.0843980943125454,0.9947775381767792},
{0.6930385166858769,-0.03720206756235876,0.7199400117780127},
{0.7196906800660393,-0.03339956747840171,0.6934910193494488},
{0.986143499749182,0.02560112929072007,0.16390723010738356},
{0.9865663093500521,0.02580173419283461,0.16131084206605514},
{0.9935967410080343,0.04319985830469714,-0.10439965756968476},
{0.9933048721723471,0.04330021238806265,-0.10710052532936512},
{0.9485573942015068,0.050703067881936105,-0.3125189095286989},
{0.9482600789205103,0.05070321240378599,-0.313419857344113},
{0.7470359893256995,0.050902452284709646,-0.662831932697555},
{0.7501271926036067,0.05100184885053185,-0.6593239009246206},
{0.2559071629417375,0.03610101048142526,-0.9660270394752576},
{0.03020130623474259,0.9995432311796429,0.0011000475780866506},
{-0.01960036329610057,0.999418524394026,0.027900517140877854},
{-0.020799529415970384,0.9993773893423463,0.0284993552093825},
{-0.09230568205114337,0.9948612405685529,0.04160256092445898},
{-0.09300198747370869,0.994921261694546,0.038500822771374024},
{-0.07250421297969634,0.9973579531676021,0.004500261495291496},
{-0.059501584845818835,0.9982265881192666,-0.001800047944915528},
{-0.03430092648053652,0.9993269921865934,-0.013000351144226673},
{-0.03420104092452105,0.9993304150840316,-0.013000395673063556},
{-0.03349927726088956,0.999278440800207,-0.017899613819997703},
{-0.03409972532781872,0.999291950735755,-0.01589987192704744},
{-0.00010000372720837088,0.9993372459932501,-0.036401356703847},
{-0.006900125824941637,0.9994182245574886,-0.03340060906565952},
{0.006899897502783889,0.9988851616711343,-0.04669930628695762},
{0.00839973957011188,0.9988690305458044,-0.04679854903348048},
{0.011700382959801515,0.9993327086948421,-0.03460113251360106},
{0.01629937012301216,0.9993613804256659,-0.03179877116023232},
{0.041799037379253605,0.9990769915218248,-0.009899772010875855},
{0.044599862632634636,0.9989969230942153,-0.003999987680056918},
{0.049702379061312016,0.9987478062078935,0.0057002728500901104},
{0.04650046268190553,0.9987099372133131,0.020400202983029525},
{0.04750219512715641,0.9987461531261285,0.015800730168612026},
{0.026999377806507588,0.9994769673186791,0.017799589813179077},
{0.031199832457349558,0.9992946338022247,0.020899887767904027},
{0.03289864016281272,0.9994586882289156,-9.999586675626968e-05},
{0.01960036329610057,0.999418524394026,0.027900517140877854},
{-0.030201302761292518,0.9995431162222475,0.0012000517653493715},
{0.020799529415970384,0.9993773893423463,0.0284993552093825},
{0.09230568205114337,0.9948612405685529,0.04160256092445898},
{0.09300198747370869,0.994921261694546,0.038500822771374024},
{0.07250421297969634,0.9973579531676021,0.004500261495291496},
{0.059501584845818835,0.9982265881192666,-0.001800047944915528},
{0.03430092648053652,0.9993269921865934,-0.013000351144226673},
{0.03420104092452105,0.9993304150840316,-0.013000395673063556},
{0.03349927726088956,0.999278440800207,-0.017899613819997703},
{0.03409972532781872,0.999291950735755,-0.01589987192704744},
{0.00010000372720837088,0.9993372459932501,-0.036401356703847},
{0.006900125824941637,0.9994182245574886,-0.03340060906565952},
{-0.006899897502783889,0.9988851616711343,-0.04669930628695762},
{-0.00839973957011188,0.9988690305458044,-0.04679854903348048},
{-0.011700382959801515,0.9993327086948421,-0.03460113251360106},
{-0.01629937012301216,0.9993613804256659,-0.03179877116023232},
{-0.041799037379253605,0.9990769915218248,-0.009899772010875855},
{-0.044599862632634636,0.9989969230942153,-0.003999987680056918},
{-0.049702379061312016,0.9987478062078935,0.0057002728500901104},
{-0.04650046268190553,0.9987099372133131,0.020400202983029525},
{-0.04750219512715641,0.9987461531261285,0.015800730168612026},
{-0.026999377806507588,0.9994769673186791,0.017799589813179077},
{-0.031199832457349558,0.9992946338022247,0.020899887767904027},
{-0.03289864016281272,0.9994586882289156,-9.999586675626968e-05},
{-0.12040291077555242,0.8445204165278573,0.5218126149724522},
{-0.16230700937955336,0.33051427356711266,0.9297401516954451},
{0.7304490841753722,0.41912816426327826,0.539236235196277},
{0.18330560007162458,0.9820300014748247,-0.04490137175786113},
{0.6276972444151455,0.6742970398424926,-0.38899829230124516},
{0.9239047535021853,0.10650054794672878,-0.3675018908020923},
{0.9201167370756725,-0.3856070142553846,0.06850124604899856},
{0.5782923955049984,-0.5449928333913611,0.6070920167924684},
{0.14870705408641985,-0.22881085390028827,0.9620456357171211},
{0.17810343208620477,0.3317063920437626,0.9264178522440208},
{0.07490063291302218,0.8453071428755361,0.5290044701066586},
{-0.7363177675620994,0.3506084602842212,0.5787139645364484},
{-0.26549598174872413,0.96388541170469,-0.020899683685681108},
{-0.6987495955126247,0.6244443215086344,-0.3490247729124174},
{-0.9458262517719319,0.03380093815805804,-0.3229089624626315},
{-0.8809404272838334,-0.46152117969291534,0.10460480042443975},
{-0.5022205362175974,-0.5983244659876316,0.6243255291928437},
{-0.08380358309879472,-0.2518107663994811,0.9641412227392362},
{0.19991008071998687,0.9555481847321033,0.2167109279240678},
{0.41601339376682195,0.5731184518455906,0.7060227307677315},
{0.9015090016123218,0.41330412686231016,-0.12830128109468764},
{0.10610457798077759,0.8959386561072445,-0.4313186096428782},
{0.2643159902795125,0.44342682591727534,-0.8564518126196541},
{0.5239189504911651,-0.14210514003587432,-0.8398303772141257},
{0.78701186822846,-0.5030075854115824,-0.3572053866978474},
{0.8338193073095936,-0.46501076744898184,0.29750688885176796},
{0.6938280104021813,-0.004100165527023557,0.7201290721974788},
{-0.4280925555351883,0.5280908165805489,0.733387246506674},
{-0.2674960023021182,0.9329860566275748,0.24079640132467311},
{-0.9375372490948745,0.3385134494065227,-0.08020318653590286},
{-0.1997041798522269,0.8891186094472456,-0.4118086192446021},
{-0.34000277103387594,0.430103505357853,-0.8363068159283249},
{-0.5494478095339519,-0.1751152374397433,-0.8169710877471519},
{-0.7588489549251743,-0.5623362774834284,-0.3285211935858194},
{-0.777750512647369,-0.5361348204066537,0.32812131053054105},
{-0.6564719200141691,-0.07029699311042817,0.7510678737587851},
{0.25700246081034345,0.8719083485624064,-0.4168039909173196},
{0.7303624303969712,0.6830583869110386,-0.0014001196803447348},
{0.6432116229390407,0.07390133540919637,-0.7621137715202781},
{-0.19510550693065076,0.577516300627631,-0.792722374904802},
{-0.2995892719002564,-0.03389878610620392,-0.9534658569989805},
{-0.05970100507488073,-0.6060102022676335,-0.7932133538592193},
{0.44720556998006133,-0.791009852089062,-0.41750520005965025},
{0.8657258206576575,-0.5005149280803483,-0.0019000566700352883},
{0.983259213652823,0.11240676933948057,0.14340863632812736},
{-0.7834172471205452,0.6200136497507506,0.042900944474689034},
{-0.3472085796300053,0.8525210660558166,-0.3907096545548475},
{-0.6822924845896731,0.02929967726583236,-0.7304919536754451},
{0.10930556051529872,0.6011305802904489,-0.7916402717649631},
{0.2561116507839973,0.002500113732760614,-0.9666439736345637},
{0.07199728539353038,-0.5894777741595301,-0.8045696642727022},
{-0.3996969103548244,-0.820393658381531,-0.408896839239649},
{-0.8207333470733512,-0.5705231808277652,0.03000121897429089},
{-0.9813248180184756,0.02870072585053526,0.19020481034048106},
{-0.589390625816644,0.5986904779036728,0.5423913733338102},
{-0.6849091298995527,-0.02470032925758352,0.7282097071000938},
{0.22000673670941867,0.2860087577222442,0.9326285575236538},
{-0.0960019464591969,0.9523193084697208,0.2896058718185773},
{0.5250965317488616,0.8291945231882614,0.19159873449453796},
{0.914388382769395,0.32289589763368076,0.24419689749812584},
{0.830290281509132,-0.28559665711069265,0.4785943980853554},
{0.3254979005453122,-0.6540957810958178,0.6827955959826087},
{-0.2912010716219154,-0.5252019327466688,0.7996029425442429},
{0.7181699308544794,0.023499016116792355,0.6954708812437908},
{0.5629399082246912,0.6390453035274076,0.5241371574001789},
{-0.19870812136688376,0.25561044701245844,0.9461386694776485},
{0.03079921616992259,0.9534757343513373,0.29989236783635664},
{-0.5819982190881743,0.7803976119869609,0.22859930048721075},
{-0.9253415996666905,0.24301092480169217,0.2910130827872116},
{-0.7804845466653902,-0.35923891486700177,0.5116554255177007},
{-0.23799612545461613,-0.6869888159131147,0.6865888224249556},
{0.37080049501899126,-0.5087006791158599,0.7770010372970771},
{-0.9417676825665988,0.3277235526994525,0.075305412017909},
{-0.9450956242173897,-0.3265984878525018,0.01129994768136335},
{-0.5274929923021455,-0.04059946063974808,0.8485887265736507},
{-0.5344080535900518,0.7825117925415711,0.31950481497384275},
{0.004199960856547225,0.7471930361933539,0.6645938060145917},
{0.39510205058496384,0.284401476047491,0.8735045335002933},
{0.36430426420636897,-0.37210435550697196,0.8537099927339478},
{-0.015500508192491772,-0.8247270391192235,0.5653185342719741},
{-0.564900737195943,-0.7903010313435189,0.23730030967710622},
{0.9682433927999943,-0.2472110790127645,-0.03730167171187749},
{0.9140586717714626,0.40388173890000406,0.03709832263726207},
{0.5684117264548764,-0.006700138225277396,0.8227169728262259},
{0.4827205305407551,0.8202348853315254,0.3069130532897405},
{-0.03449942075958814,0.7362876378343404,0.6757886536037583},
{-0.3756136387788406,0.24010871850585633,0.8951325028512785},
{-0.29179450847902516,-0.411192261434459,0.8635837475068064},
{0.10999911451069228,-0.8272933403154157,0.5508955653085488},
{0.6386333758523559,-0.7434388531297235,0.19861037964966785},
{-0.8245102363581269,0.1394017306832297,-0.5484068085127918},
{-0.5916272006858417,-0.46552140283850457,-0.6582302628320166},
{-0.8986191362982633,-0.35070746839506006,0.2636056135413112},
{-0.8188170274771315,0.5716118867927801,-0.052901100089814676},
{-0.6350211433809592,0.5325177304730091,0.5596186328125744},
{-0.3453193885013664,0.09990560935791053,0.9331523933119751},
{-0.15919772269286522,-0.5233925129236536,0.8370880255414413},
{-0.11810015884482046,-0.9373012606710434,0.32790044102638977},
{-0.3200237786501634,-0.9052672638566497,-0.2794207617339239},
{0.5962339713983081,-0.4069231851089762,-0.6920394300698243},
{0.7834231034879878,0.21390630819004416,-0.5835172081762074},
{0.9358695566584748,-0.2779909571012459,0.21649295759863213},
{0.765526127852623,0.6382217828811809,-0.08150278173741186},
{0.6146430388124192,0.576640377772927,0.5382376887224927},
{0.37951784724641,0.11710550701595418,0.9177431578867732},
{0.24110188662964435,-0.5183040557451044,0.8205064204878606},
{0.21020783143864308,-0.9281345782978337,0.30721144537560013},
{0.3799888949868136,-0.8721745110723653,-0.3080909961722033},
{-0.2922958099695959,0.2992957096267535,-0.9082869797994662},
{0.17720898029262025,-0.1565079312403785,-0.9716492395728547},
{-0.6370817128318961,-0.5199850740426715,-0.5689836675582308},
{-0.7612304460205451,0.44561782284124396,-0.47111884277493277},
{-0.9890087774918505,0.14100125139165914,0.044500394942757676},
{-0.841501611477129,-0.38560073842612114,0.37840072463808155},
{-0.4050949100144333,-0.8685890862466966,0.28539641401658666},
{0.09689772971278894,-0.9877768566593695,-0.122097139297539},
{0.31190593562643304,-0.6937132014878377,-0.649212354628664},
{-0.20930435985522416,-0.15910331415655118,-0.9648200974119459},
{0.2235021657464792,0.3334032306929582,-0.9159088752000013},
{0.6502376368436623,-0.45842653449574716,-0.6058350667485245},
{0.6989254064002923,0.5128186412964229,-0.4985181214630787},
{0.9750220113703628,0.22210501407728983,0.0012000270909173695},
{0.8872907988421239,-0.3188966930584395,0.3331965447697461},
{0.4882950511547347,-0.8352915343631987,0.25269743892443464},
{-0.02089963185622725,-0.9908825457576834,-0.13309765550544725},
{-0.2838997757192657,-0.709399439574664,-0.6450994903716039},
{0.23160626040182913,0.5763155780206137,-0.7837211842699201},
{0.7513384920569474,0.20511050808050035,-0.6272321339253526},
{-0.0030999410086839014,-0.33169368792917747,-0.9433820476104493},
{-0.42240540471173016,0.5279067546101381,-0.7368094275369383},
{-0.8151366575197515,0.047402131721796366,-0.5773259629323427},
{-0.754610621219241,-0.5510077554887381,-0.35630501502838},
{-0.2351019901467699,-0.939507952968483,-0.2491021086582747},
{0.41911954400001566,-0.873740743480825,-0.24681150908900948},
{0.8118063321140858,-0.4000031200365045,-0.4254033181588225},
{-0.7944042500741069,0.14950079983141865,-0.5887031495702754},
{-0.31500923620621035,0.5644165489358258,-0.7630223721439318},
{-0.013900695260660626,-0.3190159559820676,-0.9476473977699288},
{0.3423061102186016,0.5699101729873826,-0.7470133343070271},
{0.7804014476460281,0.12180022593962869,-0.6133011376746655},
{0.7798199090564206,-0.4821123084843554,-0.3993101945194008},
{0.29970552362370106,-0.913716839956542,-0.27440505733181036},
{-0.35690627089827004,-0.9025158573429215,-0.2410042344816001},
{-0.7952282072447753,-0.4609163489928533,-0.39391397237640463},
{-0.6022969011904151,0.7139963264983503,0.35699816324917516},
{-0.02699979142741683,0.7376943013335332,0.6745947887753849},
{0.06629992110314083,0.9594988581970381,-0.2737996741785816},
{0.5798931254077472,0.6528922600081362,0.48729422316122645},
{0.8819363321155678,0.46901932164894117,-0.047001936284648695},
{0.6748316368487205,0.3364157715410634,-0.6568307929493772},
{0.09609814964794262,0.2626949418575913,-0.9600815138084257},
{-0.5094369711825467,0.36692662883171656,-0.7783564873800081},
{-0.8128357452378625,0.5314233698565455,-0.23851048872936786},
{0.02699979142741683,0.7376943013335332,0.6745947887753849},
{0.6022969011904151,0.7139963264983503,0.35699816324917516},
{-0.06620035979993327,0.9595052149250147,-0.27380148811513183},
{-0.5798931254077472,0.6528922600081362,0.48729422316122645},
{-0.8819363321155678,0.46901932164894117,-0.047001936284648695},
{-0.6748316368487205,0.3364157715410634,-0.6568307929493772},
{-0.09609814964794262,0.2626949418575913,-0.9600815138084257},
{0.5094369711825467,0.36692662883171656,-0.7783564873800081},
{0.8128357452378625,0.5314233698565455,-0.23851048872936786},
{-0.2958249553667094,0.2354198596799303,0.9257780973054863},
{0.17661087603262945,0.044802759038855035,0.9832605510491578},
{0.2133985392919978,0.8792939812532974,0.42579708542892536},
{0.6852489662143838,0.09970712482716587,0.7214515531626626},
{0.9386711597716672,0.33258978133595024,0.09099720415385289},
{0.6391086312203473,0.6607089229342568,-0.3937053170262099},
{0.024000753995530342,0.8409264181183943,-0.5406169837493209},
{-0.5012198762682979,0.8302329235393874,-0.2439096724298441},
{-0.6844934768082489,0.5999942820817376,0.41409605368341257},
{-0.17661087603262945,0.044802759038855035,0.9832605510491578},
{0.2958249553667094,0.2354198596799303,0.9257780973054863},
{-0.2133985392919978,0.8792939812532974,0.42579708542892536},
{-0.6852489662143838,0.09970712482716587,0.7214515531626626},
{-0.9386711597716672,0.33258978133595024,0.09099720415385289},
{-0.6391086312203473,0.6607089229342568,-0.3937053170262099},
{-0.024000753995530342,0.8409264181183943,-0.5406169837493209},
{0.5012320999315523,0.8302531711156719,-0.24381561445194025},
{0.6844934768082489,0.5999942820817376,0.41409605368341257},
{-0.5160909839692643,-0.8536850862518136,-0.0697987806259536},
{0.08900033553189741,-0.984503711585989,0.15110056965022137},
{-0.42620229084346994,-0.44800240801941466,0.785904224246558},
{0.4845212588366074,-0.677629731656729,0.5532242732474948},
{0.49122600619317003,-0.11620615211654388,0.8632457014371832},
{0.047699735982692004,0.3636979869372135,0.9302948508322509},
{-0.5347129268412615,0.5170124989282443,0.6684161591559737},
{-0.9376175289235564,0.20180377275679787,0.2831052927029211},
{-0.9360127626210281,-0.34930476280291145,-0.04320058904404745},
{-0.08900033553189741,-0.984503711585989,0.15110056965022137},
{0.5160909839692643,-0.8536850862518136,-0.0697987806259536},
{0.42620229084346994,-0.44800240801941466,0.785904224246558},
{-0.4845212588366074,-0.677629731656729,0.5532242732474948},
{-0.49122600619317003,-0.11620615211654388,0.8632457014371832},
{-0.047699735982692004,0.3636979869372135,0.9302948508322509},
{0.5347129268412615,0.5170124989282443,0.6684161591559737},
{0.9376175289235564,0.20180377275679787,0.2831052927029211},
{0.9360127626210281,-0.34930476280291145,-0.04320058904404745},
{-0.6761169132761311,-0.7176179514375857,0.16700417766175696},
{-0.12110101059215009,-0.9383078302115148,0.3239027029793346},
{-0.38311629619824555,-0.1924081842561797,0.9034384285708563},
{0.3628954964948326,-0.7228910289779953,0.5879927030558324},
{0.5630105481014289,-0.1128021133673911,0.8187153387755594},
{0.2494052425532983,0.5164108550702615,0.8192172201269525},
{-0.27771494007706293,0.736639628594759,0.6166331726738099},
{-0.769128050611518,0.5200189654375106,0.37151354934622144},
{-0.9820211136809187,-0.08800189206101919,0.16700359061579778},
{0.12110101059215009,-0.9383078302115148,0.3239027029793346},
{0.6761169132761311,-0.7176179514375857,0.16700417766175696},
{0.38311629619824555,-0.1924081842561797,0.9034384285708563},
{-0.3628954964948326,-0.7228910289779953,0.5879927030558324},
{-0.5630105481014289,-0.1128021133673911,0.8187153387755594},
{-0.2494052425532983,0.5164108550702615,0.8192172201269525},
{0.27771494007706293,0.736639628594759,0.6166331726738099},
{0.769128050611518,0.5200189654375106,0.37151354934622144},
{0.9820211136809187,-0.08800189206101919,0.16700359061579778},
{-0.7428199301260915,-0.42351136296230446,0.5185139119148875},
{-0.16820503529309835,-0.6660199376052527,0.726721754741347},
{-0.2577116037261925,0.2885129905898585,0.9221415203567022},
{0.4097287045498811,-0.40482836124430527,0.8174572689750373},
{0.68834754580704,0.1616111628685423,0.7071488444575883},
{0.46072534519837827,0.7393406722491014,0.49102701213892713},
{-0.10040434559411801,0.9668418458206502,0.23481016280377398},
{-0.6836443665407966,0.7114461707974294,0.16271055944439383},
{-0.9570506628177899,0.13920736913713308,0.25431346243946085},
{0.16820503529309835,-0.6660199376052527,0.726721754741347},
{0.7428584466875302,-0.42353332279505795,0.5184407899337852},
{0.2577116037261925,0.2885129905898585,0.9221415203567022},
{-0.4097287045498811,-0.40482836124430527,0.8174572689750373},
{-0.68834754580704,0.1616111628685423,0.7071488444575883},
{-0.46072534519837827,0.7393406722491014,0.49102701213892713},
{0.10040434559411801,0.9668418458206502,0.23481016280377398},
{0.6836443665407966,0.7114461707974294,0.16271055944439383},
{0.9570506628177899,0.13920736913713308,0.25431346243946085},
{-0.5903627610915084,-0.29178159499746303,0.7525525304835184},
{0.025000294380199503,-0.49080577927207664,0.8709102550286298},
{-0.053500432017732816,0.484403911577379,0.8732070511754074},
{0.5984293207628738,-0.2236109560871968,0.7693376946237948},
{0.8236895803927117,0.3018961810374647,0.4799939281152138},
{0.531802515431847,0.8221038885605894,0.20330096161582265},
{-0.08080380998946363,0.9959469600062726,0.03950186255673036},
{-0.6552941744606834,0.7384934348225465,0.15879858828682514},
{-0.8794759686474805,0.20319444778757026,0.4303882398020189},
{-0.025000294380199503,-0.49080577927207664,0.8709102550286298},
{0.5903627610915084,-0.29178159499746303,0.7525525304835184},
{0.053500432017732816,0.484403911577379,0.8732070511754074},
{-0.5984293207628738,-0.2236109560871968,0.7693376946237948},
{-0.8236895803927117,0.3018961810374647,0.4799939281152138},
{-0.531802515431847,0.8221038885605894,0.20330096161582265},
{0.08080380998946363,0.9959469600062726,0.03950186255673036},
{0.6552941744606834,0.7384934348225465,0.15879858828682514},
{0.8794759686474805,0.20319444778757026,0.4303882398020189},
{-0.022399439125066374,0.3903902247511568,-0.9203769540496022},
{-0.39642245202137333,0.5136290902073091,-0.7609430972327522},
{-0.05199879754171011,0.3435920545256076,-0.9376783164396455},
{0.11630295296946432,0.27520698759412365,-0.9543242305998263},
{0.1390049764672379,0.31921142797368585,-0.9374335607222216},
{0.2773078673357961,0.1894053735066707,-0.9419267228401959},
{0.2966996528616092,0.23969971955149216,-0.924398918453898},
{0.6113893130082122,-0.063398891797057,-0.7887862121375167},
{0.6339913238880985,0.026399638723416087,-0.7728894230806173},
{0.8466373840990605,-0.3557157069738198,-0.3958174777066007},
{0.8960624174016019,-0.25621784747577053,-0.3625252525759829},
{0.860431763424831,-0.5076187390916367,-0.04450164280846696},
{0.9136367928944896,-0.4065163707438814,-0.0035001409535143544},
{0.9370301166319306,-0.16160519407440765,-0.3096099510237414},
{0.9530887488537293,-0.3003964538407935,0.037199560861776025},
{-0.45971145155488913,0.43751089853222536,-0.7728192511673229},
{-0.7733156172665876,0.5336107763784446,-0.34240691497747267},
{-0.7184884360216827,0.630489852347489,-0.29369527301262105},
{-0.37760919678398286,0.5952144966256,-0.7093172756326246},
{-0.0044003663897590525,0.44063668893814506,-0.8976747435108465},
{0.16060621477772355,0.362514027751711,-0.9180355240719192},
{0.32580194015633046,0.28390169063960163,-0.90180537026697},
{0.6941961645767861,0.08289954198129583,-0.7149960496577384},
{-0.8231316500204267,0.42701641909697746,-0.37431439266510225},
{-0.8936037710158705,0.448401892259978,0.020200085244539596},
{-0.8317128666975725,0.5516085334500191,0.06310097617965231},
{-0.2873195225882159,-0.22111502417074327,0.9319633243994375},
{-0.6178148833398116,0.0027000650453504233,0.7863189426514955},
{-0.2684935226718974,-0.16879592784736044,0.9483771206779422},
{-0.10800246842462408,-0.2575058853642658,0.9602219461233709},
{-0.13020527732683726,-0.3021122448574311,0.9443382748059325},
{0.06180319376255865,-0.32541681634848846,0.9435487591419754},
{0.031700338878433924,-0.37170397353671575,0.9278099183410409},
{0.4810074628886805,-0.40910634733421875,0.7754120306109831},
{0.4130084977372623,-0.48360995037709453,0.7717158782175432},
{0.8381427882815405,-0.38981990081391776,0.38151947706646905},
{0.7931745103473586,-0.49364637285015284,0.3566335019415812},
{0.7454475759824972,-0.5892376063440936,0.3116198882159192},
{-0.5934081890895145,0.09720134138776677,0.7990110264282476},
{-0.8766387614397745,0.2951130487119295,0.38001680281441286},
{-0.923855411194592,0.1945906083109293,0.3295840930076172},
{-0.6753911355495186,-0.06029920857808109,0.7349903533149188},
{-0.31640642786187373,-0.26650541411248213,0.9104184953396012},
{-0.1526963765579759,-0.3455917992039062,0.9258780291750484},
{0.012800816398099513,-0.4210268518437418,0.9069578430809725},
{0.39478574059656973,-0.563379651094497,0.7257737855242916},
{-0.8196332040136556,0.3971160874985635,0.4129167275954592},
{-0.941035058914192,0.3375125742651858,-0.023200864364303138},
{0.41432491410615035,0.8449508084197114,0.3382203378003863},
{-0.41432491410615035,-0.8449508084197114,-0.3382203378003863},
{-0.4254778119106482,-0.8385562704307159,-0.3402822547431107},
{-0.426312390949717,-0.8327242034807163,-0.35331026911220975},
{-0.43949950556333434,-0.8309990651265775,-0.3409996163756474},
{-0.4406014627992847,-0.8318027615897526,-0.33760112083758176},
{-0.42609494867432507,-0.8400900407915994,-0.3356960203472681},
{-0.4404958197145062,-0.8331920930445552,-0.33429682753815987},
{-0.43063476870163336,-0.8429680597738197,-0.3224260321165969},
{0.43071870651964506,0.8368363445916854,0.33791467595307184},
{0.4306372495799233,0.8368723884079884,0.3379292304529867},
{-0.4306372495799233,-0.8368723884079884,-0.3379292304529867},
{-0.43071870651964506,-0.8368363445916854,-0.33791467595307184},
{0.3696047716284028,-0.5051065209672788,0.7799100687039809},
{-0.13460791988995693,-0.31061827576389767,0.9409553627374478},
{-0.5959980332097357,-0.01739994258028423,0.8027973507731136},
{-0.8924207668728705,0.45071048815509046,0.021100491014138915},
{-0.3696047716284028,0.5051065209672788,-0.7799100687039809},
{0.13460791988995693,0.31061827576389767,-0.9409553627374478},
{0.5959980332097357,0.01739994258028423,-0.8027973507731136},
{0.8924207668728705,-0.45071048815509046,-0.021100491014138915},
{-0.02439986433713143,0.3849978594178525,-0.922594870386781},
{-0.4047076834483061,0.5137097528722383,-0.7565143625615111},
{0.28940656815659727,0.22650514059249927,-0.9300211070685401},
{0.6246102499383029,-0.006100100103464053,-0.7809128148844392},
{0.8751393559017723,-0.2958133030233622,-0.3829172201745956},
{-0.7712034164387023,0.5357023731667697,-0.3439015234871236},
{-0.28940656815659727,-0.22650514059249927,0.9300211070685401},
{-0.6246102499383029,0.006100100103464053,0.7809128148844392},
{0.02439986433713143,-0.3849978594178525,0.922594870386781},
{0.4047076834483061,-0.5137097528722383,0.7565143625615111},
{0.7712034164387023,-0.5357023731667697,0.3439015234871236},
{-0.8751393559017723,0.2958133030233622,0.3829172201745956},
{0.16460138841856697,-0.9434079576796847,-0.2879024284672262},
{-0.6224286572750866,-0.07540347165575438,0.779035867637038},
{-0.6851440767362303,-0.062204001712149355,0.7257466887862828},
{-0.2764051467117481,-0.23360434975348898,0.9322173580488118},
{-0.26579634665432267,-0.24189667515304986,0.9331871734304512},
{-0.13330692280825682,-0.2985155023125631,0.9450490776729384},
{-0.13460429394546639,-0.27480876653948116,0.9520303702532243},
{-0.2989061724761931,-0.22150457411668376,0.9282191679237285},
{-0.9120214053935799,0.15650367318431496,0.3791088977902479},
{-0.932921597384972,0.1315030443307148,0.33520776014947223},
{-0.5953161124486281,-0.05330144262306716,0.8017216988914247},
{-0.2653959182421659,-0.2407962965814376,0.9335856415632482},
{-0.1338971955526084,-0.3071935658981427,0.9421802662409833},
{0.0019000098705769166,-0.3650018961897761,0.9310048365826892},
{0.0038000727910914773,-0.3471066488915399,0.9378179640751545},
{0.01190006771157792,-0.30740174912092877,0.9515054140812093},
{-0.15330159817749156,-0.25350264277882656,0.9551099570732041},
{-0.9761696521896142,0.20471460690832294,-0.07200513774987422},
{-0.9861342884853262,0.13500469419482716,-0.09650335548000608},
{-0.3894067504245285,0.36160626849899713,-0.8471146848603442},
{-0.36478754454193385,0.4354851306140685,-0.8229719001041983},
{0.13520760834618847,0.3011169443271994,-0.9439531177364446},
{0.13640426679219894,0.28480890896201067,-0.9488296798565861},
{-0.35382400954277893,0.3189216411622165,-0.8792596641888389},
{0.8168920557633863,-0.312196963899289,0.4849952834438026},
{0.8238030110055078,-0.24520089621091348,0.5111018680807418},
{0.9771069032846577,-0.19950140948243703,0.07390052210903306},
{0.942906666373697,-0.3321023479719003,0.02520017816588945},
{0.902010806154187,-0.1548018545373261,-0.40300482802675985},
{0.9362478949861334,-0.036701877532569,-0.34941787492859966},
{0.9868885620278487,-0.12739852345966962,0.09909885145096747},
{0.16150888727103987,0.2681147534202216,-0.9497522615560777},
{0.6263843875637075,0.0791980260138021,-0.7754806713851455},
{0.7008972910372052,0.061599761917380286,-0.7105972535469226},
{0.9482784790641237,-0.31589283089355336,0.031299289670681296},
{0.9605261746948955,-0.27420747225542985,0.04690127807724164},
{0.40060102353692273,-0.44180112880332617,0.8027020509063602},
{0.49029944351044746,-0.42429951842031993,0.7612991359259711},
{-0.13260112976643842,-0.3362028644606078,0.9324079441495263},
{-0.10729779290709962,-0.3523927513556562,0.9296808766610486},
{-0.6201021269539432,-0.17080058584701419,0.7657026263645127},
{-0.590400938738239,-0.2271003610898612,0.774501231457937},
{-0.7960292426713541,0.4242155838457141,-0.4317158593733964},
{-0.825204996631382,0.3801023015264036,-0.41780252980197696},
{-0.9473741654587571,0.31869130940648704,-0.030299173752797486},
{-0.9191079181488225,0.3940033943538636,-0.0014000120611558605},
{-0.8824002823681355,0.21520006886403306,0.4184001338880643},
{-0.9603692254612471,0.27479119445725814,-0.046698503570429234},
{0.00529996234390132,-0.2785980205680958,0.9603931764307222},
{0.39133586953300836,-0.3500320836610093,0.851078009130054},
{0.3660841543903084,-0.3009869720608654,0.8805618857036481},
{0.27820171650988634,0.3071018948245366,-0.9101056153689703},
{0.2716962859371567,0.33609540560720785,-0.901787672646772},
{0.13440263297337016,0.3461067802982397,-0.9285181898495104},
{0.13589925323565522,0.3226982267781158,-0.9366948528759252},
{0.0004999962475422433,0.37259720366847965,-0.9279930354384034},
{-0.010699889470712648,0.37959607879275903,-0.9250904438650721},
{0.11530069814784093,0.36660221978316115,-0.9232055900267715},
{0.9439239901330677,0.032000813311005585,-0.32860835168738856},
{0.6220001430600494,0.18230004192901447,-0.7615001751450604},
{0.5965884829705034,0.10319800778168947,-0.7958846355954133},
{0.2702027128488556,0.2678026887524927,-0.9248092851318344},
{0.6010390537813204,0.24121567349759482,-0.7619495092778503},
{-0.3962097389550767,0.44661097783275433,-0.8022197188030352},
{-0.47130804294037976,0.43130736032290645,-0.7693131284405562},
{-0.7624435367689598,0.4920280956064116,-0.42022399547523204},
{-0.8977932261756626,0.44009667948307984,0.01679987324543454},
{-0.864715612581329,0.257204643871768,0.43140778913794997},
{-0.5863217500087323,-0.03240120194487963,0.8094300263637523},
{-0.03439935862993746,0.38879275102673505,-0.9206828340285879},
{-0.3662095929859341,0.4754124535923349,-0.7999209542038467},
{-0.7455958209471353,0.5320970176045744,-0.4011977512929059},
{-0.890095789856871,0.4551978469192761,0.022899891683768506},
{-0.8591314533782728,0.2721099621280736,0.43341586764537704},
{-0.584141376199066,-0.02530179218941341,0.8112574634012711},
{0.36469932348338246,-0.4318991988277293,0.8248984698147578},
{0.7801063578927254,-0.4360035534434409,0.44870365694970626},
{0.7606360093610449,-0.49802357699421557,0.4164197137758862},
{0.9157586379029375,-0.4017257233216228,-0.0016001024578406685},
{-0.3573117575368258,0.49611632497626446,-0.7913260390117276},
{-0.35531965327354886,0.5027278066439995,-0.7880435878963031},
{-0.7409915527444478,0.5447937893862013,-0.39259552443653206},
{0.600717099655616,0.05270150016955379,-0.797722707500058},
{0.5898202488767219,0.03130107458433604,-0.8069277023035384},
{0.8986682744223103,-0.43833330144591437,-0.01610122325639795},
{0.9200762866875251,-0.3917324798864169,0.0023001907167188125},
{-0.5965280822204714,-0.09920467016977495,0.7964374931775078},
{-0.9419087503729366,0.33500311219336854,-0.024100223892119944},
{-0.914799995426,0.4038999979805,0.002399999988},
{-0.36453259978541885,0.4759425630668884,-0.8003715764287263},
{-0.13390494854881213,-0.3202118336469727,0.9378346583202092},
{-0.5938863585870131,-0.05329877574118168,0.8027815603193368},
{-0.9099654925733356,0.41462984198362995,0.006700482251062037},
{-0.3597091187417416,0.48201221916463566,-0.7989202528851193},
{0.13540092546848836,0.30890211135314666,-0.9414064345349701},
{0.1342987745292736,0.30759719318841816,-0.9419914043676525},
{0.5864883964418636,0.02459951330344389,-0.8095839825393567},
{0.8914758589083891,-0.4525385081400562,-0.021901863708877856},
{0.35808015216723277,-0.5024721487406715,0.7869563802167333},
{0.36141883764073957,-0.4958258431164324,0.7896411571696954},
{0.37251544294778777,-0.47401965089195003,0.7978330748556914},
{-0.13489880547636623,-0.31369722222339574,0.9398916772960461},
{-0.5892967146799735,-0.04789973295973312,0.8064955038000994},
{0.36272776061782075,-0.4741362870386237,0.8022613994144356},
{0.35941985490119227,-0.4810265726418294,0.7996441735642552},
{0.7583458471840792,-0.5072306655568574,0.4094247525216431},
{0.9112098365632788,-0.4119044465325006,-0.005600060452978887},
{0.8769980004468386,-0.23339946784982,-0.419999042403275},
{0.8802102060965099,-0.2221025752942909,-0.4194048630275804},
{0.5925103068064311,0.056000974145417964,-0.8036139789867477},
{0.13530418231691413,0.3140097061900298,-0.939729047473793},
{0.0007999922561124411,0.37359638360451,-0.9275910209623753},
{-0.0008000210408300644,0.3740098365880551,-0.9274243915822521},
{0.26819842567986185,0.24949853544789538,-0.9304945380130928},
{0.13390399977221068,0.31160930790904295,-0.9407280999680253},
{0.5891942465462736,0.049199519569037106,-0.8064921246428541},
{0.2675040299785677,0.24490368950187374,-0.9319140393907559},
{0.0013000360244973651,-0.36951023927059723,0.9292257492022705},
{-0.1337975615616606,-0.31239430666564105,0.9404828598560672},
{-0.26699547046026517,-0.24019592511069546,0.93328416696841},
{-0.1352989385839902,-0.30959757121658066,0.9411926163728868},
{0.009699975653091667,-0.1061997334390036,0.9942975043163963},
{0.37531016729014977,0.09780264950966332,0.9217249698676552},
{0.04189990237334121,-0.15389964141425327,0.9871976998320391},
{-0.12230045618155233,-0.23030085902380623,0.9654036009621474},
{-0.14740852340724225,-0.18481068606281115,0.9716561827847799},
{-0.27861284295500083,-0.30721416136315954,0.9099419447406866},
{-0.30091008216120707,-0.2557085676590915,0.9187307825905646},
{-0.6002082649247124,-0.4701064734107086,0.647108910751052},
{-0.6276272866894461,-0.3852167476621648,0.6765294127555932},
{-0.8229994239006048,-0.5457996179404011,0.15739988982011568},
{-0.8779412027474902,-0.4453208994002248,0.1758082508748249},
{-0.8317776213241432,-0.5080863301211797,-0.2235939842847781},
{-0.8906262337820798,-0.40271186205259774,-0.21120622117086826},
{-0.9243267272937351,-0.3392098083934166,0.17480505456123002},
{-0.9360411399121685,-0.29231284743197317,-0.19590861037264296},
{0.4426224326733462,0.02880145969496695,0.8962454228690757},
{0.7467973339382767,0.33809879298946355,0.5726979554719485},
{0.6865369881766339,0.44342389010563654,0.5762310452838696},
{0.3516935816507018,0.19309647602146862,0.915983283457614},
{-0.010999737109424586,-0.052198752464723955,0.9985761343155812},
{-0.17160906634646897,-0.13870732810172054,0.975351529182466},
{-0.33241884702081287,-0.20781178222299918,0.9199521581662028},
{-0.6913042791867323,-0.31080192386986316,0.6523040377744908},
{0.8025439766020799,0.2320127134849627,0.5496301178074805},
{0.8682620273905799,0.44628048234989726,0.21669052324719415},
{0.8006193752233234,0.5540134072866865,0.22820552264047264},
{0.2904208878214052,0.2752197945194583,-0.9164659145989521},
{0.609822719368623,0.41641551384895803,-0.6743251224504141},
{0.2686985772448002,0.3278982637832899,-0.9056952043565892},
{0.11310103883781261,0.2481022788298966,-0.9621088370102521},
{0.13780235299526628,0.20260345948360628,-0.9695165546365069},
{-0.052702659179755064,0.17220868900861142,-0.9836496312942521},
{-0.020099547966249298,0.12559717535128914,-0.9918776929215264},
{-0.46539665381008866,-0.0038999719593024187,-0.8850936361996335},
{-0.3934874676237311,-0.06719785978224836,-0.916870798130112},
{-0.8195403756511842,-0.19690970099538518,-0.5381265114556464},
{-0.7688755078607895,-0.29729052996099975,-0.5660819677461216},
{-0.7158082533167414,-0.400104613232786,-0.5723065987331253},
{0.5803192117855145,0.503716675816584,-0.6399211849414971},
{0.8563084860591454,0.4868048242597128,-0.17250170950041174},
{0.9092336922787126,0.37701397051152075,-0.17650654057104354},
{0.671129359195991,0.3393148436525104,-0.6591288342215433},
{0.32209603663265374,0.22659721173846423,-0.919188689452764},
{0.16260592058935494,0.15690571304101963,-0.9741354689181467},
{0.0015999903200878455,0.07349955532903539,-0.9972939663897551},
{-0.37060692300198306,-0.1582029552588066,-0.915217096415043},
{0.7936311665078751,0.5889231274653323,-0.15270599688224867},
{0.9219320376949746,0.3308114958992272,0.20150700249000691},
{-0.46171997905574996,0.8804380973807283,0.10790466913605246},
{0.46171997905574996,-0.8804380973807283,-0.10790466913605246},
{0.47250610009312854,-0.8753113003418316,-0.10280132717370077},
{0.4730026464572104,-0.8766049046181621,-0.08850049516165565},
{0.48612884287989744,-0.868351520824141,-0.09820582672455447},
{0.4872303602696521,-0.86735404651451,-0.10150632505617753},
{0.47311059306476944,-0.8744195784735455,-0.10750240700583959},
{0.48709965415936834,-0.8669993844306556,-0.10509992537907947},
{0.47771397572679286,-0.870225458818202,-0.12040352245657496},
{-0.47752291926252816,0.8724418738526274,0.10400499183937786},
{-0.47752788366721477,0.8724509438979647,0.10390606725240548},
{0.47752291926252816,-0.8724418738526274,-0.10400499183937786},
{0.47752788366721477,-0.8724509438979647,-0.10390606725240548},
{-0.3490939711991757,-0.07979862188969986,-0.9336838754187061},
{0.14260578919952122,0.19370786373034543,-0.9706394039064186},
{0.5890074509913829,0.40570513220238374,-0.6989088412527631},
{0.8669276120841743,0.4487142917777933,0.21700691178021206},
{0.3490939711991757,0.07979862188969986,0.9336838754187061},
{-0.14260578919952122,-0.19370786373034543,0.9706394039064186},
{-0.5890074509913829,-0.40570513220238374,0.6989088412527631},
{-0.8669276120841743,-0.4487142917777933,-0.21700691178021206},
{0.011999368249892027,-0.11189410893024315,0.9936476858264757},
{0.3833993443876816,0.1004998281454408,0.9180984300530268},
{-0.2927943257009513,-0.26959477530388143,0.9173822213048249},
{-0.6165252503087002,-0.41701707928423026,0.6678273514292781},
{-0.8547868278364736,-0.4886924693070715,0.1746973079352269},
{-0.8669464218890234,-0.4487240275713517,-0.21691161484338353},
{0.7446092481042925,0.339004210458441,0.5750071416330488},
{0.8669464218890234,0.4487240275713517,0.21691161484338353},
{0.2927943257009513,0.26959477530388143,-0.9173822213048249},
{0.6165252503087002,0.41701707928423026,-0.6678273514292781},
{-0.011999368249892027,0.11189410893024315,-0.9936476858264757},
{-0.3833993443876816,-0.1004998281454408,-0.9180984300530268},
{-0.7446092481042925,-0.339004210458441,-0.5750071416330488},
{0.8547868278364736,0.4886924693070715,-0.1746973079352269},
{-0.11170377453431336,-0.9712328185114157,-0.21030710639718977},
{0.6185820706585192,0.3448900035081204,-0.7059795374796549},
{0.681089984645413,0.3335950945202023,-0.6517904154924097},
{0.2802140586919957,0.2639132408594492,-0.9229463053777404},
{0.2700097799313469,0.25660929455697634,-0.9280336139862589},
{0.14060761481157574,0.20621116766818576,-0.9683524425465776},
{0.14059796626512686,0.23039666733631028,-0.9628860719537029},
{0.30200072480260926,0.27360065664236394,-0.9132021916878901},
{0.8990033532887616,0.36730137003666535,-0.23850088960997734},
{0.9215985208355612,0.32519947805525656,-0.21189965990131882},
{0.5902193565612027,0.3739122626537339,-0.715423462697195},
{0.26961263299588545,0.25771207538219465,-0.9278434751245642},
{0.14170664761476306,0.19730925599430316,-0.9700455059020479},
{0.009300519495024997,0.13460751871294244,-0.9908553457710503},
{0.006400274801698044,0.15340658665319998,-0.988142426805912},
{-0.004000211116712674,0.19421024971640033,-0.9809517710958655},
{0.15811260128590923,0.2514200377183908,-0.9548761018835303},
{0.9644904033682294,0.1930980786836756,0.18019820703675993},
{0.9783639088210931,0.12089554024577898,0.16789380651171457},
{0.377123039150214,-0.07700470436108851,0.9229563851279038},
{0.34841423998098797,-0.0021000858322619822,0.9373383097995982},
{-0.1426998423167614,-0.20359977502237295,0.9685989296987741},
{-0.1430053613714986,-0.22010825201305487,0.9649361761353777},
{0.3441161979306639,-0.13170619955672316,0.929643759361654},
{-0.8033754934043549,-0.07769762986995069,-0.5903819906720577},
{-0.8140917370108038,-0.0069999289510817185,-0.5806941059847363},
{-0.9657392387824238,-0.1876076226525657,-0.17930728540301188},
{-0.9240570253186029,-0.32532007612136526,-0.20071238634355365},
{-0.8888977866472668,-0.3768990615225052,0.26039935160642175},
{-0.9298742162229133,-0.24951991497915346,0.27032157522591255},
{-0.9795544108609189,-0.11290627155303495,-0.1665092490131118},
{-0.16710876759149357,-0.2365124089490618,0.9571502182035816},
{-0.6228183734130276,-0.34001003044384936,0.7046207866198124},
{-0.6968876756504332,-0.3275942065476854,0.6379887172693018},
{-0.9303823415107355,-0.30839414673464194,-0.19819623827109606},
{-0.9449647748305622,-0.265118173148039,-0.1917131414276842},
{-0.38362745911811474,-0.015001073740280816,-0.9233660922934185},
{-0.4737964986568124,-0.024499818947006976,-0.8802934946551118},
{0.14210400667895326,0.16720471440338483,-0.9756275082053962},
{0.117697522493227,0.15049683207502687,-0.9815793379724013},
{0.6215236991504816,0.2550097237061509,-0.7407282445064548},
{0.5947922171947567,0.20879726790562408,-0.7762898423138695},
{0.7761249489374819,0.20030643895397193,0.5979192204222656},
{0.8074695220813842,0.1701146466510323,0.5648486327366433},
{0.9293056362557759,0.3113018880516766,0.19870120512646364},
{0.8968319950521454,0.38961389972381333,0.2095074743124715},
{0.8659840694842659,0.4360423308640027,-0.24482376742088957},
{0.9447854645874402,0.2656959122998337,0.19179704922509636},
{0.0009999889201841462,0.22399751812124874,-0.9745892016114689},
{-0.3797098839769215,0.08890231415735667,-0.9208239693598876},
{-0.3573003805251079,0.1473001568747506,-0.9223009822510692},
{-0.28611480539366757,-0.18910978573905113,0.9393486078513524},
{-0.28120485223158825,-0.15940275051819047,0.9463163288291322},
{-0.14440241154040925,-0.15680261862559675,0.9770163163087247},
{-0.14460810623459885,-0.1812101580201197,0.9727545292835014},
{-0.012099760548108105,-0.12659749466037076,0.9918803708816885},
{-0.0012999395932106227,-0.11849449368881444,0.9929538585062679},
{-0.12649951740526166,-0.13529948383345378,0.9826962510209536},
{-0.9413376777945957,-0.1799072009298287,0.2855114278236025},
{-0.6241297498535571,-0.2431115881900332,0.7425353937930879},
{-0.5942097896869283,-0.32750539569584153,0.7346121028340921},
{-0.2759097866937041,-0.2301081620812661,0.9332331023652218},
{-0.6063035377914645,-0.1908011133277444,0.772004504659427},
{0.37891274304982675,0.019300649091743616,0.9252311160456577},
{0.45448908103099084,0.025799380177336774,0.8903786089108784},
{0.7388279208347025,0.26330995067105734,0.6203234424658445},
{0.872929885266192,0.43761498200536786,0.21560738144505787},
{0.8459551453835363,0.47813116799606187,-0.2361153916834767},
{0.5800316328876728,0.39532155944913283,-0.7122388430044838},
{0.021800200017752746,-0.10710098265602382,0.9940091200755151},
{0.34751379309617736,0.04410175043321273,0.9366371758672799},
{0.719753447276665,0.3066227691191128,0.6228462511656342},
{0.864411021310783,0.4533057796855367,0.21750277317803715},
{0.839611855403098,0.491806944363082,-0.23060325614096522},
{0.5774276565599322,0.40231926954288316,-0.710434027052608},
{-0.34849617004813666,0.006199931863123234,-0.9372896992428077},
{-0.7597735869303677,-0.20149299521777977,-0.6181785093976747},
{-0.7367018086051601,-0.2704006638344445,-0.6198015216146033},
{-0.8930148911474659,-0.3977066318133787,-0.21060351184284024},
{0.3373891935971908,0.06569789573009908,0.9390699220720862},
{0.3349955847872885,0.07299903787902108,0.9393876189527727},
{0.7144013537918482,0.3217006096232329,0.6214011775563472},
{-0.5956164749795501,-0.37261030654362043,0.7116196836726794},
{-0.5835050473404892,-0.3953034193893666,0.7094061363896197},
{-0.8739293383003385,-0.43571462718555604,-0.2154072313421363},
{-0.8979391105897112,-0.38721686559787966,-0.20920911230133374},
{0.5939259818603772,0.3313144936695453,-0.7331320715639712},
{0.9229154543486756,0.32830549752158433,0.2011033675040835},
{0.8919719835999858,0.39988743973277385,0.2108933759430908},
{0.34570266364928515,0.04410033979442718,0.9373072219799682},
{0.14250842891029922,0.1839108777305546,-0.9725575236159018},
{0.5887523159113988,0.3742332539732383,-0.7164636642074504},
{0.8865191711843675,0.41110889032588105,0.21230459113642552},
{0.3405946220533764,0.04989921209766142,0.9388851751201264},
{-0.14329690625319066,-0.19549577929168718,0.9701790540603319},
{-0.14220778964502254,-0.19691078608371967,0.9700531361158359},
{-0.5798275047700486,-0.4022190797145801,0.7085336100889608},
{-0.8659004286208182,-0.45060022304716557,-0.2172001075140798},
{-0.3378138540302365,-0.07350301442043333,-0.9383384820502395},
{-0.341420065846922,-0.06650390854956156,-0.9375551017325408},
{-0.35379367776346704,-0.04409921195412351,-0.9342833045065214},
{0.1429995138024796,0.190599351963305,-0.9711966979368405},
{0.5839140520607463,0.38050915706304844,-0.71711725763446},
{-0.3441049792350746,-0.04150060051803428,-0.938013573154606},
{-0.3404059826877191,-0.048700855925064394,-0.9390165033600711},
{-0.7338041937029506,-0.28170160992930116,-0.618203533043287},
{-0.8878914318890232,-0.40829605996203194,-0.21199795422961246},
{-0.8596068038147784,-0.45240358078851295,0.23750187983481835},
{-0.8634107495307478,-0.442505509227885,0.2423030166913368},
{-0.5875201699136556,-0.3722127782840215,0.7185246673752538},
{-0.1435001628727773,-0.19020021587736757,0.9712011023138768},
{-0.012500184379079397,-0.12550185116595713,0.9920146323237409},
{-0.01089996610115814,-0.12499961125181352,0.9920969145833936},
{-0.2728177310005253,-0.24871616458882204,0.9293604010952646},
{-0.1420039690664039,-0.19270538619081712,0.9709271377927573},
{-0.5838408440149145,-0.3794265437123306,0.7177502119724293},
{-0.2719160353614218,-0.2534149443199128,0.9283547466936664},
{0.01009988738688345,0.12979855275420513,-0.9914889449598953},
{0.1418975295855147,0.1919966573672926,-0.9710830935905095},
{0.27121832277271324,0.2581174377125269,-0.9272626433438781},
{0.14330536903622831,0.19470729484545465,-0.9703363543325354}
};


// face array: 22kb.
const uint16_t sinbad_1_face[11329] PROGMEM = {
72, // chain 0
0,0,0, 1,1,1, 2,2,2, 
32771,3,3, 32772,4,4, 5,5,5, 32774,6,6, 7,7,7, 32776,8,8, 9,9,9, 32778,10,10, 11,11,11, 32780,12,12, 13,13,13, 32782,14,14, 15,15,15, 32768,0,0, 2,2,2, 16,16,16, 
32785,17,17, 32771,3,3, 18,18,18, 32773,5,5, 19,19,19, 32775,7,7, 20,20,20, 32777,9,9, 21,21,21, 32779,11,11, 22,22,22, 32781,13,13, 23,23,23, 32783,15,15, 16,16,16, 24,24,24, 
32793,25,25, 32785,17,17, 26,26,26, 32786,18,18, 27,27,27, 32787,19,19, 28,28,28, 32788,20,20, 29,29,29, 32789,21,21, 30,30,30, 32790,22,22, 31,31,31, 32791,23,23, 24,24,24, 32,32,32, 
32801,33,33, 32793,25,25, 34,34,34, 32794,26,26, 35,35,35, 32795,27,27, 36,36,36, 32796,28,28, 37,37,37, 32797,29,29, 38,38,38, 32798,30,30, 39,39,39, 32799,31,31, 32,32,32, 40,40,40, 
32801,33,33, 34,34,34, 35,35,35, 36,36,36, 37,37,37, 38,38,38, 39,39,39, 
13, // chain 1
41,41,41, 42,42,42, 43,43,43, 
44,44,44, 32813,45,45, 32814,46,46, 47,47,47, 32816,48,48, 49,49,49, 50,50,50, 32819,51,51, 52,52,52, 32821,53,53, 54,54,54, 32823,55,55, 
12, // chain 2
56,56,56, 57,57,57, 58,58,58, 
59,59,59, 32828,60,60, 61,61,61, 62,62,62, 32831,63,63, 64,64,64, 32833,65,65, 66,66,66, 32835,67,67, 68,68,68, 32837,69,69, 
4, // chain 3
70,70,70, 71,71,71, 72,72,72, 
73,73,73, 32842,74,74, 32843,75,75, 
1, // chain 4
72,72,72, 71,71,71, 42,76,42, 
14, // chain 5
60,77,60, 58,78,58, 76,79,76, 
77,80,77, 32846,81,78, 79,82,79, 32848,83,80, 81,84,81, 32850,85,82, 32851,86,83, 84,87,84, 32853,88,85, 32854,89,86, 32855,90,87, 88,91,88, 32857,92,89, 
6, // chain 6
72,93,72, 42,42,42, 90,94,90, 
75,95,75, 32859,96,91, 32812,44,44, 32809,41,41, 32810,42,42, 
12, // chain 7
92,97,92, 93,98,93, 94,99,94, 
95,100,95, 32864,101,96, 32865,102,97, 32861,98,93, 98,103,98, 32867,104,99, 100,105,100, 32869,106,101, 32870,107,102, 70,70,70, 32839,71,71, 
5, // chain 8
103,108,103, 104,109,104, 105,110,105, 
106,111,106, 32875,112,107, 32876,113,108, 32877,114,109, 
7, // chain 9
110,115,110, 67,116,67, 65,117,65, 
111,118,111, 112,119,112, 32881,120,113, 114,121,114, 32828,77,60, 32829,122,61, 
5, // chain 10
105,123,105, 104,124,104, 115,125,115, 
32884,126,116, 32885,127,117, 91,96,91, 32843,95,75, 
5, // chain 11
118,128,118, 45,45,45, 50,50,50, 
52,52,52, 119,129,119, 32888,130,120, 32822,54,54, 
1, // chain 12
50,50,50, 45,45,45, 47,47,47, 
23, // chain 13
121,131,121, 122,132,122, 123,133,123, 
124,134,124, 32893,135,125, 32825,57,57, 32894,136,126, 32895,137,127, 32890,132,122, 88,138,88, 32896,139,128, 32897,140,129, 32889,131,121, 130,141,130, 32899,142,131, 32900,143,132, 32892,134,124, 133,144,133, 32902,145,134, 
32903,146,135, 32893,135,125, 62,62,62, 32827,59,59, 32824,56,56, 32825,57,57, 
7, // chain 14
136,147,136, 115,125,115, 137,148,137, 
138,149,138, 32907,150,139, 32812,44,44, 32859,96,91, 32884,126,116, 32883,125,115, 
5, // chain 15
140,151,140, 135,146,135, 66,66,66, 
68,68,68, 141,152,141, 142,153,142, 32911,154,143, 
2, // chain 16
66,66,66, 135,146,135, 64,64,64, 
32830,62,62, 
5, // chain 17
138,149,138, 139,150,139, 144,155,144, 
32913,156,145, 32886,128,118, 32813,45,45, 32812,44,44, 
5, // chain 18
146,157,146, 145,156,145, 118,128,118, 
119,129,119, 147,158,147, 32888,130,120, 148,159,148, 
6, // chain 19
149,160,149, 150,161,150, 151,162,151, 
130,141,130, 32897,140,129, 32920,163,152, 153,164,153, 32922,165,154, 
13, // chain 20
96,101,96, 97,102,97, 155,166,155, 
32924,167,156, 32866,103,98, 157,168,157, 32926,169,158, 32868,105,100, 159,170,159, 32928,171,160, 32869,106,101, 107,112,107, 32874,111,106, 32841,73,73, 32838,70,70, 
11, // chain 21
84,87,84, 161,172,161, 162,173,162, 
163,174,163, 32932,175,164, 32933,176,165, 32929,172,161, 166,177,166, 32935,178,167, 32936,179,168, 32937,180,169, 32853,88,85, 32852,87,84, 
19, // chain 22
96,101,96, 155,166,155, 170,181,170, 
32939,182,171, 32924,167,156, 172,183,172, 32941,184,173, 32942,185,174, 32925,168,157, 175,186,175, 32926,169,158, 176,187,176, 32945,188,177, 32946,189,178, 32927,170,159, 179,190,179, 32928,171,160, 180,191,180, 32949,192,181, 
32875,112,107, 108,113,108, 
17, // chain 23
182,193,182, 183,194,183, 184,195,184, 
185,196,185, 32954,197,186, 32955,198,187, 32956,199,188, 32951,194,183, 189,200,189, 32958,201,190, 32931,174,163, 32950,193,182, 82,85,82, 32953,196,185, 81,84,81, 32959,202,191, 32960,203,192, 32961,204,193, 32954,197,186, 
8, // chain 24
191,202,191, 192,203,192, 194,205,194, 
195,206,195, 32964,207,196, 32911,208,143, 32910,209,142, 32960,203,192, 197,210,197, 32961,204,193, 
5, // chain 25
81,84,81, 191,202,191, 195,206,195, 
79,82,79, 32966,211,198, 32967,212,199, 32964,207,196, 
9, // chain 26
200,213,200, 95,100,95, 96,101,96, 
201,214,201, 32970,215,202, 32938,181,170, 203,216,203, 32915,217,147, 32939,182,171, 204,218,204, 32940,183,172, 
5, // chain 27
95,100,95, 200,213,200, 51,219,51, 
92,97,92, 32817,220,49, 205,221,205, 32816,222,48, 
3, // chain 28
51,219,51, 200,213,200, 53,223,53, 
32823,224,55, 32969,214,201, 
3, // chain 29
168,179,168, 169,180,169, 128,225,128, 
32854,89,86, 32853,88,85, 
3, // chain 30
168,179,168, 128,225,128, 153,226,153, 
154,227,154, 167,178,167, 
1, // chain 31
129,140,129, 153,164,153, 128,139,128, 
1, // chain 32
128,225,128, 86,89,86, 88,91,88, 
2, // chain 33
127,137,127, 88,138,88, 89,228,89, 
126,136,126, 
12, // chain 34
149,160,149, 130,141,130, 131,142,131, 
206,229,206, 32975,230,207, 32900,143,132, 188,231,188, 32901,144,133, 208,232,208, 32977,233,209, 32902,145,134, 142,153,142, 32908,151,140, 32903,146,135, 
5, // chain 35
164,175,164, 165,176,165, 149,234,149, 
210,235,210, 211,236,211, 163,174,163, 32958,201,190, 
4, // chain 36
138,149,138, 212,237,212, 213,238,213, 
136,147,136, 32982,239,214, 32983,240,215, 
1, // chain 37
213,238,213, 212,237,212, 216,241,216, 
1, // chain 38
209,233,209, 142,153,142, 217,242,217, 
4, // chain 39
145,156,145, 218,243,218, 219,244,219, 
144,155,144, 32988,245,220, 32989,246,221, 
1, // chain 40
219,244,219, 218,243,218, 222,247,222, 
1, // chain 41
207,230,207, 188,231,188, 223,248,223, 
3, // chain 42
115,125,115, 136,147,136, 224,249,224, 
105,123,105, 32877,250,109, 
1, // chain 43
224,249,224, 136,147,136, 214,239,214, 
2, // chain 44
144,155,144, 220,245,220, 212,237,212, 
138,149,138, 
3, // chain 45
225,251,225, 218,243,218, 146,157,146, 
147,158,147, 204,252,204, 
1, // chain 46
146,157,146, 218,243,218, 145,156,145, 
5, // chain 47
112,119,112, 114,121,114, 79,82,79, 
198,211,198, 67,116,67, 32994,253,226, 32967,212,199, 
2, // chain 48
79,82,79, 114,121,114, 77,80,77, 
32828,77,60, 
3, // chain 49
74,74,74, 227,254,227, 106,111,106, 
32871,108,103, 32872,109,104, 
1, // chain 50
74,74,74, 106,111,106, 73,73,73, 
3, // chain 51
174,185,174, 175,186,175, 219,255,219, 
228,256,228, 32990,257,222, 
1, // chain 52
84,87,84, 163,174,163, 82,85,82, 
1, // chain 53
93,98,93, 92,97,92, 205,221,205, 
17, // chain 54
229,258,229, 230,259,230, 231,260,231, 
232,261,232, 33001,262,233, 33002,263,234, 32998,259,230, 235,264,235, 33004,265,236, 32997,258,229, 237,266,237, 238,267,238, 33007,268,239, 240,269,240, 33009,270,241, 242,271,242, 33011,272,243, 180,273,180, 32983,274,215, 
8, // chain 55
244,275,244, 245,276,245, 246,277,246, 
247,278,247, 33016,279,248, 33017,280,249, 33013,276,245, 250,281,250, 33019,282,251, 33012,275,244, 
14, // chain 56
237,283,237, 229,284,229, 252,285,252, 
239,286,239, 33021,287,253, 33022,288,254, 32997,284,229, 232,289,232, 255,290,255, 33001,291,233, 256,292,256, 33025,293,257, 258,294,258, 33027,295,259, 224,296,224, 32877,297,109, 
13, // chain 57
244,298,244, 260,299,260, 261,300,261, 
33030,301,262, 263,302,263, 33032,303,264, 265,304,265, 33034,305,266, 267,306,267, 32911,307,143, 141,308,141, 268,309,268, 32836,310,68, 269,311,269, 32837,312,69, 
5, // chain 58
244,298,244, 261,300,261, 270,313,270, 
251,314,251, 33039,315,271, 33031,302,263, 33029,300,261, 
8, // chain 59
260,316,260, 244,275,244, 247,278,247, 
272,317,272, 33016,279,248, 273,318,273, 33042,319,274, 33017,280,249, 275,320,275, 33018,281,250, 
1, // chain 60
110,115,110, 112,119,112, 67,116,67, 
3, // chain 61
178,189,178, 179,190,179, 213,321,213, 
276,322,276, 32984,323,216, 
7, // chain 62
254,288,254, 255,290,255, 253,287,253, 
33045,324,277, 33024,292,256, 278,325,278, 33026,294,258, 214,326,214, 32992,296,224, 
4, // chain 63
250,327,250, 251,314,251, 271,315,271, 
279,328,279, 33033,304,265, 33031,302,263, 
7, // chain 64
236,265,236, 238,267,238, 235,264,235, 
33048,329,280, 33008,269,240, 281,330,281, 33010,271,242, 181,331,181, 32948,273,180, 
8, // chain 65
262,332,262, 260,316,260, 272,317,272, 
282,333,282, 33041,318,273, 283,334,283, 33052,335,284, 33042,319,274, 269,336,269, 33043,320,275, 
8, // chain 66
264,337,264, 262,332,262, 282,333,282, 
285,338,285, 33051,334,283, 199,339,199, 32994,340,226, 33052,335,284, 69,341,69, 33037,336,269, 
7, // chain 67
286,342,286, 257,343,257, 234,263,234, 
235,264,235, 280,329,280, 287,344,287, 33049,330,281, 108,345,108, 32949,331,181, 
1, // chain 68
234,263,234, 257,343,257, 233,262,233, 
4, // chain 69
275,346,275, 250,327,250, 279,328,279, 
268,309,268, 33035,306,267, 33033,304,265, 
5, // chain 70
253,287,253, 277,324,277, 241,347,241, 
33011,348,243, 33046,325,278, 215,349,215, 32982,326,214, 
1, // chain 71
253,287,253, 241,347,241, 239,286,239, 
1, // chain 72
268,309,268, 269,311,269, 275,346,275, 
3, // chain 73
286,342,286, 287,344,287, 259,350,259, 
32877,351,109, 32876,345,108, 
1, // chain 74
286,342,286, 259,350,259, 257,343,257, 
3, // chain 75
266,352,266, 264,337,264, 285,338,285, 
196,353,196, 32967,339,199, 
1, // chain 76
196,353,196, 143,354,143, 266,352,266, 
1, // chain 77
67,116,67, 226,253,226, 69,355,69, 
2, // chain 78
215,356,215, 213,321,213, 179,190,179, 
180,191,180, 
16, // chain 79
288,357,288, 289,358,289, 290,359,290, 
291,360,291, 33060,361,292, 293,362,293, 294,363,294, 33063,364,295, 296,365,296, 33065,366,297, 298,367,298, 299,368,299, 32843,369,75, 117,370,117, 289,358,289, 32872,371,104, 300,372,300, 32995,373,227, 
1, // chain 80
290,359,290, 289,358,289, 300,372,300, 
6, // chain 81
301,374,301, 302,375,302, 303,376,303, 
304,377,304, 32831,378,63, 32833,379,65, 33073,380,305, 33070,375,302, 
1, // chain 82
65,379,65, 305,380,305, 111,381,111, 
3, // chain 83
296,365,296, 299,368,299, 288,357,288, 
294,363,294, 33059,360,291, 
1, // chain 84
288,357,288, 299,368,299, 289,358,289, 
4, // chain 85
306,382,306, 301,374,301, 304,377,304, 
307,383,307, 32829,384,61, 32831,378,63, 
10, // chain 86
307,383,307, 308,385,308, 306,382,306, 
33077,386,309, 310,387,310, 33079,388,311, 312,389,312, 33081,390,313, 302,375,302, 301,374,301, 310,387,310, 33074,382,306, 
10, // chain 87
290,391,290, 300,392,300, 314,393,314, 
292,394,292, 33083,395,315, 33065,396,297, 33084,397,316, 33068,392,300, 227,398,227, 74,399,74, 298,400,298, 32843,401,75, 
11, // chain 88
305,402,305, 302,403,302, 317,404,317, 
33081,405,313, 318,406,318, 33079,407,311, 309,408,309, 308,409,308, 317,404,317, 33087,410,319, 33075,411,307, 113,412,113, 32829,413,61, 
3, // chain 89
305,402,305, 317,404,317, 319,410,319, 
111,414,111, 32881,412,113, 
1, // chain 90
297,396,297, 316,397,316, 298,400,298, 
2, // chain 91
315,395,315, 295,415,295, 293,416,293, 
292,394,292, 
1, // chain 92
315,395,315, 297,396,297, 295,415,295, 
2, // chain 93
221,417,221, 219,255,219, 175,186,175, 
176,187,176, 
1, // chain 94
142,209,142, 197,210,197, 217,418,217, 
1, // chain 95
177,188,177, 178,189,178, 276,322,276, 
1, // chain 96
188,231,188, 208,232,208, 187,419,187, 
6, // chain 97
220,420,220, 221,421,221, 320,422,320, 
321,423,321, 33090,424,322, 33091,425,323, 33092,426,324, 32989,421,221, 
5, // chain 98
187,427,187, 208,428,208, 325,429,325, 
33094,430,326, 32977,431,209, 327,432,327, 32985,433,217, 
6, // chain 99
187,427,187, 325,429,325, 328,434,328, 
33097,435,329, 33098,436,330, 33094,430,326, 331,437,331, 33095,432,327, 
26, // chain 100
177,438,177, 276,439,276, 332,440,332, 
333,441,333, 33102,442,334, 33103,443,335, 33104,444,336, 33044,439,276, 216,445,216, 337,446,337, 338,447,338, 33107,448,339, 340,449,340, 33109,450,341, 342,451,342, 33111,452,343, 344,453,344, 345,454,345, 33114,455,346, 
33115,456,347, 348,457,348, 33117,458,349, 334,442,334, 33118,459,350, 333,441,333, 33092,460,324, 176,461,176, 32989,462,221, 
5, // chain 101
197,463,197, 193,464,193, 351,465,351, 
33120,466,352, 32954,467,186, 328,468,328, 32955,469,187, 
6, // chain 102
197,463,197, 351,465,351, 353,470,353, 
33122,471,354, 33123,472,355, 33120,466,352, 356,473,356, 33096,468,328, 
10, // chain 103
212,474,212, 220,420,220, 321,423,321, 
337,475,337, 33107,476,339, 33090,424,322, 341,477,341, 33125,478,357, 33091,425,323, 358,479,358, 33118,480,350, 33092,426,324, 
1, // chain 104
337,475,337, 216,481,216, 212,474,212, 
9, // chain 105
217,482,217, 197,463,197, 353,470,353, 
327,483,327, 33127,484,359, 33122,471,354, 360,485,360, 33129,486,361, 33123,472,355, 362,487,362, 33124,473,356, 
1, // chain 106
333,441,333, 176,461,176, 177,438,177, 
8, // chain 107
327,483,327, 359,484,359, 331,488,331, 
33131,489,363, 33128,485,360, 364,490,364, 33133,491,365, 33129,486,361, 366,492,366, 33130,487,362, 
5, // chain 108
335,443,335, 336,444,336, 338,447,338, 
367,493,367, 33108,449,340, 345,454,345, 33110,451,342, 
6, // chain 109
328,434,328, 329,435,329, 356,494,356, 
33136,495,368, 33137,496,369, 33098,436,330, 370,497,370, 33099,437,331, 
8, // chain 110
358,479,358, 350,480,350, 349,498,349, 
371,499,371, 33115,500,347, 344,501,344, 372,502,372, 33111,503,343, 357,478,357, 33109,477,341, 
6, // chain 111
356,494,356, 368,495,368, 362,504,362, 
33141,505,373, 33142,506,374, 33137,496,369, 375,507,375, 33138,497,370, 
6, // chain 112
331,488,331, 363,489,363, 370,508,370, 
33144,509,376, 33132,490,364, 377,510,377, 33133,491,365, 366,492,366, 
4, // chain 113
348,457,348, 334,442,334, 335,443,335, 
367,493,367, 346,455,346, 33113,454,345, 
2, // chain 114
370,508,370, 376,509,376, 375,511,375, 
33145,510,377, 
2, // chain 115
372,502,372, 357,478,357, 358,479,358, 
371,499,371, 
4, // chain 116
362,504,362, 373,505,373, 366,512,366, 
33145,513,377, 33142,506,374, 375,507,375, 
1, // chain 117
188,199,188, 189,200,189, 223,514,223, 
1, // chain 118
173,184,173, 174,185,174, 228,256,228, 
1, // chain 119
149,160,149, 206,229,206, 210,515,210, 
6, // chain 120
225,516,225, 204,517,204, 378,518,378, 
379,519,379, 33148,520,380, 33149,521,381, 33150,522,382, 32972,517,204, 
5, // chain 121
210,523,210, 206,524,206, 383,525,383, 
33152,526,384, 32975,527,207, 385,528,385, 32991,529,223, 
6, // chain 122
210,523,210, 383,525,383, 386,530,386, 
33155,531,387, 33156,532,388, 33152,526,384, 389,533,389, 33153,528,385, 
26, // chain 123
173,534,173, 228,535,228, 390,536,390, 
391,537,391, 33160,538,392, 33161,539,393, 33162,540,394, 32996,535,228, 222,541,222, 395,542,395, 396,543,396, 33165,544,397, 398,545,398, 33167,546,399, 400,547,400, 33169,548,401, 402,549,402, 403,550,403, 33172,551,404, 
33173,552,405, 406,553,406, 33175,554,407, 392,538,392, 33176,555,408, 391,537,391, 33150,556,382, 172,557,172, 32972,558,204, 
5, // chain 124
189,559,189, 190,560,190, 409,561,409, 
33178,562,410, 32979,563,211, 386,564,386, 32978,565,210, 
6, // chain 125
189,559,189, 409,561,409, 411,566,411, 
33180,567,412, 33181,568,413, 33178,562,410, 414,569,414, 33154,564,386, 
10, // chain 126
218,570,218, 225,516,225, 379,519,379, 
395,571,395, 33165,572,397, 33148,520,380, 399,573,399, 33183,574,415, 33149,521,381, 416,575,416, 33176,576,408, 33150,522,382, 
1, // chain 127
395,571,395, 222,577,222, 218,570,218, 
9, // chain 128
223,578,223, 189,559,189, 411,566,411, 
385,579,385, 33185,580,417, 33180,567,412, 418,581,418, 33187,582,419, 33181,568,413, 420,583,420, 33182,569,414, 
1, // chain 129
391,537,391, 172,557,172, 173,534,173, 
8, // chain 130
385,579,385, 417,580,417, 389,584,389, 
33189,585,421, 33186,581,418, 422,586,422, 33191,587,423, 33187,582,419, 424,588,424, 33188,583,420, 
5, // chain 131
393,539,393, 394,540,394, 396,543,396, 
425,589,425, 33166,545,398, 403,550,403, 33168,547,400, 
6, // chain 132
386,530,386, 387,531,387, 414,590,414, 
33194,591,426, 33195,592,427, 33156,532,388, 428,593,428, 33157,533,389, 
8, // chain 133
416,575,416, 408,576,408, 407,594,407, 
429,595,429, 33173,596,405, 402,597,402, 430,598,430, 33169,599,401, 415,574,415, 33167,573,399, 
6, // chain 134
414,590,414, 426,591,426, 420,600,420, 
33199,601,431, 33200,602,432, 33195,592,427, 433,603,433, 33196,593,428, 
6, // chain 135
389,584,389, 421,585,421, 428,604,428, 
33202,605,434, 33190,586,422, 435,606,435, 33191,587,423, 424,588,424, 
4, // chain 136
406,553,406, 392,538,392, 393,539,393, 
425,589,425, 404,551,404, 33171,550,403, 
2, // chain 137
428,604,428, 434,605,434, 433,607,433, 
33203,606,435, 
2, // chain 138
430,598,430, 415,574,415, 416,575,416, 
429,595,429, 
4, // chain 139
420,600,420, 431,601,431, 424,608,424, 
33203,609,435, 33200,602,432, 433,603,433, 
17, // chain 140
436,610,436, 437,611,437, 438,612,438, 
439,613,439, 33208,614,440, 33209,615,441, 33205,611,437, 442,616,442, 33211,617,443, 33204,610,436, 444,618,444, 445,619,445, 33214,620,446, 447,621,447, 33216,622,448, 449,623,449, 33218,624,450, 201,625,201, 32823,626,55, 
8, // chain 141
451,627,451, 452,628,452, 453,629,453, 
454,630,454, 33223,631,455, 33224,632,456, 33220,628,452, 457,633,457, 33226,634,458, 33219,627,451, 
14, // chain 142
444,635,444, 436,636,436, 459,637,459, 
446,638,446, 33228,639,460, 33229,640,461, 33204,636,436, 439,641,439, 462,642,462, 33208,643,440, 463,644,463, 33232,645,464, 465,646,465, 33234,647,466, 120,648,120, 32916,649,148, 
13, // chain 143
451,650,451, 467,651,467, 468,652,468, 
33237,653,469, 470,654,470, 33239,655,471, 472,656,472, 33241,657,473, 474,658,474, 32922,659,154, 152,660,152, 475,661,475, 32919,662,151, 476,663,476, 32918,664,150, 
5, // chain 144
451,650,451, 468,652,468, 477,665,477, 
458,666,458, 33246,667,478, 33238,654,470, 33236,652,468, 
8, // chain 145
467,668,467, 451,627,451, 454,630,454, 
479,669,479, 33223,631,455, 480,670,480, 33249,671,481, 33224,632,456, 482,672,482, 33225,633,457, 
7, // chain 146
461,640,461, 462,642,462, 460,639,460, 
33251,673,483, 33231,644,463, 484,674,484, 33233,646,465, 54,675,54, 32888,648,120, 
4, // chain 147
457,676,457, 458,666,458, 478,667,478, 
485,677,485, 33240,656,472, 33238,654,470, 
7, // chain 148
443,617,443, 445,619,445, 442,616,442, 
33254,678,486, 33215,621,447, 487,679,487, 33217,623,449, 202,680,202, 32969,625,201, 
8, // chain 149
469,681,469, 467,668,467, 479,669,479, 
488,682,488, 33248,670,480, 489,683,489, 33258,684,490, 33249,671,481, 476,685,476, 33250,672,482, 
8, // chain 150
471,686,471, 469,681,469, 488,682,488, 
491,687,491, 33257,683,489, 166,688,166, 33260,689,492, 33258,684,490, 150,690,150, 33244,685,476, 
7, // chain 151
493,691,493, 464,692,464, 441,615,441, 
442,616,442, 486,678,486, 494,693,494, 33255,679,487, 203,694,203, 32970,680,202, 
1, // chain 152
441,615,441, 464,692,464, 440,614,440, 
4, // chain 153
482,695,482, 457,676,457, 485,677,485, 
475,661,475, 33242,658,474, 33240,656,472, 
5, // chain 154
460,639,460, 483,673,483, 448,696,448, 
33218,697,450, 33252,674,484, 55,698,55, 32822,675,54, 
1, // chain 155
460,639,460, 448,696,448, 446,638,446, 
1, // chain 156
475,661,475, 476,663,476, 482,695,482, 
3, // chain 157
493,691,493, 494,693,494, 466,699,466, 
32916,700,148, 32971,694,203, 
1, // chain 158
493,691,493, 466,699,466, 464,692,464, 
3, // chain 159
473,701,473, 471,686,471, 491,687,491, 
167,702,167, 32934,688,166, 
1, // chain 160
167,702,167, 154,703,154, 473,701,473, 
3, // chain 161
165,176,165, 166,177,166, 492,704,492, 
149,234,149, 32918,705,150, 
1, // chain 162
203,216,203, 147,217,147, 148,706,148, 
25, // chain 163
495,707,495, 496,708,496, 497,709,497, 
498,710,498, 33267,711,499, 33268,712,500, 33269,713,501, 33270,714,502, 33271,715,503, 33264,708,496, 504,716,504, 33273,717,505, 33274,718,506, 33275,719,507, 33263,707,495, 508,720,508, 33266,710,498, 509,721,509, 33278,722,510, 
33279,723,511, 33267,711,499, 512,724,512, 33268,712,500, 513,725,513, 33282,726,514, 33283,727,515, 33269,713,501, 
24, // chain 164
516,728,516, 517,729,517, 518,730,518, 
519,731,519, 33288,732,520, 33289,733,521, 33290,734,522, 33291,735,523, 33285,729,517, 524,736,524, 33293,737,525, 33294,738,526, 33295,739,527, 33296,740,528, 33284,728,516, 529,741,529, 33287,731,519, 530,742,530, 33288,732,520, 
531,743,531, 33300,744,532, 33301,745,533, 33289,733,521, 534,746,534, 33303,747,535, 33290,734,522, 
19, // chain 165
536,748,536, 537,749,537, 538,750,538, 
539,751,539, 33308,752,540, 33309,753,541, 33310,754,542, 33311,755,543, 33305,749,537, 544,756,544, 545,757,545, 33314,758,546, 33315,759,547, 548,760,548, 33317,761,549, 550,762,550, 551,763,551, 33320,764,552, 33321,765,553, 
554,766,554, 33323,767,555, 
23, // chain 166
556,768,556, 557,769,557, 558,770,558, 
559,771,559, 33328,772,560, 33303,773,535, 522,774,522, 561,775,561, 33291,776,523, 562,777,562, 33292,778,524, 563,779,563, 33293,780,525, 564,781,564, 33333,782,565, 566,783,566, 33335,784,567, 568,785,568, 33337,786,569, 
570,787,570, 33339,788,571, 572,789,572, 573,790,573, 33342,791,574, 33343,792,575, 
12, // chain 167
558,770,558, 557,769,557, 576,793,576, 
33345,794,577, 33346,795,578, 33347,796,579, 33348,797,580, 33324,768,556, 581,798,581, 33327,771,559, 582,799,582, 33351,800,583, 33329,775,561, 33328,772,560, 
7, // chain 168
584,801,584, 537,749,537, 585,802,585, 
586,803,586, 33355,804,587, 33356,805,588, 33357,806,589, 33304,748,536, 33305,749,537, 
16, // chain 169
590,807,590, 515,808,515, 591,809,591, 
592,810,592, 33361,811,593, 33362,812,594, 33363,813,595, 33283,808,515, 501,814,501, 596,815,596, 33270,816,502, 597,817,597, 33271,818,503, 586,803,586, 33272,819,504, 584,801,584, 33366,820,598, 537,749,537, 
10, // chain 170
587,804,587, 599,821,599, 600,822,600, 
597,817,597, 33364,815,596, 33362,812,594, 33369,823,601, 33367,821,599, 602,824,602, 33371,825,603, 33356,805,588, 33355,804,587, 
11, // chain 171
583,800,583, 604,826,604, 605,827,605, 
582,799,582, 33374,828,606, 33375,829,607, 33376,830,608, 33372,826,604, 609,831,609, 33331,779,563, 33330,777,562, 33351,800,583, 561,775,561, 
13, // chain 172
594,812,594, 601,823,601, 593,811,593, 
33378,832,610, 33370,824,602, 611,833,611, 33380,834,612, 33371,825,603, 613,835,613, 33382,836,614, 33356,805,588, 589,806,589, 615,837,615, 33307,751,539, 33304,748,536, 
4, // chain 173
608,830,608, 609,831,609, 616,838,616, 
33334,783,566, 33332,781,564, 33331,779,563, 
19, // chain 174
590,807,590, 592,810,592, 617,839,617, 
33386,840,618, 33387,841,619, 33361,811,593, 610,832,610, 620,842,620, 33379,833,611, 621,843,621, 33390,844,622, 33380,834,612, 613,835,613, 623,845,623, 33392,846,624, 33382,836,614, 615,837,615, 625,847,625, 33394,848,626, 
33308,752,540, 33307,751,539, 
7, // chain 175
627,849,627, 628,850,628, 541,753,541, 
629,851,629, 33310,754,542, 630,852,630, 33399,853,631, 33313,757,545, 33311,755,543, 
23, // chain 176
632,854,632, 578,795,578, 633,855,633, 
634,856,634, 33403,857,635, 33404,858,636, 33346,795,578, 579,796,579, 637,859,637, 33406,860,638, 33348,797,580, 581,798,581, 639,861,639, 33350,799,582, 606,828,606, 640,862,640, 33409,863,641, 33375,829,607, 642,864,642, 
33411,865,643, 33376,830,608, 616,838,616, 644,866,644, 33336,785,568, 33334,783,566, 
23, // chain 177
541,753,541, 628,850,628, 645,867,645, 
33414,868,646, 33415,869,647, 33395,849,627, 648,870,648, 33417,871,649, 33397,851,629, 650,872,650, 33398,852,630, 651,873,651, 33420,874,652, 33399,853,631, 653,875,653, 33313,757,545, 546,758,546, 654,876,654, 33316,760,548, 
655,877,655, 33319,763,551, 656,878,656, 33320,764,552, 657,879,657, 33322,766,554, 
21, // chain 178
541,753,541, 645,867,645, 540,752,540, 
33394,848,626, 33426,880,658, 33414,868,646, 659,881,659, 33428,882,660, 33415,869,647, 661,883,661, 33416,870,648, 662,884,662, 33431,885,663, 33417,871,649, 664,886,664, 33418,872,650, 651,873,651, 665,887,665, 33434,888,666, 
33435,889,667, 33420,874,652, 654,876,654, 33421,875,653, 
25, // chain 179
668,890,668, 632,854,632, 634,856,634, 
669,891,669, 33438,892,670, 33403,857,635, 671,893,671, 33440,894,672, 33404,858,636, 637,859,637, 673,895,673, 33442,896,674, 33406,860,638, 675,897,675, 33407,861,639, 640,862,640, 676,898,676, 33445,899,677, 33409,863,641, 
642,864,642, 678,900,678, 33447,901,679, 33411,865,643, 644,866,644, 573,790,573, 33338,787,570, 33336,785,568, 
15, // chain 180
661,883,661, 662,884,662, 680,902,680, 
33449,903,681, 33431,885,663, 682,904,682, 33432,886,664, 665,887,665, 683,905,683, 33434,888,666, 684,906,684, 33453,907,685, 33454,908,686, 33455,909,687, 33435,889,667, 655,877,655, 33422,876,654, 
18, // chain 181
688,910,688, 669,891,669, 689,911,689, 
690,912,690, 33459,913,691, 33460,914,692, 33461,915,693, 33462,916,694, 33437,891,669, 670,892,670, 695,917,695, 33439,893,671, 696,918,696, 33465,919,697, 33440,894,672, 673,895,673, 698,920,698, 33442,896,674, 676,898,676, 
33443,897,675, 
5, // chain 182
661,883,661, 680,902,680, 699,921,699, 
33468,922,700, 33469,923,701, 33470,924,702, 33449,903,681, 
11, // chain 183
661,883,661, 699,921,699, 660,882,660, 
33471,925,703, 33472,926,704, 33473,927,705, 33468,922,700, 706,928,706, 33385,929,617, 33469,923,701, 590,930,590, 33475,931,707, 33470,924,702, 
18, // chain 184
669,891,669, 688,910,688, 668,890,668, 
33476,932,708, 33458,912,690, 709,933,709, 710,934,710, 33479,935,711, 33480,936,712, 33481,937,713, 714,938,714, 715,939,715, 33484,940,716, 717,941,717, 33486,942,718, 719,943,719, 720,944,720, 33489,945,721, 33490,946,722, 
33491,947,723, 
12, // chain 185
692,914,692, 693,915,693, 569,948,569, 
33339,949,571, 33492,950,724, 33462,916,694, 725,951,725, 33463,917,695, 726,952,726, 33464,918,696, 727,953,727, 33496,954,728, 33465,919,697, 698,920,698, 
3, // chain 186
692,914,692, 569,948,569, 567,955,567, 
729,956,729, 33333,957,565, 
1, // chain 187
587,804,587, 597,817,597, 586,803,586, 
1, // chain 188
594,812,594, 595,813,595, 596,815,596, 
24, // chain 189
598,958,598, 504,716,504, 505,717,505, 
730,959,730, 33499,960,731, 33274,718,506, 732,961,732, 33501,962,733, 33502,963,734, 33275,719,507, 508,720,508, 509,721,509, 735,964,735, 33504,965,736, 33505,966,737, 33278,722,510, 738,967,738, 33507,968,739, 33508,969,740, 
33279,723,511, 512,724,512, 741,970,741, 33281,725,513, 742,971,742, 33511,972,743, 33282,726,514, 
25, // chain 190
744,973,744, 745,974,745, 746,975,746, 
736,965,736, 33503,964,735, 33515,976,747, 33516,977,748, 33517,978,749, 33513,974,745, 750,979,750, 33519,980,751, 33520,981,752, 33512,973,744, 753,982,753, 33504,965,736, 737,966,737, 754,983,754, 33506,967,738, 755,984,755, 
33524,985,756, 33507,968,739, 757,986,757, 33508,969,740, 758,987,758, 33527,988,759, 33509,970,741, 742,971,742, 
6, // chain 191
760,989,760, 761,990,761, 762,991,762, 
763,992,763, 33294,738,526, 33532,993,764, 33533,994,765, 33529,990,761, 
2, // chain 192
760,989,760, 766,995,766, 767,996,767, 
761,990,761, 
7, // chain 193
767,996,767, 766,995,766, 768,997,768, 
33537,998,769, 33538,999,770, 33539,1000,771, 33540,1001,772, 33531,992,763, 33528,989,760, 
18, // chain 194
527,739,527, 528,740,528, 772,1001,772, 
33539,1000,771, 33541,1002,773, 33297,741,529, 530,742,530, 774,1003,774, 33299,743,531, 775,1004,775, 33544,1005,776, 33545,1006,777, 33300,744,532, 778,1007,778, 33547,1008,779, 33301,745,533, 534,746,534, 780,1009,780, 33326,1010,558, 
33303,747,535, 
2, // chain 195
527,739,527, 772,1001,772, 763,992,763, 
526,738,526, 
11, // chain 196
544,1011,544, 537,1012,537, 730,959,730, 
547,1013,547, 33499,960,731, 732,961,732, 549,1014,549, 33549,1015,781, 33501,962,733, 782,1016,782, 33551,1017,783, 33503,964,735, 33502,963,734, 
1, // chain 197
730,959,730, 537,1012,537, 598,958,598, 
13, // chain 198
784,1018,784, 785,1019,785, 685,1020,685, 
786,1021,786, 33555,1022,787, 788,1023,788, 789,1024,789, 33558,1025,790, 33559,1026,791, 792,1027,792, 33561,1028,793, 33562,1029,794, 33563,1030,795, 657,1031,657, 796,1032,796, 
18, // chain 199
685,1020,685, 785,1019,785, 797,1033,797, 
33566,1034,798, 33567,1035,799, 33568,1036,800, 33552,1018,784, 801,1037,801, 33554,1021,786, 802,1038,802, 33557,1024,789, 803,1039,803, 33558,1025,790, 804,1040,804, 33560,1027,792, 805,1041,805, 33574,1042,806, 33561,1028,793, 807,1043,807, 
33562,1029,794, 
15, // chain 200
808,1044,808, 716,1045,716, 809,1046,809, 
810,1047,810, 33579,1048,811, 33580,1049,812, 33581,1050,813, 33484,1045,716, 714,1051,714, 812,1049,812, 33481,1052,713, 814,1053,814, 33583,1054,815, 33477,1055,709, 816,1056,816, 33459,1057,691, 33458,1058,690, 
21, // chain 201
685,1020,685, 797,1033,797, 684,1059,684, 
33566,1034,798, 817,1060,817, 33586,1061,818, 33567,1035,799, 819,1062,819, 33588,1063,820, 33568,1036,800, 821,1064,821, 33590,1065,822, 33569,1037,801, 823,1066,823, 33570,1038,802, 803,1039,803, 824,1067,824, 33572,1040,804, 825,1068,825, 
33573,1041,805, 826,1069,826, 33595,1070,827, 33574,1042,806, 
18, // chain 202
828,1071,828, 750,979,750, 751,980,751, 
829,1072,829, 33520,981,752, 830,1073,830, 33521,982,753, 754,983,754, 831,1074,831, 33523,984,755, 832,1075,832, 33601,1076,833, 33524,985,756, 834,1077,834, 33525,986,757, 835,1078,835, 33526,987,758, 836,1079,836, 33527,988,759, 
837,1080,837, 
15, // chain 203
838,1081,838, 828,1071,828, 829,1072,829, 
839,1082,839, 33598,1073,830, 831,1074,831, 840,1083,840, 33600,1075,832, 841,1084,841, 842,1085,842, 33611,1086,843, 769,998,769, 33612,1087,844, 768,997,768, 33613,1088,845, 767,996,767, 33614,1089,846, 
6, // chain 204
839,1082,839, 840,1083,840, 847,1090,847, 
838,1081,838, 33539,1000,771, 33538,999,770, 33610,1085,842, 33608,1083,840, 
92, // chain 205
848,1091,848, 849,1092,849, 850,1093,850, 
851,1094,851, 33620,1095,852, 33621,1096,853, 33622,1097,854, 33623,1098,855, 33624,1099,856, 33617,1092,849, 857,1100,857, 33626,1101,858, 33627,1102,859, 33628,1103,860, 33629,1104,861, 33630,1105,862, 33631,1106,863, 33616,1091,848, 851,1094,851, 
864,1107,864, 33633,1108,865, 33634,1109,866, 33620,1095,852, 867,1110,867, 33636,1111,868, 33621,1096,853, 854,1097,854, 869,1112,869, 33623,1098,855, 870,1113,870, 33624,1099,856, 871,1114,871, 33625,1100,857, 858,1101,858, 872,1115,872, 
33641,1116,873, 33627,1102,859, 874,1117,874, 33643,1118,875, 33644,1119,876, 33645,1120,877, 33628,1103,860, 861,1104,861, 878,1121,878, 33647,1122,879, 33630,1105,862, 880,1123,880, 33649,1124,881, 33631,1106,863, 864,1107,864, 820,1063,820, 
33587,1062,819, 33633,1108,865, 882,1125,882, 33651,1126,883, 33634,1109,866, 884,1127,884, 33635,1110,867, 885,1128,885, 33654,1129,886, 33655,1130,887, 33636,1111,868, 888,1131,888, 33657,1132,889, 33637,1112,869, 870,1113,870, 890,1133,890, 
33659,1134,891, 33660,1135,892, 33639,1114,871, 872,1115,872, 893,1136,893, 33662,1137,894, 33663,1138,895, 33664,1139,896, 33641,1116,873, 874,1117,874, 897,1140,897, 33643,1118,875, 876,1119,876, 898,1141,898, 33667,1142,899, 33645,1120,877, 
900,1143,900, 33646,1121,878, 901,1144,901, 33670,1145,902, 33647,1122,879, 903,1146,903, 33648,1123,880, 904,1147,904, 33589,1064,821, 33649,1124,881, 820,1063,820, 
21, // chain 206
905,1148,905, 895,1138,895, 897,1140,897, 
906,1149,906, 33666,1141,898, 907,1150,907, 33676,1151,908, 33677,1152,909, 33667,1142,899, 910,1153,910, 33668,1143,900, 911,1154,911, 33669,1144,901, 814,1053,814, 33579,1048,811, 33670,1145,902, 810,1047,810, 33671,1146,903, 912,1155,912, 
33672,1147,904, 913,1156,913, 33590,1065,822, 33589,1064,821, 
1, // chain 207
897,1140,897, 895,1138,895, 896,1139,896, 
4, // chain 208
890,1133,890, 891,1134,891, 914,1157,914, 
889,1132,889, 33655,1130,887, 888,1131,888, 
4, // chain 209
915,1158,915, 893,1136,893, 894,1137,894, 
895,1138,895, 906,1149,906, 33673,1148,905, 
7, // chain 210
808,1044,808, 810,1047,810, 916,1159,916, 
33680,1155,912, 917,1160,917, 33681,1156,913, 918,1161,918, 33591,1066,823, 33590,1065,822, 
1, // chain 211
814,1053,814, 811,1048,811, 812,1049,812, 
10, // chain 212
819,1062,819, 882,1125,882, 818,1061,818, 
33687,1162,919, 33651,1126,883, 920,1163,920, 33511,1164,743, 33510,1165,742, 33527,1166,759, 33652,1127,884, 837,1167,837, 33653,1128,885, 
7, // chain 213
921,1168,921, 922,1169,922, 923,1170,923, 
33692,1171,924, 33693,1172,925, 926,1173,926, 33393,847,625, 33391,845,623, 624,846,624, 
8, // chain 214
921,1168,921, 923,1170,923, 927,1174,927, 
33471,925,703, 33427,881,659, 33692,1171,924, 658,880,658, 33694,1173,926, 626,848,626, 33393,847,625, 
7, // chain 215
921,1168,921, 927,1174,927, 928,1175,928, 
929,1176,929, 33698,1177,930, 33473,927,705, 33472,926,704, 33695,1174,927, 703,925,703, 
10, // chain 216
726,952,726, 727,953,727, 931,1178,931, 
33700,1179,932, 933,1180,933, 33343,1181,575, 572,1182,572, 571,949,571, 724,950,724, 931,1178,931, 33493,951,725, 726,952,726, 
5, // chain 217
934,1183,934, 935,1184,935, 936,1185,936, 
937,1186,937, 33386,840,618, 33474,1187,706, 617,839,617, 
2, // chain 218
934,1183,934, 937,1186,937, 620,842,620, 
621,843,621, 
2, // chain 219
573,790,573, 574,791,574, 679,901,679, 
33446,900,678, 
4, // chain 220
935,1188,935, 929,1176,929, 930,1177,930, 
936,1189,936, 33474,928,706, 33473,927,705, 
13, // chain 221
838,1081,838, 771,1000,771, 773,1002,773, 
828,1071,828, 33542,1003,774, 750,979,750, 33706,1190,938, 33543,1004,775, 939,1191,939, 33544,1005,776, 940,1192,940, 33709,1193,941, 33545,1006,777, 942,1194,942, 33546,1007,778, 
3, // chain 222
943,1195,943, 944,1196,944, 702,1197,702, 
682,1198,682, 33449,1199,681, 
9, // chain 223
702,1197,702, 944,1196,944, 707,1200,707, 
33282,1201,514, 33511,1164,743, 33688,1163,920, 33711,1195,943, 919,1162,919, 33450,1198,682, 817,1060,817, 818,1061,818, 
6, // chain 224
816,1056,816, 691,1057,691, 945,1202,945, 
946,1203,946, 33533,1204,765, 33532,1205,764, 33497,1206,729, 33459,1057,691, 
8, // chain 225
816,1056,816, 946,1203,946, 815,1054,815, 
33678,1153,910, 33533,1204,765, 761,1207,761, 767,1208,767, 909,1152,909, 33614,1209,846, 908,1151,908, 
2, // chain 226
815,1054,815, 910,1153,910, 911,1154,911, 
814,1053,814, 
1, // chain 227
770,999,770, 842,1085,842, 769,998,769, 
1, // chain 228
707,1200,707, 514,1201,514, 515,1210,515, 
1, // chain 229
764,1205,764, 729,1206,729, 565,1211,565, 
2, // chain 230
526,738,526, 764,993,764, 565,1212,565, 
525,737,525, 
1, // chain 231
590,930,590, 707,931,707, 515,1213,515, 
2, // chain 232
937,1186,937, 618,840,618, 619,841,619, 
620,842,620, 
17, // chain 233
947,1214,947, 577,794,577, 948,1215,948, 
949,1216,949, 33718,1217,950, 33719,1218,951, 33720,1219,952, 33345,794,577, 578,795,578, 632,854,632, 953,1220,953, 33436,890,668, 708,932,708, 710,934,710, 951,1218,951, 33718,1217,950, 33479,935,711, 715,939,715, 33480,936,712, 
6, // chain 234
576,793,576, 577,794,577, 954,1221,954, 
780,1222,780, 33723,1223,955, 33724,1224,956, 33715,1214,947, 33345,794,577, 
1, // chain 235
576,793,576, 780,1222,780, 558,770,558, 
2, // chain 236
817,1225,817, 682,904,682, 683,905,683, 
684,906,684, 
10, // chain 237
957,1226,957, 917,1160,917, 958,1227,958, 
959,1228,959, 33728,1229,960, 33729,1230,961, 33730,1231,962, 33685,1160,917, 918,1161,918, 963,1232,963, 33592,1067,824, 33591,1066,823, 
15, // chain 238
916,1159,916, 917,1160,917, 957,1226,957, 
964,1233,964, 33727,1228,959, 719,1234,719, 33728,1229,960, 723,1235,723, 33733,1236,965, 33729,1230,961, 966,1237,966, 33735,1238,967, 33730,1231,962, 963,1232,963, 968,1239,968, 33593,1068,825, 33592,1067,824, 
10, // chain 239
685,907,685, 686,908,686, 787,1240,787, 
33556,1241,788, 33455,909,687, 969,1242,969, 33423,877,655, 656,878,656, 657,879,657, 795,1243,795, 788,1241,788, 33559,1244,791, 
7, // chain 240
717,941,717, 720,944,720, 715,939,715, 
33738,1245,970, 33739,1246,971, 33489,945,721, 972,1247,972, 33741,1248,973, 33490,946,722, 
2, // chain 241
949,1216,949, 950,1217,950, 970,1245,970, 
33483,939,715, 
1, // chain 242
951,1218,951, 952,1219,952, 953,1220,953, 
1, // chain 243
660,882,660, 703,925,703, 659,881,659, 
1, // chain 244
729,956,729, 691,913,691, 692,914,692, 
4, // chain 245
719,1234,719, 718,1249,718, 964,1233,964, 
33484,1045,716, 808,1044,808, 916,1159,916, 
3, // chain 246
782,1016,782, 974,1250,974, 975,1251,975, 
553,1252,553, 33323,1253,555, 
5, // chain 247
975,1251,975, 974,1250,974, 976,1254,976, 
33745,1255,977, 33515,976,747, 33551,1017,783, 33550,1016,782, 
4, // chain 248
939,1191,939, 940,1192,940, 978,1256,978, 
977,1255,977, 33747,1257,979, 976,1254,976, 
1, // chain 249
941,1193,941, 980,1258,980, 940,1192,940, 
7, // chain 250
981,1259,981, 982,1260,982, 971,1246,971, 
972,1247,972, 983,1261,983, 33741,1248,973, 984,1262,984, 941,1263,941, 33748,1264,980, 
8, // chain 251
971,1246,971, 982,1260,982, 985,1265,985, 
33723,1223,955, 33547,1266,779, 33546,1267,778, 33710,1268,942, 33749,1259,981, 983,1261,983, 941,1263,941, 
3, // chain 252
955,1223,955, 956,1224,956, 985,1265,985, 
33717,1216,949, 33715,1214,947, 
1, // chain 253
955,1223,955, 779,1266,779, 780,1222,780, 
4, // chain 254
748,977,748, 749,978,749, 750,979,750, 
938,1190,938, 977,1255,977, 33707,1191,939, 
1, // chain 255
747,976,747, 748,977,748, 977,1255,977, 
1, // chain 256
735,964,735, 747,976,747, 783,1017,783, 
2, // chain 257
985,1265,985, 949,1216,949, 970,1245,970, 
971,1246,971, 
3, // chain 258
549,1014,549, 781,1015,781, 550,1269,550, 
33321,1252,553, 33550,1016,782, 
18, // chain 259
975,1270,975, 976,1271,976, 986,1272,986, 
555,1273,555, 33755,1274,987, 33756,1275,988, 33757,1276,989, 33758,1277,990, 33744,1271,976, 991,1278,991, 33747,1279,979, 978,1280,978, 992,1281,992, 33761,1282,993, 33708,1283,940, 980,1284,980, 994,1285,994, 33752,1286,984, 995,1287,995, 
33741,1288,973, 
89, // chain 260
996,1289,996, 993,1282,993, 997,1290,997, 
998,1291,998, 33767,1292,999, 1000,1293,1000, 1001,1294,1001, 33770,1295,1002, 33771,1296,1003, 33772,1297,1004, 33773,1298,1005, 1006,1299,1006, 1003,1296,1003, 33775,1300,1007, 1008,1301,1008, 1009,1302,1009, 33778,1303,1010, 33779,1304,1011, 1012,1305,1012, 
33781,1306,1013, 1014,1307,1014, 1015,1308,1015, 33784,1309,1016, 1017,1310,1017, 1018,1311,1018, 33787,1312,1019, 33788,1313,1020, 1021,1314,1021, 1022,1315,1022, 33791,1316,1023, 33792,1317,1024, 1025,1318,1025, 33794,1319,1026, 33795,1320,1027, 1028,1321,1028, 
33797,1322,1029, 1030,1323,1030, 33799,1324,1031, 1032,1325,1032, 33801,1326,1033, 1034,1327,1034, 33803,1328,1035, 1036,1329,1036, 1037,1330,1037, 1038,1331,1038, 1039,1332,1039, 33808,1333,1040, 1041,1334,1041, 33810,1335,1042, 1043,1336,1043, 33812,1337,1044, 
1045,1338,1045, 33814,1339,1046, 1047,1340,1047, 33816,1341,1048, 33817,1342,1049, 1050,1343,1050, 33819,1344,1051, 33820,1345,1052, 1053,1346,1053, 1054,1347,1054, 33823,1348,1055, 33824,1349,1056, 1057,1350,1057, 1058,1351,1058, 33827,1352,1059, 1060,1353,1060, 
1061,1354,1061, 33830,1355,1062, 1063,1356,1063, 33832,1357,1064, 33833,1358,1065, 1066,1359,1066, 1067,1360,1067, 33836,1361,1068, 1069,1362,1069, 1064,1357,1064, 33838,1363,1070, 33839,1364,1071, 33840,1365,1072, 33841,1366,1073, 988,1275,988, 989,1276,989, 
1074,1367,1074, 33758,1277,990, 991,1278,991, 1075,1368,1075, 33844,1369,1076, 33760,1281,992, 996,1289,996, 33761,1282,993, 
2, // chain 261
997,1290,997, 993,1282,993, 994,1285,994, 
995,1287,995, 
11, // chain 262
1077,1370,1077, 1078,1371,1078, 723,1235,723, 
965,1236,965, 1079,1372,1079, 33734,1237,966, 1080,1373,1080, 33849,1374,1081, 33735,1238,967, 968,1239,968, 1082,1375,1082, 33594,1069,826, 33593,1068,825, 
3, // chain 263
723,1235,723, 1078,1371,1078, 722,1376,722, 
33741,1377,973, 33763,1378,995, 
2, // chain 264
1083,1379,1083, 1078,1371,1078, 1077,1370,1077, 
1079,1372,1079, 
11, // chain 265
1084,1380,1084, 1085,1381,1085, 807,1382,807, 
794,1383,794, 1086,1384,1086, 33564,1385,796, 1087,1386,1087, 33756,1387,988, 1088,1388,1088, 33857,1389,1089, 33841,1390,1073, 1068,1391,1068, 33837,1392,1069, 
34, // chain 266
807,1382,807, 1085,1381,1085, 806,1393,806, 
33595,1394,827, 33858,1395,1090, 33859,1396,1091, 33852,1380,1084, 1092,1397,1092, 33854,1384,1086, 1093,1398,1093, 33862,1399,1094, 33855,1386,1087, 1088,1388,1088, 1093,1398,1093, 33863,1400,1095, 33864,1401,1096, 33857,1389,1089, 1097,1402,1097, 33836,1391,1068, 
1098,1403,1098, 33867,1404,1099, 33834,1405,1066, 1100,1406,1100, 33833,1407,1065, 1062,1408,1062, 1101,1409,1101, 33828,1410,1060, 1102,1411,1102, 33827,1412,1059, 1103,1413,1103, 33872,1414,1104, 33825,1415,1057, 1056,1416,1056, 1105,1417,1105, 33820,1418,1052, 
33821,1419,1053, 
6, // chain 267
1106,1420,1106, 1083,1421,1083, 1107,1422,1107, 
1108,1423,1108, 33877,1424,1109, 33848,1425,1080, 33847,1426,1079, 33851,1421,1083, 
9, // chain 268
1110,1427,1110, 1078,1428,1078, 1106,1420,1106, 
1111,1429,1111, 33876,1423,1108, 1112,1430,1112, 33881,1431,1113, 33877,1424,1109, 1114,1432,1114, 33883,1433,1115, 33848,1425,1080, 
1, // chain 269
1106,1420,1106, 1078,1428,1078, 1083,1421,1083, 
3, // chain 270
555,1273,555, 987,1274,987, 554,1434,554, 
33564,1435,796, 33756,1275,988, 
1, // chain 271
554,1434,554, 796,1435,796, 657,1436,657, 
53, // chain 272
1116,1437,1116, 1117,1438,1117, 1118,1439,1118, 
1119,1440,1119, 33888,1441,1120, 33812,1442,1044, 33814,1443,1046, 33889,1444,1121, 33890,1445,1122, 33885,1438,1117, 1123,1446,1123, 33892,1447,1124, 33893,1448,1125, 33884,1437,1116, 1126,1449,1126, 33895,1450,1127, 33896,1451,1128, 33897,1452,1129, 33887,1440,1119, 
1130,1453,1130, 33899,1454,1131, 33888,1441,1120, 1132,1455,1132, 33812,1442,1044, 1133,1456,1133, 33902,1457,1134, 33810,1458,1042, 1135,1459,1135, 33808,1460,1040, 1136,1461,1136, 33806,1462,1038, 1137,1463,1137, 33805,1464,1037, 1138,1465,1138, 33804,1466,1036, 
1035,1467,1035, 1139,1468,1139, 33801,1469,1033, 1140,1470,1140, 33799,1471,1031, 1141,1472,1141, 33797,1473,1029, 1142,1474,1142, 33795,1475,1027, 1143,1476,1143, 33912,1477,1144, 33913,1478,1145, 33914,1479,1146, 33792,1480,1024, 1147,1481,1147, 33789,1482,1021, 
1148,1483,1148, 33788,1484,1020, 1016,1485,1016, 33785,1486,1017, 
29, // chain 273
1149,1487,1149, 1146,1479,1146, 1150,1488,1150, 
1151,1489,1151, 33920,1490,1152, 33921,1491,1153, 33922,1492,1154, 33914,1479,1146, 1147,1481,1147, 1155,1493,1155, 33924,1494,1156, 33916,1483,1148, 1157,1495,1157, 33784,1485,1016, 1014,1496,1014, 1013,1497,1013, 1158,1498,1158, 33927,1499,1159, 33779,1500,1011, 
1160,1501,1160, 33776,1502,1008, 1161,1503,1161, 33775,1504,1007, 1006,1505,1006, 1162,1506,1162, 33773,1507,1005, 1163,1508,1163, 33932,1509,1164, 33933,1510,1165, 33767,1511,999, 33768,1512,1000, 
26, // chain 274
1166,1513,1166, 1149,1487,1149, 1151,1489,1151, 
1167,1514,1167, 33936,1515,1168, 33920,1490,1152, 1169,1516,1169, 33921,1491,1153, 1170,1517,1170, 33939,1518,1171, 33922,1492,1154, 1172,1519,1172, 33923,1493,1155, 1173,1520,1173, 33924,1494,1156, 1157,1495,1157, 1174,1521,1174, 33926,1498,1158, 1168,1515,1168, 
33927,1499,1159, 1167,1514,1167, 33928,1501,1160, 1175,1522,1175, 33944,1523,1176, 33945,1524,1177, 33946,1525,1178, 33930,1506,1162, 33929,1503,1161, 
10, // chain 275
1179,1526,1179, 1180,1527,1180, 1102,1411,1102, 
1103,1413,1103, 1181,1528,1181, 33872,1414,1104, 1182,1529,1182, 33951,1530,1183, 33873,1417,1105, 1121,1444,1121, 33817,1531,1049, 33820,1418,1052, 
2, // chain 276
1180,1527,1180, 1184,1532,1184, 1101,1409,1101, 
1102,1411,1102, 
6, // chain 277
1184,1532,1184, 1180,1527,1180, 1126,1449,1126, 
1127,1450,1127, 1101,1409,1101, 33953,1533,1185, 33897,1452,1129, 33896,1451,1128, 
18, // chain 278
1126,1449,1126, 1180,1527,1180, 1125,1448,1125, 
33947,1526,1179, 1124,1447,1124, 33954,1534,1186, 33955,1535,1187, 33949,1528,1181, 1188,1536,1188, 33950,1529,1182, 1189,1537,1189, 33951,1530,1183, 1121,1444,1121, 1122,1445,1122, 1188,1536,1188, 33958,1538,1190, 33891,1446,1123, 1191,1539,1191, 33954,1534,1186, 
33892,1447,1124, 
26, // chain 279
1167,1514,1167, 1175,1522,1175, 1166,1513,1166, 
33944,1523,1176, 1149,1487,1149, 33960,1540,1192, 33961,1541,1193, 33945,1524,1177, 1194,1542,1194, 33946,1525,1178, 1195,1543,1195, 33964,1544,1196, 33930,1506,1162, 1163,1508,1163, 1195,1543,1195, 33965,1545,1197, 33912,1477,1144, 33966,1546,1198, 33967,1547,1199, 
33932,1509,1164, 1200,1548,1200, 33969,1549,1201, 33970,1550,1202, 33971,1551,1203, 33933,1510,1165, 1204,1552,1204, 33765,1553,997, 33767,1511,999, 
81, // chain 280
1205,1554,1205, 1206,1555,1206, 1207,1556,1207, 
1208,1557,1208, 33977,1558,1209, 33978,1559,1210, 33979,1560,1211, 33974,1555,1206, 1212,1561,1212, 33981,1562,1213, 33982,1563,1214, 33973,1554,1205, 1215,1564,1215, 33984,1565,1216, 33985,1566,1217, 33976,1557,1208, 1218,1567,1218, 33987,1568,1219, 33977,1558,1209, 
1220,1569,1220, 33989,1570,1221, 33978,1559,1210, 1222,1571,1222, 33991,1572,1223, 33979,1560,1211, 1224,1573,1224, 33980,1561,1212, 1225,1574,1225, 33994,1575,1226, 33995,1576,1227, 33996,1577,1228, 33981,1562,1213, 1229,1578,1229, 33998,1579,1230, 33999,1580,1231, 
33982,1563,1214, 1232,1581,1232, 34001,1582,1233, 34002,1583,1234, 34003,1584,1235, 33983,1564,1215, 1236,1585,1236, 33984,1565,1216, 1237,1586,1237, 34006,1587,1238, 33985,1566,1217, 1218,1567,1218, 1239,1588,1239, 34008,1589,1240, 33866,1403,1098, 33865,1402,1097, 
34009,1590,1241, 33987,1568,1219, 1242,1591,1242, 33988,1569,1220, 1243,1592,1243, 34012,1593,1244, 33989,1570,1221, 1245,1594,1245, 33990,1571,1222, 1246,1595,1246, 34015,1596,1247, 34016,1597,1248, 34017,1598,1249, 33991,1572,1223, 1250,1599,1250, 33992,1573,1224, 
1225,1574,1225, 1251,1600,1251, 34020,1601,1252, 34021,1602,1253, 34022,1603,1254, 33994,1575,1226, 1227,1576,1227, 1255,1604,1255, 33996,1577,1228, 1256,1605,1256, 34025,1606,1257, 33997,1578,1229, 1258,1607,1258, 33998,1579,1230, 1232,1581,1232, 33999,1580,1231, 
31, // chain 281
1259,1608,1259, 1260,1609,1260, 1261,1610,1261, 
1262,1611,1262, 34031,1612,1263, 34032,1613,1264, 34033,1614,1265, 34028,1609,1260, 1247,1596,1247, 34034,1615,1266, 34035,1616,1267, 34027,1608,1259, 1268,1617,1268, 34037,1618,1269, 34038,1619,1270, 34030,1611,1262, 1271,1620,1271, 34040,1621,1272, 34041,1622,1273, 
34042,1623,1274, 34043,1624,1275, 34031,1612,1263, 1276,1625,1276, 34045,1626,1277, 34046,1627,1278, 34032,1613,1264, 1279,1628,1279, 34048,1629,1280, 34049,1630,1281, 34050,1631,1282, 34033,1614,1265, 1248,1597,1248, 34015,1596,1247, 
31, // chain 282
1283,1632,1283, 1284,1633,1284, 1285,1634,1285, 
1286,1635,1286, 34055,1636,1287, 34056,1637,1288, 34052,1633,1284, 1289,1638,1289, 34058,1639,1290, 34059,1640,1291, 34051,1632,1283, 1292,1641,1292, 34061,1642,1293, 34062,1643,1294, 34063,1644,1295, 34064,1645,1296, 34065,1646,1297, 34066,1647,1298, 34067,1648,1299, 
34068,1649,1300, 34069,1650,1301, 34070,1651,1302, 34071,1652,1303, 34054,1635,1286, 1304,1653,1304, 34055,1636,1287, 1305,1654,1305, 34056,1637,1288, 1289,1638,1289, 1306,1655,1306, 34075,1656,1307, 34076,1657,1308, 34077,1658,1309, 
23, // chain 283
1305,1654,1305, 1310,1659,1310, 1311,1660,1311, 
1312,1661,1312, 34068,1649,1300, 34081,1662,1313, 1299,1648,1299, 34082,1663,1314, 1298,1647,1298, 34083,1664,1315, 1297,1646,1297, 34084,1665,1316, 1296,1645,1296, 34085,1666,1317, 1295,1644,1295, 34086,1667,1318, 1319,1668,1319, 1294,1643,1294, 34088,1669,1320, 
1293,1642,1293, 34089,1670,1321, 1292,1641,1292, 34090,1671,1322, 1291,1640,1291, 34058,1639,1290, 
3, // chain 284
1323,1672,1323, 1305,1654,1305, 1312,1661,1312, 
1301,1650,1301, 34068,1649,1300, 
3, // chain 285
1304,1653,1304, 1305,1654,1305, 1323,1672,1323, 
1302,1651,1302, 34069,1650,1301, 
1, // chain 286
1302,1651,1302, 1303,1652,1303, 1304,1653,1304, 
5, // chain 287
1305,1654,1305, 1306,1655,1306, 1324,1673,1324, 
34093,1674,1325, 34075,1656,1307, 1326,1675,1326, 34076,1657,1308, 
14, // chain 288
1310,1659,1310, 1305,1654,1305, 1327,1676,1327, 
1328,1677,1328, 34097,1678,1329, 34098,1679,1330, 34073,1654,1305, 1331,1680,1331, 34100,1681,1332, 34101,1682,1333, 34102,1683,1334, 34092,1673,1324, 1335,1684,1335, 34093,1674,1325, 1336,1685,1336, 34094,1675,1326, 
16, // chain 289
1337,1686,1337, 1310,1659,1310, 1328,1677,1328, 
1338,1687,1338, 34107,1688,1339, 34097,1678,1329, 1340,1689,1340, 34109,1690,1341, 34098,1679,1330, 1331,1680,1331, 1342,1691,1342, 34100,1681,1332, 1333,1682,1333, 1343,1692,1343, 34102,1683,1334, 1335,1684,1335, 1344,1693,1344, 34104,1685,1336, 
3, // chain 290
1311,1660,1311, 1310,1659,1310, 1337,1686,1337, 
1345,1694,1345, 34106,1687,1338, 
21, // chain 291
1346,1695,1346, 1347,1696,1347, 1322,1697,1322, 
1321,1698,1321, 1348,1699,1348, 34088,1700,1320, 1349,1701,1349, 34087,1702,1319, 1350,1703,1350, 34086,1704,1318, 1351,1705,1351, 34120,1706,1352, 34085,1707,1317, 1353,1708,1353, 34084,1709,1316, 1354,1710,1354, 34083,1711,1315, 1355,1712,1355, 34082,1713,1314, 
1356,1714,1356, 34081,1715,1313, 1202,1550,1202, 34079,1716,1311, 
33, // chain 292
1322,1697,1322, 1347,1696,1347, 1290,1717,1290, 
34077,1718,1309, 33863,1400,1095, 34114,1695,1346, 1357,1719,1357, 34116,1699,1348, 1358,1720,1358, 34127,1721,1359, 34117,1701,1349, 1360,1722,1360, 34118,1703,1350, 1361,1723,1361, 34119,1705,1351, 1352,1706,1352, 1362,1724,1362, 34121,1708,1353, 1363,1725,1363, 
34122,1710,1354, 1112,1430,1112, 34132,1726,1364, 34123,1712,1355, 1365,1727,1365, 34124,1714,1356, 1202,1550,1202, 1203,1551,1203, 1204,1552,1204, 1366,1728,1366, 34135,1729,1367, 34136,1730,1368, 33765,1553,997, 995,1731,995, 1110,1427,1110, 33846,1428,1078, 
1, // chain 293
1290,1717,1290, 1309,1718,1309, 1289,1732,1289, 
1, // chain 294
1345,1694,1345, 1202,1733,1202, 1311,1660,1311, 
4, // chain 295
1343,1692,1343, 1344,1693,1344, 1369,1734,1369, 
1342,1691,1342, 34109,1690,1341, 34108,1689,1340, 
2, // chain 296
1190,1538,1190, 1191,1539,1191, 1187,1535,1187, 
33954,1534,1186, 
6, // chain 297
1170,1517,1170, 1171,1518,1171, 1370,1735,1370, 
1169,1516,1169, 33936,1515,1168, 33942,1521,1174, 33940,1519,1172, 33939,1518,1171, 
1, // chain 298
1190,1538,1190, 1187,1535,1187, 1188,1536,1188, 
69, // chain 299
1101,1409,1101, 1185,1533,1185, 1371,1736,1371, 
34140,1737,1372, 33897,1452,1129, 1130,1453,1130, 1371,1736,1371, 34141,1738,1373, 33866,1403,1098, 33899,1454,1131, 1132,1455,1132, 1240,1589,1240, 34007,1588,1239, 33901,1456,1133, 1374,1739,1374, 34143,1740,1375, 33902,1457,1134, 1376,1741,1376, 33903,1459,1135, 
1377,1742,1377, 33904,1461,1136, 1378,1743,1378, 33905,1463,1137, 1379,1744,1379, 33906,1465,1138, 1139,1468,1139, 1380,1745,1380, 33908,1470,1140, 1381,1746,1381, 33909,1472,1141, 1382,1747,1382, 33910,1474,1142, 1383,1748,1383, 33911,1476,1143, 1384,1749,1384, 
34153,1750,1385, 33912,1477,1144, 1198,1546,1198, 1199,1547,1199, 1386,1751,1386, 34036,1617,1268, 34035,1616,1267, 34155,1752,1387, 33968,1548,1200, 1388,1753,1388, 34157,1754,1389, 34158,1755,1390, 33969,1549,1201, 1202,1550,1202, 1345,1756,1345, 1338,1757,1338, 
1391,1758,1391, 34107,1759,1339, 1392,1760,1392, 34108,1761,1340, 1393,1762,1393, 34137,1763,1369, 1245,1594,1245, 34012,1593,1244, 34112,1764,1344, 1243,1592,1243, 34104,1765,1336, 1394,1766,1394, 34094,1767,1326, 1395,1768,1395, 34076,1769,1308, 1309,1718,1309, 
1396,1770,1396, 33865,1402,1097, 33864,1401,1096, 33863,1400,1095, 
4, // chain 300
1099,1404,1099, 1100,1406,1100, 1101,1409,1101, 
1371,1736,1371, 1373,1738,1373, 1098,1403,1098, 
6, // chain 301
1197,1545,1197, 1144,1477,1144, 1145,1478,1145, 
1397,1771,1397, 33914,1479,1146, 1149,1487,1149, 1193,1541,1193, 33960,1540,1192, 
3, // chain 302
1193,1541,1193, 1194,1542,1194, 1195,1543,1195, 
1397,1771,1397, 33965,1545,1197, 
1, // chain 303
1172,1519,1172, 1173,1520,1173, 1174,1521,1174, 
7, // chain 304
1054,1347,1054, 1058,1351,1058, 1398,1772,1398, 
1051,1344,1051, 33818,1343,1050, 34167,1773,1399, 33831,1356,1063, 33829,1354,1061, 33826,1351,1058, 
2, // chain 305
1018,1311,1018, 1400,1774,1400, 1012,1305,1012, 
1015,1308,1015, 
6, // chain 306
1012,1305,1012, 1400,1774,1400, 1010,1303,1010, 
33777,1302,1009, 34169,1775,1401, 33790,1315,1022, 33787,1312,1019, 33786,1311,1018, 
2, // chain 307
1399,1773,1399, 1063,1356,1063, 1070,1363,1070, 
33832,1357,1064, 
5, // chain 308
1009,1302,1009, 1401,1775,1401, 1002,1295,1002, 
33769,1294,1001, 34170,1776,1402, 33791,1316,1023, 33790,1315,1022, 
4, // chain 309
1050,1343,1050, 1399,1773,1399, 1048,1341,1048, 
34171,1777,1403, 33839,1364,1071, 33838,1363,1070, 
1, // chain 310
1121,1444,1121, 1049,1531,1049, 1046,1443,1046, 
6, // chain 311
1097,1402,1097, 1241,1590,1241, 1396,1770,1396, 
34163,1768,1395, 34172,1778,1404, 34010,1591,1242, 1394,1766,1394, 34011,1592,1243, 
14, // chain 312
1071,1364,1071, 1072,1365,1072, 1405,1779,1405, 
1403,1777,1403, 34174,1780,1406, 34175,1781,1407, 34176,1782,1408, 34177,1783,1409, 33840,1365,1072, 1074,1367,1074, 1075,1368,1075, 1408,1782,1408, 34178,1784,1410, 33844,1369,1076, 998,1291,998, 33764,1289,996, 
41, // chain 313
998,1291,998, 1001,1294,1001, 1411,1785,1411, 
34170,1776,1402, 1412,1786,1412, 34181,1787,1413, 33791,1316,1023, 1025,1318,1025, 1414,1788,1414, 34183,1789,1415, 34184,1790,1416, 33794,1319,1026, 1417,1791,1417, 33796,1321,1028, 1418,1792,1418, 33798,1323,1030, 1419,1793,1419, 33800,1325,1032, 1420,1794,1420, 
33802,1327,1034, 1039,1332,1039, 1421,1795,1421, 33809,1334,1041, 1422,1796,1422, 33811,1336,1043, 1423,1797,1423, 33813,1338,1045, 1424,1798,1424, 33815,1340,1047, 1425,1799,1425, 34194,1800,1426, 34195,1801,1427, 33816,1341,1048, 1403,1777,1403, 1406,1780,1406, 
1426,1800,1426, 34196,1802,1428, 34175,1781,1407, 1412,1786,1412, 34179,1785,1411, 34176,1782,1408, 1410,1784,1410, 998,1291,998, 
20, // chain 314
1413,1787,1413, 1414,1788,1414, 1412,1786,1412, 
34196,1802,1428, 34197,1803,1429, 34198,1804,1430, 34183,1789,1415, 1431,1805,1431, 34184,1790,1416, 1417,1791,1417, 1418,1792,1418, 1419,1793,1419, 1420,1794,1420, 1421,1795,1421, 1422,1796,1422, 1423,1797,1423, 1424,1798,1424, 1425,1799,1425, 1432,1806,1432, 
34194,1800,1426, 1429,1803,1429, 34196,1802,1428, 
1, // chain 315
1002,1295,1002, 1003,1296,1003, 1009,1302,1009, 
1, // chain 316
1055,1348,1055, 1058,1351,1058, 1054,1347,1054, 
12, // chain 317
1433,1807,1433, 1434,1808,1434, 1233,1582,1233, 
1234,1583,1234, 1435,1809,1435, 34204,1810,1436, 34003,1584,1235, 1236,1585,1236, 1437,1811,1437, 34206,1812,1438, 34005,1586,1237, 1439,1813,1439, 34007,1588,1239, 34006,1587,1238, 
15, // chain 318
1440,1814,1440, 1273,1622,1273, 1441,1815,1441, 
1442,1816,1442, 34211,1817,1443, 34212,1818,1444, 34213,1819,1445, 34214,1820,1446, 34215,1821,1447, 34041,1622,1273, 1448,1822,1448, 34217,1823,1449, 34218,1824,1450, 34042,1623,1274, 1451,1825,1451, 34044,1625,1276, 34043,1624,1275, 
8, // chain 319
1233,1582,1233, 1434,1808,1434, 1452,1826,1452, 
34221,1827,1453, 34222,1828,1454, 34223,1829,1455, 34224,1830,1456, 34225,1831,1457, 34201,1807,1433, 1435,1809,1435, 
24, // chain 320
1458,1832,1458, 1459,1833,1459, 1460,1834,1460, 
1461,1835,1461, 34230,1836,1462, 34231,1837,1463, 34227,1833,1459, 1464,1838,1464, 33858,1395,1090, 34233,1839,1465, 34234,1840,1466, 34226,1832,1458, 1467,1841,1467, 34229,1835,1461, 1468,1842,1468, 34237,1843,1469, 34230,1836,1462, 1470,1844,1470, 34239,1845,1471, 
34231,1837,1463, 1360,1722,1360, 34127,1721,1359, 34232,1838,1464, 1358,1720,1358, 33859,1396,1091, 33858,1395,1090, 
3, // chain 321
1468,1842,1468, 1469,1843,1469, 1114,1432,1114, 
1466,1840,1466, 33883,1433,1115, 
7, // chain 322
1114,1432,1114, 1469,1843,1469, 1470,1844,1470, 
1113,1431,1113, 34131,1725,1363, 34130,1724,1362, 34239,1845,1471, 1361,1723,1361, 34128,1722,1360, 
1, // chain 323
1466,1840,1466, 1467,1841,1467, 1468,1842,1468, 
4, // chain 324
1431,1805,1431, 1432,1806,1432, 1472,1846,1472, 
34197,1803,1429, 1430,1804,1430, 1431,1805,1431, 
4, // chain 325
1093,1398,1093, 1095,1400,1095, 1357,1719,1357, 
1092,1397,1092, 34126,1720,1358, 1091,1396,1091, 
5, // chain 326
1364,1726,1364, 1365,1727,1365, 1366,1728,1366, 
1111,1429,1111, 33878,1427,1110, 34135,1729,1367, 1368,1730,1368, 
1, // chain 327
1112,1430,1112, 1364,1726,1364, 1111,1429,1111, 
6, // chain 328
1473,1847,1473, 1281,1630,1281, 1252,1601,1252, 
1474,1848,1474, 34021,1602,1253, 1256,1605,1256, 34022,1603,1254, 1255,1604,1255, 
5, // chain 329
1252,1601,1252, 1281,1630,1281, 1251,1600,1251, 
34018,1599,1250, 34050,1631,1282, 1248,1597,1248, 1249,1598,1249, 
6, // chain 330
1475,1849,1475, 1279,1628,1279, 1476,1850,1476, 
1477,1851,1477, 34241,1847,1473, 34049,1630,1281, 34048,1629,1280, 34047,1628,1279, 
4, // chain 331
1278,1627,1278, 1475,1849,1475, 1477,1851,1477, 
1478,1852,1478, 34242,1848,1474, 34241,1847,1473, 
1, // chain 332
1278,1627,1278, 1279,1628,1279, 1475,1849,1475, 
17, // chain 333
1256,1605,1256, 1257,1606,1257, 1474,1848,1474, 
34247,1853,1479, 34026,1607,1258, 1450,1824,1450, 34000,1581,1232, 1233,1582,1233, 1449,1823,1449, 34216,1822,1448, 34220,1826,1452, 1480,1854,1480, 34221,1827,1453, 1377,1742,1377, 34249,1855,1481, 34222,1828,1454, 1482,1856,1482, 34251,1857,1483, 34223,1829,1455, 
4, // chain 334
1277,1626,1277, 1278,1627,1278, 1478,1852,1478, 
1451,1825,1451, 34247,1853,1479, 34242,1848,1474, 
1, // chain 335
1394,1766,1394, 1395,1768,1395, 1404,1778,1404, 
7, // chain 336
1389,1754,1389, 1390,1755,1390, 1391,1758,1391, 
1388,1753,1388, 34160,1760,1392, 1484,1858,1484, 34161,1762,1393, 1246,1595,1246, 34013,1594,1245, 
1, // chain 337
1113,1431,1113, 1363,1725,1363, 1112,1430,1112, 
3, // chain 338
1266,1615,1266, 1387,1752,1387, 1484,1858,1484, 
1246,1595,1246, 1247,1596,1247, 
1, // chain 339
1484,1858,1484, 1387,1752,1387, 1388,1753,1388, 
1, // chain 340
1267,1616,1267, 1387,1752,1387, 1266,1615,1266, 
10, // chain 341
1485,1859,1485, 1438,1812,1438, 1439,1813,1439, 
1486,1860,1486, 34255,1861,1487, 34007,1588,1239, 1374,1739,1374, 1488,1862,1488, 34143,1740,1375, 1376,1741,1376, 1481,1855,1481, 34145,1742,1377, 
13, // chain 342
1489,1863,1489, 1490,1864,1490, 1491,1865,1491, 
1492,1866,1492, 34261,1867,1493, 34262,1868,1494, 34263,1869,1495, 34258,1864,1490, 1385,1750,1385, 34264,1870,1496, 34265,1871,1497, 34257,1863,1489, 1498,1872,1498, 34267,1873,1499, 34260,1866,1492, 
3, // chain 343
1494,1868,1494, 1495,1869,1495, 1269,1618,1269, 
34154,1751,1386, 34153,1750,1385, 
1, // chain 344
1269,1618,1269, 1386,1751,1386, 1268,1617,1268, 
7, // chain 345
1500,1874,1500, 1501,1875,1501, 1485,1859,1485, 
1502,1876,1502, 34254,1860,1486, 1482,1856,1482, 34255,1861,1487, 1488,1862,1488, 1481,1855,1481, 
2, // chain 346
1485,1859,1485, 1501,1875,1501, 1438,1812,1438, 
34205,1811,1437, 
4, // chain 347
1382,1747,1382, 1383,1748,1383, 1503,1877,1503, 
34152,1749,1384, 1496,1870,1496, 34153,1750,1385, 
8, // chain 348
1382,1747,1382, 1503,1877,1503, 1504,1878,1504, 
34273,1879,1505, 34264,1870,1496, 1497,1871,1497, 1498,1872,1498, 1506,1880,1506, 1445,1819,1445, 34212,1818,1444, 
4, // chain 349
1381,1746,1381, 1382,1747,1382, 1504,1878,1504, 
1446,1820,1446, 34213,1819,1445, 34273,1879,1505, 
3, // chain 350
1272,1621,1272, 1273,1622,1273, 1440,1814,1440, 
1507,1881,1507, 34210,1816,1442, 
11, // chain 351
1377,1742,1377, 1378,1743,1378, 1480,1854,1480, 
34276,1882,1508, 34147,1744,1379, 1380,1745,1380, 1509,1883,1509, 34149,1746,1381, 1446,1820,1446, 1447,1821,1447, 1448,1822,1448, 1508,1882,1508, 34248,1854,1480, 
1, // chain 352
1451,1825,1451, 1276,1625,1276, 1277,1626,1277, 
1, // chain 353
1451,1825,1451, 1479,1853,1479, 1450,1824,1450, 
5, // chain 354
1494,1868,1494, 1269,1618,1269, 1270,1619,1270, 
1271,1620,1271, 1510,1884,1510, 34040,1621,1272, 1507,1881,1507, 
2, // chain 355
1082,1375,1082, 826,1069,826, 1465,1885,1465, 
33595,1070,827, 
4, // chain 356
1082,1375,1082, 1465,1885,1465, 1466,1886,1466, 
1115,1887,1115, 1081,1374,1081, 33848,1373,1080, 
1, // chain 357
1465,1839,1465, 827,1394,827, 1090,1395,1090, 
1, // chain 358
1510,1884,1510, 1493,1867,1493, 1494,1868,1494, 
1, // chain 359
1482,1856,1482, 1483,1857,1483, 1502,1876,1502, 

 0};


// face array: 3kb.
const uint16_t sinbad_2_face[1808] PROGMEM = {
49, // chain 0
1511,1888,1511, 1512,1889,1512, 1513,1890,1513, 
1514,1891,1514, 34283,1892,1515, 34284,1893,1516, 34285,1894,1517, 34286,1895,1518, 34280,1889,1512, 1519,1896,1519, 1520,1897,1520, 34289,1898,1521, 1522,1899,1522, 34291,1900,1523, 1524,1901,1524, 34293,1902,1525, 34294,1903,1526, 1527,1904,1527, 1528,1905,1528, 
34297,1906,1529, 1530,1907,1530, 34299,1908,1531, 1532,1909,1532, 34282,1891,1514, 1515,1892,1515, 1533,1910,1533, 34284,1893,1516, 1534,1911,1534, 34285,1894,1517, 1518,1895,1518, 1532,1909,1532, 34303,1912,1535, 34304,1913,1536, 34288,1897,1520, 1537,1914,1537, 
34298,1907,1530, 34306,1915,1538, 34307,1916,1539, 34290,1899,1522, 1540,1917,1540, 34296,1905,1528, 34309,1918,1541, 34310,1919,1542, 34292,1901,1524, 1543,1920,1543, 34293,1902,1525, 1544,1921,1544, 34296,1905,1528, 1541,1918,1541, 1543,1920,1543, 34310,1919,1542, 
5, // chain 1
1545,1922,1545, 1540,1917,1540, 1528,1905,1528, 
1530,1907,1530, 1538,1915,1538, 1540,1917,1540, 34307,1916,1539, 
5, // chain 2
1546,1923,1546, 1537,1914,1537, 1530,1907,1530, 
1532,1909,1532, 1535,1912,1535, 1537,1914,1537, 34304,1913,1536, 
1, // chain 3
1532,1909,1532, 1533,1910,1533, 1534,1911,1534, 
29, // chain 4
1547,1924,1547, 1548,1925,1548, 1549,1926,1549, 
34318,1927,1550, 34319,1928,1551, 1552,1929,1552, 34321,1930,1553, 1554,1931,1554, 34323,1932,1555, 1556,1933,1556, 1557,1934,1557, 34326,1935,1558, 34315,1924,1547, 1549,1926,1549, 1559,1936,1559, 34328,1937,1560, 34318,1927,1550, 1561,1938,1561, 34320,1929,1552, 
1562,1939,1562, 34326,1935,1558, 34331,1940,1563, 34332,1941,1564, 34322,1931,1554, 1565,1942,1565, 34325,1934,1557, 1566,1943,1566, 34326,1935,1558, 1563,1940,1563, 1565,1942,1565, 34332,1941,1564, 
3, // chain 5
1558,1935,1558, 1559,1936,1559, 1562,1939,1562, 
34328,1937,1560, 1561,1938,1561, 
15, // chain 6
1567,1944,1567, 1568,1945,1568, 1569,1946,1569, 
1570,1947,1570, 34339,1948,1571, 34340,1949,1572, 34341,1950,1573, 34336,1945,1568, 1574,1951,1574, 1575,1952,1575, 34344,1953,1576, 34345,1954,1577, 1578,1955,1578, 1579,1956,1579, 34348,1957,1580, 1570,1947,1570, 34335,1944,1567, 
11, // chain 7
1581,1958,1581, 1582,1959,1582, 1576,1953,1576, 
1579,1956,1579, 1583,1960,1583, 34341,1950,1573, 34352,1961,1584, 34353,1962,1585, 34338,1947,1570, 1571,1948,1571, 1584,1961,1584, 34340,1949,1572, 1573,1950,1573, 
4, // chain 8
1576,1953,1576, 1582,1959,1582, 1575,1952,1575, 
34354,1963,1586, 34351,1960,1583, 34349,1958,1581, 
2, // chain 9
1586,1963,1586, 1583,1960,1583, 1573,1950,1573, 
1575,1952,1575, 
20, // chain 10
1587,1964,1587, 1588,1965,1588, 1589,1966,1589, 
1590,1967,1590, 34359,1968,1591, 34360,1969,1592, 34356,1965,1588, 1593,1970,1593, 34362,1971,1594, 34363,1972,1595, 34355,1964,1587, 1596,1973,1596, 34358,1967,1590, 1597,1974,1597, 34366,1975,1598, 34367,1976,1599, 34368,1977,1600, 34359,1968,1591, 1601,1978,1601, 
34360,1969,1592, 1602,1979,1602, 34361,1970,1593, 
14, // chain 11
1603,1980,1603, 1604,1981,1604, 1605,1982,1605, 
1606,1983,1606, 34375,1984,1607, 34376,1985,1608, 34377,1986,1609, 34372,1981,1604, 1610,1987,1610, 34379,1988,1611, 34371,1980,1603, 1612,1989,1612, 34374,1983,1606, 1613,1990,1613, 34382,1991,1614, 34375,1984,1607, 
13, // chain 12
1615,1992,1615, 1608,1985,1608, 1609,1986,1609, 
1616,1993,1616, 34378,1987,1610, 1617,1994,1617, 34379,1988,1611, 1618,1995,1618, 34387,1996,1619, 34388,1997,1620, 34380,1989,1612, 1613,1990,1613, 1621,1998,1621, 34390,1999,1622, 34382,1991,1614, 
10, // chain 13
1596,1973,1596, 1597,1974,1597, 1623,2000,1623, 
34392,2001,1624, 34366,1975,1598, 1625,2002,1625, 34367,1976,1599, 1626,2003,1626, 34368,1977,1600, 1601,1978,1601, 1627,2004,1627, 34370,1979,1602, 
9, // chain 14
1596,1973,1596, 1623,2000,1623, 1595,1972,1595, 
34396,2005,1628, 34397,2006,1629, 34392,2001,1624, 1630,2007,1630, 34393,2002,1625, 1631,2008,1631, 34394,2003,1626, 1627,2004,1627, 
1, // chain 15
1595,1972,1595, 1628,2005,1628, 1594,1971,1594, 
4, // chain 16
1619,1996,1619, 1620,1997,1620, 1621,1998,1621, 
1632,2009,1632, 34401,2010,1633, 34390,1999,1622, 
4, // chain 17
1618,1995,1618, 1619,1996,1619, 1632,2009,1632, 
1634,2011,1634, 34403,2012,1635, 34401,2010,1633, 
4, // chain 18
1617,1994,1617, 1618,1995,1618, 1634,2011,1634, 
1616,1993,1616, 34404,2013,1636, 34403,2012,1635, 
1, // chain 19
1615,1992,1615, 1616,1993,1616, 1636,2013,1636, 
20, // chain 20
1637,2014,1637, 1638,2015,1638, 1639,2016,1639, 
1640,2017,1640, 34409,2018,1641, 34410,2019,1642, 34406,2015,1638, 1643,2020,1643, 34412,2021,1644, 34413,2022,1645, 34405,2014,1637, 1646,2023,1646, 34408,2017,1640, 1647,2024,1647, 34416,2025,1648, 34417,2026,1649, 34418,2027,1650, 34409,2018,1641, 1651,2028,1651, 
34410,2019,1642, 1652,2029,1652, 34411,2020,1643, 
14, // chain 21
1653,2030,1653, 1654,2031,1654, 1655,2032,1655, 
1656,2033,1656, 34425,2034,1657, 34426,2035,1658, 34427,2036,1659, 34422,2031,1654, 1660,2037,1660, 34429,2038,1661, 34421,2030,1653, 1662,2039,1662, 34424,2033,1656, 1663,2040,1663, 34432,2041,1664, 34425,2034,1657, 
13, // chain 22
1665,2042,1665, 1658,2035,1658, 1659,2036,1659, 
1666,2043,1666, 34428,2037,1660, 1667,2044,1667, 34429,2038,1661, 1668,2045,1668, 34437,2046,1669, 34438,2047,1670, 34430,2039,1662, 1663,2040,1663, 1671,2048,1671, 34440,2049,1672, 34432,2041,1664, 
10, // chain 23
1646,2023,1646, 1647,2024,1647, 1673,2050,1673, 
34442,2051,1674, 34416,2025,1648, 1675,2052,1675, 34417,2026,1649, 1676,2053,1676, 34418,2027,1650, 1651,2028,1651, 1677,2054,1677, 34420,2029,1652, 
9, // chain 24
1646,2023,1646, 1673,2050,1673, 1645,2022,1645, 
34446,2055,1678, 34447,2056,1679, 34442,2051,1674, 1680,2057,1680, 34443,2052,1675, 1681,2058,1681, 34444,2053,1676, 1677,2054,1677, 
1, // chain 25
1645,2022,1645, 1678,2055,1678, 1644,2021,1644, 
4, // chain 26
1669,2046,1669, 1670,2047,1670, 1671,2048,1671, 
1682,2059,1682, 34451,2060,1683, 34440,2049,1672, 
4, // chain 27
1668,2045,1668, 1669,2046,1669, 1682,2059,1682, 
1684,2061,1684, 34453,2062,1685, 34451,2060,1683, 
4, // chain 28
1667,2044,1667, 1668,2045,1668, 1684,2061,1684, 
1666,2043,1666, 34454,2063,1686, 34453,2062,1685, 
1, // chain 29
1665,2042,1665, 1666,2043,1666, 1686,2063,1686, 
31, // chain 30
1687,2064,1687, 1688,2065,1688, 1689,2066,1689, 
1690,2067,1690, 34459,2068,1691, 34460,2069,1692, 34456,2065,1688, 1693,2070,1693, 34462,2071,1694, 34463,2072,1695, 34464,2073,1696, 34465,2074,1697, 34455,2064,1687, 1698,2075,1698, 34458,2067,1690, 1699,2076,1699, 34468,2077,1700, 34459,2068,1691, 1701,2078,1701, 
34470,2079,1702, 34460,2069,1692, 1693,2070,1693, 1703,2080,1703, 34462,2071,1694, 1704,2081,1704, 34463,2072,1695, 1705,2082,1705, 34464,2073,1696, 1706,2083,1706, 34465,2074,1697, 1698,2075,1698, 1707,2084,1707, 34467,2076,1699, 
40, // chain 31
1708,2085,1708, 1709,2086,1709, 1710,2087,1710, 
1711,2088,1711, 34480,2089,1712, 34481,2090,1713, 34482,2091,1714, 34483,2092,1715, 34484,2093,1716, 34477,2086,1709, 1717,2094,1717, 34486,2095,1718, 34476,2085,1708, 1719,2096,1719, 34479,2088,1711, 1720,2097,1720, 34480,2089,1712, 1721,2098,1721, 34481,2090,1713, 
1722,2099,1722, 34482,2091,1714, 1723,2100,1723, 34483,2092,1715, 1724,2101,1724, 34484,2093,1716, 1717,2094,1717, 1725,2102,1725, 34494,2103,1726, 34486,2095,1718, 1727,2104,1727, 34487,2096,1719, 1728,2105,1728, 34488,2097,1720, 1729,2106,1729, 34489,2098,1721, 
1730,2107,1730, 34490,2099,1722, 1731,2108,1731, 34491,2100,1723, 1732,2109,1732, 34492,2101,1724, 1725,2102,1725, 
9, // chain 32
1707,2084,1707, 1733,2110,1733, 1706,2083,1706, 
34473,2082,1705, 34502,2111,1734, 1704,2081,1704, 34503,2112,1735, 1703,2080,1703, 34504,2113,1736, 1702,2079,1702, 34469,2078,1701, 
21, // chain 33
1737,2114,1737, 1738,2115,1738, 1739,2116,1739, 
1740,2117,1740, 34509,2118,1741, 34510,2119,1742, 34506,2115,1738, 1743,2120,1743, 34512,2121,1744, 34505,2114,1737, 1740,2117,1740, 1745,2122,1745, 34514,2123,1746, 34515,2124,1747, 34516,2125,1748, 34517,2126,1749, 34509,2118,1741, 1750,2127,1750, 34519,2128,1751, 
34520,2129,1752, 34521,2130,1753, 34511,2120,1743, 34510,2119,1742, 
5, // chain 34
1748,2125,1748, 1749,2126,1749, 1754,2131,1754, 
1747,2124,1747, 34519,2128,1751, 34518,2127,1750, 34517,2126,1749, 
21, // chain 35
1755,2132,1755, 1756,2133,1756, 1757,2134,1757, 
1758,2135,1758, 34527,2136,1759, 34528,2137,1760, 34524,2133,1756, 1751,2128,1751, 34515,2124,1747, 34523,2132,1755, 1758,2135,1758, 1761,2138,1761, 34530,2139,1762, 34531,2140,1763, 34532,2141,1764, 34533,2142,1765, 34527,2136,1759, 1766,2143,1766, 34535,2144,1767, 
34536,2145,1768, 34537,2146,1769, 34519,2128,1751, 34528,2137,1760, 
5, // chain 36
1764,2141,1764, 1765,2142,1765, 1770,2147,1770, 
1763,2140,1763, 34535,2144,1767, 34534,2143,1766, 34533,2142,1765, 
2, // chain 37
1771,2148,1771, 1753,2130,1753, 1744,2121,1744, 
1745,2122,1745, 
1, // chain 38
1744,2121,1744, 1753,2130,1753, 1743,2120,1743, 
3, // chain 39
1762,2139,1762, 1763,2140,1763, 1767,2144,1767, 
1772,2149,1772, 34536,2145,1768, 
1, // chain 40
1761,2138,1761, 1746,2123,1746, 1747,2124,1747, 
1, // chain 41
1751,2128,1751, 1752,2129,1752, 1769,2146,1769, 
12, // chain 42
1773,2150,1773, 1774,2151,1774, 1775,2152,1775, 
1776,2153,1776, 34545,2154,1777, 1778,2155,1778, 34547,2156,1779, 1780,2157,1780, 34549,2158,1781, 1782,2159,1782, 34551,2160,1783, 1774,2151,1774, 34552,2161,1784, 1775,2152,1775, 
9, // chain 43
1785,2162,1785, 1786,2163,1786, 1787,2164,1787, 
1776,2153,1776, 34550,2159,1782, 34556,2165,1788, 34554,2163,1786, 1780,2157,1780, 34546,2155,1778, 34553,2162,1785, 1776,2153,1776, 
1, // chain 44
1780,2157,1780, 1782,2159,1782, 1788,2165,1788, 
9, // chain 45
1789,2166,1789, 1790,2167,1790, 1791,2168,1791, 
1773,2150,1773, 34542,2151,1774, 34560,2169,1792, 34558,2167,1790, 1782,2159,1782, 34544,2153,1776, 34557,2166,1789, 1773,2150,1773, 
1, // chain 46
1782,2159,1782, 1774,2151,1774, 1792,2169,1792, 
27, // chain 47
1793,2170,1793, 1794,2171,1794, 1795,2172,1795, 
34564,2173,1796, 1797,2174,1797, 34566,2175,1798, 1799,2176,1799, 34568,2177,1800, 1801,2178,1801, 34570,2179,1802, 1803,2180,1803, 34561,2170,1793, 1804,2181,1804, 34563,2172,1795, 1805,2182,1805, 34574,2183,1806, 34565,2174,1797, 1807,2184,1807, 34571,2180,1803, 
34576,2185,1808, 34577,2186,1809, 34567,2176,1799, 1810,2187,1810, 34569,2178,1801, 1811,2188,1811, 34571,2180,1803, 1808,2185,1808, 1810,2187,1810, 34577,2186,1809, 
5, // chain 48
1805,2182,1805, 1806,2183,1806, 1807,2184,1807, 
1812,2189,1812, 34571,2180,1803, 1804,2181,1804, 1805,2182,1805, 

 0};


// face array: 3kb.
const uint16_t sinbad_3_face[1725] PROGMEM = {
82, // chain 0
1813,2190,1813, 1814,2191,1814, 1815,2192,1815, 
1816,2193,1816, 1817,2194,1817, 34586,2195,1818, 1819,2196,1819, 34588,2197,1820, 1821,2198,1821, 34590,2199,1822, 1823,2200,1823, 34592,2201,1824, 1825,2202,1825, 34594,2203,1826, 1827,2204,1827, 34596,2205,1828, 34597,2206,1829, 34598,2207,1830, 34592,2208,1824, 
1831,2209,1831, 34590,2210,1822, 1832,2211,1832, 34588,2212,1820, 1833,2213,1833, 34586,2214,1818, 1834,2215,1834, 34584,2216,1816, 1835,2217,1835, 34583,2192,1815, 1836,2218,1836, 34605,2219,1837, 34582,2191,1814, 1838,2220,1838, 34607,2221,1839, 34608,2222,1840, 
34581,2190,1813, 1841,2223,1841, 34585,2194,1817, 1842,2224,1842, 34587,2196,1819, 1843,2225,1843, 34589,2198,1821, 1844,2226,1844, 34591,2200,1823, 1845,2227,1845, 34593,2202,1825, 1846,2228,1846, 34595,2204,1827, 1847,2229,1847, 34616,2230,1848, 34596,2205,1828, 
1849,2231,1849, 1850,2232,1850, 34619,2233,1851, 1852,2234,1852, 34621,2235,1853, 1838,2220,1838, 34605,2219,1837, 34622,2236,1854, 34623,2237,1855, 34619,2238,1851, 1856,2239,1856, 34617,2240,1849, 1857,2241,1857, 34596,2205,1828, 1829,2206,1829, 1858,2242,1858, 
34627,2243,1859, 34598,2207,1830, 1860,2244,1860, 34599,2209,1831, 1861,2245,1861, 34600,2211,1832, 1862,2246,1862, 34601,2213,1833, 1863,2247,1863, 34602,2215,1834, 1864,2248,1864, 34603,2217,1835, 1865,2249,1865, 34604,2218,1836, 1866,2250,1866, 34622,2236,1854, 
34605,2219,1837, 
26, // chain 1
1867,2251,1867, 1868,2252,1868, 1841,2223,1841, 
1842,2224,1842, 1869,2253,1869, 34611,2225,1843, 1870,2254,1870, 34612,2226,1844, 1871,2255,1871, 34613,2227,1845, 1872,2256,1872, 34614,2228,1846, 1873,2257,1873, 34615,2229,1847, 1874,2258,1874, 34643,2259,1875, 34616,2230,1848, 1850,2232,1850, 1876,2260,1876, 
34620,2234,1852, 1877,2261,1877, 34606,2220,1838, 1839,2221,1839, 1878,2262,1878, 34647,2263,1879, 34608,2222,1840, 1868,2252,1868, 34609,2223,1841, 
26, // chain 2
1880,2264,1880, 1881,2265,1881, 1867,2251,1867, 
1869,2253,1869, 1882,2266,1882, 34638,2254,1870, 1883,2267,1883, 34639,2255,1871, 1884,2268,1884, 34640,2256,1872, 1885,2269,1885, 34641,2257,1873, 1886,2270,1886, 34642,2258,1874, 1887,2271,1887, 34656,2272,1888, 34643,2259,1875, 1876,2260,1876, 1889,2273,1889, 
34645,2261,1877, 1878,2262,1878, 1890,2274,1890, 34659,2275,1891, 34647,2263,1879, 1892,2276,1892, 34636,2252,1868, 1881,2265,1881, 34635,2251,1867, 
26, // chain 3
1893,2277,1893, 1894,2278,1894, 1880,2264,1880, 
1882,2266,1882, 1895,2279,1895, 34651,2267,1883, 1896,2280,1896, 34652,2268,1884, 1897,2281,1897, 34653,2269,1885, 1898,2282,1898, 34654,2270,1886, 1899,2283,1899, 34655,2271,1887, 1900,2284,1900, 34669,2285,1901, 34656,2272,1888, 1889,2273,1889, 1890,2274,1890, 
1902,2286,1902, 34671,2287,1903, 34659,2275,1891, 1904,2288,1904, 34660,2276,1892, 1905,2289,1905, 34649,2265,1881, 1894,2278,1894, 34648,2264,1880, 
9, // chain 4
1906,2290,1906, 1894,2278,1894, 1893,2277,1893, 
1895,2279,1895, 1896,2280,1896, 1897,2281,1897, 1898,2282,1898, 1899,2283,1899, 1900,2284,1900, 1902,2286,1902, 34669,2285,1901, 
4, // chain 5
1894,2278,1894, 1906,2290,1906, 1905,2289,1905, 
34672,2288,1904, 34671,2287,1903, 34670,2286,1902, 
50, // chain 6
1907,2291,1907, 1908,2292,1908, 1909,2293,1909, 
1910,2294,1910, 34679,2295,1911, 34680,2296,1912, 1913,2297,1913, 34682,2298,1914, 1915,2299,1915, 34684,2300,1916, 1917,2301,1917, 34686,2302,1918, 1919,2303,1919, 34688,2304,1920, 1921,2305,1921, 34690,2306,1922, 1923,2307,1923, 34692,2308,1924, 1925,2309,1925, 
34694,2310,1926, 1927,2311,1927, 34696,2312,1928, 1929,2313,1929, 34698,2314,1930, 1931,2315,1931, 34675,2291,1907, 34700,2316,1932, 34701,2317,1933, 34696,2318,1928, 1934,2319,1934, 34694,2320,1926, 1935,2321,1935, 34692,2322,1924, 1936,2323,1936, 34690,2324,1922, 
1937,2325,1937, 34688,2326,1920, 1938,2327,1938, 34686,2328,1918, 1939,2329,1939, 34684,2330,1916, 1940,2331,1940, 34682,2332,1914, 1941,2333,1941, 34680,2334,1912, 1942,2335,1942, 34677,2293,1909, 1908,2292,1908, 1943,2336,1943, 34712,2337,1944, 34700,2316,1932, 
34675,2291,1907, 
26, // chain 7
1942,2335,1942, 1943,2336,1943, 1945,2338,1945, 
34714,2339,1946, 34715,2340,1947, 34712,2337,1944, 1948,2341,1948, 34717,2342,1949, 34700,2316,1932, 1933,2317,1933, 1950,2343,1950, 34702,2319,1934, 1951,2344,1951, 34703,2321,1935, 1952,2345,1952, 34704,2323,1936, 1953,2346,1953, 34705,2325,1937, 1954,2347,1954, 
34706,2327,1938, 1955,2348,1955, 34707,2329,1939, 1956,2349,1956, 34708,2331,1940, 1957,2350,1957, 34709,2333,1941, 1945,2338,1945, 34710,2335,1942, 
26, // chain 8
1945,2338,1945, 1946,2339,1946, 1958,2351,1958, 
34727,2352,1959, 34728,2353,1960, 34715,2340,1947, 1961,2354,1961, 34716,2341,1948, 1962,2355,1962, 34731,2356,1963, 34717,2342,1949, 1950,2343,1950, 1964,2357,1964, 34719,2344,1951, 1965,2358,1965, 34720,2345,1952, 1966,2359,1966, 34721,2346,1953, 1967,2360,1967, 
34722,2347,1954, 1968,2361,1968, 34723,2348,1955, 1969,2362,1969, 34724,2349,1956, 1970,2363,1970, 34725,2350,1957, 1958,2351,1958, 34713,2338,1945, 
26, // chain 9
1958,2351,1958, 1959,2352,1959, 1971,2364,1971, 
34740,2365,1972, 34741,2366,1973, 34728,2353,1960, 1974,2367,1974, 34729,2354,1961, 1975,2368,1975, 34730,2355,1962, 1976,2369,1976, 34745,2370,1977, 34731,2356,1963, 1964,2357,1964, 1978,2371,1978, 34733,2358,1965, 1979,2372,1979, 34734,2359,1966, 1980,2373,1980, 
34735,2360,1967, 1981,2374,1981, 34736,2361,1968, 1982,2375,1982, 34737,2362,1969, 1983,2376,1983, 34738,2363,1970, 1971,2364,1971, 34726,2351,1958, 
21, // chain 10
1971,2364,1971, 1972,2365,1972, 1984,2377,1984, 
34753,2378,1985, 34741,2366,1973, 1974,2367,1974, 1975,2368,1975, 1976,2369,1976, 1986,2379,1986, 34745,2370,1977, 1978,2371,1978, 1987,2380,1987, 34747,2372,1979, 1988,2381,1988, 34748,2373,1980, 1989,2382,1989, 34749,2374,1981, 1990,2383,1990, 34750,2375,1982, 
1991,2384,1991, 34751,2376,1983, 1984,2377,1984, 34739,2364,1971, 
6, // chain 11
1986,2379,1986, 1987,2380,1987, 1985,2378,1985, 
34756,2381,1988, 1989,2382,1989, 1990,2383,1990, 1991,2384,1991, 1984,2377,1984, 
21, // chain 12
1992,2385,1992, 1993,2386,1993, 1913,2297,1913, 
1915,2299,1915, 1994,2387,1994, 34685,2301,1917, 1995,2388,1995, 34687,2303,1919, 1996,2389,1996, 34689,2305,1921, 1997,2390,1997, 34691,2307,1923, 1998,2391,1998, 34693,2309,1925, 1999,2392,1999, 34695,2311,1927, 2000,2393,2000, 34697,2313,1929, 2001,2394,2001, 
34699,2315,1931, 2002,2395,2002, 34678,2294,1910, 34675,2291,1907, 
27, // chain 13
1913,2297,1913, 1993,2386,1993, 1911,2295,1911, 
34771,2396,2003, 34772,2397,2004, 34773,2398,2005, 34760,2385,1992, 2006,2399,2006, 34762,2387,1994, 2007,2400,2007, 34763,2388,1995, 2008,2401,2008, 34764,2389,1996, 2009,2402,2009, 34765,2390,1997, 2010,2403,2010, 34766,2391,1998, 2011,2404,2011, 34767,2392,1999, 
2012,2405,2012, 34768,2393,2000, 2013,2406,2013, 34769,2394,2001, 2014,2407,2014, 34770,2395,2002, 2015,2408,2015, 34771,2396,2003, 34678,2294,1910, 1911,2295,1911, 
21, // chain 14
2016,2409,2016, 2017,2410,2017, 2006,2399,2006, 
2007,2400,2007, 2018,2411,2018, 34776,2401,2008, 2019,2412,2019, 34777,2402,2009, 2020,2413,2020, 34778,2403,2010, 2021,2414,2021, 34779,2404,2011, 2022,2415,2022, 34780,2405,2012, 2023,2416,2023, 34781,2406,2013, 2024,2417,2024, 34782,2407,2014, 2025,2418,2025, 
34783,2408,2015, 2026,2419,2026, 34772,2397,2004, 34771,2396,2003, 
27, // chain 15
2006,2399,2006, 2017,2410,2017, 2005,2398,2005, 
34795,2420,2027, 34796,2421,2028, 34797,2422,2029, 34784,2409,2016, 2030,2423,2030, 34786,2411,2018, 2031,2424,2031, 34787,2412,2019, 2032,2425,2032, 34788,2413,2020, 2033,2426,2033, 34789,2414,2021, 2034,2427,2034, 34790,2415,2022, 2035,2428,2035, 34791,2416,2023, 
2036,2429,2036, 34792,2417,2024, 2037,2430,2037, 34793,2418,2025, 2038,2431,2038, 34794,2419,2026, 2039,2432,2039, 34795,2420,2027, 34772,2397,2004, 2005,2398,2005, 
12, // chain 16
2029,2422,2029, 2030,2423,2030, 2040,2433,2040, 
2028,2421,2028, 34807,2432,2039, 34806,2431,2038, 34805,2430,2037, 34804,2429,2036, 34803,2428,2035, 34802,2427,2034, 34801,2426,2033, 34800,2425,2032, 34799,2424,2031, 34798,2423,2030, 
1, // chain 17
2027,2420,2027, 2028,2421,2028, 2039,2432,2039, 
86, // chain 18
1863,2247,1863, 1864,2248,1864, 2041,2434,2041, 
34810,2435,2042, 34633,2249,1865, 2043,2436,2043, 34634,2250,1866, 2044,2437,2044, 34813,2438,2045, 34622,2236,1854, 1855,2237,1855, 2046,2439,2046, 34624,2239,1856, 2047,2440,2047, 34625,2241,1857, 1858,2242,1858, 2048,2441,2048, 34817,2442,2049, 34627,2243,1859, 
2050,2443,2050, 34628,2244,1860, 2051,2444,2051, 34629,2245,1861, 2052,2445,2052, 34630,2246,1862, 2053,2446,2053, 34631,2247,1863, 2041,2434,2041, 2054,2447,2054, 34823,2448,2055, 34810,2435,2042, 2056,2449,2056, 34811,2436,2043, 2057,2450,2057, 34812,2437,2044, 
2058,2451,2058, 34827,2452,2059, 34813,2438,2045, 2046,2439,2046, 2060,2453,2060, 34815,2440,2047, 2048,2441,2048, 2061,2454,2061, 34830,2455,2062, 34817,2442,2049, 2063,2456,2063, 34818,2443,2050, 2064,2457,2064, 34819,2444,2051, 2065,2458,2065, 34820,2445,2052, 
2066,2459,2066, 34821,2446,2053, 2054,2447,2054, 2067,2460,2067, 34836,2461,2068, 34823,2448,2055, 2069,2462,2069, 34824,2449,2056, 2070,2463,2070, 34825,2450,2057, 2071,2464,2071, 34826,2451,2058, 2072,2465,2072, 34841,2466,2073, 34827,2452,2059, 2060,2453,2060, 
2061,2454,2061, 2074,2467,2074, 34843,2468,2075, 34830,2455,2062, 2076,2469,2076, 34831,2456,2063, 2077,2470,2077, 34832,2457,2064, 2078,2471,2078, 34833,2458,2065, 2079,2472,2079, 34834,2459,2066, 2067,2460,2067, 2080,2473,2080, 34836,2461,2068, 2069,2462,2069, 
2070,2463,2070, 2071,2464,2071, 2072,2465,2072, 2074,2467,2074, 34841,2466,2073, 
5, // chain 19
2078,2471,2078, 2079,2472,2079, 2080,2473,2080, 
2077,2470,2077, 34844,2469,2076, 34843,2468,2075, 34842,2467,2074, 

 0};


// face array: 5kb.
const uint16_t sinbad_4_face[2953] PROGMEM = {
66, // chain 0
2081,2474,2081, 2082,2475,2082, 2083,2476,2083, 
2084,2477,2084, 34853,2478,2085, 34854,2479,2086, 34855,2480,2087, 34850,2475,2082, 2088,2481,2088, 34857,2482,2089, 34858,2483,2090, 34849,2474,2081, 2091,2484,2091, 34860,2485,2092, 34852,2477,2084, 2093,2486,2093, 34862,2487,2094, 34853,2478,2085, 2095,2488,2095, 
34864,2489,2096, 34854,2479,2086, 2097,2490,2097, 34866,2491,2098, 34855,2480,2087, 2099,2492,2099, 34856,2481,2088, 2100,2493,2100, 34869,2494,2101, 34857,2482,2089, 2102,2495,2102, 34871,2496,2103, 34858,2483,2090, 2104,2497,2104, 34859,2484,2091, 2105,2498,2105, 
34874,2499,2106, 34860,2485,2092, 2107,2500,2107, 34861,2486,2093, 2108,2501,2108, 34877,2502,2109, 34862,2487,2094, 2110,2503,2110, 34863,2488,2095, 2111,2504,2111, 34880,2505,2112, 34864,2489,2096, 2113,2506,2113, 34865,2490,2097, 2105,2498,2105, 34882,2507,2114, 
34866,2491,2098, 2115,2508,2115, 34867,2492,2099, 2116,2509,2116, 34868,2493,2100, 2117,2510,2117, 34886,2511,2118, 34869,2494,2101, 2119,2512,2119, 34870,2495,2102, 2120,2513,2120, 34889,2514,2121, 34871,2496,2103, 2122,2515,2122, 34872,2497,2104, 2114,2507,2114, 
34873,2498,2105, 
17, // chain 1
2105,2498,2105, 2106,2499,2106, 2113,2506,2113, 
34891,2516,2123, 34875,2500,2107, 2124,2517,2124, 34876,2501,2108, 2125,2518,2125, 34894,2519,2126, 34877,2502,2109, 2127,2520,2127, 34878,2503,2110, 2128,2521,2128, 34879,2504,2111, 2129,2522,2129, 34898,2523,2130, 34880,2505,2112, 2123,2516,2123, 34881,2506,2113, 
15, // chain 2
2123,2516,2123, 2124,2517,2124, 2130,2523,2130, 
34899,2524,2131, 34893,2518,2125, 2132,2525,2132, 34901,2526,2133, 34894,2519,2126, 2134,2527,2134, 34895,2520,2127, 2135,2528,2135, 34896,2521,2128, 2136,2529,2136, 34897,2522,2129, 2137,2530,2137, 34899,2524,2131, 34898,2523,2130, 
42, // chain 3
2131,2524,2131, 2132,2525,2132, 2137,2530,2137, 
34906,2531,2138, 34907,2532,2139, 34901,2526,2133, 2140,2533,2140, 34902,2527,2134, 2141,2534,2141, 34903,2528,2135, 2142,2535,2142, 34904,2529,2136, 2143,2536,2143, 34905,2530,2137, 2138,2531,2138, 2144,2537,2144, 34913,2538,2145, 34907,2532,2139, 2146,2539,2146, 
34908,2533,2140, 2147,2540,2147, 34909,2534,2141, 2148,2541,2148, 34910,2535,2142, 2149,2542,2149, 34911,2536,2143, 2144,2537,2144, 2150,2543,2150, 34919,2544,2151, 34913,2538,2145, 2120,2513,2120, 34914,2539,2146, 2119,2512,2119, 34915,2540,2147, 2118,2511,2118, 
34916,2541,2148, 2117,2510,2117, 34917,2542,2149, 2150,2543,2150, 2116,2509,2116, 34920,2545,2152, 34919,2544,2151, 2121,2514,2121, 34888,2513,2120, 
3, // chain 4
2152,2545,2152, 2121,2514,2121, 2122,2515,2122, 
2115,2508,2115, 34882,2507,2114, 
1, // chain 5
2116,2509,2116, 2152,2545,2152, 2115,2508,2115, 
71, // chain 6
2153,2546,2153, 2154,2547,2154, 2155,2548,2155, 
2156,2549,2156, 34925,2550,2157, 34926,2551,2158, 34927,2552,2159, 34922,2547,2154, 2160,2553,2160, 34929,2554,2161, 34930,2555,2162, 34921,2546,2153, 2163,2556,2163, 34932,2557,2164, 34924,2549,2156, 2165,2558,2165, 34934,2559,2166, 34925,2550,2157, 2167,2560,2167, 
34936,2561,2168, 34926,2551,2158, 2169,2562,2169, 34938,2563,2170, 34927,2552,2159, 2171,2564,2171, 34928,2553,2160, 2172,2565,2172, 34941,2566,2173, 34929,2554,2161, 2174,2567,2174, 34943,2568,2175, 34930,2555,2162, 2176,2569,2176, 34931,2556,2163, 2177,2570,2177, 
34946,2571,2178, 34932,2557,2164, 2179,2572,2179, 34933,2558,2165, 2180,2573,2180, 34949,2574,2181, 34934,2559,2166, 2182,2575,2182, 34935,2560,2167, 2183,2576,2183, 34952,2577,2184, 34936,2561,2168, 2185,2578,2185, 34937,2562,2169, 2186,2579,2186, 34955,2580,2187, 
34938,2563,2170, 2188,2581,2188, 34939,2564,2171, 2180,2573,2180, 34940,2565,2172, 2179,2572,2179, 34957,2582,2189, 34941,2566,2173, 2190,2583,2190, 34942,2567,2174, 2191,2584,2191, 34960,2585,2192, 34943,2568,2175, 2193,2586,2193, 34944,2569,2176, 2194,2587,2194, 
34945,2570,2177, 2195,2588,2195, 34964,2589,2196, 34946,2571,2178, 2189,2582,2189, 34947,2572,2179, 
17, // chain 7
2180,2573,2180, 2181,2574,2181, 2188,2581,2188, 
34965,2590,2197, 34950,2575,2182, 2198,2591,2198, 34951,2576,2183, 2199,2592,2199, 34968,2593,2200, 34952,2577,2184, 2201,2594,2201, 34953,2578,2185, 2202,2595,2202, 34954,2579,2186, 2203,2596,2203, 34972,2597,2204, 34955,2580,2187, 2197,2590,2197, 34956,2581,2188, 
15, // chain 8
2197,2590,2197, 2198,2591,2198, 2204,2597,2204, 
34973,2598,2205, 34967,2592,2199, 2206,2599,2206, 34975,2600,2207, 34968,2593,2200, 2208,2601,2208, 34969,2594,2201, 2209,2602,2209, 34970,2595,2202, 2210,2603,2210, 34971,2596,2203, 2211,2604,2211, 34973,2598,2205, 34972,2597,2204, 
37, // chain 9
2205,2598,2205, 2206,2599,2206, 2211,2604,2211, 
34980,2605,2212, 34981,2606,2213, 34975,2600,2207, 2214,2607,2214, 34976,2601,2208, 2215,2608,2215, 34977,2602,2209, 2216,2609,2216, 34978,2603,2210, 2217,2610,2217, 34979,2604,2211, 2212,2605,2212, 2218,2611,2218, 34987,2612,2219, 34981,2606,2213, 2220,2613,2220, 
34982,2607,2214, 2221,2614,2221, 34983,2608,2215, 2222,2615,2222, 34984,2609,2216, 2223,2616,2223, 34985,2610,2217, 2218,2611,2218, 2191,2584,2191, 34992,2617,2224, 34987,2612,2219, 2195,2588,2195, 34988,2613,2220, 2194,2587,2194, 34989,2614,2221, 2193,2586,2193, 
34990,2615,2222, 2192,2585,2192, 34991,2616,2223, 2191,2584,2191, 
2, // chain 10
2196,2589,2196, 2190,2583,2190, 2224,2617,2224, 
2195,2588,2195, 
1, // chain 11
2224,2617,2224, 2190,2583,2190, 2191,2584,2191, 
1, // chain 12
2196,2589,2196, 2189,2582,2189, 2190,2583,2190, 
26, // chain 13
2225,2618,2225, 2226,2619,2226, 2227,2620,2227, 
2228,2621,2228, 34997,2622,2229, 34998,2623,2230, 34999,2624,2231, 34994,2619,2226, 2232,2625,2232, 35001,2626,2233, 35002,2627,2234, 34993,2618,2225, 2235,2628,2235, 35004,2629,2236, 34996,2621,2228, 2237,2630,2237, 35006,2631,2238, 34997,2622,2229, 2239,2632,2239, 
35008,2633,2240, 34998,2623,2230, 2241,2634,2241, 35010,2635,2242, 34999,2624,2231, 2243,2636,2243, 35000,2625,2232, 2244,2637,2244, 35001,2626,2233, 
13, // chain 14
2245,2638,2245, 2246,2639,2246, 2247,2640,2247, 
2248,2641,2248, 35017,2642,2249, 35018,2643,2250, 35019,2644,2251, 35014,2639,2246, 2252,2645,2252, 35021,2646,2253, 35022,2647,2254, 35013,2638,2245, 2255,2648,2255, 35024,2649,2256, 35016,2641,2248, 
11, // chain 15
2257,2650,2257, 2258,2651,2258, 2259,2652,2259, 
2260,2653,2260, 35029,2654,2261, 35030,2655,2262, 35031,2656,2263, 35026,2651,2258, 2264,2657,2264, 2265,2658,2265, 35034,2659,2266, 2237,2630,2237, 35004,2629,2236, 
6, // chain 16
2267,2660,2267, 2268,2661,2268, 2269,2662,2269, 
35038,2663,2270, 35039,2664,2271, 2272,2665,2272, 35018,2643,2250, 35017,2642,2249, 
9, // chain 17
2267,2660,2267, 2269,2662,2269, 2273,2666,2273, 
35042,2667,2274, 35043,2668,2275, 35038,2663,2270, 2276,2669,2276, 35040,2665,2272, 2277,2670,2277, 35019,2644,2251, 35018,2643,2250, 
3, // chain 18
2278,2671,2278, 2279,2672,2279, 2280,2673,2280, 
35041,2666,2273, 35035,2660,2267, 
15, // chain 19
2278,2671,2278, 2280,2673,2280, 2281,2674,2281, 
35050,2675,2282, 35051,2676,2283, 35041,2666,2273, 2274,2667,2274, 2284,2677,2284, 35053,2678,2285, 35043,2668,2275, 2286,2679,2286, 35044,2669,2276, 2287,2680,2287, 35045,2670,2277, 2288,2681,2288, 35020,2645,2252, 35019,2644,2251, 
16, // chain 20
2244,2637,2244, 2257,2650,2257, 2260,2653,2260, 
2243,2636,2243, 35057,2682,2289, 35029,2654,2261, 2290,2683,2290, 35059,2684,2291, 35030,2655,2262, 2292,2685,2292, 35061,2686,2293, 35031,2656,2263, 2265,2658,2265, 2294,2687,2294, 35005,2630,2237, 2238,2631,2238, 2295,2688,2295, 35007,2632,2239, 
16, // chain 21
2296,2689,2296, 2297,2690,2297, 2298,2691,2298, 
2299,2692,2299, 35068,2693,2300, 35069,2694,2301, 35070,2695,2302, 35065,2690,2297, 2303,2696,2303, 35072,2697,2304, 35073,2698,2305, 35064,2689,2296, 2306,2699,2306, 35075,2700,2307, 35067,2692,2299, 2308,2701,2308, 35077,2702,2309, 35068,2693,2300, 
13, // chain 22
2310,2703,2310, 2311,2704,2311, 2312,2705,2312, 
2313,2706,2313, 35082,2707,2314, 35083,2708,2315, 35084,2709,2316, 35079,2704,2311, 2317,2710,2317, 35086,2711,2318, 35087,2712,2319, 35078,2703,2310, 2320,2713,2320, 35089,2714,2321, 35081,2706,2313, 
4, // chain 23
2302,2695,2302, 2303,2696,2303, 2322,2715,2322, 
35091,2716,2323, 35092,2717,2324, 35072,2697,2304, 
3, // chain 24
2315,2708,2315, 2316,2709,2316, 2325,2718,2325, 
35094,2719,2326, 35085,2710,2317, 
16, // chain 25
2327,2720,2327, 2328,2721,2328, 2329,2722,2329, 
2330,2723,2330, 35099,2724,2331, 35100,2725,2332, 35076,2701,2308, 35096,2721,2328, 2307,2700,2307, 35101,2726,2333, 35102,2727,2334, 35095,2720,2327, 2335,2728,2335, 35104,2729,2336, 35098,2723,2330, 2337,2730,2337, 35106,2731,2338, 35099,2724,2331, 
13, // chain 26
2339,2732,2339, 2340,2733,2340, 2341,2734,2341, 
2342,2735,2342, 35111,2736,2343, 35088,2713,2320, 35112,2737,2344, 35108,2733,2340, 2345,2738,2345, 35114,2739,2346, 35115,2740,2347, 35107,2732,2339, 2348,2741,2348, 35117,2742,2349, 35110,2735,2342, 
4, // chain 27
2350,2743,2350, 2336,2729,2336, 2337,2730,2337, 
2351,2744,2351, 35120,2745,2352, 35106,2731,2338, 
3, // chain 28
2353,2746,2353, 2354,2747,2354, 2348,2741,2348, 
2355,2748,2355, 35117,2742,2349, 
8, // chain 29
2348,2741,2348, 2354,2747,2354, 2347,2740,2347, 
35124,2749,2356, 35125,2750,2357, 35126,2751,2358, 35121,2746,2353, 2359,2752,2359, 35128,2753,2360, 35123,2748,2355, 
6, // chain 30
2361,2754,2361, 2362,2755,2362, 2350,2743,2350, 
2323,2716,2323, 35119,2744,2351, 2322,2715,2322, 35131,2756,2363, 35120,2745,2352, 
2, // chain 31
2350,2743,2350, 2362,2755,2362, 2336,2729,2336, 
35103,2728,2335, 
3, // chain 32
2315,2708,2315, 2325,2718,2325, 2359,2752,2359, 
2364,2757,2364, 35128,2753,2360, 
3, // chain 33
2359,2752,2359, 2325,2718,2325, 2358,2751,2358, 
35133,2758,2365, 35094,2719,2326, 
1, // chain 34
2364,2757,2364, 2314,2707,2314, 2315,2708,2315, 
1, // chain 35
2323,2716,2323, 2324,2717,2324, 2361,2754,2361, 
1, // chain 36
2307,2700,2307, 2333,2726,2333, 2306,2699,2306, 
1, // chain 37
2321,2714,2321, 2343,2736,2343, 2320,2713,2320, 
3, // chain 38
2320,2713,2320, 2344,2737,2344, 2319,2712,2319, 
35134,2759,2366, 35113,2738,2345, 
1, // chain 39
2319,2712,2319, 2366,2759,2366, 2318,2711,2318, 
1, // chain 40
2358,2751,2358, 2365,2758,2365, 2357,2750,2357, 
1, // chain 41
2347,2740,2347, 2356,2749,2356, 2346,2739,2346, 
1, // chain 42
2332,2725,2332, 2308,2701,2308, 2309,2702,2309, 
2, // chain 43
2302,2695,2302, 2322,2715,2322, 2367,2760,2367, 
2301,2694,2301, 
1, // chain 44
2367,2760,2367, 2322,2715,2322, 2363,2756,2363, 
3, // chain 45
2242,2635,2242, 2243,2636,2243, 2289,2682,2289, 
2368,2761,2368, 35058,2683,2290, 
3, // chain 46
2281,2674,2281, 2369,2762,2369, 2254,2647,2254, 
2255,2648,2255, 2278,2671,2278, 
5, // chain 47
2254,2647,2254, 2369,2762,2369, 2253,2646,2253, 
35138,2763,2370, 35139,2764,2371, 35050,2675,2282, 35049,2674,2281, 
3, // chain 48
2253,2646,2253, 2370,2763,2370, 2372,2765,2372, 
2252,2645,2252, 35056,2681,2288, 
2, // chain 49
2293,2686,2293, 2294,2687,2294, 2373,2766,2373, 
2292,2685,2292, 
1, // chain 50
2373,2766,2373, 2294,2687,2294, 2295,2688,2295, 
2, // chain 51
2282,2675,2282, 2283,2676,2283, 2374,2767,2374, 
35052,2677,2284, 
1, // chain 52
2282,2675,2282, 2374,2767,2374, 2371,2764,2371, 
1, // chain 53
2241,2634,2241, 2242,2635,2242, 2368,2761,2368, 
12, // chain 54
2375,2768,2375, 2376,2769,2376, 2377,2770,2375, 
2378,2771,2377, 2379,2772,2377, 35148,2773,2378, 2381,2774,2378, 35150,2775,2379, 2383,2776,2379, 35152,2777,2380, 2385,2778,2380, 35154,2779,2376, 2376,2769,2376, 35145,2770,2375, 
6, // chain 55
2387,2780,2381, 2388,2781,2381, 2389,2782,2381, 
35158,2783,2381, 2391,2784,2381, 2392,2785,2381, 2393,2786,2381, 2387,2780,2381, 
12, // chain 56
2394,2787,2382, 2395,2788,2383, 2396,2789,2382, 
2397,2790,2384, 2398,2791,2384, 35167,2792,2385, 2400,2793,2385, 35169,2794,2386, 2402,2795,2386, 35171,2796,2387, 2404,2797,2387, 35173,2798,2383, 2395,2788,2383, 35164,2789,2382, 
6, // chain 57
2406,2799,2388, 2407,2800,2388, 2408,2801,2388, 
35177,2802,2388, 2410,2803,2388, 2411,2804,2388, 2412,2805,2388, 2406,2799,2388, 
7, // chain 58
2413,2806,2389, 2414,2807,2390, 2415,2808,2391, 
2416,2809,2392, 2417,2810,2393, 35186,2811,2394, 2419,2812,2395, 35188,2813,2396, 2421,2814,2396, 
31, // chain 59
2415,2808,2391, 2414,2807,2390, 2422,2815,2397, 
35191,2816,2398, 2424,2817,2399, 35193,2818,2400, 2426,2819,2400, 35195,2820,2401, 2428,2821,2401, 35197,2822,2402, 2430,2823,2402, 35199,2824,2403, 2432,2825,2403, 35201,2826,2404, 2434,2827,2405, 35203,2828,2406, 2436,2829,2407, 35205,2830,2408, 2438,2831,2409, 
35207,2832,2410, 2440,2833,2411, 35209,2834,2412, 2442,2835,2413, 35211,2836,2414, 2444,2837,2415, 35213,2838,2416, 2446,2839,2417, 35215,2840,2418, 2448,2841,2419, 35217,2842,2420, 2450,2843,2421, 35219,2844,2422, 2452,2845,2422, 
3, // chain 60
2453,2846,2423, 2454,2847,2424, 2455,2848,2425, 
2456,2849,2426, 2457,2850,2426, 
35, // chain 61
2455,2848,2425, 2454,2847,2424, 2458,2851,2427, 
35227,2852,2428, 2460,2853,2429, 35229,2854,2430, 2462,2855,2431, 35231,2856,2432, 2464,2857,2432, 35233,2858,2433, 2466,2859,2433, 35235,2860,2434, 2468,2861,2434, 35237,2862,2435, 2470,2863,2435, 35239,2864,2436, 2472,2865,2437, 35241,2866,2438, 2474,2867,2439, 
35243,2868,2440, 2476,2869,2441, 35245,2870,2442, 2478,2871,2443, 35247,2872,2444, 2480,2873,2445, 35249,2874,2446, 2482,2875,2447, 35251,2876,2448, 2484,2877,2449, 35253,2878,2450, 2486,2879,2451, 35255,2880,2452, 2488,2881,2452, 35257,2882,2453, 2490,2883,2453, 
35259,2884,2454, 2492,2885,2454, 
2, // chain 62
2493,2886,2454, 2494,2887,2454, 2495,2888,2454, 
2496,2889,2454, 
2, // chain 63
2471,2864,2436, 2472,2865,2437, 2433,2826,2404, 
2434,2827,2405, 
2, // chain 64
2497,2890,2455, 2498,2891,2455, 2499,2892,2455, 
2500,2893,2455, 
36, // chain 65
2501,2894,2456, 2502,2895,2457, 2503,2896,2458, 
35272,2897,2459, 2505,2898,2460, 35274,2899,2461, 2507,2900,2462, 2508,2901,2463, 35277,2902,2464, 2510,2903,2465, 35279,2904,2466, 2512,2905,2467, 35281,2906,2468, 2514,2907,2469, 35283,2908,2470, 2516,2909,2471, 35285,2910,2472, 2518,2911,2473, 35287,2912,2474, 
2520,2913,2474, 35289,2914,2474, 2522,2915,2474, 35291,2916,2474, 2524,2917,2474, 35293,2918,2475, 2526,2919,2476, 35295,2920,2477, 35296,2921,2478, 2529,2922,2479, 35298,2923,2480, 35299,2924,2481, 2532,2925,2482, 2533,2926,2483, 35302,2927,2484, 2535,2928,2485, 
2536,2929,2486, 2537,2930,2487, 2538,2931,2487, 
8, // chain 66
2501,2894,2456, 2503,2896,2458, 2539,2932,2488, 
2540,2933,2489, 2541,2934,2490, 35310,2935,2474, 2543,2936,2474, 2544,2937,2474, 2545,2938,2474, 2546,2939,2474, 
3, // chain 67
2547,2940,2491, 2548,2941,2491, 2549,2942,2491, 
2550,2943,2491, 2551,2944,2491, 
1, // chain 68
2549,2942,2491, 2548,2941,2491, 2552,2945,2491, 
3, // chain 69
2553,2946,2492, 2554,2947,2493, 2555,2948,2494, 
2556,2949,2495, 2557,2950,2495, 
1, // chain 70
2555,2948,2494, 2554,2947,2493, 2558,2951,2493, 
2, // chain 71
2559,2952,2496, 2560,2953,2496, 2561,2954,2496, 
2562,2955,2496, 
2, // chain 72
2563,2956,2497, 2564,2957,2497, 2565,2958,2497, 
2566,2959,2497, 
32, // chain 73
2567,2960,2498, 2568,2961,2499, 2569,2962,2500, 
2570,2963,2501, 2571,2964,2502, 35340,2965,2503, 2573,2966,2503, 35342,2967,2504, 2575,2968,2505, 35344,2969,2506, 2577,2970,2507, 35346,2971,2508, 2579,2972,2509, 35348,2973,2510, 2581,2974,2511, 35350,2975,2512, 2583,2976,2513, 35352,2977,2514, 2585,2978,2515, 
35354,2979,2516, 2587,2980,2517, 35356,2981,2518, 2589,2982,2518, 35358,2983,2519, 2591,2984,2520, 35360,2985,2521, 2593,2986,2522, 35362,2987,2523, 2595,2988,2524, 35364,2989,2525, 2597,2990,2526, 35366,2991,2527, 2568,2961,2499, 35337,2962,2500, 
32, // chain 74
2599,2992,2528, 2600,2993,2528, 2601,2994,2528, 
2602,2995,2528, 2603,2996,2528, 35372,2997,2529, 2605,2998,2529, 35374,2999,2528, 2607,3000,2528, 35376,3001,2528, 2609,3002,2528, 35378,3003,2528, 2611,3004,2528, 35380,3005,2528, 2613,3006,2528, 35382,3007,2529, 2615,3008,2529, 35384,3009,2529, 2617,3010,2529, 
35386,3011,2529, 2619,3012,2529, 35388,3013,2528, 2621,3014,2528, 35390,3015,2529, 2623,3016,2529, 35392,3017,2529, 2625,3018,2529, 35394,3019,2529, 2627,3020,2529, 35396,3021,2528, 2629,3022,2528, 35398,3023,2528, 2600,2993,2528, 35369,2994,2528, 
23, // chain 75
2631,3024,2529, 2632,3025,2530, 2633,3026,2531, 
2634,3027,2532, 35403,3028,2533, 35404,3029,2534, 35400,3025,2530, 2637,3030,2535, 35406,3031,2536, 35399,3024,2529, 2639,3032,2537, 35408,3033,2538, 35409,3034,2539, 35410,3035,2540, 35411,3036,2541, 35412,3037,2542, 35413,3038,2543, 35414,3039,2544, 35415,3040,2545, 
35416,3041,2546, 35417,3042,2547, 35418,3043,2548, 35402,3027,2532, 2651,3044,2549, 35403,3028,2533, 
24, // chain 76
2649,3042,2547, 2650,3043,2548, 2652,3045,2550, 
2653,3046,2551, 2648,3041,2546, 35422,3047,2552, 2647,3040,2545, 35423,3048,2553, 2646,3039,2544, 35424,3049,2554, 2645,3038,2543, 35425,3050,2555, 2644,3037,2542, 35426,3051,2556, 2643,3036,2541, 35427,3052,2557, 2642,3035,2540, 35428,3053,2558, 2641,3034,2539, 
35429,3054,2559, 2640,3033,2538, 35430,3055,2560, 2639,3032,2537, 35431,3056,2561, 2638,3031,2536, 35405,3030,2535, 
1, // chain 77
2652,3045,2550, 2650,3043,2548, 2651,3044,2549, 

 0};


// face array: 12kb.
const uint16_t sinbad_5_face[6409] PROGMEM = {
12, // chain 0
2664,3057,2562, 2665,3058,2563, 2666,3059,2564, 
2667,3060,2565, 35436,3061,2566, 35437,3062,2567, 35438,3063,2568, 35433,3058,2563, 2671,3064,2569, 2672,3065,2570, 35441,3066,2571, 2674,3067,2572, 2675,3068,2573, 35444,3069,2574, 
13, // chain 1
2677,3070,2575, 2678,3071,2576, 2679,3072,2577, 
35448,3073,2578, 35449,3074,2579, 2682,3075,2580, 35451,3076,2581, 2684,3077,2582, 35453,3078,2583, 2686,3079,2584, 35455,3080,2585, 2688,3081,2586, 35457,3082,2587, 2690,3083,2588, 35459,3084,2589, 
14, // chain 2
2677,3070,2575, 2679,3072,2577, 2692,3085,2590, 
35461,3086,2591, 35462,3087,2592, 35448,3073,2578, 2695,3088,2593, 35450,3075,2580, 2696,3089,2594, 35452,3077,2582, 2697,3090,2595, 35454,3079,2584, 2698,3091,2596, 35456,3081,2586, 2699,3092,2597, 35458,3083,2588, 
4, // chain 3
2700,3093,2598, 2677,3070,2575, 2692,3085,2590, 
2701,3094,2599, 35470,3095,2600, 35461,3086,2591, 
11, // chain 4
2703,3096,2601, 2704,3097,2602, 2705,3098,2603, 
2706,3099,2604, 35475,3100,2605, 35476,3101,2606, 35477,3102,2607, 35472,3097,2602, 2710,3103,2608, 2711,3104,2609, 35480,3105,2610, 2667,3060,2565, 35432,3057,2562, 
4, // chain 5
2713,3106,2611, 2703,3096,2601, 2706,3099,2604, 
2674,3107,2572, 35444,3108,2574, 35475,3100,2605, 
1, // chain 6
2674,3107,2572, 2673,3109,2571, 2713,3106,2611, 
4, // chain 7
2691,3110,2589, 2700,3093,2598, 2701,3094,2599, 
2690,3111,2588, 35482,3112,2612, 35470,3095,2600, 
3, // chain 8
2669,3062,2567, 2670,3063,2568, 2715,3113,2613, 
35440,3065,2570, 2675,3068,2573, 
5, // chain 9
2708,3101,2606, 2709,3102,2607, 2716,3114,2614, 
35479,3104,2609, 2717,3115,2615, 35435,3060,2565, 2668,3061,2566, 
1, // chain 10
2690,3111,2588, 2714,3112,2612, 2699,3116,2597, 
12, // chain 11
2718,3117,2616, 2719,3118,2617, 2720,3119,2618, 
35489,3120,2619, 35490,3121,2620, 2723,3122,2621, 35492,3123,2622, 2725,3124,2623, 35494,3125,2624, 2727,3126,2625, 35496,3127,2626, 2729,3128,2627, 35486,3117,2616, 2720,3119,2618, 
12, // chain 12
2719,3129,2617, 2718,3130,2616, 2730,3131,2628, 
2731,3132,2629, 2722,3133,2620, 35500,3134,2630, 2724,3135,2622, 35501,3136,2631, 2726,3137,2624, 35502,3138,2632, 2728,3139,2626, 35503,3140,2633, 2718,3130,2616, 35498,3131,2628, 
12, // chain 13
2736,3141,2634, 2737,3142,2635, 2727,3143,2625, 
35493,3144,2623, 35506,3145,2636, 2723,3146,2621, 35507,3147,2637, 2721,3148,2619, 35508,3149,2638, 2720,3150,2618, 35509,3151,2639, 2729,3152,2627, 35504,3141,2634, 2727,3143,2625, 
12, // chain 14
2742,3153,2640, 2743,3154,2641, 2734,3155,2632, 
2733,3156,2631, 2744,3157,2642, 35500,3158,2630, 2745,3159,2643, 35499,3160,2629, 2746,3161,2644, 35498,3162,2628, 2747,3163,2645, 35503,3164,2633, 2743,3154,2641, 35502,3155,2632, 
12, // chain 15
2748,3165,2646, 2749,3166,2647, 2736,3167,2634, 
35505,3168,2635, 35518,3169,2648, 2738,3170,2636, 35519,3171,2649, 2739,3172,2637, 35520,3173,2650, 2740,3174,2638, 35521,3175,2651, 2741,3176,2639, 35516,3165,2646, 2736,3167,2634, 
12, // chain 16
2754,3177,2652, 2755,3178,2653, 2743,3179,2641, 
2742,3180,2640, 2756,3181,2654, 35512,3182,2642, 2757,3183,2655, 35513,3184,2643, 2758,3185,2656, 35514,3186,2644, 2759,3187,2657, 35515,3188,2645, 2755,3178,2653, 35511,3179,2641, 
12, // chain 17
2760,3189,2658, 2761,3190,2659, 2750,3191,2648, 
35519,3192,2649, 35530,3193,2660, 2752,3194,2650, 35531,3195,2661, 2753,3196,2651, 35532,3197,2662, 2748,3198,2646, 35533,3199,2663, 2749,3200,2647, 35528,3189,2658, 2750,3191,2648, 
12, // chain 18
2766,3201,2664, 2767,3202,2665, 2756,3203,2654, 
2757,3204,2655, 2768,3205,2666, 35526,3206,2656, 2769,3207,2667, 35527,3208,2657, 2770,3209,2668, 35523,3210,2653, 2771,3211,2669, 35522,3212,2652, 2767,3202,2665, 35524,3203,2654, 
12, // chain 19
2772,3213,2670, 2773,3214,2671, 2760,3215,2658, 
35529,3216,2659, 35542,3217,2672, 2762,3218,2660, 35543,3219,2673, 2763,3220,2661, 35544,3221,2674, 2764,3222,2662, 35545,3223,2675, 2765,3224,2663, 35540,3213,2670, 2760,3215,2658, 
12, // chain 20
2778,3225,2676, 2779,3226,2677, 2767,3227,2665, 
2766,3228,2664, 2780,3229,2678, 35536,3230,2666, 2781,3231,2679, 35537,3232,2667, 2782,3233,2680, 35538,3234,2668, 2783,3235,2681, 35539,3236,2669, 2779,3226,2677, 35535,3227,2665, 
12, // chain 21
2784,3237,2682, 2785,3238,2683, 2774,3239,2672, 
35543,3240,2673, 35554,3241,2684, 2776,3242,2674, 35555,3243,2685, 2777,3244,2675, 35556,3245,2686, 2772,3246,2670, 35557,3247,2687, 2773,3248,2671, 35552,3237,2682, 2774,3239,2672, 
12, // chain 22
2790,3249,2688, 2791,3250,2689, 2780,3251,2678, 
2781,3252,2679, 2792,3253,2690, 35550,3254,2680, 2793,3255,2691, 35551,3256,2681, 2794,3257,2692, 35547,3258,2677, 2795,3259,2693, 35546,3260,2676, 2791,3250,2689, 35548,3251,2678, 
12, // chain 23
2796,3261,2694, 2797,3262,2695, 2784,3263,2682, 
35553,3264,2683, 35566,3265,2696, 2786,3266,2684, 35567,3267,2697, 2787,3268,2685, 35568,3269,2698, 2788,3270,2686, 35569,3271,2699, 2789,3272,2687, 35564,3261,2694, 2784,3263,2682, 
12, // chain 24
2802,3273,2700, 2803,3274,2701, 2791,3275,2689, 
2790,3276,2688, 2804,3277,2702, 35560,3278,2690, 2805,3279,2703, 35561,3280,2691, 2806,3281,2704, 35562,3282,2692, 2807,3283,2705, 35563,3284,2693, 2803,3274,2701, 35559,3275,2689, 
12, // chain 25
2808,3285,2706, 2809,3286,2707, 2798,3287,2696, 
35567,3288,2697, 35578,3289,2708, 2800,3290,2698, 35579,3291,2709, 2801,3292,2699, 35580,3293,2710, 2796,3294,2694, 35581,3295,2711, 2797,3296,2695, 35576,3285,2706, 2798,3287,2696, 
12, // chain 26
2814,3297,2712, 2815,3298,2713, 2804,3299,2702, 
2805,3300,2703, 2816,3301,2714, 35574,3302,2704, 2817,3303,2715, 35575,3304,2705, 2818,3305,2716, 35571,3306,2701, 2819,3307,2717, 35570,3308,2700, 2815,3298,2713, 35572,3299,2702, 
12, // chain 27
2820,3309,2718, 2821,3310,2719, 2808,3311,2706, 
35577,3312,2707, 35590,3313,2720, 2810,3314,2708, 35591,3315,2721, 2811,3316,2709, 35592,3317,2722, 2812,3318,2710, 35593,3319,2723, 2813,3320,2711, 35588,3309,2718, 2808,3311,2706, 
12, // chain 28
2826,3321,2724, 2827,3322,2725, 2815,3323,2713, 
2814,3324,2712, 2828,3325,2726, 35584,3326,2714, 2829,3327,2727, 35585,3328,2715, 2830,3329,2728, 35586,3330,2716, 2831,3331,2729, 35587,3332,2717, 2827,3322,2725, 35583,3323,2713, 
10, // chain 29
2832,3333,2730, 2833,3334,2731, 2834,3335,2732, 
2835,3336,2733, 35604,3337,2734, 35601,3334,2731, 2837,3338,2735, 35606,3339,2736, 35607,3340,2737, 35600,3333,2730, 2840,3341,2738, 35603,3336,2733, 
16, // chain 30
2841,3342,2739, 2842,3343,2740, 2843,3344,2741, 
2844,3345,2742, 35613,3346,2743, 35614,3347,2744, 35615,3348,2745, 35610,3343,2740, 2848,3349,2746, 35609,3342,2739, 2849,3350,2747, 35612,3345,2742, 2850,3351,2748, 35613,3346,2743, 2846,3347,2744, 2851,3352,2749, 35615,3348,2745, 2848,3349,2746, 
5, // chain 31
2836,3337,2734, 2837,3338,2735, 2852,3353,2750, 
35621,3354,2751, 35606,3339,2736, 2839,3340,2737, 2840,3341,2738, 
1, // chain 32
2836,3337,2734, 2852,3353,2750, 2835,3336,2733, 
9, // chain 33
2854,3355,2752, 2855,3356,2753, 2856,3357,2754, 
2857,3358,2755, 35626,3359,2756, 35627,3360,2757, 2860,3361,2758, 2861,3362,2759, 35630,3363,2760, 35631,3364,2761, 35632,3365,2762, 
1, // chain 34
2856,3357,2754, 2855,3356,2753, 2865,3366,2763, 
13, // chain 35
2866,3367,2764, 2867,3368,2765, 2854,3355,2752, 
2868,3369,2766, 35637,3370,2767, 35625,3358,2755, 2870,3371,2768, 35626,3359,2756, 2861,3362,2759, 2871,3372,2769, 35630,3363,2760, 2872,3373,2770, 35641,3374,2771, 35642,3375,2772, 35631,3364,2761, 
1, // chain 36
2854,3355,2752, 2867,3368,2765, 2855,3356,2753, 
33, // chain 37
2875,3376,2773, 2876,3377,2774, 2866,3378,2764, 
2877,3379,2775, 35646,3380,2776, 35647,3381,2777, 2880,3382,2778, 35649,3383,2779, 2882,3384,2780, 2883,3385,2781, 2884,3386,2782, 35653,3387,2783, 35654,3388,2784, 2887,3389,2785, 35656,3390,2786, 35657,3391,2787, 2890,3392,2788, 35659,3393,2788, 2892,3394,2789, 
2893,3395,2790, 35662,3396,2791, 2895,3397,2792, 35664,3398,2793, 35665,3399,2794, 2898,3400,2795, 35667,3401,2796, 35668,3402,2797, 2901,3403,2798, 2902,3404,2799, 2903,3405,2800, 35641,3406,2771, 2904,3407,2801, 35673,3408,2802, 35674,3409,2803, 35642,3410,2772, 
1, // chain 38
2866,3378,2764, 2876,3377,2774, 2867,3411,2765, 
33, // chain 39
2856,3412,2754, 2865,3413,2763, 2875,3376,2773, 
2907,3414,2804, 35676,3415,2805, 35677,3416,2806, 35645,3379,2775, 2910,3417,2807, 35646,3380,2776, 2911,3418,2808, 35648,3382,2778, 2884,3386,2782, 2912,3419,2809, 35653,3387,2783, 2887,3389,2785, 2913,3420,2810, 35682,3421,2811, 2915,3422,2812, 35684,3423,2813, 
35663,3397,2792, 2917,3424,2814, 35664,3398,2793, 2898,3400,2795, 2918,3425,2815, 35667,3401,2796, 2903,3405,2800, 2919,3426,2816, 35672,3407,2801, 2920,3427,2817, 35673,3408,2802, 2921,3428,2818, 35690,3429,2819, 35628,3430,2758, 35632,3431,2762, 35674,3409,2803, 
1, // chain 40
2875,3376,2773, 2865,3413,2763, 2876,3377,2774, 
16, // chain 41
2909,3416,2806, 2910,3417,2807, 2923,3432,2820, 
2924,3433,2821, 2908,3415,2805, 35693,3434,2822, 2926,3435,2823, 35695,3436,2824, 35681,3420,2810, 2915,3422,2812, 2916,3423,2813, 2928,3437,2825, 2926,3435,2823, 35689,3428,2818, 35697,3438,2826, 2920,3427,2817, 35698,3439,2827, 2919,3426,2816, 
3, // chain 42
2931,3440,2828, 2907,3414,2804, 2926,3435,2823, 
2922,3429,2819, 35689,3428,2818, 
1, // chain 43
2926,3435,2823, 2907,3414,2804, 2908,3415,2805, 
7, // chain 44
2932,3441,2829, 2933,3442,2830, 2934,3443,2831, 
35703,3444,2832, 2936,3445,2833, 2937,3446,2834, 2938,3447,2835, 2939,3448,2836, 2932,3441,2829, 
7, // chain 45
2940,3449,2837, 2941,3450,2838, 2942,3451,2839, 
2943,3452,2840, 35712,3453,2841, 35713,3454,2842, 35714,3455,2843, 35715,3456,2844, 35709,3450,2838, 
14, // chain 46
2868,3369,2766, 2869,3370,2767, 2948,3457,2845, 
2879,3458,2777, 35649,3459,2779, 35717,3460,2846, 35718,3461,2847, 35637,3370,2767, 2870,3371,2768, 2951,3462,2848, 35720,3463,2849, 35639,3372,2769, 2953,3464,2850, 35640,3373,2770, 2902,3465,2799, 35641,3374,2771, 
9, // chain 47
2949,3460,2846, 2950,3461,2847, 2954,3466,2851, 
35719,3462,2848, 2955,3467,2852, 35724,3468,2853, 35720,3463,2849, 2957,3469,2854, 35721,3464,2850, 2901,3470,2798, 35670,3465,2799, 
1, // chain 48
2879,3458,2777, 2866,3367,2764, 2868,3369,2766, 
5, // chain 49
2958,3471,2855, 2959,3472,2856, 2960,3473,2855, 
2961,3474,2857, 35730,3475,2858, 2963,3476,2859, 35732,3477,2859, 
3, // chain 50
2960,3473,2855, 2959,3472,2856, 2965,3478,2860, 
35734,3479,2861, 2967,3480,2861, 
6, // chain 51
2968,3481,2862, 2969,3482,2863, 2970,3483,2864, 
35739,3484,2865, 2972,3485,2866, 2973,3486,2867, 2974,3487,2868, 2968,3481,2862, 
6, // chain 52
2975,3488,2869, 2976,3489,2870, 2977,3490,2871, 
2978,3491,2872, 35747,3492,2873, 35748,3493,2874, 35749,3494,2875, 35744,3489,2870, 
4, // chain 53
2982,3495,2876, 2983,3496,2877, 2975,3488,2869, 
2882,3497,2780, 35752,3498,2878, 35746,3491,2872, 
1, // chain 54
2975,3488,2869, 2983,3496,2877, 2976,3489,2870, 
5, // chain 55
2985,3499,2879, 2986,3500,2880, 2979,3492,2873, 
35668,3501,2797, 2987,3502,2881, 35662,3503,2791, 35665,3504,2794, 
1, // chain 56
2985,3499,2879, 2979,3492,2873, 2980,3493,2874, 
1, // chain 57
2978,3491,2872, 2979,3492,2873, 2987,3502,2881, 
2, // chain 58
2882,3497,2780, 2984,3498,2878, 2886,3505,2784, 
2883,3506,2781, 
3, // chain 59
2988,3507,2882, 2989,3508,2883, 2990,3509,2882, 
2991,3510,2884, 35755,3502,2881, 
1, // chain 60
2990,3509,2882, 2989,3508,2883, 2984,3498,2878, 
4, // chain 61
2859,3511,2757, 2856,3412,2754, 2907,3414,2804, 
2931,3440,2828, 2922,3429,2819, 2860,3430,2758, 
12, // chain 62
2992,3512,2885, 2993,3513,2886, 2821,3514,2719, 
2820,3515,2718, 2994,3516,2887, 35593,3517,2723, 2995,3518,2888, 35592,3519,2722, 2996,3520,2889, 35591,3521,2721, 2997,3522,2890, 35590,3523,2720, 2993,3513,2886, 35589,3514,2719, 
12, // chain 63
2998,3524,2891, 2999,3525,2892, 2826,3526,2724, 
35595,3527,2725, 35768,3528,2893, 2831,3529,2729, 35769,3530,2894, 2830,3531,2728, 35770,3532,2895, 2829,3533,2727, 35771,3534,2896, 2828,3535,2726, 35766,3524,2891, 2826,3526,2724, 
33, // chain 64
3004,3536,2897, 3005,3537,2897, 3006,3538,2898, 
3007,3539,2899, 35776,3540,2900, 35777,3541,2901, 3010,3542,2902, 35779,3543,2903, 3012,3544,2904, 35781,3545,2905, 3014,3546,2906, 35783,3547,2907, 3016,3548,2908, 35785,3549,2909, 3018,3550,2910, 35787,3551,2911, 3020,3552,2912, 35789,3553,2913, 3022,3554,2914, 
35791,3555,2915, 3024,3556,2916, 35793,3557,2917, 3026,3558,2918, 35795,3559,2919, 3028,3560,2920, 35797,3561,2921, 3030,3562,2922, 35799,3563,2923, 3032,3564,2924, 35801,3565,2925, 3034,3566,2926, 35803,3567,2927, 3036,3568,2928, 35805,3569,2929, 3038,3570,2930, 
33, // chain 65
3039,3571,2931, 3040,3572,2932, 3041,3573,2932, 
3042,3574,2933, 3043,3575,2934, 3044,3576,2935, 35813,3577,2936, 3046,3578,2937, 35815,3579,2938, 3048,3580,2939, 35817,3581,2940, 3050,3582,2941, 35819,3583,2942, 3052,3584,2943, 35821,3585,2944, 3054,3586,2945, 35823,3587,2946, 3056,3588,2947, 35825,3589,2948, 
3058,3590,2949, 35827,3591,2950, 3060,3592,2951, 35829,3593,2952, 3062,3594,2953, 35831,3595,2954, 3064,3596,2955, 35833,3597,2956, 3066,3598,2957, 35835,3599,2958, 3068,3600,2959, 35837,3601,2960, 3070,3602,2961, 35839,3603,2962, 3072,3604,2963, 35841,3605,2964, 
33, // chain 66
3074,3606,2965, 3075,3607,2966, 3076,3608,2967, 
35845,3609,2968, 35846,3610,2969, 3079,3611,2970, 35848,3612,2971, 3081,3613,2972, 35850,3614,2973, 3083,3615,2974, 35852,3616,2975, 3085,3617,2976, 35854,3618,2977, 3087,3619,2978, 35856,3620,2979, 3089,3621,2980, 35858,3622,2981, 3091,3623,2982, 35860,3624,2983, 
3093,3625,2984, 35862,3626,2985, 3095,3627,2986, 35864,3628,2987, 3097,3629,2988, 35866,3630,2989, 3099,3631,2990, 35868,3632,2991, 3101,3633,2992, 35870,3634,2993, 3103,3635,2994, 35872,3636,2995, 3105,3637,2996, 35874,3638,2997, 3107,3639,2998, 3108,3640,2998, 
33, // chain 67
3109,3641,2999, 3110,3642,3000, 3111,3643,3001, 
3112,3644,3002, 3113,3645,3003, 35882,3646,3004, 3115,3647,3005, 35884,3648,3006, 3117,3649,3007, 35886,3650,3008, 3119,3651,3009, 35888,3652,3010, 3121,3653,3011, 35890,3654,3012, 3123,3655,3013, 35892,3656,3014, 3125,3657,3015, 35894,3658,3016, 3127,3659,3017, 
35896,3660,3018, 3129,3661,3019, 35898,3662,3020, 3131,3663,3021, 35900,3664,3022, 3133,3665,3023, 35902,3666,3024, 3135,3667,3025, 35904,3668,3026, 3137,3669,3027, 35906,3670,3028, 3139,3671,3029, 35908,3672,3030, 3141,3673,3031, 35910,3674,3032, 35911,3675,3032, 
33, // chain 68
3144,3676,3033, 3145,3677,3034, 3146,3678,3035, 
35915,3679,3036, 35916,3680,3037, 3149,3681,3038, 35918,3682,3039, 3151,3683,3040, 35920,3684,3041, 3153,3685,3042, 35922,3686,3043, 3155,3687,3044, 35924,3688,3045, 3157,3689,3046, 35926,3690,3047, 3159,3691,3048, 35928,3692,3049, 3161,3693,3050, 35930,3694,3051, 
3163,3695,3052, 35932,3696,3053, 3165,3697,3054, 35934,3698,3055, 3167,3699,3056, 35936,3700,3057, 3169,3701,3058, 35938,3702,3059, 3171,3703,3060, 35940,3704,3061, 3173,3705,3062, 35942,3706,3063, 3175,3707,3064, 35944,3708,3065, 3177,3709,3066, 3178,3710,3066, 
1, // chain 69
3144,3676,3033, 3146,3678,3035, 3179,3711,3033, 
33, // chain 70
3180,3712,3067, 3181,3713,3068, 3182,3714,3069, 
3183,3715,3070, 3184,3716,3071, 35953,3717,3072, 3186,3718,3073, 35955,3719,3074, 3188,3720,3075, 35957,3721,3076, 3190,3722,3077, 35959,3723,3078, 3192,3724,3079, 35961,3725,3080, 3194,3726,3081, 35963,3727,3082, 3196,3728,3083, 35965,3729,3084, 3198,3730,3085, 
35967,3731,3086, 3200,3732,3087, 35969,3733,3088, 3202,3734,3089, 35971,3735,3090, 3204,3736,3091, 35973,3737,3092, 3206,3738,3093, 35975,3739,3094, 3208,3740,3095, 35977,3741,3096, 3210,3742,3097, 35979,3743,3098, 3212,3744,3099, 35981,3745,3100, 35982,3746,3100, 
1, // chain 71
3182,3714,3069, 3181,3713,3068, 3215,3747,3068, 
31, // chain 72
3216,3748,3101, 3217,3749,3102, 3218,3750,3103, 
35987,3751,3104, 35988,3752,3105, 3221,3753,3106, 35990,3754,3107, 3223,3755,3108, 35992,3756,3109, 3225,3757,3110, 35994,3758,3111, 3227,3759,3112, 35996,3760,3113, 3229,3761,3114, 35998,3762,3115, 3231,3763,3116, 36000,3764,3117, 3233,3765,3118, 36002,3766,3119, 
3235,3767,3120, 36004,3768,3121, 3237,3769,3122, 36006,3770,3123, 3239,3771,3124, 36008,3772,3125, 3241,3773,3126, 36010,3774,3127, 3243,3775,3128, 36012,3776,3129, 3245,3777,3130, 36014,3778,3131, 3247,3779,3132, 3248,3780,3132, 
1, // chain 73
3216,3748,3101, 3218,3750,3103, 3249,3781,3101, 
31, // chain 74
3250,3782,3133, 3251,3783,3134, 3252,3784,3135, 
3253,3785,3136, 3254,3786,3137, 36023,3787,3138, 3256,3788,3139, 36025,3789,3140, 3258,3790,3141, 36027,3791,3142, 3260,3792,3143, 36029,3793,3144, 3262,3794,3145, 36031,3795,3146, 3264,3796,3147, 36033,3797,3148, 3266,3798,3149, 36035,3799,3150, 3268,3800,3151, 
36037,3801,3152, 3270,3802,3153, 36039,3803,3154, 3272,3804,3155, 36041,3805,3156, 3274,3806,3157, 36043,3807,3158, 3276,3808,3159, 36045,3809,3160, 3278,3810,3161, 36047,3811,3162, 3280,3812,3163, 36049,3813,3164, 36050,3814,3164, 
1, // chain 75
3252,3784,3135, 3251,3783,3134, 3283,3815,3134, 
7, // chain 76
3284,3816,3165, 3285,3817,3166, 3286,3818,3167, 
3287,3819,3168, 36056,3820,3169, 36053,3817,3166, 3289,3821,3170, 3290,3822,3171, 36059,3823,3172, 
2, // chain 77
3288,3820,3169, 3290,3822,3171, 3292,3824,3173, 
3287,3819,3168, 
1, // chain 78
3292,3824,3173, 3290,3822,3171, 3293,3825,3174, 
8, // chain 79
3294,3826,3175, 3295,3827,3176, 3296,3828,3177, 
3297,3829,3178, 36066,3830,3179, 36067,3831,3180, 36068,3832,3181, 36063,3827,3176, 3301,3833,3182, 36070,3834,3183, 
2, // chain 80
3299,3831,3180, 3300,3832,3181, 3301,3833,3182, 
3303,3835,3184, 
18, // chain 81
3304,3836,3185, 3305,3837,3186, 3306,3838,3187, 
3307,3839,3188, 3308,3840,3189, 3309,3841,3190, 3310,3842,3191, 3311,3843,3192, 3312,3844,3193, 3313,3845,3194, 3314,3846,3195, 3315,3847,3196, 3316,3848,3197, 3317,3849,3198, 3318,3850,3199, 3319,3851,3200, 3320,3852,3201, 3321,3853,3202, 3322,3854,3203, 
3305,3837,3186, 
20, // chain 82
3323,3855,3204, 3324,3856,3205, 3325,3857,3206, 
3326,3858,3207, 36095,3859,3208, 36096,3860,3209, 36092,3856,3205, 3329,3861,3210, 36098,3862,3211, 36091,3855,3204, 3331,3863,3212, 36094,3858,3207, 3332,3864,3213, 36095,3859,3208, 3333,3865,3214, 36096,3860,3209, 3329,3861,3210, 3334,3866,3215, 36098,3862,3211, 
3331,3863,3212, 3332,3864,3213, 3333,3865,3214, 
9, // chain 83
3335,3867,3216, 3336,3868,3217, 3337,3869,3218, 
3338,3870,3219, 3339,3871,3220, 36108,3872,3221, 3341,3873,3222, 3335,3867,3216, 36110,3874,3223, 3336,3868,3217, 36111,3875,3224, 
1, // chain 84
3336,3868,3217, 3344,3876,3225, 3337,3869,3218, 
9, // chain 85
3345,3877,3226, 3346,3878,3227, 3347,3879,3228, 
3348,3880,3229, 36117,3881,3230, 3350,3882,3231, 3351,3883,3232, 3352,3884,3233, 3345,3877,3226, 36114,3878,3227, 36121,3885,3234, 
1, // chain 86
3346,3878,3227, 3354,3886,3235, 3347,3879,3228, 
91, // chain 87
3355,3887,3236, 3356,3888,3237, 3357,3889,3238, 
36126,3890,3239, 36127,3891,3240, 3360,3892,3241, 36129,3893,3242, 3362,3894,3243, 36131,3895,3244, 3364,3896,3245, 36133,3897,3246, 3366,3898,3247, 3367,3899,3248, 36136,3900,3249, 3369,3901,3250, 36138,3902,3251, 3371,3903,3252, 36140,3904,3253, 3373,3905,3254, 
36142,3906,3255, 3375,3907,3256, 36144,3908,3257, 36145,3909,3258, 3378,3910,3259, 36147,3911,3260, 3380,3912,3261, 3381,3913,3262, 36150,3914,3263, 3383,3915,3264, 36152,3916,3265, 36153,3917,3266, 3386,3918,3267, 36155,3919,3268, 3388,3920,3269, 3389,3921,3270, 
36123,3887,3236, 3390,3922,3271, 36125,3889,3238, 3391,3923,3272, 36160,3924,3273, 36126,3890,3239, 3393,3925,3274, 36128,3892,3241, 3362,3894,3243, 3394,3926,3275, 36132,3896,3245, 3367,3899,3248, 3395,3927,3276, 36137,3901,3250, 3371,3903,3252, 3396,3928,3277, 
36141,3905,3254, 3397,3929,3278, 36143,3907,3256, 3398,3930,3279, 36144,3908,3257, 3399,3931,3280, 36168,3932,3281, 36146,3910,3259, 3401,3933,3282, 36149,3913,3262, 3383,3915,3264, 3402,3934,3283, 36171,3935,3284, 36172,3936,3285, 36173,3937,3286, 36152,3916,3265, 
3386,3918,3267, 3406,3938,3287, 36157,3921,3270, 3407,3939,3288, 36176,3940,3289, 36158,3922,3271, 3391,3923,3272, 3409,3941,3290, 36178,3942,3291, 36160,3924,3273, 3393,3925,3274, 3411,3943,3292, 36162,3926,3275, 3412,3944,3293, 36181,3945,3294, 36163,3927,3276, 
3414,3946,3295, 36164,3928,3277, 3397,3929,3278, 3415,3947,3296, 36166,3930,3279, 3416,3948,3297, 36167,3931,3280, 3402,3934,3283, 36169,3933,3282, 36168,3932,3281, 
17, // chain 88
3410,3942,3291, 3411,3943,3292, 3417,3949,3298, 
36180,3944,3293, 3413,3945,3294, 3414,3946,3295, 3415,3947,3296, 3418,3950,3299, 36184,3948,3297, 3419,3951,3300, 36170,3934,3283, 3403,3935,3284, 3418,3950,3299, 36188,3952,3301, 36172,3936,3285, 3421,3953,3302, 36175,3939,3288, 36173,3937,3286, 3406,3938,3287, 
4, // chain 89
3409,3941,3290, 3410,3942,3291, 3417,3949,3298, 
3418,3950,3299, 3421,3953,3302, 36188,3952,3301, 
2, // chain 90
3408,3940,3289, 3409,3941,3290, 3421,3953,3302, 
3407,3939,3288, 
35, // chain 91
3422,3954,3303, 3423,3955,3304, 3424,3956,3305, 
36193,3957,3306, 36194,3958,3307, 3427,3959,3308, 36196,3960,3309, 3429,3961,3310, 36198,3962,3311, 3431,3963,3312, 36200,3964,3313, 3433,3965,3314, 36202,3966,3315, 3435,3967,3316, 36204,3968,3317, 3437,3969,3318, 36206,3970,3319, 3439,3971,3320, 36208,3972,3320, 
3441,3973,3321, 3442,3974,3322, 36211,3975,3323, 3444,3976,3324, 36213,3977,3325, 3446,3978,3326, 36215,3979,3327, 3448,3980,3328, 36217,3981,3329, 3450,3982,3330, 36219,3983,3331, 3452,3984,3332, 36221,3985,3333, 3454,3986,3334, 36223,3987,3335, 3456,3988,3336, 
36190,3989,3303, 3457,3990,3303, 
1, // chain 92
3422,3954,3303, 3424,3956,3305, 3457,3991,3303, 
3, // chain 93
3458,3992,3337, 3459,3993,3338, 3460,3994,3339, 
3461,3995,3340, 3462,3996,3340, 
33, // chain 94
3460,3994,3339, 3459,3993,3338, 3463,3997,3341, 
36232,3998,3342, 3465,3999,3343, 36234,4000,3344, 3467,4001,3345, 36236,4002,3346, 3469,4003,3347, 36238,4004,3348, 3471,4005,3349, 36240,4006,3350, 3473,4007,3351, 36242,4008,3352, 3475,4009,3353, 36244,4010,3354, 3477,4011,3354, 36246,4012,3355, 36247,4013,3356, 
3480,4014,3357, 36249,4015,3358, 3482,4016,3359, 36251,4017,3360, 3484,4018,3361, 36253,4019,3362, 3486,4020,3363, 36255,4021,3364, 3488,4022,3365, 36257,4023,3366, 3490,4024,3367, 36259,4025,3368, 3492,4026,3369, 36261,4027,3370, 3461,4028,3340, 36230,4029,3340, 
36, // chain 95
3494,4030,3371, 3495,4031,3372, 3496,4032,3373, 
3497,4033,3374, 3498,4034,3375, 36267,4035,3376, 3500,4036,3377, 36269,4037,3378, 3502,4038,3379, 36271,4039,3380, 3504,4040,3381, 36273,4041,3382, 3506,4042,3383, 36275,4043,3384, 3508,4044,3385, 36277,4045,3386, 3510,4046,3386, 36279,4047,3387, 36280,4048,3388, 
3513,4049,3389, 36282,4050,3390, 3515,4051,3391, 36284,4052,3392, 3517,4053,3393, 36286,4054,3394, 3519,4055,3395, 36288,4056,3396, 3521,4057,3397, 36290,4058,3398, 3523,4059,3399, 36292,4060,3400, 3525,4061,3401, 36294,4062,3402, 3527,4063,3403, 36296,4064,3403, 
3529,4065,3404, 3495,4031,3372, 36264,4032,3373, 
14, // chain 96
3530,4066,3405, 3531,4067,3406, 3532,4068,3407, 
3533,4069,3408, 36302,4070,3409, 3535,4071,3410, 36304,4072,3411, 3537,4073,3412, 36306,4074,3413, 3539,4075,3414, 36308,4076,3415, 36309,4077,3416, 3542,4078,3417, 36311,4079,3418, 3544,4080,3419, 36313,4081,3420, 
18, // chain 97
3546,4082,3421, 3547,4083,3422, 3548,4084,3423, 
3549,4085,3424, 36318,4086,3425, 3551,4087,3426, 36320,4088,3427, 3553,4089,3428, 36322,4090,3429, 3555,4091,3430, 36324,4092,3431, 36325,4093,3432, 3558,4094,3433, 3559,4095,3434, 36328,4096,3435, 36329,4097,3436, 3562,4098,3437, 36331,4099,3438, 3533,4069,3408, 
36298,4066,3405, 
35, // chain 98
3531,4100,3406, 3564,4101,3439, 3565,4102,3440, 
36334,4103,3441, 3567,4104,3442, 36336,4105,3443, 3569,4106,3444, 36338,4107,3445, 3571,4108,3446, 36340,4109,3447, 36341,4110,3448, 3574,4111,3449, 36343,4112,3450, 3576,4113,3451, 36345,4114,3452, 3547,4115,3422, 3546,4116,3421, 3578,4117,3453, 36347,4118,3454, 
3580,4119,3455, 36349,4120,3456, 3582,4121,3457, 36351,4122,3458, 3584,4123,3459, 3585,4124,3460, 36354,4125,3461, 3587,4126,3462, 36356,4127,3463, 3589,4128,3464, 3590,4129,3465, 36359,4130,3466, 3592,4131,3467, 36361,4132,3468, 3594,4133,3469, 36363,4134,3470, 
3596,4135,3471, 36365,4136,3472, 
14, // chain 99
3531,4100,3406, 3565,4102,3440, 3532,4137,3407, 
36366,4138,3473, 36335,4104,3442, 3599,4139,3474, 36337,4106,3444, 3600,4140,3475, 36339,4108,3446, 3601,4141,3476, 36370,4142,3477, 36340,4109,3447, 3603,4143,3478, 36342,4111,3449, 3578,4117,3453, 36344,4113,3451, 
3, // chain 100
3560,4096,3435, 3562,4098,3437, 3604,4144,3479, 
36303,4071,3410, 36301,4069,3408, 
4, // chain 101
3560,4096,3435, 3604,4144,3479, 3605,4145,3480, 
36374,4146,3481, 36305,4073,3412, 36303,4071,3410, 
14, // chain 102
3551,4087,3426, 3553,4089,3428, 3607,4147,3482, 
3608,4148,3483, 36377,4149,3484, 36378,4150,3485, 36379,4151,3486, 36321,4089,3428, 3555,4091,3430, 3612,4152,3487, 36381,4153,3488, 36324,4092,3431, 3559,4095,3434, 3614,4154,3489, 36373,4145,3480, 36328,4096,3435, 
24, // chain 103
3549,4085,3424, 3551,4087,3426, 3608,4148,3483, 
3579,4155,3454, 36349,4156,3456, 36377,4149,3484, 3583,4157,3458, 36383,4158,3490, 36378,4150,3485, 3616,4159,3491, 36385,4160,3492, 36379,4151,3486, 3618,4161,3493, 36380,4152,3487, 3619,4162,3494, 36388,4163,3495, 36381,4153,3488, 3614,4154,3489, 3621,4164,3496, 
36390,4165,3497, 36373,4145,3480, 3623,4166,3498, 36374,4146,3481, 3624,4167,3499, 36307,4075,3414, 36305,4073,3412, 
26, // chain 104
3532,4137,3407, 3598,4138,3473, 3534,4168,3409, 
36393,4169,3500, 36394,4170,3501, 36367,4139,3474, 3627,4171,3502, 36368,4140,3475, 3601,4141,3476, 3628,4172,3503, 36397,4173,3504, 36370,4142,3477, 3603,4143,3478, 3630,4174,3505, 36346,4117,3453, 3580,4119,3455, 3631,4175,3506, 36350,4121,3457, 3585,4124,3460, 
3632,4176,3507, 36355,4126,3462, 3590,4129,3465, 3633,4177,3508, 36360,4131,3467, 3634,4178,3509, 36362,4133,3469, 3635,4179,3510, 36364,4135,3471, 
1, // chain 105
3579,4155,3454, 3546,4082,3421, 3549,4085,3424, 
23, // chain 106
3534,4168,3409, 3625,4169,3500, 3536,4180,3411, 
36404,4181,3511, 36405,4182,3512, 36394,4170,3501, 3638,4183,3513, 36395,4171,3502, 3639,4184,3514, 36408,4185,3515, 36396,4172,3503, 3641,4186,3516, 36410,4187,3517, 36397,4173,3504, 3643,4188,3518, 36412,4189,3519, 36398,4174,3505, 3631,4175,3506, 3645,4190,3520, 
36400,4176,3507, 3633,4177,3508, 3646,4191,3521, 36402,4178,3509, 3647,4192,3522, 36403,4179,3510, 
23, // chain 107
3648,4193,3523, 3649,4194,3524, 3650,4195,3525, 
3651,4196,3526, 36420,4197,3527, 3653,4198,3528, 3654,4199,3529, 36423,4200,3530, 36415,4201,3522, 3635,4202,3510, 3656,4203,3531, 36364,4204,3471, 3657,4205,3532, 36365,4206,3472, 3658,4207,3533, 3659,4208,3534, 36428,4209,3535, 3661,4210,3536, 36430,4211,3537, 
3663,4212,3538, 36432,4213,3539, 3665,4214,3540, 36434,4215,3541, 3586,4216,3461, 36356,4217,3463, 
26, // chain 108
3650,4195,3525, 3649,4194,3524, 3667,4218,3542, 
36436,4219,3543, 36437,4220,3544, 36438,4221,3545, 36416,4193,3523, 3671,4222,3546, 36389,4164,3496, 36388,4163,3495, 36419,4196,3526, 3654,4199,3529, 3619,4162,3494, 36440,4223,3547, 36441,4224,3548, 36423,4200,3530, 3656,4203,3531, 3674,4225,3549, 36425,4205,3532, 
3659,4208,3534, 3675,4226,3550, 36429,4210,3536, 3676,4227,3551, 36431,4212,3538, 3677,4228,3552, 36433,4214,3540, 3584,4229,3459, 36354,4216,3461, 
9, // chain 109
3623,4166,3498, 3624,4167,3499, 3678,4230,3553, 
36447,4231,3554, 36448,4232,3555, 36307,4075,3414, 3540,4076,3415, 3681,4233,3556, 36310,4078,3417, 3682,4234,3557, 36312,4080,3419, 
4, // chain 110
3616,4159,3491, 3617,4160,3492, 3683,4235,3558, 
36440,4223,3547, 36387,4162,3494, 36386,4161,3493, 
3, // chain 111
3623,4166,3498, 3678,4230,3553, 3671,4222,3546, 
3621,4164,3496, 3622,4165,3497, 
9, // chain 112
3671,4222,3546, 3678,4230,3553, 3670,4221,3545, 
36452,4236,3559, 36447,4231,3554, 3685,4237,3560, 36454,4238,3561, 36448,4232,3555, 3681,4233,3556, 3687,4239,3562, 36450,4234,3557, 
9, // chain 113
3683,4235,3558, 3672,4223,3547, 3673,4224,3548, 
3674,4225,3549, 3675,4226,3550, 3616,4159,3491, 36444,4227,3551, 3615,4158,3490, 36445,4228,3552, 3583,4157,3458, 36352,4229,3459, 
19, // chain 114
3536,4180,3411, 3636,4181,3511, 3538,4240,3413, 
36309,4241,3416, 36456,4242,3563, 36405,4182,3512, 3689,4243,3564, 36458,4244,3565, 36406,4183,3513, 3639,4184,3514, 3691,4245,3566, 36418,4246,3525, 36408,4185,3515, 3641,4186,3516, 3652,4247,3527, 36421,4248,3528, 36410,4187,3517, 3643,4188,3518, 3646,4191,3521, 
36413,4190,3520, 36412,4189,3519, 
7, // chain 115
3691,4245,3566, 3650,4246,3525, 3667,4249,3542, 
3692,4250,3567, 36436,4251,3543, 3693,4252,3568, 36462,4253,3569, 3695,4254,3570, 36464,4255,3571, 
1, // chain 116
3653,4248,3528, 3646,4191,3521, 3647,4192,3522, 
6, // chain 117
3697,4256,3572, 3696,4257,3571, 3698,4258,3573, 
3685,4237,3560, 36452,4236,3559, 36437,4220,3544, 36462,4259,3569, 36464,4257,3571, 
3, // chain 118
3699,4260,3574, 3697,4256,3572, 3685,4237,3560, 
3686,4238,3561, 3687,4239,3562, 
6, // chain 119
3700,4261,3575, 3545,4262,3420, 3701,4263,3576, 
3702,4264,3577, 36457,4243,3564, 36456,4242,3563, 36311,4265,3418, 36313,4262,3420, 
11, // chain 120
3703,4266,3578, 3700,4261,3575, 3702,4264,3577, 
3704,4267,3579, 36473,4268,3580, 36457,4243,3564, 3690,4244,3565, 3691,4245,3566, 3692,4250,3567, 3704,4267,3579, 36461,4252,3568, 3706,4269,3581, 36463,4254,3570, 
1, // chain 121
3704,4267,3579, 3706,4269,3581, 3703,4266,3578, 
1, // chain 122
3669,4220,3544, 3694,4259,3569, 3668,4219,3543, 
1, // chain 123
3670,4221,3545, 3684,4236,3559, 3669,4220,3544, 
1, // chain 124
3688,4242,3563, 3543,4265,3418, 3541,4241,3416, 
69, // chain 125
3707,4270,3582, 3708,4271,3583, 3709,4272,3584, 
36478,4273,3585, 36479,4274,3586, 3712,4275,3587, 36481,4276,3588, 3714,4277,3589, 36483,4278,3590, 3716,4279,3591, 36485,4280,3592, 3718,4281,3593, 36487,4282,3594, 3720,4283,3595, 36489,4284,3596, 3722,4285,3597, 36491,4286,3598, 3724,4287,3599, 36493,4288,3600, 
3726,4289,3601, 36495,4290,3602, 3728,4291,3603, 36475,4270,3582, 3709,4272,3584, 3729,4292,3604, 36498,4293,3605, 36478,4273,3585, 3731,4294,3606, 36480,4275,3587, 3714,4277,3589, 3732,4295,3607, 36484,4279,3591, 3733,4296,3608, 36502,4297,3609, 36486,4281,3593, 
3735,4298,3610, 36488,4283,3595, 3736,4299,3611, 36490,4285,3597, 3737,4300,3612, 36492,4287,3599, 3738,4301,3613, 36494,4289,3601, 3739,4302,3614, 36496,4291,3603, 3729,4292,3604, 3740,4303,3615, 36509,4304,3616, 36510,4305,3617, 36498,4293,3605, 3743,4306,3618, 
36499,4294,3606, 3744,4307,3619, 36513,4308,3620, 36500,4295,3607, 3746,4309,3621, 36501,4296,3608, 3747,4310,3622, 36516,4311,3623, 36502,4297,3609, 3749,4312,3624, 36503,4298,3610, 3750,4313,3625, 36504,4299,3611, 3751,4314,3626, 36505,4300,3612, 3752,4315,3627, 
36506,4301,3613, 3753,4316,3628, 36507,4302,3614, 3740,4303,3615, 
25, // chain 126
3754,4317,3629, 3755,4318,3630, 3756,4319,3631, 
3757,4320,3632, 36526,4321,3633, 36527,4322,3634, 36528,4323,3635, 36523,4318,3630, 3761,4324,3636, 3762,4325,3637, 36531,4326,3638, 3764,4327,3639, 36533,4328,3640, 3766,4329,3641, 36535,4330,3642, 3768,4331,3643, 36537,4332,3644, 3770,4333,3645, 36539,4334,3646, 
3772,4335,3647, 36541,4336,3648, 3774,4337,3649, 36543,4338,3650, 3776,4339,3651, 36545,4340,3652, 3757,4320,3632, 36522,4317,3629, 
9, // chain 127
3758,4321,3633, 3778,4341,3653, 3779,4342,3654, 
3780,4343,3655, 36549,4344,3656, 36550,4345,3657, 36551,4346,3658, 36546,4341,3653, 3784,4347,3659, 36527,4322,3634, 36526,4321,3633, 
12, // chain 128
3785,4348,3660, 3786,4349,3661, 3787,4350,3662, 
3780,4343,3655, 36542,4337,3649, 36540,4335,3647, 36556,4351,3663, 36554,4349,3661, 3789,4352,3664, 36558,4353,3665, 36553,4348,3660, 3791,4354,3666, 36549,4344,3656, 36548,4343,3655, 
14, // chain 129
3764,4327,3639, 3766,4329,3641, 3792,4355,3667, 
3793,4356,3668, 36562,4357,3669, 36563,4358,3670, 36564,4359,3671, 36534,4329,3641, 3768,4331,3643, 3797,4360,3672, 36538,4333,3645, 3798,4361,3673, 36540,4335,3647, 3788,4351,3663, 3799,4362,3674, 36557,4352,3664, 
4, // chain 130
3762,4325,3637, 3764,4327,3639, 3793,4356,3668, 
3800,4363,3675, 36569,4364,3676, 36562,4357,3669, 
4, // chain 131
3760,4323,3635, 3762,4325,3637, 3800,4363,3675, 
3759,4322,3634, 36570,4365,3677, 36569,4364,3676, 
22, // chain 132
3803,4366,3678, 3804,4367,3679, 3805,4368,3680, 
3806,4369,3681, 3807,4370,3682, 36576,4371,3683, 3809,4372,3684, 36578,4373,3685, 3811,4374,3686, 36580,4375,3687, 3813,4376,3688, 36582,4377,3689, 3815,4378,3690, 36584,4379,3691, 3817,4380,3692, 36586,4381,3693, 3819,4382,3694, 36588,4383,3695, 3821,4384,3696, 
36590,4385,3697, 3823,4386,3698, 36592,4387,3699, 3804,4367,3679, 36573,4368,3680, 
22, // chain 133
3825,4388,3700, 3826,4389,3701, 3827,4390,3702, 
36596,4391,3703, 36597,4392,3704, 3830,4393,3705, 36599,4394,3706, 3832,4395,3707, 36601,4396,3708, 3834,4397,3709, 36603,4398,3710, 3836,4399,3711, 36605,4400,3712, 3838,4401,3713, 36607,4402,3714, 3840,4403,3715, 36609,4404,3716, 3842,4405,3717, 36611,4406,3718, 
3844,4407,3719, 36613,4408,3720, 3846,4409,3721, 36593,4388,3700, 3827,4390,3702, 
22, // chain 134
3847,4410,3722, 3848,4411,3723, 3849,4412,3724, 
36618,4413,3725, 36619,4414,3726, 3852,4415,3727, 36621,4416,3728, 3854,4417,3729, 36623,4418,3730, 3856,4419,3731, 36625,4420,3732, 3858,4421,3733, 36627,4422,3734, 3860,4423,3735, 36629,4424,3736, 3862,4425,3737, 36631,4426,3738, 3864,4427,3739, 36633,4428,3740, 
3866,4429,3741, 36635,4430,3742, 3868,4431,3743, 36615,4410,3722, 3849,4412,3724, 
22, // chain 135
3869,4432,3744, 3870,4433,3745, 3871,4434,3746, 
3872,4435,3747, 3873,4436,3748, 36642,4437,3749, 3875,4438,3750, 36644,4439,3751, 3877,4440,3752, 36646,4441,3753, 3879,4442,3754, 36648,4443,3755, 3881,4444,3756, 36650,4445,3757, 3883,4446,3758, 36652,4447,3759, 3885,4448,3760, 36654,4449,3761, 3887,4450,3762, 
36656,4451,3763, 3889,4452,3764, 36658,4453,3765, 3870,4433,3745, 36639,4434,3746, 
10, // chain 136
3891,4454,3766, 3892,4455,3767, 3893,4456,3768, 
3894,4457,3769, 36663,4458,3770, 3896,4459,3771, 36665,4460,3772, 3898,4461,3773, 36667,4462,3774, 36668,4463,3775, 3901,4464,3776, 36670,4465,3776, 
3, // chain 137
3903,4466,3777, 3904,4467,3778, 3905,4468,3779, 
36674,4469,3780, 36675,4470,3781, 
1, // chain 138
3891,4454,3766, 3894,4457,3769, 3908,4471,3782, 
7, // chain 139
3906,4469,3780, 3909,4472,3783, 3910,4473,3784, 
36679,4474,3785, 36680,4475,3786, 3913,4476,3787, 3914,4477,3788, 36683,4478,3789, 3916,4479,3789, 
1, // chain 140
3906,4469,3780, 3910,4473,3784, 3905,4468,3779, 
3, // chain 141
3774,4337,3649, 3776,4339,3651, 3780,4343,3655, 
36525,4320,3632, 3758,4321,3633, 
5, // chain 142
3917,4480,3790, 3795,4358,3670, 3796,4359,3671, 
3797,4360,3672, 3918,4481,3791, 36566,4361,3673, 3799,4362,3674, 
9, // chain 143
3919,4482,3792, 3741,4304,3616, 3742,4305,3617, 
3743,4306,3618, 3920,4483,3793, 36512,4307,3619, 3921,4484,3794, 36513,4308,3620, 3922,4485,3795, 36514,4309,3621, 3747,4310,3622, 
1, // chain 144
3802,4365,3677, 3784,4347,3659, 3759,4322,3634, 
1, // chain 145
3782,4345,3657, 3791,4354,3666, 3781,4344,3656, 
26, // chain 146
3923,4486,3796, 3924,4487,3797, 3925,4488,3798, 
3926,4489,3799, 3927,4490,3800, 36696,4491,3801, 3929,4492,3802, 36698,4493,3803, 3931,4494,3804, 36700,4495,3805, 3933,4496,3806, 36702,4497,3807, 3935,4498,3808, 36704,4499,3809, 3937,4500,3810, 36706,4501,3811, 3939,4502,3812, 36708,4503,3813, 3941,4504,3814, 
36710,4505,3815, 3943,4506,3816, 36712,4507,3817, 3945,4508,3818, 36714,4509,3819, 3947,4510,3820, 36716,4511,3821, 3924,4487,3797, 36693,4488,3798, 
26, // chain 147
3949,4512,3822, 3950,4513,3823, 3951,4514,3824, 
36720,4515,3825, 36721,4516,3826, 3954,4517,3827, 36723,4518,3828, 3956,4519,3829, 36725,4520,3830, 3958,4521,3831, 36727,4522,3832, 3960,4523,3833, 36729,4524,3834, 3962,4525,3835, 36731,4526,3836, 3964,4527,3837, 36733,4528,3838, 3966,4529,3839, 36735,4530,3840, 
3968,4531,3841, 36737,4532,3842, 3970,4533,3843, 36739,4534,3844, 3972,4535,3845, 36741,4536,3846, 3974,4537,3847, 36717,4512,3822, 3951,4514,3824, 
26, // chain 148
3975,4538,3848, 3976,4539,3849, 3977,4540,3850, 
36746,4541,3851, 36747,4542,3852, 3980,4543,3853, 36749,4544,3854, 3982,4545,3855, 36751,4546,3856, 3984,4547,3857, 36753,4548,3858, 3986,4549,3859, 36755,4550,3860, 3988,4551,3861, 36757,4552,3862, 3990,4553,3863, 36759,4554,3864, 3992,4555,3865, 36761,4556,3866, 
3994,4557,3867, 36763,4558,3867, 3996,4559,3868, 36765,4560,3869, 3998,4561,3870, 36767,4562,3871, 4000,4563,3872, 36743,4538,3848, 3977,4540,3850, 
26, // chain 149
4001,4564,3873, 4002,4565,3874, 4003,4566,3875, 
4004,4567,3876, 4005,4568,3877, 36774,4569,3878, 4007,4570,3879, 36776,4571,3880, 4009,4572,3881, 36778,4573,3882, 4011,4574,3883, 36780,4575,3884, 4013,4576,3885, 36782,4577,3886, 4015,4578,3887, 36784,4579,3888, 4017,4580,3889, 36786,4581,3890, 4019,4582,3891, 
36788,4583,3892, 4021,4584,3892, 36790,4585,3893, 4023,4586,3894, 36792,4587,3895, 4025,4588,3896, 36794,4589,3897, 4002,4565,3874, 36771,4566,3875, 

 0};


// face array: 1kb.
const uint16_t sinbad_6_face[869] PROGMEM = {
8, // chain 0
4027,4590,3898, 4028,4591,3899, 4029,4592,3900, 
4030,4593,3901, 36799,4594,3902, 36800,4595,3903, 36801,4596,3904, 36802,4597,3905, 36803,4598,3906, 36796,4591,3899, 
8, // chain 1
4036,4599,3907, 4037,4600,3908, 4038,4601,3909, 
36807,4602,3910, 4040,4603,3911, 4041,4604,3912, 4042,4605,3913, 4043,4606,3914, 4044,4607,3915, 4036,4599,3907, 
8, // chain 2
4045,4608,3916, 4046,4609,3917, 4047,4610,3918, 
4048,4611,3919, 36817,4612,3920, 36818,4613,3921, 36819,4614,3922, 36820,4615,3923, 36821,4616,3924, 36814,4609,3917, 
8, // chain 3
4054,4617,3925, 4055,4618,3926, 4056,4619,3927, 
36825,4620,3928, 4058,4621,3929, 4059,4622,3930, 4060,4623,3931, 4061,4624,3932, 4062,4625,3933, 4054,4617,3925, 
8, // chain 4
4063,4626,3934, 4064,4627,3935, 4065,4628,3936, 
4066,4629,3937, 36835,4630,3938, 36836,4631,3939, 36837,4632,3940, 36838,4633,3941, 36839,4634,3942, 36832,4627,3935, 
8, // chain 5
4072,4635,3943, 4073,4636,3944, 4074,4637,3945, 
36843,4638,3946, 4076,4639,3947, 4077,4640,3948, 4078,4641,3949, 4079,4642,3950, 4080,4643,3951, 4072,4635,3943, 
8, // chain 6
4081,4644,3952, 4082,4645,3953, 4083,4646,3954, 
4084,4647,3955, 36853,4648,3956, 36854,4649,3957, 36855,4650,3958, 36856,4651,3959, 36857,4652,3960, 36850,4645,3953, 
8, // chain 7
4090,4653,3961, 4091,4654,3962, 4092,4655,3963, 
36861,4656,3964, 4094,4657,3965, 4095,4658,3966, 4096,4659,3967, 4097,4660,3968, 4098,4661,3969, 4090,4653,3961, 
8, // chain 8
4099,4662,3970, 4100,4663,3971, 4101,4664,3972, 
4102,4665,3973, 36871,4666,3974, 36872,4667,3975, 36873,4668,3976, 36874,4669,3977, 36875,4670,3978, 36868,4663,3971, 
8, // chain 9
4108,4671,3979, 4109,4672,3980, 4110,4673,3981, 
36879,4674,3982, 4112,4675,3983, 4113,4676,3984, 4114,4677,3985, 4115,4678,3986, 4116,4679,3987, 4108,4671,3979, 
8, // chain 10
4117,4680,3988, 4118,4681,3989, 4119,4682,3990, 
4120,4683,3991, 36889,4684,3992, 36890,4685,3993, 36891,4686,3994, 36892,4687,3995, 36893,4688,3996, 36886,4681,3989, 
8, // chain 11
4126,4689,3997, 4127,4690,3998, 4128,4691,3999, 
36897,4692,4000, 4130,4693,4001, 4131,4694,4002, 4132,4695,4003, 4133,4696,4004, 4134,4697,4005, 4126,4689,3997, 
8, // chain 12
4135,4698,4006, 4136,4699,4007, 4137,4700,4008, 
4138,4701,4009, 36907,4702,4010, 36908,4703,4011, 36909,4704,4012, 36910,4705,4013, 36911,4706,4014, 36904,4699,4007, 
8, // chain 13
4144,4707,4015, 4145,4708,4016, 4146,4709,4017, 
36915,4710,4018, 4148,4711,4019, 4149,4712,4020, 4150,4713,4021, 4151,4714,4022, 4152,4715,4023, 4144,4707,4015, 
8, // chain 14
4153,4716,4024, 4154,4717,4025, 4155,4718,4026, 
4156,4719,4027, 36925,4720,4028, 36926,4721,4029, 36927,4722,4030, 36928,4723,4031, 36929,4724,4032, 36922,4717,4025, 
8, // chain 15
4162,4725,4033, 4163,4726,4034, 4164,4727,4035, 
36933,4728,4036, 4166,4729,4037, 4167,4730,4038, 4168,4731,4039, 4169,4732,4040, 4170,4733,4041, 4162,4725,4033, 
8, // chain 16
4171,4734,4042, 4172,4735,4043, 4173,4736,4044, 
36942,4737,4045, 4175,4738,4046, 4176,4739,4047, 4177,4740,4048, 4178,4741,4049, 4179,4742,4050, 4171,4734,4042, 
8, // chain 17
4180,4743,4051, 4181,4744,4052, 4182,4745,4053, 
4183,4746,4054, 36952,4747,4055, 36953,4748,4056, 36954,4749,4057, 36955,4750,4058, 36956,4751,4059, 36949,4744,4052, 
8, // chain 18
4189,4752,4060, 4190,4753,4061, 4191,4754,4062, 
36960,4755,4063, 4193,4756,4064, 4194,4757,4065, 4195,4758,4066, 4196,4759,4067, 4197,4760,4068, 4189,4752,4060, 
8, // chain 19
4198,4761,4069, 4199,4762,4070, 4200,4763,4071, 
4201,4764,4072, 36970,4765,4073, 36971,4766,4074, 36972,4767,4075, 36973,4768,4076, 36974,4769,4077, 36967,4762,4070, 
8, // chain 20
4207,4770,4078, 4208,4771,4079, 4209,4772,4080, 
36978,4773,4081, 4211,4774,4082, 4212,4775,4083, 4213,4776,4084, 4214,4777,4085, 4215,4778,4086, 4207,4770,4078, 
8, // chain 21
4216,4779,4087, 4217,4780,4088, 4218,4781,4089, 
4219,4782,4090, 36988,4783,4091, 36989,4784,4092, 36990,4785,4093, 36991,4786,4094, 36992,4787,4095, 36985,4780,4088, 
8, // chain 22
4225,4788,4096, 4226,4789,4097, 4227,4790,4098, 
36996,4791,4099, 4229,4792,4100, 4230,4793,4101, 4231,4794,4102, 4232,4795,4103, 4233,4796,4104, 4225,4788,4096, 
8, // chain 23
4234,4797,4105, 4235,4798,4106, 4236,4799,4107, 
4237,4800,4108, 37006,4801,4109, 37007,4802,4110, 37008,4803,4111, 37009,4804,4112, 37010,4805,4113, 37003,4798,4106, 
8, // chain 24
4243,4806,4114, 4244,4807,4115, 4245,4808,4116, 
37014,4809,4117, 4247,4810,4118, 4248,4811,4119, 4249,4812,4120, 4250,4813,4121, 4251,4814,4122, 4243,4806,4114, 
8, // chain 25
4252,4815,4123, 4253,4816,4124, 4254,4817,4125, 
4255,4818,4126, 37024,4819,4127, 37025,4820,4128, 37026,4821,4129, 37027,4822,4130, 37028,4823,4131, 37021,4816,4124, 
8, // chain 26
4261,4824,4132, 4262,4825,4133, 4263,4826,4134, 
37032,4827,4135, 4265,4828,4136, 4266,4829,4137, 4267,4830,4138, 4268,4831,4139, 4269,4832,4140, 4261,4824,4132, 
8, // chain 27
4270,4833,4141, 4271,4834,4142, 4272,4835,4143, 
4273,4836,4144, 37042,4837,4145, 37043,4838,4146, 37044,4839,4147, 37045,4840,4148, 37046,4841,4149, 37039,4834,4142, 

 0};


// face array: 6kb.
const uint16_t sinbad_7_face[3343] PROGMEM = {
13, // chain 0
4279,4842,4150, 4280,4843,4151, 4281,4844,4152, 
4282,4845,4153, 4283,4846,4154, 37052,4847,4155, 4285,4848,4156, 37054,4849,4157, 4287,4850,4158, 37056,4851,4159, 4289,4852,4160, 37058,4853,4161, 4291,4854,4162, 4292,4855,4163, 37061,4856,4164, 
14, // chain 1
4281,4844,4152, 4280,4843,4151, 4294,4857,4165, 
37063,4858,4166, 37064,4859,4167, 37065,4860,4168, 37047,4842,4150, 4298,4861,4169, 37051,4846,4154, 4299,4862,4170, 37053,4848,4156, 4300,4863,4171, 37055,4850,4158, 4301,4864,4172, 37057,4852,4160, 4292,4855,4163, 
4, // chain 2
4294,4857,4165, 4295,4858,4166, 4302,4865,4173, 
37071,4866,4174, 37072,4867,4175, 37064,4859,4167, 
13, // chain 3
4305,4868,4176, 4306,4869,4177, 4307,4870,4178, 
4308,4871,4179, 4309,4872,4180, 37078,4873,4181, 4311,4874,4182, 37080,4875,4183, 4313,4876,4184, 37082,4877,4185, 4315,4878,4186, 37061,4879,4164, 4291,4880,4162, 4316,4881,4187, 37058,4882,4161, 
14, // chain 4
4307,4870,4178, 4306,4869,4177, 4317,4883,4188, 
37086,4884,4189, 37087,4885,4190, 37088,4886,4191, 37073,4868,4176, 4321,4887,4192, 37077,4872,4180, 4322,4888,4193, 37079,4874,4182, 4323,4889,4194, 37081,4876,4184, 4324,4890,4195, 37083,4878,4186, 4316,4881,4187, 
4, // chain 5
4325,4891,4196, 4317,4883,4188, 4318,4884,4189, 
4303,4892,4174, 37094,4893,4197, 37087,4885,4190, 
1, // chain 6
4303,4866,4174, 4326,4894,4197, 4302,4865,4173, 
1, // chain 7
4325,4891,4196, 4303,4892,4174, 4304,4895,4175, 
24, // chain 8
4327,4896,4198, 4328,4897,4198, 4329,4898,4198, 
37098,4899,4198, 4331,4900,4198, 4332,4901,4198, 37101,4902,4198, 4334,4903,4198, 37103,4904,4198, 4336,4905,4198, 4337,4906,4198, 4338,4907,4198, 37107,4908,4198, 4340,4909,4198, 37109,4910,4198, 4342,4911,4198, 4343,4912,4198, 4344,4913,4198, 37113,4914,4198, 
4346,4915,4198, 37115,4916,4198, 4348,4917,4198, 4349,4918,4198, 4350,4919,4198, 37095,4896,4198, 4329,4898,4198, 
24, // chain 9
4351,4920,4199, 4352,4921,4199, 4353,4922,4199, 
37122,4923,4200, 37123,4924,4199, 4356,4925,4201, 4357,4926,4202, 4358,4927,4203, 37127,4928,4203, 4360,4929,4204, 37129,4930,4205, 4362,4931,4206, 4363,4932,4199, 4364,4933,4199, 37133,4934,4199, 4366,4935,4200, 37135,4936,4199, 4368,4937,4201, 4369,4938,4202, 
4370,4939,4203, 37139,4940,4203, 4372,4941,4204, 37141,4942,4205, 4374,4943,4206, 4351,4920,4199, 4353,4922,4199, 
24, // chain 10
4375,4944,4207, 4376,4945,4207, 4377,4946,4208, 
4378,4947,4208, 37147,4948,4208, 37148,4949,4208, 4381,4950,4208, 37150,4951,4207, 4383,4952,4207, 37152,4953,4207, 37153,4954,4207, 37154,4955,4207, 4387,4956,4207, 37156,4957,4208, 4389,4958,4208, 37158,4959,4208, 37159,4960,4208, 37160,4961,4208, 4393,4962,4208, 
37162,4963,4208, 4395,4964,4208, 37164,4965,4208, 37165,4966,4208, 37166,4967,4208, 4376,4945,4207, 37145,4946,4208, 
24, // chain 11
4399,4968,4209, 4400,4969,4209, 4401,4970,4209, 
4402,4971,4209, 37171,4972,4209, 4404,4973,4209, 37173,4974,4209, 4406,4975,4209, 37175,4976,4209, 37176,4977,4209, 37177,4978,4209, 4410,4979,4209, 37179,4980,4209, 4412,4981,4209, 37181,4982,4210, 37182,4983,4209, 37183,4984,4209, 4416,4985,4209, 37185,4986,4209, 
4418,4987,4210, 37187,4988,4209, 37188,4989,4209, 37189,4990,4209, 4422,4991,4209, 37169,4970,4209, 4400,4969,4209, 
16, // chain 12
4423,4992,4211, 4424,4993,4212, 4425,4994,4212, 
37194,4995,4213, 37195,4996,4213, 4428,4997,4214, 37197,4998,4214, 4430,4999,4215, 37199,5000,4215, 4432,5001,4216, 37201,5002,4216, 4434,5003,4217, 37203,5004,4217, 4436,5005,4218, 37205,5006,4218, 4438,5007,4211, 37191,4992,4211, 4425,4994,4212, 
11, // chain 13
4439,5008,4219, 4440,5009,4220, 4441,5010,4219, 
4442,5011,4216, 37211,5012,4216, 4444,5013,4221, 37213,5014,4221, 4446,5015,4222, 4447,5016,4222, 37216,5017,4223, 4449,5018,4223, 37218,5019,4218, 37219,5020,4218, 
5, // chain 14
4441,5010,4219, 4440,5009,4220, 4452,5021,4220, 
37221,5022,4224, 4454,5023,4224, 37223,5024,4214, 37224,5025,4214, 
11, // chain 15
4457,5026,4225, 4458,5027,4226, 4459,5028,4225, 
4460,5029,4212, 37229,5030,4212, 4462,5031,4227, 37231,5032,4227, 4464,5033,4228, 4465,5034,4228, 37234,5035,4229, 4467,5036,4229, 37219,5037,4218, 37218,5019,4218, 
5, // chain 16
4459,5028,4225, 4458,5027,4226, 4468,5038,4226, 
37237,5039,4230, 4470,5040,4230, 37224,5025,4214, 37223,5041,4214, 
24, // chain 17
4471,5042,4231, 4472,5043,4231, 4473,5044,4231, 
37242,5045,4231, 37243,5046,4231, 37244,5047,4231, 37245,5048,4231, 4478,5049,4231, 37247,5050,4231, 4480,5051,4231, 37249,5052,4231, 37250,5053,4231, 37251,5054,4231, 4484,5055,4231, 37253,5056,4231, 4486,5057,4231, 37255,5058,4231, 37256,5059,4231, 37257,5060,4231, 
4490,5061,4231, 37259,5062,4231, 4492,5063,4231, 37261,5064,4231, 37262,5065,4231, 37239,5042,4231, 4473,5044,4231, 
6, // chain 18
4495,5066,4232, 4496,5067,4233, 4497,5068,4234, 
4498,5069,4235, 37267,5070,4236, 37268,5071,4237, 37269,5072,4238, 37264,5067,4233, 
12, // chain 19
4502,5073,4239, 4503,5074,4240, 4495,5066,4232, 
4504,5075,4241, 37266,5069,4235, 4505,5076,4242, 37274,5077,4243, 37267,5070,4236, 4507,5078,4244, 37276,5079,4245, 37268,5071,4237, 4509,5080,4246, 37278,5081,4247, 37269,5072,4238, 
1, // chain 20
4495,5066,4232, 4503,5074,4240, 4496,5067,4233, 
6, // chain 21
4511,5082,4248, 4512,5083,4249, 4513,5084,4250, 
4514,5085,4251, 37283,5086,4252, 37284,5087,4253, 37285,5088,4254, 37280,5083,4249, 
6, // chain 22
4518,5089,4255, 4519,5090,4256, 4520,5091,4257, 
4521,5092,4258, 37290,5093,4259, 37291,5094,4260, 37292,5095,4261, 37287,5090,4256, 
13, // chain 23
4516,5087,4253, 4517,5088,4254, 4525,5096,4262, 
4526,5097,4263, 37295,5098,4264, 4528,5099,4265, 37297,5100,4266, 4530,5101,4267, 37299,5102,4268, 4532,5103,4269, 37301,5104,4270, 4534,5105,4271, 37303,5106,4272, 4511,5082,4248, 37280,5083,4249, 
6, // chain 24
4536,5107,4273, 4537,5108,4274, 4538,5109,4275, 
4539,5110,4276, 37308,5111,4277, 37270,5073,4239, 37309,5112,4278, 37305,5108,4274, 
5, // chain 25
4509,5080,4246, 4510,5081,4247, 4542,5113,4279, 
4543,5114,4280, 37312,5115,4281, 4518,5089,4255, 37287,5090,4256, 
6, // chain 26
4545,5116,4282, 4546,5117,4283, 4547,5118,4284, 
4548,5119,4285, 37317,5120,4286, 37318,5121,4287, 37319,5122,4288, 37314,5117,4283, 
6, // chain 27
4523,5094,4260, 4552,5123,4289, 4553,5124,4290, 
4554,5125,4291, 37323,5126,4292, 37313,5116,4282, 37324,5127,4293, 37320,5123,4289, 
1, // chain 28
4545,5116,4282, 4556,5127,4293, 4546,5117,4283, 
9, // chain 29
4557,5128,4294, 4558,5129,4295, 4536,5107,4273, 
4559,5130,4296, 37307,5110,4276, 4560,5131,4297, 37329,5132,4298, 37308,5111,4277, 4562,5133,4299, 37272,5075,4241, 37270,5073,4239, 
1, // chain 30
4536,5107,4273, 4558,5129,4295, 4537,5108,4274, 
12, // chain 31
4550,5121,4287, 4563,5134,4300, 4557,5128,4294, 
4564,5135,4301, 37327,5130,4296, 4565,5136,4302, 37328,5131,4297, 4566,5137,4303, 37335,5138,4304, 37329,5132,4298, 4562,5133,4299, 4568,5139,4305, 37273,5076,4242, 37272,5075,4241, 
1, // chain 32
4557,5128,4294, 4563,5134,4300, 4558,5129,4295, 
1, // chain 33
4550,5121,4287, 4551,5122,4288, 4563,5134,4300, 
1, // chain 34
4502,5073,4239, 4541,5112,4278, 4503,5074,4240, 
1, // chain 35
4523,5094,4260, 4524,5095,4261, 4552,5123,4289, 
6, // chain 36
4569,5140,4306, 4543,5114,4280, 4570,5141,4307, 
4571,5142,4308, 37340,5143,4309, 37289,5092,4258, 37286,5089,4255, 37311,5114,4280, 
6, // chain 37
4549,5120,4286, 4550,5121,4287, 4564,5135,4301, 
4573,5144,4310, 37333,5136,4302, 4574,5145,4311, 37343,5146,4312, 37334,5137,4303, 
6, // chain 38
4515,5086,4252, 4516,5087,4253, 4576,5147,4313, 
4577,5148,4314, 37346,5149,4315, 37347,5150,4316, 37294,5097,4263, 37284,5087,4253, 
6, // chain 39
4580,5151,4317, 4534,5105,4271, 4581,5152,4318, 
4582,5153,4319, 37351,5154,4320, 37282,5085,4251, 37279,5082,4248, 37302,5105,4271, 
20, // chain 40
4584,5155,4321, 4532,5103,4269, 4580,5151,4317, 
4585,5156,4322, 37350,5153,4319, 4586,5157,4323, 37355,5158,4324, 37351,5154,4320, 4588,5159,4325, 37357,5160,4326, 37282,5085,4251, 4515,5086,4252, 4577,5148,4314, 4590,5161,4327, 37359,5162,4328, 37346,5149,4315, 4592,5163,4329, 37361,5164,4330, 37347,5150,4316, 
4594,5165,4331, 37296,5099,4265, 37294,5097,4263, 
1, // chain 41
4580,5151,4317, 4532,5103,4269, 4534,5105,4271, 
5, // chain 42
4594,5165,4331, 4530,5101,4267, 4584,5155,4321, 
4595,5166,4332, 37353,5156,4322, 4596,5167,4333, 37354,5157,4323, 
1, // chain 43
4584,5155,4321, 4530,5101,4267, 4532,5103,4269, 
1, // chain 44
4594,5165,4331, 4528,5099,4265, 4530,5101,4267, 
14, // chain 45
4508,5079,4245, 4509,5080,4246, 4569,5140,4306, 
4597,5168,4334, 37339,5142,4308, 4598,5169,4335, 37367,5170,4336, 37368,5171,4337, 37340,5143,4309, 4601,5172,4338, 37370,5173,4339, 37289,5092,4258, 4522,5093,4259, 4603,5174,4340, 37322,5125,4291, 37291,5094,4260, 
1, // chain 46
4569,5140,4306, 4509,5080,4246, 4543,5114,4280, 
7, // chain 47
4555,5126,4292, 4545,5116,4282, 4548,5119,4285, 
4604,5175,4341, 37373,5176,4342, 37317,5120,4286, 4573,5144,4310, 4606,5177,4343, 37342,5145,4311, 
4, // chain 48
4607,5178,4344, 4555,5126,4292, 4604,5175,4341, 
4608,5179,4345, 37374,5177,4343, 37373,5176,4342, 
4, // chain 49
4603,5174,4340, 4554,5125,4291, 4607,5178,4344, 
4609,5180,4346, 37378,5181,4347, 37376,5179,4345, 
1, // chain 50
4607,5178,4344, 4554,5125,4291, 4555,5126,4292, 
3, // chain 51
4507,5078,4244, 4508,5079,4245, 4597,5168,4334, 
4611,5182,4348, 37366,5169,4335, 
3, // chain 52
4593,5164,4330, 4594,5165,4331, 4595,5166,4332, 
4612,5183,4349, 37364,5167,4333, 
1, // chain 53
4593,5164,4330, 4612,5183,4349, 4592,5163,4329, 
1, // chain 54
4590,5161,4327, 4588,5159,4325, 4589,5160,4326, 
5, // chain 55
4613,5184,4350, 4568,5139,4305, 4505,5076,4242, 
4614,5185,4351, 37274,5077,4243, 4611,5182,4348, 37275,5078,4244, 
2, // chain 56
4601,5172,4338, 4602,5173,4339, 4603,5174,4340, 
4609,5180,4346, 
13, // chain 57
4615,5186,4352, 4616,5187,4353, 4617,5188,4354, 
4618,5189,4355, 4619,5190,4356, 37388,5191,4357, 4621,5192,4358, 37390,5193,4359, 4623,5194,4360, 37392,5195,4361, 4625,5196,4362, 37394,5197,4363, 4627,5198,4364, 4628,5199,4365, 37397,5200,4366, 
14, // chain 58
4617,5188,4354, 4616,5187,4353, 4630,5201,4367, 
37399,5202,4368, 37400,5203,4369, 37401,5204,4370, 37383,5186,4352, 4634,5205,4371, 37387,5190,4356, 4635,5206,4372, 37389,5192,4358, 4636,5207,4373, 37391,5194,4360, 4637,5208,4374, 37393,5196,4362, 4628,5199,4365, 
4, // chain 59
4630,5201,4367, 4631,5202,4368, 4638,5209,4375, 
37407,5210,4376, 37408,5211,4377, 37400,5203,4369, 
13, // chain 60
4641,5212,4378, 4642,5213,4379, 4643,5214,4380, 
4644,5215,4381, 4645,5216,4382, 37414,5217,4383, 4647,5218,4384, 37416,5219,4385, 4649,5220,4386, 37418,5221,4387, 4651,5222,4388, 37397,5223,4366, 4627,5224,4364, 4652,5225,4389, 37394,5226,4363, 
14, // chain 61
4643,5214,4380, 4642,5213,4379, 4653,5227,4390, 
37422,5228,4391, 37423,5229,4392, 37424,5230,4393, 37409,5212,4378, 4657,5231,4394, 37413,5216,4382, 4658,5232,4395, 37415,5218,4384, 4659,5233,4396, 37417,5220,4386, 4660,5234,4397, 37419,5222,4388, 4652,5225,4389, 
4, // chain 62
4661,5235,4398, 4653,5227,4390, 4654,5228,4391, 
4639,5236,4376, 37430,5237,4399, 37423,5229,4392, 
1, // chain 63
4639,5210,4376, 4662,5238,4399, 4638,5209,4375, 
1, // chain 64
4661,5235,4398, 4639,5236,4376, 4640,5239,4377, 
24, // chain 65
4663,5240,4400, 4664,5241,4400, 4665,5242,4400, 
37434,5243,4400, 4667,5244,4400, 4668,5245,4400, 37437,5246,4400, 4670,5247,4400, 37439,5248,4400, 4672,5249,4400, 4673,5250,4400, 4674,5251,4400, 37443,5252,4400, 4676,5253,4400, 37445,5254,4400, 4678,5255,4400, 4679,5256,4400, 4680,5257,4400, 37449,5258,4400, 
4682,5259,4400, 37451,5260,4400, 4684,5261,4400, 4685,5262,4400, 4686,5263,4400, 37431,5240,4400, 4665,5242,4400, 
24, // chain 66
4687,5264,4401, 4688,5265,4401, 4689,5266,4401, 
37458,5267,4402, 37459,5268,4401, 4692,5269,4403, 4693,5270,4404, 4694,5271,4405, 37463,5272,4405, 4696,5273,4406, 37465,5274,4407, 4698,5275,4408, 4699,5276,4401, 4700,5277,4401, 37469,5278,4401, 4702,5279,4402, 37471,5280,4401, 4704,5281,4403, 4705,5282,4404, 
4706,5283,4405, 37475,5284,4405, 4708,5285,4406, 37477,5286,4407, 4710,5287,4408, 4687,5264,4401, 4689,5266,4401, 
24, // chain 67
4711,5288,4409, 4712,5289,4410, 4713,5290,4409, 
4714,5291,4409, 37483,5292,4409, 37484,5293,4409, 4717,5294,4409, 37486,5295,4409, 4719,5296,4409, 37488,5297,4409, 37489,5298,4409, 37490,5299,4409, 4723,5300,4410, 37492,5301,4409, 4725,5302,4409, 37494,5303,4409, 37495,5304,4409, 37496,5305,4409, 4729,5306,4409, 
37498,5307,4409, 4731,5308,4409, 37500,5309,4409, 37501,5310,4409, 37502,5311,4409, 4712,5289,4410, 37481,5290,4409, 
24, // chain 68
4735,5312,4411, 4736,5313,4411, 4737,5314,4411, 
4738,5315,4411, 37507,5316,4411, 4740,5317,4411, 37509,5318,4411, 4742,5319,4411, 37511,5320,4412, 37512,5321,4412, 37513,5322,4412, 4746,5323,4411, 37515,5324,4411, 4748,5325,4411, 37517,5326,4411, 37518,5327,4411, 37519,5328,4411, 4752,5329,4411, 37521,5330,4411, 
4754,5331,4412, 37523,5332,4411, 37524,5333,4411, 37525,5334,4411, 4758,5335,4411, 37505,5314,4411, 4736,5313,4411, 
16, // chain 69
4759,5336,4413, 4760,5337,4414, 4761,5338,4414, 
37530,5339,4415, 37531,5340,4415, 4764,5341,4416, 37533,5342,4416, 4766,5343,4417, 37535,5344,4417, 4768,5345,4418, 37537,5346,4418, 4770,5347,4419, 37539,5348,4419, 4772,5349,4420, 37541,5350,4420, 4774,5351,4413, 37527,5336,4413, 4761,5338,4414, 
11, // chain 70
4775,5352,4421, 4776,5353,4422, 4777,5354,4421, 
4778,5355,4418, 37547,5356,4418, 4780,5357,4423, 37549,5358,4423, 4782,5359,4424, 4783,5360,4424, 37552,5361,4425, 4785,5362,4425, 37554,5363,4420, 37555,5364,4426, 
5, // chain 71
4777,5354,4421, 4776,5353,4422, 4788,5365,4422, 
37557,5366,4427, 4790,5367,4427, 37559,5368,4428, 37560,5369,4428, 
11, // chain 72
4793,5370,4429, 4794,5371,4430, 4795,5372,4429, 
4796,5373,4414, 37565,5374,4414, 4798,5375,4431, 37567,5376,4431, 4800,5377,4432, 4801,5378,4432, 37570,5379,4433, 4803,5380,4433, 37555,5381,4426, 37554,5363,4420, 
5, // chain 73
4795,5372,4429, 4794,5371,4430, 4804,5382,4430, 
37573,5383,4434, 4806,5384,4434, 37560,5369,4428, 37559,5385,4428, 
24, // chain 74
4807,5386,4435, 4808,5387,4435, 4809,5388,4435, 
37578,5389,4435, 37579,5390,4435, 37580,5391,4435, 37581,5392,4435, 4814,5393,4435, 37583,5394,4435, 4816,5395,4435, 37585,5396,4435, 37586,5397,4435, 37587,5398,4435, 4820,5399,4435, 37589,5400,4435, 4822,5401,4435, 37591,5402,4435, 37592,5403,4435, 37593,5404,4435, 
4826,5405,4435, 37595,5406,4435, 4828,5407,4435, 37597,5408,4435, 37598,5409,4435, 37575,5386,4435, 4809,5388,4435, 
6, // chain 75
4831,5410,4436, 4832,5411,4437, 4833,5412,4438, 
4834,5413,4439, 37603,5414,4440, 37604,5415,4441, 37605,5416,4442, 37600,5411,4437, 
12, // chain 76
4838,5417,4443, 4839,5418,4444, 4831,5410,4436, 
4840,5419,4445, 37602,5413,4439, 4841,5420,4446, 37610,5421,4447, 37603,5414,4440, 4843,5422,4448, 37612,5423,4449, 37604,5415,4441, 4845,5424,4450, 37614,5425,4451, 37605,5416,4442, 
1, // chain 77
4831,5410,4436, 4839,5418,4444, 4832,5411,4437, 
6, // chain 78
4847,5426,4452, 4848,5427,4453, 4849,5428,4454, 
4850,5429,4455, 37619,5430,4456, 37620,5431,4457, 37621,5432,4458, 37616,5427,4453, 
6, // chain 79
4854,5433,4459, 4855,5434,4460, 4856,5435,4461, 
4857,5436,4462, 37626,5437,4463, 37627,5438,4464, 37628,5439,4465, 37623,5434,4460, 
13, // chain 80
4852,5431,4457, 4853,5432,4458, 4861,5440,4466, 
4862,5441,4467, 37631,5442,4468, 4864,5443,4469, 37633,5444,4470, 4866,5445,4471, 37635,5446,4472, 4868,5447,4473, 37637,5448,4474, 4870,5449,4475, 37639,5450,4476, 4847,5426,4452, 37616,5427,4453, 
6, // chain 81
4872,5451,4477, 4873,5452,4478, 4874,5453,4479, 
4875,5454,4480, 37644,5455,4481, 37606,5417,4443, 37645,5456,4482, 37641,5452,4478, 
5, // chain 82
4845,5424,4450, 4846,5425,4451, 4878,5457,4483, 
4879,5458,4484, 37648,5459,4485, 4854,5433,4459, 37623,5434,4460, 
6, // chain 83
4881,5460,4486, 4882,5461,4487, 4883,5462,4488, 
4884,5463,4489, 37653,5464,4490, 37654,5465,4491, 37655,5466,4492, 37650,5461,4487, 
6, // chain 84
4859,5438,4464, 4888,5467,4493, 4889,5468,4494, 
4890,5469,4495, 37659,5470,4496, 37649,5460,4486, 37660,5471,4497, 37656,5467,4493, 
1, // chain 85
4881,5460,4486, 4892,5471,4497, 4882,5461,4487, 
9, // chain 86
4893,5472,4498, 4894,5473,4499, 4872,5451,4477, 
4895,5474,4500, 37643,5454,4480, 4896,5475,4501, 37665,5476,4502, 37644,5455,4481, 4898,5477,4503, 37608,5419,4445, 37606,5417,4443, 
1, // chain 87
4872,5451,4477, 4894,5473,4499, 4873,5452,4478, 
12, // chain 88
4886,5465,4491, 4899,5478,4504, 4893,5472,4498, 
4900,5479,4505, 37663,5474,4500, 4901,5480,4506, 37664,5475,4501, 4902,5481,4507, 37671,5482,4508, 37665,5476,4502, 4898,5477,4503, 4904,5483,4509, 37609,5420,4446, 37608,5419,4445, 
1, // chain 89
4893,5472,4498, 4899,5478,4504, 4894,5473,4499, 
1, // chain 90
4886,5465,4491, 4887,5466,4492, 4899,5478,4504, 
1, // chain 91
4838,5417,4443, 4877,5456,4482, 4839,5418,4444, 
1, // chain 92
4859,5438,4464, 4860,5439,4465, 4888,5467,4493, 
6, // chain 93
4905,5484,4510, 4879,5458,4484, 4906,5485,4511, 
4907,5486,4512, 37676,5487,4513, 37625,5436,4462, 37622,5433,4459, 37647,5458,4484, 
6, // chain 94
4885,5464,4490, 4886,5465,4491, 4900,5479,4505, 
4909,5488,4514, 37669,5480,4506, 4910,5489,4515, 37679,5490,4516, 37670,5481,4507, 
6, // chain 95
4851,5430,4456, 4852,5431,4457, 4912,5491,4517, 
4913,5492,4518, 37682,5493,4519, 37683,5494,4520, 37630,5441,4467, 37620,5431,4457, 
6, // chain 96
4916,5495,4521, 4870,5449,4475, 4917,5496,4522, 
4918,5497,4523, 37687,5498,4524, 37618,5429,4455, 37615,5426,4452, 37638,5449,4475, 
20, // chain 97
4920,5499,4525, 4868,5447,4473, 4916,5495,4521, 
4921,5500,4526, 37686,5497,4523, 4922,5501,4527, 37691,5502,4528, 37687,5498,4524, 4924,5503,4529, 37693,5504,4530, 37618,5429,4455, 4851,5430,4456, 4913,5492,4518, 4926,5505,4531, 37695,5506,4532, 37682,5493,4519, 4928,5507,4533, 37697,5508,4534, 37683,5494,4520, 
4930,5509,4535, 37632,5443,4469, 37630,5441,4467, 
1, // chain 98
4916,5495,4521, 4868,5447,4473, 4870,5449,4475, 
5, // chain 99
4930,5509,4535, 4866,5445,4471, 4920,5499,4525, 
4931,5510,4536, 37689,5500,4526, 4932,5511,4537, 37690,5501,4527, 
1, // chain 100
4920,5499,4525, 4866,5445,4471, 4868,5447,4473, 
1, // chain 101
4930,5509,4535, 4864,5443,4469, 4866,5445,4471, 
14, // chain 102
4844,5423,4449, 4845,5424,4450, 4905,5484,4510, 
4933,5512,4538, 37675,5486,4512, 4934,5513,4539, 37703,5514,4540, 37704,5515,4541, 37676,5487,4513, 4937,5516,4542, 37706,5517,4543, 37625,5436,4462, 4858,5437,4463, 4939,5518,4544, 37658,5469,4495, 37627,5438,4464, 
1, // chain 103
4905,5484,4510, 4845,5424,4450, 4879,5458,4484, 
7, // chain 104
4891,5470,4496, 4881,5460,4486, 4884,5463,4489, 
4940,5519,4545, 37709,5520,4546, 37653,5464,4490, 4909,5488,4514, 4942,5521,4547, 37678,5489,4515, 
4, // chain 105
4943,5522,4548, 4891,5470,4496, 4940,5519,4545, 
4944,5523,4549, 37710,5521,4547, 37709,5520,4546, 
4, // chain 106
4939,5518,4544, 4890,5469,4495, 4943,5522,4548, 
4945,5524,4550, 37714,5525,4551, 37712,5523,4549, 
1, // chain 107
4943,5522,4548, 4890,5469,4495, 4891,5470,4496, 
3, // chain 108
4843,5422,4448, 4844,5423,4449, 4933,5512,4538, 
4947,5526,4552, 37702,5513,4539, 
3, // chain 109
4929,5508,4534, 4930,5509,4535, 4931,5510,4536, 
4948,5527,4553, 37700,5511,4537, 
1, // chain 110
4929,5508,4534, 4948,5527,4553, 4928,5507,4533, 
1, // chain 111
4926,5505,4531, 4924,5503,4529, 4925,5504,4530, 
5, // chain 112
4949,5528,4554, 4904,5483,4509, 4841,5420,4446, 
4950,5529,4555, 37610,5421,4447, 4947,5526,4552, 37611,5422,4448, 
2, // chain 113
4937,5516,4542, 4938,5517,4543, 4939,5518,4544, 
4945,5524,4550, 

 0};


// mesh info for object sinbad_7 (with tag [usemtl Sinbad/Sheaths])
const tgx::Mesh3D<tgx::RGB565> sinbad_7 = 
    {
    1, // version/id
    
    4951, // number of vertices
    5530, // number of texture coords
    4556, // number of normal vectors
    848, // number of triangles
    3343,
    
    sinbad_vert_array, // array of vertices
    sinbad_tex_array, // array of texture coords
    sinbad_norm_array, // array of normal vectors        
    sinbad_7_face, // array of face vertex indexes   
    
    &sinbad_sword_texture, // pointer to texture image 
    
    { 0.75f , 0.75f, 0.75f }, // default color
    
    0.1f, // ambiant light strength 
    0.7f, // diffuse light strength
    0.6f, // specular light strength
    32, // specular exponent
    
    nullptr, // next mesh to draw after this one    
    
    { // mesh bounding box
    -0.32630777556943186, 0.29585072341018503, 
    -0.10573174122367415, 0.6956746721116679, 
    -0.4190432519475148, -0.05589628727915092
    },

    "sinbad"    
    };
    

// mesh info for object sinbad_6 (with tag [usemtl Sinbad/Spikes])
const tgx::Mesh3D<tgx::RGB565> sinbad_6 = 
    {
    1, // version/id
    
    4951, // number of vertices
    5530, // number of texture coords
    4556, // number of normal vectors
    224, // number of triangles
    869, 
    
    sinbad_vert_array, // array of vertices
    sinbad_tex_array, // array of texture coords
    sinbad_norm_array, // array of normal vectors        
    sinbad_6_face, // array of face vertex indexes   
    
    &sinbad_clothes_texture, // pointer to texture image 
    
    { 0.75f , 0.75f, 0.75f }, // default color
    
    0.1f, // ambiant light strength 
    0.7f, // diffuse light strength
    0.6f, // specular light strength
    32, // specular exponent
    
    &sinbad_7, // next mesh to draw after this one    
    
    { // mesh bounding box
    -0.718241812471861, 0.6839331111575117, 
    -0.05148734944718255, 0.6991879317655877, 
    -0.08298786169122412, 0.3394074433707943
    },

    "sinbad"    
    };
    

// mesh info for object sinbad_5 (with tag [usemtl Sinbad/Clothes])
const tgx::Mesh3D<tgx::RGB565> sinbad_5 = 
    {
    1, // version/id
    
    4951, // number of vertices
    5530, // number of texture coords
    4556, // number of normal vectors
    1786, // number of triangles
    6409, 
    
    sinbad_vert_array, // array of vertices
    sinbad_tex_array, // array of texture coords
    sinbad_norm_array, // array of normal vectors        
    sinbad_5_face, // array of face vertex indexes   
    
    &sinbad_clothes_texture, // pointer to texture image 
    
    { 0.75f , 0.75f, 0.75f }, // default color
    
    0.1f, // ambiant light strength 
    0.7f, // diffuse light strength
    0.6f, // specular light strength
    32, // specular exponent
    
    &sinbad_6, // next mesh to draw after this one    
    
    { // mesh bounding box
    -0.699093848389521, 0.6738555389701554, 
    -1.0, 1.0, 
    -0.1537991377613615, 0.4190432519475148
    },

    "sinbad"    
    };
    

// mesh info for object sinbad_4 (with tag [usemtl Sinbad/Gold])
const tgx::Mesh3D<tgx::RGB565> sinbad_4 = 
    {
    1, // version/id
    
    4951, // number of vertices
    5530, // number of texture coords
    4556, // number of normal vectors
    802, // number of triangles
    2953, 
    
    sinbad_vert_array, // array of vertices
    sinbad_tex_array, // array of texture coords
    sinbad_norm_array, // array of normal vectors        
    sinbad_4_face, // array of face vertex indexes   
    
    &sinbad_clothes_texture, // pointer to texture image 
    
    { 0.75f , 0.75f, 0.75f }, // default color
    
    0.1f, // ambiant light strength 
    0.7f, // diffuse light strength
    0.6f, // specular light strength
    32, // specular exponent
    
    &sinbad_5, // next mesh to draw after this one    
    
    { // mesh bounding box
    -0.718246916051223, 0.6940612753489794, 
    -0.12846263991296406, 0.8234359027044753, 
    -0.08427840158557116, 0.29722103446890935
    },

    "sinbad"    
    };
    

// mesh info for object sinbad_3 (with tag [usemtl Sinbad/Eyes])
const tgx::Mesh3D<tgx::RGB565> sinbad_3 = 
    {
    1, // version/id
    
    4951, // number of vertices
    5530, // number of texture coords
    4556, // number of normal vectors
    528, // number of triangles
    1725, 
    
    sinbad_vert_array, // array of vertices
    sinbad_tex_array, // array of texture coords
    sinbad_norm_array, // array of normal vectors        
    sinbad_3_face, // array of face vertex indexes   
    
    &sinbad_body_texture, // pointer to texture image 
    
    { 0.75f , 0.75f, 0.75f }, // default color
    
    0.1f, // ambiant light strength 
    0.7f, // diffuse light strength
    0.6f, // specular light strength
    32, // specular exponent
    
    &sinbad_4, // next mesh to draw after this one    
    
    { // mesh bounding box
    -0.12987766276479534, 0.0862136566902045, 
    0.8147744628427246, 0.9155930104039792, 
    0.19579249822650618, 0.2966330133684933
    },

    "sinbad"    
    };
    

// mesh info for object sinbad_2 (with tag [usemtl Sinbad/Teeth])
const tgx::Mesh3D<tgx::RGB565> sinbad_2 = 
    {
    1, // version/id
    
    4951, // number of vertices
    5530, // number of texture coords
    4556, // number of normal vectors
    488, // number of triangles
    1808, 
    
    sinbad_vert_array, // array of vertices
    sinbad_tex_array, // array of texture coords
    sinbad_norm_array, // array of normal vectors        
    sinbad_2_face, // array of face vertex indexes   
    
    &sinbad_body_texture, // pointer to texture image 
    
    { 0.75f , 0.75f, 0.75f }, // default color
    
    0.1f, // ambiant light strength 
    0.7f, // diffuse light strength
    0.6f, // specular light strength
    32, // specular exponent
    
    &sinbad_3, // next mesh to draw after this one    
    
    { // mesh bounding box
    -0.17056472880799692, 0.12690072273340608, 
    0.6417269536224429, 0.7798318082137006, 
    0.1948521082553503, 0.3370327257041331
    },

    "sinbad"    
    };
    

// mesh info for object sinbad_1 (with tag [ | o Sinbad | usemtl Sinbad/Body])
const tgx::Mesh3D<tgx::RGB565> sinbad_1 = 
    {
    1, // version/id
    
    4951, // number of vertices
    5530, // number of texture coords
    4556, // number of normal vectors
    2936, // number of triangles
    11329, 
    
    sinbad_vert_array, // array of vertices
    sinbad_tex_array, // array of texture coords
    sinbad_norm_array, // array of normal vectors        
    sinbad_1_face, // array of face vertex indexes   
    
    &sinbad_body_texture, // pointer to texture image 
    
    { 0.75f , 0.75f, 0.75f }, // default color
    
    0.1f, // ambiant light strength 
    0.7f, // diffuse light strength
    0.6f, // specular light strength
    32, // specular exponent
    
    &sinbad_2, // next mesh to draw after this one    
    
    { // mesh bounding box
    -0.7562639225090261, 0.7562639225090261, 
    -0.3861598915910986, 0.9845499120076348, 
    -0.14101755609111088, 0.4072133768809186
    },

    "sinbad"    
    };
    
                
/** end of sinbad.h */
    
    
    