// 3D model [elementalist]
//
// - vertices   : 5306
// - textures   : 5260
// - normals    : 5306
// - triangles  : 6227
//
// - memory size: 217kb
//
// - model bounding box: [-0.5,0.5]x[-1.0,1.0]x[-0.32,0.32]
//
// object [elementalist_1] (tagged [ | g SUN_Online_-_ver_0_7_5_4_(_Protocol_ver___2_5_3_)-23db2a48.obj | usemtl Material__45]) with 948 triangles (142 chains)
// object [elementalist_2] (tagged [ | g SUN_Online_-_ver_0_7_5_4_(_Protocol_ver___2_5_3_)-23dce8f8.obj | usemtl Material__46]) with 1352 triangles (253 chains)
// object [elementalist_3] (tagged [ | g SUN_Online_-_ver_0_7_5_4_(_Protocol_ver___2_5_3_)-23deaf70.obj | usemtl Material__49]) with 528 triangles (75 chains)
// object [elementalist_4] (tagged [ | g SUN_Online_-_ver_0_7_5_4_(_Protocol_ver___2_5_3_)-23df9290.obj | usemtl Material__49]) with 876 triangles (123 chains)
// object [elementalist_5] (tagged [ | g SUN_Online_-_ver_0_7_5_4_(_Protocol_ver___2_5_3_)-23e0b828.obj | usemtl Material__49]) with 540 triangles (95 chains)
// object [elementalist_6] (tagged [ | g SUN_Online_-_ver_0_7_5_4_(_Protocol_ver___2_5_3_)-23e1a310.obj | usemtl Material__49]) with 769 triangles (103 chains)
// object [elementalist_7] (tagged [ | g SUN_Online_-_ver_0_7_5_4_(_Protocol_ver___2_5_3_)-23e2c670.obj | usemtl Material__51]) with 1214 triangles (288 chains)

#pragma once

#include <tgx.h>

#include "elementalist_hair_texture.h" // texture for object [elementalist_1]

#include "elementalist_face_texture.h" // texture for object [elementalist_2]

#include "elementalist_face_texture.h" // texture for object [elementalist_3]

#include "elementalist_body_texture.h" // texture for object [elementalist_4]

#include "elementalist_body_texture.h" // texture for object [elementalist_5]

#include "elementalist_body_texture.h" // texture for object [elementalist_6]

#include "elementalist_weapon_texture.h" // texture for object [elementalist_7]


// vertex array: 62kb.
const tgx::fVec3 elementalist_vert_array[5306] PROGMEM = {
{0.10067371591168232,0.967548185184209,0.13774413463775304},
{0.10191961477063975,0.976034782489116,0.12459848067263868},
{0.08230152081712261,0.9729755003019629,0.12229485127025073},
{0.08294922320406405,0.9628180783683218,0.13612785819305703},
{0.06399785474368654,0.9526313195962058,0.1253662807420845},
{0.06529417629377174,0.9644167068711228,0.11629271747363983},
{0.05059756618837685,0.9442902605134174,0.11215691083090863},
{0.05313726546286309,0.9541976317378751,0.1057594172970458},
{0.038860309664081716,0.9457117220151198,0.08976602725346455},
{0.035475113537002785,0.9363601463633207,0.0942249975075147},
{0.029396199733447294,0.9338011947885856,0.057001591752681276},
{0.035741666217828295,0.9419657744524266,0.06543891233671358},
{0.0661103363078901,0.9379386057896706,0.13264617137068355},
{0.08497781974575501,0.9517221067975518,0.14548883080093006},
{0.05322023370917335,0.9310373437326311,0.1167139761386074},
{0.03416618631413563,0.923375386621714,0.09340677474694113},
{0.031622590740789526,0.9247716367778522,0.061822230218548},
{0.11111533846804401,0.9527816708933866,0.1463196592342856},
{0.1111873053999264,0.963478844816146,0.135295654595398},
{0.10009339657561166,0.9553701885006469,0.14788803412241022},
{0.11443613106690972,0.9477325259590911,0.140019343977869},
{0.11422023027126259,0.9564123338486377,0.12686612660908547},
{0.1109826351127577,0.970546043365806,0.12132856915300193},
{0.11405773168940077,0.959920377986828,0.1125914627508099},
{0.10005122487030478,0.9810353382846886,0.11482587554992246},
{0.10042458197870095,0.9831588211633202,0.10115124171606754},
{0.08335489667359211,0.9785671475539837,0.1020806235911728},
{0.08233635831281087,0.9774115511509551,0.11541971733497741},
{0.06397608130888136,0.9687466408746962,0.10051912452456559},
{0.06310766505123057,0.9623166017856508,0.11090001065752335},
{0.04798796272846347,0.9498138371324156,0.09657217377951302},
{0.047426666498591,0.9367339618598179,0.1073213747517542},
{0.037716402157632764,0.9317402818857625,0.07696966502143537},
{0.03213163072712956,0.9198446522725164,0.08647342552282028},
{0.031527475209798476,0.917405569186235,0.05536193751482598},
{0.021755099281132836,0.9022200881709511,0.06163864578403273},
{0.0198229934347364,0.8936145391537925,0.04221009531034594},
{0.027043981192336183,0.9107213538950955,0.04040267102746548},
{0.02176724656581362,0.8915568349676778,0.02394493383740745},
{0.027079277076125632,0.9043933061585586,0.021008041273264635},
{0.026633036259644745,0.9018125811490184,0.004153798375701754},
{0.024545307652903924,0.8915646275653976,0.009133497512671567},
{0.025555824221914825,0.8813324883712668,0.012860880357267719},
{0.025621832108482102,0.8802639857074589,0.028576487211544967},
{0.02467296873907745,0.8816687160434689,0.04478875757343091},
{0.02619756756354116,0.8869204685184781,0.06807097681358387},
{0.03648860962867123,0.903501282913698,0.09592470058662217},
{0.05351658161657437,0.9260968367783106,0.11685974355477681},
{0.0677664925173872,0.9511878554656479,0.12681089084289549},
{0.08429252953451831,0.969119539594991,0.12581664705147583},
{0.10039959982718766,0.9740226879190668,0.12705177379005594},
{0.11093290000378167,0.9694138247559367,0.12625944995719798},
{0.11080432214140581,0.9752885266604248,0.1131335066804336},
{0.11394840612727371,0.9663169547444884,0.1088496406810272},
{0.11414436704052032,0.9598342010238099,0.12278945203140416},
{0.11066543054675383,0.9775112505629577,0.09976003382904186},
{0.11382670408641528,0.9672653597257922,0.09568977668477682},
{0.050379831840325066,0.8647853655014822,0.07548265402126692},
{0.04986895830158038,0.8616389895751085,0.06788945512552384},
{0.04657589818283494,0.8260013774562439,0.07498461534935476},
{0.04822609534701695,0.8292928332166353,0.0815771530202619},
{0.04791118272151888,0.8035806986522243,0.09051067872380168},
{0.05234815034671327,0.8328077531763429,0.0872027209917685},
{0.053437968057225144,0.8653175540869309,0.08982057543750278},
{0.057963862974044884,0.8890473893078682,0.09989869622964326},
{0.047488090504146666,0.8951363876496493,0.08916599722904393},
{0.07369780535236864,0.9108231160535534,0.13403256618264703},
{0.06376338922994233,0.9200096719889345,0.11783106794113837},
{0.044464333394833716,0.9009773980287018,0.07682389760526598},
{0.057438091822012455,0.926916893091289,0.10675251511821256},
{0.10186804610925906,0.9387561409680926,0.1526399143731027},
{0.10128933113154245,0.9522018099454171,0.14954602388431198},
{0.08484694994287335,0.9464740214273515,0.1475990204246278},
{0.09107048519234534,0.9335369340482658,0.15248933388187108},
{0.07127086955076817,0.9299250650051626,0.14255170904273667},
{0.0671446890581614,0.9395090434242506,0.13093248745449063},
{0.08333266485068577,0.9533393000184498,0.13647921267259744},
{0.09957220930459083,0.9608266112628248,0.13942458541661176},
{0.11114696724702416,0.9590301882943723,0.14052082056053988},
{0.1115184908030157,0.9496417124004292,0.14673954273494969},
{0.10909224258356698,0.9394927706466593,0.15072958196151143},
{0.10815781843934892,0.9395367759043709,0.1485967021268062},
{0.10171838239422977,0.938265436505799,0.14874063599057094},
{0.09094969992768924,0.9332004771820134,0.14812479157666025},
{0.08266066789438277,0.9207488228020577,0.14851327549239476},
{0.05532515186970774,0.9050180891404419,0.12643203307728537},
{0.06512434350229133,0.8947430906588526,0.1320509544213251},
{0.08266066789438277,0.9207488228020577,0.14851327549239476},
{0.0524338689216305,0.9182022477060537,0.11700046870183343},
{0.045278659856547415,0.8838084716996915,0.10909327395679463},
{0.05297407929884953,0.8738160694824683,0.11103981902837766},
{0.04538156798525821,0.896594291005394,0.10032362199942013},
{0.034879438199543186,0.8682867630122055,0.0812267153169238},
{0.040500422290038175,0.8600165248910467,0.08012979259084393},
{0.03521337393123947,0.8782117821785581,0.07754356692408977},
{0.0282564177199088,0.863657959966675,0.052566457679891536},
{0.027985510352122257,0.8570590048623516,0.04925116573823977},
{0.03173191630291659,0.8537652571614545,0.05717325809656632},
{0.11093679630264154,0.9385764528324373,0.14551289617624105},
{0.1124059301668647,0.9375686865920332,0.14705583052475124},
{0.11446409274108059,0.9455790186598334,0.14024487092364057},
{0.1146146732323122,0.9346698402402871,0.14235804006999586},
{0.11433070180364255,0.953306983657318,0.13554639288673345},
{0.11384824832716989,0.9355877624128631,0.14065421149797794},
{0.11461123532155348,0.9346689234640846,0.14194571997300093},
{0.1146146732323122,0.9346698402402871,0.14235804006999586},
{0.06183976356341739,0.8952441088534223,0.12234366960302445},
{0.05137017933288485,0.8713313767801214,0.10564573704795771},
{0.05993286906258484,0.8620008869809757,0.10924133331346984},
{0.0737915457190562,0.884900122962608,0.13289645127391783},
{0.07152665011121638,0.9139912654147323,0.13816287216816422},
{0.08462554849001226,0.9086379799753158,0.1439110589567316},
{0.07745406664733795,0.9277639943022358,0.1364232893242557},
{0.09159854828488359,0.9237155105927759,0.14679156978443153},
{0.10276717436968769,0.9391987146797643,0.14286662166823472},
{0.08937513680019891,0.9426460223945506,0.13459546677087356},
{0.06698562838705831,0.9299968027429945,0.1251247102127723},
{0.07990735976475519,0.945675967743229,0.11052779951938006},
{0.05216296155384396,0.9038810574555105,0.11396777302454783},
{0.05113433865483717,0.8833010360717055,0.09338316775973128},
{0.061108863736115106,0.9132674706029981,0.12019933006579016},
{0.04085429790413498,0.8683786698264885,0.05277433668376838},
{0.03816722685512527,0.8700251998858612,0.06705289684090382},
{0.04556561080787463,0.9326930415540273,0.09270635772836608},
{0.04758091409463191,0.9409243166865874,0.07556264274491963},
{0.03431997552207537,0.8307330886304852,0.05574331641499249},
{0.028472089321505367,0.828436105855564,0.06932077197140117},
{0.03737490302226732,0.8272640074808937,0.08181207692210726},
{0.02830798638128949,0.7929926210975414,0.07717204336809824},
{0.046332494101118095,0.9254933688431314,0.10422840103916582},
{0.043031412190602324,0.8695450383498944,0.08566964198743328},
{0.10511733016434356,0.9982572084393831,0.06087657556585145},
{0.10525186707203452,0.9962829308876799,0.03829041865731251},
{0.08612058128195106,0.9952277214788057,0.03872290783075854},
{0.08517194710659698,0.9970901523338257,0.061333130114608475},
{0.06462126256126641,0.9814460540233294,0.03617174885374327},
{0.06343174543875187,0.9831028978149784,0.05829722572061474},
{0.03640014072514703,0.9394178241921197,0.041370557503068346},
{0.03829740907585518,0.9402720304186344,0.018329221210075828},
{0.025717864415675473,0.8740938526717723,0.012844378385625882},
{0.029797060127913173,0.882766555545751,-0.002749984815894154},
{0.020694847603145893,0.844038720042905,-0.015068706646512851},
{0.015697500524281368,0.8337637215613156,-0.0023525623321869575},
{0.020936188938407516,0.7802003843584226,0.0006599642686475478},
{0.019894043590416455,0.802289877759353,-0.027556115298359062},
{0.011201859222138288,0.7387673714765711,-0.0005854762022087464},
{0.012108092498134911,0.756370162143331,-0.02842430236195929},
{0.11324019651097893,0.9905310769943034,0.05952685180198093},
{0.11308296939228048,0.9896644942890572,0.03619856455766123},
{0.11346939056155977,0.985333414315231,0.07930446481470232},
{0.1067540048795413,0.9898959802801437,0.08135552237335023},
{0.08694705502834554,0.9872038669620211,0.0817398807961743},
{0.06856844250036954,0.9758342376948577,0.07850870307108569},
{0.04257577441804763,0.9360158968993482,0.06544876768088853},
{0.02864008856058112,0.8654832613855008,0.029122656634079102},
{0.018067137813236617,0.8235384581887022,0.0115833527193301},
{0.05965050199226925,0.891674869903727,0.005297935076201307},
{0.060709836894053876,0.8110547166416653,-0.0017873698034546511},
{0.046352204789468054,0.7894094013107608,0.02184849585674455},
{0.053967177120016294,0.8825385074654232,0.033833052761616425},
{0.06718158930030492,0.7465329242983509,-0.008266914807425422},
{0.0487337601690535,0.7225062827819115,0.011610626811349216},
{0.06602966000208563,0.8944444508109457,-0.009235259671129432},
{0.07106299054689134,0.833394948333931,-0.019029638228650846},
{0.04527728469224393,0.8139157459750659,-0.006596777760842868},
{0.052424013577455526,0.8796128454097587,0.01085520322063479},
{0.0753138526030141,0.769817893867111,-0.02876557230327412},
{0.0501378029229117,0.7478219116388176,-0.018293237744134643},
{0.09904047910724331,0.9937423148369915,0.08287805845135872},
{0.1003010463854379,0.9972001654781044,0.0695893873986819},
{0.08325084257462842,0.9955781591821437,0.06955432070894305},
{0.08277526491967317,0.9924993955006916,0.0830708106478972},
{0.06459673879785426,0.9858694991995398,0.06792383423311096},
{0.08352931334608413,0.9904013531616744,0.06669947961490816},
{0.10019813825672709,0.9922630964345425,0.06578843326384935},
{0.11028680197519429,0.9940553939100847,0.06925407650268214},
{0.10950639623296655,0.9901043176721217,0.08139402697384782},
{0.09902420632965206,0.9860544587983586,0.09526118381019065},
{0.08456756239521532,0.984398531782912,0.09552384019215629},
{0.06403383820962773,0.9803878650917978,0.08241760760374181},
{0.051176968748245205,0.9699407418782223,0.060024202891741346},
{0.06536568483755295,0.9812312991979351,0.06445154436681132},
{0.04920039925603609,0.9637761094997496,0.07102551731962141},
{0.03527571471299745,0.952590293861152,0.04385570859351633},
{0.05484361516943741,0.9657595548134761,0.05510821970083301},
{0.03750302249654201,0.9416918875619826,0.051815617970188736},
{0.023969343003794285,0.9211838331100599,0.016518359016436664},
{0.02748128344084442,0.9322791170986783,0.012249619824368587},
{0.04052655041180439,0.9510443799899841,0.03901833896195723},
{0.06639545370681266,0.969127332192711,0.09364399058929226},
{0.04856255221326962,0.9522536078008487,0.08659902386253858},
{0.0382469863847274,0.9292386288236729,0.061439934542179164},
{0.027993302949842005,0.91067184798017,0.019362427990094248},
{0.10856372110292759,0.9828853926609772,0.09288856699857784},
{0.11364564078645643,0.9788357629812644,0.09089962102763736},
{0.11348360059269579,0.9829103748124906,0.07749979086042885},
{0.11273413604729646,0.9852951389087842,0.06666395453706812},
{0.1107351055381304,0.9860959429215136,0.06378871517253154},
{0.11337152470196175,0.9819188813496776,0.06268147871417555},
{0.10728619346499,0.990270483358793,0.0646550686837271},
{0.10007024797650299,0.9907698971950086,0.09805620525702392},
{0.1001371726392726,0.9925367541309363,0.085373981662184},
{0.084956504699051,0.993989615217568,0.08153200179229747},
{0.07825876695892725,0.9919268687623404,0.09221084019101032},
{0.06176710904938326,0.9873349659589533,0.07388860939947722},
{0.07037747114160409,0.9901400719440124,0.06609119860466661},
{0.06078042866163277,0.9811861479699707,0.04726382412565335},
{0.051408913127433016,0.9764035557165006,0.052165138897324506},
{0.04853000665808714,0.9730593853244758,0.022800338748806773},
{0.04271649956510426,0.9692946438496348,0.024641454557122612},
{0.03738773788909985,0.9759419588986307,0.008198614980352355},
{0.03301700734452333,0.9721779050059417,0.004689654065959786},
{0.032433708485795104,0.9668816888851199,0.007372370428008426},
{0.038063401950212156,0.9617259687173039,0.02592860834518457},
{0.045502353249914314,0.9661386417731369,0.054123831253588335},
{0.054774169372111416,0.9772618874359259,0.0802329299136053},
{0.07319495360539428,0.9824068354833643,0.09995966184709776},
{0.10042687391920677,0.9829562136226065,0.10740663493857028},
{0.11236673798421537,0.9841033298457638,0.09549725368228891},
{0.11191362134621706,0.9772607414656731,0.10581259031678056},
{0.1136532041901256,0.9800371981944089,0.09355345893931286},
{0.11384893590932163,0.9695174204667996,0.10162544420671929},
{0.1118581563859765,0.9876418567926815,0.0836256894443534},
{0.1104960561433746,0.9849527229972161,0.08544984489292629},
{0.0993143659976874,0.9885982835657552,0.08467769013651943},
{0.08481921746275307,0.9903495553062432,0.0813619398067665},
{0.07037747114160409,0.9901400719440124,0.06609119860466661},
{0.11351981325268755,0.9828782876454092,0.08176646730604167},
{0.11356038059964035,0.9797649156623192,0.08208504703634903},
{0.11357298627242231,0.9789815303974339,0.08244373572550805},
{0.11351981325268755,0.9828782876454092,0.08176646730604167},
{0.07532279117098675,0.856076220773461,-0.06596880898165644},
{0.07888377913486118,0.8064465410606871,-0.0724389570295534},
{0.05005437628850027,0.7951949467295727,-0.042570388357858986},
{0.05340519330799209,0.8442626426303225,-0.02592723318088107},
{0.08272988449765818,0.9058535014548093,-0.047581028691657215},
{0.05871791140045583,0.8926613210974268,-0.018082837605701445},
{0.06899336827014642,0.9454921541146636,-0.014529183851445573},
{0.08999304396056483,0.9549649734192199,-0.02720659437122329},
{0.0955354144917106,0.973669958275223,-0.009246031791506761},
{0.08419672642137552,0.9677040371386038,-0.003962421343466775},
{0.0999457956070376,0.9764450398396557,0.008318483468806143},
{0.1125876810489753,0.9811212860536564,0.003449485058266875},
{0.11245337333533492,0.977785137453402,-0.01741702888876408},
{0.11253909191025216,0.9591890197714248,-0.034183032076853345},
{0.11297135188964762,0.9100919870322005,-0.05386827988719066},
{0.11339536088322215,0.8619940111594582,-0.07317787864862604},
{0.11397201311448354,0.8087536083738337,-0.08171168992795284},
{0.08197423171289317,0.7593567898164498,-0.06695732292181159},
{0.11467288852115973,0.759630676706894,-0.06945783001364848},
{0.05620365266558408,0.7643050893684901,-0.05177688417564058},
{0.08687829681317129,0.9642228087043315,-0.024355649576048313},
{0.10078991729532683,0.9805224019994886,-0.006165663751700312},
{0.1124178482574949,0.9797385583465021,-0.018816946149711824},
{0.10050388312020193,0.9614495606923035,-0.03171552892830007},
{0.10717847226121702,0.9568739306665076,-0.03203525462886034},
{0.11263329066504088,0.9722189307409959,-0.022123528717441523},
{0.0862647443397664,0.9071573864085635,-0.054096786355619784},
{0.06779720452016504,0.9045477829486501,-0.043384485625522114},
{0.07956081836027698,0.854763397251734,-0.06982889518153887},
{0.09481414081453271,0.9058287484973465,-0.05424942959330658},
{0.05798036494568672,0.8478818458830444,-0.06215387400973844},
{0.07921633970225397,0.8082441099993926,-0.07824581749506944},
{0.08614052116435159,0.8552651030284555,-0.06894374775819567},
{0.05609593146181109,0.8031851097209217,-0.07219051067872376},
{0.07412181434594318,0.7729887935568968,-0.07238578400981865},
{0.06155487535854541,0.7719338133420732,-0.06848123416412354},
{0.05141739330730451,0.7691550646728311,-0.05776343277681197},
{0.03948555103406623,0.7989876498785844,-0.05131230783511322},
{0.045802139068074045,0.8436470274104624,-0.034233913156082284},
{0.05512735740405648,0.8976485836380658,-0.026067041551735382},
{0.0693882696192972,0.9646715706553689,-0.012440996856603565},
{0.08661449446095275,0.9797160973295453,0.004253039399603285},
{0.1129055731971309,0.9732564922079752,0.0013557974062109208},
{0.10589108927910446,0.9997712643375201,0.04589186853887647},
{0.10521129972508171,0.997020018954348,0.04997473135592346},
{0.1131437058156844,0.9903458882014339,0.04775727891655388},
{0.11307380163025725,0.9901432806607205,0.04274388825414871},
{0.11327847191742593,0.9885567994425998,0.016975601147345424},
{0.10585487661911269,0.9965435245231904,0.018108507339366472},
{0.10584089578202727,0.9897204176373987,-0.005961681046683356},
{0.11286729779068391,0.9812177767489512,-0.0021591225534967682},
{0.11273642798780226,0.9770022105766175,-0.012612434006438075},
{0.09732152372788704,0.9756096275252888,-0.015150299728519634},
{0.09296775354305349,0.984185152121821,-0.008240557491608607},
{0.07514608255798894,0.9684406668171706,-0.01639023954216193},
{0.08166000666954686,0.9633624142384509,-0.020875796306079455},
{0.07186539891797486,0.9448213031286131,-0.025115886241824946},
{0.062425125168600853,0.9474251767372621,-0.0219062527574909},
{0.0613614355798552,0.8993851869593168,-0.03426370838265778},
{0.045204171790108647,0.8988241199234949,-0.03304118731685962},
{0.05245289202782871,0.8484009704076101,-0.043857542145920976},
{0.038810116167004506,0.847401455153027,-0.04091423214836189},
{0.04365619517248568,0.8013749351094342,-0.05542198635607816},
{0.03148003204132825,0.801405188724111,-0.052204331079973784},
{0.04838607279432238,0.7724206215055068,-0.05356918165118269},
{0.030825912220970548,0.7711818276621175,-0.04707680178037938},
{0.015328956490947386,0.7577487643575747,-0.02422248783266081},
{0.021961144732605006,0.7957848922157678,-0.020055052410949525},
{0.01827616278736634,0.7565065326034266,-0.015389349123275423},
{0.023939318583168192,0.7685646607985349,0.00986898122098547},
{0.023621197240961993,0.7292835508575867,0.00904044472813577},
{0.040521508142691606,0.768728076156599,0.03105705442098135},
{0.04848531381822389,0.7304240204532769,0.034827754941137254},
{0.08445113181752024,0.9993119594601563,0.04559689579577895},
{0.08599521213628333,0.9957468460033712,0.049047183033222835},
{0.08629522714849365,0.992415510478179,0.015869281465191752},
{0.06215353021866255,0.9806386033831332,0.007664363648448409},
{0.06499370289346026,0.9852036904826025,0.04277047476401609},
{0.03830611844977725,0.9580148586502989,0.03436822086972267},
{0.04591788206361737,0.9600157227118696,0.003008057316848165},
{0.03515767977694832,0.8992444618122601,-0.007771855658170832},
{0.035114591295439125,0.8933566958468891,0.026138320901466033},
{0.023986761751638427,0.8374672682246513,-0.011276003497501193},
{0.035833343838060625,0.8914569063616246,0.042834878292229296},
{0.045256657227691656,0.9530862697866086,0.04084157763432778},
{0.06691159870872068,0.9792173710754813,0.047534731493439904},
{0.02377338209054767,0.8237548173724505,0.018686993123032517},
{0.033475395445684994,0.821670755870519,0.02846876600777198},
{0.10097854399895484,0.9891038856413363,0.09201144136700498},
{0.10019401276381665,0.9861259673421396,0.07794694845311204},
{0.0783465482802997,0.9894818266307442,0.07975895661700415},
{0.0795988645726734,0.984458580624164,0.09341112943390216},
{0.05874403952222205,0.9795728510479325,0.07936497204405568},
{0.05882127791726779,0.9722031163515058,0.09143272638928837},
{0.04131429036365071,0.9427881227059107,0.06711019535354902},
{0.04001361412660447,0.9338761412431257,0.08304399494397924},
{0.03116786974443715,0.8801723080872266,0.05692389496953438},
{0.03685807043820754,0.8854495011018503,0.03936213003782847},
{0.030129849889356547,0.8463274518320052,0.030502863206676882},
{0.030205483926048222,0.8422503188662227,0.0467034446719832},
{0.030604052380008292,0.8152216936752755,0.02784650416044501},
{0.032055996690437884,0.8117863040511193,0.044162141039142906},
{0.03503666531824165,0.7568269458861385,0.027685609936937267},
{0.03875900589372498,0.760875658789649,0.0511844175548891},
{0.035300009282359025,0.7217928017024533,0.0283871729257652},
{0.0423250361267122,0.7169712464603843,0.06512377051716492},
{0.03217792792534689,0.6917305640580181,0.027108499317574718},
{0.047127339068532434,0.6776206907221102,0.08060399508149568},
{0.07380598494424279,0.7061344933608212,0.10461848931325439},
{0.06329331223220104,0.7338154048197216,0.08441572133670554},
{0.05210360029474353,0.7676320702067214,0.0676533852534256},
{0.04456219925443173,0.8099169973745821,0.06127147691500224},
{0.041962909526794476,0.8388133248837125,0.06246443194827549},
{0.04191684152262773,0.8746468979158237,0.07321913357773058},
{0.042249402090020524,0.923244058430731,0.0991985084051188},
{0.061432256541484674,0.9607305789556312,0.10254588751385192},
{0.07991102686956449,0.9768392536066548,0.10456554548757023},
{0.10011746195092265,0.9823774986448899,0.10553068163456614},
{0.10819678142794766,0.9859749284628067,0.0914829198863656},
{0.10764075666123855,0.978727125001289,0.1045107681094814},
{0.11285354614764907,0.981098137454548,0.0913321102010834},
{0.11302154538672482,0.9731535840792644,0.09984139771699806},
{0.1127586598107086,0.979692719536386,0.07798820338221661},
{0.10696807212278381,0.9823486201945167,0.07721513184960743},
{0.06418052240199947,0.9653449427759755,0.10217000927089934},
{0.04749175760895596,0.9368879802618082,0.09844102206794915},
{0.05258169908425514,0.9298991660774468,0.11320753635877119},
{0.06514909645975407,0.9567057022333815,0.121306108136045},
{0.06211823433487311,0.9193842014248993,0.1235423544875622},
{0.05617339905090741,0.8922831509139685,0.10533288716891487},
{0.045582341973567024,0.9000993556209267,0.09078456561424579},
{0.03928065155284696,0.8999652771013369,0.07706111344761711},
{0.046020331804227,0.8437148688494343,0.06252058449066777},
{0.04232343176835813,0.8419796406924868,0.08121319286793953},
{0.034199648645520435,0.7964639941876388,0.08718140594506449},
{0.03068816659657146,0.7976120271869982,0.07635359141347409},
{0.029736094510458673,0.7642218919281293,0.10746278748096257},
{0.041807745154551254,0.7969496563808196,0.0948002745744726},
{0.04987583412309781,0.8478201926834382,0.09271162919152943},
{0.07833669293612472,0.9431676680536727,0.13069114611922902},
{0.04754401385248839,0.8539204215336977,0.08045226862001116},
{0.12707824570289802,0.967869515243123,0.13752273318489197},
{0.14488318552227017,0.9635718976006818,0.13560850447444084},
{0.1450511847613459,0.9737394040725491,0.12176862173011711},
{0.12540581671580964,0.9763205874701901,0.12440160298318977},
{0.11662722619046252,0.963545081896764,0.13525004497933243},
{0.11642553542595138,0.9706125096404747,0.12128273034288574},
{0.11362638848620764,0.9564052288330697,0.12687116887819824},
{0.1134641190983964,0.9599132729712601,0.11259627582587212},
{0.16215868708480063,0.9655959102613614,0.11548045375838135},
{0.16389368604769752,0.9538471940345371,0.12452857648721152},
{0.17726968003364565,0.9458322780857255,0.11109459640646648},
{0.1743825225784789,0.955673641423616,0.1047429416827198},
{0.1885918661323389,0.9475345022993892,0.08851050224438274},
{0.19227799404783044,0.9382691036106083,0.09291034043338305},
{0.19388854064126199,0.9253196397527913,0.09206736471534671},
{0.1750471853251633,0.9325202292398892,0.1156924582551686},
{0.1622615952135114,0.9391090998059871,0.1318398667007402},
{0.19779240290480538,0.9358511063769805,0.05558952720705276},
{0.1913923882363861,0.9438605216685783,0.06413388141270628},
{0.14328226507896305,0.9524319207722003,0.14499973069699054},
{0.1281249749319007,0.9557114584419616,0.1476528810265143},
{0.11714428796857286,0.9528550129895726,0.14626900734910722},
{0.11384228928185479,0.9477251917494722,0.1400241570529312},
{0.19586740207397693,0.9267711256751197,0.06044500316860775},
{0.1269879432469692,0.9813633149710698,0.11459989021604977},
{0.1447933414544425,0.9781717878167315,0.1148960089294002},
{0.14352337722017408,0.9792996517396402,0.10157616748584439},
{0.12633359423256088,0.98347442137097,0.10093396575611689},
{0.11621169737675947,0.977578862807879,0.09971350743677394},
{0.11635104735951261,0.9753561389053463,0.11308698028816566},
{0.11335479353626936,0.96630962053487,0.10885468295013997},
{0.11323286230136036,0.9672580255161733,0.09569458975983901},
{0.179482319397953,0.9514142991876217,0.09546952120216862},
{0.16310663367800293,0.9699533475510042,0.09968783770310889},
{0.16430531856254071,0.9635487490015734,0.1100515342822731},
{0.18054211268783882,0.9383543637974245,0.10620519972542551},
{0.16018624308550194,0.9523129690599491,0.1260359857578817},
{0.1898606843963544,0.9335926282025568,0.07569420012995302},
{0.19589215503143964,0.9218381821244682,0.08510032396579051},
{0.1748736854288736,0.9275744508224055,0.1158421219701979},
{0.196033567760648,0.9194082668002101,0.053982647718430525},
{0.20627670826920672,0.9044664190606939,0.06009135674856153},
{0.20231646426922045,0.8890643496676113,0.06659427954569155},
{0.1920932636430623,0.9053955717417487,0.09461989885666548},
{0.14321396525188995,0.9698366877792582,0.12532250467842354},
{0.1270152173389883,0.9743467683065882,0.12682853878479022},
{0.11658574206730739,0.9694828121651617,0.12621200678872777},
{0.11355052525546538,0.959826866814191,0.12279426510646635},
{0.20042721771028263,0.912832231100945,0.038949122358681816},
{0.20809169595575636,0.8959064796596008,0.040631406689945145},
{0.20589212065233206,0.8937981235883078,0.022401082712694954},
{0.20022071387070928,0.9065012038417506,0.019556326156885635},
{0.20044715759268317,0.9039287298180312,0.002696353408058223},
{0.20286675918466504,0.8937353244184486,0.007638464720732768},
{0.20216817571849466,0.8834825577597656,0.011380286790515495},
{0.20239186911186155,0.882416117842413,0.027094289286438707},
{0.2035777191295668,0.8838465179120879,0.04328845331832876},
{0.1743165146919116,0.8665547435719663,0.07415539127435329},
{0.1701628309132351,0.8333585064798886,0.08006011759946734},
{0.17002760642339243,0.829596973721756,0.07351364793272695},
{0.17427159265799774,0.8634521437092535,0.06652712568887137},
{0.18118889829857793,0.8967638946028238,0.08804500912765306},
{0.1838622177045528,0.9026743507792023,0.07565500794730372},
{0.16479556463673312,0.9212397564584017,0.1169839667301916},
{0.1707644652960098,0.9282964120817352,0.10580227658450443},
{0.17179515094147182,0.8672310952152302,0.08859140774423777},
{0.1681871781972283,0.8384369882526588,0.08565451518009495},
{0.17104591559012305,0.8904239287756567,0.09895052044239036},
{0.15536079154457305,0.9118173598449729,0.1333477343595115},
{0.12683507081523174,0.9390600522791629,0.1524304310108718},
{0.13775227102654866,0.9341051060996559,0.15209787044347903},
{0.14357632104585824,0.9471891068651639,0.1471064824099296},
{0.1270342404451865,0.9525151182125612,0.14933012308866483},
{0.12837112934222453,0.9611772781602131,0.13918301488729953},
{0.14473627213584786,0.9540869310114448,0.1359642136409423},
{0.16116100538262224,0.9406534093188008,0.13014428911454315},
{0.1574647929289051,0.9309740861746709,0.1418288310072047},
{0.1464029712716717,0.9215246446632738,0.14797856577238966},
{0.1642888165908989,0.8959502557232618,0.13121943840581785},
{0.17373940407254904,0.9064597197185954,0.1254391644501692},
{0.17659103644987578,0.8753207284245315,0.11000317433760054},
{0.18400729753857045,0.8854974026584217,0.10793011415009689},
{0.19431254963483655,0.8702275782325242,0.07989005561393639},
{0.18887698353126145,0.8618225740096238,0.07888572728429116},
{0.1974089612581836,0.8557819356125153,0.05578434215004647},
{0.20094084157763428,0.8591646106050378,0.047801054980214835},
{0.20056473414063114,0.8657555439175909,0.05112161838502996},
{0.1936753901742218,0.880140908502297,0.07621492901287269},
{0.18344600130869798,0.8982749709783032,0.09916596284993634},
{0.17615029629060885,0.9197082818124207,0.11596290723485399},
{0.1168247914620632,0.949706345122693,0.1466948498950864},
{0.11956388956055475,0.9396202025387825,0.1506415714460884},
{0.11623690872232335,0.9376154421783517,0.1470237433576699},
{0.11387048015007623,0.945571684450215,0.14024968399870277},
{0.11373708921263818,0.9532996494476997,0.13555143515584622},
{0.11686352525661135,0.9590998632857488,0.1404729190039685},
{0.12693110312242512,0.9385725565335775,0.14852931907593542},
{0.1378079651808398,0.9337709411739088,0.14773195297396471},
{0.1464029712716717,0.9215246446632738,0.14797856577238966},
{0.12046118426857871,0.939686668813451,0.1484935648040448},
{0.11765516150731756,0.9386582751084945,0.14545651443979815},
{0.11473614607912004,0.935598763727291,0.14064664809430874},
{0.11402106064130783,0.9346625060306682,0.14236308233910863},
{0.11401762273054912,0.9346615892544659,0.14195053304806313},
{0.11402106064130783,0.9346625060306682,0.14236308233910863},
{0.16739714630487618,0.896529199895029,0.12145852217968126},
{0.1558792284869869,0.8858994090231405,0.1322081815400236},
{0.16989261112760032,0.8633393802363677,0.10831928564798314},
{0.17816422441306265,0.8728749987107833,0.10458250584731321},
{0.18199016069940852,0.8555568670548448,0.07932486308520402},
{0.17790294319540048,0.8848441996142663,0.0923201657531374},
{0.1767189267300999,0.9053971761001027,0.11292333573605096},
{0.1676529268653244,0.9145647089292855,0.11930593165662604},
{0.1575232374118032,0.9150382238377855,0.13744182768503696},
{0.1512339234698145,0.9286619765924116,0.13580469458173802},
{0.16145414457331514,0.931146898488809,0.12433261557396492},
{0.13892505698337076,0.9432494903297299,0.1341799379571705},
{0.14791175570664533,0.9465040458479779,0.10995779391558555},
{0.1446567418002963,0.909368879802618,0.1434077488216561},
{0.13736814179777518,0.9242724521356874,0.14640766974970862},
{0.1257615258823111,0.9394785606155234,0.14267386947169622},
{0.18339603700567136,0.8694469432962458,0.05116608203084265},
{0.17975345595979014,0.9425332589216646,0.0744542603163107},
{0.1822557966040317,0.9343569903612443,0.09156015828141131},
{0.1866959729459342,0.870679319706219,0.06535754844875735},
{0.1818576865381728,0.9271431076192124,0.10309205693638603},
{0.1824201287382982,0.870478087329809,0.0841232697281644},
{0.17888870680694866,0.8265952192412988,0.08024713994474131},
{0.1871557362113994,0.8234151517894898,0.06766874125481452},
{0.17121712354590696,0.7919172426122162,0.07613975336428218},
{0.1828033411908693,0.827967633216177,0.05409861990802443},
{0.12060030505728128,0.9984458351430113,0.060746622539172124},
{0.140572962207047,0.9977646704246851,0.06086832458003056},
{0.1392910798821484,0.9958751946716965,0.038276896208328234},
{0.12013527032865276,0.9964642233816893,0.03816550789974595},
{0.11264635472592399,0.9905239719787354,0.05953166487704312},
{0.11243366264698498,0.9896567016913372,0.03620383602082459},
{0.16259346819875245,0.9843100628793877,0.057465709705107476},
{0.16107368244935094,0.9826204443385057,0.035362923049243496},
{0.1903926437877525,0.94129240233182,0.040079278222095914},
{0.18808924357941512,0.9420954982850555,0.01707323781289287},
{0.20218215655558008,0.876242317701917,0.011364701595076007},
{0.19974376105145056,0.8675661769171795,0.027687901877443064},
{0.184706339392842,0.9377460827871826,0.06425695861786819},
{0.15797474969144748,0.9769226802410661,0.07775900933163578},
{0.1393816115321278,0.987842172392889,0.08130028660716025},
{0.11951117492892116,0.9900511446523869,0.08124848875172896},
{0.11287554877650482,0.985326309299663,0.07930927788976454},
{0.19763219626344936,0.8848098205066791,-0.004157236286460489},
{0.20746668377982241,0.8463125542187175,-0.016634560400081107},
{0.21292539848250613,0.8361647584352004,-0.004006426601178288},
{0.21103913144622588,0.8258876972071558,0.009965471916280003},
{0.20904308045971737,0.7824904913118264,-0.0009171199933992092},
{0.2090740216565458,0.8045930487736398,-0.02914236732242901},
{0.21976088184702897,0.7413063831689055,-0.0023339976140899104},
{0.21795987499756478,0.7588761698923818,-0.030150133562832988},
{0.16770999618391902,0.8929904437540609,0.004391930994255244},
{0.1740914461342412,0.8840007655081288,0.03282574490931365},
{0.18376939411406756,0.7910822886859502,0.020696337364474692},
{0.16849498580715838,0.8123668525812405,-0.0026910819448948903},
{0.1828457420902268,0.7241390611982493,0.010486200799199673},
{0.16348801257816944,0.7477052518670719,-0.00907413625357113},
{0.16102234298202084,0.8956009639901766,-0.010031708996897861},
{0.17532015543940507,0.8811090241719505,0.009824746769223396},
{0.18377031089026988,0.8156016974111385,-0.007757874821085382},
{0.15731329566147118,0.8344448862796418,-0.019752745458233384},
{0.18032483672788815,0.749406788498584,-0.019384659813000565},
{0.1544488284173119,0.7707811964617022,-0.02942908907970566},
{0.12715319215743795,0.9940847307485591,0.08264221777331103},
{0.14344499285487544,0.9932380879257137,0.08256199985560775},
{0.14266779582935582,0.996301495605777,0.0690560528429803},
{0.1255861924336168,0.9975079730880345,0.06937715370784406},
{0.12574571149282104,0.9925741127611808,0.06557413682655626},
{0.14246770942319875,0.9911187305399926,0.0662051080478053},
{0.16152290278848938,0.9870493901719296,0.06711088293570075},
{0.16246214000776965,0.9815858623941838,0.08159205063354964},
{0.14205928562506373,0.9850984904133856,0.09504161590973421},
{0.12756436628417997,0.9864019169790388,0.09502190522138425},
{0.11675557485878778,0.990192786575646,0.08133306135639332},
{0.11567584168650147,0.9941209434085511,0.06920892527471771},
{0.11869020183974059,0.9904093749534448,0.06455926557058433},
{0.11532998786417499,0.9861520954639058,0.06375021057203398},
{0.11339948637613262,0.9853031607005542,0.06665822468580361},
{0.1127776829169068,0.9819115471400592,0.06268629178923774},
{0.1751920359651304,0.9714504430893982,0.0589843494842561},
{0.1775023119949852,0.9653378377604075,0.06994968044619498},
{0.160563496492758,0.9702735316396658,0.09285441708504132},
{0.19123768225224405,0.9544889373761636,0.04254815653495267},
{0.18941008889291247,0.9435412543561191,0.05054198663111103},
{0.18913093053930502,0.9310753899450276,0.060174554188922376},
{0.1786815153852236,0.9538375678844125,0.08550783098772322},
{0.20284544413796102,0.9233614057846284,0.015018513149435656},
{0.19899315053579836,0.9343670748994696,0.01081142715697389},
{0.18594582081838315,0.9528149040307209,0.037799026612867194},
{0.17154647539659162,0.9671803287330264,0.05412979029890343},
{0.16080919251498066,0.9823933130343799,0.06365119874218306},
{0.11806633563405959,0.9830011356565206,0.09280880746897571},
{0.11305179900140148,0.9788286579656965,0.09090443410269955},
{0.11288998800169142,0.9829030406028717,0.07750460393549104},
{0.19912677066728698,0.9127552218999497,0.01792767323345821},
{0.12645071239240765,0.9910909980598723,0.09783503299821342},
{0.14812651053203957,0.9927774078840461,0.0916250201977257},
{0.14120232906994196,0.9946739886526024,0.08106032043620212},
{0.12612823636324044,0.9928532711147882,0.08515601812008165},
{0.12703469883328763,0.9889356572082101,0.08444528736923047},
{0.1414255640752077,0.9910387418163399,0.08088727892801359},
{0.1556099254775544,0.9911776334109917,0.06537634236090499},
{0.1644155609008701,0.9885847611167708,0.07302798573954616},
{0.1746713070822107,0.9779040891656532,0.051131473729204936},
{0.16510520579906784,0.9824561122042393,0.046389219628636874},
{0.1556099254775544,0.9911776334109917,0.06537634236090499},
{0.15354992935093387,0.9833850356912436,0.09928583133839013},
{0.12644131543633386,0.9832729598005092,0.1071884422024173},
{0.11427913314226186,0.9841264784448722,0.09548121009874824},
{0.1145023681475276,0.9876741731538131,0.08360345762144705},
{0.11595981311517112,0.9850191892718846,0.0854040060828101},
{0.1717571047290754,0.9786860992662352,0.0792522085711699},
{0.1808579420895392,0.967786546996813,0.052988862315112024},
{0.18792834935590738,0.9635503533599274,0.024671937365849876},
{0.1830714982300489,0.9710035146907654,0.023464543107390025},
{0.19311890701941153,0.968837860106827,0.006025167798694267},
{0.19236187907034305,0.9741178034500578,0.003353452751073517},
{0.18796020732893812,0.9777748237211259,0.006935984955702538},
{0.17713812264861226,0.9746250098839935,0.02172198074082393},
{0.1150714569751198,0.97729901687212,0.10578600380691318},
{0.11305936240507065,0.980030093178841,0.09355827201437504},
{0.1129259714676326,0.9828709534357908,0.08177128038110387},
{0.11325532331831727,0.9695100862571807,0.10163048647583206},
{0.1129259714676326,0.9828709534357908,0.08177128038110387},
{0.11297914448736736,0.9789741961878151,0.08244854880057023},
{0.11296653881458542,0.9797578106467512,0.0820900893054618},
{0.15171637694628717,0.8570062902307181,-0.06660940635302989},
{0.1745830673727371,0.8457379647339114,-0.026943250407105945},
{0.17884791026594526,0.7967628632295962,-0.04365012153014528},
{0.14925643720140308,0.8073030392277076,-0.07302890251574849},
{0.17329889310733268,0.7657306763631029,-0.05275852229427825},
{0.14740546604891228,0.7601532391422182,-0.06750578428485154},
{0.11397201311448354,0.8087536083738337,-0.08171168992795284},
{0.11467265932710916,0.759630676706894,-0.06945783001364848},
{0.12960098461764127,0.9740845703127237,-0.009531836772581063},
{0.1411686375445066,0.9683978075297123,-0.00444006174487723},
{0.15672885083249005,0.9465601983903701,-0.015264667559759477},
{0.1352953108043221,0.9555164143049175,-0.027586598107086347},
{0.14340900938893425,0.9065921938798311,-0.04808983948394664},
{0.16822614118582707,0.8939945428896555,-0.01900098897232826},
{0.11339536088322215,0.8619940111594582,-0.07317787864862604},
{0.11245337333533492,0.977785137453402,-0.017417258082814694},
{0.11253932110430274,0.9591892489654752,-0.034183032076853345},
{0.11297226866584995,0.9100917578381499,-0.05386827988719066},
{0.1125876810489753,0.9811212860536564,0.003449255864216262},
{0.12541956835884452,0.9767551393900915,0.008104645419614207},
{0.13823082820416144,0.964848050074316,-0.024786305197089693},
{0.12455527759410416,0.9617422414948952,-0.03191744888686176},
{0.1124178482574949,0.9797385583465021,-0.018817175343762437},
{0.12423348914708868,0.980807748592462,-0.006362312247098675},
{0.11242609924331581,0.9732505331626601,0.0013599228991213927},
{0.1385970802969896,0.9803489021031989,0.0038171123153985203},
{0.15590214789204498,0.9657247173177879,-0.01316662522074249},
{0.1584372632855196,0.9056511231081462,-0.04414449309724819},
{0.17155999784557588,0.8990661488409083,-0.027043179013159162},
{0.18205868972053219,0.8453057047545158,-0.03537644549822775},
{0.16931435453798485,0.8492370703041289,-0.06308715218370362},
{0.18917333143866247,0.8008099717747525,-0.052567374456093836},
{0.17211785616468964,0.8045974034606008,-0.07316343942343942},
{0.17786443859490292,0.770694331916532,-0.058823684454798915},
{0.16748446923814747,0.7732232590706409,-0.06936913191607372},
{0.1548318116758325,0.7739711192576862,-0.07306236484713328},
{0.14878292229290307,0.8090909820162887,-0.07882888715974712},
{0.14744717936611798,0.8555896418040779,-0.07039821320318164},
{0.1408732064133079,0.8559311409394433,-0.06940259424745852},
{0.13121886542069136,0.9062717805971191,-0.05455494526273084},
{0.1397345703700223,0.907808297512213,-0.05454508991855586},
{0.11798978482116558,0.9570054880515412,-0.03212601547289037},
{0.11233006693612244,0.9722150344421356,-0.022121007582885138},
{0.11953867821499087,0.9999372008301406,0.04577727151358606},
{0.11254069626860623,0.9901368632273042,0.042748242941109744},
{0.11255009322468004,0.9903385539918155,0.04776232118566668},
{0.1203536922588563,0.997204290971015,0.0498475286578511},
{0.14097565615391752,1.0,0.045122922499177764},
{0.13957688486322267,0.9963989030772737,0.048597733500033796},
{0.1590292715181699,0.9803388175649735,0.0467621183489319},
{0.16072049441740588,0.9863691422298059,0.041967837198882},
{0.18119852444870232,0.9547410508318023,0.03970179562078929},
{0.18791757723553007,0.9598362637702648,0.03311361263684318},
{0.19215147893190984,0.8933599045635972,0.0415241175169575},
{0.19254362995245364,0.8952732164978461,0.024818392364171014},
{0.2054493177466099,0.8259665399605556,0.01716376946287228},
{0.19596618470977725,0.8236489297210823,0.027106436571119483},
{0.20647908661586958,0.7707869263129666,0.008338423351206664},
{0.1902553565514546,0.7705508564408684,0.02980152941189954},
{0.2077394247000136,0.7315250686722673,0.00749682279747381},
{0.1832906077424042,0.7320650498554357,0.03369759907772315},
{0.1630821099145908,0.9818673126882973,0.00681817921370396},
{0.13880197977820888,0.993054732685249,0.015428999694025954},
{0.14998894138705943,0.9693517131682294,-0.01701777285265229},
{0.16312336484369533,0.9486511357138192,-0.022750832833881265},
{0.17973466204764252,0.9616446048293479,0.0018859232452043944},
{0.11194272899064084,0.9885405266650089,0.016986602461773314},
{0.11918778212355162,0.9967057939110014,0.017996431448632454},
{0.1189643179242353,0.9898801658906536,-0.006071694190962165},
{0.11221180280602272,0.9812099841512312,-0.002153621896282823},
{0.11227001809487026,0.9769964807253533,-0.012608537707578164},
{0.12766956635339655,0.9759793175288755,-0.015404705124664348},
{0.13192822100723908,0.9846595838065233,-0.008567388207736911},
{0.14352635674283165,0.9641155458886598,-0.021394691636594475},
{0.15369684273735618,0.9458176096664882,-0.02580209322926395},
{0.1651487526686782,0.900648733760169,-0.03513395819271322},
{0.18133329055044387,0.900481422103245,-0.034182573688752174},
{0.19178866474984038,0.9011513563130927,-0.00908513756799902},
{0.1888442087820284,0.8492279025421057,-0.042172278292000105},
{0.20439983818900026,0.8396636348113675,-0.012788455037284128},
{0.20729180871922923,0.798041307643736,-0.021608988073887586},
{0.21200953905638512,0.7588649393839033,-0.017013647359741816},
{0.1971016120363547,0.8034214087870706,-0.05359301783244307},
{0.21477728641119928,0.7601768461294282,-0.025894687625698624},
{0.19857693413994354,0.7732239466527927,-0.048483136474743366},
{0.18088567456965948,0.7740334600394442,-0.05468008521434801},
{0.1848773181545753,0.8030941196828412,-0.05660600282137875},
{0.17513359148223226,0.8498943988411948,-0.04488616504492777},
{0.12548190914060248,0.9894022962951928,0.09180608349768456},
{0.14698879126495631,0.9852790953252433,0.09284616609922039},
{0.147889523883739,0.9903284694535898,0.0791758869523265},
{0.12610302501767653,0.986441338355739,0.07772967249316143},
{0.11833426347918857,0.9860982348620193,0.09139788889360011},
{0.11941170471096907,0.9825001174619509,0.07711084855659316},
{0.11370110574669699,0.9797041792389151,0.07798018159044628},
{0.11379576288958687,0.9811098263511274,0.09132408840931307},
{0.11928473120694728,0.9788687669245483,0.1044129022498834},
{0.11396376212866263,0.9731650437817935,0.09983360511927832},
{0.1858303070168904,0.9445474162381692,0.06589844640812813},
{0.16771824716973993,0.9808991970186437,0.07845140455844046},
{0.1680226168689113,0.9735324418448744,0.09051709615721795},
{0.18761435350661165,0.9356727934056285,0.08180634707084274},
{0.16587827733167698,0.9620021475482539,0.10167013704658254},
{0.14704952768836022,0.9776565595910259,0.10400241570529313},
{0.19732576381782277,0.882195174777653,0.055530853530104056},
{0.19121522123528711,0.8873286631225625,0.038067871234198504},
{0.198744016602817,0.8483801137490071,0.029089194302694302},
{0.19903944773401566,0.8443057311118317,0.045287942215595976},
{0.1869891121366271,0.8764128380755491,0.0720028007512981},
{0.18590914977029022,0.9249928090366629,0.09799386447526595},
{0.19028354741967604,0.718772482503899,0.06388314312137086},
{0.18670078602099643,0.6793199354131164,0.07943373025922992},
{0.20040338152902223,0.6937784128999579,0.025698268324350848},
{0.196572173779513,0.7237560779397287,0.027034928027338267},
{0.1925456926989089,0.7627479449888439,0.04989520102037191},
{0.19597099778483945,0.7587860966305036,0.026336344561167898},
{0.1978888936000999,0.8138052744426859,0.042771620734268975},
{0.1989828368035222,0.8172716052636704,0.02643466880886708},
{0.12673307946272327,0.9827015790324113,0.1053074466293004},
{0.1876349809711639,0.8405865992530565,0.06124305685273022},
{0.1857202938726116,0.8116354943658372,0.06008791883780282},
{0.17931844565178773,0.7691807344064963,0.06658694533607297},
{0.16923780372509087,0.73510507974234,0.08352736519665423},
{0.15974229420952685,0.7071807642017227,0.10389813241227883},
{0.1630126641172648,0.9665482115415249,0.10134124358399904},
{0.16257582025685774,0.9578917814451371,0.1204890313457243},
{0.1756543203651519,0.9313976367801445,0.11217570474305627},
{0.180324378339787,0.9385049442886558,0.09732713898212629},
{0.18299998968626768,0.9017722429961162,0.08963240712197593},
{0.17284783921578958,0.8937036956394684,0.10435468696103588},
{0.1665511910641823,0.9206555408234711,0.12266683321434341},
{0.1498805326011347,0.9440386054458799,0.1300911160948084},
{0.18907225686235632,0.9017885157737073,0.07580513005043416},
{0.17619132202566282,0.8452967661865433,0.060904766434072895},
{0.18031314783130856,0.8430206400702249,0.07945000303682118},
{0.1737412376249537,0.849443115755601,0.09123653628199119},
{0.16128270742348066,0.8018225510902187,0.0937991549615355},
{0.16771320490062716,0.7978194478027738,0.08613169719340426},
{0.15151697812228188,0.7721930318132801,0.10686367423274426},
{0.17119970479806282,0.7971034455887592,0.07525873143384944},
{0.1588223092904954,0.810458353722054,0.08944103008974093},
{0.08480592420781938,0.8243076334224515,-0.024120038092051207},
{0.06505948158597698,0.8278090309331749,-0.00012640051889533922},
{0.05098009105879627,0.8622041821038409,0.0051902138724283205},
{0.07441564111878782,0.8746182486595011,-0.024643517303577823},
{0.04371166013272625,0.9064333624027786,0.01266354427971762},
{0.0417114836533073,0.8978725062254832,0.04779555432300089},
{0.0456268056193797,0.8711042454759959,0.052076669993800305},
{0.05392133830990012,0.8329500826817536,0.0326242833388531},
{0.06092848801830799,0.813801378143826,0.029523058640443807},
{0.06113774218648829,0.778740876644324,0.03801699015496957},
{0.07057962029421637,0.9215005792879625,-0.014947921381856764},
{0.11301169004254984,0.9241129330764832,-0.028781845080865395},
{0.11346274393409292,0.8804138786165387,-0.03842220523639644},
{0.11416568208722434,0.823960633629872,-0.03654373079783594},
{0.11418264244696733,0.8223888208309887,-0.03679630264157601},
{0.10205713120098826,0.7841138727720904,-0.037659218242012855},
{0.06981892524033859,0.7801772357593141,-0.012501274891906354},
{0.07854090483519226,0.8203707672156245,-0.014173245490893556},
{0.06810753326465148,0.8172908575639193,0.0034996785553440706},
{0.057900605416084584,0.8588714714143448,0.010678723801687563},
{0.07614468103636964,0.871097598848529,-0.01769252013756228},
{0.10365851003239654,0.8200045151227963,-0.02641495812051712},
{0.1135885714678618,0.8741908017551678,-0.032435656635225046},
{0.11355694268888164,0.8767350849106658,-0.03252412553874925},
{0.06722696972231991,0.8156991048826353,0.021538625500359256},
{0.05842958528482515,0.8326296693990416,0.03000207420615776},
{0.06551282741802585,0.7721157934182343,0.01902001207852648},
{0.07118125467699106,0.7779100482109684,0.0052550757887427045},
{0.08463907093899653,0.7831384228928185,-0.022548225293167832},
{0.17709251303254667,0.8637395530486819,0.004132941717098934},
{0.16376717093177692,0.8290106953403702,-0.0009540202355427414},
{0.14371246231190327,0.825024781606719,-0.024613951271052883},
{0.1528646391396972,0.8755730710742209,-0.025301304228744805},
{0.11346274393409292,0.8804138786165387,-0.03842220523639644},
{0.11416568208722434,0.823960633629872,-0.03654373079783594},
{0.11418264244696733,0.8223888208309887,-0.03679630264157601},
{0.12722011682020753,0.7844200760236665,-0.03787030596259779},
{0.18301282455310022,0.872776216074983,0.05092451150153045},
{0.1753245101263661,0.8344276967258483,0.03160620336617302},
{0.18620297654313486,0.8996315705636913,0.04658403457163059},
{0.1834063507379475,0.9081339822580885,0.011492362681249514},
{0.15572039700993437,0.9225367655906386,-0.01566186084941606},
{0.11301169004254984,0.9241129330764832,-0.028781845080865395},
{0.16873449359001533,0.8151137432774519,0.028619117304953007},
{0.16952131676565935,0.7800603467935179,0.037108235744416566},
{0.1599618621099833,0.7812746168734951,-0.013257156870721952},
{0.17034801970610441,0.8602402182844137,0.009736048671648581},
{0.16103746978935918,0.8184219302035357,0.002720418783369216},
{0.15023738773788908,0.821243767354287,-0.014774192291516483},
{0.15133866515092997,0.8720129998865488,-0.01832280377665953},
{0.12493436455376487,0.8202632752059021,-0.026593500285919558},
{0.1449079384797329,0.7838716146606266,-0.023053598174698577},
{0.17078211323790451,0.833997499492908,0.02906008665827054},
{0.16225861569085387,0.8168558472559168,0.020741717786489703},
{0.16499106716187859,0.7733268547815035,0.018185974928462835},
{0.15895317909337706,0.7789787800688269,0.0045191336923276265},
{0.1135885714678618,0.8741908017551678,-0.032435656635225046},
{0.11355694268888164,0.8767350849106658,-0.03252412553874925},
{0.09281442272321493,0.8926205245564235,0.1180423848557739},
{0.08234300494027773,0.8970623052566801,0.11435648613433293},
{0.08179866907014825,0.8899343702836161,0.1200278929159557},
{0.08826698356564058,0.8871171170138765,0.12229141335949202},
{0.08261551666641835,0.8797407356899829,0.12307411104222556},
{0.07713181981222128,0.8875184357964435,0.11826997454800067},
{0.07376885550804868,0.8928196941863782,0.11104829920824914},
{0.07515547951406273,0.8801959150744364,0.11748338056640725},
{0.06997523558283471,0.8804404651264062,0.10948771691784424},
{0.07726223122700178,0.8725715457878143,0.11785261218189298},
{0.07326990005993421,0.8674082622163293,0.10990232895534496},
{0.08343098909838496,0.8696222767449401,0.11987043660320663},
{0.08361663627935542,0.862917663183299,0.11325383355698852},
{0.08934029930451062,0.8721738941100565,0.12325242401357746},
{0.09472704707531199,0.8668721773320207,0.11899651968834192},
{0.09112709612283881,0.8796522667864586,0.12432207264763821},
{0.09817939705921111,0.879904151048047,0.12153278105206945},
{0.0942558241073178,0.8777412467927157,0.1288461340120533},
{0.09394778730333715,0.879590842780903,0.12455195428037079},
{0.0992795285019991,0.8755414422952408,0.12464271512440078},
{0.0998176761327629,0.8756491634990138,0.1265429629977665},
{0.10153136004895581,0.8769693212303594,0.1279946781141455},
{0.09739784534673045,0.8800176021030844,0.13146467603993936},
{0.09256528879023355,0.8846514474177278,0.13414464207338106},
{0.09020069377039108,0.8801470967416627,0.13036798250791004},
{0.08204046879351104,0.8819813367284611,0.12954265473176846},
{0.0800806304669943,0.8876573273910955,0.13439583875281766},
{0.06965711424062851,0.8861753586600398,0.1295208812969633},
{0.0742160131007319,0.8819261009622712,0.1257797468093323},
{0.06872635720121975,0.8794730370389044,0.11953306296075167},
{0.06112605328990868,0.8833473332699229,0.12142460146019529},
{0.06245835830593506,0.8785617614937951,0.11348417357782226},
{0.0672595152775024,0.878492315696469,0.11247457378501367},
{0.06912034177416819,0.8791945662674487,0.11013037703567291},
{0.07244113437303393,0.882459206323922,0.11564020201163618},
{0.07680109279723314,0.8838121388045007,0.12077185680414108},
{0.08368676965883318,0.884445172772205,0.12355037627933253},
{0.09071179650318634,0.8829253870228035,0.12418776493399784},
{0.09592710712415323,0.8738387596934758,0.12372273020536932},
{0.09314606651440539,0.8738809313987826,0.12418180588868273},
{0.09337090587802518,0.8734051245497768,0.1262880992135206},
{0.09649023690643035,0.8735632684446776,0.1257274905657999},
{0.09754727986770917,0.8718839636360718,0.12665733082900635},
{0.09424596876314281,0.8710645949052453,0.1275605845823454},
{0.08969967557582137,0.8724947657808698,0.12544328994307966},
{0.08915556889974247,0.8734009990568664,0.12227445299974904},
{0.07155186145678029,0.8764052746718799,0.11332602968292148},
{0.06900964104773766,0.8753356260378192,0.11534431249233632},
{0.07237054260545502,0.8728238884375039,0.11833873276317491},
{0.07507847031306758,0.8737372267290684,0.11613571954899195},
{0.0794301777514459,0.8718223104364655,0.11988464663434265},
{0.07837313479016708,0.8707728308788559,0.12195976956830153},
{0.06991999981664473,0.8699734020304299,0.11908269665136033},
{0.06540418943805054,0.8734278147607843,0.11452746489606622},
{0.0672714333681326,0.8784499147971115,0.11384171629672836},
{0.06980884070211303,0.8788748405668885,0.11145695220043476},
{0.08455999899154615,0.8715323799624808,0.12448617558785408},
{0.08439658363348201,0.871528483663621,0.12216421066141964},
{0.08490241490311391,0.8676855870175321,0.12655213075978974},
{0.07663103081170217,0.8678093518048458,0.12348620194516989},
{0.08990801296779935,0.8694792596573777,0.12737860450618424},
{0.06401343993912603,0.8763312449935423,0.1111255376032949},
{0.0941719390848052,0.872895396981285,0.12129785715022408},
{0.09572266603103514,0.8721548710038584,0.1236166133599504},
{0.09777097326107606,0.8775533076712394,0.12530187721387126},
{0.09581686478582387,0.8800343332687769,0.12341033871442764},
{0.09510773839332674,0.8806247371430732,0.11941915351761297},
{0.09319969792224131,0.8725037043488424,0.11678181757757931},
{0.09824930124463827,0.871601138177655,0.12444239952419316},
{0.10032167384999018,0.8762294828350845,0.12466380097705425},
{0.13641927842837054,0.8931513379775686,0.11767682034509747},
{0.14117001270881008,0.8877611522960086,0.1218479228716181},
{0.14752900164217533,0.8907347159082444,0.11947668122430877},
{0.1467162795388157,0.8978459197156159,0.11381673414521506},
{0.15222312499212143,0.8884324616701598,0.11764037849105513},
{0.1470117106700144,0.8805248085370199,0.12253412985905711},
{0.13852694691751188,0.8802293774058212,0.12392465016393105},
{0.13142468167811297,0.8803089077413727,0.12125385189251256},
{0.13515023097030443,0.8673642569586177,0.11865754168753287},
{0.14047715909390418,0.8727966143454847,0.12282383113899129},
{0.14625605788524937,0.8636799625955308,0.11272852079305724},
{0.14638921962863682,0.8703887016500824,0.11934260270471898},
{0.15643250292508903,0.8684206123377448,0.10920512065347807},
{0.1524495687140953,0.8734869468258342,0.1172220993487451},
{0.15940171185036375,0.8815291368666651,0.10873779398434374},
{0.15436356823049585,0.8811601344452299,0.11681940540187456},
{0.15533466342280683,0.8938125628134944,0.11036461335536653},
{0.13552198372034654,0.8782436401515888,0.12850005099567624},
{0.1299748001141386,0.8760163323680442,0.12628993276592526},
{0.13048338171237747,0.8759212168370533,0.12438097551863747},
{0.1357129023644804,0.8800991951850913,0.12420174577108327},
{0.13954227656158497,0.8807473559601339,0.12995428724661165},
{0.1388601950670564,0.8835114362101387,0.123784154210925},
{0.14583434083218064,0.8852017423331724,0.12302918900831172},
{0.1476403899507576,0.8827798488006847,0.12899258901037447},
{0.15539975453317179,0.8829139273202745,0.12509904047910725},
{0.1526860969742947,0.8847360200223922,0.12013561411972867},
{0.1569910488263545,0.8834885168050807,0.11493130481318965},
{0.16084196726421374,0.8805944835283964,0.11876067901029426},
{0.16029740220003366,0.8803045530544117,0.10936601487698581},
{0.16221369365694,0.8796483704875988,0.11167835365329586},
{0.16702814388344103,0.8798349344447716,0.11260750633435056},
{0.1683764924830081,0.8846525933879807,0.12052547319976667},
{0.15991602329986715,0.8872743441325749,0.12876408254194538},
{0.14954270057057856,0.8885030534377387,0.13381345667029174},
{0.1371323011197275,0.8851939497354526,0.1337710557709343},
{0.13236964874865773,0.8804432154550131,0.13117153684924646},
{0.12825401118237767,0.8772947767821841,0.127770755526728},
{0.13386055604768607,0.8743005857053961,0.12340460886316314},
{0.1333377644183112,0.8740118012016642,0.12541853698561692},
{0.13646901353734656,0.873929978925607,0.12592666019575463},
{0.1366468681205973,0.874410598849675,0.12381715815420861},
{0.14061536310640446,0.8740273863971038,0.12184288060250531},
{0.14014666127296663,0.8731087766423757,0.12502019772570744},
{0.13567279340562874,0.8715688218165232,0.12721312640166488},
{0.13233779077562702,0.8723075142415452,0.1263657959966675},
{0.15798827214043176,0.8774575045580966,0.11260131809498489},
{0.15457534353323252,0.8747048840106207,0.11546922324990287},
{0.15734125733564205,0.8738582411877751,0.11762639765396968},
{0.16058939542047362,0.8764504258998443,0.11457651242289052},
{0.1598724764302568,0.8710684912041052,0.11832841903089879},
{0.1514518870119169,0.8716625621832107,0.12134713387109898},
{0.1503350244034365,0.872685455230953,0.11929011726713597},
{0.14529138012635465,0.872271530775604,0.12397690640746348},
{0.14541606168987062,0.8722713015815534,0.12165264954052321},
{0.16422601742103973,0.874630395944182,0.1136989284032165},
{0.16222561174757022,0.8796059695882413,0.11304549616501054},
{0.16548818905758841,0.877566600926173,0.11027476928753882},
{0.15329094007377753,0.8687426299788109,0.12284354182734125},
{0.14507754207716272,0.8684180912031885,0.12604744546041075},
{0.1400444407264076,0.8700896034140745,0.126958262617419},
{0.1596391568867655,0.8799683253822096,0.11070382055022614},
{0.13559715936893707,0.8733998530866135,0.12095062816359413},
{0.1338147172375699,0.880496846862849,0.12309175898412028},
{0.13195343235280294,0.8779692948730435,0.12501538465064524},
{0.13410396012940293,0.8726221976729928,0.12329482491293492},
{0.13160574497807181,0.8720072700352843,0.12416278278248453},
{0.12942542197489634,0.8765838168372824,0.12441970931318563},
{0.13444202135400965,0.8811035235147364,0.11908934327882716},
{0.13650270506278195,0.8730310798592289,0.11641877420145927},
{0.04030491976489271,0.8899964818713234,0.04791290167689827},
{0.031528391986000805,0.9023594381537042,0.034870843422646444},
{0.04206054619234192,0.8719022991601183,0.038289272687059596},
{0.04545972315650628,0.8826299558916049,0.0523973124705629},
{0.05264128953740616,0.8600566338498984,0.05723743243072897},
{0.05140387085832023,0.8515519302149953,0.04239711765561991},
{0.04285630793595857,0.8464736776362758,0.03713161353757579},
{0.03556037372381885,0.8580974831055334,0.022836551408798544},
{0.028455128961762385,0.8689528009231936,0.019076852203070507},
{0.027809260127225593,0.8818422159397585,0.019383743036798268},
{0.030128933113154222,0.8961987020740915,0.026049851997941832},
{0.06063809915622207,0.8379123630708794,0.049609854427398785},
{0.04285630793595857,0.8464736776362758,0.03713161353757579},
{0.0573168481692552,0.8447563266152737,0.034125733564208144},
{0.04285630793595857,0.8464736776362758,0.03713161353757579},
{0.06063809915622207,0.8379123630708794,0.049609854427398785},
{0.05446636176218135,0.8401717580215052,0.05031118822217613},
{0.07790076585191999,0.8184317855477107,0.006691664097783365},
{0.07847810566533311,0.7928523543385859,0.0003418429264413106},
{0.07588133707225225,0.7844187008593629,0.01601871598617043},
{0.0731410930035078,0.8160451878990125,0.028843039892370484},
{0.08057775236270415,0.7709762405987465,0.03184387759662536},
{0.07278744658346156,0.7573508834857664,0.00806224452025673},
{0.0731385718689514,0.7625854464069821,-0.009734673507345108},
{0.09432114441173332,0.7918640695924815,-0.016888736602175256},
{0.0970313640598517,0.8192706357728364,-0.00729238170435573},
{0.09683929944546496,0.8382994718223103,-0.002572130232643401},
{0.07770847204348266,0.8374606215971845,0.01141168637544508},
{0.06706424194640752,0.8348216812987967,0.030344490117725526},
{0.06063809915622207,0.8379123630708794,0.049609854427398785},
{0.07363019310744728,0.8220654280256192,0.053526322363724094},
{0.07890830289827333,0.8121853308931806,0.06070972229702862},
{0.07852073575874113,0.7922057979218974,0.04842881748475573},
{0.09400439823383061,0.7364405934750745,0.050353359927482993},
{0.07725512621143377,0.750492251522135,0.02546517797491013},
{0.116109706024251,0.7299076462573183,0.05928848998937686},
{0.11572695195978099,0.766852122852595,0.06730821901325085},
{0.09627158578217623,0.7758395091580211,0.06103563623695457},
{0.08530304610352922,0.8018055907304757,0.06938288355910859},
{0.09801231459633768,0.7949813378744314,0.07736135765387801},
{0.11556949564703195,0.7904563597338139,0.08276964966543397},
{0.1329178809176471,0.7954062636442082,0.0770686768512863},
{0.13484998676404356,0.7763086693795601,0.06071201423753442},
{0.137896434084364,0.7369748448069784,0.04998550347630076},
{0.15198338801521388,0.7930994255251121,0.04781274387679446},
{0.15016610838815841,0.771822883421592,0.03126057873789713},
{0.15387905200756793,0.7514253005020495,0.02482274705113205},
{0.15788605159387267,0.7583868405943918,0.007348763440798608},
{0.15426799431140364,0.7853726064978804,0.015361387449104622},
{0.1512043574372896,0.7937375017619291,-0.0002678132481036841},
{0.15710931295645425,0.7636076518725726,-0.010438757630729423},
{0.13510370457803653,0.7923605039060395,-0.017230694125641873},
{0.13940659368364114,0.7641439659509318,-0.028350501877672227},
{0.0573168481692552,0.8447563266152737,0.034125733564208144},
{0.09052019027690077,0.7635487490015733,-0.027940702915233716},
{0.09052019027690077,0.7635487490015733,-0.027940702915233716},
{0.11466692947584463,0.7923584411595843,-0.022110464656558422},
{0.11490047821338649,0.7641987433290205,-0.035130520281954486},
{0.11466692947584463,0.7923584411595843,-0.022110464656558422},
{0.09052019027690077,0.7635487490015733,-0.027940702915233716},
{0.09432114441173332,0.7918640695924815,-0.016888736602175256},
{0.11466692947584463,0.7923584411595843,-0.022110464656558422},
{0.0970313640598517,0.8192706357728364,-0.00729238170435573},
{0.11441000294514352,0.8194982254650633,-0.013347459326650803},
{0.0970313640598517,0.8192706357728364,-0.00729238170435573},
{0.11466692947584463,0.7923584411595843,-0.022110464656558422},
{0.09432114441173332,0.7918640695924815,-0.016888736602175256},
{0.1154697962350293,0.8373957596808701,0.1390326635901185},
{0.11296768478483832,0.8376547489580264,0.1387182093527216},
{0.11234313099700555,0.8354751135370028,0.13673843114380438},
{0.11547804722085021,0.8354281287566336,0.13718169243762768},
{0.11552457361311812,0.8310028500280189,0.13630158728339728},
{0.11113917464930442,0.831324867669085,0.13632588185275887},
{0.10675698440219886,0.831577439512825,0.13481778499993696},
{0.1083040442436195,0.8363568230495871,0.1358830789470367},
{0.10946835002057013,0.8391733887371751,0.13865563937691305},
{0.11265666845820013,0.8389297554614076,0.14216460029130562},
{0.11548675659477228,0.838370751172041,0.14248134646920835},
{0.11795907281838774,0.8377154853814304,0.1386764960355159},
{0.11860333729457048,0.8355512059617956,0.13668594570622136},
{0.11990080481490857,0.8314314429026051,0.13625253975657298},
{0.1206573743758759,0.8286247325591921,0.13784612599026153},
{0.11558828955917959,0.8273208476054378,0.13855158527794934},
{0.1104779498133787,0.8285007385778279,0.1379316153711282},
{0.10624656925155533,0.827368290773908,0.13559658638381064},
{0.09649000771237977,0.8293925326286379,0.12774554418116413},
{0.10133998301672081,0.8378165599577365,0.1318753917785802},
{0.10735495168016426,0.8395435371288631,0.1364938810918346},
{0.10726373244803308,0.8404823159600422,0.13921143494957156},
{0.1099519494672957,0.840724115683405,0.14184693733720058},
{0.11165738239766768,0.8411203921968593,0.1480021727595995},
{0.11551701020944896,0.84071426033923,0.14948574584900925},
{0.1193399669731373,0.8412139033694963,0.1479375400373357},
{0.11829667565489331,0.8389982844825312,0.1421171571228354},
{0.12141875701190545,0.8393189269592939,0.13855548157680922},
{0.12260483622366125,0.8365307813339781,0.13576298126453235},
{0.12424953273062934,0.8317903607858146,0.13467110080756525},
{0.12487523248871503,0.8275949636899324,0.1354405052353651},
{0.12095440986542869,0.8231529537956253,0.13599492564372015},
{0.11562037672626091,0.8246791569784431,0.13853622927656045},
{0.11028313487038499,0.823023000768946,0.13608454051749724},
{0.10649157769162625,0.822609076313597,0.13309195379906327},
{0.0998584726737663,0.8240898990743998,0.12922040789665182},
{0.09148991030490827,0.8241020463590805,0.12235421252935116},
{0.08982298197503387,0.8346369508940286,0.12535000796449325},
{0.09565115748725392,0.8422727798831796,0.1303473550433578},
{0.1030000355250778,0.8418579386516284,0.13381253989408942},
{0.10475107807151539,0.8405833905363483,0.13476942505526443},
{0.10454319906763858,0.8421868321142119,0.13807967472780341},
{0.10754564113024752,0.8415801554623245,0.14239516950618997},
{0.10918071148709119,0.8418290602012553,0.14564834986013434},
{0.11055129190956457,0.8447677863178027,0.1512892738330298},
{0.11550027904375657,0.8445965783620187,0.15312259704362594},
{0.12041190754770384,0.844887884000307,0.15120653478077015},
{0.12175911017701797,0.8419823910210937,0.14554292059686713},
{0.12095120114872053,0.8408579650089442,0.14175457213481651},
{0.12359999679128325,0.8406812563959464,0.13907437690732424},
{0.12348608734814459,0.8397399564302109,0.13635865660199192},
{0.12946323899324216,0.8381589758693043,0.1316397802945831},
{0.13444660523502128,0.8298545878346089,0.12742742283895792},
{0.13123353383992856,0.8244717363626675,0.12895729312658502},
{0.12470425372698171,0.8228307069605086,0.13293931056137645},
{0.1234436864487871,0.8214718154346148,0.12994924497749888},
{0.12024344992052692,0.8209859240473835,0.13150776452144855},
{0.11563573272764983,0.8216629632727993,0.1359749857613196},
{0.11097140460427925,0.8208731605744977,0.13158546130459545},
{0.10773472622197669,0.8212804384023799,0.13008103155658285},
{0.10200556253960756,0.8214252890423469,0.128139299560062},
{0.09672011853916293,0.8210558282328106,0.12478573221196324},
{0.09165034614031486,0.8193302262259875,0.12028756977526377},
{0.08452997457092006,0.8188246241504062,0.1144571023225379},
{0.08510777277243434,0.8274452999749031,0.11982207665853409},
{0.08251948435922497,0.8410014404846078,0.12274430080343975},
{0.08888901621891696,0.8465793360935936,0.12800453345832047},
{0.09762772697946304,0.8515588060365128,0.13211971263649938},
{0.10136634033253762,0.8446385208732751,0.1330321341518617},
{0.1027657992053842,0.8458067229490855,0.13712737344764003},
{0.09599196904046761,0.8191356404770445,0.1224839363619799},
{0.09681775520471037,0.8180776807395633,0.12163339724027443},
{0.0985428988234323,0.8189518268484786,0.12191553511653944},
{0.099259359425548,0.8199600514769836,0.12391410723760432},
{0.09995840127981954,0.8194693470146901,0.12056993684557936},
{0.10189829972393574,0.81974552584564,0.12234321121492328},
{0.10102277845071694,0.819511518719997,0.11935291643699511},
{0.10269910373666517,0.8197856348044916,0.1220046916022154},
{0.10459041304205823,0.8206904929161848,0.1254403104204221},
{0.09984838813554076,0.8148570459408013,0.12237667354630807},
{0.10052153106209666,0.8168077165052949,0.12354877192097848},
{0.10114723082018233,0.8182149679758611,0.12435163868016312},
{0.10480631383770536,0.8163211375359117,0.12899671450328493},
{0.10458766271345125,0.8131215885898033,0.12654090025131126},
{0.10471669896392827,0.8114587857528393,0.12401426503770815},
{0.09735338170091777,0.8111651881740453,0.11943611387735596},
{0.09315225475377106,0.8155336267781159,0.11906298596301036},
{0.11092464901796076,0.8103059396784177,0.12773752238939381},
{0.10966568609812023,0.8059040387429622,0.12488199371320718},
{0.11574987136483907,0.8055387034263364,0.12616983508342092},
{0.11571434628699906,0.8101874463542674,0.1286824894599386},
{0.12048295770338388,0.8104221410620622,0.1276575336657411},
{0.1218005943001731,0.8060516397115363,0.1247802315547493},
{0.11583123525279529,0.7984453767549101,0.12558584864254094},
{0.10780508879550502,0.7989551043234019,0.123913190461402},
{0.10336674600600715,0.8076780006944578,0.1211339834040588},
{0.11035235147366042,0.811076719270521,0.1299813321445802},
{0.11572099291446589,0.8113045381567984,0.1310945276482513},
{0.1210738199657813,0.8112071306853016,0.1298914880767525},
{0.12659762577883002,0.8117251092396142,0.12383090979724348},
{0.1279908964123109,0.8079777865126176,0.12092747956448546},
{0.12381337645237402,0.7991499192663956,0.1237791119418122},
{0.11589288845240152,0.7912991062577998,0.1225595703986716},
{0.1072013916662751,0.7920650727748408,0.12003156002076497},
{0.1001286924594011,0.8021961373926655,0.11835890183962605},
{0.09375503510679867,0.8064481454190411,0.11421346904677047},
{0.10295052961015234,0.8492180471979307,0.13581867541882348},
{0.10186896288546139,0.8486837958660268,0.13341718015683748},
{0.1043873471132436,0.850815071342378,0.1395863964163218},
{0.10431813050996819,0.847906140452406,0.1421089061370145},
{0.10530435250961752,0.8437526858677802,0.14308527279248884},
{0.10779042037626783,0.844574575733163,0.14699371893704383},
{0.10740033210217925,0.8493065161014549,0.14624196245113869},
{0.11061019478056384,0.8499464258906766,0.15128858625087807},
{0.11542785372377302,0.8508428038224982,0.15356081606833646},
{0.12022694794888511,0.8500635440505234,0.15120790994507366},
{0.12336644805374139,0.8495008726563474,0.1461081131255995},
{0.12310447925392749,0.8447611396903358,0.14686537026871857},
{0.12554379153425932,0.8439990694721545,0.14291544000100845},
{0.12334490381298681,0.8417724492707618,0.14226269534495425},
{0.12625887697207153,0.8424510928545316,0.13789746545759163},
{0.12603472519060346,0.8408426090075553,0.13459088288986193},
{0.12773786618046964,0.8421590996340916,0.13360511927831376},
{0.13501523567451232,0.8427520246429442,0.13001754480457195},
{0.14094288140468444,0.8352594419354061,0.12492141508990708},
{0.13948291530248455,0.8246864911880617,0.1219517477765312},
{0.13436982522807672,0.8215142163339723,0.12447013200431342},
{0.1291343455306587,0.8217555576692339,0.12791193906188583},
{0.1265231377123912,0.8209575039851115,0.12525649679185627},
{0.1318441067906759,0.8203565571844885,0.12364090792931198},
{0.12918522660988765,0.8200776280249317,0.12211447555244362},
{0.12760057894417173,0.8199744907021703,0.11964582643363743},
{0.12476246901582924,0.8207787326256584,0.12160268523749661},
{0.08857295762316598,0.8963204041149498,0.134491871060011},
{0.07882946014487353,0.8997516682461956,0.12950896320633307},
{0.08164304630980386,0.8923688694888856,0.12925409942208718},
{0.09035494136643198,0.8898465889622436,0.13175116860316538},
{0.08370281324237382,0.8845849811430594,0.12700524739778804},
{0.07503492344345722,0.8849714023123386,0.12326823840306754},
{0.07288806277166655,0.892799066721826,0.12352516493376864},
{0.06943158729485698,0.9001999718091317,0.12243145092439689},
{0.07639771126821086,0.9052777659997501,0.12595278831752085},
{0.08676324139977971,0.9022285683508227,0.13279858541431983},
{0.10032648692505236,0.898380629435621,0.13770654681345781},
{0.10085340404733771,0.8887056609784522,0.13541002242663783},
{0.09862563787569198,0.8859491441321166,0.13152793359789966},
{0.09131663960266917,0.8834422196068633,0.12870128337208622},
{0.08369891694351395,0.8844011675144936,0.1249177479850978},
{0.07681301088786334,0.8837683627408399,0.12213899931585576},
{0.07182208124241507,0.8822139686898006,0.11789936776821147},
{0.0701116060429303,0.8847176844983456,0.1185291930192076},
{0.0673729663325399,0.8914371956732746,0.11652695379333343},
{0.06358255512403407,0.8985483994806461,0.11353963853806283},
{0.06801035498720522,0.9056089514028394,0.11930845279118245},
{0.06865920334439957,0.9247106711603977,0.12020620588730757},
{0.08671992372421994,0.9264387943017773,0.1321889292397748},
{0.11459427496181052,0.9086888610545447,0.13814728697272474},
{0.11475608596152059,0.8968230266678737,0.14019559420276567},
{0.10701734884365868,0.8896650672741836,0.136833775868846},
{0.10960724161522212,0.8797783235142781,0.13528602844527363},
{0.10727198343385398,0.8790799692421583,0.13354071575010054},
{0.10553354656019835,0.8778200895461155,0.13037439994132632},
{0.10319370449781862,0.8765448538486837,0.12795204802073748},
{0.09596056945553805,0.8813666382848033,0.1281681780104352},
{0.09073356993799152,0.8821701926261397,0.12570021647378077},
{0.08896831736041792,0.8820005890287098,0.11566908046200935},
{0.08349424665634526,0.883519458001909,0.11653887188396363},
{0.07767546810019903,0.88332647661132,0.11494666081457858},
{0.07370743150249304,0.8824090128268449,0.11311998423144931},
{0.07034882188528147,0.8794469089171382,0.10959864683832536},
{0.06847538971583372,0.879837455579328,0.11361343902234984},
{0.10339562445638033,0.8513247989108698,0.13586428503488907},
{0.10440866215994762,0.8574892020952919,0.13562775677468963},
{0.10622571259295248,0.8541127153421351,0.1395616434588591},
{0.11557087081133545,0.8206050035353182,0.12672265113342188},
{0.11097140460427925,0.8208731605744977,0.13158546130459545},
{0.11312628706784025,0.8209756103151074,0.12645013940728125},
{0.10773472622197669,0.8212804384023799,0.13008103155658285},
{0.11080432214140581,0.8215126119756182,0.12447723701988142},
{0.11557087081133545,0.8206050035353182,0.12672265113342188},
{0.11562083511436207,0.8202142276790778,0.13209610564928953},
{0.05990399061221167,0.8729210667149501,0.09960968253186084},
{0.06406890489936659,0.8748236065288215,0.10706238547459786},
{0.06270611707461295,0.8805250377310705,0.10685794438147975},
{0.058554496042391706,0.8826001606650293,0.09923632542346467},
{0.05951390233812308,0.8936402088874577,0.1055584141146864},
{0.06373130206286103,0.8881058601480821,0.11096097627497785},
{0.06614104831066793,0.8802866759184664,0.11152685638586192},
{0.06779628774396272,0.8770309744299656,0.11147184981372255},
{0.06558960742497043,0.871043509052592,0.1091987032200618},
{0.061935337482509595,0.8648098892648943,0.1029192446222481},
{0.05781351167686386,0.8585363897123958,0.09271346274393409},
{0.05655798666778205,0.871470497568824,0.0915459482502753},
{0.055991189780695644,0.8846642822845603,0.09190922082044595},
{0.0572295252359839,0.8973728631952171,0.09862598166676788},
{0.06219043046080607,0.9032567328617283,0.10851157945642047},
{0.0669031185288492,0.8826851916577948,0.11401544538706863},
{0.06847538971583372,0.879837455579328,0.11361343902234984},
{0.06943319165321103,0.8787666609750142,0.11273241709191713},
{0.10629332483787382,0.8205538932620386,0.12175739122163866},
{0.10773472622197669,0.8212804384023799,0.13008103155658285},
{0.10459041304205823,0.8206904929161848,0.1254403104204221},
{0.10773472622197669,0.8212804384023799,0.13008103155658285},
{0.10629332483787382,0.8205538932620386,0.12175739122163866},
{0.11080432214140581,0.8215126119756182,0.12447723701988142},
{0.1097665314803758,0.8145458004201126,0.1321398817129505},
{0.11032324382923665,0.8180089225243891,0.13134366158123267},
{0.10583631190101564,0.8192731569073929,0.12919496735703734},
{0.1018137271192714,0.8192516126666383,0.12404887333934583},
{0.10269910373666517,0.8197856348044916,0.1220046916022154},
{0.10744364977773903,0.8211385672850703,0.12757662816588608},
{0.11168488568373738,0.8207237260535191,0.12921146932867916},
{0.11563871225030738,0.8176186050562498,0.1304633272329517},
{0.11569119768789037,0.8142281374660075,0.1317871520691066},
{0.11340223670473959,0.8208264049881793,0.12531608724500728},
{0.10910003518128672,0.8210737053687559,0.12390173075887297},
{0.10744364977773903,0.8211385672850703,0.12757662816588608},
{0.11559814490335457,0.8199435495053419,0.12899854805568955},
{0.11949421456917818,0.82081884158451,0.1291461490242636},
{0.12095693099998507,0.8181381879689166,0.13125450509555672},
{0.12161105082034278,0.814689963477928,0.1320404114949984},
{0.10269910373666517,0.8197856348044916,0.1220046916022154},
{0.10744364977773903,0.8211385672850703,0.12757662816588608},
{0.10910003518128672,0.8210737053687559,0.12390173075887297},
{0.10344535956535637,0.8195073932270865,0.11984293331713695},
{0.0985428988234323,0.8189518268484786,0.12191553511653944},
{0.09995840127981954,0.8194693470146901,0.12056993684557936},
{0.05446636176218135,0.8401717580215052,0.05031118822217613},
{0.06063809915622207,0.8379123630708794,0.049609854427398785},
{0.058502468992909853,0.8395485793979759,0.05387790603731508},
{0.06338682340483803,0.8286274828877991,0.061927430287764595},
{0.07363019310744728,0.8220654280256192,0.053526322363724094},
{0.06968690946720402,0.8184253681142943,0.06827816823530895},
{0.07890830289827333,0.8121853308931806,0.06070972229702862},
{0.07701263890591925,0.81048837814268,0.07506002019199585},
{0.08530304610352922,0.8018055907304757,0.06938288355910859},
{0.08344336557711632,0.8039485551034066,0.0815473577936864},
{0.09328289536260215,0.7940338496693302,0.09139513856499314},
{0.09801231459633768,0.7949813378744314,0.07736135765387801},
{0.10644688485176299,0.7866762622575842,0.0995264850915},
{0.11568684300092934,0.7877138237245637,0.09278336692936125},
{0.11556949564703195,0.7904563597338139,0.08276964966543397},
{0.1329178809176471,0.7954062636442082,0.0770686768512863},
{0.1250608796696855,0.786902705979558,0.09937040394305444},
{0.13790376829398257,0.7945770395692068,0.09102086468039462},
{0.1453218629350819,0.8025362613637275,0.06887957342403306},
{0.14733235314677698,0.8047264397110779,0.08101173129747898},
{0.15349240164423808,0.81141959357019,0.07441873523847069},
{0.1513157457458719,0.8130668112117144,0.060102587257039986},
{0.16050826072656801,0.8195310002142964,0.0675167855992794},
{0.1562305829665273,0.8230709023255173,0.05283369794286879},
{0.1664508040700279,0.8298820911206787,0.06106313952302427},
{0.16876566398089435,0.8392283953093145,0.048703162763300986},
{0.1709320061469844,0.8409175554620952,0.05293523090727612},
{0.1748915625648189,0.8416379123630707,0.049301588429367556},
{0.177542879341938,0.853087530353887,0.041339387112189346},
{0.18612207104327982,0.848217844361196,0.035930178324431065},
{0.09348527370926502,0.8620893558844998,0.127032063101706},
{0.0934699177078761,0.8684829531195029,0.1265704662838362},
{0.08414538695404541,0.8648639790608315,0.12269181536585673},
{0.08444173486144643,0.8569774117803449,0.12424781377525003},
{0.07439409687803322,0.8551860310810051,0.11812420713183128},
{0.07731288311218014,0.8648502274177966,0.11877511823548083},
{0.0840990897558281,0.8700847903390122,0.1237470247747309},
{0.09195265309303098,0.8724516772993606,0.12603369381737586},
{0.09886033258348677,0.8728619346499003,0.1251581725441571},
{0.10192259429329731,0.8701464435386186,0.12708546531549134},
{0.09546528111223285,0.8574353414934054,0.12884842595255913},
{0.0857002393931858,0.8518590502427738,0.12578662263084975},
{0.07748775817277333,0.847490611638703,0.12034074279499853},
{0.0683656057656055,0.8507025370635428,0.11061947713961241},
{0.06576608684391767,0.8601648134417725,0.1091666160529805},
{0.0697911927602183,0.8670562201546371,0.11346744241212985},
{0.07294604886646348,0.8722550288039622,0.11689343508021219},
{0.07895757961914822,0.870398786188308,0.12128410550718924},
{0.07940840431664072,0.8720542548156535,0.12013400976137462},
{0.08426067156148757,0.8721482243763915,0.12195495649323934},
{0.08928391756806774,0.8736505913779489,0.12308442477450168},
{0.09300282023279237,0.8744692725266237,0.12424827216335117},
{0.09689293085330089,0.8745630128933112,0.12356802422122726},
{0.0991660774469616,0.8748937399082993,0.12596608157245454},
{0.10554202674006985,0.8706790905121684,0.13090773449702792},
{0.10337774732043503,0.863257787154361,0.13247152550414096},
{0.07245121891125947,0.8425221430102117,0.11298728087616301},
{0.06178819490203671,0.8452238824784586,0.09560451649796074},
{0.06903462319925097,0.8753381471723756,0.11319974376105145},
{0.07415206796061984,0.8735861878497357,0.11697732010272477},
{0.07578209604835075,0.8741646736334017,0.1154628058164866},
{0.08039416792818889,0.8729066274897636,0.11683842850807279},
{0.0840404160788794,0.8729426109557047,0.11790257648491959},
{0.08868503351390002,0.874518320053448,0.11938156569331773},
{0.09181559505078364,0.875306747587446,0.1210021968249748},
{0.09527275810974495,0.8751481453044441,0.12136569858919602},
{0.09207641788034464,0.8784322668552169,0.1177891254298821},
{0.09395970539396735,0.8795472959112925,0.1259069495074047},
{0.11073075085116937,0.8523708405577207,0.148271475769032},
{0.11535932470264934,0.8540822325334078,0.15008669264963218},
{0.11528094033735069,0.8581609698575443,0.1466590956231958},
{0.11124139519586347,0.856417949102877,0.14520096307340052},
{0.11514800778801379,0.8653574338517319,0.14125699185100551},
{0.11933652906237856,0.8565165025446269,0.14513312163442862},
{0.11999706631615253,0.8524836040306065,0.14819400817993567},
{0.10735655603851832,0.853362563214584,0.14284118112862026},
{0.11104222556590873,0.8638305430867624,0.1397053481285733},
{0.11502149267209319,0.8730858572373177,0.1374063026071969},
{0.1192631869661927,0.8639307008868663,0.13963658991339903},
{0.12325460135705796,0.8535560029932742,0.14270801938523278},
{0.07749577996454365,0.8336546251932392,0.11517860519376638},
{0.07699957484503614,0.8205447255000154,0.10531913552588003},
{0.06688684575125796,0.8340107927478417,0.09954275786909123},
{0.059727969581365586,0.8386746624831112,0.07817407975723767},
{0.056118621672818586,0.8521111636984126,0.07609964440543052},
{0.05368549763185244,0.8676163704142567,0.07517530479943803},
{0.05146139856501602,0.8854694409842507,0.07416753855903407},
{0.053730878053867455,0.9053994680406086,0.08439188515544513},
{0.05934957020385661,0.9178096382974091,0.10279570902898501},
{0.11484890955200583,0.8885798334446834,0.13930402934600622},
{0.11493073182806317,0.8803572676860453,0.13713447846320806},
{0.11038420944669115,0.8719648691359269,0.1359041647996901},
{0.1084880870662359,0.8704677735975328,0.13412057669807007},
{0.1083828869970193,0.8618374716229115,0.1381009897745074},
{0.11965900509154578,0.8720776326088125,0.13582646801654322},
{0.12156108651731615,0.870626834268636,0.13401102194189243},
{0.12194269461153324,0.8620024913393297,0.13798730952541932},
{0.12431164431833676,0.8543327416306926,0.13941014619142517},
{0.12622999852169833,0.8510809364410518,0.13940327036990774},
{0.1264122077919101,0.8481749850737373,0.1419237173441452},
{0.0571912498295369,0.8453125805760333,0.06213141299278153},
{0.05264128953740616,0.8600566338498984,0.05723743243072897},
{0.05140387085832023,0.8515519302149953,0.04239711765561991},
{0.04285630793595857,0.8464736776362758,0.03713161353757579},
{0.09872075340668303,0.7963668159101925,0.11382636029533945},
{0.09224854261233084,0.8011420739540441,0.1079003189235214},
{0.08460927571242104,0.8086981434135931,0.10394465880454674},
{0.08784778764712822,0.812387938433894,0.11252889277500135},
{0.0462726744539165,0.908256601075149,0.0632991566804909},
{0.04545972315650628,0.8826299558916049,0.0523973124705629},
{0.048168796834371745,0.9274362468099053,0.06828985713188858},
{0.055626312852170956,0.9335103475383983,0.09191105437285059},
{0.06723407473788792,0.9463154191443498,0.11455611415238882},
{0.08801578688620397,0.9527862547743985,0.12170948966506727},
{0.11391219346728194,0.956342888051312,0.12596562318435336},
{0.11433826520731172,0.928327582472614,0.13612419108824775},
{0.14192474871737276,0.9271107912580803,0.1317261864516521},
{0.1290995080349704,0.8987310671389591,0.13746520547819618},
{0.1226091909106223,0.8898550691421151,0.13670290606596433},
{0.12023496974065544,0.8799078181528562,0.13519687195959768},
{0.12255716386114045,0.8792663040052805,0.13341259627582586},
{0.12427245213568743,0.878048366820494,0.13021717282262787},
{0.12444663961412888,0.8709092013389516,0.13074913221402598},
{0.12681696448523583,0.863543133747334,0.1322748770087426},
{0.12597971861846408,0.8577518584772575,0.13544692266878136},
{0.12714631633592052,0.8516140418027027,0.1356651154049343},
{0.1276418338732763,0.8495185205982422,0.1356114839970984},
{0.12793130595915989,0.8461129262006616,0.13691628572705508},
{0.10661373812058583,0.7868243216142594,0.11194971940918358},
{0.10003747322726993,0.7903193016915666,0.10695993573398821},
{0.09247269439379889,0.7964681196805492,0.1002569265307011},
{0.08290269681179611,0.8063026071969223,0.09216225105228719},
{0.07501704630751192,0.8145432792855561,0.08661621341633212},
{0.06565721966989177,0.8258588187567827,0.08111120151543107},
{0.062048330149445954,0.8343433533152346,0.06934025346570055},
{0.1158367359100092,0.7843845509458264,0.10581465306323579},
{0.1250989258820819,0.7870493901719299,0.11179478423099094},
{0.13150352443151275,0.7907022849500871,0.10669613338176968},
{0.13880289655441122,0.7970321662390286,0.0998684426149666},
{0.14799357798270268,0.8070949310297802,0.09161654001785423},
{0.15558219299743414,0.8155242298220422,0.08594054935521983},
{0.16457026688501214,0.8270630042985343,0.08028174824637903},
{0.1677737121299805,0.8356302779092459,0.06845396007210444},
{0.17224070417580095,0.8467131854191328,0.06116673523388679},
{0.17634763236815895,0.8615624387622145,0.05620032935185069},
{0.11589334684050268,0.7856105099223833,0.1143544233878777},
{0.12451929412816298,0.7922759313013752,0.1198864801867473},
{0.13278746950286663,0.7967814279476932,0.11354078450831571},
{0.13904125836701528,0.8017118503637882,0.10750793870892698},
{0.1464270366469827,0.8094508166757006,0.10342645105618349},
{0.15376789289303625,0.821479378838284,0.10467555863184903},
{0.1634515707241271,0.8351863290332708,0.09873301528838913},
{0.17013578601526658,0.8400188855897678,0.07724859418099225},
{0.17338140296554178,0.85353858424543,0.07511640192843874},
{0.17542077162761005,0.8690983391453123,0.07415470369220156},
{0.1771924416385999,0.8869999988540297,0.07311347512041283},
{0.1828957063932534,0.8843030724608449,0.05124492478424245},
{0.18164201493657622,0.9099045062988254,0.06216418774201459},
{0.1746103414647562,0.9068708938453375,0.0833781598697261},
{0.17936336768570157,0.9290335001484031,0.06718995488315115},
{0.16900035868868912,0.9191444644479916,0.10187641169210529},
{0.17215727754138954,0.9349290587114938,0.09093400013522449},
{0.16062262855780784,0.9474524508292812,0.11377295808155412},
{0.1598186158283703,0.9258204287533102,0.11944207292267107},
{0.1398122671531692,0.9534167676075463,0.12127516693921658},
{0.10344306762485056,0.8196824974817303,0.11984843397435088},
{0.10629332483787382,0.8205538932620386,0.12175739122163866},
{0.1152486239762188,0.8203441807057571,0.12553313401090732},
{0.0706641928988807,0.8765395823855203,0.11390038997367706},
{0.07217137297550028,0.8770978990927353,0.11269849637243115},
{0.06943319165321103,0.8787666609750142,0.11273241709191713},
{0.07034882188528147,0.8794469089171382,0.10959864683832536},
{0.06847538971583372,0.879837455579328,0.11361343902234984},
{0.131314210145733,0.8025759119344779,0.11809739142791331},
{0.13751230485559052,0.806980792392591,0.11384652937179056},
{0.14324398967251606,0.8130622273307028,0.11206454562852458},
{0.14643597521495536,0.819578214188716,0.11393797779797232},
{0.15311812775963957,0.8345752976944223,0.11454465444985978},
{0.15790805422272844,0.8435626839998486,0.11227082027404733},
{0.16820895163203348,0.8465195164463919,0.09471226405904955},
{0.1718095901666584,0.8599241596886628,0.09175772355301201},
{0.17273003347379104,0.8728848540549583,0.09057187353530677},
{0.1729816885413288,0.8860884941148697,0.09092827028395996},
{0.17154716297874337,0.8987645294703439,0.09766749214723885},
{0.16661078151733333,0.9045278430662496,0.10763605818320167},
{0.1609173721068548,0.9067397948484052,0.11852942221325818},
{0.15265309303101107,0.906206231098653,0.12531356611045089},
{0.14248077348408186,0.9029067535464913,0.13233148793923605},
{0.14084409876888412,0.8969566467993623,0.13405365203530048},
{0.12876969779618458,0.8890455557554635,0.13517601530099482},
{0.13099860993808318,0.886343128705065,0.13125656784201195},
{0.12660175127174045,0.8768299712476062,0.12775585791344027},
{0.1280133574292678,0.8704641064927235,0.12686681419123721},
{0.13480666908848377,0.8579143570591193,0.12851838651972272},
{0.13284316365715776,0.8519876281051495,0.13182451069935125},
{0.1286954389237964,0.849010168194054,0.13319234079321768},
{0.12928996829100306,0.8449784156502864,0.13279789783216805},
{0.14163046355642697,0.847221537823321,0.12756241813475006},
{0.14804468825598222,0.8417992649746797,0.12219492266419749},
{0.14573853771903786,0.8281830756237228,0.1193137242543458},
{0.13940407254908474,0.8199114623382605,0.11988716776889906},
{0.13510599651854235,0.8196119057141514,0.12215595967559874},
{0.13255117043671777,0.8193657513038276,0.12163041771761689},
{0.04545972315650628,0.8826299558916049,0.0523973124705629},
{0.0462726744539165,0.908256601075149,0.0632991566804909},
{0.04160697116624244,0.9028755831556123,0.04311999569115186},
{0.0970313640598517,0.8192706357728364,-0.00729238170435573},
{0.11421793833075677,0.8385272907085877,-0.008627207854938474},
{0.11441000294514352,0.8194982254650633,-0.013347459326650803},
{0.11421793833075677,0.8385272907085877,-0.008627207854938474},
{0.0970313640598517,0.8192706357728364,-0.00729238170435573},
{0.09683929944546496,0.8382994718223103,-0.002572130232643401},
{0.08801578688620397,0.9527862547743985,0.12170948966506727},
{0.05886322042852409,0.959052649311329,0.07896663278414619},
{0.06723407473788792,0.9463154191443498,0.11455611415238882},
{0.05886322042852409,0.959052649311329,0.07896663278414619},
{0.08801578688620397,0.9527862547743985,0.12170948966506727},
{0.08753493776808538,0.9719035597273965,0.09212351725773903},
{0.11391219346728194,0.956342888051312,0.12596562318435336},
{0.08753493776808538,0.9719035597273965,0.09212351725773903},
{0.08801578688620397,0.9527862547743985,0.12170948966506727},
{0.08753493776808538,0.9719035597273965,0.09212351725773903},
{0.11391219346728194,0.956342888051312,0.12596562318435336},
{0.11344326243979355,0.9754175629109016,0.09774014666127298},
{0.06723407473788792,0.9463154191443498,0.11455611415238882},
{0.05886322042852409,0.959052649311329,0.07896663278414619},
{0.055626312852170956,0.9335103475383983,0.09191105437285059},
{0.055626312852170956,0.9335103475383983,0.09191105437285059},
{0.0430783969709714,0.9383575725141328,0.039767803507356564},
{0.048168796834371745,0.9274362468099053,0.06828985713188858},
{0.0430783969709714,0.9383575725141328,0.039767803507356564},
{0.055626312852170956,0.9335103475383983,0.09191105437285059},
{0.05886322042852409,0.959052649311329,0.07896663278414619},
{0.048168796834371745,0.9274362468099053,0.06828985713188858},
{0.04160697116624244,0.9028755831556123,0.04311999569115186},
{0.0462726744539165,0.908256601075149,0.0632991566804909},
{0.04160697116624244,0.9028755831556123,0.04311999569115186},
{0.048168796834371745,0.9274362468099053,0.06828985713188858},
{0.0430783969709714,0.9383575725141328,0.039767803507356564},
{0.08753493776808538,0.9719035597273965,0.09212351725773903},
{0.056342315066185485,0.9671656603137896,0.03211295141200726},
{0.05886322042852409,0.959052649311329,0.07896663278414619},
{0.056342315066185485,0.9671656603137896,0.03211295141200726},
{0.08753493776808538,0.9719035597273965,0.09212351725773903},
{0.08334847924017585,0.9803858023453424,0.029056877941562392},
{0.11344326243979355,0.9754175629109016,0.09774014666127298},
{0.08334847924017585,0.9803858023453424,0.029056877941562392},
{0.08753493776808538,0.9719035597273965,0.09212351725773903},
{0.08334847924017585,0.9803858023453424,0.029056877941562392},
{0.11344326243979355,0.9754175629109016,0.09774014666127298},
{0.11271900923995812,0.9867677106837661,0.027850171265254305},
{0.05886322042852409,0.959052649311329,0.07896663278414619},
{0.056342315066185485,0.9671656603137896,0.03211295141200726},
{0.0430783969709714,0.9383575725141328,0.039767803507356564},
{0.04160697116624244,0.9028755831556123,0.04311999569115186},
{0.04542740679537438,0.8770069090546546,0.040396482788099805},
{0.04545972315650628,0.8826299558916049,0.0523973124705629},
{0.04542740679537438,0.8770069090546546,0.040396482788099805},
{0.04160697116624244,0.9028755831556123,0.04311999569115186},
{0.04800377711795355,0.9018884443797607,0.01378269882870383},
{0.0430783969709714,0.9383575725141328,0.039767803507356564},
{0.04800377711795355,0.9018884443797607,0.01378269882870383},
{0.04160697116624244,0.9028755831556123,0.04311999569115186},
{0.08334847924017585,0.9803858023453424,0.029056877941562392},
{0.05718070690321018,0.9415245759050584,0.0009627296094648092},
{0.056342315066185485,0.9671656603137896,0.03211295141200726},
{0.05718070690321018,0.9415245759050584,0.0009627296094648092},
{0.08334847924017585,0.9803858023453424,0.029056877941562392},
{0.08136984700151151,0.9561565532881895,-0.011769916676502921},
{0.11271900923995812,0.9867677106837661,0.027850171265254305},
{0.08136984700151151,0.9561565532881895,-0.011769916676502921},
{0.08334847924017585,0.9803858023453424,0.029056877941562392},
{0.08136984700151151,0.9561565532881895,-0.011769916676502921},
{0.11271900923995812,0.9867677106837661,0.027850171265254305},
{0.1126976941932541,0.9576586910956966,-0.01695520287684373},
{0.056342315066185485,0.9671656603137896,0.03211295141200726},
{0.05718070690321018,0.9415245759050584,0.0009627296094648092},
{0.0430783969709714,0.9383575725141328,0.039767803507356564},
{0.04800377711795355,0.9018884443797607,0.01378269882870383},
{0.05254525723021279,0.8647003345087168,0.026079188836416183},
{0.04542740679537438,0.8770069090546546,0.040396482788099805},
{0.05254525723021279,0.8647003345087168,0.026079188836416183},
{0.04800377711795355,0.9018884443797607,0.01378269882870383},
{0.06230571506824824,0.8705638059047262,0.011900328091283427},
{0.05718070690321018,0.9415245759050584,0.0009627296094648092},
{0.08353779352595563,0.9128308559366416,-0.020882672127596924},
{0.06224520783889489,0.9078170068861351,-0.004929849430968487},
{0.08353779352595563,0.9128308559366416,-0.020882672127596924},
{0.05718070690321018,0.9415245759050584,0.0009627296094648092},
{0.08136984700151151,0.9561565532881895,-0.011769916676502921},
{0.1126976941932541,0.9576586910956966,-0.01695520287684373},
{0.08353779352595563,0.9128308559366416,-0.020882672127596924},
{0.08136984700151151,0.9561565532881895,-0.011769916676502921},
{0.08353779352595563,0.9128308559366416,-0.020882672127596924},
{0.1126976941932541,0.9576586910956966,-0.01695520287684373},
{0.1131975664175709,0.908460583780166,-0.02877703200580319},
{0.06224520783889489,0.9078170068861351,-0.004929849430968487},
{0.08353779352595563,0.9128308559366416,-0.020882672127596924},
{0.07992844561740864,0.870999732988931,-0.006569045280722578},
{0.06230571506824824,0.8705638059047262,0.011900328091283427},
{0.06706424194640752,0.8348216812987967,0.030344490117725526},
{0.0573168481692552,0.8447563266152737,0.034125733564208144},
{0.08353779352595563,0.9128308559366416,-0.020882672127596924},
{0.11379988838249733,0.8702667704151734,-0.012410972435977503},
{0.07992844561740864,0.870999732988931,-0.006569045280722578},
{0.11379988838249733,0.8702667704151734,-0.012410972435977503},
{0.08353779352595563,0.9128308559366416,-0.020882672127596924},
{0.1131975664175709,0.908460583780166,-0.02877703200580319},
{0.06230571506824824,0.8705638059047262,0.011900328091283427},
{0.07770847204348266,0.8374606215971845,0.01141168637544508},
{0.06706424194640752,0.8348216812987967,0.030344490117725526},
{0.07992844561740864,0.870999732988931,-0.006569045280722578},
{0.11421793833075677,0.8385272907085877,-0.008627207854938474},
{0.09683929944546496,0.8382994718223103,-0.002572130232643401},
{0.11421793833075677,0.8385272907085877,-0.008627207854938474},
{0.07992844561740864,0.870999732988931,-0.006569045280722578},
{0.11379988838249733,0.8702667704151734,-0.012410972435977503},
{0.07770847204348266,0.8374606215971845,0.01141168637544508},
{0.07992844561740864,0.870999732988931,-0.006569045280722578},
{0.09683929944546496,0.8382994718223103,-0.002572130232643401},
{0.07992844561740864,0.870999732988931,-0.006569045280722578},
{0.07770847204348266,0.8374606215971845,0.01141168637544508},
{0.06230571506824824,0.8705638059047262,0.011900328091283427},
{0.06230571506824824,0.8705638059047262,0.011900328091283427},
{0.0573168481692552,0.8447563266152737,0.034125733564208144},
{0.05254525723021279,0.8647003345087168,0.026079188836416183},
{0.04545972315650628,0.8826299558916049,0.0523973124705629},
{0.04542740679537438,0.8770069090546546,0.040396482788099805},
{0.04030491976489271,0.8899964818713234,0.04791290167689827},
{0.04030491976489271,0.8899964818713234,0.04791290167689827},
{0.04542740679537438,0.8770069090546546,0.040396482788099805},
{0.031528391986000805,0.9023594381537042,0.034870843422646444},
{0.03556037372381885,0.8580974831055334,0.022836551408798544},
{0.0573168481692552,0.8447563266152737,0.034125733564208144},
{0.04285630793595857,0.8464736776362758,0.03713161353757579},
{0.028455128961762385,0.8689528009231936,0.019076852203070507},
{0.0573168481692552,0.8447563266152737,0.034125733564208144},
{0.03556037372381885,0.8580974831055334,0.022836551408798544},
{0.0573168481692552,0.8447563266152737,0.034125733564208144},
{0.028455128961762385,0.8689528009231936,0.019076852203070507},
{0.05254525723021279,0.8647003345087168,0.026079188836416183},
{0.027809260127225593,0.8818422159397585,0.019383743036798268},
{0.05254525723021279,0.8647003345087168,0.026079188836416183},
{0.028455128961762385,0.8689528009231936,0.019076852203070507},
{0.030128933113154222,0.8961987020740915,0.026049851997941832},
{0.05254525723021279,0.8647003345087168,0.026079188836416183},
{0.027809260127225593,0.8818422159397585,0.019383743036798268},
{0.05254525723021279,0.8647003345087168,0.026079188836416183},
{0.030128933113154222,0.8961987020740915,0.026049851997941832},
{0.04542740679537438,0.8770069090546546,0.040396482788099805},
{0.031528391986000805,0.9023594381537042,0.034870843422646444},
{0.04542740679537438,0.8770069090546546,0.040396482788099805},
{0.030128933113154222,0.8961987020740915,0.026049851997941832},
{0.04800377711795355,0.9018884443797607,0.01378269882870383},
{0.07992844561740864,0.870999732988931,-0.006569045280722578},
{0.06230571506824824,0.8705638059047262,0.011900328091283427},
{0.07992844561740864,0.870999732988931,-0.006569045280722578},
{0.04800377711795355,0.9018884443797607,0.01378269882870383},
{0.06224520783889489,0.9078170068861351,-0.004929849430968487},
{0.06224520783889489,0.9078170068861351,-0.004929849430968487},
{0.04800377711795355,0.9018884443797607,0.01378269882870383},
{0.05718070690321018,0.9415245759050584,0.0009627296094648092},
{0.0430783969709714,0.9383575725141328,0.039767803507356564},
{0.05718070690321018,0.9415245759050584,0.0009627296094648092},
{0.04800377711795355,0.9018884443797607,0.01378269882870383},
{0.18779358325416584,0.8917919880635737,0.04667617057996409},
{0.1828957063932534,0.8843030724608449,0.05124492478424245},
{0.18631780276247586,0.8736583839756686,0.03707958648809395},
{0.19604686101558172,0.9043621357676797,0.033491324432200396},
{0.1974474658586812,0.8982353204075527,0.02464672602028597},
{0.2000038962988598,0.8839381955323202,0.017940049712189574},
{0.19966721023855658,0.8710368624251251,0.017641409864282732},
{0.1928922341033871,0.8600128577862375,0.021517310453655264},
{0.18612207104327982,0.848217844361196,0.035930178324431065},
{0.177542879341938,0.853087530353887,0.041339387112189346},
{0.17634763236815895,0.8615624387622145,0.05620032935185069},
{0.16876566398089435,0.8392283953093145,0.048703162763300986},
{0.18612207104327982,0.848217844361196,0.035930178324431065},
{0.1748915625648189,0.8416379123630707,0.049301588429367556},
{0.18612207104327982,0.848217844361196,0.035930178324431065},
{0.16876566398089435,0.8392283953093145,0.048703162763300986},
{0.17165923886947737,0.8461484512785016,0.0331670148506285},
{0.1512653230547441,0.8193244963747229,0.006076507266024374},
{0.15645221361343897,0.8170589131847315,0.028144456426200087},
{0.1318881120483874,0.8196946447664111,-0.007584604118846275},
{0.17165923886947737,0.8461484512785016,0.0331670148506285},
{0.16876566398089435,0.8392283953093145,0.048703162763300986},
{0.16209451275063796,0.8359786528661288,0.029547811597906537},
{0.16209451275063796,0.8359786528661288,0.029547811597906537},
{0.16876566398089435,0.8392283953093145,0.048703162763300986},
{0.1562305829665273,0.8230709023255173,0.05283369794286879},
{0.1513157457458719,0.8130668112117144,0.060102587257039986},
{0.1453218629350819,0.8025362613637275,0.06887957342403306},
{0.15107325844035738,0.838353790812298,0.010796758737736703},
{0.13940659368364114,0.7641439659509318,-0.028350501877672227},
{0.11466692947584463,0.7923584411595843,-0.022110464656558422},
{0.13510370457803653,0.7923605039060395,-0.017230694125641873},
{0.11466692947584463,0.7923584411595843,-0.022110464656558422},
{0.13940659368364114,0.7641439659509318,-0.028350501877672227},
{0.11490047821338649,0.7641987433290205,-0.035130520281954486},
{0.11466692947584463,0.7923584411595843,-0.022110464656558422},
{0.1318881120483874,0.8196946447664111,-0.007584604118846275},
{0.13510370457803653,0.7923605039060395,-0.017230694125641873},
{0.1318881120483874,0.8196946447664111,-0.007584604118846275},
{0.11466692947584463,0.7923584411595843,-0.022110464656558422},
{0.11441000294514352,0.8194982254650633,-0.013347459326650803},
{0.13429189925087923,0.8185337769002191,0.1213191721969281},
{0.13065298530980726,0.8171746561802748,0.12329620007723839},
{0.13000665808716932,0.8185663224554015,0.12410960976274978},
{0.12931036656150477,0.8195862359804863,0.12381830412446153},
{0.1264731734093646,0.8165847106940797,0.12881519281522488},
{0.12537510471303182,0.8195108311378452,0.12903109361087203},
{0.12837800516374193,0.8200982554894839,0.1217892491946694},
{0.13110105967869284,0.8198486631684013,0.1203086556279172},
{0.13255117043671777,0.8193657513038276,0.12163041771761689},
{0.1313536315224329,0.8152407167814737,0.12211264200003896},
{0.12672849558171165,0.8133911207932863,0.1263552530703408},
{0.13917464930445334,0.8904408891353996,0.13134182802882802},
{0.1477795107394602,0.8931740281885762,0.12869944981968157},
{0.15041638829139267,0.9006232932205545,0.12890870398786186},
{0.15642402274521752,0.893816000724253,0.12282474791519361},
{0.1544644136127514,0.8859383720117392,0.12260220049207961},
{0.14587238704457706,0.8853417798980773,0.12648406012676724},
{0.13831815113743273,0.8840142879571131,0.12830729879913777},
{0.12024344992052692,0.8209859240473835,0.13150776452144855},
{0.11557087081133545,0.8206050035353182,0.12672265113342188},
{0.11800078613559346,0.8210349715742078,0.12640934286627786},
{0.1234436864487871,0.8214718154346148,0.12994924497749888},
{0.12027576628165881,0.8216278965830603,0.12439770668432988},
{0.16948533329971815,0.8742549760893306,0.09869084358308226},
{0.1705925697580742,0.8839643236540864,0.0982968590101338},
{0.16662109524960947,0.8817899596962261,0.10598654860117139},
{0.16540086612431712,0.8760571289090476,0.1062127631290947},
{0.16169548590857674,0.8781741943542628,0.11068456824997736},
{0.16327165339442115,0.8814690880254129,0.11071252992414823},
{0.16548062565391924,0.889344424797421,0.1101076868246654},
{0.169470664880481,0.8949789313369002,0.10463659564325029},
{0.1677079334374638,0.8660975014410575,0.10203249284055085},
{0.1640089706551397,0.8722417355490285,0.10837337544392021},
{0.16052797141491795,0.8764520302581984,0.1124326312737574},
{0.16003818372882672,0.8798695427464093,0.11197263881424166},
{0.1234436864487871,0.8214718154346148,0.12994924497749888},
{0.12027576628165881,0.8216278965830603,0.12439770668432988},
{0.12476246901582924,0.8207787326256584,0.12160268523749661},
{0.1265231377123912,0.8209575039851115,0.12525649679185627},
{0.13110105967869284,0.8198486631684013,0.1203086556279172},
{0.13001582584919255,0.8198644775578915,0.11910997074337944},
{0.12369602909847661,0.8213363617507216,0.12744025770579046},
{0.11770970969135579,0.8208788904257622,0.1252798745850155},
{0.11949421456917818,0.82081884158451,0.1291461490242636},
{0.12369602909847661,0.8213363617507216,0.12744025770579046},
{0.12198028243582851,0.8212304740993532,0.12379378036104939},
{0.12837800516374193,0.8200982554894839,0.1217892491946694},
{0.12760264169062696,0.8198094709857521,0.11964055497047406},
{0.12198028243582851,0.8212304740993532,0.12379378036104939},
{0.12369602909847661,0.8213363617507216,0.12744025770579046},
{0.12837800516374193,0.8200982554894839,0.1217892491946694},
{0.13664228423958566,0.8626148978424817,0.12667016569583886},
{0.14575962357169128,0.8577238968030866,0.12373373151979722},
{0.14583777874293935,0.8656150479645848,0.12217452439369579},
{0.13649422488291046,0.8690068907191305,0.12620971484822197},
{0.14577452118497905,0.8708356300487151,0.12322973380256995},
{0.1526019827577315,0.8657667744260693,0.11814368862613064},
{0.15574377480309362,0.8561763785735649,0.1174421256373027},
{0.14465215791928468,0.8525768860091929,0.12529248025779746},
{0.13097591972707567,0.8732529397001911,0.12488886953472461},
{0.13790514345828608,0.8730109107827778,0.1256484186183495},
{0.1404941194536472,0.8742739991955287,0.12265514431776381},
{0.14553295065566685,0.8728942510110321,0.1214411034318371},
{0.15035473509178646,0.8729180871922926,0.11953925120011735},
{0.15086515024242997,0.8712740782674763,0.12068109596011105},
{0.15675497895425625,0.8732751715230975,0.11619095531518193},
{0.15997767649947336,0.8681540596569194,0.1127111020452131},
{0.16409675197651213,0.8613618939679563,0.10834220505304122},
{0.16175301361527253,0.8518393395544238,0.10983632106877769},
{0.15287586964817562,0.8484083046172286,0.11970862560349657},
{0.15968064100992063,0.9012987280876161,0.12167465216937899},
{0.16185248383322462,0.8925875206131398,0.11573485915452607},
{0.1593123261706372,0.8858036059099977,0.11778110363811177},
{0.15765296124443196,0.8832588643663987,0.11717969844938764},
{0.15269755667682372,0.8846922439587313,0.12150275663144336},
{0.1458458005347097,0.885157737075461,0.124396560714077},
{0.138881739307811,0.8827562418134749,0.12529660575070792},
{0.13371776815417422,0.8818264015502684,0.12785166102658307},
{0.13063419139765967,0.8752769523608706,0.125702279220236},
{0.13287433404803672,0.8750010027239712,0.12326640485066288},
{0.13677636275917546,0.8750021486942241,0.12388110329432067},
{0.13788841229259366,0.8758675854292174,0.1206160048497461},
{0.14100957687340349,0.8751552503200121,0.11894288828050602},
{0.14566565401095313,0.8736927630832557,0.11738597309491039},
{0.14929356663759719,0.8737450193267883,0.1162606303065585},
{0.1538497151690936,0.8751151413611604,0.11480822760802774},
{0.15551847705137267,0.8745765353422955,0.11629523860819621},
{0.16541828487216126,0.8997883392942885,0.11268589069964922},
{0.16249308120459804,0.8838490390466444,0.11321395379218746},
{0.16098429676962442,0.8809637151438822,0.1128378463551843},
{0.13797481844966264,0.8160791086184983,0.1186871077200578},
{0.13388805933375578,0.8116100538262226,0.1191296814317294},
{0.11559814490335457,0.8199435495053419,0.12899854805568955},
{0.11559814490335457,0.8199435495053419,0.12899854805568955},
{0.11770970969135579,0.8208788904257622,0.1252798745850155},
{0.1152486239762188,0.8203441807057571,0.12553313401090732},
{0.1357243620670094,0.8800558775095315,0.12555674099811714},
{0.13749763643635335,0.8789853120992684,0.11740820491781674},
{0.1344427089361614,0.8756250981237028,0.12103726351471368},
{0.14593128991557633,0.8842796946676856,0.116015392672437},
{0.15172554470831043,0.8842278968122543,0.11432577413155508},
{0.15568372596184143,0.8834071529171245,0.1124326312737574},
{0.15905379528158203,0.8805268712834751,0.10885491214419056},
{0.16098429676962442,0.8809637151438822,0.1128378463551843},
{0.1404819721689664,0.882627663951099,0.11523727887071507},
{0.15888167054959584,0.8776135857065421,0.1131607807724527},
{0.15734102814159145,0.8781347729775629,0.11198455690487186},
{0.15905379528158203,0.8805268712834751,0.10885491214419056},
{0.16098429676962442,0.8809637151438822,0.1128378463551843},
{0.16003818372882672,0.8798695427464093,0.11197263881424166},
{0.1828957063932534,0.8843030724608449,0.05124492478424245},
{0.1860982348620194,0.9046344182997696,0.04190824674573097},
{0.18164201493657622,0.9099045062988254,0.06216418774201459},
{0.13169604743400068,0.8387237100099354,-0.0028643526471339967},
{0.15107325844035738,0.838353790812298,0.010796758737736703},
{0.1512653230547441,0.8193244963747229,0.006076507266024374},
{0.1318881120483874,0.8196946447664111,-0.007584604118846275},
{0.1318881120483874,0.8196946447664111,-0.007584604118846275},
{0.11421793833075677,0.8385272907085877,-0.008627207854938474},
{0.13169604743400068,0.8387237100099354,-0.0028643526471339967},
{0.11421793833075677,0.8385272907085877,-0.008627207854938474},
{0.1318881120483874,0.8196946447664111,-0.007584604118846275},
{0.11441000294514352,0.8194982254650633,-0.013347459326650803},
{0.1398122671531692,0.9534167676075463,0.12127516693921658},
{0.16808312409826462,0.9603822039987485,0.07805100255207575},
{0.13933164722910119,0.9725340725605444,0.09168919453188835},
{0.16808312409826462,0.9603822039987485,0.07805100255207575},
{0.1398122671531692,0.9534167676075463,0.12127516693921658},
{0.16062262855780784,0.9474524508292812,0.11377295808155412},
{0.11391219346728194,0.956342888051312,0.12596562318435336},
{0.13933164722910119,0.9725340725605444,0.09168919453188835},
{0.11344326243979355,0.9754175629109016,0.09774014666127298},
{0.13933164722910119,0.9725340725605444,0.09168919453188835},
{0.11391219346728194,0.956342888051312,0.12596562318435336},
{0.1398122671531692,0.9534167676075463,0.12127516693921658},
{0.16062262855780784,0.9474524508292812,0.11377295808155412},
{0.17215727754138954,0.9349290587114938,0.09093400013522449},
{0.16808312409826462,0.9603822039987485,0.07805100255207575},
{0.17215727754138954,0.9349290587114938,0.09093400013522449},
{0.18370751172041072,0.9400696520719715,0.03858860011711818},
{0.16808312409826462,0.9603822039987485,0.07805100255207575},
{0.18370751172041072,0.9400696520719715,0.03858860011711818},
{0.17215727754138954,0.9349290587114938,0.09093400013522449},
{0.17936336768570157,0.9290335001484031,0.06718995488315115},
{0.17936336768570157,0.9290335001484031,0.06718995488315115},
{0.1860982348620194,0.9046344182997696,0.04190824674573097},
{0.18370751172041072,0.9400696520719715,0.03858860011711818},
{0.1860982348620194,0.9046344182997696,0.04190824674573097},
{0.17936336768570157,0.9290335001484031,0.06718995488315115},
{0.18164201493657622,0.9099045062988254,0.06216418774201459},
{0.13933164722910119,0.9725340725605444,0.09168919453188835},
{0.16961987020740912,0.9685447209161345,0.031163171266400273},
{0.14225249620970334,0.9811029505296103,0.028562964762560688},
{0.16961987020740912,0.9685447209161345,0.031163171266400273},
{0.13933164722910119,0.9725340725605444,0.09168919453188835},
{0.16808312409826462,0.9603822039987485,0.07805100255207575},
{0.11344326243979355,0.9754175629109016,0.09774014666127298},
{0.14225249620970334,0.9811029505296103,0.028562964762560688},
{0.11271900923995812,0.9867677106837661,0.027850171265254305},
{0.14225249620970334,0.9811029505296103,0.028562964762560688},
{0.11344326243979355,0.9754175629109016,0.09774014666127298},
{0.13933164722910119,0.9725340725605444,0.09168919453188835},
{0.16808312409826462,0.9603822039987485,0.07805100255207575},
{0.18370751172041072,0.9400696520719715,0.03858860011711818},
{0.16961987020740912,0.9685447209161345,0.031163171266400273},
{0.1860982348620194,0.9046344182997696,0.04190824674573097},
{0.18286361922617209,0.8786800256238947,0.039244095101779355},
{0.17923662337573038,0.9034861561063596,0.012682567385915791},
{0.18286361922617209,0.8786800256238947,0.039244095101779355},
{0.1860982348620194,0.9046344182997696,0.04190824674573097},
{0.1828957063932534,0.8843030724608449,0.05124492478424245},
{0.18370751172041072,0.9400696520719715,0.03858860011711818},
{0.1860982348620194,0.9046344182997696,0.04190824674573097},
{0.17923662337573038,0.9034861561063596,0.012682567385915791},
{0.14225249620970334,0.9811029505296103,0.028562964762560688},
{0.16888392811099406,0.9428841550131039,2.6013524740947607e-05},
{0.14413555452927548,0.9569206862528262,-0.012296146216636486},
{0.16888392811099406,0.9428841550131039,2.6013524740947607e-05},
{0.14225249620970334,0.9811029505296103,0.028562964762560688},
{0.16961987020740912,0.9685447209161345,0.031163171266400273},
{0.11271900923995812,0.9867677106837661,0.027850171265254305},
{0.14413555452927548,0.9569206862528262,-0.012296146216636486},
{0.1126976941932541,0.9576586910956966,-0.01695520287684373},
{0.14413555452927548,0.9569206862528262,-0.012296146216636486},
{0.11271900923995812,0.9867677106837661,0.027850171265254305},
{0.14225249620970334,0.9811029505296103,0.028562964762560688},
{0.16961987020740912,0.9685447209161345,0.031163171266400273},
{0.18370751172041072,0.9400696520719715,0.03858860011711818},
{0.16888392811099406,0.9428841550131039,2.6013524740947607e-05},
{0.17923662337573038,0.9034861561063596,0.012682567385915791},
{0.17580833876714222,0.8662008679578694,0.025045523668296616},
{0.16567177349210366,0.871822081242415,0.01103351619198672},
{0.17580833876714222,0.8662008679578694,0.025045523668296616},
{0.17923662337573038,0.9034861561063596,0.012682567385915791},
{0.18286361922617209,0.8786800256238947,0.039244095101779355},
{0.16888392811099406,0.9428841550131039,2.6013524740947607e-05},
{0.14287063256411986,0.9135532755840722,-0.0213802524114079},
{0.14413555452927548,0.9569206862528262,-0.012296146216636486},
{0.14287063256411986,0.9135532755840722,-0.0213802524114079},
{0.16888392811099406,0.9428841550131039,2.6013524740947607e-05},
{0.1645434511810942,0.9090624473569914,-0.005787493568241951},
{0.1126976941932541,0.9576586910956966,-0.01695520287684373},
{0.14287063256411986,0.9135532755840722,-0.0213802524114079},
{0.1131975664175709,0.908460583780166,-0.02877703200580319},
{0.14287063256411986,0.9135532755840722,-0.0213802524114079},
{0.1126976941932541,0.9576586910956966,-0.01695520287684373},
{0.14413555452927548,0.9569206862528262,-0.012296146216636486},
{0.1645434511810942,0.9090624473569914,-0.005787493568241951},
{0.147736422257951,0.8718250607650725,-0.00713767572021362},
{0.14287063256411986,0.9135532755840722,-0.0213802524114079},
{0.16567177349210366,0.871822081242415,0.01103351619198672},
{0.17165923886947737,0.8461484512785016,0.0331670148506285},
{0.16209451275063796,0.8359786528661288,0.029547811597906537},
{0.14287063256411986,0.9135532755840722,-0.0213802524114079},
{0.11379988838249733,0.8702667704151734,-0.012410972435977503},
{0.1131975664175709,0.908460583780166,-0.02877703200580319},
{0.11379988838249733,0.8702667704151734,-0.012410972435977503},
{0.14287063256411986,0.9135532755840722,-0.0213802524114079},
{0.147736422257951,0.8718250607650725,-0.00713767572021362},
{0.16567177349210366,0.871822081242415,0.01103351619198672},
{0.16209451275063796,0.8359786528661288,0.029547811597906537},
{0.15107325844035738,0.838353790812298,0.010796758737736703},
{0.147736422257951,0.8718250607650725,-0.00713767572021362},
{0.11421793833075677,0.8385272907085877,-0.008627207854938474},
{0.11379988838249733,0.8702667704151734,-0.012410972435977503},
{0.11421793833075677,0.8385272907085877,-0.008627207854938474},
{0.147736422257951,0.8718250607650725,-0.00713767572021362},
{0.13169604743400068,0.8387237100099354,-0.0028643526471339967},
{0.15107325844035738,0.838353790812298,0.010796758737736703},
{0.147736422257951,0.8718250607650725,-0.00713767572021362},
{0.16567177349210366,0.871822081242415,0.01103351619198672},
{0.147736422257951,0.8718250607650725,-0.00713767572021362},
{0.15107325844035738,0.838353790812298,0.010796758737736703},
{0.13169604743400068,0.8387237100099354,-0.0028643526471339967},
{0.16567177349210366,0.871822081242415,0.01103351619198672},
{0.17580833876714222,0.8662008679578694,0.025045523668296616},
{0.17165923886947737,0.8461484512785016,0.0331670148506285},
{0.1828957063932534,0.8843030724608449,0.05124492478424245},
{0.18779358325416584,0.8917919880635737,0.04667617057996409},
{0.18286361922617209,0.8786800256238947,0.039244095101779355},
{0.18779358325416584,0.8917919880635737,0.04667617057996409},
{0.19604686101558172,0.9043621357676797,0.033491324432200396},
{0.18286361922617209,0.8786800256238947,0.039244095101779355},
{0.1928922341033871,0.8600128577862375,0.021517310453655264},
{0.18612207104327982,0.848217844361196,0.035930178324431065},
{0.17165923886947737,0.8461484512785016,0.0331670148506285},
{0.19966721023855658,0.8710368624251251,0.017641409864282732},
{0.17165923886947737,0.8461484512785016,0.0331670148506285},
{0.17580833876714222,0.8662008679578694,0.025045523668296616},
{0.17165923886947737,0.8461484512785016,0.0331670148506285},
{0.19966721023855658,0.8710368624251251,0.017641409864282732},
{0.1928922341033871,0.8600128577862375,0.021517310453655264},
{0.2000038962988598,0.8839381955323202,0.017940049712189574},
{0.19966721023855658,0.8710368624251251,0.017641409864282732},
{0.17580833876714222,0.8662008679578694,0.025045523668296616},
{0.1974474658586812,0.8982353204075527,0.02464672602028597},
{0.17580833876714222,0.8662008679578694,0.025045523668296616},
{0.18286361922617209,0.8786800256238947,0.039244095101779355},
{0.17580833876714222,0.8662008679578694,0.025045523668296616},
{0.1974474658586812,0.8982353204075527,0.02464672602028597},
{0.2000038962988598,0.8839381955323202,0.017940049712189574},
{0.19604686101558172,0.9043621357676797,0.033491324432200396},
{0.1974474658586812,0.8982353204075527,0.02464672602028597},
{0.18286361922617209,0.8786800256238947,0.039244095101779355},
{0.17923662337573038,0.9034861561063596,0.012682567385915791},
{0.147736422257951,0.8718250607650725,-0.00713767572021362},
{0.1645434511810942,0.9090624473569914,-0.005787493568241951},
{0.147736422257951,0.8718250607650725,-0.00713767572021362},
{0.17923662337573038,0.9034861561063596,0.012682567385915791},
{0.16567177349210366,0.871822081242415,0.01103351619198672},
{0.1645434511810942,0.9090624473569914,-0.005787493568241951},
{0.16888392811099406,0.9428841550131039,2.6013524740947607e-05},
{0.17923662337573038,0.9034861561063596,0.012682567385915791},
{0.18370751172041072,0.9400696520719715,0.03858860011711818},
{0.17923662337573038,0.9034861561063596,0.012682567385915791},
{0.16888392811099406,0.9428841550131039,2.6013524740947607e-05},
{0.09271907799817329,0.839265295551458,0.09410260788450453},
{0.09282863275435092,0.8263882570136244,0.09243567955463011},
{0.09973012400544104,0.8199788453891313,0.11925894687625697},
{0.09956029121396064,0.8344503869368558,0.12002399661709581},
{0.11565819374460674,0.8190661946797184,0.12721289720761428},
{0.1155055505069199,0.8327440372302815,0.12887638762672998},
{0.13142376490191063,0.8203712256037257,0.1189933109716338},
{0.13125393211043027,0.8348363497180339,0.11975813151842203},
{0.13771789191896153,0.8269353432123607,0.09205796775927291},
{0.13754049572381197,0.8398110065858909,0.09372672964155196},
{0.09422923759745042,0.8323310295511348,0.09718343431241212},
{0.09434337623463968,0.8192252553508216,0.09550412950380632},
{0.09979452753365424,0.8124681563515973,0.11604106240610206},
{0.0996299662053372,0.8275557715072831,0.11832910661305053},
{0.11574322473737224,0.810187675548318,0.12445477600292451},
{0.11559195666398889,0.8242599610599307,0.1268658974150349},
{0.13148816843012387,0.8128589322078376,0.11577542650147886},
{0.13132360710180682,0.8279458597813717,0.11806347070842733},
{0.13643005054874782,0.8197372748598191,0.09514979550160838},
{0.13625242515954766,0.8328437366422841,0.09683024628046706},
{0.11530408893645935,0.8423612487867039,0.12599060533586667},
{0.13159818157440265,0.8377120474706716,0.12160131007319311},
{0.12917376690735857,0.8392460432512092,0.1113192065760357},
{0.1151853664182585,0.8429466103918873,0.11269024538661025},
{0.12499555936526996,0.8375743018462726,0.09991451061913334},
{0.1311505655936183,0.8304949560119318,0.09754556091232983},
{0.13770643221643247,0.8292965003214445,0.10797457779590958},
{0.13847148195727133,0.8264620574979114,0.11791907845656142},
{0.13674473398019532,0.816908791081601,0.10390523742784684},
{0.1312149691218315,0.8216524203464725,0.09467971850386707},
{0.12521443968357468,0.8144245567673553,0.09241390611982495},
{0.12819900461023828,0.8083224943646912,0.10076459135273767},
{0.1356216831323492,0.8128575570435341,0.11332327935431451},
{0.1289755140536062,0.8043012847472505,0.11081910515766831},
{0.11553878364425413,0.8047557765495522,0.099631455966666},
{0.11568134234371541,0.800778572189823,0.1108539426533566},
{0.13674473398019532,0.816908791081601,0.10390523742784684},
{0.13847148195727133,0.8264620574979114,0.11791907845656142},
{0.1356216831323492,0.8128575570435341,0.11332327935431451},
{0.11568134234371541,0.800778572189823,0.1108539426533566},
{0.10231084901498123,0.8039767459716279,0.1110427985510352},
{0.10282034738942243,0.8080135407845083,0.10097751262572725},
{0.11553878364425413,0.8047557765495522,0.099631455966666},
{0.09550126457817405,0.8123689153276957,0.11365950702651659},
{0.09412220397582917,0.816389895751086,0.10426255095270237},
{0.09937945710805236,0.8212648532069404,0.09494672957279374},
{0.09927654897934156,0.8301069304842984,0.09781280117530708},
{0.09292764458420186,0.8287510184810621,0.10834999765076099},
{0.10529633071784719,0.837334564869365,0.10007953033555154},
{0.10127030802534424,0.8389063776682484,0.11155321370167874},
{0.09239866471546128,0.82590121965614,0.11830527043179012},
{0.09550126457817405,0.8123689153276957,0.11365950702651659},
{0.09550126457817405,0.8123689153276957,0.11365950702651659},
{0.09292764458420186,0.8287510184810621,0.10834999765076099},
{0.09412220397582917,0.816389895751086,0.10426255095270237},
{0.09905652269078395,0.8373160001512681,0.12187428018743489},
{0.1151853664182585,0.8429466103918873,0.11269024538661025},
{0.11530408893645935,0.8423612487867039,0.12599060533586667},
{0.11512004611384294,0.8401871140228941,0.10088239709473622},
{0.11520691065901308,0.8271015088990319,0.09247418415512769},
{0.11538866154112366,0.8115722368078768,0.09161126855469086},
{0.1055152110361519,0.8141848197904478,0.09257915503029372},
{0.024622316853899085,-0.27605254502803617,0.0437509669124009},
{-0.00712197592774889,-0.2731470520488229,0.06853051088499845},
{-0.01598628502801326,-0.32036698551379,0.041665530246165865},
{0.02093550135625577,-0.3165926178888248,0.01968123691445217},
{-0.030641411010253014,-0.41404661577794755,0.030953000322017636},
{-0.04769551111992237,-0.312642000038963,0.019080290113829244},
{-0.04516795913011692,-0.2642187978084464,0.03993282322377475},
{-0.05810092101629227,-0.25771381226486123,-0.008581598238872924},
{-0.06653961676462804,-0.30317926527263206,-0.022524618305958016},
{-0.05012588483228154,-0.30008033251472854,-0.06072530749246811},
{-0.046617840694091285,-0.25480877767374915,-0.04541995798873049},
{-0.004923088206476354,-0.30208096738224866,-0.07646589649825869},
{0.006242099967569021,-0.2605134175927061,-0.06480083609989651},
{0.028028598833631454,-0.308719343863272,-0.057076309013170616},
{0.032914557603913694,-0.26857073444087537,-0.043588468330539074},
{0.032755496932810595,-0.3109601740958008,-0.019196033109372533},
{0.04173027756545493,-0.2740088216790068,-0.0070854194766812135},
{0.032755496932810595,-0.3109601740958008,-0.019196033109372533},
{0.04173027756545493,-0.2740088216790068,-0.0070854194766812135},
{-0.0744007435055001,-0.4062966481516072,0.002427279592676321},
{-0.0438837848647125,-0.5531816145116504,0.012391261747627544},
{-0.07934262562412406,-0.5438772528342709,-0.016419347186585696},
{-0.08990755457969823,-0.39426716921282157,-0.05163501305833101},
{-0.07940221607727509,-0.3382138678444185,-0.045408727480252035},
{-0.06351494287911275,-0.3884126363847847,-0.09411108806437599},
{-0.020458777731047675,-0.3916415221693675,-0.10645318768815398},
{0.018809497343067947,-0.41427787257498366,-0.08681194513552813},
{0.02950117060861332,-0.4320640184822082,-0.04096327967518617},
{0.009368765205592773,-0.42811248385614403,0.0029331108623082396},
{-0.007334668006687901,-0.5444442789154078,-0.007898829162192603},
{-0.015813931101976472,-0.6274744076193269,-0.013289244037803277},
{-0.05024277379807777,-0.6360013430771363,0.005362109410363954},
{-0.07492101400031859,-0.6203691628572705,-0.02066493777954513},
{-0.07889088415042923,-0.6136430050548748,-0.05429022613430997},
{-0.08279337124966911,-0.5312931242930796,-0.05206177238051253},
{0.02950117060861332,-0.4320640184822082,-0.04096327967518617},
{0.005107360223143308,-0.5373119892553828,-0.042691402816565686},
{-0.0029786058813485524,-0.6182053418257368,-0.05096209932582566},
{-0.005014765826708691,-0.6893020238980636,-0.050775764562703454},
{-0.023888208309888713,-0.7043928477704575,-0.011920267973683948},
{-0.059222367505784294,-0.7035432254249544,0.013230570360854574},
{-0.07926928352793819,-0.6956974546854712,-0.019603081743204097},
{-0.08209937166451035,-0.672631365435016,-0.05576554823789881},
{-0.05917904983022452,-0.6269889746201968,-0.08946967934606354},
{-0.06550870192511543,-0.5201886725424381,-0.09145587498839702},
{-0.03797951692769961,-0.5222110808447634,-0.10125965050199223},
{-0.004710625321587924,-0.5238021459438955,-0.08540790238166998},
{0.005107360223143308,-0.5373119892553828,-0.042691402816565686},
{-0.005983569078513883,-0.6165081598811858,-0.0783372659212512},
{-0.0029786058813485524,-0.6182053418257368,-0.05096209932582566},
{-0.005014765826708691,-0.6893020238980636,-0.050775764562703454},
{-0.007229009549370139,-0.6790458193286218,-0.0860748570688602},
{0.0008796467661292243,-0.7457213481652443,-0.11280484241190064},
{0.005391560845863541,-0.7583439813069331,-0.054316125062025614},
{-0.027568606374115758,-0.6232893242557208,-0.09682268287679788},
{-0.027594734495881974,-0.68243468256051,-0.10546765327065641},
{-0.02728555172164843,-0.7429416827197999,-0.12911406185718227},
{-0.06396393402420061,-0.6806151109929488,-0.0966741651320215},
{-0.07105840666587977,-0.7463142731740968,-0.11785146621164004},
{-0.0951771841906528,-0.7660744674389742,-0.06242203104891804},
{-0.10140346976873175,-0.7512029822729861,-0.009452077242978928},
{-0.12254593335266203,-0.8297988936803178,0.0034630075072511514},
{-0.09675358087054776,-0.7727382844596119,0.02804659056660208},
{-0.12365706610987792,-0.8370776383386639,0.05651753391785455},
{-0.07460793492722517,-0.7826690334772288,0.05233359652450143},
{-0.08205032413768604,-0.8547067863212405,0.11541307070751058},
{-0.027666472233713775,-0.8435940835847782,0.07938559950860796},
{-0.036728804993679996,-0.774628447794752,0.0421926765625018},
{-0.00800368544033336,-0.8355816887705227,0.036908378532310056},
{-0.0027973133873391088,-0.7746506796176584,-0.011420854137468272},
{0.005391560845863541,-0.7583439813069331,-0.054316125062025614},
{-0.0033065825677297245,-0.734594893785747,-0.09513237675376418},
{-0.0024746081641212948,-0.7165710736480702,-0.050482166983909435},
{0.004182103840948477,-0.7537156366495038,-0.04720010817959185},
{-0.0027553708760828183,-0.775369890548381,-0.09846210792060257},
{0.0036063683858894194,-0.7749050850138032,-0.05289787227703144},
{-0.010025635354557486,-0.8179101398885887,-0.005507189244381596},
{-0.010036865863035946,-0.7896509718400729,-0.011354846250901027},
{-0.020480092777751695,-0.7397733041645704,-0.008900407163230848},
{-0.06186795443163888,-0.7678229888508553,-0.1151472056088368},
{-0.08421987502048423,-0.7698871104703864,-0.07811769802079477},
{-0.08484740833097457,-0.7414863004986116,-0.07473960690928383},
{-0.060508375323593364,-0.7356503323886717,-0.10904514320617265},
{-0.05455322630735152,-0.6960403289851401,-0.0955579901056928},
{-0.07175607335584784,-0.714556228749414,-0.06770816263151441},
{-0.09599884486198508,-0.7593888769835312,-0.03031011101013838},
{-0.09868912462770292,-0.7904178551333164,-0.03251037389571441},
{-0.06978431693870092,-0.7925644866110565,-0.08160236436582578},
{-0.05725588255180073,-0.7938335340691225,-0.10944210730177863},
{-0.02889174362811892,-0.7744281321945444,-0.12432505217029574},
{-0.024655091603132184,-0.7372533155784342,-0.12060385756506528},
{-0.010108603600867747,-0.7084154325522017,-0.08571662676780235},
{-0.062234206524467046,-0.7449748631425025,0.010181601905977711},
{-0.08463127834127683,-0.7345421791541135,-0.027628311424292038},
{-0.09511392663269247,-0.802043264960928,0.008246974925024901},
{-0.0688817507675136,-0.7844922721495994,0.036698895170079175},
{-0.07722120549194784,-0.8324144561855462,0.06693715384536048},
{-0.11407240010863799,-0.8684093818292664,0.026687240652607143},
{-0.025397680327014085,-0.7988054406083726,0.019718824738747438},
{-0.019541772334673753,-0.8645334812398939,0.04537182723810856},
{-0.13183287628219748,-0.9219743233905133,0.1245647891472033},
{-0.10770447260730007,-0.9233478833356441,0.1775445982973174},
{-0.10325879560818362,-0.8992914465926293,0.1711620023767423},
{-0.13165250056439037,-0.8995337047040932,0.1165929616799007},
{-0.08872560086085288,-0.8658871013026243,0.10868439177055843},
{-0.08199783870010303,-0.9004422299205956,0.16829065931106557},
{-0.08127175194786294,-0.9230144059920491,0.17700645066655357},
{-0.09439104859716052,-0.8314630716815853,-0.032120285621625805},
{-0.11139243407519628,-0.9129935837125539,0.007462443689886714},
{-0.12519816690598348,-0.8911087605987923,0.06255840150901364},
{-0.12801839969838064,-0.9198281503008743,0.05761399825583327},
{-0.02853030461035294,-0.8935118602191323,0.09567487907148906},
{-0.03311235206956499,-0.9197467864129183,0.09105203507127363},
{-0.024831112633978268,-0.9152454152595105,0.020683502497642177},
{-0.01490219716876591,-0.8386593064817223,-0.021091467907676038},
{-0.021250643175804457,-0.7969459892760103,-0.07123270874134646},
{0.0036063683858894194,-0.7749050850138032,-0.05289787227703144},
{-0.021250643175804457,-0.7969459892760103,-0.07123270874134646},
{-0.01650953504548931,-0.7958623598048641,-0.09314182642446968},
{-0.03058525846786071,-0.7958211048757596,-0.11192244531716444},
{-0.05219504872092531,-0.9123188364276439,-0.09238525686350234},
{-0.056797265256588486,-0.8328657392711399,-0.09018911947083678},
{-0.048481188325313465,-0.8318107590563163,-0.10628427167287591},
{-0.04990494176752161,-0.9118150679044672,-0.10783041473809421},
{-0.035941981818035984,-0.8309178190352534,-0.1080648802518384},
{-0.03058525846786071,-0.7958211048757596,-0.11192244531716444},
{-0.05725588255180073,-0.7938335340691225,-0.10944210730177863},
{-0.06978431693870092,-0.7925644866110565,-0.08160236436582578},
{-0.027667847398017264,-0.9122773523044887,-0.08465499992551194},
{-0.029056304956435956,-0.8323688465694807,-0.0804476847389995},
{-0.056797265256588486,-0.8328657392711399,-0.09018911947083678},
{-0.05219504872092531,-0.9123188364276439,-0.09238525686350234},
{-0.04990494176752161,-0.9118150679044672,-0.10783041473809421},
{-0.03398626898442972,-0.9115210119375721,-0.11115441605366805},
{-0.021411995787413367,-0.9116919906993053,-0.10093213220371225},
{-0.027667847398017264,-0.9122773523044887,-0.08465499992551194},
{-0.021411995787413367,-0.9116919906993053,-0.10093213220371225},
{-0.02696261730438003,-0.8314791152651259,-0.09957828294693123},
{-0.029056304956435956,-0.8323688465694807,-0.0804476847389995},
{-0.01650953504548931,-0.7958623598048641,-0.09314182642446968},
{-0.03398626898442972,-0.9115210119375721,-0.11115441605366805},
{-0.09439104859716052,-0.8314630716815853,-0.032120285621625805},
{-0.01490219716876591,-0.8386593064817223,-0.021091467907676038},
{-0.024831112633978268,-0.9152454152595105,0.020683502497642177},
{-0.11139243407519628,-0.9129935837125539,0.007462443689886714},
{-0.12801839969838064,-0.9198281503008743,0.05761399825583327},
{-0.03311235206956499,-0.9197467864129183,0.09105203507127363},
{-0.13183287628219748,-0.9219743233905133,0.1245647891472033},
{-0.10770447260730007,-0.9233478833356441,0.1775445982973174},
{-0.08127175194786294,-0.9230144059920491,0.17700645066655357},
{-0.06978431693870092,-0.7925644866110565,-0.08160236436582578},
{-0.021250643175804457,-0.7969459892760103,-0.07123270874134646},
{-0.06978431693870092,-0.7925644866110565,-0.08160236436582578},
{-0.06978431693870092,-0.7925644866110565,-0.08160236436582578},
{-0.029056304956435956,-0.8323688465694807,-0.0804476847389995},
{-0.021250643175804457,-0.7969459892760103,-0.07123270874134646},
{-0.021250643175804457,-0.7969459892760103,-0.07123270874134646},
{-0.06526094315643756,-0.2836390972963123,-0.058839728038339575},
{-0.08510616841408032,-0.3521747650474489,-0.09180745866198806},
{-0.10125426444180362,-0.3640259310148827,-0.02551560066603791},
{-0.07382477885639047,-0.2909636807647747,-0.012259704362594128},
{-0.08909185295368105,-0.3877069479030463,0.02007705503980528},
{-0.05578399835897062,-0.3013633608098801,0.027823126367285754},
{-0.033672273135133976,-0.4173389883145413,0.05905769158044196},
{-0.01644054763626448,-0.31859096081583915,0.04201825989000978},
{0.0380819666683092,-0.39756893870548904,0.02697900467899654},
{0.023270301149522738,-0.3032196034255343,0.031233763033979164},
{0.05628180783683215,-0.37646291697560114,-0.02842017686904882},
{0.0390805651466899,-0.2986593294011274,-0.013489788832061497},
{0.04945320029382674,-0.36474239161699834,-0.09084278090309329},
{0.03149240852005961,-0.2902795365237909,-0.06084380081661837},
{-0.009807213424353946,-0.36024812547915874,-0.1260524877295235},
{-0.008596152061084819,-0.28744761483481407,-0.08736086488666928},
{-0.008596152061084819,-0.28744761483481407,-0.08736086488666928},
{-0.009807213424353946,-0.36024812547915874,-0.1260524877295235},
{-0.06359286885631024,-0.24013371180910886,-0.0467318647342552},
{-0.08520220072127369,-0.3318149991462522,-0.08089392555548043},
{-0.08638071652936034,-0.32864295348621336,-0.009804577692772262},
{-0.06977491998262711,-0.24426241343627197,0.00034390567289657194},
{-0.05315330904640378,-0.25182879662809715,0.037129092403019405},
{-0.06845659580368614,-0.31640765829000606,0.02967661865433298},
{-0.02069599357339884,-0.3558675395904073,0.060512157025427935},
{-0.012703767835594543,-0.2607052530130423,0.06200925256382194},
{0.0342945349824609,-0.324741841551277,0.04186928375713223},
{0.0674855006113751,-0.20227979322112755,0.03289450312448789},
{0.05925078756805628,-0.3439084232251499,-0.005574572295252365},
{0.06586876577857789,-0.2221882760367306,-0.01856483269407293},
{0.05381911776334107,-0.34797753439916207,-0.08299609338740783},
{0.050149950207592484,-0.20634019502121762,-0.060623086945909066},
{-0.007687397650531809,-0.24110297344901518,-0.08939771241418112},
{-0.014050741270858109,-0.34138293398179964,-0.1281418206946184},
{0.050149950207592484,-0.20634019502121762,-0.060623086945909066},
{0.05381911776334107,-0.34797753439916207,-0.08299609338740783},
{0.06034564754768094,-0.19438887125367998,0.05474150921990366},
{0.017658026432949833,-0.23003335919406204,0.09290942365718072},
{0.07117162852686668,-0.22152728039485547,0.04131578012497953},
{0.05528916840376655,-0.29613842403878876,0.03415163249192379},
{0.006869174889958186,-0.30773678896843193,0.06318593481950396},
{-0.012156452442807508,-0.22403007942719821,0.10259814375738435},
{-0.01931441183649757,-0.30173030048486,0.07513702939299102},
{-0.04308091810552784,-0.30078945890722564,0.058004544918023024},
{-0.044421015719273975,-0.2203338669734811,0.08080408148765275},
{-0.0806313837705401,-0.28665849971866425,0.03037038904544117},
{-0.0731078598661736,-0.20279960532784488,0.01648008360998966},
{-0.06356376121188648,-0.18171787816731852,0.035350546570512134},
{-0.020885995441330355,-0.30854263525027414,0.10962981722920435},
{-0.05180518964088731,-0.3223825179945979,0.0603045072156017},
{-0.016330076103884514,-0.3395743637286663,0.06358450327346403},
{-0.0007884275339980943,-0.3326804358812454,0.06942368010011195},
{0.019113637848188713,-0.28696424458213915,0.08635241106411361},
{0.008437778972133419,-0.25735329002329754,0.0960305882379905},
{-0.02787366365543885,-0.24405293007404114,0.09886823977823184},
{-0.053009375182639026,-0.25033536819451235,0.09222482102809575},
{-0.05700766539502169,-0.28507018494813907,0.07747549629106727},
{0.23119376867215274,-0.27353782790506326,0.04201894747216152},
{0.23546204947611965,-0.3139809516824562,0.017882522005493784},
{0.2728282431244649,-0.31685091958382944,0.03924386590772877},
{0.26326901766283944,-0.26985536709438096,0.06626355253070342},
{0.30395692068625274,-0.30836111356221413,0.016131708653106796},
{0.2895779735349629,-0.4101482541716182,0.028268221213513734},
{0.24945778417483838,-0.4251898013231372,0.0009200995160567694},
{0.22869463674461935,-0.42963914542706294,-0.04263341672176872},
{0.22285843944062894,-0.3086460017670861,-0.02078984853711164},
{0.21319103438712933,-0.2719215514603672,-0.008522924561924224},
{0.22689362989515513,-0.30629836710698666,-0.05874369573114617},
{0.22125843577352414,-0.2662778771588647,-0.04516761533904104},
{0.24736753443354112,-0.25757790019286675,-0.06682255682007004},
{0.25934429874069326,-0.29886377049424545,-0.07868174457927421},
{0.300390661259215,-0.2505842729334432,-0.04832957646085422},
{0.3047423686975933,-0.2957600246612798,-0.06370070465710852},
{0.31255696904619745,-0.25320143979702575,-0.011689240370698437},
{0.32186499782838635,-0.2984507628150988,-0.02578123657066108},
{0.30060151978574934,-0.2600094198754789,0.03703374767797779},
{0.22285843944062894,-0.3086460017670861,-0.02078984853711164},
{0.21319103438712933,-0.2719215514603672,-0.008522924561924224},
{0.22869463674461935,-0.42963914542706294,-0.04263341672176872},
{0.23817983252790723,-0.41160730349761576,-0.08865122739143938},
{0.2765503545058977,-0.3880257568274042,-0.1089436102417653},
{0.3197160744101404,-0.38374716229116124,-0.09732438865351932},
{0.3351910275113078,-0.3331665564625273,-0.0488849136454116},
{0.332651099042771,-0.40134101438994846,-0.0009856490145228902},
{0.3058901725029021,-0.5489236474399597,0.009458723870445785},
{0.2688042831784172,-0.5410826897755387,-0.01021414746116021},
{0.25561049846268086,-0.5342623332183543,-0.04479173709608845},
{0.34695189102281276,-0.38894872126909324,-0.055297992374713896},
{0.34062384328627593,-0.5387646211479642,-0.019940455385659066},
{0.3379952167201643,-0.615342249745881,-0.024127143107619188},
{0.3141443670405203,-0.6315652922281443,0.0023067235220708467},
{0.2792103806569389,-0.6238827076526746,-0.01576293542572219},
{0.26552359953840315,-0.6149365762763529,-0.05321347248468124},
{0.34316927241202666,-0.5261076088986881,-0.0556330740766631},
{0.34123579140132676,-0.6085283106221129,-0.05781293869173743},
{0.34585405152053056,-0.6674213262772124,-0.05935381029379239},
{0.3441930822359712,-0.6905421929057565,-0.023153755974802407},
{0.32489631834136845,-0.6988669792109536,0.010009935562092691},
{0.28917665475239585,-0.7005815799033488,-0.014545227434986235},
{0.269292695700205,-0.6859624373870502,-0.05307572686028214},
{0.3249614094517334,-0.515434958739341,-0.09472991200094427},
{0.2973290871315562,-0.5181291348039188,-0.10407094472641679},
{0.32126771813257265,-0.6223576504401098,-0.09265960214204758},
{0.32723501443349523,-0.6758526878159296,-0.09995416118988382},
{0.3610892676447904,-0.7605199496231476,-0.06624773814121332},
{0.3678388032403454,-0.7454903205622588,-0.013386422315249545},
{0.36434382316303826,-0.7671248637727861,0.024180316127353968},
{0.34285688092108496,-0.7775868845996495,0.048833115789980314},
{0.30462845925445464,-0.7704727012696204,0.03933050125884832},
{0.2698134245831246,-0.771331949765248,-0.013706606403910943},
{0.2605120424284026,-0.7552381727275123,-0.05645519313609655},
{0.264379233643853,-0.5205262753789437,-0.0876640886155877},
{0.25561049846268086,-0.5342623332183543,-0.04479173709608845},
{0.268026856958847,-0.6131722404749816,-0.0806347070842735},
{0.26552359953840315,-0.6149365762763529,-0.05321347248468124},
{0.269292695700205,-0.6859624373870502,-0.05307572686028214},
{0.27066442209293123,-0.6756629151420487,-0.08840484378706494},
{0.289457646658408,-0.6194299256379902,-0.09948064628138378},
{0.29077849197190536,-0.6785587819711375,-0.10813707637777138},
{0.3932791136607675,-0.8307844280978154,0.0521832452273204},
{0.35310712644521164,-0.8494091950361151,0.11176453061631426},
{0.29787250622548334,-0.8396310892561849,0.0766558983661902},
{0.2773110495597755,-0.8321082529339703,0.03451605103234731},
{0.26373428158551854,-0.7425213408310346,-0.11500877240228596},
{0.2605120424284026,-0.7552381727275123,-0.05645519313609655},
{0.33557057285906966,-0.7413639108756015,-0.12126072771402996},
{0.29154606284730056,-0.7390602814732135,-0.13178738126315714},
{0.3911019993743001,-0.8235455632042703,-0.0008437778972133196},
{0.26742247224746535,-0.7132853477389434,-0.05274522903934459},
{0.26794411790658734,-0.731292895099029,-0.09740666931767784},
{0.26172768767268334,-0.750580262037558,-0.04935934533011393},
{0.2866818775118235,-0.7360340032293441,-0.011475860709607677},
{0.2774162496289921,-0.7861516370758047,-0.013765050886809082},
{0.2781909255199553,-0.8144014081682467,-0.007923811313705894},
{0.2627235358224571,-0.7717504581016086,-0.055070402682487175},
{0.26832985149371485,-0.7720697254140676,-0.10073502532021271},
{0.2889208741919477,-0.7334358594719598,-0.12323317171332865},
{0.2742636854632527,-0.7049534564181782,-0.08810093247599478},
{0.32695310575128084,-0.7630894441242093,-0.11840749097834916},
{0.3249132787011114,-0.7309580425911303,-0.11227677931936243},
{0.34995891696643333,-0.7361930639004473,-0.07838516747782258},
{0.3499664803701025,-0.7646014372758911,-0.08175821632022075},
{0.3656937761209594,-0.7847645546816895,-0.036403922426981636},
{0.36228611897692353,-0.753809606210242,-0.03415254926812606},
{0.3363356225999085,-0.7095879893149732,-0.07112980061263569},
{0.3182226459765557,-0.691502057589589,-0.09868350937346367},
{0.2939982099944649,-0.7704972250330325,-0.12703252148980718},
{0.323071933698745,-0.7892035850533391,-0.11263111332156035},
{0.33603056531858544,-0.787623979656736,-0.08500497924074883},
{0.3624032371367703,-0.8259021364323423,-0.03595011820683156},
{0.38396122953440365,-0.8623462824152011,0.022511554245074915},
{0.3630864646015518,-0.7964651401578917,0.004405224249188959},
{0.3503639028538097,-0.7292466506154432,-0.03127547635118488},
{0.3288643549390744,-0.7402135859357362,0.006902293430267128},
{0.336915483547878,-0.7795519943893295,0.033296509489206684},
{0.2935139229655876,-0.7949228933915332,0.01704481775062084},
{0.3469248461248442,-0.8272509434200106,0.06338074976249766},
{0.28969073700784864,-0.8607689689591037,0.042778954943887566},
{0.40465882746615656,-0.9154429805311113,0.12006639751645326},
{0.4037986621943267,-0.893014967517473,0.11210350861712332},
{0.3763263173214549,-0.8934529573481331,0.16714079275930155},
{0.38146278518902205,-0.9173927343194023,0.17344317076217336},
{0.35502433467832034,-0.9177028338698383,0.17334828442523287},
{0.355054588292997,-0.8951214900363614,0.1646260756363286},
{0.3599391718989758,-0.8604249486891818,0.10492240062432459},
{0.39623617530136146,-0.8847607729798549,0.0581865249941842},
{0.3996715649255176,-0.9134040702571442,0.05318940710937024},
{0.3820453964655985,-0.9069864076468301,0.0033252618828520527},
{0.2957983000677268,-0.9113417821900178,0.01799505628432898},
{0.305365318127072,-0.9156263357715759,0.08821415433698172},
{0.3002242663784933,-0.8895096737078898,0.09291836222515337},
{0.28266616855159665,-0.7922202371470841,-0.09565012611402629},
{0.2877987401203039,-0.7931835397416753,-0.0738239766772134},
{0.2627235358224571,-0.7717504581016086,-0.055070402682487175},
{0.2877987401203039,-0.7931835397416753,-0.0738239766772134},
{0.2833090578634759,-0.8350286435264712,-0.02359174580546238},
{0.29641964513885144,-0.7918400042171705,-0.11466429374426296},
{0.3211836039160095,-0.9077732308224742,-0.09551581840038594},
{0.3186230479829204,-0.9073285943643473,-0.11092017973397446},
{0.31527841920279426,-0.8273825008050439,-0.10933415690395508},
{0.3238862601604587,-0.8282312063743449,-0.09338110501327603},
{0.323071933698745,-0.7892035850533391,-0.11263111332156035},
{0.29641964513885144,-0.7918400042171705,-0.11466429374426296},
{0.30269314469135006,-0.826795305647456,-0.11090436534448436},
{0.3026484518514868,-0.9074230223131867,-0.11397694078657104},
{0.2902554711484798,-0.9078979123859903,-0.10354540276843491},
{0.2938737576249995,-0.8275731902551273,-0.10226856271264907},
{0.296795523381804,-0.9083271928427281,-0.0873755333059064},
{0.2963089444124209,-0.8284079149873427,-0.08317578152306318},
{0.28266616855159665,-0.7922202371470841,-0.09565012611402629},
{0.2877987401203039,-0.7931835397416753,-0.0738239766772134},
{0.296795523381804,-0.9083271928427281,-0.0873755333059064},
{0.3211836039160095,-0.9077732308224742,-0.09551581840038594},
{0.3238862601604587,-0.8282312063743449,-0.09338110501327603},
{0.2963089444124209,-0.8284079149873427,-0.08317578152306318},
{0.33603056531858544,-0.787623979656736,-0.08500497924074883},
{0.3624032371367703,-0.8259021364323423,-0.03595011820683156},
{0.3820453964655985,-0.9069864076468301,0.0033252618828520527},
{0.2957983000677268,-0.9113417821900178,0.01799505628432898},
{0.2833090578634759,-0.8350286435264712,-0.02359174580546238},
{0.2877987401203039,-0.7931835397416753,-0.0738239766772134},
{0.33603056531858544,-0.787623979656736,-0.08500497924074883},
{0.2902554711484798,-0.9078979123859903,-0.10354540276843491},
{0.3026484518514868,-0.9074230223131867,-0.11397694078657104},
{0.3186230479829204,-0.9073285943643473,-0.11092017973397446},
{0.3996715649255176,-0.9134040702571442,0.05318940710937024},
{0.40465882746615656,-0.9154429805311113,0.12006639751645326},
{0.305365318127072,-0.9156263357715759,0.08821415433698172},
{0.38146278518902205,-0.9173927343194023,0.17344317076217336},
{0.35502433467832034,-0.9177028338698383,0.17334828442523287},
{0.33603056531858544,-0.787623979656736,-0.08500497924074883},
{0.2963089444124209,-0.8284079149873427,-0.08317578152306318},
{0.33603056531858544,-0.787623979656736,-0.08500497924074883},
{0.2877987401203039,-0.7931835397416753,-0.0738239766772134},
{0.3195022363609485,-0.27895505848459184,-0.06206586349431541},
{0.32902181125182345,-0.28605961566449656,-0.015637566280054506},
{0.3579956063500503,-0.3584349713450138,-0.029366289909846487},
{0.34045446888289665,-0.34699406272811967,-0.09537555164143045},
{0.2624766938299815,-0.2841476788945512,-0.0896337822862794},
{0.26481080604109675,-0.35690487186333614,-0.12835497116165856},
{0.22291940505808344,-0.287949091417485,-0.062448846752835976},
{0.2624766938299815,-0.2841476788945512,-0.0896337822862794},
{0.26481080604109675,-0.35690487186333614,-0.12835497116165856},
{0.20627624988110554,-0.36283343436971055,-0.09215766717127556},
{0.21633236804439027,-0.29650146741490885,-0.014975883056027617},
{0.20078223929463235,-0.3747038526373932,-0.02963169662041909},
{0.23299660907402164,-0.3006663817020637,0.029475157083872435},
{0.2204168352197913,-0.39534919432561366,0.02545028036162238},
{0.2732449179084209,-0.3150643519595518,0.0395892613419541},
{0.2931589013812379,-0.413360179596458,0.0563174475116975},
{0.31191407973431823,-0.2968869718079858,0.024740007998872382},
{0.347179251520989,-0.3823958341689366,0.016419117992535134},
{0.31697903905810404,-0.2355005540766172,-0.0499229335004922},
{0.32404807116016876,-0.23946813228622213,-0.0029580930138215313},
{0.3425305085930579,-0.3234212254318302,-0.013400632346385558},
{0.34023810969914836,-0.3266356719912264,-0.08446087256466996},
{0.26040638397108484,-0.23783902097469353,-0.09164564766227797},
{0.2685581287680934,-0.33794250208853077,-0.13051145798357364},
{0.20223028730620204,-0.20448876548062564,-0.061898093449290245},
{0.2016355287449448,-0.3461781319080519,-0.08423557481294901},
{0.18760931123749885,-0.22070630730567495,-0.01958566299535996},
{0.20223028730620204,-0.20448876548062564,-0.061898093449290245},
{0.2016355287449448,-0.3461781319080519,-0.08423557481294901},
{0.19740529415337432,-0.34222636808793716,-0.00673291902688788},
{0.18637143417031177,-0.20083220359765902,0.031897738198511855},
{0.22267943888712532,-0.32244829668711456,0.040289678360529116},
{0.2684359683391338,-0.25728269825571864,0.05965199175359805},
{0.278716009089836,-0.35222266660402024,0.05800156539536546},
{0.3082345984462935,-0.24742918763314742,0.03409891786029018},
{0.3249783698114764,-0.3116179610209678,0.026377828684323024},
{0.1936824951897898,-0.19276640656961827,0.053623500641170364},
{0.18329656678771927,-0.22016242982364662,0.04037562612949693},
{0.237858960857094,-0.22735316396656974,0.0910630363857015},
{0.20086818706360016,-0.29436606644564717,0.03293117417258083},
{0.25003626995850436,-0.30477651861112987,0.06114725373958742},
{0.26767664844955946,-0.22062333905936468,0.10025188426158833},
{0.2762624867783682,-0.2981319538907409,0.07265852493000988},
{0.29970857976468646,-0.2966169812164015,0.05513022232968876},
{0.2994715931163858,-0.21614740844557154,0.07792059113729526},
{0.3364350928178606,-0.2815816223042482,0.026873575415729378},
{0.3266407142603392,-0.19793312805186203,0.013128349814295535},
{0.3169040926035641,-0.17708586640507984,0.032160165386426895},
{0.2740069881266021,-0.3360390454984569,0.06115023326224498},
{0.30899323075371604,-0.317989555627115,0.05727937494198525},
{0.2785775758832852,-0.3048963870995836,0.10711899640509132},
{0.3135729862724223,-0.2805580416743542,0.07436808335329231},
{0.3089781039463777,-0.24592796660184293,0.08918983341030433},
{0.2838119096104503,-0.24025793498452364,0.09625496921350915},
{0.247792460203318,-0.25443885847611164,0.09402376513110472},
{0.23767973110953983,-0.2843026140727439,0.08452000462971981},
{0.2584020819987554,-0.3295242046106967,0.06725046211250447},
{0.014154795369821768,0.5315104002530302,-0.0001779691802760087},
{0.06730558328166915,0.5245231904270229,-0.024405843073125506},
{0.07660123558512665,0.4546758451244122,0.005644018092578345},
{0.03331495961027841,0.44934479150790196,0.03418417804710626},
{0.0038628365284893726,0.5151844496420561,0.0428289192469142},
{0.019407235426982763,0.44424545307652896,0.07189439196537335},
{0.0032447001740728595,0.5180484584981142,0.0710818990560643},
{0.02764630315726262,0.4587213493112145,0.11645338250309697},
{0.002083603113830349,0.5251550784244742,0.09809287630511687},
{0.01652787056953573,0.5164122421710177,0.13150913968575204},
{0.04649361751867642,0.5091250173328,0.1531863129896874},
{0.045988932219297424,0.45652314917209375,0.14268326642777004},
{0.08571124070761368,0.5196434198961063,0.16310583149882593},
{0.08304846422796555,0.4508888718266651,0.16201395104185884},
{0.11923637126227472,0.5191389637907778,0.16150559863767056},
{0.12012587337257896,0.4480750564676842,0.16444134523156048},
{0.06730558328166915,0.5245231904270229,-0.024405843073125506},
{0.11767968527072972,0.5163799258098858,-0.02814743594885762},
{0.11867369986809878,0.45588530212932726,0.0025792352482114328},
{0.07660123558512665,0.4546758451244122,0.005644018092578345},
{0.08559068463700815,0.7979099794527533,-0.01476502452949324},
{0.08141591500567825,0.7596075281077853,-0.03084596670039636},
{0.0637961639791754,0.754841896214058,0.0031242587004926565},
{0.071767991446478,0.787001717809409,0.01493141941021498},
{0.06678049971178845,0.739844583514301,0.02550093224680075},
{0.03703294549880072,0.7340739357087768,0.005220696681155558},
{0.046376040970728456,0.7376514256442931,-0.033227980468083},
{0.075711962668873,0.737603294893671,-0.04674103249627845},
{0.11464240571243249,0.7571368162425239,-0.04085120378445215},
{0.11421587558430155,0.802001780837773,-0.026570351686810916},
{0.016315636878697883,0.6205014078244556,-0.06506876394502549},
{0.06542573367880514,0.6187719095187726,-0.0664512624581291},
{0.06180584284393143,0.5632095418067138,-0.04348624778398003},
{0.0037961410597703495,0.5808451072227067,-0.03587769288684802},
{0.014154795369821768,0.5315104002530302,-0.0001779691802760087},
{0.06730558328166915,0.5245231904270229,-0.024405843073125506},
{0.11767968527072972,0.5163799258098858,-0.02814743594885762},
{0.11695864078760239,0.5607399759117052,-0.04974737085774727},
{0.11613262542930908,0.6166944946443079,-0.06702103886787306},
{0.06900482797267546,0.6733299489011862,-0.06993455363885664},
{0.025251454522743477,0.666718846512182,-0.0680356809297944},
{-0.007592740507641925,0.6630159874309982,-0.06523126252688732},
{-0.02180941827112054,0.6163023436237641,-0.05619230756008033},
{-0.009067604223129598,0.5912159088174389,-0.02786346452018797},
{-0.007578530476505912,0.5717882751199544,0.025426214986311386},
{0.0038628365284893726,0.5151844496420561,0.0428289192469142},
{0.01616482719341569,0.7033335128686728,-0.056004139244553476},
{0.06666223558168874,0.7147982576668274,-0.057598183866343196},
{0.11542808291782358,0.6722552579980128,-0.07036360490154393},
{0.11499307260982117,0.7149470046056544,-0.06025683485308089},
{0.0124729694266596,0.7195666398891617,-0.033175036642398806},
{-0.017400870708198176,0.7046394605688825,-0.04361528403445701},
{-0.05799090787201348,0.6828609834945903,-0.007670781081864654},
{-0.030939363276008096,0.7088211060217298,-0.001001234209962377},
{-0.03960610710467179,0.6575302278303459,-0.057829440663379264},
{-0.054003389780008106,0.6375628421437435,-0.05454004764944309},
{-0.06158260783866574,0.6038924025610143,-0.05096026577342102},
{-0.032119941830549975,0.5931720800391462,-0.051383357990793244},
{-0.04531097621767935,0.5571494219153058,-0.04962108493587724},
{-0.02315776687068759,0.5527346861130178,-0.018586835322928662},
{-0.01395723009822113,0.5904866133484906,0.01894827434069468},
{0.11481384286226694,0.7359329286530379,-0.051173187046410655},
{0.004913462056351921,0.7200555107990505,0.0065442923232599},
{-0.027274321213169965,0.6914057960883451,0.03709998475859565},
{-0.053053151246299966,0.6687105428117296,0.03206848776619457},
{-0.07304414392011213,0.6442287219108366,-0.01418837229823187},
{-0.01395723009822113,0.5904866133484906,0.01894827434069468},
{-0.022063823667265267,0.61821450958776,0.059552292341595404},
{-0.039830029692089264,0.5922665343453014,0.04587101188027362},
{-0.019486994956584937,0.5824091274238703,0.020031903811840855},
{-0.051804731252786146,0.5624981234737109,0.04262699928835248},
{-0.08687577567861494,0.5683831391104749,0.021880124635724724},
{-0.059263164046787685,0.6028216079567005,0.03880725124137227},
{-0.038795447747767386,0.6455832587497693,0.04980352340013959},
{-0.0151559149827589,0.6634943154145604,0.05830799784099205},
{0.0009644485648441322,0.6480839950356568,0.07560275170377129},
{-0.0017249144246713843,0.6132820244252098,0.06868269573458413},
{-0.007578530476505912,0.5717882751199544,0.025426214986311386},
{-0.07028785626782702,0.6302852434556503,0.025660909694106167},
{-0.07763008767818406,0.6157958247719805,-0.01785914421233453},
{-0.07514837449849478,0.6095347016982132,0.022309863480563782},
{-0.09308143379214164,0.5697326336802949,-0.016346005090399858},
{-0.10982955984428557,0.5212849076863663,0.016711798795126905},
{-0.11523533072128513,0.5277195306564232,-0.019674361092934724},
{-0.09738982355496016,0.5222832769706963,-0.04846548853284867},
{-0.07878614246931379,0.5639734455772997,-0.0466172677089648},
{-0.027129241379152295,0.5556644736615926,0.01993793425110271},
{-0.04562657642532916,0.5013147716711569,0.009352377830976274},
{-0.07298386588480937,0.5101777056071177,0.03417707303153825},
{-0.14525860537712162,0.4018933720518482,0.015074894885878534},
{-0.1581017231954693,0.3940368291919878,-0.020044509484622806},
{-0.1351784218385259,0.3935550632976669,-0.049225954392675866},
{-0.06107058832966815,0.5104353197199707,-0.05378026937176763},
{-0.04012523162923738,0.49953920536130714,-0.01995947849185729},
{-0.04562657642532916,0.5013147716711569,0.009352377830976274},
{-0.027129241379152295,0.5556644736615926,0.01993793425110271},
{-0.019486994956584937,0.5824091274238703,0.020031903811840855},
{-0.17024304883093844,0.35978675785533953,-0.016686816643613562},
{-0.19161126855469085,0.31475081449835723,-0.012776995334755114},
{-0.1922060271159481,0.32236326569434903,0.023249329893894614},
{-0.15868708480065274,0.3720660583092584,0.01700608395607266},
{-0.16915919016574169,0.3209683907025141,0.04075035840219661},
{-0.1901435098547712,0.23388129810926364,0.04448622142666422},
{-0.20459419474389282,0.23312381177209396,0.022708431934523838},
{-0.19126931103122424,0.22131275476351184,-0.0022425491879081486},
{-0.17080778297156962,0.3046974466636794,-0.034501382613110095},
{-0.14788310645032277,0.3526803671230302,-0.04410025864548606},
{-0.14477500593039605,0.3724013692052581,-0.04917553170154806},
{-0.12575900474775475,0.36378436048557045,0.02388121789134598},
{-0.130805170159393,0.313847102356917,0.042001757918367945},
{-0.16745788272828016,0.22850898956364885,0.04434732983201223},
{-0.0944139680022186,0.37538318380331476,-0.02552110132325186},
{-0.09431816488907582,0.37450857930629833,-0.005087076549666931},
{-0.09815876959465886,0.33935387905200753,0.012050908582515014},
{-0.10449483912296605,0.3406004654931167,-0.018670032763289532},
{-0.11551586423919608,0.2956112777224528,-0.012899155763714674},
{-0.10716999208134556,0.30030494268429775,0.019849465347578504},
{-0.15912117833245285,0.21843522345846944,0.029608548021310473},
{-0.16739279161791518,0.21305718506159016,0.004176030198608098},
{-0.1409511323905054,0.298998536595987,-0.03787649420196348},
{-0.11424360806442187,0.394017576891739,0.02200274345278546},
{-0.09431816488907582,0.37450857930629833,-0.005087076549666931},
{-0.09815876959465886,0.33935387905200753,0.012050908582515014},
{-0.10716999208134556,0.30030494268429775,0.019849465347578504},
{-0.15912117833245285,0.21843522345846944,0.029608548021310473},
{-0.1147421051244352,0.3876324598366075,-0.05333632049579254},
{-0.12098420509200424,0.36437018047885505,-0.05459734616208832},
{-0.12762281076707813,0.3446929544602881,-0.04699704225077725},
{0.042627572273478895,0.7029661148055918,0.0483227006393368},
{0.0056775950209884225,0.6987620083357876,0.04420339596824745},
{0.0808461385959343,0.7251605790816881,0.04893373197818532},
{0.06145288400603695,0.6809886972953956,0.08975250480448028},
{0.04193334349426955,0.6550278871861044,0.11237556195516275},
{0.010925222003087222,0.6725270821420016,0.07588443119193511},
{0.006680089798228996,0.6375894286536109,0.09160897661418504},
{-0.007674333589648702,0.6084673450046583,0.09048753012469303},
{-0.004035878036677946,0.5663593556438461,0.0615565943139248},
{0.0032447001740728595,0.5180484584981142,0.0710818990560643},
{0.0038628365284893726,0.5151844496420561,0.0428289192469142},
{0.10269887454261459,0.6005431898998764,0.15479044214970267},
{0.11809475569633161,0.5997359684537308,0.14238370980366089},
{0.11738860882649203,0.6464280680202102,0.1259582889747348},
{0.08562804326725283,0.6487078612413378,0.12625555365833813},
{0.11680737271421907,0.6741085210910094,0.0968142026969264},
{0.09198886575302274,0.6769725299470676,0.08992279598406185},
{0.1160340719875593,0.7160111525825011,0.06547902129556521},
{0.10174405212789484,0.7184798017013073,0.061256120913613314},
{0.11563183642878995,0.7581670434998847,0.0787202491797718},
{0.10024306029064095,0.7614330587206617,0.07487024751811491},
{0.08357263102164392,0.7669648863254807,0.06364844841357609},
{0.07404067965203756,0.7770274219221817,0.0375035954816685},
{0.04649361751867642,0.5091250173328,0.1531863129896874},
{0.0352560040246475,0.5170963864120015,0.16645068947300265},
{0.010471417782937168,0.5217029576346257,0.14275477497155128},
{0.01652787056953573,0.5164122421710177,0.13150913968575204},
{-0.0031213937748604155,0.5332408153349155,0.1182410960976275},
{-0.007187525426215004,0.5502075925113135,0.13803131478313085},
{0.003998748600483807,0.5380286790515492,0.1582359163120844},
{0.029895155181561772,0.5375070333924271,0.17971644112062135},
{0.05829963225814582,0.5441302830661121,0.18806391763682595},
{0.07466775457442673,0.5270605977610032,0.17087917691832555},
{0.08571124070761368,0.5196434198961063,0.16310583149882593},
{0.09973379111025032,0.5462466609291755,0.16405377809202826},
{0.11892787607019294,0.5418383425603037,0.15768607978474095},
{0.11923637126227472,0.5191389637907778,0.16150559863767056},
{0.03742738845985034,0.6392753800896835,0.1357634396526335},
{0.08007260867522398,0.602668277136862,0.17262219767299278},
{0.06805756896162486,0.6297292186889412,0.15357731803997832},
{0.027680223876748584,0.6180941827112051,0.1571211164500592},
{0.00918495157702694,0.6269699515139986,0.12203425763474031},
{-0.007312665377832144,0.6064073488780377,0.11346858838238276},
{-0.006030783052933531,0.5669495303240918,0.09212993469115527},
{0.002083603113830349,0.5251550784244742,0.09809287630511687},
{0.07775293568929535,0.5660673624234062,0.18684552206393826},
{0.04980845107222704,0.5748200540210376,0.18676897125104427},
{0.05405610441164166,0.5974779486674084,0.18004418861295196},
{0.011582550540153058,0.6125337058500635,0.1530130422874483},
{0.0014640915951103528,0.5925725084028268,0.1503626422865315},
{-0.012477094919570098,0.5716189007165751,0.12402664151643952},
{0.009015577173647706,0.5632141256877253,0.16740092800671078},
{0.030995515818400363,0.5609418958702669,0.18427465239857305},
{0.0209591083434656,0.5869350223406901,0.17726589833181108},
{0.04765929845993055,0.6136535479812014,0.16865805737414666},
{0.03158958679750589,0.5058583145298714,-0.02510946880840865},
{0.011947656662728328,0.5357335298290327,-0.009213486236324264},
{0.025363988801578665,0.5461513162041339,-0.02586741353367946},
{0.05840827023812113,0.5540706582338535,-0.05070058891411297},
{0.06471248179339759,0.4998953729159098,-0.033026977285723604},
{0.1170734670069434,0.5531142314607798,-0.047108201365308966},
{0.10439009744185057,0.473910268237257,-0.03640598517343684},
{0.11813921934214427,0.472430133058606,-0.03716140876415127},
{-0.12573677292484842,0.5621607498312559,-0.008679005710369756},
{-0.10707235541579811,0.5577386798193492,-0.056952085837755795},
{-0.10940784279121683,0.4856181879230778,-0.0466972564326175},
{-0.12875365421264395,0.48638919670923175,-0.018333117508935685},
{-0.11966290139040571,0.48418778785340283,0.019045681812191535},
{-0.10624886119206119,0.5547410508318024,0.03888976109958137},
{-0.06486902132994433,0.5338176967602275,0.04499434463680193},
{-0.08398334676028481,0.4720824456838748,0.03389149724451454},
{-0.04313546628956606,0.5118010870673818,0.02485850132302267},
{-0.05884075941156721,0.4599076577170209,0.01208918398896202},
{-0.05259453395108771,0.4552105548444173,-0.022156761854775758},
{-0.03396609990797861,0.5048090641663123,-0.011253542480544287},
{-0.07332903212498411,0.5396600823035834,-0.06493514381353686},
{-0.07584329085985586,0.4729368811044402,-0.052539412781922985},
{-0.05130417144631761,0.5620738852860856,-0.06407360337740349},
{-0.0832742203677877,0.6058838696665111,-0.05114774650679619},
{-0.11943966638513998,0.588303081628607,-0.007935958598386696},
{-0.08117640722282132,0.6032174260820536,0.03438403525921274},
{-0.04671616494179045,0.5587235266546949,0.04443831987009282},
{-0.04344854536265949,0.5171165554884526,-0.046644541800983916},
{-0.03396609990797861,0.5048090641663123,-0.011253542480544287},
{-0.05259453395108771,0.4552105548444173,-0.022156761854775758},
{-0.09959650387395245,0.5736156392852354,0.029102487557627992},
{-0.09886422888234668,0.5876191665816738,-0.0033784349025868087},
{-0.12925490160126424,0.5631527016821697,0.013059820793171853},
{-0.1324207590219373,0.5670927766057048,-0.024542442727271695},
{-0.10016009204433073,0.5764594790648424,-0.04224814152274233},
{-0.1091894208610133,0.5344734209389392,-0.062340208772860645},
{-0.15044687110012,0.5038418652728611,-0.024861939233781355},
{-0.11477327551531419,0.48332510144701657,-0.048894081407434786},
{-0.1266100022575614,0.46771354869170295,-0.012789830201587601},
{-0.1466594394142717,0.5070842735064283,0.011634921380710822},
{-0.12277329385083822,0.4796167417086187,0.025951069362141505},
{-0.1117364543451181,0.5259645918111256,0.04676716061804468},
{0.0741360243770792,0.523385241965889,0.17609402915119127},
{0.034761174069443485,0.5165497586013662,0.16932844997209562},
{0.040666358782658694,0.5059511381203566,0.1562609511782293},
{0.09004323745764205,0.5142869257399816,0.17063508525445695},
{0.07303956003910048,0.4805287048358798,0.1731291749128776},
{0.030003334773435926,0.47709102327121783,0.1569893298709752},
{0.007575321759797739,0.4830647370055568,0.12575040997085798},
{0.008493243932373981,0.5087828306152828,0.13574304138213178},
{0.006413307923352904,0.5220247460816412,0.1459378219460179},
{0.0008129512974102014,0.537967484240044,0.16303271859669066},
{0.028235331867255367,0.5345747247092959,0.18947529460030277},
{0.06174327286812285,0.542261434777676,0.19640681027201895},
{0.0982369247659069,0.549464774593381,0.18418457913669475},
{0.119312234493017,0.5184231907708139,0.16953885011052883},
{0.11958680896561286,0.499163097924304,0.17431731687108865},
{0.09619503496928224,0.48970540542708585,0.17488250939982097},
{0.02687483598300753,0.5600991493462811,0.19583634628012325},
{0.06921912440996854,0.5722416209520033,0.1918245336187563},
{0.11909885483192624,0.5397613860739402,0.1750546341318072},
{-0.007776095748106592,0.5743474558887399,0.16768673298778508},
{0.027521392399696063,0.5963773588365192,0.19132764091709706},
{0.00035318803194504464,0.6058653049484141,0.16449726857990218},
{-0.0029960246291926944,0.6140759526164219,0.13369221301753448},
{-0.015487558773949361,0.5709336105053384,0.1240458938166883},
{-0.008999991978208248,0.5905984600451741,0.09185031794944665},
{-0.0007975952960213274,0.6394064790866159,0.09398182261984844},
{-0.009136591632354427,0.5514117780530653,0.13842667452038282},
{-0.006307420271984602,0.5331917678080912,0.12446371457089717},
{-0.005138989002123501,0.5434035087317203,0.09714584648811686},
{7.059176757887553e-05,0.5046914876183644,0.06842668598008533},
{-0.011673082190132527,0.588753677132049,0.06125451655525926},
{-0.005679428573393109,0.5093480231440152,0.022843656424366553},
{-0.017615167145491255,0.5721859267977121,0.011527200176937836},
{0.006501318438775943,0.5075169918739248,8.583317194250994e-05},
{-0.0018569301978059469,0.5643179242353227,-0.018392249573985563},
{0.022926739267702067,0.5341310050273714,-0.03480185601342158},
{0.014616850575792732,0.5682673961149316,-0.04151128265012496},
{0.05968511029390696,0.5298061132929112,-0.05731994228893805},
{0.05100048932929797,0.5808304388034695,-0.061429850003953596},
{0.08290269681179611,0.5560607501750469,-0.0774603694837289},
{0.06084093589098612,0.5872687288783357,-0.07751995993687996},
{0.04213686781118533,0.6011590343137873,-0.06773383236517944},
{0.05410469355036479,0.6124885546220991,-0.07377722109089488},
{0.06954160043913578,0.5975008680724665,-0.07260260158166815},
{0.09058092670030468,0.5916458768563285,-0.09211205755520996},
{0.09065403960243996,0.5932071467288851,-0.09301783244310541},
{0.06799545737391746,0.643650465321221,-0.10102931048115851},
{0.04984535131437056,0.6424682824083252,-0.08037113392610555},
{0.039837134707657235,0.6651541387288668,-0.09061496201681596},
{0.030178439028079682,0.6597573064198399,-0.0826080678597745},
{0.02307411104222554,0.682050324137686,-0.08130945436918345},
{0.04812708351716603,0.6701670710031709,-0.08737461652970412},
{0.07803759470011673,0.6642004622843999,-0.0931152399146023},
{0.11576935285913846,0.6195752346660585,-0.10615798575100582},
{0.11566781989473114,0.6403606139191838,-0.08808351372815064},
{0.000269303009432461,0.5013489215846935,0.10093946641333083},
{0.11652202612124592,0.5623853600008251,-0.09943022359025602},
{0.11744155265217623,0.5183152403729904,-0.05373924363671368},
{0.10004091113802865,0.5100122275025984,-0.05626358690981096},
{-0.0013591207199443716,0.5053737983069434,0.16412436985960718},
{-0.00237697149857386,0.5387907492697304,0.18931027488388455},
{-0.014652146459582223,0.5394217204909795,0.13855800271136562},
{-0.005587292565059617,0.4908887343102347,0.1403438827534915},
{-0.020222249470848254,0.5879881690031089,0.11426274576764536},
{-0.011608678661919312,0.49503966776030417,0.10187366136349832},
{-0.00385275199026386,0.4973746967476218,0.05000498497060013},
{-0.015941133800048836,0.5711765561989541,0.045199931700172925},
{-0.007334897200738482,0.6331868401360037,0.1049113993098967},
{-0.007878774682766806,0.6122538599143043,0.1344861412087465},
{0.0322411854833072,0.6448693192822099,0.16097845232133462},
{0.023651680049689247,0.6742662065978091,0.12372112584701526},
{-0.015896211766134993,0.6537226270680465,0.07874110583837465},
{0.01365056845854393,0.7404604279282118,0.09430957011217901},
{-0.020460152895351164,0.6195351257072068,0.06565366716210781},
{-0.015678477418083196,0.6103840948496658,0.09603471373090097},
{-0.016912687380460995,0.580771077544369,0.12025387824982839},
{-0.0222930177178461,0.5875815787573786,0.08810689152130989},
{-0.021919202221348754,0.5928172876488471,0.056998383035973155},
{-0.018924094368358405,0.5733580251723825,0.04443465276528352},
{-0.026412551582986027,0.524131039406479,0.05952937293653732},
{-0.023124075345252206,0.5453580755950737,0.08820338221660443},
{0.11581014940014185,0.7462957084559998,0.0827373333043021},
{0.09727270539511332,0.7552714058648464,0.07473571061042396},
{0.09129188664520643,0.7331695359851849,0.07140116636852341},
{0.061198707803942806,0.7335291414505462,0.048630279055216295},
{0.07251860196213022,0.7589873290069136,0.05884866660631224},
{0.11635173494166434,0.701432806607206,0.08219803970328537},
{0.09159373520982139,0.7094227404045045,0.0729211813119755},
{0.06804381731859001,0.7141299278153337,0.0559035230563485},
{0.2212600401318782,0.53403176400347,-0.0019145725015269827},
{0.20468449719982165,0.4514311449503393,0.03274736054401501},
{0.1608089633209301,0.4557010301126603,0.004937871222738817},
{0.16789633094704123,0.5257477742392762,-0.02524927717926296},
{0.16789633094704123,0.5257477742392762,-0.02524927717926296},
{0.1608089633209301,0.4557010301126603,0.004937871222738817},
{0.11867369986809878,0.45588530212932726,0.0025792352482114328},
{0.11767968527072972,0.5163799258098858,-0.02814743594885762},
{0.23266588205903346,0.517969844938765,0.040910565043552616},
{0.21934237351066835,0.4466794938936975,0.07021806667942514},
{0.2336878583305734,0.5208542520653248,0.06914979320966787},
{0.211501645040298,0.4609594292151364,0.11491205251294087},
{0.23512834293847393,0.5279920423825638,0.09613876782986466},
{0.22146333525474343,0.5189072486056406,0.12979087188854752},
{0.19205155032585658,0.5108969165378405,0.15196585467034446},
{0.19366026336688347,0.4583209473048498,0.14144516016653239},
{0.1527612726228852,0.5204595799102246,0.16254361849275115},
{0.15707814256557523,0.4517900628335489,0.16139329355288592},
{0.11923637126227472,0.5191389637907778,0.16150559863767056},
{0.12012587337257896,0.4480750564676842,0.16444134523156048},
{0.1431261839305175,0.798609479695126,-0.015247478005965903},
{0.15770613426416671,0.7880470718741083,0.014211062509239387},
{0.16625919784374235,0.7560882534611166,0.0022654685929662803},
{0.14796194920372252,0.7604170414944368,-0.031403825019510126},
{0.19355162538690815,0.7359794550453058,0.0039083315475297205},
{0.16401584647665712,0.7410274540093488,0.0246859182029353},
{0.15605524951783298,0.7780251036243601,0.03681601332992599},
{0.14721065110591855,0.7677391038283427,0.0631148846638239},
{0.1507070063475292,0.7260102014271913,0.0483479119849007},
{0.13087003207570733,0.7618057282469061,0.07461355018146437},
{0.13018703380497645,0.7188256555236338,0.06101775910100926},
{0.11563183642878995,0.7581670434998847,0.0787202491797718},
{0.1160340719875593,0.7160111525825011,0.06547902129556521},
{0.14142968956811816,0.6775746227179433,0.08950818394656111},
{0.11680737271421907,0.6741085210910094,0.0968142026969264},
{0.14908477085751803,0.6494807035798964,0.12572336507288942},
{0.11738860882649203,0.6464280680202102,0.1259582889747348},
{0.1336723877321592,0.600920214113082,0.15453076529039458},
{0.11809475569633161,0.5997359684537308,0.14238370980366089},
{0.1381130224621629,0.5467137584042593,0.1637319896450128},
{0.11892787607019294,0.5418383425603037,0.15768607978474095},
{0.1527612726228852,0.5204595799102246,0.16254361849275115},
{0.11923637126227472,0.5191389637907778,0.16150559863767056},
{0.21584601826905775,0.6229304063725113,-0.0667418805142656},
{0.2298147080698079,0.5835965817999296,-0.03777266929705035},
{0.17213206619582566,0.5645526189431174,-0.044411274972124264},
{0.1667762596218527,0.6200056610930493,-0.06730088480363224},
{0.11695864078760239,0.5607399759117052,-0.04974737085774727},
{0.11767968527072972,0.5163799258098858,-0.02814743594885762},
{0.16789633094704123,0.5257477742392762,-0.02524927717926296},
{0.2212600401318782,0.53403176400347,-0.0019145725015269827},
{0.24243275733048517,0.5748322013057184,0.023330006199699074},
{0.2425546885653942,0.5942790873034517,-0.029973195755784533},
{0.25420530973856975,0.6196625575993298,-0.05850647988879503},
{0.23870629126209142,0.6660147623887978,-0.06729630092262064},
{0.20573924822059464,0.66891590068105,-0.06954904924577969},
{0.16181214568032237,0.6744598755705499,-0.07071266744057858},
{0.11613262542930908,0.6166944946443079,-0.06702103886787306},
{0.23266588205903346,0.517969844938765,0.040910565043552616},
{0.1633511837299727,0.71597516911656,-0.05840884322324758},
{0.21413233435286483,0.7057434883105304,-0.057663962558859874},
{0.1834808388043863,0.7393206459146732,-0.03437761782579645},
{0.1539324542213533,0.7385555961738344,-0.04739698586904078},
{0.11499307260982117,0.7149470046056544,-0.06025683485308089},
{0.11542808291782358,0.6722552579980128,-0.07036360490154393},
{0.2178102112825355,0.7220664593988468,-0.03489674235036203},
{0.247859155672037,0.7078688047415664,-0.04583938310129342},
{0.27096329113488865,0.6613112420827779,-0.06043354346607868},
{0.2895644510859786,0.6870921348623632,-0.010584983434999978},
{0.262004554085785,0.7123873654487676,-0.003457277655986593},
{0.2260201713683916,0.7227473949231226,0.0046903416481115226},
{0.11464240571243249,0.7571368162425239,-0.04085120378445215},
{0.11481384286226694,0.7359329286530379,-0.051173187046410655},
{0.11421587558430155,0.802001780837773,-0.026570351686810916},
{0.24824488925916452,0.59367859889093,0.016749845007523297},
{0.2577312310127053,0.5561542613476839,-0.020942033386697312},
{0.2792468225109812,0.5611007273473194,-0.05234253509247406},
{0.2651550555050691,0.5967910540978176,-0.053875843290859864},
{0.29435093963830883,0.6082255452812955,-0.053944601506034105},
{0.2858955127242806,0.64170071153293,-0.057390075668415766},
{0.24824488925916452,0.59367859889093,0.016749845007523297},
{0.25398688780836626,0.5857384002026075,0.017738817335779616},
{0.2745144237545881,0.5960933874078496,0.043235280298594005},
{0.2563535455746639,0.6216042895958506,0.0572179509364296},
{0.29356365807456364,0.6071169336586361,0.03584881443647487},
{0.3217187720241157,0.5733573375902308,0.01845436116169295},
{0.28715401725602,0.5666245331603682,0.039784763867099546},
{0.262275232259521,0.5591876446071212,0.017511456837603405},
{0.28191005737873054,0.5053020605691116,0.006606174716916723},
{0.30945597354183874,0.5148335535506168,0.030970419069861796},
{0.3334250873515825,0.3797160973295455,-0.008673734247206423},
{0.35332119368845416,0.39970961113791403,0.01808237921760027},
{0.3655991189780695,0.3697660960116797,0.019761225638104892},
{0.33840707842905804,0.3446686598909265,0.00839067959473907},
{0.34849574214752527,0.30585235548455625,0.016029029718446584},
{0.3721623198105023,0.31997025061223455,0.03778458738768059},
{0.41091582504701335,0.2355500599915427,0.03949804210982292},
{0.4025809542035907,0.22527345715159922,0.024898839475924885},
{0.28563950296978186,0.6728339729757294,0.02922854428544744},
{0.3036947226923883,0.6348381832704386,0.02252530588810975},
{0.30544209813401657,0.6488362099096631,-0.017361793122574114},
{0.3106567211728317,0.6205229520652101,-0.021114845700835296},
{0.3090019401276381,0.6142114063003152,0.01908899948775131},
{0.27224838217649544,0.6493700028534659,0.04719552429858026},
{0.24832579475901959,0.6667018861524392,0.05609879638744339},
{0.2594036599997937,0.6948957338965394,0.034696197556103835},
{0.3272478493003278,0.5748496200535625,-0.01987032200618135},
{0.31259157734783516,0.5687379315007741,-0.04989886812518121},
{0.3321709375068041,0.5275127976227992,-0.052067043843675914},
{0.35035908977874747,0.5333874995272871,-0.02357799416242754},
{0.34572249413549716,0.5268307161282707,0.012892279942197254},
{0.23287742816771959,0.650907436544762,0.07365804018459288},
{0.2223306055421413,0.675100702135974,0.07411184440474293},
{0.22640636334362027,0.7014493085788478,0.04235265400980722},
{0.2960669154950075,0.5147833600535396,-0.05677468964260626},
{0.3730639692054873,0.39974238588714706,-0.053487359375125346},
{0.3964548264256156,0.40078819833994744,-0.024694169188756193},
{0.3840148609422396,0.40833670439582725,0.010637010484481874},
{0.39819578443382764,0.37884561832543945,0.012336713563589315},
{0.410305252096266,0.3280227543853416,0.03589167372393347},
{0.4334630189669536,0.24147312184070321,0.03925761755076363},
{0.4330147154040175,0.3299748001141386,0.018007203569009783},
{0.4475605158241302,0.24106309368421408,0.017240549469816853},
{0.432001219312349,0.3223426382297968,-0.018005599210655695},
{0.43411072135389506,0.228926122735706,-0.007486050677096532},
{0.4110874913908984,0.3117816055730825,-0.039380236367824346},
{0.4105532400589945,0.22009321322037118,-0.0006698196128224764},
{0.38132618553487585,0.30535660875314996,-0.04225570492641149},
{0.35640316608661465,0.30135648498836265,-0.016855961852942195},
{0.4025809542035907,0.22527345715159922,0.024898839475924885},
{0.34849574214752527,0.30585235548455625,0.016029029718446584},
{0.33840707842905804,0.3446686598909265,0.00839067959473907},
{0.3441951449824265,0.3460628473006097,-0.02243202390952334},
{0.3331569303124029,0.38058840988605613,-0.029105925468386702},
{0.3334250873515825,0.3797160973295455,-0.008673734247206423},
{0.2759631593483096,0.5033871442765089,-0.022609878492774096},
{0.28191005737873054,0.5053020605691116,0.006606174716916723},
{0.262275232259521,0.5591876446071212,0.017511456837603405},
{0.25398688780836626,0.5857384002026075,0.017738817335779616},
{0.35271176670795973,0.39332311891847904,-0.057255767954775404},
{0.3831721144182539,0.37882842877164585,-0.05360218559446631},
{0.4094806119022762,0.36684433025487523,-0.021547564068331887},
{0.3868438031085588,0.3591901657416776,-0.04858375266294837},
{0.3667382134094562,0.3507111318404396,-0.05114201665553163},
{0.35949613979920303,0.37021944184372857,-0.058625889989147646},
{0.18943919653733624,0.7047533700120212,0.047091699393667134},
{0.1718517618719653,0.6823331495961027,0.08882679003418428},
{0.19237379716097325,0.6568596060383464,0.11111430709481644},
{0.19765328211610278,0.6412258214601264,0.13441990412812865},
{0.1675678958725589,0.6309407384403115,0.15274282250181348},
{0.15653609863595158,0.6035992633703214,0.17198114191351818},
{0.15998409393288965,0.5670684820363432,0.1861561063597911},
{0.16374975218393278,0.5281451440083518,0.17013223350748258},
{0.19205155032585658,0.5108969165378405,0.15196585467034446},
{0.20331277080709534,0.519142172507486,0.16504160445003166},
{0.2275768573599366,0.5243460234259238,0.1409345158218383},
{0.22146333525474343,0.5189072486056406,0.12979087188854752},
{0.24047177303371553,0.5362065863494315,0.11619874791290168},
{0.23512834293847393,0.5279920423825638,0.09613876782986466},
{0.24212174100384695,0.5699705371047977,0.09004908190593189},
{0.2336878583305734,0.5208542520653248,0.06914979320966787},
{0.23962948489783098,0.5693255850464634,0.05951355854704725},
{0.24243275733048517,0.5748322013057184,0.023330006199699074},
{0.23266588205903346,0.517969844938765,0.040910565043552616},
{0.17998333759252272,0.5456117934090666,0.1870435457236401},
{0.20839675323707943,0.5396800221859841,0.17821980397032852},
{0.23390903058938395,0.5408275967972422,0.15630816515264895},
{0.24445493643875987,0.5532710001913769,0.13592158354753425},
{0.24898633201279355,0.5748019476910418,0.12183440042263383},
{0.2428003845876168,0.6094521918400042,0.11137169201361871},
{0.2427263549092792,0.611515855071434,0.08838811262137257},
{0.2362967742083351,0.6161797248067034,0.06668710313617679},
{0.20828994880950877,0.6202949039848822,0.15559560084939314},
{0.22442727271685478,0.6151247445918798,0.15122830821557534},
{0.2259530175115714,0.6296088918123863,0.12021674881363428},
{0.2276880164744683,0.6402801668074299,0.08975594271523898},
{0.23498257552230456,0.5954154314062314,0.14840486670647002},
{0.21608438008166178,0.5893106186749604,0.17562991119876506},
{0.18860126308841269,0.6153695238379001,0.1674763328493519},
{0.2068027086152897,0.5630823391086412,0.18280070545928767},
{0.1877021348279841,0.5764989004415422,0.18561268726586397},
{0.22843473069126066,0.565885382347245,0.16556118736269843},
{0.1827916522942897,0.5990451775852802,0.17896468463471624},
{0.2092688365995395,0.5483905420783087,-0.02740943110598733},
{0.22321208586067517,0.5383055454646507,-0.010984927053263559},
{0.2040393159474366,0.5079577320331918,-0.026555454073523166},
{0.17562956740768917,0.5554978495868204,-0.051683373003003553},
{0.17094323665546285,0.5011887149433375,-0.03391762536628074},
{0.1170734670069434,0.5531142314607798,-0.047108201365308966},
{0.13185877520991307,0.4742446623570545,-0.03663632519427062},
{0.11813921934214427,0.472430133058606,-0.03716140876415127},
{0.360202057474992,0.5680748731124436,-0.012753388347545244},
{0.36490007712379796,0.4923970603571071,-0.022472362062425557},
{0.34510596213943473,0.4911490987516945,-0.05050806591162503},
{0.3408438695748335,0.5631896019243131,-0.06070788874462397},
{0.30742164714888326,0.544293240036075,-0.06812758774407733},
{0.3117667079597947,0.47765369466539376,-0.05578938441915924},
{0.27840980583826,0.5210325650366767,-0.04934330174657327},
{0.26982419670350194,0.5085057350081306,-0.013800805158699702},
{0.28946910636093703,0.45937271880296526,-0.025024896203744307},
{0.27942490628828254,0.5157262643776291,0.02215401152616881},
{0.26982419670350194,0.5085057350081306,-0.013800805158699702},
{0.28946910636093703,0.45937271880296526,-0.025024896203744307},
{0.2961723447582747,0.46422773637641906,0.009112640854068698},
{0.3213733765898904,0.4770153892345262,0.030492549474400756},
{0.30095058232478394,0.5382693328046589,0.04192704065787861},
{0.3564934685425435,0.48998273022828864,0.015053121451073365},
{0.34170059693590465,0.5601926605189181,0.03513372899866266},
{0.3532836058641589,0.5940563106862872,-0.01189964050913164},
{0.31598158654997627,0.6107425543447743,-0.054495354809579837},
{0.28487537000514535,0.5661643115068018,-0.0668924610054972},
{0.2821899033144897,0.5627257131659376,0.041680657053504204},
{0.31538361927201086,0.6080433360110838,0.031058887973385997},
{0.36405870576411575,0.5691575858073875,0.008923555762339542},
{0.33281038890792464,0.5928738985793406,-0.00699786734935931},
{0.334427582128823,0.5788987913451742,0.02546357361655607},
{0.3480183309401654,0.5315610521382086,0.04291234588132561},
{0.3827966945634025,0.5135292102087614,0.007195432620960022},
{0.35982961714279815,0.485491214419056,0.021904648399136865},
{0.36330488653175536,0.4736774070818669,-0.01689813355824906},
{0.3860494165292457,0.510372749744162,-0.029360330864531416},
{0.35048812602922447,0.48898871563091956,-0.05279496414832061},
{0.34343605428690277,0.5399832459149024,-0.06613543305642869},
{0.3664968720741946,0.5731661897520464,-0.02872569253847308},
{0.33372556075189397,0.5817412559604777,-0.04588613868761193},
{0.16445796180022754,0.5244846858265253,0.1753367720080722},
{0.14868780676191204,0.5150010944015914,0.17014346401596106},
{0.1980048657896938,0.5078665128010607,0.1549419394171366},
{0.20386856637975387,0.5186086087577337,0.167910426381152},
{0.2316787432831818,0.524767511284942,0.14404903377518125},
{0.22975122131779702,0.5114767774858099,0.13388794473673052},
{0.23112707320343373,0.4857864163562042,0.1238760610252079},
{0.20937816216166658,0.47927501337920264,0.15548535851106374},
{0.16654752395937303,0.48166711168511483,0.17234510206584056},
{0.14320823540062544,0.49027770297138623,0.17448829563282195},
{0.11958680896561286,0.499163097924304,0.17431731687108865},
{0.119312234493017,0.5184231907708139,0.16953885011052883},
{0.1398684196955615,0.5499717518332659,0.18383551659766015},
{0.1767262609397185,0.5436613520386236,0.19544282009527594},
{0.21029058367702888,0.5367912603724632,0.18794886222343438},
{0.2371750458101608,0.5408450155450865,0.16105087764131817},
{0.243762082823854,0.536236381576007,0.12236681820213309},
{0.24188750468415338,0.546410993063442,0.09507461985301786},
{0.23756903038310928,0.5042379125922648,0.09894960366618803},
{0.2111356221415204,0.5623422715193158,0.19429134918515784},
{0.16844708425058696,0.5734497027926149,0.19099255921514788},
{0.24495274591662144,0.5774241568237372,0.16556783399016528},
{0.2463803956576895,0.5545228580956495,0.13628416853555314},
{0.2520123810626123,0.5741904579640922,0.12180300083770426},
{0.24450925542874755,0.5936847871302956,0.08972477232436002},
{0.23714112509067484,0.5075777282973288,0.06643911517344832},
{0.11909885483192624,0.5397613860739402,0.1750546341318072},
{0.23600638534624915,0.6087343560735851,0.1625213866698448},
{0.20953103459340397,0.5985934361115853,0.18980166692832984},
{0.2386379914350183,0.6170176582556269,0.13166613761039989},
{0.23515790897099892,0.6422794265106465,0.09200341957523465},
{0.24671318541913287,0.5918995946703215,0.05908794519511864},
{0.2420110402774164,0.5123635292675073,0.020766929132053608},
{0.2522220936188938,0.5754711943187378,0.009264596509603809},
{0.2294986494740569,0.5102320245971055,-0.0017839318926959162},
{0.23616086213634058,0.5672158538108667,-0.02038807136644346},
{0.21184772805667507,0.5364309673249501,-0.036386045291036326},
{0.21921058693158438,0.5707580478625934,-0.043226570924671935},
{0.17483311808192079,0.531208093300314,-0.05828553682403511},
{0.18220308197239812,0.5824276921419672,-0.06252998144674159},
{0.15064902025273222,0.5568853903690367,-0.07802831234106822},
{0.13499437901590947,0.510437840854527,-0.05655672610050386},
{0.11652202612124592,0.5623853600008251,-0.09943022359025602},
{0.11744155265217623,0.5183152403729904,-0.05373924363671368},
{0.15261710956506985,0.6651085291128012,-0.09374048128458677},
{0.1630222902673892,0.6448072076945026,-0.1018259890009775},
{0.11576935285913846,0.6195752346660585,-0.10615798575100582},
{0.11566781989473114,0.6403606139191838,-0.08808351372815064},
{0.18246550916031318,0.671802370554065,-0.0885008760942583},
{0.20731999958745068,0.68429321711667,-0.08285445146414888},
{0.19081940310993403,0.6669922750145251,-0.0918808007581739},
{0.2007396092012243,0.6618342629062034,-0.0840380095413483},
{0.18153956519596662,0.6440717239861887,-0.08147539086180401},
{0.16307683845142742,0.5986395041157521,-0.07338690362275573},
{0.14173589281969415,0.5938289501881109,-0.09344619612364102},
{0.1418619495475136,0.5922702014501107,-0.0925420255940996},
{0.1719402307754895,0.5886214321648638,-0.07845140455844044},
{0.17812228190180635,0.613998255833275,-0.07481707449838014},
{0.1904620895850785,0.6029648542383136,-0.06897743928363108},
{0.24015800637847037,0.5083136703937439,0.16209944042272548},
{0.24433827666701421,0.49393082694359414,0.13824836154903092},
{0.2521879437053572,0.5426698585758111,0.13632061038959548},
{0.2407841645246572,0.5417505612389313,0.18727159380396802},
{0.25616560645318764,0.5913520500834839,0.11194559391627311},
{0.24961111499467692,0.49821950601806264,0.09968348301614785},
{0.24093199468728185,0.5003542194051727,0.04795255224764877},
{0.2511380057596464,0.5744276738064432,0.042960247437897},
{0.24202708386095706,0.6362220569478457,0.10282046198644774},
{0.2103694264304287,0.6765386656093181,0.12215550128749757},
{0.20312391490941675,0.6469490260971804,0.15954576031115383},
{0.24357620644883296,0.6153145172657607,0.13237778513745338},
{0.25313382755210434,0.5840581786177993,0.11798967022414032},
{0.2507733580251723,0.6136271906653846,0.093800530125839},
{0.25780709424344755,0.5909912986478696,0.08575834008500807},
{0.2548206957643793,0.622885713532648,0.06334545387870821},
{0.2567844303897559,0.5962098179855446,0.05466152049625096},
{0.25405381247113584,0.5766806513236529,0.04214592097618332},
{0.26299031769733316,0.5276537519639064,0.05710266632898743},
{0.2596674623520122,0.5488003410407472,0.08583214056929511},
{0.24964595249036517,0.656954950763388,0.07651448563698184},
{0.21826172356217974,0.7429510796758737,0.09259405264358148},
{0.14044713467327813,0.7337675032631502,0.07098907546557906},
{0.13398684196955613,0.7557178758753779,0.0744279030004939},
{0.11581014940014185,0.7462957084559998,0.0827373333043021},
{0.11635173494166434,0.701432806607206,0.08219803970328537},
{0.14074898323789306,0.7100204784884193,0.07250909040903117},
{0.1701369319855195,0.7348541122569539,0.04771739915175281},
{0.16388887297263532,0.7152956087565878,0.055100197909062676},
{0.15837331814540753,0.7600315371013598,0.0581289972874884},
{-0.208924128747466,0.1709310893707821,0.07496192513834726},
{-0.19299147512728865,0.23643108192197546,0.05009482903842783},
{-0.21149660277118526,0.2354606743118162,0.022206726157802392},
{-0.23204568295816175,0.16427873205267335,0.05121192084095881},
{-0.21900339550985934,0.14558497770514872,0.01580258599647272},
{-0.19443310570544212,0.22033570052588572,-0.00974498723962121},
{-0.19161218533089316,0.3147301870338049,-0.01295920460496685},
{-0.19220717308620103,0.3223426382297968,0.023067120623682852},
{-0.1691603361359946,0.32094753404391124,0.04056814913198485},
{-0.16394090002211723,0.2295513641056905,0.04991697445517711},
{-0.18228811296516365,0.16540201209457003,0.07156595689089101},
{-0.21857732376982955,0.13699936857039063,0.12213097752408543},
{-0.24991846421650588,0.11887378627425588,0.06989857017291545},
{-0.2372128628285067,0.08838249736713331,0.023448041135748214},
{-0.1970284991342195,0.07809191369010442,0.025324682021904084},
{-0.19411292161678065,0.14129675701878128,0.02014718841928302},
{-0.1638574733877058,0.2097645833309459,-0.0015251718095901682},
{-0.17080869974777194,0.3046768191991272,-0.03468359188332188},
{-0.15326527034011253,0.21665094777469762,0.031042844389845337},
{-0.1767853930047684,0.15211517459429785,0.0489566513832434},
{-0.17757725844952515,0.13332790907413622,0.11860184753324172},
{-0.15326527034011253,0.21665094777469762,0.031042844389845337},
{-0.1767853930047684,0.15211517459429785,0.0489566513832434},
{-0.16315132651786624,0.09130495070608954,0.07852612181892983},
{-0.1409522783607583,0.2989776799373841,-0.03805870347217526},
{-0.11551701020944899,0.29559065025790054,-0.013081365033926462},
{-0.10717113805159847,0.30028431521974547,0.019667256077366743},
{-0.1308063161296459,0.3138264748923647,0.041819548648156186},
{-0.10717113805159847,0.30028431521974547,0.019667256077366743},
{-0.16315132651786624,0.09130495070608954,0.07852612181892983},
{-0.21498126911621626,0.1504092832758247,0.07487941528013815},
{-0.21340876873518116,0.15519898054486297,0.07197071358421678},
{-0.22664380838002207,0.14940518414023007,0.05242275301017737},
{-0.2286634663537404,0.14345897369196087,0.05519141714119385},
{-0.21878405680345347,0.1401246586441109,0.029391042867309265},
{-0.2219705416886788,0.13358712754534316,0.031603223843515486},
{-0.20635669699285944,0.1259123355675933,0.0335593950652229},
{-0.20324080387521304,0.13234810450790316,0.03087415756861785},
{-0.19146275080991446,0.13405605857283154,0.05735455059057579},
{-0.18727720905820727,0.14049503622984952,0.055454761105311216},
{-0.1914813155280115,0.14322977964138003,0.0715088875722964},
{-0.18916989352790378,0.14983263104456332,0.06991736408506309},
{-0.22300489443895016,0.07251516405137154,0.1269099026727464},
{-0.22869234480411355,0.044361425266122925,0.14088019683185063},
{-0.22155845078573447,0.041635849616615636,0.1376455811960033},
{-0.2174494598469213,0.06616648885028241,0.12528995912324106},
{-0.22180506358415947,0.03461540665327408,0.12767036853257363},
{-0.21929607631245107,0.020627235358224562,0.14946878548926626},
{-0.22709119516675585,0.022319375033662867,0.1513958490665499},
{-0.21314657074131668,-0.0021195865797715716,0.15360917601300905},
{-0.21667020007494642,-0.0009117339332105701,0.16142148442110738},
{-0.2188305831957214,-0.01370855455334091,0.16098303620234625},
{-0.21931166150789055,-0.007892984713902804,0.15064248822229073},
{-0.22095704559701038,0.014153878593619457,0.13962283827036415},
{-0.18336097031593254,0.10501213009512696,0.09972496713930298},
{-0.2064949010053597,0.08615496038953818,0.07930629836710698},
{-0.19762348688952733,0.09098453742337755,0.10893077537493281},
{-0.18544273987735826,0.08328545087626614,0.13620142948329347},
{-0.18444276623467407,0.12039380121770797,0.11428910308346216},
{-0.1971836635064627,0.05262845467057364,0.16123400368773225},
{-0.20334531636227784,0.05486813893284956,0.15367953858653735},
{-0.19372054140218628,0.05543883211879584,0.14322233083473618},
{-0.18843418062553932,0.05667281288712305,0.15518694785720752},
{-0.18941192244531715,0.07738347487975905,0.1316244242931942},
{-0.20373150833750658,0.07591296585123242,0.1314057731689401},
{-0.20986909581801075,0.09172345904245015,0.11829610266976691},
{-0.22050713767572022,0.07959611424406643,0.12415453179666361},
{-0.20760649215067675,0.0815447220621047,0.13570384919948247},
{-0.22087384815664957,0.11098011397820133,0.11115074894885878},
{-0.20986909581801075,0.09172345904245015,0.11829610266976691},
{-0.20373150833750658,0.07591296585123242,0.1314057731689401},
{-0.20334531636227784,0.05486813893284956,0.15367953858653735},
{-0.19372054140218628,0.05543883211879584,0.14322233083473618},
{-0.19015015648223804,0.08973955534062245,0.14190721537250334},
{-0.19058952147720148,0.08533971715162217,0.14514733166556462},
{-0.20568745036516345,0.08788102078446246,0.14108853422382864},
{-0.20564871657061526,0.12357593141597228,0.11587306316702631},
{-0.19015015648223804,0.08973955534062245,0.14190721537250334},
{-0.19058952147720148,0.08533971715162217,0.14514733166556462},
{-0.20568676278301165,0.08156603710880872,0.14393099883913213},
{-0.1971836635064627,0.05262845467057364,0.16123400368773225},
{-0.18843418062553932,0.05667281288712305,0.15518694785720752},
{-0.21328087845495708,0.08221786498866061,0.03842724750550926},
{-0.23193200270907366,0.07849048214406448,0.041929561792435},
{-0.20171666343885047,0.08201388228364367,0.05399662855551595},
{-0.21896007783429958,0.049538460480642824,0.09753937267296414},
{-0.2184074909783492,0.056297851420372816,0.11460378651490964},
{-0.22869234480411355,0.044361425266122925,0.14088019683185063},
{-0.22300489443895016,0.07251516405137154,0.1269099026727464},
{-0.23537312218449433,0.07015400694228778,0.1247408101780494},
{-0.23526012951755795,0.043311258126361545,0.13923550032488255},
{-0.236173238615072,0.037128977805994105,0.12865452778576775},
{-0.23976035470071266,0.06396072530749246,0.10994541743685418},
{-0.23452785452595223,0.07890073949460419,0.12193020353577662},
{-0.22050713767572022,0.07959611424406643,0.12415453179666361},
{-0.18444276623467407,0.12039380121770797,0.11428910308346216},
{-0.1914813155280115,0.14322977964138003,0.0715088875722964},
{-0.18916989352790378,0.14983263104456332,0.06991736408506309},
{-0.23598575788169687,0.10475245323581889,0.09967018976121417},
{-0.24101519212764272,0.08633739885380054,0.07619132202566285},
{-0.23744068171478402,0.05246022623744732,0.07017749933247235},
{-0.23350862858301924,0.05180771077544367,0.05193067338358031},
{-0.22341767292404624,0.048219907107651276,0.05157656857543292},
{-0.21598857696851906,0.04662471651560868,0.0586506429466104},
{-0.21781571193974947,0.04761758514272486,0.07232000531730197},
{-0.22036274542385426,0.019423279010523434,0.09219112950266035},
{-0.22135309291641406,0.0237887380919366,0.10455821127795166},
{-0.2111603750989832,0.0013451398828589125,0.09801724226842519},
{-0.21098687520269346,0.004954029403304741,0.10924179170157101},
{-0.19118955150162212,-0.017083207754093128,0.10921818471436118},
{-0.19294701148147597,-0.02006273041164398,0.11582309886399968},
{-0.19203344399586075,-0.03145413311361264,0.1139776283687228},
{-0.1922539286725195,-0.023461907375808347,0.1047596728484122},
{-0.24147243425855153,0.05487593153056932,0.09280330681176178},
{-0.23676226732506478,0.018965120103412343,0.08857513496664654},
{-0.22036274542385426,0.019423279010523434,0.09219112950266035},
{-0.23450172640418598,0.014666127296667624,0.09018453558982516},
{-0.2111603750989832,0.0013451398828589125,0.09801724226842519},
{-0.22022041591844357,-0.00839950356568645,0.0992702461429506},
{-0.1922539286725195,-0.023461907375808347,0.1047596728484122},
{-0.19203344399586075,-0.03145413311361264,0.1139776283687228},
{-0.21963001204414737,-0.004075528607428417,0.11291508475023006},
{-0.19294701148147597,-0.02006273041164398,0.11582309886399968},
{-0.21098687520269346,0.004954029403304741,0.10924179170157101},
{-0.22135309291641406,0.0237887380919366,0.10455821127795166},
{-0.23462182408669033,0.01933664365940388,0.10593956382080233},
{-0.23718833906509454,0.02376536029877735,0.1047415665184163},
{-0.21896007783429958,0.049538460480642824,0.09753937267296414},
{-0.23976035470071266,0.06396072530749246,0.10994541743685418},
{-0.22180506358415947,0.03461540665327408,0.12767036853257363},
{-0.2359069151282971,0.03313618825082537,0.13091575628879823},
{-0.22095704559701038,0.014153878593619457,0.13962283827036415},
{-0.23345889347404322,0.012096861989656463,0.1425150379946437},
{-0.21931166150789055,-0.007892984713902804,0.15064248822229073},
{-0.2188305831957214,-0.01370855455334091,0.16098303620234625},
{-0.23253867936096115,0.01653360042080027,0.15202131963058504},
{-0.21667020007494642,-0.0009117339332105701,0.16142148442110738},
{-0.22709119516675585,0.022319375033662867,0.1513958490665499},
{-0.23526906808553064,0.039997341349013255,0.14009864511936998},
{-0.22180506358415947,0.03461540665327408,0.12767036853257363},
{-0.23976035470071266,0.06396072530749246,0.10994541743685418},
{-0.2184074909783492,0.056297851420372816,0.11460378651490964},
{-0.23978762879273177,0.08041089909388131,0.10510942296959856},
{-0.24179491028771874,0.025781351167686373,0.11013862802149381},
{-0.2411852541131737,0.03259185238069589,0.12492164428395766},
{-0.2405231125010457,0.022447265313886973,0.11146566157435686},
{-0.22163568918078022,0.0263635040561617,0.11143357440727554},
{-0.24147243425855153,0.05487593153056932,0.09280330681176178},
{-0.1894976410202344,0.39645299287321095,0.003387831858660613},
{-0.19161218533089316,0.3147294994516532,-0.01295920460496685},
{-0.19220694389215043,0.32234195064764504,0.023067120623682852},
{-0.1670985064569694,0.38295850556311256,0.036325538061682996},
{-0.169160106941944,0.3209468464617595,0.04056814913198485},
{-0.14124266722284423,0.3414803414532965,0.05071709088575478},
{-0.1308063161296459,0.31382578731021293,0.041819548648156186},
{-0.0995804602904118,0.36076954194423017,0.03667895528767866},
{-0.10717090885754789,0.3002836276375937,0.019667256077366743},
{-0.07686343357899117,0.3617573683022336,0.0083987013865094},
{-0.11551701020944899,0.29558996267574883,-0.013081365033926462},
{-0.10669258087398567,0.317496330030265,-0.04247618960307028},
{-0.1409522783607583,0.2989769923552324,-0.03805870347217526},
{-0.18674891677161842,0.34691476158661866,-0.04717535522212912},
{-0.17080869974777194,0.30467613161697543,-0.03468359188332188},
{-0.1659360342324234,0.44431077338094455,-0.047108659753410095},
{-0.151501622120893,0.31704504694467134,-0.05505665103945229},
{-0.1409522783607583,0.2989769923552324,-0.03805870347217526},
{-0.06039790379121341,0.41538029595827747,-0.05986766335519459},
{-0.10669258087398567,0.317496330030265,-0.04247618960307028},
{0.4542791102228567,0.1790042206084414,0.06940144827720564},
{0.47715428082917816,0.17291155516185105,0.04526571039268963},
{0.4543950824124507,0.24356658029870856,0.016623788279703827},
{0.43634215463035003,0.24409189306263981,0.04481832360595583},
{0.43301356943376457,0.32995348506743455,0.017824994298797994},
{0.4320003025361467,0.3223213231830928,-0.018187808480867432},
{0.43717183709345264,0.2280242441466704,-0.015040515778291439},
{0.4639792900255895,0.1538987626959179,0.010076401836761112},
{0.4837012088840198,0.09715810836982292,0.01740373563383042},
{0.4964377514688473,0.12795926763333074,0.0636408850099069},
{0.4655449145851072,0.14532713439824527,0.11639493802019886},
{0.427732480120281,0.17282767013933847,0.06645149165217969},
{0.4074687465262776,0.23650694515271767,0.04512613121588591},
{0.4103041061260131,0.328001210144587,0.035709693647772295},
{0.39679517959072813,0.22334685196241674,0.026430772510007194},
{0.42217658714015094,0.1594060665373248,0.04393478054096672},
{0.34849459617727235,0.3058308112438017,0.015846820448234794},
{0.3721614030343,0.31994893556553056,0.03760260731151942},
{0.4070046285738514,0.2167135177505062,-0.006311431167869742},
{0.4392767552539871,0.14900707407437114,0.014836762267325094},
{0.42217658714015094,0.1594060665373248,0.04393478054096672},
{0.39679517959072813,0.22334685196241674,0.026430772510007194},
{0.35640224931041237,0.3013351699416586,-0.01703794192910337},
{0.34849459617727235,0.3058308112438017,0.015846820448234794},
{0.41108634542064554,0.31176006133232786,-0.03956221644398552},
{0.38132503956462294,0.3053352937064459,-0.04243768500257271},
{0.4245932092094753,0.1406579931998125,0.11355293179299653},
{0.41052459080267184,0.09828826423323701,0.0737162554734404},
{0.41052459080267184,0.09828826423323701,0.0737162554734404},
{0.44381640181384163,0.08589276239567371,0.01995168589413757},
{0.4608317681289628,0.15863666210952493,0.06921327996167875},
{0.47434688290361354,0.15201753792875042,0.04929700454835593},
{0.4721369938679131,0.15791217971563892,0.046563865495179484},
{0.4590944772255601,0.16338602122566098,0.06633208155182707},
{0.43746039240313395,0.15088646528913402,0.06623559085653254},
{0.43496240644585343,0.15743087220941918,0.06468417632815086},
{0.4716203904779039,0.08097150774160201,0.12108585265343681},
{0.4661946797185038,0.07448921240902427,0.11955804511226496},
{0.47110607902840046,0.05006835712558572,0.13183803314833553},
{0.4782248462394412,0.05296766186543329,0.13495300948977965},
{0.46955443530596824,0.02901344566897731,0.14369332460867978},
{0.47135612973758423,0.04305387320755926,0.12185846579794482},
{0.4672134472733356,0.06464464035442566,0.1088553705322917},
{0.45398734619646736,0.09419577526606562,0.07376851171697284},
{0.44549891533915553,0.09881380619121886,0.10353852694691751},
{0.4578781443991276,0.0998527428225018,0.11269757959622882},
{0.46890489936662216,0.0879892003763366,0.11837425784101495},
{0.43746039240313395,0.15088646528913402,0.06623559085653254},
{0.43742761765390087,0.14171228583248432,0.052081712262913075},
{0.43074661107946954,0.11248844002507381,0.09457589359895395},
{0.43169776638937996,0.12789463491106695,0.10912306918337014},
{0.4339681626544337,0.09082616433442618,0.13100812149118232},
{0.4488877785710438,0.08993459947766673,0.04854158095764151},
{0.45211460160917133,0.1339286266807086,0.02803856877483175},
{0.44879816369726666,0.1402860112557198,0.02540719188011319},
{0.43305551194502084,0.14804720939053861,0.05025366051548034},
{0.43496240644585343,0.15743087220941918,0.06468417632815086},
{0.44303782962401855,0.06319063329754085,0.13788348462050623},
{0.4528475641829289,0.06285669756584457,0.1481777354023444},
{0.4468697249556795,0.060469412334994595,0.15583396266199723},
{0.4379242811615095,0.06429809894994744,0.14993519538219827},
{0.4392125809198244,0.09300694572570282,0.13986670074018218},
{0.4386120925073026,0.09739394904787059,0.13663552301509355},
{0.45615620949711383,0.08962564589748377,0.13013855926327864},
{0.45234792115266265,0.08390014931992393,0.12590511595500004},
{0.4578781443991276,0.0998527428225018,0.11269757959622882},
{0.4682897425348632,0.11936999139376338,0.10537230854561479},
{0.46890489936662216,0.0879892003763366,0.11837425784101495},
{0.4828992589010373,0.08763463718008806,0.11591500567828258},
{0.4716203904779039,0.08097150774160201,0.12108585265343681},
{0.48400420341888756,0.07891174080903206,0.11870933954296414},
{0.4782248462394412,0.05296766186543329,0.13495300948977965},
{0.4847875886837729,0.052077242978926734,0.1331982998385328},
{0.4848916427827365,0.04876470136588193,0.1340605278568179},
{0.47733717768154166,0.03089489963019539,0.1454895183830818},
{0.48293363800862454,0.02524366192502374,0.14602239455068222},
{0.46765418743260245,0.0074192406113521995,0.15568384055886675},
{0.4701180234763465,-0.005321198272335255,0.15520665854555749},
{0.4838020542662753,0.020828696928685112,0.13650121530145318},
{0.47028395996896705,0.0005021641648226011,0.14486060990828797},
{0.4712071536047067,0.022580197863223857,0.13381941571560685},
{0.48554232469233544,0.04191913346313355,0.12486663771181826},
{0.47135612973758423,0.04305387320755926,0.12185846579794482},
{0.4856734236892677,0.045916736093364476,0.12260220049207961},
{0.48829219491120435,0.0728241176315545,0.1038412922877348},
{0.43800266552680817,0.08502182500346654,0.12636396244426287},
{0.45234792115266265,0.08390014931992393,0.12590511595500004},
{0.45284389707811956,0.13159245172313813,0.11035200768258457},
{0.45417413934769074,0.09591404306327014,0.13555601903685782},
{0.45437491333599955,0.08960158052217279,0.13839687929380728},
{0.4392125809198244,0.09300694572570282,0.13986670074018218},
{0.4386120925073026,0.09739394904787059,0.13663552301509355},
{0.43169776638937996,0.12789463491106695,0.10912306918337014},
{0.4833539798973897,0.11350995790851258,0.0936389483201795},
{0.48783816149700376,0.08926901995478,0.0990085065371873},
{0.48829219491120435,0.0728241176315545,0.1038412922877348},
{0.47733717768154166,0.03089489963019539,0.1454895183830818},
{0.46403062949291957,0.006124523419621065,0.14793135179797},
{0.46765418743260245,0.0074192406113521995,0.15568384055886675},
{0.4701180234763465,-0.005321198272335255,0.15520665854555749},
{0.47028395996896705,0.0005021641648226011,0.14486060990828797},
{0.4712071536047067,0.022580197863223857,0.13381941571560685},
{0.4841749529865702,0.028087272510580158,0.09991290626077928},
{0.46987668214108486,0.004318474301044083,0.10713389401837907},
{0.4703433212280675,7.563403669159215e-06,0.09348034603717756},
{0.4839047332009355,0.023411943072781705,0.08416108674651024},
{0.46102910420651294,0.009528513458847624,0.09238136056464245},
{0.4428475985620364,-0.015730275273514456,0.09943480747126765},
{0.4429766348125135,-0.02372341778752108,0.10865322137967942},
{0.44364313111160253,-0.012312762785303627,0.1104856278140732},
{0.4609557621103271,0.0131344234566359,0.10360774355019294},
{0.4707806234765757,0.03221482816749042,0.0987550179172449},
{0.48661266090854816,0.032576954767408135,0.09867296644713695},
{0.486032570766528,0.027764567287362346,0.08251501507523867},
{0.469689659795811,0.027823928546462776,0.08640558408384834},
{0.4428475985620364,-0.015730275273514456,0.09943480747126765},
{0.4429766348125135,-0.02372341778752108,0.10865322137967942},
{0.44170323266748635,-0.009378391355717197,0.10391165486126311},
{0.44364313111160253,-0.012312762785303627,0.1104856278140732},
{0.4609557621103271,0.0131344234566359,0.10360774355019294},
{0.46102910420651294,0.009528513458847624,0.09238136056464245},
{0.4707806234765757,0.03221482816749042,0.0987550179172449},
{0.469689659795811,0.027823928546462776,0.08640558408384834},
{0.46764387370032645,0.05789716750532588,0.09178247651047473},
{0.4661240879509249,0.05594397580627601,0.06658557017176948},
{0.4711154759844744,0.03479715753538468,0.10562533877745602},
{0.4728495581711689,0.04013760810796872,0.11841436679986661},
{0.4663823896459295,0.0077543223133013815,0.11731583971543265},
{0.4677036933475279,0.012957714843638078,0.1283462617877365},
{0.45316110164412343,-0.011593093466479805,0.13130836569744322},
{0.45890103744686994,-0.019955925984073312,0.12689477586540807},
{0.4589904231265963,-0.027880997865057423,0.13922358223425235},
{0.4528475641829289,0.06285669756584457,0.1481777354023444},
{0.44303782962401855,0.06319063329754085,0.13788348462050623},
{0.4675020025830169,0.1419809012597651,0.025822491499765645},
{0.4641207027547978,0.1484382144408295,0.02366554628974942},
{0.4601808570253133,0.09041659456603823,0.032780593681349224},
{0.47897339400863825,0.0871450786880474,0.03596891211897922},
{0.4884358995809187,0.09521775153760557,0.07007527878591327},
{0.4468697249556795,0.060469412334994595,0.15583396266199723},
{0.4379242811615095,0.06429809894994744,0.14993519538219827},
{0.4713614012007476,0.05667808435028643,0.04575137258587042},
{0.4640929702746776,0.05490389320474018,0.052948524162209805},
{0.4678221866716783,0.033851044494587,0.06050642717416342},
{0.4720560883680581,0.031023248298520652,0.057197094277826724},
{0.4813664090907528,0.060510667264099136,0.04593679057279033},
{0.48993734980627374,0.06378034958968533,0.08667076160037038},
{0.4855867883381483,0.06126242375000428,0.06411531669460924},
{0.48829219491120435,0.0728241176315545,0.1038412922877348},
{0.47135612973758423,0.04305387320755926,0.12185846579794482},
{0.4672134472733356,0.06464464035442566,0.1088553705322917},
{0.46764387370032645,0.05789716750532588,0.09178247651047473},
{0.46764387370032645,0.05789716750532588,0.09178247651047473},
{0.4855867883381483,0.06126242375000428,0.06411531669460924},
{0.469689659795811,0.027823928546462776,0.08640558408384834},
{0.4661240879509249,0.05594397580627601,0.06658557017176948},
{0.4890505980245765,0.03736023460303016,0.12040262518865534},
{0.47693608809302523,0.009472819304556483,0.13168630668685102},
{0.4793561480731082,0.001371726392726289,0.11917804137640195},
{0.49009068062611216,0.03134182802882801,0.10533976299043228},
{0.4663823896459295,0.0077543223133013815,0.11731583971543265},
{0.45890103744686994,-0.019955925984073312,0.12689477586540807},
{0.4589904231265963,-0.027880997865057423,0.13922358223425235},
{0.45885084394979264,-0.012356768043015146,0.13921647721868435},
{0.45316110164412343,-0.011593093466479805,0.13130836569744322},
{0.4589904231265963,-0.027880997865057423,0.13922358223425235},
{0.45885084394979264,-0.012356768043015146,0.13921647721868435},
{0.4677036933475279,0.012957714843638078,0.1283462617877365},
{0.4728495581711689,0.04013760810796872,0.11841436679986661},
{0.49073127799748556,0.04150222948512701,0.11878474438560523},
{0.49125842431382166,0.034705709109202926,0.10399233116706756},
{0.4711154759844744,0.03479715753538468,0.10562533877745602},
{0.4672134472733356,0.06464464035442566,0.1088553705322917},
{0.4672134472733356,0.06464464035442566,0.1088553705322917},
{0.48993734980627374,0.06378034958968533,0.08667076160037038},
{0.48993734980627374,0.06378034958968533,0.08667076160037038},
{0.4711154759844744,0.03479715753538468,0.10562533877745602},
{0.46764387370032645,0.05789716750532588,0.09178247651047473},
{0.4803969182567958,0.03140027251172613,0.05976429683838266},
{0.4819698770259321,0.03336446552520388,0.0713138434352521},
{0.4704359156245021,0.035962150894487066,0.07071564696323612},
{0.4630588467184569,0.024130466421352623,0.06407681209411167},
{0.4657912981894815,0.019665766316037957,0.061993438174331866},
{0.4688890849771321,0.013308152546976176,0.06519780019550253},
{0.4784107226144622,0.026629827542936628,0.0610207386236668},
{0.4799747428156259,0.02921124013462857,0.07246348079296556},
{0.4704359156245021,0.035962150894487066,0.07071564696323612},
{0.4661240879509249,0.05594397580627601,0.06658557017176948},
{0.4855867883381483,0.06126242375000428,0.06411531669460924},
{0.45125718666594844,0.004291429403075546,0.06859239327865528},
{0.4490021464022836,0.009547765759096416,0.07276143305872065},
{0.46393253443927096,0.025102020001764782,0.0739543880919939},
{0.4532216088734768,0.006744722520492805,0.07906289428539014},
{0.449509352836219,-0.0035600711876721193,0.07611614637707233},
{0.449509352836219,-0.0035600711876721193,0.07611614637707233},
{0.47048702589778163,0.016216395854796388,0.07582231960422771},
{0.46393253443927096,0.025102020001764782,0.0739543880919939},
{0.4532216088734768,0.006744722520492805,0.07906289428539014},
{0.43301356943376457,0.3299541726495863,0.017825223492848558},
{0.4320003025361467,0.3223220107652445,-0.018187579286816868},
{0.4281713867271433,0.4039733080608693,-0.0017910369082639482},
{0.42578203874983805,0.3543725067984685,-0.05231113550754447},
{0.41108634542064554,0.31176074891447964,-0.03956221644398552},
{0.39114508785580937,0.32365202384076514,-0.05960615294348189},
{0.38132503956462294,0.3053359812885977,-0.04243768500257271},
{0.34655538531530794,0.32301486438015037,-0.046276226961700535},
{0.38132503956462294,0.3053359812885977,-0.04243768500257271},
{0.35640202011636174,0.3013358575238103,-0.01703794192910337},
{0.34655538531530794,0.32301486438015037,-0.046276226961700535},
{0.31651492110567786,0.3665470655712718,0.005100598998651207},
{0.34849459617727235,0.30583149882595345,0.015846820448234794},
{0.3397201311448357,0.3661182435026351,0.03299580689484463},
{0.3721614030343,0.3199496231476823,0.03760260731151942},
{0.3820692326468589,0.34785170686539313,0.04632939998143529},
{0.4103041061260131,0.32800189772673877,0.035709693647772295},
{0.4066629002444354,0.3899441110307658,0.03151498413404184},
{0.4026084574896604,0.4512331212906375,-0.05187543761739032},
{0.29760664112680957,0.41973933760627435,-0.06286918864160121},
{-0.2184074909783492,0.056297851420372816,0.11460378651490964},
{-0.2393773714421921,0.02849225839795649,0.12650995905448284},
{-0.22883169478686674,-0.0072496370139223994,0.12511577164479964},
{-0.2160504593621759,-0.0005537328262033057,0.12303766918818321},
{-0.22163568918078022,0.0263635040561617,0.11143357440727554},
{-0.22328451118065878,0.031662928893691766,0.12425102249195814},
{-0.2160504593621759,-0.0005537328262033057,0.12303766918818321},
{-0.21731263099872453,0.004618260119203816,0.13408963550124167},
{-0.20212921272989595,-0.019570650785046932,0.13680260547796697},
{-0.20773690356545726,-0.02807168731514068,0.1324841311769229},
{-0.20742680401502137,-0.035994008867517815,0.14481110399336253},
{-0.2184074909783492,0.056297851420372816,0.11460378651490964},
{-0.22328451118065878,0.031662928893691766,0.12425102249195814},
{-0.22640017510425464,0.0009103587689070678,0.1375832404142453},
{-0.20742680401502137,-0.035994008867517815,0.14481110399336253},
{-0.20773690356545726,-0.02807168731514068,0.1324841311769229},
{-0.22163568918078022,0.0263635040561617,0.11143357440727554},
{-0.24147243425855153,0.05487593153056932,0.09280330681176178},
{-0.21896007783429958,0.049538460480642824,0.09753937267296414},
{-0.21896007783429958,0.049538460480642824,0.09753937267296414},
{-0.22036274542385426,0.019423279010523434,0.09219112950266035},
{-0.23744068171478402,0.05246022623744732,0.07017749933247235},
{-0.21781571193974947,0.04761758514272486,0.07232000531730197},
{-0.21781571193974947,0.04761758514272486,0.07232000531730197},
{-0.23744068171478402,0.05246022623744732,0.07017749933247235},
{-0.23302548752439484,0.024659904678194355,0.07730887221629502},
{-0.22156991048826355,0.027537435983236734,0.07651769435368998},
{-0.23091094321373606,0.020556872784696246,0.07842390127237076},
{-0.22947664684520117,0.018012131241097233,0.06695594775750811},
{-0.2315989837535797,0.02273238271280953,0.06573411427386168},
{-0.2232959708831878,0.022557966040317512,0.06302710334245143},
{-0.2195649209337824,0.0049269845053362005,0.07097028155343145},
{-0.21667684670241327,0.011357252788432108,0.06771549684113301},
{-0.2190769668000958,0.025488670365094647,0.06626584447120921},
{-0.22156991048826355,0.027537435983236734,0.07651769435368998},
{-0.2140193416859285,0.015887502392212892,0.06975371953294836},
{-0.21475069990133194,0.01683980367237626,0.0796445887857643},
{-0.19946826980265245,0.0016531766868395543,0.07819837432659922},
{-0.20351194043705015,-0.0012504827399690442,0.08456905215654412},
{-0.19959982718768587,-0.01146222366359815,0.08155858830216485},
{-0.20166417800126746,-0.0036572494651183935,0.07406669317677851},
{-0.19959982718768587,-0.01146222366359815,0.08155858830216485},
{-0.2210546822625578,0.00779741079481058,0.08162047069582168},
{-0.20351194043705015,-0.0012504827399690442,0.08456905215654412},
{-0.21475069990133194,0.01683980367237626,0.0796445887857643},
{-0.20766516582762545,-0.02047115420977903,0.14480491575399684},
{-0.20742680401502137,-0.035994008867517815,0.14481110399336253},
{-0.20212921272989595,-0.019570650785046932,0.13680260547796697},
{-0.21731263099872453,0.004618260119203816,0.13408963550124167},
{-0.20766516582762545,-0.02047115420977903,0.14480491575399684},
{0.024623462824151985,-0.27601747833829726,0.04389077528325521},
{-0.007121059151546566,-0.273111985359084,0.06867031925585276},
{-0.015591842066963645,-0.3189047274710843,0.033904102917296466},
{0.016556290631807757,-0.31561877236790686,0.014762045006835731},
{0.041731423535707836,-0.2739742133773691,-0.006945381911776342},
{0.02684802027908957,-0.3107144780735781,-0.019088311905599547},
{0.022732153518758937,-0.3087635783150341,-0.05207094014253577},
{-0.005959045315101728,-0.3029830751653348,-0.06895360310237066},
{0.006243245937821923,-0.2604788092910684,-0.0646610277290422},
{0.032915703574166594,-0.2685354385570859,-0.04344843076563415},
{0.04418334148882161,-0.21747146247577703,-0.03249501789432548},
{0.014253807199672688,-0.20404229547009417,-0.050721216378665224},
{-0.04661669472383837,-0.2547734817899597,-0.04528014961787618},
{-0.04531739365109562,-0.3012407419928193,-0.05524802807168731},
{-0.05809977504603937,-0.25767851638107175,-0.008441560673968002},
{-0.059608788675063584,-0.3039388143562569,-0.02198647067519421},
{-0.043201015788032184,-0.3121781112805873,0.01423902418341024},
{-0.04516681315986401,-0.264183501924657,0.040072631594629086},
{0.02684802027908957,-0.3107144780735781,-0.019088311905599547},
{0.041731423535707836,-0.2739742133773691,-0.006945381911776342},
{0.049072050587710817,-0.2227711165073577,0.001856128018628894},
{0.06035275256324894,-0.15108380136668412,0.01909106223420652},
{0.055192448514421434,-0.14898323789311077,-0.023178508932265137},
{0.011501186652196859,-0.14407527649397278,-0.04808365124458096},
{-0.041515751934111306,-0.1998061018332086,-0.03357360509635891},
{-0.054731997666804574,-0.1982237461079985,0.004543886649790356},
{-0.046040271686627575,-0.20653913545712177,0.04892227227565628},
{-0.003179609063707942,-0.22634195981540708,0.07599856982912437},
{0.031221730346323643,-0.22985367105840662,0.05318711516886445},
{0.049072050587710817,-0.2227711165073577,0.001856128018628894},
{0.06035275256324894,-0.15108380136668412,0.01909106223420652},
{0.03864486725653573,-0.15020782170536415,0.0699874974645408},
{0.0942425308523841,-0.0020478488419397698,0.028710565731134768},
{0.0756509970514185,-0.0043902120388759035,0.09942999439620546},
{0.09121877374307115,0.08229235305509938,0.07724538546428411},
{0.09677947979826336,0.08962106201647216,0.03325089987314111},
{0.10035376101707148,0.10432867343629493,0.08011604094780907},
{0.1031279258053019,0.1132766383650213,0.03660790513199859},
{0.12323741180326438,0.10297963725457614,0.034318256566696036},
{0.12368388181379586,0.09371217581934005,0.07409305049259532},
{0.09774255319880402,0.11753598060101553,0.14313569548361663},
{0.12408565898446404,0.1089453291971447,0.14415079593363916},
{0.08848792663040049,0.19428619231901975,0.16249686290643267},
{0.12331281664590547,0.18811078782016974,0.16690495208125386},
{0.0005725267383509036,-0.14362720212508723,0.09956590646819989},
{-0.045490205965233566,-0.1413911849676206,0.06608844827605967},
{-0.030096158363921207,-0.003020777586655414,0.1261159744815344},
{0.016055272437238054,-0.004237339607138487,0.13574349977023295},
{0.0601964422207528,0.04848050074316169,0.12797725936630136},
{0.06523939891568291,0.1011550234179021,0.13128269596377817},
{0.07092639089274518,0.1280672180311543,0.12923072162892796},
{0.08677195077370178,0.1299521099031311,0.1387557971770169},
{0.04274766995598326,0.2138850339722881,0.15294520084847635},
{-0.05982789818741887,-0.1398615438740441,0.013100388140124682},
{-0.03737788254492492,-0.14024406874446352,-0.029400898211484196},
{0.024537515055184173,0.0001762502248966539,-0.06370253820951316},
{-0.03575954335377363,-0.0014095434110721439,-0.036054172305795246},
{-0.0761802061142097,-0.003967578209604843,0.028995683130057306},
{0.0942425308523841,-0.0020478488419397698,0.028710565731134768},
{0.07734863738407076,-0.00035708433080494976,-0.027481168843819136},
{0.07946180653042606,0.11381180647312755,-0.038215013814671406},
{0.03584526192869083,0.11754766949759515,-0.05316855045076738},
{-0.01752005161450021,0.11336487807449491,-0.03892345262501676},
{-0.056987496318570585,0.10750828250000286,-0.009220591251892295},
{-0.07839330386661825,0.09241608346330545,0.04236984356360077},
{-0.053881687739149677,-0.005696847321237243,0.09370518540079735},
{-0.05634300264833726,0.08365353652149896,0.1018573885859071},
{-0.02824770834598677,0.08073039560039098,0.13624956023391543},
{0.019803053552335866,0.07351926318696618,0.14527820146844625},
{0.02312063743449345,0.12193879831267337,0.14642990157261496},
{0.028789752275610408,0.1555299367539017,0.14569395947619992},
{-0.07188419283012254,0.16553081915099643,0.0574893166923173},
{0.09677947979826336,0.08962106201647216,0.03325089987314111},
{0.1031279258053019,0.1132766383650213,0.03660790513199859},
{0.10426312393782879,0.12817104293606743,-0.007138821690466531},
{0.09169687253258277,0.16157722177847705,-0.06218619037087032},
{0.039651716720737334,0.1732207379360846,-0.06604971448151148},
{-0.016406856110829093,0.1617094667456622,-0.03825260163896663},
{-0.054822987704885175,0.1682426431574689,0.004883093844649975},
{-0.043765291540562204,0.20971599419222273,0.013225528091741804},
{-0.06158444139107039,0.20715154196027374,0.06109293474959977},
{-0.0506860350919011,0.15551595591681627,0.1048852711881305},
{-0.0202887157455167,0.14262149863113852,0.13525164933768646},
{-0.04313913339437536,0.19473289152360182,0.11127657648262765},
{-0.013834611281160382,0.1806044534695968,0.13150088869993112},
{0.0023315910765588123,0.24683855456480056,0.13739553048681963},
{-0.012499326742476436,0.19529693808208123,-0.03962959949485629},
{0.005078481772770122,0.24588396134413137,-0.03635418731800556},
{-0.02368835109778222,0.27105542714322217,0.01607418094641101},
{-0.038643262898181714,0.27068596633368586,0.06549437729695413},
{0.014250140094863395,0.4438202981127015,0.07097899092735352},
{0.028875012462426474,0.4491832097022425,0.0313242946839586},
{0.032797210250016307,0.4086291560043684,0.036102303056417255},
{0.015462576622436013,0.39299491303804734,0.07310316138813668},
{0.029197488491593714,0.3755463699673283,0.03413925601319242},
{0.07728927612497032,0.4116270141859657,0.011981233591138472},
{0.0743931801018309,0.45478906698539906,0.0013124797306511443},
{0.014154795369821768,0.5315413414498587,-0.00028660716025134407},
{0.0038628365284893726,0.5152160784210362,0.04272051046098945},
{0.0032447001740728595,0.5180793996949427,0.07097349027013956},
{0.022913904400869538,0.45904290856417945,0.11783565182215},
{0.024501531589242984,0.3944502952592356,0.12079431782109798},
{0.007770365896842027,0.33642019520457284,0.118974058671385},
{-0.0021434227610319908,0.35003890569008606,0.06871019902065383},
{0.006950080389813219,0.3459409160657007,0.029018831729165976},
{0.03472427382729997,0.3409378391355717,0.014089818856482125},
{0.080024477924602,0.3687851454751937,0.012973185442052301},
{0.11929687849162808,0.40983311235206954,0.009868752026934909},
{0.1186354244616518,0.4560601771899205,-0.001910447008616562},
{0.06730558328166915,0.5245541316238512,-0.024514481053100792},
{0.11767968527072972,0.5164106378126636,-0.028256073928832958},
{0.06730558328166915,0.5245541316238512,-0.024514481053100792},
{0.08165748553499046,0.3302942966206483,-0.0059543468370648125},
{0.11983571370454363,0.36454459715134707,0.008377386339805407},
{0.12025055493609493,0.3120648894196004,-0.018335180255390895},
{0.08438489473690239,0.28399434807471263,-0.03656389987428703},
{0.1207579905640809,0.2478917012272195,-0.05099739520961511},
{0.12108413369805743,0.21755924379714947,-0.05613180033072698},
{0.0868672954987434,0.2217956666280856,-0.0638668703437796},
{0.05338319067913633,0.257246943983828,-0.05298634118055564},
{0.04279832184116162,0.22673044373114157,-0.06123365989665641},
{0.005078481772770122,0.24588396134413137,-0.03635418731800556},
{0.02263084974840221,0.28526408311493046,-0.021430675102535657},
{-0.02368835109778222,0.27105542714322217,0.01607418094641101},
{-0.0051472399879444125,0.3111435293362655,0.021944986552039084},
{-0.038643262898181714,0.27068596633368586,0.06549437729695413},
{-0.018605514638051043,0.31485280585086567,0.06653354312228764},
{-0.0236982064419572,0.2645332520458433,0.10655265790610607},
{-0.005888682741573411,0.3073774126971212,0.11138979834361458},
{0.0023315910765588123,0.24683855456480056,0.13739553048681963},
{0.012224752269880556,0.2878157004800469,0.14284209790482255},
{0.04274766995598326,0.2138850339722881,0.15294520084847635},
{0.041131164317236624,0.26539800119868484,0.15574572295252356},
{0.08848792663040049,0.19428619231901975,0.16249686290643267},
{0.08062679988952844,0.23916467936325309,0.16700694343376232},
{0.12331281664590547,0.18811078782016974,0.16690495208125386},
{0.12276000059590449,0.2370377585738629,0.17202858508198846},
{0.1219493412390001,0.3054109277431376,0.17461228961418618},
{0.07758058176325856,0.3096166385712959,0.16835024976421661},
{0.12108298772780451,0.376359092070688,0.17428500050995674},
{0.0730214537091046,0.38363141929561784,0.1664933195664107},
{0.12016254442067188,0.44784746677545734,0.16829799352068417},
{0.08117296931206257,0.4508070495506077,0.1657454593793654},
{0.11923637126227472,0.5191699049876062,0.1613971898517458},
{0.08571124070761368,0.5196741318988841,0.1629971935188506},
{0.04220264650370203,0.4567312573700211,0.14541800983930056},
{0.04649361751867642,0.5091557293355778,0.1530779042037627},
{0.01652787056953573,0.5164431833678461,0.1314007308998273},
{0.002083603113830349,0.5251864780094038,0.09798423832514157},
{0.030464244009153985,0.3128840289563763,-0.0030334978564626313},
{0.03805790129299821,0.3197188247387474,0.1493821501381467},
{0.043343116099392266,0.39205200871395773,0.14374030938904886},
{0.12282738364677526,0.11576683172458208,0.0039777773448557},
{0.12323741180326438,0.10297963725457614,0.034318256566696036},
{0.12236716199320893,0.13283743380589325,-0.0261362581550108},
{0.12180632415143763,0.1632601936918921,-0.04885809794149361},
{0.12108413369805743,0.21755924379714947,-0.05613180033072698},
{0.0868672954987434,0.2217956666280856,-0.0638668703437796},
{0.04279832184116162,0.22673044373114157,-0.06123365989665641},
{-0.0236982064419572,0.2645332520458433,0.10655265790610607},
{-0.04563299385874543,0.0037594700116774273,-0.047583779020264165},
{-0.0435597044771912,-0.10767123946996583,-0.046611537857700294},
{-0.07313605073439505,-0.11860471245887401,0.011529262923393046},
{-0.08318231355350479,0.006694987411516762,0.026722307342346003},
{-0.052885610395325376,-0.12190946147419905,0.086644175090503},
{-0.06040936349374245,-0.06238432862759749,0.09858335157335986},
{0.019805803880942836,-0.0037920155668599237,-0.07089441832268914},
{0.014003068908337255,-0.09003544485992232,-0.0705231239607482},
{0.0810877091252465,-0.013256583885595506,-0.03199285372950286},
{0.07217504008030956,-0.08279887190688304,-0.036094968846798636},
{0.09642789612467237,-0.013616189350956836,0.030387578599234716},
{0.0838203897903218,-0.08588290705149876,0.0208528769010214},
{0.0828217913119411,-0.004011125079215202,0.10820239668218691},
{0.07021703530619748,-0.08397555416256504,0.09753822670271126},
{0.038220629068910605,0.04022172232453188,0.15652910821740887},
{0.03155566607801992,-0.05569117476848536,0.12803776659565472},
{0.01638416589982155,0.02362578112197362,0.15992370130056163},
{-0.017710053482431723,0.013782813425729085,0.1570970510747482},
{6.829982707306808e-05,-0.06320553091082862,0.1350254348097632},
{-0.06313035526223812,0.0480344891207314,0.12419670350197048},
{-0.09042049086489813,0.028819547502185926,0.059618758616263846},
{-0.08544125011602949,-0.017706615571673,0.04315804190354828},
{-0.07213195159880041,-0.05293213678759327,0.0869027059795582},
{-0.013939352962275825,-0.08524437242658055,0.13138629167464072},
{-0.08591659857693415,0.13895897770285678,0.06384120061011456},
{-0.09625531300458502,0.09633598931038946,0.04597483678518675},
{-0.014858879493206132,-0.06943685875802036,0.14626121475138745},
{-0.03890133539913572,-0.04597678493461667,0.13786881620126903},
{-0.05894641786888497,-0.09650215499706058,0.13280156493697734},
{-0.06730902119242789,-0.023397962235696294,0.11678754742884383},
{-0.08026765281226832,-0.08199508837149605,0.11169577240114002},
{-0.08250710788049365,-0.07103090337981006,0.07215727754138958},
{-0.0876738293627374,0.004137869389186386,0.09343954949617418},
{-0.037424179743142244,-0.15878655501860484,0.08055013447960918},
{-0.017335550403782637,-0.14808181769217635,0.10329993594026285},
{-0.012503452235386896,-0.1123355675933364,0.12683793574086405},
{-0.06859938369719801,-0.10976423953987002,0.06719912264517437},
{0.02331522318343658,0.45848986332012787,0.13751448219907106},
{0.04323768683612508,0.45466392703378194,0.15406595975581666},
{0.046339828310736686,0.4906739794848405,0.15814378030375087},
{0.025026385965073096,0.49127102998660355,0.14096912412347598},
{0.02331522318343658,0.45848986332012787,0.13751448219907106},
{0.03639945314299529,0.41837173670645855,0.14562015899191288},
{0.04323768683612508,0.45466392703378194,0.15406595975581666},
{0.03639945314299529,0.41837173670645855,0.14562015899191288},
{0.02331522318343658,0.45848986332012787,0.13751448219907106},
{0.019119367699453237,0.4281668028461317,0.1299801861743273},
{0.03639945314299529,0.41837173670645855,0.14562015899191288},
{0.019119367699453237,0.4281668028461317,0.1299801861743273},
{0.01622258409416206,0.3883429613934081,0.12899648530923433},
{0.01622258409416206,0.3883429613934081,0.12899648530923433},
{0.019119367699453237,0.4281668028461317,0.1299801861743273},
{0.008535186443630275,0.4015429343485101,0.10958672874769516},
{0.02211837185130346,0.31510377333625167,-0.02639249710356016},
{-0.00021681757184948954,0.24060470558305241,-0.050782411190170317},
{-0.032752746604203666,0.2678762764676154,0.0033250326888014906},
{0.0006697050157971794,0.3293782080004767,0.006217461607131595},
{-0.04328788033320233,0.2632754350962557,0.06902809116880942},
{-0.06134034972720179,0.1803450058043393,0.018354661749690294},
{-0.01870681840840777,0.15158069406834335,-0.06126964336259759},
{0.05917148642655531,0.21603051947977533,-0.08442259715822295},
{0.06638078528757548,0.28925389314744165,-0.05569839438107865},
{-0.019599529235420125,-0.21097518630611384,-0.15097275684917766},
{-0.07509543067281062,-0.6167625652773305,-0.3086078409576644},
{-0.14162496289921306,-0.58289433122895,-0.2727602870884677},
{-0.06606701863233035,-0.18478632811649476,-0.1179000553503632},
{-0.01787117689999005,0.02518498824807504,-0.08925882081952917},
{-0.05943299683826808,0.0740427423984928,-0.027590036017845033},
{0.051826963075692456,-0.026912423807302816,-0.11526203182817776},
{0.12367219291721623,-0.043008034397443114,-0.12579349845236718},
{0.12596229987061994,-0.25272288261941295,-0.15715916266245558},
{0.04167481260521437,-0.23773817559243796,-0.16012882997583144},
{0.12988610201656384,-0.683055340049483,-0.3140007769678314},
{0.021930203535776596,-0.6642263612121156,-0.3181666080311886},
{0.05446131949306857,0.11468801532849808,-0.092582822135103},
{0.12091338413037471,0.2074125939838853,-0.0912266809378162},
{0.12032458461443253,0.27006210012800486,-0.07050341327239824},
{0.12201534912556737,0.10560390913372669,-0.10763628737725223},
{0.004164455899053751,0.3734006552657905,0.09440353967291716},
{-0.004273323073079686,0.3533081296275711,0.06071132665538268},
{0.0034958968535094546,0.3492225164819171,0.1120808184061158},
{0.015987660192316705,0.3991237911446294,0.12001620401937607},
{0.015700021658837757,0.3919869176035928,0.1318384915364367},
{0.07968481234164121,0.1890245844998355,0.17651276668160246},
{0.12366233757304125,0.15993779673467234,0.1676936088093025},
{0.12312831543518789,0.2151969407178128,0.1842212501847877},
{0.07427858307654046,0.23990039226561755,0.18560374869789129},
{0.033606723636667814,0.21261025666295752,0.15588942762223776},
{0.012668242757754473,0.2665595566470285,0.15003443640609976},
{-0.02350407908111523,0.24138213180262263,0.1337935167878912},
{-0.005687908753264603,0.3042649574902334,0.13261958486081618},
{-0.04093749534449586,0.2556409812714081,0.09833261328202442},
{-0.02165173276432092,0.3116154398864114,0.10004469283986325},
{-0.06534207785034317,0.2160697116624246,0.030718534808273443},
{-0.03339013525886896,0.3064973075428908,0.04295383000448076},
{-0.05915017137985134,0.20741465673034057,-0.015402413184158576},
{-0.02331980706444824,0.3015943884128655,0.011552182328451127},
{-0.02108791539989207,0.2520866399350005,-0.043682896279378346},
{-0.005439462402434977,0.2968599269100172,-0.025910731209239236},
{0.06634548940378601,0.25983981627804903,-0.0864427135200424},
{0.07069192537900099,0.3118065877245958,-0.07159231420670778},
{0.12042634677289045,0.24591169382425165,-0.09763746772661273},
{0.11986092505010752,0.2933110862308236,-0.09203573593636656},
{0.056398467608577786,0.16149860821912781,0.14940804906586233},
{0.08461454717558439,0.1352717038171123,0.15629189237505772},
{-0.07711738058703474,0.16331038718896934,0.03863443892723434},
{-0.05746742866048685,0.19789485264541498,0.0714408169392739},
{-0.07868025481794544,0.21453640346403885,0.025669619068028237},
{-0.05052605764459567,0.23885687175332299,0.07784908259351403},
{-0.055641210465458744,0.2595906823450676,0.04508510548083193},
{-0.0517002187657213,0.25152671886943156,0.008264393672869037},
{-0.059388533192455406,0.21852002525718434,-0.005271348566333929},
{-0.08287748546623228,0.17740948840449997,-0.003620463820000158},
{-0.1065392500541471,0.16824768542658167,0.013716690942136534},
{-0.02275690647622171,0.30253729273695507,0.10882030384255285},
{-0.020007494645454014,0.3290584822999164,0.07302981929195082},
{-0.057292553599893666,0.2901392697648354,0.06227626363274864},
{-0.026680708622165605,0.3353404620322865,0.02944169475248761},
{-0.039553850861139356,0.3045413655152339,0.014900019825285393},
{-0.05440745889118212,0.2593614882944868,0.00421888948606675},
{-0.07099216958526192,0.22569540339871852,0.00945826548234461},
{-0.06258899891476619,0.2414144481637545,0.04575137258587042},
{-0.06712451998171032,0.2052423555189354,0.05947505394654965},
{-0.052508586182119905,0.2311669529682348,0.09390343825454978},
{-0.03803841979869889,0.2710898062508093,0.10645639640486211},
{0.0673885515279794,0.2597797674367968,-0.09167819321746046},
{0.10343000356396746,0.22471330689197969,-0.11912303480426255},
{0.0880680431297364,0.21597276257902895,-0.11591156776752386},
{0.027030229549301333,0.22745217579642063,-0.08416223271676312},
{0.0034688519555409175,0.2793341454442525,-0.05775724453744629},
{0.10455672151662283,0.28773777450284943,-0.09783251186365702},
{0.09902214358319683,0.2693032386265317,-0.10137860221424373},
{0.06570626719671609,0.30527593244734547,-0.09144097737510927},
{0.06322822112183608,0.27664638681309106,-0.0977399174672224},
{0.0199449246696454,0.2931795288457902,-0.08214670023595526},
{0.03029716154628056,0.2599259932410674,-0.09006031241441032},
{0.09596629930680256,0.23926758749196386,-0.1163704142567867},
{0.10737993383167756,0.24669370392483347,-0.11854798693135521},
{-0.017003906612592167,0.2808814344797237,-0.06307660925737689},
{-0.043544348475802276,0.3180386031539393,-0.02881186950149146},
{0.010815208858808422,0.3234232881782854,-0.06092378954027112},
{0.05814767660261072,0.3421786957254163,-0.07223955820554809},
{-0.0007137102735087406,0.24596234570943004,-0.07384689608227148},
{0.23119468544835506,-0.2735025320212738,0.04215875584301583},
{0.23973399738489581,-0.31290167689827103,0.01289090477789378},
{0.27226900964104767,-0.3154003504377033,0.031490460370629705},
{0.2632699344390418,-0.26982030040464206,0.06640336090155773},
{0.2993728104805855,-0.30800746714216787,0.011366764341531218},
{0.3006024365619516,-0.2599741239916894,0.037173556048832095},
{0.31255811501645037,-0.2531661439132363,-0.011549431999844128},
{0.31496534012970084,-0.29937876952590065,-0.025127116750303397},
{0.30005672552751866,-0.2970361771349139,-0.05814389490077616},
{0.3003918072294679,-0.25054897704965373,-0.048189538895949346},
{0.26052831520599384,-0.29973883337936313,-0.07118801590148321},
{0.247368680403794,-0.25754352108527967,-0.06668274844921573},
{0.2322735018444391,-0.3062124193380188,-0.05382794173428844},
{0.22125981093782765,-0.2662425812750753,-0.045027577774136116},
{0.22875995704903487,-0.3082563718810987,-0.020781368357240183},
{0.21319218035738224,-0.27188694315872947,-0.008383116191069915},
{0.20893742200239962,-0.21546555614509358,-0.03387637043717618},
{0.20475600574360286,-0.22087591090310477,0.0005508679005710376},
{0.1920240470397869,-0.14948081817692177,0.01798703449255865},
{0.19642228087043312,-0.14726382412565334,-0.02436275459161629},
{0.15468237715485375,-0.0013121359395752885,0.028204276073401698},
{0.17058569393655673,0.0007778846076713447,-0.028262949750350375},
{0.1655143171793546,0.11485945247833254,-0.03893651668589986},
{0.14999123332756525,0.0902687644034136,0.032804888250710804},
{0.1431261839305175,0.113763446528455,0.03627259423599883},
{0.14089543823621423,0.12861705455849776,-0.007445941718244878},
{0.12282738364677526,0.11576683172458208,0.0039777773448557},
{0.12323741180326438,0.10297963725457614,0.034318256566696036},
{0.21319218035738224,-0.27188694315872947,-0.008383116191069915},
{0.22875995704903487,-0.3082563718810987,-0.020781368357240183},
{0.21455450979403473,-0.14806623249673684,0.06851263374905314},
{0.2583147590654841,-0.22315868364688987,0.07380609954126811},
{0.2529458884306281,-0.14055485587705113,0.09744998699323762},
{0.23468324809224597,-0.00157570909774325,0.13391040575368743},
{0.28062359117282026,0.0007618410241306861,0.12351072570858206},
{0.2983726076438507,-0.13720518482781222,0.06320518711975275},
{0.3002208284677346,-0.20232356928478848,0.046019071236948844},
{0.2236315109732381,-0.2275113078614705,0.05157381824682595},
{0.1920240470397869,-0.14948081817692177,0.01798703449255865},
{0.15468237715485375,-0.0013121359395752885,0.028204276073401698},
{0.17450835011224775,-0.0031867140792759393,0.09860122870930516},
{0.18914789089904802,0.05005025079558984,0.12689615102971158},
{0.22920413511906054,0.07606858861157681,0.1435223458469465},
{0.27690698044860146,0.08444540196625575,0.1336910670472816},
{0.30434242507932974,0.08804443614252659,0.09883340228254354},
{0.3039204788322104,-0.001340785195897893,0.09070503527869424},
{0.3250821947163895,0.0009172345904244934,0.02563134366158123},
{0.31177862605042495,-0.1353377117036796,0.009984724216528788},
{0.30796208672015285,-0.19380832272355872,0.001502939986683824},
{0.2941513116202529,-0.19571980110540288,-0.036387878843440975},
{0.2886352984049239,-0.1362751153705552,-0.03213426645871126},
{0.28352633382342657,0.002477587686778817,-0.03873115881657943},
{0.2227536977595135,0.0025892051894116836,-0.06536465346432534},
{0.23955728877189802,-0.1412990489592871,-0.04999581720857686},
{0.23822154584511288,-0.20131580304438457,-0.052599003235073986},
{0.20475600574360286,-0.22087591090310477,0.0005508679005710376},
{0.2087701103454756,0.11965281685218013,-0.05461843201474175},
{0.1517200440510965,0.16230789241172874,-0.06268950050594585},
{0.12180632415143763,0.1632601936918921,-0.04885809794149361},
{0.12236716199320893,0.13283743380589325,-0.0261362581550108},
{0.1564652776743221,0.08308651044036197,0.07669829926554768},
{0.14999123332756525,0.0902687644034136,0.032804888250710804},
{0.14684623256549503,0.104894553547179,0.07972618186777108},
{0.1765062346511609,0.12935253826681165,0.12834557420558476},
{0.18288035039186448,0.10258725703998173,0.13029647396412883},
{0.22472866289336854,0.12439323740034354,0.14473936625553072},
{0.26742820209872986,0.14612404211211483,0.1328393819553232},
{0.29698919235454485,0.15974871164294316,0.10197015205879285},
{0.3171397040875612,0.17026688501219883,0.05422742696445085},
{0.32517226797826776,0.09732885793750563,0.03898625179487591},
{0.3025434809763208,0.11188520128394504,-0.012235180599182011},
{0.26245262845467054,0.1167732228006825,-0.04127085809106564},
{0.2601746687859476,0.16507655654274525,-0.04057158704274353},
{0.20339413469505155,0.17521403859398613,-0.06742258684449066},
{0.15505344232274415,0.22262580747928942,-0.0644387094999788},
{0.12108413369805743,0.21755924379714947,-0.05613180033072698},
{0.2991381157727907,0.17255172050243917,0.0019154892777293326},
{0.2182319283356042,0.15783631648489665,0.14410541551162415},
{0.2599894799930783,0.18393808093529507,0.1292048227012123},
{0.28859816896872986,0.19877129069483612,0.10849507748477866},
{0.3058917768612562,0.2116251806335611,0.05801164993359103},
{0.28721544126157567,0.2137452256014338,0.010450446527309053},
{0.2554280599984185,0.19855882780994769,-0.04187615957864965},
{0.1990282172255372,0.22854451464148892,-0.06253823243256247},
{0.1431261839305175,0.113763446528455,0.03627259423599883},
{0.12323741180326438,0.10297963725457614,0.034318256566696036},
{0.12368388181379586,0.09371217581934005,0.07409305049259532},
{0.15019131973372232,0.11817451522593375,0.142695872100552},
{0.16078146003486038,0.1308530717159644,0.13813536888209457},
{0.20298112701590487,0.2158357045367816,0.15160166532397149},
{0.24231678514089122,0.24976032032160508,0.1353832067227199},
{0.2673874055577265,0.2680768212618736,0.10411197046147076},
{0.28148742354945944,0.27459578764254433,0.06278209490238053},
{0.26570168331570443,0.2745586582063502,0.013603698275200166},
{0.23668136182520969,0.24870327736032624,-0.038296148508577016},
{0.22449488496177614,0.44637993726958825,0.06921603029028572},
{0.22455585057923064,0.395540342163798,0.07135005609524386},
{0.2062276607423824,0.41074049159831905,0.034648066805481874},
{0.2090811266721138,0.45137705515440224,0.02981321830847914},
{0.16127789434841847,0.41264944884560684,0.011277149467754105},
{0.21059839128695892,0.3777546546446747,0.03261809509948742},
{0.2431260693334922,0.35302484578105314,0.066653640804792},
{0.2343907964837048,0.33917923318546495,0.1170738107980193},
{0.21628492487592005,0.3967850950525026,0.11918629236222286},
{0.21624985818618114,0.46139673146364457,0.11621479149644234},
{0.2336878583305734,0.5208849640681027,0.06904115522969255},
{0.23266588205903346,0.5180014737177452,0.04080192706357728},
{0.2212600401318782,0.5340627052002983,-0.002022981287451756},
{0.16294298912588823,0.45586696660528075,0.0005701202008198215},
{0.11929687849162808,0.40983311235206954,0.009868752026934909},
{0.15960340261487488,0.3697539487269989,0.012305772366760902},
{0.20558041674354213,0.34301777514459275,0.012657356040351937},
{0.2334710407587239,0.34869857888228933,0.02711950063200261},
{0.24629100997796294,0.31418218405886617,0.019754349816587472},
{0.260399737343618,0.31828384078806077,0.06409698117056277},
{0.24862260105452177,0.3105414365653896,0.10919755724980891},
{0.23152037019423044,0.29057382168473667,0.140966373794869},
{0.20503287215670452,0.32175154677334883,0.14798223287719897},
{0.1978946234513644,0.3939334626751758,0.14244444622706484},
{0.19748849159373516,0.45862164989921184,0.14411595843795086},
{0.19205155032585658,0.5109280869287195,0.15185744588441974},
{0.22146333525474343,0.5189381898024691,0.12968246310262277},
{0.23512834293847393,0.5280236711615439,0.09603035904393994},
{0.16789633094704123,0.5257787154361045,-0.025357915159238294},
{0.16789633094704123,0.5257787154361045,-0.025357915159238294},
{0.1186354244616518,0.4560601771899205,-0.001910447008616562},
{0.11767968527072972,0.5164106378126636,-0.028256073928832958},
{0.15859082329940877,0.33123101270537214,-0.006599528089449866},
{0.12025055493609493,0.3120648894196004,-0.018335180255390895},
{0.11983571370454363,0.36454459715134707,0.008377386339805407},
{0.21023443113463655,0.3150327231805716,-0.0045862875491477825},
{0.21842880602505316,0.2875940698331352,-0.02310539603012986},
{0.15647925851140754,0.28480477823756645,-0.037174014436933245},
{0.18784308916909132,0.25880271319917075,-0.05411924737257669},
{0.23668136182520969,0.24870327736032624,-0.038296148508577016},
{0.26570168331570443,0.2745586582063502,0.013603698275200166},
{0.28148742354945944,0.27459578764254433,0.06278209490238053},
{0.2673874055577265,0.2680768212618736,0.10411197046147076},
{0.24231678514089122,0.24976032032160508,0.1353832067227199},
{0.20298112701590487,0.2158357045367816,0.15160166532397149},
{0.2033900092021411,0.2673731955265905,0.15438522706827576},
{0.16609142779871716,0.31069430899712697,0.16760811942843587},
{0.16881585747797154,0.3847975586249731,0.16569022361317545},
{0.1590198745620961,0.4517547669497594,0.16509271472331122},
{0.1527612726228852,0.5204905211070531,0.16243520970682643},
{0.15505344232274415,0.22262580747928942,-0.0644387094999788},
{0.1990282172255372,0.22854451464148892,-0.06253823243256247},
{0.12108413369805743,0.21755924379714947,-0.05613180033072698},
{0.1207579905640809,0.2478917012272195,-0.05099739520961511},
{0.12016254442067188,0.44784746677545734,0.16829799352068417},
{0.12108298772780451,0.376359092070688,0.17428500050995674},
{0.11923637126227472,0.5191699049876062,0.1613971898517458},
{0.1219493412390001,0.3054109277431376,0.17461228961418618},
{0.16473895370623967,0.24018871838124822,0.16630171334012508},
{0.12276000059590449,0.2370377585738629,0.17202858508198846},
{0.12331281664590547,0.18811078782016974,0.16690495208125386},
{0.15789819887855347,0.19513123078351127,0.16191493921200792},
{0.12408565898446404,0.1089453291971447,0.14415079593363916},
{0.15789819887855347,0.19513123078351127,0.16191493921200792},
{0.12331281664590547,0.18811078782016974,0.16690495208125386},
{0.2930761623289782,0.00788358775782897,-0.05042395169506186},
{0.33178359956132253,0.011746653480368947,0.023242912460478344},
{0.3245369420700577,-0.11376275894630326,0.008194718681492496},
{0.29373280328389234,-0.10356431127760785,-0.0494397924418678},
{0.22745905161793806,-0.0012640051889533143,-0.07263583471900233},
{0.2353648711986734,-0.08733989363104112,-0.0723793665764024},
{0.16708658836633916,-0.012209625462542251,-0.032714127406680754},
{0.177619430154832,-0.08151423925337746,-0.03697919949393953},
{0.15280779901515312,-0.012929753169467234,0.029914522078835885},
{0.1670091207772428,-0.0848694109598303,0.02015521021105335},
{0.16747873938688296,-0.002979751851601445,0.10749258270753806},
{0.1818457684475426,-0.08261666263667128,0.0966021982001391},
{0.22031301031487818,-0.05339258763521017,0.12645495248234345},
{0.21179386745478856,0.042334662276836604,0.15507395519027115},
{0.2520866399350005,-0.06013753934975356,0.13291226566340789},
{0.2340816137094713,0.026276868705042145,0.15809839988173585},
{0.26835300009282353,0.017265417024304872,0.15469853533541975},
{0.266563682139939,-0.0818293810729261,0.12903453152163075},
{0.3231984488146656,-0.04811860333729458,0.08358810162005813},
{0.3123683423425694,0.052606452041717884,0.12104826482914155},
{0.3349111815755486,-0.012589170810304114,0.039633495793716195},
{0.3390314030228403,0.0340483805721371,0.05601812008163893},
{0.34299164702282653,0.10168331570449092,0.042291917586403306},
{0.3319192824392664,0.14404639804359953,0.0603379695469865},
{0.3119069747187502,-0.05785178708331089,0.09546172860444888},
{0.30563530871865624,-0.11754491916898821,0.08363783672903417},
{0.31184875942990264,-0.09198817817087103,0.12969254764084834},
{0.29066756205142424,-0.041964513885148574,0.13510542353341592},
{0.26734729659887485,-0.06600123993981365,0.1438950153731909},
{0.26571176785392997,-0.10894853791385282,0.1245051986940523},
{0.27101715173677515,-0.14457148161348027,0.10088216790068563},
{0.290976057243506,-0.15478849400027272,0.07779659715593101},
{0.33245399215927146,-0.0769704672006124,0.10823517143141997},
{0.3207206319338362,-0.10502473576790894,0.06393471178275154},
{0.33376246099403745,-0.06596319372741723,0.06866711053914462},
{0.31815961761264594,-0.018705443244104277,0.11355545292755291},
{0.33745386037269237,0.009313529439402803,0.08987489442749046},
{0.21619210128543478,0.4608379563683286,0.13589728897817271},
{0.21374155849662452,0.4935684711496259,0.13938676839826591},
{0.19273982005975082,0.4924564216162076,0.1569162169688399},
{0.19664895378645758,0.4565316293519652,0.152779722743957},
{0.21619210128543478,0.4608379563683286,0.13589728897817271},
{0.20422633829271056,0.42041500166738666,0.14421290752134655},
{0.2209980713320643,0.4306244506505099,0.12828735891673723},
{0.20422633829271056,0.42041500166738666,0.14421290752134655},
{0.21619210128543478,0.4608379563683286,0.13589728897817271},
{0.19664895378645758,0.4565316293519652,0.152779722743957},
{0.20422633829271056,0.42041500166738666,0.14421290752134655},
{0.2248464686353671,0.3908828898619449,0.1272472763152014},
{0.2209980713320643,0.4306244506505099,0.12828735891673723},
{0.2248464686353671,0.3908828898619449,0.1272472763152014},
{0.23188387195845167,0.40426209256460116,0.10771421335444974},
{0.2209980713320643,0.4306244506505099,0.12828735891673723},
{0.21813085375929805,0.3174899125968488,-0.028036047640275338},
{0.23976952246273586,0.33228897244285327,0.004212701246701068},
{0.274626041257221,0.27161832773144867,0.0007477455900199618},
{0.24186091817428598,0.2435516826854208,-0.05281192450806362},
{0.30558374005727557,0.18481199785015978,0.015277960814693192},
{0.2863701736030336,0.26728885211597675,0.06626401091880457},
{0.24504144401419622,0.35634334643941307,0.058620847720034897},
{0.23668319537761434,0.3762312017904639,0.09245401507867658},
{0.23823621426435004,0.3520803370986096,0.1101124998997276},
{0.22466815566401524,0.401664407195318,0.11826653663724196},
{0.22532777614158686,0.3945389933568104,0.13008080236253228},
{0.2705479915152362,-0.20744284759856202,-0.15340542250204267},
{0.3169123435893851,-0.18012383354552883,-0.12111106399900066},
{0.3995319857487139,-0.5763063774390543,-0.2772976417078165},
{0.33325479617200093,-0.6117913463202322,-0.3120315416852409},
{0.20979850405043182,-0.23569147272075108,-0.1615383733869036},
{0.23726672343039312,-0.6616050688556225,-0.3199721987616645},
{0.12988610201656384,-0.683055340049483,-0.3140007769678314},
{0.12596229987061994,-0.25272288261941295,-0.15715916266245558},
{0.19527103915436558,-0.025166194335927435,-0.1164646130115754},
{0.12367219291721623,-0.043008034397443114,-0.12579349845236718},
{0.1895712123104708,0.11633294102951673,-0.09371572832712405},
{0.12201534912556737,0.10560390913372669,-0.10763628737725223},
{0.12091338413037471,0.2074125939838853,-0.0912266809378162},
{0.18253289221118393,0.2175324280932315,-0.08545694990849426},
{0.12032458461443253,0.27006210012800486,-0.07050341327239824},
{0.17402589663577508,0.29056419553461227,-0.05660096055226598},
{0.2641064927236618,0.028617856737674793,-0.09162318664532106},
{0.3054945835715996,0.07848521068090113,-0.030649776593099174},
{0.26233413513052023,0.15500210285541405,-0.06362598739661915},
{0.1670604602445729,0.19008850328263174,0.1757802624959461},
{0.1713782469634653,0.24108257517851348,0.18478965143022816},
{0.12312831543518789,0.2151969407178128,0.1842212501847877},
{0.12366233757304125,0.15993779673467234,0.1676936088093025},
{0.1631022789910419,0.1362272138139838,0.15563387625584013},
{0.19055239204100735,0.16313161582951627,0.14828316466561162},
{0.2121986241481143,0.2147843914267673,0.1543921028897932},
{0.23171380997292068,0.2694194400101762,0.14814450226501022},
{0.26821112897551397,0.24509943010899318,0.1312881966209921},
{0.24885225349320375,0.3075259304418976,0.13037737946398387},
{0.28469568186948996,0.2597089464751674,0.09551260968367783},
{0.2640842609007555,0.31519934725534393,0.09751897440246245},
{0.3089210346277831,0.22061256693898737,0.02750890132393945},
{0.27498633430473407,0.3102570067486187,0.040232379847883915},
{0.30217035306197515,0.21171937938834978,-0.01848988623953301},
{0.26451399974559453,0.3050490303372705,0.009016379352824778},
{0.26256378756920223,0.25539482686108433,-0.04613183470983458},
{0.24612965736635403,0.2998073624004867,-0.028122453797344328},
{0.17426425844837914,0.2609323843171678,-0.08735032196034255},
{0.16890318041124286,0.3128061029791788,-0.072467606285876},
{0.12042634677289045,0.24591169382425165,-0.09763746772661273},
{0.11986092505010752,0.2933110862308236,-0.09203573593636656},
{0.3222062677697012,0.21939485894825136,0.022226895234253526},
{0.30217424936083503,0.20233113268845765,0.06838015958781743},
{0.32210840191010315,0.16817228058394057,0.03525955653243154},
{0.35097974726772035,0.17377561673254083,0.009821767246565836},
{0.3268151309328312,0.18232455481920598,-0.0071032966126265236},
{0.30230786949232363,0.22284652134999877,-0.008373031652844322},
{0.29404588235698575,0.2556820070064621,0.005269744207979842},
{0.29840515319903316,0.2639114485866175,0.042009550516087714},
{0.29434589736919603,0.24312377739298638,0.0748764357574806},
{0.29959971259066054,0.29452375195244673,0.05914409773751093},
{0.26156381392651806,0.3325445238092509,0.07052220718454591},
{0.26555706186978795,0.3061686432743579,0.10628152134426894},
{0.28155801531703833,0.27509818100141753,0.10367398063081079},
{0.29678360529117376,0.2355165976601579,0.09089985022168795},
{0.31144789903543674,0.20988811892420894,0.056239292340449436},
{0.3058037663458331,0.2459114646302011,0.04256809641735319},
{0.31397820135384924,0.2303310822657665,0.006144119510945756},
{0.29649344562313845,0.26357247058580846,0.0011703794192910624},
{0.28072512413722756,0.30839686783410475,0.012075203151876568},
{0.2673511928977347,0.3389009916080598,0.026816964485235885},
{0.15312225325255005,0.21676554479998805,-0.11645682041385569},
{0.1375003867649603,0.2251288357056827,-0.11940838139723567},
{0.17313249822661098,0.2610676088070106,-0.09256448661105651},
{0.21438628136090837,0.22973357337590228,-0.08573289954539358},
{0.23711705971536384,0.2821791311941124,-0.0597161660877607},
{0.13519698655662293,0.2881115899993468,-0.09808898000625699},
{0.14111867324147997,0.2698164041057822,-0.10173133185808762},
{0.21990229457623736,0.2956137988570092,-0.0838230255219035},
{0.17677897557135205,0.27802888532619463,-0.098691531165234},
{0.17371075481622644,0.30659081871552774,-0.09234606468085298},
{0.18068948446236227,0.34367051980064695,-0.07326680594025137},
{0.22864765196425027,0.3260750633435057,-0.06275000773529921},
{0.28365284893934717,0.3220219957530342,-0.031554863898842885},
{0.25745413540555306,0.2842226253490911,-0.06537748833115788},
{0.2418405199037843,0.24891505266306294,-0.07588007650497408},
{0.210231451611979,0.26211640078246845,-0.09156863846128283},
{0.14465261630738585,0.2398602833067659,-0.11677837966682061},
{0.133026748091673,0.24700586622172457,-0.11876274175674945},
{0.09715146174235606,0.13458916393448256,0.15637784014402553},
{0.1305569530026139,0.13389103885641335,0.15649060361691128},
{0.12566984826207878,0.18356495302094944,0.1916991644730886},
{0.15542381990848278,0.1602481254791588,0.16790148781317932},
{0.16025591807687853,0.19718755980532254,0.17997657636803063},
{0.12416771045457199,0.22030155061234918,0.1883659953954915},
{0.10283432822650786,0.23858642277363762,0.18664108097082013},
{0.09402869280319218,0.19113614928783676,0.1781448575157886},
{0.09761030823161888,0.31074358571800187,-0.06732197065628566},
{0.12457407150625183,0.32859298918318675,-0.06269041728214815},
{0.12323099436984811,0.2969080576606392,-0.11765115061143239},
{0.15218553716782615,0.3184477145342261,-0.06497479438428735},
{0.17000537460048606,0.28855026741215845,-0.0890871544756441},
{0.16504171904705695,0.24217330966522768,-0.11911707575894742},
{0.1207162772468752,0.23173604179582702,-0.12497367133343948},
{0.0855602018282809,0.2483044797123156,-0.11792251636732011},
{0.07717857539853977,0.28735204091572186,-0.08614040656732631},
{-0.4438672828930706,0.27555771507283205,0.16086981434135933},
{-0.4404852954826999,0.32986157825315165,0.1886987851569349},
{-0.45866863467958086,0.32650869848720465,0.19574741898849787},
{-0.4532779906099197,0.2842524205756667,0.17854755146265913},
{-0.44796320977100074,0.2606628521136848,0.1622163293885217},
{-0.4360341178263694,0.27039466069539764,0.14495159994636855},
{-0.43910371374579854,0.24962761696631874,0.13510863225012404},
{-0.43198930122171886,0.34470556013307,0.16532901378946005},
{-0.4404852954826999,0.32986157825315165,0.1886987851569349},
{-0.4438672828930706,0.27555771507283205,0.16086981434135933},
{-0.4323947454971963,0.33952325345538675,0.15562906318077796},
{-0.4360341178263694,0.27039466069539764,0.14495159994636855},
{-0.44675512793038913,0.40747447637754214,0.20122951148434087},
{-0.4615443324322187,0.4098095053648597,0.20644413452315602},
{-0.4623141952481197,0.37740834243424703,0.20812871079492515},
{-0.4372328027109072,0.3723667609036204,0.19796372545761456},
{-0.4423660618617662,0.40973226696981396,0.1939592470058662},
{-0.4546290895380937,0.4228591270227807,0.18543185315995564},
{-0.4592333688202122,0.4366304807459807,0.19989674808021332},
{-0.44920589991325005,0.41783175552329005,0.19895751086093308},
{-0.4059695882414284,0.3961328087845495,0.12583750371007868},
{-0.3994721661015123,0.39052145084417894,0.11253599779056934},
{-0.3970754839145885,0.4196728713316059,0.10855214680337327},
{-0.4089630917360647,0.42108241474267805,0.11908017551680394},
{-0.4108747993119594,0.4510208875997996,0.12189101135312728},
{-0.3982209957793915,0.45437903882891006,0.11525928149957082},
{-0.4013453690769095,0.4559549771207038,0.10687352957691924},
{-0.3966187001717809,0.41916176859881066,0.09936146537508178},
{-0.40457700519009926,0.38658802254811064,0.10841142165631663},
{-0.42047046662762727,0.36413731932346494,0.1346032593685933},
{-0.414144252443495,0.36790068563400224,0.13775880305699023},
{-0.4137967942628145,0.38325783299317107,0.14292277421062705},
{-0.41265311595041615,0.3992908736075028,0.1289705863815187},
{-0.4212930440751619,0.4085379367722372,0.13033956244563802},
{-0.4108747993119594,0.4510208875997996,0.12189101135312728},
{-0.42383801481281147,0.4457840327380781,0.1312966768008636},
{-0.43102691540332994,0.4609928915465212,0.1420921749713221},
{-0.42003385196127074,0.4706479201212895,0.13571141260315164},
{-0.4362988369547903,0.4882759221336132,0.17031077567288508},
{-0.44524978140617427,0.4728300766768696,0.17348717601988486},
{-0.45040687673829355,0.4957371052562217,0.20656400301160982},
{-0.462495029354028,0.48738894115786535,0.21101013839882743},
{-0.4742160131007319,0.5173810454228228,0.24772610852567487},
{-0.4108747993119594,0.4510208875997996,0.12189101135312728},
{-0.4212930440751619,0.4085379367722372,0.13033956244563802},
{-0.4089630917360647,0.42108241474267805,0.11908017551680394},
{-0.41265311595041615,0.3992908736075028,0.1289705863815187},
{-0.41893326213038157,0.3869987382867515,0.14398096314215872},
{-0.4360533701266182,0.39567923375845004,0.15527862547743984},
{-0.42607242761192404,0.38594307048977616,0.15976326546515507},
{-0.4330165489564221,0.3919584975413207,0.17799840251746743},
{-0.44650255608664907,0.4021058349367367,0.1704372907888057},
{-0.4330165489564221,0.3919584975413207,0.17799840251746743},
{-0.4423660618617662,0.40973226696981396,0.1939592470058662},
{-0.4369323293105957,0.4038144765838168,0.19782345869865908},
{-0.42838751671684105,0.3883947592488393,0.18109733527537092},
{-0.4372328027109072,0.3723667609036204,0.19796372545761456},
{-0.44675512793038913,0.40747447637754214,0.20122951148434087},
{-0.44920589991325005,0.41783175552329005,0.19895751086093308},
{-0.41893326213038157,0.3869987382867515,0.14398096314215872},
{-0.42607242761192404,0.38594307048977616,0.15976326546515507},
{-0.42050645009356846,0.3824384642623446,0.1616903290424387},
{-0.4372655774601402,0.5115061143242843,0.20026506291949672},
{-0.43955958071240386,0.5215402298587133,0.19255497505795743},
{-0.4549364387599226,0.5475516918531829,0.2236678382302552},
{-0.4542463354736238,0.5304545032620043,0.24174093508880695},
{-0.4678595453019231,0.5570494933092526,0.2633731863588285},
{-0.46481447314590596,0.5760423458927852,0.25053373564529013},
{-0.46297289894948906,0.5806188926947833,0.2478143482351485},
{-0.45376502796740403,0.6191448082390677,0.24160593979301484},
{-0.4421930203535776,0.5655273812402377,0.21236444604370958},
{-0.42847392287391,0.5150384530318362,0.17687443489341903},
{-0.4362988369547903,0.4882759221336132,0.17031077567288508},
{-0.45040687673829355,0.4957371052562217,0.20656400301160982},
{-0.4742160131007319,0.5173810454228228,0.24772610852567487},
{-0.480279800096949,0.5420462215641806,0.2669140052462518},
{-0.48627872517685183,0.5808423568940997,0.2862009137966796},
{-0.4760413145195578,0.5867159128283347,0.28376412265090417},
{-0.4727837794786522,0.6008010332067799,0.2678608058692012},
{-0.4737759605236167,0.5766118931084786,0.24762274200886292},
{-0.4796279722170972,0.6007957617436166,0.2661487263113624},
{-0.4875113307808756,0.6422429846566042,0.29141989152245584},
{-0.49223341580499247,0.6311348658011534,0.30559462677467814},
{-0.4964377514688473,0.6990441462120525,0.3199721987616645},
{-0.4705777867418117,0.679881231642989,0.2614940243381162},
{-0.48066553368407655,0.6302873062021055,0.2699659532237862},
{-0.4602966000208567,0.6839448421597871,0.2512208594089314},
{-0.46632807065594184,0.6449944592338271,0.22614038364792124},
{-0.4473835780170818,0.5766222068407547,0.1968690946720405},
{-0.4361496316278622,0.5281611875918925,0.16330660548713474},
{-0.4147044027031146,0.48529227398315183,0.12217406600559462},
{-0.40779763998886115,0.4771306738419684,0.12703458423626238},
{-0.42003385196127074,0.4706479201212895,0.13571141260315164},
{-0.41399206759390933,0.48748451507695756,0.11815033525359747},
{-0.435220708140858,0.5357752431462384,0.1590009660529232},
{-0.41388847188304684,0.4892928561360403,0.11475322103588834},
{-0.39710000767800063,0.45755635595211214,0.09784053365542737},
{-0.42695344954235676,0.5550775076980551,0.14450788026444408},
{-0.4322324761093851,0.5464139725860996,0.1531122833113498},
{-0.412722103359641,0.49332071238094793,0.10217092604710165},
{-0.40991195510546935,0.4966676331015799,0.09235614921907857},
{-0.40120395634770106,0.4566790011264887,0.07843352742249518},
{-0.3914668763028249,0.46022165356631667,0.0910114677243208},
{-0.4045813598770603,0.4915864010002028,0.1119387180947557},
{-0.4240740846849097,0.5419957988730528,0.15902869853304347},
{-0.44351019856226576,0.6156470778331535,0.19979796544441297},
{-0.446710893478627,0.6189644325212605,0.19159533956817548},
{-0.43773817559243794,0.625017676591151,0.1808447634316308},
{-0.4441001440484607,0.634127681713638,0.15748415982617922},
{-0.4355237026757259,0.5646782172828357,0.1296148508577014},
{-0.4203911654861263,0.500273084711267,0.08166997661074714},
{-0.3987249934966188,0.45556122174180597,0.06170992513376339},
{-0.3964057788987913,0.4166346749971064,0.05812372582432505},
{-0.3808086653686643,0.4197876975509469,0.07813397079838601},
{-0.39257915503029367,0.41997357392596796,0.08069773544818323},
{-0.400913109097514,0.4585948341952939,0.09336345707138136},
{-0.46632807065594184,0.6449944592338271,0.22614038364792124},
{-0.45966814993416394,0.6756587896491382,0.2222688377455098},
{-0.4551844267226511,0.6913947947739172,0.21918824051165278},
{-0.45312122187932247,0.711043142342111,0.21173278724030878},
{-0.4515175511074083,0.7535178421838524,0.1846901812122761},
{-0.45575214038593986,0.7811481017575745,0.20993705185400796},
{-0.45662903682346206,0.8664667330565432,0.20096387557971768},
{-0.4021129399523047,0.35933891268050455,0.05432643879430179},
{-0.4097008673848844,0.35245804889396676,0.045636546366529425},
{-0.40696291525664574,0.4050608338308753,0.03832021388388801},
{-0.3958309602199346,0.40719394285963123,0.04763718123404953},
{-0.41067608807010586,0.45812223606299624,0.05087179686989687},
{-0.3867844418494584,0.3766501685149256,0.08634003458538224},
{-0.39509387215326663,0.3736809595896509,0.0770017521885167},
{-0.3851906264217193,0.41961878153566884,0.08720088743936386},
{-0.3922729517787177,0.4193155578067504,0.0958346273247439},
{-0.390420834655974,0.41884983549597016,0.09047148654115238},
{-0.39034015835016955,0.38008785007958756,0.09244851442146264},
{-0.3915713887898898,0.38188060594323087,0.10023584067804767},
{-0.40302696582602104,0.36462802378575854,0.05916403761991147},
{-0.3891247422999394,0.37053320849897375,0.06975188598054373},
{-0.4067829979269398,0.3424278296583977,0.08281846799820769},
{-0.42320085535219676,0.3342265789464637,0.08675418823478181},
{-0.41862362096804684,0.33429144086277807,0.0726915288732935},
{-0.41104990356660315,0.3324762239821778,0.06751197252421723},
{-0.4178940963050481,0.32479936925797276,0.07025588369777097},
{-0.41609331864963445,0.32450072941006597,0.06471145042017},
{-0.4112591577347835,0.35686522129258563,0.10508925389314742},
{-0.42843060519835025,0.3487061422859585,0.10313010314878245},
{-0.42526933165868874,0.3509607241615222,0.0934546763035125},
{-0.405785545418812,0.34731883069779274,0.08882289373532443},
{-0.4771577187399369,0.7556149677466671,0.26181627117323286},
{-0.46965092600126274,0.6860738256956325,0.23723773038299467},
{-0.44920589991325005,0.41783175552329005,0.19895751086093308},
{-0.4592333688202122,0.4366304807459807,0.19989674808021332},
{-0.433877860198505,0.352930876220315,0.11997724103077732},
{-0.4210209907371224,0.3583231246483303,0.13198838444551655},
{-0.4169621932953864,0.3360285025721302,0.12042623217586516},
{-0.4323947454971963,0.33952325345538675,0.15562906318077796},
{-0.41871644455853213,0.323684340201897,0.1340064380608808},
{-0.42318229063409973,0.3080058627838138,0.14310039959982718},
{-0.4360341178263694,0.27039466069539764,0.14495159994636855},
{-0.4204152308614373,0.28285135734446604,0.1364595019842475},
{-0.4136847183720805,0.23128796742694152,0.1164579663841086},
{-0.43910371374579854,0.24962761696631874,0.13510863225012404},
{-0.40431595316648766,0.15342731053387312,0.08890448681733121},
{-0.42430098679498474,0.1514243837258472,0.09225301189631718},
{-0.4008301408512038,0.09368031784630931,0.08143230238029482},
{-0.4210998334905222,0.09320909487831514,0.0858882931116874},
{-0.4164272543813307,0.057797238899272636,0.07414324398967252},
{-0.39528318643904636,0.058117422987934056,0.06879156290861002},
{-0.3978503889996023,0.006078455415454316,0.061950808080923826},
{-0.4128978951964365,0.010748742584139992,0.06709071385924964},
{-0.41432348219104925,0.0026838623323015695,0.0721593402878448},
{-0.39545439439483027,-0.00026334396411738833,0.06550537861138199},
{-0.41251032805690424,-0.013568746182486602,0.06780694526731473},
{-0.39905067824249413,-0.017492548328430498,0.062466723888781286},
{-0.4114092798379139,-0.08421460355732086,0.06767767982278718},
{-0.3975799400199169,-0.0964551702166915,0.06345179991817772},
{-0.41278925721646115,-0.09239774793925899,0.07231702579464443},
{-0.3943072781716732,-0.10668547585841766,0.06722983464795222},
{-0.4112307376725115,-0.11061432027347433,0.06789105948387791},
{-0.3976111104107959,-0.12117489454208748,0.06387764246415692},
{-0.41184451933996696,-0.2928265700078957,0.0776677900995046},
{-0.39899704683465825,-0.3231739250512535,0.07664718899226813},
{-0.41400008938567967,-0.30618789557460663,0.08590319072497515},
{-0.39568037972870296,-0.34084616151533936,0.0842655992335751},
{-0.41213651256040695,-0.33234741692575137,0.0809060728401612},
{-0.399075889588058,-0.366007313582154,0.08026914257359707},
{-0.38627975655007946,-0.400947029817,0.06021878864068447},
{-0.3923158110661763,-0.4189616821926536,0.06211536940924087},
{-0.39972198761664546,-0.4284090609575956,0.04317958614430286},
{-0.40190162303766913,-0.4395623310410108,0.05144546957850068},
{-0.40083632909056943,0.3821778706268342,0.10342713863833523},
{-0.43224301903571183,0.3553807314269736,0.11499502075925112},
{-0.4210209907371224,0.3583231246483303,0.13198838444551655},
{-0.38392112057555206,0.01776826877127922,0.04445115473692533},
{-0.3993793425110271,0.01909278118958587,0.02531413909557737},
{-0.4015064924944678,0.08689090248595326,0.026241687418278013},
{-0.38664555025480646,0.09023186416127009,0.05429939389633324},
{-0.40522012369602906,0.1287621343925154,0.03478947953469025},
{-0.3918934064309559,0.1254844302751589,0.04346653709563007},
{-0.3949228933915333,0.17708861673368678,0.04981085760975818},
{-0.4081661840221951,0.18254756063042113,0.04116222011109036},
{-0.40082211905943343,0.2631138532905963,0.06778517183250957},
{-0.4146196009043997,0.26669776065952877,0.059381313579862094},
{-0.4085782749251395,0.3103234730232872,0.09460591801958003},
{-0.42379653068965634,0.31413061539748544,0.08820384060470557},
{-0.4312478584680899,0.3377525002205992,0.11155733919458918},
{-0.39090810120750885,0.16350726487841827,0.06819817951165623},
{-0.3964165510191686,0.24897258036975872,0.09035574354560903},
{-0.406218034592258,0.29794859865027623,0.11452631892581333},
{-0.3834258322322469,-0.04534168822045718,0.0396703960358597},
{-0.3797892102316808,-0.05248704194136529,0.04223301471540402},
{-0.38528597114676094,-0.06850770607696566,0.04457652388259307},
{-0.38965761846753977,-0.14535280413191035,0.04594664591696528},
{-0.38557200532188585,-0.16107666197200854,0.045191680714352034},
{-0.3901409887202148,-0.17627589463032717,0.04732868604196774},
{-0.3924881649922131,-0.3789647992317415,0.059478950245409536},
{-0.4020295133178933,-0.40104627084090144,0.04962475204068654},
{-0.41276037876608795,-0.4104562909755988,0.0875781408466199},
{-0.39935917343457594,-0.43906910544416083,0.0864323997877663},
{-0.399075889588058,-0.366007313582154,0.08026914257359707},
{-0.41213651256040695,-0.33234741692575137,0.0809060728401612},
{-0.41157132003167457,-0.5728668623219877,0.09343725755566837},
{-0.39897962808681414,-0.5777617596602427,0.09042220982027747},
{-0.40054112715342133,-0.4742767495241358,0.0883745901723883},
{-0.412987280876163,-0.44608771485509774,0.09049669788671624},
{-0.3970023710124532,-0.45451861800571375,0.09221038180290916},
{-0.38556123320150854,-0.5177376713655266,0.06814844440268021},
{-0.39189959467032154,-0.5355499453945174,0.07007482039781213},
{-0.38968191303690136,-0.6207147874855464,0.06880554374569545},
{-0.3959086570030815,-0.5885068351395734,0.09386837156481093},
{-0.4129308991397201,-0.583352490136061,0.09883271470039182},
{-0.4011418447599937,-0.830593738647732,0.07309651476066985},
{-0.3898980430265991,-0.8321788447015492,0.07032785062965337},
{-0.3991375427876643,-0.6081682467686503,0.08870256685876948},
{-0.4107336157768016,-0.6003499793152369,0.09222619619239925},
{-0.3857349622918488,-0.6386205726871741,0.06767790901683773},
{-0.38911465776171383,-0.6577305434305535,0.0666080311887264},
{-0.3799024320926677,-0.835420794547015,0.054504980959704255},
{-0.3733600879188378,-0.9991673380142396,0.052254524577051036},
{-0.3921668349332988,-0.998604437426013,0.05224535681502779},
{-0.36648243284900806,-0.9979473380829977,0.03242213418624079},
{-0.3843634650931731,-1.0,0.025111073166762737},
{-0.3913827620862617,-0.8414987915743681,0.039731590847364794},
{-0.397730291317098,-0.6912426099243315,0.052522452422180024},
{-0.3971854970588673,-0.676643178096383,0.049713450138261325},
{-0.3991052264265324,-0.6533611880502805,0.0549610771203601},
{-0.4015055757182655,-0.5654893350278413,0.05786519493526986},
{-0.39946941577290535,-0.5565108872903877,0.050203696212453734},
{-0.40184180339046754,-0.5347292014993874,0.05712375218164086},
{-0.3913637389800635,-0.499445235800569,0.06889378345516907},
{-0.40190162303766913,-0.4395623310410108,0.05144546957850068},
{-0.3923158110661763,-0.4189616821926536,0.06211536940924087},
{-0.39923380428890826,-0.0693658086023403,0.029045189044982767},
{-0.39772593663013694,-0.08914181725670765,0.02438727835502846},
{-0.3997160285713303,-0.10105188609514074,0.03080860807015173},
{-0.40094634223484826,-0.18032277398143298,0.03572963353017282},
{-0.3991762765822125,-0.20500651484088775,0.030267710110780954},
{-0.40133986841969554,-0.21172763037417072,0.03781231986780088},
{-0.433877860198505,0.352930876220315,0.11997724103077732},
{-0.4147722441420865,-0.4227626363274862,0.09531664877043121},
{-0.45662903682346206,0.8664667330565432,0.20096387557971768},
{-0.45980085328945025,0.7811451222349169,0.20892447253854182},
{-0.46058767646509435,0.7110374124908465,0.20986531411617615},
{-0.46310743585718006,0.6913886065345516,0.2172063995562803},
{-0.46446976529383244,0.6756551225443289,0.2210678609204662},
{-0.4771577187399369,0.7556149677466671,0.26181627117323286},
{-0.477047247207557,0.6798761893738762,0.2598756851469649},
{-0.4729962423635406,0.5806111000970636,0.24530719451584473},
{-0.4737759605236167,0.5766118931084786,0.24762274200886292},
{-0.36648243284900806,-0.9979473380829977,0.03242213418624079},
{-0.3921668349332988,-0.998604437426013,0.05224535681502779},
{-0.3843634650931731,-1.0,0.025111073166762737},
{-0.3921668349332988,-0.998604437426013,0.05224535681502779},
{-0.36648243284900806,-0.9979473380829977,0.03242213418624079},
{-0.3733600879188378,-0.9991673380142396,0.052254524577051036},
{-0.45064157144608835,0.2755334205034705,0.1591680485157966},
{-0.4532779906099197,0.2842524205756667,0.17854755146265913},
{-0.45866863467958086,0.32650869848720465,0.19574741898849787},
{-0.46983038494286755,0.32982101090619886,0.1813560953584767},
{-0.4775821861216125,0.37233513212464026,0.1878709362462369},
{-0.4623141952481197,0.37740834243424703,0.20812871079492515},
{-0.4710072963926002,0.4074554532713439,0.19516320335356732},
{-0.4615443324322187,0.4098095053648597,0.20644413452315602},
{-0.46742820209872993,0.41781754549215405,0.194399528777032},
{-0.4592333688202122,0.4366304807459807,0.19989674808021332},
{-0.45064157144608835,0.2755334205034705,0.1591680485157966},
{-0.46983038494286755,0.32982101090619886,0.1813560953584767},
{-0.46282758992142087,0.3446654511742184,0.15761434204690913},
{-0.4775821861216125,0.37233513212464026,0.1878709362462369},
{-0.47476011977681076,0.38835831739479704,0.16949782437547486},
{-0.47735390884723405,0.40378284780483664,0.18771256315728554},
{-0.4710072963926002,0.4074554532713439,0.19516320335356732},
{-0.46742820209872993,0.41781754549215405,0.194399528777032},
{-0.47033965412325834,0.40971026434095814,0.18696195264163332},
{-0.46891956778585947,0.39193030667309936,0.169017662839508},
{-0.46393941026078833,0.3859132752632007,0.15029136293680087},
{-0.46987141067792154,0.38239973046779646,0.1493424995673962},
{-0.46050929209979574,0.386966192731569,0.13358128309705336},
{-0.46428549327716556,0.3832181824224206,0.13029372363552186},
{-0.4566702917525667,0.39925649449991574,0.11796033338566597},
{-0.4605070001592898,0.3960899494970909,0.11219587381950738},
{-0.4535860274139003,0.4210473480529392,0.10791842525351726},
{-0.45737895975696263,0.41962565735718627,0.09346796955844619},
{-0.45327042720625055,0.4509876544624654,0.11128620263275205},
{-0.4599952098443429,0.45433067888423745,0.09980724780346152},
{-0.4586443401102194,0.4770907940771673,0.11431614798143068},
{-0.4535429389323912,0.4706215628054727,0.1273295569793599},
{-0.47054088649966813,0.5150054490885525,0.1663519068372023},
{-0.4602883490350356,0.48825712822146555,0.16431024623462823},
{-0.4771703244127188,0.5114749439334053,0.19028343282265078},
{-0.46998898722586946,0.4957217492548328,0.20166589695664677},
{-0.48742240348925026,0.5304286043342886,0.23344227690537608},
{-0.4742160131007319,0.5173810454228228,0.24772610852567487},
{-0.480279800096949,0.5420462215641806,0.2669140052462518},
{-0.4885154299164702,0.5570334497257119,0.2582064648765847},
{-0.48627872517685183,0.5808423568940997,0.2862009137966796},
{-0.4934389765110476,0.5867023903793505,0.27941241521252586},
{-0.49223341580499247,0.6311348658011534,0.30559462677467814},
{-0.486472164955542,0.6007904902804533,0.2644368759475741},
{-0.48762569861211535,0.6422429846566042,0.2913912422661333},
{-0.4964377514688473,0.6990441462120525,0.3199721987616645},
{-0.4875113307808756,0.6422429846566042,0.29141989152245584},
{-0.4796279722170972,0.6007957617436166,0.2661487263113624},
{-0.4737759605236167,0.5766118931084786,0.24762274200886292},
{-0.4831467884756648,0.5760281358616492,0.24594825027531933},
{-0.4757591766432926,0.5475351898815409,0.21845917423675515},
{-0.48301958577759235,0.5806030783052932,0.242800040796541},
{-0.4729962423635406,0.5806111000970636,0.24530719451584473},
{-0.4737759605236167,0.5766118931084786,0.24762274200886292},
{-0.47033965412325834,0.40971026434095814,0.18696195264163332},
{-0.46742820209872993,0.41781754549215405,0.194399528777032},
{-0.4592333688202122,0.4366304807459807,0.19989674808021332},
{-0.4546290895380937,0.4228591270227807,0.18543185315995564},
{-0.4530719451584475,0.4021005634735733,0.1687939694461411},
{-0.46891956778585947,0.39193030667309936,0.169017662839508},
{-0.45292411499582286,0.39566616969756696,0.1510587046181455},
{-0.46393941026078833,0.3859132752632007,0.15029136293680087},
{-0.46050929209979574,0.386966192731569,0.13358128309705336},
{-0.45031749105856705,0.4085150173671791,0.12307938250538891},
{-0.4566702917525667,0.39925649449991574,0.11796033338566597},
{-0.4535860274139003,0.4210473480529392,0.10791842525351726},
{-0.45327042720625055,0.4509876544624654,0.11128620263275205},
{-0.4581066508675567,0.3904753828400122,0.09786941210580054},
{-0.45225120126331764,0.4191184509232509,0.0854457194000158},
{-0.4522816840720449,0.45591509735590274,0.09413263230513061},
{-0.44975115255958187,0.4852647706970822,0.11340762276492826},
{-0.45569988414240736,0.5281456023964529,0.15841652122394206},
{-0.4795674649877438,0.5654980444017633,0.20301562072051732},
{-0.4704608977760154,0.5215159352893517,0.18482540570211878},
{-0.45327042720625055,0.4509876544624654,0.11128620263275205},
{-0.45031749105856705,0.4085150173671791,0.12307938250538891},
{-0.4482572657378959,0.44576500963187987,0.12518865535288434},
{-0.4602883490350356,0.48825712822146555,0.16431024623462823},
{-0.4535429389323912,0.4706215628054727,0.1273295569793599},
{-0.4482847690239657,0.4609791399034864,0.13777530502863208},
{-0.4551809888118924,0.4728222840791498,0.1710029417056392},
{-0.46998898722586946,0.4957217492548328,0.20166589695664677},
{-0.462495029354028,0.48738894115786535,0.21101013839882743},
{-0.4742160131007319,0.5173810454228228,0.24772610852567487},
{-0.4835167076733023,0.6798709179107129,0.2582573459558137},
{-0.48662389141702656,0.6191191385054026,0.2333868119451355},
{-0.48066553368407655,0.6302873062021055,0.2699659532237862},
{-0.4610944245109285,0.3678596598989483,0.1260144415171271},
{-0.45672323557825084,0.3394884159596985,0.14954144000330039},
{-0.45387916660459326,0.3641054613504342,0.126245239926062},
{-0.48602844527361755,0.683924673083336,0.24478440288646985},
{-0.4771577187399369,0.7556149677466671,0.26181627117323286},
{-0.46965092600126274,0.6860738256956325,0.23723773038299467},
{-0.46632807065594184,0.6449944592338271,0.22614038364792124},
{-0.46570557961456444,0.5766079968096188,0.1922863596306767},
{-0.4538055953143568,0.5357605747270011,0.1543522231249921},
{-0.4702610405639091,0.6156259919805,0.1931066451377055},
{-0.46321446947880124,0.541965086870275,0.1492384454684325},
{-0.45267108476398166,0.5463981581966095,0.14799988081909368},
{-0.46257043419666904,0.6189520560425292,0.18762844894072236},
{-0.46927138065350094,0.6756514554395195,0.21986688409542263},
{-0.4477035329116927,0.2703433212280675,0.14200531042615197},
{-0.4479109535274683,0.48745792856709014,0.10966602988919613},
{-0.4504410266518301,0.45751441344085586,0.08449800200086406},
{-0.44593484242336034,0.4892678739845271,0.10673738831087423},
{-0.4518764689906179,0.5550580262037557,0.13827380208864537},
{-0.4357625228764311,0.4966474640251287,0.08588989747004147},
{-0.4393143430782824,0.49329985572234514,0.09551925631114466},
{-0.4521230817890428,0.4915495007580592,0.10004698478036908},
{-0.4510903333971257,0.4601751271740488,0.07609758165897529},
{-0.4353036763871684,0.45665218542257074,0.06990384163607882},
{-0.42737585417757723,0.45553853153079843,0.05454325636615126},
{-0.4203911654861263,0.500273084711267,0.08166997661074714},
{-0.4355237026757259,0.5646782172828357,0.1296148508577014},
{-0.4441001440484607,0.634127681713638,0.15748415982617922},
{-0.46365795996667525,0.6249972783206493,0.17436132212880018},
{-0.42128250114883514,0.35932401506721684,0.049531470062100125},
{-0.4219932318996863,0.4071733153950789,0.04109300350781494},
{-0.40696291525664574,0.4050608338308753,0.03832021388388801},
{-0.4097008673848844,0.35245804889396676,0.045636546366529425},
{-0.4219634366731108,0.3324608679807889,0.06478089621749598},
{-0.41609331864963445,0.32450072941006597,0.06471145042017},
{-0.4178940963050481,0.32479936925797276,0.07025588369777097},
{-0.41862362096804684,0.33429144086277807,0.0726915288732935},
{-0.42334524760406267,0.36461198020221786,0.054081659548281445},
{-0.44144516016653235,0.3704919535698692,0.05666467649832745},
{-0.44068927818771675,0.37364520531776035,0.06559659784351317},
{-0.4346722467778181,0.3423936797448611,0.07584065512827419},
{-0.42320085535219676,0.3342265789464637,0.08675418823478181},
{-0.4390665843096045,0.3472846807842561,0.08049833662417791},
{-0.42526933165868874,0.3509607241615222,0.0934546763035125},
{-0.4539289017135693,0.38003788577656095,0.07654267650520327},
{-0.457538937204268,0.38182880808779956,0.08373501500648045},
{-0.44406966123973346,0.3568326757374032,0.09688227332994889},
{-0.42843060519835025,0.3487061422859585,0.10313010314878245},
{-0.43224301903571183,0.3553807314269736,0.11499502075925112},
{-0.4515801210832169,0.38213799086203315,0.090734142923118},
{-0.4513403841063093,0.38655135150001774,0.09671404489682256},
{-0.4519232245769364,0.35829034989909725,0.1242565231491721},
{-0.433877860198505,0.352930876220315,0.11997724103077732},
{-0.4533233710319347,0.3765979122713932,0.06969619182625256},
{-0.4546492586145448,0.41956423335163057,0.06982683243508366},
{-0.4444592911257209,0.4199327773849646,0.06772076830429637},
{-0.4529222814434183,0.41973108662045344,0.060095711435522566},
{-0.444497566532168,0.45856068428175734,0.08246138366740277},
{-0.4521799219135869,0.41880147555129754,0.07502334914390292},
{-0.4538227848681503,0.41926742705612846,0.08043897536507746},
{-0.4276859537280131,0.4166101512336942,0.0502994993255965},
{-0.41067608807010586,0.45812223606299624,0.05087179686989687},
{-0.46927138065350094,0.6756514554395195,0.21986688409542263},
{-0.4710304449917088,0.6913821891011351,0.21522455860090783},
{-0.4680541310508662,0.7110314534455313,0.20799761179799292},
{-0.46058767646509435,0.7110374124908465,0.20986531411617615},
{-0.46310743585718006,0.6913886065345516,0.2172063995562803},
{-0.46927138065350094,0.6756514554395195,0.21986688409542263},
{-0.46446976529383244,0.6756551225443289,0.2210678609204662},
{-0.46632807065594184,0.6449944592338271,0.22614038364792124},
{-0.4526284546705736,0.7535171546017007,0.1844123980229721},
{-0.46384956619296075,0.7811419135182087,0.20791166402902514},
{-0.45980085328945025,0.7811451222349169,0.20892447253854182},
{-0.45662903682346206,0.8664667330565432,0.20096387557971768},
{-0.45662903682346206,0.8664667330565432,0.20096387557971768},
{-0.44796320977100074,0.2606628521136848,0.1622163293885217},
{-0.4477035329116927,0.2703433212280675,0.14200531042615197},
{-0.43910371374579854,0.24962761696631874,0.13510863225012404},
{-0.46632807065594184,0.6449944592338271,0.22614038364792124},
{-0.4702610405639091,0.6156259919805,0.1931066451377055},
{-0.46570557961456444,0.5766079968096188,0.1922863596306767},
{-0.4702610405639091,0.6156259919805,0.1931066451377055},
{-0.46632807065594184,0.6449944592338271,0.22614038364792124},
{-0.46927138065350094,0.6756514554395195,0.21986688409542263},
{-0.4487312390344971,0.33597922585125534,0.11247824088982297},
{-0.4519232245769364,0.35829034989909725,0.1242565231491721},
{-0.433877860198505,0.352930876220315,0.11997724103077732},
{-0.4312478584680899,0.3377525002205992,0.11155733919458918},
{-0.4406131857629239,0.3102528812557083,0.08658985610051534},
{-0.42379653068965634,0.31413061539748544,0.08820384060470557},
{-0.4146196009043997,0.26669776065952877,0.059381313579862094},
{-0.4313936258842592,0.263004069340368,0.06014269621589164},
{-0.4081661840221951,0.18254756063042113,0.04116222011109036},
{-0.42448159170684246,0.1768885303275297,0.04241728673207101},
{-0.40522012369602906,0.1287621343925154,0.03478947953469025},
{-0.4216338556283756,0.1251220744811906,0.03602368949706804},
{-0.4311981233591138,0.08960456004483033,0.04314635300696865},
{-0.4015064924944678,0.08689090248595326,0.026241687418278013},
{-0.424077751789719,0.01702888876410545,0.03433727967289426},
{-0.3993793425110271,0.01909278118958587,0.02531413909557737},
{-0.39923380428890826,-0.0693658086023403,0.029045189044982767},
{-0.419203711110067,-0.04601208081840612,0.03048063138377054},
{-0.4236940809490467,-0.053310306971051644,0.030908765870255536},
{-0.39772593663013694,-0.08914181725670765,0.02438727835502846},
{-0.42022247866489876,-0.06916067992707045,0.035493563658074566},
{-0.3997160285713303,-0.10105188609514074,0.03080860807015173},
{-0.416567062752185,-0.14584580053470972,0.03863489731533549},
{-0.40094634223484826,-0.18032277398143298,0.03572963353017282},
{-0.4194384058178618,-0.16169433993832388,0.035905883755069486},
{-0.3991762765822125,-0.20500651484088775,0.030267710110780954},
{-0.4165523943329479,-0.17675559777819286,0.04002633439641175},
{-0.40133986841969554,-0.21172763037417072,0.03781231986780088},
{-0.4160149342843358,-0.37940897730176715,0.05273491530706846},
{-0.4020295133178933,-0.40104627084090144,0.04962475204068654},
{-0.42099807133206435,-0.4015951905920426,0.05026649538231288},
{-0.39972198761664546,-0.4284090609575956,0.04317958614430286},
{-0.4163275549693281,-0.4194054018745781,0.05523221368219724},
{-0.40190162303766913,-0.4395623310410108,0.05144546957850068},
{-0.45672323557825084,0.3394884159596985,0.14954144000330039},
{-0.455541511053456,0.3236137484343181,0.12478985770487369},
{-0.4573727715175969,0.30791991501484595,0.13453954342253183},
{-0.4477035329116927,0.2703433212280675,0.14200531042615197},
{-0.45587086290414075,0.28272048754158435,0.12757525300158257},
{-0.4546829501399802,0.2978071859210678,0.1023918691118616},
{-0.4495004142682464,0.23119262270189989,0.10754758927967746},
{-0.43910371374579854,0.24962761696631874,0.13510863225012404},
{-0.4393668285158654,0.15333311177908443,0.08019327934285482},
{-0.43859925764047014,0.1632425457499974,0.05628765228512198},
{-0.4486613348490699,0.24877799462081562,0.07731001818654791},
{-0.43115388890735173,0.05763221918285443,0.05981907421647148},
{-0.43568688883973944,0.09343095471927737,0.07275524481935497},
{-0.42233014715404016,0.005655592392132675,0.05575019223650994},
{-0.4261897749658214,-0.0008035543413364159,0.057703154741509236},
{-0.42052020173660326,-0.017883324184670823,0.0569931115728098},
{-0.42046679952281796,-0.09687940840431664,0.05738961728031464},
{-0.4252564967918563,-0.10725731501461686,0.05897724446868809},
{-0.4202976543134893,-0.12159248610224575,0.05778314346516193},
{-0.421289147776302,-0.3236036638960926,0.07026000919068143},
{-0.4276130700199284,-0.3414565052720361,0.07511663112248933},
{-0.4218495272299721,-0.3664386567853471,0.07374330037140896},
{-0.4114092798379139,-0.08421460355732086,0.06767767982278718},
{-0.41251032805690424,-0.013568746182486602,0.06780694526731473},
{-0.41278925721646115,-0.09239774793925899,0.07231702579464443},
{-0.4112307376725115,-0.11061432027347433,0.06789105948387791},
{-0.41184451933996696,-0.2928265700078957,0.0776677900995046},
{-0.41400008938567967,-0.30618789557460663,0.08590319072497515},
{-0.41213651256040695,-0.33234741692575137,0.0809060728401612},
{-0.41276037876608795,-0.4104562909755988,0.0875781408466199},
{-0.41213651256040695,-0.33234741692575137,0.0809060728401612},
{-0.4218495272299721,-0.3664386567853471,0.07374330037140896},
{-0.4226097638957488,-0.4394917392734319,0.0797678951849768},
{-0.4163275549693281,-0.4194054018745781,0.05523221368219724},
{-0.4181198524448702,-0.4999224178138783,0.06122357535843084},
{-0.40190162303766913,-0.4395623310410108,0.05144546957850068},
{-0.40184180339046754,-0.5347292014993874,0.05712375218164086},
{-0.422040445874106,-0.5183885824691762,0.05769123665087902},
{-0.39946941577290535,-0.5565108872903877,0.050203696212453734},
{-0.417101314084089,-0.535999624121757,0.06285039472945363},
{-0.4015055757182655,-0.5654893350278413,0.05786519493526986},
{-0.4155010812229336,-0.6211756967212645,0.061404180270288544},
{-0.3991052264265324,-0.6533611880502805,0.0549610771203601},
{-0.4176587140151016,-0.6391905782909686,0.05852619057714499},
{-0.3971854970588673,-0.676643178096383,0.049713450138261325},
{-0.41359785382691033,-0.6581673872909606,0.05958965097184008},
{-0.397730291317098,-0.6912426099243315,0.052522452422180024},
{-0.40913796679665787,-0.8359428985942382,0.04612381291806427},
{-0.3913827620862617,-0.8414987915743681,0.039731590847364794},
{-0.40345922580541654,-0.9986069585605696,0.021822367734978348},
{-0.3843634650931731,-1.0,0.025111073166762737},
{-0.41157132003167457,-0.5728668623219877,0.09343725755566837},
{-0.412987280876163,-0.44608771485509774,0.09049669788671624},
{-0.4214887757943579,-0.4746505650206332,0.08236970604717042},
{-0.420485364240915,-0.5781452013068644,0.08425734824775417},
{-0.4271702671142062,-0.4550597451591351,0.08356243188639308},
{-0.4147722441420865,-0.4227626363274862,0.09531664877043121},
{-0.4011418447599937,-0.830593738647732,0.07309651476066985},
{-0.4107336157768016,-0.6003499793152369,0.09222619619239925},
{-0.41843843217517757,-0.6085124962326227,0.08316982247774812},
{-0.4091533227980468,-0.8325226357774204,0.06480794111546453},
{-0.42455928848998936,-0.5890183962604698,0.08565520276224668},
{-0.4129308991397201,-0.583352490136061,0.09883271470039182},
{-0.40809352950816097,-0.9997868495329597,0.042297876631718405},
{-0.42430098679498474,0.1514243837258472,0.09225301189631718},
{-0.4164272543813307,0.057797238899272636,0.07414324398967252},
{-0.4210998334905222,0.09320909487831514,0.0858882931116874},
{-0.4128978951964365,0.010748742584139992,0.06709071385924964},
{-0.41432348219104925,0.0026838623323015695,0.0721593402878448},
{-0.3921668349332988,-0.998604437426013,0.05224535681502779},
{-0.477047247207557,0.6798761893738762,0.2598756851469649},
{-0.4771577187399369,0.7556149677466671,0.26181627117323286},
{-0.40345922580541654,-0.9986069585605696,0.021822367734978348},
{-0.3921668349332988,-0.998604437426013,0.05224535681502779},
{-0.40809352950816097,-0.9997868495329597,0.042297876631718405},
{-0.3921668349332988,-0.998604437426013,0.05224535681502779},
{-0.40345922580541654,-0.9986069585605696,0.021822367734978348},
{-0.3843634650931731,-1.0,0.025111073166762737},
{-0.45327042720625055,0.4509876544624654,0.11128620263275205},
{-0.4482572657378959,0.44576500963187987,0.12518865535288434},
{-0.4530719451584475,0.4021005634735733,0.1687939694461411},
{-0.4546290895380937,0.4228591270227807,0.18543185315995564},
{-0.44650255608664907,0.4021058349367367,0.1704372907888057},
{-0.45292411499582286,0.39566616969756696,0.1510587046181455},
{-0.4360533701266182,0.39567923375845004,0.15527862547743984},
{-0.45031749105856705,0.4085150173671791,0.12307938250538891},
{-0.4212930440751619,0.4085379367722372,0.13033956244563802},
{-0.4482572657378959,0.44576500963187987,0.12518865535288434},
{-0.42383801481281147,0.4457840327380781,0.1312966768008636},
{-0.4482847690239657,0.4609791399034864,0.13777530502863208},
{-0.43102691540332994,0.4609928915465212,0.1420921749713221},
{-0.4551809888118924,0.4728222840791498,0.1710029417056392},
{-0.44524978140617427,0.4728300766768696,0.17348717601988486},
{-0.462495029354028,0.48738894115786535,0.21101013839882743},
{-0.42663189028939186,0.16662613751872227,0.09910385126222893},
{-0.41361710612715913,0.15196551087926857,0.09596114244066452},
{-0.4178225877612669,0.169637976537405,0.10302994534867864},
{-0.40966878021780306,0.17213825443519135,0.09910270529197604},
{-0.3990969754407115,0.14070154006942284,0.08418102662891075},
{-0.4051912452456559,0.13069469862701302,0.08853433842564315},
{-0.3853833786182578,0.09416552165138896,0.06310090382673847},
{-0.3847895368332028,0.10202596081010927,0.05645381797179308},
{-0.3889936433030071,0.06377897442538184,0.033207123809480155},
{-0.38688437045551166,0.0543068427029771,0.03811646037292164},
{-0.39882698484912726,0.04664442720395862,0.02161907261211315},
{-0.3990295923898407,0.03523629333629756,0.023210825293397047},
{-0.4072109032193742,0.29429684984237175,0.07252834270927995},
{-0.4102479535836209,0.29674555907877737,0.07415309933384749},
{-0.4079686187505944,0.3003975370807324,0.07874271019672871},
{-0.40520843479944946,0.30275502708500684,0.0812565105434993},
{-0.4086270932579132,0.30631945295964,0.08374257841014963},
{-0.41206317046422103,0.3116147523042596,0.07804389753650776},
{-0.4112348631654219,0.3041826768260749,0.07285288148490242},
{-0.417175114568376,0.29496174178310675,0.06790068563400233},
{-0.41581851498298805,0.2900134422310665,0.06365761617559933},
{-0.40631269173514795,0.29121946132522286,0.07573774699956339},
{-0.40228758581884727,0.2971757563117176,0.08284413773187276},
{-0.40304805167867447,0.30418817748328886,0.08850018851210659},
{-0.40770206606976894,0.3132175062999714,0.08945524012087694},
{-0.41063895863391175,0.31338092165803555,0.08932734984065284},
{-0.4162617762768114,0.31954234531980014,0.08521033711006928},
{-0.4212352871744155,0.32199540924316683,0.08085427498472995},
{-0.4189082799788683,0.3142828002470711,0.0735537568915786},
{-0.4175122590167804,0.3063820229354486,0.06911747684853596},
{-0.4099561895572314,0.3195966643097878,0.09962022545818755},
{-0.4127502942278624,0.321151058360827,0.09455824565705923},
{-0.4258228352908415,0.3289289876613382,0.09508195406263643},
{-0.42118669803569236,0.32699436068038545,0.10166601155367208},
{-0.4272697373321583,0.32955308306106984,0.09953909076428195},
{-0.4234843683927652,0.33248745449065625,0.10590953940017624},
{-0.4291138326631317,0.33431298510353263,0.10530790501740155},
{-0.4102261801488157,0.3171862304798292,0.0920066282919428},
{-0.4050693140107469,0.3106920170566212,0.09335910238442029},
{-0.4045985494308539,0.30790272546105246,0.10502095406607435},
{-0.4058689720532234,0.3108909574925254,0.10676168288023578},
{-0.39429558927509356,0.25132159019416167,0.09129360560058583},
{-0.39828814963621173,0.25436574557397634,0.10114321992429721},
{-0.4061685286773326,0.21193894728880625,0.10727782788214382},
{-0.3993170017292691,0.20886705942887132,0.09945039266670716},
{-0.41383781999786845,0.18474530238144074,0.10433497627268591},
{-0.4352651717866707,0.2181961740637136,0.12403007942719824},
{-0.41967539246616237,0.2230935925365249,0.12083992743716358},
{-0.4269378643469173,0.2515517010209448,0.13037875462828735},
{-0.4385277490966889,0.2487491161704424,0.1337373642454989},
{-0.43988709901068385,0.26441109161688375,0.13777897213344137},
{-0.3954424763042001,0.272559169309083,0.08371049124306831},
{-0.3987942100998942,0.276477470797813,0.09352664323539489},
{-0.4252441203131249,0.32393805801589,0.09320943866939103},
{-0.41487079758383627,0.319532031587524,0.09261422172003259},
{-0.40716689796166267,0.27617401787484397,0.06388772700238249},
{-0.41417908993918334,0.2717090885754787,0.058433825374760925},
{-0.4162675061280759,0.28500578141992583,0.06497983665340014},
{-0.4111097232138048,0.28755785717314347,0.0688073772981001},
{-0.40228758581884727,0.2971757563117176,0.08284413773187276},
{-0.40631269173514795,0.29121946132522286,0.07573774699956339},
{-0.4234843683927652,0.33248745449065625,0.10590953940017624},
{-0.4188667958557132,0.32064453950904337,0.10833807956013078},
{-0.42118669803569236,0.32699436068038545,0.10166601155367208},
{-0.4188667958557132,0.32064453950904337,0.10833807956013078},
{-0.4234843683927652,0.33248745449065625,0.10590953940017624},
{-0.4254474154359901,0.32744564376597907,0.11185781259490064},
{-0.4099561895572314,0.3195966643097878,0.09962022545818755},
{-0.4151059506797322,0.3058280609151947,0.1109282015257448},
{-0.4058689720532234,0.3108909574925254,0.10676168288023578},
{-0.4151059506797322,0.3058280609151947,0.1109282015257448},
{-0.4099561895572314,0.3195966643097878,0.09962022545818755},
{-0.4137585188563675,0.3145365180610641,0.1051172155673183},
{-0.4045985494308539,0.30790272546105246,0.10502095406607435},
{-0.40887118492178176,0.30562568256853184,0.09886548944962487},
{-0.4050693140107469,0.3106920170566212,0.09335910238442029},
{-0.40887118492178176,0.30562568256853184,0.09886548944962487},
{-0.4045985494308539,0.30790272546105246,0.10502095406607435},
{-0.4138355280573626,0.30284005807777237,0.1091666160529805},
{-0.40304805167867447,0.30418817748328886,0.08850018851210659},
{-0.40628725119553344,0.29101731217261056,0.09655498422571947},
{-0.39999289498443197,0.2950460851937205,0.09379846737938377},
{-0.40628725119553344,0.29101731217261056,0.09655498422571947},
{-0.40304805167867447,0.30418817748328886,0.08850018851210659},
{-0.40684992258970937,0.299120467830896,0.09401161784642394},
{-0.39958378360414515,0.2924841540963279,0.09202129671117996},
{-0.4082906363916605,0.294138705947471,0.08559102842808407},
{-0.40228758581884727,0.2971757563117176,0.08284413773187276},
{-0.4082906363916605,0.294138705947471,0.08559102842808407},
{-0.39958378360414515,0.2924841540963279,0.09202129671117996},
{-0.40658703701369314,0.2888330928705752,0.0954807517106471},
{-0.4111097232138048,0.28755785717314347,0.0688073772981001},
{-0.4091285698405841,0.27109874481878193,0.06990361244202822},
{-0.40716689796166267,0.27617401787484397,0.06388772700238249},
{-0.4091285698405841,0.27109874481878193,0.06990361244202822},
{-0.4111097232138048,0.28755785717314347,0.0688073772981001},
{-0.4130711658986756,0.28247914620632275,0.07480401043749706},
{-0.40716689796166267,0.27617401787484397,0.06388772700238249},
{-0.41641739903715574,0.26676033063533733,0.06411623347081156},
{-0.41417908993918334,0.2717090885754787,0.058433825374760925},
{-0.41641739903715574,0.26676033063533733,0.06411623347081156},
{-0.40716689796166267,0.27617401787484397,0.06388772700238249},
{-0.4091285698405841,0.27109874481878193,0.06990361244202822},
{-0.4291138326631317,0.33431298510353263,0.10530790501740155},
{-0.4254474154359901,0.32744564376597907,0.11185781259490064},
{-0.4234843683927652,0.33248745449065625,0.10590953940017624},
{-0.4254474154359901,0.32744564376597907,0.11185781259490064},
{-0.4291138326631317,0.33431298510353263,0.10530790501740155},
{-0.4310803176171153,0.3292725495431589,0.11125434465972131},
{-0.4058689720532234,0.3108909574925254,0.10676168288023578},
{-0.4138355280573626,0.30284005807777237,0.1091666160529805},
{-0.4045985494308539,0.30790272546105246,0.10502095406607435},
{-0.4138355280573626,0.30284005807777237,0.1091666160529805},
{-0.4058689720532234,0.3108909574925254,0.10676168288023578},
{-0.4151059506797322,0.3058280609151947,0.1109282015257448},
{-0.39999289498443197,0.2950460851937205,0.09379846737938377},
{-0.40658703701369314,0.2888330928705752,0.0954807517106471},
{-0.39958378360414515,0.2924841540963279,0.09202129671117996},
{-0.40658703701369314,0.2888330928705752,0.0954807517106471},
{-0.39999289498443197,0.2950460851937205,0.09379846737938377},
{-0.40628725119553344,0.29101731217261056,0.09655498422571947},
{-0.42118669803569236,0.32699436068038545,0.10166601155367208},
{-0.4137585188563675,0.3145365180610641,0.1051172155673183},
{-0.4099561895572314,0.3195966643097878,0.09962022545818755},
{-0.4137585188563675,0.3145365180610641,0.1051172155673183},
{-0.42118669803569236,0.32699436068038545,0.10166601155367208},
{-0.4188667958557132,0.32064453950904337,0.10833807956013078},
{-0.4050693140107469,0.3106920170566212,0.09335910238442029},
{-0.40684992258970937,0.299120467830896,0.09401161784642394},
{-0.40304805167867447,0.30418817748328886,0.08850018851210659},
{-0.40684992258970937,0.299120467830896,0.09401161784642394},
{-0.4050693140107469,0.3106920170566212,0.09335910238442029},
{-0.40887118492178176,0.30562568256853184,0.09886548944962487},
{-0.40631269173514795,0.29121946132522286,0.07573774699956339},
{-0.4130711658986756,0.28247914620632275,0.07480401043749706},
{-0.4111097232138048,0.28755785717314347,0.0688073772981001},
{-0.4130711658986756,0.28247914620632275,0.07480401043749706},
{-0.40631269173514795,0.29121946132522286,0.07573774699956339},
{-0.4094902380524006,0.2840278104060975,0.07785710438528437},
{-0.40966878021780306,0.17213825443519135,0.09910270529197604},
{-0.4098635951607968,0.2038218107934354,0.09709015233382572},
{-0.3993170017292691,0.20886705942887132,0.09945039266670716},
{-0.4098635951607968,0.2038218107934354,0.09709015233382572},
{-0.40966878021780306,0.17213825443519135,0.09910270529197604},
{-0.41427076755941566,0.1744336328517584,0.09491532998786417},
{-0.3987942100998942,0.276477470797813,0.09352664323539489},
{-0.4056720943637745,0.25433365840689504,0.10095115530991047},
{-0.39828814963621173,0.25436574557397634,0.10114321992429721},
{-0.4056720943637745,0.25433365840689504,0.10095115530991047},
{-0.3987942100998942,0.276477470797813,0.09352664323539489},
{-0.4080708392971535,0.2765205592793222,0.09272904793937357},
{-0.39429558927509356,0.25132159019416167,0.09129360560058583},
{-0.4094902380524006,0.2840278104060975,0.07785710438528437},
{-0.3954424763042001,0.272559169309083,0.08371049124306831},
{-0.4094902380524006,0.2840278104060975,0.07785710438528437},
{-0.39429558927509356,0.25132159019416167,0.09129360560058583},
{-0.4031064961615726,0.25124916487417814,0.08906171393602966},
{-0.39828814963621173,0.25436574557397634,0.10114321992429721},
{-0.41510709664998513,0.21196713815702767,0.1054914894519168},
{-0.4061685286773326,0.21193894728880625,0.10727782788214382},
{-0.41510709664998513,0.21196713815702767,0.1054914894519168},
{-0.39828814963621173,0.25436574557397634,0.10114321992429721},
{-0.4056720943637745,0.25433365840689504,0.10095115530991047},
{-0.3993170017292691,0.20886705942887132,0.09945039266670716},
{-0.4031064961615726,0.25124916487417814,0.08906171393602966},
{-0.39429558927509356,0.25132159019416167,0.09129360560058583},
{-0.4031064961615726,0.25124916487417814,0.08906171393602966},
{-0.3993170017292691,0.20886705942887132,0.09945039266670716},
{-0.4098635951607968,0.2038218107934354,0.09709015233382572},
{-0.4061685286773326,0.21193894728880625,0.10727782788214382},
{-0.41510709664998513,0.21196713815702767,0.1054914894519168},
{-0.41383781999786845,0.18474530238144074,0.10433497627268591},
{-0.40228758581884727,0.2971757563117176,0.08284413773187276},
{-0.4080708392971535,0.2765205592793222,0.09272904793937357},
{-0.3987942100998942,0.276477470797813,0.09352664323539489},
{-0.4080708392971535,0.2765205592793222,0.09272904793937357},
{-0.40228758581884727,0.2971757563117176,0.08284413773187276},
{-0.4082906363916605,0.294138705947471,0.08559102842808407},
{-0.3954424763042001,0.272559169309083,0.08371049124306831},
{-0.4094902380524006,0.2840278104060975,0.07785710438528437},
{-0.40631269173514795,0.29121946132522286,0.07573774699956339},
{-0.41383781999786845,0.18474530238144074,0.10433497627268591},
{-0.4188136228359784,0.22599977309788988,0.11517814680566521},
{-0.41967539246616237,0.2230935925365249,0.12083992743716358},
{-0.4188136228359784,0.22599977309788988,0.11517814680566521},
{-0.41383781999786845,0.18474530238144074,0.10433497627268591},
{-0.41510709664998513,0.21196713815702767,0.1054914894519168},
{-0.41967539246616237,0.2230935925365249,0.12083992743716358},
{-0.4213835757251413,0.25357456771137127,0.12737012432631273},
{-0.4269378643469173,0.2515517010209448,0.13037875462828735},
{-0.4213835757251413,0.25357456771137127,0.12737012432631273},
{-0.41967539246616237,0.2230935925365249,0.12083992743716358},
{-0.4188136228359784,0.22599977309788988,0.11517814680566521},
{-0.4269378643469173,0.2515517010209448,0.13037875462828735},
{-0.4374198250561811,0.26823931984373545,0.13019058631276048},
{-0.43988709901068385,0.26441109161688375,0.13777897213344137},
{-0.4374198250561811,0.26823931984373545,0.13019058631276048},
{-0.4269378643469173,0.2515517010209448,0.13037875462828735},
{-0.4213835757251413,0.25357456771137127,0.12737012432631273},
{-0.3990969754407115,0.14070154006942284,0.08418102662891075},
{-0.41427076755941566,0.1744336328517584,0.09491532998786417},
{-0.40966878021780306,0.17213825443519135,0.09910270529197604},
{-0.41427076755941566,0.1744336328517584,0.09491532998786417},
{-0.3990969754407115,0.14070154006942284,0.08418102662891075},
{-0.40215534085166216,0.14163917293034906,0.08140640345257918},
{-0.4051912452456559,0.13069469862701302,0.08853433842564315},
{-0.3896395121375439,0.09429639145427061,0.06322535619620386},
{-0.3853833786182578,0.09416552165138896,0.06310090382673847},
{-0.3896395121375439,0.09429639145427061,0.06322535619620386},
{-0.4051912452456559,0.13069469862701302,0.08853433842564315},
{-0.40910748398793056,0.1270557846859411,0.08171604461491389},
{-0.41361710612715913,0.15196551087926857,0.09596114244066452},
{-0.40910748398793056,0.1270557846859411,0.08171604461491389},
{-0.4051912452456559,0.13069469862701302,0.08853433842564315},
{-0.40910748398793056,0.1270557846859411,0.08171604461491389},
{-0.41361710612715913,0.15196551087926857,0.09596114244066452},
{-0.4235742124605929,0.15018169358359792,0.08985518373914049},
{-0.42663189028939186,0.16662613751872227,0.09910385126222893},
{-0.4235742124605929,0.15018169358359792,0.08985518373914049},
{-0.41361710612715913,0.15196551087926857,0.09596114244066452},
{-0.4235742124605929,0.15018169358359792,0.08985518373914049},
{-0.42663189028939186,0.16662613751872227,0.09910385126222893},
{-0.42496221163091047,0.1616340619030211,0.0941626567257567},
{-0.3847895368332028,0.10202596081010927,0.05645381797179308},
{-0.40215534085166216,0.14163917293034906,0.08140640345257918},
{-0.3990969754407115,0.14070154006942284,0.08418102662891075},
{-0.40215534085166216,0.14163917293034906,0.08140640345257918},
{-0.3847895368332028,0.10202596081010927,0.05645381797179308},
{-0.38916599722904394,0.10216118529995195,0.056569102579235246},
{-0.39882698484912726,0.04664442720395862,0.02161907261211315},
{-0.39320393801217707,0.06412620341201182,0.033327679880085684},
{-0.3889936433030071,0.06377897442538184,0.033207123809480155},
{-0.39320393801217707,0.06412620341201182,0.033327679880085684},
{-0.39882698484912726,0.04664442720395862,0.02161907261211315},
{-0.4009275483227006,0.04366398777020545,0.028238196792887645},
{-0.3853833786182578,0.09416552165138896,0.06310090382673847},
{-0.3910534102355771,0.05460960804379439,0.03823541208517311},
{-0.38688437045551166,0.0543068427029771,0.03811646037292164},
{-0.3910534102355771,0.05460960804379439,0.03823541208517311},
{-0.3853833786182578,0.09416552165138896,0.06310090382673847},
{-0.3896395121375439,0.09429639145427061,0.06322535619620386},
{-0.38688437045551166,0.0543068427029771,0.03811646037292164},
{-0.3999938117606343,0.036211514021519016,0.026047560057436036},
{-0.3990295923898407,0.03523629333629756,0.023210825293397047},
{-0.3999938117606343,0.036211514021519016,0.026047560057436036},
{-0.38688437045551166,0.0543068427029771,0.03811646037292164},
{-0.3910534102355771,0.05460960804379439,0.03823541208517311},
{-0.3889936433030071,0.06377897442538184,0.033207123809480155},
{-0.38916599722904394,0.10216118529995195,0.056569102579235246},
{-0.3847895368332028,0.10202596081010927,0.05645381797179308},
{-0.38916599722904394,0.10216118529995195,0.056569102579235246},
{-0.3889936433030071,0.06377897442538184,0.033207123809480155},
{-0.39320393801217707,0.06412620341201182,0.033327679880085684},
{-0.39958378360414515,0.2924841540963279,0.09202129671117996},
{-0.39999289498443197,0.2950460851937205,0.09379846737938377},
{-0.38738355509767675,0.13194839008369016,0.04442090112224868},
{-0.38811170459637206,0.12811328603532107,0.049935080785172975},
{-0.3901396135559113,0.10089236703593646,0.036317745463963255},
{-0.3911801545455483,0.10529816427025185,0.03223969572197845},
{-0.3942820668261093,0.09325653804678535,0.02830305870920203},
{-0.3937056437888985,0.09115941248397072,0.030586060647037727},
{-0.3950258015202441,0.08855806000987825,0.03473676490305664},
{-0.39452478332567437,0.09809574123074911,0.03971990195078516},
{-0.3926018452413012,0.12529534518342972,0.05333861243629839},
{-0.38871861044231015,0.15195886425180175,0.05815329185684998},
{-0.38705030694813225,0.15544582253733855,0.052739040799978903},
{-0.39068669975464776,0.1557311691303117,0.051345311778396845},
{-0.39188378028083143,0.13259380053012582,0.04292380558385465},
{-0.39496873220164946,0.10730636254144113,0.0315239227020145},
{-0.3964046329285384,0.09474423662910557,0.026648506858058987},
{-0.3967562166021294,0.08595968705844331,0.027607913153790367},
{-0.3980580388094286,0.08335810539030025,0.0317618261265174},
{-0.39125739294059403,0.21514583044453328,0.05529867995686569},
{-0.39302952133968505,0.21334138568431035,0.05039553163278988},
{-0.3998019763402981,0.2322372891844473,0.047263594931602766},
{-0.39743486018589924,0.23743288911706426,0.05027268362167856},
{-0.40920741259398385,0.2394704242267279,0.043222903819862636},
{-0.4062734995524986,0.2275649392693064,0.0344060378880685},
{-0.39692467422930633,0.2124599053657765,0.03572184093245307},
{-0.39662030453013497,0.19623640449541208,0.03506222045488144},
{-0.3926518095443278,0.19093812562813492,0.04904787061537458},
{-0.3907105359359081,0.1828672863309814,0.05257264591925722},
{-0.39025627332765694,0.216412356768043,0.062491018458142866},
{-0.3963762128662664,0.23941931395344834,0.05611483997098402},
{-0.41113057987240764,0.25195095705705667,0.049025180404367055},
{-0.4096282128708503,0.24780231554749296,0.04443281921287887},
{-0.39223146765556255,0.16855159673765185,0.046550113852144616},
{-0.39704133400105196,0.1724882337504283,0.04310853598862282},
{-0.4049279012815385,0.1826795764035557,0.03160551578402128},
{-0.40685886115768205,0.16731142772995897,0.03815886127227909},
{-0.40590083002625416,0.15528171959712267,0.035790828341677905},
{-0.39386905914696263,0.16035882620558933,0.042660690813787865},
{-0.3954000754048426,0.15727777058363115,0.04526479361648731},
{-0.39364697011194977,0.1634492787836213,0.04885305567238086},
{-0.3882996437178483,0.18193950881423016,0.06143007919800418},
{-0.39402743223591397,0.17637307290777343,0.0675827934858467},
{-0.3952898330665132,0.21401727893947325,0.06781794658174263},
{-0.4013962501561384,0.23718421357218405,0.06116123457667287},
{-0.41297971747249385,0.2503828113629826,0.05472019417319966},
{-0.39329401127405533,0.1491606340882603,0.061593952944169486},
{-0.4048744990677532,0.2134520864107409,0.030437084514160176},
{-0.40440327609975896,0.1975982755439634,0.02946255141109048},
{-0.39943297391886295,0.1285372950288956,0.03621621249955595},
{-0.3969056511231081,0.1077709388819685,0.03002636877551934},
{-0.40154385112471247,0.10865516952910934,0.025182581710543953},
{-0.40040704863383153,0.09259600079301139,0.02282761284082589},
{-0.40103824904913116,0.08281354032612019,0.025453947466431676},
{-0.3947810222742238,0.1381964490965743,0.042778954943887566},
{-0.3976065265297843,0.1358504187948289,0.0391132252988977},
{-0.40428478277560864,0.13172561346652562,0.03211088866555203},
{-0.39445556672239895,0.14072468866853152,0.0407636516571303},
{-0.40517749360262106,0.1418642414880194,0.034271500980377546},
{-0.3967562166021294,0.08595968705844331,0.027607913153790367},
{-0.40231463071681584,0.0800820056312978,0.029533601566770522},
{-0.40103824904913116,0.08281354032612019,0.025453947466431676},
{-0.40231463071681584,0.0800820056312978,0.029533601566770522},
{-0.3967562166021294,0.08595968705844331,0.027607913153790367},
{-0.3980580388094286,0.08335810539030025,0.0317618261265174},
{-0.43656516044156524,0.16962307892411727,0.09838784904821442},
{-0.43541919018866104,0.15192769386092272,0.09055537156366496},
{-0.42663189028939186,0.16662613751872227,0.09910385126222893},
{-0.4352651717866707,0.2181961740637136,0.12403007942719824},
{-0.4411093908824315,0.18471940345372512,0.09757191822814663},
{-0.44670149652255325,0.22303652321793027,0.1141272920837521},
{-0.44639689762933127,0.25144352142907067,0.1255310712644521},
{-0.4385277490966889,0.2487491161704424,0.1337373642454989},
{-0.43988709901068385,0.26441109161688375,0.13777897213344137},
{-0.4284264797054398,0.2942457395690922,0.06722250043833362},
{-0.43529611298349913,0.30268397692932686,0.0737309238926776},
{-0.43146284248753464,0.30034207212049185,0.07286663312793727},
{-0.4268017230808723,0.29670659609017863,0.0700129380041553},
{-0.42511279212214204,0.30415356918165115,0.06938150839480509},
{-0.42745263418452184,0.3115833527193301,0.07419389587485088},
{-0.43385173207673866,0.3062607792826913,0.07743263700360867},
{-0.43800129036250474,0.3131572282646687,0.08187395931576409},
{-0.44146968392994457,0.30410085455001756,0.07888710244859463},
{-0.43878123771663136,0.2970815575569289,0.07371717224964273},
{-0.4311419708167215,0.29115528699106025,0.069528650975278},
{-0.41581851498298805,0.2900134422310665,0.06365761617559933},
{-0.417175114568376,0.29496174178310675,0.06790068563400233},
{-0.4175122590167804,0.3063820229354486,0.06911747684853596},
{-0.4189082799788683,0.3142828002470711,0.0735537568915786},
{-0.4212352871744155,0.32199540924316683,0.08085427498472995},
{-0.4281088167513347,0.31952263463145014,0.08224708723010968},
{-0.4354276703685325,0.3133330201014642,0.08312467124978369},
{-0.43734969167670346,0.3171342034303473,0.08521973406614312},
{-0.44213113795992076,0.31953844902094025,0.09156840926723224},
{-0.44261152868993825,0.31061019478056384,0.0839653550273142},
{-0.43373851021575177,0.3269790046789965,0.09851848965704549},
{-0.4258228352908415,0.3289289876613382,0.09508195406263643},
{-0.43669786379685155,0.32110659471501435,0.08856573801057271},
{-0.4252441203131249,0.32393805801589,0.09320943866939103},
{-0.4337444692610669,0.3194983400620886,0.08789167830781448},
{-0.4272697373321583,0.32955308306106984,0.09953909076428195},
{-0.4342752826822121,0.3324720984892674,0.10320848751408111},
{-0.4291138326631317,0.33431298510353263,0.10530790501740155},
{-0.45080109050529266,0.2510990427710477,0.0771809819360709},
{-0.4510087403151189,0.20875635870244078,0.08658664738380721},
{-0.4499209853510623,0.211860333729457,0.09640211179398206},
{-0.4533194747330748,0.25412509182086646,0.08739959868121742},
{-0.44526444982541136,0.2723826898901358,0.07125631572855631},
{-0.44829279081573603,0.2762982410502588,0.08115383160883909},
{-0.43878123771663136,0.2970815575569289,0.07371717224964273},
{-0.4311419708167215,0.29115528699106025,0.069528650975278},
{-0.4150525484659469,0.06341936896002051,0.026669592710712422},
{-0.4193458114214271,0.05380238659764868,0.029978008830846767},
{-0.43754038112678667,0.09352423669786378,0.05005082378071629},
{-0.434358480122573,0.10138719699114049,0.04404685643170074},
{-0.44035671762032397,0.14052414387427328,0.0739112996104847},
{-0.43745489174592,0.13057322578020517,0.08051850570062902},
{-0.44122284193746897,0.1720942491774798,0.09127366571818528},
{-0.39882698484912726,0.04664442720395862,0.02161907261211315},
{-0.3990295923898407,0.03523629333629756,0.023210825293397047},
{-0.4233940659368364,0.27612680390042427,0.05983007553089937},
{-0.42293155234276425,0.2875276035584668,0.06585100323965791},
{-0.4162675061280759,0.28500578141992583,0.06497983665340014},
{-0.41417908993918334,0.2717090885754787,0.058433825374760925},
{-0.4342752826822121,0.3324720984892674,0.10320848751408111},
{-0.43979060831538935,0.3206044305501917,0.10309962034005521},
{-0.43624520554695445,0.32742914179433724,0.10915469796235029},
{-0.43979060831538935,0.3206044305501917,0.10309962034005521},
{-0.4342752826822121,0.3324720984892674,0.10320848751408111},
{-0.43373851021575177,0.3269790046789965,0.09851848965704549},
{-0.44213113795992076,0.31953844902094025,0.09156840926723224},
{-0.4446813801607337,0.30575334365470536,0.10352156658717453},
{-0.4422604034044484,0.3144785319662672,0.09798286316083807},
{-0.4446813801607337,0.30575334365470536,0.10352156658717453},
{-0.44213113795992076,0.31953844902094025,0.09156840926723224},
{-0.4499865348495284,0.31079057049837094,0.09571980110540292},
{-0.4500458961086288,0.30779569183943123,0.09364582414169692},
{-0.4427405649404152,0.305542485128171,0.09039035184724674},
{-0.4447407414198342,0.302758235801715,0.10143956783169822},
{-0.4427405649404152,0.305542485128171,0.09039035184724674},
{-0.4500458961086288,0.30779569183943123,0.09364582414169692},
{-0.44261152868993825,0.31061019478056384,0.0839653550273142},
{-0.44146968392994457,0.30410085455001756,0.07888710244859463},
{-0.4436660505166606,0.29090431950567425,0.08720845084303301},
{-0.44159872018042157,0.2990303945690177,0.08532080864244924},
{-0.4436660505166606,0.29090431950567425,0.08720845084303301},
{-0.44146968392994457,0.30410085455001756,0.07888710244859463},
{-0.4473251335341836,0.2949165905551423,0.08195692756207434},
{-0.44662677926206396,0.2923505339648393,0.08025699528891629},
{-0.4353568494069031,0.294064905463184,0.07882246972633085},
{-0.4427813614814186,0.28871895423338595,0.08643194139966516},
{-0.4353568494069031,0.294064905463184,0.07882246972633085},
{-0.44662677926206396,0.2923505339648393,0.08025699528891629},
{-0.43878123771663136,0.2970815575569289,0.07371717224964273},
{-0.42293155234276425,0.2875276035584668,0.06585100323965791},
{-0.4253623844432246,0.271046259381199,0.06584527338839338},
{-0.424900100043203,0.2824449962927862,0.07184649040880196},
{-0.4253623844432246,0.271046259381199,0.06584527338839338},
{-0.42293155234276425,0.2875276035584668,0.06585100323965791},
{-0.4233940659368364,0.27612680390042427,0.05983007553089937},
{-0.4233940659368364,0.27612680390042427,0.05983007553089937},
{-0.41570712667440574,0.2667623933817926,0.06429385886001172},
{-0.4253623844432246,0.271046259381199,0.06584527338839338},
{-0.41570712667440574,0.2667623933817926,0.06429385886001172},
{-0.4233940659368364,0.27612680390042427,0.05983007553089937},
{-0.41417908993918334,0.2717090885754787,0.058433825374760925},
{-0.4291138326631317,0.33431298510353263,0.10530790501740155},
{-0.43624520554695445,0.32742914179433724,0.10915469796235029},
{-0.4310803176171153,0.3292725495431589,0.11125434465972131},
{-0.43624520554695445,0.32742914179433724,0.10915469796235029},
{-0.4291138326631317,0.33431298510353263,0.10530790501740155},
{-0.4342752826822121,0.3324720984892674,0.10320848751408111},
{-0.4499865348495284,0.31079057049837094,0.09571980110540292},
{-0.4447407414198342,0.302758235801715,0.10143956783169822},
{-0.4446813801607337,0.30575334365470536,0.10352156658717453},
{-0.4447407414198342,0.302758235801715,0.10143956783169822},
{-0.4499865348495284,0.31079057049837094,0.09571980110540292},
{-0.4500458961086288,0.30779569183943123,0.09364582414169692},
{-0.4473251335341836,0.2949165905551423,0.08195692756207434},
{-0.4427813614814186,0.28871895423338595,0.08643194139966516},
{-0.4436660505166606,0.29090431950567425,0.08720845084303301},
{-0.4427813614814186,0.28871895423338595,0.08643194139966516},
{-0.4473251335341836,0.2949165905551423,0.08195692756207434},
{-0.44662677926206396,0.2923505339648393,0.08025699528891629},
{-0.43373851021575177,0.3269790046789965,0.09851848965704549},
{-0.4422604034044484,0.3144785319662672,0.09798286316083807},
{-0.43979060831538935,0.3206044305501917,0.10309962034005521},
{-0.4422604034044484,0.3144785319662672,0.09798286316083807},
{-0.43373851021575177,0.3269790046789965,0.09851848965704549},
{-0.44213113795992076,0.31953844902094025,0.09156840926723224},
{-0.44261152868993825,0.31061019478056384,0.0839653550273142},
{-0.44159872018042157,0.2990303945690177,0.08532080864244924},
{-0.4427405649404152,0.305542485128171,0.09039035184724674},
{-0.44159872018042157,0.2990303945690177,0.08532080864244924},
{-0.44261152868993825,0.31061019478056384,0.0839653550273142},
{-0.44146968392994457,0.30410085455001756,0.07888710244859463},
{-0.4311419708167215,0.29115528699106025,0.069528650975278},
{-0.424900100043203,0.2824449962927862,0.07184649040880196},
{-0.42976611893108474,0.28396913672914875,0.07278756118048688},
{-0.424900100043203,0.2824449962927862,0.07184649040880196},
{-0.4311419708167215,0.29115528699106025,0.069528650975278},
{-0.42293155234276425,0.2875276035584668,0.06585100323965791},
{-0.44122284193746897,0.1720942491774798,0.09127366571818528},
{-0.4405391560845864,0.2037679501915489,0.0894605115840403},
{-0.4348551436301816,0.17440223326682883,0.08980407346586097},
{-0.4405391560845864,0.2037679501915489,0.0894605115840403},
{-0.44122284193746897,0.1720942491774798,0.09127366571818528},
{-0.4510087403151189,0.20875635870244078,0.08658664738380721},
{-0.44829279081573603,0.2762982410502588,0.08115383160883909},
{-0.44693596203629743,0.2541587833463019,0.09064704918389728},
{-0.4399368341196599,0.2764071082242847,0.08476386709953783},
{-0.44693596203629743,0.2541587833463019,0.09064704918389728},
{-0.44829279081573603,0.2762982410502588,0.08115383160883909},
{-0.4533194747330748,0.25412509182086646,0.08739959868121742},
{-0.45080109050529266,0.2510990427710477,0.0771809819360709},
{-0.42976611893108474,0.28396913672914875,0.07278756118048688},
{-0.4419839953794479,0.2511050018163628,0.07935259556532431},
{-0.42976611893108474,0.28396913672914875,0.07278756118048688},
{-0.45080109050529266,0.2510990427710477,0.0771809819360709},
{-0.44526444982541136,0.2723826898901358,0.07125631572855631},
{-0.4533194747330748,0.25412509182086646,0.08739959868121742},
{-0.4412462197306282,0.21192565403387253,0.09899521328225361},
{-0.44693596203629743,0.2541587833463019,0.09064704918389728},
{-0.4412462197306282,0.21192565403387253,0.09899521328225361},
{-0.4533194747330748,0.25412509182086646,0.08739959868121742},
{-0.4499209853510623,0.211860333729457,0.09640211179398206},
{-0.4510087403151189,0.20875635870244078,0.08658664738380721},
{-0.4419839953794479,0.2511050018163628,0.07935259556532431},
{-0.4405391560845864,0.2037679501915489,0.0894605115840403},
{-0.4419839953794479,0.2511050018163628,0.07935259556532431},
{-0.4510087403151189,0.20875635870244078,0.08658664738380721},
{-0.45080109050529266,0.2510990427710477,0.0771809819360709},
{-0.4499209853510623,0.211860333729457,0.09640211179398206},
{-0.4411093908824315,0.18471940345372512,0.09757191822814663},
{-0.4412462197306282,0.21192565403387253,0.09899521328225361},
{-0.43878123771663136,0.2970815575569289,0.07371717224964273},
{-0.4399368341196599,0.2764071082242847,0.08476386709953783},
{-0.4353568494069031,0.294064905463184,0.07882246972633085},
{-0.4399368341196599,0.2764071082242847,0.08476386709953783},
{-0.43878123771663136,0.2970815575569289,0.07371717224964273},
{-0.44829279081573603,0.2762982410502588,0.08115383160883909},
{-0.44526444982541136,0.2723826898901358,0.07125631572855631},
{-0.4311419708167215,0.29115528699106025,0.069528650975278},
{-0.42976611893108474,0.28396913672914875,0.07278756118048688},
{-0.4411093908824315,0.18471940345372512,0.09757191822814663},
{-0.4440841004649201,0.22594316216739643,0.10889547949114337},
{-0.4412462197306282,0.21192565403387253,0.09899521328225361},
{-0.4440841004649201,0.22594316216739643,0.10889547949114337},
{-0.4411093908824315,0.18471940345372512,0.09757191822814663},
{-0.44670149652255325,0.22303652321793027,0.1141272920837521},
{-0.44670149652255325,0.22303652321793027,0.1141272920837521},
{-0.4493800873916914,0.25341894495102696,0.12042210668295472},
{-0.4440841004649201,0.22594316216739643,0.10889547949114337},
{-0.4493800873916914,0.25341894495102696,0.12042210668295472},
{-0.44670149652255325,0.22303652321793027,0.1141272920837521},
{-0.44639689762933127,0.25144352142907067,0.1255310712644521},
{-0.44639689762933127,0.25144352142907067,0.1255310712644521},
{-0.4374198250561811,0.26823931984373545,0.13019058631276048},
{-0.4493800873916914,0.25341894495102696,0.12042210668295472},
{-0.4374198250561811,0.26823931984373545,0.13019058631276048},
{-0.44639689762933127,0.25144352142907067,0.1255310712644521},
{-0.43988709901068385,0.26441109161688375,0.13777897213344137},
{-0.44035671762032397,0.14052414387427328,0.0739112996104847},
{-0.4348551436301816,0.17440223326682883,0.08980407346586097},
{-0.4361225867298936,0.14148836324506686,0.07294799701589347},
{-0.4348551436301816,0.17440223326682883,0.08980407346586097},
{-0.44035671762032397,0.14052414387427328,0.0739112996104847},
{-0.44122284193746897,0.1720942491774798,0.09127366571818528},
{-0.43745489174592,0.13057322578020517,0.08051850570062902},
{-0.43402775310758485,0.09376718239147946,0.0521209044455624},
{-0.429908677630546,0.1269576896322925,0.07654015537064689},
{-0.43402775310758485,0.09376718239147946,0.0521209044455624},
{-0.43745489174592,0.13057322578020517,0.08051850570062902},
{-0.43754038112678667,0.09352423669786378,0.05005082378071629},
{-0.43541919018866104,0.15192769386092272,0.09055537156366496},
{-0.429908677630546,0.1269576896322925,0.07654015537064689},
{-0.4232322549371263,0.15018238116574967,0.0899399855378554},
{-0.429908677630546,0.1269576896322925,0.07654015537064689},
{-0.43541919018866104,0.15192769386092272,0.09055537156366496},
{-0.43745489174592,0.13057322578020517,0.08051850570062902},
{-0.42663189028939186,0.16662613751872227,0.09910385126222893},
{-0.4232322549371263,0.15018238116574967,0.0899399855378554},
{-0.42496221163091047,0.1616340619030211,0.0941626567257567},
{-0.4232322549371263,0.15018238116574967,0.0899399855378554},
{-0.42663189028939186,0.16662613751872227,0.09910385126222893},
{-0.43541919018866104,0.15192769386092272,0.09055537156366496},
{-0.434358480122573,0.10138719699114049,0.04404685643170074},
{-0.4361225867298936,0.14148836324506686,0.07294799701589347},
{-0.4307401936460533,0.10164022722298173,0.04616415107096651},
{-0.4361225867298936,0.14148836324506686,0.07294799701589347},
{-0.434358480122573,0.10138719699114049,0.04404685643170074},
{-0.44035671762032397,0.14052414387427328,0.0739112996104847},
{-0.39882698484912726,0.04664442720395862,0.02161907261211315},
{-0.4115850716747095,0.06391442810927513,0.028711253313286503},
{-0.4009275483227006,0.04366398777020545,0.028238196792887645},
{-0.4115850716747095,0.06391442810927513,0.028711253313286503},
{-0.39882698484912726,0.04664442720395862,0.02161907261211315},
{-0.4150525484659469,0.06341936896002051,0.026669592710712422},
{-0.43754038112678667,0.09352423669786378,0.05005082378071629},
{-0.4159145472901814,0.05425458645944467,0.031999500356969746},
{-0.43402775310758485,0.09376718239147946,0.0521209044455624},
{-0.4159145472901814,0.05425458645944467,0.031999500356969746},
{-0.43754038112678667,0.09352423669786378,0.05005082378071629},
{-0.4193458114214271,0.05380238659764868,0.029978008830846767},
{-0.4193458114214271,0.05380238659764868,0.029978008830846767},
{-0.3999938117606343,0.036211514021519016,0.026047560057436036},
{-0.4159145472901814,0.05425458645944467,0.031999500356969746},
{-0.3999938117606343,0.036211514021519016,0.026047560057436036},
{-0.4193458114214271,0.05380238659764868,0.029978008830846767},
{-0.3990295923898407,0.03523629333629756,0.023210825293397047},
{-0.4150525484659469,0.06341936896002051,0.026669592710712422},
{-0.4307401936460533,0.10164022722298173,0.04616415107096651},
{-0.4115850716747095,0.06391442810927513,0.028711253313286503},
{-0.4307401936460533,0.10164022722298173,0.04616415107096651},
{-0.4150525484659469,0.06341936896002051,0.026669592710712422},
{-0.434358480122573,0.10138719699114049,0.04404685643170074},
{-0.4500458961086288,0.30779569183943123,0.09364582414169692},
{-0.4499865348495284,0.31079057049837094,0.09571980110540292},
{-0.44662677926206396,0.2923505339648393,0.08025699528891629},
{-0.4473251335341836,0.2949165905551423,0.08195692756207434},
{-0.42604102802699445,0.13148839762417444,0.03474593266507988},
{-0.41445801909874025,0.10490807599616327,0.026418854419376976},
{-0.41762616845991907,0.10043672926338176,0.029442153140588786},
{-0.4286201486781806,0.12765558551631112,0.0397973695398815},
{-0.41586618734550884,0.09775424209538366,0.03437945137820112},
{-0.4120171024600543,0.0882511691761505,0.030487736399338546},
{-0.41072880270173945,0.09085389681454648,0.026330156321802214},
{-0.40894636057037226,0.09298150518608836,0.024639162616616816},
{-0.40621070038263946,0.09456019380648915,0.024198880845451017},
{-0.4109036777623326,0.10704416454757665,0.0275391549386161},
{-0.4213551556628693,0.13224519637919238,0.03554811184211282},
{-0.4281943061322014,0.1554114434297514,0.04196164895951632},
{-0.43210366905295866,0.15506054733831218,0.04146773578051462},
{-0.43385104449458695,0.15159948798049097,0.04686640164194618},
{-0.4267767409293589,0.12492955147870269,0.044787611603178006},
{-0.43143304726095916,0.21496132923381572,0.045252646331806534},
{-0.42342890343252465,0.23733135615265696,0.04377159437695316},
{-0.419562399799226,0.23215569610244052,0.04232102523082707},
{-0.4269516159899521,0.2131747616095381,0.04191099707433795},
{-0.4147928716066388,0.21235630965491395,0.03125049419967156},
{-0.4062734995524986,0.2275649392693064,0.0344060378880685},
{-0.40920741259398385,0.2394704242267279,0.043222903819862636},
{-0.4096282128708503,0.24780231554749296,0.04443281921287887},
{-0.41113057987240764,0.25195095705705667,0.049025180404367055},
{-0.4278569324897464,0.2393017374055004,0.04824339949783584},
{-0.436627042835222,0.21621891698935278,0.05090067532027004},
{-0.4296331863817479,0.18261563126344363,0.042837170232735096},
{-0.42604515351990485,0.1907297882361569,0.04069443505385488},
{-0.4143587780748387,0.19611149373784553,0.030622960889181233},
{-0.40440327609975896,0.1975982755439634,0.02946255141109048},
{-0.4048744990677532,0.2134520864107409,0.030437084514160176},
{-0.4183084791484982,0.1723179425708467,0.037787108522236976},
{-0.42435599336712415,0.16829191987834377,0.03851227849827475},
{-0.4203957493671379,0.16011542212387248,0.03602254352681512},
{-0.40590083002625416,0.15528171959712267,0.035790828341677905},
{-0.40685886115768205,0.16731142772995897,0.03815886127227909},
{-0.4049279012815385,0.1826795764035557,0.03160551578402128},
{-0.4369880234648868,0.18166149643087562,0.04925941672406069},
{-0.43570086967682486,0.1761629019633908,0.057173945678718086},
{-0.4319634022940032,0.14887482910718602,0.051927693860922754},
{-0.41076937004869224,0.12838992325437215,0.03337947773551694},
{-0.40837612577252713,0.10758093701403695,0.027158463620601352},
{-0.4190072918087192,0.13792622931093954,0.036715855529822164},
{-0.4205813965481084,0.15705063927950558,0.03896356158386841},
{-0.4244064160582519,0.1631996864625388,0.04115717784197759},
{-0.40154385112471247,0.10865516952910934,0.025182581710543953},
{-0.40428478277560864,0.13172561346652562,0.03211088866555203},
{-0.4143216486386446,0.13565239513512706,0.03493020468174688},
{-0.40517749360262106,0.1418642414880194,0.034271500980377546},
{-0.40611329291114256,0.08577610262392807,0.025270592225967003},
{-0.40040704863383153,0.09259600079301139,0.02282761284082589},
{-0.4181491892833446,0.14045813598770598,0.03483394318050293},
{-0.40517749360262106,0.1418642414880194,0.034271500980377546},
{-0.40517749360262106,0.1418642414880194,0.034271500980377546},
{-0.40103824904913116,0.08281354032612019,0.025453947466431676},
{-0.42661240879509243,0.23709482789245756,0.05485839818569989},
{-0.41297971747249385,0.2503828113629826,0.05472019417319966},
{-0.4355237026757259,0.2138662400601405,0.05776687068757071},
{-0.4074190114173016,0.08317933403084721,0.02942175487008709},
{-0.40611329291114256,0.08577610262392807,0.025270592225967003},
{-0.40231463071681584,0.0800820056312978,0.029533601566770522},
{-0.4074190114173016,0.08317933403084721,0.02942175487008709},
{-0.40231463071681584,0.0800820056312978,0.029533601566770522},
{-0.40611329291114256,0.08577610262392807,0.025270592225967003},
{-0.40103824904913116,0.08281354032612019,0.025453947466431676}
};


// texture array: 41kb.
const tgx::fVec2 elementalist_tex_array[5260] PROGMEM = {
{0.194633,0.482288},
{0.231768,0.49407},
{0.242274,0.448721},
{0.204433,0.439179},
{0.220037,0.383205},
{0.2567,0.393548},
{0.237846,0.330283},
{0.271001,0.340148},
{0.287532,0.280672},
{0.263291,0.26808},
{0.298931,0.189171},
{0.306626,0.223305},
{0.18731,0.374712},
{0.169555,0.430659},
{0.205985,0.320971},
{0.235478,0.256381},
{0.274841,0.190103},
{0.151699,0.502595},
{0.18715,0.511593},
{0.158035,0.471725},
{0.150124,0.528572},
{0.18163,0.539625},
{0.225879,0.521784},
{0.219422,0.553324},
{0.306103,0.922369},
{0.340844,0.922088},
{0.33618,0.879084},
{0.302439,0.880539},
{0.335312,0.823385},
{0.306373,0.819845},
{0.329309,0.755515},
{0.288865,0.746129},
{0.337405,0.674173},
{0.2997,0.669712},
{0.340976,0.59979},
{0.299984,0.591505},
{0.302275,0.541559},
{0.342151,0.553771},
{0.312484,0.497164},
{0.344254,0.499181},
{0.348357,0.455208},
{0.324101,0.461284},
{0.299943,0.462336},
{0.284818,0.497429},
{0.27393,0.534339},
{0.258979,0.586743},
{0.251838,0.666255},
{0.249017,0.748503},
{0.257099,0.821227},
{0.270486,0.880988},
{0.27232,0.925603},
{0.274466,0.957162},
{0.309185,0.951309},
{0.317661,0.975649},
{0.280343,0.984597},
{0.343231,0.950209},
{0.351581,0.977033},
{0.580386,0.688322},
{0.61715,0.679611},
{0.587918,0.562549},
{0.564222,0.573093},
{0.520659,0.492039},
{0.53584,0.585922},
{0.541684,0.695649},
{0.534817,0.803466},
{0.586386,0.803634},
{0.517994,0.957418},
{0.569018,0.965575},
{0.621579,0.798647},
{0.611232,0.969873},
{0.332105,0.369369},
{0.360624,0.382632},
{0.370295,0.348729},
{0.336598,0.340577},
{0.369177,0.30118},
{0.404545,0.306434},
{0.398031,0.355552},
{0.387361,0.393019},
{0.37213,0.412016},
{0.349175,0.401545},
{0.327245,0.387413},
{0.322322,0.386088},
{0.323823,0.36848},
{0.327296,0.339573},
{0.333849,0.302985},
{0.378938,0.227522},
{0.34444,0.223978},
{0.333849,0.302985},
{0.414932,0.238173},
{0.389374,0.161507},
{0.361973,0.152424},
{0.422333,0.169289},
{0.404676,0.089213},
{0.385463,0.078127},
{0.426472,0.095869},
{0.429136,0.030264},
{0.420968,0.016517},
{0.40537,0.027749},
{0.317774,0.397008},
{0.32203,0.399609},
{0.340468,0.417083},
{0.315512,0.411848},
{0.359405,0.425591},
{0.311563,0.41088},
{0.315173,0.412251},
{0.315512,0.411848},
{0.723936,0.228517},
{0.654578,0.209765},
{0.641613,0.235022},
{0.713562,0.264719},
{0.775571,0.253853},
{0.766329,0.275032},
{0.808939,0.253781},
{0.81315,0.281492},
{0.858958,0.287473},
{0.856696,0.257824},
{0.809224,0.220667},
{0.868159,0.213412},
{0.7313,0.193905},
{0.663364,0.177532},
{0.763923,0.210947},
{0.624857,0.731525},
{0.585425,0.739481},
{0.56893,0.924356},
{0.617879,0.933369},
{0.605563,0.616923},
{0.569382,0.61513},
{0.537231,0.621713},
{0.521373,0.491689},
{0.522998,0.916989},
{0.543571,0.749679},
{0.718361,0.959552},
{0.770314,0.952695},
{0.762241,0.905564},
{0.711196,0.916406},
{0.752071,0.842955},
{0.70341,0.859818},
{0.69297,0.733994},
{0.744666,0.718352},
{0.688989,0.568037},
{0.728065,0.573468},
{0.717866,0.479775},
{0.679096,0.469836},
{0.630285,0.357355},
{0.708087,0.383243},
{0.606494,0.263112},
{0.677874,0.283249},
{0.722208,0.984162},
{0.778001,0.977323},
{0.67356,0.989728},
{0.66891,0.970316},
{0.660196,0.923731},
{0.654307,0.872629},
{0.646641,0.752066},
{0.650481,0.568721},
{0.640805,0.46119},
{0.032681,0.098663},
{0.16969,0.107948},
{0.200243,0.046344},
{0.052282,0.035914},
{0.300876,0.106283},
{0.343163,0.04023},
{0.032681,0.098663},
{0.16969,0.107948},
{0.200243,0.046344},
{0.052282,0.035914},
{0.300876,0.106283},
{0.343163,0.04023},
{0.172675,0.920727},
{0.207617,0.920843},
{0.207825,0.879084},
{0.172229,0.881627},
{0.206967,0.824946},
{0.224909,0.875593},
{0.222646,0.921451},
{0.206031,0.945176},
{0.173779,0.947772},
{0.136087,0.923513},
{0.134341,0.886644},
{0.166945,0.828284},
{0.205765,0.765284},
{0.222639,0.820674},
{0.171465,0.766492},
{0.204767,0.685768},
{0.217276,0.759132},
{0.170979,0.681273},
{0.167114,0.577556},
{0.194155,0.587985},
{0.213499,0.688548},
{0.126779,0.827663},
{0.125589,0.771775},
{0.127778,0.677973},
{0.134012,0.570484},
{0.139111,0.949993},
{0.139842,0.967163},
{0.178022,0.970003},
{0.209635,0.967856},
{0.22079,0.957945},
{0.222393,0.971278},
{0.219552,0.942612},
{0.185958,0.496969},
{0.220778,0.502444},
{0.231263,0.456673},
{0.199673,0.448126},
{0.21795,0.386724},
{0.252762,0.398742},
{0.273395,0.3339},
{0.243398,0.318725},
{0.289671,0.255001},
{0.271856,0.243531},
{0.306423,0.215078},
{0.299076,0.189349},
{0.279204,0.189002},
{0.246546,0.227659},
{0.215165,0.302489},
{0.186047,0.374288},
{0.164801,0.438404},
{0.153488,0.495525},
{0.183205,0.532313},
{0.150189,0.523313},
{0.180277,0.544394},
{0.147606,0.539661},
{0.215312,0.540973},
{0.221665,0.544131},
{0.230094,0.505228},
{0.24022,0.458792},
{0.252762,0.398742},
{0.212946,0.554652},
{0.214386,0.564537},
{0.219159,0.563013},
{0.212946,0.554652},
{0.786146,0.098207},
{0.884692,0.113905},
{0.909725,0.025115},
{0.806437,0.01533},
{0.680954,0.089204},
{0.703854,0.012017},
{0.590598,0.020407},
{0.572918,0.071465},
{0.518184,0.057748},
{0.528616,0.031129},
{0.483096,0.041245},
{0.472829,0.069204},
{0.508719,0.096195},
{0.556986,0.117217},
{0.663509,0.150278},
{0.766966,0.175068},
{0.879529,0.186279},
{0.981146,0.10769},
{0.986278,0.17545},
{0.973026,0.047709},
{0.430684,0.880892},
{0.433584,0.945985},
{0.472423,0.938056},
{0.467864,0.878529},
{0.486066,0.874488},
{0.481296,0.920417},
{0.473105,0.739986},
{0.430328,0.727127},
{0.483357,0.613975},
{0.492764,0.742039},
{0.434221,0.602852},
{0.496899,0.506767},
{0.503016,0.618562},
{0.437479,0.498575},
{0.499125,0.422482},
{0.446966,0.423764},
{0.41676,0.410086},
{0.385494,0.478993},
{0.369921,0.5884},
{0.376815,0.716943},
{0.382716,0.883281},
{0.392264,0.947512},
{0.445611,0.98039},
{0.942561,0.957612},
{0.951982,0.96199},
{0.935701,0.983568},
{0.924726,0.979181},
{0.86741,0.958113},
{0.88164,0.938178},
{0.829812,0.91539},
{0.819739,0.938307},
{0.796336,0.919},
{0.80145,0.877991},
{0.830207,0.882922},
{0.822341,0.824212},
{0.800919,0.824275},
{0.79327,0.767616},
{0.817419,0.763169},
{0.779524,0.654429},
{0.808022,0.645274},
{0.768368,0.534235},
{0.791643,0.526849},
{0.752549,0.428889},
{0.779965,0.424891},
{0.745041,0.363264},
{0.784826,0.359002},
{0.842607,0.319899},
{0.85713,0.406825},
{0.868549,0.317553},
{0.930855,0.355096},
{0.91896,0.26604},
{0.982975,0.333733},
{0.985876,0.234913},
{0.956446,0.914507},
{0.966462,0.917297},
{0.890329,0.894588},
{0.889834,0.834595},
{0.963996,0.863226},
{0.96617,0.777846},
{0.888299,0.774797},
{0.874885,0.639315},
{0.951838,0.634324},
{0.862364,0.504426},
{0.986007,0.633501},
{0.98601,0.776136},
{0.981297,0.860485},
{0.943982,0.476221},
{0.981313,0.473481},
{0.065694,0.945716},
{0.035944,0.946287},
{0.033138,0.898864},
{0.066031,0.897044},
{0.032614,0.849463},
{0.062876,0.842608},
{0.025537,0.747207},
{0.067362,0.742579},
{0.065236,0.60927},
{0.025764,0.608418},
{0.033174,0.523089},
{0.06899,0.521853},
{0.037871,0.458349},
{0.074581,0.453645},
{0.036834,0.333216},
{0.089745,0.339531},
{0.029248,0.258062},
{0.109585,0.239163},
{0.017484,0.192586},
{0.135396,0.149186},
{0.218107,0.206111},
{0.174549,0.271818},
{0.137561,0.351725},
{0.121413,0.451096},
{0.113012,0.521982},
{0.107443,0.611478},
{0.105397,0.737539},
{0.096763,0.833035},
{0.095372,0.892009},
{0.098437,0.941598},
{0.066469,0.962664},
{0.099159,0.963151},
{0.067562,0.976747},
{0.092907,0.983684},
{0.036677,0.980226},
{0.033506,0.965527},
{0.608517,0.480431},
{0.606516,0.429115},
{0.568138,0.433647},
{0.567558,0.482685},
{0.528409,0.429114},
{0.525899,0.347625},
{0.560827,0.346315},
{0.590578,0.33615},
{0.568941,0.231721},
{0.536518,0.239066},
{0.508746,0.151672},
{0.532088,0.147396},
{0.466797,0.099726},
{0.489406,0.158471},
{0.50971,0.249719},
{0.526925,0.480263},
{0.592704,0.182694},
{0.194633,0.482288},
{0.204433,0.439179},
{0.242274,0.448721},
{0.231768,0.49407},
{0.18715,0.511593},
{0.225879,0.521784},
{0.18163,0.539625},
{0.219422,0.553324},
{0.2567,0.393548},
{0.220037,0.383205},
{0.237846,0.330283},
{0.271001,0.340148},
{0.287532,0.280672},
{0.263291,0.26808},
{0.235478,0.256381},
{0.205985,0.320971},
{0.18731,0.374712},
{0.298931,0.189171},
{0.306626,0.223305},
{0.169555,0.430659},
{0.158035,0.471725},
{0.151699,0.502595},
{0.150124,0.528572},
{0.274841,0.190103},
{0.306103,0.922369},
{0.302439,0.880539},
{0.33618,0.879084},
{0.340844,0.922088},
{0.343231,0.950209},
{0.309185,0.951309},
{0.317661,0.975649},
{0.351581,0.977033},
{0.329309,0.755515},
{0.335312,0.823385},
{0.306373,0.819845},
{0.288865,0.746129},
{0.257099,0.821227},
{0.337405,0.674173},
{0.2997,0.669712},
{0.249017,0.748503},
{0.340976,0.59979},
{0.299984,0.591505},
{0.258979,0.586743},
{0.251838,0.666255},
{0.270486,0.880988},
{0.27232,0.925603},
{0.274466,0.957162},
{0.280343,0.984597},
{0.342151,0.553771},
{0.302275,0.541559},
{0.312484,0.497164},
{0.344254,0.499181},
{0.348357,0.455208},
{0.324101,0.461284},
{0.299943,0.462336},
{0.284818,0.497429},
{0.27393,0.534339},
{0.580386,0.688322},
{0.564222,0.573093},
{0.587918,0.562549},
{0.61715,0.679611},
{0.586386,0.803634},
{0.621579,0.798647},
{0.569018,0.965575},
{0.611232,0.969873},
{0.541684,0.695649},
{0.53584,0.585922},
{0.534817,0.803466},
{0.517994,0.957418},
{0.332105,0.369369},
{0.336598,0.340577},
{0.370295,0.348729},
{0.360624,0.382632},
{0.387361,0.393019},
{0.398031,0.355552},
{0.404545,0.306434},
{0.369177,0.30118},
{0.333849,0.302985},
{0.34444,0.223978},
{0.378938,0.227522},
{0.361973,0.152424},
{0.389374,0.161507},
{0.404676,0.089213},
{0.385463,0.078127},
{0.40537,0.027749},
{0.420968,0.016517},
{0.429136,0.030264},
{0.426472,0.095869},
{0.422333,0.169289},
{0.414932,0.238173},
{0.349175,0.401545},
{0.327245,0.387413},
{0.32203,0.399609},
{0.340468,0.417083},
{0.359405,0.425591},
{0.37213,0.412016},
{0.323823,0.36848},
{0.327296,0.339573},
{0.333849,0.302985},
{0.322322,0.386088},
{0.317774,0.397008},
{0.311563,0.41088},
{0.315512,0.411848},
{0.315173,0.412251},
{0.315512,0.411848},
{0.723936,0.228517},
{0.713562,0.264719},
{0.641613,0.235022},
{0.654578,0.209765},
{0.592704,0.182694},
{0.663364,0.177532},
{0.7313,0.193905},
{0.763923,0.210947},
{0.775571,0.253853},
{0.808939,0.253781},
{0.809224,0.220667},
{0.856696,0.257824},
{0.868159,0.213412},
{0.766329,0.275032},
{0.81315,0.281492},
{0.858958,0.287473},
{0.624857,0.731525},
{0.617879,0.933369},
{0.56893,0.924356},
{0.585425,0.739481},
{0.522998,0.916989},
{0.543571,0.749679},
{0.537231,0.621713},
{0.569382,0.61513},
{0.521373,0.491689},
{0.605563,0.616923},
{0.718361,0.959552},
{0.711196,0.916406},
{0.762241,0.905564},
{0.770314,0.952695},
{0.722208,0.984162},
{0.778001,0.977323},
{0.70341,0.859818},
{0.752071,0.842955},
{0.69297,0.733994},
{0.744666,0.718352},
{0.688989,0.568037},
{0.650481,0.568721},
{0.646641,0.752066},
{0.654307,0.872629},
{0.660196,0.923731},
{0.66891,0.970316},
{0.67356,0.989728},
{0.728065,0.573468},
{0.717866,0.479775},
{0.679096,0.469836},
{0.640805,0.46119},
{0.630285,0.357355},
{0.708087,0.383243},
{0.606494,0.263112},
{0.677874,0.283249},
{0.032681,0.098663},
{0.052282,0.035914},
{0.200243,0.046344},
{0.16969,0.107948},
{0.343163,0.04023},
{0.300876,0.106283},
{0.032681,0.098663},
{0.052282,0.035914},
{0.200243,0.046344},
{0.16969,0.107948},
{0.343163,0.04023},
{0.300876,0.106283},
{0.172675,0.920727},
{0.172229,0.881627},
{0.207825,0.879084},
{0.207617,0.920843},
{0.222646,0.921451},
{0.224909,0.875593},
{0.206967,0.824946},
{0.166945,0.828284},
{0.134341,0.886644},
{0.136087,0.923513},
{0.173779,0.947772},
{0.206031,0.945176},
{0.219552,0.942612},
{0.22079,0.957945},
{0.209635,0.967856},
{0.222393,0.971278},
{0.205765,0.765284},
{0.171465,0.766492},
{0.126779,0.827663},
{0.204767,0.685768},
{0.170979,0.681273},
{0.127778,0.677973},
{0.125589,0.771775},
{0.167114,0.577556},
{0.194155,0.587985},
{0.213499,0.688548},
{0.217276,0.759132},
{0.222639,0.820674},
{0.139111,0.949993},
{0.139842,0.967163},
{0.178022,0.970003},
{0.134012,0.570484},
{0.185958,0.496969},
{0.199673,0.448126},
{0.231263,0.456673},
{0.220778,0.502444},
{0.230094,0.505228},
{0.24022,0.458792},
{0.252762,0.398742},
{0.21795,0.386724},
{0.243398,0.318725},
{0.273395,0.3339},
{0.252762,0.398742},
{0.164801,0.438404},
{0.153488,0.495525},
{0.183205,0.532313},
{0.215312,0.540973},
{0.221665,0.544131},
{0.186047,0.374288},
{0.215165,0.302489},
{0.246546,0.227659},
{0.271856,0.243531},
{0.279204,0.189002},
{0.299076,0.189349},
{0.306423,0.215078},
{0.289671,0.255001},
{0.150189,0.523313},
{0.180277,0.544394},
{0.212946,0.554652},
{0.147606,0.539661},
{0.212946,0.554652},
{0.219159,0.563013},
{0.214386,0.564537},
{0.786146,0.098207},
{0.806437,0.01533},
{0.909725,0.025115},
{0.884692,0.113905},
{0.973026,0.047709},
{0.981146,0.10769},
{0.879529,0.186279},
{0.986278,0.17545},
{0.518184,0.057748},
{0.528616,0.031129},
{0.590598,0.020407},
{0.572918,0.071465},
{0.680954,0.089204},
{0.703854,0.012017},
{0.766966,0.175068},
{0.508719,0.096195},
{0.556986,0.117217},
{0.663509,0.150278},
{0.472829,0.069204},
{0.483096,0.041245},
{0.430684,0.880892},
{0.467864,0.878529},
{0.472423,0.938056},
{0.433584,0.945985},
{0.445611,0.98039},
{0.392264,0.947512},
{0.382716,0.883281},
{0.430328,0.727127},
{0.376815,0.716943},
{0.369921,0.5884},
{0.434221,0.602852},
{0.385494,0.478993},
{0.437479,0.498575},
{0.41676,0.410086},
{0.446966,0.423764},
{0.499125,0.422482},
{0.496899,0.506767},
{0.483357,0.613975},
{0.503016,0.618562},
{0.492764,0.742039},
{0.473105,0.739986},
{0.486066,0.874488},
{0.481296,0.920417},
{0.942561,0.957612},
{0.924726,0.979181},
{0.935701,0.983568},
{0.951982,0.96199},
{0.956446,0.914507},
{0.966462,0.917297},
{0.981297,0.860485},
{0.963996,0.863226},
{0.98601,0.776136},
{0.96617,0.777846},
{0.986007,0.633501},
{0.951838,0.634324},
{0.943982,0.476221},
{0.981313,0.473481},
{0.930855,0.355096},
{0.982975,0.333733},
{0.91896,0.26604},
{0.985876,0.234913},
{0.889834,0.834595},
{0.890329,0.894588},
{0.822341,0.824212},
{0.817419,0.763169},
{0.888299,0.774797},
{0.86741,0.958113},
{0.88164,0.938178},
{0.829812,0.91539},
{0.819739,0.938307},
{0.796336,0.919},
{0.80145,0.877991},
{0.830207,0.882922},
{0.800919,0.824275},
{0.79327,0.767616},
{0.779524,0.654429},
{0.808022,0.645274},
{0.874885,0.639315},
{0.791643,0.526849},
{0.862364,0.504426},
{0.85713,0.406825},
{0.868549,0.317553},
{0.779965,0.424891},
{0.842607,0.319899},
{0.784826,0.359002},
{0.745041,0.363264},
{0.752549,0.428889},
{0.768368,0.534235},
{0.065694,0.945716},
{0.066031,0.897044},
{0.033138,0.898864},
{0.035944,0.946287},
{0.066469,0.962664},
{0.033506,0.965527},
{0.036677,0.980226},
{0.067562,0.976747},
{0.099159,0.963151},
{0.092907,0.983684},
{0.025537,0.747207},
{0.032614,0.849463},
{0.062876,0.842608},
{0.067362,0.742579},
{0.096763,0.833035},
{0.095372,0.892009},
{0.065236,0.60927},
{0.025764,0.608418},
{0.033174,0.523089},
{0.06899,0.521853},
{0.107443,0.611478},
{0.105397,0.737539},
{0.109585,0.239163},
{0.135396,0.149186},
{0.017484,0.192586},
{0.029248,0.258062},
{0.089745,0.339531},
{0.036834,0.333216},
{0.074581,0.453645},
{0.037871,0.458349},
{0.098437,0.941598},
{0.113012,0.521982},
{0.121413,0.451096},
{0.137561,0.351725},
{0.174549,0.271818},
{0.218107,0.206111},
{0.608517,0.480431},
{0.567558,0.482685},
{0.568138,0.433647},
{0.606516,0.429115},
{0.560827,0.346315},
{0.525899,0.347625},
{0.528409,0.429114},
{0.526925,0.480263},
{0.590578,0.33615},
{0.568941,0.231721},
{0.536518,0.239066},
{0.50971,0.249719},
{0.489406,0.158471},
{0.508746,0.151672},
{0.466797,0.099726},
{0.532088,0.147396},
{0.520659,0.492039},
{0.777912,1.1135},
{0.784355,1.050732},
{0.658513,1.041633},
{0.653047,1.086701},
{0.529884,1.044219},
{0.53197,1.024332},
{0.535191,1.01779},
{0.664494,1.005037},
{0.788421,1.021765},
{0.94349,1.064407},
{0.524653,1.080195},
{0.524922,1.106702},
{0.642351,1.145101},
{0.76185,1.16539},
{0.768882,1.166935},
{0.913985,1.17917},
{0.931675,1.114175},
{0.777912,1.1135},
{0.784355,1.050732},
{0.658513,1.041633},
{0.653047,1.086701},
{0.761569,1.166618},
{0.647987,1.147071},
{0.642359,1.145066},
{0.788421,1.021765},
{0.664494,1.005037},
{0.94349,1.064407},
{0.931675,1.114175},
{0.913985,1.17917},
{0.658513,1.041633},
{0.784355,1.050732},
{0.777912,1.1135},
{0.653047,1.086701},
{0.642351,1.145101},
{0.76185,1.16539},
{0.768882,1.166935},
{0.913985,1.17917},
{0.535191,1.01779},
{0.664494,1.005037},
{0.53197,1.024332},
{0.529884,1.044219},
{0.524653,1.080195},
{0.524922,1.106702},
{0.788421,1.021765},
{0.94349,1.064407},
{0.931675,1.114175},
{0.658513,1.041633},
{0.784355,1.050732},
{0.777912,1.1135},
{0.653047,1.086701},
{0.761569,1.166618},
{0.913985,1.17917},
{0.664494,1.005037},
{0.788421,1.021765},
{0.94349,1.064407},
{0.931675,1.114175},
{0.647987,1.147071},
{0.642359,1.145066},
{0.048598,0.281381},
{0.160421,0.322028},
{0.172405,0.260661},
{0.105608,0.236433},
{0.175946,0.170459},
{0.231832,0.23706},
{0.254272,0.272617},
{0.257156,0.171179},
{0.311869,0.171962},
{0.232969,0.105513},
{0.272266,0.06211},
{0.172441,0.081099},
{0.161653,0.022091},
{0.105771,0.105015},
{0.049068,0.061427},
{0.081248,0.170715},
{0.007902,0.171359},
{0.239653,0.96857},
{0.240589,0.936076},
{0.271125,0.940872},
{0.273254,0.970046},
{0.278652,0.993927},
{0.237998,0.995698},
{0.180959,0.994917},
{0.188382,0.96145},
{0.134676,0.951206},
{0.107617,0.978056},
{0.064557,0.944459},
{0.092888,0.919325},
{0.064907,0.877139},
{0.031329,0.899573},
{0.011431,0.821542},
{0.041521,0.820646},
{0.068343,0.816661},
{0.103718,0.853181},
{0.125246,0.880572},
{0.160734,0.910132},
{0.195789,0.925933},
{0.794451,0.954286},
{0.83304,0.936791},
{0.847054,0.964541},
{0.811078,0.972969},
{0.823242,0.993012},
{0.859176,0.989377},
{0.883049,0.946987},
{0.863107,0.916815},
{0.945109,0.771696},
{0.96713,0.769105},
{0.968829,0.797121},
{0.945838,0.797551},
{0.92504,0.847499},
{0.959576,0.858883},
{0.996576,0.79681},
{0.990362,0.761362},
{0.959196,0.740098},
{0.937289,0.746514},
{0.919044,0.924393},
{0.893173,0.896839},
{0.942201,0.95349},
{0.990645,0.870905},
{0.903615,0.971867},
{0.98171,0.726749},
{0.096293,0.363455},
{0.082604,0.338929},
{0.029121,0.35033},
{0.033005,0.385652},
{0.052486,0.416902},
{0.123524,0.390059},
{0.067174,0.314528},
{0.021933,0.319649},
{0.048598,0.281381},
{0.105608,0.236433},
{0.172405,0.260661},
{0.160421,0.322028},
{0.231832,0.23706},
{0.175946,0.170459},
{0.081248,0.170715},
{0.007902,0.171359},
{0.049068,0.061427},
{0.105771,0.105015},
{0.161653,0.022091},
{0.172441,0.081099},
{0.272266,0.06211},
{0.232969,0.105513},
{0.311869,0.171962},
{0.257156,0.171179},
{0.254272,0.272617},
{0.239653,0.96857},
{0.273254,0.970046},
{0.271125,0.940872},
{0.240589,0.936076},
{0.188382,0.96145},
{0.195789,0.925933},
{0.160734,0.910132},
{0.134676,0.951206},
{0.092888,0.919325},
{0.125246,0.880572},
{0.103718,0.853181},
{0.064907,0.877139},
{0.068343,0.816661},
{0.041521,0.820646},
{0.011431,0.821542},
{0.031329,0.899573},
{0.064557,0.944459},
{0.107617,0.978056},
{0.180959,0.994917},
{0.237998,0.995698},
{0.278652,0.993927},
{0.794451,0.954286},
{0.811078,0.972969},
{0.847054,0.964541},
{0.83304,0.936791},
{0.863107,0.916815},
{0.883049,0.946987},
{0.859176,0.989377},
{0.823242,0.993012},
{0.945109,0.771696},
{0.945838,0.797551},
{0.968829,0.797121},
{0.96713,0.769105},
{0.996576,0.79681},
{0.959576,0.858883},
{0.92504,0.847499},
{0.919044,0.924393},
{0.893173,0.896839},
{0.990362,0.761362},
{0.959196,0.740098},
{0.98171,0.726749},
{0.990645,0.870905},
{0.942201,0.95349},
{0.903615,0.971867},
{0.937289,0.746514},
{0.096293,0.363455},
{0.033005,0.385652},
{0.029121,0.35033},
{0.082604,0.338929},
{0.067174,0.314528},
{0.021933,0.319649},
{0.052486,0.416902},
{0.123524,0.390059},
{0.739063,0.228579},
{0.732278,0.165734},
{0.838261,0.271743},
{0.779348,0.284334},
{0.845703,0.339914},
{0.887392,0.325072},
{0.952125,0.313672},
{0.923368,0.262389},
{0.889879,0.207305},
{0.842826,0.201391},
{0.771461,0.175362},
{0.867577,0.161932},
{0.904982,0.186305},
{0.906685,0.158569},
{0.904982,0.186305},
{0.867577,0.161932},
{0.867324,0.170692},
{0.956334,0.082596},
{0.931644,0.045778},
{0.883317,0.048291},
{0.88812,0.105241},
{0.818878,0.045877},
{0.868687,0.010588},
{0.918594,0.010236},
{0.952388,0.044297},
{0.973242,0.077791},
{0.986514,0.10891},
{0.971198,0.113481},
{0.907618,0.137312},
{0.867577,0.161932},
{0.840071,0.135634},
{0.812819,0.115315},
{0.81182,0.084713},
{0.742582,0.019224},
{0.812827,0.006885},
{0.692751,0.017702},
{0.692751,0.063243},
{0.745047,0.068569},
{0.780407,0.103311},
{0.737838,0.09501},
{0.692751,0.091749},
{0.647664,0.094874},
{0.640455,0.068433},
{0.64292,0.019088},
{0.573682,0.084577},
{0.566624,0.045741},
{0.572674,0.006749},
{0.516815,0.010451},
{0.502184,0.048155},
{0.453858,0.045642},
{0.466908,0.010099},
{0.433114,0.04416},
{0.447759,0.008083},
{0.906685,0.158569},
{0.937743,0.008219},
{0.937743,0.008219},
{0.979834,0.039792},
{0.961447,0.002592},
{0.979834,0.039792},
{0.937743,0.008219},
{0.952388,0.044297},
{0.979834,0.039792},
{0.973242,0.077791},
{0.994554,0.072628},
{0.973242,0.077791},
{0.979834,0.039792},
{0.952388,0.044297},
{0.499941,0.512142},
{0.513936,0.512764},
{0.516278,0.502613},
{0.499941,0.502823},
{0.499941,0.486575},
{0.521927,0.488209},
{0.538049,0.490095},
{0.531539,0.50753},
{0.529103,0.521528},
{0.515652,0.522793},
{0.499941,0.520381},
{0.485947,0.512764},
{0.483604,0.502613},
{0.477956,0.488209},
{0.473381,0.473011},
{0.499941,0.46809},
{0.526502,0.473011},
{0.543003,0.470729},
{0.580732,0.479507},
{0.56137,0.514486},
{0.537381,0.518797},
{0.537627,0.527316},
{0.52583,0.528433},
{0.520867,0.535135},
{0.499941,0.533223},
{0.479015,0.535135},
{0.484231,0.522793},
{0.470779,0.521528},
{0.468344,0.50753},
{0.461833,0.490095},
{0.456879,0.470729},
{0.472769,0.455891},
{0.499941,0.459296},
{0.527114,0.455891},
{0.541953,0.454423},
{0.56787,0.457535},
{0.60391,0.453272},
{0.608088,0.501254},
{0.586536,0.533217},
{0.566298,0.528332},
{0.550635,0.522697},
{0.549829,0.532765},
{0.536723,0.534894},
{0.529586,0.53831},
{0.525401,0.551362},
{0.499941,0.550392},
{0.474481,0.551362},
{0.470296,0.53831},
{0.474053,0.528433},
{0.462255,0.527316},
{0.462502,0.518797},
{0.438512,0.514486},
{0.41915,0.479507},
{0.432013,0.457535},
{0.457929,0.454423},
{0.463446,0.446819},
{0.477245,0.444375},
{0.499941,0.448792},
{0.522637,0.444375},
{0.536436,0.446819},
{0.560106,0.448136},
{0.582473,0.44207},
{0.603291,0.43608},
{0.638201,0.437071},
{0.624892,0.470494},
{0.637088,0.531218},
{0.609585,0.55873},
{0.576717,0.58331},
{0.572286,0.5456},
{0.561426,0.548475},
{0.584458,0.436096},
{0.582041,0.429923},
{0.57499,0.435424},
{0.573973,0.440637},
{0.571196,0.437893},
{0.561837,0.439421},
{0.565213,0.438669},
{0.558827,0.440307},
{0.55101,0.443627},
{0.569945,0.420637},
{0.567635,0.42714},
{0.565126,0.433473},
{0.548911,0.426515},
{0.549816,0.413997},
{0.549056,0.407398},
{0.577565,0.403404},
{0.59563,0.418717},
{0.523514,0.400475},
{0.528423,0.38315},
{0.499941,0.382169},
{0.499941,0.401007},
{0.476368,0.400475},
{0.471459,0.38315},
{0.499941,0.349685},
{0.535929,0.351171},
{0.552691,0.390729},
{0.52539,0.403297},
{0.499941,0.405246},
{0.474493,0.403297},
{0.450826,0.407398},
{0.447192,0.390729},
{0.463954,0.351171},
{0.499941,0.312242},
{0.536359,0.318683},
{0.56701,0.359834},
{0.596885,0.378073},
{0.560949,0.566074},
{0.568171,0.562684},
{0.551326,0.572277},
{0.552929,0.557944},
{0.546056,0.54219},
{0.537709,0.548331},
{0.541755,0.565967},
{0.524265,0.572835},
{0.499941,0.575262},
{0.475617,0.572835},
{0.458127,0.565967},
{0.462174,0.548331},
{0.453826,0.54219},
{0.46316,0.534894},
{0.450054,0.532765},
{0.449248,0.522697},
{0.433585,0.528332},
{0.413346,0.533217},
{0.391794,0.501254},
{0.395973,0.453272},
{0.417409,0.44207},
{0.439777,0.448136},
{0.448872,0.443627},
{0.425909,0.440637},
{0.438046,0.439421},
{0.443899,0.439786},
{0.455586,0.444052},
{0.614675,0.752257},
{0.658693,0.762675},
{0.650678,0.738022},
{0.610277,0.729071},
{0.63977,0.712443},
{0.669872,0.712748},
{0.683565,0.73786},
{0.69749,0.767512},
{0.664717,0.784559},
{0.61924,0.774994},
{0.564709,0.762011},
{0.566714,0.725899},
{0.578997,0.716104},
{0.612629,0.709987},
{0.640536,0.706736},
{0.665015,0.708636},
{0.680586,0.703492},
{0.687358,0.712193},
{0.700764,0.735005},
{0.72549,0.75824},
{0.704928,0.789481},
{0.697138,0.891118},
{0.610325,0.900891},
{0.499941,0.812715},
{0.499941,0.764346},
{0.538535,0.730614},
{0.527936,0.70015},
{0.539768,0.697272},
{0.54986,0.692313},
{0.562315,0.68825},
{0.592739,0.703372},
{0.61815,0.704519},
{0.624114,0.696992},
{0.642294,0.700233},
{0.657852,0.701062},
{0.670394,0.699941},
{0.680308,0.697408},
{0.693114,0.696832},
{0.551552,0.578977},
{0.546847,0.608198},
{0.543255,0.585757},
{0.499941,0.442156},
{0.522637,0.444375},
{0.51432,0.443962},
{0.536436,0.446819},
{0.523908,0.446299},
{0.499941,0.442156},
{0.499941,0.443751},
{0.737182,0.6772},
{0.708858,0.680742},
{0.718638,0.698918},
{0.742114,0.704401},
{0.736278,0.733862},
{0.715989,0.720282},
{0.705147,0.697852},
{0.695529,0.687967},
{0.701896,0.668262},
{0.727801,0.648474},
{0.768946,0.609058},
{0.780579,0.666022},
{0.778337,0.712214},
{0.770636,0.750468},
{0.738514,0.780546},
{0.702227,0.705792},
{0.693114,0.696832},
{0.689518,0.693369},
{0.544296,0.444052},
{0.536436,0.446819},
{0.55101,0.443627},
{0.523908,0.446299},
{0.52763,0.417849},
{0.525459,0.431564},
{0.54463,0.438147},
{0.562368,0.437858},
{0.558827,0.440307},
{0.537926,0.445567},
{0.520002,0.443091},
{0.499941,0.429115},
{0.499941,0.415898},
{0.513062,0.443291},
{0.531479,0.445131},
{0.537926,0.445567},
{0.499941,0.438806},
{0.479881,0.443091},
{0.474424,0.431564},
{0.472253,0.417849},
{0.537926,0.445567},
{0.531479,0.445131},
{0.55471,0.439854},
{0.57499,0.435424},
{0.958144,0.535137},
{0.928334,0.492543},
{0.911722,0.54233},
{0.865886,0.461048},
{0.890607,0.420778},
{0.81046,0.408901},
{0.820816,0.350068},
{0.754813,0.359225},
{0.738996,0.282098},
{0.703915,0.324435},
{0.624395,0.285048},
{0.628263,0.21909},
{0.561768,0.251739},
{0.499941,0.208887},
{0.499941,0.174701},
{0.37162,0.21909},
{0.438114,0.251739},
{0.375487,0.285048},
{0.260886,0.282098},
{0.295967,0.324435},
{0.245069,0.359225},
{0.179067,0.350068},
{0.189422,0.408901},
{0.109275,0.420778},
{0.133997,0.461048},
{0.071549,0.492543},
{0.08816,0.54233},
{0.041738,0.535137},
{0.048716,0.601224},
{0.01118,0.574509},
{0.599442,0.637037},
{0.602434,0.662352},
{0.639817,0.648835},
{0.634762,0.618905},
{0.66987,0.612736},
{0.659406,0.648279},
{0.638438,0.66719},
{0.608498,0.675884},
{0.580762,0.676293},
{0.566755,0.666314},
{0.591811,0.611364},
{0.624648,0.589647},
{0.656311,0.565333},
{0.708539,0.578851},
{0.705519,0.627018},
{0.686932,0.655458},
{0.677711,0.673455},
{0.656947,0.667604},
{0.655516,0.672841},
{0.63774,0.672283},
{0.618923,0.678618},
{0.604217,0.681058},
{0.58872,0.681766},
{0.579211,0.683577},
{0.548249,0.665208},
{0.554547,0.634614},
{0.693155,0.537784},
{0.754779,0.553648},
{0.690766,0.682817},
{0.673801,0.677884},
{0.663616,0.689432},
{0.649624,0.684385},
{0.634264,0.684492},
{0.61741,0.686243},
{0.607288,0.685683},
{0.596221,0.684008},
{0.61152,0.690249},
{0.602353,0.697121},
{0.523474,0.584438},
{0.499941,0.590487},
{0.499941,0.605871},
{0.520458,0.598491},
{0.499941,0.63588},
{0.479425,0.598491},
{0.476409,0.584438},
{0.5395,0.582891},
{0.520197,0.629566},
{0.499941,0.673777},
{0.479685,0.629566},
{0.460382,0.582891},
{0.661173,0.496391},
{0.685529,0.438555},
{0.735148,0.489458},
{0.810086,0.511173},
{0.828932,0.579756},
{0.836214,0.654044},
{0.850417,0.717671},
{0.831729,0.795978},
{0.76479,0.851636},
{0.499941,0.733067},
{0.499941,0.702379},
{0.524547,0.669279},
{0.534284,0.663298},
{0.531043,0.620785},
{0.475335,0.669279},
{0.465599,0.663298},
{0.46884,0.620785},
{0.456627,0.585757},
{0.448557,0.572277},
{0.446953,0.557944},
{0.864429,0.553885},
{0.908042,0.624632},
{0.951167,0.601224},
{0.988703,0.574509},
{0.578261,0.333073},
{0.614969,0.350762},
{0.653965,0.383159},
{0.623719,0.40373},
{0.898203,0.798244},
{0.927321,0.706231},
{0.842611,0.890054},
{0.784385,0.930136},
{0.704905,0.97986},
{0.606223,0.988588},
{0.499941,0.99384},
{0.499941,0.900125},
{0.389558,0.900891},
{0.435173,0.762011},
{0.461347,0.730614},
{0.471947,0.70015},
{0.460114,0.697272},
{0.450022,0.692313},
{0.451633,0.665208},
{0.445336,0.634614},
{0.453035,0.608198},
{0.448331,0.578977},
{0.438934,0.566074},
{0.438456,0.548475},
{0.538645,0.291573},
{0.582614,0.304466},
{0.625343,0.324782},
{0.680193,0.354996},
{0.731733,0.397395},
{0.778954,0.443125},
{0.84078,0.482151},
{0.499941,0.259046},
{0.461237,0.291573},
{0.417269,0.304466},
{0.374539,0.324782},
{0.31969,0.354996},
{0.268149,0.397395},
{0.220929,0.443125},
{0.159102,0.482151},
{0.135454,0.553885},
{0.09184,0.624632},
{0.499941,0.28311},
{0.463524,0.318683},
{0.421621,0.333073},
{0.384914,0.350762},
{0.345918,0.383159},
{0.314354,0.438555},
{0.264734,0.489458},
{0.189796,0.511173},
{0.170951,0.579756},
{0.163669,0.654044},
{0.149465,0.717671},
{0.072562,0.706231},
{0.10168,0.798244},
{0.168154,0.795978},
{0.157271,0.890054},
{0.235092,0.851636},
{0.215497,0.930136},
{0.294978,0.97986},
{0.302744,0.891118},
{0.39366,0.988588},
{0.555984,0.439786},
{0.499941,0.441178},
{0.685085,0.686819},
{0.673388,0.69396},
{0.689518,0.693369},
{0.693114,0.696832},
{0.432873,0.359834},
{0.402997,0.378073},
{0.376163,0.40373},
{0.361681,0.437071},
{0.33871,0.496391},
{0.306727,0.537784},
{0.245103,0.553648},
{0.230937,0.609058},
{0.219303,0.666022},
{0.221546,0.712214},
{0.229247,0.750468},
{0.261368,0.780546},
{0.294955,0.789481},
{0.335165,0.784559},
{0.380642,0.774994},
{0.385207,0.752257},
{0.433169,0.725899},
{0.420885,0.716104},
{0.437567,0.68825},
{0.433127,0.666314},
{0.408071,0.611364},
{0.423165,0.58331},
{0.431711,0.562684},
{0.427596,0.5456},
{0.390297,0.55873},
{0.362795,0.531218},
{0.374991,0.470494},
{0.396591,0.43608},
{0.415425,0.436096},
{0.424892,0.435424},
{0.625462,0.201221},
{0.648047,0.206497},
{0.64,0.193775},
{0.973242,0.077791},
{0.998368,0.105425},
{0.994554,0.072628},
{0.998368,0.105425},
{0.973242,0.077791},
{0.986514,0.10891},
{0.697756,0.230153},
{0.693018,0.208533},
{0.689208,0.233093},
{0.693018,0.208533},
{0.697756,0.230153},
{0.708512,0.20653},
{0.704016,0.223478},
{0.708512,0.20653},
{0.697756,0.230153},
{0.708512,0.20653},
{0.704016,0.223478},
{0.714955,0.200863},
{0.689208,0.233093},
{0.693018,0.208533},
{0.674028,0.221811},
{0.674028,0.221811},
{0.668383,0.187281},
{0.664582,0.207627},
{0.668383,0.187281},
{0.674028,0.221811},
{0.693018,0.208533},
{0.664582,0.207627},
{0.64,0.193775},
{0.648047,0.206497},
{0.64,0.193775},
{0.664582,0.207627},
{0.668383,0.187281},
{0.708512,0.20653},
{0.691905,0.173933},
{0.693018,0.208533},
{0.691905,0.173933},
{0.708512,0.20653},
{0.704955,0.160487},
{0.714955,0.200863},
{0.704955,0.160487},
{0.708512,0.20653},
{0.704955,0.160487},
{0.714955,0.200863},
{0.713001,0.148214},
{0.693018,0.208533},
{0.691905,0.173933},
{0.668383,0.187281},
{0.64,0.193775},
{0.618998,0.192887},
{0.625462,0.201221},
{0.618998,0.192887},
{0.64,0.193775},
{0.635217,0.169784},
{0.668383,0.187281},
{0.635217,0.169784},
{0.64,0.193775},
{0.704955,0.160487},
{0.666271,0.153045},
{0.691905,0.173933},
{0.666271,0.153045},
{0.704955,0.160487},
{0.678637,0.133319},
{0.713001,0.148214},
{0.678637,0.133319},
{0.704955,0.160487},
{0.678637,0.133319},
{0.713001,0.148214},
{0.682302,0.117858},
{0.691905,0.173933},
{0.666271,0.153045},
{0.668383,0.187281},
{0.635217,0.169784},
{0.607496,0.180872},
{0.618998,0.192887},
{0.607496,0.180872},
{0.635217,0.169784},
{0.61102,0.166215},
{0.666271,0.153045},
{0.6423,0.130008},
{0.638543,0.150119},
{0.6423,0.130008},
{0.666271,0.153045},
{0.678637,0.133319},
{0.682302,0.117858},
{0.6423,0.130008},
{0.678637,0.133319},
{0.6423,0.130008},
{0.682302,0.117858},
{0.640602,0.113724},
{0.638543,0.150119},
{0.6423,0.130008},
{0.610285,0.14603},
{0.61102,0.166215},
{0.585469,0.18164},
{0.593104,0.18704},
{0.6423,0.130008},
{0.6123,0.129369},
{0.610285,0.14603},
{0.6123,0.129369},
{0.6423,0.130008},
{0.640602,0.113724},
{0.61102,0.166215},
{0.585718,0.163451},
{0.585469,0.18164},
{0.610285,0.14603},
{0.587216,0.135125},
{0.586178,0.145999},
{0.587216,0.135125},
{0.610285,0.14603},
{0.6123,0.129369},
{0.585718,0.163451},
{0.610285,0.14603},
{0.586178,0.145999},
{0.610285,0.14603},
{0.585718,0.163451},
{0.61102,0.166215},
{0.61102,0.166215},
{0.593104,0.18704},
{0.607496,0.180872},
{0.917518,0.190159},
{0.936357,0.200629},
{0.928111,0.172715},
{0.928111,0.172715},
{0.936357,0.200629},
{0.953634,0.14309},
{0.982657,0.231999},
{0.95617,0.268336},
{0.972387,0.257651},
{0.993646,0.206695},
{0.95617,0.268336},
{0.982657,0.231999},
{0.95617,0.268336},
{0.993646,0.206695},
{0.950741,0.227869},
{0.988809,0.18091},
{0.950741,0.227869},
{0.993646,0.206695},
{0.970327,0.154084},
{0.950741,0.227869},
{0.988809,0.18091},
{0.950741,0.227869},
{0.970327,0.154084},
{0.936357,0.200629},
{0.953634,0.14309},
{0.936357,0.200629},
{0.970327,0.154084},
{0.635217,0.169784},
{0.610285,0.14603},
{0.61102,0.166215},
{0.610285,0.14603},
{0.635217,0.169784},
{0.638543,0.150119},
{0.638543,0.150119},
{0.635217,0.169784},
{0.666271,0.153045},
{0.668383,0.187281},
{0.666271,0.153045},
{0.635217,0.169784},
{0.739063,0.228579},
{0.779348,0.284334},
{0.838261,0.271743},
{0.732278,0.165734},
{0.771461,0.175362},
{0.842826,0.201391},
{0.889879,0.207305},
{0.923368,0.262389},
{0.952125,0.313672},
{0.887392,0.325072},
{0.845703,0.339914},
{0.867577,0.161932},
{0.904982,0.186305},
{0.867324,0.170692},
{0.904982,0.186305},
{0.867577,0.161932},
{0.906685,0.158569},
{0.429168,0.082459},
{0.497382,0.105105},
{0.412259,0.077655},
{0.906685,0.158569},
{0.867577,0.161932},
{0.907618,0.137312},
{0.477883,0.137176},
{0.517925,0.161796},
{0.545431,0.135498},
{0.572683,0.115179},
{0.605094,0.103175},
{0.414303,0.113344},
{0.447759,0.008083},
{0.405668,0.039656},
{0.433114,0.04416},
{0.405668,0.039656},
{0.447759,0.008083},
{0.424054,0.002455},
{0.405668,0.039656},
{0.412259,0.077655},
{0.433114,0.04416},
{0.412259,0.077655},
{0.405668,0.039656},
{0.390948,0.072492},
{0.417842,0.429923},
{0.432247,0.42714},
{0.434757,0.433473},
{0.437515,0.437858},
{0.450972,0.426515},
{0.455252,0.438147},
{0.441055,0.440307},
{0.428686,0.437893},
{0.424892,0.435424},
{0.429937,0.420637},
{0.450067,0.413997},
{0.389605,0.729071},
{0.349204,0.738022},
{0.34119,0.762675},
{0.316317,0.73786},
{0.330011,0.712748},
{0.360112,0.712443},
{0.387253,0.709987},
{0.477245,0.444375},
{0.499941,0.442156},
{0.485562,0.443962},
{0.463446,0.446819},
{0.475974,0.446299},
{0.2627,0.6772},
{0.257769,0.704401},
{0.281244,0.698918},
{0.291024,0.680742},
{0.304354,0.687967},
{0.294736,0.697852},
{0.283894,0.720282},
{0.263604,0.733862},
{0.272081,0.648474},
{0.297986,0.668262},
{0.309117,0.682817},
{0.310365,0.693369},
{0.475974,0.446299},
{0.448872,0.443627},
{0.434669,0.438669},
{0.461956,0.445567},
{0.48682,0.443291},
{0.461956,0.445567},
{0.468404,0.445131},
{0.441055,0.440307},
{0.445172,0.439854},
{0.468404,0.445131},
{0.461956,0.445567},
{0.40044,0.637037},
{0.365121,0.618905},
{0.360066,0.648835},
{0.397449,0.662352},
{0.361444,0.66719},
{0.340476,0.648279},
{0.330012,0.612736},
{0.375234,0.589647},
{0.41912,0.676293},
{0.391385,0.675884},
{0.380959,0.678618},
{0.362142,0.672283},
{0.344366,0.672841},
{0.342936,0.667604},
{0.322171,0.673455},
{0.31295,0.655458},
{0.294363,0.627018},
{0.291344,0.578851},
{0.343571,0.565333},
{0.302392,0.767512},
{0.299119,0.735005},
{0.312524,0.712193},
{0.319296,0.703492},
{0.334868,0.708636},
{0.359346,0.706736},
{0.381733,0.704519},
{0.407143,0.703372},
{0.420671,0.683577},
{0.411162,0.681766},
{0.395665,0.681058},
{0.392594,0.685683},
{0.382472,0.686243},
{0.365618,0.684492},
{0.350258,0.684385},
{0.336267,0.689432},
{0.326082,0.677884},
{0.274392,0.75824},
{0.297655,0.705792},
{0.306768,0.696832},
{0.404253,0.418717},
{0.422317,0.403404},
{0.499941,0.438806},
{0.499941,0.441178},
{0.397529,0.697121},
{0.388362,0.690249},
{0.403661,0.684008},
{0.357588,0.700233},
{0.342031,0.701062},
{0.329488,0.699941},
{0.319574,0.697408},
{0.306768,0.696832},
{0.375769,0.696992},
{0.314797,0.686819},
{0.326494,0.69396},
{0.306768,0.696832},
{0.310365,0.693369},
{0.625462,0.201221},
{0.64,0.193775},
{0.648047,0.206497},
{0.986514,0.10891},
{0.971198,0.113481},
{0.956334,0.082596},
{0.973242,0.077791},
{0.973242,0.077791},
{0.998368,0.105425},
{0.986514,0.10891},
{0.998368,0.105425},
{0.973242,0.077791},
{0.994554,0.072628},
{0.697756,0.230153},
{0.693018,0.208533},
{0.708512,0.20653},
{0.693018,0.208533},
{0.697756,0.230153},
{0.689208,0.233093},
{0.704016,0.223478},
{0.708512,0.20653},
{0.714955,0.200863},
{0.708512,0.20653},
{0.704016,0.223478},
{0.697756,0.230153},
{0.689208,0.233093},
{0.674028,0.221811},
{0.693018,0.208533},
{0.674028,0.221811},
{0.668383,0.187281},
{0.693018,0.208533},
{0.668383,0.187281},
{0.674028,0.221811},
{0.664582,0.207627},
{0.664582,0.207627},
{0.64,0.193775},
{0.668383,0.187281},
{0.64,0.193775},
{0.664582,0.207627},
{0.648047,0.206497},
{0.708512,0.20653},
{0.691905,0.173933},
{0.704955,0.160487},
{0.691905,0.173933},
{0.708512,0.20653},
{0.693018,0.208533},
{0.714955,0.200863},
{0.704955,0.160487},
{0.713001,0.148214},
{0.704955,0.160487},
{0.714955,0.200863},
{0.708512,0.20653},
{0.693018,0.208533},
{0.668383,0.187281},
{0.691905,0.173933},
{0.64,0.193775},
{0.618998,0.192887},
{0.635217,0.169784},
{0.618998,0.192887},
{0.64,0.193775},
{0.625462,0.201221},
{0.668383,0.187281},
{0.64,0.193775},
{0.635217,0.169784},
{0.704955,0.160487},
{0.666271,0.153045},
{0.678637,0.133319},
{0.666271,0.153045},
{0.704955,0.160487},
{0.691905,0.173933},
{0.713001,0.148214},
{0.678637,0.133319},
{0.682302,0.117858},
{0.678637,0.133319},
{0.713001,0.148214},
{0.704955,0.160487},
{0.691905,0.173933},
{0.668383,0.187281},
{0.666271,0.153045},
{0.635217,0.169784},
{0.607496,0.180872},
{0.61102,0.166215},
{0.607496,0.180872},
{0.635217,0.169784},
{0.618998,0.192887},
{0.666271,0.153045},
{0.6423,0.130008},
{0.678637,0.133319},
{0.6423,0.130008},
{0.666271,0.153045},
{0.638543,0.150119},
{0.682302,0.117858},
{0.6423,0.130008},
{0.640602,0.113724},
{0.6423,0.130008},
{0.682302,0.117858},
{0.678637,0.133319},
{0.638543,0.150119},
{0.610285,0.14603},
{0.6423,0.130008},
{0.61102,0.166215},
{0.593104,0.18704},
{0.585469,0.18164},
{0.6423,0.130008},
{0.6123,0.129369},
{0.640602,0.113724},
{0.6123,0.129369},
{0.6423,0.130008},
{0.610285,0.14603},
{0.61102,0.166215},
{0.585469,0.18164},
{0.585718,0.163451},
{0.610285,0.14603},
{0.587216,0.135125},
{0.6123,0.129369},
{0.587216,0.135125},
{0.610285,0.14603},
{0.586178,0.145999},
{0.585718,0.163451},
{0.610285,0.14603},
{0.61102,0.166215},
{0.610285,0.14603},
{0.585718,0.163451},
{0.586178,0.145999},
{0.61102,0.166215},
{0.607496,0.180872},
{0.593104,0.18704},
{0.917518,0.190159},
{0.92811,0.172715},
{0.936357,0.200629},
{0.92811,0.172715},
{0.953634,0.14309},
{0.936357,0.200629},
{0.982657,0.231999},
{0.972386,0.257651},
{0.95617,0.268336},
{0.993645,0.206695},
{0.95617,0.268336},
{0.950741,0.227869},
{0.95617,0.268336},
{0.993645,0.206695},
{0.982657,0.231999},
{0.988809,0.18091},
{0.993645,0.206695},
{0.950741,0.227869},
{0.970326,0.154084},
{0.950741,0.227869},
{0.936357,0.200629},
{0.950741,0.227869},
{0.970326,0.154084},
{0.988809,0.18091},
{0.953634,0.14309},
{0.970326,0.154084},
{0.936357,0.200629},
{0.635217,0.169784},
{0.610285,0.14603},
{0.638543,0.150119},
{0.610285,0.14603},
{0.635217,0.169784},
{0.61102,0.166215},
{0.638543,0.150119},
{0.666271,0.153045},
{0.635217,0.169784},
{0.668383,0.187281},
{0.635217,0.169784},
{0.666271,0.153045},
{0.309592,0.197289},
{0.36409,0.197289},
{0.36409,0.158132},
{0.309592,0.158132},
{0.36409,0.102935},
{0.309592,0.102935},
{0.36409,0.047739},
{0.309593,0.047738},
{0.36409,0.008582},
{0.309593,0.008582},
{0.941615,0.496951},
{0.994874,0.496951},
{0.994874,0.479656},
{0.941616,0.479656},
{0.994875,0.422608},
{0.941616,0.422608},
{0.994875,0.365561},
{0.941616,0.365561},
{0.994875,0.347258},
{0.941616,0.347258},
{0.960642,0.68041},
{0.986657,0.671152},
{0.983055,0.669061},
{0.960771,0.675519},
{0.976616,0.661581},
{0.986355,0.649599},
{0.996419,0.652088},
{0.997425,0.65145},
{0.994718,0.631454},
{0.986347,0.634771},
{0.976682,0.622761},
{0.981132,0.616987},
{0.99274,0.628901},
{0.981893,0.61518},
{0.960885,0.611178},
{0.960776,0.609954},
{0.994718,0.631454},
{0.997425,0.65145},
{0.99274,0.628901},
{0.960776,0.609954},
{0.939659,0.615118},
{0.940616,0.616928},
{0.960885,0.611178},
{0.928768,0.628806},
{0.926974,0.631354},
{0.935528,0.634696},
{0.935469,0.649525},
{0.925202,0.651984},
{0.945167,0.661535},
{0.938508,0.668996},
{0.924002,0.651342},
{0.928768,0.628806},
{0.925202,0.651984},
{0.926974,0.631354},
{0.934706,0.671075},
{0.960771,0.675519},
{0.960642,0.68041},
{0.960884,0.66614},
{0.960961,0.642382},
{0.960965,0.618156},
{0.945233,0.622715},
{0.620735,0.710628},
{0.643463,0.710615},
{0.645179,0.694425},
{0.623427,0.696525},
{0.64859,0.658209},
{0.671522,0.696745},
{0.673757,0.713007},
{0.694461,0.715481},
{0.694719,0.696632},
{0.724288,0.694263},
{0.724204,0.715413},
{0.753968,0.695689},
{0.756598,0.715601},
{0.779917,0.694994},
{0.782295,0.71197},
{0.804508,0.695294},
{0.805207,0.711192},
{0.601773,0.697388},
{0.588308,0.711266},
{0.672268,0.653305},
{0.656263,0.612884},
{0.682149,0.6102},
{0.709702,0.662647},
{0.712925,0.683846},
{0.737536,0.66393},
{0.755675,0.664149},
{0.777113,0.646401},
{0.805881,0.646135},
{0.629256,0.644886},
{0.635009,0.611909},
{0.63504,0.573333},
{0.661407,0.572864},
{0.682961,0.579065},
{0.703403,0.583695},
{0.707864,0.612242},
{0.608698,0.64619},
{0.609922,0.616471},
{0.615335,0.580879},
{0.609118,0.547523},
{0.633784,0.540506},
{0.663132,0.546275},
{0.694489,0.545191},
{0.715475,0.555677},
{0.727347,0.575326},
{0.72548,0.61457},
{0.747856,0.611825},
{0.764352,0.609732},
{0.791385,0.616471},
{0.768852,0.583414},
{0.782755,0.580879},
{0.789764,0.547523},
{0.774724,0.556208},
{0.772987,0.531036},
{0.792378,0.52428},
{0.757332,0.577502},
{0.755446,0.550924},
{0.754025,0.534545},
{0.736613,0.551564},
{0.739872,0.529846},
{0.730523,0.517511},
{0.699941,0.520411},
{0.710689,0.485129},
{0.68058,0.502261},
{0.691219,0.472529},
{0.663669,0.502825},
{0.661883,0.460581},
{0.639654,0.464767},
{0.644548,0.499805},
{0.616557,0.481104},
{0.615413,0.507202},
{0.608259,0.525523},
{0.033958,0.151895},
{0.047326,0.155021},
{0.055816,0.139228},
{0.027371,0.140236},
{0.056706,0.124997},
{0.087578,0.126654},
{0.080655,0.138462},
{0.072215,0.154004},
{0.033223,0.20703},
{0.052879,0.217041},
{0.054777,0.204115},
{0.036009,0.194262},
{0.042565,0.183198},
{0.051297,0.192097},
{0.080285,0.201519},
{0.089281,0.209976},
{0.051054,0.232713},
{0.02324,0.2186},
{0.017571,0.177199},
{0.028827,0.175478},
{0.041333,0.166662},
{0.084065,0.169703},
{0.073355,0.189222},
{0.106452,0.188625},
{0.109384,0.165839},
{0.137018,0.162635},
{0.13221,0.196221},
{0.101218,0.144076},
{0.13096,0.133707},
{0.193818,0.176669},
{0.202885,0.16429},
{0.194708,0.158914},
{0.179345,0.174908},
{0.164642,0.15933},
{0.184078,0.146532},
{0.198004,0.137363},
{0.095311,0.224316},
{0.133318,0.219526},
{0.152985,0.186868},
{0.156382,0.196913},
{0.156964,0.134004},
{0.157947,0.122771},
{0.127434,0.109691},
{0.086822,0.111092},
{0.055754,0.11396},
{0.056706,0.124997},
{0.020646,0.130608},
{0.007022,0.175323},
{0.018306,0.92602},
{0.017755,0.96121},
{0.033703,0.961211},
{0.033943,0.92602},
{0.050551,0.961211},
{0.049915,0.984046},
{0.029761,0.985093},
{0.01082,0.985077},
{0.32155,0.595616},
{0.336572,0.582208},
{0.346099,0.598319},
{0.330198,0.609518},
{0.325171,0.614572},
{0.31738,0.608827},
{0.31458,0.599241},
{0.079455,0.926021},
{0.066555,0.926021},
{0.066077,0.961211},
{0.080189,0.961211},
{0.069973,0.984307},
{0.049251,0.92602},
{0.387843,0.582692},
{0.360522,0.544998},
{0.38004,0.523348},
{0.414196,0.566904},
{0.436469,0.551623},
{0.403923,0.496448},
{0.455993,0.517473},
{0.455101,0.503139},
{0.439022,0.487846},
{0.3602,0.595104},
{0.343218,0.567322},
{0.3602,0.595104},
{0.343218,0.567322},
{0.087254,0.984428},
{0.466838,0.332007},
{0.463165,0.287304},
{0.434677,0.290925},
{0.436566,0.335346},
{0.410908,0.282052},
{0.403825,0.337732},
{0.378321,0.271142},
{0.374644,0.330571},
{0.347539,0.282052},
{0.347344,0.337732},
{0.322378,0.290719},
{0.321275,0.335346},
{0.295185,0.287304},
{0.295758,0.332007},
{0.266389,0.278355},
{0.269362,0.331637},
{0.495079,0.331637},
{0.492106,0.278355},
{0.462447,0.401782},
{0.474428,0.362561},
{0.434522,0.363013},
{0.4266,0.400639},
{0.400838,0.396566},
{0.410007,0.369618},
{0.377808,0.348198},
{0.375875,0.390494},
{0.346575,0.364908},
{0.327461,0.423252},
{0.313801,0.354042},
{0.302378,0.408688},
{0.264344,0.352176},
{0.273111,0.419863},
{0.524131,0.400785},
{0.520278,0.355218},
{0.574071,0.419863},
{0.565304,0.352176},
{0.357255,0.496426},
{0.414415,0.469451},
{0.350371,0.470683},
{0.36594,0.411897},
{0.417175,0.409145},
{0.444651,0.478985},
{0.446684,0.412491},
{0.477559,0.411811},
{0.482807,0.47163},
{0.524164,0.412412},
{0.546241,0.47271},
{0.54207,0.489749},
{0.857686,0.744473},
{0.831358,0.770757},
{0.86349,0.772368},
{0.875243,0.763821},
{0.884634,0.72955},
{0.871808,0.712468},
{0.8405,0.711665},
{0.820883,0.722027},
{0.822071,0.746365},
{0.620735,0.710628},
{0.623427,0.696525},
{0.645179,0.694425},
{0.643463,0.710615},
{0.671522,0.696745},
{0.64859,0.658209},
{0.629256,0.644886},
{0.608698,0.64619},
{0.601773,0.697388},
{0.588308,0.711266},
{0.779917,0.694994},
{0.782295,0.71197},
{0.756598,0.715601},
{0.753968,0.695689},
{0.724204,0.715413},
{0.724288,0.694263},
{0.694461,0.715481},
{0.694719,0.696632},
{0.673757,0.713007},
{0.804508,0.695294},
{0.805207,0.711192},
{0.805881,0.646135},
{0.777113,0.646401},
{0.755675,0.664149},
{0.737536,0.66393},
{0.712925,0.683846},
{0.672268,0.653305},
{0.656263,0.612884},
{0.635009,0.611909},
{0.609922,0.616471},
{0.709702,0.662647},
{0.682149,0.6102},
{0.682961,0.579065},
{0.661407,0.572864},
{0.63504,0.573333},
{0.615335,0.580879},
{0.707864,0.612242},
{0.703403,0.583695},
{0.715475,0.555677},
{0.694489,0.545191},
{0.663132,0.546275},
{0.633784,0.540506},
{0.609118,0.547523},
{0.72548,0.61457},
{0.747856,0.611825},
{0.727347,0.575326},
{0.736613,0.551564},
{0.730523,0.517511},
{0.699941,0.520411},
{0.68058,0.502261},
{0.663669,0.502825},
{0.644548,0.499805},
{0.615413,0.507202},
{0.608259,0.525523},
{0.764352,0.609732},
{0.791385,0.616471},
{0.768852,0.583414},
{0.782755,0.580879},
{0.789764,0.547523},
{0.774724,0.556208},
{0.757332,0.577502},
{0.755446,0.550924},
{0.691219,0.472529},
{0.661883,0.460581},
{0.639654,0.464767},
{0.616557,0.481104},
{0.772987,0.531036},
{0.792378,0.52428},
{0.739872,0.529846},
{0.754025,0.534545},
{0.710689,0.485129},
{0.047326,0.155021},
{0.033958,0.151895},
{0.055816,0.139228},
{0.072215,0.154004},
{0.080655,0.138462},
{0.087578,0.126654},
{0.056706,0.124997},
{0.027371,0.140236},
{0.028827,0.175478},
{0.041333,0.166662},
{0.033223,0.20703},
{0.036009,0.194262},
{0.054777,0.204115},
{0.052879,0.217041},
{0.089281,0.209976},
{0.080285,0.201519},
{0.051297,0.192097},
{0.042565,0.183198},
{0.017571,0.177199},
{0.02324,0.2186},
{0.051054,0.232713},
{0.095311,0.224316},
{0.13221,0.196221},
{0.106452,0.188625},
{0.073355,0.189222},
{0.084065,0.169703},
{0.109384,0.165839},
{0.101218,0.144076},
{0.137018,0.162635},
{0.13096,0.133707},
{0.193818,0.176669},
{0.179345,0.174908},
{0.194708,0.158914},
{0.202885,0.16429},
{0.198004,0.137363},
{0.184078,0.146532},
{0.164642,0.15933},
{0.152985,0.186868},
{0.156382,0.196913},
{0.133318,0.219526},
{0.127434,0.109691},
{0.157947,0.122771},
{0.156964,0.134004},
{0.020646,0.130608},
{0.055754,0.11396},
{0.056706,0.124997},
{0.086822,0.111092},
{0.007022,0.175323},
{0.018306,0.92602},
{0.033943,0.92602},
{0.033703,0.961211},
{0.017755,0.96121},
{0.029761,0.985093},
{0.049915,0.984046},
{0.050551,0.961211},
{0.049251,0.92602},
{0.066555,0.926021},
{0.066077,0.961211},
{0.079455,0.926021},
{0.080189,0.961211},
{0.069973,0.984307},
{0.087254,0.984428},
{0.32155,0.595616},
{0.330198,0.609518},
{0.346099,0.598319},
{0.336572,0.582208},
{0.3602,0.595104},
{0.387843,0.582692},
{0.414196,0.566904},
{0.38004,0.523348},
{0.360522,0.544998},
{0.343218,0.567322},
{0.31458,0.599241},
{0.31738,0.608827},
{0.325171,0.614572},
{0.436469,0.551623},
{0.455993,0.517473},
{0.403923,0.496448},
{0.455101,0.503139},
{0.439022,0.487846},
{0.01082,0.985077},
{0.3602,0.595104},
{0.343218,0.567322},
{0.466838,0.332007},
{0.436566,0.335346},
{0.434677,0.290925},
{0.463165,0.287304},
{0.495079,0.331637},
{0.492106,0.278355},
{0.295758,0.332007},
{0.269362,0.331637},
{0.266389,0.278355},
{0.295185,0.287304},
{0.321275,0.335346},
{0.322378,0.290719},
{0.347344,0.337732},
{0.347539,0.282052},
{0.374644,0.330571},
{0.378321,0.271142},
{0.403825,0.337732},
{0.410908,0.282052},
{0.462447,0.401782},
{0.4266,0.400639},
{0.434522,0.363013},
{0.474428,0.362561},
{0.524131,0.400785},
{0.520278,0.355218},
{0.574071,0.419863},
{0.565304,0.352176},
{0.302378,0.408688},
{0.273111,0.419863},
{0.264344,0.352176},
{0.313801,0.354042},
{0.327461,0.423252},
{0.346575,0.364908},
{0.375875,0.390494},
{0.377808,0.348198},
{0.400838,0.396566},
{0.410007,0.369618},
{0.357255,0.496426},
{0.350371,0.470683},
{0.414415,0.469451},
{0.36594,0.411897},
{0.417175,0.409145},
{0.444651,0.478985},
{0.446684,0.412491},
{0.477559,0.411811},
{0.482807,0.47163},
{0.524164,0.412412},
{0.546241,0.47271},
{0.54207,0.489749},
{0.86349,0.772368},
{0.831358,0.770757},
{0.857686,0.744473},
{0.822071,0.746365},
{0.820883,0.722027},
{0.8405,0.711665},
{0.871808,0.712468},
{0.884634,0.72955},
{0.875243,0.763821},
{0.170631,0.477532},
{0.191982,0.47763},
{0.210629,0.449935},
{0.170369,0.446912},
{0.145029,0.473417},
{0.130811,0.441748},
{0.130734,0.47631},
{0.096043,0.456185},
{0.11205,0.484001},
{0.091648,0.478305},
{0.069826,0.472893},
{0.072103,0.455029},
{0.040751,0.481063},
{0.044315,0.450855},
{0.015385,0.483249},
{0.015385,0.448307},
{0.206295,0.475996},
{0.239253,0.473384},
{0.238387,0.450407},
{0.062522,0.888251},
{0.095014,0.893358},
{0.089953,0.85399},
{0.060022,0.870634},
{0.070709,0.834995},
{0.103538,0.844239},
{0.113752,0.877902},
{0.105004,0.904751},
{0.084542,0.922285},
{0.057079,0.907357},
{0.191211,0.914339},
{0.180016,0.942362},
{0.2156,0.954001},
{0.228234,0.913158},
{0.264556,0.934445},
{0.241779,0.967322},
{0.2287,0.996635},
{0.201015,0.98613},
{0.165468,0.970053},
{0.145968,0.926255},
{0.164533,0.902099},
{0.17799,0.879963},
{0.218078,0.872179},
{0.250685,0.883073},
{0.285185,0.902017},
{0.283134,0.922048},
{0.144577,0.881204},
{0.121669,0.909843},
{0.130948,0.951205},
{0.105415,0.935681},
{0.132895,0.864545},
{0.158005,0.854812},
{0.171917,0.82243},
{0.148452,0.828639},
{0.198259,0.851155},
{0.216423,0.835753},
{0.237359,0.824085},
{0.250679,0.857817},
{0.274413,0.834435},
{0.289482,0.857378},
{0.293633,0.886106},
{0.092374,0.927265},
{0.124676,0.833815},
{0.141117,0.794699},
{0.163423,0.78711},
{0.202026,0.809469},
{0.183422,0.706148},
{0.159832,0.736811},
{0.197449,0.730586},
{0.19674,0.698491},
{0.218926,0.723329},
{0.232059,0.752633},
{0.201187,0.753358},
{0.155253,0.765173},
{0.130918,0.76972},
{0.120952,0.752328},
{0.133909,0.727625},
{0.16793,0.69794},
{0.193553,0.778303},
{0.222641,0.799954},
{0.20835,0.772244},
{0.249892,0.779794},
{0.272662,0.73474},
{0.283169,0.761219},
{0.296584,0.783433},
{0.26384,0.806893},
{0.212331,0.69616},
{0.240151,0.686943},
{0.257834,0.711773},
{0.325949,0.702676},
{0.345969,0.725415},
{0.357465,0.752108},
{0.311149,0.805536},
{0.331001,0.830254},
{0.341127,0.851088},
{0.314141,0.875131},
{0.299135,0.88358},
{0.367301,0.716217},
{0.399031,0.70155},
{0.387304,0.680404},
{0.346529,0.696807},
{0.377358,0.66585},
{0.437892,0.633342},
{0.451735,0.658647},
{0.469895,0.686988},
{0.40933,0.721312},
{0.379057,0.74217},
{0.367709,0.744063},
{0.331516,0.671684},
{0.360527,0.644571},
{0.42279,0.611809},
{0.383399,0.789059},
{0.392348,0.801781},
{0.418127,0.798265},
{0.403823,0.778427},
{0.431856,0.762896},
{0.446109,0.784237},
{0.503861,0.735518},
{0.487108,0.709798},
{0.417704,0.741832},
{0.311967,0.680249},
{0.309378,0.648371},
{0.328272,0.63885},
{0.348454,0.622075},
{0.413892,0.592353},
{0.365458,0.768493},
{0.37754,0.76127},
{0.386797,0.754692},
{0.086636,0.807149},
{0.115235,0.801204},
{0.051417,0.820142},
{0.059748,0.780643},
{0.073847,0.751757},
{0.107333,0.771721},
{0.112099,0.742657},
{0.12176,0.719802},
{0.14605,0.694638},
{0.140738,0.660203},
{0.159974,0.657278},
{0.027313,0.705267},
{0.017856,0.707456},
{0.017856,0.744745},
{0.03848,0.747422},
{0.017856,0.776543},
{0.036174,0.780983},
{0.017856,0.812158},
{0.037072,0.815541},
{0.017662,0.84262},
{0.032338,0.847053},
{0.040158,0.850043},
{0.052914,0.86088},
{0.071564,0.643792},
{0.072461,0.651856},
{0.095448,0.657662},
{0.098768,0.652769},
{0.113533,0.667254},
{0.101945,0.678345},
{0.089569,0.669024},
{0.068388,0.66465},
{0.05027,0.666385},
{0.044735,0.652847},
{0.040701,0.649349},
{0.026483,0.666695},
{0.017856,0.664541},
{0.017856,0.641897},
{0.073297,0.732684},
{0.040576,0.702158},
{0.047343,0.725344},
{0.073248,0.713231},
{0.098763,0.728805},
{0.110131,0.715035},
{0.128452,0.690824},
{0.123772,0.661708},
{0.041219,0.679323},
{0.054564,0.684022},
{0.053657,0.698721},
{0.082959,0.710702},
{0.088,0.700341},
{0.110463,0.691824},
{0.079997,0.681848},
{0.065816,0.676688},
{0.069677,0.690789},
{0.059065,0.710091},
{0.106099,0.631361},
{0.082991,0.606214},
{0.096985,0.594213},
{0.143875,0.581105},
{0.145008,0.637463},
{0.202079,0.585839},
{0.190521,0.666389},
{0.206905,0.668804},
{0.17909,0.05765},
{0.221861,0.054754},
{0.227267,0.018194},
{0.17909,0.011414},
{0.130796,0.018194},
{0.136269,0.054753},
{0.091033,0.052016},
{0.095817,0.017773},
{0.063426,0.053239},
{0.065659,0.011326},
{0.034395,0.011152},
{0.034395,0.053064},
{0.267048,0.052016},
{0.277476,0.01455},
{0.272482,0.08626},
{0.221868,0.103639},
{0.17909,0.090562},
{0.13633,0.103639},
{0.085733,0.08626},
{0.294789,0.053239},
{0.323819,0.053064},
{0.323819,0.011152},
{0.60838,0.440557},
{0.639378,0.451693},
{0.625109,0.424588},
{0.655421,0.426349},
{0.675667,0.441084},
{0.693428,0.40407},
{0.659818,0.376338},
{0.679304,0.362072},
{0.644939,0.348706},
{0.625964,0.376324},
{0.608772,0.360163},
{0.590441,0.399433},
{0.44021,0.040905},
{0.475009,0.036153},
{0.477941,0.028555},
{0.427687,0.034359},
{0.442652,0.011256},
{0.485395,0.008669},
{0.520258,0.012229},
{0.512358,0.030219},
{0.507269,0.03969},
{0.498629,0.05115},
{0.471545,0.049048},
{0.445124,0.054229},
{0.416656,0.057155},
{0.397028,0.036697},
{0.397028,0.023561},
{0.420189,0.017409},
{0.468862,0.066552},
{0.438368,0.068838},
{0.397028,0.051398},
{0.498271,0.075993},
{0.46755,0.086485},
{0.501186,0.094909},
{0.523152,0.100139},
{0.532264,0.072564},
{0.55899,0.085084},
{0.556162,0.118491},
{0.518861,0.059694},
{0.529701,0.046792},
{0.551669,0.052941},
{0.57621,0.027341},
{0.587763,0.082277},
{0.623956,0.028732},
{0.633836,0.066752},
{0.656957,0.026145},
{0.671855,0.064685},
{0.70264,0.043471},
{0.703915,0.06675},
{0.752435,0.042147},
{0.745024,0.074621},
{0.780502,0.057071},
{0.760944,0.078601},
{0.741368,0.088467},
{0.754264,0.09599},
{0.767162,0.085636},
{0.7914,0.08104},
{0.79164,0.082088},
{0.775207,0.116613},
{0.754158,0.116395},
{0.751071,0.131778},
{0.74184,0.128347},
{0.736439,0.143706},
{0.756093,0.13521},
{0.781873,0.13076},
{0.814845,0.099642},
{0.814839,0.114251},
{0.544572,0.024194},
{0.814849,0.060652},
{0.814856,0.031474},
{0.793072,0.02588},
{0.494093,0.510772},
{0.479514,0.531458},
{0.512949,0.533704},
{0.512957,0.497846},
{0.538639,0.572375},
{0.54223,0.500153},
{0.579331,0.500211},
{0.586499,0.560949},
{0.45287,0.91181},
{0.489503,0.906509},
{0.503531,0.946342},
{0.454727,0.953776},
{0.420706,0.91716},
{0.40196,0.993035},
{0.422334,0.886285},
{0.453649,0.890472},
{0.487714,0.876399},
{0.454623,0.869485},
{0.424982,0.863024},
{0.421813,0.844651},
{0.452903,0.811028},
{0.470081,0.837059},
{0.279717,0.163676},
{0.302508,0.17204},
{0.31023,0.147547},
{0.347341,0.147551},
{0.326088,0.178172},
{0.279717,0.108789},
{0.31023,0.118564},
{0.339214,0.124009},
{0.170631,0.477532},
{0.170369,0.446912},
{0.210629,0.449935},
{0.191982,0.47763},
{0.206295,0.475996},
{0.238387,0.450407},
{0.239253,0.473384},
{0.145029,0.473417},
{0.130811,0.441748},
{0.130734,0.47631},
{0.096043,0.456185},
{0.11205,0.484001},
{0.091648,0.478305},
{0.069826,0.472893},
{0.072103,0.455029},
{0.040751,0.481063},
{0.044315,0.450855},
{0.015385,0.483249},
{0.015385,0.448307},
{0.062522,0.888251},
{0.060022,0.870634},
{0.089953,0.85399},
{0.095014,0.893358},
{0.103538,0.844239},
{0.070709,0.834995},
{0.052914,0.86088},
{0.040158,0.850043},
{0.051417,0.820142},
{0.032338,0.847053},
{0.037072,0.815541},
{0.017662,0.84262},
{0.017856,0.812158},
{0.036174,0.780983},
{0.017856,0.776543},
{0.03848,0.747422},
{0.017856,0.744745},
{0.027313,0.705267},
{0.017856,0.707456},
{0.026483,0.666695},
{0.017856,0.664541},
{0.040701,0.649349},
{0.017856,0.641897},
{0.191211,0.914339},
{0.228234,0.913158},
{0.2156,0.954001},
{0.180016,0.942362},
{0.201015,0.98613},
{0.2287,0.996635},
{0.241779,0.967322},
{0.264556,0.934445},
{0.285185,0.902017},
{0.250685,0.883073},
{0.218078,0.872179},
{0.17799,0.879963},
{0.164533,0.902099},
{0.145968,0.926255},
{0.165468,0.970053},
{0.283134,0.922048},
{0.121669,0.909843},
{0.144577,0.881204},
{0.113752,0.877902},
{0.105004,0.904751},
{0.105415,0.935681},
{0.130948,0.951205},
{0.132895,0.864545},
{0.158005,0.854812},
{0.198259,0.851155},
{0.171917,0.82243},
{0.148452,0.828639},
{0.124676,0.833815},
{0.084542,0.922285},
{0.092374,0.927265},
{0.057079,0.907357},
{0.293633,0.886106},
{0.289482,0.857378},
{0.274413,0.834435},
{0.250679,0.857817},
{0.237359,0.824085},
{0.216423,0.835753},
{0.183422,0.706148},
{0.19674,0.698491},
{0.197449,0.730586},
{0.159832,0.736811},
{0.201187,0.753358},
{0.232059,0.752633},
{0.218926,0.723329},
{0.212331,0.69616},
{0.240151,0.686943},
{0.257834,0.711773},
{0.309378,0.648371},
{0.311967,0.680249},
{0.331516,0.671684},
{0.328272,0.63885},
{0.348454,0.622075},
{0.360527,0.644571},
{0.42279,0.611809},
{0.413892,0.592353},
{0.163423,0.78711},
{0.193553,0.778303},
{0.202026,0.809469},
{0.222641,0.799954},
{0.20835,0.772244},
{0.155253,0.765173},
{0.130918,0.76972},
{0.141117,0.794699},
{0.249892,0.779794},
{0.26384,0.806893},
{0.296584,0.783433},
{0.283169,0.761219},
{0.272662,0.73474},
{0.120952,0.752328},
{0.107333,0.771721},
{0.115235,0.801204},
{0.311149,0.805536},
{0.357465,0.752108},
{0.345969,0.725415},
{0.325949,0.702676},
{0.346529,0.696807},
{0.377358,0.66585},
{0.437892,0.633342},
{0.387304,0.680404},
{0.451735,0.658647},
{0.399031,0.70155},
{0.469895,0.686988},
{0.40933,0.721312},
{0.487108,0.709798},
{0.417704,0.741832},
{0.431856,0.762896},
{0.503861,0.735518},
{0.446109,0.784237},
{0.418127,0.798265},
{0.403823,0.778427},
{0.383399,0.789059},
{0.392348,0.801781},
{0.331001,0.830254},
{0.341127,0.851088},
{0.314141,0.875131},
{0.299135,0.88358},
{0.365458,0.768493},
{0.367709,0.744063},
{0.367301,0.716217},
{0.379057,0.74217},
{0.386797,0.754692},
{0.37754,0.76127},
{0.086636,0.807149},
{0.059748,0.780643},
{0.073847,0.751757},
{0.073297,0.732684},
{0.047343,0.725344},
{0.040576,0.702158},
{0.041219,0.679323},
{0.044735,0.652847},
{0.071564,0.643792},
{0.072461,0.651856},
{0.095448,0.657662},
{0.098768,0.652769},
{0.113533,0.667254},
{0.123772,0.661708},
{0.128452,0.690824},
{0.140738,0.660203},
{0.14605,0.694638},
{0.16793,0.69794},
{0.159974,0.657278},
{0.05027,0.666385},
{0.068388,0.66465},
{0.089569,0.669024},
{0.101945,0.678345},
{0.110463,0.691824},
{0.110131,0.715035},
{0.12176,0.719802},
{0.133909,0.727625},
{0.073248,0.713231},
{0.082959,0.710702},
{0.098763,0.728805},
{0.112099,0.742657},
{0.088,0.700341},
{0.069677,0.690789},
{0.059065,0.710091},
{0.065816,0.676688},
{0.054564,0.684022},
{0.079997,0.681848},
{0.053657,0.698721},
{0.096985,0.594213},
{0.082991,0.606214},
{0.106099,0.631361},
{0.143875,0.581105},
{0.145008,0.637463},
{0.202079,0.585839},
{0.190521,0.666389},
{0.206905,0.668804},
{0.17909,0.05765},
{0.17909,0.011414},
{0.227267,0.018194},
{0.221861,0.054754},
{0.267048,0.052016},
{0.277476,0.01455},
{0.294789,0.053239},
{0.323819,0.053064},
{0.323819,0.011152},
{0.063426,0.053239},
{0.034395,0.053064},
{0.034395,0.011152},
{0.065659,0.011326},
{0.095817,0.017773},
{0.091033,0.052016},
{0.130796,0.018194},
{0.136269,0.054753},
{0.17909,0.090562},
{0.221868,0.103639},
{0.272482,0.08626},
{0.085733,0.08626},
{0.13633,0.103639},
{0.625109,0.424588},
{0.639378,0.451693},
{0.60838,0.440557},
{0.590441,0.399433},
{0.625964,0.376324},
{0.608772,0.360163},
{0.644939,0.348706},
{0.659818,0.376338},
{0.679304,0.362072},
{0.693428,0.40407},
{0.655421,0.426349},
{0.675667,0.441084},
{0.44021,0.040905},
{0.427687,0.034359},
{0.477941,0.028555},
{0.475009,0.036153},
{0.507269,0.03969},
{0.512358,0.030219},
{0.520258,0.012229},
{0.485395,0.008669},
{0.442652,0.011256},
{0.420189,0.017409},
{0.397028,0.023561},
{0.397028,0.036697},
{0.416656,0.057155},
{0.445124,0.054229},
{0.471545,0.049048},
{0.498629,0.05115},
{0.529701,0.046792},
{0.551669,0.052941},
{0.544572,0.024194},
{0.468862,0.066552},
{0.438368,0.068838},
{0.498271,0.075993},
{0.518861,0.059694},
{0.532264,0.072564},
{0.55899,0.085084},
{0.57621,0.027341},
{0.397028,0.051398},
{0.501186,0.094909},
{0.46755,0.086485},
{0.523152,0.100139},
{0.556162,0.118491},
{0.587763,0.082277},
{0.623956,0.028732},
{0.633836,0.066752},
{0.656957,0.026145},
{0.671855,0.064685},
{0.70264,0.043471},
{0.703915,0.06675},
{0.752435,0.042147},
{0.745024,0.074621},
{0.780502,0.057071},
{0.793072,0.02588},
{0.814849,0.060652},
{0.814856,0.031474},
{0.781873,0.13076},
{0.775207,0.116613},
{0.814845,0.099642},
{0.814839,0.114251},
{0.756093,0.13521},
{0.736439,0.143706},
{0.751071,0.131778},
{0.74184,0.128347},
{0.754158,0.116395},
{0.767162,0.085636},
{0.79164,0.082088},
{0.7914,0.08104},
{0.760944,0.078601},
{0.754264,0.09599},
{0.741368,0.088467},
{0.494093,0.510772},
{0.512957,0.497846},
{0.512949,0.533704},
{0.479514,0.531458},
{0.538639,0.572375},
{0.54223,0.500153},
{0.579331,0.500211},
{0.586499,0.560949},
{0.45287,0.91181},
{0.454727,0.953776},
{0.503531,0.946342},
{0.489503,0.906509},
{0.487714,0.876399},
{0.453649,0.890472},
{0.454623,0.869485},
{0.422334,0.886285},
{0.424982,0.863024},
{0.421813,0.844651},
{0.452903,0.811028},
{0.470081,0.837059},
{0.420706,0.91716},
{0.40196,0.993035},
{0.31023,0.147547},
{0.302508,0.17204},
{0.279717,0.163676},
{0.279717,0.108789},
{0.31023,0.118564},
{0.347341,0.147551},
{0.339214,0.124009},
{0.326088,0.178172},
{0.485341,0.602276},
{0.437892,0.633342},
{0.451735,0.658647},
{0.503798,0.62845},
{0.522027,0.651408},
{0.469895,0.686988},
{0.399031,0.70155},
{0.387304,0.680404},
{0.377358,0.66585},
{0.42279,0.611809},
{0.471702,0.583585},
{0.516411,0.576295},
{0.536625,0.608069},
{0.555112,0.631999},
{0.561585,0.655012},
{0.533419,0.670246},
{0.487108,0.709798},
{0.40933,0.721312},
{0.413892,0.592353},
{0.458291,0.566357},
{0.492381,0.560515},
{0.503861,0.735518},
{0.544417,0.693206},
{0.565576,0.684716},
{0.417704,0.741832},
{0.431856,0.762896},
{0.348454,0.622075},
{0.360527,0.644571},
{0.446109,0.784237},
{0.466104,0.543744},
{0.685706,0.33643},
{0.682298,0.339214},
{0.690974,0.355874},
{0.695441,0.353799},
{0.69879,0.375628},
{0.703435,0.373228},
{0.711111,0.38442},
{0.706025,0.386529},
{0.715514,0.406513},
{0.709808,0.407989},
{0.713465,0.419704},
{0.708371,0.421193},
{0.796394,0.425154},
{0.818281,0.414467},
{0.81552,0.40733},
{0.791807,0.417162},
{0.812413,0.396469},
{0.833615,0.400119},
{0.836404,0.405397},
{0.854809,0.389236},
{0.860137,0.394305},
{0.860812,0.387755},
{0.856747,0.382692},
{0.832264,0.389254},
{0.748236,0.429303},
{0.75645,0.402806},
{0.763203,0.426523},
{0.766773,0.457295},
{0.73828,0.444872},
{0.810097,0.491388},
{0.815885,0.478892},
{0.799271,0.470991},
{0.793919,0.483497},
{0.771893,0.453809},
{0.781847,0.447956},
{0.778195,0.433603},
{0.789997,0.428188},
{0.70713,0.269347},
{0.709572,0.299383},
{0.716981,0.282708},
{0.71384,0.270007},
{0.711425,0.236568},
{0.713429,0.2431},
{0.76111,0.464415},
{0.766645,0.467287},
{0.700271,0.267296},
{0.691282,0.299155},
{0.681459,0.260709},
{0.68306,0.255733},
{0.701562,0.262743},
{0.697647,0.224677},
{0.685766,0.230474},
{0.741972,0.373809},
{0.743424,0.361757},
{0.747379,0.385228},
{0.785532,0.389774},
{0.789911,0.403045},
{0.740425,0.253316},
{0.732462,0.280506},
{0.740017,0.286014},
{0.746887,0.257921},
{0.756078,0.261695},
{0.750272,0.297361},
{0.733394,0.292057},
{0.726542,0.282662},
{0.67488,0.28955},
{0.668226,0.321829},
{0.664547,0.325698},
{0.723308,0.319509},
{0.737769,0.336529},
{0.762275,0.338898},
{0.76269,0.356438},
{0.766457,0.362827},
{0.771348,0.368912},
{0.776793,0.376076},
{0.798278,0.368075},
{0.803697,0.380404},
{0.819499,0.359788},
{0.823611,0.370518},
{0.839934,0.356452},
{0.845184,0.360088},
{0.846816,0.355269},
{0.841411,0.350574},
{0.762374,0.316587},
{0.797307,0.320774},
{0.805638,0.323914},
{0.800351,0.318822},
{0.824952,0.310189},
{0.819607,0.304859},
{0.844006,0.292813},
{0.845143,0.279788},
{0.812366,0.2924},
{0.835381,0.277674},
{0.811685,0.28513},
{0.790405,0.298032},
{0.792485,0.305673},
{0.788987,0.30753},
{0.773589,0.307175},
{0.750272,0.297361},
{0.764099,0.260352},
{0.756461,0.258738},
{0.767563,0.236617},
{0.761056,0.235817},
{0.768552,0.216345},
{0.763378,0.206737},
{0.753005,0.233826},
{0.754359,0.21257},
{0.746445,0.230676},
{0.747692,0.255147},
{0.750272,0.297361},
{0.757236,0.284951},
{0.737296,0.307083},
{0.784305,0.286432},
{0.773317,0.277678},
{0.78572,0.284324},
{0.792178,0.289076},
{0.762374,0.316587},
{0.2138,0.568},
{0.265882,0.519502},
{0.213916,0.522372},
{0.175769,0.564425},
{0.174448,0.525835},
{0.138288,0.538187},
{0.140185,0.523506},
{0.101758,0.562652},
{0.097636,0.518893},
{0.062909,0.570707},
{0.055257,0.519284},
{0.006737,0.531432},
{0.01007,0.516088},
{0.266029,0.537199},
{0.308891,0.52026},
{0.253624,0.61012},
{0.305659,0.541055},
{0.341017,0.523064},
{0.016816,0.614848},
{0.337684,0.538408},
{0.485341,0.602276},
{0.503798,0.62845},
{0.451735,0.658647},
{0.437892,0.633342},
{0.387304,0.680404},
{0.399031,0.70155},
{0.469895,0.686988},
{0.522027,0.651408},
{0.555112,0.631999},
{0.536625,0.608069},
{0.516411,0.576295},
{0.471702,0.583585},
{0.42279,0.611809},
{0.377358,0.66585},
{0.413892,0.592353},
{0.458291,0.566357},
{0.348454,0.622075},
{0.360527,0.644571},
{0.487108,0.709798},
{0.533419,0.670246},
{0.544417,0.693206},
{0.503861,0.735518},
{0.431856,0.762896},
{0.446109,0.784237},
{0.40933,0.721312},
{0.417704,0.741832},
{0.492381,0.560515},
{0.466104,0.543744},
{0.565576,0.684716},
{0.561585,0.655012},
{0.685706,0.33643},
{0.695441,0.353799},
{0.690974,0.355874},
{0.682298,0.339214},
{0.668226,0.321829},
{0.664547,0.325698},
{0.796394,0.425154},
{0.791807,0.417162},
{0.81552,0.40733},
{0.818281,0.414467},
{0.833615,0.400119},
{0.812413,0.396469},
{0.789911,0.403045},
{0.75645,0.402806},
{0.763203,0.426523},
{0.778195,0.433603},
{0.789997,0.428188},
{0.713465,0.419704},
{0.715514,0.406513},
{0.748236,0.429303},
{0.73828,0.444872},
{0.766773,0.457295},
{0.747379,0.385228},
{0.711111,0.38442},
{0.706025,0.386529},
{0.709808,0.407989},
{0.708371,0.421193},
{0.799271,0.470991},
{0.815885,0.478892},
{0.810097,0.491388},
{0.793919,0.483497},
{0.766645,0.467287},
{0.76111,0.464415},
{0.70713,0.269347},
{0.71384,0.270007},
{0.716981,0.282708},
{0.709572,0.299383},
{0.726542,0.282662},
{0.733394,0.292057},
{0.732462,0.280506},
{0.740017,0.286014},
{0.740425,0.253316},
{0.746887,0.257921},
{0.747692,0.255147},
{0.746445,0.230676},
{0.753005,0.233826},
{0.754359,0.21257},
{0.763378,0.206737},
{0.761056,0.235817},
{0.768552,0.216345},
{0.767563,0.236617},
{0.756461,0.258738},
{0.764099,0.260352},
{0.756078,0.261695},
{0.750272,0.297361},
{0.771893,0.453809},
{0.781847,0.447956},
{0.691282,0.299155},
{0.700271,0.267296},
{0.701562,0.262743},
{0.68306,0.255733},
{0.681459,0.260709},
{0.67488,0.28955},
{0.723308,0.319509},
{0.737296,0.307083},
{0.750272,0.297361},
{0.836404,0.405397},
{0.854809,0.389236},
{0.860137,0.394305},
{0.860812,0.387755},
{0.856747,0.382692},
{0.832264,0.389254},
{0.792485,0.305673},
{0.812366,0.2924},
{0.819607,0.304859},
{0.800351,0.318822},
{0.824952,0.310189},
{0.844006,0.292813},
{0.845143,0.279788},
{0.835381,0.277674},
{0.811685,0.28513},
{0.790405,0.298032},
{0.788987,0.30753},
{0.797307,0.320774},
{0.805638,0.323914},
{0.841411,0.350574},
{0.846816,0.355269},
{0.839934,0.356452},
{0.845184,0.360088},
{0.823611,0.370518},
{0.819499,0.359788},
{0.803697,0.380404},
{0.798278,0.368075},
{0.785532,0.389774},
{0.776793,0.376076},
{0.806061,0.381082},
{0.812003,0.393878},
{0.827736,0.373767},
{0.832626,0.384483},
{0.851368,0.374756},
{0.853669,0.361916},
{0.862165,0.367585},
{0.711425,0.236568},
{0.713429,0.2431},
{0.703435,0.373228},
{0.69879,0.375628},
{0.741972,0.373809},
{0.743424,0.361757},
{0.737769,0.336529},
{0.697647,0.224677},
{0.685766,0.230474},
{0.766457,0.362827},
{0.771348,0.368912},
{0.791379,0.360237},
{0.788899,0.355642},
{0.76269,0.356438},
{0.762374,0.316587},
{0.762275,0.338898},
{0.750272,0.297361},
{0.757236,0.284951},
{0.773589,0.307175},
{0.773589,0.307175},
{0.762275,0.338898},
{0.781869,0.335037},
{0.775268,0.274148},
{0.790881,0.256216},
{0.801399,0.263924},
{0.78572,0.284324},
{0.806469,0.267425},
{0.820892,0.24159},
{0.819919,0.229473},
{0.807292,0.230888},
{0.797032,0.234295},
{0.80499,0.223219},
{0.807292,0.230888},
{0.786118,0.249893},
{0.770099,0.269737},
{0.773317,0.277678},
{0.784305,0.286432},
{0.792178,0.289076},
{0.757236,0.284951},
{0.757236,0.284951},
{0.762374,0.316587},
{0.762374,0.316587},
{0.773589,0.307175},
{0.785295,0.349877},
{0.783025,0.340807},
{0.796312,0.367336},
{0.803227,0.354258},
{0.801106,0.351002},
{0.800102,0.345805},
{0.788433,0.349148},
{0.786216,0.340188},
{0.788476,0.334632},
{0.781869,0.335037},
{0.762275,0.338898},
{0.818602,0.343959},
{0.817809,0.35215},
{0.808829,0.361151},
{0.822997,0.35437},
{0.823223,0.34686},
{0.815086,0.338017},
{0.798838,0.337644},
{0.800467,0.332579},
{0.815563,0.332285},
{0.213916,0.522372},
{0.265882,0.519502},
{0.2138,0.568},
{0.266029,0.537199},
{0.308891,0.52026},
{0.305659,0.541055},
{0.341017,0.523064},
{0.337684,0.538408},
{0.01007,0.516088},
{0.055257,0.519284},
{0.006737,0.531432},
{0.062909,0.570707},
{0.097636,0.518893},
{0.101758,0.562652},
{0.140185,0.523506},
{0.138288,0.538187},
{0.174448,0.525835},
{0.175769,0.564425},
{0.253624,0.61012},
{0.016816,0.614848},
{0.757236,0.284951},
{0.775268,0.274148},
{0.801399,0.263924},
{0.806469,0.267425},
{0.806061,0.381082},
{0.812003,0.393878},
{0.827736,0.373767},
{0.832626,0.384483},
{0.851368,0.374756},
{0.853669,0.361916},
{0.862165,0.367585},
{0.757236,0.284951},
{0.770099,0.269737},
{0.790881,0.256216},
{0.819919,0.229473},
{0.820892,0.24159},
{0.762374,0.316587},
{0.773589,0.307175},
{0.773589,0.307175},
{0.762275,0.338898},
{0.781869,0.335037},
{0.781869,0.335037},
{0.762275,0.338898},
{0.783025,0.340807},
{0.788476,0.334632},
{0.786216,0.340188},
{0.788433,0.349148},
{0.785295,0.349877},
{0.788899,0.355642},
{0.800102,0.345805},
{0.801106,0.351002},
{0.791379,0.360237},
{0.796312,0.367336},
{0.803227,0.354258},
{0.808829,0.361151},
{0.817809,0.35215},
{0.822997,0.35437},
{0.823223,0.34686},
{0.818602,0.343959},
{0.815086,0.338017},
{0.798838,0.337644},
{0.815563,0.332285},
{0.800467,0.332579},
{0.807292,0.230888},
{0.80499,0.223219},
{0.797032,0.234295},
{0.786118,0.249893},
{0.807292,0.230888},
{0.620735,0.710628},
{0.643463,0.710615},
{0.645179,0.694425},
{0.623427,0.696525},
{0.588308,0.711266},
{0.601773,0.697388},
{0.779917,0.694994},
{0.753968,0.695689},
{0.756598,0.715601},
{0.782295,0.71197},
{0.786338,0.736874},
{0.760923,0.741964},
{0.724204,0.715413},
{0.724288,0.694263},
{0.694461,0.715481},
{0.694719,0.696632},
{0.671522,0.696745},
{0.673757,0.713007},
{0.804508,0.695294},
{0.805207,0.711192},
{0.806294,0.736036},
{0.809152,0.761602},
{0.790833,0.765473},
{0.768931,0.768915},
{0.725165,0.741825},
{0.695164,0.742118},
{0.67086,0.740305},
{0.640898,0.73199},
{0.615657,0.730449},
{0.583825,0.737093},
{0.567049,0.765061},
{0.616462,0.767323},
{0.549103,0.833561},
{0.575518,0.839215},
{0.56967,0.881263},
{0.544943,0.878684},
{0.567358,0.899644},
{0.529715,0.890435},
{0.504229,0.899712},
{0.52583,0.914106},
{0.56442,0.928281},
{0.545952,0.932406},
{0.583546,0.947113},
{0.567965,0.959955},
{0.642979,0.76961},
{0.670779,0.770916},
{0.65192,0.837476},
{0.627781,0.839767},
{0.599947,0.863846},
{0.596786,0.886581},
{0.5959,0.906535},
{0.584862,0.924141},
{0.607673,0.943577},
{0.712005,0.772008},
{0.74274,0.769342},
{0.795056,0.83328},
{0.755853,0.832204},
{0.710095,0.835039},
{0.858177,0.835078},
{0.824648,0.833673},
{0.836239,0.883559},
{0.810767,0.891931},
{0.775104,0.890283},
{0.743171,0.889263},
{0.706679,0.882346},
{0.670705,0.832376},
{0.670429,0.879526},
{0.650662,0.878558},
{0.623509,0.875227},
{0.621646,0.896731},
{0.618316,0.913294},
{0.699014,0.915356},
{0.878317,0.876599},
{0.898108,0.885385},
{0.882772,0.896586},
{0.874012,0.917436},
{0.81473,0.915862},
{0.779398,0.912264},
{0.738777,0.915737},
{0.739858,0.934215},
{0.695391,0.933837},
{0.667778,0.911562},
{0.644944,0.905886},
{0.660746,0.928923},
{0.640306,0.922775},
{0.632433,0.956648},
{0.784643,0.926909},
{0.789803,0.94951},
{0.741566,0.958417},
{0.695461,0.963519},
{0.130811,0.441748},
{0.170369,0.446912},
{0.171488,0.416924},
{0.135252,0.404445},
{0.16899,0.39241},
{0.211795,0.418191},
{0.210629,0.449935},
{0.170631,0.477532},
{0.145029,0.473417},
{0.130734,0.47631},
{0.096043,0.456185},
{0.096026,0.408465},
{0.107204,0.365595},
{0.132684,0.372687},
{0.159681,0.370563},
{0.178515,0.366266},
{0.213191,0.386463},
{0.238387,0.416443},
{0.238387,0.450407},
{0.206295,0.475996},
{0.239253,0.473384},
{0.191982,0.47763},
{0.214029,0.357503},
{0.238387,0.382864},
{0.238387,0.343375},
{0.216488,0.322426},
{0.238388,0.295087},
{0.239681,0.273795},
{0.216919,0.285247},
{0.194674,0.301988},
{0.19344,0.287525},
{0.175331,0.297929},
{0.179947,0.324276},
{0.155529,0.320233},
{0.156004,0.344716},
{0.132,0.324282},
{0.130606,0.34866},
{0.113121,0.32097},
{0.111191,0.34485},
{0.092463,0.31396},
{0.092052,0.33018},
{0.06318,0.265129},
{0.074676,0.313558},
{0.041888,0.260634},
{0.046221,0.293978},
{0.015385,0.255856},
{0.015385,0.292214},
{0.015385,0.342916},
{0.047936,0.346276},
{0.015386,0.395458},
{0.05025,0.401087},
{0.015385,0.448307},
{0.044315,0.450855},
{0.015385,0.483249},
{0.040751,0.481063},
{0.072103,0.455029},
{0.069826,0.472893},
{0.091648,0.478305},
{0.11205,0.484001},
{0.180376,0.345982},
{0.07617,0.351152},
{0.073164,0.407055},
{0.900851,0.895985},
{0.907535,0.887944},
{0.896616,0.903763},
{0.88946,0.921871},
{0.885777,0.939849},
{0.862056,0.943633},
{0.820254,0.942938},
{0.654058,0.960002},
{0.476303,0.253219},
{0.483746,0.206332},
{0.536278,0.210673},
{0.5335,0.271194},
{0.638717,0.217315},
{0.640165,0.245871},
{0.409594,0.243827},
{0.413694,0.200827},
{0.369173,0.236534},
{0.37367,0.201148},
{0.328485,0.236331},
{0.332818,0.202014},
{0.285325,0.243126},
{0.287203,0.204242},
{0.243283,0.261995},
{0.245634,0.216338},
{0.232906,0.255747},
{0.215704,0.248146},
{0.226003,0.21279},
{0.172801,0.271897},
{0.133585,0.255602},
{0.131213,0.22876},
{0.1638,0.222923},
{0.217218,0.202967},
{0.120554,0.310366},
{0.115993,0.289409},
{0.379261,0.90737},
{0.390784,0.933235},
{0.356213,0.931957},
{0.383615,0.962642},
{0.351326,0.956385},
{0.344216,0.979443},
{0.387681,0.993432},
{0.303275,0.924048},
{0.320629,0.904833},
{0.352214,0.902161},
{0.324438,0.963},
{0.565241,0.29944},
{0.566058,0.326684},
{0.521246,0.326658},
{0.523549,0.300696},
{0.565241,0.29944},
{0.608582,0.31698},
{0.566058,0.326684},
{0.608582,0.31698},
{0.565241,0.29944},
{0.608517,0.288836},
{0.608582,0.31698},
{0.608517,0.288836},
{0.650597,0.299357},
{0.650597,0.299357},
{0.608517,0.288836},
{0.642948,0.269917},
{0.918546,0.516157},
{0.913338,0.490144},
{0.879301,0.512282},
{0.893722,0.531422},
{0.849772,0.531925},
{0.860602,0.475514},
{0.903852,0.446502},
{0.95275,0.472997},
{0.957072,0.504396},
{0.897535,0.258934},
{0.883271,0.039033},
{0.844414,0.060301},
{0.871714,0.27402},
{0.900116,0.38199},
{0.866559,0.415927},
{0.93897,0.352731},
{0.979672,0.343248},
{0.975191,0.237857},
{0.931417,0.244588},
{0.991537,0.009633},
{0.935546,0.01802},
{0.944149,0.42397},
{0.987414,0.467736},
{0.986294,0.50075},
{0.984256,0.417094},
{0.842729,0.605529},
{0.875846,0.553796},
{0.819548,0.603681},
{0.833323,0.65269},
{0.814877,0.652035},
{0.394144,0.109265},
{0.359734,0.085888},
{0.359734,0.129521},
{0.395772,0.147993},
{0.434048,0.130432},
{0.455491,0.165754},
{0.493363,0.141227},
{0.488568,0.185364},
{0.533622,0.153347},
{0.529306,0.187798},
{0.60508,0.116158},
{0.598286,0.182425},
{0.640035,0.111728},
{0.637564,0.17931},
{0.69235,0.157218},
{0.687619,0.183915},
{0.769023,0.155577},
{0.768475,0.196566},
{0.809939,0.144077},
{0.809939,0.181295},
{0.41893,0.088164},
{0.395599,0.069382},
{0.25528,0.461182},
{0.275363,0.430406},
{0.292191,0.476046},
{0.303984,0.422319},
{0.328182,0.438659},
{0.326958,0.484233},
{0.307113,0.507949},
{0.276917,0.507909},
{0.253021,0.495653},
{0.987209,0.681977},
{0.992055,0.721072},
{0.953743,0.719378},
{0.979757,0.760823},
{0.950685,0.766723},
{0.912688,0.762318},
{0.889034,0.74666},
{0.912986,0.721044},
{0.895521,0.696652},
{0.927283,0.671369},
{0.962372,0.673213},
{0.957288,0.570428},
{0.975878,0.522533},
{0.985282,0.53574},
{0.987832,0.595281},
{0.951642,0.624895},
{0.927941,0.536334},
{0.938543,0.536965},
{0.912074,0.65498},
{0.883532,0.661418},
{0.895715,0.621996},
{0.869064,0.63764},
{0.860568,0.691996},
{0.868077,0.699817},
{0.882853,0.591059},
{0.90938,0.560914},
{0.919486,0.607674},
{0.940947,0.640326},
{0.85814,0.609417},
{0.620735,0.710628},
{0.623427,0.696525},
{0.645179,0.694425},
{0.643463,0.710615},
{0.671522,0.696745},
{0.673757,0.713007},
{0.694461,0.715481},
{0.694719,0.696632},
{0.724288,0.694263},
{0.724204,0.715413},
{0.753968,0.695689},
{0.756598,0.715601},
{0.779917,0.694994},
{0.782295,0.71197},
{0.804508,0.695294},
{0.805207,0.711192},
{0.786338,0.736874},
{0.806294,0.736036},
{0.809152,0.761602},
{0.790833,0.765473},
{0.858177,0.835078},
{0.824648,0.833673},
{0.836239,0.883559},
{0.878317,0.876599},
{0.898108,0.885385},
{0.882772,0.896586},
{0.900851,0.895985},
{0.907535,0.887944},
{0.588308,0.711266},
{0.601773,0.697388},
{0.616462,0.767323},
{0.640898,0.73199},
{0.642979,0.76961},
{0.627781,0.839767},
{0.65192,0.837476},
{0.670779,0.770916},
{0.67086,0.740305},
{0.615657,0.730449},
{0.567049,0.765061},
{0.549103,0.833561},
{0.575518,0.839215},
{0.599947,0.863846},
{0.623509,0.875227},
{0.650662,0.878558},
{0.670429,0.879526},
{0.670705,0.832376},
{0.710095,0.835039},
{0.712005,0.772008},
{0.695164,0.742118},
{0.725165,0.741825},
{0.74274,0.769342},
{0.755853,0.832204},
{0.795056,0.83328},
{0.768931,0.768915},
{0.760923,0.741964},
{0.583825,0.737093},
{0.810767,0.891931},
{0.874012,0.917436},
{0.88946,0.921871},
{0.896616,0.903763},
{0.56967,0.881263},
{0.544943,0.878684},
{0.567358,0.899644},
{0.5959,0.906535},
{0.596786,0.886581},
{0.621646,0.896731},
{0.644944,0.905886},
{0.667778,0.911562},
{0.699014,0.915356},
{0.706679,0.882346},
{0.743171,0.889263},
{0.775104,0.890283},
{0.779398,0.912264},
{0.81473,0.915862},
{0.862056,0.943633},
{0.885777,0.939849},
{0.738777,0.915737},
{0.618316,0.913294},
{0.640306,0.922775},
{0.660746,0.928923},
{0.695391,0.933837},
{0.739858,0.934215},
{0.784643,0.926909},
{0.820254,0.942938},
{0.529715,0.890435},
{0.504229,0.899712},
{0.52583,0.914106},
{0.56442,0.928281},
{0.584862,0.924141},
{0.607673,0.943577},
{0.632433,0.956648},
{0.654058,0.960002},
{0.695461,0.963519},
{0.741566,0.958417},
{0.789803,0.94951},
{0.130811,0.441748},
{0.135252,0.404445},
{0.171488,0.416924},
{0.170369,0.446912},
{0.211795,0.418191},
{0.16899,0.39241},
{0.132684,0.372687},
{0.107204,0.365595},
{0.096026,0.408465},
{0.096043,0.456185},
{0.130734,0.47631},
{0.145029,0.473417},
{0.170631,0.477532},
{0.210629,0.449935},
{0.238387,0.416443},
{0.213191,0.386463},
{0.178515,0.366266},
{0.159681,0.370563},
{0.156004,0.344716},
{0.130606,0.34866},
{0.111191,0.34485},
{0.092052,0.33018},
{0.07617,0.351152},
{0.073164,0.407055},
{0.072103,0.455029},
{0.069826,0.472893},
{0.091648,0.478305},
{0.11205,0.484001},
{0.191982,0.47763},
{0.206295,0.475996},
{0.238387,0.450407},
{0.239253,0.473384},
{0.214029,0.357503},
{0.238387,0.343375},
{0.238387,0.382864},
{0.180376,0.345982},
{0.179947,0.324276},
{0.216488,0.322426},
{0.194674,0.301988},
{0.175331,0.297929},
{0.155529,0.320233},
{0.132,0.324282},
{0.113121,0.32097},
{0.092463,0.31396},
{0.06318,0.265129},
{0.074676,0.313558},
{0.047936,0.346276},
{0.05025,0.401087},
{0.044315,0.450855},
{0.040751,0.481063},
{0.216919,0.285247},
{0.19344,0.287525},
{0.239681,0.273795},
{0.238388,0.295087},
{0.015385,0.448307},
{0.015386,0.395458},
{0.015385,0.483249},
{0.015385,0.342916},
{0.046221,0.293978},
{0.015385,0.292214},
{0.015385,0.255856},
{0.041888,0.260634},
{0.545952,0.932406},
{0.583546,0.947113},
{0.567965,0.959955},
{0.476303,0.253219},
{0.5335,0.271194},
{0.536278,0.210673},
{0.483746,0.206332},
{0.409594,0.243827},
{0.413694,0.200827},
{0.369173,0.236534},
{0.37367,0.201148},
{0.328485,0.236331},
{0.332818,0.202014},
{0.285325,0.243126},
{0.287203,0.204242},
{0.245634,0.216338},
{0.243283,0.261995},
{0.226003,0.21279},
{0.232906,0.255747},
{0.215704,0.248146},
{0.217218,0.202967},
{0.1638,0.222923},
{0.172801,0.271897},
{0.131213,0.22876},
{0.133585,0.255602},
{0.115993,0.289409},
{0.120554,0.310366},
{0.640165,0.245871},
{0.638717,0.217315},
{0.356213,0.931957},
{0.390784,0.933235},
{0.379261,0.90737},
{0.352214,0.902161},
{0.320629,0.904833},
{0.303275,0.924048},
{0.351326,0.956385},
{0.324438,0.963},
{0.344216,0.979443},
{0.383615,0.962642},
{0.387681,0.993432},
{0.565241,0.29944},
{0.523549,0.300696},
{0.521246,0.326658},
{0.566058,0.326684},
{0.565241,0.29944},
{0.608582,0.31698},
{0.608517,0.288836},
{0.608582,0.31698},
{0.565241,0.29944},
{0.566058,0.326684},
{0.608582,0.31698},
{0.650597,0.299357},
{0.608517,0.288836},
{0.650597,0.299357},
{0.642948,0.269917},
{0.608517,0.288836},
{0.918546,0.516157},
{0.893722,0.531422},
{0.879301,0.512282},
{0.913338,0.490144},
{0.860602,0.475514},
{0.849772,0.531925},
{0.875846,0.553796},
{0.842729,0.605529},
{0.819548,0.603681},
{0.833323,0.65269},
{0.814877,0.652035},
{0.897535,0.258934},
{0.871714,0.27402},
{0.844414,0.060301},
{0.883271,0.039033},
{0.931417,0.244588},
{0.935546,0.01802},
{0.991537,0.009633},
{0.975191,0.237857},
{0.93897,0.352731},
{0.979672,0.343248},
{0.944149,0.42397},
{0.984256,0.417094},
{0.987414,0.467736},
{0.95275,0.472997},
{0.986294,0.50075},
{0.957072,0.504396},
{0.900116,0.38199},
{0.866559,0.415927},
{0.903852,0.446502},
{0.394144,0.109265},
{0.395772,0.147993},
{0.359734,0.129521},
{0.359734,0.085888},
{0.395599,0.069382},
{0.41893,0.088164},
{0.434048,0.130432},
{0.455491,0.165754},
{0.493363,0.141227},
{0.488568,0.185364},
{0.533622,0.153347},
{0.529306,0.187798},
{0.60508,0.116158},
{0.598286,0.182425},
{0.640035,0.111728},
{0.637564,0.17931},
{0.69235,0.157218},
{0.687619,0.183915},
{0.769023,0.155577},
{0.768475,0.196566},
{0.809939,0.144077},
{0.809939,0.181295},
{0.292191,0.476046},
{0.275363,0.430406},
{0.25528,0.461182},
{0.253021,0.495653},
{0.276917,0.507909},
{0.307113,0.507949},
{0.326958,0.484233},
{0.328182,0.438659},
{0.303984,0.422319},
{0.953743,0.719378},
{0.992055,0.721072},
{0.987209,0.681977},
{0.962372,0.673213},
{0.927283,0.671369},
{0.895521,0.696652},
{0.912986,0.721044},
{0.889034,0.74666},
{0.912688,0.762318},
{0.950685,0.766723},
{0.979757,0.760823},
{0.985282,0.53574},
{0.975878,0.522533},
{0.957288,0.570428},
{0.987832,0.595281},
{0.951642,0.624895},
{0.927941,0.536334},
{0.938543,0.536965},
{0.895715,0.621996},
{0.883532,0.661418},
{0.912074,0.65498},
{0.940947,0.640326},
{0.919486,0.607674},
{0.90938,0.560914},
{0.882853,0.591059},
{0.85814,0.609417},
{0.869064,0.63764},
{0.860568,0.691996},
{0.868077,0.699817},
{0.952534,0.911732},
{0.980136,0.924976},
{0.956648,0.962215},
{0.991147,0.958233},
{0.98083,0.987927},
{0.938302,0.989864},
{0.915779,0.994505},
{0.92198,0.953966},
{0.907569,0.869654},
{0.939321,0.886436},
{0.937837,0.844807},
{0.971499,0.877125},
{0.992156,0.844729},
{0.985984,0.796599},
{0.934039,0.786019},
{0.893079,0.802562},
{0.883518,0.844729},
{0.792592,0.238232},
{0.80175,0.301994},
{0.828376,0.303403},
{0.823769,0.239289},
{0.811999,0.199123},
{0.776996,0.212165},
{0.778733,0.166688},
{0.760517,0.298071},
{0.80175,0.301994},
{0.792592,0.238232},
{0.750553,0.284928},
{0.776996,0.212165},
{0.783206,0.408832},
{0.800775,0.420765},
{0.821804,0.377902},
{0.789039,0.359273},
{0.769209,0.407558},
{0.758305,0.429035},
{0.775326,0.451498},
{0.775799,0.422748},
{0.664544,0.345311},
{0.655939,0.328004},
{0.623973,0.364488},
{0.641647,0.375248},
{0.631361,0.416012},
{0.613462,0.412863},
{0.602212,0.411181},
{0.614093,0.358897},
{0.654074,0.314911},
{0.701849,0.311879},
{0.701225,0.320031},
{0.699476,0.340522},
{0.669932,0.353168},
{0.682103,0.381734},
{0.631361,0.416012},
{0.667122,0.398306},
{0.670171,0.425702},
{0.646225,0.449047},
{0.691247,0.492366},
{0.70822,0.477246},
{0.741757,0.525734},
{0.76066,0.516388},
{0.800202,0.576894},
{0.631361,0.416012},
{0.682103,0.381734},
{0.641647,0.375248},
{0.669932,0.353168},
{0.701185,0.347519},
{0.713617,0.383623},
{0.726218,0.357745},
{0.750494,0.376102},
{0.732678,0.399404},
{0.750494,0.376102},
{0.769209,0.407558},
{0.774476,0.398143},
{0.755589,0.369285},
{0.789039,0.359273},
{0.783206,0.408832},
{0.775799,0.422748},
{0.701185,0.347519},
{0.726218,0.357745},
{0.729348,0.350071},
{0.716753,0.540865},
{0.701135,0.549731},
{0.735557,0.602179},
{0.769559,0.590143},
{0.790308,0.637859},
{0.76107,0.654209},
{0.750613,0.658616},
{0.714434,0.701779},
{0.704188,0.615443},
{0.679103,0.529415},
{0.691247,0.492366},
{0.741757,0.525734},
{0.800202,0.576894},
{0.812913,0.6226},
{0.819654,0.684263},
{0.80387,0.688634},
{0.773349,0.697509},
{0.760779,0.663809},
{0.764649,0.700123},
{0.779859,0.768119},
{0.814663,0.760437},
{0.797938,0.86693},
{0.713992,0.793189},
{0.766146,0.742698},
{0.69277,0.789244},
{0.674751,0.727101},
{0.676436,0.621741},
{0.65185,0.540935},
{0.611456,0.460445},
{0.623244,0.449973},
{0.646225,0.449047},
{0.604531,0.460052},
{0.641264,0.546528},
{0.599284,0.459334},
{0.590243,0.406434},
{0.593524,0.561788},
{0.611871,0.557371},
{0.565828,0.458233},
{0.549309,0.4552},
{0.549368,0.395978},
{0.570944,0.404551},
{0.585203,0.458327},
{0.625929,0.553025},
{0.656748,0.644142},
{0.635923,0.660434},
{0.618876,0.670234},
{0.579039,0.671354},
{0.565851,0.568485},
{0.52634,0.457495},
{0.528157,0.383011},
{0.544992,0.331327},
{0.575967,0.346607},
{0.586571,0.3499},
{0.582946,0.40687},
{0.674751,0.727101},
{0.643847,0.758371},
{0.633885,0.77688},
{0.614545,0.798099},
{0.554995,0.83398},
{0.577147,0.887291},
{0.519447,0.990764},
{0.574866,0.254812},
{0.564202,0.238962},
{0.518674,0.303433},
{0.536324,0.313648},
{0.505265,0.381578},
{0.617792,0.296144},
{0.605038,0.284686},
{0.597367,0.35209},
{0.608529,0.356685},
{0.603093,0.353539},
{0.628457,0.299285},
{0.636434,0.306504},
{0.579762,0.263592},
{0.591187,0.278337},
{0.627341,0.249539},
{0.644203,0.230739},
{0.617723,0.227416},
{0.604399,0.225084},
{0.613955,0.213973},
{0.604665,0.21195},
{0.660609,0.281694},
{0.676939,0.262694},
{0.659795,0.254704},
{0.632904,0.257722},
{0.664608,0.902783},
{0.667961,0.785434},
{0.775799,0.422748},
{0.775326,0.451498},
{0.860195,0.019658},
{0.838066,0.009283},
{0.843956,0.034995},
{0.811532,0.016304},
{0.826805,0.038487},
{0.807774,0.051887},
{0.791017,0.067317},
{0.812013,0.06729},
{0.826875,0.114533},
{0.806906,0.114588},
{0.85165,0.180584},
{0.833718,0.182955},
{0.856981,0.225365},
{0.841738,0.225051},
{0.84897,0.254904},
{0.871358,0.255664},
{0.877884,0.305842},
{0.860325,0.295361},
{0.857917,0.30974},
{0.874432,0.312467},
{0.855261,0.339086},
{0.871183,0.341812},
{0.859417,0.397205},
{0.872018,0.414674},
{0.85396,0.411014},
{0.868094,0.425569},
{0.853471,0.441754},
{0.863516,0.453815},
{0.839357,0.606766},
{0.849442,0.631448},
{0.830419,0.618453},
{0.840984,0.646063},
{0.830189,0.640735},
{0.834805,0.664163},
{0.866465,0.688273},
{0.862986,0.701003},
{0.882244,0.712246},
{0.872917,0.728971},
{0.647644,0.310356},
{0.691553,0.280604},
{0.702543,0.305259},
{0.902309,0.295611},
{0.927377,0.295373},
{0.922072,0.23505},
{0.890218,0.230578},
{0.918402,0.20136},
{0.900609,0.204361},
{0.892028,0.171673},
{0.909333,0.166267},
{0.874055,0.114308},
{0.897403,0.114274},
{0.861323,0.067047},
{0.88256,0.066978},
{0.8745,0.038795},
{0.876542,0.175085},
{0.850772,0.114467},
{0.837001,0.067196},
{0.906689,0.361213},
{0.904345,0.368842},
{0.898901,0.385712},
{0.890123,0.467505},
{0.890947,0.484403},
{0.886234,0.500429},
{0.871384,0.672661},
{0.883542,0.689563},
{0.96442,0.667197},
{0.956727,0.639249},
{0.949641,0.705298},
{0.952732,0.736845},
{0.985803,0.493736},
{0.979273,0.487442},
{0.979787,0.594654},
{0.988219,0.618559},
{0.967878,0.62393},
{0.945268,0.551217},
{0.957375,0.522568},
{0.95785,0.43739},
{0.983122,0.475718},
{0.993048,0.48269},
{0.987569,0.205818},
{0.981368,0.203276},
{0.980628,0.453602},
{0.987096,0.463136},
{0.957298,0.417263},
{0.959157,0.396149},
{0.961807,0.19773},
{0.974327,0.015809},
{0.97997,0.01731},
{0.95098,0.014975},
{0.948831,0.012849},
{0.950178,0.190144},
{0.936523,0.371077},
{0.935066,0.388249},
{0.934686,0.407148},
{0.938448,0.48529},
{0.934371,0.507226},
{0.925623,0.531073},
{0.938432,0.570531},
{0.914367,0.633574},
{0.924119,0.654503},
{0.927353,0.387145},
{0.928489,0.41152},
{0.91786,0.425144},
{0.910883,0.504425},
{0.909939,0.536033},
{0.896991,0.54589},
{0.706868,0.285359},
{0.974066,0.656977},
{0.519447,0.990764},
{0.584728,0.892892},
{0.623435,0.804189},
{0.642966,0.782355},
{0.650224,0.761226},
{0.664608,0.902783},
{0.721732,0.798052},
{0.758298,0.667397},
{0.760779,0.663809},
{0.95098,0.014975},
{0.948831,0.012849},
{0.97997,0.01731},
{0.95098,0.014975},
{0.974327,0.015809},
{0.792592,0.238232},
{0.823769,0.239289},
{0.828376,0.303403},
{0.80175,0.301994},
{0.789039,0.359273},
{0.821804,0.377902},
{0.783206,0.408832},
{0.800775,0.420765},
{0.775799,0.422748},
{0.775326,0.451498},
{0.792592,0.238232},
{0.80175,0.301994},
{0.760517,0.298071},
{0.789039,0.359273},
{0.755589,0.369285},
{0.774476,0.398143},
{0.783206,0.408832},
{0.775799,0.422748},
{0.769209,0.407558},
{0.750494,0.376102},
{0.726218,0.357745},
{0.729348,0.350071},
{0.701185,0.347519},
{0.699476,0.340522},
{0.669932,0.353168},
{0.664544,0.345311},
{0.641647,0.375248},
{0.623973,0.364488},
{0.631361,0.416012},
{0.613462,0.412863},
{0.623244,0.449973},
{0.646225,0.449047},
{0.679103,0.529415},
{0.691247,0.492366},
{0.716753,0.540865},
{0.741757,0.525734},
{0.769559,0.590143},
{0.800202,0.576894},
{0.812913,0.6226},
{0.790308,0.637859},
{0.819654,0.684263},
{0.80387,0.688634},
{0.814663,0.760437},
{0.773349,0.697509},
{0.787069,0.765741},
{0.797938,0.86693},
{0.772649,0.770498},
{0.764649,0.700123},
{0.760779,0.663809},
{0.76107,0.654209},
{0.735557,0.602179},
{0.750613,0.658616},
{0.758298,0.667397},
{0.760779,0.663809},
{0.769209,0.407558},
{0.775799,0.422748},
{0.775326,0.451498},
{0.758305,0.429035},
{0.732678,0.399404},
{0.750494,0.376102},
{0.713617,0.383623},
{0.726218,0.357745},
{0.701185,0.347519},
{0.682103,0.381734},
{0.669932,0.353168},
{0.641647,0.375248},
{0.631361,0.416012},
{0.655939,0.328004},
{0.614093,0.358897},
{0.602212,0.411181},
{0.611456,0.460445},
{0.65185,0.540935},
{0.704188,0.615443},
{0.701135,0.549731},
{0.631361,0.416012},
{0.682103,0.381734},
{0.667122,0.398306},
{0.691247,0.492366},
{0.646225,0.449047},
{0.670171,0.425702},
{0.70822,0.477246},
{0.741757,0.525734},
{0.76066,0.516388},
{0.800202,0.576894},
{0.713992,0.793189},
{0.714434,0.701779},
{0.766146,0.742698},
{0.701225,0.320031},
{0.750553,0.284928},
{0.701849,0.311879},
{0.69277,0.789244},
{0.664608,0.902783},
{0.667961,0.785434},
{0.676436,0.621741},
{0.641264,0.546528},
{0.656748,0.644142},
{0.625929,0.553025},
{0.611871,0.557371},
{0.635923,0.660434},
{0.643847,0.758371},
{0.776996,0.212165},
{0.604531,0.460052},
{0.590243,0.406434},
{0.599284,0.459334},
{0.593524,0.561788},
{0.549309,0.4552},
{0.565828,0.458233},
{0.585203,0.458327},
{0.570944,0.404551},
{0.549368,0.395978},
{0.528157,0.383011},
{0.52634,0.457495},
{0.565851,0.568485},
{0.579039,0.671354},
{0.618876,0.670234},
{0.574866,0.254812},
{0.536324,0.313648},
{0.518674,0.303433},
{0.564202,0.238962},
{0.604399,0.225084},
{0.604665,0.21195},
{0.613955,0.213973},
{0.617723,0.227416},
{0.579762,0.263592},
{0.591187,0.278337},
{0.605038,0.284686},
{0.627341,0.249539},
{0.644203,0.230739},
{0.632904,0.257722},
{0.659795,0.254704},
{0.628457,0.299285},
{0.636434,0.306504},
{0.660609,0.281694},
{0.676939,0.262694},
{0.691553,0.280604},
{0.647644,0.310356},
{0.654074,0.314911},
{0.702543,0.305259},
{0.706868,0.285359},
{0.617792,0.296144},
{0.597367,0.35209},
{0.586571,0.3499},
{0.575967,0.346607},
{0.582946,0.40687},
{0.603093,0.353539},
{0.608529,0.356685},
{0.544992,0.331327},
{0.505265,0.381578},
{0.643847,0.758371},
{0.633885,0.77688},
{0.614545,0.798099},
{0.623435,0.804189},
{0.642966,0.782355},
{0.650224,0.761226},
{0.554995,0.83398},
{0.577147,0.887291},
{0.584728,0.892892},
{0.811999,0.199123},
{0.776996,0.212165},
{0.778733,0.166688},
{0.656748,0.644142},
{0.843956,0.034995},
{0.838066,0.009283},
{0.860195,0.019658},
{0.8745,0.038795},
{0.861323,0.067047},
{0.88256,0.066978},
{0.897403,0.114274},
{0.874055,0.114308},
{0.909333,0.166267},
{0.892028,0.171673},
{0.918402,0.20136},
{0.900609,0.204361},
{0.890218,0.230578},
{0.922072,0.23505},
{0.902309,0.295611},
{0.927377,0.295373},
{0.927353,0.387145},
{0.906689,0.361213},
{0.904345,0.368842},
{0.928489,0.41152},
{0.898901,0.385712},
{0.91786,0.425144},
{0.890123,0.467505},
{0.910883,0.504425},
{0.890947,0.484403},
{0.909939,0.536033},
{0.886234,0.500429},
{0.896991,0.54589},
{0.871384,0.672661},
{0.883542,0.689563},
{0.866465,0.688273},
{0.882244,0.712246},
{0.862986,0.701003},
{0.872917,0.728971},
{0.811532,0.016304},
{0.826805,0.038487},
{0.807774,0.051887},
{0.791017,0.067317},
{0.812013,0.06729},
{0.837001,0.067196},
{0.826875,0.114533},
{0.806906,0.114588},
{0.85165,0.180584},
{0.876542,0.175085},
{0.850772,0.114467},
{0.871358,0.255664},
{0.856981,0.225365},
{0.877884,0.305842},
{0.874432,0.312467},
{0.871183,0.341812},
{0.872018,0.414674},
{0.868094,0.425569},
{0.863516,0.453815},
{0.849442,0.631448},
{0.840984,0.646063},
{0.834805,0.664163},
{0.859417,0.397205},
{0.855261,0.339086},
{0.85396,0.411014},
{0.853471,0.441754},
{0.839357,0.606766},
{0.830419,0.618453},
{0.830189,0.640735},
{0.96442,0.667197},
{0.952732,0.736845},
{0.949641,0.705298},
{0.956727,0.639249},
{0.924119,0.654503},
{0.938432,0.570531},
{0.914367,0.633574},
{0.925623,0.531073},
{0.945268,0.551217},
{0.934371,0.507226},
{0.957375,0.522568},
{0.938448,0.48529},
{0.95785,0.43739},
{0.934686,0.407148},
{0.957298,0.417263},
{0.935066,0.388249},
{0.959157,0.396149},
{0.936523,0.371077},
{0.961807,0.19773},
{0.950178,0.190144},
{0.95098,0.014975},
{0.948831,0.012849},
{0.985803,0.493736},
{0.988219,0.618559},
{0.979787,0.594654},
{0.979273,0.487442},
{0.967878,0.62393},
{0.974066,0.656977},
{0.987569,0.205818},
{0.987096,0.463136},
{0.980628,0.453602},
{0.981368,0.203276},
{0.983122,0.475718},
{0.993048,0.48269},
{0.974327,0.015809},
{0.833718,0.182955},
{0.84897,0.254904},
{0.841738,0.225051},
{0.860325,0.295361},
{0.857917,0.30974},
{0.721732,0.798052},
{0.664608,0.902783},
{0.95098,0.014975},
{0.974327,0.015809},
{0.95098,0.014975},
{0.948831,0.012849},
{0.527241,0.560247},
{0.53396,0.515603},
{0.539481,0.559955},
{0.51677,0.59304},
{0.54907,0.592268},
{0.505668,0.63168},
{0.561635,0.630344},
{0.51247,0.681802},
{0.559468,0.680679},
{0.520571,0.719075},
{0.553931,0.718278},
{0.528261,0.76383},
{0.546833,0.763387},
{0.539573,0.824218},
{0.843848,0.97349},
{0.815196,0.954955},
{0.844141,0.947459},
{0.829017,0.918902},
{0.775158,0.922657},
{0.774435,0.944415},
{0.714895,0.944169},
{0.714979,0.922878},
{0.637124,0.922696},
{0.636978,0.944044},
{0.587064,0.923146},
{0.587019,0.944173},
{0.60985,0.145671},
{0.617489,0.136331},
{0.632431,0.142627},
{0.640546,0.154377},
{0.652587,0.144903},
{0.656415,0.123653},
{0.628764,0.122221},
{0.602097,0.108557},
{0.58467,0.108576},
{0.607724,0.158374},
{0.631962,0.166182},
{0.656106,0.165565},
{0.674919,0.150396},
{0.675521,0.141842},
{0.682676,0.122233},
{0.685001,0.108478},
{0.654942,0.108463},
{0.62574,0.10849},
{0.707021,0.153878},
{0.700492,0.142386},
{0.727337,0.108541},
{0.732873,0.137141},
{0.738814,0.108566},
{0.751711,0.136686},
{0.759066,0.108585},
{0.687622,0.146204},
{0.677322,0.161759},
{0.699032,0.192746},
{0.703594,0.191322},
{0.905019,0.822156},
{0.919012,0.836981},
{0.87515,0.898024},
{0.862173,0.886042},
{0.861663,0.936807},
{0.918857,0.951223},
{0.913992,0.922098},
{0.957353,0.909822},
{0.962939,0.930531},
{0.986447,0.917646},
{0.930464,0.777327},
{0.944505,0.788623},
{0.715254,0.108532},
{0.69567,0.13296},
{0.550116,0.143219},
{0.537701,0.108609},
{0.57568,0.108605},
{0.582982,0.140044},
{0.956179,0.756448},
{0.94106,0.748713},
{0.751711,0.136686},
{0.738031,0.16822},
{0.732873,0.137141},
{0.738031,0.16822},
{0.751711,0.136686},
{0.761329,0.157032},
{0.707021,0.153878},
{0.72002,0.214278},
{0.703594,0.191322},
{0.72002,0.214278},
{0.707021,0.153878},
{0.719194,0.180083},
{0.699032,0.192746},
{0.682802,0.191387},
{0.677322,0.161759},
{0.682802,0.191387},
{0.699032,0.192746},
{0.703412,0.22074},
{0.656106,0.165565},
{0.65218,0.218026},
{0.647127,0.198812},
{0.65218,0.218026},
{0.656106,0.165565},
{0.661749,0.194593},
{0.64329,0.199309},
{0.620566,0.189132},
{0.631962,0.166182},
{0.620566,0.189132},
{0.64329,0.199309},
{0.639207,0.220519},
{0.582982,0.140044},
{0.544732,0.169178},
{0.550116,0.143219},
{0.544732,0.169178},
{0.582982,0.140044},
{0.582488,0.170764},
{0.550116,0.143219},
{0.516552,0.108385},
{0.537701,0.108609},
{0.516552,0.108385},
{0.550116,0.143219},
{0.544732,0.169178},
{0.759066,0.108585},
{0.761329,0.157032},
{0.751711,0.136686},
{0.761329,0.157032},
{0.759066,0.108585},
{0.780162,0.108671},
{0.703594,0.191322},
{0.703412,0.22074},
{0.699032,0.192746},
{0.703412,0.22074},
{0.703594,0.191322},
{0.72002,0.214278},
{0.647127,0.198812},
{0.639207,0.220519},
{0.64329,0.199309},
{0.639207,0.220519},
{0.647127,0.198812},
{0.65218,0.218026},
{0.732873,0.137141},
{0.719194,0.180083},
{0.707021,0.153878},
{0.719194,0.180083},
{0.732873,0.137141},
{0.738031,0.16822},
{0.677322,0.161759},
{0.661749,0.194593},
{0.656106,0.165565},
{0.661749,0.194593},
{0.677322,0.161759},
{0.682802,0.191387},
{0.607724,0.158374},
{0.582488,0.170764},
{0.582982,0.140044},
{0.582488,0.170764},
{0.607724,0.158374},
{0.594864,0.174441},
{0.829017,0.918902},
{0.849633,0.879257},
{0.862173,0.886042},
{0.849633,0.879257},
{0.829017,0.918902},
{0.828352,0.911795},
{0.944505,0.788623},
{0.928686,0.847972},
{0.919012,0.836981},
{0.928686,0.847972},
{0.944505,0.788623},
{0.957254,0.795579},
{0.905019,0.822156},
{0.92831,0.751798},
{0.930464,0.777327},
{0.92831,0.751798},
{0.905019,0.822156},
{0.894271,0.811001},
{0.919012,0.836981},
{0.882733,0.905992},
{0.87515,0.898024},
{0.882733,0.905992},
{0.919012,0.836981},
{0.928686,0.847972},
{0.862173,0.886042},
{0.894271,0.811001},
{0.905019,0.822156},
{0.894271,0.811001},
{0.862173,0.886042},
{0.849633,0.879257},
{0.87515,0.898024},
{0.882733,0.905992},
{0.861663,0.936807},
{0.956179,0.756448},
{0.957254,0.795579},
{0.944505,0.788623},
{0.957254,0.795579},
{0.956179,0.756448},
{0.964165,0.76858},
{0.930464,0.777327},
{0.92831,0.751798},
{0.94106,0.748713},
{0.861663,0.936807},
{0.911018,0.905377},
{0.913992,0.922098},
{0.911018,0.905377},
{0.861663,0.936807},
{0.882733,0.905992},
{0.913992,0.922098},
{0.9516,0.888222},
{0.957353,0.909822},
{0.9516,0.888222},
{0.913992,0.922098},
{0.911018,0.905377},
{0.957353,0.909822},
{0.985517,0.898256},
{0.986447,0.917646},
{0.985517,0.898256},
{0.957353,0.909822},
{0.9516,0.888222},
{0.775158,0.922657},
{0.828352,0.911795},
{0.829017,0.918902},
{0.828352,0.911795},
{0.775158,0.922657},
{0.776467,0.914487},
{0.774435,0.944415},
{0.714877,0.954766},
{0.714895,0.944169},
{0.714877,0.954766},
{0.774435,0.944415},
{0.770807,0.95491},
{0.815196,0.954955},
{0.770807,0.95491},
{0.774435,0.944415},
{0.770807,0.95491},
{0.815196,0.954955},
{0.807822,0.971227},
{0.843848,0.97349},
{0.807822,0.971227},
{0.815196,0.954955},
{0.807822,0.971227},
{0.843848,0.97349},
{0.828999,0.990882},
{0.714979,0.922878},
{0.776467,0.914487},
{0.775158,0.922657},
{0.776467,0.914487},
{0.714979,0.922878},
{0.71497,0.914877},
{0.587064,0.923146},
{0.637054,0.914316},
{0.637124,0.922696},
{0.637054,0.914316},
{0.587064,0.923146},
{0.587082,0.915111},
{0.714895,0.944169},
{0.636934,0.954749},
{0.636978,0.944044},
{0.636934,0.954749},
{0.714895,0.944169},
{0.714877,0.954766},
{0.636978,0.944044},
{0.587039,0.954725},
{0.587019,0.944173},
{0.587039,0.954725},
{0.636978,0.944044},
{0.636934,0.954749},
{0.637124,0.922696},
{0.71497,0.914877},
{0.714979,0.922878},
{0.71497,0.914877},
{0.637124,0.922696},
{0.637054,0.914316},
{0.64329,0.199309},
{0.647127,0.198812},
{0.702075,0.062004},
{0.704893,0.074095},
{0.747846,0.046846},
{0.743431,0.037585},
{0.762289,0.02862},
{0.76447,0.033993},
{0.76835,0.04312},
{0.753172,0.056163},
{0.70858,0.084958},
{0.668826,0.085598},
{0.666687,0.073252},
{0.66599,0.067575},
{0.700256,0.053399},
{0.739814,0.031022},
{0.760953,0.022878},
{0.774686,0.020658},
{0.778308,0.034725},
{0.58545,0.061665},
{0.588959,0.051919},
{0.562057,0.037606},
{0.555152,0.044435},
{0.552915,0.00833},
{0.571957,0.008435},
{0.594421,0.022394},
{0.615788,0.023744},
{0.619987,0.053806},
{0.629571,0.063316},
{0.581386,0.075467},
{0.551276,0.055257},
{0.529934,0.008451},
{0.539783,0.008361},
{0.650195,0.052897},
{0.64594,0.02875},
{0.635112,0.008461},
{0.655655,0.008565},
{0.671871,0.008568},
{0.662458,0.034458},
{0.665838,0.052222},
{0.656523,0.058629},
{0.627743,0.082495},
{0.631319,0.100129},
{0.579426,0.089404},
{0.54592,0.067255},
{0.512178,0.00821},
{0.670997,0.097058},
{0.593543,0.008386},
{0.615867,0.008396},
{0.706272,0.025905},
{0.73967,0.026143},
{0.740449,0.008464},
{0.765966,0.00846},
{0.78011,0.008529},
{0.692492,0.049739},
{0.695104,0.028077},
{0.703374,0.008555},
{0.689294,0.034087},
{0.689572,0.008572},
{0.774686,0.020658},
{0.785183,0.008622},
{0.78011,0.008529},
{0.785183,0.008622},
{0.774686,0.020658},
{0.778308,0.034725},
{0.844141,0.947459},
{0.815196,0.954955},
{0.843848,0.97349},
{0.918857,0.951223},
{0.861663,0.936807},
{0.913992,0.922098},
{0.957353,0.909822},
{0.962939,0.930531},
{0.986447,0.917646},
{0.60985,0.145671},
{0.640546,0.154377},
{0.632431,0.142627},
{0.617489,0.136331},
{0.628764,0.122221},
{0.656415,0.123653},
{0.652587,0.144903},
{0.674919,0.150396},
{0.656106,0.165565},
{0.631962,0.166182},
{0.607724,0.158374},
{0.58467,0.108576},
{0.602097,0.108557},
{0.62574,0.10849},
{0.654942,0.108463},
{0.685001,0.108478},
{0.682676,0.122233},
{0.675521,0.141842},
{0.687622,0.146204},
{0.707021,0.153878},
{0.677322,0.161759},
{0.732873,0.137141},
{0.727337,0.108541},
{0.700492,0.142386},
{0.715254,0.108532},
{0.69567,0.13296},
{0.738814,0.108566},
{0.751711,0.136686},
{0.759066,0.108585},
{0.905019,0.822156},
{0.862173,0.886042},
{0.87515,0.898024},
{0.919012,0.836981},
{0.930464,0.777327},
{0.944505,0.788623},
{0.956179,0.756448},
{0.94106,0.748713},
{0.637124,0.922696},
{0.636978,0.944044},
{0.714895,0.944169},
{0.714979,0.922878},
{0.775158,0.922657},
{0.774435,0.944415},
{0.829017,0.918902},
{0.587064,0.923146},
{0.587019,0.944173},
{0.550116,0.143219},
{0.582982,0.140044},
{0.57568,0.108605},
{0.537701,0.108609},
{0.751711,0.136686},
{0.738031,0.16822},
{0.761329,0.157032},
{0.738031,0.16822},
{0.751711,0.136686},
{0.732873,0.137141},
{0.707021,0.153878},
{0.72002,0.214278},
{0.719194,0.180083},
{0.72002,0.214278},
{0.707021,0.153878},
{0.703594,0.191322},
{0.699032,0.192746},
{0.682802,0.191387},
{0.703412,0.22074},
{0.682802,0.191387},
{0.699032,0.192746},
{0.677322,0.161759},
{0.656106,0.165565},
{0.65218,0.218026},
{0.661749,0.194593},
{0.65218,0.218026},
{0.656106,0.165565},
{0.647127,0.198812},
{0.64329,0.199309},
{0.620566,0.189132},
{0.639207,0.220519},
{0.620566,0.189132},
{0.64329,0.199309},
{0.631962,0.166182},
{0.582982,0.140044},
{0.544732,0.169178},
{0.582488,0.170764},
{0.544732,0.169178},
{0.582982,0.140044},
{0.550116,0.143219},
{0.550116,0.143219},
{0.516552,0.108385},
{0.544732,0.169178},
{0.516552,0.108385},
{0.550116,0.143219},
{0.537701,0.108609},
{0.759066,0.108585},
{0.761329,0.157032},
{0.780162,0.108671},
{0.761329,0.157032},
{0.759066,0.108585},
{0.751711,0.136686},
{0.703594,0.191322},
{0.703412,0.22074},
{0.72002,0.214278},
{0.703412,0.22074},
{0.703594,0.191322},
{0.699032,0.192746},
{0.647127,0.198812},
{0.639207,0.220519},
{0.65218,0.218026},
{0.639207,0.220519},
{0.647127,0.198812},
{0.64329,0.199309},
{0.732873,0.137141},
{0.719194,0.180083},
{0.738031,0.16822},
{0.719194,0.180083},
{0.732873,0.137141},
{0.707021,0.153878},
{0.677322,0.161759},
{0.661749,0.194593},
{0.682802,0.191387},
{0.661749,0.194593},
{0.677322,0.161759},
{0.656106,0.165565},
{0.607724,0.158374},
{0.582488,0.170764},
{0.594864,0.174441},
{0.582488,0.170764},
{0.607724,0.158374},
{0.582982,0.140044},
{0.829017,0.918902},
{0.849633,0.879257},
{0.828352,0.911795},
{0.849633,0.879257},
{0.829017,0.918902},
{0.862173,0.886042},
{0.944505,0.788623},
{0.928686,0.847972},
{0.957254,0.795579},
{0.928686,0.847972},
{0.944505,0.788623},
{0.919012,0.836981},
{0.905019,0.822156},
{0.92831,0.751798},
{0.894271,0.811001},
{0.92831,0.751798},
{0.905019,0.822156},
{0.930464,0.777327},
{0.919012,0.836981},
{0.882733,0.905992},
{0.928686,0.847972},
{0.882733,0.905992},
{0.919012,0.836981},
{0.87515,0.898024},
{0.862173,0.886042},
{0.894271,0.811001},
{0.849633,0.879257},
{0.894271,0.811001},
{0.862173,0.886042},
{0.905019,0.822156},
{0.87515,0.898024},
{0.861663,0.936807},
{0.882733,0.905992},
{0.956179,0.756448},
{0.957254,0.795579},
{0.964165,0.76858},
{0.957254,0.795579},
{0.956179,0.756448},
{0.944505,0.788623},
{0.930464,0.777327},
{0.94106,0.748713},
{0.92831,0.751798},
{0.861663,0.936807},
{0.911018,0.905377},
{0.882733,0.905992},
{0.911018,0.905377},
{0.861663,0.936807},
{0.913992,0.922098},
{0.913992,0.922098},
{0.9516,0.888222},
{0.911018,0.905377},
{0.9516,0.888222},
{0.913992,0.922098},
{0.957353,0.909822},
{0.957353,0.909822},
{0.985517,0.898256},
{0.9516,0.888222},
{0.985517,0.898256},
{0.957353,0.909822},
{0.986447,0.917646},
{0.775158,0.922657},
{0.828352,0.911795},
{0.776467,0.914487},
{0.828352,0.911795},
{0.775158,0.922657},
{0.829017,0.918902},
{0.774435,0.944415},
{0.714877,0.954766},
{0.770807,0.95491},
{0.714877,0.954766},
{0.774435,0.944415},
{0.714895,0.944169},
{0.815196,0.954955},
{0.770807,0.95491},
{0.807822,0.971227},
{0.770807,0.95491},
{0.815196,0.954955},
{0.774435,0.944415},
{0.843848,0.97349},
{0.807822,0.971227},
{0.828999,0.990882},
{0.807822,0.971227},
{0.843848,0.97349},
{0.815196,0.954955},
{0.714979,0.922878},
{0.776467,0.914487},
{0.71497,0.914877},
{0.776467,0.914487},
{0.714979,0.922878},
{0.775158,0.922657},
{0.587064,0.923146},
{0.637054,0.914316},
{0.587082,0.915111},
{0.637054,0.914316},
{0.587064,0.923146},
{0.637124,0.922696},
{0.714895,0.944169},
{0.636934,0.954749},
{0.714877,0.954766},
{0.636934,0.954749},
{0.714895,0.944169},
{0.636978,0.944044},
{0.636978,0.944044},
{0.587039,0.954725},
{0.636934,0.954749},
{0.587039,0.954725},
{0.636978,0.944044},
{0.587019,0.944173},
{0.637124,0.922696},
{0.71497,0.914877},
{0.637054,0.914316},
{0.71497,0.914877},
{0.637124,0.922696},
{0.714979,0.922878},
{0.699032,0.192746},
{0.703594,0.191322},
{0.64329,0.199309},
{0.647127,0.198812},
{0.702075,0.062004},
{0.743431,0.037585},
{0.747846,0.046846},
{0.704893,0.074095},
{0.753172,0.056163},
{0.76835,0.04312},
{0.76447,0.033993},
{0.762289,0.02862},
{0.760953,0.022878},
{0.739814,0.031022},
{0.700256,0.053399},
{0.66599,0.067575},
{0.666687,0.073252},
{0.668826,0.085598},
{0.70858,0.084958},
{0.58545,0.061665},
{0.555152,0.044435},
{0.562057,0.037606},
{0.588959,0.051919},
{0.594421,0.022394},
{0.571957,0.008435},
{0.552915,0.00833},
{0.539783,0.008361},
{0.529934,0.008451},
{0.551276,0.055257},
{0.581386,0.075467},
{0.629571,0.063316},
{0.619987,0.053806},
{0.615788,0.023744},
{0.615867,0.008396},
{0.593543,0.008386},
{0.64594,0.02875},
{0.650195,0.052897},
{0.662458,0.034458},
{0.671871,0.008568},
{0.655655,0.008565},
{0.635112,0.008461},
{0.627743,0.082495},
{0.631319,0.100129},
{0.670997,0.097058},
{0.706272,0.025905},
{0.73967,0.026143},
{0.692492,0.049739},
{0.665838,0.052222},
{0.656523,0.058629},
{0.740449,0.008464},
{0.703374,0.008555},
{0.695104,0.028077},
{0.689572,0.008572},
{0.774686,0.020658},
{0.765966,0.00846},
{0.689294,0.034087},
{0.689572,0.008572},
{0.78011,0.008529},
{0.54592,0.067255},
{0.512178,0.00821},
{0.579426,0.089404},
{0.778308,0.034725},
{0.774686,0.020658},
{0.785183,0.008622},
{0.778308,0.034725},
{0.785183,0.008622},
{0.774686,0.020658},
{0.78011,0.008529}
};


// normal array: 62kb.
const tgx::fVec3 elementalist_norm_array[5306] PROGMEM = {
{0.0687578043831589,0.7500490478139783,0.6577984419332048},
{0.1854440063508602,0.8422580288446259,0.5061738173348236},
{-0.41614398035886185,0.7151801662449703,0.5615527734958665},
{-0.457205212974268,0.6056202171858911,0.6512968184820715},
{-0.6766328938970975,0.3865714536449496,0.6266820869653686},
{-0.6291870302504953,0.5216768250815442,0.5761744277017181},
{-0.7891033047336325,0.27794023688958147,0.5477820727043038},
{-0.7680894351516906,0.4745312217169693,0.42995201967679764},
{-0.8464750064049378,0.45687240345697067,0.27340020206870996},
{-0.89827444111616,0.22696921038892115,0.37628181722331466},
{-0.983367466142655,0.1253622084320354,0.13142580883988156},
{-0.7935524235261475,0.6084488180384512,0.008036600238258038},
{-0.7030190480451951,0.2368584161871984,0.6705686458274943},
{-0.48280878793580595,0.5193615870224421,0.7050951823814202},
{-0.7851606775409178,0.05668220559782267,0.6166926609033492},
{-0.9396290436067002,0.07683540356580974,0.3334570154752135},
{-0.9822991118594553,-0.10575741204314079,0.15460861760607897},
{0.6732304061888725,0.501706004612083,0.5431868049934077},
{0.7412083856262794,0.5380053895668488,0.4014477922150121},
{-0.013892401428340102,0.6403532658375914,0.7679548789568855},
{0.9397876880953825,0.2603246244027429,0.22142762075655084},
{0.9620848979118276,0.2500210254447561,0.10900521109351104},
{0.8334972946145175,0.505204257348305,0.22372062539566612},
{0.969348445594643,0.24091981133199608,0.04817920226617532},
{0.13331998844116552,0.9439757181573655,0.301886773826436},
{0.15491960623653986,0.9755764392734109,0.15572580626899477},
{-0.33293558830098324,0.9401101669654882,0.07312159743058169},
{-0.40106118052831163,0.8404755591945595,0.36434978231066545},
{-0.6613368283980553,0.6928738297522662,0.2873316123381289},
{-0.6998334496935794,0.5554202394391262,0.44915643189357535},
{-0.8543224525840954,0.3750180230826,0.35985362214922145},
{-0.8370408064943318,0.24235620188036425,0.49053660380591657},
{-0.8942625912553103,0.4358299957381666,0.10171839900533036},
{-0.918001587243138,0.26658739629541095,0.2936055959199569},
{-0.8762982443884506,0.4809970243646644,-0.027262601380973476},
{-0.9779234523492999,0.16435020879784437,0.1290532069083577},
{-0.9998765393523231,-0.0014128001969012992,0.015649602181077697},
{-0.9225575215090123,0.38584816717212417,0.002968399747449213},
{-0.9953363061552901,0.004719600503358069,-0.09635021027600868},
{-0.9273531943786445,0.3664057977789506,-0.07591339953983423},
{-0.9622756907743185,0.2501784236000723,-0.1069404100880059},
{-0.9828360436050161,0.006993000310255097,-0.18434860817890641},
{-0.9655033051598064,-0.23404062549102292,-0.11414181243199359},
{-0.9369653803420543,-0.3476475927062006,-0.03517139926208858},
{-0.9392268393380142,-0.33248141392545233,0.08549300358073775},
{-0.9507490812778882,-0.14639421251498702,0.2732122233564386},
{-0.8858415453528081,0.03153980517519107,0.4629146759570924},
{-0.7845036790235618,0.11177401125906826,0.6099676614424361},
{-0.6949649987142313,0.4415919991830018,0.5674681989501157},
{-0.4536953994078458,0.6531345991475418,0.6062801992086951},
{0.10447940880884529,0.8450042712438172,0.524453844217639},
{0.77154979688871,0.5734359976876078,0.2754669988891738},
{0.7590526405218593,0.6248108333553898,0.18289480976379943},
{0.9539244274339321,0.2922538084049332,0.0679404019538994},
{0.9536486439366157,0.27775821279691004,0.1157784053341567},
{0.7930895185013193,0.6030412901048201,0.08573341281005774},
{0.9568230530869748,0.2904204161132628,0.012067600669541156},
{-0.9844511593127133,-0.027809598850631532,0.1734431928316069},
{-0.9977208918627453,0.006889999253232432,0.0671233927248798},
{-0.978300291463216,0.08799020822637742,0.1875800175372243},
{-0.9330600346345174,0.10319120383038324,0.3446020127913788},
{-0.9258073070576227,0.134120815509335,0.3534012408662758},
{-0.8202380011568636,0.049956400070458505,0.5698368008036978},
{-0.9699239664038363,0.09156501570924157,0.22552903869261773},
{-0.7965049884790653,-0.2872185958455669,0.5320575923041275},
{-0.9151214813385815,-0.09077740806855238,0.3928258349154695},
{-0.8427952130599379,-0.10287920159421406,0.5283106081866907},
{-0.8752994559301315,-0.022622801445558147,0.4830518308661821},
{-0.9661836515825368,-0.025005201334975725,0.25663961370145555},
{-0.8866102691730877,-0.08179260638143651,0.45522763551673406},
{0.01427797786439033,0.2619709652137584,0.9649701304875067},
{0.0024416000004545283,0.5057504000941505,0.8626764001605959},
{-0.466686436257412,0.45445943530748206,0.7587294589465741},
{-0.3277273908935526,0.1710100379755339,0.9291664674156677},
{-0.6676900104069772,0.13413340209067567,0.7322556114133315},
{-0.7707335703781044,0.3609741861265422,0.525040379820924},
{-0.5538204312238542,0.6726642379241516,0.4907196276662925},
{-0.17941999324227886,0.7551915715562689,0.6304713762537626},
{0.5605387849776728,0.5548289851306943,0.6147853835238749},
{0.6755753268478698,0.29581936796831376,0.6753435268729694},
{0.2128594847826785,0.313000356819304,0.9255925757961982},
{-0.14719238810540716,-0.9885243201175111,0.033971597254760774},
{0.3214402021424247,-0.9414536062748636,0.10169220067778667},
{0.6628551210635447,-0.7477169109577332,0.039274795322940065},
{0.8325462163417168,-0.5536080108665502,0.019620600385124917},
{-0.7797211868030476,-0.038676599345390056,0.6249311894229023},
{-0.6352294765574292,-0.20979102528387325,0.7432840895800984},
{-0.501596612791406,-0.062011801581386534,0.8628762220045347},
{-0.8781366327876204,0.16802400627363343,0.4479330167247979},
{-0.8492998542567076,-0.1462428093425818,0.5072502324051952},
{-0.6787282427446635,-0.3947896248628959,0.6192488389987945},
{-0.9585582516030646,0.16227420873587647,0.23416481260603825},
{-0.8944684778263461,-0.22166681928689383,0.38831683378685894},
{-0.7032068615350192,-0.5394006472009462,0.4631922405322317},
{-0.9560295925435619,0.12976779898789165,0.2629975979487818},
{-0.9710702598893619,-0.052687203249407503,0.23290901436432854},
{-0.9442490829822372,-0.18865301657915232,0.26982162371238944},
{-0.8839845397979759,-0.3399724537650363,0.32092065075208376},
{-0.5498279613455012,-0.8349943412974784,-0.021763798469941906},
{-0.4356121787247261,-0.8985530525265811,-0.05333330612160098},
{0.9304972978410516,0.13329241401559144,0.3411860358754406},
{0.9210395898955327,0.0862827990534156,0.37979119583341725},
{0.9252204042132872,0.22442580102199466,0.305941601393203},
{-0.7485847795743854,-0.6621129819338237,0.035031799044134955},
{-0.7749729596806069,-0.6319427671220157,0.008077799579737624},
{-0.7805434368935104,-0.6249366295385304,0.014358000678651594},
{-0.7362343563375786,-0.12198259276581523,0.6656419605240647},
{-0.873176314054123,-0.20404142665185213,0.44264005781755966},
{-0.7025378472375083,-0.3647496245251747,0.6110632410869038},
{-0.693772979015338,-0.19551339408627516,0.6931475790342545},
{-0.6479920655447508,0.13440861359550454,0.749693675831924},
{-0.4643706507328957,0.007099600775637533,0.8856124967539322},
{-0.5730966362509194,0.3671264232223844,0.7326516463434858},
{-0.4941075857200044,0.33177039041164347,0.803608176775258},
{-0.4074685675599372,0.4562493636763197,0.7910789370193129},
{-0.492273605104444,0.5561348057666284,0.6696124069432914},
{-0.6952969630351081,0.37941397982876746,0.6104155675477578},
{-0.5647548207640471,0.7615148279982202,0.3180364116930796},
{-0.7661987753950285,-0.02917999906294154,0.6419407793853303},
{-0.9971631640588497,0.043376598436559936,0.06151499778279036},
{-0.7844680945735965,0.10399481253736578,0.6113876737074351},
{-0.9590160647082493,0.1884472127152085,-0.21160301427761338},
{-0.9885826807524586,0.15041581228672815,0.008908800727716128},
{-0.9950853994573401,0.09857939994624071,0.009335399994909035},
{-0.9917435944408804,0.11172699937372547,-0.0629421996471838},
{-0.9204271140088772,0.06053920749870031,-0.3861980478364937},
{-0.9908245976272326,0.10215359975536868,0.08849439978807891},
{-0.825496664570302,0.16360901279748766,0.5401734422523359},
{-0.982344333483354,0.044786806085740906,0.18164182468193604},
{-0.9895356671236502,0.05675820385010662,0.13265620899853262},
{-0.9668308590381554,0.03173420193780404,0.2534384154758575},
{0.31594003227038825,0.9407428960882933,0.12322621258643196},
{0.3528855749015014,0.9333021336201761,-0.06647479527207209},
{-0.3070125937949869,0.9472745808546904,-0.09172859814607881},
{-0.31663080009910544,0.9323206002918164,0.1747090000546839},
{-0.7177853640747429,0.6910313654137842,-0.08520459573549816},
{-0.7175078033452797,0.6782760031623669,0.15850620073901298},
{-0.9425310534240754,0.31696361796597383,0.1056848059903735},
{-0.9353581980343821,0.34662319927158525,-0.07040879985203873},
{-0.9834579159470004,0.17345202044951916,0.052200806154332376},
{-0.9661633534268695,0.22376498921358795,-0.1282871938160186},
{-0.972247092008919,0.15425441459791656,-0.17590101664644978},
{-0.9935690718231832,0.04540920328254333,-0.10372320749794972},
{-0.9833431682608887,0.13038499579159746,0.1266331959126933},
{-0.9946852080196297,0.06855000055268301,0.07682600061940811},
{-0.9737657155098682,0.18780262227749017,0.12849321524209995},
{-0.9835531799045727,0.16539819662067337,0.07257119851726447},
{0.6871206397821699,0.7241128419239046,0.05937860343783836},
{0.6400199892634727,0.7676563871223339,-0.03283419944919646},
{0.6258860093582977,0.7429172111081577,0.23736200354905568},
{0.27979602840148626,0.8897856903202103,0.36054903659854853},
{-0.3328540140989641,0.8373398354678742,0.4336706183693338},
{-0.6856202064145804,0.6119132057249865,0.3943186036891976},
{-0.9142798365991711,0.28496761140742466,0.2878990115247704},
{-0.9662078038429756,0.10420220041445175,0.23576340093772064},
{-0.9857351696075575,0.0009397999710238433,0.16830119481089387},
{-0.9680358847532685,0.087862207692493,-0.23491862056754428},
{-0.8557050570614786,0.03100720206767131,-0.5165340344443398},
{-0.8853276329890613,0.046855801745939986,-0.4626008172374228},
{-0.9814103283116754,0.10123241323534118,-0.1630514213176899},
{-0.7301713860334424,-0.004624799911537845,-0.6832483869309752},
{-0.78462966016156,0.012334200945726128,-0.6198420475264529},
{-0.7863781753654301,0.1833229942571103,-0.5899169815198951},
{-0.49010462406423566,0.10305620506008041,-0.8655500424986813},
{-0.5462105910493673,0.12303939798378045,-0.8285621864225338},
{-0.8746048555171717,0.21108681339912852,-0.4364730277059381},
{-0.4584206419027108,0.10450320955229186,-0.8825698806727863},
{-0.4733166209448857,0.10821760478877197,-0.8742198386853828},
{0.13071999485657354,0.909797564202287,0.39392978450008453},
{0.10731559718470628,0.9514227750405846,-0.28857939242947184},
{-0.24899618331361595,0.8962733399365848,-0.3670081754050874},
{-0.28841362018433375,0.875694261284572,0.38726882710261484},
{-0.5456277970314247,0.7848427957299372,-0.2937891984015929},
{-0.1406012041094555,0.4809138140560241,-0.8654208252942953},
{0.044617801422768014,0.6226020198534713,-0.7812656249129205},
{0.6169486416310911,0.7561640510252108,-0.21815201472068463},
{0.6359215308500363,0.7011307237592034,0.3225205649291866},
{0.13563259998294014,0.8370827998947118,0.5299963999333371},
{-0.3014755739779501,0.7600447343962704,0.575712150307051},
{-0.6720153990727666,0.6013667991702462,0.43214959940372866},
{-0.6144620085695699,0.7327182102188253,-0.2925072040794401},
{-0.2029353909501411,0.5726621744622569,-0.7942765645794121},
{-0.8487778139248113,0.4508654073967717,0.2762184045315618},
{-0.7956921316747789,0.6006633484216892,-0.0779587933057629},
{-0.16878318425951053,0.7021599345175226,-0.6917251354906576},
{-0.9393321752810795,0.10731419717598187,0.3257893914267154},
{-0.9496726312091872,-0.004344800142783604,0.3132140102931835},
{-0.925515249220198,0.37841542012466234,-0.014943000794689723},
{-0.22233820989524675,0.8325478370528587,-0.5073754225809365},
{-0.6681575839621736,0.4938119881470014,0.5565205866418031},
{-0.8561236341026583,0.4315738171912255,0.28424701132263885},
{-0.9580640369906999,0.1626524062799835,0.23591840910877218},
{-0.9039356716225864,-0.1441304114200525,0.4026496319036066},
{0.5245189947912642,0.7009699930390174,0.4832399952011852},
{0.7615742732637685,0.5579114536713188,0.32975663172272807},
{0.9161164288995896,0.38428561212258194,0.11425960360440611},
{0.8752336546953658,0.3985888249087332,-0.2740310171248291},
{0.7222965960244363,0.48612659732433,-0.49190299729253645},
{0.7431443401766749,0.5643441545701393,-0.35951657105881646},
{0.28559998615762017,0.6401761689721215,-0.713166965434424},
{0.20240281339569466,0.8792602581923826,0.4312012285383385},
{0.05966662141629451,0.9886255335542458,0.1380559621796436},
{0.019329191076525365,0.9845291423640736,0.17415151509013246},
{-0.30948376817350176,0.8714555103818031,0.3805063608697248},
{-0.5725010753128077,0.8139335070733669,0.09876621299274556},
{-0.37413361889592567,0.923849246659765,-0.08078740408023419},
{-0.4906749467276692,0.8629897063056442,-0.1203613869324251},
{-0.7093562310351729,0.7048288308370938,0.005482400239861485},
{-0.4863401757815632,0.8567263573373244,0.17173579144801804},
{-0.6896046568354115,0.6804678560823803,0.24780822042370515},
{-0.7134011062881933,0.5382061293016673,0.4487683410501446},
{-0.804988822906231,0.3894062110806863,0.44761121273692944},
{-0.8217723841633945,0.36391319298692704,0.43847159155009124},
{-0.8065256468473985,0.5346824310572652,0.2522520146521697},
{-0.8505906552501858,0.5121662332677998,0.11908520773518946},
{-0.7338506288724583,0.6376002250856035,0.2343698092209944},
{-0.44603921179270595,0.6979784184536563,0.5602456148121772},
{0.20634700338411568,0.7572074124182926,0.6197240101635483},
{0.7702208085746988,0.5733976063835095,0.2792402031087198},
{0.7960373726928299,0.4809249835024073,0.36747198739428527},
{0.963910036563229,0.23806180903020838,0.11918060452078262},
{0.9735420243332353,0.15023260375499486,0.17218040430357004},
{-0.30441516703366334,-0.42431634307642263,-0.8528112611112253},
{-0.555959216919396,-0.1994324060692866,-0.8069300245571405},
{0.18443938790059214,0.12761199162852602,-0.9745241360702444},
{0.497902851637109,0.02166760224712981,-0.8669620899119493},
{0.7265198186802487,0.004644000119406347,-0.6871298176674547},
{-0.8042017291750096,-0.08928121434080692,-0.587612494385335},
{-0.9998907747116427,-0.01217239969214638,0.008382799787989606},
{-0.8854220624150856,-0.09127920643444493,-0.4557366321257422},
{0.9497227179802997,0.3066546380944937,0.06316400784661505},
{-0.5887232465539519,0.23914461891062933,-0.7721494610585858},
{-0.4747112243112822,0.005808200297454092,-0.8801224450735183},
{-0.7741710522957828,0.08922800602741268,-0.6266558423310297},
{-0.8675991603202493,0.22075558990371683,-0.44557677962149295},
{-0.5447176141378843,0.3305918085803518,-0.7707086200033726},
{-0.8010720763200948,0.1857146176934856,-0.569028654212751},
{-0.6585658094717965,0.4307600061953886,-0.6170388088745361},
{-0.4752361912575266,0.5274917902962295,-0.704203787045425},
{-0.4677289837967177,0.8277365713251695,-0.30997058926185644},
{-0.5624547628913396,0.7369087513815181,-0.37498017526021127},
{-0.3993985995915031,0.915702199063438,-0.04438739995460145},
{-0.33415978333818547,0.9370713532759181,-0.10116579495568948},
{-0.3715286216003626,0.8092566470495031,-0.45504962645620384},
{-0.34014739951883427,0.49497639929981624,-0.7995611988689567},
{-0.2524985877972334,0.37451458190043724,-0.8921789568827228},
{-0.23056299246492942,0.25471059167575744,-0.9391289693081575},
{-0.22521917444643572,-0.005340399394073619,-0.9742934894558096},
{-0.32503498010025406,-0.17116978952040382,-0.9300823430571985},
{-0.0719572052470649,-0.24237581767386102,-0.9675102705501162},
{-0.6261242218452491,-0.04469580155942045,-0.7784412271595346},
{-0.3898339566396056,0.6151365315796837,-0.6853003237755158},
{-0.36645677290156753,0.8243615343256242,-0.4314365472683923},
{-0.19851373194166483,0.7365675767889588,-0.6465759839754599},
{-0.06183860408284572,0.49791123287420175,-0.8650204571123027},
{0.21504739371900766,0.3779603889607297,-0.9005001736986596},
{0.4390436050573521,0.3721556042868679,-0.8177658094198607},
{-0.24381799374146038,0.3627761906879344,-0.8994143769130226},
{-0.6754642211756146,0.3222056101010558,-0.6632734207934364},
{-0.16378221407545387,0.25246002169643034,-0.9536452819563362},
{0.038835598842091784,0.3380053899221531,-0.9403425719630848},
{-0.6768146974963689,0.26932383879658117,-0.68511789869246},
{-0.26682181224367413,0.07655320351280306,-0.9607006440837484},
{0.11304440757729228,0.2250336150838552,-0.9677710648690578},
{-0.5465492031842721,0.01651120009619656,-0.8372642048780184},
{-0.2594504213440063,-0.14871041223384399,-0.9542382785015794},
{-0.5029162221380005,-0.1879840082749171,-0.8436452371366397},
{-0.7164388287431825,-0.18650760748259584,-0.6722576269706539},
{-0.8160579935239269,0.03814659969727622,-0.5767097954233464},
{-0.8911428561582919,0.2613406164692367,-0.3708982233733688},
{-0.8264337216070701,0.24379823587412802,-0.5075132746789497},
{-0.48102504910962957,0.6163074629211125,-0.6235222636576983},
{-0.34608335342343227,0.8461033406016626,-0.4053830898124621},
{0.3203911793504047,0.8847159429789977,0.3385663781789913},
{0.39090700705889714,0.8947516161571922,0.21589640389860118},
{0.31528460548628634,0.7508154130649842,0.5804066100996903},
{0.7797230143839404,0.6199700114368969,0.08757400161552141},
{0.7411284268327479,0.669800424250299,-0.045782601657571025},
{0.7328435791576211,0.6672367810235059,-0.13317419621246998},
{0.3252872009861017,0.9265714028088827,-0.18882180057240952},
{0.2742646111202125,0.8092456328113181,-0.5195194210642063},
{0.7982311622606533,0.5558055737222245,-0.23217918902286538},
{0.417442965480048,0.5884289513405642,-0.6924541427383241},
{-0.07321039691663583,0.5610343763712075,-0.8245487652729091},
{-0.29489237599153284,0.7422183395727863,-0.6017893510057192},
{-0.3752365892645489,0.585115783259943,-0.7189137794320064},
{-0.2314769906701673,0.46018058145211826,-0.8571185654532713},
{-0.24132542018493197,0.3071326256891759,-0.9205604769974858},
{-0.49457334732300545,0.3671181608982541,-0.7877953160919411},
{-0.09239160921483652,0.22754362269445572,-0.9693748966822774},
{-0.5867128531973976,0.2840388257538697,-0.7583468687594958},
{-0.20746178542431223,0.21972078456302904,-0.9532483330274246},
{-0.6423602301556017,0.2255030105862391,-0.7324764343861071},
{-0.2524287912371871,0.08242599713866398,-0.9640983665322899},
{-0.6654667764274903,0.12404219560611292,-0.7360485739273052},
{-0.3137990354854324,-0.13879981569594207,-0.9392895062179629},
{-0.6424232915538954,-0.11465021633918641,-0.757725307985972},
{-0.9931351288209762,0.11468961487655377,0.022998002983103817},
{-0.9877264036008356,0.11932380043500447,-0.10078880036743362},
{-0.9669023467664387,0.08185419549345355,0.2416603866951993},
{-0.9203331296183466,-0.0005470000770386757,0.39113505508687835},
{-0.8470895239970753,-0.03439760503512592,0.5303358776306352},
{-0.7693562754548203,-0.05607520549959063,0.6363540624105931},
{-0.7157538086217556,-0.08052500096998001,0.6936946083560371},
{-0.3298813777460777,0.8880525400916401,0.32022017839782585},
{-0.2830844150848668,0.6008336320169351,0.7475708398361971},
{-0.28169017390523193,0.9085023158396018,-0.30866517140636485},
{-0.5362451849366906,0.7634689785538971,-0.3599391898891859},
{-0.6436183518001958,0.6575547507565157,0.391633970671003},
{-0.8897262268993782,0.35457641072002233,0.2875114086924246},
{-0.8108050536586586,0.4267070282392502,-0.40064482651446715},
{-0.9527845858653646,0.2255215966543691,-0.20332619698363966},
{-0.9914359210324493,0.12823998978572623,0.024684398033895674},
{-0.9753222383017048,0.1357646053315875,-0.17411060683746646},
{-0.9870427673008332,0.08885199705647377,0.1336109955736789},
{-0.5944216442202879,0.20208141503326543,0.7783482579029791},
{-0.563408237596571,0.39935302664906797,0.7232484482628045},
{-0.9291844308041554,-0.010982600364093195,0.3694532122480466},
{-0.7275092333552952,-0.10912260500312097,0.6773644310562251},
{0.17127337406247867,0.9709256529636905,0.1672387746734756},
{0.2922128197094865,0.9279130625868844,-0.23149301561399144},
{-0.25250779935754947,0.9332995976254245,0.2553265993503776},
{-0.32720621475395106,0.8338454375986587,0.44456482004573056},
{-0.6934076343574339,0.6275362310935927,0.3540962175450006},
{-0.7171986365231694,0.5271096268429319,0.45583062321306567},
{-0.9526282784091221,0.2955644243273768,0.07170100590158099},
{-0.9513361402346252,0.2282762336497592,0.20700123051365207},
{-0.9871549222002907,0.04456920551723923,0.15342341899234455},
{-0.9473921211928901,0.20584742633254377,-0.24510203135409606},
{-0.9988620002470194,0.034803806977298776,-0.03260980653745618},
{-0.9554642447194349,-0.06529980305628422,0.28779161346976445},
{-0.9962130839475728,-0.061912005217119356,0.061044205143992725},
{-0.9412595597073068,-0.07344821246225451,0.3295994559244694},
{-0.9867322935529024,-0.04711660446716412,0.15536861473062646},
{-0.9132953174984093,-0.015157801950100459,0.4070158523639116},
{-0.9817390821262867,0.03503600293089771,0.18697821564145387},
{-0.8900968996320051,0.0864310096745588,0.4475010500905316},
{-0.9720815602705413,0.043523007175792855,0.23057143801513233},
{-0.8646912052798738,0.08895480054316514,0.4943644030186286},
{-0.7466351711203613,0.17252659332671982,0.6424721751493567},
{-0.7458991048550256,0.15562398014900475,0.6476231173908583},
{-0.7778725907116569,0.004625799944764712,0.6284049924964046},
{-0.8036531430484952,-0.05865459584339647,0.5922003580332612},
{-0.8082537146895775,-0.13259621881513695,0.573710881408421},
{-0.8637803661187858,-0.11803739537006118,0.48984758078605234},
{-0.9635506579256224,0.14193640853276862,0.2267690136326369},
{-0.7274632608500348,0.40374123377169596,0.5547884464063245},
{-0.389532589198503,0.7267611798473634,0.5657583843118711},
{0.11069420857888786,0.8679496672667789,0.48415923752272005},
{0.5487205685549212,0.8281619525412035,0.1142519934526549},
{0.6103582299987294,0.6628214325772633,0.4337402213180635},
{0.7416999894580995,0.6441533908445448,0.18694259734295499},
{0.8036595627360428,0.44281557946759853,0.397549581566485},
{0.5149160178736828,0.8304756288273376,-0.2125364073775299},
{0.44013653682940806,0.8604860764987448,-0.2565999631714929},
{-0.8764202253397455,0.37921121096405047,0.2967936085811284},
{-0.8904840017704069,0.19384640038539377,0.41165740081843255},
{-0.8482569740970597,0.07873861616038769,0.5236987074844155},
{-0.8136740688518332,0.2597326219781702,0.5200706440075685},
{-0.7338645789318343,-0.05418619844439445,0.6771311805605662},
{-0.8285316709465735,-0.11991681026839057,0.5469508468350093},
{-0.8931781289073175,-0.09760841408726705,0.43898226335581236},
{-0.8979521289421097,-0.1498564215187453,0.4137934594189822},
{-0.9897214188152773,0.10915420207509562,-0.09239520175649563},
{-0.9807507367149424,0.1154577925498368,0.15747218983876715},
{-0.8226384289778012,0.34231161205807736,0.4539700159912939},
{-0.8727179084654727,0.36704064561753197,0.32193884001206813},
{-0.7607194898327307,0.4177844493358176,0.4967514586609659},
{-0.6932440002623652,0.33515320012684213,0.6380322002414697},
{-0.8408879990904787,0.022811999975326083,0.5407281994151376},
{-0.5123459782969428,0.09276359607051932,0.8537543638348294},
{-0.9451726798974538,-0.18334081549818845,0.2702494228447576},
{-0.0759583991436602,0.7482889915639396,0.6590097925704554},
{0.45318240541697996,0.616702807371572,0.6436640076938446},
{0.4079665872444353,0.7252139773253151,0.5546421826584469},
{-0.1973805969752411,0.8375999871641991,0.5093791921940187},
{-0.7472497748328372,0.5198865824903657,0.4139271860590485},
{-0.8416783596053314,0.4848137767323329,0.2377669885888492},
{-0.9659229539285092,0.2265505891942485,0.12517059402975583},
{-0.9739817235124223,0.21726242755144995,0.0644720081758145},
{0.625874566239,0.5369541710355544,0.5656511694875775},
{0.6774354433608286,0.4030544257984344,0.6153278393854873},
{0.7911767825074614,0.2971723934296611,0.5345351881816838},
{0.7634120645504625,0.4931648416996536,0.4171216352698048},
{0.8395673935110004,0.47739639631021286,0.2592667979961321},
{0.8986649239220733,0.24884423431456223,0.36121724981032344},
{0.9429385676208858,0.09975079657470536,0.31767378909155247},
{0.7937768253179727,0.07590360242098947,0.6034542192475226},
{0.7081890145847989,0.2540362052317487,0.6587366135663514},
{0.9820903064905914,0.14928341618718682,0.1149482124641319},
{0.7785343354730527,0.6275809479844614,-0.005142199573801147},
{0.48177599907035545,0.5311039989751712,0.6970081986550392},
{0.01117360108575742,0.6406584622538494,0.7677446746030282},
{-0.6760416169756757,0.48528081218559543,0.5545000139237173},
{-0.9420013712877044,0.23741679276351255,0.23720599276993773},
{0.9870357005216751,-0.0817888083295346,0.13809821406419626},
{-0.15117941063417176,0.9405122661569518,0.3042720214029207},
{0.3865347594037948,0.8500641107211544,0.35774556242740946},
{0.31113157527476054,0.9479509246675185,0.06772139461826496},
{-0.17598919751673264,0.9715479862911278,0.15850019776350835},
{-0.805985034961133,0.5835746253136587,0.09914020430039482},
{-0.7708641626805242,0.6061857706530199,0.19572239052458607},
{-0.959482917538123,0.2689596329479659,0.08398361028812054},
{-0.9632723047917412,0.26704522905111505,0.02816580306408015},
{0.8508545264490913,0.39578025881857887,0.3455496513535958},
{0.6490006709152948,0.7088250774522148,0.2763424301955079},
{0.6935388854762315,0.572383670544277,0.4374708539167461},
{0.8389996369984586,0.2627610115873142,0.4764832210121005},
{0.693425594836226,0.4584945965857008,0.5558269958608898},
{0.8849684353291973,0.4574892182636196,0.08680140346523535},
{0.9160338434258312,0.28891281369630517,0.27822901318982507},
{0.791665867878527,0.13095981122867545,0.5967534511664666},
{0.8637499045186162,0.502179860766599,-0.041850805064183746},
{0.975659087238171,0.18813461682198226,0.11267081007441587},
{0.958478100948299,-0.12315041297037949,0.2572036270890578},
{0.8924474909680877,0.05318960542167102,0.44800484566559323},
{0.4477625981516808,0.6641097972586212,0.5987209975285396},
{-0.116210792640982,0.8423177466604495,0.5263039666719392},
{-0.7805539991237656,0.5545395993774849,0.288480999676157},
{-0.9580527273380729,0.25448283382418596,0.1318084175191087},
{0.9128136759666575,0.4081874339703883,-0.012418201033474028},
{0.9997364118237427,0.02293160027120883,-0.0011174000132153337},
{0.9931717081609933,0.028920403149565687,-0.11302021230842393},
{0.9167596410094283,0.3888478173943376,-0.09137360408741735},
{0.9539737057382989,0.273504430315189,-0.12300201363352427},
{0.9791468930868337,0.03087660293541778,-0.20079341908929474},
{0.968864070609634,-0.2104970153407662,-0.13035880950039133},
{0.9444286483942441,-0.3247448166405159,-0.05094440261048398},
{0.9483443079701246,-0.30949923523685513,0.06966560793151212},
{0.9725994085144855,-0.18196340159297314,0.14470560126680493},
{0.9405662123274183,-0.2111172027669823,0.2660164034865121},
{0.9589517227843783,-0.2541302325388879,0.12581501610938087},
{0.9838107803625664,-0.1684455966377282,0.06117539877890357},
{0.9290484566923223,-0.12024480733756925,0.34987162134983874},
{0.9750801300950046,-0.06215660829292279,0.21296782841412698},
{0.8835659550392175,-0.0012103999384080746,0.4683051761700108},
{0.8958454510274658,-0.0600952034230301,0.44028342507859747},
{0.9797997034133767,-0.0680924071868421,0.18803181984589848},
{0.8674224260247203,-0.17547060526453234,0.4656054139692615},
{0.8089468642027339,-0.3162416250987769,0.4955766393318479},
{0.853788471058017,-0.08222400684323468,0.5140860427856969},
{-0.004472154238276497,0.26174161067884777,0.9651276232062324},
{0.3390005855211453,0.17912639381589437,0.9235758431524905},
{0.46814135384053446,0.4658395540674955,0.7508909259609869},
{-0.00029000002600392644,0.505716845346974,0.862699477357144},
{0.1715285765216023,0.7594638960465029,0.6275289141054295},
{0.5454323815894211,0.6860461768431292,0.4815019837473341},
{0.7704124310721978,0.3797338153153866,0.5121200206547739},
{0.6764096701478802,0.150495015607267,0.7209862747707507},
{0.5173536226696706,-0.04960820217375805,0.8543326374355926},
{0.6525196499333634,-0.1941132148543047,0.7324876560528288},
{0.7907985784135874,-0.019555999466180283,0.611763983300691},
{0.6984267646648589,-0.37802158087495125,0.607700369254932},
{0.8609934306341813,-0.1254194044624275,0.4929100175377584},
{0.9059851299886177,-0.19974342865871778,0.3732204535487937},
{0.7238029116206878,-0.522018936259341,0.4512267449033587},
{0.8972539011552082,-0.31828703588325596,0.3059882344967055},
{0.9529532017995378,-0.16555140031262397,0.2539152004794884},
{0.9758340299987388,-0.028975400890751353,0.21658340665812917},
{0.9568622156308036,0.15305280250019104,0.24696060403422007},
{0.9581151299576283,0.18560798643125115,0.21809418405636918},
{0.8811722613999267,0.18944241320031371,0.4331824301840748},
{-0.6711601911888747,0.27942299633167905,0.6866343909857263},
{-0.204875734981919,0.30790824490099294,0.9290954988253944},
{0.4564012054397315,-0.8876934799110193,-0.06081303640359352},
{-0.9276158458600299,0.11067000547137026,0.3567646176379436},
{-0.9251502986916901,0.20189962153792188,0.3214552342916825},
{-0.5634927986902061,0.5411459987421493,0.6242089985490761},
{-0.2966619899324729,-0.9489897677950647,0.10681799637502239},
{-0.6437162451660043,-0.7636140535785696,0.050229203524305065},
{-0.8183812303056232,-0.5737006212448114,0.033462801239167034},
{0.17176177870378742,-0.9846414779173434,0.03128979612047479},
{0.5695487520303052,-0.8213669308211617,-0.031154197376067744},
{0.7649699876384982,-0.6436783895985049,0.022339399639007367},
{0.79567080312226,-0.6057282023769138,0.001148000004504821},
{0.7902043948204631,-0.6128229959831414,-0.004998999967233155},
{-0.9163686387921947,0.06391640270574245,0.3952002167298214},
{0.7500420634880632,-0.10388800879370477,0.6531800552890813},
{0.7098506429701286,-0.17842501080078704,0.6813784412465911},
{0.7213531716095017,-0.3474163863266363,0.5991255764200474},
{0.8851822801404062,-0.1826342165348772,0.4278984387399923},
{0.9537526959035262,-0.16022598251228032,0.2543293722414511},
{0.9967029033276172,0.06765060701329954,0.04479640464401752},
{0.7773385236380917,-0.0103885989794752,0.6289967382104581},
{0.7918448824032944,0.12318481281922083,0.5981698622485141},
{0.6570060037564318,0.1502950008593117,0.7387520042238147},
{0.5761932491812995,0.38111903253062984,0.7230142617132899},
{0.6959916956228345,0.3963546544554709,0.5987474822623772},
{0.48974699314508,0.5680913920485043,0.6613773907427933},
{0.5513027679905242,0.7751015549964267,0.30867918207761796},
{0.4788424023878339,0.018581800092661492,0.87770420437683},
{0.49928783751667927,0.34386322583801443,0.795279659757618},
{0.40944660406336447,0.46619560462654386,0.7842290077827201},
{0.9715353383980161,0.059188396247050946,-0.22938138545565162},
{0.9909739003304442,0.08294540839774858,-0.10531281066232023},
{0.9969097626621014,0.06995819737981092,-0.035731998661706614},
{0.9993055123925568,0.02768860311415564,-0.024936602804636332},
{0.9958961351944513,0.027772398192777905,0.086136994394842},
{0.9721340132488452,-0.07917000107897787,0.22065260300719053},
{0.8457946398318706,-0.10308580485472507,0.5234546246515831},
{0.9650255100979331,-0.2516170287065103,0.07358420839508299},
{0.8967602529339298,-0.4071880240354791,0.17325981022717346},
{0.9157474066630331,-0.18598560135324238,-0.35611240259109517},
{-0.33663719278421556,0.9327979800055689,0.12869859724135846},
{0.296728784550015,0.9397863510674874,0.16956899117093283},
{0.28228239086416207,0.9544487691100487,-0.09666539687150376},
{-0.37656774196961246,0.9244206575435892,-0.060358790698502224},
{-0.7034517056436936,0.7071841051430545,0.07103759047149279},
{-0.6589773986377224,0.7518425984457459,-0.021942999954638113},
{0.7033420202442092,0.6955720200205663,0.14659320421937466},
{0.6992229362401288,0.7082813354141227,-0.09708159114744465},
{0.9361752408438849,0.33983521482648743,0.08993300392363855},
{0.9253314411092382,0.3692750164055969,-0.08600980382111464},
{0.9796811769644628,0.1973509953596269,0.035740399159625284},
{0.9672018256540035,0.12773980338816293,0.2195522058233896},
{0.9117700731598865,0.3071986246494343,0.27258822187231624},
{0.6770359987579233,0.6285053988469566,0.38288799929756134},
{0.31959736367281427,0.8452831039204957,0.42819855132860885},
{-0.29528882941859996,0.8827846879487707,0.36537063640060685},
{-0.639717774203023,0.7275097706627617,0.24797319000034243},
{0.9581436795456856,0.24719062052191945,-0.14442121198993907},
{0.9651180830090186,0.17784001529587457,-0.19214581652630486},
{0.9902905358672964,0.0695604095436485,-0.12035781651302375},
{0.9881030534117736,0.024968801349685096,0.151752808202977},
{0.9818624122699419,0.15431020192835287,0.11015700137658797},
{0.9938698660794281,0.09275900616726825,0.0601536039994328},
{0.9709228816233735,0.21147741777844628,0.11218760943136817},
{0.9803140640722313,0.18930601237282932,0.05610320366684267},
{0.9615356406527854,0.1113526047078791,-0.2510972106161442},
{0.9757836471263701,0.12505920603984955,-0.1794616086672637},
{0.8760444808928298,0.06829840630658772,-0.477369244079667},
{0.845916219338271,0.051722201182407807,-0.5308018121345224},
{0.7735945025414434,0.031303604149353105,-0.6329072838930812},
{0.718509764866411,0.013010799363799772,-0.6953951659966654},
{0.7716816685872394,0.20229001797958207,-0.6029810535930911},
{0.8617661533411896,0.23222478742659797,-0.45103297557961397},
{0.5290856073185133,0.13612920188299088,-0.8375782115857002},
{0.4728707613815355,0.11477859062624866,-0.8736241286527627},
{0.45581902360024934,0.11952800618862004,-0.882010245666505},
{0.4408798085856405,0.11545040224826729,-0.8901102173338996},
{-0.1462051919860141,0.9064263503158,0.39625157828015184},
{0.27346699650392137,0.882533388717446,0.3825579951092715},
{0.22091921219288066,0.901993249782434,-0.370948620473241},
{-0.13526699159366262,0.9484695410561671,-0.2865455821922643},
{-0.07285259646904163,0.6211715698935789,-0.7802809621819987},
{0.11432619506666246,0.4840161791140151,-0.8675585625636169},
{0.521362632955844,0.7978318504317348,-0.3027298191358492},
{0.6643300139535878,0.617634012972785,0.42094400884150807},
{0.29249680634495195,0.7672764166440519,0.5707298123804881},
{-0.14706420242107093,0.8336416137239752,0.5323662087641745},
{-0.647303770757535,0.6855089690315846,0.3332795849438285},
{-0.6387435826430248,0.7408771798676852,-0.20762379435810996},
{-0.3130145916746947,0.6328881831669594,-0.708148581165245},
{-0.7420615674342875,0.46829897944848436,-0.4796255789514113},
{-0.8891482864476598,0.37710883666449896,-0.25923782520446104},
{-0.7625856226500592,0.5460116162174516,-0.34689261030328655},
{0.5914518017272048,0.7474008021826195,-0.30261660088372516},
{0.842061355540088,0.4714527751078127,0.26203998616457735},
{0.6651743791168109,0.5100489839869818,0.5453375828790942},
{0.7794172353335405,0.6198372280992552,-0.09116240413269087},
{0.9417711740848308,0.1302133964168555,0.3100185914690697},
{0.9576413806527906,0.1859739962427711,0.21985599555825378},
{0.8500092775184527,0.45234484125257585,0.26994142461789783},
{0.954614711366218,0.018840202197915074,0.2972470346771086},
{0.9156462872329484,0.40083483818724025,-0.030386002894852153},
{0.1934740028742343,0.8376096124434614,-0.5108600075892954},
{0.14002521122372685,0.7059212565831487,-0.6943112556525487},
{0.17559739181126868,0.5772755730795855,-0.7974449628123034},
{-0.5332516205562852,0.6880930265252573,0.49210841897025825},
{-0.7692938943125753,0.539275066113121,0.34259204200051246},
{-0.9231549491430814,0.36189478006309406,0.12968079285584122},
{0.913798665769638,-0.12200220878097265,0.38741122788349025},
{-0.2164855716566154,0.8741618855503102,0.434712543085238},
{0.2945123684898112,0.8788099059752017,0.3754405598312187},
{-0.04036076795098072,0.9838030887715854,0.17464962334312412},
{-0.08138283417451504,0.9869090500875424,0.13923850457767914},
{-0.20380360425721278,0.12288600256694115,-0.9712688202886404},
{-0.5127480529520172,0.009361400966761477,-0.8584880886569451},
{-0.7378350593524875,-0.013185601060668252,-0.6748522542860623},
{0.554090647602661,0.8276506711045647,0.08931920767353137},
{0.6919809548620977,0.7218885529112257,-0.006266999591203756},
{0.4674332363418698,0.874654668002409,-0.12839540998245078},
{0.35011674880500143,0.932669663622571,-0.08686518729834218},
{0.43824343576948327,0.7087474578480549,0.5528288451219585},
{-0.21429840781636741,0.7520878274318173,0.6232496227325443},
{-0.7791606320817994,0.5545358228329132,0.2922306120325431},
{0.3003144102710959,-0.4169559320932677,-0.8578805311205973},
{0.5470430277465155,-0.1860062094344026,-0.8161774413972553},
{0.7219393640735982,0.6553213673887587,0.22216538894421964},
{0.839748276693693,0.5327438486551677,0.1049134095816771},
{0.797385092163082,0.5542106640565811,0.23880442760140896},
{0.6768928371907137,0.6971056383012714,0.2363468129856695},
{0.8199027464243914,0.3839057749141156,0.42470677224802095},
{0.802656545320435,0.4089906740474901,0.43413027859899883},
{0.7075037875562677,0.5555189902294098,0.4368489923166039},
{0.46815620149220105,0.8683450027677629,0.16372760052186536},
{-0.8012360000396772,0.4614800000228525,0.3808636000188604},
{-0.9672858356455863,0.21455180790647885,0.13537220498862018},
{-0.955713483461105,0.28345822475400534,0.0791402069112022},
{-0.9738871782776026,0.1265249971778802,0.18850779579536384},
{0.7961726358712563,-0.06980000314481269,-0.6010300270791801},
{0.8796200969393122,-0.069791807691468,-0.47052905185507105},
{0.9998907655715817,0.012172599580870868,-0.00838359971133439},
{0.5696990213235955,0.2532460094788919,-0.7818628292647979},
{0.854375779460704,0.24171819418906565,-0.4600155889411702},
{0.7611545653034854,0.1079185950806324,-0.6395289708476737},
{0.4596069934066069,0.017181999753511847,-0.8879561872616293},
{0.6138879881433552,-0.02960019942830116,-0.7888379847643674},
{0.3134662149224279,-0.16339740777846518,-0.9354358445310316},
{0.20891661214566842,-5.6000003255640914e-05,-0.9779334568535714},
{0.06160480651373158,-0.24075082545558282,-0.9686299024172551},
{0.44217899347650685,0.838813587624933,-0.3175995953144342},
{0.5379843678833887,0.7503053552082423,-0.3842065770636211},
{0.6374476234377001,0.4465370164182912,-0.6279054230868522},
{0.4503819969056145,0.5387595962984091,-0.7119649951083875},
{0.523510815213392,0.3435956099849985,-0.7796656226573327},
{0.7866618295254014,0.20504340769579596,-0.582340421856704},
{0.2085171759874261,0.260054970052399,-0.9428106914271149},
{0.3440381980442873,0.8179675953501977,-0.46104959737912665},
{0.3145450084635633,0.5029456135329188,-0.8050510216617658},
{0.22831320888518314,0.38036721480261426,-0.8962108348775152},
{0.30950696781629106,0.9449073017449532,-0.10656278891919685},
{0.3761895589205087,0.9251440989752691,-0.05089019444284602},
{0.3632002066025004,0.6243048113490376,-0.691613412572619},
{0.03518540035181249,0.4990902049903132,-0.8658354086573324},
{0.16965777743367874,0.7410503406753522,-0.6496619360415142},
{0.3389962239097505,0.8329510229119947,-0.43734900663519494},
{-0.33610642379839933,0.8767274620776896,0.3440660243619879},
{0.3185346074570656,0.8541945379515496,-0.4109591161975991},
{0.4553567938914706,0.6277075915794157,-0.6313741915302289},
{0.6562054125388519,0.338416806466509,-0.6744394128872694},
{0.8116307991314089,0.26373939971775134,-0.5212455994421734},
{0.8781729903593292,0.2828795968945195,-0.3857347957653649},
{0.6584762162359956,0.285578407041484,-0.6963146171689741},
{0.805103638892867,0.05788320279621604,-0.5903030285163003},
{0.5318711315236598,0.029638196184197482,-0.8463064910413299},
{0.7093948745765021,-0.16915061778228438,-0.6842126719291746},
{0.49312978975341404,-0.17586039634585315,-0.8519953822966608},
{0.24696039853257615,-0.14254739915299192,-0.9584835943047479},
{0.24873561433339514,0.08282940477304623,-0.965023255609486},
{0.1415759981503832,0.2561763966531886,-0.956205987507666},
{-0.1346994065193814,0.22201681074549848,-0.9656938467390812},
{-0.06281180579080405,0.3367674310475743,-0.9394904866143753},
{0.2197999867963822,0.36841937786865814,-0.9033023457376722},
{-0.23926000687108331,0.3724238106952895,-0.896691225751233},
{-0.4616187861055148,0.36118858912841145,-0.8102165756129028},
{-0.40889679065094303,0.8850163797648971,0.22259699491052007},
{-0.7578721243531342,0.6515571349649452,-0.03321359668479099},
{-0.7930020984442382,0.6008292745876718,0.10075641250802272},
{-0.3236933566716143,0.743049900538111,0.5857469215941012},
{0.3134891714313256,0.895886318356719,0.31482097130995695},
{0.28086958274484514,0.6077129626653012,0.7428305543643846},
{0.5655681573031576,0.4130997688135629,0.7137795461141289},
{0.633894838687161,0.6731092410804506,0.3809216232479826},
{0.602289265397102,0.21664762352379088,0.7683172834245713},
{0.8855258330076926,0.37618801402228813,0.27262901016215935},
{0.9866885363275304,0.11287979271570014,0.11706359244571336},
{0.9882949443014296,0.15234082224335818,0.008085601180582594},
{0.9352396971701938,0.01171500121717346,0.35382123676156846},
{0.7412036184359727,-0.09124220226946916,0.6650504165418126},
{0.9265018590261197,0.02193660139754977,0.3756502239321431},
{0.781054396018419,-0.03719979981036658,0.6233539968223283},
{0.8564480844984569,-0.013658201347538701,0.5160524509145114},
{0.7290314687462274,-0.06293580593472217,0.6815806642717102},
{0.5113919703025281,0.7762227549233177,-0.3687227785875904},
{0.254280414879285,0.915026653543024,-0.31315761832449995},
{0.3487777601296749,0.5939291321053396,-0.7249843171238429},
{0.47221277307185006,0.37888717839378494,-0.7959017546133376},
{0.7933472471144034,0.4462338265004266,-0.4140960245918634},
{-0.7510032577466252,0.6491668499161547,-0.12073320928349554},
{-0.35086536491328285,0.9183401081655163,-0.18315278168462754},
{-0.30255377526934013,0.8022229344265247,-0.5146839579298791},
{-0.8153043542986376,0.5361629699457288,-0.21865058774368162},
{-0.44319603503454164,0.5779508456868775,-0.6852372541678426},
{0.04569800113255917,0.562481813940302,-0.8255458204599647},
{0.26660758422979397,0.7490539556924262,-0.6064969641248686},
{0.20580562592643123,0.46550225864179967,-0.8607855084377367},
{0.21830939801259422,0.3127271971530505,-0.924414791584479},
{0.0705597996063624,0.2295265987195216,-0.9707413945844474},
{0.5668281373910469,0.2980813670754483,-0.7680191151685148},
{0.9434696978859486,0.24860622579315084,-0.21922562274488314},
{0.6243106058077493,0.24092260224122103,-0.743096606912775},
{0.9686722409897542,0.15943060674637005,-0.19041000805727581},
{0.9827004640572728,0.1433114093417459,-0.11731000764684606},
{0.9685386061722642,0.1054166006717947,0.22543360143663424},
{0.649815629096899,0.14005340627119392,-0.7470774334520065},
{0.9902948777624528,0.13883621090205003,0.006368800500107149},
{0.6322292349271005,-0.0991342054766059,-0.7684130424504879},
{0.30129299079246824,-0.1313133959870548,-0.9444465711376566},
{0.23414760141257973,0.08834860053299474,-0.9681784058408849},
{0.18604159995168126,0.22451019994169022,-0.9565477997515655},
{-0.1920297913972422,0.9665033567015396,0.17028159237154147},
{0.31422121385023666,0.841653637098393,0.43918581935842416},
{0.23396359912542064,0.9392209964890978,0.2512467990608143},
{-0.31855080265636965,0.9204774076757875,-0.22637740188774305},
{-0.5667154376561793,0.8145896541265193,0.12360140821286393},
{-0.4651866008018793,0.8494678014642956,-0.2490098004292381},
{-0.5384619516923297,0.8176559266446723,-0.2037093817243807},
{-0.7539086130655681,0.6259630108482145,0.19947960345706933},
{-0.6189519979888269,0.6478557978949092,0.4440509985571362},
{-0.8074224475950841,0.4231956249460879,0.4110650242310261},
{0.9462189943338514,0.31868159809167085,0.05578219966596504},
{0.6837681834656787,0.6443013844200324,0.3425445917168677},
{0.7116968098759605,0.544506807555925,0.44384680615910244},
{0.9488342409906838,0.25140801086110287,0.19106960825441743},
{0.7266188591955919,0.42144523433395614,0.5425946442036573},
{0.38115781323687165,0.7361440255648544,0.5592948194232243},
{0.9882109067519237,0.06861720741240442,0.1368608147844505},
{0.9378576892354004,0.22879862176975976,-0.26091022482511855},
{0.9970316281916479,0.059101801671137745,-0.049344801395252894},
{0.96146144103281,-0.04196300179087773,0.2717186115962822},
{0.8744886008076427,-0.09687560008947044,0.47527340043894356},
{0.9634759509176901,0.1653972259076184,0.21061303299016693},
{0.8951066450304177,0.10816480544148162,0.43253262175955753},
{0.8704363016490871,0.11007901285496842,0.4798158560326398},
{0.9744630664047879,0.0672210045807755,0.2142500146000677},
{0.9835920939855733,0.05896220563403949,0.1704994162917997},
{0.9200891050806408,0.007162000817950818,0.39164364472845614},
{0.9900529222695436,-0.023051602846826565,0.1387942171408065},
{0.9481619227894421,-0.050446606532967134,0.3137580406324847},
{0.9983082864467528,-0.037631203258607956,0.04432220383800341},
{-0.12365681072828483,0.8650968750545452,0.48612384217539667},
{0.8207473864634134,-0.1127639981401834,0.5600517907630659},
{0.8146584172924448,-0.038953200826844794,0.5786314122823891},
{0.7879558815085875,0.02368840245040144,0.6152758636460337},
{0.7526424620507373,0.17386801433434734,0.6350584523566596},
{0.7528804091698424,0.1907828023236735,0.6298992076719708},
{0.8717829250624132,0.4004930574530961,0.28213444047385294},
{0.815714620268192,0.27956960694651084,0.5064094125828359},
{0.8547496485718681,0.09947200565258042,0.509419628948199},
{0.8922805111239793,0.2155468268440483,0.3967052494053892},
{0.9028685564773126,-0.12422799401160212,0.4115771801599636},
{0.8454828593450358,-0.14908261046421314,0.512770035991689},
{0.746214742368026,-0.03616700690019251,0.6647221268202993},
{0.5241766729879376,0.10538401467398738,0.8450639176692432},
{0.8976818510008802,-0.19736281121296712,0.39397362238321015},
{0.9793090438562411,-0.14779040661847428,-0.13824540619102205},
{0.975724871117388,-0.17332641263319415,0.13386160975673403},
{0.8233718532424203,-0.15787641020890159,0.5450998352482714},
{0.7628209107268044,-0.04824740700332296,0.6448072935966097},
{0.8846852704025313,-0.15636121244309759,0.4391846349499546},
{0.8473967917625406,-0.11647799886772904,0.5180265949643154},
{0.9462047383978573,-0.09406181375807258,0.3095948452832896},
{0.8898717282211104,-0.2998174432005246,0.34385724954619523},
{-0.578951497947729,-0.014014202370940055,-0.8152415379235697},
{-0.8574524356795571,-0.17813040741220593,-0.482747220087653},
{-0.9046092607686489,-0.1633122109707725,-0.3937146264484424},
{-0.5623682364889155,-0.0011920000773421886,-0.8268860536519907},
{-0.9102484231241514,-0.05320220135156044,-0.41063041043174536},
{-0.9845512644312027,-0.15198500994623373,-0.08694460568984645},
{-0.9832919002957594,-0.1628436166100465,-0.08135720829843406},
{-0.9505224998115404,-0.25793422708490593,-0.1731384181807503},
{-0.9693065782338334,-0.14790179667880604,-0.19639199558993925},
{-0.9863938539473214,-0.04424300241971446,-0.15833420865952927},
{-0.5360640547649821,0.12867921314603123,-0.8343122852343986},
{-0.33202501332051176,0.18151600728224085,-0.9256410371357935},
{-0.3525200283754945,0.07711800620748152,-0.9326212750697486},
{-0.3885252472270106,0.05617880682878943,-0.9197239117966239},
{-0.38431020789058806,0.1423104029218916,-0.9121696187285026},
{-0.3843096487968445,0.14231641807030385,-0.9121689158205757},
{-0.7624790284421,0.09026440336705548,-0.6406856238989453},
{-0.6600037775818105,-0.041859798578158296,-0.7500951745216977},
{-0.9380127310587353,-0.10967061532313119,-0.3287924459387391},
{-0.8814890611152254,-0.14767921023886582,-0.44851743109652187},
{-0.5896894028696881,-0.0642850003128391,-0.8050676039178132},
{-0.4194555767734534,0.010922599395182047,-0.9077101497372946},
{-0.36348182714082555,-0.03684300275103027,-0.930872469507319},
{-0.3634803763559149,-0.036860597602249905,-0.9308723394475569},
{-0.9858644825373469,-0.11937580999423636,-0.11756120984231662},
{-0.889410516858268,-0.2825290371210519,-0.3593414472133153},
{-0.99810872402909,0.04186220520196958,-0.04501700559399804},
{-0.8507692702714857,-0.08948780739147663,-0.5178644427743515},
{-0.4328812564345253,0.1297624169170651,-0.8920625162977697},
{0.9015887014781596,-0.14132381590667756,-0.4088586460190139},
{0.8533206647781852,-0.15730461194147488,-0.49709063773567286},
{0.5653717898173036,-8.339999849791433e-05,-0.8248361851441891},
{0.5482886472225023,0.012329201061878133,-0.8361982720193185},
{0.3348534161304654,0.08548580411799832,-0.9383844452035939},
{0.37156817535268727,0.06543639565939331,-0.9260967385690233},
{0.3653850161535039,0.15144260669520815,-0.9184546406044581},
{0.3653847875197055,0.15144359482720482,-0.9184545686287335},
{0.9854624747837345,-0.1388750105388,-0.0978644074266307},
{0.9534814685888636,-0.23475881688741837,-0.18910681360343318},
{0.986363348764462,-0.12798979335171373,-0.10346959462538795},
{0.9042618891085391,-0.031112203065885004,-0.4258432419638046},
{0.5187104200434481,0.14151940546844013,-0.8431558325803177},
{0.3119432184746131,0.18935541121443825,-0.9310402551401905},
{0.9691906730328813,-0.1243042093668819,-0.2126450160237595},
{0.984385646506533,-0.02025180095678056,-0.1748564082609548},
{0.7492069909415331,0.10866719868613317,-0.6533607921003846},
{0.8771796386996928,-0.1262688055707677,-0.46326242043836013},
{0.9347599300284172,-0.08687079349727483,-0.3444957742127216},
{0.6481583825774899,-0.025935199302861336,-0.7610637795425906},
{0.5774998132483772,-0.05007540114877579,-0.8148536186934919},
{0.4037892142655744,0.02094600074000672,-0.9146122323125739},
{0.414576583787187,0.140077794521989,-0.8991687648362796},
{0.8898773444924073,-0.2608665837280091,-0.3742551766552053},
{0.9863689655214734,-0.09536579666648863,-0.13409559531268855},
{0.9958988452057418,0.06613740300210245,-0.06173600280231453},
{0.8438923954920281,-0.0688577996321699,-0.5320753971577171},
{0.34861460705694286,-0.028173800570317178,-0.9368426189643366},
{0.3486135537058174,-0.028191596256293278,-0.9368424755918805},
{0.1375633849871391,0.5337985417443584,0.8343473089442289},
{-0.3066520111365893,0.6058702220032075,0.7340884266596696},
{-0.29992559266758717,0.4780263883134787,0.8255515798173776},
{0.04677859854255291,0.40322338743705943,0.913905171526115},
{-0.37153680144435675,-0.00881240003425838,0.9283764036090818},
{-0.6442428463905633,0.29387462116128926,0.7061082508453601},
{-0.6970721037418334,0.3788726563857652,0.6087248905935495},
{-0.7504395644853883,-0.017438999174697985,0.6607089687318959},
{-0.8380293144083396,-0.009604201311172181,0.5455406744775888},
{-0.6241154416106016,-0.344924822996594,0.701075446741627},
{-0.6777297919142906,-0.41817839501088927,0.6048215927841276},
{-0.3279474002666212,-0.5461470004440175,0.7708268006266822},
{-0.32999336923953093,-0.6662197378980502,0.6687717376601645},
{0.028177401437342247,-0.3867604197288274,0.9217496470188747},
{0.10496340129742952,-0.5434748067177726,0.8328372102945176},
{0.16359059156466077,0.05215419731073564,0.9851487492020671},
{0.3692194038524501,0.04952700051676671,0.9280216096830146},
{-0.37432420211612205,-0.882729204990227,0.2840256016056478},
{-0.6027386466262964,-0.7334070567344652,-0.3143568243178276},
{-0.417802771704726,-0.908219538491742,-0.024043998371644306},
{-0.15376320946986738,-0.8873558546498884,0.4346912267714772},
{-0.0010313999107525156,-0.7452625355121076,0.6667703423040713},
{-0.09670520901921174,-0.6908010644275643,0.7165486668289145},
{-0.1557130032407333,-0.6180016128619856,0.7706020160379389},
{-0.3161491940877193,-0.8799917835433443,0.3544913933706849},
{-0.13523239794567654,-0.9540643855067508,0.2673449959387461},
{-0.1941435909645031,-0.6753641685683632,0.7114713668879241},
{-0.26187957551410895,-0.7638429285802465,0.5898839448455115},
{-0.013788800689274312,-0.9683046484035945,0.24939121246656323},
{0.11809360355799736,-0.9553506287833966,0.27084880816030094},
{-0.28745437112462924,-0.8119721184357647,0.5080071489696584},
{-0.15639360704241054,-0.9398614423219993,0.3036470136732375},
{0.24465197907615016,-0.9660203173811546,0.08336759286999025},
{0.5383715233929464,-0.8413692802781745,0.04747459324464881},
{0.5784226397948543,-0.8146724560485871,-0.04166580286656233},
{0.3150208000639051,-0.9303240001887255,-0.18777420003809187},
{0.00905059957944779,-0.9306201567570789,-0.36587458299898656},
{-0.38316360777192976,-0.8302042168395137,-0.4049032082128867},
{0.0037693996808393637,0.9853793165664785,0.1703331855776377},
{-0.1065109874075092,0.9673664856310146,0.22990757281868218},
{-0.1266722015549114,0.7629068093647422,0.6339774077821235},
{0.06466760169325005,0.8066680211217151,0.5874562153818951},
{0.11576879374565824,0.5228913717510977,0.8445011543763162},
{-0.07756980251809735,0.481711815637493,0.8728898283360468},
{-0.2941635555300926,0.7477138869650347,0.5953081100048391},
{-0.3235249708798357,0.8964009193158352,0.30298017272905275},
{0.19453378147175535,0.7547937281101579,0.6264527403339125},
{-0.10094760510419169,0.5937438300213395,0.7982968403641085},
{-0.1414195978777331,0.6970987895387223,0.7028895894518203},
{0.10368420638811271,0.8672492534323034,0.4869582300021013},
{-0.07333839899992241,0.9242503873964782,0.3746767948907274},
{-0.23513721341481827,0.7306226416827681,0.6410156365705969},
{-0.3475805646887778,0.501294149072788,0.7923963194992892},
{-0.5138696127164025,0.3776726093460224,0.7702606190611467},
{-0.06368599478362685,0.5302157565712488,0.8454675307497019},
{0.3890661853029239,0.6399661758251117,0.6626241749692},
{-0.27497476954005656,0.8000739113729375,0.5331703409388052},
{-0.07028399150966622,0.9963162796446021,0.04913279406473918},
{-0.3235959764398515,0.4465427674884279,0.8341973392643462},
{-0.29719439448957613,0.5694713894411577,0.7664057857897025},
{-0.24899182588824917,0.4943606513998067,0.8328328865915386},
{-0.7236106152297025,0.3502738073721498,0.5947234125170366},
{-0.9130473618242306,0.127627194663731,0.38737038380351},
{-0.6360556530927761,0.00043280003612664286,0.7716430644105154},
{-0.45539796240416736,-0.06890959431109976,0.8876171267218834},
{-0.8929961194961712,0.07442079329094643,0.44386875998511766},
{-0.9668143620481864,0.16456999353988733,0.19541419232911375},
{-0.9671608906806999,0.16425761540074216,0.19395681818533003},
{-0.20143521717051593,-0.15585441328516791,0.967022882429885},
{0.17844442223324133,-0.12659061577252836,0.9757727215761756},
{-0.13650818910410514,0.5304621576592443,0.8366453332201267},
{-0.04125080334307909,0.40215223259152816,0.9146430741252022},
{0.3020085717456679,0.4853535545928765,0.8205015232381969},
{0.30407877432437996,0.6133009482144647,0.7289705384476256},
{0.6486469837940223,0.3096109922645924,0.6952683826292202},
{0.3871536481981157,0.00042520005293464607,0.9220151147848958},
{-0.14827099326462126,0.04835779780329196,0.9877637551297064},
{-0.35470198667769154,0.04071339847083898,0.9340925649162685},
{-0.07772760138421356,-0.5456978097180705,0.8343694148588845},
{-0.0032982001722904612,-0.38714142022338566,0.9220144481639337},
{0.35728039326348543,-0.6578485875962782,0.6630127874989072},
{0.35402604103297997,-0.5378396623376858,0.7651104886792488},
{0.6977523657161616,-0.40143058027583745,0.5932917708487995},
{0.6439935321650995,-0.3294849652937821,0.6904433272723217},
{0.8470419963864511,0.010909599953458773,0.5314139977329453},
{0.7616110754808707,0.0009694000960741849,0.6480336642245719},
{0.697744816694117,0.39585160947107445,0.5970374142846099},
{0.4003816382307308,-0.8733102833886652,0.27753142650028934},
{0.18258479722292542,-0.8832633865657583,0.4318663934314072},
{0.43932514228155445,-0.8977848820492094,-0.03123659589614254},
{0.6150379815783089,-0.718588178476761,-0.32459099027781185},
{0.3433657604746614,-0.8719682996264443,0.3489573598310042},
{0.39639657041554555,-0.820698138748444,-0.41149036928904287},
{0.007464999519992931,-0.9306301401595346,-0.36588497647322354},
{0.16288341238560955,-0.9504310722705155,0.2648580201397305},
{0.04153520096159308,-0.9676296224018646,0.2489332057631224},
{-0.2954191689441678,-0.9377339014210664,-0.18270918079276413},
{-0.5590430485352587,-0.8285152719304232,-0.03214520279079713},
{-0.09024358677986419,-0.9578906596748527,0.2725831600682273},
{-0.5168644109346079,-0.8542124180714277,0.05632340119155874},
{-0.21963380014145736,-0.9716720006258152,0.08726120005620146},
{0.1842847990075858,-0.9357187949609485,0.300781398380226},
{0.315589204718532,-0.8046430120306202,0.5029444075197733},
{0.29025497988251514,-0.7571095475249663,0.585266759435338},
{0.22242702552835159,-0.670294676930931,0.7079768812557857},
{0.18360119098629804,-0.6138575698633263,0.7677691623072032},
{0.12548819057145771,-0.6880939483001319,0.7146883463019645},
{0.030347803214921414,-0.7448796789094885,0.6665082706071439},
{-0.024919201320081266,0.9850262521812351,0.17059400903712574},
{-0.0744270008300903,0.8049728089779262,0.5886250065649818},
{0.11867560093674451,0.7658830060453597,0.6319330049880495},
{0.0867802017201971,0.9697052192219432,0.22834400452634},
{0.30665038326940086,0.9040667506748427,0.2977059837574001},
{0.2858242028166546,0.7547694074378751,0.59044700581856},
{0.08044720788003931,0.48363544737350667,0.8715646853723101},
{-0.1142897980839704,0.5200891912808816,0.8464307858098759},
{-0.20229259674992672,0.7499579879510252,0.6297941898816007},
{-0.11658560812344296,0.8645676602412784,0.4888052340589332},
{0.1361839928982201,0.7004771634712236,0.7005609634668535},
{0.09986559205914981,0.5961743525949718,0.7966197366564814},
{0.34852840243350897,0.5097660035593087,0.786553605491906},
{0.22799099637252193,0.7362629882855996,0.6371317898628382},
{0.05708260197253044,0.9258348319928897,0.373592612909762},
{0.2643226203515421,0.8066282621064099,0.5286628407044394},
{0.04685199908248607,0.997738180461054,0.04820179905605261},
{0.5173800477939567,0.3902020360456483,0.7616168703557935},
{0.06491899557619778,0.5317477637648901,0.8444109424589525},
{0.7247354163235638,0.36786620828562727,0.5826088131223781},
{0.2960523967213974,0.5766951936134468,0.7614299915676198},
{0.3265628077982677,0.454479210852891,0.8287372197901124},
{0.25082062005933475,0.5004474400231955,0.8286382662701988},
{-0.393363788352105,0.6304233813325335,0.6692019801842604},
{0.9160375245993226,0.1498908203881328,0.3720322506037856},
{0.8982375048504437,0.09622321123204758,0.4288478500590179},
{0.47176137910733074,-0.057625797447954034,0.8798411610348978},
{0.6487136817347503,0.016069002024615642,0.7608628958650027},
{0.22136600891668945,-0.15070940607062022,0.9634748388090564},
{-0.1589377997901576,-0.1306965998274439,0.9785995987079745},
{0.9656626126552211,0.1880938024650107,0.1792106023485944},
{0.9659917064102906,0.18779022068631834,0.17774941958025856},
{-0.8775948813688109,-0.2887098267685874,0.38271903548492986},
{-0.9002321692987526,-0.2732615906807689,0.3389839884393919},
{-0.8593553973697194,-0.2036459993766885,0.469080598564257},
{-0.869327091949253,-0.2694482284997023,0.4143284438237705},
{-0.9008002958534258,-0.2952056314125908,0.3184532338863493},
{-0.7339028236589579,-0.20631440665099476,0.6471638208627369},
{-0.7221718032474478,-0.05399360024279734,0.6896032031009939},
{-0.8401644093398389,-0.1778818019774551,0.5123298056954066},
{-0.7937020118347797,-0.16057420239429948,0.586730808748661},
{-0.8181957890911921,-0.09440679874129683,0.5671357924385146},
{-0.8791062669759795,-0.2182708166292771,0.42370983228094494},
{-0.18409261351224,-0.9129986670133194,-0.3640650267220608},
{-0.18409261351224,-0.9129986670133194,-0.3640650267220608},
{-0.18409261351224,-0.9129986670133194,-0.3640650267220608},
{-0.3539115830709654,-0.9260551557030047,-0.13102839373237748},
{-0.3539115830709654,-0.9260551557030047,-0.13102839373237748},
{-0.3539115830709654,-0.9260551557030047,-0.13102839373237748},
{-0.8307360514545797,0.09782560605917541,-0.5480034339425337},
{-0.8978470892124255,0.16249961614638517,-0.4092242406615865},
{-0.9992447765096306,0.00023720004189973546,0.038856406863713666},
{-0.9707703651643137,-0.23103319170947106,-0.06502739766651919},
{-0.9574512368269072,-0.11131740428165485,0.26626221024137137},
{-0.9843425375009681,0.10193981423978199,0.1437986200869603},
{-0.8977762320840273,0.2753426098399796,-0.3437794122857207},
{-0.6736772564808341,0.29421362466675366,-0.6779360568378902},
{-0.5771688335129862,0.26047421512428987,-0.773969844940127},
{-0.5848114492660859,0.18973121598346682,-0.7886682664395313},
{-0.7564971141844575,0.1502520226787986,-0.6365032960727837},
{-0.9085872373756998,-0.3164310130167254,-0.2726548112159449},
{-0.8308320258118743,-0.5537312172030449,-0.05567660172973284},
{-0.8585395913383659,-0.49396879501644775,0.13749399861285058},
{-0.9431416423003941,-0.22231140997078255,0.24710621108284228},
{-0.9263250514003148,-0.22908901271178772,0.2990654165946679},
{-0.6374324727108044,-0.19125402181601092,0.746392485139682},
{-0.9071950993681691,0.01623920177873508,0.42039664604747656},
{0.010916400191750282,-0.22581940396659464,0.9741080171105386},
{0.012333200246707914,-0.3750142075016193,0.9269370185420405},
{-0.5903306621732862,-0.3485208367060143,0.7280404766768047},
{-0.7823621897122814,-0.38341479495826414,0.4908181935459567},
{-0.5262541448067418,-0.5020155473488732,0.6863213280189798},
{0.01368459962957623,-0.5478259851710848,0.8364803773575973},
{0.549749809486197,-0.48891700843649777,0.6773000116871369},
{0.6107560483648207,-0.3338986264409124,0.7179754568553587},
{0.6543220302228997,-0.1755286081076034,0.735562633975374},
{0.9365088805893647,-0.20641401776253798,0.2834508243917835},
{0.9642058954122086,-0.08792300870034966,0.25015302475368867},
{0.9134516089160002,0.038408200374893994,0.40513080395439266},
{0.9838413780777713,0.12590239719460758,0.1272977971635149},
{0.9994537447626098,0.02456860355855905,0.02210420320161104},
{0.8866406036204373,0.18422380075224473,-0.4241816017320692},
{0.8849175382172897,0.297045779261013,-0.35872657495461546},
{0.6548579727036604,0.31038778706215575,-0.6890721712775155},
{0.6693054298875001,0.3585310160100237,-0.6507578290592662},
{-0.7326808257453349,-0.6665458234214475,-0.1374608048301721},
{-0.6886506242182865,0.3419996120273536,-0.6393720224852694},
{-0.2687983990298206,0.4023881985476523,-0.8751177968414198},
{-0.2687983990298206,0.4023881985476523,-0.8751177968414198},
{-0.2687983990298206,0.4023881985476523,-0.8751177968414198},
{-0.23854258947009102,0.38072678319369985,-0.8933893605634002},
{-0.23854258947009102,0.38072678319369985,-0.8933893605634002},
{-0.23854258947009102,0.38072678319369985,-0.8933893605634002},
{-0.31839422092172953,0.28854321896021595,-0.902977259334764},
{-0.31839422092172953,0.28854321896021595,-0.902977259334764},
{-0.31839422092172953,0.28854321896021595,-0.902977259334764},
{-0.24140198514764674,0.3418773789658581,-0.9082097441220339},
{-0.24140198514764674,0.3418773789658581,-0.9082097441220339},
{-0.24140198514764674,0.3418773789658581,-0.9082097441220339},
{0.01475899840683528,-0.8530191079205843,0.5216709436880661},
{-0.2513008145535694,-0.7874312456024597,0.5628498325962895},
{-0.20007462437039522,-0.3770786459306405,0.9043129101512153},
{0.013082999467991614,-0.4648431810975708,0.8852963640002209},
{0.005588800333995213,0.21399641278875128,0.9768184583761576},
{-0.1503490014348497,0.24944580238057604,0.9566462091297149},
{-0.4756771747510943,0.10155399460952225,0.8737379536220605},
{-0.43500336291674785,-0.2783449762715928,0.8563271269996569},
{-0.4480609993534839,-0.728312798949103,0.5184609992519024},
{-0.3622986098451171,-0.8791450238899223,0.3095864084127136},
{0.014179999260817928,-0.9500201504768758,0.3118663837428736},
{0.2797971919298601,-0.7809655774747507,0.5583961838942795},
{0.22432880045118359,-0.3719148007480174,0.9007530018116485},
{0.16025080525773605,0.2532284083082773,0.9540414313015464},
{0.2800976062083467,0.16265060360514091,0.9460920209700732},
{0.005439000458385598,0.22437941891014623,0.9744866821273438},
{-0.2680717795728722,0.1559721881148854,0.9506893275572669},
{-0.5507677646457888,-0.09918339363334082,0.8287445468022429},
{-0.5563206072572358,-0.18667340243516575,0.8097286105629584},
{-0.4830646007222492,-0.17091660025554425,0.858741001283938},
{-0.5925363591796383,-0.5779177601867268,0.5611699613404977},
{-0.4792383689456902,-0.8120297473810425,0.33307397841704006},
{-0.42410296985874,-0.8482389397151346,0.31721817745510816},
{-0.4224505946907508,-0.7927813900365297,0.4393553944782957},
{0.014779198615119397,-0.8295207222699966,0.5582803476864988},
{0.44893019514635535,-0.7821725915434785,0.4320505953288505},
{0.3887319720047994,-0.8700019373453164,0.30328877815813776},
{0.47428596766647535,-0.717085351114099,0.510726365182222},
{0.45594621108100675,-0.26749540650102654,0.8488576206300587},
{0.48764386983765856,0.1132808162234521,0.8656621239753426},
{0.5668365872398964,-0.08557579807359639,0.8193735815550159},
{0.36285760995007105,-0.6232078170892434,0.6927816189970559},
{0.012134799114578106,-0.35225037429786926,0.9358271317168892},
{-0.33591298777908934,-0.6317149770174642,0.698640574582632},
{-0.37664919466166064,-0.7219089897682107,0.5805021917724033},
{-0.559077429340183,-0.4037936211909445,0.724143038002767},
{-0.5469216185197617,-0.3386806114683421,0.7656188259252473},
{-0.49540164340922416,-0.2549040223357875,0.8304222727651736},
{-0.41820702691000045,-0.16104261036246745,0.8939620575229916},
{-0.6667422265565836,-0.3095040123276565,0.6779838270043405},
{-0.6461269444672654,-0.4458193616831204,0.619487746756827},
{-0.7648098518234255,-0.5516892373823978,0.33272342254529996},
{-0.46423640212579415,-0.8281848037923576,0.3139976014378327},
{-0.5438805562541114,-0.7610779387842967,0.3534887715678741},
{-0.5933540751958617,-0.3266512413965667,0.7356832932332673},
{0.012395999650479425,-0.38173478923651444,0.9241887739413519},
{0.6133780646467392,-0.3119602328789257,0.725567476470898},
{0.5680931565416819,-0.7475433428139979,0.34416437367191516},
{0.4498836290557351,-0.8375998540963883,0.309889020014183},
{0.5043776132488199,-0.8000576210156419,0.3248246085323825},
{0.6157516116305505,-0.5632102106381285,0.5510392104082381},
{0.5014112461699096,-0.1589324146344847,0.8504864783127305},
{0.574196688491583,-0.17291102664796015,0.8002499233294862},
{0.5808049675512057,-0.3899163782158951,0.7145843600771306},
{0.40378903738975214,-0.7124086659670793,0.5739584531469711},
{0.19773799025192462,-0.9255477543724033,0.32289478408195266},
{0.2517449658397914,-0.9255986744020811,0.28265096164604214},
{0.014780399220924879,-0.8236431565857538,0.5669157701178592},
{-0.2243597828613498,-0.9313959288514688,0.28664317810357504},
{-0.16971058991024748,-0.9300189447078643,0.32598018061959866},
{-0.25340878395344174,-0.8432517466029232,0.4740363699826812},
{-0.3880217788367496,-0.6359565653140395,0.6670819636164168},
{-0.5242392058741527,-0.4082530045745158,0.7473304083739121},
{-0.6526851473878748,-0.44342876425576744,0.6143069504814928},
{-0.5836099851164865,-0.3418977912807517,0.7365495812161446},
{-0.5931372613671586,-0.22326542309948394,0.7735248800304197},
{-0.4801716715617854,-0.07518861120564078,0.87394613024747},
{-0.48416921431718407,0.05515260163089664,0.8732344258220837},
{-0.6459961322727613,-0.09267479028383092,0.7576941205621706},
{-0.9359590559532251,-0.09640380576318355,0.3386546202453495},
{-0.15288180026218007,-0.6650316011404761,0.7309994012536055},
{-0.20565320285918415,-0.3916638054452784,0.8968312124685905},
{-0.03559539923500504,-0.5041007891661684,0.8629109814548352},
{-0.049237395012750415,-0.9278899060141474,0.3695889625643802},
{0.21280180102211685,-0.9617462046194017,0.17250980082858874},
{0.09010099292540548,-0.9844963226988286,0.15049518818334406},
{0.052644794845047214,-0.9960203024701748,0.07191719295790333},
{-0.09105698876549687,0.9948138772610453,-0.04532079440837421},
{0.047279994826633656,-0.9762968931738146,0.21120837688962715},
{-0.4859588235059649,-0.3083666149157799,0.8177738395559506},
{-0.6496160388262525,-0.19965681193308868,0.7335776438444699},
{-0.6645659712914418,0.2710595882905079,0.6963323699191665},
{-0.6836074011021666,-0.10697120017246753,0.7219682011640149},
{-0.6590672286672106,-0.5580552242735277,0.5041872219304505},
{-0.5662998196355066,-0.5109568177165799,0.6467052224234304},
{-0.49596382414634654,-0.40721541982556825,0.7669390373389647},
{-0.4936760014259633,-0.4376568012641541,0.7514922021706552},
{-0.2798378114130119,-0.7560516308350976,0.5916728241310097},
{-0.3909034356547027,-0.220850420143993,0.8935432815009979},
{0.011567000386997135,-0.29097400973511756,0.9566610320070086},
{0.014667398370432771,-0.7459797171206735,0.6658071260279536},
{0.30804319539638075,-0.7488927888080071,0.5867443912312695},
{0.4110926210005355,-0.2110852107832207,0.8868178453028069},
{0.01106619967124933,-0.24027099286211595,0.9706427711644945},
{-0.43083981653368514,-0.23003600882774242,0.8726170334870982},
{-0.5367000540190241,-0.2504052252033623,0.8057606811000583},
{-0.26712877704622356,-0.7552567351024834,0.5985227485702832},
{0.01408119952660782,-0.6116349794376029,0.7910147734070805},
{0.2954331850282679,-0.7484077620727762,0.5938055699075853},
{0.5893330435283994,-0.4968856367001931,0.6370174470503907},
{0.556070000583462,-0.23710020024877976,0.7965988008358393},
{0.4508839849273094,-0.21930159266892335,0.8652227710762954},
{0.014200198567798998,-0.6331577361410942,0.7738925219468912},
{-0.46129758770257223,-0.5908045842501307,0.6619323823539818},
{-0.6332214380210098,-0.21697221302783223,0.7429358446086778},
{-0.6529570539380942,-0.3897830321983717,0.6493968536440007},
{-0.9320977690998222,0.16357559457726956,0.32316678928662684},
{-0.6700940781033157,-0.09560341114312698,0.7360936857959491},
{-0.8803237578690265,0.346881983398749,0.32357838451402426},
{-0.9071864816693941,0.1023014092096766,0.40810183673933687},
{-0.8182663637190614,-0.40666848136639244,0.4062768812880409},
{-0.7848762210254843,-0.2874066076991288,0.5489688147059305},
{-0.8075785185895803,0.2523709745589729,0.533034546265824},
{-0.6417914664944513,0.32195243335670776,0.6960246721134217},
{0.0031430004819798527,0.37908005813201484,0.925358541903947},
{0.6453422017909924,0.33762080093698554,0.6852340019017025},
{0.8100170470799741,0.2720672158131456,0.519472630192893},
{0.8007306184147225,-0.26810400616569513,0.5356778123191971},
{0.8346200401338073,-0.3865480185876722,0.3924156188698235},
{0.4894575893379202,-0.8165745822121804,0.3060019933342179},
{0.7834832092720381,-0.5328400063058312,0.31974300378396026},
{0.6670795709641483,-0.4298381812905113,0.6084767735149417},
{0.6853522485594291,-0.2930422207629916,0.6666472472341191},
{0.43693434873150716,-0.15063058232548449,0.8867912959467177},
{0.5153114201290023,-0.2425976094763043,0.8219492321068336},
{0.5677593886742109,-0.3251141935145506,0.7562737849136844},
{0.4145165357664313,-0.6261861029660712,0.6603536976714537},
{0.2817755728894492,-0.836734719495012,0.4695503548230224},
{-0.0199637967208708,-0.9770952395084073,0.21186396520054152},
{0.07800119716029472,-0.9263403662757272,0.3685231865835746},
{-0.06328939884096606,-0.9863595819365604,0.15195139721727763},
{-0.10867238870532715,-0.9885324972586201,0.10485138910245599},
{-0.182520787855487,-0.9738123352047692,0.1355569909803499},
{-0.360624574829711,-0.13680139045175851,0.9226241356041774},
{-0.5253698861894797,0.054168808886656,0.8491479393068408},
{-0.4559271886198204,-0.2900685927597372,0.8414217789976751},
{-0.3071686089399766,-0.4521424131593609,0.8373856243716568},
{-0.26500798647295387,-0.7610271611541914,0.5921219697757742},
{-0.4638265712533844,-0.5200917677662319,0.7171955555503151},
{-0.6455588814284139,-0.19528362463235543,0.7383210931290968},
{-0.7130013738343046,0.01637599939903424,0.7009713742757809},
{-0.5667881687531732,0.13710499244145136,0.8123751552140513},
{-0.40661584712948745,0.1030370119426766,0.9077703052166302},
{-0.20641420635892413,-0.04424960136318068,0.977463630112351},
{-0.31255719752564093,-0.39511399687208004,0.8638245931615327},
{-0.3418469748578533,-0.5594265588553194,0.755104344463618},
{-0.26396760638913014,-0.6734648163006908,0.6904826167125934},
{-0.10115840019934476,-0.9885916019481383,0.1115958002199129},
{-0.07512539039346602,-0.9435584793440336,0.32257335875146986},
{-0.14729059776859754,-0.8680629868491411,0.47410139281752517},
{-0.6781932219178354,-0.32157421039262907,0.660790421355412},
{-0.7781898999747165,-0.1641688210909077,0.6061922778780361},
{-0.8670035995847225,0.013245599993655622,0.4981257997614077},
{-0.780155802871067,0.0845186003110386,0.6198496022811208},
{-0.7190784459945024,0.10227760654199503,0.6873612439657711},
{-0.3731411865685295,0.20270239270358967,0.9053603674109385},
{0.006653000454275137,0.13583840927521534,0.9907086676468186},
{0.008573000907761164,-0.015590601650827155,0.9998417058692844},
{-0.2322469945083666,-0.20968259504191672,0.9497865775416698},
{-0.4098718181657571,-0.16174780716875678,0.8976874397860289},
{-0.649161661822667,-0.3000532285754566,0.6989686665660184},
{-0.6980322404031404,-0.272485215771848,0.6621954383288531},
{-0.5299818339806344,-0.2252866144446122,0.8175360524176336},
{-0.30042660642617924,-0.5246898112232097,0.796520217037711},
{-0.4442732122289758,-0.8270470227651313,0.34440460948001256},
{-0.5052677929940479,-0.8546253881499183,0.11966579834073561},
{-0.10458478311909285,-0.9899240402175219,0.09545898459207729},
{0.13200219843723654,-0.989114388289954,0.06502419923018371},
{0.39923356695121515,-0.9089133247596309,0.12037079003563661},
{0.43373840871469826,-0.8750796175821524,0.2147246043142597},
{0.3337037695400686,-0.9104777168930909,0.24427877770263481},
{-0.8087074006657603,0.1298574001069038,0.5736980004722912},
{-0.6794765630572136,0.24613438661780176,0.6911797624209167},
{-0.8346575995140957,0.34182599980100253,0.4318583997485893},
{-0.1407919975127883,-0.9869003825655561,-0.07877339860840019},
{-0.10538120390765945,-0.9923688367982081,-0.06402260237403368},
{-0.13082559585659123,-0.9875105687243163,-0.08779259721949963},
{-0.10813558398157869,-0.9911228531822472,-0.07734458854273349},
{-0.13176440550179386,-0.9848238411211037,-0.11296080471665364},
{0.011531800257010848,-0.9972898222267381,-0.07266380161946832},
{0.013319198257198475,-0.9879748707246427,0.15403977984407483},
{-0.895533424563927,-0.0815702022374201,0.43745421199909795},
{-0.8107932602316119,-0.07976800592574682,0.5798718430770919},
{-0.8293220556939871,-0.18087741214701117,0.5286854355044215},
{-0.9220918069331899,-0.10022140075356271,0.37376780281035266},
{-0.9138248849382725,-0.03353320311684699,0.4047216376181008},
{-0.8215493738398638,-0.1586935949468088,0.5476065825628705},
{-0.7231524439984907,-0.35349202150738135,0.5933750361024929},
{-0.7074271063480626,-0.060758809133918644,0.7041699058584051},
{-0.7922258449387747,-0.012593600714368242,0.6100980346076289},
{-0.8844093144809916,-0.06942720898689735,0.46151925974064456},
{-0.9426868699949552,-0.14621521085654998,0.29993762227051324},
{-0.9578482969887925,-0.0647112065524591,0.2798912283409308},
{-0.9629604078001142,-0.05216700042256,0.2645484021428791},
{-0.9524982908232881,0.006506000620364756,0.3044744290324603},
{-0.8983553203892154,0.07524221008326042,0.4327774579968053},
{-0.749496067112504,-0.2933434262669983,0.5934688531412806},
{-0.5814532174065931,-0.5954990178270732,0.5543402165949286},
{-0.5002581667839194,-0.7712843487883561,0.3935253738707503},
{0.07857380828123038,-0.9942195047850544,0.07316920771161636},
{0.07857380828123038,-0.9942195047850544,0.07316920771161636},
{0.07857380828123038,-0.9942195047850544,0.07316920771161636},
{0.1754624052227649,-0.9829258292574955,0.05540540164918171},
{0.1754624052227649,-0.9829258292574955,0.05540540164918171},
{0.1754624052227649,-0.9829258292574955,0.05540540164918171},
{-0.2666761899747942,-0.18499739304535984,0.9458645644419439},
{-0.08768080691636754,0.44051403474827705,0.8934536704767004},
{-0.5065878361361882,0.52470063742822,0.6841476488019775},
{-0.40229180658823643,0.8111982132847986,0.4244040069503627},
{-0.2561157687071319,0.9486472840918914,0.18566917731447344},
{-0.3643615770961664,0.7559661524798331,0.543834365814475},
{0.061094190750015195,0.8576308701501334,0.5106239226888274},
{0.0019012000502258656,0.45634981205584035,0.8897984235066771},
{0.008850600984204763,-0.038848604320043514,0.9992059111137219},
{0.15234079889371027,0.9856889928419856,0.07217679947585641},
{0.0550241971250397,0.9984593478314789,0.007160199625886596},
{0.0644688022816799,0.9974000352999827,0.03220160113967909},
{0.07174699838628806,0.731020383558109,0.6785731847377358},
{0.0013643998085201988,0.6132433139374639,0.7898928891464713},
{0.09189580450932909,0.44269942172327004,0.8919486437679388},
{0.2869201775273912,-0.17825778603821615,0.9412231262800569},
{-0.15101320415141045,0.9765516268457758,-0.15343380421795366},
{-0.1695951863035408,0.981041320771381,-0.0937837924260475},
{-0.16494520549128328,0.9802670326346192,-0.10894780362704239},
{-0.14406978684447547,0.9739531110648783,-0.17509778401119871},
{-0.1963717750749367,0.9665058773234078,0.16524077902632964},
{-0.1970684101918385,0.9663026499745268,0.16559960856435824},
{-0.6610720234440206,0.06784740240611589,0.7472486265001567},
{-0.6660820516822675,-0.7361124571160278,-0.12030440933459272},
{-0.8639666644609526,-0.4855784362292318,0.13332360994733625},
{-0.8444626878333455,-0.5211476542050498,-0.123644212860349},
{-0.6934053920038016,-0.6356975926692753,-0.3392307960880651},
{-0.7634658414897124,-0.6365960345951122,-0.10892840591959455},
{-0.7088842421986751,-0.6622924394251443,-0.2425940144412097},
{-0.7483181045287918,-0.6632628926478571,-0.0101168014131651},
{-0.6823051989375553,-0.7257731988698695,-0.08782299986324729},
{-0.7372211702404314,-0.673145972826969,0.05813299765333254},
{-0.5879633743095996,-0.8084065646775814,-0.027890798781342815},
{-0.3175043654816575,-0.9237550995714756,-0.21416697671626012},
{-0.2857736057590184,-0.9493932191325332,-0.1303302026264638},
{0.009334999377382074,-0.9598415359812976,-0.28038738129895857},
{0.009524599793423244,-0.9644093790831567,-0.26424199426891887},
{0.3362612071016888,-0.9157962193412132,-0.21964900463889034},
{0.3065750084541432,-0.9421818259817005,-0.1352966037309527},
{0.6069149733449017,-0.7938619651343771,-0.03791299833489906},
{0.6982019432578844,-0.7089669423830246,-0.09939779192204913},
{0.7542604136568656,-0.6549880118594096,0.04562820082615791},
{0.7639672381461534,-0.6448522321985433,-0.022796001138242206},
{0.720629608921092,-0.6448892079834575,-0.25457980315159107},
{0.7768024065606712,-0.6178450052181583,-0.12184240102904925},
{0.7028889774272973,-0.6187019801308936,-0.3509343887300301},
{0.8547070449568054,-0.500462826323885,-0.13788700725272993},
{0.6817184112007699,-0.7196870118246016,-0.13156980216171818},
{0.877650260578056,-0.46435903205145446,0.11874640819623361},
{0.6716628060317469,0.08406240075490726,0.7360724066101657},
{0.825335200563968,0.09223140006302356,0.5570594003806498},
{0.6318106600841226,0.338580032198387,0.6972652663087446},
{-0.30449383582812317,0.18167742137698784,0.9350277100195932},
{-0.062126999015423755,0.06310019900000068,0.9960715842144569},
{-0.44162447178428843,-0.011604201886216524,0.8971249458240654},
{-0.4626729956974836,0.1521253985853464,0.873379391878218},
{-0.6456299947504988,0.0031241999745976923,0.7636439937909483},
{-0.5413868443353832,-0.032041202623925964,0.8401628688028222},
{-0.3926235959467581,0.20916299784070996,0.8955989907543017},
{-0.17213200571405282,0.42640121415471255,0.8880048294779956},
{-0.4065815812558658,0.11200399483641658,0.9067229581984587},
{-0.5666129751104491,0.22489079012124497,0.7927003651791311},
{-0.4648653952419074,0.266052197276844,0.8444621913565749},
{-0.494717377367007,0.10472139520906538,0.862721360531068},
{-0.651973418625916,-0.1302966037223812,0.7469628213396227},
{-0.8114752452438847,-0.18288501019677236,0.5550324309458896},
{-0.8168504039269431,-0.08320540040000331,0.5708172027441581},
{-0.6808603761085825,-0.028703398992796596,0.7318505743193344},
{-0.5845876353273568,0.11264260680713262,0.8034730485548741},
{-0.460283643943834,0.1683200160697147,0.8716692832193165},
{-0.16779419546763388,0.8130311780388412,0.5575171849406472},
{-0.28702976560108057,0.8188909018604844,0.4970227404345916},
{-0.3647351806102552,0.8103297569219313,0.458621775619135},
{-0.08063939943731602,0.833451194184361,0.546677596185404},
{-0.5247267685089227,0.18079678914961844,0.831849950077159},
{-0.5037930491409639,-0.3128982305207082,0.8051628785371691},
{-0.7112373553236412,0.20277238726285698,0.6730711577210501},
{-0.6223504746291243,0.31166363737312863,0.7180150861007412},
{-0.7719033860853918,-0.2597699953172926,0.5802453895402878},
{-0.9092659201192552,-0.2467548325977319,0.3351828442795806},
{-0.6711964624940718,0.10016860932654538,0.7344804683863484},
{-0.21397456802940318,0.6612149012058525,0.7190338925669396},
{0.13390838870171048,0.8832707254755549,0.44933436208818756},
{0.0433636009625011,0.9659504214402937,0.2550674056614915},
{-0.1821683773012059,0.9605170803163329,0.21028937379723492},
{-0.37762663768238225,0.8861108884227061,0.2687110268139761},
{-0.2201657901929441,0.9316107585023686,0.28918578711852017},
{-0.6346381944210099,0.4905823956873785,0.5971291947507448},
{-0.7664046360373584,-0.605902628490342,0.21332121003064508},
{-0.5754043927815634,-0.5916827925773512,0.5646425929165699},
{-0.6237688467726227,0.5709540428123624,0.5337826400251056},
{-0.002607600261044163,0.703546470431309,0.7106444711418825},
{-0.0010344000116537162,0.6234336070237028,0.7818756088087357},
{-0.5927142066129125,0.4983660055602696,0.6327094070591389},
{0.0008674001012772601,0.5178686604661205,0.855459699883104},
{0.5909310244735506,0.5127756212367258,0.6227854257928084},
{0.6185465688520367,0.5860777704870582,0.523366973644967},
{-0.7677751696326346,0.4132307836557228,0.4896545806329767},
{-0.5708614626191787,0.40964824493530977,0.7115514780518079},
{0.005600400059514219,0.21298320226332562,0.9770398103827871},
{0.5725689596232286,0.42356817013055825,0.7019649504984022},
{0.7655890996766755,0.4318974562313421,0.4767996620774319},
{-0.7341185836691799,-0.30908979312414925,0.6045935865505256},
{-0.7838872726307181,-0.46713524328220307,0.4090298378984732},
{-0.8495999688583386,-0.3642577866483132,0.38143958601852296},
{-0.9359733847871007,-0.3368709945246472,0.10233159833674724},
{-0.9760637652595292,-0.19496479306073133,0.09637559656975934},
{-0.9812687091654827,-0.12668441409355571,0.14513021614563876},
{-0.9617668181277466,-0.0989384018648286,0.25537380481338257},
{-0.9573573817920201,-0.012704999758363611,0.288626794510607},
{-0.9193870236244589,0.025201800647582453,0.3925460100868153},
{0.010432199937079438,-0.17945759891762303,0.9837103940668688},
{0.00977180088790691,-0.11897561081062419,0.9928490902144425},
{-0.5591946507656276,0.15138941374365542,0.8150966739972997},
{-0.7215064037445461,0.17162320089070726,0.6708010034813902},
{-0.6943985002221955,0.34070704917408157,0.6338212914791167},
{0.5689242816731714,0.1651240237047409,0.8056421156557184},
{0.7282555023685964,0.18927362660560124,0.6586496925843256},
{0.696427393814903,0.35763819682375086,0.6221605944744799},
{0.8332114633575021,0.36213042753644215,0.4178758317753296},
{0.8769202059202988,0.36827380248630487,0.30884520208508814},
{0.9111416832981618,0.12443861137639489,0.392856035915584},
{-0.9547948544494125,-0.2909092165897793,0.061144203486891396},
{-0.9525605979709125,-0.24259939948322934,0.18377659960853013},
{-0.8178802649829942,0.0722268057386323,0.5708372453546993},
{-0.6280852073747253,0.323242403795383,0.7078300083110568},
{-0.705028432918159,-0.48939102284993163,0.5132556239641828},
{-0.7550694100802068,-0.5109734068215155,0.4108240054845169},
{-0.7478528518139995,-0.5609052388615805,0.3551076246031639},
{-0.6453481568082692,-0.49870496662277486,0.5786355612731962},
{-0.9479287255578887,-0.03809620504603241,0.3161958418817166},
{-0.9437324825275785,-0.17181061502450562,0.28257762471086617},
{-0.9482539687950864,-0.006631599781768909,0.3174435895536427},
{-0.935002379036424,0.023589999471091458,0.35385599206623736},
{-0.6493655309749282,0.1577269832342251,0.7439399209220324},
{-0.3215656313808648,0.330075432211317,0.8874940866085465},
{0.0034229999371396874,0.3610783933691204,0.932529182874941},
{0.005430599279652558,0.2249755701578835,0.9743492707564362},
{0.3832222018796436,0.21191020103938563,0.8990188044095434},
{0.22378841200715724,-0.039012402093173824,0.9738566522513648},
{0.2531734191165078,-0.20377241538635843,0.9457166714087609},
{0.42868004340878646,-0.1515402153451903,0.8906564901892167},
{0.6679014246913276,-0.2840186104997479,0.687925225431578},
{0.7154629689092712,-0.25527678890684524,0.6503433717390693},
{0.7172752837428411,0.22016262570427866,0.6610934771835406},
{0.6265302180580923,0.3268668094210795,0.7075436203930914},
{0.6847756928601235,0.2627422356295889,0.6797416921774796},
{0.8148116999731515,0.14961458163321034,0.5600869312433404},
{0.9331286667060487,0.18627801331635246,0.3075246219838412},
{0.9435760074501742,-0.07351920058048408,0.32289200254945194},
{-0.4192653451335486,-0.857413087796084,0.2984281609467026},
{-0.6326669402386633,-0.7446183296638027,0.2127817799007617},
{-0.7514806235324358,-0.6225036194935518,0.21855460684398517},
{-0.7654620378392084,-0.6197598306366876,0.17310580855716734},
{-0.7896411009642599,-0.5885904752577362,0.17328642215656623},
{-0.8617503934506625,-0.4852573963120243,0.14802539887500105},
{-0.9279779538279569,-0.3711721815321281,0.03298679835872407},
{0.011938798286055258,-0.9995476565040292,-0.027603396037231356},
{0.44495914535559417,-0.8468908959952833,0.2911823642405658},
{0.6540826446770642,-0.7289536497911224,0.20199621379733568},
{0.7699686284584414,-0.603983022323527,0.20579800760640155},
{0.783119009590749,-0.6009032073591776,0.16012480196102605},
{0.8065282734694059,-0.5691586518465991,0.1599080145665654},
{0.8756677927751978,-0.46410659617083283,0.1334577988988904},
{0.9371607641355877,-0.3484662610308463,0.017348403038422475},
{0.9624838934640628,-0.2675698259829418,0.04506820437644465},
{0.9611304834633253,-0.21930381904405938,0.1677320145656307},
{0.014468400295798635,-0.9222746188554067,0.3862644078969673},
{0.48657945668437885,-0.579264267481754,0.6539826761861218},
{0.7252376173665691,-0.47197901130202835,0.5012646120033025},
{0.7740668394048643,-0.49235342506388197,0.3980058202609963},
{0.7671381805810172,-0.5424539862685696,0.34240719133246195},
{0.801772179673007,-0.44783158864631406,0.39573758996703123},
{0.8644875882389577,-0.34339559532822655,0.36707039500613947},
{0.9454804235475874,-0.31396600781945544,0.08655700215573853},
{0.9819989682260688,-0.1711273944629371,0.07995899741281634},
{0.986356846471987,-0.10273080484013938,0.12863340606053478},
{0.9680365081789378,-0.0754448084310242,0.23919322673005508},
{0.9522398150301342,-0.14872880234753244,0.2666816042092971},
{0.9537426134892206,-0.014946600211396642,0.3002526042466107},
{0.962087250170523,0.010661200555955822,0.27253341421195837},
{0.9533228485800371,0.016516800841673732,0.3015008153640719},
{0.9249528065317209,0.04765360033651449,0.3770828026628381},
{0.9399518370671518,0.04641600183042249,0.3381362133344559},
{0.6577148133687903,0.17363940352941537,0.7329806148986521},
{0.7277978361356584,0.11989120595268005,0.6752306335256609},
{0.32826903554738257,0.33798643659965416,0.8820456955143873},
{0.1348535946617774,-0.9855501609866822,0.1024957959426712},
{0.20791557363527147,-0.9691920771016258,0.13205238325510124},
{0.24204360224927246,0.9663290089799408,0.08731060081136344},
{-0.1689188094627475,0.4925716275936171,0.8537210478250276},
{0.3218468096287491,0.7488512224035172,0.5793414173322619},
{0.2643351919379195,0.5299017838382819,0.8058107754232068},
{0.6029149585830959,0.7247501502136959,0.3335127770895273},
{0.8224988216277712,0.4563880120008142,0.3394196089251066},
{0.6506830545257197,-0.20134481687222522,0.7321692613540735},
{0.6730497767473017,-0.37363918709141647,0.6382771779486345},
{0.6669123983223951,-0.48272539878571386,0.5676301985721375},
{0.673498462490477,-0.42728523964561155,0.603180855966066},
{0.7514611122040079,-0.29100976600024847,0.5921313308190979},
{0.7876162338245579,-0.2407884103407741,0.567169824357381},
{0.9204945776614931,-0.22447959455234276,0.31984159223810354},
{0.9508626242287976,-0.12316360313831455,0.2840616072381341},
{0.9636970401879985,-0.041319201723089255,0.2637816110001946},
{0.9682446453821311,-0.028656601343149832,0.24835681164061316},
{0.9570286170935074,0.029752400531408228,0.2884632051522471},
{0.9033864876879003,0.0971764094325025,0.4176716405416172},
{0.7881510803137025,0.10361381055839289,0.6066976618233443},
{0.5768248057095389,0.15102560149488464,0.8027854079461466},
{0.4191490358304204,0.11309000966735515,0.9008466770077285},
{0.37926499736733205,-0.12779419911291656,0.9164205936386665},
{0.33652098602313957,-0.387211383917795,0.8583827643484461},
{0.36797460786191744,-0.5507842117677141,0.7491538160059561},
{0.5489447597935965,-0.21215058446143834,0.8084873407838991},
{0.5741809726367978,0.23877858862075355,0.7831353626788551},
{0.47234357298718194,0.27746178413226064,0.8366041521555133},
{0.49725624592075124,0.06710020619658758,0.8650050798817178},
{0.6844698752080483,-0.07911500869298359,0.7247356796323664},
{0.6606761717219242,-0.07676579671429194,0.746735568038434},
{0.49644485187330684,-0.06330220661442006,0.8657570904625821},
{0.6112805848466234,-0.20860099482887318,0.7634275810749663},
{0.6040284684185018,-0.3274472370900554,0.726586482300688},
{0.5464803855483701,-0.3952161895485396,0.7383517804743465},
{0.18126239900265076,-0.6609555963632636,0.7282043959932446},
{0.06232279954448764,-0.5029085963242813,0.8620897936990547},
{-0.9672899241307918,-0.07269919429785199,0.2430329809377526},
{-0.9672899241307918,-0.07269919429785199,0.2430329809377526},
{-0.9672899241307918,-0.07269919429785199,0.2430329809377526},
{-0.32322622240569343,0.22475741557994186,-0.9192436637209802},
{-0.32322622240569343,0.22475741557994186,-0.9192436637209802},
{-0.32322622240569343,0.22475741557994186,-0.9192436637209802},
{-0.3232315863627498,0.22476239051719854,-0.9192405612169291},
{-0.3232315863627498,0.22476239051719854,-0.9192405612169291},
{-0.3232315863627498,0.22476239051719854,-0.9192405612169291},
{-0.39353956141078755,0.8322809183892337,0.39042936171576365},
{-0.39353956141078755,0.8322809183892337,0.39042936171576365},
{-0.39353956141078755,0.8322809183892337,0.39042936171576365},
{-0.5310301926698823,0.7077433902306075,0.46594659356826895},
{-0.5310302421562197,0.707743456184726,0.4659464369894948},
{-0.5310301926698823,0.7077433902306075,0.46594659356826895},
{-0.20057639324453103,0.821355772336508,0.5339885820151152},
{-0.20057639324453103,0.821355772336508,0.5339885820151152},
{-0.20057639324453103,0.821355772336508,0.5339885820151152},
{-0.2279297949618626,0.8049769822068694,0.5477773878919835},
{-0.2279297949618626,0.8049769822068694,0.5477773878919835},
{-0.2279297949618626,0.8049769822068694,0.5477773878919835},
{-0.9099522538092274,0.27336441616516466,0.3118634184417694},
{-0.9099522538092274,0.27336441616516466,0.3118634184417694},
{-0.9099522538092274,0.27336441616516466,0.3118634184417694},
{-0.9475046903594713,0.20316721937518903,0.24689662354547534},
{-0.9475046903594713,0.20316721937518903,0.24689662354547534},
{-0.9475046903594713,0.20316721937518903,0.24689662354547534},
{-0.9372918877124011,0.2446121706954539,0.24829177025463778},
{-0.9372918877124011,0.2446121706954539,0.24829177025463778},
{-0.9372918877124011,0.2446121706954539,0.24829177025463778},
{-0.9758152478640904,0.0405750019902185,0.21479821053592976},
{-0.9758152557828126,0.040574802319472435,0.21479821227901316},
{-0.9758152557828126,0.040574802319472435,0.21479821227901316},
{-0.978549195443601,0.05921859972426162,0.19731859908122937},
{-0.978549195443601,0.05921859972426162,0.19731859908122937},
{-0.978549195443601,0.05921859972426162,0.19731859908122937},
{-0.4684912089354298,0.8659322165157347,0.17514960334058988},
{-0.4684912089354298,0.8659322165157347,0.17514960334058988},
{-0.4684912089354298,0.8659322165157347,0.17514960334058988},
{-0.4212187706273041,0.8947519376065874,0.1483027896584553},
{-0.4212187706273041,0.8947519376065874,0.1483027896584553},
{-0.4212187706273041,0.8947519376065874,0.1483027896584553},
{-0.16323179869934942,0.9762941922207707,0.14214439886737637},
{-0.16323179869934942,0.9762941922207707,0.14214439886737637},
{-0.16323179869934942,0.9762941922207707,0.14214439886737637},
{-0.20339217401900261,0.9661000765918911,0.15900397968908095},
{-0.20339217401900261,0.9661000765918911,0.15900397968908095},
{-0.20339217401900261,0.9661000765918911,0.15900397968908095},
{-0.888330325128886,0.44205106226665397,0.1243386175141524},
{-0.888330325128886,0.44205106226665397,0.1243386175141524},
{-0.888330325128886,0.44205106226665397,0.1243386175141524},
{-0.9853569676762323,-0.15336599496896358,0.07450179755603413},
{-0.9853569676762323,-0.15336599496896358,0.07450179755603413},
{-0.9853569676762323,-0.15336599496896358,0.07450179755603413},
{-0.9706495237087266,-0.1214996154850565,-0.20755082645223413},
{-0.9706495237087266,-0.1214996154850565,-0.20755082645223413},
{-0.9706495237087266,-0.1214996154850565,-0.20755082645223413},
{-0.9767006322990608,0.020317400671887514,-0.21364240706506052},
{-0.9767006322990608,0.020317400671887514,-0.21364240706506052},
{-0.9767006322990608,0.020317400671887514,-0.21364240706506052},
{-0.4086665625323969,0.6992347358923583,-0.5865683462219031},
{-0.4086665625323969,0.6992347358923583,-0.5865683462219031},
{-0.4086665625323969,0.6992347358923583,-0.5865683462219031},
{-0.6168424218535308,0.689624424432056,-0.37937261344043594},
{-0.6168424218535308,0.689624424432056,-0.37937261344043594},
{-0.6168424218535308,0.689624424432056,-0.37937261344043594},
{-0.2040927987625568,0.8461709948695467,-0.4922811970152302},
{-0.2040927987625568,0.8461709948695467,-0.4922811970152302},
{-0.2040927987625568,0.8461709948695467,-0.4922811970152302},
{-0.1292789986543375,0.8315563913443462,-0.5401859943772148},
{-0.1292789986543375,0.8315563913443462,-0.5401859943772148},
{-0.1292789986543375,0.8315563913443462,-0.5401859943772148},
{-0.8946929836442354,0.33275986830212456,-0.2979854611643471},
{-0.8946929836442354,0.33275986830212456,-0.2979854611643471},
{-0.8946929303231113,0.3327598484705951,-0.2979856434053012},
{-0.9353430483514565,-0.20867601078726045,-0.28563561476559646},
{-0.9353431017849023,-0.208676022708318,-0.2856354310831121},
{-0.9353431017849023,-0.208676022708318,-0.2856354310831121},
{-0.7261030264949481,-0.2941704107340549,-0.621480622677356},
{-0.7261030264949481,-0.2941704107340549,-0.621480622677356},
{-0.7261030264949481,-0.2941704107340549,-0.621480622677356},
{-0.6060918265190636,0.047734402088580624,-0.7939610347391307},
{-0.6060918265190636,0.047734402088580624,-0.7939610347391307},
{-0.6060918265190636,0.047734402088580624,-0.7939610347391307},
{-0.529708471526402,0.14911802013536885,-0.8349687127456159},
{-0.529708471526402,0.14911802013536885,-0.8349687127456159},
{-0.529708471526402,0.14911802013536885,-0.8349687127456159},
{-0.16924740967672094,0.1947440111344892,-0.9661418552391623},
{-0.16924740967672094,0.1947440111344892,-0.9661418552391623},
{-0.16924740967672094,0.1947440111344892,-0.9661418552391623},
{-0.21934781879178286,0.2258450193484056,-0.9491472813145521},
{-0.21934781879178286,0.2258450193484056,-0.9491472813145521},
{-0.21934781879178286,0.2258450193484056,-0.9491472813145521},
{-0.5489022414779312,-0.2278328172162422,-0.8042378607724293},
{-0.5489022414779312,-0.2278328172162422,-0.8042378607724293},
{-0.5489022414779312,-0.2278328172162422,-0.8042378607724293},
{-0.6622202275080724,-0.4113592170875166,-0.6262970260158528},
{-0.6622202275080724,-0.4113592170875166,-0.6262970260158528},
{-0.6622201730259849,-0.411359383244222,-0.6262969744892337},
{-0.16823478701252728,-0.3061089763688471,-0.9370135276639641},
{-0.16823478701252728,-0.3061089763688471,-0.9370135276639641},
{-0.16823478701252728,-0.3061089763688471,-0.9370135276639641},
{-0.28981701051313546,-0.38081701381416794,-0.8780572318515969},
{-0.28981703258658265,-0.3808168428184618,-0.878057298727416},
{-0.28981701051313546,-0.38081701381416794,-0.8780572318515969},
{-0.7906690207752242,-0.36059520947481954,-0.4947864130007606},
{-0.7906690207752242,-0.36059520947481954,-0.4947864130007606},
{-0.7906690207752242,-0.36059520947481954,-0.4947864130007606},
{-0.3133132205065953,-0.2731954178808538,-0.9095048595278045},
{-0.3133132205065953,-0.2731954178808538,-0.9095048595278045},
{-0.3133132205065953,-0.2731954178808538,-0.9095048595278045},
{-0.17125780926818174,-0.11884800643185224,-0.9780316529294117},
{-0.17125780926818174,-0.11884800643185224,-0.9780316529294117},
{-0.17125780926818174,-0.11884800643185224,-0.9780316529294117},
{-0.5374708134451444,-0.3705394092692584,-0.7575128189496229},
{-0.5374708134451444,-0.3705394092692584,-0.7575128189496229},
{-0.5374708134451444,-0.3705394092692584,-0.7575128189496229},
{-0.68449506771888,-0.30874883054532604,-0.6604094653360286},
{-0.68449506771888,-0.30874883054532604,-0.6604094653360286},
{-0.68449506771888,-0.30874883054532604,-0.6604094653360286},
{-0.6625538204754311,-0.4111240127052945,-0.6260986193488268},
{-0.6625538204754311,-0.4111240127052945,-0.6260986193488268},
{-0.6625538204754311,-0.4111240127052945,-0.6260986193488268},
{0.8571144919726904,0.4655743413208574,-0.22044337221619206},
{0.8571144919726904,0.4655743413208574,-0.22044337221619206},
{0.8571144919726904,0.4655743413208574,-0.22044337221619206},
{0.8792632893277912,0.44502804521213707,-0.16984141725485286},
{0.8792632893277912,0.44502804521213707,-0.16984141725485286},
{0.8792632893277912,0.44502804521213707,-0.16984141725485286},
{-0.21029360391537677,-0.8083018150494644,-0.5499316102389679},
{-0.21029360391537677,-0.8083018150494644,-0.5499316102389679},
{-0.21029360391537677,-0.8083018150494644,-0.5499316102389679},
{0.4557446824444574,-0.009947401799490321,-0.8900549610114199},
{0.45574484090382134,-0.009947400892794988,-0.8900548798838354},
{0.45574484090382134,-0.009947400892794988,-0.8900548798838354},
{0.21145798028355733,-0.3217679699982014,-0.9229035139480374},
{0.21145798028355733,-0.3217679699982014,-0.9229035139480374},
{0.21145798028355733,-0.3217679699982014,-0.9229035139480374},
{0.2849506317405728,0.037075404129819106,-0.957824906691854},
{0.2849506317405728,0.037075404129819106,-0.957824906691854},
{0.2849506317405728,0.037075404129819106,-0.957824906691854},
{0.44601881219764233,0.31663560865929374,-0.837143422894048},
{0.44601881219764233,0.31663560865929374,-0.837143422894048},
{0.44601881219764233,0.31663560865929374,-0.837143422894048},
{0.811260754016671,0.5772609672800874,-0.09287499473572286},
{0.811260754016671,0.5772609672800874,-0.09287499473572286},
{0.8112606856454604,0.5772610609419269,-0.09287500980489147},
{0.8392914249445136,0.3741584111203324,-0.3944558117235898},
{0.8392914249445136,0.3741584111203324,-0.3944558117235898},
{0.8392914249445136,0.3741584111203324,-0.3944558117235898},
{-0.6921430541758384,-0.2759336215980428,-0.6669322522025234},
{-0.6921430541758384,-0.2759336215980428,-0.6669322522025234},
{-0.6921430541758384,-0.2759336215980428,-0.6669322522025234},
{-0.7062725610541263,-0.3109075828556734,-0.6360153649283075},
{-0.7062725610541263,-0.3109075828556734,-0.6360153649283075},
{-0.7062726508941645,-0.3109076224040725,-0.6360152458314002},
{-0.7937112967933366,-0.01293640157759815,-0.6081570741649421},
{-0.7937112967933366,-0.01293640157759815,-0.6081570741649421},
{-0.7937112967933366,-0.01293640157759815,-0.6081570741649421},
{-0.9370287718406353,0.10970442011856818,-0.33157506080717136},
{-0.937028709701537,0.10970441284351543,-0.3315752388187821},
{-0.9370287718406353,0.10970442011856818,-0.33157506080717136},
{0.8906552607847833,-0.26718381823456416,0.36789402510776004},
{0.8824522888395473,-0.24812262497936935,0.3996412402332764},
{0.8718012930699192,-0.1825706194904882,0.4545662485276225},
{0.9121738517548302,-0.2511980142524482,0.32378761837103},
{0.8911390610622585,-0.19672001347956658,0.4088672280162294},
{0.8296436290211006,-0.07434580260063109,0.5533210193552803},
{0.8071004053303493,-0.1410852009317718,0.57330960378632},
{0.8527156667201601,-0.1572720123056421,0.4981380389764736},
{0.7347318402176645,-0.036257001984631484,0.6773880370787861},
{0.7494569979255931,-0.18825759947892556,0.6347229982431629},
{0.9129320292461615,-0.27312600874970655,0.3032446097145686},
{0.3741375430839789,-0.9171832604726451,-0.13709837914378178},
{0.3741375430839789,-0.9171832604726451,-0.13709837914378178},
{0.3741375430839789,-0.9171832604726451,-0.13709837914378178},
{0.20013401488322674,-0.9083152675480483,-0.3673006273147897},
{0.20013401488322674,-0.9083152675480483,-0.3673006273147897},
{0.20013397852627368,-0.9083153025407162,-0.367300560589842},
{0.8882699211394355,0.08096659281178945,-0.4521293598599753},
{0.9748802923231763,-0.20734721963620978,-0.08133600770268784},
{0.5471736219381608,0.3350428134330728,-0.7670380307533166},
{0.7462820308202396,-0.6485380267835704,-0.14987180618946294},
{0.7462819340217842,-0.6485381426632382,-0.1498717867499498},
{0.7462820308202396,-0.6485380267835704,-0.14987180618946294},
{0.9302051948633139,-0.18173459899644337,-0.31888999823905756},
{0.884178659251042,-0.4663890312539053,-0.026634001784811637},
{0.8724919382495946,-0.4728973665308036,0.1229873912955972},
{0.9522839707367521,-0.1992377938775143,0.23121319289492503},
{0.7995824867782282,-0.3641536395213854,0.47755625182890576},
{0.8618840377429888,0.13026680570454768,-0.4900882214615812},
{0.2141967867782582,0.38624057615849783,-0.8971833446194937},
{0.2141967867782582,0.38624057615849783,-0.8971833446194937},
{0.2141967867782582,0.38624057615849783,-0.8971833446194937},
{0.2442142187220049,0.40863243132667065,-0.8794196674182666},
{0.2442142187220049,0.40863243132667065,-0.8794196674182666},
{0.2442142187220049,0.40863243132667065,-0.8794196674182666},
{0.2177521999247405,0.34746719987990843,-0.9120583996847744},
{0.2177521999247405,0.34746719987990843,-0.9120583996847744},
{0.2177521999247405,0.34746719987990843,-0.9120583996847744},
{0.2960972193085892,0.2960234193037766,-0.9081280592193052},
{0.2960972193085892,0.2960234193037766,-0.9081280592193052},
{0.2960970368432737,0.29602343683411564,-0.9081281129981339},
{0.23013618787831305,-0.38635537964996725,0.8931779529547107},
{0.6664896808274878,-0.18363742227033958,0.7225432876253008},
{0.6693488799124833,0.28729883430014447,0.6851506817990348},
{0.38948214095935707,0.8208390755710168,0.4177641366721586},
{0.6980165566019946,-0.09015119439500112,0.7103841558330599},
{0.505064652265689,0.5370154555720592,0.6756656699200223},
{0.23602679948546162,0.9546379979188893,0.1815423996042376},
{0.17623339765287427,0.9708485870699668,0.16246479783624834},
{0.1755224134428128,0.9710356743691393,0.16211601241605084},
{0.5069605516226935,-0.29627997172713544,0.8094499227572897},
{0.6808160668093962,-0.5417456531622294,0.4929514483739886},
{0.33208004015577847,-0.4443610537330217,0.832025300610153},
{0.4768950357157197,-0.27871382087349195,0.8336004624301748},
{0.5380588388237768,0.06711520484271523,0.8402310606270927},
{0.6624094012098908,-0.17935900032759922,0.7273542013285125},
{0.4883090202793276,-0.5085006211178787,0.7092118294533551},
{0.2933439874371333,-0.7542307676990121,0.5874395748420783},
{0.2918236159493692,-0.6666976364377869,0.6858230374830693},
{0.12841959432285494,-0.9895223562554143,-0.0659841970829852},
{0.1634363803543795,-0.9831960818164166,-0.08132659022426143},
{0.1533365795588921,-0.9840508688174077,-0.09017638797869834},
{0.13091858810965493,-0.9882125102481327,-0.0793495927932767},
{0.15378580305015688,-0.9813476194638526,-0.11535500228792807},
{0.9044617721922807,-0.05965741135763395,0.4223622804097272},
{0.9303944646163816,-0.07767020539423634,0.35823662487972074},
{0.8422275408073685,-0.16052762683772687,0.5146684860445802},
{0.8221027211237076,-0.05988780882351227,0.5661806834176824},
{0.7204021923266506,-0.04337959953794307,0.6921985926270606},
{0.7413823959355045,-0.33566879815975625,0.5811011968142172},
{0.8342337804254387,-0.1385361967493701,0.5337243874766271},
{0.9210275101508627,-0.01119380133872969,0.3893366465629604},
{0.8934505981201264,-0.0477829998994617,0.44661259906030026},
{0.8024146019907265,0.006819000016917393,0.5967280014804344},
{0.6807770859871892,0.11662761473093174,0.7231462913387336},
{-0.26361280990540437,0.5234788196700206,0.8102334304449917},
{-0.11342878350060273,-0.9914580557821054,0.06438039063520204},
{-0.15052958078442455,-0.9868944740198098,0.05813899257837435},
{-0.11022800909999049,-0.991784281877806,0.0649132053589787},
{-0.05311239535078119,-0.9958225128302022,0.07427379349840812},
{-0.1864039707212398,-0.9666064481736292,0.175856572377936},
{-0.025960999141873206,-0.9969993670447248,0.07292659758945073},
{0.3549185878021369,0.7647209737180243,0.5378053815166727},
{-0.1420283867841172,0.9874789081141044,0.06865379361169614},
{-0.14883739018002487,0.9852881349927798,0.08399239445836007},
{-0.08818018997544554,0.9955416868242192,0.033481396193747376},
{-0.07918538988185464,0.9968254726277027,0.008285598941283303},
{0.12538779411881606,0.9801777540257829,-0.153393192805252},
{0.11843999396171843,0.9775789501612865,-0.1741015911239912},
{0.139379991164173,0.9840097376198854,-0.11089659296984378},
{0.14406800302689757,0.9848598206921021,-0.09641340202566488},
{0.06603918866198494,0.9967264288758617,-0.0466395919926273},
{0.3156129977771377,0.1892259986672813,0.9298289934512144},
{0.4734100064090531,0.163521802213768,0.8655308117176082},
{0.45675439507073406,-0.000667599992795301,0.8895925903995703},
{0.07726620355588658,0.06480320298232382,0.994902245786636},
{0.40237365349257115,0.21884062909322669,0.8889343181771763},
{0.5560148145137106,-0.01868100048763203,0.8309624216906956},
{0.6580736887891375,0.01899480256283174,0.7527139015582589},
{0.5064150609599192,0.11690421407239236,0.8543285028401414},
{0.41888179645194556,0.12205299896617447,0.899800592378419},
{0.17656379670429903,0.4306375919618135,0.8850855834791874},
{0.35253503109819523,0.819055872251428,0.45262183992715926},
{0.27530758628318525,0.8257387588587233,0.4923019754717438},
{0.1572594000139835,0.817004800072648,0.5547726000493304},
{0.47059937120174766,0.17965138900626235,0.8638643471359612},
{0.5950590469345226,0.12700401001727912,0.7935834625928824},
{0.6935308509932586,-0.01197160088023617,0.7203274529635331},
{0.8280890081906118,-0.06318020062491411,0.5570250055095233},
{0.8248775470162031,-0.16296478953239382,0.5413127652302264},
{0.6673822206665719,-0.11423560353749056,0.7359016227883861},
{0.7240450867882489,0.03387560406052663,0.6889202825779858},
{0.7920085385807558,-0.1450530253804813,0.593027903764355},
{0.696804629859612,-0.3048330130627655,0.6492612278222726},
{0.17630939529896744,-0.8641215769594601,0.47139038743106376},
{0.10346878983991993,-0.9413839075611506,0.32107716847194456},
{0.12704998385013636,-0.985813274689083,0.10968358605765301},
{0.4699851852846701,-0.8159169744534768,0.3367393894566226},
{0.3264215987778971,-0.5170585980641637,0.7912643970375537},
{0.5246869905129669,-0.3003769945687875,0.7965407855974914},
{0.5340441796438384,0.19367499261769044,0.8229743686306865},
{0.06948359561807832,0.835270147324425,0.5454317656028267},
{0.20224058129000877,0.9367523133377313,0.28564637357384404},
{0.36039635353673916,0.8950960846018213,0.26252136615504407},
{0.1622790013528519,0.9647022080423172,0.20740100172901507},
{-0.06261579871523026,0.9646713802065834,0.25590699474922357},
{-0.1478287857969746,0.8798429154668611,0.4516891566028191},
{0.2098403796060342,0.6663727352365698,0.7154819304637455},
{0.8746529487356299,0.03445259798069539,0.4835237716601407},
{0.7662552018875471,-0.2748862006771382,0.5807672014306272},
{0.6049730282538504,-0.5810458271363863,0.5444202254258733},
{0.5167174312166475,-0.42535582569718394,0.7430178448882208},
{0.5185188090804985,-0.3948648069150226,0.7584326132819602},
{-0.22188460106024008,0.9679746046253118,0.11744100056117303},
{-0.19738697593950025,0.971370281594749,0.1322049838848639},
{-0.19738697593950025,0.971370281594749,0.1322049838848639},
{-0.19738697593950025,0.971370281594749,0.1322049838848639},
{0.5990220235153887,-0.5773868226660708,0.5547946217791845},
{0.7843944639251079,-0.587024647840233,0.20031821632515803},
{0.6324396473437127,0.5059964378783179,0.5865046439050707},
{0.13023738278679192,-0.9870652695416056,0.09348998764361986},
{-0.10677599266761169,-0.9920213318771436,0.06702659539723292},
{-0.37491697379017763,-0.9183371358005775,0.12686279113123317},
{-0.4086469280853964,-0.8853342441968924,0.22179036096883442},
{-0.3072963961223251,-0.9182813884125011,0.24965619684966833},
{0.527857417142761,-0.8420480273464531,0.11100300360494693},
{0.1711665996261653,0.4967103989151646,0.8508705981416647},
{-0.3302185705784051,0.740912533986667,0.5848113478948669},
{-0.6146985268279391,0.7099277154921123,0.3437271590836426},
{-0.827555315052276,0.4363006606574366,0.3532618491128255},
{0.5253758080591284,-0.7588012116398134,0.38496880590532145},
{0.9727116487972871,-0.04908200246225957,0.22676641137601847},
{0.9727116487972871,-0.04908200246225957,0.22676641137601847},
{0.9727116487972871,-0.04908200246225957,0.22676641137601847},
{0.5667177994251555,0.2037471997933311,-0.7983219991902302},
{0.566715972893647,0.20374459025477828,-0.7983239618157028},
{0.566717280437261,0.20374662891886544,-0.7983225133102493},
{0.566719016478489,0.20374920592441573,-0.7983206232127691},
{0.3022076145893873,0.23237461121812628,-0.924485044630478},
{0.3022076145893873,0.23237461121812628,-0.924485044630478},
{0.3022076145893873,0.23237461121812628,-0.924485044630478},
{0.3022063849455651,0.23237338842430133,-0.9244857539466693},
{0.3022063849455651,0.23237338842430133,-0.9244857539466693},
{0.3022063849455651,0.23237338842430133,-0.9244857539466693},
{0.5213809837447801,0.72055577753506,0.4571227857481734},
{0.5213809837447801,0.72055577753506,0.4571227857481734},
{0.5213809837447801,0.72055577753506,0.4571227857481734},
{0.37965323534924106,0.841693678369496,0.3839468357490151},
{0.37965323534924106,0.841693678369496,0.3839468357490151},
{0.37965323534924106,0.841693678369496,0.3839468357490151},
{0.21741879493860355,0.8103985811343426,0.5440433873349529},
{0.21741879493860355,0.8103985811343426,0.5440433873349529},
{0.21741879493860355,0.8103985811343426,0.5440433873349529},
{0.18944721248314328,0.8261040544340301,0.5307182349703312},
{0.18944721248314328,0.8261040544340301,0.5307182349703312},
{0.18944721248314328,0.8261040544340301,0.5307182349703312},
{0.9081288286072936,0.2954972093085641,0.29662000934393384},
{0.9081288286072936,0.2954972093085641,0.29662000934393384},
{0.9081288286072936,0.2954972093085641,0.29662000934393384},
{0.9350907206260992,0.26740577730162524,0.23259298025666203},
{0.9350907206260992,0.26740577730162524,0.23259298025666203},
{0.9350907206260992,0.26740577730162524,0.23259298025666203},
{0.946283688523632,0.22622482116304346,0.23101842161147867},
{0.9462836448018191,0.22622481071061848,0.23101861093758103},
{0.9462836448018191,0.22622481071061848,0.23101861093758103},
{0.9799884483190568,0.08306100409538436,0.18089640891923153},
{0.9799884483190568,0.08306100409538436,0.18089640891923153},
{0.9799884483190568,0.08306100409538436,0.18089640891923153},
{0.9780026427671568,0.06436020281441251,0.19841520867651471},
{0.9780026427671568,0.06436020281441251,0.19841520867651471},
{0.9780026427671568,0.06436020281441251,0.19841520867651471},
{0.4017401717422963,0.9047707363600029,0.14140279005397413},
{0.4017401717422963,0.9047707363600029,0.14140279005397413},
{0.4017401717422963,0.9047707363600029,0.14140279005397413},
{0.45014335728447635,0.8771159167677028,0.16744738411038934},
{0.4501435167586313,0.8771158378021228,0.16744736903532392},
{0.45014335728447635,0.8771159167677028,0.16744738411038934},
{0.18245181421189485,0.970797275619247,0.15576901213346567},
{0.18245181421189485,0.970797275619247,0.15576901213346567},
{0.18245181421189485,0.970797275619247,0.15576901213346567},
{0.1417781934343229,0.9800073546163505,0.13958699353579626},
{0.1417781934343229,0.9800073546163505,0.13958699353579626},
{0.1417781934343229,0.9800073546163505,0.13958699353579626},
{0.8792662548618021,0.46356942892440617,0.10951820683338655},
{0.8792662548618021,0.46356942892440617,0.10951820683338655},
{0.8792662548618021,0.46356942892440617,0.10951820683338655},
{0.9697031573891302,-0.09787859569900122,-0.22382039016484434},
{0.9697031573891302,-0.09787859569900122,-0.22382039016484434},
{0.9697031573891302,-0.09787859569900122,-0.22382039016484434},
{0.9899087045808311,-0.12932001366226445,0.05794040612122694},
{0.9899087045808311,-0.12932001366226445,0.05794040612122694},
{0.9899087045808311,-0.12932001366226445,0.05794040612122694},
{0.9721975126183943,0.04404320510192113,-0.2299830266410054},
{0.9721975126183943,0.04404320510192113,-0.2299830266410054},
{0.9721975126183943,0.04404320510192113,-0.2299830266410054},
{0.5934295658128915,0.7043553594225256,-0.38951877756006537},
{0.5934295658128915,0.7043553594225256,-0.38951877756006537},
{0.5934295658128915,0.7043553594225256,-0.38951877756006537},
{0.38163321643708803,0.7088532305305787,-0.5931974255492392},
{0.38163321643708803,0.7088532305305787,-0.5931974255492392},
{0.38163321643708803,0.7088532305305787,-0.5931974255492392},
{0.09992378924332858,0.8343467101836162,-0.542107741642777},
{0.09992378924332858,0.8343467101836162,-0.542107741642777},
{0.09992378924332858,0.8343467101836162,-0.542107741642777},
{0.17515158592780022,0.8507877316451811,-0.49546156019314336},
{0.17515158592780022,0.8507877316451811,-0.49546156019314336},
{0.17515158592780022,0.8507877316451811,-0.49546156019314336},
{0.8812056944473494,0.3543788379822125,-0.3128772335340836},
{0.8812056944473494,0.3543788379822125,-0.3128772335340836},
{0.8812056944473494,0.3543788379822125,-0.3128772335340836},
{0.7225241847463441,-0.2765335941619279,-0.6336307866230277},
{0.7225241847463441,-0.2765335941619279,-0.6336307866230277},
{0.7225241847463441,-0.2765335941619279,-0.6336307866230277},
{0.935226249174104,-0.18590200977470936,-0.30131761584325056},
{0.9352262839461768,-0.18590181668659986,-0.3013176270463558},
{0.9352262839461768,-0.18590181668659986,-0.3013176270463558},
{0.5118486071739371,0.16179800226771876,-0.8437016118251026},
{0.5118486071739371,0.16179800226771876,-0.8437016118251026},
{0.5118486071739371,0.16179800226771876,-0.8437016118251026},
{0.5913541826793426,0.062310998174922104,-0.8040009764509565},
{0.5913541826793426,0.062310998174922104,-0.8040009764509565},
{0.5913541826793426,0.062310998174922104,-0.8040009764509565},
{0.19784160225736871,0.23092380263483597,-0.9526452108696629},
{0.19784141008561504,0.23092381177209906,-0.9526452485642176},
{0.19784141008561504,0.23092381177209906,-0.9526452485642176},
{0.14823519908876265,0.1986089987791028,-0.9688037940445305},
{0.14823519908876265,0.1986089987791028,-0.9688037940445305},
{0.14823519908876265,0.1986089987791028,-0.9688037940445305},
{0.5407254005390708,-0.21456800021391143,-0.8133736008108847},
{0.5407254005390708,-0.21456800021391143,-0.8133736008108847},
{0.5407254005390708,-0.21456800021391143,-0.8133736008108847},
{0.6614435785295418,-0.39524518717034146,-0.6373959793101268},
{0.6614434660310446,-0.3952452394568204,-0.6373960636304236},
{0.6614435785295418,-0.39524518717034146,-0.6373959793101268},
{0.2842395835734709,-0.37382857839602096,-0.8828703489779176},
{0.2842395835734709,-0.37382857839602096,-0.8828703489779176},
{0.2842395835734709,-0.37382857839602096,-0.8828703489779176},
{0.15990361795769856,-0.30211443392843773,-0.9397647055386459},
{0.15990361795769856,-0.30211443392843773,-0.9397647055386459},
{0.15990361795769856,-0.30211443392843773,-0.9397647055386459},
{0.7908061915657989,-0.3413423963594741,-0.5080461945815248},
{0.7908061915657989,-0.3413423963594741,-0.5080461945815248},
{0.7908061915657989,-0.3413423963594741,-0.5080461945815248},
{0.1576791982622365,-0.1148435987343225,-0.9807895891908357},
{0.1576791982622365,-0.1148435987343225,-0.9807895891908357},
{0.1576791982622365,-0.1148435987343225,-0.9807895891908357},
{0.30457821172205213,-0.2656726102247241,-0.9146858352027645},
{0.30457821172205213,-0.2656726102247241,-0.9146858352027645},
{0.30457821172205213,-0.2656726102247241,-0.9146858352027645},
{0.6806398275491153,-0.29212961182403974,-0.6718554271935641},
{0.6806398275491153,-0.29212961182403974,-0.6718554271935641},
{0.6806398275491153,-0.29212961182403974,-0.6718554271935641},
{0.5335562088008924,-0.3575004058968906,-0.7664928126431304},
{0.5335562088008924,-0.3575004058968906,-0.7664928126431304},
{0.5335562088008924,-0.3575004058968906,-0.7664928126431304},
{0.6617679938061031,-0.3950067963028865,-0.6372069940359847},
{0.6617679938061031,-0.3950067963028865,-0.6372069940359847},
{0.6617679938061031,-0.3950067963028865,-0.6372069940359847},
{-0.8717688593020961,0.4445274302389884,-0.20594761400959102},
{-0.8717688593020961,0.4445274302389884,-0.20594761400959102},
{-0.8717688593020961,0.4445274302389884,-0.20594761400959102},
{-0.8925592742569003,0.4234586352298459,-0.1549862128941529},
{-0.8925592742569003,0.4234586352298459,-0.1549862128941529},
{-0.8925592742569003,0.4234586352298459,-0.1549862128941529},
{0.22065678943407055,-0.803053961546565,-0.5535475734939287},
{0.22065678943407055,-0.803053961546565,-0.5535475734939287},
{0.22065678943407055,-0.803053961546565,-0.5535475734939287},
{-0.2190044116363135,-0.3270122173750687,-0.9192932488446073},
{-0.2190044116363135,-0.3270122173750687,-0.9192932488446073},
{-0.2190044116363135,-0.3270122173750687,-0.9192932488446073},
{-0.4702152246778548,-0.021236201114519182,-0.882296246304708},
{-0.4702152246778548,-0.021236201114519182,-0.882296246304708},
{-0.4702152246778548,-0.021236201114519182,-0.882296246304708},
{-0.30178680264984503,0.02993340026283082,-0.952905408367005},
{-0.30178680264984503,0.02993340026283082,-0.952905408367005},
{-0.30178680264984503,0.02993340026283082,-0.952905408367005},
{-0.8265151445182057,0.5573223625884112,-0.07914859468696238},
{-0.8265151445182057,0.5573223625884112,-0.07914859468696238},
{-0.8265151445182057,0.5573223625884112,-0.07914859468696238},
{-0.467563637974024,0.30551122481264503,-0.8294860673682067},
{-0.467563637974024,0.30551122481264503,-0.8294860673682067},
{-0.467563637974024,0.30551122481264503,-0.8294860673682067},
{-0.8546453567756798,0.3535373821195857,-0.38025338076840437},
{-0.854645421772024,0.35353740900633723,-0.3802532096869201},
{-0.8546453567756798,0.3535373821195857,-0.38025338076840437},
{0.7028692830373755,-0.29375323470417364,-0.6478300765350125},
{0.7028692830373755,-0.29375323470417364,-0.6478300765350125},
{0.7028692830373755,-0.29375323470417364,-0.6478300765350125},
{0.6873761663625882,-0.25913978731874604,-0.6784987667970124},
{0.6873761663625882,-0.25913978731874604,-0.6784987667970124},
{0.6873761663625882,-0.25913978731874604,-0.6784987667970124},
{0.7834835505213701,0.006263199604465804,-0.6213809607584887},
{0.7834835495399316,0.006263399596607265,-0.6213809599801097},
{0.7834835495399316,0.006263399596607265,-0.6213809599801097},
{0.9283899109317388,0.1324140158219266,-0.3472156414882092},
{0.9283899109317388,0.1324140158219266,-0.3472156414882092},
{0.9283899109317388,0.1324140158219266,-0.3472156414882092},
{-0.9692983565780846,-0.034885805635367674,0.24340023931827903},
{-0.9699351523262916,-0.03933999806638249,0.24016278819565343},
{-0.7573031996061872,-0.04561279997628043,0.6514685996612233},
{-0.8013180590325587,-0.05362100395022304,0.5958306438944401},
{-0.0040736001492694225,-0.10621880389218845,0.9943344364355168},
{-0.0045903997459999695,-0.1062247941222764,0.9943315449807735},
{0.7799564363151782,-0.03847140179124851,0.6246502290840402},
{0.8205877638287056,-0.023014198985540118,0.5710569748279576},
{0.9730177680840466,-0.011808202039808983,0.23042783980527906},
{0.9726415116100556,-0.01662960190823728,0.23171522658918936},
{-0.9694829494844904,-0.042390606536203884,0.241466037231627},
{-0.9689318405006154,-0.039718801660215755,0.24411781020393913},
{-0.7695807997044656,-0.10260879996059614,0.6302513997579708},
{-0.8087220499170438,-0.1003748061954705,0.5795632357725914},
{0.0065567991875149344,-0.1645983796038095,0.9863388777779242},
{0.006020799685141928,-0.16464719138976547,0.9863341484195979},
{0.7843504292662956,-0.08872320331050944,0.6139402229078169},
{0.8212530794036627,-0.07529520727999126,0.5655740546830844},
{0.9744719484414985,-0.018397402802479892,0.22375423408452533},
{0.9747598225049822,-0.015352600354456543,0.22272760514227263},
{0.27270957221178505,0.9605885021191681,0.053844394513432016},
{0.5728981514655603,0.8189949306168819,0.032171597274506046},
{0.4996475928738462,0.8550213878053772,-0.13889099801908658},
{0.0895917879618067,0.9874706673163798,-0.12990378254519883},
{0.33300860496892803,0.7461052111328746,-0.5765694086031767},
{0.5773720059871168,0.4461224046261109,-0.6838248070909898},
{0.9076095033018505,0.3519008400524761,-0.22893402605670002},
{0.9479374906500343,0.31796403040648835,0.01770280169289599},
{0.8598484405857244,-0.3124902147498573,-0.4037456190572055},
{0.6000362182904843,0.02294800069950785,-0.7996436243749772},
{0.36446341729274717,-0.32348901534862895,-0.8732246414320128},
{0.5280539328728906,-0.7043583104607798,-0.4743821396957397},
{0.7624760657321494,-0.6037532520488456,-0.23262042005392813},
{0.5545241780628687,-0.7624685698365306,-0.33338358681125224},
{0.09615999289528265,-0.8280007388237143,-0.5524201591848027},
{0.2412758094505131,-0.913741435790266,-0.3268984128042581},
{0.9767354457893002,-0.21300140998549358,0.02486500116566979},
{0.9767354457893002,-0.21300140998549358,0.02486500116566979},
{0.9767354457893002,-0.21300140998549358,0.02486500116566979},
{-0.24669598080150273,-0.9064493294578497,-0.342769173324847},
{-0.5062678039170345,-0.8024222062084049,-0.3159296024443726},
{-0.5044305767958106,-0.7172003670082389,-0.48080497788260607},
{-0.26670118917612984,-0.9094777630895188,-0.3189367870561868},
{-0.7897774571138805,-0.5972802431931705,-0.13967061010047888},
{-0.8220359216794595,-0.33789805001636913,-0.45834686784545264},
{-0.6263741625819746,0.001764999894563322,-0.7795205534333924},
{-0.6103139914027266,0.42151719406223903,-0.6707011905520738},
{-0.9016774166501409,0.37462000691763575,-0.21595760398781702},
{-0.3617929798052229,0.7374215588381621,-0.5703641681630716},
{-0.5432904372353784,0.8322698570410981,-0.11028320755845619},
{-0.9749754658926856,0.219037014803385,-0.03802140256963628},
{-0.9765427634051738,-0.18764879296807552,-0.1056037960426182},
{-0.9878733506154305,-0.12563461915479573,0.09122601390871142},
{-0.9878733506154305,-0.12563461915479573,0.09122601390871142},
{-0.9878733506154305,-0.12563461915479573,0.09122601390871142},
{-0.60896316842034,0.7930043588763175,-0.01754839908997374},
{-0.29886038920032737,0.9524653655815407,0.059094797864539785},
{-0.30654562174217204,0.9508112674376037,0.044583803162167875},
{-0.014764001043162637,0.8451750597165391,-0.5342856377503912},
{-0.011754800923855686,0.308085424213636,-0.9512860747652856},
{-0.00239259987246419,-0.4447741762916334,-0.8956395522585798},
{-0.3829383782991202,-0.33305478112599257,-0.8616453511710935},
{0.6881824544976387,-0.424091833584122,0.5886858466184344},
{-0.05818600275974356,-0.480612022795275,0.8750008415010109},
{-0.05725280075210715,-0.3001414039428376,0.9521750125083425},
{0.7881273368246866,-0.2730086473963037,0.5516534957710933},
{-0.028740800329368998,-0.1150554013185326,0.9929432113791093},
{-0.7918708077658929,-0.031867600312526195,0.609856605980876},
{-0.8115931167638777,-0.1948228280291545,0.5507818792409727},
{-0.9943315266733502,0.09621781225771515,0.045243205763780284},
{-0.9654648469203183,0.2525438122732962,0.06402540311155015},
{-0.6116829908165586,0.3701285944431114,-0.6991771895029733},
{-0.7347623698494382,0.2685945889783717,-0.6228813744404121},
{0.11490121003853307,0.27062482364358253,-0.955803283505325},
{0.19460162160354844,0.25685982851509515,-0.9466537050920286},
{0.8429927355577276,0.06829561098229847,-0.5335718858012047},
{0.8783480409092015,0.018127800844305243,-0.4776778222479215},
{0.9851224009937362,-0.06427161311328586,-0.15938323251883355},
{0.955869509795881,-0.14921661713975579,-0.2530768290696514},
{0.9472653947525476,-0.1858089989706962,0.2610809985537209},
{0.9213018342978937,-0.28085681045563643,0.26892821001156275},
{-0.8082336996014736,0.02617400322551422,0.5882798724957921},
{-0.09072019809802384,-0.12058999747179454,0.9885483792747868},
{-0.887312746966776,-0.06795301125514652,0.4561342755501193},
{-0.9865641064875847,0.08226060887903126,-0.1411540152358575},
{-0.9441203663377855,0.28860358970996036,-0.15920019432378402},
{-0.5803762053754328,0.16450960152368463,-0.7975588073869737},
{0.10550160330199344,0.14205060444590556,-0.9842210308041895},
{0.7655806917307509,-0.03906260468042376,-0.642152876941812},
{0.9577155570062725,-0.125264994376609,-0.25901658837223795},
{0.7437694005319141,-0.17786260012720023,0.644338400460805},
{0.7733667937887974,-0.14887959880429136,0.6162293950508275},
{0.770856029620899,-0.08337000320357414,0.6315302242671683},
{-0.1449048227950722,-0.0035148005529155677,0.9894393556493505},
{-0.9002905239913325,0.0024092003318039582,0.4352828599487614},
{-0.9794613185891483,-0.00215620026106386,-0.201620624411396},
{-0.9824679424018613,-0.04389500636227437,-0.18119042626228585},
{0.8953833810399706,-0.17742119624304942,0.4084241913514871},
{0.9341966513612926,-0.1530568084149258,0.32225801771745627},
{0.9484820172726164,-0.07862240143177684,0.3069208055892735},
{0.9170094618248167,0.046662003145954215,0.3961266267068739},
{0.7259194339808848,0.10827340506836701,0.679203831794089},
{-0.13240380379634017,0.3765048107953118,0.9169042262898818},
{-0.9189799953042879,0.2115897989188396,0.3327243982998781},
{-0.9810896100397254,0.10835700110884319,-0.1603806016412132},
{-0.6134367621854773,0.051043796853470574,-0.7880925514190449},
{-0.6821812122410462,-0.02106620037801148,-0.7308796131148892},
{0.025207200267178178,-0.03511840037222976,-0.999065210589372},
{0.7521073247874616,-0.10478501738562555,-0.6506571079551364},
{0.9629333651295282,-0.11622041993016735,-0.24341764174270183},
{0.889972711684516,-0.02931640367897612,-0.4550704571077327},
{0.991964218974014,-0.05793140110809563,-0.11247640215141716},
{0.9958516893575768,0.07472780670531146,-0.051915004658323195},
{0.9042179772929709,0.1409801964596574,-0.40313078987644263},
{0.8334912516720416,0.2701450167475598,-0.48198962988080346},
{0.9875597101087067,0.1510856168454036,-0.043577004858650674},
{0.24397322444494232,0.03690520369772371,-0.9690794970970995},
{0.2353353930276572,0.2818129916506533,-0.9301605724418912},
{0.12886220048731045,0.3506642013260858,-0.9275932035078236},
{-0.6376334160036553,0.22200460557198712,-0.7376568185140947},
{-0.6783976698620876,0.2907436299410771,-0.6747182694831791},
{-0.9513793523329523,0.22683383632017856,-0.2083836333659691},
{-0.9234382892083723,0.3693614356820081,0.10408581005516646},
{-0.9402206445768209,0.33839561604368174,0.038386801819957475},
{-0.7550700162803367,0.4468892096355393,0.4797492103440456},
{-0.7329059454731189,0.5302545605500166,0.42623816828864863},
{-0.20935860054850694,0.54213460142036,0.8137930021320887},
{-0.088753592294859,0.6613541425845558,0.7448043353398294},
{0.5080324113839295,0.5183062116141436,0.687940215415282},
{0.5231070608405979,0.44521585178136686,0.7267336845236381},
{0.8139668891602286,0.3429436375653279,0.4688790513600295},
{0.8205471446798621,0.2954005800845071,0.489326967010262},
{0.9629716723010329,0.13312340999506042,0.2344434176022844},
{0.8880033836264787,0.2084403961566551,-0.40988119244237287},
{0.9701196728212599,0.2141910160780779,0.11397380855535308},
{0.9783572153346731,0.09771900153163786,0.18239560285885043},
{0.8602610966093396,-0.28042743149265853,-0.4258066478190856},
{0.9842496085993298,-0.17370640151766237,0.0328450002869648},
{0.9883561630849177,-0.05207539805498496,0.14296939466009606},
{0.8773066686049279,0.12040080941528104,0.46458223633009066},
{0.7257811369142063,0.2530001780089118,0.63971294439536},
{-0.5979538883774717,-0.04821360712596202,-0.8000791182515424},
{-0.8884306591398813,-0.16612081105811122,-0.42789582848360563},
{-0.9148209633113988,0.25726558968244606,-0.3113149875148123},
{-0.5805100483886494,0.2588022215725636,-0.7720294643528275},
{-0.391180255847393,0.5455868778914691,-0.7411565058122389},
{-0.8741236148896471,0.46054620784485206,-0.15428900262812806},
{-0.9607435152494941,0.2635385767523513,0.08671399235065905},
{-0.9797508948906032,0.0022920002219842662,-0.2002072193904225},
{-0.82326485207697,-0.39519122499846987,-0.4075032257772857},
{-0.5569024417591195,-0.36770102757192286,-0.744752055844952},
{0.23976978740620739,-0.20914878901456058,-0.9480333502050048},
{0.2912711800158035,0.2947385797779042,-0.910104537557475},
{0.7414660118286074,0.48354580771400635,-0.4652006074213454},
{-0.2505148075429609,0.5104988153710379,0.8225772247676689},
{-0.8867729492999818,0.4227131758319582,0.18694198931185005},
{-0.8721874536040319,0.3498858215037383,0.34186102101053967},
{-0.21276519146547346,0.558097777613348,0.8020335678284933},
{-0.19114259838226844,0.6670205943546845,0.7201027939054244},
{-0.9636383524292421,0.2640497869649766,-0.040973597977306424},
{0.6860326355548908,0.30695061590827477,0.6596518341876577},
{0.910045973768817,0.17672699490601762,0.37494518919257247},
{-0.9612336475110503,0.1286194063572921,0.24389941205525553},
{-0.5068980236855913,0.30735641436170213,0.8053486376311562},
{-0.3718549839004199,0.5971419741465478,0.7107357692284682},
{-0.897475984331649,0.4155007927460875,0.1479727974166554},
{-0.13731960732316148,0.8914326475394982,0.43184622303006603},
{0.4241902015667804,0.5776212021334901,0.6974356025760342},
{0.43565844600149134,0.2597696274292634,0.8618128909994485},
{-0.9153330224100804,-0.0742690018183265,-0.3957898096901141},
{-0.9574384516137084,0.07904260426103832,-0.27760381496510017},
{-0.9265517490271098,0.3739039794302191,-0.041202797733288304},
{-0.9754129519892196,0.12681639375797296,-0.18024199112831274},
{0.8698955215836179,0.2617976365909503,0.4180236584263598},
{0.9392510974106568,-0.20338702109346837,0.27647982867399545},
{0.9880893210616991,-0.13708901679628446,0.06990060856429299},
{0.9863681090667128,-0.14042541552740637,-0.08578260948533022},
{0.830416253613502,-0.47389043059540975,-0.29297901891537065},
{0.7489808007128949,-0.5834554005553445,-0.314018400298889},
{0.6199879780717572,-0.7787599724561792,0.09564419661717768},
{0.7292013753537231,-0.6126309792936858,-0.3048747896955371},
{0.3931340022773467,-0.48426640280525846,-0.7816212045277754},
{-0.981380488483212,0.012179801098155035,-0.19168721728289984},
{-0.8832023673373224,-0.13889199486348244,-0.44795378343372866},
{-0.9051865776781283,-0.03141611710785478,-0.423851727821444},
{-0.9890750297837451,0.02042374633611654,-0.14599128756155932},
{0.6804980020373967,0.05790607246690691,-0.7304583191357112},
{0.7697768918929375,-0.137576246557545,-0.6233107676679316},
{-0.8862980521596521,-0.21320574088679076,-0.41111929508467676},
{-0.8960428192905117,-0.20482480440958312,-0.3938960084800139},
{-0.3069601019335917,-0.04635144189552618,0.9505929936913718},
{-0.32585400625816313,-0.13957500268059658,0.9350604179582283},
{-0.3200213961138522,-0.1828279977798465,0.9296021887114689},
{-0.300238478913877,-0.04372778954369514,0.9528613415398401},
{0.011682999215197127,-0.9994465328624014,-0.031146997907707346},
{0.011905599791061488,-0.9994371824602775,-0.03136199944960946},
{0.011899998653542597,-0.999437286915976,-0.03136079645159821},
{0.9445389400399794,0.05165660765875282,0.3243112480832908},
{0.9681101966261358,0.0646735997746125,-0.24203299915651497},
{0.9267348195940472,-0.10488260221754338,-0.3607800076280079},
{0.9821613715837343,-0.14607619577366804,0.11840939657413438},
{0.9570963138944107,-0.22468222673717309,-0.1829878217755411},
{0.6305340788336758,0.044997892709781884,-0.7748560931431376},
{0.07172039999510293,-0.6250985999573183,-0.7772437999469298},
{0.05195079941899057,-0.6226951930358766,-0.7807379912683513},
{0.10191964086964213,-0.4684742107534124,-0.8775786578216055},
{0.12296767829281319,-0.45406451331573283,-0.8824422745101358},
{0.009113999959564828,-0.9973857955749983,-0.07168339968196943},
{0.017074399580565332,-0.9987951754644769,-0.046007198869827653},
{0.011908397928357878,-0.9994376261330283,-0.03134679454676101},
{0.011937798698118895,-0.9994382910058832,-0.03131439658499676},
{0.011973000186514919,-0.999438815569218,-0.031284200487344024},
{0.05605579700849166,-0.7982845573982525,-0.5996661679978443},
{0.035728801933139036,-0.7815074422841647,-0.6228720337010528},
{-0.3120925812220453,-0.2931197823635988,0.9037029456260931},
{-0.22193060806139867,-0.19939360724276553,0.9544574346696743},
{-0.22193060806139867,-0.19939360724276553,0.9544574346696743},
{-0.22193060806139867,-0.19939360724276553,0.9544574346696743},
{0.9467018605678283,-0.258579416543322,0.19207361228843217},
{-0.924002790211765,0.3577727242327515,-0.1349722989207371},
{-0.9239192321431017,0.3460354025495239,-0.16319544313028622},
{-0.9377860961248804,0.31710803250418385,0.14142041449586476},
{-0.9269356973581191,0.33556323524495335,0.16789141763400922},
{-0.7099107056621375,0.20005082977529162,0.675282500508123},
{-0.6437755444524733,0.24476077888106185,0.7250139374429001},
{-0.05666900326202886,0.13548340779880996,0.9891576569387256},
{0.053303399447228825,0.11965999875909233,0.991382989719081},
{0.9263676265780252,0.12947957350668887,0.3536637675430186},
{0.9279626581224772,0.13548470217463698,0.3471731565183521},
{0.9710307930332618,0.18222059869264373,0.1545795988909563},
{0.9699141650084073,0.19936499280750927,0.13971439495952387},
{0.4859912286819019,0.42490305300796677,-0.763721101704519},
{0.5084961873331031,0.4070240687870068,-0.7587905079109567},
{0.49996637488555973,0.4138819792097733,-0.7607465617859819},
{0.5266202151850099,0.3921112113064642,-0.7542678217491924},
{-0.3481029921807018,0.4673007895032094,-0.8126833817450185},
{-0.3300865781747224,0.4472803704258856,-0.8312539450376075},
{-0.9728176671971083,0.21868565506007384,-0.07617329361477466},
{-0.970709164091512,0.23876417699742286,-0.026746710666949662},
{-0.9708259143559406,0.20514062416401196,0.12415461462447336},
{-0.970977293209321,0.17097078119617634,0.1672485816055538},
{-0.7394398959027432,0.08609401116608921,0.6676948865976688},
{-0.7675118479299805,0.10897740680547797,0.6317036394489586},
{0.3427879677067781,-0.0435516317855031,0.9384027198193091},
{0.35420217269528886,-0.03396342841102069,0.9345519281390984},
{0.5881159793684213,-0.1076915962220927,0.8015747718801163},
{0.8703069653037883,-0.08410861597536662,0.4852746921717832},
{0.9822379715322884,-0.11007379680978623,0.15196159559577313},
{0.9904815686811849,-0.007483801274507781,-0.13744182340664415},
{0.9910673323359903,-0.02816699807692982,-0.13035399110022755},
{0.9430433338339318,0.07560399469545154,-0.32396497726987933},
{-0.09681560166211477,0.3837600065883304,-0.9183436157659765},
{0.01724400104908471,0.30513721856383497,-0.9521522579267172},
{0.4093132055600451,0.2448548033260685,-0.878924811939174},
{0.5577398386599167,0.14358160995240557,-0.8175026566654603},
{0.6982347845247993,-0.07373059836588518,0.7120617842183471},
{0.46243064651355187,-0.3090926310900591,0.8310352835896216},
{0.6984440309292256,-0.1512636066984125,0.6994964309758291},
{0.6151936527787699,-0.2984062256009038,0.7297194626041824},
{0.4282848507390806,-0.36140964281634747,0.8282240981200459},
{-0.5653741435804375,-0.23206042011049996,0.7915175545676957},
{-0.5756370749523868,-0.22483023397697097,0.7861891145456803},
{-0.6014176732192863,-0.2246052273444483,0.7667132933431168},
{-0.7395244433762307,-0.09171380537940188,0.6668524391137108},
{-0.7679318874046915,-0.06527060742898869,0.6371972725247017},
{-0.8982134203952834,0.10038300227934667,0.4279438097171062},
{-0.9085873423647083,0.03908900612477711,0.41586186516055235},
{-0.06646060088748564,-0.42251360564206086,0.9039166120705049},
{-0.5957121956068491,-0.5944001956165246,0.5401993960162348},
{-0.16138698534707915,-0.8257127250304901,0.5405115509249586},
{0.34265382714370773,-0.7199704570332683,0.603515447808154},
{0.585034993999811,-0.25341799740091464,0.7703981920987037},
{0.31531399032068674,0.07078259782715972,0.9463439709497199},
{-0.10152839409158779,0.15303339109427105,0.9829917427951117},
{-0.48732562568669074,-0.007849200413727442,0.8731850460251485},
{-0.7325919694595601,-0.2736041885939341,0.6232573740175223},
{-0.6676885375193387,-0.44059795876992,0.6000545438483625},
{-0.7718884127681922,-0.2920000048301181,0.5647338093415444},
{0.08049760874657282,-0.29846423243002096,0.9510201033343313},
{0.0845296116570924,-0.47887446603938894,0.8738043205023601},
{0.8025251754539493,-0.012457599618971615,0.5964881817558008},
{0.04817660254566524,-0.11411920603009097,0.9922982524333189},
{-0.7283123614782055,-0.19578358964464207,0.6566809652669233},
{-0.8838260387148869,-0.19908140872051044,0.4233416185439466},
{-0.9379512180713563,-0.20875980402214178,0.2768878053347531},
{-0.9095537882212966,-0.3031453960742732,0.2842793963185875},
{-0.8532326085654829,0.04764560047830752,-0.519349605213678},
{-0.886414142498584,-0.0033562005395376734,-0.4628808744120225},
{-0.216640399796891,0.2518533997638774,-0.9432055991157071},
{-0.13746322106322703,0.2675524409965499,-0.953687346131692},
{0.7174593154567191,0.28627404606848283,-0.6350585021964167},
{0.5906834593137779,0.38476603863647607,-0.7092588712205878},
{0.9923134212899662,0.12040322685041381,0.02858560637470756},
{0.9599690624493877,0.27598341795369885,0.04788060311480282},
{0.8252148796686579,-0.17489541688491503,0.537058651849213},
{-0.9857995734668893,-0.08826579762429784,-0.14285779615493674},
{-0.956062430352841,-0.17249240547624753,-0.23704640752569256},
{-0.9585905237046906,-0.14859438817320372,-0.24294838066346222},
{-0.7750614672856001,-0.0578184050194033,-0.6292350546259362},
{-0.12541438724129905,0.13923938583484938,-0.9822849000698441},
{0.5627466084184755,0.1784258026691822,-0.8071434120745588},
{0.9340134284078695,0.3114680094732498,-0.17494740532099742},
{0.8171060975063059,0.045960805484561155,0.5746522685739832},
{0.11018901471299578,-0.11814381577516114,0.9868639317710746},
{-0.7590735264143241,-0.16753542790095707,0.6290781047651915},
{-0.9246598508195657,-0.17568640965577453,0.3378438185679914},
{0.9817642001081707,0.10622300001170365,-0.15765700001737065},
{0.8962266573246306,-0.046240002957612415,0.44117982821883334},
{0.9071363376597605,0.024412798322303243,0.42012817112794437},
{0.16151542682605746,0.00021560003580895683,0.9868701639090225},
{-0.757902131371038,-0.1019810176768894,0.6443479116881066},
{-0.9410082861699018,-0.10162460930595696,0.3227628295560005},
{0.9800693906480603,-0.020003199809127067,-0.1976457981140401},
{0.9757056502623461,0.021646001115068668,-0.21801361123071858},
{0.975334354324235,0.13217479381013822,-0.17678439172103155},
{0.9190061422162668,0.23396583620623,0.31731324910424813},
{0.1385530011368052,0.3798034031162261,0.9146324075044125},
{-0.7168509875533164,0.0907091984250162,0.6913005879969479},
{-0.9111034905947236,0.024406402426827803,0.4114544409125876},
{0.6701425502905028,-0.004602999658561006,-0.7422181449441156},
{-0.04109119706257616,-0.03592539743185581,-0.9985093286210839},
{0.5987138190983244,0.06580060209896817,-0.7982556254634927},
{0.6195838418552939,0.2373102160312264,-0.7481976505436561},
{0.941948310493972,0.2498832293122141,-0.2242582263063078},
{0.9157886425452518,0.39175201819981986,0.08866520411916382},
{0.7519048291423128,0.46523501803156986,0.4671140181043961},
{0.20971420001025498,0.5472366000267598,0.8102790000396226},
{-0.5215323734259028,0.43249817796254036,0.7354925625238012},
{-0.8191758535328981,0.27543861799983166,0.5030750328758036},
{-0.9618609759504941,0.10969059725739505,0.25058219373466845},
{-0.7601368305053862,-0.12319520494400106,-0.6379772256029452},
{-0.963764658525613,-0.13967600848197112,-0.22726261380075896},
{-0.8964997638092197,-0.05106439793858238,-0.44009158223395206},
{-0.992006255617229,-0.08208400460207269,-0.09584260537345415},
{-0.9981061165827737,0.050453005893112246,-0.035194804110893436},
{-0.9140139627436948,0.11884519515572733,-0.3878843841893673},
{-0.2610121925988898,0.030757799127849705,-0.9648453726414046},
{-0.2576872239089381,0.2758106255904778,-0.9260268859193528},
{0.7268238165301397,0.5480258124637403,0.41399860941556227},
{0.08510320172563082,0.6634706134531406,0.7433466150727799},
{-0.5088936659315145,0.5059262655470624,0.6964666902331994},
{-0.8140986472120729,0.3231234187389163,0.48252942798335885},
{-0.8477842256488813,0.2496766075537212,-0.46789261415563266},
{-0.9915366597437741,0.1269920076517411,-0.026983001625826276},
{0.659711448084799,0.30703342237893616,-0.6859382499964083},
{-0.1528934094955831,0.3472340215652821,-0.9252308574622968},
{0.932215829728531,0.3611910115184465,0.022687000723492546},
{-0.972998804293688,0.19053620084080575,0.1302662005748439},
{-0.8995615039044332,0.1866790215624811,-0.3948924456123073},
{-0.9772505663160694,0.07391099745243136,0.1987925931480051},
{-0.720897379515586,0.2353883933114012,0.6518429814777776},
{-0.8720649554898233,0.09910441767039059,0.4792504854507142},
{-0.984259734723365,-0.07608979495368387,0.15950898942127803},
{-0.9790401936523342,-0.1976087987187915,0.049305799680322886},
{-0.8601977886812595,-0.301372596034449,-0.41138099458692545},
{-0.3135779942403751,0.2873751947216534,-0.9050327833768649},
{-0.7607115616472976,0.4652595765430644,-0.4526051771810597},
{0.5854526289646022,-0.03380660167254312,-0.8100014400738988},
{0.561012263251275,0.27269943074547176,-0.7816010881215414},
{0.9029390550815414,0.27939501704379505,-0.3265570199207952},
{0.8849121277431453,-0.14453182086416136,-0.44276526391620785},
{0.9759105786426852,0.026100799428797065,-0.21660399525972995},
{0.9553625032080268,0.2868648309900725,0.0706474076320554},
{0.8599443216878667,0.4816557561372884,-0.16882978462525974},
{0.365302824039513,0.5547958365094953,-0.7474994491907577},
{-0.2504679676033681,-0.21511717217579593,-0.9439228779088508},
{0.5531236023091693,-0.35418780147865614,-0.7540592031480313},
{0.8256926762664452,-0.37511723464831265,-0.4213296389167964},
{0.9101052098135552,-0.052047200561218726,-0.4110956044327946},
{0.9561026668930369,0.2874208201091914,-0.05706980399284788},
{0.8690201624318942,0.37108358395790114,0.3272627858522926},
{0.8792310095825805,0.4442106048413714,0.1721330018760466},
{0.25176838863243595,0.5166131766744609,0.8183663630500393},
{0.212533004188609,0.5632754111010545,0.7984676157362319},
{-0.6821454670412325,0.2902944285301262,0.6711234659579907},
{0.1868946009109953,0.6716228032737448,0.7169332034946049},
{-0.9076643187914287,0.1545978202331364,0.3901858510659434},
{0.9617718330652929,0.15203000522672477,0.22777580783083218},
{0.8894505769853954,0.43725418868601307,0.13299039655886288},
{0.36907261236438305,0.6061618203071609,0.7045234236023946},
{0.5126967960359001,0.3197687975275924,0.7967997938392556},
{-0.4273430531207704,0.24926343098462786,0.8690487080268804},
{-0.4263728388970579,0.5672666517504911,0.7045670642761062},
{0.12280139320408757,0.894599350492265,0.4296647762220598},
{0.9163542515857975,0.39633962231178116,-0.05665500318937084},
{0.9688778321543817,0.15048680499424183,-0.1965438065227466},
{0.9504418395496725,0.10226920425561394,-0.2936006122172737},
{-0.9831485199887814,-0.1610876196600074,0.08642781054811909},
{-0.9292544720598214,-0.22613401753575302,0.2921464226547406},
{-0.8688796298598483,0.2406304082694855,0.43260281486679397},
{-0.7190813798555682,-0.6302621823437599,-0.2927311917993934},
{-0.5991571573550507,-0.7936013435155058,0.10586599246499884},
{-0.7397158460860296,-0.601578237479733,-0.3015362187864126},
{-0.8234298944131102,-0.4940238566439585,-0.27911223200254703},
{-0.98395693317919,-0.16441242225332478,-0.06926260937473776},
{-0.3942785491844533,-0.4938523363511495,-0.7750189001137415},
{0.977441672007075,0.03602660265404101,-0.20811021533125537},
{0.9856982632515793,0.04446478622403481,-0.16254789020122995},
{0.8984498435770824,-0.009458671982450154,-0.43897427270928385},
{0.8786873195135041,-0.11744281597383067,-0.4627264629371333},
{0.8842081628942312,-0.19165168383487954,-0.4259642669925074},
{-0.776542263975607,-0.15640178990663625,-0.6103446504833471},
{-0.6938587405789348,0.04117476117684162,-0.7189330199429182},
{-0.6443462416729856,0.029477478079306646,-0.764165557407544},
{-0.973319046578476,0.04103860196391465,-0.22575621080363145},
{-0.929825630671359,-0.12748440420521848,-0.3452130113872449},
{-0.9399473671205852,0.028714998995547632,0.34010938810295344},
{-0.9761913379197191,-0.16991742400652668,0.13482781904894484},
{-0.9542764705381154,-0.2479518183280784,-0.1669620123414818},
{-0.9367736220315295,-0.2815090066206753,0.20786500488867735},
{0.3238915762144304,-0.038671444471890214,0.9453035312743677},
{0.3171469708448806,-0.036211755041549595,0.9476848145247064},
{0.33991741217036925,-0.17479400625830724,0.9240688330852688},
{0.34478616507560433,-0.13141078668901837,0.9294373058545861},
{0.33424279388623807,-0.2852513947823584,0.8982835835691537},
{-0.06950359797434826,-0.626817981731666,-0.7760595773820854},
{-0.12665571371211562,-0.4571034346594276,-0.8803492376361947},
{-0.10518455211873691,-0.4709954996089333,-0.8758421372277724},
{-0.0498600010649847,-0.62393501332694,-0.7798840166579327},
{-0.027132199946346077,-0.7822729984530552,-0.6223445987693136},
{-0.046652597449578136,-0.7995349562907204,-0.5988049672643033},
{0.011904198655295605,-0.9994372871030507,-0.031359196457649056},
{0.011904198655295605,-0.9994372871030507,-0.031359196457649056},
{0.012130999189531368,-0.9994411332276201,-0.031148997918944238},
{0.013966798754398204,-0.997326711055356,-0.07172419360341724},
{0.011900199091425069,-0.9994377236933724,-0.03134679760668589},
{0.006474799946342944,-0.9989241917218553,-0.04591879961946815},
{0.011871398746198726,-0.9994390944439457,-0.03131399669276302},
{0.011836800893232255,-0.9994404754200799,-0.0312830023606874},
{0.8940334541827561,-0.18303241109265034,-0.4089050247816244},
{0.24268940204399808,-0.19373720163170896,0.9505618080058976},
{0.24268940204399808,-0.19373720163170896,0.9505618080058976},
{0.24268940204399808,-0.19373720163170896,0.9505618080058976},
{0.9126267328219331,0.3801320988795191,-0.15037298274695238},
{0.9211768649385311,0.358062425241676,0.1523958107431705},
{0.9320280338221609,0.3398712123335119,0.1257430045630603},
{0.9123557099829489,0.3683901340859594,-0.17859386207156777},
{0.32295100031051094,0.47547000045715493,-0.8183098007867885},
{0.30511839817526387,0.45501319727883,-0.8365797949969015},
{-0.5309031343643177,0.39437060389157336,-0.7500757886429469},
{-0.5485800333257334,0.37902222302525207,-0.7452530452734383},
{-0.5225768078633596,0.4014336060404839,-0.752173211318161},
{-0.5089262480127225,0.4127906896118749,-0.7553793223629077},
{-0.9720012639506869,0.1757236115613488,0.15599601026341464},
{-0.9724508498274881,0.15855980812445888,0.17087460875545796},
{-0.9250349770822145,0.11292563046333728,0.3627093783719477},
{-0.9231856475122729,0.10696214471760052,0.3691711795695278},
{-0.03957260390902237,0.118529211708437,0.9921616980067492},
{0.06993019740098691,0.13702459490736865,0.9880961632765964},
{0.649690952194312,0.2605073808312945,0.7141691474498648},
{0.7160520261359997,0.21741040793551045,0.6633266242115151},
{0.9657924095741418,0.24228595065401,-0.09242586069199255},
{0.9691950979409106,0.1945902196640938,0.15098181525729598},
{0.9674895879851533,0.22873739715940633,0.1079031986599955},
{0.9640246595098216,0.2623171277754922,-0.04296720066037057},
{0.072035607532931,0.38581564034563876,-0.9197592961813685},
{-0.040628198484813624,0.3044321886465184,-0.9516671645085636},
{-0.4298302035827035,0.2346392019557553,-0.8718890072673345},
{-0.5746974568816836,0.12979501284668787,-0.8080074799739503},
{-0.9921709875855798,-0.03162099960434604,-0.12081739848828683},
{-0.9499029664085821,0.052558998141356186,-0.3080939891048725},
{-0.9921340755526002,-0.052311203983582036,-0.11372560866038739},
{-0.9765812836779021,-0.13392141147499234,0.16838661442812686},
{-0.8597422157572523,-0.10517160192757252,0.4997822091599485},
{-0.5717975895385744,-0.12181359777133743,0.8113007851567007},
{-0.3375512458589898,-0.042386223409696375,0.940352361875115},
{-0.32584512387397047,-0.051692138659340074,0.9440089396019407},
{0.7482149579172644,0.10420439413910947,0.6552219631475791},
{0.7751140080802691,0.12775740133182237,0.6187700064504423},
{-0.6841966926277175,-0.09055981226014216,0.7236530979693931},
{-0.6827297750000474,-0.1680769938454173,0.7110767739620473},
{-0.44076667406828934,-0.32009025378931516,0.8386101409235821},
{-0.5954274199532257,-0.3131444104937074,0.7398694247935871},
{-0.40541240842511045,-0.37156020772160825,0.8352148173570837},
{0.584046460173766,-0.2180654455715664,0.7818805495765755},
{0.5940344138057537,-0.21059246133331772,0.7763851688717589},
{0.61947505272314,-0.20974101785092877,0.7564782643833989},
{0.7526146286186987,-0.0735462027966459,0.654341024881776},
{0.7798663862745702,-0.0464281991828767,0.6242217890138715},
{0.9025515757752813,0.12230499671730213,0.41284638891909575},
{0.914210217080793,0.061280801144949666,0.40058000748430067},
{0.19047699947777683,-0.8214293977479199,0.5375613985261893},
{0.6189785710029096,-0.5796123728470852,0.5300141751705961},
{0.09187240774495271,-0.42058623545591745,0.9025888760893106},
{0.7493824377360229,-0.25556241286914205,0.6108304307590757},
{0.5019441284717119,0.004194399402287642,0.8648898767510391},
{0.11423899978340743,0.1556603997048741,0.981182598139717},
{-0.3010330256207895,0.06327920538566556,0.951511880982761},
{-0.5656929918416437,-0.2674269961432,0.7800475887502474},
{-0.3148615769810251,-0.7279743467790787,0.6090283554750104},
{-0.63898364413018,-0.40865982822330743,-0.6516878450075714},
{-0.42278060359863245,-0.4050372034476038,-0.8106796069003589},
{-0.44616817824064614,-0.4224019793997094,-0.7889933615212681},
{-0.7272169301514863,-0.3970379618648709,-0.5599253462196883},
{-0.9268748870922642,-0.30190382836789337,-0.22306282095972862},
{-0.9611056979422116,-0.27333162785406867,-0.03956840403224849},
{-0.9628254456776149,-0.2622282124404266,0.06483460307583273},
{-0.8813442675908234,-0.2255996173013707,0.41513503183695594},
{-0.93548896359563,-0.31658245536303287,0.15695842744844013},
{-0.7967523265321514,-0.2916736463206605,0.5292562840511337},
{-0.43752401027498894,-0.2267092053241297,0.8701584204351487},
{-0.6284769961463048,-0.08714019946567372,0.7729315952605381},
{-0.11656861519601157,-0.05799520756031839,0.9914879292514457},
{-0.24397140165593637,0.014818400100578707,0.9696692065815523},
{0.01308380096779885,0.0005088000376355534,0.9999142739629017},
{-0.06221979994692527,0.04041659996552383,0.997243799149331},
{-0.1080394090550231,-0.4327364362686029,-0.8950232750138907},
{-0.13831500121758697,-0.4503112039640896,-0.8820934077650683},
{-0.08609480582614591,-0.41967762840012324,-0.9035808611464754},
{-0.05509499839457254,-0.4007773883216436,-0.9145173733516408},
{-0.6536962220261769,0.3377846113815919,-0.6771874228177088},
{-0.47275339790719634,0.575071397454251,-0.6676803970442856},
{-0.8431037290742671,0.53770048231881,0.007368401128059267},
{-0.9658889586687559,0.25021084110269876,-0.06673121096208641},
{-0.7541356255926487,0.4172172141588505,0.5071580172111176},
{-0.4813369741961512,0.8367265551441784,0.261157785999671},
{-0.425829756782191,0.8001427187928636,-0.4224223571280108},
{-0.2181608006952785,0.5263794016775711,-0.8217850026190289},
{-0.20601501325565327,0.4385974282207366,-0.8747514562842572},
{-0.39988746475472614,0.2745524444589289,-0.8744775416062235},
{-0.12741181002038374,-0.2815972221463946,-0.951035874794828},
{-0.0395660049827586,-0.21063142652594194,-0.97676452300918},
{-0.20248919824141776,-0.4584051960188334,-0.8653685924844297},
{-0.26384484738600145,-0.5163998912407568,-0.8146883139179009},
{-0.9082541394003641,-0.3150268473932051,-0.2753770209796053},
{-0.2701578200261029,-0.4565044338394971,-0.8477136628388289},
{-0.12828379181036814,-0.4435901716812221,-0.8870011433738842},
{-0.0994478078199832,-0.3884968305490765,-0.9160678720341207},
{-0.017894399479514555,-0.18354099466143492,-0.9828491714123581},
{-0.03362399548163939,0.12146158367810765,-0.9920264666924248},
{-0.07685399781334394,0.1142019967507157,-0.9904803718187737},
{-0.20159980357819496,0.1373564024379388,-0.9697890172127853},
{-0.14479936383256872,-0.22428619463657865,-0.9637057886767757},
{-0.742798395437429,-0.6354305617457316,-0.21089937158532468},
{-0.9043452130593057,-0.3673114053042045,-0.21735240313870346},
{-0.9033420294926362,-0.2819658092057214,-0.3232158105524663},
{-0.2114393848186781,0.5194991627000238,-0.8278973405570725},
{-0.12532599389666935,0.4203181795306564,-0.898680156234601},
{-0.02039620008111895,0.09536700037928982,-0.9952332039582017},
{-0.0640004032777961,0.321879416485132,-0.9446150483786877},
{-0.36380816967025276,0.8697277274930463,-0.33349257219758577},
{-0.45277607111073326,0.6832249073038689,-0.5728852899744833},
{-0.8288076252441545,0.5539800168733452,-0.07863880239521213},
{-0.534309006336969,0.8408350099724041,0.08666240102782648},
{-0.47908523315572715,0.25770641783491344,-0.8390856580700325},
{-0.5738735682971475,0.1476371918439873,-0.8055261554998204},
{-0.5128538145695104,0.06408800182065685,-0.8560804243201323},
{-0.07117867908626838,-0.1153779819630961,-0.9907681448864096},
{-0.09237528682855828,-0.014875634535476186,-0.995613138664064},
{0.9132201992749214,-0.34673339972470063,-0.21402059983007193},
{-0.9300370982986738,-0.35283872434985497,-0.10264419314968645},
{-0.08501620527744912,0.41427362571636756,-0.9061730562514192},
{-0.3247067873898108,0.9134751645246263,0.24521139047706378},
{-0.46297920802601317,0.6424638111374829,0.6106476105859305},
{-0.7336089394122673,0.41673856558214667,0.5367931556670066},
{-0.9444841566971025,0.2921023866076317,-0.15041899310356008},
{0.6143050056651301,-0.4850014487600964,0.6224170263700792},
{-0.2965167198801098,-0.42935110549278266,0.8530741251753365},
{0.08597179538829075,-0.35898718074316704,0.9293745501463802},
{0.6588832385860353,-0.31347021835768796,0.6838196400463803},
{0.0752578003786205,-0.13856460069711574,0.9874898049680415},
{-0.7767789620246757,0.22287118910422898,0.5890185712039431},
{-0.5471670052835541,-0.0029644000286248398,0.8370182080824153},
{-0.525828161600222,0.14832318916836726,0.8375589388353846},
{-0.5299806043658001,0.3284184027053991,0.7818324064404695},
{-0.756063994304328,0.16503419875674458,0.6333489952287794},
{-0.9266402987876821,-0.07371280785840788,0.3686518393013996},
{-0.9693090922704819,-0.17025441303280336,0.17735083446273914},
{-0.8615988356420009,0.20563040850637085,0.46407281919743065},
{-0.9451327797916247,0.24359439479158163,-0.217682795345611},
{-0.8812537398453044,0.20053778631121896,0.42799117078516963},
{-0.9127145465558826,0.3747502601741863,-0.162832426146236},
{-0.7554520872192754,0.26291223035402855,0.6001410692881389},
{-0.9060735038386208,0.37922964346080423,-0.18765842150619305},
{-0.5112451976636402,0.22196199898564697,-0.8302777962056803},
{-0.5236921403449958,0.22247117465778488,-0.8223461063246196},
{0.6115062194402477,-0.26603500845745526,0.7451748236896744},
{0.5771076064001694,-0.3272392036291089,0.7482388082980282},
{0.09496379854032856,-0.14401239778641137,0.9850087848596074},
{-0.6523682268303269,0.24080640990378507,0.7186292295554817},
{-0.9229929295095588,0.3281678460468023,-0.200972428199404},
{-0.48679459411078824,0.1873915977329477,-0.8531795896782846},
{-0.0944624982462401,0.10124702574533559,-0.990366536289874},
{0.9213852424682499,-0.32927021517663746,-0.20647120951661754},
{0.9225230465104027,-0.34190901723786327,0.1790236090257476},
{0.9449403181777776,-0.3042312380482988,0.12054521507583638},
{0.8604680910927194,-0.440238446605467,0.25648542715261063},
{-0.8860702804378003,0.36161323282738816,-0.2900264263287104},
{-0.8925880291053325,0.18017380587507156,-0.41330861347708486},
{-0.8568427613979834,0.34287618455292757,0.3850407826533509},
{-0.6102880291809228,0.4396906210238076,0.6589542315078973},
{-0.2744507995676851,0.28113759955715206,0.919585998551468},
{-0.45340175735184474,0.0939689911610309,0.8863389166286432},
{-0.9985183585124254,0.045799407270547474,0.029385404664863418},
{-0.42682539290249133,-0.2737451954480007,-0.8619069856676937},
{-0.46046856844188905,-0.11217819231189254,-0.8805593396510614},
{-0.4955486420993367,-0.06196480526422026,-0.866367073602218},
{-0.5510344910636039,0.07555361248594117,-0.8310551373396349},
{0.25110220974258013,0.17745080688496012,0.9515560369196708},
{0.37712841950441117,0.10455640540747133,0.9202402475931889},
{0.38263862790247655,-0.16967541237293854,0.9081838662258779},
{0.8732424224283587,-0.31505320809182674,-0.3717380095477192},
{0.9704304701492382,-0.24137121744793422,-0.002153600155676697},
{0.94980368644405,-0.25500642320878336,-0.1812310164942959},
{0.8562180130459371,-0.30791760469164825,-0.4148222063205216},
{0.7994883796323943,-0.420540989286382,-0.42890978907318017},
{0.9009585840394467,-0.39812239294723,-0.17254619694333034},
{0.8238742659983457,-0.5470774438248986,-0.14811301186493395},
{0.7921262357839071,-0.5517509078600351,-0.2609731063892315},
{-0.1501593847956385,-0.13296961741092886,-0.9796791515610539},
{0.2763424163247795,-0.13144660776513759,0.9520276562405214},
{0.6632790460018128,-0.09043860627238243,0.742887451523065},
{0.5065847903692863,0.16227279691502217,0.8467817839017808},
{0.6293034488727901,-0.05837700453365876,0.7749640601850443},
{0.685369275648241,-0.3594154396707976,0.6333162699028444},
{-0.17892255208139232,0.0820171472332126,-0.9804386303672489},
{-0.22790554898530002,-0.06917565877872713,-0.9712228317817895},
{-0.21785222947693772,-0.20664197041900936,-0.953855073988327},
{-0.3217749991846158,0.746295198108873,0.5826699985235025},
{-0.2673181894624562,0.7554805702193493,0.5981555764210187},
{-0.5787156058979338,0.33986160346367233,0.741338207555289},
{-0.1806897971426908,0.7297941884595164,0.6593569895733637},
{-0.3297509656539128,0.7398053229436127,0.5864745389141875},
{-0.47919026170802703,0.5791474745800799,0.6595186849299329},
{-0.822953420045154,0.4316548105140668,0.3693532089965505},
{-0.9735876089814625,0.21755000200692487,-0.06927600063907943},
{-0.9976029806510913,-0.06876879866620166,0.007690599850837742},
{-0.984114452314325,-0.17751480943647094,0.0026902001430077612},
{-0.9800969591418364,-0.198514991724331,-0.001322399944871951},
{0.5727838178538324,0.28969400902984355,0.7668090239016525},
{0.5948634327544069,0.20815241146130084,0.7764084427506494},
{0.11738019365307936,0.6068105671888554,0.7861315574927042},
{0.057881001020758084,0.72108581271668,0.6904238121759416},
{-0.07890360028203144,0.7023242025103735,0.7074708025287695},
{-0.014383999392411534,0.6840379711058399,0.7293045691937526},
{-0.2433444157668254,0.22443841454186358,0.9436158611389683},
{-0.3060106481632339,0.22592203555803012,0.924833345560179},
{-0.2959202292524322,-0.29607942926816955,0.9081674897745585},
{-0.4546670634529943,-0.2724094380172568,0.847980518343525},
{-0.7842074906858536,-0.1225960141770186,0.6082670703400811},
{-0.9598360172223378,0.10319820185168535,0.260892604681196},
{-0.10667078587762306,-0.8771792838683301,0.4681643380187069},
{-0.25174218252143515,-0.7755271461548264,0.5789503598032348},
{-0.6356811842828973,-0.7340953818496241,0.23877479409633628},
{-0.5519418292620358,-0.8256164437713119,0.11712260620943318},
{-0.8853278172814043,-0.4643778090645527,0.02340740045690731},
{-0.9415801261753942,-0.19454778474647766,0.27491457844531786},
{-0.7775880757554333,-0.3673168357853302,0.5103284497180371},
{-0.40117301269014566,-0.37918381199457,0.8338344263763513},
{0.09087200776445,-0.33086142827005893,0.9392938802568418},
{0.2587081993751369,-0.5512283986686071,0.7932321980840904},
{0.2381604228820306,-0.33959863262803375,0.9099188874233912},
{0.46734419894860635,-0.06162259986136641,0.8819251980159153},
{0.24736482293803225,0.11691901084184893,0.9618422891912165},
{0.04950679511322311,0.1663837835763873,0.9848175027894372},
{-0.3148954083870126,0.792894221118167,0.5216892138948167},
{0.4135557820797598,0.43261158125403204,0.8011359652850969},
{0.10437099588065638,0.7280883712636048,0.677490973260597},
{-0.3374702220424015,0.6948506453852693,0.6350562414797032},
{-0.6686198009881532,0.6594960009746691,0.34352960050770237},
{-0.9373155115578927,0.3091950367999317,0.16074221913129894},
{-0.9899450810952353,-0.10120900829093299,-0.09882040809526144},
{-0.9436922676322002,-0.32968022362740446,-0.02749280197034431},
{0.44676680272184627,0.04114960025069653,0.8937036054447284},
{-0.08110840385381723,0.1753420083312705,0.98116084661927},
{-0.011838001182514806,0.44081464403360293,0.8975200896545605},
{-0.6390852549547134,0.5764898495721567,0.5091458437812697},
{-0.8566922439689082,0.23998121231680566,0.4566042234347741},
{-0.9949436763542889,0.006716800515462875,0.10020960769031809},
{-0.7599234002662619,-0.008640800003027563,0.6499552002277313},
{-0.3870689864887457,-0.0297103989629116,0.921571967831075},
{-0.5048521774391563,0.28102758744143386,0.8161787635265879},
{-0.12007180099233819,0.6431788053155769,0.7562432062500023},
{-0.4895536089122256,-0.21921200399071072,-0.8439688153642837},
{-0.7326372052746802,-0.1257810009055704,-0.6688960048157704},
{-0.6484912135103936,-0.11435360238239496,-0.7525838156790153},
{-0.19471819222078637,-0.26761798930835645,-0.9436447623003167},
{-0.15214181908255928,-0.24200863035420545,-0.9582717201923113},
{-0.0379850017111993,-0.21325240960688052,-0.9762584439797996},
{-0.10546980675951582,-0.11655320746984635,-0.98756846329285},
{-0.0676318016027628,-0.12295520291383669,-0.9901050234638655},
{-0.9070208180307895,0.015511507885006048,-0.4207999866704977},
{-0.9331482021258662,-0.020813115416569116,-0.3588889063427847},
{-0.8697977141305369,0.05782769062629936,-0.4900080557400275},
{-0.8203069723656257,0.10430801966775169,-0.5623311374282354},
{-0.3417438723785886,-0.11064679367478691,0.9332568846470816},
{-0.2494118017472402,-0.21796679813390013,0.9435487417512944},
{0.10355860895657114,-0.16804501453386778,0.9803246847862661},
{0.08608740729505582,-0.22076701870782003,0.9715198823266954},
{0.6395582214921626,-0.3483320117055929,0.6852956230291541},
{0.8014478276910969,-0.36006081244058374,0.477532816499399},
{0.9017236082048733,-0.35531600323305584,0.2462622022407644},
{0.870584027890779,-0.3922662125669779,0.29700280951503755},
{0.011921399993177621,-0.09286219994685682,-0.9956075994302336},
{0.3813010347724749,-0.25970122368326715,-0.8872230809096737},
{0.03576719793335992,0.007973199539305992,-0.9993283422584902},
{-0.76939679136629,0.4365338607170817,-0.4663333205794941},
{-0.8467107117091661,0.3285400934489657,-0.4185001525370121},
{-0.10137608425408995,0.14392904349691685,0.9843816942524736},
{0.07167980694231293,-0.011316401096012963,0.9973634965963748},
{0.5796105702280256,-0.3602021814980425,-0.7309623624537684},
{0.7796093737775429,-0.36685078766083457,-0.5075723829276103},
{0.7464093692095691,-0.13718879434077028,-0.6511929731373787},
{-0.5276891681730198,0.640765361352956,0.5576413663664865},
{-0.49539980620822166,0.8649652108395192,0.08008880100365204},
{-0.7469990043114243,0.5327848030750527,0.3976592022951537},
{-0.7638717792712548,0.581941584208189,-0.279005192428798},
{-0.49009780790848295,0.6959888112308514,-0.5247892084682821},
{-0.6628670705327588,0.17951721910163485,-0.7268980773460156},
{-0.9350383347178831,-0.16541982383325654,-0.31359144518143706},
{-0.6533407981467857,-0.3491681990095774,-0.6717345980946113},
{-0.7989227132218983,-0.5950835353626844,-0.08716699053201787},
{-0.9158841252099862,-0.10825719115984589,0.3865703684331212},
{-0.7637518868235486,-0.4001880454934996,0.5064904575779905},
{-0.6864643863506581,0.1567285968836807,0.7100723858812474},
{0.06467640427441972,-0.6133094405332051,0.7871902520248701},
{-0.2624881751237186,-0.777909126276731,0.5709267458926697},
{-0.43599041244246023,-0.33895620967326123,0.8336792237918549},
{-0.049124799453398184,-0.14656839836916274,0.9879799890069443},
{-0.27381285137338535,0.1845292346217916,0.9439149770994589},
{-0.6050529912978133,0.24269299650946316,0.7582947890938101},
{-0.8481876898100531,-0.050593605357085986,0.5272740558302266},
{-0.7878375705786793,-0.3585199866112865,0.5007747812988667},
{-0.6997496148019856,-0.5803264122757956,0.41661940881285875},
{-0.7679368528022954,-0.4462688306848389,0.4594748315928656},
{-0.3649018023534269,-0.523597403376931,0.7698652049652303},
{0.13521460069908384,-0.32843580169807224,0.9347978048330728},
{0.24668762211291662,-0.30371902722517435,0.92027168249255},
{0.09056820740661396,-0.07152200584902696,0.993318681233009},
{-0.017024199418577978,0.2050063929984824,0.9786125665777589},
{-0.08862560360293219,0.14802220601760607,0.9850050400438046},
{-0.35140724893623193,-0.0490002068236654,0.9349395301977059},
{0.15497622267513694,0.10752421573226055,0.9820493436872247},
{0.2952040216052451,-0.23634701729764795,0.9257400677526036},
{-0.867950384189659,0.020292199630362977,0.4962361909607006},
{-0.39665281713709977,0.15608580674357506,0.9046014390826548},
{-0.8591379549607249,0.26584378606345893,0.4372745770764057},
{-0.9691779755092411,0.23220199413234394,0.08231819791985044},
{-0.9999883704788837,0.001004399970348647,-0.0047169998607472785},
{-0.998901559173238,0.03852260613851075,-0.02667740425099829},
{-0.9853046486801597,0.16341900807391238,0.04968880245493497},
{-0.9532222663014532,-0.24299861690178878,0.17977481250425187},
{-0.9022821075749876,-0.4304636513222213,-0.024249602891169748},
{-0.983650886160739,-0.16396801436241812,-0.07446760652282644},
{-0.9910452007378728,-0.12393120009227174,0.04970380003700647},
{-0.9835394111101793,-0.1366614015437436,0.11821120133532792},
{-0.9711967272017032,-0.19459382548676837,-0.13751421801081312},
{-0.9727043648946915,-0.20961879243476988,-0.0995297964079279},
{-0.8364992419367028,-0.2658298133270005,-0.47916962402248925},
{-0.8171627625169738,-0.2827393870308238,-0.5022981769597238},
{-0.6599910073822504,-0.29728500332524577,-0.6899518077173732},
{-0.6125418400967574,-0.2534534165909649,-0.7487014490097139},
{-0.4026338327769239,-0.2984398242948769,-0.865343670444412},
{-0.5841420040889006,-0.32088240224612546,-0.7455284052185795},
{0.2897840558724702,0.20307018250243133,-0.9353008617233978},
{0.28584710073018765,0.20662575012438614,-0.9357335274476815},
{-0.5617173988548829,-0.1889137996148803,-0.8054719983579647},
{0.2783822286171399,0.21333138096102933,-0.9364790743457189},
{0.2783823726530261,0.2133314429867768,-0.9364790173993496},
{-0.5287244493834052,-0.2503008233783533,-0.8110486757527771},
{-0.3182399935933198,-0.4335143912726617,-0.8430827830273948},
{-0.343881993169816,-0.042069999164405694,-0.9380699813680542},
{-0.6109781712983358,-0.479785577461315,-0.6296915704192443},
{-0.29367303011392126,0.043608604471728575,-0.9549106979187825},
{-0.4879726283649226,-0.3272302190212715,-0.8091990470372045},
{-0.37872358182419225,0.1289985938090635,-0.91647575601624},
{0.011427801186505004,0.47450264926580005,-0.8801798913857205},
{0.05067240489582105,0.41162103976963305,-0.9099452879162792},
{-0.06743940470758623,0.06277020438165418,-0.995746869507794},
{0.45950619410331334,0.5840851925046333,-0.6691027914136315},
{-0.9828964872618686,-0.10283760912995626,0.15277081356304234},
{0.40480002890001965,-0.6540666639900785,-0.6390099652270167},
{0.4048004000912582,-0.6540664001474527,-0.6390100001440584},
{0.4048003784895671,-0.6540665491885924,-0.6390098612754186},
{-0.9506710592139368,-0.18319121141033243,0.25033081559222087},
{-0.9527423488014839,-0.20081583136387685,0.227936435599635},
{-0.9816320683545575,-0.19045201326185596,-0.011247800783224663},
{-0.9743727536977651,-0.1431590225819346,0.17350282736837283},
{-0.9908463690817494,-0.13032579593332957,-0.035194598901791975},
{-0.9958040054560102,-0.09102980049875228,-0.00937860005138535},
{-0.9891655923506439,-0.10880559915859106,-0.09855339923787276},
{-0.986397948877955,-0.16296619155395142,-0.021473398887098188},
{-0.8774932500500929,0.30584681744476283,0.36940942107022007},
{-0.8779335743775265,0.3982637883766794,0.265741592244337},
{-0.770028839950052,0.45315622351030743,0.44911582330068645},
{-0.7887139482497978,0.2805057815950625,0.5470345641072035},
{-0.8653993066473863,0.15937521964058726,0.47506165854417004},
{-0.7759094032864574,0.15452820065452275,0.6116254025906128},
{-0.976338840877746,0.11677760488929156,0.18200400762021676},
{-0.9458044862278452,0.2319538211469479,0.22726922071985858},
{-0.9571523962613435,0.21945279914281296,0.18894379926198174},
{-0.9892330620168824,0.11815800740754788,0.0863518054135572},
{-0.998381360653372,-0.052892797915472654,-0.0209047991761331},
{-0.995059221615214,0.041395200899208916,-0.09024180196028117},
{-0.996760247806337,0.07624540365686079,-0.025605601228088706},
{-0.9948475902703303,0.019807603788318286,0.09942801901618119},
{-0.41030502949458114,-0.02097640150787861,0.9117070655376273},
{-0.4951202007452748,-0.020304200030562696,0.8685872013074322},
{-0.5129011683798902,0.023146798573011024,0.8581355470963571},
{-0.5806520314278502,0.022788601233435356,0.8138328440487853},
{-0.5474905866433979,-0.09046639779297817,0.8319073797047546},
{-0.37823879485249534,0.016217799779289693,0.925565987403843},
{-0.44716961752008805,0.05885660230599937,0.8925106349685317},
{-0.568533370446067,0.10528639452692276,0.8158949575875294},
{0.6377271964086647,-0.3931171977861762,-0.662391796269767},
{0.7271770579835012,-0.37933183024708683,-0.5721196456195637},
{0.44302741912089544,-0.41157701776350814,-0.7964490343744384},
{0.41886420830481236,-0.3947914078275214,-0.8177362162132399},
{0.10352059835304941,-0.4301611931563936,-0.8967969857324981},
{0.04949439878246949,-0.3995039901724577,-0.9153943774818846},
{0.08112420631610867,-0.4176420325164656,-0.9049828704594893},
{0.13442758315143657,-0.44699114397609135,-0.8843800891556802},
{0.9300796905223541,-0.27929682718326887,-0.2386316232254252},
{0.9666760982139485,-0.24986262538595405,-0.05573140566229104},
{0.9698749215383511,-0.23870042991236912,0.04862860609381733},
{0.8934107621774218,-0.20399403703025348,0.40025447265665604},
{0.9454178554497987,-0.2936860172250084,0.14118640828073836},
{0.8123772050991943,-0.27208520170784617,0.5157644032373913},
{0.457440633415582,-0.2158140157649986,0.8626542630160335},
{0.6432828735496101,-0.07165760819295734,0.7622678871537362},
{0.1345523941069578,-0.05493819759385094,0.989382356667646},
{0.2597604018460964,0.02095060014889424,0.9654458068613462},
{0.003673799903739023,0.00039439998966592373,0.9999931737981592},
{0.07792781124694931,0.04212260607935482,0.9960687437578509},
{0.633839549498836,0.3534577718382532,-0.6879789451852798},
{0.9582597328946696,0.2736300379479302,-0.08285461149055505},
{0.8297623844609735,0.5580773895488401,-0.006634199875760808},
{0.44735820579574037,0.5862808075955493,-0.6753854087499421},
{0.4651278179151331,0.8482530326718064,0.2532250097533615},
{0.7521454378880638,0.4355582219405142,0.4945364249114421},
{0.9612772138504474,0.1265808018238243,0.24479260352706486},
{0.7970421628310237,-0.1033487951804696,0.5950149722522867},
{0.5826118138055464,0.35400800838855967,0.731602217336017},
{0.47530713990482126,-0.2610895669892941,0.8401876937713629},
{0.3158822055032619,0.2334984040679812,0.9196178160214713},
{0.3182168114569446,-0.28860381039077054,0.9030204325119688},
{0.25360040002914375,0.23048300002648708,0.9394490001079614},
{0.009950599456536882,0.6843361626242151,0.7290987601794557},
{0.07363300605666549,0.704182257922345,0.7061908580875619},
{-0.06383480490156718,0.719603455254883,0.6914448530927196},
{-0.118922797431798,0.6039331869577368,0.7881129829802748},
{-0.566729466323798,0.2758208322790436,0.7763636908570872},
{-0.5866536225997283,0.19376760746453292,0.7863152302913166},
{-0.45085322952686585,-0.07280140476784278,0.8896242582624554},
{-0.23397659698651713,0.1110597985696142,0.9658781875600492},
{-0.21453180565405017,-0.3451090090954516,0.9137154240812445},
{-0.03702360198131589,0.16533040884764716,0.9855430527412787},
{0.11826640236384736,-0.27860620556863597,-0.9530958190499838},
{0.2626414369407909,-0.5099904179077621,-0.8191027098257841},
{0.19905119369835383,-0.4535167856423754,-0.8687353724972112},
{0.028300198741263216,-0.2098051906682807,-0.9773335565301394},
{0.09350320784013022,-0.38614783237802597,-0.9176856769468276},
{0.12415479354836584,-0.4405169771087825,-0.8891177537974949},
{0.26694000001886736,-0.4499658000318037,-0.8522170000602347},
{0.9109094432472928,-0.29288026355076996,-0.290628865437242},
{0.9092474126385027,-0.34523340479873055,-0.2325576032325414},
{0.7544054011097814,-0.617204889702637,-0.22345159409488594},
{0.1340387398110333,-0.2208915486666005,-0.9660437567509771},
{0.18190939693353878,0.14202619760585306,-0.9730043835979874},
{0.057434198341582955,0.11583659665520905,-0.9916063713672871},
{0.014020799295881084,0.12204159387112011,-0.992425950160767},
{0.005876400476805042,-0.18325161486884606,-0.9830484797635345},
{0.9043927098972145,-0.2599588315888785,-0.3383714411171811},
{0.09997280682582957,0.4230612288852933,-0.9005690614880298},
{0.184820596499132,0.5243233900682769,-0.8312197842550516},
{0.3990809915288037,0.8101873828023471,-0.42933759088655415},
{0.19147501439758133,0.531370039955309,-0.8252170620505489},
{0.04029999840474879,0.3231491872083336,-0.9454895625733638},
{0.0013802000005067542,0.09563200003511224,-0.9954158003654768},
{0.33688638909401075,0.8782579715682428,-0.33936778901368064},
{0.4263422141742587,0.6939274230704502,-0.5802560192913079},
{0.458535020449406,0.2691208120020511,-0.846947237771527},
{0.8136416547199417,0.5739752386016269,-0.09241040621488834},
{0.5150601682277316,0.8536101473437622,0.07786359519686592},
{0.30643981044313795,0.9211586313920918,0.23991960817620123},
{0.1805879773641472,0.4433053444337621,-0.8779910899479503},
{0.05970220251437623,0.41603501752144,-0.9073866382148614},
{0.3783756043585464,0.28402620327172623,-0.8810000101483273},
{0.9364981140861087,-0.3301177798888533,-0.11829426746218932},
{-0.9079690171148893,-0.36890440695371535,-0.19875060374637737},
{0.07600512581772871,-0.012825694598523934,-0.9970249356999535},
{0.05734544902510503,-0.1138133961810687,-0.9918457593425704},
{0.4967171901636486,0.07637839848749997,-0.864545182879654},
{0.5565240025950825,0.16139860075260487,-0.8150040038003799},
{-0.5917950583030932,-0.4996849473174553,0.6325294952746396},
{-0.6394997585674643,-0.3292783786663904,0.6947055549907372},
{-0.06161560684771123,-0.3607828400959567,0.9306123034245161},
{0.3211424023842374,-0.42182924410620626,0.8478960114351685},
{0.5610328202224732,0.010526200379417741,0.8277266298354731},
{0.7808894976815827,0.24183443025110463,0.5759580720466804},
{-0.05529640289115148,-0.14015380732788874,0.9885844516877637},
{-0.5922700202199093,-0.28068920958263993,0.7552680257846092},
{-0.5563450227740284,-0.34103801396041866,0.7577422310182395},
{-0.0749024053238085,-0.14608021038288505,0.9864330701123113},
{-0.6483331878474612,-0.10640539800550744,0.7538845858689763},
{-0.2570613877799909,-0.13794079344266452,0.9564997545305661},
{-0.23935859754028882,0.17147999823782695,0.9556683901793032},
{-0.49611579917142706,0.15006619974937144,0.8551895985717306},
{-0.6146144385523925,-0.07352060461166389,0.7853940492647387},
{-0.3640805879494425,0.09553279683799822,0.9264549693356381},
{-0.363115386676004,-0.17875499344084306,0.914436366446075},
{-0.6657034268727304,-0.37586441517267705,0.6446432260225844},
{0.7321434055529563,0.434582803296102,0.5245034039781066},
{0.863997626817208,0.22663660703446495,0.44960421395504957},
{0.9344388958594377,0.3149766323118858,-0.1661736170469247},
{0.9351404912209669,0.26648456900152,-0.23344857284439047},
{0.8831628476000059,0.2220160119660417,0.41319762227019546},
{0.5360297977589346,0.1612501993258355,0.8286557965355061},
{0.534861179898334,0.34138118716988475,0.7729051709519364},
{0.45737557140252927,0.6536683591292956,0.6029305623016833},
{0.9004634341226122,0.39682381503744035,-0.1780350067465477},
{0.5042608191985208,0.23498540894650566,-0.8309650316369999},
{0.49169877062728323,0.23417198601121697,-0.8386869498991747},
{0.8932999839651761,0.40113519279958315,-0.20274539636069988},
{0.7587836553883406,0.2813466205372405,0.5874448428812545},
{0.76233403187526,0.18352000767347085,0.620618425949745},
{0.47594137619221355,0.5907747704479579,0.6515097674098405},
{0.2588391849576078,0.7618857557231479,0.5937443654946541},
{0.07535256756289946,0.10331425651836337,-0.9917903785385985},
{0.4677156053024638,0.19901240225619168,-0.8611830097631802},
{0.9112316738067433,0.3504978283891616,-0.21635181752377963},
{0.6582696467952718,0.2567618182527618,0.7076400503049299},
{0.6103654586324656,0.45455064366470055,0.6487200623168565},
{0.2829045861045758,0.2879229858580871,0.9149127550622314},
{0.46577665940815854,0.10515901341265867,0.8786317120663542},
{0.8545778045047532,0.36371060191723503,0.3706904019540278},
{0.9974598465027561,0.07009880326808901,0.012649600589739319},
{0.8808826170412383,0.2017636039032461,-0.42817900828339706},
{0.41885302027748783,-0.2634494127540975,-0.8689974420698531},
{0.4482357615696032,-0.10111539133066806,-0.8881781238502577},
{-0.7827251522077004,-0.5709229579648903,-0.24776664862336145},
{0.1369058326525915,-0.12947482504992527,-0.9820860770136147},
{-0.796092448928337,-0.4399662270405979,-0.4155316255388321},
{-0.8126806426277989,-0.5670006297410662,-0.13438920704916027},
{-0.8937658683707499,-0.41997263212680724,-0.15749781204817043},
{-0.9462191712052265,-0.27808899153736283,-0.16533539496861255},
{-0.8553026296706369,-0.3287536114045353,-0.4004728138924903},
{-0.8714240356526768,-0.3362924137587721,-0.35711001461048514},
{-0.9641673926995752,-0.26492139799408404,0.014067399893485304},
{-0.9164289902373002,-0.3516435962539478,-0.19106199796462037},
{-0.910795561785978,-0.36422786469834045,0.19439523453071628},
{-0.9351009784760516,-0.3271179924704701,0.13630839686248333},
{-0.8450739223305773,-0.4610032667335654,0.2707878391985031},
{0.1604104148904615,0.08614831983565302,-0.9832837666636035},
{0.5350214407689671,0.08877560676475653,-0.8401612640208116},
{0.8720182477967516,0.3830158209937259,-0.30476721670479145},
{0.48231541998478805,-0.05006080207427439,-0.874566036237732},
{0.20679499333056728,-0.20147259941541745,-0.9574155954538266},
{0.21320674875761247,-0.06380598054307099,-0.9749213707428643},
{0.31323058901901896,0.7540293735658569,0.5773441797599415},
{0.1738987902084237,0.7341135586648709,0.6563813630416738},
{0.32143218426835074,0.7477301634043221,0.5810171715636491},
{0.30416336588267245,0.8004467102156746,0.5164975420656207},
{-0.1106758002160458,0.7254700014161609,0.6792968013260281},
{-0.4104746080403028,0.4225796082774134,0.8080452158278444},
{-0.43259016070027584,0.030444397234203356,0.9010765181394728},
{-0.2318774003963202,-0.5571992009523538,0.7973468013628092},
{0.1358250051471104,-0.8742288331290422,0.46612821766400375},
{0.2802173881586747,-0.7690535675016118,0.5744865757235535},
{0.6572782621806035,-0.7183538679585492,0.2279320215630905},
{0.5737674227195035,-0.8119074321491478,0.1076906042642314},
{0.8966387530122949,-0.4426818755441023,0.008467801445038737},
{0.9508448418650147,-0.3066148135000298,-0.043375601909796564},
{0.9903195976369191,-0.07710079981602362,-0.11542339972457899},
{0.9880506669939083,-0.15350621040835385,-0.013846400938843064},
{0.9989700586501333,-0.044462602610426165,-0.009049800531319235},
{0.9760036492997753,-0.1465719542713597,0.16103893558576235},
{0.9844786722855068,-0.17459961282000502,-0.01779660130671835},
{-0.06703079972266408,-0.33278319862312944,0.9406179961082495},
{0.42420804292855807,-0.3691336373551965,0.8269146836812399},
{0.7947466682503354,-0.3481774299003787,0.49714204269298945},
{0.9505138217766331,-0.1715144039294602,0.25904880593490665},
{0.9960255163861064,0.030953403616921515,0.08351680975898322},
{0.9320743580966782,0.3319529850763701,0.14506759347818768},
{0.9667047020975172,0.2411724254711763,-0.08554460903470541},
{0.9342100332680982,-0.05105760181820923,0.3530506125724644},
{0.33116339677811135,0.7030161931603555,0.6293639938769177},
{0.633369747646533,0.5919073510737572,0.49848615879582375},
{0.6580469607643855,0.6756467597150091,0.3323787801821352},
{0.818278174070958,0.45163578568887264,0.3555923887322304},
{0.8581311859488914,0.2608575957286968,0.44222639275894965},
{0.5114736119861183,0.29340280687574233,0.8076568189270178},
{0.11706258986221627,0.6460851440481244,0.7542349346822015},
{0.4030737699032002,-0.02009099849984096,0.9149469316825438},
{0.09325480556275936,0.17746461058597374,0.9796988584401948},
{0.770698826259852,0.009993400340502936,0.6371212217084915},
{0.016149400168578097,0.4411554046050713,0.8972854093664574},
{0.6383742011581385,-0.09868700017903796,-0.7633736013849124},
{0.7241641769034212,-0.1080453965539872,-0.6811111782765586},
{0.4805270128353956,-0.20740200553993163,-0.8521022227605709},
{0.18532818803802215,-0.26299098302528967,-0.9468311388869375},
{0.14190098907828713,-0.2384287816488193,-0.960737126054814},
{0.026792204510022715,-0.21246383576475858,-0.9768015644283227},
{0.09170380813463987,-0.1141528101259917,-0.9892216877494875},
{0.0539958001609658,-0.1214746003621255,-0.9911248029546222},
{0.8991915603922199,0.03749989609239995,-0.4359452895862781},
{0.8079813627551503,0.12412977772400643,-0.5759843016285416},
{0.8597943782460711,0.07888287794773871,-0.504510771642325},
{0.9272296749418951,0.0018349555924803249,-0.37448866851364304},
{-0.02634760211119023,-0.09332860747826854,-0.9952866797506925},
{-0.38968845212135617,-0.2690874359908076,-0.8807581178025864},
{-0.5828462373803667,-0.3743562240090302,-0.7212126462543831},
{-0.7788500530359364,-0.385824226272771,-0.49450203367320616},
{-0.7536624708007893,-0.1554500146033326,-0.6386142599928952},
{-0.6193107814746189,-0.3636569891219651,0.6958503791850976},
{-0.8556769817674917,-0.41327879119397953,0.3114763933631545},
{-0.8885516407089589,-0.37710961727726244,0.261274411970277},
{-0.7843266697701428,-0.3793654337466282,0.49082944366196085},
{-0.06438800023937784,-0.2225986008275637,0.9727816036165491},
{-0.08298760943792576,-0.17031621936954017,0.9818887116671853},
{0.3599344077469319,-0.10210452623238755,0.9273736506083862},
{0.27042782842804985,-0.21163832593101964,0.9391900811916641},
{0.8313250830917863,0.3489703797716877,-0.4325717053442568},
{0.75061509495938,0.4550382741108847,-0.47907948016306046},
{-0.052699998879715035,0.006895999853406353,-0.9985865787722664},
{-0.05465159684660186,-0.012854199258312467,0.9984227423909895},
{0.11433187012960198,0.14655532679686908,0.982573030191716},
{0.7403701676315204,0.5508913759154042,0.3851891831597912},
{0.47546841042784016,0.8767854192294126,0.07195220157803556},
{0.5212089716647251,0.6535351644708753,0.5488469701621987},
{0.6942542424110766,0.17353721060115943,0.6984954426701658},
{0.9246004336878544,-0.0858540031280941,0.3711376135224141},
{0.7816523623279683,-0.3813763816194208,0.4935297762141455},
{0.8115968314931716,-0.5754778223308188,-0.1006770039066665},
{0.9333992741570633,-0.14267261133510828,-0.32925722615895425},
{0.6502926553226096,-0.3332960283546275,-0.6826662580767421},
{0.646020980333597,0.1954513940499984,-0.7378723775374237},
{0.7446937838268746,0.6003085869626062,-0.2916517936659589},
{0.4641434266686981,0.707607240657613,-0.5327878306128602},
{-0.03652199804012445,-0.6145423670218876,0.7880379577116148},
{0.06923380839947524,-0.14512861760706594,0.9869875197417477},
{0.45803021298318713,-0.32806900929934585,0.8261834234187478},
{0.29088459363464225,-0.7711705831246592,0.566287987608056},
{0.7205553963629391,-0.5630345971580378,0.40471219795718283},
{0.8046166240306966,-0.3391314101285057,0.4874238145574097},
{0.8578882783211199,-0.029826802723045238,0.5129698468317075},
{0.6115942581471434,0.25750402448211906,0.7480936711247848},
{0.28502623680998934,0.19133302470988875,0.9392293212976802},
{0.10149700664323505,0.15033640983989716,0.9834110643667344},
{0.028432396961138754,0.20555957802974414,0.9782314954463885},
{-0.07213340485150543,-0.0735008049434732,0.9946830668997992},
{-0.22375880931699033,-0.3094452128848471,0.9242162384830156},
{-0.111488587955777,-0.3314401641941895,0.9368658987894455},
{0.39039638417620426,-0.5144015791499464,0.763532369052018},
{0.786168472100127,-0.42734883919249717,0.4464438409437147},
{0.9119604676162535,-0.4083760302785681,-0.03946040292574591},
{0.9859641666105606,-0.1399891952592996,-0.09098179691892334},
{0.9875316580180198,-0.07885000463248049,0.13624940800472654},
{0.36812103093013404,-0.040240403381064827,0.9289066780482658},
{-0.14106160983562266,0.10392020724591153,0.9845314686471679},
{0.8753964985450702,0.04151480467340154,0.4816196542168522},
{0.961735562169826,-0.21968263704333751,0.16372002760680734},
{0.9994479352364755,0.025346798357545268,-0.021479398608150055},
{0.9970802264241021,0.06282040166483363,-0.04341220115048759},
{0.9944623007970532,-0.09975981011148927,0.03305620335052207},
{-0.2738012234599196,-0.2432720208441072,0.9305114797283672},
{0.8596227247075063,0.2867654416017424,0.4228644613459498},
{0.4078466416578986,0.16587921694308325,0.8978558917079752},
{0.964482476409044,0.25574102026053075,0.06610660523715323},
{0.9817293464317041,0.18736458977640646,0.03319639818863061},
{0.9884181671251925,-0.11265519625308598,0.10167759661820115},
{0.9732038174845995,-0.17092260307079896,-0.15381740276348657},
{0.975713410204284,-0.1858988019441817,-0.11586620121176118},
{0.8345710728634993,-0.2454864214325661,-0.49318104305792243},
{0.8152678296479163,-0.2628670095593851,-0.5159838187641956},
{0.6553720633076862,-0.2812728271704164,-0.700980067713332},
{0.6058922192933173,-0.23862140759837866,-0.7589166241660459},
{0.39521562859618353,-0.2887270208911042,-0.8720328630967249},
{0.5791987899337452,-0.3067201946693196,-0.7552823868734793},
{0.6852523212418888,-0.12418842540650853,-0.7176395273587256},
{0.40403692059824914,-0.4925131423672068,-0.7708339454052758},
{0.4040368363679393,-0.4925131449003478,-0.770833987936544},
{-0.39941495347558975,-0.6638563226730906,-0.6322677263525743},
{-0.07592600145221842,0.4100798078434981,-0.9088838173840028},
{0.3290299883422835,-0.03387839879966938,-0.9437115665637713},
{0.04918759557171082,0.06419059422101221,-0.9967247102662937},
{-0.4847414168153601,0.5725900198627702,-0.6611856229360934},
{-0.037730001206740534,0.47390401515714725,-0.8797678281381252},
{0.36005364621435026,0.13799261771191387,-0.922669718428412},
{0.27647722485366133,0.05054600454378577,-0.9596902862704602},
{0.4821680396788729,-0.3154200259567414,-0.8173274672600214},
{0.6118369907999908,-0.4649005930094293,-0.6399397903774174},
{-0.29915425205514906,0.20630057703322077,-0.9316366273355102},
{0.3145191930165418,-0.4258115905454499,-0.8483879811627328},
{0.520989262121169,-0.23752122832130612,-0.8198498977563989},
{-0.30643996225272574,0.19941520291510623,-0.9307674931909015},
{-0.2991541446852991,0.2063007147572477,-0.9316366313151582},
{0.5525666521261897,-0.1753486165414529,-0.8148146768652691},
{0.9589111029192823,-0.15994441716672647,0.23432302514973233},
{0.9803406582831754,-0.1193616070962817,0.15711460934077173},
{0.9856506516876398,-0.16650240873140654,-0.027744201454909294},
{0.9610352687549065,-0.17751921270017582,0.21189181515927916},
{0.9929959532608336,-0.10617379500252276,-0.051828197560506925},
{0.9974276690597198,-0.0667632046225389,-0.02609060180645646},
{0.9897299297685275,-0.08471381110725885,-0.11514441509717019},
{0.9895741254819457,-0.1389100176143442,-0.038040204823649684},
{0.8758579490772367,0.3271924556904772,0.3547082603738624},
{0.790711826527212,0.2997354100556796,0.5337916179079191},
{0.766189813432135,0.4718596082722085,0.4362358076476849},
{0.872310415753996,0.41957120757748967,0.2510668045342866},
{0.9545600082540422,0.2427252020988351,0.17291520149519082},
{0.9435553065474412,0.2549542287897493,0.21142782387469342},
{0.9873721126295388,0.14222158741511376,0.06978059382526346},
{0.9761208647880919,0.1405476093285696,0.16563341099359008},
{0.9988823456342198,-0.028578004166592147,-0.03764780548894352},
{0.99210406888655,0.06558760455406237,-0.10690080742263644},
{0.9940394097581868,0.10048200098640168,-0.04229680041521501},
{0.9955977834184784,0.04404099926650421,0.08273719862202521},
{0.869105881964858,0.18049301702218892,0.4605184434312201},
{0.7820629859793783,0.1734957968896125,0.5985621892691328},
{0.5264961555065594,0.035797596974796037,0.8494235282164269},
{0.5099543823410042,-0.008072199720471192,0.8601635702137576},
{0.42591763948323147,-0.010799401001121367,0.904697483866872},
{0.39319302858574756,0.02560820186175629,0.9190992668199529},
{0.4605030203266959,0.06990540308563854,0.8849012390597186},
{0.5934836000589091,0.037081600003680715,0.8039914000798041},
{0.5793986906423666,0.1192564186567284,0.8062723261349619},
{0.5633970088605447,-0.07693900121001968,0.8225960129369675},
{-0.3472739544048358,0.6075601202306908,0.7143329062120101},
{-0.4313726221244639,0.2922702149901072,0.8535196437757604},
{-0.9799274540810806,0.19935441100214296,-5.9600003289256324e-05},
{-0.9280343928569194,0.36201579721356447,0.08773099932473452},
{0.10977075434699377,-0.3459037682670759,-0.9318266816252521},
{-0.8800488723327367,0.010134221563720512,-0.47477497813087827},
{-0.9079321332131016,0.1023696150198164,-0.4064230596309729},
{-0.8708570284866046,0.25244380825768953,0.4217584137961397},
{-0.28746801673283534,0.18036341049852878,0.9406546547532891},
{0.4692885974773485,0.008679599953342984,0.8830021952534394},
{0.7203185188956832,0.3450167611528124,0.6017513322457644},
{-0.30335280307926754,0.8149796082726787,0.4937462050119091},
{-0.9150951962031236,0.4015141983340534,-0.037244199845467854},
{0.011424883669609623,-0.13604025939760328,-0.9906374310796907},
{0.8497616872191379,-0.08185770884804165,-0.5207728779771784},
{0.8245467100215907,-0.4659532679391441,-0.32095213831567304},
{0.8793981694532645,-0.4096406012697198,-0.242597274002883},
{-0.10832042208410463,-0.33493046596246845,-0.9359958702524737},
{0.8076320845385214,-0.1996226208954071,0.554870458080813},
{0.9760995032495854,0.0373962039556854,0.21408242264515173},
{0.6414026121154925,0.6617846125004895,0.38812860733138466},
{0.8743769034671062,-0.4478434529943848,-0.18681882210671716},
{0.876839583062809,-0.25809479501459454,-0.4056345921646893},
{0.8547060246412777,-0.07113740205089987,-0.5142150148248809},
{0.6027700620258654,-0.4300047912628342,-0.6721340132862945},
{0.7751128237154143,-0.48627201487801774,-0.4034100123427652},
{0.6398270485723571,-0.19568941485572725,0.7431870564189137},
{0.3408104166009848,-0.043764402131778075,0.9391128457444883},
{0.8575154430617855,-0.4927358247436761,-0.14791440742780615},
{0.9636982730290388,0.254821619310378,0.07969680603942261},
{-0.3713099535858354,0.6868291141455832,0.6248157218973274},
{-0.31880423169882743,0.539893253681794,0.7790244774587036},
{-0.945699263355422,0.3250420217756059,0.0007664000513435936},
{-0.9472318910159172,0.3205480308002437,-0.0008394000806547679},
{-0.8855667445949614,0.2746823507481893,-0.3745946436548857},
{-0.8770349519961509,0.30069501657653414,-0.37468947140685305},
{0.4732715843290694,-0.30774518980996607,-0.8254131726689855},
{0.4361464454591539,-0.5245880546773437,-0.7311522762073478},
{0.9254162942548019,-0.33840123446658704,-0.17055581737132236},
{0.8608071876657866,-0.5065751927414563,0.04891379929913081},
{0.9925617900683078,-0.07481199925142216,0.09604299903898224},
{0.9239727749008158,-0.2546649930821733,0.2853419922488504},
{0.4905035856110873,0.22161219349901082,0.842789575276785},
{0.4782774350119469,0.3799174278115751,0.7917786579615728},
{0.4990329183733822,0.30533470145484193,0.8110097819799881},
{0.5622903963333835,0.29492955426189815,0.7725581325791118},
{0.998812223533095,-0.04414700104015103,-0.020620000485829484},
{0.3121878714712546,0.32764255776530643,0.8917337535650735},
{0.8187886501060906,0.493726217346265,0.2929497717397894},
{0.8187888744455623,0.4937259790641256,0.2929495463067659},
{0.9068404528646467,0.1798160104824502,0.38119102222169143},
{0.7239727727278987,-0.5863299282431106,-0.36342900213811635},
{0.7022636431579085,-0.47950142946796265,-0.5262168323388774},
{0.9601019938761419,0.03285080663365735,-0.27771385607955335},
{0.9319604360554438,-0.30561441182353116,-0.1950630075465471},
{0.9211289604690884,-0.3889919833061294,0.014376199383035068},
{0.5392737913126092,-0.7161574965905698,-0.4430600614820213},
{0.9964851813334014,-0.06882899871066492,0.04774779910556723},
{0.9952271249896669,0.09390801179382155,0.026537803332858517},
{0.11157879318184638,-0.98492053981527,-0.1322183919206394},
{-0.1358017871166399,-0.9745837075423591,-0.17816978309723663},
{-0.13580181425309376,-0.9745837301694341,-0.1781696386441867},
{0.9518376889615222,-0.24163035022452845,-0.1887320527169672},
{0.8761140011923376,-0.2913046303615091,-0.3841430322740441},
{-0.02683819771216881,-0.6972361405638707,-0.7163389389354462},
{-0.4796736250578364,-0.6628882293446846,-0.5748846917601327},
{0.3624103775634786,0.16014539008553372,0.9181569431576767},
{-0.9714323450257903,-0.2323839868491861,0.048133997276054816},
{-0.619673575061634,0.4707273810558782,0.6280289747253763},
{-0.8279101446114554,-0.2802981812475926,0.48579596749945414},
{-0.8445919133260059,-0.4414757546947274,-0.30292516891311194},
{-0.9480720515531256,-0.11555160628332674,0.2963228161130869},
{-0.5711312454592619,-0.6015836478831246,-0.5584856444527337},
{0.8642203775588934,0.2388815937969904,0.44278518850225024},
{0.8655319559835812,0.2292053883438153,0.445330577352821},
{-0.5929826406041556,0.34786702382000045,0.726195649725842},
{-0.21903979605622795,0.7251095869445325,0.6528687882452151},
{-0.07204139536011069,0.5978145614972283,0.7983907485789429},
{-0.10420280682145566,0.5085550332916714,0.8547008559515062},
{-0.7093480197485613,0.2697754075106662,0.651188618129378},
{-0.17535640329780866,0.3529864066383754,0.9190488172839264},
{0.4303352220814217,0.32701221677969705,0.8413528431716158},
{0.3669444355716173,-0.2841904275494384,-0.8857694858665512},
{-0.13141001240994407,-0.2646997378496867,-0.9553352591738282},
{0.9348562951927193,-0.2801808285297057,-0.21804222220237718},
{0.9800398599250095,-0.1865420114062012,0.06873100420259037},
{0.9800775022813247,-0.18347701914774345,0.0760544079370719},
{-0.3024121826583735,0.4050827767707962,0.8628179505222755},
{-0.20591558232339177,0.4142565644385776,0.8865609238941028},
{-0.7272266012371724,0.2873118004887806,0.6233726010604939},
{-0.756886612136026,0.2345160037602625,0.6100204097811528},
{-0.1560950810837514,-0.5789050369789595,-0.8003144905734537},
{-0.9795032935200519,0.06642701842913268,0.19015979913216818},
{-0.6495340166620417,0.3198316082044165,0.6897922176947572},
{-0.11794441026445476,0.39032103396882134,0.9130928794645592},
{0.16192159265327746,0.7750057648363617,0.6108579722840917},
{0.23416880906004758,0.5916608228914997,0.7714288298467671},
{0.12477079507778725,0.19102099246421436,0.9736237615905045},
{-0.8593494616286441,0.38697142775183496,0.33432262397610163},
{-0.9912896673683455,0.08076000548847438,-0.10403180707003307},
{-0.9787785167696392,-0.07070508635913081,-0.19233669923645116},
{-0.15306765815784548,-0.338894479669712,-0.9282891918338101},
{0.20198140218341495,-0.41743520451246624,-0.8859748095773701},
{0.8684331827674201,-0.35710059291394597,-0.34395199317485753},
{0.9633257086006262,-0.24300382739506235,0.11381001283038389},
{0.9843772518377603,0.176002009268347,0.0049718002618172955},
{0.9840352719014722,0.17791261299971575,0.004656800340263007},
{0.8174288558916509,0.5351042365877213,-0.21324521458062923},
{0.818514200789277,0.5564912005366133,-0.14266060013756476},
{0.9195082211087827,0.3861960088657474,-0.07319340168027166},
{0.8920988694566617,0.2726246212258941,0.3603268280541759},
{0.996464847434199,-0.032917601566959505,0.07729320367934826},
{0.9329666792233914,0.08825240749400293,-0.3489766296335472},
{-0.9998327239656891,0.017619713450198984,0.004906096746202878},
{-0.9626194887363112,-0.26995745287187517,0.02206113197394676},
{0.2068008048284183,-0.30135520703608965,-0.9308160217328417},
{-0.8916725095726559,-0.4391304919964629,0.10992973515544512},
{0.13647280246312393,-0.23236320419379802,-0.9630070173807938},
{-0.7871139194180211,-0.5805725337408612,0.20829596953402027},
{-0.2184234229181837,-0.6656162698401104,-0.7136148748763873},
{-0.6873702409973292,-0.6832863945467653,0.24625566961707887},
{-0.7802294010108128,-0.585763622390503,0.2193696890690788},
{-0.164994989850053,-0.09685419404184978,0.9815273396196789},
{0.09215360556225541,0.29827581800348746,0.9500206573418425},
{0.018559200071629235,0.27487440106087774,0.9613010037101413},
{-0.8727151082609318,-0.4698667957323264,0.1326406200277515},
{-0.11510543310784804,0.3420274710778915,0.93261350424338},
{0.01079259925630813,0.2620345819438317,0.9649981335043162},
{-0.1560949916471106,-0.5789049690218813,-0.8003145571739047},
{-0.14829900486177833,-0.5304826173911409,-0.8346230273619647},
{-0.9961371419467571,-0.008159659535352599,0.08743119803830603},
{-0.1284708064776935,-0.47562442398170696,-0.8702164438776369},
{-0.9662652386000641,-0.18563166732536784,0.17852835281591914},
{-0.13006114332099686,-0.45104221891674035,-0.8829750935064354},
{-0.8402928756795359,-0.367833233128269,0.3982544358681024},
{-0.7546758426678942,0.06351920359125138,0.6530158369202366},
{-0.4415444304334597,0.07990960550777135,0.8936738615964909},
{-0.2911516074742811,0.36543400938121734,0.8841316226969322},
{-0.8169770057628088,0.18067600127445602,0.547635603862923},
{0.0015344001861132713,-0.5163270626272856,-0.8563901038748335},
{0.0015344001861132713,-0.5163270626272856,-0.8563901038748335},
{0.0015344001861132713,-0.5163270626272856,-0.8563901038748335},
{-0.976787364323272,0.1160762195273044,0.1800354302870533},
{-0.9877040200510409,-0.11700812864473487,0.10368156348199284},
{-0.04151069870750528,0.4320006578421745,0.9009174731998171},
{-0.9380763551764703,-0.29724355606640723,0.1779298182875077},
{0.07431879852207707,-0.42803179148804865,-0.9007027820883905},
{0.0697857926974336,-0.5111815465086367,-0.8566349103595005},
{-0.9850259612324326,0.1631455935790953,0.055743797806096965},
{-0.9622539265603021,-0.13864498941854547,-0.23418998212650413},
{-0.9018301155315696,0.08208381051558525,0.4242224543462512},
{-0.6674065881458714,0.1451157974225287,0.7304175870267028},
{-0.4270686600008193,-0.031114004371348047,0.9036837269626385},
{-0.03371339980066615,-0.13156579922210404,0.9907339941421861},
{0.32683423262996136,-0.2760514275599876,0.9038666902388189},
{0.6440322410879573,-0.24979121593617548,0.7230676461302566},
{0.8741060187932955,-0.45970471488523984,-0.15687652157545878},
{0.8816207250959425,-0.45357912294911684,-0.13042575016466126},
{0.7460910709479819,-0.6134840583379931,-0.25881542461151563},
{0.7730714665158449,-0.5914780508913652,-0.2291598197171409},
{0.36765516198339937,-0.7951655177775996,-0.4822255501364919},
{-0.9295579413955712,-0.09938081511687061,-0.3550288540036348},
{-0.5386718204981331,-0.5265560200370892,-0.6577016250275862},
{-0.946863199322633,0.2025113998551274,-0.24987839982124202},
{-0.2082276153528142,-0.6101798449891229,-0.7644094563606145},
{0.03947660170859552,-0.6723462290999657,-0.7391834319927615},
{0.8863810500027774,-0.44306802499447817,-0.13423620757257074},
{0.22262919342661044,-0.595893582405539,-0.7715873772179725},
{0.3443094401263409,0.6159792717871525,0.7085340825736296},
{0.9202876113387348,0.38451660473757526,0.07223360088998008},
{0.9746455211841959,0.22314922774563584,-0.01644780204506523},
{0.43837959568728296,0.3028583970205215,0.8462269916749374},
{0.8714021170900315,0.27365403677080785,0.40715085470873374},
{0.8982295411166722,0.12435759184775326,-0.4215671723642155},
{0.8714582436910582,0.031456999261921866,-0.4894598928414172},
{-0.11692550187485025,-0.3486639650132661,-0.9299257317186909},
{-0.02471677509485384,-0.1364802537571425,-0.9903343987579631},
{0.904297582120789,0.42366239162360997,-0.05249819896203817},
{0.29166019009357513,0.8222231720726642,0.4887569833990565},
{-0.7183142934005461,0.3275020425842419,0.6138134798125762},
{-0.4544903753260363,-0.0025661998606828097,0.8907479516419184},
{0.2987218317990243,0.1874996199593881,0.9357398996097795},
{-0.7931168072228196,-0.21910960199540486,0.5682928051753745},
{-0.9729942887686471,0.013667201246892174,0.23042422102216487},
{-0.6223248329281412,-0.21105601116729042,0.7537686398830303},
{-0.3238523950761612,-0.051856999211568264,0.9446853856370413},
{-0.8731095286992515,-0.4309759762347575,-0.22790230100433068},
{-0.8182255107486431,-0.4859521712566795,-0.30717666058970167},
{-0.8769751407407571,-0.2794451811172414,-0.3909283735840637},
{-0.866225290906174,-0.46903364922282337,-0.17222421807410251},
{-0.7697007305282777,-0.5050783544125894,-0.3904569647580978},
{-0.8476261443152702,-0.5134941662660429,-0.13361759122200334},
{0.10073379995683764,-0.3323851502910147,-0.937748800805565},
{-0.6033087560401457,-0.4446874644726029,-0.6620208484830516},
{-0.6507246165924108,0.6460544164733282,0.39896261017289236},
{-0.9681439296327382,0.23130403097119548,0.09589461284011691},
{-0.861222185729612,-0.09202721984642304,-0.49982730779184914},
{-0.8561286305217864,-0.10262601257680495,-0.506469811087962},
{0.3649055881650245,0.6957905774334385,0.6186431799355584},
{0.9389979841182201,0.34351919418987437,-0.016653799718325292},
{0.937382458768089,0.347977221816022,-0.015032600942451204},
{0.3185886305822353,0.547647652570267,0.7736816742679202},
{-0.23553660344515626,0.585942408570486,0.7753670113411694},
{-0.11304340119601275,0.1881262019903978,0.9756176103221514},
{-0.4815570106495275,0.20977600463915025,0.8509388188183249},
{-0.5562766205629319,0.28131114354803216,0.7819337324420673},
{-0.5014562186484423,0.3777299529024523,0.7783712118643115},
{-0.474045871797609,0.36832325578516906,0.7997615211295538},
{-0.3050734138026888,0.32012805852141046,0.8969103847866218},
{-0.9976469493805522,-0.06845079652688606,-0.0038797998031434625},
{-0.9739080581919821,-0.2072618123841009,0.0924426055235383},
{-0.9110165634253627,-0.4112960737815456,0.02973820533467468},
{-0.5290325844391474,-0.7291631523684782,-0.4341032386768151},
{0.48596665674048084,-0.6511330370863145,-0.5829769948730669},
{-0.35075883053978,0.15146081318735127,0.9241362804624609},
{-0.9886965979556465,-0.09893281980821046,0.11265582255581359},
{-0.9196339557062915,-0.36086178261927315,-0.15508759253028384},
{-0.9273842148861675,-0.32824940526898727,-0.17947380288087403},
{-0.9966333415135528,0.06965920989102198,0.04323860613951844},
{-0.9935736717204227,-0.0930590067173995,0.06443120465092157},
{-0.9312825272343915,-0.30289957633299097,-0.2023973841857134},
{-0.4794141561689107,-0.3193387708040199,-0.8174257252657448},
{-0.43544723261840423,-0.5351934400901754,-0.723846454221762},
{-0.8472800433562528,-0.5273684269860233,0.0632382032359685},
{-0.9125841905397691,-0.2770263971282281,0.3007431968823697},
{0.15647748454091803,-0.9710272813375326,-0.18061233548677474},
{0.15647760770845018,-0.9710272478350563,-0.18061240889738653},
{-0.08977160461715303,-0.9873726507827687,-0.13052320671309844},
{-0.9487040934560594,-0.264768384145467,-0.17279538713957324},
{-0.8632677813104945,0.20815879549342042,0.4598245900449265},
{-0.8622346277927713,0.21786400702250214,0.4572600147390543},
{0.9774713648859839,-0.20866019250423326,0.03179079885796898},
{0.8498896792192236,-0.42084723922766964,-0.3171358295606063},
{0.8425167987332591,-0.2599651996091371,0.47178759929065794},
{0.6184737552996254,0.48579956488869197,0.6176479553593103},
{0.12370520232813192,0.39326200740119105,0.9110664171462701},
{0.6530289827582196,0.33569339113676133,0.6788689820759718},
{0.21060401381823107,0.4193268275130321,0.8830690579402646},
{0.7303667082344235,0.30506384520798807,0.6111468905670134},
{0.3068815858664032,0.4124983810021648,0.8577113604976411},
{0.7610746158352534,0.25298700526375895,0.5972964124276121},
{0.8213973977055579,0.20061139943962417,0.533911398508604},
{0.2969506008319071,0.3725940010438221,0.879200802463081},
{0.7637492199290128,0.08200480213980546,0.6402830167073276},
{0.45438804353563844,0.09081800870141732,0.8861622849046128},
{0.8555561088358984,-0.34718724416593516,0.3840374488536758},
{0.9733552186631779,-0.16201888044369905,0.16226367640642067},
{0.1261806560345956,-0.4479236115236939,-0.8851230876450178},
{0.12540359661031575,-0.4725337872273174,-0.8723449764203411},
{0.9965126201287416,-0.009170974248280825,0.0829366695466334},
{0.1471565883317515,-0.5268851582225503,-0.8371003336251619},
{0.9969724703801336,0.010937567249203233,0.07698222474573463},
{0.15670300861731806,-0.5750956316253149,-0.8029378441546773},
{-0.8750756504089623,-0.31262875285019187,-0.36946700658200227},
{0.03179359826618576,-0.6965223620162405,-0.7168303609087755},
{0.21223861839566419,0.7303596633035174,0.6492530562736475},
{0.5964333690783781,0.36234778121436245,0.7162201628681253},
{0.7133916967399442,0.28709703893198035,0.6392554866866552},
{0.10610860075190676,0.5111192036218929,0.852935006044068},
{0.07084479608700256,0.5995553668845315,0.797191555968417},
{-0.17047960849515595,0.7709578384175393,0.6136454305785171},
{0.8551582549788272,0.40784462622066625,0.3199486205697598},
{0.9765534690325867,0.1398546098863255,0.16365821156900265},
{0.04607998034681353,0.43306522125792524,0.9001839531718289},
{-0.27275944627118753,0.23840330105056495,0.9320762578877486},
{-0.2727597477807817,0.23840355885130568,0.9320761037155693},
{-0.9044307973367046,0.15776479953542685,0.396377598832779},
{-0.7154748328865076,-0.6038555536010229,-0.35136054686208895},
{-0.6991049222685259,-0.4965632868454207,-0.5144678899768096},
{-0.965137730071138,0.009413001268585559,-0.26157323525209647},
{0.8808975650319049,-0.4556800924125726,0.12796535976478202},
{0.7978246453958017,-0.5665508163219757,0.2061455983618529},
{0.8043936613070509,-0.5611968301066151,0.19495885598588314},
{0.8923211426494476,-0.4383463814745365,0.10777489609813666},
{-0.1469036015040872,-0.2358122024143868,-0.9606310098355167},
{0.2225674059934332,-0.6602500177796221,-0.7173100193161692},
{0.7078312066094625,-0.6662988181614712,0.23456527421257242},
{0.18373939198445371,-0.09261139595987054,0.9786025573089145},
{-0.08344680441984022,0.29613781568522407,0.9514930503967441},
{-0.009127199661628976,0.27453858982208046,0.9615327643532695},
{0.8904045558837498,-0.4410706537939852,0.11241176639128463},
{0.907719895114846,-0.40991851728639556,0.08950643104501517},
{-0.21498098260316775,-0.30648957519804937,-0.9272795249620773},
{-0.9405557058648742,0.06544040736568865,-0.3332754375120389},
{-0.9939312336870932,-0.05715040193698604,0.09399220318565712},
{-0.9297365279889338,0.363679050064607,-0.05768480794097773},
{-0.8922951607073729,0.2509051889512748,0.3753077834731494},
{-0.8340945953029965,0.5363705969795576,-0.1288129992746205},
{-0.8336720333791452,0.5150016206199959,-0.19940980798410965},
{-0.9878586885833076,0.1539036138008516,0.021187001899881763},
{-0.9881485509583392,0.1519864232187944,0.02150740328566173},
{-0.9739180840848576,-0.2103310181592826,0.0851142073484784},
{-0.9550813443773821,-0.2663601844875509,0.12989179243528148},
{-0.9952748503147677,0.018184200919277572,0.09537980482179644},
{-0.9922177677573483,0.020073199347710555,0.12288599600675326},
{-0.9366920915278858,0.34690482526765554,-0.04759167863326623},
{-0.9441141527865707,0.32703438364560616,-0.041194397939943186},
{-0.8598889834936321,0.4936785963585049,-0.12989372411238587},
{-0.819053637685871,-0.3060558140820813,-0.4852638223277072},
{-0.8541786468792216,-0.44020282415930884,-0.2767676151896215},
{0.9554386951938397,-0.09237800920395778,0.28036262793355055},
{0.576166992007158,-0.5876121918483851,-0.5681051921189949},
{0.8630490774067554,0.32188205619804705,-0.3892791182237569},
{0.8722119653639949,0.2960850893374202,-0.38933264356836184},
{-0.3747140591105105,-0.2932196462549044,-0.8795519387478341},
{0.12177947548612886,-0.2616178376562574,-0.9574580232941743},
{0.9871465693951794,0.10484519674945085,-0.12061979626038592},
{0.18209278606523718,0.3573383726544605,0.9160521298985455},
{-0.42400686205997246,0.31661064634087266,0.8485139241931569},
{-0.20659319723020503,-0.42240899433676266,-0.8825473881676872},
{-0.8651287970426264,-0.37820319870714264,-0.3294153988739198},
{-0.9386654106860847,-0.02075240465793544,-0.3442042772576156},
{-0.17211520822287657,-0.33781861613942665,-0.9253404442085293},
{0.16547339441195125,-0.36276409155130673,-0.9170718453985718},
{0.9816934439227334,-0.050114373401385005,-0.1837567188913366},
{0.9816934461740281,-0.05011438187484949,-0.18375670455322846},
{-0.003321200297090613,-0.51638504619208,-0.8563500766028984},
{-0.003321200297090613,-0.51638504619208,-0.8563500766028984},
{-0.003321200297090613,-0.51638504619208,-0.8563500766028984},
{0.12236540058138738,0.3449194016387948,0.9306220044216084},
{-0.000987800093961268,0.26189122491155015,0.9650968918017},
{0.05201639960904371,-0.570917195708975,-0.8193581938416875},
{0.05201639960904371,-0.570917195708975,-0.8193581938416875},
{0.05201639960904371,-0.570917195708975,-0.8193581938416875},
{0.9377779108961602,-0.28315681948529164,0.2009845899918879},
{0.9049216307046593,-0.2553495116158515,0.34046067203183145},
{0.9215294348695716,-0.25811011527069866,0.290108029988683},
{0.9489509262868152,-0.26818990724497566,0.166031060802872},
{-0.050493403970774176,-0.3641394286357292,-0.9299746731327091},
{-0.022165794748685807,-0.32128154378469825,-0.9467242719855027},
{0.3804210552754888,0.0038456724121371006,0.9248054019666959},
{0.38042100879732726,0.003845600088930426,0.9248054213863477},
{-0.7629634166618089,0.29131720636186675,0.5770798126024307},
{-0.8120311244247779,-0.007038201078439704,0.5835716894187127},
{-0.7328238519377784,0.24888821763957472,0.6332644448816566},
{-0.22824501186102622,0.41249862143598637,0.8819008458290369},
{-0.058632397716162604,0.37073778555909614,0.9268849638961629},
{0.9363016445395672,-0.30020422211930736,0.18225437019244123},
{0.9507830277419974,-0.2673102707063321,0.15670626449720323},
{-0.07896840103156108,-0.42989760561573526,-0.8994176117490563},
{0.04607999844002988,0.4330651853392193,0.9001839695256044},
{-0.0463512024192473,0.35372881846246584,0.9341988487594265},
{-0.0716733987907465,-0.5129037913464309,-0.8554487855671077},
{-0.05834320288486841,-0.5195834256915929,-0.8524254421494728},
{-0.05834320288486841,-0.5195834256915929,-0.8524254421494728},
{-0.05834320288486841,-0.5195834256915929,-0.8524254421494728},
{0.28436316571568027,-0.4190595516062311,-0.8622799326157029},
{0.9035166028982541,-0.4272923445186691,-0.03284814458896416},
{-0.9647586839231653,0.18434241603571888,0.18777261633410777},
{-0.8083293010402637,0.3354324419286822,-0.48382726047786945},
{-0.26410700845229595,-0.22044140705485257,-0.9389638300499416},
{0.08225152930712802,-0.4304929155999293,-0.8988384368421897},
{0.22474105415700238,-0.4341684363757033,-0.8723469650497307},
{0.8605645019475765,-0.509341336741897,0.0003750649237482687},
{0.006686000197575587,0.22631840668785383,0.9740304287832229},
{0.04183020197893587,0.23282241101454448,0.9716192459661221},
{0.056639403218715426,0.24255821378414708,0.9684820550370936},
{-0.46313598124139066,-0.3505105858031088,-0.8140315670289057},
{-0.9344174493378219,0.35586161878971456,-0.015051200794712755},
{-0.7875762266690641,0.6104390206708086,0.08418960285084522},
{-0.7179333883926398,0.3149005949087691,0.6208133899628506},
{-0.9837244969718275,0.007868200775617371,0.17951101769551484},
{0.22741346580365376,-0.699672291796366,-0.6773048055813508},
{0.8116657701811547,-0.5829178481428916,0.03748946295552385},
{0.058646002382448145,0.24661101001838012,0.9673384392973704},
{0.31856082250592793,-0.26979101906040165,0.9086978641983797},
{0.906550037130441,0.10409980426371572,0.40906021675427234},
{0.9612820255633733,-0.11522700306423174,-0.25031900665673346},
{0.9815586911046873,0.18708717924432125,0.03925459564504751},
{0.9256183769193543,-0.0767953980850776,-0.37058479075932754},
{0.5402270249287225,-0.5134214236917808,-0.6667482307670312},
{0.21017439703280413,-0.6050861914575264,-0.7679175891587086},
{-0.035484998954806404,-0.6732589801694803,-0.7385547782462238},
{-0.22096221100060837,-0.601294429935456,-0.7678676382283067},
{-0.35622242125347703,-0.8039782479681576,-0.476156028409136},
{-0.7351702042039827,-0.6315172036112554,-0.2463956014089837},
{-0.7621776028192949,-0.6101682022570122,-0.21628700080004562},
{-0.8723809274027712,-0.4749322267023175,-0.11571904572480478},
{-0.8651637305079274,-0.480878645536823,-0.14229352648759808},
{-0.6255476155531406,-0.2652470065949001,0.7337126182424731},
{-0.30481836815206037,-0.2837409703542626,0.90916270500914},
{0.053511804003781145,-0.1305036097643483,0.9900026740725176},
{0.4427900052918277,-0.020524200245286773,0.8963904107128515},
{0.6758284588028095,0.16146881404915667,0.7191548625725742},
{0.937330791936312,0.22544899806050286,-0.2656759977144372},
{-0.8774589836114179,-0.4645407913236231,-0.11944699776905021},
{-0.04151080360023714,0.4320006374674688,0.9009174781366844},
{-0.9225952741433778,-0.3284980498706307,0.2022547684468724},
{-0.9099800102074356,-0.28040433849792806,0.30546650876064124},
{0.043742400154529654,-0.36299240128235055,-0.9307648032881315},
{0.9959966463384264,0.04242580197384691,0.07868120366061791},
{0.9933561217511971,0.044244405422838,0.10623581302084632},
{0.927041030341837,0.369591899946172,-0.06321989842544798},
{0.9350513174863628,0.3499080439648848,-0.05695080715569624},
{0.8453185207773105,0.514436409571491,-0.14419354679753518},
{0.8180110730576357,-0.2861262255543063,-0.49898864456532654},
{0.859881335439183,-0.41933776851566856,-0.29113557814122715},
{0.05338260156123827,0.35494401038076373,0.9333622272972988},
{0.06512159595579664,0.37224437688275386,0.9258473425027154},
{-0.8926022880924924,-0.27723001822378524,0.3555343475498354},
{-0.3648437025494477,-0.00522705518355876,0.9310541072376612},
{0.01410363611397892,-0.3208409915460807,-0.9470280595590039},
{0.056672602565026986,-0.5181840234532374,-0.8533894386247824},
{0.056672602565026986,-0.5181840234532374,-0.8533894386247824},
{0.056672602565026986,-0.5181840234532374,-0.8533894386247824},
{-0.11510541442734348,0.34202744286981135,0.932613516894028},
{-0.051833004189306316,-0.5721814462455029,-0.8184874661527297},
{-0.05183299570437384,-0.5721813525808387,-0.8184875321683724},
{-0.051833004189306316,-0.5721814462455029,-0.8184874661527297},
{-0.031190001187490702,0.23193280883033163,0.9722316370155814},
{-0.04628240021354329,0.2413044011133592,0.9693452044724812},
{-0.04628235006065546,0.24130449652318797,0.9693451831161868},
{0.004138399822479867,0.22628839029316963,0.9740515582172411},
{-0.8878604802533352,-0.46002568291424417,-0.008952020084883562},
{-0.9026830568994708,-0.42896232543590634,-0.03397973135924118},
{-0.9881752084765112,-0.11372316437476016,-0.1028435668235726},
{0.16474518361134435,-0.3337181668021122,-0.9281655076671951},
{-0.08680765626210893,-0.4325528970907702,-0.8974198694215886},
{0.2536130080207144,-0.21413940677233015,-0.943305229832783},
{0.9329906050485427,0.0020294000109813675,-0.35989500194744223},
{0.9629964036595982,0.20781360078973743,0.17161420065217173},
{0.7917000669269063,0.354912030002731,-0.49724084203459445},
{0.7737822109000844,0.6294492088668999,0.0710970010015264},
{0.9250929748517287,0.37850227154067567,-0.030643405791906997},
{0.7203650831456665,0.33241383836772603,0.6087488702627483},
{0.9861129509682046,0.031853604876603166,0.1629926249532307},
{0.4578192204932157,-0.33929661518782617,-0.8217538367839048},
{-0.22163786327059193,-0.7051397139022139,-0.6735388937862091},
{-0.7964938398377902,-0.6024942703791529,0.05097271094168857},
{-0.29662001750472833,-0.2772830163635749,0.9138548539302137},
{-0.04840499961798581,0.24530879806401318,0.9682357923586445},
{0.7370644270123208,0.2667822097771733,0.6209374227564379},
{0.821633154227837,0.012850199284131352,0.5698717682531513},
{0.7652150170580356,0.3099220069087257,0.5642644125784808},
{0.23289419948143777,0.4181119990690318,0.8780333980449707},
{-0.3648438235609874,-0.005227000337550702,0.9310540601258717},
{0.7369900075793675,-0.38142300392263806,0.5579984057385784},
{-0.030557600259122953,-0.38055760322706,0.9242522078374923},
{-0.11271059919259988,-0.586002195802185,0.8024323942517917},
{0.7360265751317969,-0.5060469829021402,0.44964578480777306},
{0.9115291778490937,-0.30519879258341914,0.2756233933021256},
{0.8812684568110611,-0.42519702741036974,0.20633321330129165},
{0.811783028963737,-0.12364880441168555,-0.5707182203627471},
{0.056281005114536584,0.08595500781116171,-0.9947080903941019},
{0.17119181200126546,0.13818440968730783,-0.9754990683865841},
{0.8384222144361885,-0.10191080175472872,-0.5354086092188154},
{0.8435922984487454,-0.037871604419684665,-0.5356470625109799},
{0.16192460389441957,0.11914020286541963,-0.9795846235598137},
{-0.7153341873313459,0.17218479695058664,-0.6772365880060589},
{-0.6618217607728857,0.1628825903457179,-0.731752156628012},
{-0.9997398850831065,0.01361120115838459,-0.01830020155744311},
{-0.9989176039383796,0.03968840810276003,-0.024258004952498788},
{-0.8207217890733205,-0.2639089964864476,0.5067225932537488},
{-0.81857976838866,-0.19946199229731654,0.5386483791988543},
{0.9490136097054294,-0.24852460254162634,-0.1939296019832909},
{0.9485199235486359,-0.20651462689938271,-0.24012843127771952},
{0.9808145621728276,-0.11509499556111988,-0.15734019393184512},
{0.9754663002492816,-0.17593041808047907,-0.13234041360070706},
{0.8297860446339104,-0.11215520603279057,-0.5466958294065836},
{0.07288059739586261,-0.016752599401403504,-0.9971999643684903},
{-0.7004692117640583,0.14065080236216557,-0.6996858117509014},
{-0.9958823222186497,0.01553040190595285,-0.08931521096111884},
{-0.8406429133362754,-0.11186581508185535,0.5299108714430867},
{-0.015786000744978962,-0.2037482096153631,0.9788960461964351},
{0.7759312444388251,-0.21398601225532163,0.593414433985795},
{0.9334718579534632,-0.201279812496212,0.29684461842923654},
{0.9062400495059197,-0.20599061125281834,0.3691840201677188},
{0.7528112659604226,-0.24321802131047207,0.6116536535923615},
{0.9538399447355698,-0.1793498272145233,0.2408796365510499},
{0.7982733862240686,-0.23717199590708496,0.5536325904458739},
{0.9322780323542063,-0.1934718067143347,0.30565721060766865},
{0.9819092268694948,-0.17645180482852257,0.06869520187981264},
{0.2576521811408607,-0.9267451321658545,0.2734205799866751},
{0.35133495510380136,-0.9212242822790965,-0.1670615786516266},
{-0.458889976993625,-0.864798156643484,-0.2038237897813272},
{-0.41534002476621973,-0.9089688542007055,-0.03561300212355993},
{-0.46879565047398336,-0.6463730695932728,0.6020236648182901},
{-0.27007482456563986,-0.7342912667901381,0.6227968566487576},
{-0.24805320813666132,-0.269258408832236,0.9305748305247905},
{-0.16841798549380252,-0.27381497641573666,0.9469217184396285},
{-4.619999506373962e-05,-0.2979473681656722,0.9545822980072017},
{-0.8146790235767297,-0.17672160511430565,0.5523292159843525},
{-0.5319756266957718,-0.15541360779901559,0.8323752417705218},
{0.1444171881939589,-0.22523378158723822,0.9635421212308588},
{0.5623488273003154,-0.1508812073248211,0.8130182394695487},
{0.6309319632742592,-0.08297879516991069,0.7713879550984959},
{0.19098399148576198,-0.4372817805055851,0.8788115608217907},
{-0.6114510273569432,-0.6160700275636021,0.49657362221721085},
{-0.28314802013376167,-0.1319106093797469,0.9499614675487604},
{-0.9899249270416475,-0.07710740989555079,-0.11875641524056041},
{-0.6754472423921916,0.003697200232042431,-0.7373990462803897},
{0.07962419744109173,-0.04786799846165084,-0.9956749680016754},
{-0.6489862501386807,-0.00625060048290216,-0.7607744587750938},
{-0.9925932348838363,-0.06459220227003745,-0.10289080361600887},
{0.9591384672392919,-0.09512760666881075,-0.2664660186802918},
{0.8070120333892197,-0.10780300446022867,-0.5806118240221644},
{0.6729966242756752,-0.3058432110320768,-0.6734504242920442},
{-0.0381413995080263,-0.08763959886956486,-0.995421787160373},
{-0.44732142782277634,0.05423640337342954,-0.8927272555264051},
{-0.8101649857411936,0.08411259851962838,-0.5801359897896763},
{-0.9992680323190067,0.034234201107225824,-0.017071000552121917},
{-0.8764720263072733,-0.11111480333510643,0.46845521406066476},
{-0.8616192444403745,-0.005173800266852932,0.5075288261771905},
{-0.5205200448369115,-0.009565000823916581,0.8537958735448528},
{0.06756519498018591,-0.07888119413945405,0.9945917261059551},
{0.04249520043687446,0.007827200080468,0.9990660102709581},
{-0.016479999414553963,-0.043378798458983826,0.998922764513629},
{-0.9841085929206771,0.165300598810887,0.06485359953346655},
{0.9585570026286891,-0.1009066002767202,-0.2664326007306487},
{0.8955504737732655,-0.3411259255099235,-0.2856964330709747},
{0.7262496741287434,-0.6223053511629885,-0.2920572901706161},
{0.2956463918700259,-0.3214867911594413,-0.8995773752625401},
{-0.20000379056368936,-0.06064079713892722,-0.9779167538612431},
{-0.5627151906452201,0.02656819955832069,-0.8262237862645585},
{-0.8626754407630892,0.20792900982504933,-0.46103862178496985},
{-0.8522302038314736,0.301483601355416,-0.4275644019222526},
{-0.9606260311405569,0.2735674088682184,0.048564401574309315},
{-0.8246934201416196,0.06302560153928438,0.5620574137272184},
{-0.4589756035666352,0.08559140066511879,0.884316406871899},
{-0.7536356221936651,0.177164805217291,0.6329660186400901},
{-0.4210104008032794,0.10779520020567109,0.9006278017183798},
{-0.5911556040916837,0.06517420045110324,0.8039200055643324},
{-0.6302128223335328,0.16915840599464924,-0.7577712268539579},
{-0.656517824924214,0.2663370101112877,-0.7057258267923593},
{-0.8528149968151454,0.3103451988410097,-0.41999099843153526},
{-0.9425927402678058,0.32911997914363467,0.05655939641582551},
{-0.9896142208830176,-0.12018820253623311,-0.0788574016640631},
{-0.7437570174511281,-0.2626090061617212,-0.6147048144231142},
{-0.7375318193306207,-0.010887200285352215,-0.6752246176975565},
{-0.9792188766704126,0.16808641316074982,-0.11347840888507835},
{-0.6408836692742218,0.32514263514522856,-0.6953778751645946},
{-0.26880820115950416,-0.12503240053932727,-0.9550440041195822},
{-0.27854400985589,-0.3159052111778638,-0.9069824320923041},
{-0.6588701976649509,-0.35514799874134845,-0.6631439976498045},
{-0.9469067146310567,-0.23646842862650083,-0.21783102637028587},
{-0.9785645701447391,-0.19845459394530124,0.055019598321393894},
{-0.9072567071481665,-0.08938241055617592,0.4109696485360361},
{-0.8953565802331952,0.10800979761546557,0.43205379046153997},
{-0.8174375870004372,0.26965719571169017,0.5089997919054678},
{-0.9042274948538491,0.4262054447091325,-0.02686180281781455},
{-0.6825023378886182,0.4592361582070408,-0.5685883482554036},
{-0.3434301990666735,0.4506761987752153,-0.8239821977606965},
{-0.21079459156861283,0.21950879122006123,-0.9525657618991612},
{-0.071517597884119,-0.11904699647793988,-0.9903095707012362},
{-0.0750719952122266,-0.3105975801914039,-0.9475723395678557},
{-0.1033024138377105,-0.3806738509925601,-0.918921123092617},
{-0.13181721411299493,-0.39834484264874503,-0.9077144971843489},
{-0.4261574096841801,-0.3518294079951193,-0.8334302189392184},
{-0.1479808003141662,0.48713760103420284,-0.860696601827276},
{-0.08753199817842061,0.2620377945468782,-0.961079779999507},
{-0.0012661999535370973,0.4937767818809798,-0.8695877680906862},
{-0.02260439893879492,0.503239376374502,-0.8638513594449094},
{-0.14848498466534762,0.23448357578392098,-0.9607131007832242},
{0.10178660368385878,0.33239721203011346,-0.9376308339347169},
{0.15855281429272192,0.37198103353217976,-0.914598882446392},
{-0.14074141604281656,0.45486425184901474,-0.879369300237448},
{-0.2039190222695123,0.32071263502426545,-0.9249651010132428},
{-0.48615615976913074,0.4664715613980898,-0.7389563388491635},
{-0.41734140838568273,0.5443380109374382,-0.7276828146214037},
{-0.7612874160692854,0.44857960946863645,-0.46820700988293246},
{-0.7315016068790119,0.44147460415160955,-0.5196206048864914},
{-0.906030208717859,0.41958080403722336,0.05532820053237017},
{-0.9133700926006797,0.40708004127120967,0.006396400648489646},
{-0.7980252899362422,0.28914643258636524,0.5287248595864913},
{-0.8460218701982107,0.27253402261336435,0.4582272380211592},
{-0.554895106082304,0.05547321060511424,0.8300687586887422},
{-0.6088332129465218,0.12760320271341577,0.7829684166494164},
{-0.2868932004083064,-0.05546400007893637,0.9563556013610853},
{-0.3708985949981654,-0.021913799704476634,0.9284147874796582},
{-0.19697540092402738,-0.11682780054804856,0.9734228045664043},
{-0.24245217940519145,-0.09562759187702931,0.9654389179919531},
{-0.13474260240231511,-0.11462140204357583,0.9842288175477371},
{-0.12166600531424472,-0.07297520318748106,0.9898848432371414},
{-0.1368868001210572,-0.014525000012845327,0.990480200875941},
{-0.2798914179892098,0.02010780129237066,0.9598210616897173},
{-0.14985820033898525,0.04205220009512376,0.9878128022344721},
{-0.3858498321257735,0.015589401297970179,0.9224298768013118},
{-0.07855419560460851,0.06774839620923209,0.9946051443482432},
{-0.2518613880356827,0.0580993972400707,0.9660177541106995},
{0.01363299924516212,0.05590979690436185,0.9983427447233211},
{-0.11913020374760278,0.004759800149733985,0.9928672312336576},
{-0.6566648274257254,0.003228200134826363,0.7541756314982818},
{-0.4446897903721904,-0.15251739669790385,0.8826037808910812},
{-0.8002186521941353,-0.22079941440160694,0.5575820363682004},
{-0.9546268493357087,-0.2539556131245839,0.155544608038642},
{-0.3565382076730802,0.5525330118910962,-0.7533842162136271},
{-0.49604022345994503,0.14429980682457869,0.8562252404946941},
{-0.6717483406533877,0.032271997148882126,0.7400761346168666},
{-0.37747961035918065,-0.8529988234088641,-0.36041940989099724},
{-0.45901160882192776,-0.8208950157771098,-0.33976420653006423},
{-0.49601677967036584,-0.6062735751514051,-0.6216105745228062},
{-0.5612396987164171,-0.5018789216419991,-0.6581242653148185},
{0.27973921066298196,-0.04311940164360727,-0.9591072365588476},
{0.10085619141050013,0.016838198565961075,-0.994758515280579},
{-0.2732400125603573,0.13139340603992114,-0.9529300438044989},
{-0.8085125897469932,0.22264879717651934,0.5447337930920565},
{-0.6766001813596383,-0.017601999515064217,-0.7361401797193089},
{-0.7092924783681841,-0.009921801096238235,-0.7048444778767341},
{-0.991558307870008,-0.06753480734700132,-0.11068501204124158},
{-0.9787202148387493,-0.06437540097601993,-0.1948398029540403},
{-0.9675201520056802,-0.12574859376217828,0.21929898912156423},
{-0.9748808110881774,-0.15525180176581538,0.15970060181641546},
{-0.3538565405762179,-0.002785700392457083,-0.9352955621431949},
{-0.389326132384029,0.022231750224890212,-0.9208316414659259},
{0.5227019640837378,-0.02913343099385586,-0.8520175467333575},
{0.5106211927895872,-0.014732873162003158,-0.8596795565340213},
{0.9860290328855478,-0.16633400554748864,0.00893000029782891},
{0.9860023888850713,-0.16474119814291863,-0.025683199710480487},
{0.9655165038672189,-0.18435081141381707,0.1838277973841012},
{0.9684684117203993,-0.17615370486268678,0.176178340788295},
{0.4562808345967291,-0.29433542231748977,0.8397466636723824},
{0.42464698248671806,-0.25728138938920636,0.8680329642006026},
{0.2607090363299631,-0.31105264334537547,0.9139349273573892},
{-0.00012346810722643856,-0.2756142672796446,0.9612683082404888},
{0.1698805934240277,-0.2645531897593103,0.9492903632535593},
{-0.8490688592459215,-0.10585360738620246,0.5175684361146432},
{-0.895123744812057,-0.14525122349857053,0.42149206818848656},
{-0.9382841355009621,-0.09241359364735302,0.33329057708911325},
{-0.8253034458269723,-0.13154160730416628,0.5491548304931518},
{-0.6649446155537477,-0.2113152605474416,0.7163759619821461},
{-0.9090730488310784,0.046979402523509954,0.41397962223701534},
{-0.9134259950123833,0.030807799831778938,0.4058371977839909},
{-0.18752220211260262,-0.175188801973656,0.9665114108886016},
{-0.440479195446423,0.08512059912004198,0.8937183907609361},
{-0.5046072470484818,-0.347168632369248,0.7904716737018591},
{-0.8216401446361307,-0.012846999134341735,0.5698617616014963},
{-0.9163553457023185,-0.15465999083578333,0.36928737811826107},
{-0.9851594311099757,-0.12387640391184594,0.11880880375181813},
{-0.8428090704887272,-0.1994618166820815,0.4998878418083514},
{-0.6164646137671099,-0.640288614299156,0.4582596102340187},
{-0.28971462238931495,-0.6405062494986964,0.7112082549625885},
{-0.05623359859335816,-0.49214158768944255,0.8686969782701883},
{-0.8850756316071489,-0.4620354164998579,0.05625300200886448},
{-0.6363028725403514,-0.03863880440493446,0.7704710878359127},
{-0.6422754164483397,-0.03139180080392771,0.7658308196125293},
{-0.6339308613933415,-0.04149260401837135,0.7722758747914314},
{-0.6275274597959649,-0.049129004681414644,0.7770428740430203},
{-0.6443738039675255,-0.05606880034522569,0.7626524046957881},
{-0.6443738039675255,-0.05606880034522569,0.7626524046957881},
{-0.6443738039675255,-0.05606880034522569,0.7626524046957881},
{-0.6938782520432439,-0.0817536061318003,0.7154364536601828},
{-0.6938782520432439,-0.0817536061318003,0.7154364536601828},
{-0.6938782520432439,-0.0817536061318003,0.7154364536601828},
{-0.6614762320210861,0.029608401433298927,0.7493814362764472},
{-0.6614762320210861,0.029608401433298927,0.7493814362764472},
{-0.6614762320210861,0.029608401433298927,0.7493814362764472},
{-0.9144616376461185,0.0566228023310204,0.4006916164954806},
{-0.9144616376461185,0.0566228023310204,0.4006916164954806},
{-0.9144616376461185,0.0566228023310204,0.4006916164954806},
{-0.5624362710744574,0.40212705081635636,-0.722467491297428},
{-0.5892324212188726,0.295930410656762,-0.7518180270737495},
{-0.8533148631132005,0.35686222639438053,-0.3801356281157368},
{-0.8218725313060393,0.41600796522911554,-0.38918236747125956},
{-0.9245159007574095,0.3678088400852661,-0.09993501089131383},
{-0.8622623396363958,0.22771758405838513,-0.4523807683305968},
{-0.6268616632983375,0.19005641919124436,-0.7555944762973348},
{-0.23439000838233062,0.22944440820546447,-0.9446780337838787},
{-0.2596698127198637,0.37881621855622194,-0.8882960435129695},
{-0.22036899809350408,0.3126975972947343,-0.9239359920066788},
{-0.06065559994224859,0.3635901996538185,-0.9295821991149261},
{-0.2874591944814676,0.38193519266775333,-0.8783465831378363},
{-0.46478299875494855,0.288300999227705,-0.8371733977573966},
{-0.48687615694840625,0.21623638087948918,-0.8462821251682511},
{-0.7730048045939985,0.18282720108654937,-0.6074848036103065},
{-0.1336118106011837,0.18987121506498283,-0.9726750771751175},
{-0.12203480635913386,0.1460698076115781,-0.9817184511565447},
{0.06610079886271462,0.27607299525007584,-0.95886098350249},
{0.038468195081107597,0.28636356338295693,-0.9573484775847387},
{0.09546239905571269,0.3419361966176629,-0.934861790752609},
{0.08756680372124423,0.3425658145576977,-0.935404039750987},
{-0.23762559376248987,0.14259219625705188,-0.9608337747787672},
{-0.10198159434871051,0.20193598880975785,-0.9740747460218443},
{-0.0948450019959429,0.34765220731608354,-0.9328142196303851},
{-0.1984522177210019,0.1332900119022734,-0.9710048867069144},
{-0.9363660236538608,0.27403440692247644,0.21937140554161574},
{-0.9163358784902191,0.3879150332274842,-0.09924960850138438},
{-0.9116070492575031,0.2650226143201528,0.31422221697858943},
{-0.9639136435687241,0.2167088097951994,0.1546214069888599},
{-0.9680142371927535,0.2245150086262485,0.11198860430279264},
{-0.27464637297746775,-0.28773137169003116,0.9174857097283284},
{-0.025648400288330084,-0.3253754036577532,0.9452370106260144},
{-0.03097600035002137,-0.23473880265249214,0.9715648109784493},
{-0.3647116065707246,-0.17499700315278455,0.9145280164763381},
{-0.49434304679161817,-0.17065041615276913,0.8523516806786192},
{-0.46559537217034114,0.02131679872584808,0.8847409471170887},
{-0.6314466761890346,0.1344120162178726,0.7636808921441384},
{-0.7450336315765524,0.2347944099512259,0.6243368264610935},
{-0.9045302500201986,0.2943902162796735,0.30847921705879017},
{-0.8967227147658264,0.2963174379237808,0.32876184207613335},
{-0.9361930633258423,0.34257822317262904,-0.07863020531869352},
{-0.9329715334706559,0.35816765123936756,-0.03577780511836315},
{-0.8695066789805299,0.39189463559724924,-0.3006272273070906},
{-0.8242418289816454,0.4256432149662882,-0.3734344131305442},
{-0.6798839341522108,0.4556799558667058,-0.5745551443534637},
{-0.6440017829647234,0.4374977884272124,-0.6275805833991006},
{-0.3088784202489764,0.3134176205465503,-0.8979774588682252},
{-0.3997668079349235,0.24755360491366185,-0.8825552175177328},
{-0.2372781772083739,0.1969081810860919,-0.9512761086256915},
{-0.34751160129780295,0.10595960039571249,-0.9316696034793761},
{-0.5158306009759205,-0.33853900064049547,0.786962601488886},
{-0.26925218080444724,-0.3606255742902464,0.8930019363360189},
{-0.7617186491488006,0.13702940884162557,0.6332516408596516},
{-0.8922472849422133,0.08329300792951971,0.44379844224974685},
{-0.932798237626731,0.3591316144864646,0.030198201218119357},
{-0.898216726135883,0.1996866280418394,0.3915762549887519},
{-0.9036689096218049,0.4124162500291791,0.11530541398741007},
{-0.8321709940984763,0.4643561967069159,-0.30309199785055646},
{-0.7996440602571964,0.4010010302174418,-0.44695363368020125},
{-0.685887837634653,0.4969384272670024,-0.5316108291694764},
{-0.8626223464504964,0.4725804802316868,0.18041723063008175},
{-0.7633336215914412,0.4724982133649523,0.4405306124607257},
{-0.7299212031182089,0.6194068026460935,0.2890506012348184},
{-0.9089668027780207,0.3824128011687453,0.16595120050718673},
{-0.8236108575767921,0.5670128396385989,0.01271200088866754},
{-0.8894236670700716,0.40623163063330286,-0.20952661580008006},
{-0.8908803027251508,0.38152024399213286,-0.24652502842617652},
{-0.9561218624461184,0.27829481817595836,-0.09155860597986488},
{-0.9928513207915302,0.0769938093671629,0.0912042110960181},
{-0.9694259519678833,0.1049526164524448,0.221806834770593},
{-0.9202705633440229,0.12432059504809449,0.3710073852221306},
{-0.8390910486196722,0.26004721506798384,0.4778092276858251},
{-0.37977861658226647,0.29403581283848007,-0.8771038382969683},
{-0.3622986003055626,0.3143668002651369,-0.8774470007400388},
{-0.37438760588237063,0.30724580482744,-0.8748908137462671},
{-0.3890214144781091,0.2817470104857055,-0.8770866326423058},
{-0.38043959599591126,0.28345199701669604,-0.8802957907349748},
{-0.3644686351693808,0.2897196279564795,-0.8850000853980342},
{-0.3572834017038274,0.2787524013293256,-0.8914290042510823},
{-0.26934482076526906,0.3214310247808801,-0.9078190699887496},
{-0.2900423865459259,0.1911911911312947,-0.9377213565023143},
{-0.40295241972183776,0.26095901277220596,-0.877228442934491},
{-0.37717282766117727,0.11445740839410061,-0.9190430674009668},
{-0.3073722009017194,0.19502180057212376,-0.9313908027323653},
{-0.3056690202998349,0.19662481305808235,-0.9316142618695858},
{-0.5063069590581476,0.2342127810606887,-0.8299383328881184},
{-0.5083141984636915,0.3700947988814403,-0.7775901976498425},
{-0.4444088006747725,0.4208022006389292,-0.7908390012007783},
{-0.32177102613035036,0.42222123428770114,-0.8474624688206502},
{-0.4765451917683681,0.054256199062802296,-0.8774741848428972},
{-0.7180277908286885,-0.3991369949018551,0.5701979927169066},
{-0.715847649159436,-0.5237220359655855,0.46181963171455914},
{0.1403785990808318,-0.5829211961831602,0.8003103947597435},
{0.05530340408575592,-0.3795124280379693,0.923532268229569},
{0.8352827050463036,-0.24374857229102456,0.4928381439748923},
{0.8321079900145377,-0.17936619784756977,0.5248085937021919},
{0.9986649250852663,0.03794000475207998,-0.035056004390851755},
{0.9971082949867144,0.0639882060956563,-0.04099460390523552},
{0.6452989748303721,0.17879559302614956,-0.7427121710308094},
{0.6994756029834452,0.18940860080787691,-0.689099602939189},
{-0.07502581089400812,0.08435621224881477,-0.9936071442752057},
{-0.1908358011350112,0.13377680079564824,-0.9724636057838052},
{-0.8179862857990768,-0.14348941505069163,-0.5570540584297375},
{-0.8445512429090822,-0.12239920621873171,-0.5212980264855686},
{-0.9458005098754675,-0.2715908315512302,-0.17804442068376336},
{-0.9471041992751622,-0.22959139982428908,-0.2242351998283883},
{-0.8512825964087963,-0.058505199753191135,-0.5214355978002823},
{-0.9802223271162983,-0.13896881802162758,-0.1408966182716268},
{-0.9729762631863844,-0.19965081296559178,-0.116003207533404},
{-0.8358590358066305,-0.13243260567316398,-0.5327300228211532},
{-0.960871468130517,-0.11850180840236153,-0.25036641775221147},
{-0.8137699674751613,-0.12753419490270065,-0.5670215773372254},
{-0.6765484038788414,-0.3222728018476802,-0.6621348037962043},
{-0.9601487395393206,-0.1242657921749684,-0.250344584235772},
{-0.8916447294156951,-0.36288416797826495,-0.27071157554846914},
{-0.7156802704422378,-0.6398594033823025,-0.27996730952553966},
{0.39203641978453396,-0.8436306425747157,-0.3668716185145655},
{0.4730975775051853,-0.8095475615076819,-0.3475793834733167},
{-0.8990804440134953,-0.32724101601972433,0.2908052142360497},
{-0.8670734004398837,-0.44648080022650866,0.220994600112115},
{-0.7363069489181181,-0.26134678186885857,0.6241393566998343},
{0.03715219877429994,-0.20310359329934444,0.978452167719572},
{0.02330300220273736,-0.2976632281368859,0.9543864902142463},
{-0.12271699420685975,-0.2284857892137985,0.9657819544080234},
{0.5494814057443775,-0.14224780148708413,0.8233078086070081},
{0.8278850243816283,-0.1567250046156298,0.5385570158607736},
{0.8518830489279895,-0.09126080524157362,0.5157196296204093},
{-0.7604341847127485,-0.23268979532216263,0.6062963878114299},
{-0.8946401304651291,-0.22791503323678788,0.38428345603995284},
{-0.9450185797082022,-0.20246659565256034,0.25680179448585433},
{-0.7828690414445402,-0.2564206135747282,0.5668902300107728},
{-0.544798855106396,-0.164359816624993,0.822301683175803},
{-0.04894039936822154,-0.08029959896340125,0.9955685871480658},
{0.5348398474504479,0.00328300029126445,0.844947074962846},
{0.8698776523769008,0.015905800957716935,0.49301102968508237},
{0.8866475890690185,-0.08965059889474798,0.45367259440692465},
{0.9920070041722425,-0.040431800170050484,-0.11952980050272559},
{0.989378357238729,-0.053011208424901334,-0.13535242151112623},
{0.993571758630276,0.039750398344897596,-0.1059955955866212},
{0.6850089759802155,0.15751799447664425,-0.7113021750582467},
{0.6626993593706325,0.01998799877455782,-0.7486187541030092},
{0.6361005745695392,0.009393999624440302,-0.7715489691544912},
{-0.0951170042742634,-0.04999540224663844,-0.9942098446767093},
{-0.08915980864142971,-0.018725401814878768,-0.9958412965176203},
{-0.18117779464185524,0.11496319660008306,-0.9767077711148837},
{-0.9231879790922113,-0.2238823949296504,0.3124109929247096},
{0.023569200102056525,-0.08688840037623373,-0.9959392043124965},
{-0.30277318475332976,-0.32877178344412517,-0.894559954952878},
{-0.2747043913986261,-0.7960458316132246,-0.5393037468046372},
{0.5001367638110553,-0.5941463570087,-0.6299629544170791},
{-0.9220365917567347,-0.2160459980684883,0.3212049971283374},
{-0.9760331468328016,-0.20028798908976478,0.08511179536372743},
{-0.2303961934385653,-0.932686573438094,0.2775127920967355},
{-0.1655222092909936,-0.4416220247888632,0.8818006494967064},
{-0.6157036564371606,-0.09815540899720593,0.781840471665737},
{-0.02591740047762815,0.006994400128898822,0.9996396184222187},
{0.47151782375965173,0.0969194048837418,0.8765144441673186},
{0.832221911339132,0.0831970111305445,0.5481650733364776},
{0.9807420997000305,0.18922041923572117,0.04837940491814122},
{0.9977118845424771,0.05854520496090777,-0.03381500286536038},
{0.7980374401895017,0.10369060522190257,-0.5936198298949447},
{0.430838406373022,0.06492700096040929,-0.9000904133142634},
{0.5479705829336428,0.04008999875141064,-0.8355363739775041},
{0.1850098164961679,-0.055869204981507485,-0.9811472874827656},
{-0.11791478920968183,0.01420519870009,-0.9929221091382382},
{-0.2946472177658606,-0.05011200302152135,-0.9542912575393365},
{0.8495074699805764,0.22877321884583982,-0.4753944391619591},
{0.034275999902230445,-0.04276099987802766,0.9984971971518666},
{0.43330260496272743,0.11819560135372496,0.8934644102330803},
{0.7596086326064899,0.19560180839628213,0.6202698266253186},
{0.9543626612004927,0.2968718190375235,0.03254280208687494},
{0.8373726070906368,0.32197780272641785,-0.4417436037405612},
{0.6130597503814226,0.18433718508049354,-0.7682301378225588},
{0.25384878831815827,0.13795059365166557,-0.9573559559435331},
{-0.33155462799953084,-0.9295386784988197,-0.16133621362471795},
{0.47632360173597094,-0.8534130031102808,-0.21166500077141734},
{0.4366882308695096,-0.8985962635218081,-0.04275680302248022},
{0.49441858409901407,-0.634646779589138,0.593947580898064},
{0.6345057861659086,-0.6009017868985745,0.4861269894010026},
{0.30216202185183855,-0.12478500902423756,0.9450538683446729},
{0.6027884311656456,0.07970940412117238,0.7939096410470825},
{0.8119239280123209,0.24238803821621002,0.531062683730217},
{0.9351474861397681,0.3519186324164795,0.04065040374445358},
{0.8378398321431059,0.3306938126868237,-0.4343570166637858},
{0.6378370261401566,0.2819790115562051,-0.7166950293719547},
{0.9907854232068503,-0.09607920225043244,-0.09546220223598065},
{0.9727968911737975,0.19185001798082915,-0.12984521216953013},
{0.7261541627542905,0.006932199644435427,-0.6874969647370853},
{0.7395189023589925,-0.24455183384914062,-0.6271412868044752},
{0.255722591987572,-0.11864679628249933,-0.959441969938285},
{0.621030963304685,0.3405057798802836,-0.7059577582865527},
{0.8929585024408303,0.44819485141723003,-0.041791004794293596},
{0.8191000396132188,0.2894918140003687,0.49524702395107767},
{0.8995796491083963,0.12986120708917284,0.41700422276441956},
{0.9159261703684516,-0.06718679782640903,0.3956831871990714},
{0.9838902955213875,-0.17456401694761825,0.03856540374413783},
{0.9485970669762104,-0.21339261506670135,-0.23372461650225332},
{0.6561096919403688,-0.33913944752346487,-0.6741694944710812},
{0.2709061916380416,-0.30921619045554144,-0.9115893718623177},
{0.057781403870316446,-0.11747300786858199,-0.9913936664055725},
{0.18938859658383125,0.2243805959526498,-0.9559211827572086},
{0.3182338191676881,0.4590442276489049,-0.8294610499596515},
{0.6613980769454562,0.47611785539040236,-0.5795380674220603},
{0.7112527854651653,0.4591917906161678,-0.5322239891237155},
{0.9030787260260719,0.4293668599188279,-0.009639201345165872},
{0.8469383899479593,0.2933145965187429,0.44346579473664643},
{0.6189882442999256,0.14280261022013757,0.7723088552728185},
{0.5066962110367049,0.15643540340742906,0.847813018466809},
{0.6830768471148992,0.048765403363570395,0.7287166502628828},
{0.6689437135703031,0.019366603287976198,0.7430607261535616},
{0.4630056483418203,-0.141466814770367,0.874993091356896},
{0.814591615265219,-0.20114100376932614,0.5440430101952138},
{0.9629992387690212,-0.2306106092840651,0.13946760561477345},
{0.42056278307517453,-0.3415215862560515,-0.840529566174334},
{0.09711779360210335,-0.3782339750828165,-0.92060153935289},
{0.06671339886243782,-0.3088713947332856,-0.9487611838222179},
{0.126238200551363,-0.3952032017261053,-0.9098782039740204},
{0.12156320609186065,0.4902794245692264,-0.8630460432495686},
{-0.024976000945289203,0.49330841867068803,-0.8694958329085919},
{0.06500199740477582,0.2638945894639296,-0.9623587615775385},
{0.32977241911045735,0.5608106324992238,-0.7594350440095962},
{0.39129659637664055,0.5538903948710415,-0.7349097931948236},
{-0.003979399755186857,0.5032241690415897,-0.8641467468375901},
{0.11485498751525204,0.45769515024849416,-0.881659504163529},
{0.4617590052349619,0.47793300541832656,-0.7472340084713921},
{0.7421412496794416,0.4666386312371084,-0.4811182322063827},
{0.8963623824103405,0.44149439133638796,0.0402141992108615},
{0.7993362373851804,0.3088700144459373,0.5154230241064797},
{0.5667616374762757,0.06968320460769893,0.8209296542827603},
{0.30421042053857866,-0.048136803249926544,0.951387864232364},
{0.3873604250357481,-0.012730600822799892,0.9218404595800811},
{0.29537162728380933,0.02711120250429226,0.9549976882142102},
{0.4007669731747598,0.02516539831556016,0.9158343386988504},
{0.26653299511890133,0.06441039882043305,0.9616711823886273},
{0.13560799762174763,0.007861199862132637,0.9907313826248504},
{-0.18255798345362423,0.3680233666437326,-0.9117189173651927},
{0.18063019778946934,0.32505739602198663,-0.9282835886397769},
{-0.12539499420862982,0.32978898476868956,-0.9356897567851509},
{0.12680239959665426,0.23790899924323528,-0.9629747969368734},
{0.09354579529149223,0.06984359648451205,0.9931621500104556},
{0.16533021314669535,0.04588940364902457,0.9851700783385603},
{0.0017495999803669338,0.055764999374235284,0.9984423887960187},
{0.15378640590044615,-0.010986200421516348,0.9880430379090384},
{0.26086002518949564,-0.08950020864243233,0.9612188928184342},
{0.13998520112799515,-0.06978980056236342,0.9876910079587746},
{0.15397520095136658,-0.11110660068649438,0.9818080060662971},
{0.2160531838601321,-0.11179959164821084,0.9699597275408879},
{0.2982727941611251,-0.7273721857612386,0.6180315879016486},
{0.2701008353274575,-0.2629504343922309,0.9262303211449876},
{0.1908854209097047,-0.26944082951471177,0.9439091033963753},
{0.6643917864726379,-0.0012767999740036888,-0.7473833847828858},
{0.976592875574209,-0.040571403139641686,-0.21123521634656034},
{0.9909134001455849,-0.04340060000637642,-0.12730680001870393},
{0.6974070467052679,0.007203200482397488,-0.7166390479932326},
{0.3380895638555397,0.0056380116965361535,-0.9410970511249521},
{0.373176755305102,0.03151411426478661,-0.9272248755841604},
{-0.5360486351013236,-0.042022932663492704,-0.8431405184999519},
{-0.5244525048594182,-0.02733443910264274,-0.8510008217302882},
{-0.98139917336096,-0.19028699483486128,0.025426799309816492},
{-0.9819917353370498,-0.1887006260065183,-0.009181801265426021},
{-0.9575252682559536,-0.20776160444833383,0.19995118496377617},
{-0.9608042968919004,-0.19963862783049444,0.1923525964265063},
{-0.4036485972031108,-0.26736579814741707,0.8749761939372724},
{-0.4348337752895713,-0.30518398265721874,0.8472203518547562},
{-0.1474519959356745,-0.26841619260145133,0.9519509737606903},
{-0.23769140868519198,-0.31711581158734226,0.9181178335478243},
{0.022943482404233915,-0.2753313985589953,0.9610755524841501},
{0.6818102781097645,-0.1949177570300915,0.7050828409897972},
{0.8373526466672888,-0.11129940620293201,0.5352130298284613},
{0.8599525917713201,-0.08504739918620186,0.5032379951846365},
{0.9457117903355632,-0.0694767992900013,0.3174935967554631},
{0.9053354703759477,-0.12333060958706338,0.4063954315910119},
{0.9190813903795341,0.05311619944400726,0.39047159591274644},
{0.9144732043836005,0.06917860033161316,0.39868920191114865},
{0.9809116159310054,-0.13144220213475546,0.14330160232736425},
{0.9738353203659557,-0.10211501262140613,0.20302042509330576},
{0.5260896151247609,-0.3346210096201534,0.7818302224771501},
{0.4531980082460919,0.09600040174675996,0.8862254161251729},
{0.2079090201938091,-0.1703746165481636,0.9631958935533916},
{0.08275320085860749,-0.4904496050886697,0.8675316090010916},
{0.3171039936299072,-0.6331191872816866,0.7061197858152257},
{0.6394643622314837,-0.6249995630858144,0.44772857355592444},
{0.9259111896678497,-0.13223199852443634,0.35384059605152823},
{0.8968789499146396,-0.44034257540948346,0.04131059769304857},
{0.9897366496822868,-0.09983320501137544,0.10224820513260234},
{0.8311478785998134,0.007274600687942871,0.5560038525800525},
{0.8556772203759166,-0.1787844042573251,0.4856466115645183},
{0.6498824258589652,-0.022981400914435013,0.7596872302281226},
{0.6414767702809848,-0.0336801984396281,0.7664027644932812},
{0.6476112678994416,-0.025891402714609633,0.7615308798434556},
{0.6555978351127589,-0.015592400835103755,0.7549492404338595},
{0.7075587342800799,-0.0646919939912371,0.7036871346396842},
{0.7075587342800799,-0.0646919939912371,0.7036871346396842},
{0.7075587342800799,-0.0646919939912371,0.7036871346396842},
{0.6582426020483324,-0.04021040012512753,0.7517312023392522},
{0.6582426020483324,-0.04021040012512753,0.7517312023392522},
{0.6582426020483324,-0.04021040012512753,0.7517312023392522},
{0.6730296914831285,0.04585380623278542,0.7381927003405623},
{0.6730296914831285,0.04585380623278542,0.7381927003405623},
{0.6730296914831285,0.04585380623278542,0.7381927003405623},
{0.9194018802959116,0.07894720689484988,0.38531483365144936},
{0.9194018802959116,0.07894720689484988,0.38531483365144936},
{0.9194018802959116,0.07894720689484988,0.38531483365144936},
{0.5402891860500684,0.4155515892707158,-0.7317133811076144},
{0.8048618082856661,0.43581140448646927,-0.4028224041468634},
{0.8378818165164942,0.37745100744038984,-0.3943156077728282},
{0.5691666539661763,0.3100328293961114,-0.7615306722053871},
{0.8487578405389331,0.24854781187130495,-0.46672702229212465},
{0.9134829975522676,0.390184598954477,-0.11534639969092242},
{0.904828613598398,0.4100860061630597,-0.11451920172107476},
{0.9329640593125389,0.29679161886832006,0.2036978129499463},
{0.9100254914439939,0.2871991657403065,0.2989485643387328},
{0.9608097360663004,0.2401405840206907,0.1384815907852303},
{0.9640036916050142,0.24803582356974907,0.09578680910219751},
{0.1971703810269064,0.3177807694209432,-0.9274369107556255},
{0.4435259702469927,0.2993587799181455,-0.8447893433290827},
{0.2633103925407642,0.3886401889903366,-0.8829645749867794},
{0.03619360156821015,0.36476921580485955,-0.930394240312476},
{-0.06147259674154182,0.28514678488531603,-0.9565105492985526},
{-0.11154979413111786,0.3401417821043862,-0.9337345508741537},
{-0.11941761642483145,0.3393202466704832,-0.9330601283341253},
{-0.08886800350302036,0.274186410807946,-0.9575616377453952},
{0.11262400973085,0.19286881666409791,-0.9747396842186821},
{0.10196680063606686,0.14879680092819145,-0.9835966061356559},
{0.2179418287009749,0.1481382195084686,-0.9646535270361767},
{0.17884158513009543,0.13788318853560902,-0.9741683190021161},
{0.08069039950338448,0.2041597987434822,-0.9756063939955525},
{0.21286441487411437,0.23488921641311947,-0.9484280662723619},
{0.0707016036334559,0.3496676179699159,-0.9342022480099814},
{0.23544241425556303,0.38484382330151684,-0.8924472540358802},
{0.4672114242924063,0.22785161184702185,-0.854281644417914},
{0.7580320826010929,0.2014662219533322,-0.6203214675950693},
{0.6092931979338138,0.20510559930446232,-0.7659591974025405},
{0.2969121923058116,-0.28077319272403795,0.9126935763484407},
{0.38444258807579823,-0.16554139486542582,0.9081849718309543},
{0.05296540112497453,-0.23371680496409825,0.9708610206208941},
{0.049405007364377154,-0.3244616483646917,0.9446077408045062},
{0.2928842219166619,-0.3537820264736728,0.888288866471067},
{0.537038817683303,-0.3257216107251724,0.7781354256219923},
{0.5129002582613079,-0.15792121793856906,0.8437974958485495},
{0.4802673794331646,0.03377119855379168,0.8764717624662194},
{0.641014904685986,0.15048182457561915,0.7526321229145145},
{0.7496983920780271,0.2535403973208691,0.6112851935406227},
{0.9022595208674514,0.3166686424212002,0.2926580392047194},
{0.8947123010414585,0.318401435957643,0.3132258353731532},
{0.9260737593090237,0.3651951839536015,-0.09497299582695883},
{0.9232350416821796,0.38071681718858796,-0.051882202342375644},
{0.8543738790329024,0.4126438381711579,-0.3158644292186866},
{0.8070566643806235,0.44518483551333954,-0.387904630943976},
{0.6584575922527197,0.4714521944529878,-0.5866569930975113},
{0.6221472941740822,0.45232546846824895,-0.6390104967266556},
{0.28667323252578053,0.31979543628380686,-0.9030777024626783},
{0.3785174275088762,0.25631021862742787,-0.8893984646373203},
{0.2167864240498016,0.20224442243654445,-0.9550397059499716},
{0.32847640180346027,0.11471320062981907,-0.9375202051473422},
{0.9241534921124347,0.3817680380516698,0.013910001386440787},
{0.8973664788013793,0.10550140926450537,0.42848903762735513},
{0.7689109109850498,0.15626898190911917,0.619964528228211},
{0.853856435970223,0.49379782080211265,0.16459920693403474},
{0.6641605682644164,0.5129069754917666,-0.5438907740112677},
{0.7817768075116869,0.41988440403445093,-0.4610012044295209},
{0.8152415987704853,0.48418239926977547,-0.31772399952082137},
{0.8952146268663582,0.4343572130355292,0.09962220298976994},
{0.8996350720631653,0.22194821777864338,0.3760262301207025},
{0.9021091429609217,0.40459537441800986,0.15000559051535983},
{0.7195559204766125,0.6373041295668594,0.27583096951590214},
{0.7591285621658077,0.49146197550603704,0.42683597872693074},
{0.840567044248022,0.2809742147906741,0.46314202438011176},
{0.9231315090087292,0.14711401737207747,0.35522624194717745},
{0.97020528397195,0.12877501114556783,0.20522841776266398},
{0.9920763368486089,0.10123839355559128,0.07439979526402316},
{0.9473417303181488,0.30143197782812947,-0.10808519204977883},
{0.8769448895230816,0.40285064112508234,-0.2620668267531406},
{0.8755350009774122,0.42752280047726937,-0.22508380025127453},
{0.8096278131945045,0.5869404095653679,-0.0019390000315998837},
{0.3520775641618224,0.31608956782506126,-0.8809817103243653},
{0.33977783675332207,0.32291323492910023,-0.8833334955490234},
{0.35775038933523207,0.30301439096694716,-0.8832875736686325},
{0.36728858886961335,0.2909537911828783,-0.8834279732284224},
{0.3586150159433497,0.2924490130017336,-0.8864924394117881},
{0.3424193984401906,0.29832539864105023,-0.8909269959415959},
{0.3353966035567469,0.2871850030454821,-0.8972368095148376},
{0.38171682488102104,0.2705118176324694,-0.8838074576082334},
{0.26954020208041374,0.19800360152826704,-0.9424132072739033},
{0.24618259398793554,0.32770699199701525,-0.9121415777244449},
{0.29714443491894216,0.42975605050280236,-0.8526517001994045},
{0.4207120417758916,0.4313352428307549,-0.7980922792490189},
{0.48604598937809684,0.3822007916474986,-0.7859273828245789},
{0.4864699973158531,0.24629879864102175,-0.8382623953748033},
{0.46030502189956424,0.06566140312392012,-0.885329242120602},
{0.35881360000650886,0.1234174000022388,-0.9252140000167834},
{0.28687458932801874,0.2022569924758661,-0.9363733651661061},
{0.2851294174795116,0.2038182124948272,-0.9365678574151517},
{-0.15669861256351234,-0.516071241376674,0.8420902675156677},
{0.06692399979588715,-0.5725799982536768,0.8171127975078714},
{-0.0003451999597143938,-0.248211171033202,0.9687058869498596},
{0.29137940279799984,-0.4754038045651126,0.8301140079712528},
{0.3699743902594772,-0.15039899604036147,0.9167873758632258},
{0.0839783922413845,0.09344639136665277,0.9920763083438202},
{-0.24260840162402067,-0.011511200077055975,0.9700560064935551},
{-0.4273980413848859,-0.21340362066383942,0.8785156850665373},
{-0.45212239071006044,0.7741801840926101,-0.4429789908979335},
{-0.06318239736566181,0.8652797639228705,-0.4972915792658358},
{-0.02897399911671722,0.5905843819958229,-0.8064555754149119},
{0.3512392007560354,0.7830644016855305,-0.5132652011047931},
{0.49831206080012463,0.5769104703900854,-0.6471934789654662},
{0.30251900033105866,0.25567860027979933,-0.9182106010048345},
{-0.011870199330666307,0.11209899367899126,-0.9936261439716688},
{-0.3426525879663839,0.27060099049676395,-0.8996467684053057},
{-0.5256998328896121,0.6228214389658779,-0.5794248362508353},
{0.8196996634719049,-0.19597681517509682,0.5382244416763994},
{0.39338319117105724,-0.3272019926564029,0.8591789807169136},
{0.4268929746268911,-0.306494581782974,0.8507781494325559},
{0.853412673998887,-0.11153020967071574,0.5091638441492831},
{0.8490646659739235,-0.23083821793656423,0.4751872369229431},
{0.8564265863016453,-0.27765099555903344,0.43525099303825615},
{0.8541575869881564,-0.32038839511935063,0.409592593760455},
{0.9410208899633141,-0.2335906223316897,0.2447756234009962},
{0.9559983846415803,-0.15892019744689623,0.24659979603829543},
{0.9055055638756169,-0.13450199463415602,0.4024535839444527},
{0.9444901574354375,-0.3041795862917883,0.12414959440505215},
{0.8751498498581635,-0.11853200675288714,0.46910862672558834},
{0.358490420364601,0.12964400736462772,0.924487452516935},
{0.3689988033921248,0.13632300125318736,0.9193780084516399},
{0.3552195529373908,-0.07087879060935472,0.932091876508274},
{0.3604312301762699,-0.12066181010213056,0.9249486774391855},
{0.7832736904456522,0.5724598661027003,-0.2424294279936477},
{0.7860289401780122,0.5460433584424982,-0.28981917794284856},
{0.8245071636536144,0.5480871758389148,-0.14067119379885382},
{0.8014434960211113,0.40553904858771744,0.4395752526656021},
{0.7785036765179779,0.1898802186630466,0.5982286587990124},
{0.9396373181570512,-0.33610304226412,-0.06415960806791084},
{0.9326688930969057,0.04637520462906834,0.3577402357088236},
{0.6544516008970045,0.1280352001754876,0.745184601021365},
{0.5421030447791662,-0.17522701447422162,0.8218392678861288},
{0.9454516418765312,0.10171060450502926,0.30947721370755693},
{0.9654924035906276,0.22467040083554024,0.1317104004898257},
{0.8625178394183599,0.004569600208837589,0.5060060231252348},
{0.8620014066617586,-0.4304347214286782,0.26773032234277433},
{0.8507456163818046,-0.5236870100840229,-0.04454000085765425},
{0.8679666560094561,-0.49554883197751937,0.03263800210611403},
{0.8561074621543971,0.2221886161311519,0.46659643387544364},
{0.5374624513251512,0.41697783981943415,0.7329826699964179},
{0.5821597926663002,0.01888759976206535,0.8128549897601407},
{0.6146819600225619,-0.12146679210009165,0.7793663493118849},
{0.6122761425922936,-0.10915598976541045,0.7830727265782119},
{0.6928537603902306,-0.33911938061287794,0.6363581636200285},
{0.671146365811456,-0.3232561835331624,0.6671341660158396},
{0.7989871835619575,-0.38723559203316993,0.4600739905346219},
{0.7898223043102274,-0.4038182533314565,0.46164006096786514},
{0.6361245334973311,-0.5506593424321591,0.5404811434962233},
{0.5975929410606303,-0.5593385448335831,0.5744763433405731},
{0.5883807680178347,-0.5239659715191807,0.6158471665248646},
{0.6874644032742004,-0.024246400115478815,0.7258132034568451},
{0.5793593856927202,0.3289389918768517,0.7457491815837243},
{0.6486412261978283,0.04441540179388393,0.7597972306872839},
{0.5557598266500959,0.41243521977731684,0.7218228346132392},
{0.63003302303649,0.5487526200645583,0.5494806200911767},
{0.6533767198123868,0.7118575126351565,0.257599968385273},
{0.6448936153330939,0.7432004176704522,0.1782284042375871},
{0.6624198244313552,0.7400396272941272,-0.11636720429185299},
{0.6837051461618319,0.7075631442831405,-0.17861038593537573},
{0.6758115103524062,0.7217279042615151,-0.1496249801519814},
{0.7636139394878586,0.6385071494018733,-0.09592899239816294},
{0.7814132391135782,0.3670866183744918,0.5046194252586856},
{0.9322198282328186,0.30629840927642515,0.19273680583714603},
{0.904229671966467,-0.11561620920174413,0.4110980327187592},
{0.3860840137142835,0.19771500702313374,0.9010260320057968},
{0.6364094127106998,0.5104628101952288,0.5782826115497611},
{0.5704895922606356,0.6929121905998286,0.4409243940183404},
{0.5122558199344766,0.8525556331772713,0.10364780403346266},
{0.8830934445061622,0.334590616862705,0.3289302165774321},
{0.9247403115228667,0.3279659930850988,0.1931156742066696},
{0.8719792578795436,0.0700600046503871,0.4845036321599956},
{0.9070604920995164,0.04936560501239817,0.41809604245190224},
{0.9239813506002088,0.29481318839903475,0.2436055165405934},
{0.9521229097345307,0.09906279666509644,0.28922055092185334},
{0.937373811083231,0.004976502621476868,0.3482894955593083},
{0.8553321831041109,-0.10733636172336597,0.5068389902112368},
{0.7260434635142305,-0.06898284598680737,0.6841799880497973},
{0.7812678867270514,-0.17757824782239712,0.5984032545611482},
{0.7370806150280017,-0.37881541696373244,0.5596526126272763},
{0.8012210220064809,-0.37554301031473203,0.4658458127950051},
{0.7347844057281736,-0.4756434037079828,0.4835858037698996},
{0.5323262373038803,-0.5005960350803197,0.6826656478392306},
{0.5653047519623714,-0.33597297145018723,0.753360935982012},
{0.43365043155974387,-0.3529446256862237,0.8290822603380555},
{0.9408756739078367,0.12361298674142164,0.3153930813403162},
{0.9375796626902229,0.1325539772848211,0.32151799205590853},
{0.2671829966510909,0.6118881923305077,-0.7444501906689571},
{0.19698541063187808,0.5815040313854714,-0.7893350426027183},
{0.9365404838990395,0.04544039543440003,0.34760191668188245},
{0.9339512906907214,0.069387090805128,0.35060008306721285},
{0.9503550657214836,-0.007026200485894522,0.3110882215132009},
{0.7077255638835429,0.0014887321368421405,0.7064858879711229},
{0.740133767168264,-0.035836858151785035,0.6715040776459388},
{0.703957770463398,0.014146959930314968,0.7101009230587804},
{0.8950126395265873,0.21494560949267758,-0.3908334172604392},
{0.9805370336986071,0.10665440366544528,0.1648392056651115},
{0.9599125416048303,0.2587686381731538,0.1077344158928163},
{0.9136350906385624,0.39776103946049046,0.08400640833398385},
{0.9438608134712914,0.20745620296092696,0.2570772036691447},
{0.671751217103646,-0.3484204088712297,0.65372281664462},
{0.9295987553014534,0.2706989869837914,0.25013638797251725},
{0.9490405285282445,0.06379209089445162,0.30863027127964016},
{0.9254690994843817,0.3387530454868332,0.16956803965654413},
{0.930679230617095,0.362334211919919,-0.05049840166127524},
{0.9822819788141955,0.1293492235466779,0.13561302468693762},
{0.8898506257798492,-0.10009988375798284,0.44513579621375005},
{0.9524384081008439,0.04804791939095504,0.3009193849131864},
{0.9291165909839828,0.3508595965953076,-0.1167899988666862},
{0.9809509912540477,0.12366457960250177,0.14980729124257522},
{0.5852109801514305,0.5701958698129898,-0.576545556533402},
{0.6559143994867637,0.6155283359567477,-0.43692238232921343},
{0.6608993494483938,0.5758010752233538,-0.4813160829125905},
{0.9124934324203058,0.3281566073111378,-0.24427234159407535},
{0.921749598118778,0.30854657089266113,-0.23489719444525348},
{0.9710282586557599,0.042392402560747916,0.23517441420590376},
{0.9652820810585236,0.2135404179318267,-0.1504360126327022},
{0.8843948166953047,0.3507410066211695,-0.3079392058131717},
{0.6793936021193141,0.5398102016838948,-0.49702040155041544},
{0.9078725138715514,0.2864192359246505,-0.30615603840017463},
{0.9983746534841337,0.014799767103438204,0.055036516733165855},
{0.244961466453006,-0.1743650261606483,0.9537246550263808},
{0.6629054523204658,0.17680591764872367,-0.727527338845896},
{0.7076593275097861,0.49142721432447667,-0.5076589103026581},
{0.7097622560750037,-0.07670100135488726,0.7002531658211039},
{0.8143972942589188,-0.12094440656435514,0.5675645316830045},
{0.9062596962145381,-0.007529787388203856,0.42265430947645816},
{0.9877076553799536,0.05281032155881888,0.14712123381989722},
{0.9916881140896581,0.036269404172646486,0.12344721420209666},
{0.9904673265055575,0.028689613477197305,0.1347270618823942},
{0.9899935461039908,0.02478700365808461,0.13891862050171433},
{0.9647778955024231,-0.24254162400895882,-0.10186841008385457},
{0.8275269888216662,-0.3256267956013942,-0.457346993822102},
{0.655342785577688,-0.00018039999602988683,-0.7553315833772065},
{0.915449766918374,-0.013863799499003609,-0.4021933854659298},
{0.654918947899497,0.3965731684515746,-0.6432813488252982},
{0.9605728870288873,-0.27554342496451656,-0.03708840336024733},
{0.7449783517988653,0.012782275869741127,-0.6669661676386861},
{0.9901131775288669,0.13852119685618944,0.02208559949875584},
{0.8448247094758736,0.060895807891130194,0.5315664688825776},
{0.7614812947324519,0.02545980316733923,0.6476866805757774},
{0.8208696684481052,-0.29255962439504435,0.4904914408995618},
{0.7678003374757376,-0.23946604287673406,0.5942547064021466},
{0.6387450629309454,-0.5624879904067427,-0.5249876238822464},
{0.6483815379339074,-0.3396971294799206,0.6813275581462731},
{0.7697916058287236,-0.6381942048322917,-0.011359600086012849},
{0.3806249702014051,-0.708252544551902,0.5945611534526415},
{0.47024777800766415,-0.8698567780549002,0.14905104142810474},
{0.893590548913823,-0.2543429854593238,0.3698723788545594},
{0.7051300296368274,-0.4260432179067246,0.5668146238233892},
{0.8382658706390248,-0.5438498458291625,0.03921320330441992},
{0.6959063444267587,-0.6374075490983179,0.33079597358350793},
{0.3869248035891764,-0.8802560081653956,0.2746608025477976},
{0.45165940306655966,-0.718479004878142,0.5289534035913503},
{0.6214849905588228,-0.4510009931486997,0.6405891902686047},
{0.6942555371858288,0.05726516320667071,0.7174468274163108},
{0.8238503677695078,0.23645519074945226,-0.5151305798471751},
{0.39584497881230307,0.2226147880844903,0.8909261523129651},
{0.4217419741455223,0.18057018893032184,0.8885539455280728},
{0.49448057127164885,0.4755435723718514,-0.7275625577300427},
{0.9640658463276455,0.23737721140702925,-0.11928580573221273},
{0.8776890437779895,0.4476676223290796,-0.17104280853139314},
{0.8589297953890759,0.03322179982165807,0.5110145972567612},
{0.8949907931666201,0.15561699881184243,0.4180607968080473},
{0.7423279797102169,-0.06424919824389981,0.6669491817705183},
{0.5351931723397082,-0.24550978731136217,0.8082655582265577},
{0.7282746177097309,-0.1263422030723114,0.6735382163786849},
{0.6831477883902313,-0.18218279690389083,0.7071905879816355},
{0.32180101250959625,-0.4055714157660618,0.8555442332581704},
{0.5911752176249435,-0.14628900436137268,0.7931654236469584},
{0.18832440081845406,-0.2440662010607068,0.9512968041343169},
{0.5816281555630174,-0.13247418987883716,0.8025953386808998},
{0.21515699997369062,-0.18228659997771002,0.9594159998826827},
{0.2415497841087784,-0.21932038557121936,0.9452789378114241},
{0.6813616303014879,-0.15422060685849281,0.7155154318203744},
{0.6705575062023488,-0.07703285210668659,0.7378472542281338},
{0.35770975491479473,0.1356965828970046,0.9239210835503614},
{0.39389828518292336,0.46782954619882156,0.7911887616955623},
{0.945747713037938,0.30932438755506575,-0.09939661235270203},
{0.32799880137124493,-0.13431280056151348,0.9350812039092379},
{0.4325089764130112,-0.14797859192994925,0.8894033514961583},
{0.40033398908929757,0.13352439636092617,0.9065891752918189},
{0.7521821797882332,0.18064779514584203,0.6337099829716806},
{0.5395556104530979,0.3685363410198242,0.7570077334983473},
{0.9483288238430708,0.31603614427064447,0.02817086052931661},
{0.1595095996386342,-0.15435419965031366,0.9750545977910334},
{0.3708389944249772,-0.1508807977317275,0.9163587862238837},
{0.34421817416043754,0.11307339151187479,0.9320559300329873},
{0.8765812635554047,0.17993741304613226,0.44634943236199537},
{0.7223030694078438,0.2978720245770272,0.6241398344108399},
{0.9792853398217504,0.20228721671229744,0.008950148880937694},
{-0.2842167954309536,-0.17790119714007463,0.942110384854709},
{0.6304380971287158,-0.19958420165450327,0.7501426211985681},
{0.6283190319883796,0.19153716926627914,-0.7540084262331863},
{0.9234381778419138,-0.32942497454770864,-0.19682763486931282},
{0.5413796541881398,0.2357509035305749,-0.8070499250453145},
{0.9239166879518071,-0.3273415603015827,-0.1980541759809377},
{0.48493161163087145,-0.09977760239312192,0.8688416208387842},
{0.4068616097315952,-0.5428812169708278,0.7346724540820135},
{0.9256799059538988,-0.22456393008410117,0.3044466341058216},
{0.9994809353399222,-0.01715659889007686,-0.02726739823597227},
{0.7780809911051804,0.005278199939660991,-0.6281417928192464},
{0.8603449003784069,0.12425261449683667,-0.4943358576752949},
{0.999345320631718,0.03328679735635334,-0.014174598874249435},
{0.6356075573409078,0.06763459546067317,-0.7690439483852634},
{0.801794235118893,0.008508800372688698,-0.5975396261724634},
{0.8449566256812233,0.13649940414870015,-0.5171230157171993},
{0.5847579587999088,0.17346038777856088,-0.7924453441669499},
{0.8266733520042229,0.27835058383926065,-0.48901137160851893},
{0.5416341491361035,0.3673733655006228,-0.756088128997113},
{0.7883380361981184,0.4834282221975742,-0.38055261747383495},
{0.4302941791009737,0.6254357696231108,-0.6509047683861029},
{0.469066789487688,0.6049307864428237,-0.6434555855794398},
{0.9824915588374975,0.019042003078483565,0.18533142996217147},
{0.9795219285074201,0.03937879712585118,0.197448985588748},
{0.9539958527100085,0.10126840559526386,0.28219961559204276},
{0.6014483982936655,0.04041740070756522,-0.7978886250035329},
{0.5382658450720684,0.037741610355311615,-0.8419295997152255},
{0.7508430585039898,-0.05445055729026113,-0.658232358903111},
{0.7538433363929444,-0.0526448591780711,-0.6549417859459534},
{0.36972838965001686,0.1550467840746413,-0.9161121179391291},
{0.974163793015577,-0.1388301990046347,0.1781321987228527},
{0.8755168393078878,0.10979360492937944,-0.47054822112610045},
{0.592632201412776,0.15247440036348373,-0.7909100018854504},
{0.3683416159240493,0.1356810058657261,0.9197364397618074},
{0.8605759662439256,0.17968639295180497,0.4765729813064347},
{0.37007100517250474,0.07665180107136685,0.9258358129404628},
{0.2539690060178566,0.08030760190290792,0.9638726228391934},
{0.29554641009228944,0.1848870063135031,0.9372668320056946},
{0.7271368160338179,0.18382360405342452,0.6614234145847966},
{0.3406085694134813,-0.1118611899549081,0.9335271161696235},
{-0.15385060137192275,-0.17227540153622112,0.972960008676118},
{0.977967759305962,0.19245620293298768,0.08086823672303425},
{0.4769466781434614,0.21353777636364976,-0.8525980789760117},
{0.7493178309330442,0.02937064376637712,-0.6615588813783292},
{0.7743139046248253,0.040678257213407516,-0.6314928792114262},
{0.7522352569395172,0.08282000626895793,0.6536688494786549},
{0.3022841797084919,0.09829619340164608,0.9481361363542211},
{0.22694138942190353,-0.0867385959569771,0.9700381547849901},
{0.5734952132078013,-0.042767000984939435,0.8180918188409493},
{0.4156260343772786,-0.20051941658537067,0.8871566733785413},
{0.16822500198436194,-0.23580180278148977,0.9571300112901908},
{0.5627554866225614,0.1846624163661889,-0.8057332401347264},
{0.7491436960507031,0.08359720147014033,-0.6571112771622873},
{0.7500065071713056,0.14947334267163678,-0.6443197645822033},
{0.609728400198174,-0.04029680001309727,0.7915854002572811},
{0.005646000082574559,-0.10809060158085965,0.9941250145393966},
{0.39618865424093785,0.10566920710473296,-0.9120682918074785},
{0.36649318758428123,0.10154059656010117,-0.9248633686683303},
{0.7461881562556757,0.12393919273422369,-0.6540965616544274},
{0.7945962346170466,0.05070960220919328,-0.6050168263579095},
{0.5272206883591818,0.22797264891194982,-0.8185760912182445},
{0.5735941890760707,0.195684996273238,-0.7954225848514156},
{0.8541408954755159,-0.06054460676765109,-0.516505257734744},
{0.28095945699063507,0.31826048650878874,-0.9054126386652201},
{0.3869285947017326,0.254227596518826,-0.8863715878627898},
{0.8614076551034053,0.13725380877999194,-0.48901763128197967},
{0.7846134142316007,-0.04215660076465161,-0.6185504112194902},
{0.9923392212746219,0.013085800280544645,0.12284800263372117},
{0.4600812038840332,0.17500500147740275,-0.8704588073484655},
{0.3943091506149008,0.239059986032181,-0.8873390653068584},
{0.8135038231362117,-0.1193570033945371,-0.5691796161875824},
{0.37174935679132204,0.1827947787536398,-0.9101584942116655},
{0.28889211147981414,0.22653485225069128,-0.9301738056086573},
{0.8469326580979055,-0.12841220880882356,-0.5159606353938793},
{0.5444949556819784,-0.8095623341073767,-0.21939478214282315},
{0.6970869215010237,0.3054890817126517,0.6486495547108518},
{-0.24153917042406664,0.09904438787223532,0.9653232817983144},
{-0.24230561391886357,0.05714380328253559,0.9685156556348532},
{-0.23807757567737714,0.19638897993639223,0.9511837028246048},
{-0.2310818006458366,0.30805780086097223,0.9228768025792929},
{-0.2373197869275389,0.21132618835936354,0.9481669477714197},
{-0.24256696685237727,-0.025201796556086533,0.9698072674724516},
{-0.24165260735028468,0.09422300286595664,0.9657774293758016},
{-0.2150430760885648,-0.4606558888254563,0.8611345002476654},
{-0.23360237627324146,0.5208981470928987,0.8210329166085121},
{0.08336699432049699,-0.9936869323035696,0.07507479488541564},
{0.08336699432049699,-0.9936869323035696,0.07507479488541564},
{0.08336699432049699,-0.9936869323035696,0.07507479488541564},
{-0.029795200804784476,-0.9969842269290828,-0.07165680193548894},
{-0.029795200804784476,-0.9969842269290828,-0.07165680193548894},
{-0.029795200804784476,-0.9969842269290828,-0.07165680193548894},
{-0.9788511632565122,-0.2009551924566727,-0.03830679856206394},
{-0.990545862913116,-0.10602480673401528,-0.08704960552883227},
{-0.8046745654958452,-0.32276838615980813,0.49831657863236495},
{-0.7794542301985204,-0.3397160131616721,0.5263498203924557},
{-0.7839425643600589,-0.12092559450242756,0.6089425723159855},
{-0.783654404271857,-0.0664120003620251,0.6176368033668618},
{-0.7803666371738893,0.14481200689832865,0.6083234289783632},
{-0.7876259496406949,0.15648658999454507,0.5959507618960417},
{-0.797679435649603,0.2436594108895389,0.5516680246549492},
{-0.8207125089862295,0.20125002672492665,0.5347236710084421},
{-0.970180101786703,-0.12805721343515655,-0.20579582159112328},
{-0.920117030414837,-0.14671160484961088,-0.36312581200326915},
{-0.9088672928530502,-0.22047182252416977,-0.3540514361711286},
{-0.9574544092815502,-0.11015271559960944,-0.2667347622514719},
{-0.8724542305287444,0.2985270104459976,-0.38691761353894394},
{-0.7232953646267438,0.4744830370078053,-0.5017067501053929},
{-0.793483588811802,0.22037199689273285,0.567291792001129},
{-0.5979378131017724,0.6477903633337901,-0.47205721775537557},
{-0.5822758250528371,0.6228706267994577,-0.5224816224801484},
{-0.490524746464554,0.7079209227381236,-0.5081667445391216},
{-0.48201496417396916,0.8517275366948762,-0.2054793847276302},
{-0.9056709552951046,0.33759098333614485,-0.25650038733886416},
{-0.7071786240778909,0.7054984240206837,0.04658720158619268},
{-0.9615834071193905,0.24491880181333475,-0.1239844009179582},
{-0.8384470717192564,0.44187443779714564,0.3189882272856799},
{-0.9754041172454156,0.2156818259253625,0.04547700546642188},
{-0.9563428435950616,0.14507340661319748,0.25369681156481505},
{-0.9690838122683879,0.062242600787977644,-0.2387518030225453},
{-0.8982876589209531,-0.17756261164677953,0.40193382636385344},
{-0.9631009974238012,0.09446479974731611,-0.25201759932587814},
{-0.9283069843698727,0.19181319677039518,-0.3185181946370328},
{-0.9212412382283247,-0.3530718146512589,0.16326320677485834},
{-0.9227425316034671,-0.3838559468867025,0.03465302886816081},
{-0.923595083609945,-0.374244033879049,-0.0831476075270722},
{-0.8606091053907423,0.3340359167743411,-0.3844112043414863},
{-0.8760954177802867,-0.4809412097606635,-0.033946600688943555},
{-0.8882532147838893,0.30390002628101126,-0.34445754521056193},
{-0.808911801150046,-0.521449400741355,0.2715736003861016},
{-0.881802805950176,-0.3470942023421014,0.319295202154521},
{-0.9389285914365842,0.1124845125505399,-0.325208140456507},
{-0.8000111834214324,-0.3703661923249311,0.4720285902181894},
{-0.945022142612944,0.1362809679527381,-0.29725518960163694},
{-0.9612971396125147,0.08248036674464022,-0.2628779155320335},
{-0.9459678711725471,0.14543077426116824,-0.2898183510529937},
{-0.9619667999216097,0.057588065170410214,-0.26702713457344784},
{-0.9524483216350407,0.00553374889719052,-0.30464991750817383},
{0.20966838773402646,0.502599370597043,-0.8387091509340232},
{0.19666301019512872,0.5834022302439225,-0.788013640851101},
{0.11594038926947167,0.6073977437840536,-0.7858917272640579},
{-0.9633405743991231,0.016941205273173107,-0.26774602383650814},
{-0.9807525276112706,0.056071607295794655,-0.18703062433561468},
{-0.991389611502903,-0.09826651864144267,-0.08654668981662016},
{-0.21504215116876976,-0.4606557872509027,0.86113478555506},
{-0.18158401085825931,0.5189976310347306,0.8352656499467491},
{-0.5357007506680488,0.5553391488595754,-0.6360999414224242},
{-0.8990680496047323,0.42376842338078774,-0.1099862060683241},
{-0.6075469739597473,0.5334227771368067,-0.588512374775595},
{-0.5081876491803297,0.5280192510995513,-0.6803976658461133},
{-0.49102778493215465,0.6930671787323053,-0.5277779838044256},
{-0.49946801269763585,0.7155056181898131,-0.4884500124175327},
{-0.6905716638944003,0.7054052652668633,-0.1597316147789958},
{-0.6334446154574931,0.7345802179254324,-0.24318680593431263},
{-0.8188873703813356,0.5681651794498067,0.08131299705895774},
{-0.890432054083972,0.3455514209884553,0.29618401798992755},
{-0.8569854674108737,0.43695763437128987,0.2732104214908583},
{-0.9655178580976637,0.05581680335863893,0.25428281530084335},
{-0.9795128514643705,-0.012284800645453025,0.20100661056104438},
{-0.7520044811067408,-0.312287633681491,-0.5804874626079329},
{-0.9973596045702009,0.017677000081001315,-0.07043680032276255},
{-0.8658485147074491,0.2288029774611964,-0.44492195617186153},
{-0.7959763502427558,0.3926563754546738,-0.4606979712013285},
{-0.8456604526537137,0.26026161620477883,-0.46596382901250255},
{-0.9840408717062231,-0.1730721072768684,0.0413474121850561},
{-0.9916550186384141,0.07297880137165555,-0.10627520199747005},
{-0.936333554258665,0.03199039843721981,0.3496513829189919},
{-0.936333554258665,0.03199039843721981,0.3496513829189919},
{-0.936333554258665,0.03199039843721981,0.3496513829189919},
{-0.9231910773307346,-0.37047863103299566,-0.10229280856851657},
{-0.9300061955350402,-0.3284349984231835,0.16498159920792332},
{-0.9338208114531069,-0.33317120408627154,0.13029060159798558},
{-0.9176368556602379,-0.38652702344520706,-0.0924092056051785},
{-0.8249215325760477,-0.558535954348747,0.08684499290183074},
{-0.8073860265325461,-0.5742862188723548,0.13536300444833704},
{-0.8226661641733006,-0.539826576490823,0.17834699223307787},
{-0.9825812467023828,0.013325152593283233,0.18535515621950477},
{-0.9858706151443393,-0.05971225081706693,0.15650424050894501},
{-0.9908196464106697,-0.025631126624216054,0.13273836534555072},
{-0.7445504576576769,-0.46541623604163923,-0.4785732370605119},
{-0.8433570889626574,-0.29052943064688797,-0.4520414476842004},
{-0.6901032414770832,-0.4948344297408961,-0.528106431740634},
{-0.9811656224440767,0.02753658407982207,0.19119560107686182},
{-0.976334075420206,0.0723921288376074,0.20379193520777703},
{-0.4320099884417543,0.22906459387147307,-0.8722939766621413},
{-0.5444794459009042,0.2135144179997701,-0.8111434683813116},
{-0.8710771064580853,0.12635881544285513,-0.4746136580045795},
{-0.9526127554084821,0.06128368077323446,-0.29794839939819023},
{-0.6238858521661659,0.32014714715165393,-0.7129321479899432},
{-0.3222098105325326,0.5513158385739526,-0.769565906296588},
{-0.9830938977692011,-0.08930934498667004,-0.15984439016434598},
{-0.6369936764743034,0.3113775265272864,-0.7051830202901227},
{-0.6377363793999291,0.3223825895864429,-0.6995439774034288},
{-0.9844102857216442,-0.11379680990933334,-0.1341144116785735},
{-0.8968761799306916,0.2802443937289993,-0.34216399234343065},
{-0.7481605800939461,0.35288999061077614,-0.5618935850498886},
{-0.8468446610551105,0.34468320042134326,-0.4050279143340063},
{-0.883758043020282,0.1279164062268173,-0.4501212219113614},
{-0.7078568337612466,0.33890161616391973,-0.6197454295587713},
{-0.9468127697331389,0.0611121153749699,-0.31592861286160606},
{-0.33933818338036004,0.5941770041708903,-0.7292484384725297},
{-0.2227852363073791,0.5508092665054961,-0.80434811519338},
{-0.8824630661073114,0.1331588657524668,-0.45114039214860757},
{-0.5953365619160118,0.2797821821021889,-0.7531907518179974},
{-0.32981161267590065,0.519275619957715,-0.7884016303012398},
{-0.572816553741147,0.3426485723287852,-0.7446295398660738},
{-0.7115873994450472,0.21237519983437284,-0.6697313994776899},
{-0.9318451405403356,0.044499406711374326,-0.36011725431267233},
{-0.7522855862741433,-0.22322539592713217,-0.6198683886901666},
{-0.5565695604546543,-0.004731399663824887,-0.8307875409709355},
{-0.1968946230141554,0.008037000939410054,-0.9803917145937198},
{-0.46073216655462385,-0.2928025787449345,-0.837849939178967},
{-0.9559654483494069,-0.23232421175015044,-0.17931960906936203},
{-0.7119388251671234,-0.5209106184142532,-0.47095141664818946},
{-0.89714500303741,-0.4385234014846823,0.05317960018004698},
{-0.46945045226954935,-0.8689220131937057,-0.15681456517592104},
{-0.2867925954276223,-0.5331712730354166,-0.7959135636598245},
{-0.9137888477877332,-0.35253409353974435,0.20176633651548026},
{-0.3045932974186231,0.018892977202937394,-0.9522951110764243},
{-0.6440902266402293,-0.6293356260299638,-0.4348384179853608},
{-0.6176172049276465,-0.739765605902205,0.2670128021303563},
{-0.8646774885483232,-0.46084784719367,0.1998802204689709},
{-0.33487357120040023,-0.887602917058032,-0.31626057759632786},
{-0.9779434412911645,0.004897077102369821,-0.2088124619639547},
{-0.972064051097392,0.040457003078331805,0.23120274969395702},
{-0.4677635332910649,-0.8835899349095182,0.021589438382047174},
{-0.45513877909443873,-0.8902253591099205,-0.018641399143758057},
{-0.8814411708541966,-0.3624437818690796,0.3028134199595883},
{-0.8714082942602578,-0.09998261081512161,0.4802614519498938},
{-0.8728222890733632,-0.4035304910391974,-0.27448933403394493},
{-0.9309535425718245,-0.21128364500508134,-0.29779980343569223},
{-0.3535453970967276,-0.7882783935267523,-0.5036097958644168},
{-0.7930160763582369,-0.26459002547694616,-0.5487418528374666},
{-0.859228224538493,0.1387890039636419,-0.4924068140625282},
{-0.21514588791975528,0.1724557210339124,-0.9612342436648278},
{-0.6863882642819121,-0.17790583410136931,0.7051387557415633},
{-0.34643166717234847,0.4700263849173877,-0.8118252875229244},
{-0.9933759556344881,0.0381216059725994,0.10840181698356116},
{-0.9961708616664848,0.07408040458583795,-0.04642960287415594},
{-0.8453778992316839,0.025725783551177325,-0.5335488651954033},
{-0.24504160936048672,0.3783618144532626,-0.8926348340982764},
{-0.9935386006691879,-0.1132586000762842,-0.007317000004928292},
{-0.9819923353200979,0.005591248386902357,-0.18883800283326563},
{-0.8870443807868406,0.06469891179448868,-0.4571283379173724},
{-0.2383014134196347,0.19179701080079964,0.9520642536142624},
{-0.23093101193690743,0.31014021603125985,0.9222168476697221},
{-0.23710776872119096,0.21570237154495053,0.9472340750426698},
{-0.2372792021554633,0.21241040192955313,0.9479348086111158},
{-0.2391468000504456,0.17257220003640236,0.9555248002015584},
{-0.8768239515296994,0.04791859735108876,-0.47841777355335324},
{-0.8821688483875476,0.04076832763353854,-0.4691652868622661},
{-0.24229680951245178,0.05774100226688292,0.9684824380221371},
{-0.2415395937202412,0.09904439742495665,0.965323174902679},
{-0.884219828747278,0.03691100120003056,-0.4656102151376681},
{-0.964678821827402,-0.23903060540844992,-0.11072100250523985},
{-0.9468858671638479,-0.28510742022304064,-0.1487310105496843},
{-0.9289180712940003,-0.3291608252629297,-0.16960061301676274},
{-0.9683903413381107,-0.11768921717692846,0.21993043209919644},
{-0.9683903413381107,-0.11768921717692846,0.21993043209919644},
{-0.9683903413381107,-0.11768921717692846,0.21993043209919644},
{-0.9836177285107662,-0.05962440778999616,0.1701208222264774},
{-0.9836177285107662,-0.05962440778999616,0.1701208222264774},
{-0.9836177285107662,-0.05962440778999616,0.1701208222264774},
{-0.6446754008434804,0.42589080055722695,-0.6348312008306004},
{-0.7422490706710071,0.22671522158600618,-0.6306080600414449},
{-0.08219019171923012,0.4625347533990154,-0.8827833110584206},
{-0.0995223943774586,0.5934645664720779,-0.7986833548781935},
{-0.46574238280221136,0.4650955828260948,-0.7528413722009263},
{-0.06368419537922015,0.6061137560217694,-0.7928243424744755},
{-0.10702639190851182,0.3478473737017864,-0.9314223295819223},
{-0.4467371826064758,0.26097238983914983,-0.8557565666814783},
{-0.1262394030852557,0.15720760384210986,-0.9794638239378219},
{-0.4494131675121659,0.11308279182530633,-0.8861377359415838},
{-0.1798637852492061,0.04965419592781387,-0.9824375194293986},
{-0.3743033912773312,-0.014598599659798034,-0.9271913783929735},
{-0.8211264163143697,-0.013177800261820229,-0.5705942113367257},
{-0.4694127347220427,0.08459998823526928,-0.8789166777751835},
{-0.8201750544187316,-0.05907560391967472,-0.569054437756843},
{-0.34176114636939603,-0.018135197154148193,-0.9396118525521356},
{0.01697539959291804,0.16725819598903144,-0.9857669763606182},
{-0.33589519356773473,0.1534271970619275,-0.9293193822038871},
{-0.22281501289375227,0.12896374470529984,-0.9662928244485433},
{0.07996969401862443,0.2342984300704663,-0.9688700086725166},
{-0.3005125382079018,-0.05333402831600832,-0.9522855117050935},
{-0.39442017428900394,-0.12010759217056827,-0.9110471406117359},
{-0.298108284296809,-0.05436022971580573,-0.9529829044945443},
{0.13823080012214906,0.18030200015932568,-0.9738498008605522},
{0.14775160190545558,0.15591907770477523,-0.9766569025722719},
{0.21833824812218822,0.22573116572620408,-0.9494071045799177},
{-0.9138063086520517,-0.15557961849849863,-0.3751706446079874},
{-0.45378959136448394,-0.14138739730942895,-0.8798207832572043},
{-0.49458421080189735,0.08853080193354461,-0.8646090188833724},
{-0.0882749946986789,0.14110099152623384,-0.9860517407830393},
{-0.13971100838898373,0.17886388001510037,-0.973903766581112},
{-0.03947667875958971,0.22593708499945972,-0.9733416797076241},
{-0.6676736082399692,-0.3566367146408058,-0.6534693616613042},
{-0.6675124285018601,-0.35473501514669586,-0.6546680279534219},
{-0.9952760613955366,0.047140602907959635,-0.08487240523551914},
{-0.9684867430728721,0.16715862469405462,-0.1846386272763452},
{-0.988723408375298,-0.06262780053050883,0.13602860115227383},
{-0.8844616824510431,-0.25897942414250846,0.3881458361836241},
{-0.9802917733786871,-0.1311975964371299,0.14769979598898758},
{-0.9406320616284086,0.10246720671345487,-0.3235920212011286},
{-0.955409520313773,-0.2069158260567047,0.21066202652846003},
{-0.7018504459422333,-0.4323476283009233,0.5661108370568919},
{-0.9206882951257773,-0.1828206188890785,0.344832835628227},
{-0.9113142829154052,-0.01143260104018862,-0.4115526374448797},
{-0.9152096901460722,0.02796220275421335,-0.4020066395967394},
{-0.9521382435579261,-0.20876220955034522,0.22327361021420525},
{-0.9173680470023438,-0.17284600885595217,0.35855281837084135},
{-0.9694430485537807,0.13414680671863566,0.20538941028676455},
{-0.857321669565644,0.43710986114878336,-0.27190903659067295},
{-0.8260113309877308,-0.18353118466618673,0.5329367554737647},
{-0.9792322718443551,0.17301821269400763,0.10568280775374075},
{-0.8106568734511256,0.29986399758893373,-0.5029085567739227},
{-0.7875398876730246,-0.16936161885421375,0.5925348659640542},
{-0.9836613220061575,0.15203621885746083,-0.09641261195831538},
{-0.8404225519054714,0.17238434823228782,-0.513783583557537},
{-0.925486077790919,-0.22559689953752107,0.30427217870557766},
{-0.8168019005136489,0.11981558540647935,0.5643393312635525},
{-0.7567659467559176,-0.16606378831618404,0.6322405555171999},
{-0.8673000592722633,0.36751020687744884,0.33574820182277015},
{-0.6277669620901462,-0.16963718975587844,0.7596919541234046},
{-0.7908310416330957,0.09620140506449809,0.6044266318198838},
{-0.952091881577629,0.2707222552961127,0.14223399565981604},
{-0.2514623901697118,-0.17746879306230492,0.9514575628051651},
{-0.8039397761454672,0.11586299656210859,0.5833151826918488},
{-0.7281985607536813,0.06410579654501306,0.6823615632240699},
{-0.8064246453925802,0.0571388032162679,0.5885698331298199},
{-0.9875721485398491,0.1476448222071265,-0.05387260810293111},
{-0.9065744936546257,-0.019319001995769695,-0.4216034435541844},
{-0.4755517456582677,0.11351738702826449,-0.8723327003177456},
{-0.33653238522967466,-0.06179759728771833,-0.9396419587593408},
{0.13312779058375987,0.24969718233870916,-0.9591289321600074},
{0.04026915783658789,0.20574851455222332,-0.9777760191816353},
{0.23091276593939614,0.3173675024745228,-0.9197592961744401},
{-0.2856882955072822,0.01090439214006111,-0.9582605554034871},
{-0.4483967695968975,-0.08378459431906789,-0.889899139661263},
{-0.32316983815307854,0.021096859911529143,-0.9461057965206567},
{-0.07133240628069024,0.18417781621652587,-0.9803010863137498},
{-0.05632129302075117,0.1736162297162056,-0.9832015646507081},
{-0.020829145379017203,0.21819458019175086,-0.9756829771384378},
{-0.28968317764982676,0.06506259846772557,-0.9549086421576287},
{-0.3547152066776983,0.030203600568598495,-0.9344864175921929},
{-0.2993599327927746,0.13075035119066672,-0.9451391306584563},
{-0.2901033882948797,0.10544919574532538,-0.9511679616221806},
{0.14377875730756803,0.10116564195899617,-0.9844253053605011},
{0.1758605919468407,0.09813939550591651,-0.979510955145393},
{-0.7529992824115592,0.16618001818747338,0.6366916696823416},
{-0.37917461751892184,-0.17626720814403524,0.9083812419697397},
{-0.7793770356915254,-0.13184760603795334,0.612525628050575},
{-0.9726832610864365,0.15349160963957728,0.1741482109368528},
{-0.8776755033233067,0.15987095615418426,-0.4518041481046041},
{-0.9442186878956196,0.2773758239731011,0.17752104580561046},
{-0.7032628303088564,-0.10333540445349564,0.7033798303138988},
{-0.641743662304572,-0.2502532242961808,0.72494027038183},
{-0.8155367151129829,-0.22248743140409424,0.5342276754062203},
{-0.9179681658000685,-0.0693777974152525,0.39053958545001066},
{-0.986520082437232,0.051791204327862765,0.15522821297143813},
{-0.7616189529603281,0.0793131951013999,0.6431531602770998},
{-0.9347197713858727,-0.06785299792284877,0.34884798932088407},
{-0.6265328111539757,-0.26355300469195514,0.7334824130579675},
{-0.6727979453704237,-0.252594779489911,0.6953695435376642},
{-0.655379567686852,-0.21409318944424688,0.7243215642877029},
{-0.7879011203872445,0.11010238887480377,0.605878938779511},
{-0.7597379056914412,0.46465611630464976,0.45485493097938673},
{-0.5277474369163039,-0.11760720822670684,0.8412200588439341},
{-0.2417034033819817,0.0921658012896097,0.9659632135160279},
{-0.2425702150331003,-0.025201601561849647,0.9698064601030008},
{0.0960637974727498,-0.9947391738303625,-0.0355769990640389},
{0.0960637974727498,-0.9947391738303625,-0.0355769990640389},
{0.0960637974727498,-0.9947391738303625,-0.0355769990640389},
{-0.07767300268184689,-0.9965596344086137,0.028910200998194097},
{-0.07767300268184689,-0.9965596344086137,0.028910200998194097},
{-0.07767300268184689,-0.9965596344086137,0.028910200998194097},
{-0.9399913785055746,-0.2207297949526557,0.26018179405052183},
{-0.9416318109814232,-0.21559240251426448,0.2585526030152715},
{0.13654940386636366,0.8248826233563539,-0.54856441553247},
{0.18940116538869783,0.6226962862080427,-0.7591946612642337},
{0.13366159737022149,0.8329181836124182,-0.5370119894343429},
{0.08411871914661455,0.9369352662736207,-0.3392290493190594},
{0.08412652427687467,0.9369338395926236,-0.33923105420836147},
{-0.10257063479540214,0.9075511688341148,0.40722247092406433},
{-0.1025744549418182,0.9075501707474002,0.40722373306298565},
{-0.22891697804784716,-0.32889036846082936,0.9162031121400653},
{-0.22945260082026092,-0.32253960115303393,0.9183244032828812},
{-0.14276720863788184,-0.8068190488151842,0.5732892346858687},
{-0.14626938525986727,-0.796077119776224,0.5872533408202053},
{-0.0802653934925172,-0.9427103235701595,0.32381277374701645},
{-0.0801900038932729,-0.9428218457745674,0.32350661570644074},
{-0.08127499621346465,-0.9412309561488226,0.32783938472623225},
{-0.2395726236645872,-0.43240344271209635,0.869271085865159},
{0.4246529970722299,-0.2347131983817699,0.8744023939714327},
{0.14628920517285662,-0.3384836119689432,0.9295312328686712},
{0.47431534334923964,-0.1794091785719216,0.861880097059702},
{0.6543278222338765,-0.08210440278988466,0.7517406255439364},
{0.6663612527790383,-0.08348780661263862,0.7409402586860568},
{0.9923307485533281,0.006240599676460611,0.12345339359964785},
{0.9867241898420692,0.054748999436380966,0.15289839842597217},
{0.9413807206399429,0.013256801698887353,-0.337085443198217},
{0.8971626243275518,-0.026989800731858145,-0.4408750119548111},
{0.8267057018240744,-0.09421341160412154,-0.5546904683203749},
{0.8264354224363666,-0.09219660250298657,-0.5554316150790576},
{0.7046627592673228,0.22940538673933672,-0.6714339611880967},
{0.535172159830996,0.473114364488936,-0.6998239474725462},
{0.5063415844545642,0.566799782598408,-0.6498893800474345},
{0.5716233623979647,0.5509035637609367,-0.6080723600003083},
{0.548445218786037,0.60210122062393,-0.5802430198752154},
{0.7789211960922148,0.5154565974139955,-0.35719219820799536},
{0.752421544916906,0.23739798262062609,-0.6144135550201615},
{0.4820641284694499,0.4512929330353995,-0.75096528856885},
{0.6450242006298403,0.14425880014086295,-0.7504220007327571},
{0.861153059699903,-0.17732061229284765,-0.47641663302784154},
{0.9068723372264984,0.2551191823407069,-0.3354053767833144},
{0.8810740150926217,0.3824122065506447,-0.2783334047677956},
{0.5349473965107414,0.6372697958433313,-0.5547237963817475},
{0.4495878112428515,0.6301396157579142,-0.6330836158315348},
{0.6380662041694564,0.7495176048977378,-0.17633740115228028},
{0.5603699723389732,0.7921995608953828,-0.24167198807056828},
{0.5858673786679364,0.5760953790237454,-0.5699767792465302},
{0.5649229560062988,0.32246537488782284,-0.7595249408515569},
{0.7569332264449312,0.6478132226326121,-0.08596580300338216},
{0.496916232615088,0.7600358498849393,-0.41883142748999325},
{0.42091721617146294,0.8224472315980779,-0.38263461470066146},
{0.5086952174508915,0.8217416281900114,-0.2568460088111539},
{0.41901614332968784,0.8487420852109169,-0.32258695637136225},
{0.38929642152933064,0.726673240187342,-0.5660338313034717},
{0.31090220447437394,0.7795088112183635,-0.5437884078259744},
{0.5019049652871094,0.6554133546701196,-0.5643799609661964},
{0.8561851373466857,0.49673656365016083,-0.1421259895996042},
{0.9050455467472303,0.42475217500763374,0.021866598713371994},
{0.9137256620445148,0.4053062275214205,-0.02884920195894108},
{0.9204827914177497,0.037486199650492165,0.38898099637328126},
{0.9326394544047594,0.023551801373875057,0.3600402210026516},
{0.7429798951111879,-0.11622538359209648,0.6591453069463807},
{0.7091762260598157,-0.11611100426668473,0.6954044255537488},
{0.5554193768408564,-0.22984979041602702,0.7991735666771163},
{0.2732188079127228,-0.2964896085866713,0.9151204265029129},
{0.27892779822099295,-0.2920227981374728,0.914834394165168},
{0.3122107471133147,-0.23667735990823133,0.9200588441473813},
{0.3223175647245814,-0.23352897444187587,0.917374299599755},
{0.31876798738435547,-0.2107945916575386,0.9240955634277545},
{0.9469005168980981,0.18948143477154847,0.2597618081532198},
{0.9494576179069798,0.1940292036594335,0.24674460465365758},
{0.3075974247390222,0.6686640537783919,-0.6769580544454504},
{0.39544084874246915,0.7456626919111945,-0.536296266104461},
{0.35034856876660864,0.4617847588321307,-0.8148685273548977},
{0.34576540624957836,0.4575948082708524,-0.8191784148063388},
{0.35654636210419893,0.46743759184279227,-0.8089355903917645},
{0.36227408908228415,0.47264817356990596,-0.8033437548152305},
{0.9392745290352998,0.2686930933313834,0.21346517444662544},
{0.7747648087114399,0.19426020218425782,-0.601666406765125},
{0.9294620934481237,0.3679300369916878,0.026976002712167452},
{0.9294620934481237,0.3679300369916878,0.026976002712167452},
{0.9294620934481237,0.3679300369916878,0.026976002712167452},
{0.7168794253965438,0.3970304140654062,0.5731062203031594},
{0.7168794253965438,0.3970304140654062,0.5731062203031594},
{0.7168794253965438,0.3970304140654062,0.5731062203031594},
{0.0008853999400495545,0.6344751570396758,0.7729427476640329},
{0.0008853999400495545,0.6344751570396758,0.7729427476640329},
{0.0008853999400495545,0.6344751570396758,0.7729427476640329},
{0.5226876125219541,0.41576160996034284,0.7442714178304064},
{0.5226876125219541,0.41576160996034284,0.7442714178304064},
{0.5226876125219541,0.41576160996034284,0.7442714178304064},
{0.6681222390322235,-0.7170916418930542,-0.19847481159505362},
{0.6681222390322235,-0.7170916418930542,-0.19847481159505362},
{0.6681222390322235,-0.7170916418930542,-0.19847481159505362},
{0.47819236781427865,-0.8782269408891284,-0.0070355995264544955},
{0.47819236781427865,-0.8782269408891284,-0.0070355995264544955},
{0.47819236781427865,-0.8782269408891284,-0.0070355995264544955},
{0.047315194237954106,0.5126501375694495,0.8572928955988431},
{0.047315194237954106,0.5126501375694495,0.8572928955988431},
{0.047315194237954106,0.5126501375694495,0.8572928955988431},
{0.6617088698581177,0.26596462807849364,0.7010022740064122},
{0.6617088698581177,0.26596462807849364,0.7010022740064122},
{0.6617088698581177,0.26596462807849364,0.7010022740064122},
{0.20283059245967555,-0.8463841685352629,-0.4924363816934415},
{0.20283059245967555,-0.8463841685352629,-0.4924363816934415},
{0.20283059245967555,-0.8463841685352629,-0.4924363816934415},
{0.2004403925946176,-0.8485113686512729,-0.48974698190602384},
{0.2004403925946176,-0.8485113686512729,-0.48974698190602384},
{0.2004403925946176,-0.8485113686512729,-0.48974698190602384},
{0.9024286662174205,0.13586180996911884,0.40885703000066254},
{0.9024286662174205,0.13586180996911884,0.40885703000066254},
{0.9024286662174205,0.13586180996911884,0.40885703000066254},
{0.901868276756912,0.1358764115642761,0.41008683490199166},
{0.901868276756912,0.1358764115642761,0.41008683490199166},
{0.901868276756912,0.1358764115642761,0.41008683490199166},
{0.6725345923094997,-0.6685697923548376,-0.3173509963710596},
{0.6725344827700344,-0.6685698822821039,-0.317351039056966},
{0.6725345923094997,-0.6685697923548376,-0.3173509963710596},
{0.6660896147955956,-0.6628358147233202,-0.3420136075970184},
{0.6660896147955956,-0.6628358147233202,-0.3420136075970184},
{0.6660896147955956,-0.6628358147233202,-0.3420136075970184},
{0.16368520434415954,0.7252494192479167,0.6687454177483163},
{0.16368520434415954,0.7252494192479167,0.6687454177483163},
{0.16368520434415954,0.7252494192479167,0.6687454177483163},
{0.16354338763371953,0.7252285451620777,0.668802749428696},
{0.16354338763371953,0.7252285451620777,0.668802749428696},
{0.16354338763371953,0.7252285451620777,0.668802749428696},
{0.5105014197864329,-0.26036381009139425,0.8195114317632967},
{0.5105014197864329,-0.26036381009139425,0.8195114317632967},
{0.5105013932032049,-0.2603639965335242,0.8195113890890583},
{0.5129446016442029,-0.26354200084476276,0.8169660026187191},
{0.5129446016442029,-0.26354200084476276,0.8169660026187191},
{0.5129446016442029,-0.26354200084476276,0.8169660026187191},
{0.5662256218727526,-0.4068320157155305,0.7168516276912907},
{0.5662256218727526,-0.4068320157155305,0.7168516276912907},
{0.5662256218727526,-0.4068320157155305,0.7168516276912907},
{0.5767575903471082,-0.42285479292289924,0.6989595883018769},
{0.5767575903471082,-0.42285479292289924,0.6989595883018769},
{0.5767576709731618,-0.4228548520345846,0.6989594860107584},
{0.45214099527915974,0.4781819950072635,0.7529345921385497},
{0.45214099527915974,0.4781819950072635,0.7529345921385497},
{0.45214099527915974,0.4781819950072635,0.7529345921385497},
{0.8032004124217516,0.5453438084339166,0.239727403707461},
{0.8032004124217516,0.5453438084339166,0.239727403707461},
{0.8032004124217516,0.5453438084339166,0.239727403707461},
{0.860936245827672,-0.1044082055576531,0.4978832265023447},
{0.860936245827672,-0.1044082055576531,0.4978832265023447},
{0.860936245827672,-0.1044082055576531,0.4978832265023447},
{0.8607093776355517,-0.10435059728858126,0.49828738705263026},
{0.8607093776355517,-0.10435059728858126,0.49828738705263026},
{0.8607093776355517,-0.10435059728858126,0.49828738705263026},
{0.7809520498949031,-0.578803636979673,-0.2347344149971447},
{0.7809520498949031,-0.578803636979673,-0.2347344149971447},
{0.7809520498949031,-0.578803636979673,-0.2347344149971447},
{0.6818830546384596,-0.4671460374318436,-0.5628588451011943},
{0.6818830546384596,-0.4671460374318436,-0.5628588451011943},
{0.6818830546384596,-0.4671460374318436,-0.5628588451011943},
{0.2452241790863903,-0.059954994886820025,-0.9676107174786394},
{0.2452241790863903,-0.059954994886820025,-0.9676107174786394},
{0.2452241790863903,-0.059954994886820025,-0.9676107174786394},
{0.6604059807220497,-0.043557398728513386,-0.7496443781170864},
{0.6604059807220497,-0.043557398728513386,-0.7496443781170864},
{0.6604059807220497,-0.043557398728513386,-0.7496443781170864},
{-0.025997798426894585,0.3250385803321827,0.9453433427980512},
{-0.025997798426894585,0.3250385803321827,0.9453433427980512},
{-0.025997798426894585,0.3250385803321827,0.9453433427980512},
{-0.07903640111122492,0.3388836047645883,0.9375026131809681},
{-0.07903640111122492,0.3388836047645883,0.9375026131809681},
{-0.07903640111122492,0.3388836047645883,0.9375026131809681},
{0.12266178793060564,-0.32784816774114506,-0.9367335078294365},
{0.12266178793060564,-0.32784816774114506,-0.9367335078294365},
{0.12266178793060564,-0.32784816774114506,-0.9367335078294365},
{0.23839020820274498,-0.2722346093672936,-0.9322330320771136},
{0.23839020820274498,-0.2722346093672936,-0.9322330320771136},
{0.23839020820274498,-0.2722346093672936,-0.9322330320771136},
{-0.19240800322687462,0.17534540294071777,0.9655222161927731},
{-0.19240800322687462,0.17534540294071777,0.9655222161927731},
{-0.19240800322687462,0.17534540294071777,0.9655222161927731},
{-0.02632219954610684,0.11231299806330389,0.9933241828713762},
{-0.02632219954610684,0.11231299806330389,0.9933241828713762},
{-0.02632219954610684,0.11231299806330389,0.9933241828713762},
{0.2416833922471546,-0.21057779324497614,-0.9472307696142392},
{0.2416833922471546,-0.21057779324497614,-0.9472307696142392},
{0.2416833922471546,-0.21057779324497614,-0.9472307696142392},
{0.30451459093168354,-0.2009957940144298,-0.9310593722734434},
{0.30451459093168354,-0.2009957940144298,-0.9310593722734434},
{0.30451459093168354,-0.2009957940144298,-0.9310593722734434},
{-0.1958753899463394,-0.050741197395615764,0.979315149734869},
{-0.1958753899463394,-0.050741197395615764,0.979315149734869},
{-0.1958753899463394,-0.050741197395615764,0.979315149734869},
{-0.07455458732394683,0.44738992393307153,0.8912260484703735},
{-0.07455458732394683,0.44738992393307153,0.8912260484703735},
{-0.07455458732394683,0.44738992393307153,0.8912260484703735},
{0.22639656367225638,0.36817354092262805,0.9017720553010544},
{0.22639660450387522,0.36817360732435006,0.9017720179396183},
{0.22639656367225638,0.36817354092262805,0.9017720553010544},
{0.12117180078772094,-0.3294800021419034,-0.9363548060871116},
{0.12117180078772094,-0.3294800021419034,-0.9363548060871116},
{0.12117180078772094,-0.3294800021419034,-0.9363548060871116},
{0.9802809263169499,0.06962100897121759,0.18493842383077846},
{0.9802809263169499,0.06962100897121759,0.18493842383077846},
{0.9802809263169499,0.06962100897121759,0.18493842383077846},
{0.9475491121551981,0.030663803629474108,0.31813583765566067},
{0.9475491121551981,0.030663803629474108,0.31813583765566067},
{0.9475491121551981,0.030663803629474108,0.31813583765566067},
{0.5130297878660863,-0.1522275963995921,0.8447645800200677},
{0.5130297878660863,-0.1522275963995921,0.8447645800200677},
{0.5130299352261475,-0.15222758078013351,0.8447644933421875},
{0.9867541741113403,0.020831599453458416,0.16087959577913402},
{0.9867541741113403,0.020831599453458416,0.16087959577913402},
{0.9867541741113403,0.020831599453458416,0.16087959577913402},
{0.7411169691092079,0.470921380371338,0.4785171800547344},
{0.7411169691092079,0.470921380371338,0.4785171800547344},
{0.7411169691092079,0.470921380371338,0.4785171800547344},
{0.38770981677535116,0.25353201096977257,0.886229438345199},
{0.38770981677535116,0.25353201096977257,0.886229438345199},
{0.38770981677535116,0.25353201096977257,0.886229438345199},
{0.7088371618706011,0.48256937404187994,-0.5144673723260395},
{0.7088371618706011,0.48256937404187994,-0.5144673723260395},
{0.7088371618706011,0.48256937404187994,-0.5144673723260395},
{0.6654020225744294,0.48098081631775547,-0.5708744193674858},
{0.6654019466022278,0.48098076140182455,-0.5708745541879467},
{0.6654020225744294,0.48098081631775547,-0.5708744193674858},
{0.006549000547222721,-0.5689898475437696,0.822318468711454},
{0.006549000547222721,-0.5689898475437696,0.822318468711454},
{0.006549000547222721,-0.5689898475437696,0.822318468711454},
{-0.479156170814541,-0.6298165616377988,0.6113431627630157},
{-0.4791562294003084,-0.6298166386446055,0.611343037511093},
{-0.479156170814541,-0.6298165616377988,0.6113431627630157},
{-0.6362347432242337,-0.46655895836561473,0.6144331451697459},
{-0.6362347432242337,-0.46655895836561473,0.6144331451697459},
{-0.6362347432242337,-0.46655895836561473,0.6144331451697459},
{-0.38143955589930373,-0.5099655410395827,0.7709987108598481},
{-0.38143955589930373,-0.5099655410395827,0.7709987108598481},
{-0.38143955589930373,-0.5099655410395827,0.7709987108598481},
{-0.3832582113066846,-0.5058962149246873,0.7727756227980249},
{-0.3832582113066846,-0.5058962149246873,0.7727756227980249},
{-0.3832582113066846,-0.5058962149246873,0.7727756227980249},
{-0.9445261829841153,0.009021799837469932,-0.3283121940853705},
{-0.9445261829841153,0.009021799837469932,-0.3283121940853705},
{-0.9445261829841153,0.009021799837469932,-0.3283121940853705},
{0.6336111827512537,0.5917145838918014,-0.498408186431874},
{0.6336111827512537,0.5917145838918014,-0.498408186431874},
{0.6336111827512537,0.5917145838918014,-0.498408186431874},
{-0.005921199928538697,0.5311115935901629,-0.8472811897744006},
{-0.005921199928538697,0.5311115935901629,-0.8472811897744006},
{-0.005921199928538697,0.5311115935901629,-0.8472811897744006},
{0.0216025989051518,0.5515407720471863,-0.8338681577384622},
{0.0216025989051518,0.5515407720471863,-0.8338681577384622},
{0.0216025989051518,0.5515407720471863,-0.8338681577384622},
{-0.9182370361991452,0.3768644148569151,-0.12171260479820795},
{-0.9182370361991452,0.3768644148569151,-0.12171260479820795},
{-0.9182370138469224,0.37686440568307755,-0.12171280183541688},
{-0.014328799056343725,-0.530668165051618,0.8474585441886532},
{-0.014328799056343725,-0.530668165051618,0.8474585441886532},
{-0.014328799056343725,-0.530668165051618,0.8474585441886532},
{0.008348199517561238,-0.5330347691961562,0.8460521511070199},
{0.008348199517561238,-0.5330347691961562,0.8460521511070199},
{0.008348199517561238,-0.5330347691961562,0.8460521511070199},
{0.5673008019226846,-0.7001498023729338,0.43354360146935733},
{0.5673007527327529,-0.700149741663834,0.4335437638773259},
{0.5673008019226846,-0.7001498023729338,0.43354360146935733},
{-0.015800397910078662,-0.5468561276672463,0.837077489279617},
{-0.015800397910078662,-0.5468561276672463,0.837077489279617},
{-0.015800397910078662,-0.5468561276672463,0.837077489279617},
{-0.006449599038008321,0.519899522454247,-0.8542030725911111},
{-0.006449599038008321,0.519899522454247,-0.8542030725911111},
{-0.006449599038008321,0.519899522454247,-0.8542030725911111},
{0.018415400256461337,0.5199036072404168,-0.8540264118935647},
{0.018415400256461337,0.5199036072404168,-0.8540264118935647},
{0.018415400256461337,0.5199036072404168,-0.8540264118935647},
{0.9597014947887806,0.24017082372143805,-0.1459144144118244},
{0.9606150756429455,0.24475101927274354,-0.13158881036186654},
{0.8555008660763401,0.15489261196344423,-0.49409163816216717},
{0.8904331269173835,-0.196926783837164,0.41030316632422126},
{0.9562084273799003,-0.2553976073130092,0.14295980409348533},
{0.7364317923248195,0.14381759850111572,-0.6610481931104764},
{0.77638186003286,-0.09875240763591961,-0.6224782481324352},
{0.9255617945143619,-0.321368798095305,-0.20014359881378493},
{0.8901011486638339,-0.44566367443431637,0.09541401593595678},
{0.7036458916726533,-0.35822084666986037,0.6136450799471345},
{0.6888108436746316,-0.3029292192074822,0.6586148417600287},
{0.8334827957630236,-0.10894719944617129,0.541698197246299},
{0.9151918656075996,0.08383680601003113,-0.39420202825926426},
{0.5707776696968779,0.14904881820014662,-0.8074634985982596},
{0.4458201932921359,0.3034617954340774,-0.8421135873294581},
{0.4883155846069843,0.2986253905865276,-0.8199821741519647},
{0.6423411476427624,0.05729119533019372,-0.7642745377039698},
{0.7954553655195721,-0.334230185512198,-0.5055105780877447},
{0.8706976621286512,-0.4907192350152821,-0.03286660234519715},
{0.9520887590960398,0.12869099447113386,-0.2774267880810963},
{0.9342053286622606,0.14199221955570085,-0.3272592450713702},
{0.7268226248438152,0.2773150094790154,-0.6283512214779248},
{0.7779538488641852,0.33141602081662536,-0.5338082335291154},
{0.5867255501391144,0.3082677738029063,-0.7488151363644794},
{0.688768635854362,0.4321160224941199,-0.5821284303031271},
{0.8065648849183013,0.17766601870537235,-0.5638154593606937},
{0.8091479392487568,-0.057343009868334884,-0.5848003006400818},
{0.9302207207850383,-0.007986601037024752,-0.36691364764211115},
{0.9142510091554925,0.05178880051862342,-0.40182460402395204},
{0.9180896652475147,0.20018221422670623,0.34210882431325756},
{0.7794996397455495,0.5823200296916489,0.23083261176981815},
{0.6672383953672705,0.7410893948545126,0.074695599481378},
{0.680936975220241,0.49863558185431245,-0.536364980481314},
{0.9519679392403054,-0.0029423998122002784,-0.30618358045772337},
{0.6783156620199098,-0.002219400202924697,-0.7347672671814056},
{0.6360510339332981,-0.25715321371911404,-0.7275378388141156},
{0.45763039160660113,-0.01790699967156772,-0.8889621836955447},
{0.45743560047049087,0.12356000012708641,-0.8806166009057494},
{0.8963748179259549,-0.03203660064067691,-0.44213780884199577},
{0.9975304233048247,-0.02222140051914792,-0.06662780155659337},
{0.914552225131054,-0.08952440246004825,-0.3944358108387333},
{0.9629601274261916,0.03308780437842937,0.2676060354116614},
{0.7607718980317038,-0.0696794089787638,0.6452680831480891},
{0.6798280344673774,0.15875360804883037,0.7159826363004208},
{0.49137163529096073,0.5386254386847914,0.6844242491562548},
{0.5912343525995377,0.7076685432647715,0.3868425689860433},
{0.6705379256912459,-0.17282898084715909,0.7214631200477356},
{0.5600940449844478,0.17671821419327946,-0.8093610650045487},
{0.5739540088616203,-0.032799200506406535,-0.8182304126331503},
{0.6499013134256899,0.23340516890775403,-0.7232913036493014},
{0.6768482573193302,0.24809722101027282,-0.693054258691746},
{0.712931990037132,0.23394679673071056,-0.6610573907620536},
{0.6663004372230882,-0.03199580178745576,-0.744996641619477},
{0.5740051132269534,-0.24666336271160136,-0.7808170819629381},
{0.6951314481205874,0.0836996057941188,-0.7139934494263125},
{0.7110254301219531,0.1629950069051369,-0.6840142289776477},
{0.6858693904376912,0.21156579705037504,-0.6962923902923751},
{0.821841941850444,-0.2348913833802232,-0.5190393632752882},
{0.5802019443260406,0.1214355883475054,-0.8053689227198785},
{0.6544190524699213,-0.7068522566739035,-0.26850622152825504},
{0.6544190524699213,-0.7068522566739035,-0.26850622152825504},
{0.6544190524699213,-0.7068522566739035,-0.26850622152825504},
{0.6669405365949133,-0.70740073274842,-0.2340395777501907},
{0.6669405365949133,-0.70740073274842,-0.2340395777501907},
{0.6669406309537558,-0.7074006328315676,-0.2340396108621437},
{-0.19446665897910037,-0.43436706059208313,0.8794930216994902},
{-0.1874408617475352,-0.4076935988995582,0.8936732360117245},
{-0.19318740770087908,-0.42948841712036206,0.8821668351651292},
{-0.19940494175505463,-0.45329566171229835,0.8687696543252836},
{-0.8922020700788886,-0.26286002064659875,0.3672602288468157},
{-0.6939496773387529,-0.31312123489648686,0.648374072259479},
{-0.7305776104217043,-0.25460380363192836,0.6335876090381399},
{-0.7384738425846418,-0.2526852145712803,0.6251452360494637},
{-0.7390967779967196,-0.22772759322043576,0.6339369811273793},
{-0.2619135894899108,0.2334591906317311,-0.9364283624229285},
{-0.18293599226357488,0.5354051773575336,-0.8245457651296799},
{-0.10942419748109657,0.5629931870401109,-0.8191855811426594},
{-0.12507080077653707,0.46447180288380324,-0.8767116054433094},
{-0.32943036738290987,0.2293757772893724,-0.9158943093167777},
{-0.4718767720777215,0.4950055707091253,-0.7295901568280942},
{-0.1733857726924538,0.5876029074549586,-0.7903544755224203},
{-0.17847719106498228,0.6171897691019256,-0.7663045616368634},
{-0.5880697940011,0.36530499627352375,-0.7216135926388199},
{-0.5786621934406788,0.24781959719088556,-0.7770041911924088},
{-0.4824531866904869,-0.1588157956187233,-0.8614037762363166},
{-0.18850918697279032,0.14172059020618638,-0.971791932842863},
{-0.05897559458534593,0.4455333590947911,-0.8933207179826386},
{-0.12302918231543963,0.30783195575136973,-0.9434528643854344},
{-0.2243177921539694,0.552027580691566,-0.8030859719102216},
{-0.3528272251035733,0.7659440544967376,-0.537440838238788},
{-0.4467583625850877,0.7354013384119495,-0.5095015573304997},
{-0.07139339994771433,0.6170495995480976,-0.7836789994260649},
{-0.15202640878745505,0.6358456367532523,-0.756695643738644},
{-0.5870748577687559,0.6287914618737117,-0.5098670501714301},
{-0.6348391867736463,0.48173338996348,-0.6040795874144973},
{-0.3038943650717877,0.7998975080634813,-0.5175057405202844},
{-0.1632475874360352,0.7956495387647133,-0.5833455551041878},
{-0.22438837907504416,0.7411579308845804,-0.6327201409967617},
{0.03568779848189604,0.674473771308925,-0.7374357686306187},
{-0.08046819344674301,0.724962940959673,-0.6840713442898476},
{-0.21291181297894696,0.8419780513263604,-0.49572323021892223},
{-0.06922679670575574,0.7121107661133128,-0.6986457667540616},
{-0.01432519854774697,0.7690019220404961,-0.639085935211056},
{-0.9741841132255878,0.03245280377186174,-0.22341022596609186},
{-0.9745567558882204,-0.14000242239451766,0.1750384279988096},
{-0.9838677219504117,-0.13173681632877943,0.12103601500241501},
{-0.9670434932598608,0.018623401796005943,-0.25392922448845817},
{-0.8775922061368092,0.19824760138630187,-0.4364972030523289},
{-0.91403063933743,0.1938094083410377,-0.3563508153363844},
{-0.5356552669112105,0.22178422770410758,-0.814791501779426},
{-0.35810855298221944,0.1851777756871263,-0.9151324798478903},
{-0.5974917824450942,-0.028668999157676144,-0.8013623764551723},
{-0.5237903310926418,-0.05724939246854292,-0.8499212881884083},
{-0.8796889830964245,-0.032286399379603925,-0.4744521908832115},
{-0.8903992112770842,0.012886400163208836,-0.45499800576264077},
{-0.9571869402192057,-0.11575941695770472,0.2653166388664814},
{-0.9631276545480462,-0.12145460687874704,0.2400706135967261},
{-0.8519967283901381,-0.2073191825749354,0.480749759593244},
{-0.4102951835594231,-0.12050659517128637,-0.9039557637783848},
{-0.4098992078290749,-0.11891560227128803,-0.904346017273009},
{0.07518159958435702,0.45445019748756293,-0.8875937950929199},
{-0.2166683726521674,0.1926215756873486,-0.9570536792009029},
{-0.04468980442796347,0.2030794201215527,-0.9781418969164364},
{0.08122940371032854,0.45046442057593583,-0.8890914406111728},
{-0.9056045613306679,0.4203451820512527,0.05648279758818346},
{-0.9056045613306679,0.4203451820512527,0.05648279758818346},
{-0.9056045613306679,0.4203451820512527,0.05648279758818346},
{-0.7749574686209679,0.3648890323102101,-0.5160396456943013},
{-0.7749574686209679,0.3648890323102101,-0.5160396456943013},
{-0.7749574686209679,0.3648890323102101,-0.5160396456943013},
{-0.8334988158905384,0.44184720842375536,0.33173900632455783},
{-0.8334988158905384,0.44184720842375536,0.33173900632455783},
{-0.8334987605897123,0.441847179108158,0.33173918431438976},
{-0.36769974753567713,0.6471229076668793,0.6678539047089286},
{-0.36769974753567713,0.6471229076668793,0.6678539047089286},
{-0.36769974753567713,0.6471229076668793,0.6678539047089286},
{-0.39808757553904783,-0.869881546549121,-0.29125998210319304},
{-0.39808757553904783,-0.869881546549121,-0.29125998210319304},
{-0.39808757553904783,-0.869881546549121,-0.29125998210319304},
{-0.46094602354138065,-0.6922470353543584,-0.555268228358593},
{-0.46094602354138065,-0.6922470353543584,-0.555268228358593},
{-0.46094602354138065,-0.6922470353543584,-0.555268228358593},
{-0.9356497384747867,0.2860674423375612,0.20670023059133047},
{-0.9356497384747867,0.2860674423375612,0.20670023059133047},
{-0.9356497384747867,0.2860674423375612,0.20670023059133047},
{-0.4520277619646318,0.5284013555382615,0.7186535395297053},
{-0.4520277619646318,0.5284013555382615,0.7186535395297053},
{-0.4520277619646318,0.5284013555382615,0.7186535395297053},
{0.060377988938859706,-0.8435150454695425,-0.5337011022269064},
{0.06037799912480763,-0.8435149877730649,-0.5337011922638839},
{0.06037799912480763,-0.8435149877730649,-0.5337011922638839},
{0.05961279818406901,-0.84137437436997,-0.5371549836371314},
{0.05961279818406901,-0.84137437436997,-0.5371549836371314},
{0.05961279818406901,-0.84137437436997,-0.5371549836371314},
{-0.9698795458099992,0.14311819200356893,-0.197106188987102},
{-0.9698795458099992,0.14311819200356893,-0.197106188987102},
{-0.9698795458099992,0.14311819200356893,-0.197106188987102},
{-0.9699971195309094,0.14313541763830664,-0.19651422421607595},
{-0.9699971195309094,0.14313541763830664,-0.19651422421607595},
{-0.9699971195309094,0.14313541763830664,-0.19651422421607595},
{-0.389453982539462,-0.6368609714473707,-0.6653823701686601},
{-0.389453982539462,-0.6368609714473707,-0.6653823701686601},
{-0.389453982539462,-0.6368609714473707,-0.6653823701686601},
{-0.40663499912864626,-0.6431051986219285,-0.6488941986095235},
{-0.40663499912864626,-0.6431051986219285,-0.6488941986095235},
{-0.40663499912864626,-0.6431051986219285,-0.6488941986095235},
{-0.4614079719006891,0.7461903545577101,0.479898570774629},
{-0.4614079719006891,0.7461903545577101,0.479898570774629},
{-0.4614079719006891,0.7461903545577101,0.479898570774629},
{-0.4613308245700559,0.7461698397403203,0.48000462556460544},
{-0.4613308245700559,0.7461698397403203,0.48000462556460544},
{-0.4613308245700559,0.7461698397403203,0.48000462556460544},
{-0.8682944756481451,-0.2713802236433734,0.415231836176112},
{-0.8682944756481451,-0.2713802236433734,0.415231836176112},
{-0.8682944756481451,-0.2713802236433734,0.415231836176112},
{-0.8681482712018085,-0.2707956222094988,0.4159186341118676},
{-0.8681482712018085,-0.2707956222094988,0.4159186341118676},
{-0.8681482712018085,-0.2707956222094988,0.4159186341118676},
{-0.8587000528972645,-0.44064182714422484,0.261665816119023},
{-0.8587000528972645,-0.44064182714422484,0.261665816119023},
{-0.8587000528972645,-0.44064182714422484,0.261665816119023},
{-0.8594931984874983,-0.4235351992546797,0.2861631994964215},
{-0.8594931984874983,-0.4235351992546797,0.2861631994964215},
{-0.8594931984874983,-0.4235351992546797,0.2861631994964215},
{-0.7883378088295571,0.5493056061523437,-0.27710440310363027},
{-0.7883378088295571,0.5493056061523437,-0.27710440310363027},
{-0.7883378088295571,0.5493056061523437,-0.27710440310363027},
{-0.7699936412983174,0.5084092272683364,0.38552542067750994},
{-0.7699935819278813,0.5084091880673924,0.3855255909515294},
{-0.7699935819278813,0.5084091880673924,0.3855255909515294},
{-0.9904264309633257,-0.09801720306427464,-0.09720140303877059},
{-0.9904264309633257,-0.09801720306427464,-0.09720140303877059},
{-0.9904264309633257,-0.09801720306427464,-0.09720140303877059},
{-0.9904400745999098,-0.09800380738164313,-0.0970758073117462},
{-0.9904400745999098,-0.09800380738164313,-0.0970758073117462},
{-0.9904400745999098,-0.09800380738164313,-0.0970758073117462},
{-0.3016281821317762,-0.4410831738705687,-0.8452609499273851},
{-0.3016281821317762,-0.4410831738705687,-0.8452609499273851},
{-0.3016281821317762,-0.4410831738705687,-0.8452609499273851},
{-0.5316306329174428,-0.5519368341747598,-0.6424442397787866},
{-0.5316306329174428,-0.5519368341747598,-0.6424442397787866},
{-0.5316306329174428,-0.5519368341747598,-0.6424442397787866},
{-0.20683861243781013,-0.05147040309506574,-0.9770202587510829},
{-0.20683861243781013,-0.05147040309506574,-0.9770202587510829},
{-0.20683861243781013,-0.05147040309506574,-0.9770202587510829},
{0.23723657826820518,-0.06062899444614791,-0.9695581111846998},
{0.23723657826820518,-0.06062899444614791,-0.9695581111846998},
{0.2372365811448833,-0.06062879518133755,-0.9695581229413464},
{-0.3759577525252535,0.3456195563562642,0.8597690914311},
{-0.3759577525252535,0.3456195563562642,0.8597690914311},
{-0.3759577525252535,0.3456195563562642,0.8597690914311},
{-0.42882976190088745,0.3336873703537538,0.8394985254152774},
{-0.42882976190088745,0.3336873703537538,0.8394985254152774},
{-0.42882976190088745,0.3336873703537538,0.8394985254152774},
{0.2302785572608058,-0.27224214947245523,-0.9342676266019813},
{0.2302785572608058,-0.27224214947245523,-0.9342676266019813},
{0.2302785572608058,-0.27224214947245523,-0.9342676266019813},
{0.33575996654900847,-0.3326585668579937,-0.8812511122029829},
{0.33575978909595927,-0.33265858919667296,-0.881251171380734},
{0.33575978909595927,-0.33265858919667296,-0.881251171380734},
{-0.4509282142665933,0.1142302036140472,0.8852204280068522},
{-0.4509282142665933,0.1142302036140472,0.8852204280068522},
{-0.4509282142665933,0.1142302036140472,0.8852204280068522},
{-0.2830513876521495,0.17798499223557215,0.9424453588867079},
{-0.2830513876521495,0.17798499223557215,0.9424453588867079},
{-0.2830513876521495,0.17798499223557215,0.9424453588867079},
{0.16913699534610432,-0.20087479447282167,-0.9649051734501135},
{0.16913699534610432,-0.20087479447282167,-0.9649051734501135},
{0.16913699534610432,-0.20087479447282167,-0.9649051734501135},
{0.23384022187609987,-0.2119288198262557,-0.9488966887706938},
{0.23384022187609987,-0.2119288198262557,-0.9488966887706938},
{0.23384022187609987,-0.2119288198262557,-0.9488966887706938},
{-0.28565637905836594,-0.05149619622478413,0.956947529845624},
{-0.28565637905836594,-0.05149619622478413,0.956947529845624},
{-0.285656195378277,-0.051496199166826524,0.9569475845172388},
{-0.6422421422945204,0.388845965062176,0.6605481406497258},
{-0.6422421422945204,0.388845965062176,0.6605481406497258},
{-0.6422421422945204,0.388845965062176,0.6605481406497258},
{-0.35806818600948126,0.4555101822022062,0.8150445681543999},
{-0.35806818600948126,0.4555101822022062,0.8150445681543999},
{-0.35806818600948126,0.4555101822022062,0.8150445681543999},
{0.3370588032468201,-0.33455640322271496,-0.880036008477211},
{0.3370588032468201,-0.33455640322271496,-0.880036008477211},
{0.3370588032468201,-0.33455640322271496,-0.880036008477211},
{-0.9572694486385939,0.01031180052393971,-0.2890136146847012},
{-0.9572694486385939,0.01031180052393971,-0.2890136146847012},
{-0.9572694486385939,0.01031180052393971,-0.2890136146847012},
{-0.9042440354441967,0.05119880200687021,-0.4239356166172591},
{-0.9042440354441967,0.05119880200687021,-0.4239356166172591},
{-0.9042440354441967,0.05119880200687021,-0.4239356166172591},
{-0.8970084713690646,0.01246220099153537,-0.4418376351541148},
{-0.8970084713690646,0.01246220099153537,-0.4418376351541148},
{-0.8970084713690646,0.01246220099153537,-0.4418376351541148},
{-0.8781944397872498,-0.1700454077040332,0.44705602025420427},
{-0.8781944397872498,-0.1700454077040332,0.44705602025420427},
{-0.8781944397872498,-0.1700454077040332,0.44705602025420427},
{-0.7849570758461044,0.2640564255143266,0.560461054154283},
{-0.7849570758461044,0.2640564255143266,0.560461054154283},
{-0.7849570758461044,0.2640564255143266,0.560461054154283},
{-0.8761644673884577,0.4801216369276064,-0.042650203280356055},
{-0.8761644673884577,0.4801216369276064,-0.042650203280356055},
{-0.8761644673884577,0.4801216369276064,-0.042650203280356055},
{-0.29374940654241616,0.4446550099034009,-0.8461638188458454},
{-0.29374940654241616,0.4446550099034009,-0.8461638188458454},
{-0.29374940654241616,0.4446550099034009,-0.8461638188458454},
{-0.3511286030116019,0.4437968038064096,-0.8244714070714253},
{-0.3511286030116019,0.4437968038064096,-0.8244714070714253},
{-0.3511286030116019,0.4437968038064096,-0.8244714070714253},
{0.13041578956236832,-0.5980069521394126,0.7908093367087635},
{0.13041578956236832,-0.5980069521394126,0.7908093367087635},
{0.13041578956236832,-0.5980069521394126,0.7908093367087635},
{-0.3805982427154414,-0.5868452658630328,0.714673080209451},
{-0.3805981980449813,-0.5868453969855513,0.7146729963289392},
{-0.3805981980449813,-0.5868453969855513,0.7146729963289392},
{-0.026820394765069273,-0.4937767036223419,0.8691750303503317},
{-0.026820397413725834,-0.49377655238543555,0.8691751161859865},
{-0.026820394765069273,-0.4937767036223419,0.8691750303503317},
{0.25035957318766283,-0.4312681538132015,0.8667917071706697},
{0.25035957318766283,-0.4312681538132015,0.8667917071706697},
{0.25035957318766283,-0.4312681538132015,0.8667917071706697},
{0.9582554476506523,0.040374402007676134,0.283048414074996},
{0.9582554476506523,0.040374402007676134,0.283048414074996},
{0.9582554476506523,0.040374402007676134,0.283048414074996},
{-0.026304197536615174,-0.49077655403883674,0.8708883184414172},
{-0.026304197536615174,-0.49077655403883674,0.8708883184414172},
{-0.026304197536615174,-0.49077655403883674,0.8708883184414172},
{0.3932521927411073,0.5488965898681265,-0.7376077863847782},
{0.3932521927411073,0.5488965898681265,-0.7376077863847782},
{0.3932521927411073,0.5488965898681265,-0.7376077863847782},
{-0.30225722231844443,0.5485482405043868,-0.7795738575631433},
{-0.30225722231844443,0.5485482405043868,-0.7795738575631433},
{-0.30225722231844443,0.5485482405043868,-0.7795738575631433},
{0.7994757877386317,0.41050279370421716,0.4385497932740671},
{0.7994757877386317,0.41050279370421716,0.4385497932740671},
{0.7994757877386317,0.41050279370421716,0.4385497932740671},
{0.3559867978539621,0.5677897965771247,-0.7422183955255959},
{0.3559867978539621,0.5677897965771247,-0.7422183955255959},
{0.3559867978539621,0.5677897965771247,-0.7422183955255959},
{-0.3939028186630451,-0.5540476262506774,0.7333974347482394},
{-0.3939028186630451,-0.5540476262506774,0.7333974347482394},
{-0.3939028186630451,-0.5540476262506774,0.7333974347482394},
{-0.36964821056859,-0.5483688156783801,0.7501012214460994},
{-0.36964821056859,-0.5483688156783801,0.7501012214460994},
{-0.36964821056859,-0.5483688156783801,0.7501012214460994},
{-0.36250320112467344,-0.5644906017513434,0.7415806023007686},
{-0.36250320112467344,-0.5644906017513434,0.7415806023007686},
{-0.36250320112467344,-0.5644906017513434,0.7415806023007686},
{-0.6692880273423976,-0.74248523033272,0.027734801133048742},
{-0.6692880273423976,-0.74248523033272,0.027734801133048742},
{-0.6692880273423976,-0.74248523033272,0.027734801133048742},
{0.36933797695509857,0.5380553664279504,-0.7576845527241526},
{0.36933797695509857,0.5380553664279504,-0.7576845527241526},
{0.36933797695509857,0.5380553664279504,-0.7576845527241526},
{0.39626319215814176,0.5410103892936642,-0.7418107853199208},
{0.39626319215814176,0.5410103892936642,-0.7418107853199208},
{0.39626319215814176,0.5410103892936642,-0.7418107853199208},
{-0.7525587406337138,0.4170811670981697,-0.5096063597992351},
{-0.7334801785727265,0.3967377884100357,-0.5519111838769305},
{-0.7100528115984855,0.23422140382593168,-0.6640522108470804},
{-0.7173027468155324,0.23849658231665247,-0.6546725514592531},
{-0.4646851279126582,0.12081038125849372,-0.8771958639192127},
{-0.29350455878005244,0.11784798344936201,-0.9486658667688249},
{-0.860918520663762,-0.29552617276637194,-0.41410576183890524},
{-0.9556630523245987,-0.2376704130129641,-0.1738416095182004},
{-0.9073577183530445,-0.4076564531734964,0.1025582133773886},
{-0.7660822468145827,-0.46809502860485747,-0.44046002691610786},
{-0.6463831251487092,-0.3398749606424139,-0.6831353208927978},
{-0.3404111880066741,-0.11585939591805572,-0.9331113671247327},
{-0.18321801279189734,0.03536840246934767,-0.9824358685916116},
{-0.0399257996075246,0.2774185972729419,-0.9599191905638792},
{0.005803999521395603,0.28630577639090027,-0.9581207209922764},
{-0.10028699781734776,0.1343613970757505,-0.9858445785440196},
{-0.5646968132448962,0.051946001218387244,-0.8236620193188942},
{-0.9892471429805678,-0.14267839177612904,-0.03213979814748716},
{-0.9248743230044194,-0.34878477096374577,0.15151458738644447},
{-0.6423079810182836,0.10699739683797446,-0.7589413775714915},
{-0.39167838235075314,0.3112979859727387,-0.8658415609846953},
{-0.3104208018848503,0.25453360154550764,-0.9158884055612012},
{-0.6030175678734923,0.12053159357853008,-0.7885695579879801},
{-0.39663955692141645,0.15847418278829428,-0.9041919017967175},
{-0.29966677113438395,0.4011513613588082,-0.8656081166196791},
{-0.15162739920981197,0.297785998448124,-0.9425139950882013},
{-0.3111179767809862,0.46248456548436184,-0.8302491380377619},
{-0.592768934659155,0.7241659201752819,-0.3524325611514032},
{-0.7797480385187431,0.5800408286534143,-0.23568121164240705},
{-0.9540415319140152,0.19178522651788044,-0.2302676318387899},
{-0.5536147489177701,0.03141579710125322,-0.8321801232144439},
{-0.5801262533985241,-0.022975202114784283,-0.8142024749443938},
{-0.38519121288778174,-0.06715320224682128,-0.9203902307945457},
{-0.10308399100906004,-0.038571396635819905,-0.9939245133103451},
{-0.09841159135116459,0.1618431857765223,-0.9818971137066437},
{-0.22427817668677819,-0.012429398707991417,-0.974445898708498},
{-0.6317489619217747,-0.028705798269778152,-0.7746413533090359},
{-0.5230722175228987,-0.050737001699687555,-0.8507768285009902},
{0.01579599887585661,0.1129321919630295,-0.9934771292978714},
{0.02230619949616631,-0.02323379947521446,-0.999481177424559},
{-0.187485994954092,-0.2530747931888666,-0.9491059744562177},
{-0.9473413038350356,0.006520600714702087,-0.3201592350916248},
{-0.9908492785305751,-0.09767540774134484,0.09315160738280731},
{-0.9521576331051312,-0.21055500732069032,0.2215004077012459},
{-0.2092346080973753,0.20327920786690143,-0.9565032370166568},
{-0.2463587687925493,0.21489917277768766,-0.9450532802855534},
{-0.3307671541926737,0.1789108293541367,-0.9265980816120304},
{-0.792157610129969,-0.054239800693608814,-0.6079016077737364},
{-0.5577854363443407,-0.1042402067921128,-0.823413253652193},
{-0.28717180288252714,0.19825320198999424,-0.9371382094066559},
{-0.25104539788103125,0.18443319844327685,-0.9502423919794031},
{-0.2738931843639535,0.13662379220040477,-0.9520065456517376},
{-0.20640179269543243,0.20231799283995827,-0.9573221661203308},
{-0.400322391244373,-0.3361223926485194,-0.8525043813545019},
{-0.20531418777604526,-0.049313597063977005,-0.977452941804604},
{-0.6071255111766671,-0.008720975395851243,-0.7945580899258503},
{-0.054901395452852504,0.10943219093639954,-0.9924769177991944},
{0.03078739814910909,-0.6029369637523594,-0.7971945520738927},
{-0.11177259965043343,-0.2509267992152315,-0.9615313969928297},
{-0.7804550027053223,0.5492126019037575,0.29875660103559193},
{-0.6978501948952818,0.7156335947651976,-0.029557799783787062},
{-0.9666910348211977,0.14905640536916387,0.2080640074946779},
{-0.6801548208776518,-0.5067252155541536,-0.5297348162604435},
{-0.4160374117753733,-0.7063370199919089,-0.5727136162098801},
{-0.41603757715793177,-0.7063369612193754,-0.5727135685558152},
{-0.4160374117753733,-0.7063370199919089,-0.5727136162098801},
{-0.38969362770063987,-0.7042656500614015,-0.5934212421822348},
{-0.38969362770063987,-0.7042656500614015,-0.5934212421822348},
{-0.38969362770063987,-0.7042656500614015,-0.5934212421822348}
};


// face array: 7kb.
const uint16_t elementalist_1_face[3839] PROGMEM = {
10, // chain 0
0,0,0, 1,1,1, 2,2,2, 
3,3,3, 32772,4,4, 32773,5,5, 6,6,6, 32775,7,7, 8,8,8, 9,9,9, 32778,10,10, 32779,11,11, 
8, // chain 1
12,12,12, 13,13,13, 3,3,3, 
4,4,4, 6,6,6, 14,14,14, 32783,15,15, 32777,9,9, 16,16,16, 32778,10,10, 
4, // chain 2
17,17,17, 18,18,18, 0,0,0, 
19,19,19, 32781,13,13, 32771,3,3, 
4, // chain 3
18,18,18, 17,17,17, 20,20,20, 
21,21,21, 22,22,22, 32791,23,23, 
2, // chain 4
1,1,1, 0,0,0, 18,18,18, 
22,22,22, 
36, // chain 5
24,24,24, 25,25,25, 26,26,26, 
27,27,27, 32796,28,28, 29,29,29, 32798,30,30, 31,31,31, 32800,32,32, 33,33,33, 32802,34,34, 35,35,35, 32804,36,36, 32805,37,37, 38,38,38, 32807,39,39, 40,40,40, 41,41,41, 42,42,42, 
43,43,43, 36,36,36, 32812,44,44, 35,35,35, 32813,45,45, 33,33,33, 32814,46,46, 47,47,47, 31,31,31, 32816,48,48, 29,29,29, 32795,27,27, 32817,49,49, 50,50,50, 24,24,24, 32819,51,51, 
52,52,52, 32821,53,53, 32822,54,54, 
2, // chain 6
24,24,24, 52,52,52, 55,55,55, 
25,25,25, 
2, // chain 7
55,55,55, 52,52,52, 53,53,53, 
56,56,56, 
12, // chain 8
57,57,57, 58,58,58, 59,59,59, 
60,60,60, 32829,61,61, 62,62,62, 63,63,63, 57,57,57, 32832,64,64, 65,65,65, 32834,66,66, 67,67,67, 68,68,68, 32837,69,69, 
2, // chain 9
65,65,65, 68,68,68, 58,58,58, 
57,57,57, 
16, // chain 10
70,70,70, 71,71,71, 72,72,72, 
73,73,73, 32842,74,74, 32843,75,75, 32844,76,76, 32845,77,77, 32839,71,71, 78,78,78, 32847,79,79, 32838,70,70, 80,80,80, 32849,81,81, 32850,82,82, 32841,73,73, 83,83,83, 32852,84,84, 
3, // chain 11
74,74,74, 85,85,85, 86,86,86, 
87,87,87, 73,73,73, 
2, // chain 12
88,88,88, 85,85,85, 74,74,74, 
75,75,75, 
2, // chain 13
85,85,85, 89,89,89, 90,90,90, 
86,86,86, 
2, // chain 14
88,88,88, 91,91,91, 89,89,89, 
85,85,85, 
8, // chain 15
92,92,92, 93,93,93, 90,90,90, 
89,89,89, 91,91,91, 94,94,94, 95,95,95, 96,96,96, 97,97,97, 93,93,93, 
5, // chain 16
81,81,81, 98,98,98, 99,99,99, 
80,80,80, 32847,79,79, 32868,100,100, 32869,101,101, 
2, // chain 17
79,79,79, 100,100,100, 102,102,102, 
78,78,78, 
3, // chain 18
103,103,103, 104,104,104, 105,105,105, 
99,99,99, 98,98,98, 
10, // chain 19
106,106,106, 107,107,107, 108,108,108, 
109,109,109, 110,110,110, 32879,111,111, 112,112,112, 32881,113,113, 114,114,114, 115,115,115, 116,116,116, 32885,117,117, 
6, // chain 20
118,118,118, 119,119,119, 107,107,107, 
106,106,106, 120,120,120, 32878,110,110, 112,112,112, 116,116,116, 
2, // chain 21
121,121,121, 122,122,122, 123,123,123, 
124,124,124, 
5, // chain 22
121,121,121, 125,125,125, 126,126,126, 
122,122,122, 32895,127,127, 32896,128,128, 32893,125,125, 
3, // chain 23
129,129,129, 123,123,123, 122,122,122, 
130,130,130, 32895,127,127, 
14, // chain 24
131,131,131, 132,132,132, 133,133,133, 
134,134,134, 32903,135,135, 136,136,136, 32905,137,137, 32906,138,138, 139,139,139, 32908,140,140, 141,141,141, 142,142,142, 32911,143,143, 32912,144,144, 145,145,145, 32914,146,146, 
15, // chain 25
147,147,147, 148,148,148, 132,132,132, 
131,131,131, 149,149,149, 32918,150,150, 32902,134,134, 151,151,151, 32904,136,136, 152,152,152, 32921,153,153, 32905,137,137, 154,154,154, 32907,139,139, 142,142,142, 155,155,155, 32911,143,143, 
2, // chain 26
156,156,156, 157,157,157, 158,158,158, 
159,159,159, 
2, // chain 27
157,157,157, 160,160,160, 161,161,161, 
158,158,158, 
2, // chain 28
162,162,162, 163,163,163, 164,164,164, 
165,165,165, 
2, // chain 29
163,163,163, 166,166,166, 167,167,167, 
164,164,164, 
17, // chain 30
168,168,168, 169,169,169, 170,170,170, 
171,171,171, 32940,172,172, 32941,173,173, 32942,174,174, 32937,169,169, 175,175,175, 32944,176,176, 32936,168,168, 177,177,177, 32946,178,178, 32939,171,171, 179,179,179, 32940,172,172, 180,180,180, 32949,181,181, 32941,173,173, 
4, // chain 31
179,179,179, 180,180,180, 182,182,182, 
32951,183,183, 32952,184,184, 32949,181,181, 
5, // chain 32
182,182,182, 183,183,183, 185,185,185, 
32954,186,186, 32955,187,187, 32956,188,188, 32952,184,184, 
7, // chain 33
178,178,178, 179,179,179, 189,189,189, 
32950,182,182, 190,190,190, 32959,191,191, 32953,185,185, 192,192,192, 32954,186,186, 
7, // chain 34
176,176,176, 177,177,177, 193,193,193, 
194,194,194, 195,195,195, 175,175,175, 32964,196,196, 197,197,197, 32966,198,198, 
2, // chain 35
174,174,174, 175,175,175, 199,199,199, 
32965,197,197, 
24, // chain 36
200,200,200, 201,201,201, 202,202,202, 
203,203,203, 32972,204,204, 32973,205,205, 206,206,206, 207,207,207, 32976,208,208, 209,209,209, 32978,210,210, 211,211,211, 212,212,212, 213,213,213, 207,207,207, 32982,214,214, 215,215,215, 204,204,204, 32984,216,216, 
203,203,203, 32985,217,217, 200,200,200, 32986,218,218, 32987,219,219, 220,220,220, 32989,221,221, 
5, // chain 37
201,201,201, 222,222,222, 223,223,223, 
224,224,224, 202,202,202, 32993,225,225, 226,226,226, 
3, // chain 38
227,227,227, 228,228,228, 229,229,229, 
223,223,223, 222,222,222, 
2, // chain 39
200,200,200, 218,218,218, 222,222,222, 
201,201,201, 
2, // chain 40
222,222,222, 218,218,218, 220,220,220, 
230,230,230, 
21, // chain 41
231,231,231, 232,232,232, 233,233,233, 
234,234,234, 235,235,235, 33004,236,236, 237,237,237, 238,238,238, 33007,239,239, 33008,240,240, 241,241,241, 242,242,242, 243,243,243, 238,238,238, 33012,244,244, 245,245,245, 235,235,235, 33014,246,246, 231,231,231, 
33000,232,232, 33015,247,247, 248,248,248, 33017,249,249, 
2, // chain 42
232,232,232, 248,248,248, 250,250,250, 
233,233,233, 
4, // chain 43
251,251,251, 252,252,252, 253,253,253, 
254,254,254, 33023,255,255, 33024,256,256, 
6, // chain 44
251,251,251, 254,254,254, 257,257,257, 
258,258,258, 33027,259,259, 33028,260,260, 33023,255,255, 33022,254,254, 
4, // chain 45
258,258,258, 259,259,259, 261,261,261, 
33030,262,262, 33031,263,263, 33028,260,260, 
15, // chain 46
261,261,261, 262,262,262, 264,264,264, 
33033,265,265, 266,266,266, 267,267,267, 268,268,268, 261,261,261, 33037,269,269, 258,258,258, 33038,270,270, 271,271,271, 251,251,251, 33020,252,252, 33040,272,272, 273,273,273, 253,253,253, 
28, // chain 47
274,274,274, 275,275,275, 276,276,276, 
277,277,277, 33046,278,278, 279,279,279, 33048,280,280, 33049,281,281, 282,282,282, 283,283,283, 284,284,284, 33053,285,285, 33054,286,286, 287,287,287, 288,288,288, 33057,289,289, 290,290,290, 33059,291,291, 292,292,292, 
33061,293,293, 294,294,294, 33063,295,295, 296,296,296, 297,297,297, 298,298,298, 33067,299,299, 300,300,300, 33069,301,301, 302,302,302, 33071,303,303, 
4, // chain 48
304,304,304, 305,305,305, 275,275,275, 
274,274,274, 279,279,279, 33045,277,277, 
11, // chain 49
304,304,304, 306,306,306, 307,307,307, 
308,308,308, 33077,309,309, 33078,310,310, 33056,288,288, 33053,285,285, 33074,306,306, 284,284,284, 33048,280,280, 33047,279,279, 33072,304,304, 
6, // chain 50
288,288,288, 290,290,290, 311,311,311, 
310,310,310, 33080,312,312, 33081,313,313, 33060,292,292, 33058,290,290, 
6, // chain 51
309,309,309, 312,312,312, 314,314,314, 
315,315,315, 308,308,308, 33084,316,316, 304,304,304, 33073,305,305, 
6, // chain 52
314,314,314, 312,312,312, 317,317,317, 
318,318,318, 33068,300,300, 33066,298,298, 33081,313,313, 33080,312,312, 
1, // chain 53
318,318,318, 300,300,300, 302,302,302, 
2, // chain 54
292,292,292, 294,294,294, 298,298,298, 
313,313,313, 
1, // chain 55
310,310,310, 312,312,312, 309,309,309, 
40, // chain 56
319,319,319, 320,320,320, 321,321,321, 
322,322,322, 33091,323,323, 324,324,324, 33093,325,325, 326,326,326, 33095,327,327, 33096,328,328, 329,329,329, 330,330,330, 33099,331,331, 332,332,332, 33101,333,333, 334,334,334, 33103,335,335, 336,336,336, 33105,337,337, 
338,338,338, 339,339,339, 340,340,340, 334,334,334, 33109,341,341, 342,342,342, 332,332,332, 33111,343,343, 330,330,330, 33112,344,344, 327,327,327, 33094,326,326, 33113,345,345, 346,346,346, 324,324,324, 33115,347,347, 
322,322,322, 33116,348,348, 319,319,319, 33117,349,349, 33118,350,350, 351,351,351, 33120,352,352, 
4, // chain 57
349,349,349, 351,351,351, 353,353,353, 
354,354,354, 320,320,320, 319,319,319, 
17, // chain 58
355,355,355, 356,356,356, 357,357,357, 
358,358,358, 33127,359,359, 33128,360,360, 33129,361,361, 33124,356,356, 362,362,362, 363,363,363, 364,364,364, 33133,365,365, 33134,366,366, 367,367,367, 368,368,368, 364,364,364, 33137,369,369, 360,360,360, 361,361,361, 
1, // chain 59
358,358,358, 359,359,359, 370,370,370, 
2, // chain 60
371,371,371, 108,108,108, 107,107,107, 
119,119,119, 
6, // chain 61
372,372,372, 373,373,373, 374,374,374, 
375,375,375, 376,376,376, 33145,377,377, 378,378,378, 33147,379,379, 
11, // chain 62
380,380,380, 381,381,381, 382,382,382, 
383,383,383, 33152,384,384, 33153,385,385, 33154,386,386, 33155,387,387, 33156,388,388, 33149,381,381, 373,373,373, 33142,374,374, 33148,380,380, 
2, // chain 63
384,384,384, 385,385,385, 389,389,389, 
390,390,390, 
7, // chain 64
388,388,388, 373,373,373, 391,391,391, 
33140,372,372, 392,392,392, 33161,393,393, 33144,376,376, 394,394,394, 33146,378,378, 
2, // chain 65
385,385,385, 386,386,386, 395,395,395, 
389,389,389, 
6, // chain 66
396,396,396, 397,397,397, 398,398,398, 
399,399,399, 400,400,400, 401,401,401, 33170,402,402, 33171,403,403, 
6, // chain 67
404,404,404, 405,405,405, 406,406,406, 
407,407,407, 33176,408,408, 33165,397,397, 33173,405,405, 398,398,398, 
4, // chain 68
409,409,409, 404,404,404, 407,407,407, 
410,410,410, 33179,411,411, 33176,408,408, 
5, // chain 69
412,412,412, 409,409,409, 410,410,410, 
413,413,413, 33182,414,414, 33183,415,415, 33179,411,411, 
7, // chain 70
408,408,408, 397,397,397, 416,416,416, 
33185,417,417, 33164,396,396, 418,418,418, 33169,401,401, 402,402,402, 419,419,419, 
11, // chain 71
420,420,420, 421,421,421, 422,422,422, 
423,423,423, 33192,424,424, 33193,425,425, 33194,426,426, 33195,427,427, 33189,421,421, 428,428,428, 33181,413,413, 33180,412,412, 33188,420,420, 
1, // chain 72
428,428,428, 413,413,413, 414,414,414, 
6, // chain 73
429,429,429, 430,430,430, 431,431,431, 
432,432,432, 433,433,433, 33202,434,434, 435,435,435, 33204,436,436, 
6, // chain 74
437,437,437, 438,438,438, 430,430,430, 
429,429,429, 439,439,439, 33201,433,433, 440,440,440, 33203,435,435, 
24, // chain 75
441,441,441, 442,442,442, 443,443,443, 
444,444,444, 33213,445,445, 33214,446,446, 33215,447,447, 33216,448,448, 33210,442,442, 449,449,449, 450,450,450, 451,451,451, 33220,452,452, 453,453,453, 33222,454,454, 33223,455,455, 456,456,456, 457,457,457, 458,458,458, 
459,459,459, 460,460,460, 453,453,453, 33229,461,461, 451,451,451, 33216,448,448, 33215,447,447, 
8, // chain 76
441,441,441, 444,444,444, 462,462,462, 
463,463,463, 33232,464,464, 33233,465,465, 33234,466,466, 33235,467,467, 33212,444,444, 445,445,445, 
3, // chain 77
442,442,442, 441,441,441, 468,468,468, 
469,469,469, 470,470,470, 
5, // chain 78
471,471,471, 463,463,463, 464,464,464, 
472,472,472, 33241,473,473, 33242,474,474, 475,475,475, 
2, // chain 79
441,441,441, 463,463,463, 471,471,471, 
468,468,468, 
1, // chain 80
464,464,464, 465,465,465, 476,476,476, 
12, // chain 81
477,477,477, 478,478,478, 479,479,479, 
480,480,480, 33249,481,481, 482,482,482, 483,483,483, 477,477,477, 33252,484,484, 485,485,485, 33254,486,486, 33255,487,487, 488,488,488, 33257,489,489, 
6, // chain 82
478,478,478, 477,477,477, 485,485,485, 
490,490,490, 33254,486,486, 491,491,491, 33260,492,492, 33256,488,488, 
10, // chain 83
493,493,493, 494,494,494, 495,495,495, 
496,496,496, 33265,497,497, 498,498,498, 499,499,499, 500,500,500, 33269,501,501, 502,502,502, 493,493,493, 496,496,496, 
4, // chain 84
503,503,503, 504,504,504, 505,505,505, 
506,506,506, 507,507,507, 33276,508,508, 
2, // chain 85
504,504,504, 509,509,509, 510,510,510, 
505,505,505, 
13, // chain 86
510,510,510, 509,509,509, 511,511,511, 
512,512,512, 33281,513,513, 33282,514,514, 33283,515,515, 33277,509,509, 516,516,516, 33285,517,517, 33272,504,504, 518,518,518, 33271,503,503, 519,519,519, 33275,507,507, 
10, // chain 87
512,512,512, 513,513,513, 520,520,520, 
33289,521,521, 33290,522,522, 33282,514,514, 523,523,523, 524,524,524, 521,521,521, 33293,525,525, 33294,526,526, 527,527,527, 
4, // chain 88
528,528,528, 529,529,529, 530,530,530, 
531,531,531, 33300,532,532, 533,533,533, 
4, // chain 89
534,534,534, 535,535,535, 536,536,536, 
537,537,537, 33306,538,538, 539,539,539, 
18, // chain 90
540,540,540, 541,541,541, 542,542,542, 
543,543,543, 33312,544,544, 33313,545,545, 33314,546,546, 33309,541,541, 547,547,547, 33316,548,548, 33308,540,540, 549,549,549, 33318,550,550, 33311,543,543, 551,551,551, 33312,544,544, 552,552,552, 553,553,553, 554,554,554, 
33323,555,555, 
4, // chain 91
556,556,556, 546,546,546, 547,547,547, 
557,557,557, 33326,558,558, 33316,548,548, 
5, // chain 92
559,559,559, 556,556,556, 557,557,557, 
560,560,560, 33329,561,561, 33330,562,562, 33326,558,558, 
8, // chain 93
559,559,559, 560,560,560, 563,563,563, 
564,564,564, 565,565,565, 566,566,566, 556,556,556, 33335,567,567, 546,546,546, 33313,545,545, 
5, // chain 94
549,549,549, 550,550,550, 568,568,568, 
33337,569,569, 33338,570,570, 33319,551,551, 554,554,554, 
2, // chain 95
560,560,560, 561,561,561, 571,571,571, 
563,563,563, 
5, // chain 96
572,572,572, 573,573,573, 574,574,574, 
575,575,575, 33344,576,576, 33345,577,577, 33346,578,578, 
12, // chain 97
579,579,579, 580,580,580, 581,581,581, 
582,582,582, 574,574,574, 573,573,573, 583,583,583, 33352,584,584, 33340,572,572, 585,585,585, 33354,586,586, 33343,575,575, 587,587,587, 33344,576,576, 
11, // chain 98
579,579,579, 583,583,583, 588,588,588, 
580,580,580, 33357,589,589, 590,590,590, 591,591,591, 33360,592,592, 593,593,593, 594,594,594, 595,595,595, 580,580,580, 33349,581,581, 
4, // chain 99
584,584,584, 585,585,585, 596,596,596, 
33365,597,597, 33354,586,586, 598,598,598, 
1, // chain 100
596,596,596, 597,597,597, 599,599,599, 
2, // chain 101
600,600,600, 587,587,587, 601,601,601, 
602,602,602, 
6, // chain 102
603,603,603, 604,604,604, 605,605,605, 
606,606,606, 33375,607,607, 608,608,608, 609,609,609, 33378,610,610, 
9, // chain 103
611,611,611, 612,612,612, 613,613,613, 
614,614,614, 33383,615,615, 33384,616,616, 604,604,604, 603,603,603, 617,617,617, 33374,606,606, 609,609,609, 
5, // chain 104
618,618,618, 611,611,611, 614,614,614, 
619,619,619, 33388,620,620, 33383,615,615, 617,617,617, 
3, // chain 105
611,611,611, 618,618,618, 621,621,621, 
622,622,622, 612,612,612, 
25, // chain 106
623,623,623, 624,624,624, 625,625,625, 
626,626,626, 33395,627,627, 628,628,628, 629,629,629, 623,623,623, 33398,630,630, 33399,631,631, 632,632,632, 633,633,633, 33402,634,634, 635,635,635, 33404,636,636, 637,637,637, 638,638,638, 639,639,639, 633,633,633, 
33408,640,640, 33409,641,641, 642,642,642, 643,643,643, 33412,644,644, 624,624,624, 33393,625,625, 33413,645,645, 
2, // chain 107
623,623,623, 630,630,630, 643,643,643, 
624,624,624, 
2, // chain 108
630,630,630, 633,633,633, 640,640,640, 
643,643,643, 
16, // chain 109
646,646,646, 647,647,647, 648,648,648, 
649,649,649, 650,650,650, 33419,651,651, 652,652,652, 653,653,653, 33422,654,654, 655,655,655, 33424,656,656, 657,657,657, 33426,658,658, 33427,659,659, 660,660,660, 33429,661,661, 662,662,662, 33431,663,663, 
7, // chain 110
650,650,650, 653,653,653, 664,664,664, 
665,665,665, 33434,666,666, 33435,667,667, 33436,668,668, 33423,655,655, 33421,653,653, 
12, // chain 111
669,669,669, 670,670,670, 671,671,671, 
672,672,672, 33441,673,673, 33442,674,674, 33443,675,675, 33433,665,665, 33438,670,670, 650,650,650, 33414,646,646, 33415,647,647, 33437,669,669, 648,648,648, 
11, // chain 112
665,665,665, 666,666,666, 675,675,675, 
33442,674,674, 33444,676,676, 33445,677,677, 33435,667,667, 678,678,678, 33447,679,679, 33448,680,680, 33436,668,668, 657,657,657, 33423,655,655, 
8, // chain 113
681,681,681, 679,679,679, 680,680,680, 
682,682,682, 33425,657,657, 658,658,658, 683,683,683, 33428,660,660, 684,684,684, 33430,662,662, 
4, // chain 114
681,681,681, 682,682,682, 683,683,683, 
685,685,685, 33454,686,686, 33452,684,684, 
7, // chain 115
685,685,685, 686,686,686, 687,687,687, 
688,688,688, 689,689,689, 681,681,681, 33458,690,690, 679,679,679, 33446,678,678, 
8, // chain 116
691,691,691, 692,692,692, 693,693,693, 
694,694,694, 695,695,695, 33464,696,696, 697,697,697, 698,698,698, 699,699,699, 33468,700,700, 
7, // chain 117
701,701,701, 702,702,702, 703,703,703, 
704,704,704, 33473,705,705, 33474,706,706, 33460,692,692, 33470,702,702, 693,693,693, 
8, // chain 118
701,701,701, 704,704,704, 707,707,707, 
708,708,708, 33477,709,709, 33478,710,710, 33479,711,711, 33472,704,704, 712,712,712, 33473,705,705, 
8, // chain 119
713,713,713, 714,714,714, 715,715,715, 
716,716,716, 717,717,717, 33486,718,718, 719,719,719, 33488,720,720, 710,710,710, 33477,709,709, 
2, // chain 120
721,721,721, 691,691,691, 695,695,695, 
699,699,699, 
2, // chain 121
721,721,721, 706,706,706, 692,692,692, 
691,691,691, 
9, // chain 122
710,710,710, 711,711,711, 722,722,722, 
719,719,719, 33491,723,723, 717,717,717, 33492,724,724, 725,725,725, 713,713,713, 33494,726,726, 714,714,714, 
7, // chain 123
727,727,727, 728,728,728, 729,729,729, 
730,730,730, 33499,731,731, 33500,732,732, 33501,733,733, 33496,728,728, 734,734,734, 
11, // chain 124
730,730,730, 731,731,731, 735,735,735, 
33504,736,736, 33505,737,737, 33500,732,732, 738,738,738, 739,739,739, 740,740,740, 33509,741,741, 742,742,742, 736,736,736, 737,737,737, 
2, // chain 125
743,743,743, 431,431,431, 430,430,430, 
438,438,438, 
1, // chain 126
600,600,600, 586,586,586, 587,587,587, 
9, // chain 127
744,744,744, 745,745,745, 746,746,746, 
747,747,747, 33516,748,748, 33517,749,749, 33518,750,750, 33519,751,751, 33520,752,752, 33513,745,745, 753,753,753, 
7, // chain 128
747,747,747, 748,748,748, 754,754,754, 
755,755,755, 756,756,756, 744,744,744, 33525,757,757, 758,758,758, 759,759,759, 
1, // chain 129
744,744,744, 760,760,760, 745,745,745, 
5, // chain 130
761,761,761, 762,762,762, 763,763,763, 
764,764,764, 765,765,765, 33534,766,766, 33535,767,767, 
3, // chain 131
768,768,768, 769,769,769, 763,763,763, 
762,762,762, 770,770,770, 
1, // chain 132
761,761,761, 771,771,771, 762,762,762, 
1, // chain 133
765,765,765, 772,772,772, 761,761,761, 
6, // chain 134
773,773,773, 774,774,774, 775,775,775, 
776,776,776, 33545,777,777, 33546,778,778, 33547,779,779, 33548,780,780, 
7, // chain 135
781,781,781, 782,782,782, 773,773,773, 
783,783,783, 33552,784,784, 33544,776,776, 785,785,785, 33554,786,786, 33545,777,777, 
3, // chain 136
773,773,773, 782,782,782, 787,787,787, 
774,774,774, 33556,788,788, 
1, // chain 137
774,774,774, 789,789,789, 775,775,775, 
4, // chain 138
790,790,790, 791,791,791, 792,792,792, 
793,793,793, 33562,794,794, 33563,795,795, 
3, // chain 139
790,790,790, 796,796,796, 797,797,797, 
791,791,791, 33566,798,798, 
1, // chain 140
791,791,791, 799,799,799, 792,792,792, 
2, // chain 141
800,800,800, 801,801,801, 793,793,793, 
794,794,794, 

 0};


// face array: 11kb.
const uint16_t elementalist_2_face[5828] PROGMEM = {
18, // chain 0
802,802,802, 803,803,803, 804,804,804, 
805,805,805, 33574,806,806, 33575,807,807, 33571,803,803, 808,808,808, 809,809,809, 33578,810,810, 811,811,811, 33580,812,812, 813,813,813, 33582,814,814, 815,815,815, 33584,816,816, 817,817,817, 33586,818,818, 805,805,805, 
33570,802,802, 
6, // chain 1
817,817,817, 805,805,805, 806,806,806, 
815,815,815, 33581,813,813, 33579,811,811, 33577,809,809, 33575,807,807, 
24, // chain 2
819,819,819, 820,820,820, 821,821,821, 
822,822,822, 823,823,823, 824,824,824, 825,825,825, 826,826,826, 33595,827,827, 33596,828,828, 829,829,829, 830,830,830, 33599,831,831, 33600,832,832, 833,833,833, 834,834,834, 835,835,835, 836,836,836, 830,830,830, 
33605,837,837, 838,838,838, 827,827,827, 33594,826,826, 33607,839,839, 820,820,820, 819,819,819, 
7, // chain 3
840,840,840, 841,841,841, 842,842,842, 
843,843,843, 33612,844,844, 33613,845,845, 33614,846,846, 33615,847,847, 33609,841,841, 
10, // chain 4
848,848,848, 849,849,849, 850,850,850, 
851,851,851, 33620,852,852, 33621,853,853, 33622,854,854, 33617,849,849, 855,855,855, 33624,856,856, 33625,857,857, 33616,848,848, 
5, // chain 5
858,858,858, 859,859,859, 852,852,852, 
853,853,853, 860,860,860, 33629,861,861, 33622,854,854, 
2, // chain 6
862,862,862, 846,846,846, 858,858,858, 
860,860,860, 
2, // chain 7
859,859,859, 858,858,858, 846,846,846, 
847,847,847, 
1, // chain 8
845,845,845, 846,846,846, 862,862,862, 
1, // chain 9
855,855,855, 856,856,856, 863,863,863, 
4, // chain 10
864,864,864, 865,865,865, 866,866,866, 
867,867,867, 868,868,868, 869,869,869, 
2, // chain 11
866,866,866, 865,865,865, 870,870,870, 
871,871,871, 
8, // chain 12
872,872,872, 873,873,873, 874,874,874, 
875,875,875, 33644,876,876, 33645,877,877, 33641,873,873, 878,878,878, 33647,879,879, 33640,872,872, 
2, // chain 13
880,880,880, 881,881,881, 878,878,878, 
879,879,879, 
2, // chain 14
882,882,882, 883,883,883, 881,881,881, 
880,880,880, 
2, // chain 15
884,884,884, 885,885,885, 883,883,883, 
882,882,882, 
2, // chain 16
886,886,886, 887,887,887, 885,885,885, 
884,884,884, 
2, // chain 17
888,888,888, 876,876,876, 887,887,887, 
886,886,886, 
1, // chain 18
875,875,875, 876,876,876, 888,888,888, 
5, // chain 19
877,877,877, 878,878,878, 881,881,881, 
883,883,883, 885,885,885, 887,887,887, 876,876,876, 
24, // chain 20
889,889,889, 890,890,890, 891,891,891, 
892,892,892, 893,893,893, 33662,894,894, 895,895,895, 896,896,896, 33665,897,897, 33666,898,898, 899,899,899, 900,900,900, 33669,901,901, 902,902,902, 903,903,903, 904,904,904, 905,905,905, 897,897,897, 33664,896,896, 
33674,906,906, 907,907,907, 893,893,893, 33657,889,889, 33676,908,908, 909,909,909, 890,890,890, 
7, // chain 21
910,910,910, 911,911,911, 912,912,912, 
913,913,913, 33682,914,914, 33683,915,915, 33684,916,916, 33685,917,917, 33679,911,911, 
6, // chain 22
918,918,918, 919,919,919, 920,920,920, 
921,921,921, 33690,922,922, 33691,923,923, 33692,924,924, 33687,919,919, 
4, // chain 23
925,925,925, 923,923,923, 924,924,924, 
926,926,926, 915,915,915, 33682,914,914, 
3, // chain 24
921,921,921, 922,922,922, 927,927,927, 
928,928,928, 33697,929,929, 
6, // chain 25
922,922,922, 923,923,923, 930,930,930, 
33699,931,931, 33693,925,925, 932,932,932, 33683,915,915, 916,916,916, 
2, // chain 26
933,933,933, 918,918,918, 921,921,921, 
928,928,928, 
4, // chain 27
934,934,934, 935,935,935, 936,936,936, 
937,937,937, 33706,938,938, 33707,939,939, 
2, // chain 28
940,940,940, 935,935,935, 934,934,934, 
941,941,941, 
10, // chain 29
942,942,942, 943,943,943, 944,944,944, 
945,945,945, 33714,946,946, 33715,947,947, 33716,948,948, 33717,949,949, 33718,950,950, 33719,951,951, 33720,952,952, 33711,943,943, 
1, // chain 30
953,953,953, 954,954,954, 955,955,955, 
1, // chain 31
956,956,956, 957,957,957, 958,958,958, 
21, // chain 32
959,959,959, 960,960,960, 961,961,961, 
962,962,962, 33731,963,963, 33732,964,964, 33728,960,960, 965,965,965, 33734,966,966, 33727,959,959, 967,967,967, 33736,968,968, 33737,969,969, 33738,970,970, 33730,962,962, 971,971,971, 33740,972,972, 33741,973,973, 33742,974,974, 
33731,963,963, 975,975,975, 33744,976,976, 33732,964,964, 
20, // chain 33
977,977,977, 978,978,978, 979,979,979, 
975,975,975, 33742,974,974, 33748,980,980, 33749,981,981, 33746,978,978, 982,982,982, 33751,983,983, 33752,984,984, 33745,977,977, 985,985,985, 986,986,986, 33755,987,987, 33756,988,988, 989,989,989, 990,990,990, 33759,991,991, 
33760,992,992, 993,993,993, 33762,994,994, 
1, // chain 34
995,995,995, 970,970,970, 971,971,971, 
1, // chain 35
974,974,974, 980,980,980, 973,973,973, 
1, // chain 36
965,965,965, 966,966,966, 996,996,996, 
1, // chain 37
997,997,997, 998,998,998, 999,999,999, 
1, // chain 38
1000,1000,1000, 1001,1001,1001, 1002,1002,1002, 
1, // chain 39
1003,1003,1003, 1004,1004,1004, 1005,1005,1005, 
1, // chain 40
1006,1006,1006, 1007,1007,1007, 1008,1008,1008, 
109, // chain 41
1009,1009,1009, 1010,1010,1010, 1011,1011,1011, 
1012,1012,1012, 33781,1013,1013, 33782,1014,1014, 33783,1015,1015, 33784,1016,1016, 33785,1017,1017, 33778,1010,1010, 1018,1018,1018, 33787,1019,1019, 33777,1009,1009, 1020,1020,1020, 33789,1021,1021, 33780,1012,1012, 1013,1013,1013, 1022,1022,1022, 33791,1023,1023, 
33792,1024,1024, 33793,1025,1025, 33782,1014,1014, 1015,1015,1015, 1026,1026,1026, 33795,1027,1027, 33796,1028,1028, 33784,1016,1016, 1029,1029,1029, 33785,1017,1017, 1030,1030,1030, 33799,1031,1031, 33786,1018,1018, 1032,1032,1032, 33787,1019,1019, 1033,1033,1033, 
33802,1034,1034, 33803,1035,1035, 33788,1020,1020, 1036,1036,1036, 33789,1021,1021, 1037,1037,1037, 33806,1038,1038, 33790,1022,1022, 1023,1023,1023, 1039,1039,1039, 33808,1040,1040, 33809,1041,1041, 33792,1024,1024, 1025,1025,1025, 1042,1042,1042, 33794,1026,1026, 
1043,1043,1043, 33812,1044,1044, 33795,1027,1027, 1045,1045,1045, 33814,1046,1046, 33815,1047,1047, 33796,1028,1028, 1048,1048,1048, 33817,1049,1049, 33797,1029,1029, 1030,1030,1030, 1050,1050,1050, 33819,1051,1051, 33799,1031,1031, 1052,1052,1052, 33800,1032,1032, 
1053,1053,1053, 33801,1033,1033, 1054,1054,1054, 33823,1055,1055, 33802,1034,1034, 1056,1056,1056, 33825,1057,1057, 33803,1035,1035, 1036,1036,1036, 1058,1058,1058, 33827,1059,1059, 33805,1037,1037, 1060,1060,1060, 33806,1038,1038, 1061,1061,1061, 33807,1039,1039, 
1062,1062,1062, 33831,1063,1063, 33808,1040,1040, 1064,1064,1064, 33833,1065,1065, 33834,1066,1066, 33809,1041,1041, 1042,1042,1042, 1067,1067,1067, 33836,1068,1068, 33811,1043,1043, 1069,1069,1069, 33812,1044,1044, 1070,1070,1070, 33813,1045,1045, 1071,1071,1071, 
33840,1072,1072, 33841,1073,1073, 33814,1046,1046, 1074,1074,1074, 33843,1075,1075, 33815,1047,1047, 1076,1076,1076, 33845,1077,1077, 33816,1048,1048, 1078,1078,1078, 33818,1050,1050, 33817,1049,1049, 
7, // chain 42
1079,1079,1079, 1080,1080,1080, 1081,1081,1081, 
1070,1070,1070, 33850,1082,1082, 33851,1083,1083, 1084,1084,1084, 33853,1085,1085, 33854,1086,1086, 
3, // chain 43
1068,1068,1068, 1069,1069,1069, 1087,1087,1087, 
33850,1082,1082, 33838,1070,1070, 
13, // chain 44
1080,1080,1080, 1088,1088,1088, 1089,1089,1089, 
1081,1081,1081, 33858,1090,1090, 33859,1091,1091, 33860,1092,1092, 33861,1093,1093, 33856,1088,1088, 1094,1094,1094, 33863,1095,1095, 33848,1080,1080, 1079,1079,1079, 1071,1071,1071, 33838,1070,1070, 
28, // chain 45
1096,1096,1096, 1097,1097,1097, 1098,1098,1098, 
1099,1099,1099, 33868,1100,1100, 33869,1101,1101, 33870,1102,1102, 33865,1097,1097, 1103,1103,1103, 33872,1104,1104, 33864,1096,1096, 1093,1093,1093, 33873,1105,1105, 33874,1106,1106, 33867,1099,1099, 1100,1100,1100, 1107,1107,1107, 33876,1108,1108, 33877,1109,1109, 
33869,1101,1101, 1110,1110,1110, 33870,1102,1102, 1111,1111,1111, 33871,1103,1103, 1112,1112,1112, 33881,1113,1113, 33872,1104,1104, 1114,1114,1114, 33862,1094,1094, 33861,1093,1093, 
42, // chain 46
1115,1115,1115, 1116,1116,1116, 1077,1077,1077, 
1078,1078,1078, 1117,1117,1117, 33886,1118,1118, 33818,1050,1050, 1119,1119,1119, 33819,1051,1051, 1052,1052,1052, 1120,1120,1120, 33821,1053,1053, 1121,1121,1121, 33890,1122,1122, 33891,1123,1123, 33822,1054,1054, 1055,1055,1055, 1124,1124,1124, 33893,1125,1125, 
33894,1126,1126, 33824,1056,1056, 1127,1127,1127, 33896,1128,1128, 33825,1057,1057, 1058,1058,1058, 1129,1129,1129, 33898,1130,1130, 33827,1059,1059, 1060,1060,1060, 1131,1131,1131, 33900,1132,1132, 33829,1061,1061, 1133,1133,1133, 33902,1134,1134, 33830,1062,1062, 
1135,1135,1135, 33904,1136,1136, 33831,1063,1063, 1064,1064,1064, 1137,1137,1137, 1138,1138,1138, 33907,1139,1139, 33908,1140,1140, 33909,1141,1141, 
52, // chain 47
1142,1142,1142, 1143,1143,1143, 1144,1144,1144, 
1145,1145,1145, 33914,1146,1146, 33915,1147,1147, 33916,1148,1148, 33911,1143,1143, 1149,1149,1149, 33918,1150,1150, 33919,1151,1151, 33910,1142,1142, 1152,1152,1152, 33921,1153,1153, 33913,1145,1145, 1154,1154,1154, 33923,1155,1155, 33914,1146,1146, 1156,1156,1156, 
33925,1157,1157, 33915,1147,1147, 1158,1158,1158, 33927,1159,1159, 33916,1148,1148, 1160,1160,1160, 33917,1149,1149, 1161,1161,1161, 33930,1162,1162, 33918,1150,1150, 1163,1163,1163, 33932,1164,1164, 33919,1151,1151, 1152,1152,1152, 1165,1165,1165, 33934,1166,1166, 
33935,1167,1167, 33921,1153,1153, 1168,1168,1168, 33937,1169,1169, 33938,1170,1170, 33922,1154,1154, 1171,1171,1171, 33940,1172,1172, 33923,1155,1155, 1173,1173,1173, 33924,1156,1156, 1174,1174,1174, 33943,1175,1175, 33925,1157,1157, 1176,1176,1176, 33926,1158,1158, 
1177,1177,1177, 33946,1178,1178, 33947,1179,1179, 
6, // chain 48
1116,1116,1116, 1115,1115,1115, 1180,1180,1180, 
1076,1076,1076, 33949,1181,1181, 33950,1182,1182, 33885,1117,1117, 33883,1115,1115, 
3, // chain 49
1183,1183,1183, 1184,1184,1184, 1185,1185,1185, 
33954,1186,1186, 1187,1187,1187, 
4, // chain 50
1067,1067,1067, 1188,1188,1188, 1189,1189,1189, 
33833,1065,1065, 1066,1066,1066, 1067,1067,1067, 
24, // chain 51
1190,1190,1190, 1191,1191,1191, 1192,1192,1192, 
1193,1193,1193, 33962,1194,1194, 33963,1195,1195, 33964,1196,1196, 33965,1197,1197, 33959,1191,1191, 1198,1198,1198, 33967,1199,1199, 33958,1190,1190, 1200,1200,1200, 33969,1201,1201, 33961,1193,1193, 1202,1202,1202, 33971,1203,1203, 33962,1194,1194, 1204,1204,1204, 
33929,1161,1161, 33963,1195,1195, 1160,1160,1160, 33973,1205,1205, 33964,1196,1196, 1206,1206,1206, 33975,1207,1207, 
1, // chain 52
1208,1208,1208, 1209,1209,1209, 1210,1210,1210, 
1, // chain 53
1211,1068,1211, 1212,1208,1212, 1213,1211,1213, 
13, // chain 54
1214,1212,1214, 1215,1213,1215, 1216,1214,1216, 
1091,1091,1091, 33985,1215,1217, 33986,1216,1218, 33987,1217,1219, 33983,1213,1215, 1220,1218,1220, 33989,1219,1221, 33990,1220,1222, 33982,1212,1214, 1105,1105,1105, 33860,1092,1092, 33859,1091,1091, 
2, // chain 55
1091,1091,1091, 1217,1215,1217, 1090,1090,1090, 
33849,1081,1081, 
11, // chain 56
1223,1221,1223, 1224,1222,1224, 1225,1223,1225, 
1220,1218,1220, 1226,1224,1226, 33989,1219,1221, 1227,1225,1227, 33996,1226,1228, 33990,1220,1222, 1229,1227,1229, 33875,1107,1107, 33874,1106,1106, 33873,1105,1105, 
2, // chain 57
1230,1086,1230, 1231,1228,1231, 1232,1229,1232, 
1233,1230,1233, 
2, // chain 58
1234,1231,1234, 1217,1215,1217, 1235,1083,1235, 
33986,1216,1218, 
28, // chain 59
1236,1232,1236, 1237,1233,1237, 1238,1234,1238, 
34007,1235,1239, 34008,1236,1240, 1241,1237,1241, 34010,1238,1242, 1243,1239,1243, 34012,1240,1244, 1245,1241,1245, 34014,1242,1246, 34015,1243,1247, 1248,1244,1248, 34017,1245,1249, 34018,1246,1250, 1251,1247,1251, 1252,1248,1252, 34021,1249,1253, 34022,1250,1254, 
1255,1251,1255, 34024,1252,1256, 34025,1253,1257, 1258,1254,1258, 34027,1255,1259, 1260,1256,1260, 34029,1257,1261, 1262,1258,1262, 34031,1259,1263, 1264,1260,1264, 34033,1261,1265, 
70, // chain 60
1266,1262,1266, 1267,1263,1267, 1268,1264,1268, 
1269,1265,1269, 34038,1266,1270, 34039,1267,1271, 34040,1268,1272, 34035,1263,1267, 1273,1269,1273, 34042,1270,1274, 34034,1262,1266, 1275,1271,1275, 34044,1272,1276, 34045,1273,1277, 34037,1265,1269, 1270,1266,1270, 1278,1274,1278, 34047,1275,1279, 34048,1276,1280, 
34049,1277,1281, 34039,1267,1271, 1282,1278,1282, 34051,1279,1283, 34040,1268,1272, 1284,1280,1284, 34053,1281,1285, 34054,1282,1286, 34041,1269,1273, 1287,1283,1287, 34056,1284,1288, 34042,1270,1274, 1289,1285,1289, 34043,1271,1275, 1171,1171,1171, 33938,1170,1170, 
34058,1286,1290, 34044,1272,1276, 1291,1287,1291, 33949,1181,1181, 33844,1076,1076, 34045,1273,1277, 1075,1075,1075, 34046,1274,1278, 1074,1074,1074, 34060,1288,1292, 34047,1275,1279, 1293,1289,1293, 34048,1276,1280, 1200,1200,1200, 33967,1199,1199, 33966,1198,1198, 
34049,1277,1281, 1294,1290,1294, 34050,1278,1282, 1295,1291,1295, 34051,1279,1283, 1284,1280,1284, 1296,1292,1296, 34065,1293,1297, 34053,1281,1285, 1298,1294,1298, 34054,1282,1286, 1299,1295,1299, 34068,1296,1300, 34055,1283,1287, 1301,1297,1301, 34056,1284,1288, 
1302,1298,1302, 34071,1299,1303, 34057,1285,1289, 1172,1172,1172, 33939,1171,1171, 
22, // chain 61
1304,1300,1304, 1305,1301,1305, 1306,1302,1306, 
1307,1303,1307, 34076,1304,1308, 34077,1305,1309, 34078,1306,1310, 34073,1301,1305, 1124,1124,1124, 33891,1123,1123, 33890,1122,1122, 34072,1300,1304, 1121,1121,1121, 34075,1303,1307, 1311,1307,1311, 34080,1308,1312, 34076,1304,1308, 1313,1309,1313, 34082,1310,1314, 
34077,1305,1309, 1315,1311,1315, 33893,1125,1125, 34078,1306,1310, 1124,1124,1124, 
19, // chain 62
1073,1073,1073, 1074,1074,1074, 1316,1312,1316, 
34060,1288,1292, 1317,1313,1317, 34086,1314,1318, 34061,1289,1293, 1319,1315,1319, 34088,1316,1320, 33968,1200,1200, 1321,1317,1321, 33969,1201,1201, 1202,1202,1202, 1322,1318,1322, 34091,1319,1323, 33971,1203,1203, 1324,1320,1324, 33972,1204,1204, 1163,1163,1163, 
33930,1162,1162, 33929,1161,1161, 
5, // chain 63
1182,1182,1182, 1117,1117,1117, 1311,1307,1311, 
33886,1118,1118, 1121,1121,1121, 33888,1120,1120, 33887,1119,1119, 
31, // chain 64
1166,1166,1166, 1167,1167,1167, 1325,1321,1325, 
33936,1168,1168, 1326,1322,1326, 34095,1323,1327, 34096,1324,1328, 33937,1169,1169, 1170,1170,1170, 1290,1286,1290, 1291,1287,1291, 1329,1325,1329, 33949,1181,1181, 1182,1182,1182, 1311,1307,1311, 1312,1308,1312, 1328,1324,1328, 34095,1323,1327, 34081,1309,1313, 
1326,1322,1326, 34098,1326,1330, 34082,1310,1314, 1331,1327,1331, 34100,1328,1332, 34083,1311,1315, 1333,1329,1333, 34102,1330,1334, 34103,1331,1335, 33893,1125,1125, 1126,1126,1126, 1127,1127,1127, 1129,1129,1129, 33896,1128,1128, 
4, // chain 65
1238,1234,1238, 1336,1332,1336, 1337,1333,1337, 
1338,1334,1338, 1236,1232,1236, 34107,1335,1339, 
1, // chain 66
1093,1093,1093, 1105,1105,1105, 1092,1092,1092, 
9, // chain 67
1112,1112,1112, 1113,1113,1113, 1340,1336,1340, 
33882,1114,1114, 1341,1337,1341, 34110,1338,1342, 34111,1339,1343, 33862,1094,1094, 1095,1095,1095, 1072,1072,1072, 33839,1071,1071, 
36, // chain 68
1344,1340,1344, 1345,1341,1345, 1322,1318,1322, 
1323,1319,1323, 1346,1342,1346, 34092,1320,1324, 1347,1343,1347, 34116,1344,1348, 33931,1163,1163, 1349,1345,1349, 33932,1164,1164, 1350,1346,1350, 34119,1347,1351, 33933,1165,1165, 1352,1348,1352, 34121,1349,1353, 33934,1166,1166, 1354,1350,1354, 34093,1321,1325, 
1355,1351,1355, 34094,1322,1326, 1330,1326,1330, 1331,1327,1331, 1356,1352,1356, 34125,1353,1357, 34126,1354,1358, 34127,1355,1359, 34100,1328,1332, 1360,1356,1360, 34101,1329,1333, 1361,1357,1361, 34102,1330,1334, 1362,1358,1362, 34131,1359,1363, 34103,1331,1335, 
1129,1129,1129, 1131,1131,1131, 33898,1130,1130, 
4, // chain 69
1342,1338,1342, 1343,1339,1343, 1072,1072,1072, 
1317,1313,1317, 34084,1312,1316, 33841,1073,1073, 
18, // chain 70
1364,1360,1364, 1112,1112,1112, 1340,1336,1340, 
1365,1361,1365, 34134,1362,1366, 34109,1337,1341, 1367,1363,1367, 34110,1338,1342, 1368,1364,1368, 34085,1313,1317, 1318,1314,1318, 1369,1365,1369, 34087,1315,1319, 1370,1366,1370, 34104,1332,1336, 34088,1316,1320, 1321,1317,1321, 1337,1333,1337, 34090,1318,1322, 
1345,1341,1345, 
28, // chain 71
1369,1365,1369, 1241,1237,1241, 1243,1239,1243, 
1368,1364,1368, 34013,1241,1245, 1367,1363,1367, 34134,1362,1366, 34014,1242,1246, 1365,1361,1365, 34016,1244,1248, 1364,1360,1364, 34139,1367,1371, 34017,1245,1249, 1252,1248,1252, 1372,1368,1372, 34141,1369,1373, 34021,1249,1253, 1374,1370,1374, 34023,1251,1255, 
1375,1371,1375, 34144,1372,1376, 34024,1252,1256, 1377,1373,1377, 34026,1254,1258, 1260,1256,1260, 1378,1374,1378, 34147,1375,1379, 34030,1258,1262, 1380,1376,1380, 34032,1260,1264, 
32, // chain 72
1364,1360,1364, 1371,1367,1371, 1381,1377,1381, 
34140,1368,1372, 1382,1378,1382, 34151,1379,1383, 34141,1369,1373, 1374,1370,1374, 1384,1380,1384, 34143,1371,1375, 1385,1381,1385, 34144,1372,1376, 1386,1382,1386, 34155,1383,1387, 34145,1373,1377, 1388,1384,1388, 34146,1374,1378, 1379,1375,1379, 1389,1385,1389, 
34158,1386,1390, 34148,1376,1380, 1391,1387,1391, 34160,1388,1392, 1393,1389,1393, 1394,1390,1394, 34163,1391,1395, 1396,1392,1396, 34165,1393,1397, 1398,1394,1398, 1399,1395,1399, 34168,1396,1400, 1352,1348,1352, 34118,1346,1350, 1351,1347,1351, 
3, // chain 73
1084,1084,1084, 1085,1085,1085, 1401,1397,1401, 
1087,1087,1087, 34170,1208,1402, 
1, // chain 74
1076,1076,1076, 1077,1077,1077, 1116,1116,1116, 
1, // chain 75
1223,1221,1223, 1226,1224,1226, 1403,1398,1403, 
3, // chain 76
1173,1173,1173, 1174,1174,1174, 1302,1298,1302, 
1303,1299,1303, 1172,1172,1172, 
3, // chain 77
1206,1206,1206, 1158,1158,1158, 1159,1159,1159, 
1205,1205,1205, 33928,1160,1160, 
6, // chain 78
1294,1290,1294, 1295,1291,1295, 1404,1399,1404, 
34064,1292,1296, 1405,1400,1405, 1406,1401,1406, 34175,1178,1407, 1408,1402,1408, 
3, // chain 79
1406,1401,1406, 1196,1196,1196, 1197,1197,1197, 
1294,1290,1294, 33966,1198,1198, 
1, // chain 80
1406,1401,1406, 1294,1290,1294, 1404,1399,1404, 
1, // chain 81
1087,1087,1087, 1082,1082,1082, 1084,1084,1084, 
67, // chain 82
1112,1112,1112, 1364,1360,1364, 1381,1377,1381, 
1111,1111,1111, 34150,1378,1382, 1110,1110,1110, 34177,1403,1409, 34151,1379,1383, 1410,1404,1410, 34152,1380,1384, 1385,1381,1385, 1411,1405,1411, 34180,1406,1412, 34154,1382,1386, 1413,1407,1413, 34182,1408,1414, 34155,1383,1387, 1415,1409,1415, 34156,1384,1388, 
1389,1385,1389, 1416,1410,1416, 34158,1386,1390, 1417,1411,1417, 34186,1412,1418, 34159,1387,1391, 1394,1390,1394, 1419,1413,1419, 34164,1392,1396, 1420,1414,1420, 34167,1395,1399, 1421,1415,1421, 34190,1416,1422, 34120,1348,1352, 1423,1417,1423, 34121,1349,1353, 
1424,1418,1424, 34193,1419,1425, 34122,1350,1354, 1355,1351,1355, 1356,1352,1356, 1357,1353,1357, 1426,1420,1426, 34195,1421,1427, 34196,1422,1428, 34126,1354,1358, 1429,1423,1429, 34127,1355,1359, 1360,1356,1360, 1430,1424,1430, 34129,1357,1361, 1431,1425,1431, 
34130,1358,1362, 1432,1426,1432, 34131,1359,1363, 1131,1131,1131, 1132,1132,1132, 1430,1424,1430, 34201,1427,1433, 33901,1133,1133, 1434,1428,1434, 34203,1429,1435, 33902,1134,1134, 1412,1406,1412, 34204,1430,1436, 33903,1135,1135, 1437,1431,1437, 34206,1432,1438, 
33906,1138,1138, 33904,1136,1136, 
2, // chain 83
1369,1365,1369, 1370,1366,1370, 1239,1235,1239, 
1241,1237,1241, 
2, // chain 84
1336,1332,1336, 1238,1234,1238, 1239,1235,1239, 
1370,1366,1370, 
1, // chain 85
1439,1433,1439, 1440,1434,1440, 1441,1435,1441, 
1, // chain 86
1442,1436,1442, 1443,1437,1443, 1444,1438,1444, 
1, // chain 87
1445,1439,1445, 1446,1440,1446, 1447,1441,1447, 
1, // chain 88
1448,1442,1448, 1449,1443,1449, 1450,1444,1450, 
1, // chain 89
1451,1445,1451, 1452,1446,1452, 1453,1447,1453, 
1, // chain 90
1454,1448,1454, 1455,1449,1455, 1456,1450,1456, 
1, // chain 91
1457,1451,1457, 1458,1452,1458, 1459,1453,1459, 
1, // chain 92
1460,1454,1460, 1461,1455,1461, 1462,1456,1462, 
1, // chain 93
1463,1457,1463, 1464,1458,1464, 1465,1459,1465, 
1, // chain 94
1466,1460,1466, 1467,1461,1467, 1468,1462,1468, 
1, // chain 95
1469,1463,1469, 1470,1464,1470, 1471,1465,1471, 
1, // chain 96
1472,1466,1472, 1473,1467,1473, 1474,1468,1474, 
1, // chain 97
1475,1469,1475, 1476,1470,1476, 1477,1471,1477, 
1, // chain 98
1478,1472,1478, 1479,1473,1479, 1480,1474,1480, 
1, // chain 99
1481,1475,1481, 1482,1476,1482, 1483,1477,1483, 
1, // chain 100
1484,1478,1484, 1485,1479,1485, 1486,1480,1486, 
1, // chain 101
1487,1481,1487, 1488,1482,1488, 1489,1483,1489, 
1, // chain 102
1490,1484,1490, 1491,1485,1491, 1492,1486,1492, 
1, // chain 103
1493,1487,1493, 1494,1488,1494, 1495,1489,1495, 
1, // chain 104
1496,1490,1496, 1497,1491,1497, 1498,1492,1498, 
1, // chain 105
1499,1493,1499, 1500,1494,1500, 1501,1495,1501, 
1, // chain 106
1502,1496,1502, 1503,1497,1503, 1504,1498,1504, 
1, // chain 107
1505,1499,1505, 1506,1500,1506, 1507,1501,1507, 
1, // chain 108
1508,1502,1508, 1509,1503,1509, 1510,1504,1510, 
1, // chain 109
1511,1505,1511, 1512,1506,1512, 1513,1507,1513, 
1, // chain 110
1514,1508,1514, 1515,1509,1515, 1516,1510,1516, 
1, // chain 111
1517,1511,1517, 1518,1512,1518, 1519,1513,1519, 
1, // chain 112
1520,1514,1520, 1521,1515,1521, 1522,1516,1522, 
1, // chain 113
1523,1517,1523, 1524,1518,1524, 1525,1519,1525, 
1, // chain 114
1526,1520,1526, 1527,1521,1527, 1528,1522,1528, 
1, // chain 115
1529,1523,1529, 1530,1524,1530, 1531,1525,1531, 
1, // chain 116
1532,1526,1532, 1533,1527,1533, 1534,1528,1534, 
1, // chain 117
1535,1529,1535, 1536,1530,1536, 1537,1531,1537, 
1, // chain 118
1538,1532,1538, 1539,1533,1539, 1540,1534,1540, 
1, // chain 119
1541,1535,1541, 1542,1536,1542, 1543,1537,1543, 
1, // chain 120
1544,1538,1544, 1545,1539,1545, 1546,1540,1546, 
1, // chain 121
1547,1541,1547, 1548,1542,1548, 1549,1543,1549, 
1, // chain 122
1550,1544,1550, 1551,1545,1551, 1552,1546,1552, 
1, // chain 123
1553,1547,1553, 1554,1548,1554, 1555,1549,1555, 
1, // chain 124
1556,1550,1556, 1557,1551,1557, 1558,1552,1558, 
1, // chain 125
1559,1553,1559, 1560,1554,1560, 1561,1555,1561, 
1, // chain 126
1562,1556,1562, 1563,1557,1563, 1564,1558,1564, 
1, // chain 127
1565,1559,1565, 1566,1560,1566, 1567,1561,1567, 
1, // chain 128
1568,1562,1568, 1569,1563,1569, 1570,1564,1570, 
1, // chain 129
1571,1565,1571, 1572,1566,1572, 1573,1567,1573, 
1, // chain 130
1574,1568,1574, 1575,1569,1575, 1576,1570,1576, 
1, // chain 131
1577,1571,1577, 1578,1572,1578, 1579,1573,1579, 
1, // chain 132
1580,1574,1580, 1581,1575,1581, 1582,1576,1582, 
1, // chain 133
1583,1577,1583, 1584,1578,1584, 1585,1579,1585, 
1, // chain 134
1586,1580,1586, 1587,1581,1587, 1588,1582,1588, 
1, // chain 135
1589,1583,1589, 1590,1584,1590, 1591,1585,1591, 
1, // chain 136
1592,1586,1592, 1593,1587,1593, 1594,1588,1594, 
1, // chain 137
1595,1589,1595, 1596,1590,1596, 1597,1591,1597, 
1, // chain 138
1598,1592,1598, 1599,1593,1599, 1600,1594,1600, 
10, // chain 139
1601,1595,1601, 1602,1596,1602, 1603,1597,1603, 
1604,1598,1604, 34373,1599,1605, 34374,1600,1606, 34375,1601,1607, 34376,1602,1608, 34377,1603,1609, 34378,1604,1610, 34379,1605,1611, 34370,1596,1602, 
1, // chain 140
1612,1606,1612, 1613,1607,1613, 1614,1608,1614, 
1, // chain 141
1615,1609,1615, 1616,1610,1616, 1617,1611,1617, 
4, // chain 142
1618,1612,1618, 1619,1613,1619, 990,990,990, 
991,991,991, 993,993,993, 1620,1614,1620, 
2, // chain 143
1619,1613,1619, 986,986,986, 987,987,987, 
990,990,990, 
1, // chain 144
1621,1615,1621, 1622,1616,1622, 1623,1617,1623, 
7, // chain 145
1619,1613,1619, 1624,1618,1624, 1625,1619,1625, 
1626,1620,1626, 1627,1621,1627, 986,986,986, 34396,1622,1628, 984,984,984, 33751,983,983, 
2, // chain 146
1624,1618,1624, 1619,1613,1619, 1618,1612,1618, 
1629,1623,1629, 
1, // chain 147
1630,1624,1630, 1631,1625,1631, 1632,1626,1632, 
1, // chain 148
1633,1627,1633, 1634,1628,1634, 1635,1629,1635, 
1, // chain 149
1636,1630,1636, 1637,1631,1637, 1638,1632,1638, 
1, // chain 150
1639,1633,1639, 1640,1634,1640, 1641,1635,1641, 
9, // chain 151
1642,1636,1642, 1437,1431,1437, 1438,1432,1438, 
1643,1637,1643, 34412,1638,1644, 34413,1639,1645, 1646,1640,1646, 34415,1641,1647, 34416,1642,1648, 34417,1643,1649, 34418,1644,1650, 
5, // chain 152
1642,1636,1642, 1643,1637,1643, 1651,1645,1651, 
33876,1108,1108, 34420,1646,1652, 34414,1640,1646, 34412,1638,1644, 
10, // chain 153
1424,1418,1424, 1653,1647,1653, 1654,1648,1654, 
1655,1649,1655, 34424,1650,1656, 34425,1651,1657, 34426,1652,1658, 34421,1647,1653, 1659,1653,1659, 34194,1420,1426, 34193,1419,1425, 34192,1418,1424, 
3, // chain 154
1660,1654,1660, 1661,1655,1661, 1662,1656,1662, 
1663,1657,1663, 34432,1658,1664, 
19, // chain 155
1665,1659,1665, 1666,1660,1666, 1667,1661,1667, 
1668,1662,1668, 34437,1663,1669, 34438,1664,1670, 34439,1665,1671, 34440,1666,1672, 34434,1660,1666, 1419,1413,1419, 34186,1412,1418, 34185,1411,1417, 34433,1659,1665, 1416,1410,1416, 34441,1667,1673, 34436,1662,1668, 1674,1668,1674, 34437,1663,1669, 1675,1669,1675, 
34444,1670,1676, 34438,1664,1670, 
2, // chain 156
1677,1064,1677, 1678,1671,1678, 1679,1141,1679, 
1680,1672,1680, 
4, // chain 157
1681,1643,1681, 1438,1432,1438, 1138,1138,1138, 
1139,1139,1139, 1682,1673,1682, 33908,1140,1140, 
4, // chain 158
1229,1227,1229, 1646,1640,1646, 1647,1641,1647, 
1228,1226,1228, 34451,1674,1683, 34416,1642,1648, 
1, // chain 159
1228,1226,1228, 1683,1674,1683, 1227,1225,1227, 
2, // chain 160
1684,1675,1684, 1685,1225,1685, 1686,1676,1686, 
1687,1677,1687, 
2, // chain 161
1688,1678,1688, 1689,1679,1689, 1690,1680,1690, 
1691,1681,1691, 
1, // chain 162
1692,1678,1692, 1681,1643,1681, 1682,1673,1682, 
29, // chain 163
1693,1682,1693, 1694,1683,1694, 1695,1684,1695, 
1696,1685,1696, 34465,1686,1697, 34466,1687,1698, 34467,1688,1699, 34462,1683,1694, 1700,1689,1700, 34461,1682,1693, 1429,1423,1429, 34196,1422,1428, 34469,1690,1701, 34464,1685,1696, 1702,1691,1702, 34465,1686,1697, 1703,1692,1703, 34472,1693,1704, 34473,1694,1705, 
34474,1695,1706, 34466,1687,1698, 1707,1696,1707, 34476,1697,1708, 34467,1688,1699, 1709,1698,1709, 34478,1699,1710, 34479,1700,1711, 34468,1689,1700, 1433,1427,1433, 34198,1424,1430, 34197,1423,1429, 
2, // chain 164
1434,1428,1434, 1435,1429,1435, 1413,1407,1413, 
34180,1406,1412, 
42, // chain 165
1655,1649,1655, 1656,1650,1656, 1712,1701,1712, 
34481,1702,1713, 34482,1703,1714, 34425,1651,1657, 1715,1704,1715, 34484,1705,1716, 34426,1652,1658, 1717,1706,1717, 34427,1653,1659, 1718,1707,1718, 34487,1708,1719, 34194,1420,1426, 1427,1421,1427, 1720,1709,1720, 34196,1422,1428, 1701,1690,1701, 1721,1710,1721, 
34470,1691,1702, 1722,1711,1722, 34471,1692,1703, 1723,1712,1723, 34492,1713,1724, 34493,1714,1725, 34472,1693,1704, 1726,1715,1726, 34473,1694,1705, 1727,1716,1727, 34496,1717,1728, 34474,1695,1706, 1707,1696,1707, 1675,1669,1675, 34476,1697,1708, 1674,1668,1674, 
34477,1698,1709, 1673,1667,1673, 34184,1410,1416, 34183,1409,1415, 34478,1699,1710, 1414,1408,1414, 34479,1700,1711, 1434,1428,1434, 34201,1427,1433, 
9, // chain 166
1422,1416,1422, 1655,1649,1655, 1712,1701,1712, 
1421,1415,1421, 34497,1718,1729, 34481,1702,1713, 1671,1665,1671, 34498,1719,1730, 34482,1703,1714, 1731,1720,1731, 34483,1704,1715, 
3, // chain 167
1421,1415,1421, 1729,1718,1729, 1420,1414,1420, 
34440,1666,1672, 34439,1665,1671, 
3, // chain 168
1107,1107,1107, 1108,1108,1108, 1652,1646,1652, 
1229,1227,1229, 34414,1640,1646, 
7, // chain 169
1437,1431,1437, 1642,1636,1642, 1732,1721,1732, 
1436,1430,1436, 34180,1406,1412, 34179,1405,1411, 34501,1722,1733, 34419,1645,1651, 34410,1636,1642, 
2, // chain 170
1108,1108,1108, 1109,1109,1109, 1733,1722,1733, 
1651,1645,1651, 
1, // chain 171
1414,1408,1414, 1434,1428,1434, 1413,1407,1413, 
1, // chain 172
1420,1414,1420, 1672,1666,1672, 1419,1413,1419, 
4, // chain 173
1411,1405,1411, 1733,1722,1733, 1410,1404,1410, 
33877,1109,1109, 1409,1403,1409, 33878,1110,1110, 
1, // chain 174
1432,1426,1432, 1430,1424,1430, 1431,1425,1431, 
1, // chain 175
1684,1675,1684, 1734,1723,1734, 1685,1225,1685, 
1, // chain 176
1735,1224,1735, 1736,1675,1736, 1737,1724,1737, 
6, // chain 177
1719,1708,1719, 1720,1709,1720, 1738,1725,1738, 
34489,1710,1721, 1739,1726,1739, 34508,1727,1740, 34490,1711,1722, 1723,1712,1723, 
6, // chain 178
1716,1705,1716, 1717,1706,1717, 1741,1728,1741, 
1742,1729,1742, 1715,1704,1715, 34511,1730,1743, 1744,1731,1744, 1745,1732,1745, 
2, // chain 179
1717,1706,1717, 1718,1707,1718, 1746,1733,1746, 
1741,1728,1741, 
2, // chain 180
1718,1707,1718, 1738,1725,1738, 1739,1726,1739, 
1746,1733,1746, 
1, // chain 181
1718,1707,1718, 1719,1708,1719, 1738,1725,1738, 
5, // chain 182
1728,1717,1728, 1675,1669,1675, 1747,1734,1747, 
34444,1670,1676, 1748,1735,1748, 34517,1731,1749, 34518,1736,1750, 
2, // chain 183
1730,1719,1730, 1731,1720,1731, 1670,1664,1670, 
34519,1737,1751, 
2, // chain 184
1727,1716,1727, 1728,1717,1728, 1747,1734,1747, 
1748,1735,1748, 
1, // chain 185
1670,1664,1670, 1671,1665,1671, 1730,1719,1730, 
2, // chain 186
1423,1417,1423, 1424,1418,1424, 1655,1649,1655, 
1422,1416,1422, 
1, // chain 187
1752,1738,1752, 1753,1739,1753, 1754,1740,1754, 
2, // chain 188
1755,1741,1755, 1756,1742,1756, 1757,1743,1757, 
1758,1744,1758, 
1, // chain 189
1759,1745,1759, 1760,1746,1760, 1761,1747,1761, 
1, // chain 190
1762,1748,1762, 1763,1749,1763, 1764,1750,1764, 
1, // chain 191
1765,1751,1765, 1766,1752,1766, 1767,1753,1767, 
1, // chain 192
1768,1754,1768, 1769,1755,1769, 1770,1756,1770, 
1, // chain 193
1771,1757,1771, 1772,1758,1772, 1773,1759,1773, 
1, // chain 194
1774,1760,1774, 1775,1761,1775, 1776,1762,1776, 
1, // chain 195
1777,1763,1777, 1778,1764,1778, 1779,1765,1779, 
1, // chain 196
1780,1766,1780, 1781,1767,1781, 1782,1768,1782, 
1, // chain 197
1783,1769,1783, 1784,1770,1784, 1785,1771,1785, 
1, // chain 198
1786,1772,1786, 1787,1773,1787, 1788,1774,1788, 
1, // chain 199
1789,1775,1789, 1790,1776,1790, 1791,1777,1791, 
1, // chain 200
1792,1778,1792, 1793,1779,1793, 1794,1780,1794, 
1, // chain 201
1795,1781,1795, 1796,1782,1796, 1797,1783,1797, 
1, // chain 202
1798,1784,1798, 1799,1785,1799, 1800,1786,1800, 
1, // chain 203
1801,1787,1801, 1802,1788,1802, 1803,1789,1803, 
1, // chain 204
1804,1790,1804, 1805,1791,1805, 1806,1792,1806, 
1, // chain 205
1807,1793,1807, 1808,1794,1808, 1809,1795,1809, 
1, // chain 206
1810,1796,1810, 1811,1797,1811, 1812,1798,1812, 
1, // chain 207
1813,1799,1813, 1814,1800,1814, 1815,1801,1815, 
1, // chain 208
1816,1802,1816, 1817,1803,1817, 1818,1804,1818, 
1, // chain 209
1819,1805,1819, 1820,1806,1820, 1821,1807,1821, 
1, // chain 210
1822,1808,1822, 1823,1809,1823, 1824,1810,1824, 
1, // chain 211
1825,1811,1825, 1826,1812,1826, 1827,1813,1827, 
1, // chain 212
1828,1814,1828, 1829,1815,1829, 1830,1816,1830, 
1, // chain 213
1831,1817,1831, 1832,1818,1832, 1833,1819,1833, 
1, // chain 214
1834,1820,1834, 1835,1821,1835, 1836,1822,1836, 
1, // chain 215
1837,1823,1837, 1838,1824,1838, 1839,1825,1839, 
1, // chain 216
1840,1826,1840, 1841,1827,1841, 1842,1828,1842, 
1, // chain 217
1843,1829,1843, 1844,1830,1844, 1845,1831,1845, 
1, // chain 218
1846,1832,1846, 1847,1833,1847, 1848,1834,1848, 
1, // chain 219
1849,1835,1849, 1850,1836,1850, 1851,1837,1851, 
1, // chain 220
1852,1838,1852, 1853,1839,1853, 1854,1840,1854, 
1, // chain 221
1855,1841,1855, 1856,1842,1856, 1857,1843,1857, 
1, // chain 222
1858,1844,1858, 1859,1845,1859, 1860,1846,1860, 
1, // chain 223
1861,1847,1861, 1862,1848,1862, 1863,1849,1863, 
1, // chain 224
1864,1850,1864, 1865,1851,1865, 1866,1852,1866, 
1, // chain 225
1867,1853,1867, 1868,1854,1868, 1869,1855,1869, 
1, // chain 226
1870,1856,1870, 1871,1857,1871, 1872,1858,1872, 
1, // chain 227
1873,1859,1873, 1874,1860,1874, 1875,1861,1875, 
1, // chain 228
1876,1862,1876, 1877,1863,1877, 1878,1864,1878, 
1, // chain 229
1879,1865,1879, 1880,1866,1880, 1881,1867,1881, 
1, // chain 230
1882,1868,1882, 1883,1869,1883, 1884,1870,1884, 
1, // chain 231
1885,1871,1885, 1886,1872,1886, 1887,1873,1887, 
1, // chain 232
1888,1874,1888, 1889,1875,1889, 1890,1876,1890, 
1, // chain 233
1891,1877,1891, 1892,1878,1892, 1893,1879,1893, 
1, // chain 234
1894,1880,1894, 1895,1881,1895, 1896,1882,1896, 
1, // chain 235
1897,1883,1897, 1898,1884,1898, 1899,1885,1899, 
1, // chain 236
1900,1886,1900, 1901,1887,1901, 1902,1888,1902, 
1, // chain 237
1903,1889,1903, 1904,1890,1904, 1905,1891,1905, 
1, // chain 238
1906,1892,1906, 1907,1893,1907, 1908,1894,1908, 
1, // chain 239
1909,1895,1909, 1910,1896,1910, 1911,1897,1911, 
1, // chain 240
1912,1898,1912, 1913,1899,1913, 1914,1900,1914, 
1, // chain 241
1915,1901,1915, 1916,1902,1916, 1917,1903,1917, 
8, // chain 242
1918,1904,1918, 1919,1905,1919, 1920,1906,1920, 
1921,1907,1921, 34690,1908,1922, 1923,1909,1923, 34692,1910,1924, 1925,1911,1925, 34694,1912,1926, 1927,1913,1927, 
8, // chain 243
1928,1914,1928, 1929,1915,1929, 1930,1916,1930, 
1931,1917,1931, 34700,1918,1932, 1933,1919,1933, 34702,1920,1934, 1935,1921,1935, 34704,1922,1936, 1937,1923,1937, 
15, // chain 244
1938,1924,1938, 1939,1925,1939, 1940,1926,1940, 
1941,1927,1941, 34710,1928,1942, 34711,1929,1943, 34712,1930,1944, 34707,1925,1939, 1945,1931,1945, 1946,1932,1946, 1947,1933,1947, 34716,1934,1948, 34717,1935,1949, 34718,1936,1950, 1951,1937,1951, 1952,1938,1952, 34721,1939,1953, 
1, // chain 245
1954,1940,1954, 1955,1941,1955, 1956,1942,1956, 
2, // chain 246
1957,1943,1957, 1958,1944,1958, 1959,1945,1959, 
1960,1946,1960, 
9, // chain 247
1958,1944,1958, 1961,1947,1961, 1962,1948,1962, 
1959,1945,1959, 34731,1949,1963, 34732,1950,1964, 34733,1951,1965, 1966,1952,1966, 34735,1953,1967, 34736,1954,1968, 34737,1947,1969, 
1, // chain 248
1970,1955,1970, 1971,1956,1971, 1972,1957,1972, 
3, // chain 249
1967,1953,1967, 1968,1954,1968, 1973,1958,1973, 
1974,1959,1974, 34743,1960,1975, 
5, // chain 250
1941,1927,1941, 1942,1928,1942, 1976,1961,1976, 
34745,1962,1977, 34711,1929,1943, 1947,1933,1947, 34712,1930,1944, 
13, // chain 251
1949,1935,1949, 1952,1938,1952, 1978,1963,1978, 
1948,1934,1948, 34745,1962,1977, 34747,1964,1979, 34720,1938,1952, 1959,1945,1959, 1963,1949,1963, 1977,1962,1977, 34732,1950,1964, 1966,1952,1966, 1976,1961,1976, 34735,1953,1967, 1941,1927,1941, 
1, // chain 252
1977,1962,1977, 1947,1933,1947, 1948,1934,1948, 

 0};


// face array: 4kb.
const uint16_t elementalist_3_face[2110] PROGMEM = {
16, // chain 0
1980,1965,1980, 1981,1966,1981, 1982,1967,1982, 
1983,1968,1983, 34752,1969,1984, 34753,1970,1985, 34749,1966,1981, 1986,1971,1986, 1987,1972,1987, 1988,1973,1988, 34757,1974,1989, 34758,1975,1990, 1991,1976,1991, 34760,1977,1992, 1993,1978,1993, 34762,1979,1994, 1995,1980,1995, 34764,1981,1996, 
2, // chain 1
1983,1968,1983, 1997,1982,1997, 1998,1983,1998, 
1980,1965,1980, 
15, // chain 2
1985,1970,1985, 1988,1973,1988, 1999,1984,1999, 
1984,1969,1984, 34768,1985,2000, 34769,1986,2001, 34770,1987,2002, 34771,1988,2003, 34756,1973,1988, 1989,1974,1989, 2004,1989,2004, 34773,1990,2005, 34759,1976,1991, 2006,1991,2006, 34761,1978,1993, 2007,1992,2007, 34763,1980,1995, 
12, // chain 3
1983,1968,1983, 1984,1969,1984, 2008,1993,2008, 
34777,1994,2009, 34768,1985,2000, 2010,1995,2010, 34779,1996,2011, 34780,1997,2012, 34769,1986,2001, 2013,1998,2013, 34782,1999,2014, 34770,1987,2002, 2004,1989,2004, 34771,1988,2003, 
30, // chain 4
2015,2000,2015, 1997,1982,1997, 1983,1968,1983, 
2008,1993,2008, 2016,2001,2016, 34777,1994,2009, 2017,2002,2017, 34778,1995,2010, 2018,2003,2018, 34787,2004,2019, 34779,1996,2011, 2020,2005,2020, 34789,2006,2021, 34780,1997,2012, 2022,2007,2022, 34781,1998,2013, 2023,2008,2023, 34782,1999,2014, 2024,2009,2024, 
34772,1989,2004, 2005,1990,2005, 2025,2010,2025, 34774,1991,2006, 2026,2011,2026, 34775,1992,2007, 2027,2012,2027, 2028,2013,2028, 34797,2014,2029, 2030,2015,2030, 2031,2016,2031, 34800,2017,2032, 34801,2018,2033, 
25, // chain 5
2034,2019,2034, 2025,2010,2025, 2026,2011,2026, 
2028,2013,2028, 2031,2016,2031, 2035,2020,2035, 34800,2017,2032, 2036,2021,2036, 2037,2022,2037, 34806,2023,2038, 2039,2024,2039, 2022,2007,2022, 34789,2006,2021, 34808,2025,2040, 34809,2026,2041, 2042,2027,2042, 34811,2028,2043, 2044,2029,2044, 34813,2030,2045, 
2046,2031,2046, 2047,2032,2047, 34816,2033,2048, 2049,2034,2049, 2020,2005,2020, 34787,2004,2019, 34786,2003,2018, 34818,2035,2050, 
4, // chain 6
2023,2008,2023, 2024,2009,2024, 2025,2010,2025, 
2034,2019,2034, 2037,2022,2037, 34803,2020,2035, 
2, // chain 7
2040,2025,2040, 2042,2027,2042, 2020,2005,2020, 
2021,2006,2021, 
2, // chain 8
2044,2029,2044, 2047,2032,2047, 2020,2005,2020, 
2042,2027,2042, 
1, // chain 9
2037,2022,2037, 2022,2007,2022, 2023,2008,2023, 
7, // chain 10
2051,2036,2051, 2052,2037,2052, 2053,2038,2053, 
2054,2039,2054, 34823,2040,2055, 34824,2041,2056, 34825,2042,2057, 34826,2043,2058, 34820,2037,2052, 
17, // chain 11
2059,2044,2059, 2060,2045,2060, 2061,2046,2061, 
2062,2047,2062, 34831,2048,2063, 34832,2049,2064, 34833,2050,2065, 34834,2051,2066, 34828,2045,2060, 2067,2052,2067, 34836,2053,2068, 34827,2044,2059, 2069,2054,2069, 34838,2055,2070, 34830,2047,2062, 2063,2048,2063, 2071,2056,2071, 2051,2036,2051, 34820,2037,2052, 
8, // chain 12
2072,2057,2072, 2073,2058,2073, 2074,2059,2074, 
2075,2060,2075, 34844,2061,2076, 34845,2062,2077, 34834,2051,2066, 34833,2050,2065, 34841,2058,2073, 2064,2049,2064, 
7, // chain 13
2072,2057,2072, 2075,2060,2075, 2078,2063,2078, 
2058,2043,2058, 34825,2042,2057, 34824,2041,2056, 34847,2064,2079, 34844,2061,2076, 34843,2060,2075, 
6, // chain 14
2080,2065,2080, 2081,2066,2081, 2082,2067,2082, 
2083,2068,2083, 34852,2069,2084, 34853,2070,2085, 34854,2071,2086, 34849,2066,2081, 
18, // chain 15
2087,2072,2087, 2088,2073,2088, 2077,2062,2077, 
34857,2074,2089, 34858,2075,2090, 2080,2065,2080, 2083,2068,2083, 2084,2069,2084, 2076,2061,2076, 34847,2064,2079, 34859,2076,2091, 34853,2070,2085, 2086,2071,2086, 2092,2077,2092, 2079,2064,2079, 34861,2078,2093, 2094,2079,2094, 2056,2041,2056, 34863,2080,2095, 
2096,2081,2096, 
5, // chain 16
2055,2040,2055, 2097,2080,2097, 2098,2082,2098, 
2054,2039,2054, 34837,2054,2069, 34867,2083,2099, 2068,2053,2068, 
7, // chain 17
2100,2084,2100, 2101,2085,2101, 2102,2086,2102, 
2103,2087,2103, 34872,2088,2104, 34873,2089,2105, 34874,2090,2106, 34869,2085,2101, 2107,2091,2107, 
5, // chain 18
2108,2092,2108, 2109,2093,2109, 2110,2094,2110, 
2111,2095,2111, 2112,2096,2112, 2113,2097,2113, 2114,2098,2114, 
8, // chain 19
2115,2099,2115, 2116,2100,2116, 2117,2101,2117, 
2118,2102,2118, 34887,2103,2119, 34873,2089,2105, 34872,2088,2104, 34884,2100,2116, 2120,2104,2120, 2103,2087,2103, 
2, // chain 20
2066,2051,2066, 2067,2052,2067, 2087,2072,2087, 
2077,2062,2077, 
2, // chain 21
2054,2039,2054, 2069,2054,2069, 2070,2055,2070, 
2051,2036,2051, 
7, // chain 22
2121,2105,2121, 2122,2106,2122, 2123,2107,2123, 
2124,2108,2124, 34893,2109,2125, 34894,2110,2126, 2127,2111,2127, 34896,2112,2128, 34897,2113,2129, 
2, // chain 23
2121,2105,2121, 2130,2114,2130, 2131,2115,2131, 
2122,2106,2122, 
1, // chain 24
2089,2074,2089, 2076,2061,2076, 2077,2062,2077, 
1, // chain 25
2109,2093,2109, 2132,2114,2132, 2110,2094,2110, 
1, // chain 26
2133,2116,2133, 2134,2093,2134, 2135,2117,2135, 
1, // chain 27
2118,2102,2118, 2119,2103,2119, 2136,2118,2136, 
14, // chain 28
2137,2119,2137, 2138,2120,2138, 2139,2121,2139, 
2140,2122,2140, 34909,2123,2141, 2142,2124,2142, 34911,2125,2143, 2144,2126,2144, 34913,2127,2145, 2146,2128,2146, 34915,2129,2147, 2148,2130,2148, 34917,2131,2149, 2150,2132,2150, 34919,2133,2151, 2152,2134,2152, 
2, // chain 29
2153,2135,2153, 2154,2136,2154, 2138,2120,2138, 
2137,2119,2137, 
12, // chain 30
2155,2137,2155, 2156,2138,2156, 2157,2139,2157, 
2158,2140,2158, 34927,2141,2159, 34928,2142,2160, 2161,2143,2161, 2162,2144,2162, 34931,2145,2163, 2164,2146,2164, 34933,2147,2165, 2166,2148,2166, 34935,2149,2167, 2168,2150,2168, 
2, // chain 31
2169,2151,2169, 2170,2152,2170, 2156,2138,2156, 
2155,2137,2155, 
2, // chain 32
2171,2153,2171, 2172,2154,2172, 2170,2152,2170, 
2169,2151,2169, 
10, // chain 33
2173,2155,2173, 2174,2156,2174, 2175,2157,2175, 
34944,2158,2176, 34945,2159,2177, 34946,2160,2178, 2179,2161,2179, 34948,2162,2180, 34949,2163,2181, 2182,2164,2182, 34951,2165,2183, 34952,2166,2184, 
8, // chain 34
2185,2167,2185, 2186,2168,2186, 2187,2169,2187, 
2188,2170,2188, 2189,2171,2189, 2190,2172,2190, 2191,2173,2191, 2192,2174,2192, 2193,2175,2193, 2186,2168,2186, 
10, // chain 35
2194,2176,2194, 2195,2177,2195, 2196,2178,2196, 
2197,2179,2197, 34966,2180,2198, 34967,2181,2199, 34963,2177,2195, 2200,2182,2200, 34969,2183,2201, 34970,2184,2202, 34971,2185,2203, 34962,2176,2194, 
9, // chain 36
2204,2186,2204, 2205,2187,2205, 2206,2188,2206, 
2207,2189,2207, 34976,2190,2208, 2209,2191,2209, 34978,2192,2210, 2211,2193,2211, 34966,2180,2198, 34980,2194,2212, 2197,2179,2197, 
18, // chain 37
2213,2195,2213, 2214,2196,2214, 2205,2187,2205, 
2204,2186,2204, 2215,2197,2215, 34984,2198,2216, 34975,2189,2207, 2217,2199,2217, 34977,2191,2209, 2218,2200,2218, 34987,2201,2219, 34979,2193,2211, 2220,2202,2220, 34966,2180,2198, 2199,2181,2199, 2221,2203,2221, 34990,2204,2222, 34968,2182,2200, 2223,2205,2223, 
34969,2183,2201, 
9, // chain 38
2224,2206,2224, 2219,2201,2219, 2220,2202,2220, 
2225,2207,2225, 34989,2203,2221, 2226,2208,2226, 34995,2209,2227, 34996,2210,2228, 34990,2204,2222, 2229,2211,2229, 34991,2205,2223, 
13, // chain 39
2219,2201,2219, 2224,2206,2224, 2218,2200,2218, 
34998,2212,2230, 34993,2207,2225, 2231,2213,2231, 34994,2208,2226, 2232,2214,2232, 35001,2215,2233, 34995,2209,2227, 2234,2216,2234, 35003,2217,2235, 34996,2210,2228, 2236,2218,2236, 34997,2211,2229, 
18, // chain 40
2237,2219,2237, 2238,2220,2238, 2217,2199,2217, 
2218,2200,2218, 2230,2212,2230, 2239,2221,2239, 34999,2213,2231, 2232,2214,2232, 2240,2222,2240, 35009,2223,2241, 35001,2215,2233, 2242,2224,2242, 35002,2216,2234, 2243,2225,2243, 35012,2226,2244, 35013,2227,2245, 35014,2228,2246, 35003,2217,2235, 2236,2218,2236, 
2247,2229,2247, 
2, // chain 41
2238,2220,2238, 2248,2230,2248, 2216,2198,2216, 
2217,2199,2217, 
2, // chain 42
2248,2230,2248, 2249,2231,2249, 2215,2197,2215, 
2216,2198,2216, 
9, // chain 43
2249,2231,2249, 2248,2230,2248, 2250,2232,2250, 
2251,2233,2251, 35020,2234,2252, 35021,2235,2253, 35022,2236,2254, 35016,2230,2248, 2238,2220,2238, 2239,2221,2239, 35005,2219,2237, 
3, // chain 44
2253,2235,2253, 2254,2236,2254, 2255,2237,2255, 
35008,2222,2240, 35007,2221,2239, 
6, // chain 45
2256,2238,2256, 2243,2225,2243, 2244,2226,2244, 
2257,2239,2257, 35026,2240,2258, 35013,2227,2245, 2259,2241,2259, 35014,2228,2246, 
2, // chain 46
2252,2234,2252, 2253,2235,2253, 2260,2242,2260, 
2261,2243,2261, 
5, // chain 47
2241,2223,2241, 2262,2244,2262, 2240,2222,2240, 
35031,2245,2263, 2255,2237,2255, 35028,2242,2260, 2253,2235,2253, 
3, // chain 48
2264,2246,2264, 2241,2223,2241, 2242,2224,2242, 
2243,2225,2243, 2256,2238,2256, 
10, // chain 49
2265,2247,2265, 2266,2248,2266, 2267,2249,2267, 
2268,2250,2268, 35037,2251,2269, 35038,2252,2270, 35039,2253,2271, 35040,2254,2272, 35034,2248,2266, 2273,2255,2273, 35042,2256,2274, 35033,2247,2265, 
20, // chain 50
2275,2257,2275, 2276,2258,2276, 2277,2259,2277, 
2278,2260,2278, 35047,2261,2279, 35048,2262,2280, 35049,2263,2281, 35050,2264,2282, 35044,2258,2276, 2273,2255,2273, 35043,2257,2275, 2283,2265,2283, 35052,2266,2284, 35046,2260,2278, 2285,2267,2285, 35047,2261,2279, 2286,2268,2286, 35055,2269,2287, 35056,2270,2288, 
35048,2262,2280, 2289,2271,2289, 35049,2263,2281, 
2, // chain 51
2290,2272,2290, 2291,2273,2291, 2288,2270,2288, 
2289,2271,2289, 
7, // chain 52
2290,2272,2290, 2268,2250,2268, 2292,2274,2292, 
2291,2273,2291, 35061,2275,2293, 35062,2276,2294, 35038,2252,2270, 35037,2251,2269, 35036,2250,2268, 
12, // chain 53
2295,2277,2295, 2296,2278,2296, 2297,2279,2297, 
2298,2280,2298, 35067,2281,2299, 35068,2282,2300, 35069,2283,2301, 35064,2278,2296, 2302,2284,2302, 35063,2277,2295, 2303,2285,2303, 2304,2286,2304, 2287,2269,2287, 35054,2268,2286, 
11, // chain 54
2294,2276,2294, 2305,2287,2305, 2306,2288,2306, 
2307,2289,2307, 35067,2281,2299, 2300,2282,2300, 2301,2283,2301, 2294,2276,2294, 35061,2275,2293, 35070,2284,2302, 2287,2269,2287, 2288,2270,2288, 2291,2273,2291, 
2, // chain 55
2271,2253,2271, 2272,2254,2272, 2308,2290,2308, 
2309,2291,2309, 
4, // chain 56
2270,2252,2270, 2310,2292,2310, 2311,2291,2311, 
2312,2293,2312, 2294,2276,2294, 35073,2287,2305, 
3, // chain 57
2283,2265,2283, 2313,2294,2313, 2308,2290,2308, 
2272,2254,2272, 2273,2255,2273, 
13, // chain 58
2314,2295,2314, 2315,2296,2315, 2316,2297,2316, 
2317,2298,2317, 35086,2299,2318, 35087,2300,2319, 35088,2301,2320, 35083,2296,2315, 2321,2302,2321, 2322,2303,2322, 2323,2304,2323, 35092,2305,2324, 2325,2306,2325, 2326,2307,2326, 35095,2308,2327, 
3, // chain 59
2328,2309,2328, 2329,2310,2329, 2330,2311,2330, 
2331,2312,2331, 35100,2313,2332, 
1, // chain 60
2283,2265,2283, 2284,2266,2284, 2313,2294,2313, 
4, // chain 61
2333,2314,2333, 2334,2315,2334, 2335,2316,2335, 
2336,2317,2336, 2337,2318,2337, 2338,2313,2338, 
3, // chain 62
2328,2309,2328, 2339,2319,2339, 2340,2320,2340, 
2341,2321,2341, 2329,2310,2329, 
3, // chain 63
2342,2322,2342, 2343,2323,2343, 2344,2324,2344, 
2335,2316,2335, 2334,2315,2334, 
2, // chain 64
2345,2325,2345, 2346,2326,2346, 2344,2324,2344, 
2343,2323,2343, 
1, // chain 65
2273,2255,2273, 2274,2256,2274, 2282,2264,2282, 
1, // chain 66
2317,2298,2317, 2318,2299,2318, 2347,2327,2347, 
1, // chain 67
2348,2312,2348, 2349,2328,2349, 2350,2329,2350, 
2, // chain 68
2323,2304,2323, 2326,2307,2326, 2319,2300,2319, 
2320,2301,2320, 
4, // chain 69
2351,2330,2351, 2352,2331,2352, 2353,2332,2353, 
2354,2333,2354, 2355,2334,2355, 35124,2335,2356, 
12, // chain 70
2357,2336,2357, 2358,2337,2358, 2359,2338,2359, 
2360,2339,2360, 2361,2340,2361, 35130,2341,2362, 2363,2342,2363, 35132,2343,2364, 2365,2344,2365, 35134,2345,2366, 2367,2346,2367, 35136,2347,2368, 2352,2331,2352, 35121,2332,2353, 
6, // chain 71
2369,2348,2369, 2370,2349,2370, 2371,2350,2371, 
2372,2351,2372, 2373,2352,2373, 35142,2353,2374, 2375,2354,2375, 35144,2355,2376, 
10, // chain 72
2377,2356,2377, 2378,2357,2378, 2379,2358,2379, 
2380,2359,2380, 2381,2360,2381, 35150,2361,2382, 2383,2362,2383, 35152,2363,2384, 2385,2364,2385, 35154,2365,2386, 2371,2350,2371, 2370,2349,2370, 
10, // chain 73
2387,2366,2387, 2388,2367,2388, 2389,2368,2389, 
35158,2369,2390, 2391,2370,2391, 2392,2371,2392, 35161,2372,2393, 2394,2373,2394, 2395,2374,2395, 35164,2375,2396, 2397,2376,2397, 2398,2377,2398, 
8, // chain 74
2399,2378,2399, 2400,2379,2400, 2401,2380,2401, 
35170,2381,2402, 2403,2382,2403, 2404,2383,2404, 2405,2384,2405, 2406,2385,2406, 2407,2386,2407, 2399,2378,2399, 

 0};


// face array: 6kb.
const uint16_t elementalist_4_face[3490] PROGMEM = {
14, // chain 0
2408,2387,2408, 2409,2388,2409, 2410,2389,2410, 
2411,2390,2411, 2412,2391,2412, 35181,2392,2413, 2414,2393,2414, 35183,2394,2415, 2416,2395,2416, 35185,2396,2417, 35186,2397,2418, 35187,2398,2419, 2420,2399,2420, 35189,2400,2421, 2422,2401,2422, 35191,2402,2423, 
2, // chain 1
2424,2403,2424, 2425,2404,2425, 2426,2405,2426, 
2427,2389,2427, 
10, // chain 2
2428,2406,2428, 2429,2407,2429, 2430,2408,2430, 
2431,2409,2431, 35200,2410,2432, 35201,2411,2433, 35197,2407,2429, 2434,2412,2434, 35203,2413,2435, 35204,2414,2436, 35196,2406,2428, 2437,2415,2437, 
18, // chain 3
2438,2416,2438, 2439,2417,2439, 2440,2418,2440, 
2441,2419,2441, 35210,2420,2442, 35211,2421,2443, 35212,2422,2444, 35213,2423,2445, 35207,2417,2439, 2446,2424,2446, 35215,2425,2447, 35216,2426,2448, 35206,2416,2438, 2449,2427,2449, 35218,2428,2450, 35209,2419,2441, 2451,2429,2451, 35220,2430,2452, 35210,2420,2442, 
2453,2431,2453, 
11, // chain 4
2448,2426,2448, 2454,2432,2454, 2455,2433,2455, 
2447,2425,2447, 35224,2434,2456, 35225,2435,2457, 35203,2413,2435, 35202,2412,2434, 35222,2432,2454, 2458,2436,2458, 35227,2437,2459, 35217,2427,2449, 35216,2426,2448, 
12, // chain 5
2460,2438,2460, 2461,2439,2461, 2459,2437,2459, 
2462,2440,2462, 35217,2427,2449, 2450,2428,2450, 2463,2441,2463, 35232,2442,2464, 35233,2443,2465, 35219,2429,2451, 2466,2444,2466, 35235,2445,2467, 35236,2446,2468, 35220,2430,2452, 
2, // chain 6
2435,2413,2435, 2436,2414,2436, 2469,2447,2469, 
2457,2435,2457, 
1, // chain 7
2446,2424,2446, 2447,2425,2447, 2456,2434,2456, 
2, // chain 8
2458,2436,2458, 2470,2448,2470, 2433,2411,2433, 
2434,2412,2434, 
8, // chain 9
2459,2437,2459, 2461,2439,2461, 2458,2436,2458, 
35238,2448,2470, 35239,2449,2471, 35240,2450,2472, 35228,2438,2460, 2473,2451,2473, 35231,2441,2463, 35230,2440,2462, 
12, // chain 10
2474,2452,2474, 2475,2453,2475, 2476,2454,2476, 
2477,2455,2477, 35246,2456,2478, 35247,2457,2479, 35248,2458,2480, 35243,2453,2475, 2481,2459,2481, 35250,2460,2482, 35251,2461,2483, 35252,2462,2484, 35253,2463,2485, 35242,2452,2474, 
4, // chain 11
2472,2450,2472, 2473,2451,2473, 2486,2464,2486, 
35255,2465,2487, 35232,2442,2464, 35231,2441,2463, 
8, // chain 12
2488,2466,2488, 2487,2465,2487, 2489,2467,2489, 
2479,2457,2479, 35258,2468,2490, 35259,2469,2491, 35260,2470,2492, 35261,2471,2493, 35232,2442,2464, 35255,2465,2487, 
3, // chain 13
2486,2464,2486, 2487,2465,2487, 2488,2466,2488, 
2480,2458,2480, 35247,2457,2479, 
2, // chain 14
2481,2459,2481, 2472,2450,2472, 2486,2464,2486, 
2480,2458,2480, 
15, // chain 15
2477,2455,2477, 2478,2456,2478, 2494,2472,2494, 
35263,2473,2495, 35264,2474,2496, 35247,2457,2479, 2490,2468,2490, 2497,2475,2497, 35259,2469,2491, 2498,2476,2498, 35267,2477,2499, 35260,2470,2492, 2500,2478,2500, 35261,2471,2493, 2466,2444,2466, 35233,2443,2465, 35232,2442,2464, 
6, // chain 16
2501,2479,2501, 2500,2478,2500, 2466,2444,2466, 
2467,2445,2467, 2502,2480,2502, 35271,2481,2503, 35272,2482,2504, 35236,2446,2468, 
19, // chain 17
2505,2483,2505, 2506,2484,2506, 2507,2485,2507, 
2508,2486,2508, 35277,2487,2509, 35278,2488,2510, 35279,2489,2511, 35274,2484,2506, 2512,2490,2512, 35281,2491,2513, 35282,2492,2514, 35273,2483,2505, 2515,2493,2515, 35266,2476,2498, 35276,2486,2508, 2497,2475,2497, 35284,2494,2516, 35285,2495,2517, 35277,2487,2509, 
2518,2496,2518, 35278,2488,2510, 
9, // chain 18
2519,2497,2519, 2520,2498,2520, 2521,2499,2521, 
2522,2500,2522, 35291,2501,2523, 35292,2502,2524, 2525,2503,2525, 2526,2504,2526, 2527,2505,2527, 35281,2491,2513, 35280,2490,2512, 
7, // chain 19
2497,2475,2497, 2516,2494,2516, 2528,2506,2528, 
35297,2507,2529, 35298,2508,2530, 35299,2509,2531, 35285,2495,2517, 2518,2496,2518, 2532,2510,2532, 
5, // chain 20
2499,2477,2499, 2500,2478,2500, 2533,2511,2533, 
35287,2497,2519, 35269,2479,2501, 2520,2498,2520, 35270,2480,2502, 
9, // chain 21
2515,2493,2515, 2499,2477,2499, 2533,2511,2533, 
2534,2512,2534, 35287,2497,2519, 2522,2500,2522, 2535,2513,2535, 35291,2501,2523, 2527,2505,2527, 2514,2492,2514, 35281,2491,2513, 
2, // chain 22
2514,2492,2514, 2515,2493,2515, 2534,2512,2534, 
2535,2513,2535, 
3, // chain 23
2496,2474,2496, 2497,2475,2497, 2528,2506,2528, 
2529,2507,2529, 2495,2473,2495, 
1, // chain 24
2499,2477,2499, 2515,2493,2515, 2498,2476,2498, 
7, // chain 25
2432,2410,2432, 2433,2411,2433, 2536,2514,2536, 
35238,2448,2470, 2537,2515,2537, 35239,2449,2471, 2482,2460,2482, 35240,2450,2472, 2481,2459,2481, 
14, // chain 26
2538,2516,2538, 2432,2410,2432, 2536,2514,2536, 
2539,2517,2539, 35308,2518,2540, 35309,2519,2541, 35305,2515,2537, 2482,2460,2482, 2483,2461,2483, 2542,2520,2542, 35252,2462,2484, 2543,2521,2543, 35312,2522,2544, 35253,2463,2485, 2545,2523,2545, 35314,2524,2546, 
13, // chain 27
2547,2525,2547, 2548,2526,2548, 2549,2527,2549, 
2550,2528,2550, 35319,2529,2551, 2552,2530,2552, 35321,2531,2553, 2554,2532,2554, 35323,2533,2555, 2556,2534,2556, 2538,2516,2538, 35325,2535,2557, 2432,2410,2432, 35326,2536,2558, 2431,2409,2431, 
14, // chain 28
2559,2537,2559, 2560,2538,2560, 2561,2539,2561, 
2562,2540,2562, 35331,2541,2563, 35332,2542,2564, 35333,2543,2565, 35328,2538,2560, 2566,2544,2566, 35335,2545,2567, 35336,2546,2568, 35327,2537,2559, 2569,2547,2569, 2570,2548,2570, 35339,2549,2571, 35340,2550,2572, 
5, // chain 29
2550,2528,2550, 2552,2530,2552, 2539,2517,2539, 
2540,2518,2540, 2573,2551,2573, 35310,2520,2542, 35309,2519,2541, 
17, // chain 30
2570,2548,2570, 2571,2549,2571, 2548,2526,2548, 
2547,2525,2547, 2574,2552,2574, 35318,2528,2550, 2575,2553,2575, 35341,2551,2573, 2576,2554,2576, 35345,2555,2577, 35310,2520,2542, 2578,2556,2578, 35311,2521,2543, 2579,2557,2579, 35312,2522,2544, 2545,2523,2545, 2580,2558,2580, 2563,2541,2563, 35330,2540,2562, 
6, // chain 31
2568,2546,2568, 2570,2548,2570, 2581,2559,2581, 
2567,2545,2567, 35350,2560,2582, 35351,2561,2583, 35342,2552,2574, 35338,2548,2570, 
24, // chain 32
2576,2554,2576, 2577,2555,2577, 2584,2562,2584, 
35353,2563,2585, 35346,2556,2578, 2586,2564,2586, 35347,2557,2579, 2563,2541,2563, 2564,2542,2564, 2587,2565,2587, 35333,2543,2565, 2566,2544,2566, 2588,2566,2588, 35335,2545,2567, 2582,2560,2582, 2589,2567,2589, 35351,2561,2583, 2590,2568,2590, 35342,2552,2574, 
2575,2553,2575, 2576,2554,2576, 2589,2567,2589, 35352,2562,2584, 2585,2563,2585, 2587,2565,2587, 35354,2564,2586, 
2, // chain 33
2554,2532,2554, 2538,2516,2538, 2539,2517,2539, 
2552,2530,2552, 
1, // chain 34
2589,2567,2589, 2587,2565,2587, 2588,2566,2588, 
6, // chain 35
2591,2569,2591, 2592,2570,2592, 2593,2571,2593, 
2594,2572,2594, 2595,2573,2595, 35364,2574,2596, 2597,2575,2597, 35366,2576,2598, 
10, // chain 36
2599,2577,2599, 2600,2578,2600, 2601,2579,2601, 
2602,2580,2602, 2603,2581,2603, 2604,2582,2604, 35373,2583,2605, 35374,2584,2606, 2607,2585,2607, 35376,2586,2608, 2609,2587,2609, 2610,2588,2610, 
11, // chain 37
2611,2589,2611, 2612,2590,2612, 2601,2579,2601, 
2600,2578,2600, 2613,2591,2613, 35382,2592,2614, 35383,2593,2615, 35367,2577,2599, 2604,2582,2604, 2616,2594,2616, 35385,2595,2617, 35373,2583,2605, 2607,2585,2607, 
2, // chain 38
2612,2590,2612, 2611,2589,2611, 2618,2596,2618, 
35381,2591,2613, 
2, // chain 39
2619,2597,2619, 2620,2598,2620, 2612,2590,2612, 
2618,2596,2618, 
12, // chain 40
2621,2599,2621, 2622,2600,2622, 2623,2601,2623, 
35392,2602,2624, 35393,2603,2625, 2626,2604,2626, 2627,2605,2627, 35396,2606,2628, 2629,2607,2629, 2630,2608,2630, 35399,2609,2631, 2632,2610,2632, 2623,2601,2623, 35389,2599,2621, 
2, // chain 41
2624,2602,2624, 2627,2605,2627, 2630,2608,2630, 
2623,2601,2623, 
18, // chain 42
2633,2611,2633, 2634,2612,2634, 2635,2613,2635, 
2636,2614,2636, 35405,2615,2637, 35406,2616,2638, 35407,2617,2639, 35408,2618,2640, 35409,2619,2641, 35402,2612,2634, 2642,2620,2642, 35411,2621,2643, 35412,2622,2644, 35401,2611,2633, 2645,2623,2645, 35404,2614,2636, 2646,2624,2646, 35415,2625,2647, 35416,2626,2648, 
35405,2615,2637, 
3, // chain 43
2649,2627,2649, 2643,2621,2643, 2644,2622,2644, 
2650,2628,2650, 35413,2623,2645, 
1, // chain 44
2645,2623,2645, 2646,2624,2646, 2651,2629,2651, 
6, // chain 45
2652,2630,2652, 2649,2627,2649, 2653,2631,2653, 
2654,2632,2654, 2655,2633,2655, 2656,2634,2656, 35425,2635,2657, 35426,2636,2658, 
34, // chain 46
2652,2630,2652, 2656,2634,2656, 2659,2637,2659, 
2642,2620,2642, 35428,2638,2660, 35424,2634,2656, 2661,2639,2661, 35425,2635,2657, 2662,2640,2662, 35431,2641,2663, 2664,2642,2664, 35433,2643,2665, 2666,2644,2666, 35435,2645,2667, 2668,2646,2668, 35437,2647,2669, 2670,2648,2670, 35439,2649,2671, 2672,2650,2672, 
35441,2651,2673, 35442,2652,2674, 2675,2653,2675, 2676,2654,2676, 2672,2650,2672, 35445,2655,2677, 35446,2656,2678, 35447,2657,2679, 35448,2658,2680, 2681,2659,2681, 35450,2660,2682, 2683,2661,2683, 2684,2662,2684, 2679,2657,2679, 35453,2663,2685, 2686,2664,2686, 
35455,2665,2687, 
2, // chain 47
2640,2618,2640, 2641,2619,2641, 2660,2638,2660, 
35410,2620,2642, 
3, // chain 48
2688,2666,2688, 2639,2617,2639, 2640,2618,2640, 
2661,2639,2661, 35428,2638,2660, 
3, // chain 49
2689,2667,2689, 2690,2668,2690, 2691,2669,2691, 
2672,2650,2672, 35438,2648,2670, 
4, // chain 50
2672,2650,2672, 2677,2655,2677, 2689,2667,2689, 
35454,2664,2686, 35446,2656,2678, 2679,2657,2679, 
1, // chain 51
2661,2639,2661, 2662,2640,2662, 2688,2666,2688, 
2, // chain 52
2642,2620,2642, 2643,2621,2643, 2649,2627,2649, 
2652,2630,2652, 
1, // chain 53
2649,2627,2649, 2650,2628,2650, 2653,2631,2653, 
6, // chain 54
2692,2670,2692, 2693,2671,2693, 2694,2672,2694, 
2695,2673,2695, 35464,2674,2696, 2697,2675,2697, 35466,2676,2698, 35467,2677,2699, 
4, // chain 55
2700,2678,2700, 2701,2679,2701, 2702,2680,2702, 
2703,2681,2703, 2704,2682,2704, 35473,2683,2705, 
2, // chain 56
2706,2684,2706, 2707,2685,2707, 2700,2678,2700, 
2704,2682,2704, 
8, // chain 57
2708,2686,2708, 2701,2679,2701, 2700,2678,2700, 
2707,2685,2707, 2709,2687,2709, 35474,2684,2706, 2710,2688,2710, 2711,2689,2711, 2712,2690,2712, 2713,2691,2713, 
3, // chain 58
2714,2692,2714, 2715,2693,2715, 2716,2694,2716, 
35485,2695,2717, 35486,2696,2718, 
4, // chain 59
2714,2692,2714, 2716,2694,2716, 2719,2697,2719, 
35488,2698,2720, 35485,2695,2717, 2721,2699,2721, 
2, // chain 60
2722,2700,2722, 2723,2701,2723, 2724,2702,2724, 
2725,2703,2725, 
2, // chain 61
2726,2704,2726, 2727,2702,2727, 2728,2705,2728, 
2729,2706,2729, 
12, // chain 62
2723,2701,2723, 2722,2700,2722, 2730,2707,2730, 
2731,2708,2731, 35500,2709,2732, 2733,2710,2733, 35502,2711,2734, 2735,2712,2735, 2736,2713,2736, 2737,2714,2737, 35506,2715,2738, 2739,2716,2739, 35508,2717,2740, 2741,2718,2741, 
22, // chain 63
2742,2719,2742, 2743,2720,2743, 2744,2721,2744, 
2745,2722,2745, 35514,2723,2746, 35515,2724,2747, 35511,2720,2743, 2748,2725,2748, 2749,2726,2749, 2750,2727,2750, 35519,2728,2751, 2752,2729,2752, 35521,2730,2753, 2754,2731,2754, 2755,2732,2755, 35524,2733,2756, 2757,2734,2757, 35526,2735,2758, 2759,2736,2759, 
35528,2737,2760, 2761,2738,2761, 35530,2739,2762, 2763,2740,2763, 35532,2741,2764, 
17, // chain 64
2765,2742,2765, 2766,2743,2766, 2767,2744,2767, 
2768,2745,2768, 35537,2746,2769, 35538,2747,2770, 35539,2748,2771, 35540,2749,2772, 35534,2743,2766, 2773,2750,2773, 35542,2751,2774, 35543,2752,2775, 35533,2742,2765, 2776,2753,2776, 35545,2754,2777, 35536,2745,2768, 2778,2755,2778, 35547,2756,2779, 35537,2746,2769, 
1, // chain 65
2772,2749,2772, 2773,2750,2773, 2780,2757,2780, 
8, // chain 66
2777,2754,2777, 2778,2755,2778, 2781,2758,2781, 
2782,2759,2782, 35551,2760,2783, 35552,2761,2784, 35553,2762,2785, 35554,2763,2786, 35546,2755,2778, 2779,2756,2779, 
10, // chain 67
2782,2759,2782, 2787,2764,2787, 2788,2765,2788, 
2776,2753,2776, 35557,2766,2789, 35558,2767,2790, 35559,2768,2791, 35555,2764,2787, 2792,2769,2792, 35514,2723,2746, 35551,2760,2783, 35550,2759,2782, 
3, // chain 68
2793,2770,2793, 2745,2722,2745, 2784,2761,2784, 
2794,2771,2794, 35553,2762,2785, 
2, // chain 69
2742,2719,2742, 2745,2722,2745, 2793,2770,2793, 
2795,2772,2795, 
9, // chain 70
2773,2750,2773, 2774,2751,2774, 2796,2773,2796, 
35565,2774,2797, 35566,2775,2798, 35567,2776,2799, 35543,2752,2775, 2800,2777,2800, 35569,2778,2801, 35557,2766,2789, 35544,2753,2776, 
2, // chain 71
2745,2722,2745, 2746,2723,2746, 2783,2760,2783, 
2784,2761,2784, 
1, // chain 72
2782,2759,2782, 2776,2753,2776, 2777,2754,2777, 
17, // chain 73
2802,2779,2802, 2803,2780,2803, 2804,2781,2804, 
2805,2782,2805, 35574,2783,2806, 35575,2784,2807, 35576,2785,2808, 35571,2780,2803, 2809,2786,2809, 2810,2787,2810, 2811,2788,2811, 35580,2789,2812, 2813,2790,2813, 35582,2791,2814, 35583,2792,2815, 2816,2793,2816, 2817,2794,2817, 35586,2795,2818, 35587,2796,2819, 
14, // chain 74
2820,2797,2820, 2821,2798,2821, 2822,2799,2822, 
2790,2767,2790, 35569,2778,2801, 35568,2777,2800, 35591,2800,2823, 35589,2798,2821, 2824,2801,2824, 35574,2783,2806, 35593,2802,2825, 35588,2797,2820, 2826,2803,2826, 35595,2804,2827, 35559,2768,2791, 35558,2767,2790, 
1, // chain 75
2790,2767,2790, 2801,2778,2801, 2789,2766,2789, 
10, // chain 76
2824,2801,2824, 2807,2784,2807, 2828,2805,2828, 
2823,2800,2823, 35568,2777,2800, 35597,2806,2829, 35598,2807,2830, 35599,2808,2831, 35600,2809,2832, 35575,2784,2807, 2811,2788,2811, 35576,2785,2808, 
8, // chain 77
2805,2782,2805, 2806,2783,2806, 2825,2802,2825, 
2826,2803,2826, 2833,2810,2833, 35602,2811,2834, 35603,2812,2835, 35595,2804,2827, 2792,2769,2792, 35559,2768,2791, 
37, // chain 78
2799,2776,2799, 2800,2777,2800, 2829,2806,2829, 
2798,2775,2798, 35604,2813,2836, 35598,2807,2830, 2837,2814,2837, 35599,2808,2831, 2838,2815,2838, 35607,2816,2839, 35600,2809,2832, 2811,2788,2811, 2813,2790,2813, 2814,2791,2814, 2840,2817,2840, 35585,2794,2817, 2841,2818,2841, 35586,2795,2818, 2842,2819,2842, 
2843,2820,2843, 35612,2821,2844, 2845,2822,2845, 35614,2823,2846, 2847,2824,2847, 35616,2825,2848, 2849,2826,2849, 35618,2827,2850, 35619,2828,2851, 2852,2829,2852, 2853,2830,2853, 2854,2831,2854, 35623,2832,2855, 35624,2833,2856, 2857,2834,2857, 35626,2835,2858, 
2797,2774,2797, 35627,2836,2859, 2860,2837,2860, 2796,2773,2796, 
10, // chain 79
2857,2834,2857, 2797,2774,2797, 2798,2775,2798, 
2836,2813,2836, 2855,2832,2855, 35629,2838,2861, 35605,2814,2837, 2862,2839,2862, 35606,2815,2838, 2863,2840,2863, 35608,2817,2840, 35607,2816,2839, 
14, // chain 80
2863,2840,2863, 2840,2817,2840, 2843,2820,2843, 
2845,2822,2845, 2864,2841,2864, 35615,2824,2847, 2849,2826,2849, 2865,2842,2865, 35618,2827,2850, 2854,2831,2854, 2866,2843,2866, 35623,2832,2855, 2861,2838,2861, 2862,2839,2862, 2864,2841,2864, 35631,2840,2863, 
1, // chain 81
2866,2843,2866, 2864,2841,2864, 2865,2842,2865, 
1, // chain 82
2806,2783,2806, 2807,2784,2807, 2824,2801,2824, 
1, // chain 83
2843,2820,2843, 2840,2817,2840, 2841,2818,2841, 
26, // chain 84
2746,2723,2746, 2747,2724,2747, 2867,2844,2867, 
35518,2727,2750, 2868,2845,2868, 35520,2729,2752, 2755,2732,2755, 2757,2734,2757, 2869,2846,2869, 35638,2847,2870, 35639,2848,2871, 35640,2849,2872, 35527,2736,2759, 2761,2738,2761, 2873,2850,2873, 35642,2851,2874, 35531,2740,2763, 2875,2852,2875, 2876,2853,2876, 
35645,2854,2877, 35646,2855,2878, 2879,2856,2879, 35648,2857,2880, 2881,2858,2881, 35650,2859,2882, 2883,2860,2883, 35652,2861,2884, 35653,2862,2885, 
16, // chain 85
2873,2850,2873, 2874,2851,2874, 2886,2863,2886, 
35644,2853,2876, 2887,2864,2887, 35656,2865,2888, 35645,2854,2877, 2889,2866,2889, 35647,2856,2879, 2890,2867,2890, 35649,2858,2881, 2891,2868,2891, 35660,2869,2892, 35651,2860,2883, 2893,2870,2893, 35652,2861,2884, 2805,2782,2805, 35570,2779,2802, 
11, // chain 86
2894,2871,2894, 2895,2872,2895, 2896,2873,2896, 
2870,2847,2870, 35665,2874,2897, 35659,2868,2891, 35666,2875,2898, 35663,2872,2895, 2899,2876,2899, 35662,2871,2894, 2900,2877,2900, 35639,2848,2871, 35638,2847,2870, 
5, // chain 87
2834,2811,2834, 2869,2846,2869, 2897,2874,2897, 
2833,2810,2833, 35661,2870,2893, 35660,2869,2892, 35659,2868,2891, 
5, // chain 88
2867,2844,2867, 2868,2845,2868, 2869,2846,2869, 
2834,2811,2834, 2835,2812,2835, 2792,2769,2792, 2746,2723,2746, 
10, // chain 89
2886,2863,2886, 2887,2864,2887, 2901,2878,2901, 
2902,2879,2902, 35667,2876,2899, 35671,2880,2903, 35655,2864,2887, 2888,2865,2888, 2889,2866,2889, 2890,2867,2890, 2898,2875,2898, 35659,2868,2891, 
5, // chain 90
2873,2850,2873, 2902,2879,2902, 2904,2881,2904, 
2872,2849,2872, 35668,2877,2900, 35667,2876,2899, 35670,2879,2902, 
1, // chain 91
2872,2849,2872, 2900,2877,2900, 2871,2848,2871, 
1, // chain 92
2870,2847,2870, 2897,2874,2897, 2869,2846,2869, 
1, // chain 93
2886,2863,2886, 2902,2879,2902, 2873,2850,2873, 
1, // chain 94
2899,2876,2899, 2903,2880,2903, 2898,2875,2898, 
1, // chain 95
2805,2782,2805, 2833,2810,2833, 2893,2870,2893, 
6, // chain 96
2905,2882,2905, 2906,2883,2906, 2907,2884,2907, 
2908,2885,2908, 35677,2886,2909, 2910,2887,2910, 35679,2888,2911, 2912,2889,2912, 
7, // chain 97
2913,2890,2913, 2914,2891,2914, 2915,2892,2915, 
2916,2893,2916, 35685,2894,2917, 35686,2895,2918, 2919,2896,2919, 35688,2897,2920, 35689,2898,2921, 
8, // chain 98
2922,2899,2922, 2923,2900,2923, 2924,2901,2924, 
2925,2902,2925, 2926,2903,2926, 2927,2904,2927, 35696,2905,2928, 2929,2906,2929, 35681,2890,2913, 35682,2891,2914, 
5, // chain 99
2930,2907,2930, 2913,2890,2913, 2916,2893,2916, 
2931,2908,2931, 35700,2909,2932, 35685,2894,2917, 2919,2896,2919, 
4, // chain 100
2933,2910,2933, 2927,2904,2927, 2929,2906,2929, 
2934,2911,2934, 35698,2907,2930, 35681,2890,2913, 
1, // chain 101
2927,2904,2927, 2933,2910,2933, 2922,2899,2922, 
14, // chain 102
2935,2912,2935, 2936,2913,2936, 2937,2914,2937, 
2938,2915,2938, 2939,2916,2939, 35708,2917,2940, 2941,2918,2941, 2942,2919,2942, 35711,2920,2943, 2944,2921,2944, 2945,2922,2945, 35714,2923,2946, 2936,2913,2936, 2935,2912,2935, 2939,2916,2939, 2942,2919,2942, 
23, // chain 103
2947,2924,2947, 2948,2925,2948, 2949,2926,2949, 
2950,2927,2950, 35719,2928,2951, 35720,2929,2952, 35721,2930,2953, 35722,2931,2954, 35723,2932,2955, 35716,2925,2948, 2956,2933,2956, 35725,2934,2957, 35726,2935,2958, 35727,2936,2959, 35715,2924,2947, 2960,2937,2960, 35718,2927,2950, 2961,2938,2961, 35730,2939,2962, 
35719,2928,2951, 2963,2940,2963, 35720,2929,2952, 2964,2941,2964, 35733,2942,2965, 35721,2930,2953, 
11, // chain 104
2966,2943,2966, 2967,2944,2967, 2960,2937,2960, 
2961,2938,2961, 2962,2939,2962, 2968,2945,2968, 35737,2946,2969, 35731,2940,2963, 2970,2947,2970, 35732,2941,2964, 2971,2948,2971, 35740,2949,2972, 35733,2942,2965, 
1, // chain 105
2958,2935,2958, 2959,2936,2959, 2973,2950,2973, 
3, // chain 106
2968,2945,2968, 2974,2951,2974, 2975,2952,2975, 
2966,2943,2966, 35735,2944,2967, 
4, // chain 107
2969,2946,2969, 2970,2947,2970, 2968,2945,2968, 
35744,2953,2976, 35739,2948,2971, 2977,2954,2977, 
1, // chain 108
2959,2936,2959, 2960,2937,2960, 2967,2944,2967, 
13, // chain 109
2971,2948,2971, 2972,2949,2972, 2978,2955,2978, 
35747,2956,2979, 2980,2957,2980, 35749,2958,2981, 2982,2959,2982, 35751,2960,2983, 2984,2961,2984, 35753,2962,2985, 2986,2963,2986, 35755,2964,2987, 35756,2965,2988, 2989,2966,2989, 35758,2967,2990, 
2, // chain 110
2991,2968,2991, 2992,2969,2992, 2993,2970,2993, 
2994,2971,2994, 
13, // chain 111
2995,2972,2995, 2996,2973,2996, 2997,2974,2997, 
35766,2975,2998, 2999,2976,2999, 2992,2969,2992, 35768,2977,3000, 3001,2978,3001, 35770,2979,3002, 35755,2964,2987, 35771,2980,3003, 35772,2981,3004, 3005,2982,3005, 2986,2963,2986, 2987,2964,2987, 
4, // chain 112
2987,2964,2987, 2989,2966,2989, 3002,2979,3002, 
35761,2970,2993, 3001,2978,3001, 35760,2969,2992, 
2, // chain 113
2995,2972,2995, 2997,2974,2997, 2992,2969,2992, 
2991,2968,2991, 
1, // chain 114
2976,2953,2976, 2974,2951,2974, 2968,2945,2968, 
2, // chain 115
3006,2983,3006, 3007,2984,3007, 3008,2985,3008, 
3009,2986,3009, 
2, // chain 116
3010,2987,3010, 3011,2988,3011, 3012,2989,3012, 
3013,2990,3013, 
2, // chain 117
3010,2987,3010, 3008,2985,3008, 3007,2984,3007, 
3011,2988,3011, 
10, // chain 118
3014,2991,3014, 3015,2992,3015, 3016,2993,3016, 
3017,2994,3017, 3018,2995,3018, 3019,2996,3019, 35788,2997,3020, 3021,2998,3021, 35790,2999,3022, 35791,3000,3023, 35792,3001,3024, 35793,3002,3025, 
2, // chain 119
3021,2998,3021, 3026,3003,3026, 3014,2991,3014, 
3019,2996,3019, 
2, // chain 120
3015,2992,3015, 3014,2991,3014, 3026,3003,3026, 
3027,3004,3027, 
5, // chain 121
3028,3005,3028, 3029,3006,3029, 3030,3007,3030, 
3031,3008,3031, 3032,3009,3032, 3033,3010,3033, 35802,3011,3034, 
2, // chain 122
3033,3010,3033, 3035,3012,3035, 3029,3006,3029, 
3028,3005,3028, 

 0};


// face array: 4kb.
const uint16_t elementalist_5_face[2286] PROGMEM = {
22, // chain 0
3036,3013,3036, 3037,3014,3037, 3038,3015,3038, 
3039,3016,3039, 35808,3017,3040, 35809,3018,3041, 35810,3019,3042, 35811,3020,3043, 35805,3014,3037, 3044,3021,3044, 35813,3022,3045, 35804,3013,3036, 3046,3023,3046, 35815,3024,3047, 35816,3025,3048, 35807,3016,3039, 3049,3026,3049, 35808,3017,3040, 3050,3027,3050, 
35819,3028,3051, 35820,3029,3052, 35809,3018,3041, 3053,3030,3053, 35810,3019,3042, 
4, // chain 1
3054,3031,3054, 3045,3022,3045, 3046,3023,3046, 
3055,3032,3055, 35824,3033,3056, 35815,3024,3047, 
4, // chain 2
3052,3029,3052, 3057,3034,3057, 3058,3035,3058, 
3051,3028,3051, 35827,3036,3059, 3050,3027,3050, 
2, // chain 3
3060,3037,3060, 3061,3038,3061, 3052,3029,3052, 
3053,3030,3053, 
2, // chain 4
3062,3039,3062, 3063,3040,3063, 3045,3022,3045, 
3054,3031,3054, 
2, // chain 5
3061,3038,3061, 3064,3041,3064, 3057,3034,3057, 
3052,3029,3052, 
1, // chain 6
3044,3021,3044, 3045,3022,3045, 3063,3040,3063, 
1, // chain 7
3055,3032,3055, 3056,3033,3056, 3065,3042,3065, 
10, // chain 8
3066,3043,3066, 3067,3044,3067, 3068,3045,3068, 
3069,3046,3069, 35838,3047,3070, 3071,3048,3071, 35840,3049,3072, 35841,3050,3073, 3074,3051,3074, 35843,3052,3075, 3076,3053,3076, 35845,3054,3077, 
13, // chain 9
3078,3055,3078, 3079,3056,3079, 3080,3057,3080, 
3081,3058,3081, 35850,3059,3082, 35851,3060,3083, 35847,3056,3079, 3084,3061,3084, 3085,3062,3085, 35854,3063,3086, 3087,3064,3087, 3088,3065,3088, 3089,3066,3089, 3083,3060,3083, 35850,3059,3082, 
6, // chain 10
3074,3051,3074, 3076,3053,3076, 3090,3067,3090, 
3091,3068,3091, 35860,3069,3092, 35861,3070,3093, 35862,3071,3094, 35844,3053,3076, 
10, // chain 11
3095,3072,3095, 3096,3073,3096, 3097,3074,3097, 
3098,3075,3098, 35861,3070,3093, 35867,3076,3099, 35868,3077,3100, 3092,3069,3092, 35869,3078,3101, 3081,3058,3081, 35870,3079,3102, 3078,3055,3078, 
4, // chain 12
3103,3080,3103, 3104,3081,3104, 3105,3082,3105, 
3106,3083,3106, 3107,3084,3107, 35876,3085,3108, 
3, // chain 13
3093,3070,3093, 3094,3071,3094, 3109,3086,3109, 
3110,3087,3110, 3098,3075,3098, 
1, // chain 14
3092,3069,3092, 3093,3070,3093, 3099,3076,3099, 
10, // chain 15
3104,3081,3104, 3103,3080,3103, 3111,3088,3111, 
3112,3089,3112, 35881,3090,3113, 35882,3091,3114, 35883,3092,3115, 35871,3080,3103, 3107,3084,3107, 3116,3093,3116, 3114,3091,3114, 35885,3094,3117, 
9, // chain 16
3118,3095,3118, 3119,3096,3119, 3071,3048,3071, 
3072,3049,3072, 3120,3097,3120, 35842,3051,3074, 3091,3068,3091, 3121,3098,3121, 35890,3099,3122, 35849,3058,3081, 35860,3069,3092, 
9, // chain 17
3123,3100,3123, 3124,3101,3124, 3125,3102,3125, 
3126,3103,3126, 35895,3104,3127, 35896,3105,3128, 35897,3106,3129, 35892,3101,3124, 3130,3107,3130, 3104,3081,3104, 35873,3082,3105, 
5, // chain 18
3112,3089,3112, 3113,3090,3113, 3131,3108,3131, 
3132,3109,3132, 3066,3043,3066, 35835,3044,3067, 35901,3110,3133, 
22, // chain 19
3134,3111,3134, 3104,3081,3104, 3066,3043,3066, 
3069,3046,3069, 3135,3112,3135, 35839,3048,3071, 3119,3096,3119, 3136,3113,3136, 35905,3114,3137, 35906,3115,3138, 35886,3095,3118, 3139,3116,3139, 35888,3097,3120, 3140,3117,3140, 35889,3098,3121, 3141,3118,3141, 35910,3119,3142, 3143,3120,3143, 35912,3121,3144, 
3145,3122,3145, 35914,3123,3146, 3147,3124,3147, 3148,3125,3148, 3143,3120,3143, 
15, // chain 20
3135,3112,3135, 3136,3113,3136, 3149,3126,3149, 
35918,3127,3150, 35919,3128,3151, 3152,3129,3152, 35921,3130,3153, 3154,3131,3154, 35923,3132,3155, 3156,3133,3156, 3157,3134,3157, 35926,3135,3158, 3159,3136,3159, 3160,3137,3160, 3161,3138,3161, 35930,3139,3162, 35931,3140,3163, 
1, // chain 21
3081,3058,3081, 3082,3059,3082, 3122,3099,3122, 
14, // chain 22
3164,3141,3164, 3165,3142,3165, 3127,3104,3127, 
35934,3143,3166, 35935,3144,3167, 3168,3145,3168, 35937,3146,3169, 3170,3147,3170, 3171,3148,3171, 35940,3149,3172, 3173,3150,3173, 3174,3151,3174, 35891,3100,3123, 3126,3103,3126, 3166,3143,3166, 35895,3104,3127, 
1, // chain 23
3175,3142,3175, 3176,3152,3176, 3177,3153,3177, 
3, // chain 24
3128,3105,3128, 3129,3106,3129, 3178,3154,3178, 
35902,3111,3134, 35872,3081,3104, 
1, // chain 25
3066,3043,3066, 3104,3081,3104, 3112,3089,3112, 
7, // chain 26
3128,3105,3128, 3178,3154,3178, 3135,3112,3135, 
3149,3126,3149, 3179,3155,3179, 3180,3156,3180, 35949,3157,3181, 35950,3158,3182, 35951,3159,3183, 
1, // chain 27
3134,3111,3134, 3135,3112,3135, 3178,3154,3178, 
11, // chain 28
3184,3160,3184, 3185,3161,3185, 3186,3162,3186, 
3187,3163,3187, 35956,3164,3188, 3189,3165,3189, 35958,3166,3190, 3191,3167,3191, 35960,3168,3192, 3193,3169,3193, 35962,3170,3194, 3195,3171,3195, 35964,3172,3196, 
3, // chain 29
3197,3173,3197, 3198,3174,3198, 3185,3161,3185, 
3184,3160,3184, 3199,3175,3199, 
2, // chain 30
3200,3176,3200, 3201,3177,3201, 3198,3174,3198, 
3197,3173,3197, 
1, // chain 31
3195,3171,3195, 3202,3178,3202, 3193,3169,3193, 
1, // chain 32
3201,3177,3201, 3200,3176,3200, 3203,3179,3203, 
16, // chain 33
3204,3180,3204, 3205,3181,3205, 3206,3182,3206, 
3207,3183,3207, 35976,3184,3208, 35977,3185,3209, 35978,3186,3210, 35979,3187,3211, 35973,3181,3205, 3212,3188,3212, 35981,3189,3213, 35972,3180,3204, 3214,3190,3214, 35983,3191,3215, 35984,3192,3216, 35975,3183,3207, 3217,3193,3217, 35976,3184,3208, 
5, // chain 34
3218,3194,3218, 3219,3195,3219, 3215,3191,3215, 
3216,3192,3216, 3220,3196,3220, 35989,3197,3221, 35985,3193,3217, 
4, // chain 35
3222,3198,3222, 3223,3199,3223, 3224,3200,3224, 
3225,3201,3225, 3226,3202,3226, 35995,3203,3227, 
5, // chain 36
3211,3187,3211, 3223,3199,3223, 3222,3198,3222, 
3210,3186,3210, 35996,3204,3228, 35997,3205,3229, 35994,3202,3226, 
1, // chain 37
3209,3185,3209, 3210,3186,3210, 3228,3204,3228, 
2, // chain 38
3230,3206,3230, 3215,3191,3215, 3219,3195,3219, 
3231,3207,3231, 
4, // chain 39
3232,3208,3232, 3224,3200,3224, 3223,3199,3223, 
3233,3209,3233, 35979,3187,3211, 3212,3188,3212, 
1, // chain 40
3214,3190,3214, 3215,3191,3215, 3230,3206,3230, 
4, // chain 41
3234,3210,3234, 3235,3211,3235, 3236,3212,3236, 
3237,3213,3237, 3238,3214,3238, 36007,3215,3239, 
11, // chain 42
3240,3216,3240, 3241,3217,3241, 3242,3218,3242, 
3243,3219,3243, 36012,3220,3244, 36013,3221,3245, 36009,3217,3241, 3246,3222,3246, 36015,3223,3247, 36016,3224,3248, 36017,3225,3249, 36018,3226,3250, 36008,3216,3240, 
12, // chain 43
3251,3227,3251, 3252,3228,3252, 3253,3229,3253, 
3254,3230,3254, 36023,3231,3255, 36016,3224,3248, 36015,3223,3247, 36020,3228,3252, 3256,3232,3256, 36025,3233,3257, 36026,3234,3258, 36027,3235,3259, 36019,3227,3251, 3260,3236,3260, 
6, // chain 44
3261,3237,3261, 3262,3238,3262, 3263,3239,3263, 
3264,3240,3264, 3255,3231,3255, 36033,3241,3265, 3266,3242,3266, 3254,3230,3254, 
20, // chain 45
3267,3243,3267, 3268,3244,3268, 3269,3245,3269, 
3270,3246,3270, 36039,3247,3271, 3272,3248,3272, 36041,3249,3273, 3274,3250,3274, 36043,3251,3275, 3276,3252,3276, 36045,3253,3277, 36046,3254,3278, 3279,3255,3279, 36048,3256,3280, 3281,3257,3281, 3282,3258,3282, 36051,3259,3283, 3284,3260,3284, 3285,3261,3285, 
36054,3262,3286, 3287,3263,3287, 36056,3264,3288, 
4, // chain 46
3261,3237,3261, 3255,3231,3255, 3289,3265,3289, 
36016,3224,3248, 3290,3266,3290, 36017,3225,3249, 
21, // chain 47
3270,3246,3270, 3291,3267,3291, 3292,3268,3292, 
3267,3243,3267, 36061,3269,3293, 36062,3270,3294, 36063,3271,3295, 36059,3267,3291, 3296,3272,3296, 36006,3214,3238, 36002,3210,3234, 36038,3246,3270, 3297,3273,3297, 36040,3248,3272, 3298,3274,3298, 36067,3275,3299, 36042,3250,3274, 3287,3263,3287, 36044,3252,3276, 
3285,3261,3285, 36045,3253,3277, 3282,3258,3282, 36047,3255,3279, 
7, // chain 48
3300,3276,3300, 3244,3220,3244, 3301,3277,3301, 
3302,3278,3302, 36071,3279,3303, 36072,3280,3304, 36073,3281,3305, 36012,3220,3244, 3245,3221,3245, 
15, // chain 49
3306,3282,3306, 3307,3283,3307, 3308,3284,3308, 
3309,3285,3309, 36078,3286,3310, 36079,3287,3311, 36080,3288,3312, 36075,3283,3307, 3313,3289,3313, 36082,3290,3314, 36083,3291,3315, 36074,3282,3306, 3316,3292,3316, 36077,3285,3309, 3317,3293,3317, 36086,3294,3318, 36078,3286,3310, 
18, // chain 50
3319,3295,3319, 3320,3296,3320, 3321,3297,3321, 
36090,3298,3322, 3323,3299,3323, 3324,3300,3324, 36093,3301,3325, 3326,3302,3326, 36095,3303,3327, 3328,3304,3328, 36024,3232,3256, 36015,3223,3247, 36014,3222,3246, 36097,3305,3329, 3330,3306,3330, 36099,3307,3331, 3332,3308,3332, 36101,3309,3333, 36102,3310,3334, 
3335,3311,3335, 
3, // chain 51
3267,3243,3267, 3293,3269,3293, 3336,3312,3336, 
3268,3244,3268, 36105,3313,3337, 
2, // chain 52
3235,3211,3235, 3338,3314,3338, 3339,3315,3339, 
3236,3212,3236, 
6, // chain 53
3340,3316,3340, 3257,3233,3257, 3338,3314,3338, 
3341,3317,3341, 36110,3318,3342, 36003,3211,3235, 3297,3273,3297, 36002,3210,3234, 
3, // chain 54
3336,3312,3336, 3293,3269,3293, 3343,3319,3343, 
36062,3270,3294, 3344,3320,3344, 
1, // chain 55
3289,3265,3289, 3290,3266,3290, 3261,3237,3261, 
1, // chain 56
3243,3219,3243, 3244,3220,3244, 3300,3276,3300, 
9, // chain 57
3340,3316,3340, 3345,3321,3345, 3346,3322,3346, 
3256,3232,3256, 36096,3304,3328, 36115,3323,3347, 36113,3321,3345, 3348,3324,3348, 36117,3325,3349, 36109,3317,3341, 36108,3316,3340, 
4, // chain 58
3350,3326,3350, 3351,3327,3351, 3342,3318,3342, 
3299,3275,3299, 36066,3274,3298, 36065,3273,3297, 
1, // chain 59
3352,3328,3352, 3353,3262,3353, 3354,3329,3354, 
4, // chain 60
3355,3330,3355, 3316,3292,3316, 3350,3326,3350, 
36085,3293,3317, 3351,3327,3351, 36086,3294,3318, 
1, // chain 61
3316,3292,3316, 3356,3331,3356, 3315,3291,3315, 
1, // chain 62
3357,3332,3357, 3358,3294,3358, 3359,3333,3359, 
7, // chain 63
3360,3334,3360, 3361,3335,3361, 3362,3336,3362, 
3363,3337,3363, 36132,3338,3364, 36133,3339,3365, 36134,3340,3366, 36129,3335,3361, 3367,3341,3367, 
10, // chain 64
3368,3342,3368, 3369,3343,3369, 3370,3344,3370, 
3371,3345,3371, 36129,3335,3361, 3372,3346,3372, 36128,3334,3360, 3373,3347,3373, 36131,3337,3363, 3374,3348,3374, 36143,3349,3375, 36132,3338,3364, 
3, // chain 65
3376,3350,3376, 3373,3347,3373, 3299,3275,3299, 
36142,3348,3374, 3350,3326,3350, 
1, // chain 66
3373,3347,3373, 3377,3351,3377, 3372,3346,3372, 
1, // chain 67
3375,3349,3375, 3378,3352,3378, 3374,3348,3374, 
1, // chain 68
3379,3353,3379, 3380,3349,3380, 3381,3354,3381, 
5, // chain 69
3348,3324,3348, 3349,3325,3349, 3382,3355,3382, 
36151,3356,3383, 36119,3327,3351, 36109,3317,3341, 3342,3318,3342, 
12, // chain 70
3328,3304,3328, 3347,3323,3347, 3384,3357,3384, 
36153,3358,3385, 36154,3359,3386, 36116,3324,3348, 3387,3360,3387, 36156,3361,3388, 36150,3355,3382, 3383,3356,3383, 3389,3362,3389, 36158,3363,3390, 36159,3364,3391, 36160,3365,3392, 
6, // chain 71
3386,3359,3386, 3393,3366,3393, 3394,3367,3394, 
3385,3358,3385, 36163,3368,3395, 36164,3369,3396, 36165,3370,3397, 36161,3366,3393, 
1, // chain 72
3384,3357,3384, 3385,3358,3385, 3395,3368,3395, 
5, // chain 73
3386,3359,3386, 3387,3360,3387, 3393,3366,3393, 
36166,3371,3398, 36167,3372,3399, 36157,3362,3389, 36156,3361,3388, 
4, // chain 74
3399,3372,3399, 3389,3362,3389, 3390,3363,3390, 
3400,3373,3400, 3401,3374,3401, 3398,3371,3398, 
1, // chain 75
3256,3232,3256, 3257,3233,3257, 3340,3316,3340, 
1, // chain 76
3321,3297,3321, 3324,3300,3324, 3319,3295,3319, 
2, // chain 77
3257,3233,3257, 3258,3234,3258, 3339,3315,3339, 
3338,3314,3338, 
6, // chain 78
3402,3375,3402, 3403,3376,3403, 3404,3377,3404, 
36173,3378,3405, 36174,3379,3406, 3407,3380,3407, 36176,3381,3408, 3409,3382,3409, 
10, // chain 79
3410,3383,3410, 3411,3384,3411, 3412,3385,3412, 
36181,3386,3413, 36182,3387,3414, 3415,3388,3415, 36184,3389,3416, 3417,3390,3417, 36186,3391,3418, 3419,3392,3419, 36170,3375,3402, 3404,3377,3404, 
1, // chain 80
3404,3377,3404, 3405,3378,3405, 3420,3393,3420, 
1, // chain 81
3412,3385,3412, 3413,3386,3413, 3421,3394,3421, 
1, // chain 82
3180,3156,3180, 3422,3395,3422, 3128,3105,3128, 
4, // chain 83
3180,3156,3180, 3181,3157,3181, 3423,3396,3423, 
36192,3397,3424, 36193,3398,3425, 35950,3158,3182, 
7, // chain 84
3426,3399,3426, 3121,3098,3121, 3122,3099,3122, 
3427,3400,3427, 3428,3401,3428, 36197,3402,3429, 3430,3403,3430, 3431,3404,3431, 36200,3405,3432, 
7, // chain 85
3433,3406,3433, 3180,3156,3180, 3434,3407,3434, 
36191,3396,3423, 3435,3408,3435, 36192,3397,3424, 3436,3409,3436, 36205,3410,3437, 36193,3398,3425, 
1, // chain 86
3438,3158,3438, 3439,3411,3439, 3440,3412,3440, 
6, // chain 87
3162,3139,3162, 3441,3413,3441, 3149,3126,3149, 
3150,3127,3150, 3152,3129,3152, 3161,3138,3161, 35922,3131,3154, 3157,3134,3157, 
1, // chain 88
3442,3128,3442, 3443,3414,3443, 3444,3415,3444, 
7, // chain 89
3445,3416,3445, 3446,3417,3446, 3447,3418,3447, 
3448,3419,3448, 36217,3420,3449, 36218,3421,3450, 36219,3422,3451, 35905,3114,3137, 35904,3113,3136, 
26, // chain 90
3137,3114,3137, 3138,3115,3138, 3452,3423,3452, 
3451,3422,3451, 36218,3421,3450, 36221,3424,3453, 36222,3425,3454, 36223,3426,3455, 35906,3115,3138, 3139,3116,3139, 3140,3117,3140, 3456,3427,3456, 3457,3428,3457, 36226,3429,3458, 3459,3430,3459, 36228,3431,3460, 3461,3432,3461, 3462,3433,3462, 3454,3425,3454, 
36221,3424,3453, 36231,3434,3463, 3464,3435,3464, 36233,3436,3465, 3466,3437,3466, 3448,3419,3448, 3449,3420,3449, 3453,3424,3453, 36218,3421,3450, 
4, // chain 91
3467,3438,3467, 3468,3439,3468, 3469,3440,3469, 
3470,3441,3470, 3435,3408,3435, 36202,3407,3434, 
1, // chain 92
3435,3408,3435, 3436,3409,3436, 3471,3442,3471, 
2, // chain 93
3459,3430,3459, 3454,3425,3454, 3457,3428,3457, 
36223,3426,3455, 
2, // chain 94
3174,3151,3174, 3166,3143,3166, 3168,3145,3168, 
3171,3148,3171, 

 0};


// face array: 5kb.
const uint16_t elementalist_6_face[3029] PROGMEM = {
4, // chain 0
3472,3443,3472, 3473,3444,3473, 3474,3445,3474, 
3475,3446,3475, 3476,3447,3476, 36245,3448,3477, 
13, // chain 1
3478,3449,3478, 3479,3450,3479, 3480,3451,3480, 
3481,3452,3481, 36250,3453,3482, 36251,3454,3483, 36252,3455,3484, 36247,3450,3479, 3485,3456,3485, 3486,3457,3486, 36255,3458,3487, 3488,3459,3488, 3489,3460,3489, 36241,3444,3473, 36242,3445,3474, 
34, // chain 2
3490,3461,3490, 3478,3449,3478, 3481,3452,3481, 
3491,3462,3491, 36250,3453,3482, 3492,3463,3492, 36261,3464,3493, 36262,3465,3494, 36251,3454,3483, 3495,3466,3495, 36264,3467,3496, 36252,3455,3484, 3486,3457,3486, 3497,3468,3497, 36266,3469,3498, 36257,3460,3489, 3473,3444,3473, 3499,3470,3499, 36268,3471,3500, 
36240,3443,3472, 3476,3447,3476, 3501,3472,3501, 3502,3473,3502, 3503,3474,3503, 36272,3475,3504, 3505,3476,3505, 36274,3477,3506, 36275,3478,3507, 3508,3479,3508, 36277,3480,3509, 3510,3481,3510, 3511,3482,3511, 3512,3483,3512, 36281,3484,3513, 3514,3485,3514, 
36283,3486,3515, 
16, // chain 3
3499,3470,3499, 3503,3474,3503, 3516,3487,3516, 
3498,3469,3498, 36285,3488,3517, 36286,3489,3518, 36287,3490,3519, 36271,3474,3503, 3505,3476,3505, 3520,3491,3520, 36289,3492,3521, 36274,3477,3506, 3522,3493,3522, 36276,3479,3508, 3523,3494,3523, 36280,3483,3512, 3524,3495,3524, 36282,3485,3514, 
10, // chain 4
3497,3468,3497, 3525,3496,3525, 3526,3497,3526, 
3496,3467,3496, 36263,3466,3495, 36295,3498,3527, 36296,3499,3528, 36297,3500,3529, 36293,3496,3525, 3517,3488,3517, 36266,3469,3498, 36265,3468,3497, 
25, // chain 5
3530,3501,3530, 3493,3464,3493, 3494,3465,3494, 
3531,3502,3531, 36263,3466,3495, 3527,3498,3527, 3532,3503,3532, 36301,3504,3533, 36302,3505,3534, 36296,3499,3528, 3535,3506,3535, 36297,3500,3529, 3536,3507,3536, 36305,3508,3537, 36285,3488,3517, 3518,3489,3518, 3538,3509,3538, 36307,3510,3539, 36287,3490,3519, 
3540,3511,3540, 36288,3491,3520, 3521,3492,3521, 3541,3512,3541, 36310,3513,3542, 36290,3493,3522, 3524,3495,3524, 36291,3494,3523, 
3, // chain 6
3543,3514,3543, 3535,3506,3535, 3536,3507,3536, 
3538,3509,3538, 36305,3508,3537, 
20, // chain 7
3530,3501,3530, 3531,3502,3531, 3532,3503,3532, 
3544,3515,3544, 36313,3516,3545, 36314,3517,3546, 36315,3518,3547, 36301,3504,3533, 3548,3519,3548, 36317,3520,3549, 36302,3505,3534, 3535,3506,3535, 3550,3521,3550, 36311,3514,3543, 3551,3522,3551, 36320,3523,3552, 36321,3524,3553, 36306,3509,3538, 3554,3525,3554, 
36307,3510,3539, 3541,3512,3541, 36308,3511,3540, 
6, // chain 8
3555,3526,3555, 3553,3524,3553, 3554,3525,3554, 
3556,3527,3556, 36309,3512,3541, 3542,3513,3542, 3557,3528,3557, 36292,3495,3524, 
9, // chain 9
3558,3529,3558, 3548,3519,3548, 3549,3520,3549, 
3550,3521,3550, 3551,3522,3551, 3559,3530,3559, 36328,3531,3560, 36320,3523,3552, 3561,3532,3561, 36323,3526,3555, 36321,3524,3553, 
1, // chain 10
3500,3471,3500, 3503,3474,3503, 3499,3470,3499, 
25, // chain 11
3562,3533,3562, 3563,3534,3563, 3564,3535,3564, 
3565,3536,3565, 36334,3537,3566, 36335,3538,3567, 36331,3534,3563, 3568,3539,3568, 36337,3540,3569, 36338,3541,3570, 36330,3533,3562, 3571,3542,3571, 36340,3543,3572, 36341,3544,3573, 36333,3536,3565, 3574,3545,3574, 36343,3546,3575, 36334,3537,3566, 3576,3547,3576, 
36345,3548,3577, 36346,3549,3578, 36335,3538,3567, 3579,3550,3579, 36336,3539,3568, 3580,3551,3580, 36349,3552,3581, 3582,3553,3582, 
1, // chain 12
3568,3539,3568, 3569,3540,3569, 3583,3554,3583, 
38, // chain 13
3584,3555,3584, 3578,3549,3578, 3585,3556,3585, 
3586,3557,3586, 3587,3558,3587, 36356,3559,3588, 3589,3560,3589, 3590,3561,3590, 3591,3562,3591, 36360,3563,3592, 3593,3564,3593, 3594,3565,3594, 36363,3566,3595, 3596,3567,3596, 36365,3568,3597, 3598,3569,3598, 36367,3570,3599, 3600,3571,3600, 36369,3572,3601, 
3602,3573,3602, 36371,3574,3603, 3604,3575,3604, 36373,3576,3605, 3606,3577,3606, 36375,3578,3607, 3608,3579,3608, 3609,3580,3609, 3610,3581,3610, 36379,3582,3611, 3612,3583,3612, 36381,3584,3613, 3614,3585,3614, 36383,3586,3615, 3616,3587,3616, 3617,3588,3617, 
36386,3589,3618, 3572,3543,3572, 36387,3590,3619, 3620,3591,3620, 3571,3542,3571, 
1, // chain 14
3578,3549,3578, 3579,3550,3579, 3585,3556,3585, 
5, // chain 15
3577,3548,3577, 3578,3549,3578, 3584,3555,3584, 
3621,3592,3621, 36355,3558,3587, 3594,3565,3594, 36359,3562,3591, 
12, // chain 16
3594,3565,3594, 3596,3567,3596, 3621,3592,3621, 
36345,3548,3577, 36344,3547,3576, 36343,3546,3575, 36366,3569,3598, 3574,3545,3574, 36368,3571,3600, 3602,3573,3602, 3622,3593,3622, 36372,3575,3604, 3610,3581,3610, 36374,3577,3606, 
2, // chain 17
3617,3588,3617, 3623,3594,3623, 3612,3583,3612, 
3614,3585,3614, 
4, // chain 18
3574,3545,3574, 3622,3593,3622, 3623,3594,3623, 
3573,3544,3573, 36385,3588,3617, 3572,3543,3572, 
2, // chain 19
3610,3581,3610, 3612,3583,3612, 3623,3594,3623, 
3622,3593,3622, 
11, // chain 20
3624,3595,3624, 3625,3596,3625, 3545,3516,3545, 
3546,3517,3546, 3626,3597,3626, 36395,3598,3627, 36315,3518,3547, 3628,3599,3628, 36397,3600,3629, 36316,3519,3548, 3630,3601,3630, 36326,3529,3558, 3559,3530,3559, 
3, // chain 21
3561,3532,3561, 3555,3526,3555, 3631,3602,3631, 
36324,3527,3556, 3557,3528,3557, 
4, // chain 22
3632,3603,3632, 3633,3604,3633, 3634,3605,3634, 
3635,3606,3635, 36404,3607,3636, 3637,3608,3637, 
2, // chain 23
3638,3609,3638, 3639,3610,3639, 3633,3604,3633, 
3632,3603,3632, 
2, // chain 24
3640,3611,3640, 3641,3612,3641, 3639,3610,3639, 
3638,3609,3638, 
2, // chain 25
3642,3613,3642, 3643,3614,3643, 3641,3612,3641, 
3640,3611,3640, 
2, // chain 26
3644,3615,3644, 3645,3616,3645, 3643,3614,3643, 
3642,3613,3642, 
2, // chain 27
3644,3615,3644, 3646,3617,3646, 3647,3618,3647, 
3645,3616,3645, 
3, // chain 28
3648,3619,3648, 3649,3620,3649, 3650,3621,3650, 
3646,3617,3646, 36415,3618,3647, 
5, // chain 29
3651,3622,3651, 3652,3623,3652, 3653,3624,3653, 
3654,3625,3654, 3649,3620,3649, 36423,3626,3655, 3650,3621,3650, 
2, // chain 30
3651,3622,3651, 3656,3627,3656, 3657,3628,3657, 
3652,3623,3652, 
5, // chain 31
3658,3629,3658, 3659,3630,3659, 3660,3631,3660, 
36429,3632,3661, 3662,3633,3662, 36431,3634,3663, 36432,3635,3664, 
4, // chain 32
3660,3631,3660, 3662,3633,3662, 3665,3636,3665, 
3666,3637,3666, 3667,3638,3667, 3658,3629,3658, 
2, // chain 33
3665,3636,3665, 3662,3633,3662, 3668,3639,3668, 
36431,3634,3663, 
2, // chain 34
3669,3640,3669, 3670,3641,3670, 3671,3642,3671, 
3672,3643,3672, 
1, // chain 35
3673,3644,3673, 3674,3645,3674, 3675,3646,3675, 
1, // chain 36
3676,3647,3676, 3677,3648,3677, 3678,3649,3678, 
1, // chain 37
3679,3650,3679, 3680,3651,3680, 3681,3652,3681, 
1, // chain 38
3682,3653,3682, 3683,3654,3683, 3684,3655,3684, 
9, // chain 39
3685,3656,3685, 3686,3657,3686, 3687,3658,3687, 
3688,3659,3688, 36457,3660,3689, 36458,3661,3690, 36454,3657,3686, 3691,3662,3691, 36460,3663,3692, 36461,3664,3693, 36453,3656,3685, 
6, // chain 40
3694,3665,3694, 3695,3666,3695, 3696,3667,3696, 
3697,3668,3697, 3698,3669,3698, 36467,3670,3699, 3691,3662,3691, 36458,3661,3690, 
14, // chain 41
3700,3671,3700, 3701,3672,3701, 3702,3673,3702, 
3703,3674,3703, 36472,3675,3704, 3705,3676,3705, 3695,3666,3695, 3694,3665,3694, 3700,3671,3700, 36466,3669,3698, 3706,3677,3706, 36459,3662,3691, 3692,3663,3692, 3707,3678,3707, 36476,3679,3708, 36461,3664,3693, 
2, // chain 42
3706,3677,3706, 3709,3680,3709, 3701,3672,3701, 
3700,3671,3700, 
1, // chain 43
3706,3677,3706, 3707,3678,3707, 3709,3680,3709, 
4, // chain 44
3710,3681,3710, 3711,3682,3711, 3689,3660,3689, 
3712,3683,3712, 3713,3684,3713, 36482,3685,3714, 
1, // chain 45
3688,3659,3688, 3689,3660,3689, 3711,3682,3711, 
18, // chain 46
3715,3686,3715, 3716,3687,3716, 3717,3688,3717, 
3718,3689,3718, 3719,3690,3719, 36488,3691,3720, 3721,3692,3721, 36490,3693,3722, 3723,3694,3723, 36492,3695,3724, 3725,3696,3725, 36494,3697,3726, 3727,3698,3727, 36496,3699,3728, 3729,3700,3729, 36498,3701,3730, 3731,3702,3731, 36500,3703,3732, 3733,3704,3733, 
36502,3705,3734, 
3, // chain 47
3719,3690,3719, 3735,3706,3735, 3715,3686,3715, 
36504,3707,3736, 3716,3687,3716, 
8, // chain 48
3737,3708,3737, 3738,3709,3738, 3739,3710,3739, 
36508,3711,3740, 3741,3712,3741, 3742,3713,3742, 3743,3714,3743, 3744,3715,3744, 3745,3716,3745, 3737,3708,3737, 
10, // chain 49
3746,3717,3746, 3747,3718,3747, 3748,3719,3748, 
36517,3720,3749, 3750,3721,3750, 3751,3722,3751, 3752,3723,3752, 3753,3724,3753, 3754,3725,3754, 3755,3726,3755, 3756,3727,3756, 3746,3717,3746, 
5, // chain 50
3757,3728,3757, 3758,3729,3758, 3759,3730,3759, 
3760,3731,3760, 3761,3732,3761, 3762,3733,3762, 3763,3734,3763, 
4, // chain 51
3764,3735,3764, 3765,3736,3765, 3766,3737,3766, 
36535,3738,3767, 36536,3739,3768, 36537,3740,3769, 
4, // chain 52
3766,3737,3766, 3770,3741,3770, 3771,3742,3771, 
3772,3743,3772, 3773,3744,3773, 3764,3735,3764, 
2, // chain 53
3774,3745,3774, 3770,3741,3770, 3766,3737,3766, 
3767,3738,3767, 
26, // chain 54
3775,3746,3775, 3776,3747,3776, 3777,3748,3777, 
3778,3749,3778, 36547,3750,3779, 3780,3751,3780, 36549,3752,3781, 36550,3753,3782, 3783,3754,3783, 3784,3755,3784, 36553,3756,3785, 3786,3757,3786, 36555,3758,3787, 3788,3759,3788, 36557,3760,3789, 3790,3761,3790, 3791,3762,3791, 36560,3763,3792, 3793,3764,3793, 
3794,3765,3794, 36563,3766,3795, 3796,3767,3796, 36565,3768,3797, 36566,3769,3798, 3799,3770,3799, 3800,3771,3800, 36569,3772,3801, 36570,3773,3802, 
2, // chain 55
3776,3747,3776, 3775,3746,3775, 3803,3774,3803, 
3804,3775,3804, 
27, // chain 56
3805,3776,3805, 3806,3777,3806, 3807,3778,3807, 
3808,3779,3808, 36577,3780,3809, 36578,3781,3810, 36579,3782,3811, 36574,3777,3806, 3778,3749,3778, 36580,3783,3812, 36573,3776,3805, 3813,3784,3813, 36582,3785,3814, 36583,3786,3815, 36576,3779,3808, 3816,3787,3816, 36585,3788,3817, 36586,3789,3818, 36577,3780,3809, 
3819,3790,3819, 36588,3791,3820, 36578,3781,3810, 3821,3792,3821, 36590,3793,3822, 36579,3782,3811, 3823,3794,3823, 36549,3752,3781, 36548,3751,3780, 36546,3749,3778, 
11, // chain 57
3823,3794,3823, 3824,3795,3824, 3825,3796,3825, 
3822,3793,3822, 36589,3792,3821, 36594,3797,3826, 36595,3798,3827, 36596,3799,3828, 36592,3795,3824, 3829,3800,3829, 36552,3755,3784, 36549,3752,3781, 36591,3794,3823, 
4, // chain 58
3778,3749,3778, 3812,3783,3812, 3775,3746,3775, 
36571,3774,3803, 36598,3801,3830, 36581,3784,3813, 
3, // chain 59
3829,3800,3829, 3784,3755,3784, 3786,3757,3786, 
3791,3762,3791, 36556,3759,3788, 
11, // chain 60
3791,3762,3791, 3794,3765,3794, 3829,3800,3829, 
36596,3799,3828, 36564,3767,3796, 3827,3798,3827, 36565,3768,3797, 3831,3802,3831, 36600,3803,3832, 36568,3771,3800, 3833,3804,3833, 36602,3805,3834, 36569,3772,3801, 
28, // chain 61
3814,3785,3814, 3815,3786,3815, 3835,3806,3835, 
3836,3807,3836, 36605,3808,3837, 36606,3809,3838, 36607,3810,3839, 36583,3786,3815, 3816,3787,3816, 3817,3788,3817, 3840,3811,3840, 36586,3789,3818, 3841,3812,3841, 36587,3790,3819, 3842,3813,3842, 36611,3814,3843, 36612,3815,3844, 36588,3791,3820, 3821,3792,3821, 
3845,3816,3845, 36594,3797,3826, 3846,3817,3846, 36595,3798,3827, 3831,3802,3831, 3847,3818,3847, 36616,3819,3848, 36600,3803,3832, 3849,3820,3849, 36618,3821,3850, 36601,3804,3833, 
4, // chain 62
3844,3815,3844, 3845,3816,3845, 3843,3814,3843, 
36619,3822,3851, 36615,3818,3847, 36614,3817,3846, 
15, // chain 63
3852,3823,3852, 3838,3809,3838, 3839,3810,3839, 
3840,3811,3840, 3853,3824,3853, 36609,3812,3841, 3854,3825,3854, 36610,3813,3842, 3855,3826,3855, 36611,3814,3843, 3856,3827,3856, 36619,3822,3851, 3857,3828,3857, 36615,3818,3847, 3848,3819,3848, 3858,3829,3858, 36617,3820,3849, 
19, // chain 64
3836,3807,3836, 3837,3808,3837, 3859,3830,3859, 
36628,3831,3860, 36629,3832,3861, 36630,3833,3862, 36631,3834,3863, 36606,3809,3838, 3864,3835,3864, 36620,3823,3852, 3865,3836,3865, 36621,3824,3853, 3866,3837,3866, 36622,3825,3854, 3867,3838,3867, 36623,3826,3855, 3868,3839,3868, 36624,3827,3856, 3869,3840,3869, 
36625,3828,3857, 3858,3829,3858, 
36, // chain 65
3870,3841,3870, 3871,3842,3871, 3872,3843,3872, 
3873,3844,3873, 36642,3845,3874, 36643,3846,3875, 36639,3842,3871, 3876,3847,3876, 36645,3848,3877, 36646,3849,3878, 36638,3841,3870, 3879,3850,3879, 36648,3851,3880, 36649,3852,3881, 36641,3844,3873, 3882,3853,3882, 36651,3854,3883, 36642,3845,3874, 3884,3855,3884, 
36653,3856,3885, 36643,3846,3875, 3886,3857,3886, 36655,3858,3887, 36644,3847,3876, 3888,3859,3888, 36657,3860,3889, 36645,3848,3877, 3890,3861,3890, 36659,3862,3891, 36660,3863,3892, 36661,3864,3893, 36646,3849,3878, 3894,3865,3894, 36647,3850,3879, 3895,3866,3895, 
36664,3867,3896, 36665,3868,3897, 36648,3851,3880, 
1, // chain 66
3882,3853,3882, 3883,3854,3883, 3898,3869,3898, 
2, // chain 67
3899,3870,3899, 3883,3854,3883, 3900,3871,3900, 
3901,3872,3901, 
3, // chain 68
3902,3873,3902, 3903,3874,3903, 3904,3875,3904, 
3885,3856,3885, 36652,3855,3884, 
1, // chain 69
3883,3854,3883, 3884,3855,3884, 3900,3871,3900, 
4, // chain 70
3885,3856,3885, 3886,3857,3886, 3902,3873,3902, 
36673,3876,3905, 36656,3859,3888, 36655,3858,3887, 
22, // chain 71
3905,3876,3905, 3888,3859,3888, 3906,3877,3906, 
3907,3878,3907, 36676,3879,3908, 36677,3880,3909, 36678,3881,3910, 36656,3859,3888, 3911,3882,3911, 36657,3860,3889, 3912,3883,3912, 36658,3861,3890, 3913,3884,3913, 36659,3862,3891, 3914,3885,3914, 36683,3886,3915, 36660,3863,3892, 3916,3887,3916, 36661,3864,3893, 
3917,3888,3917, 36662,3865,3894, 3918,3889,3918, 36687,3890,3919, 36663,3866,3895, 
3, // chain 72
3920,3891,3920, 3907,3878,3907, 3908,3879,3908, 
3921,3892,3921, 36677,3880,3909, 
2, // chain 73
3922,3893,3922, 3923,3894,3923, 3907,3878,3907, 
3920,3891,3920, 
3, // chain 74
3902,3873,3902, 3905,3876,3905, 3907,3878,3907, 
3903,3874,3903, 36691,3894,3923, 
4, // chain 75
3924,3895,3924, 3925,3896,3925, 3917,3888,3917, 
3918,3889,3918, 3926,3897,3926, 36687,3890,3919, 
8, // chain 76
3916,3887,3916, 3917,3888,3917, 3925,3896,3925, 
3927,3898,3927, 3928,3899,3928, 36697,3900,3929, 3930,3901,3930, 3931,3902,3931, 3915,3886,3915, 36682,3885,3914, 
1, // chain 77
3915,3886,3915, 3916,3887,3916, 3928,3899,3928, 
2, // chain 78
3932,3903,3932, 3862,3833,3862, 3933,3904,3933, 
3934,3905,3934, 
1, // chain 79
3861,3832,3861, 3862,3833,3862, 3932,3903,3932, 
2, // chain 80
3862,3833,3862, 3863,3834,3863, 3864,3835,3864, 
3933,3904,3933, 
22, // chain 81
3935,3906,3935, 3936,3907,3936, 3937,3908,3937, 
3938,3909,3938, 3939,3910,3939, 36708,3911,3940, 3941,3912,3941, 36710,3913,3942, 3943,3914,3943, 36712,3915,3944, 3945,3916,3945, 36714,3917,3946, 3947,3918,3947, 3948,3919,3948, 36717,3920,3949, 3950,3921,3950, 36719,3922,3951, 36720,3923,3952, 3953,3924,3953, 
3954,3925,3954, 36723,3926,3955, 3956,3927,3956, 3957,3928,3957, 3958,3929,3958, 
2, // chain 82
3936,3907,3936, 3959,3930,3959, 3960,3931,3960, 
3937,3908,3937, 
9, // chain 83
3961,3932,3961, 3962,3933,3962, 3963,3934,3963, 
3964,3935,3964, 3965,3936,3965, 3966,3937,3966, 3967,3938,3967, 36736,3939,3968, 3969,3940,3969, 3970,3941,3970, 36739,3942,3971, 
2, // chain 84
3961,3932,3961, 3967,3938,3967, 3970,3941,3970, 
3962,3933,3962, 
2, // chain 85
3972,3943,3972, 3973,3944,3973, 3974,3945,3974, 
3975,3946,3975, 
1, // chain 86
3976,3947,3976, 3977,3948,3977, 3978,3949,3978, 
1, // chain 87
3979,3950,3979, 3980,3951,3980, 3981,3952,3981, 
1, // chain 88
3982,3953,3982, 3983,3954,3983, 3984,3955,3984, 
1, // chain 89
3985,3956,3985, 3986,3957,3986, 3987,3958,3987, 
10, // chain 90
3988,3959,3988, 3989,3960,3989, 3990,3961,3990, 
3991,3962,3991, 36760,3963,3992, 36761,3964,3993, 36757,3960,3989, 3994,3965,3994, 3995,3966,3995, 3996,3967,3996, 36765,3968,3997, 3998,3969,3998, 
16, // chain 91
3999,3970,3999, 4000,3971,4000, 4001,3972,4001, 
4002,3973,4002, 4003,3974,4003, 36772,3975,4004, 4005,3976,4005, 4006,3977,4006, 4007,3978,4007, 36776,3979,4008, 4009,3980,4009, 36778,3981,4010, 4011,3982,4011, 4012,3983,4012, 36781,3984,4013, 4014,3985,4014, 3991,3962,3991, 36756,3959,3988, 
4, // chain 92
4015,3986,4015, 4016,3987,4016, 4000,3971,4000, 
3999,3970,3999, 4007,3978,4007, 36771,3974,4003, 
4, // chain 93
4017,3988,4017, 3992,3963,3992, 4016,3987,4016, 
4015,3986,4015, 4009,3980,4009, 36775,3978,4007, 
2, // chain 94
4012,3983,4012, 3991,3962,3991, 4017,3988,4017, 
4009,3980,4009, 
1, // chain 95
3991,3962,3991, 3992,3963,3992, 4017,3988,4017, 
21, // chain 96
4018,3989,4018, 4019,3990,4019, 4020,3991,4020, 
4021,3992,4021, 4022,3993,4022, 4023,3994,4023, 4024,3995,4024, 4019,3990,4019, 36793,3996,4025, 36794,3997,4026, 4027,3998,4027, 36796,3999,4028, 4029,4000,4029, 36798,4001,4030, 4031,4002,4031, 36800,4003,4032, 4033,4004,4033, 36802,4005,4034, 4035,4006,4035, 
36804,4007,4036, 4037,4008,4037, 36806,4009,4038, 4039,4010,4039, 
8, // chain 97
4040,4011,4040, 4041,4012,4041, 4042,4013,4042, 
4043,4014,4043, 4044,4015,4044, 4045,4016,4045, 4046,4017,4046, 4047,4018,4047, 4048,4019,4048, 4041,4012,4041, 
10, // chain 98
4049,4020,4049, 4050,4021,4050, 4051,4022,4051, 
4052,4023,4052, 4053,4024,4053, 4054,4025,4054, 4055,4026,4055, 4056,4027,4056, 4057,4028,4057, 4058,4029,4058, 4059,4030,4059, 4050,4021,4050, 
5, // chain 99
4060,4031,4060, 4061,4032,4061, 4062,4033,4062, 
4063,4034,4063, 36832,4035,4064, 36833,4036,4065, 36834,4037,4066, 
10, // chain 100
4067,4038,4067, 4068,4039,4068, 4069,4040,4069, 
4070,4041,4070, 4071,4042,4071, 4072,4043,4072, 4073,4044,4073, 4074,4045,4074, 4075,4046,4075, 4068,4039,4068, 36844,4047,4076, 4077,4048,4077, 
7, // chain 101
4078,4049,4078, 4079,4050,4079, 4080,4051,4080, 
36849,4052,4081, 4082,4053,4082, 4083,4054,4083, 4084,4055,4084, 4085,4056,4085, 4078,4049,4078, 
8, // chain 102
4086,4057,4086, 4087,4058,4087, 4088,4059,4088, 
36857,4060,4089, 4090,4061,4090, 4091,4062,4091, 4092,4063,4092, 4093,4064,4093, 4094,4065,4094, 4086,4057,4086, 

 0};


// face array: 11kb.
const uint16_t elementalist_7_face[5659] PROGMEM = {
5, // chain 0
4095,4066,4095, 4096,4067,4096, 4097,4068,4097, 
4098,4069,4098, 4099,4070,4099, 4100,4071,4100, 36869,4072,4101, 
3, // chain 1
4102,4073,4102, 4103,4074,4103, 4104,4075,4104, 
4105,4076,4105, 36874,4077,4106, 
4, // chain 2
4107,4078,4107, 4108,4079,4108, 4109,4080,4109, 
4110,4081,4110, 36865,4068,4097, 4096,4067,4096, 
2, // chain 3
4111,4082,4111, 4112,4083,4112, 4113,4084,4113, 
4114,4085,4114, 
14, // chain 4
4115,4086,4115, 4116,4087,4116, 4117,4088,4117, 
4118,4089,4118, 36887,4090,4119, 36888,4091,4120, 36889,4092,4121, 36890,4093,4122, 36884,4087,4116, 4123,4094,4123, 36892,4095,4124, 36893,4096,4125, 36894,4097,4126, 36883,4086,4115, 4127,4098,4127, 36886,4089,4118, 
8, // chain 5
4128,4099,4128, 4129,4100,4129, 4130,4101,4130, 
36899,4102,4131, 36900,4103,4132, 4133,4104,4133, 4134,4105,4134, 36903,4106,4135, 4136,4107,4136, 36905,4108,4137, 
9, // chain 6
4138,4109,4138, 4139,4110,4139, 4140,4111,4140, 
36909,4112,4141, 36910,4113,4142, 36911,4114,4143, 4144,4115,4144, 36913,4116,4145, 36914,4117,4146, 4111,4082,4111, 36880,4083,4112, 
6, // chain 7
4147,4118,4147, 4148,4119,4148, 4149,4120,4149, 
4150,4121,4150, 36919,4122,4151, 36920,4123,4152, 36921,4124,4153, 36916,4119,4148, 
7, // chain 8
4154,4125,4154, 4155,4126,4155, 4156,4127,4156, 
4126,4097,4126, 36893,4096,4125, 36870,4073,4102, 36918,4121,4150, 36923,4126,4155, 4147,4118,4147, 
25, // chain 9
4157,4128,4157, 4158,4129,4158, 4159,4130,4159, 
4160,4131,4160, 36929,4132,4161, 36930,4133,4162, 36931,4134,4163, 36932,4135,4164, 36933,4136,4165, 36934,4137,4166, 36926,4129,4158, 4157,4128,4157, 4167,4138,4167, 36936,4139,4168, 36928,4131,4160, 4169,4140,4169, 36938,4141,4170, 36929,4132,4161, 4171,4142,4171, 
36940,4143,4172, 36930,4133,4162, 4173,4144,4173, 36942,4145,4174, 4175,4146,4175, 4176,4147,4176, 4177,4148,4177, 36946,4149,4178, 
2, // chain 10
4173,4144,4173, 4177,4148,4177, 4172,4143,4172, 
36939,4142,4171, 
12, // chain 11
4179,4150,4179, 4180,4151,4180, 4163,4134,4163, 
4164,4135,4164, 4181,4152,4181, 36950,4153,4182, 36951,4154,4183, 36933,4136,4165, 4184,4155,4184, 36934,4137,4166, 4185,4156,4185, 36954,4157,4186, 36955,4158,4187, 36935,4138,4167, 
2, // chain 12
4119,4090,4119, 4120,4091,4120, 4186,4157,4186, 
4187,4158,4187, 
2, // chain 13
4150,4121,4150, 4151,4122,4151, 4102,4073,4102, 
36871,4074,4103, 
2, // chain 14
4105,4076,4105, 4124,4095,4124, 4125,4096,4125, 
4102,4073,4102, 
8, // chain 15
4184,4155,4184, 4185,4156,4185, 4188,4159,4188, 
4189,4160,4189, 36958,4161,4190, 36959,4162,4191, 36889,4092,4121, 36953,4156,4185, 4186,4157,4186, 4120,4091,4120, 
38, // chain 16
4192,4163,4192, 4193,4164,4193, 4194,4165,4194, 
4195,4166,4195, 36964,4167,4196, 36965,4168,4197, 36966,4169,4198, 36961,4164,4193, 4199,4170,4199, 36968,4171,4200, 36969,4172,4201, 36960,4163,4192, 4202,4173,4202, 36971,4174,4203, 36972,4175,4204, 36963,4166,4195, 4205,4176,4205, 36974,4177,4206, 36964,4167,4196, 
4207,4178,4207, 36976,4179,4208, 36965,4168,4197, 4209,4180,4209, 36978,4181,4210, 36966,4169,4198, 4190,4161,4190, 36967,4170,4199, 4189,4160,4189, 36968,4171,4200, 4183,4154,4183, 36979,4182,4211, 36980,4183,4212, 36969,4172,4201, 4213,4184,4213, 36970,4173,4202, 
4214,4185,4214, 36971,4174,4203, 4215,4186,4215, 4216,4187,4216, 36985,4188,4217, 
5, // chain 17
4218,4189,4218, 4219,4190,4219, 4220,4191,4220, 
4221,4192,4221, 36990,4193,4222, 4206,4177,4206, 36973,4176,4205, 
5, // chain 18
4223,4194,4223, 4224,4195,4224, 4209,4180,4209, 
4225,4196,4225, 36978,4181,4210, 4191,4162,4191, 36958,4161,4190, 
8, // chain 19
4121,4092,4121, 4226,4197,4226, 4227,4198,4227, 
4191,4162,4191, 36993,4196,4225, 36996,4199,4228, 36994,4197,4226, 4229,4200,4229, 36890,4093,4122, 36889,4092,4121, 
6, // chain 20
4221,4192,4221, 4206,4177,4206, 4207,4178,4207, 
4230,4201,4230, 36999,4202,4231, 36976,4179,4208, 4224,4195,4224, 36977,4180,4209, 
10, // chain 21
4232,4203,4232, 4233,4204,4233, 4234,4205,4234, 
4224,4195,4224, 36999,4202,4231, 36998,4201,4230, 36986,4189,4218, 37003,4206,4235, 37004,4207,4236, 4237,4208,4237, 4219,4190,4219, 4218,4189,4218, 
10, // chain 22
4238,4209,4238, 4239,4210,4239, 4240,4211,4240, 
4229,4200,4229, 36996,4199,4228, 37009,4212,4241, 37001,4204,4233, 4232,4203,4232, 4224,4195,4224, 4223,4194,4223, 4228,4199,4228, 36993,4196,4225, 
3, // chain 23
4179,4150,4179, 4181,4152,4181, 4242,4213,4242, 
37011,4214,4243, 36950,4153,4182, 
2, // chain 24
4108,4079,4108, 4107,4078,4107, 4244,4215,4244, 
4245,4216,4245, 
1, // chain 25
4184,4155,4184, 4189,4160,4189, 4183,4154,4183, 
36, // chain 26
4246,4217,4246, 4247,4218,4247, 4248,4219,4248, 
37017,4220,4249, 4250,4221,4250, 37019,4222,4251, 37020,4223,4252, 4253,4224,4253, 37022,4225,4254, 37023,4226,4255, 4256,4227,4256, 37025,4228,4257, 4258,4229,4258, 37027,4230,4259, 4260,4231,4260, 4261,4232,4261, 37030,4233,4262, 37031,4234,4263, 4264,4235,4264, 
4265,4236,4265, 37034,4237,4266, 4267,4238,4267, 37036,4239,4268, 4269,4240,4269, 37038,4241,4270, 4271,4242,4271, 37040,4243,4272, 4273,4244,4273, 37042,4245,4274, 4275,4246,4275, 37044,4247,4276, 4277,4248,4277, 37046,4249,4278, 4279,4250,4279, 4280,4251,4280, 
37049,4252,4281, 4282,4253,4282, 37051,4254,4283, 
1, // chain 27
4126,4097,4126, 4127,4098,4127, 4154,4125,4154, 
3, // chain 28
4284,4255,4284, 4123,4094,4123, 4285,4256,4285, 
4238,4209,4238, 37007,4210,4239, 
2, // chain 29
4123,4094,4123, 4124,4095,4124, 4286,4257,4286, 
36873,4076,4105, 
13, // chain 30
4287,4258,4287, 4288,4259,4288, 4289,4260,4289, 
4290,4261,4290, 37059,4262,4291, 4292,4263,4292, 37061,4264,4293, 37062,4265,4294, 4295,4266,4295, 37064,4267,4296, 4297,4268,4297, 37066,4269,4298, 4299,4270,4299, 4248,4219,4248, 37014,4217,4246, 
17, // chain 31
4258,4229,4258, 4261,4232,4261, 4290,4261,4290, 
4300,4271,4300, 37060,4263,4292, 4293,4264,4293, 4301,4272,4301, 37063,4266,4295, 4297,4268,4297, 4302,4273,4302, 37016,4219,4248, 4250,4221,4250, 4251,4222,4251, 4253,4224,4253, 4301,4272,4301, 37022,4225,4254, 4300,4271,4300, 37024,4227,4256, 4258,4229,4258, 
19, // chain 32
4290,4261,4290, 4261,4232,4261, 4262,4233,4262, 
4287,4258,4287, 37071,4274,4303, 37033,4236,4265, 4304,4275,4304, 37035,4238,4267, 4305,4276,4305, 37037,4240,4269, 4306,4277,4306, 37039,4242,4271, 4307,4278,4307, 37041,4244,4273, 4308,4279,4308, 37043,4246,4275, 4309,4280,4309, 37045,4248,4277, 4280,4251,4280, 
4310,4281,4310, 37050,4253,4282, 
2, // chain 33
4311,4282,4311, 4312,4283,4312, 4313,4284,4313, 
4314,4285,4314, 
10, // chain 34
4315,4286,4315, 4316,4287,4316, 4317,4288,4317, 
4318,4289,4318, 37087,4290,4319, 37088,4291,4320, 37089,4292,4321, 37084,4287,4316, 4322,4293,4322, 37091,4294,4323, 37092,4295,4324, 37083,4286,4315, 
10, // chain 35
4325,4296,4325, 4326,4297,4326, 4327,4298,4327, 
4328,4299,4328, 37091,4294,4323, 37097,4300,4329, 37098,4301,4330, 37094,4297,4326, 4331,4302,4331, 37100,4303,4332, 37101,4304,4333, 37093,4296,4325, 
18, // chain 36
4334,4305,4334, 4335,4306,4335, 4336,4307,4336, 
4331,4302,4331, 37105,4308,4337, 4330,4301,4330, 37106,4309,4338, 4329,4300,4329, 37107,4310,4339, 4322,4293,4322, 37108,4311,4340, 4321,4292,4321, 37109,4312,4341, 4320,4291,4320, 37110,4313,4342, 4343,4314,4343, 37112,4315,4344, 4345,4316,4345, 4312,4283,4312, 
37081,4284,4313, 
1, // chain 37
4331,4302,4331, 4332,4303,4332, 4334,4305,4334, 
14, // chain 38
4346,4317,4346, 4288,4259,4288, 4287,4258,4287, 
4303,4274,4303, 4304,4275,4304, 4347,4318,4347, 37073,4276,4305, 4348,4319,4348, 37074,4277,4306, 4349,4320,4349, 37075,4278,4307, 4350,4321,4350, 37076,4279,4308, 4351,4322,4351, 37077,4280,4309, 4310,4281,4310, 
1, // chain 39
4221,4192,4221, 4230,4201,4230, 4218,4189,4218, 
3, // chain 40
4123,4094,4123, 4284,4255,4284, 4122,4093,4122, 
36997,4200,4229, 37006,4209,4238, 
2, // chain 41
4286,4257,4286, 4352,4323,4352, 4285,4256,4285, 
4123,4094,4123, 
4, // chain 42
4319,4290,4319, 4320,4291,4320, 4343,4314,4343, 
4312,4283,4312, 4353,4324,4353, 37079,4282,4311, 
1, // chain 43
4322,4293,4322, 4323,4294,4323, 4329,4300,4329, 
1, // chain 44
4318,4289,4318, 4319,4290,4319, 4353,4324,4353, 
1, // chain 45
4328,4299,4328, 4323,4294,4323, 4324,4295,4324, 
8, // chain 46
4216,4187,4216, 4354,4325,4354, 4355,4326,4355, 
4356,4327,4356, 4214,4185,4214, 36981,4184,4213, 37125,4328,4357, 4212,4183,4212, 37126,4329,4358, 4211,4182,4211, 
2, // chain 47
4179,4150,4179, 4359,4330,4359, 4360,4331,4360, 
4180,4151,4180, 
3, // chain 48
4163,4134,4163, 4180,4151,4180, 4361,4332,4361, 
4162,4133,4162, 37130,4333,4362, 
1, // chain 49
4363,4334,4363, 4364,4304,4364, 4365,4335,4365, 
1, // chain 50
4366,4336,4366, 4367,4337,4367, 4368,4338,4368, 
8, // chain 51
4369,4339,4369, 4370,4340,4370, 4371,4341,4371, 
4372,4342,4372, 37141,4343,4373, 37142,4344,4374, 4375,4345,4375, 37144,4346,4376, 4377,4347,4377, 37146,4348,4378, 
46, // chain 52
4379,4349,4379, 4380,4350,4380, 4381,4351,4381, 
37150,4352,4382, 4383,4353,4383, 37152,4354,4384, 37153,4355,4385, 4386,4356,4386, 4387,4357,4387, 4388,4358,4388, 4383,4353,4383, 37157,4359,4389, 4390,4360,4390, 37159,4361,4391, 4392,4362,4392, 37161,4363,4393, 4394,4364,4394, 37163,4365,4395, 4396,4366,4396, 
37165,4367,4397, 4398,4368,4398, 37167,4369,4399, 37168,4370,4400, 4401,4371,4401, 37170,4372,4402, 4403,4373,4403, 37172,4374,4404, 4405,4375,4405, 37174,4376,4406, 4407,4377,4407, 4408,4378,4408, 37177,4379,4409, 4410,4380,4410, 37179,4381,4411, 4412,4382,4412, 
37181,4383,4413, 37182,4384,4414, 4415,4385,4415, 4416,4386,4416, 4412,4382,4412, 37185,4387,4417, 4418,4388,4418, 4410,4380,4410, 37176,4378,4408, 37187,4389,4419, 37188,4390,4420, 37189,4391,4421, 37190,4392,4422, 
11, // chain 53
4423,4393,4423, 4424,4394,4424, 4425,4395,4425, 
4426,4396,4426, 4427,4397,4427, 4428,4398,4428, 37197,4399,4429, 4430,4400,4430, 37199,4401,4431, 37200,4402,4432, 4433,4403,4433, 37202,4404,4434, 37203,4405,4435, 
15, // chain 54
4436,4406,4436, 4394,4364,4394, 4396,4366,4396, 
4437,4407,4437, 37206,4408,4438, 37166,4368,4398, 4399,4369,4399, 4439,4409,4439, 37169,4371,4401, 4440,4410,4440, 37209,4411,4441, 37187,4389,4419, 37210,4412,4442, 37171,4373,4403, 4419,4389,4419, 37173,4375,4405, 4408,4378,4408, 
1, // chain 55
4443,4413,4443, 4444,4414,4444, 4445,4415,4445, 
5, // chain 56
4446,4416,4446, 4447,4417,4447, 4448,4418,4448, 
4449,4419,4449, 4450,4420,4450, 37219,4421,4451, 4452,4422,4452, 
3, // chain 57
4453,4423,4453, 4454,4424,4454, 4420,4390,4420, 
4455,4425,4455, 37189,4391,4421, 
2, // chain 58
4454,4424,4454, 4441,4411,4441, 4419,4389,4419, 
4420,4390,4420, 
7, // chain 59
4390,4360,4390, 4392,4362,4392, 4456,4426,4456, 
4381,4351,4381, 37225,4427,4457, 37226,4428,4458, 37204,4406,4436, 37160,4362,4392, 4394,4364,4394, 
14, // chain 60
4454,4424,4454, 4453,4423,4453, 4459,4429,4459, 
37228,4430,4460, 4461,4431,4461, 4462,4182,4462, 4454,4424,4454, 37231,4432,4463, 4441,4411,4441, 37208,4410,4440, 37232,4433,4464, 37233,4434,4465, 4466,4435,4466, 37235,4436,4467, 37236,4437,4468, 37237,4438,4469, 
2, // chain 61
4457,4427,4457, 4470,4439,4470, 4379,4349,4379, 
4381,4351,4381, 
6, // chain 62
4439,4409,4439, 4440,4410,4440, 4471,4440,4471, 
4438,4408,4438, 37240,4441,4472, 37241,4442,4473, 37232,4433,4464, 37208,4410,4440, 
14, // chain 63
4474,4443,4474, 4475,4444,4475, 4476,4445,4476, 
4467,4436,4467, 37245,4446,4477, 37246,4447,4478, 37247,4448,4479, 37243,4444,4475, 4480,4449,4480, 37249,4450,4481, 37250,4451,4482, 37242,4443,4474, 4483,4452,4483, 37252,4453,4484, 37236,4437,4468, 37235,4436,4467, 
23, // chain 64
4485,4454,4485, 4486,4455,4486, 4487,4456,4487, 
4488,4457,4488, 4489,4458,4489, 37258,4459,4490, 4491,4460,4491, 4492,4461,4492, 4485,4454,4485, 37261,4462,4493, 37262,4463,4494, 37263,4464,4495, 37264,4465,4496, 37265,4466,4497, 4498,4467,4498, 37267,4468,4499, 4500,4469,4500, 37269,4470,4501, 37270,4471,4502, 
37271,4472,4503, 4504,4473,4504, 4505,4474,4505, 37274,4475,4506, 37275,4476,4507, 37276,4477,4508, 
13, // chain 65
4509,4478,4509, 4510,4479,4510, 4511,4480,4511, 
4495,4464,4495, 37280,4481,4512, 37246,4447,4478, 37281,4482,4513, 37278,4479,4510, 4472,4441,4472, 37282,4483,4514, 37268,4469,4500, 37277,4478,4509, 4498,4467,4498, 37263,4464,4495, 4496,4465,4496, 
6, // chain 66
4515,4484,4515, 4438,4408,4438, 4514,4483,4514, 
4500,4469,4500, 4501,4470,4501, 4437,4407,4437, 37273,4474,4505, 37270,4471,4502, 
7, // chain 67
4480,4449,4480, 4486,4455,4486, 4516,4485,4516, 
4479,4448,4479, 37280,4481,4512, 37262,4463,4494, 37261,4462,4493, 37254,4455,4486, 4485,4454,4485, 
3, // chain 68
4517,4486,4517, 4487,4456,4487, 4486,4455,4486, 
4480,4449,4480, 4481,4450,4481, 
8, // chain 69
4468,4437,4468, 4518,4487,4518, 4519,4488,4519, 
4484,4453,4484, 37288,4489,4520, 37289,4490,4521, 37290,4491,4522, 37291,4438,4523, 4524,4492,4524, 37293,4153,4525, 
6, // chain 70
4483,4452,4483, 4484,4453,4484, 4520,4489,4520, 
4526,4493,4526, 37295,4494,4527, 37289,4490,4521, 4528,4495,4528, 4529,4188,4529, 
4, // chain 71
4467,4436,4467, 4477,4446,4477, 4466,4435,4466, 
37241,4442,4473, 37281,4482,4513, 37246,4447,4478, 
1, // chain 72
4527,4494,4527, 4530,4325,4530, 4526,4493,4526, 
1, // chain 73
4381,4351,4381, 4383,4353,4383, 4390,4360,4390, 
3, // chain 74
4531,4496,4531, 4370,4340,4370, 4369,4339,4369, 
4532,4497,4532, 4533,4498,4533, 
1, // chain 75
4472,4441,4472, 4473,4442,4473, 4513,4482,4513, 
1, // chain 76
4495,4464,4495, 4512,4481,4512, 4494,4463,4494, 
1, // chain 77
4534,4153,4534, 4535,4499,4535, 4536,4432,4536, 
1, // chain 78
4537,4434,4537, 4538,4153,4538, 4539,4487,4539, 
1, // chain 79
4466,4435,4466, 4473,4442,4473, 4464,4433,4464, 
1, // chain 80
4472,4441,4472, 4514,4483,4514, 4438,4408,4438, 
32, // chain 81
4540,4500,4540, 4541,4501,4541, 4542,4502,4542, 
4543,4503,4543, 4544,4504,4544, 37313,4505,4545, 4546,4506,4546, 4547,4507,4547, 37316,4508,4548, 4549,4509,4549, 37318,4510,4550, 4551,4511,4551, 37320,4512,4552, 37321,4513,4553, 4554,4514,4554, 37323,4515,4555, 4556,4516,4556, 4557,4517,4557, 37326,4518,4558, 
37327,4519,4559, 4560,4520,4560, 37329,4521,4561, 4562,4522,4562, 37331,4523,4563, 4564,4524,4564, 37333,4525,4565, 4566,4526,4566, 37335,4527,4567, 4568,4528,4568, 37337,4529,4569, 4570,4530,4570, 37339,4531,4571, 4572,4532,4572, 37341,4533,4573, 
1, // chain 82
4512,4481,4512, 4478,4447,4478, 4479,4448,4479, 
8, // chain 83
4574,4534,4574, 4575,4535,4575, 4576,4536,4576, 
4577,4537,4577, 37346,4538,4578, 37347,4539,4579, 37343,4535,4575, 4540,4500,4540, 37342,4534,4574, 4541,4501,4541, 
2, // chain 84
4436,4406,4436, 4437,4407,4437, 4506,4475,4506, 
37273,4474,4505, 
3, // chain 85
4458,4428,4458, 4436,4406,4436, 4506,4475,4506, 
4507,4476,4507, 4457,4427,4457, 
9, // chain 86
4577,4537,4577, 4578,4538,4578, 4580,4540,4580, 
4581,4541,4581, 37350,4542,4582, 37351,4543,4583, 37352,4544,4584, 37346,4538,4578, 4579,4539,4579, 4544,4504,4544, 37308,4500,4540, 
20, // chain 87
4585,4545,4585, 4586,4546,4586, 4552,4512,4552, 
4587,4547,4587, 37322,4514,4554, 4557,4517,4557, 4588,4548,4588, 37326,4518,4558, 4589,4549,4589, 37328,4520,4560, 4590,4550,4590, 37330,4522,4562, 4591,4551,4591, 37332,4524,4564, 4592,4552,4592, 37334,4526,4566, 4593,4553,4593, 37336,4528,4568, 4594,4554,4594, 
37338,4530,4570, 4595,4555,4595, 37340,4532,4572, 
12, // chain 88
4596,4556,4596, 4597,4557,4597, 4589,4549,4589, 
4590,4550,4590, 4598,4558,4598, 37359,4551,4591, 4599,4559,4599, 37360,4552,4592, 4600,4560,4600, 37361,4553,4593, 4601,4561,4601, 37362,4554,4594, 4602,4562,4602, 37363,4555,4595, 
20, // chain 89
4603,4563,4603, 4604,4564,4604, 4605,4565,4605, 
4606,4566,4606, 37375,4567,4607, 4608,4568,4608, 37377,4569,4609, 4610,4570,4610, 4611,4571,4611, 37380,4572,4612, 4613,4573,4613, 37382,4574,4614, 4615,4575,4615, 37384,4576,4616, 4617,4577,4617, 37386,4578,4618, 4619,4579,4619, 37388,4580,4620, 4621,4581,4621, 
37390,4582,4622, 4623,4583,4623, 37392,4584,4624, 
9, // chain 90
4625,4585,4625, 4626,4586,4626, 4627,4587,4627, 
4628,4588,4628, 37381,4573,4613, 37379,4571,4611, 37397,4589,4629, 37394,4586,4626, 4630,4590,4630, 4606,4566,4606, 37371,4563,4603, 
9, // chain 91
4631,4591,4631, 4632,4592,4632, 4633,4593,4633, 
4634,4594,4634, 37387,4579,4619, 37385,4577,4617, 37403,4595,4635, 37400,4592,4632, 4636,4596,4636, 4628,4588,4628, 37393,4585,4625, 
2, // chain 92
4637,4597,4637, 4634,4594,4634, 4621,4581,4621, 
4623,4583,4623, 
9, // chain 93
4581,4541,4581, 4582,4542,4582, 4638,4598,4638, 
37354,4546,4586, 37351,4543,4583, 4552,4512,4552, 37319,4511,4551, 37317,4509,4549, 37352,4544,4584, 4547,4507,4547, 37312,4504,4544, 
8, // chain 94
4639,4599,4639, 4640,4600,4640, 4586,4546,4586, 
4585,4545,4585, 4587,4547,4587, 4641,4601,4641, 37410,4602,4642, 37356,4548,4588, 4597,4557,4597, 37357,4549,4589, 
3, // chain 95
4628,4588,4628, 4613,4573,4613, 4615,4575,4615, 
4635,4595,4635, 37385,4577,4617, 
1, // chain 96
4634,4594,4634, 4619,4579,4619, 4621,4581,4621, 
2, // chain 97
4634,4594,4634, 4637,4597,4637, 4643,4336,4643, 
4631,4591,4631, 
1, // chain 98
4638,4598,4638, 4586,4546,4586, 4640,4600,4640, 
2, // chain 99
4629,4589,4629, 4606,4566,4606, 4608,4568,4608, 
4611,4571,4611, 
2, // chain 100
4644,4603,4644, 4645,4604,4645, 4453,4423,4453, 
4455,4425,4455, 
1, // chain 101
4438,4408,4438, 4515,4484,4515, 4437,4407,4437, 
1, // chain 102
4646,4605,4646, 4647,4304,4647, 4648,4606,4648, 
1, // chain 103
4649,4336,4649, 4650,4607,4650, 4651,4608,4651, 
2, // chain 104
4448,4418,4448, 4447,4417,4447, 4652,4405,4652, 
4653,4415,4653, 
12, // chain 105
4654,4609,4654, 4655,4610,4655, 4656,4611,4656, 
4657,4612,4657, 37426,4613,4658, 4659,4614,4659, 37428,4615,4660, 4661,4616,4661, 37430,4617,4662, 4663,4618,4663, 37432,4619,4664, 4665,4620,4665, 37434,4621,4666, 4667,4622,4667, 
10, // chain 106
4668,4623,4668, 4669,4624,4669, 4670,4625,4670, 
37439,4626,4671, 37440,4627,4672, 37441,4628,4673, 4674,4629,4674, 4675,4630,4675, 37444,4631,4676, 37445,4632,4677, 4678,4633,4678, 37447,4634,4679, 
23, // chain 107
4680,4635,4680, 4681,4636,4681, 4682,4637,4682, 
4683,4638,4683, 37452,4639,4684, 37453,4640,4685, 37454,4641,4686, 37449,4636,4681, 4687,4642,4687, 37448,4635,4680, 4688,4643,4688, 37457,4644,4689, 37458,4645,4690, 37451,4638,4683, 4691,4646,4691, 37460,4647,4692, 37452,4639,4684, 4693,4648,4693, 37462,4649,4694, 
37453,4640,4685, 4695,4650,4695, 37464,4651,4696, 37454,4641,4686, 4697,4652,4697, 37455,4642,4687, 
5, // chain 108
4698,4653,4698, 4699,4654,4699, 4700,4655,4700, 
4701,4656,4701, 37470,4657,4702, 4703,4658,4703, 37472,4659,4704, 
5, // chain 109
4699,4654,4699, 4698,4653,4698, 4705,4660,4705, 
37460,4647,4692, 37474,4661,4706, 37475,4662,4707, 37476,4663,4708, 
9, // chain 110
4709,4664,4709, 4710,4665,4710, 4711,4666,4711, 
4712,4667,4712, 37481,4668,4713, 4670,4625,4670, 37482,4669,4714, 37483,4670,4715, 4716,4671,4716, 4717,4672,4717, 37486,4673,4718, 
2, // chain 111
4719,4674,4719, 4720,4675,4720, 4710,4665,4710, 
4709,4664,4709, 
1, // chain 112
4668,4623,4668, 4670,4625,4670, 4714,4669,4714, 
4, // chain 113
4695,4650,4695, 4721,4676,4721, 4694,4649,4694, 
37490,4677,4722, 37467,4654,4699, 37468,4655,4700, 
1, // chain 114
4712,4667,4712, 4670,4625,4670, 4671,4626,4671, 
3, // chain 115
4705,4660,4705, 4692,4647,4692, 4693,4648,4693, 
4722,4677,4722, 37462,4649,4694, 
4, // chain 116
4723,4678,4723, 4724,4679,4724, 4725,4680,4725, 
4726,4681,4726, 37456,4643,4688, 4689,4644,4689, 
2, // chain 117
4727,4682,4727, 4720,4675,4720, 4719,4674,4719, 
4728,4683,4728, 
1, // chain 118
4699,4654,4699, 4705,4660,4705, 4722,4677,4722, 
1, // chain 119
4691,4646,4691, 4692,4647,4692, 4706,4661,4706, 
1, // chain 120
4729,4684,4729, 4730,4685,4730, 4731,4686,4731, 
1, // chain 121
4732,4687,4732, 4733,4688,4733, 4734,4689,4734, 
1, // chain 122
4735,4690,4735, 4736,4691,4736, 4737,4692,4737, 
1, // chain 123
4738,4693,4738, 4739,4694,4739, 4740,4695,4740, 
1, // chain 124
4741,4696,4741, 4742,4697,4742, 4743,4698,4743, 
1, // chain 125
4744,4699,4744, 4745,4700,4745, 4746,4701,4746, 
1, // chain 126
4747,4702,4747, 4748,4703,4748, 4749,4704,4749, 
1, // chain 127
4750,4705,4750, 4751,4706,4751, 4752,4707,4752, 
1, // chain 128
4753,4708,4753, 4754,4709,4754, 4755,4710,4755, 
1, // chain 129
4756,4711,4756, 4757,4712,4757, 4758,4713,4758, 
1, // chain 130
4759,4714,4759, 4760,4715,4760, 4761,4716,4761, 
1, // chain 131
4762,4717,4762, 4763,4718,4763, 4764,4719,4764, 
1, // chain 132
4765,4720,4765, 4766,4721,4766, 4767,4722,4767, 
1, // chain 133
4768,4723,4768, 4769,4724,4769, 4770,4725,4770, 
1, // chain 134
4771,4726,4771, 4772,4727,4772, 4773,4728,4773, 
1, // chain 135
4774,4729,4774, 4775,4730,4775, 4776,4731,4776, 
1, // chain 136
4777,4732,4777, 4778,4733,4778, 4779,4734,4779, 
1, // chain 137
4780,4735,4780, 4781,4736,4781, 4782,4737,4782, 
1, // chain 138
4783,4738,4783, 4784,4739,4784, 4785,4740,4785, 
1, // chain 139
4786,4741,4786, 4787,4742,4787, 4788,4743,4788, 
1, // chain 140
4789,4744,4789, 4790,4745,4790, 4791,4746,4791, 
1, // chain 141
4792,4747,4792, 4793,4748,4793, 4794,4749,4794, 
1, // chain 142
4795,4750,4795, 4796,4751,4796, 4797,4752,4797, 
1, // chain 143
4798,4753,4798, 4799,4754,4799, 4800,4755,4800, 
1, // chain 144
4801,4756,4801, 4802,4757,4802, 4803,4758,4803, 
1, // chain 145
4804,4759,4804, 4805,4760,4805, 4806,4761,4806, 
1, // chain 146
4807,4762,4807, 4808,4763,4808, 4809,4764,4809, 
1, // chain 147
4810,4765,4810, 4811,4766,4811, 4812,4767,4812, 
1, // chain 148
4813,4768,4813, 4814,4769,4814, 4815,4770,4815, 
1, // chain 149
4816,4771,4816, 4817,4772,4817, 4818,4773,4818, 
1, // chain 150
4819,4774,4819, 4820,4775,4820, 4821,4776,4821, 
1, // chain 151
4822,4777,4822, 4823,4778,4823, 4824,4779,4824, 
1, // chain 152
4825,4780,4825, 4826,4781,4826, 4827,4782,4827, 
1, // chain 153
4828,4783,4828, 4829,4784,4829, 4830,4785,4830, 
1, // chain 154
4831,4786,4831, 4832,4787,4832, 4833,4788,4833, 
1, // chain 155
4834,4789,4834, 4835,4790,4835, 4836,4791,4836, 
1, // chain 156
4837,4792,4837, 4838,4793,4838, 4839,4794,4839, 
1, // chain 157
4840,4795,4840, 4841,4796,4841, 4842,4797,4842, 
1, // chain 158
4843,4798,4843, 4844,4799,4844, 4845,4800,4845, 
1, // chain 159
4846,4801,4846, 4847,4802,4847, 4848,4803,4848, 
1, // chain 160
4849,4804,4849, 4850,4805,4850, 4851,4806,4851, 
1, // chain 161
4852,4807,4852, 4853,4808,4853, 4854,4809,4854, 
1, // chain 162
4855,4810,4855, 4856,4811,4856, 4857,4812,4857, 
1, // chain 163
4858,4813,4858, 4859,4814,4859, 4860,4815,4860, 
1, // chain 164
4861,4816,4861, 4862,4817,4862, 4863,4818,4863, 
1, // chain 165
4864,4819,4864, 4865,4820,4865, 4866,4821,4866, 
1, // chain 166
4867,4822,4867, 4868,4823,4868, 4869,4824,4869, 
1, // chain 167
4870,4825,4870, 4871,4826,4871, 4872,4827,4872, 
1, // chain 168
4873,4828,4873, 4874,4829,4874, 4875,4830,4875, 
1, // chain 169
4876,4831,4876, 4877,4832,4877, 4878,4833,4878, 
1, // chain 170
4879,4834,4879, 4880,4835,4880, 4881,4836,4881, 
1, // chain 171
4882,4837,4882, 4883,4838,4883, 4884,4839,4884, 
1, // chain 172
4885,4840,4885, 4886,4841,4886, 4887,4842,4887, 
1, // chain 173
4888,4843,4888, 4889,4844,4889, 4890,4845,4890, 
1, // chain 174
4891,4846,4891, 4892,4847,4892, 4893,4848,4893, 
1, // chain 175
4894,4849,4894, 4895,4850,4895, 4896,4851,4896, 
1, // chain 176
4897,4852,4897, 4898,4853,4898, 4899,4854,4899, 
1, // chain 177
4900,4855,4900, 4901,4856,4901, 4902,4857,4902, 
1, // chain 178
4903,4858,4903, 4904,4859,4904, 4905,4860,4905, 
1, // chain 179
4906,4861,4906, 4907,4862,4907, 4908,4863,4908, 
1, // chain 180
4909,4864,4909, 4910,4865,4910, 4911,4866,4911, 
1, // chain 181
4912,4867,4912, 4913,4868,4913, 4914,4869,4914, 
1, // chain 182
4915,4870,4915, 4916,4871,4916, 4917,4872,4917, 
1, // chain 183
4918,4873,4918, 4919,4874,4919, 4920,4875,4920, 
2, // chain 184
4921,4876,4921, 4690,4645,4690, 4691,4646,4691, 
4922,4877,4922, 
21, // chain 185
4923,4878,4923, 4924,4879,4924, 4925,4880,4925, 
4926,4881,4926, 37695,4882,4927, 37696,4883,4928, 37697,4884,4929, 37698,4885,4930, 37692,4879,4924, 4931,4886,4931, 37700,4887,4932, 37701,4888,4933, 37691,4878,4923, 4934,4889,4934, 37703,4890,4935, 37694,4881,4926, 4936,4891,4936, 37705,4892,4937, 37695,4882,4927, 
4938,4893,4938, 37696,4883,4928, 4939,4894,4939, 37697,4884,4929, 
16, // chain 186
4940,4895,4940, 4941,4896,4941, 4942,4897,4942, 
4943,4898,4943, 37712,4899,4944, 37713,4900,4945, 37714,4901,4946, 37709,4896,4941, 4947,4902,4947, 37716,4903,4948, 37708,4895,4940, 4949,4904,4949, 37718,4905,4950, 37719,4906,4951, 37711,4898,4943, 4952,4907,4952, 37721,4908,4953, 37712,4899,4944, 
21, // chain 187
4949,4904,4949, 4954,4909,4954, 4955,4910,4955, 
4948,4903,4948, 37715,4902,4947, 37724,4911,4956, 37725,4912,4957, 37726,4913,4958, 37727,4914,4959, 37722,4909,4954, 4960,4915,4960, 37729,4916,4961, 37717,4904,4949, 4934,4889,4934, 37701,4888,4933, 37730,4917,4962, 37718,4905,4950, 4963,4918,4963, 37732,4919,4964, 
37719,4906,4951, 4965,4920,4965, 37720,4907,4952, 4966,4921,4966, 
3, // chain 188
4932,4887,4932, 4933,4888,4933, 4962,4917,4962, 
4967,4922,4967, 37731,4918,4963, 
4, // chain 189
4945,4900,4945, 4946,4901,4946, 4968,4923,4968, 
37737,4924,4969, 37715,4902,4947, 4956,4911,4956, 
7, // chain 190
4970,4925,4970, 4935,4890,4935, 4936,4891,4936, 
4971,4926,4971, 37705,4892,4937, 4972,4927,4972, 37741,4928,4973, 37706,4893,4938, 4974,4929,4974, 
8, // chain 191
4960,4915,4960, 4961,4916,4961, 4934,4889,4934, 
4975,4930,4975, 37703,4890,4935, 4970,4925,4970, 4976,4931,4976, 37745,4932,4977, 37739,4926,4971, 4972,4927,4972, 
4, // chain 192
4978,4933,4978, 4979,4934,4979, 4958,4913,4958, 
4959,4914,4959, 4975,4930,4975, 37728,4915,4960, 
3, // chain 193
4979,4934,4979, 4978,4933,4978, 4975,4930,4975, 
4976,4931,4976, 4977,4932,4977, 
1, // chain 194
4931,4886,4931, 4932,4887,4932, 4967,4922,4967, 
1, // chain 195
4980,4935,4980, 4981,4936,4981, 4982,4937,4982, 
1, // chain 196
4983,4938,4983, 4984,4939,4984, 4985,4940,4985, 
7, // chain 197
4986,4941,4986, 4987,4942,4987, 4988,4943,4988, 
4989,4944,4989, 4990,4945,4990, 37759,4946,4991, 37760,4947,4992, 37761,4948,4993, 4994,4949,4994, 
27, // chain 198
4995,4950,4995, 4996,4951,4996, 4997,4952,4997, 
4998,4953,4998, 37767,4954,4999, 37768,4955,5000, 37769,4956,5001, 37764,4951,4996, 5002,4957,5002, 37771,4958,5003, 37772,4959,5004, 37763,4950,4995, 5005,4960,5005, 37774,4961,5006, 37775,4962,5007, 37766,4953,4998, 4999,4954,4999, 5008,4963,5008, 37777,4964,5009, 
37768,4955,5000, 5010,4965,5010, 37779,4966,5011, 37769,4956,5001, 5012,4967,5012, 37770,4957,5002, 5013,4968,5013, 37782,4969,5014, 37783,4970,5015, 37771,4958,5003, 
6, // chain 199
5014,4969,5014, 5016,4971,5016, 5017,4972,5017, 
5018,4973,5018, 37787,4974,5019, 5020,4975,5020, 37779,4966,5011, 37778,4965,5010, 
4, // chain 200
5013,4968,5013, 5014,4969,5014, 5018,4973,5018, 
5020,4975,5020, 5012,4967,5012, 37779,4966,5011, 
3, // chain 201
5021,4976,5021, 5017,4972,5017, 5016,4971,5016, 
5022,4977,5022, 5023,4978,5023, 
6, // chain 202
5024,4979,5024, 5025,4980,5025, 5026,4981,5026, 
5027,4982,5027, 5028,4983,5028, 37797,4984,5029, 5030,4985,5030, 5031,4986,5031, 
10, // chain 203
5032,4987,5032, 5033,4988,5033, 5034,4989,5034, 
5035,4990,5035, 37804,4991,5036, 37805,4992,5037, 4987,4942,4987, 5038,4993,5038, 37754,4941,4986, 5025,4980,5025, 37758,4945,4990, 5026,4981,5026, 
2, // chain 204
5039,4994,5039, 5040,4995,5040, 5033,4988,5033, 
5032,4987,5032, 
2, // chain 205
5041,4996,5041, 5042,4997,5042, 5043,4998,5043, 
5044,4999,5044, 
2, // chain 206
5006,4961,5006, 5043,4998,5043, 5042,4997,5042, 
5005,4960,5005, 
1, // chain 207
5045,5000,5045, 5046,5001,5046, 5047,5002,5047, 
1, // chain 208
5048,5003,5048, 5049,5004,5049, 5050,5005,5050, 
1, // chain 209
5051,5006,5051, 5052,5007,5052, 5053,5008,5053, 
1, // chain 210
5054,5009,5054, 5055,5010,5055, 5056,5011,5056, 
1, // chain 211
5057,5012,5057, 5058,5013,5058, 5059,5014,5059, 
1, // chain 212
5060,5015,5060, 5061,5016,5061, 5062,5017,5062, 
1, // chain 213
5063,5018,5063, 5064,5019,5064, 5065,5020,5065, 
1, // chain 214
5066,5021,5066, 5067,5022,5067, 5068,5023,5068, 
1, // chain 215
5069,5024,5069, 5070,5025,5070, 5071,5026,5071, 
1, // chain 216
5072,5027,5072, 5073,5028,5073, 5074,5029,5074, 
1, // chain 217
5075,5030,5075, 5076,5031,5076, 5077,5032,5077, 
1, // chain 218
5078,5033,5078, 5079,5034,5079, 5080,5035,5080, 
1, // chain 219
5081,5036,5081, 5082,5037,5082, 5083,5038,5083, 
1, // chain 220
5084,5039,5084, 5085,5040,5085, 5086,5041,5086, 
1, // chain 221
5087,5042,5087, 5088,5043,5088, 5089,5044,5089, 
1, // chain 222
5090,5045,5090, 5091,5046,5091, 5092,5047,5092, 
1, // chain 223
5093,5048,5093, 5094,5049,5094, 5095,5050,5095, 
1, // chain 224
5096,5051,5096, 5097,5052,5097, 5098,5053,5098, 
1, // chain 225
5099,5054,5099, 5100,5055,5100, 5101,5056,5101, 
1, // chain 226
5102,5057,5102, 5103,5058,5103, 5104,5059,5104, 
1, // chain 227
5105,5060,5105, 5106,5061,5106, 5107,5062,5107, 
1, // chain 228
5108,5063,5108, 5109,5064,5109, 5110,5065,5110, 
1, // chain 229
5111,5066,5111, 5112,5067,5112, 5113,5068,5113, 
1, // chain 230
5114,5069,5114, 5115,5070,5115, 5116,5071,5116, 
1, // chain 231
5117,5072,5117, 5118,5073,5118, 5119,5074,5119, 
1, // chain 232
5120,5075,5120, 5121,5076,5121, 5122,5077,5122, 
1, // chain 233
5123,5078,5123, 5124,5079,5124, 5125,5080,5125, 
1, // chain 234
5126,5081,5126, 5127,5082,5127, 5128,5083,5128, 
1, // chain 235
5129,5084,5129, 5130,5085,5130, 5131,5086,5131, 
1, // chain 236
5132,5087,5132, 5133,5088,5133, 5134,5089,5134, 
1, // chain 237
5135,5090,5135, 5136,5091,5136, 5137,5092,5137, 
1, // chain 238
5138,5093,5138, 5139,5094,5139, 5140,5095,5140, 
1, // chain 239
5141,5096,5141, 5142,5097,5142, 5143,5098,5143, 
1, // chain 240
5144,5099,5144, 5145,5100,5145, 5146,5101,5146, 
1, // chain 241
5147,5102,5147, 5148,5103,5148, 5149,5104,5149, 
1, // chain 242
5150,5105,5150, 5151,5106,5151, 5152,5107,5152, 
1, // chain 243
5153,5108,5153, 5154,5109,5154, 5155,5110,5155, 
1, // chain 244
5156,5111,5156, 5157,5112,5157, 5158,5113,5158, 
1, // chain 245
5159,5114,5159, 5160,5115,5160, 5161,5116,5161, 
1, // chain 246
5162,5117,5162, 5163,5118,5163, 5164,5119,5164, 
1, // chain 247
5165,5120,5165, 5166,5121,5166, 5167,5122,5167, 
1, // chain 248
5168,5123,5168, 5169,5124,5169, 5170,5125,5170, 
1, // chain 249
5171,5126,5171, 5172,5127,5172, 5173,5128,5173, 
1, // chain 250
5174,5129,5174, 5175,5130,5175, 5176,5131,5176, 
1, // chain 251
5177,5132,5177, 5178,5133,5178, 5179,5134,5179, 
1, // chain 252
5180,5135,5180, 5181,5136,5181, 5182,5137,5182, 
1, // chain 253
5183,5138,5183, 5184,5139,5184, 5185,5140,5185, 
1, // chain 254
5186,5141,5186, 5187,5142,5187, 5188,5143,5188, 
1, // chain 255
5189,5144,5189, 5190,5145,5190, 5191,5146,5191, 
1, // chain 256
5192,5147,5192, 5193,5148,5193, 5194,5149,5194, 
1, // chain 257
5195,5150,5195, 5196,5151,5196, 5197,5152,5197, 
1, // chain 258
5198,5153,5198, 5199,5154,5199, 5200,5155,5200, 
1, // chain 259
5201,5156,5201, 5202,5157,5202, 5203,5158,5203, 
1, // chain 260
5204,5159,5204, 5205,5160,5205, 5206,5161,5206, 
1, // chain 261
5207,5162,5207, 5208,5163,5208, 5209,5164,5209, 
1, // chain 262
5210,5165,5210, 5211,5166,5211, 5212,5167,5212, 
1, // chain 263
5213,5168,5213, 5214,5169,5214, 5215,5170,5215, 
1, // chain 264
5216,5171,5216, 5217,5172,5217, 5218,5173,5218, 
1, // chain 265
5219,5174,5219, 5220,5175,5220, 5221,5176,5221, 
1, // chain 266
5222,5177,5222, 5223,5178,5223, 5224,5179,5224, 
1, // chain 267
5225,5180,5225, 5226,5181,5226, 5227,5182,5227, 
1, // chain 268
5228,5183,5228, 5229,5184,5229, 5230,5185,5230, 
1, // chain 269
5231,5186,5231, 5232,5187,5232, 5233,5188,5233, 
1, // chain 270
5234,5189,5234, 5235,5190,5235, 5236,5191,5236, 
2, // chain 271
5237,5192,5237, 5238,5193,5238, 5014,4969,5014, 
5015,4970,5015, 
2, // chain 272
5239,5194,5239, 5240,5195,5240, 5003,4958,5003, 
5004,4959,5004, 
17, // chain 273
5241,5196,5241, 5242,5197,5242, 5243,5198,5243, 
5244,5199,5244, 38013,5200,5245, 38014,5201,5246, 38015,5202,5247, 38016,5203,5248, 38010,5197,5242, 5249,5204,5249, 38018,5205,5250, 38019,5206,5251, 38009,5196,5241, 5252,5207,5252, 38021,5208,5253, 38012,5199,5244, 5254,5209,5254, 38023,5210,5255, 38013,5200,5245, 
19, // chain 274
5256,5211,5256, 5257,5212,5257, 5258,5213,5258, 
5259,5214,5259, 38028,5215,5260, 38029,5216,5261, 38030,5217,5262, 38025,5212,5257, 5263,5218,5263, 38032,5219,5264, 38033,5220,5265, 38024,5211,5256, 5266,5221,5266, 38035,5222,5267, 38036,5223,5268, 38027,5214,5259, 5269,5224,5269, 38028,5215,5260, 5270,5225,5270, 
38039,5226,5271, 38029,5216,5261, 
8, // chain 275
5267,5222,5267, 5268,5223,5268, 5272,5227,5272, 
5273,5228,5273, 38042,5229,5274, 38043,5230,5275, 38044,5231,5276, 38045,5232,5277, 38037,5224,5269, 38036,5223,5268, 
7, // chain 276
5253,5208,5253, 5254,5209,5254, 5278,5233,5278, 
5267,5222,5267, 38034,5221,5266, 38047,5234,5279, 38048,5235,5280, 38022,5209,5254, 5255,5210,5255, 
1, // chain 277
5269,5224,5269, 5270,5225,5270, 5277,5232,5277, 
8, // chain 278
5281,5236,5281, 5282,5237,5282, 5250,5205,5250, 
5251,5206,5251, 5283,5238,5283, 38020,5207,5252, 5284,5239,5284, 38053,5240,5285, 38035,5222,5267, 38021,5208,5253, 
8, // chain 279
5250,5205,5250, 5282,5237,5282, 5249,5204,5249, 
38054,5241,5286, 38055,5242,5287, 38049,5236,5281, 5288,5243,5288, 38051,5238,5283, 5289,5244,5289, 5287,5242,5287, 
4, // chain 280
5290,5245,5290, 5247,5202,5247, 5248,5203,5248, 
5249,5204,5249, 5291,5246,5291, 38054,5241,5286, 
7, // chain 281
5267,5222,5267, 5273,5228,5273, 5285,5240,5285, 
38052,5239,5284, 38042,5229,5274, 5283,5238,5283, 38060,5247,5292, 38043,5230,5275, 5293,5244,5293, 
1, // chain 282
5294,5248,5294, 5283,5238,5283, 5292,5247,5292, 
1, // chain 283
5290,5245,5290, 5291,5246,5291, 5295,5249,5295, 
5, // chain 284
5296,5250,5296, 5297,5251,5297, 5264,5219,5264, 
5265,5220,5265, 5298,5252,5298, 38034,5221,5266, 5279,5234,5279, 
2, // chain 285
5299,5253,5299, 5246,5201,5246, 5247,5202,5247, 
5290,5245,5290, 
1, // chain 286
5300,5254,5300, 5301,5255,5301, 5302,5256,5302, 
1, // chain 287
5303,5257,5303, 5304,5258,5304, 5305,5259,5305, 

 0};


// mesh info for object elementalist_7 (with tag [ | g SUN_Online_-_ver_0_7_5_4_(_Protocol_ver___2_5_3_)-23e2c670.obj | usemtl Material__51])
const tgx::Mesh3D<tgx::RGB565> elementalist_7 = 
    {
    1, // version/id
    
    5306, // number of vertices
    5260, // number of texture coords
    5306, // number of normal vectors
    1214, // number of triangles
    5659,
    
    elementalist_vert_array, // array of vertices
    elementalist_tex_array, // array of texture coords
    elementalist_norm_array, // array of normal vectors        
    elementalist_7_face, // array of face vertex indexes   
    
    &elementalist_weapon_texture, // pointer to texture image 
    
    { 0.75f , 0.75f, 0.75f }, // default color
    
    0.1f, // ambiant light strength 
    0.7f, // diffuse light strength
    0.6f, // specular light strength
    32, // specular exponent
    
    nullptr, // next mesh to draw after this one    
    
    { // mesh bounding box
    -0.4964377514688473, -0.36648243284900806, 
    -1.0, 0.8664667330565432, 
    0.02161907261211315, 0.3199721987616645
    },

    "elementalist"    
    };
    

// mesh info for object elementalist_6 (with tag [ | g SUN_Online_-_ver_0_7_5_4_(_Protocol_ver___2_5_3_)-23e1a310.obj | usemtl Material__49])
const tgx::Mesh3D<tgx::RGB565> elementalist_6 = 
    {
    1, // version/id
    
    5306, // number of vertices
    5260, // number of texture coords
    5306, // number of normal vectors
    769, // number of triangles
    3029,
    
    elementalist_vert_array, // array of vertices
    elementalist_tex_array, // array of texture coords
    elementalist_norm_array, // array of normal vectors        
    elementalist_6_face, // array of face vertex indexes   
    
    &elementalist_body_texture, // pointer to texture image 
    
    { 0.75f , 0.75f, 0.75f }, // default color
    
    0.1f, // ambiant light strength 
    0.7f, // diffuse light strength
    0.6f, // specular light strength
    32, // specular exponent
    
    nullptr, // stop here: do not draw the weapon directly
    
    { // mesh bounding box
    -0.14162496289921306, 0.3995319857487139, 
    -0.683055340049483, 0.5340627052002983, 
    -0.3199721987616645, 0.1916991644730886
    },

    "elementalist"    
    };
    

// mesh info for object elementalist_5 (with tag [ | g SUN_Online_-_ver_0_7_5_4_(_Protocol_ver___2_5_3_)-23e0b828.obj | usemtl Material__49])
const tgx::Mesh3D<tgx::RGB565> elementalist_5 = 
    {
    1, // version/id
    
    5306, // number of vertices
    5260, // number of texture coords
    5306, // number of normal vectors
    540, // number of triangles
    2286, 
    
    elementalist_vert_array, // array of vertices
    elementalist_tex_array, // array of texture coords
    elementalist_norm_array, // array of normal vectors        
    elementalist_5_face, // array of face vertex indexes   
    
    &elementalist_body_texture, // pointer to texture image 
    
    { 0.75f , 0.75f, 0.75f }, // default color
    
    0.1f, // ambiant light strength 
    0.7f, // diffuse light strength
    0.6f, // specular light strength
    32, // specular exponent
    
    &elementalist_6, // next mesh to draw after this one    
    
    { // mesh bounding box
    -0.24991846421650588, 0.4964377514688473, 
    -0.035994008867517815, 0.4512331212906375, 
    -0.06286918864160121, 0.16142148442110738
    },

    "elementalist"    
    };
    

// mesh info for object elementalist_4 (with tag [ | g SUN_Online_-_ver_0_7_5_4_(_Protocol_ver___2_5_3_)-23df9290.obj | usemtl Material__49])
const tgx::Mesh3D<tgx::RGB565> elementalist_4 = 
    {
    1, // version/id
    
    5306, // number of vertices
    5260, // number of texture coords
    5306, // number of normal vectors
    876, // number of triangles
    3490, 
    
    elementalist_vert_array, // array of vertices
    elementalist_tex_array, // array of texture coords
    elementalist_norm_array, // array of normal vectors        
    elementalist_4_face, // array of face vertex indexes   
    
    &elementalist_body_texture, // pointer to texture image 
    
    { 0.75f , 0.75f, 0.75f }, // default color
    
    0.1f, // ambiant light strength 
    0.7f, // diffuse light strength
    0.6f, // specular light strength
    32, // specular exponent
    
    &elementalist_5, // next mesh to draw after this one    
    
    { // mesh bounding box
    -0.20459419474389282, 0.4475605158241302, 
    0.21305718506159016, 0.802001780837773, 
    -0.10615798575100582, 0.19640681027201895
    },

    "elementalist"  
    };
    

// mesh info for object elementalist_3 (with tag [ | g SUN_Online_-_ver_0_7_5_4_(_Protocol_ver___2_5_3_)-23deaf70.obj | usemtl Material__49])
const tgx::Mesh3D<tgx::RGB565> elementalist_3 = 
    {
    1, // version/id
    
    5306, // number of vertices
    5260, // number of texture coords
    5306, // number of normal vectors
    528, // number of triangles
    2110,
    
    elementalist_vert_array, // array of vertices
    elementalist_tex_array, // array of texture coords
    elementalist_norm_array, // array of normal vectors        
    elementalist_3_face, // array of face vertex indexes   
    
    &elementalist_face_texture, // pointer to texture image 
    
    { 0.75f , 0.75f, 0.75f }, // default color
    
    0.1f, // ambiant light strength 
    0.7f, // diffuse light strength
    0.6f, // specular light strength
    32, // specular exponent
    
    &elementalist_4, // next mesh to draw after this one    
    
    { // mesh bounding box
    -0.13183287628219748, 0.40465882746615656, 
    -0.9233478833356441, -0.17708586640507984, 
    -0.13178738126315714, 0.1775445982973174
    },

    "elementalist"    
    };
    

// mesh info for object elementalist_2 (with tag [ | g SUN_Online_-_ver_0_7_5_4_(_Protocol_ver___2_5_3_)-23dce8f8.obj | usemtl Material__46])
const tgx::Mesh3D<tgx::RGB565> elementalist_2 = 
    {
    1, // version/id
    
    5306, // number of vertices
    5260, // number of texture coords
    5306, // number of normal vectors
    1352, // number of triangles
    5828, 
    
    elementalist_vert_array, // array of vertices
    elementalist_tex_array, // array of texture coords
    elementalist_norm_array, // array of normal vectors        
    elementalist_2_face, // array of face vertex indexes   
    
    &elementalist_face_texture, // pointer to texture image 
    
    { 0.75f , 0.75f, 0.75f }, // default color
    
    0.1f, // ambiant light strength 
    0.7f, // diffuse light strength
    0.6f, // specular light strength
    32, // specular exponent
    
    &elementalist_3, // next mesh to draw after this one    
    
    { // mesh bounding box
    0.027809260127225593, 0.2000038962988598, 
    0.7299076462573183, 0.9867677106837661, 
    -0.035130520281954486, 0.15356081606833646
    },

    "elementalist"    
    };
    

// mesh info for object elementalist_1 (with tag [ | g SUN_Online_-_ver_0_7_5_4_(_Protocol_ver___2_5_3_)-23db2a48.obj | usemtl Material__45])
const tgx::Mesh3D<tgx::RGB565> elementalist_1 = 
    {
    1, // version/id
    
    5306, // number of vertices
    5260, // number of texture coords
    5306, // number of normal vectors
    948, // number of triangles
    3839, 
    
    elementalist_vert_array, // array of vertices
    elementalist_tex_array, // array of texture coords
    elementalist_norm_array, // array of normal vectors        
    elementalist_1_face, // array of face vertex indexes   
    
    &elementalist_hair_texture, // pointer to texture image 
    
    { 0.75f , 0.75f, 0.75f }, // default color
    
    0.1f, // ambiant light strength 
    0.7f, // diffuse light strength
    0.6f, // specular light strength
    32, // specular exponent
    
    &elementalist_2, // next mesh to draw after this one    
    
    { // mesh bounding box
    0.011201859222138288, 0.21976088184702897, 
    0.6776206907221102, 1.0, 
    -0.08171168992795284, 0.1526399143731027
    },
    
    "elementalist"
    };
    
                
/** end of elementalist.h */
    
    
    