// 3D model [R2D2]
//
// - vertices   : 4397
// - textures   : 8227
// - normals    : 5314
// - triangles  : 8035
//
// - memory size: 250kb
//
// - model bounding box: [-0.59,0.59]x[-1.0,1.0]x[-0.47,0.47]
//
// object [R2D2] (tagged [ | o Merged_Meshes | usemtl R2D2_IlluminationMaterial]) with 8035 triangles (1823 chains)

#pragma once

#include <tgx.h>

#include "R2D2_texture.h" // texture for object [R2D2]


// vertex array: 51kb.
const tgx::fVec3 R2D2_vert_array[4397] PROGMEM = {
{0.3921046505631816,-0.5014293895643546,0.12638590947256034},
{0.37129891780685226,-0.5014240505322893,0.18482990350489217},
{0.3913963762465933,-0.5014293895643546,-0.10157411367228346},
{0.26965466295022517,-0.5014294454704495,0.22199656891716585},
{0.31925491375614823,-0.5014298088600666,0.27138759116283695},
{0.26500046657130344,-0.5014294454704495,0.23447339767523873},
{0.20503591061618937,-0.5014565739030112,0.2939994262217713},
{0.25164505955498095,-0.5014291240104037,0.3376649794975928},
{0.19197733701086422,-0.5014294454704495,0.30131054578541805},
{0.11767107871278368,-0.5014565739030112,0.34153112356247},
{0.15518520050500814,-0.5014310387941548,0.39616015555982725},
{0.1030810554726899,-0.5014294454704495,0.34486560066462285},
{0.02045267179036242,-0.5014566298091062,0.3625245051264107},
{0.025557219716941984,-0.5014372303941677,0.4261310077292343},
{0.005513738611849837,-0.5014294454704495,0.3616136550748664},
{-0.07874208547023027,-0.5014493340637186,0.3552800116513893},
{-0.11272735864477589,-0.5014357908122234,0.4124088287771649},
{-0.09281809409707183,-0.5014294454704495,0.35019342355780403},
{-0.17187532222438698,-0.5014592993251389,0.32037677437472023},
{-0.22570312204582152,-0.5014294454704495,0.3618117583222285},
{-0.1839506194321941,-0.5014294454704495,0.31153438687111334},
{-0.2514264667238293,-0.5014686775725623,0.26061826033244745},
{-0.2958799185719342,-0.5014294454704495,0.3048007353384572},
{-0.3511970567621361,-0.5014294454704495,0.23711609275880574},
{-0.2558472551564446,-0.5014294454704495,0.24702992057162532},
{-0.2558472551564446,-0.5014293336582597,-0.21914165429726848},
{-0.32714323579683474,-0.5014294454704495,-0.24349250434489939},
{-0.39956213228333864,-0.5014293895643546,0.13360850173489544},
{-0.3997671539099476,-0.5014293895643546,-0.0999041287342939},
{-0.37918533904031143,-0.5014115275670264,-0.15693414581381557},
{0.3926184415520541,-0.3431690184019735,-0.09826627582436173},
{0.3859103251282544,0.4306884725874142,-0.12299971923260304},
{0.39758532071988406,0.4287893565193798,-0.08226569987977184},
{0.40598785304515506,-0.23182725039031024,-0.02192865559070487},
{0.40604314417303455,0.0323214029656882,-0.02293367945914821},
{0.4083541064658481,0.4287893565193798,-0.007538971841770163},
{0.4076695782630786,0.03390509684616316,0.0073076743505471236},
{0.40214938249726506,0.034259765112359036,0.08428701269478568},
{0.40507765989022604,0.43037198818405115,0.07276982603260185},
{0.38343701153578247,0.4287893565193798,0.156291798759666},
{0.3926968917797558,0.03390509684616316,0.12338862998193979},
{0.37942693722952414,0.03328460907512864,0.163913267032758},
{0.36309707438583366,0.38277543977324086,0.203446689020579},
{0.3447839707777724,0.43014582007703733,0.23953426896515914},
{0.2941053333303424,0.38352793581091393,0.29753080459024545},
{0.2780706965974202,0.4287639751522844,0.3127469760934847},
{0.36138242047800007,0.38310514596805334,-0.17551220238224396},
{0.354241115677684,0.4303707023438678,-0.19454956945004176},
{0.37798715961390666,-0.26624621509622654,-0.1395345338202838},
{0.3777648070978714,-0.4780500197282128,-0.1398199344348693},
{0.39139363684794204,-0.3431690184019735,0.12945351883059492},
{0.37898519522048457,-0.2308807741797758,0.1647887145496919},
{0.3891259039430282,-0.23244768225524978,0.13627659216208152},
{0.40433366157898143,-0.3431690184019735,0.07153504209054583},
{0.4054252560354141,-0.23279178426950514,0.060529438126485036},
{0.40759759916586435,-0.23244779406743957,0.020628894789823816},
{0.4076938415082755,-0.3431690184019735,-0.009132365429714252},
{0.32942713953970515,0.38307059600139054,-0.22810082963317102},
{0.3084838638133398,0.43036996158811014,-0.2583755593815357},
{0.2942122677134077,0.3831052577802433,-0.26974550336621433},
{0.25116446280996935,0.43037209999624093,-0.3126855352951635},
{0.26506341683418755,0.3940322997044125,-0.2974703840781566},
{0.26522666263136474,-0.26601908260907525,-0.2969551395308161},
{0.2947925310491445,-0.23339543032944374,-0.26942857171409185},
{0.3307628200065747,-0.26509548596788823,-0.22994253014171862},
{0.3333889249564731,-0.23339266297774505,-0.2223696023355442},
{0.3613465147885353,-0.2333833266598928,-0.1757646743069194},
{0.20811938332865854,0.39409596277000686,-0.33943917339652013},
{0.18474335388168842,0.43037209999624093,-0.35505907076425086},
{0.13210789129973907,0.3941215537849583,-0.3749378245606502},
{0.1284307797183226,0.43163813544535923,-0.37622618051816686},
{0.06894061493168355,0.4287894543550459,-0.39353449785868827},
{0.05556333465572212,0.3941172909452202,-0.39368913411724726},
{-0.026696320377536106,0.4287894543550459,-0.4001280347409419},
{-0.022875320484309764,0.39411952718901727,-0.3975719941045066},
{-0.1260991181938636,0.39400436063347444,-0.3805120954967787},
{-0.12202237586940881,0.43037209999624093,-0.3833249407802461},
{-0.17813353434928825,0.43116340884031473,-0.35945488314895885},
{-0.22360630804961323,0.3940324115166025,-0.33440988905023156},
{-0.24178003776302973,0.43037209999624093,-0.32250552472765365},
{-0.2730663463694677,0.3940324115166025,-0.29740515564190434},
{-0.30231491974550795,0.38297196367342135,-0.26952078881766856},
{-0.29226686139877656,0.43037198818405115,-0.2842203041446703},
{-0.2732051751796869,-0.5013304357763396,-0.29719704520355095},
{-0.3024628472726761,-0.23323697847990627,-0.2696333277867499},
{-0.2974899861526893,-0.38938489591602427,-0.2761792047230811},
{-0.29785368325321543,-0.43347687293087633,-0.2764118439605823},
{-0.32576988859851036,-0.477239339422248,-0.24290477754549025},
{-0.3519343323654661,-0.4772758181491857,-0.20622087523940652},
{-0.3744660120608036,-0.43347687293087633,-0.16882755254178844},
{-0.3746284332430807,-0.39050219319959817,-0.16761384519751865},
{-0.39936843164095176,-0.3431690184019735,-0.10125131188019401},
{-0.3999893247311744,-0.3431690184019735,0.1274354066395155},
{-0.3873177191383873,-0.23182761377992722,0.16391919307881989},
{-0.40057983285880594,-0.23244768225524978,0.12338717642347177},
{-0.40985164905404553,-0.232791896081695,0.08457919192338066},
{-0.41557634931508997,-0.3431690184019735,0.037036215528031095},
{-0.41547954791172953,-0.23244768225524978,0.007259874639387361},
{-0.4118179502716544,-0.3431690184019735,-0.04637690803221663},
{-0.4137396384255142,-0.23086387656258506,-0.02292456676567565},
{-0.4140329497525314,0.03328493053517443,-0.021941863405630587},
{-0.41036327368173975,0.4287893565193798,-0.05804309841389585},
{-0.41588437792159577,0.4287893565193798,0.01993241665926437},
{-0.41534765145728086,0.03390509684616316,0.02068000693710781},
{-0.41336428490419647,0.034256452676234825,0.060797941123879824},
{-0.4039220948846769,0.4287893565193798,0.11540567289907117},
{-0.39700869128031735,0.03390509684616316,0.13627685771603243},
{-0.37944629471489155,0.43037198818405115,0.18740917312376823},
{-0.3869423236874984,0.0323214029656882,0.1648410845841117},
{-0.3698292024774032,0.383660279514122,0.20281823463101795},
{-0.369651826414734,-0.2337749907844045,0.20299187896185097},
{-0.34161566056625653,0.38292951697085065,-0.22192765067864864},
{-0.3471648296657643,0.4287864773554912,-0.2178911747190626},
{-0.36914173920465015,0.3829593848020637,-0.17561961196711612},
{-0.39321881710543977,0.4287894543550459,-0.12193272345793676},
{-0.369275760090706,-0.23324864887722163,-0.17566337246291766},
{-0.3384575811701117,-0.23322578328439775,-0.226778832183034},
{-0.35192424131533234,-0.34496300305850375,-0.20617510212418771},
{-0.3258150746997324,-0.34492680386204067,-0.2429010597901779},
{-0.3038906470074561,0.3831403388548079,0.2991826899300034},
{-0.34074412647596725,0.43037198818405115,0.2554596512120767},
{-0.2875017892570974,0.429982783927716,0.31494816676891546},
{-0.30217815946080084,-0.23394885873961715,0.29782528994525603},
{-0.28604233269606677,0.14628553021889,0.313063809909941},
{-0.24279136504367574,0.374160925512543,0.349856211969748},
{-0.24406869352396868,0.4287893565193798,0.3514797109898084},
{-0.28498664392909884,0.2556135047853067,0.3145603741414772},
{-0.24284209982481897,0.1490128811066952,0.34943322645555525},
{-0.1754044783255879,0.14652076908980513,0.3882166542034511},
{-0.2361339694244955,0.17495674737612948,0.3543535917524086},
{-0.1609944168050535,0.1675279874122396,0.39507346686322414},
{-0.04941005827099264,0.16561479698480816,0.42554290356368446},
{-0.07937346095325107,0.14638118554730445,0.41779848381133156},
{0.001407743423226201,0.14638001151931104,0.4246055260700988},
{0.046251112330376445,0.16611585536056175,0.422569565858215},
{0.08079142121532457,0.14626921961569606,0.4160648358077476},
{0.04627734626541939,0.18007521592034506,0.42268569679389517},
{0.10625165783409768,0.1762336705372343,0.4110226930596267},
{0.16735145692925613,0.14926068487244448,0.38997367095471314},
{0.18997357870965645,0.14567261772371776,0.37776161346219883},
{0.2768953687873155,0.14645070477634212,0.3142675240397431},
{0.23824063686993405,0.4304652954564788,0.34728882239604314},
{0.23912483369072354,0.37409705279909267,0.34743314398008873},
{0.2766420163416451,0.2558419231126411,0.31471464701041924},
{0.22876774042777764,0.3325007098851109,0.3531468027873857},
{0.1813899665429276,0.33269615759296406,0.38185659515012255},
{0.14931179003146666,0.37409919120722346,0.39672687564406883},
{0.14722755490661626,0.34692934620568366,0.3969281236092704},
{0.04100178159446823,0.3470350227016131,0.42562863556024993},
{0.02985786595156621,0.37409919120722346,0.4266927242179802},
{-0.05400844639065675,0.3387042598257005,0.42251624542018146},
{-0.11904508280772348,0.37409481655529575,0.41212715989441556},
{-0.11424866132331588,0.33773859384808347,0.4109949915895919},
{-0.15014929128647117,0.34798021307196436,0.4004377405302955},
{-0.23832627103083345,0.336904726489249,0.3521530719501169},
{-0.23667069588881046,0.2871673240559544,0.3558498764534703},
{-0.19107520831012798,0.2559904516303296,0.38017246597011733},
{-0.24284209982481897,0.25320500033337506,0.34943325440860273},
{-0.2362686472071667,0.22072765430415872,0.35438994469063284},
{-0.1619703135980416,0.2319578610045755,0.3948149151507258},
{-0.12238671589002656,0.2539297809244896,0.40885485036981783},
{-0.043923434115180786,0.23446520743233232,0.42573775028101724},
{-0.08668214860176868,0.25621534787368394,0.41819091664464847},
{0.005407139665354073,0.25605710567200235,0.4249240929754978},
{0.04700780132516871,0.22596000356373394,0.4225408860315191},
{0.0897512394713187,0.2559216731570498,0.41504846300203474},
{0.11538608480106224,0.225577074766554,0.4088663111192771},
{0.16966050443831848,0.2556171386814767,0.3878520765819299},
{0.22877347080250734,0.2239822835262369,0.35593128970420296},
{0.23495794278820428,0.2538926732539839,0.34943325440860273},
{0.22967480284139094,0.17724530530140226,0.3528281100932732},
{0.1415631773219945,0.16699632044951507,0.40069987023286896},
{0.4077664775021051,0.43353715367772755,-0.04171231311963911},
{0.4079627638013822,0.43353715367772755,0.014266166220462671},
{0.03903262916601824,0.4335372654899173,-0.39928062413061216},
{-0.03994909778010246,0.4335372654899173,-0.39994594858977545},
{-0.3275209233976155,0.43353694402987153,-0.2409312923946837},
{-0.37394078827551913,0.4311631991924587,-0.17680338159755424},
{-0.3979882638990467,0.43353715367772755,-0.10635679623386354},
{-0.41465213770685877,0.43353715367772755,-0.04865207644775523},
{-0.4199170103371558,0.43037198818405115,0.039289273083027376},
{-0.4084948360832948,0.43353715367772755,0.10848950194301286},
{-0.38629713939903143,0.43353715367772755,0.1670158736062148},
{-0.3700144752759803,0.43353715367772755,0.20266858799143095},
{-0.35041800532937434,0.43353715367772755,0.23661198750087875},
{-0.32768239417627887,0.43353715367772755,0.26853714903053355},
{-0.30201589202028484,0.43353715367772755,0.2981589934258556},
{-0.2736505510848966,0.43353715367772755,0.3252049784740919},
{-0.24284209982481897,0.43353715367772755,0.34943326838512645},
{-0.2120840059797439,0.42997627086765755,0.3744456412774658},
{-0.09468734233389317,0.4301457082648474,0.4198496924106058},
{-0.16160186447944694,0.4335370558420615,0.3983194446171128},
{-0.1523277002282206,0.4284915307751975,0.37960548033192487},
{0.04134259912564684,0.4287892447071901,0.42879663828824377},
{-0.0074405841029663465,0.4335370558420615,0.42938292550570856},
{0.054359452807635184,0.4335370558420615,0.4217016097580008},
{0.10973417427560848,0.4335370558420615,0.41354289788921583},
{0.16872708230094868,0.42997617303199126,0.392029939055578},
{0.0892815723678647,0.4284408798531966,0.39809971968753893},
{0.3911860714940141,0.43353715367772755,0.13030134873663654},
{0.38251478459392113,0.43116331100464866,0.16865492849718783},
{0.37841298236241677,0.43353715367772755,0.1670172712585879},
{0.3621317298682624,0.43353715367772755,0.20266858799143095},
{0.34253386226928334,0.43353715367772755,0.23661198750087875},
{0.31979964876856104,0.43353715367772755,0.26853854668290655},
{0.2827799884328892,0.4308241147502228,0.31465225580848427},
{0.2941331466125669,0.43353715367772755,0.2981589934258556},
{0.2657663800717581,0.43353715367772755,0.3252049784740919},
{0.4060501464114238,0.43353715367772755,0.05309462632781957},
{0.4004721297669354,0.43353715367772755,0.09188926324774763},
{0.4060501464114238,0.43353715367772755,-0.025206052569940626},
{0.4004721297669354,0.43353715367772755,-0.06400068948986869},
{0.39123224992842104,0.43353715367772755,-0.10208951196138503},
{0.37841298236241677,0.43353715367772755,-0.13912729984833586},
{0.3621317298682624,0.43353715367772755,-0.174780014233552},
{0.3425352459451327,0.43353715367772755,-0.20872339976647605},
{0.31979964876856104,0.43353715367772755,-0.24064856129613083},
{0.2941331466125669,0.43353715367772755,-0.2702704056914529},
{0.2657678056771787,0.43353715367772755,-0.2973163907396893},
{0.2349593544171011,0.4335372654899173,-0.3215446806507238},
{0.20198732330695257,0.4335372654899173,-0.34273448827917885},
{0.16714944025524933,0.4335372654899173,-0.36069432127341733},
{0.20198592565457948,0.4335370558420615,0.3706230760135816},
{0.16714944025524933,0.4335370558420615,0.38858290900781994},
{0.13076295837415966,0.4335370558420615,0.4031492420401898},
{0.09315772362373329,0.4335370558420615,0.4141920934399936},
{0.0156551042310089,0.4335370558420615,0.4253341781582868},
{-0.023539261267623613,0.4335370558420615,0.4253341781582868},
{-0.06255472726250029,0.4335370558420615,0.42160944856051913},
{-0.1010404830079749,0.4335370558420615,0.4141920934399936},
{-0.13864711541077435,0.4335370558420615,0.4031492420401898},
{-0.17503359729186407,0.4335370558420615,0.38858290900781994},
{-0.2098700826911942,0.4335370558420615,0.3706230760135816},
{-0.39911499533613887,0.43353715367772755,0.129978085719264},
{-0.40835630078007384,0.43353715367772755,0.09188926324774763},
{-0.41393431742456227,0.43353715367772755,0.05309462632781957},
{-0.4157987856902676,0.43353715367772755,0.013944985705126018},
{-0.41393431742456227,0.43353715367772755,-0.02520465491756753},
{-0.40835630078007384,0.43353715367772755,-0.06400068948986869},
{-0.38629713939903143,0.43353715367772755,-0.13912729984833586},
{-0.3700144752759803,0.43353715367772755,-0.174780014233552},
{-0.35041800532937434,0.43353715367772755,-0.20872198813757922},
{-0.30201730364918167,0.43353715367772755,-0.27026902201560354},
{-0.2736505510848966,0.43353715367772755,-0.2973163907396893},
{-0.2098700826911942,0.4335372654899173,-0.34273448827917885},
{-0.13864711541077435,0.4335372654899173,-0.3752606543057872},
{-0.1010404830079749,0.4335372654899173,-0.38630350570559085},
{-0.06255472726250029,0.4335372654899173,-0.3937208608261164},
{-0.023539261267623613,0.4335372654899173,-0.397447002052781},
{0.0156551042310089,0.4335372654899173,-0.397447002052781},
{0.05467196787825866,0.4335372654899173,-0.3937208608261164},
{0.09315772362373329,0.4335372654899173,-0.38630350570559085},
{0.10084430852088763,-0.31218303733746566,-0.38274494299846007},
{0.1014102319432765,-0.27323458877387874,-0.38329825959644365},
{0.2570078377340131,-0.31218303733746566,-0.3048841751851308},
{0.14935729759273456,-0.31218303733746566,-0.36896425831805296},
{0.2567589857289839,-0.27323458877387874,-0.3028449025371227},
{0.15084783794254278,-0.27323458877387874,-0.3682092465061084},
{0.2160248964935341,-0.27323458877387874,-0.33475505328029054},
{0.08496973093773201,-0.3121744976814661,-0.3869897390442556},
{-0.007003775806803753,-0.31217887233339386,-0.3967343391077411},
{0.08471607100853945,-0.27323458877387874,-0.3867865203892079},
{-0.09232899962563185,-0.27323458877387874,-0.38741512852052995},
{-0.09272558348649683,-0.31219444218083015,-0.3879733508783431},
{-0.26489075086001573,-0.31218303733746566,-0.30353415480491325},
{-0.17966770940618443,-0.27323458877387874,-0.35941616817822425},
{-0.10929385787198945,-0.31218303733746566,-0.38329791018335035},
{-0.17103450853325827,-0.31218303733746566,-0.3637976126965369},
{-0.10876616024200464,-0.27323458877387874,-0.38286304462398646},
{-0.2653238973069608,-0.27323458877387874,-0.3040990020349748},
{-0.22732980771329267,-0.31934035923397736,0.35928266442354645},
{-0.22735393119325223,-0.26607715506517726,0.35927669644791344},
{-0.240259657535056,-0.3440819649320775,0.35090125062563293},
{-0.192406136758929,-0.3440974788734188,0.37976286996565883},
{-0.1574896357612393,-0.31934089034187907,0.3955927925554941},
{-0.12105142676582145,-0.34407188785846743,0.408489056790732},
{-0.15739031858360736,-0.26607725290084333,0.3955037620993282},
{-0.12177712980750227,-0.2331010707631468,0.40862068769122994},
{-0.09982079371154828,-0.3194501308513601,0.41411663418837025},
{-0.07180510347033663,-0.34364807772937467,0.42149882437518876},
{-0.1206163934881727,-0.4779836871465858,0.40792590072004187},
{-0.16203274672954762,-0.47801872629157927,0.39434791756330434},
{-0.23513361371497826,-0.47809038392874775,0.35534514225197544},
{-0.28706155671262074,-0.47817728995330655,0.31221381364272105},
{-0.28718775074538727,-0.3439352254094265,0.31272058841668066},
{-0.28712284376918085,-0.00674999707715962,0.31210569125513865},
{-0.216045679584322,-0.006789019531416355,0.36788444607112547},
{-0.20864789159701974,-0.23310421548098623,0.37126751954629084},
{-0.027488887108745665,-0.3194003884034017,0.4250377640430014},
{0.002174551421199661,-0.2659824082108053,0.42684304173070625},
{0.04258396601038012,-0.3194709838247666,0.4227831830469184},
{0.09201933576584945,-0.26604414251612474,0.4140129283822868},
{0.09203148136497162,-0.3193284232827111,0.41398922419803913},
{-0.09977636234260769,-0.2659881665385824,0.4139872255551456},
{0.13211191653857357,-0.3194923679060748,0.4032159939175287},
{0.13131862302813002,-0.2659400733204243,0.402313627615889},
{0.1130061343871129,-0.2330445636777026,0.4079484728058673},
{0.20206121718791797,-0.23288546890807355,0.3712761290849091},
{0.20256154878443763,-0.2659600178197884,0.37106818636484035},
{0.2788593079724139,-0.23302814126231883,0.3123282394425061},
{0.2791661905039738,-0.2659782991128284,0.31229205422256673},
{0.29426008140109117,-0.26593874555066993,0.297250281782442},
{0.2943816771575502,-0.3194806835322358,0.2973455038386208},
{0.27916325543399034,-0.31944043114389076,0.31229939189752554},
{0.2648061928914436,-0.34410803114883565,0.32542485714542685},
{0.2351599315091636,-0.3441164589926454,0.34812528938829157},
{0.21894650708467545,-0.3194325903140777,0.3601472521815415},
{0.21743908309420026,-0.3441128810025703,0.36032054709928124},
{0.18509445813433298,-0.34411335620437716,0.37870374297385306},
{0.16604604961278774,-0.3441143205845145,0.3882436009412043},
{0.11293903309668075,-0.344113468016567,0.4082818688029448},
{0.3314954274509786,-0.31947744097873026,0.2528189268183557},
{0.3314990333941012,-0.2659393325646666,0.2528123438756785},
{0.36131425697176434,-0.2659392207524768,0.20308619254398727},
{0.3614258734902795,-0.31948058569656973,0.20315483125202982},
{0.36162886852094744,-0.23388055546814418,0.20293492462764745},
{0.24457327398370252,-0.21281687198983695,-0.30779164153425637},
{0.19104767455837804,-0.21545298413072664,-0.34654566267622244},
{0.1890577250626164,0.09855068410576234,-0.3485165761466624},
{0.11346772305985045,0.09564474119772322,-0.3752284523951111},
{0.11378451494673558,-0.21303157934739136,-0.3750884775099459},
{0.1142719601883753,-0.21457753661379267,-0.38044203118331565},
{0.11451819858346673,0.09752423422643945,-0.3801193831329872},
{0.24422411246785652,0.09585384396926158,-0.3079518823788315},
{0.2482607002396324,0.09737186216472489,-0.31140397192818003},
{0.24811373709260176,-0.2148151654702659,-0.3115441564612012},
{0.0700361647443321,-0.21282524392755167,-0.38577612953565193},
{0.004189728542295597,-0.21545319377858257,-0.395821658131588},
{-0.01722370346585434,0.09847497327671181,-0.3964306292470681},
{-0.07793530461438636,0.09566222582891075,-0.38581889769826855},
{-0.07756281628043349,-0.21302517809952257,-0.3857674361378913},
{-0.07957655381958514,-0.2145097644502214,-0.39061476012172686},
{-0.07923674259811515,0.09762490712687316,-0.39082987279846954},
{0.0696851303743062,0.09585149591327495,-0.38578062997629325},
{0.07169393420058083,0.09733219679037657,-0.3906142569668725},
{0.07134512209782813,-0.21477554202548868,-0.3907668246999193},
{-0.1213531659366484,-0.2128251880214568,-0.3752378865486295},
{-0.1844779536725619,-0.21545298413072664,-0.3539969807494141},
{-0.20379065825785891,0.09847508508890176,-0.34472543010812534},
{-0.2524176957633502,0.09564718708937611,-0.3077843597653926},
{-0.25199923864284635,-0.2130929362865701,-0.30805709764947786},
{-0.255921666168788,-0.2147203068037041,-0.31167083967229836},
{-0.25587881414702895,0.09761626963520761,-0.3116551440361485},
{-0.12166776350930777,0.09585202702117658,-0.37508157310722284},
{-0.12213460735496813,0.09737409840852176,-0.38038045061975717},
{-0.1224722382387361,-0.21477288648597986,-0.38026581517211616},
{-0.2871606362893493,0.11618490602664136,0.31220893583593895},
{-0.21022444347386807,0.11618490602664136,0.37124184467219706},
{-0.1206366454710588,0.11618501783883112,0.4083509687362705},
{-0.10345941394660979,0.11709811811069618,0.4103025247213433},
{-0.12070267056916369,-0.006768767548530132,0.40843559658746126},
{-0.1209874981462762,-0.038331419982175936,0.40801117149132426},
{-0.20862135017845473,-0.03840362270376993,0.3715592934556976},
{0.11299770654330316,0.11586171289188732,0.40796879467137215},
{0.09438209505560975,-0.23428411361435095,0.4098915869706066},
{-0.004204935000114862,-0.23428767762790226,0.42803016572683983},
{-0.10293683172431052,-0.2342750987565444,0.40996063099783747},
{0.09448466876327101,0.11710600087008038,0.4107235814752611},
{0.19940859877250203,0.11567073767162808,0.372852904586137},
{0.2788741230875687,0.11566465788380519,0.3124131328476478},
{0.29613385803160136,-0.23334462566568187,0.29892275454165573},
{0.1343617874461592,0.09434861429301214,0.40195445890905174},
{0.13480023099559832,-0.21133297048880087,0.4016209091702132},
{0.20968707408946147,-0.21301301852387666,0.36329575765893063},
{0.26312427200218785,-0.20989024382667612,0.32713860257921795},
{0.26290879593582817,0.09275372521702896,0.3272574868900732},
{0.21990486334038123,0.09623003608200315,0.35633985144590535},
{0.21175434171450255,0.13878031867019192,-0.33573535267825383},
{0.24886261321062841,0.13861419370912606,-0.30940200262200984},
{0.24940329503115924,0.27071298629191626,-0.309712197589694},
{0.17398313574477148,0.2701890902763864,-0.35603744140193927},
{0.11132699482607959,0.2710841748091623,-0.3819346959647309},
{0.031646064327271926,0.2705676444216385,-0.39606437444269926},
{-0.047198021813146626,0.2705600691457762,-0.3953038139508335},
{-0.13922157848916283,0.2707512679904154,-0.37634584751435113},
{-0.257234676714166,0.27041878046738027,-0.3102166382841905},
{-0.2568551442122527,0.13862879917642495,-0.3096123772572077},
{-0.17630452452428824,0.13862271938860185,-0.3596358372017032},
{-0.07898263542016322,0.13828575937797305,-0.3918030721223776},
{-0.10104009166531044,-0.22230870662164864,-0.3863037153534469},
{0.03513217273538158,0.1381254905803506,-0.39646728966881434},
{0.0834642776371029,0.13869746583751483,-0.38844522627254663},
{0.09315847835601475,-0.2204720097085967,-0.38630343582297216},
{0.1500835876484121,0.1385367777441805,-0.3678950961822085},
{-0.007415761796820224,0.11710152838248646,0.42621029654835985},
{-0.0868877991719455,0.13983618913196819,-0.3866815007898937},
{-0.17212518053912473,0.2693722882530274,-0.35821154557437956},
{0.22876774042777764,0.2856640231399799,0.3532474337582483},
{-0.12440150166845802,0.28572704328548265,0.40853545884951875},
{-0.053417029788982676,0.28986800773648097,0.42267131495097615},
{-0.05258130355249202,0.27636897796229953,0.4245192070595366},
{0.11448662561635857,0.2755563269664887,0.4104557773040529},
{0.18194895760954596,0.2856837440149641,0.38156004126959986},
{-0.23387337852320825,0.4272778374074515,0.3362979217349474},
{-0.14138230712839261,0.3746031287468657,0.38511007829725474},
{-0.041466431125902856,0.37469856045090044,0.4067274557396863},
{0.05230231816229901,0.37469856045090044,0.4052352661600779},
{0.1426633254109505,0.3746984626152344,0.3802684846881488},
{0.22959192205566656,0.37463362552164664,0.3326841238060319},
{0.17842233125914034,0.4282083104983141,0.36390342895770383},
{0.22914245102900377,0.4279705139235561,0.3314345806549161},
{-0.04160096914333674,0.42832474891751643,0.40849505271941267},
{-0.18535267441026182,-0.5014541839174532,-0.28470851809511527},
{-0.19866420911859298,-0.5014293336582597,-0.35155160622788034},
{-0.1716582668108457,-0.5014293336582597,-0.2907433853707964},
{-0.09386528513761136,-0.5014564760673452,-0.32372030826425074},
{-0.031725241334207635,-0.5014470419138268,-0.40068931795745216},
{-0.07902326517464901,-0.5014293336582597,-0.32565256267005105},
{0.004908415369063482,-0.5014564760673452,-0.3353773579994099},
{0.01969292193687308,-0.5014293336582597,-0.3330489390284565},
{0.10296560938667247,-0.5014564760673452,-0.318733260972677},
{0.14823171223058826,-0.501448747049722,-0.37097696159444854},
{0.11649572294963156,-0.5014293336582597,-0.3123343332068528},
{0.19236093668118318,-0.5014564760673452,-0.2751377021277},
{0.2658619235879827,-0.5015455065235112,-0.2990511568651717},
{0.20354011509345832,-0.5014293336582597,-0.26518732570532405},
{0.26586853448370745,-0.5014663295165754,-0.20809238767307225},
{0.26965466295022517,-0.5014293336582597,-0.19410831661933273},
{0.3609023548408902,-0.5014293336582597,-0.17969979251640875},
{-0.2507038944234642,-0.5014293336582597,-0.23115028348687905},
{0.06212675212933561,-0.4779555943338867,-0.3936629560882992},
{0.06212975708193777,-0.34424825761142797,-0.39367436093166364},
{0.09553204149861906,-0.4780970926601385,-0.38778702984048613},
{0.2322354976602286,-0.4777256385889418,-0.3230119221354725},
{0.23421827719931623,-0.3442248469341787,-0.32213907425195254},
{0.1677181869354319,-0.3432260146657482,-0.36145497960094913},
{0.09391476203161883,-0.34396658872867863,-0.3858992347566738},
{-0.10297606382642323,-0.47806793763163585,-0.3873361891144977},
{-0.10335735737032659,-0.34393016590783587,-0.387425568983757},
{-0.0711732667620327,-0.477956824267975,-0.39368731716916217},
{-0.0014937409737426017,-0.47795585988783756,-0.39779557655463027},
{-0.07116715902116229,-0.34424479143354275,-0.39365704401876106},
{-0.24217957067040197,-0.3440235710159297,-0.3224402962914014},
{-0.24030399106833047,-0.4777885608987784,-0.32349914375273253},
{-0.2565293095145137,-0.3894536184832092,-0.2469856708974932},
{-0.2565293095145137,-0.43347687293087633,-0.24698428722164387},
{-0.28439149559558863,-0.4772247898610441,-0.21349374105760177},
{-0.28439149559558863,-0.34497756659623147,-0.21349371310455426},
{-0.3105960939152233,-0.34497756659623147,-0.17669354009755292},
{-0.3105960939152233,-0.4772247898610441,-0.17669215642170358},
{-0.33314162434557815,-0.43347687293087633,-0.1394013794786993},
{-0.33314162434557815,-0.3894536184832092,-0.1394013794786993},
{-0.07170763119383715,-0.4785069961481191,0.421526707540032},
{-0.005072597593330676,-0.47849915531830606,0.4258969009567414},
{0.06267027118418382,-0.47850789064563787,0.42152491854499446},
{0.11291971754088459,-0.47809640781047574,0.4084855906128468},
{0.16607913204445887,-0.4780883992623779,0.38830476220905086},
{0.1850397400439264,-0.4780887766285187,0.37860209171675807},
{0.21746344417506328,-0.47808995065651205,0.36043435793202216},
{0.23519540392639268,-0.47808627483077076,0.34818666030399403},
{0.2647353878222228,-0.47809357057615837,0.3253510051940327},
{0.28996954019312443,-0.4334769707665424,0.3043001242114629},
{0.31788573156189565,-0.4772394512344378,0.27079442749569654},
{0.34405020328189884,-0.47727591598485175,0.23411053916613647},
{0.36658184104766517,-0.4334784103484867,0.19671583279266902},
{0.36658184104766517,-0.38945373029539904,0.19671583279266902},
{0.3440400703021939,-0.3449631148706936,0.23406482195701264},
{0.3179309316396414,-0.34492691567423056,0.27079075166995525},
{0.28996954019312443,-0.38945373029539904,0.3043001521645104},
{0.03088308589680074,-0.3588920345617909,0.42460482724391224},
{0.06266582664963738,-0.34369408844549687,0.4215145759174336},
{-0.00244624106600513,-0.34370272593716256,0.42577471818628554},
{-0.025876946673810644,-0.35229218029081094,0.42526913141684314},
{-0.06828166376734167,-0.40425936936708984,0.4218521928246778},
{-0.03883694385726158,-0.463994906004349,0.42460514870395805},
{0.01791556934358256,-0.4705852702157157,0.425299628191624},
{0.06033261373104426,-0.41861327321527336,0.4218600616075383},
{0.2486451385013752,-0.38945373029539904,0.27487396512489753},
{0.2486451385013752,-0.4334769707665424,0.27487395114837376},
{0.27650736651202135,-0.47722490167323395,0.2413820073319586},
{0.27650736651202135,-0.34497766443189753,0.2413820352850061},
{0.3027119368786086,-0.34497766443189753,0.20458184830148096},
{0.3027119368786086,-0.47722490167323395,0.2045818203484335},
{0.32525746730896343,-0.4334783684189155,0.16728965972957988},
{0.32525746730896343,-0.38945367438930417,0.16728965972957988},
{0.22712723197833662,-0.6119472694551272,0.21138430626046448},
{0.17520420871704745,-0.611948736990119,0.2624090443650434},
{0.16503160556734978,-0.6119459696384203,0.25317528624392316},
{0.07493004452871542,-0.6119459975914677,0.29664534988232016},
{0.09796633263683424,-0.611950498032109,0.30289363867537256},
{-0.03578758783921959,-0.6119459975914677,0.3057081471651637},
{0.012432033999515243,-0.611950498032109,0.3198999093615449},
{-0.07442902808253299,-0.6119505259851566,0.312118968952683},
{-0.14927067109865033,-0.6119459696384203,0.269530376712948},
{-0.15446102090441402,-0.6119463190515135,0.27917192786696543},
{-0.1495611871209213,-0.611945885779278,-0.24018652537463395},
{-0.2133321514784867,-0.6119472415020798,-0.20625412538936236},
{-0.21128322105258054,-0.6119472135490324,0.23720598975944301},
{0.16526049909649113,-0.611945885779278,-0.22469027831235067},
{0.17110741008103875,-0.6119463190515135,-0.23577596775738968},
{0.09457070824335859,-0.6119504141729667,-0.2761813151781644},
{0.08255031082076654,-0.611945885779278,-0.26651958192387953},
{0.008841465053040653,-0.6119503862199193,-0.29218293936203416},
{-0.04166277333127488,-0.611945885779278,-0.27811418455100895},
{-0.07792232042384034,-0.6119503862199193,-0.2833843263307525},
{-0.15865885583047357,-0.6119491143562598,-0.25042462251453473},
{0.22524736158347974,-0.6119469060655103,-0.1868793929917475},
{0.2142601087950777,-0.4926955577205658,0.30812969171373633},
{0.17951825843792962,-0.6119459975914677,0.27565526677797997},
{0.20269593306011047,-0.4926955577205658,0.3163632618436242},
{0.12253917181088347,-0.4926955577205658,0.3576876355823259},
{0.09835330064937235,-0.6119459696384203,0.3167402226651709},
{0.10912450433394182,-0.4926955577205658,0.362329239113366},
{0.020572045279548253,-0.4926955577205658,0.37939738387009514},
{0.008902584391315988,-0.6119459975914677,0.3332944087147428},
{0.006392861954525008,-0.4926955577205658,0.3800724499662988},
{-0.08337974762157829,-0.4926955577205658,0.37150063398559885},
{-0.08158935493164682,-0.6119460255445152,0.32397765799570827},
{-0.09717597419637419,-0.4926955577205658,0.3681532565520424},
{-0.18089674899698702,-0.4926955577205658,0.33463615499291155},
{-0.16579093612512721,-0.6119459975914677,0.28954323525454567},
{-0.19319049927070853,-0.4926955577205658,0.32753889021887167},
{-0.26789501861250176,-0.4926955577205658,0.2664013824626872},
{-0.22483204918081537,-0.6119459975914677,0.23848702201852467},
{-0.2730383793454821,-0.4926955577205658,0.2543913556207034},
{-0.1931918969230816,-0.49269544590837594,-0.29965062394451475},
{-0.16169301936722003,-0.6119458578262303,-0.2640203558564105},
{-0.18089814664936013,-0.49269544590837594,-0.3067479166716021},
{-0.09717597419637419,-0.49269544590837594,-0.34026501823073296},
{-0.07699112055374374,-0.6119459137323253,-0.29720495591598267},
{-0.08337974762157829,-0.49269544590837594,-0.3436123956642895},
{0.006392861954525008,-0.49269544590837594,-0.35218416971541816},
{0.013628983491831646,-0.611945885779278,-0.30518180525798083},
{0.020572045279548253,-0.49269544590837594,-0.3515091175957382},
{0.10912450433394182,-0.49269544590837594,-0.3344423844679059},
{0.10282485181617833,-0.611945885779278,-0.287304321941565},
{0.12253917181088347,-0.49269544590837594,-0.3297993972610165},
{0.20269593306011047,-0.49269544590837594,-0.28847498159274354},
{0.18337060767388444,-0.611945885779278,-0.24502156399411007},
{0.2142601087950777,-0.49269544590837594,-0.2802414254393794},
{0.2824767258209756,-0.49269544590837594,-0.21310239839313583},
{0.2390727431867784,-0.611945885779278,-0.18744063427868654},
{0.2871294965944768,-0.49269544590837594,-0.20062696728743604},
{-0.041670083053186154,-0.5449719354548203,0.30600080159556564},
{-0.1495629341863877,-0.5449719354548203,0.2680740229401855},
{-0.14978102386268505,-0.5449718236426304,-0.23964631875590994},
{0.06846865567833768,-0.5449719354548203,0.29757769582736265},
{0.04770386016001624,-0.5449718236426304,-0.2749733242321006},
{-0.06337595984388197,-0.5449718236426304,-0.2734718262876874},
{0.16353293088073015,-0.5449718236426304,-0.2282783454610775},
{0.16473090065927892,-0.5449719354548203,0.2547416911645428},
{0.27003149798305837,-0.4926961866641337,0.22924396950912335},
{0.2871294965944768,-0.4926955577205658,0.2285152056087455},
{0.28247534214512626,-0.4926955577205658,0.24099065069096898},
{0.23752246717454423,-0.6119459696384203,0.21948602186547475},
{0.19936093882657957,-0.4926958791806116,0.29944331016801395},
{0.11069125866765475,-0.4926955577205658,0.3451548587997581},
{0.012734709597432151,-0.4926955577205658,0.36403370413539976},
{-0.08657212540695883,-0.49269576736842174,0.35455189067110304},
{-0.17918459688690128,-0.4926955577205658,0.31747439548023265},
{-0.2559603392099515,-0.4926958232745167,0.2541847825999603},
{-0.25595927699414794,-0.4926949148004742,-0.22629502083756428},
{-0.2730383793454821,-0.49269544590837594,-0.22650307536982278},
{-0.2678964302413986,-0.49269544590837594,-0.23851173251248092},
{-0.22312012069510928,-0.611945829873183,-0.21459973133347726},
{-0.17918403782595205,-0.49269502661266407,-0.28958513687269094},
{-0.08657233505481479,-0.49269603292237263,-0.3266645328707887},
{0.012734709597432151,-0.4926955018144709,-0.336145535696709},
{0.11069128662070223,-0.49269544590837594,-0.31726664843149616},
{0.19935998842296587,-0.4926951803544251,-0.2715530033211924},
{0.2700301702133039,-0.4926955577205658,-0.20135454318329682},
{0.33209982824319867,-0.47792504165301086,-0.22556316812544186},
{0.2654402798200682,-0.4778555224239733,-0.2966175226235718},
{-0.3398557646511059,-0.4689940988950448,0.25313426514677284},
{-0.38258535206223854,-0.4689940429889499,0.17714158551879522},
{0.04101062873398991,-0.3689516794466952,0.3959665667296303},
{-0.0014139629762864828,-0.34842419132480124,0.3959665667296303},
{-0.04646948153714844,-0.36644954626229015,0.3959665667296303},
{0.05903364959201583,-0.4140040253366703,0.3959665667296303},
{0.03850796444168305,-0.45643135644559796,0.39596653877658283},
{-0.006545737171093884,-0.47445703284313273,0.39596653877658283},
{-0.04897160074502979,-0.453928594317625,0.39596653877658283},
{-0.06698528528520346,-0.4088568350361877,0.3959665667296303},
{-0.2098700826911942,-0.36681876408969005,0.370622950224868},
{-0.2676537558598585,-0.366694261216295,0.331160584883695},
{-0.2651134248360968,-0.4682976347410091,0.3275245782585712},
{-0.20967625626009376,-0.46801579813997507,0.3701343030021874},
{-0.19605149367842883,-0.36681876408969005,0.3491130802029747},
{0.031785843541104905,-0.27323458877387874,-0.39678697469611185},
{0.13287067405887804,-0.20937636897866124,0.3962465584295319},
{0.25941469295614444,0.09010657162239172,0.3227248722910868},
{0.2584457564719744,-0.20897149703922382,0.3234624973075101},
{0.13326787288678718,0.09294757960117685,0.39594917993410905},
{-0.39507021732145675,-0.2252910452084009,-0.015309387928262596},
{-0.39618273463391457,-0.2252910452084009,0.008053769140351354},
{-0.39618273463391457,0.026749004883739682,0.008053811069922546},
{-0.39507021732145675,0.026749004883739682,-0.015309345998691404},
{-0.39618273463391457,-0.2252910452084009,0.019834580993147895},
{-0.39496677706932415,-0.2252910452084009,0.04536549689242828},
{-0.39496677706932415,0.026749004883739682,0.045365538821999486},
{-0.39618273463391457,0.026749004883739682,0.01983462292271909},
{-0.39384724354195333,-0.2252910452084009,0.05709319795504732},
{-0.3902091683913173,-0.2252910452084009,0.08239350121276745},
{-0.3902091683913173,0.026749004883739682,0.08239354314233864},
{-0.39384724354195333,0.026749004883739682,0.057093239884618514},
{-0.3879799128562348,-0.2252910452084009,0.09396047225248085},
{-0.3819532358234601,-0.2252910452084009,0.11879955022708046},
{-0.3819532358234601,0.026749004883739682,0.11879959215665166},
{-0.3879799128562348,0.026749004883739682,0.09396051418205204},
{-0.37863519511321475,-0.2252910452084009,0.13010236496827937},
{-0.37098445999943025,-0.2252910452084009,0.15220622327221328},
{-0.37098445999943025,0.026749004883739682,0.15220627917830817},
{-0.37863519511321475,0.026749004883739682,0.13010380455022363},
{-0.40821484438339317,0.029709442257805547,0.0941853405427877},
{-0.4007223235182427,0.026749004883739682,0.12335314358818694},
{-0.39688576775410384,-0.2252910452084009,0.1364197536946574},
{-0.4144454109443547,-0.22825297807050596,0.05085108678548405},
{-0.41547454431623393,-0.2252910452084009,0.020752838602269657},
{-0.41547454431623393,0.026749004883739682,0.007135553460800783},
{-0.4142585867516434,0.026749004883739682,0.04628519408349434},
{-0.40674900055101754,-0.2252910452084009,0.09851402368401616},
{0.3882985775972999,-0.2252910452084009,0.008053769140351354},
{0.38718604630831827,-0.2252910452084009,-0.015309387928262596},
{0.38718604630831827,0.026749004883739682,-0.015309345998691404},
{0.3882985775972999,0.026749004883739682,0.008053811069922546},
{0.3631002889862918,-0.2252910452084009,0.15220622327221328},
{0.37075106602964747,-0.2252910452084009,0.13010376262065246},
{0.37075106602964747,0.026749004883739682,0.13010380455022363},
{0.3631002889862918,0.026749004883739682,0.15220627917830817},
{0.3740704764392184,-0.2252910452084009,0.11880094787945354},
{0.38009576979614385,-0.2252910452084009,0.09396047225248085},
{0.38009576979614385,0.026749004883739682,0.09396051418205204},
{0.3740704764392184,0.026749004883739682,0.11880098980902476},
{0.3823249973781789,-0.2252910452084009,0.08239350121276745},
{0.3859631144583861,-0.2252910452084009,0.05709319795504732},
{0.3859631144583861,0.026749004883739682,0.057093239884618514},
{0.3823249973781789,0.026749004883739682,0.08239354314233864},
{0.38708262003270943,-0.2252910452084009,0.04536689454480138},
{0.3882985775972999,-0.2252910452084009,0.019834580993147895},
{0.3882985775972999,0.026749004883739682,0.01983462292271909},
{0.38708262003270943,0.026749004883739682,0.04536693647437257},
{0.40033049167544627,-0.22825265661046015,0.09418568995588096},
{0.40656137969645356,0.029709218633425818,0.050851575963814635},
{0.4075917569789448,-0.2252910452084009,0.007135511531229591},
{0.4075917569789448,0.026749004883739682,0.02075288053184085},
{0.38900298041681475,0.026749004883739682,0.13642119327660165},
{0.39283953618095363,-0.2252910452084009,0.12335449931098884},
{0.39886482953787905,0.026749004883739682,0.09851406561358735},
{0.40637441573850497,-0.2252910452084009,0.04628515215392314},
{-0.04312719155822999,-0.27323458877387874,-0.39647960298622126},
{-0.005704769738204138,-0.344246440663343,-0.3977989309203257},
{0.03088284829589731,-0.3588918109374112,-0.39687065214368883},
{0.06032826703216395,-0.418613916135365,-0.3941066548106611},
{0.01792613559552314,-0.4705817481317355,-0.39753374035905514},
{-0.038837209411212464,-0.46399389969464033,-0.39687024682450067},
{-0.06827738695108,-0.4042553161752079,-0.39409502634291704},
{-0.02587717029819033,-0.35229218029081094,-0.3975344671382891},
{0.059033789357253154,-0.41400232020077515,-0.3682320002867424},
{0.041010069673040675,-0.36895103652660366,-0.3682320002867424},
{-0.0014139629762864828,-0.34842407951261134,-0.3682320002867424},
{-0.046468866570104274,-0.36644895924829346,-0.3682320002867424},
{-0.06698528528520346,-0.4088539558722991,-0.3682320002867424},
{-0.0489723275242638,-0.45392795139753334,-0.3682320282397898},
{-0.006546589739041471,-0.4744569909135615,-0.3682320561928373},
{0.03850796444168305,-0.4564312586099319,-0.3682320282397898},
{-0.1620938381147755,-0.34500880412677004,-0.36686128067487944},
{-0.17844143716708055,-0.47558595859445074,-0.35869584609817984},
{-0.17745391190634832,-0.36371107006159514,-0.3594086348319333},
{-0.2389365279864968,-0.36365674331385306,-0.32359162641026007},
{-0.16693436950807788,-0.4105438154270341,-0.33522392372189186},
{-0.16317731221092052,-0.41619073633351594,-0.32332264821105844},
{-0.21521385279795227,-0.41633293348595435,-0.2942807177383798},
{-0.22275666119548662,-0.4075547401558436,-0.3015793842193824},
{0.15426149205163134,-0.3449794813799825,-0.36683786999763},
{0.16951377889219124,-0.363711335615546,-0.35940855097279084},
{0.2309957101226769,-0.3636568970556141,-0.3235922972833991},
{0.17069648630682582,-0.47599164117226456,-0.35888770183943425},
{0.15899420854087337,-0.41054385735660526,-0.33522389576884437},
{0.1552372490793821,-0.41619073633351594,-0.32332264821105844},
{0.20727402726731728,-0.41633283565028817,-0.2942812767993291},
{0.21481722700751607,-0.4075545305079876,-0.30157934228981126},
{0.29937966806720523,0.37085447134047067,-0.259143261877028},
{0.3393072699538095,0.3725475734487112,-0.20674440786531947},
{0.30100973605341924,-0.22213857039827214,-0.2599238367508764},
{0.3012914608422635,0.37200770226655666,-0.2624806740491643},
{0.35435987419982573,-0.2221716807829907,-0.1851108456084075},
{0.35272263625693767,0.36999757067052763,-0.18337327020165517},
{0.3566850226642261,0.37208063176738465,-0.18454100875937393},
{-0.35870405730587174,0.37058468250289256,-0.19127134785590588},
{-0.3094636600564488,0.36860824830557887,-0.2581436049936973},
{-0.3611899218166541,-0.21945020003515248,-0.1870319187952231},
{-0.36224355603463354,0.3643477566236335,-0.18565383355535392},
{-0.3107859789666316,-0.21966570405455962,-0.25804455337001625},
{-0.31091281591948977,0.3693657758917949,-0.2603262907517084},
{0.35846567371711713,-0.4085609240757565,-0.14083957774713518},
{0.3495277007677144,-0.4085609240757565,-0.16041090392754923},
{0.34954445861966776,-0.27495515475125054,-0.16037174170805518},
{0.3703453554987862,-0.27535629495885183,-0.14664763399571085},
{0.3432075167365902,-0.4085609240757565,-0.17266550595830038},
{0.3313414620655587,-0.4085609240757565,-0.19321658645225226},
{0.33135404093691656,-0.27495515475125054,-0.19319559371360842},
{0.3432033237794709,-0.27495515475125054,-0.17267386391949147},
{0.3238933725693489,-0.4085609240757565,-0.2048087152346813},
{0.31010412027989476,-0.4085609240757565,-0.22417318886387763},
{0.3101264827178642,-0.27495515475125054,-0.22414104285929654},
{0.32387239380722876,-0.27495515475125054,-0.20483806593451628},
{0.30160078926547634,-0.4085609240757565,-0.23498542762212113},
{0.28602115826261443,-0.4085609240757565,-0.2529662114254322},
{0.28605330426719555,-0.27495515475125054,-0.25292848878788243},
{0.3015714385656414,-0.27495515475125054,-0.2350203689314484},
{0.27646823224557476,-0.4085609240757565,-0.26297760935041736},
{0.260891396547459,-0.4085609240757565,-0.2778304611192712},
{0.2609235145989927,-0.27495515475125054,-0.27779969879053945},
{0.2765017619260053,-0.27495515475125054,-0.26294544936931247},
{0.31964575326575984,-0.41739541484345544,-0.21225848191373886},
{0.3592295047155359,-0.41739541484345544,-0.14088867727500193},
{0.3611794673769033,-0.46911384975037146,-0.14266772102766387},
{0.37526419735455296,-0.4124027909189132,-0.14739835501487003},
{0.37420212131624,-0.46944739948920994,-0.14706421826203478},
{0.34491145065072215,-0.4698009356569837,-0.20638877521898613},
{0.2632199273306023,-0.46911278753456787,-0.27893037160732376},
{0.27268597527613053,-0.4697226112179955,-0.29132647196432687},
{0.26151346366567507,-0.41739541484345544,-0.2787921577641486},
{0.27274499813584624,-0.4149188307444306,-0.29162400420151074},
{0.324366981052495,-0.41526704185666274,-0.23533226903502777},
{0.3656089492072792,-0.4144549219687537,-0.1686913233649831},
{0.33883081025982226,-0.2679743004433655,-0.214548116031339},
{0.3592671295174195,-0.2710690382339618,-0.18098451457775536},
{0.28957586344919545,-0.2710715400317097,-0.2754461360533941},
{0.3157707480848371,-0.27106610316397833,-0.24622165820426592},
{0.2984239533744846,-0.2744379255375402,-0.264533266324288},
{0.29903975901006913,-0.41225669431635387,-0.2653269791304434},
{0.28874449788810885,-0.40910613428997616,-0.2748331257225557},
{0.3235440712882656,-0.27443798144363507,-0.23451634753266387},
{0.31494904030164866,-0.40910560318207445,-0.24561981511588854},
{0.2720847890843685,-0.27446900932631774,-0.2904170335416793},
{0.3464652068173653,-0.4122605378603798,-0.20288948694899817},
{0.3381919992661766,-0.40910560318207445,-0.21412582934333282},
{0.3456980214532512,-0.2744379255375402,-0.20224823006369963},
{0.36468340982929365,-0.2744379255375402,-0.1680207157798496},
{0.35832664923556556,-0.40910560318207445,-0.18058143163335547},
{0.09408466065409195,0.37882268319080303,0.41839677686268123},
{-0.049205288221810854,0.38196545829346257,0.4286528617886238},
{-0.037984250120961585,0.37567339502808506,0.42972438595697876},
{-0.15936815043329428,0.37881596048288857,0.39921075548848134},
{-0.2340289651853809,0.3750195313183811,0.3360958212017981},
{-0.242651418111558,0.37901792125080036,0.3552715279014846},
{-0.14491966744902357,0.3823735448333582,0.21740600765079107},
{0.13930002871686448,0.38233931632674123,0.21737249194688432},
{0.1393518676433825,0.40506065744910724,0.2173721285572673},
{-0.14489642449005904,0.4050607552847733,0.2174058818620775},
{0.18776503638274317,0.3788231024865151,0.38250548321737826},
{0.2398287752849553,0.3778521114533565,0.34929429980966986},
{-0.2432013244377512,0.42754281832086605,0.3549634992949787},
{-0.10715838481114144,0.42692178546540616,0.41956863849490067},
{-0.24894598317468342,0.4180308854479293,0.36504841373478863},
{-0.16132169108473685,0.41788042816996585,0.4107163835655397},
{-0.23724872298075034,0.4108813904047069,0.3453370427865907},
{-0.1260531494073126,0.41549730508512966,0.402377416470197},
{-0.08262978133470059,0.41785227945117176,0.4334262080323516},
{-0.0018276401256743962,0.41785237728683783,0.4407387392248952},
{0.029355507759105576,0.41549122529730653,0.42006965494108306},
{0.07890201883128323,0.41785237728683783,0.43262529731647464},
{0.17676119346067246,0.4178562208308638,0.40157316536514837},
{0.1598225691493578,0.415460197414624,0.3849321152205888},
{0.24503707094718952,0.4239473855441332,0.35846500983223994},
{0.23371510836847922,0.40869105948821494,0.3399666334256015},
{-0.11556643786328612,0.40540336181098946,0.40593200984458816},
{0.040359364657700014,0.4053792662840774,0.41932421704789424},
{0.16858027289567906,0.4053440873738467,0.3811674546945219},
{0.06950261095090404,0.42696978084789816,0.4245700955824409},
{-0.14707764271307835,0.27659397204131997,0.28540120858774365},
{-0.23655452302355906,0.28746407360780935,0.2853980359168567},
{-0.23655519389669813,0.33693522326402997,0.2853986928134721},
{-0.1471580077245312,0.34759974414296124,0.28540120858774365},
{-0.11916072456507315,0.3372799681983769,0.28540120858774365},
{-0.053386435178535675,0.3344183867766599,0.28538340249651045},
{-0.053386099741966134,0.3470351345138031,0.28539574376696486},
{0.14839223260563794,0.3468073591065601,0.28540120858774365},
{0.1814180174260556,0.332706290572669,0.28540120858774365},
{0.22876774042777764,0.33250080772077695,0.28540120858774365},
{-0.11907490870936527,0.2873796274514272,0.28540120858774365},
{-0.053753472668233486,0.2875892613308674,0.28538120818228474},
{0.1517766897566526,0.27731214173670976,0.28541730954308164},
{0.22876760066254034,0.2856891808826956,0.28540120858774365},
{-0.18898125950128453,0.17505016646074686,0.28617805172975597},
{-0.1540723757090282,0.16546060797500858,0.2861964448349858},
{0.04659335546697561,0.17774945248890053,0.28619657062369946},
{-0.1566483608448275,0.234570562468216,0.2861964727880333},
{-0.1889708050615338,0.22079270104560247,0.2861864376439945},
{-0.23639724520201494,0.22061504545245875,0.28614714963578686},
{0.04602751590372911,0.2344662836246595,0.2861964727880333},
{0.046254564531737985,0.22158444316191203,0.2861964448349858},
{0.11110524330056475,0.22392331657261602,0.2861964448349858},
{0.13877058402141335,0.23447299235605046,0.2861964727880333},
{0.2283620858030113,0.2238405755521291,0.2861964448349858},
{0.22836332971362333,0.17724081883728462,0.2861964448349858},
{0.13880273002599447,0.167216408768706,0.2861964448349858},
{0.11166589757350706,0.1766864400234975,0.2861964448349858},
{0.09163847549418175,-0.06406769294463475,0.4088725586253849},
{-0.10255973113752644,-0.06406769294463475,0.4088725586253849},
{0.2506871225949871,-0.23337506653436785,0.2661149475853456},
{0.28902854277989243,-0.23337506653436785,0.22084400886421887},
{0.2527964455799345,0.38308328668493835,0.26698439917359895},
{0.3176402618756094,0.38308328668493835,0.17209213304876297},
{0.3176402618756094,-0.23337501062827287,0.1720920212365731},
{-0.3251479332924842,0.38293794481466037,0.17209388011422933},
{-0.3248144394597406,-0.23322966875799497,0.17176361485846758},
{-0.29786202723788274,-0.23322972466408995,0.2171993927004768},
{-0.25910242946294815,0.38293794481466037,0.2660658201044314},
{-0.2580275928584688,-0.23322972466408995,0.26555166572594185},
{-0.3408113815081604,-0.2339502983215615,0.2521109879383369},
{0.03246332757591402,-0.06987340113722365,0.4088725586253849},
{0.06437033360124234,-0.09771938842729441,0.4088725586253849},
{-0.04396360264438346,-0.07120887195623726,0.4088725586253849},
{0.03785851731347817,-0.05271017408955306,0.4088725586253849},
{0.06570542705411518,-0.020804467880931855,0.4088725586253849},
{0.0643704593899559,0.07470255564020901,0.4088725865784324},
{0.032461915947017195,0.10255003841831899,0.4088725865784324},
{-0.04396170183715606,0.10121500087154094,0.4088725865784324},
{-0.07180896099088635,0.0693090850150637,0.4088725865784324},
{-0.07047344824230156,-0.026202201345814857,0.4088725586253849},
{-0.038571180258518044,-0.054044778364095346,0.4088725586253849},
{-0.038569209568671985,-0.22277089628490668,0.4088725306723375},
{-0.07047344824230156,-0.1949282214309601,0.4088725306723375},
{0.03785839152476459,-0.2214358587381287,0.4088725306723375},
{0.06570545500716266,-0.18953043205998202,0.4088725306723375},
{-0.07180852771865069,-0.10311136356440052,0.4088725306723375},
{-0.07071907167034883,-0.024836555212066302,0.4142040713208309},
{-0.06306795919042357,-0.016869727037583212,0.41411543220732944},
{-0.07121115711786723,0.07062909779883081,0.41417871790678307},
{-0.042594280684893564,0.10145865360974211,0.4142084739258062},
{-0.061720384701859,0.07213239871480548,0.4141634695193926},
{-0.04151199459326566,-0.04385562701030034,0.41413870311934137},
{-0.03989015877952915,-0.0534471002797899,0.4141786899537356},
{0.03649183691697341,-0.052955531963649466,0.4142047142409226},
{0.02863499000772894,-0.04525080553869246,0.4141038875987276},
{0.05561616591542502,-0.023629808176614458,0.4141634415663451},
{0.065108042476808,-0.02212415920465316,0.4141782846345474},
{0.06461633439543034,0.07333457542699713,0.4142044207339242},
{0.05696326520218274,0.06537585363627797,0.41411537630123446},
{0.035409662637535366,0.09236227074037322,0.41414493664892543},
{0.033783004923111676,0.10195546312228171,0.41417237256500916},
{-0.034737629446981326,0.09374987399290324,0.41409481683482635},
{-0.07071908564687256,-0.1935624634850216,0.41420404336778355},
{-0.06306794521389984,-0.18559569121663338,0.41411540425428195},
{-0.07121089156391634,-0.10179210551291477,0.4141786060945932},
{-0.042596922247878706,-0.0709630808099053,0.41420425301563946},
{-0.0617203427722878,-0.10028965716488791,0.4141634136132977},
{-0.04139357150769354,-0.2126853389250052,0.4141686408331731},
{-0.039889278258534104,-0.22217620917667952,0.4141725542598177},
{0.028529033981324798,-0.21402586924560935,0.41410692050437725},
{0.0364901597341257,-0.22167924592237898,0.4142090469632792},
{0.05561619386847248,-0.19235560463738,0.4141634136132977},
{0.06510807042985546,-0.19085005350108475,0.41417825668149993},
{0.06461626451281167,-0.09908727080484003,0.41420428096868694},
{0.05696322327261155,-0.10704578294770337,0.4141153203951396},
{0.03529030312487327,-0.07996295578291229,0.4141633018011079},
{0.033784164974581345,-0.07047140068157509,0.41417874585983055},
{-0.034637445724878056,-0.07861577263701215,0.41411522255947353},
{-0.06150598482782661,-0.023818323528697307,0.354343137312658},
{-0.0592119201522038,0.07872622910405744,0.35434316526570536},
{-0.021191540717397785,0.09528421676808417,0.3543436963736072},
{-0.025890028700022785,-0.04719706442127119,0.3543433469605139},
{0.015086371527350102,-0.04678108114546764,0.3543436404675122},
{0.05310736592920028,-0.03022362458934272,0.354343137312658},
{0.05540164025267905,0.07232305247501893,0.35434316526570536},
{0.01978916427928423,0.09570007425517407,0.3543433749135614},
{-0.06280717123412825,-0.18658374758526733,0.39643062924706823},
{-0.05921182231653768,-0.09369582677563595,0.3964306572001156},
{-0.03238866498614344,-0.07747191995834957,0.39284900527578137},
{-0.036778579277837085,-0.21342387241547092,0.39556152707190806},
{0.02628708776269461,-0.21517366330396412,0.3928553226645078},
{0.053107393882247736,-0.19894953286229802,0.39643062924706823},
{0.0567025611050298,-0.10605772657906933,0.39643062924706823},
{0.030690475423264866,-0.07922580596829573,0.3955647975784611},
{-0.020910277153836653,-0.04645298225088411,0.2660702087328829},
{0.014805331588168665,-0.04645298225088411,0.2660702087328829},
{0.014805331588168665,0.09495589424912092,0.2660702366859304},
{-0.020910277153836653,0.09495589424912092,0.2660702366859304},
{-0.08061239592285517,-0.06539259751170784,0.3467930331697361},
{-0.0214218179223885,-0.06539259751170784,0.3471102862819043},
{-0.08028544310321765,-0.06539291897175364,0.3924771319088726},
{0.015316872356720516,-0.06539259751170784,0.3471102862819043},
{-0.0214218179223885,-0.06539259751170784,0.2660702087328829},
{0.015316872356720516,-0.06539259751170784,0.2660702087328829},
{-0.08028190704271372,-0.22862715756383029,0.39247710395582514},
{-0.08060960061810898,-0.228625871723647,0.3467930052166886},
{-0.0214218179223885,-0.228625871723647,0.3471102583288569},
{0.015316872356720516,-0.228625871723647,0.3471102583288569},
{0.07418319500662973,-0.228625871723647,0.34742474408932644},
{0.07450745035718717,-0.22862725539949635,0.39293090770484457},
{0.07450884800956027,-0.0653927093238978,0.39293092168136834},
{0.0741859903113759,-0.06539259751170784,0.34742477204237393},
{-0.0214218179223885,-0.228625871723647,0.2660701807798354},
{0.015316872356720516,-0.228625871723647,0.2660701807798354},
{-0.29946903395994073,-0.4302106152410541,0.28179940251618946},
{-0.36929721405463295,-0.4302105593349591,0.17062916838027586},
{-0.37035740326224226,-0.4689940429889499,0.17149453882359983},
{-0.29824155973979605,-0.4689940988950448,0.281194498569115},
{-0.1923831174243442,-0.21587753501557716,0.37812072626294124},
{-0.13728198640840375,-0.21533200334131172,0.4017904863326405},
{-0.1923641512816413,-0.055474716507006305,0.37811171140513483},
{-0.13725172723452628,-0.05588515110288859,0.40188119397165417},
{-0.23641288493206986,0.17482612278534035,0.2861586942443886},
{-0.25167217401101893,-0.3666908509445046,0.3108738144300186},
{-0.35715733133066524,-0.27507403906210576,0.22555179123512492},
{-0.3409452766055027,-0.27507403906210576,0.24991382250174063},
{-0.306317474681999,-0.2750739412264397,0.28860300655011883},
{-0.3234044597927174,-0.27507403906210576,0.27347437001500646},
{-0.3088032832866864,-0.42895011449533316,0.2906499662861789},
{-0.3085904767363593,-0.4689941548011398,0.29057236862642477},
{-0.37137158175372936,-0.27507403906210576,0.19969747255323467},
{-0.378706810820812,-0.27507382941424985,0.1745862017789753},
{-0.3824501571481893,-0.42768955784351725,0.17645852485101746},
{-0.34283941703108883,-0.420126595298763,0.24725305577298956},
{-0.35867142212296005,-0.420126595298763,0.22257191251654937},
{-0.3504175441040912,-0.4302106152410541,0.23661172194692784},
{-0.3727287581140971,-0.420126595298763,0.19672653880984692},
{-0.32554337107840325,-0.420126595298763,0.2710056966284132},
{-0.34719362130465,-0.420126595298763,0.2121207712254181},
{-0.34719362130465,-0.27507403906210576,0.21212079917846555},
{-0.3569925481158776,-0.27507403906210576,0.19514910641200353},
{-0.3569925481158776,-0.420126595298763,0.19514907845895607},
{-0.3604070268398663,-0.2750739971325346,0.1875081269117832},
{-0.36576752684553027,-0.42012653939266803,0.17576969187893882},
{-0.31543336877849637,-0.420126595298763,0.25981565845719906},
{-0.31543336877849637,-0.27507403906210576,0.25981565845719906},
{-0.32680187318123066,-0.27507403906210576,0.2438517010047842},
{-0.32680187318123066,-0.420126595298763,0.24385167305173677},
{-0.3056763715384615,-0.420126595298763,0.27097173367574706},
{-0.30990147466232004,-0.27507403906210576,0.2660953245460274},
{-0.3392350253026444,-0.420126595298763,0.22584311789577233},
{-0.33597672025482506,-0.27507403906210576,0.23091222135817027},
{-0.2872049698226238,-0.051181268182103425,0.31071262318182985},
{-0.23535196894522653,-0.041433579306873476,0.3512277422199873},
{-0.25153872616243605,-0.043353813902265184,0.36581857609845747},
{-0.2963496276049594,-0.046544891870938805,0.32977939685555757},
{-0.2872049698226238,-0.03493635464964966,0.31071262318182985},
{-0.29477493460576726,-0.04007198636500678,0.33093800874328},
{-0.24604821653302703,-0.04368405120497951,0.3591623684837944},
{-0.29015103933029424,-0.042433361978917554,0.3236071683046489},
{-0.2872049698226238,-0.0878696429757811,0.31071262318182985},
{-0.23535196894522653,-0.07812195410055116,0.3512277422199873},
{-0.25153872616243605,-0.08004218869594287,0.36581857609845747},
{-0.2963496276049594,-0.0832332666646165,0.32977939685555757},
{-0.2872049698226238,-0.07162472944332735,0.31071262318182985},
{-0.29477493460576726,-0.07676036115868447,0.33093800874328},
{-0.24604821653302703,-0.0803724259986572,0.3591623684837944},
{-0.29015103933029424,-0.07912173677259524,0.3236071683046489},
{-0.2872049698226238,-0.12455807367555378,0.3107125952287825},
{-0.23535192701565533,-0.11481038480032373,0.3512277701730348},
{-0.25153875411548354,-0.11673056348962056,0.36581854814541},
{-0.2963496276049594,-0.11992169736438907,0.3297793689025101},
{-0.2872049698226238,-0.10831316014309982,0.3107125952287825},
{-0.29477493460576726,-0.11344884776455191,0.3309379668137088},
{-0.24604818857997954,-0.11706080079233479,0.3591623405307469},
{-0.29015103933029424,-0.11581011156627302,0.32360714035160143},
{-0.2872049698226238,-0.16124644846923147,0.3107125952287825},
{-0.23535192701565533,-0.15149875959400141,0.3512277701730348},
{-0.25153875411548354,-0.15341893828329825,0.36581854814541},
{-0.2963496276049594,-0.15661007215806674,0.3297793689025101},
{-0.2872049698226238,-0.1450015349367775,0.3107125952287825},
{-0.29477493460576726,-0.15013722255822962,0.3309379668137088},
{-0.24604818857997954,-0.15374917558601248,0.3591623405307469},
{-0.29015103933029424,-0.15249848635995072,0.32360714035160143},
{-0.2872049698226238,-0.19793482326290915,0.3107125952287825},
{-0.23535192701565533,-0.1881871343876791,0.3512277701730348},
{-0.25153875411548354,-0.19010731307697593,0.36581854814541},
{-0.2963496276049594,-0.19329844695174445,0.3297793689025101},
{-0.2872049698226238,-0.1816899097304552,0.3107125952287825},
{-0.29477493460576726,-0.1868255973519073,0.3309379668137088},
{-0.24604818857997954,-0.19043755037969015,0.3591623405307469},
{-0.29015103933029424,-0.1891868611536284,0.32360714035160143},
{-0.2872049698226238,-0.23462319805658685,0.3107125952287825},
{-0.23535192701565533,-0.2248755091813568,0.3512277701730348},
{-0.25153875411548354,-0.22679568787065363,0.36581854814541},
{-0.2963496276049594,-0.22998682174542212,0.3297793689025101},
{-0.2872049698226238,-0.21837828452413288,0.3107125952287825},
{-0.29477493460576726,-0.22351397214558497,0.3309379668137088},
{-0.24604818857997954,-0.22712592517336785,0.3591623405307469},
{-0.29015103933029424,-0.22587523594730607,0.32360714035160143},
{-0.017193248620644655,-0.4171174776925423,-0.41192159318338106},
{-0.011046219742022871,-0.396183188870936,-0.4118630874550434},
{0.012438407294336545,-0.4110876838949756,-0.4118569517611256},
{-0.006878224694128856,-0.4255670969262628,-0.41259679904482205},
{0.004130831471293479,-0.4286551679150394,-0.41544362125747913},
{0.01413907070191548,-0.4033951170456644,-0.41510425728476863},
{0.004225704114378996,-0.3922449399201309,-0.4154346623057677},
{-0.022649641555626515,-0.4028608364730023,-0.41508330647569597},
{-0.0222182002445766,-0.4176855674761095,-0.41538046134673917},
{-0.012957201878704765,-0.43081846823463565,-0.4146662609840888},
{-0.020135306866004333,-0.45017795224486007,-0.40100598405562365},
{0.012473208838426546,-0.45051470260763304,-0.39879658916076277},
{-0.008653746362810622,-0.45998585198432307,-0.38894836715033615},
{0.01754232627734821,-0.46255888807361506,-0.37293194182783534},
{0.016110613115923465,-0.4653625228279437,-0.36333113224049357},
{-0.02461914339716979,-0.4634863701883993,-0.36330910523909365},
{-0.02509894348032871,-0.46155408782955143,-0.3728940794250484},
{-0.012710921554042137,-0.39015888784719543,-0.37283586720370904},
{-0.023844802052905366,-0.40224972694939126,-0.37283586720370904},
{-0.05659220247365044,-0.38832124053052974,-0.3728351124714276},
{-0.025333930773816748,-0.3591378676376942,-0.3728859730412844},
{-0.02279127964711571,-0.356401893234747,-0.3632875115099294},
{-0.05589555662480622,-0.3871525515691972,-0.3632876233221192},
{-0.043571910566824294,-0.3943718313954081,-0.4010077450976138},
{-0.04391183360048412,-0.4269783764099929,-0.3987950098135812},
{-0.05523938678868676,-0.40384527292198996,-0.38547641696076596},
{-0.056942845501011884,-0.4334966497119555,-0.3728127779865056},
{-0.05875820026232679,-0.4306172062929104,-0.3633311881465885},
{-0.023964231448186116,-0.41889835236981304,-0.37283586720370904},
{-0.012517668160414639,-0.4308388320297116,-0.3728358951567564},
{0.03002355764039632,-0.4239701672778148,-0.40711610093507206},
{0.016551740157918913,-0.4188670030270846,-0.4147921475333333},
{0.03634459423946812,-0.3939058401176953,-0.3989129576973465},
{0.04847059827537104,-0.4096665509620151,-0.3846288246556278},
{0.04746916637352654,-0.38917136258646323,-0.37286822285614607},
{0.04998734460717474,-0.38889999440170353,-0.36329546415193226},
{0.04898138431164142,-0.4312225574887442,-0.36330910523909365},
{0.048390708465725074,-0.4327243629166795,-0.37282517516305486},
{0.01606229627338566,-0.40221218600665004,-0.37283586720370904},
{0.004796155930456694,-0.39040153427568797,-0.37283586720370904},
{0.018150388918785832,-0.35817678595986085,-0.37282896280098593},
{0.01671745979979649,-0.35762416818806386,-0.36330910523909365},
{-0.012597767617916571,-0.3903092472894927,-0.4146355266084046},
{-0.01940626343515183,-0.3726550668927259,-0.40255194132202504},
{0.012846102491567622,-0.3696506034689076,-0.39760451747522846},
{-0.006951685302858596,-0.3581675195246273,-0.38433949663787387},
{0.014430872564369727,-0.42161320824540277,-0.37283586720370904},
{-0.011915391799801627,-0.39778528983316436,0.4443918391385419},
{-0.018028807138850536,-0.41587516040419537,0.4443902597913603},
{0.003153173636315287,-0.4249445126766688,0.4443622228847561},
{0.008223031830994692,-0.4011973226655002,0.4443808535908894},
{0.005297158400115426,-0.42843737174574037,0.4477235908185673},
{-0.02178367012178215,-0.41977834225695954,0.4476579291100794},
{-0.012268396859673594,-0.3926470025782983,0.44749459945375974},
{0.014202915462318343,-0.4029706639964799,0.4479633580831713},
{-0.056592174520602986,-0.38832145017838565,0.4053118854631708},
{-0.023844816029429092,-0.40224988069115236,0.40531268212502347},
{-0.012612163437359422,-0.39008302327638394,0.40531268212502347},
{-0.02535823594858483,-0.3591468824955006,0.40534238223795166},
{-0.02279111192883094,-0.3564024802487437,0.3957643124547201},
{-0.05589571036656727,-0.38715313858319395,0.39576442426690983},
{-0.024234761041521898,-0.402468166038782,0.4471692958639225},
{-0.04357178477811072,-0.39437194320759794,0.4334856921173504},
{-0.04390940168535494,-0.42697858605784883,0.43127589190330134},
{-0.055240518887108965,-0.4038456922177019,0.41795043657733416},
{-0.058758367980611556,-0.43061832441480885,0.39580789125571314},
{-0.056944410871669744,-0.43349739046771324,0.4052827723642392},
{-0.025096637353913105,-0.4615605449835151,0.40534062119596154},
{-0.012255720152649646,-0.4304496277733766,0.405312654171976},
{-0.02434774725936269,-0.41931687937293555,0.40531268212502347},
{-0.024616334115899877,-0.4634886623382911,0.3957858782308369},
{-0.012361033258962165,-0.4305325924182433,0.44710116031073427},
{-0.020135167100767022,-0.45017811996314494,0.43348401493450267},
{0.012472873401857007,-0.4505158207295315,0.43127530488930466},
{-0.008658009202548554,-0.4599839791301431,0.4214282010007765},
{0.03641302329965473,-0.39526652458551953,0.433705584765209},
{0.016551292909159528,-0.41886711483927447,0.44726889257202906},
{-0.01940623548210437,-0.3726555001649615,0.4350299162948091},
{0.004720584866643583,-0.3898542415594325,0.4471630064282436},
{0.016332881772816363,-0.4191238216506403,0.40531268212502347},
{0.004391563521493881,-0.4305690012625624,0.405312654171976},
{0.018990713431583955,-0.4635481743763374,0.40528813934935193},
{0.047170110695255944,-0.43174446883790435,0.4054045498155068},
{0.048981510100354994,-0.43122229193479333,0.3957858782308369},
{0.016112891289291605,-0.465363752762032,0.395807947161808},
{0.043649410390912254,-0.42915878399463586,0.4217034406826095},
{0.050857564904233314,-0.3904927031399848,0.395807947161808},
{0.012843377069440092,-0.3696582765804359,0.43009086438572747},
{-0.006950874664482202,-0.3581657025765422,0.41681160147069096},
{0.018150682425784177,-0.3581765204059099,0.4053011095633743},
{0.01671727810498799,-0.35762443374201475,0.3957858782308369},
{0.009244198584347253,-0.39399376642848655,0.40531268212502347},
{0.047476210541486936,-0.3891854928519552,0.4053424381440465},
{0.33432203961032086,-0.3823132501099831,0.23212623618596212},
{0.34419508392689363,-0.40372146887478144,0.21889944114101156},
{0.30703597981395836,-0.400338507211806,0.19278035119356268},
{0.29987322104971537,-0.4404576154265714,0.20290597924700068},
{0.33936840326860856,-0.4349681819894896,0.2258324258551182},
{0.3184619976118454,-0.4441713035705917,0.2554449898386829},
{0.28927933752172014,-0.3766570907213152,0.21788126536373742},
{0.3201591808650153,-0.378945802388349,0.25283518151545475},
{0.2724454672557688,-0.3907508635098188,0.24167481550412148},
{0.3077615570669256,-0.3965620644762339,0.27068603955416315},
{0.26850264798170365,-0.41577722690241276,0.24724789843573286},
{0.3059034620960415,-0.4203140065054709,0.27229693174981834},
{0.2773957143603589,-0.4406352570431915,0.23467787421742217},
{-0.3402693160117803,-0.38214275049698965,-0.20576806382357202},
{-0.34934362995017815,-0.4020227621805248,-0.19318079257497736},
{-0.311236512209098,-0.3938331202647233,-0.1686920501442171},
{-0.3112657790497905,-0.426371264172169,-0.16865020443216672},
{-0.34828799708930513,-0.42446264406799766,-0.1946483415432482},
{-0.33920995141907107,-0.44154424821707966,-0.2077543514701161},
{-0.2963436875823738,-0.4458778510946614,-0.18974160335703244},
{-0.3202871499162957,-0.4406596321005782,-0.23444396311626134},
{-0.29704989337344995,-0.3782009235561094,-0.18874356775045453},
{-0.3243438918352915,-0.37904411325627235,-0.22862397091641945},
{-0.2822338278150559,-0.38325406582840665,-0.20968717891338945},
{-0.3112697763355776,-0.4057514750875559,-0.24750670172565833},
{-0.2739112691585733,-0.4122670928500096,-0.22145116303161394},
{-0.28040038743203316,-0.435534343012782,-0.2122792230749556},
{-0.3049378939540906,0.3236302714983761,0.25797236462494605},
{-0.30476269822912344,0.31155234670410753,0.25601488259381144},
{-0.3033793997459026,0.3217031045472137,0.2677724095580722},
{-0.2598161686003153,0.34996954760068194,0.22963622064763176},
{-0.25304564699805693,0.35683038549928947,0.23358060529235466},
{-0.29734043734876836,0.3119669323275379,0.264858010853176},
{-0.2479690940485104,0.34720093801482294,0.22896995976137857},
{-0.2900317217472033,0.35726107207805796,0.1794580545619587},
{-0.2897202968454308,0.3499806449605243,0.18689746463693163},
{-0.2864546261696053,0.34666095502047867,0.17563782337753756},
{-0.33799238655425157,0.3237846841325552,0.21370808502553923},
{-0.33919411601768396,0.31235837282767,0.21038006507735008},
{-0.32817066403281875,0.3181261207818056,0.2134853970729344},
{-0.33086039011874036,0.3232495929215169,0.22550987564045588},
{-0.3251455572834499,0.3133083711221847,0.22150725082134617},
{0.2902524110569146,0.3226712303930075,0.24670450516959821},
{0.29321927763189665,0.3240315374946908,0.2600218401352777},
{0.29961550792864083,0.31737618244797533,0.25177616633583894},
{0.28715068500445284,0.3144026211181261,0.2568273099652426},
{0.24260878971417865,0.3592657668063557,0.22590292344081697},
{0.24821200603095386,0.3496963624678372,0.22085176583488955},
{0.23780542189747678,0.3495297902580121,0.22122354136613215},
{0.27841091313807836,0.35838785942124507,0.16616568166766263},
{0.2797338749683528,0.3535978252081825,0.17971383892275833},
{0.33210888503057634,0.32195764499740137,0.20426389636312617},
{0.3157853395756122,0.32363561053044115,0.21004880748840343},
{0.32262532450081327,0.31469639367042657,0.20362086445931377},
{0.2760146660974588,0.3490988940313878,0.16795710862035018},
{0.31705692370465177,0.3141376402047116,0.2152110365284205},
{0.3211859242513365,0.32412942906690234,0.2181013956124995},
{-0.09547503125832064,-0.0030784341756642103,0.3949058184610717},
{0.08700246257263398,-0.0030784341756642103,0.3949058184610717},
{0.08700246257263398,-0.0015115680297614954,0.3954760606292934},
{-0.09547503125832064,-0.0015115680297614954,0.3954760606292934},
{-0.09547503125832064,0.011888605792071256,0.35540951812028},
{0.08700246257263398,0.012410880530848465,0.35559961281954433},
{-0.09547503125832064,0.049103001032885916,0.35521946535058696},
{-0.09547503125832064,0.05066974139007517,0.3557897075188087},
{0.08700246257263398,0.05066974139007517,0.3557897075188087},
{0.08700246257263398,0.049103001032885916,0.35521946535058696},
{0.08700246257263398,0.03518053849575226,0.39509591316033604},
{-0.09547503125832064,0.035702715398863404,0.3952860078596004},
{-0.09547503125832064,-0.03918256232434192,0.3949058184610717},
{0.08700246257263398,-0.03918256232434192,0.3949058184610717},
{0.08700246257263398,-0.037418655146880565,0.3954760606292934},
{-0.09547503125832064,-0.037418655146880565,0.3954760606292934},
{-0.09547503125832064,-0.024017950217145992,0.3554080505852883},
{0.08700246257263398,-0.023495661501845087,0.3555981173315051},
{-0.09547503125832064,0.07372815433525996,0.39490584641411924},
{0.08700246257263398,0.07372815433525996,0.39490584641411924},
{0.08700246257263398,0.07529500650463919,0.3954760885823409},
{-0.09547503125832064,0.07529500650463919,0.3954760885823409},
{-0.09547503125832064,0.08869476103075988,0.3554095460733275},
{0.08700246257263398,0.08921650466163526,0.3555996407725918},
{-0.09547503125832064,-0.19787197083569116,0.3505219417480994},
{-0.09547503125832064,-0.19630516059588335,0.3510921839163211},
{0.08700246257263398,-0.19630516059588335,0.3510921839163211},
{0.08700246257263398,-0.19787197083569116,0.3505219417480994},
{0.08700246257263398,-0.21179346899268736,0.39039696395242784},
{-0.09547503125832064,-0.2112716554791933,0.39058704467516847},
{-0.09547503125832064,-0.16223039573988857,0.3505219417480994},
{-0.09547503125832064,-0.16066503905854876,0.3510921839163211},
{0.08700246257263398,-0.16066503905854876,0.3510921839163211},
{0.08700246257263398,-0.16223039573988857,0.3505219417480994},
{0.08700246257263398,-0.17615334745535277,0.39039693599938047},
{-0.09547503125832064,-0.17563158984795368,0.39058704467516847},
{-0.09547503125832064,-0.14103502545498853,0.3902068692531636},
{0.08700246257263398,-0.14103502545498853,0.3902068692531636},
{0.08700246257263398,-0.13946965479712492,0.3907771114213853},
{-0.09547503125832064,-0.13946965479712492,0.3907771114213853},
{-0.09547503125832064,-0.1260684746655836,0.35071203644736365},
{0.08700246257263398,-0.12554666115208954,0.35090213114662794},
{-0.09547503125832064,-0.10539490391765405,0.3902068692531636},
{0.08700246257263398,-0.10539490391765405,0.3902068692531636},
{0.08700246257263398,-0.10382953325979034,0.3907771114213853},
{-0.09547503125832064,-0.10382953325979034,0.3907771114213853},
{-0.09547503125832064,-0.09042818540996438,0.35071206440041114},
{0.08700246257263398,-0.0899064278025651,0.3509021590996754},
{-0.09547503125832064,-0.06975482430989055,0.39020689720621105},
{0.08700246257263398,-0.06975482430989055,0.39020689720621105},
{0.08700246257263398,-0.0681880699761776,0.3907771393744328},
{-0.09547503125832064,-0.0681880699761776,0.3907771393744328},
{-0.09547503125832064,-0.054788217614390636,0.35071203644736365},
{0.08700246257263398,-0.05426636217132549,0.35090213114662794},
{0.4822417818547111,0.22199955989324408,0.16752678543119875},
{0.4822417818547111,0.3043501741429433,0.1571604956156379},
{-0.48843756084810647,0.2986904507407238,0.1593330623704678},
{-0.48843756084810647,0.3668325030125173,0.11193440755916377},
{0.4822417818547111,0.36243466403186836,0.11552549363701639},
{0.4822417818547111,0.3988316143292324,0.04006729025303303},
{-0.48843756084810647,0.3985577862762961,0.03439553306388135},
{-0.48843756084810647,0.3906377654797879,-0.036622147035978686},
{0.4822417818547111,0.3884651288423393,-0.042282010203435354},
{-0.48843756084810647,0.33446562742687036,-0.11299649757400043},
{0.4822417818547111,0.3468292183896753,-0.10036733868378421},
{0.4822417818547111,0.25925970029623036,-0.13962728203176222},
{-0.48843756084810647,0.22999955435854072,-0.13784724594591535},
{0.4822417818547111,0.1675515658077735,-0.11562928330224219},
{-0.48843756084810647,0.14312057437306944,-0.0987742525793622},
{0.4822417818547111,0.1166955802507218,-0.06541897121198802},
{-0.48843756084810647,0.09245035079292559,-0.0045471292188809355},
{0.4822417818547111,0.0925531481249664,0.014801103689740087},
{-0.48843756084810647,0.22767240725124677,0.16725299930783366},
{-0.48843756084810647,0.1501383826096991,0.13553038556008742},
{0.4822417818547111,0.1281859599403897,0.11609598738266527},
{-0.48843756084810647,0.10832578094402875,0.07901524963828933},
{-0.32499845437118197,-0.06203069846999494,0.2351629294735039},
{-0.32165401200760896,-0.08059101882980872,0.22693884940322936},
{-0.3218978604171424,-0.08062408728495622,0.2447008167510091},
{-0.3143534726724265,-0.06205949010888065,0.24938940935483261},
{-0.30426391802673797,-0.08059101882980872,0.2461070507096724},
{-0.3009183016351715,-0.06203069846999494,0.23787909914232439},
{-0.3340165687076578,-0.08198001973471188,0.248576898124259},
{-0.29830471965053607,-0.08201947546120418,0.25481463464189447},
{-0.3312286156129553,-0.11216082724360477,0.22183115675881038},
{-0.32505856739974864,-0.11216082724360477,0.2575704137789684},
{-0.291042545872995,-0.11216082724360477,0.24484906573822304},
{-0.32544735236037176,-0.11216082724360477,0.23713276675161676},
{-0.30816128564563006,-0.11216082724360477,0.24905538441418726},
{-0.33669509959807087,-0.17520063771523425,0.2316354505551507},
{-0.3247224180274962,-0.17523251816586455,0.22882414268929385},
{-0.31687317434716133,-0.17531825016243,0.25107310526260224},
{-0.32494400183472627,-0.17520063771523425,0.2575858997672623},
{-0.29050765033328874,-0.17520063771523425,0.24942907472918094},
{-0.29891603882200296,-0.17523251816586455,0.235835479795436},
{-0.3166957144253498,-0.2068908259279247,0.2424387722912538},
{-0.3064609716511444,-0.2067953383177951,0.238778404585267},
{-0.3366993903908562,-0.06061290592620628,0.2316681695972048},
{-0.32491248477371304,-0.06061290592620628,0.25760123201379515},
{-0.33032317447609477,0.33669103941792694,0.2557346812460538},
{-0.3326109217629912,0.33669103941792694,0.22342914862306193},
{-0.2966059989797557,-0.06061290592620628,0.2544053740740056},
{-0.3253332060910613,-0.14859594742727816,0.23222173777261554},
{-0.3368917912165362,-0.160632459781732,0.23313669692213684},
{-0.32655587238704264,-0.16076094596439033,0.2558132991920403},
{-0.31504552024496324,-0.14929072042194239,0.24842641289324813},
{-0.30162895196079414,-0.16063192867383017,0.25787444509968727},
{-0.3012138072764145,-0.14916803449663235,0.24057318590364998},
{-0.28936017773497985,-0.1607607363165344,0.2361826706214359},
{-0.2893213369755316,0.33669103941792694,0.24710149434965137},
{-0.29441267708718544,0.33669103941792694,0.2230491269428181},
{-0.3129581404022733,-0.20672048005669227,0.23652242593681097},
{-0.29022978306499425,-0.060601291434985806,0.2301169990874518},
{-0.3117734063916977,-0.06063370299351782,0.21154939695877417},
{-0.31027326417008644,0.33669103941792694,0.21243806626715755},
{-0.3115617319397929,-0.062059378296690886,0.22365558228402665},
{-0.293194329537037,-0.08204175404003143,0.22532116461704096},
{-0.3040208802555809,-0.08062397547276626,0.22834383945128062},
{-0.32124209590021113,-0.08201947546120418,0.21459790040886859},
{-0.3017206239799453,-0.11216082724360477,0.21677590403142977},
{-0.30731566403033794,-0.11216082724360477,0.22385863322078955},
{-0.3072960689440672,-0.14929060860975252,0.22584588524747107},
{-0.29936179209335334,-0.16076122549486493,0.21723159461115285},
{-0.32057281608483207,-0.16076094596439033,0.21418325887934322},
{-0.30762380444903364,-0.17520063771523425,0.21118149292460503},
{-0.30937148488244337,-0.17520607458296567,0.22373329175597056},
{-0.3129181256148317,-0.20674660217954538,0.22993235523244257},
{-0.3173065583950098,-0.20674245115199724,0.2318206954006804},
{0.13856166294468347,0.1688604672551746,0.4050793999674306},
{0.22992693932949682,0.17891719104661935,0.35536621884976166},
{0.22996956772687616,0.2230079800569541,0.355320389828448},
{0.21681521300442297,0.17915379961686004,0.337396686148054},
{0.2168151291452806,0.22257505723438872,0.3373145041885161},
{0.13856626122099092,0.23307813528770413,0.4050796096152865},
{0.111885929986603,0.17866755635626114,0.40249062631241744},
{0.11188218427824313,0.2232645471030826,0.40248562271692184},
{0.04556605301970517,0.18167129300084553,0.415034011276497},
{0.04556545202918474,0.220257609834564,0.4150340951356394},
{0.045237283251982625,0.23307919750350758,0.42517790664645133},
{0.04542139599909009,0.23307877820779574,0.4061345296734493},
{0.04541695146454366,0.22025793129460997,0.40613461353259167},
{0.04514804314796066,0.16786089423098632,0.42550249743357843},
{-0.036136078481926466,0.23307877820779574,0.4251750833886577},
{-0.07534998316073481,0.1678615371510779,0.42043820189534387},
{-0.10710662974376584,0.23307877820779574,0.41426045261756156},
{-0.14970387345169034,0.16753226422850118,0.40117987996388393},
{-0.1570629464682579,0.23286465786423793,0.39721144172182},
{-0.19487432096719168,0.1778577985008626,0.37652267849259485},
{-0.189329512543088,0.21842172355988837,0.37902545459709147},
{-0.226233433285744,0.2182762838539445,0.34493423937266543},
{-0.2277117302007639,0.17761712276221617,0.3414397590268409},
{-0.22439563222731726,0.21821208968044836,0.32599328236556363},
{-0.22431213647454867,0.17748522630776736,0.32616997357856997},
{0.13861404695562696,0.23307014071612997,0.38042504970698254},
{0.18365294742977284,0.22771741165766055,0.36183920821483606},
{0.13859727512714984,0.16885461109173142,0.3804248680121741},
{0.11092964225640942,0.22302771490846218,0.3941516312640273},
{0.11104837282550362,0.17889192149171368,0.3939841086505884},
{0.04541939735619657,0.18167065008075375,0.406077771010578},
{0.02404957210208712,0.23307877820779574,0.4036270434804552},
{0.04528242742363351,0.16786174679893395,0.40524140185399576},
{-0.044039019966435534,0.23307877820779574,0.4030425312815042},
{-0.05662617940284032,0.1678615371510779,0.4011416541714798},
{-0.1531799886453324,0.2335635259803554,0.3798468129671868},
{-0.15003092410699398,0.16752447930478304,0.38067862577703276},
{-0.19802219750101296,0.1785888685276561,0.3501807188977326},
{-0.1982438931204329,0.21751214537200353,0.3486671452368158},
{-0.20324213560751506,0.21825154540694067,0.3243810344471065},
{-0.2036832207199393,0.1775438718013422,0.32406981919319},
{0.18365618998327843,0.17403661691282785,0.3619192377897193},
{-0.21804683825211582,0.2237383093279899,0.34248057677255916},
{-0.2143438561252734,0.2237383093279899,0.32915896499061803},
{-0.21933005084889948,0.17251156852592794,0.34119736417577556},
{-0.2060084670200058,0.17251156852592794,0.3374943680724094},
{-0.21557126046279948,0.17251156852592794,0.3298796644368032},
{-0.2067291524896672,0.2237383093279899,0.33872175843341173},
{-0.1464490904878512,0.3456980703710842,0.4050798192631425},
{-0.23785306786687552,0.33562812478819,0.3553206414058751},
{-0.1464450652490167,0.27856123763906626,0.4050792602021932},
{-0.11976711002366305,0.28836896966024445,0.40249068221851236},
{-0.11976476196767626,0.335884468209939,0.4024855668108268},
{-0.053448994098755295,0.2913726923283049,0.415034011276497},
{-0.05344875649785188,0.332877656730134,0.4150340951356394},
{-0.05330489613908945,0.34569881112684187,0.423830010697841},
{-0.053060614457320354,0.277561664614878,0.42517388140761686},
{-0.05322084132537168,0.27756240537063565,0.4055294160785189},
{-0.053303163050146825,0.2913721612204031,0.4060779107758153},
{-0.23781073297649452,0.2886187021862685,0.3553670155116143},
{-0.2246993700410377,0.2888543603528957,0.33739663024195904},
{-0.22469902062794442,0.33519509015343485,0.3373145041885161},
{0.14938643864471357,0.3453994898946203,0.3971055136484633},
{0.11540294048868174,0.3457234517381794,0.40996089655178825},
{0.1489042765290441,0.2776141185084402,0.39744961566271864},
{0.18144638976922936,0.3310416586432684,0.3790252868788067},
{0.18878173064850184,0.2875020478227863,0.3748648391537274},
{0.21834970952136495,0.3308961071251346,0.3449346866214249},
{0.21982803438943233,0.28731799098177374,0.3414408072661208},
{0.2165120622046992,0.3308324440595403,0.32599322645946865},
{0.21642927925464095,0.2871864159873709,0.3261702391325208},
{-0.14648064947843564,0.2785550460390534,0.3804251615191724},
{-0.19153985784156255,0.283738337700333,0.3619201183107144},
{-0.19153601429753656,0.34033765422456247,0.3618396834166429},
{-0.14649683429291604,0.3456901736351761,0.380425133566125},
{-0.11881350578602577,0.3356475381796523,0.39415139366312385},
{-0.11892916151989917,0.28859278971127145,0.3939850450776784},
{-0.053300856923731224,0.33287807602584585,0.4061345855795442},
{-0.031932219674138895,0.34569881112684187,0.4036270434804552},
{-0.05330535736437258,0.34569881112684187,0.4061345296734493},
{0.03635025473157914,0.34569881112684187,0.4027496112971515},
{0.04084844515261626,0.2775619860749238,0.4027313300041115},
{0.14532877427515145,0.34608621241161575,0.3798949061853448},
{0.14287125415449548,0.27715997932285125,0.38023392074496215},
{0.19013516130050967,0.28828941528716806,0.35018263368148367},
{0.19036012742648264,0.33013229010323963,0.3486672850020531},
{0.19535951598851073,0.3308713686781308,0.32438113228277266},
{0.19579951093208395,0.28724292307281496,0.3240700567940934},
{0.00940899577565859,0.34569881112684187,0.42677631780641484},
{0.07558973644881507,0.2775619860749238,0.4192657252960803},
{0.21226048754489427,0.28221190563758386,0.3387218143395067},
{0.20464645478242716,0.28221190563758386,0.32915885317842825},
{0.20646122252974536,0.33635834224703604,0.32915882522538076},
{0.21180537000264416,0.33635834224703604,0.3398203691047573},
{0.20094234055716254,0.28221190563758386,0.34248001771160996},
{0.19965841515766858,0.33635834224703604,0.3411962740069245},
{0.3148326577885412,-0.08210990356974336,0.25052437296440233},
{0.32906816650420007,-0.08210990356974336,0.22553539677278853},
{0.3140515657833147,-0.06729640969171587,0.2522376711494341},
{0.3278604411120871,-0.06767015591280455,0.22722940735507158},
{0.3161721957759605,-0.08214178402037355,0.23697775312691707},
{0.29463987945695536,-0.0821737762831937,0.2401938211200215},
{0.28998836657058996,-0.08210990356974336,0.24887805028108922},
{0.2810753137629995,-0.08210990356974336,0.22539619059642851},
{0.29546909263338733,-0.08214178402037355,0.21846660217758856},
{0.3039256022933072,-0.05620110439835002,0.24143890576006719},
{0.3157091954743262,-0.05620131404620585,0.2335034968109312},
{0.31129141199431304,-0.03366454689623037,0.24136590637662056},
{0.2914881454025843,-0.055506387309780664,0.22690056770473035},
{0.29139004418251696,-0.03366454689623037,0.22590107853968447},
{0.2895899378085925,-0.06773755071023493,0.24722557792733452},
{0.28024120880326164,-0.06754166973014601,0.22769790043053217},
{0.30873194710956375,-0.11377567479547586,0.23538758811595478},
{0.2972204209394909,-0.11371435978586829,0.2282231381923403},
{0.28996253795473526,0.01788337442116832,0.2488559533970707},
{0.31844986598924696,0.01788337442116832,0.24907177887652365},
{0.32016117950790884,0.339797992690264,0.24873945907177342},
{0.3274588676322502,0.01788337442116832,0.22204853363239743},
{0.28497659480853627,0.339797992690264,0.2451661371555828},
{0.2810807785837783,0.017894988912388592,0.22536797199501582},
{0.28624405586307516,0.339797992690264,0.2132582925388306},
{0.3112988754579854,0.01635799059769893,0.2413401057138133},
{0.2913952993554398,0.01640640527590277,0.22592215513747071},
{0.2862199463596393,-0.003524369141823188,0.24420691435540565},
{0.31920149548244864,-0.003524047681777394,0.24749668055814328},
{0.3124665860626567,-0.0020049672705106246,0.24057556191268423},
{0.29112077247631696,-0.0020609432480528708,0.22722784198441373},
{0.28950974051542444,-0.0035245787896792183,0.21122507172559804},
{0.2877191801072082,-0.03366454689623037,0.24587905167804977},
{0.3208737585938063,-0.03366454689623037,0.2459972790922897},
{0.2878374354744956,-0.03366454689623037,0.2127244871679754},
{0.30744078187077717,-0.11363741902272954,0.22335753291546465},
{0.30056483535001643,0.017862577353856577,0.20464818088310796},
{0.3216469398866011,0.339797992690264,0.21008279839411703},
{0.31111112881470787,0.01645535106200843,0.21884312972689968},
{0.2950657720880841,-0.06766994626494852,0.2076652511313315},
{0.3103713653901537,-0.05607868402699068,0.2184913406245923},
{0.3164495738659244,-0.06767058918504011,0.20909367980967947},
{0.3005300477824502,-0.08210990356974336,0.20464836257791644},
{0.3134099874379704,-0.08212418757699626,0.2191744991280362},
{0.3100882010193652,-0.002117142849975041,0.21825341826112077},
{0.3224913874738998,-0.0035245787896792183,0.21451500564662046},
{0.31112776087794763,-0.03366454689623037,0.2188505512610008},
{0.32099201396109367,-0.03366454689623037,0.212842728558739},
{0.2794251475356604,-0.12248391562431332,0.257568457065646},
{0.29420343455040976,-0.10494757129912194,0.23197426944343577},
{0.3024041318964824,-0.10449822606117268,0.2394725905659346},
{0.2882961030537733,-0.12631483884938868,0.2639111153469296},
{0.2859951759049986,-0.16336310912913762,0.2570433311160278},
{0.28188753148657475,-0.12605583988813088,0.27500939763985016},
{0.2724247540475995,-0.131986148789781,0.2696948105146423},
{0.2908565462951838,-0.07600209281671057,0.24862302065257108},
{0.3002060160562724,-0.07600370011693953,0.23242860430035697},
{0.3125697328077909,-0.10449833787336264,0.22186679689432423},
{0.30197425595609034,-0.10494757129912194,0.2185135772738482},
{0.31675233332298375,-0.1224855089480187,0.19291845322454795},
{0.3266787679602086,-0.1263151044033396,0.19742959988308362},
{0.3195803571112228,-0.16336331877699364,0.1988710546815488},
{0.3330859838046053,-0.12605252745200668,0.1863311918014495},
{0.3237520279848581,-0.13198683363944377,0.1807927147425959},
{0.3147195737350343,-0.07600390976479557,0.20729055450662914},
{0.3053695029834253,-0.07600326684470397,0.22348594921550438},
{0.3543398877708905,-0.2219606492511775,0.21234431174597052},
{0.3393137969903918,0.37254927858460624,0.2343148759430826},
{0.3006302594576009,-0.2219030659734061,0.28795688583456197},
{0.332846440164381,-0.2332056291371778,0.2504567685191158},
{0.2935623174303485,-0.23340689107890314,0.29661328773688145},
{0.30145138022679274,0.37210995451417217,0.28990458429908494},
{0.29954897967568167,0.37095587102013855,0.2865511270777055},
{0.35668491085203624,0.3720831894712275,0.21212296553964388},
{0.35263287902153767,0.3700852174508442,0.21109826272578738},
{0.36120223513406097,-0.23323948027765415,0.20348520831998143},
{0.3599462208524577,0.38310003056036784,0.20245202175622026},
{0.3296479965677013,0.3829116130439512,0.2549385644778166},
{0.29398131963527785,0.38302527013493115,0.2969925127552726},
{0.29454189004907777,0.3730955649911533,0.2858821687223723},
{0.35058248106063983,0.37226584865986695,0.20665332286016508},
{0.30331937057647834,-0.22696912255363064,0.2808654912004891},
{0.295511287758531,-0.22293527418050607,0.28647397666671076},
{0.35350516784410846,-0.22544646415228875,0.20882313623981996},
{0.34980797199809066,-0.22351230893926102,0.207878658672179},
{0.35432036256723837,0.37462542130221665,0.20796415306784105},
{0.29570255648578875,0.37434828081315613,0.2895033322792938},
{-0.3588490497630564,0.3705976946464862,0.21881292645911712},
{-0.36183273009608674,0.3644139773930707,0.21319251901815287},
{-0.361480130355403,-0.21932993204844783,0.21432517650130703},
{-0.3136204319557869,-0.22087731492026977,0.28221011664254636},
{-0.33655677394270594,-0.2330105448189415,0.2555821973721494},
{-0.36813073338405,-0.2332932759174944,0.2028691511069697},
{-0.36723792702464225,0.3829645002097492,0.2022067197882188},
{-0.3390990197502188,0.3829123537997091,0.25015523899614495},
{-0.31025791794702984,0.36907018639140965,0.28597701341241033},
{-0.3095444862931848,-0.21469071850296575,0.28743468097840336},
{-0.3009784426167857,-0.23325531567904123,0.2961613708185657},
{-0.3009192380622615,0.3829820966531263,0.29602783911084046},
{-0.36044465164174994,0.3635679504585902,0.20841636349315515},
{-0.3559879435431462,0.3732572174646252,0.21502626688469767},
{-0.3586891583315746,-0.2221444824678103,0.2108627163713501},
{-0.32049758045758847,-0.22609399649674256,0.27087994984440605},
{-0.3056268107853116,-0.22146347634902103,0.28468127785036373},
{-0.31061081119471196,0.3734985221468396,0.27890230674767214},
{-0.3044381773246151,0.3666882373345667,0.2868966686739051},
{-0.022194719684708646,-0.38432711343784837,-0.05772816540466693},
{0.014467099713880284,-0.38432711343784837,-0.05772816540466693},
{0.014467099713880284,-0.38432711343784837,0.0656579837443106},
{-0.022194719684708646,-0.38432711343784837,0.0656579837443106},
{0.05112752146009612,-0.20312425061810663,0.14115360228232163},
{0.05112756338966731,-0.2471440808174596,0.06594482394084035},
{0.05112752146009612,-0.25199132094215276,-0.03533299441660937},
{0.05112752146009612,0.045745881962289035,-0.13333130533973997},
{0.05112753543661985,-0.20625956225709385,-0.1326916697311942},
{-0.058855141430924476,-0.20312425061810663,-0.13322372803658306},
{-0.058855155407448206,-0.2471422778458983,-0.058019352300077015},
{-0.05885512745440075,-0.25199116720039183,0.04326664232375531},
{-0.058855141430924476,0.045748341830465625,-0.1333327169686368},
{-0.05885511347787702,-0.20655659133942342,0.1401110654241845},
{-0.058855141430924476,0.045744498286439596,0.14126266109699404},
{0.05112752146009612,0.04574866329051142,0.14126405874936712},
{-0.022194691731661182,-0.20634838306540387,-0.13237633140277708},
{0.014467099713880284,-0.20312563429395597,-0.1332209187553131},
{-0.022194719684708646,-0.20312707387590032,0.14115220462994854},
{0.014467071760832822,-0.20634993445953795,0.14030704423993953},
{0.014467127666927747,-0.25199276052409714,0.043256048118767265},
{0.014467085737356554,-0.24714258532942038,-0.05801820622513108},
{-0.02219476161427984,-0.2471443463714105,0.06594046326543632},
{-0.022194719684708646,-0.25199175421438846,-0.035330268994481835},
{-0.08710449119586976,-0.05092545586825646,0.05938397814759336},
{-0.04178840830309217,-0.05087235905460267,0.05938397814759336},
{-0.08710449119586976,-0.05092545586825646,-0.02794273977559809},
{-0.09946436440336225,-0.14758262150373863,-0.027942753752121824},
{-0.09940933882943359,-0.14846634312272128,0.05938396417106963},
{-0.09362776809332804,-0.17024734372847083,-0.027942753752121824},
{-0.0876549006769173,-0.1763743302720624,0.05938396417106963},
{-0.07936415258844629,-0.18672200335801364,-0.027942767728645554},
{-0.07929414418107807,-0.18677782559379505,0.05938396417106963},
{-0.06742048628113699,-0.19249577519387737,-0.027942767728645554},
{-0.06733367809224422,-0.19251560788105154,0.05938395019454589},
{-0.041787038603766535,-0.19251683781513992,-0.027942767728645554},
{-0.041787010650719075,-0.19249641811396895,0.05938395019454589},
{-0.04178840830309217,-0.05087235905460267,-0.02794273977559809},
{-0.04178840830309217,-0.13441426230450707,-0.027942753752121824},
{-0.06736963968780389,-0.13441426230450707,-0.027942753752121824},
{-0.07930978391113298,-0.14016420416740955,-0.027942753752121824},
{-0.08757270474085574,-0.15052504313871534,-0.027942753752121824},
{-0.09052175124808089,-0.16344488576948726,-0.027942753752121824},
{-0.08757270474085574,-0.17636479828287796,-0.027942753752121824},
{-0.09052175124808089,-0.16344488576948726,0.05938396417106963},
{-0.08757270474085574,-0.15052504313871534,0.05938396417106963},
{-0.07930978391113298,-0.14016420416740955,0.05938396417106963},
{-0.06736963968780389,-0.13441426230450707,0.05938396417106963},
{-0.04178840830309217,-0.13441426230450707,0.05938396417106963},
{-0.03673761408678174,-0.1424461372204339,0.15421745901361708},
{-0.030175370641161648,-0.17596108639491015,0.15421745901361708},
{-0.032370886847957706,-0.15095349347368678,-0.122776262571193},
{-0.05279269847392226,-0.13130785411659543,-0.12277624859466926},
{-0.03557148282929203,-0.14157004678340834,-0.1391134491133185},
{-0.027947163345358957,-0.16948577692689643,-0.1391134491133185},
{-0.031899542561655995,-0.17954131271382387,-0.122776262571193},
{-0.06706017149935375,-0.19608037616471885,0.15421745901361708},
{-0.052873482781087,-0.1956713392212096,0.1755363817682985},
{-0.028573563185931548,-0.17223033291541445,0.17055463157921885},
{-0.03381629700263876,-0.14377105576403068,0.17055463157921885},
{-0.05347417979451842,-0.1315924021632333,0.17155099000294902},
{-0.06182815767634815,-0.1315042102984912,0.1542174729901408},
{-0.06953355497444433,-0.1951630689592108,-0.122776262571193},
{-0.09212491442611288,-0.16949558844655557,-0.122776262571193},
{-0.09164276628696716,-0.17160781854843898,0.15421745901361708},
{-0.09272867229824137,-0.17654169914374024,0.17055463157921885},
{-0.06801395743179953,-0.19529594377032067,0.17693126678969226},
{-0.05347417979451842,-0.13159234625713842,-0.14010977958400123},
{-0.06801395743179953,-0.1315924021632333,0.17232593233773386},
{-0.08591668235007338,-0.14157010268950324,0.17055463157921885},
{-0.0863920518752096,-0.14437779063571385,0.15421745901361708},
{-0.08504071770176139,-0.14268323496900534,-0.122776262571193},
{-0.06801395743179953,-0.13159234625713842,-0.14088472191878607},
{-0.08767185420020292,-0.14377105576403068,-0.1391134491133185},
{-0.09291458801691013,-0.17223038882150934,-0.1391134491133185},
{-0.06861465444523095,-0.19567128331511474,-0.14366818854937094},
{-0.052421454050581434,-0.19607334597328216,-0.14409518532587443},
{0.07517832349627157,-0.05092545586825646,-0.02794273977559809},
{0.029862240603493993,-0.05087235905460267,-0.02794273977559809},
{0.029862240603493993,-0.05087235905460267,0.05938397814759336},
{0.07517832349627157,-0.05092545586825646,0.05938397814759336},
{0.08753677109834351,-0.1475830547759743,-0.027942753752121824},
{0.08748173154789113,-0.14846655277057721,0.05938396417106963},
{0.08170020274135677,-0.17024734372847083,-0.027942753752121824},
{0.07572734930146977,-0.1763743302720624,0.05938396417106963},
{0.06743658723647501,-0.18672200335801364,-0.027942767728645554},
{0.0673665788291068,-0.18677782559379505,0.05938396417106963},
{0.05549431858153882,-0.19249577519387737,-0.027942767728645554},
{0.05540751039264604,-0.19251560788105154,0.05938395019454589},
{0.029860870904168356,-0.19251683781513992,-0.027942767728645554},
{0.029860842951120892,-0.19249641811396895,0.05938395019454589},
{0.029862240603493993,-0.13441426230450707,-0.027942753752121824},
{0.05544347198820571,-0.13441426230450707,-0.027942753752121824},
{0.06738221855916171,-0.14016420416740955,-0.027942753752121824},
{0.07564513938888447,-0.15052504313871534,-0.027942753752121824},
{0.0785941858961096,-0.16344488576948726,-0.027942753752121824},
{0.07564513938888447,-0.17636479828287796,-0.027942753752121824},
{0.0785941858961096,-0.16344488576948726,0.05938396417106963},
{0.07564513938888447,-0.15052504313871534,0.05938396417106963},
{0.06738221855916171,-0.14016420416740955,0.05938396417106963},
{0.05544347198820571,-0.13441426230450707,0.05938396417106963},
{0.029862240603493993,-0.13441426230450707,0.05938396417106963},
{0.019972885683727234,-0.17954185779824938,-0.122776262571193},
{0.0182486299040905,-0.17596135194886106,0.15421745901361708},
{0.027238651427867164,-0.1381585590354981,-0.12277624859466926},
{0.01601959799338768,-0.16948577692689643,-0.1391134491133185},
{0.023643903500797026,-0.14157004678340834,-0.1391134491133185},
{0.041546614442547154,-0.13159234625713842,-0.14010977958400123},
{0.061698203958698,-0.13419678759525386,-0.12277624859466926},
{0.04990057834785316,-0.1315042102984912,0.1542174729901408},
{0.02481122276280387,-0.14244513091072525,0.15421745901361708},
{0.021888731650667487,-0.14377105576403068,0.17055463157921885},
{0.016645997833960275,-0.17223038882150934,0.17055463157921885},
{0.040945931405639464,-0.1956713392212096,0.1755363817682985},
{0.055132508311716365,-0.19608064171866976,0.15421745901361708},
{0.05026739221317127,-0.1953058531256459,-0.12277627654771672},
{0.04049390267513389,-0.19607334597328216,-0.14409518532587443},
{0.041546614442547154,-0.1315924021632333,0.17155099000294902},
{0.056086168455448566,-0.1315924021632333,0.17232593233773386},
{0.056086168455448566,-0.13159229035104344,-0.1454900843237919},
{0.07446549283294694,-0.14437816800185452,0.15421745901361708},
{0.07399020716695312,-0.1415696274876964,0.17055463157921885},
{0.08080278412911782,-0.17654090248188758,0.17055463157921885},
{0.0797157040898502,-0.17160888076424255,0.15421745901361708},
{0.05608756610782165,-0.19529598569989187,0.17693126678969226},
{0.07574544889970132,-0.14377062249179504,-0.1391134491133185},
{0.07971578794899259,-0.1552804714790201,-0.122776262571193},
{0.0809882665755509,-0.17223129729555184,-0.1391134491133185},
{0.0744650595607113,-0.1825115616075488,-0.122776262571193},
{0.05668748043592414,-0.19567117150292487,-0.14056270281202557},
{-0.02482370379849561,-0.2617921206075604,-0.09540465247307355},
{-0.05917240851961648,-0.2617921206075604,-0.09540465247307355},
{-0.05917240851961648,-0.2617921206075604,0.10495580347159941},
{-0.02482370379849561,-0.2617921206075604,0.10495580347159941},
{-0.022965021813614834,-0.3664195805954111,0.16740437903636332},
{-0.10235995070731659,-0.4845382854337251,0.2339385021355325},
{-0.022345652164478903,-0.4765421345124545,0.23188635710916827},
{0.016089760142516927,-0.4745927868181313,0.23161855293796005},
{0.09610407266187836,-0.4845369995935418,0.2339387676894834},
{0.016709199674271515,-0.3666839185887341,0.16670605600467137},
{0.052916516497654505,-0.2617921206075604,0.10495580347159941},
{0.01856781177653363,-0.2617921206075604,0.10495580347159941},
{-0.02333577705862508,-0.3669889003130665,-0.15824011219123316},
{-0.10235975503598435,-0.48455203833307636,-0.22438223572932112},
{-0.022344184629487156,-0.4765344474244025,-0.22233298384336916},
{0.09610387699054612,-0.48455086430508293,-0.22438248730674823},
{0.016089592424232156,-0.47067153332018297,-0.22152371516630118},
{0.017080849416800537,-0.36620418838819374,-0.15682150900906805},
{0.052916516497654505,-0.2617921206075604,-0.09540465247307355},
{0.01856781177653363,-0.2617921206075604,-0.09540465247307355},
{-0.0505405074633973,-0.5117831843677,-0.17256628661633455},
{0.044284615441435325,-0.5117831843677,-0.17256628661633455},
{0.044284615441435325,-0.511783240273795,0.18211735375571803},
{-0.0505405074633973,-0.5251566490526829,0.18211735375571803},
{0.044284615441435325,-0.5296144612966613,0.18211735375571803},
{-0.09337504459122546,-0.5099594995982415,-0.21475421385027518},
{0.08714614123658788,-0.5097755126398476,-0.21542693189049206},
{0.08394110072070712,-0.5097719905558674,0.2249794106587724},
{-0.09018371504512473,-0.5099560334203562,0.22430568630884687},
{-0.08709330997688501,-0.5296144193670902,-0.20911908912982224},
{-0.08709330997688501,-0.5296145172027563,0.21867015626920575},
{-0.0505405074633973,-0.5296144193670902,-0.17256628661633455},
{0.044284615441435325,-0.5296144193670902,-0.17256628661633455},
{0.08083741795492304,-0.5296144193670902,-0.2091177054539729},
{0.08083741795492304,-0.5296145172027563,0.21867015626920575},
{-0.0388826890194329,-0.4547925251790047,0.1551133402082456},
{-0.0388826890194329,-0.38941245762082166,0.14310508838477576},
{-0.0993367587416989,-0.396098155700557,0.14603764259399837},
{-0.0993367587416989,-0.3282379819593689,0.08963307495143562},
{-0.0388826890194329,-0.3247369186708671,0.08427453165909397},
{-0.0993367587416989,-0.30481953376287535,0.030445837340140648},
{-0.0388826890194329,-0.300360156148239,-0.00048788550213724126},
{-0.0993367587416989,-0.3054542636115916,-0.03142705918867019},
{-0.0388826890194329,-0.3282214477317951,-0.08332228314425856},
{-0.0993367587416989,-0.3399002589144034,-0.09832088210257846},
{-0.0388826890194329,-0.39609656237685165,-0.13974729844103967},
{-0.0993367587416989,-0.39150528830776654,-0.13553429898673205},
{-0.0993367587416989,-0.45398244586356024,-0.15035261476544678},
{-0.0388826890194329,-0.45479246927290967,-0.1488243517780888},
{-0.09933674476517518,-0.4547925251790047,0.1551133262317219},
{-0.0999898257895501,-0.4546207956319228,-0.057518140182562315},
{-0.09972269249148093,-0.45469106959324185,0.06395437129022444},
{-0.09870011410923155,-0.34436784074846977,0.06459839552722171},
{-0.0998671678172875,-0.3215235481468427,0.06386341207378358},
{-0.0996903647920913,-0.321412169229231,-0.05770672541726369},
{-0.09870011410923155,-0.34436784074846977,-0.05833035790613755},
{0.032626796997470925,-0.4547925251790047,0.1551133402082456},
{0.0930808527432132,-0.4547925251790047,0.1551133262317219},
{0.0930808527432132,-0.396098155700557,0.14603764259399837},
{0.032626796997470925,-0.38941245762082166,0.14310508838477576},
{0.0930808527432132,-0.3282379819593689,0.0896330190453407},
{0.032626796997470925,-0.3247369186708671,0.08427448972952277},
{0.0930808527432132,-0.30481936604459064,0.03044540406790499},
{0.032626796997470925,-0.30036005831257295,-0.00048743825337785123},
{0.0930808527432132,-0.3054542636115916,-0.03142704521214646},
{0.032626796997470925,-0.3282214477317951,-0.08332224121468737},
{0.0930808527432132,-0.3399003148204984,-0.09832091005562592},
{0.032626796997470925,-0.39609656237685165,-0.13974728446451595},
{0.0930808527432132,-0.39150528830776654,-0.13553428501020834},
{0.0930808527432132,-0.45398244586356024,-0.15035261476544678},
{0.032626796997470925,-0.45479246927290967,-0.1488243517780888},
{0.09373393376758812,-0.4546207956319228,-0.057518154159086045},
{0.09346680046951895,-0.4546910136871469,0.06395437129022444},
{0.09244422208726957,-0.3443677848423749,0.064598381550698},
{0.09244422208726957,-0.3443677848423749,-0.05833035790613755},
{0.0934344587936056,-0.32141222513532586,-0.05770672541726369},
{0.09361126181880179,-0.3215235481468427,0.06386341207378358},
{-0.4269618631472047,0.2721645740700864,0.19199734440458507},
{-0.4269618631472047,0.33822942140846607,0.1724602607073118},
{-0.5020605484112576,0.2986401212787689,0.18865691330332285},
{-0.5020605484112576,0.389748131791267,0.13358161090323714},
{-0.4269618631472047,0.39245499309528276,0.1270381519055114},
{-0.4269618631472047,0.4327835814477273,0.04912149197378211},
{-0.5020605484112576,0.43604227783821103,0.028547797464433592},
{-0.4269618631472047,0.42908152177145115,-0.03550546471944899},
{-0.5020605484112576,0.4172151456403738,-0.07063056533382273},
{-0.4269618631472047,0.39828864035880973,-0.10151585952137297},
{-0.5020605484112576,0.37237856932375674,-0.12803564242766374},
{-0.4269618631472047,0.3122497193321858,-0.16645165531972106},
{-0.5020605484112576,0.29997930985309484,-0.16940925545946953},
{-0.4305149051274618,0.022232379427901582,-0.17187604201535908},
{-0.5016142780085291,0.022439343791309147,-0.17172330656402754},
{-0.5012378762479315,0.022209234304603014,0.1915785378709879},
{-0.4296327349026133,0.02248253124963751,0.1913548296321507},
{-0.42875998485475936,-0.04167914682882571,-0.09019867691377864},
{-0.42898102357756396,-0.04149894750836302,0.108107663314684},
{-0.4966739542357878,0.028595345598166056,0.1395295861308831},
{-0.4966739542357878,-0.028017933473270522,0.07281262214826593},
{-0.43234837346353194,-0.028017933473270522,0.07281262214826593},
{-0.43234837346353194,0.028595345598166056,0.1395295861308831},
{-0.4269618631472047,-0.47125267717691477,0.10798794041240489},
{-0.4269618631472047,-0.47125267717691477,-0.09007443959433446},
{-0.43234837346353194,0.028595345598166056,-0.12164832915305991},
{-0.43234837346353194,-0.028017933473270522,-0.0549034540525521},
{-0.4966739542357878,-0.028017933473270522,-0.0549034540525521},
{-0.4966739542357878,0.028595345598166056,-0.12164832915305991},
{-0.49975327592070906,-0.04148114141712969,-0.0901985651015888},
{-0.5020605484112576,-0.47125267717691477,-0.09007892605845211},
{-0.5007121772608403,-0.041677651340786506,0.10810780307992131},
{-0.5020605484112576,0.1882797288573962,0.020894546576377505},
{-0.5020605484112576,0.21219140857635405,0.057315550471082596},
{-0.5020605484112576,0.264233036618024,0.06270077494722659},
{-0.5020605484112576,0.2951922666161107,0.03173019601187025},
{-0.5020605484112576,0.29725655724159705,-0.011795955416258982},
{-0.5020605484112576,0.2623957526909752,-0.04483807879291807},
{-0.5020605484112576,0.22305543035502057,-0.0437276020529249},
{-0.5020605484112576,0.19333623947191267,-0.0181395081950613},
{-0.5020605484112576,-0.47125267717691477,0.10798345394828728},
{-0.4966739542357878,-0.07006075643783678,0.10810054926410495},
{-0.43234837346353194,-0.07006075643783678,0.10810054926410495},
{-0.45170871004170393,0.22276176961491007,0.06270140389079448},
{-0.45170871004170393,0.2662858105879561,0.0606365821574063},
{-0.45170871004170393,0.2972563475937412,0.029677645666317826},
{-0.45170871004170393,0.29187119300021586,-0.022364723131109723},
{-0.45170871004170393,0.19544979734355045,-0.024160538712248793},
{-0.45170871004170393,0.2466044612127321,-0.04859583491626199},
{-0.45170871004170393,0.18971756373621523,0.0278401800444606},
{-0.43234837346353194,-0.07006075643783678,-0.09019138116839111},
{-0.4966739542357878,-0.07006075643783678,-0.09019138116839111},
{-0.517209646577112,0.19689060922192403,0.17907797697561992},
{-0.517209646577112,0.2290181088856314,0.16817606484111888},
{-0.5420012043710264,0.21933876521144552,0.17785542249182848},
{-0.5420012043710264,0.23024064939289923,0.14572793680464483},
{-0.517209646577112,0.22310939371314567,0.13505505796452244},
{-0.5420012043710264,0.2019026605144525,0.127594012230814},
{-0.517209646577112,0.19976307835562748,0.12975620840503554},
{-0.517209646577112,0.17875671260114084,0.15074001605022058},
{-0.5420012043710264,0.1809188947988385,0.14860051775053806},
{-0.5420012043710264,0.18621788412356274,0.17194681913153254},
{-0.5424420798355949,0.21004489406175875,0.15137018955220052},
{-0.5432888475258327,0.20494680328914286,0.15988221396437957},
{-0.5423899334255547,0.2019544854644466,0.1503075125233671},
{-0.5463781484486978,0.20562199517405993,0.1544592249211146},
{-0.517209646577112,0.10255462271810267,0.17785497524306906},
{-0.517209646577112,0.13567571345384147,0.17194669334281895},
{-0.5420012043710264,0.12500255508324443,0.1790781027643335},
{-0.5420012043710264,0.14313689895278728,0.1507401138858867},
{-0.517209646577112,0.14097470277856572,0.14860051775053806},
{-0.517209646577112,0.11999190144308931,0.12759434766738353},
{-0.5420012043710264,0.1176258297172047,0.1283725884617689},
{-0.5420012043710264,0.09002819127730875,0.14761665433902335},
{-0.517209646577112,0.09165305999669494,0.14572718207236338},
{-0.5420012043710264,0.10140661901189196,0.17503954430271157},
{-0.5423898775194598,0.11993901427729135,0.158611202872813},
{-0.5424420798355949,0.11184849386778965,0.15754846993788466},
{-0.5463781484486978,0.11627245497129189,0.15445925287416207},
{-0.543288581971882,0.1169466964525953,0.14903623587784967},
{-0.4939569040459723,0.01286471223291534,-0.014651051730964846},
{-0.4939569040459723,0.01286471223291534,0.03405853112368129},
{-0.5629180644675403,-0.024495444173889363,0.029806858628210225},
{-0.5639811887451331,-0.022654330679338266,-0.012525725626345489},
{-0.5183123942994821,0.055048712063687555,0.03405853112368129},
{-0.584084056099558,0.012164991548850234,0.03193267391116016},
{-0.5183123942994821,0.055048712063687555,-0.014651051730964846},
{-0.5851473480954356,0.01400610504340133,-0.01039933730592259},
{-0.5752695098312232,-0.026716816949587593,0.027681029368736558},
{-0.5752695098312232,-0.026716816949587593,-0.008274975581440665},
{-0.5932461286304623,0.004420180453832846,0.027681043345260288},
{-0.5932461286304623,0.00442156412968229,-0.008274961604916939},
{-0.580379648367295,-0.02268098391009318,0.009703012917124216},
{-0.5872903405260509,-0.012899807284003868,0.021629278452388493},
{-0.5923064310339373,-0.0020237237653574413,0.009703082799742871},
{-0.5872902287138609,-0.012899807284003868,-0.0022231967120451396},
{-0.5412912528715905,-0.47125267717691477,-0.05680013820545725},
{-0.5412912528715905,-0.47125267717691477,0.07495375570122496},
{-0.539665363865972,-0.28543040554581767,-0.05459481047900208},
{-0.5002686881863342,-0.47125267717691477,-0.05680013820545725},
{-0.5002686881863342,-0.28534668616866943,-0.05459481047900208},
{-0.5412912528715905,0.03819854517106584,-0.05680005434631486},
{-0.5412912528715905,0.03819854517106584,0.07495244190799426},
{-0.5395066464624837,-0.2852458735029983,0.0727477990312019},
{-0.5002686881863342,-0.28534668616866943,0.07274805060862906},
{-0.5002686881863342,0.16698235790230798,0.07432859977126444},
{-0.5798930277405554,0.16986270979539564,0.07472402358065976},
{-0.5798930277405554,0.06887701476044596,0.074952455884518},
{-0.5798930277405554,0.15072581590210984,0.020432273053977164},
{-0.5798930277405554,0.06887701476044596,-0.05680005434631486},
{-0.5798930277405554,0.16615595400714583,-0.05398980869626154},
{-0.5002686881863342,0.16993095716077364,-0.05670786519578568},
{-0.5002686881863342,-0.47125267717691477,0.07495375570122496},
{-0.5002686881863342,0.15072581590210984,-0.0022781663798788665},
{-0.4579603671769755,0.023392109437522526,0.16231892304120019},
{-0.4579603671769755,0.009011873818629895,0.13750465339622298},
{-0.4709333625274961,0.010811085695035607,0.13763431360687475},
{-0.4709333625274961,0.02254886383126464,0.16607782523949005},
{-0.4579603671769755,0.008521689178338907,0.17950375779455882},
{-0.4709333625274961,-0.0019037632621748918,0.18241909292654496},
{-0.4579603671769755,-0.014552712909994216,0.1775994843892678},
{-0.4709333625274961,-0.0194406386952681,0.17111536971130356},
{-0.4579603671769755,-0.01936578043416538,0.14616484293647355},
{-0.4709333625274961,-0.01780286964447826,0.14515090204588987},
{-0.4905242418646098,0.024714344488562797,0.16161584799143974},
{-0.4905242418646098,-0.006334768533637618,0.18480796036263464},
{-0.4905242418646098,0.009185042947656003,0.13721535333151655},
{-0.4807288371373622,-0.048223821784115974,0.06415834467755355},
{-0.4383694738633381,0.012554629077420974,0.13886477880309794},
{-0.4383694738633381,-0.048223821784115974,0.06415835865407728},
{-0.4579603671769755,-0.048223821784115974,0.06415835865407728},
{-0.4383694738633381,0.024262860842482747,0.16417624930327906},
{-0.4383694738633381,-0.007840627153454746,0.18408934341848543},
{-0.4905242418646098,-0.07548930813754652,0.09160126299974819},
{-0.4709333625274961,-0.07548930813754652,0.09160126299974819},
{-0.4481648925671094,-0.07548930813754652,0.09160124902322446},
{-0.4709333625274961,0.018388807448849784,-0.1255610010654374},
{-0.4709333625274961,0.00039512331413498136,-0.11637518242071421},
{-0.4579603671769755,0.002976796895092721,-0.11646890898885377},
{-0.4579603671769755,-0.0247995593537506,-0.14161601556995923},
{-0.4709333625274961,-0.02120018519732549,-0.1329690338446344},
{-0.4709333625274961,-0.014069782085519535,-0.15864196520154472},
{-0.4579603671769755,0.0001984876017647101,-0.16354171512589502},
{-0.4709333625274961,0.006547379412632124,-0.1612909357442669},
{-0.4579603671769755,0.022337622651595286,-0.1465913924642176},
{-0.4709333625274961,0.02147134373422899,-0.14808416905782276},
{-0.4579603671769755,0.020675115153801802,-0.12986532312580285},
{-0.4905242418646098,0.015271833008997529,-0.12213229424029065},
{-0.4905242418646098,0.02074239813904262,-0.1552379548938305},
{-0.4905242418646098,-0.013094737860479102,-0.16073476793544222},
{-0.4905242418646098,-0.07535089862303926,-0.07268718284778086},
{-0.4383694738633381,0.017512926659680156,-0.1232025884745574},
{-0.4383694738633381,-0.04808552408179867,-0.045244278502109936},
{-0.4383694738633381,0.018903409076098623,-0.15742948779136326},
{-0.4383694738633381,-0.013793927436642183,-0.15995461235730574},
{-0.4481648925671094,-0.07535099645870533,-0.07268722477735204},
{-0.4709333625274961,-0.07535089862303926,-0.07268718284778086},
{-0.4807288371373622,-0.04808562191746474,-0.04524433440820487},
{-0.4579603671769755,-0.04808552408179867,-0.045244278502109936},
{-0.5422816013901164,-0.2303811973155376,0.006311888964289921},
{-0.545764844610861,-0.47125267717691477,0.019987721763667636},
{-0.5447816380959617,-0.47125267717691477,0.0006230804161865119},
{-0.5569676573247653,-0.2303811973155376,0.00339500243816964},
{-0.5548781390739446,-0.16944499343064956,0.001903050459464608},
{-0.5612335858744419,-0.47125267717691477,0.005621392785887311},
{-0.5594776173624597,-0.2303811973155376,0.015319478978396356},
{-0.5486770350250079,-0.2303811973155376,0.017210292991334523},
{-0.5421863234278427,-0.16944499343064956,0.006328213544007643},
{-0.5456830120644165,-0.14372396885558122,0.0015075148378794355},
{-0.5428431781136248,-0.14372396885558122,0.014418132962989019},
{-0.5436269815644552,-0.08185280541571302,0.0037265395575909097},
{-0.5564792756560356,-0.08185280541571302,0.0018818760260122579},
{-0.5445015765134414,-0.036246010829332084,0.002133607194929945},
{-0.5430414630557956,-0.08185280541571302,0.015608164076058612},
{-0.546452838991516,-0.036246010829332084,0.018528432920921777},
{-0.5426912812537171,-0.016390947240656664,0.009961900066192134},
{-0.5544862653015767,-0.016390947240656664,0.0013180351056592868},
{-0.5598179876448788,-0.14372396885558122,0.005946095385204159},
{-0.5578900799379588,-0.08185280541571302,0.015455037282062599},
{-0.5541119879725864,-0.14372396885558122,0.017634592298757943},
{-0.5577559332631894,-0.16944499343064956,0.014151488843250433},
{-0.5482232592290359,-0.16944499343064956,0.017114511874206498},
{-0.5606200304591779,-0.036246010829332084,0.008192500114904511},
{-0.5535782804373974,-0.016390947240656664,0.01738023354337884},
{-0.5138639463264033,0.22181093272897165,-0.1448257102682424},
{-0.5411340728857125,0.22181093272897165,-0.14157060584435746},
{-0.5429625516028107,0.255479050627015,-0.14482569629171868},
{-0.5135878261235751,0.255479050627015,-0.14320331539355666},
{-0.5193563707395633,0.22181093272897165,-0.142247600700836},
{-0.5279767970697996,0.1749882085310478,-0.1454970725856574},
{-0.5160978979734594,0.17498841817890384,-0.12641205954846085},
{-0.5351727780309509,0.10476042564636463,-0.13636885119522932},
{-0.5252064404184742,0.10476042564636463,-0.1392613766404866},
{-0.5331099269874088,0.09952338027481596,-0.1399952140189788},
{-0.5396360411191844,0.09952338027481596,-0.12925549944237516},
{-0.5381986395126013,0.09952338027481596,-0.14491915730590738},
{-0.5200293263806838,0.09952338027481596,-0.14107403393272144},
{-0.5186278584166127,0.04748036855729679,-0.14491919923547855},
{-0.5454770959402889,0.04748036855729679,-0.13653668129219027},
{-0.5306367531601742,0.09952338027481596,-0.11592045622112855},
{-0.5261897028394685,0.04748036855729679,-0.11592045622112855},
{-0.513691252399184,0.09952338027481596,-0.12676512051442776},
{-0.5136406014771832,0.04748036855729679,-0.12848512743085028},
{-0.5252701034840686,0.09952338027481596,-0.12281750729272296},
{-0.52738296252952,0.04748036855729679,-0.13974406986405782},
{-0.5351510305600257,0.04748036855729679,-0.1286881504145657},
{-0.522789242568782,0.04748036855729679,-0.1270208629456562},
{-0.5207536317699915,0.03625720602484049,-0.13458532097844975},
{-0.5351516734801173,0.03625720602484049,-0.13528178513248545},
{-0.5302277022401412,0.03625720602484049,-0.12503110912122684},
{-0.5367195459357287,0.1707139499732275,-0.13183194580345756},
{-0.5268839307497074,0.1707609809755821,-0.1402886651112333},
{-0.5378840139868943,0.14923509385749323,-0.13445528340165722},
{-0.5325028147495849,0.14923509385749323,-0.1250843876296891},
{-0.5282227000283215,0.14923509385749323,-0.139566260529153},
{-0.52024819874231,0.14923509385749323,-0.13163020865992536},
{-0.5212537956482264,0.10476042564636463,-0.13046435693291028},
{-0.5402528111349063,0.1745953703785426,-0.12465132504188642},
{-0.5384741307718616,0.22181093272897165,-0.11955238170132294},
{-0.5184404472099047,0.22181093272897165,-0.12033000752866414},
{-0.5171957399359997,0.255479050627015,-0.11716024375868024},
{-0.5216671513375684,0.1705583772875787,-0.12800752166191712},
{-0.5300997471653847,0.16816438046727966,-0.12241643696774034},
{-0.5309518538876878,0.10476042564636463,-0.12451620001045584},
{-0.5362176210155037,0.27642847602382203,-0.12607881729314444},
{-0.5329018305255792,0.27642847602382203,-0.14116366537940786},
{-0.5368560825960561,0.255479050627015,-0.12703451800934135},
{-0.5216531748138374,0.255479050627015,-0.12432593759290676},
{-0.517981933372388,0.27642847602382203,-0.12844442779374582},
{-0.5276929478493483,0.255479050627015,-0.14297914592943636},
{-0.5404002215306964,0.255479050627015,-0.11868404823496806},
{-0.5114514445886845,0.27827545965834,0.0507734611726825},
{-0.5114382227972352,0.24958707932995894,0.06292846649532709},
{-0.46462579929730097,0.26252467214586933,0.06286589359858373},
{-0.511432198915507,0.22443482938812057,0.060213289159691506},
{-0.46462579929730097,0.21174397812215606,0.05490949191080389},
{-0.5114214789218055,0.2027882410110913,0.04417097931524107},
{-0.46462579929730097,0.19155099014271407,0.026966479592993024},
{-0.5114317656432714,0.19034657718672535,0.020001614428256178},
{-0.46462579929730097,0.19080574792085747,-0.011380740849260664},
{-0.51149510724882,0.1928985087251837,-0.01337351360281593},
{-0.46462579929730097,0.21756205553824678,-0.03954353400274032},
{-0.5114256439258773,0.21789848444097376,-0.039030483769625535},
{-0.46462579929730097,0.2553280622411499,-0.04627986902795282},
{-0.511432352657268,0.24578061502141282,-0.045712799530618006},
{-0.511432310727697,0.27746867880249615,-0.033932323114391004},
{-0.46462579929730097,0.2951268984146212,-0.01394330852227827},
{-0.46462579929730097,0.29511761800286385,0.028975213536649003},
{-0.5114301723195662,0.29708285700466913,0.019632787943520802},
{-0.5114255880197823,0.29488366497213186,-0.008834274131581086},
{-0.4705681978919782,0.2566826110150563,0.04379431200069264},
{-0.470220042685841,0.28458532901495087,-7.352350308651303e-05},
{-0.47027965255955345,0.23459071661543596,0.05097012483810034},
{-0.4717558809490611,0.2537390153520862,0.0499204040467655},
{-0.5053041361795881,0.255870602939337,0.054735763720828494},
{-0.5053568136975299,0.23032158744182504,0.05185056197400621},
{-0.505417220233095,0.25467717553100067,0.06113075010696061},
{-0.5054261232787117,0.2874946821947801,0.03727851254343041},
{-0.5054078978917665,0.29529783129985043,-0.0064665252228488426},
{-0.505588320836609,0.26625616638112276,-0.03691780641898267},
{-0.5054260673726167,0.23242181170982362,-0.04220773895632921},
{-0.5054261232787117,0.20447387965565947,-0.025930511701009382},
{-0.505417122397429,0.19020049456068971,0.011820176731884709},
{-0.5054228248191113,0.21145297292155432,0.05091019350434214},
{-0.5050941249340072,0.287906179006466,0.025420662091829006},
{-0.505340712742192,0.28835073029677555,-0.004595935239749326},
{-0.5054011192777571,0.23117602824359135,-0.0360537357923657},
{-0.5052918787682761,0.25703097586904955,-0.03524178362274136},
{-0.4865126860468359,0.2560672386517073,-0.02632903829867297},
{-0.4702383938614996,0.25384469184801567,-0.03030783314482146},
{-0.4878026632811054,0.2785977023894801,-0.003137261364047622},
{-0.5050941808401022,0.19908713173842885,-0.007538957865246437},
{-0.48780245363324937,0.23141818549375331,-0.02615930739448462},
{-0.4865129516007869,0.2082263806060805,-0.003629877919467797},
{-0.47022916935583725,0.2038061512344145,-0.0009688037071946357},
{-0.47021221583255157,0.23325579088084786,-0.031554790639047106},
{-0.5052070552457532,0.19865697626756218,0.02606674087781474},
{-0.4873721444206218,0.2196457595551954,0.03702801130860104},
{-0.47021221583255157,0.21894348116728765,0.03641751675203425},
{-0.47134582371931943,0.21084144410223152,0.019699302219956274},
{-0.47029395054333,0.20102880632122389,0.018691175563244667},
{-0.48737240997457265,0.2675061148514269,0.03689333352592985},
{-0.47022916935583725,0.28318769061838217,0.018850130567636476},
{-0.4871528527632835,0.27823098635982824,0.020210563458033504},
{-0.5053452970419757,0.2934943565837068,-0.1711114842377063},
{-0.5053198178392142,0.023799972353038257,-0.17317278388711432},
{-0.5420025880468758,0.023799972353038257,-0.17317278388711432},
{-0.5420025880468758,0.3023776953018452,-0.16831451628519736},
{-0.5053232281110047,0.38974684595108383,-0.11393414062153698},
{-0.5420025880468758,0.37237856932375674,-0.12803564242766374},
{-0.5420025880468758,0.4172151456403738,-0.07063056533382273},
{-0.5053202371349262,0.42908152177145115,-0.03550557653163882},
{-0.5420025880468758,0.43604227783821103,0.028547797464433592},
{-0.5053232281110047,0.43278337179987125,0.04912156185640076},
{-0.5053072249913326,-0.04155706189403606,-0.09019417647313731},
{-0.541990009175518,-0.04155706189403606,-0.09019417647313731},
{-0.5420027557651605,0.24058505197229746,0.08326485360824823},
{-0.5420025880468758,0.2903396315532573,0.0686358917730401},
{-0.5113918347149721,0.25473911948417627,0.0833836540599611},
{-0.511398180056746,0.30026423526587354,0.05854182271018647},
{-0.5420025880468758,0.3175114891742144,0.02469044463298311},
{-0.5113997314508802,0.3198437656657176,0.01072743620050608},
{-0.5420025880468758,0.3108493135839182,-0.026738899857082343},
{-0.511398180056746,0.30242940843964977,-0.038124707196195484},
{-0.5420025880468758,0.27700323260920884,-0.057574912821957334},
{-0.5113673618219193,0.26375724779717585,-0.06303370971902092},
{-0.5420026439529708,0.2231590802550092,-0.0627262821030355},
{-0.5112760811454327,0.21123960731027805,-0.05817383481687492},
{-0.5420025880468758,0.21145852160147557,0.07429277794094206},
{-0.5113053060565539,0.21117935451647402,0.07461605493483836},
{-0.5057922522943671,0.27076426615748506,0.19202763153150998},
{-0.5053211456089687,0.3382286806527084,0.17246065204997624},
{-0.5420031750608725,0.296159637729623,0.18957257127903065},
{-0.5420025880468758,0.389748131791267,0.1335815969267134},
{-0.5053202371349262,0.39245488128309297,0.12703829167074873},
{-0.5420022246572588,0.14311055320555446,0.18892262099597143},
{-0.5053198737453092,0.02380008416522822,0.19282065948800267},
{-0.5420025880468758,0.023799972353038257,0.19282065948800267},
{-0.541990009175518,-0.04155706189403606,0.10808657274037403},
{-0.5053072249913326,-0.04155706189403606,0.10808657274037403},
{-0.5420025880468758,0.2741697859297623,-0.10416225838372864},
{-0.5420025880468758,0.2741697859297623,-0.16013683827370953},
{-0.5420012043710264,0.03847110136034269,-0.1601368802032807},
{-0.5419928324333116,0.03847110136034269,-0.10416230031329986},
{-0.541990009175518,0.15079065299569758,-0.09022349921992479},
{-0.5053072249913326,0.15079065299569758,0.10805726397011027},
{-0.541990009175518,0.15079065299569758,0.10805726397011027},
{-0.5419998206951772,0.23213400713315652,0.1280995990002565},
{-0.5419955997850103,0.17910710405107513,0.1280995990002565},
{-0.5419928324333116,0.14311055320555446,0.1280995990002565},
{-0.5419928324333116,0.09008225247109992,0.12809958502373278},
{-0.5419998206951772,0.09008225247109992,0.18112651605886157},
{-0.5053072249913326,0.15079065299569758,-0.09022349921992479},
{-0.5178204346406772,0.17910710405107513,0.1280995990002565},
{-0.5178204346406772,0.17910710405107513,0.1811265300353853},
{-0.5178204346406772,0.23213400713315652,0.18112654401190903},
{-0.5178204346406772,0.23213400713315652,0.1280995990002565},
{-0.5419998206951772,0.17910710405107513,0.1811265300353853},
{-0.5420025880468758,0.23213400713315652,0.18112654401190903},
{-0.5178204346406772,0.09008225247109992,0.12809958502373278},
{-0.5178204346406772,0.09008225247109992,0.18112651605886157},
{-0.5178204346406772,0.14311055320555446,0.1811265300353853},
{-0.5178204346406772,0.14311055320555446,0.1280995990002565},
{-0.5092583882500652,0.03847110136034269,-0.1601368802032807},
{-0.5092597719259144,0.03847110136034269,-0.10416230031329986},
{-0.5092597719259144,0.2741697859297623,-0.10416225838372864},
{-0.5092597719259144,0.2741697859297623,-0.16013683827370953},
{-0.48268485163350533,-0.8293172386394781,-0.052752592839076344},
{-0.4460230182583925,-0.8293172386394781,-0.052752592839076344},
{-0.4460230182583925,-0.8293172665925256,0.07063355630990119},
{-0.48268485163350533,-0.8293172665925256,0.07063355630990119},
{-0.4093626104887005,-0.6481127545429836,0.14613171857523125},
{-0.409362582535653,-0.6921344715730402,0.07092183608837523},
{-0.4093626104887005,-0.6969819912282081,-0.030354458827987825},
{-0.4460230741644875,-0.6969826481248234,0.048237574683467226},
{-0.44602313007058236,-0.6513422679519172,0.1452793183459296},
{-0.5193452873562447,-0.6481144037727838,-0.12824816944751619},
{-0.5193452873562447,-0.6921329062023823,-0.0530427734247778},
{-0.5193452873562447,-0.696981530002925,0.04824020226992864},
{-0.48268485163350533,-0.6969820611108268,-0.03035519958374557},
{-0.48268485163350533,-0.651341652984873,-0.12739715289406392},
{-0.5393960083006295,-0.3870897410715504,0.1508657069281328},
{-0.5346741655468502,-0.39193735856238443,0.14869396478820304},
{-0.40684777264422395,-0.3907011629914316,0.14912033262113863},
{-0.40684771673812903,-0.39070148445147734,-0.1312392713146477},
{-0.5350161431294984,-0.3893504577615513,-0.13374769393473168},
{-0.5736598894992274,-0.3871829924378832,-0.04914378452913289},
{-0.5770930827884917,-0.38718513084601397,0.04340171144909096},
{-0.5736066249672889,-0.39198577324058836,0.06703661406860528},
{-0.5770407826366908,-0.3919881632261464,-0.02552452163967348},
{-0.5541707313018276,-0.39194669488023665,-0.09226864200789982},
{-0.5238125477302653,-0.5874118454351057,-0.12920981018629873},
{-0.4460230182583925,-0.6481171711244826,-0.12824536016624627},
{-0.4093626104887005,-0.6510697397156879,-0.12802896164932034},
{-0.46879495439666474,-0.5170451219280136,-0.12496614623892549},
{-0.5156233251101757,-0.5170369596381547,-0.12848013781187836},
{-0.531486497849967,-0.3919290984368594,-0.12869705346018231},
{-0.562963222615715,-0.5198546687518804,-0.056362700965726764},
{-0.574547873957948,-0.3919237034986993,0.00894429732639096},
{-0.5711833473297736,-0.5075248730234567,0.01978483854518953},
{-0.5609518051795027,-0.5238097733903049,0.07936850627558846},
{-0.5568626656784985,-0.39192686219306244,0.09660948472477422},
{-0.523811848904079,-0.5874675698352209,0.1470906059388388},
{-0.5157085819049344,-0.517147374175629,0.14636261074726611},
{-0.4688089309203955,-0.51715479570973,0.14313990390538947},
{-0.48268485163350533,-0.6481172270305775,0.14612777719553913},
{-0.5193452873562447,-0.6515503085076519,0.14508115919247255},
{-0.5193452873562447,-0.5078817635569259,0.025921930115438627},
{-0.48268479572741035,-0.6921357015071287,0.07091621752583539},
{-0.5193452873562447,-0.5170190417347316,-0.05061646288161299},
{-0.5193452873562447,-0.5261638392823045,0.08328804066111782},
{-0.4460230741644875,-0.6921327943901926,-0.05304238208211334},
{-0.5157083722570783,-0.47160420072527126,0.14104451551460176},
{-0.4688089309203955,-0.47159789731306867,0.14644087928015928},
{-0.4688089309203955,-0.47159789731306867,0.1302490765378829},
{-0.5157085819049344,-0.517147374175629,0.1302490765378829},
{-0.5156229617205589,-0.4716745166161616,-0.12267567352990155},
{-0.46879495439666474,-0.4716678078847707,-0.12855980399714462},
{-0.46879495439666474,-0.4716678078847707,-0.11091024982973276},
{-0.5156233251101757,-0.5170369596381547,-0.11091024982973276},
{-0.5608107960315813,-0.5060151149535186,-0.04226175822054924},
{-0.5608107960315813,-0.5060151149535186,0.06021690907933782},
{-0.5154947271153276,-0.5059620181398647,0.06021690907933782},
{-0.5154947271153276,-0.5059620181398647,-0.04226175822054924},
{-0.5731152662990046,-0.6035588254657771,0.06021688112629037},
{-0.5731702359668382,-0.6026772702079728,-0.042261786173596695},
{-0.5673333880793768,-0.6253387918087705,-0.042261786173596695},
{-0.5613612194891526,-0.6314639893573246,0.06021688112629037},
{-0.5530704993537291,-0.641811550631086,-0.042261786173596695},
{-0.5530005468524559,-0.6418673449138198,0.06021688112629037},
{-0.5411268190698962,-0.6475853783730446,-0.042261786173596695},
{-0.5410399689514322,-0.6476052110602188,0.06021688112629037},
{-0.515497564349645,-0.6475859653870413,-0.042261786173596695},
{-0.5154961666972718,-0.6475756087829567,0.06021688112629037},
{-0.5154947271153276,-0.5895038654836744,-0.04226177219707297},
{-0.5410759585000392,-0.5895038654836744,-0.04226177219707297},
{-0.5530161166998921,-0.5952538073465768,-0.04226177219707297},
{-0.5612790095765673,-0.605614618364835,-0.04226177219707297},
{-0.5642280980133637,-0.6185344889486546,-0.042261786173596695},
{-0.5612790095765673,-0.6314543874855214,-0.042261786173596695},
{-0.5642280980133637,-0.6185344889486546,0.06021688112629037},
{-0.5612790095765673,-0.605614618364835,0.06021688112629037},
{-0.5530161166998921,-0.5952538073465768,0.06021689510281409},
{-0.5410759585000392,-0.5895038654836744,0.06021689510281409},
{-0.5154947271153276,-0.5895038654836744,0.06021689510281409},
{-0.5104427029649288,-0.5975367047797385,0.14747373040735093},
{-0.5038817174064445,-0.6310517797429284,0.14747373040735093},
{-0.5060763670687692,-0.6060436277607558,-0.12951862147813353},
{-0.526499674182773,-0.5863973454835728,-0.12951862147813353},
{-0.5092751321254949,-0.5966616486054691,-0.14585717771958465},
{-0.5016536918054503,-0.6245794892040405,-0.1458573873674406},
{-0.5056055399138455,-0.6346311534938945,-0.12951863545465728},
{-0.5355344764885835,-0.5865938414307059,0.14747373040735093},
{-0.5271804706537063,-0.5866820332954481,0.1677969935644887},
{-0.5417203321501298,-0.5866820332954481,0.16558326594727127},
{-0.5596230710449275,-0.5966597617747654,0.16381228664880204},
{-0.5600983846639688,-0.5994674357444523,0.14747373040735093},
{-0.5587470225374731,-0.5977728381481725,-0.12951862147813353},
{-0.5417203321501298,-0.5866819773893531,-0.1511701156149923},
{-0.5271804706537063,-0.5866819494363057,-0.14685385760336064},
{-0.5407665601942078,-0.651170454545693,0.14747371643082718},
{-0.5267633273264333,-0.6507998390659201,0.16665849389441506},
{-0.5022802593643078,-0.6273240451925586,0.16381228664880204},
{-0.5432396920918713,-0.650252783950568,-0.12951863545465728},
{-0.5658312611913958,-0.6245851636726752,-0.12951862147813353},
{-0.5653491130522501,-0.6266974217276062,0.14747373040735093},
{-0.5664349491809054,-0.6316313023229075,0.16381228664880204},
{-0.5417203321501298,-0.6503854351372981,0.1701878177139007},
{-0.5075199043692704,-0.5988628672339473,0.16381228664880204},
{-0.561378186988962,-0.5988606449666741,-0.14585717771958465},
{-0.5666208648995744,-0.6273200479067715,-0.14585717771958465},
{-0.5421375313834979,-0.6508008174225811,-0.14830931687860424},
{-0.5261279545576253,-0.6511626696219749,-0.15083737651453016},
{-0.4093626384417479,-0.6481264794892874,-0.13512044014253566},
{-0.45610575236050044,-0.6481218672364562,-0.1318815904157498},
{-0.45610569645440546,-0.5881215733101621,-0.13846777564652096},
{-0.4098203276643645,-0.5797049666254941,-0.13848291222172154},
{-0.4578141727387499,-0.5535849821805263,-0.13852745540285202},
{-0.46856948511583746,-0.5394270431715742,-0.13438941204531338},
{-0.5168560545032433,-0.5394273646316199,-0.13855303244127962},
{-0.5193459162998126,-0.5881159128180511,-0.13361023482383805},
{-0.5175815339205444,-0.5233854321533102,-0.13858147466707205},
{-0.4097117999575939,-0.5788741880784042,-0.12877024851496116},
{-0.46705002733842993,-0.5223232582793311,-0.13858255085939933},
{-0.5193452873562447,-0.521406062886013,-0.12887008282397114},
{-0.4656293137011813,-0.5214046233040687,-0.12886868517159805},
{-0.45610569645440546,-0.5881048014816849,-0.1287526940011551},
{-0.4485862008984543,-0.5628487758511445,-0.12879723718228558},
{-0.46839273799673614,-0.5248421353391659,-0.12886384929438718},
{-0.5167799243784811,-0.5318926206882784,-0.1288510328221259},
{-0.409362582535653,-0.6481265913014772,0.15378972148135586},
{-0.4098203276643645,-0.5797050225315891,0.15715156461697385},
{-0.45610569645440546,-0.5881216152397333,0.15713709891491234},
{-0.4578141727387499,-0.5535850101335739,0.15719652709381626},
{-0.46857092469778167,-0.5394266797819571,0.15305795262837582},
{-0.4670500832445249,-0.5223232582793311,0.15725202786955175},
{-0.45610575236050044,-0.648121923142551,0.15054994930400373},
{-0.5193446444361531,-0.5881160246302409,0.15227885926604287},
{-0.5168560545032433,-0.5394273646316199,0.15722095805729788},
{-0.5175815339205444,-0.5233854321533102,0.15725005717970567},
{-0.4097117999575939,-0.578874243984499,0.14743804834226584},
{-0.4485862008984543,-0.5628488317572393,0.14746611320191755},
{-0.46839273799673614,-0.5248421353391659,0.14753171900431053},
{-0.4656293137011813,-0.5214046233040687,0.1475380363930369},
{-0.5193452873562447,-0.521406062886013,0.1475380363930369},
{-0.45610569645440546,-0.5881048573877798,0.14742201726954648},
{-0.5167798125662911,-0.5318926206882784,0.14752097105756143},
{-0.4409006083344849,-0.7053957886316062,-0.16045006614704327},
{-0.4409006083344849,-0.705395844537701,0.17734013601491674},
{-0.3793633999526434,-0.705395844537701,0.17734013601491674},
{-0.3793633999526434,-0.7053957886316062,-0.16045006614704327},
{-0.3757520758684284,-0.9041036324572872,0.2923982057805379},
{-0.4425366722493794,-0.8203499149902406,0.2453820884237493},
{-0.4436275259500544,-0.9485861275217048,0.3190135042500058},
{-0.32231654116202596,-0.9401033699502184,0.3143792523704482},
{-0.4436275259500544,-0.948580355217404,-0.30195721158540045},
{-0.4429456672633175,-0.8211112302143876,-0.22956822485968073},
{-0.3755111625288784,-0.9027969952067304,-0.27475162861268065},
{-0.34776547077310077,-0.9311813162613451,-0.29118723783491934},
{-0.32049723104449523,-0.9388227849398962,-0.29785792512816767},
{-0.48577195824214453,-0.9377398699047004,-0.2995364217691094},
{-0.4868624904827736,-0.8202489485828083,-0.2280087103652605},
{-0.4884977018297206,-0.7053957886316062,-0.16045006614704327},
{-0.5262818221073791,-0.7053957886316062,-0.16045006614704327},
{-0.5262818221073791,-0.705395844537701,0.17734013601491674},
{-0.4884977018297206,-0.705395844537701,0.17734013601491674},
{-0.48645366318712024,-0.8207767160954117,0.24526428030522135},
{-0.573787956386174,-0.9504271431805899,0.3192176174025722},
{-0.4857722237960953,-0.9377436994722027,0.3164276377119288},
{-0.573788012292269,-0.9504239844862264,-0.30232856782093115},
{-0.5167875415839143,-0.9803867442483933,0.26221811107435516},
{-0.5167875415839143,-0.980386660389251,-0.24532815301867159},
{-0.37863101613261924,-0.980386660389251,-0.24532815301867159},
{-0.37863101613261924,-0.9803867442483933,0.26221811107435516},
{-0.3315019405110372,-0.9783020199452124,0.30757458612071514},
{-0.5604069164253288,-0.978206518358559,0.3102602869678022},
{-0.5639166172054962,-0.9783019221095464,-0.2906846560180791},
{-0.33501161333815727,-0.9782064205228929,-0.2933703149355949},
{-0.5569952190295626,-0.9999999021643341,-0.2855358304643199},
{-0.5569952190295626,-1.0000000000000002,0.30242578852000346},
{-0.3384233526634946,-1.0000000000000002,0.30242578852000346},
{-0.3384233526634946,-0.9999999021643341,-0.2855358304643199},
{-0.5167875415839143,-1.0000000000000002,0.26221811107435516},
{-0.5167875415839143,-0.9999999161408578,-0.24532815301867159},
{-0.37863101613261924,-0.9999999161408578,-0.24532815301867159},
{-0.37863101613261924,-1.0000000000000002,0.26221811107435516},
{-0.5039640950373145,-0.9176947675228555,0.1756097864709333},
{-0.5039640950373145,-0.8457824082094078,0.16240283808968067},
{-0.5704629972966817,-0.8531347864711082,0.16562794889363905},
{-0.5704629972966817,-0.7784896254256002,0.10358581063897042},
{-0.5039640950373145,-0.7746372202835504,0.09768953457260517},
{-0.5704629972966817,-0.7527241555050674,0.03846590209351486},
{-0.5039640950373145,-0.7478192342669366,0.004450327815520581},
{-0.5704629972966817,-0.7534233171281832,-0.029580718474243827},
{-0.5039640950373145,-0.7784687864287174,-0.08666852847939285},
{-0.5704629972966817,-0.7913150007324748,-0.10316599779566461},
{-0.5039640950373145,-0.8531317116358874,-0.1487375156361486},
{-0.5704629972966817,-0.848077171711217,-0.14410140487893466},
{-0.5704629972966817,-0.9168051058812872,-0.16040250403678694},
{-0.5039640950373145,-0.9176967941187963,-0.15872124004414653},
{-0.5704629972966817,-0.9176950330768063,0.1756098144239808},
{-0.5711811110859768,-0.9175076218700984,-0.05828473853267982},
{-0.5708874503458663,-0.9175836541591945,0.07533465790246387},
{-0.5697625218803353,-0.7962294399832665,0.07604374285742861},
{-0.5710461677493546,-0.7711008383195807,0.07523464189864536},
{-0.5708517822573048,-0.7709782921595079,-0.05849227593356032},
{-0.5697625218803353,-0.7962304742460224,-0.05917884470879454},
{-0.4514046507679377,-0.8905189964752537,0.30793657808534614},
{-0.44876107516337566,-0.8948272319622639,0.29731305035051764},
{-0.4619814130543626,-0.8795591236968404,0.30330974773988956},
{-0.46408782892237405,-0.8839873476400806,0.2988329414001608},
{-0.4682821697175007,-0.8998633088990855,0.30802313469681175},
{-0.4656079296198732,-0.8993994700060274,0.3147724119829991},
{-0.4706965862389705,-0.9044009829996624,0.30285695030057885},
{-0.46919893183858336,-0.887039596798535,0.2928041259592552},
{-0.4726685479486904,-0.8864905430402892,0.3073334631333092},
{-0.4504418639542093,-0.8450509747929973,0.2832004651610722},
{-0.45654966073071823,-0.8412109388744494,0.2662676411071059},
{-0.4618683849069506,-0.8353925679513603,0.27773009570235946},
{-0.4667203770497122,-0.8403105851922269,0.27353859214155},
{-0.4529308871593547,-0.8513883499483105,0.27995767405459426},
{-0.4676003110307639,-0.8552246401584984,0.2822409628304205},
{-0.46653249064119745,-0.8549571993769073,0.2890847633466001},
{-0.45793593621349377,-0.8624369317228439,0.2785589734422219},
{-0.47456228305508846,-0.8526345527102546,0.2728825620706679},
{-0.4726685898782617,-0.8425170170640568,0.2818699699845069},
{-0.2502328715972083,-0.6209454812218103,0.19172550101801858},
{-0.2502328995502558,-0.8508061718288226,0.18079093972408208},
{-0.2533746683432066,-0.5852080970558321,-0.21787536727072296},
{-0.2595386786981615,-0.5708100832987538,0.20266003435890761},
{-0.2818317092507935,-0.5556023396393244,-0.21787536727072296},
{-0.3141527138855555,-0.5492353063006541,0.20266004833543136},
{-0.3307230428200365,-0.5513736165958194,-0.21787536727072296},
{-0.3647989537509772,-0.5740231603157798,0.20266003435890761},
{-0.3679113997971406,-0.5815543122925225,-0.21787536727072296},
{-0.37228012567885815,-0.6209454812218103,0.18079098165365326},
{-0.37228012567885815,-0.6209454812218103,0.20266003435890761},
{-0.25460168133806826,-0.8901959710587846,-0.21787542317681785},
{-0.24747147389759455,-0.8535628734164626,0.2026599924293364},
{-0.27391139494728683,-0.9129033356574198,0.2026599784528127},
{-0.2845241467823188,-0.9172695597413896,-0.21787542317681785},
{-0.34185685343628114,-0.9185076700960935,0.2026599784528127},
{-0.33271907210362106,-0.9195459720675401,-0.21787545112986534},
{-0.3686688575007381,-0.8890697427765467,-0.21787542317681785},
{-0.37531389787294017,-0.8522514981243612,0.2026599924293364},
{-0.37228009772581067,-0.8508061858053462,0.18079092574755834},
{-0.2952750146248597,-0.6615975981455782,0.18863038586128153},
{-0.26598339355572825,-0.6637589277753284,0.18863038586128153},
{-0.2921107576052258,-0.6223745667967736,0.18546610088860016},
{-0.29482751428804305,-0.6637589277753284,0.1823018159159188},
{-0.29550667550569987,-0.706031217306509,0.18863038586128153},
{-0.29422026228498177,-0.7081925469362592,0.1823018159159188},
{-0.2921107576052258,-0.8493763874276726,0.1854660729355527},
{-0.2693793394092497,-0.6223745667967736,0.18546610088860016},
{-0.3562986137126372,-0.6615975981455782,0.18863038586128153},
{-0.32700664323041245,-0.6637589277753284,0.18863038586128153},
{-0.3531336299137693,-0.6223745667967736,0.18546610088860016},
{-0.35585097361058315,-0.6637589277753284,0.1823018159159188},
{-0.3565303025465248,-0.706031217306509,0.18863038586128153},
{-0.35524362377185587,-0.7081925469362592,0.1823018159159188},
{-0.3531336299137693,-0.8493763874276726,0.1854660729355527},
{-0.33040223967084065,-0.6223745667967736,0.18546610088860016},
{-0.26621505443656834,-0.7081925469362592,0.18863038586128153},
{-0.2693793394092497,-0.8493763874276726,0.1854660729355527},
{-0.2666625827264325,-0.706031217306509,0.1823018159159188},
{-0.2672698067764463,-0.6615975981455782,0.1823018159159188},
{-0.3272379546981592,-0.7081925469362592,0.18863038586128153},
{-0.33040223967084065,-0.8493763874276726,0.1854660729355527},
{-0.32768574854197435,-0.706031217306509,0.1823018159159188},
{-0.3282927070380372,-0.6615975981455782,0.1823018159159188},
{-0.2684526819093656,-0.7027892088853599,0.18863038586128153},
{-0.3294769937998534,-0.7027892088853599,0.18863038586128153},
{-0.2930373871520624,-0.7027892088853599,0.1823018159159188},
{-0.3540603013901771,-0.7027892088853599,0.1823018159159188},
{-0.2684526819093656,-0.6670009222199538,0.1823018159159188},
{-0.3294769937998534,-0.6670009222199538,0.1823018159159188},
{-0.2930373871520624,-0.6670009222199538,0.18863038586128153},
{-0.3540603013901771,-0.6670009222199538,0.18863038586128153},
{-0.2789674862660913,-0.8905237624698459,0.21447186011786307},
{-0.298796986792863,-0.8926450912886782,0.2146283412775545},
{-0.2919107954802075,-0.8974296047748671,0.20176422304689773},
{-0.27695650210211464,-0.879898697317407,0.20174801027936984},
{-0.2832718921855991,-0.8748153937068984,0.21458122641605756},
{-0.29864289561872953,-0.8747986777845163,0.20175269241481972},
{-0.29637871275084343,-0.8760047818998764,0.21461303698406917},
{-0.2976967268917171,-0.8780116849189237,0.20849893679535744},
{-0.28079244289920935,-0.8804507001221599,0.20854690422480196},
{-0.28775761554746826,-0.894714665040135,0.20849608558451632},
{-0.34259911865858306,-0.897431323887286,0.20182639062445287},
{-0.32783088076439626,-0.8793404190534989,0.2018151954289444},
{-0.3322611173270536,-0.893971100001126,0.21463197517372457},
{-0.33242850017525516,-0.8775790556033567,0.21318006593550862},
{-0.3484971976965096,-0.8759053389335308,0.21465157025999532},
{-0.3497429951392656,-0.8753678297838869,0.2018159222081784},
{-0.34800915146434946,-0.8919450631210911,0.21319714524750782},
{-0.333955211768479,-0.8925734336515099,0.20860957495721144},
{-0.3464728659523699,-0.8766785621558969,0.20857779234224733},
{-0.4688553609322298,-0.8411895547931411,0.2776457194285959},
{-0.46374346135416766,-0.8543874184339686,0.28842922245404856},
{-0.46710446589836185,-0.8292871052543143,0.30329606472315707},
{-0.4610433227580666,-0.8238206771752935,0.29743725971691437},
{-0.4440612454344725,-0.8196054973832839,0.31315521637514127},
{-0.4451887875099412,-0.8340715488578844,0.3131601780410657},
{-0.4652984893844704,-0.8405549926627096,0.3016792744344874},
{-0.4523946219203228,-0.8388679843188157,0.2983916466398806},
{-0.45447998914359555,-0.8437265174746836,0.27885520586269896},
{-0.4534359008913243,-0.8299085853585336,0.29295581317130687},
{-0.4311673432317451,-0.8253295687007605,0.3002237452766251},
{-0.4051628607788898,-0.8158880914839512,0.30369733071947186},
{-0.38307065889574743,-0.8161909068471054,0.28892724792415253},
{-0.38574587735003635,-0.8094343058624831,0.295583078172675},
{-0.361724467943267,-0.8122375912037184,0.2537722655020421},
{-0.36996729053186467,-0.818329985851076,0.27901717979621665},
{-0.3566456507968761,-0.8226663001742616,0.2567307321862619},
{-0.34202419435491144,-0.8412538468023032,0.24618526333647062},
{-0.3430683804428488,-0.8194200289133746,0.2398077755580496},
{-0.3396022165341032,-0.8678495082559292,0.24315228780424125},
{-0.34837414838158254,-0.8716348959666892,0.2501750996363666},
{-0.34490348403219556,-0.878622361170299,0.215405016701282},
{-0.3345364674374007,-0.8735123344464168,0.24257118587708065},
{-0.33695232354081484,-0.8775291733901609,0.20656877886811673},
{-0.34897133728755747,-0.8852926431443592,0.20531936150571442},
{-0.3457594622515723,-0.8852329214584569,0.25215582462646574},
{-0.3440324251437131,-0.8945385887941728,0.20388738279033877},
{-0.3359172641228737,-0.893356775877057,0.2186337054953155},
{-0.3317867820646735,-0.8856957540418064,0.20528847338826908},
{-0.3315318502718214,-0.8749830001794797,0.25539980373746085},
{-0.4383912912168821,-0.8331112079358088,0.30279468488735756},
{-0.38376808742992063,-0.8259784847210636,0.29594627211834673},
{-0.35103863286564607,-0.8197263244309378,0.26362071113684843},
{-0.34086629526989926,-0.837798989901256,0.2540088041896643},
{-0.3378280226351759,-0.8691199183569754,0.2607151875245214},
{-0.37420878811805963,-0.8088237553998214,0.3008635905330268},
{-0.3973007726732462,-0.8247404162959309,0.31257628080915884},
{-0.39567380747530045,-0.8308455295798836,0.3065856771841336},
{-0.3718229955171908,-0.8186524382300722,0.29943987194317623},
{-0.3435730028321539,-0.8143077799222193,0.2563550432283746},
{-0.3281999308735113,-0.8364495565350352,0.25413681517051584},
{-0.32722659178436597,-0.8326499966292121,0.24221908929125113},
{-0.35832252616106497,-0.8031753390053004,0.2668080294206384},
{-0.46139403566804665,-0.9012024415673167,0.3082908130793064},
{-0.45377627117374336,-0.8907520130788956,0.32756738835075894},
{-0.46341722133724045,-0.8838201185336401,0.3352801932064326},
{-0.4392180305486138,-0.8905071024535587,0.3484138906268114},
{-0.4261374578949361,-0.8822825891110484,0.35673057914332706},
{-0.3889417352898259,-0.9056719940912291,0.3550515793475311},
{-0.39320510613565973,-0.8881369915123158,0.35695603444763063},
{-0.3507678656714069,-0.9108397578346435,0.3405204811314868},
{-0.3408851216473648,-0.9166873955984252,0.32057841368258627},
{-0.3086046908609937,-0.9116002484438908,0.28748556950130766},
{-0.3148940007511962,-0.9116967144106816,0.2801978885679577},
{-0.2869938404551444,-0.8934913977536332,0.20993857464573762},
{-0.2813702044371983,-0.8806257560818896,0.2137495114418777},
{-0.3028348044987272,-0.9017444092280307,0.2800621485694829},
{-0.319170830989383,-0.9044368607360798,0.30955002798484405},
{-0.2927140542520712,-0.8758130379708119,0.21175151146844706},
{-0.3170901179485128,-0.8977414349958278,0.28833177813059646},
{-0.3217856289315831,-0.9023345539660453,0.28356688768372595},
{-0.2967131709637245,-0.8860544195937894,0.2089519159294767},
{-0.33106000283066545,-0.9098893122913696,0.3004356852824809},
{-0.4720237410263643,-0.8870001410720425,0.30251922158114475},
{-0.4544458584726446,-0.8738003906005113,0.3353899927768627},
{-0.4364221108353846,-0.8756016430493816,0.3401083553762331},
{-0.38733129034293007,-0.8924532355474238,0.34332566727994956},
{-0.3507430433652607,-0.8995449097119713,0.32501309477979007},
{-0.3575339846686899,-0.9000061349950919,0.3432227581357188},
{-0.4575673613061856,-0.88639108609742,0.3006030960837299},
{-0.4496708629991165,-0.8823599910994703,0.3240500424121107},
{-0.41176274300291726,-0.8885149027374764,0.3426916502339437},
{-0.41596572128970977,-0.89470183459135,0.3450281895651848},
{-0.3800247271260196,-0.9038693719430331,0.338763715957652},
{0.40571433247574085,0.4667146536632443,0.012353758478360226},
{0.39850457066219075,0.4667146536632443,-0.07513041896118383},
{0.40577752033952835,0.5008737109338605,9.237783359956539e-05},
{0.38281302963381536,0.5007908581011833,-0.11617151651690717},
{0.34840594497307037,0.4667146536632443,-0.19799461483142994},
{0.3330212165936362,0.500791291373419,-0.21931826165113244},
{0.27138490068201876,0.4667146536632443,-0.2925249448977299},
{0.2369917366389098,0.5007962949689146,-0.316181469199456},
{0.22233894483074043,0.4667147654754343,-0.32750671626124306},
{0.11658774438187597,0.5007913892090852,-0.37765692929945427},
{0.13443372461380226,0.4667147654754343,-0.3729803285529918},
{0.04270100542010289,0.4667147654754343,-0.39359329709402424},
{-0.018765230174232962,0.5007964067811046,-0.3944354245783837},
{-0.03528411152486049,0.4667147654754343,-0.39505464048575856},
{-0.13328558114235428,0.5007964067811046,-0.3737085194158967},
{-0.11216560022645884,0.4667147654754343,-0.3817242654234381},
{-0.18514137732449773,0.4667147654754343,-0.35407622763896845},
{-0.23733360240936824,0.5007964067811046,-0.3215521021848249},
{-0.2515731363638616,0.4667147654754343,-0.3131038526504301},
{-0.3469058726340777,0.5007976786447641,-0.21291603542570767},
{-0.3090492561278269,0.4667146536632443,-0.2602880370062568},
{-0.3743357089300602,0.4667146536632443,-0.1654402162268852},
{-0.40453509123899156,0.5007899076975697,-0.06776940320781764},
{-0.40450244207955616,0.4667146536632443,-0.07947676842840817},
{-0.41550439817092316,0.4667146536632443,0.006189342804217174},
{-0.4159271740372599,0.5013201909844447,-0.006901502594402683},
{-0.39304244735247923,0.5007911795612291,0.1432962872294148},
{-0.40100921962086744,0.4667146536632443,0.11857989518012525},
{-0.36495584022985683,0.4667146536632443,0.21298150146286338},
{-0.3171938237545962,0.5007911795612291,0.2786529935173599},
{-0.2927144036651645,0.4667146536632443,0.305918451917743},
{-0.23394752398160082,0.46671455582757826,0.3538056002099666},
{-0.2123936418864788,0.5007960853210588,0.36595396668383895},
{-0.16278726936316162,0.46671455582757826,0.39237524305087423},
{-0.08701425875866291,0.501567785102338,0.419605187104457},
{-0.08829695422406852,0.46671455582757826,0.41560535759009354},
{-0.028032895341924446,0.5007960853210588,0.42236766099639805},
{0.011894916192535802,0.46671455582757826,0.42479420914046634},
{0.08794575213575784,0.5007961971332485,0.41262047527602225},
{0.10505975386684814,0.46671455582757826,0.40962572553619697},
{0.23008245610905084,0.5007859523413538,0.3524660901755947},
{0.19149471366991166,0.46671455582757826,0.3751673051037884},
{0.27264129232976275,0.4667146536632443,0.3193071929431638},
{0.3484358547338546,0.500791291373419,0.22370809208368372},
{0.34890376079531843,0.4667146536632443,0.227124513544471},
{0.39733026313831843,0.4667146536632443,0.10403799311123704},
{0.4049697191974521,0.501567896914528,0.07787851101020576},
{0.41032293743425224,0.5048100451009143,-0.000875845847860252},
{0.40151885958219186,0.5067506574679057,0.10269484918069516},
{0.37388291149074937,0.5044468651317662,0.18751722562873205},
{0.33772540699794346,0.5053709369747599,0.2493291425845049},
{0.272175874089523,0.5019991146011981,0.3256405987657374},
{0.2545359916765329,0.5067530055238926,0.3390257618010831},
{0.19648100622920386,0.5049224443047583,0.3788439135303505},
{0.12361571355125794,0.505096787461778,0.4083633100067249},
{0.03881624462561606,0.5067596164196173,0.426594091890011},
{0.020571989373453326,0.5019990027890083,0.429690353121694},
{-0.0678601457881407,0.5067371142164105,0.4236016902061726},
{-0.17906135190064199,0.5051382697842113,0.3905095448510805},
{-0.28802623035705294,0.5019939991935126,0.31988087333622334},
{-0.3766113385708819,0.5047423428199617,0.1991391383832317},
{-0.4113216159609218,0.5039247860643213,0.09903026056454159},
{-0.41718747911164855,0.5067480997640629,0.04411300469480518},
{-0.40918932954748444,0.5044192475208739,-0.08332544183862176},
{-0.3469668661836394,0.501986857189886,-0.22348234327238178},
{-0.24432623892675842,0.5067261286687579,0.35072598501804714},
{-0.336575935756741,0.5067515100358534,0.2624132512986864},
{-0.39841127736628684,0.5067719856431191,-0.11428914432430248},
{-0.37278491578644796,0.5067684635591388,-0.17288190447522628},
{-0.33530144451076543,0.5067453184358405,-0.2342888237028481},
{-0.2822936193835768,0.5067454302480302,-0.29250388227646734},
{-0.24004729823348836,0.5047424406556277,-0.32836846678492065},
{0.0209766097354636,0.506742229624096,-0.39933218352665556},
{0.050622367962889304,0.501999226413388,-0.398447315832727},
{-0.0427536549849973,0.5044469629674322,-0.39968348345063237},
{-0.10278395650774166,0.5067767795907588,-0.38682817042992607},
{-0.13974987710966805,0.5044462222116746,-0.37951443725634154},
{0.13461010834328654,0.5051385912442571,-0.37707858074746853},
{0.19066039906231783,0.5067408459482465,-0.35116535101805246},
{0.23918746249356185,0.5046699304505118,-0.32257874773548},
{0.3125047559489658,0.5067407341360568,-0.25267253670879797},
{0.3328633377815717,0.5019939991935126,-0.23221811785296917},
{0.35639941240178463,0.5067384978922598,-0.18934922642981045},
{0.3938342034453124,0.5043165620010228,-0.10511210293648231},
{0.403188397271422,0.506731886996535,-0.05984848791379061},
{0.025456295239080974,0.9714444805062051,0.024883166918708833},
{0.015433282822875387,0.9714335927942188,-0.009675702789753955},
{-0.014701597829037762,0.9717170227189581,-0.013874613908140775},
{-0.005901111943576169,0.9714378696104804,0.04512634459486843},
{-0.031399700143466935,0.970569871580695,0.027505973409006727},
{-0.03176026650267733,0.9706029260593186,0.002082075751934025},
{0.06785413588293639,0.9625295827974819,0.018623850648432798},
{0.05830682842843655,0.9631525304366932,-0.024089118675983765},
{0.02452164316762284,0.9683662070605639,-0.0010531240748633047},
{0.02545713383050483,0.9683344384221234,0.025445540304070056},
{0.05074102864936486,0.9626278936654054,0.062139365942002804},
{0.009730357985803743,0.968345312157586,0.0429453499962288},
{0.0019523246938779563,0.9631179804700303,0.08670601351603922},
{-0.013788399721506594,0.9683346480699793,0.04408846191913369},
{-0.03796538181392484,0.9631825939392384,0.07782806973606085},
{-0.06334850995127443,0.9632725887755419,0.0552753973020795},
{-0.07710488945691346,0.9626257552572748,0.012518066491340978},
{-0.05669434290907604,0.9632787803755546,-0.03587511581908447},
{-0.006015062541554398,0.96840204286741,-0.018551619973791348},
{0.017454134412606077,0.9628763543277703,-0.05465940997168642},
{-0.02628269913424312,0.9644830815193537,-0.05573136741227716},
{0.06936381009373223,0.9651520957807819,0.025838294597432775},
{0.09943233021097095,0.957674390030786,0.020234155830091305},
{0.08865605304828716,0.9587833712827398,-0.02496122580374601},
{0.023667398037188713,0.9650957983431936,-0.055091717827207655},
{0.06065531768746758,0.9553766774824695,-0.0641530056454883},
{0.08762029480415952,0.955811095793074,-0.031086521187966207},
{0.16068989630600408,0.9262278545562967,-0.05760784151186739},
{0.16479020304946923,0.9219896414531787,-0.0663311350567631},
{0.21931121049491017,0.8781131824342576,-0.08844804743386167},
{0.03209661154626202,0.9576421881201099,-0.08096160635653415},
{0.005337941896362264,0.9584690113109839,-0.0867158250356983},
{-0.036143723640407285,0.9576590438077294,-0.08265816066613621},
{-0.08799659872909095,0.9579260513170849,-0.04582898637239319},
{-0.07839887795349369,0.9649812747077423,0.0117592949945128},
{-0.10731619374058732,0.957674390030786,0.00814106650757471},
{-0.0972563811373982,0.9579896025704895,0.05775434343361498},
{-0.05213409672267362,0.9579612302273158,0.104601470641973},
{-0.013174746470576608,0.958275156926836,0.11580858812518628},
{0.03731849238956269,0.9649430908449094,0.0773465784935305},
{0.03277152390070465,0.9576566957517425,0.10904722114597168},
{0.08011284701166443,0.9579260513170849,0.07420330023601669},
{0.1947313411294243,0.8761268249050947,-0.13039799639823585},
{0.24062965804778474,0.832684574548922,-0.14658179059241447},
{0.18866632649205559,0.846330525540563,-0.1882375477087764},
{0.2336017028549265,0.7810406764430632,-0.2166638123111077},
{0.29128067788432244,0.7475465802419936,-0.17636145789370616},
{0.2985454792483249,0.7978068164750145,-0.09096365398714336},
{0.2435977266038077,0.8787245994413906,-0.013379803038494844},
{0.31531558861301584,0.7932499805604025,-0.03624169208349918},
{0.3260771205431635,0.7810477206110237,0.04253696994933491},
{0.28151194036435356,0.8348713833814337,0.06925709234678477},
{0.24273791881692866,0.878302131058576,0.022594245603819},
{0.22568084346699444,0.8782946675949035,0.10294546222771436},
{0.25997715020064804,0.8358240372154573,0.13559681597738052},
{0.19567201708261045,0.8787939229990958,0.1575061909535986},
{0.20357514026192802,0.8239914702952853,0.23129278812283965},
{0.14578815465713948,0.8785341553290328,0.21158730129113243},
{0.09947427375868745,0.8461552319799298,0.2753954292252983},
{0.04604181388750585,0.8783019214107197,0.2558960961186223},
{-0.004129601537205177,0.8503744649638215,0.290870459924558},
{-0.02828486411174556,0.8782230099577352,0.25854657612590737},
{-0.08167230559998986,0.8782944579470476,0.24777370923501396},
{-0.10803592880663503,0.8487150462777725,0.2723750465409505},
{-0.15388025441382291,0.878302131058576,0.21024719026624017},
{-0.18675839123754706,0.8467259213969113,0.22570248611399174},
{-0.20280696256462896,0.8803420046971044,0.1601877966792325},
{-0.23070568327873653,0.7839090923848848,0.2524244114830029},
{-0.28088630923258623,0.7810389713071682,0.1959057954067958},
{-0.25992711424569137,0.8487999257063903,0.12114896193667775},
{-0.22773458181706396,0.878222800309879,0.11528460825051388},
{-0.24509894501774634,0.8782946675949035,0.06366168890677514},
{-0.29153755241397317,0.8329069969475761,0.06746316359634938},
{-0.2496670879400567,0.8787342013131937,-0.002355917781394001},
{-0.2926963320199804,0.8357466212505118,-0.011603890027148612},
{-0.23505108234234717,0.8788003102704409,-0.07103315909989201},
{-0.2788579941791832,0.8260545868927784,-0.099972376099672},
{-0.23632850865830626,0.8416815703580407,-0.15072704583619825},
{-0.20339192201233935,0.8782225766854994,-0.129074433577441},
{-0.16736691496450257,0.8782946675949035,-0.1699234797205777},
{-0.19388590120894067,0.8329076398676677,-0.2082336903279919},
{-0.09876785831975533,0.878302131058576,-0.21369361932347772},
{-0.1273439233034347,0.8378037838488954,-0.24623729793432084},
{-0.05596545321998458,0.8794923578429775,-0.2280900397568507},
{-0.09951824390234495,0.7706643794365111,-0.31002433529417667},
{-0.03642945969156231,0.7706600187611071,-0.32225573629553456},
{0.009000741517478273,0.8466596027918079,-0.26514458549575487},
{0.020872428727573288,0.8770210428933991,-0.2301330860662661},
{0.06519195752528847,0.8767130981460358,-0.22193185761229162},
{0.08958783993238045,0.8347208142912804,-0.2611727649349481},
{0.11926715579328412,0.8772458273245637,-0.19903727747828068},
{0.1496780168827881,0.82044892468435,-0.24613693251740904},
{0.15661631267591247,0.876642712372527,-0.17227120027080353},
{0.17114443389240197,0.7475480757300328,-0.2904588513006822},
{0.23709109574611295,0.7180183645791449,-0.2601731499811887},
{0.28584663341078637,0.66608400635711,-0.24191410756691858},
{0.34647443132302774,0.6660596872058182,-0.14634915135491322},
{0.3310508621841453,0.7258752534179606,-0.12049206532132421},
{0.3517480532571803,0.7250924562768389,-0.037270909314520755},
{0.36119474371734117,0.7181294779428057,0.01670470622189205},
{0.33402904974334946,0.7424428429537904,0.12011539800677586},
{0.2996244389273049,0.7454655457410774,0.19271930173790597},
{0.2521000513085174,0.7503461058983453,0.25270845637478656},
{0.16919786752630117,0.7559463452155658,0.31411973627781237},
{0.12913207974956922,0.7975152801665111,0.3048864673350227},
{0.05490231496586803,0.7708812811082913,0.34704588246055224},
{0.009630439817651361,0.8068607526418127,0.3269274592352148},
{-0.04118983572126785,0.806809151316198,0.3265761034051432},
{-0.0720709369516988,0.7882729125067728,0.33499614831464897},
{-0.1634758088282419,0.787877307002569,0.2993042856864625},
{-0.22805317667551042,0.7287011108450214,0.2958070379889393},
{-0.28118419088286345,0.7170739149645513,0.2514868662711325},
{-0.32964281127739703,0.718129575778472,0.17925912669969643},
{-0.3028292837718535,0.7878236790810134,0.14501753805644937},
{-0.3352372223842218,0.7705462358814136,0.0783104135465388},
{-0.3526340111199599,0.7499858050930858,-0.01093419091605762},
{-0.3236449678130792,0.783906534681042,-0.06307779167486825},
{-0.34236583650099023,0.7422067515149277,-0.09119598574112255},
{-0.30724864659904816,0.7459869818884309,-0.16418163026491545},
{-0.26800980780190387,0.745987079724097,-0.2183594860997147},
{-0.21923064981212517,0.7459877226441886,-0.2641304629103627},
{-0.16266326964462086,0.7459903921602212,-0.29984479978870854},
{-0.11402949545469124,0.6463893233782468,-0.3634399674307863},
{-0.03687582792995686,0.648433990964415,-0.37710526193127086},
{0.03295516144600527,0.7170801065645642,-0.3488713142954771},
{0.027031421510508743,0.7839086591126491,-0.31325678377309385},
{0.10666179892298167,0.7503433385466466,-0.31780407372199765},
{0.10504417004288814,0.6661074589639304,-0.3568759489666524},
{0.1880807800303485,0.6661221762434191,-0.31958578699069223},
{0.2193090441337319,0.6659816422973047,-0.2995212292878139},
{0.09373629580009864,0.7256339487357462,0.3622735007367271},
{0.14444611487197234,0.6488756630908359,0.37764039507188063},
{0.20411509530322486,0.6666238915157882,0.33809590367726466},
{0.22136875045943455,0.7156563460451424,0.3021393955722331},
{0.2614700665594905,0.6659259738032843,0.29184852307872433},
{0.2746947231963102,0.6666130038038017,0.28009386130182834},
{0.3203442999218314,0.6658169988477544,0.22163962247760177},
{0.32889668853454535,0.6660094695560529,0.20594592906457176},
{0.359021156676279,0.6661217569477073,0.1402731930994632},
{0.36532304543783944,0.6664369555108871,0.1217435791622862},
{0.3794756733677739,0.6657218746272417,0.048218007550243934},
{0.3789640766931271,0.666513309260029,-0.02195797833749235},
{0.36464347890099436,0.6957133142161044,-0.0390260392350791},
{0.37660954957584436,0.6659675679379077,-0.04145686419540901},
{0.3428210518789064,0.6957144882440978,-0.12436961422956588},
{0.35426627342039974,0.6659285315071273,-0.12806973116904347},
{0.014854696669986293,0.6661128958316618,-0.37046189874191654},
{-0.3825157629505823,0.6650844333329218,-0.05923326929220276},
{-0.34912204614294806,0.6659632911216459,-0.15542015285718686},
{-0.31072256747846444,0.6663426978348456,-0.21828636092755452},
{-0.24136497693779246,0.6661573691301736,-0.2900226300185163},
{-0.16421499921532304,0.6664458026504086,-0.33599913161062755},
{-0.3901576089952739,0.6672553648344751,0.029579209009680918},
{-0.3802863816267862,0.667243736366731,0.10236463983102834},
{-0.3375624547077646,0.6658893972406805,0.20974213460469945},
{-0.26227866436341946,0.665849843678522,0.30004143550107887},
{-0.20869337120524017,0.6663102722997899,0.3405892316517192},
{-0.17307157289051683,0.7171469562775693,0.33752029452393023},
{-0.13085142976937642,0.6660705749178045,0.37890717127675666},
{-0.09145862558681223,0.7474845244766283,0.3553828509130015},
{-0.07939492889370177,0.7076782108629609,0.37651278311379327},
{-0.38800184202196863,0.6665636387219841,-0.021947621733407734},
{0.39297109719883283,0.6124295573595101,-0.04378895899210366},
{0.39814418599778884,0.5951334694772533,-0.02357875193542532},
{0.4018176217534641,0.5541024769481874,-0.04491805246170643},
{0.4056133381152612,0.5187208931468276,-0.024469811229366697},
{0.3900779008804365,0.6091817486810127,-0.058222515049029734},
{0.3606720357063284,0.6571220776460324,-0.11554536825376173},
{0.3767072035471523,0.6574365494299783,-0.05640509176220265},
{0.3682323007820026,0.6158988520095714,-0.13401727312445377},
{0.3817311348848519,0.563104923601561,-0.12246346797009491},
{0.3973540651582322,0.5629515871597089,-0.05906774532165742},
{0.3780259863968312,0.5538092494803126,-0.13753842067755684},
{0.36554762022114795,0.5921575600914173,-0.1556313660838086},
{0.3266359858210683,0.6160622096189385,-0.2138565017310379},
{0.2698289502011498,0.6148375307035399,-0.28006683070493277},
{0.2967606212617909,0.5789019873841048,-0.26331528216375655},
{0.33432433176021276,0.5210523030938594,-0.22234526920772868},
{0.2306332709092866,0.5966616066758977,-0.3152280466566272},
{0.23493820793669618,0.5194325497821587,-0.3210730708104712},
{0.30635329651232135,0.5190804531963292,-0.2586580808322327},
{0.36944036161068505,0.5190740519484605,-0.15719406722563956},
{0.10059398898086676,0.653577840875726,-0.36036117685376695},
{0.17873532153157068,0.6538532622523676,-0.32932761970247915},
{0.12517943497932127,0.6335740251449821,-0.3583503604080751},
{0.1001927649141231,0.6191571011512959,-0.3698113893979081},
{0.09273211052307916,0.5908732852788301,-0.37855149670085203},
{0.028562354013899324,0.5977005375909124,-0.3884392722734372},
{0.029014536486165938,0.5320073959011566,-0.3955362016109076},
{0.1148759836144547,0.5576937586973723,-0.3768791217773045},
{0.1136476708028861,0.5320193318524227,-0.3794485099939028},
{0.18984679766289322,0.5319742296103431,-0.3485196929114545},
{0.15183653723126841,0.5591694420024546,-0.3628537640724639},
{0.16879136033358721,0.5878883191056166,-0.35168346075275786},
{0.18557357336782906,0.5998744460920202,-0.3414185985699123},
{0.15688688419881944,0.6209447963721472,-0.349405706680329},
{-0.19699201588985393,0.651737034864697,-0.3220181074390614},
{-0.20586780728517778,0.6135837526657336,-0.3341203234315743},
{-0.17386876585108132,0.5694322775893591,-0.35710006252467774},
{-0.22152932674057915,0.5644735467348642,-0.3308531293146621},
{-0.17462661489734327,0.5188056607632555,-0.35925295033409455},
{-0.23789467597802247,0.5190528355854369,-0.32407568933315695},
{-0.28314955567338235,0.5644741896549558,-0.28304792538107293},
{-0.30486482468802534,0.5193363773223663,-0.2653807048876651},
{-0.33460328919735827,0.5644757969551849,-0.22445171302878753},
{-0.3525333801490973,0.5193382921061174,-0.20305357133759921},
{-0.37963472620783184,0.56195339781137,-0.14667505593527091},
{-0.38822859714297914,0.5192968097836841,-0.13099647114439406},
{-0.4076427153844678,0.5187128845987297,-0.06392022664274975},
{-0.382886909538257,0.6145820398497386,-0.11230433818927384},
{-0.40134313274932293,0.591587192134482,-0.06266478539861943},
{-0.35041994806617294,0.6107298443555449,-0.18513695375473685},
{-0.339536051670761,0.6516306176130097,-0.17921169037815365},
{-0.27553989756284303,0.6517079357422891,-0.2650749544545274},
{-0.08624369107580583,0.6254126996662596,0.40276550260463356},
{-0.07303844783044834,0.6250506797485811,0.40552221816879747},
{-0.07501078690630901,0.5763161487990752,0.4154343687987693},
{-0.0890003088043036,0.565744082624624,0.41321696535581065},
{-0.08887609943790686,0.519159364649314,0.4157314398106702},
{-0.07532611125820239,0.518939485977979,0.4195418454989085},
{-0.13656819136494167,0.51878859542778,0.4041532176693533},
{0.3339870642660618,0.6110416326469343,0.23030860325127908},
{0.3478384561800236,0.5851718559297977,0.2170086271280734},
{0.342567643527141,0.5189943997397181,0.23639702856589712},
{0.3514587531924739,0.5190277756783874,0.219082463719268},
{0.3777241074607669,0.5954067664222878,0.14688865914745067},
{0.3840836913122886,0.5188250741547178,0.1488533949944017},
{0.3985348577891157,0.5964393939250997,0.03317272700266274},
{0.3874319213137927,0.578450182277979,0.12723558427973444},
{0.19773985774512454,0.5967536420846659,-0.33636570787504233},
{0.20137919078289632,0.5193467199499271,-0.34254820917089307},
{0.027952879743564883,0.6536722103639571,-0.37339330687619326},
{0.015756783441151376,0.5798650816813553,-0.39322480604585847},
{-0.045195647187788214,0.5714221432259783,-0.39340016948911033},
{0.016216093940520756,0.5190595582933516,-0.39625857823994043},
{0.07384609523076355,0.519048782393555,-0.389722065574509},
{0.1489868917608176,0.5190498446093584,-0.3676557062837451},
{-0.23704185645300893,0.6394916992691794,-0.28324267426273964},
{-0.19677433153274482,0.6394966050290091,-0.31039182003263394},
{-0.20172838025178977,0.6154711424303576,-0.31788678678943727},
{-0.33475223701075874,0.6154781865983181,-0.18789354353018714},
{-0.29095506681096317,0.6394913778091336,-0.23143867507754295},
{-0.32826578825333147,0.6395081216845633,-0.17922422731994028},
{-0.41268418725944966,0.5536154929318308,-0.02425184734178292},
{-0.4131025325677637,0.5190928224198312,-0.024451180523233373},
{-0.1179776397842978,0.5650682338430915,-0.3798125285544748},
{-0.13824570964922217,0.5735956324313745,0.4000858815453695},
{-0.12550409564906695,0.6250539782081816,0.39221388408440067},
{-0.1285943329990219,0.5667145425498807,0.40290350679995274},
{0.2144678837968616,0.5986700331360315,0.3538249856483814},
{0.14296317775107376,0.5717948272312633,0.3964125016957892},
{0.21869165915096575,0.5187328290980938,0.360391254332836},
{0.2773612762058859,0.5779318349423702,0.3081167634292852},
{0.2795515372397592,0.5190085859113048,0.3109195875452374},
{0.2910213993925901,0.5765188503227447,0.2955362148886051},
{0.2938357960701915,0.5190807746563749,0.2978386794549902},
{-0.28469510762059547,0.6105067650602756,-0.2728412334899955},
{0.013319165890288235,0.6247907024306621,0.41218482703132936},
{-0.005537554608287352,0.5773481333817955,0.42028810800699745},
{0.016351023300619105,0.6057005180796852,0.4143213902610283},
{0.05120353977266862,0.6079556860897648,0.41038887168495297},
{0.08973210561033106,0.6259626059924528,0.40122618418700445},
{0.07698877249775693,0.5671028942382683,0.4126368697383586},
{0.092232897048458,0.5196446435297755,0.4149020309629059},
{0.04617139023901525,0.5307230092763795,0.4198809718707156},
{0.03159106670639074,0.5193379706460716,0.4229414811546949},
{0.007954584739694818,0.540903411326319,0.42280951481762746},
{0.40558305098833625,0.519115324623038,0.052089448717615186},
{0.3909477997174492,0.5188092806829018,0.12922908381252374},
{-0.22052111622472514,0.5783409836980693,0.36016168993055553},
{-0.27959856824211377,0.5187446672136938,0.32037922026637317},
{-0.22185303700671113,0.5189695494805244,0.36250774727445734},
{0.010712907604087756,0.9219454896147126,-0.17226728684415887},
{0.016199112464187683,0.9232764879461325,-0.16446750608130775},
{0.15020461036739816,0.9219457132390925,0.12010520912097598},
{0.1405517661822061,0.9262267923404931,0.1208654900823671},
{-0.018596156166659966,0.9219476280228436,0.20063710026714104},
{-0.024080739750007102,0.9262280642041526,0.1926593284745766},
{-0.17274111196342284,0.9219465658070399,0.09472234653757729},
{-0.16857588426722755,0.9262265687161136,0.0859832455443419},
{-0.15808573449836327,0.9219476280228436,-0.09172919012145732},
{-0.14843557380572756,0.9262270019883494,-0.09249123212483853},
{0.23583639525774036,0.8368031346323799,-0.02936022483586476},
{0.23737230340357912,0.836802505688812,0.052285595251654986},
{0.198113198647025,0.8367975999289824,0.1526130379484493},
{0.21892604545393338,0.8368033582567598,-0.08294860680578856},
{0.09070858941731585,0.836802924984524,-0.024042073697105475},
{0.09911750901393186,0.8368035679046156,0.01750476436982138},
{0.08249016983915236,0.8368022820644324,0.0700284566914945},
{0.009581424148927008,0.9545492113715038,-0.08825654110570053},
{0.14078272823685964,0.9319894109104195,-0.055662798586853246},
{0.17520349591433718,0.9111466124131561,-0.07186192502756467},
{-0.058102058379254785,0.836802924984524,-0.22490425889067112},
{-0.15256056309010152,0.836802505688812,-0.17974263056164402},
{-0.199497838876524,0.8368033582567598,-0.13025487679523118},
{0.014919477857479128,0.8368031346323799,-0.2280993481216555},
{-0.08437333869360973,0.836802924984524,-0.048668890205803526},
{-0.04841347622288277,0.8368037775524714,-0.07939569061424508},
{0.0012185292449569402,0.8368031346323799,-0.08793147511676667},
{-0.22897421561285464,0.836802924984524,-0.07937518705393182},
{-0.24994696782776848,0.836802505688812,0.022401565247664474},
{-0.22680946173479033,0.8368033582567598,0.11132290669288833},
{-0.20433746179578388,0.8368031346323799,-0.12328974607654344},
{-0.09912199547804951,0.8368022820644324,0.052606566119135674},
{-0.10620466876131433,0.8368035679046156,0.0009906350372623721},
{-0.0897985080745767,0.8368031346323799,-0.04134155787462888},
{-0.17654328547918366,0.836802505688812,0.18967761883139228},
{-0.08611138930216888,0.836802924984524,0.24361628043906047},
{-0.03125370137657369,0.8368033582567598,0.25576405989893625},
{-0.22319745280091252,0.8368031346323799,0.11899626979859322},
{-0.01816021441496869,0.836802924984524,0.11527064570330671},
{-0.06711518309675867,0.8368042108247071,0.09703972405478327},
{-0.09464042314372846,0.8368033582567598,0.060613227386251925},
{0.05021607041803132,0.8368018627687204,0.25327840503600985},
{0.13517723374671628,0.8368031346323799,0.2142473272641258},
{0.19226892922546251,0.8368012198486288,0.15917750366134262},
{-0.022802726420051336,0.8368031346323799,0.25647329859566204},
{0.07649046749717826,0.836802924984524,0.07704232354843198},
{0.03622081814530705,0.8368042108247071,0.11032414430707643},
{-0.00908441896505534,0.8368033582567598,0.11594751477107168},
{-0.41463923737545516,0.5190022964756259,0.04893408076707413},
{-0.3814601300897093,0.5189537699852321,0.18236638745555564},
{-0.3167930888661831,0.5189645458850287,0.2814016865569022},
{0.0128835595751665,0.6836700372241649,0.39342205672527303},
{-0.041903281351636644,0.6820486905887589,0.392733503283669},
{-0.27458046511480994,0.5967795405831392,0.31533484127445527},
{0.049692174402501336,0.712146645264975,0.3764894702722101},
{-0.3126667159059598,0.6475301850808309,-0.05268638604616295},
{-0.25305545851771605,0.6394553323544315,0.09943460139607725},
{-0.18076584487572317,0.6470440396558982,0.2757731168260791},
{-0.34025665328128,0.5198359402100807,-0.05257077224186074},
{-0.28064313169619187,0.5110647910479302,0.10218407712094851},
{-0.20180209243794667,0.5190548621813779,0.29468480699248845},
{0.40767651061884913,0.43353715367772755,0.04828572380772026},
{0.40067840928068016,0.43353715367772755,-0.06906829746422741},
{0.3609000347379509,0.43353715367772755,-0.17970455851100098},
{0.2777611445498277,0.43353715367772755,-0.28961390055852915},
{0.1447642624816594,0.4335372654899173,-0.37256610631917847},
{-0.02965735874212238,0.4335372654899173,-0.40078248546464246},
{-0.19866581641882206,0.4335372654899173,-0.35155069775383785},
{-0.33420936087600217,0.43353715367772755,-0.23821084590960162},
{-0.4076815840969635,0.43353715367772755,-0.07824388529357956},
{-0.41462137537812704,0.43353715367772755,0.05811973169351256},
{-0.37828512512332624,0.43353715367772755,0.19106364273674065},
{-0.2856439598401642,0.43353715367772755,0.3175024323868369},
{-0.13420340547924037,0.4335370558420615,0.40852152425535904},
{0.04100330503555491,0.4335370558420615,0.42562842591239397},
{0.17211974367139338,0.4335370558420615,0.3875897931375954},
{0.2858710224446968,0.43353715367772755,0.3097694873604671},
{0.37505612884577066,0.43353715367772755,0.18087203151476888},
{-0.38553122589857675,0.6643482478984427,-0.021193364653744644},
{-0.4063321926603139,0.5933061088820535,-0.023190707730559916},
{-0.38773324118890773,0.6645488249905052,0.032415618712158534},
{-0.40657619481160834,0.5964249981056567,0.03265785982146293},
{-0.4141232101427857,0.5200602913690096,0.02947066732638656},
{-0.4111949327498247,0.5200350218141039,-0.023643463240299496},
{-0.3771344798541304,0.6645486013661256,0.10513672957129623},
{-0.39974786630719894,0.5785041316595801,0.10681071179507283},
{-0.36761989144168467,0.5816432868425935,0.19615976281951045},
{-0.39607103425625706,0.5200332188425427,0.13404525412496313},
{-0.35978448451984346,0.6645503065020206,0.15761210505043155},
{-0.3360536051118689,0.6645488249905052,0.20718341047570785},
{-0.3079028876748927,0.5964325594049954,0.27888705836028166},
{-0.34360725929181835,0.520042918550012,0.2447610695448131},
{-0.2932248822179128,0.6645483917182695,0.26706848194036414},
{-0.2620840832000375,0.6648786290209839,0.29917413629748013},
{-0.2797781246424849,0.5200841772480655,0.3195655909139011},
{0.06916539936284802,0.9310553178999106,-0.13182112797408982},
{0.11606307965754077,0.905195464514623,-0.15317812277941426},
{0.08642085749061901,0.7043100223855692,-0.35748402558461373},
{0.07458355252890207,0.7115276529819796,-0.3617647552729214},
{0.0833919211737479,0.7176528225774863,-0.34817617791119576},
{0.0888395648048742,0.7006622335509402,-0.3434893183963149},
{0.07456408323134489,0.7181730846968464,-0.338438188743435},
{0.06324350432848397,0.7154022388671905,-0.3524914435896426},
{0.06436820916963523,0.6989085571888498,-0.35972063277117866},
{0.08188374245099127,0.6949470513025563,-0.3579806394258209},
{0.07530455945860928,0.6885839733201021,-0.3516736492330987},
{0.05698699733947785,0.7022407141880633,-0.34917850431055913},
{0.14403513519166453,0.700728985428279,-0.3373585162617448},
{0.14246150440827596,0.7163463670217382,-0.33124114556648004},
{0.1584602913578283,0.7089148397061493,-0.33282953555892847},
{0.15610731563467964,0.6941678880576048,-0.3311976646011531},
{0.1643624096111131,0.7037275926886539,-0.32277236451872443},
{0.15466039601543566,0.7187094477715443,-0.32012716763740967},
{0.13694761205466505,0.716911200275276,-0.31820847045962825},
{0.1385351914087371,0.6933963000885154,-0.32913008949258993},
{0.15955384252758334,0.6917619413095161,-0.319568763584788},
{0.15827697527257348,0.7096505918683927,-0.3113528318278486},
{-0.19018236002114902,0.6444043495249334,0.3316464787312006},
{-0.19564198153311274,0.6049326618424318,0.3410949162568278},
{-0.13970235692898292,0.6048634500969164,0.36929684367675414},
{-0.13529562887924096,0.6448446379755051,0.358640471111158},
{-0.19767063202308527,0.584680930533749,0.34452386068287805},
{-0.20042213434389752,0.5438624650245354,0.34810247970156266},
{-0.14135295642855766,0.5439939421832723,0.37700524592745244},
{-0.1405127017983782,0.5847763622377837,0.3728011075891902},
{-0.20627305659075595,0.6581651595885952,0.34751479483172476},
{-0.21344246818029486,0.6063587564413166,0.3605445069155455},
{-0.21493827767954962,0.595261522387676,0.36175033150043107},
{-0.21821040550933882,0.538444898872478,0.36713868671789085},
{-0.1447564775579413,0.538429007564996,0.4027906883003967},
{-0.14292152771035563,0.5952078944661204,0.39724431450563513},
{-0.14206840070182,0.6049924813640003,0.3950285183629055},
{-0.1372799737889865,0.6582306396022745,0.3811616684136973},
{-0.2136851285853112,0.54455057121738,0.37272008568112214},
{-0.15127210929691876,0.5444344402816998,0.4025575738610886},
{-0.14963640877164117,0.5896606541268876,0.3979089261620881},
{-0.2110452008534429,0.5898504692956774,0.3683356082571598},
{-0.20291737710210325,0.6532749975595242,0.3545856998820081},
{-0.14419346125248844,0.6532770241554653,0.38277998214345355},
{-0.14874818671201717,0.61171981550793,0.39442418745330404},
{-0.2028987743490174,0.6526333912611324,-0.32660838917496154},
{-0.2452738751887626,0.6519257738411594,-0.29877985856303074},
{-0.30722773771954665,0.6522497356847184,-0.2395130386256118},
{-0.3451335376128066,0.6502879069547034,-0.1847377982135054},
{-0.3536984631673072,0.6141260837160648,-0.19092770706693363},
{-0.3097707941654359,0.614405991556824,-0.25274830344394333},
{-0.2534376884887094,0.614405991556824,-0.30611227834884336},
{0.09177467671793961,0.6079806481611482,-0.363986575297379},
{0.09233266147484932,0.5774809942163817,-0.36953308885737796},
{0.12659009949600727,0.5504890284323654,-0.36266206207297047},
{0.1586589257130922,0.5680985258827644,-0.3477372312069024},
{0.1646318630121216,0.5975498566885691,-0.3399168630245956},
{0.1441961167919973,0.6262217167659002,-0.34114551127273374},
{0.11104385840833852,0.6290791471600692,-0.3526740189191397},
{0.06432827824133597,0.5977140668658839,0.3994000814789405},
{0.07188565017659791,0.5546612304139024,0.40402629685735286},
{0.05074406155501447,0.5328589575390343,0.4087146378837492},
{0.01994754624620307,0.5315184831245251,0.4119641516981417},
{-0.0020919361894261843,0.5529184417637983,0.41185644860627124},
{-0.00384460624180789,0.5836325235356449,0.40807353474021163},
{0.02142239095986145,0.6075717090533052,0.40275615231025763},
{0.12383513099730974,0.6187910420182593,0.4194435346309851},
{0.14993582783952875,0.6429250463002047,0.4062974120810095},
{0.12782071843399145,0.640720948507838,0.39443297868673083},
{0.10973568374017142,0.6169374474880164,0.4082685351993055},
{0.11597499960498851,0.6337058237637646,0.38137317514731733},
{0.14309158007458977,0.6467182748407779,0.3660360228546632},
{0.17035291540047226,0.6441132464886656,0.3968291139151605},
{0.13422269308198906,0.630650583629232,0.4121728072209207},
{0.10747526055716895,0.5823723302734458,0.4157268555108864},
{0.09703189021323207,0.5932406288683741,0.3976520236793899},
{0.12407129231879117,0.5839219214360173,0.42845351463064957},
{0.132755102184147,0.5628351487405067,0.42977885246995823},
{0.10944969611158924,0.5549779384416451,0.39844781898758136},
{0.16428449049131316,0.5449936270196504,0.41263246713338336},
{0.13634131045521755,0.5407771613874576,0.40801618906334375},
{0.16612399668563513,0.5337917786858838,0.3958237126805765},
{0.13444791078538917,0.5357988214701683,0.38980033410740217},
{0.19222927782763785,0.5517610458336405,0.39989919711789557},
{0.19505185077162188,0.5466237089823881,0.37987972768057315},
{0.17730500602251903,0.5353876461185282,0.36922789748518947},
{0.21239675865127078,0.5754348311421743,0.38919383683662245},
{0.20070309042393655,0.5638047560978158,0.3529388740438407},
{0.20273302675409235,0.619537779728155,0.3809155418307956},
{0.21094307439454102,0.5922695260230258,0.36297689724653337},
{0.20029690469126843,0.6234273065172341,0.36350379821466544},
{0.2017991853210106,0.5958587811762697,0.34673736467571586},
{0.173919738233128,0.6452737312305681,0.3725963934461034},
{0.18065073422627528,0.6337635048772023,0.3501191103811266},
{0.15100501792842075,0.6463348289122198,0.387100824454869},
{0.12278696160010903,0.6299855247240196,0.4031933379725609},
{0.10799114802460111,0.6013586690531021,0.40954380913061006},
{0.11309879873944893,0.5675618413480205,0.41193921757980584},
{0.13387569792732137,0.5647254176690192,0.427773976046852},
{0.13720612183759226,0.5432284340020058,0.40663026299366145},
{0.17784427621415302,0.5392765299875156,0.3868854322476517},
{0.20101016862682872,0.5589802697537565,0.37111447661143715},
{0.20946012329711872,0.5758596475809757,0.3894020031810708},
{0.20812567276433747,0.5921148059053244,0.3638207019137405},
{0.2012632135889771,0.6142177836882632,0.3625045186974755},
{0.18372146034910186,0.6368491299743261,0.369074169700673},
{0.1484674123267866,0.6434873218499,0.36440012665805344},
{0.11252119094322101,0.6279170690944614,0.3839678888249161},
{0.10121509171894533,0.5871929730734793,0.39716154553210065},
{0.1149047333237692,0.5543784434092545,0.39630502222829833},
{0.142018742113004,0.5348732401626115,0.3862180392629763},
{0.18007659260793263,0.5419186660101335,0.36719271995863456},
{0.2020739218479894,0.5845771688215706,0.3490727998615822},
{0.18174614427368652,0.6287830265517822,0.35065818490142836},
{-0.03701060354829417,0.6238849677868034,-0.41179355424948205},
{-0.06560939435956002,0.6480238918051022,-0.40574157970875424},
{-0.04724935758481031,0.6458187317969318,-0.38862774569594877},
{-0.026229406649257103,0.6220285080691957,-0.39739229793889813},
{-0.039133819197830155,0.6388079677282626,-0.37297536688706734},
{-0.0681466365715772,0.6516838262388535,-0.3652829258264698},
{-0.08776135985817576,0.649209855749766,-0.4017980196789314},
{-0.048910397547612075,0.6357470810781426,-0.4074139266792544},
{-0.022143188241712724,0.5874660603706578,-0.4040246755806},
{-0.016658087526987542,0.5983526961647211,-0.3838795152653654},
{-0.03657896656591202,0.580992931240346,-0.4227578855389654},
{-0.028463553967645435,0.5600722974824247,-0.3878211744879608},
{-0.08351378248415786,0.5485224057547107,-0.41504832323679747},
{-0.04904683637227336,0.5622239274047057,-0.4228702428132383},
{-0.05202018805426658,0.5458736588363682,-0.4039355752418154},
{-0.08392793483535262,0.5388897716228336,-0.3997490892530253},
{-0.05482906400499427,0.5409002107023846,-0.3858398485073412},
{-0.06696394313346633,0.5532588120462176,-0.4173203189814491},
{-0.1159612467056373,0.5517149792114233,-0.391709345554238},
{-0.09759099309204028,0.5394758212393949,-0.37772591742059014},
{-0.12230973319731663,0.56872456233372,-0.4081937328442976},
{-0.12398987906805856,0.6247269415294016,-0.3948588154117646},
{-0.13170997966911968,0.5884405734877967,-0.4026493017863347},
{-0.1356460482822227,0.5973679382556875,-0.37942289102590404},
{-0.12521570405840304,0.6285266831300332,-0.37721808043082694},
{-0.13094876228063856,0.6009616658965253,-0.3613879062635645},
{-0.12789501763414507,0.567871393395613,-0.36737265372514644},
{-0.12855533849781262,0.6080580641260938,-0.3965280875470439},
{-0.0973958528677091,0.6503695857593871,-0.37928213345540995},
{-0.1067258533312405,0.6418184131042376,-0.35942795038772946},
{-0.07817375808575967,0.6507384262206461,-0.3896714426055556},
{-0.053467317321366545,0.6461460899357575,-0.3883625271816307},
{-0.07486478813941576,0.6485852029746598,-0.3648595908991838},
{-0.041548641038488154,0.6374167305795626,-0.3730103641024896},
{-0.0327293707051322,0.6272995583229819,-0.3932904118482514},
{-0.02383177593278814,0.6004743604201227,-0.40131724123911144},
{-0.02152012879031183,0.6054611281812219,-0.3818719693262265},
{-0.027749018168425635,0.5674178831535921,-0.3871377224775186},
{-0.034698565063153386,0.5710009467068231,-0.41101714437970543},
{-0.048868216398992144,0.551199622851893,-0.4046638499638627},
{-0.05487896019471367,0.5436764933997718,-0.38565660230470505},
{-0.07515447954678664,0.5419221880941135,-0.3989598768875112},
{-0.09288003805024728,0.5413592696243269,-0.3784974075540134},
{-0.10375293492148295,0.5470084407511294,-0.39456360327751994},
{-0.12630137246877382,0.5709012521630505,-0.3933393017282622},
{-0.13311742958534753,0.5921666308553187,-0.38174113508758134},
{-0.12640785960307974,0.6193111923254294,-0.37649626286274335},
{-0.10776913094513538,0.6419462703433282,-0.37837365941289974},
{-0.11056027068724854,0.633879090728457,-0.3600627361425406},
{-0.12864694063434512,0.5996730164320102,-0.3623183374248558},
{-0.12249993970877078,0.5648192560493487,-0.36926050471505373},
{0.05928955974152908,0.9391423162254324,-0.1655143337322303},
{0.04206778503594961,0.9395238473702393,-0.13131113859967208},
{0.05327379837378813,0.9505692564738856,-0.14022605028491877},
{0.05771144249402289,0.9422086397432838,-0.15478300506986517},
{0.08491181222339106,0.9258736195623367,-0.18152676176894403},
{0.060504538949458356,0.91127073792041,-0.1719632694999638},
{0.08888665171332369,0.9016840585985603,-0.18201880528689124},
{0.1263709755569538,0.9127958002838337,-0.17313148325948943},
{0.12264674911404039,0.8951024856206203,-0.17351054055959583},
{0.14599433633521808,0.8978606407667288,-0.15044987739409027},
{0.15059301796188057,0.9221293368078693,-0.14550796029764376},
{0.13805502793596117,0.9149915680680569,-0.16047821486583735},
{0.15203500386824753,0.931802810342088,-0.12520570385567353},
{0.14995782688788123,0.890707106508148,-0.11964028005906674},
{0.15106399885856525,0.9192176215955292,-0.10418150405690613},
{0.1407210498376351,0.9096213543784,-0.08533725061749854},
{0.05494372740568276,0.9504664731183685,-0.10016493066711296},
{0.03970716415432013,0.9281613109431381,-0.11109376158631977},
{0.04264170302991257,0.9094132020104753,-0.14979900466046484},
{0.06991946077117887,0.8907924052324777,-0.17177148364132805},
{0.10505433097564054,0.8799798869437597,-0.17121862826862758},
{0.13707478444409277,0.8812573412127662,-0.1481560922489421},
{0.0738150254185097,0.9656421825854068,-0.1040176991987797},
{0.07880394556426333,0.949072147157924,-0.07949574854763476},
{0.06080910137807894,0.935730940289712,-0.08195532321727919},
{0.10270563206875354,0.9620309703133813,-0.08848827186915928},
{0.129996262188376,0.9361478739691294,-0.08126734281314815},
{0.12807780261149806,0.9500128510641577,-0.09272410896324321},
{0.11184042242533511,0.9557786842345419,-0.09063830846773491},
{0.09764797537929124,0.9309943243503491,-0.06801706720832963},
{0.07366365966650379,0.9163822741088551,-0.17656264995281282},
{0.053742934369340356,0.9216588730425623,-0.16211921249360897},
{0.06732429984482075,0.8934949058610895,-0.16836228804330966},
{0.04441572921055513,0.910679782544019,-0.14643119354921375},
{0.04472591020171555,0.9334368476610417,-0.1378419348668976},
{0.0501926457642583,0.9461064825639829,-0.11190472142275923},
{0.04251617987028514,0.9274249158608029,-0.11152634897231563},
{0.06575504371335997,0.9348665761560967,-0.08123589563475357},
{0.07450357886011372,0.9558085380892314,-0.09201274583491031},
{0.09460070186328515,0.9482376368789979,-0.07889816829899535},
{0.09983676887817272,0.9292131282130326,-0.07087073791761495},
{0.12080221137117532,0.93723530342149,-0.0802323532778257},
{0.13302538020005564,0.913206752011094,-0.08291073042647774},
{0.14291839696903988,0.9254477269312079,-0.09556953352352726},
{0.15195222091818927,0.9162816151849453,-0.12582176106868526},
{0.14648152999943068,0.9012479351520608,-0.14524567685330925},
{0.12764432072798346,0.8950602625424293,-0.16564592270315698},
{0.10157342183435879,0.899121896244731,-0.1785702937276178},
{0.10436154264734605,0.881613281342622,-0.16888029994234893},
{0.13578456960891988,0.8828499940449527,-0.1462569062982891},
{0.1470411919391881,0.8946200859040475,-0.11407822460467909},
{0.059304891988061895,0.731958311747466,0.28967254605210413},
{0.015696754271727054,0.7734356585384026,0.2676028463721687},
{-0.03399491697591998,0.7759377777462839,0.26570809097953835},
{0.04902274084536123,0.6766047786894688,0.31832305000117445},
{-0.004290778808870202,0.6453028443294996,0.3347422088549818},
{-0.06440671449251395,0.6625944597241624,0.32272779338454655},
{-0.0876854952873643,0.7017483911396414,0.3013899044871623},
{-0.07669715233011119,0.7469745071491631,0.27722566898438666},
{0.07560614488767518,0.6685406040271996,0.4257810914811069},
{0.009275254420077369,0.6664213856634509,0.4353219278051193},
{0.0016527658607530442,0.6572992999669406,0.4407254894803983},
{-0.055973154284560324,0.6692630365623276,0.43247180713286165},
{-0.08030700887933447,0.6576199493743754,0.4359370346145173},
{-0.07987569335699812,0.6683781968214464,0.43032107170809947},
{-0.05236877653263958,0.7035516562079291,0.41425304505998406},
{-0.01129686074208955,0.6960521890104845,0.41965989121833985},
{0.03600144262882645,0.6704336542839349,0.4306657607363515},
{0.020692369172347784,0.7043556557355506,0.4140592605584549},
{0.04947362350092086,0.7305533216994147,0.3972766561815485},
{0.05369523249384671,0.7680950750790552,0.37665034006035303},
{0.08489456519310709,0.8301371154980576,0.3386496675240076},
{0.10145815744314984,0.6564675710162371,0.4271000560255943},
{-0.07756144658110786,0.7273081825369498,0.3996705831192288},
{-0.1316299500942364,0.6677950263687735,0.42159666004130536},
{-0.08684195617410806,0.7561106532285466,0.38290711260331},
{-0.09015675433084779,0.8301343481463591,0.34254284218578046},
{-0.07378208275207594,0.7932964804548555,0.3654998973808687},
{-0.057384629439622685,0.8298114624951274,0.3486104983861344},
{-0.04829386513279352,0.8134632205227303,0.3573901312981894},
{-0.020029728205740924,0.8213591457923265,0.3547121454922018},
{0.010394256839546402,0.8298743848049636,0.34953971358986113},
{0.013207814925723958,0.8155314665044329,0.35671064862048674},
{0.03958737136942238,0.7961107233906956,0.3641497791649851},
{-0.08512549929471319,0.797195595139214,0.2909135914767916},
{-0.12438206032394832,0.6437076198169467,0.36568184376679785},
{-0.05325821454982817,0.7972845277597137,0.29678088023293897},
{0.006547540142655154,0.7972312073216802,0.2976969295513113},
{0.045307599142872905,0.7972164900421914,0.29327502299679753},
{0.07904808748079512,0.7970454593212961,0.28627257495974817},
{0.057521781066994224,0.6340198482989511,0.37756975772094453},
{0.09465167424533183,0.634231522750856,0.3702844947261999},
{0.008775579720173074,0.634516014891399,0.3821539596690217},
{-0.03425715849068332,0.6346342702586862,0.38210427312715833},
{-0.07629271366290942,0.6349037236596949,0.37891207703658625},
{-0.07587705184715171,0.645030176328033,0.3736687981354535},
{0.00835389402268734,0.6637818073446757,0.42057359248072534},
{0.009997826720442452,0.6598322513861723,0.42254899241528304},
{0.07322275624888804,0.6616808283443958,0.4134619598402901},
{-0.05516919668651006,0.6618318307067846,0.41957689862042563},
{0.05181541800508478,0.7443054942714107,0.3155228115421125},
{0.05371247952413067,0.7152187271106034,0.330585269237359},
{0.040068862611952735,0.6887055411235136,0.3464585190507601},
{0.008572584689505123,0.6688786262536321,0.35954282343627386},
{-0.03971355142566518,0.6677791350612915,0.3600334413488005},
{-0.08228365272450423,0.7031432482079877,0.33792854878211054},
{-0.08512637981570824,0.7374352781253798,0.31901827024459806},
{0.034807959314395315,0.7708033200589203,0.30406014729900294},
{0.001993807016311341,0.789427638920898,0.2972299878699847},
{-0.03876503464266597,0.7880537885677192,0.29759171428066483},
{-0.07264155648606127,0.7640740711312394,0.30712422059653366},
{0.12295792243838569,0.7164392410219302,0.3817934352393825},
{0.09239478712283329,0.7168641692729214,0.38935634187804186},
{0.09580325594161765,0.6818913009550249,0.4074423968580943},
{0.12840032487311293,0.6815879265309216,0.39928791987599976},
{0.12089283515104664,0.729663688010894,0.37515805264507845},
{0.10859691851614686,0.8109234485599179,0.3342445467744947},
{0.08325748099198013,0.8105640981582721,0.34089257812277524},
{0.09110299294047883,0.7300987492415901,0.3825089913248347},
{0.08361036026313852,0.7118501053609758,0.35376601869476054},
{0.11421545310293117,0.7111648783320198,0.3457186577905399},
{0.10182351774999995,0.7921825934430718,0.30440722631281303},
{0.10771157562041142,0.8155122767373503,0.3311972592819649},
{0.08263180793064155,0.8151234917767272,0.3377867010427654},
{0.07516993758203303,0.7964640918401845,0.3092200562360807},
{0.10106196492494932,0.7967549852285963,0.30209520180419597},
{0.09951143733528797,0.806531689367092,0.29712700884313525},
{0.10617215936711617,0.8253177585382074,0.32627201617832946},
{0.12177817804678207,0.6632346823467049,0.37008602808922075},
{0.11629475451490459,0.6979826683977709,0.3524206664734692},
{0.08839731964098028,0.6638505858179558,0.3790369712526458},
{0.08167612119096837,0.8249279113617811,0.3327170944255131},
{0.0756213792985419,0.7919273122371263,0.3116086581182195},
{0.07419577387798756,0.8062224587795453,0.30408230008911646},
{0.08492415349384545,0.6986731086700787,0.36070397905131546},
{0.1502003754807077,0.9344048477181217,0.016840292478605752},
{0.14866804532494401,0.9287569624315024,-0.050722894109823974},
{0.09955012435297517,0.9535935665614018,0.026989121561437124},
{0.13077058955611673,0.9314635022754725,0.10433545546580231},
{0.08128335292108194,0.9510514465426027,0.0694283466920598},
{0.09678928571431067,0.9483777515294002,0.034176562866588954},
{0.09036275431411785,0.9478023660004455,-0.023935600539323285},
{0.09086533613095818,0.9537108715250756,-0.024128770073808398},
{0.15859338979331788,0.9170787941689857,-0.0552875708542491},
{0.21844584005158624,0.8749747680070021,-0.08255314106682204},
{0.18954922349613812,0.9123229884625402,-0.012106346055275363},
{0.1958619859931612,0.9040973569981318,0.07257004560239201},
{0.19827325779679156,0.8756320559650199,0.15220742525325412},
{0.13368469475401454,0.9223059162086857,0.10683285060866261},
{0.2354997567071573,0.87618419853501,-0.03259279910349543},
{0.23737279258190971,0.875658709195775,0.052282548369481645},
{0.15029925938610397,0.9281135391850257,0.013578199792855357},
{0.19959413712503007,0.8984398698397092,-0.015780047364901493},
{0.23488652275193922,0.8708261304444754,-0.021434333899389518},
{0.18072325840791503,0.9083590366845941,0.06489947780143329},
{0.2277431913556822,0.8711485828234714,0.08565092573959171},
{0.19446663974648432,0.871411537140945,0.15009343410938053},
{0.03731613035705216,0.9541282245002045,0.10971415290536396},
{-0.009198439445652224,0.9501356907312284,0.11557853454457526},
{-0.015590868127941585,0.9277004490496343,0.18174318823891744},
{0.033449021912037497,0.9120926553514546,0.20659023283204367},
{-0.022668943134898926,0.8760093242700888,0.2572240196148212},
{-0.014450621392401546,0.9260145867806864,0.17396072438896895},
{0.07585871464801672,0.9337831859190939,0.14749877633787672},
{0.11693485134873348,0.9354543309085533,0.10570781033094181},
{0.10060676352355682,0.9032199946974468,0.19420325914503692},
{0.05886738486571275,0.8737941430944034,0.24942942414227423},
{-0.022331871312080212,0.8718600437874705,0.2541720639633652},
{0.07623658394360601,0.9508341395516342,0.07675054963902521},
{0.1350602781961359,0.9190779402173627,0.11856098494351729},
{0.1607071712893355,0.9057734077474207,0.13734179894171022},
{0.14467679739615127,0.875658709195775,0.20811623162255724},
{0.19030848417129687,0.8732552223158624,0.1579255984777162},
{0.037769934106071566,0.9479866185127903,0.10778586783230318},
{0.08163687511233195,0.929308252433545,0.13970248970595836},
{0.06096113800322394,0.9053972156346791,0.20010010824887514},
{0.1581320946275787,0.8726983836338987,0.19305498988487532},
{0.09690442431680603,0.8708237823884887,0.23285748790756408},
{-0.13949713963104174,0.9356618403563861,0.08094435932625023},
{-0.08353492896456274,0.9362832925075579,0.14168813443241085},
{-0.0961263652172292,0.953987900201946,0.06220094650556126},
{-0.09392313396933366,0.9480538036623648,0.060132476899479294},
{-0.06414265602966558,0.9479868421371702,0.0971117730346162},
{-0.053429454918579464,0.9536204434165364,0.10428585278308126},
{-0.024786624081037465,0.9260211976764111,0.18487086869594752},
{-0.12590360060339173,0.9057143429581336,0.17951605713544203},
{-0.1525129171207028,0.9144944510719956,0.13574702167791677},
{-0.22413150388185024,0.8773230336416534,0.11958540822689916},
{-0.1529888736598357,0.92230548293645,0.08705326024813406},
{-0.018033545180395318,0.9508343491994901,0.1149049220068396},
{-0.025319031799519585,0.9150805006885571,0.19285388168491105},
{-0.03145436232777858,0.8763814631909483,0.2560475177767231},
{-0.08591200021462352,0.8763695272396821,0.24400273132022057},
{-0.16719670885850735,0.8756593521158665,0.1970466012032851},
{-0.12641680457826754,0.9236366909157256,0.12337187212998642},
{-0.16008355277698538,0.8961242393879696,0.15311473924429456},
{-0.07996640099601182,0.9242257175318419,0.15832019767221142},
{-0.06656551437146886,0.8995957702818281,0.2076629869344871},
{-0.03265789476277225,0.8711157379927037,0.2545622046467903},
{-0.12447782746455262,0.8715011126815367,0.22298972671696166},
{-0.18593119068053227,0.8708261304444754,0.17289066775560563},
{-0.22084386211071969,0.8714106845729975,0.11806103071313839},
{-0.14323031104914294,0.9276974580735559,-0.07968353712048348},
{-0.15311028772148624,0.9335618117597199,-0.030953506611618997},
{-0.08988214359258256,0.9537279228840272,-0.04148288848259599},
{-0.08914771920009365,0.9478874550769194,-0.04098317185312051},
{-0.10631684434077873,0.9536923107015609,0.0008653914081095548},
{-0.13152002473509267,0.9423035403394168,0.06713788795955956},
{-0.19939817228579879,0.9126145247710437,0.02993087232327472},
{-0.19380325802411974,0.9047113456856312,-0.06543465287161411},
{-0.20349044252811865,0.8738662200272838,-0.12253539116121424},
{-0.14156587479107458,0.922307621344581,-0.07845607687686247},
{-0.09927380847881481,0.9537110811729315,0.052634085894361866},
{-0.16936147671309537,0.915080081392845,0.0850076562348759},
{-0.19403466732753263,0.9036379905926674,0.09619902217584442},
{-0.22554810842112183,0.8732558512594303,0.11054315643394003},
{-0.24619958228503294,0.875658709195775,0.04592555017485018},
{-0.238271804517854,0.8757676841513048,-0.05792229931928948},
{-0.2356265237773968,0.8711490160957072,-0.05727937922766693},
{-0.24353867579104457,0.8712115051333081,0.04594395725660381},
{-0.14953542838768524,0.9325641674958064,0.005660443193191518},
{-0.188777411902669,0.9083236341499836,-0.0365079448605733},
{-0.19459307138015428,0.9064746239195246,0.04814450501194299},
{-0.09765740953280963,0.9479616704179308,0.052194300598644584},
{-0.10572639211924208,0.9481022183405688,0.007347158030086988},
{0.0077076754714643,0.9276983106415037,-0.15337380808817094},
{-0.03862237626494442,0.9192831016092086,-0.16733663482583946},
{0.0012992157164555698,0.9537277132361713,-0.08807449688410525},
{0.0010670796338086395,0.94772131613933,-0.08796146873669324},
{-0.04834163689090582,0.9536963638934426,-0.07956827272927454},
{-0.0902756805712742,0.9346833718830319,-0.11324917914653182},
{-0.12071758351998459,0.902769363619314,-0.1611609540735693},
{-0.08067463338302898,0.8756593521158665,-0.21862614419597703},
{0.014786547140274301,0.8760091006457092,-0.2288501390234333},
{0.0074782927639923625,0.9223035681526989,-0.15132915447852652},
{-0.13646219340896634,0.9287559002156991,-0.08552322224226222},
{-0.198443659574119,0.8739837346388134,-0.12970838074082827},
{-0.15755879160065994,0.8724827678023018,-0.17303730944259044},
{-0.0650547919213932,0.8713070486495326,-0.22047384063320533},
{0.014551685635499844,0.8714109081973771,-0.22559383261850757},
{-0.08412048940279357,0.9508339159272543,-0.048377088343349285},
{-0.13479480810439073,0.9233643443743048,-0.08431260370973696},
{-0.05612295466590837,0.9326917032748512,-0.12247880021662773},
{-0.039057507378259304,0.8999519200595393,-0.18604605674081484},
{-0.11704810312052519,0.908379721939716,-0.13987465252527587},
{-0.05455898166041788,0.9479258485876083,-0.07384682899825942},
{-0.06723462646856315,0.6352739617733271,-0.45532920971374835},
{-0.10761997348387896,0.6390448977585493,-0.447141119192081},
{-0.08649258501040613,0.6443400575157712,-0.4505876880145558},
{-0.09937878614855779,0.6431910894294229,-0.4478582126951435},
{-0.05427535606434623,0.6101474146586298,-0.4620491782296719},
{-0.05554991719294045,0.6197380353601717,-0.46066418858707964},
{-0.059526489771815724,0.6284260242061231,-0.4579514012370021},
{-0.06099644270216828,0.5852665468780748,-0.4650256606529809},
{-0.06701488756246556,0.5814402638588779,-0.46305615881143763},
{-0.05055168868238204,0.5892064031291089,-0.43376216173327187},
{-0.05345601031366822,0.5833250959196594,-0.4341563276555314},
{-0.057317723820522755,0.5780097959917413,-0.4342737304548711},
{-0.062018028751232766,0.5734212892743548,-0.4341102051272193},
{-0.08231742000583815,0.5706468235250528,-0.463331384516747},
{-0.09196337376483085,0.5704617044682365,-0.4610715763007886},
{-0.1132373759722411,0.5761648389531642,-0.4564642991120317},
{-0.11806482533933131,0.584769639529869,-0.4526774159132325},
{-0.12687636665506408,0.6001737673242418,-0.4497827660363682},
{-0.12159156350192676,0.5954734064874369,-0.4190253151113846},
{-0.12195774842367701,0.6019375766660371,-0.41790439790816447},
{-0.12120022083746089,0.6084017328681135,-0.4170015144751467},
{-0.11934134318124788,0.6146688340621077,-0.41634324816046764},
{-0.12370246583405582,0.6225177283293493,-0.4467603847091268},
{-0.12795452967219134,0.6101527397141713,-0.44770264000949456},
{-0.06665571885562825,0.6384944603244542,-0.4223952786072903},
{-0.09412591935214566,0.6408075330723512,-0.41650137854995933},
{-0.05998145357230479,0.6424048959930349,-0.4042706204686931},
{-0.055703016033889,0.6305175131467899,-0.4256810195711935},
{-0.038837223387736194,0.626910130442267,-0.4025208854862949},
{-0.06447079685382023,0.6436976964850978,-0.381920202309622},
{-0.08703910901785648,0.6460196303490402,-0.3970800204691781},
{-0.10670110090771305,0.6346888625603793,-0.41479914977172255},
{-0.10860786213422818,0.6373321726109905,-0.39699825780535214},
{-0.12349224494061897,0.6125264845515841,-0.4155220155790859},
{-0.11753791039467545,0.6253802741312037,-0.41542276828407265},
{-0.04939742349353988,0.6210934367020257,-0.42781116757649995},
{-0.03125354763481265,0.5916649295594734,-0.4109138718458577},
{-0.02981393773747993,0.6069569656335242,-0.3920754745698933},
{-0.03699292324577455,0.6120275506074375,-0.3707503741917228},
{-0.056114401033385046,0.631435183741915,-0.36543975639925447},
{-0.08677186390759747,0.6412509103346673,-0.37124164900086487},
{-0.11497741124717004,0.628206257346978,-0.3776513526664856},
{-0.1285965832193426,0.607582261328722,-0.39712720521329364},
{-0.12443325633037468,0.6021322836181325,-0.41637528235285887},
{-0.1186186870217404,0.5788181701712903,-0.42179528042004544},
{-0.12449995230161867,0.5914433457522434,-0.4195888904777867},
{-0.047492115825492745,0.5887897909097375,-0.43330997926100523},
{-0.04251230837321169,0.5667164573336319,-0.4118341280978729},
{-0.035072045730291164,0.5800866654885855,-0.37585324493545463},
{-0.04741644692601352,0.5895923089258434,-0.356074129776733},
{-0.06335396079552949,0.6128471339590189,-0.3490099753874116},
{-0.08382382371008097,0.6200279783449697,-0.35028487195257535},
{-0.10393148501214552,0.6194874502662,-0.35618521518734636},
{-0.12378952560037575,0.6044988864519187,-0.3721167610812292},
{-0.12082538444752122,0.5715465901932785,-0.37997471213584844},
{-0.12314052572093026,0.5752914040556476,-0.4027359422569426},
{-0.10880954337166544,0.5687173085179036,-0.42533403839304956},
{-0.10456557194077011,0.5561035517568388,-0.4100295352598308},
{-0.09919790197843216,0.5640126848413607,-0.4275525739344304},
{-0.06296054960555142,0.568795465238607,-0.434225427588857},
{-0.056418376448008935,0.5545870150728912,-0.4100275086638898},
{-0.047642992399168076,0.5637601849636378,-0.3719358070284849},
{-0.07041341907287724,0.574465643080577,-0.35041752313930563},
{-0.06181100848173031,0.5941932827023978,-0.3476660068419696},
{-0.08687197774708208,0.5920033710816177,-0.34504641495212984},
{-0.10999799513755344,0.5871361445279892,-0.35618380355844953},
{-0.10142378917129552,0.5611332973284104,-0.3669355938515567},
{-0.09129575715577576,0.5484925519000213,-0.3908499710395946},
{-0.07564652306473385,0.5630759223148192,-0.43241933926277576},
{-0.07996574409939648,0.5497672388173293,-0.41083514208768135},
{-0.06155280618232521,0.5505932094402556,-0.38760909471686783},
{-0.07635627889283766,0.5524754837971942,-0.3710121265281555},
{-0.0885256241288302,0.5683530523564282,-0.3545110233157138},
{-0.08977648107317676,0.5613956087257925,-0.43117306661821286},
{-0.07741177198847338,0.6385980123887767,-0.4205557584364446},
{-0.08382140577147551,0.6391626220179348,-0.4192265910296337},
{-0.09026598086380495,0.6385980123887767,-0.4180735138453087},
{-0.09654842828085566,0.6369180202597958,-0.4171329077747411},
{-0.10247866729988708,0.6341758542568356,-0.4164326839358218},
{-0.10787500311239716,0.6304538500811956,-0.4159952187430439},
{-0.11257530804310717,0.625865357340333,-0.41583170739191583},
{-0.11643702154996172,0.6205501552480809,-0.4159491101912555},
{-0.07123135319465843,0.6369180202597958,-0.4220218957758186},
{-0.06546603715565193,0.6341758542568356,-0.4235802502187694},
{-0.06029472337520974,0.6304538500811956,-0.4251833714672301},
{-0.055871153614372025,0.625865357340333,-0.42678231373509534},
{-0.05233090015332877,0.6205501552480809,-0.4283295009355851},
{-0.04978297987718117,0.6146688340621077,-0.4297760711417357},
{-0.04830286601407623,0.6084017328681135,-0.431080080805831},
{-0.04793528343995291,0.6019375766660371,-0.4322010119855749},
{-0.048692811026169035,0.5954734064874369,-0.4331038674655453},
{-0.12011144963882182,0.5892064031291089,-0.42032932477547996},
{-0.11756213171030115,0.5833250959196594,-0.42177589498163065},
{-0.1140218782492579,0.5780097959917413,-0.42332172645931837},
{-0.10959970614079328,0.5734212892743548,-0.4249220104734619},
{-0.10442699470797799,0.5696992850987147,-0.426525117745399},
{-0.09866307632134459,0.5669571330722785,-0.42808350014139707},
{-0.09248125987515654,0.5652785246191468,-0.4295496374807711},
{-0.08607162609215441,0.5647125173376156,-0.4308788188641058},
{-0.07962844865219806,0.5652785246191468,-0.432031882071907},
{-0.07334600123514735,0.5669571330722785,-0.4329724881424746},
{-0.06741576221611595,0.5696992850987147,-0.43367273993444133},
{-0.04482039150213662,0.598482034915327,-0.4335415842357504},
{-0.04556506068652029,0.6125754303376897,-0.4314029664570629},
{-0.07397252686443351,0.6409430634229698,-0.4531294306672144},
{-0.08028732993392132,0.6426238102842321,-0.4198178958191179},
{-0.11643579161587336,0.6334630235935111,-0.4461436705994998},
{-0.12517725464161927,0.590982581694406,-0.4513520221678289},
{-0.12012464347722383,0.5827660209938986,-0.45367390012567627},
{-0.10159434469038399,0.5705470171690902,-0.4592238519105129},
{-0.05499317634664279,0.5971263121134271,-0.46390889447730876},
{-0.052527424053509304,0.5786390330666311,-0.43556813824716323},
{-0.07030480750696422,0.5760577787813852,-0.46437238395727365},
{-0.08494651593181496,0.6019375766660371,-0.42505199214415945},
{-0.015812423982124204,0.7641276012171287,0.40487671242028467},
{-0.01553775733776407,0.7776882674609636,0.39631119985178737},
{-0.038657177809034424,0.7714351288141766,0.39662670589848925},
{-0.023611967144071884,0.7506852043171051,0.4091863735127153},
{-0.047593361763399566,0.7539250184240283,0.4006118740394591},
{-0.06560651519567146,0.7573530403995122,0.3852358809873567},
{-0.051144293288573256,0.7811251365759693,0.3803366062648133},
{-0.026027585646582547,0.7914159112338119,0.38211560808790407},
{0.0022769434340524164,0.792492886246422,0.3783500390877946},
{0.007564108619700241,0.7689407805534897,0.3980679929786698},
{0.003833872271582519,0.7400626968685089,0.4087101514196315},
{-0.010044592168846145,0.722521237135632,0.4102596028169656},
{-0.03681762968514129,0.7262611592146951,0.4082513440751165},
{-0.06656865908930831,0.7336404422845776,0.3897022887934298},
{-0.07955254215181541,0.7331436327720382,0.37156285746924894},
{-0.0753460417810427,0.7683671979960963,0.3604344278146408},
{-0.058339994719250055,0.7897522297080249,0.35489219107090353},
{-0.033289396034506626,0.7975197526541052,0.36721123885257806},
{-0.011914874668423583,0.8036003650919575,0.35545000810952854},
{0.012924482836650649,0.7994237884584929,0.3418059858781624},
{0.029573275975357114,0.7851758825662845,0.3621886492611567},
{0.031190150123169152,0.7642209084895564,0.38509118203717047},
{0.03167556876886791,0.7404539277207849,0.39367341052804994},
{0.012125137491431596,0.7091126354699895,0.4007661748614485},
{-0.03078600496296575,0.6928970446843231,0.3966313600808917},
{-0.05499904648660978,0.7183691893013148,0.3974837603101933},
{-0.06438584754258368,0.7024939687980677,0.3800372291264969},
{-0.0767371112114579,0.6993643036746678,0.34894643811053083},
{-0.08634402853967013,0.7263406017755818,0.33465036911754587},
{-0.08327193271751794,0.7469742835247833,0.3240543332048961},
{-0.07665801806366461,0.7695807795516526,0.33573985311889526},
{-0.0557492084448197,0.7892693967192164,0.32016723833094624},
{-0.03384535419547535,0.803043316762138,0.33866115622651444},
{-0.007374027896959684,0.803304999215952,0.32952225677195596},
{0.007530005901796784,0.7908162065535652,0.30443868746773134},
{0.03809804697717875,0.7800683995697215,0.3319782953810965},
{0.05263308657291508,0.748590193292458,0.354735458333785},
{0.047791492963809135,0.7357279758690285,0.3711874899714075},
{0.03561840201945672,0.7108254724297381,0.3824382142086613},
{0.024785030757332117,0.6905703308492647,0.3782127197421382},
{-0.000585225001661295,0.6811150168739618,0.38403416550044817},
{-0.02956728004667657,0.6757504496998922,0.376408392458047},
{-0.05615107543165499,0.6799012256705498,0.35975885856358286},
{-0.01891537996867429,0.7940670062081412,0.30186292595631176},
{-0.06375684806859713,0.7763499174780615,0.3095399089816629},
{0.04810472083714289,0.7052120252975919,0.35014053639200615},
{0.025738313534923576,0.6821759049077578,0.36137511774435066},
{-0.013487666860388284,0.668893231720931,0.3669370613865485},
{0.05426891288690625,0.7420529818008399,0.33126911259046565},
{0.04125421158957247,0.7692230364502357,0.31678109002056015},
{0.06972764695949565,0.5485266685944485,0.4047959420896437},
{0.06644475720643366,0.5912295468687314,0.4000255868219943},
{0.07327020654695453,0.5595465984953335,0.40677338259666607},
{0.056619093305308725,0.6035445274820002,0.4032903210707298},
{0.032018860144746884,0.6093270905512906,0.4014210588573847},
{0.013753514318274186,0.6034837435802942,0.4076388928052273},
{-0.0005379703749270378,0.5890619138267785,0.4072139366011886},
{-0.004908331509921117,0.5750284497381739,0.4129733405706569},
{-0.0028582270560216006,0.5548742885416564,0.41154345833384093},
{0.00827635226902817,0.5392393105048202,0.4157428865836058},
{0.026763938799346302,0.5296313030077571,0.4115009417486514},
{0.04580228422380526,0.5317926326375072,0.4131319321854317},
{0.04529574705074908,0.5673439892726266,0.4165223852651269},
{0.02821028538111733,0.5726510849811148,0.4185029285604176},
{0.09416358608360048,0.578453704361959,-0.3721756162226601},
{0.08960318615543701,0.6022102306909799,-0.3656211856538056},
{0.09444634513520082,0.604264611961141,-0.36903465806808566},
{0.11910881575593646,0.5554296317355812,-0.3679244748350908},
{0.13848561667906348,0.5773581545493105,-0.3606298335929228},
{0.16214840246342102,0.6055442046382784,-0.3440263942737232},
{0.1454530395476431,0.6277607416765311,-0.34429801403591},
{0.10545422727262975,0.6251457899925701,-0.35913839874559583},
{0.10985540664245053,0.6272493266966929,-0.35352140157642187},
{0.14264747603303965,0.6272827026353622,-0.3418554068660749},
{0.16427737644073415,0.5951456150763754,-0.3404531422401512},
{0.15823195688963618,0.5648318349207065,-0.35223029224373026},
{0.15687328504122924,0.5671184640857043,-0.348569169805462},
{0.13250468480846003,0.5530288003951778,-0.35999095271665854},
{0.1014142991116822,0.565270208587527,-0.3686496048392987},
{0.10649765862828568,0.9546771664462603,-0.17096366852272807},
{0.08846196106323581,0.969281543576226,-0.15418896088172968},
{0.11060815425755068,0.9674461884094517,-0.15513023782543628},
{0.12960862330269882,0.9525967748654361,-0.15967864589623862},
{0.11638386883021297,0.9720812788804334,-0.14076223166480822},
{0.09038183226901057,0.9754015977640468,-0.1309267981735954},
{0.07346480168686019,0.9679742354525301,-0.1348783527749923},
{0.07176246109643354,0.9657114921665882,-0.14080719414165063},
{0.07114469874752667,0.9630881266153409,-0.14680032751747119},
{0.07162968412098976,0.960182393355158,-0.15267326278920582},
{0.07320623599783808,0.9570836443022509,-0.15824989575784482},
{0.0758226412402672,0.9538872412780358,-0.16335971283387093},
{0.07940063131538397,0.9506880429490747,-0.1678461769514978},
{0.08383118933808714,0.9475839828171498,-0.17157511348290855},
{0.08898153833293294,0.9446697099009674,-0.1744319149335096},
{0.09469234592938883,0.9420337654783623,-0.17633132450854228},
{0.10079170088556443,0.9397556619928402,-0.1772146408083367},
{0.10709511308821153,0.9379064421145255,-0.1770539107854311},
{0.11340970650984337,0.9365396359293071,-0.17585472504931773},
{0.11954400277534626,0.9356983051068002,-0.17365482021407017},
{0.12531071646672587,0.9354089072064278,-0.17051988594122372},
{0.13053653868971865,0.9356774102038223,-0.1665449625921487},
{0.13506073942141902,0.9364976224989721,-0.16185164592330414},
{0.1387463487292639,0.9378450292692515,-0.1565810988243724},
{0.141482952075779,0.9396786793001305,-0.15089544897063217},
{0.13800134410831066,0.9559620841789394,-0.13875481151438296},
{0.11918839808206036,0.9721949499479372,-0.12289741107889267},
{0.09540375098729291,0.9719533238056769,-0.11212037918392741},
{0.08963703729591331,0.9722440075462324,-0.11525531345677384},
{0.08441121507292051,0.9719742187086547,-0.11922885312999952},
{0.07988701434122014,0.9711540064135055,-0.12392355347469343},
{0.07620140503337526,0.9698065996432256,-0.1291927029212521},
{0.1015380472527958,0.9711119929831703,-0.10991907669630674},
{0.10785264067442765,0.9697464586616115,-0.10872128861256648},
{0.11415465522470167,0.9678959669196368,-0.10856057256618458},
{0.12025540783325034,0.9656191492742979,-0.10944247723708221},
{0.12596621542970624,0.9629831908751695,-0.11134188681211489},
{0.13111656442455205,0.9600691415833662,-0.11419868826271592},
{0.13554712244725522,0.9569648578270618,-0.11792762479412668},
{0.13912511252237197,0.9537656734746245,-0.12241548656412662},
{0.1417415177648011,0.9505679846102261,-0.12752530364015274},
{0.14331667198927633,0.9474692495338427,-0.13310053895641866},
{0.1438030550151125,0.9445649977851751,-0.13897487188052637},
{0.14318529266620564,0.9419401367458888,-0.14496660760397384},
{0.08274206872635481,0.9952712807965449,-0.14698312647134795},
{0.08432574863030591,0.9816387472676859,-0.17560732660275663},
{0.07945704056516198,0.9922205271261298,-0.15679502349659794},
{0.08026949588964065,0.9860219807810358,-0.1684504379784806},
{0.1205346867304417,0.9958078535190992,-0.12139402630377572},
{0.09521393581850321,1.0,-0.12989144524865595},
{0.08598223224637139,0.9980339084302471,-0.1391426880009636},
{0.15166693211579363,0.9735139983515667,-0.14890482860173146},
{0.13840090496873036,0.9875532207679487,-0.12723523486664115},
{0.15041337770236698,0.9783139558964784,-0.1404856642132207},
{0.1461055754875925,0.982698670921344,-0.13268229148377075},
{0.14739123397602913,0.9655253108939686,-0.1697004423548796},
{0.1354570996579043,0.9629277460055287,-0.18139364935693073},
{0.1414913240134938,0.9631557310606275,-0.17732506932233474},
{0.07293344220765789,0.953415491672546,-0.16495587377351376},
{0.08732673189971517,0.9433901312003536,-0.17642693790738553},
{0.07205457044240987,0.9197893872048376,-0.17191138864387462},
{0.055975753917974255,0.9210851786729792,-0.1558298746503589},
{0.06397148554353292,0.8964951064451699,-0.1518631415441902},
{0.08865234926949847,0.9065876520669368,-0.17483309707068206},
{0.09799316756239762,0.9240335682835892,-0.18011618111140043},
{0.09379242551940203,0.9403869256636711,-0.17924313755654822},
{0.12041750755548163,0.9333634848879783,-0.17530343504727514},
{0.10372826635709784,0.9377360543137218,-0.18072228703951573},
{0.11409422073608914,0.9352984367628586,-0.179081191576078},
{0.0703034098545911,0.9565445138758545,-0.15860390712742542},
{0.05375815480368333,0.9455121169158014,-0.14045404931654135},
{0.04916630769712529,0.9230350714517279,-0.13428064673763931},
{0.05512627478213237,0.9042451587365862,-0.12022866375509121},
{0.07002598983505598,0.8848604471010275,-0.12738369350171103},
{0.08835365698084488,0.8843658878088089,-0.15562953515919983},
{0.11344854726929161,0.8880641179175827,-0.15974680940247435},
{0.12068540956235597,0.9076448083688965,-0.17148110738429434},
{0.13807263835586212,0.9152649768252814,-0.1600506869814321},
{0.13680942616453742,0.9345496584804981,-0.16294911051970384},
{0.1300894436720901,0.934125694609644,-0.1712570497323639},
{0.06787922374303339,0.962126723477462,-0.15010144265747832},
{0.06924322064698181,0.9678789015841616,-0.1368679249046132},
{0.05727181094006664,0.9480742792696306,-0.11292306491831815},
{0.053718727030238396,0.9309395084242762,-0.10742162564735153},
{0.0664560781906557,0.9145816785566001,-0.09288112123083642},
{0.07122998349533277,0.8997661720591555,-0.09750532398983154},
{0.08982917256764235,0.8830997405475004,-0.1060184944769565},
{0.09221109367143775,0.8770626370280227,-0.12142888375396066},
{0.09869687155572594,0.8771573279762993,-0.13913445582848608},
{0.12253707533232382,0.8815911005994609,-0.12687584253542417},
{0.13235341689212024,0.8909210032273263,-0.14173353018148888},
{0.07560034463032685,0.9638217543459773,-0.10680921630703359},
{0.0987895918141569,0.9579746756431448,-0.09087702749305909},
{0.0827341021078282,0.9728963757678973,-0.11697533434972011},
{0.0752331953284392,0.9725306380949064,-0.12513554170654428},
{0.10151223261346479,0.9715182625749808,-0.1069324752698166},
{0.12411815560286096,0.9435315177144159,-0.08957100520954656},
{0.1007003503264591,0.933668242987931,-0.07964827435111035},
{0.07739336490671973,0.9448162257992386,-0.0883937346626433},
{0.11178100822295496,0.9701559288773562,-0.1052452433015431},
{0.13279391499054777,0.95964603028046,-0.11184705428584545},
{0.14600097518399027,0.93221803888561,-0.11131858794705546},
{0.13194545614093825,0.9188190390917709,-0.09247443234331394},
{0.09986078054594244,0.9155976739961725,-0.08019653144750334},
{0.1460186135569387,0.9407328446260117,-0.14357138714601053},
{0.14348458594537966,0.937666954380396,-0.15499161866307296},
{0.14752828776773455,0.9161636673011799,-0.13853790984260275},
{0.1443216679046722,0.949703187204375,-0.12627541107594362},
{0.14726526356764227,0.9456473258063742,-0.1355296028747585},
{0.1427385191086229,0.9026863989744474,-0.12282232919341012},
{0.12411185219065832,0.896927609972023,-0.09649757469926067},
{0.09373243827954891,0.8951099630608166,-0.09108688499687893},
{0.11361454644164379,0.884393393607511,-0.10710785268959225},
{0.1404171303291061,0.9559230617246826,-0.11809264560981772},
{0.10697533427983749,0.9677797381482903,-0.19000247517247013},
{0.11560884263628574,0.9657462517811071,-0.18918192744075124},
{0.08959210277211839,0.9763920021886676,-0.1829020796571145},
{0.09995398998270398,0.9705265862867004,-0.18865520816742765},
{0.12493868935805609,0.9631898477550548,-0.18802623664648854},
{0.1511657479513264,0.9679416002696183,-0.16083191875189587},
{0.12477126458028334,0.9657460421332512,-0.1073471447523894},
{0.13168213843384766,0.99176072744843,-0.12276134962037209},
{0.07917883786029793,0.9490619023660293,-0.17257137407097262},
{0.09114195948864064,0.9743137350394503,-0.11098080332152645},
{0.10367370200845231,0.9994218331428227,-0.12469824423205111},
{0.11300901355100149,0.9979782399362268,-0.12166955949260717},
{0.1074738768813196,0.9538258144562385,-0.14288690087281225},
{-0.08350334202093085,0.5966710967355111,-0.44404174119560597},
{-0.09102451475972971,0.6128468124989731,-0.4406753976193466},
{-0.06570636348120519,0.5983755198279737,-0.44291698044835975},
{-0.07504136754023226,0.5761002115074324,-0.43964933908268816},
{-0.060462204059077415,0.6156139265967927,-0.4370395587125075},
{-0.08709276489245951,0.6294861575076376,-0.43214608424731243},
{-0.11124141657127518,0.6181075201251983,-0.4259162025360137},
{-0.11078218993104817,0.5940078561620596,-0.43324930717148924},
{-0.09611167589078799,0.5809701215536172,-0.43844684091045066},
{0.1698488800251639,0.5716774244319236,0.46167381073183045},
{0.1807341880494726,0.5655176908932305,0.45763414812483383},
{0.20033894607465103,0.5671724134673057,0.44760765555421916},
{0.1925740786680798,0.564310300937687,0.45182377177331884},
{0.2088929699406415,0.571025265858115,0.4430983118672448},
{0.2144795402176532,0.5818616700258892,0.43699307279457855},
{0.22092746967567806,0.5921301661049047,0.43371535435529696},
{0.21658000208655523,0.5802077021840953,0.4374490568812999},
{0.21734218385517376,0.6141159507363598,0.43120036276905943},
{0.2075290149662643,0.5968401148369891,0.4036761989144169},
{0.20656463482883047,0.6033042710390656,0.4029955422087209},
{0.20459953559226243,0.6095727698854329,0.40283340055691835},
{0.201691021003857,0.6154526934190329,0.40319400884569995},
{0.1979271431631189,0.620767895511285,0.4040661299499859},
{0.20428777525392042,0.6319254801943958,0.43445823454464305},
{0.21358719508352858,0.6233454180646946,0.43125765253983245},
{0.1502175666048967,0.629904377027238,0.4250986178273259},
{0.15823588429280458,0.6341928077801214,0.41978096984342084},
{0.12260030512568253,0.621415148325264,0.4094947235792671},
{0.1433845559650374,0.6224385093928424,0.42917232724613097},
{0.12175521461829217,0.6008412860976309,0.42364614952816065},
{0.11026568749657183,0.5856975549168889,0.3970526963652841},
{0.11096406643435867,0.5963117463338652,0.38112987182220937},
{0.1228331819640872,0.6250010910423837,0.38413053363157285},
{0.15027074727769288,0.6404611948142988,0.4026288261790689},
{0.16731376224475383,0.6370857525210906,0.41564502296444183},
{0.1781048125930212,0.6381002524726236,0.37996256653672633},
{0.189073225027434,0.6312296030543568,0.40551890573267324},
{0.18067966563039828,0.6362868544246308,0.41013982400859156},
{0.13647027183968277,0.6002441391212271,0.43661876751254064},
{0.1197218540398223,0.5783706279049023,0.419951022207655},
{0.14304487053228104,0.5767199585227091,0.4371312866377537},
{0.13340942711913398,0.5602710576264023,0.4200468312778305},
{0.12802703987730737,0.5541548330060835,0.40141447591470747},
{0.15750122229941224,0.5620546996553718,0.43300844973803426},
{0.15701207192187733,0.5478595830932952,0.4166704246044849},
{0.14575637204217537,0.5432918734432204,0.38538116695153973},
{0.11990229096118854,0.5635368960205126,0.38299857497460527},
{0.11991296902531896,0.5805594773098789,0.3640414051999755},
{0.12658852014882566,0.616143888423622,0.3619825514422204},
{0.14731253217090026,0.6387130671321295,0.37996842270016956},
{0.15647538738713357,0.6262751350395998,0.35500807042915666},
{0.1832627648167766,0.6185493040638091,0.35656815796105},
{0.20337610058747593,0.6168582145749858,0.3831709194887312},
{0.20592600552999332,0.6145422626632004,0.40143091230661504},
{0.1980788024221232,0.6257289744217666,0.40362807774321136},
{0.19138263592611338,0.5601154849407532,0.4174010194294715},
{0.17938669742005042,0.5568260821276328,0.4225537025037804},
{0.1980367330856931,0.5588008111890514,0.3963260568965134},
{0.2077192913603371,0.5797383006345922,0.4058755167356678},
{0.20908845957806596,0.5834052792363037,0.38444296484305396},
{0.19037214723689125,0.5556383152114075,0.37380330819984},
{0.17310023874068894,0.5433463679092474,0.3892514760204887},
{0.16740265293568252,0.5593917665654424,0.35404525566238076},
{0.15042651563467405,0.5509880741887017,0.36384567796164763},
{0.13339679234168125,0.5668942107624418,0.3569491859510025},
{0.152901282785614,0.5859643527783887,0.34234307573209444},
{0.131829325205258,0.5882907591299247,0.3510384441825757},
{0.1361055963824955,0.6086708787855999,0.3512665270733406},
{0.20857830248536346,0.6040811002045541,0.40092729622701856},
{0.21082748854328628,0.5932663316955153,0.40291414293451194},
{0.20405702284712285,0.6015144513866071,0.37002418197171144},
{0.18247176345622493,0.5988088619462508,0.3474457787575415},
{0.1977497950534972,0.581496994568702,0.36100243373906554},
{0.18112024758796824,0.5772171873309604,0.3487664204848766},
{0.16194011033025904,0.6070321453546726,0.34438526947356224},
{0.13886612753763794,0.6141563708429897,0.43419296012423014},
{0.16684554869976786,0.5575388149552913,0.4307363002516216},
{0.17980083579472145,0.5562983705211243,0.4247151998518154},
{0.16513402553325,0.6335005505597286,0.4176065721639822},
{0.1709915866288806,0.6340651741654105,0.4146854926807427},
{0.18152087066419145,0.6385646364501072,0.4442861905956598},
{0.17692881390977744,0.6335005505597286,0.41192652689625814},
{0.18276261491506549,0.6318205584307478,0.40941354792943785},
{0.18831828309810808,0.6290783924277877,0.4072234266608019},
{0.19342390721701494,0.6253563882521476,0.4054232643807825},
{0.20745913234760965,0.5903759446583888,0.4048530222125608},
{0.20636057758235896,0.5841089552765846,0.40649105681730147},
{0.20426549667509333,0.5782276340906114,0.40854001519625505},
{0.201238181634975,0.5729123341626933,0.4109397843208548},
{0.19736947986625503,0.5683238414218307,0.413613479334057},
{0.19277679416827312,0.5646019350818564,0.41648427128491267},
{0.18760128743071167,0.5618596712432304,0.41946125686307595},
{0.18199949671935697,0.5601810627900988,0.42245642589861315},
{0.17614193562372638,0.5596150555085676,0.42537893098727325},
{0.17020470834282952,0.5601810627900988,0.428137882795234},
{0.16437090733754148,0.5618596712432304,0.43064947808620496},
{0.15881523915449888,0.5646033187577059,0.4328395993548409},
{0.1537082173832189,0.5683238414218307,0.43464118724028084},
{0.14920498143711497,0.5729123341626933,0.4359982937180299},
{0.15527374178284356,0.5921941366540211,0.4650256606529809},
{0.14544250124875,0.5782276340906114,0.43687044277536335},
{0.14253398666034453,0.5841089552765846,0.43722962545872446},
{0.1405674897714034,0.5903759446583888,0.4370674977834457},
{0.1396045072863427,0.5968401148369891,0.43638825270664644},
{0.1550461201173617,0.6143457387630199,0.4612867029540551},
{0.13967299225262422,0.6033042710390656,0.43521142940850266},
{0.14077154701787492,0.6095727698854329,0.4335733668507145},
{0.14286662792514054,0.6154526934190329,0.43152301081938776},
{0.16386801803717907,0.6296715980244995,0.4542012762956152},
{0.14589534061763196,0.620767895511285,0.4291246393471611},
{0.14976404238635194,0.6253563882521476,0.42644951872853837},
{0.15435533043196076,0.6290783924277877,0.4235801523831032},
{0.1595308371695222,0.6318205584307478,0.42060174119951943},
{0.17012010844468622,0.6358457134061117,0.44997902438259774},
{0.19334143175047874,0.6380932083046631,0.43839909710538577},
{0.22093026498042423,0.6050569969975422,0.43095807973018385},
{0.20204659774409542,0.56807517111161,0.41191890969082473},
{0.15738348406350294,0.6233301696773041,0.45832746756103004},
{0.15257917981971109,0.6050387576340733,0.46387795045376845},
{0.13856120171940034,0.5863765903458322,0.43925609561099493},
{0.16037740918842805,0.5801935160125083,0.46451864827811784},
{0.1494462581662819,0.5680961778267776,0.4372479207282882},
{0.17356606230011695,0.5968401148369891,0.42003149903129766},
{0.16135049670014623,0.5820337769391117,0.44126340394923036},
{0.18664260971496005,0.5752280764266228,0.4315196844067399},
{0.17797357303518782,0.600368907548573,0.4379995921510611},
{0.15396407162663725,0.6088123771118519,0.4387651143088513},
{0.18506643520425248,0.6132556397946265,0.42955068572005084},
{0.2005566723613314,0.5919896181822666,0.42120594632040725},
{0.17465216398272337,0.6272597811364435,0.42446029601201074},
{0.1990636162372516,0.6114489644545484,0.4161725249230944},
{0.42696183519415726,0.38422585352341754,0.1376288208330485},
{0.42696183519415726,0.29997984096099667,0.18905871040753947},
{0.5020604785286389,0.31225142446808085,0.1861007608546977},
{0.5020604785286389,0.3982907787669405,0.12116073016965916},
{0.42696183519415726,0.4217649373870255,0.07767284646350521},
{0.5020604785286389,0.43604227783821103,0.028547797464433592},
{0.42696183519415726,0.43604227783821103,-0.00889839842245857},
{0.5020604785286389,0.4172151456403738,-0.07063056533382273},
{0.42696183519415726,0.38974760068336534,-0.11393366541973013},
{0.5020604785286389,0.37237856932375674,-0.12803562845114},
{0.5020604785286389,0.2999756899334486,-0.16941087673622232},
{0.42696183519415726,0.298633929678756,-0.1690096247164312},
{0.43051482126831936,0.02223247726356765,-0.17187583236750312},
{0.5016142780085291,0.022439134143453117,-0.1717222024186528},
{0.5012378203418365,0.022209234304603014,0.19157852389446417},
{0.4296327349026132,0.02248253124963751,0.19135480167910326},
{0.42875997087823564,-0.04167937045320544,-0.09019867691377864},
{0.42898102357756396,-0.04149883569617306,0.10810913084967574},
{0.42696183519415726,-0.47125267717691477,-0.09007442561781073},
{0.42696183519415726,-0.47125267717691477,0.10798343997176355},
{0.4966739402592641,0.028595345598166056,0.1395295861308831},
{0.43234840141657943,0.028595345598166056,0.1395295861308831},
{0.43234840141657943,-0.028017933473270522,0.07281262214826593},
{0.4966739402592641,-0.028017933473270522,0.07281262214826593},
{0.43234840141657943,0.028595345598166056,-0.12164832915305991},
{0.4966739402592641,0.028595345598166056,-0.12164832915305991},
{0.4966739402592641,-0.028017933473270522,-0.0549034540525521},
{0.43234840141657943,-0.028017933473270522,-0.0549034540525521},
{0.4997532759207089,-0.04148123925279576,-0.0901985651015888},
{0.5007121632843164,-0.041677651340786506,0.10810918675577066},
{0.5020604785286389,-0.47125267717691477,-0.09007891208192835},
{0.4966739402592641,-0.07006075643783678,-0.09019138116839111},
{0.43234840141657943,-0.07006075643783678,-0.09019138116839111},
{0.4517072984128071,0.19544979734355045,-0.0241604967826776},
{0.4517072984128071,0.2466044612127321,-0.048595848892785724},
{0.4517072984128071,0.29187119300021586,-0.022364723131109723},
{0.4517072984128071,0.22276188142710004,0.06270140389079448},
{0.4517072984128071,0.2972563475937412,0.029677645666317826},
{0.4517072984128071,0.2662858105879561,0.0606365821574063},
{0.4517072984128071,0.18971756373621523,0.027840263903602985},
{0.5020604785286389,0.23756437578095124,0.06625536832161778},
{0.5020604785286389,0.2898244988181066,0.04440744812024459},
{0.5020604785286389,0.29725655724159705,-0.011795955416258982},
{0.5020604785286389,0.2623957526909752,-0.04483807879291807},
{0.5020604785286389,0.22305554216721052,-0.043727630005972365},
{0.5020604785286389,0.19081971046806476,-0.014411144701123523},
{0.5020604785286389,0.1936418501398131,0.03783092066737148},
{0.5020604785286389,-0.47125267717691477,0.10798103600968181},
{0.4966739402592641,-0.07006075643783678,0.10810054926410495},
{0.43234840141657943,-0.07006075643783678,0.10810054926410495},
{0.517209646577112,0.2204862378097546,0.17504046675327783},
{0.517209646577112,0.19689072103411398,0.17907797697561992},
{0.5420012043710264,0.21933876521144552,0.17785542249182848},
{0.517209646577112,0.23186540630009547,0.14761740907130483},
{0.5420012043710264,0.23024064939289923,0.1457279228281211},
{0.5420012043710264,0.21147973796449918,0.12975576115627616},
{0.517209646577112,0.2096677375688796,0.12939533456230307},
{0.5420012043710264,0.1839941772684014,0.13809507766471216},
{0.517209646577112,0.18621788412356274,0.13697181240550518},
{0.517209646577112,0.1809188947988385,0.1603181417395471},
{0.5420012043710264,0.18621788412356274,0.17194681913153254},
{0.5426185474242214,0.20795031630934732,0.15940810232637914},
{0.5434172778023963,0.20059524057856673,0.15562639044136042},
{0.5427491720150106,0.2076282832260632,0.14911959186538087},
{0.5462966233857753,0.2060146236787091,0.15317127428278615},
{0.517209646577112,0.13567571345384147,0.1719467073193427},
{0.517209646577112,0.10255473453029244,0.17785497524306906},
{0.5420012043710264,0.12500245724757836,0.17907811674085725},
{0.5420012043710264,0.14097470277856572,0.16031805788040474},
{0.517209646577112,0.14097470277856572,0.14860058763315673},
{0.5420012043710264,0.13567571345384147,0.13697189626464756},
{0.517209646577112,0.12500255508324443,0.12984054274922793},
{0.5420012043710264,0.10255462271810267,0.1310636423174449},
{0.517209646577112,0.09287539085610655,0.14074246886025274},
{0.5420012043710264,0.09287539085610655,0.16817612074721378},
{0.542623662831907,0.12113926222920844,0.1516859052467584},
{0.5425805312796732,0.11794072079686248,0.15965039934177844},
{0.5463774496225112,0.11627235713562563,0.15445929480373327},
{0.5430808069700981,0.11085361695557505,0.15348801026357636},
{0.4939569040459723,0.01286471223291534,-0.014651051730964846},
{0.5639801684589008,-0.022654218867148503,-0.012525236448014907},
{0.5629175752892098,-0.024495555986079127,0.029806858628210225},
{0.4939569040459723,0.01286471223291534,0.03405853112368129},
{0.5840837346395122,0.01216487973666047,0.03193267391116016},
{0.5183109966471089,0.055048712063687555,0.03405853112368129},
{0.5851463837152983,0.01400610504340133,-0.010399393212017508},
{0.5183109966471089,0.055048712063687555,-0.014651051730964846},
{0.57526811217885,-0.026716816949587593,-0.008273577929067575},
{0.57526811217885,-0.026716816949587593,0.027681029368736558},
{0.5932461286304623,0.004420180453832846,0.027681043345260288},
{0.5932461286304623,0.00442156412968229,-0.008273563952543842},
{0.5803786839871575,-0.02268088607442711,0.009702565668364825},
{0.5872907039156677,-0.012899387988291808,0.021630662128237853},
{0.5872908157278577,-0.012899276176102044,-0.0022231967120451396},
{0.5923058440199407,-0.0020235141175016097,0.009702565668364825},
{0.5395732865276327,-0.28534668616866943,0.07274849785738845},
{0.5412898552192174,-0.47125267717691477,-0.05680013820545725},
{0.5396346574433352,-0.28534668616866943,-0.05459481047900208},
{0.5412898552192174,0.03819854517106584,0.07495383956036736},
{0.5412898552192174,0.03819854517106584,-0.05680005434631486},
{0.500267304510485,-0.28534668616866943,-0.0551774777768206},
{0.500267304510485,0.16990046038599269,-0.05664698345841378},
{0.5412898552192174,-0.47125267717691477,0.07495375570122496},
{0.500267304510485,-0.28534674207476435,0.07274849785738845},
{0.500267304510485,-0.47125267717691477,0.07495375570122496},
{0.5798929718344604,0.16615595400714583,-0.05398980869626154},
{0.5798929718344604,0.15072581590210984,0.020432273053977164},
{0.5798929718344604,0.06887701476044596,-0.05680005434631486},
{0.5798929718344604,0.06887701476044596,0.07495383956036736},
{0.5798929718344604,0.16986291944325146,0.07472549111565151},
{0.500267304510485,0.16698267936235378,0.07433008128277992},
{0.500267304510485,0.15072581590210984,-0.0022781663798788665},
{0.500267304510485,-0.47125267717691477,-0.05680013820545725},
{0.47093197885164684,0.020037338422912273,0.1457990214043403},
{0.47093197885164684,-0.005111487270612125,0.13703093310088701},
{0.45796035320045164,0.00799491399892038,0.13719197060731472},
{0.45796035320045164,0.021692913564935242,0.1525569082291459},
{0.47093197885164684,0.013575097004587032,0.17851786778710313},
{0.45796035320045164,0.01851293295610416,0.1717452916358563},
{0.45796035320045164,0.0014393653081673017,0.18226750355015936},
{0.47093197885164684,-0.013887332544736088,0.17763395049678823},
{0.45796035320045164,-0.016687501121179293,0.17531729975881624},
{0.47093197885164684,-0.02285032347161715,0.1557395164244385},
{0.45796035320045164,-0.019365151490597487,0.14616436773466668},
{0.43836950181638557,0.021064319410136985,0.1454649265810763},
{0.4383694738633381,-0.048223821784115974,0.06415835865407728},
{0.4905228581887604,0.01687590466107198,0.17697262332341204},
{0.4905228581887604,0.019498529456561414,0.1448022856144694},
{0.48072743948498925,-0.048223821784115974,0.06415834467755355},
{0.4905228581887604,-0.013214698363661452,0.17971118338324946},
{0.43836950181638557,0.014883900616322027,0.17864421556163065},
{0.43836950181638557,-0.013914516883392626,0.1789309858755418},
{0.47093197885164684,-0.07548930813754652,0.09160126299974819},
{0.4905228581887604,-0.07548930813754652,0.09160126299974819},
{0.45796035320045164,-0.048223821784115974,0.06415835865407728},
{0.4481649484732042,-0.07548930813754652,0.09160124902322446},
{0.45796035320045164,0.009683976891802509,-0.11910910227467295},
{0.45796035320045164,-0.010830820546543898,-0.11852215816059276},
{0.47093197885164684,0.020159325522035854,-0.1268242971159045},
{0.45796035320045164,0.024072207082269304,-0.14156983713555227},
{0.47093197885164684,0.013695910075717,-0.1595421092359112},
{0.47093197885164684,-0.004990143091580132,-0.11805527238536122},
{0.47093197885164684,-0.021200283032991558,-0.1329681673001631},
{0.45796035320045164,-0.017691756280817494,-0.1563020715046082},
{0.47093197885164684,-0.014631945823024795,-0.15804498594342573},
{0.45796035320045164,0.005737509745043633,-0.16176893285586452},
{0.43836950181638557,0.021186627969306163,-0.12648988083259466},
{0.4383694738633381,-0.04808552408179867,-0.045244278502109936},
{0.45796035320045164,-0.04808552408179867,-0.045244278502109936},
{0.4905228581887604,0.01699789176019556,-0.1579964314999845},
{0.4905228581887604,-0.013094737860479102,-0.16073524313724907},
{0.4905228581887604,-0.07535089862303926,-0.07268718284778086},
{0.47093197885164684,-0.07535089862303926,-0.07268718284778086},
{0.4905228581887604,0.019621578771488447,-0.12582789676260314},
{0.48072743948498925,-0.04808562191746474,-0.04524433440820487},
{0.43836950181638557,0.015005789879779342,-0.1596680656677743},
{0.43836950181638557,-0.01379360597659639,-0.15995532516001598},
{0.4481649484732042,-0.07535099645870533,-0.07268723875387578},
{0.5517257620994819,-0.2303811973155376,0.000906118998261471},
{0.5440113778966268,-0.47125267717691477,-0.00021011606950884187},
{0.5422667163923428,-0.2303811973155376,0.012598179925366638},
{0.5451236576081813,-0.16944499343064956,0.003606551101360919},
{0.549927081330978,-0.16944499343064956,0.0175106484863121},
{0.554946582110655,-0.2303811973155376,0.01698854146581967},
{0.548717119695068,-0.47125267717691477,0.020370999973940793},
{0.5612727760469834,-0.47125267717691477,0.008622264243106722},
{0.5612728738826495,-0.2303811973155376,0.010145216151446946},
{0.5584512792953267,-0.16944499343064956,0.011588585733663285},
{0.5561609183984926,-0.16944499343064956,0.002398224718727543},
{0.5574900858053036,-0.14372396885558122,0.0022395492448103542},
{0.5557535306847835,-0.14372396885558122,0.01725813463206548},
{0.5574900858053036,-0.08185280541571302,0.016526365779085447},
{0.5557535306847835,-0.08185280541571302,0.00150776641530659},
{0.5568804717697318,-0.036246010829332084,0.0018572214381509051},
{0.5567904210273334,-0.036246010829332084,0.016554682216164303},
{0.554486251325053,-0.016390947240656664,0.0013180351056592868},
{0.5535782804373972,-0.016390947240656664,0.017380247519902574},
{0.5453088325710923,-0.036246010829332084,0.016464184225006565},
{0.5426913790893831,-0.016390947240656664,0.009961914042715866},
{0.541195751284937,-0.16944499343064956,0.014000891800049717},
{0.5438681744344795,-0.14372396885558122,0.003607585364117006},
{0.5428424792874382,-0.08185280541571302,0.004347474577384707},
{0.5428424792874382,-0.14372396885558122,0.014418440446511098},
{0.5438681744344795,-0.08185280541571302,0.015158329659778796},
{0.5423803874598464,-0.036246010829332084,0.005119481842186069},
{0.5417145738223527,0.255479050627015,-0.1439734218511306},
{0.5190089562891838,0.255479050627015,-0.14802345503873562},
{0.5356752340590777,0.255479050627015,-0.14026909797801002},
{0.5157527197668766,0.255479050627015,-0.1307137400458412},
{0.5312114957690373,0.22180954905312222,-0.14642374406206515},
{0.5464017128677082,0.22180954905312222,-0.13667935364643555},
{0.5445782377461055,0.255479050627015,-0.12428498637837514},
{0.5361135937493743,0.22180954905312222,-0.11582030045207274},
{0.523719226481314,0.255479050627015,-0.11399685328351765},
{0.5199515889556923,0.22180954905312222,-0.11898759037735629},
{0.514689274029238,0.22180954905312222,-0.14007017011574777},
{0.5390375663730262,0.1752087301224743,-0.13955140348442702},
{0.5232888054564965,0.17532325375792554,-0.14350729080818053},
{0.5157012721830231,0.17520882795814036,-0.1290611838329441},
{0.5266997201669337,0.17053449140852248,-0.1398716895022449},
{0.5363373718708302,0.1705368394645093,-0.13314269215199115},
{0.5339862829783852,0.1749882085310478,-0.11967051127989672},
{0.5306320011421055,0.17065092982772478,-0.12461128230139731},
{0.5205056043798625,0.17043201553652726,-0.12914892844892684},
{0.5352242256148044,0.10476042564636463,-0.1350204381152409},
{0.5278084777945079,0.09952338027481596,-0.14165777742286725},
{0.5247452989944961,0.10476042564636463,-0.13864241231053887},
{0.5271272061217678,0.14923509385749323,-0.13940051293422795},
{0.536195118812297,0.14923509385749323,-0.13332270977764546},
{0.5187165254831617,0.14923509385749323,-0.13332737793657157},
{0.5270712161677016,0.27642847602382203,-0.1416820406680641},
{0.5386092697798157,0.27642847602382203,-0.13134925257988633},
{0.5290493135713394,0.255479050627015,-0.12178928239488629},
{0.520129510102787,0.27642847602382203,-0.1247233181156244},
{0.5267261078437376,0.14923509385749323,-0.1238908204561156},
{0.5231287043771587,0.10476042564636463,-0.1259956989065166},
{0.5160791275020886,0.09952338027481596,-0.13591042121685498},
{0.5165985929595959,0.09952338027481596,-0.12339838559550392},
{0.5154794228218421,0.04748036855729679,-0.12219999652124325},
{0.5238607387840896,0.04748036855729679,-0.14904878679616002},
{0.541100906594899,0.22180954905312222,-0.12867671761815383},
{0.5370762268213418,0.10185096065434547,-0.12792670940170492},
{0.5358531971357434,0.09952338027481596,-0.1471906778487522},
{0.5396139162821184,0.09952338027481596,-0.1192936622705398},
{0.5436960116151621,0.04748036855729679,-0.12313734606178144},
{0.530429509266292,0.04748036855729679,-0.13954788140044685},
{0.533377731158617,0.04748036855729679,-0.12636135272036508},
{0.5213165362632544,0.04748036855729679,-0.12955319939784382},
{0.534037255360432,0.03625720602484049,-0.1270208629456562},
{0.5308454226594768,0.03625720602484049,-0.1390820438644951},
{0.5208507127038264,0.03625720602484049,-0.12996916869712363},
{0.5114754283034069,0.24239770926453233,0.06389852110139566},
{0.5114237151656023,0.26717256511258836,0.057343559424639375},
{0.46462584122687206,0.23596585280879787,0.06562683007291435},
{0.5114337363331175,0.2130408457826248,0.05375627496124155},
{0.46462584122687206,0.19433505776381937,0.03548194223000987},
{0.5114237710716972,0.19509459796945275,0.03261805468187726},
{0.5114754283034069,0.18853895144303381,0.007846427410803086},
{0.46462584122687206,0.19080574792085747,-0.011380670966642012},
{0.5114255880197823,0.19890873538952727,-0.022177451689639062},
{0.46462584122687206,0.22115866234297302,-0.04172539514585127},
{0.5114256299493536,0.21789901554887559,-0.03903101487752731},
{0.5114338481453072,0.2417921344443188,-0.045217751060068645},
{0.46462584122687206,0.2681748076528092,-0.042644044097637494},
{0.5114515004947795,0.27253468639500505,-0.03706244946307401},
{0.5114493061805537,0.29435019503784626,-0.010775375676903117},
{0.46462584122687206,0.28392953654497216,0.047496455536111204},
{0.5114533593724356,0.28992942058175475,0.03774080004235448},
{0.46462584122687206,0.2996710436456855,0.003127673468768242},
{0.5113988649064088,0.29715216658585075,0.015834318206548705},
{0.4702428104429986,0.23183992709733398,0.04810082837528385},
{0.4702937269189503,0.20970463559152921,0.019572507196669326},
{0.4702564096005888,0.25295996391932446,0.04974793374392589},
{0.47021220185602786,0.27097327109335734,0.033494927804231744},
{0.47102543986583556,0.27531704888021513,0.019183945860425884},
{0.47022862427141177,0.28458553866280667,-7.376110398993782e-05},
{0.47021220185602786,0.25781046057404683,-0.02559919820596781},
{0.47035146393848276,0.2526760028866831,-0.033531881732976276},
{0.4704449808587664,0.2303117759221659,-0.025908009497802597},
{0.4702291553793136,0.2038061512344145,-0.0009688037071946357},
{0.4702939365668063,0.20102880632122389,0.01869104977453109},
{0.5050932164599649,0.19908692209057283,-0.007539013771341356},
{0.5049351839061392,0.19658095933866543,0.023430768502162316},
{0.5054263888326626,0.24246018432560953,0.060898921507835754},
{0.5054065002393935,0.2807435739839841,0.048099710253385386},
{0.5054246836967673,0.29574878383802866,0.006008877929803472},
{0.5057931467918858,0.28503253584476934,-0.01788127794260873},
{0.5053395387141986,0.28835093994463157,-0.00459635453546125},
{0.48780281702286643,0.2785978142016701,-0.0031372054579526997},
{0.486513105342548,0.25606701502732754,-0.02632917806391028},
{0.50516358825695,0.25841613322992646,-0.03946934661477657},
{0.5051038246414764,0.22882563817733295,-0.038385844565584096},
{0.505415668838961,0.19470156414561543,-0.012688524174763302},
{0.5057924619422229,0.21420121871233733,0.050444789240626065},
{0.4873723540684777,0.21554392937064354,0.03294878116292213},
{0.5052682584431709,0.25629808889417105,0.0548231309706705},
{0.5051617852853886,0.28801824277374066,0.02365495194280635},
{0.48737213044409794,0.2715837376968767,0.032792467721515464},
{0.48767592416391337,0.25487614532283426,0.043771208806965424},
{0.47035316907437796,0.2855970476382612,0.019423601312840048},
{0.4874003909750818,0.22191223457297327,-0.02061219284396533},
{0.48687747331621306,0.20839795641140132,-0.002659096534165223},
{0.5052906488341877,0.2299631874437929,0.05312348784932393},
{0.47175512621677956,0.23325344282486105,-0.03203942659941693},
{0.48715262913890384,0.2322262521897805,0.04367552552550351},
{0.5420025880468758,0.30237737384179947,-0.16831464207391095},
{0.5420025880468758,0.023799972353038257,-0.1731713862347412},
{0.5053450873941197,0.2934937136636152,-0.17111173581513348},
{0.5053216208107755,0.3897469577632738,-0.11393411266848953},
{0.5420025880468758,0.37237866715942297,-0.12803562845114},
{0.5420025880468758,0.4172151456403738,-0.07063057931034646},
{0.5053217885290603,0.4360420542138313,-0.008898594093790806},
{0.5420025880468758,0.43604227783821103,0.028547797464433592},
{0.505318420186841,0.023799972353038257,-0.1731713862347412},
{0.541990009175518,-0.04155706189403606,-0.09019417647313731},
{0.5053072249913326,-0.04155706189403606,-0.09019417647313731},
{0.5420025880468758,0.2954652421010994,0.06544507935831742},
{0.5420026998590656,0.24058505197229746,0.08326485360824823},
{0.5113909821470245,0.254739231296366,0.08338364008343735},
{0.511398180056746,0.30026241831778855,0.05854324831560703},
{0.5113997733804513,0.3198437656657176,0.01072743620050608},
{0.5420025880468758,0.3179801499679597,0.019060169766264814},
{0.5420025880468758,0.3108493135839182,-0.026738899857082343},
{0.5113974812305595,0.30242950627531584,-0.03812453947791072},
{0.5420025880468758,0.27700279933697325,-0.057575150422860766},
{0.5113665651600666,0.2637576670928877,-0.06303352802421242},
{0.5420026439529708,0.2231590802550092,-0.06272631005608295},
{0.5112746415634882,0.21123960731027805,-0.05817382084035119},
{0.5420025880468758,0.21145852160147557,0.07429277794094206},
{0.5113038664746097,0.21117935451647402,0.07461605493483836},
{0.5420020010328791,0.23328180119151118,0.1929612772932595},
{0.5420025880468758,0.3317207919078778,0.1757765962816619},
{0.5057841878401742,0.29555982123718655,0.19068475315491898},
{0.542002112845069,0.14311055320555446,0.18892262099597143},
{0.5420025880468758,0.023799972353038257,0.19282065948800267},
{0.505318420186841,0.023799972353038257,0.19282065948800267},
{0.5053197619331192,0.38422553206337173,0.13762907241047567},
{0.5420025880468758,0.3982907787669405,0.12116073016965916},
{0.5053187975529818,0.4217649373870255,0.07767293032264759},
{0.5053072249913326,-0.04155706189403606,0.10808657274037403},
{0.541990009175518,-0.04155706189403606,0.10808657274037403},
{0.541998423042804,0.23213400713315652,0.1280995990002565},
{0.541990009175518,0.15079065299569758,0.10805726397011027},
{0.5419955997850103,0.17910710405107513,0.1280995990002565},
{0.541998423042804,0.17910710405107513,0.1811265300353853},
{0.5420025880468758,0.2741697859297623,-0.10416225838372864},
{0.541990009175518,0.15079065299569758,-0.09022349921992479},
{0.5419928324333116,0.03847110136034269,-0.10416230031329986},
{0.5420012043710264,0.03847110136034269,-0.1601368802032807},
{0.5420025880468758,0.2741697859297623,-0.16013683827370953},
{0.5053072249913326,0.15079065299569758,0.10805726397011027},
{0.5053072249913326,0.15079065299569758,-0.09022349921992479},
{0.5178204346406772,0.17910710405107513,0.1280995990002565},
{0.5178204346406772,0.23213400713315652,0.1280995990002565},
{0.5178204346406772,0.23213400713315652,0.18112654401190903},
{0.5178204346406772,0.17910710405107513,0.1811265300353853},
{0.5419928324333116,0.09008365012347307,0.12809958502373278},
{0.5419998206951772,0.09008365012347307,0.18112651605886157},
{0.5419928324333116,0.14311055320555446,0.1280995990002565},
{0.5178204346406772,0.09008365012347307,0.12809958502373278},
{0.5178204346406772,0.14311055320555446,0.1280995990002565},
{0.5178204346406772,0.14311055320555446,0.1811265300353853},
{0.5178204346406772,0.09008365012347307,0.18112651605886157},
{0.5092583882500652,0.03847110136034269,-0.1601368802032807},
{0.5092583882500652,0.2741697859297623,-0.16013683827370953},
{0.5092583882500652,0.2741697859297623,-0.10416225838372864},
{0.5092583882500652,0.03847110136034269,-0.10416230031329986},
{0.48268345398113216,-0.8293172386394781,-0.052752592839076344},
{0.48268345398113216,-0.8293172665925256,0.07063355630990119},
{0.4460230182583925,-0.8293186642448988,0.07063355630990119},
{0.4460230182583925,-0.8293186362918512,-0.052752592839076344},
{0.5393950019909208,-0.38708979697764534,0.15086601441165487},
{0.406847199606751,-0.3907015403575724,0.14912034659766235},
{0.534674431100801,-0.39193735856238443,0.14869395081167933},
{0.5736051853853444,-0.3919862484423952,0.06703949323249385},
{0.5770920625022594,-0.38718522868168015,0.04339974075924491},
{0.5770403912940261,-0.3919881632261464,-0.025529077986409757},
{0.5736601969827495,-0.3871832579918341,-0.04914054197562732},
{0.5541701442878307,-0.3919467927159028,-0.09226787329909462},
{0.5350160872234034,-0.38935040185545633,-0.13374769393473168},
{0.4093612268128511,-0.692133968418186,0.07092419812088577},
{0.4093612268128511,-0.6481127545429836,0.14613171857523125},
{0.4093612268128511,-0.6510697397156879,-0.12802896164932034},
{0.4093612268128511,-0.6969823546178251,-0.03035712834402043},
{0.4460230182583925,-0.6969827040309183,0.04823764456608588},
{0.4460230182583925,-0.6921348209861335,-0.053038678303324635},
{0.4460230182583925,-0.6481171711244826,-0.12824536016624627},
{0.5238124778476466,-0.5874124324491024,-0.1292099779045835},
{0.519345273379721,-0.6481157874486332,-0.12824816944751619},
{0.48268345398113216,-0.6513411498300188,-0.12739734856539614},
{0.46879506620885447,-0.5170450660219186,-0.12496614623892549},
{0.40684711574760857,-0.3907018618176181,-0.13123929926769515},
{0.46879495439666474,-0.47166919156062015,-0.12855840634477153},
{0.5314867074978229,-0.3919290984368594,-0.12869662018794664},
{0.5156227940022738,-0.4716760121042008,-0.12267567352990155},
{0.5156218855282315,-0.5170369596381547,-0.12847874015950525},
{0.5629625237895284,-0.5198534947238869,-0.056360674369785785},
{0.5745473288735226,-0.39192381531088916,0.008939112036086787},
{0.5711816421938785,-0.5075256696853094,0.019788360629169728},
{0.5609521266395485,-0.5238089767284522,0.07936571097084227},
{0.5568570750690062,-0.39192686219306244,0.09662197973698966},
{0.5238114156318432,-0.5874679052717905,0.14709055003274388},
{0.5157085819049344,-0.517147374175629,0.14636261074726611},
{0.5157083163509836,-0.47160420072527126,0.14104451551460176},
{0.4688089309203955,-0.47159789731306867,0.14644087928015928},
{0.4688089309203955,-0.5171560675733896,0.14313990390538947},
{0.44602304621144,-0.651342799059819,0.14527912267459736},
{0.48268345398113216,-0.6481172270305775,0.14612777719553913},
{0.519345329285816,-0.6515506020146503,0.14508160644123194},
{0.519345329285816,-0.5170207049410556,-0.05061988712992706},
{0.519345329285816,-0.50788155390907,0.025919484223785715},
{0.519345329285816,-0.5261651251224878,0.08329043064667582},
{0.519345329285816,-0.692133968418186,-0.053043863593628816},
{0.519345329285816,-0.6969817676038284,0.04824358458867152},
{0.48268345398113216,-0.6969816138620674,-0.03036186638556522},
{0.48268345398113216,-0.6921359391080321,0.0709168045398321},
{0.5157085819049344,-0.517147374175629,0.1302490765378829},
{0.4688089309203955,-0.47159789731306867,0.1302490765378829},
{0.5156218855282315,-0.5170369596381547,-0.11091024982973276},
{0.46879495439666474,-0.47166919156062015,-0.11091024982973276},
{0.5608107820550576,-0.5060151149535186,-0.04226175822054924},
{0.5154947271153274,-0.5059620181398647,-0.04226175822054924},
{0.5154947271153274,-0.5059620181398647,0.06021690907933782},
{0.5608107820550576,-0.5060151149535186,0.06021690907933782},
{0.5731692715867007,-0.6026726579551415,-0.042261786173596695},
{0.5731142460127722,-0.6035562118558394,0.06021688112629037},
{0.567330830375534,-0.6253427331884626,-0.042261786173596695},
{0.5613598358133032,-0.6314639893573246,0.06021688112629037},
{0.5530703875415391,-0.6418116205137047,-0.042261786173596695},
{0.553000435040266,-0.6418674008199148,0.06021688112629037},
{0.541126819069896,-0.6475853783730446,-0.042261786173596695},
{0.541039968951432,-0.6476052110602188,0.06021688112629037},
{0.5154975503731211,-0.6475859653870413,-0.042261786173596695},
{0.5154961666972718,-0.6475756087829567,0.06021688112629037},
{0.5154947271153274,-0.5895038654836744,-0.04226177219707297},
{0.5410759445235156,-0.5895038654836744,-0.04226177219707297},
{0.5530161166998919,-0.5952538073465768,-0.04226177219707297},
{0.561277625900718,-0.605614618364835,-0.04226177219707297},
{0.5642266444548957,-0.6185344889486546,-0.042261786173596695},
{0.561277625900718,-0.6314543874855214,-0.042261786173596695},
{0.5642266444548957,-0.6185344889486546,0.06021688112629037},
{0.561277625900718,-0.605614618364835,0.06021688112629037},
{0.5530161166998919,-0.5952538073465768,0.06021689510281409},
{0.5410759445235156,-0.5895038654836744,0.06021689510281409},
{0.5154947271153274,-0.5895038654836744,0.06021689510281409},
{0.50560510664161,-0.6346307901042775,-0.12951863545465728},
{0.503881018580258,-0.6310505218557926,0.14747373040735093},
{0.5128711379397006,-0.5932481622146654,-0.12951862147813353},
{0.5024641345105118,-0.6316303099897226,-0.14585578006721156},
{0.5092764039891543,-0.596659677915623,-0.14585578006721156},
{0.5271790869778569,-0.5866819773893531,-0.14917695151877258},
{0.5546173650941729,-0.5922800503453953,-0.12951862147813353},
{0.5492855309386812,-0.5902273742111294,0.14747371643082718},
{0.5151301494938063,-0.5918866251788936,0.14747373040735093},
{0.5075211762329298,-0.5988607288258165,0.16381228664880204},
{0.5022784983223175,-0.6273200479067715,0.16381228664880204},
{0.5432389932656847,-0.650253664471563,-0.12951863545465728},
{0.5334328545682119,-0.6504608245063026,0.14747371643082718},
{0.5271790869778569,-0.6503869725549085,-0.1498411997856085},
{0.5265785297296628,-0.6507623260762262,0.16460921405541565},
{0.5427727923401158,-0.6511643607813462,0.1652612608170345},
{0.558745471143339,-0.6392973976362722,0.14747371643082718},
{0.5658307161069702,-0.6245840175977293,-0.12951862147813353},
{0.5666209208056692,-0.6273199640476291,-0.14585578006721156},
{0.5423208334922289,-0.6507622981231788,-0.1473048940006813},
{0.5271790869778569,-0.5866820332954481,0.1704534695004544},
{0.5417202762440348,-0.5866820332954481,0.17018783169042445},
{0.5596230011623088,-0.5966595661034332,0.16381230062532579},
{0.5658307161069702,-0.6124850721117696,0.14747371643082718},
{0.5672473346227656,-0.6245752682938739,0.16381228664880204},
{0.541720164431845,-0.5866819214832582,-0.15223270878468334},
{0.5613779633645823,-0.5988604912249131,-0.14585559837240306},
{0.409361855756419,-0.6481266052780009,-0.13512042616601191},
{0.40981897194156264,-0.579705232179445,-0.1384822553251062},
{0.45610425687246126,-0.5881215733101621,-0.13846777564652096},
{0.4578151231423636,-0.5535824244766837,-0.13852769300375545},
{0.46857039358987984,-0.539427154983764,-0.13438941204531338},
{0.4670493844183383,-0.5223232582793311,-0.13858255085939933},
{0.45610431277855606,-0.6481229294522597,-0.13188157643922607},
{0.5193459722059076,-0.5881163740433342,-0.13361023482383805},
{0.5168560545032433,-0.5394273646316199,-0.13855303244127962},
{0.5175815199440207,-0.5233854321533102,-0.13858147466707205},
{0.40971047218783946,-0.5788743278436415,-0.12877024851496116},
{0.4656278601427134,-0.5214046233040687,-0.12886868517159805},
{0.519345273379721,-0.521406062886013,-0.12887008282397114},
{0.45610425687246126,-0.5881048014816849,-0.1287526940011551},
{0.44858277665014024,-0.5628511518601786,-0.12879751671276018},
{0.4683927939028309,-0.5248426105409727,-0.12886340204562777},
{0.5167798684723861,-0.5318926206882784,-0.1288510328221259},
{0.4093617858738003,-0.6481267170901908,0.15378970750483212},
{0.45610431277855606,-0.6481229853583547,0.15054994930400373},
{0.45610425687246126,-0.5881230128921064,0.15713709891491234},
{0.40981886012937274,-0.5797050644611601,0.15715164847611623},
{0.4578151231423636,-0.5535822148288276,0.15719729580262146},
{0.46857092469778167,-0.5394275323499048,0.15305795262837582},
{0.5168560545032433,-0.5394273646316199,0.15722095805729788},
{0.5193446863657244,-0.5881162901841919,0.15227885926604287},
{0.5175815199440207,-0.5233854321533102,0.15725005717970567},
{0.40971030446955464,-0.5788741601253566,0.14743863535626256},
{0.4485807360776755,-0.5628539751179723,0.14746593150710907},
{0.4683927939028309,-0.5248426105409727,0.14753171900431053},
{0.4656278601427134,-0.5214046233040687,0.1475380363930369},
{0.46704944032443313,-0.5223232582793311,0.15725202786955175},
{0.519345273379721,-0.521406062886013,0.1475380363930369},
{0.45610425687246126,-0.5881048573877798,0.14742201726954648},
{0.5167798684723861,-0.5318926206882784,0.14752097105756143},
{0.44090060833448486,-0.7053957886316062,-0.16045006614704327},
{0.3793633859761197,-0.7053957886316062,-0.16045006614704327},
{0.3793633859761197,-0.705395844537701,0.17734013601491674},
{0.44090060833448486,-0.705395844537701,0.17734013601491674},
{0.37575217370409447,-0.9041030035137193,0.29239785636744464},
{0.44253688189723545,-0.8203502644033337,0.24538289906212568},
{0.4436275958326731,-0.9485859598034201,0.3190135322030533},
{0.32231498976789186,-0.9401039988937863,0.3143798114313974},
{0.4429446190240377,-0.8211112302143876,-0.22956825281272822},
{0.44362608636811013,-0.9485803412408803,-0.30195721158540045},
{0.375510924927975,-0.902798057422534,-0.2747522435797249},
{0.34776439458077346,-0.9311810786604418,-0.2911871819288245},
{0.3204957635095035,-0.9388242105453167,-0.29785824658821347},
{0.4857720560778106,-0.9377398279751292,-0.2995363938160619},
{0.4868624904827736,-0.8202489346062846,-0.2280087103652605},
{0.48849768785319686,-0.7053957886316062,-0.16045006614704327},
{0.48849768785319686,-0.705395844537701,0.17734013601491674},
{0.5262818221073791,-0.705395844537701,0.17734013601491674},
{0.5262818221073791,-0.7053957886316062,-0.16045006614704327},
{0.48645349546883554,-0.8207771074380762,0.2452653425210249},
{0.573787998315745,-0.9504271571571136,0.3192176174025722},
{0.4857717485942885,-0.937743573683489,0.31642758180583386},
{0.57378805422184,-0.9504239705097027,-0.30232856782093115},
{0.5167875415839143,-0.9803867442483933,0.26221811107435516},
{0.3786310161326192,-0.9803867442483933,0.26221811107435516},
{0.3786310161326192,-0.980386660389251,-0.24532815301867159},
{0.5167875415839143,-0.980386660389251,-0.24532815301867159},
{0.331501535191849,-0.9783019780156411,0.30757461407376263},
{0.5604069164253288,-0.978206518358559,0.3102602869678022},
{0.5569952050530389,-1.0000000000000002,0.30242578852000346},
{0.3384233386869709,-1.0000000000000002,0.30242578852000346},
{0.5639166172054962,-0.9783019221095464,-0.2906846560180791},
{0.5569952050530389,-0.9999999021643341,-0.2855358304643199},
{0.33501076077020964,-0.9782064065463693,-0.2933703149355949},
{0.33842195501112154,-0.9999999021643341,-0.2855358304643199},
{0.3786310161326192,-1.0000000000000002,0.26221811107435516},
{0.5167875415839143,-1.0000000000000002,0.26221811107435516},
{0.3786310161326192,-0.9999999161408578,-0.24532815301867159},
{0.5167875415839143,-0.9999999161408578,-0.24532815301867159},
{0.5039640810607909,-0.9176964307291794,0.1756098144239808},
{0.5704629972966817,-0.9176964307291794,0.1756098144239808},
{0.5704629972966817,-0.8531357927808169,0.16562821444758993},
{0.5039640810607909,-0.8457801440125633,0.16240201347478053},
{0.5704629972966817,-0.7784889825055085,0.10358469251707195},
{0.5039640810607909,-0.7746362139738417,0.09768766171842522},
{0.5704629972966817,-0.7527257068992016,0.038471394867341115},
{0.5039640810607909,-0.7519136429173873,0.03360374901800073},
{0.5704629972966817,-0.753424575015319,-0.029584659853935946},
{0.5039640810607909,-0.755157803723191,-0.03642900545454104},
{0.5704629972966817,-0.791316496220514,-0.10316791257941572},
{0.5039640810607909,-0.79607840966783,-0.10833943600771388},
{0.5704629972966817,-0.848084705057508,-0.14410392065320624},
{0.5039640810607909,-0.8526040838885213,-0.1460863927087718},
{0.5704629972966817,-0.9168051058812872,-0.16040250403678694},
{0.5039640810607909,-0.9175826478494858,-0.1598315350893312},
{0.5711810551798818,-0.9175075799405271,-0.05828475250920354},
{0.5708873385336763,-0.9175848281871879,0.07533472778508252},
{0.5697622563263844,-0.7962320675697278,0.07604388262266591},
{0.5697622563263844,-0.7962320396166803,-0.05917901242707931},
{0.5708517682807812,-0.7709782642064604,-0.05849227593356032},
{0.5710461677493546,-0.7711008103665332,0.07523464189864536},
{0.4520297228387559,-0.8926673978205528,0.3085070299014238},
{0.4561223285176452,-0.8809017365194806,0.3040817689812147},
{0.4511628569073927,-0.8891035799404992,0.293999132714773},
{0.4575494434027625,-0.8982766519955797,0.3141732663637018},
{0.4646276022688623,-0.9068860648251159,0.3042959592073911},
{0.4695957672768754,-0.882397559995259,0.3049626813189274},
{0.4614029806432345,-0.883538799063984,0.2984477344296128},
{0.46990073502468427,-0.8980166047950422,0.3070160702559037},
{0.4723237471082485,-0.8940926118984427,0.3117250126782794},
{0.47336234258669346,-0.8912041675981148,0.2952152020915533},
{0.4531354056311094,-0.8390019213457292,0.27984644887874355},
{0.46919663968869146,-0.8430644215925022,0.2673412198244494},
{0.44876107516337566,-0.8508529093241787,0.2718506194175188},
{0.45689344128492776,-0.8541061548704074,0.2885713637003921},
{0.470695468117072,-0.8604265066198165,0.27739446346148505},
{0.4686406535746752,-0.8376726001971573,0.2790516459037371},
{0.47303504035396277,-0.8492352804440852,0.28570318535947403},
{0.46408654308219066,-0.8400129131898056,0.27337072011501784},
{0.4537538109001079,-0.8536635463168964,0.2812709781069706},
{0.4707995373127725,-0.8520254278530134,0.28038868209340856},
{0.2533746543666829,-0.5852080970558321,-0.21787536727072296},
{0.25460149964325973,-0.8901956216456913,-0.21787542317681785},
{0.25023289955025574,-0.8508061858053462,0.18079092574755834},
{0.24714109682964291,-0.8519738405039227,0.2026599924293364},
{0.2806561438397853,-0.9185076561195697,0.2026599784528127},
{0.28979398107854026,-0.9195459860440639,-0.21787545112986534},
{0.3379888365172239,-0.9172695597413896,-0.21787542317681785},
{0.34860158835225585,-0.9129033496339435,0.2026599784528127},
{0.368668857500738,-0.8890697148234992,-0.21787542317681785},
{0.37456620975943056,-0.8558522140270645,0.2026599924293364},
{0.37228009772581067,-0.8508061718288226,0.18079093972408208},
{0.37228009772581067,-0.6209454812218103,0.18079096767712954},
{0.36791135786756934,-0.5815542563864277,-0.21787536727072296},
{0.25023289955025574,-0.6209454812218103,0.18079098165365326},
{0.259538650745114,-0.5708101112518013,0.20266003435890761},
{0.2502329275033032,-0.6209454812218103,0.20266003435890761},
{0.2818329391848818,-0.5556016408131378,-0.21787536727072296},
{0.3141539577961675,-0.5492363265868865,0.20266004833543136},
{0.3307269282936337,-0.5513749443655739,-0.21787536727072296},
{0.3647989537509772,-0.574023104409685,0.20266003435890761},
{0.37228009772581067,-0.6209454812218103,0.20266003435890761},
{0.2921107576052258,-0.6223752516464365,0.18546610088860016},
{0.2693793394092497,-0.6223752516464365,0.18546610088860016},
{0.26598269472954167,-0.6637589277753284,0.18863038586128153},
{0.2952750146248597,-0.6615975981455782,0.18863038586128153},
{0.293036003476213,-0.6670009222199538,0.18863038586128153},
{0.2948272068045209,-0.6637589277753284,0.1823018159159188},
{0.2684526679328419,-0.6670009222199538,0.1823018159159188},
{0.3531336578668167,-0.6223752516464365,0.18546610088860016},
{0.3304022676238881,-0.6223752516464365,0.18546610088860016},
{0.32700629381731916,-0.6637589277753284,0.18863038586128153},
{0.3562979428394981,-0.6615975981455782,0.18863038586128153},
{0.3540602874136533,-0.6670009222199538,0.18863038586128153},
{0.3558504145496339,-0.6637589277753284,0.1823018159159188},
{0.3294755821709565,-0.6670009222199538,0.1823018159159188},
{0.26621435561038176,-0.7081925469362592,0.18863038586128153},
{0.26666202366548325,-0.706031217306509,0.1823018159159188},
{0.2693793394092497,-0.8493763874276726,0.1854660729355527},
{0.2921107576052258,-0.8493763874276726,0.1854660729355527},
{0.2955063260926065,-0.706031217306509,0.18863038586128153},
{0.2684526679328419,-0.7027892088853599,0.18863038586128153},
{0.293036003476213,-0.7027892088853599,0.1823018159159188},
{0.3272379686746829,-0.7081925469362592,0.18863038586128153},
{0.3276854829880234,-0.706031217306509,0.1823018159159188},
{0.3304022676238881,-0.8493763874276726,0.1854660729355527},
{0.3531336578668167,-0.8493763874276726,0.1854660729355527},
{0.3565296037203382,-0.706031217306509,0.18863038586128153},
{0.3294755821709565,-0.7027892088853599,0.18863038586128153},
{0.3540602874136533,-0.7027892088853599,0.1823018159159188},
{0.2672693455511631,-0.6615975981455782,0.1823018159159188},
{0.29422026228498177,-0.7081925469362592,0.1823018159159188},
{0.32829273499108463,-0.6615975981455782,0.1823018159159188},
{0.3552431904996201,-0.7081925469362592,0.1823018159159188},
{0.2919108374097787,-0.8974295768218197,0.20176422304689773},
{0.29879700076938664,-0.8926457202322461,0.21462853694888676},
{0.2789679614678981,-0.8905247128734597,0.2144713290099613},
{0.2769562924542587,-0.8798984177869323,0.20174798232632238},
{0.28327043862713114,-0.8748156313078018,0.21458177150048308},
{0.28079300196015855,-0.8804507420517311,0.20854781269884448},
{0.28775719625175633,-0.8947146370870874,0.20849618342018245},
{0.2986434267266313,-0.8748001872490793,0.20175270639134346},
{0.2963795373657435,-0.8760054527730156,0.21461316277278275},
{0.2976961538542441,-0.8780113355058304,0.20849869919445402},
{0.3278305872573979,-0.8793386859645563,0.20181593618470214},
{0.34259900684639316,-0.8974310024272402,0.20182643255402408},
{0.3322598594399178,-0.8939701915270836,0.21463168166672622},
{0.33242809485606695,-0.8775798522652093,0.21317999605288998},
{0.3339557149233333,-0.8925738249941741,0.20860956098068772},
{0.3464726423279902,-0.8766792190525122,0.2085778342718185},
{0.3484957860676128,-0.875904919637819,0.21465210136789709},
{0.3497426317496486,-0.875368346915265,0.20181596413774963},
{0.3480088439808273,-0.8919457339942302,0.213197187177079},
{0.47079372307890044,-0.8521672196862636,0.28718132853273287},
{0.468463333418101,-0.8418571714021962,0.2781962127687858},
{0.46710359935389056,-0.8292844497148054,0.3032964700423452},
{0.46104160364564767,-0.8238198805134409,0.2974383498857654},
{0.4553051071985743,-0.8420753030080647,0.2775141863637642},
{0.45343541171299356,-0.8299065168330214,0.29295774193158175},
{0.431165945579372,-0.8253307986348489,0.3002236753940065},
{0.4383876852737595,-0.8331106768279071,0.30279465693431007},
{0.45239452408465675,-0.8388683477084328,0.2983911155319788},
{0.45694952907465997,-0.8517445835851642,0.28570398202132674},
{0.44519147100249745,-0.8340729325337337,0.3131593534261656},
{0.44405898123762805,-0.8196052038762855,0.31315482503247677},
{0.40516448205564254,-0.8158888462162327,0.303697065165521},
{0.3742076001135425,-0.8088236016580603,0.30086311533121995},
{0.38574376689495293,-0.8094335371536779,0.29558295238396143},
{0.3583216176870224,-0.8031757023949173,0.2668099162513421},
{0.361727221318442,-0.8122362913870115,0.2537759692808308},
{0.3430677095697098,-0.8194197633594237,0.2398079572528581},
{0.34357363177572176,-0.8143081852414075,0.2563559517024172},
{0.32722559945118107,-0.8326498568639747,0.24221953654001052},
{0.3396046484492324,-0.8678508639787312,0.2431528887947617},
{0.3345364255078295,-0.873512068892466,0.24257149336060269},
{0.3315314449526332,-0.8749818261514863,0.25540046063407623},
{0.33178690785338705,-0.8856952369104284,0.20528845941174534},
{0.336952672953908,-0.8775293131553983,0.20656803811235896},
{0.39566943282337264,-0.8308445931527936,0.30658543958323015},
{0.3973028831283295,-0.8247405141315969,0.31257679794053694},
{0.3718223945266703,-0.818652969337974,0.29943994182579486},
{0.38307046322441524,-0.8161912422836749,0.2889275973372458},
{0.3837720288096127,-0.8259800081621502,0.2959477955594334},
{0.3699682968415733,-0.8183307266068337,0.279020534161912},
{0.35103944350402244,-0.8197261427361293,0.26362160563436726},
{0.3282000147326537,-0.8364474321034281,0.2541365216635175},
{0.33782894508574207,-0.8691212461267298,0.2607151316184265},
{0.34575969985247573,-0.8852331590593603,0.2521554332838013},
{0.33591574068178703,-0.8933569995014365,0.2186352848424971},
{0.3440326627446165,-0.8945386866298389,0.20388830524090504},
{0.3489707502735608,-0.8852915949050792,0.20531917981090592},
{0.3483747353955792,-0.8716382922619558,0.25017336654742384},
{0.3449028550886276,-0.8786221934520142,0.21540557576223124},
{0.342024320143625,-0.841253133999593,0.24618534719561297},
{0.3566458324916846,-0.822665964737692,0.2567314310124484},
{0.34086689626041966,-0.8377978018967388,0.2540083289878574},
{0.45377540462927207,-0.8907520410319432,0.3275676539047099},
{0.4613943990576637,-0.9012026791682202,0.30829131623416073},
{0.46626249215576343,-0.8857214428924238,0.32960593421953305},
{0.4420563131052713,-0.8886774636849907,0.3497887053601275},
{0.437543950489171,-0.8736796194589523,0.3435664408542623},
{0.4639220114448303,-0.8758787695619185,0.3233828450987676},
{0.47187311603011606,-0.8896077550810448,0.3037756691349837},
{0.4575679483201822,-0.8863908484965166,0.3006032218724435},
{0.44967069528083176,-0.8823605501604196,0.32404983276425475},
{0.4117662930399449,-0.8885139802869101,0.3426913287738978},
{0.4159693691624035,-0.8947003530798345,0.3450272810911422},
{0.366057903102564,-0.9134438078300946,0.3385619648375961},
{0.3800259011540129,-0.903868128032421,0.3387647222673606},
{0.33105976522976194,-0.9098895638687967,0.3004356293763859},
{0.31489708956294077,-0.9116985453352903,0.2802056175855808},
{0.32187780410558847,-0.9155167079941993,0.30676090086214824},
{0.39726822134947687,-0.8989456243274367,0.3604308917541369},
{0.4074856052812084,-0.8825297779097536,0.35504397611862143},
{0.37147203102978354,-0.8979514602179324,0.3528334071957672},
{0.3768565706562647,-0.8944151621131049,0.34183774054007904},
{0.3456470770242519,-0.9127451493618332,0.3352091784893557},
{0.3191701601162439,-0.9044364134873205,0.3095486722620422},
{0.3170923821453572,-0.8977424692585838,0.28833553781548016},
{0.3422811108141333,-0.8997262690839037,0.31705737794167305},
{0.3028356850197222,-0.9017450102185512,0.2800637139401408},
{0.2813699947893423,-0.8806261753776017,0.21374952541840142},
{0.2927132296371711,-0.8758128422994796,0.2117517490693505},
{0.32178643956995945,-0.9023356720879437,0.2835689701857618},
{0.29671329675243807,-0.8860535390727944,0.20895206967123775},
{0.2869933512768138,-0.8934914676362519,0.20993846283354775},
{0.30124114535683216,-0.906695690595377,0.2680225474032846}
};


// texture array: 64kb.
const tgx::fVec2 R2D2_tex_array[8227] PROGMEM = {
{0.142599,0.367891},
{0.149151,0.3702},
{0.117058,0.367898},
{0.1533,0.3815},
{0.158727,0.376225},
{0.1547,0.382},
{0.161258,0.388851},
{0.166243,0.383579},
{0.1623,0.3902},
{0.166674,0.398641},
{0.172514,0.394442},
{0.1673,0.4002},
{0.169091,0.409435},
{0.176131,0.408775},
{0.1692,0.4111},
{0.16841,0.420437},
{0.174669,0.424114},
{0.1681,0.4221},
{0.164727,0.430841},
{0.169439,0.436707},
{0.1639,0.4323},
{0.158239,0.439655},
{0.163268,0.444586},
{0.155698,0.450601},
{0.1571,0.4404},
{0.1047,0.4402},
{0.102108,0.447917},
{0.144152,0.456012},
{0.11805,0.456205},
{0.1117,0.4539},
{0.197829,0.81939},
{0.199668,0.639542},
{0.2035,0.6395},
{0.214929,0.793571},
{0.214114,0.731185},
{0.217405,0.639297},
{0.223,0.730986},
{0.238367,0.730876},
{0.235655,0.639048},
{0.255561,0.638778},
{0.2504,0.730505},
{0.259286,0.730514},
{0.26761,0.649098},
{0.281592,0.6377},
{0.2925,0.6466},
{0.2925,0.6378},
{0.1763,0.65029},
{0.172413,0.639882},
{0.187281,0.80156},
{0.1879,0.850953},
{0.197522,0.856299},
{0.251055,0.855517},
{0.251375,0.818701},
{0.265651,0.855349},
{0.260069,0.792897},
{0.2512,0.793115},
{0.237595,0.818853},
{0.236603,0.793106},
{0.223868,0.793505},
{0.218846,0.819159},
{0.16173,0.650459},
{0.154174,0.640141},
{0.1489,0.6507},
{0.1396,0.6403},
{0.1397,0.6482},
{0.141965,0.802545},
{0.1509,0.7947},
{0.163604,0.801641},
{0.164747,0.794448},
{0.1782,0.7943},
{0.0761,0.6399},
{0.088264,0.640055},
{0.079251,0.646641},
{0.094949,0.646882},
{0.104016,0.640255},
{0.1074,0.6471},
{0.118509,0.647241},
{0.119746,0.640556},
{0.135565,0.647517},
{0.135463,0.640756},
{0.4173,0.6967},
{0.417701,0.672508},
{0.425182,0.693158},
{0.425482,0.674858},
{0.425882,0.656658},
{0.418212,0.646025},
{0.426182,0.638457},
{0.4185,0.6329},
{0.5975,0.646802},
{0.5936,0.636441},
{0.6066,0.644},
{0.6092,0.852899},
{0.5993,0.790803},
{0.601497,0.826885},
{0.6016,0.8372},
{0.591663,0.853192},
{0.591591,0.847507},
{0.581119,0.847711},
{0.56815,0.853448},
{0.5708,0.8376},
{0.570759,0.827325},
{0.5538,0.816802},
{0.553885,0.853611},
{0.500004,0.817394},
{0.499111,0.854309},
{0.490014,0.791914},
{0.498983,0.791995},
{0.51174,0.791508},
{0.521342,0.817159},
{0.526333,0.791604},
{0.540735,0.816946},
{0.535192,0.791392},
{0.534386,0.728985},
{0.538832,0.637082},
{0.522912,0.637315},
{0.5255,0.728905},
{0.514191,0.729169},
{0.500931,0.637556},
{0.4981,0.729322},
{0.485773,0.637722},
{0.489184,0.729484},
{0.4788,0.6483},
{0.4806,0.7923},
{0.6065,0.6362},
{0.583119,0.646958},
{0.575372,0.636641},
{0.5701,0.647089},
{0.556497,0.636847},
{0.5719,0.7912},
{0.587741,0.790921},
{0.580709,0.816795},
{0.591181,0.816689},
{0.4685,0.6484},
{0.440581,0.6485},
{0.455378,0.6378},
{0.4406,0.6378},
{0.4685,0.6378},
{0.4657,0.6654},
{0.4671,0.7223},
{0.4624,0.7225},
{0.461224,0.6548},
{0.45714,0.572698},
{0.4577,0.5608},
{0.470228,0.561594},
{0.468277,0.599362},
{0.468427,0.623665},
{0.4562,0.6228},
{0.439336,0.622893},
{0.454457,0.617194},
{0.435921,0.618077},
{0.410709,0.618553},
{0.41767,0.623043},
{0.400623,0.622928},
{0.3899,0.6188},
{0.382264,0.623795},
{0.3899,0.6158},
{0.376646,0.616593},
{0.362678,0.622864},
{0.357169,0.624792},
{0.333782,0.623416},
{0.3436,0.5609},
{0.344222,0.572793},
{0.331964,0.561619},
{0.334188,0.59927},
{0.3471,0.5818},
{0.359152,0.581072},
{0.366648,0.57195},
{0.367352,0.577883},
{0.391326,0.577398},
{0.393775,0.571503},
{0.411936,0.579485},
{0.426737,0.572137},
{0.425566,0.580187},
{0.433874,0.578195},
{0.4559,0.5808},
{0.454811,0.591553},
{0.443563,0.59833},
{0.4565,0.6001},
{0.454575,0.607196},
{0.436232,0.604334},
{0.427224,0.599356},
{0.409793,0.603474},
{0.419255,0.597894},
{0.399123,0.598},
{0.39036,0.605245},
{0.38068,0.597884},
{0.375191,0.605399},
{0.362281,0.599232},
{0.347823,0.606537},
{0.3459,0.6},
{0.347,0.6167},
{0.368776,0.618825},
{0.240698,0.992682},
{0.237181,0.993487},
{0.237702,0.991468},
{0.244225,0.991871},
{0.248023,0.992593},
{0.287699,0.9935},
{0.279792,0.993736},
{0.284998,0.992697},
{0.292859,0.992547},
{0.294399,0.9935},
{0.301496,0.993},
{0.318527,0.992623},
{0.325824,0.991973},
{0.3233,0.993394},
{0.33,0.9925},
{0.334961,0.9915},
{0.339675,0.991582},
{0.33593,0.993144},
{0.3401,0.9929},
{0.340332,0.988147},
{0.347543,0.988594},
{0.347918,0.989495},
{0.341812,0.988824},
{0.334017,0.98764},
{0.334542,0.986794},
{0.327681,0.986366},
{0.3294,0.9858},
{0.3262,0.9854},
{0.3229,0.9849},
{0.321175,0.985293},
{0.3197,0.9845},
{0.3165,0.9841},
{0.31457,0.984969},
{0.3132,0.9837},
{0.31,0.9833},
{0.306741,0.983441},
{0.309975,0.9842},
{0.296509,0.982521},
{0.302284,0.982535},
{0.2987,0.9832},
{0.285544,0.982462},
{0.289484,0.9818},
{0.2844,0.981604},
{0.279884,0.982082},
{0.274793,0.982822},
{0.280137,0.983066},
{0.240895,0.987939},
{0.245799,0.986304},
{0.24895,0.9864},
{0.249,0.9858},
{0.2522,0.9854},
{0.255563,0.985642},
{0.2554,0.9849},
{0.2586,0.9844},
{0.263509,0.984315},
{0.2619,0.984},
{0.2651,0.9835},
{0.268113,0.983929},
{0.263476,0.984981},
{0.236853,0.990038},
{0.237082,0.987212},
{0.2397,0.9872},
{0.2427,0.9868},
{0.248037,0.987251},
{0.2398,0.993},
{0.2429,0.9931},
{0.2461,0.9932},
{0.2494,0.9932},
{0.2528,0.9933},
{0.254502,0.992516},
{0.2561,0.9934},
{0.2594,0.9934},
{0.261186,0.992593},
{0.2628,0.9934},
{0.2662,0.9936},
{0.267918,0.992814},
{0.2695,0.9937},
{0.2729,0.9937},
{0.274644,0.992914},
{0.2762,0.9938},
{0.2715,0.9826},
{0.2747,0.9823},
{0.2779,0.982},
{0.2812,0.9818},
{0.2876,0.9816},
{0.2908,0.9816},
{0.294,0.9817},
{0.2972,0.9819},
{0.3004,0.9821},
{0.3036,0.9824},
{0.3068,0.9829},
{0.3326,0.9863},
{0.3359,0.9867},
{0.339,0.9872},
{0.3422,0.9876},
{0.3451,0.988},
{0.3477,0.988},
{0.3389,0.9938},
{0.3331,0.9932},
{0.3299,0.9933},
{0.3266,0.9933},
{0.3199,0.9934},
{0.3165,0.9935},
{0.313013,0.993306},
{0.3098,0.9937},
{0.306793,0.993523},
{0.3031,0.9938},
{0.2997,0.9938},
{0.2964,0.9938},
{0.293,0.9939},
{0.2897,0.9939},
{0.2863,0.9938},
{0.2829,0.9938},
{0.334841,0.634505},
{0.335359,0.648799},
{0.296934,0.634975},
{0.324149,0.63415},
{0.297423,0.64927},
{0.323751,0.6496},
{0.308327,0.6496},
{0.296712,0.671805},
{0.316306,0.671551},
{0.296385,0.686198},
{0.335357,0.6861},
{0.334735,0.671594},
{0.334415,0.652931},
{0.312983,0.668302},
{0.296541,0.653799},
{0.310893,0.6528},
{0.297232,0.668069},
{0.334475,0.66806},
{0.430485,0.8118},
{0.430506,0.7989},
{0.4345,0.8171},
{0.419351,0.816871},
{0.411525,0.811401},
{0.402442,0.8167},
{0.411427,0.7986},
{0.402349,0.7914},
{0.397777,0.8115},
{0.390923,0.8169},
{0.401553,0.853628},
{0.4033,0.8483},
{0.413171,0.848356},
{0.430645,0.853746},
{0.433042,0.848572},
{0.451882,0.853977},
{0.4495,0.8488},
{0.4529,0.7918},
{0.44841,0.8171},
{0.448163,0.738999},
{0.426627,0.738871},
{0.425352,0.791699},
{0.269406,0.521888},
{0.251636,0.521881},
{0.251646,0.509963},
{0.2691,0.510082},
{0.504974,0.48248},
{0.483481,0.48253},
{0.474825,0.466128},
{0.463136,0.482337},
{0.44817,0.466132},
{0.448156,0.482176},
{0.504887,0.466233},
{0.342803,0.811802},
{0.3428,0.7989},
{0.352,0.7988},
{0.347268,0.7917},
{0.317986,0.792239},
{0.324485,0.799201},
{0.301519,0.7926},
{0.301634,0.799799},
{0.297,0.7998},
{0.2971,0.81269},
{0.301741,0.812699},
{0.3063,0.8179},
{0.3155,0.8176},
{0.320007,0.812249},
{0.320134,0.817599},
{0.3292,0.8174},
{0.3338,0.8173},
{0.347478,0.8171},
{0.3521,0.811702},
{0.415376,0.464795},
{0.438191,0.464694},
{0.438557,0.480837},
{0.410122,0.481909},
{0.386978,0.465777},
{0.387233,0.481912},
{0.416611,0.559695},
{0.404177,0.559864},
{0.404193,0.542731},
{0.391827,0.542713},
{0.391766,0.559681},
{0.416573,0.542564},
{0.2696,0.8002},
{0.2697,0.813095},
{0.2695,0.7931},
{0.277834,0.876067},
{0.292132,0.873801},
{0.291894,0.97658},
{0.308122,0.974946},
{0.308333,0.876237},
{0.30908,0.875573},
{0.308774,0.975834},
{0.277375,0.97475},
{0.276682,0.975495},
{0.277099,0.875197},
{0.237608,0.87449},
{0.252017,0.8722},
{0.255201,0.975776},
{0.268124,0.973273},
{0.268326,0.874555},
{0.268987,0.873752},
{0.26879,0.974117},
{0.237467,0.973186},
{0.236772,0.974015},
{0.236959,0.873664},
{0.347674,0.97437},
{0.333284,0.976685},
{0.329799,0.873124},
{0.316979,0.875658},
{0.317098,0.974408},
{0.316512,0.975315},
{0.316321,0.874812},
{0.347533,0.87564},
{0.348319,0.874948},
{0.348341,0.975218},
{0.448102,0.7099},
{0.448025,0.703699},
{0.425842,0.709606},
{0.419612,0.70336},
{0.402547,0.7095},
{0.393351,0.7034},
{0.397897,0.709501},
{0.402493,0.7386},
{0.402429,0.745401},
{0.425252,0.745799},
{0.347588,0.7098},
{0.3519,0.7917},
{0.373893,0.798703},
{0.374858,0.791552},
{0.397707,0.7986},
{0.3977,0.7914},
{0.352295,0.709799},
{0.355614,0.7036},
{0.326832,0.704004},
{0.322092,0.71026},
{0.301963,0.710699},
{0.301894,0.7046},
{0.2973,0.7046},
{0.296804,0.792602},
{0.284091,0.799983},
{0.161924,0.520453},
{0.182083,0.521757},
{0.176633,0.527347},
{0.176419,0.626718},
{0.181922,0.632271},
{0.161156,0.632794},
{0.157857,0.628819},
{0.145575,0.626231},
{0.140174,0.631834},
{0.145492,0.526979},
{0.140266,0.521361},
{0.157209,0.525479},
{0.012658,0.805797},
{0.027599,0.80674},
{0.020618,0.813859},
{0.0118,0.8137},
{0.007231,0.872088},
{0.011628,0.8392},
{0.022749,0.872297},
{0.030151,0.8392},
{0.040885,0.872484},
{0.045752,0.8392},
{0.05806,0.872423},
{0.064301,0.8392},
{0.075115,0.87236},
{0.081335,0.8392},
{0.098076,0.872288},
{0.102942,0.8392},
{0.121596,0.872195},
{0.130571,0.8392},
{0.135258,0.872134},
{0.130485,0.8137},
{0.129599,0.805843},
{0.110936,0.813985},
{0.115452,0.806731},
{0.09773,0.805935},
{0.087664,0.814241},
{0.097185,0.706889},
{0.092,0.704728},
{0.087339,0.80611},
{0.072821,0.807},
{0.062625,0.8143},
{0.054984,0.806109},
{0.0497,0.8142},
{0.05559,0.706888},
{0.050419,0.705112},
{0.044505,0.806063},
{0.036689,0.814048},
{0.375857,0.709641},
{0.374244,0.7035},
{0.357347,0.873883},
{0.368001,0.873259},
{0.376975,0.899232},
{0.382699,0.873052},
{0.408396,0.899808},
{0.397378,0.873178},
{0.424955,0.899819},
{0.433544,0.8741},
{0.407674,0.873},
{0.431714,0.873},
{0.453437,0.872894},
{0.452633,0.8988},
{0.473553,0.899155},
{0.473451,0.873401},
{0.358148,0.89947},
{0.444787,0.899763},
{0.3473,0.592},
{0.427643,0.591572},
{0.41201,0.590301},
{0.41179,0.593199},
{0.375113,0.593436},
{0.35913,0.591807},
{0.470099,0.546199},
{0.465251,0.543984},
{0.467487,0.543852},
{0.4706,0.5453},
{0.511218,0.547489},
{0.521181,0.542823},
{0.519404,0.544858},
{0.527302,0.5429},
{0.532978,0.541511},
{0.534804,0.543084},
{0.54205,0.5449},
{0.542601,0.5435},
{0.549043,0.548634},
{0.549832,0.547357},
{0.4427,0.5465},
{0.4468,0.544},
{0.446262,0.545446},
{0.4493,0.544},
{0.4433,0.5474},
{0.458803,0.54275},
{0.452353,0.543149},
{0.4533,0.5419},
{0.4578,0.5416},
{0.46,0.5417},
{0.095873,0.442147},
{0.097437,0.432154},
{0.09022,0.433604},
{0.0966,0.4307},
{0.092922,0.421962},
{0.084899,0.415121},
{0.0925,0.4204},
{0.091503,0.410965},
{0.0916,0.4093},
{0.093284,0.400063},
{0.08766,0.395203},
{0.0938,0.3985},
{0.097968,0.390155},
{0.095237,0.382011},
{0.0989,0.3888},
{0.105355,0.381942},
{0.1066,0.3812},
{0.108414,0.371477},
{0.1033,0.4396},
{0.0588,0.6566},
{0.0588,0.6821},
{0.050315,0.6566},
{0.038448,0.652275},
{0.017429,0.6567},
{0.009595,0.6524},
{0.0175,0.6821},
{0.011806,0.687438},
{0.033996,0.6821},
{0.038149,0.6919},
{0.0505,0.6821},
{0.0488,0.6919},
{0.0487,0.6938},
{0.052286,0.6919},
{0.092129,0.656601},
{0.092223,0.6821},
{0.0837,0.6566},
{0.07708,0.652246},
{0.070181,0.6566},
{0.0837,0.6821},
{0.090072,0.6919},
{0.0903,0.6938},
{0.0937,0.6919},
{0.107422,0.691929},
{0.124942,0.6822},
{0.130925,0.692},
{0.133902,0.652573},
{0.125023,0.6568},
{0.113932,0.652412},
{0.3609,0.5434},
{0.3675,0.5367},
{0.3778,0.5366},
{0.361,0.5537},
{0.3678,0.5604},
{0.3847,0.5434},
{0.3847,0.5537},
{0.3782,0.5604},
{0.3917,0.8485},
{0.375965,0.8486},
{0.368897,0.853823},
{0.36,0.8485},
{0.34827,0.8487},
{0.337724,0.854096},
{0.3344,0.8489},
{0.3298,0.849},
{0.320647,0.849199},
{0.311314,0.854604},
{0.316,0.8493},
{0.3068,0.8495},
{0.289265,0.854991},
{0.2992,0.839},
{0.289191,0.849405},
{0.278619,0.849511},
{0.2683,0.8395},
{0.2682,0.8292},
{0.278209,0.818695},
{0.283892,0.812889},
{0.288779,0.818587},
{0.299,0.8288},
{0.317846,0.723565},
{0.311082,0.71998},
{0.323288,0.720093},
{0.327297,0.722472},
{0.336102,0.719851},
{0.333749,0.731213},
{0.336216,0.744562},
{0.329453,0.741036},
{0.323799,0.744476},
{0.320005,0.74213},
{0.311197,0.744696},
{0.313572,0.733392},
{0.3593,0.8169},
{0.360612,0.811552},
{0.374553,0.816746},
{0.382159,0.811466},
{0.5294,0.602961},
{0.5294,0.607},
{0.5044,0.602998},
{0.3295,0.8445},
{0.323,0.8445},
{0.323,0.8196},
{0.3294,0.8196},
{0.4761,0.6065},
{0.4761,0.6018},
{0.5001,0.6019},
{0.4761,0.5971},
{0.5001,0.5971},
{0.5001,0.6066},
{0.4758,0.5935},
{0.4758,0.5834},
{0.4998,0.5834},
{0.4998,0.5935},
{0.3556,0.5451},
{0.349,0.5518},
{0.3387,0.5519},
{0.3555,0.5348},
{0.3487,0.528},
{0.3318,0.5451},
{0.3317,0.5348},
{0.3383,0.5281},
{0.502987,0.622665},
{0.485298,0.621849},
{0.522252,0.619307},
{0.473579,0.619304},
{0.493558,0.611535},
{0.510717,0.612266},
{0.474631,0.614795},
{0.523087,0.614896},
{0.065893,0.373485},
{0.072072,0.379666},
{0.07097,0.380812},
{0.075131,0.392123},
{0.07635,0.38939},
{0.073875,0.405486},
{0.076982,0.40009},
{0.073729,0.410175},
{0.067609,0.417732},
{0.068727,0.41841},
{0.016741,0.417718},
{0.019962,0.423187},
{0.064381,0.42381},
{0.012766,0.380661},
{0.011442,0.380021},
{0.007257,0.389748},
{0.008835,0.391177},
{0.006989,0.400509},
{0.010396,0.406001},
{0.010495,0.410522},
{0.015761,0.418682},
{0.017416,0.373592},
{0.1999,0.4598},
{0.210328,0.459698},
{0.202298,0.4728},
{0.209193,0.4728},
{0.2111,0.458},
{0.212133,0.472},
{0.2119,0.4579},
{0.2127,0.4595},
{0.223823,0.459},
{0.214586,0.472491},
{0.2228,0.4721},
{0.2246,0.4573},
{0.225633,0.471333},
{0.2254,0.4573},
{0.2262,0.4589},
{0.237621,0.458797},
{0.227987,0.471896},
{0.2363,0.4718},
{0.2385,0.4571},
{0.239133,0.4712},
{0.2393,0.4571},
{0.2401,0.4588},
{0.251422,0.458994},
{0.241586,0.471798},
{0.2498,0.4719},
{0.2524,0.4573},
{0.252633,0.4714},
{0.2532,0.4574},
{0.2539,0.4591},
{0.264926,0.459593},
{0.254987,0.472102},
{0.2633,0.4726},
{0.2659,0.458},
{0.2663,0.472067},
{0.2666,0.4581},
{0.2673,0.4598},
{0.277734,0.459797},
{0.268612,0.4728},
{0.275307,0.472801},
{0.2786,0.4581},
{0.278233,0.472367},
{0.2792,0.4582},
{0.1583,0.4113},
{0.1062,0.4113},
{0.1083,0.3989},
{0.1562,0.3989},
{0.2595,0.4499},
{0.249073,0.449903},
{0.257002,0.4369},
{0.250308,0.4369},
{0.2483,0.4517},
{0.2474,0.437667},
{0.2476,0.4518},
{0.2468,0.4501},
{0.235677,0.4506},
{0.244913,0.437208},
{0.2367,0.4376},
{0.2349,0.4523},
{0.233867,0.4383},
{0.2341,0.4524},
{0.2332,0.4507},
{0.221878,0.450903},
{0.231414,0.437804},
{0.2232,0.4378},
{0.221,0.4525},
{0.2203,0.4385},
{0.2202,0.4525},
{0.2194,0.4509},
{0.207979,0.450705},
{0.217914,0.437804},
{0.2097,0.4377},
{0.2071,0.4523},
{0.206867,0.4383},
{0.2063,0.4523},
{0.2056,0.4506},
{0.194476,0.450107},
{0.204513,0.4375},
{0.1962,0.4371},
{0.1936,0.4517},
{0.193267,0.437533},
{0.1928,0.4516},
{0.1921,0.4499},
{0.181667,0.449704},
{0.190888,0.4368},
{0.183992,0.4368},
{0.1807,0.4514},
{0.181067,0.437167},
{0.1801,0.4513},
{0.1072,0.4191},
{0.1536,0.4191},
{0.1518,0.4315},
{0.109,0.4315},
{0.071873,0.452389},
{0.068049,0.464509},
{0.011577,0.464553},
{0.071311,0.440225},
{0.007966,0.442558},
{0.008137,0.454808},
{0.013077,0.42977},
{0.066522,0.429603},
{0.4157,0.4464},
{0.358899,0.4464},
{0.358948,0.4389},
{0.348611,0.4389},
{0.346187,0.4464},
{0.336291,0.4389},
{0.332308,0.4464},
{0.322335,0.4389},
{0.321963,0.4464},
{0.2688,0.4389},
{0.2688,0.4464},
{0.415601,0.4389},
{0.428275,0.4389},
{0.428908,0.4464},
{0.441308,0.4464},
{0.440588,0.4389},
{0.45236,0.4389},
{0.45248,0.4464},
{0.1979,0.46},
{0.1989,0.4601},
{0.1984,0.4582},
{0.199,0.4582},
{0.199933,0.472333},
{0.197,0.4732},
{0.2116,0.4598},
{0.22505,0.45915},
{0.2389,0.459},
{0.2527,0.45915},
{0.2662,0.45985},
{0.2798,0.46},
{0.2788,0.46},
{0.2805,0.4732},
{0.2615,0.4498},
{0.2605,0.4497},
{0.2609,0.4515},
{0.2604,0.4516},
{0.259433,0.437367},
{0.2623,0.4365},
{0.2479,0.4499},
{0.2344,0.45055},
{0.2206,0.4507},
{0.2068,0.4505},
{0.1933,0.4498},
{0.1796,0.4496},
{0.1806,0.4495},
{0.1788,0.4364},
{0.177987,0.856613},
{0.163492,0.851171},
{0.142771,0.857161},
{0.142389,0.851768},
{0.472338,0.854467},
{0.467803,0.84925},
{0.4815,0.8493},
{0.49866,0.630197},
{0.489245,0.630488},
{0.491199,0.6256},
{0.484551,0.6256},
{0.48109,0.630563},
{0.477599,0.6256},
{0.476,0.6303},
{0.498041,0.6256},
{0.504799,0.6256},
{0.508267,0.630563},
{0.511639,0.6256},
{0.516343,0.630488},
{0.518299,0.6256},
{0.525836,0.630197},
{0.525278,0.6256},
{0.5303,0.6256},
{0.364037,0.511054},
{0.371838,0.513738},
{0.356778,0.514122},
{0.374945,0.521038},
{0.372222,0.528778},
{0.364914,0.531921},
{0.357222,0.529222},
{0.354017,0.521891},
{0.379909,0.668843},
{0.379669,0.653358},
{0.406774,0.660249},
{0.3842,0.6498},
{0.384286,0.635139},
{0.378169,0.64222},
{0.37995,0.629929},
{0.405248,0.635586},
{0.406956,0.63003},
{0.407956,0.643794},
{0.405216,0.649459},
{0.3861,0.6477},
{0.022327,0.6937},
{0.014381,0.706627},
{0.009254,0.695419},
{0.0115,0.6937},
{0.045363,0.706953},
{0.037696,0.693746},
{0.063686,0.6938},
{0.0522,0.6938},
{0.109515,0.6938},
{0.0937,0.6938},
{0.130719,0.6938},
{0.127898,0.706604},
{0.133524,0.903987},
{0.154886,0.9008},
{0.17478,0.904056},
{0.175719,0.625849},
{0.146098,0.527941},
{0.146374,0.625522},
{0.175754,0.527956},
{0.5812,0.4596},
{0.5813,0.4558},
{0.6216,0.4561},
{0.6216,0.4599},
{0.5919,0.471},
{0.596,0.471},
{0.596,0.5113},
{0.5919,0.5113},
{0.6074,0.471},
{0.6115,0.471},
{0.6115,0.5113},
{0.6074,0.5113},
{0.5971,0.471},
{0.6011,0.471},
{0.6011,0.5113},
{0.5971,0.5113},
{0.6173,0.471},
{0.6211,0.471},
{0.6211,0.5113},
{0.6173,0.5113},
{0.286145,0.630248},
{0.267851,0.630344},
{0.276256,0.629674},
{0.2838,0.6293},
{0.284746,0.56829},
{0.287,0.5693},
{0.294091,0.567963},
{0.256767,0.568339},
{0.275124,0.568112},
{0.266644,0.568926},
{0.2591,0.5693},
{0.258154,0.630297},
{0.2559,0.6293},
{0.248847,0.630575},
{0.2652,0.6293},
{0.2777,0.5693},
{0.6163,0.5113},
{0.6125,0.5113},
{0.6125,0.471},
{0.6163,0.471},
{0.6259,0.5113},
{0.6221,0.5113},
{0.6221,0.471},
{0.6259,0.471},
{0.5857,0.5113},
{0.5816,0.5113},
{0.5816,0.471},
{0.5857,0.471},
{0.6063,0.5113},
{0.6022,0.5113},
{0.6022,0.471},
{0.6063,0.471},
{0.5908,0.5113},
{0.5867,0.5113},
{0.5867,0.471},
{0.5908,0.471},
{0.226171,0.5697},
{0.225284,0.592011},
{0.2251,0.5813},
{0.237647,0.5748},
{0.237069,0.597111},
{0.2367,0.5864},
{0.232605,0.556295},
{0.2355,0.5574},
{0.234414,0.633186},
{0.2315,0.6321},
{0.222095,0.632568},
{0.244023,0.555877},
{0.199934,0.633266},
{0.1972,0.6321},
{0.198231,0.556315},
{0.2011,0.5574},
{0.210248,0.556932},
{0.18925,0.633626},
{0.211089,0.633411},
{0.2085,0.6321},
{0.221305,0.555995},
{0.2239,0.5574},
{0.1802,0.8358},
{0.179878,0.838141},
{0.180344,0.813889},
{0.029202,0.705843},
{0.070645,0.7061},
{0.079549,0.6938},
{0.086886,0.706943},
{0.112101,0.705957},
{0.391347,0.8999},
{0.072221,0.6821},
{0.07078,0.6919},
{0.323999,0.687},
{0.308086,0.6869},
{0.375857,0.742487},
{0.363209,0.743379},
{0.369746,0.738535},
{0.365474,0.728707},
{0.361955,0.717621},
{0.371928,0.719973},
{0.3751,0.717224},
{0.381353,0.721089},
{0.387959,0.716325},
{0.385648,0.730888},
{0.389108,0.742072},
{0.379197,0.739627},
{0.364161,0.6925},
{0.364752,0.6982},
{0.358014,0.6982},
{0.355552,0.692074},
{0.349735,0.6982},
{0.345453,0.691975},
{0.341114,0.6982},
{0.333533,0.692503},
{0.332834,0.6982},
{0.324214,0.6982},
{0.321751,0.692174},
{0.315927,0.6982},
{0.311678,0.692075},
{0.307355,0.6982},
{0.300826,0.692562},
{0.299891,0.698262},
{0.353365,0.687946},
{0.346078,0.684878},
{0.34338,0.677146},
{0.346522,0.669778},
{0.354252,0.667116},
{0.361622,0.670222},
{0.364245,0.678034},
{0.361178,0.685322},
{0.34071,0.636654},
{0.373762,0.635962},
{0.360631,0.6368},
{0.374626,0.661236},
{0.355498,0.660449},
{0.341377,0.661137},
{0.356958,0.6409},
{0.3418,0.6409},
{0.505838,0.757381},
{0.495615,0.761486},
{0.506361,0.743887},
{0.5078,0.7556},
{0.518161,0.755798},
{0.521884,0.743596},
{0.520286,0.757925},
{0.52933,0.762928},
{0.504546,0.768529},
{0.5211,0.768415},
{0.3708,0.675957},
{0.387771,0.674},
{0.40413,0.675417},
{0.384686,0.6762},
{0.388342,0.6803},
{0.4034,0.6803},
{0.40481,0.700286},
{0.371305,0.70104},
{0.388137,0.69989},
{0.380349,0.758116},
{0.390457,0.776086},
{0.380362,0.771609},
{0.3785,0.7698},
{0.368139,0.769598},
{0.364906,0.757264},
{0.365953,0.771606},
{0.35667,0.776328},
{0.381254,0.782756},
{0.3647,0.782116},
{0.130874,0.629593},
{0.1173,0.6306},
{0.130792,0.466881},
{0.131428,0.630207},
{0.134065,0.463977},
{0.121027,0.463049},
{0.111752,0.466887},
{0.112047,0.629685},
{0.111555,0.630247},
{0.108736,0.463799},
{0.108687,0.633013},
{0.122281,0.633462},
{0.134526,0.632991},
{0.065324,0.641245},
{0.048317,0.640188},
{0.065988,0.478999},
{0.066713,0.639736},
{0.070101,0.644077},
{0.070074,0.475451},
{0.056606,0.474696},
{0.048145,0.478894},
{0.047804,0.640576},
{0.057788,0.644213},
{0.044489,0.474948},
{0.044053,0.644083},
{0.6025,0.4661},
{0.6025,0.4695},
{0.5811,0.4693},
{0.5812,0.4658},
{0.6104,0.5341},
{0.6066,0.5341},
{0.6066,0.5128},
{0.6103,0.5128},
{0.6055,0.5341},
{0.6017,0.5341},
{0.6017,0.5128},
{0.6055,0.5128},
{0.6006,0.5341},
{0.5968,0.5341},
{0.5968,0.5128},
{0.6006,0.5128},
{0.5812,0.4645},
{0.5813,0.461},
{0.6026,0.4613},
{0.6026,0.4647},
{0.206522,0.4999},
{0.20211,0.4999},
{0.202149,0.4971},
{0.202015,0.500785},
{0.201472,0.496838},
{0.202104,0.494326},
{0.211134,0.4971},
{0.211286,0.496217},
{0.211291,0.4998},
{0.211896,0.500138},
{0.208637,0.502363},
{0.2036,0.500787},
{0.164759,0.802449},
{0.203309,0.525925},
{0.189948,0.526779},
{0.197028,0.525672},
{0.1912,0.5254},
{0.1914,0.502562},
{0.190075,0.491907},
{0.1914,0.4931},
{0.205466,0.496214},
{0.203388,0.492313},
{0.216428,0.525848},
{0.221886,0.527157},
{0.209927,0.525773},
{0.2145,0.5255},
{0.214958,0.502942},
{0.2168,0.5032},
{0.2207,0.5026},
{0.208,0.5255},
{0.2104,0.5031},
{0.222035,0.491989},
{0.220709,0.4935},
{0.2206,0.5256},
{0.2097,0.5008},
{0.201957,0.502843},
{0.2039,0.5031},
{0.2016,0.5254},
{0.1951,0.5254},
{0.195695,0.502665},
{0.196878,0.500861},
{0.4508,0.5194},
{0.4414,0.5192},
{0.4416,0.5084},
{0.451,0.5086},
{0.4311,0.5196},
{0.4313,0.5088},
{0.4215,0.5194},
{0.4217,0.5086},
{0.4112,0.5185},
{0.4114,0.5077},
{0.4018,0.5183},
{0.402,0.5075},
{0.3914,0.5188},
{0.3917,0.508},
{0.3818,0.5186},
{0.3821,0.5078},
{0.4611,0.5203},
{0.4613,0.5095},
{0.3988,0.5253},
{0.4081,0.5255},
{0.4079,0.5363},
{0.3985,0.5361},
{0.4185,0.525},
{0.4182,0.5358},
{0.4281,0.5252},
{0.4279,0.536},
{0.4384,0.5261},
{0.4382,0.5369},
{0.4477,0.5263},
{0.4475,0.5371},
{0.4581,0.5259},
{0.4579,0.5367},
{0.4677,0.5261},
{0.4675,0.5369},
{0.3885,0.5244},
{0.3882,0.5352},
{0.153953,0.910414},
{0.1333,0.907511},
{0.1746,0.907525},
{0.524037,0.546492},
{0.533856,0.54601},
{0.533046,0.546373},
{0.541076,0.547542},
{0.539866,0.548689},
{0.5454,0.5503},
{0.545702,0.549349},
{0.5448,0.5566},
{0.4786,0.5246},
{0.48253,0.52474},
{0.482486,0.534171},
{0.482599,0.5325},
{0.4826,0.5297},
{0.587808,0.5325},
{0.587798,0.5297},
{0.5882,0.5343},
{0.587951,0.524961},
{0.5916,0.5246},
{0.5916,0.5343},
{0.4786,0.5343},
{0.533399,0.5477},
{0.526796,0.547767},
{0.52065,0.5487},
{0.518015,0.547996},
{0.51541,0.550297},
{0.515131,0.549365},
{0.5159,0.5581},
{0.47861,0.551555},
{0.4749,0.5493},
{0.4815,0.5403},
{0.485089,0.553748},
{0.494351,0.554128},
{0.500701,0.5401},
{0.502083,0.552204},
{0.5074,0.5493},
{0.483504,0.489726},
{0.503994,0.4881},
{0.504398,0.4928},
{0.471654,0.494673},
{0.504644,0.496453},
{0.483395,0.497223},
{0.504797,0.5021},
{0.476828,0.50276},
{0.466255,0.497875},
{0.449455,0.498069},
{0.442486,0.503014},
{0.432736,0.497864},
{0.411643,0.497294},
{0.413014,0.50234},
{0.394585,0.494668},
{0.3941,0.5017},
{0.498683,0.556919},
{0.507235,0.560247},
{0.5009,0.5693},
{0.488279,0.556114},
{0.4817,0.5694},
{0.479705,0.558596},
{0.475167,0.561},
{0.479981,0.557641},
{0.488951,0.55534},
{0.499587,0.556485},
{0.466683,0.52237},
{0.463867,0.524068},
{0.462798,0.520912},
{0.4398,0.5209},
{0.3949,0.4883},
{0.408068,0.489427},
{0.434223,0.494878},
{0.429053,0.490367},
{0.458013,0.490525},
{0.55206,0.5819},
{0.5616,0.582},
{0.561412,0.58917},
{0.5669,0.5889},
{0.5671,0.5794},
{0.555781,0.579498},
{0.556054,0.565155},
{0.552007,0.5795},
{0.551269,0.563698},
{0.5437,0.5795},
{0.543059,0.5622},
{0.5421,0.5795},
{0.53017,0.562402},
{0.516785,0.565524},
{0.516625,0.5795},
{0.512135,0.567477},
{0.512097,0.5795},
{0.5061,0.571},
{0.5061,0.5796},
{0.549373,0.594752},
{0.548915,0.5819},
{0.541662,0.5819},
{0.541905,0.5964},
{0.540398,0.596406},
{0.518849,0.5819},
{0.522912,0.594642},
{0.515587,0.591988},
{0.5106,0.5819},
{0.5106,0.589},
{0.5057,0.589},
{0.5057,0.5819},
{0.359102,0.4873},
{0.3736,0.4891},
{0.359092,0.498794},
{0.354569,0.497009},
{0.354582,0.489089},
{0.3439,0.4894},
{0.3439,0.496974},
{0.310674,0.498556},
{0.3439,0.4873},
{0.311233,0.487299},
{0.305892,0.489478},
{0.2982,0.4971},
{0.2982,0.4895},
{0.3736,0.4971},
{0.580748,0.624834},
{0.573436,0.628718},
{0.576264,0.6183},
{0.572685,0.6183},
{0.562581,0.63137},
{0.5534,0.6315},
{0.552237,0.6183},
{0.562327,0.601106},
{0.57586,0.604373},
{0.575242,0.6166},
{0.579164,0.6166},
{0.584546,0.608964},
{0.584598,0.6166},
{0.5521,0.6166},
{0.551108,0.601},
{0.550598,0.6166},
{0.54273,0.602722},
{0.543201,0.6166},
{0.539778,0.6166},
{0.529537,0.608857},
{0.5295,0.6166},
{0.5342,0.6183},
{0.542881,0.6183},
{0.542686,0.629207},
{0.545736,0.6183},
{0.546276,0.630343},
{0.5521,0.6315},
{0.5341,0.6248},
{0.5296,0.6247},
{0.367052,0.475081},
{0.374797,0.4751},
{0.367055,0.482624},
{0.361437,0.484005},
{0.361758,0.4729},
{0.3288,0.4731},
{0.328797,0.4752},
{0.328817,0.482289},
{0.318246,0.474886},
{0.318161,0.482404},
{0.313769,0.484104},
{0.31367,0.473215},
{0.2992,0.4825},
{0.2991,0.475},
{0.1336,0.894096},
{0.0792,0.89414},
{0.1064,0.894},
{0.0792,0.896091},
{0.1336,0.896098},
{0.1064,0.8962},
{0.5125,0.4739},
{0.5125,0.469539},
{0.5766,0.473849},
{0.5766,0.4649},
{0.5125,0.4649},
{0.5125,0.4808},
{0.5766,0.4808},
{0.5766,0.4849},
{0.5125,0.4849},
{0.531317,0.508246},
{0.537,0.5081},
{0.536761,0.513101},
{0.5259,0.5077},
{0.5258,0.5127},
{0.5766,0.4794},
{0.5125,0.4794},
{0.5125,0.4753},
{0.5766,0.4753},
{0.536733,0.519795},
{0.5258,0.5197},
{0.525804,0.5147},
{0.5369,0.5148},
{0.5762,0.496586},
{0.5125,0.4966},
{0.5125,0.490977},
{0.5762,0.486323},
{0.5125,0.4863},
{0.5125,0.5007},
{0.5762,0.5007},
{0.5234,0.5192},
{0.518277,0.5195},
{0.518415,0.514563},
{0.5125,0.5142},
{0.5125,0.5192},
{0.5235,0.5142},
{0.5762,0.5062},
{0.5125,0.5062},
{0.5125,0.5021},
{0.5762,0.5021},
{0.523389,0.513099},
{0.51253,0.512797},
{0.512593,0.5078},
{0.5236,0.5081},
{0.019548,0.939731},
{0.011153,0.947789},
{0.0026,0.9373},
{0.041084,0.940786},
{0.0583,0.9386},
{0.019517,0.933879},
{0.011065,0.925004},
{0.011458,0.891449},
{0.0026,0.8793},
{0.01997,0.883698},
{0.0595,0.8808},
{0.043426,0.885031},
{0.050874,0.893947},
{0.049472,0.926827},
{0.041069,0.934938},
{0.040643,0.991102},
{0.049162,0.983352},
{0.058,0.9956},
{0.0013,0.994},
{0.017182,0.989768},
{0.009713,0.980959},
{0.049551,0.949669},
{0.046377,0.977037},
{0.045113,0.975142},
{0.046564,0.950003},
{0.04753,0.949725},
{0.040971,0.943318},
{0.040457,0.944398},
{0.044482,0.950052},
{0.04063,0.9814},
{0.040553,0.984085},
{0.0472,0.977797},
{0.023211,0.98662},
{0.024463,0.984836},
{0.040822,0.985347},
{0.019178,0.980959},
{0.017118,0.981},
{0.022704,0.987695},
{0.017271,0.954051},
{0.018522,0.955949},
{0.016129,0.981293},
{0.022982,0.949685},
{0.023065,0.94696},
{0.0164,0.953278},
{0.039161,0.946182},
{0.022811,0.945667},
{0.044583,0.920597},
{0.043416,0.918692},
{0.044817,0.893394},
{0.045697,0.893125},
{0.039637,0.886648},
{0.039133,0.887741},
{0.042895,0.893447},
{0.039248,0.924941},
{0.039199,0.927685},
{0.045356,0.921358},
{0.024329,0.928401},
{0.023097,0.93022},
{0.019393,0.924554},
{0.01748,0.924598},
{0.02266,0.931295},
{0.039453,0.928947},
{0.017613,0.89742},
{0.018798,0.899334},
{0.016602,0.924881},
{0.022965,0.893027},
{0.02301,0.890282},
{0.016847,0.896658},
{0.037911,0.889553},
{0.022762,0.889014},
{0.0752,0.952783},
{0.075102,0.978859},
{0.0624,0.977134},
{0.0624,0.984675},
{0.0751,0.987649},
{0.0624,0.954287},
{0.062487,0.946662},
{0.0752,0.943536},
{0.0752,0.93335},
{0.0625,0.930487},
{0.0752,0.924584},
{0.0625,0.922866},
{0.0753,0.898503},
{0.0625,0.900039},
{0.0625,0.892432},
{0.0753,0.889319},
{0.0753,0.8792},
{0.0625,0.879497},
{0.150532,0.9933},
{0.178379,0.993188},
{0.176524,0.997336},
{0.184109,0.9973},
{0.1851,0.9931},
{0.150836,0.9975},
{0.142264,0.9975},
{0.141411,0.992973},
{0.124786,0.992537},
{0.124236,0.9975},
{0.117579,0.993383},
{0.115676,0.9975},
{0.089775,0.9933},
{0.090053,0.9974},
{0.081519,0.9974},
{0.080698,0.992955},
{0.064084,0.992423},
{0.065242,0.9974},
{0.077462,0.947775},
{0.1147,0.94653},
{0.110688,0.952128},
{0.083647,0.953951},
{0.077961,0.983573},
{0.101195,0.983034},
{0.098412,0.987835},
{0.081322,0.988318},
{0.0844,0.9309},
{0.0782,0.9309},
{0.0782,0.9075},
{0.0844,0.9075},
{0.125096,0.987784},
{0.108017,0.988177},
{0.10465,0.983473},
{0.127895,0.983034},
{0.111039,0.963837},
{0.083945,0.965515},
{0.077771,0.959385},
{0.1151,0.95823},
{0.1767,0.9823},
{0.1886,0.9823},
{0.176701,0.9914},
{0.1973,0.9823},
{0.1886,0.966},
{0.1973,0.966},
{0.1715,0.9902},
{0.1341,0.9902},
{0.1341,0.9811},
{0.1715,0.9811},
{0.1336,0.9571},
{0.1335,0.9452},
{0.1427,0.945202},
{0.1336,0.9658},
{0.1337,0.9776},
{0.1428,0.9777},
{0.0972,0.9341},
{0.1346,0.9341},
{0.1346,0.9432},
{0.0972,0.9432},
{0.2092,0.9915},
{0.2091,0.9824},
{0.181827,0.954507},
{0.150298,0.954109},
{0.1472,0.944702},
{0.150275,0.967486},
{0.1472,0.9772},
{0.1847,0.9772},
{0.181802,0.96789},
{0.1847,0.944701},
{0.1684,0.9291},
{0.1309,0.9291},
{0.1309,0.9172},
{0.1684,0.9172},
{0.1752,0.9335},
{0.1752,0.9422},
{0.1377,0.9422},
{0.1377,0.9335},
{0.089,0.9183},
{0.1265,0.9183},
{0.1265,0.9302},
{0.089,0.9302},
{0.0995,0.8755},
{0.1369,0.8755},
{0.1369,0.8918},
{0.0995,0.8918},
{0.1265,0.9152},
{0.089,0.9152},
{0.089,0.8989},
{0.1265,0.8989},
{0.1173,0.9658},
{0.1173,0.9571},
{0.0779,0.97},
{0.1013,0.9701},
{0.0942,0.9335},
{0.0941,0.9426},
{0.1046,0.9699},
{0.128,0.9701},
{0.0942,0.8792},
{0.0942,0.8883},
{0.278325,0.6504},
{0.277,0.7158},
{0.2738,0.660697},
{0.17106,0.4821},
{0.184665,0.4821},
{0.184631,0.4869},
{0.171029,0.4869},
{0.406983,0.668884},
{0.321675,0.60092},
{0.300318,0.606932},
{0.306006,0.600836},
{0.321614,0.547401},
{0.306053,0.54746},
{0.300209,0.541249},
{0.32734,0.541629},
{0.327501,0.607013},
{0.280308,0.5327},
{0.280247,0.5032},
{0.303325,0.503267},
{0.304641,0.5327},
{0.326345,0.5033},
{0.326363,0.5327},
{0.511933,0.5486},
{0.4677,0.5086},
{0.4643,0.508463},
{0.465859,0.50594},
{0.4694,0.507062},
{0.5673,0.571},
{0.5808,0.6183},
{0.3748,0.4825},
{0.5852,0.6248},
{0.4401,0.5066},
{0.3861,0.63743},
{0.467146,0.792262},
{0.4714,0.7995},
{0.4666,0.7994},
{0.1703,0.4732},
{0.1694,0.5156},
{0.1675,0.5136},
{0.1617,0.5154},
{0.163033,0.513467},
{0.157167,0.513367},
{0.16806,0.48305},
{0.1683,0.4751},
{0.1626,0.475},
{0.15,0.5152},
{0.1462,0.5152},
{0.145533,0.513167},
{0.1404,0.5131},
{0.1384,0.5151},
{0.140906,0.482602},
{0.141639,0.474405},
{0.1395,0.4724},
{0.151391,0.513267},
{0.157033,0.4846},
{0.151176,0.4845},
{0.1545,0.4825},
{0.145333,0.484333},
{0.162933,0.4847},
{0.6048,0.4616},
{0.628,0.4613},
{0.628,0.4644},
{0.6048,0.4647},
{0.6187,0.536},
{0.6156,0.536},
{0.616633,0.5128},
{0.6233,0.5129},
{0.6236,0.5361},
{0.6205,0.5361},
{0.6202,0.5129},
{0.612433,0.5128},
{0.6145,0.536},
{0.6114,0.536},
{0.171088,0.48879},
{0.181798,0.4885},
{0.171276,0.490594},
{0.187363,0.491193},
{0.1878,0.4894},
{0.1598,0.4692},
{0.1646,0.4692},
{0.1646,0.4706},
{0.1598,0.4706},
{0.154871,0.467204},
{0.1465,0.4679},
{0.154524,0.465308},
{0.138437,0.465305},
{0.138126,0.467104},
{0.1646,0.4683},
{0.1598,0.4683},
{0.1598,0.4666},
{0.1646,0.4666},
{0.1889,0.4961},
{0.171,0.4961},
{0.171,0.4944},
{0.1889,0.4944},
{0.181709,0.5169},
{0.1841,0.517},
{0.182434,0.5188},
{0.171,0.5068},
{0.1889,0.5068},
{0.1889,0.5083},
{0.171,0.5083},
{0.1802,0.5187},
{0.177815,0.5187},
{0.179432,0.5168},
{0.1889,0.5011},
{0.171,0.5011},
{0.171,0.4995},
{0.1889,0.4995},
{0.1775,0.5138},
{0.18,0.5139},
{0.1798,0.5158},
{0.1774,0.5156},
{0.171,0.4969},
{0.1889,0.4969},
{0.1889,0.4986},
{0.171,0.4986},
{0.1833,0.5158},
{0.1809,0.5156},
{0.181,0.5138},
{0.1834,0.5139},
{0.1889,0.4931},
{0.171,0.4935},
{0.171,0.4919},
{0.1843,0.5139},
{0.1867,0.5138},
{0.1851,0.515667},
{0.1392,0.4697},
{0.1571,0.4697},
{0.1571,0.4714},
{0.1392,0.4714},
{0.174225,0.517925},
{0.1767,0.5167},
{0.1766,0.5185},
{0.17342,0.51544},
{0.171,0.5156},
{0.1711,0.5138},
{0.1889,0.5129},
{0.171,0.5129},
{0.171,0.5115},
{0.1889,0.5115},
{0.1878,0.5193},
{0.1855,0.5191},
{0.1872,0.5174},
{0.1889,0.50948},
{0.171,0.5106},
{0.171,0.5092},
{0.171,0.502},
{0.1889,0.502},
{0.1889,0.5035},
{0.171,0.5035},
{0.171,0.5165},
{0.1735,0.5166},
{0.1734,0.5185},
{0.171,0.5184},
{0.1889,0.5059},
{0.171,0.5059},
{0.171,0.5044},
{0.1889,0.5044},
{0.1743,0.5138},
{0.1768,0.514},
{0.1766,0.5158},
{0.1742,0.5156},
{0.190741,0.479732},
{0.211558,0.479184},
{0.2114,0.4816},
{0.213563,0.500858},
{0.213463,0.497321},
{0.216,0.4973},
{0.2161,0.5007},
{0.211758,0.485737},
{0.190847,0.485729},
{0.191,0.4834},
{0.2116,0.4834},
{0.233659,0.525159},
{0.2357,0.5286},
{0.233094,0.528676},
{0.213647,0.487694},
{0.234481,0.487678},
{0.2344,0.49},
{0.2138,0.49},
{0.196871,0.496947},
{0.1995,0.497},
{0.1995,0.5007},
{0.211353,0.490006},
{0.190524,0.490006},
{0.1906,0.4877},
{0.2112,0.4877},
{0.228971,0.528753},
{0.228894,0.524847},
{0.2315,0.5249},
{0.2316,0.5286},
{0.241994,0.513376},
{0.241978,0.492539},
{0.2442,0.4927},
{0.2442,0.5133},
{0.235842,0.530019},
{0.235829,0.533953},
{0.2332,0.5338},
{0.2333,0.5301},
{0.233706,0.492247},
{0.233729,0.513153},
{0.2316,0.513},
{0.2316,0.4924},
{0.236206,0.535147},
{0.236106,0.539053},
{0.2335,0.5389},
{0.2336,0.5352},
{0.238694,0.513377},
{0.238678,0.492539},
{0.2407,0.4927},
{0.2407,0.5133},
{0.228878,0.534081},
{0.228971,0.530147},
{0.2316,0.5304},
{0.2315,0.534},
{0.229906,0.492347},
{0.229906,0.513176},
{0.2279,0.5131},
{0.2279,0.4925},
{0.217371,0.500453},
{0.217371,0.496547},
{0.22,0.4967},
{0.2199,0.5004},
{0.224294,0.513276},
{0.224278,0.492439},
{0.2263,0.4926},
{0.2263,0.5132},
{0.228439,0.535558},
{0.232058,0.535463},
{0.232,0.538},
{0.2287,0.5381},
{0.237337,0.492542},
{0.237316,0.513372},
{0.2354,0.5133},
{0.2354,0.4927},
{0.195116,0.497256},
{0.195129,0.500853},
{0.1926,0.5007},
{0.1925,0.4974},
{0.2175,0.5547},
{0.2175,0.5316},
{0.2193,0.5316},
{0.2193,0.5547},
{0.2326,0.5454},
{0.2327,0.5475},
{0.2309,0.5476},
{0.2308,0.5455},
{0.2163,0.5316},
{0.2163,0.5547},
{0.2145,0.5547},
{0.2145,0.5316},
{0.23,0.545},
{0.2301,0.5471},
{0.2284,0.5472},
{0.2282,0.5451},
{0.1886,0.5547},
{0.1886,0.5316},
{0.1902,0.5316},
{0.1902,0.5547},
{0.2347,0.5435},
{0.2349,0.5413},
{0.2367,0.5415},
{0.2365,0.5436},
{0.2044,0.5316},
{0.2044,0.5547},
{0.2028,0.5547},
{0.2028,0.5316},
{0.2299,0.5413},
{0.2299,0.5434},
{0.2281,0.5434},
{0.2282,0.5412},
{0.2057,0.5547},
{0.2057,0.5316},
{0.2074,0.5316},
{0.2074,0.5547},
{0.242,0.5487},
{0.242,0.551},
{0.2402,0.5509},
{0.2403,0.5486},
{0.1932,0.5316},
{0.1932,0.5547},
{0.1915,0.5547},
{0.1915,0.5316},
{0.2314,0.5437},
{0.2316,0.5414},
{0.2334,0.5415},
{0.2332,0.5439},
{0.1944,0.5547},
{0.1944,0.5316},
{0.1962,0.5316},
{0.1962,0.5547},
{0.2378,0.5432},
{0.2377,0.5408},
{0.2395,0.5408},
{0.2395,0.5431},
{0.2103,0.5316},
{0.2103,0.5547},
{0.2086,0.5547},
{0.2086,0.5316},
{0.2352,0.545},
{0.2351,0.5473},
{0.2333,0.5472},
{0.2335,0.5448},
{0.2116,0.5547},
{0.2116,0.5316},
{0.2133,0.5316},
{0.2133,0.5547},
{0.242,0.5447},
{0.2421,0.547},
{0.2404,0.5471},
{0.2403,0.5448},
{0.1992,0.5316},
{0.1992,0.5547},
{0.1974,0.5547},
{0.1974,0.5316},
{0.2385,0.5447},
{0.2386,0.547},
{0.2368,0.5471},
{0.2367,0.5447},
{0.2742,0.5457},
{0.2487,0.5457},
{0.2487,0.5438},
{0.2742,0.5438},
{0.2386,0.5509},
{0.2363,0.551},
{0.2362,0.549},
{0.2385,0.5489},
{0.2487,0.5378},
{0.2742,0.5378},
{0.2742,0.5397},
{0.2487,0.5397},
{0.2777,0.5427},
{0.2753,0.5428},
{0.2753,0.5408},
{0.2776,0.5408},
{0.2742,0.5427},
{0.2487,0.5427},
{0.2487,0.5408},
{0.2742,0.5408},
{0.2779,0.5397},
{0.2753,0.5398},
{0.2753,0.5379},
{0.2778,0.5378},
{0.2487,0.5348},
{0.2742,0.5348},
{0.2742,0.5367},
{0.2487,0.5367},
{0.231,0.5542},
{0.2285,0.5543},
{0.2284,0.5523},
{0.2309,0.5522},
{0.2742,0.5517},
{0.2487,0.5517},
{0.2487,0.5498},
{0.2742,0.5498},
{0.2778,0.5369},
{0.2753,0.5367},
{0.2754,0.5348},
{0.278,0.5349},
{0.2487,0.5468},
{0.2742,0.5468},
{0.2742,0.5487},
{0.2487,0.5487},
{0.2394,0.5523},
{0.2419,0.5522},
{0.242,0.5542},
{0.2394,0.5542},
{0.2742,0.5576},
{0.2487,0.5576},
{0.2487,0.5557},
{0.2742,0.5557},
{0.2286,0.5487},
{0.2312,0.5489},
{0.231,0.5509},
{0.2285,0.5506},
{0.2487,0.5527},
{0.2742,0.5527},
{0.2742,0.5546},
{0.2487,0.5546},
{0.2383,0.5542},
{0.2357,0.5542},
{0.2357,0.5522},
{0.2383,0.5523},
{0.2742,0.5605},
{0.2487,0.5605},
{0.2487,0.5586},
{0.2742,0.5586},
{0.235,0.551},
{0.2326,0.551},
{0.2326,0.549},
{0.235,0.5491},
{0.2487,0.5615},
{0.2742,0.5615},
{0.2742,0.5634},
{0.2487,0.5634},
{0.2323,0.5522},
{0.2346,0.5524},
{0.2344,0.5544},
{0.2321,0.5542},
{0.8533,0.0835},
{0.8341,0.0844},
{0.835551,0.077288},
{0.851519,0.078095},
{0.8335,0.0708},
{0.8527,0.0699},
{0.851036,0.076263},
{0.8572,0.0745},
{0.8574,0.0786},
{0.8105,0.0215},
{0.7964,0.0215},
{0.795947,0.018521},
{0.810902,0.018279},
{0.7964,0.0153},
{0.8104,0.0153},
{0.8129,0.018114},
{0.813,0.0194},
{0.8509,0.0497},
{0.8317,0.0505},
{0.833151,0.043454},
{0.849118,0.044295},
{0.8311,0.037},
{0.8503,0.0361},
{0.848663,0.042431},
{0.8549,0.0407},
{0.855,0.0448},
{0.8117,0.0466},
{0.7977,0.0466},
{0.797247,0.043621},
{0.812173,0.043379},
{0.7977,0.0404},
{0.8117,0.0404},
{0.8142,0.043214},
{0.8142,0.0445},
{0.8533,0.0669},
{0.8342,0.0678},
{0.835639,0.06067},
{0.851584,0.061495},
{0.8336,0.0542},
{0.8527,0.0533},
{0.851104,0.059631},
{0.8573,0.0579},
{0.8575,0.062},
{0.8105,0.0134},
{0.7964,0.0134},
{0.795947,0.010421},
{0.810902,0.010179},
{0.7964,0.0072},
{0.8104,0.0072},
{0.8129,0.010014},
{0.813,0.0114},
{0.8506,0.0334},
{0.8315,0.0342},
{0.832939,0.02717},
{0.848884,0.027995},
{0.8309,0.0207},
{0.85,0.0198},
{0.848384,0.026131},
{0.8546,0.0244},
{0.8548,0.0285},
{0.8117,0.0385},
{0.7977,0.0385},
{0.797247,0.035521},
{0.812173,0.035279},
{0.7977,0.0323},
{0.8117,0.0323},
{0.8142,0.035114},
{0.8142,0.0365},
{0.8506,0.0172},
{0.8315,0.018},
{0.832939,0.010954},
{0.848884,0.011795},
{0.8309,0.0045},
{0.85,0.0036},
{0.848384,0.009931},
{0.8546,0.0082},
{0.8548,0.0123},
{0.8117,0.0304},
{0.7977,0.0304},
{0.797247,0.027421},
{0.812173,0.027179},
{0.7977,0.0242},
{0.8117,0.0242},
{0.8142,0.027014},
{0.8142,0.0284},
{0.8528,0.1014},
{0.8336,0.1023},
{0.835084,0.095188},
{0.851018,0.095995},
{0.833,0.0887},
{0.8522,0.0878},
{0.850563,0.094163},
{0.8568,0.0924},
{0.8569,0.0965},
{0.8117,0.0547},
{0.7977,0.0547},
{0.797247,0.051721},
{0.812173,0.05143},
{0.7977,0.0485},
{0.8117,0.0485},
{0.8142,0.051314},
{0.8142,0.0526},
{0.660108,0.18834},
{0.659842,0.191671},
{0.656247,0.190596},
{0.658062,0.187338},
{0.655739,0.187208},
{0.654975,0.192505},
{0.657965,0.193831},
{0.662485,0.190597},
{0.661579,0.187623},
{0.658796,0.185743},
{0.658119,0.180514},
{0.652767,0.182352},
{0.655773,0.178814},
{0.650292,0.177483},
{0.650416,0.175497},
{0.657285,0.17346},
{0.6579,0.1752},
{0.717927,0.199578},
{0.720096,0.197008},
{0.726667,0.199569},
{0.721362,0.20565},
{0.722901,0.207006},
{0.728049,0.201048},
{0.668477,0.189853},
{0.666333,0.184026},
{0.671167,0.187286},
{0.671723,0.181189},
{0.673933,0.181286},
{0.676371,0.188972},
{0.6744,0.1896},
{0.713599,0.171697},
{0.711412,0.169109},
{0.720082,0.169133},
{0.714942,0.163117},
{0.716355,0.161655},
{0.721524,0.167508},
{0.649148,0.19087},
{0.653846,0.189574},
{0.650294,0.195298},
{0.645562,0.194207},
{0.645,0.1989},
{0.642865,0.199086},
{0.640375,0.191245},
{0.642298,0.1905},
{0.706402,0.209403},
{0.708553,0.211963},
{0.705091,0.21806},
{0.699848,0.211936},
{0.698558,0.213592},
{0.703645,0.219445},
{0.661032,0.193365},
{0.663271,0.197706},
{0.65804,0.199932},
{0.662522,0.201865},
{0.6663,0.2026},
{0.666332,0.204548},
{0.6594,0.20664},
{0.6587,0.204903},
{0.72484,0.211247},
{0.726504,0.219411},
{0.719544,0.217317},
{0.722966,0.210234},
{0.717944,0.216138},
{0.724252,0.151123},
{0.723653,0.156241},
{0.718178,0.150522},
{0.723246,0.14633},
{0.715773,0.158616},
{0.711397,0.157003},
{0.716005,0.152595},
{0.721423,0.158373},
{0.736997,0.1462},
{0.743611,0.146178},
{0.737047,0.154367},
{0.733882,0.1544},
{0.733715,0.1462},
{0.729348,0.150568},
{0.727096,0.1462},
{0.741174,0.151203},
{0.647415,0.2094},
{0.656711,0.20938},
{0.65008,0.217574},
{0.64679,0.217571},
{0.642474,0.214156},
{0.640296,0.209398},
{0.654273,0.214445},
{0.672807,0.196541},
{0.676109,0.1941},
{0.676103,0.2023},
{0.669495,0.2023},
{0.679276,0.194142},
{0.683726,0.197602},
{0.686005,0.202303},
{0.679339,0.2023},
{0.699,0.188545},
{0.699098,0.191618},
{0.695617,0.191752},
{0.695759,0.188194},
{0.694441,0.192884},
{0.699791,0.192791},
{0.699438,0.187437},
{0.694205,0.187505},
{0.735967,0.164631},
{0.729396,0.167192},
{0.727108,0.164605},
{0.730665,0.158553},
{0.732201,0.157195},
{0.737349,0.163152},
{0.701577,0.189754},
{0.707297,0.190342},
{0.705132,0.196174},
{0.709967,0.192914},
{0.7132,0.1906},
{0.715171,0.191234},
{0.712659,0.198928},
{0.710438,0.199019},
{0.721383,0.192884},
{0.717907,0.186895},
{0.720082,0.184331},
{0.726581,0.186868},
{0.722855,0.194345},
{0.727931,0.188482},
{0.697521,0.194395},
{0.696938,0.199622},
{0.691607,0.197847},
{0.694624,0.201334},
{0.6961,0.20664},
{0.6968,0.2049},
{0.688066,0.185013},
{0.692648,0.190621},
{0.702115,0.182424},
{0.696614,0.185756},
{0.748506,0.157113},
{0.750697,0.159698},
{0.747072,0.165567},
{0.741917,0.159583},
{0.740344,0.160862},
{0.745366,0.166755},
{0.68609,0.189402},
{0.681467,0.181487},
{0.679175,0.18897},
{0.681098,0.1898},
{0.696881,0.180269},
{0.701367,0.178248},
{0.697501,0.175197},
{0.6982,0.17346},
{0.705142,0.175552},
{0.7052,0.1775},
{0.689183,0.202637},
{0.689304,0.204603},
{0.666291,0.21084},
{0.669004,0.217824},
{0.661046,0.216966},
{0.659758,0.215308},
{0.664845,0.209455},
{0.6838,0.1813},
{0.747462,0.1399},
{0.743307,0.136498},
{0.747408,0.1317},
{0.740796,0.1317},
{0.755051,0.136068},
{0.750659,0.1399},
{0.750691,0.1317},
{0.757204,0.1317},
{0.688879,0.209426},
{0.693074,0.212596},
{0.695518,0.217638},
{0.688868,0.2176},
{0.685641,0.2094},
{0.685609,0.2176},
{0.681249,0.213232},
{0.679096,0.2176},
{0.727676,0.173422},
{0.731873,0.176555},
{0.734319,0.181644},
{0.727697,0.1816},
{0.724415,0.1816},
{0.72439,0.173429},
{0.720075,0.176843},
{0.717896,0.181602},
{0.744894,0.094301},
{0.753617,0.0942},
{0.751408,0.102432},
{0.754682,0.102454},
{0.761405,0.094298},
{0.759165,0.098999},
{0.746079,0.0975},
{0.601817,0.202},
{0.595159,0.202},
{0.596047,0.1914},
{0.586076,0.1914},
{0.587342,0.202},
{0.581712,0.202},
{0.605237,0.1914},
{0.607953,0.202},
{0.612921,0.1914},
{0.614231,0.201945},
{0.619049,0.1914},
{0.620266,0.2019},
{0.62599,0.1914},
{0.627368,0.2019},
{0.6303,0.1914},
{0.723646,0.117988},
{0.729589,0.116856},
{0.734753,0.126737},
{0.734116,0.12042},
{0.731433,0.130986},
{0.724411,0.13092},
{0.720155,0.124092},
{0.61065,0.2086},
{0.61637,0.2086},
{0.614483,0.219186},
{0.622201,0.2191},
{0.621721,0.2086},
{0.627242,0.2086},
{0.629221,0.2191},
{0.6308,0.2086},
{0.607637,0.2192},
{0.603654,0.20865},
{0.601475,0.2192},
{0.595215,0.2087},
{0.593775,0.2192},
{0.585819,0.2087},
{0.587674,0.2193},
{0.583074,0.2193},
{0.754036,0.12408},
{0.74832,0.124797},
{0.744342,0.113064},
{0.743557,0.120687},
{0.751956,0.110185},
{0.757449,0.114929},
{0.75745,0.120302},
{0.474992,0.509153},
{0.474964,0.509093},
{0.4754,0.507998},
{0.4812,0.5134},
{0.482079,0.513271},
{0.475806,0.508073},
{0.48243,0.513311},
{0.477032,0.519651},
{0.477053,0.518647},
{0.47741,0.51966},
{0.470678,0.51442},
{0.470482,0.514558},
{0.471741,0.514363},
{0.471632,0.513081},
{0.472085,0.513192},
{0.497354,0.508834},
{0.497375,0.507452},
{0.498262,0.508493},
{0.496909,0.507674},
{0.490012,0.511735},
{0.490858,0.5121},
{0.48955,0.511967},
{0.495422,0.518856},
{0.495544,0.517614},
{0.503211,0.514198},
{0.501156,0.513402},
{0.502172,0.51428},
{0.495124,0.518598},
{0.501239,0.512822},
{0.501683,0.512552},
{0.9185,0.1262},
{0.8622,0.1262},
{0.8622,0.1256},
{0.9185,0.1256},
{0.9185,0.1068},
{0.8622,0.1068},
{0.8622,0.0923},
{0.9185,0.0923},
{0.9185,0.1226},
{0.8622,0.1226},
{0.8622,0.108},
{0.9185,0.108},
{0.9185,0.1238},
{0.9185,0.1244},
{0.8622,0.1244},
{0.8622,0.1238},
{0.9185,0.1068},
{0.8622,0.1068},
{0.8622,0.0923},
{0.9185,0.0923},
{0.9185,0.1226},
{0.8622,0.1226},
{0.8622,0.108},
{0.9185,0.108},
{0.9185,0.1262},
{0.8622,0.1262},
{0.8622,0.1256},
{0.9185,0.1256},
{0.9185,0.1068},
{0.8622,0.1068},
{0.8622,0.0923},
{0.9185,0.0923},
{0.9185,0.1226},
{0.8622,0.1226},
{0.8622,0.108},
{0.9185,0.108},
{0.9185,0.1262},
{0.8622,0.1262},
{0.8622,0.1256},
{0.9185,0.1256},
{0.9185,0.1068},
{0.8622,0.1068},
{0.8622,0.0923},
{0.9185,0.0923},
{0.9185,0.1226},
{0.8622,0.1226},
{0.8622,0.108},
{0.9185,0.108},
{0.997,0.0275},
{0.997,0.0279},
{0.959,0.0279},
{0.959,0.0275},
{0.997,0.016},
{0.959,0.016},
{0.959,0.0062},
{0.997,0.0062},
{0.997,0.0266},
{0.959,0.0266},
{0.959,0.0168},
{0.997,0.0168},
{0.9974,0.0515},
{0.9974,0.0518},
{0.9594,0.0518},
{0.9594,0.0515},
{0.9974,0.04},
{0.9594,0.04},
{0.9594,0.0302},
{0.9974,0.0302},
{0.9974,0.0506},
{0.9594,0.0506},
{0.9594,0.0408},
{0.9974,0.0408},
{0.9974,0.0773},
{0.9594,0.0773},
{0.9594,0.0769},
{0.9974,0.0769},
{0.9974,0.0642},
{0.9594,0.0642},
{0.9594,0.0544},
{0.9974,0.0544},
{0.9974,0.0748},
{0.9594,0.0748},
{0.9594,0.065},
{0.9974,0.065},
{0.9974,0.1016},
{0.9594,0.1016},
{0.9594,0.1013},
{0.9974,0.1013},
{0.9974,0.0886},
{0.9594,0.0886},
{0.9594,0.0788},
{0.9974,0.0788},
{0.9974,0.0992},
{0.9594,0.0992},
{0.9594,0.0894},
{0.9974,0.0894},
{0.9974,0.1254},
{0.9594,0.1254},
{0.9594,0.1251},
{0.9974,0.1251},
{0.9974,0.1124},
{0.9594,0.1124},
{0.9594,0.1026},
{0.9974,0.1026},
{0.9974,0.123},
{0.9594,0.123},
{0.9594,0.1132},
{0.9974,0.1132},
{0.8843,0.05857},
{0.8843,0.052894},
{0.95,0.0533},
{0.95,0.047731},
{0.8843,0.048094},
{0.8843,0.042389},
{0.95,0.042},
{0.95,0.0372},
{0.8843,0.036794},
{0.95,0.030775},
{0.8843,0.031952},
{0.8843,0.025443},
{0.95,0.02353},
{0.8843,0.019023},
{0.95,0.01703},
{0.8843,0.014194},
{0.95,0.009797},
{0.8843,0.008517},
{0.95,0.0582},
{0.95,0.06383},
{0.8843,0.06578},
{0.95,0.068602},
{0.8843,0.0709},
{0.95,0.0709},
{0.720763,0.242867},
{0.7229,0.243323},
{0.722753,0.244373},
{0.72045,0.245287},
{0.722784,0.246116},
{0.720718,0.247236},
{0.72343,0.244123},
{0.723441,0.246089},
{0.725059,0.243622},
{0.7249,0.244802},
{0.725035,0.24628},
{0.725459,0.244082},
{0.725431,0.245509},
{0.728953,0.243952},
{0.729341,0.244019},
{0.7293,0.244942},
{0.7289,0.244789},
{0.728963,0.245844},
{0.729359,0.245818},
{0.731023,0.24482},
{0.7311,0.245318},
{0.719667,0.242165},
{0.719331,0.244581},
{0.670094,0.243121},
{0.6702,0.2403},
{0.719455,0.247078},
{0.7278,0.244216},
{0.7284,0.243935},
{0.728435,0.244708},
{0.7278,0.245089},
{0.728473,0.245538},
{0.7278,0.245792},
{0.7284,0.2462},
{0.67,0.247121},
{0.656063,0.256763},
{0.657655,0.256334},
{0.6571,0.2571},
{0.6571,0.2571},
{0.6571,0.2572},
{0.670181,0.251797},
{0.7198,0.2528},
{0.719484,0.254076},
{0.6701,0.2537},
{0.719317,0.256575},
{0.670047,0.255821},
{0.67,0.25857},
{0.719582,0.258887},
{0.720763,0.253967},
{0.720449,0.256398},
{0.720718,0.258336},
{0.722871,0.254386},
{0.7235,0.2542},
{0.723419,0.255206},
{0.722753,0.255442},
{0.723424,0.256789},
{0.722793,0.257239},
{0.7235,0.2579},
{0.725013,0.254862},
{0.7249,0.255885},
{0.724996,0.257151},
{0.7255,0.2549},
{0.72541,0.255958},
{0.7255,0.257143},
{0.7278,0.255113},
{0.7278,0.255912},
{0.7278,0.256926},
{0.7285,0.255808},
{0.7285,0.256477},
{0.7284,0.257106},
{0.7284,0.255077},
{0.7289,0.256085},
{0.729,0.257022},
{0.728942,0.255058},
{0.729337,0.255257},
{0.7293,0.256025},
{0.729363,0.256779},
{0.731065,0.256101},
{0.7311,0.256336},
{0.731053,0.255635},
{0.657,0.257},
{0.657347,0.257757},
{0.657947,0.257579},
{0.6577,0.2574},
{0.6576,0.2573},
{0.6569,0.2568},
{0.7311,0.2444},
{0.6575,0.2572},
{0.6566,0.2486},
{0.659778,0.24705},
{0.656735,0.252849},
{0.663871,0.248825},
{0.662883,0.254059},
{0.4194,0.3342},
{0.398307,0.332201},
{0.398206,0.323399},
{0.3938,0.3322},
{0.3937,0.3234},
{0.4194,0.3212},
{0.424815,0.332101},
{0.424816,0.323299},
{0.4385,0.3315},
{0.4385,0.3237},
{0.440363,0.3211},
{0.4367,0.3211},
{0.4367,0.3237},
{0.440387,0.3343},
{0.456762,0.3211},
{0.464865,0.3343},
{0.471347,0.321},
{0.480436,0.3342},
{0.482022,0.321058},
{0.49082,0.332243},
{0.4896,0.3239},
{0.499808,0.323918},
{0.500556,0.3322},
{0.5029,0.324},
{0.5029,0.3322},
{0.4469,0.3119},
{0.4433,0.3115},
{0.4469,0.3071},
{0.449176,0.311108},
{0.449164,0.307897},
{0.4541,0.3081},
{0.4541,0.311},
{0.4557,0.3119},
{0.454118,0.3071},
{0.460771,0.311932},
{0.46174,0.3071},
{0.468993,0.311972},
{0.468783,0.307166},
{0.47301,0.307888},
{0.473096,0.3109},
{0.474904,0.3109},
{0.474961,0.3079},
{0.476489,0.3109},
{0.476489,0.3079},
{0.4433,0.3075},
{0.4403,0.3111},
{0.4403,0.3079},
{0.4541,0.3119},
{0.508893,0.338602},
{0.488299,0.3435},
{0.4896,0.338699},
{0.483128,0.339697},
{0.482785,0.341498},
{0.4696,0.3386},
{0.4691,0.3404},
{0.4995,0.3374},
{0.5073,0.3344},
{0.4988,0.3193},
{0.488901,0.317999},
{0.508194,0.318098},
{0.5066,0.3223},
{0.4876,0.3132},
{0.482396,0.317004},
{0.482085,0.315202},
{0.4689,0.3181},
{0.4684,0.3164},
{0.4368,0.3343},
{0.4367,0.3315},
{0.4413,0.3176},
{0.4369,0.3173},
{0.441839,0.313984},
{0.423234,0.315462},
{0.42556,0.310955},
{0.411053,0.310764},
{0.400715,0.316269},
{0.400474,0.312338},
{0.3928,0.3147},
{0.389963,0.320603},
{0.384491,0.320568},
{0.387775,0.324549},
{0.384127,0.323885},
{0.441051,0.338903},
{0.441616,0.342522},
{0.417435,0.345885},
{0.420494,0.341256},
{0.401177,0.340446},
{0.401938,0.344513},
{0.391941,0.341194},
{0.390371,0.336007},
{0.387892,0.331878},
{0.384134,0.335438},
{0.384329,0.332614},
{0.455396,0.3379},
{0.458521,0.338},
{0.45545,0.348275},
{0.45235,0.348175},
{0.457977,0.3484},
{0.4594,0.3484},
{0.4514,0.3378},
{0.452885,0.3378},
{0.4693,0.3623},
{0.488294,0.364199},
{0.4693,0.3745},
{0.464386,0.372601},
{0.464486,0.364199},
{0.4521,0.3721},
{0.4522,0.3646},
{0.4506,0.3622},
{0.450532,0.3746},
{0.4538,0.3746},
{0.4538,0.3721},
{0.488294,0.372701},
{0.4923,0.3727},
{0.4923,0.3642},
{0.413048,0.362154},
{0.419616,0.3621},
{0.41315,0.374431},
{0.4063,0.3647},
{0.40477,0.3727},
{0.397168,0.3647},
{0.396496,0.3727},
{0.3944,0.3647},
{0.3944,0.3727},
{0.443,0.3509},
{0.4458,0.3512},
{0.4458,0.3544},
{0.4482,0.3541},
{0.4482,0.3514},
{0.443,0.3547},
{0.441243,0.354107},
{0.441249,0.351497},
{0.4374,0.3516},
{0.4374,0.354},
{0.4361,0.3548},
{0.4374,0.3548},
{0.437391,0.3508},
{0.432215,0.3548},
{0.43193,0.3508},
{0.425827,0.354778},
{0.42589,0.3509},
{0.422715,0.351391},
{0.422648,0.353919},
{0.421226,0.3539},
{0.421197,0.3514},
{0.41998,0.3539},
{0.419933,0.3514},
{0.3959,0.3777},
{0.405601,0.378899},
{0.386706,0.378902},
{0.3882,0.3748},
{0.406901,0.383701},
{0.411966,0.379897},
{0.412215,0.381698},
{0.4252,0.3789},
{0.4257,0.3806},
{0.385506,0.359699},
{0.4058,0.3549},
{0.404499,0.359599},
{0.410896,0.358604},
{0.411115,0.356901},
{0.4241,0.3597},
{0.4245,0.358},
{0.3948,0.3608},
{0.3871,0.3638},
{0.4538,0.3622},
{0.4538,0.3646},
{0.4544,0.3592},
{0.4501,0.3594},
{0.462032,0.353431},
{0.468208,0.357377},
{0.483683,0.353023},
{0.490504,0.358188},
{0.490765,0.354349},
{0.4981,0.3567},
{0.500674,0.362059},
{0.505754,0.362151},
{0.502693,0.365831},
{0.506073,0.365307},
{0.474977,0.386807},
{0.449672,0.383419},
{0.468792,0.382102},
{0.450231,0.379902},
{0.498842,0.381923},
{0.490057,0.385156},
{0.499853,0.377105},
{0.489454,0.381427},
{0.439182,0.362182},
{0.427054,0.374517},
{0.502325,0.373043},
{0.505771,0.373714},
{0.505969,0.376531},
{0.438085,0.3895},
{0.435396,0.3895},
{0.435743,0.3787},
{0.438315,0.3787},
{0.440522,0.3895},
{0.440882,0.3787},
{0.4428,0.3895},
{0.4428,0.3787},
{0.4495,0.3558},
{0.649138,0.5461},
{0.6492,0.545522},
{0.6487,0.54614},
{0.6486,0.5454},
{0.649559,0.545794},
{0.649519,0.546932},
{0.649147,0.54687},
{0.649262,0.547686},
{0.6496,0.5476},
{0.6481,0.546489},
{0.648049,0.545743},
{0.645673,0.546031},
{0.648042,0.547426},
{0.645749,0.547636},
{0.6487,0.546906},
{0.6487,0.547608},
{0.6513,0.546248},
{0.6513,0.547009},
{0.639547,0.547431},
{0.639684,0.544959},
{0.590376,0.543608},
{0.64,0.5433},
{0.5903,0.547523},
{0.639825,0.549598},
{0.590169,0.553721},
{0.640841,0.545467},
{0.640923,0.548716},
{0.643641,0.547343},
{0.643691,0.545564},
{0.643067,0.545702},
{0.643047,0.547853},
{0.6437,0.5484},
{0.645137,0.547143},
{0.645216,0.545643},
{0.6453,0.5481},
{0.673065,0.580599},
{0.663204,0.580749},
{0.669421,0.586382},
{0.639365,0.556397},
{0.639718,0.554128},
{0.5901,0.557663},
{0.639455,0.559219},
{0.5901,0.5603},
{0.640655,0.55539},
{0.640486,0.557672},
{0.640759,0.559336},
{0.6485,0.556642},
{0.648453,0.556006},
{0.647823,0.556389},
{0.647881,0.557291},
{0.6485,0.557308},
{0.6485,0.558042},
{0.6478,0.557994},
{0.6489,0.556832},
{0.649,0.556022},
{0.648976,0.557939},
{0.649337,0.556466},
{0.6493,0.55743},
{0.6494,0.558018},
{0.642758,0.557428},
{0.642876,0.555581},
{0.642841,0.558724},
{0.643474,0.556064},
{0.643424,0.557843},
{0.6435,0.5589},
{0.6454,0.557391},
{0.645488,0.556262},
{0.644989,0.556143},
{0.644915,0.557643},
{0.6455,0.558219},
{0.6451,0.5586},
{0.6511,0.557119},
{0.6511,0.556635},
{0.6511,0.557541},
{0.645165,0.595469},
{0.650225,0.604235},
{0.660035,0.599758},
{0.654414,0.58997},
{0.6866,0.5554},
{0.678936,0.5554},
{0.679622,0.5586},
{0.6866,0.5586},
{0.6909,0.545202},
{0.679793,0.5436},
{0.680916,0.5468},
{0.6785,0.541252},
{0.689749,0.5428},
{0.688044,0.5397},
{0.7043,0.54125},
{0.6785,0.55305},
{0.6873,0.5546},
{0.6873,0.5515},
{0.674898,0.552228},
{0.667822,0.553331},
{0.668073,0.555656},
{0.658,0.5525},
{0.663305,0.549137},
{0.6575,0.5489},
{0.667068,0.542919},
{0.674569,0.544368},
{0.669197,0.540664},
{0.658,0.5438},
{0.663241,0.547614},
{0.6575,0.5473},
{0.695043,0.5546},
{0.69575,0.5515},
{0.6881,0.5515},
{0.6881,0.5546},
{0.68845,0.5507},
{0.689588,0.5475},
{0.6785,0.549102},
{0.693049,0.5389},
{0.7043,0.537302},
{0.694757,0.5357},
{0.6785,0.5373},
{0.6916,0.5436},
{0.6916,0.5468},
{0.7004,0.5452},
{0.674569,0.535832},
{0.667068,0.537263},
{0.669197,0.539436},
{0.658,0.5364},
{0.663241,0.532586},
{0.6575,0.5328},
{0.667822,0.559035},
{0.674898,0.560172},
{0.668073,0.556643},
{0.658,0.5599},
{0.663305,0.563263},
{0.6575,0.5634},
{0.078078,0.611192},
{0.0845,0.4661},
{0.099494,0.611261},
{0.089189,0.615016},
{0.10286,0.614621},
{0.10043,0.466475},
{0.099752,0.467219},
{0.078163,0.466439},
{0.078767,0.467028},
{0.074516,0.614392},
{0.075073,0.463287},
{0.088913,0.462884},
{0.103691,0.463355},
{0.359423,0.357769},
{0.351172,0.357812},
{0.358498,0.302508},
{0.359138,0.303178},
{0.360276,0.301924},
{0.355063,0.3019},
{0.350301,0.302912},
{0.350868,0.303243},
{0.351003,0.358006},
{0.359962,0.358054},
{0.3607,0.3591},
{0.355138,0.3592},
{0.350038,0.35916},
{0.3495,0.302},
{0.112815,0.63088},
{0.11145,0.628967},
{0.111968,0.468732},
{0.130251,0.467793},
{0.122224,0.46418},
{0.108493,0.463826},
{0.108083,0.634339},
{0.120741,0.634419},
{0.130916,0.629885},
{0.131693,0.469597},
{0.134913,0.464262},
{0.134855,0.634476},
{0.373383,0.357466},
{0.372622,0.358243},
{0.373527,0.303124},
{0.374269,0.359355},
{0.374847,0.301853},
{0.367098,0.302319},
{0.365411,0.303053},
{0.365512,0.358374},
{0.368806,0.359348},
{0.364685,0.357596},
{0.36355,0.359158},
{0.364154,0.301754},
{0.36976,0.3016},
{0.8492,0.1928},
{0.8448,0.1928},
{0.8449,0.1782},
{0.8492,0.1782},
{0.8529,0.275},
{0.85742,0.284088},
{0.858293,0.295799},
{0.8234,0.3074},
{0.852942,0.307187},
{0.8936,0.2344},
{0.89812,0.243487},
{0.898953,0.255159},
{0.8642,0.2343},
{0.893681,0.266529},
{0.8641,0.2667},
{0.8235,0.275},
{0.910091,0.2133},
{0.9098,0.2177},
{0.8804,0.2177},
{0.9098,0.209},
{0.910054,0.2047},
{0.8804,0.2047},
{0.9744,0.2176},
{0.944677,0.2177},
{0.945,0.2133},
{0.944709,0.209},
{0.945,0.2047},
{0.9744,0.2047},
{0.934727,0.2047},
{0.932003,0.209},
{0.922796,0.2047},
{0.920072,0.209},
{0.934727,0.2133},
{0.932004,0.2177},
{0.922796,0.2133},
{0.920072,0.2177},
{0.9734,0.278},
{0.9734,0.2737},
{0.9966,0.2737},
{0.9966,0.278},
{0.8706,0.1694},
{0.865979,0.178446},
{0.865107,0.190121},
{0.870343,0.201456},
{0.8735,0.197},
{0.8967,0.1971},
{0.8967,0.2014},
{0.8234,0.2017},
{0.82802,0.192613},
{0.828953,0.180902},
{0.823663,0.169544},
{0.9503,0.291},
{0.9453,0.2929},
{0.9466,0.2814},
{0.957382,0.277291},
{0.961167,0.286851},
{0.959948,0.27632},
{0.963897,0.285813},
{0.9624,0.2754},
{0.9661,0.285},
{0.964,0.2748},
{0.9676,0.2844},
{0.9668,0.2737},
{0.9705,0.2833},
{0.9416,0.2833},
{0.9871,0.2047},
{0.9871,0.2077},
{0.9773,0.21},
{0.988746,0.2114},
{0.9878,0.2091},
{0.9891,0.2101},
{0.991348,0.210673},
{0.9906,0.2104},
{0.9921,0.2101},
{0.993303,0.209101},
{0.9773,0.2047},
{0.9549,0.2969},
{0.9534,0.2972},
{0.953167,0.29581},
{0.9522,0.2982},
{0.9417,0.2972},
{0.9515,0.2996},
{0.9416,0.3025},
{0.9515,0.3026},
{0.956495,0.297195},
{0.934537,0.189083},
{0.934551,0.185136},
{0.968025,0.1883},
{0.96805,0.190795},
{0.97,0.189255},
{0.97,0.186055},
{0.968049,0.185064},
{0.934611,0.180286},
{0.932131,0.181981},
{0.9326,0.185745},
{0.9326,0.188945},
{0.9326,0.1915},
{0.9346,0.19145},
{0.968043,0.180458},
{0.968,0.176524},
{0.9346,0.176276},
{0.9327,0.176951},
{0.93198,0.1804},
{0.97,0.1915},
{0.9325,0.1709},
{0.932588,0.1693},
{0.93465,0.169976},
{0.9327,0.173145},
{0.934629,0.173176},
{0.96795,0.169889},
{0.968,0.173424},
{0.9701,0.1709},
{0.970013,0.1693},
{0.9699,0.173455},
{0.9699,0.176555},
{0.970425,0.180308},
{0.970459,0.181981},
{0.89798,0.2854},
{0.898306,0.287712},
{0.890522,0.2858},
{0.89518,0.282462},
{0.891484,0.283416},
{0.890887,0.288987},
{0.895955,0.291242},
{0.892695,0.291137},
{0.974724,0.294356},
{0.977885,0.293521},
{0.9734,0.296512},
{0.980864,0.296872},
{0.9734,0.299778},
{0.98086,0.299503},
{0.978214,0.302761},
{0.974976,0.302157},
{0.9568,0.2447},
{0.9514,0.2447},
{0.9514,0.2343},
{0.9568,0.2343},
{0.968264,0.2446},
{0.968367,0.2343},
{0.971041,0.2446},
{0.971362,0.2343},
{0.9737,0.2446},
{0.9737,0.2343},
{0.9753,0.2447},
{0.9753,0.2343},
{0.9784,0.2447},
{0.9784,0.2343},
{0.874,0.3098},
{0.8641,0.3098},
{0.8641,0.3044},
{0.874,0.3067},
{0.875564,0.303},
{0.8747,0.3053},
{0.8759,0.3043},
{0.878195,0.303727},
{0.8774,0.304},
{0.8789,0.3043},
{0.880203,0.305299},
{0.9158,0.3004},
{0.917295,0.300105},
{0.913967,0.30149},
{0.9142,0.3001},
{0.913,0.2991},
{0.9025,0.3},
{0.9123,0.2977},
{0.9025,0.2947},
{0.9123,0.2947},
{0.98572,0.145269},
{0.952301,0.145364},
{0.985655,0.140386},
{0.9876,0.144305},
{0.9876,0.141145},
{0.987713,0.1389},
{0.98565,0.13735},
{0.95225,0.138402},
{0.952237,0.141466},
{0.9503,0.141595},
{0.95036,0.144755},
{0.949831,0.148519},
{0.952358,0.150246},
{0.985763,0.149183},
{0.988187,0.148319},
{0.950188,0.1391},
{0.9501,0.1375},
{0.98832,0.1373},
{0.95235,0.157366},
{0.9524,0.15965},
{0.9504,0.157455},
{0.9504,0.153549},
{0.95235,0.154224},
{0.94968,0.15018},
{0.9504,0.1597},
{0.9877,0.156945},
{0.9877,0.1595},
{0.98575,0.158576},
{0.98575,0.155376},
{0.9877,0.153745},
{0.98575,0.152234},
{0.987846,0.150045},
{0.97382,0.2842},
{0.981267,0.284516},
{0.980911,0.287422},
{0.973413,0.286888},
{0.977485,0.290419},
{0.974484,0.289124},
{0.890522,0.275578},
{0.890887,0.272312},
{0.898306,0.273652},
{0.895955,0.270058},
{0.892695,0.270263},
{0.89798,0.27598},
{0.89518,0.278838},
{0.891484,0.277884},
{0.975695,0.281463},
{0.978955,0.281258},
{0.8304,0.2385},
{0.8304,0.2345},
{0.8541,0.2343},
{0.8541,0.2384},
{0.988,0.1693},
{0.9921,0.1693},
{0.987874,0.183526},
{0.9972,0.1997},
{0.9877,0.1994},
{0.9832,0.1994},
{0.9737,0.1997},
{0.983069,0.183569},
{0.9788,0.1693},
{0.9829,0.1693},
{0.878281,0.285881},
{0.8876,0.2697},
{0.8825,0.3001},
{0.8784,0.3001},
{0.8234,0.2507},
{0.8612,0.2506},
{0.9465,0.1373},
{0.9313,0.1641},
{0.9077,0.1641},
{0.8924,0.1373},
{0.8781,0.27},
{0.8641,0.2697},
{0.8736,0.27},
{0.873376,0.285924},
{0.8692,0.3001},
{0.8733,0.3001},
{0.9464,0.2364},
{0.9464,0.2476},
{0.9046,0.2476},
{0.9046,0.234825},
{0.9025,0.2476},
{0.8879,0.166},
{0.8258,0.1664},
{0.827887,0.163696},
{0.8251,0.1377},
{0.827216,0.140157},
{0.8872,0.1373},
{0.884935,0.140071},
{0.885549,0.163183},
{0.9264,0.1941},
{0.8759,0.1939},
{0.8759,0.1915},
{0.9264,0.1917},
{0.8802,0.1872},
{0.8803,0.176},
{0.876,0.1717},
{0.9265,0.1719},
{0.9221,0.1762},
{0.9221,0.1874},
{0.9464,0.2343},
{0.9485,0.2364},
{0.9485,0.2476},
{0.9288,0.1917},
{0.9289,0.1719},
{0.8306,0.268},
{0.8542,0.2679},
{0.8542,0.2719},
{0.8306,0.2721},
{0.942222,0.262958},
{0.957201,0.2639},
{0.956968,0.2685},
{0.942136,0.269303},
{0.8235,0.2559},
{0.8612,0.2557},
{0.8234,0.2047},
{0.8775,0.2047},
{0.8623,0.2314},
{0.8387,0.2314},
{0.9265,0.1695},
{0.876,0.1693},
{0.8735,0.1915},
{0.8736,0.1717},
{0.9046,0.2497},
{0.9464,0.2497},
{0.996964,0.234485},
{0.99716,0.2409},
{0.9829,0.24065},
{0.98215,0.23485},
{0.8804,0.2206},
{0.88828,0.2206},
{0.88742,0.2277},
{0.897814,0.2277},
{0.898577,0.2206},
{0.905332,0.2277},
{0.909,0.2206},
{0.912659,0.2277},
{0.919312,0.2206},
{0.921516,0.2277},
{0.929721,0.2206},
{0.929031,0.2277},
{0.936619,0.2277},
{0.9367,0.2206},
{0.8804,0.2277},
{0.9569,0.1944},
{0.9676,0.1944},
{0.9677,0.2015},
{0.9425,0.1945},
{0.9318,0.2017},
{0.9318,0.1945},
{0.9025,0.2918},
{0.904107,0.284993},
{0.913332,0.291752},
{0.913367,0.278599},
{0.910449,0.276919},
{0.913375,0.27585},
{0.917391,0.273995},
{0.924601,0.274253},
{0.927767,0.275833},
{0.932477,0.278286},
{0.927749,0.278604},
{0.936992,0.284249},
{0.92782,0.29172},
{0.938695,0.291719},
{0.9396,0.2277},
{0.9396,0.2206},
{0.946598,0.2206},
{0.947452,0.2277},
{0.957014,0.2206},
{0.957777,0.2277},
{0.964532,0.2206},
{0.968178,0.2277},
{0.971817,0.2206},
{0.978512,0.2277},
{0.980687,0.2206},
{0.988901,0.2277},
{0.988231,0.2206},
{0.995819,0.2206},
{0.9959,0.2277},
{0.9775,0.2527},
{0.9775,0.2598},
{0.9668,0.2598},
{0.9524,0.2598},
{0.9416,0.2527},
{0.9416,0.2599},
{0.9025,0.2527},
{0.913332,0.252732},
{0.904107,0.259407},
{0.913367,0.265801},
{0.92782,0.252754},
{0.927749,0.265796},
{0.936992,0.260151},
{0.938695,0.252779},
{0.932477,0.266156},
{0.924601,0.270218},
{0.927767,0.268567},
{0.913375,0.26855},
{0.917391,0.270505},
{0.910449,0.26751},
{0.513787,0.0234},
{0.498887,0.0234},
{0.508073,0.0088},
{0.484993,0.0088},
{0.483545,0.0234},
{0.464576,0.0234},
{0.460146,0.0088},
{0.446246,0.0234},
{0.438275,0.0088},
{0.430525,0.0234},
{0.422554,0.0088},
{0.407138,0.0234},
{0.404482,0.0088},
{0.3448,0.0234},
{0.3448,0.0088},
{0.5676,0.0088},
{0.5675,0.0234},
{0.1042,0.2621},
{0.0935,0.2786},
{0.031525,0.276052},
{0.1039,0.2158},
{0.039287,0.200064},
{0.025303,0.204704},
{0.013483,0.214229},
{0.005853,0.231237},
{0.005784,0.249236},
{0.012778,0.263135},
{0.2743,0.0796},
{0.2965,0.0788},
{0.2969,0.0913},
{0.2747,0.092},
{0.2045,0.2153},
{0.2047,0.2615},
{0.2291,0.3428},
{0.2513,0.3421},
{0.2517,0.3546},
{0.2295,0.3553},
{0.1041,0.303172},
{0.2046,0.3037},
{0.1041,0.350175},
{0.054406,0.329039},
{0.0932,0.3664},
{0.04965,0.335502},
{0.040268,0.336487},
{0.03397,0.364665},
{0.014929,0.352793},
{0.034291,0.331069},
{0.005196,0.330731},
{0.0343,0.323024},
{0.008629,0.309615},
{0.01793,0.297116},
{0.04051,0.316842},
{0.033744,0.28909},
{0.04785,0.316862},
{0.0932,0.2872},
{0.053256,0.321741},
{0.2046,0.3499},
{0.1096,0.351},
{0.2046,0.3644},
{0.1096,0.3634},
{0.1041,0.364088},
{0.114532,0.070918},
{0.106531,0.070928},
{0.101082,0.064932},
{0.102068,0.055563},
{0.119247,0.05538},
{0.110239,0.050773},
{0.120751,0.06467},
{0.405996,0.0439},
{0.397616,0.0439},
{0.405504,0.0341},
{0.414516,0.0439},
{0.414004,0.0341},
{0.422484,0.0341},
{0.424697,0.0439},
{0.431732,0.0341},
{0.434816,0.0439},
{0.439075,0.0341},
{0.4405,0.0439},
{0.37811,0.0439},
{0.373498,0.0341},
{0.379278,0.0341},
{0.386905,0.0341},
{0.388248,0.0439},
{0.395384,0.0341},
{0.093,0.1994},
{0.1041,0.289434},
{0.2046,0.2891},
{0.1096,0.2901},
{0.1096,0.3026},
{0.2932,0.0991},
{0.2751,0.1036},
{0.2973,0.1029},
{0.2627,0.08},
{0.2632,0.0924},
{0.2739,0.068},
{0.2923,0.0713},
{0.2961,0.0673},
{0.3085,0.0909},
{0.3081,0.0785},
{0.2175,0.3432},
{0.2179,0.3557},
{0.2287,0.3312},
{0.2471,0.3345},
{0.2509,0.3305},
{0.2632,0.3542},
{0.2628,0.3417},
{0.2521,0.3661},
{0.248,0.3624},
{0.2299,0.3669},
{0.639514,0.059},
{0.646461,0.059},
{0.643867,0.064},
{0.650786,0.064},
{0.653214,0.059},
{0.657567,0.064},
{0.65809,0.059},
{0.6608,0.059},
{0.632269,0.064},
{0.6295,0.064},
{0.632761,0.059},
{0.637086,0.064},
{0.673805,0.16787},
{0.672667,0.168539},
{0.674911,0.164026},
{0.677877,0.169141},
{0.673832,0.169101},
{0.674431,0.173362},
{0.670027,0.172112},
{0.669293,0.166241},
{0.673304,0.168543},
{0.616661,0.068},
{0.623452,0.068},
{0.620986,0.0729},
{0.627798,0.0729},
{0.62829,0.068},
{0.634261,0.068},
{0.634686,0.0729},
{0.6389,0.0729},
{0.6389,0.068},
{0.609776,0.068},
{0.610198,0.0729},
{0.616169,0.0729},
{0.638626,0.164752},
{0.643782,0.161823},
{0.642652,0.165818},
{0.642687,0.167076},
{0.643192,0.166371},
{0.643818,0.166383},
{0.648048,0.166123},
{0.644366,0.170864},
{0.639154,0.169312},
{0.3916,0.1586},
{0.3918,0.1683},
{0.3761,0.1687},
{0.3759,0.1589},
{0.3909,0.1292},
{0.3912,0.139},
{0.3754,0.1394},
{0.3752,0.1296},
{0.3914,0.1488},
{0.3757,0.1491},
{0.6759,0.1426},
{0.6672,0.1426},
{0.6672,0.1397},
{0.6759,0.1397},
{0.6647,0.1395},
{0.6656,0.1319},
{0.668,0.1322},
{0.668,0.1299},
{0.6751,0.1299},
{0.6751,0.1322},
{0.6776,0.1319},
{0.6784,0.1395},
{0.671464,0.1378},
{0.669836,0.13595},
{0.671622,0.134209},
{0.673262,0.135971},
{0.5692,0.1426},
{0.5692,0.1667},
{0.542291,0.143385},
{0.5689,0.1341},
{0.542423,0.134962},
{0.4358,0.1435},
{0.4358,0.1662},
{0.542525,0.166038},
{0.542177,0.174418},
{0.4161,0.1781},
{0.413127,0.165492},
{0.4288,0.1625},
{0.414428,0.156573},
{0.4289,0.1474},
{0.413519,0.144607},
{0.416,0.1316},
{0.569,0.1752},
{0.399721,0.164542},
{0.400053,0.152977},
{0.399903,0.144486},
{0.639611,0.0535},
{0.633788,0.0535},
{0.634759,0.0504},
{0.640901,0.0504},
{0.64389,0.0535},
{0.64511,0.0504},
{0.649195,0.0535},
{0.648893,0.0504},
{0.654381,0.0535},
{0.654712,0.0504},
{0.658087,0.0504},
{0.65869,0.0535},
{0.617267,0.0773},
{0.623757,0.0773},
{0.617959,0.082},
{0.609977,0.082},
{0.61095,0.0773},
{0.60698,0.0773},
{0.623938,0.082},
{0.6434,0.07965},
{0.647511,0.0451},
{0.641212,0.0451},
{0.646707,0.0404},
{0.6669,0.0404},
{0.6669,0.0451},
{0.640973,0.0404},
{0.63645,0.0451},
{0.633201,0.0404},
{0.63191,0.0451},
{0.579279,0.033708},
{0.576299,0.028753},
{0.5987,0.0291},
{0.5987,0.0338},
{0.582211,0.03775},
{0.580377,0.041927},
{0.5987,0.042},
{0.58119,0.050313},
{0.57962,0.045771},
{0.5979,0.0457},
{0.577868,0.054234},
{0.5979,0.0562},
{0.575728,0.058888},
{0.598,0.0668},
{0.57788,0.067235},
{0.57343,0.064765},
{0.574417,0.022617},
{0.579387,0.020653},
{0.5987,0.0209},
{0.63709,0.0279},
{0.64124,0.0279},
{0.640024,0.031},
{0.647777,0.031},
{0.646788,0.0279},
{0.652212,0.0279},
{0.654456,0.031},
{0.65639,0.0279},
{0.65907,0.031},
{0.659331,0.0279},
{0.63605,0.031},
{0.634336,0.0279},
{0.6333,0.031},
{0.6899,0.0358},
{0.693618,0.0358},
{0.692584,0.0405},
{0.699493,0.040485},
{0.698217,0.0358},
{0.70245,0.035741},
{0.706538,0.0404},
{0.70663,0.0357},
{0.728,0.0403},
{0.69385,0.0483},
{0.689894,0.0483},
{0.692898,0.0436},
{0.6716,0.0437},
{0.699937,0.0435},
{0.698067,0.0482},
{0.70387,0.0482},
{0.706592,0.0435},
{0.709022,0.0482},
{0.72785,0.04575},
{0.7279,0.0356},
{0.588631,0.10045},
{0.5705,0.1013},
{0.5705,0.0931},
{0.587289,0.095687},
{0.58999,0.093056},
{0.6717,0.03825},
{0.6716,0.0484},
{0.588381,0.088944},
{0.5708,0.0901},
{0.5708,0.082},
{0.589201,0.082367},
{0.594791,0.074806},
{0.591326,0.079597},
{0.59072,0.070793},
{0.57,0.0793},
{0.57,0.0711},
{0.596908,0.006222},
{0.60057,0.010522},
{0.596965,0.015125},
{0.5758,0.0148},
{0.5758,0.0066},
{0.403367,0.421844},
{0.476887,0.422864},
{0.476644,0.42699},
{0.403088,0.423606},
{0.390081,0.423459},
{0.403566,0.414963},
{0.4771,0.4157},
{0.477081,0.418117},
{0.403925,0.417177},
{0.403389,0.419087},
{0.389918,0.421675},
{0.38419,0.422911},
{0.384333,0.420073},
{0.371072,0.421385},
{0.37105,0.423},
{0.361329,0.421073},
{0.371043,0.419054},
{0.361626,0.417612},
{0.357142,0.418998},
{0.35696,0.42102},
{0.38475,0.41275},
{0.390481,0.41441},
{0.384672,0.414866},
{0.371588,0.413013},
{0.371314,0.41597},
{0.384408,0.417535},
{0.390312,0.416986},
{0.39022,0.41904},
{0.361727,0.414051},
{0.357313,0.416011},
{0.36175,0.4114},
{0.357484,0.412491},
{0.595941,0.117261},
{0.596328,0.122075},
{0.589,0.122134},
{0.588838,0.117338},
{0.597066,0.117814},
{0.606424,0.120877},
{0.6068,0.1184},
{0.623237,0.123452},
{0.623058,0.120927},
{0.6244,0.122206},
{0.624965,0.124788},
{0.625681,0.122257},
{0.624891,0.119232},
{0.636363,0.119493},
{0.636418,0.12382},
{0.625668,0.127126},
{0.636381,0.127721},
{0.625525,0.130113},
{0.6363,0.130505},
{0.6365,0.1321},
{0.624731,0.131433},
{0.624385,0.127937},
{0.638036,0.121068},
{0.6381,0.125232},
{0.637998,0.129079},
{0.6381,0.131},
{0.640359,0.120127},
{0.640373,0.123445},
{0.640381,0.126908},
{0.640291,0.129569},
{0.60847,0.12442},
{0.608341,0.121192},
{0.6127,0.12384},
{0.613189,0.126071},
{0.613025,0.121775},
{0.613119,0.120154},
{0.622541,0.120262},
{0.6064,0.125186},
{0.596435,0.126414},
{0.606546,0.129556},
{0.596467,0.130518},
{0.597319,0.133296},
{0.596141,0.133427},
{0.589081,0.130123},
{0.588981,0.133473},
{0.608338,0.128756},
{0.6088,0.126691},
{0.613095,0.12924},
{0.622888,0.12928},
{0.623023,0.126528},
{0.583032,0.125876},
{0.583073,0.121703},
{0.5874,0.125511},
{0.587461,0.130156},
{0.583095,0.130671},
{0.5873,0.133},
{0.587331,0.119905},
{0.582959,0.118816},
{0.589,0.126301},
{0.6229,0.1304},
{0.608412,0.130426},
{0.687826,0.0231},
{0.693813,0.0231},
{0.691615,0.0325},
{0.699252,0.0231},
{0.701927,0.0325},
{0.704902,0.0231},
{0.708849,0.0325},
{0.70929,0.0231},
{0.716533,0.0325},
{0.716914,0.0231},
{0.724286,0.0325},
{0.724029,0.0231},
{0.731966,0.0325},
{0.730216,0.0231},
{0.737089,0.0231},
{0.738999,0.0325},
{0.682173,0.0325},
{0.680434,0.0231},
{0.673914,0.0325},
{0.674913,0.0231},
{0.6713,0.0231},
{0.753625,0.005726},
{0.760975,0.006113},
{0.766736,0.010837},
{0.747342,0.019448},
{0.767495,0.018182},
{0.753281,0.026019},
{0.76148,0.025598},
{0.748374,0.009876},
{0.753295,0.06829},
{0.762095,0.062487},
{0.7518,0.072751},
{0.751273,0.068695},
{0.744282,0.068445},
{0.744385,0.073944},
{0.733261,0.084095},
{0.729439,0.082772},
{0.729461,0.080752},
{0.724705,0.078754},
{0.723997,0.075418},
{0.720725,0.072541},
{0.721428,0.069345},
{0.719293,0.067354},
{0.684485,0.134351},
{0.689049,0.131464},
{0.685762,0.135274},
{0.69167,0.132363},
{0.695848,0.129675},
{0.698423,0.131395},
{0.6972,0.1541},
{0.696755,0.15617},
{0.695813,0.154316},
{0.69351,0.158343},
{0.694002,0.160451},
{0.6908,0.1615},
{0.622341,0.166016},
{0.617385,0.16807},
{0.618476,0.165974},
{0.611785,0.169115},
{0.609807,0.167251},
{0.608561,0.168739},
{0.7341,0.0829},
{0.724003,0.072957},
{0.729527,0.079617},
{0.73428,0.081695},
{0.722327,0.066688},
{0.68557,0.13693},
{0.699477,0.132781},
{0.693386,0.132902},
{0.693937,0.136771},
{0.696374,0.139184},
{0.68819,0.139648},
{0.688383,0.143145},
{0.690298,0.160257},
{0.69484,0.153193},
{0.691145,0.152093},
{0.687508,0.157555},
{0.683972,0.156796},
{0.689062,0.149232},
{0.615112,0.16582},
{0.621354,0.163226},
{0.60686,0.165453},
{0.610729,0.162124},
{0.606946,0.158627},
{0.611008,0.158731},
{0.614791,0.159011},
{0.616298,0.158926},
{0.733869,0.074093},
{0.729687,0.074234},
{0.729272,0.068195},
{0.727397,0.071095},
{0.757439,0.055465},
{0.76284,0.055365},
{0.757984,0.062787},
{0.762861,0.086432},
{0.75746,0.086532},
{0.758267,0.079558},
{0.762316,0.079047},
{0.757905,0.078002},
{0.754732,0.075798},
{0.734748,0.075596},
{0.768401,0.073125},
{0.768299,0.068673},
{0.775944,0.068059},
{0.775956,0.073683},
{0.050155,0.09043},
{0.108,0.0869},
{0.1084,0.0939},
{0.049515,0.097888},
{0.026048,0.101572},
{0.034094,0.104086},
{0.023378,0.114653},
{0.01285,0.117864},
{0.01678,0.127718},
{0.009,0.1275},
{0.114,0.0892},
{0.1269,0.1048},
{0.1212,0.1095},
{0.053146,0.152079},
{0.045956,0.150618},
{0.051852,0.147397},
{0.04701,0.145581},
{0.040586,0.145632},
{0.044026,0.1425},
{0.0439,0.1349},
{0.046991,0.130488},
{0.048331,0.137008},
{0.051754,0.133285},
{0.053025,0.126376},
{0.056482,0.13121},
{0.061632,0.125737},
{0.063046,0.131194},
{0.0568,0.1513},
{0.056414,0.147198},
{0.051204,0.186549},
{0.035527,0.183097},
{0.046495,0.178597},
{0.027372,0.170215},
{0.021494,0.174965},
{0.010072,0.15896},
{0.014926,0.153186},
{0.074798,0.17728},
{0.1048,0.1915},
{0.1058,0.1842},
{0.1201,0.1682},
{0.1259,0.1734},
{0.1115,0.1894},
{0.998526,0.0016},
{0.998637,0.0016},
{0.998682,0.0018},
{0.9986,0.0018},
{0.998441,0.0017},
{0.9984,0.001812},
{0.9986,0.001876},
{0.9984,0.001959},
{0.9986,0.0019},
{0.998481,0.002053},
{0.998669,0.0019},
{0.9986,0.00217},
{0.9987,0.0019},
{0.0535,0.1093},
{0.0543,0.0988},
{0.099,0.0968},
{0.1,0.1083},
{0.0777,0.1134},
{0.999,0.0016},
{0.9991,0.0017},
{0.9988,0.0017},
{0.9987,0.0018},
{0.0735,0.1614},
{0.0553,0.1632},
{0.0677,0.1654},
{0.075,0.1652},
{0.0865,0.1669},
{0.0855,0.1782},
{0.0596,0.1464},
{0.0759,0.1543},
{0.0803,0.1198},
{0.067,0.1299},
{0.1218,0.1165},
{0.1212,0.1605},
{0.3546,0.0435},
{0.3546,0.0537},
{0.3443,0.0537},
{0.3443,0.0435},
{0.3443,0.0388},
{0.3546,0.0388},
{0.3593,0.0435},
{0.3593,0.0537},
{0.3546,0.0584},
{0.3443,0.0584},
{0.3396,0.0537},
{0.3396,0.0435},
{0.0676,0.1768},
{0.0578,0.1754},
{0.2835,0.3018},
{0.2732,0.3018},
{0.2732,0.2916},
{0.2835,0.2916},
{0.2882,0.2916},
{0.2882,0.3018},
{0.2835,0.3065},
{0.2732,0.3065},
{0.2685,0.3018},
{0.2685,0.2916},
{0.2732,0.2869},
{0.2835,0.2869},
{0.9988,0.002},
{0.3496,0.2773},
{0.3495,0.2881},
{0.3038,0.2878},
{0.3039,0.277},
{0.356,0.2773},
{0.3559,0.2882},
{0.304,0.2706},
{0.3496,0.2709},
{0.3038,0.2942},
{0.3495,0.2945},
{0.2975,0.2878},
{0.2976,0.2769},
{0.9991,0.002},
{0.999,0.0021},
{0.2467,0.27},
{0.2467,0.2771},
{0.2228,0.2771},
{0.2228,0.27},
{0.3328,0.2439},
{0.31775,0.250976},
{0.299332,0.252443},
{0.315069,0.259451},
{0.336051,0.25075},
{0.3816,0.1038},
{0.36645,0.110854},
{0.347931,0.112201},
{0.363728,0.119374},
{0.384846,0.11075},
{0.215923,0.210175},
{0.214478,0.209858},
{0.2153,0.1842},
{0.2707,0.1842},
{0.271074,0.209876},
{0.254071,0.21665},
{0.236378,0.217753},
{0.231737,0.217531},
{0.249792,0.218653},
{0.263302,0.214823},
{0.2978,0.1611},
{0.2907,0.161},
{0.28988,0.149292},
{0.3049,0.1612},
{0.312,0.1613},
{0.3008,0.1358},
{0.2917,0.1356},
{0.289,0.1114},
{0.278142,0.1113},
{0.273062,0.136981},
{0.260812,0.1112},
{0.258726,0.133922},
{0.247323,0.137391},
{0.243458,0.1113},
{0.231618,0.149275},
{0.2326,0.1113},
{0.2299,0.1357},
{0.2208,0.1358},
{0.2096,0.1613},
{0.2167,0.1612},
{0.2238,0.1611},
{0.2309,0.161},
{0.352135,0.078278},
{0.329166,0.104178},
{0.341841,0.117912},
{0.382229,0.091081},
{0.365374,0.08016},
{0.352642,0.068285},
{0.33985,0.073428},
{0.341951,0.081333},
{0.32797,0.091185},
{0.280409,0.244673},
{0.2791,0.1947},
{0.293359,0.258248},
{0.368898,0.072812},
{0.3326,0.194},
{0.288848,0.179938},
{0.2883,0.1559},
{0.2893,0.1553},
{0.281219,0.151217},
{0.261682,0.148268},
{0.268296,0.147401},
{0.25056,0.148504},
{0.244773,0.151231},
{0.234424,0.155532},
{0.2297,0.1268},
{0.2207,0.1269},
{0.2089,0.1116},
{0.31176,0.31806},
{0.3038,0.31},
{0.3165,0.31},
{0.3187,0.3122},
{0.311867,0.302133},
{0.3188,0.3078},
{0.30824,0.31806},
{0.3016,0.3121},
{0.3017,0.3077},
{0.325,0.1105},
{0.2766,0.2512},
{0.1848,0.2771},
{0.1848,0.27},
{0.2082,0.2349},
{0.223066,0.242419},
{0.24227,0.243856},
{0.260998,0.235162},
{0.2848,0.27},
{0.2848,0.2771},
{0.2614,0.3123},
{0.246464,0.304752},
{0.22723,0.303344},
{0.208602,0.312032},
{0.2919,0.1269},
{0.3009,0.127},
{0.3127,0.1117},
{0.280733,0.3243},
{0.2889,0.3164},
{0.2885,0.329},
{0.2861,0.3314},
{0.29692,0.3247},
{0.2909,0.3315},
{0.2914,0.314},
{0.297,0.32078},
{0.2865,0.3139},
{0.9982,0.0025},
{0.9977,0.0025},
{0.9977,0.0023},
{0.9982,0.0023},
{0.620676,0.1066},
{0.6009,0.1068},
{0.620384,0.0891},
{0.625049,0.089},
{0.625736,0.106535},
{0.6295,0.089},
{0.6297,0.1065},
{0.6324,0.089},
{0.6325,0.1065},
{0.6376,0.0889},
{0.6378,0.1065},
{0.6008,0.0892},
{0.6903,0.0972},
{0.6903,0.1023},
{0.6735,0.1063},
{0.692902,0.108682},
{0.6914,0.1047},
{0.6935,0.1064},
{0.697409,0.107492},
{0.6961,0.107},
{0.6987,0.1064},
{0.700804,0.104704},
{0.6735,0.0972},
{0.7058,0.1135},
{0.7032,0.1141},
{0.702776,0.11172},
{0.7011,0.1157},
{0.6832,0.1142},
{0.7,0.1181},
{0.6832,0.1233},
{0.7,0.1233},
{0.708392,0.114092},
{0.9977,0.0019},
{0.9982,0.0019},
{0.501074,0.210521},
{0.501192,0.206458},
{0.557908,0.2092},
{0.55795,0.2148},
{0.5613,0.21077},
{0.5613,0.2064},
{0.55795,0.206442},
{0.5011,0.21567},
{0.49705,0.2146},
{0.497467,0.2172},
{0.4978,0.220989},
{0.5011,0.221042},
{0.55795,0.221459},
{0.5622,0.2172},
{0.561388,0.2146},
{0.557935,0.241359},
{0.501116,0.241475},
{0.501116,0.233176},
{0.497264,0.236064},
{0.4978,0.242588},
{0.557965,0.233463},
{0.55795,0.226858},
{0.5011,0.226441},
{0.4978,0.227579},
{0.4966,0.2334},
{0.4978,0.210228},
{0.4978,0.2064},
{0.56126,0.221512},
{0.5613,0.226911},
{0.561663,0.233331},
{0.562128,0.236137},
{0.5613,0.243111},
{0.65626,0.14108},
{0.656707,0.145394},
{0.643444,0.141756},
{0.651438,0.136185},
{0.645147,0.137853},
{0.644,0.1467},
{0.647193,0.150855},
{0.652772,0.151203},
{0.731928,0.049074},
{0.73727,0.047642},
{0.7297,0.0527},
{0.742434,0.053347},
{0.7297,0.057533},
{0.742467,0.058172},
{0.732373,0.062274},
{0.737831,0.063282},
{0.6779,0.0812},
{0.6741,0.0897},
{0.6631,0.0849},
{0.664984,0.075424},
{0.656482,0.081676},
{0.6531,0.0832},
{0.6492,0.092},
{0.6579,0.0965},
{0.646235,0.090866},
{0.6349,0.0361},
{0.6349,0.0342},
{0.6491,0.035767},
{0.6428,0.0189},
{0.6321,0.0186},
{0.6321,0.0166},
{0.6429,0.0169},
{0.6644,0.0606},
{0.6645,0.0586},
{0.67785,0.0603},
{0.6906,0.06},
{0.6905,0.0619},
{0.702533,0.061867},
{0.7122,0.0771},
{0.716,0.0857},
{0.703083,0.091374},
{0.7012,0.082},
{0.697054,0.08567},
{0.688602,0.084893},
{0.6912,0.0837},
{0.6859,0.07545},
{0.696,0.0704},
{0.6838,0.0758},
{0.6882,0.0857},
{0.649433,0.019087},
{0.6465,0.017},
{0.652073,0.017159},
{0.660473,0.019399},
{0.660569,0.017399},
{0.6437,0.0119},
{0.6421,0.01},
{0.6533,0.010986},
{0.6406,0.0119},
{0.631,0.012},
{0.631,0.0101},
{0.6279,0.011186},
{0.650218,0.081476},
{0.6732,0.1163},
{0.660285,0.122076},
{0.6584,0.1126},
{0.651857,0.115824},
{0.6485,0.1143},
{0.645518,0.116024},
{0.6694,0.1078},
{0.6533,0.101},
{0.6445,0.1055},
{0.641535,0.106634},
{0.720967,0.054767},
{0.706769,0.055398},
{0.706872,0.053498},
{0.698273,0.055018},
{0.695832,0.052948},
{0.6927,0.0548},
{0.6891,0.0546},
{0.6892,0.0527},
{0.6783,0.0541},
{0.6784,0.0522},
{0.665,0.05255},
{0.6321,0.0048},
{0.6448,0.0038},
{0.6448,0.0058},
{0.6569,0.004533},
{0.736,0.1044},
{0.725,0.0995},
{0.726883,0.090126},
{0.720895,0.095889},
{0.712405,0.096607},
{0.7151,0.0979},
{0.70975,0.1061},
{0.7199,0.1112},
{0.7076,0.1057},
{0.712,0.0959},
{0.7398,0.0959},
{0.649643,0.022757},
{0.63845,0.02395},
{0.64,0.022},
{0.6369,0.022},
{0.6273,0.024},
{0.6273,0.0221},
{0.6527,0.0219},
{0.6527,0.0238},
{0.1966,0.18},
{0.1371,0.18},
{0.1371,0.1692},
{0.1966,0.1692},
{0.085511,0.015468},
{0.0844,0.0557},
{0.073142,0.032473},
{0.0735,0.0558},
{0.072832,0.006168},
{0.093842,0.007657},
{0.023341,0.005341},
{0.023294,0.031557},
{0.0122,0.055},
{0.023,0.055},
{0.010862,0.01499},
{0.006561,0.009182},
{0.002,0.00726},
{0.32972,0.005572},
{0.328809,0.010991},
{0.22228,0.005615},
{0.226168,0.017724},
{0.325886,0.017941},
{0.3058,0.0528},
{0.2463,0.0528},
{0.193459,0.19466},
{0.169304,0.196149},
{0.169534,0.185726},
{0.195075,0.1872},
{0.1921,0.2016},
{0.1921,0.2082},
{0.1326,0.2085},
{0.1325,0.2018},
{0.0651,0.0558},
{0.0585,0.0559},
{0.065143,0.032457},
{0.0497,0.0061},
{0.0652,0.0064},
{0.031276,0.031676},
{0.0465,0.0051},
{0.0381,0.055},
{0.0314,0.055},
{0.156459,0.1867},
{0.157646,0.195794},
{0.132359,0.195609},
{0.131829,0.1866},
{0.1896,0.1125},
{0.2012,0.1326},
{0.1185,0.1326},
{0.1301,0.1125},
{0.2012,0.141},
{0.1185,0.141},
{0.1896,0.161},
{0.1301,0.161},
{0.2152,0.0051},
{0.1902,0.0491},
{0.1307,0.0491},
{0.1057,0.0051},
{0.031,0.0056},
{0.148,0.0677},
{0.2392,0.0677},
{0.2395,0.092},
{0.1478,0.092},
{0.2189,0.3928},
{0.2,0.3868},
{0.219487,0.386941},
{0.182291,0.375531},
{0.1788,0.3802},
{0.1915,0.4056},
{0.3017,0.3937},
{0.301069,0.399559},
{0.338309,0.410969},
{0.3228,0.4004},
{0.3417,0.4063},
{0.194144,0.411207},
{0.3006,0.4047},
{0.1957,0.4161},
{0.329,0.3809},
{0.326404,0.375293},
{0.22,0.3819},
{0.3248,0.3704},
{0.1845,0.3713},
{0.336,0.4152},
{0.1376,0.1013},
{0.1385,0.0583},
{0.1462,0.0661},
{0.2411,0.0661},
{0.2487,0.0583},
{0.2415,0.0936},
{0.2497,0.1013},
{0.1457,0.0936},
{0.3985,0.1871},
{0.385696,0.1871},
{0.387104,0.1754},
{0.36999,0.1754},
{0.368759,0.1871},
{0.357627,0.1754},
{0.351627,0.1871},
{0.345655,0.1754},
{0.334675,0.1871},
{0.331056,0.1754},
{0.317575,0.1871},
{0.31869,0.1754},
{0.306233,0.1754},
{0.3061,0.1871},
{0.3985,0.1754},
{0.358,0.2034},
{0.3404,0.2034},
{0.3403,0.1917},
{0.3817,0.2033},
{0.3993,0.1915},
{0.3993,0.2032},
{0.4002,0.2087},
{0.397504,0.21983},
{0.382252,0.208763},
{0.382222,0.230362},
{0.387058,0.233139},
{0.3822,0.2349},
{0.375686,0.238029},
{0.363813,0.23757},
{0.358567,0.234933},
{0.350873,0.230881},
{0.358596,0.230358},
{0.343379,0.221054},
{0.358507,0.208807},
{0.340611,0.208833},
{0.594079,0.17498},
{0.594709,0.177456},
{0.591442,0.175627},
{0.59222,0.17414},
{0.594202,0.172948},
{0.596127,0.173806},
{0.5983,0.1757},
{0.5915,0.1782},
{0.624982,0.148683},
{0.626399,0.146133},
{0.627202,0.148798},
{0.625756,0.150095},
{0.628051,0.150722},
{0.629434,0.150224},
{0.630336,0.147652},
{0.627578,0.172898},
{0.626325,0.175747},
{0.625114,0.173201},
{0.62572,0.17184},
{0.627584,0.171698},
{0.6285,0.1704},
{0.629764,0.17145},
{0.630859,0.173967},
{0.60732,0.14292},
{0.610216,0.143689},
{0.608788,0.145684},
{0.610937,0.146965},
{0.61296,0.14512},
{0.606568,0.145503},
{0.607615,0.146944},
{0.609707,0.147598},
{0.4357,0.05255},
{0.4762,0.0542},
{0.429935,0.12479},
{0.426804,0.0507},
{0.422746,0.1248},
{0.416448,0.050768},
{0.41406,0.1249},
{0.406466,0.050825},
{0.405632,0.124957},
{0.3982,0.0547},
{0.3982,0.0509},
{0.483676,0.1244},
{0.476634,0.0503},
{0.488227,0.05024},
{0.490711,0.124348},
{0.500294,0.050168},
{0.499244,0.1243},
{0.507495,0.1242},
{0.5135,0.0501},
{0.5137,0.0539},
{0.5542,0.0536},
{0.5547,0.1239},
{0.4765,0.2094},
{0.4765,0.1871},
{0.480704,0.187129},
{0.480943,0.20934},
{0.491413,0.204816},
{0.491797,0.193079},
{0.4326,0.2094},
{0.4306,0.1871},
{0.4346,0.1871},
{0.506833,0.18168},
{0.561997,0.181929},
{0.561773,0.201127},
{0.566973,0.186707},
{0.567147,0.19528},
{0.506203,0.201071},
{0.501359,0.18622},
{0.500962,0.19493},
{0.60585,0.0511},
{0.612961,0.050611},
{0.6066,0.06075},
{0.606,0.0511},
{0.605821,0.039989},
{0.6061,0.0395},
{0.6066,0.00465},
{0.6121,0.06075},
{0.61785,0.0511},
{0.624961,0.050646},
{0.6186,0.06075},
{0.618,0.0511},
{0.617821,0.040054},
{0.6181,0.0396},
{0.6186,0.00465},
{0.6241,0.06075},
{0.6129,0.0395},
{0.6121,0.00465},
{0.61274,0.0395},
{0.612633,0.0511},
{0.6249,0.0396},
{0.6241,0.00465},
{0.62474,0.0396},
{0.624633,0.0511},
{0.6124,0.0409},
{0.6244,0.0409},
{0.9974,0.0041},
{0.9962,0.004133},
{0.9962,0.00396},
{0.9962,0.0042},
{0.995839,0.004179},
{0.9974,0.004},
{0.9974,0.0038},
{0.9962,0.003833},
{0.9962,0.0036},
{0.9962,0.0038},
{0.9959,0.00384},
{0.9974,0.0036},
{0.9955,0.0041},
{0.9955,0.004},
{0.9958,0.003967},
{0.9959,0.004},
{0.9955,0.0038},
{0.9955,0.0036},
{0.9959,0.0036},
{0.9959,0.0036},
{0.6064,0.0497},
{0.6184,0.0498},
{0.6124,0.0497},
{0.6064,0.0409},
{0.6244,0.0498},
{0.6184,0.0409},
{0.592989,0.164326},
{0.5951,0.164},
{0.594801,0.166516},
{0.591355,0.166697},
{0.59027,0.164177},
{0.5887,0.1664},
{0.704034,0.146936},
{0.705282,0.143996},
{0.705438,0.14636},
{0.705997,0.147687},
{0.708151,0.146355},
{0.709473,0.144115},
{0.591495,0.163266},
{0.593751,0.162677},
{0.590705,0.162099},
{0.708576,0.147937},
{0.7097,0.1471},
{0.674284,0.155012},
{0.670715,0.155188},
{0.673026,0.152742},
{0.670341,0.152518},
{0.668673,0.152354},
{0.6682,0.1549},
{0.658079,0.159158},
{0.662305,0.159291},
{0.660893,0.161775},
{0.662531,0.161938},
{0.660748,0.163772},
{0.658466,0.162871},
{0.658237,0.161545},
{0.672795,0.151419},
{0.6695,0.1508},
{0.422068,0.206795},
{0.418038,0.197786},
{0.422584,0.189392},
{0.563941,0.033724},
{0.562503,0.037576},
{0.559233,0.034028},
{0.558503,0.032455},
{0.554827,0.033292},
{0.555288,0.03557},
{0.56001,0.035879},
{0.5579,0.037967},
{0.561054,0.040005},
{0.557234,0.040054},
{0.5612,0.0414},
{0.556358,0.041136},
{0.552703,0.039705},
{0.548605,0.040863},
{0.542847,0.039834},
{0.542459,0.04123},
{0.535049,0.041026},
{0.539374,0.038614},
{0.53373,0.038875},
{0.528017,0.039506},
{0.531199,0.041512},
{0.521832,0.040562},
{0.521822,0.038849},
{0.514885,0.039383},
{0.519155,0.040874},
{0.513517,0.040348},
{0.512807,0.038096},
{0.520465,0.037083},
{0.512435,0.035614},
{0.515035,0.034586},
{0.51318,0.033048},
{0.522189,0.035392},
{0.520895,0.033394},
{0.514413,0.030871},
{0.554585,0.038022},
{0.543968,0.03766},
{0.534361,0.03688},
{0.529303,0.037885},
{0.523543,0.036912},
{0.548107,0.032943},
{0.542584,0.034502},
{0.547173,0.035448},
{0.546866,0.036962},
{0.542238,0.036229},
{0.533591,0.034613},
{0.528797,0.035169},
{0.528381,0.033159},
{0.521747,0.03242},
{0.531176,0.031827},
{0.537028,0.033134},
{0.535966,0.031708},
{0.543698,0.032667},
{0.50226,0.04182},
{0.498506,0.042438},
{0.496928,0.040863},
{0.492123,0.042433},
{0.48955,0.040524},
{0.482503,0.042531},
{0.483559,0.040183},
{0.475422,0.041662},
{0.471576,0.042978},
{0.46391,0.042098},
{0.462549,0.043246},
{0.449521,0.042032},
{0.449736,0.039443},
{0.462203,0.040758},
{0.467926,0.040586},
{0.449988,0.037205},
{0.464832,0.038242},
{0.464674,0.036623},
{0.450153,0.035395},
{0.46835,0.03569},
{0.463835,0.034139},
{0.450199,0.033701},
{0.502185,0.038782},
{0.495258,0.039212},
{0.492196,0.038159},
{0.482141,0.03761},
{0.474233,0.037627},
{0.476726,0.040154},
{0.495483,0.034389},
{0.499465,0.033155},
{0.500484,0.035594},
{0.495535,0.036238},
{0.486999,0.036795},
{0.487503,0.035299},
{0.480258,0.035981},
{0.489466,0.033909},
{0.480195,0.034},
{0.470723,0.033995},
{0.371987,0.9865},
{0.385821,0.9865},
{0.365933,0.9968},
{0.394372,0.9968},
{0.412071,0.9865},
{0.424908,0.9967},
{0.43756,0.9865},
{0.461295,0.9967},
{0.469242,0.9865},
{0.497349,0.9967},
{0.508883,0.9865},
{0.520364,0.9865},
{0.53374,0.9967},
{0.541061,0.9865},
{0.564803,0.9967},
{0.561762,0.9865},
{0.582465,0.9865},
{0.595841,0.9967},
{0.603164,0.9865},
{0.637014,0.9967},
{0.623862,0.9865},
{0.666667,0.9865},
{0.675967,0.9967},
{0.6799,0.9865},
{0.714535,0.982641},
{0.693878,0.9826},
{0.695674,0.972358},
{0.665172,0.97228},
{0.660761,0.982506},
{0.642135,0.982441},
{0.623797,0.97218},
{0.621438,0.9824},
{0.595236,0.982325},
{0.587424,0.9721},
{0.569734,0.9823},
{0.561217,0.972},
{0.549076,0.982241},
{0.535724,0.972},
{0.50952,0.9822},
{0.504696,0.971938},
{0.497377,0.9822},
{0.463558,0.9719},
{0.462738,0.9821},
{0.428288,0.9821},
{0.416954,0.9718},
{0.414638,0.982041},
{0.376008,0.982},
{0.385372,0.9718},
{0.364716,0.9718},
{0.362878,0.982},
{0.716372,0.9724},
{0.986995,0.54883},
{0.990997,0.575433},
{0.98964,0.569127},
{0.991934,0.597402},
{0.993218,0.615428},
{0.98997,0.608669},
{0.987125,0.652705},
{0.99113,0.640739},
{0.991444,0.646169},
{0.987962,0.663742},
{0.983781,0.683081},
{0.97994,0.685906},
{0.932865,0.456461},
{0.940156,0.468496},
{0.941123,0.473153},
{0.952221,0.492565},
{0.953568,0.497664},
{0.959953,0.520373},
{0.959075,0.531052},
{0.963313,0.552796},
{0.962353,0.565427},
{0.96566,0.590191},
{0.963225,0.604654},
{0.96501,0.616484},
{0.965416,0.630706},
{0.963611,0.642862},
{0.962262,0.662211},
{0.960379,0.658544},
{0.957453,0.687875},
{0.95896,0.691069},
{0.962768,0.539886},
{0.966075,0.571446},
{0.962601,0.67051},
{0.960854,0.686452},
{0.9594,0.697},
{0.976279,0.533666},
{0.977827,0.553885},
{0.974752,0.532883},
{0.977537,0.568164},
{0.977507,0.638548},
{0.975569,0.646203},
{0.977672,0.622319},
{0.979474,0.606558},
{0.978199,0.59696},
{0.974777,0.628298},
{0.971984,0.66363},
{0.973987,0.668192},
{0.972669,0.683957},
{0.970145,0.694834},
{0.967998,0.694298},
{0.965961,0.460006},
{0.972623,0.480466},
{0.973414,0.48797},
{0.977656,0.49934},
{0.981359,0.522164},
{0.985235,0.533764},
{0.975662,0.598025},
{0.984342,0.549464},
{0.978929,0.519577},
{0.972226,0.491026},
{0.964253,0.46185},
{0.975184,0.567797},
{0.972749,0.533047},
{0.945204,0.484711},
{0.932475,0.461048},
{0.817002,0.764627},
{0.818964,0.757558},
{0.824011,0.756357},
{0.823156,0.768692},
{0.828309,0.765965},
{0.828842,0.760276},
{0.915567,0.809178},
{0.909615,0.798472},
{0.920954,0.797219},
{0.925368,0.802694},
{0.927085,0.814289},
{0.931683,0.80289},
{0.940794,0.810651},
{0.936525,0.798833},
{0.947595,0.801836},
{0.93688,0.79216},
{0.948345,0.792234},
{0.942509,0.780893},
{0.931742,0.786905},
{0.929155,0.775424},
{0.923587,0.788737},
{0.911473,0.785372},
{0.918562,0.777874},
{0.671347,0.821206},
{0.66419,0.81999},
{0.666019,0.80847},
{0.674597,0.80974},
{0.683722,0.802676},
{0.67385,0.799214},
{0.666814,0.806582},
{0.646775,0.800095},
{0.645487,0.797798},
{0.628929,0.791777},
{0.681604,0.795403},
{0.688536,0.79416},
{0.696059,0.802127},
{0.698687,0.795303},
{0.71186,0.804599},
{0.703951,0.807503},
{0.70947,0.819233},
{0.716088,0.817925},
{0.71384,0.830596},
{0.704905,0.829507},
{0.698344,0.834419},
{0.701684,0.841178},
{0.691738,0.843824},
{0.688021,0.835812},
{0.679924,0.833572},
{0.68048,0.842306},
{0.668388,0.833347},
{0.807831,0.581896},
{0.803535,0.590565},
{0.793022,0.576358},
{0.805133,0.567516},
{0.789775,0.557055},
{0.772165,0.565769},
{0.778076,0.588863},
{0.796602,0.603981},
{0.773871,0.602447},
{0.770544,0.619993},
{0.786905,0.625554},
{0.800445,0.61487},
{0.804076,0.632662},
{0.792183,0.64129},
{0.809901,0.645092},
{0.803083,0.664299},
{0.820158,0.656917},
{0.826662,0.673232},
{0.838321,0.667474},
{0.847666,0.67689},
{0.851559,0.668468},
{0.860974,0.66491},
{0.868133,0.67156},
{0.873571,0.654795},
{0.88332,0.658988},
{0.882092,0.642434},
{0.899677,0.668215},
{0.909837,0.653967},
{0.895802,0.634081},
{0.886364,0.632443},
{0.888798,0.62055},
{0.904426,0.62094},
{0.888904,0.605604},
{0.902996,0.602879},
{0.885653,0.590153},
{0.900291,0.582519},
{0.889328,0.572288},
{0.879739,0.578341},
{0.872824,0.569865},
{0.881578,0.558592},
{0.859941,0.561078},
{0.867408,0.551388},
{0.848644,0.555514},
{0.863729,0.530317},
{0.848961,0.527793},
{0.839672,0.548848},
{0.838326,0.558045},
{0.830334,0.560394},
{0.822843,0.549285},
{0.821236,0.565001},
{0.810108,0.552671},
{0.813989,0.57201},
{0.799325,0.535541},
{0.781163,0.540692},
{0.760815,0.542956},
{0.747049,0.565012},
{0.760096,0.579109},
{0.755046,0.600469},
{0.752089,0.614539},
{0.763048,0.641525},
{0.771574,0.659349},
{0.7837,0.674464},
{0.803993,0.691567},
{0.817445,0.684544},
{0.834686,0.699166},
{0.844597,0.690467},
{0.856087,0.689545},
{0.863192,0.693705},
{0.884416,0.680905},
{0.906598,0.684733},
{0.920265,0.672439},
{0.93055,0.651756},
{0.913299,0.639213},
{0.921748,0.623633},
{0.92781,0.601507},
{0.915393,0.589548},
{0.927538,0.57933},
{0.916095,0.563462},
{0.906399,0.549988},
{0.89449,0.538627},
{0.880674,0.529749},
{0.870728,0.505389},
{0.849577,0.502518},
{0.831697,0.514115},
{0.834623,0.532193},
{0.815545,0.528032},
{0.809601,0.505595},
{0.786524,0.516718},
{0.778211,0.522994},
{0.821097,0.709731},
{0.805946,0.71776},
{0.785591,0.710056},
{0.787174,0.692037},
{0.769398,0.69592},
{0.765877,0.691884},
{0.753797,0.674458},
{0.751138,0.669996},
{0.743104,0.650704},
{0.741393,0.645432},
{0.73774,0.624942},
{0.73696,0.60442},
{0.746562,0.599792},
{0.73718,0.59865},
{0.752074,0.576282},
{0.743238,0.573231},
{0.834576,0.498502},
{0.949298,0.585218},
{0.939084,0.558297},
{0.927847,0.540734},
{0.907538,0.521052},
{0.886628,0.507272},
{0.952363,0.61148},
{0.95099,0.632402},
{0.942086,0.662696},
{0.924799,0.6918},
{0.911144,0.706059},
{0.894587,0.699418},
{0.890017,0.720994},
{0.869749,0.702755},
{0.868863,0.715676},
{0.8716,0.841877},
{0.863901,0.841648},
{0.863402,0.818036},
{0.871099,0.817387},
{0.951352,0.595731},
{0.912382,0.424775},
{0.912051,0.414075},
{0.91721,0.41407},
{0.917278,0.431667},
{0.912033,0.442323},
{0.917365,0.447018},
{0.90228,0.449899},
{0.9173,0.4499},
{0.886709,0.911453},
{0.870423,0.895384},
{0.887686,0.897241},
{0.891116,0.909734},
{0.892167,0.894906},
{0.866616,0.892021},
{0.864521,0.903676},
{0.866718,0.922586},
{0.885129,0.924572},
{0.889021,0.927751},
{0.861652,0.924943},
{0.888091,0.414482},
{0.887897,0.426444},
{0.8832,0.414446},
{0.8833,0.440339},
{0.888289,0.442467},
{0.888,0.449799},
{0.82384,0.996344},
{0.803255,0.996498},
{0.816711,0.985497},
{0.837011,0.985872},
{0.83,0.977696},
{0.819405,0.965221},
{0.802912,0.98042},
{0.846038,0.997488},
{0.847423,0.9821},
{0.848246,0.965575},
{0.828027,0.964389},
{0.802408,0.964386},
{0.974565,0.992231},
{0.951281,0.992925},
{0.967647,0.985919},
{0.974937,0.982172},
{0.977189,0.9744},
{0.995484,0.976705},
{0.996015,0.95821},
{0.971477,0.966111},
{0.973408,0.958144},
{0.949585,0.958575},
{0.961244,0.96634},
{0.95628,0.973789},
{0.95033,0.977165},
{0.959083,0.982705},
{0.990584,0.8788},
{0.994251,0.866446},
{0.994777,0.888296},
{0.9788,0.879},
{0.970263,0.889394},
{0.965935,0.874169},
{0.9539,0.8898},
{0.953645,0.87357},
{0.965892,0.852947},
{0.953656,0.852031},
{0.966359,0.831756},
{0.954124,0.830557},
{0.966977,0.807413},
{0.955885,0.797138},
{0.95693,0.783402},
{0.982339,0.799492},
{0.978552,0.785261},
{0.997534,0.787371},
{0.995012,0.821806},
{0.979556,0.821544},
{0.991292,0.822009},
{0.990512,0.851779},
{0.994396,0.842856},
{0.815,0.3897},
{0.806169,0.390368},
{0.817316,0.379386},
{0.820561,0.379257},
{0.820309,0.368486},
{0.816972,0.365991},
{0.81682,0.355488},
{0.820162,0.355442},
{0.818564,0.3525},
{0.805124,0.354712},
{0.8047,0.3518},
{0.796248,0.367687},
{0.784746,0.367557},
{0.796205,0.363973},
{0.77785,0.363752},
{0.766123,0.367497},
{0.766219,0.363601},
{0.925122,0.980206},
{0.899699,0.980014},
{0.900488,0.95929},
{0.924475,0.961398},
{0.942798,0.982239},
{0.943601,0.960186},
{0.896123,0.934068},
{0.897402,0.914375},
{0.91436,0.915067},
{0.911938,0.935146},
{0.935964,0.937245},
{0.937998,0.914939},
{0.819243,0.430189},
{0.819001,0.441276},
{0.8133,0.441183},
{0.8133,0.429514},
{0.819499,0.420221},
{0.8133,0.420124},
{0.994892,0.992511},
{0.825099,0.442254},
{0.824843,0.418608},
{0.838312,0.436153},
{0.840599,0.416815},
{0.8253,0.4038},
{0.825408,0.401031},
{0.810556,0.405299},
{0.801126,0.403535},
{0.7957,0.4072},
{0.567407,0.920207},
{0.5262,0.920209},
{0.526528,0.899},
{0.683787,0.899},
{0.631517,0.920207},
{0.687072,0.920198},
{0.975016,0.444409},
{0.975233,0.424892},
{0.98479,0.444396},
{0.985369,0.414954},
{0.974834,0.40601},
{0.985068,0.405984},
{0.970787,0.4029},
{0.956983,0.406004},
{0.95454,0.403},
{0.936404,0.406137},
{0.920885,0.403},
{0.916362,0.40614},
{0.900985,0.402959},
{0.893659,0.40597},
{0.881086,0.402677},
{0.87523,0.405663},
{0.855737,0.40136},
{0.874326,0.418568},
{0.859396,0.41648},
{0.857895,0.43648},
{0.872123,0.443888},
{0.804571,0.366318},
{0.807551,0.380039},
{0.806941,0.366072},
{0.782915,0.371289},
{0.797423,0.371192},
{0.793037,0.382446},
{0.776889,0.383118},
{0.767338,0.371357},
{0.7675,0.3833},
{0.7673,0.3755},
{0.770388,0.997076},
{0.769366,0.975507},
{0.792273,0.974845},
{0.768581,0.951781},
{0.79206,0.951344},
{0.792263,0.996688},
{0.854602,0.983867},
{0.854604,0.962702},
{0.881821,0.96259},
{0.866901,0.9844},
{0.89788,0.9848},
{0.898,0.962193},
{0.978715,0.851406},
{0.875643,0.956535},
{0.854754,0.956792},
{0.8715,0.945225},
{0.875773,0.951811},
{0.883776,0.951996},
{0.8929,0.956611},
{0.888867,0.943389},
{0.893598,0.932225},
{0.88269,0.935377},
{0.879579,0.931785},
{0.874168,0.937169},
{0.854251,0.931799},
{0.854311,0.941963},
{0.8954,0.951682},
{0.913003,0.951812},
{0.9389,0.952298},
{0.883163,0.447},
{0.873249,0.44975},
{0.846703,0.446217},
{0.851678,0.449323},
{0.831385,0.448448},
{0.8274,0.4455},
{0.8181,0.445},
{0.81278,0.447147},
{0.805215,0.444201},
{0.8009,0.4462},
{0.972669,0.939935},
{0.981,0.9298},
{0.985766,0.933047},
{0.9859,0.9398},
{0.934251,0.833718},
{0.9344,0.8179},
{0.94737,0.832987},
{0.946967,0.853107},
{0.933999,0.852652},
{0.947618,0.818301},
{0.686606,0.77106},
{0.685234,0.77333},
{0.683603,0.753746},
{0.648408,0.844818},
{0.651046,0.845125},
{0.63384,0.854644},
{0.693614,0.866839},
{0.694999,0.86461},
{0.696492,0.884168},
{0.734901,0.84011},
{0.733575,0.837805},
{0.751597,0.845774},
{0.731792,0.792973},
{0.729108,0.79266},
{0.746271,0.782974},
{0.812505,0.857321},
{0.80784,0.851559},
{0.812957,0.856058},
{0.808508,0.848263},
{0.810658,0.842651},
{0.813078,0.841877},
{0.819544,0.841415},
{0.819134,0.857537},
{0.822017,0.854291},
{0.82425,0.853282},
{0.824098,0.846547},
{0.671812,0.819077},
{0.67611,0.829533},
{0.685204,0.802857},
{0.708172,0.818893},
{0.838899,0.605588},
{0.827142,0.609812},
{0.829212,0.602438},
{0.816702,0.609376},
{0.814402,0.619299},
{0.809514,0.616085},
{0.840538,0.599505},
{0.846599,0.6046},
{0.847093,0.599199},
{0.7178,0.3135},
{0.725714,0.308204},
{0.718401,0.3179},
{0.735599,0.3167},
{0.734899,0.304},
{0.740522,0.303744},
{0.740812,0.316473},
{0.747602,0.3161},
{0.746895,0.3034},
{0.757537,0.307047},
{0.764899,0.3155},
{0.765,0.3111},
{0.647029,0.794804},
{0.663892,0.803494},
{0.663402,0.803901},
{0.695095,0.805005},
{0.6957,0.8056},
{0.691137,0.80986},
{0.684588,0.81546},
{0.682937,0.7764},
{0.686015,0.789837},
{0.681573,0.769699},
{0.6817,0.764553},
{0.68161,0.753179},
{0.872786,0.614215},
{0.867333,0.61959},
{0.859681,0.617862},
{0.857086,0.626817},
{0.844997,0.625662},
{0.84395,0.632236},
{0.835401,0.6282},
{0.835507,0.633799},
{0.8682,0.610701},
{0.7632,0.2939},
{0.754287,0.297132},
{0.763699,0.2896},
{0.746701,0.2864},
{0.744252,0.29889},
{0.741049,0.285269},
{0.737057,0.297434},
{0.734998,0.2841},
{0.732605,0.296601},
{0.72312,0.290388},
{0.718101,0.2804},
{0.7169,0.2846},
{0.874211,0.590017},
{0.878418,0.598396},
{0.872765,0.599525},
{0.875607,0.614979},
{0.881427,0.610343},
{0.881349,0.6219},
{0.8743,0.627999},
{0.879502,0.630294},
{0.87,0.5936},
{0.7168,0.3277},
{0.70894,0.332996},
{0.716199,0.3233},
{0.699003,0.3245},
{0.699701,0.3372},
{0.694113,0.33743},
{0.692595,0.324775},
{0.686998,0.3251},
{0.687805,0.3378},
{0.677064,0.334153},
{0.669801,0.3257},
{0.6696,0.3301},
{0.865889,0.598019},
{0.861529,0.6045},
{0.85186,0.605415},
{0.852295,0.613931},
{0.837325,0.615915},
{0.839261,0.622211},
{0.829001,0.6192},
{0.830207,0.625398},
{0.8607,0.5956},
{0.6696,0.298},
{0.675814,0.290784},
{0.671301,0.302},
{0.687699,0.2964},
{0.683599,0.284301},
{0.687861,0.282908},
{0.69373,0.294383},
{0.694932,0.280621},
{0.698999,0.2926},
{0.706242,0.28127},
{0.715499,0.2875},
{0.7145,0.2832},
{0.854478,0.650798},
{0.841604,0.648527},
{0.84279,0.641927},
{0.823241,0.638993},
{0.828239,0.634899},
{0.818201,0.626701},
{0.813605,0.630106},
{0.853999,0.6445},
{0.6701,0.3084},
{0.679094,0.305208},
{0.669601,0.3128},
{0.686599,0.3159},
{0.689049,0.303411},
{0.692888,0.317175},
{0.695693,0.304777},
{0.700805,0.305803},
{0.698399,0.3183},
{0.710229,0.311939},
{0.715199,0.3219},
{0.7164,0.3177},
{0.874852,0.392822},
{0.889447,0.393912},
{0.878305,0.395888},
{0.903059,0.397499},
{0.910506,0.395082},
{0.915109,0.395263},
{0.936277,0.39894},
{0.932848,0.395921},
{0.937062,0.396207},
{0.955227,0.396574},
{0.966777,0.399464},
{0.959732,0.396523},
{0.977413,0.396618},
{0.9848,0.4029},
{0.7921,0.3408},
{0.830607,0.339976},
{0.814848,0.34388},
{0.86148,0.344333},
{0.85025,0.340059},
{0.887407,0.340838},
{0.905652,0.345247},
{0.926708,0.346806},
{0.927,0.3425},
{0.792312,0.344168},
{0.894556,0.390163},
{0.886115,0.390147},
{0.882442,0.38667},
{0.905918,0.388916},
{0.841063,0.352331},
{0.84523,0.355484},
{0.859142,0.356086},
{0.872929,0.3543},
{0.870451,0.368781},
{0.857349,0.380244},
{0.872003,0.386073},
{0.8567,0.39},
{0.843721,0.389331},
{0.840119,0.379397},
{0.828029,0.3891},
{0.948651,0.94007},
{0.968399,0.930105},
{0.948386,0.9307},
{0.924216,0.361505},
{0.922915,0.389232},
{0.923638,0.373112},
{0.689599,0.3528},
{0.6891,0.3432},
{0.693947,0.343871},
{0.692857,0.353734},
{0.6953,0.3557},
{0.703399,0.3504},
{0.700279,0.347056},
{0.693399,0.381901},
{0.6877,0.3741},
{0.697621,0.371249},
{0.690752,0.372447},
{0.703699,0.3723},
{0.699802,0.381201},
{0.696322,0.380836},
{0.6798,0.3431},
{0.6884,0.3476},
{0.684655,0.351961},
{0.677651,0.345278},
{0.674399,0.3466},
{0.674801,0.3562},
{0.67856,0.355508},
{0.7029,0.3598},
{0.7034,0.3695},
{0.692788,0.366062},
{0.698515,0.368745},
{0.6891,0.3622},
{0.6971,0.3569},
{0.699942,0.358992},
{0.714401,0.343099},
{0.720099,0.3509},
{0.707732,0.353696},
{0.713297,0.353637},
{0.704101,0.3527},
{0.707999,0.3438},
{0.710833,0.344222},
{0.840339,0.726726},
{0.833573,0.716823},
{0.969377,0.379993},
{0.9755,0.3828},
{0.974393,0.3925},
{0.960883,0.3777},
{0.954722,0.391585},
{0.947582,0.377629},
{0.932204,0.3912},
{0.933204,0.381598},
{0.994012,0.3511},
{0.980138,0.350505},
{0.993569,0.341399},
{0.978303,0.340826},
{0.9782,0.35},
{0.9779,0.3702},
{0.971727,0.37277},
{0.97732,0.3609},
{0.956571,0.359262},
{0.953306,0.375118},
{0.932219,0.360501},
{0.938972,0.372437},
{0.9328,0.3697},
{0.978926,0.377},
{0.993798,0.3773},
{0.992421,0.386398},
{0.977392,0.3866},
{0.935298,0.340828},
{0.956949,0.342486},
{0.932219,0.3566},
{0.975693,0.342131},
{0.975369,0.357475},
{0.3598,0.9511},
{0.381763,0.950888},
{0.383555,0.963174},
{0.412828,0.950662},
{0.418673,0.963108},
{0.44923,0.950447},
{0.450988,0.9627},
{0.469986,0.963348},
{0.490607,0.950242},
{0.494346,0.962349},
{0.5188,0.962046},
{0.537302,0.9502},
{0.539502,0.962049},
{0.560207,0.962106},
{0.58387,0.950312},
{0.580897,0.962157},
{0.601605,0.962273},
{0.630612,0.950554},
{0.622314,0.962377},
{0.65193,0.963053},
{0.673902,0.950833},
{0.675576,0.963236},
{0.359304,0.963242},
{0.702727,0.931722},
{0.720444,0.931338},
{0.715436,0.943759},
{0.689211,0.943913},
{0.673606,0.93152},
{0.652828,0.944112},
{0.646063,0.931881},
{0.611429,0.944281},
{0.614885,0.931898},
{0.594732,0.931512},
{0.564671,0.944384},
{0.572831,0.932398},
{0.55208,0.932473},
{0.524727,0.932283},
{0.518147,0.9444},
{0.50028,0.932481},
{0.482074,0.944362},
{0.476775,0.931904},
{0.4499,0.93217},
{0.445597,0.944269},
{0.418215,0.931842},
{0.404149,0.944088},
{0.383117,0.931916},
{0.368072,0.943887},
{0.358021,0.931863},
{0.8,0.878},
{0.778778,0.878591},
{0.799799,0.862896},
{0.779604,0.862759},
{0.762752,0.861723},
{0.7625,0.8788},
{0.800247,0.842043},
{0.774997,0.841218},
{0.778482,0.815724},
{0.763544,0.833373},
{0.801199,0.8263},
{0.802595,0.810795},
{0.785235,0.787101},
{0.766626,0.799916},
{0.805149,0.790053},
{0.807602,0.7751},
{0.770704,0.768702},
{0.796569,0.361577},
{0.778381,0.361294},
{0.796601,0.357369},
{0.777004,0.357214},
{0.766462,0.357318},
{0.766548,0.361538},
{0.782523,0.350174},
{0.796916,0.350394},
{0.783109,0.354595},
{0.766866,0.350244},
{0.7669,0.354503},
{0.796947,0.354376},
{0.703308,0.868096},
{0.719699,0.864536},
{0.718286,0.885244},
{0.701666,0.894362},
{0.713813,0.916864},
{0.731757,0.897906},
{0.744687,0.868526},
{0.730424,0.856604},
{0.75668,0.879335},
{0.747001,0.906847},
{0.758725,0.89888},
{0.768578,0.889723},
{0.730739,0.913961},
{0.700822,0.9186},
{0.786557,0.387384},
{0.79538,0.387342},
{0.795133,0.389037},
{0.803331,0.38914},
{0.80495,0.387535},
{0.788136,0.389039},
{0.785938,0.393738},
{0.793088,0.39353},
{0.787633,0.39528},
{0.798246,0.394997},
{0.802803,0.393374},
{0.808357,0.394925},
{0.809863,0.393313},
{0.805263,0.391918},
{0.797966,0.392029},
{0.803645,0.390375},
{0.796021,0.390528},
{0.788431,0.390319},
{0.786756,0.391866},
{0.80936,0.39752},
{0.798141,0.397554},
{0.807856,0.395919},
{0.798777,0.395835},
{0.78843,0.396222},
{0.78698,0.39792},
{0.622385,0.266401},
{0.624019,0.266566},
{0.622946,0.268135},
{0.620079,0.266659},
{0.624016,0.269797},
{0.625631,0.267358},
{0.625051,0.264948},
{0.622526,0.264937},
{0.622863,0.263059},
{0.627094,0.265512},
{0.644585,0.226303},
{0.645839,0.228096},
{0.643829,0.228139},
{0.642568,0.226676},
{0.642361,0.228844},
{0.644635,0.229883},
{0.647116,0.22917},
{0.644799,0.224483},
{0.640803,0.227442},
{0.642776,0.23135},
{0.6182,0.714561},
{0.6182,0.682},
{0.668835,0.682},
{0.669168,0.714528},
{0.6182,0.758377},
{0.6182,0.725345},
{0.66918,0.725323},
{0.66915,0.758357},
{0.94919,0.921803},
{0.949065,0.900083},
{0.951504,0.901409},
{0.965294,0.900902},
{0.974094,0.899325},
{0.967903,0.900902},
{0.982292,0.90071},
{0.987131,0.89923},
{0.982377,0.921194},
{0.987225,0.922406},
{0.975201,0.922418},
{0.967968,0.915656},
{0.965393,0.921085},
{0.95151,0.920592},
{0.849196,0.946975},
{0.84824,0.960173},
{0.846901,0.958289},
{0.832418,0.957087},
{0.830515,0.958134},
{0.833225,0.947508},
{0.831759,0.946075},
{0.847699,0.948706},
{0.807719,0.948112},
{0.824486,0.946424},
{0.823301,0.948412},
{0.825859,0.958493},
{0.809514,0.94931},
{0.808242,0.959794},
{0.809986,0.958394},
{0.844283,0.9426},
{0.8314,0.9423},
{0.8313,0.9348},
{0.843585,0.935101},
{0.8107,0.9257},
{0.830878,0.925291},
{0.830289,0.933387},
{0.8114,0.9338},
{0.8323,0.9151},
{0.845284,0.9145},
{0.844972,0.9225},
{0.8326,0.923},
{0.830281,0.942802},
{0.8107,0.9432},
{0.811,0.9352},
{0.829517,0.934809},
{0.832109,0.9248},
{0.845784,0.925099},
{0.845183,0.932499},
{0.832809,0.9322},
{0.8107,0.9051},
{0.832592,0.904698},
{0.8332,0.912502},
{0.845684,0.912399},
{0.8112,0.9135},
{0.846393,0.9045},
{0.831263,0.922804},
{0.8107,0.9232},
{0.8111,0.9149},
{0.830306,0.914511},
{0.957256,0.769708},
{0.95815,0.777356},
{0.9565,0.777788},
{0.976974,0.778321},
{0.968445,0.776906},
{0.984919,0.776525},
{0.999191,0.777697},
{0.997315,0.777115},
{0.997885,0.7682},
{0.997488,0.769939},
{0.976874,0.768561},
{0.98302,0.770404},
{0.968279,0.770285},
{0.997896,0.9102},
{0.9898,0.91},
{0.9907,0.9057},
{0.996603,0.9059},
{0.9928,0.9191},
{0.993441,0.926917},
{0.989606,0.919861},
{0.986852,0.948798},
{0.992688,0.939071},
{0.989703,0.950691},
{0.9979,0.9158},
{0.989797,0.9157},
{0.991301,0.9114},
{0.9972,0.9114},
{0.998301,0.920304},
{0.99891,0.931192},
{0.996005,0.931091},
{0.994585,0.942745},
{0.997416,0.943006},
{0.9925,0.95},
{0.995,0.9511},
{0.995601,0.921005},
{0.662751,0.875364},
{0.653191,0.875484},
{0.656579,0.87222},
{0.6444,0.87244},
{0.639435,0.875636},
{0.632126,0.87255},
{0.627346,0.875729},
{0.621289,0.872547},
{0.617764,0.875749},
{0.610482,0.872683},
{0.606954,0.875933},
{0.602046,0.872752},
{0.6007,0.8759},
{0.666145,0.872242},
{0.672113,0.875353},
{0.674835,0.872144},
{0.976245,0.97298},
{0.97509,0.980354},
{0.971542,0.967026},
{0.968072,0.985106},
{0.96,0.982546},
{0.956813,0.975759},
{0.961353,0.96778},
{0.613689,0.880821},
{0.626811,0.880569},
{0.623457,0.883826},
{0.637915,0.883484},
{0.635924,0.880324},
{0.645179,0.880169},
{0.649708,0.883253},
{0.654323,0.879961},
{0.661331,0.882894},
{0.663665,0.879688},
{0.672333,0.882775},
{0.673497,0.879547},
{0.60889,0.884113},
{0.602793,0.881041},
{0.6013,0.8842},
{0.871879,0.945114},
{0.875653,0.93718},
{0.88454,0.936532},
{0.875088,0.950723},
{0.881507,0.952238},
{0.887175,0.949064},
{0.888668,0.94265},
{0.720333,0.43759},
{0.711901,0.436566},
{0.714127,0.432143},
{0.721471,0.433387},
{0.715857,0.428275},
{0.707508,0.428423},
{0.706073,0.437861},
{0.716237,0.438011},
{0.729108,0.43465},
{0.727013,0.430196},
{0.728502,0.439361},
{0.734442,0.440395},
{0.736624,0.433244},
{0.740986,0.44411},
{0.739634,0.438164},
{0.745134,0.441914},
{0.74243,0.435647},
{0.74654,0.447923},
{0.750753,0.445522},
{0.750722,0.441017},
{0.679954,0.447843},
{0.67732,0.444655},
{0.684585,0.443937},
{0.680046,0.436877},
{0.674724,0.439728},
{0.694748,0.440467},
{0.686458,0.437821},
{0.693879,0.435772},
{0.686318,0.433489},
{0.701826,0.433541},
{0.696665,0.430437},
{0.693701,0.485319},
{0.691867,0.487381},
{0.692279,0.485284},
{0.690975,0.487059},
{0.689713,0.488542},
{0.690896,0.488908},
{0.690539,0.489872},
{0.688902,0.490359},
{0.689824,0.49155},
{0.68839,0.49228},
{0.6895,0.493},
{0.703098,0.479692},
{0.700953,0.480517},
{0.700902,0.478828},
{0.698643,0.479748},
{0.698418,0.481577},
{0.696567,0.48098},
{0.695796,0.483238},
{0.695256,0.481937},
{0.693805,0.483288},
{0.691734,0.484001},
{0.689876,0.486506},
{0.688573,0.488803},
{0.687845,0.490855},
{0.68737,0.492324},
{0.7035,0.477996},
{0.702598,0.477267},
{0.699723,0.47808},
{0.696235,0.479872},
{0.693533,0.48201},
{0.734198,0.441839},
{0.68565,0.445155},
{0.718894,0.407701},
{0.710466,0.406665},
{0.712704,0.402304},
{0.720062,0.403527},
{0.714365,0.398375},
{0.707246,0.398694},
{0.704622,0.407992},
{0.714797,0.408132},
{0.727663,0.404774},
{0.725536,0.400307},
{0.729502,0.409915},
{0.735163,0.403379},
{0.741147,0.415042},
{0.734709,0.411031},
{0.738181,0.408284},
{0.743672,0.412023},
{0.740981,0.405782},
{0.737683,0.413807},
{0.749326,0.415648},
{0.748694,0.4108},
{0.746424,0.419069},
{0.693163,0.41041},
{0.68485,0.412926},
{0.685007,0.407967},
{0.692409,0.405903},
{0.68483,0.403642},
{0.677461,0.407399},
{0.680333,0.416415},
{0.689443,0.412493},
{0.700398,0.403654},
{0.696265,0.40031},
{0.675832,0.414809},
{0.6724,0.4104},
{0.69266,0.485068},
{0.693702,0.485318},
{0.691511,0.486074},
{0.691734,0.484002},
{0.690092,0.485981},
{0.690386,0.487386},
{0.691867,0.487381},
{0.689666,0.488949},
{0.689042,0.488013},
{0.688175,0.490205},
{0.689359,0.490799},
{0.690295,0.490672},
{0.690896,0.488908},
{0.688683,0.492056},
{0.687387,0.492328},
{0.689572,0.492724},
{0.703647,0.47858},
{0.703138,0.47977},
{0.702518,0.478426},
{0.703182,0.477033},
{0.700788,0.477794},
{0.700526,0.479156},
{0.701589,0.480204},
{0.699573,0.481215},
{0.698659,0.480507},
{0.696997,0.481024},
{0.696808,0.482567},
{0.695256,0.481937},
{0.693805,0.483288},
{0.695092,0.483808},
{0.693533,0.48201},
{0.695566,0.480314},
{0.698125,0.478953},
{0.711196,0.420968},
{0.719571,0.418907},
{0.718433,0.42309},
{0.714338,0.423532},
{0.704173,0.423392},
{0.707297,0.417467},
{0.699926,0.419054},
{0.692663,0.425786},
{0.69198,0.421294},
{0.684557,0.423351},
{0.684392,0.428326},
{0.688961,0.427892},
{0.679871,0.431788},
{0.678112,0.422444},
{0.675356,0.430156},
{0.672825,0.425228},
{0.727187,0.420162},
{0.723048,0.415358},
{0.712535,0.414209},
{0.703104,0.414178},
{0.693652,0.416348},
{0.684422,0.419041},
{0.729063,0.425313},
{0.733827,0.421688},
{0.731693,0.417402},
{0.735664,0.425979},
{0.743212,0.427423},
{0.740695,0.430404},
{0.737222,0.429207},
{0.73926,0.420984},
{0.748853,0.43102},
{0.748821,0.426525},
{0.745929,0.434469},
{0.69266,0.485068},
{0.693701,0.485319},
{0.691511,0.486074},
{0.691734,0.484001},
{0.690092,0.485981},
{0.690386,0.487386},
{0.691867,0.487381},
{0.689666,0.488949},
{0.689042,0.488014},
{0.688175,0.490205},
{0.689359,0.490799},
{0.690295,0.490672},
{0.690896,0.488908},
{0.688683,0.492056},
{0.687388,0.492327},
{0.689572,0.492724},
{0.703647,0.47858},
{0.703138,0.47977},
{0.702518,0.478426},
{0.703181,0.477033},
{0.700787,0.477794},
{0.700526,0.479156},
{0.701589,0.480204},
{0.699573,0.481215},
{0.698659,0.480507},
{0.696997,0.481024},
{0.696808,0.482567},
{0.695256,0.481937},
{0.693805,0.483288},
{0.695093,0.483807},
{0.693533,0.48201},
{0.695565,0.480315},
{0.698124,0.478954},
{0.997283,0.003},
{0.996741,0.003146},
{0.996688,0.002624},
{0.996223,0.002739},
{0.996285,0.0033},
{0.999235,0.0019},
{0.996,0.0034},
{0.997122,0.0025},
{0.997713,0.0029},
{0.997623,0.002363},
{0.997993,0.0028},
{0.998124,0.0022},
{0.99838,0.00266},
{0.998516,0.0021},
{0.998782,0.002559},
{0.998864,0.002},
{0.9991,0.0025},
{0.999363,0.0024},
{0.993983,0.004666},
{0.995479,0.005546},
{0.600609,0.384315},
{0.582627,0.382946},
{0.580518,0.380104},
{0.564968,0.383624},
{0.5579,0.3805},
{0.558001,0.3839},
{0.566042,0.395306},
{0.577055,0.392446},
{0.590189,0.384367},
{0.585813,0.39498},
{0.593367,0.403305},
{0.595496,0.413804},
{0.604938,0.436886},
{0.609496,0.381102},
{0.558741,0.402348},
{0.540118,0.385798},
{0.556631,0.411393},
{0.555207,0.434699},
{0.560128,0.422334},
{0.564653,0.434235},
{0.566888,0.428306},
{0.574803,0.430107},
{0.584265,0.435068},
{0.584021,0.427851},
{0.591668,0.421331},
{0.536135,0.43744},
{0.524196,0.391279},
{0.556807,0.437898},
{0.567657,0.452976},
{0.584003,0.45195},
{0.594678,0.452505},
{0.604087,0.453698},
{0.559005,0.454554},
{0.569649,0.37805},
{0.559313,0.379297},
{0.558403,0.3624},
{0.586031,0.360945},
{0.583153,0.37755},
{0.594919,0.378182},
{0.6084,0.3628},
{0.606398,0.3796},
{0.6232,0.434315},
{0.626099,0.383911},
{0.5536,0.3798},
{0.536412,0.3801},
{0.551717,0.363},
{0.554904,0.3629},
{0.53561,0.3633},
{0.618571,0.377039},
{0.618323,0.377592},
{0.610653,0.376529},
{0.6107,0.3745},
{0.615367,0.374883},
{0.626575,0.376296},
{0.626151,0.378301},
{0.626322,0.379951},
{0.618264,0.379359},
{0.610003,0.378141},
{0.583031,0.355362},
{0.574021,0.35536},
{0.581059,0.337449},
{0.56923,0.337206},
{0.564748,0.354909},
{0.557629,0.336493},
{0.553915,0.354312},
{0.548404,0.336225},
{0.540715,0.354383},
{0.53683,0.336559},
{0.524271,0.355169},
{0.526528,0.337096},
{0.519598,0.337394},
{0.517,0.3554},
{0.590308,0.336996},
{0.59221,0.354811},
{0.599492,0.336366},
{0.602761,0.354212},
{0.60877,0.336223},
{0.613898,0.354306},
{0.616864,0.336522},
{0.626031,0.337074},
{0.625612,0.35501},
{0.634294,0.355428},
{0.636343,0.3375},
{0.5534,0.4399},
{0.5543,0.4489},
{0.5438,0.4487},
{0.543,0.4391},
{0.5606,0.4101},
{0.585,0.411001},
{0.5857,0.4185},
{0.5618,0.4189},
{0.6263,0.3622},
{0.6354,0.3631},
{0.6346,0.3719},
{0.625198,0.3711},
{0.5647,0.4087},
{0.5641,0.399},
{0.5895,0.3997},
{0.5901,0.4095},
{0.5228,0.378199},
{0.5235,0.3705},
{0.5323,0.3713},
{0.5317,0.3793},
{0.5327,0.3852},
{0.523,0.3844},
{0.5236,0.3814},
{0.5332,0.3822},
{0.6088,0.4477},
{0.6082,0.4381},
{0.6191,0.4384},
{0.6197,0.448},
{0.5211,0.3582},
{0.531,0.3592},
{0.5303,0.3679},
{0.519998,0.3671},
{0.543801,0.4457},
{0.5442,0.4433},
{0.5503,0.4434},
{0.55,0.4458},
{0.638,0.384099},
{0.6289,0.3834},
{0.6299,0.3754},
{0.6388,0.3763},
{0.5786,0.428299},
{0.5697,0.4277},
{0.5706,0.4199},
{0.5794,0.4208},
{0.622,0.363},
{0.621301,0.3719},
{0.6117,0.3709},
{0.6126,0.3622},
{0.886934,0.758945},
{0.876056,0.77205},
{0.878121,0.747851},
{0.900178,0.74124},
{0.883538,0.736409},
{0.877999,0.74484},
{0.867224,0.757201},
{0.868408,0.756405},
{0.876542,0.776147},
{0.886979,0.79307},
{0.890524,0.772007},
{0.906184,0.757938},
{0.923019,0.745677},
{0.901064,0.739223},
{0.897912,0.784653},
{0.911849,0.76983},
{0.707936,0.686331},
{0.711804,0.69593},
{0.696425,0.684246},
{0.702775,0.676964},
{0.691505,0.672398},
{0.701559,0.66985},
{0.716,0.679996},
{0.719054,0.670496},
{0.723395,0.687541},
{0.730475,0.674322},
{0.702005,0.696884},
{0.717717,0.697569},
{0.900529,0.784545},
{0.917381,0.763211},
{0.924443,0.745995},
{0.829902,0.775938},
{0.840038,0.769263},
{0.853212,0.782575},
{0.848544,0.795897},
{0.869239,0.799316},
{0.854378,0.781641},
{0.830584,0.791104},
{0.815548,0.79162},
{0.834487,0.805743},
{0.852299,0.810767},
{0.870128,0.800323},
{0.817411,0.77711},
{0.813113,0.79889},
{0.813706,0.80726},
{0.829494,0.817817},
{0.812365,0.819351},
{0.720796,0.622494},
{0.713894,0.625855},
{0.718435,0.611403},
{0.705036,0.620985},
{0.696336,0.625507},
{0.708302,0.631885},
{0.705665,0.609971},
{0.689583,0.612752},
{0.684602,0.619596},
{0.7159,0.59636},
{0.70753,0.599127},
{0.697713,0.604791},
{0.84311,0.816172},
{0.825672,0.819857},
{0.829595,0.774377},
{0.774016,0.900635},
{0.777863,0.920383},
{0.761667,0.907253},
{0.760313,0.907694},
{0.763222,0.919216},
{0.765065,0.921648},
{0.780096,0.936773},
{0.793227,0.915646},
{0.78591,0.903739},
{0.796189,0.887022},
{0.776007,0.896807},
{0.762912,0.930792},
{0.7834,0.940311},
{0.800959,0.945265},
{0.804015,0.931949},
{0.803535,0.909207},
{0.701296,0.721157},
{0.691404,0.727194},
{0.696431,0.716377},
{0.702206,0.708942},
{0.688265,0.710677},
{0.685495,0.721636},
{0.678115,0.718898},
{0.679376,0.704559},
{0.68609,0.701502},
{0.680991,0.69244},
{0.696024,0.697262},
{0.706827,0.704885},
{0.713867,0.713006},
{0.797554,0.886235},
{0.803371,0.901547},
{0.806269,0.921523},
{0.802475,0.945508},
{0.902072,0.894963},
{0.913846,0.890876},
{0.914112,0.907682},
{0.912971,0.908556},
{0.92417,0.902336},
{0.93729,0.887325},
{0.92612,0.875703},
{0.902556,0.880949},
{0.886292,0.877437},
{0.900909,0.895799},
{0.937292,0.900581},
{0.942201,0.879075},
{0.94182,0.871738},
{0.943336,0.859848},
{0.926438,0.860866},
{0.903413,0.868493},
{0.900458,0.867531},
{0.926608,0.859402},
{0.697274,0.645719},
{0.702985,0.635634},
{0.711192,0.645807},
{0.704325,0.653451},
{0.7185,0.653938},
{0.724459,0.64957},
{0.718589,0.636409},
{0.711568,0.637808},
{0.700995,0.662411},
{0.690224,0.658978},
{0.718593,0.663485},
{0.729095,0.660902},
{0.937184,0.901988},
{0.926981,0.903019},
{0.840509,0.892625},
{0.839396,0.879919},
{0.858097,0.895478},
{0.857674,0.896944},
{0.863043,0.884227},
{0.856088,0.871081},
{0.844535,0.860268},
{0.826831,0.866154},
{0.81774,0.888253},
{0.840042,0.894024},
{0.864139,0.860107},
{0.852323,0.838957},
{0.840154,0.847721},
{0.823766,0.868702},
{0.816357,0.888002},
{0.872786,0.876198},
{0.865388,0.859274},
{0.659435,0.644514},
{0.657531,0.633128},
{0.668211,0.636887},
{0.668536,0.649151},
{0.679565,0.638629},
{0.680188,0.62888},
{0.666372,0.628648},
{0.669998,0.623814},
{0.662405,0.659267},
{0.674695,0.654399},
{0.687959,0.643876},
{0.693664,0.635986},
{0.866513,0.882605},
{0.703786,0.46205},
{0.713081,0.460983},
{0.708474,0.461569},
{0.711302,0.46125},
{0.697426,0.463835},
{0.699448,0.463251},
{0.701602,0.46285},
{0.692195,0.465535},
{0.691241,0.464954},
{0.6916,0.4572},
{0.6902,0.4577},
{0.6887,0.4582},
{0.6873,0.4588},
{0.738173,0.462923},
{0.735543,0.46252},
{0.73771,0.462208},
{0.733487,0.461936},
{0.729032,0.461364},
{0.727016,0.460269},
{0.722998,0.460766},
{0.7234,0.4529},
{0.7219,0.4529},
{0.7204,0.4528},
{0.7189,0.4528},
{0.718142,0.460732},
{0.721002,0.4608},
{0.715507,0.476323},
{0.725528,0.476441},
{0.716408,0.480814},
{0.710882,0.477714},
{0.711332,0.484318},
{0.719111,0.484635},
{0.723376,0.480836},
{0.730549,0.477956},
{0.729247,0.482213},
{0.738815,0.482895},
{0.734998,0.480049},
{0.707181,0.479778},
{0.704942,0.489374},
{0.709569,0.488993},
{0.713753,0.491462},
{0.718166,0.489192},
{0.723864,0.486556},
{0.729962,0.486945},
{0.736591,0.4876},
{0.741085,0.485341},
{0.745999,0.491599},
{0.743699,0.488098},
{0.699237,0.487305},
{0.701917,0.494696},
{0.710185,0.495444},
{0.71518,0.497437},
{0.719685,0.49472},
{0.723449,0.493103},
{0.72715,0.491774},
{0.733052,0.491746},
{0.737152,0.49718},
{0.741574,0.494246},
{0.748161,0.494897},
{0.745066,0.499443},
{0.749372,0.497104},
{0.695251,0.494341},
{0.700941,0.49905},
{0.709635,0.499757},
{0.716522,0.502634},
{0.718993,0.499135},
{0.724162,0.498975},
{0.730418,0.497235},
{0.733546,0.502531},
{0.74089,0.504074},
{0.693944,0.498397},
{0.698743,0.503334},
{0.705216,0.502082},
{0.70872,0.505907},
{0.713761,0.506617},
{0.7102,0.5086},
{0.695438,0.506171},
{0.70237,0.507945},
{0.735,0.506},
{0.728405,0.503215},
{0.723259,0.502361},
{0.691963,0.503831},
{0.6926,0.501801},
{0.7066,0.4537},
{0.7082,0.4535},
{0.7097,0.4533},
{0.7112,0.4531},
{0.7127,0.453},
{0.7143,0.4529},
{0.7158,0.4529},
{0.7173,0.4528},
{0.7051,0.4539},
{0.7036,0.4542},
{0.7021,0.4544},
{0.7005,0.4548},
{0.699,0.4551},
{0.6975,0.4555},
{0.696,0.4559},
{0.6946,0.4563},
{0.6931,0.4567},
{0.7249,0.453},
{0.7264,0.4532},
{0.7279,0.4533},
{0.7294,0.4535},
{0.7308,0.4537},
{0.7323,0.454},
{0.7338,0.4542},
{0.7352,0.4545},
{0.7367,0.4548},
{0.7381,0.4552},
{0.7396,0.4556},
{0.741,0.456},
{0.700824,0.484744},
{0.704298,0.481352},
{0.722973,0.472189},
{0.719458,0.47208},
{0.719577,0.464905},
{0.715768,0.46493},
{0.715949,0.47211},
{0.712031,0.465133},
{0.713366,0.472236},
{0.710781,0.472433},
{0.708181,0.465508},
{0.707431,0.472841},
{0.704587,0.466048},
{0.704198,0.473404},
{0.701951,0.466546},
{0.699421,0.467118},
{0.70188,0.473896},
{0.699628,0.474468},
{0.696196,0.467984},
{0.697429,0.475096},
{0.69302,0.468986},
{0.695268,0.475815},
{0.690688,0.469833},
{0.692418,0.476815},
{0.688372,0.470718},
{0.690316,0.477662},
{0.686109,0.471548},
{0.688964,0.478263},
{0.723573,0.465048},
{0.7256,0.472418},
{0.727237,0.465374},
{0.72817,0.472686},
{0.730074,0.46571},
{0.730735,0.473061},
{0.732845,0.466174},
{0.733129,0.473516},
{0.736396,0.466906},
{0.736369,0.474259},
{0.738998,0.467538},
{0.739481,0.47513},
{0.741518,0.46826},
{0.742464,0.476074},
{0.744806,0.469289},
{0.745363,0.477162},
{0.747832,0.470367},
{0.715402,0.46095},
{0.727,0.4611},
{0.725052,0.46095},
{0.731651,0.4618},
{0.738201,0.46325},
{0.694852,0.464649},
{0.705702,0.46205},
{0.720598,0.4758},
{0.696849,0.490402},
{0.7976,0.466},
{0.7987,0.4671},
{0.7918,0.4729},
{0.7996,0.4684},
{0.8002,0.4698},
{0.8006,0.4713},
{0.8008,0.4729},
{0.8006,0.4744},
{0.8002,0.476},
{0.7996,0.4774},
{0.7987,0.4786},
{0.7976,0.4798},
{0.7963,0.4806},
{0.7949,0.4813},
{0.7934,0.4817},
{0.7918,0.4818},
{0.7903,0.4817},
{0.7888,0.4813},
{0.7874,0.4806},
{0.7861,0.4798},
{0.785,0.4786},
{0.7841,0.4774},
{0.7834,0.476},
{0.783,0.4744},
{0.7829,0.4729},
{0.783,0.4713},
{0.7834,0.4698},
{0.7841,0.4684},
{0.785,0.4671},
{0.7861,0.466},
{0.7874,0.4651},
{0.7888,0.4645},
{0.7903,0.4641},
{0.7918,0.4639},
{0.7934,0.4641},
{0.7949,0.4645},
{0.7963,0.4651},
{0.965444,0.739613},
{0.965455,0.737365},
{0.968944,0.738027},
{0.966632,0.741812},
{0.970635,0.740817},
{0.974358,0.739348},
{0.971514,0.735293},
{0.96706,0.7345},
{0.962462,0.733574},
{0.961937,0.738336},
{0.962101,0.743236},
{0.964444,0.746258},
{0.968422,0.74552},
{0.975026,0.743658},
{0.979736,0.742738},
{0.977639,0.735547},
{0.973849,0.730604},
{0.968695,0.73152},
{0.965071,0.728958},
{0.959708,0.726682},
{0.956902,0.732391},
{0.957242,0.73805},
{0.956755,0.742926},
{0.959948,0.748773},
{0.96854,0.752362},
{0.972717,0.746881},
{0.976696,0.750266},
{0.985119,0.752606},
{0.989265,0.743169},
{0.989203,0.732654},
{0.981305,0.730328},
{0.976577,0.723729},
{0.969638,0.726027},
{0.963924,0.723694},
{0.959856,0.717309},
{0.951761,0.727107},
{0.948452,0.737619},
{0.951195,0.741991},
{0.953746,0.748213},
{0.955104,0.753898},
{0.961607,0.756296},
{0.969245,0.758483},
{0.977764,0.758951},
{0.968981,0.71787},
{0.981681,0.722086},
{0.944228,0.749708},
{0.951899,0.758042},
{0.96475,0.762071},
{0.943044,0.736227},
{0.947321,0.724644},
{0.546402,0.8635},
{0.560964,0.863524},
{0.550038,0.863023},
{0.563068,0.868317},
{0.566772,0.875592},
{0.56359,0.88164},
{0.560183,0.887096},
{0.55481,0.887592},
{0.548039,0.888086},
{0.543656,0.8833},
{0.539711,0.877654},
{0.541071,0.871343},
{0.552188,0.872059},
{0.554073,0.878532},
{0.509223,0.862897},
{0.517397,0.861522},
{0.517665,0.862891},
{0.501999,0.87068},
{0.509274,0.877098},
{0.516221,0.885663},
{0.524242,0.880569},
{0.524331,0.867695},
{0.526548,0.868914},
{0.525773,0.880737},
{0.514992,0.888274},
{0.50592,0.883215},
{0.504852,0.885159},
{0.500248,0.875604},
{0.504494,0.864578},
{0.728533,0.724503},
{0.739236,0.72743},
{0.731868,0.731791},
{0.722084,0.732295},
{0.73269,0.737197},
{0.743506,0.736244},
{0.7496,0.7303},
{0.7488,0.7273},
{0.7475,0.7245},
{0.7457,0.722},
{0.7435,0.7199},
{0.741,0.7182},
{0.7382,0.7169},
{0.7353,0.7161},
{0.7323,0.7159},
{0.7292,0.7161},
{0.7263,0.7169},
{0.7235,0.7182},
{0.721,0.7199},
{0.7188,0.7221},
{0.7171,0.7245},
{0.7157,0.7273},
{0.7149,0.7303},
{0.7146,0.7334},
{0.7149,0.7365},
{0.722879,0.741163},
{0.734398,0.744167},
{0.7457,0.7447},
{0.7475,0.7422},
{0.7488,0.7394},
{0.7496,0.7365},
{0.7499,0.7334},
{0.7435,0.7468},
{0.741,0.7486},
{0.7382,0.7499},
{0.7353,0.7506},
{0.7323,0.7509},
{0.7292,0.7506},
{0.7263,0.7499},
{0.7235,0.7486},
{0.721,0.7468},
{0.7188,0.7447},
{0.7171,0.7422},
{0.7157,0.7394},
{0.697883,0.463622},
{0.70484,0.462135},
{0.700205,0.46314},
{0.702952,0.46255},
{0.690205,0.465879},
{0.693521,0.465077},
{0.696152,0.46425},
{0.726309,0.460971},
{0.732542,0.461599},
{0.728364,0.461229},
{0.730351,0.4616},
{0.721656,0.460734},
{0.718051,0.460504},
{0.719602,0.4608},
{0.714492,0.476591},
{0.721972,0.476195},
{0.720632,0.482168},
{0.716447,0.48467},
{0.719979,0.489132},
{0.724798,0.484116},
{0.726531,0.480376},
{0.724582,0.476169},
{0.734,0.479858},
{0.728097,0.476949},
{0.7317,0.4782},
{0.711746,0.477724},
{0.710194,0.483701},
{0.713251,0.487917},
{0.715305,0.492949},
{0.719486,0.495009},
{0.724527,0.490381},
{0.729257,0.489895},
{0.732071,0.485257},
{0.736698,0.48757},
{0.739884,0.484102},
{0.737048,0.481449},
{0.708347,0.478857},
{0.704224,0.481513},
{0.70659,0.488727},
{0.709922,0.491804},
{0.711028,0.496385},
{0.714702,0.498502},
{0.718303,0.501994},
{0.722917,0.498294},
{0.725316,0.494695},
{0.729868,0.497333},
{0.732904,0.493528},
{0.701616,0.489865},
{0.699821,0.496981},
{0.698645,0.487687},
{0.700799,0.484702},
{0.69556,0.493788},
{0.699409,0.504178},
{0.704228,0.500666},
{0.70475,0.495442},
{0.694325,0.496468},
{0.69242,0.502836},
{0.696161,0.507206},
{0.703578,0.508595},
{0.708321,0.503174},
{0.744088,0.489297},
{0.742248,0.486298},
{0.739206,0.492585},
{0.743313,0.498755},
{0.74751,0.494115},
{0.746149,0.491649},
{0.736334,0.497327},
{0.732809,0.503727},
{0.737801,0.504685},
{0.711755,0.507196},
{0.714418,0.503036},
{0.72807,0.50168},
{0.721227,0.501035},
{0.727,0.5049},
{0.74948,0.4974},
{0.749349,0.496398},
{0.7066,0.4537},
{0.7082,0.4535},
{0.7115,0.461137},
{0.7097,0.4533},
{0.713245,0.460801},
{0.7112,0.4531},
{0.7127,0.453},
{0.7143,0.4529},
{0.7158,0.4529},
{0.7173,0.4528},
{0.7189,0.4528},
{0.7204,0.4528},
{0.7219,0.4529},
{0.7234,0.4529},
{0.7249,0.453},
{0.7264,0.4532},
{0.7279,0.4533},
{0.7294,0.4535},
{0.7308,0.4537},
{0.7323,0.454},
{0.7338,0.4542},
{0.7352,0.4545},
{0.7367,0.4548},
{0.7381,0.4552},
{0.736514,0.462652},
{0.7396,0.4556},
{0.741,0.456},
{0.6873,0.4588},
{0.6887,0.4582},
{0.6902,0.4577},
{0.6916,0.4572},
{0.6931,0.4567},
{0.6946,0.4563},
{0.696,0.4559},
{0.6975,0.4555},
{0.699,0.4551},
{0.7005,0.4548},
{0.7021,0.4544},
{0.7036,0.4542},
{0.7051,0.4539},
{0.721209,0.472121},
{0.717702,0.472063},
{0.718608,0.464881},
{0.716709,0.464881},
{0.713829,0.465024},
{0.715091,0.472134},
{0.713365,0.472236},
{0.710974,0.465218},
{0.710781,0.472432},
{0.709114,0.465399},
{0.70635,0.465761},
{0.708266,0.472736},
{0.705784,0.473104},
{0.703651,0.466204},
{0.701103,0.466725},
{0.703428,0.473555},
{0.701128,0.474082},
{0.698588,0.467333},
{0.696169,0.467992},
{0.698127,0.474891},
{0.693788,0.468733},
{0.695992,0.475568},
{0.691472,0.469535},
{0.693835,0.476312},
{0.689153,0.470404},
{0.691722,0.477068},
{0.68685,0.47129},
{0.689635,0.477963},
{0.721528,0.464956},
{0.72385,0.472254},
{0.724408,0.465101},
{0.726459,0.4725},
{0.726309,0.465275},
{0.729172,0.465597},
{0.729881,0.472923},
{0.732907,0.466185},
{0.732343,0.473358},
{0.734783,0.473874},
{0.736412,0.46691},
{0.737933,0.474678},
{0.738997,0.467538},
{0.741517,0.46826},
{0.740205,0.475346},
{0.742463,0.476074},
{0.743998,0.46901},
{0.746496,0.469888},
{0.744671,0.476846},
{0.746051,0.477467},
{0.748671,0.470665},
{0.709901,0.4614},
{0.707102,0.4618},
{0.715402,0.46095},
{0.723702,0.46085},
{0.734252,0.46225},
{0.6916,0.4658},
{0.6902,0.4663},
{0.718048,0.47595},
{0.696849,0.490402},
{0.6932,0.500102},
{0.7976,0.466},
{0.7987,0.4671},
{0.7918,0.4729},
{0.7996,0.4684},
{0.8002,0.4698},
{0.8006,0.4713},
{0.8008,0.4729},
{0.8006,0.4744},
{0.8002,0.476},
{0.7996,0.4774},
{0.7987,0.4786},
{0.7976,0.4798},
{0.7963,0.4806},
{0.7949,0.4813},
{0.7934,0.4817},
{0.7918,0.4818},
{0.7903,0.4817},
{0.7888,0.4813},
{0.7874,0.4806},
{0.7861,0.4798},
{0.785,0.4786},
{0.7841,0.4774},
{0.7834,0.476},
{0.783,0.4744},
{0.7829,0.4729},
{0.783,0.4713},
{0.7834,0.4698},
{0.7841,0.4684},
{0.785,0.4671},
{0.7861,0.466},
{0.7874,0.4651},
{0.7888,0.4645},
{0.7903,0.4641},
{0.7918,0.4639},
{0.7934,0.4641},
{0.7949,0.4645},
{0.7963,0.4651},
{0.734472,0.735865},
{0.731823,0.730731},
{0.741668,0.73519},
{0.737964,0.744076},
{0.7461,0.7444},
{0.7478,0.7419},
{0.7491,0.7392},
{0.75,0.7362},
{0.743679,0.727845},
{0.732061,0.723259},
{0.72226,0.727002},
{0.722576,0.737155},
{0.729459,0.742442},
{0.7297,0.7503},
{0.7327,0.7506},
{0.7357,0.7503},
{0.7386,0.7495},
{0.7414,0.7483},
{0.7439,0.7465},
{0.7327,0.7157},
{0.7357,0.716},
{0.7297,0.716},
{0.7268,0.7168},
{0.724,0.718},
{0.7215,0.7198},
{0.7194,0.7219},
{0.7176,0.7244},
{0.7163,0.7271},
{0.7154,0.7301},
{0.7152,0.7331},
{0.7155,0.7362},
{0.7163,0.7392},
{0.7176,0.7419},
{0.7194,0.7444},
{0.7215,0.7465},
{0.724,0.7483},
{0.7268,0.7495},
{0.7386,0.7168},
{0.7414,0.718},
{0.7439,0.7198},
{0.7461,0.7219},
{0.7478,0.7244},
{0.7491,0.7271},
{0.75,0.7301},
{0.7503,0.7331},
{0.737626,0.462857},
{0.735548,0.462548},
{0.731178,0.461583},
{0.732951,0.462},
{0.729048,0.461398},
{0.726315,0.460223},
{0.723672,0.460816},
{0.726352,0.46105},
{0.719008,0.460538},
{0.7219,0.4529},
{0.7204,0.4528},
{0.7189,0.4528},
{0.7173,0.4528},
{0.7158,0.4529},
{0.714067,0.46093},
{0.716802,0.46085},
{0.713118,0.476864},
{0.716776,0.476615},
{0.711694,0.48437},
{0.709466,0.478348},
{0.706675,0.485478},
{0.709004,0.492368},
{0.712831,0.4928},
{0.71552,0.487589},
{0.718489,0.480526},
{0.720552,0.47582},
{0.726407,0.483243},
{0.729059,0.477449},
{0.725648,0.47635},
{0.702639,0.483054},
{0.704172,0.490891},
{0.697673,0.489845},
{0.701119,0.494993},
{0.704794,0.498091},
{0.695027,0.495416},
{0.698546,0.500107},
{0.705603,0.503323},
{0.709273,0.4981},
{0.714896,0.497883},
{0.717699,0.49172},
{0.720294,0.484873},
{0.723241,0.49005},
{0.728681,0.489385},
{0.733981,0.484552},
{0.736872,0.481355},
{0.732798,0.478799},
{0.749256,0.496357},
{0.74947,0.497419},
{0.74356,0.497283},
{0.744781,0.489992},
{0.7397,0.491241},
{0.738577,0.500087},
{0.741508,0.503948},
{0.731096,0.502715},
{0.730998,0.505652},
{0.723476,0.502867},
{0.723715,0.499479},
{0.719013,0.499289},
{0.720158,0.494917},
{0.714982,0.502},
{0.710513,0.506181},
{0.70118,0.507846},
{0.692976,0.502163},
{0.6951,0.5066},
{0.739393,0.483768},
{0.74221,0.486316},
{0.734756,0.489305},
{0.729328,0.493682},
{0.734888,0.494777},
{0.731136,0.497864},
{0.725056,0.494535},
{0.706298,0.479951},
{0.69375,0.498251},
{0.692599,0.501802},
{0.6915,0.5042},
{0.7066,0.4537},
{0.7082,0.4535},
{0.708536,0.461557},
{0.7097,0.4533},
{0.7112,0.4531},
{0.7127,0.453},
{0.7143,0.4529},
{0.7234,0.4529},
{0.7249,0.453},
{0.7264,0.4532},
{0.7279,0.4533},
{0.7294,0.4535},
{0.7308,0.4537},
{0.7323,0.454},
{0.7338,0.4542},
{0.7352,0.4545},
{0.7367,0.4548},
{0.7381,0.4552},
{0.7396,0.4556},
{0.741,0.456},
{0.6873,0.4588},
{0.6887,0.4582},
{0.690207,0.46605},
{0.694732,0.464592},
{0.6902,0.4577},
{0.6916,0.4572},
{0.6931,0.4567},
{0.6946,0.4563},
{0.699379,0.463025},
{0.696,0.4559},
{0.6975,0.4555},
{0.699,0.4551},
{0.703686,0.462126},
{0.7005,0.4548},
{0.7021,0.4544},
{0.7036,0.4542},
{0.7051,0.4539},
{0.722973,0.472189},
{0.71947,0.472079},
{0.719692,0.464908},
{0.71576,0.464931},
{0.715949,0.47211},
{0.712845,0.465067},
{0.712505,0.472281},
{0.710046,0.465308},
{0.709095,0.472632},
{0.706434,0.465747},
{0.706598,0.472955},
{0.703651,0.466204},
{0.704198,0.473404},
{0.701087,0.466728},
{0.701142,0.474086},
{0.697716,0.467558},
{0.698152,0.474882},
{0.694579,0.468482},
{0.695253,0.475819},
{0.69147,0.469536},
{0.693141,0.476562},
{0.688373,0.470717},
{0.691007,0.477365},
{0.68611,0.471548},
{0.688964,0.478263},
{0.722508,0.464981},
{0.725303,0.465183},
{0.725616,0.472423},
{0.728169,0.472686},
{0.728195,0.465475},
{0.731002,0.46586},
{0.730736,0.473061},
{0.733158,0.473521},
{0.734739,0.46654},
{0.736382,0.474265},
{0.73813,0.467324},
{0.73945,0.475117},
{0.740692,0.46801},
{0.74317,0.46876},
{0.742481,0.476083},
{0.745626,0.469572},
{0.745352,0.477153},
{0.74795,0.470409},
{0.711302,0.46125},
{0.721002,0.4608},
{0.692251,0.465549},
{0.697502,0.463899},
{0.701602,0.46285},
{0.705702,0.46205},
{0.699299,0.486501},
{0.695849,0.492402},
{0.747199,0.493348},
{0.7976,0.466},
{0.7987,0.4671},
{0.7918,0.4729},
{0.7996,0.4684},
{0.8002,0.4698},
{0.8006,0.4713},
{0.8008,0.4729},
{0.8006,0.4744},
{0.8002,0.476},
{0.7996,0.4774},
{0.7987,0.4786},
{0.7976,0.4798},
{0.7963,0.4806},
{0.7949,0.4813},
{0.7934,0.4817},
{0.7918,0.4818},
{0.7903,0.4817},
{0.7888,0.4813},
{0.7874,0.4806},
{0.7861,0.4798},
{0.785,0.4786},
{0.7841,0.4774},
{0.7834,0.476},
{0.783,0.4744},
{0.7829,0.4729},
{0.783,0.4713},
{0.7834,0.4698},
{0.7841,0.4684},
{0.785,0.4671},
{0.7861,0.466},
{0.7874,0.4651},
{0.7888,0.4645},
{0.7903,0.4641},
{0.7918,0.4639},
{0.7934,0.4641},
{0.7949,0.4645},
{0.7963,0.4651},
{0.740869,0.739866},
{0.730965,0.742584},
{0.734218,0.733106},
{0.742984,0.728893},
{0.730539,0.728342},
{0.723333,0.736307},
{0.7176,0.7419},
{0.7194,0.7444},
{0.7215,0.7465},
{0.724,0.7483},
{0.7268,0.7495},
{0.7297,0.7503},
{0.7327,0.7506},
{0.7357,0.7503},
{0.7386,0.7495},
{0.7414,0.7483},
{0.7439,0.7465},
{0.7461,0.7444},
{0.7478,0.7419},
{0.7491,0.7392},
{0.75,0.7362},
{0.7503,0.7331},
{0.75,0.7301},
{0.7491,0.7271},
{0.7478,0.7244},
{0.7461,0.7219},
{0.7439,0.7198},
{0.73298,0.721569},
{0.722757,0.727815},
{0.7154,0.7301},
{0.7152,0.7331},
{0.7155,0.7362},
{0.7163,0.7392},
{0.7327,0.7157},
{0.7357,0.716},
{0.7297,0.716},
{0.7268,0.7168},
{0.724,0.718},
{0.7215,0.7198},
{0.7194,0.7219},
{0.7176,0.7244},
{0.7163,0.7271},
{0.7386,0.7168},
{0.7414,0.718},
{0.486401,0.0234},
{0.507818,0.0234},
{0.505109,0.0088},
{0.481799,0.0088},
{0.471146,0.0234},
{0.460146,0.0088},
{0.452126,0.0234},
{0.438275,0.0088},
{0.427307,0.0234},
{0.422554,0.0088},
{0.404481,0.0088},
{0.404226,0.0234},
{0.3448,0.0234},
{0.3448,0.0088},
{0.5676,0.0088},
{0.5675,0.0234},
{0.034171,0.277188},
{0.0935,0.2786},
{0.1042,0.2621},
{0.1039,0.2158},
{0.2047,0.2615},
{0.2045,0.2153},
{0.2743,0.0796},
{0.2747,0.092},
{0.2969,0.0913},
{0.2965,0.0788},
{0.2291,0.3428},
{0.2295,0.3553},
{0.2517,0.3546},
{0.2513,0.3421},
{0.1041,0.303172},
{0.1041,0.350175},
{0.2046,0.3037},
{0.1096,0.3026},
{0.1096,0.2901},
{0.2046,0.2891},
{0.1041,0.289434},
{0.119247,0.05538},
{0.110239,0.050773},
{0.102068,0.055563},
{0.114532,0.070918},
{0.101082,0.064932},
{0.106531,0.070928},
{0.120751,0.06467},
{0.397616,0.0439},
{0.405996,0.0439},
{0.400454,0.0341},
{0.411447,0.0341},
{0.414516,0.0439},
{0.422484,0.0341},
{0.424697,0.0439},
{0.431732,0.0341},
{0.434816,0.0439},
{0.439075,0.0341},
{0.4405,0.0439},
{0.380122,0.0341},
{0.373498,0.0341},
{0.37811,0.0439},
{0.388248,0.0439},
{0.390284,0.0341},
{0.035851,0.333011},
{0.0343,0.323024},
{0.005196,0.330731},
{0.008629,0.309615},
{0.01793,0.297116},
{0.04051,0.316842},
{0.033744,0.28909},
{0.04785,0.316862},
{0.0932,0.2872},
{0.053521,0.32254},
{0.05302,0.331998},
{0.0932,0.3664},
{0.045071,0.337119},
{0.031277,0.363513},
{0.012718,0.350532},
{0.015061,0.265393},
{0.005227,0.243431},
{0.007245,0.224859},
{0.015546,0.212221},
{0.033544,0.201642},
{0.093,0.1994},
{0.2046,0.3499},
{0.1096,0.351},
{0.2046,0.3644},
{0.1096,0.3634},
{0.1041,0.364088},
{0.2932,0.0991},
{0.2973,0.1029},
{0.2751,0.1036},
{0.2627,0.08},
{0.2632,0.0924},
{0.2739,0.068},
{0.2923,0.0713},
{0.2961,0.0673},
{0.3085,0.0909},
{0.3081,0.0785},
{0.2175,0.3432},
{0.2179,0.3557},
{0.2287,0.3312},
{0.2471,0.3345},
{0.2509,0.3305},
{0.2632,0.3542},
{0.2628,0.3417},
{0.2521,0.3661},
{0.248,0.3624},
{0.2299,0.3669},
{0.64439,0.059},
{0.639514,0.059},
{0.643867,0.064},
{0.650361,0.059},
{0.650786,0.064},
{0.65571,0.064},
{0.656089,0.059},
{0.65967,0.064},
{0.66003,0.059},
{0.63459,0.059},
{0.630256,0.059},
{0.630799,0.064},
{0.637086,0.064},
{0.674911,0.164026},
{0.669293,0.166241},
{0.672638,0.168106},
{0.673023,0.169108},
{0.670027,0.172112},
{0.676089,0.172186},
{0.673879,0.168293},
{0.678162,0.16737},
{0.673431,0.168508},
{0.623451,0.068},
{0.616661,0.068},
{0.620986,0.0729},
{0.625969,0.0729},
{0.62829,0.068},
{0.630786,0.0729},
{0.633214,0.068},
{0.637206,0.0729},
{0.63809,0.068},
{0.609241,0.068},
{0.60837,0.0729},
{0.614098,0.0729},
{0.643437,0.165751},
{0.638626,0.164752},
{0.642502,0.166277},
{0.643191,0.166406},
{0.643399,0.166939},
{0.640873,0.170388},
{0.64201,0.161538},
{0.646435,0.162788},
{0.647188,0.168706},
{0.3916,0.1586},
{0.3759,0.1589},
{0.3761,0.1687},
{0.3918,0.1683},
{0.3909,0.1292},
{0.3752,0.1296},
{0.3754,0.1394},
{0.3912,0.139},
{0.3757,0.1491},
{0.3914,0.1488},
{0.6759,0.1426},
{0.6759,0.1397},
{0.6672,0.1397},
{0.6672,0.1426},
{0.6647,0.1395},
{0.668,0.1322},
{0.6656,0.1319},
{0.668,0.1299},
{0.6751,0.1322},
{0.6751,0.1299},
{0.6776,0.1319},
{0.6784,0.1395},
{0.671464,0.1378},
{0.669836,0.13595},
{0.673262,0.135971},
{0.671622,0.134209},
{0.54257,0.166039},
{0.5692,0.1426},
{0.542268,0.143386},
{0.4358,0.1662},
{0.4358,0.1435},
{0.542346,0.13497},
{0.416,0.1316},
{0.5692,0.1667},
{0.542177,0.174418},
{0.569,0.1752},
{0.413519,0.144607},
{0.414428,0.156573},
{0.4289,0.1474},
{0.4288,0.1625},
{0.413127,0.165492},
{0.4161,0.1781},
{0.399721,0.164542},
{0.400053,0.152977},
{0.399903,0.144496},
{0.5689,0.1341},
{0.635688,0.0504},
{0.6327,0.0504},
{0.633949,0.0535},
{0.638435,0.0535},
{0.641997,0.0504},
{0.641714,0.0535},
{0.647259,0.0535},
{0.648109,0.0504},
{0.649831,0.0535},
{0.652419,0.0504},
{0.654381,0.0535},
{0.65765,0.0504},
{0.65869,0.0535},
{0.643009,0.0451},
{0.647892,0.0451},
{0.644608,0.0404},
{0.6669,0.0404},
{0.614659,0.082},
{0.621372,0.082},
{0.620882,0.0773},
{0.6434,0.07965},
{0.614136,0.0773},
{0.608562,0.082},
{0.608128,0.0773},
{0.637701,0.0404},
{0.639749,0.0451},
{0.635032,0.0451},
{0.631867,0.0404},
{0.630764,0.0451},
{0.577736,0.033438},
{0.5987,0.0338},
{0.5987,0.0291},
{0.577396,0.029497},
{0.578519,0.04249},
{0.5987,0.042},
{0.581387,0.040436},
{0.581409,0.035764},
{0.6669,0.0451},
{0.577608,0.05428},
{0.5979,0.0562},
{0.5979,0.0457},
{0.58119,0.050312},
{0.578678,0.045594},
{0.576792,0.058245},
{0.573068,0.061785},
{0.575971,0.066719},
{0.598,0.0668},
{0.573757,0.025535},
{0.576969,0.021055},
{0.5987,0.0209},
{0.6392,0.031},
{0.643348,0.031},
{0.637628,0.0279},
{0.634182,0.031},
{0.6333,0.0279},
{0.64235,0.0279},
{0.646788,0.0279},
{0.65063,0.031},
{0.6522,0.0279},
{0.655284,0.031},
{0.658003,0.0279},
{0.65907,0.031},
{0.69095,0.0483},
{0.697036,0.048232},
{0.693841,0.043569},
{0.6716,0.0437},
{0.6716,0.0484},
{0.700905,0.035768},
{0.694141,0.0358},
{0.7004,0.040481},
{0.706538,0.0404},
{0.707085,0.0357},
{0.728,0.0403},
{0.7279,0.0356},
{0.693692,0.0405},
{0.6717,0.03825},
{0.700799,0.0435},
{0.702051,0.0482},
{0.707612,0.0482},
{0.706592,0.0435},
{0.72785,0.04575},
{0.587289,0.095687},
{0.591234,0.092786},
{0.5705,0.0931},
{0.587839,0.099761},
{0.590673,0.101807},
{0.5705,0.1013},
{0.588012,0.084539},
{0.590336,0.081711},
{0.5708,0.082},
{0.589105,0.090102},
{0.5708,0.0901},
{0.597765,0.014698},
{0.600654,0.009717},
{0.596908,0.006222},
{0.5758,0.0148},
{0.5758,0.0066},
{0.591326,0.079597},
{0.595012,0.075615},
{0.591732,0.071155},
{0.57,0.0793},
{0.57,0.0711},
{0.403183,0.423295},
{0.476665,0.426885},
{0.403593,0.420503},
{0.390072,0.422257},
{0.390311,0.418725},
{0.403628,0.417833},
{0.476913,0.422299},
{0.477073,0.418661},
{0.4771,0.4161},
{0.403626,0.414219},
{0.403962,0.416315},
{0.390323,0.416345},
{0.390322,0.414341},
{0.384758,0.414167},
{0.384481,0.417298},
{0.371259,0.416046},
{0.371535,0.412883},
{0.361832,0.412606},
{0.361686,0.415614},
{0.357484,0.412491},
{0.357313,0.416011},
{0.361486,0.41794},
{0.357142,0.418998},
{0.389762,0.42034},
{0.38422,0.42233},
{0.384167,0.423707},
{0.371015,0.423014},
{0.371075,0.421023},
{0.384325,0.420203},
{0.38993,0.423685},
{0.37118,0.41887},
{0.361359,0.420524},
{0.35696,0.42102},
{0.361167,0.422307},
{0.589,0.122138},
{0.588915,0.118285},
{0.5874,0.12196},
{0.587181,0.117683},
{0.596514,0.120189},
{0.5959,0.123277},
{0.589,0.125263},
{0.595925,0.127062},
{0.589053,0.129023},
{0.596585,0.129952},
{0.588159,0.132275},
{0.596645,0.13337},
{0.5889,0.134},
{0.6064,0.122914},
{0.606435,0.120119},
{0.596471,0.116755},
{0.6068,0.1184},
{0.608321,0.120724},
{0.608261,0.12381},
{0.6064,0.126325},
{0.608225,0.126601},
{0.608648,0.129207},
{0.606586,0.130007},
{0.6082,0.1304},
{0.623025,0.123573},
{0.624335,0.121059},
{0.622901,0.120806},
{0.613116,0.121395},
{0.613066,0.124105},
{0.612819,0.119983},
{0.609,0.1192},
{0.583081,0.120377},
{0.583015,0.124462},
{0.587437,0.128058},
{0.583113,0.129919},
{0.613038,0.127361},
{0.612794,0.129607},
{0.6135,0.1297},
{0.62269,0.13019},
{0.623175,0.128109},
{0.624974,0.131009},
{0.625548,0.129193},
{0.636332,0.129506},
{0.6365,0.1321},
{0.5969,0.12467},
{0.623939,0.125125},
{0.625663,0.121865},
{0.6257,0.125956},
{0.636414,0.125345},
{0.636369,0.120413},
{0.624907,0.118544},
{0.638038,0.121792},
{0.6381,0.125979},
{0.637999,0.129802},
{0.6404,0.125806},
{0.640334,0.12204},
{0.64036,0.119943},
{0.6381,0.1192},
{0.640317,0.129479},
{0.5829,0.1184},
{0.695545,0.0231},
{0.689461,0.0231},
{0.696733,0.0325},
{0.702413,0.0231},
{0.707088,0.0325},
{0.706602,0.0231},
{0.712744,0.0231},
{0.716533,0.0325},
{0.718929,0.0231},
{0.725132,0.0325},
{0.724029,0.0231},
{0.72923,0.0231},
{0.734548,0.0325},
{0.735948,0.0231},
{0.74,0.0231},
{0.686443,0.0325},
{0.684395,0.0231},
{0.676966,0.0325},
{0.679103,0.0231},
{0.674095,0.0231},
{0.6713,0.0325},
{0.746858,0.014641},
{0.749799,0.023701},
{0.758305,0.026469},
{0.766569,0.02046},
{0.767034,0.011624},
{0.752096,0.006564},
{0.760975,0.006113},
{0.752106,0.073335},
{0.757905,0.078002},
{0.751745,0.068929},
{0.755302,0.065532},
{0.7579,0.0639},
{0.762095,0.062487},
{0.766937,0.0682},
{0.768756,0.069097},
{0.767005,0.073609},
{0.762316,0.079047},
{0.758267,0.079558},
{0.762861,0.086432},
{0.75746,0.086532},
{0.726683,0.080474},
{0.730822,0.083262},
{0.731376,0.08195},
{0.725557,0.077241},
{0.722558,0.07622},
{0.720436,0.071814},
{0.721428,0.069345},
{0.719292,0.067865},
{0.684626,0.134177},
{0.6848,0.136},
{0.687243,0.134303},
{0.68557,0.13693},
{0.68819,0.139648},
{0.688383,0.143145},
{0.695105,0.139843},
{0.693937,0.136771},
{0.696784,0.13897},
{0.693066,0.132256},
{0.690155,0.13111},
{0.696595,0.129721},
{0.699147,0.132246},
{0.696755,0.15617},
{0.6972,0.1541},
{0.695176,0.153784},
{0.691954,0.16023},
{0.694002,0.160451},
{0.619904,0.167355},
{0.6229,0.1655},
{0.620826,0.165062},
{0.61586,0.166263},
{0.621354,0.163226},
{0.614595,0.168572},
{0.609787,0.167262},
{0.61188,0.16215},
{0.614804,0.158818},
{0.616298,0.158926},
{0.609042,0.168622},
{0.7338,0.084},
{0.7341,0.0829},
{0.729481,0.079583},
{0.723834,0.072685},
{0.728987,0.073334},
{0.731595,0.076296},
{0.734876,0.075274},
{0.731782,0.07138},
{0.729782,0.069099},
{0.728978,0.067818},
{0.722327,0.066687},
{0.690298,0.160257},
{0.690025,0.153946},
{0.688233,0.150434},
{0.687414,0.157682},
{0.683972,0.156796},
{0.73428,0.081695},
{0.74428,0.068406},
{0.744455,0.073898},
{0.76284,0.055365},
{0.757439,0.055465},
{0.758028,0.06227},
{0.776023,0.07352},
{0.776014,0.068013},
{0.769027,0.073205},
{0.607994,0.161899},
{0.607302,0.158636},
{0.606826,0.16556},
{0.689562,0.149096},
{0.049515,0.097888},
{0.1084,0.0939},
{0.050155,0.09043},
{0.026048,0.101572},
{0.034094,0.104086},
{0.023378,0.114653},
{0.011031,0.122418},
{0.01678,0.127718},
{0.108,0.0869},
{0.1212,0.1095},
{0.1269,0.1048},
{0.114,0.0892},
{0.045246,0.150097},
{0.053146,0.152079},
{0.051852,0.147397},
{0.047011,0.145581},
{0.044026,0.1425},
{0.040181,0.144991},
{0.046991,0.130488},
{0.0439,0.1349},
{0.048331,0.137008},
{0.051754,0.133285},
{0.053025,0.126376},
{0.056482,0.13121},
{0.061632,0.125737},
{0.063046,0.131194},
{0.0568,0.1513},
{0.056414,0.147198},
{0.057096,0.175809},
{0.039425,0.177133},
{0.04562,0.185547},
{0.074798,0.17728},
{0.1058,0.1842},
{0.1048,0.1915},
{0.024017,0.176714},
{0.025028,0.16849},
{0.012937,0.164959},
{0.014926,0.153186},
{0.007504,0.153582},
{0.1115,0.1894},
{0.1259,0.1734},
{0.1201,0.1682},
{0.998596,0.0016},
{0.998458,0.001671},
{0.9986,0.0018},
{0.9984,0.001759},
{0.9986,0.001876},
{0.9984,0.001912},
{0.9986,0.0019},
{0.998481,0.002053},
{0.998669,0.0019},
{0.9986,0.00217},
{0.9987,0.0019},
{0.998682,0.0018},
{0.9987,0.0018},
{0.0553,0.1632},
{0.0735,0.1614},
{0.0677,0.1654},
{0.0676,0.1768},
{0.0535,0.1093},
{0.0777,0.1134},
{0.1,0.1083},
{0.099,0.0968},
{0.0543,0.0988},
{0.999,0.0016},
{0.9988,0.0017},
{0.9991,0.0017},
{0.0596,0.1464},
{0.0759,0.1543},
{0.067,0.1299},
{0.0803,0.1198},
{0.1218,0.1165},
{0.1212,0.1605},
{0.3546,0.0435},
{0.3443,0.0435},
{0.3443,0.0537},
{0.3546,0.0537},
{0.3546,0.0388},
{0.3443,0.0388},
{0.3593,0.0537},
{0.3593,0.0435},
{0.3443,0.0584},
{0.3546,0.0584},
{0.3396,0.0435},
{0.3396,0.0537},
{0.0865,0.1669},
{0.0855,0.1782},
{0.075,0.1652},
{0.2835,0.3018},
{0.2835,0.2916},
{0.2732,0.2916},
{0.2732,0.3018},
{0.2882,0.3018},
{0.2882,0.2916},
{0.2732,0.3065},
{0.2835,0.3065},
{0.2685,0.2916},
{0.2685,0.3018},
{0.2835,0.2869},
{0.2732,0.2869},
{0.9988,0.002},
{0.3496,0.2773},
{0.3039,0.277},
{0.3038,0.2878},
{0.3495,0.2881},
{0.3559,0.2882},
{0.356,0.2773},
{0.3496,0.2709},
{0.304,0.2706},
{0.3038,0.2942},
{0.3495,0.2945},
{0.2976,0.2769},
{0.2975,0.2878},
{0.999,0.0021},
{0.9991,0.002},
{0.2467,0.27},
{0.2228,0.27},
{0.2228,0.2771},
{0.2467,0.2771},
{0.215923,0.210175},
{0.2153,0.1842},
{0.214478,0.209858},
{0.231737,0.217531},
{0.236378,0.217753},
{0.249793,0.218653},
{0.254071,0.21665},
{0.263303,0.214823},
{0.271074,0.209876},
{0.31775,0.250976},
{0.3328,0.2439},
{0.280409,0.244673},
{0.299332,0.252443},
{0.315069,0.259451},
{0.29336,0.258248},
{0.2766,0.2512},
{0.28988,0.149292},
{0.2907,0.161},
{0.2978,0.1611},
{0.3049,0.1612},
{0.312,0.1613},
{0.3008,0.1358},
{0.3127,0.1117},
{0.3009,0.127},
{0.289,0.1114},
{0.2919,0.1269},
{0.2917,0.1356},
{0.278141,0.1113},
{0.273062,0.136981},
{0.260788,0.1112},
{0.258726,0.133922},
{0.247324,0.137391},
{0.243456,0.1113},
{0.231618,0.149275},
{0.2326,0.1113},
{0.2299,0.1357},
{0.2297,0.1268},
{0.2207,0.1269},
{0.2089,0.1116},
{0.2208,0.1358},
{0.2096,0.1613},
{0.2167,0.1612},
{0.2238,0.1611},
{0.2309,0.161},
{0.3816,0.1038},
{0.382229,0.091082},
{0.329166,0.104178},
{0.365375,0.08016},
{0.352136,0.078278},
{0.341951,0.081333},
{0.32797,0.091185},
{0.339851,0.073428},
{0.352641,0.068285},
{0.368897,0.072812},
{0.366451,0.110854},
{0.347931,0.112201},
{0.36373,0.119373},
{0.341841,0.117912},
{0.325,0.1105},
{0.3326,0.194},
{0.2791,0.1947},
{0.2707,0.1842},
{0.2883,0.1559},
{0.288848,0.179938},
{0.2893,0.1553},
{0.281219,0.151217},
{0.261659,0.148268},
{0.268297,0.147401},
{0.250559,0.148503},
{0.244771,0.151232},
{0.234424,0.155532},
{0.3165,0.31},
{0.311867,0.302133},
{0.3038,0.31},
{0.31176,0.31806},
{0.3187,0.3122},
{0.3188,0.3078},
{0.3016,0.3121},
{0.30824,0.31806},
{0.3017,0.3077},
{0.336051,0.250751},
{0.384846,0.11075},
{0.1848,0.2771},
{0.1848,0.27},
{0.2082,0.2349},
{0.223067,0.24242},
{0.242271,0.243856},
{0.260998,0.235162},
{0.2848,0.27},
{0.2848,0.2771},
{0.2614,0.3123},
{0.246463,0.304752},
{0.22723,0.303344},
{0.208602,0.312032},
{0.2885,0.329},
{0.29692,0.3247},
{0.2889,0.3164},
{0.280733,0.3243},
{0.2861,0.3314},
{0.2909,0.3315},
{0.297,0.32078},
{0.2914,0.314},
{0.2865,0.3139},
{0.9982,0.0025},
{0.9982,0.0023},
{0.9977,0.0023},
{0.9977,0.0025},
{0.620383,0.0891},
{0.6008,0.0892},
{0.6009,0.1068},
{0.620675,0.1066},
{0.62505,0.089},
{0.625737,0.106535},
{0.6295,0.089},
{0.6297,0.1065},
{0.6324,0.089},
{0.6325,0.1065},
{0.6376,0.0889},
{0.6378,0.1065},
{0.6903,0.0972},
{0.6735,0.0972},
{0.6735,0.1063},
{0.6903,0.1023},
{0.692901,0.108682},
{0.6914,0.1047},
{0.6935,0.1064},
{0.69741,0.107492},
{0.6961,0.107},
{0.6987,0.1064},
{0.700804,0.104704},
{0.7058,0.1135},
{0.708392,0.114092},
{0.702775,0.11172},
{0.7032,0.1141},
{0.7011,0.1157},
{0.6832,0.1142},
{0.7,0.1181},
{0.6832,0.1233},
{0.7,0.1233},
{0.9977,0.0019},
{0.9982,0.0019},
{0.55795,0.206442},
{0.501192,0.206458},
{0.557937,0.212053},
{0.5613,0.2064},
{0.5613,0.210771},
{0.561825,0.2146},
{0.55795,0.220252},
{0.5011,0.218342},
{0.501083,0.211786},
{0.4978,0.210229},
{0.4978,0.2064},
{0.557965,0.233463},
{0.501123,0.234577},
{0.557935,0.241359},
{0.56195,0.236},
{0.5613,0.241893},
{0.501116,0.241475},
{0.497647,0.23609},
{0.497531,0.233294},
{0.5011,0.229142},
{0.55795,0.226858},
{0.5613,0.226911},
{0.561474,0.233318},
{0.49655,0.2146},
{0.4966,0.2172},
{0.4978,0.220989},
{0.5011,0.223742},
{0.4978,0.226388},
{0.5624,0.2172},
{0.56126,0.221511},
{0.4978,0.242589},
{0.742461,0.058387},
{0.7425,0.0533},
{0.7297,0.053167},
{0.738355,0.048238},
{0.731927,0.049074},
{0.7297,0.05732},
{0.732373,0.062274},
{0.737831,0.063282},
{0.652771,0.151203},
{0.65675,0.14583},
{0.647192,0.150855},
{0.643933,0.146167},
{0.656073,0.139993},
{0.64356,0.14268},
{0.645147,0.137853},
{0.650269,0.135721},
{0.6779,0.0812},
{0.664984,0.075424},
{0.6631,0.0849},
{0.656482,0.081676},
{0.6531,0.0832},
{0.650218,0.081476},
{0.6741,0.0897},
{0.6579,0.0965},
{0.6492,0.092},
{0.646235,0.090866},
{0.6491,0.035767},
{0.6349,0.0342},
{0.6349,0.0361},
{0.6428,0.0189},
{0.6429,0.0169},
{0.6321,0.0166},
{0.6321,0.0186},
{0.67785,0.0603},
{0.6645,0.0586},
{0.6644,0.0606},
{0.6905,0.0619},
{0.6906,0.06},
{0.702533,0.061867},
{0.7122,0.0771},
{0.7012,0.082},
{0.703083,0.091374},
{0.697055,0.08567},
{0.688602,0.084893},
{0.6912,0.0837},
{0.6859,0.07545},
{0.696,0.0704},
{0.6838,0.0758},
{0.6882,0.0857},
{0.716,0.0857},
{0.6465,0.017},
{0.649432,0.019087},
{0.652074,0.017159},
{0.660473,0.019399},
{0.660569,0.017399},
{0.6533,0.010986},
{0.6421,0.01},
{0.6437,0.0119},
{0.6406,0.0119},
{0.631,0.0101},
{0.631,0.012},
{0.6279,0.011186},
{0.6732,0.1163},
{0.6694,0.1078},
{0.6584,0.1126},
{0.660285,0.122076},
{0.651857,0.115824},
{0.6485,0.1143},
{0.6445,0.1055},
{0.6533,0.101},
{0.641535,0.106634},
{0.706769,0.055398},
{0.720967,0.054767},
{0.706872,0.053498},
{0.698274,0.055019},
{0.695832,0.052948},
{0.6927,0.0548},
{0.6891,0.0546},
{0.6892,0.0527},
{0.6784,0.0522},
{0.6783,0.0541},
{0.665,0.05255},
{0.6448,0.0058},
{0.6448,0.0038},
{0.6321,0.0048},
{0.6569,0.004533},
{0.736,0.1044},
{0.7398,0.0959},
{0.726883,0.090126},
{0.725,0.0995},
{0.720896,0.095889},
{0.712405,0.096607},
{0.7151,0.0979},
{0.70975,0.1061},
{0.7199,0.1112},
{0.7076,0.1057},
{0.712,0.0959},
{0.64,0.022},
{0.63845,0.02395},
{0.649643,0.022757},
{0.6369,0.022},
{0.6273,0.0221},
{0.6273,0.024},
{0.6527,0.0238},
{0.6527,0.0219},
{0.645518,0.116024},
{0.1966,0.18},
{0.1966,0.1692},
{0.1371,0.1692},
{0.1371,0.18},
{0.0844,0.0557},
{0.085511,0.015468},
{0.073142,0.032474},
{0.0735,0.0558},
{0.072832,0.006168},
{0.093842,0.007657},
{0.023294,0.031557},
{0.023341,0.005341},
{0.0122,0.055},
{0.023,0.055},
{0.010861,0.01499},
{0.006561,0.009182},
{0.002,0.00726},
{0.328809,0.010991},
{0.32972,0.005572},
{0.22228,0.005615},
{0.226168,0.017724},
{0.325886,0.017941},
{0.3058,0.0528},
{0.2463,0.0528},
{0.193459,0.19466},
{0.195075,0.1872},
{0.169534,0.185726},
{0.169304,0.196149},
{0.1921,0.2016},
{0.1325,0.2018},
{0.1326,0.2085},
{0.1921,0.2082},
{0.0651,0.0558},
{0.065143,0.032457},
{0.0585,0.0559},
{0.0497,0.0061},
{0.0652,0.0064},
{0.031276,0.031676},
{0.0381,0.055},
{0.0465,0.0051},
{0.031,0.0056},
{0.156459,0.1867},
{0.131829,0.1866},
{0.132359,0.195609},
{0.157646,0.195794},
{0.1896,0.1125},
{0.1301,0.1125},
{0.1185,0.1326},
{0.2012,0.1326},
{0.2012,0.141},
{0.1185,0.141},
{0.1301,0.161},
{0.1896,0.161},
{0.0314,0.055},
{0.2152,0.0051},
{0.1057,0.0051},
{0.1307,0.0491},
{0.1902,0.0491},
{0.148,0.0677},
{0.1478,0.092},
{0.2395,0.092},
{0.2392,0.0677},
{0.2189,0.3928},
{0.219487,0.386941},
{0.2,0.3868},
{0.182291,0.375531},
{0.1845,0.3713},
{0.22,0.3819},
{0.1915,0.4056},
{0.194144,0.411207},
{0.301069,0.399559},
{0.3006,0.4047},
{0.1957,0.4161},
{0.3017,0.3937},
{0.338309,0.410969},
{0.336,0.4152},
{0.329,0.3809},
{0.326404,0.375293},
{0.3248,0.3704},
{0.1457,0.0936},
{0.1462,0.0661},
{0.1376,0.1013},
{0.2497,0.1013},
{0.2415,0.0936},
{0.2487,0.0583},
{0.2411,0.0661},
{0.1385,0.0583},
{0.3228,0.4004},
{0.3417,0.4063},
{0.1788,0.3802},
{0.3985,0.1871},
{0.3985,0.1754},
{0.387105,0.1754},
{0.385696,0.1871},
{0.36999,0.1754},
{0.368759,0.1871},
{0.357628,0.1754},
{0.35677,0.1871},
{0.345654,0.1754},
{0.344414,0.1871},
{0.331056,0.1754},
{0.32982,0.1871},
{0.318688,0.1754},
{0.317812,0.1871},
{0.306233,0.1754},
{0.306104,0.1871},
{0.3403,0.1917},
{0.3404,0.2034},
{0.358,0.2034},
{0.3817,0.2033},
{0.3993,0.1915},
{0.3993,0.2032},
{0.4002,0.2087},
{0.382252,0.208763},
{0.397504,0.21983},
{0.382222,0.230362},
{0.358507,0.208807},
{0.358596,0.230358},
{0.343379,0.221053},
{0.340611,0.208833},
{0.350873,0.230881},
{0.363812,0.237569},
{0.358567,0.234933},
{0.3822,0.2349},
{0.375687,0.238029},
{0.387058,0.233139},
{0.594184,0.174667},
{0.592348,0.175539},
{0.593697,0.17776},
{0.595878,0.174078},
{0.59764,0.17612},
{0.625,0.1459},
{0.624737,0.148843},
{0.62627,0.148651},
{0.62591,0.150026},
{0.62791,0.150486},
{0.628474,0.149295},
{0.629926,0.150787},
{0.631083,0.148062},
{0.627516,0.146401},
{0.592229,0.174086},
{0.594038,0.172807},
{0.626438,0.173213},
{0.625,0.176},
{0.628209,0.175175},
{0.629293,0.171813},
{0.6318,0.1734},
{0.607955,0.143033},
{0.6062,0.1454},
{0.607544,0.145549},
{0.609847,0.146232},
{0.607338,0.146995},
{0.61198,0.144575},
{0.611621,0.147559},
{0.60945,0.148292},
{0.609273,0.147111},
{0.627797,0.17139},
{0.62572,0.17184},
{0.6248,0.1729},
{0.429934,0.12479},
{0.483676,0.1244},
{0.4762,0.0542},
{0.47635,0.0503},
{0.489586,0.050232},
{0.491716,0.124341},
{0.500241,0.1243},
{0.501673,0.05016},
{0.507495,0.1242},
{0.512856,0.0501},
{0.5137,0.0539},
{0.5542,0.0536},
{0.5547,0.1239},
{0.4357,0.0545},
{0.426804,0.0507},
{0.4357,0.0506},
{0.422745,0.1248},
{0.416447,0.050768},
{0.414059,0.1249},
{0.406466,0.050825},
{0.405632,0.124957},
{0.3982,0.0547},
{0.3982,0.0509},
{0.506203,0.201071},
{0.561773,0.201127},
{0.561997,0.181929},
{0.566973,0.196293},
{0.567147,0.18772},
{0.506833,0.181679},
{0.500962,0.194931},
{0.501359,0.186221},
{0.48136,0.187223},
{0.4765,0.1871},
{0.480653,0.209379},
{0.491413,0.191745},
{0.491797,0.20349},
{0.4765,0.2094},
{0.4346,0.2094},
{0.4346,0.1871},
{0.4306,0.1871},
{0.4306,0.2094},
{0.6066,0.06075},
{0.6121,0.06075},
{0.612961,0.050611},
{0.60585,0.0511},
{0.6064,0.0497},
{0.606,0.0511},
{0.6124,0.0497},
{0.6186,0.06075},
{0.6241,0.06075},
{0.624961,0.050646},
{0.61785,0.0511},
{0.6184,0.0498},
{0.618,0.0511},
{0.6244,0.0498},
{0.6129,0.0395},
{0.61274,0.0395},
{0.6121,0.00465},
{0.6066,0.00465},
{0.605821,0.039989},
{0.6124,0.0409},
{0.6064,0.0409},
{0.6249,0.0396},
{0.62474,0.0396},
{0.6241,0.00465},
{0.6186,0.00465},
{0.617821,0.040054},
{0.6244,0.0409},
{0.6184,0.0409},
{0.612633,0.0511},
{0.6061,0.0395},
{0.624633,0.0511},
{0.6181,0.0396},
{0.9974,0.0041},
{0.9974,0.004},
{0.9962,0.00396},
{0.9962,0.004133},
{0.9962,0.0042},
{0.995839,0.004179},
{0.9974,0.0038},
{0.9974,0.0036},
{0.9962,0.0036},
{0.9962,0.003833},
{0.9962,0.0038},
{0.9959,0.00384},
{0.9955,0.0041},
{0.9958,0.003967},
{0.9959,0.004},
{0.9955,0.004},
{0.9955,0.0038},
{0.9959,0.0036},
{0.9959,0.0036},
{0.9955,0.0036},
{0.594801,0.166516},
{0.5951,0.164},
{0.592989,0.164326},
{0.591355,0.166697},
{0.59027,0.164177},
{0.591495,0.163266},
{0.593751,0.162677},
{0.5887,0.1664},
{0.705282,0.143996},
{0.704034,0.146936},
{0.705438,0.14636},
{0.705997,0.147687},
{0.708151,0.146355},
{0.708576,0.147937},
{0.7097,0.1471},
{0.709473,0.144115},
{0.590704,0.162099},
{0.670715,0.155188},
{0.674284,0.155012},
{0.673026,0.152742},
{0.670341,0.152518},
{0.672795,0.151419},
{0.6695,0.1508},
{0.668673,0.152354},
{0.6682,0.1549},
{0.658079,0.159158},
{0.658237,0.161545},
{0.660893,0.161775},
{0.658467,0.162871},
{0.660748,0.163772},
{0.662531,0.161938},
{0.662305,0.159291},
{0.422068,0.206795},
{0.418038,0.197786},
{0.422584,0.189392},
{0.563212,0.036529},
{0.56394,0.033763},
{0.559233,0.034028},
{0.558503,0.032455},
{0.564,0.0325},
{0.556358,0.041136},
{0.561092,0.040309},
{0.557233,0.040054},
{0.552703,0.039705},
{0.554584,0.038022},
{0.5579,0.037967},
{0.561542,0.038698},
{0.555288,0.03557},
{0.554827,0.033292},
{0.548108,0.032943},
{0.542584,0.034502},
{0.543697,0.032667},
{0.537028,0.033135},
{0.535966,0.031708},
{0.531176,0.031827},
{0.533591,0.034613},
{0.528381,0.033159},
{0.521746,0.03242},
{0.520895,0.033393},
{0.522189,0.035392},
{0.51318,0.033048},
{0.514413,0.030871},
{0.546865,0.036962},
{0.547174,0.035448},
{0.542237,0.03623},
{0.548605,0.040863},
{0.542847,0.039835},
{0.543969,0.03766},
{0.54246,0.04123},
{0.53505,0.041026},
{0.539374,0.038614},
{0.534361,0.036881},
{0.528798,0.035169},
{0.523543,0.036912},
{0.520465,0.037083},
{0.515035,0.034586},
{0.512435,0.035614},
{0.512807,0.038096},
{0.521822,0.038849},
{0.514885,0.039383},
{0.513517,0.040348},
{0.519155,0.040874},
{0.521832,0.040561},
{0.528017,0.039506},
{0.531199,0.041512},
{0.53373,0.038875},
{0.529303,0.037886},
{0.498506,0.042438},
{0.50226,0.041819},
{0.498059,0.040764},
{0.492298,0.041942},
{0.492064,0.038847},
{0.497835,0.038908},
{0.502266,0.03878},
{0.500484,0.035594},
{0.495535,0.036238},
{0.495483,0.034389},
{0.499465,0.033155},
{0.487,0.036796},
{0.487504,0.035299},
{0.489466,0.033909},
{0.47752,0.03406},
{0.480258,0.035981},
{0.46835,0.03569},
{0.463837,0.034139},
{0.4689,0.033942},
{0.484283,0.041873},
{0.48619,0.040099},
{0.479717,0.040682},
{0.4801,0.037871},
{0.476915,0.04346},
{0.474243,0.041877},
{0.467926,0.040586},
{0.464832,0.038242},
{0.472072,0.037742},
{0.467898,0.042388},
{0.462204,0.040758},
{0.449736,0.039443},
{0.449988,0.037205},
{0.464675,0.036623},
{0.450153,0.035395},
{0.450199,0.033701},
{0.462549,0.043246},
{0.460277,0.041994},
{0.449521,0.042032}
};


// normal array: 62kb.
const tgx::fVec3 R2D2_norm_array[5314] PROGMEM = {
{0.7308363198133921,-0.6709333428609808,0.12540623221756894},
{0.6572847840333724,-0.6924839691816681,0.2973931154290658},
{0.7282170222718457,-0.6724157179011111,-0.13250309729609938},
{0.32449560960410284,-0.9458872022327299,-0.0},
{0.5777795209678125,-0.6770760014664345,0.4557838450279144},
{9.999999900000002e-05,-0.9999999900000002,-9.999999900000002e-05},
{-0.000499999687500293,-0.999999375000586,0.000999999375000586},
{0.4568931946265487,-0.6746899505680289,0.5796913655614145},
{-0.00019999998000000302,-0.999999900000015,0.00039999996000000603},
{0.14350372899284744,-0.8647224701053323,-0.48131250706799633},
{9.999999500000039e-05,-0.999999950000004,0.00029999998500000117},
{-0.6590308697289241,-0.6854321063918127,0.3096145026829665},
{0.518301728539147,-0.8038026806864101,0.29200097382487156},
{-0.0,-0.9999999800000006,0.0001999999960000001},
{-0.0005999998890000307,-0.9999998150000513,9.999998150000513e-05},
{0.3816165930502066,-0.8642375778668463,-0.3278142536736313},
{-0.0,-0.999999995,9.999999950000001e-05},
{0.09470497308870876,-0.9600504135708596,-0.26331382697209094},
{-0.0005999998650000455,-0.999999775000076,-0.00029999993250002274},
{-0.00019999998700000128,-0.9999999350000064,0.0002999999805000019},
{-0.0005999998170000836,-0.9999996950001395,-0.0004999998475000698},
{-9.999998700000255e-05,-0.9999998700000254,-0.0004999999350000127},
{-0.5093951378466137,-0.6891934216801849,0.5152950815319199},
{-0.6240924298047394,-0.6772917845004808,0.38959527423798507},
{0.0001999997070006439,-0.9999985350032193,-0.001699997509505473},
{-0.0,-1.0,0.0},
{-0.5793972507665677,-0.6776967843363874,-0.452797851479292},
{-0.7295102387480519,-0.6678093727703207,0.14780207441667176},
{-0.73110638258658,-0.670205850922618,-0.1277011148355988},
{-0.6576727893512492,-0.6914713909630361,-0.29888763377997324},
{0.9771142757438537,-0.02990043684857356,-0.21060307693343117},
{0.9097081237298175,0.2558022843245986,-0.3271029210421274},
{0.9686048769378331,0.08140040985209542,-0.2349011827304326},
{0.9941816426054524,-0.0019999630710228374,0.1076980113745798},
{0.9699256936719425,-0.21260563199778842,0.11850313918973625},
{0.9994357504562021,0.018700668934891918,-0.02790099803654997},
{0.9471954108493517,-0.24959879069678859,-0.20129902470858793},
{0.9690639030419049,-0.24629082583760312,-0.015999404033299434},
{0.9639885382444199,0.2262973093409878,0.1396983389966239},
{0.8874082307495105,-0.3690034225226159,0.2763025627181539},
{0.9993092486498946,0.008400077743079269,0.03620033503565114},
{0.9888822497229247,0.0009999820504832892,0.1486973309068651},
{0.6635946116336302,-0.3241973675280635,0.6741945255626787},
{0.7857771774333173,0.32509055788186747,0.5261847171868307},
{0.8590944545631937,-0.31589796088524374,0.40269740059666875},
{0.49501071214771764,-0.7046152480389533,0.5084110021331305},
{0.8904696087908691,-0.011999590460966231,-0.45488447505779495},
{0.8204055705727363,0.3249022060934691,-0.47050319472753827},
{0.9039893103896066,-0.04579945842460617,-0.4250949732816612},
{0.9237155416447334,-0.011500193492383279,-0.382906442455092},
{0.9736297691852963,-0.03250099373307532,0.22580690415164328},
{0.9646296097603143,0.21130648615214015,0.15760483775474343},
{0.850287594394496,0.2502963482029194,0.46299324497783334},
{0.7194860600926273,-0.6874866800746091,0.09849809161796218},
{0.9254118083300119,0.2456031339159833,0.2886036826064853},
{0.9692137580869447,-0.007600107884297131,0.24610349346388477},
{0.7259899741476851,-0.686090525155271,-0.04709934956247379},
{0.805411690635535,-0.1334019363431591,-0.5775083825950105},
{0.7111727163820941,0.327687428512953,-0.62197613834317},
{0.7163565865245707,-0.015699048587989612,-0.6975577257950034},
{0.584395263495584,0.3150974461455484,-0.7477939391546846},
{0.6468231178713565,-0.03520125811544797,-0.7618272281917121},
{0.6376975926961314,-0.024499907513023708,-0.7698970936439572},
{0.7328191121716714,0.0028000730268568233,-0.680417745526208},
{0.7075936246101633,-0.43749605817827364,-0.5548950004185692},
{0.8028880009284886,0.2021969781887413,-0.5607916190318799},
{0.8798141915173646,-0.0031000500042098547,-0.4753076667744981},
{0.5135840380561418,-0.03379894954497195,-0.857373353250265},
{0.42700565786245026,0.31310414865745473,-0.8483112401983995},
{0.33031918054009324,-0.014700853629849745,-0.9437548007135513},
{0.3136123236383908,0.014700577670549568,-0.9494373088720927},
{0.21050799419287208,0.1574059776055015,-0.9648366403671401},
{0.13740565504610253,-0.023300958970700066,-0.9902407541968757},
{-0.03680114747766781,-0.04220131585754298,-0.998431131568031},
{-0.05259767391930524,-0.036298394738988216,-0.9979558663776926},
{-0.29829581046476283,-0.023399671353923734,-0.9541865985433345},
{-0.2651033787640937,0.3213040950467872,-0.9091115867010093},
{-0.4357237432336708,-0.055803040790541276,-0.8983489523681581},
{-0.5185841289755952,-0.00949970926584681,-0.8549738339262128},
{-0.5683124859624764,-0.017900393275960456,-0.8226180731176018},
{-0.6354002096821038,-0.02730000900900446,-0.771700254661126},
{-0.7288654999680692,-0.016099237960606274,-0.6844676014928568},
{-0.6501151446086926,0.34140795319090544,-0.6788158131985549},
{-0.46641061096210046,-0.6985158914172968,-0.5427123468463377},
{-0.7325900075404452,0.010399858146902306,-0.6805907168059336},
{-0.8120093341009436,-0.2774031887679824,-0.5135059027842789},
{-0.6601384277763539,-0.0006000349290498596,-0.7511437253489158},
{-0.734763468468499,0.4185791887600894,-0.5337734614432292},
{-0.8072950351508007,0.3325979545288695,-0.48749700190265743},
{-0.92563446664106,-0.001900070750451614,-0.37841409051099517},
{-0.7427243246199535,-0.27610904271922604,-0.6100199784814483},
{-0.9719264707779024,-0.03540096415838846,-0.23260633511980666},
{-0.9797934305070726,-0.027599814943861198,0.19809867175285883},
{-0.9854866221099068,-0.01889974343772424,0.16869770994413116},
{-0.9993373259461991,-0.006000224112555984,0.03590134094012664},
{-0.96935616670519,0.24518891280803853,-0.015199312702619028},
{-0.7257173085642163,-0.6866163759958536,0.04350103751211714},
{-0.9456664341656184,0.24949114446898782,-0.20849259968650885},
{-0.717500821538911,-0.689500789478856,-0.09890011324069449},
{-0.9660151424060367,0.20730324950390416,0.15440242027690693},
{-0.9882201944860136,0.0033000674375671373,0.15300312665083998},
{-0.9619521873217817,-0.1815098471763212,-0.20421107875154154},
{-0.8542156920863968,-0.5199095508261738,-0.0031000569485692226},
{-0.9692898370493377,0.00779991821828622,0.24579742282753242},
{-0.9249406104090196,-0.2477108759847704,0.2883126586451728},
{-0.9387885750125629,-0.22929720946994106,0.2570968711501171},
{-0.8512859326161942,-0.2505958589376463,0.4609923821638266},
{-0.8753026828068342,0.271300831538323,0.4003012269251408},
{-0.9650289706045528,-0.21140634651378495,0.15500465330953958},
{-0.619780771599837,-0.3300897591240823,0.7119779112279508},
{-0.6757201806845488,0.3153094168563538,0.6663198999409721},
{-0.81190064140176,-0.12840010143612018,-0.5695004499055332},
{-0.8058827099719345,0.22589515347147288,-0.5472882580563838},
{-0.886906443398717,-0.006500047223014614,-0.46190335574006924},
{-0.8264882598176533,0.4909930254936089,-0.2753960880263541},
{-0.8656280381462407,0.013100424329616167,-0.5005162119826634},
{-0.8064714715762805,0.13489522816570396,-0.5756796356930747},
{-0.5689066164224237,-0.5452063407866152,-0.615707160715919},
{-0.7687181073682811,-0.5458128567732636,-0.3334078535144853},
{-0.8611992550629665,-0.3169997257953558,0.3972996563359459},
{-0.7758892501289087,0.31309566208965245,0.5476924117742019},
{-0.6634334644279398,0.24601240917888637,0.7066356436008174},
{-0.8680788625370427,0.30779250534374125,0.38949051602140095},
{-0.6321096429061543,-0.010200155604560631,0.7748118198444683},
{-0.5810651284226952,-0.0030998139702466962,0.813851158188318},
{-0.5991661930013129,0.24888595700605276,0.7609570642089439},
{-0.5342884087387072,-0.005899872003665305,0.8452816618132682},
{-0.489693648714564,-0.5256931818036477,0.6955909782435179},
{-0.414507803182843,-0.015300288030633288,0.9099171293511915},
{-0.5554159934337997,-0.009000259166194088,0.8315239440767095},
{-0.3322009866383955,-0.07890023433404396,0.9399027915154362},
{-0.10689879953322183,-0.17809799997069045,0.9781890149990421},
{-0.21679927047168232,-0.020699930344851587,0.9759967157765772},
{0.039400924159514364,-0.0003000070367475713,0.9992234370605776},
{-0.1849963583825275,-0.06509871854433806,0.980580697458954},
{0.18450711196369862,-0.06710258651904703,0.9805377955577588},
{-0.5090205419384634,0.590223818962831,0.6265252839380103},
{0.2557047382527001,-0.06860127119333292,0.9643178689756697},
{0.37817504694276405,-0.3506768613506805,0.8567434696471715},
{0.4818919356059359,0.3280945093843278,0.8124864031538139},
{0.6562981295529962,0.0023999931600292407,0.7544978496841925},
{0.6553917945460982,0.012199847258868475,0.7551905450735632},
{0.6094903396546741,0.0030999508661681534,0.7927874344187459},
{0.6596938153994708,0.00789992593854149,0.7514929547865732},
{0.7329170808316056,0.0017000396198850174,0.6803158549457515},
{0.5679803908155048,-0.02109927156022386,0.8227715943010516},
{0.4733819928914791,0.029398881687810487,0.880366511494842},
{0.355508621188597,0.009700235233556656,0.9346226648744381},
{0.33301361220960435,-0.018600760321617536,0.9427385352252071},
{0.13900237140068433,0.012200208137326252,0.9902168932442994},
{0.06579693261850032,0.012599412629074531,0.9977534858167117},
{-0.10510140258757636,0.06830091148174562,0.992113239839529},
{-0.26769306817774813,0.007499805795043373,0.9634750511365721},
{-0.23390882905538218,-0.0611023063500806,0.9703366260471883},
{-0.41279106523408843,0.06669855632537232,0.9083803383203631},
{-0.07320212984695229,0.05260153046379359,0.9959289769751337},
{-0.5846166939680478,-0.07620217598420329,0.8077230648614303},
{-0.4521045188072484,0.025200251877776286,0.8916089116756085},
{-0.50910487215694,0.4827046195053131,0.7126068196798967},
{-0.5709079299662212,0.0021000291696077504,0.8210114039276014},
{-0.38618655128752305,0.028898993610070988,0.9219678930271783},
{-0.27098429691497755,0.4036766076183632,0.8738493618966747},
{-0.08239628153971927,0.11049501347256042,0.9904553017608245},
{-0.21659768674905816,-0.03619961339019347,0.9755895807589159},
{0.05169868635306944,0.10919722533375596,0.9926747764543914},
{0.1176021397904004,0.03840069870706952,0.9923180553912783},
{0.1882078183151626,0.023800988713607172,0.9818407865134252},
{0.30449113030255953,0.016499519376000762,0.9523722578001895},
{0.42808822345495684,-0.037098979421113995,0.9029751594950387},
{0.5961082680790177,0.01760024411707887,0.8027111336806367},
{0.48328597041191546,0.5698834565233821,0.6645807075020878},
{0.6183902882567838,-0.05579912368164382,0.7838876891405123},
{0.5811239602348309,-0.09080374391554405,0.808733344763221},
{0.25819411195041464,-0.1965955166903622,0.9458784294883704},
{0.7710134273157561,-0.6276109299395183,-0.10790187912758765},
{0.9943806047954534,-0.09809808661548068,0.039799223723711835},
{0.06399952352532103,-0.5639958010668915,-0.82329387059995},
{-0.14669856162765482,-0.3743963290619902,-0.9155910226740338},
{-0.7664667743854799,0.13389419581241457,-0.6281727693006635},
{-0.3505902870306449,-0.9206744930664994,-0.17159524601956264},
{-0.4492966886956064,0.8636936346013694,-0.22839831671060873},
{-0.8198031767434648,-0.5095019743239757,-0.2614010129308877},
{-0.8860896948367731,0.45139475030958065,-0.1052987753823634},
{-0.9867492054759771,-0.1467073157427038,0.06930345590299505},
{-0.861219201096135,0.4706104923778927,0.19190427855358608},
{-0.8963750990456179,0.28059220525680545,0.34319046630126737},
{-0.8517463618162449,0.1967107072552018,0.48562643336617173},
{-0.8258700792690323,0.30338900841533406,0.4752827808167709},
{-0.6935986613558753,0.40709921429927465,0.5942988530043206},
{-0.7350097977459064,0.13970186223823552,0.6635088446318488},
{-0.6141873478709495,0.1683965310671897,0.7709841178907556},
{-0.6057027438396444,0.19190086931290698,0.7722034980897695},
{-0.46537823709560144,-0.2793869347754857,0.8398607248315335},
{-0.19789622615495048,-0.2901944660442983,0.936282145269733},
{-0.3415890539541463,0.34768885848904174,0.8731720196509383},
{-0.3558126707148102,0.00670023859974488,0.9345332793226255},
{0.11540318055548478,-0.34460949756863135,0.931625675957449},
{-0.06310001198900342,0.4100000779000222,0.9099001728810493},
{0.09569831859531328,0.7407869844870227,0.6648883180148778},
{0.26449601010778107,0.3723943824731103,0.8895865806876447},
{0.40359644634893477,-0.3272971181615618,0.8543924771073586},
{0.3604951315461225,-0.017999756914924284,0.9325874054921328},
{0.9606197985780751,0.16010329976301252,0.22710468067570358},
{0.9184325039014798,-0.007100251282339402,0.39551399748806104},
{0.43940819723637986,0.8808164317838038,0.17630328896853384},
{0.7079329869060552,0.5926276141270354,0.3842179030502986},
{0.5915119900695593,0.7145144833553679,0.37360757310226095},
{0.7430236842574095,0.277508845735439,0.6090194128031795},
{0.6913884089704846,-0.09739836713006247,0.7158879982383134},
{0.5710925587124397,0.6508915189387621,0.5001934825213838},
{0.510702599482847,0.5098025949018121,0.6923035238339045},
{0.5642170819307372,-0.30650927970891695,0.7666232098690235},
{0.998139392348444,0.02850112481908692,0.05390212728943105},
{0.9728282270205164,0.0247007167016928,0.23020667954371182},
{0.9719829855867547,-0.005099910726844084,0.23499588643301167},
{0.0,1.0,0.0},
{0.011300354215154396,0.9999313433391931,-0.003100097174068905},
{0.9505333310356393,0.16510578953601687,-0.2631092260867719},
{0.909273931490071,0.07219793011501499,-0.40988824867236345},
{0.8766216133723198,0.2752067853069386,-0.3947097316884036},
{0.7465686597054846,0.40818286484299326,-0.5253779450967875},
{0.7548378032238018,0.362818170388971,-0.5464273657677335},
{0.6349988411281724,0.40359926343201635,-0.6586987978757908},
{0.6391339676773423,0.3579190221119086,-0.6807361786855999},
{0.49801015951088207,0.4072083071341992,-0.7656156187179344},
{0.4983879366659877,0.35889131314089684,-0.7891808981075391},
{0.34199777702167405,0.34419776272181346,-0.8743943164554144},
{0.09299857294784707,-0.9844848931952198,0.1487977167165553},
{0.5385926213316313,0.031199572568783692,0.8419884648370471},
{0.29169827023438627,0.7330956527556688,0.6143963566404077},
{0.0,0.999999995,9.999999950000001e-05},
{-0.0620988046095168,0.9646814300612053,0.25599507214229145},
{-0.090901863961831,0.3843078803138796,0.9187188385229279},
{-0.15589739185845114,0.7631872319844124,0.6270895088802738},
{0.0,0.9999999800000006,-0.0001999999960000001},
{-0.18269758018657556,0.9483874386915614,0.2591965669642057},
{-0.3137873467803565,0.7785686048540011,0.5434780846880936},
{-0.24749703624073643,0.9688883976309072,0.0006999916176505677},
{-0.6051868282520231,0.7919827626827534,0.08069824362184114},
{-0.6400687846065436,0.7682625327498944,-0.009199551348820811},
{-0.8550802264983908,0.4179903340852852,-0.30679290549608973},
{-0.4208153831875038,0.8808321994095849,-0.2169079292142813},
{-0.7779217587758938,0.3022084528886426,-0.550915409319501},
{-0.783637454847253,0.274813135007689,-0.5571266285035792},
{-0.6433974843207545,0.5148979867528077,-0.5664977849979911},
{-0.5836028479888473,0.28280138007410216,-0.7612037146831916},
{-0.43848802505555134,-0.4710871347860211,-0.7653790977822554},
{-0.36030073141122715,0.33030067051104167,-0.8724017709773926},
{-0.19309987351962427,0.4888996797708146,-0.8506994427920475},
{-0.002800046747170669,0.9999166937485543,-0.012600210362268011},
{0.0,0.999999995,-9.999999950000001e-05},
{0.002399937602433494,0.999974001013956,-0.0067998232068949005},
{0.0,0.9999999800000006,0.0001999999960000001},
{0.07210202825858276,0.9758274504122755,-0.2063058034638783},
{0.1621080521069272,-0.6379316868538486,-0.7528373943620901},
{0.09610603853210743,-0.8613541205796474,-0.49883134255791034},
{0.41737918164561627,0.026198693241770835,-0.9083546923978865},
{0.3552165161758883,-0.03460160883920533,-0.9341434340087198},
{0.5846988832261995,0.041299921117225996,-0.8101984525224335},
{0.2724961387570705,0.6834903150108539,-0.6771904042799566},
{0.5534173333023228,-0.03360105240144207,-0.8322260657285743},
{0.28170793018985385,-0.6785191005815259,-0.678419097766407},
{0.38677392264736854,-0.6809540882183506,-0.6218580726328814},
{0.12629712172139357,0.024999430269476163,-0.9916773999295804},
{-0.007199940096747591,0.11279906151571227,-0.9935917333511677},
{0.0823982589431826,-0.015499672495380222,-0.9964789446223479},
{-0.10069877853122458,-0.007599907813677327,-0.9948879320825753},
{-0.10869456866810208,0.03229838608996962,-0.9935503535292202},
{-0.4474921711929469,0.002499956263647748,-0.8942843546320725},
{-0.43740459058526737,-0.09040094876293592,-0.8947093900243227},
{-0.41220202803896694,0.03540017416928537,-0.9104044792010565},
{-0.33059768913022947,0.6218956529645786,-0.709895037851028},
{-0.40200475172424827,0.007000082741467009,-0.9156108225838847},
{-0.6020195900361949,-0.009400305890930617,-0.7984259812041494},
{-0.5092937331791696,0.0023999704685450755,0.8605894105124551},
{-0.49779887497581393,-0.012799971072098067,0.8671980401346441},
{-0.559996066041454,-0.04269970003566086,0.8273941875762483},
{-0.45189227496758866,0.026299550413028505,0.8916847567793733},
{-0.3900970079674233,-0.012199906427076556,0.9206929383122446},
{-0.3080863566977838,-0.0009999557179415249,0.9513578700495667},
{-0.39770956701870336,0.012800307915110392,0.9174220688533026},
{-0.2444048527065262,0.026200520216493398,0.9693192460246965},
{-0.21159993123003354,0.017499994312502775,0.9771996824101548},
{-0.16199671392998657,0.04239913994216933,0.9858800016269986},
{-0.2787980790878526,-0.03549975540752785,0.9596933877353376},
{-0.3997093812892696,0.020100471763608505,0.9164215086652155},
{-0.3929082786646481,-0.055201163100759926,0.917919340764267},
{-0.5238909105715518,-0.0004999913252257604,0.8517852216546054},
{-0.5807017159761061,0.148800439705949,0.8004023651924838},
{-0.6320891123588086,0.012999776080785494,0.7747866544148155},
{-0.680619353686487,0.004900139337443118,0.7326208323695569},
{-0.6503959805652602,-0.00019999876401145762,0.759595305715516},
{-0.5114909211167246,0.0025999538512287076,0.8592847478310879},
{-0.4677012698106713,-0.012200033123134894,0.8838023995267721},
{-0.07030005307656012,0.01580001192901351,0.9974007530378528},
{0.024998945316745163,-0.00769967515755751,0.9996578253260056},
{0.10459476359423771,0.018099093891545914,0.9943502191023897},
{0.1983045481669689,0.04680107339492761,0.9790224541374813},
{0.22830988717375073,0.009500411424225282,0.9735421601561381},
{-0.17630781589872205,0.03110137875468097,0.9838436147541846},
{0.34499391781084304,-0.015099733794039798,0.9384834546825397},
{0.34790795848557654,0.02400054901883828,0.9372214391856349},
{0.23860927611591704,0.012300478190384658,0.971037749826301},
{0.49767873215381236,0.06029742324467528,0.8652630237747515},
{0.5063242484489012,-0.001800086208192815,0.8623412985137024},
{0.628821682145407,-0.02240077239194834,0.7772267992420647},
{0.6603965890604262,0.0055999710762240865,0.7508961216315476},
{0.7287061758110102,-0.02400020340258576,0.6844058003637373},
{0.7310035344106334,0.009800047383343648,0.6823032989444257},
{0.6696632398453953,-0.0028998408176073563,0.7426592328403392},
{0.6329835521360938,0.03009921788198487,0.7735798987874916},
{0.5963069559612122,0.008700101487275775,0.8027093636593409},
{0.5450863021533382,-0.0012999673322314062,0.8383789318021624},
{0.5303772313941739,-0.012899446238659207,0.8476636105822798},
{0.4624089107055648,0.02490047983686973,0.8863170794946844},
{0.41570792138991386,0.022600430655309242,0.909217325301202},
{0.29860223803216107,-0.011600086942977457,0.9543071525589127},
{0.8148865626313723,0.005899902711406426,0.5795904426324008},
{0.8184022915296244,0.02720007616031987,0.5740016072067502},
{0.8839306464067755,-0.0013000450733440527,0.46761621253513774},
{0.874896163588734,0.01739992370150185,0.4839978776739596},
{0.6595136982417702,0.32140667568598175,0.6795141136547124},
{-0.04339813478824934,0.440381072828226,-0.8967614580207836},
{0.46978509865300233,0.01919939100497583,-0.8825720052599827},
{0.4670114302446346,-0.030600748962496396,-0.8837216293515708},
{0.7610199351783065,-0.44651169652708783,-0.47061232785139423},
{0.7231085435779138,0.47760564294400726,-0.4990058957894883},
{0.7624362127679086,0.6370302564705638,-0.11350539106657612},
{0.4953826098987139,-0.23469176129032732,-0.8363706397240297},
{0.001299991719079124,-0.47479697555289857,-0.880094393816567},
{0.3880097760294622,-0.2175054801196083,-0.89562256549481},
{0.4044071398710822,0.2337041260827693,-0.8842156109644186},
{0.4651944083968164,0.06539921390617325,-0.8827893889353171},
{-0.45970006665651447,0.446100064684514,-0.7679001113455242},
{0.016499950335224237,0.02309993046931393,-0.9995969912175847},
{-0.028699294293029896,-0.024999385272674125,-0.9992754281193301},
{0.45479117258900925,-0.44529135697864075,-0.7712850295028647},
{0.41049824922870054,0.47919795622507505,-0.7757966912341678},
{0.6263675268173363,0.6342671172736853,-0.45317650567307927},
{0.25159711545560687,-0.24659717277962107,-0.9358892700910273},
{-0.02819918322248677,-0.016199530787386018,-0.999471050740267},
{-0.4106842012826591,-0.4790815700864913,-0.7757701566960967},
{-0.6257035227207495,-0.6349035745171868,-0.45320255153754774},
{-0.06040136116001078,0.23290524857891576,-0.970621873210372},
{0.00829964598615053,0.06489723186761077,-0.9978574372987488},
{-0.7603990228878833,0.44599942689110467,-0.4720993933526693},
{-0.4430815548987963,0.023899005105125777,-0.8961626935235867},
{-0.4836086735993422,-0.025400455561255773,-0.8749156917536487},
{0.05130042528228839,-0.444703686608843,-0.8942074130101809},
{0.027398388885111022,0.4716722641279879,-0.8813481738444107},
{0.3530068395737757,0.6488125708653419,-0.6741130610670885},
{-0.3858161313096821,-0.22650947055895027,-0.8943373930281201},
{-0.4982883775591386,-0.007399827401038782,-0.8669797779325168},
{-0.7223818648309224,-0.4778880027722837,-0.499787452993487},
{-0.7624795467604836,-0.6367829185273127,-0.11459692597869038},
{-0.4994967382969483,0.22159855296617365,-0.837494531178567},
{-0.4538938770128984,0.06889907055780722,-0.8883880157265012},
{-0.7839307855664357,0.012400486976685549,0.6207243763248969},
{-0.5133169756730829,0.05510182224739309,0.8564283225529481},
{-0.2608030018598272,0.01250014387748405,0.9653111107948282},
{-0.08119984531444199,-0.11009979026009932,0.9905981129123922},
{-0.20479354500919036,-0.008399735244517573,0.9787691496825953},
{-0.24869491548442885,0.0017999632001285562,0.9685801975802887},
{-0.41537636368051806,0.001599908959770893,0.9096482379397383},
{0.2636958613259344,0.031699502480212825,0.9640848688067251},
{0.11519726928109716,0.11139735935689431,0.9870766016264845},
{0.002500130985293569,0.660934627272208,0.7504393165457177},
{-0.10220067401566771,0.11660076898460718,0.9879065152649523},
{0.1365944017931614,-0.07399696729644174,0.9878595134074973},
{0.5026990096839264,-0.07029986150940924,0.8615983026530156},
{0.642092930595751,0.014399841458618305,0.7664915609743702},
{0.8452796543635762,0.2902930127312743,0.44858920258783896},
{0.3296094055385825,0.036101030157593535,0.9434269210712947},
{0.5472394655971436,0.21921580931815404,0.8077582535870119},
{0.5163103521263412,0.15950319807118232,0.8414168705773843},
{0.6460371288207207,-0.03410195989595445,0.7625438246529403},
{0.4279115837233592,-0.22360605309778714,0.8757237061615931},
{0.5273926666559549,-0.17789752635209402,0.8307884479669461},
{0.5272993830600826,0.011699986311024023,-0.8495990059697445},
{0.28518511087403176,0.03969792742531227,-0.9576500023985282},
{0.5848819332761174,-0.008399740536022202,-0.8110749462818582},
{0.43022332303853006,-0.017700959595030177,-0.9025489285036572},
{0.21040228392918817,-0.6527070851738646,-0.7278079003976384},
{0.09200467947700033,-0.031801617471397946,-0.9952506197338123},
{-0.0983981516080829,-0.02299956795717385,-0.9948813113300985},
{-0.3601913753207757,-0.04319896561315245,-0.9318776864559436},
{-0.5822775536329529,-0.005899772568151162,-0.8129686606621854},
{-0.2553038257564937,0.03250048702344709,-0.9663144803309824},
{-0.41479599723793986,0.006499937275907929,-0.9098912195920962},
{-0.2967089577786551,0.016300492119285734,-0.9548288267174244},
{-0.17150514437395942,0.017400521936483344,-0.9850295464043732},
{-0.24190104743380308,-0.013700059321385294,-0.9702042009932854},
{0.052399427539381184,0.6324930900507365,-0.7727915572983546},
{0.1564973630416489,-0.013699769160834442,-0.9875833593605908},
{0.20198967758128406,0.04049793040614853,-0.9785499924804186},
{0.23380156998281368,-0.012300082595331942,-0.9722065283887572},
{0.37300927872121376,0.002900072140191742,-0.9278230798861719},
{0.0012999842767852578,-0.6626919847889157,0.7488909422188306},
{-0.18230622312914158,0.5090173756046795,-0.8412287158323307},
{-0.02740117813898167,0.9442405984973173,-0.3281141075693389},
{-0.46688375739661525,0.08859691776684539,-0.87986938987638},
{0.5865124869837732,-0.07860167344744173,0.8061171624170836},
{-0.32089199384462913,-0.058998528005089174,0.9452764156476408},
{0.49000105350339757,0.635301365899405,0.5969012833391388},
{0.15909894199555358,0.30399797842016524,0.9392937537173067},
{0.2872898961920233,-0.08719693333778082,0.953866453106756},
{0.47571929080837133,-0.010400421745652852,0.8795356658943926},
{-0.8562472404634205,-0.1601088334480187,-0.49112709622936906},
{-0.020799353462146286,0.9986689568579565,0.047198532856408876},
{-0.007400178050425865,0.9996240512440129,0.02640063520692471},
{-0.39820849586889,0.09050193087929317,0.9128194752112576},
{-0.10240441065295229,-0.00010000430727827372,0.9947428444969886},
{0.0019000215653671509,0.9995113445181407,0.031200354126029003},
{0.21649453358203968,0.07399813157076644,0.9734754200559613},
{0.36539089457235946,0.09319767754281309,0.9261769199587283},
{0.01250047615220513,0.9994380693211045,0.03110118466668636},
{-0.21990313034334083,0.9076129199618741,0.3576050905446961},
{-0.5924959295669457,0.6944952288341668,0.4081971956948983},
{0.48100576248355204,-0.03520042170357803,0.8760104946685896},
{-0.11350120595671997,-0.31190331399031684,0.9433100227222374},
{-0.10520079479500703,-0.00930007026229625,0.9944075127771387},
{-0.0,-0.9999998200000486,-0.0005999998920000291},
{-0.3552911924405077,-0.5829855479673965,-0.7306818866205431},
{0.0005999998650000455,-0.999999775000076,-0.00029999993250002274},
{0.0002999999805000019,-0.9999999350000064,0.00019999998700000128},
{0.0013999977810052757,-0.9999984150037684,0.0010999982565041452},
{0.0011999987520019467,-0.9999989600016224,-0.0007999991680012979},
{0.00019999999500000022,-0.999999975000001,9.999999750000011e-05},
{0.0004999998975000315,-0.9999997950000631,0.00039999991800002523},
{-0.0001999999920000005,-0.9999999600000025,0.0001999999920000005},
{0.0005999997840001166,-0.9999996400001944,0.0005999997840001166},
{-0.47692254466154177,-0.8636408252667384,0.16330771973837235},
{-0.0008999992710008856,-0.9999991900009841,0.0008999992710008856},
{0.6317002684726711,-0.6865002917626859,0.3601001530425975},
{-0.19549662380246013,-0.6801882532502986,-0.7064877990610643},
{0.1432034569731775,-0.9878238463554799,0.060801467765147985},
{0.6731205944396351,-0.6444197163228359,-0.3628111003754266},
{0.14089546253469243,-0.1577949182964831,-0.9773685243535017},
{0.1491997694865342,0.0545999156431955,-0.9872984746250351},
{0.2349107756044211,-0.12730583965280037,-0.9636442033734364},
{0.3950047855119649,0.18860228493052297,-0.8991108927944497},
{0.45648589023919567,0.0748976849483368,-0.8865725964645583},
{0.5658011740386542,-0.04140008590526738,-0.8235017087678185},
{0.5399059228004599,0.032200353239812574,-0.8411092270188308},
{0.34820791485585806,-0.624714199915148,-0.6989158865386536},
{0.2664895404907996,0.018399277842516742,-0.9636621770018144},
{-0.2763927917699847,-0.12879664102740243,-0.9523751623796436},
{-0.2655872507900314,0.021198982367276603,-0.9638537313121659},
{-0.15740369115983707,-0.004700110218876964,-0.9875231576895749},
{-0.05720290912791744,0.06490330074129094,-0.9962506656159327},
{0.017400483914186575,0.04290119309877035,-0.9989277805678718},
{-0.11990230994025172,0.057501107769511874,-0.9911190940932734},
{-0.5577084242493728,0.029500445607596376,-0.8295125298813965},
{-0.49180893624955824,0.10690194242594098,-0.8641157011249354},
{-0.7687947376180315,-0.0,-0.6394956226674442},
{-0.7687046698950545,-0.0,-0.6396038856054076},
{-0.7998319619238105,-0.0,-0.6002239854296962},
{-0.7999159904804762,0.0,-0.6001119963587119},
{-0.8286967763758099,-0.0,-0.559697822779704},
{-0.8288208492506977,-0.0,-0.5595140747535778},
{-0.8557587534221036,-0.0,-0.5173750631229217},
{-0.1209973834598737,-0.11829744184547983,0.9855786870913349},
{-0.03320029066981723,-0.02190019173701799,0.9992087481108848},
{0.062097197306247943,0.005499751774305372,0.9980549538062169},
{0.1926936970922505,-0.08269729501571933,0.9777680177312015},
{0.2758900198590441,-0.037298650745713466,0.9604652557977958},
{0.378915827644688,0.06650277787904922,0.9230385561257509},
{0.4132186613761311,0.053802429772594036,0.9090410532209662},
{0.4773015035021041,0.020400064260303632,0.8785027672880754},
{0.5265960084173842,-0.023399822630016696,0.8497935585892388},
{0.5850278772425418,0.021101005486867747,0.8107386326162882},
{0.658590549293426,-0.004299938296328168,0.7524892018574294},
{0.6669731848821419,-0.012899481386776056,0.7449700490812529},
{0.7347942208661793,0.418496708536331,0.5337958017125293},
{0.8072950351508007,0.3325979545288695,0.48749700190265743},
{0.916351894477218,-0.006400362462789693,0.400322670914799},
{0.9181048705592575,0.005300028116723739,0.39630210238822977},
{0.7953222931963218,-0.35630998750892673,0.4904137464899738},
{0.7237191751935734,-0.35560942199645534,0.5914156697657584},
{0.6692156163286126,0.00870020302160629,0.7430173385118936},
{0.07219878382172969,0.03179946434253469,0.9968832076437996},
{0.16449295245042517,0.02879876614329632,0.9859577575447976},
{0.009599557470600671,-0.000199990780637514,0.99995390318757},
{-0.05919993813609698,0.060699936568599434,0.9963989587636323},
{-0.0941956157670938,0.00029998603747482096,0.995553663033106},
{0.2779944401667945,0.46599068027959073,0.8399832005039832},
{-0.16790719161902887,0.5048216219731136,0.8467362664909573},
{0.1283045022839791,-0.00020000701836941405,0.9917348005847395},
{0.7687947376180315,-0.0,0.6394956226674442},
{0.7998319619238105,-0.0,0.6002239854296962},
{0.7999159904804762,-0.0,0.6001119963587119},
{0.8286967763758099,-0.0,0.559697822779704},
{0.8288208492506977,-0.0,0.5595140747535778},
{0.8557587534221036,0.0,0.5173750631229217},
{0.5612123355827057,-0.7954174834684321,0.228805029189813},
{0.33739251503008016,-0.8243817112946001,0.4544899172530274},
{-9.999999900000002e-05,-0.9999999900000002,-9.999999900000002e-05},
{-9.999999500000039e-05,-0.999999950000004,-0.00029999998500000117},
{0.0,-0.9999999200000096,-0.00039999996800000383},
{-0.0,-0.9999999800000006,-0.0001999999960000001},
{9.999999500000039e-05,-0.999999950000004,-0.00029999998500000117},
{-0.2725922571269029,-0.829076450417884,0.4881861332698239},
{9.999999750000011e-05,-0.999999975000001,0.00019999999500000022},
{-0.554379019922979,-0.79117005873568,-0.25829022519138795},
{-0.5398202328414975,-0.7916296708361049,0.28621072737909703},
{0.31830446743455093,-0.8290116352599519,-0.4598064534288612},
{-9.999999500000039e-05,-0.999999950000004,0.00029999998500000117},
{-0.0,-0.9999999550000032,0.00029999998650000095},
{0.0,-0.9999999200000096,0.00039999996800000383},
{-0.2920143952044261,-0.8245406467330458,-0.48462389012351},
{0.5487973602910455,-0.795696172710614,-0.2562987672058946},
{-0.09540324710477376,-0.0031001055138867783,0.9954338801686771},
{0.9680987075890881,-0.24349967492815097,-0.059099921101658},
{0.821560746765257,-0.3523831635346599,0.4481785865386906},
{0.015600223630808631,-0.9221132185877333,0.3866055420301678},
{0.540216819912536,-0.3640113336693134,0.7587236232277695},
{-0.5640947934290849,-0.005399950158690052,0.8256923788945141},
{0.9455159462609016,-0.24190407974670766,0.21790367497646798},
{0.3100951594523411,-0.4179934751727784,0.8538866709330993},
{0.6619960247258072,-0.3523978838570611,0.6614960277282802},
{-0.09480373865915248,-0.9220363612208713,0.37531480083101193},
{0.30459555293739043,-0.3639946857163825,0.8801871493614283},
{0.05649940280446852,-0.41799558181005025,0.9066904163329487},
{0.4488052420758413,-0.35240411610411426,0.8212095917840484},
{-0.19670684059932483,-0.9220320642225597,0.33341159458980624},
{0.0443018478686127,-0.36401518338995537,0.9303388052408668},
{-0.9208876325621415,-0.00509993150837976,0.38979476509145694},
{0.6775735209441921,-0.24179055100989616,0.6945728566231344},
{-0.20509426051742802,-0.4209882188095426,0.8835752734919523},
{0.19949572086268078,-0.35229244340813254,0.9143803867510542},
{-0.2826131404034517,-0.9220428713799804,0.2645122987852547},
{-0.21960810698290667,-0.36401343780408935,0.9051334136167069},
{-0.9934100235577068,-0.005100051459778846,0.11450115532248584},
{0.4572965382783078,-0.24079817716469826,0.8560935193965872},
{-0.06670054761374387,-0.3515028858505393,0.9338076665924143},
{-0.3459168638581796,-0.9220449507870531,0.17370846849426366},
{-0.4657055768576745,-0.3640043589782983,0.8066096592085038},
{-0.9848157719508828,-0.010200163356924254,-0.17330277546617384},
{-0.03160171206912828,-0.21971190321479375,0.9750528249177237},
{-0.6139672487906466,-0.37647991721446,0.6937629922002453},
{-0.36908700283003903,-0.9258673961537066,-0.08089715125697686},
{-0.8463128598216083,-0.39040593226321146,0.3624055067935139},
{-0.9283537227203549,-0.3716814721404092,0.0034998255380452844},
{-0.9333327185519333,-0.359012585406776,-0.0},
{0.15639842898567125,-0.0027999718744237813,-0.987690078702989},
{-0.9694008918492307,-0.24320022374430877,-0.0334000307280424},
{-0.7753034811204453,-0.3523015818376537,-0.524202353673852},
{0.021300534756637683,-0.9221231501922821,-0.38630969842672},
{-0.4657055768576745,-0.3640043589782983,-0.8066096592085038},
{0.6400868815537925,-0.0052998913798392435,-0.7682842541755643},
{-0.9205174439708464,-0.24190458413530447,-0.3068058140252642},
{-0.22749994312502134,-0.4179998955000392,-0.8794997801250825},
{-0.59620366964488,-0.35230216842652007,-0.7214044402579948},
{0.13010369694907395,-0.922026199746704,-0.36461036055059465},
{-0.21960810698290667,-0.36401343780408935,-0.9051334136167069},
{0.8304978157936166,-0.005099986587052914,-0.556998535095779},
{-0.7967793158774362,-0.2417937231164208,-0.5537856239118024},
{0.029898774025906086,-0.41798286096417203,-0.907962769749924},
{-0.3688183049067201,-0.3523174859507524,-0.8601426899410789},
{0.2275074521286437,-0.9220302015938879,-0.31321025937007124},
{0.0443018478686127,-0.36401518338995537,-0.9303388052408668},
{0.9537710534877833,-0.005099845222046232,-0.30049088024017495},
{-0.6085081753622544,-0.24180324864846853,-0.7558101543776367},
{0.2881895893391243,-0.42098479219906776,-0.8600689305710645},
{-0.1114982913017786,-0.3523945995941415,-0.9291857603373334},
{0.3065136079736957,-0.9220409349159786,-0.23641049567693853},
{0.30459555293739043,-0.3639946857163825,-0.8801871493614283},
{0.9997929314889615,-0.005099963943382381,-0.019699860722477036},
{-0.37388797221739756,-0.24079225383778902,-0.8956711867213774},
{0.15500965042619028,-0.35152188467616696,-0.9232574791836056},
{0.3609121250465148,-0.9220309761509745,-0.14000470353702435},
{0.540216819912536,-0.3640113336693134,-0.7587236232277695},
{0.6466243102979271,-0.37061393349274946,-0.6667250660000433},
{0.3677103732559464,-0.9245260812486332,0.10020282676161497},
{0.8650076769771998,-0.3843034107079051,-0.3226028631131152},
{0.0973970323576354,-0.6602798815785077,-0.7446773100280398},
{0.6557671304963553,-0.6005698971883363,-0.45747706953656986},
{0.6621733248848998,-0.6001758224039818,0.4486819252127069},
{-0.1734114836886874,-0.6740446367138138,-0.7180475506832614},
{-0.12700571538579145,-0.6660299720231267,0.7350330772327299},
{0.15840464766054455,-0.6724197290842813,0.7230212137536218},
{-0.6616301379391903,-0.6053275732989599,0.44252015725225474},
{-0.6703989106026554,-0.6021990214273852,-0.43349929556421707},
{0.8085798019288185,0.0011999700251231538,-0.5883853023187199},
{0.8204020263955077,0.0099000244530906,0.5717014121042319},
{0.12079409512498619,0.007199648053807123,0.9926514754186572},
{-0.29620726605335557,-0.0007000171716318328,0.9551234294650908},
{-0.8614396228266988,0.006100280588858676,0.5078233578725304},
{-0.8507370121188358,0.008500369816633484,-0.525522863369517},
{0.1026033100361735,0.013400432304919347,-0.9946320873487151},
{-0.2615919430922273,-0.0039998768056915485,-0.9651702732133706},
{-0.5258018981482785,0.5565020089758786,-0.6433023223255754},
{-0.8895927898796568,0.3137974566819204,-0.3318973099832038},
{-0.47712613291396916,0.573131391265973,-0.6662364907719267},
{-0.03280060337264861,0.6391117565688941,-0.7684141351080241},
{-0.4551810785158409,0.27988836528247774,0.845264863069948},
{-0.5279869852812173,0.6390842467674734,0.559286213764744},
{0.21729367793240947,-0.925273079571369,0.310890954759255},
{0.9245181068644361,-0.3647071428593401,-0.11070216812319426},
{0.8649797683598244,-0.38429101153835893,0.3226924523118096},
{0.3728033962544099,-0.054500496501784707,-0.9263084387083151},
{0.004300042699636012,0.5298052609923627,-0.8481084217584423},
{-0.47609925014427157,0.22049965271332048,-0.8512986592056676},
{-0.05519928986570379,0.5009935547593768,-0.8636888887139197},
{0.3812928984858979,0.653387830764977,-0.6539878195902892},
{-0.8510504943237869,0.2903172250319569,0.43752595918526055},
{-0.7399131187758949,0.6567116436006625,0.14580258510275104},
{0.19040043220947167,0.5009011370468716,-0.8443019165675258},
{0.5500874636495535,0.6533851095230289,-0.520088147326182},
{-0.9398309491427412,0.2903095600512213,0.18010593098596267},
{-0.7510194741874519,0.6567170288933417,-0.06850177627408849},
{0.4623077229150175,0.529708848860231,-0.7111118792231644},
{0.0597985301701924,0.22039458276773255,-0.9735760697943031},
{0.4206005783261928,0.5008006886014202,-0.7565010401896454},
{0.6744161018766507,0.653315598096109,-0.3440082132941397},
{-0.9525026955864428,0.2903008215524875,-0.09200026036110523},
{-0.7013098639926061,0.6567092366803713,-0.2773039003067869},
{0.616497530932333,0.500997993507054,-0.607397567377614},
{0.7437332233051441,0.6536291982684445,-0.1401062586863664},
{-0.8880081475121303,0.290302663539157,-0.3566032718500289},
{-0.5947176425605537,0.6567194818723988,-0.46371375627262273},
{0.7733835503068257,0.529688733640452,-0.3482925918953548},
{0.5766171228997006,0.22040654506953525,-0.7867233620971114},
{0.7628207947783023,0.5008136523662478,-0.4090111497959172},
{0.7533745778038008,0.6532779555073309,0.07519746250444097},
{-0.7516015257526459,0.29030058931079444,-0.5923012023726613},
{-0.4401051360569068,0.6567076638231554,-0.6124071468331056},
{0.8176344681075198,0.5492231529900317,0.17270728062887558},
{0.9193868482652028,0.2562963337071693,-0.2983957314795916},
{0.8294793254854652,0.5381865858665188,0.1493962763442176},
{0.5364313258219338,0.661538631676378,0.5240306016605021},
{-0.2558993781652666,0.27689932713545257,-0.9261977493422037},
{-0.009300035293700909,0.6336024045256878,-0.7736029358287122},
{-0.30680788966632544,0.16520424828186756,-0.93732410359924},
{0.49550637473051656,0.5541071286340651,0.6689086055645662},
{0.8718210111395558,0.31700763997618625,0.3734089992653248},
{0.4354974675895889,0.5736966639635985,0.693695966169685},
{-0.009399895191752914,0.6334929365931352,0.7736913733892798},
{0.4936260246500474,0.2768145940501076,-0.8244434658053061},
{0.5534192869982337,0.633522078629167,-0.5407188443800957},
{-0.20020696331927848,-0.9264322218730249,-0.3188110884424874},
{-0.9266199781420954,-0.3704079860822708,0.064601392821044},
{-0.8463128598216083,-0.39040593226321146,-0.3624055067935139},
{-0.41621900291237685,-0.05430247923628559,0.9076414393158895},
{-0.08510036976190992,0.5297023015615004,0.8439036667693982},
{0.39270599077558427,0.22060336533000735,0.8928136199756599},
{-0.02709856259486972,0.5007734371775187,0.8651541091173904},
{-0.4417783887298221,0.6533680380173511,0.6147699261907982},
{0.8888028575057804,0.2902009329974994,-0.3547011403659994},
{0.7505004465478985,0.6566003906773487,-0.07500004462503983},
{-0.3193055847035151,0.529809266445106,0.7857137422535291},
{0.12549473560625965,0.2205907464122779,0.9672594243182069},
{-0.26978181731824846,0.5009662360135007,0.8223445758433193},
{-0.5969908034275092,0.6533899346055855,0.4654928291382003},
{0.9527031486891098,0.2903009594462565,-0.08990029712097299},
{0.7410616102976418,0.6567659771198101,0.13959276858393038},
{-0.5278216041803977,0.5297216819521724,0.6639271750954263},
{-0.15209674364357753,0.2203952813875377,0.9634793721274617},
{-0.49059985036706844,0.5007998472560699,0.7130997825045995},
{-0.704026947147113,0.6533250064931945,0.27841065637181284},
{0.9394554943501577,0.29028624801474273,0.1820913736255069},
{0.6717954922673702,0.6566955935873504,0.3426977005061444},
{-0.6934795773271671,0.5296844010240813,0.4883856172553546},
{-0.4173871509343347,0.22049321222094106,0.8815728611971957},
{-0.6715787213653149,0.5008841297377699,0.5459827008121828},
{-0.7539378712504332,0.6533328177316726,0.06880345608440086},
{0.850130354446218,0.2903103657166652,0.43931568604661053},
{0.5479677119538318,0.6567613014804319,0.5180694736556208},
{-0.7982570469439249,0.5007730541269166,0.3346819912465635},
{-0.7428053147910411,0.6533046744116682,-0.14640104750324234},
{0.691881696511825,0.2902923204182437,0.6610825112934926},
{0.379894083195731,0.6566897721364477,0.6514898531245557},
{-0.8267111524086695,0.5323071808723053,-0.1822024579277363},
{-0.5141704540437632,0.662461932718773,-0.5447686957663208},
{0.20959394491839572,0.27989191403940344,0.9368729341318939},
{-0.03270028547473829,0.6390055785430511,0.7685067090928557},
{0.2598089830508861,0.1680058089012659,0.9509328790727007},
{0.7848108893266346,0.03200044400924096,-0.618908587416226},
{0.7688086991196461,0.02930033153512699,-0.6388072281446799},
{0.9445723905525304,-0.002899915236716428,-0.3282904042117253},
{-0.5884066313801037,0.6853077234615654,0.4291048360387534},
{-0.7127980861397081,0.2651992879408678,0.6492982566365213},
{-0.9934256505814513,0.1084027989964056,-0.0368009502128019},
{-0.5681354669635724,-0.8215512869399308,-0.04770297795135082},
{-0.6097837525283679,-0.4924868778619567,0.6209834541162946},
{-0.04229876383669004,-0.790976884038341,0.6103821618419765},
{0.36889970119136306,-0.9278992484019131,-0.05399995626005314},
{0.710321047124444,-0.7012207774794595,-0.06110181047346688},
{0.9934219896391138,-0.10840239951367016,-0.036900816808620195},
{-0.7646682439872271,-0.00809966362795415,0.6443732397350191},
{-0.7102799029144665,0.7012801575586588,-0.060898276907632},
{0.05329763736810205,0.9983557438707896,-0.02109906469919237},
{0.7778154592358801,0.6279124798845578,-0.027000536640998662},
{0.9987846338166123,0.010299841538156895,0.048199258460112845},
{0.0,0.0,1.0},
{-0.7573410717200092,0.04400238631411647,0.6515353337192473},
{-0.37409140721906314,-0.28879336649255666,0.8812797572364618},
{-0.5710303425033948,0.15920845976627052,0.8053427930262415},
{-0.5426681408886451,0.03419799229480683,0.839250729036005},
{-0.8413307343731002,0.001000036532001783,-0.5405197455469638},
{0.29949860583723475,0.001499993017548755,-0.9540955586955114},
{0.05979986963642628,-0.6803985167328501,-0.7303984077332066},
{-0.5936934605025487,-0.000499994492590996,-0.8046911363759489},
{-0.034298635284452504,-0.12969483954499972,0.9909605704633363},
{0.8020269926726652,0.456215354186122,0.3855129746574968},
{0.514326318751113,0.03340170920919147,0.8569438509388075},
{0.53479883146583,-0.02179995236715612,0.8446981543365492},
{-0.06530136318018473,-0.3990083293858148,0.9146190928728477},
{0.02260139895688399,0.5137317984137747,0.8576530860806952},
{-0.40227633477931696,0.628863005077585,0.6653608579720545},
{0.7557881191041508,-0.4967921904881478,0.4265932940061269},
{0.7684115800497676,-0.6399096435109921,0.007700116041623128},
{-0.9988665535134241,-0.0,-0.04759840619405245},
{-0.9988665535134241,-0.0,0.04759840619405245},
{-0.9898230977914836,0.0,0.1423033206867328},
{-0.9718015160115474,-0.0,0.23580036784886077},
{-0.9449908289085079,-0.0,0.3270968255407121},
{-0.9817208617899719,0.029000616269643665,0.18810399725241286},
{-0.9976472047942687,0.023501111981420724,-0.06440304730227636},
{-0.8017739668219389,-0.040098698016412755,0.5962806390819684},
{-0.9942935420844161,-0.045899701882404415,0.09629937453759356},
{-0.939821663139006,-0.02810064772739526,0.3405078487963732},
{-0.9372991704906011,0.04019996442304723,-0.3461996936134067},
{-0.9980530826273526,-0.061497109088851,-0.010399511130472364},
{-0.9587988302661405,0.006999991460015628,-0.283999653520634},
{-0.9549120844888943,0.05980075678336567,0.2908036801438585},
{-0.8414092345170234,-0.010000109751806792,0.5403059298901209},
{0.9988665535134241,-0.0,-0.04759840619405245},
{0.9449908289085079,-0.0,0.3270968255407121},
{0.9718244271139672,-0.0,0.235705924542871},
{0.9898230977914836,-0.0,0.1423033206867328},
{0.9988665535134241,-0.0,0.04759840619405245},
{0.9815616315057221,-0.0400984325829049,0.1868926945073548},
{0.9951444341910021,0.023801062741177624,0.09550426436060769},
{0.9348069549896177,-0.03720027677108877,-0.35320262783732675},
{0.9389998591500317,0.0236999964450008,0.34309994853501163},
{0.8016839905305619,0.04029919523310671,0.5963880902487554},
{0.9976448551210519,-0.023601061127562977,-0.06440289561928202},
{0.9546464924162985,-0.06200301962058507,0.2912141824760383},
{0.8390782471784093,0.005199865195242198,0.5439858973484146},
{0.9981604337045963,0.059797629668938944,-0.009999603623568385},
{0.9600662350642588,-0.0067997608566159355,-0.27969016346992315},
{0.6847909984814871,0.06089919948528412,-0.7261904542892171},
{-0.06229789623556559,-0.6784770882155899,-0.7319752816121029},
{-0.16559644302660528,0.005399884011737129,-0.9861788171065105},
{-0.004900229605637384,0.01680078721932817,-0.9998468489216851},
{0.07189789378205204,0.047698602689901004,-0.99627081467397},
{0.19659685742435093,-0.0003999936061533081,-0.9804843270832965},
{0.06189772127733599,-0.08009705128133462,-0.9948633747790239},
{-0.06980084668940555,-0.04990060529801342,-0.9963120853388931},
{-0.12930069176055137,0.000500002675021467,-0.9916053051025734},
{-0.0602008039871059,0.07300097493453041,-0.995513295168836},
{-0.9934256505814513,0.1084027989964056,0.0368009502128019},
{-0.9987852480508286,-0.010699841964501267,-0.04809928957873934},
{-0.6097837525283679,-0.4924868778619567,-0.6209834541162946},
{-0.568088791718708,-0.8215837903117241,0.047699058906851555},
{-0.04229876383669004,-0.790976884038341,-0.6103821618419765},
{0.3688133051799809,-0.9279334758039702,0.05400194815542019},
{0.5671240295542092,-0.5598237202335501,-0.6041255973438507},
{0.9934219896391138,-0.10840239951367016,0.036900816808620195},
{0.9987894428513833,0.01029989113072612,-0.048099491591060806},
{0.7778133551699634,0.6279107813206737,0.027100465318984322},
{0.568086079221191,0.8215798674320199,0.04779882870405374},
{0.05340245283098909,0.9983458550782098,0.02130097837640576},
{-0.3689840934385904,0.9278600008175285,0.05409766789980418},
{-0.7103253839311503,0.7012250587252183,0.06100217995185156},
{0.0,0.0,-1.0},
{-0.3111889187599009,0.6302775562158276,-0.7112746719598892},
{-0.4958167688066864,-0.4336146650959645,-0.7524254474589569},
{-0.5431048282233845,-0.10940097257896934,-0.8325074010236927},
{-0.3273904714389912,-0.13789598659571434,-0.9347727938337475},
{-0.9250893337814718,0.02689968984836406,0.3787956325115356},
{-0.8585790466340472,0.4065900772902441,-0.31229237859749936},
{0.19459294029618676,0.36218686009906914,-0.9115669289517155},
{0.7690029222166567,0.007400028120160285,-0.6392024289738452},
{-0.3741856352891865,-0.7032730018676775,-0.6044767945812755},
{-0.41500828779826177,-0.6305125914621784,-0.6559130987153733},
{-0.34688665032413846,-0.7809699449499917,-0.5193800120448472},
{-0.20229208143145552,-0.9079644584268987,-0.36698563462849315},
{0.29929832692702873,0.646996383300326,-0.7012960797658712},
{0.5458076604642723,-0.10730150598720488,-0.8310116633305429},
{0.3735073170800131,-0.13590266235923368,-0.9176179763122357},
{0.49591203593116984,-0.4676113490651644,-0.7317177590055192},
{0.9246382808172552,0.02800115927199129,0.3798157246965104},
{0.8585306286265241,0.4072145276374148,-0.31161111692489796},
{-0.19239533543163798,0.3592912890882928,-0.9131778602711633},
{-0.7675133011207637,0.005300091851387684,-0.6410111088187747},
{0.3741856352891865,-0.7032730018676775,-0.6044767945812755},
{0.41500828779826177,-0.6305125914621784,-0.6559130987153733},
{0.3469137415254581,-0.7809309332869134,-0.5194205746564512},
{0.20229950436682145,-0.9079977754081753,-0.3668991010983034},
{0.8730722847602234,-0.4771848520073057,-0.10019681930245605},
{0.21350250012891486,-0.9732113963721777,0.08530099888054538},
{0.8094938276330965,0.0499996187543605,-0.5849955394260178},
{0.8598210959693876,-0.1808044360912599,-0.4775117158936759},
{0.822809347167276,0.05120058164191121,-0.5660064298695652},
{0.38270257559700066,-0.38330257963504144,-0.8406056572951105},
{0.0736014072723607,-0.6204118623882143,-0.7808149293241744},
{0.8695682048198756,0.015099447898781189,-0.4935819525058539},
{-0.8372817265257256,-0.05099888696143796,-0.5443881188589573},
{-0.8762797844585561,-0.47818896830775026,-0.05889864122402026},
{-0.8284260916906432,0.040701281907060814,-0.558617593938186},
{-0.8353675507777228,-0.003799852397600367,-0.5496786481476109},
{-0.7986749938774063,0.04219867878005077,-0.6002812054896794},
{-0.8699343543859954,-0.19490769705693817,-0.4530178900297229},
{0.31698485482544597,-0.011999426681089439,-0.9483546886954353},
{0.9096321469681209,0.0,-0.41541468101424517},
{0.5926238802603924,-0.07760312708100987,-0.8017323064541959},
{0.7049888401149907,-0.28849543315343945,-0.6478897439865284},
{0.8660190526287391,-0.0,-0.5000110003630134},
{0.8145636834877396,0.0,-0.580074137971075},
{0.755801254631124,0.0,-0.6548010869707066},
{0.7557088796315038,-0.0,-0.6549076952106283},
{0.6901070046216455,0.0,-0.7237073456668379},
{0.8127255403014123,-0.07250227841989958,-0.578118167648882},
{0.2681056825601634,0.043200915653111,-0.9624203987165285},
{0.26769234009328075,0.5874831894090491,-0.7636781476624525},
{0.5022966496925197,0.0013999906620934257,-0.8646942325087037},
{0.6920091207403174,0.2580034005072282,-0.6742088861316793},
{0.7012806519337161,0.5917836729136934,-0.3974890334288495},
{0.8111326609141508,0.5845235363140441,-0.019900801321898164},
{0.8475971351265249,0.18539937335117712,-0.49719831947252024},
{0.850047225685471,-0.526029224365362,-0.02670148344212009},
{0.914730383274279,-0.3348111209360759,-0.2262075136073488},
{0.11010263533811561,-0.9914237300109701,-0.070401685084499},
{0.0887990613988815,-0.9932895009854615,-0.074099216775418},
{0.2190104328104563,-0.9743464140969296,-0.05180246766932254},
{0.4742950175570107,-0.83839119274678,-0.26859717840146125},
{0.9408374225527378,0.050902024668297574,-0.33501332542003315},
{0.8781120741240294,-0.07000096251985202,-0.47330650800922797},
{0.3757140463321881,0.01930072157096415,-0.9265346391449888},
{0.7571647320881498,0.033398444336693346,-0.6523696133311},
{0.551705161225925,0.06620061930969047,-0.831407777856143},
{0.5810202489085178,0.15430537763611754,-0.799127850090872},
{0.8553862797141092,-0.3893937541742742,-0.34159452086782754},
{0.8696199623553564,0.00320007345852937,-0.4937113332737344},
{0.3802826785184813,0.35298392194852457,-0.8548610619654211},
{0.17570181500912363,0.862208906664009,-0.47510490785904747},
{0.5447817038137109,-0.8281721863041767,-0.1316955770783145},
{0.9044675437645275,-0.34958745527924695,-0.24439123017805475},
{0.9990020079960541,-0.0057000114570345435,-0.044300089043268466},
{0.47490935343182467,0.34020670043694834,-0.8116159849342365},
{0.8351896896469216,-0.3165960916453728,-0.44969444855629864},
{0.9876490034209873,-0.0074003671783265555,0.1565077653254197},
{0.2693179237042536,0.8604572653365756,-0.43252878574856923},
{0.9493248678906259,-0.03440090114340833,-0.3124081836395571},
{0.5388311103122567,0.3465200069101651,-0.767844332772366},
{0.9213986086891514,-0.3384994888661577,-0.1908997117416529},
{0.9978751432397689,0.0628984332195425,0.0169995765458223},
{0.6187965687825392,0.3456980831094437,-0.7053960885895332},
{0.5800077837566874,0.0,-0.8146109321520647},
{0.41141315514595705,0.7047225338632862,-0.5780184824364686},
{0.41111112892889223,0.7048190797107351,-0.578115649802463},
{0.41130108377978364,0.7048018571553404,-0.5780015230360198},
{0.411608289874438,0.7046141910727138,-0.578011641271684},
{0.0006999998250000656,0.9999997500000938,9.999997500000939e-05},
{0.0001999999920000005,0.9999999600000025,0.0001999999920000005},
{-0.4116216333434255,0.7048370436842718,0.577730363417145},
{-0.41140271320984045,0.7049046488614888,0.5778038106286967},
{-0.4118167571647805,0.7047286759932511,0.5777235080478235},
{-0.5800077837566874,0.0,0.8146109321520647},
{-0.41500156455884757,-0.6989026348679002,0.5825021960374186},
{-0.41509882527198666,-0.6990980215553984,0.582198352380994},
{-0.41499672983865327,-0.6989944919451052,0.5823954107422451},
{-0.41489461055401305,-0.6988909214658947,0.5825924321734587},
{0.00029999991300003783,-0.9999997100001263,0.0006999997970000884},
{0.0001999999920000005,-0.9999999600000025,0.0001999999920000005},
{0.41479246743718645,-0.6987873101376708,-0.5827894166402898},
{0.41481182023122865,-0.698919916006764,-0.58261660189661},
{0.4147876519553992,-0.6988791946760571,-0.5826826537955909},
{0.41471447586142435,-0.6987243894004755,-0.5829203471898342},
{-0.5801877059527649,0.0002999936432020501,0.814482741293566},
{-0.5800740654682863,0.0004999776464991263,0.8145635816763767},
{-0.580234977618708,0.00020001205709021305,0.8144490964713474},
{-0.5804149023439289,0.0,0.8143209079577212},
{-0.41141315514595705,0.7047225338632862,0.5780184824364686},
{-0.41108215325571623,0.7048693987593149,0.57807490342284},
{-0.41130108377978364,0.7048018571553404,0.5780015230360198},
{-0.411608289874438,0.7046141910727138,0.578011641271684},
{-0.0006999998250000656,0.9999997500000938,-9.999997500000939e-05},
{-0.0001999999920000005,0.9999999600000025,-0.0001999999920000005},
{0.4115978514648231,0.7047963209728068,-0.577796983907616},
{0.41140271320984045,0.7049046488614888,-0.5778038106286967},
{0.4118167571647805,0.7047286759932511,-0.5777235080478235},
{0.5701953130137905,0.013799886565398645,-0.8213932481752498},
{0.5617222586855093,0.025501010497561843,-0.8269327678601525},
{0.5719207010444182,0.011400412645403686,-0.8202296887508862},
{0.4145785647694486,-0.6992638454975287,-0.5823698893432872},
{0.41419410605980583,-0.6988900548652783,-0.5830917026641061},
{-0.00029999991300003783,-0.9999997100001263,-0.0006999997970000884},
{-0.0001999999920000005,-0.9999999600000025,-0.0001999999920000005},
{-0.41508910405402605,-0.6992816440977606,0.5819847231015253},
{-0.41471447586142435,-0.6987243894004755,0.5829203471898342},
{0.30580552136853295,0.07000126388422925,0.9495171436867953},
{-0.15900438142609613,0.6030166163517985,0.7817215406338323},
{0.015300363081923951,-0.575413654728042,0.8177194047117134},
{-0.4738190005228891,0.07940318413152679,0.8770351698154786},
{-0.6442053984638587,0.7092059431707057,-0.28640240006216877},
{-0.8765878330453154,0.07479896179761533,0.4753934015853786},
{-0.020399797941002086,0.9997900971281316,0.001899981180779606},
{-0.8620032669985729,0.0009000034110193916,0.5069019211619218},
{-0.4436894913388449,0.0017999573685145837,0.8961787742570945},
{-0.34070194371013335,-0.6187035297137056,0.7079040386040604},
{0.45419984103008343,-0.0004999998250000919,0.8908996881851636},
{0.4669821849694587,-0.0008999656669646955,0.8842662658854225},
{0.8215829235763984,-0.0009999792156480019,0.5700881508409259},
{0.8164652601422557,-0.004699800027763138,0.577375433197965},
{0.8327077483816482,-0.0029000269848766416,0.5537051522504126},
{0.843387648678327,0.0037999443502224834,0.5372921314143527},
{0.4822923340242755,0.07849875227224887,0.8724861319431483},
{0.9140473752372625,0.050297104227583746,0.4024768280636672},
{0.7147967333863926,0.4572979101533258,-0.5290975820295751},
{0.01159947327987727,0.9998545976335589,0.012499432413660852},
{-0.687470401599025,0.7230688689400071,-0.067497093975177},
{-0.12559843191336625,0.8768890521085261,0.4639942070684869},
{-0.8764136020446565,-0.15240236530306442,0.45680708970104866},
{-0.3947076475347572,-0.16960328609550246,0.903017496133483},
{-0.6353196253263441,-0.7382228040546313,-0.22670700308748976},
{-0.24661028263010587,-0.7244302057471561,0.6437268407501993},
{-0.11600008294008897,-0.2836002027742175,0.9519006806092299},
{-0.02869963006415269,-0.18249764762048312,0.982787331952936},
{0.010600182059690325,-0.9927170500617535,0.12000206105309802},
{0.2264920842399813,-0.30028950506519375,0.9265676170276673},
{0.4616151181426828,-0.1795058789138032,0.8687284513226788},
{0.07379697992039387,-0.9894595071982349,0.12459490105800916},
{0.8773286496348384,0.18780613290940687,0.44161442115438804},
{0.6747815314822215,-0.7258801329326388,-0.1332963517287791},
{-0.017400669503638975,-0.9998384695251866,0.004500173147492838},
{-0.05859844716172506,-0.997973554051222,-0.02479934282612255},
{-0.0,-0.999998555003132,0.0016999975435053243},
{0.36598284861569,-0.6517694555401824,0.6642688697688603},
{0.3458151401182588,-0.04020176007158475,0.9374410420672523},
{0.17790542530866843,0.1122034216955177,0.9776298132757407},
{-0.0031001073585767733,-0.06720232725689004,0.9977345521458215},
{-0.19149205611682457,0.1335944579488656,0.9723596624960847},
{0.06790197971107813,0.9078264680665203,0.4138120648666293},
{-0.11769917257772516,0.992593022095582,-0.030099788399231327},
{0.6019992174015261,0.5397992982613683,0.5883992350814916},
{0.6285168381916457,0.7771208193456292,-0.03240086803088198},
{0.6891583037382104,-0.7245561620555822,0.008899461554367487},
{0.5994008691318904,-0.5393007819867008,0.5915008576768654},
{-0.12079722531960126,-0.992677198466624,9.999770307914011e-05},
{-0.13690558928477614,-0.9905404396389392,0.009300379695751775},
{-0.19369230475759494,-0.9810610232198057,0.0015999364357880842},
{-0.11829628023195124,-0.992768782876426,0.020399358552255328},
{0.2845881528417907,-0.2982875825464025,0.9110620732753179},
{0.08319842090895659,-0.9963810888663983,-0.017399669757401977},
{0.5784265127868343,-0.5831267282261463,0.5704261460816222},
{0.02919945747912001,-0.9993814316654978,-0.019599635842149046},
{-0.1533945323493399,-0.9881647774942481,-0.0006999750498340151},
{-0.20140179046987594,-0.9795087078711195,0.00010000088901185498},
{-0.2599085433342314,-0.9656317408369907,-0.001700055881755265},
{-0.20249648165419665,-0.9792829851059494,-9.99982625452823e-05},
{-0.004199962935490641,-0.9999911751168193,-9.999911751168193e-05},
{-0.004299960247051274,-0.9999907551282031,0.0},
{-0.03699950624488372,0.998786671280807,-0.03249956629618165},
{-0.1792963083270169,0.9837797441835987,0.005499886758497451},
{0.031199691592572902,0.6851932268984281,0.7276928067921572},
{-0.04640124612219714,0.7258194921441958,0.6863184313289633},
{-0.04670041773710499,0.9989089352803893,0.00010000089451200213},
{-0.1178002444357608,0.99250205944391,-0.03260006764521054},
{-0.7337934325781674,0.6788939239265711,-0.02549977177806387},
{-0.5953016579174261,0.8035022377568483,0.0003000008355034903},
{-1.0,0.0,0.0},
{9.999999950000001e-05,-0.0,0.999999995},
{0.0,0.0001999999960000001,0.9999999800000006},
{9.999999750000011e-05,0.00019999999500000022,0.999999975000001},
{9.999999900000002e-05,9.999999900000002e-05,0.9999999900000002},
{0.04889918119006641,0.9981832855608238,0.03519941059080445},
{0.06310008928668952,0.9980014121729973,0.003400004811010211},
{0.12969639254501136,0.9914724225780938,0.01269964676423781},
{0.08899998353500456,0.7315998646540376,0.6758998749585347},
{0.001099997134511197,0.9999973950101791,-0.0019999947900203583},
{-0.039101741239306945,0.997844435002058,0.05270234688776153},
{-0.025799514844684977,0.4205920908400969,0.9068829462265429},
{-0.026400350466978688,-0.9993132659716593,-0.02600034515687295},
{0.09069581448474008,-0.9958540423963907,0.006999676972361417},
{0.19959084098645588,-0.9798550354841088,-0.006899683380794316},
{0.19819175143095458,-0.9799592149461932,0.019999167651963128},
{0.643415242687651,-0.7645181116486,0.03910092631191663},
{0.7092036595003246,-0.7050036378281568,-0.00020000103200798776},
{-0.6980998533990463,-0.7158998496610474,-0.011999997480000794},
{-0.08230398813637008,-0.9964482840714354,-0.017800862561693647},
{-0.6859943337102054,-0.7273939917504423,0.017599854625801187},
{0.018499414595287554,-0.9997683628307296,-0.010999651921522328},
{0.1950928197409017,-0.980763903648777,0.006399764461003439},
{0.11610195865656395,-0.9928167489598336,-0.028900487555337622},
{-0.6375171048133863,-0.7700206599314627,-0.02530067882631949},
{-0.60527290556481,-0.5387758822374353,0.5859737694713012},
{-0.6027017900269745,0.5401016041041463,0.5874017445857721},
{0.11530347126325435,0.9933299046469258,-0.0009000270957235813},
{0.12629400749151343,0.9919529329499709,0.008899577725055181},
{0.17199939714316953,0.9850965472426529,0.0009999964950184277},
{0.1347963463945458,0.9908731427474439,-0.000599983737661183},
{-0.03589833471487797,0.9993536410598619,-0.0018999118651328174},
{-0.6831009529264941,0.7302010186311315,0.013400018693039117},
{-0.0005999998890000307,-9.999998150000513e-05,0.9999998150000513},
{-0.0005999998920000291,0.0,0.9999998200000486},
{-9.999999950000001e-05,-0.0,0.999999995},
{-0.02229895799403884,0.019899070138178154,0.9995532919659741},
{-0.233206388776532,-0.0011000301357383586,0.972426639992709},
{0.022300962307285788,0.020400880316978925,0.9995431312166881},
{0.5246218011119272,-0.00020000831151808132,0.8513353779767131},
{0.8139054816718787,0.5726038564999604,-0.09840066273069525},
{0.5608110985614618,0.7267143818199258,0.39670785092605554},
{0.8058345307494797,-0.5771247303245529,-0.1325056779899554},
{0.8278743238760112,0.005899817020012642,0.5608826044957781},
{0.17600684239899997,0.571322210582663,0.8016311640172635},
{-0.5681277309913411,0.0006000292881443488,0.8229401686899745},
{-0.004599929230633176,-0.9999846153550382,-0.0030999523076006186},
{-0.8205094112969217,0.005500063086085398,0.5716065563648024},
{-0.17560674255032283,0.5703218979296646,0.8024308099224318},
{-0.5676693154644564,0.7200610781503525,0.39907842839856367},
{-0.8071788158699627,-0.5760848808507005,-0.12879661977707035},
{-0.8156980667978726,0.5696986498158,-0.10039976205284593},
{0.39461172803483835,-0.7072210189210282,0.5866174345292351},
{-0.5936032618588859,0.6791037316852585,0.4318023727605575},
{-0.03680008960832729,-0.015500037742637855,0.9992024330608867},
{-0.007200195379952487,-0.09420255622104505,0.9955270139920419},
{0.0065002462014874095,-0.06540247716573487,0.9978377938221751},
{0.03719976899015185,-0.005299967087306581,0.999293794404805},
{0.0075997102665690255,-0.0042998360718745805,0.999961877180135},
{0.0035001299797402415,0.07420275557049312,0.9972370330848482},
{0.01979912766965189,0.009799568240534772,0.9997559517231291},
{-0.004999780089509038,0.05709748862219321,0.9983560882731647},
{-0.021400867929798693,0.007800316348244384,0.9997405452999886},
{-0.7144965775695902,-0.2642987340120961,0.6477968970602946},
{0.5912096249710423,0.18500301187355014,0.7850127801120912},
{-0.7048084436557328,0.31260374501529803,0.6368076290010934},
{-0.9558228970117502,0.292206999902525,0.03190076419195943},
{-0.46201859893305763,0.88433559964611,0.06700269724786767},
{-0.26519250974334196,0.7131798565194248,0.6488816725959826},
{0.5301073950497418,-0.24150336899549638,0.8128113387972647},
{0.2600088599528569,0.5288180197810414,0.8079275305996657},
{-0.31208343037013503,-0.7042626081694525,0.6376661440148514},
{-0.8850188820792759,-0.4608098314826331,0.06630141455576948},
{0.26518564721525617,-0.7135613795354706,0.6484649027869293},
{-0.19670482031068331,0.5931145344497522,0.7807191317567383},
{-0.29148755083255024,-0.95605916758491,0.03139865899191107},
{-0.5300771064641471,0.24138957460940408,0.8128648931233826},
{0.7048084436557328,-0.31260374501529803,0.6368076290010934},
{0.4621034334412658,-0.8843065704222275,0.0668004963295316},
{0.7145644012882696,0.2641868385395478,0.6477677290155907},
{-0.591263727082981,-0.18508864515991844,0.7849518446814477},
{0.9557949629738177,-0.29229845959117695,0.03189983188832892},
{-0.2592987514795174,-0.5282974562538721,0.8084961071006164},
{0.3126016161545333,0.7049036443612621,0.6367032917645277},
{0.8850130097868665,0.4608067739093651,0.0664009761015231},
{0.19609093982743306,-0.5945725284109725,0.7797639718380026},
{0.29140148469434685,0.9561048713667295,0.030800156927199323},
{-0.7145729146269969,-0.26438997848779455,0.6476754503273242},
{0.586094458503092,0.19229818182928615,0.7870925580750449},
{-0.7048076084391999,0.3124033724126079,0.6369068754468309},
{-0.955825941468082,0.2922079306308575,0.03180086308713644},
{-0.46210651805840613,0.8843124733154047,0.06670094082340551},
{-0.2652923371415109,0.7137793827802883,0.6481812775541929},
{0.5450881444617857,-0.2094954435236545,0.8117823439260273},
{0.26350219893502524,0.49910416504163596,0.8255068888837318},
{-0.31269882112766645,-0.7054973402800406,0.635997602293559},
{-0.8849156188985116,-0.46100813686542413,0.06630117022598182},
{-0.19219820487714961,0.6121942821321071,0.7669928363203629},
{0.265299255836631,-0.7133979989214195,0.6485981806846547},
{-0.5449950051436667,0.2096980781259209,0.8117925599552818},
{0.7048807922601128,-0.3124914847230604,0.6367826479092635},
{0.4620155008800862,-0.884329669758139,0.06710225131829824},
{-0.29140058571576594,-0.9561019217667942,0.030900062109187262},
{0.7145918036790174,0.26429696853115625,0.6476925710088155},
{-0.5861169888471361,-0.1921055682605952,0.7871228150854477},
{0.9558538686626955,-0.2921164626871452,0.031801792240503994},
{-0.264112029256315,-0.49972276039144486,0.8249375726373882},
{0.3122207493193669,0.7049468487995572,0.6368423227628855},
{0.884863071010331,0.4610807571961393,0.06649722479623349},
{0.1929943096466689,-0.6105819972552126,0.7680773535730899},
{0.29139696074554905,0.9560900280330111,0.03129967354610737},
{0.6953976321750936,0.3505988062130973,0.6272978640544092},
{0.6572998619670434,-0.43529990858702877,0.6151998708080406},
{0.1611936619898134,-0.9237636783262383,0.3473863410376003},
{0.2218027104456826,0.918411223053719,0.3276040033453815},
{-0.1611936619898134,0.9237636783262383,0.3473863410376003},
{-0.6572998619670434,0.43529990858702877,0.6151998708080406},
{-0.6953976321750936,-0.3505988062130973,0.6272978640544092},
{-0.2218027104456826,-0.918411223053719,0.3276040033453815},
{0.7332858513859949,0.2660948657490976,0.6256879274679081},
{0.7096800689151429,-0.4367877329887762,0.5527844752660153},
{0.2317107585802871,-0.9724451516766128,-0.025701193334110396},
{0.21530542361193203,0.6817171726718722,-0.6992176135135295},
{-0.2318041945348505,0.9724175960556024,-0.025900468673221},
{-0.7095911975757907,0.4367945815968227,0.552893141403121},
{-0.7331937348863029,-0.2660977262046443,0.6257946526075401},
{-0.23118970188408922,-0.6421713951122928,-0.7308674442347787},
{0.07860109531389485,0.12440173355023562,-0.989113783396608},
{-0.03650154879357367,0.013500572841458754,-0.9992423987544878},
{0.7098920102103874,-0.7042920732373235,-0.0050999426004690466},
{0.7047938647961103,-0.7093938247536332,-0.005099955605079687},
{0.9999740810077261,0.0,-0.007199813383255628},
{-0.9999747959528978,0.0,0.007099821051265575},
{0.0435987160367188,0.027499190160774473,-0.9986705895841987},
{0.0017999965080101618,0.0007999984480045164,-0.9999980600056454},
{-0.039799394854801814,-0.02539961380180819,-0.9988848120718978},
{0.01050041046906801,-0.003400132913793451,-0.9999390883829622},
{-0.005299925563068197,-0.0,0.9999859552958861},
{-0.005399921269721828,-0.0,0.999985420318857},
{1.0,0.0,0.0},
{0.9996895133120078,-0.011699877268931172,0.02199976922363126},
{0.9978886141558684,-0.03289962461742466,0.055999361050935594},
{0.9990733950297308,-0.021299432803656558,0.03739900407778194},
{0.9999948800393212,0.0,0.0031999836161258283},
{-0.00759968929305475,0.999959117507204,0.0048997996757853},
{-0.010200415726414568,0.9999407534158752,0.0038001548784681724},
{-0.0027999184535625423,0.9999708762723365,0.00709979322153359},
{0.0,0.9999647218669078,0.008399703663682026},
{-0.9996895133120078,0.011699877268931172,0.02199976922363126},
{-0.9978830211648411,0.03289944022078692,0.05609904548286159},
{-0.9990733950297308,0.021299432803656558,0.03739900407778194},
{-0.9999948800393212,0.0,0.0031999836161258283},
{0.00759968929305475,-0.999959117507204,0.0048997996757853},
{0.010100425691411334,-0.9999421434497222,0.0037001559463586083},
{0.0027999184535625423,-0.9999708762723365,0.00709979322153359},
{0.0,-0.9999647218669078,0.008399703663682026},
{-0.8166215345938047,-0.5707150499543036,-0.08610227054681188},
{-0.2829161422410065,-0.5278301162064448,0.8008456935546058},
{-0.22179190363433407,0.5955782588124859,0.7720718160327743},
{-0.992536079342238,-0.029601076018670274,-0.11830430043948288},
{-0.3917809971235906,0.002399883596469161,0.9200553737963648},
{-0.3981977043968512,0.0029999827051495572,0.9172947118112296},
{-0.3877134655224905,-0.009400326479008023,0.9217320123086908},
{-0.378010187511832,0.011900320717965082,0.9257249486235526},
{-0.004699939606164089,0.9999871502476784,-0.0018999755854705888},
{-0.00039999995000000943,0.000299999962500007,0.9999998750000235},
{0.9999873902385132,0.0028999634316916882,-0.0040999482999779045},
{0.9999959500246035,0.0008999963550221432,-0.0026999890650664295},
{-0.5688220678801934,0.21840847332108695,0.7929307623456495},
{0.07609802109669174,-0.5251863427067346,0.8475779590217598},
{-0.001499997405006734,-0.9999982700044894,-0.0010999980970049384},
{-0.0015999971520076043,-0.9999982200047526,-0.0009999982200047527},
{-0.8841028910211804,-0.14040045911025195,0.44570145744614875},
{-0.7558912543887797,-0.19719771843559641,0.6242927769743553},
{-0.8467941317370005,-0.0050999646573673865,0.5318963139713163},
{-0.7083920341763633,0.06529926571388554,0.7027920971473011},
{-0.8423610290684643,0.01909911639981917,0.5385750834001364},
{-0.7241732459136354,0.2986889651400206,0.6215770362605852},
{-0.8813136340273784,-0.2969045931495843,0.36760568690396495},
{-0.8171508528799113,-0.14130879391987697,0.5588347773703272},
{-0.8577086414580943,0.011600116871766228,0.5140051786282622},
{-0.815605460496837,0.002300015398654641,0.5786038737659023},
{-0.875435096896566,-0.05210208881461171,0.48051926440347265},
{-0.8414690260952137,0.015599425795704494,0.5400801200166666},
{-0.4392943023898468,0.5718925826013052,0.6927910145588114},
{-0.9113239726924066,0.1041027384585532,0.39831047769492545},
{-0.7897693259550583,0.10599588319984322,0.6041765342391063},
{-0.299503824688262,0.7486095598051183,0.5915075535996894},
{-0.8660190526287391,-0.0,0.5000110003630134},
{-0.9958024895093356,-0.013000032500121874,0.09060022650084937},
{-0.5403264928574332,-0.04130202508793631,0.8404412078426555},
{-0.7272679318275534,0.45407997778480963,0.5146773058045399},
{-0.8145636834877396,-0.0,0.580074137971075},
{-0.040198493790655966,0.5102808801336254,0.8590678113321528},
{-0.8841537909096455,-0.4454767177677529,0.14079264166487004},
{-0.3509101309217217,-0.5547160148825279,0.7544217804712079},
{-0.6748818931617065,-0.008199780002853747,-0.7378802029397291},
{-0.5343644499156812,-0.7072529480264996,-0.4628692063360196},
{-0.016200582502416,-0.9998359497478714,0.008100291251208},
{0.16170032825199954,-0.7224014664764654,0.6723013647731557},
{-0.8311704690378434,0.5020821613377059,0.23889151233534744},
{-0.6569919847466789,0.5791929338893096,0.4825941123877431},
{-0.7078810502779227,-0.579184495438583,0.4042891773235826},
{-0.7030318410331369,0.0061002762877697524,0.7111322079070607},
{-0.8364344074370395,0.035401456268856046,0.5469224981196998},
{-0.795819935539081,0.035100879288039386,0.6045151432940118},
{0.11319695447690913,-0.01989946461210682,0.9933732736516037},
{0.30160993519490065,0.0,0.9534314065478061},
{-0.7951358375798178,0.019200865402505974,-0.6061273187738995},
{-0.6732847671044645,0.0,-0.7393832716427164},
{-0.7182811166376623,0.10369727383450587,0.6879819131932501},
{-0.9884659528766196,0.013999517794914188,-0.1507948059623614},
{-0.8565987450837578,0.01989997084656407,-0.5155992446476598},
{-0.7419999406400071,0.0,-0.6703999463680064},
{0.22019222514979253,-0.019299318553092627,0.975265563980893},
{0.3940037804844107,-0.0,0.919108818891426},
{0.2214056226671824,0.9630244563166062,-0.1535038982809959},
{0.18979763418723467,0.9779878094579321,-0.08669891930470625},
{0.45148804024021894,-0.0011999682132630403,0.8922763639121757},
{0.45770270274243957,-0.00030000177151569117,0.8891052501820035},
{0.010999890826625315,-0.9988900860650934,-0.045799545441767224},
{-0.46349867671316697,0.0004999985725061132,-0.8860974701953338},
{-0.45949092514384177,-9.999802505850746e-05,-0.8881824585696632},
{0.08080234774632115,0.9882287134024079,-0.12990377440899897},
{0.027599751465357075,0.9994909996240724,-0.01599985592194613},
{0.5341094057494536,-0.0009000158494186635,0.8454148878872647},
{0.5387699024600751,-0.0001999888279361823,0.8424529376811679},
{0.15889795737988677,-0.9872873085032233,-0.003899949866466698},
{0.026400906886727606,-0.9995343345941001,-0.01530052558208077},
{-0.5458070791637254,-0.00010000129702523368,-0.8379108677744329},
{-0.5444117349214207,-0.0003000064667090856,-0.8388180809186034},
{0.10459962448802212,0.9650965353096573,-0.24009913804564162},
{0.02599975950333688,0.9994907547532775,-0.01849982887737432},
{0.6120901913332752,-0.0009999839753851907,0.7907873277346088},
{0.6160844163417805,-0.0002999924117879145,0.7876800758844675},
{0.27431063111451726,-0.961437261223102,-0.019800767393610797},
{0.024800885655440412,-0.9995356940569635,-0.017700632100858683},
{-0.6227907703091755,0.00019999703606588809,-0.7823884050897542},
{-0.6192778240581737,-0.0002999892575770258,-0.7851718834982689},
{0.05490229112041368,0.9882412401674462,-0.14270595524377108},
{0.024099784669385962,0.9994910695871896,-0.02089981326100276},
{0.6845060031439715,-0.0011000096471269081,0.7290063934141054},
{0.6885180910505166,-0.00040001051041424355,0.7252190553810235},
{0.15539536462540884,-0.9872705501587267,-0.03389898880824555},
{0.02310076395489619,-0.9995330551047076,-0.020000661432810558},
{-0.6943943302934398,0.0008999926515899996,-0.7195941245379597},
{-0.6911295153161909,0.0003000128123207311,-0.7227308648806412},
{0.04480167718217856,0.9697363027580034,-0.24000898490452802},
{0.022099753920610136,0.999488870753386,-0.02309974278579611},
{0.749780907072299,-0.001999949071945316,0.6616831504531078},
{0.7583522446857666,-0.00030002066913586967,0.6518449071425328},
{0.15039188732845118,-0.9877467174404527,-0.04169775067550808},
{0.019899671857116594,-0.9995835170037058,-0.02089965536752446},
{-0.04709952947805076,0.0005999940060898185,-0.998890021138533},
{-0.03849840735383098,0.0,-0.9992586615242415},
{0.11259557451791366,0.9883611532282935,-0.10229597933554678},
{0.24809982881117715,0.9420993499516728,-0.2255998443361611},
{0.1592927451771276,0.9765555237914804,-0.144793405534514},
{0.3722161284742777,0.003300142998294241,0.928140217186935},
{0.33208251631576186,-0.0,0.9432503391769291},
{0.32209974070981306,-0.9465992379879201,0.014199988569013803},
{0.27839281616606704,-0.9603752178372514,-0.013299656806784093},
{0.6185991648916911,-0.003499995275009568,-0.7856989393071478},
{0.5826940041095464,0.0,-0.8126916374460759},
{0.3134914073182865,0.9463740602425084,0.07809785936701173},
{0.26508498866212604,0.9598456454801011,0.0917948018075563},
{-0.3267086154197844,-0.0006000158226258667,0.9451249232728444},
{-0.31850690211935423,-0.0,0.9479205416607092},
{0.07900111708369341,-0.9884139762724374,0.12960183258286917},
{0.1733940856286071,-0.9428678393264914,0.28449029620149197},
{0.11119970532117135,-0.9768974112252904,0.1824995163769224},
{0.23589479975645844,0.00019999559114578926,-0.97177857737739},
{0.23909882722312872,0.0,-0.9709952372800418},
{0.06109876887221071,0.9977798949376734,-0.02649946604113885},
{0.145199215926351,0.9873946680831884,-0.0629996598027556},
{0.0934004273079324,0.9948045512412329,-0.04050018528877155},
{-0.2246955533189993,-0.016999663579986595,0.9742807191753494},
{-0.011100426153540208,-0.0,0.9999383883716084},
{0.11710648143757771,-0.9827543920470335,0.14310792052704843},
{0.2676021595581415,-0.9063073139295352,0.327102639728954},
{0.1644935889873014,-0.9656623640427779,0.20109216258569187},
{0.5260020934924982,-0.03400013532080787,-0.8498033822241919},
{0.09509694458425495,0.0,-0.9954680161264544},
{0.29789769279130396,0.9537926129048194,-0.03919969639952707},
{0.14859497683171088,0.9886665786912014,0.021399276609681106},
{0.26619051180830683,0.032698834470817555,0.9633656614429857},
{-0.17389371820289282,-0.0,0.984764426027653},
{0.274112058454683,-0.9540419692293599,0.12110532754054035},
{0.14859497683171088,-0.9886665786912014,0.021399276609681106},
{0.05890112443319825,0.017000324539293215,-0.9981190542746209},
{0.27099461268064934,0.0,-0.9625808640826312},
{0.152098324646181,0.98288917353538,-0.10389885556040898},
{0.34641054143316613,0.9077276225718387,-0.2367072031097876},
{0.21300877933776433,0.9661398202733057,-0.14560600127501638},
{-0.047199308535194905,-0.0004999926751609629,0.9988853664365718},
{-0.04109815370691614,-0.0,0.9991551139647351},
{0.05109921282268966,-0.9977846292461788,0.042599343762163976},
{0.12150105098863657,-0.9874085411208211,0.10130087625636944},
{0.0781013800635787,-0.9948175785819217,0.06510115034749006},
{-0.37479941156538576,-0.00369999419101368,0.9270985444564277},
{-0.33020342587831536,-0.0,0.9439097931149056},
{-0.3239884079021442,0.9459661539365074,0.013399520573730657},
{-0.28100383291842174,0.9596130892118059,-0.013400182779739683},
{0.047199308535194905,-0.0004999926751609629,-0.9988853664365718},
{0.04109815370691614,0.0,-0.9991551139647351},
{-0.11230166993824807,-0.988414697835836,-0.10210151826086489},
{-0.24660628360816053,-0.9428240234621806,-0.22420571283434546},
{-0.15819689225257727,-0.9768808093649983,-0.14379717513224155},
{0.04739886220396902,0.0001999951991728651,0.9988760222688747},
{0.04410119493806549,-0.0,0.999027069005157},
{-0.05109921282268966,0.9977846292461788,0.042599343762163976},
{-0.12159957379424076,0.9873965391811952,0.1012996449453667},
{-0.07820077067239249,0.9948098038989264,0.06510064156998403},
{-0.05890112443319825,-0.017000324539293215,-0.9981190542746209},
{-0.2710872632641463,0.0,-0.96255477542629},
{-0.15270641838564997,-0.9827413054851226,-0.10440438820865656},
{-0.34890119498863925,-0.9063031040934473,-0.23850081686669666},
{-0.2144916028181213,-0.9656621950650804,-0.1465942609470237},
{-0.2655055504515489,-0.03370070452059208,0.9635201425991238},
{0.1864917479227276,-0.0,0.9824565272604819},
{-0.27479504823784573,0.9537828129885635,0.12159780882722722},
{-0.14859497683171088,0.9886665786912014,0.021399276609681106},
{-0.5267821186844668,0.032698890055015306,-0.8493711685850154},
{-0.11059615297972676,0.0,-0.9938654289923184},
{-0.2975059100136042,-0.9539189497881582,-0.03910077674464513},
{-0.14859497683171088,-0.9886665786912014,0.021399276609681106},
{0.2246955533189993,0.016999663579986595,0.9742807191753494},
{0.011100426153540208,-0.0,0.9999383883716084},
{-0.11710480490872012,0.9827403226626753,0.14320587585763211},
{-0.2676021595581415,0.9063073139295352,0.327102639728954},
{-0.1644935889873014,0.9656623640427779,0.20109216258569187},
{-0.23589479975645844,-0.00019999559114578926,-0.97177857737739},
{-0.23909882722312872,0.0,-0.9709952372800418},
{-0.060999143273049054,-0.9977859861942352,-0.02649962781534098},
{-0.14520012995417445,-0.9874008837241863,-0.06290005629557556},
{-0.09330129783007929,-0.9948138379567297,-0.04050056336675468},
{0.3267086154197844,0.0006000158226258667,0.9451249232728444},
{0.31850690211935423,-0.0,0.9479205416607092},
{-0.07900111708369341,0.9884139762724374,0.12960183258286917},
{-0.1733990176973471,0.9428946585168893,0.2843983888876904},
{-0.11119970532117135,0.9768974112252904,0.1824995163769224},
{-0.6184270722376437,0.0035001532225610497,-0.7858344006538495},
{-0.5828074017010026,0.0,-0.8126103202166005},
{-0.31300789415863733,-0.9466238741551631,0.07700194201346669},
{-0.26320768446052334,-0.9604280401059523,0.09110265978097902},
{-0.0281987805701008,-0.986957319953528,0.1584931461120914},
{0.5700922296958636,0.07779893960767967,0.8178888522509152},
{0.1546987894867084,-0.05199959310477593,0.986592279945614},
{-0.47899042747195947,-0.4148917084720584,0.7735845400674485},
{-0.05499894925511163,0.9724814209199284,0.2263956747519504},
{-0.714701325772189,0.2388004429752326,0.6574012194803932},
{-0.9133616715816611,0.05739759136061676,-0.4030830849732512},
{-0.9016852801079523,0.0,-0.4323929412428509},
{-0.9998744285384811,-0.008299787735642957,0.013499654750744569},
{-0.9972378109884191,0.009200348837839406,-0.0737027944944309},
{-0.1156027097592755,-0.10600248472736336,0.9876231501579628},
{-0.9972451562830379,0.009200416604295977,-0.07360333283436782},
{-0.055000194151028026,0.9725034329431774,0.22630079884322987},
{-0.11570137396197373,-0.10600125877242192,0.9876117279589046},
{0.36192065359141257,0.17751012990460274,-0.9151522246518421},
{0.33600466209703017,-0.7872109226273277,-0.5171071749118282},
{-0.780514291347513,0.20430374083574238,-0.590810817845113},
{0.0023000606073955176,0.2676070515387133,-0.9635253892285136},
{0.3153099119228744,-0.25520802259028713,-0.9140287329448373},
{0.18020663082497404,0.36691350083064916,-0.912633580970429},
{0.4098822483842254,0.2469893031249175,-0.8780619719594739},
{-0.288295707308877,0.3866942421656009,-0.8759869566513224},
{-0.2006892453515047,-0.3461814486332383,-0.9164508887127756},
{-0.4294873689622155,-0.3075909538830675,-0.8490750290705872},
{-0.7433227088556386,-0.36601118181240916,-0.559917105728874},
{0.7568216681145417,-0.3675105219768684,-0.5405154751795848},
{-0.07939931796278804,-0.9040922338810664,-0.41989639310547483},
{0.5213866500657354,-0.7364811426417609,-0.4309889646688376},
{0.3301053130877716,-0.9282149397396837,-0.17160276196868102},
{-0.35510801487834476,-0.9186207335039354,-0.1733039115134248},
{-0.09380397455860486,-0.8279350803525476,-0.5529234278619682},
{-0.7797681510202942,0.13619443725181335,-0.6110750411496559},
{-0.1635016505574936,0.7780078540289298,-0.6066061237197286},
{-0.831973934664934,0.45288581130979405,-0.3204899592068646},
{-0.5915248830175672,0.6901290308882894,-0.416917538005112},
{-0.33710207992624974,0.9358057739394379,-0.10310063613288742},
{-0.9045216499847917,0.42521017752740015,-0.03220077073467141},
{-0.3388060426596567,0.7335130823224859,-0.5892105086631337},
{-0.35368512077994657,-0.7466685883132206,-0.5633762992576248},
{-0.9225846575447164,0.0612989806064287,-0.3808936657910064},
{-0.737336650229072,-0.5499273348175326,-0.39231950072543736},
{-0.9500905893993178,-0.3067969611911491,-0.05659943938532932},
{-0.15820171412485887,-0.7825084785252975,-0.6022065249430468},
{-0.0005999995920004162,0.0009999993200006938,-0.9999993200006937},
{0.33348198245521876,-0.6833630788902444,-0.6494649103588143},
{0.3668898684761711,-0.44508770907261863,-0.8168774422408944},
{0.3397922647171396,0.7717824305729498,-0.5374877642303194},
{0.9252275721924832,-0.0010000298013321262,-0.3794113066254087},
{0.6809614927163495,0.5512688266292562,-0.4820727395573452},
{0.9048443294095733,0.3913191711958068,-0.16770821622677431},
{0.9363004026092597,-0.3512001510160974,0.00010000004300002774},
{0.7656962251269152,-0.5340973669064717,-0.35839823310106617},
{-0.000599999880000036,0.00019999996000001201,-0.9999998000000601},
{0.7809124283201958,0.13440213902706405,-0.6100097083817639},
{0.5310744585881066,0.7676630801319704,-0.35868274956797935},
{0.34749083505008677,0.9376752691409105,-0.0038998971415693195},
{-0.46278350437597454,0.403585614447155,-0.7892718669056973},
{-0.7328206328553811,0.3408095956292493,-0.588916581179768},
{0.7468006235787811,0.3797003170498971,-0.5460004559105711},
{-0.04290164337892505,0.9253354456531316,-0.3767144303226355},
{0.435294948431435,-0.6335926471999936,-0.6395925775712056},
{-0.9814878590702746,-0.19149763118895322,0.0031999604167344663},
{0.1951109938386805,0.9803552396722628,-0.028901628508138728},
{0.3534059355025306,-0.30770516795169395,0.883414837076784},
{0.4467874320463023,0.05289851198578647,0.8930748781570111},
{-0.22689482572249842,0.4117906092222338,0.8825798729954919},
{-0.3837893001034676,-0.49838610518907833,0.7773783269943609},
{-0.3052036105800699,0.5201061528921833,0.7977094369584591},
{0.48098983919696936,0.27949409574959033,0.8309824456812506},
{0.22949510033191134,-0.5457883475431686,0.8058827945860014},
{-0.5387155098427958,-0.13730395303771276,0.8312239312814774},
{-0.831905465636864,0.4530029762393309,0.32050210570575177},
{-0.17279257958200137,0.7813664449385177,0.5996742475423971},
{-0.7820720218738673,0.14249490233605175,0.6066782964721587},
{-0.5902926036800136,0.6938913055964109,0.4123948327251187},
{-0.3372897516065938,0.935771567012898,0.10279687656435768},
{-0.9045216499847917,0.42521017752740015,0.03220077073467141},
{-0.41360880789334714,0.4283091209398467,0.8034171089495046},
{-0.3361188399889869,0.7330410881045146,0.5913331451517047},
{-0.5134091053912269,-0.5431096321347396,0.6644117834474701},
{-0.42180230093782745,-0.6979038070756514,0.5788031573798352},
{-0.9225846575447164,0.0612989806064287,0.3808936657910064},
{-0.9501251073876984,-0.3067081048687581,0.05650149307168189},
{-0.741035133308525,-0.5503260915785173,0.38471823992414245},
{-0.0938952917386407,-0.8277584930910199,0.5531722618723752},
{-0.7816055963161045,-0.17540125587748814,0.598604286022032},
{-0.12530224355675648,-0.7929141972558039,0.5963106770382595},
{-0.35510801487834476,-0.9186207335039354,0.1733039115134248},
{0.5504005806729189,-0.5267005556693792,0.6478006834300816},
{-0.4332129251004334,-0.424012650606149,0.7953237288374301},
{-0.7436772661334562,-0.3570890839535527,0.5651827226282499},
{0.7004095221321806,-0.4172056719496655,0.579107873025051},
{-0.08680089014769272,-0.9027092573309011,0.42140432152347596},
{0.4616940488020661,0.6739913123079762,0.5766925664807266},
{0.4763127772616274,0.5005134264527493,0.7229193925728121},
{0.4339989475538283,-0.4552988959015162,0.7773981148118574},
{-0.735445315859248,0.34692137621916386,0.5820358632446047},
{-0.5430997664671506,0.4765997950621321,0.6912997027411917},
{0.4497183781170403,0.40171641647679585,0.7977326000088126},
{0.15240266707001082,-0.776813594356853,0.6110106927806863},
{0.7928089865407939,-0.14070159486161668,0.5930067217692871},
{0.5397076585060117,-0.7488106256981686,0.38470545900919534},
{0.785993947869902,-0.42979669057822373,0.44439657815952216},
{0.925586579091904,-0.345794986009054,0.15399776704856658},
{0.2972932203054155,-0.9513783040651609,0.08059816197987384},
{0.516602322132657,-0.747203358686646,0.4181018793721717},
{0.9159817675643732,0.31649370025559403,0.2465950915735529},
{0.7574946861934144,0.37169739255193684,0.5366962350891162},
{-0.04299910304806553,0.9253806967599963,0.3765921443698018},
{0.5320903133840165,0.7749858915102664,0.34099379226451726},
{0.3524147312436554,0.9358391188927716,0.0030001254078631276},
{0.5872852769426583,0.4861878114243495,0.6470837778130328},
{0.7587031941471711,0.4330018229415119,0.4867020490199396},
{0.7419021441002946,0.6694019345743863,0.038500111265482334},
{0.9525787720185958,0.13339702728037023,-0.27349390525623135},
{0.5172026351541392,0.28390144648155474,-0.8074041137344393},
{0.32920005267201263,-0.7980001276800307,-0.5048000807680194},
{0.8368039957486196,-0.5345025522557806,-0.11860056631905626},
{0.3685949650271664,-0.7489897688696355,0.5505924789581058},
{0.007799778138466231,0.9942717183432017,-0.10659696789237183},
{0.4080036230882596,0.7332065109027254,0.5440048307843461},
{-0.46951691465153095,0.6353228879193134,0.613122088121094},
{0.13520049213068702,0.3582013038551191,0.9238033626503601},
{-0.5911273757426706,-0.14390666447195113,0.793636754169148},
{0.07220200977091334,-0.2382066305738443,0.9685269593231244},
{-0.3192010150608418,-0.86560275262113,0.385801226849852},
{-0.7373973121916956,0.6721975498443962,-0.06629975833782127},
{-0.9511635283337457,0.20249223558408697,0.23299106612885068},
{-0.48031011303589605,0.47921008987466457,0.7346154674915037},
{-0.4892957480384243,-0.44169616167703246,0.751993465205181},
{-0.9313487806698649,-0.3020158184927512,0.20341065391200527},
{-0.705693274775137,-0.699593332907306,-0.11209893170227131},
{-0.058998200582322934,-0.9891698307802347,0.13439590098752885},
{-0.2537081010290008,-0.6501207586872426,-0.7162228693613338},
{-0.0763002308085473,0.9825029720759858,0.16990051394983202},
{-0.36119845407392487,0.7225969072918552,-0.5893974773841952},
{0.3716185033459339,0.7931394913984396,-0.4825240254693571},
{-0.06170086042449797,0.10910152143132461,-0.9921138351238968},
{0.5737964482109784,-0.028699822348649495,-0.8184949335320423},
{0.40820362894639206,-0.7133063413215617,-0.5697050647005378},
{-0.795479039403464,0.34209098602127597,-0.5001868202509273},
{-0.30460140421571014,-0.6719030974804191,-0.6751031122325211},
{-0.44659750575989543,0.24689862107505192,0.8599951969402375},
{-0.9750163755375418,-0.15460259657241432,-0.15950267886998762},
{0.37170656625448983,0.8347147453662165,0.4063071774796858},
{0.2759064093803357,-0.8868206010818476,0.3707086116610745},
{0.7088885373650256,-0.583190569884727,0.3966935855165829},
{0.8325666105856101,-0.05509779034742628,-0.5511778954537453},
{0.39500964230305435,0.8677211813325577,-0.30170736476666205},
{-0.7686240390927398,-0.3555111187841127,0.5318166328252916},
{0.7856180969212962,-0.22560519687556574,-0.5761132709220452},
{-0.7055964931941432,0.532697352500737,-0.4672976775363139},
{-0.24339396755527026,-0.4475889066464214,-0.8604786733003701},
{-0.6574238386205904,0.30861119044465196,-0.6874249264797595},
{0.0006000129574197247,0.7147154344464621,0.6994151040322591},
{-0.6577910080583793,-0.6960904845081147,-0.2876960672216414},
{0.9429451316191401,-0.18668913687517866,0.27568395841717597},
{0.7334797525708917,-0.516385745368246,0.4419877990952067},
{0.258613162451863,0.415521148487042,0.8720443838284011},
{-0.6073937286921267,0.5257945711990784,0.5954938515577238},
{0.15810527368935734,0.5678189399166167,0.8078269455171592},
{0.7392874285241661,-0.46339212008399644,0.48859169156892673},
{0.5174183039962615,0.002000070753754393,-0.8557302719938171},
{0.4055962746153264,0.42849606428172426,0.8073925841331719},
{0.9142878309099555,-0.32579566368857427,-0.2406967963469608},
{-0.2843007349183496,-0.8665022399111852,0.4103010606296126},
{-0.27409383432854434,0.485289083544847,0.8302813230317051},
{0.7819850446790295,-0.5627892367587695,-0.26789487655947825},
{-0.9429027108491905,-0.3278009424290642,-0.05900016962573151},
{0.054498140010221637,0.6564775948020276,-0.7523743219025827},
{-0.27680025880836295,0.9583008960117566,-0.0710000663850931},
{0.4379070372226327,0.32320519394920044,0.8389134814479712},
{0.8537787369053328,0.46488842209801967,-0.23439416248607403},
{-0.36642127320454176,0.7382428599333862,0.566332879409749},
{-0.06990082098996382,-0.7395086855805185,-0.669507863416034},
{-0.36209995111650983,-0.6068999180685165,-0.7074999044875193},
{-0.4197931406361225,-0.7507877322286822,0.509991666804246},
{0.11470099274138829,0.4986043154390253,0.8592074364725442},
{-0.992872765873543,-0.09229746831516569,0.0753979318630931},
{0.20320677401071932,-0.9778325965929201,0.05050168350167976},
{0.5796885077892485,-0.7783845686788874,0.24099522231707587},
{0.0,-0.34199998461000114,0.939699957713503},
{-0.002999870813345075,0.9511590392179451,0.3086867066932082},
{0.002999889876063937,-0.9270659680329587,-0.37488623817879},
{0.0029999269226702345,-0.9303773362841288,-0.36659106995030266},
{0.0,-0.935094684001832,-0.3543979852531807},
{-0.0029998689085929797,0.9483585576365272,0.3171861392685643},
{0.0,0.9441184246508374,0.32960643233229103},
{0.0,0.34199998461000114,-0.939699957713503},
{0.0,-0.9441184246508374,-0.32960643233229103},
{-0.0029998689085929797,-0.9483585576365272,-0.3171861392685643},
{0.0,0.935094684001832,0.3543979852531807},
{0.0029999269226702345,0.9303773362841288,0.36659106995030266},
{0.0,-0.3076046125657484,0.9515142680634253},
{-0.0029999475613749368,0.9513833699640383,0.30799461630116015},
{0.003000127253096217,-0.9251392406131036,-0.37961610175844135},
{0.002999854615568999,-0.9287549889801621,-0.370682035330476},
{0.0,-0.9335722173042135,-0.3583893344921059},
{0.0,-0.9351278204664945,-0.35431054089538977},
{0.0,0.3422970134715861,-0.9395918020972898},
{0.0,-0.3422970134715861,0.9395918020972898},
{-0.0030000635270177843,0.9511201401822048,0.3088065390476973},
{0.0,0.9440873021111793,0.3296955656244633},
{-0.003000156162192469,0.951149508620419,0.308716069089605},
{0.0039998231117342395,-0.185391801228882,0.9826565429753091},
{0.0005000052150815901,0.36550381222464234,0.9308097083958881},
{-0.0005000001550000721,0.35120010887205066,0.936300290253135},
{-0.0018999428980742844,0.7800765551514469,0.6256811954342525},
{0.00109997649375349,0.7647836567478811,0.6442862317503396},
{0.0019000679951498315,0.9869353181122993,0.16110576527296727},
{-0.001100031488852059,0.9905283542799678,0.13730393038126157},
{-0.0006000184568516034,0.9316286573382564,-0.36341117869978784},
{-0.0006000200860085742,0.9305311500516307,-0.36621225916056654},
{-0.005099863809955409,0.5541852006818211,-0.8323777716484082},
{0.0020000422313375768,0.6351134105612475,-0.7724163097425721},
{0.006099882486895824,0.08239841260987146,-0.9965808010557997},
{-0.007100096810480022,-0.09540130080560479,-0.9954135725565934},
{0.005399953560599067,-0.4947957447748923,-0.8689925266964054},
{-0.0067002931107333335,-0.6811297966746975,-0.7321320278161004},
{0.0052998737320124846,-0.8565795922343197,-0.5159877067393287},
{-0.00560018363303204,-0.9885324145093164,-0.15090494825438122},
{0.006300141534269369,-0.9997224590173156,0.02270050997268487},
{-0.0011000314888520589,-0.13730393038126154,0.9905283542799677},
{-0.004199906238139838,-0.612986315233267,0.7900823616081636},
{0.006799869409761966,-0.7623853585297827,0.6470875728024953},
{-0.004700013301056463,-0.9165025937060103,0.4000011320048054},
{-0.9889410517951077,0.11560479885480275,-0.09290385651912782},
{-0.6777772101244579,-0.10399650317637006,-0.7278755255969209},
{-0.745266337079814,-0.1155947787017664,0.6566703388706747},
{-0.12000261008515434,0.10390225989872946,0.9873214744756073},
{0.6777160925596789,-0.10410247194254475,0.7279172846011367},
{0.9889638589761486,0.1154957792838677,0.09279660880989543},
{-0.06659950949641884,0.9893927131495013,0.12909904918900406},
{-0.1846067271917105,0.9770356038261169,-0.10640387742794148},
{-0.11110010054563649,0.9917008974897183,0.06470005855357948},
{0.08230229338535822,0.9903275958629434,0.11170311265060161},
{0.08710015982893991,0.9916018195910083,0.09560017542648286},
{-0.8754756183435389,0.10909696169192475,0.47078688876771924},
{-0.8143107286145247,-0.08200108037135088,-0.5746075705046124},
{-0.4725211930507731,-0.10830485758179624,0.8746392284491137},
{0.5727686560929195,0.08249548555807587,0.8155553699535355},
{0.9161254182523489,-0.11410316583625478,0.38431066284726306},
{-0.004999929401495272,-0.9999858802990544,-0.001799974584538298},
{-0.0031999567208780234,-0.9999864752743822,-0.004099944548624968},
{0.00020000095100678307,-0.9999047545584119,0.013800065619468031},
{-0.0064001824718034435,-0.9999285083681662,0.01010028796331481},
{0.005499903505039499,-0.9999824554617271,0.0021999614020158},
{0.009700436044400513,-0.9999449485356776,-0.004000179812123923},
{-0.2589986998297903,-0.1797990974107965,0.9489952360558725},
{-0.8745006777382879,-0.18920014663017046,-0.44660034611540234},
{-0.535401081511277,-0.31860064357395,0.7822015800487876},
{0.9042158962551855,-0.3168055694908679,0.2864050350447745},
{0.9761309487223516,-0.21370677568073615,0.03870122704185535},
{-0.9729269212603721,-0.011900329286667106,-0.23080638650107296},
{-0.4886778389624932,-0.0025998820980202217,0.8724604348164013},
{-0.492303382135853,0.5771039647178564,0.6516044765381308},
{-0.8658055541604449,0.008800056452543215,-0.500303209455383},
{-0.06459751788806181,-0.9936618192781272,0.09199646510374127},
{-0.10520080584125913,-0.994207615659504,-0.022000168521936318},
{-0.013299534125479233,-0.9918652555686355,0.12659556543501285},
{0.08080176068954835,-0.9927216316400328,0.08930194591060232},
{0.11259529586680599,-0.9935584899934141,0.01279946524951258},
{-0.12439762340610704,-0.9921810445622138,0.01009980704502959},
{-0.5882249177352841,0.7848332462404811,-0.1950082607248902},
{-0.7221096582812697,0.6878091995095655,-0.0740009897698573},
{-0.419307763555114,0.7178132904361098,0.5558102909228055},
{-0.14910029745539014,0.7762015485236339,0.6126012221406573},
{0.3298988354591662,0.705897508186194,0.6267977874077156},
{0.6259921375881274,0.7583904746754566,0.18159771914697118},
{0.692016923480798,0.7210176327018142,-0.03530086329316788},
{-0.6172107117848553,0.027600479010469876,0.786313646591756},
{-0.9942794733121579,-0.0015999669690228832,-0.10679779518227746},
{-0.4843183124215955,-0.06420242753967877,0.8725329910961018},
{0.38381173522320944,-0.08350255312959351,0.9196281180595711},
{0.8838628873765222,-0.0945960279961749,0.45808076559247063},
{0.9675402601878571,-0.19420808116638952,-0.16170672875697828},
{-0.9725292832975868,-0.08080243299788689,-0.218306573309885},
{0.4157896386513056,0.18339542984283178,0.8907778020937543},
{-0.99301037701266,0.11590121117398519,0.02230023303865289},
{-0.24660393829634217,-0.0787012568691084,0.9659154257925259},
{0.9546128109898857,-0.01960026303729495,0.29720398850428875},
{-0.9399813133572338,-0.0509989861502329,-0.3373932926880114},
{0.649583780095514,-0.0036999076144602866,0.760281016020042},
{0.6822168509643308,0.5824143858129965,0.4420109178045063},
{-0.8765960202631019,-0.4805978180908587,-0.02459988831676056},
{0.6386034293096231,-0.5601030077612276,-0.527702833771826},
{0.3343015010171093,-0.9403042219754351,-0.06380028646392932},
{-0.08430428908981394,-0.995050624488314,0.052602676229231475},
{0.11940494346699142,-0.9928411044726053,0.003000124207713352},
{0.9542181016890852,-0.011100210572991874,-0.2989056702943487},
{0.8772309624132372,-0.08140287316511344,-0.4731166989485893},
{0.01700007607551066,-0.01010004519780339,-0.9998044741350327},
{0.3787819628323847,0.7095662112615105,-0.5941717062170089},
{0.11640511262482219,-0.9924435890796696,-0.038801704208274064},
{0.0047997765036105425,-0.9939537176226833,-0.10969489217626596},
{0.0004000075582142194,-0.9933187689354602,-0.1154021805448023},
{0.121005001240054,0.9905409399030868,-0.0647026742167892},
{0.08880033699791837,0.9904037585893958,-0.10590040189278777},
{-0.04780077437881746,0.990016038389734,-0.13260214817220073},
{0.866793715768341,0.08989934823208796,-0.49049644391367236},
{0.49203076026449694,-0.08960560186930676,-0.8659541368150974},
{-0.38300865417831287,0.11450258721518752,-0.9166207112789597},
{0.43702083546500803,0.17710844384634536,-0.8818420428216113},
{0.42330249325902797,-0.04820028390050826,-0.9047053287300794},
{0.7452046314611769,-0.11580071970370945,-0.6567040814285492},
{0.12010241768600229,0.1038020895570944,-0.9873198749491261},
{0.3106920324049921,0.7743801412759121,-0.551185865019735},
{0.41721054304363575,0.7249183189173815,-0.5481138510120248},
{-0.227198172198057,0.7135942591572776,-0.6626946686428361},
{0.7051196484327591,-0.10990306249150508,-0.7005195202484014},
{0.2375101525884632,-0.11510492026497733,-0.9645412301960959},
{-0.43511422629219676,-0.08420275305401739,-0.896429309235406},
{0.00039999951800087126,-0.9999987950021781,-0.0014999981925032672},
{0.2759023369026904,-0.21510182192014754,-0.9368079347968117},
{0.23380989855158724,-0.24831051244807145,-0.940039797427254},
{-0.8169799964896759,-0.24209407239920508,-0.5233871850216602},
{-0.5159892649550127,-0.3174933946186367,0.7955834480585429},
{0.9041883315248719,-0.3895949723093233,0.17509774037824052},
{0.22920267710290293,-0.9380109560319501,0.2600030368532058},
{0.05579717785011471,-0.6983646776078873,0.7135639088502125},
{0.8253939540114302,-0.5381960577283156,0.17049875110122226},
{0.8245809977498576,0.5402875492168907,0.16779613318266567},
{0.14310446922236184,-0.5347166994632904,-0.8328260095624244},
{0.14200399533861405,0.5303149206201905,-0.8358235162254481},
{0.05600062133034051,0.6985077499864794,0.7134079153047307},
{-0.123094990751275,-0.6926718122941363,0.7106710798288476},
{-0.12420292811854601,0.6920163144769229,0.7111167647753467},
{0.9129552982382059,-0.2661869664742721,0.3092848562377624},
{0.914475592972131,0.26279298614879826,0.30769178781577333},
{0.570898909584124,0.5809988902931793,0.5800988920121743},
{0.6056737597527757,0.5853746391931235,-0.5389766493424899},
{0.2972017326911524,0.3291019186697788,-0.8963052254746967},
{0.5631252651817963,-0.5815260907533556,0.587126342014265},
{-0.05030016775133918,0.6850022844864282,0.7268024238901255},
{-0.108099622732975,-0.6900975915636083,0.7155975025690742},
{-0.17200589904346325,0.6850234932835602,0.7079242786794631},
{-0.3121955528060252,-0.6922901383972173,0.6505907324010249},
{-0.39171086229281915,0.69631930920217,0.6014166775157045},
{-0.5411057519847156,-0.6048064291265126,0.5843062112080379},
{-0.5781938567229082,0.5554940979065643,0.5975936506011933},
{-0.7212077566311341,0.6324068015717266,0.2827030404875508},
{-0.7591928863959816,-0.6186942028624787,0.20209810634961523},
{-0.556683386032262,0.5931822967385267,-0.5815826429250289},
{-0.5316055872040825,-0.6019063260687306,-0.5959062630077365},
{-0.3135082234285522,0.7327192194771937,-0.6040158435433669},
{-0.25720533706611676,0.7271150877946093,-0.6365132077860938},
{-0.3130975234083847,-0.7329942020387926,-0.6038952232076765},
{-0.3703018903959758,0.6637033882144453,-0.6499033177649058},
{-0.3714934116227668,-0.6608882792503004,-0.6520884353141486},
{0.3737929279047054,-0.3007943090255093,-0.8773834000631046},
{0.040101205059318315,0.6910207654860089,-0.7217216880625943},
{0.5832815744260912,-0.580181672350451,-0.5684820419359383},
{0.07410240799687243,0.729623709507667,-0.679822091177785},
{0.0943015838084002,-0.7256121867590158,-0.6816114477603985},
{0.0697025351273047,0.7919288029743557,-0.6066220632456676},
{0.13400337625759776,-0.7775195898528526,-0.6144154803930452},
{0.7152898107692179,-0.5935915443486758,-0.3687947465562527},
{0.5053135476378207,0.77982090727879,-0.36950990669339945},
{0.49259979064513343,0.5896997493776598,-0.6399997280001734},
{0.47578335501048236,-0.5872794543876761,-0.6547770930240939},
{-0.25448483570044744,-0.7377560384274662,-0.6252627417032998},
{-0.967426038622249,-0.023000619069993514,0.25210678554545063},
{-0.9630091823363306,0.0308002936822004,-0.267702552556008},
{-0.25198933351726355,0.022899030704544982,0.9674590483252083},
{0.267702552556008,-0.0308002936822004,0.9630091823363306},
{-0.5087301914890975,-0.14890883725717832,-0.8479503231051813},
{-0.9960470294707708,0.05390254506874955,0.07060333361509681},
{-0.263601132169294,-0.007300031353701996,-0.9646041429836911},
{0.6227155369464726,-0.025900646229185226,-0.7820195116302258},
{0.9646041429836911,0.007300031353701996,0.263601132169294},
{0.7820195116302258,0.025900646229185226,-0.6227155369464726},
{0.8479503231051813,0.14890883725717832,0.5087301914890975},
{-0.07049680409982755,-0.053897556609655395,0.9960548448771379},
{-0.056000537327733496,0.6984067012444478,0.7135068461310331},
{-0.8245671581441237,0.540278481136636,0.1678933129425156},
{-0.05579717785011471,-0.6983646776078873,0.7135639088502125},
{0.12330048457185656,-0.6926027219340458,0.7107027930674651},
{0.12420292811854601,0.6920163144769229,0.7111167647753467},
{-0.9136678668661735,-0.2655906593407636,0.3076891787618711},
{-0.9175373904105043,0.2619106730773963,0.2992121931453111},
{-0.5879813436479444,0.5860814039320752,0.5574823113668861},
{-0.56481499038877,-0.582215452203155,0.5848155212099021},
{-0.5832655941773692,-0.5821656590606281,-0.5664665851216864},
{-0.3507895729349145,-0.30909081241214953,-0.8839737242715633},
{-0.8253939540114302,-0.5381960577283156,0.17049875110122226},
{-0.1430056230916521,-0.5344210138474048,-0.8330327554919316},
{-0.14210197949436165,0.5303073872333567,-0.8358116429372798},
{0.4025939490584181,0.694689558894394,0.5960910408189841},
{0.19459955825950412,0.6822984511842737,0.7046984003364468},
{0.34289687622368636,-0.69589366043763,0.6309942516685509},
{0.5770849786735052,0.5517856372067929,0.6020843279489126},
{0.5481147280406163,-0.6087163564282488,0.573615413253234},
{0.7214160120060816,0.6326140410244625,0.2817062525396634},
{0.7595775472195514,-0.6185817149947531,0.2009940587034358},
{0.557224535136435,0.5929261071112568,-0.581325596329522},
{0.5316776354506373,-0.6017746868801834,-0.5959749308417902},
{0.3130975234083847,-0.7329942020387926,-0.6038952232076765},
{0.254313686259299,-0.7378397079123508,-0.6252336478541632},
{0.25750185144496784,0.727105227905383,-0.6364045757653497},
{0.31341804556347497,0.7327421888460692,-0.6040347783035701},
{0.3703018903959758,0.6637033882144453,-0.6499033177649058},
{0.371517636360807,-0.6609313751570858,-0.6520309526440005},
{-0.2972115127109216,0.32901274455549534,-0.8963347201978433},
{-0.04129909679862942,0.6908848905126649,-0.7217842147518332},
{-0.6042718083564064,0.5850727040697227,-0.5408747660764195},
{-0.07659780588727509,0.7252792246741595,-0.6841804019330759},
{-0.08439914082111963,-0.7303925646415377,-0.6777931001013612},
{-0.0697017934502185,0.7913203609348336,-0.6074156290052041},
{-0.15889682368424152,-0.771084586173182,-0.6165876745355778},
{-0.6460153462768283,-0.670015916417144,-0.36570868751305907},
{-0.5050837087877053,0.780074839091841,-0.3692880888047903},
{-0.49220220999288433,0.5897026477708327,-0.6403028749663628},
{-0.4758016034541055,-0.5869019778629981,-0.65510220769816},
{0.0364005467403181,0.6788101958057121,0.7334110159161893},
{0.1254033520764021,-0.6843182920724239,0.7183192009288647},
{0.9572512238835217,-0.03170169640316301,0.2875153853599169},
{-0.1984001011840774,-0.04890002493901908,-0.9789004992393818},
{0.029200944227797652,0.041001325799304926,-0.9987322945308739},
{0.8801120620184655,0.03170043445743138,0.47370649219196354},
{-0.6857142698624352,-0.041000853236633876,0.7267151230990692},
{-0.8326054702359093,0.048900321276166184,0.5517036247047216},
{0.5030701537331423,-0.07309566336293521,0.8611489095507496},
{0.9899950846866067,-0.04169979296104192,-0.13479933072298442},
{0.42509296476964903,-0.02899952006191443,0.904685027586689},
{0.9965615484144673,0.0819968362131109,0.01189954086507341},
{0.0021999941370234376,-0.9999973350106534,-0.0006999981345074573},
{0.0019999837501980446,-0.9999918750990222,0.003499971562846578},
{0.0033999742112934108,-0.9999924150862973,0.001899985588663965},
{-0.003499955883334134,-0.999987395238324,0.0035999546228579664},
{-0.0036999207300475287,-0.9999785756885212,0.005399884308718015},
{-0.00409996305949925,-0.9999909901217683,-0.0010999900891339451},
{-0.002399983680166462,-0.9999932000693591,-0.0027999809601942055},
{-0.24489335735777126,0.08319774329181938,0.9659737983160761},
{0.9640651496747475,-0.026999024002923123,0.26429044607305857},
{0.4043873408524388,0.19029404293822727,0.8945719958619974},
{-0.986549141236618,0.0847042192222418,-0.13980696395831646},
{-0.9860444716085269,0.026201181699942604,-0.16440741494162456},
{0.6346777168565348,0.7417739567735584,0.2166923920636696},
{-0.09379963793409635,0.7811969845854593,0.6171976176217939},
{0.2847084588139689,0.7165212881637117,0.6368189201711816},
{-0.4457787435474089,0.7141659458087918,0.5396742662461564},
{-0.5906016773111453,0.7970022634896424,-0.12640035897752924},
{-0.7313637545104675,0.6803662818825842,-0.04699767085314735},
{0.80821420853068,-0.21760382550887894,0.547209620029681},
{-0.653895393323181,-0.16579883195134335,0.7381947994359569},
{0.4156044220545761,-0.695607401302125,0.5860062351395129},
{-0.7083872208098039,-0.7033873110073631,-0.05859894288460545},
{-0.6536105362867681,-0.16860271789771894,-0.7378118936235887},
{-0.5684844862700517,-0.005199858097808739,0.8226775494360097},
{0.5801199854777555,-0.0022000757939166734,0.8145280609750591},
{0.653589369455358,0.01989967633439661,0.75658769420123},
{0.9452453539601506,-0.01500071975180095,-0.32601564260580734},
{-0.6108731924181633,0.5863742675298919,0.5319766547167505},
{-0.9808524984637212,-0.01339935108514004,-0.19429059073453056},
{-0.5848998040585985,0.5928998013785999,-0.5534998145775932},
{0.08729826714659554,-0.9895803570248677,0.11449772724267113},
{-0.06220087392841808,-0.9945139730194821,0.0841011816299029},
{0.05089923015496582,-0.9937849691160124,0.09899850265897085},
{-0.10580141034219986,-0.9939132489519134,-0.03070040923918276},
{-0.1415936100245661,-0.9896553378623806,-0.023098957567566927},
{-0.09090175851152778,0.9923191966005392,0.08390162309259826},
{0.10139989657215825,0.9877989924455416,0.11819987943618447},
{0.06899818261180471,0.99117389282349,0.11319701842980133},
{-0.24079134491065798,0.9702651244468915,-0.024599115800673532},
{-0.08120163176318558,0.99061990670704,-0.10990220850707015},
{-0.7041119101536911,-0.031000524378304826,0.709411999805466},
{0.709411999805466,-0.031000524378304826,0.7041119101536911},
{0.6274311464551842,0.0314015588120701,0.7780386227958772},
{-0.7780386227958772,0.03140155881207011,0.6274311464551843},
{-0.709411999805466,-0.031000524378304826,-0.7041119101536911},
{-0.6274311464551842,0.0314015588120701,-0.7780386227958772},
{-0.5886080139526654,0.0035000476534732053,0.8084110065907826},
{-0.6344227571524559,0.07090254331984415,0.7697276106245986},
{-0.9928783257027224,-0.047398965291881395,-0.10929761405912734},
{-0.9684725684029944,-0.016199541154495106,-0.24859295870416562},
{-0.997694422903764,-0.04419975292407173,-0.05149971211741389},
{0.5442219734057734,-0.05800234189183178,0.8369337918840347},
{0.43310733906604126,0.050700859133337085,0.8999152491930975},
{-0.9835814104870111,0.0539989794289331,-0.17219674551226444},
{0.37900453860652494,-0.6793081347636211,-0.6284075252251722},
{-0.12280112486345567,-0.02100019236264307,-0.9922090886768786},
{0.5610625054455998,0.5813611489325818,-0.5892606210285011},
{-0.017300237879906283,-0.9936136622817853,-0.11150153315662142},
{0.07549781474737775,-0.9909713167503491,-0.11079679303323782},
{0.10939775627502794,-0.9934796239418672,-0.032099341649254085},
{-0.27440142140304424,0.7258037596732126,-0.630803267569389},
{0.2741131837906193,0.7894379689321956,-0.5492264156797085},
{0.37218939089261677,0.6943802069742964,-0.6158824445211248},
{0.7098032651025292,0.7024032310622943,-0.05300024380168223},
{-0.1636020605809296,-0.05280066502856408,-0.9851124075689105},
{-0.5304085184292094,-0.02360037902513074,-0.8474136095718555},
{0.5367834190162759,-0.13729575899950572,-0.8324742852664859},
{-0.0,-0.9999968750146484,-0.002499992187536621},
{0.0016999930470426561,-0.9999959100250919,-0.0022999905930577115},
{0.4824951123492677,-0.04199957454646476,-0.874891137397667},
{0.5749103887245872,0.0384006939068084,-0.8173147690113153},
{0.045698307137567555,0.9867634460252006,-0.15559423611828252},
{0.10399525116528081,0.9916547171212403,-0.07619652056533076},
{0.40551039133691874,-0.025900663713011578,-0.9137234144624972},
{0.5294143129094269,0.11060299019226032,-0.8411227400606703},
{0.6642938586316653,-0.22879788477333288,-0.7115934213492294},
{0.7041119101536911,-0.031000524378304826,-0.709411999805466},
{0.7780780857393185,0.03139911565636113,-0.6273823300255087},
{0.3816994465362038,-0.5223992425216475,-0.7624988943774047},
{-0.1753108617209173,-0.3818236566174913,-0.9074562231920158},
{0.9326804092537533,-0.3445927619050535,-0.10659776093754701},
{0.9869528741253638,-0.16069232712456533,-0.010099517759540197},
{0.15299090572590565,-0.9569431162071353,-0.24668533622601913},
{0.14429388928318057,0.11389517664140171,0.9829583725943624},
{-0.9204541887331831,-0.15610919041856786,0.3583210949838108},
{-0.1970100792934916,0.9198470605794596,0.33921735480381904},
{0.30279233188129145,0.7983797812880551,-0.5204868188382172},
{-0.8872747174671336,0.076297825924425,-0.4548870381785181},
{0.3740100684865673,-0.3446092770066072,0.8610231790559745},
{-0.8735862673318154,-0.38179399824552096,0.3017952558158676},
{-0.4695020540759799,-0.5224022855149987,0.7118031141454366},
{0.4846964568818503,-0.16069882529588064,0.8597937149309158},
{-0.13719269605528783,-0.9569490533885602,0.25578638229550027},
{0.9234065515927254,0.11400080883860808,-0.3665026003451742},
{-0.14989774105806328,-0.15619764611920936,-0.9762852874915755},
{0.1953021268517422,0.9198100167856245,-0.34030370592753645},
{-0.29938665214366467,0.7983644057164391,0.5224767058953399},
{-0.8376132930284413,0.07630121090982579,-0.5409085842873496},
{0.8185178070485907,0.05320115740376912,0.572012444266089},
{0.21569646907770154,-0.9739840560115035,-0.06949886231293582},
{0.7831391970977466,0.01980099106440478,0.6215311084104834},
{0.45461222468708495,-0.8359224782576646,0.30750826900853195},
{-0.3384100103161599,-0.7242214227865337,0.6008177724525676},
{0.853474801528472,-0.16719506363861802,0.49358542710539394},
{0.8723119245855142,-0.47810653576101614,0.10240139983670372},
{0.7838416074168119,-0.14060746364226046,0.6048321053402498},
{0.39759348548411017,-0.3909935936224524,0.8300863991457742},
{0.489693489568334,-0.6920907987139963,-0.5302929498020982},
{0.3628006022494996,0.7190011935429719,-0.5928009840504502},
{0.3825025819011418,0.8848059724604712,0.26610179619318647},
{-0.37700304431187426,0.7238058447557947,0.5779046665990242},
{-0.8666786366349072,0.4620886096561563,-0.1879953659713425},
{-0.3395986534940083,0.37839849965292327,-0.8610965857588061},
{-0.7262169355764088,-0.2624061193820568,-0.6354148180463373},
{-0.8238907477588537,-0.14229840199791832,-0.5485938393257764},
{-0.5573019700659463,-0.37500132563202915,-0.7408026187418858},
{-0.3864143343056015,-0.3982147720509589,-0.8319308610476964},
{-0.6399014653760335,0.29900068471235197,-0.7079016210965684},
{-0.9096005457604912,0.30420018252016434,-0.2830001698001528},
{-0.8564120412379502,0.026600374003887758,0.5156072494888919},
{-0.8897127674698204,0.003600051661112008,0.4565065509160088},
{-0.849212937857663,0.006700102076832717,0.5280080442638321},
{-0.7790057607689014,-0.0039000288408199166,0.6270046367164328},
{-0.32110352734162184,-0.8759096219200454,0.36010395576368115},
{-0.45060946965750837,-0.676914225501925,-0.5820122311155568},
{-0.4054975710768238,0.6941958417793616,-0.5946964377790065},
{-0.30939597014373316,0.9236879690425543,0.22599705640751033},
{-0.7686237662142827,0.010200315398628266,0.6396197773492782},
{-0.7528796649948689,-0.009999729910942608,0.658082225439133},
{0.395613354154158,-0.7223243824710525,0.567219146805456},
{0.40660904715194984,0.7013156044458003,0.5855130278098047},
{0.7570907597636654,0.012399848660770638,-0.6531920278399501},
{0.8157726843089912,0.16179458239911104,-0.5552814067133891},
{0.7592078768225833,-0.12150126058211784,-0.6394066338782398},
{0.6857031473846698,-0.4827022156082545,-0.544802500649217},
{0.8327825367333052,-0.14929686927747654,-0.5330888212446265},
{0.7854900911050007,0.18269769528311092,-0.5912925408916447},
{0.8689656374332881,0.029698825583163013,-0.49398046592870465},
{0.641205681107502,-0.7272064430776286,0.24500217072884903},
{0.6566897228862545,-0.74448834884851,-0.12039811578423183},
{0.7065053765263731,-0.0018000136981563646,-0.7077053856584773},
{0.5996153113724664,-0.4229107991651368,-0.6794173491435184},
{-0.7794129773341099,-0.0003000049951247536,-0.6265104314855271},
{-0.641205681107502,-0.7272064430776286,-0.24500217072884903},
{-0.6566976260423727,-0.744497308647094,0.12029956511785815},
{-0.7065556968140033,-0.0015998996814356146,-0.7076556278449903},
{-0.772313384306926,-0.5554096253322113,0.30830534297789114},
{-0.0018999806012970906,-0.00409995813964109,-0.9999897901563635},
{-0.0005999997840001166,-0.0005999997840001166,-0.9999996400001944},
{-0.009300457082195231,-0.0039001916796302587,0.9999491437082809},
{-0.027999925520297175,-0.004599987764048821,0.9995973410746092},
{-9.999998700000255e-05,-0.0004999999350000127,0.9999998700000254},
{-0.0037999269471066565,-0.004899905800216478,0.9999807755543832},
{-0.02220003363307643,-0.010200015453035116,0.9997015145489417},
{-0.0,-0.00039999996800000383,0.9999999200000096},
{0.06409797101084098,-0.8612727368430161,0.5040840434721519},
{0.012299941821412778,-0.8740958655363341,0.4855977031282963},
{-0.005900185091709536,-0.9871309667841497,0.15980501316189558},
{0.03660168993903763,-0.9471437306355885,-0.31871471539812274},
{-0.06630315278987452,-0.8611409482256553,-0.5040239669094534},
{-0.03630094783012193,-0.9472247323606472,0.3185083163607117},
{0.06619788567329685,-0.8611724945897772,0.5039839030112027},
{0.005900185091709536,-0.9871309667841497,-0.15980501316189558},
{-0.012199957239224814,-0.8740969362956074,-0.4855982979809483},
{-0.06409797101084098,-0.8612727368430161,-0.5040840434721519},
{0.39580495550906464,-0.3534044246510951,0.8476106121512966},
{-0.012499984937527226,-0.3845995365578377,0.9229988877870104},
{-0.0014999836577670725,-0.3864957891513157,0.922289951705714},
{0.7815631345363953,-0.24128861868427864,0.5752728650189205},
{-0.7815631345363953,-0.24128861868427864,-0.5752728650189205},
{-0.39580495550906464,-0.3534044246510951,-0.8476106121512966},
{0.012499984937527226,-0.3845995365578377,-0.9229988877870104},
{0.0014999836577670725,-0.3864957891513157,-0.922289951705714},
{-0.6614726784352641,0.7499690231692338,0.0005999752185353869},
{-0.0011999991360009332,0.9999992800007776,0.0},
{-0.661204800364276,0.7502054465113126,0.0},
{-0.9981008334145439,-0.06160005143606443,-0.0004000003340004184},
{-0.9919338304801926,-0.1257042872178246,0.016300555939940658},
{-0.8846461797359048,-0.4662243375456464,0.006000313224525693},
{-0.8528900169807764,-0.5217938924382333,0.017599793995616914},
{-0.6096652073993922,-0.7926547644833495,0.002599851630701033},
{-0.621396815349482,-0.7834959845933684,0.00019999897500787967},
{-0.22369084899454766,-0.9746601274697613,-0.00019999181850205422},
{-0.22139634256263105,-0.9751838900952022,0.00019999669608187086},
{-0.0004999999350000127,-0.9999998700000254,-9.999998700000255e-05},
{0.0007999997280001387,-0.9999996600001734,0.00019999993200003468},
{0.77707381693885,0.6262788978880476,-0.06269788743027398},
{0.9060058346963632,-0.4206027086901659,-0.047400305258948804},
{0.9199027827101266,0.3865011691678051,0.06630020055841003},
{0.21360006301202786,0.9746002875071271,0.06730001985350878},
{0.6527815591814261,0.5124855224884817,-0.5578842399928271},
{0.9828590451168673,-0.18329236236638696,0.019799174985567172},
{0.8351766947194963,-0.5490846780058374,0.031399123819674545},
{-0.16379755206387647,-0.9835853004275269,-0.07569886868886111},
{0.3587117408274191,-0.7242237042297655,0.5889192756433429},
{0.9658155787309284,-0.2567041406711838,-0.03610058230708896},
{0.703210281009463,0.4334063364469586,0.5636082400127038},
{0.26170177696109836,0.7628051794647529,0.5913040149678925},
{-0.04580200662986664,0.9965436595341072,-0.06930303623252747},
{-0.26419216813926155,-0.9617714887068196,0.07209786269054033},
{-0.9736696706621308,-0.220593128631063,0.057498208958685966},
{-0.965026224943999,-0.2532068809904876,-0.06790184525771766},
{-0.9030605461465895,-0.4135819310001433,-0.11589493666082351},
{-0.257289412758493,-0.6634726986601636,0.7025710897944701},
{0.21869050357106917,0.7369679978595244,-0.6395722271790389},
{-0.2356974250196974,0.7519917845346307,0.615593274680211},
{-0.6669734516501251,0.5080797762869994,0.5449783075701923},
{-0.8136198444300113,0.5799141442784704,-0.04150101222203229},
{-0.7403105643071295,0.6679095311370145,0.07640109025133687},
{-0.23630704914441553,0.7677229015157334,-0.5956177675430127},
{-0.6988701938218366,0.4484808726986604,-0.5571762369402309},
{-0.9396417774021556,-0.3356149217711403,0.06660296123348614},
{-0.3175016605380269,-0.6923036207574048,-0.6480033890665873},
{0.31110223061099024,-0.7401053065740724,-0.5962042747999755},
{-0.1850985090375145,0.0630994917356411,0.9806921005569449},
{0.1274965818624598,0.053898554999110455,0.9903734484437661},
{0.12229940134589562,0.056299724413523496,-0.9908951495801142},
{-0.13549645952376838,0.03989895745386242,-0.9899741323138797},
{0.6596083375020794,0.7516095004041281,-0.0},
{0.0011999991360009332,0.9999992800007776,0.0},
{0.6614726784352641,0.7499690231692338,0.0005999752185353869},
{0.6622695263688502,0.7492655233401471,0.0004999769940879134},
{0.9981008334145439,-0.06160005143606443,-0.0004000003340004184},
{0.9919338304801926,-0.1257042872178246,0.016300555939940658},
{0.8846461797359048,-0.4662243375456464,0.006000313224525693},
{0.8528900169807764,-0.5217938924382333,0.017599793995616914},
{0.6097135327420405,-0.7926175923426952,0.0026000577089212813},
{0.621396815349482,-0.7834959845933684,0.00019999897500787967},
{0.22369084899454766,-0.9746601274697613,-0.00019999181850205422},
{0.22300399180718034,-0.9748174493885174,-0.00040000716019225174},
{0.0007999997280001387,-0.9999996600001734,-0.00019999993200003468},
{0.22080400431692776,-0.9753176875466469,0.0010000181354933324},
{-0.0007999997280001387,-0.9999996600001734,0.00019999993200003468},
{-0.8819787622071059,-0.4695886924404274,0.039999036834789385},
{-0.9067825854076692,-0.41839196485947155,-0.05189900328921265},
{-0.6795867447898131,0.7292857754196743,0.07939845134830954},
{-0.9842847338621659,-0.1301979806449802,0.11929814970004714},
{-0.6813900211162106,0.44929342014604257,-0.5777915383048818},
{-0.2839082590113837,0.818523811204007,-0.4994145281799402},
{0.3700883405504935,0.926370815147196,0.0697978010549161},
{0.041400939397972535,0.9971226249690438,-0.06350144086404},
{-0.7780187037944616,0.6246150159254765,-0.06740162035443022},
{-0.703210281009463,0.4334063364469586,0.5636082400127038},
{-0.9658155787309284,-0.2567041406711838,-0.03610058230708896},
{-0.3587117408274191,-0.7242237042297655,0.5889192756433429},
{0.1610075313034192,-0.9844460485409059,-0.0703032885132321},
{0.009300123413456549,-0.9956132118749829,0.09310123546159191},
{-0.2599039440722772,-0.7292110658618872,-0.633009605993657},
{-0.26170177696109836,0.7628051794647529,0.5913040149678925},
{0.2356974250196974,0.7519917845346307,0.615593274680211},
{0.14079931219703987,0.6952966034843879,-0.704796557077228},
{0.814884248439715,0.5787888121203915,-0.03109939885443016},
{0.6669734516501251,0.5080797762869994,0.5449783075701923},
{0.9030605461465895,-0.4135819310001433,-0.11589493666082351},
{0.9656923227765508,-0.25289798946897557,-0.05899953095559335},
{0.257289412758493,-0.6634726986601636,0.7025710897944701},
{0.791186830804801,0.607589886750502,0.0696988398724654},
{0.967139972721126,0.24971032074083876,0.04780197569648415},
{0.790896907599137,-0.22009913941404735,-0.5709977674030942},
{0.7910304513033456,-0.6115235410518279,0.017600677551123746},
{0.3645976993957752,-0.756095229054157,-0.5434965705474598},
{-0.12229940134589562,0.056299724413523496,-0.9908951495801142},
{-0.1274965818624598,0.053898554999110455,0.9903734484437661},
{0.1850985090375145,0.0630994917356411,0.9806921005569449},
{0.21800413230749222,-0.05280100085245683,-0.9745184721727118},
{0.0,0.5124943779675103,0.8586905802160022},
{-0.7231819134465142,0.45028873841947636,0.5236869027543412},
{-0.010000145103158178,0.697710123847346,0.7163103937392203},
{-0.6886186583753264,-0.01720046605294164,0.7249196419638021},
{-0.0179993227882199,0.432683720581264,0.9013660867389678},
{0.0073003426496235785,0.382217939820018,0.9240433709934502},
{0.6911705947725548,-0.013299434187608474,0.7225692589448034},
{0.0170007697272745,0.7013317535139768,0.7126322651562239},
{0.7224359601448965,0.4485223257544104,0.5262261935606929},
{0.0,0.5072866762904186,0.8617773657147304},
{-0.01870029051126966,0.6968108250402512,-0.7170111388545639},
{-0.6811117050052267,0.00990017013588569,-0.7321125814628195},
{-0.7232250782643908,0.45041561843235844,-0.5235181533067043},
{0.0,0.5128035665612082,-0.8585059709297918},
{0.9998843969257281,0.015199762809552021,-0.00039999375814610586},
{0.9999005899415221,0.014100008319007363,0.0},
{0.9998633756753114,0.016499395638206456,-0.0009999633720125126},
{0.9998530779960487,0.017099197553487783,-0.0011999436879640546},
{-0.021299183511449837,0.3752856137017429,-0.9266644769981485},
{0.6856867595165094,0.012699754770103062,-0.7277859465890558},
{0.002299964419825636,0.3680943056251376,-0.9297856163277722},
{0.012200070211606103,0.7067040670936092,-0.707404071122144},
{0.7223923137866717,0.4483952291001434,-0.5263943991933886},
{0.0,0.5070201265633938,-0.8619342151577695},
{0.706899908103018,-0.7072999080510181,-0.004399999428000113},
{0.08489515856715643,-0.7228587765394274,-0.6857608921714473},
{0.16889679521371592,-0.9734815283632473,-0.15429707224083106},
{-0.643483173135031,-0.43508862258127734,-0.6297835313759791},
{0.6364022624140644,-0.43470154536674066,-0.6372022652580795},
{0.6024717718464296,-0.4354795960815271,0.6688686608930735},
{-0.610471839583545,-0.434879939451079,0.6619694640529186},
{-0.9542262988391991,-0.2990082407806754,0.006800187415747802},
{-0.9878681417661337,-0.15529499181726952,-0.0},
{0.05910145568678057,-0.9967245496279897,-0.05520135962623159},
{0.0026999901045544,-0.9999963350201482,0.00019999926700402964},
{-0.015399463646021651,-0.9998651753024058,-0.00569980147937165},
{-0.023501117974773722,-0.9994475448505896,0.023501117974773722},
{0.0643015709065661,-0.9969243551594985,-0.04480109450410827},
{0.0,-0.2755926900008453,0.961274502531976},
{-0.003100040626298613,-0.3007039407509655,0.9537124984841895},
{-0.9998828721530988,0.015299737917734185,-0.0003999931481760571},
{-0.9998531929683813,0.01709919951971129,-0.001099948507115931},
{-0.9998634706553873,0.016499397205534446,-0.0008999671203018787},
{-0.9998991750835209,0.014199988285014498,0.0},
{0.9879929605752337,-0.1544988991992648,-0.0},
{0.9546978137445098,-0.29749931872734015,0.00679998442805349},
{-0.0029999344671473404,-0.3004934357925919,-0.953779164921711},
{0.0,-0.2755926900008453,-0.961274502531976},
{0.010399367685671224,-0.6456607417921068,0.7635535735363987},
{0.007400332504409303,0.449320188409608,0.8933401386741662},
{-0.007800000078000001,0.3995000039950001,0.9167000091670001},
{-0.008200007831011219,0.8086007722141061,0.5883005618273048},
{0.0256005936846514,0.8445195846362542,0.5349124047625013},
{-0.005599928293377302,0.9792874603043557,0.20239740831777964},
{0.031001549341143454,0.9993499437614404,-0.01840091960893676},
{-0.010599725682648952,0.9677749543082694,-0.2515934888447619},
{0.030399939656179677,0.8258983605933814,-0.5629988824483275},
{-0.001699996821008917,0.7446986074149062,-0.6673987519655007},
{0.0057001844324510165,0.4006129620420837,-0.9162296450897581},
{-0.030600625330167996,0.42660871783822446,-0.9039184717627077},
{-0.012100498490303174,0.19240792640779592,-0.9812404230318573},
{0.02699968613047309,0.15279822373097363,-0.9878885158627543},
{-0.0,-0.6524944244589643,0.7577935246819972},
{-0.7124850272844758,-0.7016852542393216,-0.0016999642756261176},
{-0.6609049535011898,-0.7504056243112314,-0.009800073451825783},
{-0.00930043364282813,-0.9999466235982631,-0.004500209827174901},
{-0.7105978824214655,-0.7035979032813723,0.0007999976160106564},
{-0.9999909351232594,0.0006999936545862817,0.00419996192751769},
{-0.9999951900347038,0.002899986051100641,-0.0010999947090381743},
{-0.9998140374876302,-0.019200269573677233,-0.0018000252725322407},
{-0.9998282055515235,-0.017700499338129592,-0.005500155161565692},
{-0.9983543063690723,0.049297743693905514,0.02929865903106352},
{-0.9993895414431729,0.034899634777233075,0.0015999832562628347},
{-0.9995996701321633,0.02809999072700459,-0.003299998911000539},
{-0.9980105290666228,0.05290055810383201,-0.03430036187072661},
{-0.9998194166816098,-0.014400279656146408,0.012400240815014963},
{-0.9998405943522127,-0.017400706483025104,0.004000162409890829},
{-0.9999903001411327,0.004399957320620984,-0.00019999806002822654},
{0.0006000082171688016,-0.8844121121068135,0.4667063915877995},
{-0.019299921449479552,0.23169905698675708,0.9725960415421663},
{-0.007400332504409303,0.449320188409608,0.8933401386741662},
{-0.027699087468594775,0.18059405042701143,0.9831676100766203},
{0.03689947344827081,0.48219311915328417,0.8752875097363534},
{0.008200007831011219,0.8086007722141061,0.5883005618273048},
{-0.0256005936846514,0.8445195846362542,0.5349124047625013},
{0.005599928293377302,0.9792874603043557,0.20239740831777964},
{-0.031001549341143454,0.9993499437614404,-0.01840091960893676},
{0.010599725682648952,0.9677749543082694,-0.2515934888447619},
{-0.030399939656179677,0.8258983605933814,-0.5629988824483275},
{0.001699996821008917,0.7446986074149062,-0.6673987519655007},
{-0.0057001844324510165,0.4006129620420837,-0.9162296450897581},
{0.030600625330167996,0.42660871783822446,-0.9039184717627077},
{0.012100498490303174,0.19240792640779592,-0.9812404230318573},
{-0.02699968613047309,0.15279822373097363,-0.9878885158627543},
{0.00930043364282813,-0.9999466235982631,-0.004500209827174901},
{0.6609049535011898,-0.7504056243112314,-0.009800073451825783},
{0.7124850272844758,-0.7016852542393216,-0.0016999642756261176},
{0.7105978824214655,-0.7035979032813723,0.0007999976160106564},
{0.9999909351232594,0.0006999936545862817,0.00419996192751769},
{0.9999951900347038,0.002899986051100641,-0.0010999947090381743},
{0.9998140374876302,-0.019200269573677233,-0.0018000252725322407},
{0.9998405943522127,-0.017400706483025104,0.004000162409890829},
{0.9999903001411327,0.004399957320620984,-0.00019999806002822654},
{0.9998194166816098,-0.014400279656146408,0.012400240815014963},
{0.9995996701321633,0.02809999072700459,-0.003299998911000539},
{0.9980105290666228,0.05290055810383201,-0.03430036187072661},
{0.9983543063690723,0.049297743693905514,0.02929865903106352},
{0.9993895414431729,0.034899634777233075,0.0015999832562628347},
{0.9998282055515235,-0.017700499338129592,-0.005500155161565692},
{0.001800042616513425,0.11790279138162935,0.9930235101099061},
{-0.0027998689412022213,0.47927756554222306,0.8776589177475678},
{-0.030900006489002044,0.26190005499901736,0.9646002025660638},
{-0.02720091342200932,0.7544253340280821,0.6558220228732984},
{0.02529966642609724,0.7871896209732707,0.6161918755636806},
{-0.0013999677941113405,0.971777644512429,0.23589457330776087},
{-0.03209913750776259,0.9937732976702325,0.10669713308655042},
{0.00959967452855257,0.9721670392352927,-0.23409206324314136},
{-0.02860038367672055,0.9089121931388571,-0.41600558075229893},
{0.6667878345669364,0.5819893817005953,-0.46549150718492643},
{-0.002999960040798383,0.6489913554927169,-0.7607898663464701},
{0.6517732061542312,0.24229003966120005,-0.7186704560648143},
{-0.004200048699847013,0.23940277589127978,-0.9709112577813014},
{0.0024999929250300334,-0.734597921090825,-0.678498079853151},
{-0.003600064135713872,-0.7210128449582505,-0.6929123443433727},
{-0.00279997881824036,-0.7259945078723219,0.6876947976085341},
{0.00490003662791069,-0.733005479236436,0.6802050845520106},
{0.9999876302295208,-0.002499969075573802,-0.004299946809986939},
{0.999463270399707,-0.011699570048700921,-0.030598875511987023},
{0.9994486093652035,-0.0026001264602256643,0.0331016099359498},
{0.9999909901217683,-0.00409996305949925,0.0010999900891339451},
{0.0,-0.7624941860039975,0.6469950666814249},
{0.7082025318285771,0.0031000110825594304,0.7060025239635348},
{0.9999893751693331,0.004599951125778932,0.0002999968125507999},
{0.0,-0.7625853699400151,-0.6468875895806397},
{-0.9996110157740911,-0.0052000573049472525,-0.027400301952991292},
{-0.7079041235535295,0.002500014562627241,-0.7063041142334482},
{-0.1376970953104113,0.09529798971011036,0.9858792030975636},
{-0.9999846953513555,-0.005499915824432455,0.0005999908172108132},
{-0.9999874552360607,-0.004999937276180304,-0.0002999962365708182},
{-0.9999908751248965,-0.0014999863126873448,0.003999963500499586},
{-0.9999987900021962,-0.0010999986690024158,0.0010999986690024158},
{-0.9999987950021781,-0.0014999981925032672,0.00039999951800087126},
{-0.9999997400001014,-0.0005999998440000607,-0.00039999989600004055},
{-0.9999989900015303,-0.0010999988890016833,-0.0008999990910013772},
{-0.999929143359581,-0.010100294377369505,0.006300183621527513},
{-0.9999978750067734,-0.0018999959625128693,-0.0007999983000054187},
{-0.7079049199562906,0.0020000139001449093,0.7063049088361747},
{0.14620616345073315,0.020500864232147944,0.98904169393143},
{0.00019999998700000128,-0.0002999999805000019,0.9999999350000064},
{-0.6302746035965118,0.276488859105879,-0.7254707677443588},
{-0.6418297045661069,-0.3188147550883061,-0.69743227791275},
{-0.6261890167409687,-0.7291872101684995,-0.2759951590873641},
{-0.6321367313719455,-0.6487376959990209,0.423724621234446},
{-0.6251860928900438,0.644085672473572,0.44079019473117614},
{-0.6362917855260729,-0.03419955848654989,0.7706900504556725},
{-0.6339972579677889,0.7343968237406061,-0.24229895205929852},
{0.01620007735555406,-0.35400169036210716,-0.9351044651344815},
{0.02030038632002754,-0.9093173044729578,-0.4156079090937658},
{0.022300413341991978,-0.9342173158784263,0.35600659864345935},
{0.031899102052915636,-0.36368976227728583,0.9309737934565662},
{0.013700378478183263,0.36951020786049016,0.9291256674510999},
{0.01619977344775249,0.8932875074615617,0.4491937180697789},
{0.0050999311258952155,0.9799867653681,-0.19899731255944075},
{0.03340199916947723,0.5325318729864259,-0.845750619689428},
{0.9998131276325494,-0.010700140493767031,0.016100211397163475},
{-0.990847655964048,0.00460022125296187,-0.13490648848359918},
{9.999999500000038e-05,-0.00029999998500000106,-0.9999999500000037},
{-0.14629606907743511,0.01819951098570963,-0.9890734239541427},
{-0.00019999998700000128,-0.0002999999805000019,-0.9999999350000064},
{-0.9950695364124569,0.015899513243852945,0.09789700292913228},
{-0.9967260049207071,-0.06770176636212688,0.04420115322313159},
{-0.9964119071934368,-0.06950083053988747,0.04830057719534625},
{-0.9958814220053572,-0.014499729510068964,0.08949833042421877},
{-0.9836130919773819,0.11590154265979927,0.1381018381476987},
{0.0,-0.9925553360147963,-0.12179451936993974},
{0.002099958389736757,-0.9928803262712506,-0.1190976401036418},
{0.9929185627860486,-0.0908016975536038,0.07660143207715915},
{0.9941680081882365,-0.017599433659337117,0.1063965762132653},
{0.9930578406242956,-0.08969619202899941,0.07609676938023249},
{0.0,0.6428754394129969,0.7659707366469989},
{0.0,-0.9920687999268557,0.1256960469214855},
{-0.0016000489542466443,-0.9923303608118407,0.12360378171555328},
{-0.9973778335239721,-0.05949867765658346,-0.041199084360525016},
{-0.99632095284996,-0.01840038696420683,-0.08370176026652781},
{-0.9987974580637038,-0.03739990481736336,-0.03169991932380798},
{0.0,0.6428754394129969,-0.7659707366469989},
{0.9862538000228316,0.10619502541054925,-0.1265940698396943},
{0.9953550856151197,0.01219944951226086,-0.09549569085417313},
{0.9965521367502801,-0.013299361247018587,-0.08189606662637762},
{0.993334265656501,-0.0806027804408678,-0.08240284253508073},
{0.9926833329867575,-0.08299860646509608,-0.08769852755408344},
{0.07659799583965794,-0.3250914940923342,0.942575337838924},
{0.0652014002151046,0.8720187268032393,0.48511041785808645},
{-0.0652014002151046,0.48511041785808645,0.8720187268032393},
{-0.07659799583965794,0.942575337838924,-0.3250914940923342},
{0.031199649161917746,0.6935922005995561,-0.7196919071100065},
{-0.036201644859102114,-0.15630710197452097,-0.9870448474014857},
{0.05619814183915962,-0.308789790034386,-0.9494686063395384},
{0.036201644859102114,-0.9870448474014857,-0.15630710197452097},
{-0.05619814183915962,-0.9494686063395384,-0.308789790034386},
{-0.031199649161917746,-0.7196919071100065,0.6935922005995561},
{-0.9884752736002924,0.09569760615432268,-0.11729706585059615},
{-0.9969883153654154,-0.031199634342428246,0.07099916789462837},
{-0.999375710468532,0.031499234420411006,-0.015999611134177017},
{-0.9998045191266397,-0.002600011752079679,-0.019600088592600658},
{-0.9898327194613217,-0.09840325277328152,-0.1027033949168294},
{-0.9998264907538134,-0.018100479578559734,-0.004400116582633306},
{-0.9991730576617454,-0.03399908322708101,0.02229939870482078},
{-0.9984209970143532,0.030300637229101465,0.047300994750379514},
{-0.9992777663170465,-9.999777507425663e-05,0.03799915452821752},
{0.0587019691905853,-0.5329178770300325,0.8441283167593364},
{0.031199649161917746,0.7196919071100065,0.6935922005995561},
{-0.031099137632869995,0.36528987065232826,0.930374201081101},
{-0.058700862322001314,0.9838144523404582,-0.1693024870718028},
{0.05619814183915962,0.9494686063395384,-0.308789790034386},
{-0.03109891622165419,0.11249607957993879,-0.9931653887892906},
{-0.03309960760647772,0.018099785428315616,-0.9992881535091598},
{0.03110076539925483,-0.9606236412387199,-0.2761067950718411},
{0.033101355362743556,-0.930138085283619,-0.36571497450620305},
{-0.056202208790209034,-0.6486254914827326,0.759029830458517},
{-0.9998021145837086,0.007800016497052337,0.018300038704622792},
{-0.9992546298735225,0.03859824748635843,0.0005999727588553122},
{-0.9891279630427784,0.09190259812317393,0.1148032455336275},
{-0.9887439110921591,-0.11500510749023798,0.09570425032013716},
{-0.9992777263477169,0.00029999331322357156,-0.03799915300831907},
{-0.9971868671354392,0.011299851181939895,-0.07409902412227842},
{-0.9980652529630666,0.0030998920791358645,-0.06209783810139909},
{-0.9992771218121911,-0.037699136888141305,-0.004899887818352583},
{-0.999762804516774,-0.01309951264169808,0.017399352669125692},
{0.4683890093808407,-0.8833792717485797,-0.015899626919631444},
{0.4762928127956819,-0.8792867316633279,0.0},
{0.33681098526942976,-0.9407306824315694,-0.039801298140508624},
{0.38690720621382424,-0.9215171634170044,-0.03330062022982773},
{-0.02330052694737544,-0.03180071918139653,0.9992225976745724},
{-0.023500735937068983,-0.013600425904005878,0.9996313039444321},
{-0.1348993214581196,-0.12379937729069834,0.9830950550443097},
{-0.09220083073322738,-0.0917008262281665,0.991508933535737},
{-0.5308933877640328,0.8472894470756545,0.0158998019691997},
{-0.523277046955742,0.8521626207064461,0.0},
{-0.6463220625801657,0.7620260122018974,0.039801358642566294},
{-0.6046137974442883,0.7958181607776458,0.03340076221409068},
{-0.03920086693675857,-0.004300095097654639,-0.99922209804105},
{-0.02350076778262539,-0.013500441066614586,-0.9996326585324401},
{-0.17460132872116738,-0.05490041779376912,-0.983107481476401},
{-0.12550134914675504,-0.0340003655058938,-0.9915106587968734},
{0.21071078550759137,-0.9767499962281182,-0.03950202196274257},
{0.3386096894548976,-0.9409269250091942,0.0},
{-0.24511234294280113,-0.18720942716806355,0.9512479012941348},
{-0.1534952532326895,-0.0885972601720931,0.9841695650267949},
{-0.7404972934873384,0.6708975478739437,0.03949985562829151},
{-0.6455880405923209,0.7636858528506126,0.0},
{-0.28459167012372144,-0.11869652580353385,-0.9512721566714554},
{-0.1533989683954063,-0.08849940484350362,-0.9841933813217657},
{-0.7528153500614833,-0.6383130153350753,-0.16070327677322047},
{-0.7528153500614833,-0.6383130153350753,0.16070327677322047},
{-0.7286196839266456,-0.6849185033233043,-0.0},
{-0.8430139562115686,-0.4867080575185889,0.229003791189145},
{-0.9292341871546298,-0.33271224070850763,0.16070591247928218},
{-0.9574815686572035,-0.2884944465353558,-0.0},
{-0.9292192489761159,-0.3327068920946553,-0.1608033310755052},
{-0.8429946470009873,-0.48669690948443717,-0.2290985452288567},
{-0.7063310298037239,0.014600641420266697,-0.7077310913097768},
{-0.9911389872188585,0.010600416975602765,0.13240520826130245},
{-0.7080025912942262,0.0032000117120642995,-0.7062025847061901},
{-0.0,0.011900347376209942,-0.9999291883590185},
{-0.0,0.002899987805576916,-0.9999957950265228},
{-0.9970004536353095,-0.005500002502501707,-0.07720003512602397},
{-0.4995063587564207,-0.2570032716724727,0.8273105317301038},
{-0.7067001307395363,0.00430000079550022,0.7075001308875363},
{0.0,0.0035999766722267456,0.9999935200629849},
{-0.011100403451495301,0.7877286305173737,0.615922386105942},
{-0.5498027242792483,0.6866034021282864,0.47570235711101927},
{-0.7052841418643533,-0.33979235985468204,0.6221860103048357},
{-0.7063670946553253,-0.33608434387550234,-0.6229709795728591},
{-0.5765935047107539,0.6540926316880058,-0.4895944847491937},
{-0.042600164223949626,0.8197031599617725,-0.5712022019887331},
{-0.220908949202802,-0.294911947124972,-0.9296376603844487},
{0.01710073868236142,-0.004600198709875002,-0.9998431891593538},
{0.0,0.011900347376209942,0.9999291883590185},
{0.017699795214554042,0.9967884672241508,-0.07809909639868196},
{-0.019500628905423464,0.9969321515803411,0.07580244466826147},
{-0.0418987828580367,0.9967710442217419,0.06849801016170678},
{-0.25959478089939453,0.6057878207582943,-0.7520848794854954},
{0.0025998972930861147,0.6834729999324459,-0.7299711630587937},
{-0.020699383374553768,0.9421719331161624,0.33449003569025293},
{-0.00810028371740589,0.43471522616744945,0.9005315416696301},
{0.04970108498652801,0.0385008404825217,0.9980217870534196},
{-0.07189878276391164,-0.6300893326778959,0.7731869100564183},
{0.132999803160437,-0.8319987686427336,0.5385992028737696},
{-0.8800110662087368,-0.3917049257204116,-0.2686033777087122},
{-0.03620117148886438,-0.7378238763669651,-0.6740218116987455},
{-0.5703019760997707,0.813302818099147,0.11530039951657647},
{-0.5609175401657258,-0.12470389955190946,0.8184255925684257},
{-0.1810977308596484,0.7918900776794896,-0.5831926926413415},
{-0.927111412811738,0.22410275872193988,-0.30040369799228356},
{0.6480093508423995,0.6383092108683697,-0.41550599579477926},
{-0.012699254131212262,0.7866537972460383,-0.6172637460785299},
{-0.738639089814977,0.49422615514021334,-0.4584242604538118},
{0.5888078400285853,0.7852104551468159,0.19170255253648066},
{0.1298959414647124,-0.22879285147903158,0.9647698562367555},
{-0.015299599920693043,-0.8154786755114495,0.5785848702034637},
{0.7996611134255581,-0.5273743544087024,0.2870860393453517},
{0.9957439431498383,0.04340191536878877,-0.08130358800650983},
{0.9667881182470396,0.12029852154025535,-0.2254972286560896},
{-0.9607944802515663,-0.265798472992159,0.0788995467234061},
{0.9332998740045254,-0.32969995549050896,0.1422999807895039},
{0.9621770571616047,-0.25819384344120383,0.08689792794361198},
{-0.966853659814601,0.12109419609426847,-0.2247892261105826},
{-0.0183000309270784,0.8213013880005186,0.5702009636404428},
{0.2237985397192925,0.29349808493124374,0.9293939357243541},
{-0.12150141246212984,0.3873045024410114,0.913910624272761},
{-0.09999717162000055,-0.918074032643225,-0.38358915033432206},
{0.10499674252659388,-0.8523735555206536,0.5122841066321338},
{0.08280315941482236,-0.5743219136706822,-0.8144310752105233},
{-0.01180032445438137,-0.0024000659907216343,-0.999927493384401},
{0.006400227564136637,0.3157112253121775,-0.9488337363832564},
{-0.0031001035761907495,0.9526318279610672,-0.3041101604901958},
{0.014000554292916904,0.9469374899973583,-0.3211127131039727},
{0.0012999715439343516,0.9102800741872616,0.41399093783755503},
{-0.6269186134899559,0.6526193765569392,0.42551263365764275},
{-0.5751942020716646,0.6683932626298689,-0.4715952463438752},
{-0.01269941450699092,-0.43038015778022776,-0.9025583885047248},
{0.02100056145751595,-0.8163218246557271,-0.577215432060867},
{0.6070397988338601,0.6888451621692963,0.39622597742664806},
{-0.327299206300387,0.7229982467313774,0.6083985246353666},
{0.5627019272574013,0.6131020998782881,-0.554501899172257},
{0.5674959764677903,-0.4231969995439098,-0.7062949923862559},
{-0.08909678856413326,-0.8091708339629253,-0.5807790661958316},
{0.8848063485083258,-0.37940272222429794,-0.2705019408583885},
{0.8010590428981782,-0.5223732917363728,-0.29228505584713205},
{0.0,-0.814273642388787,-0.5804812101273374},
{0.997411540118279,0.035900415370208764,0.06230072082350992},
{0.9673658670975586,0.1265955331554175,0.2194922553524024},
{0.3940016351101786,0.733303043213944,0.5541022995293147},
{-0.9915887157846212,0.1051988028444354,0.07539914196264666},
{-0.7274835190475619,0.5214881858189738,0.4458898984787737},
{0.0,0.8126916374460759,0.5826940041095464},
{-0.9968245770129232,-0.07740190836757649,-0.018700461065551427},
{-0.9585350542679136,-0.277010130445709,-0.06690244666721275},
{-0.9818083748611566,0.09090077538692108,0.1667014219691941},
{-0.9669594610743739,0.1220948812794013,0.22379061777502057},
{0.9792001909440559,-0.19440003790801108,-0.058100011329503314},
{0.9608738357616735,-0.26539277345316703,-0.0792978407491942},
{0.22139514153692788,-0.003299927583883749,-0.9751785999404338},
{0.9986464331453888,-0.011600539379617974,0.050702357460916496},
{0.6136733732899868,-0.012199470676450774,-0.7894657458244169},
{-0.6480040824385791,0.16920106597007342,-0.7426046784242112},
{-0.47281160293910596,-0.06420157552599534,-0.8788215665458678},
{-0.9725125552181324,-0.026800345994700204,-0.23130298614082676},
{-0.6729273012144267,0.5813235847762612,0.4574185578473454},
{-0.6434957690292279,-0.023299846804010895,0.7650949695171131},
{0.6257186154057166,0.28010833334687746,0.7280216589665361},
{0.8956995790212967,0.007299996569002418,0.4445997910381473},
{0.9330351667581652,-0.07390278544847631,-0.35211327139930326},
{0.5033158899334716,0.017400549344014322,-0.8639272746145961},
{0.8541633144734482,0.011499506106818842,0.5198776717334883},
{0.7474701391643986,0.00539978428292676,-0.6642734628052308},
{-0.6068874345257509,-0.0025999461686718604,-0.7947835441770749},
{0.629707452631803,-0.00600007101126063,-0.7768091935912095},
{0.7333025995623232,0.00010000035450188507,0.6799024102583165},
{0.4088078716713543,-0.0023000442877791462,0.9126175726205429},
{0.9726226964154343,0.23110539290726595,0.024400569393930288},
{-0.4351758723426184,0.2843842327533104,-0.854252637275503},
{-0.9208861822065032,0.005399918974823669,-0.3897941511826419},
{-0.7434289719915688,-0.01090042479783172,0.6687260607623917},
{-0.40011036699391495,0.008900230607962616,0.9164237448468474},
{-0.8599301797792483,-0.055201937345987336,0.5074178081404704},
{-0.7413975348572949,-0.09849967248913347,0.6637977928760079},
{0.3643793748892101,-0.056296813409062924,0.9295473844594119},
{-0.9922014833423264,0.016100024069553978,-0.12360018478241439},
{-0.4112900839156137,0.2677935435754956,0.8712789937166892},
{0.6022028785366391,-0.5756027513877274,-0.5532026443149598},
{-0.7830129315653481,-0.06490107185005248,-0.6186102164320874},
{-0.7381951131645262,-0.05179965708740512,-0.672595547432214},
{0.7843195847045482,0.023400584319885794,-0.6199154794827865},
{0.30939552307917134,-0.8926870829113648,-0.3276952582839187},
{0.008799793867242963,-0.20899510434702034,-0.9778770934973742},
{0.8765071085014752,-0.16230131626901245,0.45320367549671253},
{-0.8246105179742357,0.26020331891449927,-0.5023064069590815},
{0.3039026333277267,0.3295028551546099,-0.8939077457441754},
{-0.20820273892504595,0.8937117568554926,-0.3974052279001597},
{-0.6991168559105966,0.6844165014807785,0.20690498853941125},
{-0.4637176656609664,0.5994228354478829,-0.6524248545982628},
{0.5859330680658208,0.3876218760578804,-0.7116401625458919},
{0.5005696263565811,-0.035997815718811256,-0.8649475165769928},
{-0.9663765125042919,-0.10139753556284686,-0.23629425693787684},
{-0.9298408581049774,0.24581080116390994,0.2738120315650063},
{-0.17349782261598914,0.5850926571332291,0.7921900580771563},
{-0.002599977939280777,-0.04699960121007559,0.9988915244413725},
{0.763818286028654,0.6022144171857232,0.2322055590676269},
{0.9726199680929195,-0.006700137555236028,0.23230476926587004},
{0.10889770718291264,0.14729689869644658,-0.9830793014832087},
{0.9185723467957434,-0.21449354276909097,-0.3319900055913203},
{-0.8435072963696705,-0.16940146532901265,-0.5097044089622064},
{-0.8868920800890869,0.20919813186902356,0.4118963217822696},
{-0.1845894436315694,-0.170890227067363,0.9678446505471074},
{0.7412640162117282,0.16039221394895614,0.651768360672878},
{-0.9489799340314402,0.23049512623208324,-0.21519544974032237},
{0.21340140738692256,-0.43130284445163874,-0.8766057812341909},
{-0.7921813483097285,-0.5631867399243109,-0.23509446476598989},
{-0.42060656992593376,-0.2382037207711779,0.8754136740683843},
{-0.013700324084999391,-0.15240360514992024,-0.988223376700467},
{0.990772090343317,-0.03869890986706335,0.12989634087161572},
{0.9498271084525183,0.060801735306288816,0.3068087564468653},
{-0.811484492679516,-0.23259555514141148,0.5360897554226599},
{-0.6354166100072812,-0.07600198671789954,0.7684200867636054},
{0.6735903407837692,-0.12539820180267913,0.7283895549686721},
{0.6271998463360564,-0.055199986476004964,0.77689980965957},
{-0.4337061695141423,-0.8519121185360798,0.29350417512658694},
{-0.02519946174524562,-0.7787833653649718,-0.6267866119809506},
{0.7482084211331701,-0.4095046090003116,0.5220058752091885},
{-0.135201497364875,0.3940043636224908,0.9091100684497624},
{-0.3066969238452807,0.2205977874152883,0.9258907133627173},
{-0.75662274063821,0.1028030897932963,0.645719407388438},
{-0.3830099871156228,0.12370322560366198,-0.915423869988619},
{-0.886080041271853,-0.10279768450823439,0.4519898190439878},
{0.6991209250024326,-0.12370370250722489,0.7042210776522859},
{0.9464770103526244,0.1651959874381971,0.27729326462840226},
{0.10600316212148982,-0.16530493111964403,-0.9805292496237809},
{-0.7010329317954748,-0.05840274353331774,0.7107333874850842},
{0.39550529585136746,0.2976039849440378,0.8689116348046856},
{0.6405827525415786,0.4814870361360757,-0.5981838941154735},
{0.594603359518472,-0.7565042742612244,0.27230153850803884},
{-0.9070746294774152,0.3331906807869857,0.25729280362092266},
{-0.9428645442454578,0.23579113324114856,0.23539114828230012},
{0.6239923093421809,0.2507969089471458,0.7400908784361346},
{-0.8913226978215038,-0.2063052536301764,0.4037102806131954},
{0.6384156892583477,-0.41251013756119737,0.6498159694236754},
{-0.9179986734928752,-0.16999975435053244,0.3582994822576222},
{0.6488977613065852,-0.721197511872876,0.24249916337932947},
{-0.8955030357604369,-0.3911013258357419,-0.21240072003966143},
{0.6288862589853601,-0.723184198597889,-0.2854937620294487},
{-0.8904066736230283,-0.3926029425700819,-0.23030172611790592},
{0.6392960587519466,-0.3627977633586833,-0.6779958201686529},
{-0.9268713647515221,-0.16269497361643398,-0.3382895487058366},
{0.6292792498588482,0.17389426593111984,-0.7574750226729342},
{-0.8980336544418122,-0.10040376270151219,-0.4283160514447975},
{-0.8860984493290704,0.2344995896260772,-0.39979930035183653},
{0.6311279406524127,0.7051312168499702,-0.32321430901419707},
{0.6396880667304218,0.7138866825681539,0.2848946853392171},
{-0.8922137580422244,0.43760674794808047,0.1116017209118048},
{-0.8469356948570554,0.3269137780715214,0.4193176725157201},
{-0.7858321018970572,-0.4729193191487889,-0.39851627972254683},
{-0.647694264692679,-0.6900938892456658,0.32289714075847775},
{-0.6677978363385154,0.27419911159631766,-0.6919977579308965},
{-0.5695940164462856,-0.4456953179952765,-0.6905927453613148},
{-0.9285066806296007,-0.023000165486786017,-0.37060266649577817},
{-0.8072269537579865,0.25830862506898894,-0.5307177209605592},
{-0.17859927846037252,-0.2655989269825025,-0.9473961725271944},
{-0.0862990740159037,-0.847090910763291,-0.524394373278562},
{-0.6672014111324768,-0.717301517094313,0.20080042469334733},
{-0.4055040165371758,-0.3635036005209948,0.838708307446928},
{-0.2494027958210118,0.21110236647079228,0.945110594749151},
{-0.13139840680397616,0.7222912422717808,0.6789917672747323},
{-0.12360116432845199,0.9922093466560684,-0.015600146954076464},
{-0.20669158885693373,0.6004755641441156,-0.7724685650313561},
{-0.8310051314725303,-0.5032031072887813,-0.2371014641060613},
{-0.9998231311757128,-0.0020000462716057467,-0.018700432639513733},
{-0.999894270622244,0.006899960463339817,-0.012799926656630387},
{-0.9990863575689305,-0.03129957260725406,-0.029099602647638754},
{-0.859073871665534,-0.4680857633880066,0.20709370134085914},
{-0.6411963804566484,-0.3170982099856569,0.6987960553074016},
{-0.9999806555613254,-0.0036999284255769043,0.0049999032778066275},
{-0.8681800798365996,0.2012953813304625,0.45358959250619857},
{-0.7338711227394691,-0.020699185503075365,0.6789732829269649},
{-0.22418886481562006,-0.834658543539688,0.5030750128846496},
{-0.6591253801114012,-0.35731375863116926,0.6617254802301838},
{-0.19689762346002718,-0.5181937454392386,0.8322899543208767},
{-0.9995470098013324,0.01880088422637824,0.023501105282972796},
{-0.822684348579151,0.49899050679591145,0.2723948177378883},
{-0.9992068246059181,0.03970027115377797,-0.0031000211732169197},
{-0.12550521798790903,0.8514353991625956,0.509221171310305},
{-0.18399684632108088,0.41679285623166584,0.8901847423642728},
{-0.686923788582705,0.6328219150023814,0.3573123739417681},
{-0.6392023362888087,0.335901227721231,0.6918025285428627},
{-0.777231486285277,0.551722350725151,-0.3025122550196813},
{-0.17449253624138997,0.7122695333223042,-0.679870919143387},
{-0.7258029322497694,0.5668022898858768,-0.3898015748015433},
{-0.8727319643935546,0.2339085670581556,-0.42851569467473144},
{-0.6813186581669344,0.5755157607149137,-0.4523123867443188},
{-0.2432999343090266,-0.6822998157790746,-0.6893998138620754},
{-0.2117012850307002,-0.714904339482511,-0.6664040450848305},
{-0.6722208727821548,-0.6555203542230028,-0.3441106848026473},
{-0.1817034714779842,-0.45430867965023786,-0.8721166619479913},
{-0.014200401593035658,0.23360660648824857,-0.9722274949823426},
{0.0,0.007599780521507763,-0.9999711212510214},
{-0.006200276848542068,0.008500379550420578,-0.9999446485253571},
{0.007500079276256927,0.31060328309405355,-0.9505100469442945},
{-0.008599984950039505,0.7326987177783658,-0.680498809128126},
{0.02060034691276304,0.6036101648807656,-0.7970134218190361},
{0.014799384062452715,0.9067622613400083,-0.42138246242686306},
{-0.027300481994264453,0.9726171717077511,-0.23080407488191337},
{-0.016799441847816753,0.9960669062268017,0.08699710956905105},
{-0.03859813961450479,0.9637535481984383,0.26398727611992917},
{0.0,-0.785568263683208,-0.618775001994869},
{0.019399482622697584,0.047698727891890454,-0.9986733657364989},
{0.011300398967628453,-0.5989211452843081,-0.8007282702106285},
{-0.005499877629084114,-0.15449656248972649,-0.9879780177336555},
{-0.029898679553975602,-0.7605664103262155,-0.6485713564785477},
{0.029898623798019136,-0.9717552711342808,-0.23408922512094582},
{-0.011300462367876865,-0.9998409093277247,-0.013800564661654932},
{0.006300233049930855,-0.8893328970323031,0.45721691276641063},
{-0.03599994006014969,-0.7676987217826923,0.6397989347356604},
{0.03979979980751045,-0.4258978577391633,0.9038954534173038},
{0.003899887099902663,-0.22749341416098867,0.9737718097141572},
{-0.12680273643257864,-0.12180262852908579,0.984421244039672},
{-0.16940646636823428,-0.2043077985775104,0.9641368018041007},
{0.009599604312465192,-0.10179580406343297,-0.9947589968792055},
{-0.01769964406373678,-0.14219714044425819,-0.9896800977333499},
{-0.0055998783159662766,0.0882980813035397,0.9960783554525015},
{-0.07269687301125967,0.48647907455265244,0.8706625492558983},
{-0.002499876084213682,0.24918764807441982,0.9684519950243804},
{-0.00850035553480552,0.7537315254803436,0.6571274849318479},
{0.04960044442197303,0.7936071107515685,0.6064054334170252},
{-0.10799470136996274,-0.0006999656570275362,0.9941512231668236},
{-0.01009966080858752,-0.4295855726108117,0.9029696742727258},
{0.0,-0.4264133874584522,0.9045283981148452},
{0.0,-0.7918389079606375,0.6107300089562533},
{0.0,-0.7917905460773194,0.6107927071786142},
{0.9986101209648642,-0.027600279730252607,-0.044900455068418194},
{0.9987078598617858,-0.016400129069523667,-0.0481003785514688},
{0.9987899721990184,-0.004199957832635039,-0.048999508047408796},
{0.9987603849549805,-0.03699853248231305,-0.03329867923408175},
{0.9986008338320445,-0.0414000345690433,-0.03290002747153441},
{0.9986487302537181,-0.05070247408758613,-0.011400556303717592},
{0.9987982820684324,-0.048999915720217446,-0.0009999982800044376},
{0.9986036299307922,-0.0511001857495128,0.013400048709265587},
{0.9986974533247409,-0.03899990055038039,0.03289991610532089},
{0.9986122730202536,-0.038900478089813596,0.03550043630304326},
{0.9985700034076396,-0.010599681590347467,0.05239842597492521},
{0.9985354136864307,-0.0209007412579333,0.04990176979764936},
{0.998314445714545,0.007100102739229962,0.05760083349009095},
{-0.9999999900000002,-9.999999900000002e-05,9.999999900000002e-05},
{-0.999999995,-0.0,9.999999950000001e-05},
{-0.9999999800000006,-0.0,0.0001999999960000001},
{-0.9999999150000108,-9.99999915000011e-05,0.0003999999660000044},
{-0.9999999900000002,-9.999999900000002e-05,-9.999999900000002e-05},
{0.9999994700004213,0.0004999997350002106,0.0008999995230003792},
{0.999999995,-0.0,9.999999950000001e-05},
{0.9995955168241605,0.01849991702805819,-0.021599903124651727},
{0.999136439170417,0.026500966507873133,-0.0320011671038468},
{0.9955001294150253,0.05700000741000145,-0.07570000984100192},
{-0.999999975000001,-9.999999750000011e-05,0.00019999999500000022},
{-0.999999995,-9.999999950000001e-05,0.0},
{-0.999999975000001,-9.999999750000011e-05,-0.00019999999500000022},
{-0.999999995,0.0,-9.999999950000001e-05},
{-0.9999999800000006,0.0,-0.0001999999960000001},
{-0.9485479830548748,0.012599309072835149,-0.31638265005119376},
{-0.40409781585720794,0.13299928114082815,-0.9049951085146577},
{0.0,-0.4844197647296097,-0.8748356940244891},
{0.001300078039526554,-0.48492910874340467,-0.874552496589209},
{-0.07429949142172183,-0.4373970060277406,0.8961938655739852},
{0.0,-0.4684068364476673,0.8835128949648037},
{0.0,-0.0001999999960000001,-0.9999999800000006},
{0.9984977883298483,0.012699971869593462,-0.053299881940892246},
{-0.22479974260444208,0.10249988263770157,-0.9689988904969056},
{0.9947032874997978,0.05090016822533397,0.08930029513796314},
{0.0,-0.7071067811865476,0.7071067811865476},
{0.999999950000004,9.999999500000039e-05,-0.00029999998500000117},
{0.9999999800000006,0.0,-0.0001999999960000001},
{0.9999601423830711,-0.008599657224494411,0.0023999043417193703},
{0.6539765324731908,-0.7468731989361256,-0.1203956796785507},
{-0.9992306768526763,-0.029000890341000417,0.026400810517324517},
{-0.5817720814277023,0.3206846107147888,0.7474641300570772},
{-0.4160108497044423,-0.39721035938126076,0.8180213342746004},
{0.5843925607300526,0.5582928929767084,0.5888925034461464},
{0.7173128902284571,0.6966125182394302,-0.013900249789733102},
{-0.48569301092785877,0.1554977624032984,-0.8601876219891786},
{0.03679998215201299,0.9992995153398527,-0.0067999967020024},
{-0.8585724917780381,0.5103836475698935,0.04859844293083234},
{-0.7546854007521323,0.6087882231057349,0.2445952683503002},
{-0.8520477668126843,-0.5213680385120686,-0.04679713118980593},
{-0.7537950664274354,-0.6115959971172984,-0.24029842725194048},
{-0.916277922549431,-0.04049902418776815,-0.3984903984895212},
{-0.006800285992041219,-0.03270137528525704,-0.9994420324185286},
{0.02199905703063014,-0.014199391356134001,-0.9996571506145887},
{-0.20830256317881,-0.09830120960382631,-0.9731119742165145},
{-0.000399985516786651,-0.016499402567449355,-0.9998637955874308},
{-0.007500186194433444,0.009700240811467255,-0.9999248234418667},
{-0.009999599124106511,0.07329706157970074,-0.9972600206471424},
{0.08039870719918227,0.30799504747945444,-0.9479847565276714},
{-0.358018513616021,-0.6587340640191984,-0.6617342191612321},
{-0.7926197642202342,-0.6096152009445557,0.011100276788852637},
{-0.9999938800561811,-0.0029999816401685433,0.0017999889841011259},
{-0.9987361299330123,-0.025000904424076608,0.043601577315589606},
{-0.9369096595883858,-0.021600222699444057,0.34890359721463104},
{-0.6338909671180774,-0.7447893868268559,0.20849702893850625},
{-0.19409546792373533,-0.003299922947698746,0.9809770944522637},
{0.39470186891777403,0.003000014205100892,0.9188043505488999},
{-0.011200344919932796,-0.0036001108671212556,0.9999307933429288},
{-0.015199422888869156,-0.006699745615488378,0.9998620359592282},
{-0.010300146572128589,-0.04080058059639286,0.9991142174964732},
{0.007500101627065574,-0.010800146342974428,0.9999135489203824},
{-0.02540074196650942,-0.033100966893364635,0.9991291849897466},
{-0.6663767038776417,-0.7419740610402312,-0.07359742707892321},
{-0.7732899704941236,-0.5676926370742454,0.2823963373432568},
{-0.9967851430281639,-0.055899166829127565,0.05739914447212741},
{-0.6740759123276518,-0.6720759837938212,0.3064890478095613},
{0.011599934518554463,-0.9987943618217413,-0.047699730735779995},
{0.007099700185991586,-0.89336227410773,-0.4492810272628196},
{-0.7000094886929292,-0.5992081223211474,-0.38850526622457576},
{-0.9635340856211789,-0.18280646689315153,-0.1954069126418042},
{0.7745020524331584,-0.5533014662508284,-0.3066008124932297},
{0.03680025594667016,-0.9471065871492205,-0.3188022172771317},
{0.04630121634893044,-0.9989262421370759,-0.0016000420336563436},
{0.006199875600744094,-0.9999799356038862,-0.001299973916285052},
{0.46250959717371304,-0.071601485746244,0.8837183373457518},
{0.004499753915187384,-0.3552805702369062,0.9347488799815926},
{-0.42122680351428854,0.4213268098778959,0.8031511061308764},
{-0.6562095347938113,0.02010029205936545,0.7543109602178785},
{-0.0125997182104533,0.6545853603621214,0.755883094863623},
{0.0001999999960000001,0.9999999800000006,0.0},
{0.21859932015717148,-0.2250992999422658,0.9494970470687756},
{9.999999950000001e-05,-0.999999995,0.0},
{0.06629744328839843,-0.8611667897431181,0.5039805643642958},
{-0.06640271692274548,-0.8611352340689176,-0.5040206224256584},
{0.4378200219674173,-0.06990319674628248,-0.8963409906107723},
{0.0019000634061738136,-0.350311690096151,-0.9366312559065231},
{-0.02649914806608429,-0.023699238081743308,-0.9993678708394204},
{0.4493253718734545,-0.22431266617230325,-0.864748829421269},
{-0.6519969845209199,0.022199897325712304,-0.7578964947368179},
{0.6448688987230038,0.014099320006193756,-0.7641631453002318},
{-0.4835201970604557,0.25901081910787593,-0.8361349260853091},
{-0.9917744274260789,-0.12719672027485102,0.014299631288760767},
{-0.9920294438708476,0.1260037398464988,0.0008000237450571352},
{-0.9980885170576667,-0.061799289003270017,-0.00039999539807941757},
{-0.8847786770908201,-0.4659887698059699,0.004599889144007429},
{-0.8537489089252722,-0.5204688534734179,0.014999102405574002},
{-0.6094289363728649,-0.7928376448250857,0.0022001044634399453},
{-0.22328906245315702,-0.9747522529303067,-0.0001999902037198003},
{-0.22120613966161065,-0.9752270678029055,0.00010000277561555636},
{0.00019999999500000022,-0.999999975000001,-9.999999750000011e-05},
{0.001199999130000946,-0.9999992750007884,9.999992750007886e-05},
{-0.9919278487652866,0.12680356005992371,0.0},
{0.7757181093506467,0.6281146635079814,-0.06110142642945019},
{0.9062924506153295,-0.42009650061072484,-0.0463996134928294},
{0.20919247757375722,0.9757649121246287,0.06419769149252014},
{0.6528150116537915,0.5124117830444281,-0.5579128293530181},
{0.9828376237443691,-0.1834070209551458,0.019800757987523922},
{0.8351740682477651,-0.5490829512390419,0.03149902197055148},
{-0.041998120836123844,0.9969553922289398,-0.06569706045079372},
{0.20430012768761974,0.715100446937919,0.6685004178128917},
{-0.2893020453726912,0.7519053159893762,0.5924041883124171},
{-0.6670073371210627,0.5080055880922038,0.5450059950989193},
{-0.7379712750271684,0.6707738906344507,0.0738971236104441},
{-0.18760306921131864,0.7214118023936316,-0.6666109058436301},
{0.29070141426582063,0.7527036619122228,-0.5907028737764713},
{-0.1673945463745172,-0.9827679819407139,-0.07839744585282048},
{0.3874117833085868,-0.7504228244573141,0.5355162879756019},
{0.8078928138253814,-0.18269837490518281,0.5602950161979964},
{-0.26479266931642353,-0.9616733764411047,0.07119802890985406},
{-0.20550106552578712,-0.6577034102010227,0.7247037575987247},
{0.8269830263475745,0.5533886418146889,-0.09929796193024686},
{-0.8099932527843063,0.5824951478356276,0.06789943440006715},
{-0.7956048293359711,-0.24850150840873408,-0.5525033537055355},
{-0.35191267964227535,-0.7272262024321189,-0.5893212336265783},
{0.28059623161791386,-0.7466899720210131,-0.6030919005301634},
{-0.1850019332803042,0.0631006594053362,0.9807102484756451},
{0.16779784213362517,-0.008199894550034127,0.9857873228565416},
{-0.20139946327114558,-0.028399924314302556,-0.9790973907089306},
{0.5727784582072726,-0.8186692104299828,-0.041298446794623536},
{-0.5561774919523419,-0.8294664321727212,0.05149791592151313},
{-0.02320027260480467,-0.32650383644261743,-0.9449111027706867},
{0.6634120742096269,0.40400735300073753,-0.6298114626729319},
{-0.30501384184222136,-0.03100140687576676,-0.9518431956243484},
{-0.9552055688646998,-0.022300130010136938,-0.2951017204480453},
{-0.23979172133372897,0.2229923013236929,-0.9448673790168495},
{-0.08960165854204956,-0.19290357067814018,-0.9771180866231767},
{0.5084179957734462,0.3132110863026029,-0.8021283918369024},
{0.8030742578672394,0.5928809955042786,-0.059698086408509765},
{0.04029850837831805,0.5112810752812411,-0.8584682243867505},
{-0.017900244787521214,0.9818134263904094,-0.1890025846280173},
{-0.0,0.995563080227742,-0.0940965104956112},
{-0.7119893024410957,0.0010999834728724794,0.7021894496827773},
{-0.9833629229999693,0.012899513633007528,-0.1811931682403848},
{-0.17780873684693274,-0.07950390652042268,0.9808481951601329},
{-0.31909049603111145,-0.016999493677621106,0.947571776994927},
{0.025200981219306032,-0.04780186120169954,0.9985388788681379},
{0.0,0.0017999970840070858,0.9999983800039365},
{-0.9860704873519638,0.008799736627824037,0.16609502885017866},
{-0.1347931061828719,-0.028998516908778086,0.9904493447636101},
{0.19380087791996548,-0.07050031936717009,0.9785044326351198},
{0.6683066998082485,0.0665006666725251,0.7409074276341933},
{0.8261123009037413,0.5374080020647266,-0.16950252391137172},
{0.9459869076317969,0.2791961359522175,-0.164797719215349},
{0.5695038327736919,0.8027054022255355,0.1770011912220254},
{0.05279884028620953,0.78848268116811,-0.6127865402914622},
{0.03380062531735261,-0.9490175569872079,-0.31340579806089675},
{0.711514052541308,-0.49890985356691286,-0.4948097725895139},
{-0.9330590442721078,-0.00529976737181671,-0.3596842120080133},
{0.5728253509468716,-0.8186362295480256,0.04130182785283834},
{0.6634680580992457,0.4039805508245596,0.6297696804685832},
{-0.02320027260480467,-0.32650383644261743,0.9449111027706867},
{-0.30498481060975197,-0.030998456160335447,0.9518525941620423},
{-0.9552337537810454,-0.022300788012266867,0.2950104243775213},
{-0.9330935710074435,-0.005099964861363157,0.3595975223816061},
{-0.5561774919523419,-0.8294664321727212,-0.05149791592151313},
{-0.08960165854204956,-0.19290357067814018,0.9771180866231767},
{-0.23979706729980033,0.2228972739830087,0.944888444084993},
{0.5084179957734462,0.3132110863026029,0.8021283918369024},
{0.8030742578672394,0.5928809955042786,0.059698086408509765},
{0.5695139105471497,0.8027196066658421,-0.17690432094080913},
{0.8261123009037413,0.5374080020647266,0.16950252391137172},
{0.19389984972767466,-0.07029994551756333,-0.9784992416633815},
{0.6684026435376828,0.06670026380006498,-0.7408029298813815},
{0.9459869076317969,0.2791961359522175,0.164797719215349},
{0.04029850837831805,0.5112810752812411,0.8584682243867505},
{-0.0,0.995563080227742,0.0940965104956112},
{-0.017900244787521214,0.9818134263904094,0.1890025846280173},
{-0.1777912973289884,-0.0794961087607119,-0.9808519884702177},
{-0.9833629229999693,0.012899513633007528,0.1811931682403848},
{-0.7118900692028014,0.000999986050291897,-0.7022902031199992},
{0.0,-0.999998555003132,-0.0016999975435053243},
{-0.31909049603111145,-0.016999493677621106,-0.947571776994927},
{0.025200981219306032,-0.04780186120169954,-0.9985388788681379},
{0.0,0.0016999975435053243,-0.999998555003132},
{-0.9860504624236548,0.008900455492465039,-0.16620850593794262},
{-0.13439958000196875,-0.029199908750427734,-0.9904969047020094},
{0.052803003520262785,0.7884448480184693,0.6128348590382013},
{0.7115989183704662,-0.49879924182572866,0.4947992479057148},
{0.03380062531735261,-0.9490175569872079,0.31340579806089675},
{0.006800009112018315,0.5072006796493661,0.8618011548143212},
{0.005699844652850951,0.5070861795545117,0.8618765098758306},
{0.008900221662780802,0.697717376867659,0.716317840117965},
{0.0,0.5093692553995881,0.8605480588867012},
{0.027201344595695866,0.0857042364651153,0.9959492309872616},
{0.032600656583835465,0.07800157096745909,0.9964200681022594},
{0.038399144476591485,0.47898932823664897,-0.8769804610929879},
{0.027198876709587358,0.6909714634678259,-0.7223701667281585},
{0.007699911220535437,0.5083941382493787,-0.8610900716887098},
{0.007299823017936371,0.5027878100573161,-0.8643790433841367},
{0.22529916752111398,0.8230969586623565,-0.5212980738071759},
{0.8403198191766557,0.5145121349118045,-0.17070402610193397},
{0.945114654116319,0.3267050656013135,-0.004700072875194899},
{0.8014731150352766,0.5979799410993081,-0.007799738362164888},
{0.8698681851529314,0.4932819585422934,0.0014999451405097103},
{0.9998193966844454,0.01900036861072661,0.00040000776022582334},
{0.9998343548986617,0.01820062538423249,0.0},
{0.004500228684931084,0.3856195957576503,-0.9226468854927597},
{-0.010900177347328174,0.7049114690029018,-0.7092115389656093},
{-0.7224837659721659,0.44848992254465936,0.5261881766845034},
{-0.015599895793044155,0.70099531736692,0.7129952372077232},
{-0.6946258231949748,-0.008000297416584794,0.7193267414686804},
{0.003999922842232553,0.39029247133084133,0.9206822402108779},
{-0.5858273910000142,0.476122261616775,-0.6558306640795654},
{-0.7223923137866717,0.4483952291001434,-0.5263943991933886},
{-0.9998586367037815,0.016799305027126243,0.0006999710427969268},
{-0.9998517633152401,0.01719917024604673,0.0007999614067928714},
{-0.999887476487785,0.014999812128529626,0.0001999974950470617},
{0.999887476487785,0.014999812128529626,-0.0001999974950470617},
{0.9998991750835209,0.014199988285014498,0.0},
{0.9998586367037815,0.016799305027126243,-0.0006999710427969268},
{0.9998517633152401,0.01719917024604673,-0.0007999614067928714},
{0.026500354312105744,-0.22100295482925922,0.9749130346744109},
{-0.5932254083883736,-0.4357186622299635,0.6769289934897},
{-0.6137885560190586,-0.4713912109928058,-0.6332881924517266},
{-0.6540668363818205,-0.4373778233196886,-0.6171687072540278},
{0.01659952874606825,-0.23409335418401073,-0.9720724032562017},
{0.010399702780741728,-0.24299305535771537,-0.9699722785884112},
{0.043201249182180414,-0.12880372441353788,-0.9907286473330124},
{-0.9540160562253406,-0.29970504407833815,0.005500092567336869},
{-0.9879624136849433,-0.15469411477435296,-0.0},
{0.9637802330701276,-0.26669453015127936,-0.0012999733378202592},
{0.9633017628438391,-0.2684004911733483,-0.003300006039016577},
{0.9540160562253406,-0.29970504407833815,-0.005500092567336869},
{0.9879624136849433,-0.15469411477435296,-0.0},
{0.01030043422395726,-0.3308139457558312,0.9436397799734049},
{0.0,-0.23089494230168273,0.9729786871352849},
{-0.01030043422395726,-0.3308139457558312,-0.9436397799734049},
{0.0,-0.23089494230168273,-0.9729786871352849},
{0.007399671424885405,0.44928005016229894,0.893360331215219},
{-0.010699711700152305,0.9677739236829347,-0.25159322091199254},
{-0.03059931978468169,0.42669051477528364,-0.9038799069729995},
{0.6517928368360846,0.25429720528907074,0.7144921477744438},
{0.9966607024432388,-0.013099483497548338,-0.0805968221299539},
{-0.022300470433385743,0.9134192687827146,0.4064085732792809},
{0.09549513607911257,-0.2098893095602694,0.9730504389380569},
{0.4263135889622257,0.8510271269220128,0.3066097733422904},
{-0.14440598069753843,-0.10950453522424142,0.9834407300412695},
{-0.592601407430014,-0.7532017888563728,0.2855006780649156},
{-0.5317789313361025,0.6391746764009716,-0.5555779884361386},
{-0.5298157887457605,0.5060150794740559,0.680620282786645},
{0.6934683404256105,0.0658969915415252,0.7174672447806424},
{0.40977634839173654,0.6753610192869177,-0.6131646091601094},
{-0.5097797697912458,0.7786690991299393,0.3657854840910901},
{0.3109936433548941,-0.2577947307295553,0.9147813020612768},
{-0.7113763506863257,0.6001800473459834,0.3656878429097404},
{0.4466190978409442,0.8274353818934108,0.3404145564376565},
{-0.3255054132000327,0.006800113086820958,0.9455157240572377},
{0.41439868014230563,-0.8325973481816692,0.367498829518092},
{-0.9948623650685806,-0.0590977643738598,-0.08219689055044459},
{-0.28019193339035486,0.8476755957708916,0.450487030665078},
{0.9299729102836793,0.010099705799855013,0.36748929519274426},
{0.8203054550494141,0.5719038031729367,0.005000033250331672},
{0.9286506481726695,0.3707802954047872,-0.01139939419529281},
{0.6210265929280759,0.43941881631658064,0.6490277919650906},
{0.42970502972680963,0.9029105686300591,-0.0103001205636168},
{-0.03990033396719296,0.9991083625719922,0.013800115507450198},
{-0.2265055517191098,0.7387181062026773,-0.6348155595200481},
{-0.6325797546089255,0.4645851311908106,0.619680167453606},
{-0.7034927892358653,0.33649655092802944,-0.6259935835986521},
{-0.9301197047946713,-0.2059043621301181,0.3041064425632293},
{-0.6168986150641638,-0.5371987939900613,0.5751987086803486},
{0.9130190822982321,-0.40780852328720596,-0.009400196466159236},
{0.6919967580027832,0.41039807728951183,0.5938972175980534},
{0.5754127714281944,-0.8177181494557431,0.015400341814379898},
{0.3777084248803765,-0.9259206528904966,-0.002700060225515003},
{-0.38438961777663383,-0.6954812153060583,0.6070836028933256},
{-0.24519137677091574,-0.7326742323003669,-0.6348776717449202},
{-0.7074176149179199,-0.32620812268338345,-0.6270156128831436},
{-0.699679072911889,0.4181874921991597,0.579282673914331},
{-0.7453790998630557,0.6663813149298904,-0.018599478477935114},
{-0.08809644317790859,-0.1594935605774849,0.9832603016667141},
{-0.027800109393645692,-0.014800058238343752,0.9995039330557148},
{-0.7330242635046896,0.06360210526452696,0.6772224164329821},
{-0.03589989212098627,-0.45179864234711964,0.8913973213550741},
{-0.5017928921540236,0.8649877475353336,0.0002999957505902891},
{-0.7592671282412587,-0.2560889128705207,-0.5982740982836101},
{-0.985298438303213,-0.014799976542055773,-0.17019973023364138},
{-0.632411484696844,-0.018400334153102358,-0.7744140634870905},
{-0.5275968291525851,-0.8494948945510256,-9.999939900541796e-05},
{0.5043119271181161,0.8635204224994911,0.0014000331111746235},
{-0.9852816640788457,-0.014799724579688336,-0.1702968308054678},
{0.732114631457116,-0.0191003817249432,0.680913608194441},
{0.5269844410140653,-0.8498749078137648,-0.00019999409526150484},
{0.7536305000435177,0.2841114982250045,-0.592723988025203},
{0.9859753706428581,0.032999175690886735,-0.1635959134251233},
{0.6336330226454852,0.05550289260862441,-0.7716402150777404},
{0.7321610281056834,-0.019098983388170655,0.68086375858667},
{0.7535858289517287,0.28409465765019387,-0.5927888527104362},
{0.9859914958600221,0.032999715378682286,-0.16349858983074403},
{0.03580177133645639,0.467923151070613,0.8830436896673461},
{-0.04600013685061069,0.3842011430001006,0.9221027432597417},
{-0.04599836938670735,0.38428637728938336,0.9220673132931054},
{0.04939972929022523,0.40179779815409916,-0.9143949891291893},
{0.04939774430350839,0.4018816484935227,-0.914358246783969},
{-0.04939972929022523,-0.40179779815409916,-0.9143949891291893},
{-0.04939774430350839,-0.4018816484935227,-0.914358246783969},
{0.04600013685061069,-0.3842011430001006,0.9221027432597417},
{0.04599836938670735,-0.38428637728938336,0.9220673132931054},
{-0.9562101932549905,0.05100054366869327,0.28820307226112557},
{-0.9670188570515705,-0.04440086582532548,-0.25080489074305473},
{-0.979075459781147,-0.035399112732358906,-0.20039497716284532},
{-0.9398765268768582,0.05949851404316742,0.3362916012221379},
{0.9562101932549905,-0.05100054366869327,0.28820307226112557},
{0.9670188570515705,0.04440086582532548,-0.25080489074305473},
{0.979075459781147,0.035399112732358906,-0.20039497716284532},
{0.9398765268768582,-0.05949851404316742,0.3362916012221379},
{-0.9561826311002578,0.05099907361024173,0.28829476317319},
{-0.9669703338052313,-0.044398637870684876,-0.2509922996743672},
{-0.9790482193122308,-0.0355017485041718,-0.2005098753545478},
{-0.9398332471891894,0.059502104924193194,0.3364119007814889},
{0.9561826311002578,-0.05099907361024173,0.28829476317319},
{0.966994599350244,0.04439975202807739,-0.2508985987352391},
{0.9790523653659665,0.03549827287354898,-0.20049024538441046},
{0.9398449173035478,-0.05949651301155559,0.3363802853291983},
{0.39001629327098425,-0.44191846152935366,0.8078337479597463},
{-0.5095070057694943,-0.3548048786006214,0.7839107788473143},
{-0.17110834259061947,-0.9758475786085709,-0.13580662141324443},
{0.9305911035915744,0.3373967745022536,-0.14199864249946653},
{0.30319016921814207,0.45188534785513984,0.8389727967480909},
{-0.7103138334966124,0.6950135355204077,-0.11140216957837902},
{-0.42731493705469176,0.06680233511643671,0.901631517080529},
{0.6378316212864573,-0.4401218195800719,0.6320313337300738},
{-0.9860387274315447,-0.10240402199694745,0.13130515711132032},
{-0.08910008108111067,0.8359007606700383,0.5416004928566727},
{-0.060298514865868055,-0.3998901508268762,0.914577474234211},
{-0.21490828917257318,-0.9631371489162643,-0.16180624098707463},
{0.9063864541556632,0.422193690362446,-0.014699780313424811},
{0.46889514696034323,-0.4806950248322393,0.7409923307690645},
{0.3028142568308253,0.5694268092452838,0.7642359810770035},
{-0.12829926933774166,0.48169725674193425,0.8668950630466739},
{-0.7087255535605087,0.7046254057270134,-0.03480125478186214},
{-0.5967777943114029,-0.3576866907258526,0.7182732735487277},
{-0.40918736039765297,0.5116841943193525,0.7554766636862825},
{0.3917080633934783,-0.548511291221146,0.7387152066090438},
{-0.7461802973693685,0.49008705942204167,-0.450588102378233},
{-0.2190078515722208,-0.8577307501986018,0.46511667473168905},
{-0.8345547975635518,0.31008320479805584,0.4553753352629301},
{-0.3596950848002491,0.8831879313193772,-0.3009958869193077},
{-0.22990232892238804,0.7003070941467958,0.6758068459580245},
{-0.05419961599708098,-0.603795722122463,0.795294365359382},
{-0.5975070954388878,-0.5454064767403671,0.5878069802493359},
{0.6272884015446821,-0.778785600387372,-0.0014999722657692066},
{0.8460379541139514,0.16720750109675256,-0.5062227096601445},
{0.4561045382627337,0.4160041392617786,-0.7867078277818298},
{0.04300086067083957,-0.05390107884088961,-0.9976199675634783},
{-0.24700903452065942,0.8132297444218634,-0.5269192724248399},
{-0.6550251927533792,-0.12480480008491866,-0.745228662045524},
{-0.4206079790090434,0.8881168477364039,-0.1853035152410265},
{-0.6807805844145949,0.28259194059277987,-0.6757807270084947},
{-0.5231776660221461,-0.6816709000903994,-0.5114781654631646},
{-0.6809091140294873,-0.7319097966781932,0.025900346678460452},
{-0.9854592176141511,-0.12359488513151605,-0.11659517480853375},
{0.0071003071304275335,0.4752205561097414,-0.87983805821833},
{-0.2780837450897573,0.4376744164897043,-0.8550500195118714},
{-0.9679835444196161,0.15299739906632362,0.19899661708626407},
{-0.4573028032747761,0.8626052877866213,-0.21630132593119195},
{0.8094343166952999,0.4437188118578015,-0.3846163061539564},
{0.2855108710333758,0.9316354726959473,-0.22480855974887176},
{-0.9914678125199412,0.07179766912650709,-0.10879646797999959},
{-0.41740021704816926,-0.712200370344289,0.564400293488229},
{-0.2941923378603394,-0.9545751384142759,-0.04729876811962628},
{0.4819805283799723,-0.8703648379708047,0.10079592792676599},
{0.9696295838499117,-0.18910576970505188,-0.1551047323175756},
{0.7822278634527531,-0.4026143413782644,0.47541693465282386},
{0.25030015894065144,-0.8620005473705213,-0.44080027990826665},
{0.1656054766636714,-0.9269306541036052,-0.3367111352213657},
{0.4044034859730737,-0.6458055668679797,0.6476055823841803},
{-0.4635994042751483,-0.3279995785208124,0.8230989423185388},
{-0.06070041913784122,-0.10790074505721693,0.9923068519024687},
{0.3819927555760851,0.6611874606987106,0.6456877546478486},
{0.23939986952710668,-0.11319993830605043,0.9642994744569297},
{0.2787094400486044,-0.9209311924677422,0.2724092266567629},
{0.6752981530620771,-0.39429892159392416,0.6232982952814936},
{0.7202956890432015,0.6551960786632036,0.2277986366292396},
{0.7654371973244279,0.1362066191214882,0.628930563623377},
{0.7993108267384728,0.25290342560009976,-0.5451073835295152},
{0.16499982180028866,0.9853989357697239,-0.04199995464007348},
{0.10299592298708124,-0.975561383166956,0.1940923170076939},
{0.19140538239503047,-0.9814275981320947,0.012800359951182812},
{-0.8208065500624043,-0.07980063681162264,0.5656045135420271},
{-0.4026895503417512,-0.666882694618609,0.6269837299833076},
{-0.1344963276279105,0.4049889419279089,0.9043753063693847},
{-0.04559999817600011,-0.7385999704560019,0.6725999730960016},
{0.27910389213091386,0.6453089988967349,0.7111099164969288},
{0.43599951822079863,-0.5185994269479499,0.7354991872738472},
{0.07139645846651448,-0.9969505474946069,0.031498437558756386},
{0.637137764274466,-0.7397438459171598,0.2164128271684107},
{-0.20880257977180974,-0.9347115484325218,-0.2876035533638529},
{0.32258212783229745,-0.9280485828926078,-0.18618968444629197},
{0.8613102410396493,0.3563042364825578,0.362204306634809},
{0.9176021838957965,0.13520032177714875,0.37380088964717606},
{0.7626122743433341,0.1923030951432247,0.6176099405119895},
{-0.3609039952293409,0.9253102432410893,0.11640128856939673},
{-0.18049207205984832,0.9797569651204399,0.08659619634561144},
{-0.7033973517139562,0.6893974044236586,-0.1730993482821806},
{-0.9022232551041043,-0.1955050392073292,-0.384409908293081},
{-0.7479905267599675,-0.37779521525389803,-0.5456930888407944},
{-0.866486504577786,0.49829223915881216,-0.03009953120345223},
{-0.31311101230795774,0.9187323123836498,0.24060846234843383},
{0.24659643424134114,0.9593861273768965,-0.1369980190229673},
{0.06299934544020129,0.7592921109959497,-0.647693270501879},
{-0.219695743436206,0.91788221620434,-0.3304935967485939},
{0.4799192475473921,0.549722047044804,0.6837274214381163},
{0.6521389892949974,0.593135461663645,-0.4721282270298547},
{0.6304136769730845,-0.6781147118582623,-0.37780819663774007},
{0.03739812097861596,-0.19419024315634276,-0.9802507485384284},
{-0.08879598473635328,-0.7739650020938901,-0.6269716489830349},
{-0.12000585402834273,0.6490316605366203,-0.7512366462174255},
{0.9999050945294349,0.010600054007412752,-0.008800044836342662},
{0.9721084233559827,0.07990069234249873,-0.22050191065733382},
{0.9013174361544553,-0.43110833987150304,-0.04210081444813333},
{0.937108804178573,0.04280040211166676,-0.3464032544738637},
{0.8565710441052727,0.04809837406194679,-0.5137826318716894},
{0.8096828268093631,0.03719921101310153,-0.5856875776982141},
{0.6773140239320498,0.10670220929211532,-0.727915071637589},
{0.5672882317276979,0.09359805832841975,-0.8181830269691565},
{0.5145156337950529,0.016300495298074563,-0.8573260502478113},
{0.29050643043100716,0.056201244028305,-0.955221144054038},
{0.34850738494973144,0.07960168677761442,-0.9339197899700264},
{0.13290420449101464,0.0314009933861389,-0.9906313391181274},
{-0.034898942752543724,0.07369776735995624,-0.9966698063455682},
{-0.09660368356868305,0.11430435850828646,-0.9887377012873388},
{-0.3148872079670092,0.06699727829085303,-0.9467615385937259},
{-0.2525928416203012,0.00039998866448187056,-0.9675725793816449},
{-0.4302159268884256,0.10640393914674216,-0.8964331865708616},
{-0.5794769981170805,0.07349708259120866,-0.8116677814868581},
{-0.6347132085193053,0.007000145674547246,-0.772716080388951},
{-0.8271413663741244,-0.008600430118265591,-0.5619281027271436},
{-0.7035944205183678,0.13989889060619623,-0.696694475234717},
{-0.9094867124961951,0.0263996143044525,-0.4148939384438387},
{-0.8367987071469962,-0.509399212978824,-0.2006996899192186},
{-0.9651855754093625,0.0797988074157347,-0.24909627728395378},
{-0.9999223435144015,-0.010100225692064662,0.007300163123967527},
{-0.9878364024421574,0.14850547252749582,-0.04610169887890611},
{-0.9490776684651885,0.04909884471777552,0.31119267772243875},
{-0.9734523263396977,0.035698251720931905,0.22608892756590204},
{-0.8571005742575771,0.0940000629800633,0.506500339355341},
{-0.7679471478562606,0.024198334606929044,0.6400559496650943},
{-0.7013206015952622,0.09400276137167353,0.7066207572896226},
{-0.5616628023043643,0.0058996092818154695,0.8273452067413762},
{-0.48928650811055574,-0.3304908868394414,0.8070777451380126},
{-0.41368410863019456,0.07329718434274417,0.9074651403961845},
{-0.22778928390520206,0.06769681527823608,0.9713543037116475},
{-0.15909916791352768,-0.06069968254149045,0.9853948463984299},
{-0.04309834290057259,-0.5914772581366284,0.8051690418455},
{0.013600083980777871,0.04900030257780263,0.9987061670296222},
{0.2322995423703523,0.0598998819973487,0.9707980875296514},
{0.2916975118308361,0.03439970657175441,0.9558918462773267},
{0.5632154492116608,0.02530069400755507,0.8259226553691594},
{0.46100568654021545,0.08080099668644122,0.8837109006411895},
{0.6737383401711522,0.10590602675393353,0.7313416181789574},
{0.797719707908829,-0.37110916836525815,0.47531174272165777},
{0.8489844127892705,0.005399900858730343,0.528390298843169},
{0.9679843720184695,-0.002699956409555649,0.2509959477031362},
{0.9942655691794986,0.018099373229557403,0.1053963501875884},
{0.9590132104979625,-0.2812038736100387,-0.034900480757433676},
{0.9649866060788607,-0.11239843992048078,0.23699671050848703},
{0.919200395256255,0.06670002868101849,0.3881001668831076},
{0.7325809348292533,-0.3926897803814466,0.5559855306648442},
{0.39318342963352976,-0.7017704245086754,0.5940749632382504},
{0.6774013819002286,-0.4320008812826967,0.5954012146197167},
{0.5968833054074183,0.13329627175541778,0.7911778710644152},
{0.40161425755921953,0.11120394781022212,0.9090322712184525},
{0.29419074490474567,-0.47878493766278796,0.8271739775159945},
{0.16069729227343763,-0.7338876340975473,0.6599888792810754},
{0.1351938001544841,0.10579514834574275,0.9851548218357822},
{0.003899833812123069,-0.39688308718760157,0.9178608861917347},
{-0.10620274856269966,-0.037800978301977844,0.9936257153662748},
{-0.43738706884246165,-0.2648921685788022,0.8593745929657328},
{-0.07709847732010924,-0.992980388830979,0.08969822847748118},
{-0.7146231255785216,-0.47161526171680773,0.5166167179874954},
{-0.2868972085037418,-0.9451908033382251,0.1558984831151389},
{-0.6876789092112768,-0.6841790165513387,0.24289255059970793},
{-0.9757711712666111,9.99970456309296e-05,0.21879353584047398},
{-0.9770382322540567,-0.20570804951346924,0.055502171842477126},
{-0.9276416114363444,-0.2633834218522509,-0.2647833337375703},
{-0.23980949184753472,-0.9648381890512989,-0.10760425906086211},
{-0.14080503175771641,-0.9833351401091089,-0.11500410974529394},
{-0.3841010332331691,0.8305022340540145,0.4034010851503786},
{-0.5464809882571221,-0.20429289277388848,0.8121717450364768},
{-0.7930107691593683,-0.2560034765508175,0.5528075071769215},
{-0.8614762838843526,0.21849398494339065,0.4583873807691088},
{-0.9264769588045483,-0.17819556833132272,-0.3314917559025448},
{-0.8964186232903503,-0.12570261149888112,-0.4250088296501549},
{-0.6703046586335664,0.6065042152189437,-0.42760297185098156},
{-0.7304862012459865,0.33129374192032207,-0.5971887192116401},
{-0.6521908237396645,-0.24929649242302723,-0.7158899274995796},
{-0.5392004502325639,0.2595002166827714,-0.8012006690028379},
{0.050100139779584975,0.08040022431693876,-0.9955027774566236},
{0.1754996674284453,-0.3126994074351843,-0.9334982310225283},
{-0.14039334481123011,0.009199563905009379,-0.990053067646716},
{-0.22188896129875627,0.1344933091243025,-0.9657519550353258},
{-0.38281677348440335,0.08570375519230243,-0.9198403036858783},
{-0.020999986875012307,-0.8756994526880132,-0.4823996985002827},
{0.19270090087881742,-0.7694035969702238,-0.6090028470949652},
{0.3274173519423615,-0.34651836422733123,-0.8790465863082948},
{0.4204919413491653,-0.36919292448540264,-0.8287841165046093},
{0.5481922595799417,-0.38399457803483694,-0.7429895090621975},
{0.31800664481826596,-0.8555178762327879,-0.4086085379646021},
{0.7435016728806461,0.006600014850050119,-0.6687015045800779},
{0.7578781923687675,-0.31829084131281,-0.5694836133447857},
{0.8778988719006744,-0.07459990413918477,-0.4729993921961715},
{0.9544358254210734,0.10690401271742743,-0.2786104578398062},
{0.935304498825459,-0.31550151756594924,-0.16020077056755966},
{-0.27329740505345845,-0.8690917480130287,-0.4122960852672555},
{-0.12219437552233908,-0.8950588013915362,-0.42888025909600025},
{0.39218441294025536,-0.9151636275444205,-0.09309629996108561},
{0.4657992058130312,-0.8638985270542672,-0.1915996733228355},
{0.16920122332926701,-0.9807070905378971,-0.09790070782467637},
{-0.2807051944976867,-0.8771162311860385,-0.38970721159867655},
{0.720436091150002,0.6542327746117869,0.23011152772572938},
{0.5062928436012332,0.38969449170728926,-0.7692891261750516},
{-0.5167907133543208,0.480891358459932,-0.708287272192077},
{-0.007900256051448009,0.5454176772733853,0.8381271641415918},
{-0.10630181405593543,0.9923169340329702,0.06330108024215157},
{-0.1193965417292525,0.9908712998284448,-0.0625981868697756},
{-0.6650812915264004,0.7359792971935508,0.12649644170514154},
{0.11310063675837743,0.9912055805031273,-0.06870038678426639},
{0.10560471218738905,0.9926442927765377,-0.059202641680809014},
{0.12489860988620789,0.9911889681281767,0.044099509175194306},
{-0.7905223128071729,0.35631005699329,-0.4981140594677455},
{0.05890278469497124,0.9918468906701609,0.11300534245384974},
{-0.006299727164724616,0.9912570695859542,0.1317942921128102},
{-0.009399609078387475,0.991058782722322,0.13309446471631628},
{-0.07430335152825773,0.9873445351796616,0.14010631963807413},
{-0.13569841301633961,0.9840884911523936,0.11469865860703134},
{0.5240802661291114,0.851467938578398,-0.018499303421844228},
{-0.10669884018991066,0.9886892530062293,-0.10539885432068026},
{-0.004400094295031125,0.9887211885221074,-0.1497032081741271},
{-0.038198647791801835,0.8165710938949052,0.5759796106826663},
{-0.03349990452540815,0.9971971579921495,-0.06689980933581509},
{-0.12199853602635148,0.9911881058140949,-0.05159938081114538},
{0.823782169427912,0.5648877731364743,0.047798965402590675},
{0.5775879805191868,0.8134830715934184,-0.06809858288323514},
{-0.0394999050028427,0.9969976022236499,0.06659983982757782},
{0.24700884307487594,0.9274332027029958,-0.28081005317985896},
{0.36180988297193195,0.8398229400769166,-0.40471105483344627},
{0.3211055439350745,0.9015155648005906,-0.29010500870621336},
{0.14779949969954026,0.6787977022736666,-0.7192975651818628},
{0.5550066573447825,0.8149097749013752,0.16700200320104266},
{0.4369115979723043,0.24910661262279926,-0.864322943757067},
{-0.10020703027082162,0.7811548038377123,-0.6162432340606815},
{-0.28339450078306794,0.5805887337849304,-0.7632851885946216},
{-0.699316874719783,0.7135172173781855,0.043001037627557075},
{-0.20910983884938225,0.977846008737092,-0.009500447006547733},
{-0.8206870578671454,0.5680910412749182,-0.061199034898829406},
{-0.690077814354897,0.6272798332775349,0.36098839440967656},
{-0.4048289382067915,0.6038431642521263,0.6866490834307881},
{-0.43899288617791876,0.7553877590405462,0.48649211645912865},
{0.017599260494610698,0.9997579910518053,0.013199445370958022},
{0.0860998940971954,0.9681988091161974,0.2348997110735331},
{0.7112970872443916,0.7022971240991652,-0.02889988165522693},
{0.49222737598679445,0.7827435334922064,-0.3808211799589015},
{0.6365961104096481,0.6544960010416504,-0.4078975077538414},
{0.49799077480634424,0.686687279235977,-0.5295901894326102},
{0.5963244557674069,0.5445223313187204,-0.589824189186008},
{0.741115048493841,0.4697095375489909,-0.4797097406051755},
{0.7657982042053166,0.5823986342768039,-0.27269936052074933},
{-0.19970949241776725,0.9798465732144636,-0.004100194886894571},
{0.8138789777775026,0.5688853058823212,-0.11819694701228753},
{0.8337097294493143,0.5476063906038677,0.07110082975152482},
{0.7466967369423895,0.6520971503416796,0.13119942665975826},
{-0.28251007872684103,0.9592342212912778,0.007600271144509707},
{0.6419049234296442,0.7292055930283479,0.23710181857792278},
{0.6881072010795392,0.6439067385192782,0.3345035005974507},
{-0.08480116814413684,0.7490103176881897,0.657109051739532},
{0.5414912360352666,0.6275898425405971,0.5593909463307999},
{-0.13630063448093027,0.9718045237605872,-0.19240089562825372},
{0.27009006356933857,0.6825748885317678,0.6790750172896625},
{0.14499625479510733,0.7214813643770341,0.6770825111846013},
{0.004199940844249811,0.6977901716946471,0.7162899111276523},
{-0.08819963441327304,0.7210970110590837,0.6871971515737102},
{-0.2027938189385967,0.7255778847231052,0.657579957268349},
{-0.274103167280397,0.6848079130011523,0.6752078020712297},
{-0.4047073374105415,0.7222130938420881,0.5609101693935574},
{-0.49749414701579037,0.6651921740601081,0.5567934493636021},
{0.21449556213272872,0.9727798733926271,-0.08769818554331146},
{-0.5763023657260671,0.5599022984036525,0.5953024437215473},
{-0.688483235637316,0.5538865130276096,0.4681885997463926},
{-0.6723173829906588,0.6784175407122756,0.29620765854801895},
{-0.08049935077535399,0.798793557755935,0.5961951917051682},
{-0.6798057477818963,0.7217061020508894,0.13040110254598303},
{-0.7532907684781981,0.6450920944448236,0.12809843016335745},
{-0.697469472429273,0.715168697751134,-0.04549800859574469},
{-0.7561148729258271,0.651212809481945,-0.06490127662066682},
{-0.6634867469845922,0.7086858441416435,-0.2398952081410756},
{-0.7150981622000846,0.6326983739672684,-0.29719923619894445},
{-0.6129797229661409,0.6595781815146272,-0.4349856109139825},
{-0.55491224704844,0.7331161800526426,-0.39320867821129324},
{-0.4487094342150326,0.719915136374865,-0.529511133088611},
{-0.4926818228394633,0.6408763553030485,-0.5886782811154699},
{0.10770435295938906,0.9612388492531547,0.2538102579488667},
{-0.32360449004344927,0.652509053625929,-0.6852095073478722},
{0.02180057859503397,0.9692257235920607,0.24520650786707934},
{-0.23440101144254655,0.522002252444579,-0.8201035387544047},
{-0.09040149254096287,0.5191085705532503,-0.8499140321965083},
{0.024899324490489733,0.6782815984698468,-0.7343800765387816},
{-0.31088818181039846,0.8350682554836402,-0.4538827459753614},
{0.18160987621361008,0.7792423763526705,-0.5998326197848199},
{0.23791201367045306,0.6558331171293953,-0.7164361773581865},
{0.30669459915566283,0.7751863490885877,-0.5522902742539049},
{0.4028219926670508,0.6236340482303201,-0.6699365761858426},
{0.4198192281609847,0.7820358180607195,-0.4606210969293701},
{0.4402279509599378,0.47533017967119134,-0.7617483649390837},
{0.6008176582904695,0.4207123649181101,-0.6797199772637019},
{0.7114900925694411,0.3413952461042968,-0.6141914474436412},
{0.8393036719615973,0.3360014700096469,-0.42740186988727114},
{0.8452620232304252,0.43208058705532554,-0.31438587495994996},
{0.8859891865679667,0.4359946787174192,-0.15789807286578098},
{0.9077138835900251,0.41940641487017355,0.012400189662351341},
{0.8460987223918938,0.46299930087158353,0.2640996012099033},
{0.758500007585,0.47580000475800005,0.44530000445300005},
{0.64199325589627,0.48649488939803015,0.5925937748350928},
{0.43811860729238594,0.4892207776476495,0.7541320286674007},
{0.3424087914585825,0.5808149126143245,0.7385189617177663},
{-0.4214048777896908,0.2817032607341146,0.8620099778232403},
{-0.16160896550604906,-0.0005000277398083201,0.9868547472857006},
{0.11360294178626683,-0.00100002589600587,0.9935257276818318},
{0.31301613796299976,0.12300634175542802,0.9417485530982648},
{-0.4062003310534047,0.5592004557485571,0.72270058900122},
{-0.5584174982864675,0.43861374417701404,0.704122064010569},
{-0.6973790928881881,0.4077877747057687,0.5893823305825897},
{-0.8156794696061218,0.4223893685933871,0.39529005067463524},
{-0.7662727633186832,0.5557802451422734,0.3223885409029668},
{-0.8446229487172793,0.5119139088898594,0.15670425771252386},
{-0.874378376890106,0.48308805338015803,-0.045698869880921596},
{-0.8035371684713614,0.5630260433719682,-0.19320893708608217},
{-0.8493810717537217,0.4513899408872498,-0.27349390525623135},
{-0.7592606599280823,0.47647531207129096,-0.44327703219559983},
{-0.6598239091525302,0.4755172306790361,-0.5818210826689026},
{-0.5341095446228443,0.47930856532059407,-0.6964124450015893},
{-0.3982014315367196,0.47140169469213866,-0.786902828920755},
{-0.2680895621360934,0.3000883162888535,-0.9154643570891217},
{-0.08470173089755652,0.30980633095706034,-0.9470193525382057},
{0.08390136508631503,0.416806781501503,-0.9051147263363972},
{0.08720040112276775,0.5530025438175524,-0.8286038115862999},
{0.27470850098609656,0.4821149192770191,-0.831925744340494},
{0.2821988980154549,0.2815989003584412,-0.9170964187454773},
{0.46221937433112115,0.338214176544321,-0.819734359885807},
{0.5525963528761064,0.3279978352214313,-0.766194943130063},
{0.25850645886456314,0.4233105765468842,0.8683216952885885},
{0.36811612752082773,0.30411332349655995,0.8786384939956514},
{0.5213213381190627,0.32211318436245945,0.7902323448718269},
{0.5639031945206454,0.4089023164381839,0.7175040646720395},
{0.618015855400158,0.3087079200032828,0.7230185492788256},
{0.6884979310668258,0.3175990456163019,0.6519980407488314},
{0.7861003694672606,0.325900153173108,0.5252002468441741},
{0.8463277684696328,0.3237106211197212,0.4230138793130741},
{0.8780366587957731,0.3215134234656504,0.35451480130193797},
{0.9178004175992849,0.31690014418959844,0.23920010883607426},
{0.9456903681926497,0.31019684066126674,0.0971990100331242},
{0.9447865416115714,0.32119542460376455,-0.0648990755192538},
{0.9042563752034921,0.3929810410869981,-0.16699194366801193},
{0.9231234568650621,0.3471088201471813,-0.16540420297419703},
{0.8756643524298041,0.3797845392861021,-0.2982878569485104},
{0.8904515541851374,0.3358194428294802,-0.30711778109866994},
{0.04950107666012617,0.3375073408644966,-0.9400204456670422},
{-0.9220154853801166,0.3255054669102255,-0.20960352032068594},
{-0.8509874182440312,0.3210952526417843,-0.41559385549026956},
{-0.8182091271737206,0.041700465171283486,-0.5734063963840277},
{-0.5908902297108268,0.224496287984567,-0.7748871873462849},
{-0.39769485982715486,0.3369956443594448,-0.8533889700188433},
{-0.9049705663109883,-0.4217862816242816,0.055898181941198055},
{-0.881403631390442,-0.4208017337067143,0.21460088415746412},
{-0.7713949512365662,-0.4451970861946063,0.4546970240177167},
{-0.8657373400567323,-0.12350532689962625,0.4850209194033905},
{-0.5292913038153169,0.36189405412953557,0.767387391928725},
{-0.4179758918458174,0.41997577649579737,0.805553537011939},
{-0.27710347628491516,0.36670460033806707,0.8881111414241543},
{0.4407847447039742,0.3936863747503508,0.8066720815623774},
{0.39769806918056116,0.6640967758179801,0.6330969263218841},
{-0.9720599373752545,-0.1050956685712779,0.20989134950629149},
{0.9625253869418753,0.22840602428833695,-0.14620385617756068},
{0.9833031318254623,0.1765005621551857,-0.044300141096174084},
{0.9855509247319554,0.106005477444533,-0.13210682613606423},
{0.9904413765527763,0.12270512611371734,-0.06300263198992821},
{0.9451919375471589,0.21109819934003943,-0.24909787520418672},
{0.9249708823749271,0.2835910726935452,-0.2529920359360611},
{0.9176636153589622,0.3324868171590443,-0.21759137267310688},
{0.9334089561019009,0.24180232010439212,-0.2651025436711098},
{0.9552467843569239,0.11740575008741924,-0.2715132976893895},
{0.9641970784872783,0.133899594284844,-0.22889930643615225},
{0.02010015165621637,-0.5259039679604075,-0.8503064155861084},
{0.8925020616821436,0.1652003816133223,-0.41970096951035935},
{0.8062888813529887,0.2357967483852595,-0.5424925190797425},
{0.650899811239082,0.22709993414102864,-0.7243997899240914},
{0.7215229411866283,0.13540430524832914,-0.6790215898346786},
{0.7324378936546677,-0.48812525381327593,-0.47462455533657194},
{0.5747029568543196,0.17190088443232562,-0.8001041165462696},
{0.5851856953105151,0.1666959251679133,-0.7935806011593041},
{0.7338052687407445,0.04880035038777369,-0.6776048652203985},
{0.8995054959953708,0.08170049919157509,-0.4292026224360347},
{0.2455101876566096,0.2270094199513254,-0.9424391073221544},
{0.43710074525740594,0.3017005143998156,-0.8473014446501947},
{0.33050127243234834,0.3043011715617658,-0.8934034396098638},
{0.6378146412031352,-0.20130462100061322,-0.7434170653346044},
{0.7378927908226502,0.1791982492416573,-0.6506936427541652},
{0.10529941716933895,0.20869884485509058,-0.9722946183641811},
{0.10049963669447003,0.0356998709451998,-0.9942964056249904},
{0.4859048372067318,0.5052050293411008,-0.7132071000120211},
{0.2806077336557108,0.019400534686104025,-0.9596264476693517},
{0.45931312276337866,0.05410154570324143,-0.8866253312475758},
{0.050301121476005094,0.5314118479592268,-0.8456188532825032},
{0.4278939218100108,0.1445979460007655,-0.8921873265690385},
{0.4256881255953525,0.1982944686529443,-0.88287537253497},
{0.39417908147120473,0.2634860171680935,-0.8804532755844642},
{-0.2516085623850694,0.5097173459764305,-0.8227279979101614},
{-0.5966180479689307,0.3765113896418076,-0.7087214391478062},
{-0.4114026700119926,0.11550074960229739,-0.9041058676661219},
{-0.5485848784662347,0.09589735662579642,-0.8305771054576278},
{-0.40602224656835095,-0.059103238355146644,-0.9119499671075842},
{-0.5605030211194257,0.1969010612995806,-0.8044043357510546},
{-0.6760652308592423,0.10189475968726044,-0.7297624692812824},
{-0.7293522253471667,0.12209200262529346,-0.6731559063664828},
{-0.8041005709116079,0.12640008974409558,-0.5809004124394391},
{-0.845320418961333,0.12340298083500353,-0.5198125562239453},
{-0.914378155766785,0.11189732680479357,-0.3890907047340945},
{-0.9202979477378649,0.1608996411942002,-0.35659920478465995},
{-0.9816122653218833,-0.03630045357700118,-0.18740234160688765},
{-0.9220273569575274,0.2229066137373458,-0.3165093909729473},
{-0.9647927061947117,0.16819872842241967,-0.20219847138533448},
{-0.9501932108937622,0.006299954986982426,-0.3115977736418609},
{-0.7825843562950748,0.5448891077756023,-0.30109398119147335},
{-0.6650107067585689,0.36740591528285443,-0.6502104684728143},
{-0.21980453901059632,0.24790511929357067,0.9435194838785151},
{-0.14040216150791474,0.24690380111327742,0.9588147610668708},
{-0.16480643004830497,0.1407054897317749,0.9762380886720589},
{-0.23290777575589258,0.10390346887521357,0.9669322815730894},
{-0.24290969350473282,0.1297051759883238,0.9613383629728269},
{-0.17780096901792175,0.13250072213090344,0.9751053143384447},
{-0.29559708838301907,-0.006499935975945954,0.9552905904340262},
{0.8128374360901985,0.2282105104770956,0.5359246825796474},
{0.861710659426786,0.1494018481122918,0.4849059983242991},
{0.8457354412862662,0.12430520911893447,0.5189217458714007},
{0.9006394578789934,0.04790209863691293,0.43191892278251975},
{0.9171255606455677,0.19290537634775926,0.34880972146240763},
{0.9234173373232639,-0.0400007510211507,0.3817071666193305},
{0.9812283677221723,0.18350530521506178,0.059301714437346935},
{0.9551956443177929,0.13919936525234167,0.26119880893614683},
{0.4794951643156517,0.18139817060867408,-0.8585913411499866},
{0.5009028025590205,0.12240068483374747,-0.8568047938362323},
{0.10530270684086947,0.2929075292848117,-0.9503244284034023},
{0.07679976499307867,0.13979957221396355,-0.9871969791818654},
{-0.10310307200179611,0.11980356960053516,-0.9874294208979},
{0.1326047274428015,0.19630699846924538,-0.9715346358271619},
{0.19040815630806693,0.07360315285858049,-0.9789419338758756},
{0.3732925379567486,0.17899642189728904,-0.9102818036486157},
{-0.5955867721646837,-0.44089020793722133,-0.6714850864818419},
{-0.8945536946264654,-0.20938916125059454,-0.39487955958863313},
{-0.7382155986604013,0.6465136609779862,-0.19250406765392478},
{-0.24370046546833357,0.7315013971690029,-0.6368012162914847},
{-0.6401646606853333,-0.4605745746823876,-0.6148660572561878},
{-0.40259485285770913,-0.21409726278399285,-0.8899886215682095},
{-0.6623004834795293,0.051000037230040755,0.7475005456755975},
{-0.9085075815274019,0.3355027997825464,0.24910207876552098},
{-0.2894989216185254,0.11539957013740186,-0.9501964605247768},
{-0.13680244536556657,0.13010232559985532,0.9820175537206606},
{-0.3167801195035304,0.2317854536013837,0.9197422787858184},
{-0.23049363731096187,0.11399685316030218,0.9663733236325968},
{0.5462071635539253,0.18830246960308336,0.8162107046735881},
{0.3624988363806028,0.12839958783798455,0.9230970368632676},
{0.5155812306069433,-0.011099595926565306,0.856768809899203},
{0.6479907661973722,0.15509778987224138,0.7456893740021303},
{0.649197234425672,0.1911991854932047,0.7361968638080402},
{0.7311216927024384,0.14970444179668313,0.6656197492309438},
{0.7321672948173944,0.024898887791522974,0.6806695951682605},
{-0.6947003994528445,0.15500008912507687,-0.7024004038803483},
{0.04069989153493359,0.22719939451442045,0.9729974069653656},
{0.5380021412527833,0.03980015840494568,0.8420033511800066},
{0.10389578866955768,0.12689485642124032,0.9864600146536925},
{0.1404967440256854,0.1772958912153311,0.974077426017225},
{0.21190827941821846,0.24670963913390512,0.9456369467572788},
{0.21219240576969378,0.12449554438419828,0.9692653106152884},
{0.20169136981092473,0.07899661980695614,0.9762582268041934},
{0.12510349168718016,0.10160283577472025,0.9869275455321991},
{0.05110137004609665,0.18910506997488993,0.980626290943295},
{0.3975894302254943,0.4574878378474941,0.7953788551342006},
{0.9923846677753233,0.08669866051604246,0.08749864815632889},
{0.9515175223565128,0.10960201833975176,0.2874052926171958},
{-0.6021785357286341,0.1366951275890141,0.7865719631420518},
{-0.8136043080462166,0.3454018289075261,0.4677024764911695},
{-0.4770697046503288,-0.03559773943733327,0.8781442352209572},
{-0.47019152722501845,0.7247869394570254,-0.5035909253732864},
{0.25240738428604254,0.8647252979086409,-0.43421270307844556},
{0.7111231616585689,0.6394208262754731,-0.29230952067613514},
{0.11090499693720804,0.06280282964523592,0.991844688569188},
{-0.10879857039617742,0.6977908310887188,0.7079906970633604},
{0.12960482527746928,0.1527056853384997,-0.9797364762680298},
{0.6043707461420325,0.638369100491518,0.4766769270117585},
{-0.6675843253040606,0.6981836068413648,0.25859392828584493},
{0.9030223907177702,0.1746043293680207,-0.3925097323994738},
{-0.11190254860956719,0.6378145263912597,0.7620173551428973},
{-0.5574907540925145,0.6973884339087347,-0.45039253030182697},
{-0.7139254626056938,0.6389227875875862,0.28651021856917114},
{-0.10480038461811733,0.06890025286439203,-0.9921036410270438},
{0.10799959338229638,0.6971973750568244,-0.708697331759569},
{-0.11369956453150175,0.1668993607766723,0.9793962489195499},
{0.923636978546669,0.06840273855845838,0.377115098105185},
{0.5354899837535299,0.8153847483709212,-0.2199958850154558},
{0.026698420835110027,0.7620549257841704,-0.6469617333451755},
{0.26500052337655056,0.8481016750024623,0.4588009061326845},
{-0.3533943086304889,0.6851889651205744,0.6368897429732834},
{0.8618666851871638,0.500280662024757,0.08309678795574116},
{-0.6886196948049113,0.7128203869546046,0.1330038039631908},
{-0.7121924009476226,0.6904926324829169,-0.12649865026660245},
{-0.9295920008952483,0.10129912832475113,-0.3543969504273623},
{-0.25419153047930426,0.10379654155685203,-0.9615679610892958},
{-0.316097969077073,0.6049961129124617,0.7307953046552513},
{0.43100536820529173,0.024700307644247577,0.9020112346198913},
{0.8930970795773248,0.01219996010619568,0.4496985294882129},
{0.9987522261193914,-0.0037001934881763774,0.049802604246265834},
{0.9514782018840895,0.014099676980100537,-0.30739295770800745},
{0.34740634890904,0.7710140904112546,-0.5337097536348723},
{0.07310198620794826,0.7517204245214052,-0.655417807943766},
{0.21880045510541993,0.7052014668205765,-0.6744014027563766},
{0.15249675642848576,0.6974851646483201,0.7001851072211523},
{0.42930265739167384,0.6913042791867322,0.5812035976614043},
{0.6651081609272022,0.04790058774381745,0.7452091437722914},
{0.9896465342740881,0.08340392174460282,-0.1168054923233766},
{0.9285012116948719,0.09750012723774906,-0.3583004675824153},
{-0.579892986236747,0.6052926790293205,0.5452934047161547},
{-0.05169794918303306,0.014299432752753824,-0.9985603878951027},
{-0.427587478284045,0.0008999736446577187,-0.9039735275228642},
{-0.7262821227855687,0.012499692323860126,-0.6872830827351252},
{0.9433943160663685,0.07449955114155654,0.32319805273759833},
{0.6663916401693109,0.6977912462637231,0.26269670449051313},
{0.7359280062731782,0.6768257570942886,-0.01780067741766894},
{0.991163976799883,0.062497728561332413,0.11699574786681428},
{0.9727508870475382,0.07169638014114771,-0.22048886779809024},
{0.3200936414029697,0.6033880138161571,-0.7303854910363294},
{0.15399221281069228,0.09749506979897726,-0.9832502782906085},
{0.21079481240349932,0.07969803865540273,0.974276023362094},
{-0.8822249276174997,0.01040029386445477,-0.4707133001921981},
{-0.9920408233198367,-0.0017000699593182685,-0.1259051811048059},
{-0.9586988735294855,0.022899973092547425,0.2834996668880871},
{0.5152866980455827,0.6794824593867135,-0.5222865173475797},
{0.569394772979976,0.07099934822897487,-0.8189924816835271},
{0.25801024191983357,0.6990277484572234,-0.6669264741718488},
{0.3269045995800744,0.05400075979603553,-0.9435132753251764},
{-0.5992904743536146,0.07629878724041514,-0.7968873335764983},
{-0.7745071642244037,0.09750090188751372,-0.6250057813302161},
{0.7663852089082008,0.6019883817363477,0.2241956730652644},
{-0.8410210888682084,0.009800245744243095,0.5409135635776623},
{-0.6009114805235042,-0.0007000133738832633,0.7993152710641319},
{-0.2526918091277585,0.012299601314884964,0.9674686400122928},
{-0.2118917416802989,0.04029842939932065,-0.976461943137385},
{-0.1765086623751643,0.6804333930881687,-0.711234904709444},
{-0.3862899044452692,0.7016816617894006,-0.5986843535888758},
{-0.7985096380694976,0.5969072047134416,0.07800094147704548},
{0.7269109982466059,0.07780117714071527,-0.6823103234332909},
{0.04319820018448319,0.01469938756277553,0.9989583792661738},
{0.39440357725666864,0.007300066211900815,0.9189083345363915},
{0.37661713270305885,0.020500932608637033,0.9261421311638417},
{0.6522793556850837,0.027599126501469125,0.7574760262631471},
{0.7131064393802216,0.01870016886328726,0.7008063283097171},
{-0.6650059850807987,0.7404066636899599,0.09780088021188287},
{-0.6736920201652814,0.7075916186269158,0.21319747469086836},
{-0.49768248686142563,0.7396739713309153,0.45298405977140005},
{-0.18549660358828218,0.8305847921316829,0.5250903856830564},
{0.12799462881810011,0.8362649068795087,0.5331776256703983},
{-0.9756230932719299,0.1457034488414516,0.16410388438491563},
{-0.45600845219499286,0.5702105689508441,0.6833126653176286},
{-0.443992341198171,-0.48209168399017616,0.7552869714121138},
{-0.7869015698701978,-0.5346010665301916,0.30820061486083994},
{-0.8320647420035705,-0.4802796485810779,-0.2774882416848826},
{-0.2558998183111935,0.59499957755045,0.7618994590515762},
{-0.5568111753124338,0.8001160584904425,0.22310447775180317},
{-0.6913770604896932,0.593380311967868,-0.41218632388465654},
{0.9941452097813955,0.07600345633576709,0.07680349271824884},
{0.9824269876400308,0.030700843363750962,-0.18410505743539257},
{0.891253183699858,0.07309616035954182,-0.44757648942449957},
{0.6913075041836871,0.040800442891211396,-0.7214078309245073},
{0.36609699618646935,0.05759952739781654,-0.9287923792897917},
{-0.05949832544319526,0.08299766406361693,-0.9947720025359773},
{-0.4725849389579893,0.05329830141020066,-0.8796719653011917},
{-0.7942221432220338,0.12120337919731869,-0.5954166004462339},
{-0.9732147151177397,0.032400489899110936,-0.22760344139005093},
{-0.9898252953086366,0.08140208025674178,0.11670298238282267},
{-0.907780401232704,0.049698927011748606,0.4164910080562031},
{-0.6808028015092923,0.05080020904329032,0.7307030068490598},
{-0.30800768026726233,0.08780218937488843,0.9473236218090183},
{0.10829964586073705,0.06789977796808908,0.9917967568299079},
{0.4204081644058299,0.055801083667567336,0.9056175872643186},
{0.7083044162918035,0.04900030551785736,0.7042043907280644},
{0.9151866566758179,0.114598329168541,0.38639436641120634},
{-0.9586204380056098,0.2818060081681419,-0.04040086135554625},
{-0.9839656946340744,0.176193857108256,-0.02769903429000392},
{-0.9616755977913051,0.26809319722142966,0.05749854099303321},
{-0.9800409175624801,0.18910789541945408,0.06130255943528575},
{-0.9963109943524844,0.07100078349796887,0.04820053189580423},
{-0.9962696441264083,0.06649797383760529,-0.054998324226590845},
{-0.9413943281162596,0.24719851063346013,0.22949861727499635},
{-0.9626824552721275,0.1503972590349309,0.22499589948709742},
{-0.8853029480637257,0.14660048818043847,0.4413014695363404},
{-0.9534163702996183,0.04210072287561771,0.29870512881109296},
{-0.9040523983741625,0.24748696891671854,0.34848165118172286},
{-0.8287897064957676,0.25979677334411244,0.49559384476267176},
{-0.7321596993784911,0.1812900211654199,0.656563860436926},
{-0.8267762222577669,0.06979799263859716,0.5581839468605292},
{-0.7403251492724884,0.2666090568634951,0.6171209639552244},
{-0.6650035877040336,0.23500126783525996,0.7089038245464502},
{-0.7112141497462653,0.10810215071368288,0.6946138194794091},
{0.21859594180401026,0.8938834052086221,-0.3913927338613432},
{0.31939185401464376,0.8482783649362,-0.4223892271001425},
{0.7913057844664267,0.05650041301952877,-0.6088044503767984},
{0.03710008495929184,0.45950105225861454,-0.8874020321529804},
{0.5969798074995112,0.8018728771086399,-0.02479916118255926},
{0.9965160739339097,-0.07570122107054388,0.03500056456365965},
{0.04070063310327192,0.9486147558172909,0.3138048812728926},
{-0.6462950009275017,0.7302943511950402,-0.22129828826436038},
{-0.5372211669309739,-0.3594141611969322,-0.7630300639767927},
{0.48061565631001063,-0.57681879017814,-0.6605215168388722},
{0.09410319909263067,-0.87622978793797,-0.4726160668562938},
{-0.9606929581464251,0.0028999787432337177,-0.27759796521437247},
{-0.32331178654602166,-0.13760501648231546,-0.9362341310373818},
{-0.4120862509716007,0.6635778600940407,-0.6243791679365869},
{0.6083889213386128,0.34049379966436166,-0.7168869456075796},
{0.4325933597428916,-0.660489861558437,-0.6136905799218968},
{0.999178128230157,0.026699415556190143,-0.030499332376921325},
{0.39279625666951085,0.9088913383068188,0.14009866486608571},
{-0.5752053580628657,0.8148075899680509,-0.07230067348391027},
{-0.5682040967663067,-0.4985035942238716,-0.6547047204380515},
{0.7491380047349948,-0.6582333930270639,-0.0743037695258445},
{0.7227740637180768,0.4731830201319784,0.5036819256983887},
{0.17749194737301738,-0.3831826153991001,0.906458874893748},
{-0.43368835345564977,0.2660928541723505,0.8608768814617683},
{-0.6997700015030396,0.6992700229366613,0.1460937370957332},
{-0.8140431044455028,-0.3856730443245675,0.4342696477836652},
{0.20450462696952837,-0.4915111205649056,0.8465191527124977},
{0.11339857062002595,0.6853913606963473,0.7192909333949266},
{-0.7523127668559811,0.6074103078403869,0.255104329157199},
{-0.7856067248223468,-0.4956042423904724,0.3704031706647114},
{-0.614617919446666,0.42221230977934004,0.6663194268260878},
{-0.688916578976962,0.4471107598499052,0.5705137295781054},
{-0.627685732865436,0.21709506548524163,0.7475830076313525},
{-0.7021254630416341,-0.06450233921974849,0.7091257169104441},
{-0.1848981011062524,-0.04579952964124586,0.9816899180963115},
{-0.0252998263172885,0.24499831809231942,0.9691933465105143},
{0.010800220650761866,0.15330313201498091,0.9881201875016481},
{-0.15079672096095365,0.4146909826426226,0.8973804866734736},
{-0.6464768468463379,-0.19469302719409434,0.7376735806938027},
{-0.18479319234418876,-0.16419395120625432,0.9689643040125483},
{-0.18100506278241005,0.3315092724440273,0.9259258985095771},
{-0.6188093935978928,0.3852058474691472,0.684610392464637},
{-0.5787958645183219,0.5150963196499441,0.6321954829794111},
{-0.13749257903831422,0.4806740563179464,0.8660532560369739},
{-0.4956727709642201,0.3116828781713686,0.8106554678650257},
{0.46050240152628596,-0.6776035337116425,0.5734029903043917},
{0.7325128410626567,-0.07850137614118573,0.6762118540977043},
{0.7812789604408892,-0.05689846774489516,0.6215832609881694},
{0.02610111897895646,0.9984428041605412,-0.04930211362691775},
{-0.7628954760432407,-0.6442961793349848,-0.05359968215482724},
{0.8802944497609914,-0.0053999659533219965,0.474397008936288},
{0.623376467982492,0.7136730593505046,0.3194879395579182},
{0.8703334301490904,-0.015500595389303574,0.4922189064913045},
{0.3788811890159365,-0.8371584361154448,0.39448041453361554},
{-0.4861925005385184,0.8495868952232111,-0.20449684566048335},
{-0.939947510847684,-0.0011000556037157705,-0.34131725231653853},
{-0.7192021971660685,-0.6830020865745619,-0.12750038951428497},
{-0.21109293061612855,0.5650810757516544,-0.7975732897177836},
{0.07330055048920127,0.9947074702811528,0.07200054072609127},
{-0.6075105403993147,0.2752047748442657,-0.7451129278214476},
{-0.7125084610882134,0.3224038285681965,-0.623207400631824},
{-0.892213414529532,0.412206197566771,-0.18450277402006124},
{-0.9213407564098096,-0.07100314089340766,-0.382216907738879},
{-0.5410920974076256,-0.6219909158890097,-0.5659917337510924},
{-0.7786088567261181,0.19480221588780866,-0.5965067853032745},
{-0.5573044751729035,0.1513012149536341,-0.8164065557709643},
{0.9109695695697844,-0.1958934562883872,-0.3629878745925705},
{0.8622043110323329,0.4596022980172352,-0.21300106500798757},
{0.14319550229990802,0.9422704037514199,-0.3026904926409369},
{-0.8153911082084472,0.5712937700754058,-0.09359897930869591},
{-0.9225235200369688,0.18700476774733135,-0.33760860744117144},
{-0.9361072548593378,-0.21480166471935236,-0.27850215840009146},
{-0.6550701360332318,-0.6185717999544456,-0.4338802198516552},
{-0.40448733569977574,-0.8828723576992138,-0.2385925297848368},
{0.10549471115523103,-0.9650516183498906,-0.23988797351791397},
{0.40220903170521155,-0.9153205537538044,0.020400458097429925},
{0.33910081214741766,0.1788004282275384,-0.9236022120299467},
{0.3296870204775007,0.18809259494030292,-0.9251635770269446},
{0.3277034916993062,0.18640198612374329,-0.9262098688187287},
{0.3300007177523417,0.18030039215377938,-0.926602015361575},
{-0.6316634593257865,-0.49157156340756153,0.5994653219341602},
{-0.8813405293761364,0.4603211683556514,-0.10650489774033647},
{-0.9604938240445668,0.03939974666044345,0.27549822855208556},
{-0.2627135589966788,0.9630497042778898,-0.059303060709946905},
{-0.5333046664362471,0.8440073850969295,-0.05690049788153471},
{0.282509574411718,0.9046306584525313,-0.31911081484877596},
{0.8934770111322515,0.3588907658593901,-0.26999305316811184},
{0.7648964164686833,-0.2789986928941857,0.5805972799081155},
{0.5310046489660526,-0.8465074112048278,0.03820033444539211},
{0.2706057030752891,-0.7025148056555455,0.6582138720035302},
{-0.30219790728673807,-0.8973937855695523,0.3214977736356263},
{0.10019892938015933,0.11929872529993023,0.9877894455261615},
{0.09869569794828761,0.1174948785098662,0.9881569271782961},
{0.10270367993877948,0.11760421383447388,0.9877353911931109},
{0.10509916236301393,0.11919904998735738,0.9872921313130699},
{0.3114996480055966,-0.057599934912110316,0.9484989281968166},
{0.1330952399338641,0.6425770186438848,0.7545730131787668},
{-0.4400171390013527,0.8583334327383204,0.26391027950558404},
{-0.7588756063356952,0.45778528472852975,0.46318511115389904},
{-0.6654012376474531,0.739401375287837,0.10260019083653243},
{-0.09189875845615982,0.9945865632262956,-0.04849934477827803},
{0.5809081850539914,0.1355019092353518,0.8026113088730136},
{0.3800842743384672,-0.7504689499895281,-0.5406776299258332},
{-0.7683673566062671,-0.11289520374915091,0.6299732361555808},
{-0.904872008217382,0.10749667464180414,0.411887258464736},
{0.5166808159974465,0.48088214517741823,0.7083736985728489},
{0.006500029477700522,-0.2122009623335463,0.9772044316321462},
{-0.6727256380626091,-0.5515210188665511,0.49321879692653314},
{0.3819911799254821,0.3426920873310542,0.858280182539375},
{-0.27151066243307476,-0.8211322464964923,0.502019714701302},
{0.18999622101274571,-0.9422812582121594,0.27569451649059995},
{-0.2688032659795226,-0.9399114199931298,0.21050255762161274},
{0.09160324464438896,0.1192042222883315,0.9886350180725211},
{0.7017093959517181,-0.712309537888569,0.014800198175980375},
{0.4228113293813582,-0.9049242477700828,-0.0484012969301271},
{0.8322905577171837,-0.06259928981508554,0.5507937512803374},
{0.8695236252778527,-0.4105111537395727,-0.27460746118608204},
{0.20460303530854337,0.1839027282172098,0.9614142626863812},
{0.9681771900141019,0.0681983932647818,-0.24079432695248473},
{0.7824195255228922,0.5648140951116174,-0.26230654594153197},
{0.8429704080432293,0.1635942571244037,-0.512482009634822},
{0.3517058629856044,0.9304155101558326,-0.10310171871997671},
{0.504898884174699,0.7603983195215707,-0.40849909721799266},
{0.13049911913391876,-0.9864933411924204,-0.09899933175676595},
{0.5714770327995684,-0.7012718164520338,-0.4261828720545513},
{0.8452041499625645,-0.23150113667337163,-0.4817023651644195},
{0.759095544122234,0.3977976649345602,-0.5152969752156332},
{0.7754370435123741,0.624129815393439,0.0957045719166033},
{0.30880021461622376,0.8231005720550963,-0.4766003312373453},
{-0.3644952652372566,0.9257879740923242,-0.10029869712838639},
{-0.7860905276662121,0.5616932316373379,0.25799689115619223},
{-0.5169256944302284,0.37331855626001986,0.7703382906163763},
{-0.9705044546256701,-0.0576002643858203,0.2341010745263981},
{-0.8110782390627651,-0.42138869429299614,0.4056891155070445},
{-0.49649247819593256,-0.844187210660637,0.20209693825457797},
{0.04849885980520881,-0.9845768528702803,0.1680960481083629},
{0.6750179118379391,-0.7108188618287512,-0.19770524617831192},
{0.9223815802237625,0.021299574651741263,-0.38569229780171854},
{0.6668784901811932,0.6460791610527349,-0.3712880242979113},
{0.10939801499102679,0.96528248510821,-0.23719569612314037},
{-0.4970963388989459,0.8473937589679477,0.18659862570618246},
{-0.8757516029249595,0.09169493261956929,0.47397380656135046},
{-0.5381735305858312,-0.6991656123850114,0.47067685032841083},
{0.007400182305736681,0.033100815448632984,-0.9994246211288159},
{0.06329992309064017,0.6426992191209232,-0.7634990723491906},
{0.4940004717706758,0.8572008186271727,-0.14550013895269903},
{0.851946266198263,0.4577248574233419,-0.2543138108865105},
{0.6721064052045627,0.7373070265694449,0.06820064995529113},
{0.09380490143415324,0.9941519457962872,0.053502795594106596},
{-0.3994825230219184,0.14649359104558457,-0.9049604088481505},
{-0.5240963680247543,-0.7351949051169612,0.4298970208239685},
{0.8982056542223901,-0.11560072770887139,-0.42410266973470895},
{0.9800055958479286,0.10770061497226725,-0.1673009552911821},
{-0.07450320445173668,0.34581487381759124,-0.9353402298484473},
{0.7707480422227543,-0.546634072763666,-0.3273204025165531},
{-0.385421823201462,0.044802536791451734,-0.92165218542415},
{0.17090565194336618,-0.3024100008640956,-0.9377310112773228},
{0.40139921727228944,-0.8236983937896981,-0.40049921902728436},
{-0.1228018850234028,-0.9439144891986148,-0.30650470488333026},
{0.31678727015931785,-0.937762316778435,-0.14229428201916328},
{-0.17469595146823655,0.7748820423167516,0.6074859216768959},
{-0.6592717672910856,-0.7253689367404119,-0.19799152119465338},
{-0.3708095633019579,-0.9273239159921941,-0.050701307603584864},
{-0.07060006177508107,-0.031700027737536406,-0.997000872376145},
{-0.168497160004302,0.3814935699800665,-0.9088846808778046},
{-0.7004814024656436,0.05189862210987424,-0.7117811024625912},
{-0.9986208114745689,0.05060105453696494,0.014000291769120734},
{-0.8203862750524266,0.5652905427683286,0.08609855958314715},
{-0.9435456592792055,0.16290788330321418,0.28841395668905445},
{-0.903830161315733,-0.4269142463661058,0.028900964441275375},
{0.9428700879209336,-0.24479223408955833,0.22599283049117724},
{-0.35739474454892184,0.9338862673034082,-0.011199835307632694},
{-0.5563161500922591,0.7952230856612699,0.24110699943779199},
{-0.005499894705523784,-0.9989808746942292,0.0447991423286301},
{-0.4036064073025743,-0.9080144148432543,0.11230178280495315},
{0.016299316502493402,-0.9852586840433588,-0.17029285891868876},
{-0.6311029093911185,-0.7721035594056134,-0.07460034390837814},
{-0.7990990290952695,-0.5528993282277243,0.2360997131390228},
{-0.9375760639886257,-0.09089767941186654,0.3356914299071903},
{-0.9729868842252003,-0.2119971422977826,0.09139876795291194},
{-0.8606499761739101,0.45297367167047903,0.23258648130364992},
{-0.7738272508064642,0.4643163511882157,0.4308151714233972},
{-0.49590673941838337,0.769510457718181,0.4024054687274803},
{-0.362209096995708,0.9202231116936789,0.14830372469481914},
{0.01420038795989867,0.9464258567076126,0.32260881379319084},
{0.304111670509288,0.9520365351030654,0.033801297149667654},
{0.4843007894109301,0.8484013828953811,0.21370034833185164},
{0.8916040969302381,0.4404020236519481,0.105300483856835},
{0.9984676751322679,0.055298209749438575,-0.0020999320158014644},
{0.87841510886981,-0.47200811860946074,-0.07480128659319421},
{0.5455252311254228,-0.8350386214293823,-0.07150330710443213},
{0.6351035121321332,-0.711703935733647,-0.30020166011977073},
{0.9546953506449635,-0.11539943800610536,-0.2742986641687582},
{0.84037777230188,0.5356858312971408,-0.08249781796157199},
{-0.3371813661866823,0.7162604169618048,-0.6109662358839351},
{-0.900934213626406,0.41501576052276445,-0.1268048155043049},
{0.15569532687489473,0.9722708177293523,-0.17449476261829885},
{0.9538011636381294,0.1346001642123005,0.26860032769259967},
{0.46620092307874156,0.7856015554926198,-0.4068008054663922},
{-0.6120891722383138,-0.07109874227437366,-0.7875860677256918},
{-0.06470296540485831,-0.20440936829602843,-0.9767447652384098},
{0.14010001891350382,0.7956001074060217,-0.5894000795690161},
{0.4595082413542137,-0.31820570707053486,-0.8292148721020979},
{0.8522009161164773,-0.26250028218795507,-0.4526004865457846},
{0.7187789760224226,0.5090851094783185,-0.47348615073263367},
{-0.7605745325881574,0.03899869415058919,0.6480782994614578},
{0.2553916743671213,0.9459691619079745,-0.1997934868384919},
{0.9792158928029113,-0.20270328990109285,-0.006900111989726397},
{0.9403082982573483,0.11990105813150703,0.318502810799708},
{0.7776088142458645,0.04540051461774981,0.6271071082993591},
{-0.696510653211912,0.6180094525268651,0.3646055766849434},
{-0.928141094356699,0.32701447888658614,0.1778078726178441},
{-0.875952790885712,0.0655039477143671,-0.47792880324726766},
{-0.41528889739974,-0.3336910788882573,-0.846277375076812},
{0.19560517773758299,-0.4927130422868463,-0.8479224448041749},
{0.7151906024572251,-0.511793275080548,-0.4759937454832762},
{0.1285024993979202,0.8134158210915818,-0.567311034306927},
{-0.27539117523118234,0.5616820011886533,0.7801749996926959},
{-0.5723018599840675,0.43700142025692373,0.693902255185994},
{0.2748949227376651,0.9301828196819792,0.2432955063734955},
{0.5646753214043553,0.34538490528256477,0.7495672408795905},
{0.5194126712266738,0.757118470130371,-0.3962096656526919},
{-0.12170468024346988,-0.12520481484373402,-0.9846378649771605},
{0.11209533805183362,0.3978834523713166,0.9105621305084718},
{0.4390076892870174,0.05790101414514421,0.896615704361594},
{0.7367982169504724,-0.11419972363700319,0.666398387317854},
{0.4516950562246642,0.2691970536543715,0.8505906903358411},
{0.9096802647007337,-0.0038999153922533378,0.4152909903596952},
{0.9053822365747759,-0.3671927957480205,0.2131958171391012},
{0.8050810083630165,-0.5445871533405773,-0.23509445418723784},
{0.9329951857572623,-0.30539842414819707,-0.19039901754360422},
{0.5149889664795886,-0.48208967133943614,-0.708784814448024},
{0.3987047645504047,-0.6529078022948565,-0.6440076959379499},
{0.024201214931485103,-0.5886295499451294,-0.808040564654544},
{-0.11489911872713904,-0.3261974980747846,-0.9382928033217978},
{-0.4883075346433898,-0.404406240036426,-0.7733119322951737},
{-0.6947313817252848,-0.0554025025875641,-0.717132393601845},
{-0.8390263248639204,-0.17400545950693938,-0.5155161745737198},
{-0.9973487017261871,0.07240353555096354,-0.007300356485110965},
{-0.9018865710089358,0.24159640265634647,0.35809466801008966},
{-0.5500907943075853,0.33609437550768845,0.7644872064136501},
{-0.09740120486035622,0.2885035688112194,0.9525117826436273},
{-0.1903955819217817,0.5183879709466996,0.8336806546648602},
{-0.7395936358241454,0.5106956054832221,0.4383962276166919},
{-0.9612687881091668,0.2310924965484536,-0.1501951232435211},
{-0.9614623979409105,-0.24609037559361213,0.12259520539527365},
{-0.4279078008303144,-0.7948144896002193,0.43030784458351085},
{0.27589541189744987,-0.8365860876890416,0.4732921292173361},
{-0.6571997075461953,0.6570997075906952,0.36919983570610965},
{-0.11660076023943515,0.9736063479340828,0.19620127923651096},
{0.4734982078126751,0.8163969099435437,0.33059874868610434},
{0.9874295393965131,0.15790472379046935,0.007000209414396994},
{0.8327815249468012,-0.45778984404496353,0.31129309403931227},
{-0.004100110581473594,0.46381250919206163,0.8859238936896235},
{-0.0086997139146118,0.46518470265257583,0.8851708916338351},
{-0.037299321531511956,0.4602916273714464,0.8869838659102173},
{-0.05580197179751082,0.46121629736580627,0.8855312908010005},
{-0.03190087122468988,0.4731129208903067,0.8804240447089959},
{0.125199035345149,0.4230967400521768,0.897393085612913},
{0.04740052520072885,0.9382103954287724,0.34280379828712765},
{0.021300763965599684,-0.32131152404446844,0.9467339552222169},
{-0.03999786697063017,0.4384766166655332,0.8978521188232208},
{-0.629515391839498,-0.28980708586987536,0.7209176266514601},
{-0.4398871180943672,0.1583953614597585,0.883974113197137},
{0.2785985777578908,0.8490956653776923,0.4487977088935441},
{-0.022999774143326865,0.9157910069764671,0.4009960622380032},
{0.0720016513768117,-0.2622060137638893,0.9623220711098043},
{-0.29490102330832635,0.8529029595784047,0.4308014948837809},
{-0.49916876798724996,0.6330603906504967,0.5916629808054003},
{-0.5757940866250953,0.2700972261157316,0.7716920747630881},
{0.5840011066831458,0.8015015188468174,0.1286002436976927},
{0.6797985112428906,-0.29029936424508845,0.6734985250398452},
{0.4866018539565954,0.6819025980538479,0.546102080652891},
{-0.7222442966011076,-0.2493152909757077,0.6451395676230608},
{0.5694132788724968,0.3760087686267278,0.7310170475163245},
{-0.5341063185151222,0.8373099054347722,0.11680138176851952},
{0.42792010629855276,0.034901639892076404,0.9031424351442463},
{-0.029699255597487557,0.9549760638249365,0.29519260109017936},
{0.2766058627233913,-0.16380347185137925,0.9469200701835836},
{0.024399335127176555,-0.18049508157603966,0.9832732061701929},
{0.025198933351726356,0.9560595308565701,0.2920876361920345},
{-0.19900467467471283,-0.1701039957897922,0.9651226709978157},
{-0.43360150459983143,-0.0017000058990307044,0.9011031268332752},
{-0.6154010707987948,0.6360011066428884,-0.46560081014611454},
{-0.8122122482530562,-0.5666085445212775,0.1388020931513472},
{0.053999519136423126,0.8465924611277004,-0.5294952848654823},
{-0.032001959700005175,0.8443517054598242,-0.5348327514863366},
{-0.0770960832329845,0.8377574388144541,-0.5405725369098757},
{0.669690483765838,0.5916915921222135,-0.44879362268793205},
{0.04970079795271675,-0.9284149058209704,0.36820591159336635},
{0.7882662865718696,-0.5991743738600332,0.14009400830739432},
{0.012299952706772763,-0.9313964187876546,0.3637986011970676},
{-0.02069954844427598,-0.9294797236209914,0.36829196579839824},
{-0.7491112891921927,-0.6319095229482667,0.19880299598372436},
{-0.6917856905609846,-0.6816858994730026,0.23819507298587242},
{0.0330995190674819,-0.2992956512657805,0.9535861444939802},
{0.022600647630836922,0.9667277019792059,0.2548073016078429},
{-0.7605031560946468,0.26920111718695455,0.5909024522502654},
{0.8220170775821819,0.2729056696741818,0.4998103836685822},
{-0.9574867389004985,-0.24809656388638504,0.1471979613223534},
{-0.9856911781034338,0.157898586813972,-0.05899947195708896},
{-0.7840978868590424,0.562298484607626,-0.26269929202636194},
{-0.3362834771172678,0.8486583021987071,-0.40827993965798526},
{0.3652858308374274,0.8417673484778165,-0.39748458187209795},
{0.9121905634374314,0.37719609792655023,-0.16009834379120014},
{0.9847492682383658,-0.14690734995858226,0.09320466314594872},
{-0.7170147670711933,-0.609012542742478,0.33910698398025335},
{-0.2560991113376255,-0.8456970654362744,0.4681983753544563},
{0.351080139958208,-0.8231534355271912,0.44627475495114843},
{0.7913063898248969,-0.5404043637828564,0.28600230947797356},
{0.6011018904684183,0.7955025018593026,0.076500240593635},
{0.07710179610726073,0.9632224385280613,0.25740599634252803},
{0.23109584608949948,-0.2714951199190788,0.9342832064102958},
{0.7555010803673173,-0.21170030273164936,0.6200008866019018},
{0.7528687340107013,-0.21439109652263827,0.6222741574908479},
{0.5927255025633835,0.8021345125798716,0.07250311951382706},
{0.05750022051376851,0.9608036846891962,0.27120104005798296},
{0.22700127915581209,-0.26970151977234585,0.9358052732775723},
{0.11439938167301308,-0.8522953933558484,0.510397241310366},
{0.7765008580339222,-0.5977006604595948,0.19950022044786542},
{0.60632155208261,0.6041214738794404,-0.5171183812995508},
{0.7626136966649891,-0.19860356695209397,0.6156110564738623},
{0.24809475905357187,-0.2739942119334087,0.929180371271983},
{0.14929375144079743,-0.8458645970781685,0.5120785674000828},
{0.7855986409155268,-0.5860989860496312,0.19829965694189025},
{0.6036036095603778,0.6002035892281954,-0.524803138332151},
{0.5891743803090961,0.805164988161718,0.06769705625751156},
{0.7799511765844709,-0.5941628065724264,0.19658769399552176},
{0.6177947951007768,0.5950949863458599,-0.5139956696047253},
{0.120102793022928,-0.852219818602325,0.5092118418590752},
{0.05480107493362733,0.9622188741083253,0.26670523147442354},
{-0.14549394394062257,0.851964537714161,-0.5029790639321866},
{-0.14990830065241706,0.8458468358359862,-0.5119283462573201},
{-0.11520055469200627,0.8523041038541401,-0.510202456630743},
{0.4165145491073049,0.9090317530337099,0.013300464593342508},
{0.03969824656717283,0.6714703418099889,-0.7399673163654382},
{-0.25729848322991195,0.965694307248838,0.03509979308732962},
{-0.08130126587056448,0.7021109319523163,0.7074110144752438},
{-0.9102877157501634,0.28389616884705193,0.30129593403880506},
{-0.794851158266872,-0.5718368046011543,-0.20301306634143815},
{-0.8340656288636371,-0.41198302252945507,-0.3668848809855754},
{-0.5514998952150298,0.7276998617370394,-0.40779992251802205},
{-0.5867088212334414,-0.5750086453199741,-0.5702085731503466},
{0.21579239453107976,-0.3232886058938743,-0.9213675269737576},
{0.5355198413776914,0.8409311570765653,-0.07780288265020428},
{0.5417961695146223,0.8238941750887732,0.1662988242714686},
{0.431076416454366,0.07899567826465997,0.8988508252164918},
{-0.6903074519091652,-0.5504059416642105,0.4696050694140866},
{0.9567322137159628,0.17440587234458443,-0.23290784213906945},
{0.6065747397209357,0.7897671108334898,0.09129619804899675},
{-0.411802493471647,-0.9112055173661116,0.011100067211110447},
{-0.5608000616880101,-0.8267000909370149,0.04550000500500082},
{0.3899988514550737,-0.9204972891394751,-0.024199928731314827},
{-0.5110077648219802,-0.846912868938816,-0.1470022337159121},
{0.6560902538516681,-0.6724900102350964,0.342494912275867},
{-0.24908780371427938,-0.7825616828052792,0.5705720626229138},
{0.5882925316737154,-0.8068897565995595,0.05329932336938471},
{-0.13589966161026387,0.9415976554247569,-0.3080992328338653},
{-0.78093355743596,0.24461051113950036,-0.5747246964508211},
{-0.7041947748941554,0.6613950924666208,0.25819808417732304},
{0.10289784225487164,0.8431823186521649,0.5276889344790647},
{-0.5937936701932134,0.12279869097293131,0.7951915233035421},
{-0.7074937634699623,-0.6016946960846309,-0.3706967323227067},
{0.21640279918831137,0.9026116753575315,0.37210481320688843},
{0.6317910791729426,0.6897902602302878,-0.3535950072737457},
{0.2832010520938628,0.8192030433449591,0.49870185268082406},
{0.36019775597497045,-0.513096803416872,0.7790951462523583},
{-0.5728807658511743,-0.8074728895528422,0.14069527623539926},
{0.012299840041620382,0.27839637947862717,-0.9603875102416435},
{0.21698918878299658,-0.5442728822791938,-0.8103596248375136},
{0.7225459734501377,0.6453410611313133,-0.24791577414296076},
{0.3786116595255854,0.7843241536342225,0.4914151333620514},
{0.8773113130023222,-0.47240609171582926,-0.08460109093810152},
{-0.36611721889771665,-0.5117240669488162,-0.7772365542947429},
{-0.2358962339466873,-0.9093854817766741,-0.34259453052197997},
{-0.17360725606690416,-0.8549357327856932,-0.48882043067685915},
{0.38118602407063645,-0.8854675349279868,0.2657902549789485},
{0.18769431482530463,-0.7822763052095674,0.5939820085574371},
{0.34641892538285457,-0.8043439425099017,0.4827263720620783},
{-0.56099943619585,0.68649931006854,-0.46259953508770085},
{-0.21509441837226392,0.9094763993936495,0.35579076734937937},
{-0.043600662735110395,0.8140123730821068,-0.5792088040407326},
{0.3249954403459577,-0.27749610675693315,-0.9040873157439395},
{0.46159393931136505,-0.7082907002041592,-0.5340929874051128},
{0.11049653764523848,0.9518701736154073,-0.28589104174455815},
{0.5916830958554237,0.6859804018198761,0.4234879011234949},
{-0.3068003666266572,0.831900994122282,0.4624005525689905},
{-0.4146031385576384,0.8537064625823828,0.3151023853340855},
{-0.97596542703711,0.1765937442774115,-0.12769547646786777},
{-0.03470124319430656,-0.5785207258762635,-0.8149291953613951},
{0.8749037008504819,0.24930105454569107,-0.4152017563071438},
{0.7951181527546435,-0.5568127121793301,-0.2403054862368769},
{0.5647090749477521,0.20890335710392322,0.7984128305972824},
{-0.33949665597440787,0.024399759663550964,0.940290738181843},
{-0.41059699854691095,0.7898942258943131,0.45549667033150987},
{0.3342859285300015,-0.8918624578399892,-0.30468717446333077},
{0.4221872163646298,-0.8223750988590041,-0.3813884517325197},
{0.2218045869662882,-0.8868183395928961,-0.40540838393207046},
{0.1903005575814506,-0.8198024020245569,-0.5401015824999551},
{0.4379162535633821,-0.8150302504091262,0.37941408221499695},
{-0.2891152801463443,-0.8107428488918758,0.5090269027827369},
{-0.45519021123975983,-0.8460818052064165,0.2773940347054248},
{-0.4284956507912166,-0.7998918811386095,-0.420195735034934},
{-0.39639161838784276,-0.7821834609055768,0.480689835920878},
{0.09800021511070826,0.6605014498022734,-0.7444016339633798},
{-0.41550941139475334,0.903320460440146,-0.1066024145720354},
{0.613468830440568,0.7278630182195426,-0.3063844330024287},
{0.8949798542302195,-0.40689084099025286,-0.18289588306000798},
{0.31120143152987756,0.9450043470299946,0.10060046276319307},
{-0.021699528908341044,0.723784286813698,0.6896850271005907},
{-0.5323993797550838,0.8455990148777215,0.03889995468157919},
{-0.5150998068376086,0.825499690437674,-0.23069991348754862},
{-0.12940396435117277,-0.38111167553502273,-0.9154280445677245},
{0.6846313362934097,-0.5787264889176106,-0.44312028207947685},
{0.5090002621352026,0.751400386971299,0.4199002162486671},
{0.5978836152240341,-0.550784905946476,0.5823840399840734},
{-0.1470981811422352,0.6125924253414907,0.7765903975191015},
{-0.35069402247133,-0.4401924969828328,0.8265859109632204},
{-0.5958852132918959,0.797080220699732,0.09789757070192417},
{-0.9440204571449619,0.18650404158637224,-0.2721058965986697},
{-0.27730090538893415,-0.9573031255998077,-0.08170026675180642},
{-0.8553827684876916,-0.5111897021871731,0.08369831391444912},
{-0.26960650029108396,-0.961923192247751,0.0449010825781516},
{0.40481411611434764,-0.9141318763343014,0.02210077066730999},
{0.5154216326998962,-0.8439354207129266,0.1487062413319258},
{0.5291337942089352,-0.8455540030309104,-0.07110454123654374},
{0.8695665223333229,-0.3571862485941386,0.34098687225812224},
{0.8084154691780056,-0.5886112631842827,0.001100021049104164},
{0.6904833940740563,0.669283903915664,-0.2743934009180609},
{-0.09360267145836568,0.8630246310744613,-0.49641416786252907},
{0.576133710569637,0.706141317537269,0.41162408482982576},
{0.6030873021305291,-0.46449022026136755,0.6484863462637176},
{0.05929912860570766,0.9678857770230092,0.24429641009063036},
{-0.2303956755137555,0.9112828953805789,-0.3412935939793609},
{-0.34430799836770415,0.804718693832389,-0.4836112344194648},
{-0.3683995192389411,0.03779995067109656,-0.9288987877878728},
{0.5890723760986191,0.13769354301269707,-0.7962626601380588},
{0.721313095558126,-0.5810105483422586,0.3770068446213967},
{-0.665510664893858,0.6701107386106301,0.32870526754411894},
{-0.9008159085494187,-0.43000759400116567,0.06020106316016319},
{-0.698400607608793,-0.561100488157637,-0.4443003865415044},
{0.007200210465227893,-0.859125112594067,-0.5117149576468213},
{0.5789191364883401,-0.8038265709264601,-0.13680452214822067},
{-0.04240120739157095,0.28520812141688767,0.9575272659771035},
{-0.20019155109387535,-0.5830753918223712,0.7873667698867006},
{0.14979412144505355,-0.9118642145910838,0.3821850014439217},
{0.09580195917009775,-0.8339170537781264,0.5435111149159512},
{0.2980993710109907,-0.8524982012306931,0.42939909396886755},
{0.46672024909727017,-0.5465237114455928,0.6953301675537432},
{0.5269160158557067,0.7658232775522872,-0.3686112041078259},
{-0.5613901841784437,0.21739619886069408,-0.7984860385936716},
{-0.0561001497875999,0.794702121857498,-0.6044016137544631},
{-0.3065951236433374,0.8239868945926615,-0.4764924214483049},
{0.8857377243730387,0.10030427204992184,-0.45321930302118224},
{0.47671018025460016,0.313606697142527,-0.8212175372877651},
{0.4721017916296989,0.567002151777249,-0.6750025616395822},
{-0.9707941315672118,-0.07089957141338621,0.229198614498563},
{-0.45371873443332505,0.27781147107246573,-0.8467349624084116},
{-0.6479142704689624,0.7615167725916265,-0.01730038104508882},
{-0.8760127460781839,0.33170482634033516,0.3501050940661783},
{-0.8162059828117811,0.45730335204585576,0.35310258825145785},
{-0.7211768902568216,0.6162802516157504,0.31638986144933223},
{-0.5897818084606727,0.7462769814415057,0.30859048167338693},
{-0.026499301090150498,-0.5104865360951634,-0.8594773315843153},
{-0.07309853109977617,-0.8896821220173852,-0.45069094345648586},
{0.05520194093436547,0.9810344937792125,0.18580653307255623},
{-0.06030155549868639,0.3736096373848961,-0.9256238767758561},
{0.7895850256619811,0.6103884240933046,-0.06309880334254181},
{-0.34730282879306085,0.2859023286839507,-0.893107274388375},
{0.9756700522673614,0.20369374771636928,-0.08109751075011071},
{0.9882917230914785,-0.018099848414404294,-0.15149873120343924},
{0.9713399908906544,-0.207408539185341,-0.11610478013219908},
{0.9336142563985436,-0.3111047506058129,-0.1777027135411538},
{-0.35311967107918146,0.21831216141768708,-0.9097506790731559},
{-0.8510842295553382,0.1683968796347303,-0.49729078528712223},
{0.3614115274045028,0.9215293926487254,-0.1420045293066945},
{-0.2467900965121365,0.969061112357826,0.003899843502420309},
{0.3748166947073817,0.9152407657315788,-0.14780658345184366},
{0.6558871086655675,0.7136859726400603,-0.2458951669779891},
{0.8014219752918479,0.5844160249071074,-0.12720348796746075},
{0.31709961789519064,0.9181988935709999,0.23739971393351708},
{-0.14500628978423202,0.9888428919906803,-0.03410147918374008},
{-0.5803679616709895,0.8139550668507675,0.025498592389059667},
{-0.6004926710316749,0.7995902410606615,-0.00799990236178751},
{-0.9450136791720097,0.3267047290851805,0.014600211339588724},
{-0.5931990123244666,0.41969930120124516,0.6869988561478567},
{0.8552129095363049,0.44060665100759583,-0.2729041195187764},
{0.9439213564622877,-0.09730220148721326,-0.3155071384297614},
{0.9819853046998719,0.18319725847354026,0.04629930713605302},
{0.8229280211761897,0.3165107773754576,0.4718160656105557},
{0.46819938197722377,0.6821990994977831,0.5615992586894678},
{-0.16410158030582755,0.8677083560717037,0.46920451846126926},
{-0.7077241939651131,0.6325216231212859,0.31471075857117575},
{-0.9826414634313427,0.18540782344816908,-0.006300265845326134},
{-0.9988326623620977,-0.04800156967699308,-0.005400176588661721},
{-0.8574594002585739,-0.5013762603960921,-0.1156945219940723},
{-0.7791909263744932,-0.30079649724518426,0.5498935965263525},
{0.8795111126931138,-0.27580348479904576,-0.3878048999458664},
{0.756188415282216,-0.5857910257502277,-0.2915955327906562},
{0.8925471404608629,-0.3239808128045257,0.31368142276783856},
{0.6416707597297036,-0.1443934201417628,0.753265674465304},
{0.3187832898179101,0.32558293338993577,0.890153339384892},
{-0.07979636216677133,0.4714785057848707,0.8782599610410434},
{-0.4910910474918056,0.42609223240940414,0.7597861492247484},
{-0.8907062572334357,0.1161008156110945,0.43950308752003475},
{-0.8256112242608913,-0.4956067378194013,0.26970366664627227},
{-0.9024997743750846,-0.41199989700003864,-0.12549996862501178},
{-0.6284042166064402,-0.7399049647789705,-0.24010161108721562},
{-0.5065924796904581,-0.8262877338496357,-0.2461963452423821},
{-0.3257942953918311,-0.9016842116476799,-0.2842950220377458},
{0.4984076431398118,-0.7534115536547635,-0.42890657733279547},
{0.45090476608856656,-0.8503089878135021,-0.271402868743484},
{0.6103116753740259,-0.6674127677283711,0.42670816300523823},
{0.2022002689265365,-0.4709006262982494,0.8587011420732784},
{0.32408793929175467,-0.0608977337330079,0.9440648672796841},
{-0.17509825778100258,-0.07499925376113759,0.9816902322307837},
{-0.617614501758754,-0.18580436273765621,0.7642179440479918},
{-0.4614814234391917,-0.7198710221752417,0.5184791290427321},
{-0.26539436175667613,-0.9601796012010565,0.0872981453706022},
{0.15130195256429682,-0.9085117244194559,-0.3895050265948025},
{-0.01989949843946267,-0.9455761670530602,-0.3247918137255012},
{0.3691138770970691,-0.9226346871031048,0.11180420335803937},
{0.061903483716571985,-0.8772493685973659,0.4760267891613613},
{-0.19560735790915423,-0.5629211746782358,0.8030302065493398},
{0.002900110989371385,-0.9616368025446635,0.27431049806364516},
{-0.13820379512832204,-0.9890271590586868,0.052201433471044945},
{-0.023500668603532792,-0.9994284341434327,0.02430069136450412},
{0.1370995167250553,-0.9857965250733736,-0.09699965807680791},
{0.3040000167200014,-0.9358000514690042,-0.1785000098175008},
{0.5111133351208722,-0.8419219660306444,-0.17300451374664624},
{0.6079903664689643,-0.7862875413726096,-0.10999825709142447},
{0.731070706583669,-0.6546737677476789,-0.19219229900886498},
{0.8348246402128892,-0.5007147788147983,-0.22880675333098832},
{-0.5589803018812365,-0.8207710765368853,0.11779584894742336},
{-0.3263112611959391,-0.945232620540612,0.007500258838398846},
{-0.5005147278625542,-0.8657254743468796,-0.0021000617952275005},
{-0.6501106001397536,-0.7593123806893015,0.02830046144278577},
{-0.768407080903876,-0.6325058285680655,0.09740089755340646},
{-0.8484191872168808,-0.48951107041803765,0.2014045548155113},
{-0.9029417259012532,-0.3811176118517749,0.19860917794217395},
{-0.9677369779364039,-0.17980687055178818,0.1765067444515607},
{-0.9780178294275472,0.002700049222345989,0.20850380105894029},
{-0.9455697327972721,0.17789430569441064,0.2724912776937993},
{0.9563553105604818,0.2914863791597453,0.020499042102143327},
{0.8841155163634694,0.46720819957585447,0.007500131628465129},
{0.7836797264677111,0.6201839560485829,0.03489909717203409},
{0.6615374903919008,0.7429421037220607,0.10200578083140421},
{0.535019932538887,0.8268308041554239,0.17350646410373252},
{0.4003241923219351,0.8991543375384758,0.17681068499255093},
{0.2189081774677068,0.9622359449951005,0.1618060443776837},
{0.0346993537305551,0.9829816921364743,0.1803966401438657},
{-0.17280431238542404,0.9409234810384576,0.2912072671680294},
{-0.24671283680285697,0.8924464351960663,0.37771965326485235},
{-0.4290103714510962,0.8408203270771135,0.3301079804568925},
{0.9428166220035702,-0.12470219851914002,0.3091054495771145},
{0.9403708489555166,0.13779572839862844,0.31099035944828335},
{0.23460808356078103,0.7513258873794321,-0.6168212529424115},
{0.19240121116943645,0.7638048081664011,0.6161038783861216},
{-0.6211043197955664,0.6258043524844074,-0.4718032814032333},
{-0.7939815004465568,-0.18159576886787748,-0.5801864818124588},
{-0.7028970970409839,-0.35719852477313907,-0.6150974596527374},
{-0.604001679127002,-0.7580021072487872,-0.24620068443885412},
{-0.3099975556789102,-0.5988952777293526,-0.7383941777848622},
{0.5751991602098392,-0.06779990101221678,-0.8151988098106066},
{0.7300764517638163,-0.5176833023943676,-0.44608561174063616},
{0.784305513687142,-0.5867041245444934,0.20160141726294506},
{0.28770407247996915,-0.5182073352767467,-0.8054114006790655},
{-0.1872053578940155,0.1574045049813998,-0.9696277511433623},
{-0.18730185336100855,0.15740155749611717,-0.9696095943344042},
{-0.18729890430461474,0.157499078633085,-0.9695943278897728},
{-0.18720241024654802,0.15750202785166298,-0.9696124838410948},
{-0.1876065419541789,0.15750549231227706,-0.9695338082333499},
{0.01610036234273183,0.41270928812704516,0.9107204959953961},
{0.014299891106743833,0.6264952292569937,0.7792940656982845},
{-0.331788672928056,0.5201822412814188,0.7869731331958413},
{-0.11419640515374774,0.20739347135628095,0.9715694154761936},
{-0.4642870349655704,0.25099299111858314,0.8493762814985042},
{-0.7111706292595048,0.32958638836323506,0.6209743542887408},
{-0.5173889538637513,0.6524860695711204,0.5536881788835699},
{-0.13909940256934894,0.8006965610156556,0.5826974973196235},
{0.27270031905955994,0.809400946999662,0.5201006085180679},
{0.3468800324256336,0.4803723481616442,0.8055536296399263},
{0.2955026935193272,0.08660078936979267,0.9514086721295699},
{0.07030283150355936,-0.2106084824274481,0.9750392704974448},
{-0.29480086524180926,-0.12150035660406995,0.9478027818052469},
{-0.714576530119296,-0.01979934970103843,0.699277032623039},
{-0.9199231593570589,-0.029200735137760756,0.39100984379672793},
{-0.8582061619423642,0.4368031362577776,0.26960193574884805},
{-0.5970223589060193,0.7819292838000278,0.17930671516222657},
{-0.2623048146490597,0.8998165162837359,0.34860639872917354},
{0.06330300158298177,0.9762462898152734,0.20720982508679026},
{0.415291748234943,0.9096819247997295,-0.003399932444013499},
{0.6540994930730892,0.6924994633131238,0.30429976416777416},
{0.6718060026134501,0.43200385997173335,0.6017053762615555},
{0.6592061965673717,0.0666006260488273,0.7490070406992739},
{0.37989874823568687,-0.37569876207461844,0.8452972147502662},
{-0.20810136202787174,-0.5879038478432763,0.7817051162767291},
{-0.5569031019589169,-0.24310135407831335,0.7942044237309603},
{-0.6889961795267767,-0.47719735394800855,0.5454969752276585},
{-0.8679359463115901,-0.3820158215128787,0.3174131459376642},
{-0.9865249100684729,0.019000479768171295,0.1625041032804124},
{-0.9611937282313848,0.27439820955752386,-0.028499814039320087},
{-0.8713188294033573,0.4845104703843987,-0.07780168131249994},
{-0.5295712556523436,0.7921570028847935,-0.30338353278874824},
{-0.2618960270674039,0.9631853885884818,-0.0606990792019527},
{0.11109646107859762,0.9762689014494585,-0.18589407843844552},
{0.36210571950500975,0.8740138051570796,-0.3240051177012515},
{0.7541707161196285,0.6470748745704211,-0.11189565517606263},
{0.9562020032452951,0.21640045335942468,0.19710041292579758},
{0.9045350514123764,-0.008400325518920908,0.42631652008523613},
{0.7456590420736973,-0.33088182516050213,0.578368231105574},
{0.5743364887562328,-0.6277398815815556,0.5254333818431564},
{0.22349640955902042,-0.7497879547532595,0.6227899949590958},
{-0.24660473855557746,-0.8405161506730043,0.48240926958317343},
{-0.5567973607867647,-0.6981966905555301,0.4499978670151655},
{-0.09339790183970248,0.9228792677501223,-0.3735916073588099},
{-0.6867932900623339,0.6298938459671872,-0.3626964564729303},
{0.9001271347414713,-0.3167095473532096,0.29910901677721813},
{0.5844010227026846,-0.7205012608783098,0.3733006532767148},
{0.04850241305507573,-0.8912443405089379,0.4509224339491473},
{0.9842367324002925,0.17640658361655315,0.012600470258325225},
{0.8034005463125572,0.5508003745443819,-0.22620015381615688},
{0.6785884742726458,-0.4023931654101277,0.6144895629834083},
{0.7285972568364921,0.37889857344955646,0.5705978517031326},
{0.9817701104639734,-0.04009877921125008,0.18579434357731336},
{0.5205977588314723,0.8519963321636851,0.05549976107404287},
{0.05369997583501631,0.7524996613752286,0.6563997046201994},
{-0.47110039101348683,0.860300714049889,0.1948001616842013},
{-0.6393801635381345,0.5087842152145807,0.5764821149198226},
{-0.9210226344093644,0.1299031924101807,0.36720902427265867},
{-0.6446924087915794,-0.1874977922264947,0.7410912737016279},
{-0.6047051218740735,-0.7124060341046635,0.356103016205321},
{-0.06389874983318915,-0.6553871774753077,0.7525852758131166},
{0.3576117995959947,-0.891529416498404,0.2780091730640004},
{0.2314060108491987,0.07800202612894339,0.9697251889389282},
{0.019500874926380796,0.1401062860095359,0.9899444148525308},
{-0.744104338140937,-0.26970157236475034,-0.6112035633271613},
{-0.7274052082399366,0.28240202200571635,-0.6254044779120927},
{-0.24249009448195652,0.3562854460367881,-0.9023631392186291},
{-0.14709942704884746,-0.820296804950167,-0.5526978472460774},
{0.35571577100831925,0.11700518753998694,-0.9272411101459477},
{0.8642138750651471,0.4879078334231489,-0.12280197160148122},
{0.5836998978525267,0.7978998603675367,-0.1504999736625069},
{-0.43830232520000284,0.7819041480125078,-0.4433023517252139},
{-0.09540402327249388,0.9585404225019433,-0.26851132336126426},
{0.20999784753309414,0.8854909237645469,0.41449575144032147},
{0.9563228898623066,0.07000167551015525,-0.28380679299688655},
{0.7676943996897813,-0.5958956529570674,-0.23569828058731462},
{0.6088238998512921,-0.5514216464816073,0.5703223884447962},
{0.38838589990585126,-0.5362805306887436,-0.7493727945145336},
{-0.31048869531240175,-0.45908328508187973,-0.8323696939711538},
{0.14559919847861857,0.5756968307976696,-0.8045955707135748},
{-0.19309817909275667,0.8542919440649509,-0.4825954491463717},
{0.23759997980400258,0.8279999296200089,-0.5078999568285055},
{0.597104027480248,0.5481036969719042,-0.5857039505864701},
{0.343212937655532,0.910634327007947,-0.23010867410995894},
{-0.13129784607650252,0.9903837528877996,-0.043599284759600225},
{-0.3679832755401814,0.9098586478641605,-0.19169128782894776},
{-0.40138615040981607,0.8760697717340306,-0.26719078074116304},
{-0.4481125406049257,0.8151228115310756,-0.3671102737247673},
{-0.4507865126693083,0.754377429364965,-0.47718572281675675},
{-0.4069157011452489,0.7031271306837663,-0.5831225002157646},
{-0.3245841266014234,0.6663674120985476,-0.6712671724816252},
{-0.21709927271865456,0.6449978392608577,-0.732697545467334},
{-0.1706943893676307,0.6121798779781108,-0.7720746223242395},
{-0.1264981923537468,0.5151926379498052,-0.8476878866266495},
{-0.046002671682739214,0.4264247653373913,-0.9033524637177899},
{0.06619892560015618,0.36389409404678,-0.9290849210740955},
{0.19460680551898557,0.34091192189836683,-0.9197321635961513},
{0.31861221423335345,0.3581137285529311,-0.8776336447306685},
{0.41549181073711466,0.3913922857340715,-0.8210838165974607},
{0.49120213673394225,0.3735016247356014,-0.7869034230373354},
{0.5986980931496101,0.3291989515030092,-0.730197674324111},
{0.6938098209475237,0.32190455659124806,-0.6442091188446163},
{0.7609150168060365,0.35760705744491866,-0.5414106848452992},
{0.788675228100122,0.43468634671627115,-0.4347863435754192},
{0.7470077988021294,0.6366066462080798,-0.1916020003353253},
{0.39327841354030496,0.9114499718840274,0.12079336983388976},
{0.03310109152648992,0.9838324424096915,0.17600580388707632},
{-0.10080238450860866,0.9762230928303945,0.1919045395555754},
{-0.23769323891197733,0.9581727451638902,0.1593954660604509},
{-0.33640997806792644,0.9394278638436685,0.0656019457825683},
{-0.37348115835082984,0.9250533322365534,-0.06919650912416982},
{0.09369823708425375,0.9734816841144186,0.20869607342031757},
{0.18580649869593982,0.9325326158986215,0.3096108288281107},
{0.30309506868334846,0.8782857104077366,0.3697939835008323},
{0.43100835086769784,0.8237159596513288,0.36840713795744756},
{0.5464880129169035,0.781082867135212,0.3020933736545225},
{0.6291830091422541,0.7540796363543767,0.18839491246408246},
{0.6715061308789626,0.7390067471624026,0.054300495765789526},
{0.7119184175676968,0.7013181433350552,0.036400941704543006},
{0.8192808249566852,0.5733865800441393,0.0025999391491363134},
{0.8710704625014164,0.4818836596021496,-0.0949967787138498},
{0.8648319431577417,0.44471642590454175,-0.23300860633181525},
{0.8057536891570223,0.46203078613695464,-0.37052468888255774},
{-0.7077022894206094,0.7060022839210828,0.026800086698420707},
{0.0884986415562781,0.8208873994751265,-0.5641913397294023},
{-0.4450965861222766,0.8472935012837677,-0.2897977772595726},
{-0.5251776042785882,0.6623717537588287,-0.5342772162339102},
{0.6794906740544975,0.7263900303652495,-0.10319858360915989},
{-0.19159850362153003,0.9684924361036109,0.1590987574435565},
{-0.4036942009744542,0.914786859181151,0.013999798894333313},
{0.9983265009287055,0.022900607904705356,0.05310140959562683},
{0.24889616329521402,0.9438854501179288,-0.2170966534808797},
{0.8106438529653713,0.5808314209255955,-0.07410400876478414},
{0.7428853690167344,0.6326875393416178,0.21869569283074414},
{-0.9709306770393692,0.19900628770299153,-0.1330042023341602},
{0.7419805863319346,0.37119028793317266,-0.5582853926537994},
{-0.030399268450407007,0.6653839877270007,-0.7458820505644272},
{0.6486767194103031,0.2346915770704457,-0.7239740170387843},
{-0.779804612557925,0.14830087720228297,-0.6082035975349191},
{-0.47808343230572525,-0.05989792427340084,-0.8762696334020226},
{-0.5463837480571174,-0.12419630583582354,-0.8282753633157218},
{-0.8525813244106311,-0.0802982410862933,-0.516388688629662},
{-0.6873005429676434,-0.5852004623085479,-0.43030033993740285},
{-0.19489016706467485,-0.4398778065251435,-0.8766557694489505},
{-0.012299523095237795,-0.10049610333913808,-0.9948614249961042},
{-0.2962000399870081,-0.15600002106000427,-0.9423001272105257},
{0.3742967492468492,-0.32579717046386175,-0.8681924597812302},
{-0.19169719261517107,-0.7573889081206602,-0.6241908587918089},
{0.03179946434253469,-0.7541872958220018,-0.6558889516436636},
{-0.8454384260497159,0.2735124314225187,-0.45872084933641427},
{-0.9124333865484319,0.35651304505098197,-0.20090735133448046},
{-0.994481234316161,-0.07649855648585853,-0.07179864517234827},
{-0.8764722776202813,-0.44348597276051893,0.18739407281921364},
{-0.5770785388482029,-0.8150696881219377,0.051398088540630105},
{-0.23029465377166833,-0.8196809713271234,-0.5244878241564916},
{0.2923163219375158,-0.7502418909255024,-0.5930331129283163},
{0.411677592998403,-0.39337858898608635,-0.8220552567500296},
{0.7695826499547329,-0.26669398745182854,-0.5801869198333369},
{0.7712970806460746,-0.2827989296080771,-0.5701978418052531},
{0.40780410049084576,-0.7799078420127773,-0.47480477418600675},
{-0.8787466001916102,0.38427664821761015,-0.28308279758107063},
{-0.8475844173037304,0.5229903849101593,0.089898347234079},
{-0.8259711741090267,0.4581840096570896,0.3283885394399569},
{-0.8930027683128726,0.08680026908125123,0.44160136896636565},
{-0.6207937175993666,-0.1993979821026316,0.7581923271324739},
{-0.5433747716950117,-0.5540742749286088,0.6306707186382847},
{-0.2016028627809774,-0.8498120674170366,0.48700691554730147},
{-0.12439787965621173,-0.9807832826914186,0.15029743820199856},
{0.0030999758977810917,-0.9812923704814791,-0.1924985033299549},
{0.4616921189827929,-0.8848848951437588,0.06179894510101061},
{0.6707762247580626,-0.6888755832376705,-0.27479026023183606},
{-0.4921956539315636,0.7138936963464917,0.4980956018352536},
{0.01830076910598286,0.6359267253822131,0.7715324243314631},
{-0.5481154543331055,0.6334178594683251,0.5462154007603397},
{-0.8181969031305825,-0.012699951930772913,0.574797824394352},
{-0.11849839139525514,0.6016918320888187,0.78988927732584},
{0.49409552845570104,0.3339969773410325,0.8026927356636131},
{0.03529904076160077,0.1374962635898047,0.9898731005639831},
{-0.4507892172508834,0.34039185792413645,0.8251802619241992},
{0.1053977244876922,0.48688948816942446,0.8670812799172478},
{0.6651012437404887,0.3215006012066864,0.6740012603835355},
{0.9205774737448228,0.06969829450359999,0.38429059652415315},
{0.6702726902955894,-0.1691931063673187,0.7225705594623199},
{0.008299650509075438,-0.21869079112467454,0.975758911657327},
{0.9831315246177634,-0.15010481318800356,-0.10450335095367336},
{0.6789858602666885,-0.7271848565330424,-0.1008978988231353},
{0.965069166532686,-0.20669339625148295,-0.1609948562965107},
{0.9477383367911004,0.07900319574390306,0.3091125038536764},
{0.7935173385432728,-0.5059110542773053,0.3382073899122053},
{0.8629815755400413,-0.46529006616313,0.1968957963196224},
{0.5166058350958612,-0.5572062936806309,0.650107343003909},
{-0.09879622012892543,-0.6027769381955086,0.7917697074704773},
{0.2779068435402843,-0.8485208950843153,0.4503110890471033},
{0.6160026210967291,-0.31550134246106826,0.7218030712786024},
{0.6046158139334229,0.03330087099567149,0.7958208149656266},
{0.49137249128109195,0.19008935814516806,0.8499524167458855},
{0.6417926418895409,0.5062941953703248,-0.5759933962735673},
{0.3190881764066808,0.29308913978313433,0.9012666041847115},
{-0.18939722345705606,0.8759871581223923,-0.4435934969670014},
{0.17500535087040556,0.3277100198870394,0.9284283871319116},
{0.0030000549465095225,0.3986073005595652,0.917116797147961},
{-0.18679173931798895,0.41388169648670037,0.8909605981388018},
{-0.32110416474802533,0.42780554867394965,0.8449109585661994},
{-0.4751130681646623,0.4693129086290802,0.744320472816161},
{-0.6236616272805738,0.4578718280131068,0.6335610181897893},
{-0.7597377637040907,0.39391958025936724,0.5173257143137108},
{-0.8728433901234114,0.2805139446947948,0.39931985068317843},
{-0.9206955714649518,0.25529877201585993,0.2951985800982446},
{-0.9584519063685221,0.269214579710357,0.0943051072313769},
{-0.9684841799401298,0.23189621200631502,-0.09089851518488157},
{-0.9546851547612644,0.15009766599944044,-0.25699600374321246},
{-0.916686575223408,-0.00319995313702946,-0.3995941479865538},
{-0.8747119967573039,-0.08680119048649135,-0.47680653944653306},
{-0.7647830525953296,-0.12119731429727242,-0.6327859776181022},
{-0.6348150802113478,-0.18730444947004635,-0.7496178073825241},
{-0.49291821612927184,-0.28281045145335376,-0.8228304082596163},
{-0.34500592380256795,-0.40250691110299597,-0.8479145588179634},
{-0.222601392376064,-0.3997025001469577,-0.8892055619981856},
{-0.00570006369856775,-0.4350048612064862,-0.9004100621386669},
{0.1586030126928394,-0.5138097599090852,-0.8431160151408128},
{0.30229755291121374,-0.6048951033939569,-0.7366940364859118},
{0.41170383092197016,-0.6665062018690627,-0.6215057831382184},
{0.8195183123412862,-0.529511832074083,-0.21910489595360075},
{0.5336834907565662,-0.6316804592672343,-0.5622826060566183},
{0.6922970438979339,-0.5397976950687631,-0.47889795511009753},
{0.8145075505199901,-0.4580042457190368,-0.3561033010929018},
{0.8965962163719502,-0.39419833648653,-0.20179914840939056},
{0.923790240207668,-0.3812959716293394,0.034999630230859904},
{0.9006798024818916,-0.4079908509077515,0.14939664981769135},
{0.9271134525137947,-0.25310367256093347,0.27640401065129205},
{0.9036731206427837,-0.11819648429786106,0.4115877575042268},
{0.7763978804366795,-0.044099879607493,0.6286982836560284},
{0.6745205529543775,-0.15160461946313364,0.7225220155812272},
{-0.32409496846467156,0.5099920824343799,-0.7967876299680663},
{-0.1253938928391703,0.41517977916127197,-0.9010561151305929},
{0.3606935544637721,0.26249530925073516,-0.894984006778697},
{0.8884649818428475,0.31968739976945226,-0.3292870214078218},
{0.24849991923753936,-0.1521999505350241,0.9565996891051516},
{0.50319929300549,0.8028988719278775,0.31959955096294634},
{-0.7278152515283953,-0.47250990154873146,-0.4970104149623694},
{-0.4699987850547109,0.07589980379926076,0.8793977267598144},
{-0.03380098463702392,0.9447275203135059,0.3261094997080918},
{0.13849844190129287,0.9299895376765513,0.34049616943964056},
{0.26650416416009776,0.8725136331320275,-0.40950639858746724},
{0.2665970594506513,0.8724903764842208,-0.4094954832897288},
{0.266491822823873,0.8725732255013569,-0.40938743813918804},
{0.2666079756968912,0.8725261020087682,-0.4094122477505899},
{-0.11079685950752526,-0.01189966270884071,-0.9937718319366301},
{-0.24159984296015313,0.3064998007751943,-0.9206994015455835},
{0.2645016372702021,0.03040018817774723,-0.9639059665963998},
{0.06759868555633891,-0.39269236417121733,-0.9171821655661843},
{0.32369613832810445,-0.2740967300455157,-0.9055891963853303},
{0.389189357762516,-0.20579437262981964,-0.8978754479315599},
{0.4643032640634196,-0.11010077401116197,-0.8788061780291475},
{0.4852166335113,0.03140107644735123,-0.8738299554043156},
{0.3258120715608811,0.3849142613375787,-0.8635319944531027},
{-0.1491045246454516,0.6341192426403813,-0.7587230237994911},
{-0.6198978086651196,0.41089854747620197,-0.6684976368650305},
{-0.6152655614740178,-0.036897934695906486,-0.787455923388248},
{-0.3393923332137881,-0.31289293182850414,-0.887079961090016},
{-0.2473969063210296,-0.5064936663363034,-0.8259896710637447},
{-0.19049796263518437,-0.47649490391425375,-0.8582908206287597},
{-0.05889916187088983,-0.5577920626754218,-0.8278882192344599},
{0.09090281394015894,-0.5762178370992254,-0.8122251428184499},
{0.220396702889987,-0.5123923346680097,-0.8299875834786261},
{0.29279352933450176,-0.38559147852248593,-0.8749806631410144},
{-0.10979889433070111,0.8086918565140072,-0.5778941806349014},
{0.012099724794889272,0.7811822322121901,-0.6241858030553623},
{-0.24050359555563053,0.7891117973095554,-0.5652084499294902},
{-0.3583034648112572,0.7271070311589871,-0.5856056628341395},
{-0.4441930950720053,0.6483899208570199,-0.6182903887506097},
{-0.5151103898813469,0.617812461403021,-0.5941119833595577},
{-0.6372108677240244,0.5678096840767436,-0.5211088875878674},
{-0.7331920522412304,0.46499495948195874,-0.49619462127945785},
{-0.7753568564680493,0.33368143281324225,-0.5361701656411763},
{-0.7585948188150812,0.20969856776367324,-0.6168957866161661},
{-0.7651818768818665,0.13829672448087052,-0.6287851074010946},
{-0.795558134854701,0.0114993948602678,-0.6057681222913246},
{-0.7833998550710402,-0.11909997796650611,-0.6099998871500313},
{-0.7277053814011933,-0.23160171270099816,-0.6456047742649585},
{-0.6384878113840199,-0.30829411472152446,-0.7051865381174799},
{-0.5632968314642345,-0.3593979783920573,-0.7439958150353106},
{-0.487286283084194,-0.43898764267178575,-0.7548787504622575},
{-0.38240834424110803,-0.5034109845475255,-0.774816906689358},
{0.10729859761649366,0.7137906708168981,-0.692090954430338},
{0.16850045326682894,0.6211016707657415,-0.7654020589343078},
{0.223392729801911,0.6012804316467729,-0.7671750326948349},
{0.3807060399492361,0.5633089369671781,-0.7333116340813628},
{0.4945862358565814,0.4724868508739076,-0.729479698862467},
{0.5484280007063823,0.3458176561711652,-0.7613388711483751},
{0.5293011935755373,0.21400048257163232,-0.8210018513612622},
{0.45341606708301074,0.1021036181058125,-0.8854313758167129},
{0.17160332055637945,0.03570069081505097,0.9845190506279462},
{0.1715974174783003,-0.5494917302116901,0.8176876938928097},
{0.5925216126199877,-0.01420051797333979,0.805429378572385},
{0.4214829366087101,-0.6115752408775496,0.6695728928901359},
{0.6832378216764573,-0.39562190025644983,0.6137339741844875},
{-0.7555051638954429,0.5412036991399255,0.3692025235078723},
{0.8917019840391217,-0.06790015107800422,0.4475009956908231},
{0.8694932397163417,-0.32369748326185144,0.37309709918133077},
{0.4631946223416517,0.43829491142561733,0.7702910569727424},
{-0.9538840225764317,0.020199661658500807,0.2994949835010392},
{-0.8975699767864064,-0.1682943706474512,0.407486369808891},
{-0.8353797589936566,-0.3422917063724307,0.43008957905574774},
{-0.7607238338510778,-0.5106159978498229,0.4007125545210028},
{-0.6749640118783043,-0.6329662511392098,0.37917978267296737},
{0.5001892610518466,0.3162932092576951,0.806082693590351},
{0.8089169833903512,0.5122107539776708,0.2886060593478247},
{-0.477195397472587,0.8447918520218807,0.24209766497928187},
{-0.31140949502025694,0.9205280673286658,0.23590719291996984},
{-0.7504114025878941,0.5796088072227391,0.31770482756153245},
{-0.6462175062693705,0.6363172380674721,0.42131141348078893},
{-0.7921566504134268,0.19308943346987212,0.5789683168257688},
{-0.9865767713233756,-0.11769722885136967,0.11319733480012784},
{-0.9708347128157462,0.11270402980462978,-0.2116075661637947},
{-0.737594169341137,0.6617947685330321,-0.13409893995206948},
{-0.23620610600676142,0.9545246747817687,0.18190470229733235},
{-0.021500884887126665,0.9970410340681529,0.07380303742650922},
{0.3502940555603153,0.9031846730861455,-0.24809578985016906},
{0.4631965793058927,0.8656936068763197,-0.18979859834252683},
{-0.05380031527077123,0.7810045767002293,-0.6222036461240494},
{-0.7894053363981112,0.10740072603136196,0.6044040857854299},
{-0.8018232010899902,-0.2775080298110156,0.5292153130666286},
{-0.6607036404870886,-0.45200249054058433,0.5993033021702925},
{-0.5191106159206444,-0.6455132008799382,0.5602114564414276},
{-0.6426036339338249,-0.7432042028316506,0.18630105353543663},
{-0.3016892268700593,-0.805671229994056,0.5097817960170905},
{-0.06089897599232796,-0.8958849358214551,0.4400925999051483},
{-0.28628880775783677,-0.9498628658371259,-0.12569508604666463},
{-0.8020647339889526,-0.5672750574640728,-0.186791786945688},
{-0.8265390548930374,-0.19900940341647239,-0.526524878888305},
{-0.6647038220579653,0.4825027743989292,-0.5704032798282885},
{-0.2602939170022386,0.9290782876941218,-0.2627938585792866},
{-0.0706986729983616,0.7043867787842422,-0.7062867431222462},
{0.4780922286739838,0.5530910095787084,-0.6822889094839137},
{0.8219225661938365,0.524214392503722,-0.2228061172259238},
{0.8511404726917375,0.46372205050776494,-0.24601169813437604},
{0.31628675735069883,0.5441772157769532,-0.7770674648663548},
{0.4736999360505129,-0.8766998816455239,0.08369998870050228},
{0.15870131801991927,-0.98530818301844,0.06310052405202839},
{0.7317876438699491,-0.6786885404407412,0.06219894977959939},
{0.9159725166569506,-0.37598871862774386,-0.1400957964886886},
{0.964449472704586,-0.1854095108247929,-0.18830965959173948},
{0.5899783068964758,-0.7084739498917849,-0.38728575976441537},
{0.2600086948361354,-0.9644322511537269,-0.04760159182384633},
{0.1482917366732044,-0.6515636926248145,-0.7439585440651657},
{-0.18789815297023443,-0.8138919994809675,-0.5497945955456885},
{-0.5017890385381784,-0.527688472771217,-0.6853850279275955},
{-0.12859910238139804,-0.14119901443431887,-0.9815931485037351},
{-0.5710859885771532,-0.04809881990993008,-0.8194798943074366},
{-0.4454854840919974,0.3135897818434352,-0.8385726755545433},
{0.9526079209677943,0.16100133873169736,-0.2581021461282676},
{0.5847848747348199,-0.16379576347736577,-0.7944794510547443},
{0.866216003488498,0.19650363043810884,-0.45940848765021475},
{0.45400246070000555,0.13700074254603692,-0.8804047718067948},
{0.7612785703098646,-0.22809357925611468,-0.606982913671467},
{0.40801305254632975,-0.3089098821851992,-0.8591274839278233},
{0.03409899051432851,0.2985911603395453,-0.9537717640048838},
{-0.9530028399526945,0.2902008647998657,-0.0870002592611589},
{-0.3372992528829823,-0.9334979323043698,-0.12169973043539563},
{0.08519855078497661,-0.9962830533693919,-0.01269978397851177},
{0.22200858190760367,-0.9738376444217317,0.04850187487621071},
{0.05629786466248927,-0.9898624552290963,0.130395054209389},
{0.36319264723928424,0.3543928253898742,0.8616825554132468},
{-0.12919596850270335,-0.9768695172623133,0.17039468291687807},
{-0.2544955781777434,-0.9410836488136515,0.2226961306883436},
{-0.3946032041910271,-0.8608069897811357,0.3214026097997874},
{-0.5387308971029486,-0.7556433373881345,0.37252136471291697},
{-0.9632863069824686,0.11729833261605271,0.24149656715069673},
{-0.9145825956588052,0.3046942017245112,0.2658949400674353},
{-0.8446819789022181,0.4772898171303761,0.24229483069493007},
{-0.760580586428294,0.6261840168569519,0.17149562263009785},
{-0.6663947321704633,0.7433941234926806,0.057299547048870865},
{-0.5673231784619438,0.8224336012111803,0.041801707843661634},
{-0.3814028738814821,0.9244069654327269,-0.0019000143166618144},
{-0.23019264661335403,0.9678690819160094,-0.10119676732090108},
{-0.08929862213289065,0.9685850548479047,-0.23209641877988713},
{0.030199695890593563,0.9502904306235451,-0.30989687935413723},
{0.20390862755655173,0.922439029221007,-0.32791387432954056},
{0.378494623522059,0.8549878549837792,-0.3545949630143253},
{0.5228708638328967,0.7499582097431107,-0.40517742211721125},
{0.6303803545023732,0.6123809154461507,-0.4770851318735442},
{0.21460371160328856,0.21600373581691673,0.9525164739148758},
{0.7118903361542797,0.4976932438600716,-0.4954932737244635},
{0.8134814935065316,0.3400922629890245,-0.4717892669162651},
{0.8687860126577934,0.16299737576337514,-0.467592471821805},
{0.8788032999125869,-0.019100071720903968,-0.47680179039408443},
{0.3634012337492829,0.20230068681199762,0.9094030874287228},
{0.8786650605785353,-0.16779332783097556,-0.44698222610516136},
{0.8581271429908061,-0.34171080848381125,-0.38321212119109294},
{0.7881103164315636,-0.5111066904303669,-0.3430044899581606},
{0.34660531003402495,0.19360296602015933,0.917814061019123},
{0.7177098936990775,-0.6333087302210195,-0.28950399084002076},
{0.6188246792203208,-0.7606303345426244,-0.19620782492409009},
{0.4800915648653073,-0.8671847636975515,-0.13229767555026067},
{0.361189522043946,-0.930273013171326,-0.06429813473816647},
{-0.048298838426903586,0.7614816865856537,0.6463844546407965},
{0.4133243579221397,0.8133479320059913,0.4094241280748221},
{0.9439210591137459,0.20960467633249408,0.25510569147146583},
{0.3871116232009825,-0.6845205530381621,-0.6177185472778272},
{-0.2788064558382282,0.5320123188878674,0.7995185130655075},
{-0.3844971739561571,0.16259880490317594,0.9086933211286344},
{-0.9588600978672736,-0.28088831107614676,0.04109828973025857},
{-0.21980828692862875,-0.30501149915028103,0.926634934795575},
{-0.7052876928371391,-0.7083876387435549,0.027499520137560362},
{0.4285100486784636,0.15740369115983707,0.8897208641989011},
{0.4285033016306586,0.15750121355152563,0.8897068552177292},
{0.42842165726217574,0.15750796222874108,0.8897449777454663},
{0.42838353967872567,0.1574939484112962,0.8897658114055325},
{0.42859168325907865,0.15739694574190152,0.8896827358740138},
{0.42847192529686223,0.15738968737859071,0.8897417015849429},
{0.047901237544458145,-0.18040466081461898,0.9824253812875925},
{0.5230744170558773,-0.30858490748125356,0.7944611438556577},
{0.3527103098730386,0.16800491085531752,0.9205269073947604},
{-0.07500175956191922,0.3378079250668842,0.9382220109465682},
{0.4973819801772814,0.4320843458677187,0.7522727456521286},
{0.795549619437851,-0.005699639053287771,0.6058616319977299},
{0.8271325648501299,-0.21580849654776693,0.5189204302995193},
{0.7827842466255535,-0.22449548207388445,0.5803883198025949},
{0.7407994962565138,-0.344599765672239,0.5765996079123998},
{0.6679223022980169,-0.4515150763401027,0.5916197545134103},
{0.5698805474595131,-0.5274819947094107,0.6300784926377245},
{0.4601035957236509,-0.5580043608211198,0.6906053971022675},
{0.35449289957833147,-0.5389892041543601,0.7640846955368211},
{0.2619972909620171,-0.4621952209261233,0.847191240087866},
{0.2172953999050755,-0.4287909225922521,0.8768814366164782},
{0.08529667818555084,-0.44358272500715534,0.8921652553006852},
{-0.04529977486067841,-0.4138979429323354,0.9091954813096867},
{-0.15099822351635045,-0.33569605055919766,0.929789061096044},
{-0.21069614534928094,-0.21909599167549812,0.9526825708317985},
{-0.21790024622741738,-0.08570009684116416,0.9722010985878621},
{-0.2014019898614898,0.024200239099543462,0.9792096746393785},
{-0.24429363623366307,0.10149735602831275,0.9643748783616237},
{-0.3139904783831123,0.21879336519179926,0.9238719840068709},
{-0.3255945170344993,0.349394116252623,0.878585204749727},
{-0.26880515438825353,0.46860898566345094,0.8415161362266197},
{-0.15819895114443086,0.5528963343094552,0.8180945760509412},
{-0.020099981307026078,0.592799448696769,0.8050992512580445},
{0.2939089966920852,0.6731206045370621,0.6786207728997925},
{0.7661310365969515,0.39761610775479433,0.5049204547419408},
{0.8993997256831254,0.21249993518752963,0.3819998834900533},
{0.9079342570057874,0.1322049881883083,0.3977150060702739},
{0.9215085746771812,0.006500060483344197,0.388303613181931},
{0.9017302129769372,-0.11430382981397796,0.4169139689365478},
{0.2404021431946599,0.8365074574972255,0.49240438980470275},
{0.1216074590222557,0.8121498147366272,0.5706350009712098},
{0.37960256422398203,0.7988053959486745,0.4667031525904437},
{0.5040869090329565,0.712781489305081,0.48768733492436595},
{0.580697868842732,0.6372976611218756,0.5065981407882351},
{0.650283908923758,0.6117848615708983,0.45038885526566297},
{0.7460604822228571,0.5596703550464189,0.36078088994237617},
{0.8299915258297816,0.46309527182141197,0.3108968257596134},
{0.8849099066218572,0.33880379292969287,0.31960357798208333},
{0.04859999854200006,0.7340999779770009,0.6772999796810009},
{0.022198768668452,0.6250653285878083,0.7802567203600492},
{-0.007000448673133652,0.6991448096268196,0.7149458223461783},
{-0.006599974755144841,0.2527990330455479,0.9674962993337325},
{0.014400092088883364,0.32760209502209653,0.9447060414144524},
{0.03740123500917034,0.7924261663440261,0.6088201035717353},
{-0.012300148894203552,0.9315112760122446,0.36350440024739766},
{0.028799404146492246,0.9936794409850468,0.10849775520466697},
{-0.02330016904333962,0.9918071955873061,-0.12560091123791656},
{0.0044002835414052805,0.9091585835208046,-0.41642683332753605},
{-0.6537073411746623,0.558706274306691,-0.5104057318885539},
{-0.0012000353655633423,0.6271184814539766,-0.7789229551977396},
{-0.01649926002478146,0.2712878330135279,-0.9623568392636168},
{-0.6570895884979547,0.20219679621714567,-0.7261884936344767},
{0.0014999733757088695,-0.7348869558722988,-0.6781879622705036},
{0.003600064135713872,-0.7210128449582505,-0.6929123443433727},
{0.0016999738716023884,-0.7222888985049443,0.6915893703530658},
{-0.004899899112115911,-0.7293849821178258,0.6840859148160194},
{-0.9994318324108015,-0.012500398144021433,-0.03130099695262967},
{-0.9999871102492226,-0.0026999651976729014,-0.004299944574071657},
{-0.9994457956555595,-0.0024001099755586778,0.03320152132856171},
{-0.9999893751693331,0.004599951125778932,0.0002999968125507999},
{-0.7082025318285771,0.0031000110825594304,0.7060025239635348},
{0.999607991897843,-0.0047000375769506424,-0.027600220664646322},
{0.9999920700943261,-0.002499980175235815,-0.0030999754172924107},
{0.7079041235535295,0.002500014562627241,-0.7063041142334482},
{0.00019999998700000128,-0.0002999999805000019,-0.9999999350000064},
{0.14629606907743511,0.01819951098570963,-0.9890734239541427},
{-9.999999500000038e-05,-0.00029999998500000106,-0.9999999500000037},
{0.990847655964048,0.00460022125296187,-0.13490648848359918},
{0.6278994882621257,0.6378994801121357,0.44589963659194437},
{0.6362917855260729,-0.03419955848654989,0.7706900504556725},
{0.6321967694827618,-0.6486966851684082,0.4236978349095954},
{0.6325898027345693,0.29479524793890455,-0.7161884551351542},
{0.6309995772304248,-0.7344995078854946,-0.2496998327011681},
{0.6406038692590555,-0.30660185188077804,-0.704004252198525},
{0.635399091379949,0.7342989499532524,-0.2388996583737328},
{-0.06449801671647848,0.08979723877736073,-0.9938694389846195},
{-0.06329967147555755,-0.7917958905899917,-0.6074968470995453},
{-0.043898204819620104,-0.941661491540689,0.3336863541755633},
{-0.031899102052915636,-0.36368976227728583,0.9309737934565662},
{-0.019699663237135418,0.37729355022188804,0.9258841721453647},
{-0.0372008418645772,0.9287210171944313,0.3689083484903906},
{-0.041101066586517056,0.8660224735747877,-0.4983129313883565},
{0.9999997400001014,-0.0005999998440000607,-0.00039999989600004055},
{0.9999989900015303,-0.0010999988890016833,-0.0008999990910013772},
{0.9999240684619952,-0.009700233487430097,0.007600182938605024},
{0.9999859352967293,-0.005299925457072666,-0.00019999718705934587},
{0.9999906151321153,-0.004099961522041673,0.0013999868611849614},
{0.9999874202373796,-0.004999937101186899,-0.0003999949680949519},
{0.9999975950086759,-0.0015999961520138815,0.0014999963925130138},
{0.999999035001397,-0.0011999988420016761,0.0006999993245009778},
{-0.9999914151105517,-0.0038999665189311515,0.0013999879811547723},
{-0.9998408443327537,-0.009500388098780916,0.01510061687279914},
{0.9999951950346317,0.0030999851046073583,0.0},
{0.0,-0.00029999998650000095,0.9999999550000032},
{-0.9876711159805636,0.01719949700806489,0.15559544967761027},
{-0.146304027805329,0.02050056438830652,0.9890272282943976},
{0.9958814220053572,-0.014499729510068964,0.08949833042421877},
{0.9964119071934368,-0.06950083053988747,0.04830057719534625},
{0.9950695364124569,0.015899513243852945,0.09789700292913228},
{0.9836130919773819,0.11590154265979927,0.1381018381476987},
{0.9967260049207071,-0.06770176636212688,0.04420115322313159},
{-0.002099958389736757,-0.9928803262712506,-0.1190976401036418},
{-0.9929185627860486,-0.0908016975536038,0.07660143207715915},
{-0.9930578406242956,-0.08969619202899941,0.07609676938023249},
{-0.9941680081882365,-0.017599433659337117,0.1063965762132653},
{0.0016000489542466443,-0.9923303608118407,0.12360378171555328},
{0.9973778335239721,-0.05949867765658346,-0.041199084360525016},
{0.9987974580637038,-0.03739990481736336,-0.03169991932380798},
{0.99632095284996,-0.01840038696420683,-0.08370176026652781},
{-0.9862538000228316,0.10619502541054925,-0.1265940698396943},
{-0.9965521367502801,-0.013299361247018587,-0.08189606662637762},
{-0.9953550856151197,0.01219944951226086,-0.09549569085417313},
{-0.993334265656501,-0.0806027804408678,-0.08240284253508073},
{-0.9926833329867575,-0.08299860646509608,-0.08769852755408344},
{-0.05619794291194888,0.6485762593005345,0.7590722146701138},
{-0.003399918589924034,-0.32069232111430523,0.9471773201106016},
{0.0587019691905853,0.5329178770300325,0.8441283167593364},
{0.01810009728828439,0.9740052352922096,-0.22580121368478534},
{0.03979969155358569,0.9538926073609394,-0.29749769440180257},
{0.003600156232169616,0.22110959525908394,-0.9752423215588361},
{-0.0036000336244710793,0.16900157848211458,-0.9856092056329712},
{0.05049771629241984,-0.801563750099084,-0.5957730567727474},
{-0.03280002410802658,-0.7170005269955809,-0.6963005117810642},
{-0.004300106063424098,-0.9773241059963652,0.2117052217736934},
{0.11429487798981176,-0.745466592663208,0.6566705719677111},
{0.9994598874823577,0.031898719770572494,-0.00789968295258692},
{0.9992020733464532,0.023900049592654356,0.03200006640020667},
{0.9903880906548144,0.1257984872822856,0.05749930857497156},
{0.9945602581661097,-0.1025959003497314,0.01799928076311077},
{0.997871206841734,-0.04729863521757092,0.044898704466573666},
{0.998719350374872,-0.03800073627139795,-0.03340064714380767},
{0.991852536032555,0.06269699970686682,-0.11089469326142791},
{0.9992826825811648,0.00759986829542365,-0.03709935707371282},
{0.971810223497327,0.12860135289334867,-0.19760207878480326},
{-0.07910197836521868,0.7106177727727483,0.699117485146958},
{-0.08250268055563759,-0.5059164374920855,0.858627897273581},
{0.046998248642895875,0.2802895552043343,0.9587642723150758},
{0.06269958963252878,0.9715936409404299,0.22819850644566292},
{-0.06269958963252878,0.9715936409404299,-0.22819850644566292},
{0.07910197836521868,0.7106177727727483,-0.699117485146958},
{-0.046998248642895875,0.2802895552043343,-0.9587642723150758},
{0.08250268055563759,-0.5059164374920855,-0.858627897273581},
{-0.05699837870417631,-0.8869747703614804,-0.45828696421270176},
{0.05699837870417631,-0.8869747703614804,0.45828696421270176},
{0.9925992208099175,0.10199991993009427,-0.06589994826856091},
{0.9996299093743394,0.008000239370743012,0.02600077795491479},
{0.9885683762034598,0.04809846135483149,0.14289542884834555},
{0.9963072033271202,-0.02790020171918765,-0.08120058708236691},
{0.9958759946984681,-0.08879785955339288,-0.01859955166321067},
{0.9991909223917049,-0.033199698382110295,0.022699793773310353},
{0.9995795188254867,0.027899428346569704,0.007899838133974935},
{0.9995460051636058,0.020900961988913818,-0.021700998811455974},
{0.9992040118121611,-0.01780007146743041,-0.035700143336363246},
{-0.45060764687665184,-0.891315125746027,-0.05010085021864238},
{-0.38690720621382424,-0.9215171634170044,-0.03330062022982773},
{-0.3027073362011904,-0.9518230677115724,-0.049001187558170886},
{-0.4762928127956819,-0.8792867316633279,0.0},
{0.023000091425545127,-0.07110028262418515,0.9972039638936347},
{0.09220083073322738,-0.0917008262281665,0.991508933535737},
{0.16059411112191577,-0.14929452547012467,0.9756642230488993},
{0.023500735937068983,-0.013600425904005878,0.9996313039444321},
{0.5465971631680846,0.8358956617127734,0.05009973998302423},
{0.6046137974442883,0.7958181607776458,0.03340076221409068},
{0.6729043671635144,0.7381047903156337,0.04900031801309586},
{0.523277046955742,0.8521626207064461,0.0},
{0.07300060846260731,0.015700130861136093,-0.997208311765918},
{0.1255997732926138,-0.03399993863016616,-0.9914982103473455},
{0.2095913126201341,-0.06449732664121494,-0.9756595597493553},
{0.023500735937068983,-0.013600425904005878,-0.9996313039444321},
{-0.3386096894548976,-0.9409269250091942,0.0},
{-0.21071078550759137,-0.9767499962281182,-0.03950202196274257},
{0.1534952532326895,-0.0885972601720931,0.9841695650267949},
{0.24511234294280113,-0.18720942716806355,0.9512479012941348},
{0.6455880405923209,0.7636858528506126,0.0},
{0.7404972934873384,0.6708975478739437,0.03949985562829151},
{0.1534952532326895,-0.0885972601720931,-0.9841695650267949},
{0.28471064553005826,-0.11870443844193157,-0.951235567362808},
{0.7527239595849564,-0.6384203212422428,0.1607051153252325},
{0.7527118590687601,-0.6384100582297016,-0.16080253346387222},
{0.7285697795523033,-0.6849715879677845,-0.0},
{0.8429946470009873,-0.48669690948443717,0.2290985452288567},
{0.8429946470009873,-0.48669690948443717,-0.2290985452288567},
{0.9292192489761159,-0.3327068920946553,-0.1608033310755052},
{0.9574815686572035,-0.2884944465353558,-0.0},
{0.9292341871546298,-0.33271224070850763,0.16070591247928218},
{0.7071005444676288,0.0042000032340037356,0.7071005444676288},
{0.7064290489597521,0.01480060861353954,-0.7076290983067959},
{0.7126829136319661,0.0020999496543105496,-0.7014831821423099},
{0.4995063587564207,-0.2570032716724727,0.8273105317301038},
{0.4743967503933897,-0.005499962325387106,-0.8802939700069581},
{0.012500001125000153,-0.00660000059400008,-0.9999000899910121},
{-0.014099936127434013,-0.0031999855040984997,-0.9998954704837781},
{0.9911659193457849,0.010699632099475281,0.13219545453744228},
{0.5763367311103478,0.6541416897783767,-0.4898312179383105},
{0.7062967157279079,-0.33599843761089765,-0.6230971026052093},
{0.04919730701311914,0.8971508913042783,-0.43897597111299397},
{0.4940835621133281,-0.6216793170731757,-0.6077797795030982},
{0.7052841418643533,-0.33979235985468204,0.6221860103048357},
{0.5618985559225669,0.690698224907843,0.4551988301405098},
{0.011100403451495301,0.7877286305173737,0.615922386105942},
{0.0,-0.0034999785626969554,0.999993875056273},
{-0.017699795214554042,0.9967884672241508,-0.07809909639868196},
{0.019500776633894473,0.9969397039143283,0.07570301493260573},
{0.0020000660332701505,0.011400376389639859,-0.9999330133334118},
{0.014799298973811024,0.008699587910280804,-0.9998526381022731},
{-0.013399971592090337,0.926198036462244,-0.3767992011865402},
{-0.8442293881365105,-0.1357047239636632,-0.5185180499274825},
{0.1261922747454029,0.5427667728352193,-0.8303491675798935},
{0.052499053450599346,0.9858822247037313,-0.15899713330752946},
{0.002100060503614676,0.6106175921462482,0.7919228156249819},
{0.06530328940953342,0.8886447621640335,0.4539228646705547},
{0.053297971251335736,0.05679783803144221,0.9969620513617585},
{-0.02749960813337613,-0.5324924120371923,0.8459879447576802},
{0.03340201871200313,-0.7119430275770967,0.7014423929520658},
{-0.854725445555277,-0.5161153649831267,-0.05540164933165127},
{0.8581267310640155,-0.42001308361133494,-0.2953091990248267},
{-0.5827092855464484,0.7600121108894814,-0.287804586202622},
{0.22770056242108377,0.7411018305237821,-0.63160156005778},
{0.5720831523992391,0.5992823513946234,0.5599835087284984},
{0.6364627234698976,0.7291572945078544,-0.251485270939009},
{-0.0116004387368897,0.7664289868924368,-0.6422242893819453},
{-0.040699947293602386,-0.43169944094958596,0.9010988330777668},
{-0.5960127160669474,0.5218111329592838,0.6103130211672113},
{-0.024799227640082543,-0.4789850822419168,0.8774726715392108},
{0.0,-0.8130640430377772,0.5821742539129184},
{-0.03309848313127634,-0.8161625961253097,0.5768735624904326},
{-0.9672345453986944,0.12530447532925598,-0.22080788629449102},
{0.9858479281620697,0.13280645654283105,-0.10230497367719592},
{0.23490981238779943,0.7702321732698303,-0.5929247669847862},
{0.0,0.792400887489491,-0.6100006832011478},
{0.960297186333366,-0.2683992135914563,0.07609977702797996},
{-0.009600356659874994,-0.817730379247894,0.5755213810164646},
{-0.9990846891444574,-0.04099937168944325,0.012199813039297748},
{-0.9793717308429778,-0.1935944119779462,0.05789832878885891},
{-0.9608738357616735,-0.26539277345316703,0.0792978407491942},
{0.9816168348730784,0.09330160013616362,-0.1665028555484592},
{0.967146767512692,0.12420600612664291,-0.22181072591698386},
{0.40679889350851456,0.547598510534077,0.7311980111441146},
{0.8840389648760844,-0.22731001890988006,0.40841800142012763},
{-0.10669706907176833,0.9013752395622491,0.4196884713160372},
{0.083497083080353,0.9908653847224167,-0.10589630057735787},
{-0.03870036630070056,0.5943056251293629,-0.8033076033424486},
{-0.8431557049217793,-0.03490230589701115,0.536535447385286},
{-0.24489658861428076,-0.9400869046806262,0.23719669587303957},
{-0.04290086424661546,-0.6757136123878337,-0.7359148251534806},
{-0.05389993478111838,-0.560499321796231,-0.826399000057815},
{-0.03200032480494517,0.17910181789267748,-0.9833099806469556},
{-0.5816090266421409,0.7524116775198534,0.30920479889571856},
{0.02649991665789317,0.7839975343316319,0.6201980494802016},
{0.0,0.7876801113282803,0.6160844440641786},
{0.5720831523992391,0.5992823513946234,-0.5599835087284984},
{0.5899023566646223,-0.34300137029321154,-0.7310029203625003},
{-0.001799913957169867,-0.8150610369384215,-0.5793723037690116},
{-0.8007119387040098,-0.5235078055595718,-0.29120434188910665},
{0.6363872214728878,0.7291853581050123,0.251594948024165},
{0.9321767051952021,0.21329466983280046,0.292492690698988},
{-0.5703067239559134,0.4797056557630224,-0.6668078617110346},
{-0.5820937192426539,-0.3248964943857383,-0.7453919572641715},
{-0.9299726034106494,-0.34138994280042545,-0.13639598183356189},
{-0.9672252981085123,0.1252032747344766,0.22090577786618115},
{0.9785515580041518,-0.19869016408688428,-0.05439730712796429},
{0.9922433173275476,-0.11990523457727571,-0.03280143197777017},
{0.9598999184085104,-0.27039997701600293,-0.0739999937100008},
{-0.9608738357616735,-0.26539277345316703,-0.0792978407491942},
{0.9671373177133697,0.12410478867565836,0.2219085625070797},
{0.06230044825333778,0.1296009324820638,-0.9896071202488455},
{-0.6116760288861327,-0.03179875383125555,-0.7904690221260223},
{-0.9601283194024274,-0.00920027136600597,0.2794082412676161},
{-0.7059886407341552,-0.12729795179243336,-0.6966887903675438},
{-0.0808007886195454,-0.16600162018371953,0.982809592268431},
{0.4072934467011635,0.1891969558454705,0.8934856239319655},
{-0.28808490762702377,-0.022098842271979263,0.9573498457553369},
{0.9904484291599446,-0.01260061612218831,-0.13730671377590914},
{0.8162586738694864,0.5773707684579706,-0.019099033040435122},
{0.9446062863757537,-0.04430029481944303,0.3252021642276044},
{0.5770153920908787,-0.028900770938347305,-0.8162217730061962},
{0.7020796891283859,0.005199849570527855,-0.7120793998409396},
{0.575409491457843,0.020300334856785215,0.8176134866456942},
{0.7113926406811981,-0.0016999824137728938,0.7027927296468175},
{0.5734856114265117,0.007699806814270515,-0.8191794470455073},
{0.646588755919301,0.038099337458282354,-0.7618867509046017},
{0.717165368920482,0.04149799611015059,0.6956664070802836},
{0.46980332621932447,0.23540166664969983,-0.850806023727972},
{0.4361930776707856,0.2398961928776283,0.8672862362766446},
{-0.6201211247859298,0.04650158410344418,0.7831266776646697},
{-0.5525142688652426,0.1927049766702846,0.810920942303756},
{-0.7417902492312604,-0.5782923983963844,0.33959553604601783},
{-0.7015844916462164,0.0016999624227459632,-0.7125842484992785},
{-0.8050978020860003,0.00719998034408049,-0.5930983808436303},
{-0.8062194623727355,0.030800743538923654,0.5908142624284446},
{-0.7104979999509453,-0.0012999963405154523,0.7036980190928644},
{-0.829078618338146,0.01659957190256088,-0.5588855865265828},
{-0.802686157796562,0.15319735813433827,-0.576390060239116},
{-0.44872902248807445,0.5786374245856917,-0.6810440479482476},
{-0.9329607931464846,0.3335859813436948,0.135294314375905},
{0.6972914198818673,0.041399490582402554,-0.7155911947045235},
{0.21069275861432749,-0.1427950922170193,-0.9670667624865501},
{0.7627050758191695,-0.6108040649145781,-0.21260141486712392},
{0.8839213292790163,0.0742017905108078,0.4617111412242582},
{0.35080603216158496,-0.6176106199059147,0.70391210387269},
{-0.34859194587613473,0.057998659956442385,0.9354783860215836},
{-0.5997205977576511,-0.1441049493694806,0.7871270343422497},
{-0.8944294585193324,-0.04810158425176642,-0.4446146436244356},
{0.8568857629613217,-0.10309828703619123,-0.5050916079726497},
{-0.39680322205524465,-0.12460101176432331,-0.9094073844179423},
{-0.9433121216386451,-0.1521019545226735,0.2950037908230682},
{-0.3298877267554349,-0.7085736380081877,-0.6237767928161269},
{0.5768914937976354,-0.7051896020559759,-0.4121939222454244},
{-0.16880276079172932,-0.46640762815913833,-0.8683142013948967},
{0.9141205222360889,-0.4027090409194541,-0.047001055185533505},
{0.27430006446052274,-0.7248001703280601,0.6320001485200524},
{0.1844911031310721,-0.5323743268671153,0.8261601593869472},
{-0.8529998379300462,-0.38229992736302065,0.3552999324930192},
{-0.6857179214720696,-0.7118186036223116,0.1520039726757395},
{0.9450565491504782,0.06770405119310834,-0.31981913695060626},
{0.02050114696875165,0.9295520052416907,-0.368120595082804},
{-0.4066859228104187,0.4402847598068044,-0.8004722921311536},
{-0.1763984468185136,-0.21029814833295585,-0.9615915332238247},
{0.9962768816631884,-0.03059928995171491,-0.08059812974209876},
{-0.8134134173649801,-0.5712094221771289,-0.10990181284535444},
{-0.21259634762612145,0.15859727532221476,-0.9641834354708667},
{0.9694401695856575,0.16460682062492182,0.1819075374949774},
{0.6336957257367448,-0.28239809523127146,-0.7201951423001476},
{0.11270530910863129,0.9113429298198377,0.39591865018728595},
{-0.6664838113048327,0.3491915182410317,0.6586840007599299},
{-0.9765306879590612,0.20970659013314402,-0.04910154304023544},
{-0.13830395347501592,-0.25750736095312077,0.9563273370076482},
{-0.2808984297821662,0.6085965979545261,0.7420958516957835},
{-0.8222277917690506,0.4130139601077814,-0.39161323675110704},
{-0.6778988306255258,0.42479926722189615,0.5999989650026781},
{-0.7929145183977491,-0.0796014575160308,0.6041110613748015},
{-0.20520462741652296,-0.15150341644056153,-0.9669218043325344},
{0.9499968840153306,0.09199969824148466,0.2983990212528154},
{0.4222076378052525,-0.12870232824617717,0.897316232597473},
{0.5597774862022483,0.822166933110912,0.10339584150288045},
{0.03140165616702052,0.9930523749634198,-0.11340598118917604},
{0.5691274012983691,0.5123246664648646,0.6431309642856812},
{0.8828231611694539,-0.14880390392162973,0.44551168815246},
{0.46178028932901594,0.10579548421613229,-0.880662409727294},
{0.0,-0.999999995,-9.999999950000001e-05},
{0.7439055532756828,-0.015500115708795649,0.6681049874223467},
{0.30750967594418277,-0.02810088420823264,-0.9511299277740235},
{0.24639213036103236,0.03939874162428845,-0.9683690707858107},
{-0.9683690707858107,-0.03939874162428845,0.24639213036103236},
{-0.9511299277740235,0.02810088420823264,0.30750967594418277},
{0.6681049874223467,0.01550011570879565,0.7439055532756829},
{0.929165937401091,0.03719863632298814,0.36778651719341504},
{0.9177213235026803,0.29300680809227997,0.26820623184419623},
{-0.6250053250680544,-0.10140086393904116,0.7740065945642787},
{0.917022884591631,-0.24780618408048652,0.31250779872942713},
{-0.6368007577933528,-0.6733008012284303,0.375700447083798},
{0.9030893300625976,-0.39889528708002453,0.1590981202668135},
{0.8790180376352003,-0.47400972677939124,-0.051401054760465636},
{-0.6332880341356415,-0.7226863449705165,-0.276894768122784},
{0.9087986322590876,-0.41309937828590354,-0.05859991180719909},
{-0.6430709306356059,-0.30518620436944016,-0.7023682501608609},
{0.8813140174109212,-0.18430293136143513,-0.4351069204306046},
{0.8979815017715933,0.014599699249293165,-0.43979094039994066},
{-0.6205175422788839,0.3564100758552686,-0.6985197474323939},
{0.8822357974437366,0.23490953164762382,-0.40801655560762246},
{0.8972620869915042,0.4070827990797296,-0.17089277907817682},
{-0.635086898292431,0.5541885672077866,0.5380888993405089},
{0.8864209463744471,0.272306434677078,0.3743088450225131},
{-0.6296797718622381,0.770975232818462,-0.09539693542267351},
{0.9130807113737062,0.3989915713920806,-0.08419822133136136},
{0.651329326763171,0.3745168630013935,-0.6599297140043247},
{0.8638047768536241,0.2523013952305735,-0.4361024116530047},
{0.6409803061826341,-0.3188902022490515,-0.6981785487936274},
{0.6502989530195284,-0.6291989869904464,-0.4256993146246552},
{0.8939023152099945,-0.24650063843748032,-0.37440096969976727},
{0.6513213343797171,-0.6754221238140042,0.3458113272355384},
{0.7140690065073941,-0.5379766496302733,0.44798055582595236},
{0.6583049702212879,-0.3755028350571071,0.6524049256757833},
{0.7939694407043295,0.485681306486263,0.3656859250196137},
{0.6706239383487267,0.6264223605452466,0.39731418238286476},
{0.647903728696688,0.5988034461237487,-0.47080270947738956},
{0.8565237688643835,0.4515125296465489,0.2500069377887868},
{0.49292460248088005,0.8196409092987001,-0.2919145698197786},
{0.4669758392950961,0.030198437573258893,-0.8837542757366295},
{-0.021899563108073946,-0.6724865840264717,-0.7397852414316487},
{0.7203244410229329,-0.6921234841482325,0.045801554073095},
{0.5633772512858803,-0.6653731327753368,0.48978022307388036},
{0.8069972521790345,-0.5665980707368536,0.1664994330703956},
{0.23790534579318062,-0.5188116578289286,0.8211184507388845},
{0.24250708373537538,-0.8443246630836183,0.4778139571495355},
{0.38499590944019313,-0.3244965522424485,0.8639908201463036},
{0.4766970754724129,0.21529867914665513,0.852294771187618},
{0.638682062866143,0.7101800548732344,0.2961916815734329},
{0.5656096691799427,0.48260825025855786,-0.6687114317196386},
{0.35168984686067956,0.664080828263228,-0.6597809523988524},
{0.9997751608946875,-0.013799657151777042,-0.01609960001040655},
{0.9995362738295778,0.004600166943087601,-0.03010109238846452},
{0.8494183263980902,-0.2068044618543973,-0.48551047500149846},
{0.8072097148273774,-0.5347064352306722,-0.2500030088043166},
{0.22590486039535768,-0.6930149103761969,-0.6846147296443642},
{0.17790177102094581,-0.8192081552577786,-0.545205427547047},
{0.638979345326488,-0.5537820992829562,-0.5338827425192676},
{0.42180739434843495,0.6953121889295089,0.5819102009752354},
{0.29419814655751503,0.7529952561448294,0.5885962918550419},
{0.22461195191995093,0.3901207588778845,0.8929475150014434},
{0.7935789347267628,0.15729582463775174,-0.587784397470251},
{0.5969976717136204,0.4297983237898058,0.6773973581554548},
{0.1552998338292667,0.8537990864354663,-0.49689946831785337},
{-0.007500079276256927,0.31060328309405355,-0.9505100469442945},
{0.006200276848542068,0.008500379550420578,-0.9999446485253571},
{0.014200401593035658,0.23360660648824857,-0.9722274949823426},
{-0.0055997855043243075,0.7393716789102487,-0.6732742107252779},
{-0.02060034691276304,0.6036101648807656,-0.7970134218190361},
{-0.07249609764009322,0.9078511316888365,-0.41297777000494484},
{0.03400154200489568,0.9899448950190067,-0.13730622697859343},
{-0.014300146577253628,0.9926101743064302,0.12050123514399036},
{0.013399923352657633,-0.673796145897068,-0.7387957741002581},
{-0.02430002745904654,0.037500042375071825,-0.9990011288719134},
{-0.00829990716605752,-0.16179819029736225,-0.986788962827176},
{0.018000493040256648,-0.7819214171209264,-0.6231170674102177},
{-0.0003999865746759278,-0.9988664736094606,-0.04759840238643541},
{-0.005499804595414026,-0.9799651824555901,-0.19909292635398776},
{0.0009000218437952265,-0.8868215234195632,0.46211121557530466},
{0.03599994006014969,-0.7676987217826923,0.6397989347356604},
{-0.03979979980751045,-0.4258978577391633,0.9038954534173038},
{-0.003899887099902663,-0.22749341416098867,0.9737718097141572},
{0.12680273643257864,-0.12180262852908579,0.984421244039672},
{0.16940646636823428,-0.2043077985775104,0.9641368018041007},
{-0.00949961750560155,-0.10179590127055135,-0.9947599467970971},
{0.01769964406373678,-0.14219714044425819,-0.9896800977333499},
{-0.07640343976028875,-0.00800036018432343,0.9970448879713074},
{-0.020400437288059955,0.4576098089713841,0.8889190541841419},
{0.09079732469624115,0.22649332647245177,0.9697714261058884},
{0.159393447470059,0.026498910652174176,0.9868594310426677},
{0.015700435379109676,0.00990027453841948,0.999827725607252},
{0.0,0.007899753492038362,0.999968796460552},
{-0.00269990644986224,0.6964758675292778,0.7175751364522753},
{0.02440029658740754,0.8068098068328033,0.5903071752273226},
{0.03530057787518976,0.9289152064663958,0.36860603413016846},
{-0.9987273105717165,-0.020900571533942997,-0.04590125518698487},
{-0.9986132017537914,-0.03860051030211931,-0.03580047328538527},
{-0.9987871107355033,-0.036899523814717734,-0.032599579305143574},
{-0.9986119634429835,-0.049200589426592015,-0.018800225228047356},
{-0.9987838747645118,-0.04929920407077536,-0.0005999903132345886},
{-0.9986362261861692,-0.051801879147249714,0.006500235800330562},
{-0.9986732259297143,-0.0396989356858012,0.0327991206673622},
{-0.9986128771960777,-0.03960051065187731,0.03470044746515511},
{-0.9985700034076396,-0.010599681590347467,0.05239842597492521},
{-0.9985354136864307,-0.0209007412579333,0.04990176979764936},
{-0.998314445714545,0.007100102739229962,0.05760083349009095},
{-0.9986917558335834,-0.004899959551000859,-0.050899579825702805},
{-0.9982658449184141,0.013499538121204639,-0.05729803958111302},
{0.9999999900000002,-9.999999900000002e-05,9.999999900000002e-05},
{0.793091010364346,-0.6090930959688856,0.003499960328174519},
{0.9481772961664616,-0.3176923929467252,0.005599865912816057},
{0.9999999900000002,-9.999999900000002e-05,-9.999999900000002e-05},
{0.999999995,0.0,-9.999999950000001e-05},
{0.9485791694301565,0.018599591557454047,-0.3159930608685742},
{0.5138921811899444,0.18309721419707886,-0.8380872485995181},
{0.9999999150000108,-9.99999915000011e-05,0.0003999999660000044},
{0.9999999800000006,-0.0,0.0001999999960000001},
{-0.9999995550002969,0.0004999997775001485,0.0007999996440002375},
{-0.9990429297970599,0.024101035643752895,-0.03650156850609878},
{-0.9996289046876745,0.01550044820193973,-0.022400647724093545},
{-0.9950332147630724,0.05180172917058005,-0.08500283744207152},
{0.999999975000001,-9.999999750000011e-05,0.00019999999500000022},
{-0.001300078039526554,-0.48492910874340467,-0.874552496589209},
{0.07429949142172183,-0.4373970060277406,0.8961938655739852},
{0.32170242242836133,0.1467011046634772,-0.935407043641558},
{0.010800516439040595,-0.9998478088659988,0.01370065511248668},
{0.04739886315190078,-0.9988760422454366,0.0},
{0.9485479830548748,0.012599309072835149,-0.31638265005119376},
{0.40409781585720794,0.13299928114082815,-0.9049951085146577},
{0.22479974260444208,0.10249988263770157,-0.9689988904969056},
{-0.9947032874997978,0.05090016822533397,0.08930029513796314},
{-0.999999950000004,9.999999500000039e-05,-0.00029999998500000117},
{0.5817969048486992,0.32079829335761895,0.7473960238637294},
{-0.5847223572867544,0.558021336353701,0.5888225140592458},
{0.4160108497044423,-0.39721035938126076,0.8180213342746004},
{0.7545964043567,0.6088970986122376,0.2445988344893305},
{0.8585724917780381,0.5103836475698935,0.04859844293083234},
{0.8520477668126843,-0.5213680385120686,-0.04679713118980593},
{0.7538843382155587,-0.611487296483372,-0.24029500792306505},
{0.916277922549431,-0.04049902418776815,-0.3984903984895212},
{0.48569301092785877,0.1554977624032984,-0.8601876219891786},
{-0.641205681107502,-0.7272064430776286,0.24500217072884903},
{-0.8242832054007833,-0.49009001451768025,0.28349422386403256},
{-0.8016290635885601,-0.000300010877091527,-0.5978216744177162},
{-0.6566818134490112,-0.7444793819290223,-0.1204966628911312},
{0.005900185091709536,-0.9871309667841497,0.15980501316189558},
{-0.03680025594667016,-0.9471065871492205,-0.3188022172771317},
{0.013799798248424403,-0.8741872194762763,-0.48539290360762355},
{0.06640271692274548,-0.8611352340689176,-0.5040206224256584},
{0.20830256317881,-0.09830120960382631,-0.9731119742165145},
{-0.02189910938133182,-0.014199422521228853,-0.9996593446811609},
{0.006800285992041219,-0.03270137528525704,-0.9994420324185286},
{0.000399985516786651,-0.016499402567449355,-0.9998637955874308},
{0.009999599124106511,0.07329706157970074,-0.9972600206471424},
{-0.5778833254172142,0.5616837928479828,-0.592082915693948},
{-0.0019000634061738136,-0.350311690096151,-0.9366312559065231},
{0.357994929037745,-0.658790668296275,-0.6616906272186476},
{-0.4378200219674173,-0.06990319674628248,-0.8963409906107723},
{-0.08049805800777557,0.3079925697688804,-0.9479771303275929},
{0.7926197642202342,-0.6096152009445557,0.011100276788852637},
{0.9999941750508954,-0.0028999831076475966,0.0017999895150916116},
{0.9987361299330123,-0.025000904424076608,0.043601577315589606},
{0.9369096595883858,-0.021600222699444057,0.34890359721463104},
{0.6338909671180774,-0.7447893868268559,0.20849702893850625},
{0.7088830259991612,-0.11319728952335315,0.6961833300897391},
{-0.39470186891777403,0.003000014205100892,0.9188043505488999},
{-0.46250959717371304,-0.071601485746244,0.8837183373457518},
{-0.004499753915187384,-0.3552805702369062,0.9347488799815926},
{0.011200344919932796,-0.0036001108671212556,0.9999307933429288},
{0.015199422888869156,-0.006699745615488378,0.9998620359592282},
{0.010300146572128589,-0.04080058059639286,0.9991142174964732},
{-0.007500101627065574,-0.010800146342974428,0.9999135489203824},
{0.8125802464143117,-0.03349918564469535,0.5818858545268126},
{0.8086487104221526,-0.5181312105734817,-0.2786167829874001},
{0.9995737865211682,-0.02749927884086847,0.00979974300510949},
{0.9995147429511885,0.025700379083387237,0.01760025960574379},
{0.659814661244661,-0.6376141679442192,-0.3976088349664705},
{-0.007100019134577353,-0.8934024077227333,-0.44920121059889384},
{0.00659970232713965,-0.9951551145408152,-0.09809557549884845},
{-0.011599934518554463,-0.9987943618217413,-0.047699730735779995},
{0.007600190881191002,-0.9175230438806242,0.39760998610020293},
{0.641205681107502,-0.7272064430776286,-0.24500217072884903},
{0.6566976260423727,-0.744497308647094,0.12029956511785815},
{-0.005900185091709536,-0.9871309667841497,-0.15980501316189558},
{0.03630094783012193,-0.9472247323606472,0.3185083163607117},
{-0.014099734856978999,-0.8741835611326979,0.4853908723104685},
{-0.06629744328839843,-0.8611667897431181,0.5039805643642958},
{-0.03679998215201299,0.9992995153398527,-0.0067999967020024},
{-0.04640100389657907,-0.9989216119028629,-0.0016000346171234163},
{-0.006199875600744094,-0.9999799356038862,-0.001299973916285052},
{0.012600542969095059,0.6545282042279933,0.7559325738364251},
{-0.21859932015717148,-0.2250992999422658,0.9494970470687756},
{0.6562095347938113,0.02010029205936545,0.7543109602178785},
{0.42122680351428854,0.4213268098778959,0.8031511061308764},
{-0.0001999999960000001,0.9999999800000006,0.0},
{-9.999999950000001e-05,-0.999999995,0.0},
{-0.012299941821412778,-0.8740958655363341,0.4855977031282963},
{0.012199957239224814,-0.8740969362956074,-0.4855982979809483},
{-0.39580495550906464,-0.3534044246510951,0.8476106121512966},
{-0.7815631345363953,-0.24128861868427864,0.5752728650189205},
{0.0014999836577670725,-0.3864957891513157,0.922289951705714},
{0.012499984937527226,-0.3845995365578377,0.9229988877870104},
{0.7815631345363953,-0.24128861868427864,-0.5752728650189205},
{0.39580495550906464,-0.3534044246510951,-0.8476106121512966},
{-0.0014999836577670725,-0.3864957891513157,-0.922289951705714},
{-0.012499984937527226,-0.3845995365578377,-0.9229988877870104},
{-0.6448688987230038,0.014099320006193756,-0.7641631453002318},
{0.4835201970604557,0.25901081910787593,-0.8361349260853091},
{0.6519969845209199,0.022199897325712304,-0.7578964947368179},
{-0.4493253718734545,-0.22431266617230325,-0.864748829421269},
{0.9980885170576667,-0.061799289003270017,-0.00039999539807941757},
{0.9919278487652866,0.12680356005992371,0.0},
{0.9920294438708476,0.1260037398464988,0.0008000237450571352},
{0.9917744274260789,-0.12719672027485102,0.014299631288760767},
{0.8847786770908201,-0.4659887698059699,0.004599889144007429},
{0.8537933404379168,-0.5203959409274911,0.014999883001368881},
{0.6094289363728649,-0.7928376448250857,0.0022001044634399453},
{0.6215068832268479,-0.7834086762991352,0.00020000221503679738},
{0.22328906245315702,-0.9747522529303067,-0.0001999902037198003},
{0.22120613966161065,-0.9752270678029055,0.00010000277561555636},
{-0.00019999999500000022,-0.999999975000001,-9.999999750000011e-05},
{-0.001199999130000946,-0.9999992750007884,9.999992750007886e-05},
{-0.8725600507525935,-0.4808779835055262,0.08599606276039769},
{-0.9282095188374238,-0.3688037821021783,-0.049100503528245534},
{-0.6579820998404574,0.747979651490368,0.08709763054119124},
{-0.9415358072876396,-0.31631202957523147,0.11600441173166882},
{-0.7457117599671828,0.42860675918188884,-0.5101080444672924},
{-0.22130536672021525,0.7966193182527043,-0.5625136411211978},
{0.5711086038159252,0.8171123098896734,0.07850118262922452},
{0.4137133362643452,0.9072292450060767,-0.07600244997846321},
{-0.5995892734438464,0.796085758153179,-0.08209853127041325},
{-0.8468709655266617,0.5135823921295235,-0.13799526891330657},
{-0.7870983274178314,-0.18699960262626664,0.5877987509289814},
{0.25729437946567013,-0.9645789290034412,0.05819872866265839},
{-0.08430327355966971,-0.9916385060708006,-0.09770379391197782},
{-0.23310852493463816,-0.7463272936882044,-0.6234227989886462},
{-0.33860708881360724,-0.7584158776025981,0.5569116590676251},
{0.28728950550604226,-0.7610721985403717,0.5815787553160954},
{0.757514627748694,-0.6528126059331321,-0.002700052138510197},
{0.9788812154497115,-0.1953962503819324,0.06009884671419723},
{0.785328598261618,-0.2512091479476868,-0.5658206047324887},
{0.32479348795584906,-0.7384851935203034,-0.5908881528113029},
{-0.2090015967782991,0.7274055573996879,0.6536049935612263},
{0.21580676133175045,0.7233226620540089,0.6559205503127671},
{0.7576632504352849,0.6483685516460851,-0.07459638179024977},
{0.9796881556417969,0.19469764611968754,-0.04799941969052389},
{0.8014043396162486,-0.16950091784995527,0.573603106069229},
{0.14129451010846253,0.7138722630320693,-0.6858733509086655},
{0.8406594433634588,0.5363741232546203,0.07479639153513348},
{-0.15970837692406029,0.014900781566490282,-0.9870517722232153},
{-0.2159944943705068,-0.06429836105566476,0.9742751660425223},
{0.240507387297853,-0.048601492817778195,0.9694297764928845},
{-0.5728253509468716,-0.8186362295480256,-0.04130182785283834},
{-0.6634680580992457,0.4039805508245596,-0.6297696804685832},
{0.02320027260480467,-0.32650383644261743,-0.9449111027706867},
{0.30501289469269044,-0.03110131483587762,-0.9518402398967304},
{0.9552337537810454,-0.022300788012266867,-0.2950104243775213},
{0.9330130249527432,-0.0052000725935201116,-0.35980502291318006},
{0.5561084223258347,-0.829512563062902,0.051500779985219354},
{0.08960165854204956,-0.19290357067814018,-0.9771180866231767},
{0.23979172133372897,0.2229923013236929,-0.9448673790168495},
{-0.5084179957734462,0.3132110863026029,-0.8021283918369024},
{-0.8030742578672394,0.5928809955042786,-0.059698086408509765},
{-0.04029990710882118,0.5113988212270756,-0.8583980213948411},
{0.017900244787521214,0.9818134263904094,-0.1890025846280173},
{0.17780873684693274,-0.07950390652042268,0.9808481951601329},
{0.9833629229999693,0.012899513633007528,-0.1811931682403848},
{0.7119893024410957,0.0010999834728724794,0.7021894496827773},
{-9.999985500031538e-05,-0.9999985500031539,0.0016999975350053614},
{0.31900067628215056,-0.01700003604011461,0.9476020089183883},
{-0.025200981219306032,-0.04780186120169954,0.9985388788681379},
{0.9860696147329757,0.00889972575917603,0.16609488186507176},
{0.1347931061828719,-0.028998516908778086,0.9904493447636101},
{-0.19380224327394893,-0.07040081489414864,0.9785113263341539},
{-0.6684115469092101,0.06650114881726882,0.7408127976516201},
{-0.8261426878955538,0.5373277644429016,-0.1696087639112528},
{-0.5694937498403931,0.802691190512526,0.17709805635949716},
{-0.9459869076317969,0.2791961359522175,-0.164797719215349},
{-0.05279884028620953,0.78848268116811,-0.6127865402914622},
{-0.711514052541308,-0.49890985356691286,-0.4948097725895139},
{-0.03380062531735261,-0.9490175569872079,-0.31340579806089675},
{-0.572892535258898,-0.8185893338504694,0.0412994618715177},
{0.5561774919523419,-0.8294664321727212,-0.05149791592151313},
{0.02320027260480467,-0.32650383644261743,0.9449111027706867},
{-0.6634120742096269,0.40400735300073753,0.6298114626729319},
{0.3051035910904008,-0.031100366053462686,0.9518112028837874},
{0.9552706784165321,-0.02229931553301441,0.2948909484612533},
{0.23979706729980033,0.2228972739830087,0.944888444084993},
{0.08960165854204956,-0.19290357067814018,0.9771180866231767},
{-0.5084179957734462,0.3132110863026029,0.8021283918369024},
{-0.8030742578672394,0.5928809955042786,0.059698086408509765},
{-0.5694836617481134,0.8026769715280256,-0.17719491635077383},
{-0.8261744344276839,0.5372833740232323,0.1695947519715991},
{-0.19389984972767466,-0.07029994551756333,-0.9784992416633815},
{-0.6684070985210796,0.06660070730326736,-0.7408078674213282},
{-0.9459869076317969,0.2791961359522175,0.164797719215349},
{-0.04029990710882118,0.5113988212270756,0.8583980213948411},
{0.017900244787521214,0.9818134263904094,0.1890025846280173},
{0.7118900692028014,0.000999986050291897,-0.7022902031199992},
{0.9833629229999693,0.012899513633007528,0.1811931682403848},
{0.1777912973289884,-0.0794961087607119,-0.9808519884702177},
{-0.0,-0.9999981950048871,-0.0018999965705092854},
{0.31900067628215056,-0.01700003604011461,-0.9476020089183883},
{-0.025200981219306032,-0.04780186120169954,-0.9985388788681379},
{0.9860532326042402,0.008899577903029853,-0.16619211769478218},
{0.13449816344011725,-0.029099602647638754,-0.9904864749995252},
{-0.052803003520262785,0.7884448480184693,0.6128348590382013},
{-0.03380062531735261,-0.9490175569872079,0.31340579806089675},
{-0.7115989183704662,-0.49879924182572866,0.4947992479057148},
{0.9330130249527432,-0.0052000725935201116,0.35980502291318006},
{-0.005699844652850951,0.5070861795545117,0.8618765098758306},
{-0.006800009112018315,0.5072006796493661,0.8618011548143212},
{-0.008900221662780802,0.697717376867659,0.716317840117965},
{0.0,0.5094130895375056,0.8605221113997323},
{-0.027201344595695866,0.0857042364651153,0.9959492309872616},
{-0.032600656583835465,0.07800157096745909,0.9964200681022594},
{-0.027198876709587358,0.6909714634678259,-0.7223701667281585},
{-0.038399144476591485,0.47898932823664897,-0.8769804610929879},
{-0.007699911220535437,0.5083941382493787,-0.8610900716887098},
{-0.007299823017936371,0.5027878100573161,-0.8643790433841367},
{-0.22529916752111398,0.8230969586623565,-0.5212980738071759},
{-0.8403924323002205,0.5143953678905681,-0.17069846286726276},
{-0.9451455287567067,0.32661573345883016,-0.004700226415359773},
{-0.8014731150352766,0.5979799410993081,-0.007799738362164888},
{-0.8698681851529314,0.4932819585422934,0.0014999451405097103},
{-0.9998193966844454,0.01900036861072661,0.00040000776022582334},
{-0.9998343548986617,0.01820062538423249,0.0},
{-0.004500228684931084,0.3856195957576503,-0.9226468854927597},
{0.010900177347328174,0.7049114690029018,-0.7092115389656093},
{0.015599895793044155,0.70099531736692,0.7129952372077232},
{0.7224837659721659,0.44848992254465936,0.5261881766845034},
{0.6946258231949748,-0.008000297416584794,0.7193267414686804},
{-0.003999922842232553,0.39029247133084133,0.9206822402108779},
{0.5858273910000142,0.476122261616775,-0.6558306640795654},
{0.9998586367037815,0.016799305027126243,0.0006999710427969268},
{0.999887476487785,0.014999812128529626,0.0001999974950470617},
{0.9998517633152401,0.01719917024604673,0.0007999614067928714},
{-0.999887476487785,0.014999812128529626,-0.0001999974950470617},
{-0.9998517633152401,0.01719917024604673,-0.0007999614067928714},
{-0.9998586367037815,0.016799305027126243,-0.0006999710427969268},
{-0.026500354312105744,-0.22100295482925922,0.9749130346744109},
{0.5932254083883736,-0.4357186622299635,0.6769289934897},
{-0.01030043422395726,-0.3308139457558312,0.9436397799734049},
{0.6540668363818205,-0.4373778233196886,-0.6171687072540278},
{0.9540160562253406,-0.29970504407833815,0.005500092567336869},
{0.6137885560190586,-0.4713912109928058,-0.6332881924517266},
{-0.01659952874606825,-0.23409335418401073,-0.9720724032562017},
{0.01030043422395726,-0.3308139457558312,-0.9436397799734049},
{-0.9633017628438391,-0.2684004911733483,-0.003300006039016577},
{-0.9637545263154884,-0.2667874119329449,-0.0012999386638411858},
{-0.9540160562253406,-0.29970504407833815,-0.005500092567336869},
{-0.9879776917155788,-0.15459650925023125,0.0},
{-0.010399702780741728,-0.24299305535771537,-0.9699722785884112},
{-0.043201249182180414,-0.12880372441353788,-0.9907286473330124},
{0.00039998880646987427,-0.8844752483065094,0.4665869427471083},
{-0.019300368544056055,0.23160442252867267,0.9726185723289595},
{-0.01019987265538484,0.8362895589900335,0.5481931558511735},
{0.0083999971020015,0.9832996607616756,0.18179993727903246},
{-0.008399759728309409,0.9890717080084329,0.14719578952466011},
{0.008900472538630947,0.971951602280384,-0.23501247714362614},
{-0.008299775992068922,0.9596740987456077,-0.2809924161170322},
{0.00840010630401792,0.7597096141860016,-0.6502082284371966},
{-0.008899470185813264,0.7280566564371502,-0.6854591924016845},
{0.008499640217844209,0.4154824130016786,-0.9095614990765989},
{-0.005399915194997789,0.3859939380128049,-0.9224855124787888},
{0.5670843345116356,-0.5071859891805706,-0.6489820721178832},
{-0.0021998971242164233,-0.6334703764505017,-0.7737638157812128},
{0.7118893964864085,-0.7022895394752138,-0.0016999746790657317},
{0.7103989486103341,-0.7037989583783124,0.0005999991120019713},
{-0.7323973597122773,-0.049199822634959096,0.6790975518577382},
{0.2764870800606161,0.9063576468967175,0.3194850708114533},
{-0.8200173025476275,0.38640815329805284,-0.4222089087019614},
{-0.4062888393988704,-0.0697980826730031,0.911074973114228},
{0.09960021463869381,-0.9287020013549694,0.3572007697684883},
{0.013100276025723825,0.9305196062546579,0.3660077118637343},
{0.03969934218734989,-0.26589559414650726,0.9631840401726804},
{-0.4895959216829585,0.7860934518688188,0.37729685713027017},
{0.4184179484228547,0.030601312671461166,0.9077389382969053},
{0.8607162935136558,0.363806886929555,-0.356106741164416},
{-0.3144902666768672,0.8357741331908605,0.45008607005169454},
{0.5271054450273708,0.6742069645939165,-0.5173053437918022},
{-0.986930624932445,-0.03920121643261915,-0.15630485021475443},
{-0.58391089879864,-0.06110114046343022,0.8095151097405363},
{0.5860733137592231,-0.7630652546146788,0.2724875925599528},
{0.014800198545995251,0.8902119422733089,0.45530610797240795},
{0.6225884791067902,0.2847947299222837,0.7288865120798897},
{-0.020100928885386185,-0.32661509323219545,0.9449436668557913},
{0.6692120425790603,0.6816122657230835,0.2959053248642318},
{-0.6078826056881038,0.6988800018348672,0.37688921546939685},
{-0.8587426507870367,-0.20578625702372166,0.46926866093893377},
{-0.7168649855848978,0.28618602158515516,-0.6357689466241847},
{-0.7050070642061752,-0.3314033206779099,-0.6270062826344283},
{-0.7078808414642851,0.6565822298424207,0.2603929525601072},
{-0.6991862226712221,0.423391657149593,0.5760886482850271},
{-0.38489247542565747,-0.6952864072836052,0.6069881334979841},
{-0.24220524380029304,-0.7331158721304494,-0.6355137590218258},
{0.38119589644826196,-0.924490047918201,-0.002799969858486709},
{0.5721865737995669,-0.8199807593772191,0.01529964099813592},
{0.9159362992748246,-0.4012159005012115,-0.009300368580910436},
{0.6957568713682744,0.36527735715842286,0.6184616627497523},
{0.8248957724199996,0.4539976732678868,0.33679827391326933},
{0.9439640450942706,0.09629633214256171,0.3156879756740055},
{0.902043114180988,0.4315206250211711,-0.010400497103638886},
{-0.9277752055389435,-0.20299457504247204,0.3130916327379211},
{-0.6091861442187229,0.4985886597299002,0.6166859736370427},
{-0.6326824781014002,-0.5260854302657604,0.5682842615853101},
{-0.33030643112882174,0.694113514521693,-0.6396124533757019},
{0.03990033396719296,0.9991083625719922,0.013800115507450198},
{0.29320373983755266,0.9560121940133025,-0.008500108419574343},
{0.8058975621635617,0.5919982092081257,0.008199975195112553},
{0.9875340655751482,0.15740542979395275,0.0},
{0.5017928921540236,0.8649877475353336,0.0002999957505902891},
{-0.5043119271181161,0.8635204224994911,0.0014000331111746235},
{0.03589989212098627,-0.45179864234711964,0.8913973213550741},
{0.7330242635046896,0.06360210526452696,0.6772224164329821},
{-0.04609815357543706,-0.3842846077882963,0.9220630675034819},
{0.7592865683394079,-0.2559954714801639,-0.5982894163538361},
{0.04939774430350839,-0.4018816484935227,-0.914358246783969},
{-0.04600013685061069,-0.3842011430001006,0.9221027432597417},
{0.7592671282412587,-0.2560889128705207,-0.5982740982836101},
{0.04939972929022523,-0.40179779815409916,-0.9143949891291893},
{-0.7321610281056834,-0.019098983388170655,0.68086375858667},
{-0.7536305000435177,0.2841114982250045,-0.592723988025203},
{-0.5269844410140653,-0.8498749078137648,-0.00019999409526150484},
{0.5275968291525851,-0.8494948945510256,-9.999939900541796e-05},
{-0.03579860996696195,0.4678818325011591,0.8830657112241368},
{0.04599836938670735,0.38428637728938336,0.9220673132931054},
{-0.04939774430350839,0.4018816484935227,-0.914358246783969},
{0.985298438303213,-0.014799976542055773,-0.17019973023364138},
{-0.732114631457116,-0.0191003817249432,0.680913608194441},
{-0.03580177133645639,0.467923151070613,0.8830436896673461},
{0.04600013685061069,0.3842011430001006,0.9221027432597417},
{-0.04939972929022523,0.40179779815409916,-0.9143949891291893},
{-0.9859753706428581,0.032999175690886735,-0.1635959134251233},
{-0.6335841289163535,0.055498609777237404,-0.7716806696413353},
{0.632411484696844,-0.018400334153102358,-0.7744140634870905},
{-0.6336330226454852,0.05550289260862441,-0.7716402150777404},
{0.9561826311002578,0.05099907361024173,0.28829476317319},
{0.9398765268768582,0.05949851404316742,0.3362916012221379},
{0.9790558357873489,-0.03539840321404571,-0.2004909560569538},
{0.966994599350244,-0.04439975202807739,-0.2508985987352391},
{-0.9561826311002578,-0.05099907361024173,0.28829476317319},
{-0.9398332471891894,-0.059502104924193194,0.3364119007814889},
{-0.9790482193122308,0.0355017485041718,-0.2005098753545478},
{-0.9669703338052313,0.044398637870684876,-0.2509922996743672},
{0.9562101932549905,0.05100054366869327,0.28820307226112557},
{0.979075459781147,-0.035399112732358906,-0.20039497716284532},
{0.9670188570515705,-0.04440086582532548,-0.25080489074305473},
{-0.9562101932549905,-0.05100054366869327,0.28820307226112557},
{-0.9398765268768582,-0.05949851404316742,0.3362916012221379},
{-0.979075459781147,0.035399112732358906,-0.20039497716284532},
{-0.9670188570515705,0.04440086582532548,-0.25080489074305473},
{0.17110834259061947,-0.9758475786085709,-0.13580662141324443},
{0.5089132446395399,-0.35430922101746704,0.784520417409548},
{-0.3901205618460824,-0.44272333434827144,0.807342552110593},
{-0.9305911035915744,0.3373967745022536,-0.14199864249946653},
{-0.3029948491313468,0.4519923161959365,0.8389857373636962},
{0.986364683844731,-0.10079639104982652,0.13009534201966697},
{0.0889982534264146,0.8359835939829506,0.5414893733753203},
{0.7103059168729314,0.6950057894223388,-0.11150092880660545},
{0.4273092192958606,0.06700144557178249,0.9016194526495386},
{-0.6377197281649409,-0.4400136120316355,0.6322195580145454},
{0.06039814791919067,-0.3998877376305355,0.9145719550809897},
{-0.9063303308520414,0.42231413297894416,-0.01470049196019531},
{0.21490828917257318,-0.9631371489162643,-0.16180624098707463},
{-0.47019946162192466,-0.4790994514314422,0.7411991513274576},
{-0.30388375328943396,0.5713694525488073,0.7623592415526964},
{0.4090831665740361,0.5117789407298745,0.755468913093826},
{-0.3917080633934783,-0.548511291221146,0.7387152066090438},
{0.12840380530315607,0.48161427285046704,0.866925691723567},
{0.708772850975905,0.7045730118476619,-0.03489866323230684},
{0.5966922042672766,-0.3579953228216608,0.7181906169008849},
{0.7279092663439413,-0.43780557330042247,0.5277067177492757},
{0.6695076223876715,0.5997068277011003,-0.4383049901307191},
{0.8283783547563818,0.2570932822403015,0.49768699560870494},
{0.36841649621793554,0.8810394494245418,-0.29671328563480315},
{-0.7038858027665359,0.4287913513656636,-0.5662885780745692},
{-0.4985866854203464,0.4212887496341595,-0.7575797691023957},
{-0.04300086067083957,-0.05390107884088961,-0.9976199675634783},
{-0.25019539019240317,-0.8619841180889349,-0.44089187664200863},
{-0.7230881197597877,-0.6697889954572062,-0.16889722504138865},
{-0.6277823564248055,-0.6475817999692641,0.4318878619622069},
{0.05880053332325587,-0.5999054411670272,0.7979072370514603},
{0.22990232892238804,0.7003070941467958,0.6758068459580245},
{0.24700308508779922,0.8131101558092695,-0.5271065836023441},
{-0.38190734414884264,0.6612127152427723,0.6457124171691744},
{0.42057841646948596,0.8881544210846349,-0.18519049626759107},
{-0.1650977893554007,0.9853868057590058,-0.04189943897026826},
{0.6808073459508944,0.28270305038237054,-0.6757072909210038},
{-0.007099969683194179,0.47529797048199907,-0.8797962432780618},
{-0.7202956890432015,0.6551960786632036,0.2277986366292396},
{-0.7993108267384728,0.25290342560009976,-0.5451073835295152},
{0.27819978717724425,0.43769966515988423,-0.8549993459257506},
{-0.8093327705473327,0.4438179705534489,-0.38471557744910273},
{-0.7822278634527531,-0.4026143413782644,0.47541693465282386},
{-0.9696328711115055,-0.18900640742581945,-0.1552052615475512},
{-0.28539242435864176,0.931675269008222,-0.2247940329215931},
{-0.27870184640584866,-0.920906101023129,0.2725018053304405},
{-0.23939986952710668,-0.11319993830605043,0.9642994744569297},
{-0.6752715244002114,-0.3943833692039736,0.6232737171015131},
{0.6550333649741891,-0.12470635207981891,-0.7452379596622377},
{-0.16559989981209092,-0.9268994392260089,-0.33679979623618495},
{0.5232948455711565,-0.6814932873241796,-0.5115949608144539},
{-0.4044035547228691,-0.6459056775358585,0.6475056916000438},
{-0.7653890550147694,0.13619805238177632,0.6289910054929317},
{0.06080005046406283,-0.1079000895571115,0.9923008236100254},
{0.41740021704816926,-0.712200370344289,0.564400293488229},
{-0.4820273365454052,-0.8703493589117555,0.10070571118282635},
{0.2941909449420699,-0.9545706187685246,-0.04739854109535728},
{0.9914606893629846,0.0718971493345422,-0.10879568633655341},
{0.9679835444196161,0.15299739906632362,0.19899661708626407},
{0.4573028032747761,0.8626052877866213,-0.21630132593119195},
{0.9854713921807214,-0.12349641495111019,-0.11659661524938825},
{0.6809091140294873,-0.7319097966781932,0.025900346678460452},
{0.4635994042751483,-0.3279995785208124,0.8230989423185388},
{-0.1810964523552472,-0.9833807357600779,-0.01289974729642567},
{-0.16170047378308228,-0.9678028356664627,0.19290056519948404},
{0.7884875971876436,-0.16999732596309375,0.5910907022163806},
{0.4716083192441278,-0.35540626942188935,0.8070142358566819},
{0.024401076965298318,0.967442699025803,0.25191111834256746},
{0.4818061069311083,0.875011090835865,0.04710059700385057},
{0.9565744502376466,0.26649288207017857,-0.11809684567537744},
{-0.5952805376209785,0.5496820284398654,-0.5860808384002276},
{-0.725565855674229,-0.5469742599969726,-0.41758034913114395},
{-0.0354985988979517,-0.07619699256405407,-0.9964606704734893},
{0.09149756482471785,-0.4666875792753642,-0.8796765877191727},
{0.20250428301087903,-0.974720615559031,0.0944019966233431},
{0.3195993544099561,-0.07219985415644191,-0.9447980915097827},
{0.7849001138105247,0.1719000249255054,-0.5953000863185188},
{0.16109963833171792,-0.9497978677061806,-0.2681993978930276},
{-0.43680209665509595,-0.8640041472298601,0.2504012019286539},
{0.05059987527146118,-0.39889901671513567,0.915597743054345},
{-0.13459763648625475,0.7819862684416881,0.6085893132654877},
{-0.47159334822273474,0.3325953087762544,0.8166884806902193},
{-0.09659903594643186,0.8965910520659504,-0.43219568670856984},
{-0.48819987062705145,-0.5559998526600586,0.6726998217345709},
{-0.7532669360734957,0.3262856780044891,0.5710749332159477},
{0.18820814111922,0.9780423061349476,0.08950387157369918},
{0.5734723650325776,0.5352742057575218,-0.6201701147222399},
{-0.898329991247395,0.08850295472046583,0.43031436628493164},
{-0.8625173755875486,0.3665073833656076,0.34890702880289354},
{0.360812812690472,0.9253328591532531,0.11650413713536582},
{0.7054204081076142,0.6897199538869031,-0.16330472447401956},
{0.9022594849474722,-0.19539122615397989,-0.38438273968060327},
{-0.3190118196068787,-0.9249342694495364,-0.20670765866063268},
{-0.680058810085272,-0.7307557394652503,0.05929640852530014}
};


// face array: 72kb.
const uint16_t R2D2_face[36867] PROGMEM = {
28, // chain 0
0,0,0, 1,1,1, 2,2,2, 
32771,3,3, 32772,4,4, 5,5,5, 32774,6,6, 32775,7,7, 8,8,8, 32777,9,9, 32778,10,10, 11,11,11, 32780,12,12, 32781,13,13, 14,14,14, 32783,15,15, 32784,16,16, 17,17,17, 32786,18,18, 
32787,19,19, 20,20,20, 32789,21,21, 32790,22,22, 23,23,23, 24,24,24, 32793,25,25, 32794,26,26, 32795,27,27, 28,28,28, 29,29,29, 
14, // chain 1
30,30,30, 31,31,31, 32,32,32, 
33,33,33, 32802,34,34, 32803,35,35, 36,36,36, 32805,37,37, 32806,38,38, 39,39,39, 40,40,40, 32809,41,41, 32810,42,42, 32811,43,43, 44,44,44, 32813,45,45, 
16, // chain 2
46,46,46, 47,47,47, 31,31,31, 
48,48,48, 32798,30,30, 49,49,49, 32770,50,2, 32768,51,0, 32818,52,50, 1,53,1, 32819,54,51, 32820,55,52, 32821,56,53, 54,57,54, 32823,58,55, 32824,59,56, 33,33,33, 32798,30,30, 
12, // chain 3
46,46,46, 57,60,57, 47,47,47, 
32826,61,58, 32827,62,59, 60,63,60, 32829,64,61, 32830,65,62, 32831,66,63, 64,67,64, 32833,68,65, 66,69,66, 48,48,48, 32814,46,46, 
8, // chain 4
61,70,61, 67,71,67, 60,72,60, 
32836,73,68, 32837,74,69, 70,75,70, 32839,76,71, 32840,77,72, 73,78,73, 32842,79,74, 
6, // chain 5
74,80,74, 75,81,75, 73,82,73, 
32844,83,76, 32845,84,77, 32846,85,78, 79,86,79, 32848,87,80, 
34, // chain 6
81,88,81, 82,89,82, 80,90,80, 
83,91,83, 84,92,84, 32853,93,85, 32854,94,86, 32794,95,26, 87,96,87, 32856,97,88, 32797,98,29, 89,99,89, 32858,100,90, 32859,101,91, 32796,102,28, 92,103,92, 32795,104,27, 93,105,93, 94,106,94, 
95,107,95, 96,108,96, 32865,109,97, 98,110,98, 32867,111,99, 100,112,100, 101,113,101, 32870,114,102, 32871,115,103, 104,116,104, 105,117,105, 32874,118,106, 107,119,107, 32876,120,108, 109,121,109, 32878,122,110, 
32861,105,93, 
1, // chain 7
82,89,82, 79,123,79, 80,90,80, 
11, // chain 8
81,88,81, 111,124,111, 82,89,82, 
32880,125,112, 32881,126,113, 114,127,114, 32883,128,115, 90,100,90, 32884,129,116, 117,130,117, 32886,131,118, 32853,93,85, 32852,92,84, 
2, // chain 9
109,132,109, 119,133,119, 120,134,120, 
32889,135,121, 
1, // chain 10
120,134,120, 107,136,107, 109,132,109, 
2, // chain 11
119,137,119, 122,138,122, 123,139,123, 
121,140,121, 
17, // chain 12
124,141,124, 125,142,125, 121,143,121, 
126,144,126, 32891,145,123, 127,146,127, 32896,147,128, 129,148,129, 32898,149,130, 32899,150,131, 32900,151,132, 133,152,133, 134,153,134, 32903,154,135, 136,155,136, 32905,156,137, 32906,157,138, 32907,158,139, 140,159,140, 
38, // chain 13
141,160,141, 142,161,142, 45,162,143, 
32911,163,144, 32912,164,145, 32913,165,146, 32914,166,147, 147,167,148, 32916,168,149, 32917,169,150, 150,170,151, 32919,171,152, 152,172,153, 32921,173,154, 32892,141,124, 154,174,155, 32923,175,156, 32894,144,126, 156,176,157, 
32925,177,158, 32895,146,127, 129,148,129, 158,178,159, 156,176,157, 32927,179,160, 160,180,161, 32929,181,162, 162,182,163, 32931,183,164, 32932,184,165, 165,185,166, 32934,186,167, 167,187,168, 32936,188,169, 169,189,170, 
32908,159,171, 32938,190,172, 138,157,138, 32939,191,173, 137,156,137, 
3, // chain 14
172,192,174, 173,193,175, 35,194,35, 
32,195,32, 31,196,31, 
4, // chain 15
174,197,176, 70,198,70, 71,199,71, 
73,200,73, 175,201,177, 32844,202,76, 
4, // chain 16
82,203,82, 112,204,112, 176,205,178, 
32945,206,179, 32882,207,114, 101,208,101, 
2, // chain 17
177,206,180, 101,208,101, 178,209,181, 
32947,210,182, 
16, // chain 18
180,211,183, 179,212,182, 101,213,101, 
102,214,102, 105,215,105, 181,216,184, 32875,217,107, 182,218,185, 32951,219,186, 32952,220,187, 32888,221,120, 185,222,188, 32954,223,189, 32889,224,121, 187,225,190, 32956,226,191, 32957,227,192, 32893,228,125, 
2, // chain 19
190,229,193, 191,230,194, 189,227,192, 
192,231,195, 
5, // chain 20
190,229,193, 193,232,196, 194,233,197, 
32963,234,198, 32964,235,199, 32965,236,200, 32966,237,201, 
12, // chain 21
38,238,38, 199,239,202, 200,240,203, 
32969,241,204, 202,242,205, 43,243,43, 32971,244,206, 204,245,207, 205,246,208, 32974,247,209, 207,248,210, 141,249,211, 45,250,45, 43,243,43, 
4, // chain 22
38,238,38, 35,251,35, 173,252,175, 
208,253,212, 209,254,213, 199,239,214, 
2, // chain 23
200,240,203, 43,243,43, 39,255,39, 
38,238,38, 
18, // chain 24
173,193,215, 172,192,216, 210,256,215, 
32979,257,215, 32980,258,217, 32799,196,31, 213,259,218, 32982,260,219, 32815,261,47, 215,262,220, 32984,263,221, 32826,264,58, 217,265,222, 32986,266,223, 32828,267,60, 219,268,224, 32988,269,225, 32836,270,68, 221,271,226, 
32838,198,70, 
6, // chain 25
141,249,227, 222,272,228, 197,236,200, 
32991,273,229, 196,235,199, 32992,274,215, 225,275,230, 195,234,230, 
11, // chain 26
195,234,198, 226,276,215, 194,233,197, 
32995,277,231, 190,229,193, 32996,278,232, 229,279,233, 191,230,194, 32998,280,234, 231,281,235, 189,227,192, 33000,282,236, 188,226,191, 
8, // chain 27
182,218,185, 233,283,215, 181,216,184, 
33002,284,237, 180,211,183, 33003,285,238, 236,286,239, 179,212,182, 33005,287,215, 238,288,215, 
1, // chain 28
178,209,215, 179,210,182, 238,289,215, 
3, // chain 29
239,290,240, 240,291,241, 177,206,180, 
33009,292,242, 176,205,243, 
1, // chain 30
177,206,180, 178,209,181, 239,290,240, 
3, // chain 31
176,205,178, 242,293,244, 82,203,82, 
33011,294,245, 79,295,79, 
1, // chain 32
79,295,79, 244,296,246, 77,297,77, 
10, // chain 33
77,297,77, 245,298,247, 76,202,76, 
33014,299,248, 175,201,249, 33015,300,250, 248,301,215, 174,197,251, 33017,302,252, 250,303,253, 70,198,254, 33019,304,255, 
2, // chain 34
252,305,256, 253,306,257, 254,307,258, 
255,308,259, 
3, // chain 35
256,309,260, 254,307,258, 253,306,257, 
257,310,261, 258,311,262, 
3, // chain 36
259,312,263, 260,313,264, 261,314,265, 
33030,315,266, 33031,316,267, 
2, // chain 37
264,317,268, 265,318,269, 266,319,270, 
267,320,271, 
1, // chain 38
265,318,269, 268,321,272, 266,319,270, 
1, // chain 39
269,322,273, 265,318,269, 264,317,268, 
24, // chain 40
270,323,274, 271,324,275, 272,325,276, 
273,326,277, 274,327,278, 33043,328,279, 276,329,280, 33045,330,281, 33046,331,282, 33047,332,283, 32784,333,284, 33048,334,285, 281,335,286, 19,336,287, 33050,337,288, 22,338,22, 33051,339,289, 122,340,122, 33052,341,290, 
285,342,291, 33054,343,292, 33040,325,276, 271,324,275, 287,344,293, 33044,329,280, 277,330,281, 
2, // chain 41
270,345,274, 274,346,278, 276,347,280, 
271,348,275, 
4, // chain 42
278,349,282, 288,350,294, 289,351,295, 
33058,352,296, 291,353,297, 33060,354,298, 
1, // chain 43
289,351,295, 293,355,299, 278,349,282, 
19, // chain 44
294,356,300, 295,357,301, 291,358,297, 
33064,359,302, 33065,360,303, 33066,361,304, 299,362,305, 33068,363,306, 301,364,307, 33070,365,308, 33071,366,309, 304,367,310, 33073,368,311, 33074,369,312, 307,370,313, 33076,371,314, 33062,356,300, 309,372,315, 33078,373,316, 
33060,374,298, 33059,358,297, 
4, // chain 45
298,375,304, 295,376,301, 294,377,300, 
306,378,312, 300,379,306, 33071,380,309, 
3, // chain 46
302,381,308, 311,382,317, 312,383,318, 
33081,384,319, 33082,385,320, 
1, // chain 47
312,383,318, 301,386,307, 302,381,308, 
4, // chain 48
313,387,319, 314,388,320, 51,54,51, 
315,389,321, 32809,41,41, 42,42,42, 
7, // chain 49
316,390,322, 317,391,323, 318,392,324, 
33087,393,325, 33088,394,326, 33089,395,327, 319,393,325, 33090,396,328, 318,392,324, 
5, // chain 50
323,397,329, 316,390,322, 318,392,324, 
324,398,330, 316,390,322, 33093,399,331, 317,391,332, 
7, // chain 51
326,400,333, 327,401,334, 328,402,335, 
33097,403,336, 33098,404,337, 33099,405,338, 329,403,336, 33100,406,339, 328,402,340, 
5, // chain 52
333,407,341, 326,400,333, 328,402,335, 
334,408,342, 326,400,333, 33103,409,343, 327,401,344, 
7, // chain 53
336,410,345, 337,411,346, 338,412,347, 
33107,413,348, 33108,414,349, 33109,415,350, 339,413,348, 33110,416,351, 338,412,352, 
5, // chain 54
343,417,353, 336,410,345, 338,412,347, 
344,418,354, 336,410,345, 33113,419,355, 337,411,356, 
3, // chain 55
91,101,91, 98,110,98, 101,113,101, 
114,127,114, 90,100,90, 
12, // chain 56
122,340,122, 285,342,291, 346,420,357, 
123,421,123, 33115,422,358, 128,423,128, 33116,424,359, 132,425,132, 33117,426,360, 33118,427,361, 351,428,362, 33120,429,363, 33054,343,292, 287,344,293, 
9, // chain 57
296,359,302, 353,430,364, 354,431,365, 
291,358,297, 33057,432,295, 33123,433,366, 293,434,299, 33124,435,367, 277,330,281, 33119,428,362, 33117,426,360, 
13, // chain 58
357,436,368, 354,431,365, 353,430,364, 
135,437,135, 32907,438,139, 33126,439,369, 359,440,370, 140,441,140, 32812,442,44, 33128,443,371, 33067,362,305, 301,364,307, 312,444,318, 315,389,321, 33081,387,319, 
12, // chain 59
358,445,369, 353,446,364, 361,447,372, 
33130,448,373, 33064,449,302, 297,450,303, 363,451,374, 33132,452,375, 33067,453,305, 365,454,376, 33127,455,370, 358,445,369, 366,456,377, 33129,447,372, 
36, // chain 60
324,457,330, 318,458,324, 367,459,378, 
368,460,379, 61,461,61, 33137,462,380, 67,463,67, 33138,464,381, 69,465,69, 33139,466,382, 72,467,72, 33140,468,383, 74,469,74, 33141,470,384, 75,471,75, 33142,472,385, 78,473,78, 33143,474,386, 80,475,80, 
33144,476,387, 342,477,351, 33145,478,388, 338,479,352, 33112,480,389, 33146,481,390, 345,482,355, 33147,483,391, 33100,484,339, 33096,485,340, 33148,486,392, 334,487,393, 33149,488,394, 335,489,343, 33150,490,395, 33090,491,328, 
33151,492,396, 318,458,324, 33135,459,378, 
4, // chain 61
132,425,132, 349,426,360, 384,493,397, 
133,494,133, 33125,436,368, 135,437,135, 
12, // chain 62
368,495,379, 367,496,378, 370,497,381, 
33151,498,396, 372,499,383, 33149,500,394, 373,501,384, 33153,502,398, 33148,503,392, 378,504,399, 377,505,388, 386,506,400, 33143,507,386, 33144,508,387, 
1, // chain 63
370,497,381, 369,509,380, 368,495,379, 
3, // chain 64
374,510,385, 373,501,384, 385,502,398, 
386,506,400, 375,507,386, 
4, // chain 65
169,189,170, 140,159,171, 143,163,144, 
167,187,168, 33155,511,401, 32912,164,145, 
10, // chain 66
156,176,157, 160,180,161, 162,182,163, 
388,512,402, 33157,513,403, 33158,514,404, 32931,183,164, 391,515,405, 32933,185,166, 167,187,168, 392,516,406, 33155,511,401, 
2, // chain 67
393,517,407, 192,518,195, 189,519,192, 
125,520,125, 
8, // chain 68
124,521,408, 151,522,409, 394,523,410, 
33163,524,411, 32917,525,412, 396,526,413, 33165,527,414, 32914,528,415, 398,529,416, 32910,530,417, 
2, // chain 69
141,531,227, 197,532,200, 399,533,418, 
32966,534,201, 
1, // chain 70
399,533,418, 400,535,419, 141,531,227, 
1, // chain 71
401,536,420, 198,537,201, 193,538,196, 
2, // chain 72
193,539,196, 190,540,193, 401,536,420, 
32960,518,195, 
18, // chain 73
26,26,26, 83,541,83, 402,542,421, 
33171,543,422, 404,544,423, 33173,545,424, 33174,546,25, 407,547,425, 33176,548,426, 33177,549,427, 33178,550,428, 33179,551,429, 412,552,430, 33181,553,431, 33182,554,432, 415,555,433, 33184,556,434, 33185,557,435, 32770,2,2, 
33186,558,436, 
2, // chain 74
402,542,421, 419,559,13, 26,26,26, 
32793,25,25, 
15, // chain 75
420,560,437, 421,561,438, 422,562,439, 
411,563,440, 33191,564,441, 414,565,442, 33192,566,443, 254,567,258, 33193,568,444, 255,569,259, 33194,570,445, 252,571,256, 33021,572,257, 33150,490,395, 33027,573,263, 33189,561,438, 33190,562,439, 
5, // chain 76
427,574,446, 428,575,447, 429,576,448, 
406,577,449, 33198,578,450, 420,560,437, 411,563,440, 
13, // chain 77
431,579,451, 429,576,448, 428,575,447, 
263,580,267, 33030,581,266, 33147,483,391, 33034,582,270, 33035,583,271, 33200,584,452, 264,585,268, 32851,586,83, 33201,587,453, 403,588,422, 33195,574,446, 406,577,449, 
6, // chain 78
434,589,454, 435,590,455, 436,591,456, 
437,592,457, 33206,593,458, 33207,594,459, 440,595,460, 441,596,460, 
29, // chain 79
442,597,461, 279,332,283, 16,333,284, 
443,598,462, 32781,599,463, 444,600,464, 33213,601,465, 32778,602,466, 446,603,467, 33215,604,468, 33216,605,469, 32775,606,7, 449,607,470, 33218,608,471, 32772,609,4, 451,610,472, 33220,611,473, 33221,612,474, 32769,53,1, 
454,613,475, 33223,614,476, 32819,54,51, 314,388,320, 456,615,477, 33079,616,317, 457,617,478, 33070,365,308, 458,618,479, 33072,367,310, 451,610,472, 33218,608,471, 
12, // chain 80
459,619,480, 460,620,481, 461,621,482, 
462,622,483, 33047,623,283, 463,624,484, 33210,625,461, 464,626,485, 33211,627,462, 465,628,486, 33212,629,464, 466,630,487, 33228,620,481, 459,619,480, 
7, // chain 81
444,600,464, 445,601,465, 292,374,298, 
460,631,481, 33058,632,296, 461,633,482, 33056,634,294, 279,332,283, 33046,331,282, 
1, // chain 82
310,635,316, 292,636,298, 445,637,465, 
2, // chain 83
445,638,465, 446,639,467, 309,640,315, 
310,641,316, 
3, // chain 84
446,642,467, 447,643,468, 308,644,314, 
33216,645,469, 307,646,313, 
1, // chain 85
308,644,314, 309,647,315, 446,642,467, 
2, // chain 86
449,648,470, 450,649,471, 304,650,310, 
305,651,311, 
6, // chain 87
467,652,488, 468,653,488, 469,654,489, 
470,655,490, 33239,656,491, 33240,657,492, 473,658,493, 474,659,493, 
2, // chain 88
96,660,96, 98,661,98, 92,662,92, 
32859,663,91, 
2, // chain 89
56,664,56, 53,665,53, 30,666,30, 
32818,667,50, 
1, // chain 90
3,3,3, 417,557,435, 2,2,2, 
11, // chain 91
475,668,494, 476,669,495, 477,670,496, 
33246,671,21, 33247,672,497, 480,673,498, 33249,674,499, 482,675,500, 483,676,25, 33252,677,501, 485,678,502, 33254,679,503, 33255,680,504, 
9, // chain 92
477,670,496, 488,681,25, 489,682,505, 
33258,683,506, 33259,684,506, 492,685,507, 33261,686,508, 494,687,10, 33263,688,509, 33253,678,502, 486,679,503, 
2, // chain 93
475,668,494, 477,670,496, 489,682,505, 
496,689,510, 
5, // chain 94
5,690,511, 6,691,512, 475,692,494, 
33244,693,495, 33265,694,513, 498,695,514, 33267,696,515, 
5, // chain 95
8,697,516, 9,698,517, 476,699,495, 
33247,700,518, 33268,701,519, 501,702,520, 33270,703,521, 
5, // chain 96
11,704,11, 12,705,12, 479,706,518, 
33249,707,522, 33271,708,523, 504,709,524, 33273,710,525, 
5, // chain 97
14,711,526, 15,712,527, 481,713,522, 
33250,714,528, 33274,715,529, 507,716,530, 33276,717,531, 
5, // chain 98
17,718,532, 18,719,533, 482,720,528, 
33252,721,501, 33277,722,534, 510,723,535, 33279,724,536, 
5, // chain 99
20,725,537, 21,726,538, 484,727,501, 
33255,728,504, 33280,729,539, 513,730,540, 33282,731,541, 
2, // chain 100
24,732,542, 25,733,543, 486,734,503, 
487,735,504, 
5, // chain 101
419,736,544, 402,737,545, 486,738,503, 
33263,739,509, 33283,740,546, 516,741,547, 33285,742,548, 
5, // chain 102
404,743,549, 405,744,550, 495,745,509, 
33262,746,551, 33286,747,552, 519,748,553, 33288,749,554, 
5, // chain 103
407,750,555, 408,751,556, 494,752,551, 
33260,753,557, 33289,754,558, 522,755,559, 33291,756,560, 
5, // chain 104
409,757,561, 410,758,562, 492,759,557, 
33258,760,563, 33292,761,564, 525,762,565, 33294,763,566, 
5, // chain 105
412,764,567, 413,765,568, 490,766,563, 
33257,767,505, 33295,768,569, 528,769,570, 33297,770,571, 
5, // chain 106
415,771,433, 416,772,434, 489,773,505, 
33264,774,510, 33298,775,572, 531,776,573, 33300,777,574, 
2, // chain 107
417,778,435, 3,779,3, 475,780,494, 
496,781,510, 
4, // chain 108
533,782,575, 534,783,576, 535,784,577, 
536,785,578, 33305,786,579, 33306,787,580, 
2, // chain 109
536,785,578, 537,786,579, 539,788,581, 
540,789,582, 
9, // chain 110
483,790,583, 485,791,584, 535,792,577, 
33306,793,580, 33261,794,585, 537,795,579, 33259,796,586, 539,797,581, 33256,798,587, 540,799,582, 33245,800,588, 
7, // chain 111
535,792,577, 534,801,576, 483,790,583, 
33301,802,575, 480,803,589, 33246,804,590, 33304,805,578, 540,806,582, 477,807,588, 
2, // chain 112
3,808,591, 5,690,592, 541,809,593, 
542,810,594, 
3, // chain 113
543,811,595, 541,809,596, 5,690,511, 
544,812,597, 33243,692,494, 
3, // chain 114
542,810,598, 543,811,599, 544,812,597, 
475,813,494, 3,808,600, 
2, // chain 115
6,691,601, 8,697,602, 545,814,603, 
497,694,604, 
3, // chain 116
499,696,605, 545,814,606, 8,697,516, 
498,695,514, 33244,699,495, 
2, // chain 117
9,698,9, 11,704,11, 546,815,607, 
500,701,608, 
3, // chain 118
502,703,609, 546,815,610, 11,704,11, 
501,702,520, 33247,706,518, 
2, // chain 119
12,705,611, 14,711,612, 547,816,613, 
503,708,614, 
3, // chain 120
505,710,615, 547,816,616, 14,711,526, 
504,709,524, 33249,713,522, 
2, // chain 121
15,712,15, 17,718,17, 548,817,617, 
506,715,618, 
3, // chain 122
508,717,619, 548,817,620, 17,718,532, 
507,716,530, 33250,720,528, 
2, // chain 123
18,719,621, 20,725,622, 549,818,623, 
509,722,624, 
3, // chain 124
511,724,625, 549,818,626, 20,725,537, 
510,723,535, 33252,727,501, 
2, // chain 125
21,726,627, 24,819,628, 550,820,629, 
512,729,630, 
3, // chain 126
514,731,631, 550,820,632, 24,819,633, 
513,730,540, 33255,821,504, 
2, // chain 127
25,822,634, 419,736,635, 551,823,636, 
552,824,637, 
3, // chain 128
553,825,638, 551,823,639, 419,736,544, 
554,826,640, 33254,738,503, 
3, // chain 129
552,824,641, 553,825,642, 554,826,640, 
486,827,503, 25,822,643, 
2, // chain 130
402,737,644, 404,743,645, 555,828,646, 
515,740,647, 
3, // chain 131
517,742,648, 555,828,649, 404,743,549, 
516,741,547, 33263,745,509, 
2, // chain 132
405,744,650, 407,750,651, 556,829,652, 
518,747,653, 
3, // chain 133
520,749,654, 556,829,655, 407,750,555, 
519,748,553, 33262,752,551, 
2, // chain 134
408,751,656, 409,757,657, 557,830,658, 
521,754,659, 
3, // chain 135
523,756,660, 557,830,661, 409,757,561, 
522,755,559, 33260,759,557, 
2, // chain 136
410,758,662, 412,764,663, 558,831,664, 
524,761,665, 
3, // chain 137
526,763,666, 558,831,667, 412,764,567, 
525,762,565, 33258,766,563, 
2, // chain 138
413,765,431, 415,771,433, 559,832,668, 
527,768,669, 
3, // chain 139
529,770,670, 559,832,671, 415,771,433, 
528,769,570, 33257,773,505, 
2, // chain 140
416,772,434, 417,833,435, 560,834,672, 
530,775,673, 
3, // chain 141
532,777,674, 560,834,675, 417,833,676, 
531,776,573, 33264,835,510, 
4, // chain 142
2,50,2, 418,836,436, 49,49,49, 
33329,837,677, 33182,838,678, 562,839,679, 
2, // chain 143
23,840,23, 563,841,680, 564,842,681, 
27,104,27, 
1, // chain 144
563,841,680, 23,840,23, 22,338,22, 
5, // chain 145
466,843,682, 459,844,683, 565,845,684, 
33334,846,685, 33230,847,686, 567,848,687, 33231,849,688, 
9, // chain 146
565,845,684, 568,850,689, 466,843,682, 
33337,851,690, 465,852,486, 33338,853,691, 464,854,485, 33339,855,692, 463,856,688, 33340,857,693, 567,858,687, 
6, // chain 147
566,859,685, 567,860,694, 565,861,684, 
33340,862,694, 571,863,694, 570,864,694, 569,865,694, 568,866,689, 
12, // chain 148
275,867,279, 273,868,277, 281,869,286, 
33341,870,695, 33342,871,696, 33040,872,276, 284,873,290, 575,874,697, 33051,875,289, 282,876,288, 576,877,698, 33049,869,286, 573,870,695, 577,878,699, 
4, // chain 149
258,879,262, 325,880,331, 62,881,62, 
256,882,260, 33022,567,258, 33182,565,442, 
2, // chain 150
321,883,700, 257,884,261, 382,490,395, 
322,491,328, 
3, // chain 151
578,885,701, 335,489,343, 382,490,395, 
261,886,265, 33027,573,263, 
3, // chain 152
265,887,269, 345,482,355, 379,483,391, 
268,888,272, 33034,582,270, 
4, // chain 153
265,887,269, 269,889,273, 341,890,702, 
32848,475,80, 32851,586,83, 33032,585,268, 
1, // chain 154
357,891,703, 384,892,397, 349,893,360, 
7, // chain 155
579,894,704, 363,451,705, 366,456,706, 
33348,895,707, 33349,896,708, 33132,452,709, 580,895,707, 33133,454,376, 366,456,377, 
5, // chain 156
582,897,710, 579,894,704, 366,456,706, 
361,447,711, 579,894,704, 33130,448,373, 363,451,374, 
2, // chain 157
583,898,712, 584,899,712, 585,900,712, 
586,901,712, 
2, // chain 158
587,902,713, 588,903,713, 589,904,713, 
590,905,713, 
2, // chain 159
591,906,714, 592,907,714, 593,908,714, 
594,909,714, 
2, // chain 160
595,910,715, 596,911,715, 597,912,715, 
598,913,715, 
2, // chain 161
599,914,716, 600,915,716, 601,916,716, 
602,917,716, 
5, // chain 162
106,918,106, 104,919,104, 603,920,717, 
604,921,718, 94,922,94, 605,923,719, 32861,924,93, 
5, // chain 163
97,925,97, 95,926,95, 606,927,720, 
607,928,721, 103,929,103, 608,930,722, 32868,931,100, 
2, // chain 164
606,927,723, 104,919,104, 609,932,724, 
32871,929,103, 
2, // chain 165
603,920,725, 95,926,95, 610,933,726, 
32862,922,94, 
2, // chain 166
611,934,727, 612,935,727, 613,936,727, 
614,937,727, 
2, // chain 167
615,938,728, 616,939,728, 617,940,728, 
618,941,728, 
2, // chain 168
619,942,729, 620,943,729, 621,944,729, 
622,945,729, 
2, // chain 169
623,946,730, 624,947,730, 625,948,730, 
626,949,730, 
2, // chain 170
627,950,731, 628,951,731, 629,952,731, 
630,953,731, 
1, // chain 171
52,954,52, 54,955,54, 631,956,732, 
1, // chain 172
36,957,36, 37,958,37, 632,959,733, 
3, // chain 173
55,960,55, 633,961,734, 36,962,36, 
634,963,735, 33400,964,733, 
1, // chain 174
33,965,33, 633,961,734, 55,960,55, 
3, // chain 175
40,966,40, 635,967,736, 52,968,52, 
636,969,737, 33399,970,732, 
1, // chain 176
41,971,41, 635,967,736, 40,966,40, 
2, // chain 177
631,970,738, 37,972,37, 637,973,739, 
32808,966,40, 
2, // chain 178
632,964,740, 54,974,54, 638,975,741, 
32823,960,55, 
1, // chain 179
562,976,679, 414,977,678, 62,978,742, 
2, // chain 180
61,461,61, 62,881,62, 325,880,331, 
324,457,330, 
3, // chain 181
325,880,331, 258,879,262, 317,979,332, 
33025,884,261, 321,883,700, 
5, // chain 182
335,489,343, 578,885,701, 327,980,344, 
33407,981,743, 331,982,744, 33147,483,391, 33030,581,266, 
2, // chain 183
345,482,355, 265,887,269, 337,983,356, 
33109,890,702, 
1, // chain 184
342,477,351, 341,890,702, 80,475,80, 
1, // chain 185
332,484,339, 331,982,744, 379,483,391, 
1, // chain 186
370,497,381, 372,499,383, 371,984,382, 
1, // chain 187
257,884,261, 253,572,257, 382,490,395, 
3, // chain 188
421,561,438, 640,985,745, 260,986,264, 
33031,580,267, 33199,579,451, 
1, // chain 189
260,986,264, 259,573,263, 421,561,438, 
2, // chain 190
639,987,743, 578,988,701, 261,314,265, 
262,315,266, 
12, // chain 191
640,989,745, 421,990,438, 641,991,746, 
33410,992,747, 33188,993,437, 643,994,748, 33198,995,450, 644,996,749, 33197,997,448, 645,998,750, 33199,999,451, 646,1000,751, 33408,989,745, 641,991,746, 
14, // chain 192
642,1001,752, 647,1002,753, 648,1003,754, 
641,1004,755, 33417,1005,756, 646,1006,757, 33418,1007,758, 645,1008,759, 33419,1009,760, 652,1010,761, 644,1011,762, 33421,1012,763, 643,1013,764, 33422,1014,765, 642,1015,752, 33415,1016,753, 
6, // chain 193
649,1017,756, 648,1018,754, 647,1019,766, 
654,1020,766, 653,1021,766, 652,1022,766, 651,1023,766, 650,1024,758, 
4, // chain 194
432,1025,452, 428,1026,447, 655,1027,767, 
33195,1028,446, 656,1029,768, 33201,1030,453, 
3, // chain 195
432,1025,452, 655,1027,767, 657,1031,769, 
658,1032,770, 433,1030,453, 
1, // chain 196
656,1029,768, 657,1031,769, 655,1027,767, 
6, // chain 197
659,1033,771, 657,1034,769, 656,1035,768, 
660,1036,772, 33429,1037,773, 33201,1038,453, 662,1039,774, 33426,1040,770, 
3, // chain 198
657,1041,769, 659,1033,775, 662,1039,776, 
33429,1037,777, 33428,1036,778, 
1, // chain 199
662,1039,776, 658,1042,770, 657,1041,769, 
5, // chain 200
426,1043,445, 425,1044,444, 424,1045,443, 
663,1046,779, 33432,1047,780, 33433,1048,781, 33191,1049,441, 
3, // chain 201
423,1049,441, 422,1050,439, 666,1051,782, 
33431,1046,779, 33194,1043,445, 
1, // chain 202
666,1051,782, 663,1046,779, 664,1047,780, 
6, // chain 203
666,1052,782, 664,1053,780, 667,1054,783, 
668,1055,784, 669,1056,785, 423,1057,441, 33438,1058,786, 665,1059,781, 
3, // chain 204
667,1054,787, 664,1060,780, 670,1058,788, 
669,1056,789, 668,1055,790, 
1, // chain 205
664,1060,780, 665,1061,781, 670,1058,788, 
10, // chain 206
671,1062,791, 672,1063,792, 673,1064,793, 
674,1065,794, 32831,1066,63, 32833,1067,65, 33443,1068,795, 33440,1063,792, 676,1069,796, 33445,1070,797, 33439,1062,791, 674,1065,794, 
7, // chain 207
66,1071,66, 65,1067,65, 675,1068,795, 
677,1070,798, 46,1072,46, 32825,1073,57, 33442,1065,794, 59,1074,59, 32831,1066,63, 
1, // chain 208
676,1069,796, 677,1070,797, 675,1068,795, 
12, // chain 209
678,1075,799, 679,1076,800, 680,1077,801, 
681,1078,802, 32881,1079,113, 32883,1080,115, 32884,1081,116, 33450,1082,803, 33447,1076,800, 683,1083,804, 33446,1075,799, 111,1084,111, 32881,1079,113, 33449,1078,802, 
4, // chain 210
84,1085,84, 116,1081,116, 682,1082,803, 
683,1083,804, 81,1086,81, 32879,1084,111, 
2, // chain 211
684,1087,805, 685,1088,806, 686,1089,807, 
687,1090,808, 
2, // chain 212
688,1091,809, 689,1092,809, 690,1093,809, 
691,1094,809, 
2, // chain 213
692,1095,810, 693,1096,810, 694,1097,810, 
695,1098,810, 
2, // chain 214
696,1099,811, 697,1100,811, 698,1101,812, 
699,1102,812, 
2, // chain 215
700,1103,813, 701,1104,813, 702,1105,813, 
703,1106,813, 
13, // chain 216
704,1107,814, 705,1108,815, 706,1109,816, 
33475,1110,817, 708,1111,818, 709,1112,819, 710,1113,820, 33479,1114,821, 712,1115,822, 33481,1116,823, 704,1107,824, 33482,1117,825, 705,1108,826, 33483,1118,827, 707,1110,828, 
2, // chain 217
706,1109,816, 710,1113,820, 704,1107,814, 
33480,1115,822, 
2, // chain 218
716,1119,829, 62,65,62, 64,67,64, 
48,48,48, 
7, // chain 219
716,1120,830, 48,1121,48, 717,1122,831, 
33455,1123,808, 33475,1124,817, 32817,1125,49, 708,1126,818, 33477,1127,819, 33329,1128,677, 
5, // chain 220
718,1129,832, 62,1130,742, 719,1131,833, 
720,1132,834, 721,1133,835, 722,1134,836, 33481,1135,837, 
5, // chain 221
62,1130,742, 716,1120,838, 719,1131,833, 
33491,1136,839, 714,1117,840, 724,1137,841, 33489,1133,835, 
5, // chain 222
561,1128,677, 562,1138,679, 711,1139,821, 
33481,1135,823, 32830,1130,742, 725,1140,842, 33486,1129,832, 
1, // chain 223
711,1139,821, 709,1112,819, 561,1128,677, 
1, // chain 224
714,1117,840, 713,1116,837, 721,1141,835, 
5, // chain 225
715,1118,843, 714,1117,844, 726,1142,845, 
33495,1143,846, 716,1120,830, 728,1144,847, 33485,1122,831, 
3, // chain 226
717,1122,831, 729,1145,848, 715,1146,843, 
730,1147,849, 33494,1142,845, 
1, // chain 227
687,1123,808, 729,1145,848, 717,1122,831, 
2, // chain 228
458,1148,850, 451,1149,850, 468,1150,850, 
467,1151,850, 
2, // chain 229
451,1149,851, 452,1152,852, 469,1153,853, 
468,1150,854, 
2, // chain 230
452,1152,473, 453,1154,474, 472,1155,855, 
469,1153,856, 
2, // chain 231
453,1154,857, 454,1156,858, 473,1157,857, 
472,1155,859, 
2, // chain 232
454,1156,860, 455,1158,860, 474,1159,860, 
473,1157,860, 
2, // chain 233
455,1158,861, 456,1160,862, 471,1161,863, 
474,1159,864, 
2, // chain 234
456,1160,477, 457,1162,478, 470,1163,865, 
471,1161,866, 
2, // chain 235
457,1164,867, 458,1148,868, 467,1151,869, 
470,1165,870, 
2, // chain 236
85,1166,871, 86,1167,872, 435,1168,873, 
434,1169,874, 
2, // chain 237
86,1167,875, 87,1170,876, 436,1171,877, 
435,1168,878, 
2, // chain 238
87,1170,87, 88,1172,88, 439,1173,879, 
436,1171,880, 
2, // chain 239
88,1172,881, 89,1174,882, 440,1175,881, 
439,1173,883, 
2, // chain 240
89,1174,884, 90,1176,885, 441,1177,886, 
440,1175,850, 
2, // chain 241
90,1176,90, 117,1178,117, 438,1179,887, 
441,1177,888, 
2, // chain 242
117,1178,117, 118,1180,118, 437,1181,889, 
438,1179,890, 
2, // chain 243
118,1182,118, 85,1166,85, 434,1169,891, 
437,1183,892, 
1, // chain 244
355,1184,366, 354,1185,365, 356,1186,367, 
6, // chain 245
731,1187,893, 732,1188,894, 733,1189,895, 
33502,1190,896, 394,1191,410, 33503,1192,897, 33504,1193,898, 737,1194,899, 
9, // chain 246
141,1195,900, 400,1196,419, 398,1197,416, 
33506,1198,901, 33507,1199,902, 737,1200,903, 33508,1201,904, 735,1202,905, 33161,1203,906, 125,1204,907, 124,1205,908, 
1, // chain 247
398,1197,416, 142,1206,417, 141,1195,900, 
8, // chain 248
394,1191,410, 395,1207,411, 733,1189,895, 
33164,1208,413, 731,1187,893, 33165,1209,414, 741,1210,909, 33166,1211,416, 742,1212,910, 33506,1213,911, 
6, // chain 249
741,1214,909, 742,1215,910, 738,1216,912, 
731,1217,893, 33500,1218,894, 33505,1219,899, 734,1220,896, 33504,1221,898, 
14, // chain 250
192,1222,195, 393,1223,407, 743,1224,913, 
744,1225,914, 33513,1226,915, 746,1227,916, 33515,1228,917, 748,1229,918, 749,1230,919, 33518,1231,920, 33519,1232,921, 752,1233,922, 33521,1234,923, 33522,1235,924, 755,1236,925, 33524,1237,926, 
11, // chain 251
757,1238,927, 747,1239,917, 740,1240,928, 
758,1241,929, 33507,1242,902, 759,1243,930, 33524,1244,926, 754,1245,931, 758,1241,932, 33519,1246,933, 757,1238,934, 33516,1247,918, 747,1239,917, 
2, // chain 252
755,1248,925, 756,1249,926, 400,1250,419, 
33507,1251,902, 
6, // chain 253
400,1252,419, 399,1253,418, 755,1236,925, 
33528,1254,935, 32966,1255,201, 401,1256,420, 744,1225,914, 32960,1222,195, 
1, // chain 254
155,175,156, 156,176,157, 388,512,402, 
3, // chain 255
761,1257,936, 762,1258,937, 155,1259,938, 
32922,1260,939, 33531,1261,940, 
13, // chain 256
763,1261,940, 764,1262,941, 153,1263,942, 
33533,1264,943, 152,1265,944, 33534,1266,945, 150,1267,946, 33535,1268,947, 148,1269,948, 32915,1270,949, 33536,1271,950, 145,1272,951, 33537,1273,952, 144,1274,953, 33538,1275,954, 
12, // chain 257
155,1259,938, 388,1276,955, 761,1257,936, 
33539,1277,956, 33540,1278,957, 33157,1279,403, 390,1280,404, 773,1281,958, 33159,1282,959, 392,1283,960, 774,1284,961, 33155,1285,962, 144,1286,963, 770,1287,963, 
11, // chain 258
764,1288,694, 763,1289,940, 761,1290,694, 
771,1291,964, 765,1292,964, 33534,1293,945, 33540,1294,957, 773,1295,958, 767,1296,947, 33536,1297,965, 33537,1298,966, 33542,1299,967, 770,1300,694, 
1, // chain 259
763,1289,940, 762,1301,937, 761,1290,694, 
5, // chain 260
129,1302,968, 130,1303,969, 775,1304,970, 
33544,1305,971, 32899,1306,972, 134,1307,973, 777,1308,974, 
4, // chain 261
161,1309,975, 159,1310,976, 778,1311,977, 
33547,1312,978, 32926,1313,979, 780,1314,980, 
8, // chain 262
778,1311,977, 781,1315,981, 161,1309,975, 
32932,1316,982, 33550,1317,983, 166,1318,984, 33551,1319,985, 784,1320,986, 168,1321,987, 33553,1322,988, 
6, // chain 263
786,1323,989, 787,1324,990, 171,1325,991, 
33556,1326,992, 137,1327,993, 33545,1308,994, 136,1328,136, 32902,1307,134, 
3, // chain 264
786,1323,989, 171,1325,991, 170,1329,995, 
168,1330,987, 785,1322,988, 
12, // chain 265
779,1331,996, 780,1332,997, 775,1333,996, 
776,1334,971, 778,1335,998, 33549,1336,694, 33550,1337,694, 33545,1338,974, 783,1339,694, 33556,1340,694, 787,1341,694, 784,1342,694, 33554,1343,989, 785,1344,988, 
1, // chain 266
354,1345,999, 357,1346,703, 789,1347,1000, 
1, // chain 267
349,1348,360, 356,1349,1001, 790,1350,1002, 
3, // chain 268
791,1351,1003, 792,1352,1004, 793,1353,1005, 
33562,1354,1006, 33563,1355,1007, 
2, // chain 269
791,1356,1003, 793,1357,1005, 44,1358,44, 
360,1359,371, 
3, // chain 270
792,1360,1004, 791,1361,1003, 360,1362,371, 
795,1363,1007, 33083,1364,321, 
2, // chain 271
794,1365,1008, 795,1366,1007, 315,1367,321, 
42,1368,42, 
2, // chain 272
793,1369,1005, 794,1370,1009, 42,1371,42, 
44,1372,44, 
3, // chain 273
796,1373,1010, 797,1374,1011, 798,1375,1012, 
799,1376,1013, 33568,1377,1014, 
2, // chain 274
797,1374,1011, 796,1373,1015, 110,1378,110, 
32877,1379,109, 
3, // chain 275
110,1380,110, 801,1381,1016, 798,1382,1012, 
33568,1383,1014, 32890,1384,122, 
1, // chain 276
798,1382,1012, 797,1385,1011, 110,1380,110, 
2, // chain 277
799,1386,1013, 800,1387,1014, 122,1388,122, 
119,1389,119, 
2, // chain 278
796,1390,1015, 799,1391,1013, 119,1392,119, 
109,1393,109, 
15, // chain 279
802,1394,694, 803,1395,694, 789,1396,1000, 
804,1397,694, 33558,1398,1002, 33573,1399,694, 33574,1400,694, 33575,1401,1017, 33125,1402,703, 808,1403,1018, 33117,1404,360, 809,1405,1019, 33578,1406,1020, 33579,1407,1021, 33558,1398,1002, 812,1408,694, 33573,1399,694, 
6, // chain 280
813,1409,1022, 814,1410,1023, 356,1411,1001, 
354,1412,999, 815,1413,1024, 33584,1414,1025, 33557,1396,1000, 803,1395,694, 
3, // chain 281
790,1398,1002, 356,1411,1001, 814,1410,1023, 
817,1415,694, 804,1397,694, 
6, // chain 282
818,1416,1026, 819,1417,1027, 820,1418,1028, 
810,1419,1029, 33577,1420,1030, 33589,1421,1031, 33590,1422,1032, 33587,1417,1027, 
4, // chain 283
823,1423,1033, 819,1417,1027, 818,1416,1026, 
824,1424,1034, 33579,1425,1035, 33578,1419,1029, 
3, // chain 284
825,1426,1036, 826,1427,1037, 824,1424,1034, 
812,1428,1038, 33579,1425,1035, 
1, // chain 285
826,1427,1037, 823,1423,1033, 824,1424,1034, 
4, // chain 286
827,1429,1039, 826,1427,1037, 825,1426,1036, 
828,1430,1040, 33573,1431,1041, 33580,1428,1038, 
3, // chain 287
829,1432,1042, 830,1433,1043, 828,1430,1040, 
806,1434,1044, 33573,1431,1041, 
1, // chain 288
830,1433,1043, 827,1429,1039, 828,1430,1040, 
4, // chain 289
831,1435,1045, 830,1433,1043, 829,1432,1042, 
832,1436,1046, 33575,1437,1047, 33574,1434,1044, 
2, // chain 290
833,1438,1048, 831,1435,1045, 821,1421,1031, 
822,1422,1032, 
3, // chain 291
831,1435,1045, 832,1436,1046, 821,1421,1031, 
33576,1439,1049, 33575,1437,1047, 
6, // chain 292
834,1440,1050, 835,1441,1051, 836,1442,1052, 
817,1443,1053, 33572,1444,1054, 33605,1445,1055, 33606,1446,1056, 33603,1441,1051, 
4, // chain 293
839,1447,1057, 835,1441,1051, 834,1440,1050, 
840,1448,1058, 33582,1449,1059, 33585,1443,1053, 
7, // chain 294
841,1450,1060, 839,1447,1057, 842,1451,1061, 
843,1452,1062, 33612,1453,1063, 33583,1454,1064, 33581,1455,1065, 33608,1448,1058, 33607,1447,1057, 
3, // chain 295
845,1456,1066, 846,1457,1067, 844,1453,1063, 
816,1458,1068, 33583,1454,1064, 
1, // chain 296
846,1457,1067, 843,1452,1062, 844,1453,1063, 
4, // chain 297
847,1459,1069, 846,1457,1067, 845,1456,1066, 
848,1460,1070, 33571,1461,1071, 33584,1458,1068, 
3, // chain 298
837,1445,1055, 849,1462,1072, 848,1460,1070, 
802,1463,1073, 33571,1461,1071, 
1, // chain 299
849,1462,1072, 847,1459,1069, 848,1460,1070, 
1, // chain 300
838,1446,1056, 849,1462,1072, 837,1445,1055, 
1, // chain 301
808,1439,1049, 809,1420,1030, 821,1421,1031, 
3, // chain 302
850,1464,1074, 851,1465,1075, 822,1466,1032, 
33601,1467,1048, 33620,1468,1076, 
13, // chain 303
822,1466,1032, 819,1469,1027, 850,1464,1074, 
33591,1470,1033, 853,1471,1077, 33622,1472,1078, 33594,1473,1037, 855,1474,1079, 33595,1475,1039, 856,1476,1080, 33598,1477,1043, 831,1478,1045, 857,1479,1081, 33620,1480,1076, 33601,1481,1048, 
1, // chain 304
814,1449,1059, 813,1455,1065, 840,1448,1058, 
1, // chain 305
802,1463,1073, 804,1444,1054, 837,1445,1055, 
3, // chain 306
858,1482,1082, 859,1483,1083, 838,1484,1056, 
33617,1485,1072, 33628,1486,1084, 
13, // chain 307
838,1484,1056, 835,1487,1051, 858,1482,1082, 
33607,1488,1057, 861,1489,1085, 33630,1490,1086, 33609,1491,1060, 863,1492,1087, 33611,1493,1062, 864,1494,1088, 33614,1495,1067, 847,1496,1069, 865,1497,1089, 33628,1498,1084, 33617,1499,1072, 
2, // chain 308
861,1500,1085, 860,1501,1090, 859,1502,1083, 
858,1503,1082, 
2, // chain 309
853,1504,1077, 852,1505,1076, 851,1506,1075, 
850,1507,1074, 
2, // chain 310
866,1508,694, 867,1509,694, 868,1510,694, 
869,1511,694, 
2, // chain 311
855,1512,1079, 856,1513,1080, 857,1514,1081, 
854,1515,1078, 
2, // chain 312
863,1516,1087, 864,1517,1088, 865,1518,1089, 
862,1519,1091, 
4, // chain 313
870,1520,1092, 871,1521,25, 872,1522,1093, 
33641,1523,25, 33642,1524,25, 875,1525,25, 
2, // chain 314
872,1526,1093, 876,1527,1094, 877,1528,1094, 
870,1529,1092, 
4, // chain 315
878,1530,215, 877,1531,215, 876,1532,215, 
879,1533,215, 33648,1534,215, 33649,1535,215, 
2, // chain 316
881,1536,1095, 882,1537,1095, 883,1538,1095, 
880,1539,1095, 
2, // chain 317
882,1540,25, 872,1522,1093, 873,1523,25, 
883,1541,25, 
8, // chain 318
860,1542,1090, 861,1543,1085, 876,1544,1096, 
33630,1545,1091, 881,1546,1097, 33650,1547,1098, 33633,1548,1089, 872,1549,1099, 33628,1542,1090, 876,1544,1096, 
2, // chain 319
873,1550,1100, 879,1551,1100, 880,1552,1100, 
883,1553,1100, 
2, // chain 320
875,1554,694, 874,1555,694, 884,1556,694, 
885,1557,694, 
2, // chain 321
878,1558,1101, 871,1559,1101, 870,1560,1101, 
877,1561,1101, 
2, // chain 322
879,1562,963, 873,1563,963, 875,1564,963, 
885,1565,963, 
2, // chain 323
871,1566,1102, 878,1567,1102, 884,1568,1102, 
874,1569,1102, 
2, // chain 324
878,1530,215, 879,1533,215, 885,1570,215, 
884,1571,215, 
2, // chain 325
852,1505,1103, 853,1504,1104, 866,1572,1105, 
869,1573,1106, 
2, // chain 326
853,1471,1107, 854,1472,1108, 867,1574,1109, 
866,1575,1110, 
2, // chain 327
854,1515,1111, 857,1514,1112, 868,1576,1113, 
867,1577,1114, 
2, // chain 328
857,1479,1115, 852,1480,1116, 869,1578,1117, 
868,1579,1118, 
1, // chain 329
45,1580,45, 140,1581,140, 44,1582,44, 
1, // chain 330
140,159,171, 45,162,143, 143,163,144, 
2, // chain 331
886,1583,1119, 887,1584,1120, 888,1585,1121, 
889,1586,1122, 
1, // chain 332
275,867,279, 281,869,286, 280,1587,285, 
1, // chain 333
278,331,282, 293,434,299, 277,330,281, 
10, // chain 334
890,1588,1123, 277,1589,281, 891,1590,1124, 
892,1591,1125, 33661,1592,1126, 33045,1589,281, 351,1593,362, 352,1594,363, 892,1591,1125, 33658,1588,1123, 33055,1595,293, 277,1589,281, 
4, // chain 335
350,1596,361, 348,1597,359, 347,1598,358, 
286,1599,292, 33114,1600,357, 285,1601,291, 
1, // chain 336
394,523,410, 735,1602,897, 124,521,408, 
2, // chain 337
743,1603,913, 393,1604,407, 747,1605,917, 
745,1606,915, 
1, // chain 338
763,1261,940, 153,1263,942, 154,1607,939, 
1, // chain 339
775,1304,970, 894,1608,1127, 129,1302,968, 
1, // chain 340
780,1332,997, 894,1609,1128, 775,1333,996, 
2, // chain 341
158,1610,979, 129,1302,1129, 894,1608,1130, 
780,1314,980, 
6, // chain 342
755,1236,925, 760,1254,935, 753,1234,923, 
33520,1233,922, 33518,1231,920, 33512,1225,914, 749,1230,919, 33514,1227,916, 
1, // chain 343
747,1605,917, 393,1604,407, 740,1611,928, 
2, // chain 344
449,607,470, 305,368,311, 307,370,313, 
448,605,469, 
4, // chain 345
577,878,1131, 895,1612,1132, 575,874,697, 
33342,871,696, 33341,870,1133, 33345,878,1134, 
1, // chain 346
575,874,697, 576,877,698, 577,878,1131, 
1, // chain 347
801,1613,1016, 896,1614,1135, 897,1615,1136, 
4, // chain 348
22,1616,22, 122,1617,122, 898,1618,1137, 
33569,1619,1016, 899,1620,1138, 33665,1621,1136, 
3, // chain 349
22,1616,22, 898,1618,1137, 900,1622,1139, 
901,1623,1140, 563,1624,680, 
6, // chain 350
801,1625,1016, 110,1626,110, 902,1627,1141, 
33671,1628,1142, 32861,1629,93, 904,1630,1143, 33332,1631,681, 32795,1632,27, 
1, // chain 351
902,1627,1141, 896,1633,1135, 801,1625,1016, 
3, // chain 352
905,1634,1144, 906,1635,1145, 907,1636,1146, 
33672,1630,1147, 33676,1637,1148, 
2, // chain 353
909,1638,1149, 905,1634,1144, 907,1636,1146, 
900,1622,1150, 
2, // chain 354
910,1639,1151, 911,1640,1151, 912,1641,1151, 
913,1642,1151, 
1, // chain 355
914,1643,1152, 903,1644,1153, 915,1645,1154, 
2, // chain 356
916,1646,1155, 917,1647,1155, 918,1648,1155, 
919,1649,1155, 
1, // chain 357
920,1650,1156, 898,1651,1157, 921,1652,1158, 
3, // chain 358
564,1653,681, 563,1654,680, 888,1655,1121, 
33657,1656,215, 33669,1657,1140, 
2, // chain 359
901,1658,1159, 900,1659,1160, 886,1660,1119, 
889,1661,1122, 
3, // chain 360
900,1662,1160, 907,1663,1161, 886,1664,1119, 
33655,1665,1120, 33672,1666,1162, 
2, // chain 361
904,1667,1162, 564,1668,681, 888,1669,1121, 
887,1670,1120, 
2, // chain 362
896,1671,1135, 906,1672,1163, 922,1673,1164, 
923,1674,1165, 
1, // chain 363
906,1675,1163, 905,1676,215, 922,1677,1164, 
2, // chain 364
905,1678,1166, 897,1679,1136, 923,1680,1165, 
922,1681,1164, 
1, // chain 365
897,1682,1136, 896,1683,1135, 923,1684,1165, 
2, // chain 366
902,1685,1167, 908,1686,1168, 913,1687,1169, 
912,1688,1170, 
2, // chain 367
908,1689,215, 906,1690,215, 910,1691,215, 
913,1692,215, 
2, // chain 368
906,1693,1163, 896,1694,1135, 911,1695,1171, 
910,1696,1172, 
2, // chain 369
896,1697,25, 902,1698,25, 912,1699,25, 
911,1700,25, 
1, // chain 370
903,1701,1153, 904,1702,1147, 915,1703,1154, 
1, // chain 371
904,1704,1147, 908,1705,1148, 915,1706,1154, 
2, // chain 372
908,1707,1168, 902,1708,1167, 914,1709,1152, 
915,1710,1154, 
1, // chain 373
903,1711,1142, 914,1712,25, 902,1713,1141, 
1, // chain 374
898,1714,1157, 899,1715,25, 921,1716,1158, 
2, // chain 375
899,1717,1173, 909,1718,1149, 920,1719,1156, 
921,1720,1158, 
1, // chain 376
909,1721,1149, 900,1722,1150, 920,1723,1156, 
1, // chain 377
898,1724,1137, 920,1725,1174, 900,1726,1139, 
2, // chain 378
909,1727,1149, 899,1728,1173, 917,1729,1175, 
916,1730,1176, 
2, // chain 379
899,1731,25, 897,1732,25, 918,1733,25, 
917,1734,25, 
2, // chain 380
897,1735,1136, 905,1736,1166, 919,1737,1177, 
918,1738,1178, 
2, // chain 381
905,1739,215, 909,1740,215, 916,1741,215, 
919,1742,215, 
1, // chain 382
687,1743,808, 707,1744,817, 684,1745,805, 
2, // chain 383
707,1746,828, 715,1747,827, 685,1748,1179, 
684,1749,1180, 
2, // chain 384
715,1750,843, 729,1751,848, 686,1752,1181, 
685,1753,1182, 
1, // chain 385
687,1754,808, 686,1755,1183, 729,1756,848, 
2, // chain 386
717,1757,831, 730,1758,849, 688,1759,1184, 
691,1760,1185, 
2, // chain 387
730,1147,849, 726,1761,845, 689,1762,1186, 
688,1763,1187, 
2, // chain 388
726,1764,845, 728,1765,847, 690,1766,1188, 
689,1767,1189, 
2, // chain 389
728,1768,847, 717,1769,831, 691,1770,1190, 
690,1771,1191, 
2, // chain 390
716,1772,830, 727,1773,846, 692,1774,1192, 
695,1775,1193, 
2, // chain 391
727,1776,846, 714,1777,844, 693,1778,1194, 
692,1779,1195, 
2, // chain 392
714,1780,840, 723,1781,839, 694,1782,1196, 
693,1783,1197, 
2, // chain 393
723,1784,839, 716,1785,838, 695,1786,1198, 
694,1787,1199, 
2, // chain 394
719,1788,833, 724,1789,841, 696,1790,1200, 
699,1791,1201, 
2, // chain 395
724,1792,841, 721,1793,835, 697,1794,1202, 
696,1795,1203, 
2, // chain 396
721,1796,835, 720,1797,834, 698,1798,1204, 
697,1799,1205, 
2, // chain 397
720,1800,834, 719,1801,833, 699,1802,1206, 
698,1803,1207, 
2, // chain 398
718,1804,832, 722,1805,836, 700,1806,1208, 
703,1807,1209, 
2, // chain 399
722,1808,836, 713,1809,837, 701,1810,1210, 
700,1811,1211, 
2, // chain 400
713,1812,823, 725,1813,842, 702,1814,1212, 
701,1815,1213, 
2, // chain 401
725,1816,842, 718,1817,832, 703,1818,1214, 
702,1819,1215, 
2, // chain 402
36,1820,36, 633,1821,734, 611,1822,1216, 
614,1823,1217, 
2, // chain 403
633,1824,1218, 33,1825,1219, 612,1826,1220, 
611,1827,215, 
2, // chain 404
33,1828,33, 34,1829,34, 613,1830,1221, 
612,1831,1222, 
2, // chain 405
34,1832,34, 36,1833,36, 614,1834,1223, 
613,1835,1224, 
2, // chain 406
41,1836,41, 51,1837,51, 615,1838,1225, 
618,1839,1226, 
2, // chain 407
51,1840,51, 52,1841,52, 616,1842,1227, 
615,1843,1228, 
2, // chain 408
52,1844,52, 635,1845,736, 617,1846,1229, 
616,1847,1230, 
2, // chain 409
635,1848,1231, 41,1849,1232, 618,1850,1233, 
617,1851,25, 
2, // chain 410
40,1852,40, 636,1853,737, 619,1854,1234, 
622,1855,1235, 
2, // chain 411
636,1856,1236, 631,1857,1237, 620,1858,1238, 
619,1859,215, 
2, // chain 412
631,1860,738, 637,1861,739, 621,1862,1239, 
620,1863,1240, 
2, // chain 413
637,1864,1241, 40,1865,1242, 622,1866,1243, 
621,1867,25, 
2, // chain 414
37,1868,37, 631,1869,738, 623,1870,1244, 
626,1871,1245, 
2, // chain 415
631,1872,732, 54,1873,54, 624,1874,1246, 
623,1875,1247, 
2, // chain 416
54,1876,54, 632,1877,740, 625,1878,1248, 
624,1879,1249, 
2, // chain 417
632,1880,733, 37,1881,37, 626,1882,1250, 
625,1883,1251, 
2, // chain 418
632,1884,740, 638,1885,741, 627,1886,1252, 
630,1887,1253, 
2, // chain 419
638,1888,1254, 55,1889,1255, 628,1890,1256, 
627,1891,215, 
2, // chain 420
55,1892,55, 634,1893,735, 629,1894,1257, 
628,1895,1258, 
2, // chain 421
634,1896,1259, 632,1897,1260, 630,1898,1261, 
629,1899,25, 
2, // chain 422
100,1900,100, 99,1901,99, 583,1902,1262, 
586,1903,1263, 
2, // chain 423
99,1904,99, 97,1905,97, 584,1906,1264, 
583,1907,1265, 
2, // chain 424
97,1908,97, 608,1909,722, 585,1910,1266, 
584,1911,1267, 
2, // chain 425
608,1912,1268, 100,1913,1269, 586,1914,1270, 
585,1915,25, 
2, // chain 426
103,1916,103, 607,1917,721, 587,1918,1271, 
590,1919,1272, 
2, // chain 427
607,1920,1273, 606,1921,1274, 588,1922,1275, 
587,1923,215, 
2, // chain 428
606,1924,723, 609,1925,724, 589,1926,1276, 
588,1927,1277, 
2, // chain 429
609,1928,1278, 103,1929,1279, 590,1930,1280, 
589,1931,25, 
2, // chain 430
104,1932,104, 606,1933,723, 591,1934,1281, 
594,1935,1282, 
2, // chain 431
606,1936,720, 95,1937,95, 592,1938,1283, 
591,1939,1284, 
2, // chain 432
95,1940,95, 603,1941,725, 593,1942,1285, 
592,1943,1286, 
2, // chain 433
603,1944,717, 104,1945,104, 594,1946,1287, 
593,1947,1288, 
2, // chain 434
603,1948,725, 610,1949,726, 595,1950,1289, 
598,1951,1290, 
2, // chain 435
610,1952,1291, 94,1953,1292, 596,1954,1293, 
595,1955,215, 
2, // chain 436
94,1956,94, 604,1957,718, 597,1958,1294, 
596,1959,1295, 
2, // chain 437
604,1960,1296, 603,1961,1297, 598,1962,1298, 
597,1963,25, 
2, // chain 438
106,1964,106, 605,1965,719, 599,1966,1299, 
602,1967,1300, 
2, // chain 439
605,1968,1301, 93,1969,1302, 600,1970,1303, 
599,1971,215, 
2, // chain 440
93,1972,93, 108,1973,108, 601,1974,1304, 
600,1975,1305, 
2, // chain 441
108,1976,108, 106,1977,106, 602,1978,1306, 
601,1979,1307, 
2, // chain 442
924,1980,1308, 925,1981,1309, 926,1982,1310, 
927,1983,1311, 
2, // chain 443
925,1984,1309, 928,1985,1312, 929,1986,1313, 
926,1982,1310, 
2, // chain 444
928,1987,1314, 924,1988,1315, 927,1983,1316, 
929,1986,1313, 
4, // chain 445
927,1989,1311, 926,1990,1310, 930,1991,1317, 
931,1992,1318, 33694,1993,1310, 929,1994,1313, 
1, // chain 446
929,1995,1313, 927,1996,1316, 931,1992,1318, 
2, // chain 447
932,1997,1308, 933,1998,1309, 934,1999,1310, 
935,2000,1311, 
2, // chain 448
933,2001,1309, 936,2002,1312, 937,2003,1313, 
934,1999,1310, 
2, // chain 449
936,2004,1314, 932,2005,1315, 935,2000,1316, 
937,2003,1313, 
4, // chain 450
935,2006,1311, 934,2007,1310, 938,2008,1319, 
939,2009,1318, 33702,2010,1310, 937,2011,1313, 
1, // chain 451
937,2012,1313, 935,2013,1316, 939,2009,1318, 
2, // chain 452
940,2014,1308, 941,2015,1309, 942,2016,1310, 
943,2017,1311, 
2, // chain 453
941,2018,1309, 944,2019,1320, 945,2020,1313, 
942,2016,1310, 
2, // chain 454
944,2021,1314, 940,2022,1315, 943,2017,1316, 
945,2020,1313, 
4, // chain 455
943,2023,1311, 942,2024,1310, 946,2025,1319, 
947,2026,1318, 33710,2027,1310, 945,2028,1313, 
1, // chain 456
945,2029,1313, 943,2030,1316, 947,2026,1318, 
2, // chain 457
948,2031,1308, 949,2032,1309, 950,2033,1310, 
951,2034,1311, 
2, // chain 458
949,2035,1309, 952,2036,1312, 953,2037,1313, 
950,2033,1310, 
2, // chain 459
952,2038,1314, 948,2039,1315, 951,2034,1316, 
953,2037,1313, 
4, // chain 460
951,2040,1311, 950,2041,1310, 954,2042,1319, 
955,2043,1318, 33718,2044,1310, 953,2045,1313, 
1, // chain 461
953,2046,1313, 951,2047,1316, 955,2043,1318, 
2, // chain 462
956,2048,1308, 957,2049,1309, 958,2050,1310, 
959,2051,1311, 
2, // chain 463
957,2052,1309, 960,2053,1320, 961,2054,1313, 
958,2050,1310, 
2, // chain 464
960,2055,1314, 956,2056,1315, 959,2051,1316, 
961,2054,1313, 
4, // chain 465
959,2057,1311, 958,2058,1310, 962,2059,1319, 
963,2060,1321, 33726,2061,1310, 961,2062,1313, 
1, // chain 466
961,2063,1313, 959,2064,1316, 963,2060,1321, 
2, // chain 467
964,2065,1308, 965,2066,1309, 966,2067,1310, 
967,2068,1311, 
2, // chain 468
965,2069,1309, 968,2070,1312, 969,2071,1313, 
966,2067,1310, 
2, // chain 469
968,2072,1314, 964,2073,1315, 967,2068,1316, 
969,2071,1313, 
4, // chain 470
967,2074,1311, 966,2075,1310, 970,2076,1319, 
971,2077,1318, 33734,2078,1310, 969,2079,1313, 
1, // chain 471
969,2080,1313, 967,2081,1316, 971,2077,1318, 
20, // chain 472
972,2082,1322, 973,2083,1323, 974,2084,1324, 
975,2085,1325, 33744,2086,1326, 33745,2087,1327, 33746,2088,1328, 33741,2083,1323, 979,2089,1329, 33748,2090,1330, 33740,2082,1322, 975,2085,1325, 981,2091,1331, 33744,2086,1326, 982,2092,1332, 33751,2093,1333, 984,2094,1334, 33753,2095,1335, 986,2096,1336, 
987,2097,1337, 982,2092,1332, 33756,2098,1338, 
4, // chain 473
989,2099,1339, 990,2100,1340, 991,2101,1341, 
992,2102,1342, 33761,2103,1343, 33762,2104,1344, 
8, // chain 474
995,2105,1345, 979,2089,1329, 980,2090,1330, 
996,2106,1346, 997,2107,1347, 33766,2108,1348, 999,2109,1349, 994,2110,1344, 991,2111,1341, 995,2105,1345, 
4, // chain 475
1000,2112,1350, 1001,2113,1351, 998,2114,1348, 
33756,2115,1338, 987,2116,1337, 999,2117,1349, 
2, // chain 476
977,2087,1327, 1002,2118,1352, 1003,2119,1353, 
976,2086,1326, 
7, // chain 477
1002,2118,1352, 977,2087,1327, 1004,2120,1354, 
1005,2121,1355, 33774,2122,1356, 1007,2123,1357, 1008,2124,1358, 1009,2125,1359, 1002,2118,1352, 
4, // chain 478
1010,2126,1360, 1011,2127,1361, 1012,2128,1362, 
1006,2129,1356, 33775,2130,1357, 33781,2131,1363, 
2, // chain 479
1014,2132,1364, 1015,2133,1365, 978,2088,1328, 
979,2089,1329, 
7, // chain 480
1016,2134,1366, 978,2088,1328, 1015,2133,1365, 
1017,2135,1367, 33760,2136,1342, 993,2137,1343, 1013,2138,1363, 1012,2139,1362, 1016,2134,1366, 
3, // chain 481
985,2140,1335, 1018,2141,1368, 1009,2142,1359, 
986,2143,1336, 33776,2144,1358, 
2, // chain 482
1015,2145,1365, 1014,2146,1364, 989,2147,1339, 
992,2148,1342, 
4, // chain 483
995,2149,1345, 991,2150,1341, 990,2151,1340, 
979,2152,1329, 33757,2147,1339, 1014,2146,1364, 
5, // chain 484
1000,2153,1350, 998,2154,1348, 980,2155,1330, 
981,2156,1331, 1001,2157,1369, 33750,2158,1332, 988,2159,1338, 
1, // chain 485
998,2154,1348, 996,2160,1346, 980,2155,1330, 
4, // chain 486
1018,2161,1368, 985,2162,1335, 976,2163,1326, 
1003,2164,1353, 1002,2165,1352, 1009,2166,1359, 
1, // chain 487
985,2162,1335, 983,2167,1333, 976,2163,1326, 
2, // chain 488
1004,2168,1354, 977,2169,1327, 1010,2170,1370, 
1006,2171,1356, 
4, // chain 489
978,2172,1328, 1016,2173,1366, 1012,2174,1362, 
1011,2175,1361, 1010,2170,1370, 977,2169,1327, 
10, // chain 490
1019,2176,1371, 1020,2177,1372, 1021,2178,1373, 
1022,2179,1374, 33791,2180,1375, 33792,2181,1376, 33788,2177,1372, 1025,2182,1377, 33787,2176,1371, 1022,2179,1374, 1026,2183,1378, 33791,2180,1375, 
4, // chain 491
1027,2184,1379, 1028,2185,1380, 1029,2186,1381, 
1030,2187,1382, 1031,2188,1383, 1032,2189,1384, 
8, // chain 492
1033,2190,1385, 1034,2191,1386, 1024,2181,1387, 
33803,2192,1388, 33804,2193,1389, 33795,2194,1379, 1032,2195,1384, 1037,2196,1390, 1038,2197,1391, 1035,2192,1388, 
4, // chain 493
1039,2198,1392, 1040,2199,1393, 1041,2200,1394, 
1038,2201,1391, 1042,2202,1395, 33805,2203,1390, 
5, // chain 494
1023,2180,1396, 1043,2204,1397, 1044,2205,1398, 
1045,2206,1399, 33814,2207,1400, 33810,2208,1395, 33807,2209,1392, 
2, // chain 495
1047,2210,1401, 1026,2183,1402, 1048,2211,1403, 
33791,2180,1396, 
2, // chain 496
1049,2212,1404, 1025,2182,1405, 1050,2213,1406, 
33794,2183,1402, 
4, // chain 497
1051,2214,1407, 1052,2215,1408, 1053,2216,1409, 
1054,2217,1410, 33823,2218,1411, 33824,2219,1412, 
4, // chain 498
1048,2211,1403, 1057,2220,1413, 1047,2210,1401, 
33826,2221,1414, 33823,2222,1411, 33822,2223,1410, 
7, // chain 499
1050,2213,1406, 1059,2224,1415, 1049,2212,1404, 
33828,2225,1416, 33829,2226,1417, 1062,2227,1418, 1031,2228,1383, 1030,2229,1382, 1049,2212,1404, 
3, // chain 500
1053,2230,1409, 1045,2206,1399, 1046,2207,1400, 
1056,2231,1412, 33810,2208,1395, 
3, // chain 501
1061,2232,1417, 1063,2233,1419, 1064,2234,1420, 
1058,2235,1414, 1062,2236,1418, 
1, // chain 502
1047,2210,1401, 1058,2221,1414, 1064,2237,1420, 
1, // chain 503
1024,2181,1387, 1025,2182,1405, 1033,2190,1385, 
1, // chain 504
1023,2180,1396, 1024,2181,1387, 1043,2204,1397, 
2, // chain 505
1025,2238,1405, 1049,2239,1404, 1029,2240,1381, 
33798,2241,1382, 
3, // chain 506
1034,2242,1386, 1033,2243,1385, 1028,2244,1380, 
33797,2240,1381, 33793,2238,1405, 
1, // chain 507
1028,2244,1380, 1027,2245,1379, 1034,2242,1386, 
6, // chain 508
1024,2246,1387, 1035,2247,1388, 1038,2248,1391, 
1041,2249,1394, 1043,2250,1397, 33808,2251,1393, 1044,2252,1398, 33807,2253,1392, 
6, // chain 509
1023,2254,1396, 1045,2255,1399, 1053,2256,1409, 
1052,2257,1408, 1051,2258,1407, 1048,2259,1403, 33825,2260,1413, 33822,2261,1410, 
4, // chain 510
1064,2262,1420, 1063,2263,1419, 1026,2264,1402, 
33818,2265,1406, 33829,2266,1417, 1059,2267,1415, 
1, // chain 511
1026,2264,1402, 1047,2268,1401, 1064,2262,1420, 
4, // chain 512
1065,2269,1421, 1066,2270,1422, 1067,2271,1423, 
33836,2272,1424, 33837,2273,1425, 1070,2274,1426, 
9, // chain 513
1067,2271,1423, 1071,2275,1427, 1065,2269,1421, 
33840,2276,1428, 33841,2277,1429, 1074,2278,1430, 33843,2279,1431, 1076,2280,1432, 33845,2281,1433, 1070,2282,1426, 33836,2283,1424, 
2, // chain 514
1066,2284,1422, 1065,2285,1421, 1074,2286,1430, 
33840,2287,1428, 
3, // chain 515
1076,2288,1432, 1070,2289,1426, 1074,2286,1430, 
33837,2290,1425, 1066,2284,1422, 
6, // chain 516
1078,2291,1434, 1079,2292,1435, 1080,2293,1436, 
33849,2294,1437, 33850,2295,1438, 1083,2296,1439, 1084,2297,1440, 33853,2298,1441, 
8, // chain 517
1080,2293,1436, 1086,2299,1442, 1078,2291,1434, 
33855,2300,1443, 33856,2301,1444, 1089,2302,1445, 33858,2303,1446, 1085,2304,1441, 33859,2305,1447, 1084,2306,1440, 
2, // chain 518
1079,2307,1435, 1078,2308,1434, 1089,2309,1445, 
33855,2310,1443, 
3, // chain 519
1085,2311,1441, 1083,2312,1439, 1089,2309,1445, 
33850,2313,1438, 1079,2307,1435, 
8, // chain 520
1092,2314,1448, 1093,2315,1449, 1094,2316,1450, 
1095,2317,1451, 33864,2318,1452, 33865,2319,1453, 33861,2315,1449, 1092,2314,1448, 1098,2320,1454, 33863,2317,1451, 
1, // chain 521
1097,2319,1453, 1098,2320,1454, 1096,2318,1452, 
6, // chain 522
1096,2318,1452, 1098,2320,1455, 1099,2321,1456, 
1100,2322,1457, 1095,2317,1451, 33869,2323,1458, 1098,2320,1455, 33867,2321,1456, 
2, // chain 523
1099,2321,1459, 1101,2323,1460, 1102,2324,1461, 
1100,2322,1462, 
4, // chain 524
1103,2325,1463, 1102,2324,1461, 1101,2323,1460, 
1104,2326,1464, 33868,2322,1465, 1102,2324,1466, 
5, // chain 525
1102,2324,1467, 1103,2325,1463, 1105,2327,1468, 
1106,2328,1469, 33871,2325,1463, 1104,2326,1464, 1102,2324,1467, 
9, // chain 526
1107,2329,1470, 1108,2330,1471, 1109,2331,1472, 
1110,2332,1473, 33876,2330,1471, 1111,2333,1474, 33880,2334,1475, 33875,2329,1470, 1113,2335,1476, 33878,2332,1473, 1111,2333,1474, 
7, // chain 527
1114,2336,1477, 1111,2333,1478, 1115,2337,1479, 
1116,2338,1480, 33885,2339,1481, 33886,2340,1482, 33887,2341,1483, 33880,2334,1475, 33879,2333,1478, 
3, // chain 528
1112,2334,1475, 1113,2335,1476, 1119,2341,1483, 
33882,2336,1477, 33879,2333,1478, 
2, // chain 529
1116,2338,1480, 1118,2340,1482, 1119,2341,1483, 
1114,2336,1477, 
4, // chain 530
1120,2342,1484, 1116,2338,1480, 1121,2343,1485, 
1117,2339,1486, 1118,2340,1487, 1116,2338,1488, 
1, // chain 531
1116,2338,1480, 1117,2339,1481, 1121,2343,1485, 
2, // chain 532
1122,2344,1489, 1123,2345,1489, 1124,2346,1489, 
1125,2347,1489, 
1, // chain 533
1126,2348,1490, 1127,2349,1491, 1123,2350,1492, 
1, // chain 534
1123,2350,1493, 1122,2351,1493, 1126,2348,1493, 
1, // chain 535
1127,2352,1491, 1126,2353,1490, 1125,2354,1494, 
1, // chain 536
1125,2354,1495, 1124,2355,1495, 1127,2352,1495, 
2, // chain 537
1128,2356,1496, 1129,2357,1496, 1130,2358,1496, 
1131,2359,1496, 
1, // chain 538
1128,2360,1497, 1131,2361,1497, 1132,2362,1497, 
1, // chain 539
1132,2362,1498, 1133,2363,1498, 1128,2360,1498, 
1, // chain 540
1130,2364,1499, 1129,2365,1499, 1133,2366,1499, 
1, // chain 541
1133,2366,1500, 1132,2367,1500, 1130,2364,1500, 
2, // chain 542
1134,2368,1501, 1135,2369,1501, 1136,2370,1501, 
1137,2371,1501, 
1, // chain 543
1138,2372,1502, 1139,2373,1503, 1135,2374,1504, 
1, // chain 544
1135,2374,1505, 1134,2375,1505, 1138,2372,1505, 
1, // chain 545
1139,2376,1503, 1138,2377,1502, 1137,2378,1494, 
1, // chain 546
1137,2378,1495, 1136,2379,1495, 1139,2376,1495, 
2, // chain 547
1140,2380,1489, 1141,2381,1489, 1142,2382,1489, 
1143,2383,1489, 
1, // chain 548
1144,2384,1490, 1145,2385,1491, 1141,2386,1492, 
1, // chain 549
1141,2386,1506, 1140,2387,1506, 1144,2384,1506, 
1, // chain 550
1145,2388,1491, 1144,2389,1490, 1143,2390,1494, 
1, // chain 551
1143,2390,1495, 1142,2391,1495, 1145,2388,1495, 
2, // chain 552
1146,2392,1496, 1147,2393,1496, 1148,2394,1496, 
1149,2395,1496, 
1, // chain 553
1146,2396,1497, 1149,2397,1497, 1150,2398,1497, 
1, // chain 554
1150,2398,1498, 1151,2399,1498, 1146,2396,1498, 
1, // chain 555
1148,2400,1499, 1147,2401,1499, 1151,2402,1499, 
1, // chain 556
1151,2402,1500, 1150,2403,1500, 1148,2400,1500, 
2, // chain 557
1152,2404,1507, 1153,2405,1507, 1154,2406,1507, 
1155,2407,1507, 
1, // chain 558
1152,2408,1497, 1155,2409,1497, 1156,2410,1497, 
1, // chain 559
1156,2410,1498, 1157,2411,1498, 1152,2408,1498, 
1, // chain 560
1154,2412,1499, 1153,2413,1499, 1157,2414,1499, 
1, // chain 561
1157,2414,1500, 1156,2415,1500, 1154,2412,1500, 
2, // chain 562
1158,2416,1508, 1159,2417,1508, 1160,2418,1508, 
1161,2419,1508, 
1, // chain 563
1162,2420,1509, 1163,2421,1491, 1159,2422,1492, 
1, // chain 564
1159,2422,1493, 1158,2423,1493, 1162,2420,1493, 
1, // chain 565
1163,2424,1491, 1162,2425,1509, 1161,2426,1494, 
1, // chain 566
1161,2426,1495, 1160,2427,1495, 1163,2424,1495, 
2, // chain 567
1164,2428,1508, 1165,2429,1508, 1166,2430,1508, 
1167,2431,1508, 
1, // chain 568
1168,2432,1509, 1169,2433,1491, 1165,2434,1492, 
1, // chain 569
1165,2434,1493, 1164,2435,1493, 1168,2432,1493, 
1, // chain 570
1169,2436,1491, 1168,2437,1509, 1167,2438,1494, 
1, // chain 571
1167,2438,1510, 1166,2439,1510, 1169,2436,1510, 
2, // chain 572
1170,2440,1489, 1171,2441,1489, 1172,2442,1489, 
1173,2443,1489, 
1, // chain 573
1174,2444,1511, 1175,2445,1491, 1171,2446,1492, 
1, // chain 574
1171,2446,1493, 1170,2447,1493, 1174,2444,1493, 
1, // chain 575
1175,2448,1491, 1174,2449,1511, 1173,2450,1494, 
1, // chain 576
1173,2450,1495, 1172,2451,1495, 1175,2448,1495, 
16, // chain 577
1176,2452,1512, 1177,2453,1513, 1178,2454,1514, 
33947,2455,1515, 33948,2456,1516, 1181,2457,1517, 1182,2458,1518, 33951,2459,1519, 33952,2460,1520, 1185,2461,1521, 33954,2462,1522, 1187,2463,1523, 1188,2464,1524, 33957,2465,1525, 1190,2466,1526, 33959,2467,1527, 1192,2468,1528, 33961,2469,1529, 
6, // chain 578
1178,2454,1514, 1194,2470,1530, 1176,2452,1512, 
33963,2471,1531, 1196,2472,1532, 33965,2473,1533, 1193,2474,1529, 33960,2475,1528, 
4, // chain 579
1198,2476,1534, 1199,2477,1535, 1200,2478,1536, 
1201,2479,1537, 33970,2480,1538, 1203,2481,1539, 
3, // chain 580
1200,2478,1540, 1199,2477,1541, 1204,2482,1542, 
1205,2483,1543, 1202,2480,1544, 
3, // chain 581
1204,2482,1545, 1206,2484,1546, 1207,2485,1547, 
1205,2483,1548, 33976,2486,1549, 
3, // chain 582
1207,2485,25, 1206,2484,25, 1209,2487,25, 
1210,2488,25, 1208,2486,25, 
4, // chain 583
1211,2489,1550, 1212,2490,1551, 1213,2491,1552, 
1214,2492,1553, 33983,2493,1554, 33984,2494,1555, 
3, // chain 584
1213,2491,1556, 1212,2490,1557, 1217,2495,1558, 
1218,2496,1559, 1216,2494,1560, 
2, // chain 585
1219,2497,1561, 1220,2498,1562, 1221,2499,1563, 
1222,2500,1564, 
3, // chain 586
1220,2498,1565, 1219,2497,1566, 1201,2479,1567, 
1223,2501,1568, 33971,2481,1569, 
1, // chain 587
1219,2497,1566, 1198,2476,1570, 1201,2479,1567, 
5, // chain 588
1224,2502,1571, 1225,2503,1572, 1226,2504,1573, 
1227,2505,1574, 33996,2506,1575, 1229,2507,1576, 33998,2508,1577, 
4, // chain 589
1226,2504,1578, 1225,2503,1579, 1214,2492,1580, 
1228,2506,1581, 33983,2493,1582, 1230,2508,1583, 
1, // chain 590
1225,2503,1579, 1211,2489,1584, 1214,2492,1580, 
2, // chain 591
1210,2488,1585, 1209,2487,1586, 1227,2505,1587, 
1229,2507,1588, 
1, // chain 592
1209,2487,1586, 1224,2502,1589, 1227,2505,1587, 
2, // chain 593
1223,2501,1590, 1231,2509,1591, 1221,2499,1563, 
1220,2498,1562, 
2, // chain 594
1218,2510,1592, 1217,2511,1593, 1232,2512,1594, 
1233,2513,1595, 
1, // chain 595
1217,2511,1593, 1233,2514,1596, 1232,2512,1594, 
6, // chain 596
1231,2515,1591, 1223,2516,1590, 1234,2517,1597, 
1232,2518,1598, 34003,2519,1599, 1236,2520,1600, 33990,2521,1564, 33987,2522,1561, 
5, // chain 597
1234,2517,1601, 1223,2516,1568, 1203,2523,1569, 
1237,2524,1602, 1235,2519,1603, 33966,2525,1570, 1219,2522,1566, 
5, // chain 598
1202,2526,1544, 1205,2527,1543, 1238,2528,1604, 
1239,2529,1605, 34008,2530,1606, 1199,2531,1541, 33972,2532,1542, 
5, // chain 599
1238,2528,1607, 1205,2527,1548, 1208,2533,1549, 
1241,2534,1608, 1240,2530,1609, 33974,2535,1546, 1204,2532,1545, 
4, // chain 600
1208,2533,25, 1210,2536,25, 1242,2537,25, 
1241,2534,25, 33974,2535,25, 33977,2538,25, 
4, // chain 601
1242,2537,1610, 1210,2536,1585, 1229,2539,1588, 
1243,2540,1611, 1224,2541,1589, 1209,2538,1586, 
4, // chain 602
1203,2523,1539, 1202,2526,1538, 1239,2529,1612, 
1237,2524,1613, 33967,2531,1535, 1198,2525,1534, 
4, // chain 603
1243,2540,1614, 1229,2539,1576, 1244,2542,1615, 
1245,2543,1616, 1224,2541,1571, 33993,2544,1572, 
1, // chain 604
1229,2539,1576, 1230,2545,1577, 1244,2542,1615, 
4, // chain 605
1244,2542,1617, 1230,2545,1583, 1246,2546,1618, 
1245,2543,1619, 33979,2547,1584, 1225,2544,1579, 
1, // chain 606
1230,2545,1583, 1215,2548,1582, 1246,2546,1618, 
4, // chain 607
1246,2546,1620, 1215,2548,1554, 1216,2549,1555, 
1247,2550,21, 1212,2551,1551, 1211,2547,1550, 
3, // chain 608
1247,2550,1621, 1216,2549,1560, 1248,2552,1622, 
1212,2551,1557, 34017,2553,1623, 
1, // chain 609
1216,2549,1560, 1218,2554,1559, 1248,2552,1622, 
1, // chain 610
1218,2510,1592, 1233,2555,1595, 1248,2556,1624, 
2, // chain 611
1249,2557,1625, 1248,2556,1624, 1232,2558,1626, 
1233,2559,1596, 
1, // chain 612
1248,2556,1624, 1233,2560,1595, 1232,2558,1626, 
1, // chain 613
1212,2490,1557, 1249,2561,1623, 1217,2495,1558, 
1, // chain 614
1249,2557,1625, 1233,2562,1596, 1217,2511,1593, 
3, // chain 615
1232,2563,1598, 1236,2564,1600, 1231,2565,1591, 
33990,2566,215, 1221,2567,1563, 
3, // chain 616
1250,2568,1627, 1251,2569,1628, 1252,2570,1629, 
34021,2571,1630, 1254,2572,1631, 
8, // chain 617
1252,2570,1629, 1255,2573,1632, 1250,2568,1627, 
34024,2574,1633, 34025,2575,1634, 1258,2576,1635, 34027,2577,1636, 1260,2578,1637, 34029,2579,1638, 34030,2580,1639, 
12, // chain 618
1263,2581,1640, 1258,2576,1635, 1260,2578,1637, 
1264,2582,1641, 1265,2583,1642, 34034,2584,1643, 1267,2585,1644, 34036,2586,1645, 1269,2587,1646, 34038,2588,1647, 1271,2589,1648, 1272,2590,1649, 34041,2591,1650, 1274,2592,1651, 
17, // chain 619
1275,2593,1652, 1276,2594,1653, 1277,2595,1654, 
1278,2596,1655, 34047,2597,1656, 1280,2598,1657, 1262,2599,1639, 34049,2600,1658, 34050,2601,1659, 1283,2602,1660, 34052,2603,1661, 1285,2604,1662, 34054,2605,1663, 1287,2606,1664, 1288,2607,1665, 34057,2608,1666, 34058,2609,1667, 1273,2610,1650, 34042,2611,1651, 
3, // chain 620
1291,2612,1668, 1277,2595,1654, 1276,2594,1653, 
1254,2613,1631, 1253,2614,1630, 
1, // chain 621
1281,2600,1658, 1261,2615,1638, 1262,2599,1639, 
5, // chain 622
1251,2616,1628, 1250,2617,1627, 1277,2618,1654, 
34047,2619,1656, 34024,2620,1633, 1280,2621,1657, 34026,2622,1635, 
2, // chain 623
1277,2618,1654, 1291,2623,1668, 1251,2616,1628, 
34021,2624,1630, 
2, // chain 624
1276,2625,1653, 1275,2626,1652, 1252,2627,1629, 
1254,2628,1631, 
5, // chain 625
1255,2629,1632, 1252,2627,1629, 1275,2626,1652, 
1278,2630,1655, 1257,2631,1634, 34030,2632,1639, 1259,2633,1636, 
2, // chain 626
1258,2576,1635, 1263,2581,1640, 1282,2634,1659, 
1280,2635,1657, 
11, // chain 627
1261,2636,1638, 1281,2637,1658, 1260,2638,1637, 
34051,2639,1660, 1264,2640,1641, 34034,2641,1643, 34053,2642,1662, 1268,2643,1645, 34038,2644,1647, 34056,2645,1665, 1271,2646,1648, 34057,2647,1666, 1273,2648,1650, 
9, // chain 628
1282,2649,1659, 1263,2650,1640, 1265,2651,1642, 
1284,2652,1661, 34054,2653,1663, 34035,2654,1644, 1269,2655,1646, 1287,2656,1664, 34058,2657,1667, 34040,2658,1649, 1274,2659,1651, 
2, // chain 629
1292,2660,1669, 1293,2661,1670, 1294,2662,1671, 
1295,2663,1672, 
2, // chain 630
1296,2664,1673, 1294,2662,1674, 1293,2661,1675, 
1295,2665,1676, 
2, // chain 631
1295,2663,1677, 1293,2666,1678, 1297,2667,1679, 
1292,2660,1680, 
9, // chain 632
1298,2668,1681, 1299,2669,1682, 1300,2670,1683, 
1301,2671,1684, 1302,2672,1685, 34071,2673,1686, 1304,2674,1687, 34073,2675,1688, 34074,2676,1689, 34075,2677,1690, 34076,2678,1691, 
3, // chain 633
1309,2679,1692, 1300,2670,1683, 1299,2669,1682, 
1310,2680,1693, 34079,2681,1694, 
7, // chain 634
1312,2682,1695, 1313,2683,1696, 1314,2684,1697, 
1315,2685,1698, 34084,2686,1699, 1317,2687,1700, 34086,2688,1701, 1319,2689,1702, 34088,2690,1703, 
3, // chain 635
1321,2691,1704, 1322,2692,1705, 1323,2693,1706, 
34079,2694,1694, 34078,2695,1693, 
7, // chain 636
1323,2693,1706, 1324,2696,1707, 1321,2691,1704, 
34093,2697,1708, 1326,2698,1709, 34076,2699,1691, 34095,2700,1710, 1328,2701,1711, 34097,2702,1712, 
11, // chain 637
1307,2703,1690, 1308,2699,1691, 1328,2701,1711, 
1330,2704,1713, 1331,2705,1714, 34100,2706,1715, 1333,2707,1716, 34102,2708,1717, 34103,2709,1718, 1336,2710,1719, 1337,2711,1720, 34087,2712,1702, 1320,2713,1703, 
2, // chain 638
1322,2714,1705, 1321,2715,1704, 1309,2716,1692, 
1310,2717,1693, 
5, // chain 639
1300,2718,1683, 1309,2716,1692, 1321,2715,1704, 
1326,2719,1709, 1301,2720,1684, 34076,2721,1691, 1303,2722,1686, 
5, // chain 640
1299,2723,1682, 1298,2724,1681, 1324,2725,1707, 
34093,2726,1708, 34070,2727,1685, 1327,2728,1710, 34072,2729,1687, 
2, // chain 641
1324,2725,1707, 1323,2730,1706, 1299,2723,1682, 
34079,2731,1694, 
2, // chain 642
1304,2674,1687, 1305,2675,1688, 1329,2732,1712, 
1327,2733,1710, 
10, // chain 643
1328,2734,1711, 1329,2735,1712, 1338,2736,1721, 
1330,2737,1713, 34081,2738,1696, 1332,2739,1715, 34080,2740,1695, 1315,2741,1698, 1335,2742,1718, 34085,2743,1700, 1336,2744,1719, 34087,2745,1702, 
2, // chain 644
1339,2746,1722, 1306,2747,1689, 1331,2748,1714, 
34075,2749,1690, 
4, // chain 645
1316,2750,1699, 1314,2751,1697, 1334,2752,1717, 
34101,2753,1716, 34099,2748,1714, 34107,2746,1722, 
4, // chain 646
1338,2754,1721, 1305,2675,1688, 1306,2676,1689, 
1339,2755,1722, 1313,2683,1696, 34082,2684,1697, 
3, // chain 647
1337,2756,1720, 1320,2757,1703, 1318,2758,1701, 
1316,2750,1699, 1334,2752,1717, 
6, // chain 648
1340,2759,1723, 1341,2760,1724, 1342,2761,1725, 
1343,2762,1726, 1344,2763,1727, 34113,2764,1728, 1341,2765,1724, 34110,2766,1725, 
1, // chain 649
1338,2736,1721, 1329,2735,1712, 1305,2767,1688, 
2, // chain 650
1346,2768,1729, 1347,2769,1730, 1348,2770,1731, 
34117,2771,1732, 
5, // chain 651
1347,2769,1733, 1346,2768,1734, 1350,2772,1735, 
34119,2773,1736, 34120,2774,1737, 1353,2775,1738, 1354,2776,1739, 
3, // chain 652
1355,2777,1740, 1356,2778,1741, 1357,2779,1742, 
1358,2780,1743, 34127,2781,1744, 
4, // chain 653
1356,2778,1745, 1355,2777,1746, 1348,2770,1747, 
34128,2782,1748, 34126,2780,1749, 1361,2783,1750, 
3, // chain 654
1350,2772,1751, 1351,2773,1752, 1362,2784,1753, 
34131,2785,1754, 34122,2776,1755, 
2, // chain 655
1364,2786,1756, 1365,2787,1757, 1366,2788,1758, 
34135,2789,1759, 
3, // chain 656
1366,2788,1758, 1368,2790,1760, 1364,2786,1756, 
34137,2791,1761, 34138,2792,1762, 
3, // chain 657
1365,2787,1763, 1364,2786,1764, 1371,2793,1765, 
34140,2794,1766, 34137,2791,1767, 
3, // chain 658
1373,2795,1768, 1374,2796,1769, 1375,2797,1770, 
1376,2798,1771, 1377,2799,1772, 
4, // chain 659
1378,2800,1773, 1379,2801,1774, 1374,2796,1775, 
1373,2795,1776, 1380,2802,1777, 34145,2799,1778, 
3, // chain 660
1379,2801,25, 1378,2800,25, 1357,2779,25, 
34127,2781,25, 34148,2802,25, 
4, // chain 661
1352,2774,1779, 1346,2768,1729, 1348,2770,1731, 
1360,2782,1780, 1361,2783,1781, 1353,2775,1782, 
2, // chain 662
1376,2798,1783, 1375,2797,1784, 1371,2793,1785, 
1372,2794,1786, 
1, // chain 663
1362,2803,1753, 1363,2804,1754, 1381,2805,1787, 
4, // chain 664
1382,2806,1788, 1369,2807,1761, 1370,2792,1762, 
1383,2808,1789, 1367,2809,1759, 34134,2810,1758, 
4, // chain 665
1369,2807,1767, 1382,2806,1790, 1372,2811,1766, 
34152,2812,1791, 34135,2809,1792, 1371,2813,1765, 
5, // chain 666
1385,2814,1793, 1361,2815,1750, 1358,2816,1749, 
1386,2817,1794, 1387,2818,1795, 34117,2819,1796, 34124,2820,1745, 
5, // chain 667
1388,2821,1797, 1353,2822,1782, 1361,2815,1781, 
1385,2814,1798, 1387,2818,1799, 1347,2823,1730, 34117,2819,1732, 
4, // chain 668
1353,2822,1738, 1388,2821,1800, 1354,2824,1739, 
34157,2825,1801, 34115,2823,1733, 1350,2826,1735, 
4, // chain 669
1390,2827,1802, 1376,2828,1783, 1372,2811,1786, 
1384,2812,1803, 1375,2829,1784, 34139,2813,1785, 
4, // chain 670
1376,2828,1771, 1390,2827,1804, 1377,2830,1772, 
34159,2831,1805, 34143,2829,1770, 1374,2832,1769, 
4, // chain 671
1392,2833,25, 1359,2834,25, 1380,2835,25, 
1393,2836,25, 1357,2837,25, 34147,2838,25, 
4, // chain 672
1386,2817,1806, 1358,2816,1743, 1359,2834,1744, 
1392,2833,1807, 1356,2820,1741, 34125,2837,1742, 
4, // chain 673
1381,2839,1787, 1363,2840,1754, 1354,2824,1755, 
1389,2825,1808, 1362,2841,1753, 34118,2826,1751, 
4, // chain 674
1393,2836,1809, 1380,2835,1777, 1377,2830,1778, 
1391,2831,1810, 1379,2838,1774, 34142,2832,1775, 
1, // chain 675
1367,2789,1792, 1365,2787,1763, 1371,2793,1765, 
1, // chain 676
1348,2770,1747, 1349,2771,1796, 1356,2778,1745, 
2, // chain 677
1370,2842,1762, 1368,2843,1760, 1366,2844,215, 
1383,2845,1789, 
2, // chain 678
1394,2846,1811, 1395,2847,1812, 1396,2848,1813, 
1397,2849,1814, 
1, // chain 679
1398,2850,1815, 1394,2851,1811, 1397,2852,1814, 
2, // chain 680
1398,2853,1815, 1399,2854,1816, 1400,2855,1817, 
34169,2856,1818, 
1, // chain 681
1402,2857,1819, 1396,2858,1813, 1395,2859,1812, 
4, // chain 682
1398,2860,1815, 1397,2861,1814, 1399,2862,1816, 
34169,2863,1818, 34164,2864,1813, 1402,2865,1819, 
4, // chain 683
1394,2866,1820, 1398,2867,1815, 1400,2868,1817, 
1401,2869,1818, 1395,2870,1812, 34170,2871,1819, 
2, // chain 684
1403,2872,1821, 1404,2873,1822, 1405,2874,1823, 
1406,2875,1824, 
1, // chain 685
1406,2876,1824, 1405,2877,1823, 1407,2878,1825, 
2, // chain 686
1408,2879,1826, 1407,2880,1825, 1409,2881,1827, 
1410,2882,1828, 
1, // chain 687
1404,2883,1822, 1403,2884,1821, 1411,2885,1829, 
4, // chain 688
1407,2886,1825, 1405,2887,1830, 1409,2888,1827, 
34178,2889,1828, 34172,2890,1822, 1411,2891,1829, 
4, // chain 689
1406,2892,1824, 1407,2893,1825, 1408,2894,1826, 
1410,2895,1828, 1403,2896,1821, 34179,2897,1829, 
12, // chain 690
1412,2898,1831, 1413,2899,1832, 1414,2900,1833, 
1415,2901,1834, 34184,2902,1835, 34185,2903,1836, 34186,2904,1837, 34181,2899,1832, 1419,2905,1838, 34188,2906,1839, 34180,2898,1831, 1419,2905,1838, 34189,2907,1840, 34183,2901,1834, 
5, // chain 691
1421,2907,1840, 1422,2908,1841, 1419,2905,1838, 
34191,2909,1842, 1417,2903,1836, 34192,2910,1843, 1416,2902,1835, 
1, // chain 692
1419,2905,1838, 1417,2903,1836, 1418,2904,1837, 
20, // chain 693
1425,2911,1844, 1426,2912,1845, 1427,2913,1846, 
1428,2914,1847, 34184,2915,1835, 34183,2916,1834, 34197,2917,1848, 34198,2918,1849, 34194,2912,1845, 1429,2917,1848, 34199,2919,1850, 34193,2911,1844, 1432,2920,1851, 34196,2914,1847, 1416,2915,1835, 1424,2921,1843, 1423,2922,1842, 1431,2919,1850, 34190,2923,1841, 
1429,2917,1848, 34189,2924,1840, 1415,2916,1834, 
13, // chain 694
1433,2925,1852, 1434,2926,1853, 1435,2927,1854, 
1436,2928,1855, 34205,2929,1856, 34206,2930,1857, 34202,2926,1853, 1439,2931,1858, 34201,2925,1852, 1440,2932,1859, 34209,2933,1860, 34204,2928,1855, 1442,2934,1861, 34211,2935,1862, 34205,2929,1856, 
3, // chain 695
1443,2935,1862, 1444,2936,1863, 1442,2934,1861, 
34209,2933,1860, 34208,2932,1859, 
10, // chain 696
1445,2937,1864, 1446,2938,1865, 1447,2939,1866, 
1439,2940,1858, 34206,2941,1857, 34216,2942,1867, 34217,2943,1868, 34218,2944,1869, 34214,2938,1865, 1440,2945,1859, 34207,2940,1858, 34213,2937,1864, 
3, // chain 697
1449,2943,1868, 1450,2944,1869, 1451,2946,1870, 
34212,2947,1863, 34208,2945,1859, 
2, // chain 698
1443,2948,1862, 1437,2949,1856, 1448,2942,1867, 
34206,2941,1857, 
3, // chain 699
1451,2946,1870, 1444,2947,1863, 1443,2948,1862, 
1449,2943,1868, 34216,2942,1867, 
2, // chain 700
1452,2950,25, 1453,2951,25, 1454,2952,25, 
1455,2953,25, 
3, // chain 701
1456,2954,1102, 1457,2955,1871, 1458,2956,1872, 
1459,2957,1873, 34228,2958,1874, 
4, // chain 702
1461,2959,1875, 1462,2960,1876, 1463,2961,1877, 
1464,2962,1878, 34233,2963,1879, 1466,2964,963, 
1, // chain 703
1459,2957,1873, 1467,2965,1102, 1456,2954,1102, 
4, // chain 704
1468,2966,1880, 1461,2967,1875, 1464,2968,1878, 
1469,2969,1881, 34228,2970,1874, 34227,2971,1873, 
3, // chain 705
1466,2972,1882, 1465,2973,1883, 1470,2974,1884, 
1471,2975,1885, 1456,2976,1886, 
1, // chain 706
1466,2972,1887, 1456,2976,1887, 1467,2977,1887, 
6, // chain 707
1457,2978,1871, 1456,2976,1888, 1471,2975,1889, 
1472,2979,1890, 1458,2980,1872, 34241,2981,1891, 1460,2970,1874, 34237,2969,1892, 
6, // chain 708
1474,2982,1893, 1470,2974,1894, 1465,2973,1879, 
1463,2983,1877, 1475,2984,1895, 34230,2985,1876, 1468,2966,1896, 34229,2967,1897, 
2, // chain 709
1471,2986,1898, 1470,2987,1899, 1455,2988,1900, 
1454,2989,1901, 
4, // chain 710
1470,2990,963, 1474,2991,963, 1455,2953,963, 
34243,2992,963, 1452,2950,1902, 34236,2993,1903, 
2, // chain 711
1468,2993,1903, 1469,2994,1904, 1453,2995,1905, 
1452,2996,1902, 
4, // chain 712
1469,2997,1102, 1473,2998,1102, 1453,2951,1102, 
34222,2952,1901, 34240,2999,1102, 1471,3000,1898, 
11, // chain 713
1476,3001,1906, 1477,3002,1907, 1478,3003,1908, 
1479,3004,1909, 1480,3005,1910, 34249,3006,1911, 1482,3007,1912, 34251,3008,1913, 1484,3009,1914, 34253,3010,1915, 1486,3011,1916, 34255,3012,1917, 1488,3013,1918, 
1, // chain 714
1477,3002,1907, 1489,3014,1907, 1478,3003,1908, 
8, // chain 715
1490,3015,766, 1491,3016,766, 1478,3017,766, 
34247,3018,766, 34260,3019,766, 1493,3020,766, 1481,3021,766, 34262,3022,766, 1495,3023,766, 1483,3024,766, 
1, // chain 716
1478,3017,766, 1489,3025,766, 1490,3015,766, 
6, // chain 717
1496,3026,694, 1497,3027,694, 1480,3028,694, 
34266,3029,694, 1476,3030,694, 34267,3031,694, 1477,3032,694, 34268,3033,694, 
1, // chain 718
1480,3028,694, 1482,3034,694, 1496,3026,694, 
14, // chain 719
1501,3035,1919, 1502,3036,1920, 1503,3037,1921, 
1504,3038,1922, 34273,3039,1923, 34274,3040,1924, 34275,3041,1925, 34270,3036,1920, 1508,3042,1926, 34277,3043,1927, 34278,3044,1928, 34279,3045,1929, 34269,3035,1919, 1512,3046,1930, 34281,3047,1931, 34272,3038,1922, 
6, // chain 720
1514,3048,1932, 1507,3041,1925, 1508,3042,1926, 
1515,3049,1933, 34284,3050,1934, 34285,3051,1935, 34286,3052,1936, 34277,3043,1927, 
1, // chain 721
1505,3039,1923, 1519,3053,1937, 1504,3038,1922, 
7, // chain 722
1520,3054,1938, 1512,3055,1930, 1513,3056,1931, 
1521,3057,1939, 34290,3058,1940, 34272,3059,1922, 1523,3060,1941, 34292,3061,1942, 34287,3062,1937, 
8, // chain 723
1524,3061,1942, 1525,3063,1943, 1523,3060,1941, 
34283,3049,1933, 34294,3064,1944, 1514,3048,1932, 34295,3065,1945, 1528,3066,1946, 1507,3041,1925, 34274,3040,1924, 
4, // chain 724
1517,3051,1935, 1521,3057,1939, 1522,3058,1940, 
1516,3050,1934, 34291,3060,1941, 1515,3049,1933, 
3, // chain 725
1518,3067,1936, 1509,3068,1927, 1520,3069,1938, 
1517,3070,1947, 34289,3071,1939, 
3, // chain 726
1512,3072,1930, 1520,3069,1938, 1509,3068,1927, 
1510,3073,1948, 1511,3074,1929, 
6, // chain 727
1505,3075,1923, 1506,3076,1949, 1519,3077,1937, 
34296,3078,1946, 1524,3079,1942, 34295,3080,1945, 1526,3081,1950, 1525,3082,1943, 
1, // chain 728
1529,3083,1951, 1530,3084,1952, 1531,3085,1952, 
10, // chain 729
1531,3085,1952, 1532,3086,1953, 1529,3083,1954, 
34301,3087,1955, 34302,3088,1956, 1535,3089,1957, 34304,3090,1958, 1537,3091,1959, 34306,3092,1960, 1539,3093,1961, 34308,3094,1962, 1541,3095,1963, 
1, // chain 730
1540,3094,1964, 1542,3096,1965, 1541,3095,1965, 
9, // chain 731
1543,3097,766, 1530,3098,766, 1529,3099,766, 
1544,3100,766, 34301,3101,766, 1545,3102,766, 34314,3103,766, 34303,3104,766, 1547,3105,766, 34316,3106,766, 34305,3107,766, 
7, // chain 732
1549,3108,694, 1536,3109,694, 1534,3110,694, 
1550,3111,694, 34319,3112,694, 34300,3113,694, 1552,3114,694, 34299,3115,694, 1553,3116,694, 
16, // chain 733
1554,3117,1966, 1555,3118,1967, 1556,3119,1968, 
1557,3120,1969, 34326,3121,1970, 34327,3122,1971, 34328,3123,1972, 34329,3124,1973, 34330,3125,1974, 34323,3118,1967, 1563,3126,1975, 34332,3127,1976, 34333,3128,1977, 34334,3129,1978, 34322,3117,1966, 1567,3130,1979, 34336,3131,1980, 34325,3120,1969, 
2, // chain 734
1561,3124,1973, 1562,3125,1974, 1569,3132,1981, 
1570,3133,1982, 
1, // chain 735
1562,3125,1974, 1563,3126,1975, 1569,3132,1981, 
1, // chain 736
1560,3123,1972, 1571,3134,1983, 1559,3122,1971, 
6, // chain 737
1572,3135,1984, 1561,3136,1973, 1573,3137,1985, 
1574,3138,1986, 1575,3139,1987, 34334,3129,1978, 34344,3140,1988, 1565,3128,1977, 
1, // chain 738
1561,3136,1973, 1570,3141,1982, 1573,3137,1985, 
4, // chain 739
1577,3142,1989, 1571,3143,1983, 1560,3144,1972, 
1578,3145,1990, 34340,3135,1984, 34329,3136,1973, 
4, // chain 740
1579,3146,1991, 1577,3142,1989, 1578,3145,1990, 
1580,3147,1992, 34343,3139,1987, 34340,3135,1984, 
4, // chain 741
1581,3148,1993, 1579,3146,1991, 1580,3147,1992, 
1567,3130,1979, 34334,3129,1978, 34343,3139,1987, 
1, // chain 742
1567,3130,1979, 1568,3131,1980, 1581,3148,1993, 
4, // chain 743
1571,3149,1983, 1581,3150,1993, 1568,3151,1980, 
1559,3152,1971, 34325,3153,1994, 1558,3154,1970, 
3, // chain 744
1570,3155,1982, 1569,3156,1981, 1565,3157,1977, 
34332,3158,1995, 34331,3159,1975, 
3, // chain 745
1565,3157,1977, 1576,3160,1988, 1570,3155,1982, 
34342,3161,1996, 1573,3162,1985, 
2, // chain 746
1581,3150,1993, 1571,3149,1983, 1577,3163,1997, 
1579,3164,1991, 
2, // chain 747
1582,3165,215, 1583,3166,215, 1584,3167,215, 
1585,3168,215, 
8, // chain 748
1585,3169,1998, 1584,3170,1999, 1586,3171,2000, 
34355,3172,2001, 1588,3173,2002, 34357,3174,2003, 34358,3175,2004, 1591,3176,2005, 34360,3177,2006, 1593,3178,2007, 
2, // chain 749
1594,3179,2008, 1595,3180,2009, 1583,3181,2010, 
1582,3182,2011, 
2, // chain 750
1594,3183,2012, 1582,3165,2013, 1585,3168,2014, 
1586,3184,2015, 
2, // chain 751
1587,3185,2001, 1584,3186,1999, 1583,3187,2010, 
1595,3188,2009, 
6, // chain 752
1594,3179,2008, 1596,3189,2016, 1595,3180,2009, 
34365,3190,2017, 34366,3191,2018, 1599,3192,2019, 1600,3193,2020, 34369,3194,2021, 
3, // chain 753
1602,3195,2022, 1603,3196,25, 1604,3197,2023, 
1605,3198,2024, 34374,3199,766, 
8, // chain 754
1587,3200,2001, 1595,3201,2009, 1607,3202,2025, 
34365,3203,2017, 1608,3204,2026, 34358,3205,2004, 1609,3206,2027, 34378,3207,2028, 34355,3200,2001, 1607,3202,2025, 
2, // chain 755
1610,3208,2028, 1607,3209,2025, 1611,3210,2029, 
1612,3211,2030, 
8, // chain 756
1612,3211,2031, 1611,3210,25, 1613,3212,2032, 
34382,3213,25, 34383,3214,25, 1616,3215,2033, 1606,3216,2034, 34373,3217,2035, 34380,3211,2031, 1613,3212,2032, 
1, // chain 757
1605,3198,2024, 1613,3218,1102, 1602,3195,2022, 
2, // chain 758
1613,3219,694, 1614,3220,694, 1603,3196,694, 
1602,3195,694, 
2, // chain 759
1610,3221,2028, 1612,3211,2036, 1616,3215,2037, 
1609,3222,2027, 
2, // chain 760
1601,3223,215, 1593,3224,215, 1592,3225,215, 
1600,3226,215, 
2, // chain 761
1586,3227,2000, 1588,3228,2002, 1589,3229,2003, 
1591,3230,2005, 
2, // chain 762
1599,3231,2038, 1591,3232,2039, 1593,3224,2040, 
1601,3223,2041, 
2, // chain 763
1590,3233,2004, 1597,3234,2017, 1600,3235,2020, 
1592,3236,2006, 
2, // chain 764
1609,3237,2027, 1616,3215,2042, 1615,3214,2043, 
1608,3238,2026, 
2, // chain 765
1615,3214,2044, 1611,3210,2045, 1607,3239,2025, 
1608,3240,2026, 
2, // chain 766
1606,3241,963, 1604,3197,963, 1603,3196,963, 
1614,3242,963, 
2, // chain 767
1594,3243,2008, 1599,3244,2019, 1598,3245,2018, 
1596,3246,2016, 
2, // chain 768
1586,3184,2000, 1591,3232,2005, 1599,3231,2019, 
1594,3183,2008, 
12, // chain 769
1617,3247,2046, 1618,3248,2047, 1619,3249,2048, 
34388,3250,2049, 34389,3251,2050, 1622,3252,2051, 34391,3253,2052, 1624,3254,2053, 34393,3255,2054, 1626,3256,2055, 34395,3257,2056, 1628,3258,2057, 34397,3259,2058, 34398,3260,2059, 
1, // chain 770
1619,3249,2048, 1631,3261,2060, 1617,3247,2046, 
4, // chain 771
1632,3262,2061, 1629,3263,2062, 1630,3264,2063, 
1633,3265,2064, 34385,3266,2046, 1631,3267,2060, 
12, // chain 772
1631,3268,2065, 1619,3269,2066, 1633,3270,2064, 
34402,3271,2067, 34388,3272,2068, 1635,3273,2069, 34390,3274,2070, 1624,3275,2071, 1636,3276,2072, 34394,3277,2073, 1637,3278,2074, 34396,3279,2075, 1632,3280,2061, 34397,3281,2062, 
3, // chain 773
1634,3271,2067, 1635,3273,2069, 1637,3278,2074, 
1632,3280,2061, 1633,3270,2064, 
1, // chain 774
1635,3273,2069, 1636,3276,2072, 1637,3278,2074, 
1, // chain 775
1638,3282,2076, 1639,3283,2060, 1640,3284,2077, 
12, // chain 776
1641,3285,2078, 1638,3282,2079, 1640,3284,2080, 
1642,3286,2081, 1643,3287,2082, 34412,3288,2083, 1645,3289,2084, 34414,3290,2085, 1647,3291,2086, 34416,3292,2087, 1649,3293,2088, 34418,3294,2089, 1651,3295,2090, 1652,3296,2091, 
4, // chain 777
1652,3297,2092, 1651,3298,2093, 1653,3299,2094, 
1654,3300,2095, 1638,3301,2076, 34407,3302,2060, 
6, // chain 778
1639,3303,2096, 1654,3304,2095, 1640,3305,2097, 
34423,3306,2098, 34421,3307,2094, 1656,3308,2099, 34418,3309,2100, 34419,3310,2093, 
6, // chain 779
1648,3311,2101, 1646,3312,2102, 1657,3313,2103, 
34426,3314,2104, 34412,3315,2105, 1642,3316,2106, 1655,3306,2098, 34408,3305,2097, 
3, // chain 780
1656,3308,2099, 1648,3311,2101, 1657,3313,2103, 
1658,3314,2104, 1655,3306,2098, 
1, // chain 781
1650,3309,2100, 1648,3311,2101, 1656,3308,2099, 
13, // chain 782
1659,3317,2107, 1660,3318,2108, 1661,3319,2109, 
34430,3320,2110, 34431,3321,2111, 1664,3322,2112, 1665,3323,2113, 34434,3324,2114, 1667,3325,2115, 34436,3326,2116, 1669,3327,2117, 34438,3328,2118, 1671,3329,2119, 34440,3330,2120, 1673,3331,2121, 
2, // chain 783
1674,3332,2122, 1675,3333,2123, 1659,3317,2107, 
1661,3319,2109, 
8, // chain 784
1676,3334,2124, 1672,3335,2125, 1670,3336,2118, 
1677,3337,2126, 34427,3338,2127, 34428,3339,1102, 34431,3340,1102, 34432,3341,1102, 34434,3342,1102, 34436,3343,2116, 
2, // chain 785
1678,3344,2128, 1679,3345,2128, 1680,3346,2128, 
1681,3347,2128, 
2, // chain 786
1677,3337,2126, 1682,3348,2129, 1683,3349,2130, 
1676,3334,2124, 
2, // chain 787
1684,3350,2131, 1685,3351,2131, 1686,3352,2131, 
1687,3353,2131, 
19, // chain 788
1688,3354,2132, 1689,3355,2133, 1690,3356,2134, 
1691,3357,2135, 34442,3358,2136, 1692,3359,2137, 34461,3360,2138, 34429,3361,2139, 1662,3362,963, 1694,3363,963, 34433,3364,963, 1695,3365,963, 34435,3366,963, 1669,3367,963, 1696,3368,963, 34439,3369,2140, 1697,3370,2141, 34441,3371,2142, 1698,3372,2143, 
34459,3357,2135, 34456,3354,2132, 
5, // chain 789
1689,3355,2133, 1699,3373,2144, 1690,3356,2134, 
34468,3374,2145, 34450,3375,2129, 1701,3376,2146, 34445,3377,2126, 
4, // chain 790
1702,3378,2147, 1703,3379,2148, 1704,3380,2149, 
1705,3381,2150, 1706,3382,2151, 34475,3383,2152, 
1, // chain 791
1702,3378,2147, 1706,3382,2151, 1708,3384,2153, 
9, // chain 792
1703,3385,2148, 1702,3386,2147, 1693,3387,2154, 
1704,3388,2149, 34462,3389,2155, 1695,3390,2156, 1705,3391,2150, 34464,3392,2157, 1707,3393,2152, 34465,3394,2158, 1706,3395,2151, 
6, // chain 793
1706,3396,2151, 1697,3397,2158, 1698,3398,2159, 
1691,3399,2160, 1708,3400,2153, 34460,3401,2161, 1702,3386,2147, 34461,3387,2154, 
1, // chain 794
1659,3338,2127, 1675,3402,2162, 1677,3337,2126, 
4, // chain 795
1676,3403,2163, 1683,3404,2164, 1709,3405,2165, 
34457,3355,2133, 1710,3406,2166, 34456,3354,2132, 
3, // chain 796
1677,3407,2167, 1675,3408,2168, 1681,3347,2169, 
1680,3346,2170, 1701,3409,2171, 
2, // chain 797
1674,3410,2122, 1678,3344,2172, 1681,3347,2173, 
1675,3411,2123, 
2, // chain 798
1674,3412,2174, 1690,3413,2134, 1679,3345,2175, 
34468,3414,2145, 
1, // chain 799
1679,3345,2175, 1678,3344,2176, 1674,3412,2174, 
2, // chain 800
1701,3415,2177, 1680,3346,2177, 1679,3345,2177, 
1700,3416,2177, 
2, // chain 801
1672,3417,2120, 1684,3350,2178, 1687,3353,2179, 
1673,3418,2121, 
2, // chain 802
1672,3419,2180, 1676,3420,2163, 1685,3351,2181, 
34477,3421,2165, 
1, // chain 803
1685,3351,2181, 1684,3350,2182, 1672,3419,2180, 
2, // chain 804
1710,3422,2183, 1686,3352,2183, 1685,3351,2183, 
1709,3423,2183, 
3, // chain 805
1710,3424,2184, 1688,3425,2185, 1686,3352,2186, 
34455,3353,2187, 34441,3426,2188, 
6, // chain 806
1711,3427,2189, 1712,3428,2190, 1713,3429,2191, 
34482,3430,2192, 34483,3431,2193, 1716,3432,2194, 34485,3433,2195, 1718,3434,2196, 
4, // chain 807
1719,3435,2197, 1716,3436,2194, 1718,3437,2196, 
1720,3438,2198, 34479,3427,2189, 1713,3429,2191, 
8, // chain 808
1721,3439,2199, 1722,3440,2200, 1714,3441,2201, 
1716,3442,2202, 1723,3443,2203, 34487,3444,2204, 1720,3445,2205, 1722,3440,2200, 34481,3446,2206, 1714,3441,2201, 
3, // chain 809
1722,3440,2200, 1721,3439,2199, 1724,3447,2207, 
34491,3443,2203, 1722,3440,2200, 
7, // chain 810
1725,3448,2208, 1726,3449,2209, 1727,3450,2210, 
34496,3451,2211, 34497,3452,2212, 1730,3453,2213, 1731,3454,2214, 34500,3455,2215, 34501,3456,2216, 
3, // chain 811
1733,3457,2216, 1725,3448,2208, 1732,3458,2215, 
34502,3459,2217, 34495,3450,2210, 
10, // chain 812
1727,3460,2218, 1728,3461,2219, 1735,3462,2220, 
1736,3463,2221, 34505,3464,2222, 34506,3465,2223, 34496,3461,2219, 1731,3466,2224, 1732,3467,2225, 1736,3463,2221, 34502,3468,2226, 1727,3460,2218, 
1, // chain 813
1738,3465,2223, 1736,3463,2221, 1737,3464,2222, 
2, // chain 814
1739,3469,2227, 1740,3470,2228, 1741,3471,2229, 
1742,3472,2230, 
2, // chain 815
1740,3473,2231, 1743,3474,2232, 1744,3475,2233, 
1741,3476,2234, 
2, // chain 816
1743,3474,2235, 1745,3477,2236, 1746,3478,2237, 
1744,3475,2238, 
2, // chain 817
1745,3477,2239, 1739,3469,2240, 1742,3472,2241, 
1746,3478,2242, 
2, // chain 818
1742,3479,2230, 1741,3480,2229, 1747,3481,2243, 
1748,3482,2244, 
2, // chain 819
1741,3483,2234, 1744,3484,2233, 1749,3485,2245, 
1747,3481,2246, 
2, // chain 820
1744,3486,2238, 1746,3487,2237, 1750,3488,2247, 
1749,3485,2248, 
2, // chain 821
1746,3489,2242, 1742,3490,2241, 1748,3482,2249, 
1750,3488,2250, 
10, // chain 822
1748,3482,2251, 1747,3481,2252, 1751,3491,2253, 
34520,3492,2254, 34517,3485,2255, 1753,3493,2256, 34518,3488,2257, 1754,3494,2258, 34516,3482,2251, 1751,3491,2253, 1752,3492,2254, 1753,3493,2256, 
18, // chain 823
1755,3495,2259, 1756,3496,2260, 1757,3497,2261, 
1758,3498,2262, 34527,3499,2263, 34528,3500,2264, 34529,3501,2265, 34530,3502,2266, 34524,3496,2260, 1763,3503,2267, 1764,3504,2268, 1761,3501,2265, 34533,3505,2269, 1766,3506,2270, 34535,3507,963, 1768,3508,2271, 34537,3509,2272, 1770,3510,2273, 1760,3500,2274, 
34527,3499,2275, 
1, // chain 824
1756,3496,2276, 1771,3511,2276, 1763,3503,2276, 
2, // chain 825
1760,3500,2274, 1761,3501,2265, 1768,3508,2271, 
34534,3506,2270, 
4, // chain 826
1767,3507,2277, 1765,3505,2269, 1764,3512,2268, 
1772,3513,2278, 1769,3509,2272, 34538,3514,2273, 
10, // chain 827
1773,3515,2279, 1774,3516,2280, 1775,3517,2281, 
1776,3518,2282, 1777,3519,2283, 34546,3520,2284, 1779,3521,2285, 34548,3522,2286, 1781,3523,2287, 34550,3524,2288, 1775,3525,2281, 1774,3526,2280, 
4, // chain 828
1776,3527,2282, 1775,3528,2281, 1783,3529,2289, 
1784,3530,2290, 1778,3531,2284, 34548,3532,2286, 
2, // chain 829
1785,3533,2291, 1783,3529,2289, 1775,3528,2281, 
1786,3534,2292, 
3, // chain 830
1774,3535,2280, 1773,3536,2279, 1787,3537,2293, 
1788,3538,2294, 1789,3539,2295, 
4, // chain 831
1790,3540,2296, 1787,3537,2293, 1773,3536,2279, 
1777,3541,2283, 1791,3542,2297, 34547,3543,2285, 
5, // chain 832
1780,3544,2286, 1784,3545,2290, 1792,3546,2298, 
1793,3547,2299, 1782,3548,1102, 34543,3549,2300, 34554,3550,2301, 
3, // chain 833
1781,3551,2287, 1774,3552,2280, 1789,3553,2295, 
1779,3554,2285, 34562,3555,2302, 
2, // chain 834
1791,3556,2297, 1779,3554,2285, 1794,3555,2303, 
1788,3557,2304, 
2, // chain 835
1787,3558,2293, 1790,3559,2296, 1791,3556,1102, 
1788,3557,1102, 
2, // chain 836
1784,3545,2290, 1783,3560,2289, 1785,3561,963, 
1792,3546,963, 
1, // chain 837
1786,3562,2292, 1792,3546,2305, 1785,3561,2291, 
8, // chain 838
1795,3563,2306, 1796,3564,2307, 1797,3565,2308, 
34566,3566,2309, 34567,3567,2310, 1800,3568,2311, 1801,3569,2312, 34570,3570,2313, 1803,3571,2314, 34572,3572,2315, 
3, // chain 839
1797,3565,2308, 1805,3573,2316, 1795,3563,2306, 
34572,3574,2315, 34571,3575,2314, 
7, // chain 840
1796,3576,2307, 1795,3577,2306, 1806,3578,2317, 
34575,3579,2318, 34572,3580,2315, 1802,3581,2313, 1808,3582,2319, 34568,3583,2311, 1809,3584,2320, 
2, // chain 841
1805,3585,2316, 1797,3586,2308, 1810,3587,2321, 
34579,3588,2322, 
5, // chain 842
1810,3587,2321, 1812,3589,2323, 1803,3590,2314, 
34569,3591,2312, 34581,3592,2324, 1798,3593,2309, 34582,3594,2325, 
1, // chain 843
1803,3590,2314, 1805,3585,2316, 1810,3587,2321, 
1, // chain 844
1800,3583,2326, 1815,3595,2327, 1809,3584,2328, 
3, // chain 845
1796,3596,2329, 1816,3597,2330, 1815,3598,2327, 
1799,3599,1102, 34568,3600,2326, 
1, // chain 846
1816,3601,2331, 1796,3576,2307, 1806,3578,2317, 
1, // chain 847
1797,3586,2332, 1817,3602,2333, 1811,3588,2334, 
2, // chain 848
1798,3603,2335, 1814,3604,2336, 1817,3605,2333, 
1797,3606,2332, 
3, // chain 849
1807,3607,2318, 1808,3608,963, 1806,3609,2317, 
34577,3610,2337, 1816,3611,2338, 
3, // chain 850
1813,3612,2324, 1812,3613,2323, 1810,3614,2321, 
1811,3615,2339, 1814,3616,2340, 
3, // chain 851
1818,3617,2341, 1819,3618,2342, 1820,3619,2343, 
1821,3620,2344, 1822,3621,2345, 
16, // chain 852
1821,3622,2344, 1820,3623,2343, 1823,3624,2346, 
1824,3625,2347, 34587,3618,2348, 1825,3626,2349, 34586,3617,2350, 1826,3627,2351, 34590,3621,2345, 1827,3628,2352, 1828,3629,2353, 34597,3630,2354, 34598,3631,2355, 1831,3632,2356, 1832,3633,2357, 34601,3634,2358, 34602,3635,2359, 34603,3636,2360, 
14, // chain 853
1827,3637,2352, 1822,3638,2345, 1836,3639,2361, 
1830,3640,2355, 34605,3641,2362, 34606,3642,2363, 34607,3643,2364, 34590,3638,2345, 1821,3622,2344, 1825,3626,2365, 1840,3644,2366, 34594,3627,2351, 1828,3629,2353, 1838,3642,2363, 34600,3633,2357, 34597,3630,2354, 
1, // chain 854
1839,3643,2364, 1840,3644,2366, 1838,3642,2363, 
1, // chain 855
1825,3626,2349, 1821,3622,2344, 1824,3625,2347, 
5, // chain 856
1837,3641,2362, 1838,3642,2363, 1832,3633,2357, 
1833,3634,2358, 1841,3645,2367, 34610,3646,2368, 34602,3635,2359, 
3, // chain 857
1831,3647,2356, 1830,3640,2355, 1841,3645,2367, 
1835,3648,2360, 34610,3646,2368, 
1, // chain 858
1830,3640,2355, 1837,3641,2362, 1841,3645,2367, 
2, // chain 859
1843,3649,2369, 1844,3650,2370, 1845,3651,2371, 
1846,3652,2372, 
3, // chain 860
1843,3649,2369, 1847,3653,2373, 1844,3650,2370, 
34616,3654,2374, 34617,3655,2375, 
16, // chain 861
1850,3656,2376, 1851,3657,2377, 1852,3658,2378, 
1853,3659,2379, 34622,3660,2380, 34623,3661,2381, 1856,3662,2382, 1857,3663,2383, 1853,3659,2384, 34626,3664,2385, 34627,3665,2386, 1860,3666,2387, 34629,3667,2388, 1856,3668,2382, 1855,3669,2381, 1862,3670,215, 1858,3664,2385, 34621,3659,2384, 
7, // chain 862
1857,3663,25, 1856,3662,25, 1863,3671,25, 
1864,3672,25, 1859,3665,25, 34633,3673,25, 1861,3667,25, 34631,3674,25, 1856,3668,25, 
6, // chain 863
1863,3671,2389, 1866,3675,2390, 1867,3676,2391, 
1864,3672,2392, 34636,3677,2393, 1865,3673,2394, 34634,3678,2390, 1863,3674,2389, 
7, // chain 864
1869,3679,2395, 1870,3680,2396, 1871,3681,2397, 
1872,3682,2398, 34641,3683,2399, 34638,3680,2396, 1874,3684,2400, 1851,3657,2377, 34643,3685,2401, 
8, // chain 865
1844,3650,2370, 1848,3654,2374, 1876,3686,2402, 
1877,3687,2403, 34617,3688,2375, 1878,3689,2404, 34615,3690,2373, 1843,3691,2369, 1879,3692,2405, 34614,3693,2372, 
11, // chain 866
1876,3686,2406, 1848,3654,2407, 1870,3680,2396, 
1869,3679,2395, 1880,3694,2408, 34649,3695,2409, 34640,3682,2398, 1874,3696,2400, 34643,3697,2401, 34650,3698,2410, 34618,3656,2376, 34641,3683,2399, 1851,3657,2377, 
4, // chain 867
1883,3699,2411, 1884,3700,2412, 1885,3701,2413, 
1886,3702,2414, 1887,3703,2415, 34656,3704,2416, 
2, // chain 868
1888,3705,2416, 1885,3701,2413, 1884,3700,2412, 
1887,3706,2415, 
6, // chain 869
1885,3701,215, 1888,3705,230, 1845,3651,215, 
1889,3707,215, 1879,3692,215, 1886,3702,215, 34614,3693,215, 1888,3704,230, 
3, // chain 870
1889,3707,2417, 1845,3651,2371, 1877,3687,2403, 
1879,3692,2405, 34646,3689,2404, 
1, // chain 871
1845,3651,2371, 1844,3650,2370, 1877,3687,2403, 
5, // chain 872
1882,3698,2410, 1850,3656,2376, 1853,3659,2379, 
1862,3670,2418, 1875,3697,2401, 34623,3669,2419, 1851,3708,2377, 
4, // chain 873
1849,3688,2420, 1876,3686,2406, 1880,3694,2408, 
1870,3709,2396, 34642,3696,2400, 34649,3695,2409, 
1, // chain 874
1870,3680,2396, 1848,3654,2407, 1849,3655,2420, 
1, // chain 875
1888,3705,230, 1846,3652,215, 1845,3651,215, 
1, // chain 876
1851,3657,2377, 1855,3661,2419, 1852,3658,2378, 
14, // chain 877
1890,3710,2421, 1891,3711,2422, 1892,3712,2423, 
34661,3713,2424, 1894,3714,2425, 34663,3715,2426, 1896,3716,2427, 34665,3717,2428, 1898,3718,2429, 34667,3719,2430, 1900,3720,2431, 34669,3721,2432, 1902,3722,2433, 34671,3723,2434, 1904,3724,2435, 1905,3725,2436, 
5, // chain 878
1892,3712,2423, 1906,3726,2437, 1890,3710,2421, 
34675,3727,2438, 34673,3728,2436, 1908,3729,2439, 34672,3730,2435, 
5, // chain 879
1896,3731,2427, 1898,3732,2429, 1900,3733,2431, 
1892,3734,2423, 34670,3735,2433, 1906,3736,2437, 34673,3737,2436, 
1, // chain 880
1894,3738,2425, 1896,3731,2427, 1892,3734,2423, 
4, // chain 881
1909,3739,2440, 1910,3740,2441, 1911,3741,2442, 
1912,3742,2443, 34681,3743,2444, 34682,3744,2445, 
6, // chain 882
1893,3745,2424, 1891,3746,2422, 1915,3747,2446, 
34658,3748,2421, 1916,3749,2447, 34675,3750,2438, 1917,3751,2448, 34676,3752,2439, 
4, // chain 883
1908,3753,2439, 1904,3754,2435, 1917,3755,2448, 
34686,3756,2449, 34671,3757,2434, 1919,3758,2450, 
4, // chain 884
1903,3759,2434, 1901,3760,2432, 1919,3761,2450, 
34688,3762,2451, 34667,3763,2430, 1921,3764,2452, 
4, // chain 885
1899,3765,2430, 1897,3766,2428, 1921,3767,2452, 
34663,3768,2426, 1922,3769,2453, 34661,3770,2424, 
1, // chain 886
1915,3747,2446, 1922,3771,2453, 1893,3745,2424, 
3, // chain 887
1923,3772,2454, 1913,3773,2444, 1915,3747,2455, 
34682,3774,2445, 1922,3771,2456, 
3, // chain 888
1915,3747,2455, 1916,3749,2457, 1923,3772,2454, 
34685,3751,2448, 1924,3775,2458, 
1, // chain 889
1918,3756,2449, 1924,3776,2458, 1917,3755,2448, 
9, // chain 890
1918,3756,2459, 1919,3758,2460, 1925,3777,2461, 
1926,3778,2462, 1927,3779,2463, 34696,3780,2464, 1929,3781,2465, 34678,3782,2441, 1924,3776,2458, 1918,3756,2459, 1927,3779,2463, 
2, // chain 891
1919,3761,2460, 1920,3762,2466, 1930,3783,2467, 
34689,3764,2468, 
7, // chain 892
1925,3784,2461, 1919,3761,2460, 1930,3783,2467, 
1931,3785,2469, 34700,3786,2470, 34701,3787,2471, 1934,3788,2472, 1931,3785,2469, 34693,3784,2461, 
9, // chain 893
1935,3789,2473, 1930,3790,2467, 1921,3767,2468, 
1922,3769,2456, 1914,3791,2445, 1936,3792,2474, 34679,3793,2442, 1937,3794,2475, 1938,3795,2476, 1935,3789,2473, 34707,3796,2477, 
5, // chain 894
1909,3797,2440, 1913,3773,2478, 1940,3798,2479, 
1941,3799,2480, 34710,3800,2481, 34691,3772,2454, 34681,3773,2478, 
3, // chain 895
1923,3801,2454, 1924,3802,2458, 1910,3740,2441, 
1941,3803,2480, 34677,3739,2440, 
6, // chain 896
1930,3804,2467, 1935,3805,2473, 1939,3806,2477, 
1933,3807,2471, 34706,3808,2476, 1910,3740,2441, 34679,3741,2442, 34705,3809,2475, 
1, // chain 897
1913,3773,2444, 1909,3797,2440, 1912,3810,2443, 
1, // chain 898
1923,3772,2454, 1941,3799,2480, 1942,3800,2481, 
4, // chain 899
1934,3811,2472, 1933,3807,2471, 1910,3740,2441, 
1928,3812,2464, 1926,3813,2462, 1925,3814,2461, 
8, // chain 900
1943,3815,2482, 1944,3816,2483, 1945,3817,2484, 
1946,3818,2485, 1947,3819,2486, 34716,3820,2487, 1949,3821,2488, 1950,3822,2489, 34719,3823,2490, 1952,3824,2491, 
2, // chain 901
1945,3817,2492, 1944,3825,2492, 1953,3826,2492, 
1954,3827,2492, 
4, // chain 902
1955,3828,2493, 1956,3829,2494, 1957,3830,2495, 
34726,3831,2496, 34727,3832,2497, 1960,3833,2498, 
6, // chain 903
1959,3834,2497, 1961,3835,2499, 1960,3836,2498, 
34730,3837,2500, 34731,3838,2501, 1964,3839,2502, 34733,3840,2503, 1966,3841,2504, 
2, // chain 904
1967,3842,2505, 1955,3828,2493, 1968,3843,2506, 
34725,3830,2495, 
5, // chain 905
1969,3844,2507, 1970,3845,2508, 1971,3846,2509, 
34740,3847,2510, 34741,3848,2511, 1952,3849,2491, 1951,3850,2490, 
2, // chain 906
1971,3846,2509, 1974,3851,2512, 1975,3852,2513, 
34744,3853,2514, 
1, // chain 907
1975,3852,2513, 1969,3844,2507, 1971,3846,2509, 
2, // chain 908
1976,3853,2514, 1977,3854,2515, 1978,3855,2516, 
1975,3856,2513, 
11, // chain 909
1970,3857,2517, 1969,3858,2518, 1957,3859,2519, 
1958,3860,2520, 1973,3861,2521, 34720,3862,2522, 34728,3863,2523, 1950,3864,2524, 34730,3865,2525, 1947,3866,2526, 34732,3867,2527, 1943,3868,2528, 34734,3869,2529, 
4, // chain 910
1956,3829,963, 1955,3828,2530, 1971,3846,963, 
1972,3847,963, 1959,3832,963, 34719,3850,963, 
15, // chain 911
1961,3835,963, 1959,3834,963, 1951,3823,963, 
1949,3821,963, 1948,3820,963, 1963,3838,963, 34714,3818,963, 1979,3870,963, 34748,3871,963, 34713,3817,2531, 1981,3872,2531, 34750,3873,2532, 34722,3827,2532, 1983,3874,2533, 1979,3870,963, 34733,3840,2534, 1963,3838,963, 
3, // chain 912
1975,3875,2535, 1978,3876,2536, 1984,3877,2537, 
1969,3858,2538, 34736,3878,2539, 
10, // chain 913
1955,3828,2530, 1967,3842,2540, 1985,3879,2534, 
1986,3880,2541, 34755,3881,2542, 34742,3851,2543, 34756,3882,2543, 34757,3883,2543, 34745,3854,2543, 1976,3853,2544, 1990,3884,2545, 34742,3851,2546, 
2, // chain 914
1968,3885,2506, 1984,3886,2547, 1985,3879,2548, 
1967,3842,2505, 
2, // chain 915
1983,3874,2549, 1991,3887,2550, 1966,3888,2504, 
1965,3840,2503, 
2, // chain 916
1954,3827,965, 1953,3889,965, 1991,3887,965, 
1983,3874,965, 
2, // chain 917
1978,3890,2551, 1977,3854,2551, 1985,3879,2551, 
1984,3886,2551, 
1, // chain 918
1968,3878,2552, 1957,3859,2519, 1969,3858,2518, 
2, // chain 919
1992,3891,963, 1993,3892,963, 1994,3893,963, 
1995,3894,963, 
2, // chain 920
1995,3894,694, 1986,3895,694, 1987,3896,694, 
1992,3891,694, 
2, // chain 921
1992,3891,215, 1987,3897,215, 1996,3898,215, 
1993,3892,215, 
2, // chain 922
1994,3893,766, 1993,3892,766, 1996,3899,766, 
1997,3900,766, 
2, // chain 923
1995,3894,25, 1994,3893,25, 1997,3901,25, 
1986,3902,25, 
2, // chain 924
1974,3851,2543, 1971,3846,963, 1996,3903,2544, 
1987,3881,2542, 
3, // chain 925
1997,3904,2532, 1996,3903,2544, 1971,3846,963, 
1986,3880,2541, 34723,3828,2530, 
2, // chain 926
1998,3905,963, 1999,3906,963, 2000,3907,963, 
2001,3908,963, 
2, // chain 927
2001,3908,694, 1988,3909,694, 1989,3910,694, 
1998,3905,694, 
2, // chain 928
1998,3905,215, 1989,3911,215, 1990,3912,215, 
1999,3906,215, 
2, // chain 929
2000,3907,2553, 1999,3906,766, 1990,3913,2545, 
1974,3914,2546, 
2, // chain 930
2001,3908,25, 2000,3907,25, 1974,3915,25, 
1988,3916,25, 
1, // chain 931
1991,3917,2554, 1943,3868,2554, 1966,3869,2554, 
2, // chain 932
2002,3918,963, 2003,3919,963, 2004,3920,963, 
2005,3921,963, 
2, // chain 933
2002,3918,215, 1981,3922,215, 1982,3923,215, 
2003,3919,215, 
2, // chain 934
2002,3918,694, 2005,3921,2555, 1980,3924,2555, 
1981,3925,694, 
2, // chain 935
1979,3926,766, 2004,3920,766, 2003,3919,766, 
1982,3927,766, 
2, // chain 936
2004,3920,25, 1979,3928,25, 1980,3929,2555, 
2005,3921,2555, 
2, // chain 937
1991,3917,2556, 1953,3930,2557, 1944,3931,2557, 
1943,3868,2556, 
2, // chain 938
2006,3932,25, 2007,3933,25, 2008,3934,25, 
2009,3935,25, 
4, // chain 939
2010,3936,2558, 2011,3937,1871, 2012,3938,2559, 
34781,3939,1890, 34782,3940,1889, 34778,3936,1888, 
4, // chain 940
2015,3941,2560, 2016,3942,1876, 2017,3943,1877, 
34786,3944,1895, 34787,3945,1896, 34783,3941,1897, 
10, // chain 941
2020,3946,2561, 2021,3947,2562, 2022,3948,2563, 
2023,3949,2564, 2024,3950,2565, 2025,3951,2566, 2026,3952,2567, 2027,3953,2568, 34796,3954,2569, 34793,3951,2570, 2029,3955,2571, 34792,3950,2565, 
20, // chain 942
2019,3956,2572, 2015,3957,2573, 2030,3958,2574, 
2031,3959,2575, 34800,3960,2576, 34801,3961,2577, 34802,3962,2578, 34803,3963,2579, 34797,3964,2571, 34804,3965,2580, 2037,3966,2581, 34806,3967,2582, 2039,3968,2583, 2040,3969,2584, 34809,3970,2585, 2021,3971,2562, 34810,3972,2586, 34811,3973,2587, 34778,3974,2588, 
34782,3975,2589, 34812,3976,2590, 34813,3977,2591, 
4, // chain 943
2015,3941,2560, 2017,3943,1877, 2046,3978,2592, 
34813,3979,2593, 34815,3980,1893, 34786,3944,1895, 
7, // chain 944
2030,3981,2594, 2015,3941,2560, 2046,3978,2592, 
2048,3982,2595, 34806,3983,2596, 34807,3984,2597, 34817,3985,2598, 34809,3986,2599, 34813,3979,2593, 
3, // chain 945
2032,3987,2600, 2023,3988,2564, 2012,3938,2559, 
2050,3989,2601, 34781,3939,1890, 
1, // chain 946
2041,3986,2599, 2039,3984,2597, 2049,3985,2598, 
2, // chain 947
2038,3983,2596, 2036,3990,2580, 2048,3982,2595, 
34798,3981,2574, 
2, // chain 948
2012,3938,2559, 2023,3988,2564, 2022,3991,2563, 
2010,3936,2558, 
1, // chain 949
2027,3953,2568, 2021,3947,2562, 2020,3946,2561, 
2, // chain 950
2023,3992,2564, 2035,3993,2579, 2024,3994,2565, 
34797,3995,2571, 
4, // chain 951
2029,3995,2571, 2037,3996,2602, 2028,3997,2569, 
34795,3998,2603, 34808,3999,2584, 2021,4000,2562, 
5, // chain 952
2042,3972,2586, 2051,4001,2604, 2021,3971,2562, 
34820,4002,2605, 2022,4003,2563, 34811,3973,2587, 2010,3974,2588, 
2, // chain 953
2043,4004,2606, 2053,4005,2607, 2054,4006,2608, 
2042,4007,2609, 
1, // chain 954
2053,4005,2607, 2051,4008,2610, 2054,4006,2608, 
1, // chain 955
2042,4009,2586, 2054,4006,1102, 2051,4008,2604, 
1, // chain 956
2043,4010,2606, 2052,4011,963, 2053,4005,2607, 
1, // chain 957
2051,4008,2604, 2053,4005,2611, 2052,4012,2605, 
1, // chain 958
2047,3980,1893, 2044,4013,2612, 2045,3979,2593, 
1, // chain 959
2050,3989,2601, 2031,4014,2613, 2032,3987,2600, 
2, // chain 960
2014,4015,1898, 2044,4016,1899, 2009,3935,1900, 
2008,3934,1901, 
4, // chain 961
2044,4017,963, 2047,4018,963, 2009,3935,963, 
34786,4019,963, 2006,3932,1902, 34787,4020,1903, 
2, // chain 962
2019,4021,1903, 2031,4022,1904, 2007,3933,1905, 
2006,3932,1902, 
4, // chain 963
2031,4023,1102, 2050,4024,1102, 2007,3933,1102, 
34776,3934,1901, 34781,4025,1102, 2014,4026,1898, 
5, // chain 964
2055,4027,2614, 2034,3962,2578, 2035,3963,2579, 
2056,4028,2615, 34791,4029,2616, 2033,3961,2577, 34800,3960,2576, 
2, // chain 965
2055,4030,2617, 2057,4031,2618, 2058,4032,2619, 
2034,4033,1102, 
1, // chain 966
2057,4031,2618, 2033,4034,2620, 2058,4032,2619, 
1, // chain 967
2034,4035,2578, 2058,4032,2609, 2033,4034,2577, 
1, // chain 968
2057,4031,2618, 2056,4036,963, 2033,4037,2620, 
1, // chain 969
2056,4038,2615, 2057,4031,2611, 2055,4030,2614, 
2, // chain 970
2059,4039,1907, 2060,4040,1907, 2061,4041,1907, 
2062,4042,1907, 
9, // chain 971
2063,4043,2621, 2060,4044,2622, 2064,4045,2623, 
2065,4046,2624, 2066,4047,2625, 34835,4048,2626, 2068,4049,1914, 34837,4050,2627, 2070,4051,2628, 34839,4052,2629, 2072,4053,2630, 
1, // chain 972
2060,4044,2622, 2059,4054,2631, 2064,4045,2623, 
8, // chain 973
2073,4055,766, 2074,4056,766, 2059,4057,766, 
34832,4058,766, 34843,4059,766, 2076,4060,766, 2065,4061,766, 34845,4062,766, 2078,4063,766, 2067,4064,766, 
1, // chain 974
2059,4057,766, 2062,4065,766, 2073,4055,766, 
6, // chain 975
2079,4066,694, 2080,4067,694, 2063,4068,694, 
34849,4069,694, 2060,4070,694, 34850,4071,694, 2061,4072,694, 34851,4073,694, 
1, // chain 976
2063,4068,694, 2066,4074,694, 2079,4066,694, 
2, // chain 977
2083,4075,1102, 2073,4076,1102, 2062,4042,1102, 
2061,4041,1102, 
6, // chain 978
2084,4077,2632, 2085,4078,2633, 2086,4079,1921, 
2087,4080,2634, 34856,4081,2635, 34857,4082,2636, 34858,4083,2637, 34853,4078,2633, 
10, // chain 979
2084,4077,2632, 2087,4080,2634, 2091,4084,2638, 
2092,4085,2639, 34861,4086,2640, 34862,4087,2641, 34863,4088,1940, 34855,4080,2634, 2096,4089,2642, 34865,4090,2643, 34866,4091,2644, 34856,4081,2635, 
3, // chain 980
2090,4092,2637, 2085,4093,2633, 2099,4094,2645, 
34868,4095,2646, 34869,4096,2647, 
6, // chain 981
2102,4097,2648, 2090,4092,2637, 2099,4094,2645, 
2103,4098,1933, 34872,4099,1934, 34873,4100,1935, 34874,4101,2649, 34868,4095,2646, 
3, // chain 982
2107,4102,2650, 2101,4103,2647, 2085,4078,2633, 
2084,4077,2632, 2092,4085,2639, 
8, // chain 983
2097,4090,2643, 2108,4104,2651, 2096,4089,2642, 
34871,4098,1933, 34877,4105,2652, 2102,4097,2648, 34878,4106,2653, 2111,4107,2654, 2090,4092,2637, 34857,4108,2636, 
4, // chain 984
2105,4100,1935, 2094,4087,2641, 2095,4088,1940, 
2104,4099,1934, 34864,4089,2642, 2103,4098,1933, 
3, // chain 985
2106,4109,2649, 2100,4110,2646, 2093,4111,2640, 
2105,4112,2655, 34862,4113,2641, 
3, // chain 986
2092,4114,2639, 2093,4111,2640, 2100,4110,2646, 
2107,4115,2656, 34869,4116,2647, 
6, // chain 987
2088,4117,2635, 2089,4118,1949, 2098,4119,2644, 
34879,4120,2654, 2097,4121,2643, 34878,4122,2653, 2108,4123,2657, 34877,4124,2652, 
7, // chain 988
2112,4125,2658, 2113,4126,2659, 2114,4127,2660, 
2115,4128,2661, 34884,4129,2662, 34885,4130,2663, 34886,4131,2664, 34887,4132,2665, 2120,4133,2666, 
1, // chain 989
2115,4134,2661, 2121,4135,2667, 2112,4136,2658, 
2, // chain 990
2122,4137,2668, 2120,4138,2666, 2123,4139,2669, 
2124,4140,2670, 
1, // chain 991
2123,4141,2671, 2120,4142,2672, 2119,4143,2673, 
1, // chain 992
2114,4144,2660, 2125,4145,929, 2119,4143,2665, 
1, // chain 993
2125,4145,2674, 2114,4144,963, 2113,4146,2659, 
10, // chain 994
2113,4147,2659, 2112,4148,2658, 2121,4149,2675, 
2125,4150,2674, 34894,4151,2676, 2127,4152,2677, 2117,4153,2663, 2128,4154,2678, 2119,4155,2673, 34891,4156,2671, 34895,4152,2679, 2124,4157,2680, 
5, // chain 995
2116,4158,2681, 2122,4137,2682, 2124,4140,2680, 
2127,4159,2679, 2126,4160,2683, 2115,4161,2661, 34889,4162,2667, 
1, // chain 996
2118,4163,2664, 2128,4164,2684, 2117,4165,2663, 
3, // chain 997
2120,4166,2666, 2122,4167,2668, 2127,4168,2685, 
2128,4164,2686, 2118,4163,2664, 
1, // chain 998
2127,4168,2677, 2122,4167,2687, 2117,4169,2663, 
1, // chain 999
2122,4170,2687, 2116,4129,2662, 2117,4130,2663, 
4, // chain 1000
2129,4171,2688, 2130,4172,2689, 2131,4173,2690, 
34900,4174,2691, 2133,4175,2692, 34902,4176,2693, 
1, // chain 1001
2131,4173,2690, 2135,4177,2694, 2129,4171,2688, 
2, // chain 1002
2136,4178,2695, 2131,4173,2690, 2137,4179,2696, 
34901,4175,2692, 
1, // chain 1003
2136,4178,2695, 2137,4179,2696, 2138,4180,2697, 
6, // chain 1004
2129,4181,2688, 2139,4182,2698, 2130,4183,2689, 
34908,4184,2699, 2132,4185,2700, 34909,4186,2701, 2142,4187,2702, 2134,4188,2703, 
2, // chain 1005
2134,4188,2704, 2142,4187,2705, 2143,4189,2706, 
2138,4190,2697, 
1, // chain 1006
2136,4191,2707, 2138,4190,2708, 2143,4189,2709, 
1, // chain 1007
2136,4192,2695, 2144,4193,2710, 2131,4194,2690, 
1, // chain 1008
2135,4195,2694, 2131,4194,963, 2144,4193,2711, 
9, // chain 1009
2135,4196,2694, 2144,4197,2711, 2139,4198,2712, 
34908,4199,2713, 34909,4200,2714, 34901,4201,2692, 34913,4202,2715, 34904,4203,2707, 2143,4204,2709, 2141,4200,2701, 34910,4205,2702, 
1, // chain 1010
2139,4198,2712, 2129,4206,2688, 2135,4196,2694, 
1, // chain 1011
2133,4207,2692, 2145,4208,2716, 2137,4209,2696, 
3, // chain 1012
2138,4210,2697, 2137,4209,2696, 2145,4208,2717, 
2141,4211,2718, 2134,4212,2704, 
1, // chain 1013
2133,4207,2692, 2134,4213,2693, 2141,4214,2714, 
2, // chain 1014
2146,4215,215, 2147,4216,215, 2148,4217,215, 
2149,4218,215, 
2, // chain 1015
2150,4219,2719, 2148,4220,2720, 2151,4221,2721, 
34915,4222,2722, 
2, // chain 1016
2150,4219,2719, 2151,4221,2721, 2152,4223,2723, 
2153,4224,2724, 
2, // chain 1017
2154,4225,2725, 2155,4226,2726, 2149,4227,2727, 
34914,4228,2011, 
3, // chain 1018
2154,4225,2725, 2149,4227,2727, 2156,4229,2728, 
2157,4230,2729, 2158,4231,2730, 
5, // chain 1019
2158,4232,2730, 2157,4233,2729, 2153,4234,2731, 
34918,4235,2732, 34924,4236,2733, 2149,4237,2734, 2148,4238,2735, 
2, // chain 1020
2159,4239,2736, 2160,4240,2737, 2155,4241,2726, 
2154,4242,2725, 
2, // chain 1021
2161,4243,215, 2162,4244,215, 2163,4245,215, 
2164,4246,215, 
4, // chain 1022
2164,4247,2007, 2163,4248,2738, 2165,4249,2739, 
34934,4250,2740, 2167,4251,2741, 34920,4223,2723, 
2, // chain 1023
2160,4252,2737, 2168,4253,2742, 2162,4254,2743, 
2161,4255,2021, 
2, // chain 1024
2167,4256,2741, 2152,4257,2723, 2151,4258,2721, 
2165,4259,2739, 
2, // chain 1025
2146,4260,2744, 2155,4261,2745, 2151,4262,2746, 
2147,4263,2041, 
2, // chain 1026
2160,4264,2737, 2165,4265,2739, 2151,4262,2721, 
2155,4261,2726, 
2, // chain 1027
2160,4264,2747, 2161,4266,2748, 2164,4267,2749, 
2165,4265,2750, 
2, // chain 1028
2166,4268,2740, 2163,4269,2738, 2162,4270,2743, 
2168,4271,2742, 
2, // chain 1029
2154,4225,2725, 2168,4253,2742, 2159,4272,2736, 
34928,4252,2737, 
2, // chain 1030
2169,4273,25, 2170,4274,25, 2171,4275,25, 
2172,4276,25, 
3, // chain 1031
2153,4277,2724, 2152,4278,2723, 2173,4279,2751, 
34942,4280,2752, 34934,4281,2740, 
4, // chain 1032
2166,4282,2740, 2168,4283,2753, 2175,4284,2754, 
34944,4285,2755, 34922,4286,2756, 2158,4287,2757, 
3, // chain 1033
2174,4288,2752, 2166,4282,2740, 2175,4284,2754, 
2177,4289,2758, 2178,4290,2759, 
4, // chain 1034
2158,4291,2730, 2153,4277,2731, 2173,4279,2760, 
2176,4292,2761, 34947,4293,2762, 2180,4294,2763, 
2, // chain 1035
2173,4279,2751, 2174,4280,2752, 2178,4295,2764, 
2179,4293,2765, 
2, // chain 1036
2175,4284,2754, 2176,4285,2755, 2180,4296,2766, 
2177,4289,2767, 
8, // chain 1037
2179,4297,25, 2178,4298,25, 2181,4299,25, 
34950,4300,25, 34945,4301,25, 2183,4302,25, 34948,4303,25, 2184,4304,25, 34947,4297,25, 2181,4299,25, 
2, // chain 1038
2184,4304,766, 2181,4299,766, 2169,4273,766, 
2172,4276,766, 
2, // chain 1039
2181,4299,1102, 2182,4300,1102, 2170,4274,1102, 
2169,4273,1102, 
2, // chain 1040
2182,4300,694, 2183,4302,694, 2171,4275,694, 
2170,4274,694, 
2, // chain 1041
2183,4302,963, 2184,4304,963, 2172,4276,963, 
2171,4275,963, 
12, // chain 1042
2185,4305,2046, 2186,4306,2768, 2187,4307,2048, 
34956,4308,2049, 34957,4309,2050, 2190,4310,2051, 34959,4311,2052, 2192,4312,2769, 34961,4313,2054, 2194,4314,2055, 34963,4315,2056, 2196,4316,2770, 34965,4317,2058, 34966,4318,2059, 
1, // chain 1043
2187,4307,2048, 2199,4319,2060, 2185,4305,2046, 
4, // chain 1044
2200,4320,2061, 2197,4321,2062, 2198,4322,2063, 
2201,4323,2064, 34953,4324,2046, 2199,4325,2060, 
12, // chain 1045
2199,4326,2065, 2187,4327,2066, 2201,4328,2064, 
34970,4329,2067, 34956,4330,2068, 2203,4331,2069, 34958,4332,2070, 2192,4333,2071, 2204,4334,2072, 34962,4335,2073, 2205,4336,2074, 34964,4337,2075, 2200,4338,2061, 34965,4339,2062, 
3, // chain 1046
2202,4329,2067, 2203,4331,2069, 2205,4336,2074, 
2200,4338,2061, 2201,4328,2064, 
1, // chain 1047
2203,4331,2069, 2204,4334,2072, 2205,4336,2074, 
6, // chain 1048
2206,4340,2771, 2207,4341,2772, 2208,4342,2773, 
2209,4343,2774, 2210,4344,2775, 2211,4345,2776, 2207,4341,2772, 34980,4346,2777, 
1, // chain 1049
2207,4341,2772, 2213,4347,2778, 2208,4342,2773, 
6, // chain 1050
2208,4348,2773, 2213,4349,2778, 2214,4350,2779, 
2209,4351,2774, 34978,4352,2775, 34979,4353,2776, 34980,4354,2777, 34981,4349,2778, 
8, // chain 1051
2215,4355,2780, 2216,4356,2781, 2217,4357,2782, 
2218,4358,2783, 2219,4359,2784, 34988,4360,2785, 2221,4361,2786, 2215,4355,2780, 34990,4362,2787, 2216,4356,2781, 
3, // chain 1052
2216,4363,2781, 2223,4364,2788, 2224,4365,2789, 
34989,4366,2786, 34990,4367,2787, 
4, // chain 1053
2217,4368,2782, 2216,4363,2781, 2224,4365,2789, 
2218,4369,2783, 34988,4370,2785, 34989,4366,2786, 
9, // chain 1054
2225,4371,2790, 2226,4372,2791, 2227,4373,2792, 
2228,4374,2793, 34997,4375,2794, 2230,4376,2795, 34999,4377,2796, 2232,4378,2797, 35001,4379,2798, 2234,4380,2799, 2235,4381,2800, 
11, // chain 1055
2236,4382,2801, 2227,4373,2792, 2226,4372,2791, 
2237,4383,2802, 2238,4384,2803, 2239,4385,2804, 35008,4386,2805, 2241,4387,2806, 35010,4388,2807, 35011,4389,2808, 2244,4390,2809, 2234,4391,2799, 2233,4392,2798, 
4, // chain 1056
2226,4393,2791, 2244,4394,2809, 2243,4395,2808, 
2237,4396,2802, 35006,4397,694, 35008,4398,2805, 
3, // chain 1057
2225,4399,2810, 2235,4400,2800, 2234,4401,2799, 
2226,4393,2811, 35012,4394,694, 
3, // chain 1058
2227,4402,766, 2236,4403,766, 2242,4404,2807, 
35007,4405,766, 2241,4406,2806, 
3, // chain 1059
2242,4404,2807, 2233,4407,2798, 2227,4402,766, 
34997,4408,766, 34999,4409,2796, 
5, // chain 1060
2245,4410,2812, 2246,4411,2813, 2247,4412,2814, 
2248,4413,2815, 2249,4414,2816, 35018,4415,2817, 2251,4416,2818, 
1, // chain 1061
2246,4411,2813, 2252,4417,2819, 2247,4412,2814, 
5, // chain 1062
2253,4418,2812, 2254,4419,2813, 2255,4420,2814, 
2256,4421,2815, 2257,4422,2820, 35026,4423,2817, 2259,4424,2818, 
1, // chain 1063
2254,4419,2813, 2260,4425,2819, 2255,4420,2814, 
4, // chain 1064
2261,4426,2821, 2262,4427,2822, 2263,4428,2823, 
2246,4411,2824, 35032,4429,2825, 2252,4417,2819, 
4, // chain 1065
2265,4430,2826, 2266,4431,2822, 2267,4432,2827, 
2254,4419,2828, 35036,4433,2825, 2260,4425,2819, 
4, // chain 1066
2251,4416,2818, 2262,4427,2822, 2261,4426,2821, 
2249,4414,2829, 35037,4434,2830, 35014,4411,2824, 
4, // chain 1067
2259,4424,2818, 2266,4431,2822, 2265,4430,2826, 
2257,4422,2829, 35038,4435,2831, 35022,4419,2828, 
3, // chain 1068
2251,4436,2818, 2250,4437,2817, 2263,4438,2823, 
35039,4439,2832, 35016,4440,2815, 
1, // chain 1069
2263,4438,2823, 2262,4441,2822, 2251,4436,2818, 
3, // chain 1070
2259,4442,2818, 2258,4443,2817, 2267,4444,2827, 
35040,4445,2833, 35024,4446,2815, 
1, // chain 1071
2267,4444,2827, 2266,4447,2822, 2259,4442,2818, 
4, // chain 1072
2247,4448,2814, 2252,4449,2819, 2264,4450,2825, 
2248,4440,2815, 35041,4451,2834, 35031,4438,2823, 
4, // chain 1073
2255,4452,2814, 2260,4453,2819, 2268,4454,2825, 
2256,4446,2815, 35042,4455,2835, 35035,4444,2827, 
2, // chain 1074
2246,4411,2813, 2245,4410,2812, 2275,4456,2836, 
35017,4414,2816, 
2, // chain 1075
2254,4419,2813, 2253,4418,2812, 2276,4457,2837, 
35025,4422,2820, 
2, // chain 1076
2248,4413,2815, 2273,4458,2834, 2246,4411,2813, 
2275,4456,2836, 
2, // chain 1077
2273,4458,2838, 2263,4428,2839, 2269,4434,2840, 
2246,4411,2841, 
2, // chain 1078
2263,4428,2823, 2271,4459,2832, 2249,4414,2829, 
2269,4434,2830, 
2, // chain 1079
2271,4459,2842, 2248,4413,2843, 2275,4456,2844, 
2249,4414,2845, 
2, // chain 1080
2256,4421,2815, 2274,4460,2835, 2254,4419,2813, 
2276,4457,2837, 
2, // chain 1081
2274,4460,2846, 2267,4432,2847, 2270,4435,2848, 
2254,4419,2849, 
2, // chain 1082
2267,4432,2827, 2272,4461,2833, 2257,4422,2829, 
2270,4435,2831, 
2, // chain 1083
2272,4461,2850, 2256,4421,2851, 2276,4457,2852, 
2257,4422,2853, 
4, // chain 1084
2277,4462,2854, 2278,4463,2855, 2279,4464,2856, 
2280,4465,2857, 2281,4466,2858, 35050,4467,2859, 
5, // chain 1085
2281,4468,2858, 2282,4469,2859, 2283,4470,2860, 
2284,4471,2861, 35046,4472,2855, 35050,4469,2859, 2279,4473,2856, 
2, // chain 1086
2285,4474,2862, 2286,4475,2863, 2277,4462,2854, 
2281,4466,2858, 
2, // chain 1087
2285,4474,2864, 2281,4466,2858, 2284,4476,2861, 
2286,4475,2863, 
2, // chain 1088
2286,4477,2863, 2284,4471,2861, 2278,4472,2855, 
2277,4478,2854, 
4, // chain 1089
2287,4479,2865, 2288,4480,2866, 2289,4481,2867, 
35058,4482,2868, 35059,4483,2869, 35060,4484,2870, 
6, // chain 1090
2292,4485,2870, 2287,4486,2865, 2293,4487,2871, 
35057,4488,2867, 2294,4489,2872, 2295,4490,2873, 2291,4491,2869, 2292,4485,2870, 
3, // chain 1091
2294,4492,2872, 2289,4481,2867, 2290,4482,2868, 
2295,4493,2873, 35059,4483,2869, 
3, // chain 1092
2225,4399,2790, 2228,4494,2793, 2235,4400,2800, 
34998,4495,694, 2232,4496,2797, 
34, // chain 1093
2296,4497,2874, 2297,4498,2875, 2298,4499,2876, 
2299,4500,2877, 35068,4501,2878, 35069,4502,2879, 35070,4503,2880, 35065,4498,2875, 2303,4504,2881, 35072,4505,2882, 2305,4506,2883, 35064,4507,2874, 2299,4508,2877, 2306,4509,2884, 35075,4510,2885, 2308,4511,2886, 35077,4512,2887, 2310,4513,2888, 2311,4514,2889, 
35080,4515,2890, 35081,4516,2891, 35082,4517,2892, 2315,4518,2893, 2316,4519,2894, 35085,4520,2895, 35086,4521,2896, 2319,4522,2897, 2320,4523,2898, 2316,4519,2894, 35089,4524,2899, 35090,4525,2900, 2323,4526,2901, 35092,4527,2902, 2325,4528,2903, 35086,4529,2896, 
35087,4530,2897, 
16, // chain 1094
2301,4502,2879, 2302,4503,2880, 2303,4504,2881, 
2326,4531,2904, 35073,4506,2883, 2306,4509,2884, 2327,4532,2905, 35076,4511,2886, 2311,4514,2889, 2328,4533,2906, 35080,4515,2890, 2329,4534,2907, 35081,4516,2891, 2316,4519,2894, 2330,4535,2908, 35089,4524,2899, 2325,4528,2903, 35091,4526,2901, 
24, // chain 1095
2307,4536,2885, 2299,4500,2877, 2300,4501,2878, 
2331,4537,2909, 35100,4538,2910, 35069,4502,2879, 2333,4539,2911, 35094,4531,2904, 2327,4532,2905, 2334,4540,2912, 35096,4533,2906, 2335,4541,2913, 35104,4542,2914, 35097,4534,2907, 2330,4535,2908, 2325,4528,2903, 2337,4543,2915, 35086,4529,2896, 2315,4544,2893, 
2314,4545,2892, 2335,4541,2913, 35106,4546,2916, 35078,4547,2888, 2309,4548,2887, 2331,4537,2909, 35075,4536,2885, 
4, // chain 1096
2332,4538,2910, 2333,4539,2911, 2334,4540,2912, 
2331,4537,2909, 35103,4541,2913, 2338,4546,2916, 
1, // chain 1097
2336,4542,2914, 2337,4543,2915, 2335,4541,2913, 
20, // chain 1098
2339,4549,2917, 2340,4550,2918, 2341,4551,2919, 
35110,4552,2920, 2343,4553,2921, 35112,4554,2922, 2345,4555,2923, 35114,4556,2924, 35115,4557,2925, 2348,4558,2926, 35117,4559,2927, 2350,4560,2928, 2351,4561,2929, 2352,4562,2930, 35121,4563,2931, 35122,4564,2932, 2355,4565,2933, 35124,4566,2934, 35125,4567,2935, 
2358,4568,2936, 35117,4569,2927, 35118,4570,2928, 
12, // chain 1099
2359,4571,2937, 2339,4549,2917, 2341,4551,2919, 
2360,4572,2938, 35111,4553,2921, 2361,4573,2939, 35113,4555,2923, 2362,4574,2940, 35131,4575,2941, 35132,4576,2942, 35114,4556,2924, 2353,4563,2931, 35116,4558,2926, 2352,4562,2930, 
5, // chain 1100
2340,4577,2918, 2339,4578,2917, 2365,4579,2943, 
2366,4580,2944, 35129,4573,2939, 35128,4572,2938, 35127,4571,2937, 
5, // chain 1101
2366,4580,2944, 2361,4573,2939, 2367,4581,2945, 
2368,4582,2946, 35137,4583,2947, 35130,4574,2940, 35129,4573,2939, 
8, // chain 1102
2340,4577,2918, 2366,4580,2944, 2368,4582,2946, 
2342,4584,2920, 35112,4585,2922, 35115,4586,2925, 35137,4583,2947, 2358,4568,2936, 35131,4575,2941, 35130,4574,2940, 
3, // chain 1103
2363,4575,2941, 2364,4576,2942, 2355,4565,2933, 
2356,4566,2934, 2358,4568,2936, 
1, // chain 1104
2364,4576,2942, 2353,4563,2931, 2355,4565,2933, 
1, // chain 1105
2349,4569,2927, 2347,4586,2925, 2358,4568,2936, 
22, // chain 1106
2370,4587,2948, 2371,4588,2949, 2372,4589,2950, 
35141,4590,2951, 35142,4591,2952, 2375,4592,2953, 35144,4593,2954, 2377,4594,2955, 35146,4595,2956, 2379,4596,2957, 35148,4597,2958, 2381,4598,2959, 2382,4599,2960, 35151,4600,2961, 2384,4601,2962, 35153,4602,2963, 2386,4603,2964, 2387,4604,2965, 35156,4605,2966, 
2389,4606,2967, 35158,4607,2968, 2391,4608,2969, 2392,4609,2970, 35161,4610,2971, 
24, // chain 1107
2393,4611,2971, 2394,4612,2972, 2395,4613,2973, 
35164,4614,2974, 35165,4615,2975, 2398,4616,2976, 2399,4617,2977, 35168,4618,2978, 2401,4619,2979, 2402,4620,2980, 35171,4621,2981, 2404,4622,2982, 35173,4623,2983, 2406,4624,2984, 35175,4625,2985, 2408,4626,2986, 35177,4627,2987, 2410,4628,2988, 35179,4629,2989, 
2412,4630,2990, 2413,4631,2991, 35182,4632,2992, 2415,4633,2993, 2416,4634,2994, 35140,4635,2950, 35138,4636,2948, 
1, // chain 1108
2395,4613,2973, 2392,4637,2970, 2393,4611,2971, 
12, // chain 1109
2417,4638,2995, 2418,4639,2996, 2416,4640,2994, 
35187,4641,2997, 35188,4642,2998, 2413,4643,2991, 35178,4644,2999, 35189,4645,3000, 35190,4646,3001, 2423,4647,3002, 35192,4648,3003, 2408,4649,3004, 2410,4644,2999, 2421,4645,3000, 
16, // chain 1110
2424,4650,3003, 2425,4651,3005, 2426,4652,3006, 
35195,4653,3007, 2404,4654,2982, 35196,4655,3008, 2402,4656,2980, 35197,4657,3009, 2399,4658,3010, 35198,4659,3011, 2396,4660,3012, 35199,4661,3013, 35200,4662,3014, 2395,4663,2973, 35201,4664,3015, 2392,4665,2970, 35157,4666,3016, 35202,4667,3017, 
3, // chain 1111
2429,4657,3018, 2428,4655,3008, 2435,4668,3019, 
2436,4669,3020, 2430,4659,3021, 
2, // chain 1112
2437,4670,3022, 2438,4671,3023, 2434,4667,3024, 
35207,4672,3025, 
1, // chain 1113
2434,4667,3024, 2433,4664,3015, 2437,4670,3022, 
2, // chain 1114
2439,4673,3025, 2440,4674,3026, 2434,4675,3024, 
35209,4676,3027, 
8, // chain 1115
2442,4677,3028, 2443,4678,3029, 2444,4679,3030, 
2445,4680,3031, 35214,4681,3032, 35150,4682,3033, 35211,4678,3029, 2379,4683,3034, 35215,4684,3035, 35210,4677,3028, 
3, // chain 1116
2447,4684,3035, 2448,4685,3036, 2449,4686,3037, 
2377,4687,3038, 2379,4683,3034, 
3, // chain 1117
2449,4688,3037, 2450,4689,3039, 2451,4690,3040, 
35220,4691,3041, 2453,4692,3042, 
1, // chain 1118
2417,4638,2995, 2453,4692,3042, 2454,4693,3043, 
3, // chain 1119
2441,4676,3044, 2445,4680,3031, 2446,4681,3032, 
2384,4694,3045, 35150,4682,3033, 
2, // chain 1120
2453,4692,3046, 2417,4638,2995, 2372,4695,2950, 
35184,4640,2994, 
5, // chain 1121
2453,4692,3046, 2372,4695,2950, 2373,4696,3047, 
2451,4690,3040, 35143,4697,3048, 2449,4688,3037, 35145,4698,3038, 
3, // chain 1122
2384,4694,3045, 2387,4699,3049, 2441,4676,3044, 
35202,4675,3017, 35157,4700,3016, 
1, // chain 1123
2395,4663,2973, 2396,4660,3012, 2431,4661,3013, 
3, // chain 1124
2426,4652,3006, 2404,4654,2982, 2406,4701,2984, 
2408,4702,3004, 2424,4650,3003, 
1, // chain 1125
2416,4640,2994, 2419,4641,2997, 2413,4643,2991, 
4, // chain 1126
2455,4703,3050, 2456,4704,3051, 2457,4705,3052, 
2458,4706,3053, 35227,4707,3054, 35228,4708,3055, 
16, // chain 1127
2461,4709,3056, 2462,4710,3057, 2463,4711,3058, 
2464,4712,3059, 2465,4713,3060, 35234,4714,3061, 2467,4715,3062, 35236,4716,3063, 2469,4717,3064, 35227,4718,3054, 2470,4719,3065, 35239,4720,3066, 35228,4721,3055, 2472,4722,3067, 35241,4723,3068, 2474,4724,3069, 35231,4711,3058, 2462,4710,3057, 
1, // chain 1128
2472,4722,3067, 2474,4724,3069, 2475,4725,3070, 
8, // chain 1129
2476,4726,3071, 2477,4727,3072, 2478,4728,3073, 
2462,4729,3057, 35247,4730,3074, 35248,4731,3075, 35249,4732,3076, 35250,4733,3077, 2483,4734,3078, 35252,4735,3079, 
19, // chain 1130
2480,4731,3075, 2485,4736,3080, 2479,4730,3074, 
35254,4737,3081, 2475,4738,3070, 35255,4739,3082, 2488,4740,3083, 2472,4741,3067, 35257,4742,3084, 35258,4743,3085, 2491,4744,3086, 2470,4745,3065, 35237,4746,3064, 35260,4747,3087, 2493,4748,3088, 2467,4749,3062, 35262,4750,3089, 35263,4751,3090, 2496,4752,3091, 
2476,4726,3071, 35245,4727,3072, 
53, // chain 1131
2497,4753,3092, 2484,4754,3079, 2498,4755,3093, 
2499,4756,3094, 35268,4757,3095, 35269,4758,3096, 35270,4759,3097, 35252,4754,3079, 2503,4760,3098, 2504,4761,3099, 35273,4762,3100, 35274,4763,3101, 35275,4764,3102, 2508,4765,3103, 2509,4766,3104, 35278,4767,3105, 2511,4768,3106, 35280,4769,3107, 2513,4770,3108, 
35282,4771,3109, 2515,4772,3110, 35284,4773,3111, 2517,4774,3112, 2518,4775,3113, 35287,4776,3114, 2520,4777,3115, 35289,4778,3116, 2522,4779,3117, 35291,4780,3118, 35292,4781,3119, 35293,4782,3120, 2526,4783,3121, 2527,4784,3122, 35296,4785,3123, 2529,4786,3124, 
35298,4787,3125, 2531,4788,3126, 35300,4789,3127, 35301,4790,3128, 2534,4791,3129, 2535,4792,3130, 35304,4793,3131, 2537,4794,3132, 35306,4795,3133, 2539,4796,3134, 35308,4797,3135, 35309,4798,3136, 35310,4799,3137, 2543,4800,3138, 2544,4801,3139, 35313,4802,3140, 
2546,4803,3141, 35267,4756,3094, 35315,4804,3142, 2497,4753,3092, 
66, // chain 1132
2499,4756,3094, 2500,4757,3095, 2546,4803,3141, 
35316,4805,3143, 35317,4806,3144, 35269,4758,3096, 2550,4807,3145, 35319,4808,3146, 35320,4809,3147, 35270,4759,3097, 2504,4761,3099, 2553,4810,3148, 35322,4811,3149, 35273,4762,3100, 2555,4812,3150, 35274,4763,3101, 2509,4766,3104, 2556,4813,3151, 35279,4768,3106, 
2557,4814,3152, 35326,4815,3153, 35327,4816,3154, 35281,4770,3108, 2560,4817,3155, 35329,4818,3156, 35283,4772,3110, 2562,4819,3157, 35286,4775,3113, 2563,4820,3158, 35332,4821,3159, 35288,4777,3115, 2522,4779,3117, 2565,4822,3160, 35334,4823,3161, 35291,4780,3118, 
2567,4824,3162, 35336,4825,3163, 35292,4781,3119, 2527,4784,3122, 2569,4826,3164, 35297,4786,3124, 2570,4827,3165, 35339,4828,3166, 35299,4788,3126, 2572,4829,3167, 35341,4830,3168, 35300,4789,3127, 2574,4831,3169, 35303,4792,3130, 2575,4832,3170, 35305,4794,3132, 
2576,4833,3171, 35307,4796,3134, 2577,4834,3172, 35308,4797,3135, 2578,4835,3173, 35347,4836,3174, 35348,4837,3175, 35309,4798,3136, 2544,4801,3139, 2581,4838,3176, 35314,4803,3141, 2548,4805,3143, 2582,4839,3177, 35351,4840,3178, 35352,4841,3179, 35317,4806,3144, 
2550,4807,3145, 
23, // chain 1133
2559,4816,3154, 2560,4817,3155, 2585,4842,3180, 
2558,4815,3153, 35354,4843,3181, 2587,4844,3182, 2588,4845,3183, 35357,4846,3184, 2557,4814,3152, 35358,4847,3185, 2591,4848,3186, 2556,4813,3151, 35360,4849,3187, 2555,4812,3150, 35361,4850,3188, 2594,4851,3189, 2595,4852,3190, 2554,4811,3149, 35364,4853,3191, 
2597,4854,3192, 35366,4855,3193, 2599,4856,3194, 35368,4857,3195, 2551,4808,3146, 2552,4809,3147, 
4, // chain 1134
2579,4836,3174, 2580,4837,3175, 2581,4838,3176, 
2582,4839,3177, 2601,4858,3196, 2578,4835,3173, 
11, // chain 1135
2571,4828,3166, 2572,4829,3167, 2570,4827,3165, 
35370,4859,3197, 35371,4860,3198, 35341,4830,3168, 2604,4861,3199, 35342,4831,3169, 2605,4862,3200, 35343,4832,3170, 2576,4833,3171, 2606,4863,3201, 35345,4834,3172, 
12, // chain 1136
2569,4826,3164, 2570,4827,3165, 2607,4864,3202, 
2608,4865,3203, 2567,4824,3162, 35377,4866,3204, 2566,4823,3161, 35378,4867,3205, 2565,4822,3160, 35379,4868,3206, 2612,4869,3207, 35381,4870,3208, 2614,4871,3209, 35383,4872,3210, 
1, // chain 1137
2567,4824,3162, 2568,4825,3163, 2569,4826,3164, 
3, // chain 1138
2564,4821,3159, 2565,4822,3160, 2612,4869,3207, 
2614,4871,3209, 2563,4820,3158, 
1, // chain 1139
2588,4845,3183, 2557,4814,3152, 2558,4815,3153, 
1, // chain 1140
2597,4854,3192, 2553,4810,3148, 2554,4811,3149, 
2, // chain 1141
2599,4873,3194, 2552,4874,3147, 2553,4875,3148, 
2597,4876,3192, 
2, // chain 1142
2602,4859,3197, 2616,4877,3211, 2570,4827,3165, 
35375,4864,3202, 
6, // chain 1143
2617,4878,3212, 2598,4879,3193, 2596,4880,3191, 
2618,4881,3213, 2619,4882,3214, 35388,4883,3215, 2454,4884,3043, 35185,4885,2995, 
14, // chain 1144
2621,4886,3216, 2622,4887,3217, 2623,4888,3218, 
2617,4889,3212, 35366,4890,3193, 35368,4891,3195, 35390,4887,3217, 2624,4892,3219, 35393,4893,3220, 35389,4886,3216, 2626,4894,3221, 35385,4889,3212, 2619,4895,3214, 2625,4893,3220, 35395,4896,3222, 2624,4892,3219, 
6, // chain 1145
2600,4897,3195, 2624,4898,3219, 2551,4899,3146, 
35396,4900,3223, 35395,4901,3222, 2453,4902,3042, 35222,4884,3043, 35387,4882,3214, 
6, // chain 1146
2550,4903,3145, 2551,4904,3146, 2629,4905,3224, 
2630,4906,3225, 35399,4907,3226, 35400,4908,3227, 35396,4909,3223, 35319,4904,3146, 
8, // chain 1147
2550,4903,3145, 2630,4906,3225, 2584,4910,3179, 
35401,4911,3228, 35402,4912,3229, 35399,4907,3226, 2635,4913,3230, 35400,4908,3227, 2636,4914,3231, 35396,4909,3223, 
14, // chain 1148
2637,4915,3232, 2638,4916,3233, 2639,4917,3234, 
2640,4918,3235, 2641,4919,3236, 2642,4920,3237, 35411,4921,3238, 35412,4922,3239, 2645,4923,3240, 35414,4924,3241, 35415,4925,3242, 2648,4926,3243, 2649,4927,3244, 35418,4928,3245, 2638,4916,3233, 35407,4917,3234, 
23, // chain 1149
2651,4929,3246, 2605,4930,3200, 2606,4931,3201, 
2652,4932,3247, 35421,4933,3248, 2654,4934,3249, 35423,4935,3250, 2656,4936,3251, 2657,4937,3252, 35426,4938,3253, 2659,4939,3254, 35428,4940,3255, 2661,4941,3256, 35430,4942,3257, 2663,4943,3258, 2664,4944,3259, 35433,4945,3260, 2602,4946,3197, 2603,4947,3198, 
2666,4948,3261, 35435,4949,3262, 35436,4950,3263, 35372,4951,3199, 2605,4930,3200, 2651,4929,3246, 
9, // chain 1150
2615,4952,3210, 2613,4953,3208, 2669,4954,3264, 
2670,4955,3265, 35439,4956,3266, 35440,4957,3267, 2673,4958,3268, 2674,4959,3269, 35195,4960,3007, 35443,4961,3270, 2428,4962,3008, 
4, // chain 1151
2591,4963,3186, 2676,4964,3271, 2592,4965,3187, 
35445,4966,3272, 35446,4967,3273, 2679,4968,3274, 
4, // chain 1152
2680,4969,3275, 2593,4970,3188, 2592,4971,3187, 
2677,4972,3272, 2681,4973,3276, 35447,4974,3274, 
4, // chain 1153
2618,4975,3213, 2596,4976,3191, 2595,4977,3190, 
2682,4978,3277, 35451,4979,3278, 35362,4980,3189, 
4, // chain 1154
2684,4981,3279, 2583,4982,3178, 2584,4983,3179, 
2633,4984,3228, 2685,4985,3280, 35402,4986,3229, 
1, // chain 1155
2642,4920,3237, 2686,4987,3281, 2637,4915,3232, 
7, // chain 1156
2601,4988,3196, 2687,4989,3282, 2578,4990,3173, 
35456,4991,3283, 35457,4992,3284, 2442,4993,3028, 35458,4994,3285, 2447,4995,3035, 35459,4996,3286, 
4, // chain 1157
2692,4997,3287, 2693,4998,3288, 2694,4999,3289, 
2695,5000,3290, 2696,5001,3291, 35465,5002,3292, 
19, // chain 1158
2602,5003,3197, 2665,5004,3260, 2616,5005,3211, 
35466,5006,3293, 35431,5007,3258, 2699,5008,3294, 35205,5009,3022, 35430,5010,3257, 2438,5011,3023, 35428,5012,3255, 2439,5013,3025, 35426,5014,3253, 2440,5015,3026, 35424,5016,3251, 2441,5017,3027, 35423,5018,3250, 2445,5019,3031, 35421,5020,3248, 2700,5021,3295, 
35345,5022,3172, 35374,5023,3201, 
3, // chain 1159
2613,4953,3208, 2701,5024,3296, 2702,5025,3297, 
35471,5026,3298, 35443,4961,3270, 
5, // chain 1160
2704,5027,3299, 2587,5028,3182, 2586,5029,3181, 
2705,5030,3300, 2706,5031,3301, 35192,5032,3003, 2422,5033,3001, 
3, // chain 1161
2587,5034,3182, 2704,5035,3299, 2707,5036,3302, 
35474,5037,3301, 2708,5038,3303, 
1, // chain 1162
2707,5036,3302, 2589,5039,3184, 2587,5034,3182, 
4, // chain 1163
2591,5040,3186, 2590,5041,3185, 2709,5042,3304, 
2676,5043,3271, 35446,5044,3273, 35478,5045,3305, 
6, // chain 1164
2711,5046,3306, 2652,4932,3247, 2654,4934,3249, 
2657,4937,3252, 2659,4939,3254, 2666,4948,3261, 35429,4941,3256, 2664,4944,3259, 
13, // chain 1165
2712,5047,3307, 2670,5048,3265, 2713,5049,3308, 
2714,5050,3309, 2715,5051,3310, 2716,5052,3311, 35485,5053,3312, 2718,5054,3313, 35487,5055,3314, 2720,5056,3315, 35489,5057,3316, 2674,5058,3269, 35481,5049,3308, 2671,5059,3266, 35438,5048,3265, 
4, // chain 1166
2620,5060,3215, 2618,4975,3213, 2682,4978,3277, 
2722,5061,3317, 35451,4979,3278, 2723,5062,3318, 
10, // chain 1167
2636,5063,3231, 2628,4900,3223, 2453,4902,3042, 
2452,5064,3041, 2635,5065,3230, 35218,5066,3039, 2449,5067,3037, 2634,5068,3229, 35453,5069,3280, 35216,5070,3036, 2691,5071,3286, 35215,5072,3035, 
4, // chain 1168
2442,4993,3028, 2445,5019,3031, 2688,4991,3283, 
35468,5021,3295, 2577,5022,3172, 2578,4990,3173, 
2, // chain 1169
2724,5073,3319, 2725,5074,3320, 2435,5075,3019, 
2726,5076,3321, 
3, // chain 1170
2703,5077,3298, 2675,5078,3270, 2672,5079,3267, 
2669,5080,3264, 2702,5081,3297, 
1, // chain 1171
2675,5078,3270, 2673,5082,3268, 2672,5079,3267, 
2, // chain 1172
2727,5083,3322, 2486,4737,3081, 2728,5084,3323, 
2542,5085,3137, 
2, // chain 1173
2729,5086,3324, 2496,4752,3325, 2730,5087,3326, 
2510,5088,3327, 
2, // chain 1174
2731,5089,3328, 2493,4748,3088, 2732,5090,3329, 
2516,5091,3330, 
2, // chain 1175
2733,5092,3331, 2491,4744,3086, 2734,5093,3332, 
2525,5094,3120, 
2, // chain 1176
2735,5095,3333, 2488,4740,3334, 2736,5096,3335, 
2533,5097,3336, 
5, // chain 1177
2464,5098,3337, 2463,5099,3338, 2455,5100,3050, 
35224,5101,3051, 35241,5102,3339, 2457,5103,3052, 35228,5104,3055, 
4, // chain 1178
2466,5105,3340, 2464,5098,3337, 2455,5100,3050, 
2458,5106,3053, 2468,5107,3341, 35227,5108,3054, 
4, // chain 1179
2476,4726,3071, 2462,4729,3057, 2461,5109,3056, 
2465,5110,3060, 2494,4750,3089, 35235,4749,3062, 
2, // chain 1180
2474,5111,3069, 2462,4729,3057, 2479,4730,3074, 
2475,4738,3070, 
2, // chain 1181
2472,4741,3067, 2489,4742,3342, 2471,5112,3066, 
35238,4745,3065, 
4, // chain 1182
2737,5113,3343, 2738,5114,3344, 2507,5115,3102, 
35276,5116,3345, 35507,5117,3346, 2510,5118,3327, 
3, // chain 1183
2507,5115,3102, 2503,5119,3098, 2737,5113,3343, 
35508,5120,3347, 35252,5121,3079, 
10, // chain 1184
2484,5122,3079, 2482,5123,3348, 2740,5124,3347, 
35509,5125,3349, 35246,5126,3073, 2477,5127,3072, 2742,5128,3350, 35511,5129,3351, 35264,5130,3091, 2729,5131,3324, 2739,5132,3346, 35278,5133,3327, 
1, // chain 1185
2728,5134,3323, 2486,5135,3081, 2744,5136,3352, 
2, // chain 1186
2744,5137,3352, 2486,5138,3081, 2485,5139,3080, 
2480,5140,3075, 
3, // chain 1187
2745,5141,3353, 2481,5142,3076, 2483,5143,3078, 
2746,5144,3354, 35252,5145,3079, 
6, // chain 1188
2542,5146,3137, 2538,5147,3133, 2747,5148,3355, 
35304,5149,3131, 2748,5150,3356, 35302,5151,3357, 2749,5152,3358, 35301,5153,3359, 
1, // chain 1189
2747,5148,3355, 2750,5154,3360, 2542,5146,3137, 
10, // chain 1190
2533,5155,3359, 2736,5156,3335, 2749,5157,3358, 
35519,5158,3361, 35256,5159,3334, 2752,5160,3362, 35255,5161,3082, 2753,5162,3363, 35254,5163,3081, 2727,5164,3322, 2750,5165,3360, 35310,5166,3137, 
6, // chain 1191
2533,5167,3336, 2530,5168,3364, 2754,5169,3365, 
35523,5170,3366, 35296,5171,3367, 2526,5172,3368, 2756,5173,3369, 35293,5174,3370, 
1, // chain 1192
2754,5169,3365, 2757,5175,3371, 2533,5167,3336, 
10, // chain 1193
2525,5176,3370, 2734,5177,3332, 2756,5178,3369, 
35526,5179,3372, 35259,5180,3086, 2490,5181,3085, 2759,5182,3373, 35528,5183,3374, 35256,5184,3083, 2735,5185,3333, 2757,5186,3371, 35301,5187,3336, 
6, // chain 1194
2525,5188,3120, 2521,5189,3116, 2761,5190,3375, 
35287,5191,3376, 2762,5192,3377, 35285,5193,3378, 2763,5194,3379, 35284,5195,3380, 
1, // chain 1195
2761,5190,3375, 2764,5196,3381, 2525,5188,3120, 
10, // chain 1196
2516,5197,3380, 2732,5198,3329, 2763,5199,3379, 
35533,5200,3382, 35261,5201,3088, 2492,5202,3087, 2766,5203,3383, 35259,5204,3086, 2767,5205,3384, 35501,5206,3331, 2764,5207,3381, 35293,5208,3120, 
5, // chain 1197
2516,5209,3330, 2514,5210,3385, 2768,5211,3386, 
35280,5212,3107, 2769,5213,3387, 35538,5214,3388, 35278,5215,3105, 
1, // chain 1198
2768,5211,3386, 2771,5216,3389, 2516,5209,3330, 
10, // chain 1199
2510,5217,3105, 2730,5218,3326, 2770,5219,3388, 
35540,5220,3390, 35264,5221,3325, 2773,5222,3391, 35263,5223,3392, 2493,5224,3393, 2774,5225,3394, 35499,5226,3328, 2771,5227,3389, 35284,5228,3330, 
11, // chain 1200
2620,5229,3215, 2722,5230,3317, 2417,5231,2995, 
35186,5232,2996, 35491,5233,3318, 2681,5234,3276, 2420,5235,2998, 35447,5236,3274, 2678,5237,3273, 2710,5238,3305, 2422,5239,3001, 35476,5240,3303, 2706,5241,3301, 
1, // chain 1201
2437,5009,3022, 2433,5242,3015, 2699,5008,3294, 
7, // chain 1202
2433,5243,3015, 2432,5244,3014, 2775,5245,3395, 
35544,5246,3396, 35198,5247,3021, 2436,5248,3020, 2777,5249,3397, 35493,5250,3320, 35203,5251,3019, 
1, // chain 1203
2775,5245,3395, 2699,5252,3294, 2433,5243,3015, 
2, // chain 1204
2435,5253,3019, 2428,5254,3008, 2675,5255,3270, 
2726,5256,3321, 
13, // chain 1205
2427,4960,3007, 2425,5257,3005, 2674,4959,3269, 
35488,5258,3315, 35486,5259,3313, 35192,5260,3003, 2705,5261,3300, 2716,5262,3311, 35354,5263,3181, 2585,5264,3180, 2778,5265,3398, 2712,5266,3307, 35547,5267,3399, 2670,4955,3265, 35383,4952,3210, 
2, // chain 1206
2724,5073,3319, 2611,5268,3206, 2780,5269,3400, 
2725,5074,3320, 
1, // chain 1207
2611,5268,3206, 2610,5270,3205, 2780,5269,3400, 
1, // chain 1208
2610,5271,3205, 2725,5272,3320, 2780,5273,3400, 
5, // chain 1209
2753,5274,215, 2750,5275,3360, 2747,5276,3355, 
2752,5277,215, 35519,5278,215, 35517,5279,215, 35516,5280,3356, 
2, // chain 1210
2760,5281,215, 2757,5282,215, 2755,5283,3366, 
35522,5284,3365, 
3, // chain 1211
2756,5285,3369, 2758,5286,215, 2755,5283,3366, 
35527,5287,215, 2760,5281,215, 
5, // chain 1212
2767,5288,215, 2764,5289,3381, 2761,5290,3375, 
2766,5291,215, 35533,5292,215, 35531,5293,215, 35530,5294,3377, 
2, // chain 1213
2774,5295,215, 2771,5296,215, 2769,5297,3387, 
35536,5298,3386, 
3, // chain 1214
2770,5299,3388, 2772,5300,215, 2769,5297,3387, 
35541,5301,215, 2774,5295,215, 
2, // chain 1215
2743,5302,215, 2739,5303,215, 2737,5304,3343, 
35506,5305,3344, 
3, // chain 1216
2740,5306,3347, 2741,5307,215, 2737,5304,3343, 
35510,5308,215, 2743,5302,215, 
2, // chain 1217
2778,5309,3398, 2585,4842,3180, 2781,5310,3401, 
35328,4817,3155, 
6, // chain 1218
2607,5311,3202, 2616,5312,3211, 2782,5313,3402, 
2608,5314,3203, 35551,5315,3403, 2609,5316,3204, 35552,5317,3404, 2610,5318,3205, 
3, // chain 1219
2616,5319,3211, 2698,5320,3293, 2782,5321,3402, 
35553,5322,3405, 35467,5323,3294, 
6, // chain 1220
2699,5324,3294, 2775,5325,3395, 2785,5326,3405, 
35554,5327,3406, 35544,5328,3396, 2787,5329,3407, 35545,5330,3397, 2725,5331,3320, 
2, // chain 1221
2784,5332,3404, 2787,5333,3407, 2725,5334,3320, 
2610,5335,3205, 
2, // chain 1222
2784,5336,3404, 2783,5337,3403, 2786,5327,3406, 
2787,5338,3407, 
2, // chain 1223
2783,5337,3403, 2782,5339,3402, 2785,5340,3405, 
2786,5327,3406, 
20, // chain 1224
2788,5341,3408, 2789,5342,3409, 2371,5343,2949, 
35558,5344,3410, 2374,5345,2952, 35559,5346,3411, 2376,5347,2954, 35146,5348,2956, 35560,5349,3412, 2380,5350,2958, 35149,5351,2959, 35561,5352,3413, 2383,5353,2961, 35153,5354,2963, 35562,5355,3414, 2386,5356,2964, 35156,5357,2966, 35563,5358,3415, 2390,5359,2968, 
35159,5360,2969, 35564,5361,3416, 2393,5362,2971, 
1, // chain 1225
2371,5343,2949, 2370,5363,2948, 2788,5341,3408, 
23, // chain 1226
2394,5364,2972, 2393,5365,2971, 2796,5366,3416, 
2797,5367,3417, 2397,5368,2975, 35566,5369,3418, 2398,5370,2976, 35567,5371,3419, 2400,5372,2978, 35169,5373,2979, 35568,5374,3420, 2403,5375,2981, 35173,5376,2983, 35175,5377,2985, 35569,5378,3421, 2409,5379,2987, 35570,5380,3422, 2411,5381,2989, 35180,5382,2990, 
35571,5383,3423, 2414,5384,2992, 35572,5385,3424, 2415,5386,2993, 35556,5387,3408, 2370,5388,2948, 
1, // chain 1227
2669,4954,3264, 2613,4953,3208, 2702,5025,3297, 
4, // chain 1228
2805,5389,3425, 2806,5390,3426, 2807,5391,3427, 
35576,5392,3428, 35577,5393,3429, 35578,5394,3430, 
6, // chain 1229
2811,5395,3431, 2807,5391,3427, 2812,5396,3432, 
2813,5397,3433, 35582,5398,3434, 35577,5393,3429, 35576,5392,3428, 35575,5391,3427, 
5, // chain 1230
2815,5399,3435, 2811,5395,3431, 2813,5397,3433, 
2816,5400,3436, 35585,5401,3437, 35586,5402,3438, 35582,5398,3434, 
4, // chain 1231
2819,5403,3439, 2816,5400,3436, 2817,5401,3437, 
2820,5404,3440, 35589,5405,3441, 35586,5402,3438, 
4, // chain 1232
2589,5406,3184, 2707,5407,3302, 2590,5408,3185, 
35477,5409,3304, 35478,5410,3305, 35476,5411,3303, 
3, // chain 1233
2683,5412,3278, 2594,5413,3189, 2680,5414,3275, 
2723,5415,3318, 35449,5416,3276, 
1, // chain 1234
2594,5413,3189, 2593,5417,3188, 2680,5414,3275, 
7, // chain 1235
2744,5418,3352, 2480,5419,3075, 2822,5420,3442, 
2728,5421,3323, 35311,5422,3138, 35591,5423,3443, 35513,5424,3353, 35249,5425,3076, 35248,5419,3075, 
4, // chain 1236
2745,5424,3353, 2746,5426,3354, 2823,5423,3443, 
35315,5427,3142, 35265,5428,3092, 35252,5429,3079, 
2, // chain 1237
2545,5430,3140, 2543,5422,3138, 2823,5423,3443, 
2547,5427,3142, 
1, // chain 1238
2542,5431,3137, 2728,5421,3323, 2543,5422,3138, 
3, // chain 1239
2583,5432,3178, 2684,5433,3279, 2649,5434,3244, 
35414,5435,3241, 35453,5436,3280, 
1, // chain 1240
2649,5434,3244, 2638,5437,3233, 2583,5432,3178, 
5, // chain 1241
2685,5438,3280, 2691,5439,3286, 2646,5440,3241, 
35413,5441,3240, 35458,5442,3285, 2643,5443,3238, 35457,5444,3284, 
4, // chain 1242
2689,5445,3284, 2687,5446,3282, 2643,5447,3238, 
35410,5448,3237, 35454,5449,3281, 35369,5450,3196, 
4, // chain 1243
2601,5451,3196, 2582,5452,3177, 2686,5453,3281, 
35405,5454,3232, 35406,5455,3233, 35351,5456,3178, 
14, // chain 1244
2824,5457,3444, 2825,5458,3445, 2826,5459,3446, 
2827,5460,3447, 35596,5461,3448, 35597,5462,3449, 35593,5458,3445, 2830,5463,3450, 35599,5464,3451, 35592,5457,3444, 2827,5460,3447, 2832,5465,3452, 2830,5463,3450, 35601,5466,3453, 2829,5462,3449, 35596,5461,3448, 
14, // chain 1245
2834,5467,3454, 2835,5468,3455, 2836,5469,3456, 
2837,5470,3457, 35606,5471,3458, 35607,5472,3459, 35603,5468,3455, 2840,5473,3460, 35602,5467,3454, 2841,5474,3461, 35605,5470,3457, 2842,5475,3462, 35606,5471,3458, 2843,5476,3463, 35607,5472,3459, 2840,5473,3460, 
2, // chain 1246
2844,5477,3464, 2845,5478,3465, 2846,5479,3466, 
2847,5480,3467, 
2, // chain 1247
2848,5481,3468, 2849,5482,3469, 2850,5483,3470, 
2851,5484,3471, 
14, // chain 1248
2613,5485,3208, 2611,5486,3206, 2852,5487,3472, 
35621,5488,3473, 35492,5489,3319, 2854,5490,3474, 35623,5491,3475, 35494,5492,3321, 2856,5493,3476, 35443,5494,3270, 2701,5495,3296, 2857,5496,3477, 35626,5497,3478, 35381,5485,3208, 2859,5498,3479, 35620,5487,3472, 
2, // chain 1249
2853,5488,3473, 2854,5490,3474, 2857,5496,3477, 
2858,5497,3478, 
8, // chain 1250
2854,5499,3474, 2855,5500,3475, 2860,5501,3480, 
35629,5502,3481, 35624,5503,3476, 2862,5504,3482, 35625,5505,3477, 2863,5506,3483, 35622,5499,3474, 2860,5501,3480, 
2, // chain 1251
2859,5507,3479, 2852,5508,3472, 2864,5509,3484, 
35621,5510,3473, 
4, // chain 1252
2864,5509,3484, 2865,5511,3485, 2859,5507,3479, 
35626,5512,3478, 35634,5513,3486, 2853,5510,3473, 
2, // chain 1253
2864,5514,3487, 2853,5515,3488, 2845,5516,3489, 
2844,5517,3464, 
2, // chain 1254
2853,5518,3473, 2866,5519,3486, 2846,5520,3466, 
2845,5521,3490, 
2, // chain 1255
2866,5522,3486, 2865,5523,3491, 2847,5524,3467, 
2846,5525,3466, 
2, // chain 1256
2865,5526,3491, 2864,5527,3487, 2844,5528,3464, 
2847,5529,3467, 
1, // chain 1257
2863,5530,3492, 2860,5531,3493, 2849,5532,3469, 
1, // chain 1258
2849,5532,3494, 2848,5533,3468, 2863,5530,3495, 
2, // chain 1259
2860,5534,3493, 2861,5535,3496, 2850,5536,3470, 
35619,5537,3471, 
1, // chain 1260
2850,5536,3470, 2849,5538,3469, 2860,5534,3493, 
1, // chain 1261
2861,5535,3497, 2862,5539,3498, 2851,5537,3471, 
2, // chain 1262
2862,5540,3498, 2863,5541,3495, 2848,5542,3468, 
2851,5543,3471, 
12, // chain 1263
2652,5544,3247, 2867,5545,3499, 2651,5546,3246, 
35436,5547,3500, 35636,5548,3501, 2869,5549,3502, 2667,5550,3262, 35638,5551,3503, 2666,5552,3261, 35639,5553,3504, 2711,5554,3505, 35640,5555,3506, 2873,5556,3507, 2652,5544,3247, 
2, // chain 1264
2867,5557,3499, 2652,5558,3247, 2694,5559,3289, 
2693,5560,3288, 
4, // chain 1265
2652,5561,3247, 2873,5562,3507, 2694,5563,3289, 
35463,5564,3290, 35640,5565,3506, 2871,5566,3504, 
2, // chain 1266
2871,5567,3504, 2870,5568,3503, 2697,5569,3292, 
2695,5570,3290, 
5, // chain 1267
2870,5571,3503, 2869,5572,3502, 2696,5573,3291, 
35460,5574,3287, 35636,5575,3501, 2693,5576,3288, 35635,5577,3499, 
1, // chain 1268
2696,5573,3291, 2697,5578,3292, 2870,5571,3503, 
11, // chain 1269
2874,5579,3508, 2875,5580,3509, 2641,5581,3236, 
35412,5582,3239, 35644,5583,3510, 2647,5584,3242, 35645,5585,3511, 2648,5586,3512, 35646,5587,3513, 2650,5588,3514, 35647,5589,3515, 2639,5590,3516, 35648,5591,3517, 
3, // chain 1270
2641,5581,3236, 2640,5592,3235, 2874,5579,3508, 
35648,5593,3517, 35407,5594,3516, 
5, // chain 1271
2874,5595,3508, 2880,5596,3518, 2875,5597,3509, 
35647,5598,3519, 2878,5599,3520, 2877,5600,3521, 2876,5601,3510, 
10, // chain 1272
2881,5602,3522, 2882,5603,3523, 2717,5604,3524, 
35487,5605,3525, 35651,5606,3526, 2884,5607,3527, 2721,5608,3316, 35653,5609,3528, 2713,5610,3308, 35654,5611,3529, 2714,5612,3530, 35655,5613,3531, 
3, // chain 1273
2717,5604,3524, 2715,5614,3532, 2881,5602,3522, 
35655,5615,3531, 35482,5616,3530, 
5, // chain 1274
2882,5617,3533, 2881,5618,3522, 2887,5619,3531, 
2883,5620,3534, 35652,5621,3535, 35653,5622,3536, 35654,5623,3529, 
8, // chain 1275
2888,5624,3537, 2889,5625,3538, 2890,5626,3539, 
2891,5627,3540, 35660,5628,3541, 35661,5629,3542, 35657,5625,3538, 2894,5630,3543, 35663,5631,3544, 35656,5624,3537, 
3, // chain 1276
2888,5624,3537, 2891,5627,3540, 2896,5632,3545, 
35665,5633,3546, 35660,5628,3541, 
4, // chain 1277
2898,5634,3547, 2888,5624,3537, 2896,5632,3545, 
2899,5635,3548, 35668,5636,3549, 35665,5633,3546, 
5, // chain 1278
2901,5637,3550, 2899,5635,3548, 2902,5638,3551, 
2903,5639,3552, 35672,5640,3553, 35668,5636,3549, 35667,5635,3548, 
4, // chain 1279
2905,5641,3554, 2901,5637,3550, 2903,5639,3552, 
2906,5642,3555, 35675,5643,3556, 35672,5640,3553, 
3, // chain 1280
2905,5644,3554, 2906,5645,3555, 2908,5646,3557, 
35677,5647,3558, 35675,5648,3556, 
5, // chain 1281
2910,5649,3559, 2908,5646,3557, 2911,5650,3560, 
2912,5651,3561, 35681,5652,3562, 35677,5647,3558, 35676,5646,3557, 
3, // chain 1282
2910,5649,3559, 2912,5651,3561, 2914,5653,3563, 
35683,5654,3564, 35681,5652,3562, 
3, // chain 1283
2894,5630,3543, 2910,5649,3559, 2914,5653,3563, 
2893,5629,3542, 35683,5654,3564, 
9, // chain 1284
2894,5655,3543, 2895,5656,3544, 2916,5657,3565, 
35685,5658,3566, 35686,5659,3567, 35656,5660,3537, 2898,5661,3547, 2919,5662,3568, 35688,5663,3569, 2921,5664,3570, 35669,5665,3550, 
18, // chain 1285
2901,5666,3550, 2905,5667,3554, 2922,5668,3571, 
35691,5669,3572, 35692,5670,3573, 2925,5671,3574, 35678,5672,3559, 2926,5673,3575, 35695,5674,3576, 35662,5655,3543, 2916,5657,3565, 2928,5675,3577, 35697,5676,3578, 35685,5658,3566, 2918,5659,3567, 2930,5677,3579, 35687,5662,3568, 2931,5678,3580, 35689,5664,3570, 
2932,5679,3581, 
10, // chain 1286
2921,5680,3570, 2901,5666,3550, 2932,5681,3581, 
35690,5668,3571, 2933,5682,3582, 35691,5669,3572, 2934,5683,3583, 35693,5671,3574, 2926,5673,3575, 2935,5684,3584, 35695,5674,3576, 2928,5675,3577, 
2, // chain 1287
2898,5634,3547, 2899,5635,3548, 2920,5685,3569, 
35669,5637,3550, 
2, // chain 1288
2905,5644,3554, 2908,5646,3557, 2924,5686,3573, 
35678,5649,3559, 
8, // chain 1289
2936,5687,3585, 2937,5688,3586, 2938,5689,3587, 
2939,5690,3588, 35708,5691,3589, 35709,5692,3590, 35705,5688,3586, 2942,5693,3591, 35711,5694,3592, 35704,5687,3585, 
3, // chain 1290
2936,5687,3585, 2939,5690,3588, 2944,5695,3593, 
35713,5696,3594, 35708,5691,3589, 
3, // chain 1291
2946,5697,3595, 2936,5687,3585, 2944,5695,3593, 
2947,5698,3596, 35713,5696,3594, 
8, // chain 1292
2948,5699,3597, 2949,5700,3598, 2950,5701,3599, 
2951,5702,3600, 35720,5703,3601, 35715,5698,3596, 35717,5700,3598, 2946,5697,3595, 35721,5704,3602, 35716,5699,3597, 
3, // chain 1293
2948,5699,3597, 2951,5702,3600, 2954,5705,3603, 
35723,5706,3604, 35720,5703,3601, 
1, // chain 1294
2954,5705,3603, 2956,5707,3605, 2948,5699,3597, 
8, // chain 1295
2957,5708,3606, 2958,5709,3607, 2959,5710,3608, 
2960,5711,3609, 35729,5712,3610, 35730,5713,3611, 35726,5709,3607, 2956,5714,3605, 35731,5715,3612, 35725,5708,3606, 
3, // chain 1296
2957,5708,3606, 2960,5711,3609, 2964,5716,3613, 
35733,5717,3614, 35729,5712,3610, 
3, // chain 1297
2942,5693,3591, 2957,5708,3606, 2964,5716,3613, 
2941,5692,3590, 35733,5717,3614, 
2, // chain 1298
2956,5714,3605, 2954,5718,3603, 2962,5713,3611, 
35723,5719,3604, 
6, // chain 1299
2966,5720,3615, 2942,5721,3591, 2967,5722,3616, 
2968,5723,3617, 35737,5724,3618, 35738,5725,3619, 35711,5726,3592, 35710,5721,3591, 
7, // chain 1300
2970,5725,3619, 2943,5726,3592, 2971,5727,3620, 
2972,5728,3621, 35741,5729,3622, 35742,5730,3623, 35714,5731,3595, 35704,5732,3585, 35711,5726,3592, 
3, // chain 1301
2974,5730,3623, 2946,5731,3595, 2975,5733,3624, 
2973,5729,3622, 35744,5734,3625, 
1, // chain 1302
2946,5731,3595, 2953,5735,3602, 2975,5733,3624, 
24, // chain 1303
2975,5736,3624, 2953,5737,3602, 2977,5738,3626, 
2976,5739,3625, 35746,5740,3627, 35747,5741,3628, 35721,5737,3602, 2948,5742,3597, 2956,5743,3605, 2980,5744,3629, 35749,5745,3630, 35731,5746,3612, 2982,5747,3631, 35751,5748,3632, 35725,5749,3606, 2942,5721,3591, 2966,5720,3615, 2968,5723,3617, 2984,5750,3633, 
2982,5747,3631, 35753,5751,3634, 2981,5745,3630, 35754,5752,3635, 2980,5744,3629, 35747,5741,3628, 35746,5740,3627, 
1, // chain 1304
2972,5728,3621, 2969,5724,3618, 2970,5725,3619, 
14, // chain 1305
2987,5753,3636, 2988,5754,3637, 2989,5755,3638, 
2990,5756,3639, 2991,5757,3640, 2992,5758,3641, 35761,5759,3642, 35762,5760,3643, 2995,5761,3644, 35764,5762,3645, 35765,5763,3646, 35766,5764,3647, 2999,5765,3648, 3000,5766,3649, 35769,5767,3650, 3002,5768,3651, 
13, // chain 1306
2989,5755,3638, 2988,5754,3637, 3003,5769,3652, 
35772,5770,3653, 35773,5771,3654, 35755,5753,3636, 2992,5758,3641, 3006,5772,3655, 35761,5759,3642, 3007,5773,3656, 35763,5761,3644, 3008,5774,3657, 35764,5762,3645, 3000,5766,3649, 35765,5763,3646, 
4, // chain 1307
3009,5775,3658, 2989,5755,3638, 3003,5769,3652, 
3010,5776,3659, 35779,5777,3660, 35772,5770,3653, 
6, // chain 1308
3012,5778,3661, 3013,5779,3662, 3014,5780,3663, 
3015,5781,3664, 3009,5775,3658, 3010,5776,3659, 3016,5782,3665, 35779,5777,3660, 
4, // chain 1309
3014,5780,3663, 3013,5779,3662, 3001,5783,3650, 
35770,5784,3651, 35784,5782,3665, 35780,5778,3661, 
1, // chain 1310
3001,5783,3650, 2999,5785,3648, 3014,5780,3663, 
6, // chain 1311
3017,5786,3666, 2991,5787,3640, 3018,5788,3667, 
3019,5789,3668, 35788,5790,3669, 35789,5791,3670, 35758,5792,3639, 35759,5787,3640, 
7, // chain 1312
3021,5791,3670, 2990,5792,3639, 3022,5793,3671, 
3023,5794,3672, 35792,5795,3673, 35793,5796,3674, 35777,5797,3658, 35757,5798,3638, 35758,5792,3639, 
3, // chain 1313
3025,5796,3674, 3009,5797,3658, 3026,5799,3675, 
3024,5795,3673, 35795,5800,3676, 
1, // chain 1314
3009,5797,3658, 3015,5801,3664, 3026,5799,3675, 
24, // chain 1315
3026,5802,3675, 3015,5803,3664, 3028,5804,3677, 
3027,5805,3676, 35797,5806,3678, 35798,5807,3679, 35783,5803,3664, 3014,5808,3663, 2999,5809,3648, 3031,5810,3680, 35800,5811,3681, 35766,5812,3647, 3033,5813,3682, 35802,5814,3683, 35762,5815,3643, 2991,5787,3640, 3017,5786,3666, 3019,5789,3668, 3035,5816,3684, 
3033,5813,3682, 35804,5817,3685, 3032,5811,3681, 35805,5818,3686, 3031,5810,3680, 35798,5807,3679, 35797,5806,3678, 
1, // chain 1316
3023,5794,3672, 3020,5790,3669, 3021,5791,3670, 
5, // chain 1317
2781,5819,3401, 2560,5820,3155, 3038,5821,3687, 
35807,5822,3688, 35329,5823,3156, 3040,5824,3689, 35330,5825,3157, 
12, // chain 1318
3038,5821,3687, 3041,5826,3690, 2781,5819,3401, 
35546,5827,3398, 35810,5828,3691, 2779,5829,3399, 35811,5830,3692, 2615,5831,3210, 35812,5832,3693, 2614,5833,3209, 35813,5834,3694, 2563,5835,3158, 35330,5836,3157, 35808,5824,3689, 
6, // chain 1319
3041,5837,3690, 3038,5821,3695, 3042,5838,3691, 
35807,5822,3696, 3040,5824,3697, 3045,5834,3698, 3044,5832,3699, 3043,5830,3692, 
14, // chain 1320
3046,5839,3700, 3047,5840,3701, 3048,5841,3702, 
35817,5842,3703, 3050,5843,3704, 35819,5844,3705, 35820,5845,3706, 35821,5846,3707, 35822,5847,3708, 3055,5848,3709, 35824,5849,3710, 35814,5839,3700, 3057,5850,3711, 35826,5851,3712, 35827,5852,3713, 35816,5841,3702, 
13, // chain 1321
3051,5844,3705, 3052,5845,3706, 3060,5853,3714, 
3061,5854,3715, 35830,5855,3716, 3063,5856,3717, 35832,5857,3718, 3065,5858,3719, 35834,5859,3720, 3067,5860,3721, 3068,5861,3722, 35837,5862,3723, 3058,5851,3712, 35838,5863,3724, 3057,5850,3711, 
2, // chain 1322
3061,5854,3715, 3063,5856,3717, 3071,5864,3725, 
3072,5865,3726, 
6, // chain 1323
3063,5866,3717, 3065,5858,3719, 3073,5867,3727, 
35842,5868,3728, 35836,5861,3722, 3058,5851,3712, 3075,5869,3729, 35844,5870,3730, 
1, // chain 1324
3073,5867,3727, 3071,5871,3725, 3063,5866,3717, 
6, // chain 1325
3077,5872,3731, 3078,5873,3732, 3059,5874,3713, 
3048,5875,3702, 3079,5876,3733, 35848,5877,3734, 35818,5878,3704, 3081,5879,3735, 
2, // chain 1326
3076,5880,3730, 3058,5851,3712, 3059,5852,3713, 
3078,5881,3732, 
3, // chain 1327
3051,5882,3705, 3061,5883,3715, 3082,5884,3736, 
3081,5885,3735, 3050,5843,3704, 
1, // chain 1328
3061,5883,3715, 3072,5886,3726, 3082,5884,3736, 
10, // chain 1329
3083,5887,3737, 3084,5888,3738, 3085,5889,3739, 
3046,5890,3700, 3054,5891,3708, 3049,5892,3703, 3086,5893,3740, 3084,5888,3738, 35817,5894,3703, 3047,5895,3701, 3085,5889,3739, 35814,5896,3700, 
12, // chain 1330
3087,5897,3741, 3088,5898,3742, 3057,5899,3711, 
35824,5900,3710, 35857,5901,3743, 3055,5902,3709, 35858,5903,3744, 3053,5904,3707, 35859,5905,3745, 3052,5906,3706, 35860,5907,3746, 3060,5908,3714, 35830,5909,3716, 35861,5910,3747, 
11, // chain 1331
3057,5899,3711, 3070,5911,3724, 3087,5897,3741, 
35862,5912,3748, 35837,5913,3723, 3095,5914,3749, 35835,5915,3721, 3096,5916,3750, 35834,5917,3720, 3064,5918,3718, 3097,5919,3751, 35861,5920,3747, 35830,5921,3716, 
2, // chain 1332
3098,5922,3752, 3099,5923,3753, 3100,5924,3754, 
3101,5925,3755, 
2, // chain 1333
3102,5926,3756, 3103,5927,3757, 3104,5928,3758, 
3105,5929,3759, 
2, // chain 1334
3102,5930,3756, 3105,5931,3759, 3106,5932,3760, 
3107,5933,3761, 
2, // chain 1335
3102,5934,3756, 3107,5935,3761, 3108,5936,3762, 
3103,5937,3757, 
2, // chain 1336
3109,5938,3763, 3110,5939,3764, 3111,5940,3765, 
3112,5941,3766, 
2, // chain 1337
3109,5942,3763, 3112,5943,3766, 3113,5944,3767, 
3114,5945,3768, 
2, // chain 1338
3101,5946,3755, 3115,5947,3769, 3116,5948,3770, 
3098,5949,3752, 
2, // chain 1339
3101,5950,3755, 3100,5951,3754, 3117,5952,3771, 
3115,5953,3769, 
2, // chain 1340
3109,5954,3763, 3114,5955,3768, 3118,5956,3772, 
3110,5957,3764, 
2, // chain 1341
3103,5958,3757, 3108,5959,3762, 3119,5960,3773, 
3104,5961,3758, 
2, // chain 1342
3114,5962,3768, 3113,5963,3767, 3120,5964,3774, 
3118,5965,3772, 
2, // chain 1343
3098,5966,3752, 3116,5967,3770, 3121,5968,3775, 
3099,5969,3753, 
16, // chain 1344
3122,5970,3776, 3123,5971,3777, 3124,5972,3778, 
3125,5973,3779, 35894,5974,3780, 35895,5975,3781, 35896,5976,3782, 35897,5977,3783, 35891,5971,3777, 3130,5978,3784, 35899,5979,3785, 35900,5980,3786, 35890,5970,3776, 3133,5981,3787, 35893,5973,3779, 3134,5982,3788, 35903,5983,3789, 35894,5974,3780, 
4, // chain 1345
3136,5984,3790, 3131,5979,3785, 3132,5980,3786, 
3137,5985,3791, 35901,5981,3787, 3134,5982,3788, 
8, // chain 1346
3138,5986,3792, 3127,5987,3781, 3130,5988,3784, 
3139,5989,3793, 35899,5990,3785, 3140,5991,3794, 3141,5992,3795, 35910,5993,3796, 3135,5994,3789, 35911,5995,3797, 
1, // chain 1347
3127,5987,3781, 3128,5996,3782, 3130,5988,3784, 
4, // chain 1348
3135,5994,3789, 3126,5997,3780, 3127,5987,3781, 
3141,5992,3795, 35906,5986,3792, 3139,5989,3793, 
1, // chain 1349
3130,5978,3784, 3128,5976,3782, 3129,5977,3783, 
5, // chain 1350
3136,5984,3790, 3137,5985,3798, 3140,5998,3794, 
35910,5999,3796, 35902,5982,3788, 3143,6000,3797, 35903,5983,3789, 
1, // chain 1351
3131,5979,3785, 3136,5984,3790, 3140,5998,3794, 
5, // chain 1352
3144,6001,3799, 3145,6002,3800, 3146,6003,3801, 
3147,6004,3802, 35916,6005,3803, 35917,6006,3804, 35913,6002,3800, 
7, // chain 1353
3150,6007,3805, 3151,6008,3806, 3144,6001,3799, 
3147,6004,3802, 3152,6009,3807, 35921,6010,3808, 35916,6005,3803, 3154,6011,3809, 35917,6006,3804, 
7, // chain 1354
3155,6012,3810, 3144,6001,3799, 3151,6008,3806, 
3156,6013,3811, 35925,6014,3812, 35918,6007,3805, 3152,6009,3807, 3158,6015,3813, 35921,6010,3808, 
2, // chain 1355
3157,6014,3812, 3158,6015,3813, 3159,6016,3814, 
3156,6013,3811, 
4, // chain 1356
3145,6017,3800, 3160,6018,3815, 3149,6019,3804, 
35929,6020,3816, 35924,6021,3811, 35923,6022,3810, 
4, // chain 1357
3149,6019,3804, 3161,6020,3816, 3162,6023,3817, 
35931,6024,3818, 35924,6021,3811, 3159,6025,3814, 
4, // chain 1358
3149,6019,3804, 3162,6023,3817, 3154,6026,3809, 
35921,6027,3808, 35932,6028,3819, 35931,6024,3818, 
3, // chain 1359
3158,6015,3820, 3153,6010,3808, 3164,6029,3819, 
3163,6030,3818, 3159,6016,3814, 
2, // chain 1360
3145,6002,3800, 3144,6001,3799, 3160,6031,3815, 
35923,6012,3810, 
12, // chain 1361
3165,6032,3821, 3166,6033,3822, 3167,6034,3823, 
3168,6035,3824, 35937,6036,3825, 35938,6037,3826, 35934,6033,3822, 3171,6038,3827, 35940,6039,3828, 35941,6040,3829, 35933,6032,3821, 3174,6041,3830, 35943,6042,3831, 35936,6035,3824, 
8, // chain 1362
3176,6043,3832, 3170,6037,3826, 3171,6038,3827, 
3177,6044,3833, 35946,6045,3834, 35947,6046,3835, 35940,6039,3828, 3180,6047,3836, 35941,6040,3829, 3174,6041,3830, 
5, // chain 1363
3175,6048,3831, 3168,6049,3824, 3181,6050,3837, 
3182,6051,3838, 35951,6052,3839, 35937,6053,3825, 35936,6049,3824, 
10, // chain 1364
3169,6053,3825, 3176,6054,3832, 3183,6052,3839, 
35945,6055,3833, 3184,6056,3840, 35953,6057,3841, 3186,6058,3842, 3183,6052,3839, 35950,6051,3838, 35955,6059,3843, 3188,6060,3844, 3175,6048,3831, 
7, // chain 1365
3188,6061,3844, 3187,6062,3843, 3174,6041,3830, 
35948,6047,3845, 35954,6063,3842, 3179,6046,3835, 35953,6064,3841, 3178,6045,3834, 35945,6044,3833, 
1, // chain 1366
3176,6043,3832, 3169,6036,3825, 3170,6037,3826, 
1, // chain 1367
3175,6042,3831, 3188,6061,3844, 3174,6041,3830, 
11, // chain 1368
3189,6065,3846, 3190,6066,3847, 3191,6067,3848, 
3192,6068,3849, 35961,6069,3850, 35958,6066,3847, 3194,6070,3851, 35963,6071,3852, 35964,6072,3853, 35957,6065,3846, 3197,6073,3854, 35966,6074,3855, 35960,6068,3849, 
13, // chain 1369
3199,6075,3856, 3193,6069,3850, 3194,6070,3851, 
3200,6076,3857, 35969,6077,3858, 35963,6071,3852, 3202,6078,3859, 35971,6079,3860, 35972,6080,3861, 35964,6072,3853, 3197,6073,3854, 3205,6081,3862, 3203,6079,3863, 35974,6082,3864, 3202,6078,3859, 
7, // chain 1370
3198,6083,3855, 3192,6084,3849, 3207,6085,3865, 
3208,6086,3866, 35977,6087,3867, 35968,6088,3857, 35978,6089,3868, 35979,6090,3869, 35960,6084,3849, 
6, // chain 1371
3205,6091,3862, 3197,6092,3854, 3198,6083,3855, 
3208,6086,3866, 3206,6093,3864, 35977,6087,3867, 3202,6094,3859, 35968,6088,3857, 
4, // chain 1372
3200,6076,3857, 3210,6095,3868, 3199,6075,3856, 
35979,6096,3869, 3193,6069,3850, 35960,6068,3849, 
1, // chain 1373
3202,6078,3859, 3200,6076,3857, 3201,6077,3858, 
11, // chain 1374
3212,6097,3870, 3213,6098,3871, 3214,6099,3872, 
3215,6100,3873, 35984,6101,3874, 35981,6098,3871, 3217,6102,3875, 35986,6103,3876, 35987,6104,3877, 35988,6105,3878, 35980,6097,3870, 3221,6106,3879, 35983,6100,3873, 
9, // chain 1375
3216,6101,3874, 3217,6102,3875, 3222,6107,3880, 
35986,6103,3876, 3223,6108,3881, 35992,6109,3882, 35987,6104,3877, 3225,6110,3883, 35988,6105,3878, 3226,6111,3884, 35989,6106,3879, 
3, // chain 1376
3227,6112,3885, 3216,6101,3874, 3222,6107,3880, 
3228,6113,3886, 35991,6108,3881, 
6, // chain 1377
3221,6114,3879, 3215,6115,3873, 3229,6116,3887, 
3230,6117,3888, 35999,6118,3889, 35996,6119,3886, 36000,6120,3890, 35983,6115,3873, 
1, // chain 1378
3232,6120,3890, 3227,6121,3885, 3228,6119,3886, 
6, // chain 1379
3226,6122,3884, 3221,6114,3879, 3230,6117,3888, 
3225,6123,3883, 35999,6118,3889, 3224,6124,3882, 35991,6125,3881, 35996,6119,3886, 
2, // chain 1380
3232,6126,3890, 3215,6100,3873, 3216,6101,3874, 
3227,6112,3885, 
2, // chain 1381
3233,6127,3891, 3234,6128,3892, 3235,6129,3893, 
36004,6130,3894, 
2, // chain 1382
3237,6131,3895, 3233,6127,3891, 3238,6132,3896, 
36007,6133,3897, 
5, // chain 1383
3237,6131,3898, 3240,6134,3899, 3241,6135,3900, 
3242,6136,3901, 36011,6137,3902, 36012,6138,3903, 36013,6139,3904, 
2, // chain 1384
3240,6140,3899, 3246,6141,3905, 3241,6142,3900, 
36015,6143,3906, 
8, // chain 1385
3247,6143,3907, 3248,6144,3908, 3249,6145,3909, 
36018,6146,3910, 3251,6147,3911, 36020,6148,3912, 36021,6149,3913, 36022,6150,3914, 36023,6151,3915, 36024,6152,3916, 
10, // chain 1386
3257,6153,3917, 3258,6154,3918, 3259,6155,3919, 
3260,6156,3920, 36029,6157,3921, 36030,6158,3922, 36031,6159,3923, 36026,6154,3918, 3264,6160,3924, 3265,6161,3925, 36034,6162,3926, 36035,6163,3927, 
15, // chain 1387
3268,6164,3928, 3260,6156,3920, 3261,6157,3921, 
3269,6165,3929, 36038,6166,3930, 36039,6167,3931, 36040,6168,3932, 36030,6158,3922, 3273,6169,3933, 36031,6159,3923, 3265,6161,3925, 3274,6170,3934, 36043,6171,3935, 36034,6162,3926, 3276,6172,3936, 3277,6173,3937, 36046,6174,3938, 
20, // chain 1388
3279,6175,3939, 3268,6164,3928, 3269,6165,3929, 
3280,6176,3940, 36049,6177,3941, 36038,6166,3930, 3271,6167,3931, 3282,6178,3942, 36051,6179,3943, 36040,6168,3932, 3284,6180,3944, 36041,6169,3933, 3285,6181,3945, 36042,6170,3934, 3286,6182,3946, 36043,6171,3935, 3287,6183,3947, 36056,6184,3948, 36045,6173,3937, 
3289,6185,3949, 3290,6186,3950, 36059,6187,3951, 
18, // chain 1389
3292,6188,3952, 3279,6175,3939, 3280,6176,3940, 
3293,6189,3953, 36062,6190,3954, 36049,6177,3941, 3282,6178,3942, 3295,6191,3955, 36064,6192,3956, 36051,6179,3943, 3297,6193,3957, 36052,6180,3944, 3285,6181,3945, 3298,6194,3958, 36054,6182,3946, 3287,6183,3947, 3299,6195,3959, 36068,6196,3960, 36058,6186,3950, 
36056,6184,3948, 
8, // chain 1390
3301,6197,3961, 3292,6188,3952, 3293,6189,3953, 
3302,6198,3962, 36071,6199,3963, 36062,6190,3954, 3304,6200,3964, 36063,6191,3955, 3305,6201,3965, 3299,6202,3959, 
4, // chain 1391
3301,6197,3961, 3302,6198,3962, 3290,6203,3950, 
36068,6204,3960, 36071,6199,3963, 3304,6200,3964, 
1, // chain 1392
3300,6196,3960, 3304,6205,3964, 3299,6195,3959, 
4, // chain 1393
3299,6195,3959, 3305,6206,3965, 3298,6194,3958, 
36065,6193,3957, 36063,6207,3955, 3296,6192,3956, 
2, // chain 1394
3301,6197,3961, 3290,6203,3950, 3291,6208,3951, 
3306,6209,3966, 
9, // chain 1395
3307,6210,3967, 3308,6211,3968, 3234,6128,3892, 
36077,6212,3969, 3310,6213,3970, 3311,6214,3971, 3255,6151,3915, 36080,6215,3972, 3313,6216,3973, 3314,6217,3974, 3254,6150,3914, 
12, // chain 1396
3234,6128,3892, 3233,6127,3975, 3307,6210,3967, 
36083,6218,3976, 36084,6219,3977, 36085,6220,3978, 36086,6221,3979, 36087,6222,3980, 36088,6223,3981, 36005,6131,3898, 3321,6224,3982, 36090,6225,3983, 36091,6226,3984, 36010,6136,3901, 
14, // chain 1397
3251,6147,3911, 3324,6227,3985, 3249,6145,3909, 
36093,6228,3986, 3326,6229,3987, 3327,6230,3988, 3328,6231,3989, 3247,6143,3907, 36097,6232,3990, 3330,6233,3991, 3331,6234,3992, 3332,6235,3993, 3241,6142,3900, 36101,6236,3994, 3334,6237,3995, 3245,6238,3904, 
2, // chain 1398
3268,6164,3928, 3279,6175,3939, 3335,6239,3996, 
3336,6240,3997, 
24, // chain 1399
3337,6241,3998, 3235,6242,3893, 3338,6243,3999, 
36026,6244,3918, 36004,6245,3894, 3264,6246,3924, 36002,6247,3892, 3339,6248,4000, 3267,6249,3927, 36023,6250,3915, 3266,6251,3926, 36024,6252,3916, 3276,6253,3936, 36046,6254,3938, 36018,6255,3910, 3340,6256,4001, 3277,6257,3937, 36109,6258,4002, 3289,6259,3949, 
36016,6260,4003, 3291,6261,3951, 36110,6262,4004, 3306,6263,3966, 36015,6264,3906, 3301,6265,3961, 36014,6266,3905, 
17, // chain 1400
3338,6243,3999, 3257,6267,3917, 3337,6241,3998, 
36001,6268,3891, 36028,6269,3920, 3239,6270,3897, 36036,6271,3928, 3238,6272,3896, 36104,6273,3997, 3237,6274,3895, 36103,6275,3996, 3343,6276,4005, 36047,6277,3939, 3240,6278,4006, 36112,6279,4007, 3345,6280,4008, 36060,6281,3952, 3246,6282,3905, 36069,6283,3961, 
1, // chain 1401
3234,6128,3892, 3255,6151,3915, 3339,6284,4000, 
2, // chain 1402
3250,6146,3910, 3248,6144,4003, 3341,6285,4002, 
3340,6286,4001, 
1, // chain 1403
3248,6144,4003, 3247,6143,3906, 3342,6287,4004, 
1, // chain 1404
3246,6141,3905, 3240,6140,4006, 3345,6288,4008, 
1, // chain 1405
3240,6134,4006, 3237,6131,3895, 3343,6289,4005, 
1, // chain 1406
3235,6129,3893, 3337,6290,3998, 3233,6127,3891, 
1, // chain 1407
3258,6154,3918, 3257,6153,3917, 3338,6291,3999, 
1, // chain 1408
3279,6175,3939, 3292,6188,3952, 3344,6292,4007, 
36, // chain 1409
3308,6293,4009, 3307,6294,4009, 3346,6295,4010, 
36083,6296,4009, 3316,6297,4009, 3317,6298,4009, 3318,6299,4010, 3319,6300,4010, 3320,6301,4010, 3321,6302,4011, 3322,6303,4010, 3323,6304,4010, 3242,6305,4010, 3243,6306,4011, 3244,6307,4010, 3245,6308,4010, 3334,6309,4012, 3333,6310,4010, 3332,6311,4010, 
3331,6312,4010, 3330,6313,4009, 3329,6314,4009, 3328,6315,4009, 3327,6316,4011, 3326,6317,4011, 3325,6318,4013, 3324,6319,4009, 3251,6320,4011, 3252,6321,4011, 3253,6322,4010, 3254,6323,4009, 3314,6324,4009, 3313,6325,4010, 3312,6326,4010, 3311,6327,4009, 
3310,6328,4010, 3309,6329,4010, 3308,6293,4009, 
67, // chain 1410
3347,6330,4014, 3348,6331,4015, 3349,6332,4016, 
3350,6333,4017, 36119,6334,4018, 36120,6335,4019, 36121,6336,4020, 36122,6337,4021, 36116,6331,4015, 3355,6338,4022, 36124,6339,4023, 36115,6330,4014, 3357,6340,4024, 36118,6333,4017, 3358,6341,4025, 36127,6342,4026, 36119,6334,4018, 3360,6343,4027, 36120,6335,4019, 
3361,6344,4028, 36130,6345,4029, 36121,6336,4020, 3363,6346,4030, 36132,6347,4031, 36122,6337,4021, 3365,6348,4032, 36123,6338,4022, 3366,6349,4033, 36135,6350,4034, 36136,6351,4035, 36124,6339,4023, 3369,6352,4036, 36125,6340,4024, 3370,6353,4037, 36126,6341,4025, 
3371,6354,4038, 36127,6342,4026, 3372,6355,4039, 36128,6343,4027, 3373,6356,4040, 36129,6344,4028, 3374,6357,4041, 36143,6358,4042, 36130,6345,4029, 3376,6359,4043, 36145,6360,4044, 36131,6346,4030, 3378,6361,4045, 36147,6362,4046, 36132,6347,4031, 3365,6348,4032, 
3380,6363,4047, 36134,6349,4033, 3381,6364,4048, 36150,6365,4049, 36135,6350,4034, 3383,6366,4050, 36136,6351,4035, 3384,6367,4051, 36137,6352,4036, 3385,6368,4052, 36138,6353,4037, 3386,6369,4053, 36155,6370,4054, 36139,6354,4038, 3388,6371,4055, 36157,6372,4056, 
36141,6356,4040, 36140,6355,4039, 
5, // chain 1411
3379,6362,4046, 3380,6363,4047, 3390,6373,4057, 
3378,6361,4045, 36159,6374,4058, 3377,6360,4044, 36144,6359,4043, 
1, // chain 1412
3373,6356,4040, 3374,6357,4041, 3389,6372,4056, 
6, // chain 1413
3385,6368,4052, 3386,6369,4053, 3392,6375,4059, 
36161,6376,4060, 36155,6370,4054, 3394,6377,4061, 36156,6371,4055, 3389,6372,4056, 
6, // chain 1414
3384,6367,4051, 3385,6368,4052, 3392,6375,4059, 
3383,6366,4050, 36163,6378,4062, 3382,6365,4049, 36164,6379,4063, 3381,6364,4048, 
1, // chain 1415
3380,6363,4047, 3381,6364,4048, 3390,6373,4057, 
20, // chain 1416
3397,6380,4064, 3398,6381,4065, 3399,6382,4066, 
36168,6383,4067, 36169,6384,4068, 3402,6385,4069, 36171,6386,4070, 3404,6387,4071, 36173,6388,4072, 3406,6389,4073, 36175,6390,4074, 3408,6391,4075, 36165,6380,4064, 3399,6382,4066, 3409,6392,4076, 36168,6383,4067, 3410,6393,4077, 36170,6385,4069, 3404,6387,4071, 
3406,6389,4073, 3408,6391,4075, 3409,6392,4076, 
19, // chain 1417
3411,6394,4078, 3412,6395,4079, 3413,6396,4080, 
3414,6397,4081, 36183,6398,4082, 36184,6399,4083, 36185,6400,4084, 36186,6401,4085, 36180,6395,4079, 3419,6402,4086, 3417,6400,4084, 36188,6403,4087, 3421,6404,4088, 3416,6399,4083, 36190,6405,4089, 36191,6406,4090, 3424,6407,4091, 3414,6397,4081, 36193,6408,4092, 
3411,6394,4078, 36180,6395,4079, 
2, // chain 1418
3416,6399,4083, 3422,6405,4089, 3415,6398,4082, 
36182,6397,4081, 
36, // chain 1419
3426,6409,4093, 3427,6410,4094, 3428,6411,4095, 
3429,6412,4096, 36198,6413,4097, 36195,6410,4094, 3431,6414,4098, 36200,6415,4099, 36201,6416,4100, 36202,6417,4101, 36203,6418,4102, 36204,6419,4103, 36205,6420,4104, 36206,6421,4105, 36194,6409,4093, 3439,6422,4106, 36208,6423,4107, 36209,6424,4108, 36210,6425,4109, 
36211,6426,4110, 36212,6427,4111, 36213,6428,4112, 36197,6412,4096, 3446,6429,4113, 36215,6430,4114, 36216,6431,4115, 36217,6432,4116, 36218,6433,4117, 36219,6434,4118, 36198,6413,4097, 3452,6435,4119, 36199,6414,4098, 3453,6436,4120, 36222,6437,4121, 36223,6438,4122, 
36224,6439,4123, 36225,6440,4124, 36200,6415,4099, 
14, // chain 1420
3452,6435,4119, 3453,6436,4120, 3458,6441,4125, 
3459,6442,4126, 3460,6443,4127, 3461,6444,4128, 3462,6445,4129, 3463,6446,4130, 3464,6447,4131, 3465,6448,4132, 3451,6434,4118, 36234,6449,4133, 3467,6450,4134, 3468,6451,4135, 3469,6452,4136, 3450,6433,4117, 
2, // chain 1421
3470,6453,4137, 3471,6454,4138, 3472,6455,4139, 
36241,6456,4140, 
2, // chain 1422
3474,6457,4141, 3470,6453,4137, 3475,6458,4142, 
36244,6459,4143, 
2, // chain 1423
3477,6460,4144, 3478,6461,4145, 3479,6462,4146, 
36248,6463,4147, 
2, // chain 1424
3477,6460,4148, 3481,6464,4149, 3482,6465,4150, 
36251,6466,4151, 
10, // chain 1425
3484,6467,4152, 3485,6468,4153, 3486,6469,4154, 
3487,6470,4155, 36256,6471,4156, 36257,6472,4157, 36258,6473,4158, 36253,6468,4153, 3491,6474,4159, 3492,6475,4160, 36261,6476,4161, 3494,6477,4162, 
15, // chain 1426
3495,6478,4163, 3484,6467,4152, 3496,6479,4164, 
36255,6470,4155, 3497,6480,4165, 36256,6471,4156, 3498,6481,4166, 36267,6482,4167, 36268,6483,4168, 36257,6472,4157, 3501,6484,4169, 36270,6485,4170, 36258,6473,4158, 3492,6475,4160, 3503,6486,4171, 36272,6487,4172, 36273,6488,4173, 
18, // chain 1427
3506,6489,4174, 3495,6478,4163, 3496,6479,4164, 
3507,6490,4175, 36276,6491,4176, 36277,6492,4177, 36265,6480,4165, 3498,6481,4166, 3510,6493,4178, 36279,6494,4179, 36267,6482,4167, 3512,6495,4180, 36281,6496,4181, 36282,6497,4182, 36268,6483,4168, 3501,6484,4169, 3515,6498,4183, 36284,6499,4184, 36271,6486,4171, 
36270,6485,4170, 
3, // chain 1428
3517,6500,4185, 3518,6501,4186, 3519,6502,4187, 
3507,6490,4175, 36288,6503,4188, 
7, // chain 1429
3521,6504,4189, 3519,6502,4187, 3518,6501,4186, 
3522,6505,4190, 36291,6506,4191, 36292,6507,4192, 36285,6500,4185, 3508,6491,4176, 36275,6490,4175, 
10, // chain 1430
3525,6508,4193, 3521,6504,4189, 3522,6505,4190, 
3526,6509,4194, 36295,6510,4195, 36296,6511,4196, 36297,6512,4197, 36291,6506,4191, 3510,6493,4178, 36292,6507,4192, 3509,6492,4177, 36276,6491,4176, 
2, // chain 1431
3503,6486,4171, 3504,6487,4172, 3530,6513,4198, 
36299,6514,4199, 
4, // chain 1432
3532,6515,4200, 3503,6486,4171, 3530,6513,4198, 
3527,6516,4195, 36301,6517,4201, 36302,6518,4202, 
6, // chain 1433
3532,6515,4200, 3527,6516,4195, 3535,6519,4203, 
3516,6499,4184, 36283,6498,4183, 36304,6520,4204, 36295,6516,4195, 3528,6521,4196, 
1, // chain 1434
3516,6499,4184, 3503,6486,4171, 3532,6515,4200, 
4, // chain 1435
3536,6522,4204, 3528,6511,4196, 3529,6512,4197, 
3537,6523,4205, 36279,6494,4179, 36278,6493,4178, 
5, // chain 1436
3515,6498,4183, 3536,6520,4204, 3538,6524,4206, 
3513,6496,4181, 36280,6525,4180, 36305,6526,4205, 36304,6520,4204, 
1, // chain 1437
3515,6498,4183, 3513,6496,4181, 3514,6497,4182, 
1, // chain 1438
3512,6495,4180, 3537,6523,4205, 3511,6494,4179, 
2, // chain 1439
3526,6527,4194, 3527,6516,4195, 3533,6517,4201, 
3539,6528,4207, 
28, // chain 1440
3439,6529,4208, 3440,6530,4209, 3540,6531,4210, 
36209,6532,4211, 3541,6533,4212, 36210,6534,4213, 3443,6535,4214, 3444,6536,4215, 3482,6465,4150, 36213,6537,4216, 3446,6538,4217, 3447,6539,4218, 3448,6540,4219, 3449,6541,4220, 3450,6542,4221, 3477,6460,4148, 36237,6543,4222, 3468,6544,4223, 3467,6545,4224, 
3466,6546,4225, 3478,6461,4145, 36233,6547,4226, 3464,6548,4227, 3463,6549,4228, 3462,6550,4229, 3461,6551,4230, 3460,6552,4231, 3474,6553,4141, 36227,6554,4232, 3458,6555,4233, 
16, // chain 1441
3458,6556,4233, 3453,6557,4234, 3474,6457,4141, 
36222,6558,4235, 3470,6453,4236, 36223,6559,4237, 3456,6560,4238, 3457,6561,4239, 3432,6562,4240, 3433,6563,4241, 3471,6454,4138, 36202,6564,4242, 3435,6565,4243, 3436,6566,4244, 3437,6567,4245, 3540,6531,4210, 36206,6568,4246, 3439,6529,4208, 
26, // chain 1442
3542,6569,4247, 3543,6570,4248, 3485,6571,4153, 
36259,6572,4159, 36261,6573,4161, 36308,6574,4210, 3541,6575,4212, 3494,6576,4162, 36312,6577,4249, 3492,6578,4160, 36273,6579,4173, 36250,6580,4150, 3483,6581,4151, 3504,6582,4172, 36299,6583,4199, 36249,6584,4149, 3545,6585,4250, 3530,6586,4198, 36302,6587,4202, 
36245,6588,4144, 3533,6589,4201, 36247,6590,4146, 3539,6591,4207, 36248,6592,4147, 3526,6593,4194, 36246,6594,4145, 3546,6595,4251, 36315,6596,4252, 
21, // chain 1443
3485,6571,4153, 3548,6597,4253, 3542,6569,4247, 
36239,6598,4138, 36252,6599,4152, 3473,6600,4140, 36263,6601,4163, 3506,6602,4174, 3472,6603,4139, 36275,6604,4175, 3470,6605,4137, 36244,6606,4143, 36288,6607,4188, 3475,6608,4142, 36287,6609,4187, 3549,6610,4254, 3550,6611,4255, 36319,6612,4256, 36289,6613,4189, 
3525,6614,4193, 3474,6615,4141, 36315,6616,4252, 36314,6617,4251, 
2, // chain 1444
3471,6454,4138, 3540,6531,4210, 3543,6618,4248, 
3542,6619,4247, 
1, // chain 1445
3541,6533,4212, 3482,6465,4150, 3544,6620,4249, 
1, // chain 1446
3481,6464,4149, 3477,6460,4144, 3545,6621,4250, 
1, // chain 1447
3478,6461,4145, 3474,6553,4141, 3547,6622,4252, 
2, // chain 1448
3474,6457,4141, 3475,6458,4142, 3550,6623,4255, 
3551,6624,4256, 
1, // chain 1449
3485,6468,4153, 3484,6467,4152, 3548,6625,4253, 
1, // chain 1450
3519,6502,4187, 3521,6504,4189, 3549,6626,4254, 
1, // chain 1451
3525,6508,4193, 3526,6509,4194, 3546,6627,4251, 
36, // chain 1452
3440,6628,4257, 3439,6629,4258, 3552,6630,4257, 
36206,6631,4258, 3437,6632,4257, 3436,6633,4259, 3435,6634,4257, 3434,6635,4258, 3433,6636,4258, 3432,6637,4257, 3457,6638,4257, 3456,6639,4258, 3455,6640,4257, 3454,6641,4257, 3453,6642,4258, 3458,6643,4257, 3459,6644,4257, 3460,6645,4257, 3461,6646,4257, 
3462,6647,4257, 3463,6648,4257, 3464,6649,4257, 3465,6650,4257, 3466,6651,4258, 3467,6652,4257, 3468,6653,4257, 3469,6654,4257, 3450,6655,4257, 3449,6656,4257, 3448,6657,4260, 3447,6658,4260, 3446,6659,4257, 3445,6660,4257, 3444,6661,4258, 3443,6662,4257, 
3442,6663,4257, 3441,6664,4257, 3440,6628,4257, 
21, // chain 1453
3553,6665,4261, 3554,6666,4262, 3555,6667,4263, 
3556,6668,4264, 36012,6669,4265, 36011,6670,4266, 36010,6671,4267, 36091,6672,4268, 36325,6673,4269, 36322,6666,4262, 3558,6674,4270, 36327,6675,4271, 36328,6676,4272, 36321,6665,4261, 3561,6677,4273, 36324,6668,4264, 3330,6678,4274, 36099,6679,4275, 36100,6680,4276, 
36101,6681,4277, 36102,6682,4278, 36013,6683,4279, 36012,6669,4265, 
21, // chain 1454
3308,6684,4280, 3307,6685,4281, 3558,6674,4270, 
3309,6686,4282, 36078,6687,4283, 36079,6688,4284, 36327,6675,4271, 3312,6689,4285, 36081,6690,4286, 36082,6691,4287, 36022,6692,4288, 36021,6693,4289, 36328,6676,4272, 3252,6694,4290, 36019,6695,4291, 36092,6696,4292, 36093,6697,4293, 36094,6698,4294, 36095,6699,4295, 
36329,6677,4273, 3328,6700,4296, 36097,6701,4297, 36098,6678,4274, 
10, // chain 1455
3558,6674,4270, 3307,6685,4281, 3315,6702,4298, 
3316,6703,4299, 3317,6704,4300, 3557,6673,4269, 36086,6705,4301, 3319,6706,4302, 3320,6707,4303, 3321,6708,4304, 3322,6709,4305, 3323,6672,4268, 
2, // chain 1456
3562,6710,4306, 3563,6711,4307, 3564,6712,4308, 
36333,6713,4309, 
3, // chain 1457
3564,6712,4308, 3566,6714,4310, 3567,6715,4311, 
36336,6716,4312, 36337,6717,4313, 
8, // chain 1458
3567,6715,4311, 3568,6716,4312, 3570,6718,4314, 
3571,6719,4315, 36340,6720,4316, 36341,6721,4317, 36342,6722,4318, 36343,6723,4319, 36344,6724,4320, 36345,6725,4321, 
12, // chain 1459
3578,6726,4322, 3579,6727,4323, 3580,6728,4324, 
3581,6729,4325, 36350,6730,4326, 36351,6731,4327, 36352,6732,4328, 36353,6733,4329, 36354,6734,4330, 36347,6727,4323, 3587,6735,4331, 3588,6736,4332, 36357,6737,4333, 36358,6738,4334, 
6, // chain 1460
3591,6739,4335, 3582,6730,4326, 3592,6740,4336, 
3593,6741,4337, 36362,6742,4338, 36363,6743,4339, 36351,6731,4327, 36350,6730,4326, 
19, // chain 1461
3596,6744,4340, 3593,6741,4337, 3594,6742,4338, 
3597,6745,4341, 36363,6743,4339, 3598,6746,4342, 36367,6747,4343, 36351,6731,4327, 3584,6732,4328, 3600,6748,4344, 36369,6749,4345, 36353,6733,4329, 3602,6750,4346, 36354,6734,4330, 3588,6736,4332, 3603,6751,4347, 36372,6752,4348, 36373,6753,4349, 36374,6754,4350, 
36357,6737,4333, 3607,6755,4351, 
21, // chain 1462
3608,6756,4352, 3609,6757,4353, 3610,6758,4354, 
3611,6759,4355, 36380,6760,4356, 36381,6761,4357, 36382,6762,4358, 3615,6763,4359, 36384,6764,4360, 3617,6765,4361, 3618,6766,4362, 36387,6767,4363, 3620,6768,4364, 36369,6749,4345, 36368,6748,4344, 36385,6769,4361, 3599,6747,4343, 36366,6746,4342, 36384,6770,4360, 
3614,6771,4358, 3597,6745,4341, 36377,6772,4353, 36378,6773,4354, 
3, // chain 1463
3612,6760,4356, 3605,6753,4349, 3621,6774,4365, 
3611,6759,4355, 36390,6775,4366, 
15, // chain 1464
3605,6753,4349, 3612,6760,4356, 3623,6776,4367, 
3604,6752,4348, 36392,6777,4368, 36393,6778,4369, 36380,6760,4356, 3613,6761,4357, 3626,6779,4370, 36383,6763,4359, 3618,6766,4362, 3624,6777,4368, 36395,6780,4371, 36388,6768,4364, 3603,6751,4347, 36369,6749,4345, 3602,6750,4346, 
1, // chain 1465
3625,6778,4369, 3626,6779,4370, 3624,6777,4368, 
2, // chain 1466
3604,6752,4348, 3624,6777,4368, 3627,6780,4371, 
3603,6751,4347, 
2, // chain 1467
3581,6729,4325, 3582,6730,4326, 3591,6739,4335, 
3628,6781,4372, 
4, // chain 1468
3596,6744,4340, 3597,6745,4341, 3609,6772,4353, 
3629,6782,4373, 36398,6783,4374, 36376,6784,4352, 
1, // chain 1469
3606,6754,4350, 3621,6774,4365, 3605,6753,4349, 
7, // chain 1470
3631,6785,4375, 3632,6786,4376, 3633,6787,4377, 
36402,6788,4378, 3576,6724,4320, 36403,6789,4379, 3636,6790,4380, 3637,6791,4381, 3575,6723,4319, 
15, // chain 1471
3571,6719,4315, 3638,6792,4382, 3567,6715,4311, 
36407,6793,4383, 3640,6794,4384, 3641,6795,4385, 3642,6796,4386, 3643,6797,4387, 3564,6712,4308, 36412,6798,4388, 3645,6799,4389, 3646,6800,4390, 3647,6801,4391, 3562,6710,4306, 36416,6802,4392, 3649,6803,4393, 3650,6804,4394, 
17, // chain 1472
3650,6805,4394, 3651,6806,4395, 3562,6807,4306, 
36420,6808,4396, 36421,6809,4397, 3654,6810,4398, 3655,6811,4399, 3656,6812,4400, 3657,6813,4401, 36426,6814,4402, 3659,6815,4403, 3660,6816,4404, 3661,6817,4405, 36430,6818,4406, 3663,6819,4407, 3664,6820,4408, 3665,6821,4409, 3633,6787,4377, 36399,6785,4375, 
23, // chain 1473
3666,6822,4410, 3633,6823,4377, 3587,6824,4331, 
36358,6825,4334, 36435,6826,4411, 3589,6827,4333, 36344,6828,4320, 3607,6829,4351, 36345,6830,4321, 3606,6831,4350, 36338,6832,4314, 3621,6833,4365, 36436,6834,4412, 3622,6835,4366, 36336,6836,4312, 3611,6837,4355, 36337,6838,4313, 3669,6839,4413, 36334,6840,4310, 
3608,6841,4352, 36332,6842,4308, 3630,6843,4374, 36333,6844,4309, 3629,6845,4373, 36331,6846,4307, 
18, // chain 1474
3587,6824,4331, 3579,6847,4323, 3666,6822,4410, 
36346,6848,4322, 3661,6849,4405, 36438,6850,4414, 36349,6851,4325, 3628,6852,4372, 3657,6853,4401, 36439,6854,4415, 36359,6855,4335, 3652,6856,4396, 36440,6857,4416, 3673,6858,4417, 36361,6859,4337, 3674,6860,4418, 3562,6861,4306, 36364,6862,4340, 3563,6863,4307, 
36397,6864,4373, 
1, // chain 1475
3633,6787,4377, 3576,6724,4320, 3667,6865,4411, 
1, // chain 1476
3570,6718,4314, 3568,6716,4312, 3668,6866,4412, 
1, // chain 1477
3562,6807,4306, 3652,6808,4396, 3673,6867,4417, 
1, // chain 1478
3652,6808,4396, 3657,6813,4401, 3671,6868,4415, 
1, // chain 1479
3657,6813,4401, 3661,6817,4405, 3670,6869,4414, 
1, // chain 1480
3661,6817,4405, 3633,6787,4377, 3666,6870,4410, 
1, // chain 1481
3591,6739,4335, 3593,6741,4337, 3672,6871,4416, 
1, // chain 1482
3593,6741,4337, 3596,6744,4340, 3674,6872,4418, 
1, // chain 1483
3608,6756,4352, 3611,6759,4355, 3669,6873,4413, 
36, // chain 1484
3632,6874,4419, 3631,6875,4419, 3675,6876,4419, 
36433,6877,4419, 3664,6878,4419, 3663,6879,4419, 3662,6880,4419, 3660,6881,4419, 3659,6882,4420, 3658,6883,4419, 3656,6884,4419, 3655,6885,4419, 3654,6886,4420, 3653,6887,4420, 3651,6888,4419, 3650,6889,4419, 3649,6890,4419, 3648,6891,4421, 3647,6892,4422, 
3646,6893,4420, 3645,6894,4423, 3644,6895,4419, 3643,6896,4419, 3642,6897,4424, 3641,6898,4419, 3640,6899,4420, 3639,6900,4419, 3638,6901,4419, 3571,6902,4420, 3572,6903,4420, 3573,6904,4419, 3574,6905,4419, 3575,6906,4419, 3637,6907,4419, 3636,6908,4419, 
3635,6909,4419, 3634,6910,4419, 3632,6874,4419, 
37, // chain 1485
3676,6911,4425, 3677,6912,4426, 3678,6913,4427, 
3679,6914,4428, 36448,6915,4429, 36449,6916,4430, 36445,6912,4426, 3640,6917,4431, 36409,6918,4432, 36410,6919,4433, 36411,6920,4434, 36412,6921,4435, 36413,6922,4436, 36414,6923,4437, 36415,6924,4438, 36444,6911,4425, 3648,6925,4439, 36417,6926,4440, 36418,6927,4441, 
36419,6928,4442, 36421,6929,4443, 36422,6930,4444, 36423,6931,4445, 36447,6914,4428, 3656,6932,4446, 36426,6933,4447, 36427,6934,4448, 36428,6935,4449, 36430,6936,4450, 36431,6937,4451, 36450,6938,4452, 36448,6915,4429, 3683,6939,4453, 36449,6916,4430, 3572,6940,4454, 
36339,6941,4455, 36406,6942,4456, 36407,6943,4457, 36408,6917,4431, 
10, // chain 1486
3632,6944,4458, 3631,6945,4459, 3682,6938,4452, 
3634,6946,4460, 36403,6947,4461, 36404,6948,4462, 36451,6939,4453, 3637,6949,4463, 36343,6950,4464, 36342,6951,4465, 36341,6952,4466, 36340,6940,4454, 
3, // chain 1487
3682,6938,4452, 3631,6945,4459, 3665,6953,4467, 
3664,6954,4468, 3663,6937,4451, 
12, // chain 1488
3684,6955,4469, 3685,6956,4470, 3686,6957,4471, 
3687,6958,4472, 3688,6959,4473, 36457,6960,4474, 3690,6961,4475, 36459,6962,4476, 3692,6963,4477, 36461,6964,4478, 3694,6965,4479, 3695,6966,4480, 36464,6967,4481, 36465,6968,4482, 
2, // chain 1489
3698,6969,4483, 3686,6957,4471, 3685,6956,4470, 
3699,6970,4484, 
4, // chain 1490
3695,6971,4480, 3696,6972,4485, 3700,6973,4486, 
3701,6974,4487, 36470,6975,4488, 3703,6976,4489, 
2, // chain 1491
3704,6977,2128, 3705,6978,2128, 3706,6979,2128, 
3707,6980,2128, 
2, // chain 1492
3708,6981,2131, 3709,6982,2131, 3710,6983,2131, 
3711,6984,2131, 
5, // chain 1493
3712,6985,4490, 3713,6986,4491, 3714,6987,4492, 
3715,6988,4493, 36484,6989,4494, 36470,6990,4495, 3700,6991,4496, 
4, // chain 1494
3717,6992,4497, 3718,6993,4498, 3719,6994,4499, 
3720,6995,4500, 36489,6996,4501, 3722,6997,4502, 
1, // chain 1495
3723,6998,4503, 3717,6992,4497, 3720,6995,4500, 
9, // chain 1496
3720,6999,4500, 3722,7000,4502, 3724,7001,4504, 
36493,7002,4505, 36489,7003,4501, 3726,7004,4506, 36487,7005,4499, 3727,7006,4507, 36486,7007,4498, 3728,7008,4508, 36485,7009,4497, 
5, // chain 1497
3729,7010,4509, 3728,7011,4508, 3717,7012,4497, 
3723,7013,4503, 3730,7014,4510, 36488,6999,4500, 3724,7001,4504, 
17, // chain 1498
3725,7015,1102, 3726,7016,1102, 3689,7017,1102, 
36459,7018,1102, 36461,7019,1102, 36495,7020,1102, 3694,7021,4511, 36496,7022,4512, 3697,7023,4513, 36497,7024,4514, 3712,6985,4490, 36481,6986,4491, 36498,7025,4515, 3698,7026,4516, 36492,7027,4517, 3686,7028,4518, 36493,7015,1102, 3687,7029,1102, 36457,7017,1102, 
6, // chain 1499
3692,7030,4477, 3695,6971,4480, 3690,7031,963, 
36456,7032,963, 36452,7033,963, 36453,7034,4519, 36469,6974,4487, 3699,7035,4520, 
1, // chain 1500
3731,7036,4521, 3714,6987,4492, 3713,6986,4491, 
4, // chain 1501
3731,7036,4522, 3713,6986,4523, 3732,7037,4524, 
3703,7038,4489, 36501,7039,4522, 3701,7040,4487, 
2, // chain 1502
3706,6979,4525, 3705,6978,4526, 3701,7041,4527, 
3733,7042,4528, 
1, // chain 1503
3705,6978,4526, 3699,7043,4529, 3701,7041,4527, 
2, // chain 1504
3698,7044,4483, 3699,7045,4484, 3705,6978,4530, 
3704,6977,2172, 
3, // chain 1505
3698,7046,4531, 3704,6977,4532, 3707,6980,4533, 
3713,7047,4523, 36500,7048,4524, 
2, // chain 1506
3733,7049,2177, 3732,7050,2177, 3707,6980,2177, 
3706,6979,2177, 
2, // chain 1507
3696,7051,4481, 3697,7052,4482, 3709,6982,4534, 
3708,6981,2178, 
3, // chain 1508
3696,7053,4535, 3708,6981,4536, 3711,6984,4537, 
3700,7054,4496, 36484,7055,4494, 
2, // chain 1509
3715,7056,2183, 3716,7057,2183, 3711,6984,2183, 
3710,6983,2183, 
3, // chain 1510
3715,7058,4538, 3710,6983,4539, 3712,7059,4540, 
36477,6982,4541, 3697,7060,4542, 
7, // chain 1511
3734,7061,4543, 3735,7062,4544, 3736,7063,4545, 
3737,7064,4546, 36506,7065,4547, 3739,7066,4548, 3740,7067,4549, 36509,7068,4550, 3742,7069,4551, 
4, // chain 1512
3743,7070,4552, 3742,7071,4551, 3741,7072,4550, 
3744,7073,4553, 3735,7062,4544, 36504,7063,4545, 
11, // chain 1513
3738,7074,4554, 3736,7075,4555, 3745,7076,4556, 
36514,7077,4557, 36512,7078,4558, 3741,7079,4559, 3747,7080,4560, 36507,7081,4561, 3738,7074,4554, 3745,7076,4556, 3748,7082,4562, 36514,7077,4557, 3747,7080,4560, 
7, // chain 1514
3749,7083,4563, 3750,7084,4564, 3751,7085,4565, 
3752,7086,4566, 3753,7087,4567, 36522,7088,4568, 3755,7089,4569, 36524,7090,4570, 3757,7091,4571, 
3, // chain 1515
3757,7092,4571, 3756,7093,4570, 3758,7094,4572, 
3750,7084,4564, 36519,7085,4565, 
5, // chain 1516
3759,7095,4573, 3751,7096,4574, 3760,7097,4575, 
3761,7098,4576, 36530,7099,4577, 36526,7100,4578, 36519,7096,4574, 
5, // chain 1517
3752,7101,4579, 3751,7096,4574, 3759,7095,4573, 
3754,7102,4580, 36524,7103,4581, 36530,7099,4577, 36529,7098,4576, 
1, // chain 1518
3758,7100,4578, 3756,7103,4581, 3762,7099,4577, 
1, // chain 1519
3763,7104,4582, 3764,7105,4583, 3765,7106,4584, 
1, // chain 1520
3765,7106,4585, 3766,7107,4585, 3763,7104,4585, 
1, // chain 1521
3766,7108,4586, 3765,7109,4587, 3767,7110,4588, 
1, // chain 1522
3767,7110,4589, 3768,7111,4589, 3766,7108,4589, 
1, // chain 1523
3768,7111,4590, 3767,7110,4591, 3769,7112,4592, 
1, // chain 1524
3769,7112,4593, 3770,7113,4593, 3768,7111,4593, 
1, // chain 1525
3770,7113,4594, 3769,7112,4595, 3764,7105,4596, 
1, // chain 1526
3764,7105,4597, 3763,7104,4597, 3770,7113,4597, 
2, // chain 1527
3764,7114,4583, 3771,7115,4598, 3772,7116,4599, 
3765,7117,4584, 
2, // chain 1528
3765,7118,4587, 3772,7116,4600, 3773,7119,4601, 
3767,7120,4588, 
2, // chain 1529
3767,7121,4591, 3773,7119,4602, 3774,7122,4603, 
3769,7123,4592, 
2, // chain 1530
3769,7124,4595, 3774,7122,4604, 3771,7115,4605, 
3764,7125,4596, 
9, // chain 1531
3772,7116,4606, 3771,7115,4607, 3775,7126,4608, 
3776,7127,4609, 36545,7128,4610, 36539,7115,4607, 3774,7122,4611, 3778,7129,4612, 36541,7119,4613, 3776,7127,4609, 36540,7116,4606, 
1, // chain 1532
3778,7129,4612, 3776,7127,4609, 3777,7128,4610, 
5, // chain 1533
3779,7130,4614, 3780,7131,4615, 3781,7132,4616, 
3782,7133,4617, 36551,7134,4618, 36552,7135,4619, 3785,7136,4620, 
2, // chain 1534
3786,7137,4621, 3780,7131,4615, 3779,7130,4614, 
3787,7138,2276, 
1, // chain 1535
3787,7138,2276, 3788,7139,2276, 3786,7137,2276, 
11, // chain 1536
3789,7140,4622, 3790,7141,1102, 3791,7142,4623, 
3785,7136,4624, 36551,7134,4625, 36550,7133,4617, 36560,7143,4626, 36558,7141,1102, 3793,7144,4627, 3782,7133,4617, 36562,7145,4628, 3779,7130,4614, 36555,7138,4629, 
4, // chain 1537
3794,7146,4628, 3793,7144,4627, 3790,7141,4630, 
3795,7147,4631, 36557,7140,4622, 3785,7148,4624, 
2, // chain 1538
3796,7149,4632, 3784,7135,4633, 3781,7132,4616, 
3780,7131,4615, 
11, // chain 1539
3797,7150,4634, 3798,7151,4635, 3799,7152,4636, 
3800,7153,4637, 3801,7154,4638, 36570,7155,4639, 3803,7156,4640, 3804,7157,4641, 36573,7158,4642, 3806,7159,4643, 36575,7160,4644, 3798,7161,4635, 36567,7162,4636, 
2, // chain 1540
3800,7163,4637, 3799,7164,4636, 3808,7165,4645, 
36577,7166,4646, 
2, // chain 1541
3810,7167,4647, 3811,7168,4648, 3797,7169,4634, 
36580,7170,4649, 
3, // chain 1542
3797,7169,4634, 3801,7171,4638, 3810,7167,4647, 
36581,7172,4650, 36572,7173,4641, 
4, // chain 1543
3808,7165,4645, 3814,7174,4651, 3802,7175,4639, 
36571,7176,4640, 36583,7177,4652, 3805,7178,4642, 
1, // chain 1544
3802,7175,4639, 3800,7163,4637, 3808,7165,4645, 
1, // chain 1545
3804,7179,4653, 3816,7180,4653, 3817,7181,4653, 
1, // chain 1546
3817,7181,4654, 3813,7182,4650, 3804,7179,4641, 
1, // chain 1547
3797,7183,4655, 3812,7184,4655, 3816,7180,4655, 
3, // chain 1548
3798,7185,4635, 3797,7183,4634, 3816,7180,963, 
3806,7186,4643, 36572,7179,4641, 
1, // chain 1549
3799,7164,4656, 3818,7187,4657, 3809,7166,4658, 
1, // chain 1550
3805,7188,4659, 3819,7189,4659, 3818,7190,4659, 
2, // chain 1551
3807,7191,4644, 3805,7188,4642, 3818,7190,4657, 
3799,7192,4656, 
1, // chain 1552
3819,7189,4660, 3805,7188,4642, 3815,7193,4652, 
3, // chain 1553
3815,7193,4661, 3814,7194,4651, 3808,7195,4645, 
3809,7196,4662, 3819,7189,4663, 
3, // chain 1554
3810,7197,4647, 3813,7182,1102, 3811,7198,4648, 
36585,7181,4664, 3812,7199,4665, 
3, // chain 1555
3820,7200,4666, 3821,7201,4667, 3822,7202,4668, 
3823,7203,4669, 36592,7204,4670, 
7, // chain 1556
3825,7205,4671, 3822,7202,4668, 3821,7201,4667, 
3826,7206,4672, 36595,7207,4673, 3828,7208,4674, 36597,7209,4675, 3824,7210,4670, 36591,7211,4669, 
3, // chain 1557
3820,7212,4666, 3823,7213,4669, 3830,7214,4676, 
3831,7215,4677, 3832,7216,4678, 
5, // chain 1558
3824,7217,4670, 3822,7218,4668, 3833,7219,4679, 
3834,7220,4680, 3828,7221,4674, 36603,7222,4681, 3836,7223,4682, 
2, // chain 1559
3837,7224,4683, 3833,7219,4679, 3822,7218,4668, 
3838,7225,4684, 
5, // chain 1560
3839,7226,4685, 3830,7214,4676, 3823,7213,4669, 
3829,7227,4675, 3827,7228,4673, 3840,7229,4686, 36609,7230,4687, 
4, // chain 1561
3826,7231,963, 3828,7232,4674, 3836,7233,4682, 
3825,7234,4671, 36590,7235,4668, 36606,7236,4688, 
3, // chain 1562
3821,7237,4667, 3820,7238,4666, 3832,7239,4689, 
3827,7240,4690, 36609,7241,4691, 
2, // chain 1563
3830,7242,4676, 3839,7243,4685, 3840,7244,4686, 
3831,7245,963, 
1, // chain 1564
3841,7246,4687, 3831,7245,4692, 3840,7244,4686, 
2, // chain 1565
3834,7247,4680, 3833,7248,4679, 3837,7249,4683, 
3835,7250,1102, 
1, // chain 1566
3838,7251,4684, 3835,7250,4693, 3837,7249,4683, 
6, // chain 1567
3842,7252,4694, 3843,7253,4695, 3844,7254,4696, 
3845,7255,4697, 36614,7256,4698, 36615,7257,4699, 36616,7258,4700, 36611,7253,4695, 
15, // chain 1568
3849,7259,4701, 3843,7260,4695, 3842,7261,4694, 
3850,7262,4702, 36615,7257,4699, 36619,7263,4703, 36620,7264,4704, 3853,7265,4705, 3854,7266,4706, 36623,7267,4707, 36624,7268,4708, 3857,7269,4709, 3858,7270,4710, 36627,7271,4711, 3860,7272,4712, 3861,7273,4713, 36630,7274,4714, 
2, // chain 1569
3848,7258,4700, 3849,7259,4701, 3850,7262,4702, 
3847,7257,4699, 
8, // chain 1570
3845,7255,4697, 3863,7275,4715, 3864,7276,4716, 
3853,7277,4705, 36624,7278,4708, 36633,7279,4717, 36634,7280,4718, 36631,7275,4715, 3846,7256,4698, 36613,7255,4697, 
2, // chain 1571
3853,7277,4705, 3852,7281,4704, 3845,7255,4697, 
36610,7252,4694, 
6, // chain 1572
3846,7256,4698, 3851,7263,4703, 3854,7266,4706, 
3866,7280,4718, 36635,7282,4719, 36623,7267,4707, 3861,7273,4713, 36626,7270,4710, 
1, // chain 1573
3851,7263,4703, 3846,7256,4698, 3847,7257,4699, 
8, // chain 1574
3866,7280,4718, 3867,7282,4719, 3865,7279,4717, 
36636,7283,4720, 36629,7273,4713, 3862,7274,4721, 3859,7284,4711, 3857,7285,4709, 3865,7279,4717, 36624,7278,4708, 
2, // chain 1575
3869,7286,215, 3870,7287,4722, 3871,7288,215, 
36640,7289,4723, 
9, // chain 1576
3870,7287,4722, 3869,7286,4724, 3873,7290,4725, 
36642,7291,4726, 36643,7292,4727, 3876,7293,4728, 36645,7294,4729, 3878,7295,4730, 36640,7296,4723, 3879,7297,4731, 36638,7298,4722, 
3, // chain 1577
3880,7299,4732, 3881,7300,4733, 3873,7290,4725, 
36647,7301,4731, 36650,7302,4734, 
7, // chain 1578
3881,7300,4735, 3880,7299,4736, 3883,7303,4737, 
36652,7304,4738, 36653,7305,4739, 3886,7306,4740, 36655,7307,4741, 36650,7308,4742, 3883,7309,4737, 
6, // chain 1579
3888,7310,4743, 3889,7311,4744, 3890,7312,4745, 
3891,7313,4746, 3892,7314,4747, 36651,7303,4737, 36661,7315,4748, 3887,7316,4741, 
8, // chain 1580
3894,7317,4749, 3895,7318,4750, 3871,7288,4751, 
36664,7319,4752, 36665,7320,4753, 3872,7296,4754, 3877,7294,215, 3875,7292,215, 3871,7288,215, 36637,7286,215, 
12, // chain 1581
3883,7303,4737, 3884,7304,4738, 3892,7314,4747, 
36666,7321,4755, 36654,7306,4740, 3887,7307,4741, 3893,7322,4748, 3891,7323,4746, 3890,7324,4745, 3899,7325,4756, 36668,7326,4757, 3901,7327,4758, 36670,7328,4759, 36671,7329,4760, 
3, // chain 1582
3904,7330,25, 3873,7290,4725, 3874,7291,4726, 
3876,7293,4728, 3878,7295,4730, 
5, // chain 1583
3873,7290,4725, 3904,7330,4761, 3880,7299,4732, 
36653,7305,4762, 36646,7295,4730, 3882,7308,4734, 36647,7297,4731, 
8, // chain 1584
3889,7311,4744, 3888,7310,4743, 3905,7331,4763, 
3906,7332,4764, 36675,7333,4765, 36669,7327,4758, 36667,7325,4756, 36656,7310,4743, 3892,7314,4747, 3898,7321,4755, 
2, // chain 1585
3908,7334,4766, 3903,7335,4760, 3906,7332,4767, 
36668,7336,4757, 
5, // chain 1586
3903,7335,25, 3908,7334,25, 3909,7337,4768, 
36678,7338,25, 36679,7339,25, 36670,7328,25, 3903,7329,25, 
3, // chain 1587
3906,7332,4767, 3907,7333,4765, 3908,7334,4766, 
36670,7328,4759, 36669,7327,4758, 
3, // chain 1588
3912,7340,4769, 3913,7341,4770, 3909,7337,4771, 
36682,7342,4772, 3911,7343,4773, 
3, // chain 1589
3909,7337,4771, 3910,7338,4774, 3912,7340,4769, 
36682,7344,4772, 36679,7339,4773, 
2, // chain 1590
3897,7345,4753, 3894,7317,4749, 3872,7289,4754, 
36639,7288,4751, 
1, // chain 1591
3882,7302,4742, 3881,7300,4735, 3883,7303,4737, 
2, // chain 1592
3900,7336,4757, 3890,7312,4745, 3889,7311,4744, 
3906,7332,4764, 
1, // chain 1593
3909,7337,4768, 3911,7343,25, 3903,7335,25, 
1, // chain 1594
3873,7290,4725, 3879,7301,4731, 3870,7287,4722, 
13, // chain 1595
3915,7346,4775, 3916,7347,4776, 3917,7348,4777, 
3918,7349,4778, 36687,7350,4779, 3920,7351,4780, 36689,7352,4781, 36690,7353,4782, 3923,7354,4783, 36692,7355,4784, 3925,7356,4785, 36694,7357,4786, 36695,7358,4787, 3928,7359,4788, 36697,7360,4789, 
6, // chain 1596
3930,7361,4790, 3917,7348,4777, 3916,7347,4776, 
3931,7362,4791, 3932,7363,4792, 36701,7364,4793, 3929,7365,4789, 3927,7366,4787, 
5, // chain 1597
3917,7367,4777, 3930,7368,4790, 3932,7369,4792, 
3927,7370,4787, 3924,7371,4784, 3919,7372,4779, 36690,7373,4782, 
11, // chain 1598
3934,7374,4794, 3935,7375,4795, 3936,7376,4796, 
36705,7377,4797, 36706,7378,4798, 36707,7379,4799, 36708,7380,4800, 36709,7381,4801, 36710,7382,4802, 36711,7383,4803, 36712,7384,4804, 3945,7385,4805, 36714,7386,4806, 
6, // chain 1599
3916,7387,4776, 3915,7388,4775, 3947,7389,4807, 
3948,7390,4808, 3931,7391,4791, 36701,7392,4793, 36717,7393,4809, 3929,7394,4789, 
12, // chain 1600
3929,7395,4789, 3949,7396,4809, 3950,7397,4810, 
36719,7398,4811, 3952,7399,4812, 36707,7400,4799, 3940,7401,4800, 3953,7402,4813, 36709,7403,4801, 3954,7404,4814, 3950,7397,4810, 36696,7405,4788, 36694,7406,4786, 36723,7407,4815, 
1, // chain 1601
3950,7397,4810, 3928,7405,4788, 3929,7395,4789, 
3, // chain 1602
3925,7408,4785, 3926,7409,4786, 3955,7410,4815, 
3956,7411,4816, 3923,7412,4783, 
3, // chain 1603
3921,7413,4781, 3923,7414,4783, 3956,7415,4816, 
3946,7416,4806, 36713,7417,4805, 
5, // chain 1604
3920,7418,4780, 3921,7413,4781, 3946,7416,4806, 
3957,7419,4817, 36726,7420,4818, 36703,7421,4795, 36712,7422,4804, 
1, // chain 1605
3957,7419,4817, 3918,7423,4778, 3920,7418,4780, 
2, // chain 1606
3918,7424,4778, 3957,7425,4817, 3947,7389,4807, 
3915,7388,4775, 
10, // chain 1607
3948,7390,4819, 3947,7389,4820, 3959,7426,4821, 
3960,7427,4822, 36729,7428,4823, 36730,7429,4824, 36704,7430,4796, 3937,7431,4797, 3961,7428,4823, 36706,7432,4798, 3960,7427,4822, 36731,7433,4825, 
2, // chain 1608
3949,7393,4809, 3948,7390,4819, 3960,7427,4822, 
3951,7434,4811, 
7, // chain 1609
3945,7435,4805, 3956,7411,4816, 3955,7410,4826, 
3964,7436,4827, 36710,7437,4802, 3965,7438,4828, 36711,7439,4803, 3945,7435,4805, 3964,7436,4827, 
2, // chain 1610
3947,7389,4820, 3957,7425,4817, 3966,7440,4829, 
3959,7426,4821, 
2, // chain 1611
3959,7441,4821, 3966,7442,4829, 3936,7376,4796, 
36702,7374,4794, 
3, // chain 1612
3951,7443,4811, 3960,7444,4822, 3939,7379,4799, 
36731,7445,4825, 3938,7378,4798, 
1, // chain 1613
3950,7397,4810, 3952,7399,4812, 3953,7402,4813, 
3, // chain 1614
3955,7446,4815, 3954,7447,4814, 3941,7381,4801, 
3967,7448,4830, 36710,7382,4802, 
3, // chain 1615
3957,7419,4817, 3958,7420,4818, 3968,7449,4831, 
36702,7450,4794, 36703,7421,4795, 
2, // chain 1616
3966,7451,4829, 3957,7419,4817, 3968,7449,4831, 
3934,7450,4794, 
1, // chain 1617
3967,7452,4830, 3942,7437,4802, 3955,7410,4815, 
6, // chain 1618
3969,7453,4832, 3970,7454,4833, 3971,7455,4834, 
3972,7456,4835, 3973,7457,4836, 36742,7458,4837, 36743,7459,4838, 3976,7460,4839, 
1, // chain 1619
3970,7454,4833, 3977,7461,2483, 3971,7455,4834, 
2, // chain 1620
3970,7454,2492, 3978,7462,2492, 3979,7463,2492, 
3977,7464,2492, 
4, // chain 1621
3980,7465,4840, 3981,7466,4841, 3982,7467,4842, 
3983,7468,4843, 3984,7469,4844, 3985,7470,4845, 
6, // chain 1622
3986,7471,4846, 3985,7472,4845, 3984,7473,4844, 
3987,7474,4847, 3988,7475,4848, 36757,7476,4849, 3990,7477,4850, 36759,7478,4851, 
2, // chain 1623
3981,7466,4841, 3992,7479,4852, 3993,7480,4853, 
3982,7467,4842, 
4, // chain 1624
3994,7481,4854, 3995,7482,4855, 3996,7483,4856, 
3997,7484,4857, 36766,7485,4858, 36767,7486,4859, 
5, // chain 1625
4000,7487,4860, 3996,7483,4856, 3995,7482,4855, 
4001,7488,4861, 4002,7489,4862, 36744,7490,4839, 3975,7491,4838, 
2, // chain 1626
3998,7485,2515, 3999,7492,2515, 4003,7493,2515, 
4004,7494,2516, 
9, // chain 1627
3996,7495,4863, 4000,7496,4864, 3983,7497,4865, 
36770,7498,4866, 3984,7499,4867, 36743,7500,4868, 3987,7501,4869, 36740,7502,4870, 3989,7503,4871, 36739,7504,4872, 3991,7505,4873, 
2, // chain 1628
3983,7497,4865, 3982,7506,4874, 3996,7495,4863, 
36761,7507,4875, 
4, // chain 1629
3981,7466,4876, 3980,7465,1102, 3995,7482,1102, 
36769,7488,1102, 36744,7490,1102, 36753,7470,1102, 
7, // chain 1630
3995,7482,1102, 3994,7481,4877, 3981,7466,4876, 
36773,7508,4878, 4006,7509,4879, 36775,7510,2557, 3997,7484,4880, 36776,7511,4881, 3994,7481,4882, 
15, // chain 1631
3985,7472,1102, 3986,7471,1102, 3976,7460,1102, 
36742,7458,1102, 36741,7457,1102, 36756,7475,1102, 3969,7453,1102, 36777,7512,1102, 36758,7477,4879, 4010,7513,4883, 4011,7514,4884, 36746,7462,4884, 3970,7454,2536, 4012,7515,2536, 36781,7516,1102, 36737,7453,1102, 4009,7512,1102, 
2, // chain 1632
3999,7517,4885, 3996,7495,4886, 4014,7518,4887, 
36761,7507,4888, 
1, // chain 1633
4014,7518,4887, 4003,7519,2531, 3999,7517,4885, 
1, // chain 1634
4006,7509,4879, 3992,7479,4889, 3981,7466,4876, 
2, // chain 1635
3993,7520,4853, 3992,7479,4852, 4006,7509,4890, 
4014,7521,2547, 
2, // chain 1636
4010,7513,4891, 3990,7477,4850, 3991,7522,4851, 
4015,7523,2550, 
2, // chain 1637
3978,7462,965, 4010,7513,965, 4015,7523,965, 
3979,7524,965, 
2, // chain 1638
4003,7525,2551, 4014,7521,2551, 4006,7509,2551, 
4004,7494,2551, 
2, // chain 1639
4016,7526,1102, 4017,7527,1102, 4018,7528,1102, 
4019,7529,1102, 
2, // chain 1640
4017,7527,694, 4016,7526,694, 4007,7530,694, 
4005,7531,694, 
2, // chain 1641
4016,7526,215, 4019,7529,215, 4008,7532,215, 
4007,7533,215, 
2, // chain 1642
4018,7528,4892, 3994,7534,4882, 4008,7535,4881, 
4019,7529,766, 
2, // chain 1643
4017,7527,4893, 4005,7536,4878, 3994,7537,4877, 
4018,7528,4894, 
4, // chain 1644
4004,7494,4880, 4006,7509,4879, 4020,7538,4880, 
3998,7485,2557, 36789,7539,4895, 3997,7484,4896, 
2, // chain 1645
4022,7540,4880, 4020,7538,4880, 4006,7509,4879, 
3997,7484,4880, 
2, // chain 1646
4023,7541,1102, 4024,7542,1102, 4025,7543,1102, 
4026,7544,1102, 
2, // chain 1647
4024,7542,694, 4023,7541,694, 4020,7545,694, 
4022,7546,694, 
2, // chain 1648
4023,7541,215, 4026,7544,215, 4021,7547,215, 
4020,7548,215, 
2, // chain 1649
4025,7543,4897, 3997,7549,4896, 4021,7550,4895, 
4026,7544,766, 
2, // chain 1650
4024,7542,25, 4022,7551,25, 3997,7552,25, 
4025,7543,25, 
1, // chain 1651
3991,7505,4898, 3971,7504,4898, 4015,7553,4898, 
2, // chain 1652
4027,7554,1102, 4028,7555,1102, 4029,7556,1102, 
4030,7557,1102, 
2, // chain 1653
4027,7554,215, 4030,7557,215, 4011,7558,215, 
4012,7559,215, 
2, // chain 1654
4027,7554,694, 4012,7560,694, 4013,7561,2555, 
4028,7555,2555, 
2, // chain 1655
4009,7562,766, 4011,7563,766, 4030,7557,766, 
4029,7556,766, 
2, // chain 1656
4029,7556,25, 4028,7555,2555, 4013,7564,2555, 
4009,7565,25, 
2, // chain 1657
4015,7553,4899, 3971,7504,4899, 3977,7566,2544, 
3979,7567,2543, 
2, // chain 1658
4031,7568,25, 4032,7569,25, 4033,7570,25, 
4034,7571,25, 
7, // chain 1659
4035,7572,4900, 4036,7573,4901, 4037,7574,4902, 
4038,7575,4903, 4039,7576,4904, 36808,7577,4905, 4041,7578,4906, 36810,7579,4907, 4043,7580,4908, 
6, // chain 1660
4044,7581,4909, 4045,7582,4910, 4046,7583,4911, 
4047,7584,4912, 4048,7585,4913, 36817,7586,4914, 36814,7583,4915, 4050,7587,4916, 
28, // chain 1661
4051,7588,4917, 4052,7589,4918, 4053,7590,4919, 
4050,7591,4920, 4046,7592,4911, 4054,7593,4921, 36823,7594,4922, 4056,7595,4923, 36825,7596,4924, 4058,7597,4925, 36827,7598,4926, 36819,7588,4917, 36810,7599,4907, 4060,7600,4927, 36829,7601,4928, 4062,7602,4929, 36831,7603,4930, 36832,7604,4931, 4065,7605,4932, 
36805,7606,4902, 4066,7607,4933, 36835,7608,4934, 36836,7609,4935, 36804,7610,4901, 4069,7611,4936, 36813,7612,4937, 4065,7605,4932, 36838,7613,4938, 4071,7614,4939, 4072,7615,4940, 
11, // chain 1662
4052,7616,4941, 4051,7617,4942, 4072,7618,4940, 
36841,7619,4943, 4074,7620,1102, 4075,7621,4944, 4065,7622,4932, 36831,7623,4945, 36842,7620,4946, 4062,7624,4947, 36841,7619,4948, 4060,7625,4927, 36819,7617,4917, 
6, // chain 1663
4076,7626,4949, 4052,7616,4941, 4072,7618,4940, 
4077,7627,4950, 4078,7628,4951, 36847,7629,4952, 36840,7618,4953, 4071,7630,4954, 
2, // chain 1664
4036,7631,4901, 4055,7632,4922, 4046,7583,4911, 
4045,7582,4910, 
4, // chain 1665
4055,7633,4922, 4036,7573,4901, 4035,7572,4900, 
4043,7580,4908, 36809,7578,4955, 36807,7576,4904, 
2, // chain 1666
4057,7634,4924, 4055,7635,4922, 4043,7636,4908, 
4042,7637,4907, 
4, // chain 1667
4061,7638,4956, 4042,7637,4907, 4040,7639,4905, 
4038,7640,4957, 4064,7641,4931, 36805,7642,4902, 
3, // chain 1668
4080,7643,4958, 4067,7644,4959, 4081,7645,4960, 
4069,7646,4961, 4066,7647,4962, 
1, // chain 1669
4067,7644,4934, 4080,7643,963, 4066,7648,4933, 
1, // chain 1670
4081,7645,4960, 4068,7649,1102, 4069,7650,4961, 
1, // chain 1671
4068,7651,4935, 4081,7645,4963, 4067,7644,4934, 
1, // chain 1672
4065,7605,4932, 4066,7607,4933, 4069,7611,4936, 
2, // chain 1673
4070,7652,4964, 4045,7582,4910, 4044,7581,4909, 
4048,7585,4913, 
2, // chain 1674
4076,7626,4949, 4078,7628,4951, 4053,7653,4965, 
4052,7616,4941, 
2, // chain 1675
4070,7654,4966, 4033,7570,4967, 4032,7569,4968, 
4071,7655,4969, 
4, // chain 1676
4071,7656,1102, 4032,7569,1102, 4079,7657,1102, 
36846,7658,1102, 36799,7568,4970, 4053,7659,4971, 
2, // chain 1677
4053,7660,4971, 4031,7568,4970, 4034,7571,4972, 
4050,7661,4973, 
4, // chain 1678
4050,7662,963, 4034,7571,963, 4049,7663,963, 
36801,7570,4967, 4048,7664,963, 36838,7665,4966, 
3, // chain 1679
4082,7666,4974, 4054,7667,4975, 4083,7668,4976, 
4058,7669,4977, 4059,7670,963, 
1, // chain 1680
4054,7667,4921, 4082,7666,4962, 4059,7671,4926, 
1, // chain 1681
4054,7672,4975, 4056,7673,1102, 4083,7668,4976, 
1, // chain 1682
4058,7669,4925, 4083,7668,4963, 4056,7674,4923, 
1, // chain 1683
4054,7593,4921, 4059,7598,4926, 4051,7588,4917, 
2, // chain 1684
4084,7675,1952, 4085,7676,1952, 4086,7677,1952, 
4087,7678,1952, 
10, // chain 1685
4088,7679,4978, 4084,7680,4979, 4087,7681,4980, 
4089,7682,4981, 4090,7683,4982, 36859,7684,4983, 4092,7685,4984, 36861,7686,4985, 4094,7687,4986, 36863,7688,4987, 4096,7689,4988, 36865,7690,4989, 
9, // chain 1686
4098,7691,766, 4085,7692,766, 4084,7693,766, 
4099,7694,766, 36856,7695,766, 4100,7696,766, 36869,7697,766, 36858,7698,766, 4102,7699,766, 36871,7700,766, 36860,7701,766, 
7, // chain 1687
4104,7702,694, 4091,7703,694, 4089,7704,694, 
4105,7705,694, 36874,7706,694, 36855,7707,694, 4107,7708,694, 36854,7709,694, 4108,7710,694, 
2, // chain 1688
4108,7711,963, 4086,7677,963, 4085,7676,963, 
4098,7712,963, 
10, // chain 1689
4109,7713,4990, 4110,7714,4991, 4111,7715,4992, 
4112,7716,4993, 36881,7717,4994, 36882,7718,4995, 36883,7719,4996, 36884,7720,4997, 36885,7721,4998, 36878,7714,4991, 4118,7722,4999, 36887,7723,5000, 
3, // chain 1690
4120,7724,5001, 4121,7725,5002, 4109,7726,4990, 
4122,7727,5003, 36880,7728,4993, 
9, // chain 1691
4110,7729,4991, 4109,7726,4990, 4121,7725,5002, 
4123,7730,5004, 36892,7731,5005, 36893,7732,5006, 36888,7724,5001, 4126,7733,5007, 36895,7734,5008, 36896,7735,5009, 36890,7727,5003, 
8, // chain 1692
4117,7721,4998, 4118,7722,4999, 4129,7736,5010, 
4130,7737,5011, 4116,7720,4997, 36899,7738,5012, 4132,7739,5013, 36901,7740,5014, 4125,7732,5006, 36892,7731,5005, 
5, // chain 1693
4134,7741,5015, 4114,7718,4995, 4115,7719,4996, 
4135,7742,5016, 36894,7733,5007, 36900,7739,5013, 36884,7720,4997, 
1, // chain 1694
4126,7733,5007, 4127,7734,5008, 4135,7742,5016, 
1, // chain 1695
4110,7729,4991, 4123,7730,5004, 4119,7743,5000, 
3, // chain 1696
4128,7744,5009, 4122,7745,5003, 4114,7746,4995, 
36880,7747,5017, 4113,7748,4994, 
3, // chain 1697
4114,7746,4995, 4134,7749,5015, 4128,7744,5009, 
36903,7750,1997, 4127,7751,5008, 
6, // chain 1698
4119,7752,5000, 4123,7753,5004, 4118,7754,5018, 
36897,7755,5010, 36892,7756,5005, 4130,7757,5011, 36899,7758,5019, 36901,7759,5014, 
1, // chain 1699
4126,7733,5007, 4132,7739,5013, 4125,7732,5006, 
4, // chain 1700
4136,7760,5020, 4137,7761,5021, 4138,7762,5022, 
36907,7763,5023, 4140,7764,5024, 36909,7765,5025, 
1, // chain 1701
4138,7762,5022, 4142,7766,5026, 4136,7760,5020, 
2, // chain 1702
4143,7767,5027, 4138,7762,5022, 4144,7768,5028, 
36908,7764,5024, 
1, // chain 1703
4143,7767,5027, 4144,7768,5028, 4145,7769,5029, 
1, // chain 1704
4136,7770,5020, 4146,7771,5030, 4137,7772,5021, 
2, // chain 1705
4141,7773,5031, 4147,7774,2670, 4148,7775,5032, 
4145,7776,5029, 
1, // chain 1706
4143,7777,5033, 4145,7778,5034, 4148,7779,5035, 
1, // chain 1707
4143,7777,5027, 4149,7780,5036, 4138,7781,5022, 
1, // chain 1708
4142,7782,5026, 4138,7781,1102, 4149,7780,5037, 
9, // chain 1709
4142,7783,5026, 4149,7784,5037, 4146,7785,5038, 
36918,7786,2676, 36919,7787,5039, 36908,7788,5024, 36920,7789,5040, 36911,7790,5033, 4148,7791,5035, 4151,7787,5041, 36915,7792,5042, 
1, // chain 1710
4146,7785,5038, 4136,7793,5020, 4142,7783,5026, 
4, // chain 1711
4151,7794,5041, 4147,7774,5042, 4139,7795,5043, 
4150,7796,5044, 36905,7797,5021, 4146,7798,5030, 
1, // chain 1712
4147,7774,5042, 4141,7773,5045, 4139,7795,5043, 
1, // chain 1713
4140,7799,5024, 4152,7800,5046, 4144,7801,5028, 
3, // chain 1714
4145,7802,5029, 4144,7801,5028, 4152,7800,5047, 
4151,7803,5048, 4141,7804,5031, 
1, // chain 1715
4140,7805,5024, 4141,7804,5025, 4151,7803,5039, 
7, // chain 1716
4153,7806,5049, 4154,7807,5050, 4155,7808,5051, 
4156,7809,5052, 36925,7810,5053, 36926,7811,5054, 36927,7812,5055, 36928,7813,5056, 4161,7814,5057, 
6, // chain 1717
4162,7815,5058, 4153,7816,5049, 4156,7817,5052, 
4163,7818,5059, 36925,7819,5060, 4164,7820,5061, 36933,7821,5062, 36934,7822,5063, 
2, // chain 1718
4166,7822,5064, 4161,7823,5057, 4167,7824,5065, 
4165,7821,2705, 
1, // chain 1719
4167,7824,5066, 4161,7823,5067, 4160,7825,5068, 
1, // chain 1720
4155,7826,5051, 4168,7827,5069, 4160,7828,5056, 
1, // chain 1721
4168,7827,5070, 4155,7826,1102, 4154,7829,5050, 
10, // chain 1722
4154,7830,5050, 4153,7831,5049, 4162,7832,5071, 
4168,7833,5070, 36931,7834,2713, 4164,7835,5072, 4158,7836,5054, 4169,7837,5073, 4160,7838,5068, 36935,7839,5066, 36932,7835,5061, 4165,7840,5062, 
1, // chain 1723
4159,7841,5055, 4169,7842,5074, 4158,7843,5054, 
3, // chain 1724
4161,7844,5057, 4166,7845,5064, 4164,7846,5075, 
4169,7842,5076, 4159,7841,5055, 
1, // chain 1725
4164,7847,5072, 4166,7848,5077, 4158,7843,5054, 
1, // chain 1726
4166,7849,5077, 4157,7810,5053, 4158,7811,5054, 
2, // chain 1727
4170,7850,215, 4171,7851,215, 4172,7852,215, 
4173,7853,215, 
2, // chain 1728
4172,7854,5078, 4174,7855,5079, 4175,7856,5080, 
4173,7857,5081, 
2, // chain 1729
4176,7858,5082, 4175,7856,5080, 4174,7855,5079, 
4177,7859,5083, 
2, // chain 1730
4178,7860,5084, 4179,7861,5085, 4171,7862,5086, 
4170,7863,2011, 
3, // chain 1731
4180,7864,5087, 4171,7862,5086, 4179,7861,5085, 
4181,7865,5088, 36950,7866,5089, 
5, // chain 1732
4181,7867,5088, 4182,7868,5089, 4177,7869,5090, 
4174,7870,5091, 4180,7871,5092, 36939,7872,5093, 36940,7873,5094, 
2, // chain 1733
4183,7874,5095, 4179,7875,5085, 4178,7876,5084, 
4184,7877,5096, 
2, // chain 1734
4185,7878,215, 4186,7879,215, 4187,7880,215, 
4188,7881,215, 
4, // chain 1735
4186,7882,2007, 4189,7883,5097, 4187,7884,5098, 
36958,7885,5099, 36959,7886,5100, 4176,7858,5082, 
3, // chain 1736
4184,7887,5096, 4188,7888,2020, 4192,7889,5101, 
4183,7890,5095, 36947,7861,5085, 
2, // chain 1737
4191,7891,5100, 4189,7892,5097, 4175,7893,5080, 
4176,7894,5082, 
2, // chain 1738
4170,7895,5102, 4173,7896,2748, 4175,7897,5103, 
4178,7898,5104, 
2, // chain 1739
4184,7899,5096, 4178,7898,5084, 4175,7897,5080, 
4189,7900,5097, 
2, // chain 1740
4184,7899,5105, 4189,7900,5106, 4186,7901,5107, 
4185,7902,2041, 
1, // chain 1741
4185,7903,2021, 4188,7888,2020, 4184,7887,5096, 
2, // chain 1742
4190,7904,5099, 4192,7905,5101, 4188,7906,2020, 
4187,7907,5098, 
2, // chain 1743
4193,7908,25, 4194,7909,25, 4195,7910,25, 
4196,7911,25, 
4, // chain 1744
4177,7912,5083, 4197,7913,5108, 4176,7914,5082, 
36966,7915,5109, 36967,7916,5110, 36968,7917,2765, 
3, // chain 1745
4190,7918,5099, 4198,7919,5109, 4201,7920,5111, 
36970,7921,5112, 36967,7922,2763, 
4, // chain 1746
4192,7923,5113, 4190,7918,5099, 4201,7920,5111, 
4203,7924,5114, 36972,7925,5115, 36970,7921,2767, 
3, // chain 1747
4182,7926,5089, 4203,7927,5116, 4197,7913,5117, 
36968,7917,5118, 36972,7928,5119, 
1, // chain 1748
4197,7913,5117, 4177,7912,5090, 4182,7926,5089, 
8, // chain 1749
4205,7929,25, 4206,7930,25, 4200,7931,25, 
4204,7932,25, 4207,7933,25, 36970,7934,25, 4208,7935,25, 36967,7936,25, 4206,7930,25, 36968,7931,25, 
2, // chain 1750
4205,7929,766, 4194,7909,766, 4193,7908,766, 
4206,7930,766, 
2, // chain 1751
4206,7930,963, 4193,7908,963, 4196,7911,963, 
4208,7935,963, 
2, // chain 1752
4208,7935,694, 4196,7911,694, 4195,7910,694, 
4207,7933,694, 
2, // chain 1753
4207,7933,1102, 4195,7910,1102, 4194,7909,1102, 
4205,7929,1102, 
2, // chain 1754
4179,7937,5120, 4192,7923,5113, 4203,7924,5114, 
4182,7938,5121, 
1, // chain 1755
4198,7915,5109, 4190,7939,5099, 4176,7914,5082, 
1, // chain 1756
4209,7940,5122, 4210,7941,2060, 4211,7942,5123, 
13, // chain 1757
4212,7943,2078, 4209,7940,2079, 4211,7942,2080, 
4213,7944,2081, 4214,7945,5124, 36983,7946,5125, 4216,7947,5126, 36985,7948,5127, 4218,7949,5128, 36987,7950,5129, 4220,7951,5130, 36989,7952,5131, 4222,7953,5132, 36991,7954,5133, 4224,7955,5134, 
4, // chain 1758
4224,7956,5134, 4223,7957,5133, 4225,7958,5135, 
4226,7959,5136, 4209,7960,5122, 36978,7961,2060, 
6, // chain 1759
4210,7962,2096, 4226,7963,5136, 4211,7964,2097, 
36995,7965,2098, 36993,7966,5135, 4228,7967,2099, 36989,7968,2100, 36991,7969,5133, 
6, // chain 1760
4219,7970,2101, 4217,7971,2102, 4229,7972,2103, 
36998,7973,2104, 36983,7974,2105, 4213,7975,2106, 4227,7965,2098, 36979,7964,2097, 
3, // chain 1761
4228,7967,2099, 4219,7970,2101, 4229,7972,2103, 
4230,7973,2104, 4227,7965,2098, 
1, // chain 1762
4221,7968,2100, 4219,7970,2101, 4228,7967,2099, 
3, // chain 1763
4231,7976,5137, 4232,7977,5138, 4233,7978,5139, 
4234,7979,5140, 37003,7980,5141, 
9, // chain 1764
4233,7981,5139, 4232,7982,5138, 4236,7983,5142, 
37005,7984,5143, 4238,7985,5144, 4239,7986,5145, 37002,7987,5140, 4235,7988,5141, 4240,7989,5146, 4236,7983,5142, 37001,7981,5139, 
3, // chain 1765
4237,7990,5143, 4232,7977,5138, 4231,7976,5137, 
4238,7991,5144, 37002,7979,5140, 
3, // chain 1766
4241,7992,5147, 4242,7993,5148, 4243,7994,5149, 
4244,7995,5150, 37013,7996,5151, 
3, // chain 1767
4242,7997,5148, 4241,7998,5147, 4246,7999,5152, 
4247,8000,5153, 37016,8001,5154, 
5, // chain 1768
4245,8002,5151, 4242,7997,5148, 4247,8000,5153, 
4244,8003,5150, 37017,8004,5155, 37018,8005,5156, 37016,8001,5157, 
2, // chain 1769
4249,8006,5155, 4248,8007,5154, 4241,7992,5147, 
4244,7995,5150, 
1, // chain 1770
4248,8007,5154, 4246,8008,5152, 4241,7992,5147, 
1, // chain 1771
4248,8001,5154, 4249,8004,5155, 4250,8005,5156, 
11, // chain 1772
4251,8009,5158, 4252,8010,5159, 4253,8011,5160, 
37022,8012,5161, 37023,8013,5162, 37024,8014,5163, 4257,8015,5164, 4258,8016,5165, 37027,8017,5166, 4260,8018,5167, 37029,8019,5168, 37030,8020,5169, 37031,8021,5170, 
3, // chain 1773
4253,8011,5160, 4264,8022,5171, 4251,8009,5158, 
37033,8023,5172, 37034,8024,5173, 
7, // chain 1774
4267,8025,5174, 4251,8009,5158, 4265,8023,5172, 
4268,8026,5175, 4269,8027,5176, 37038,8028,5177, 4263,8029,5170, 37030,8030,5169, 37039,8031,5178, 
3, // chain 1775
4263,8032,766, 4259,8033,766, 4252,8034,5159, 
37025,8035,766, 4256,8036,5163, 
3, // chain 1776
4252,8034,5159, 4251,8037,5158, 4263,8032,766, 
37037,8038,766, 37035,8039,5174, 
3, // chain 1777
4260,8040,5167, 4261,8041,5168, 4254,8042,5161, 
4258,8043,694, 37023,8044,5162, 
3, // chain 1778
4253,8045,5160, 4254,8042,5161, 4261,8041,5168, 
4264,8046,5171, 37030,8047,5169, 
2, // chain 1779
4271,8048,25, 4266,8049,5173, 4264,8046,5171, 
4262,8047,25, 
5, // chain 1780
4272,8050,5179, 4273,8051,5180, 4274,8052,5181, 
4275,8053,5182, 37044,8054,5183, 37045,8055,5184, 37046,8056,5185, 
5, // chain 1781
4279,8057,5179, 4280,8058,5180, 4281,8059,5181, 
4282,8060,5182, 37051,8061,5186, 37052,8062,5187, 37053,8063,5188, 
6, // chain 1782
4286,8064,5189, 4287,8065,5190, 4288,8066,5191, 
4289,8067,5192, 4290,8068,5193, 4291,8069,5194, 37055,8065,5190, 37060,8070,5195, 
3, // chain 1783
4272,8050,5179, 4275,8053,5182, 4277,8055,5184, 
37058,8068,5196, 37044,8054,5183, 
6, // chain 1784
4293,8071,5197, 4294,8072,5190, 4295,8073,5191, 
4296,8074,5192, 4297,8075,5198, 4298,8076,5199, 37062,8072,5190, 37067,8077,5200, 
3, // chain 1785
4279,8057,5179, 4282,8060,5182, 4284,8062,5187, 
37065,8075,5196, 37051,8061,5186, 
4, // chain 1786
4274,8052,5201, 4273,8051,5180, 4300,8078,5202, 
4287,8065,5190, 4286,8064,5189, 4291,8069,5194, 
2, // chain 1787
4290,8068,5196, 4289,8067,5192, 4301,8079,5203, 
4277,8055,5184, 
4, // chain 1788
4281,8059,5201, 4280,8058,5180, 4302,8080,5204, 
4294,8072,5190, 4293,8071,5197, 4298,8076,5199, 
2, // chain 1789
4297,8075,5196, 4296,8074,5192, 4303,8081,5203, 
4284,8062,5187, 
4, // chain 1790
4289,8082,5192, 4288,8083,5191, 4287,8084,5190, 
4301,8085,5203, 37060,8086,5195, 4277,8087,5184, 
4, // chain 1791
4296,8088,5192, 4295,8089,5191, 4294,8090,5190, 
4303,8091,5203, 37067,8092,5200, 4284,8093,5187, 
3, // chain 1792
4272,8094,5179, 4277,8087,5184, 4300,8095,5202, 
37046,8096,5185, 4287,8084,5190, 
1, // chain 1793
4300,8095,5202, 4273,8097,5180, 4272,8094,5179, 
3, // chain 1794
4279,8098,5179, 4284,8093,5187, 4302,8099,5204, 
37053,8100,5188, 4294,8090,5190, 
1, // chain 1795
4302,8099,5204, 4280,8101,5180, 4279,8098,5179, 
2, // chain 1796
4278,8056,5205, 4274,8052,5206, 4291,8069,5207, 
4287,8065,5208, 
2, // chain 1797
4292,8070,5209, 4290,8068,5210, 4276,8054,5211, 
4277,8055,5212, 
2, // chain 1798
4285,8063,5213, 4281,8059,5206, 4298,8076,5214, 
4294,8072,5215, 
2, // chain 1799
4299,8077,5216, 4297,8075,5217, 4283,8061,5218, 
4284,8062,5219, 
5, // chain 1800
4304,8102,5220, 4305,8103,5221, 4306,8104,5222, 
4307,8105,5223, 37076,8106,5224, 37077,8107,5225, 37078,8108,5226, 
1, // chain 1801
4308,8106,5224, 4311,8109,5227, 4307,8105,5223, 
5, // chain 1802
4311,8110,5227, 4308,8111,5224, 4312,8112,5228, 
37081,8113,5229, 4305,8114,5221, 37078,8115,5226, 4306,8116,5222, 
2, // chain 1803
4311,8110,5227, 4312,8112,5228, 4305,8114,5221, 
4304,8117,5220, 
2, // chain 1804
4308,8106,5224, 4309,8107,5230, 4313,8118,5229, 
37078,8108,5226, 
7, // chain 1805
4314,8119,5231, 4315,8120,5232, 4316,8121,5233, 
4317,8122,5234, 37086,8123,5235, 4319,8124,5236, 4320,8125,5237, 4314,8119,5231, 37089,8126,5238, 
6, // chain 1806
4321,8127,5238, 4320,8128,5237, 4322,8129,5239, 
37087,8130,5236, 4318,8131,5235, 4316,8132,5233, 4315,8133,5232, 4321,8127,5238, 
3, // chain 1807
4265,8134,5172, 4266,8049,5173, 4268,8135,694, 
37038,8136,694, 37039,8048,694, 
3, // chain 1808
4323,8137,5240, 4324,8138,5241, 4325,8139,5242, 
37094,8140,5243, 37095,8141,5244, 
24, // chain 1809
4326,8142,5243, 4327,8143,5244, 4328,8144,5245, 
4329,8145,5246, 37098,8146,5247, 37099,8147,5248, 37095,8143,5244, 4332,8148,5249, 4323,8137,5240, 4333,8149,5250, 37093,8139,5242, 4334,8150,5251, 37094,8140,5243, 4335,8151,5252, 4336,8152,5253, 37105,8153,5254, 4338,8154,5255, 37107,8155,5256, 4340,8156,5257, 
4341,8157,5258, 37110,8158,5259, 37111,8159,5260, 4344,8160,5261, 4345,8161,5262, 37114,8162,5263, 37115,8163,5264, 
8, // chain 1810
4330,8146,5247, 4331,8147,5248, 4333,8149,5250, 
4348,8164,5265, 37117,8165,5266, 37102,8150,5251, 4336,8152,5253, 4350,8166,5267, 37109,8157,5258, 37106,8154,5255, 
7, // chain 1811
4335,8167,5252, 4326,8142,5243, 4329,8145,5246, 
4351,8168,5268, 37120,8169,5269, 37098,8146,5247, 4348,8164,5265, 4350,8166,5267, 37117,8165,5266, 
34, // chain 1812
4337,8170,5254, 4335,8167,5252, 4351,8168,5268, 
4339,8171,5256, 37121,8172,5270, 37120,8169,5269, 4354,8173,5271, 37118,8166,5267, 4341,8157,5258, 4355,8174,5272, 37110,8158,5259, 4345,8161,5262, 4356,8175,5273, 37125,8176,5274, 37126,8177,5275, 37114,8162,5263, 4359,8178,5276, 4357,8176,5274, 37128,8179,5277, 
4361,8180,5278, 37130,8181,5279, 37115,8182,5264, 4344,8183,5261, 4343,8184,5260, 4361,8180,5278, 37131,8185,5280, 37108,8186,5257, 4339,8171,5256, 4364,8187,5281, 37121,8172,5270, 4354,8173,5271, 4365,8188,5282, 37123,8174,5272, 4356,8175,5273, 4361,8180,5278, 
37125,8176,5274, 
2, // chain 1813
4363,8185,5280, 4364,8187,5281, 4365,8188,5282, 
4361,8180,5278, 
6, // chain 1814
4366,8189,5283, 4367,8190,5284, 4368,8191,5285, 
4369,8192,5286, 37138,8193,5287, 37139,8194,5288, 37140,8195,5289, 37135,8190,5284, 
5, // chain 1815
4371,8194,5288, 4372,8195,5289, 4373,8196,5290, 
4370,8193,5287, 37142,8197,5291, 37134,8198,5283, 37135,8199,5284, 
9, // chain 1816
4370,8193,5287, 4374,8197,5291, 4375,8200,5292, 
37144,8201,5293, 37134,8198,5283, 4369,8202,5286, 4377,8203,5294, 4378,8204,5295, 37147,8205,5296, 37148,8206,5297, 37149,8207,5298, 
5, // chain 1817
4382,8208,5299, 4369,8192,5286, 4383,8209,5300, 
4384,8210,5301, 37153,8211,5302, 37138,8193,5287, 37137,8192,5286, 
3, // chain 1818
4385,8211,5302, 4370,8193,5287, 4375,8200,5292, 
4378,8204,5295, 37144,8201,5293, 
9, // chain 1819
4377,8212,5294, 4369,8192,5286, 4382,8208,5299, 
4386,8213,5303, 37152,8210,5301, 4387,8214,5304, 37156,8215,5305, 37157,8216,5306, 37153,8211,5302, 4379,8205,5296, 37146,8204,5295, 
12, // chain 1820
4377,8212,5294, 4386,8213,5303, 4381,8217,5298, 
37155,8214,5304, 4390,8218,5307, 37159,8219,5308, 37160,8220,5309, 37156,8215,5305, 4393,8221,5310, 37157,8216,5306, 4379,8205,5296, 4394,8222,5311, 37148,8206,5297, 4395,8223,5312, 
5, // chain 1821
4380,8224,5297, 4381,8217,5298, 4396,8225,5313, 
37158,8218,5307, 4391,8219,5308, 4395,8226,5312, 4380,8224,5297, 
1, // chain 1822
4394,8222,5311, 4392,8220,5309, 4393,8221,5310, 

 0};


// mesh info for object R2D2 (with tag [ | o Merged_Meshes | usemtl R2D2_IlluminationMaterial])
const tgx::Mesh3D<tgx::RGB565> R2D2 = 
    {
    1, // version/id
    
    4397, // number of vertices
    8227, // number of texture coords
    5314, // number of normal vectors
    8035, // number of triangles
    36867, 
    
    R2D2_vert_array, // array of vertices
    R2D2_tex_array, // array of texture coords
    R2D2_norm_array, // array of normal vectors        
    R2D2_face, // array of face vertex indexes   
    
    &R2D2_texture, // pointer to texture image 
    
    { 0.75f , 0.75f, 0.75f }, // default color
    
    0.1f, // ambiant light strength 
    0.7f, // diffuse light strength
    0.6f, // specular light strength
    32, // specular exponent
    
    nullptr, // next mesh to draw after this one    
    
    { // mesh bounding box
    -0.5932461286304623, 0.5932461286304623, 
    -1.0000000000000002, 1.0, 
    -0.4650256606529809, 0.4650256606529809
    },
    
    "R2D2" // model name    
    };
    
                
/** end of R2D2.h */
    
    
    