// 3D model [cyborg]
//
// - vertices   : 2869
// - textures   : 2212
// - normals    : 2869
// - triangles  : 5549
//
// - memory size: 124kb
//
// - model bounding box: [-0.86,0.86]x[-1.0,1.0]x[-0.23,0.23]
//
// object [cyborg] (tagged [ | o Cyborg | usemtl Cyborg]) with 5549 triangles (557 chains)

#pragma once

#include <tgx.h>

#include "cyborg_texture.h" // texture for object [cyborg]


// vertex array: 33kb.
const tgx::fVec3 cyborg_vert_array[2869] PROGMEM = {
{-0.024064760908170144,0.8144312374891642,0.0763805009715628},
{-0.02674901285276096,0.8139858157691011,0.07364510012131882},
{-0.025951942406332248,0.8133278064099171,0.07800074911834738},
{-0.02963146680675785,0.8137124888045169,0.07510817194343997},
{-0.02527315380422651,0.8147450573373903,0.07586368390402548},
{-0.025867227031344166,0.8155346685684114,0.07827567448623324},
{-0.020258962646913254,0.814562839361001,0.08132009997479853},
{-0.021493462796896765,0.8160003367302956,0.08356479101143231},
{-0.007921953163586468,0.8147349341164799,0.0891085864626962},
{-0.009099976396911258,0.8159699670675641,0.09206563257077065},
{-8.23177700355989e-05,0.81492727531378,0.09355960685672393},
{-8.23177700355989e-05,0.8142692659545957,0.09008574368111215},
{0.0077471944026047445,0.8147450573373903,0.08911391447370173},
{0.008925217635929536,0.8159800902884746,0.09207096058177618},
{0.021231324655424193,0.8160205831721167,0.0836138087126833},
{0.019999488510943454,0.814583085802822,0.08136911767604947},
{0.02556672721063171,0.8155447917893219,0.07835559465131632},
{0.025216676887567766,0.8148260431046745,0.07615938851483292},
{0.02807835159864305,0.8138542138972643,0.07369891303247476},
{0.027227468241058386,0.813813721013622,0.07366801056864264},
{-0.008269339481147645,0.8151196165110799,0.09045071243499161},
{-0.014645903052577357,0.8124673326325224,0.09057432229032011},
{-0.009151125302564438,0.811515749866933,0.09401994700760255},
{-8.23177700355989e-05,0.8103920723458646,0.0955421597518852},
{-0.010333943745794215,0.8047331918568812,0.09382707300920202},
{-0.01628639764118298,0.8071830113172282,0.09073096581388299},
{-0.02633769040313331,0.8109488494959436,0.0773246245217444},
{-0.013293653859371425,0.8149981378601536,0.08746809187409059},
{0.025026466894670005,0.8507229844533966,-0.08022625931536123},
{-0.00015158191310761285,0.86331627126609,-0.09715335027996033},
{0.035200836710848296,0.8753122880450621,-0.09068141531153145},
{0.046784998239092344,0.8466534496473656,-0.05899786506599007},
{0.06000112953833316,0.8574954192425381,-0.05873572692451753},
{0.055722736700884914,0.8791388655492408,-0.07399142083667887},
{0.055697162248058325,0.905671827555727,-0.07930611181470457},
{0.038299607911670086,0.9138817597141627,-0.09609946970306461},
{0.023113710943681313,0.8904768729690289,-0.10041675702085329},
{-0.0001542459186103826,0.8813760973704667,-0.10231938975093145},
{0.027060168695484443,0.8185615116206585,0.08107607707074481},
{0.022627263538875553,0.8202723359545372,0.0877536732639875},
{0.03183779616415174,0.8176301752968901,0.07581999421378005},
{0.03207169584729493,0.8119510483660856,0.07104769475611829},
{0.025630663342698187,0.813175958096259,0.08150285075228852},
{0.023265026456238635,0.8144211142682537,0.07962845648053972},
{0.013077869413647048,0.814815919883764,0.08848627477724919},
{0.014430118606852982,0.812285114656133,0.09163885888922692},
{0.008086588703657614,0.8149880146392431,0.09046136845700269},
{0.00896890732617496,0.8113841479950962,0.0940274062230103},
{-8.23177700355989e-05,0.814775427000122,0.09274175716737361},
{-0.12517815536799773,0.8217806958702054,-0.056460133424051595},
{-0.11677002120015581,0.8022023866292498,-0.0492039152356073},
{-0.11561810522075815,0.8210417007437372,-0.056339187574225846},
{-0.11606033013421795,0.8246253209460631,-0.07890011737608243},
{-0.1257178828828589,0.8253744392934418,-0.0784424412307066},
{-0.11728204305778815,0.811282915785991,-0.09138897517306711},
{-0.12691455415470307,0.812285114656133,-0.09068940732803978},
{-0.1232531449916963,0.7933850612161826,-0.0918519793294485},
{-0.14636339272822405,0.7908846256512828,-0.08669606307938789},
{-0.1646528561069396,0.8016962255837236,-0.08455207145075878},
{-0.18928371818444828,0.7728652924305481,-0.06663503604133045},
{-0.1943330742143981,0.7869264462752674,-0.06693553586204286},
{-0.21378297839012017,0.7630761378100703,-0.03580769716437926},
{-0.18824688724277028,0.7969686814185084,-0.04371446549659993},
{-0.20782199967712253,0.7672873977088488,-0.023486138912968527},
{-0.17374244288239002,0.7818142197154522,-0.03473250454346138},
{-0.196588421273043,0.758348593644855,-0.015779703794556153},
{-0.16746071790685893,0.7697878332737484,-0.040898611680172274},
{-0.19188538595845325,0.7530035330040977,-0.01821993283509326},
{-0.18412780193438769,0.7502702633582561,-0.026180514078469875},
{-0.16831746207654968,0.7647262228184859,-0.05033025676217836},
{-0.15089912849723985,0.7834136886193152,-0.05111720398769655},
{-0.15058530864901357,0.7787165141168315,-0.06589444251156044},
{-0.13094572728149428,0.7889308440155514,-0.05546272976381459},
{-0.12925088698063214,0.7847094608958625,-0.06633133941401469},
{-0.11817395210011547,0.7885664080627725,-0.05634185157972862},
{-0.13178861862257063,0.8027085476747761,-0.04883894648172784},
{-0.16233890092723374,0.8103819491249542,-0.051214706589097915},
{-0.1654243521005417,0.8147146876746588,-0.06804376215119509},
{-0.021385304173484315,0.9512161984321795,-0.09397252770965323},
{-0.052560029367996676,0.9467113651269957,-0.06568078927023831},
{-0.03676673914537639,0.9639005942330675,-0.06728292217960405},
{-0.01654107656724777,0.9731937110289296,-0.06997996135060815},
{-0.017011539939036913,0.9882975566274329,-0.048008309565964226},
{-0.042092086145413155,0.9769899188703763,-0.045387993753439895},
{-0.05824768111641012,0.9597500736597523,-0.04390733949500046},
{-0.06604629082521835,0.9380661344694072,-0.041441003200536196},
{-0.06212007951523626,0.9206137016196619,-0.06537975664842534},
{-0.03918405773858968,0.9361224760545866,-0.09147795295685962},
{-0.01396977845597439,0.9341889408606763,-0.1006943463942419},
{-0.0001542459186103826,0.9402325037442598,-0.09950886394550935},
{3.596407428737873e-05,0.9611875710290466,-0.08862427026229265},
{2.8504858879623387e-05,0.9782451982632816,-0.07236904148549209},
{5.940732271175268e-05,0.9931668258853956,-0.05032492875117282},
{0.0004142528556806856,0.9983904078752266,-0.028554142981437734},
{-0.015469080752933215,0.995586275683011,-0.02804744913481092},
{-0.019037782524443596,0.992984607909006,-0.027335094063370292},
{-0.04097853184525539,0.9833776712649178,-0.00801412775398228},
{-0.05973099938035233,0.9644978642667884,-0.007926748373491433},
{-0.06813913354819426,0.9441501902366329,-0.009027515447235901},
{-0.07104982596052051,0.9222030473026146,-0.012074604941303961},
{-0.06938642092459107,0.9160683754308364,-0.042819359647669274},
{-0.0724537568604802,0.8880270535086817,-0.04477367408450118},
{-0.06472707530024675,0.8902845317717287,-0.06722857646734753},
{-0.04206917569808934,0.9057730597648324,-0.09624119479581196},
{-0.018479939772163608,0.9208566589215147,-0.10242967957874613},
{-0.0001542459186103826,0.9214842986179672,-0.10098205898854104},
{-0.11232486161823417,0.7997626903898133,-0.12976344163936504},
{-0.09977899410349024,0.8550152301194595,-0.10796867982010502},
{-0.05454471346756015,0.8230562217049314,-0.167915730046732},
{-0.10255915024618077,0.783737631688452,-0.19179534257245962},
{-0.055429163294479715,0.7822191485518732,-0.19552175346973397},
{-7.965376453282913e-05,0.7807310350780261,-0.20060733997452143},
{-7.965376453282913e-05,0.8338374519746407,-0.18155330701651096},
{-0.053261728417426234,0.8692687251614786,-0.14113075311968362},
{-0.04970847787783191,0.8847471299336717,-0.12647392764454493},
{-0.09023439518816671,0.8700785828343207,-0.09559011185093502},
{-0.11557441553051273,0.8362467785513458,-0.06253886118027165},
{-0.12608658124444222,0.7960272218738296,-0.08919223623548315},
{-0.14589026535093214,0.7891029387710302,-0.13249031767200017},
{-0.12385947264412671,0.7828467882483258,-0.15905258373901696},
{-0.15270425862591663,0.7490858465117245,-0.17993359167082693},
{-0.112856597116587,0.7437002929873252,-0.21869860134383093},
{-0.055861264987028966,0.7414731843870098,-0.21865011644368051},
{-7.965376453282913e-05,0.739590265297652,-0.20638503510892853},
{0.05570195745796331,0.7414731843870098,-0.21865011644368051},
{0.05526985576541406,0.7822191485518732,-0.19552175346973397},
{0.05438540593849449,0.8230562217049314,-0.167915730046732},
{0.05310242088836058,0.8692687251614786,-0.14113075311968362},
{-7.965376453282913e-05,0.8733686296302413,-0.15367821903772924},
{-7.965376453282913e-05,0.8898897261562184,-0.1374155310455209},
{-7.965376453282913e-05,0.8858404377920084,-0.12048844008092183},
{-0.0437554911813426,0.8814672063586614,-0.11117720804764095},
{-0.07707953601548961,0.868347512058621,-0.08416632345395772},
{-0.10498339525370125,0.8513405009289389,-0.05492513345335566},
{-0.10125005794211969,0.8324505707098989,-0.0163993514745004},
{-0.10764686795537046,0.8149981378601536,-0.019472015421395046},
{-0.12457928693097509,0.7749000598335637,-0.05064407661040464},
{0.3317616588868826,0.5139234247602263,-0.1669593520712376},
{0.3790328381302304,0.48756255750921873,-0.1494461798960292},
{0.34205697455288664,0.47594109990393607,-0.11927525197496046},
{0.2998703162121252,0.5003684319610331,-0.12371295234147435},
{0.3336749476389719,0.482804643681272,-0.0514416798579339},
{0.38458942080790764,0.4609486097354482,-0.1005195876332602},
{0.41416148029195365,0.4591264299715538,-0.12811442223315053},
{0.43861172279637456,0.47392657894274154,-0.14374094571129747},
{0.41421476040200905,0.5124656809491106,-0.15990133589219943},
{0.3677646276546149,0.5422886897515176,-0.17717048516335415},
{0.32228419291022886,0.5720509592284615,-0.1787955285200437},
{0.2965344485215568,0.5397072684193337,-0.17466845119515276},
{0.2669543970210025,0.5210704187230568,-0.12875751316151918},
{0.28869214912250324,0.513397017272879,-0.0570339602093482},
{-0.5644945076198549,0.40970486548637025,0.07258748993671922},
{-0.5716921176872383,0.42887824589090473,0.05158020814407795},
{-0.5618027964598564,0.43668324921291957,0.06814446155919981},
{-0.6064046421894289,0.4014038243397395,0.09274655237727861},
{-0.6187517748936662,0.42877701368179955,0.09155361071313829},
{-0.5739597191711959,0.4658684950979635,0.06820093847585852},
{-0.5339223804700691,0.4509671139176705,0.05292499812187613},
{-0.541229214763066,0.44333420535113455,0.03906790709866891},
{-0.7211279079618067,0.3791833544411369,0.08369532728106804},
{-0.7363889298849735,0.3686045885896383,0.10183347514722627},
{-0.7351720121713083,0.38172428288967875,0.10006723949888992},
{-0.7237562157908394,0.39828587229929774,0.0856778801762293},
{-0.7280473958547009,0.3835262162117523,0.10915895747874257},
{-0.7270776978516926,0.37053812378354845,0.11227531111588264},
{0.5616434889307907,0.43668324921291957,0.06814446155919981},
{0.5410699072340003,0.44333420535113455,0.03906790709866891},
{0.5715328101581726,0.42887824589090473,0.05158020814407795},
{0.5643352000907892,0.40970486548637025,0.07258748993671922},
{0.5731008437971029,0.40487608911204964,0.055413712062563646},
{0.5994984743240486,0.38655305926399935,0.0665604438872529},
{0.5930601058249546,0.39286994911216694,0.0867424167751361},
{0.6155192706166053,0.394550403783314,0.0743718408224744},
{0.6062453346603633,0.4014038243397395,0.09274655237727861},
{0.6305794265248634,0.38154206491328935,0.08495273787837537},
{0.6266073943202337,0.39054160830274603,0.09808948181363364},
{0.6282297736714205,0.3702749200398749,0.08889706442577629},
{0.62784455847572,0.3753972698206006,0.0962768924695491},
{0.63578915568608,0.36894931090169664,0.10127296838944351},
{0.6391601882492849,0.3629659545424758,0.09652357937910556},
{0.6470179388802546,0.3811978754023314,0.10719984783200569},
{0.6560302694961246,0.37624762037708454,0.09980456855631681},
{0.6629961110847671,0.3934267262622458,0.11873712286340099},
{0.6699566246624039,0.3839311450481731,0.10317293711401891},
{0.6891699651494799,0.38966088808353055,0.09795574873739461},
{0.7020749406059973,0.3827062353179997,0.10598612692494377},
{0.6693007465076221,0.4032867434290972,0.12053479377667004},
{0.7064481720393442,0.3969091142554665,0.10238652268960127},
{0.7278880883256352,0.3835262162117523,0.10915895747874257},
{0.726918390322627,0.37053812378354845,0.11227531111588264},
{0.7350127046422427,0.38172428288967875,0.10006723949888992},
{0.7362296223559078,0.3686045885896383,0.10183347514722627},
{0.720968600432741,0.3791833544411369,0.08369532728106804},
{0.7235969082617737,0.39828587229929774,0.0856778801762293},
{0.73627011523955,0.3907845656045988,0.06267525826201348},
{0.7290149626533068,0.3731499147784639,0.06880513492388671},
{0.7494766561189808,0.37044701479535375,0.06776883678330926},
{0.7467668297215635,0.36009095980388656,0.07418163082957664},
{0.746663466308056,0.3553229227550293,0.06035863907680488},
{0.7509994016643641,0.36666093017481743,0.05759926217703597},
{0.7278699730882163,0.3642414803772019,0.04039245063464604},
{0.7364198323488057,0.3768853832944478,0.03815521881341999},
{0.7251265802214641,0.3576006474598974,0.0022289734041674707},
{0.7092277953809342,0.35938233434014993,0.02155526772456102},
{0.7034405098267171,0.3490971418950564,-0.000800000852481755},
{0.697693717156142,0.3491781276623406,0.016037046726123726},
{0.6904859838678482,0.34363060260337275,-0.003661675563557035},
{0.6832862425960627,0.34319530410422017,0.006826514100847533},
{0.6799200052427629,0.3499272460097193,-0.011797015567915346},
{0.6708469353014296,0.3512432647280877,-0.0033505197208335293},
{0.6710238252668135,0.36013145268752866,-0.008266675475644856},
{0.6851174799786666,0.3572767043907607,-0.016736614571151047},
{0.6739989866123067,0.3666508069539069,-0.029184446683393064},
{0.6626204863088765,0.3637758122153177,-0.017143141810873716},
{0.6606587126566368,0.359038144829192,-0.034579057826501836},
{0.6537195111230222,0.35858259988821833,-0.019781040059716336},
{0.6280134564245956,0.3708418204108643,-0.04694164176265521},
{0.6378825312101564,0.37426346907862185,-0.06213553074715231},
{0.6170782466368263,0.3821393349470103,-0.05616762561984748},
{0.6419600580326958,0.3983162419620293,-0.07396851038935506},
{0.6113644876344856,0.41041349095010693,-0.0948660351552822},
{0.5908894741412978,0.3949047165151825,-0.08144370983012701},
{0.583090331631389,0.3927079775775984,-0.10423001449751794},
{0.5738984470446321,0.38978236673445676,-0.0903500130269869},
{0.5521628261475336,0.39910585319305036,-0.10432005788351155},
{0.5448298846006097,0.41869428565491645,-0.1310181882311696},
{0.5318780226472436,0.42272332757730546,-0.11873765566450153},
{0.5364345376591809,0.44328358924658195,-0.12610736048736382},
{0.5531064168966147,0.4425243476782927,-0.13622205658028008},
{0.5371362367086105,0.4686625040692683,-0.12923330454431387},
{0.5582308978817427,0.47165897745878377,-0.1386031446986557},
{0.5400799627891711,0.5016135881330278,-0.13191808929000523},
{0.5264370578083866,0.49289749492906565,-0.1301028359404179},
{0.5114365756233906,0.528338891336814,-0.11809190073063014},
{0.5358505876529739,0.5347266437313553,-0.1130057814247421},
{0.5275868425833821,0.5508124417581797,-0.0823787757615992},
{0.488984337246047,0.5482006507632642,-0.06881579094589776},
{0.5117402722507063,0.5601359282167735,-0.06006027046049465},
{0.4857182664996512,0.5398186238493494,-0.052297891226524104},
{0.502133335606618,0.5540417492286372,-0.04405705660425612},
{0.49247578285797705,0.5399907186048283,-0.023432326001812585},
{0.4848801703684799,0.5216271958731359,-0.03324439106961418},
{0.4982992988870317,0.5314872130399874,-0.0029674357295352343},
{0.4874871661534904,0.5107244869525002,-0.008938004862342835},
{0.4890173709142814,0.5207161059911886,0.008932676851337314},
{0.47985319198475335,0.49473992113478105,0.013751330004747264},
{0.4822033776392968,0.49136888857157635,-0.0028155874158773573},
{0.474738834220536,0.46584824865614244,0.017903981782464776},
{0.4810972825545468,0.4598553018771115,0.0009204139012069616},
{0.52014041440204,0.4333122166497148,0.025643450569111503},
{0.5120743385407537,0.4396189832769719,0.0428944846028474},
{0.5337630729410034,0.4509671139176705,0.05292499812187613},
{0.5738004116421302,0.4658684950979635,0.06820093847585852},
{0.6185924673646005,0.42877701368179955,0.09155361071313829},
{-0.27085556667925853,-0.7211660032404963,-0.04741476913994712},
{-0.21319849558281248,-0.6396351804304288,-0.1224859114068986},
{-0.19783038063843428,-0.7348350154752079,-0.10440317485519797},
{-0.2571274135223854,-0.8242230561151447,-0.04520630857815099},
{-0.1958302453069547,-0.8094697936408057,-0.10320117557234826},
{-0.17673785066970435,-0.7357322525285408,-0.10299071913762944},
{-0.15317525479880634,-0.645860428489301,-0.11567191813191409},
{-0.1536894078608409,-0.5802385137406739,-0.11543642004546925},
{-0.21537392247637427,-0.5784589580648237,-0.11907438596005164},
{-0.26790331578108906,-0.567810928070253,-0.09895688200533546},
{-0.28075181432094765,-0.6405968864169287,-0.0648767924095024},
{-0.2885173903615215,-0.6212961665493616,-0.020079408676026554},
{-0.25631222783853785,-0.7219188511955791,0.009487855598114533},
{-0.25546134448095315,-0.8152703992225366,0.0031880153851645884},
{-0.2543680366226165,-0.8622629234902948,0.017096255314024988},
{-0.2528666031212554,-0.9128044358888427,-0.04374057275052707},
{-0.19485255528743822,-0.8632763111835484,-0.10755735737047738},
{-0.1769850703803614,-0.8095981987060392,-0.10138432381945928},
{-0.12923064053881111,-0.7374297568349056,-0.046401914247794065},
{-0.11488497090639592,-0.68370688906495,-0.060160969868499344},
{-0.10123194270470086,-0.6313709025597364,-0.0695201540008301},
{-0.10569308631963913,-0.5855995584144478,-0.08821614461926831},
{-0.12359200649164861,-0.499982683964232,-0.08392496455540677},
{-0.16245398596495345,-0.5082086001556845,-0.10503774096595773},
{-0.20885883061880053,-0.506442364507348,-0.10620297697286923},
{-0.25022018005480395,-0.4910428142980372,-0.0861185066863874},
{-0.2804593065167435,-0.5256386553592065,-0.04730661051653468},
{-0.011563115884772185,0.30469669498149315,0.1619275784776061},
{-0.015458424730922137,0.28008714494800657,0.16072930880246025},
{-7.965376453282913e-05,0.28203080336282743,0.15289500141991494},
{-7.965376453282913e-05,0.32597570533541703,0.15138557590204557},
{0.011403808355706526,0.30469669498149315,0.1619275784776061},
{0.015299117201856479,0.28008714494800657,0.16072930880246025},
{-7.965376453282913e-05,0.2505374631101839,0.1531640659756947},
{-0.016363653800763305,0.24842170993988416,0.1556714279549016},
{-0.04999352646662828,0.24406872494835824,0.14286875030969065},
{-0.046463186374357784,0.30314784218218277,0.1435448749062936},
{-0.02134427848874166,0.3179783608161021,0.15293549430355705},
{-0.007716291938772642,0.3294074772240849,0.15994236157694208},
{-7.965376453282913e-05,0.332474813159974,0.15588508119622374},
{0.007556984409706984,0.3294074772240849,0.15994236157694208},
{0.021184970959676003,0.3179783608161021,0.15293549430355705},
{0.04630387884529213,0.30314784218218277,0.1435448749062936},
{0.049834218937562624,0.24406872494835824,0.14286875030969065},
{0.016204346271697645,0.24842170993988416,0.1556714279549016},
{0.013229184926204372,0.20233068513426328,0.1541406903930101},
{-7.965376453282913e-05,0.20075146267222138,0.15370166228615362},
{-0.01338849245527003,0.20233068513426328,0.1541406903930101},
{-0.048779805559566375,0.2091436128070466,0.15071904172525258},
{-0.10556148444780229,0.24231740773083751,0.12585214876019848},
{-0.08883312829370982,0.30691368036089806,0.11969882884990088},
{-0.08499429636421858,0.363684703227123,0.13235765019796225},
{-0.042066511692586565,0.35900777516646043,0.14520295193121752},
{-0.008824518227924865,0.36194350923051277,0.15571724884954924},
{-7.965376453282913e-05,0.3619840021141549,0.14927355233944972},
{0.008665210698859206,0.36194350923051277,0.15571724884954924},
{0.04190720416352091,0.35900777516646043,0.14520295193121752},
{0.08483498883515292,0.363684703227123,0.13235765019796225},
{0.08867382076464415,0.30691368036089806,0.11969882884990088},
{0.10540217691873664,0.24231740773083751,0.12585214876019848},
{0.04862049803050072,0.2091436128070466,0.15071904172525258},
{0.013697517093591296,0.2017739079841844,0.16376627507561778},
{-7.698975903005936e-05,0.1998100031275425,0.16858972343893275},
{-0.013856824622656952,0.2017739079841844,0.16376627507561778},
{-0.018012140405877234,0.19549751101965865,0.16815442493978017},
{-0.030338493867192947,0.18258028113782865,0.1684016446504372},
{-0.05852793449530151,0.1781058174953767,0.15133868940519685},
{-0.08420202112769486,0.19409038331309583,0.13690297638678806},
{-0.12389090790905939,0.17622289840601896,0.11335050373680051},
{-0.1562708291930248,0.20310004992346306,0.08329679205785369},
{-0.1390048767284734,0.25845382186221444,0.08625117416042535},
{-0.12026253241428696,0.3135848829409341,0.08768121231431215},
{-0.12567419319261347,0.37593380052885844,0.09214768394025596},
{-0.11781697536274433,0.4403073622988875,0.1236047937180619},
{-0.08200368378680925,0.43216829268682533,0.1420050797256927},
{-0.05305073918160686,0.42319911896010015,0.15243412846793578},
{-0.015479203973843742,0.41849182123670603,0.15550466121042822},
{-7.965376453282913e-05,0.41622421975274826,0.1475254319285322},
{0.015319896444778084,0.41849182123670603,0.15550466121042822},
{0.052891431652541204,0.42319911896010015,0.15243412846793578},
{0.08184437625774359,0.43216829268682533,0.1420050797256927},
{0.11765766783367866,0.4403073622988875,0.1236047937180619},
{0.12551488566354782,0.37593380052885844,0.09214768394025596},
{0.12010322488522131,0.3135848829409341,0.08768121231431215},
{0.13884556919940771,0.25845382186221444,0.08625117416042535},
{0.15611152166395914,0.20310004992346306,0.08329679205785369},
{0.12373160037999373,0.17622289840601896,0.11335050373680051},
{0.08404271359862919,0.19409038331309583,0.13690297638678806},
{0.05836862696623585,0.1781058174953767,0.15133868940519685},
{0.030179186338127287,0.18258028113782865,0.1684016446504372},
{0.017852832876811577,0.19549751101965865,0.16815442493978017},
{-0.1807546381667806,0.8170227820422586,-0.11965194235305211},
{-0.15022300390063686,0.8322278598498672,-0.117142449169443},
{-0.17572979098745628,0.8045307274386705,-0.1368443682657271},
{-0.2103320256618322,0.7917957155332301,-0.1092362136383229},
{-0.20356438608259592,0.7838894800021099,-0.12711914977731575},
{-0.18561165299943044,0.7800224096142894,-0.13144656031601498},
{-0.16401828999617984,0.7833731957356731,-0.13400293999647284},
{-0.13320800075444636,0.8083370585010281,-0.13817530541491085},
{-0.14197684126736332,0.8260122022108048,-0.1353653124105893},
{-0.12019753068001938,0.8394457163590716,-0.10434563233633815},
{-0.14734534515654496,0.8241191599005369,-0.10214729499545254},
{-0.17286598507197876,0.8068185753644493,-0.10272005617854803},
{-0.20944171502280656,0.7816421249599733,-0.09390059956107845},
{-0.15575880733539244,0.789578730153825,-0.10958359995588406},
{-0.14162465973989719,0.8105844135431646,-0.10031552481174805},
{-0.128454349335304,0.7988414772869554,-0.12063709158797636},
{-0.13130110561556377,0.749480652127235,0.013569112028357814},
{-0.15137705108443672,0.7219758609133384,0.010627517152199437},
{-0.14859050132853954,0.7253367702556326,0.019094792242202865},
{-0.12329150667093619,0.7418882364443411,0.02425283969666568},
{-0.13885462681811717,0.720001832835786,0.02692164040934044},
{-0.11510874736862858,0.7303882574899847,0.02278443986353899},
{-0.1326501580021664,0.7129560710820604,0.025844316584020345},
{-0.11367444680593734,0.7232007706435118,0.01148639252629241},
{-0.13473341030533234,0.7048372479118192,0.017379705499519685},
{0.08823905506659213,-0.2803753903434063,0.15388974107464917},
{0.1321264145203218,-0.2040495014846503,0.16709255234637613},
{0.08237930856269976,-0.206929824234245,0.16166224352953024},
{0.04479178932192001,-0.20576938343723847,0.10624560106091356},
{0.036296275773587225,-0.11435776421739771,0.10937527472556748},
{0.04534217285879224,-0.10038452255426981,0.1380500971562807},
{0.07396851038935504,-0.11801118136389624,0.16096800369550843},
{0.12767219731969076,-0.11055782676824696,0.1706234252397472},
{0.18330036182522738,-0.19856271575114562,0.15360629088915448},
{0.17934804326131815,-0.2875703364052869,0.14020740881242363},
{0.13158082619335457,-0.28461595430271514,0.15874888711170124},
{0.11647484939044889,-0.3468263436044953,0.13661259978698614},
{0.06241312012054091,-0.28951186361570547,0.10290547096154083},
{0.05913959015873742,-0.28418704941676926,0.0621195467141357},
{0.03842534897140082,-0.20535539698210803,0.06116316873864135},
{0.019863091429201642,-0.1262061950915165,0.052443878728075904},
{0.046561221776859694,-0.10396707715439457,0.10661110261589357},
{0.0674582137416863,-0.04401683012116428,0.13218289143698056},
{0.0669952095853049,-0.0513710837121105,0.1480550362224828},
{0.12601198909036465,-0.0317309695434907,0.16477859716667032},
{0.1866431559301029,-0.10065305430894891,0.15790066775961933},
{0.1888771909447256,-0.195278529767331,0.14534787383056819},
{0.19538535638799215,-0.24185280517115434,0.10857554027363599},
{0.1987436017247837,-0.2843410289348293,0.10497540323719294},
{0.21355387391688196,-0.3482196184824439,0.09348448190154582},
{0.17414417491220768,-0.36160624613386194,0.1345069698375969},
{0.13803730992986737,-0.3330822064146056,0.15362653733097553},
{0.13285635202808074,-0.3707730890688928,0.13065801468719515},
{0.10370041020356731,-0.37711608617098763,0.10456674479306804},
{0.09287282623810987,-0.3559233895953536,0.1106119060799532},
{0.08219655778520975,-0.36057154639658623,0.06412287885221857},
{0.10064586149409148,-0.3589187973826679,0.016756861012972114},
{0.06409730439939196,-0.27677365490366157,0.0020696658751018387},
{0.048545905876423164,-0.19869325202078136,-0.006063010123753705},
{0.02953929221636199,-0.13095771530625666,-0.016171312603463307},
{0.04081442910628475,-0.11742723135768911,-0.007142997954576569},
{0.03638631915958084,-0.1141957926828294,0.04559152377385152},
{0.18351614627095172,0.16398392432519407,0.08617445080194558},
{0.21115733456659028,0.07391816068535262,0.059448081995958184},
{0.19058694967640322,0.1638017063488047,0.03497706024861565},
{0.1709063426241413,0.1656846254381622,0.08582972848988717},
{0.18261890921761886,0.16661596176193058,0.03223633138736612},
{0.1874215783380122,0.15660409628142136,-0.03414695613395258},
{0.20996492570355052,0.06960513577636838,-0.027106522391232644},
{0.22427436486112806,-0.00594659308328266,-0.021326696052423356},
{0.2282517250767633,-0.007381959248174997,0.05982104276634594},
{0.1960870554374217,0.057771623333065174,0.12507532475559083},
{0.17642669482698084,0.12722650919907752,0.11686006458614942},
{0.15718032067167037,0.12354165678764618,0.11284114588467095},
{0.17687744455804946,0.04950041904806555,0.12563103630346859},
{0.2070483724791182,-0.006265208141413976,0.13259847629541266},
{0.18922138045568346,-0.012173972346557224,0.13429331659627475},
{0.20877464804491297,-0.10154176654467291,0.14246968228537574},
{0.18871202260355388,-0.10452012469676951,0.13984297285964475},
{0.19773021403153007,-0.18953493390335951,0.1430126066068402},
{0.2058298563621513,-0.2361054796994788,0.10588862432354242},
{0.21054301489765156,-0.28223699738874175,0.09980989656732235},
{0.21970133301507347,-0.342794104875503,0.052906882884457294},
{0.20596305663728978,-0.36228450193486716,0.09228354822089721},
{0.21776779782116318,-0.354264779769329,0.04660704267150735},
{0.2052080774778048,-0.35245165762414404,0.0171527322306837},
{0.20518463422938046,-0.34563819715026006,0.023362529057640028},
{0.1872260403341089,-0.3524447312098368,0.003573763381965648},
{0.18273133024983576,-0.3388055558367561,0.00248365233023226},
{0.13725622351645528,-0.35447363780074626,-0.00788625548984933},
{0.13518895524630595,-0.3439593408824145,-0.005561644288132432},
{0.10654237127392209,-0.36749369829498313,0.01772123100497477},
{0.09185464333495126,-0.37329750068331735,0.057751110490693834},
{0.08653462434592003,0.1587400958935421,0.13449151860568084},
{0.08901055106019426,0.12860326724290877,0.13168365680576152},
{0.11931041684759702,0.13610457393760797,0.11548170813901633},
{-0.04248529335762197,0.14162172933384423,0.15282999968564734},
{-0.08916985858925991,0.12860326724290877,0.13168365680576152},
{-0.034493809650413224,0.11054344113853201,0.15196366509614662},
{-0.017549136249495847,0.13508212862564495,0.161965940156846},
{-7.43257535272896e-05,0.10355841871026959,0.15818624914951623},
{-0.029721510192751467,0.076306708019136,0.1543857788992649},
{-0.09100322717626606,0.11028023739485848,0.12294625155777722},
{-0.11946972437666269,0.13610457393760797,0.11548170813901633},
{-0.08669393187498568,0.1587400958935421,0.13449151860568084},
{0.7039083091930035,0.30174071447561973,0.14960282341959208},
{0.6990379743328398,0.2971042792985992,0.16128502035033804},
{0.6822909701402279,0.2893397688602265,0.14680242083508047},
{0.6960505585620338,0.29251846022613137,0.12017941544260055},
{0.6745253940996541,0.2947961849309996,0.12911555550109144},
{0.6679181276516845,0.29882575965448904,0.10816688182951112},
{0.7034453050366221,0.29806598528509914,0.09407589112316071},
{0.674060791539971,0.30518260958519833,0.08740841815082855},
{0.6490777479349961,0.3201346068700439,0.07128159443926149},
{0.6636956789297944,0.3199321424518335,0.047841542821490855},
{0.6327836246778552,0.3382146794162417,0.03869761033378391},
{0.6512046899284075,0.3394800820300575,0.011424054797527597},
{0.6765186030168264,0.3238599521651171,0.025545415166609575},
{0.6904726638403345,0.3094141159257978,0.06016043706739881},
{0.706392227923786,0.3072173769882139,0.038584656500466476},
{0.7106519727227149,0.30346166203040914,0.06863783537831276},
{0.74089642719566,0.29407743624635224,0.05082949139339743},
{0.7339529632532409,0.29441150253639964,0.07429671586729629},
{0.7706240646010678,0.2814335333291065,0.05744741386337808},
{0.7631419387459886,0.2844401299395325,0.08564484650799495},
{0.781858175806248,0.2831038647793431,0.06512188091575723},
{0.7772904719711989,0.28452111570681665,0.0845302266056361},
{0.8094173127324011,0.2696197345265237,0.07725536037867241},
{0.8056312281118647,0.27295027420608636,0.09387449230715132},
{0.8263982166081562,0.2605594518116036,0.08589366462195365},
{0.8231412034804698,0.26290803906284554,0.09816087716110787},
{0.8391614669719261,0.25344282751150443,0.09280622610054064},
{0.8366557033960209,0.25607486494824094,0.10348249455344076},
{0.8453243773020337,0.2508816526211416,0.09731052660462376},
{0.8427541447929615,0.2535136900578781,0.10494609917666246},
{-7.965376453282913e-05,0.36533478823553855,-0.1077630185952912},
{-7.965376453282913e-05,0.41926118602590584,-0.14438883184957108},
{0.029142888197549847,0.36531454179371753,-0.12356430083441979},
{0.02284091678019769,0.3065998605126719,-0.11113191995409386},
{0.0777018477009366,0.3170672709341548,-0.09434335727563878},
{0.09071018657096136,0.3679162095677224,-0.11876589412283091},
{0.031038061712220257,0.4190587216076954,-0.16043413699275338},
{0.03306430429762694,0.4744226167673573,-0.19094232801047273},
{-7.965376453282913e-05,0.4756677729393518,-0.18024314911024877},
{-0.0332236118266926,0.4744226167673573,-0.19094232801047273},
{-0.031197369241285917,0.4190587216076954,-0.16043413699275338},
{-0.029302195726615507,0.36531454179371753,-0.12356430083441979},
{-0.023000224309263347,0.3065998605126719,-0.11113191995409386},
{-7.965376453282913e-05,0.3083410545092822,-0.09629713891137014},
{-7.965376453282913e-05,0.2579071679330461,-0.10204712838854839},
{0.06947912831608744,0.26954887198015004,-0.09939910691879525},
{0.12366659864572614,0.2810184812717749,-0.08141227456519433},
{0.1177162759547396,0.32200740273849116,-0.0691706364788667},
{0.1313804929795463,0.3727753556047746,-0.0910442528610087},
{0.09424319066873463,0.4189676126195007,-0.15315660676028692},
{0.09344878422780868,0.4726814227707468,-0.18714185776022138},
{0.034046789527048434,0.5254740198191353,-0.20934208121700296},
{-7.965376453282913e-05,0.5281161804767823,-0.19259028181448612},
{-0.03420609705611409,0.5254740198191353,-0.20934208121700296},
{-0.09360809175687435,0.4726814227707468,-0.18714185776022138},
{-0.09440249819780029,0.4189676126195007,-0.15315660676028692},
{-0.09086949410002702,0.3679162095677224,-0.11876589412283091},
{-0.07786115523000225,0.3170672709341548,-0.09434335727563878},
{-0.0696384358451531,0.26954887198015004,-0.09939910691879525},
{0.21119090103592517,0.5267495456538617,-0.1843643656230336},
{0.21355866912678692,0.4889291923321397,-0.11024427332057098},
{0.1694070403271825,0.4707985036813893,-0.16238259061747917},
{0.15747922208908113,0.5200479734110938,-0.2106074838308186},
{0.15631718288877294,0.42143767852166863,-0.13165861515403546},
{0.1904564134067675,0.431662131641299,-0.07638796018697055},
{0.21346329772978778,0.4905995237823763,-0.04869562298567883},
{0.22561862203782568,0.5288754220450719,-0.0689750984749634},
{0.24008257351456383,0.5334005017920764,-0.1353711732226954},
{0.24163036071167307,0.5505391147935955,-0.16801909346023944},
{0.2481641006077662,0.5830346539163811,-0.19079847171332318},
{0.19893860692758644,0.5832168718927705,-0.21346169932648612},
{0.15277885077999415,0.5822855355690023,-0.21759570306568424},
{0.09191644826261552,0.5240668921125723,-0.21335833591297865},
{0.08672749834432056,0.581313706361592,-0.2291462981245934},
{0.023221336765993212,0.5837129097173862,-0.22517906112986866},
{-7.965376453282913e-05,0.587002956513307,-0.2089099795244537},
{-0.02338064429505887,0.5837129097173862,-0.22517906112986866},
{-0.08688680587338622,0.581313706361592,-0.2291462981245934},
{-0.09207575579168119,0.5240668921125723,-0.21335833591297865},
{-0.15763852961814678,0.5200479734110938,-0.2106074838308186},
{-0.16956634785624816,0.4707985036813893,-0.16238259061747917},
{-0.15647649041783862,0.42143767852166863,-0.13165861515403546},
{-0.13153980050861194,0.3727753556047746,-0.0910442528610087},
{-0.11787558348380527,0.32200740273849116,-0.0691706364788667},
{-0.1238259061747918,0.2810184812717749,-0.08141227456519433},
{-0.13238801986069385,0.23399612014238566,-0.09418458254767371},
{-0.0632176497823774,0.2215648048642609,-0.11748024506719422},
{-7.965376453282913e-05,0.21639183897898256,-0.1173182735326258},
{0.06305834225331174,0.2215648048642609,-0.11748024506719422},
{0.13222871233162817,0.23399612014238566,-0.09418458254767371},
{0.16786937635098378,0.23288256584222794,-0.03153729634343932},
{0.15447528948415795,0.2802491164825751,-0.028567463008951584},
{0.13984030885414195,0.3262591555209116,-0.02134214728433942},
{0.15893696590019674,0.3791934776620474,-0.022959198624520675},
{0.2611335449974505,-0.4518611541644,-0.03803214175919201},
{0.20007027646516304,-0.3740711278813217,-0.037882957451036904},
{0.2288324782763671,-0.38180633425916405,-0.007937937196603063},
{0.26146281607759286,-0.4506351788320254,0.0171862987000186},
{0.24541431412780723,-0.390679070986689,0.031745088772655375},
{0.21242486838480812,-0.3600089084344013,0.00937969697470208},
{0.19015964319375897,-0.3624518014804411,-0.002080321897112902},
{0.14476125981885826,-0.3773164193847959,-0.044460387037375454},
{0.14647634656154146,-0.43947193017321895,-0.07908766336347743},
{0.21521461494730862,-0.4333122166497147,-0.07093953613270583},
{0.2500608725257383,-0.4910428142980372,-0.0861185066863874},
{0.2802999989876779,-0.5256386553592065,-0.04730661051653468},
{0.27814961374584213,-0.5401596165537039,0.013746001993741725},
{0.24250202331217935,-0.5112397056167359,0.10266411206298988},
{0.24078906777389836,-0.4717031999501298,0.10169707806548445},
{0.24283608960222666,-0.44666154822409404,0.07718769463890206},
{0.2376114420101946,-0.40147149007950994,0.07333820668739974},
{0.22845685350047656,-0.371841888076604,0.06871029632798811},
{0.23058379549388794,-0.3628524679080577,0.03449114564491045},
{0.14121813250017448,-0.3708444844163669,-0.01370018109909407},
{0.10002354980864446,-0.37595085016407603,0.01008192882523219},
{0.1111058127001667,-0.46258324351194774,-0.0539410498206325},
{0.12343269896258297,-0.499982683964232,-0.08392496455540677},
{0.16229467843588777,-0.5082086001556845,-0.10503774096595773},
{0.20869952308973486,-0.506442364507348,-0.10620297697286923},
{0.26774400825202344,-0.567810928070253,-0.09895688200533546},
{0.2883580828324559,-0.6212961665493616,-0.020079408676026554},
{0.26210750540926314,-0.6356801978610166,0.04442682056804057},
{0.20228459783906527,-0.5515988561825973,0.10543840739357431},
{0.2168140838511716,-0.513343204361723,0.10776035458978844},
{0.21866290367009378,-0.4696028980117461,0.10173064453481935},
{0.21954735349701338,-0.44912735171745766,0.0902679616575016},
{0.2168140838511716,-0.40660609428554834,0.08488613774080614},
{0.21598611094091075,-0.3706830456828991,0.07894380706632788},
{-0.10531053512944137,0.6663487620100027,0.08970532369531663},
{-0.07238182871190539,0.6337216210153804,0.10977167874437961},
{-0.09320955653365999,0.6755811394804017,0.07626754713824538},
{-0.1361549236416103,0.6972853251125677,0.047615635154855986},
{-0.08982840074954461,0.6838416877433902,0.07867154570394481},
{-0.045750831302917155,0.6551119867993198,0.10474470036065306},
{-0.04610354563148387,0.6418708138483532,0.10049188197603141},
{-0.04266538012960921,0.6192251686715086,0.11865240748841292},
{-0.04915276632995415,0.601155219346221,0.13072195081926163},
{-0.09309873390474475,0.5908700269011274,0.135396747675522},
{-0.11782976258915762,0.6181217375922611,0.11874511487990931},
{-0.14655626672662456,0.6470437797336315,0.09434655408224213},
{-0.17801337650443053,0.6726251589745285,0.06078328155394638},
{-0.17987498354976603,0.7209534156013754,0.017713771789567016},
{-0.1317300105015097,0.7083095126841294,0.050672847869834566},
{-0.12443010262281998,0.7144239381140866,0.04293604308869061},
{-0.08149698994018244,0.6904217813352315,0.06933047680903291},
{-0.03838965129766373,0.6614288766474876,0.09391711639519564},
{-0.01606262117895032,0.636181563696638,0.09556773420471178},
{-0.02797818499173893,0.6279311386545601,0.10905133165643068},
{-0.02356819028245386,0.6368699427185537,0.12291854590054842},
{-0.03944885988556499,0.6222520117237553,0.12803503486916804},
{-0.04624473792313067,0.6042832946075732,0.1345373395003285},
{-0.045977271770652584,0.5856970610158492,0.14037417555689702},
{-0.07879195875267002,0.5718586180311613,0.13969325575038907},
{-0.11187251348386387,0.5498304893298587,0.13357030550282306},
{-0.13094839128699706,0.5582732555692368,0.12018207944810332},
{-0.16524213412415226,0.5837534026010286,0.09466197233377005},
{-0.18847066370500296,0.6142850368671722,0.07735446138337543},
{-0.2083132422918333,0.6424680838820741,0.05762057422105812},
{-0.21144824396749276,0.6846009293116796,0.034931239353968024},
{-0.6577171177804785,0.33569399740952094,0.13065481788059183},
{-0.6783311923609109,0.3257125015917433,0.1579773911180991},
{-0.6622475255384888,0.3221693742730595,0.1464667561417315},
{-0.6526597697340204,0.32099508064743865,0.11903815548521399},
{-0.6598696342267165,0.30767292192918755,0.13892655496669196},
{-0.6685319145195227,0.31007212528498207,0.15440123013118096},
{-0.6808055206718835,0.3134026649645447,0.16891046970146623},
{-0.7017866952105977,0.3277168993320273,0.15295627354647867},
{-0.6959029726571803,0.34299283968600974,0.14183191936801265},
{-0.680627032303198,0.3503929141716035,0.13560720411024083},
{-0.6672494622704892,0.3593215950146866,0.12094078821529214},
{-0.6531760540004571,0.3514457291462981,0.11133704837780714},
{-0.6440688847886884,0.3327785097872899,0.09715654708656367},
{-0.6680774351807501,0.29882575965448904,0.10816688182951112},
{-0.6746847016287197,0.2947961849309996,0.12911555550109144},
{-0.6685265865085172,0.29902769127159906,0.1489032555745647},
{-0.6670203577972511,0.3013155391973779,0.16419731116596595},
{-0.682473720917718,0.303613510344067,0.1772706517702583},
{-0.6991972818619054,0.2971042792985992,0.16128502035033804},
{-0.7040676167220691,0.30174071447561973,0.14960282341959208},
{-0.7183584078411273,0.3024797096020882,0.15273995629965376},
{-0.7240082307114014,0.32876971430672186,0.1546713602891618},
{-0.72944120353375,0.3433066595342359,0.15506403470027008},
{-0.7069628579024793,0.3536019752002399,0.14371696966177253},
{-0.6913699008936672,0.3625407792642337,0.13328792091952946},
{-0.6807303957167055,0.35822828715634986,0.1344318448824188},
{-0.6697253889847635,0.3668431481512068,0.1252836499859074},
{-0.6644975445861281,0.37172254063008003,0.11097207962392767},
{-0.6561895770251903,0.37624762037708454,0.09980456855631681},
{-0.6273527830599086,0.3706494792135644,0.08282366468056178},
{-0.6252002666136708,0.3492894830923563,0.06217389242639221},
{-0.6492370554640617,0.3201346068700439,0.07128159443926149},
{0.1812069863011509,0.7233222492944381,0.026451177037551298},
{0.2112889364384271,0.6846009293116796,0.034931239353968024},
{0.21372863267786366,0.6887210802222633,0.04412632074732815},
{0.2526018009742801,0.7298011106771742,0.03853617160031607},
{0.2488988333254301,0.6511639306442152,0.04846438730803843},
{0.2444478129314024,0.6487647272884207,0.02910239531390777},
{0.26044623157773594,0.6156921645737352,0.03653017545673043},
{0.26366062061737794,0.6155504394809878,0.04861783402499797},
{0.3389560721476626,0.6588879481989458,0.02834635055222171},
{0.32126068199606467,0.6054575882331943,0.032449451827587704},
{0.3148143214804624,0.6038682425502419,0.01895306714945551},
{0.3301568619720141,0.7468283682486775,-0.1253992678247276},
{0.38866215242054203,0.6885287390249635,-0.12162756883390617},
{0.3334714176185602,0.7117817774564396,-0.17482243071321288},
{0.27733016565319013,0.7844057642685466,-0.1548301350171269},
{0.26879629042561753,0.749116216174456,-0.17835277080548337},
{0.24538927247608122,0.6902091936961106,-0.2135512099113792},
{0.3087617009781695,0.6537959680809518,-0.20896485803781076},
{0.35236028223539895,0.6671889893455764,-0.17265765984166215},
{0.40600322984027154,0.6234667982330184,-0.11388490324065612},
{0.38409231738109073,0.6864838484010374,-0.03898319172368082},
{0.3339573322222654,0.7341642188896105,-0.03501062671795054},
{0.3276324503575894,0.7685224306599328,-0.03973390847436134},
{0.3238602185656675,0.7789291017559526,-0.11250388278802029},
{0.27843519513573906,0.7890928155501197,-0.13462738288632206},
{0.23178153236793325,0.7923423694623984,-0.13714486808643953},
{0.2191104565945591,0.7606769344542759,-0.17210141549268382},
{0.18719087546147234,0.7139380235103814,-0.20907141825792155},
{0.19327706243310014,0.6517510774570257,-0.21032190244092167},
{0.25980367345046784,0.615439084050972,-0.20175126393741077},
{0.32881953120962365,0.5974096276093268,-0.18686693239233554},
{0.37266852898411346,0.6127159376260408,-0.15781541958353068},
{0.3871964165929181,0.6167652259902509,-0.11619086640385363},
{0.3896307848213491,0.6123616248941723,-0.04923535050053998},
{0.4075126553581409,0.6213814147254503,-0.047797853131245426},
{0.34700882798143506,0.7141101182658602,-0.019736817568370358},
{0.29383261414064776,0.6975384056353306,0.03440163506001739},
{0.2784538431742585,0.7547346037797975,-0.00013613068119152703},
{0.27796260055954775,0.7693221651118644,-0.007860148235922189},
{0.2517557128266004,0.7845474893612939,-0.052521134887656216},
{0.250473260577567,0.7880703702381567,-0.08173035682222504},
{0.23084326962985774,0.7914211563595406,-0.09792964148346743},
{0.22387742804121535,0.7858027687541992,-0.12114644944010595},
{0.207989832023797,0.7563441959045711,-0.16050020432922205},
{0.18115530459439716,0.7020128692777828,-0.19633161114257597},
{-0.15319550124062736,0.7694638902046116,-0.14978770540148428},
{-0.13174333052902357,0.8005118087371922,-0.1524240052470252},
{-0.14788240866590335,0.8123154843188645,-0.1566533803832225},
{-0.1701060753711093,0.7633595879955649,-0.16119977217424938},
{-0.17524867159365606,0.7712860699685062,-0.18452900116310478},
{-0.14484650799494692,0.816223047590327,-0.18179573151726303},
{-0.12485154829335816,0.8398202755327612,-0.168533246522274},
{-0.1292157221079956,0.8277230265446838,-0.1449877002865937},
{-0.11535383587488339,0.8163040333576113,-0.13949452093988243},
{-0.12234471911525183,0.7954198286191981,-0.166878899105054},
{-0.07278036393511975,0.8979174403382647,-0.01742552639416731},
{-0.07094965935361637,0.9017136481797118,-0.000433966496401189},
{-0.07259015394222199,0.8922281901865496,-0.004900438122344977},
{-0.07392748470461243,0.8904667497481183,-0.014604344566734132},
{-0.07320713761666348,0.8740772550939782,-0.029276621273788894},
{-0.018181571155853393,0.9932073187690377,0.0010157852982061186},
{-0.030549483103012313,0.984076173507744,0.025096263838842593},
{-0.04468895870951312,0.9748134263746135,0.030843056509417533},
{-0.056797396520702266,0.9618354571673204,0.027315380422649808},
{-0.06381438701499784,0.9438363703884067,0.023638520027726977},
{-0.06812901032728375,0.9257259281794772,0.02049339513115699},
{-0.06938109291358553,0.9058945384157586,0.020043711002289452},
{-0.06864582739482109,0.888938143390629,0.025029130900172794},
{-0.07190124211920573,0.8874095370331397,0.005623982016897263},
{-0.07794107539508534,0.8884927216705659,-0.006075797350166998},
{-0.0775505321883793,0.8940098770668021,-0.010583294660853447},
{-0.08110911073897915,0.8931494032894074,-0.020341014016398547},
{-0.08041220689945458,0.8839575187026506,-0.029417813565435692},
{-0.07715679217506992,0.8667784128174896,-0.030454111706013132},
{-0.07057936258873138,0.8492551174213704,-0.0222415155420745},
{-0.06856377602533578,0.8500852215360336,-0.04646585037986054},
{-0.055601790851059193,0.8623241956168585,-0.06626473927644545},
{-0.030238327260288803,0.8766687996470726,-0.09608934648215409},
{-0.023421669979801524,0.8904768729690289,-0.1004188882252555},
{-0.01221366602854856,0.9075851163078162,-0.10394390030652047},
{-0.00015690992411315237,0.9034649653972325,-0.1043125986681038},
{-0.025185774423735666,0.8507229844533966,-0.08022625931536123},
{-9.2440990946124e-05,0.8439303032224343,-0.07814886782430137},
{-0.015224525047778952,0.9969326640641109,0.0006534805498294303},
{0.00043982730850727534,1.0,0.0004989682306687846},
{-0.014448233844271841,0.9917698213997431,0.028012284262174378},
{-0.017515569780160948,0.9893098787184854,0.026826801813441832},
{-0.030225540033875505,0.9767165919057923,0.04692672333183972},
{-0.04336228396913378,0.962928765025657,0.05614737917802644},
{-0.0531024208883606,0.951590757605869,0.05349882490717273},
{-0.060533397837786586,0.9405260771506649,0.046612903483613445},
{-0.064166568542464,0.9239341180783144,0.046895820868007594},
{-0.06734739111277109,0.9046493822437639,0.03936680851607968},
{-0.06599993712947015,0.8852431677582874,0.04573857687760441},
{-0.06892608077371246,0.8717084214009152,0.02434554708816207},
{-0.0698339738490564,0.866383607201979,-0.002390944938735857},
{-0.08289346162473435,0.8794830550601984,-0.017970581920034003},
{-0.08303198991087837,0.8896568920752762,-0.017703115767555924},
{-0.08353868375750519,0.8825301445542665,-0.02655880285986318},
{-0.08019588965262968,0.8666063180620105,-0.02778264698783561},
{-0.07337976517324296,0.8488096957013075,-0.0216421143039513},
{-0.07005242230028352,0.8412375264602346,-0.010135741736388123},
{-0.07376018515903847,0.8381600673034351,-0.00796031484282633},
{-0.07377297238545177,0.8364188733068246,-0.02311797335248575},
{-0.06829098186185215,0.8342423808110617,-0.02439616319271468},
{-0.060085844913321265,0.8370262665614563,-0.03738905083082339},
{-0.04692885453624194,0.8467445586355604,-0.058936592939426366},
{0.05863822432311615,0.7650096730039805,0.012404408822546871},
{0.07488652668560951,0.7826038309464732,-0.029608023558333453},
{0.059849814025775834,0.7653133696312963,0.0010621389939543145},
{0.049291827417198696,0.7279890541341901,0.02131657283151285},
{0.07312775025268091,0.8180249809124006,0.009341868096562747},
{0.0854647597360077,0.8338880680791936,-0.020894061558773547},
{0.08333089132828911,0.7981733447068609,-0.06453153729634344},
{0.0880877395540348,0.8501459608614967,-0.05146672150965994},
{0.0742258533209226,0.8092076554993333,-0.10078971779124106},
{0.07692022848642395,0.868347512058621,-0.08416632345395772},
{0.043596183652276944,0.8814672063586614,-0.11117720804764095},
{0.041979132312095685,0.8061301963425337,-0.13956431788405502},
{-7.965376453282913e-05,0.8066667270507915,-0.15881602005037102},
{-0.04213843984116135,0.8061301963425337,-0.13956431788405502},
{-0.07438516084998827,0.8092076554993333,-0.10078971779124106},
{-0.08824704708310047,0.8501459608614967,-0.05146672150965994},
{-0.08349019885735477,0.7981733447068609,-0.06453153729634344},
{-0.08562406726507336,0.8338880680791936,-0.020894061558773547},
{-0.07504583421467516,0.7826038309464732,-0.029608023558333453},
{-0.07328705778174656,0.8180249809124006,0.009341868096562747},
{-0.058797531852181804,0.7650096730039805,0.012404408822546871},
{-0.0600091215548415,0.7653133696312963,0.0010621389939543145},
{-0.04945113494626436,0.7279890541341901,0.02131657283151285},
{-7.965376453282913e-05,0.6636762316896242,0.06636543868445016},
{-7.965376453282913e-05,0.6350983790592116,0.09837293199912835},
{0.015903313649884662,0.636181563696638,0.09556773420471178},
{0.020004816521948996,0.664000174758761,0.06681032760341271},
{0.03006356849930708,0.6492506418921259,0.08506142930288836},
{0.03759737606113998,0.6731920593455178,0.05999367032292543},
{0.06944076663684756,0.6734451398682809,0.06126919615765159},
{0.07380920286028941,0.7006462344548618,0.040264045569412536},
{0.11570441899904788,0.7016079404413618,0.03299077774575052},
{0.11351513927687168,0.7232007706435118,0.01148639252629241},
{0.1345741027762667,0.7125207725829078,0.021378910560277662},
{0.11039612163422884,0.7569718356010237,-0.017111706545941036},
{0.13149078280736096,0.7398129761576835,-0.007495179482042729},
{0.11241170819762443,0.7576095985183867,-0.02610858592989509},
{0.1388423723928044,0.7516065285184452,-0.01858010637906773},
{0.15121774355537107,0.7219758609133384,0.010627517152199437},
{0.1675507612928525,0.7380515357192522,0.0006790550026560197},
{-0.6957591163600307,0.29375349317721555,0.17270880874731534},
{-0.6772277612816637,0.280441457679875,0.16642228856187927},
{-0.678716940357712,0.28581688798336374,0.15727089685876455},
{-0.6824502776692936,0.2893397688602265,0.14680242083508047},
{-0.6962098660910995,0.29251846022613137,0.12017941544260055},
{-0.7233166548828823,0.2984309540389788,0.12377635567244027},
{-0.7484211771387835,0.2961324500911888,0.1340359736647072},
{-0.7354139038709598,0.304615709214209,0.16091419078435248},
{-0.7592530235130454,0.29987804182808325,0.14465523239984804},
{-0.7426083171317399,0.30513252628174636,0.16439071796546703},
{-0.779789309132797,0.2912733040541369,0.1726954887198015},
{-0.7643796357025755,0.29747883847228873,0.18920060121276186},
{-0.7983622226970072,0.28320509698844826,0.1989998790541502},
{-0.7864519868952241,0.2875479587590637,0.21092290208234654},
{-0.8074102509866145,0.27745510751127006,0.21296512870076986},
{-0.7981768079140145,0.281443656550017,0.22437080186032834},
{-0.812970030470895,0.27585563860740714,0.22215754608862723},
{-0.8052897026064098,0.2795303677979277,0.22977873303095095},
{-0.6767216002361375,0.27795114533588583,0.1738111742243615},
{-0.6933114281040859,0.28869188272195295,0.18048983601980528},
{-0.6759399810216249,0.27164437870862873,0.1840558737858129},
{-0.6913160879825113,0.2826483198383694,0.19111175876044892},
{-0.6772410813091775,0.2701157723511394,0.1941306097961876},
{-0.6885028981715865,0.2775664629412858,0.19879261942603468},
{-0.6828722561409323,0.2743675251335599,0.20404550547639613},
{-0.6759016193423849,0.2704295921993656,0.2013021126096438},
{0.022522301722066426,0.7587231528185444,0.012952128353916336},
{-7.965376453282913e-05,0.7619828299517336,0.027747482115199066},
{-7.965376453282913e-05,0.7547548502216185,0.021028327436113162},
{0.028425737916204227,0.7308235559891373,0.013574440039363353},
{-7.965376453282913e-05,0.7294771676080374,0.012895651437257617},
{-0.028585045445269883,0.7308235559891373,0.013574440039363353},
{-0.022681609251132082,0.7587231528185444,0.012952128353916336},
{-0.023259698445233123,0.777046182666595,0.01690391411672501},
{-0.04700557789472171,0.7637746400528965,0.011373438692974972},
{-0.043225886887391964,0.7876451949599148,0.010771373449349005},
{-0.06231561751913956,0.8022732491756235,-0.007823917761084521},
{-0.055617242082975256,0.8045307274386705,0.0013248099365274137},
{-0.0629736268783237,0.8280064767301784,-0.002565703699717555},
{-0.06574525820340535,0.796826956325761,-0.030168530316116215},
{-0.05939160507929946,0.8148867824301379,-0.04258013195352055},
{-0.04713451576105577,0.8307093767132885,-0.0640147202288061},
{-0.025430330128889924,0.8347789115193196,-0.08068500106293817},
{-7.965376453282913e-05,0.8327745137790356,-0.08029925306613714},
{0.025271022599824267,0.8347789115193196,-0.08068500106293817},
{0.04697520823199011,0.8307093767132885,-0.0640147202288061},
{0.060351179861397104,0.8369655272359932,-0.03743007651556604},
{0.059232297550233806,0.8148867824301379,-0.04258013195352055},
{0.06629084653037258,0.8278343819746995,-0.010719158941494701},
{0.0655859506743397,0.796826956325761,-0.030168530316116215},
{0.0621563099900739,0.8022732491756235,-0.007823917761084521},
{0.06281431934925803,0.8280064767301784,-0.002565703699717555},
{0.0554579345539096,0.8045307274386705,0.0013248099365274137},
{0.04306657935832631,0.7876451949599148,0.010771373449349005},
{0.046846270365656056,0.7637746400528965,0.011373438692974972},
{0.02475367273118638,0.7707697857020694,0.020840781448718166},
{-0.8404950681266127,0.25171175673580476,0.1079020796825358},
{-0.843119113546841,0.24904934963633668,0.10029634397212811},
{-0.8344067499505826,0.2542729316261676,0.10638572775035925},
{-0.8369871056805656,0.25160040130578903,0.09573823055688904},
{-0.8209290133109699,0.2610757360780404,0.10094156610489896},
{-0.8242712746147448,0.25868665594315665,0.08870738723397908},
{-0.8034478092017947,0.27109772477946037,0.09649161131307234},
{-0.8073495116611512,0.26770644577443437,0.07991350506933607},
{-0.7761252359642874,0.28341768462756944,0.08590751745056806},
{-0.7803359630619653,0.2815651352009433,0.0670197184359304},
{-0.76309505224914,0.2842680351840534,0.085852638937211},
{-0.7703230319792549,0.2809982348299539,0.0579759525551276},
{-0.7341101395779044,0.29441150253639964,0.07429831427059798},
{-0.7410557347247256,0.29407743624635224,0.05082949139339743},
{-0.7108112802517804,0.30346166203040914,0.06863783537831276},
{-0.7065515354528517,0.3072173769882139,0.038584656500466476},
{-0.6906319713694,0.3094141159257978,0.06016043706739881},
{-0.6766779105458921,0.3238599521651171,0.025545415166609575},
{-0.66385498645886,0.3199321424518335,0.047841542821490855},
{-0.6513639974574731,0.3394800820300575,0.011424054797527597},
{-0.6329429322069208,0.3382146794162417,0.03869761033378391},
{-0.6742200990690367,0.30518260958519833,0.08740841815082855},
{-0.7036046125656877,0.29806598528509914,0.09407589112316071},
{-0.03240576213734228,0.8896568920752762,0.08750485515002882},
{-0.032830404614483784,0.8850913194446294,0.06631269137549531},
{-0.023623601596911473,0.8870046081967187,0.08439755913159816},
{-0.0321718624541991,0.8922281901865496,0.09125364369352643},
{-0.016895922100216704,0.8885939538796711,0.0931663996445151},
{-0.01860834483739711,0.8837348078426192,0.08156252447555055},
{-0.02534188514619797,0.8817506565441562,0.08562832967387778},
{-0.03218891208941682,0.8814469599168404,0.08810905159805699},
{-0.04073291053790001,0.8819025048578141,0.0866140117099026},
{-0.04812446020588502,0.8840385044699348,0.08060881050555897},
{-0.04048995323604741,0.8889482666115396,0.08495327067947593},
{-0.043991522068888,0.8922079437447286,0.08475133906236598},
{-0.031225607699615278,0.8962774785507597,0.0942565106962485},
{-0.010850760813331549,0.8910538965609288,0.09684805524934292},
{-0.006641632118955318,0.8855873572692451,0.09283180055336723},
{-0.010938140193822396,0.8807687041158353,0.08708234387728953},
{-0.021297924792993465,0.8763954726824883,0.08348433804524867},
{-0.03118937722477761,0.8741886105239939,0.08489412975731443},
{-0.04154969462504923,0.8750490843013886,0.08280128703433852},
{-0.047802648341150424,0.8788351689219249,0.07938603197978766},
{-0.0509999877455747,0.8823782962406087,0.07491316674063724},
{-0.050145374780286155,0.8909729107936446,0.07765602680628897},
{-7.965376453282913e-05,0.8118801858197119,-0.09776553874449681},
{-0.028525904523108395,0.8151499861738114,-0.09576007540201174},
{-0.05611327990759099,0.8149778914183325,-0.07978190319749924},
{-0.07041739105416298,0.7989730791587925,-0.0548169748299432},
{-0.02720189378823182,0.6989354101209833,0.020989965756873275},
{-0.04738386667611502,0.7043412100872035,0.03884253223313459},
{-0.07396851038935508,0.7006462344548618,0.040264045569412536},
{-0.07704650234725527,0.7261567511493853,0.029547284232870317},
{-0.09630513092787847,0.7434269660227409,0.004636168776470232},
{0.07025808352509731,0.7989730791587925,-0.0548169748299432},
{0.055953972378525334,0.8149778914183325,-0.07978190319749924},
{0.028366596994042738,0.8151499861738114,-0.09576007540201174},
{-7.965376453282913e-05,0.8902237924462656,0.09558052143112507},
{-7.965376453282913e-05,0.8817810262068878,0.09535940897439518},
{-0.00451255892114172,0.8808294434412984,0.09460602821821189},
{-0.017070680861198402,0.8629113424296689,0.0935958373315616},
{-0.02577451963984778,0.8620812383150057,0.08890292523788237},
{-0.03758725284022948,0.8614940915021954,0.08521594162204903},
{-0.047358292223288426,0.8645310577753529,0.0794377136865414},
{-0.05469123377021249,0.8692889716032997,0.06825528418811502},
{-0.058972823414264054,0.8763954726824883,0.06221811491773818},
{-0.057769225728112675,0.8879258212995765,0.06732714467095004},
{-0.05423142642043443,0.8972999238627227,0.0764396418937243},
{-0.046399250242291315,0.8982818762910437,0.08530332100253987},
{-0.031817016921230165,0.905803429427564,0.09277532363670851},
{-0.011015396353402722,0.8995371556839487,0.09807243217841592},
{-0.0002933070058549644,0.8989196392084067,0.09729081296390325},
{0.004039431543849784,0.8882295179268922,0.09470353081961326},
{0.006780693206199874,0.8816190546723195,0.09383719623011254},
{0.005566972299137968,0.8681652940822314,0.10336634391352},
{-7.965376453282913e-05,0.8685094835931894,0.1051794660587051},
{-0.005232373207990112,0.8682564030704261,0.10344093606759755},
{-0.01874474191913892,0.8517656762071807,0.09891798752499503},
{-0.02154248049814773,0.8505508896979178,0.08983372876055014},
{-0.0392069681859135,0.8478682361566287,0.08347741163094147},
{-0.051718736430221984,0.852403439124544,0.07522645378776294},
{-0.06059253875994807,0.8592771061227904,0.06274239120068327},
{-0.06577616066723749,0.8649663562745055,0.04382795213101793},
{-0.06402004823981165,0.895396758331544,0.05812194005667939},
{-0.05604135175901621,0.9079191825978636,0.0734287828744939},
{-0.04784420682699364,0.9095186515017266,0.08146928428295364},
{-0.03077592357074774,0.9278113116870453,0.08594854313531071},
{-0.013643171381334819,0.924794591855709,0.0917779199764715},
{-0.002216186177754182,0.9240657199501511,0.09433589806023103},
{0.0030164534307861937,0.9000129470667434,0.10000330336682343},
{0.011079865286569722,0.892795090557539,0.09841928569487654},
{0.012854092951414387,0.8835525898662295,0.09278544685761904},
{0.01513235045738309,0.8666569341665631,0.09391711639519564},
{0.01675206580306711,0.8533752683319544,0.10139711104587258},
{0.005818987219699988,0.8535777327501648,0.11259499177621503},
{-7.965376453282913e-05,0.8536182256338068,0.11452852697012532},
{-0.005993745980681711,0.8535777327501648,0.11259499177621503},
{-0.005975630743262876,0.8439201800015238,0.1135487057462066},
{-0.017553931459400835,0.8438290710133292,0.10165125717083683},
{-0.02281747353177334,0.8433330331887133,0.08841168262317163},
{-0.02979610234682902,0.830101983458657,0.08127161507464811},
{-0.042904607823757934,0.8310231965615148,0.07318742397594298},
{-0.05213325568645295,0.8360341909122249,0.06353200243170423},
{-0.05990362693693182,0.8408832137283663,0.0506573966379185},
{-0.06506913360680239,0.8530918181464596,0.04167596848588051},
{0.001141526357936832,0.9267686199332612,0.09730573139471876},
{0.01785016887130881,0.9062184814848953,0.10165924918734513},
{0.015960323367643935,0.9265357858523192,0.09776607154559738},
{0.0317711960265825,0.9101766608609106,0.09831911908797239},
{0.0323983029219345,0.9011265013669011,0.09805911215090207},
{0.01948533544890889,0.8977959616873384,0.09972304998793206},
{-0.002653615881308978,0.9393720299668651,0.08948421123858674},
{-0.00028531498934665516,0.9429252805064594,0.09195747394735819},
{0.01523997627969499,0.9472074029516115,0.09033029938626641},
{0.03044665249060537,0.9452839909786117,0.0860668249796337},
{0.031585781243589725,0.9259992551440615,0.09351325316097574},
{0.04346777858704343,0.9115432956838316,0.09297352564611458},
{0.04259078797553163,0.9022906717716117,0.0942565106962485},
{0.04195089385376633,0.8944249291241335,0.0888517763322292},
{0.032941227243398985,0.8952145403551546,0.09153336427131725},
{0.022334222933570878,0.8917017826992023,0.0920555093498601},
{0.01674673779206157,0.8852127980955559,0.08915227615294163},
{0.019701119894633242,0.8782885149927566,0.08568107698283263},
{0.027906256843164123,0.8744619374885781,0.08573755389949135},
{0.026816145791430733,0.863569351788853,0.08837864895493729},
{0.022264958790498866,0.8527779982982332,0.09019869751442959},
{0.016489927661594565,0.8433229099678029,0.10050733320794748},
{0.005767305512946254,0.8439201800015238,0.1135487057462066},
{-7.965376453282913e-05,0.8456816204399553,0.11619459601155753},
{-7.965376453282913e-05,0.8395773182309086,0.11464947281995107},
{-7.965376453282913e-05,0.8359127122612986,0.1092085079810941},
{-0.00632514826522627,0.837795631350656,0.10787384122420644},
{-0.012216330034051332,0.8413590051111609,0.10037839534161343},
{-0.015412071035173943,0.8389091856508138,0.09441315421981136},
{-0.022678945245629314,0.8313977557352044,0.08816499571361516},
{-0.022887270475945905,0.8202520895127161,0.08770199155723377},
{-0.027412350222950632,0.8182274453306111,0.08125616384273204},
{-0.03259863613574281,0.8208999756509896,0.07458336285939433},
{-0.04403361335583176,0.812517948737075,0.056764362852467914},
{-0.05493578947536675,0.8157573794284428,0.041333910179324876},
{-0.06421558624371496,0.8269131688718416,0.026996232563417988},
{-0.06645494926934321,0.8413286354484294,0.0316939398670022},
{-0.06746034494608853,0.8527476286355017,0.029711919772941492},
{-0.06866927064324545,0.8555517608277172,0.016634316759844708},
{-0.0682835226464444,0.8508849559879652,0.00850377196539138},
{-0.07364989533122382,0.8485363687367232,-0.007749325607006968},
{-0.0783039129445626,0.8593175990064325,-0.018821465277618667},
{0.028096466836061883,0.8777823539472304,0.08437251747987211},
{0.03462274751674725,0.8766485532052516,0.08361647271818605},
{0.03549174611175076,0.8726903738292362,0.08521594162204903},
{0.039762679733791245,0.8631542997315217,0.08597944559914285},
{0.037039533308859986,0.8485363687367232,0.08416419224955551},
{0.022056633560182268,0.8433330331887133,0.08841701063417717},
{0.012825854493085029,0.8374008257351455,0.09554961896729294},
{0.011298313737796844,0.841014815600203,0.1015819930277648},
{0.006165840736160611,0.837795631350656,0.10787384122420644},
{0.021807282645123018,0.8808294434412984,0.08356745501693509},
{0.019264222992179,0.8844029404227137,0.08321260948396617},
{0.022408815087648432,0.8844839261899979,0.08013461752606596},
{0.02867508883126348,0.8805763629185351,0.08052835753937534},
{0.033576326155259295,0.8797766284666038,0.08112456197089522},
{0.03852338437390275,0.8808395666622089,0.0810297233749966},
{0.04069081925095623,0.878258145330025,0.08298883302173349},
{0.0456330822596947,0.8743100891749201,0.0819786421350832},
{0.05223342229335707,0.8674971615021368,0.08052569353387257},
{0.051408113388599,0.8465623406591708,0.07427753502767637},
{0.03723240730726052,0.8290390452630518,0.07541133576965517},
{0.024802690432437345,0.8340196699510303,0.08649093465567463},
{0.010413863910877282,0.8232283164604105,0.09692531140892326},
{-3.596407428740496e-05,0.8329668549763357,0.09919824090388642},
{-0.010591286677361774,0.8232283164604105,0.09690719617150441},
{-0.03285597906731037,0.8122648682143117,0.06837143482803579},
{-0.029621343585847323,0.808164963745549,0.07031775724835938},
{-0.037803037285953835,0.7989325862751503,0.057291303140915774},
{-0.050728791985392735,0.796017098652919,0.037662377795407584},
{-0.05922963354473106,0.8067375895971651,0.029457240846876703},
{-0.06906780586645982,0.8228436340658105,0.01072501975360081},
{-0.07151815812790745,0.8397899058700296,0.011627584817939208},
{-0.0698339738490564,0.849670169478702,0.027898797627756388},
{-0.07154906059173957,0.8511582829525492,0.0162895944477863},
{-0.06818069203403747,0.8423713272022134,0.0029780917515463278},
{-0.07361100085088336,0.8427560095968135,-0.008999276988906542},
{-0.0759713097263374,0.8506015058024704,-0.019073480198180687},
{-0.07194759581495393,0.8412476496811452,-0.009930080511574298},
{-0.06663770004683323,0.8395570717890876,0.0009827516299717738},
{-0.07216870827168383,0.8302943246559571,-0.010922688961906315},
{0.023822869208518622,0.8902339156671761,0.08432616378412391},
{0.03252937199267077,0.8935745785676495,0.08570398743015645},
{0.02690618917742435,0.8890393755997342,0.0824645567387884},
{0.032290677099622606,0.8843017082136085,0.08576845636332348},
{0.04210487337182642,0.8830363055997927,0.08004723814557511},
{0.04469961473152417,0.8817810262068878,0.08069032907394375},
{0.05365546843073558,0.8780961737954567,0.07731396849973335},
{0.06186273658366867,0.8719412554818574,0.07213833860895225},
{0.06728079097520183,0.862567152918711,0.0650515511704841},
{0.06006027046049465,0.8545394387366647,0.07169824489989467},
{0.06124042489822166,0.837755138467014,0.05280991308415647},
{0.04910694543530648,0.8318330542343569,0.06363216903860837},
{0.043622290906204085,0.812173759226117,0.05760245898363928},
{0.029402895134620178,0.8266600883490783,0.07998330201350864},
{-8.23177700355989e-05,0.8215478617892634,0.09894409477892219},
{0.03234981802178409,0.8914284557346183,0.08348273964194701},
{0.03851805636289721,0.8922686830701917,0.08469379654350616},
{0.03749454544873307,0.8909627875727341,0.08192216521842448},
{0.041235874776822924,0.8887559254142394,0.08078516766984235},
{0.04396168520725695,0.8857088359201714,0.07948939539329514},
{0.04670241406850648,0.8856683430365293,0.07915000109224227},
{0.05380944794879567,0.8865996793602976,0.07787980326852163},
{0.059782681087106035,0.8886142003214922,0.07514120561167431},
{0.0733872243886507,0.878875661805567,0.05307205122562902},
{0.07561166898346344,0.8714249712154206,0.049114937451814805},
{0.06951003077991957,0.8512392687198334,0.053187669064449224},
{0.06774059832497988,0.8407921047401715,0.037013958856033424},
{0.062374758441301026,0.8199787625481318,0.029467364067787227},
{0.055074850562611306,0.8155144221265904,0.04162215557472456},
{0.0435295835147077,0.889515166982529,0.08265743073718894},
{0.04840737759027914,0.891114635886392,0.08300428425364956},
{0.053164225816024833,0.8964698197480596,0.08380135470007827},
{0.061122143053898674,0.9017642642842644,0.07169078568448692},
{0.06738841679751371,0.895589099528844,0.05141610540510733},
{0.08238676777810751,0.8886648164260448,0.02158617018839315},
{0.0745497963900594,0.8592771061227904,0.039760548529389046},
{0.07925016769914639,0.8681248011985893,0.014098716322308443},
{0.07448266345138962,0.8418246732730451,0.0022577446635973835},
{0.06974126645755997,0.8292111400185307,0.010648296395121042},
{0.0670079968117182,0.8185210187370164,0.011249828837646456},
{0.06113279907590976,0.804925533054181,0.014823858620162373},
{0.05912467172792191,0.8066869734926125,0.02950838975252988},
{0.050618502157578044,0.795976605769277,0.037710862695558},
{0.03651738823031712,0.8010888323290921,0.060135395415672775},
{0.029312851748626557,0.8080333618737122,0.07174459859564286},
{0.07036357814300699,0.8305372819578096,-0.0074562850017022885},
{0.07501013654093802,0.8528083679609648,-0.030646985704413664},
{0.06774592633598542,0.8312965235260991,-0.00015637712301257902},
{0.050104349095543475,0.7891738013174039,0.02719709857832683},
{0.033751084916240986,0.774424268450769,0.047801049937848755},
{0.03551732056457734,0.7826746934928469,0.05686186545386929},
{0.026674953499783938,0.7942354117726664,0.07147500123876258},
{0.020721966803294616,0.8021112776410552,0.08295047134249363},
{0.026013747333996477,0.8107767547404647,0.08072123153777587},
{0.016073277200961373,0.8070007933408386,0.09161062043089757},
{0.010151725769404736,0.8046218364268655,0.09383453222460977},
{-6.953054362230401e-05,0.8036803768821865,0.09604352558750646},
{-0.010874204061755923,0.79584500389744,0.08960515708841249},
{-0.02338064429505887,0.7991755435770028,0.0788798709342614},
{0.07969505661810894,0.8452564451617132,-0.0011154191040096929},
{0.08421534115520868,0.8676490098157946,0.010658419616031567},
{0.08769399954072543,0.8807788273367457,-0.02078110772545611},
{0.08204257826714965,0.855683362699554,-0.029337893400352602},
{0.06840180449076734,0.8720829805746046,-0.059067662010162635},
{0.0628297705811741,0.8679628296640209,-0.057462865095294136},
{0.07199128550519933,0.8426750238295293,-0.03492804254736468},
{0.08633375833101119,0.889555659866171,0.016955595823478744},
{0.08693795477903937,0.9021084537952221,-0.01314926476112128},
{0.07569638435845151,0.8949108437278387,-0.0559022906717716},
{0.07298868916543633,0.9054187470329639,0.023875083716372935},
{0.07512042636875269,0.9169187259873204,-0.007448825786294533},
{0.06947912831608744,0.9304129794610505,-0.04197859951099514},
{0.075498715150146,0.9151269158861575,-0.048769682338655834},
{0.06629564174027756,0.917758953322894,0.05052099955617669},
{0.06816524080212139,0.9317694910630607,0.032126041559551455},
{0.07063850351089285,0.9441096973529908,0.003654216348149298},
{0.0681524535757081,0.9540304538453056,-0.029276621273788894},
{0.06407172994656536,0.9591224339632995,-0.04513597883287788},
{0.0639278736494158,0.9400199161051387,-0.05950189490711411},
{0.05531141425125726,0.9282061173025559,-0.07473680957635385},
{0.03787283423012638,0.9361123528336761,-0.09204698453225124},
{0.01801214040587721,0.9198139671677306,-0.10260283993642616},
{0.011905174191327797,0.9075851163078162,-0.1039620155439393},
{0.01371030432000459,0.9329842775723238,-0.10053930127398071},
{0.021069353120855793,0.9492624167964481,-0.09268474744961433},
{0.03905298866785338,0.9557918942837369,-0.07630271201088193},
{0.030361937115617292,0.9492725400173586,-0.08473215822274602},
{0.01532469165468307,0.9587782444523418,-0.083887668478368},
{0.04090447249227837,0.9689419582465091,-0.06431308884511631},
{0.015625724276496052,0.975187985548303,-0.07026021472949953},
{0.016651899196162966,0.9898565326476538,-0.04843508324750794},
{0.0177009845631537,0.994715678684706,-0.02762813466867496},
{0.0176674180938188,0.9946245696965113,0.0004659345624344397},
{0.017631187618981133,0.9914256318887852,0.02673675842744822},
{-0.0006891782235665517,0.9957684936594006,0.029330966986045415},
{0.01688846288480892,0.9828310173357495,0.05161377461341285},
{-0.00023150207819070583,0.9868600592581384,0.05394371382613529},
{0.015638511502909347,0.965530432799662,0.07593348084819805},
{-0.0002570765310172956,0.9680713612482038,0.07845309725271768},
{-0.014352862447272685,0.9673829822262882,0.07451676272182507},
{-0.014165316459877692,0.9832055765094387,0.052418837076349874},
{0.026037190582420853,0.9893301251603065,-0.04778719710923434},
{0.02626309824905573,0.9947460483474375,-0.027468827139609336},
{0.026479415495880638,0.9956571382293848,0.0006534805498294303},
{0.027572190553116792,0.9897046843339959,0.026034526576918102},
{0.028613283903599216,0.9810999465600496,0.05035423281170331},
{0.02955953865818304,0.96491291632412,0.07308192935803327},
{-0.014116298758626728,0.955640045970079,0.08397131825115499},
{-0.016857560420976817,0.9654089541487357,0.07169344968998968},
{-0.016977973469702014,0.9807456338281814,0.05044427619769692},
{-0.029973525113313484,0.9643561391740412,0.06595944424582804},
{-0.029816881589750627,0.9483209572517692,0.07678969221678825},
{-0.04497187609390727,0.9484424359026957,0.0659876827041574},
{-0.05632906435331534,0.9291273304054137,0.06451182365562294},
{0.044470510258285974,0.9814643825128285,-0.043937709157732034},
{0.04449395350671035,0.9863538982126121,-0.026101126714487336},
{0.0459362460859099,0.9878622581282803,0.001193208064690585},
{0.04709349007631309,0.9812517948737076,0.02339929233357825},
{0.04838180313745254,0.9732949432380348,0.04374590076153262},
{0.04888316897307382,0.9582315905231734,0.0655502530006026},
{0.06414365809514014,0.9597601968806627,0.03372817446891719},
{0.06342384380829176,0.9474604834743747,0.051634553856334454},
{0.0634440902501128,0.9313240693429976,0.06312547519198157},
{0.04984967016947869,0.9400300393260492,0.07773594697137207},
{0.04910428142980371,0.9209882607933515,0.08405869763164583},
{0.0548585333157864,0.9084152204224794,0.08225356750296904},
{0.06425927593396036,0.9666338638789093,0.016865552437485123},
{0.06428751439228972,0.971452517032319,-0.013043770143211602},
{-0.01676218902397766,0.9515198950594953,0.08076758523352406},
{-0.046833483139242786,0.9300991596128241,0.07424130455283869},
{-0.03730433545583533,0.7772486470848053,0.04355036275762932},
{-0.03897573250827308,0.7852459916041203,0.052742780145486674},
{-0.05026365662460913,0.7891738013174039,0.02719709857832683},
{-0.061292106604975416,0.804925533054181,0.014823858620162373},
{-0.029225472368135736,0.792625819647893,0.06643523562862272},
{-0.02298477307734728,0.7733714534760744,0.0738917870308753},
{-0.015304445212862044,0.7632178629028177,0.06941252817851822},
{-0.01609885165378799,0.7628230572873071,0.04555103089020941},
{-0.02059356173806114,0.7837275084675415,0.0812044821359783},
{-0.01356378401735228,0.7754669602045531,0.08521807282645123},
{-0.011514098183521221,0.7659106396650173,0.08084430859200382},
{-7.965376453282913e-05,0.761162849057981,0.0734879237966554},
{-7.965376453282913e-05,0.7597253516886864,0.05388936811387878},
{-7.965376453282913e-05,0.7668723456515172,0.08602313528938825},
{-7.965376453282913e-05,0.777451111503016,0.09016566384619526},
{0.013404476488286621,0.7754669602045531,0.08521807282645123},
{0.011354790654455563,0.7659106396650173,0.08084430859200382},
{0.015152596899204143,0.7632178629028177,0.06945621786876365},
{0.01593954412472233,0.7628230572873071,0.04555103089020941},
{-0.01129831373779687,0.7881007399008882,0.09028607689492044},
{-7.965376453282913e-05,0.7886575170509671,0.09236400118708085},
{0.011139006208731211,0.7881007399008882,0.09028607689492044},
{0.020434254208995483,0.7837275084675415,0.0812044821359783},
{0.022825465548281625,0.7733714534760744,0.0738917870308753},
{-8.23177700355989e-05,0.795399582177377,0.09099097275095332},
{0.010701576505176415,0.7957943877928874,0.08972823414264046},
{-0.02675274246046484,0.8904869961899394,0.08485203847037068},
{-0.03210526231662986,0.8927039815693443,0.08485203847037068},
{-0.03210526231662986,0.885141935549182,0.08635773438053615},
{-0.024535757081059838,0.885141935549182,0.08485203847037068},
{-0.02675274246046484,0.8797867516875143,0.08485203847037068},
{-0.03210526231662986,0.8775697663081093,0.08485203847037068},
{-0.03745724937169431,0.8797867516875143,0.08485203847037068},
{-0.03967423475109932,0.885141935549182,0.08485203847037068},
{-0.03745724937169431,0.8904869961899394,0.08485203847037068},
{-0.03210526231662986,0.8991221036266174,0.080564588014213},
{-0.022215408288147373,0.8950323223787652,0.080564588014213},
{-0.018119233427088578,0.885141935549182,0.080564588014213},
{-0.022215408288147373,0.875251548719599,0.080564588014213},
{-0.03210526231662986,0.8711516442508364,0.080564588014213},
{-0.04199458354401178,0.875251548719599,0.080564588014213},
{-0.04609129120617113,0.885141935549182,0.080564588014213},
{-0.04199458354401178,0.8950323223787652,0.080564588014213},
{-0.050378741662328794,0.885141935549182,0.07414753155914118},
{0.10109075041305404,0.8324505707098989,-0.0163993514745004},
{0.1048240877246356,0.8513405009289389,-0.05492513345335566},
{0.0869459467955477,0.8155852846729641,0.01813841426670852},
{0.10748756042630479,0.8149981378601536,-0.019472015421395046},
{0.0813073127483852,0.7615981475571336,0.02361774078480537},
{0.0768871948181896,0.7261567511493853,0.029547284232870317},
{0.09614582339881281,0.7434269660227409,0.004636168776470232},
{-0.7752972630540266,0.28517912506600074,0.08925990197525352},
{-0.7894660427210579,0.2981368478314728,0.08862746706889597},
{-0.7901906522178113,0.3019836717774725,0.08905903596034469},
{-0.7883855220891344,0.30762230582463496,0.07981014165582861},
{-0.7875980420625157,0.3132204469881554,0.09951152795101213},
{-0.7863640747136328,0.3090901728566611,0.11432712815411591},
{-0.7842200830850037,0.31485028555474986,0.11538686954311773},
{-0.7851492882043697,0.3099309329933352,0.11595110590860438},
{-0.769015005277395,0.2910505931941054,0.11822137139806477},
{-0.7703267615869588,0.2916883561114684,0.11343735031619083},
{-0.7963274552939916,0.2927310478652525,0.0687992741117806},
{-0.7856394652168793,0.3028238991130459,0.06232041272904454},
{-0.7894111642077009,0.30866499757841903,0.05640632051289566},
{-0.792306405388111,0.3251962173253065,0.09482927187934401},
{-0.7840447915229214,0.3319990217771793,0.1274974385587091},
{-0.7796667648796696,0.3208229858919598,0.12858808241154304},
{-0.7789235073443969,0.31673320464410765,0.14137744002924013},
{-0.769959661628677,0.32226048326125417,0.14188146987036418},
{-0.7608599516323161,0.29557567294111,0.139351730244934},
{-0.7698195349392314,0.31995238889365457,0.14669426221166804},
{-0.7631483323591953,0.3303793064314953,0.1555579413204836},
{-0.7510036640731685,0.32985289894414804,0.16275288738236418},
{-0.7468078554063061,0.3320293914399109,0.15809087775251712},
{-0.7414564011523422,0.3261376768699854,0.16036380724748028},
{-0.13900167992187007,0.7516065285184452,-0.01858010637906773},
{-0.1125710157266901,0.7576095985183867,-0.02610858592989509},
{-0.14205889263684865,0.7646047441675596,-0.0044454259824719},
{-0.16771006882191816,0.7380515357192522,0.0006790550026560197},
{-0.16426018169583131,0.7654955876076857,-0.0006092580584834375},
{-0.14098156881152854,0.7898318106765881,-0.012259486923196183},
{-0.11287950756391084,0.7796984665451525,-0.013408738897091056},
{-0.10377500235764488,0.7805285706598156,-0.01655865900356603},
{-0.10730267844441262,0.7960778379783822,-0.022390699850229605},
{-0.11636722356813702,0.7950857623291506,-0.019168851595179844},
{-0.1133936606259454,0.801665855920992,-0.03709068221451317},
{-0.12239160561210057,0.8005927945044764,-0.03370686242489502},
{-0.12738714873089443,0.7925549571015194,-0.04907018215936825},
{-0.11831088198295783,0.7918159619750511,-0.052166289354687284},
{-0.12402144417869511,0.7776333294794053,-0.05354198179631759},
{-0.16036167604307805,0.7789999643023263,-0.035879625312954036},
{-0.15406982784663642,0.767024193965175,-0.04242082442445492},
{-0.17068523016741147,0.7725514725823217,-0.012136409868968214},
{-0.18519979774870224,0.7524872487376609,-0.006175963957071141},
{-0.1761879999339327,0.747223173864188,0.003039896679210589},
{-0.14688766901116912,0.7929396394961193,-0.027679816375428695},
{-8.711297994058448e-05,0.1302533522513243,0.16839418543502943},
{-0.017549136249495847,0.13508212862564495,0.16839418543502943},
{-0.030338493867192947,0.14780701731017507,0.16775855372206858},
{-0.03502128273996164,0.1651891204146471,0.16861529789175933},
{-0.10141895589099531,0.8115866124133065,-0.15150279214416745},
{-0.08899243582277545,0.8056645281806495,-0.1456302584138618},
{-0.09884819058082249,0.811282915785991,-0.13301246275054304},
{-0.10093890209939618,0.8244633494114945,-0.12400013213467294},
{-0.11086924901152077,0.8420473841330766,-0.132853688022578},
{-0.09602221354348431,0.8398000290909401,-0.11993059732864182},
{-0.08987954965519777,0.8521301121599597,-0.13753274728764278},
{-0.08130677994728468,0.8473418286692813,-0.13059834096393308},
{-0.06496630299439549,0.8380487118734193,-0.14666708935553976},
{-0.08338736824494786,0.8453070612662658,-0.15678711345946153},
{-0.08570132342465368,0.8239065722614156,-0.16403054442149254},
{-0.06992614843945222,0.8163647726830744,-0.1551540780862637},
{-0.10756481658588515,0.8301525995632096,-0.17832133554055069},
{-0.1276130563975293,0.8041460450440707,-0.19077662686820043},
{-0.15372457273347745,0.7550889165116659,-0.19296537378927608},
{0.3633983226355752,0.5939778557206586,0.005664474900539363},
{0.3718666633277798,0.5965896467155741,0.01824550728791986},
{0.3595365802587602,0.6109443739666988,-0.14981914066641694},
{0.3233226222552085,0.5994241485705213,-0.173673178739318},
{-0.030222876028372737,0.6492506418921259,0.08506142930288836},
{-0.020164124051014653,0.664000174758761,0.06681032760341271},
{-0.037756683590205634,0.6731920593455178,0.05999367032292543},
{-0.018199686393272227,0.6722910926844811,0.031128637899314453},
{-7.965376453282913e-05,0.6985709741682042,0.015579903381848432},
{-0.08110644673347638,0.6805718873892906,0.05474344827806677},
{-0.12133665943300374,0.699046765550999,0.02507282059041822},
{0.06217922043739772,0.9139323758187154,0.0715208221334102},
{0.6753229973471833,0.34767989096758284,0.00455891261688991},
{0.6903602428081176,0.3569223916588923,0.005741731060119686},
{0.5990194861346505,0.36387704442442287,-0.05627045623225439},
{0.6392683468726973,0.3489351703604878,-0.016873011652892865},
{0.5750008125216783,0.35501922612771347,-0.026872622708089457},
{0.6186111154031199,0.34706237449204086,0.002437298634484068},
{0.601552422566684,0.34941096174328257,0.02706762791089222},
{0.5509746796932984,0.36284447589154933,0.0075260819458748745},
{0.5338302058796732,0.3650007219454914,-0.053151438589611535},
{0.5048127923413038,0.38200773307517355,-0.014229785393044697},
{0.552530458906916,0.3891648502589148,0.03154475555884709},
{0.5948465879151119,0.3687969297869382,0.0494585941616721},
{0.6250409590846051,0.3492894830923563,0.06217389242639221},
{0.627193475530843,0.3706494792135644,0.08282366468056178},
{0.5627570432309484,0.37172254063008003,-0.08681487772481142},
{0.5417359086096928,0.37733080501451094,-0.09678145511177368},
{0.5131996144651236,0.3744456870550112,-0.07177017304846943},
{0.47707623264866617,0.3997334928895029,-0.04929449142270147},
{0.4715782580920499,0.4133593482350698,-0.024484075374306084},
{0.5038457583437984,0.41897773584041126,0.009513430050941123},
{0.5176479708536486,0.3920398449975038,-0.10762235910474496},
{0.4924523396095527,0.38796018697056217,-0.07856125587613012},
{-0.08146662027745086,0.7615981475571336,0.02361774078480537},
{-0.1105554291632945,0.7569718356010237,-0.017111706545941036},
{-0.08710525432461336,0.8155852846729641,0.01813841426670852},
{-0.761906372993804,0.3342868697029581,0.04092738293960221},
{-0.7380336868823836,0.3614171017431655,0.062454145805283585},
{-0.7411505733206242,0.34774063029304597,0.031351881560446555},
{-0.7505561111487032,0.31916277766263346,0.03878285850987254},
{-0.7267132618989138,0.3199726353354756,0.02883439636032913},
{-0.7096657578855895,0.3577018796690026,0.019826860954363996},
{-0.7198193484588462,0.3757110896688267,0.04832212941419052},
{-0.7111384201275207,0.3859557892302782,0.07388326221326642},
{-0.7283143292060784,0.37241091965199563,0.08891038445329014},
{-0.755215989574148,0.3518304115408981,0.07211436255942731},
{-0.7779303660929642,0.3221390046103279,0.048733451863818174},
{-0.7742018239912876,0.30655936762902986,0.04895989233155361},
{-0.7001254213790704,0.33839689739263135,0.01693428377945658},
{-0.6890021328028055,0.35796508341267635,0.004980358287428086},
{-0.6744385475202638,0.34920849732507214,0.002121347581855572},
{-0.744303157432602,0.3620751111023495,0.09966337626467002},
{-0.7102902007754387,0.3770777244917477,0.11178460130227245},
{-0.7284763007406468,0.36653945152389117,0.126538396577712},
{-0.7636699446366376,0.3490870186741459,0.11291840204425127},
{-0.7736626292775269,0.34023932359834674,0.08301440747456008},
{-0.7472085218339227,0.3528427336319506,0.1418788058648614},
{-0.7650488338848713,0.33802233821894184,0.15663313394140146},
{-0.7161110527989907,0.3628545991124599,0.13689072196147528},
{-0.6980533578990161,0.37525554472785333,0.12222643727092883},
{-0.664950425521599,0.37524542150694257,0.11605287091881018},
{-0.7339977185456874,0.3498057673587931,0.15134881262610736},
{-0.6870531463769791,0.3904302528727303,0.100522251638763},
{-0.6701159321914696,0.3839311450481731,0.10317293711401891},
{-0.7464956339613815,0.33771864159162596,0.1615876513754527},
{-0.6800127126342592,0.2997869328398886,0.18453912438401535},
{-0.6778687210056301,0.29227550292427884,0.1959405351347694},
{-0.6784798438679656,0.28388335278945365,0.20733661787451788},
{-0.669483497285112,0.2768578374775491,0.20277797165817826},
{-0.66811579685999,0.28461222469501135,0.19090023672352896},
{-0.668060918346633,0.2917187257742,0.17859679370953707},
{-0.6684035094542892,0.2942900238854734,0.17326665149959536},
{-7.43257535272896e-05,0.6427920269512107,0.12080492393465088},
{-4.875130070069984e-05,0.6007604137307107,0.1431793733513136},
{-0.03816054682442553,0.567839699329683,0.1462712181378282},
{-0.0420302812177489,0.5426430024833858,0.1514239375812855},
{-0.07784357279368398,0.5486561957042378,0.1452263951796419},
{-0.08440288714260369,0.5265774508983826,0.13394433187541194},
{-0.1300639414600775,0.5275998962103455,0.11453545338443251},
{-0.17235982402645253,0.554558033495074,0.08852676766089128},
{-0.20479142701717165,0.5889061220444858,0.05097814290045198},
{-0.2349112060325872,0.6252687315550918,0.03892671480702211},
{-0.24460712046046804,0.6487647272884207,0.02910239531390777},
{0.02339396432257269,0.6368699427185537,0.12291854590054842},
{0.04006371235560423,0.620723405366266,0.12866001056011783},
{0.046584132224183505,0.5970451916565478,0.13700154459039052},
{0.040323186491574,0.5736504281323244,0.14507774367258736},
{0.021393296189992597,0.5588199094984051,0.1509167109335581},
{-7.43257535272896e-05,0.5543251994141318,0.15235420830285268},
{-0.02040601575066615,0.5567142795490159,0.15138237909544228},
{-0.02065003865471986,0.5536874364967689,0.14843545620827836},
{-7.43257535272896e-05,0.5331271748274924,0.15243625967233798},
{-0.02600362411308598,0.5128706097855315,0.1520968653712851},
{-0.05468111054930196,0.5072522221801903,0.1446403139690325},
{-0.053344312588012095,0.5271241048275509,0.14081693327145736},
{0.02629400071288786,0.6318589483678437,0.11229609035880425},
{0.04017133817791613,0.644087799227758,0.1050047072977234},
{0.077419463117643,0.6270200487726129,0.11984268514705045},
{0.07063637230649063,0.5932591070360115,0.13432475186120746},
{0.041397846311391324,0.571929480577535,0.14152928834289802},
{0.022213277083745132,0.5541126117750109,0.14238070450158324},
{-7.43257535272896e-05,0.5502759110499218,0.14746149579646572},
{0.04427284104998046,0.5442121017245174,0.146476879362642},
{0.02584431658402032,0.5128706097855315,0.1520968653712851},
{-7.43257535272896e-05,0.5130528277619211,0.15799071114561294},
{-0.01562039626549054,0.49433499229836003,0.1556666327449966},
{-0.02756153453110574,0.4793728717926039,0.15105523921970215},
{0.038230343768598074,0.6614288766474876,0.09391711639519564},
{0.0455915237738515,0.6551119867993198,0.10474470036065306},
{0.08040687888844902,0.6742853672038546,0.08317691181022904},
{0.10791167010234576,0.6483496752310891,0.09947103506737004},
{0.11118253605864648,0.6256837836124234,0.1146537352287555},
{0.11214211084074414,0.6082920900881412,0.12204368649343883},
{0.09664239402452908,0.5828321894981707,0.13404609688561775},
{0.07946328813936797,0.5486561957042378,0.14464351077563586},
{0.01546108873642488,0.49433499229836003,0.1556666327449966},
{0.012203542807638012,0.48348289948227713,0.1497829101915793},
{0.02740222700204008,0.4793728717926039,0.15105523921970215},
{0.054521803020236306,0.5072522221801903,0.1446403139690325},
{0.05314344657310323,0.5271241048275509,0.14081693327145736},
{0.08424357961353802,0.5265774508983826,0.13394433187541194},
{0.11873765566450153,0.5499823376435167,0.13291069774033726},
{0.12990463393101181,0.5275998962103455,0.11453545338443251},
{0.14310531399833656,0.5553780143888265,0.11595270431190603},
{0.1704055095896206,0.5293917063115087,0.08475506867006985},
{0.16734510006803868,0.5559955308643685,0.09712777582713376},
{0.19170583198756655,0.5677587135623987,0.06440579623661272},
{0.19758635773438052,0.5361742643215605,0.05132552921801316},
{0.21918824555524002,0.5524422803247744,0.014576638909505338},
{0.22281821945331406,0.579623128469534,0.032503797539844205},
{0.2030560938326674,0.5875698568842964,0.07201419595252317},
{0.19571942267803946,0.6015702714035526,0.05471467701863686},
{0.21391404746085643,0.6193972634269873,0.04789801973814958},
{0.2360636548130854,0.605933379615989,0.03739651004623116},
{0.23475189850352154,0.6252687315550918,0.03892671480702211},
{0.22838812215850512,0.6370622839158536,0.04216188308958572},
{0.1975495944584423,0.6762492720604965,0.040032809891772124},
{0.17971567602070038,0.7209534156013754,0.017713771789567016},
{0.16453510706371713,0.7175317669336178,0.024420139242239625},
{0.1883113561759373,0.7457451836112513,0.009465477951891267},
{0.22477519789564876,0.7669533314188013,-0.017420198383161774},
{0.22222947423720196,0.7680162696144065,-0.01578503180556169},
{0.21376219914719854,0.7714480415030746,-0.02514155193238966},
{0.2272926830957662,0.766021995095033,-0.04133604138372708},
{0.21362367086105452,0.7630761378100703,-0.03580769716437926},
{0.1787539700342005,0.7451580367984408,-0.009153256506966634},
{0.18095284017618665,0.7508877798337981,0.0017515836180711283},
{0.1486565686650082,0.725245661267438,0.012671874975024955},
{0.15414442000071396,0.7314511956855898,0.02208007680860666},
{0.12427079509375433,0.7144239381140866,0.04293604308869061},
{0.07207333687468463,0.6846819150789638,0.07430044547500018},
{-7.43257535272896e-05,0.49558014847035475,0.15865404851580261},
{-0.01236285033670367,0.48348289948227713,0.1497829101915793},
{-7.965376453282913e-05,0.474149289802773,0.1492948643834719},
{0.1493774485540577,-0.9991256733939909,0.15178304552305882},
{0.1752444091848516,-0.9609392857161886,0.19609771145943278},
{0.15326476538369938,-0.95621813516418,0.1530900066227177},
{0.15595434533929572,-0.9544572275268493,0.09374928404852113},
{0.19113999721877825,-0.9185155308856806,0.10155588577383766},
{0.19391482535046323,-0.9385147529960738,0.14291030879553385},
{0.19550576943671732,-0.9522045444737071,0.17470947687989546},
{0.21131717489675644,-0.9641302315074062,0.21426889299382537},
{0.20891530753545925,-0.9991256733939909,0.21377285516920966},
{0.17205559459803618,-0.9991256733939909,0.19488079374576756},
{0.2487752234701016,-0.9493966826737877,0.1707704783435001},
{0.25363756631375695,-0.9634024252040495,0.20021146875680987},
{0.2536253118884442,-0.9991256733939909,0.19818789017690597},
{0.24782364070451224,-0.9372163167140238,0.13407273694064542},
{0.2454356261718294,-0.9164839602892684,0.09444085987704016},
{0.2869871856007306,-0.956717369795399,0.1272326364117338},
{0.2767488796524858,-0.961150274952008,0.17306312147918373},
{0.275052440948322,-0.9991768222996441,0.1733620228965945},
{0.2861778607289891,-0.9991256733939909,0.1265357325722092},
{0.13269438049351234,0.7468486146904985,-0.0016631386353791575},
{0.11182349578261287,0.773057633627848,-0.012691588615745434},
{0.10559558371823771,0.7799717935097368,-4.3423289695138864e-05},
{0.09909807429698225,0.7808828833916839,-0.003491179211379773},
{0.10527856706340812,0.77405983249799,-0.01629119285108795},
{0.08791511199745533,0.7476483491424301,0.010583827461954012},
{0.09451065682121272,0.7470207094459773,0.01390850632941068},
{0.09213489671384265,0.7562429636954657,0.017330687798268723},
{0.08599223282555611,0.757113560693771,0.014469013087193441},
{0.08984917999246618,0.772419870710485,0.01221419882964911},
{0.09642874078320694,0.7715897665958218,0.015526090470692483},
{0.12313219914187053,0.7418882364443411,0.02425283969666568},
{0.11494943983956292,0.7303882574899847,0.02278443986353899},
{0.13114179808649812,0.749480652127235,0.013569112028357814},
{0.1484311937994739,0.7253367702556326,0.019094792242202865},
{0.13869531928905152,0.720001832835786,0.02692164040934044},
{0.13249085047310072,0.7129560710820604,0.025844316584020345},
{0.43957875679388003,0.4348408230072041,-0.028618611914604762},
{0.4684491172284965,0.45553268654831736,-0.007693381491448798},
{0.4475132307833295,0.4713147879478261,-0.014083265090392361},
{0.42804148176248474,0.4508962513712969,-0.03138012001877591},
{0.41023740018637384,0.4588834726697011,-0.011552992663861636},
{0.4257760114829293,0.48435349648058235,0.009634375900766868},
{0.4612626959842248,0.49671394921233347,-0.008652423472445919},
{0.4845999169895885,0.47465545084829924,-0.002101101140034509},
{0.48147557133594016,0.47665984858858323,0.003008461414277904},
{0.4581303583140681,0.4448020723831607,-0.003417652659503324},
{0.42719006560379946,0.4262664548959893,-0.03373563368432493},
{0.4300618635357853,0.426124729803242,-0.0690214521707116},
{0.4200265548068516,0.4387483862786667,-0.07154106857523124},
{0.37569537203636044,0.4675894426527527,-0.044151895200154716},
{0.38410563740860465,0.4721853849461311,0.010452225590117187},
{0.40466589907788114,0.5093274824668479,0.02774694931409851},
{0.4406560806192001,0.5149863629558314,0.009341335295462194},
{0.4795308473189182,0.5088213214213216,-0.02033675160759411},
{0.48872699431447947,0.4827540275767194,0.006831842111853074},
{0.49600878695575035,0.5082949139339743,-0.00900460499991208},
{0.4995748247217579,0.5341597433603659,-0.035486950901845775},
{0.4761448963248978,0.5400919508139335,-0.047514935746851276},
{0.5038196510898713,0.542491154169728,-0.07643164987721597},
{0.47043113732255726,0.5530294271375847,-0.10015728288488353},
{0.4909562341191972,0.5218903996168095,-0.12693533339762467},
{0.5338168858521595,0.5145105715730367,-0.10895649306053207},
{0.5123769695658683,0.47945385755988806,-0.13929791733377803},
{0.544996651345083,0.48013211336089345,-0.12209536820019253},
{0.5464362799187797,0.4432228499211188,-0.12534811891907444},
{0.4866155035529841,0.4377158177457931,-0.1421643872547583},
{0.5231358221893543,0.4107273107983333,-0.1262640040109267},
{0.5722659444725349,0.39479336108516677,-0.09935275322304706},
{0.5509858685164101,0.37942631174298963,-0.10247443487119266},
{0.5681585807883645,0.3959575314898771,-0.09066383287521318},
{0.5497689508027447,0.38200773307517355,-0.0934002993276583},
{0.5146525630663342,0.3813396004950787,-0.09384252424111807},
{0.5101791650260833,0.3762071274934425,-0.10454383434574421},
{0.48119744916145096,0.37652094734166885,-0.07717757141799152},
{0.49008936672859593,0.3829390693989416,-0.071217658307195},
{0.4800434019776511,0.38406274692001013,-0.0458078410206764},
{0.4654457174246739,0.38174452933149977,-0.043979800444675796},
{0.4249943922684167,0.42049621897699,-0.07211489536052784},
{0.44184635827783764,0.41639631450822734,-0.1039273834724033},
{0.44565482054459726,0.42334084405284744,-0.10139125023376647},
{0.441311958773982,0.4351647660763408,-0.11256142530688011},
{0.4617720538363544,0.3931837689603931,-0.008753122880450614},
{0.4894771782640594,0.4203038777796899,0.01948267144340614},
{0.5126119348512126,0.45441913224815966,0.02224950755858282},
{0.4960887071208334,0.4190485983867849,0.012377768767519174},
{0.47843061304627427,0.3968584981509139,-0.016469148418672964},
{0.14672836148210347,0.7929396394961193,-0.027679816375428695},
{0.12722784120182878,0.7925549571015194,-0.04907018215936825},
{0.1222322980830349,0.8005927945044764,-0.03370686242489502},
{0.1408222612824629,0.7898318106765881,-0.012259486923196183},
{0.11620791603907137,0.7950857623291506,-0.019168851595179844},
{0.11323435309687975,0.801665855920992,-0.03709068221451317},
{0.11815157445389217,0.7918159619750511,-0.052166289354687284},
{0.12386213664962945,0.7776333294794053,-0.05354198179631759},
{0.1602023685140124,0.7789999643023263,-0.035879625312954036},
{0.1705259226383458,0.7725514725823217,-0.012136409868968214},
{0.16410087416676566,0.7654955876076857,-0.0006092580584834375},
{0.141899585107783,0.7646047441675596,-0.0044454259824719},
{0.11272020003484519,0.7796984665451525,-0.013408738897091056},
{0.10714337091534695,0.7960778379783822,-0.022390699850229605},
{-0.6711831327958792,0.36013145268752866,-0.008266675475644856},
{-0.6627797938379422,0.3637758122153177,-0.017143141810873716},
{-0.6538788186520879,0.35858259988821833,-0.019781040059716336},
{-0.639427654401763,0.3489351703604878,-0.016873011652892865},
{-0.6281727639536613,0.3708418204108643,-0.04694164176265521},
{-0.5991787936637162,0.36387704442442287,-0.05627045623225439},
{-0.617237554165892,0.3821393349470103,-0.05616762561984748},
{-0.5910487816703635,0.3949047165151825,-0.08144370983012701},
{-0.5740577545736978,0.38978236673445676,-0.0903500130269869},
{-0.5629163507600141,0.37172254063008003,-0.08681487772481142},
{-0.5523221336765993,0.39910585319305036,-0.10432005788351155},
{-0.5418952161387585,0.37733080501451094,-0.09678145511177368},
{-0.5178072783827142,0.3920398449975038,-0.10762235910474496},
{-0.5245940988015705,0.41004905499732797,-0.11445127081054496},
{-0.5320373301763093,0.42272332757730546,-0.11873765566450153},
{0.10361569482857921,0.7805285706598156,-0.01655865900356603},
{0.17602869240486702,0.747223173864188,0.003039896679210589},
{0.1850404902196366,0.7524872487376609,-0.006175963957071141},
{0.1917260784293876,0.7530035330040977,-0.01821993283509326},
{0.18396849440532204,0.7502702633582561,-0.026180514078469875},
{0.15391052031757074,0.767024193965175,-0.04242082442445492},
{-0.6187704229321855,0.34706237449204086,0.002437298634484068},
{-0.6017117300957496,0.34941096174328257,0.02706762791089222},
{-0.575160120050744,0.35501922612771347,-0.026872622708089457},
{-0.5339895134087389,0.3650007219454914,-0.053151438589611535},
{-0.5511339872223641,0.36284447589154933,0.0075260819458748745},
{-0.5526897664359816,0.3891648502589148,0.03154475555884709},
{-0.5049720998703695,0.38200773307517355,-0.014229785393044697},
{-0.5133589219941893,0.3744456870550112,-0.07177017304846943},
{0.16550160826012203,-0.982191123213984,0.03594888945602607},
{0.2616295828220663,-1.0,-0.0448232245868527},
{0.2878487249803263,-0.9991256733939909,0.04985712938488646},
{0.15444012461152137,-0.9991256733939909,0.08837012413732843},
{0.15154967864101618,-1.0,-0.016358858590858293},
{0.23920984531185646,-1.0,-0.09570413128645358},
{0.14257357849998373,-0.999614252003199,-0.06761219325974639},
{0.1553320336538487,-1.0,-0.11375170296551765},
{0.21418950562984282,-1.0,-0.12476203770846508},
{0.1846062573226851,-1.0,-0.13116683973822416},
{-0.4926116471386183,0.38796018697056217,-0.07856125587613012},
{-0.47723554017773184,0.3997334928895029,-0.04929449142270147},
{-7.965376453282913e-05,0.13034446123951923,0.16173417167810503},
{0.01738982872043019,0.13508212862564495,0.161965940156846},
{0.01738982872043019,0.13508212862564495,0.16839418543502943},
{0.030179186338127287,0.14780701731017507,0.16775855372206858},
{0.04232598582855631,0.14162172933384423,0.15282999968564734},
{0.034861975210895985,0.1651891204146471,0.16861529789175933},
{0.44096457245642084,0.5772340483346503,-0.10835229661250387},
{0.44191828642641245,0.5671411970868566,-0.0487851335705719},
{0.41472411825413863,0.5388164249792075,0.019721899137554864},
{0.4101324383695647,0.5950003010326217,-0.048240078044705204},
{0.4055173152365663,0.5989281107459056,-0.11461004553851005},
{0.43218347751819114,0.5538797776940687,-0.14442026711450373},
{-0.5040050658728641,0.41897773584041126,0.009513430050941123},
{-0.4717375656211155,0.4133593482350698,-0.024484075374306084},
{-0.5950058954441776,0.3687969297869382,0.0494585941616721},
{-0.5732601513261686,0.40487608911204964,0.055413712062563646},
{-0.5202997219311056,0.4333122166497148,0.025643450569111503},
{-0.4749546186662603,0.4392241776614614,-0.014216998166631405},
{-0.5996577818531142,0.38655305926399935,0.0665604438872529},
{-0.615678578145671,0.394550403783314,0.0743718408224744},
{-0.6307387340539291,0.38154206491328935,0.08495273787837537},
{0.36255543129449885,0.5316593077954662,0.033167134910033876},
{0.3828583500322078,0.557392535350021,0.022724766140276947},
{0.3916810034562807,0.5781755078793291,-0.15736360425026094},
{0.476423018499387,0.5032434266996223,-0.1483326255958714},
{0.4758491917140904,0.4740480575936678,-0.15884692251420315},
{0.49505720419016097,0.46372237226493224,-0.15262167445533073},
{0.4813439694641033,0.44401246115213966,-0.14809872591272824},
{0.46039636139472406,0.45131130342862846,-0.14951597684020176},
{0.47547143573379763,0.4141388362451801,-0.13160213823737674},
{0.3432035625212787,0.49515497319211266,0.015846836733225966},
{0.2856200179767091,0.5300800853334243,0.006013992422502755},
{0.31222490813177023,0.5641042308136991,0.024656170129785028},
{0.34675468185647085,0.5786209295993923,0.020559995268726233},
{0.2575493919940241,0.615439084050972,-0.19340759870273586},
{0.24540738771350004,0.5402033062439494,-0.06900067292779},
{0.45272562395004884,0.4942742529728969,-0.150619407919449},
{0.4698349328910374,0.48196441634569837,-0.15404425339380978},
{0.45256098840997766,0.45767880938134864,-0.14305469789378397},
{0.0832280607158822,0.8453070612662658,-0.15678711345946153},
{0.08972024212613212,0.8521301121599597,-0.13753274728764278},
{0.1060633830845241,0.8507634773370387,-0.15233076505442827},
{0.10740550905681949,0.8301525995632096,-0.17832133554055069},
{0.12469224076429251,0.8398202755327612,-0.168533246522274},
{0.12905641457892994,0.8277230265446838,-0.1449877002865937},
{0.11070994148245512,0.8420473841330766,-0.132853688022578},
{0.09586290601441866,0.8398000290909401,-0.11993059732864182},
{0.08114747241821901,0.8473418286692813,-0.13059834096393308},
{0.06480699546532982,0.8380487118734193,-0.14666708935553976},
{0.08554201589558802,0.8239065722614156,-0.16403054442149254},
{0.10125964836192965,0.8115866124133065,-0.15150279214416745},
{0.12218541158618616,0.7954198286191981,-0.166878899105054},
{0.12745374886846364,0.8041460450440707,-0.19077662686820043},
{0.14468720046588127,0.816223047590327,-0.18179573151726303},
{0.1477231011368377,0.8123154843188645,-0.1566533803832225},
{0.1315840229999579,0.8005118087371922,-0.1524240052470252},
{0.11519452834581773,0.8163040333576113,-0.13949452093988243},
{0.10077959457033053,0.8244633494114945,-0.12400013213467294},
{0.06976684091038657,0.8163647726830744,-0.1551540780862637},
{0.08883312829370979,0.8056645281806495,-0.1456302584138618},
{0.09868888305175683,0.811282915785991,-0.13301246275054304},
{0.1530361937115617,0.7694638902046116,-0.14978770540148428},
{0.16994676784204366,0.7633595879955649,-0.16119977217424938},
{0.1750893640645904,0.7712860699685062,-0.18452900116310478},
{0.18555784008827447,0.7572957786701603,-0.16441096440728806},
{0.1884584092796902,0.7595330104913866,-0.18248197933477653},
{0.17285532904996767,0.7371404458373049,-0.18625154712119574},
{0.1535652652044118,0.7550889165116659,-0.19296537378927608},
{0.15254495109685098,0.7490858465117245,-0.17993359167082693},
{0.09352604038738901,-0.5191597939764704,-0.03555887905042056},
{0.10915416226883758,-0.5109440010059284,0.05070854554357169},
{0.0981001378356447,-0.4706882138535745,-0.019369717610088686},
{0.08902333828660755,-0.3845129638499781,0.023771720302865465},
{0.09112417302609178,-0.4489840282214087,0.03925598588716445},
{0.10072578165917459,-0.43592720445123345,0.08399635990288103},
{0.1255079592492406,-0.48133357984264247,0.1056467326238909},
{0.14125649417941435,-0.5166657520247774,0.09911565673330056},
{0.13548945506701837,-0.5275604689289046,0.09159730040338372},
{0.11998973825080332,-0.5498454077606743,0.04507470670631419},
{0.09123233164950424,-0.5466597899804622,-0.008786156548684962},
{0.09644419201512301,-0.5417873239158962,-0.054565492710481736},
{0.10553377879057346,-0.5855995584144478,-0.08821614461926831},
{0.15353010033177522,-0.5802385137406739,-0.11543642004546925},
{0.21521461494730862,-0.5784589580648237,-0.11907438596005164},
{0.21303918805374683,-0.6396351804304288,-0.1224859114068986},
{0.280592506791882,-0.6405968864169287,-0.0648767924095024},
{0.2706962591501929,-0.7211660032404963,-0.04741476913994712},
{0.2561529203094722,-0.7219188511955791,0.009487855598114533},
{0.2249909823413731,-0.6543149163528913,0.07098588982845402},
{0.17316701769379172,-0.6567599406033332,0.06891808875720415},
{0.1766504712892135,-0.5540161747758106,0.10436641157925977},
{0.1951802279642789,-0.5357368346180057,0.11165299943043562},
{0.21077691458079476,-0.5116131991882242,0.10409095341027337},
{0.09245883978297945,-0.6050968818881192,-0.03428814842559938},
{0.1010726351756352,-0.6313709025597364,-0.0695201540008301},
{0.15301594726974066,-0.645860428489301,-0.11567191813191409},
{0.1976710731093686,-0.7348350154752079,-0.10440317485519797},
{0.2553020369518875,-0.8152703992225366,0.0031880153851645884},
{0.2255546859057592,-0.7407794773540884,0.0440202933283179},
{0.17901930498227636,-0.7443044894353534,0.04679458865890234},
{0.22652331830656627,-0.8090456839647647,0.040682827234447945},
{0.18515397685405457,-0.8114049272380177,0.041114928926997196},
{0.22580350401971788,-0.8562593206892528,0.04462715378184886},
{0.18736776542685624,-0.857866781609624,0.042613698422855464},
{0.22754416521522766,-0.8653201362052734,0.023275149677149182},
{0.18512840240122796,-0.8670000580753199,0.026091003493576823},
{0.2569681059933197,-0.8242230561151447,-0.04520630857815099},
{0.19567093777788905,-0.8094697936408057,-0.10320117557234826},
{0.19469324775837255,-0.8632763111835484,-0.10755735737047738},
{0.25270729559218974,-0.9128044358888427,-0.04374057275052707},
{0.2542087290935508,-0.8622629234902948,0.017096255314024988},
{0.14996352976466706,-0.9467353411765207,-0.0111773678879711},
{0.15330099585853704,-0.9145195226315259,-0.02988135052291763},
{0.13797870180880645,-0.9342571394015471,-0.06358847934836294},
{0.14433715014281734,-0.9118400658968401,-0.06454485732385729},
{0.17987445074866545,-0.8846565537465774,-0.09430499559639889},
{0.1577930419373074,-0.899233459056633,-0.10082541546497817},
{0.1859686297368016,-0.8926629558846018,-0.1171978604839006},
{0.19645468819680392,-0.8857285495608919,-0.09666796847735569},
{0.21470845390178236,-0.8984491758366175,-0.11244793867246211},
{0.24386652693069802,-0.9203643507046028,-0.04036421217631666},
{0.23971920316398607,-0.9398520837584643,-0.09712351341832931},
{0.2642648170654061,-0.9451619795265849,-0.04563041825419194},
{0.2630463009484392,-0.9258308899962864,0.020662825881133145},
{0.23497514216465365,-0.8786039332442844,0.045545170078103325},
{0.18645294593720513,-0.8826846568734272,0.05204800751036432},
{0.16537533439929072,-0.8928696827116166,0.0003801535852452525},
{0.1694070403271825,-0.9151135958586436,0.04524946546729588},
{0.1845646988368419,-0.9310017246771625,-0.12829983701614334},
{0.21534355281364267,-0.9331228058584677,-0.12469010955989031},
{0.2869136590488541,-0.9534235933917745,0.05391707377110759},
{0.1599684688308692,-0.9510398412678961,0.040940170166015505},
{0.15455041443933606,-0.9303485105278834,-0.11059112683703157},
{0.2177475513793421,-0.47755335603421223,0.12069410130573567},
{0.21754242295562884,-0.41384419723657373,0.1570492516009341},
{0.21868421571411598,-0.3936909956081205,0.12407792109535382},
{0.19633107834147542,-0.33684165098011426,0.19733647401822074},
{0.19220666502208728,-0.3188143257428712,0.16125838029531034},
{0.15782128039563678,-0.5195476731776737,0.10561316615455602},
{0.14467121643286465,-0.488453400949345,0.12412640599550423},
{0.1572586424334518,-0.5162746760169707,0.09682727600642133},
{0.13891216933697698,-0.4769310443487652,0.10473670834414477},
{0.12509077598750687,-0.4355382596478291,0.15985444939535068},
{0.20719702398617273,-0.5105230881364908,0.09622307955839315},
{-0.6408651517710575,0.4929379878127077,0.021668221557878457},
{-0.6839080214804091,0.43055870056205187,0.004139598150753947},
{-0.6629700038308399,0.446310432298829,0.05201177703552665},
{-0.6300189197670807,0.47620430364760963,0.032081819068205474},
{-0.6420959223133371,0.45477344498002786,0.07005242230028352},
{-0.6669585528695868,0.4329275342551148,0.08568054418173206},
{-0.6846827142806146,0.43504328742541454,0.06291182195065943},
{-0.7040340502527342,0.4223791380663475,0.020382572502241767},
{-0.6907252115619971,0.4108690358910806,-0.02667228949428117},
{-0.6536497141788497,0.45418629816721745,-0.0300252068200672},
{-0.6612069649891069,0.4756475264975307,-0.019889198683128793},
{-0.5925816504366571,0.5308798197853558,-0.01519895059495234},
{-0.5763610537313926,0.5174665520789099,-0.003682454806478641},
{-0.6155277954342143,0.474898408150152,0.05226166075168646},
{-0.6254139198549928,0.4522932558569494,0.07796664984791193},
{-0.6235059591139092,0.43859653796500886,0.09246097098738168},
{-0.6694600540366876,0.4032867434290972,0.12053479377667004},
{-0.7066074795684097,0.3969091142554665,0.10238652268960127},
{-0.7364294227686157,0.3907845656045988,0.06267525826201348},
{-0.7365791398778714,0.3768853832944478,0.03815521881341999},
{-0.7307518942411128,0.3690196406469696,-0.0006998342455776114},
{-0.7003774362996324,0.38780833865690434,-0.027945151323504565},
{-0.6787835404952812,0.3999764501913556,-0.030963469558142713},
{-0.6627211857168812,0.4313989278976255,-0.05081936817248689},
{-0.6046298817234836,0.48856475637936075,-0.07108126122545318},
{-0.6124876323544535,0.5135792352492684,-0.059193935870993926},
{-0.5452028453709974,0.5643573113364624,-0.050554566025511574},
{-0.5341514849433073,0.5423190594142492,-0.02943113359294954},
{-0.4971196772504053,0.5295840475088085,-0.00455145340148214},
{-0.5286199439173561,0.4993966027536226,0.041181529064566444},
{-0.6041471639263818,0.47020123364766814,0.06333593162670038},
{-0.5964332695925617,0.45665636406938565,0.06494072854156888},
{-0.6151724171001447,0.4424433619110083,0.0745316811526406},
{-0.6631554186138328,0.3934267262622458,0.11873712286340099},
{-0.7026429065791878,0.3842145952336679,0.10616621369693102},
{0.1789111463588639,-0.5368525201225656,0.1104835010147197},
{0.17514104577134415,-0.8626774427465257,-0.10730001443890981},
{0.14620674920466115,-0.8787914792316796,-0.07195292382595944},
{0.14164224217621543,-0.9044117529529169,-0.025571522420536702},
{0.15564052549106944,-0.8660117120337923,0.021755600938369306},
{0.14746415980196845,-0.8157744290636606,0.011691520950005682},
{0.14073221789646928,-0.734337912048391,0.012383096778524713},
{0.13732602046062783,-0.6398610880970634,0.02851524850109731},
{0.1363744376950385,-0.4618890036779259,0.09489107680700826},
{0.1212338288205968,-0.43546633149925434,0.08730825154392441},
{0.1323858886562916,-0.42694257949259223,0.11902270425329792},
{0.11337927499623042,-0.3887204941410527,0.09591938293107738},
{0.13488792262449298,-0.3894584236653199,0.1361165619623704},
{0.1598033004896975,-0.3785535835402821,0.1385440037764942},
{-0.5122336460698194,0.4396189832769719,0.0428944846028474},
{-0.4748981417496016,0.46584824865614244,0.017903981782464776},
{-0.4812565900836125,0.4598553018771115,0.0009204139012069616},
{-0.4823626851683625,0.49136888857157635,-0.0028155874158773573},
{-0.480012499513819,0.49473992113478105,0.013751330004747264},
{-0.4876464736825561,0.5107244869525002,-0.008938004862342835},
{-0.4885772772052238,0.5199872340856306,0.00630703302780743},
{-0.4850394778975456,0.5216271958731359,-0.03324439106961418},
{-0.4926350903870427,0.5399907186048283,-0.023432326001812585},
{-0.4858775740287169,0.5398186238493494,-0.052297891226524104},
{-0.5022926431356837,0.5540417492286372,-0.04405705660425612},
{-0.511899579779772,0.5601359282167735,-0.06006027046049465},
{-0.4891436447751127,0.5482006507632642,-0.06881579094589776},
{-0.5277461501124476,0.5508124417581797,-0.0823787757615992},
{-0.5115958831524562,0.528338891336814,-0.11809190073063014},
{-0.5360098951820395,0.5347266437313553,-0.1130057814247421},
{-0.5402392703182368,0.5016135881330278,-0.13191808929000523},
{-0.5265963653374522,0.49289749492906565,-0.1301028359404179},
{-0.5372955442376762,0.4686625040692683,-0.12923330454431387},
{-0.5583902054108083,0.47165897745878377,-0.1386031446986557},
{-0.5532657244256803,0.4425243476782927,-0.13622205658028008},
{-0.5365938451882466,0.44328358924658195,-0.12610736048736382},
{-0.5449891921296753,0.41869428565491645,-0.1310181882311696},
{-0.5832496391604546,0.3927079775775984,-0.10423001449751794},
{-0.6115237951635513,0.41041349095010693,-0.0948660351552822},
{-0.6421193655617615,0.3983162419620293,-0.07396851038935506},
{-0.638041838739222,0.37426346907862185,-0.06213553074715231},
{-0.6608180201857025,0.359038144829192,-0.034579057826501836},
{-0.6741582941413724,0.3666508069539069,-0.029184446683393064},
{-0.6852767875077322,0.3572767043907607,-0.016736614571151047},
{-0.6800793127718284,0.3499272460097193,-0.011797015567915346},
{-0.6714021140482068,0.351152155739893,-0.003486916802575341},
{-0.6837572387689524,0.3430535790114729,0.005823782429604995},
{-0.6906452913969139,0.34363060260337275,-0.003661675563557035},
{-0.7011436042822291,0.34916800444143004,0.014905909989647683},
{-0.7035998173557828,0.3490971418950564,-0.000800000852481755},
{-0.7252858877505298,0.3576006474598974,0.0022289734041674707},
{-0.7103871705757395,0.359696154188376,0.024570921953696395},
{-0.7269754000403863,0.3623383148460231,0.04087570123284848},
{-0.7511587091934298,0.36666093017481743,0.05759926217703597},
{-0.7468227738371217,0.3553229227550293,0.06035863907680488},
{-0.7496359636480465,0.37044701479535375,0.06776883678330926},
{-0.7469261372506292,0.36009095980388656,0.07418163082957664},
{-0.7291742701823725,0.3731499147784639,0.06880513492388671},
{-0.500148118705954,0.4754248156374993,0.038870237890363396},
{0.17682576285129575,-0.8095981987060392,-0.10138432381945928},
{0.13528379384220454,-0.8177100954619732,-0.04007117157101199},
{0.12907133300974546,-0.7374297568349056,-0.046401914247794065},
{0.10995869193067404,-0.665021554468523,-0.00719201565582753},
{0.10106730716462967,-0.6272518172513536,0.007623584547276249},
{0.09227875301099221,-0.6003229840271558,-0.011218926373814313},
{0.11472566337733026,-0.68370688906495,-0.060160969868499344},
{0.1765785431406387,-0.7357322525285408,-0.10299071913762944},
{-0.5932194133540203,0.39286994911216694,0.0867424167751361},
{-0.6267667018492994,0.39054160830274603,0.09808948181363364},
{-0.6471772464093202,0.3811978754023314,0.10719984783200569},
{-0.6280038660047856,0.3753972698206006,0.0962768924695491},
{-0.6359484632151456,0.36894931090169664,0.10127296838944351},
{-0.6393194957783506,0.3629659545424758,0.09652357937910556},
{-0.6283890812004861,0.3702749200398749,0.08889706442577629},
{-0.6920827887662085,0.38159268101784194,-0.028310120077384024},
{-0.6483653928635555,0.41745925270383244,-0.07237969750750316},
{-0.6558555107351429,0.41844120513215344,-0.05254990614708613},
{-0.6027917179265725,0.4483553229227551,-0.11077441041562214},
{-0.5621501827774176,0.5199264947601675,-0.10160010826518362},
{-0.5633974701538144,0.5468137694985223,-0.0950732947833977},
{0.1121655540891685,0.7997626903898133,-0.12976344163936504},
{0.09961968657442458,0.8550152301194595,-0.10796867982010502},
{0.12592727371537657,0.7960272218738296,-0.08919223623548315},
{0.14573095782186649,0.7891029387710302,-0.13249031767200017},
{0.15559949980632679,0.789578730153825,-0.10958359995588406},
{0.11541510800144707,0.8362467785513458,-0.06253886118027165},
{0.1290915794515665,0.7847094608958625,-0.06633133941401469},
{0.09007508765910105,0.8700785828343207,-0.09559011185093502},
{0.049549170348766255,0.8847471299336717,-0.12647392764454493},
{0.10239984271711511,0.783737631688452,-0.19179534257245962},
{0.12370016511506104,0.7828467882483258,-0.15905258373901696},
{0.12441997940190944,0.7749000598335637,-0.05064407661040464},
{0.8073207404017213,0.26775706187898696,0.10214196698444701},
{0.7758364577677872,0.2857460254369901,0.08854807970491343},
{0.7901608153561802,0.3020950272074882,0.08892583568520619},
{0.8185292771540749,0.28661662243529534,0.10081262823856489},
{0.786203701582366,0.3090901728566611,0.11432659535301536},
{0.8142087930296829,0.2924678441215788,0.12227012696117426},
{0.8034073163181525,0.2713609285231339,0.12494691969035732},
{0.7701445436105693,0.29169847933237897,0.11341816947657088},
{0.8256224582057496,0.2815853816427643,0.10394443310762104},
{0.8323293584595228,0.2550726660780989,0.11223428543114},
{0.838769858163019,0.27237325061418644,0.11117241283773596},
{0.8217037061111754,0.2869304422835217,0.12426280307724603},
{0.8551801320600807,0.2573098978993251,0.12050122730733513},
{0.852984458724698,0.24346133169372677,0.12453559724072967},
{0.8443727945364443,0.24715630732606841,0.11904561470062174},
{0.8457356997516614,0.26683584877612915,0.11488550370749646},
{0.835996095633535,0.2763213067692913,0.12869091302394994},
{0.8288166008035707,0.2575731016429987,0.1290921122526671},
{0.8421121194667939,0.27111797122128145,0.13074805807318876},
{0.8524287471768202,0.2602456319633775,0.13357669911602973},
{0.8417657987514339,0.25014265749467335,0.13372748182748645},
{0.8599859979870774,0.2522482874440626,0.12508544797650134},
{0.8581009476933175,0.2544247799398254,0.1338207220200834},
{0.8500732335112711,0.24659953017598954,0.13512928152304393},
{0.7231573473538166,0.2984309540389788,0.12377688847354083},
{0.758271603885825,0.28810473590914254,0.11141696854289022},
{0.7482698616262262,0.2961324500911888,0.13404130167571277},
{0.7181991003120616,0.3024797096020882,0.15273995629965376},
{0.7352545963418942,0.304615709214209,0.16091419078435248},
{0.7591272824533146,0.2998577953862622,0.14465043718994308},
{0.7607528586111048,0.2955453032783784,0.13933468060971627},
{0.7688184016712906,0.29107083963592645,0.11815317285719387},
{0.7284832271549541,0.29716501862406236,0.10081742344846988},
{0.8000687846220814,0.2751672595854915,0.15017665020488868},
{0.8029698866145978,0.27218090941688655,0.12713246980482962},
{0.8280003495175219,0.2578261821657619,0.15407728706204418},
{0.830771448041503,0.2557509218791043,0.13702232383331214},
{0.843402030931235,0.24750049683702632,0.15750000133200276},
{0.8442976695812663,0.24585041182861078,0.1424100085621137},
{0.8516982768679606,0.2436739193328477,0.157640660822549},
{0.853336640252164,0.24147718039526384,0.14654934031231734},
{0.6837487139513435,0.43055870056205187,0.004139598150753947},
{0.6628106963017742,0.446310432298829,0.05201177703552665},
{0.7038747427236686,0.4223791380663475,0.020382572502241767},
{0.6905659040329314,0.4108690358910806,-0.02667228949428117},
{0.7002181287705668,0.38780833865690434,-0.027945151323504565},
{0.7305925867120471,0.3690196406469696,-0.0006998342455776114},
{0.684523406751549,0.43504328742541454,0.06291182195065943},
{0.6667992453405212,0.4329275342551148,0.08568054418173206},
{0.6419366147842714,0.45477344498002786,0.07005242230028352},
{0.6286693345793776,0.47613344110123595,0.03296626889512504},
{0.640705844241992,0.4929379878127077,0.021668221557878457},
{0.6610476574600412,0.4756475264975307,-0.019889198683128793},
{0.653490406649784,0.45418629816721745,-0.0300252068200672},
{0.6625618781878156,0.4313989278976255,-0.05081936817248689},
{0.6786242329662155,0.3999764501913556,-0.030963469558142713},
{0.6919234812371429,0.38159268101784194,-0.028310120077384024},
{0.6153684879051486,0.474898408150152,0.05226166075168646},
{0.5758543598847659,0.5181245614380942,-0.0010104572872005663},
{0.5924223429075914,0.5308798197853558,-0.01519895059495234},
{0.6123283248253878,0.5135792352492684,-0.059193935870993926},
{0.604470574194418,0.48856475637936075,-0.07108126122545318},
{0.6026324103975069,0.4483553229227551,-0.11077441041562214},
{0.6482060853344899,0.41745925270383244,-0.07237969750750316},
{0.6556962032060772,0.41844120513215344,-0.05254990614708613},
{0.6252546123259272,0.4522932558569494,0.07796664984791193},
{0.6039878563973162,0.47020123364766814,0.06333593162670038},
{0.5345393641445105,0.4977566409661176,0.04259877999203995},
{0.5339921774142417,0.5423190594142492,-0.02943113359294954},
{0.5450435378419317,0.5643573113364624,-0.050554566025511574},
{0.5632381626247488,0.5468137694985223,-0.0950732947833977},
{0.5619908752483519,0.5199264947601675,-0.10160010826518362},
{0.596273962063496,0.45665636406938565,0.06494072854156888},
{0.615013109571079,0.4424433619110083,0.0745316811526406},
{0.6233466515848435,0.43859653796500886,0.09246097098738168},
{0.8051303950773441,0.2795303677979277,0.22977873303095095},
{0.7980175003849488,0.281443656550017,0.22437080186032834},
{0.8128107229418293,0.27585563860740714,0.22215754608862723},
{0.8072509434575488,0.27745510751127006,0.21296512870076986},
{0.7862926793661585,0.2875479587590637,0.21092290208234654},
{0.7982029151679416,0.28320509698844826,0.1989998790541502},
{0.7642203281735098,0.29747883847228873,0.18920060121276186},
{0.7796300016037313,0.2912733040541369,0.1726954887198015},
{0.7424490096026742,0.30513252628174636,0.16439071796546703},
{0.844557143717236,0.26358629486385066,0.10349208497325073},
{0.8487513539807968,0.2592839259768776,0.10406218215084347},
{0.8504861543642004,0.25742125332934085,0.09773570188286582},
{0.8471060641822862,0.2610251199734878,0.09400769258228982},
{0.8393053232690757,0.267392625926208,0.08906010156254579},
{0.8334263959255633,0.2717456109177339,0.08559636160784453},
{0.8214911184720544,0.2793279033797173,0.07879728676367555},
{0.8173427291031412,0.2819599408164538,0.07643591228602042},
{0.7983201314100634,0.29469495272189444,0.06632281459640584},
{0.8360008908434402,0.27102686223308675,0.10053344046187462},
{0.7915578198418326,0.2999792740371885,0.0862644941879392},
{0.8133046295620427,0.2869203190626112,0.09197718758807868},
{0.817794544436411,0.2838732295685431,0.09352763879069069},
{0.8306872654676156,0.275177382806402,0.098339898330894},
{0.6785576328286463,0.28581688798336374,0.15727089685876455},
{0.677068453752598,0.280441457679875,0.16642228856187927},
{0.6682442019252235,0.2942900238854734,0.17326665149959536},
{0.6765622927070718,0.27795114533588583,0.1738111742243615},
{0.6679016108175673,0.2917187257742,0.17859679370953707},
{0.6679564893309243,0.28461222469501135,0.19090023672352896},
{0.6757806734925592,0.27164437870862873,0.1840558737858129},
{0.6770817737801118,0.2701157723511394,0.1941306097961876},
{0.6693241897560464,0.2768578374775491,0.20277797165817826},
{0.6757423118133192,0.2704295921993656,0.2013021126096438},
{0.6783205363388999,0.28388335278945365,0.20733661787451788},
{0.6827129486118666,0.2743675251335599,0.20404550547639613},
{0.6883435906425208,0.2775664629412858,0.19879261942603468},
{0.6777094134765644,0.29227550292427884,0.1959405351347694},
{0.6911567804534458,0.2826483198383694,0.19111175876044892},
{0.6931521205750202,0.28869188272195295,0.18048983601980528},
{0.6798534051051937,0.2997869328398886,0.18453912438401535},
{0.6955998088309651,0.29375349317721555,0.17270880874731534},
{0.6823144133886523,0.303613510344067,0.1772706517702583},
{0.6806462131428178,0.3134026649645447,0.16891046970146623},
{0.701627387681532,0.3277168993320273,0.15295627354647867},
{0.7238489231823357,0.32876971430672186,0.1546713602891618},
{0.7412970936232766,0.3261376768699854,0.16036380724748028},
{0.7508443565441029,0.32985289894414804,0.16275288738236418},
{0.7466485478772404,0.3320293914399109,0.15809087775251712},
{0.7629890248301296,0.3303793064314953,0.1555579413204836},
{0.769662358614568,0.31994226567274403,0.14669426221166804},
{0.7698003540996113,0.32226048326125417,0.14188146987036418},
{0.7788744896431458,0.31666234209773375,0.14132575832248642},
{0.7795074573506039,0.3208229858919598,0.12858808241154304},
{0.7849345693608464,0.3099607698549661,0.11583602087088471},
{0.784060775555938,0.31485028555474986,0.11538686954311773},
{0.6668610502681854,0.3013155391973779,0.16419731116596595},
{0.668372606990457,0.31007212528498207,0.15440123013118096},
{0.6781718848318452,0.3257125015917433,0.1579773911180991},
{0.6957436651281146,0.34299283968600974,0.14183191936801265},
{0.7068035503734136,0.3536019752002399,0.14371696966177253},
{0.7292818960046844,0.3433066595342359,0.15506403470027008},
{0.7463363264323158,0.33771864159162596,0.1615876513754527},
{0.7648895263558056,0.33802233821894184,0.15663313394140146},
{0.7838854839938557,0.3319990217771793,0.1274974385587091},
{0.7921470978590454,0.3251962173253065,0.09482927187934401},
{0.78743873453345,0.3132204469881554,0.09951152795101213},
{0.7882262145600687,0.30762230582463496,0.07981014165582861},
{0.6683672789794515,0.29902769127159906,0.1489032555745647},
{0.6597103266976508,0.30767292192918755,0.13892655496669196},
{0.6620882180094231,0.3221693742730595,0.1464667561417315},
{0.6575578102514128,0.33569399740952094,0.13065481788059183},
{0.6804677247741323,0.3503929141716035,0.13560720411024083},
{0.6912105933646016,0.3625407792642337,0.13328792091952946},
{0.6978940503699504,0.37525554472785333,0.12222643727092883},
{0.7159517452699251,0.3628545991124599,0.13689072196147528},
{0.7338384110166217,0.3498057673587931,0.15134881262610736},
{0.747049214304857,0.3528427336319506,0.1418788058648614},
{0.763510637107572,0.3490870186741459,0.11291840204425127},
{0.7735033217484614,0.34023932359834674,0.08301440747456008},
{0.7892518566786352,0.30866499757841903,0.05640632051289566},
{0.6530167464713915,0.3514457291462981,0.11133704837780714},
{0.6439095772596227,0.3327785097872899,0.09715654708656367},
{0.6525004622049547,0.32099508064743865,0.11903815548521399},
{0.8542956822331612,0.25736051400387777,0.15707376045155957},
{0.8606258921088427,0.25002117884374714,0.14710345345689346},
{0.8555104687424242,0.2555889503445357,0.1435613917404108},
{0.8420556425501352,0.2705915637339341,0.15569380560112486},
{0.8448789555819706,0.26669412368338186,0.13957177709946278},
{0.8597771399556603,0.2514181833293994,0.1561552113542046},
{0.8361596655714052,0.276179581676544,0.15404478619491035},
{0.8380963975719188,0.2727174401251444,0.1363120999662737},
{0.8151246781215351,0.29046344638129473,0.12603063712888407},
{0.8118873786345693,0.29575789091749954,0.14782113653933965},
{0.8191398672153097,0.2897649441384686,0.14934228368142116},
{0.8220420348100271,0.2849564142059693,0.12872074988558097},
{0.05566359577872342,0.4861756762444767,0.15311558107554427},
{0.0849788451323025,0.49296835747543927,0.14458170584797161},
{0.1201900714646116,0.500732867913812,0.13013853361415503},
{0.14846422746770824,0.44787953153996035,0.0984730986060325},
{0.1492096162073832,0.38512568511561523,0.04081123229968144},
{0.14147334422733981,0.3253379424180538,0.03940517019531956},
{0.1566107562951782,0.27203918432413926,0.033503865205583974},
{0.1714977518457562,0.21821401874287719,0.027415014228453397},
{0.17882376697837304,0.17953319164376058,0.029415682361033493},
{0.1428644879008862,0.14799935850747495,0.10760104706072281},
{0.12521225463843316,0.10635242768157466,0.11999453346070832},
{0.09084391964720041,0.11028023739485848,0.12294625155777722},
{0.10326138209671085,0.08607561619779273,0.1265485197986225},
{0.05712666760084459,0.07302678444412596,0.12744096164205038},
{0.06170076504910027,0.01038855585860099,0.13338116111212642},
{0.04404640058224503,0.040511531680619876,0.12050122730733513},
{0.02635314163504935,0.010615529127436994,0.09603766477540036},
{0.0383353055854072,-0.03744472854583127,0.09949607671909608},
{0.019526361133651544,-0.0429427031024475,0.042266844906394846},
{0.008542133644631243,0.023959532690810744,0.0421123325872342},
{0.7792703608608574,0.3154070627048287,0.19463677084171388},
{0.7915460982176205,0.30691368036089806,0.2103853057718876},
{0.8032554680044947,0.30096122646550943,0.19783251184283648},
{0.7934945518423463,0.30785513990557695,0.18058147780910058},
{0.8075727553222833,0.2971548954031519,0.205565054215176},
{0.7959837985841344,0.3030668564148986,0.21623279785046726},
{0.7736082835652704,0.3193854885226652,0.1880849157082019},
{0.7887941805332592,0.3112362956896924,0.17337481012300782},
{0.8178350373200531,0.28571565577425856,0.2241816574696317},
{0.8064592010221256,0.2931460999225841,0.22712751475459447},
{0.8120029964733895,0.28842867897827923,0.23075535744826633},
{0.8150932428566025,0.28939038496477915,0.2171992990468721},
{0.1781497735861723,0.4963697597013756,0.06907792908737033},
{0.20680434957506447,0.4979489821634175,0.009760649761598154},
{0.18237701751796737,0.44065155180984544,0.030685880184754117},
{0.17498706625328403,0.1799786133638237,-0.03567449688924077},
{0.17628603533643455,0.15829467417347898,-0.030894205415070694},
{0.1414653522108315,0.8105844135431646,-0.10031552481174805},
{0.12752674261923955,0.8118396929360698,-0.09349460512245633},
{0.1192054550307879,0.8029717514184497,-0.11087617542582794},
{0.12829504180623832,0.7988414772869554,-0.12063709158797636},
{0.11809190073063013,0.8092785180457069,-0.09013902379116753},
{0.1212673952899317,0.8304259265277939,-0.09298258326482399},
{0.1471860376274793,0.8241191599005369,-0.10214729499545254},
{0.1727066775429131,0.8068185753644493,-0.10272005617854803},
{0.2092824074937409,0.7816421249599733,-0.09390059956107845},
{0.21017271813276656,0.7917957155332301,-0.1092362136383229},
{0.18059533063771496,0.8170227820422586,-0.11965194235305211},
{0.1755704834583906,0.8045307274386705,-0.1368443682657271},
{0.20340507855353024,0.7838894800021099,-0.12711914977731575},
{0.18545234547036477,0.7800224096142894,-0.13144656031601498},
{0.1638589824671142,0.7833731957356731,-0.13400293999647284},
{0.1330486932253807,0.8083370585010281,-0.13817530541491085},
{0.10977327714768126,0.8213049044874107,-0.13158349019885734},
{0.10402168926720134,0.8196446962580847,-0.12989397790900076},
{0.10296780869030561,0.8345055845547356,-0.11943349390182498},
{0.10736235216767462,0.8352850725648459,-0.12309277186042955},
{0.12003822315095374,0.8394457163590716,-0.10434563233633815},
{0.10720517584301122,0.83671244671323,-0.1007407000899901},
{0.11232965682813913,0.8281482018229256,-0.09039103871172956},
{0.14181753373829767,0.8260122022108048,-0.1353653124105893},
{0.15006369637157121,0.8322278598498672,-0.117142449169443},
{0.11590102260515228,0.8246253209460631,-0.07890011737608243},
{0.12501884783893208,0.8217806958702054,-0.056460133424051595},
{0.12555857535379322,0.8253744392934418,-0.0784424412307066},
{0.1171227355287225,0.811282915785991,-0.09138897517306711},
{0.12675524662563742,0.812285114656133,-0.09068940732803978},
{0.16449354857787393,0.8016962255837236,-0.08455207145075878},
{0.16526504457147606,0.8147146876746588,-0.06804376215119509},
{0.1621795933981681,0.8103819491249542,-0.051214706589097915},
{0.13162931109350498,0.8027085476747761,-0.04883894648172784},
{0.11661071367109015,0.8022023866292498,-0.0492039152356073},
{0.1154587976916925,0.8210417007437372,-0.056339187574225846},
{0.12309383746263065,0.7933850612161826,-0.0918519793294485},
{0.1462040851991584,0.7908846256512828,-0.08669606307938789},
{0.18912441065538263,0.7728652924305481,-0.06663503604133045},
{0.19417376668533246,0.7869264462752674,-0.06693553586204286},
{0.18808757971370463,0.7969686814185084,-0.04371446549659993},
{0.17358313535332437,0.7818142197154522,-0.03473250454346138},
{0.15577958657831403,0.795612169816498,-0.044768346073495634},
{0.13078641975242863,0.7889308440155514,-0.05546272976381459},
{0.11801464457104982,0.7885664080627725,-0.05634185157972862},
{0.15042600111994792,0.7787165141168315,-0.06589444251156044},
{0.15073982096817418,0.7834136886193152,-0.05111720398769655},
{0.16815815454748403,0.7647262228184859,-0.05033025676217836},
{0.16730141037779328,0.7697878332737484,-0.040898611680172274},
{0.1964291137439773,0.758348593644855,-0.015779703794556153},
{0.20766269214805688,0.7672873977088488,-0.023486138912968527},
{-0.1316500903364266,0.7398129761576835,-0.007495179482042729},
{0.7265539543698482,0.3199726353354756,0.02883439636032913},
{0.7503968036196376,0.31916277766263346,0.03878285850987254},
{0.6999661138500048,0.33839689739263135,0.01693428377945658},
{0.7740425164622219,0.30655936762902986,0.04895989233155361},
{0.7777710585638985,0.3221390046103279,0.048733451863818174},
{0.7617470654647384,0.3342868697029581,0.04092738293960221},
{0.7409912657915586,0.34774063029304597,0.031351881560446555},
{0.7097552684704825,0.36119439088313376,0.021017671414102077},
{0.7550566820450824,0.3518304115408981,0.07211436255942731},
{0.7441438499035364,0.3620751111023495,0.09966337626467002},
{0.7854801576878138,0.3028238991130459,0.06232041272904454},
{0.737874379353318,0.3614171017431655,0.062454145805283585},
{0.719881686187611,0.3763994686907426,0.048492092965267235},
{0.7281550216770127,0.37241091965199563,0.08891038445329014},
{0.7082021532623678,0.38765649034324656,0.0792778733563752},
{0.7101308932463731,0.3770777244917477,0.11178460130227245},
{0.6647911179925333,0.37524542150694257,0.11605287091881018},
{0.6643382370570624,0.37172254063008003,0.11097207962392767},
{0.7283169932115812,0.36653945152389117,0.126538396577712},
{-0.7889534880623249,0.3112362956896924,0.17337481012300782},
{-0.793653859371412,0.30785513990557695,0.18058147780910058},
{-0.8034147755335603,0.30096122646550943,0.19783251184283648},
{-0.807732062851349,0.2971548954031519,0.205565054215176},
{-0.8152525503856681,0.28939038496477915,0.2171992990468721},
{-0.8179943448491188,0.28571565577425856,0.2241816574696317},
{-0.8121623040024551,0.28842867897827923,0.23075535744826633},
{-0.8066185085511912,0.2931460999225841,0.22712751475459447},
{-0.7961431061132,0.3030668564148986,0.21623279785046726},
{-0.7917054057466861,0.30691368036089806,0.2103853057718876},
{-0.7794296683899231,0.3154070627048287,0.19463677084171388},
{-0.7737675910943361,0.3193854885226652,0.1880849157082019},
{-0.8194126613787934,0.277414614627628,0.08149858834348409},
{-0.8111323994750844,0.2850576464150745,0.09458951138409472},
{-0.8152802560428969,0.280036528843454,0.07909725378328743},
{-0.8156111255263409,0.28202068014191695,0.0961841850780527},
{-0.8313010523354537,0.26987281504928673,0.08841221542427219},
{-0.8284713456904117,0.2733552030425074,0.10112165287688618},
{-0.8371554708283406,0.2655299532786715,0.09193509630113492},
{-0.8449221124711155,0.25918269376777214,0.09696314028706259},
{-0.8482766282002032,0.2555889503445357,0.10072951126687849},
{-0.846497072524353,0.257481992654804,0.10703627789413561},
{-0.8423071246695967,0.26177423832086677,0.10641876141859359},
{-0.8337711182376218,0.2692046824691921,0.10336954072012332},
{0.03433450212134757,0.11054344113853201,0.15196366509614662},
{0.02956220266368581,0.076306708019136,0.1543857788992649},
{-7.43257535272896e-05,0.0715184245284577,0.16144699188490644},
{-0.024293332580307792,0.039802906216883094,0.15282467167464184},
{-0.057285975129910245,0.07302678444412596,0.12744096164205038},
{-0.7286425346840197,0.29716501862406236,0.10081742344846988},
{-0.7584351738236951,0.28809461268823205,0.11141696854289022},
{-0.807480047930787,0.26775706187898696,0.10214196698444701},
{-0.8035666238472182,0.2713609285231339,0.12494691969035732},
{-0.8324886659885885,0.2550726660780989,0.11223428543114},
{-0.8289759083326362,0.2575731016429987,0.1290921122526671},
{-0.84453210206551,0.24715630732606841,0.11904561470062174},
{-0.8419251062804995,0.25014265749467335,0.13372748182748645},
{-0.8531437662537636,0.24346133169372677,0.12453559724072967},
{-0.8502325410403367,0.24659953017598954,0.13512928152304393},
{-0.8031100133040434,0.2722011558587076,0.12754752186216117},
{-0.8000458741747577,0.27528873823641775,0.15055707019068418},
{-0.8308423105878768,0.2558116612045674,0.1377037764409206},
{-0.827951331816271,0.2579679072585092,0.15472890280802165},
{-0.844332834453903,0.24594152081680548,0.14322998945586624},
{-0.8433295699815597,0.24765234515068416,0.15830559659604032},
{-0.8533425010642702,0.24157841260436905,0.1474513725755552},
{-0.8516247503160842,0.24383589086741628,0.1585213810417647},
{-0.8257817657348153,0.2815853816427643,0.10394443310762104},
{-0.8143681005587485,0.2924678441215788,0.12227012696117426},
{-0.8186885846831405,0.28661662243529534,0.10081262823856489},
{-0.8218630136402411,0.2869304422835217,0.12426280307724603},
{-0.8389291656920846,0.27237325061418644,0.11117241283773596},
{-0.8361554031626007,0.2763213067692913,0.12869091302394994},
{-0.8458950072807271,0.26683584877612915,0.11488550370749646},
{-0.8553394395891464,0.2573098978993251,0.12050122730733513},
{-0.8601453055161431,0.2522482874440626,0.12508544797650134},
{-0.8582602552223831,0.2544247799398254,0.1338207220200834},
{-0.8525880547058858,0.2602456319633775,0.13357669911602973},
{-0.8422714269958596,0.27111797122128145,0.13074805807318876},
{-0.4476725383123952,0.4713147879478261,-0.014083265090392361},
{-0.425935319011995,0.48435349648058235,0.009634375900766868},
{-0.4614220035132905,0.49671394921233347,-0.008652423472445919},
{-0.48475922451865416,0.47465545084829924,-0.002101101140034509},
{-0.47969015484798383,0.5088213214213216,-0.02033675160759411},
{-0.44081538814826576,0.5149863629558314,0.009341335295462194},
{-0.40172643540612496,0.5045493221970798,0.029173790661381996},
{-0.38418981998249213,0.4766800950304043,0.010274802823632719},
{-0.40709760330080935,0.4564134067675331,-0.015939544124722337},
{-0.4282007892915504,0.4508962513712969,-0.03138012001877591},
{-0.43973806432294565,0.4348408230072041,-0.028618611914604762},
{-0.46860842475756215,0.45553268654831736,-0.007693381491448798},
{-0.4816348788650058,0.47665984858858323,0.003008461414277904},
{-0.5127712423802783,0.45441913224815966,0.02224950755858282},
{-0.4582896658431338,0.4448020723831607,-0.003417652659503324},
{-0.4896364857931251,0.4203038777796899,0.01948267144340614},
{-0.49624801464989904,0.4190485983867849,0.012377768767519174},
{-0.47858992057533994,0.3968584981509139,-0.016469148418672964},
{-0.46193136136542,0.3931837689603931,-0.008753122880450614},
{-0.4656050249537395,0.38174452933149977,-0.043979800444675796},
{-0.4802027095067168,0.38406274692001013,-0.0458078410206764},
{-0.42734937313286514,0.4262664548959893,-0.03373563368432493},
{-0.4251536997974823,0.42049621897699,-0.07211489536052784},
{-0.4302211710648509,0.426124729803242,-0.0690214521707116},
{-0.42018586233591726,0.4387483862786667,-0.07154106857523124},
{-0.3758546795654261,0.4675894426527527,-0.044151895200154716},
{-0.3435301695959183,0.4984247735462122,0.016029054709615416},
{-0.3338342551680375,0.482804643681272,-0.0514416798579339},
{-0.28860743374751513,0.5309810519944611,0.006116823034909667},
{-0.28885145665156886,0.513397017272879,-0.0570339602093482},
{-0.24147797959691467,0.5518146406283216,-0.02161707265222526},
{-0.2455666952425657,0.5402033062439494,-0.06900067292779},
{-0.22577792956689133,0.5288754220450719,-0.0689750984749634},
{-0.21919037675964226,0.53944406467566,-0.016850101205569044},
{-0.2480245067194211,0.5603485158558944,0.009521422067449428},
{-0.21934755308430567,0.5524422803247744,0.014576638909505338},
{-0.22297752698237974,0.579623128469534,0.032503797539844205},
{-0.23622296234215104,0.605933379615989,0.03739651004623116},
{-0.2764403878152651,0.5933603392451167,0.021346942494244424},
{-0.2606055391068016,0.6156921645737352,0.03653017545673043},
{-0.2612928525265162,-0.4518611541644,-0.03803214175919201},
{-0.2783089212749078,-0.5401596165537039,0.013746001993741725},
{-0.2622668129383288,-0.6356801978610166,0.04442682056804057},
{-0.22515028987043878,-0.6543149163528913,0.07098588982845402},
{-0.22571399343482484,-0.7407794773540884,0.0440202933283179},
{-0.22668262583563192,-0.8090456839647647,0.040682827234447945},
{-0.22596281154878353,-0.8562593206892528,0.04462715378184886},
{-0.2277034727442933,-0.8653201362052734,0.023275149677149182},
{-0.24402583445976367,-0.9203643507046028,-0.04036421217631666},
{-0.19661399572586957,-0.8857285495608919,-0.09666796847735569},
{-0.18003375827773113,-0.8846565537465774,-0.09430499559639889},
{-0.1753003533004098,-0.8626774427465257,-0.10730001443890981},
{-0.1463660567337268,-0.8787914792316796,-0.07195292382595944},
{-0.13544310137127022,-0.8177100954619732,-0.04007117157101199},
{-0.14762346733103412,-0.8157744290636606,0.011691520950005682},
{-0.14089152542553493,-0.734337912048391,0.012383096778524713},
{-0.11011799945973968,-0.665021554468523,-0.00719201565582753},
{-0.0926181473120451,-0.6050968818881192,-0.03428814842559938},
{-0.09660349954418866,-0.5417873239158962,-0.054565492710481736},
{-0.11126512022923236,-0.46258324351194774,-0.0539410498206325},
{-0.1466356540906071,-0.43947193017321895,-0.07908766336347743},
{-0.21537392247637427,-0.4333122166497147,-0.07093953613270583},
{-0.20022958399422872,-0.3740711278813217,-0.037882957451036904},
{-0.22899178580543278,-0.38180633425916405,-0.007937937196603063},
{-0.26162212360665854,-0.4506351788320254,0.0171862987000186},
{-0.242661330841245,-0.5112397056167359,0.10266411206298988},
{-0.20244390536813092,-0.5515988561825973,0.10543840739357431},
{-0.1733263252228574,-0.6567599406033332,0.06891808875720415},
{-0.179178612511342,-0.7443044894353534,0.04679458865890234},
{-0.18531328438312025,-0.8114049272380177,0.041114928926997196},
{-0.18752707295592191,-0.857866781609624,0.042613698422855464},
{-0.18528770993029364,-0.8670000580753199,0.026091003493576823},
{-0.10622269061358974,0.8507634773370387,-0.15233076505442827},
{-0.1449205673479239,-0.3773164193847959,-0.044460387037375454},
{-0.19031895072282462,-0.3624518014804411,-0.002080321897112902},
{-0.21258417591387377,-0.3600089084344013,0.00937969697470208},
{-0.24557362165687288,-0.390679070986689,0.031745088772655375},
{-0.23777074953926028,-0.40147149007950994,0.07333820668739974},
{-0.2429953971312923,-0.44666154822409404,0.07718769463890206},
{-0.24094837530296404,-0.4717031999501298,0.10169707806548445},
{-0.21697339138023725,-0.513343204361723,0.10776035458978844},
{-0.19533953549334454,-0.5357368346180057,0.11165299943043562},
{-0.17680977881827914,-0.5540161747758106,0.10436641157925977},
{-0.8221688414719589,0.2849766606477903,0.1292157221079956},
{-0.8381709897259964,0.2727781794506075,0.1369738389331617},
{-0.844931170089825,0.26676498622975553,0.14030757541932778},
{-0.8555349775930496,0.2556901825536412,0.14441973431340321},
{-0.8606258921088427,0.25013253427376286,0.1480204041509468},
{-0.8597132038235938,0.25157003164305747,0.15706150602624686},
{-0.854224286885687,0.25751236231753555,0.1579150533893343},
{-0.8419922392191693,0.2707332888266814,0.15639124224175},
{-0.836108516665752,0.2763111835483808,0.15467722110126791},
{-0.8191196207734887,0.28988642278939486,0.14979623021909316},
{-0.8118777882147593,0.29586924634751527,0.1481978269174313},
{-0.8152711984241875,0.2904836928231158,0.1264536812027239},
{-0.15741794996251746,-0.5162746760169707,0.09682727600642133},
{-0.15798058792470243,-0.5195476731776737,0.10561316615455602},
{-0.20735633151523838,-0.5105230881364908,0.09622307955839315},
{-0.2109362221098604,-0.5116131991882242,0.10409095341027337},
{-0.1448305239619303,-0.488453400949345,0.12412640599550423},
{-0.13907147686604263,-0.4769310443487652,0.10473670834414477},
{-0.12525008351657252,-0.4355382596478291,0.15985444939535068},
{-0.13653374522410414,-0.4618890036779259,0.09489107680700826},
{-0.1197068208664092,-0.41585445578896385,0.12412640599550423},
{-0.13303590599896745,-0.3455145872949315,0.20034040662314392},
{-0.12753580023794897,-0.3271095060773957,0.1647812611721731},
{-0.4929174749703363,0.39534001501433513,-0.05281950350396643},
{-0.5499282583318104,0.38200773307517355,-0.0934002993276583},
{-0.5148118705953999,0.3813396004950787,-0.09384252424111807},
{-0.4902486742576616,0.3829390693989416,-0.071217658307195},
{-0.132853688022578,0.7468486146904985,-0.0016631386353791575},
{-0.10575489124730336,0.7799717935097368,-4.3423289695138864e-05},
{-0.0965880483122726,0.7715897665958218,0.015526090470692483},
{-0.0922942042429083,0.7562429636954657,0.017330687798268723},
{-0.09466996435027837,0.7470207094459773,0.01390850632941068},
{-0.11198280331167852,0.773057633627848,-0.012691588615745434},
{-0.10543787459247377,0.77405983249799,-0.01629119285108795},
{-0.09925738182604792,0.7808828833916839,-0.003491179211379773},
{-0.09000848752153183,0.772419870710485,0.01221419882964911},
{-0.08615154035462176,0.757113560693771,0.014469013087193441},
{-0.08807441952652098,0.7476483491424301,0.010583827461954012},
{-0.2617888903511319,-1.0,-0.0448232245868527},
{-0.23936915284092214,-1.0,-0.09570413128645358},
{-0.15170898617008183,-1.0,-0.016358858590858293},
{-0.14273288602904938,-0.999614252003199,-0.06761219325974639},
{-0.15549134118291436,-1.0,-0.11375170296551765},
{-0.21434881315890847,-1.0,-0.12476203770846508},
{-0.18476556485175077,-1.0,-0.13116683973822416},
{-0.16566091578918768,-0.982191123213984,0.03594888945602607},
{-0.288008032509392,-0.9991256733939909,0.04985712938488646},
{-0.15459943214058705,-0.9991256733939909,0.08837012413732843},
{-0.2863371682580548,-0.9991256733939909,0.1265357325722092},
{-0.14953675608312336,-0.9991256733939909,0.15178304552305882},
{-0.27521174847738766,-0.9991768222996441,0.1733620228965945},
{-0.17221490212710183,-0.9991256733939909,0.19488079374576756},
{-0.25378461941750985,-0.9991256733939909,0.19818789017690597},
{-0.2090746150645249,-0.9991256733939909,0.21377285516920966},
{-0.104180996796267,0.8196446962580847,-0.12989397790900076},
{-0.11936476255985355,0.8029717514184497,-0.11087617542582794},
{-0.10993258467674692,0.8213049044874107,-0.13158349019885734},
{-0.10752165969674028,0.8352850725648459,-0.12309277186042955},
{-0.10312711621937128,0.8345055845547356,-0.11943349390182498},
{-0.11248896435720479,0.8281482018229256,-0.09039103871172956},
{-0.10736448337207687,0.83671244671323,-0.1007407000899901},
{-0.11825120825969579,0.8092785180457069,-0.09013902379116753},
{-0.1276860501483052,0.8118396929360698,-0.09349460512245633},
{-0.12142670281899737,0.8304259265277939,-0.09298258326482399},
{-0.10018285733771012,-0.37595085016407603,0.01008192882523219},
{-0.14137744002924013,-0.3708444844163669,-0.01370018109909407},
{-0.18738534786317457,-0.3524447312098368,0.003573763381965648},
{-0.2053673850068705,-0.35245165762414404,0.0171527322306837},
{-0.23074310302295362,-0.3628524679080577,0.03449114564491045},
{-0.22861616102954221,-0.371841888076604,0.06871029632798811},
{-0.21697339138023725,-0.40660609428554834,0.08488613774080614},
{-0.21970666102607903,-0.44912735171745766,0.0902679616575016},
{-0.21882221119915946,-0.4696028980117461,0.10173064453481935},
{-0.17907045388792955,-0.5368525201225656,0.1104835010147197},
{-0.3149736290095281,0.6038682425502419,0.01895306714945551},
{-0.3635576301646409,0.5939778557206586,0.005664474900539363},
{-0.34691398938553647,0.5786209295993923,0.020559995268726233},
{-0.3830176575612735,0.557392535350021,0.022724766140276947},
{-0.3897900923504148,0.6123616248941723,-0.04923535050053998},
{-0.4102917458986304,0.5950003010326217,-0.048240078044705204},
{-0.405676622765632,0.5989281107459056,-0.11461004553851005},
{-0.3873557241219837,0.6167652259902509,-0.11619086640385363},
{-0.3918403109853464,0.5781755078793291,-0.15736360425026094},
{-0.35969588778782585,0.6109443739666988,-0.14981914066641694},
{-0.32244350043929454,0.5720509592284615,-0.1787955285200437},
{-0.32348192978427415,0.5994241485705213,-0.173673178739318},
{-0.2577086995230897,0.615439084050972,-0.19340759870273586},
{-0.24832340813683185,0.5830346539163811,-0.19079847171332318},
{-0.2966937560506225,0.5397072684193337,-0.17466845119515276},
{-0.24178966824073872,0.5505391147935955,-0.16801909346023944},
{-0.2671137045500681,0.5210704187230568,-0.12875751316151918},
{-0.24024188104362948,0.5334005017920764,-0.1353711732226954},
{-0.4148834257832043,0.5388164249792075,0.019721899137554864},
{-0.3600896278011352,0.5291082561260139,0.0374226173001583},
{-0.4420775939554781,0.5671411970868566,-0.0487851335705719},
{-0.44112387998548647,0.5772340483346503,-0.10835229661250387},
{-0.4323427850472568,0.5538797776940687,-0.14442026711450373},
{-0.36792393518368055,0.5422886897515176,-0.17717048516335415},
{-0.33192096641594826,0.5139234247602263,-0.1669593520712376},
{-0.3000296237411908,0.5003684319610331,-0.12371295234147435},
{-0.30995144583570655,0.5619479847597573,0.02857705342876157},
{-0.4763042038539635,0.5400919508139335,-0.047514935746851276},
{-0.4705904448516229,0.5530294271375847,-0.10015728288488353},
{-0.4911155416482628,0.5218903996168095,-0.12693533339762467},
{-0.47658232602845263,0.5032434266996223,-0.1483326255958714},
{-0.41437406793107473,0.5124656809491106,-0.15990133589219943},
{-0.3791921456592961,0.48756255750921873,-0.1494461798960292},
{-0.3422162820819523,0.47594109990393607,-0.11927525197496046},
{-0.4997341322508236,0.5341597433603659,-0.035486950901845775},
{-0.5039789586189369,0.542491154169728,-0.07643164987721597},
{-0.533976193381225,0.5145105715730367,-0.10895649306053207},
{-0.512536277094934,0.47945385755988806,-0.13929791733377803},
{-0.476008499243156,0.4740480575936678,-0.15884692251420315},
{-0.469994240420103,0.48196441634569837,-0.15404425339380978},
{-0.45288493147911446,0.4942742529728969,-0.150619407919449},
{-0.43877103032544024,0.47392657894274154,-0.14374094571129747},
{-0.41432078782101933,0.4591264299715538,-0.12811442223315053},
{-0.38474872833697327,0.4609486097354482,-0.1005195876332602},
{-0.44147126630304767,0.4351647660763408,-0.11256142530688011},
{-0.44581412807366294,0.42334084405284744,-0.10139125023376647},
{-0.4420056658069033,0.41639631450822734,-0.1039273834724033},
{-0.48135675669051664,0.37652094734166885,-0.07717757141799152},
{-0.5103384725551489,0.3762071274934425,-0.10454383434574421},
{-0.5511451760454757,0.37942631174298963,-0.10247443487119266},
{-0.5683178883174301,0.3959575314898771,-0.09066383287521318},
{-0.5724252520016005,0.39479336108516677,-0.09935275322304706},
{-0.52329512971842,0.4107273107983333,-0.1262640040109267},
{-0.5465955874478454,0.4432228499211188,-0.12534811891907444},
{-0.4867748110820498,0.4377158177457931,-0.1421643872547583},
{-0.5451559588741487,0.48013211336089345,-0.12209536820019253},
{-0.4756307432628633,0.4141388362451801,-0.13160213823737674},
{-0.46055566892378974,0.45131130342862846,-0.14951597684020176},
{-0.48150327699316897,0.44401246115213966,-0.14809872591272824},
{-0.49521651171922665,0.46372237226493224,-0.15262167445533073},
{-0.4527202959390433,0.45767880938134864,-0.14305469789378397},
{-0.4545126388413068,0.4881497043220292,-0.16017679406118582},
{-0.4403960736821298,0.4688852149293,-0.15196899310715214},
{-0.32141998952513035,0.6054575882331943,0.032449451827587704},
{-0.3720259708568454,0.5965896467155741,0.01824550728791986},
{-0.26381992814644356,0.6155504394809878,0.04861783402499797},
{-0.40767196288720653,0.6213814147254503,-0.047797853131245426},
{-0.3391153796767283,0.6588879481989458,0.02834635055222171},
{-0.24905814085449576,0.6511639306442152,0.04846438730803843},
{-0.2138879402069293,0.6887210802222633,0.04412632074732815},
{-0.18136629383021655,0.7233222492944381,0.026451177037551298},
{-0.1486235349967739,0.44787953153996035,0.0984730986060325},
{-0.12034937899367726,0.500732867913812,0.13013853361415503},
{-0.08513815266136815,0.49296835747543927,0.14458170584797161},
{-0.05582290330778908,0.4861756762444767,0.15311558107554427},
{-0.3525195897644646,0.6671889893455764,-0.17265765984166215},
{-0.37282783651317913,0.6127159376260408,-0.15781541958353068},
{-0.4061625373693372,0.6234667982330184,-0.11388490324065612},
{-0.3888214599496077,0.6885287390249635,-0.12162756883390617},
{-0.3842516249101564,0.6864838484010374,-0.03898319172368082},
{-0.3289788387386893,0.5974096276093268,-0.18686693239233554},
{-0.30892100850723514,0.6537959680809518,-0.20896485803781076},
{-0.3336307251476259,0.7117817774564396,-0.17482243071321288},
{-0.3303161695010797,0.7468283682486775,-0.1253992678247276},
{-0.33411663975133105,0.7341642188896105,-0.03501062671795054},
{-0.34716813551050074,0.7141101182658602,-0.019736817568370358},
{-0.18253632504703302,0.44065155180984544,0.030685880184754117},
{-0.17830908111523794,0.4963697597013756,0.06907792908737033},
{-0.20696365710413012,0.4979489821634175,0.009760649761598154},
{-0.19774566526344617,0.5361742643215605,0.05132552921801316},
{-0.17056481711868626,0.5293917063115087,0.08475506867006985},
{-0.15611365286836137,-0.9544572275268493,0.09374928404852113},
{-0.16956634785624816,-0.9151135958586436,0.04524946546729588},
{-0.1912993047478439,-0.9185155308856806,0.10155588577383766},
{-0.15342407291276502,-0.95621813516418,0.1530900066227177},
{-0.1940741328795289,-0.9385147529960738,0.14291030879553385},
{-0.2479829482335779,-0.9372163167140238,0.13407273694064542},
{-0.24559493370089508,-0.9164839602892684,0.09444085987704016},
{-0.2351344496937193,-0.8786039332442844,0.045545170078103325},
{-0.18661225346627078,-0.8826846568734272,0.05204800751036432},
{-0.16553464192835637,-0.8928696827116166,0.0003801535852452525},
{-0.1501228372937327,-0.9467353411765207,-0.0111773678879711},
{-0.16012777635993486,-0.9510398412678961,0.040940170166015505},
{-0.17540371671391725,-0.9609392857161886,0.19609771145943278},
{-0.195665076965783,-0.9522045444737071,0.17470947687989546},
{-0.24893453099916724,-0.9493966826737877,0.1707704783435001},
{-0.27690818718155147,-0.961150274952008,0.17306312147918373},
{-0.28714649312979623,-0.956717369795399,0.1272326364117338},
{-0.28707296657791975,-0.9534235933917745,0.05391707377110759},
{-0.2632056084775049,-0.9258308899962864,0.020662825881133145},
{-0.1534603033876027,-0.9145195226315259,-0.02988135052291763},
{-0.1381380093378721,-0.9342571394015471,-0.06358847934836294},
{-0.15470972196840171,-0.9303485105278834,-0.11059112683703157},
{-0.18472400636590755,-0.9310017246771625,-0.12829983701614334},
{-0.21550286034270835,-0.9331228058584677,-0.12469010955989031},
{-0.23987851069305172,-0.9398520837584643,-0.09712351341832931},
{-0.2644241245944718,-0.9451619795265849,-0.04563041825419194},
{-0.2537968738428226,-0.9634024252040495,0.20021146875680987},
{-0.2114764824258221,-0.9641302315074062,0.21426889299382537},
{-0.144496457671883,-0.9118400658968401,-0.06454485732385729},
{-0.15795234946637307,-0.899233459056633,-0.10082541546497817},
{-0.18612793726586724,-0.8926629558846018,-0.1171978604839006},
{-0.14180154970528108,-0.9044117529529169,-0.025571522420536702},
{-0.1557998330201351,-0.8660117120337923,0.021755600938369306},
{-0.1374853279896935,-0.6398610880970634,0.02851524850109731},
{-0.10122661469369533,-0.6272518172513536,0.007623584547276249},
{-0.09243806054005786,-0.6003229840271558,-0.011218926373814313},
{-0.0913916391785699,-0.5466597899804622,-0.008786156548684962},
{-0.09368534791645468,-0.5191597939764704,-0.03555887905042056},
{-0.09825944536471035,-0.4706882138535745,-0.019369717610088686},
{-0.0891826458156732,-0.3845129638499781,0.023771720302865465},
{-0.09176459994895768,-0.3843744355638341,0.057265195886988626},
{-0.10670167880298774,-0.36749369829498313,0.01772123100497477},
{-0.13741553104552093,-0.35447363780074626,-0.00788625548984933},
{-0.21486776143084801,-0.8984491758366175,-0.11244793867246211},
{-0.12014904577986897,-0.5498454077606743,0.04507470670631419},
{-0.10931346979790323,-0.5109440010059284,0.05070854554357169},
{-0.09128348055515745,-0.4489840282214087,0.03925598588716445},
{-0.08794068645028194,-0.3908826010071006,0.05699027051910279},
{-0.10125272194762247,-0.39552436419512665,0.08789699676003652},
{-0.11353858252529607,-0.3887204941410527,0.09591938293107738},
{-0.09201395086401692,-0.37329750068331735,0.057751110490693834},
{-0.13564876259608402,-0.5275604689289046,0.09159730040338372},
{-0.14141580170848003,-0.5166657520247774,0.09911565673330056},
{-0.12566726677830628,-0.48133357984264247,0.1056467326238909},
{-0.10088508918824024,-0.43592720445123345,0.08399635990288103},
{-0.12139313634966246,-0.43546633149925434,0.08730825154392441},
{-0.13254519618535726,-0.42694257949259223,0.11902270425329792},
{-0.13504723015355863,-0.3894584236653199,0.1361165619623704},
{-0.10385971773263297,-0.37711608617098763,0.10456674479306804},
{-0.2138778169860188,-0.4418178534189581,0.09491398725433207},
{-0.2036778727170139,-0.41471372863267786,0.11413478695681593},
{-0.20686881850823152,-0.4250037162876763,0.10872206057628833},
{-0.2025925568751855,-0.38129218119712954,0.1082388099780859},
{-0.19605881697909236,-0.3836210548076508,0.1330955797222295},
{-0.17430348244127336,-0.36160624613386194,0.1345069698375969},
{-0.15996260801876314,-0.3785535835402821,0.1385440037764942},
{-0.2161454184699764,-0.3706830456828991,0.07894380706632788},
{-0.21792710535022883,-0.354264779769329,0.04660704267150735},
{-0.20612236416635543,-0.36228450193486716,0.09228354822089721},
{-0.1330156595571464,-0.3707730890688928,0.13065801468719515},
{-0.21884352324318163,-0.3936909956081205,0.12407792109535382},
{-0.19236597255115293,-0.3188143257428712,0.16125838029531034},
{-0.2411721517651967,0.7774004953984635,-0.05760459018804148},
{-0.24059406257109567,0.7836262762584363,-0.07954267550335052},
{-0.2506325681066327,0.7880703702381567,-0.08173035682222504},
{-0.25191502035566604,0.7845474893612939,-0.052521134887656216},
{-0.3277917578866551,0.7685224306599328,-0.03973390847436134},
{-0.3240195260947331,0.7789291017559526,-0.11250388278802029},
{-0.27859450266480473,0.7890928155501197,-0.13462738288632206},
{-0.2310025771589234,0.7914211563595406,-0.09792964148346743},
{-0.2301186601331044,0.7865721335433989,-0.09525338155538493},
{-0.22918199579833054,0.7871592803562096,-0.08968454445239502},
{-0.22126510424519932,0.7826544470510259,-0.06791802109146436},
{-0.2274189569565975,0.7749506759381163,-0.04580464421407308},
{-0.23091040256852757,0.7830087597828941,-0.03808329066484519},
{-0.27812190808861337,0.7693221651118644,-0.007860148235922189},
{-0.2786131507033241,0.7547346037797975,-0.00013613068119152703},
{-0.2774894731822558,0.7844057642685466,-0.1548301350171269},
{-0.2319408398969989,0.7923423694623984,-0.13714486808643953},
{-0.224036735570281,0.7858027687541992,-0.12114644944010595},
{-0.26895559795468316,0.749116216174456,-0.17835277080548337},
{-0.21926976412362478,0.7606769344542759,-0.17210141549268382},
{-0.20814913955286266,0.7563441959045711,-0.16050020432922205},
{-0.24554858000514687,0.6902091936961106,-0.2135512099113792},
{-0.187350182990538,0.7139380235103814,-0.20907141825792155},
{-0.1813146121234628,0.7020128692777828,-0.19633161114257597},
{-0.19343636996216582,0.6517510774570257,-0.21032190244092167},
{-0.19091355675104285,0.6506273999359574,-0.20388406674292825},
{-0.2599629809795335,0.615439084050972,-0.20175126393741077},
{-0.1795073507903838,-0.2875703364052869,0.14020740881242363},
{-0.13819661745893305,-0.3330822064146056,0.15362653733097553},
{-0.13174013372242022,-0.28461595430271514,0.15874888711170124},
{-0.11663415691951455,-0.3468263436044953,0.13661259978698614},
{-0.18680246345916854,-0.10065305430894891,0.15790066775961933},
{-0.18345966935429303,-0.19856271575114562,0.15360629088915448},
{-0.1278315048487564,-0.11055782676824696,0.1706234252397472},
{-0.1261712966194303,-0.0317309695434907,0.16477859716667032},
{-0.06715451711437057,-0.0513710837121105,0.1480550362224828},
{-0.0741278179184207,-0.11801118136389624,0.16096800369550843},
{-0.13228572204938746,-0.2040495014846503,0.16709255234637613},
{-0.1955446639170578,-0.24185280517115434,0.10857554027363599},
{-0.18903649847379128,-0.195278529767331,0.14534787383056819},
{-0.18887133013261953,-0.10452012469676951,0.13984297285964475},
{-0.1893806879847491,-0.012173972346557224,0.13429331659627475},
{-0.18583756066606533,-0.008906303196859859,0.151883212129963},
{-0.1332261159918652,0.03288821353389392,0.1508581028124972},
{-0.09420696019389699,0.0057217510188489334,0.15118417708603618},
{-0.06761752127075196,-0.04401683012116428,0.13218289143698056},
{-0.045501480387857896,-0.10038452255426981,0.1380500971562807},
{-0.08253861609176542,-0.206929824234245,0.16166224352953024},
{-0.08839836259565778,-0.2803753903434063,0.15388974107464917},
{-0.09303213376717552,-0.3559233895953536,0.1106119060799532},
{-0.08235586531427541,-0.36057154639658623,0.06412287885221857},
{-0.10080516902315714,-0.3589187973826679,0.016756861012972114},
{-0.1353482627753716,-0.3439593408824145,-0.005561644288132432},
{-0.1828906377789014,-0.3388055558367561,0.00248365233023226},
{-0.2053439417584461,-0.34563819715026006,0.023362529057640028},
{-0.21986064054413912,-0.342794104875503,0.052906882884457294},
{-0.21371318144594761,-0.3482196184824439,0.09348448190154582},
{-0.21070232242671721,-0.28223699738874175,0.09980989656732235},
{-0.19890290925384937,-0.2843410289348293,0.10497540323719294},
{-0.20598916389121694,-0.2361054796994788,0.10588862432354242},
{-0.19788952156059575,-0.18953493390335951,0.1430126066068402},
{-0.20893395557397865,-0.10154176654467291,0.14246968228537574},
{-0.20720768000818385,-0.006265208141413976,0.13259847629541266},
{-0.1770367520871151,0.04950041904806555,0.12563103630346859},
{-0.19624636296648737,0.057771623333065174,0.12507532475559083},
{-0.15733962820073602,0.12354165678764618,0.11284114588467095},
{-0.1765860023560465,0.12722650919907752,0.11686006458614942},
{-0.17106565015320696,0.1656846254381622,0.08582972848988717},
{-0.18367545380001737,0.16398392432519407,0.08617445080194558},
{-0.1907462572054689,0.1638017063488047,0.03497706024861565},
{-0.1827782167466845,0.16661596176193058,0.03223633138736612},
{-0.18758088586707786,0.15660409628142136,-0.03414695613395258},
{-0.17644534286550023,0.15829467417347898,-0.030894205415070694},
{-0.17552892497254743,0.14064990012643377,-0.0868383209732358},
{-0.15827309572890655,0.1422392458093862,-0.08456272747276986},
{-0.159975928046277,0.11829782835599423,-0.0856880033971398},
{-0.17109921662254185,0.11628384019590034,-0.08689479788989452},
{-0.13893454698320026,0.061617914477964206,-0.09905385180563628},
{-0.14314420847867704,0.05818667539039674,-0.10500417449662283},
{-0.12017728423819833,0.014170910871433486,-0.10476547960357466},
{-0.1248211786306266,0.009920756492314654,-0.11473152418943636},
{-0.12107718529703396,-0.029952479469841573,-0.09135114629492777},
{-0.12562091308255807,-0.033011823389222324,-0.10010080596822479},
{-0.11382629511959522,-0.08518370715546544,-0.07259548195322753},
{-0.11789689552782741,-0.09222627210258769,-0.08439063271729093},
{-0.06752481387925556,-0.11083008813063,-0.06961552539782925},
{-0.06137682197996349,-0.10527830066285787,-0.046494621639290454},
{-0.02969859974542765,-0.13095771530625666,-0.016171312603463307},
{-0.04097373663535041,-0.11742723135768911,-0.007142997954576569},
{-0.0200223989582673,-0.1262061950915165,0.052443878728075904},
{-0.036545626688646506,-0.1141957926828294,0.04559152377385152},
{-0.04672052930592535,-0.10396707715439457,0.10661110261589357},
{-0.03645558330265288,-0.11435776421739771,0.10937527472556748},
{-0.06257242764960656,-0.28951186361570547,0.10290547096154083},
{-0.059298897687803075,-0.28418704941676926,0.0621195467141357},
{-0.06425661192845761,-0.27677365490366157,0.0020696658751018387},
{-0.1006506567039965,-0.3482526521506783,0.0018586766392824727},
{-0.13395232389192024,-0.3336965260835443,-0.019428858532250175},
{-0.18221451318229842,-0.3231444002870732,-0.014538277230265443},
{-0.21443352853389655,-0.34484325790823356,0.016790427482307014},
{-0.22203446903439925,-0.2560983081966654,0.06006559847150021},
{-0.22959811345786318,-0.17982783065236693,0.06202950332814208},
{-0.23625812721478756,-0.09123952446436166,0.062034831339147625},
{-0.22841103260582896,-0.007381959248174997,0.05982104276634594},
{-0.21131664209565593,0.07391816068535262,0.059448081995958184},
{-0.21012423323261617,0.06960513577636838,-0.027106522391232644},
{-0.1883704970980988,0.06390576240374289,-0.08131210795829019},
{-0.19656018281471363,-0.002555314078256772,-0.07864330724561544},
{-0.19705408943492717,-0.08598823681730197,-0.07557117609982134},
{-0.1874705960392632,-0.17326052428693897,-0.05530608624025173},
{-0.09022427196725619,-0.18471308394334623,-0.06038687753513423},
{-0.04870521340548882,-0.19869325202078136,-0.006063010123753705},
{-0.03858465650046648,-0.20535539698210803,0.06116316873864135},
{-0.04495109685098567,-0.20576938343723847,0.10624560106091356},
{-0.11399306186406859,-0.25101911530508453,-0.0434347449188091},
{-0.1841613684037226,-0.24852773735889433,-0.036844528106057255},
{-0.2161555416908869,-0.2513382631643164,0.012112966620543859},
{-0.22188262072074136,-0.17520418270175975,0.001033367734524402},
{-0.22795335646045312,-0.0861091826671277,-0.011192819119887166},
{-0.2244336723901937,-0.00594659308328266,-0.021326696052423356},
{-0.17245466262235112,0.05084680742916548,0.1414877298570548},
{-0.15219703197818926,0.12141578039643594,0.12349397108914668},
{-0.12744895365855868,0.10560330933419566,0.1330513572308835},
{-0.11041690087715046,0.08713855439339785,0.13730204441110297},
{-0.09112417302609181,0.012263482931450378,0.1319820254220717},
{-0.1034206896257765,0.08607561619779273,0.1265485197986225},
{-0.12537156216749884,0.10635242768157466,0.11999453346070832},
{-0.14983938710823802,0.6973359412171203,-0.20813635232644936},
{-0.15335907117849742,0.6358171277438591,-0.2171428221302134},
{-0.10580124494305156,0.6943394678276048,-0.2257129278326237},
{-0.17301463657903332,0.7371404458373049,-0.18625154712119574},
{-0.16980024753939132,0.7271083339149746,-0.20517078140076603},
{-0.181548511806606,0.7212166193450489,-0.20744690770233254},
{-0.1990979144566521,0.5832168718927705,-0.21346169932648612},
{-0.1529381583090598,0.5822855355690023,-0.21759570306568424},
{-0.10355602110531721,0.6379834970187114,-0.22533037664242597},
{-0.056190536067171316,0.692223714657305,-0.23075535744826633},
{-0.21362260525885343,0.4905995237823763,-0.04869562298567883},
{-0.1909982721260309,0.4348711926699357,-0.023887338141685657},
{-0.19061572093583318,0.431662131641299,-0.07638796018697055},
{-0.2137179766558526,0.4889291923321397,-0.11024427332057098},
{-0.21135020856499082,0.5267495456538617,-0.1843643656230336},
{-0.05183488707014275,0.637740539716859,-0.22830553798791928},
{-7.965376453282913e-05,0.6932765296319997,-0.21321394681472852},
{-0.1590962734292624,0.3791934776620474,-0.022959198624520675},
{-7.965376453282913e-05,0.6349465307455538,-0.21461627931138655},
{0.051675579541077085,0.637740539716859,-0.22830553798791928},
{0.05603122853810566,0.692223714657305,-0.23075535744826633},
{0.1056419374139859,0.6943394678276048,-0.2257129278326237},
{0.11269728958752136,0.7437002929873252,-0.21869860134383093},
{0.10339671357625155,0.6379834970187114,-0.22533037664242597},
{0.15319976364943177,0.6358171277438591,-0.2171428221302134},
{0.14968007957917237,0.6973359412171203,-0.20813635232644936},
{-0.16802868388004946,0.23288256584222794,-0.03153729634343932},
{-0.13679748176887835,0.17199139206541952,-0.10779125705362057},
{-0.09769627460142483,0.1718901598563143,-0.13677297291825286},
{-0.039978464179515616,0.16349800972148884,-0.13145242112812108},
{-7.965376453282913e-05,0.15975241798459464,-0.1209413210163927},
{0.03981915665044996,0.16349800972148884,-0.13145242112812108},
{0.09753696707235916,0.1718901598563143,-0.13677297291825286},
{0.1366381742398127,0.17199139206541952,-0.10779125705362057},
{0.15811378819984087,0.1422392458093862,-0.08456272747276986},
{-0.17165705937482187,0.21821401874287719,0.027415014228453397},
{-0.15677006382424385,0.27203918432413926,0.033503865205583974},
{-0.1546345970132236,0.2802491164825751,-0.028567463008951584},
{-0.13999961638320763,0.3262591555209116,-0.02134214728433942},
{-0.1416326517564055,0.3253379424180538,0.03940517019531956},
{-0.14936892373644886,0.38512568511561523,0.04081123229968144},
{-0.29399192166971344,0.6975384056353306,0.03440163506001739},
{-0.2527611085033457,0.7298011106771742,0.03853617160031607},
{-0.2178221435334197,0.7594115318404603,0.0038806568158847254},
{-0.21076732416098481,0.7490554768489929,-0.006345394707047297},
{-0.2249345054247144,0.7669533314188013,-0.017420198383161774},
{-0.2260501909292744,0.7731791122787742,-0.005329875809391464},
{-0.22745199062483185,0.766021995095033,-0.04133604138372708},
{-0.21583959063825842,0.7659410093277488,-0.04738866188601998},
{-0.21589873156041992,0.7758212729364212,-0.04545992190201468},
{-0.20084443646426797,0.7700004209128694,-0.05751454680204786},
{-0.20185143054431492,0.7793340305923735,-0.05534657912389383},
{-0.19725442264873544,0.7797996987542577,-0.07954001149784774},
{-0.2010548928989868,0.7859040009633044,-0.0771003152584112},
{-0.21559610053530529,0.7880804934590672,-0.09051731257256085},
{-0.14302379542995186,0.14799935850747495,0.10760104706072281},
{-0.17898307450743872,0.17953319164376058,0.029415682361033493},
{-0.061860072578165934,0.01038855585860099,0.13338116111212642},
{-0.03849461311447286,-0.03744472854583127,0.09949607671909608},
{-0.0196856686627172,-0.0429427031024475,0.042266844906394846},
{-0.044205708111310686,0.040511531680619876,0.12050122730733513},
{-0.026512449164115007,0.010615529127436994,0.09603766477540036},
{-0.008701441173696901,0.023959532690810744,0.0421123325872342},
{-0.09754975429877248,0.10814423778273748,-0.14436538860114667},
{-0.03890859956960328,0.105896882740601,-0.13583364457797623},
{-7.965376453282913e-05,0.10365965091937503,-0.11943402670292555},
{0.038749292040537626,0.105896882740601,-0.13583364457797623},
{0.09739044676970683,0.10814423778273748,-0.14436538860114667},
{0.1326506908032669,0.1106851662312793,-0.11731507672602247},
{0.15981662051721132,0.11829782835599423,-0.0856880033971398},
{0.13877523945413459,0.061617914477964206,-0.09905385180563628},
{0.11842863102618024,0.055118806653407,-0.11576036311460605},
{0.12001797670913268,0.014170910871433486,-0.10476547960357466},
{0.0724105999713353,0.017328822994416775,-0.10381070003138199},
{0.1209178777679683,-0.029952479469841573,-0.09135114629492777},
{0.09384998345652582,-0.03546483965617275,-0.08075213400160798},
{0.11366698759052955,-0.08518370715546544,-0.07259548195322753},
{0.061217514450897834,-0.10527830066285787,-0.046494621639290454},
{0.04649941684919543,-0.044118062330269485,-0.057357903278485},
{0.03162201171842739,-0.04607450797150366,-0.007572435641623056},
{0.017582702718830723,0.020801087766726945,-0.012429983275373448},
{-7.965376453282913e-05,0.038506601139235375,-0.014867548310407782},
{-7.698975903005936e-05,0.024041051259195537,0.043117728263979506},
{-0.01774201024789638,0.020801087766726945,-0.012429983275373448},
{-0.03178131924749305,-0.04607450797150366,-0.007572435641623056},
{-0.04665872437826109,-0.044118062330269485,-0.057357903278485},
{-0.09400929098559148,-0.03546483965617275,-0.08075213400160798},
{-0.07256990750040095,0.017328822994416775,-0.10381070003138199},
{-0.1185879385552459,0.055118806653407,-0.11576036311460605},
{-0.13280999833233256,0.1106851662312793,-0.11731507672602247},
{-0.17514637378234968,0.1799786133638237,-0.03567449688924077},
{-7.965376453282913e-05,0.05900612348304863,-0.10609162154285344},
{0.03842534897140082,0.05005719619814453,-0.12059127069332874},
{0.09152004424380338,0.050452001813654945,-0.13211842250381353},
{-0.21293635744133993,0.7965131364775347,-0.11655636795883366},
{-0.21202952996819713,0.7808322672871313,-0.15698265146336485},
{-0.22515028987043878,0.7943872600863245,-0.11919479900877683},
{-0.19941972632138671,0.7565871532064237,-0.18400419207905916},
{-0.20260268009609603,0.7831707313174626,-0.15542154423874177},
{-0.18861771680875586,0.7595330104913866,-0.18248197933477653},
{-0.18571714761734012,0.7572957786701603,-0.16441096440728806},
{-0.2572377033502001,0.5680624101897145,0.004471533236399059},
{-7.965376453282913e-05,0.043022090466430137,-0.07399195363777943},
{-0.017369049477508613,0.03575308505157251,-0.07213247779684613},
{-0.03858465650046648,0.05005719619814453,-0.12059127069332874},
{-0.0325421592190841,0.014251896638717768,-0.06463223670434813},
{-0.09167935177286902,0.050452001813654945,-0.13211842250381353},
{-0.21790685890840775,-0.47755335603421223,0.12069410130573567},
{-0.21770173048469452,-0.41384419723657373,0.1570492516009341},
{-0.19649038587054107,-0.33684165098011426,0.19733647401822074},
{-0.4888863018435451,0.4827540275767194,0.006831842111853074},
{-0.49616809448481597,0.5082949139339743,-0.00900460499991208},
{0.2360988196857219,-0.09123952446436166,0.062034831339147625},
{0.22779404893138747,-0.0861091826671277,-0.011192819119887166},
{0.2217233131916757,-0.17520418270175975,0.001033367734524402},
{0.22943880592879753,-0.17982783065236693,0.06202950332814208},
{0.18731128851019752,-0.17326052428693897,-0.05530608624025173},
{0.18400206087465695,-0.24852773735889433,-0.036844528106057255},
{0.21599623416182126,-0.2513382631643164,0.012112966620543859},
{0.22187516150533357,-0.2560983081966654,0.06006559847150021},
{0.21427422100483087,-0.34484325790823356,0.016790427482307014},
{0.18205520565323277,-0.3231444002870732,-0.014538277230265443},
{0.13379301636285457,-0.3336965260835443,-0.019428858532250175},
{0.10049134917493084,-0.3482526521506783,0.0018586766392824727},
{0.11383375433500294,-0.25101911530508453,-0.0434347449188091},
{0.09006496443819054,-0.18471308394334623,-0.06038687753513423},
{0.06736550635018991,-0.11083008813063,-0.06961552539782925},
{0.18567825313699968,-0.008906303196859859,0.151883212129963},
{0.17229535509328545,0.05084680742916548,0.1414877298570548},
{0.1520377244491236,0.12141578039643594,0.12349397108914668},
{0.12728964612949303,0.10560330933419566,0.1330513572308835},
{0.1102575933480848,0.08713855439339785,0.13730204441110297},
{0.09096486549702616,0.012263482931450378,0.1319820254220717},
{0.09404765266483132,0.0057217510188489334,0.15118417708603618},
{0.13306680846279956,0.03288821353389392,0.1508581028124972},
{0.11773758799876176,-0.09222627210258769,-0.08439063271729093},
{0.12546160555349242,-0.033011823389222324,-0.10010080596822479},
{0.12466187110156093,0.009920756492314654,-0.11473152418943636},
{0.1429849009496114,0.05818667539039674,-0.10500417449662283},
{0.1709399090934762,0.11628384019590034,-0.08689479788989452},
{0.17536961744348176,0.14064990012643377,-0.0868383209732358},
{0.19689478190586152,-0.08598823681730197,-0.07557117609982134},
{0.19640087528564798,-0.002555314078256772,-0.07864330724561544},
{0.18821118956903315,0.06390576240374289,-0.08131210795829019},
{0.5046689360441543,0.47618405720578855,0.03764639376239096},
{0.024134025051242132,0.039802906216883094,0.15282467167464184},
{-7.43257535272896e-05,0.03389094520513643,0.15639124224175},
{-0.017685533331237662,0.014231117395796099,0.13723011626252815},
{0.017526225802172002,0.014231117395796099,0.13723011626252815},
{0.012992621237558415,0.00148438386614329,0.1022682408452783},
{-7.43257535272896e-05,0.0026778583313841558,0.10368495897165125},
{-7.43257535272896e-05,0.01234553430093568,0.14132575832248642},
{-0.013151928766624073,0.00148438386614329,0.1022682408452783},
{0.6670901547414235,0.3593215950146866,0.12094078821529214},
{0.6805710881876398,0.35822828715634986,0.1344318448824188},
{0.6695660814556978,0.3668431481512068,0.1252836499859074},
{0.2190310692305766,0.53944406467566,-0.016850101205569044},
{0.19083896459696525,0.4348711926699357,-0.023887338141685657},
{0.1907542492219772,0.6506273999359574,-0.20388406674292825},
{0.16964094001032567,0.7271083339149746,-0.20517078140076603},
{0.1010934144185568,-0.39552436419512665,0.08789699676003652},
{0.09160529241989201,-0.3843744355638341,0.057265195886988626},
{0.08778137892121628,-0.3908826010071006,0.05699027051910279},
{0.18138920427754035,0.7212166193450489,-0.20744690770233254},
{0.12737649270888332,-0.3271095060773957,0.1647812611721731},
{0.11954751333734354,-0.41585445578896385,0.12412640599550423},
{0.1328765984699018,-0.3455145872949315,0.20034040662314392},
{-0.14685197133743202,0.7214899463096331,0.007218122909754688},
{-0.16676967487944044,0.7424348903735094,0.013106107871976427},
{-0.1790725850923318,0.743831894859162,-0.01185349248457407},
{-0.20092329102714995,0.7651918909803701,-0.013974573665879357},
{-0.2139215066762642,0.7714480415030746,-0.02514155193238966},
{-0.22238878176626764,0.7680162696144065,-0.01578503180556169},
{-0.2100592314983486,0.7615880243362231,-0.0059985411905866745},
{-0.17378400136823324,0.7374036495809787,0.020594094539161688},
{0.22902268826926486,0.7871592803562096,-0.08968454445239502},
{0.22995935260403874,0.7865721335433989,-0.09525338155538493},
{0.2154367930062396,0.7880804934590672,-0.09051731257256085},
{0.22110579671613367,0.7826544470510259,-0.06791802109146436},
{0.20089558536992114,0.7859040009633044,-0.0771003152584112},
{0.1970951151196698,0.7797996987542577,-0.07954001149784774},
{0.20169212301524927,0.7793340305923735,-0.05534657912389383},
{0.2006851289352023,0.7700004209128694,-0.05751454680204786},
{0.21573942403135427,0.7758212729364212,-0.04545992190201468},
{0.21568028310919277,0.7659410093277488,-0.04738866188601998},
{0.22725964942753182,0.7749506759381163,-0.04580464421407308},
{0.2307510950394619,0.7830087597828941,-0.03808329066484519},
{0.22589088340020874,0.7731791122787742,-0.005329875809391464},
{0.21766283600435404,0.7594115318404603,0.0038806568158847254},
{0.24043475504203002,0.7836262762584363,-0.07954267550335052},
{0.24101284423613104,0.7774004953984635,-0.05760459018804148},
{0.1608118929730461,0.7265211871021642,0.029343754212458707},
{0.13157070297244405,0.7083095126841294,0.050672847869834566},
{0.08040421488294625,0.6781018214871224,0.08364204717101263},
{0.12182843484881502,0.6357665116393065,0.10344360007310031},
{0.12433260002141859,0.637011667811301,0.10771986170614635},
{0.11373039092149546,0.627101034539897,0.11781431135724155},
{0.11499579353531111,0.610600184455741,0.12592674091427605},
{0.12584895195359513,0.5960733624491373,0.12819434239823368},
{0.12302883572836305,0.5925606047931854,0.12296170278969329},
{0.12181991003120614,0.5720307127866404,0.1290537505734272},
{0.1413497343720113,0.6315653749614386,0.09416327050365156},
{0.14357897417672905,0.633772237119933,0.10017539812230236},
{0.1352891218532101,0.6149329230054457,0.11311127604265181},
{0.14243718141824194,0.5922062920613169,0.12230369343050916},
{0.1398525632794547,0.5883189752316752,0.11698367444147793},
{0.1458902653509321,0.6737285900537757,0.05775430729729716},
{0.18022503387282995,0.63679908017218,0.060705492593265506},
{0.1696798344906661,0.6135156720779722,0.07969985182801394},
{0.1560518479406971,0.6170183065130139,0.09768881538601708},
{0.15724212559933462,0.6189214720441927,0.10147596560875456},
{0.1563321013195885,0.6008312762770843,0.11141643574178967},
{0.1561349649123835,0.5988268785368004,0.1083336485739845},
{0.12563849551887632,0.6952708041513731,0.05090941155848052},
{0.1732357490357632,0.5987155231067847,0.09685817847025346},
{0.1686723076095186,0.5825284928708548,0.099041064579223},
{0.20243324934611984,-0.38129218119712954,0.1082388099780859},
{0.1958995094500267,-0.3836210548076508,0.11814571364178611},
{0.20351856518794825,-0.41471372863267786,0.11413478695681593},
{0.20670951097916584,-0.4250037162876763,0.10872206057628833},
{0.21371850945695312,-0.4418178534189581,0.09491398725433207},
{0.4402367661530641,0.4688852149293,-0.15196899310715214},
{0.45435333131224115,0.4881497043220292,-0.16017679406118582},
{0.2762810802861994,0.5933603392451167,0.021346942494244424},
{0.24755137934212917,0.5629400604089888,0.0076779302595327515},
{0.241318672067849,0.5518146406283216,-0.02161707265222526},
{0.2570783958211344,0.5680624101897145,0.004471533236399059},
{0.017209741948442957,0.03575308505157251,-0.07213247779684613},
{0.03238285169001844,0.014251896638717768,-0.06463223670434813},
{0.2249909823413731,0.7943872600863245,-0.11919479900877683},
{0.21187022243913148,0.7808322672871313,-0.15698265146336485},
{0.21277704991227428,0.7965131364775347,-0.11655636795883366},
{0.20244337256703035,0.7831707313174626,-0.15542154423874177},
{0.19926041879232106,0.7565871532064237,-0.18400419207905916},
{0.49275816744127066,0.39534001501433513,-0.05281950350396643},
{0.47479531113719464,0.4392241776614614,-0.014216998166631405},
{0.5244347912725048,0.41004905499732797,-0.11445127081054496},
{-7.965376453282913e-05,0.6700538608632551,0.02753382887387693},
{0.018040378864206567,0.6722910926844811,0.031128637899314453},
{-7.965376453282913e-05,0.16550240746177283,0.17219465568528078},
{-0.15593889410737968,0.795612169816498,-0.044768346073495634},
{0.027042586259166165,0.6989354101209833,0.020989965756873275},
{0.047224559147049365,0.7043412100872035,0.03884253223313459}
};


// texture array: 17kb.
const tgx::fVec2 cyborg_tex_array[2212] PROGMEM = {
{0.208008,0.804321},
{0.205078,0.803955},
{0.207642,0.802612},
{0.203979,0.803955},
{0.206909,0.804565},
{0.207397,0.80542},
{0.21228,0.804321},
{0.211914,0.805542},
{0.223145,0.804565},
{0.222534,0.80542},
{0.229126,0.804687},
{0.229126,0.804199},
{0.234985,0.804565},
{0.235718,0.80542},
{0.246094,0.805542},
{0.245605,0.804321},
{0.250732,0.80542},
{0.250244,0.80481},
{0.254883,0.803955},
{0.253174,0.804077},
{0.2229,0.804321},
{0.219116,0.801514},
{0.223267,0.800903},
{0.229126,0.801147},
{0.222534,0.796509},
{0.218384,0.798218},
{0.206909,0.801025},
{0.218506,0.804077},
{0.403076,0.841187},
{0.427979,0.84668},
{0.400391,0.861938},
{0.380859,0.837891},
{0.373291,0.847046},
{0.380859,0.86377},
{0.380127,0.883057},
{0.396729,0.891357},
{0.411377,0.873657},
{0.430176,0.863647},
{0.250977,0.808472},
{0.24585,0.809937},
{0.256592,0.807739},
{0.258789,0.802612},
{0.248901,0.802124},
{0.248779,0.804321},
{0.23938,0.804199},
{0.239014,0.801514},
{0.235229,0.804321},
{0.235107,0.800903},
{0.229126,0.803833},
{0.703613,0.85437},
{0.719238,0.849609},
{0.708008,0.859619},
{0.692871,0.86853},
{0.689941,0.862549},
{0.678711,0.872314},
{0.677734,0.865601},
{0.664063,0.870117},
{0.660156,0.853638},
{0.668457,0.842163},
{0.650879,0.819702},
{0.661621,0.82019},
{0.65625,0.789185},
{0.678711,0.813599},
{0.66748,0.784424},
{0.694336,0.80481},
{0.678223,0.775269},
{0.707031,0.800171},
{0.685059,0.772217},
{0.699219,0.775391},
{0.716309,0.798096},
{0.714355,0.819336},
{0.727539,0.817017},
{0.722168,0.834717},
{0.731445,0.83252},
{0.728027,0.842529},
{0.711426,0.841064},
{0.69043,0.830688},
{0.680664,0.83728},
{0.055297,0.934205},
{0.088562,0.917847},
{0.086792,0.93863},
{0.079772,0.960724},
{0.107544,0.969605},
{0.110291,0.943421},
{0.108887,0.923645},
{0.106567,0.905457},
{0.086181,0.894958},
{0.063171,0.914002},
{0.039978,0.921143},
{0.027999,0.93451},
{0.045471,0.960907},
{0.07257,0.981308},
{0.103943,0.989205},
{0.131592,0.991005},
{0.130249,0.973313},
{0.130249,0.968628},
{0.144287,0.943512},
{0.137695,0.922242},
{0.131592,0.905823},
{0.123962,0.890015},
{0.100891,0.88855},
{0.093383,0.866699},
{0.079772,0.871216},
{0.056884,0.888245},
{0.039489,0.906434},
{0.019393,0.91272},
{0.084045,0.689453},
{0.088073,0.717285},
{0.049285,0.689941},
{0.064575,0.664795},
{0.043182,0.666504},
{0.013595,0.66748},
{0.013595,0.692383},
{0.050384,0.719238},
{0.050293,0.731934},
{0.089782,0.729736},
{0.123657,0.713135},
{0.114868,0.685303},
{0.092285,0.671387},
{0.080078,0.672119},
{0.088439,0.651855},
{0.065551,0.644531},
{0.040893,0.644531},
{0.013595,0.641846},
{0.013595,0.719238},
{0.013595,0.732422},
{0.013595,0.741699},
{0.051269,0.74292},
{0.093566,0.741455},
{0.126221,0.725098},
{0.15332,0.720947},
{0.153809,0.709961},
{0.14209,0.680664},
{0.130249,0.682617},
{0.586426,0.768921},
{0.582031,0.74585},
{0.563965,0.756714},
{0.563965,0.776001},
{0.534668,0.758423},
{0.558105,0.738281},
{0.571777,0.727295},
{0.583984,0.721191},
{0.600098,0.736084},
{0.605469,0.76062},
{0.608398,0.783813},
{0.589844,0.786987},
{0.564941,0.791626},
{0.534668,0.779907},
{0.54834,0.124512},
{0.550293,0.137695},
{0.539063,0.138184},
{0.541992,0.097656},
{0.523926,0.102051},
{0.520996,0.143066},
{0.539063,0.162109},
{0.547852,0.157715},
{0.466064,0.024902},
{0.481689,0.009277},
{0.483398,0.019531},
{0.475342,0.037598},
{0.493408,0.020996},
{0.500488,0.011719},
{0.557617,0.125488},
{0.560547,0.101074},
{0.54834,0.103516},
{0.553711,0.090332},
{0.55127,0.079102},
{0.54248,0.080566},
{0.554199,0.074219},
{0.549316,0.074219},
{0.550293,0.067383},
{0.554688,0.064453},
{0.540527,0.063965},
{0.544434,0.055176},
{0.526855,0.058105},
{0.53418,0.044922},
{0.524902,0.038086},
{0.511719,0.033691},
{0.519531,0.05957},
{0.498535,0.040527},
{0.450684,0.037598},
{0.456299,0.024902},
{0.440674,0.021484},
{0.444092,0.012207},
{0.423096,0.014648},
{0.431396,0.022949},
{0.410889,0.035645},
{0.425293,0.04248},
{0.401123,0.05957},
{0.391846,0.043457},
{0.38916,0.064941},
{0.384277,0.054199},
{0.382568,0.069824},
{0.375732,0.067383},
{0.382324,0.078613},
{0.375977,0.07959},
{0.37915,0.084961},
{0.387695,0.082031},
{0.388916,0.095703},
{0.379395,0.091309},
{0.382324,0.101562},
{0.374756,0.096191},
{0.373779,0.123047},
{0.382813,0.126465},
{0.374268,0.13623},
{0.394287,0.137695},
{0.390869,0.164062},
{0.375977,0.162598},
{0.37793,0.176758},
{0.371582,0.17334},
{0.369629,0.192871},
{0.379395,0.208496},
{0.373535,0.21582},
{0.384033,0.223145},
{0.389404,0.213379},
{0.393311,0.23291},
{0.400635,0.220703},
{0.410645,0.240723},
{0.402832,0.24707},
{0.428467,0.263184},
{0.431396,0.246582},
{0.455811,0.245117},
{0.479248,0.266602},
{0.477051,0.248047},
{0.499268,0.260254},
{0.490723,0.245117},
{0.507324,0.237793},
{0.519531,0.247559},
{0.513184,0.224121},
{0.526855,0.230469},
{0.520996,0.220703},
{0.53418,0.213867},
{0.538574,0.224121},
{0.546875,0.205566},
{0.555664,0.210449},
{0.558594,0.171387},
{0.54834,0.173828},
{0.848633,0.146484},
{0.791992,0.178711},
{0.788086,0.131348},
{0.856445,0.086426},
{0.791504,0.084961},
{0.773926,0.129883},
{0.761719,0.174805},
{0.762695,0.202148},
{0.791992,0.203613},
{0.816895,0.209961},
{0.836914,0.183594},
{0.85791,0.195312},
{0.885254,0.149902},
{0.889648,0.098145},
{0.904297,0.073242},
{0.868652,0.027832},
{0.792969,0.04834},
{0.777832,0.083984},
{0.723145,0.125},
{0.725586,0.155273},
{0.726074,0.180664},
{0.735352,0.200684},
{0.745605,0.237305},
{0.76709,0.231934},
{0.790039,0.231934},
{0.811035,0.239258},
{0.836426,0.22998},
{0.287354,0.441895},
{0.287109,0.432129},
{0.294678,0.434082},
{0.291992,0.451172},
{0.296143,0.420898},
{0.288818,0.418457},
{0.272461,0.413086},
{0.269287,0.44043},
{0.281738,0.447754},
{0.287842,0.453125},
{0.29126,0.45459},
{0.295654,0.399414},
{0.301758,0.399902},
{0.278076,0.397461},
{0.243896,0.406738},
{0.244385,0.439453},
{0.24939,0.46875},
{0.27124,0.46582},
{0.286865,0.466309},
{0.291504,0.466309},
{0.296387,0.395508},
{0.302734,0.394531},
{0.29541,0.39209},
{0.291016,0.385742},
{0.276367,0.382324},
{0.260986,0.387207},
{0.241089,0.374512},
{0.214111,0.381348},
{0.21521,0.410645},
{0.218872,0.44043},
{0.218994,0.474121},
{0.237915,0.509766},
{0.256836,0.50293},
{0.270264,0.496094},
{0.286377,0.490234},
{0.293701,0.487305},
{0.473633,0.931336},
{0.477295,0.955414},
{0.458008,0.932251},
{0.473877,0.902649},
{0.45752,0.906434},
{0.446289,0.916504},
{0.439697,0.933106},
{0.449463,0.960419},
{0.463135,0.958527},
{0.483643,0.976609},
{0.490479,0.955018},
{0.490234,0.93042},
{0.487061,0.895447},
{0.51123,0.933045},
{0.50293,0.953827},
{0.526367,0.95221},
{0.531738,0.934815},
{0.945801,0.70874},
{0.933105,0.678955},
{0.942871,0.680664},
{0.959473,0.704346},
{0.956543,0.679687},
{0.972168,0.699463},
{0.96582,0.677002},
{0.984375,0.694336},
{0.974121,0.668701},
{0.672852,0.450684},
{0.640137,0.486328},
{0.668457,0.48877},
{0.706055,0.492187},
{0.703613,0.541016},
{0.685547,0.546631},
{0.666504,0.535156},
{0.635254,0.535645},
{0.608398,0.484375},
{0.619141,0.433105},
{0.649414,0.442383},
{0.671387,0.407227},
{0.706055,0.445312},
{0.731445,0.447754},
{0.731934,0.492676},
{0.737793,0.533936},
{0.703613,0.549805},
{0.674316,0.579102},
{0.667969,0.571533},
{0.631348,0.577148},
{0.600586,0.537598},
{0.602051,0.484863},
{0.589355,0.452637},
{0.594238,0.427734},
{0.596191,0.386719},
{0.634766,0.389648},
{0.65332,0.414062},
{0.665039,0.388672},
{0.695313,0.384766},
{0.695313,0.401855},
{0.730469,0.396973},
{0.77002,0.393555},
{0.769043,0.452148},
{0.770508,0.496094},
{0.773926,0.529297},
{0.772461,0.538818},
{0.742188,0.544434},
{0.958496,0.650391},
{0.941895,0.606689},
{0.931641,0.651611},
{0.961426,0.655518},
{0.930664,0.656006},
{0.895508,0.649658},
{0.897461,0.607178},
{0.897461,0.572266},
{0.9375,0.568115},
{0.976074,0.597656},
{0.974609,0.633545},
{0.984375,0.636719},
{0.987305,0.595947},
{0.975586,0.565918},
{0.984375,0.562988},
{0.972168,0.523926},
{0.980469,0.522217},
{0.973145,0.489746},
{0.979004,0.490723},
{0.957031,0.459473},
{0.964844,0.455566},
{0.955078,0.42627},
{0.964844,0.424316},
{0.945313,0.37793},
{0.912598,0.384277},
{0.944336,0.365723},
{0.907227,0.375},
{0.878418,0.374023},
{0.882813,0.380371},
{0.856934,0.377441},
{0.85498,0.390137},
{0.809082,0.384277},
{0.80957,0.394043},
{0.770508,0.385254},
{0.734375,0.385254},
{0.935059,0.81665},
{0.936523,0.794922},
{0.963379,0.799561},
{0.967773,0.827881},
{0.828125,0.80603},
{0.789063,0.794922},
{0.835449,0.784668},
{0.849121,0.802002},
{0.862793,0.780518},
{0.84082,0.761719},
{0.785645,0.78064},
{0.762207,0.799561},
{0.790527,0.81665},
{0.419678,0.431641},
{0.429688,0.427734},
{0.419678,0.413086},
{0.397705,0.419434},
{0.409912,0.406738},
{0.395508,0.401367},
{0.376221,0.417969},
{0.379883,0.396973},
{0.378662,0.374512},
{0.356689,0.375977},
{0.363281,0.350586},
{0.337158,0.351074},
{0.336182,0.375},
{0.355957,0.397949},
{0.335693,0.402344},
{0.355469,0.414062},
{0.332764,0.430176},
{0.352051,0.432617},
{0.327148,0.452148},
{0.349365,0.457031},
{0.328857,0.460449},
{0.343506,0.46582},
{0.322021,0.481934},
{0.334473,0.486816},
{0.317871,0.496582},
{0.327148,0.5},
{0.314941,0.507812},
{0.322998,0.510986},
{0.314209,0.513672},
{0.320557,0.515381},
{0.013595,0.474121},
{0.013595,0.512939},
{0.035675,0.474121},
{0.031494,0.435059},
{0.070739,0.441406},
{0.07196,0.475098},
{0.035888,0.512207},
{0.032074,0.539551},
{0.013595,0.540039},
{0.013595,0.432129},
{0.013595,0.407227},
{0.062744,0.412598},
{0.102173,0.416992},
{0.103394,0.442871},
{0.101563,0.475098},
{0.064758,0.512207},
{0.060791,0.541504},
{0.030899,0.560791},
{0.013595,0.560791},
{0.060791,0.541748},
{0.099182,0.561523},
{0.123291,0.540771},
{0.097351,0.542236},
{0.083679,0.560547},
{0.097839,0.515137},
{0.127075,0.515137},
{0.146484,0.540527},
{0.14624,0.556396},
{0.130127,0.564941},
{0.114197,0.572266},
{0.112549,0.583008},
{0.094665,0.583008},
{0.079284,0.583008},
{0.061279,0.561279},
{0.053985,0.583252},
{0.02629,0.584229},
{0.013595,0.584961},
{0.0979,0.515137},
{0.102661,0.390137},
{0.056396,0.384277},
{0.013595,0.383301},
{0.145142,0.391602},
{0.142822,0.416992},
{0.14502,0.444336},
{0.147827,0.475586},
{0.828613,0.261719},
{0.797852,0.306152},
{0.824219,0.306152},
{0.855469,0.271484},
{0.851563,0.305176},
{0.821777,0.32666},
{0.801758,0.328125},
{0.762207,0.306152},
{0.760742,0.266113},
{0.79834,0.268066},
{0.866211,0.231445},
{0.909668,0.257812},
{0.90332,0.274414},
{0.888184,0.283203},
{0.877441,0.305664},
{0.870605,0.321777},
{0.846191,0.324219},
{0.822266,0.335449},
{0.802246,0.336426},
{0.756836,0.323242},
{0.717285,0.320801},
{0.733887,0.258789},
{0.894531,0.194824},
{0.932617,0.240723},
{0.922852,0.259766},
{0.913086,0.280762},
{0.90332,0.289551},
{0.891113,0.309082},
{0.879395,0.326172},
{0.853027,0.334961},
{0.298584,0.648682},
{0.318604,0.633057},
{0.304932,0.65625},
{0.278076,0.668945},
{0.307861,0.659912},
{0.333008,0.64624},
{0.332031,0.640381},
{0.336426,0.627686},
{0.332764,0.616211},
{0.308594,0.608643},
{0.294189,0.62207},
{0.274414,0.639893},
{0.256348,0.652344},
{0.25415,0.680176},
{0.281982,0.673828},
{0.2854,0.678711},
{0.311768,0.665527},
{0.33667,0.651367},
{0.351563,0.645508},
{0.344727,0.63623},
{0.349609,0.634521},
{0.339844,0.626465},
{0.335693,0.616699},
{0.335693,0.606689},
{0.316895,0.598877},
{0.298584,0.587402},
{0.286377,0.591797},
{0.264404,0.605469},
{0.251465,0.621826},
{0.23938,0.63623},
{0.234863,0.6604},
{0.167603,0.244141},
{0.171387,0.272461},
{0.161499,0.259766},
{0.15271,0.239258},
{0.148682,0.258301},
{0.155273,0.273926},
{0.16748,0.286133},
{0.192749,0.276367},
{0.201782,0.260742},
{0.191284,0.248535},
{0.186646,0.23291},
{0.173462,0.225586},
{0.154297,0.220215},
{0.130493,0.240723},
{0.131104,0.257324},
{0.143555,0.270508},
{0.150391,0.283691},
{0.163086,0.296875},
{0.184692,0.302246},
{0.196167,0.29834},
{0.205933,0.299805},
{0.215332,0.282715},
{0.225342,0.274414},
{0.212891,0.258789},
{0.204956,0.245605},
{0.195679,0.244141},
{0.193481,0.233398},
{0.191406,0.223145},
{0.189697,0.213379},
{0.173462,0.195801},
{0.153198,0.19043},
{0.13562,0.209473},
{0.94873,0.958802},
{0.961426,0.926941},
{0.95459,0.925843},
{0.917969,0.926148},
{0.955078,0.89093},
{0.970215,0.893311},
{0.970215,0.865723},
{0.960449,0.864136},
{0.898438,0.866211},
{0.922363,0.839844},
{0.929688,0.831543},
{0.96582,0.856689},
{0.819336,0.916443},
{0.813477,0.881531},
{0.792969,0.908936},
{0.80957,0.944428},
{0.791016,0.94101},
{0.755859,0.936341},
{0.759766,0.902955},
{0.78418,0.889038},
{0.806641,0.851196},
{0.851563,0.873901},
{0.861328,0.904908},
{0.858398,0.919739},
{0.828125,0.927247},
{0.818359,0.944916},
{0.813477,0.964722},
{0.788574,0.964814},
{0.751465,0.967408},
{0.723145,0.947602},
{0.727539,0.908204},
{0.747559,0.872803},
{0.777344,0.860107},
{0.798828,0.843872},
{0.839355,0.829712},
{0.840332,0.840698},
{0.867188,0.892212},
{0.910645,0.898254},
{0.887695,0.928956},
{0.880859,0.934632},
{0.86084,0.956116},
{0.844238,0.958619},
{0.833496,0.96811},
{0.819336,0.972001},
{0.789063,0.973404},
{0.75,0.976914},
{0.637695,0.852051},
{0.633301,0.881531},
{0.617188,0.878357},
{0.621582,0.836792},
{0.601563,0.838989},
{0.599609,0.876221},
{0.599609,0.894653},
{0.616699,0.896057},
{0.628906,0.902039},
{0.647949,0.883301},
{0.112793,0.873413},
{0.127808,0.873535},
{0.122986,0.86792},
{0.113098,0.869019},
{0.098693,0.85376},
{0.160522,0.963623},
{0.177368,0.941407},
{0.174194,0.926819},
{0.164917,0.915101},
{0.156616,0.902039},
{0.149658,0.889221},
{0.144775,0.874512},
{0.147339,0.862305},
{0.130249,0.861206},
{0.121094,0.862061},
{0.117554,0.866333},
{0.111084,0.865601},
{0.104797,0.858521},
{0.103149,0.845093},
{0.105774,0.828857},
{0.088256,0.836304},
{0.073242,0.848389},
{0.046386,0.863281},
{0.039489,0.876526},
{0.029892,0.894714},
{0.015686,0.891846},
{0.014595,0.868164},
{0.016296,0.848999},
{0.04779,0.834229},
{0.022796,0.822388},
{0.161743,0.968506},
{0.167847,0.985604},
{0.190796,0.955018},
{0.187378,0.952027},
{0.193481,0.928528},
{0.189697,0.913514},
{0.182007,0.904847},
{0.173096,0.897522},
{0.169434,0.886108},
{0.1604,0.873169},
{0.164307,0.859497},
{0.146729,0.848999},
{0.123291,0.844727},
{0.113098,0.85498},
{0.113281,0.862915},
{0.107483,0.857422},
{0.105774,0.844971},
{0.108276,0.831055},
{0.116577,0.825195},
{0.11908,0.822754},
{0.1073,0.821411},
{0.104675,0.819702},
{0.089599,0.822632},
{0.071289,0.833496},
{0.556641,0.948029},
{0.586914,0.950226},
{0.562988,0.94571},
{0.541992,0.929444},
{0.570801,0.977402},
{0.59375,0.980805},
{0.611328,0.952027},
{0.615234,0.983506},
{0.635742,0.950104},
{0.639648,0.986107},
{0.667969,0.985703},
{0.665039,0.938416},
{0.693359,0.932618},
{0.696289,0.984314},
{0.312988,0.699463},
{0.288574,0.707275},
{0.293213,0.715332},
{0.317627,0.710205},
{0.305664,0.719971},
{0.328125,0.71875},
{0.332031,0.738037},
{0.354492,0.736084},
{0.361816,0.76123},
{0.380371,0.75647},
{0.373779,0.770508},
{0.748535,0.791504},
{0.743164,0.769287},
{0.742188,0.79541},
{0.730469,0.776245},
{0.742676,0.744141},
{0.722168,0.748291},
{0.438965,0.425293},
{0.436523,0.407715},
{0.428467,0.410156},
{0.393311,0.439453},
{0.418945,0.442871},
{0.393555,0.459961},
{0.42041,0.459473},
{0.39917,0.471191},
{0.420898,0.46582},
{0.411621,0.499023},
{0.430664,0.492187},
{0.426514,0.523926},
{0.440674,0.517822},
{0.434814,0.536621},
{0.447754,0.532227},
{0.44043,0.543945},
{0.449707,0.539795},
{0.442627,0.407227},
{0.445801,0.422363},
{0.45166,0.404785},
{0.455078,0.419434},
{0.459961,0.40625},
{0.462158,0.416504},
{0.466797,0.412109},
{0.465576,0.40625},
{0.393066,0.700195},
{0.396484,0.683838},
{0.390381,0.685303},
{0.374756,0.704102},
{0.373291,0.687012},
{0.405762,0.699707},
{0.396973,0.71582},
{0.413818,0.712402},
{0.42749,0.72876},
{0.42749,0.720703},
{0.445557,0.720947},
{0.45459,0.734863},
{0.426758,0.746094},
{0.44458,0.753662},
{0.460205,0.744141},
{0.467773,0.767578},
{0.476318,0.756226},
{0.492676,0.780151},
{0.498779,0.767334},
{0.519531,0.776367},
{0.518066,0.785645},
{0.205322,0.862915},
{0.204468,0.859131},
{0.210815,0.86084},
{0.206299,0.86499},
{0.217041,0.862061},
{0.213867,0.858276},
{0.209717,0.856689},
{0.205566,0.856445},
{0.199707,0.856934},
{0.192871,0.858521},
{0.199219,0.862427},
{0.196899,0.86499},
{0.207764,0.868042},
{0.22168,0.864014},
{0.224365,0.859741},
{0.220581,0.855957},
{0.212036,0.852539},
{0.205444,0.85083},
{0.197754,0.851562},
{0.192505,0.854492},
{0.188721,0.8573},
{0.190674,0.864014},
{0.516113,0.811035},
{0.463867,0.850708},
{0.511719,0.877136},
{0.484375,0.80481},
{0.434082,0.808105},
{0.453857,0.787109},
{0.420898,0.776978},
{0.429443,0.766602},
{0.413818,0.749023},
{0.399658,0.726562},
{0.371826,0.717529},
{0.354248,0.703857},
{0.353271,0.719971},
{0.371826,0.734131},
{0.391357,0.744141},
{0.229248,0.863403},
{0.229126,0.856812},
{0.226074,0.856079},
{0.217041,0.842041},
{0.210083,0.841431},
{0.201172,0.840942},
{0.192993,0.843384},
{0.183594,0.847046},
{0.177979,0.852539},
{0.181396,0.861572},
{0.187744,0.868896},
{0.195679,0.869629},
{0.207397,0.87439},
{0.22168,0.870605},
{0.229004,0.870117},
{0.232178,0.861816},
{0.234131,0.856689},
{0.233032,0.846191},
{0.22937,0.846436},
{0.225952,0.846313},
{0.218384,0.833496},
{0.212646,0.832642},
{0.199585,0.831299},
{0.188965,0.834961},
{0.177979,0.839722},
{0.163086,0.843628},
{0.173096,0.86731},
{0.186523,0.875244},
{0.194336,0.876404},
{0.207153,0.889343},
{0.219482,0.88916},
{0.227661,0.889709},
{0.231323,0.870972},
{0.236938,0.865356},
{0.238647,0.858154},
{0.240112,0.844971},
{0.239136,0.834595},
{0.23291,0.834717},
{0.229492,0.834839},
{0.227173,0.834473},
{0.227539,0.828003},
{0.220337,0.828247},
{0.21167,0.826904},
{0.204834,0.816895},
{0.193237,0.818481},
{0.182495,0.822021},
{0.17041,0.824951},
{0.161743,0.834473},
{0.22998,0.891846},
{0.241089,0.875854},
{0.23999,0.889832},
{0.250488,0.878906},
{0.250977,0.871826},
{0.242432,0.869263},
{0.227173,0.901612},
{0.228882,0.904419},
{0.239868,0.904053},
{0.250732,0.900818},
{0.250732,0.888428},
{0.258545,0.878906},
{0.258057,0.872803},
{0.259277,0.866699},
{0.252686,0.86731},
{0.245483,0.864502},
{0.241821,0.859497},
{0.244629,0.854004},
{0.250488,0.851074},
{0.24939,0.842529},
{0.24646,0.834473},
{0.239014,0.827515},
{0.23291,0.827271},
{0.229492,0.828613},
{0.229492,0.823853},
{0.229492,0.821045},
{0.226685,0.823975},
{0.221802,0.824829},
{0.21814,0.822876},
{0.211792,0.817505},
{0.211792,0.808838},
{0.207397,0.807983},
{0.200928,0.809326},
{0.183716,0.802734},
{0.165894,0.80542},
{0.150146,0.814087},
{0.153442,0.825317},
{0.151489,0.834106},
{0.140137,0.836304},
{0.132813,0.832642},
{0.119141,0.830811},
{0.111572,0.839233},
{0.250977,0.853638},
{0.255859,0.852783},
{0.256104,0.849609},
{0.258789,0.842285},
{0.257813,0.831909},
{0.246826,0.827026},
{0.238892,0.821899},
{0.236816,0.824707},
{0.233276,0.82251},
{0.246582,0.856079},
{0.244629,0.858887},
{0.247681,0.858887},
{0.252441,0.855835},
{0.255859,0.855225},
{0.259521,0.856079},
{0.260254,0.854004},
{0.263916,0.850952},
{0.268311,0.845703},
{0.270752,0.831177},
{0.26123,0.816772},
{0.249023,0.82019},
{0.236084,0.811768},
{0.229248,0.818726},
{0.22229,0.811646},
{0.198242,0.802612},
{0.200684,0.799194},
{0.187378,0.791992},
{0.165039,0.789307},
{0.153931,0.798218},
{0.134888,0.810913},
{0.135498,0.824097},
{0.149414,0.831787},
{0.139404,0.833008},
{0.127808,0.82605},
{0.118164,0.826416},
{0.110779,0.83252},
{0.117188,0.825195},
{0.125977,0.823853},
{0.122253,0.814819},
{0.116394,0.81665},
{0.247925,0.863403},
{0.253906,0.865967},
{0.250732,0.862427},
{0.253662,0.858765},
{0.262207,0.857788},
{0.263672,0.856812},
{0.270508,0.853882},
{0.277344,0.849243},
{0.283447,0.842285},
{0.276367,0.83728},
{0.288086,0.824219},
{0.274658,0.81897},
{0.273926,0.802612},
{0.253906,0.814575},
{0.229248,0.809814},
{0.254395,0.864258},
{0.258301,0.86499},
{0.258545,0.864014},
{0.261475,0.862305},
{0.263672,0.859863},
{0.265625,0.859863},
{0.270264,0.860596},
{0.274902,0.862061},
{0.292969,0.854004},
{0.296143,0.848511},
{0.29126,0.834839},
{0.302246,0.826172},
{0.305664,0.809326},
{0.292725,0.80542},
{0.262207,0.862793},
{0.265137,0.864014},
{0.267578,0.868286},
{0.277344,0.871948},
{0.29248,0.867187},
{0.313232,0.862061},
{0.301758,0.840332},
{0.318848,0.8479},
{0.330078,0.82959},
{0.323486,0.817871},
{0.322021,0.808228},
{0.316895,0.795288},
{0.304199,0.79834},
{0.29248,0.788818},
{0.268311,0.793457},
{0.25708,0.79895},
{0.339844,0.822021},
{0.352295,0.841309},
{0.33374,0.81958},
{0.337402,0.814575},
{0.330811,0.789429},
{0.313477,0.770264},
{0.300049,0.781128},
{0.273926,0.770874},
{0.268555,0.779053},
{0.255615,0.788574},
{0.246094,0.794312},
{0.249756,0.800659},
{0.239868,0.798096},
{0.23584,0.796509},
{0.229248,0.795898},
{0.221191,0.789917},
{0.208984,0.79248},
{0.331787,0.834473},
{0.322266,0.849121},
{0.340088,0.860352},
{0.348877,0.845093},
{0.36792,0.858032},
{0.370361,0.853882},
{0.356934,0.834717},
{0.343506,0.819336},
{0.316895,0.862793},
{0.333008,0.873047},
{0.361084,0.872803},
{0.309082,0.875},
{0.327148,0.884705},
{0.348145,0.896545},
{0.354004,0.885559},
{0.290771,0.882202},
{0.30127,0.892822},
{0.315918,0.902527},
{0.335938,0.91211},
{0.346191,0.917603},
{0.358887,0.904908},
{0.373779,0.898804},
{0.390869,0.908631},
{0.412354,0.899048},
{0.419678,0.888733},
{0.430664,0.884827},
{0.36377,0.828613},
{0.428711,0.904053},
{0.419678,0.829712},
{0.412354,0.912049},
{0.398193,0.924744},
{0.422363,0.924256},
{0.375732,0.924622},
{0.387451,0.922608},
{0.394043,0.93863},
{0.408691,0.948121},
{0.363281,0.93396},
{0.37793,0.955414},
{0.38916,0.972611},
{0.357422,0.985001},
{0.351563,0.966614},
{0.328369,0.988701},
{0.327881,0.96872},
{0.290527,0.984704},
{0.297119,0.964814},
{0.269775,0.952729},
{0.252686,0.968811},
{0.248901,0.934021},
{0.227661,0.93863},
{0.241821,0.918152},
{0.228638,0.924012},
{0.217163,0.919922},
{0.211182,0.934815},
{0.203003,0.967804},
{0.348389,0.957703},
{0.327881,0.960328},
{0.300049,0.956513},
{0.2771,0.945008},
{0.26001,0.929444},
{0.252686,0.914429},
{0.21936,0.911133},
{0.213867,0.918824},
{0.206787,0.933838},
{0.202393,0.915833},
{0.205933,0.903931},
{0.192749,0.902405},
{0.18396,0.888916},
{0.34375,0.94043},
{0.328613,0.942627},
{0.305664,0.939118},
{0.289551,0.930542},
{0.277344,0.92035},
{0.268066,0.907654},
{0.292236,0.91034},
{0.283691,0.90094},
{0.279785,0.890503},
{0.265381,0.895752},
{0.26416,0.884644},
{0.269287,0.877502},
{0.301758,0.916748},
{0.321777,0.923157},
{0.215942,0.908143},
{0.193481,0.889832},
{0.17981,0.772583},
{0.18396,0.781006},
{0.158081,0.780518},
{0.140869,0.794678},
{0.126587,0.789185},
{0.19812,0.787354},
{0.207886,0.773804},
{0.209961,0.765015},
{0.194824,0.756714},
{0.164673,0.749756},
{0.144409,0.768066},
{0.21228,0.781494},
{0.218506,0.775513},
{0.217896,0.768677},
{0.219971,0.758423},
{0.207642,0.750977},
{0.194092,0.739258},
{0.229004,0.767212},
{0.229126,0.775513},
{0.23938,0.775513},
{0.239136,0.768188},
{0.237427,0.756226},
{0.248779,0.764038},
{0.253906,0.746826},
{0.26709,0.755615},
{0.274414,0.739258},
{0.291748,0.753662},
{0.221313,0.784424},
{0.229126,0.78418},
{0.236816,0.784424},
{0.245728,0.781494},
{0.25,0.773682},
{0.229126,0.789429},
{0.237061,0.789917},
{0.979492,0.049805},
{0.961914,0.057129},
{0.961914,0.032227},
{0.986816,0.032227},
{0.979492,0.014648},
{0.961914,0.007324},
{0.944336,0.014648},
{0.937012,0.032227},
{0.944336,0.049805},
{0.962891,0.067871},
{0.987793,0.057129},
{0.998535,0.033691},
{0.984375,0.005859},
{0.959961,0.000488},
{0.933594,0.009766},
{0.925293,0.030762},
{0.9375,0.061035},
{0.922852,0.03125},
{0.13208,0.736084},
{0.154175,0.730713},
{0.177124,0.729248},
{0.178833,0.719482},
{0.195801,0.691406},
{0.187256,0.725342},
{0.208984,0.700195},
{0.207886,0.67334},
{0.223389,0.681641},
{0.161987,0.676758},
{0.185181,0.672852},
{0.16687,0.673828},
{0.318359,0.274902},
{0.315918,0.276855},
{0.307373,0.26416},
{0.304199,0.266113},
{0.303711,0.258301},
{0.292725,0.269043},
{0.28833,0.279297},
{0.28418,0.277344},
{0.285645,0.282227},
{0.301514,0.294922},
{0.303467,0.291016},
{0.317383,0.252441},
{0.313232,0.247559},
{0.30835,0.244141},
{0.287598,0.26123},
{0.269531,0.274414},
{0.273438,0.28125},
{0.266602,0.288574},
{0.262207,0.287598},
{0.264648,0.306152},
{0.260498,0.303711},
{0.259033,0.289551},
{0.248779,0.286133},
{0.238892,0.290039},
{0.235718,0.286133},
{0.22998,0.289551},
{0.22583,0.305176},
{0.219971,0.303223},
{0.560547,0.518799},
{0.563477,0.544434},
{0.541504,0.518311},
{0.549316,0.486816},
{0.530762,0.502686},
{0.522461,0.529053},
{0.538574,0.547607},
{0.540527,0.556152},
{0.523438,0.558105},
{0.522949,0.549561},
{0.506348,0.556885},
{0.508301,0.548584},
{0.49292,0.544189},
{0.489014,0.551514},
{0.479248,0.541016},
{0.5,0.515137},
{0.487305,0.513672},
{0.500977,0.483887},
{0.510254,0.480469},
{0.518066,0.503174},
{0.522949,0.48291},
{0.536621,0.484863},
{0.509277,0.52832},
{0.297363,0.364746},
{0.30542,0.361328},
{0.299561,0.366699},
{0.293457,0.371582},
{0.285645,0.367187},
{0.290527,0.378418},
{0.643066,0.904053},
{0.646973,0.912537},
{0.635742,0.913147},
{0.625977,0.917542},
{0.612793,0.911927},
{0.615234,0.924134},
{0.601074,0.920411},
{0.600586,0.927857},
{0.58252,0.928101},
{0.588867,0.915711},
{0.576172,0.908631},
{0.567871,0.919312},
{0.557129,0.905823},
{0.563965,0.897217},
{0.586426,0.895447},
{0.567871,0.876404},
{0.585449,0.875122},
{0.581055,0.839722},
{0.571289,0.837158},
{0.548828,0.851685},
{0.879395,0.817627},
{0.88623,0.825195},
{0.894043,0.81665},
{0.771484,0.853516},
{0.745605,0.864502},
{0.336914,0.700195},
{0.35376,0.687744},
{0.340088,0.74292},
{0.364258,0.763672},
{0.371582,0.770874},
{0.276855,0.879944},
{0.149414,0.15332},
{0.152954,0.162598},
{0.154541,0.146484},
{0.165283,0.171387},
{0.156616,0.181152},
{0.124573,0.076172},
{0.134644,0.105469},
{0.153198,0.094238},
{0.143188,0.117676},
{0.166626,0.138184},
{0.182495,0.158203},
{0.185303,0.090332},
{0.189453,0.131836},
{0.214844,0.128906},
{0.210083,0.15625},
{0.219849,0.085449},
{0.183472,0.052734},
{0.223755,0.044434},
{0.248779,0.089355},
{0.240845,0.128418},
{0.232788,0.157715},
{0.257324,0.161621},
{0.26123,0.133301},
{0.272461,0.144531},
{0.26709,0.161621},
{0.147827,0.057617},
{0.149536,0.040039},
{0.178955,0.03125},
{0.213135,0.009277},
{0.238159,0.01123},
{0.259277,0.04248},
{0.277588,0.055176},
{0.270264,0.10791},
{0.130493,0.061035},
{0.128662,0.038086},
{0.149414,0.016602},
{0.182983,0.01123},
{0.291992,0.071289},
{0.289063,0.099609},
{0.293457,0.223145},
{0.264893,0.219727},
{0.284912,0.208984},
{0.304199,0.216309},
{0.303223,0.199219},
{0.276123,0.191895},
{0.254883,0.203613},
{0.236084,0.211914},
{0.24585,0.229004},
{0.271484,0.232422},
{0.300781,0.234375},
{0.311523,0.233887},
{0.325439,0.214355},
{0.316895,0.187988},
{0.289795,0.179687},
{0.275391,0.17041},
{0.281982,0.161133},
{0.304199,0.166016},
{0.292236,0.146973},
{0.32959,0.236328},
{0.327148,0.243652},
{0.252197,0.241211},
{0.22583,0.234863},
{0.232788,0.250488},
{0.260254,0.256836},
{0.279053,0.246582},
{0.240601,0.266602},
{0.248291,0.281738},
{0.221802,0.253906},
{0.214844,0.238281},
{0.194458,0.225586},
{0.22998,0.27002},
{0.21167,0.220215},
{0.201294,0.217773},
{0.23645,0.281738},
{0.175171,0.307129},
{0.158081,0.302246},
{0.169189,0.3125},
{0.152466,0.30957},
{0.161499,0.319336},
{0.153564,0.324219},
{0.145386,0.319824},
{0.144653,0.324219},
{0.137329,0.319824},
{0.140991,0.316406},
{0.13269,0.314941},
{0.143311,0.307129},
{0.130493,0.306641},
{0.131836,0.296875},
{0.146118,0.297363},
{0.147217,0.292969},
{0.131592,0.290527},
{0.13269,0.281738},
{0.128296,0.272949},
{0.36377,0.637695},
{0.364014,0.614746},
{0.340576,0.59668},
{0.339111,0.583008},
{0.317627,0.58667},
{0.3125,0.574463},
{0.284424,0.574951},
{0.260742,0.589844},
{0.238037,0.60791},
{0.220581,0.62793},
{0.216309,0.639648},
{0.363281,0.647217},
{0.375,0.645996},
{0.378174,0.634521},
{0.388184,0.625488},
{0.392334,0.612305},
{0.388672,0.600098},
{0.377197,0.592041},
{0.36377,0.5896},
{0.351563,0.59082},
{0.351074,0.588867},
{0.36377,0.578125},
{0.348389,0.567139},
{0.330566,0.563965},
{0.331299,0.574707},
{0.381104,0.636719},
{0.390869,0.641846},
{0.411133,0.628418},
{0.406738,0.610352},
{0.390137,0.598877},
{0.378662,0.588623},
{0.36377,0.587402},
{0.390869,0.583496},
{0.379639,0.567139},
{0.36377,0.566895},
{0.354736,0.557129},
{0.347168,0.548828},
{0.391113,0.651367},
{0.394287,0.64624},
{0.415771,0.655518},
{0.431641,0.641113},
{0.432373,0.629395},
{0.432129,0.619629},
{0.421875,0.60498},
{0.411133,0.58667},
{0.373047,0.557129},
{0.371338,0.551025},
{0.380615,0.548828},
{0.397217,0.563965},
{0.396484,0.574707},
{0.415527,0.574463},
{0.433838,0.588135},
{0.443359,0.574951},
{0.449463,0.59082},
{0.468018,0.575928},
{0.463623,0.59082},
{0.480713,0.595947},
{0.484619,0.57959},
{0.497803,0.588623},
{0.5,0.603271},
{0.481445,0.607666},
{0.485596,0.617432},
{0.495117,0.625732},
{0.507813,0.617432},
{0.507324,0.62793},
{0.502441,0.634521},
{0.51123,0.639893},
{0.493164,0.6604},
{0.484863,0.65625},
{0.473877,0.680176},
{0.4646,0.678223},
{0.479004,0.693604},
{0.499268,0.703613},
{0.497803,0.703857},
{0.494629,0.70752},
{0.500488,0.714355},
{0.488281,0.710205},
{0.474365,0.703369},
{0.476563,0.698242},
{0.455811,0.692871},
{0.459961,0.688232},
{0.44165,0.678711},
{0.434082,0.684326},
{0.404297,0.669922},
{0.410889,0.663086},
{0.38208,0.653076},
{0.36377,0.558105},
{0.356445,0.551025},
{0.36377,0.545898},
{0.568359,0.432617},
{0.566895,0.415039},
{0.558105,0.424316},
{0.543457,0.433594},
{0.53418,0.418945},
{0.547852,0.414551},
{0.558105,0.411621},
{0.569336,0.405762},
{0.580566,0.405273},
{0.578125,0.419434},
{0.554688,0.397949},
{0.564453,0.395508},
{0.574219,0.389648},
{0.54248,0.398926},
{0.527832,0.400879},
{0.543457,0.385254},
{0.557129,0.389648},
{0.565918,0.380859},
{0.549805,0.372559},
{0.931152,0.710937},
{0.919434,0.73584},
{0.934082,0.742676},
{0.948242,0.745605},
{0.94873,0.752075},
{0.931641,0.749268},
{0.987793,0.728027},
{0.982422,0.723145},
{0.977051,0.731201},
{0.981934,0.73584},
{0.96875,0.74585},
{0.965332,0.73999},
{0.991699,0.718994},
{0.716309,0.624512},
{0.69873,0.633301},
{0.707031,0.643799},
{0.723145,0.632568},
{0.730957,0.643311},
{0.716797,0.658203},
{0.691895,0.654785},
{0.686035,0.638428},
{0.687012,0.635986},
{0.70166,0.626709},
{0.719238,0.618652},
{0.73291,0.613281},
{0.738281,0.617187},
{0.753906,0.640381},
{0.737305,0.660889},
{0.725098,0.674561},
{0.703125,0.669434},
{0.67627,0.657227},
{0.680176,0.636963},
{0.669922,0.651123},
{0.656738,0.667969},
{0.662598,0.681152},
{0.63916,0.683594},
{0.640137,0.705322},
{0.616699,0.699463},
{0.614258,0.678223},
{0.596191,0.689941},
{0.597656,0.675537},
{0.583496,0.674561},
{0.57666,0.695801},
{0.570313,0.680908},
{0.567383,0.661133},
{0.560059,0.668701},
{0.5625,0.658691},
{0.555664,0.66626},
{0.550781,0.677734},
{0.555664,0.681152},
{0.544922,0.689697},
{0.541504,0.68457},
{0.531738,0.689209},
{0.531738,0.695801},
{0.542969,0.712646},
{0.555176,0.706299},
{0.557617,0.709473},
{0.544434,0.716309},
{0.546387,0.722168},
{0.563477,0.713379},
{0.533691,0.740723},
{0.702637,0.608398},
{0.711914,0.597656},
{0.732422,0.609131},
{0.687988,0.615723},
{0.675781,0.625},
{0.685059,0.612061},
{0.697266,0.602539},
{0.706543,0.592773},
{0.132446,0.012695},
{0.119446,0.011719},
{0.584961,0.296875},
{0.542969,0.273437},
{0.538574,0.309082},
{0.591797,0.316406},
{0.543457,0.336426},
{0.597168,0.338867},
{0.549805,0.352539},
{0.590332,0.35498},
{0.55957,0.360352},
{0.577148,0.36377},
{0.586426,0.276367},
{0.547852,0.253906},
{0.586426,0.257812},
{0.578125,0.242187},
{0.555176,0.242187},
{0.565918,0.237793},
{0.303467,0.359375},
{0.262695,0.371094},
{0.646484,0.725586},
{0.674805,0.704834},
{0.71582,0.686035},
{0.688965,0.727539},
{0.65332,0.747803},
{0.624023,0.732178},
{0.261963,0.009277},
{0.742676,0.689941},
{0.729004,0.699707},
{0.696289,0.740479},
{0.658203,0.760742},
{0.627441,0.755615},
{0.604004,0.707031},
{0.59082,0.704346},
{0.588379,0.696777},
{0.579102,0.699463},
{0.57959,0.70752},
{0.566406,0.696533},
{0.754883,0.674805},
{0.776367,0.649658},
{0.783203,0.693359},
{0.766113,0.709473},
{0.745605,0.715576},
{0.762695,0.729248},
{0.732422,0.724365},
{0.637695,0.775513},
{0.620605,0.789185},
{0.611328,0.81665},
{0.597168,0.813354},
{0.581055,0.808472},
{0.565918,0.804321},
{0.537598,0.800293},
{0.597168,0.717285},
{0.59375,0.708008},
{0.579102,0.712402},
{0.600586,0.908631},
{0.616699,0.825073},
{0.602539,0.825684},
{0.581543,0.821899},
{0.712891,0.233887},
{0.660645,0.24707},
{0.710938,0.260742},
{0.703613,0.316895},
{0.679688,0.283203},
{0.652344,0.29834},
{0.625977,0.271484},
{0.620117,0.245605},
{0.626465,0.238281},
{0.657715,0.223145},
{0.694824,0.22168},
{0.720703,0.221191},
{0.919922,0.188477},
{0.948242,0.186523},
{0.946777,0.239746},
{0.937012,0.249512},
{0.92627,0.262207},
{0.707031,0.192383},
{0.915039,0.143555},
{0.942871,0.142578},
{0.918945,0.106934},
{0.944336,0.109863},
{0.92627,0.08252},
{0.950195,0.085449},
{0.92334,0.067871},
{0.953613,0.074707},
{0.401367,0.382812},
{0.411865,0.391113},
{0.418457,0.378418},
{0.422363,0.384766},
{0.441406,0.390625},
{0.434814,0.383301},
{0.443359,0.383301},
{0.44751,0.389648},
{0.450928,0.381348},
{0.47998,0.384277},
{0.463379,0.370605},
{0.482666,0.374023},
{0.504395,0.387207},
{0.499023,0.411621},
{0.507813,0.408203},
{0.51416,0.423828},
{0.504395,0.42627},
{0.505859,0.44043},
{0.521973,0.434082},
{0.51709,0.456055},
{0.504883,0.453125},
{0.442139,0.371094},
{0.451172,0.370117},
{0.451172,0.350586},
{0.466309,0.352539},
{0.486084,0.35791},
{0.521973,0.364746},
{0.519531,0.379395},
{0.530273,0.443848},
{0.537109,0.452148},
{0.529785,0.468262},
{0.432617,0.373535},
{0.411621,0.359375},
{0.427002,0.353516},
{0.395996,0.366211},
{0.439209,0.350586},
{0.552734,0.444824},
{0.035675,0.04541},
{0.040496,0.02002},
{0.022399,0.042969},
{0.034271,0.09082},
{0.008995,0.050781},
{0.010597,0.09375},
{0.043487,0.14502},
{0.017898,0.149414},
{0.079162,0.018066},
{0.084594,0.043945},
{0.085266,0.016113},
{0.100159,0.04248},
{0.090698,0.083984},
{0.04187,0.013672},
{0.07965,0.01123},
{0.473389,0.140625},
{0.442383,0.101562},
{0.47876,0.101074},
{0.484131,0.134277},
{0.496826,0.107422},
{0.497559,0.08252},
{0.477539,0.081543},
{0.443848,0.082031},
{0.419189,0.103027},
{0.435303,0.137207},
{0.447998,0.13916},
{0.472656,0.18457},
{0.484863,0.183594},
{0.497803,0.132812},
{0.507324,0.111328},
{0.51709,0.102539},
{0.407959,0.0625},
{0.407959,0.091309},
{0.410156,0.106445},
{0.418701,0.131836},
{0.431885,0.183594},
{0.446289,0.18457},
{0.470459,0.225586},
{0.487061,0.219238},
{0.518066,0.175293},
{0.506836,0.131836},
{0.514648,0.129395},
{0.515137,0.11377},
{0.929688,0.265625},
{0.946289,0.249023},
{0.959473,0.263184},
{0.871582,0.02002},
{0.800781,0.032715},
{0.781738,0.030273},
{0.78125,0.04834},
{0.745605,0.040527},
{0.715332,0.016113},
{0.712891,0.026367},
{0.687988,0.029785},
{0.681641,0.049316},
{0.664551,0.04248},
{0.658203,0.05127},
{0.688477,0.077148},
{0.658691,0.075684},
{0.65332,0.110352},
{0.683594,0.12207},
{0.664063,0.170898},
{0.632813,0.156738},
{0.603516,0.21582},
{0.598145,0.225586},
{0.608887,0.243652},
{0.617676,0.273926},
{0.62207,0.286621},
{0.638672,0.301758},
{0.621582,0.316895},
{0.652344,0.331055},
{0.624023,0.343262},
{0.655273,0.341309},
{0.632324,0.351562},
{0.614258,0.357422},
{0.613281,0.371094},
{0.535156,0.18457},
{0.723633,0.077637},
{0.693848,0.162109},
{0.686035,0.179687},
{0.694336,0.194824},
{0.402344,0.093262},
{0.405273,0.141113},
{0.411377,0.129883},
{0.403809,0.185059},
{0.430908,0.223145},
{0.444092,0.226562},
{0.105896,0.667969},
{0.51123,0.313965},
{0.514648,0.284668},
{0.49707,0.285645},
{0.494629,0.311035},
{0.474854,0.285645},
{0.478271,0.311523},
{0.460693,0.316895},
{0.455078,0.286133},
{0.494141,0.317383},
{0.503418,0.333984},
{0.492432,0.328125},
{0.479248,0.317871},
{0.48999,0.340332},
{0.490967,0.34668},
{0.497559,0.343262},
{0.491699,0.333496},
{0.481445,0.329102},
{0.470215,0.335937},
{0.482178,0.333496},
{0.484375,0.340332},
{0.477295,0.344238},
{0.48877,0.342773},
{0.485596,0.342773},
{0.483398,0.34668},
{0.370361,0.461426},
{0.394287,0.470215},
{0.374268,0.473145},
{0.368164,0.47168},
{0.373779,0.436523},
{0.39502,0.499023},
{0.378418,0.499023},
{0.395264,0.519531},
{0.379639,0.520264},
{0.395752,0.5354},
{0.38208,0.534668},
{0.394531,0.542725},
{0.384521,0.543457},
{0.358643,0.498535},
{0.341797,0.493652},
{0.346924,0.466309},
{0.344482,0.534668},
{0.347168,0.528564},
{0.335938,0.533203},
{0.335938,0.525635},
{0.349854,0.517822},
{0.337158,0.51416},
{0.335205,0.075195},
{0.34082,0.078125},
{0.342041,0.072266},
{0.343018,0.074219},
{0.345947,0.074219},
{0.3479,0.078125},
{0.347168,0.072266},
{0.354004,0.074707},
{0.349121,0.06543},
{0.361572,0.063477},
{0.350586,0.060059},
{0.353271,0.046387},
{0.368896,0.044434},
{0.354248,0.041504},
{0.35791,0.01709},
{0.378418,0.014648},
{0.326416,0.063965},
{0.340088,0.064941},
{0.311279,0.011719},
{0.319092,0.043945},
{0.334473,0.014648},
{0.337158,0.040527},
{0.338135,0.045898},
{0.339355,0.060059},
{0.136597,0.183105},
{0.330566,0.149902},
{0.334717,0.151855},
{0.335938,0.149902},
{0.328613,0.14209},
{0.337402,0.142578},
{0.342773,0.152344},
{0.33667,0.155762},
{0.329834,0.155762},
{0.331787,0.151855},
{0.324219,0.15332},
{0.317383,0.144043},
{0.327881,0.138184},
{0.338379,0.137695},
{0.348633,0.143066},
{0.340576,0.091797},
{0.320068,0.092773},
{0.340576,0.119141},
{0.324951,0.119141},
{0.309082,0.124023},
{0.299561,0.095215},
{0.356934,0.121582},
{0.361084,0.089355},
{0.325928,0.125},
{0.340332,0.124512},
{0.289795,0.518066},
{0.30127,0.511963},
{0.297119,0.517822},
{0.2771,0.524902},
{0.262939,0.531982},
{0.245239,0.540039},
{0.218628,0.516113},
{0.18689,0.475586},
{0.186768,0.443848},
{0.182251,0.415039},
{0.180298,0.38623},
{0.183228,0.365723},
{0.215454,0.360352},
{0.237671,0.357422},
{0.253174,0.356934},
{0.238037,0.342773},
{0.258545,0.341797},
{0.273682,0.351074},
{0.273926,0.338379},
{0.295166,0.342285},
{0.305664,0.318359},
{0.307861,0.333008},
{0.325195,0.327148},
{0.330322,0.308105},
{0.35498,0.31543},
{0.345215,0.34082},
{0.399902,0.304199},
{0.396484,0.317383},
{0.406982,0.320312},
{0.414063,0.309082},
{0.430664,0.312012},
{0.414551,0.32959},
{0.403809,0.325195},
{0.395264,0.321777},
{0.383545,0.319824},
{0.383057,0.296875},
{0.401855,0.29834},
{0.416748,0.304199},
{0.445801,0.289062},
{0.429199,0.282715},
{0.410645,0.272461},
{0.388672,0.268066},
{0.397461,0.333496},
{0.394287,0.330078},
{0.394775,0.33252},
{0.398193,0.337891},
{0.391357,0.335449},
{0.386719,0.331055},
{0.399658,0.331543},
{0.405273,0.336426},
{0.211792,0.561279},
{0.239746,0.556641},
{0.265381,0.550293},
{0.280518,0.535889},
{0.283691,0.546631},
{0.200684,0.543457},
{0.187988,0.563721},
{0.169678,0.543213},
{0.179688,0.515137},
{0.146484,0.364258},
{0.14978,0.353516},
{0.185303,0.358887},
{0.506348,0.966401},
{0.523438,0.962525},
{0.510742,0.973404},
{0.494141,0.97551},
{0.437988,0.947205},
{0.434814,0.965424},
{0.455566,0.979401},
{0.431885,0.975907},
{0.45459,0.984101},
{0.469482,0.987008},
{0.468018,0.983109},
{0.485596,0.986207},
{0.497559,0.981904},
{0.70166,0.823608},
{0.181641,0.194336},
{0.148438,0.565186},
{0.15564,0.567627},
{0.163086,0.57251},
{0.141602,0.567627},
{0.134888,0.56958},
{0.129395,0.575439},
{0.126831,0.580078},
{0.129028,0.586426},
{0.128784,0.592773},
{0.130127,0.597168},
{0.143677,0.60376},
{0.153931,0.601318},
{0.160156,0.598145},
{0.164429,0.593506},
{0.16687,0.588379},
{0.167847,0.584717},
{0.169434,0.580078},
{0.862793,0.798706},
{0.876465,0.802002},
{0.890137,0.784668},
{0.884277,0.761719},
{0.862793,0.760254},
{0.848145,0.741455},
{0.812988,0.753906},
{0.800293,0.665527},
{0.813477,0.699219},
{0.825195,0.676758},
{0.835938,0.680664},
{0.826172,0.704102},
{0.805664,0.713867},
{0.821289,0.718018},
{0.814941,0.731201},
{0.804199,0.740479},
{0.785156,0.726318},
{0.791016,0.741211},
{0.802246,0.749512},
{0.792969,0.759033},
{0.111694,0.046875},
{0.115173,0.084961},
{0.083984,0.143555},
{0.109375,0.146484},
{0.599609,0.044922},
{0.530762,0.023437},
{0.564453,0.012207},
{0.59668,0.023926},
{0.618164,0.040527},
{0.630371,0.068848},
{0.625,0.106934},
{0.600586,0.138184},
{0.921387,0.708252},
{0.537598,0.809814},
{0.592773,0.714355},
{0.584473,0.716309},
{0.954102,0.958039},
{0.200806,0.543457},
{0.451172,0.350098},
{0.682129,0.32373},
{0.71582,0.329102},
{0.754395,0.335937},
{0.681152,0.319336},
{0.65918,0.323242},
{0.684082,0.330078},
{0.905273,0.294922},
{0.910156,0.311035},
{0.909668,0.305176},
{0.900391,0.32666},
{0.914063,0.330078},
{0.912598,0.346191},
{0.925293,0.346191},
{0.888184,0.333008},
{0.447266,0.47168},
{0.445313,0.444336},
{0.466309,0.438477},
{0.480713,0.466309},
{0.45459,0.490723},
{0.481934,0.483887},
{0.859863,0.96402},
{0.845703,0.964631},
{0.835449,0.970414},
{0.838867,0.971314},
{0.853516,0.976212},
{0.870117,0.972107},
{0.874512,0.964905},
{0.741699,0.970215},
{0.720215,0.950318},
{0.719238,0.947724},
{0.723145,0.907349},
{0.739258,0.870605},
{0.590332,0.534424},
{0.585938,0.585205},
{0.596191,0.585937},
{0.62207,0.61084},
{0.646484,0.600098},
{0.945801,0.37793},
{0.895508,0.655273},
{0.868164,0.643799},
{0.864258,0.650146},
{0.85791,0.636475},
{0.86377,0.633545},
{0.839355,0.611084},
{0.842285,0.60791},
{0.826172,0.589844},
{0.830566,0.587402},
{0.825195,0.568115},
{0.830078,0.567627},
{0.820313,0.543213},
{0.825684,0.539795},
{0.803711,0.531738},
{0.794922,0.537598},
{0.780762,0.402344},
{0.812012,0.407227},
{0.851563,0.408203},
{0.884277,0.388184},
{0.928223,0.444824},
{0.934082,0.48877},
{0.934082,0.530273},
{0.867676,0.607666},
{0.867188,0.577393},
{0.862793,0.540527},
{0.855469,0.49707},
{0.807617,0.494141},
{0.8125,0.461914},
{0.855957,0.45752},
{0.894531,0.450195},
{0.897949,0.492187},
{0.897949,0.535889},
{0.599121,0.61792},
{0.590332,0.619629},
{0.60498,0.654297},
{0.618652,0.648437},
{0.629395,0.640869},
{0.654785,0.60791},
{0.635742,0.643555},
{0.621094,0.655029},
{0.600098,0.657715},
{0.602051,0.378418},
{0.09497,0.605713},
{0.096069,0.624512},
{0.08197,0.625977},
{0.079772,0.602051},
{0.061492,0.625},
{0.094787,0.643799},
{0.094665,0.634766},
{0.098754,0.63208},
{0.112549,0.583252},
{0.116699,0.593018},
{0.094665,0.583252},
{0.059783,0.60376},
{0.040069,0.624268},
{0.158081,0.558105},
{0.152344,0.513428},
{0.03778,0.604248},
{0.013595,0.623047},
{0.013595,0.604004},
{0.09497,0.666748},
{0.102051,0.357422},
{0.068481,0.355469},
{0.040771,0.352539},
{0.013595,0.351562},
{0.121155,0.344238},
{0.168091,0.56665},
{0.908691,0.958619},
{0.947266,0.963837},
{0.913574,0.968628},
{0.893066,0.967408},
{0.896484,0.959412},
{0.87793,0.97551},
{0.873535,0.983002},
{0.868164,0.979706},
{0.864258,0.992005},
{0.861328,0.987206},
{0.84668,0.993702},
{0.847656,0.9888},
{0.834961,0.986107},
{0.837891,0.980011},
{0.294189,0.313477},
{0.314453,0.29834},
{0.337891,0.281738},
{0.364014,0.287598},
{0.071899,0.323242},
{0.042297,0.321289},
{0.013595,0.318848},
{0.102295,0.326172},
{0.125,0.333008},
{0.118958,0.297363},
{0.10199,0.294434},
{0.099792,0.271484},
{0.071472,0.27002},
{0.101257,0.252441},
{0.090087,0.246582},
{0.10675,0.23291},
{0.093261,0.214844},
{0.071899,0.230469},
{0.060882,0.210449},
{0.08905,0.19873},
{0.079956,0.180176},
{0.051788,0.188477},
{0.027786,0.227539},
{0.018585,0.194824},
{0.013595,0.236328},
{0.013595,0.193359},
{0.013595,0.291992},
{0.045593,0.289551},
{0.073852,0.29248},
{0.790039,0.56958},
{0.765137,0.570557},
{0.787598,0.563232},
{0.800781,0.557617},
{0.78418,0.559814},
{0.75293,0.563232},
{0.743652,0.575684},
{0.766602,0.575439},
{0.783203,0.578125},
{0.794922,0.571045},
{0.805176,0.56543},
{0.805664,0.570801},
{0.70752,0.566406},
{0.714355,0.578125},
{0.744141,0.582275},
{0.753418,0.589844},
{0.780762,0.589111},
{0.756836,0.600342},
{0.78125,0.606201},
{0.765137,0.612549},
{0.783691,0.619141},
{0.765137,0.635254},
{0.716309,0.585937},
{0.729004,0.591064},
{0.799805,0.712891},
{0.013595,0.262207},
{0.027999,0.259766},
{0.044586,0.250488},
{0.044677,0.170898},
{0.085998,0.168945},
{0.38501,0.781128},
{0.400635,0.761963},
{0.394531,0.789795},
{0.376465,0.799805},
{0.395996,0.81311},
{0.381104,0.815796},
{0.897461,0.80603},
{0.939941,0.78064},
{0.912109,0.753906},
{0.876953,0.741455},
{0.862793,0.73999},
{0.853027,0.726318},
{0.825195,0.72998},
{0.899902,0.72998},
{0.872559,0.726318},
{0.881836,0.702393},
{0.871094,0.705811},
{0.862793,0.706787},
{0.862793,0.727295},
{0.854492,0.705811},
{0.843262,0.702393},
{0.862793,0.671875},
{0.856934,0.671143},
{0.868164,0.671143},
{0.259766,0.575928},
{0.243286,0.57959},
{0.227783,0.603271},
{0.219727,0.617432},
{0.22998,0.588623},
{0.345703,0.65332},
{0.31665,0.672852},
{0.293213,0.688232},
{0.275391,0.696045},
{0.260498,0.692871},
{0.255371,0.705078},
{0.240234,0.705566},
{0.235352,0.71582},
{0.233887,0.709961},
{0.227661,0.717529},
{0.228516,0.706055},
{0.230103,0.705811},
{0.236572,0.700928},
{0.235229,0.695312},
{0.258057,0.687744},
{0.462158,0.683105},
{0.444824,0.67334},
{0.415283,0.657227},
{0.443359,0.636719},
{0.443604,0.635254},
{0.435059,0.628906},
{0.434082,0.620117},
{0.440918,0.612305},
{0.439941,0.610596},
{0.437012,0.599609},
{0.454346,0.635986},
{0.45459,0.634521},
{0.447754,0.623047},
{0.451904,0.611084},
{0.452148,0.609131},
{0.454102,0.655518},
{0.475586,0.63623},
{0.470215,0.624512},
{0.463135,0.626465},
{0.460205,0.625977},
{0.459473,0.615723},
{0.460938,0.614502},
{0.443359,0.666992},
{0.467285,0.614014},
{0.465332,0.605225},
{0.906738,0.328613},
{0.283936,0.013184},
{0.520508,0.593994},
{0.527832,0.638672},
{0.536133,0.597656},
{0.548828,0.638916},
{0.553711,0.655029},
{0.565918,0.569336},
{0.556152,0.561523},
{0.556152,0.572021},
{0.553223,0.58667},
{0.550293,0.598389},
{0.334473,0.689941},
{0.757324,0.827881},
{0.942871,0.327148},
{0.932129,0.317383},
{0.957031,0.303223},
{0.958008,0.330078},
{0.973145,0.326172},
{0.98291,0.315918},
{0.986328,0.301758},
{0.981934,0.288086},
{0.971191,0.278809},
{0.956055,0.275391},
{0.941406,0.279297},
{0.931152,0.289551},
{0.927734,0.303711}
};


// normal array: 33kb.
const tgx::fVec3 cyborg_norm_array[2869] PROGMEM = {
{-0.33469809389978283,0.9132947988009311,0.23209867820179142},
{0.10739897971453904,0.29899715954047645,0.9481909922283606},
{-0.6030914904391044,0.5374924160355142,0.5893916837420132},
{-0.6932788241217208,-0.37538853393234384,0.6151812095769258},
{0.033001070572094324,-0.9584310920089454,0.2834091939433797},
{-0.21691160291196795,-0.8746467861079169,0.43352318977564824},
{-0.29901030855808436,-0.8771302395862737,0.37581295637501044},
{-0.36888755763251807,-0.7867734625786533,0.4948833078675337},
{-0.17939622733700827,-0.9348803396731828,0.30629355871418973},
{-0.29090900377300233,-0.7645236623735313,0.5752178032665209},
{0.00040000756821478666,-0.8410159121715889,0.5410102360104989},
{0.000600018054814908,-0.9825295647594121,0.18610560000175733},
{0.18039718582585149,-0.9347854174612303,0.3059952265116993},
{0.29139472288935225,-0.7648861480372874,0.5744895960876214},
{0.38649613119309,-0.7790922013260968,0.49359505913818685},
{0.30000418508757315,-0.875112207900451,0.37970529692583843},
{0.3850981091729259,-0.8234959566447793,0.41659795450906506},
{0.05900063072011361,-0.9499101545938292,0.30690328081360796},
{0.6133034651743673,-0.19300109045924166,0.7659043273716745},
{0.02929911371521497,-0.9175722438594285,0.39648800641920595},
{-0.2031977922679804,0.709292293581095,0.6749926662445216},
{-0.5231228217309078,0.5117223243733618,0.681529732383127},
{-0.25231578915452496,0.39342461931585465,0.8840553214926677},
{0.0018000251285261925,0.31220435840326516,0.9500132622777127},
{-0.3628199756036505,-0.1843101474745115,0.9134502913902268},
{-0.660531967218099,-0.051402487683588634,0.7490362504865348},
{-0.7738355469522925,-0.16120740523224292,0.6125281371262331},
{-0.3809874009549722,0.798273601528489,0.4664845736102219},
{0.3878188406969327,-0.33821643095333326,-0.8574416555274629},
{0.026502041663422342,-0.48723753578941004,-0.8728672439183026},
{0.4826079003559937,-0.3415055904922749,-0.8065132027291938},
{0.6807308752490362,-0.2536115028105709,-0.6872311700765943},
{0.6894387544416114,-0.3999224802744421,-0.6039339480813594},
{0.6726262396614238,-0.24590959312034513,-0.6979272266721791},
{0.7319978259696852,0.0034999896050463093,-0.6812979765480144},
{0.5349357054752827,0.030102009225660885,-0.8443563584460295},
{0.29342031565885635,-0.19461347453037983,-0.9359648037666108},
{0.029098658291798536,-0.21099027146286908,-0.977054949034926},
{0.6612275340877911,-0.45581898069754256,0.5958248106616847},
{0.5881018201779502,-0.39920123552973596,0.7034021770331069},
{0.5971070608327418,-0.4505053272569925,0.6637078483917112},
{0.6932484978950647,-0.3864270334487205,0.608342558092279},
{0.6730320202600639,0.5196247217342187,0.5263250405094675},
{0.30290075573832836,0.9244023063866317,0.23180057834316448},
{0.3050945434328856,0.8119854777695941,0.49759110066274626},
{0.42821675002577236,0.49471935132589806,0.7562295804985731},
{0.15390298497734076,0.708413739817727,0.6888133596646673},
{0.19989862270323433,0.3875973294635999,0.8998937997530795},
{0.0029999597258110193,0.5383927721255509,0.8426886869803154},
{-0.03830365932337109,0.8021766355946724,0.5958569249311879},
{0.029998612596250394,-0.037298274994671324,0.9988538040798173},
{0.05119806244598941,0.7667709821012633,0.6398757843591527},
{0.05600042644487107,0.9421071741734471,-0.3306025175477567},
{-0.1138080641560888,0.9417667312459473,-0.31642242090497796},
{-0.023800355341957905,0.40790609008338774,-0.9127136269161755},
{-0.15151178428730222,0.40723167367517804,-0.9006700523375867},
{-0.18060461902219802,0.02550065218751965,-0.9832251463046793},
{-0.322807692598973,0.6623157831731717,-0.6761161120389271},
{-0.42852049448273466,0.25991243060924796,-0.8653413859414476},
{-0.5738448505970161,0.7747605537774632,-0.26542074476899286},
{-0.7745076599186351,0.2671026416581891,-0.5734056710101296},
{-0.004900159282266247,0.9693315086327905,-0.24570798686792183},
{-0.47873599751303036,0.7548567598137358,0.44833371147919676},
{-0.401084255746555,0.7066722601248826,0.5828771196077459},
{0.3533096225186057,0.25800702691706845,0.8992244907125113},
{0.3379871618014838,0.41058440424760134,0.8468678323363213},
{0.7524908723410774,-0.35049574851235565,0.5575932364350629},
{-0.03170052036831281,0.6992114776506093,0.7142117238816721},
{0.24770642930380996,0.9688251461830081,-0.004400114206446362},
{0.5505199016541736,0.3416123495096562,0.7617275369482001},
{0.5397074237266704,-0.5622077332205561,0.6266086190608332},
{0.386399998068,-0.007599999962,0.9222999953885},
{0.16730560315847623,-0.712223852776251,0.6817228312799357},
{-0.7341191387354234,-0.050801324407791185,0.6771176526873114},
{0.03239907987919696,-0.6651811091247475,0.7459788145024979},
{0.08370105045477486,0.012500156877953236,0.9964125050554082},
{-0.15769345664577192,0.7546686856725685,0.6368735734793414},
{-0.45580147452015507,0.8745028290212279,-0.1658005363656027},
{-0.3060059289223099,0.5213101004810462,-0.7966154345735688},
{-0.7588544080172441,0.4189300362657137,-0.49863575097179474},
{-0.5369373264956722,0.6344441049149829,-0.5560386543706346},
{-0.3403967458226648,0.7389929352613083,-0.5813944418957032},
{-0.3543928253898742,0.8467828570545867,-0.39669196905237897},
{-0.5772791865741354,0.7450731368723164,-0.3340879546759373},
{-0.8197436361151565,0.4932262551323597,-0.2911154964903283},
{-0.9448005290884444,0.2428001359681142,-0.22000012320010348},
{-0.8781929349662573,0.18779848916723196,-0.4398964610472063},
{-0.587918725509616,0.3395108135916221,-0.7342233853872427},
{-0.11809852495863485,0.20839739713276462,-0.970887873686186},
{0.030399827785463393,0.29859830844537394,-0.9538945962024188},
{0.039700461719054704,0.6329073607554087,-0.773208992472874},
{-0.04069850781656586,0.7649719528175155,-0.6427764330341164},
{-0.04150111826269759,0.9125245883063023,-0.40691096436365415},
{0.006100086530341154,0.9871140023114349,-0.15990226822976236},
{-0.38920413726196873,0.9053096234924468,-0.17010180819183168},
{-0.5312265991817482,0.8379419568041921,-0.12510626422747873},
{-0.5749067666924661,0.8182096303840247,0.003900045903810433},
{-0.8348862328395297,0.550390924128491,0.005899902711406426},
{-0.964123086203702,0.2653063528366789,0.008900213118154702},
{-0.9949628637041554,0.10019626024437826,0.0030998842989777707},
{-0.975649656952968,0.13260674919225457,-0.17470889203534595},
{-0.9741719929577979,-0.011899657889753435,-0.2254935171545714},
{-0.8603924113723973,-0.10919903686874219,-0.4977956094620866},
{-0.5779890154231417,-0.009899811855863503,-0.8159844923620825},
{-0.1627984550499923,0.12669879763411565,-0.9784907141671835},
{0.0021001423839795462,0.12880873288407885,-0.9916672323591039},
{-0.5795001535675611,0.731100193741577,-0.3601000954265379},
{-0.7656707818787665,0.5170477981077878,-0.38263537244881934},
{-0.36601331397644826,0.539419621745618,-0.7583275846675975},
{-0.34801656250232355,0.694133034577192,-0.6301299885997531},
{-0.05689981706738219,0.5270983053816723,-0.847897274014646},
{0.0,0.37101132343838966,-0.9286283421695112},
{0.0,0.4477335588879051,-0.8941670203298547},
{-0.4310174393183993,0.5752232740045088,-0.6952281294991908},
{-0.2986116625062232,0.9212359795737871,-0.24930973698192044},
{-0.5164193919122563,0.856332155876191,0.0025000938802878406},
{-0.9164772393741595,0.3907329304053733,0.08600724856632225},
{-0.7730903750847449,0.6259922064455442,-0.10229872638878464},
{0.04399894557790368,0.33079207266296673,-0.9426774090065864},
{-0.4745020640884682,0.7872034243423439,-0.3939017134761804},
{0.2726959709467937,0.2798958645691513,-0.9204863999139112},
{-0.2586054876666731,0.3862081954248613,-0.8854187887860492},
{0.0541991003024024,0.3283945486957371,-0.9429843465897687},
{0.0,0.16350699007324163,-0.9865421755795283},
{-0.0541991003024024,0.3283945486957371,-0.9429843465897687},
{0.05689981706738219,0.5270983053816723,-0.847897274014646},
{0.36601331397644826,0.539419621745618,-0.7583275846675975},
{0.4310174393183993,0.5752232740045088,-0.6952281294991908},
{0.0,0.637524733251799,-0.7704298894073506},
{0.0,0.9462558307410692,-0.3234190822887992},
{0.0,0.5151867469913983,0.8570779519532754},
{0.2622022955911469,0.5903051681443707,0.7634066836547732},
{0.40481109804838156,0.6663182673657032,0.6262171679789934},
{-0.544288205402382,0.7792831131179061,0.3105932695167735},
{-0.5362967044668766,0.6847957919427877,0.4933969680849467},
{-0.9030163041065573,0.1480026722123704,0.40330728177870934},
{-0.7525631403600556,0.4363786266982836,0.49317584483866517},
{-0.18160746331206037,-0.569423400935502,-0.8017329478925044},
{-0.10400852436793619,-0.6675547116884366,-0.7372604246542553},
{-0.3412991109169741,-0.8983976596771449,-0.2763992799808135},
{-0.4882248659256485,-0.8369426265734846,-0.24731259595127583},
{-0.46171762409807415,-0.8774334922756124,0.13010496620134165},
{-0.3652194740215461,-0.9114485997350413,-0.18941009961577446},
{-0.3253213726896413,-0.7674504193114994,-0.5524362934944909},
{-0.4991116319321248,-0.3417079635968885,-0.7963185584202584},
{0.17680643233501467,-0.1372049916083937,-0.9746354578829484},
{0.1759982224269302,-0.04859950914743641,-0.9831900698304419},
{0.20219635443259404,0.030099457311676958,-0.978882350910318},
{-0.12500352702427317,-0.5241147881073727,-0.8424237693219818},
{-0.4276965891333025,-0.8784929940463087,-0.2128983021428106},
{-0.5538348594631164,-0.8228517919217266,0.12720800672392274},
{0.8778867835139607,-0.3352949521724923,0.3418948528117361},
{0.8589142495055999,-0.33190550635802607,0.3900064702610129},
{0.7034510864729169,-0.21561565857770953,0.6772491836216368},
{0.29700096079966226,-0.31420101644193227,0.9017029170136548},
{0.4186201779788796,0.26301267751659185,0.8692418984692837},
{0.11749915694657335,0.4522967547824266,0.8840936566507702},
{0.3670168005785785,-0.3372154363899092,0.866939685072397},
{0.35978525450351007,-0.6531732302437264,0.6662726933732316},
{-0.990357880974964,-0.12529467133094002,-0.05909748663733883},
{-0.9808259726156368,0.1124029764702259,0.15920421578345165},
{-0.9535932247442073,0.3010978607072995,-0.00019999857901514413},
{-0.7584378242374655,0.5921295302360277,0.27231358061690647},
{-0.4296066997687248,0.4543070849742357,0.7804121706227021},
{-0.4490984483675413,0.19609932247801123,0.8716969882921082},
{-0.7034510864729169,-0.21561565857770953,0.6772491836216368},
{-0.35978525450351007,-0.6531732302437264,0.6662726933732316},
{-0.8589142495055999,-0.33190550635802607,0.3900064702610129},
{-0.8778867835139607,-0.3352949521724923,0.3418948528117361},
{-0.7636488407234627,-0.4947316415739877,0.41482653107921996},
{-0.4884115071106629,-0.6514153475263837,0.5806136794194326},
{-0.2917213124790032,-0.6754493467546065,0.6772494782680183},
{-0.4063044307739765,-0.6621072203186066,0.629706866990827},
{-0.29700096079966226,-0.31420101644193227,0.9017029170136548},
{-0.840209070105868,-0.1926020791506667,0.5069054720741067},
{-0.617624007511767,-0.25690998628525413,0.7433288937556614},
{-0.929291534192685,-0.354196773282093,0.1046990461960337},
{-0.8458937657859191,-0.2411982223756516,0.47569649412975734},
{-0.3948218480714613,-0.46982599854096385,0.7895436906089632},
{-0.22940104836518652,-0.7023032095330013,0.6739030797441117},
{-0.1681026820996895,-0.4438070809984664,0.8802140439271071},
{-0.27028298622150915,-0.10589333422440925,0.9569397625378626},
{-0.12450315930775166,-0.3856097849724421,0.9142231987080045},
{0.03639931187751337,-0.010599799612682464,0.9992811087692063},
{0.02070067506002074,0.5398176037390916,0.8415274426573649},
{0.06550175350541232,-0.08140217916550478,0.9945266238340849},
{0.10849952531561512,0.28389875794565095,0.9526958319648527},
{0.34799459046613646,0.585490898614721,0.732188618216394},
{0.42332000445947726,0.4536214363874767,0.784237059997926},
{0.4312055518072196,0.19910256346200697,0.8800113302188154},
{0.9535932247442073,0.3010978607072995,-0.00019999857901514413},
{0.9808259726156368,0.1124029764702259,0.15920421578345165},
{0.990357880974964,-0.12529467133094002,-0.05909748663733883},
{0.7584378242374655,0.5921295302360277,0.27231358061690647},
{0.8373056350858862,0.5050033986843098,0.2095014099492334},
{0.5159113217981867,0.128702824414473,0.8469185858323014},
{0.7890968199462235,0.3361986451221902,0.5140979281895242},
{0.7977614491094351,0.15249263097165813,0.5833718092384614},
{0.881092400610817,-0.36479685364070596,-0.30099740390858687},
{0.9542485152278026,-0.03620184054836141,-0.29681509046280846},
{0.6764190583754583,-0.6862193345021282,-0.2675075371310395},
{0.93163977720945,0.08740373178199436,-0.35271505949095433},
{0.5781369238937544,-0.7615486378569347,-0.2929187078506844},
{0.2709088886664581,-0.9354306919845143,0.22710745151772846},
{0.4470031714987527,-0.8385059492208146,-0.3116022108255287},
{0.4797140030561268,-0.8588250694696722,0.1797052456726829},
{0.17180404345574465,-0.9165215705889987,-0.3612085011421128},
{-0.026600083923397168,-0.9983031496514058,-0.05180016342977343},
{-0.3148954765589686,-0.6435907548852086,-0.6975899791919228},
{-0.5508168304653862,-0.6785207325177279,-0.4860148504106349},
{0.023299598201893482,-0.6933880426263065,-0.7201875804722612},
{0.11420043567549315,-0.6193023626430202,-0.7768029635089587},
{0.36813606069330385,-0.7445729344910752,-0.5568545465743863},
{0.3629973210896555,-0.8759935351915653,-0.3175976561379465},
{0.2833968089698964,-0.8985898819348938,-0.3349962279637096},
{0.3009121646201371,-0.8745353538062809,-0.38031537455978115},
{0.038701856572590745,-0.8034385418713025,-0.5941285010278078},
{-0.0004000098683651803,-0.6729166010573246,-0.7397182490743097},
{0.12200188738379684,-0.6085094137134458,-0.7841121303084846},
{0.39549482300665,-0.40329472090665475,-0.82518919834409},
{0.4536219875906207,-0.48272339817017773,-0.7491363115170502},
{0.44689421946065666,-0.7384904476878383,-0.5048934692452127},
{0.29520710129223343,-0.7913190354083479,-0.5354128795117268},
{0.3130070975164052,-0.7519170499124124,-0.5802131564824866},
{0.013700240167315218,-0.6522114333666412,-0.7579132863363652},
{-0.26800809396665853,-0.4742143214887667,-0.8386253268673128},
{-0.5821202988887395,-0.2812098059569036,-0.7629266037145154},
{-0.6199344755148017,-0.0709039430779149,-0.7814434572790225},
{-0.003600235715148659,-0.15591020777546555,-0.9877646710700918},
{-0.45529855670586283,-0.11639963101375453,-0.8826972018543051},
{0.20331088860621677,0.16060860162399612,-0.9658517275744425},
{0.14449794453135847,0.32159542533761165,-0.9357866885290329},
{-0.4348308697392031,-0.036702605610461715,-0.8997638765049701},
{-0.5192204654779782,0.44731763137191766,-0.7282287037000457},
{0.15679606054846743,0.6734830789502093,-0.7223818503840108},
{-0.10949991130510776,0.8910992782098769,-0.4403996432764334},
{-0.7651132710047794,0.6019104402271294,-0.22870396690470923},
{-0.23419305276613303,0.9711711906339384,-0.044498679966237915},
{-0.9255316814916954,0.37801293960438775,0.022300763368195364},
{-0.32520917753248674,0.9024254668060149,0.28260797530959647},
{-0.6101247776703419,0.6739273687461784,0.4166169191566374},
{-0.9885251335710357,0.09990254005437173,0.11330288076236553},
{-0.3969203268104172,0.8101414884079593,0.4314220936911414},
{-0.9698902720493567,0.2417975747824873,-0.029099708131391153},
{-0.6669819983987916,0.629683005085036,0.3982892503181989},
{-0.8850510999004217,0.28721658292813684,0.36632115016217454},
{-0.9605016376566883,0.13470022966408735,-0.24350041516856177},
{-0.9237611982257856,-0.2353901126459731,0.30208731108899095},
{-0.9660488350029452,-0.2569129872797688,0.027301380119648454},
{-0.5125228513407519,-0.5687253571853378,0.6433286834487917},
{-0.4011169054282264,-0.6491273580490196,0.646327240035559},
{-0.38581872037848014,-0.3196155081206902,0.8654419922642217},
{-0.12099889165522863,0.45039587439268575,0.8845918971753327},
{-0.4186201779788796,0.26301267751659185,0.8692418984692837},
{-0.9319576433629181,-0.18381136908477771,-0.3125193299183517},
{-0.2671977328368553,-0.13029889441857126,-0.95479189862511},
{-0.3005062581079883,-0.1297027010868755,-0.9449196781571986},
{-0.9220667554824358,-0.06409768899948394,-0.38168623855074907},
{-0.32940040022172945,0.018900022963541853,-0.9440011469620903},
{0.41713121509678225,-0.1343100507971658,-0.8988672647542265},
{0.41141489348872134,-0.1558056402662683,-0.8980325093652692},
{0.29350892574214976,0.08980273094257257,-0.9517289425172195},
{-0.1495996312373635,0.11009972860450348,-0.9825975778999557},
{-0.7237213030500875,0.07300214884987755,-0.686220199188849},
{-0.8830906657809937,-0.13719854981899257,-0.4486952573161951},
{-0.9940559818389703,-0.059603356657547915,0.09110513072990965},
{-0.8834641506610539,-0.14611060947654514,0.44513232223141846},
{-0.9383342075970683,-0.01480053956350486,0.34541259224557963},
{-0.7879799225273577,-0.3109920760228531,0.5313864604454795},
{-0.8197577252726591,-0.5158363238936655,-0.24881752110264438},
{-0.31170085562002303,-0.16410045045635477,-0.9359025690560782},
{0.4945136364015382,0.030800849345131196,-0.8686239526357454},
{0.9468331160673619,-0.2234078138249352,-0.23150809713729856},
{0.8861366602319665,-0.2994123869466773,-0.3537146334770867},
{0.8958755389307317,-0.22031857694400556,-0.3858325328415676},
{0.7847272697464438,0.016500573404888905,-0.6196215322223737},
{0.6451731710315124,0.20979127601117684,-0.7346694494061565},
{0.20651026484782772,0.25531269063268974,-0.9445469498729941},
{-0.13249785023981966,0.30159510665909134,-0.9441846807278318},
{-0.6061091947462269,0.35570539609178836,-0.7114107921835767},
{-0.9658882452115833,0.19069767922336572,-0.17519786785492225},
{0.08370482362944646,0.144508327532318,0.985956817398701},
{-0.03289970077858212,-0.048299560717492904,0.9982909205853657},
{0.0,-0.03779944567519373,0.9992853455878595},
{0.0,-0.3119946945753277,0.9500838439615988},
{-0.08370482362944646,0.144508327532318,0.985956817398701},
{0.03289970077858212,-0.048299560717492904,0.9982909205853657},
{0.0,-0.06890162024065016,0.9976234593914747},
{-0.07549729649021816,-0.0643976939598682,0.9950643673829946},
{-0.363514028277032,0.11760453844670966,0.9241356630833709},
{-0.44340277127598077,0.005500034375322269,0.8963056019275181},
{-0.3210873156961352,0.1017959786292948,0.9415628042961098},
{0.12929950155138226,-0.2838989055718285,0.9500963373856789},
{0.0,-0.15820110741162782,0.9874069118725747},
{-0.12929950155138226,-0.2838989055718285,0.9500963373856789},
{0.3210873156961352,0.1017959786292948,0.9415628042961098},
{0.44340277127598077,0.005500034375322269,0.8963056019275181},
{0.363514028277032,0.11760453844670966,0.9241356630833709},
{0.07549729649021816,-0.0643976939598682,0.9950643673829946},
{-0.09980057086089798,0.6934039662820307,0.7136040818270221},
{0.0,0.7066065997364624,0.7076066090765933},
{0.09980057086089798,0.6934039662820307,0.7136040818270221},
{-0.33310504491410814,0.19590296697290238,0.9223139685508314},
{-0.5287219397720957,0.13840574326547767,0.8374347500759466},
{-0.5854256978250214,0.021700952584220987,0.8104355748503542},
{-0.5252045246564699,-0.13180113547167316,0.8407072427240943},
{-0.2930019631197293,-0.041600278722801164,0.9552063999043191},
{0.15910756017533684,0.07960378246358778,0.9840467580925925},
{0.0,0.12149896665568287,0.9925915580446981},
{-0.15910756017533684,0.07960378246358778,0.9840467580925925},
{0.2930019631197293,-0.041600278722801164,0.9552063999043191},
{0.5252045246564699,-0.13180113547167316,0.8407072427240943},
{0.5854256978250214,0.021700952584220987,0.8104355748503542},
{0.5287219397720957,0.13840574326547767,0.8374347500759466},
{0.33310504491410814,0.19590296697290238,0.9223139685508314},
{0.011700613420738295,0.890146667162321,0.45552388146549516},
{0.0,0.6855362486874993,0.7280384960532451},
{-0.011700613420738295,0.890146667162321,0.45552388146549516},
{-0.1630012404441597,0.3673027951849071,0.9157069685565462},
{-0.3084989973798878,0.16729945627765067,0.9363969567148361},
{-0.504105159542712,0.007600077787194229,0.8636088390817022},
{-0.45882249661852736,0.018100887508272333,0.8883435565523928},
{-0.5250244142029039,0.059002743691373954,0.8490394812538388},
{-0.8060189819705407,0.2403056592649143,0.5409127386449943},
{-0.8157396703847797,0.23791156992097473,0.5272256396062962},
{-0.8188762774978563,0.0731978794881464,0.5692835080956523},
{-0.8159350818830345,-0.2006086253532746,0.5422233133925498},
{-0.5786017184496557,-0.15210045173901252,0.8013023798716024},
{-0.4071152793231549,-0.07570284118094528,0.9102341617291465},
{-0.21041493157333546,-0.06160437160131875,0.9756692359455612},
{0.15420454910129872,-0.0044001298057439325,0.9880291472897739},
{0.0,0.01930026509096155,0.9998137325359253},
{-0.15420454910129872,-0.0044001298057439325,0.9880291472897739},
{0.21041493157333546,-0.06160437160131875,0.9756692359455612},
{0.4071152793231549,-0.07570284118094528,0.9102341617291465},
{0.5786017184496557,-0.15210045173901252,0.8013023798716024},
{0.8159350818830345,-0.2006086253532746,0.5422233133925498},
{0.8188762774978563,0.0731978794881464,0.5692835080956523},
{0.8157396703847797,0.23791156992097473,0.5272256396062962},
{0.8060189819705407,0.2403056592649143,0.5409127386449943},
{0.5250244142029039,0.059002743691373954,0.8490394812538388},
{0.45882249661852736,0.018100887508272333,0.8883435565523928},
{0.5041797424649135,0.007599694650403297,0.8635653026431958},
{0.3084989973798878,0.16729945627765067,0.9363969567148361},
{0.1630012404441597,0.3673027951849071,0.9157069685565462},
{-0.5500920072212022,0.8328878982267575,-0.060799116595253756},
{-0.38751428985291236,0.9218339932552635,-0.007400272890094327},
{-0.33470830588966727,0.3002074497402991,-0.8932221655830619},
{0.1827995713355078,0.9470977790583122,0.2637993813911759},
{0.3127240353293883,0.8192629668750718,-0.48063694077167907},
{-0.14540065939348554,0.45910208203266306,-0.8764039745010366},
{-0.08180431079173875,0.3636191614165796,-0.927948899555677},
{0.3205948625084921,-0.24869601467829694,-0.9139853535020643},
{-0.12730233029048413,0.6211113695476803,-0.7733141556451798},
{-0.10940592722666562,0.9720526623795154,0.20771125306196023},
{-0.3931053344755835,0.4962067335710621,0.7741105047508247},
{-0.16549946543758995,0.34499888565539893,0.9238970158174583},
{0.3778194940997101,0.9026465732514514,0.2061106345525417},
{0.07790190667249901,0.5870143673524636,0.8058197226790719},
{-0.0952045142290658,-0.41821983036339616,0.9033428330159152},
{0.5084106869049593,-0.8608180945865244,-0.022600475066978914},
{-0.6681034908498596,0.6375033309636065,0.383702004848213},
{-0.5015028034085066,0.7809043652676029,0.37240208173345535},
{-0.7078959614650597,0.5713967401908958,0.4151976313042701},
{-0.1469070421578528,0.30961484174316695,0.9394450333770382},
{-0.12139729711926912,0.20559542246887755,0.9710783791805786},
{0.5089892477157119,-0.3189932613385306,0.7994831110976653},
{0.5162135017407093,-0.4013104964133023,0.7566197896494009},
{0.269211430960043,-0.008800373671799326,0.9630408915844035},
{0.2770986962537012,-0.00939995577331213,0.9607954794679036},
{-0.5398408000102494,-0.26652014302099203,0.7984603459210506},
{0.08390127069436706,-0.07410112226999523,0.9937150499283975},
{-0.49899114298581737,-0.09589829782032042,0.8612847123320331},
{-0.9203971559771821,-0.1678994811914047,0.35309890892605716},
{-0.9322344280531538,0.2817104037573197,0.22710838726761556},
{-0.8926126484108426,0.14430204477446182,0.42710605213563846},
{-0.40900915168215446,0.030500682460405163,0.9120204066849019},
{0.0017000110076069112,0.028000181301760893,0.9996064724728639},
{0.6055817359302623,-0.1219963206464531,0.7863762832489404},
{0.6524274742994263,-0.0539022698723775,0.7559318329597431},
{0.07790123902906021,-0.14530231105163607,0.9863156874757649},
{-0.5146277366093169,-0.392421150107843,0.7623410874801445},
{-0.9124625423260501,-0.2890198100966993,0.2896198512249278},
{-0.9561140215149391,-0.2885042309455705,-0.051100749397984924},
{-0.9720466156132044,-0.23471125584816777,-0.006000287750698793},
{-0.9537143344341706,0.3007045196228952,0.002400036072813263},
{-0.9113543639092591,0.3945235340307283,0.11740700353664767},
{-0.8664311920843826,0.20600741640048803,0.45481637368418426},
{-0.7127406772712109,0.2804160037980181,0.6429366934441721},
{-0.05370139249516133,0.11660302355560169,0.9917257157812196},
{0.726225425597233,0.013500472659821875,0.6873240636367093},
{0.709495849461421,-0.2223986989714165,0.6686960881393266},
{0.669399230191328,-0.19629977425538944,0.7164991760264214},
{0.6876945466038681,0.012399901669169643,0.7258942436814713},
{0.900432195528737,-0.2308082526966154,0.36871318357557237},
{0.4666158838750353,-0.11440389437484791,0.8770298546043848},
{-0.07610023933562907,-0.2459007733591483,0.9663030390278367},
{-0.3999066425044984,-0.16860280051577503,0.9009149643218372},
{-0.7101176608458405,-0.5835145121863794,0.39400979914555867},
{-0.7612797121660025,-0.40748914055910423,0.5043865582773305},
{-0.8921517061504883,-0.4482259776893273,-0.05620325735417268},
{-0.7022900345751136,-0.5096927675109433,-0.49699294772010744},
{-0.8272314147094717,-0.3086117197525906,-0.46951783027816363},
{-0.8578066994964847,-0.2823022047888291,-0.4295033544342972},
{-0.923972007944478,0.15021170645444376,-0.3517274111852721},
{-0.8978696908606891,0.37882940398532977,-0.22431741107156666},
{-0.9233566866070396,0.38282350225622735,-0.029301798892652723},
{0.5666899526762078,0.7135873482084735,0.4118926972072172},
{0.9661192549486286,0.22070439868249908,0.13380266671372168},
{0.7397278364822402,0.6727253151299214,0.015600587061136872},
{0.4736107676632057,0.6261142348689465,0.6194140825392517},
{0.7081084371622934,0.7060084121403463,0.011600138216470279},
{0.6380262202262914,0.7305300217481283,-0.24341000313962277},
{0.9627011841231847,0.1760002164803994,-0.20550025276546635},
{0.9659898523299015,0.08949905981731489,-0.24259745152715748},
{0.9843109554419015,0.14090156824318187,0.10620118202573396},
{0.5714035255706291,0.23230143330426523,0.7871048564519465},
{0.33370497390970444,0.3665054628046349,0.8685129452819249},
{0.1097055940308631,0.46432367646791006,0.8788448134395851},
{0.562126074822735,0.2569119171356709,0.7861364657857178},
{0.621022040463331,0.1569055686774503,0.7679272542218871},
{0.6322904809384637,0.15489766803316155,0.7590885720075721},
{0.5385999326750126,0.01019999872500024,0.8424998946875198},
{0.6194396918699255,0.033002114678249185,0.7843502588530556},
{0.6287218956212792,-0.15450538074357822,0.7621265415189706},
{0.7560472619915668,-0.2163135221809205,0.6177386160478715},
{0.7655154827072082,-0.030100608790969256,0.6427129990018586},
{0.9913541194986155,-0.1312071627945308,0.0013000709728116615},
{0.8902890183526876,-0.04369946097047338,0.4532944086479538},
{0.9005976719580269,0.4344988768218551,-0.011599970014116268},
{0.5216041050404601,0.6833053776344831,-0.5109040208304659},
{0.6725403200008122,-0.4848290663738198,-0.5591335210594114},
{0.4261104717935181,0.3500086015670765,-0.8342205012207294},
{0.2957969059805451,-0.44779531608549045,-0.8437911739904798},
{-0.2507120369738496,0.18070867603180943,-0.9510456607982887},
{-0.055999455407944224,-0.4540955839419191,-0.8891913526561429},
{-0.8125327050995836,0.12650509193242748,-0.569022903632816},
{-0.9385862920473063,-0.3390950475529955,-0.06379906822141289},
{0.46669375801272955,-0.048499351325514,0.883088188774462},
{0.4757823630746952,-0.16749379112024262,0.863467991834803},
{0.3075059087828064,0.06360122210922436,0.9494182432468177},
{-0.47800705304610186,-0.22400330519315234,0.8493125316988585},
{-0.4757823630746952,-0.16749379112024262,0.863467991834803},
{-0.29930821013680764,-0.06520178850958856,0.9519261116913704},
{-0.4309206997729823,-0.6464310520613965,0.6296302450152464},
{0.0,-0.04870065429768576,0.9988134191484299},
{-0.4128034593074836,-0.08540071566099587,0.9068075990795206},
{-0.3362016171336676,-0.1015004882185225,0.9363045036354937},
{-0.3075059087828064,0.06360122210922436,0.9494182432468177},
{-0.46669375801272955,-0.048499351325514,0.883088188774462},
{0.469504164520409,-0.744906607350911,0.4740042044359401},
{0.8752861148841818,-0.3754369373029272,0.3048299906497928},
{-0.015601105533508543,-0.9884700454692208,-0.15061067265040942},
{0.0810030518474686,-0.9946374736727441,-0.06430242263941026},
{-0.42641317423853026,-0.9010278376850746,-0.07950245626633011},
{-0.49419520138789164,-0.8572916757382426,-0.14429859886740748},
{-0.09389792393985229,-0.9809783108093194,-0.16989624363557937},
{-0.23810228341184692,-0.9211088334760698,-0.30800295376248993},
{-0.6263938582383297,-0.7751923992757874,-0.08189919698231037},
{-0.3360014767297354,-0.8961039383854639,-0.2900012745584025},
{-0.4844330103900303,-0.8730594923007772,-0.05560378897127515},
{-0.09710353754631039,-0.9012328325101434,-0.422315385229731},
{-0.14460795582554065,-0.8084444777964527,-0.5705313886477935},
{-0.25179864532693225,-0.9415949342328809,-0.22359879704170788},
{-0.18800096538743588,-0.8443043355138943,-0.5018025767628476},
{-0.2674115671375102,-0.9472409737945013,-0.17670764365444297},
{-0.13110764969898903,-0.8293483897434906,-0.5431316899429516},
{-0.3036021950518053,-0.9513068779735917,-0.05330038536317926},
{0.13290392736908146,-0.8395248083246344,-0.5268155676300387},
{-0.1357107283571317,-0.9846778418602202,0.10950865700151748},
{0.1824000355680104,-0.790700154186545,-0.5844001139580334},
{0.004999948500795662,-0.9165905591658606,0.39979588212362105},
{-0.08990528613670216,-0.793846675587477,-0.6014353624317318},
{-0.4313986626662186,-0.47819851758689325,0.7649976285110275},
{-0.10450231736458163,-0.7828173591674115,-0.613413602597458},
{-0.5207351143526812,-0.5113344804465639,0.6836460998108178},
{-0.04669975949685788,-0.8234957590077616,-0.5653970882124936},
{-0.45571147723808314,-0.48171213207282126,0.7485188516846725},
{0.33912368861700376,-0.9218643944770099,-0.18751309824738485},
{0.018299856072197987,-0.6099952024065995,0.7921937694205052},
{0.0,-0.35102480253366547,-0.9363661612885213},
{0.0,-0.53042136315061,-0.8477341431801887},
{-0.14940729050661475,-0.4261207930714092,-0.8922435380856872},
{-0.1282000737150636,-0.12050006928755976,-0.9844005660304882},
{0.3612180523232586,-0.160608026586698,-0.9185459054787182},
{0.33160637851003655,-0.5101098120566032,-0.7936152653364444},
{-0.1687036398202941,-0.5150111114845968,-0.8404181322168061},
{-0.13420016842131707,-0.4121005171864736,-0.9012011310081292},
{0.0,-0.4273038243863425,-0.9041080918036327},
{0.13420016842131707,-0.4121005171864736,-0.9012011310081292},
{0.1687036398202941,-0.5150111114845968,-0.8404181322168061},
{0.14940729050661475,-0.4261207930714092,-0.8922435380856872},
{0.1282000737150636,-0.12050006928755976,-0.9844005660304882},
{0.0,-0.04620148655674533,-0.9989321411587211},
{0.0,0.1457041540846503,-0.9893282061492418},
{0.19290346650643997,0.15980287168340646,-0.9681173972259437},
{0.6148288822651325,0.26991267944593245,-0.7410348109278841},
{0.765206848631943,-0.07410066320390353,-0.6395057236018394},
{0.6539034068456245,-0.5534028832365325,-0.5159026878600057},
{0.219007696065662,-0.5594196583521979,-0.7994280923967589},
{0.10769712775590361,-0.5066864868515911,-0.8553771873946142},
{-0.2320984844018453,-0.30269802338836094,-0.9243939637271253},
{0.0,-0.24761495639506304,-0.9688585208220398},
{0.2320984844018453,-0.30269802338836094,-0.9243939637271253},
{-0.10769712775590361,-0.5066864868515911,-0.8553771873946142},
{-0.219007696065662,-0.5594196583521979,-0.7994280923967589},
{-0.33160637851003655,-0.5101098120566032,-0.7936152653364444},
{-0.3612180523232586,-0.160608026586698,-0.9185459054787182},
{-0.19290346650643997,0.15980287168340646,-0.9681173972259437},
{0.5745125187641773,-0.5371117037915398,-0.6176134579438746},
{0.8453945176343297,-0.5074967088945141,-0.16659891960950948},
{0.4944202320898541,-0.6114250200237396,-0.6178252819278153},
{0.22060927019630455,-0.39581663256435784,-0.8914374589890566},
{0.5431248458143707,-0.6043276456004865,-0.5829266665903087},
{0.8384130751538613,-0.5161080487677813,-0.17520273230791567},
{0.951216589361979,-0.29720518330359563,0.08280144406977696},
{0.7889447896671001,-0.598533979738572,0.13900789170202424},
{0.2964140800032081,-0.9230438456240254,-0.24521164782991445},
{0.29840726779751187,-0.7317178212045558,-0.6128149252892603},
{0.22359166018660967,-0.24199097390500687,-0.9441647833103616},
{0.313411195247845,-0.07000250053397943,-0.94703382865255},
{0.11239502943973212,-0.06619707249920165,-0.9914561538211245},
{-0.004100203006076371,-0.3399168296988679,-0.9404465626620047},
{0.05409865485367039,-0.12739683231714619,-0.9903753746224612},
{-0.3341074139257734,-0.162503605995026,-0.9284206018817361},
{0.0,-0.2322153731665723,-0.9726643925142473},
{0.3341074139257734,-0.162503605995026,-0.9284206018817361},
{-0.05409865485367039,-0.12739683231714619,-0.9903753746224612},
{0.004100203006076371,-0.3399168296988679,-0.9404465626620047},
{-0.22060927019630455,-0.39581663256435784,-0.8914374589890566},
{-0.4944202320898541,-0.6114250200237396,-0.6178252819278153},
{-0.5431248458143707,-0.6043276456004865,-0.5829266665903087},
{-0.6539034068456245,-0.5534028832365325,-0.5159026878600057},
{-0.765206848631943,-0.07410066320390353,-0.6395057236018394},
{-0.6148288822651325,0.26991267944593245,-0.7410348109278841},
{-0.6212311213525558,0.2946147590960446,-0.7261363767129599},
{-0.05869888649268475,0.34359348209346646,-0.9372822199249304},
{0.0,0.25679120633570596,-0.9664669039075539},
{0.05869888649268475,0.34359348209346646,-0.9372822199249304},
{0.6212311213525558,0.2946147590960446,-0.7261363767129599},
{0.9417771394157851,0.22291825886776948,-0.25172061802161316},
{0.9240066667321508,0.29490212772652735,-0.24340175615000595},
{0.976870351851674,-0.0293021102674591,-0.21181525442484087},
{0.8975098636876032,-0.4381048147983721,-0.050400553905131144},
{0.8663459088861,0.4032213672663922,-0.2947156173943596},
{0.29160122326969745,0.7484031395577557,-0.5957024989772248},
{0.7457014392051664,0.5838011267372618,-0.32110061972479403},
{0.9666079455499688,0.235601936655879,0.10080082858621647},
{0.9250552228198385,0.3781225727007361,-0.036002149212447765},
{0.4799972040244299,0.789395401785177,-0.38269777079197775},
{0.13529975037219083,0.8251984775102134,-0.5483989882048},
{-0.30878897025497026,0.707774718738562,-0.6353773047280055},
{-0.3193169657610983,0.39902120055959356,-0.8595456688746133},
{0.3450035449296363,0.4946050820933279,-0.7977081964938286},
{0.6061091947462269,0.35570539609178836,-0.7114107921835767},
{0.9658882452115833,0.19069767922336572,-0.17519786785492225},
{0.9698417137891844,0.09050389265613651,0.22630973379098002},
{0.646605260155187,-0.04310035062277848,0.761606195691603},
{0.5843069708237432,0.27530328438777424,0.7634091075249795},
{0.7952402202912375,0.26661348431796267,0.5445275401767843},
{0.7551884419293436,0.234596409529428,0.6120906320245647},
{0.701494984328793,0.513396329229369,0.4942964657929043},
{0.7468288505557562,0.6521251920827645,-0.13030503378068428},
{-0.22229993553302801,0.7999997680001009,-0.5572998383830703},
{-0.715811918367662,0.5741095590037368,-0.3975066185402985},
{-0.8211702869729217,0.24452092944206474,-0.5156441358704645},
{-0.6451731710315124,0.20979127601117684,-0.7346694494061565},
{-0.20651026484782772,0.25531269063268974,-0.9445469498729941},
{0.13249785023981966,0.30159510665909134,-0.9441846807278318},
{0.7237213030500875,0.07300214884987755,-0.686220199188849},
{0.9940559818389703,-0.059603356657547915,0.09110513072990965},
{0.8051508509077844,-0.1808114195058097,0.5648356733234586},
{0.2104058146450327,-0.30160833506151075,0.9299256988517866},
{-0.05130331147911257,0.08610555786260414,0.9949642220383841},
{0.7454082591692676,0.15720174180494886,0.6478071777432943},
{0.7629990653267176,0.4851994056310922,0.4270994768034614},
{0.7165933177984672,0.1329987597923474,0.6846936152618064},
{0.7752448337051372,0.37712180958489067,0.506729305003087},
{-0.0056001615949942685,0.6793196020499298,0.733821174715499},
{0.03660196173471017,0.5806311197588175,0.8133435923180268},
{-0.26811186957520494,0.4043178995496284,0.8744387122587065},
{-0.3954171298411051,0.3786164020178108,0.8368362525317066},
{-0.26199925592316975,0.44219874415734983,0.8577975638583779},
{-0.07070143737483289,0.31540641227754307,0.9463192388656911},
{-0.28891965731760116,0.23261582655615795,0.9286631837491328},
{-0.3872092156890014,0.735017493624525,0.5566132475529395},
{-0.47099428922886444,0.4573944541258654,0.7542908542788375},
{-0.19050161355550027,0.28000237163013164,0.9409079695242529},
{-0.29068714464528583,0.35138446036585286,0.8899606423608681},
{-0.3735125147464634,0.4457149339290461,0.8135272576874109},
{-0.34700912298976666,0.5309139579114327,0.7731203256005436},
{0.07680355685507884,0.4035186873831291,0.9117422237600962},
{-0.30650144209267755,0.43530204810095446,0.8465039828106087},
{0.44500292590385676,0.8797057840845457,0.1676011019808683},
{0.4488208145479232,0.8834409705250342,0.1345062378714253},
{0.5813059264441304,0.7776079277532353,0.23960244275935597},
{0.10160394535779885,0.8853343782013713,0.45371761819717854},
{-0.21680920483019073,0.9001382161792191,0.3778160405205077},
{-0.35171536678006926,0.8878387905241555,0.2967129636725805},
{-0.5819083504447438,0.6063087005922807,0.542007777867419},
{-0.6016050775682822,0.386603262945309,0.6990058996346895},
{-0.19970649655800127,0.32771066060118687,0.9234300396677936},
{-0.15179938900868883,0.21159914831514204,0.9654961138859623},
{-0.43848560694617417,-0.10339660606210811,0.8927706952828832},
{-0.5626135985350169,-0.00010000241708763187,0.8267199820634527},
{-0.6143794554945067,0.047598408335837436,0.7875736639770076},
{-0.6071176036301296,0.03540102646764386,0.7938230172320818},
{-0.5278011453297281,0.25590055530480754,0.8099017574887206},
{0.2591111601580072,-0.07090305386029608,0.9632414877043325},
{0.7973980822599182,0.33019920587186474,0.5050987852388822},
{0.3215948995453395,0.5719909282958152,0.7545880323287102},
{0.7871531110121605,0.21481449402288408,0.5781390083548849},
{0.9499486718670866,-0.25561309667252063,0.17960920251324222},
{0.8838469821350363,-0.41032181123557976,0.2246119395649798},
{0.8667051525774482,0.15810093991288166,0.4731028126045814},
{0.12090130936827072,0.5748062251851283,0.8093087648613855},
{-0.050000226751542476,0.31370142263917744,0.9482043001162516},
{0.23560208744374214,0.4846042936130621,0.8424074637631935},
{0.3470090952275804,0.4447116560452594,0.8257216424478765},
{0.7225818056191989,0.2713931664061037,0.6357839911606513},
{0.7608199261348016,0.25370664466403675,0.5973156439015734},
{0.8906100817631887,-0.3280037130230473,0.31500356586054845},
{0.49419520138789164,-0.8572916757382426,-0.14429859886740748},
{0.42641317423853026,-0.9010278376850746,-0.07950245626633011},
{0.8274202182600527,-0.5601136865451481,0.04060099209736299},
{0.9681233030083585,0.08800211823647923,0.23450564461879977},
{-0.11100352219763988,0.7785247029807446,0.6177196005538933},
{-0.8752861148841818,-0.3754369373029272,0.3048299906497928},
{-0.469504164520409,-0.744906607350911,0.4740042044359401},
{0.18179932552575342,-0.6892974427112313,0.7012973981914791},
{0.19929559461957086,0.02659941202649566,0.979578346659968},
{0.1968959026388987,0.35989251071477724,0.9119810218724003},
{0.2548163839461257,0.5074326264296082,0.8231529263189014},
{0.15950887372547487,0.5580310441305015,0.814345303289368},
{0.3200201218977664,0.2871180531151523,0.9028567689040734},
{0.6014078273738103,0.3324043262704598,0.726509455582097},
{0.8414902135257246,0.33049615635205226,0.42739502942471147},
{0.27028298622150915,-0.10589333422440925,0.9569397625378626},
{0.6768390885860813,-0.1301075139259001,0.724541843499728},
{0.7425142452724446,-0.6017115439467069,0.2943056463079871},
{0.6263938582383297,-0.7751923992757874,-0.08189919698231037},
{-0.7984053253812805,0.24210161482315634,0.5513036772077905},
{-0.39949614488080276,-0.16809837785848045,0.901191303545881},
{-0.4716153159560826,-0.18570603090128188,0.8620279948137047},
{0.1301087429507337,0.4978334530428536,0.8574576188006081},
{-0.3857908549361744,-0.24889410003528722,0.8883789412267945},
{-0.34092166455553313,-0.2459156272050619,0.9073576598745533},
{-0.23971241143141112,-0.5920306531806232,0.7694398387790059},
{-0.3331164380362124,-0.5803286370231584,0.7431366709838169},
{0.5039287197161283,0.24201379275908522,0.8291472544485848},
{0.08970459523558943,-0.6489332424567892,0.7555387034614026},
{-0.0158998609563239,-0.59819476880962,0.8011929935979063},
{0.7645043959129149,0.5771033183536208,-0.28720165141424353},
{0.8577212331519434,0.4386108579461844,-0.26820663953754365},
{0.5601157786837314,0.45811290522231274,-0.6902194437555997},
{0.254510461867557,0.7795320433232247,-0.5723235258420546},
{0.14630016312477284,0.5212005811389719,-0.840800937493568},
{0.09990309154900272,0.20270627284267118,-0.9741301449237592},
{0.3328978727893893,0.011399927154698224,-0.9428939749267504},
{0.6820215522215807,0.1368043230849153,-0.718422702516105},
{0.8895277492509636,-0.38601204183347043,-0.2444076244147673},
{0.8238695540037475,0.4654392940438748,0.32342730488566634},
{0.7357248274532107,0.5479184898214139,0.3981134345645279},
{0.697368976689878,0.6189612213873017,0.3613357396788368},
{0.6632648910022175,0.7016628584596051,-0.26028622211348895},
{0.29951783532052206,0.9425561261755995,-0.147908807492171},
{-0.33441018461726113,0.8953272676071589,-0.29420896027032967},
{-0.3031960448333926,0.6987908843323704,-0.647891548309878},
{-0.5830293271127492,0.43962211354848124,-0.6832343675530537},
{-0.5093145716983474,-0.4102117363256669,-0.7565216443938736},
{-0.1905081443972632,-0.7317312821809842,-0.6544279773940632},
{0.28381386180752427,-0.8022391823185201,-0.5252256526473282},
{0.6451983870060487,-0.5935985160055649,-0.4809987975045093},
{0.8873170455241683,-0.3498067198516332,-0.30050577277134294},
{0.9530213955704985,-0.24870558350302516,0.17290388173571794},
{0.9344128155596487,-0.3080042243069048,0.1789024536639781},
{0.5782984414878003,0.6214983250642709,0.5284985756982576},
{0.38149841678485547,0.34419857157889183,0.8578964397371625},
{0.3757873775139805,0.5422817850607546,0.7514747583867917},
{0.24900638709574457,0.7341188303895023,0.6317162037284412},
{-0.07920122208428522,0.9937153331458866,0.0791012205412495},
{-0.0416988904072892,0.9791739445279996,0.19869471280403747},
{-0.5244948468634443,0.8111920300774567,0.25859745929244365},
{0.3643126163643608,0.8283286855190779,-0.42561473929363697},
{0.2884968640561315,0.5517940020317967,-0.7824914943636843},
{-0.245508933005044,0.045301648330462296,-0.968335233518469},
{-0.30381398791801306,0.9502437502294141,-0.06880316777076793},
{0.14440002021600423,-0.3956000553840116,0.9070001269800266},
{-0.7260264714077301,0.4138150879731663,0.5492200249271699},
{-0.5414282253891035,0.8407438291182477,0.002300119908376317},
{-0.6816345563397727,0.48582462950390487,-0.5471277373437348},
{-0.5652427678857885,0.5970451741468785,-0.5692430705601396},
{-0.4313256775819025,0.8285493250095205,-0.3570212541079044},
{-0.7103596229853408,0.3218270120747327,0.6259525384014146},
{-0.3586976882008493,-0.6255959680469788,0.6927955349471657},
{0.7815422005104556,-0.6220335876103691,0.04760257037018259},
{-0.99534169573697,0.0962040300712313,-0.006300263923583755},
{-0.9927605900277705,0.0727044372872156,0.09560583500217071},
{-0.8364948221130766,0.48669698735497235,0.25179844137247187},
{-0.4195061814691262,0.825212159590758,-0.37820557290017526},
{-0.6307322028546962,0.0654033392527305,-0.7732394787494071},
{-0.6173092658816218,0.7830117530946217,0.07630114528878626},
{-0.43409596726719607,0.8770918518545443,0.2055980900026158},
{-0.6179363017343494,0.7483439627574262,0.24111416466766733},
{-0.8400083791253729,0.5078050653807908,0.1911019062510223},
{-0.9499662862102612,0.27601925991581444,0.14621020217279734},
{-0.9839456462973222,0.1320061239061353,0.12010557182671856},
{-0.995849016894947,0.02540125028030895,0.08740430214563001},
{-0.99177703070995,0.0067998425174709215,0.12779704025482114},
{-0.9752624870693839,0.037102377225465694,0.21791396219485107},
{-0.8295432908462288,0.21031097536463159,0.5173269974138085},
{-0.2151145486889084,0.9572647420038266,0.1933130742053277},
{-0.25101535633415,0.8857541876699468,-0.3904238849117616},
{-0.07640450952723238,0.44622633705564246,-0.8916526268911045},
{-0.0981016647993776,-0.2367040169012505,-0.9666164036195554},
{-0.8135957652450628,-0.26329862953419986,-0.5183973017490665},
{-0.7994068509460691,-0.37510321464832436,-0.4693040219527023},
{-0.657215217994561,-0.386908958980669,-0.6468149771741967},
{-0.4177212500204966,-0.3464176227127125,-0.839942728973462},
{-0.21590473916103747,-0.13000285359395494,-0.967721241714386},
{-0.08869939462869748,0.011399922195796521,-0.9959932023695908},
{-0.0003999995760006742,0.0013999985160023595,-0.9999989400016853},
{-0.39192476846838975,-0.35282229730964,-0.8496536955619901},
{0.00010000204106248735,-0.23940488630359472,-0.9709198166756896},
{-0.49801048572116646,0.8642181963056869,0.07150150548004698},
{0.03830019858704451,0.9975051720777259,0.05930030747289137},
{-0.47653776711462503,0.8483672357677575,0.23061827722273356},
{-0.5369096188219826,0.8140145832018881,0.22160397007068602},
{-0.42532190038849105,0.8117417976612701,0.40022060788966407},
{-0.6084954423862048,0.6167953802199031,0.4992962602850156},
{-0.7876984364201557,0.4457991150896349,0.42519915598051317},
{-0.9145128627138718,0.2919041056601194,0.28010393968961783},
{-0.9547681060380921,0.15701120000835914,0.25251801275229735},
{-0.9875442726021334,0.037501681238055695,0.15280685048466428},
{-0.974613542349257,-0.05270073228176261,0.21760302361501982},
{-0.992795309053247,-0.036899825648735715,0.11399946135381765},
{-0.948177478747312,-0.08690710146940345,0.30562497363693547},
{-0.9535180550353097,-0.14920282518224248,0.26180495732380077},
{-0.9470741357585238,0.28139231528080305,0.15449578077783965},
{-0.914528364537096,0.07960246890886041,-0.3966123011212819},
{-0.8548013505872009,-0.27580043576503277,-0.4396006945696461},
{-0.3982051109953997,-0.6670085611098232,-0.6297080823551059},
{-0.9469195351515174,-0.17570362480316995,0.269205553767862},
{-0.8880917141429603,0.19469818347442222,0.41639611504236984},
{-0.8790295490749466,-0.3781127104723974,-0.2904097622882417},
{-0.7461280437495464,-0.543120413564373,-0.3851144747995581},
{-0.7718144292056323,-0.30410568530893073,-0.5584104395807529},
{-0.670633753846268,-0.2663134038909352,-0.6923348460897276},
{-0.8442514164769429,0.30101833257469773,0.44342700552698},
{-0.3460214245797748,0.897655580065913,0.2729168981728917},
{-0.18449465895693368,0.7217791047973698,0.6670806882936068},
{-0.2925084931073978,0.3602104588625118,0.8858257203231897},
{-0.7203177956709659,0.5781142824897755,0.3833094697774277},
{-0.6455090210516042,0.729610196373742,0.22580315562114986},
{-0.5924961665622034,0.7429951928366534,0.31129798590854674},
{-0.6114822030694657,0.6635806867651634,0.4309874562926242},
{-0.6255340612569784,0.6441350741097039,0.44022397084783677},
{-0.40481109804838156,0.6663182673657032,0.6262171679789934},
{-0.2622022955911469,0.5903051681443707,0.7634066836547732},
{-0.4880047117082374,0.6105058944628667,0.6238060228762264},
{0.0,0.4977212581289117,0.8673370447562893},
{0.4880047117082374,0.6105058944628667,0.6238060228762264},
{0.6255340612569784,0.6441350741097039,0.44022397084783677},
{0.6115085550645285,0.6636092839588242,0.43090602841750664},
{0.5924961665622034,0.7429951928366534,0.31129798590854674},
{0.6455090210516042,0.729610196373742,0.22580315562114986},
{0.3460214245797748,0.897655580065913,0.2729168981728917},
{0.7203177956709659,0.5781142824897755,0.3833094697774277},
{0.8442514164769429,0.30101833257469773,0.44342700552698},
{0.18449465895693368,0.7217791047973698,0.6670806882936068},
{0.2924979554464371,0.36029748152940616,0.8857938083229197},
{0.0,0.8863047417430525,0.4631024776048828},
{0.0,0.9900373053085093,0.1408053056438769},
{-0.12490310637888394,0.9183228389730114,0.37560934152048686},
{-0.13450833775773188,0.850352710746464,0.5087315347015481},
{-0.49930125574423734,0.8258020768948351,0.2622006594354877},
{-0.26080890286385144,0.7478255274600771,0.610520840484591},
{-0.43140697590720106,0.8707140795605006,0.2361038178296017},
{0.08169994648655257,0.5530996377198559,0.8290994569400335},
{-0.3613072207969622,0.8953178931068925,0.2605052062485709},
{-0.2844031270295726,0.09870108522439809,0.9536104850049243},
{-0.7361698176562014,-0.16659316982005318,0.655973105653991},
{0.10760014795030515,0.8730012003774758,-0.4757006540888491},
{0.5237970929342014,0.8420953263839078,0.12849928683093714},
{0.48219554212281956,0.15019861142025612,0.8630920207511521},
{-0.37872606103692075,0.028701975050857212,0.9250636558203109},
{0.5015028034085066,0.7809043652676029,0.37240208173345535},
{-0.30890361110432085,0.23300272381776224,0.9221107795380196},
{-0.9621296196162668,-0.05910181947751935,0.2661081922668003},
{0.22090315231047536,-0.8893126905826425,-0.4004057138303048},
{0.21610548698797283,-0.9045229661296688,-0.36760933371947624},
{0.015601105533508543,-0.9884700454692208,-0.15061067265040942},
{-0.0810030518474686,-0.9946374736727441,-0.06430242263941026},
{0.04119885098006903,-0.9946722589775403,0.09449736450525541},
{0.10380174336491985,-0.9586161000926027,0.2651044524666691},
{0.28040557872448363,-0.562611193261036,0.7777154728032486},
{-0.37640278539091787,-0.9050066970743377,0.19820146669628033},
{0.5190953203767801,-0.5330951941684868,0.6680939771599438},
{-0.25820512671368684,-0.8643171611876047,-0.43160856967322714},
{0.7387170904175825,-0.4348100594470893,0.5150119149384798},
{-0.27051562137559754,-0.8315480191268367,-0.48512801452607157},
{0.7319004574379288,-0.4965003103127909,0.46670029168777344},
{-0.2571020902484906,-0.8733071000155849,-0.41380336423502695},
{0.7038133690619193,-0.46260878733737404,0.5391102404962783},
{-0.4979123035650335,-0.865121377413357,0.0604014925393212},
{0.2359122701162614,-0.5389280303758087,0.8086420585672275},
{0.20730321944399716,-0.8802136698244394,-0.4269066299114442},
{-0.9781932260353644,-0.1305990956043944,0.1614988816241171},
{0.22100158569206602,-0.9164065752407661,-0.3337023943232689},
{-0.9730413454051681,-0.09510404105655858,0.21010892771801215},
{0.08730200709621498,-0.9872226965106922,-0.13330306467268563},
{-0.9115409336647099,-0.26371184224617006,0.31551416848186065},
{-0.45399901709319207,-0.5552987977794043,0.6967984914328992},
{0.21031470361491253,-0.8872620306569207,0.4105287010647722},
{0.2577089246145918,-0.25910897309911035,0.9308322352784713},
{-0.06020088255140735,-0.9542139888796162,0.29300429547445767},
{0.0,-0.41329808850076105,0.9105957885042173},
{-0.10110205694227294,0.1317026795182725,0.986120062816769},
{0.0,-0.065198192405173,0.997872334373039},
{0.10110205694227294,0.1317026795182725,0.986120062816769},
{-0.26340613611741215,-0.09870229929684349,0.9596223546631308},
{-0.5401508494936883,-0.6786638890324327,0.4976468481911855},
{-0.36250826890792176,0.12380282397462267,0.9237210703179237},
{-0.7506532945225342,-0.47673384692098586,0.45743247657155217},
{-0.9114883466959808,-0.06959911018106446,0.4053948170603956},
{-0.8945817462456999,-0.39819187497768577,0.2028958599522161},
{-0.9393254842460861,-0.3430093059687081,0.003500094958864368},
{-0.9459619116104281,0.26818920157919324,0.1822926601338066},
{-0.9275779192704446,0.28769315154604025,-0.23839432509063604},
{-0.764546107343297,0.43752638582431974,-0.4733285449386298},
{-0.2859054050927754,0.40230760569717927,-0.8697164421447596},
{0.0,0.4278283916341345,-0.9038599821386881},
{0.28569501323706553,0.4020929815282606,-0.8698848162930463},
{0.7634483201733241,0.43552756541195004,-0.4769301858667255},
{0.7824196194179385,-0.37720945864576483,-0.49551242512984217},
{0.9410317509469244,0.3004101360089863,-0.1556052502097146},
{0.8771450600991357,-0.4802246697749458,0.0009000462365627888},
{0.9385384667873581,0.295312103614605,0.17870732446979315},
{0.9060992977733163,-0.0846999343575763,0.4144996787628734},
{0.841687252743085,-0.5377918552040288,0.048399266998651914},
{0.8950536466480159,-0.3972238083224491,0.2027121499168188},
{0.8221313813537509,-0.41751593688747224,0.38701477263581263},
{0.4041201842866689,0.10070502983832605,0.9091454084014122},
{0.5055176100126725,-0.7458259813005959,0.4338151122126555},
{-0.012499800317284888,-0.6068903050048158,0.7946873049717039},
{-0.34000784577156284,-0.9227212920394736,-0.1816041905650465},
{0.4610013092455774,-0.4784013586617879,0.7474021226250424},
{0.042800728474598,-0.8256140520707503,-0.5626095756964682},
{0.5253968528822769,-0.5088969517163889,0.6818959154556996},
{0.09999914551095239,-0.7852932896975091,-0.6109947790719191},
{0.45369716440158364,-0.4719970500276559,0.7558952756692905},
{0.09679844107365965,-0.7960871791192196,-0.5973903791054161},
{0.09990777812330212,-0.891069372451073,0.44273446822007856},
{-0.16970736291366348,-0.841736519531117,-0.5125222362595906},
{0.17980305577889966,-0.9786166317309856,0.0999016978437824},
{-0.13020097390692725,-0.8402062847665152,-0.526403937516179},
{0.30850875714535914,-0.9497269583823259,-0.05330151298491942},
{0.13270491946254842,-0.8269306548875756,-0.5464202561743515},
{0.2674115671375102,-0.9472409737945013,-0.17670764365444297},
{0.18800096538743588,-0.8443043355138943,-0.5018025767628476},
{0.25179864532693225,-0.9415949342328809,-0.22359879704170788},
{0.14420623561244475,-0.8122351218060169,-0.565224440833244},
{0.3360014767297354,-0.8961039383854639,-0.2900012745584025},
{0.10220816215869678,-0.900471910055681,-0.4227337587522616},
{0.4844330103900303,-0.8730594923007772,-0.05560378897127515},
{0.23810228341184692,-0.9211088334760698,-0.30800295376248993},
{0.09389792393985229,-0.9809783108093194,-0.16989624363557937},
{-0.08630556084643377,-0.8948576575363725,0.4379282166240249},
{-0.03640080628678898,0.005500121829047785,0.9993221352304458},
{-0.2883924788222272,-0.8967766123709201,0.3355912478943809},
{-0.2774120427181672,-0.6549284310603019,0.7029305148759905},
{-0.25129697817200614,-0.7519909573631063,0.6093926720971768},
{-0.4108958232651847,-0.2205977576351904,0.8845910081781027},
{0.21849973670797593,0.5195993738831317,0.8259990046717991},
{0.050599497802476454,0.408195948675314,0.9114909534971796},
{-0.2871023169250464,0.40320325386338807,0.8689070121078817},
{-0.644608154344729,-0.06770085642125062,0.7615096331577895},
{-0.13959480019053755,-0.738472492411977,0.6596754275479771},
{-0.5476189862793872,-0.2849098779967082,0.7867272763075126},
{-0.3425121850877306,-0.19320687345678703,0.9194327094004657},
{-0.07980352060996927,-0.40631792511065806,0.910240156130251},
{-0.3792267193598019,-0.38312699416334417,0.8422593434726402},
{-0.6483262382938063,0.12560508334058626,0.7509303907678839},
{-0.09400515068331278,0.2489136383518782,0.9639528164217573},
{-0.05099863529477902,-0.047398731626912265,0.9975733052955207},
{-0.4748886384252369,-0.1821956410214322,0.8609794013142323},
{-0.717741867104198,-0.24271415792976012,0.6526380694889223},
{-0.8307087806382173,-0.09860104221852439,0.5479057913948228},
{-0.7578029781715564,-0.18770073766534853,0.6249024558714774},
{0.0,0.881006779373251,-0.4731036405465211},
{-0.08629686316603484,0.872968268180167,-0.4800825493164928},
{-0.4809180972885079,0.8612324087853254,-0.16430618295799926},
{-0.6196354379640748,0.7355420668537395,0.27391566568489356},
{0.4035948299833417,0.36749529241545603,0.8378892667072397},
{0.32100792899377045,0.5788142968897019,0.7496185158060135},
{-0.12389900509498361,0.5416956502013932,0.831393323938413},
{-0.15370744807484907,0.35421716400853315,0.9224446981407989},
{0.837073427525808,0.34178915007564353,0.4271864391817289},
{0.6196354379640748,0.7355420668537395,0.27391566568489356},
{0.4809180972885079,0.8612324087853254,-0.16430618295799926},
{0.08629686316603484,0.872968268180167,-0.4800825493164928},
{0.04560165582618512,-0.18890685933259582,0.9809356184189688},
{-0.04170288635665057,0.31382172035292444,0.9485656525007929},
{-0.4882195853215056,0.361714510468637,0.7942318612501839},
{-0.6468270735137548,0.33661408927756625,0.6843286431748027},
{-0.34859423081321966,0.12949785682820408,0.928284637016385},
{-0.388720808781856,0.003400182016615154,0.9213493211492769},
{-0.6702093394322179,0.06280087513629258,0.739510305147904},
{-0.792807638738399,0.05800055883807662,0.6067058456389842},
{-0.8850135054091395,-0.04680071418434772,0.4632070685938005},
{-0.8293649501124645,-0.15921246841662168,0.5355419399315383},
{-0.7838888022284396,-0.11899830012142404,0.6093912949075279},
{-0.6390256094644592,-0.061402460752923,0.7667307273496102},
{-0.3665003115253972,0.20390017331522098,0.9078007716309838},
{-0.06820345732087961,0.025301282554519855,0.9973505569811325},
{-0.24329335574918048,-0.125696567273621,0.9617737343179688},
{0.035900385931223154,-0.2355025316658232,0.9712104405683545},
{0.26129465788532874,0.1775963690793509,0.9487806023788745},
{0.4771928206880187,0.4880926567012195,0.7307890053621209},
{-0.0019000443665539446,0.5595130647825958,0.8288193531578469},
{-0.5007036701713536,0.49430362325883775,0.7106052087552703},
{-0.8497188044852172,0.20390451245679156,0.4862107599631783},
{-0.7191183701133999,0.036700937537424254,0.6939177263547325},
{-0.4743111132395763,-0.19530457603982554,0.8584201130188748},
{-0.7384079120831671,-0.1624017401439685,0.6545070130802179},
{-0.8995585676671339,-0.059503874125841544,0.43272817368490146},
{-0.9749306620514898,-0.04550143104250978,0.2178068501331567},
{-0.940461615842458,-0.028698828681210573,0.3386861768057847},
{-0.820052837706555,0.13250853780014457,0.5567358716478527},
{-0.63037869040855,0.2202925531361097,0.744374836833954},
{-0.39661590263343055,0.33151329229193705,0.856034323384308},
{-0.22270964687728625,0.28321226760506274,0.9328404068573535},
{-0.4539140397783789,0.1723053294862628,0.8742270402605393},
{-0.3575015193846861,-0.1499006370790614,0.9218039176749753},
{0.06940479707833083,-0.4554314782344649,0.8875613459224584},
{0.47508565738050224,-0.12459623849633883,0.871073702681868},
{0.6132169587494946,0.2926080921886858,0.7337202913152384},
{0.8064878019642423,0.1735973743595691,0.5651914515439427},
{0.5102181411285175,0.2951104928401127,0.807828722860871},
{0.0001000033651698579,0.3662123232520197,0.9305313129055278},
{-0.5262250041751242,0.299814246012357,0.7957378103803617},
{-0.5688164674751035,-0.23850690487484563,0.7871227875345534},
{-0.7577907209094334,-0.38529528208815605,0.5265935519014352},
{-0.6314927568196186,-0.17099803866374472,0.7562913253882463},
{-0.6132209449190666,-0.22920782872708753,0.7559258190872838},
{-0.6371212196755879,-0.40671354582021907,0.6547218058728729},
{-0.8152307755426761,-0.36391373800291926,0.45051700733804656},
{-0.8931893532463635,-0.2767967006029931,0.3543957756275316},
{-0.9655735891674526,-0.11420870417703063,0.23371781231324046},
{-0.40251564004904705,0.19300749945208964,0.8948347694804654},
{0.05479973422193354,-0.002099989815074095,0.9984951573102306},
{0.11190303764918605,0.2777075384734492,0.9541259000990922},
{0.29729827864794994,0.13979919056502996,0.9444945313924948},
{0.2869937694328976,-0.35909220419286947,0.8880807199768517},
{0.173603249883257,-0.4476083793072917,0.8772164216451213},
{-0.5616045265507261,0.14040113163768153,0.8154065722034581},
{-0.32551071110617635,0.2513082694346609,0.9115299943879561},
{0.14960498940959663,0.4517150649486283,0.8795293327923811},
{0.36890064373218495,0.43930076658050654,0.8191014293332414},
{0.3653178845748198,0.3230158136262436,0.8730427408535933},
{0.5537270585338391,0.19830969063980547,0.8087395200222425},
{0.49928989197845436,-0.21559563531054426,0.8391830109119144},
{0.21860413056407088,-0.7080133780391683,0.6715126883521207},
{0.1755017155376541,-0.836808179839937,0.51860506938933},
{0.39063575652726734,-0.7593695082722839,0.5203476295984055},
{0.7096145046687147,-0.3214065696174252,0.6270128162729484},
{0.526123954969017,0.2702123030462429,0.806336713346357},
{0.2087008901111945,0.3353014300636489,0.9187039182805673},
{0.3319196153692725,0.05580329779332753,0.941655648784896},
{0.6505951335666014,-0.0067999491365706875,0.7593943197517323},
{0.7461262566449651,-0.4275150445191296,0.5104179619241257},
{0.5910179967720067,-0.2549077620595339,0.7653233044494361},
{0.0011999694491667313,-0.021199460268612254,0.9997745460640818},
{0.0017000675705284125,-0.6381253627965765,0.769930601499897},
{-0.00010000450130390781,-0.8706391883518214,0.49192214191392253},
{-0.4985118173626975,-0.7597180093288692,0.41750989718942066},
{-0.4370065070753359,-0.8631128518460467,0.2531037687431751},
{-0.5819231813716541,-0.43261723365076055,0.6886274320201426},
{-0.6543389834061892,-0.02900172782940469,0.7556450188930408},
{-0.572618996950341,-0.398013204307083,0.7167237777057446},
{-0.6642530991938109,-0.467537374093807,0.5832466236823706},
{-0.7008322074841593,-0.36321669200663054,0.613928213719357},
{-0.7556204549225759,-0.3685099757000651,0.5415146590002313},
{-0.8383539204663979,-0.28081806139444654,0.46723005086711333},
{-0.9197612489409183,-0.21671443149450584,0.3272217904245607},
{-0.9335181711080527,-0.18990369651142927,0.3041059194793346},
{-0.9585034985441545,0.09060033069181053,0.27030098660040164},
{-0.9814932817014801,0.19099869261842353,0.013799905539969867},
{-0.995874628661553,0.0735055083416591,-0.05320398699015325},
{-0.9480685341275198,-0.046898443466491586,0.314589558945805},
{-0.9586209844430267,-0.19490426650109108,0.20750454232414775},
{0.19669873228075566,0.5509964488393309,0.8109947731555305},
{0.0636033325839184,0.49362586420475024,0.8673454457552267},
{0.17079711953086846,0.25219574675459616,0.9524839364938654},
{0.3234140348565705,-0.03930170553451831,0.9454410283036542},
{0.43640616864479104,-0.21610305463826612,0.8734123457707618},
{0.5952947465470426,-0.1639985527191584,0.7865930583468901},
{0.5608237233452569,-0.3924165995732504,0.7290308386567266},
{0.5030226868347759,-0.7524339355357562,0.42521917781738916},
{0.5785147552069997,-0.7007178720372423,0.4175106487448961},
{0.4618188864695511,0.5036205959854179,0.7301298592711548},
{0.8426923736685272,-0.0004999954750614259,0.5383951275461434},
{0.3005870314522859,-0.033698546107591605,0.9531588768473684},
{-0.026200332615333843,0.17560222928445124,0.9841124933874058},
{0.025899476058898935,0.052598935934288965,0.998279805003815},
{0.13850093488446572,0.12210082418334486,0.9828066339671689},
{0.1333020988580699,0.35290555654173195,0.9261145817888863},
{0.3571068100918033,0.1807034460475745,0.9164174762479096},
{0.5207135517465286,-0.018900491891702304,0.8535222132046517},
{0.5916027923717699,-0.4000018880133671,0.7000033040233924},
{0.6215402460339383,-0.35712312447098843,0.6972451480850551},
{0.579396251318381,-0.1256991867288928,0.8052947897595654},
{0.39132286566308055,-0.2677156430820513,0.8804514462810532},
{-0.008800221328349648,-0.5265132419745556,0.8501213808215949},
{-0.3883195038368826,-0.26651338597097407,0.8821443068104923},
{-0.7269186347980576,-0.3404087264895567,0.5964152893019145},
{-0.7969012351978719,-0.2627004071859467,0.5440008432019605},
{-0.7742907976085553,-0.21219747804796002,0.5961929142893202},
{-0.8331034948764915,-0.37520157397390425,0.40640170485872784},
{-0.8855907102021746,-0.32389660234246204,0.3328965079339475},
{-0.959320870252551,-0.2600056564845859,-0.11000239312809404},
{-0.9924180572108279,-0.0696012664065635,-0.1013018432038058},
{-0.9027948360283068,0.13779921179076282,0.407397669691994},
{-0.951374094436108,0.2990918558396467,-0.07369799323096611},
{-0.9735475394870581,-0.22801113405552054,-0.014700717853579612},
{-0.8783849533946214,-0.4658920193380625,0.10669817227596323},
{-0.8926868151131104,-0.41799382627677845,-0.1684975113101368},
{-0.4096208563768671,-0.8840450122977308,-0.22511146184187691},
{-0.9338625288589998,-0.3534236642736887,0.05470366280636891},
{-0.6326215221502816,-0.7698261899324799,0.08460287823887735},
{0.42809964681793705,-0.7547993772907706,0.4969995899755074},
{0.08029808772381102,-0.8854789125707927,0.45768910026386433},
{-0.09960116085829473,-0.35430412943869305,0.9298108370084583},
{-0.03100134331730954,-0.21850946822039144,0.9753422624958707},
{0.19710118063960808,0.16200097038871897,0.9669057917830393},
{0.22820775234902316,0.28510968534051934,0.9309316242844244},
{0.45079434482041614,0.06029924355073446,0.8905888276332355},
{0.7312101309865477,-0.01820025216624066,0.6819094479208518},
{0.8343969586286286,-0.13169951995612464,0.5351980492066659},
{0.6822908641864924,-0.3129958090141758,0.6606911534046834},
{0.7856879397826858,-0.45549300823598504,0.41859357463794367},
{0.6969432850068648,-0.4347269995587374,0.5703354217813388},
{0.7437235131905601,-0.3638115020824604,0.5608177305328306},
{0.6567175280247376,-0.21030561313172272,0.7242193296718669},
{-0.0005999983080071571,-0.3487990163881607,0.9371973571071794},
{0.0850053448790942,-0.37342347973945617,0.9237580831155212},
{-0.1130027912034145,-0.8616212823085128,0.4948122220128274},
{0.10990119902862214,-0.4799052357946839,0.8704094962194059},
{0.0574008707778146,-0.4217063973345717,0.9049137276453734},
{0.15020805662518144,-0.17100917232294294,0.9737522286014592},
{0.22519679322049668,-0.24119656538536324,0.9439865577271264},
{0.37011782345294286,-0.2798134747423221,0.885842658780375},
{0.7647047794198072,-0.04210026312746682,0.6430040187876762},
{0.894299262203413,0.17459985595517827,0.4119996601004206},
{0.9506382639602021,-0.07250291830119361,0.3017121441582085},
{0.8698488303346747,-0.3737209794160358,0.3220180769921422},
{0.9154265614870278,-0.3484101092659826,0.2015058467769676},
{0.9081619660049829,-0.30072051886102674,0.2912198706096807},
{0.8230825261434531,-0.34569266102270896,0.45059043406662613},
{-0.04320074305917098,-0.724412460001469,0.6880118339053155},
{0.3043070310951811,-0.5677131171631098,0.764917673627026},
{0.6518274522912421,-0.23130974181491912,0.7222304173745551},
{0.9165299481053396,-0.016800548966906387,0.39961305756998766},
{0.925426703572803,0.21030606846915978,0.3152090954896774},
{0.8699967984176727,0.09199966144186884,0.48439821741783984},
{0.9522319669637055,-0.2791093698588219,0.12390415953245443},
{0.8049950855200043,-0.3539978388497907,0.47609709343611684},
{0.8802104569623435,-0.45820544351300363,0.12360146839416684},
{0.9422240034622362,-0.33350849623716383,-0.03140079994556805},
{0.9393988492371144,-0.3246996022432308,-0.10999986525024759},
{0.8651302022225485,-0.49611731975795437,-0.0736025695105532},
{0.8956108100877169,-0.3267039433403943,0.30190364399897474},
{0.8311202754264316,-0.3908095339148712,0.39560965101515627},
{0.7736397777117828,-0.2345120577474316,0.5886302652031482},
{0.7836826729676489,-0.32429282996479336,0.5297882865104766},
{0.7567348522261974,-0.6520300299345588,0.047002164734546416},
{0.7312044164880135,-0.5498033208220867,-0.4038024389740972},
{0.7090943769038865,-0.7050944086235093,0.005199958764490495},
{0.7638470009519973,-0.6449396843597055,0.024301495317011697},
{0.6997402712114458,-0.7009403402774079,0.1380079425856503},
{0.8251319786095085,-0.3508135960443772,0.4428171617116597},
{0.8320586185936308,-0.09849510146793972,0.5458728516888152},
{0.7514695097432006,-0.24429008813075706,0.6128751330959518},
{0.8148266208205603,-0.21610706033299348,0.5379175740542212},
{0.5758277411696623,-0.21001011748112033,0.7901380658182533},
{0.36050867754830407,-0.2180052474494599,0.9069218298711706},
{-0.0017000966192363847,-0.2157122592760519,0.9764554935425919},
{-0.46010198304382044,-0.16760072236067008,0.871903757913295},
{-0.8070845243026182,-0.1362973865226699,0.5744889842793386},
{0.7625051659899994,-0.6362043102988035,0.11760079674809697},
{0.8258214468614661,-0.3319086197787849,0.45591184018423636},
{0.9844806945228687,-0.05809886069251261,-0.1655967526795196},
{0.7819049299261248,-0.5143032426921678,-0.3523022212725077},
{0.652111500087707,-0.4466078759993405,-0.6126108034867801},
{0.6608415219772797,-0.47272970254034524,-0.5829366270589532},
{0.7843051019212821,-0.4695030541273007,-0.4055026378032385},
{0.9102603431582882,0.12930857214938107,0.39332607444974155},
{0.9463262419905407,0.3231089599356902,0.00820022739545856},
{0.867639595636441,-0.008400383360242167,-0.4971226867114739},
{0.9177902714746834,0.30799673525190946,0.2505973436822354},
{0.9207485017047746,0.37461973361421586,0.10900574202869603},
{0.948012693974959,0.29590396218058057,-0.11710156800049336},
{0.9085396722509522,0.2511109649996853,-0.33391458069850627},
{0.9783094211650889,0.061200589364513384,0.19790190580452938},
{0.9812668877075521,0.11939597105093419,0.15119489801424832},
{0.9827178414043676,0.17420316268712815,0.06260113653395076},
{0.9692196317424634,0.22060446838876127,-0.10930221393876523},
{0.8353463546553654,0.4273237128507574,-0.3458191900392977},
{0.8294359609756491,0.2918126518117849,-0.47632065132951734},
{0.7433041550818403,0.23370130639395412,-0.6268035038413797},
{0.5721999513630063,0.39229996665450423,-0.7201999387830078},
{0.16509560768978535,0.11479694586788224,-0.9795739387820335},
{0.1011019912233259,0.010600208773167702,-0.9948195931648329},
{0.12289796789890103,0.2378960664210623,-0.9634840689226294},
{0.31881132278519664,0.5632200031136222,-0.7623270745268362},
{0.5082098187085471,0.4704090883913824,-0.7214139378519202},
{0.48652487665293115,0.5718292383764564,-0.6605337739553155},
{0.33029781508717976,0.6614956242209186,-0.6732955461646931},
{0.5064171526394448,0.6063205364243589,-0.6131207667520608},
{0.27210539454292076,0.7063140028139101,-0.6535129560227809},
{0.15269626127781336,0.9031778859601901,-0.4011901769787735},
{0.11890536810401733,0.9843444392328364,-0.1301058737622595},
{0.11540522278153814,0.9903448190689533,0.07680347581994912},
{0.22271525540389622,0.9484649673329824,0.22541544035939923},
{-0.02169962264684323,0.9694831408347702,0.24419575347277037},
{0.21921164812039254,0.8645459388689751,0.4522240295622331},
{-0.002299980369751316,0.8822924696659069,0.47069598262693235},
{0.20071257905150608,0.6984437728429091,0.686943052070152},
{-0.00520013289109407,0.6792173576213639,0.7339187555334495},
{-0.5398383055860074,0.6074431026545776,0.5827413498795231},
{-0.5181005051482388,0.7540007351510751,0.40380039370557574},
{0.253490627357327,0.8752676375773898,-0.411884770842142},
{0.20781170740231406,0.9685545650584272,-0.13680770727929048},
{0.13560687476477873,0.9863500042809826,0.09340473527308504},
{0.28641400025850733,0.9272453248592458,0.24121179072050267},
{0.3130853761236139,0.8465604580844828,0.4304798927538032},
{0.32568581017836906,0.6751705834585041,0.661871162901635},
{-0.5598051138430725,0.2760025212945481,0.7813071372732986},
{-0.623890373445806,0.5436916109031651,0.5613913377984862},
{-0.570546929414996,0.7283599100665058,0.37943120950052495},
{-0.43362521603949034,0.6307366784043049,0.6435374227892344},
{-0.44040010349403647,0.4444001044340368,0.7801001833235646},
{-0.6099161568929969,0.44011165871226093,0.6590174576036809},
{-0.8198549731189831,0.2631176426294273,0.5085340983544803},
{0.5747366549990461,0.740647236283789,-0.3480221958233305},
{0.5489320009237679,0.820447829400363,-0.15980931635565332},
{0.5224147949964943,0.8484240277087018,0.0852024129665033},
{0.5507098192436165,0.7988142429849298,0.2421043167584521},
{0.5923282132647127,0.7216343722637458,0.35831706704836497},
{0.615643265850815,0.5628395549396339,0.5515387607484152},
{0.8762619539102895,0.4180295557344225,0.239616941516669},
{0.8918353485945762,0.3182126126068559,0.3215127434101326},
{0.9043292419588157,0.19000614394799845,0.3822123590364474},
{0.633306694087135,0.3526037270410924,0.688907281788453},
{0.651552745329688,0.2627212681475196,0.711657611015512},
{0.7681366947663844,0.07870375976840835,0.6354303552331215},
{0.8556284543973843,0.49531647202317025,0.15020499515017194},
{0.840691950413112,0.5384948439365538,-0.05709945327535231},
{-0.53829818593817,0.27909905943775454,0.7951973201895465},
{-0.6142375034156915,0.3299201438893466,0.716843768232445},
{-0.6913396183520271,-0.7201412688779034,0.05870336409267176},
{-0.8233169028695256,-0.33780693524757166,0.45610936402136604},
{-0.7311296442524015,-0.6821276574265669,0.012300498733831948},
{-0.8551941077328964,-0.5106964813133655,-0.08849939024130184},
{-0.8264245410411247,-0.10940324877770939,0.5523164012790576},
{-0.7850876663696413,-0.4329931977302951,0.44289304220496006},
{-0.46129867607469943,-0.8638975206176737,0.20219941968849822},
{-0.38903083191519233,-0.9145724827414997,-0.11050875816614075},
{-0.767950555849192,-0.12920850607594167,0.6273412992371378},
{-0.513836306386887,-0.3427242160350062,0.7864555689814089},
{-0.41270065619456503,-0.7143011357397088,0.5652008986701433},
{-0.00019999359630756773,-0.9711689036695488,0.23839236679862072},
{-0.0,-0.9999968750146484,-0.002499992187536621},
{0.0,-0.6512030443813487,0.7589035478823796},
{0.0,-0.30670182028070503,0.9518056489832901},
{0.513836306386887,-0.3427242160350062,0.7864555689814089},
{0.4125297836628861,-0.7140515528128502,0.565640837914493},
{0.4588119453244968,-0.8643225029292995,0.20600536341945583},
{0.361516017321979,-0.930541228542466,-0.05830258315317116},
{-0.45411492700297995,-0.05360176191887189,0.8893292327323278},
{-0.001600042745712935,-0.012000320592847013,0.9999267133989773},
{0.4537924557631339,-0.059999002524874466,0.8890852190810982},
{0.7546255633739463,-0.13780466821220488,0.6415217319167592},
{0.7703930896049792,-0.45629590704407064,0.4452960057127431},
{-0.0060998964551365045,-0.16849713978532802,0.9856832681685331},
{0.4501220362636911,-0.15020735358099624,0.8802430933554786},
{0.2986993518231098,0.2986993518231098,0.9063980331184022},
{0.0,0.42260624405338415,0.9063133908792761},
{0.0,9.999999950000001e-05,0.999999995},
{0.42260623560100974,0.00020000295106531462,0.9063133727524731},
{0.29880858041158154,-0.29880858041158154,0.9063260255254898},
{0.0,-0.42252409723641765,0.9063516907109239},
{-0.29880858041158154,-0.29880858041158154,0.9063260255254898},
{-0.42260623560100974,0.00020000295106531462,0.9063133727524731},
{-0.2986993518231098,0.2986993518231098,0.9063980331184022},
{-0.0,0.5553923023160344,0.8315884742636194},
{0.3925010931170665,0.3927010936740688,0.8317023162941762},
{0.5555076355049253,0.00010000137452833939,0.831511429203142},
{0.3929219629869489,-0.39282195739698017,0.8314464749996164},
{-0.0,-0.5555076382825399,0.8315114333608136},
{-0.474414752156081,-0.38791206231311937,0.7902245724151248},
{-0.7295870973662737,0.0,0.6838879055493347},
{-0.47408817164767425,0.38779032475209463,0.7904802777631016},
{-0.8315114333608136,-0.0,0.5555076382825399},
{0.5362967044668766,0.6847957919427877,0.4933969680849467},
{0.544288205402382,0.7792831131179061,0.3105932695167735},
{0.25320030384054687,0.4320005184009331,0.8656010387218698},
{0.8996963517386906,0.15009939134820213,0.40989833786560986},
{0.298118296081263,0.11180686179766924,0.9479581779786286},
{0.15370744807484907,0.35421716400853315,0.9224446981407989},
{-0.837073427525808,0.34178915007564353,0.4271864391817289},
{-0.11239927053110135,-0.9828936210410989,0.14589905311821785},
{-0.5385075256952577,0.22720317518656002,0.811411339552706},
{-0.9293160122528379,0.16810289643785864,-0.3288056653704219},
{-0.9992629855310295,0.032702061275885375,0.020101267022791927},
{-0.9861211722488546,-0.07830168115514179,0.14640314330923063},
{-0.7505603399711929,0.3016242485480503,0.5879472669807653},
{-0.9611591803926612,0.03380208125821657,0.27391686558063666},
{-0.9736637721972085,0.18581217016664064,0.13210865273957603},
{-0.10440308515675026,-0.987329176008233,-0.11950353138152926},
{-0.17390029041372748,-0.9139015262168232,0.36680061255753443},
{-0.6845328925957529,0.2579123929882318,-0.6818327628514015},
{-0.8868056356677221,-0.35390224905593914,-0.29720188872400427},
{-0.8833636618962745,-0.08270596041981422,-0.46133324717848007},
{-0.959201779320951,0.28260052422445864,0.008300015396542841},
{-0.8801881131397976,0.31959568388943344,0.3508952611914962},
{-0.9160183205496184,0.050001000030001005,0.39800796023880797},
{-0.3793959461759725,0.5573940442764551,0.7384921092539686},
{-0.8130065853800125,-0.04380035478431064,0.5806047029171406},
{0.15110299564658336,-0.7765153945702975,0.6117121273131372},
{-0.985025290849018,0.11220288084594905,-0.13090336098694055},
{-0.5724990324774527,-0.22369962194795837,0.7887986669313792},
{0.09520662470742874,0.7542524827136843,0.6496452038859842},
{0.1519990120096329,0.1725988781109384,0.9731936742616758},
{0.25531169226667716,0.22861046945617858,0.9394430227783647},
{0.37872606103692075,0.028701975050857212,0.9250636558203109},
{-0.48219554212281956,0.15019861142025612,0.8630920207511521},
{0.35778801430227797,-0.13099561172050983,0.9245690274563616},
{0.30890361110432085,0.23300272381776224,0.9221107795380196},
{-0.1632078733377193,0.39321896934063244,0.9048436507105907},
{-0.13110785228441701,0.7049422202538944,0.6970417470803864},
{0.32111345975275424,-0.001400058684689679,0.9470396960008042},
{0.3267970572057497,0.002399978388291919,0.9450914894894555},
{0.1587016878014247,0.725007710498002,0.6702071276907047},
{0.10330441067597274,0.7196307252897384,0.6866293162645002},
{-0.1018018095432471,0.9939176670435489,-0.04200074656990548},
{-0.18980137321790286,0.9818071034000898,0.005500039792931853},
{-0.3536132236137502,0.6060226626412121,-0.7125266454321182},
{-0.21419114552106244,0.5997752058054774,-0.7709681288363172},
{-0.3892144634781992,0.19700732092807105,-0.8998334384318697},
{-0.6283091293979757,0.537307807139157,-0.5626081747561692},
{-0.5198796055231052,0.7933688767494357,-0.31668757659005076},
{-0.5982885458754329,0.733385959460208,0.3227938201714687},
{-0.5990102132112036,0.5663096556619442,0.566109652251857},
{-0.0798025744725794,0.2450079040824806,0.9662311711203786},
{-0.4676093686475522,0.8829176894331134,-0.04240084950952997},
{-0.0002000127072109465,-0.7907502379584769,0.6121388904191017},
{-0.4009988170552345,-0.6718980179037708,0.6226981630431285},
{-0.42539943634612026,-0.3342995570533803,0.8409988856772147},
{-0.4231102838204239,-0.06530158717436464,0.9037219652293006},
{0.1151011044003951,-0.9672092804175686,-0.22640217233926543},
{-0.18439019346833366,-0.87245359978916,-0.45257593038919636},
{-0.43301263116267924,-0.8321242734190886,0.346510107847271},
{-0.5924062410326241,-0.19610206594614715,0.7814082321790892},
{-0.6007094041793343,0.565408851544857,0.5652088484137835},
{-0.4499000787325207,0.5508000963900253,0.7030001230250323},
{0.07719908905612369,0.9825884055252219,0.16899800583529667},
{0.2879065787404872,0.9167209473129718,0.27700632966695016},
{0.5773754822707071,0.5735756436274292,-0.5810753251602145},
{0.4154192156602408,0.6933320708166706,-0.5888272368337741},
{0.3946152383616497,-0.30561180142757255,-0.8665334618357057},
{0.3794853426617041,-0.25359020526747866,-0.8897656334660983},
{0.35319417940788467,0.21039653269371159,-0.9115849772033625},
{0.4022956773561701,-0.014799840976563058,-0.9153901641855285},
{0.33660095426505804,-0.34390097496064603,-0.8766024851715682},
{0.6122207485127565,-0.34731177059536156,0.7103240732907726},
{0.5800298462036244,-0.5485282252460137,0.6022309885927976},
{0.5894091919080223,-0.5389084043420991,-0.601809385290546},
{0.3334222133278025,-0.6664444000049418,-0.666844426655605},
{0.4983178550486253,0.8263296079202871,0.2624094022973295},
{0.13450833775773188,0.850352710746464,0.5087315347015481},
{0.26011916368470894,0.7497552365029847,0.6084448257815338},
{0.37251395090869716,0.728727291348101,0.5746215199788923},
{0.0,0.24390009146255145,0.9698003636752046},
{0.3914899094776232,0.8922770018566619,0.22489420342660907},
{0.29840907028153896,0.889627040624856,0.34571050803058984},
{0.8981160360049856,0.0658011748904666,0.43480776356192824},
{0.23891000456591618,-0.6448270026961187,-0.7260304031597118},
{0.44251067791148857,-0.36070870400604277,-0.8210198114470781},
{0.2513132835146596,-0.787441621326872,-0.562829749152608},
{0.1619104743273873,-0.8845572238577769,-0.4374282981519408},
{-0.1278970270681583,-0.983777132366334,-0.12579707588095632},
{-0.1630029626057683,-0.9732176883922312,-0.16210294624782232},
{-0.3824168630433721,-0.8874391324913399,0.25731134639398434},
{-0.4246213844713965,-0.820641328537984,0.3824192591188461},
{-0.2680075445185688,-0.9579269660236457,-0.10270289112707841},
{-0.5867907610522003,-0.7193886733145074,0.37169414772171583},
{-0.5398942393591989,-0.4736949457018939,0.695792575932822},
{-0.5691365795834925,-0.609739189197075,0.5516354547500517},
{-0.7425142452724446,-0.6017115439467069,0.2943056463079871},
{-0.6768390885860813,-0.1301075139259001,0.724541843499728},
{0.2036001058720826,-0.7650003978003104,-0.6110003177202479},
{0.005400010584031118,-0.743601457460285,-0.6686013104598528},
{-0.3940840891760928,-0.896263814078995,-0.20349178418506692},
{-0.9325410047294868,-0.03340146869486848,-0.35951580825764123},
{-0.9770289693384178,-0.17030504961958295,0.12810379833393173},
{-0.6274887209916094,-0.27329508756495113,0.7290868947808484},
{-0.3990187204024118,-0.440620672203766,-0.8041377270064645},
{-0.7824722216066936,-0.496245803120196,-0.3761347169558761},
{-0.298118296081263,0.11180686179766924,0.9479581779786286},
{-0.10760014795030515,0.8730012003774758,-0.4757006540888491},
{-0.25320030384054687,0.4320005184009331,0.8656010387218698},
{-0.5942875111791774,0.3672922814338076,-0.7154849642414629},
{-0.6247018678613774,0.7588022688221757,-0.1843005510594715},
{-0.5503402478540422,0.3877283556115067,-0.7394540782541864},
{-0.30801817360838013,-0.28701693449871785,-0.9070535177363662},
{-0.20760194316328207,-0.3916036654274627,-0.8964083904218018},
{-0.4763956624372401,0.1369987526320359,-0.8684920924154976},
{-0.6244244123496105,0.732228627037772,-0.2719106305539063},
{-0.5623797040827129,0.8240702598409739,0.06809754240404116},
{-0.5426281170043428,0.8380434243450778,0.05690294850266698},
{-0.5906995569754984,0.7825994130506603,-0.1964998526251658},
{-0.6661231381890644,0.32641133809474654,-0.6706232945047089},
{-0.32362345384158064,-0.2749199241688829,-0.9053656142236803},
{-0.27949783390018096,-0.3798970558092262,-0.8817931661294438},
{-0.45107517125052893,-0.33518155043932013,-0.8271544705352196},
{-0.2709133143620095,-0.6351312142905583,-0.7233355491991196},
{-0.5226274543412837,0.8517447433265812,0.037301959523402},
{-0.34620554452619373,0.8852141768185635,0.31070497598003577},
{-0.3194178224146163,0.891149723085988,0.32221797865369245},
{-0.5657935245301674,0.8209906038163086,0.07649912447253059},
{-0.6515492655025173,0.7393559048135243,-0.16981284003427086},
{-0.367612157135058,0.8471280149866911,0.38371268958847055},
{-0.5922004796825827,0.3527002856873471,0.7245005868457131},
{-0.02890106776967349,0.7743286080988991,0.632123354228741},
{-0.040600303488402864,0.80380600847237,0.5935044364622439},
{0.7685133684063162,0.46640811323969533,0.4380076192088048},
{-0.026100173958239152,0.7161047728542166,0.6975046488839772},
{0.015300055845305752,0.24060087819480813,0.9705035423443944},
{0.0,-0.01820062538423249,0.9998343548986617},
{0.0587031721116099,0.10000540393800665,0.9932536719122819},
{0.03179985403900494,0.8586960585941366,0.5114976522311643},
{0.06430266154224298,0.8143337059696496,0.5768238752343041},
{-0.03429983501819034,0.40719804138213145,0.9126956099446741},
{0.8349245053938552,-0.22400657468945212,0.5027147548945874},
{0.9872276723794906,0.09710272182743977,0.1263035403378542},
{0.980710425007227,0.1880019984718657,0.05350056871406816},
{0.9877947202513303,0.1250993313458609,0.09279950398797676},
{-0.036700514911836346,0.9296130425624813,0.3667051449092749},
{-0.0015999716727522985,0.3350940672120595,0.9421833187920097},
{-0.11960561621356705,0.2128099927278183,0.9697455354707022},
{-0.15610350846577958,0.03200071922424694,0.987222188068018},
{-0.24010677710942724,-0.07650215930391996,0.9677273144889327},
{-0.28421657030908765,-0.0460026820345462,0.9576558329626401},
{-0.5774036232191037,-0.04870030559537642,0.8150051141731371},
{-0.6979194966534623,-0.0824023019404575,0.7114198737917654},
{-0.6782329188335928,-0.191209280567654,0.7095344380896993},
{-0.41841019050428613,0.052801285990980655,0.9067220834852682},
{0.3094082597637431,-0.2567068528809077,0.91562444292076},
{0.4021033334504515,0.8174067763302638,0.4125034196675236},
{0.13850954779220534,0.5417373432421488,0.8290571488789762},
{0.17060620932598466,0.2866104313764784,0.9427343114396586},
{0.6014064561329601,-0.13410143958668097,0.7876084550221472},
{0.3367008181839823,-0.3771009163563401,0.8628020966116421},
{0.02620146037909248,-0.3735208187630168,0.927251681812769},
{-0.24600794864523318,-0.29170942528379884,0.9243298655804432},
{-0.11330690399999747,-0.1830111512091751,0.9765595035833852},
{0.048398684299650725,0.2209939923599754,0.9740735201712762},
{-0.197804152941787,0.015400323333182607,0.9801205778475501},
{-0.2069113794042241,0.19241058191093627,0.9592527555559776},
{-0.47458973473505534,-0.04829895530489501,0.8788809900097768},
{0.22689820524229481,0.9409925567783138,0.251098013822566},
{-0.22751486858250872,0.572437410007156,0.7877514812415037},
{0.09990627181307578,0.5138322568324157,0.8520534893367423},
{0.12500624671822666,0.29091453736265704,0.9485474000979038},
{0.44492744174623067,-0.09920611872606445,0.8900548958286025},
{0.2450055886412161,-0.17970409909725116,0.9527217318305574},
{0.11850433852325146,-0.2543093104342856,0.9598351402077363},
{0.09939854680386853,0.10219850586876623,0.9897855294413387},
{0.21920264250378316,0.06500078358916928,0.9735117357547122},
{0.0,0.1587042073043042,0.9873261743638282},
{-0.18050766632338658,-0.17410739449806983,0.9680411135791591},
{-0.0044002669722960595,0.007700467201518105,0.9999606694542795},
{-0.5963293013601012,0.7560371487979817,0.26981325760012626},
{0.02060084454893378,0.255310466667126,0.966639628203854},
{0.4037962669207684,0.27609744749089693,0.8721919366228188},
{0.24540379888021022,0.6078094089624766,0.7552116907674603},
{-0.2598030851799548,0.5975070954388878,0.7586090085354649},
{-0.2756938672581335,0.16499632969746839,0.9469789346878942},
{0.20359843535203645,0.25039807569818234,0.9464927262313483},
{0.1716044325997418,-0.06930179008835727,0.9827253841245122},
{0.18060440951048798,-0.17410425080717584,0.9680236345855612},
{0.008600049622429483,-0.26970155618246877,0.9629055559810871},
{0.0044002669722960595,0.007700467201518105,0.9999606694542795},
{0.19331195768097498,0.2088129165224396,0.9586592997050316},
{0.43879576564129225,0.013099873586829828,0.8984913296005038},
{0.274111662328766,-0.05470232736002736,0.9601408500614673},
{0.4205079792146091,-0.161403062652171,0.892816941362195},
{0.5710034802768185,-0.12350075273938192,0.8116049467472257},
{0.5908260441860542,-0.12640557208042869,0.7968351252664997},
{0.721418133072665,-0.14040352908705594,0.67811704468613},
{0.6972492519404276,-0.1505106316939678,0.7008495062533731},
{0.7564900976094331,-0.3262957288168645,0.566792580733677},
{0.8494999405350062,-0.14419998990600105,0.5074999644750037},
{0.7303069123876388,-0.4887046256111723,0.4773045177086403},
{0.5964346150873591,-0.3579207725348186,0.7184416959737738},
{0.8226746373318906,0.08189747513976156,0.5625826558440764},
{0.6707211917708362,0.34341085023722256,0.6574207715374203},
{0.38822924641073964,-0.08130612502110544,0.9179691532210663},
{0.2602044469319974,-0.28570488273816935,0.9223157625110732},
{0.33521690038606017,0.059703010003125875,0.9402474037678216},
{0.442212654096148,0.14120404061143396,0.8857253453933929},
{0.22700478758145567,0.3771079532906032,0.8979189373100839},
{-0.18660921778997472,0.39541953223020365,0.8993444242150282},
{0.47310255949177027,0.19390104900751268,0.8594046493917299},
{0.26650507297234655,0.5052096167565833,0.8208156243741164},
{-0.5415354663190719,0.832154499582825,0.11940782027423304},
{0.3713095446345189,0.713718346365893,0.5939152667881518},
{-0.23698802055833348,0.9672511066923039,-0.09089540535338614},
{-0.6646038081907314,0.7077040551558541,0.23970137349280518},
{0.013600331580125935,0.9692236299601512,-0.24580599282315846},
{-0.6540053236250015,0.7084057664464084,-0.2654021603823783},
{-0.4130069117285021,0.8848148074997063,0.21570360983011602},
{-0.6220203279564819,0.7610248706991684,-0.18420601995109961},
{-0.38771790328753597,0.8830407753492244,0.26441220951566813},
{-0.4030318226338837,0.8922704519949157,0.20351606924564597},
{-0.45558518233291306,0.8804713631346136,0.13119573292817865},
{0.00010000034150174934,-0.1970006727584462,0.9804033480831505},
{-0.00850028552938648,-0.2696090563203053,0.9629323454407342},
{0.0,-0.07550344832122904,0.9971455406767878},
{-0.7664907600095817,-0.6224924958981927,0.15809809413896264},
{-0.5463277295676392,0.5602284351158547,0.6226316024689953},
{-0.8054441476036284,0.5271288927264373,0.2709148492498422},
{-0.9438251155204904,0.3303087896338398,-0.00950025280509076},
{-0.3588093219872794,0.830421574632767,0.4262110731075209},
{-0.12620344224583155,0.9026246194222467,0.411511224121709},
{-0.11470265539720903,0.9385217270294741,0.3256075379017547},
{-0.04400181093179411,0.5020206610854693,0.8637355477679677},
{-0.06520287290187148,-0.6322278565730544,0.7720340165681715},
{-0.5541247643890932,-0.6309281968111873,0.5430242682968375},
{0.1829033233835791,0.923016771367105,0.3385061507126382},
{0.46822489852098587,0.46712484002382,0.7500398844313101},
{0.4182996883668482,-0.6687995017445567,0.6145995421235116},
{0.24989012703611732,0.9000644391564995,0.35698589576588186},
{0.4275335605640564,0.8274649544109949,0.36402857554460005},
{0.8804239082358467,0.44481207903601155,0.164304461748239},
{0.7764246557564216,0.46321470961665956,0.42731356955785543},
{0.6588060577495517,-0.6719061782057131,0.3384031116309172},
{0.7184221492962996,-0.6907212952658046,0.08230253742634389},
{0.7895292644445401,0.5061187596394955,-0.3471128659768206},
{0.6439176113875105,0.5935162328909575,-0.4828132051217426},
{0.3805216713262906,0.904851532762228,0.1909108726838078},
{0.11419954034777514,0.9920960068216087,0.051999790701263635},
{0.4384822790967783,0.6556735014908951,-0.6146751584054495},
{-0.3859058098557014,-0.6578099034026441,0.6468097377939043},
{-0.553488457118589,-0.6310868388212132,0.5434886656620652},
{-0.37111804234220336,-0.06000291711272488,0.9266450499441813},
{-0.43090387384323886,-0.08890079922177753,0.8980080731288663},
{-0.28589856336332864,0.6169968995983693,0.7331963156977704},
{-0.03109929809676284,0.5947865758184739,0.8032818701327843},
{0.1469070421578528,0.30961484174316695,0.9394450333770382},
{-0.496880520181052,-0.34758637314335616,0.7951688260172521},
{0.6681034908498596,0.6375033309636065,0.383702004848213},
{0.7078959614650597,0.5713967401908958,0.4151976313042701},
{0.12139729711926912,0.20559542246887755,0.9710783791805786},
{-0.6595216425578067,-0.5796190205102422,0.4786157060320944},
{-0.8245961367761488,0.37109826140871793,0.42699799951905837},
{-0.7919963172256873,0.4218980381786837,0.44129794796931293},
{-0.014400739352938056,-0.4186214925791577,0.9080466203102608},
{-0.32211828717425905,-0.7517426776432491,0.5754326682398903},
{-0.032998421723232564,-0.8870575730508972,0.46047797586510897},
{0.36061960742109767,-0.4849263661633119,0.7967433201120037},
{0.3480038663444327,-0.0383004255200913,0.9367104069104315},
{-0.44979358149138776,0.7582891792906167,0.4718932661311381},
{-0.3067970056758368,0.908791130241853,0.28279723991240757},
{-0.7168880782503871,0.34509426113015573,0.6057899257973003},
{-0.9517433528971092,0.13600619522329185,0.2751125316612323},
{-0.984758841098686,0.12040719454481749,-0.1255074992971312},
{-0.6166963830863198,-0.787195383112617,-0.002999982405154791},
{-0.41210431269419867,-0.9015094343455958,0.13210138244820102},
{-0.1773145137869545,-0.7726632450750199,0.6095498937007827},
{0.21581215812040122,-0.17150966226899356,0.9612541537781727},
{0.5918095015778223,0.16160259455048342,0.7897126789388413},
{0.029001373972638703,0.5933281095850532,0.8044381111582956},
{-0.8472850116607145,0.20969629050543115,0.48799136750906247},
{-0.4344858577154933,0.6125800608435241,0.6602785082843273},
{-0.13029369784624908,0.8167604942503165,0.5620728131955227},
{0.3245034478674505,0.8383089070794568,0.4381046548866874},
{0.299510294345728,0.9499326497462673,-0.08900305908771217},
{0.5805200340920708,0.8023276888063192,-0.13880479023596798},
{0.480124203671176,0.609430722177077,-0.6309318060740365},
{0.39191422478493754,0.6216225622003501,-0.6782246166091979},
{0.4509155049962135,0.18990653004830552,-0.8721299887052513},
{0.4450120733413268,0.26850728470145224,-0.854323178102237},
{0.3603059649146242,-0.12940214227019806,-0.9238152938887866},
{0.04440206452198604,-0.4331201383890125,-0.9002418577182846},
{0.2170938150853111,-0.3770892568801051,-0.9003743487002033},
{0.5873991159649957,-0.696398951920366,-0.4122993794899008},
{0.35881041821174137,-0.8705252760683413,-0.33680977941391993},
{0.5219723857813761,-0.7833585575117432,0.33748214597933796},
{0.2527033445508978,-0.9182121526182604,0.3050040367551399},
{0.13491023872654015,-0.9211699102373325,0.36502770300361126},
{-0.019200212259519796,-0.9381103708674752,-0.34580382288239303},
{-0.1576065053427648,-0.9860406996698357,-0.05370221660473648},
{0.43912687099537945,-0.8159499295038263,0.3760230095519533},
{0.4546121269402314,-0.8305221544739599,0.3218085843584832},
{-0.31041576796941117,-0.9353475121836027,0.16960861548844114},
{-0.9736925756224162,-0.023999817002093034,-0.22659827219476172},
{-0.7773251740834006,-0.14850480940613017,-0.6113197979122382},
{-0.7741940000197496,-0.036499717128288374,-0.6318951028319294},
{-0.48920779558833455,-0.7310116487634353,-0.47570758046069245},
{-0.33181342212439285,-0.741529995494989,0.5831235878262009},
{-0.03540035294327828,-0.3989039770924775,0.9163091356476238},
{0.06069951137090019,0.018099854296759366,0.9979919661970081},
{0.6593123226624669,-0.6417119937092447,0.3918073229472994},
{0.4508347133551836,-0.8259635975156303,0.3384260581175557},
{0.4676093686475522,0.8829176894331134,-0.04240084950952997},
{0.3536132236137502,0.6060226626412121,-0.7125266454321182},
{0.18980137321790286,0.9818071034000898,0.005500039792931853},
{0.13110785228441701,0.7049422202538944,0.6970417470803864},
{-0.10330441067597274,0.7196307252897384,0.6866293162645002},
{0.1018018095432471,0.9939176670435489,-0.04200074656990548},
{0.21419114552106244,0.5997752058054774,-0.7709681288363172},
{0.3892144634781992,0.19700732092807105,-0.8998334384318697},
{0.6283091293979757,0.537307807139157,-0.5626081747561692},
{0.5982885458754329,0.733385959460208,0.3227938201714687},
{0.1632078733377193,0.39321896934063244,0.9048436507105907},
{-0.35778801430227797,-0.13099561172050983,0.9245690274563616},
{-0.32111345975275424,-0.001400058684689679,0.9470396960008042},
{-0.1587016878014247,0.725007710498002,0.6702071276907047},
{-0.03749790954981227,-0.6857617698469667,-0.726859478713561},
{-0.3629973210896555,-0.8759935351915653,-0.3175976561379465},
{-0.3006095505171323,-0.8747277905433654,-0.3801120763525016},
{-0.1619104743273873,-0.8845572238577769,-0.4374282981519408},
{-0.038701856572590745,-0.8034385418713025,-0.5941285010278078},
{-0.2513132835146596,-0.787441621326872,-0.562829749152608},
{-0.12200188738379684,-0.6085094137134458,-0.7841121303084846},
{-0.44689421946065666,-0.7384904476878383,-0.5048934692452127},
{-0.3130070975164052,-0.7519170499124124,-0.5802131564824866},
{-0.2036001058720826,-0.7650003978003104,-0.6110003177202479},
{-0.013700240167315218,-0.6522114333666412,-0.7579132863363652},
{-0.005400010584031118,-0.743601457460285,-0.6686013104598528},
{0.3990187204024118,-0.440620672203766,-0.8041377270064645},
{0.41160366946307,-0.09000080236072958,-0.9069080851216184},
{0.5821202988887395,-0.2812098059569036,-0.7629266037145154},
{-0.3267970572057497,0.002399978388291919,0.9450914894894555},
{0.0798025744725794,0.2450079040824806,0.9662311711203786},
{0.5989762899928316,0.5663775803872118,0.5660775922620066},
{0.03170052036831281,0.6992114776506093,0.7142117238816721},
{-0.24770642930380996,0.9688251461830081,-0.004400114206446362},
{0.5198796055231052,0.7933688767494357,-0.31668757659005076},
{0.1630029626057683,-0.9732176883922312,-0.16210294624782232},
{0.3824168630433721,-0.8874391324913399,0.25731134639398434},
{0.1278970270681583,-0.983777132366334,-0.12579707588095632},
{0.2680075445185688,-0.9579269660236457,-0.10270289112707841},
{0.4246213844713965,-0.820641328537984,0.3824192591188461},
{0.5398942393591989,-0.4736949457018939,0.695792575932822},
{0.5867907610522003,-0.7193886733145074,0.37169414772171583},
{0.3940840891760928,-0.896263814078995,-0.20349178418506692},
{-0.7094484995572012,-0.7046481713955511,0.01240084775092937},
{0.6546937771652219,-0.729393067151845,-0.19839811423488626},
{0.7146990959062154,-0.691199125633659,-0.10699986464525682},
{-0.7038660961297856,-0.6876645747354938,-0.17801671655456355},
{-0.6239190235810479,-0.7390225331405584,0.25410774786335033},
{0.6127195399376979,-0.6858218712082148,-0.39271252380207927},
{-0.737798166573834,-0.6732983268557367,-0.04819988022344646},
{-0.6160384173535967,-0.626239053485101,-0.47782979839537093},
{0.3863192894036919,-0.6461322621892968,-0.6582328663875486},
{-0.13440431377567705,-0.6238200218249058,-0.7699247111301619},
{0.7824722216066936,-0.496245803120196,-0.3761347169558761},
{0.9325410047294868,-0.03340146869486848,-0.35951580825764123},
{0.00010000509989010667,-0.6970355462340434,0.7170365662120648},
{0.43089356680707097,-0.6463903494641232,0.6296905987895396},
{0.4009129156176182,-0.6720216495261648,0.6226200580282593},
{0.42539943634612026,-0.3342995570533803,0.8409988856772147},
{0.47800705304610186,-0.22400330519315234,0.8493125316988585},
{0.4231102838204239,-0.06530158717436464,0.9037219652293006},
{0.5892015643322299,0.773902054712683,-0.2322006164934552},
{0.6127952906862866,0.7167944914554997,0.33269744322997313},
{0.47822276872804165,0.4177198881173212,0.7725367813517611},
{0.5999371642587457,0.74194596126615,0.2993185418613812},
{0.6211370798847586,0.7356439155743495,-0.27021613103342745},
{0.4623953922528741,0.47439527267466153,-0.7490925353300779},
{0.6274887209916094,-0.27329508756495113,0.7290868947808484},
{0.9770289693384178,-0.17030504961958295,0.12810379833393173},
{0.5691365795834925,-0.609739189197075,0.5516354547500517},
{0.7636488407234627,-0.4947316415739877,0.41482653107921996},
{0.5125228513407519,-0.5687253571853378,0.6433286834487917},
{0.9571035843596352,0.2883010796895652,0.028900108231107988},
{0.4884115071106629,-0.6514153475263837,0.5806136794194326},
{0.4063044307739765,-0.6621072203186066,0.629706866990827},
{0.840209070105868,-0.1926020791506667,0.5069054720741067},
{-0.041302038099356266,-0.04890241314911673,0.9979492450205233},
{0.3343933172163324,0.46349073723017375,0.8205836008006053},
{0.444693576447682,0.4697932138860378,-0.7625889844816781},
{0.32410213746064487,0.34260225946935186,-0.8818058155285302},
{-0.06070304949428894,0.0648032554733101,-0.9960500378305072},
{0.576394555979128,-0.27279742344050334,-0.7702927246195738},
{0.12090759021222083,-0.5608352075352643,-0.8190514175666573},
{-0.4498980002078336,-0.4187981384464119,-0.7887964938073774},
{-0.4127210266083145,-0.4259216991337076,-0.8051410189540925},
{-0.37838834392659526,-0.6531798791037315,0.6558797959340746},
{-0.5088914227073548,-0.5832901687270585,0.6330893293692794},
{-0.16399819520979256,-0.051999427749446415,0.9850891591534551},
{0.16789766120186908,0.35829500898528704,0.9183872069553101},
{-0.13120736225164972,-0.6655373443481164,-0.7347412274869439},
{-0.05160009571826634,-0.9862018294060904,0.15730029179231192},
{-0.045799556433443904,0.1281987584010373,-0.9906904052098882},
{-0.1685962521469717,0.13869691680180884,-0.9758783064663681},
{-0.493524161066722,-0.4228206996940427,-0.7600372085323378},
{-0.4154192156602408,0.6933320708166706,-0.5888272368337741},
{-0.07719908905612369,0.9825884055252219,0.16899800583529667},
{0.25320171038333045,0.9540064443352974,-0.16050108418848558},
{-0.35319417940788467,0.21039653269371159,-0.9115849772033625},
{0.4313256775819025,0.8285493250095205,-0.3570212541079044},
{0.7103596229853408,0.3218270120747327,0.6259525384014146},
{0.6007094041793343,0.565408851544857,0.5652088484137835},
{0.4499000787325207,0.5508000963900253,0.7030001230250323},
{-0.2879065787404872,0.9167209473129718,0.27700632966695016},
{-0.5773754822707071,0.5735756436274292,-0.5810753251602145},
{-0.3946152383616497,-0.30561180142757255,-0.8665334618357057},
{-0.1151011044003951,-0.9672092804175686,-0.22640217233926543},
{-0.7815422005104556,-0.6220335876103691,0.04760257037018259},
{-0.4022956773561701,-0.014799840976563058,-0.9153901641855285},
{0.5652427678857885,0.5970451741468785,-0.5692430705601396},
{0.7260264714077301,0.4138150879731663,0.5492200249271699},
{-0.14440002021600423,-0.3956000553840116,0.9070001269800266},
{0.3586976882008493,-0.6255959680469788,0.6927955349471657},
{0.5924062410326241,-0.19610206594614715,0.7814082321790892},
{-0.3794853426617041,-0.25359020526747866,-0.8897656334660983},
{0.18439019346833366,-0.87245359978916,-0.45257593038919636},
{0.43301263116267924,-0.8321242734190886,0.346510107847271},
{0.30381398791801306,0.9502437502294141,-0.06880316777076793},
{0.5414282253891035,0.8407438291182477,0.002300119908376317},
{0.6816345563397727,0.48582462950390487,-0.5471277373437348},
{-0.17159668392612443,0.9802810562516303,-0.09799810620489623},
{0.07500380128897642,0.7208365329212562,-0.6890349211747301},
{-0.32140324297508255,0.5115051611131135,-0.7969080408426984},
{-0.33660095426505804,-0.34390097496064603,-0.8766024851715682},
{-0.2726959709467937,0.2798958645691513,-0.9204863999139112},
{-0.985891136878519,0.11309898324471093,-0.12339889064895958},
{-0.9170981795619203,-0.22659955020033926,0.3279993489219386},
{-0.9872928026617028,0.04399967924350747,-0.15269888682917254},
{-0.8935923776895275,0.416296449006435,-0.1678985678313246},
{-0.9836103033718919,-0.16280170535679545,0.07750081182525582},
{-0.7135161327821453,-0.08620194904810222,0.6953157212661888},
{-0.44790929421428344,-0.05280109563410173,0.8925185199514354},
{-0.405406208843633,-0.17610269703345777,0.897013737870594},
{-0.722766446973846,-0.20411876550070837,0.6602607005564315},
{-0.8390670902914137,-0.2678214145173308,0.4735378632335928},
{-0.9844321865365168,0.028700938392521365,0.1734056695910524},
{-0.943339144669979,0.09340387587424577,-0.3184132128304053},
{-0.7847272697464438,0.016500573404888905,-0.6196215322223737},
{-0.29350892574214976,0.08980273094257257,-0.9517289425172195},
{0.1495996312373635,0.11009972860450348,-0.9825975778999557},
{0.2671977328368553,-0.13029889441857126,-0.95479189862511},
{0.8830906657809937,-0.13719854981899257,-0.4486952573161951},
{0.9319576433629181,-0.18381136908477771,-0.3125193299183517},
{0.8834641506610539,-0.14611060947654514,0.44513232223141846},
{0.36428943393820074,-0.2755920065697725,0.8895741982745631},
{-0.43323408386611933,-0.2969233598796187,0.8509669482033263},
{-0.23869718100293846,-0.30879635313660414,0.9206891267256198},
{0.03319996265006303,0.06239992980011846,0.9974988778143937},
{-0.3358163244283053,-0.018500899350576677,0.9417457793750301},
{-0.9892960576630653,-0.12319950905093466,-0.07819968837486274},
{-0.8958755389307317,-0.22031857694400556,-0.3858325328415676},
{-0.41141489348872134,-0.1558056402662683,-0.8980325093652692},
{0.3005062581079883,-0.1297027010868755,-0.9449196781571986},
{0.9383342075970683,-0.01480053956350486,0.34541259224557963},
{0.4675098107963204,-0.14070295268244337,0.8727183141859868},
{-0.34768948081388457,-0.1478955254885635,0.9258719881667404},
{0.4624978332027272,0.006599969079217296,0.8865958463081901},
{-0.3227974676637992,-0.040699680712257214,0.9455925818552929},
{0.32161684512340655,-0.4295224968299226,0.8438441974972961},
{-0.22590030496561755,-0.45150060952623433,0.8632011653223598},
{0.5713124918842041,-0.3543077470235839,0.7403161871904013},
{-0.4134181143115265,-0.33051448180928766,0.8484371750892576},
{0.9220667554824358,-0.06409768899948394,-0.38168623855074907},
{0.32940040022172945,0.018900022963541853,-0.9440011469620903},
{0.31170085562002303,-0.16410045045635477,-0.9359025690560782},
{0.8197577252726591,-0.5158363238936655,-0.24881752110264438},
{0.7879799225273577,-0.3109920760228531,0.5313864604454795},
{-0.9725585984208854,0.06860413352357093,0.2223133947855659},
{-0.9784591697507519,-0.08639639475366884,0.1874921761147327},
{-0.9935730347937486,0.10839705814376242,-0.03259911527201711},
{-0.8345368831725958,0.5494242823427491,0.04100181211513053},
{-0.5583998827360369,0.23189995130101532,-0.7964998327350525},
{-0.717935718190492,0.57282849892675,-0.3955196775934526},
{-0.1269083013434952,0.6451422001315111,-0.753449284729624},
{0.43939295658735844,0.3822938718783503,-0.812886969526317},
{0.559723472495989,0.6198259929480328,-0.5500230657009004},
{0.9597587486310606,0.1585097026758603,-0.23181418978084803},
{0.8567558880094217,0.20591343217128508,-0.4728308437619407},
{0.9010855196720473,0.3137949573555526,-0.2992951903649359},
{0.8246475959095365,0.5610323809183241,-0.0721041616117846},
{0.5247179955122395,0.7674263193369402,0.368412634927976},
{-0.49818119401488214,0.7084732556393899,0.4998811298435159},
{-0.78991574712738,-0.2276045373416783,0.5694113513284342},
{-0.9044080221347347,0.3607031994515688,0.22790202149989608},
{-0.1932099525009866,0.17430897888675964,-0.9655497367479428},
{0.4669924581327013,0.15769745320669593,-0.8700859482254034},
{0.9289722891699149,0.3670890498969599,-0.04749858313839715},
{-0.9977702754353355,0.03230227512935886,0.058404113546580726},
{-0.765521228197991,0.14300396555494801,-0.6273173957525796},
{0.7518187618713067,-0.3686091987573339,0.546713643409209},
{0.7500961820201502,-0.23039882727295374,0.6198968447330904},
{0.7120096798373965,0.42160573176888533,-0.5615076337481716},
{0.5075140329570196,0.3598099488826318,0.7829216480828584},
{0.3819057229001368,0.8811132035802841,-0.2789041794104429},
{-0.38130940129918495,-0.8810217218583319,0.2800069036553155},
{-0.5506374308515865,-0.5988407075806937,0.5815395314932755},
{-0.3461185074514034,-0.12630675380269357,0.929649709699002},
{-0.757896843366221,-0.12339948604221093,0.6405973319176688},
{-0.6347896498391384,-0.42909300369561165,0.6425895226632488},
{-0.4800234137130197,-0.4831235649265829,0.7322357156680688},
{-0.4146919363936945,0.7493854283420175,0.5161899627837596},
{-0.7021572597484644,0.690556313710746,-0.17351414978829025},
{-0.5605210479605337,0.796929925280552,0.22520845673632864},
{-0.20509628881623052,0.7542863513119583,0.623688714454817},
{-0.3701135371501864,0.7940290421433343,0.4822176374326395},
{-0.3564972228974504,0.7826939028382451,0.5101960255884409},
{-0.49201541016397327,0.8450264666434094,0.2094065587161301},
{-0.669312924557361,0.7200139036027191,-0.18330353962552556},
{-0.7086429556946786,0.34842112018631954,-0.6135371906840041},
{-0.7654737485279336,0.3644875001155216,-0.5302818142970126},
{-0.8382322348403981,0.4456171365364846,-0.3143120871037189},
{-0.33351735502711505,0.847844118716606,0.41222145050127984},
{-0.07300079972814155,0.7678084113872204,0.6365069729720836},
{-0.27481875152314644,0.8347569574103725,0.4771325558649679},
{0.09089913918922779,0.6577937707224868,0.74769291938158},
{0.3786097663648867,0.5474141207293687,0.746319251553394},
{-0.10860115117830377,0.28280299772766393,0.9530101019606214},
{-0.35040514048111654,0.5967087537816275,0.7219105905060447},
{-0.8373056350858862,0.5050033986843098,0.2095014099492334},
{-0.9317502366683014,0.08980484195858482,-0.35181896883107056},
{-0.8703338827575964,-0.06060235929577197,-0.4887190262020423},
{-0.5526240479586818,0.0386016797886448,-0.8325362286022486},
{-0.6214998446250584,0.19599995100001838,-0.7584998103750711},
{-0.782892539069654,0.2687974383726184,-0.5610946527934383},
{-0.7013843312490577,0.3303926191113326,-0.6315858905288065},
{-0.7255038197876668,0.530102790998542,-0.43890231082674974},
{-0.11279939934479773,0.9740948129589314,0.19599895630833647},
{-0.0011000047905312942,0.7868034265363839,0.6172026879235588},
{0.42100507314169716,0.7919095425674822,0.4423053298113365},
{0.14299994780502856,0.6201997736271239,0.7712997184756542},
{0.028901340764297807,0.7280337742702008,0.6849317747220611},
{-0.11640231119083326,0.4778094870015475,0.8707172882633893},
{0.25070333312297094,0.5914078628198046,0.7664101894912043},
{0.12000711783324429,-0.38672293721762974,0.9143542319577939},
{-0.11130458417370072,0.009500391281672568,0.9937409280629507},
{-0.17880066782174145,0.05750021476370322,0.9822036685375529},
{-0.405918904083555,-0.17270804320086217,-0.8974417948376011},
{-0.8070980710379153,-0.3180992397437255,-0.4973988112182618},
{-0.8240402635909426,-0.5362262006522615,0.18280893226265085},
{-0.6446868678622512,-0.3271933351396441,0.6908859267970052},
{-0.8527937874198878,-0.06879949879747688,0.5176962285967119},
{-0.8439111481399009,-0.1621021413834316,0.511406755727865},
{-0.722703057040397,-0.21150089465067654,0.6580027833576604},
{-0.8654047207956279,0.3608019681801047,0.3477018967190199},
{-0.547524940329061,-0.1084049379573885,0.8297377954173915},
{-0.8790560966396026,-0.23778812396871518,0.41317936427196433},
{-0.7898436321673947,-0.3802210039884065,0.48122658369074495},
{-0.6434699538719896,0.0032998459172922543,0.7654642574809759},
{9.999588725373417e-05,0.20309164701233406,0.9791597279885649},
{0.38689394515713704,-0.6744894443227938,0.6287901595110048},
{0.931090563444959,-0.24909747540988,0.2664972990635609},
{0.9660488350029452,-0.2569129872797688,0.027301380119648454},
{0.9605016376566883,0.13470022966408735,-0.24350041516856177},
{0.8763160104397675,0.3241059214692784,0.35640651160645115},
{0.9714107632908863,0.23380259054705496,-0.0412004565035871},
{0.6886120611458774,0.6350111223172119,0.3501061321626077},
{0.9887113603587961,0.09930114097666476,0.11220128920021939},
{0.5912236198554291,0.674526947889863,0.4421176629534595},
{0.9255316814916954,0.37801293960438775,0.022300763368195364},
{0.32520917753248674,0.9024254668060149,0.28260797530959647},
{0.23419305276613303,0.9711711906339384,-0.044498679966237915},
{0.7651132710047794,0.6019104402271294,-0.22870396690470923},
{0.10949991130510776,0.8910992782098769,-0.4403996432764334},
{0.5192204654779782,0.44731763137191766,-0.7282287037000457},
{-0.15679606054846743,0.6734830789502093,-0.7223818503840108},
{-0.14449794453135847,0.32159542533761165,-0.9357866885290329},
{0.4348308697392031,-0.036702605610461715,-0.8997638765049701},
{0.45529855670586283,-0.11639963101375453,-0.8826972018543051},
{-0.20331088860621677,0.16060860162399612,-0.9658517275744425},
{0.003600235715148659,-0.15591020777546555,-0.9877646710700918},
{0.6199344755148017,-0.0709039430779149,-0.7814434572790225},
{0.26800809396665853,-0.4742143214887667,-0.8386253268673128},
{-0.29520710129223343,-0.7913190354083479,-0.5354128795117268},
{-0.4536219875906207,-0.48272339817017773,-0.7491363115170502},
{-0.39549482300665,-0.40329472090665475,-0.82518919834409},
{0.0004000098683651803,-0.6729166010573246,-0.7397182490743097},
{-0.2833968089698964,-0.8985898819348938,-0.3349962279637096},
{-0.36813606069330385,-0.7445729344910752,-0.5568545465743863},
{-0.11420043567549315,-0.6193023626430202,-0.7768029635089587},
{0.31632118948459026,-0.6405429082038572,-0.6997468741143464},
{0.5605346112781431,-0.6701413791569735,-0.4865300417249181},
{0.05589730749154563,-0.9947520839461467,-0.0856958721292569},
{-0.17210333367386021,-0.910617638834498,-0.375707277520449},
{-0.3954033747822057,-0.898407667942169,0.1911016310593817},
{-0.4120981167159099,-0.8251962288618511,-0.38629823462110163},
{-0.6013038663962914,-0.7352047273815957,-0.3129020119664055},
{-0.24039523901943638,-0.938381415540096,0.2482950825645842},
{-0.6613241883745428,-0.6980255307506893,-0.27461004404604483},
{-0.9538583731492719,-0.03740228890310628,-0.2979182316640471},
{-0.8740910362423847,-0.36729623339643963,-0.31789673998564705},
{-0.7890968199462235,0.3361986451221902,0.5140979281895242},
{-0.7977614491094351,0.15249263097165813,0.5833718092384614},
{-0.5159113217981867,0.128702824414473,0.8469185858323014},
{0.49923022181624416,0.1810109578300084,0.8473512959633488},
{-0.4945136364015382,0.030800849345131196,-0.8686239526357454},
{-0.9895186773413039,-0.04120077767201791,-0.13840261237396306},
{-0.9468331160673619,-0.2234078138249352,-0.23150809713729856},
{-0.900649442508257,-0.28281552558442713,0.3299181113518477},
{-0.763819702983361,0.004100105763592276,0.6454166487371841},
{-0.951463150705038,-0.12570834353965027,0.2809186451892423},
{-0.8861366602319665,-0.2994123869466773,-0.3537146334770867},
{-0.41713121509678225,-0.1343100507971658,-0.8988672647542265},
{0.2917213124790032,-0.6754493467546065,0.6772494782680183},
{0.617624007511767,-0.25690998628525413,0.7433288937556614},
{0.1681026820996895,-0.4438070809984664,0.8802140439271071},
{0.8458937657859191,-0.2411982223756516,0.47569649412975734},
{0.3948218480714613,-0.46982599854096385,0.7895436906089632},
{0.22940104836518652,-0.7023032095330013,0.6739030797441117},
{0.929291534192685,-0.354196773282093,0.1046990461960337},
{-0.4217099124079881,-0.32070753831928334,-0.8481199352933714},
{-0.7117806078015072,0.04619874133243837,-0.7008809047598713},
{-0.8570993571757232,0.052199960850044046,-0.5124996156254323},
{-0.631934510885985,0.1294070671129078,-0.7641417309194194},
{-0.608791266951913,0.3209953953540802,-0.7254895929264337},
{-0.4447331471967369,0.6863511556580179,-0.5754428893568753},
{0.5795001535675611,0.731100193741577,-0.3601000954265379},
{0.7656707818787665,0.5170477981077878,-0.38263537244881934},
{0.7730903750847449,0.6259922064455442,-0.10229872638878464},
{-0.04399894557790368,0.33079207266296673,-0.9426774090065864},
{-0.07790190667249901,0.5870143673524636,0.8058197226790719},
{0.9142340055662673,0.39661475236007615,0.08290308363754492},
{0.7606187723029536,-0.07180177208960303,0.6452159241255135},
{0.5164193919122563,0.856332155876191,0.0025000938802878406},
{0.2986116625062232,0.9212359795737871,-0.24930973698192044},
{0.34801656250232355,0.694133034577192,-0.6301299885997531},
{0.4745020640884682,0.7872034243423439,-0.3939017134761804},
{0.7621681077427832,0.4060830078120497,0.504178903075192},
{-0.1704042039235668,-0.7709190188067938,-0.6137151405392779},
{0.12260783979592285,-0.9894632683041278,0.0770049238522517},
{0.9600049680385644,0.23660122441450454,-0.14970077470351364},
{0.5697104742233537,0.41950771272019816,-0.7067129930378165},
{0.7344534077213843,0.3064222823064163,0.6055440337354279},
{0.3108107775505706,0.7276252308423268,0.6115212048654245},
{-0.45709796820404697,-0.48919782552049834,0.7427966982760142},
{0.16370142911971436,-0.9273080954350099,0.33660293855648044},
{0.5999175148475226,0.3808111179428849,-0.7036205425016119},
{-0.10419862250331569,-0.747190122211876,-0.6563913225640731},
{0.6496193167175781,0.39741181721608,-0.6481192721130887},
{0.3482135300995731,0.6848266094548755,0.6401248725351429},
{0.7409231245715825,0.2661083053698179,-0.6166192449869587},
{0.3264118146894529,-0.9139330804065288,-0.2412087307080148},
{-0.09420127125473343,-0.8056108717920727,-0.5849078933852822},
{0.6878046186235212,0.3618024295114713,-0.6293042257920644},
{0.3138168696792566,0.6709360671377095,0.6718361155211108},
{-0.5012378900042123,-0.524339636331222,0.6883520344970059},
{0.3563170519605421,0.6328302848179372,0.6874328978885115},
{0.44303117941641573,0.5575392382046315,0.7020494084657423},
{-0.4387061353482045,-0.5047070583775675,0.7435103980656259},
{0.9662420855905768,-0.08890387229248839,-0.24181053228710564},
{0.7780524425019965,0.11140750911918047,0.6182416708929745},
{0.05800205649937042,-0.6410227278637317,0.7653271351546238},
{-0.041099411049659446,-0.9946857462553834,0.0943986472770767},
{-0.03620262822519748,-0.9839714339992208,0.17461267646738893},
{-0.1039044648707853,-0.9587411979944357,0.2646113705948969},
{-0.18179932552575342,-0.6892974427112313,0.7012973981914791},
{-0.2805134944262319,-0.5625270610151708,0.7777374139582193},
{0.37629869989023784,-0.9048968735867027,0.19889931280406137},
{-0.14870605394668676,-0.7767316213879731,0.6120249160415084},
{0.10220166743380638,-0.9877161147198685,-0.11820192848019485},
{-0.18279851568207897,-0.9821920246331399,0.04339964759629228},
{-0.4190041376862896,-0.4994049316480502,0.758307488323421},
{-0.20140515200968345,-0.7352188071376329,-0.6472165560112568},
{-0.494144052435169,-0.5199463526837571,0.6967621156275698},
{-0.19149649660364162,-0.707487056642697,-0.6802875542530413},
{-0.3891126580406524,-0.5522179639425554,0.7373239855393807},
{-0.19249407704837243,-0.7451770712542708,-0.6384803542617443},
{0.12140389591353079,-0.7105228010425341,0.6931222426496557},
{0.2694080203961525,-0.8941266185456571,-0.3577106492045426},
{0.7021572597484644,0.690556313710746,-0.17351414978829025},
{0.5595288864244118,0.7975411741259488,0.2255116423390614},
{0.669312924557361,0.7200139036027191,-0.18330353962552556},
{0.7086429556946786,0.34842112018631954,-0.6135371906840041},
{0.5526240479586818,0.0386016797886448,-0.8325362286022486},
{0.8703338827575964,-0.06060235929577197,-0.4887190262020423},
{0.49201541016397327,0.8450264666434094,0.2094065587161301},
{0.3564972228974504,0.7826939028382451,0.5101960255884409},
{0.37049800857855586,0.7954957242219736,0.47949742270827944},
{0.23179347510551243,0.7584786491265365,0.6090828545589629},
{0.42689698825237177,0.7504947052785312,0.5044964407901652},
{0.8382322348403981,0.4456171365364846,-0.3143120871037189},
{0.7654737485279336,0.3644875001155216,-0.5302818142970126},
{0.782892539069654,0.2687974383726184,-0.5610946527934383},
{0.6214998446250584,0.19599995100001838,-0.7584998103750711},
{0.4217099124079881,-0.32070753831928334,-0.8481199352933714},
{0.28201002563462013,0.831329554290992,0.4789170258029063},
{0.10810342747350295,0.779724721564202,0.616719553403416},
{0.36500161148567206,0.8501037532163557,0.3796016759450989},
{0.7255038197876668,0.530102790998542,-0.43890231082674974},
{0.7013843312490577,0.3303926191113326,-0.6315858905288065},
{0.631934510885985,0.1294070671129078,-0.7641417309194194},
{0.7117806078015072,0.04619874133243837,-0.7008809047598713},
{0.8570993571757232,0.052199960850044046,-0.5124996156254323},
{-0.09089913918922779,0.6577937707224868,0.74769291938158},
{-0.028901340764297807,0.7280337742702008,0.6849317747220611},
{-0.1302045546349831,0.603021094046811,0.7870275307045446},
{-0.010200097870408603,0.8074077471145006,0.5899056601719641},
{0.11019992230908217,0.9755993122027274,0.1898998661206416},
{0.4447331471967369,0.6863511556580179,-0.5754428893568753},
{0.608791266951913,0.3209953953540802,-0.7254895929264337},
{0.11640231119083326,0.4778094870015475,0.8707172882633893},
{-0.25070333312297094,0.5914078628198046,0.7664101894912043},
{-0.3786097663648867,0.5474141207293687,0.746319251553394},
{-0.2359122701162614,-0.5389280303758087,0.8086420585672275},
{-0.7038133690619193,-0.46260878733737404,0.5391102404962783},
{0.4979123035650335,-0.865121377413357,0.0604014925393212},
{0.2571020902484906,-0.8733071000155849,-0.41380336423502695},
{-0.7319004574379288,-0.4965003103127909,0.46670029168777344},
{0.27051562137559754,-0.8315480191268367,-0.48512801452607157},
{-0.7387170904175825,-0.4348100594470893,0.5150119149384798},
{0.25830956538031236,-0.8644320105100348,-0.4313159719261662},
{-0.5190082263455819,-0.5329084466658199,0.6683105928068446},
{0.39110108921805026,0.6181017214156912,0.6819018990994334},
{0.7447037458692626,0.13690068861219556,0.65320328562079},
{0.9776686613333333,-0.09609691966260953,-0.18689400920855068},
{0.7535907723374887,0.2787965861567036,-0.5952927106853861},
{0.6724153278821006,0.3564081244157951,-0.6487147876221276},
{0.6452042325536483,0.3800024928245294,-0.6628043480107844},
{0.6219930181675564,0.37259581763542043,-0.6886922694726625},
{0.6107328522037038,0.37532018901596537,-0.6972375054141514},
{0.5988020928169716,0.3526012323434606,-0.7191025132676757},
{0.2873935538348804,0.6882845619504112,0.6660850598796585},
{0.7191234042520434,0.3503114010700748,0.6001195312079699},
{0.2970914765678041,0.7488785149836032,0.592383004775386},
{0.2912057295290933,0.7264142923418042,0.6225122480489718},
{0.2629152889685933,0.7152415925079417,0.647537655409525},
{-0.21610548698797283,-0.9045229661296688,-0.36760933371947624},
{-0.22090315231047536,-0.8893126905826425,-0.4004057138303048},
{-0.9877947202513303,0.1250993313458609,0.09279950398797676},
{-0.20730321944399716,-0.8802136698244394,-0.4269066299114442},
{-0.980710425007227,0.1880019984718657,0.05350056871406816},
{-0.9872276723794906,0.09710272182743977,0.1263035403378542},
{-0.22100158569206602,-0.9164065752407661,-0.3337023943232689},
{-0.08730200709621498,-0.9872226965106922,-0.13330306467268563},
{-0.8349245053938552,-0.22400657468945212,0.5027147548945874},
{-0.21031470361491253,-0.8872620306569207,0.4105287010647722},
{0.03429983501819034,0.40719804138213145,0.9126956099446741},
{0.45399901709319207,-0.5552987977794043,0.6967984914328992},
{0.9115409336647099,-0.26371184224617006,0.31551416848186065},
{-0.06430266154224298,0.8143337059696496,0.5768238752343041},
{0.9730413454051681,-0.09510404105655858,0.21010892771801215},
{0.9781932260353644,-0.1305990956043944,0.1614988816241171},
{-0.03179985403900494,0.8586960585941366,0.5114976522311643},
{0.9621296196162668,-0.05910181947751935,0.2661081922668003},
{0.11100352219763988,0.7785247029807446,0.6177196005538933},
{-0.12090130936827072,0.5748062251851283,0.8093087648613855},
{0.050000226751542476,0.31370142263917744,0.9482043001162516},
{-0.19929559461957086,0.02659941202649566,0.979578346659968},
{-0.25531169226667716,0.22861046945617858,0.9394430227783647},
{-0.09520662470742874,0.7542524827136843,0.6496452038859842},
{-0.1519990120096329,0.1725988781109384,0.9731936742616758},
{0.5725246362651591,-0.22350961782578704,0.7888339442549477},
{0.9849411172251759,0.11270470495611465,-0.131105473112215},
{0.8135318707353163,-0.0444017394722164,0.5798227149997989},
{0.383315505425798,0.5545224308860032,0.738629878182871},
{0.9164508369379265,0.05070281256302147,0.3969220178750142},
{0.9667430741972777,0.1898084571042136,0.17140763723741945},
{0.9601296780670306,0.028400877884703336,0.27810859646957736},
{-0.9681233030083585,0.08800211823647923,0.23450564461879977},
{-0.8667051525774482,0.15810093991288166,0.4731028126045814},
{-0.3215948995453395,0.5719909282958152,0.7545880323287102},
{-0.23560208744374214,0.4846042936130621,0.8424074637631935},
{-0.2548163839461257,0.5074326264296082,0.8231529263189014},
{-0.1968959026388987,0.35989251071477724,0.9119810218724003},
{-0.0587031721116099,0.10000540393800665,0.9932536719122819},
{0.5922004796825827,0.3527002856873471,0.7245005868457131},
{0.8801881131397976,0.31959568388943344,0.3508952611914962},
{0.959201779320951,0.28260052422445864,0.008300015396542841},
{0.9863482829302032,-0.07400362256598908,0.14710720107374317},
{0.9913069490860698,0.12980090990756768,0.021500150716584787},
{-0.8274202182600527,-0.5601136865451481,0.04060099209736299},
{-0.8838469821350363,-0.41032181123557976,0.2246119395649798},
{-0.7871531110121605,0.21481449402288408,0.5781390083548849},
{-0.7973980822599182,0.33019920587186474,0.5050987852388822},
{-0.3470090952275804,0.4447116560452594,0.8257216424478765},
{-0.15950887372547487,0.5580310441305015,0.814345303289368},
{0.037099997959500176,0.8136999552465038,0.5800999680945027},
{0.02890106776967349,0.7743286080988991,0.632123354228741},
{0.026100173958239152,0.7161047728542166,0.6975046488839772},
{0.367612157135058,0.8471280149866911,0.38371268958847055},
{0.5657935245301674,0.8209906038163086,0.07649912447253059},
{0.6515492655025173,0.7393559048135243,-0.16981284003427086},
{0.8843201052461417,-0.0798018143148729,-0.4600104584566609},
{-0.7608199261348016,0.25370664466403675,0.5973156439015734},
{-0.8906100817631887,-0.3280037130230473,0.31500356586054845},
{-0.9499486718670866,-0.25561309667252063,0.17960920251324222},
{0.5225095985894899,0.4905090107332915,0.6974128115910244},
{0.9307197919668165,-0.08670184373431074,-0.3553075556955087},
{0.6764614491667293,0.3091280809246541,-0.6684607223877024},
{0.41130813164214464,0.5754113759953563,0.7069139758274545},
{0.6585603729967158,0.38403520612109165,-0.6471593278149959},
{0.8441486032550389,0.03700213045899353,0.5348307937694525},
{0.36140716135385403,0.6375126324379689,0.6804134825267357},
{0.6386149277984079,0.39230917033403606,-0.662015474792587},
{0.5551218472502063,0.42121657730460615,-0.7172282270723255},
{0.3733922689931049,0.6932856456693081,0.6163872378343596},
{0.397822139418105,0.6519362812636066,0.6455359250738733},
{0.5877079135403341,0.3773050804471126,-0.7157096370951457},
{0.07440353276360541,0.17220817663834478,0.9822466381775973},
{0.30059054357024656,0.12159617464451757,0.9459702402443554},
{0.5492173939903059,0.11210355037566148,0.8281262271729284},
{0.7607257928452671,-0.2107071441468355,0.613920815338122},
{0.9101318051116541,-0.28711003323542017,0.29871043861866947},
{0.970794592689178,0.02409986576412154,0.23869867045210835},
{0.9462313349694949,0.25870856727606034,0.19420643125245815},
{0.9626713269610196,0.2225164868572895,0.15411141853801488},
{0.9680055902484256,0.2382013756169163,0.07890045565144709},
{0.35931945048829667,0.2399129868414761,0.9018488183978457},
{-0.2802999397355194,0.604699869989542,0.7454998397175517},
{0.3362016171336676,-0.1015004882185225,0.9363045036354937},
{-0.3591261201926169,0.3157229633662188,0.8782638784549045},
{0.3678885202178371,-0.19879379673635775,0.9083716547047654},
{-0.36280951843257575,-0.0345009051431198,0.9312244309934249},
{0.11539950262921549,-0.4038982592022542,0.9074960887002864},
{-0.2832073280844225,-0.8524220567060796,0.43951137250389716},
{-0.8557505849121554,-0.11150659134942775,0.505229865020008},
{-0.9803665593451477,-0.19381315842200308,0.03630246465799129},
{-0.600522489988383,-0.7791291789341368,-0.1798067338882785},
{-0.08080089123874556,0.8377092399838758,0.5401059574015654},
{-0.09860477209342097,0.8035388882055148,0.5870284099273643},
{0.8594230457379612,0.3925105253108562,-0.32760878494735407},
{0.8633544232614094,0.3452217617396485,-0.36802319907355346},
{0.8669713936989922,0.4073335432617367,-0.28712364417000885},
{-0.09840622488263866,0.74634721168611,0.6582416383917964},
{-0.10300041972756557,0.8541034804787744,0.5098020774476985},
{0.8209046914837178,0.40260230087872434,-0.40500231459484193},
{0.9795489247928537,0.05650282210392673,0.19310964510209294},
{-0.017499962637619656,0.7070984903463347,0.7068984907733333},
{0.39221648128282255,0.31941342203399675,0.8626362487367739},
{0.9110630841919999,0.3186220621554019,-0.2616181150654524},
{0.8339572364492737,-0.1768121350332553,0.5227358765943583},
{0.9307969051054358,-0.2548991524617271,0.26199912885434484},
{0.8762336261106154,-0.36161387719881133,0.31851222314109906},
{0.9593755969786132,0.10560832173557964,-0.26162061520859503},
{0.6938090993660078,0.6677087570577737,-0.26980353849661126},
{0.0952045142290658,-0.41821983036339616,0.9033428330159152},
{0.35721170959176374,-0.4594150598724979,0.8132266580067813},
{-0.16900597869224623,-0.9779345950482106,0.12280434428051974},
{-0.5084106869049593,-0.8608180945865244,-0.022600475066978914},
{0.39378338662936974,-0.43368170335489503,0.8104658071688781},
{0.2457022285293192,0.5131046538803161,0.8224074592694836},
{0.3931053344755835,0.4962067335710621,0.7741105047508247},
{0.16549946543758995,0.34499888565539893,0.9238970158174583},
{-0.377827280114472,0.9026651747785135,0.2060148748109614},
{-0.1827995713355078,0.9470977790583122,0.2637993813911759},
{0.5500920072212022,0.8328878982267575,-0.060799116595253756},
{0.33470830588966727,0.3002074497402991,-0.8932221655830619},
{-0.3127240353293883,0.8192629668750718,-0.48063694077167907},
{0.14540065939348554,0.45910208203266306,-0.8764039745010366},
{0.08180431079173875,0.3636191614165796,-0.927948899555677},
{-0.3205948625084921,-0.24869601467829694,-0.9139853535020643},
{-0.33448822956629876,-0.04619837430781166,-0.9412668774013662},
{-0.2499999187500396,-0.11239996347001781,-0.9616996874476523},
{-0.40918723355746645,0.8375738681029665,-0.36198870612855044},
{-0.30841595014330314,0.776040133953318,-0.5501284506285055},
{0.10940592722666562,0.9720526623795154,0.20771125306196023},
{-0.11449710898449676,0.9443761548031331,0.3082922157198284},
{0.13640375592912996,0.4794132008242295,0.8669238710774396},
{0.12730233029048413,0.6211113695476803,-0.7733141556451798},
{0.38751428985291236,0.9218339932552635,-0.007400272890094327},
{-0.05600042644487107,0.9421071741734471,-0.3306025175477567},
{0.03830365932337109,0.8021766355946724,0.5958569249311879},
{0.1138080641560888,0.9417667312459473,-0.31642242090497796},
{0.023800355341957905,0.40790609008338774,-0.9127136269161755},
{0.15151178428730222,0.40723167367517804,-0.9006700523375867},
{0.42852049448273466,0.25991243060924796,-0.8653413859414476},
{0.45580147452015507,0.8745028290212279,-0.1658005363656027},
{0.15769345664577192,0.7546686856725685,0.6368735734793414},
{-0.08370105045477486,0.012500156877953236,0.9964125050554082},
{-0.029998612596250394,-0.037298274994671324,0.9988538040798173},
{-0.05119806244598941,0.7667709821012633,0.6398757843591527},
{0.18060461902219802,0.02550065218751965,-0.9832251463046793},
{0.322807692598973,0.6623157831731717,-0.6761161120389271},
{0.5738448505970161,0.7747605537774632,-0.26542074476899286},
{0.7745076599186351,0.2671026416581891,-0.5734056710101296},
{0.47873599751303036,0.7548567598137358,0.44833371147919676},
{-0.3533096225186057,0.25800702691706845,0.8992244907125113},
{-0.27429156703540525,0.127396083267629,0.9531706952174565},
{-0.16730560315847623,-0.712223852776251,0.6817228312799357},
{-0.03239907987919696,-0.6651811091247475,0.7459788145024979},
{-0.386399998068,-0.007599999962,0.9222999953885},
{-0.5397074237266704,-0.5622077332205561,0.6266086190608332},
{-0.5505199016541736,0.3416123495096562,0.7617275369482001},
{-0.7524908723410774,-0.35049574851235565,0.5575932364350629},
{-0.3379871618014838,0.41058440424760134,0.8468678323363213},
{0.401084255746555,0.7066722601248826,0.5828771196077459},
{-0.5237970929342014,0.8420953263839078,0.12849928683093714},
{0.2092109535262153,-0.3979208336906361,-0.8932467671587739},
{0.30801817360838013,-0.28701693449871785,-0.9070535177363662},
{0.2696087610790392,-0.36981201723675333,-0.8891288927128107},
{0.32220101815682606,-0.2678008462520112,-0.9080028692936004},
{0.6661231381890644,0.32641133809474654,-0.6706232945047089},
{0.5942875111791774,0.3672922814338076,-0.7154849642414629},
{0.5615246233946156,0.38021667286666583,-0.7349322274847783},
{0.4934812924787965,0.21459186497659521,-0.8428680474779687},
{0.5906995569754984,0.7825994130506603,-0.1964998526251658},
{0.5226274543412837,0.8517447433265812,0.037301959523402},
{0.8824322932006653,-0.296410847353442,-0.36531336888735616},
{0.6263028966575955,0.7591035108618567,-0.1775008209431953},
{0.6404966374014803,0.72949617015516,-0.23999874000992238},
{0.5486106047454856,0.8347161352188422,0.04770092206773544},
{0.5376853590270078,0.8345772747702078,0.11989673525634786},
{0.3366237395431984,0.8856624591190033,0.31982255468186227},
{-0.7685133684063162,0.46640811323969533,0.4380076192088048},
{-0.8414902135257246,0.33049615635205226,0.42739502942471147},
{0.3194178224146163,0.891149723085988,0.32221797865369245},
{-0.8208055650805969,0.40260272965576066,-0.4052027472839399},
{-0.8633544232614094,0.3452217617396485,-0.36802319907355346},
{-0.8594230457379612,0.3925105253108562,-0.32760878494735407},
{-0.8669713936989922,0.4073335432617367,-0.28712364417000885},
{-0.9110630841919999,0.3186220621554019,-0.2616181150654524},
{-0.9795489247928537,0.05650282210392673,0.19310964510209294},
{-0.39221648128282255,0.31941342203399675,0.8626362487367739},
{0.017499962637619656,0.7070984903463347,0.7068984907733333},
{0.09840622488263866,0.74634721168611,0.6582416383917964},
{0.09860477209342097,0.8035388882055148,0.5870284099273643},
{0.08080089123874556,0.8377092399838758,0.5401059574015654},
{0.10300041972756557,0.8541034804787744,0.5098020774476985},
{-0.6265469019238309,0.3698276844875223,-0.6860513562964854},
{-0.2927017415805437,0.7509044678948761,0.5920035224314377},
{-0.6158234356067716,0.37201415726813736,-0.6945264307062403},
{-0.2864149569795904,0.7292380818069739,0.6214324520499912},
{-0.6498161221379879,0.37750936612356173,-0.6597163677661289},
{-0.25851395366723395,0.717838746392033,0.6464348922649904},
{-0.6771306543986026,0.35361600855906944,-0.6453292147148402},
{-0.7578260658758115,0.2766095141478615,-0.5909203250541264},
{-0.9789357758616551,-0.09690354140463213,-0.17970656749651592},
{-0.7400438674003988,0.14040832295002162,0.6577389886341112},
{-0.3861265104256411,0.6208426254137219,0.6822468412648858},
{-0.2828095336700727,0.6907232846743961,0.6655224351394392},
{0.29939925000581813,-0.0651998366746137,0.9518976154994598},
{0.4128034593074836,-0.08540071566099587,0.9068075990795206},
{0.0,-0.009500521307906639,0.9999548690290367},
{-0.504401904120782,-0.3435012967198427,0.7922029905719341},
{-0.3678885202178371,-0.19879379673635775,0.9083716547047654},
{0.1842964145481321,-0.9818808976929512,0.044099142059536765},
{0.05859833641684336,-0.9790722045346644,0.19489446702462065},
{0.16970905082502716,-0.7703410833854946,-0.6146327792401987},
{0.45709796820404697,-0.48919782552049834,0.7427966982760142},
{0.10419862250331569,-0.747190122211876,-0.6563913225640731},
{0.5012378900042123,-0.524339636331222,0.6883520344970059},
{0.09420127125473343,-0.8056108717920727,-0.5849078933852822},
{0.4387061353482045,-0.5047070583775675,0.7435103980656259},
{-0.3264118146894529,-0.9139330804065288,-0.2412087307080148},
{-0.05800205649937042,-0.6410227278637317,0.7653271351546238},
{0.19660154037910332,-0.7381057830814658,-0.6454050567684297},
{0.42441323977752554,-0.49601547344404495,0.7575236313182742},
{0.18660014181616166,-0.7106005400566157,-0.6784005155845878},
{0.49894813335338783,-0.5169498699746766,0.6955671011170199},
{0.18800812870717076,-0.7477323289061254,-0.6368275338336508},
{0.39441254054609315,-0.54911745946719,0.7368234276733302},
{-0.27208909760828387,-0.8956641114580665,-0.35178590422122114},
{-0.11689866853174807,-0.7070919462685976,0.69739205674971},
{-0.5999175148475226,0.3808111179428849,-0.7036205425016119},
{-0.3108107775505706,0.7276252308423268,0.6115212048654245},
{-0.5679070250533501,0.42010519673342556,-0.7078087556484615},
{-0.3482135300995731,0.6848266094548755,0.6401248725351429},
{-0.6496193167175781,0.39741181721608,-0.6481192721130887},
{-0.3138168696792566,0.6709360671377095,0.6718361155211108},
{-0.6878046186235212,0.3618024295114713,-0.6293042257920644},
{-0.7409231245715825,0.2661083053698179,-0.6166192449869587},
{-0.9662420855905768,-0.08890387229248839,-0.24181053228710564},
{-0.7780524425019965,0.11140750911918047,0.6182416708929745},
{-0.44303117941641573,0.5575392382046315,0.7020494084657423},
{-0.3563170519605421,0.6328302848179372,0.6874328978885115},
{0.03160028740592095,-0.4210038290472379,0.9065082447299789},
{-0.35050055028629584,-0.5169008115349112,0.7810012261728876},
{-0.3480038663444327,-0.0383004255200913,0.9367104069104315},
{0.44979358149138776,0.7582891792906167,0.4718932661311381},
{-0.029001373972638703,0.5933281095850532,0.8044381111582956},
{-0.5925114800211393,0.1634031659670112,0.7888152834441765},
{-0.20699558069152785,-0.26029444277296954,0.9430798654598065},
{0.19730895605677776,-0.7743351478700609,0.6012272903260759},
{0.12510992223583997,-0.8853702170694575,0.4477355090726264},
{0.30350846496913364,-0.7429207203478398,0.5966166398701322},
{0.8245961367761488,0.37109826140871793,0.42699799951905837},
{0.7919963172256873,0.4218980381786837,0.44129794796931293},
{0.3067970056758368,0.908791130241853,0.28279723991240757},
{-0.06069951137090019,0.018099854296759366,0.9979919661970081},
{0.7168880782503871,0.34509426113015573,0.6057899257973003},
{0.03540035294327828,-0.3989039770924775,0.9163091356476238},
{-0.6593123226624669,-0.6417119937092447,0.3918073229472994},
{-0.4508347133551836,-0.8259635975156303,0.3384260581175557},
{0.33181342212439285,-0.741529995494989,0.5831235878262009},
{0.31041576796941117,-0.9353475121836027,0.16960861548844114},
{-0.4546121269402314,-0.8305221544739599,0.3218085843584832},
{0.9517433528971092,0.13600619522329185,0.2751125316612323},
{0.9736925756224162,-0.023999817002093034,-0.22659827219476172},
{0.984758841098686,0.12040719454481749,-0.1255074992971312},
{0.613805521205495,-0.7894071007488069,-0.008900080056580165},
{0.4321048331195878,-0.8899099536984986,0.14610163415591712},
{0.39011099738402655,-0.6880193955401442,0.6119172501904278},
{0.46171997905574996,-0.8744378377438764,0.14890644332120678},
{0.5151217566268463,-0.6136259170379207,0.5984252750252473},
{0.5507100505501347,-0.8226150128609784,0.14150258244569466},
{-0.07230360623229351,-0.9500473847950045,0.3036151431829088},
{0.05160009571826634,-0.9862018294060904,0.15730029179231192},
{-0.7889447896671001,-0.598533979738572,0.13900789170202424},
{-0.80235124379858,-0.5643360424723155,0.1943124101583748},
{-0.4944049638507558,-0.7290073192702284,0.47340475300758045},
{-0.7161517044387703,-0.5278381086479305,0.45663296780720924},
{-0.5851079019355738,-0.3587048443416345,0.7273098223854774},
{-0.32221549088209517,-0.2515120917344722,0.9126438764090629},
{-0.03610107673067048,-0.3433102393805866,0.938527992014799},
{0.23971241143141112,-0.5920306531806232,0.7694398387790059},
{-0.8663459088861,0.4032213672663922,-0.2947156173943596},
{-0.9698417137891844,0.09050389265613651,0.22630973379098002},
{-0.8051508509077844,-0.1808114195058097,0.5648356733234586},
{-0.36428943393820074,-0.2755920065697725,0.8895741982745631},
{-0.4675098107963204,-0.14070295268244337,0.8727183141859868},
{-0.4624978332027272,0.006599969079217296,0.8865958463081901},
{-0.32161684512340655,-0.4295224968299226,0.8438441974972961},
{-0.5713124918842041,-0.3543077470235839,0.7403161871904013},
{-0.9597587486310606,0.1585097026758603,-0.23181418978084803},
{-0.43939295658735844,0.3822938718783503,-0.812886969526317},
{0.5583998827360369,0.23189995130101532,-0.7964998327350525},
{0.405918904083555,-0.17270804320086217,-0.8974417948376011},
{0.8070980710379153,-0.3180992397437255,-0.4973988112182618},
{0.9895186773413039,-0.04120077767201791,-0.13840261237396306},
{0.8527937874198878,-0.06879949879747688,0.5176962285967119},
{0.8439111481399009,-0.1621021413834316,0.511406755727865},
{0.900649442508257,-0.28281552558442713,0.3299181113518477},
{0.9892960576630653,-0.12319950905093466,-0.07819968837486274},
{0.943339144669979,0.09340387587424577,-0.3184132128304053},
{0.8211702869729217,0.24452092944206474,-0.5156441358704645},
{0.3193169657610983,0.39902120055959356,-0.8595456688746133},
{-0.3450035449296363,0.4946050820933279,-0.7977081964938286},
{-0.29160122326969745,0.7484031395577557,-0.5957024989772248},
{-0.7457014392051664,0.5838011267372618,-0.32110061972479403},
{-0.9666079455499688,0.235601936655879,0.10080082858621647},
{-0.646605260155187,-0.04310035062277848,0.761606195691603},
{-0.2104058146450327,-0.30160833506151075,0.9299256988517866},
{0.43323408386611933,-0.2969233598796187,0.8509669482033263},
{0.34768948081388457,-0.1478955254885635,0.9258719881667404},
{0.3227974676637992,-0.040699680712257214,0.9455925818552929},
{0.22590030496561755,-0.45150060952623433,0.8632011653223598},
{0.4134181143115265,-0.33051448180928766,0.8484371750892576},
{-0.25320171038333045,0.9540064443352974,-0.16050108418848558},
{0.30878897025497026,0.707774718738562,-0.6353773047280055},
{-0.13529975037219083,0.8251984775102134,-0.5483989882048},
{-0.4799972040244299,0.789395401785177,-0.38269777079197775},
{-0.9250552228198385,0.3781225727007361,-0.036002149212447765},
{-0.7551884419293436,0.234596409529428,0.6120906320245647},
{-0.7952402202912375,0.26661348431796267,0.5445275401767843},
{-0.5843069708237432,0.27530328438777424,0.7634091075249795},
{0.05130331147911257,0.08610555786260414,0.9949642220383841},
{-0.03319996265006303,0.06239992980011846,0.9974988778143937},
{0.23869718100293846,-0.30879635313660414,0.9206891267256198},
{-0.5926451464636132,0.3740284927056891,-0.7133543418368129},
{-0.6434145381157349,0.3895088010507908,-0.659014890609682},
{-0.6630158031700051,0.38130908861044177,-0.6442153550559838},
{-0.6812466363347901,0.3066209904583773,-0.6647455067112962},
{-0.9332295185165134,-0.08810278673521735,-0.34831101725171626},
{-0.8402945633117631,0.039399745084473956,0.5406965017049509},
{-0.5173304328578456,0.49352903269929793,0.699141128186584},
{-0.4061299024148885,0.5785425967668382,0.7073520807142345},
{-0.3566078918199699,0.6403141703093851,0.6803150555387705},
{-0.39321760867878375,0.654829323913702,0.6454289029534258},
{-0.3689332017928112,0.6959626324955741,0.6160554413238594},
{-0.5605427205886662,0.41823187466579875,-0.714754473514219},
{0.3461185074514034,-0.12630675380269357,0.929649709699002},
{0.38130940129918495,-0.8810217218583319,0.2800069036553155},
{0.4800234137130197,-0.4831235649265829,0.7322357156680688},
{0.3358163244283053,-0.018500899350576677,0.9417457793750301},
{0.5506374308515865,-0.5988407075806937,0.5815395314932755},
{0.757896843366221,-0.12339948604221093,0.6405973319176688},
{0.6347896498391384,-0.42909300369561165,0.6425895226632488},
{0.8654047207956279,0.3608019681801047,0.3477018967190199},
{0.8251008787329038,0.19050020288282413,-0.531900566474405},
{0.5006068959074871,0.22280306913341613,0.8365115230255951},
{0.6390195255399089,0.7390225811799572,-0.2133065176802231},
{-0.6185592011805908,-0.7135529356005004,0.3289783013068451},
{-0.2527033445508978,-0.9182121526182604,0.3050040367551399},
{-0.13491023872654015,-0.9211699102373325,0.36502770300361126},
{-0.43912687099537945,-0.8159499295038263,0.3760230095519533},
{-0.7895292644445401,0.5061187596394955,-0.3471128659768206},
{-0.3805216713262906,0.904851532762228,0.1909108726838078},
{0.03109929809676284,0.5947865758184739,0.8032818701327843},
{0.37111804234220336,-0.06000291711272488,0.9266450499441813},
{0.553488457118589,-0.6310868388212132,0.5434886656620652},
{-0.6439176113875105,0.5935162328909575,-0.4828132051217426},
{-0.4384822790967783,0.6556735014908951,-0.6146751584054495},
{-0.11419954034777514,0.9920960068216087,0.051999790701263635},
{0.28589856336332864,0.6169968995983693,0.7331963156977704},
{0.43090387384323886,-0.08890079922177753,0.8980080731288663},
{0.3859058098557014,-0.6578099034026441,0.6468097377939043},
{-0.6546937771652219,-0.729393067151845,-0.19839811423488626},
{-0.6127195399376979,-0.6858218712082148,-0.39271252380207927},
{0.6239190235810479,-0.7390225331405584,0.25410774786335033},
{0.737798166573834,-0.6732983268557367,-0.04819988022344646},
{0.6160384173535967,-0.626239053485101,-0.47782979839537093},
{-0.3863192894036919,-0.6461322621892968,-0.6582328663875486},
{0.13440431377567705,-0.6238200218249058,-0.7699247111301619},
{0.7094484995572012,-0.7046481713955511,0.01240084775092937},
{-0.7146990959062154,-0.691199125633659,-0.10699986464525682},
{0.7038660961297856,-0.6876645747354938,-0.17801671655456355},
{-0.7184221492962996,-0.6907212952658046,0.08230253742634389},
{0.7664907600095817,-0.6224924958981927,0.15809809413896264},
{-0.6588060577495517,-0.6719061782057131,0.3384031116309172},
{0.5541247643890932,-0.6309281968111873,0.5430242682968375},
{-0.4182996883668482,-0.6687995017445567,0.6145995421235116},
{0.06520287290187148,-0.6322278565730544,0.7720340165681715},
{0.2499999187500396,-0.11239996347001781,-0.9616996874476523},
{0.16900597869224623,-0.9779345950482106,0.12280434428051974},
{0.33448822956629876,-0.04619837430781166,-0.9412668774013662},
{0.30841595014330314,0.776040133953318,-0.5501284506285055},
{0.40918723355746645,0.8375738681029665,-0.36198870612855044},
{-0.13640375592912996,0.4794132008242295,0.8669238710774396},
{0.11449710898449676,0.9443761548031331,0.3082922157198284},
{-0.39378338662936974,-0.43368170335489503,0.8104658071688781},
{-0.35721170959176374,-0.4594150598724979,0.8132266580067813},
{-0.2457022285293192,0.5131046538803161,0.8224074592694836},
{0.715811918367662,0.5741095590037368,-0.3975066185402985},
{0.22229993553302801,0.7999997680001009,-0.5572998383830703},
{-0.4261104717935181,0.3500086015670765,-0.8342205012207294},
{-0.5216041050404601,0.6833053776344831,-0.5109040208304659},
{-0.7468288505557562,0.6521251920827645,-0.13030503378068428},
{-0.701494984328793,0.513396329229369,0.4942964657929043},
{-0.7165933177984672,0.1329987597923474,0.6846936152618064},
{-0.7629990653267176,0.4851994056310922,0.4270994768034614},
{-0.7454082591692676,0.15720174180494886,0.6478071777432943},
{0.17880066782174145,0.05750021476370322,0.9822036685375529},
{0.008900223798941172,-0.5761144865808999,0.8173205517836653},
{-0.6122207485127565,-0.34731177059536156,0.7103240732907726},
{-0.1938998351852101,0.3919996668004248,0.8992992355959745},
{-0.34969728985650544,0.4909961947942355,0.797893816346885},
{-0.9530213955704985,-0.24870558350302516,0.17290388173571794},
{-0.5999371642587457,0.74194596126615,0.2993185418613812},
{-0.6211370798847586,0.7356439155743495,-0.27021613103342745},
{-0.8873170455241683,-0.3498067198516332,-0.30050577277134294},
{-0.444693576447682,0.4697932138860378,-0.7625889844816781},
{-0.5894091919080223,-0.5389084043420991,-0.601809385290546},
{-0.20219635443259404,0.030099457311676958,-0.978882350910318},
{-0.3334222133278025,-0.6664444000049418,-0.666844426655605},
{0.13120736225164972,-0.6655373443481164,-0.7347412274869439},
{-0.22359166018660967,-0.24199097390500687,-0.9441647833103616},
{0.12500352702427317,-0.5241147881073727,-0.8424237693219818},
{-0.29840726779751187,-0.7317178212045558,-0.6128149252892603},
{0.4276965891333025,-0.8784929940463087,-0.2128983021428106},
{-0.2964140800032081,-0.9230438456240254,-0.24521164782991445},
{-0.49019067176027376,0.41609208184302304,0.7658854253390324},
{0.048699783042949814,-0.08609961642706321,0.9950955668591244},
{-0.6127952906862866,0.7167944914554997,0.33269744322997313},
{-0.5892015643322299,0.773902054712683,-0.2322006164934552},
{-0.4623953922528741,0.47439527267466153,-0.7490925353300779},
{-0.1759982224269302,-0.04859950914743641,-0.9831900698304419},
{0.18160746331206037,-0.569423400935502,-0.8017329478925044},
{0.4882248659256485,-0.8369426265734846,-0.24731259595127583},
{0.19910487613812566,-0.05150126128133335,0.9786239667944238},
{-0.3245034478674505,0.8383089070794568,0.4381046548866874},
{-0.5805200340920708,0.8023276888063192,-0.13880479023596798},
{-0.480124203671176,0.609430722177077,-0.6309318060740365},
{-0.32410213746064487,0.34260225946935186,-0.8818058155285302},
{-0.17680643233501467,-0.1372049916083937,-0.9746354578829484},
{0.10400852436793619,-0.6675547116884366,-0.7372604246542553},
{0.3412991109169741,-0.8983976596771449,-0.2763992799808135},
{0.13029369784624908,0.8167604942503165,0.5620728131955227},
{-0.299510294345728,0.9499326497462673,-0.08900305908771217},
{-0.39191422478493754,0.6216225622003501,-0.6782246166091979},
{-0.4509155049962135,0.18990653004830552,-0.8721299887052513},
{0.06070304949428894,0.0648032554733101,-0.9960500378305072},
{0.1685962521469717,0.13869691680180884,-0.9758783064663681},
{0.045799556433443904,0.1281987584010373,-0.9906904052098882},
{0.4991116319321248,-0.3417079635968885,-0.7963185584202584},
{0.3253213726896413,-0.7674504193114994,-0.5524362934944909},
{0.3652194740215461,-0.9114485997350413,-0.18941009961577446},
{0.48920779558833455,-0.7310116487634353,-0.47570758046069245},
{0.7741940000197496,-0.036499717128288374,-0.6318951028319294},
{0.7773251740834006,-0.14850480940613017,-0.6113197979122382},
{0.1576065053427648,-0.9860406996698357,-0.05370221660473648},
{0.019200212259519796,-0.9381103708674752,-0.34580382288239303},
{-0.35881041821174137,-0.8705252760683413,-0.33680977941391993},
{-0.5219723857813761,-0.7833585575117432,0.33748214597933796},
{-0.5873991159649957,-0.696398951920366,-0.4122993794899008},
{-0.2170938150853111,-0.3770892568801051,-0.9003743487002033},
{-0.3603059649146242,-0.12940214227019806,-0.9238152938887866},
{-0.04440206452198604,-0.4331201383890125,-0.9002418577182846},
{-0.4450120733413268,0.26850728470145224,-0.854323178102237},
{0.4127210266083145,-0.4259216991337076,-0.8051410189540925},
{0.4498980002078336,-0.4187981384464119,-0.7887964938073774},
{-0.12090759021222083,-0.5608352075352643,-0.8190514175666573},
{-0.576394555979128,-0.27279742344050334,-0.7702927246195738},
{0.493524161066722,-0.4228206996940427,-0.7600372085323378},
{0.10120332660801931,0.3659120277260303,-0.9251304095363505},
{0.6933452283844194,-0.4073265707788461,-0.5944387765061285},
{-0.08970459523558943,-0.6489332424567892,0.7555387034614026},
{-0.5800298462036244,-0.5485282252460137,0.6022309885927976},
{0.3331164380362124,-0.5803286370231584,0.7431366709838169},
{-0.9344128155596487,-0.3080042243069048,0.1789024536639781},
{-0.5039287197161283,0.24201379275908522,0.8291472544485848},
{0.3857908549361744,-0.24889410003528722,0.8883789412267945},
{0.4716153159560826,-0.18570603090128188,0.8620279948137047},
{0.7984053253812805,0.24210161482315634,0.5513036772077905},
{-0.7607257928452671,-0.2107071441468355,0.613920815338122},
{-0.5492173939903059,0.11210355037566148,0.8281262271729284},
{-0.30059054357024656,0.12159617464451757,0.9459702402443554},
{-0.07440353276360541,0.17220817663834478,0.9822466381775973},
{-0.6820215522215807,0.1368043230849153,-0.718422702516105},
{-0.6451983870060487,-0.5935985160055649,-0.4809987975045093},
{-0.8895277492509636,-0.38601204183347043,-0.2444076244147673},
{-0.8577212331519434,0.4386108579461844,-0.26820663953754365},
{-0.8238695540037475,0.4654392940438748,0.32342730488566634},
{-0.28381386180752427,-0.8022391823185201,-0.5252256526473282},
{-0.3328978727893893,0.011399927154698224,-0.9428939749267504},
{-0.5601157786837314,0.45811290522231274,-0.6902194437555997},
{-0.7645043959129149,0.5771033183536208,-0.28720165141424353},
{-0.7357248274532107,0.5479184898214139,0.3981134345645279},
{-0.5782984414878003,0.6214983250642709,0.5284985756982576},
{-0.8762336261106154,-0.36161387719881133,0.31851222314109906},
{-0.8339572364492737,-0.1768121350332553,0.5227358765943583},
{-0.9307969051054358,-0.2548991524617271,0.26199912885434484},
{-0.8337481795306215,-0.18751083562671408,0.5193300103517473},
{-0.7042130280615299,-0.11500212755903995,0.7006129614596815},
{0.9438251155204904,0.3303087896338398,-0.00950025280509076},
{0.9044080221347347,0.3607031994515688,0.22790202149989608},
{0.3588093219872794,0.830421574632767,0.4262110731075209},
{0.8054441476036284,0.5271288927264373,0.2709148492498422},
{0.12620344224583155,0.9026246194222467,0.411511224121709},
{-0.24989012703611732,0.9000644391564995,0.35698589576588186},
{-0.4275335605640564,0.8274649544109949,0.36402857554460005},
{-0.5247179955122395,0.7674263193369402,0.368412634927976},
{0.49818119401488214,0.7084732556393899,0.4998811298435159},
{0.78991574712738,-0.2276045373416783,0.5694113513284342},
{0.9725585984208854,0.06860413352357093,0.2223133947855659},
{0.9977702754353355,0.03230227512935886,0.058404113546580726},
{0.5463277295676392,0.5602284351158547,0.6226316024689953},
{0.11470265539720903,0.9385217270294741,0.3256075379017547},
{-0.1829033233835791,0.923016771367105,0.3385061507126382},
{-0.7764246557564216,0.46321470961665956,0.42731356955785543},
{-0.8804239082358467,0.44481207903601155,0.164304461748239},
{-0.9289722891699149,0.3670890498969599,-0.04749858313839715},
{-0.8246475959095365,0.5610323809183241,-0.0721041616117846},
{0.9784591697507519,-0.08639639475366884,0.1874921761147327},
{0.9935730347937486,0.10839705814376242,-0.03259911527201711},
{0.765521228197991,0.14300396555494801,-0.6273173957525796},
{0.1932099525009866,0.17430897888675964,-0.9655497367479428},
{-0.4669924581327013,0.15769745320669593,-0.8700859482254034},
{-0.8567558880094217,0.20591343217128508,-0.4728308437619407},
{-0.9010855196720473,0.3137949573555526,-0.2992951903649359},
{-0.46822489852098587,0.46712484002382,0.7500398844313101},
{0.04400181093179411,0.5020206610854693,0.8637355477679677},
{0.8345368831725958,0.5494242823427491,0.04100181211513053},
{0.717935718190492,0.57282849892675,-0.3955196775934526},
{0.1269083013434952,0.6451422001315111,-0.753449284729624},
{0.8240402635909426,-0.5362262006522615,0.18280893226265085},
{0.6446868678622512,-0.3271933351396441,0.6908859267970052},
{0.722703057040397,-0.21150089465067654,0.6580027833576604},
{0.763819702983361,0.004100105763592276,0.6454166487371841},
{0.951463150705038,-0.12570834353965027,0.2809186451892423},
{0.9844321865365168,0.028700938392521365,0.1734056695910524},
{0.985891136878519,0.11309898324471093,-0.12339889064895958},
{0.9872928026617028,0.04399967924350747,-0.15269888682917254},
{0.8935923776895275,0.416296449006435,-0.1678985678313246},
{0.9190544601856053,0.3400201484908659,0.19931181057126346},
{0.8125327050995836,0.12650509193242748,-0.569022903632816},
{0.2507120369738496,0.18070867603180943,-0.9510456607982887},
{-0.559723472495989,0.6198259929480328,-0.5500230657009004},
{0.8390670902914137,-0.2678214145173308,0.4735378632335928},
{0.9170981795619203,-0.22659955020033926,0.3279993489219386},
{0.9836103033718919,-0.16280170535679545,0.07750081182525582},
{0.9568814318959694,0.20659599104369034,0.20419603761433477},
{0.7208156202437378,0.18810407625949926,0.6671144565269111},
{0.7898436321673947,-0.3802210039884065,0.48122658369074495},
{0.9385862920473063,-0.3390950475529955,-0.06379906822141289},
{0.722766446973846,-0.20411876550070837,0.6602607005564315},
{0.405406208843633,-0.17610269703345777,0.897013737870594},
{0.44790929421428344,-0.05280109563410173,0.8925185199514354},
{0.7135161327821453,-0.08620194904810222,0.6953157212661888},
{0.547524940329061,-0.1084049379573885,0.8297377954173915},
{0.8790560966396026,-0.23778812396871518,0.41317936427196433},
{0.6434699538719896,0.0032998459172922543,0.7654642574809759},
{0.7101176608458405,-0.5835145121863794,0.39400979914555867},
{-0.7883377031522515,0.1055050458994831,0.6061289888121015},
{-0.9185692054835706,0.07649743546646326,0.38778699965875096},
{-0.9344950191548218,0.11199940304477266,0.3378981990073989},
{-0.8685392024016205,0.24781118521027237,0.4292193732536276},
{-0.7809307888032848,0.43471713906106785,0.44851768315824464},
{-0.4313089325004891,0.018300379004773826,0.9020186810003273},
{0.08429967881883554,0.2712989663529073,0.958796346992877},
{-0.7752448337051372,0.37712180958489067,0.506729305003087},
{-0.9005976719580269,0.4344988768218551,-0.011599970014116268},
{-0.8902890183526876,-0.04369946097047338,0.4532944086479538},
{0.3999066425044984,-0.16860280051577503,0.9009149643218372},
{-0.7120096798373965,0.42160573176888533,-0.5615076337481716},
{-0.3819057229001368,0.8811132035802841,-0.2789041794104429},
{0.2836942538310824,0.9588805780705846,0.00809983593948455},
{0.148694458260809,0.932165258848192,0.3300876978607468},
{0.0416988904072892,0.9791739445279996,0.19869471280403747},
{0.07920122208428522,0.9937153331458866,0.0791012205412495},
{-0.697368976689878,0.6189612213873017,0.3613357396788368},
{-0.6632648910022175,0.7016628584596051,-0.26028622211348895},
{-0.29951783532052206,0.9425561261755995,-0.147908807492171},
{0.5244948468634443,0.8111920300774567,0.25859745929244365},
{0.2994186229203968,0.8994559434021538,0.3183197985155722},
{-0.161394469913231,0.985566230151676,0.05109824914848888},
{-0.06719821759091728,0.9610745078367648,0.2679928915828249},
{0.5440087450108647,0.7464119986693186,0.3833061616960743},
{0.5413061249134553,0.8408095138134735,-0.005200058838998646},
{-0.24900638709574457,0.7341188303895023,0.6317162037284412},
{-0.3757873775139805,0.5422817850607546,0.7514747583867917},
{-0.254510461867557,0.7795320433232247,-0.5723235258420546},
{0.33441018461726113,0.8953272676071589,-0.29420896027032967},
{-0.3643126163643608,0.8283286855190779,-0.42561473929363697},
{-0.14630016312477284,0.5212005811389719,-0.840800937493568},
{0.3031960448333926,0.6987908843323704,-0.647891548309878},
{-0.2884968640561315,0.5517940020317967,-0.7824914943636843},
{-0.09990309154900272,0.20270627284267118,-0.9741301449237592},
{0.5830293271127492,0.43962211354848124,-0.6832343675530537},
{0.245508933005044,0.045301648330462296,-0.968335233518469},
{0.5093145716983474,-0.4102117363256669,-0.7565216443938736},
{0.17720341474270346,-0.16690321625596619,-0.9699186905132511},
{0.1905081443972632,-0.7317312821809842,-0.6544279773940632},
{-0.6524274742994263,-0.0539022698723775,0.7559318329597431},
{0.07610023933562907,-0.2459007733591483,0.9663030390278367},
{-0.07790123902906021,-0.14530231105163607,0.9863156874757649},
{0.5146277366093169,-0.392421150107843,0.7623410874801445},
{-0.726225425597233,0.013500472659821875,0.6873240636367093},
{-0.6055817359302623,-0.1219963206464531,0.7863762832489404},
{-0.0017000110076069112,0.028000181301760893,0.9996064724728639},
{0.05370139249516133,0.11660302355560169,0.9917257157812196},
{0.7127406772712109,0.2804160037980181,0.6429366934441721},
{0.40900915168215446,0.030500682460405163,0.9120204066849019},
{-0.08390127069436706,-0.07410112226999523,0.9937150499283975},
{-0.669399230191328,-0.19629977425538944,0.7164991760264214},
{-0.709495849461421,-0.2223986989714165,0.6686960881393266},
{-0.6194396918699255,0.033002114678249185,0.7843502588530556},
{-0.6322904809384637,0.15489766803316155,0.7590885720075721},
{-0.7012154374277844,0.17230379330976506,0.6918152304799503},
{-0.012700109602418805,0.21190182872067284,0.9772084333451698},
{0.6094295915722456,0.2787135332641694,0.7422360401459152},
{0.8664311920843826,0.20600741640048803,0.45481637368418426},
{0.8926126484108426,0.14430204477446182,0.42710605213563846},
{0.49899114298581737,-0.09589829782032042,0.8612847123320331},
{0.5398408000102494,-0.26652014302099203,0.7984603459210506},
{0.7612797121660025,-0.40748914055910423,0.5043865582773305},
{0.8921517061504883,-0.4482259776893273,-0.05620325735417268},
{0.7022900345751136,-0.5096927675109433,-0.49699294772010744},
{0.055999455407944224,-0.4540955839419191,-0.8891913526561429},
{-0.2957969059805451,-0.44779531608549045,-0.8437911739904798},
{-0.6725403200008122,-0.4848290663738198,-0.5591335210594114},
{-0.9913541194986155,-0.1312071627945308,0.0013000709728116615},
{-0.900432195528737,-0.2308082526966154,0.36871318357557237},
{-0.7655154827072082,-0.030100608790969256,0.6427129990018586},
{-0.6876945466038681,0.012399901669169643,0.7258942436814713},
{-0.7560472619915668,-0.2163135221809205,0.6177386160478715},
{-0.6287218956212792,-0.15450538074357822,0.7621265415189706},
{-0.5385999326750126,0.01019999872500024,0.8424998946875198},
{-0.621022040463331,0.1569055686774503,0.7679272542218871},
{-0.562126074822735,0.2569119171356709,0.7861364657857178},
{-0.5714035255706291,0.23230143330426523,0.7871048564519465},
{-0.1097055940308631,0.46432367646791006,0.8788448134395851},
{-0.33370497390970444,0.3665054628046349,0.8685129452819249},
{-0.4736107676632057,0.6261142348689465,0.6194140825392517},
{-0.5666899526762078,0.7135873482084735,0.4118926972072172},
{-0.7397278364822402,0.6727253151299214,0.015600587061136872},
{-0.7081084371622934,0.7060084121403463,0.011600138216470279},
{-0.6380262202262914,0.7305300217481283,-0.24341000313962277},
{-0.6938090993660078,0.6677087570577737,-0.26980353849661126},
{-0.42140813957682466,0.5046097466313852,-0.753514554274175},
{-0.5917897976318325,0.33499422474934754,-0.7331873599588705},
{-0.3158980240640392,0.08809944893967031,-0.9446940909569416},
{-0.10169689981726289,0.057198256337732914,-0.9931697236824533},
{-0.06820381372286946,0.17470976916987235,-0.982254924319683},
{0.11980152987530482,0.26810342370258117,-0.955912207076827},
{0.4490292394909252,-0.07740504039331315,-0.8901579645231014},
{0.35499405567430614,-0.02679955124527156,-0.9344843521905326},
{0.6333905340492024,-0.24269637292980967,-0.7347890186601737},
{0.3845034240182364,-0.1995017765712306,-0.90130802618371},
{0.6541831026686843,0.18689517256003838,-0.7328810699264425},
{0.2962104490078864,-0.019000670260465365,-0.9549336858799146},
{0.6098387259886895,0.2740174006574302,-0.7436472230980478},
{0.7964017043014708,0.27700059278190287,-0.537601150467693},
{0.923972007944478,0.15021170645444376,-0.3517274111852721},
{0.8978696908606891,0.37882940398532977,-0.22431741107156666},
{0.9537143344341706,0.3007045196228952,0.002400036072813263},
{0.9233566866070396,0.38282350225622735,-0.029301798892652723},
{0.9113543639092591,0.3945235340307283,0.11740700353664767},
{0.9322344280531538,0.2817104037573197,0.22710838726761556},
{0.9124625423260501,-0.2890198100966993,0.2896198512249278},
{0.9561140215149391,-0.2885042309455705,-0.051100749397984924},
{0.8272314147094717,-0.3086117197525906,-0.46951783027816363},
{0.4954182763173262,-0.6109225373481117,-0.6175227808355853},
{0.029799284080799838,-0.5448869092492562,-0.8379798677755123},
{-0.4000243122163849,-0.4046245918068733,-0.8223499798388332},
{-0.632127482339705,-0.6642288779782187,-0.3990173476562922},
{-0.9942218283798657,-0.04940108461271914,0.09530209238040757},
{-0.9895436299404873,-0.09340411827836434,0.10990484581148009},
{-0.9949728276631097,0.0030999153424679797,0.10009726638098218},
{-0.9843109554419015,0.14090156824318187,0.10620118202573396},
{-0.9661192549486286,0.22070439868249908,0.13380266671372168},
{-0.9627011841231847,0.1760002164803994,-0.20550025276546635},
{-0.7331373506337663,0.07850399948813348,-0.6755344159775053},
{-0.7004250441451881,0.0008000286055341955,-0.7137255197121941},
{-0.6002960200505805,-0.15859894849245723,-0.7838948027946862},
{-0.5226040214534177,-0.2277017521717245,-0.8216063222849751},
{0.3692106241885687,-0.31750913645685425,-0.8734251331698156},
{0.8578066994964847,-0.2823022047888291,-0.4295033544342972},
{0.9720466156132044,-0.23471125584816777,-0.006000287750698793},
{0.9203971559771821,-0.1678994811914047,0.35309890892605716},
{0.25161583216625555,-0.29221838695937946,-0.9226580554713328},
{-0.5057875350197973,-0.23729415195768663,-0.8293795601926055},
{-0.9262444561695364,-0.1046050206384512,-0.36211738024075696},
{-0.9349787014277694,-0.1165973439427571,-0.3349923689607516},
{-0.959497299018905,-0.04969986009509075,-0.2772992194037961},
{-0.9659898523299015,0.08949905981731489,-0.24259745152715748},
{-0.6331276207949489,0.300513110170403,0.7133311197489134},
{-0.17329761717414569,0.8304885808605192,0.5293927209001311},
{0.32600738578098826,0.6562148667162101,0.6805154172514186},
{0.5048002725922208,0.4398002374921924,0.7428004011123249},
{0.5927914520088925,0.2125969343743093,0.7767887987862816},
{0.3591261201926169,0.3157229633662188,0.8782638784549045},
{0.2802999397355194,0.604699869989542,0.7454998397175517},
{-0.3275160323021814,0.1501073479345265,-0.9328456639129001},
{-0.21870697030221706,0.08090257840626136,-0.9724309918695742},
{-0.18780534407709965,0.09050257528742021,-0.9780278301778671},
{0.32140324297508255,0.5115051611131135,-0.7969080408426984},
{0.4427141892171503,0.4194134424162476,-0.7925254008461522},
{-0.3312294326989218,-0.13541203257075488,-0.9337829749727756},
{-0.313411195247845,-0.07000250053397943,-0.94703382865255},
{-0.11239502943973212,-0.06619707249920165,-0.9914561538211245},
{-0.1210059869193079,0.002300113800945522,-0.9926491125297937},
{0.09090294484859832,0.09380303879866361,-0.9914321179637006},
{-0.951216589361979,-0.29720518330359563,0.08280144406977696},
{-0.9019420404982843,-0.41861951231021377,0.10610494566677897},
{-0.8384130751538613,-0.5161080487677813,-0.17520273230791567},
{-0.8453945176343297,-0.5074967088945141,-0.16659891960950948},
{-0.5745125187641773,-0.5371117037915398,-0.6176134579438746},
{0.10710301285012781,0.006300177226478107,-0.9942279680261165},
{0.0,0.0759011681279663,-0.9971153457232569},
{-0.8975098636876032,-0.4381048147983721,-0.050400553905131144},
{0.0,0.02620148566635712,-0.9996566821408617},
{-0.10710301285012781,0.006300177226478107,-0.9942279680261165},
{-0.09090294484859832,0.09380303879866361,-0.9914321179637006},
{0.18780534407709965,0.09050257528742021,-0.9780278301778671},
{0.2586054876666731,0.3862081954248613,-0.8854187887860492},
{0.1210059869193079,0.002300113800945522,-0.9926491125297937},
{0.21870697030221706,0.08090257840626136,-0.9724309918695742},
{0.3275160323021814,0.1501073479345265,-0.9328456639129001},
{-0.9417771394157851,0.22291825886776948,-0.25172061802161316},
{-0.7244325639756425,0.1557069991869237,-0.6715301859603036},
{-0.2454041645440088,0.23010390489639942,-0.9417159810557989},
{0.16409674271198543,0.14329715557969236,-0.9759806269768299},
{0.0,0.05090019087607368,-0.9987037451460664},
{-0.16409674271198543,0.14329715557969236,-0.9759806269768299},
{0.2454041645440088,0.23010390489639942,-0.9417159810557989},
{0.7244325639756425,0.1557069991869237,-0.6715301859603036},
{0.5917897976318325,0.33499422474934754,-0.7331873599588705},
{-0.9626713269610196,0.2225164868572895,0.15411141853801488},
{-0.9462313349694949,0.25870856727606034,0.19420643125245815},
{-0.9240066667321508,0.29490212772652735,-0.24340175615000595},
{-0.976870351851674,-0.0293021102674591,-0.21181525442484087},
{-0.970794592689178,0.02409986576412154,0.23869867045210835},
{-0.9101318051116541,-0.28711003323542017,0.29871043861866947},
{-0.38149841678485547,0.34419857157889183,0.8578964397371625},
{-0.1301087429507337,0.4978334530428536,0.8574576188006081},
{0.47429338365344675,0.7720892294303736,0.4229940992734724},
{0.18920671695768013,0.6906245176055703,0.6980247803195598},
{0.5450185145934164,0.8291281659622047,0.1245042294805144},
{0.452211183320847,0.7771192183959094,0.4377108247225447},
{0.6646038081907314,0.7077040551558541,0.23970137349280518},
{0.23590547542962784,0.649415073098772,0.7229167790931664},
{0.196706148146742,0.4532141654301143,0.8694271743710091},
{0.45953477201408643,0.7019531152920288,0.544141173999705},
{0.6202994758471644,0.5487995362645878,0.5603995264626003},
{0.3574044747320356,0.9202115211203671,0.1596019982295268},
{0.5121085753298915,0.858914382641757,0.003300055259887994},
{0.21250036762595398,0.968501675509348,0.1298002245545827},
{-0.35931945048829667,0.2399129868414761,0.9018488183978457},
{-0.9680055902484256,0.2382013756169163,0.07890045565144709},
{0.36280951843257575,-0.0345009051431198,0.9312244309934249},
{0.8557505849121554,-0.11150659134942775,0.505229865020008},
{0.9803665593451477,-0.19381315842200308,0.03630246465799129},
{-0.11539950262921549,-0.4038982592022542,0.9074960887002864},
{0.2832073280844225,-0.8524220567060796,0.43951137250389716},
{0.600522489988383,-0.7791291789341368,-0.1798067338882785},
{-0.2523901014543277,-0.053197913618741016,-0.9661621078651799},
{0.25800332697435213,-0.09550123149632027,-0.9614123974927989},
{0.0,-0.16780348363648082,-0.9858204658453086},
{-0.25800332697435213,-0.09550123149632027,-0.9614123974927989},
{0.2523901014543277,-0.053197913618741016,-0.9661621078651799},
{0.6844157348986201,-0.04790110125897706,-0.7275167258017915},
{0.3158980240640392,0.08809944893967031,-0.9446940909569416},
{0.06820381372286946,0.17470976916987235,-0.982254924319683},
{0.5315118289273807,-0.28680638294707955,-0.7970177378271354},
{-0.4490292394909252,-0.07740504039331315,-0.8901579645231014},
{-0.2640957665787923,-0.528991520333893,-0.80648707211585},
{-0.6333905340492024,-0.24269637292980967,-0.7347890186601737},
{-0.3083077401629764,-0.3753094222613203,-0.8741219451069013},
{-0.6541831026686843,0.18689517256003838,-0.7328810699264425},
{-0.7964017043014708,0.27700059278190287,-0.537601150467693},
{-0.7365245782352704,-0.3074102584514896,-0.6025201064314331},
{-0.9431954632407328,-0.2096989913502774,-0.2576987604719432},
{-0.8576542655021218,-0.4887309229837767,-0.15991011783324305},
{0.0,-0.9885800061715607,-0.1506969521849628},
{0.0,-0.9547198870223722,-0.29750619711862963},
{0.8576542655021218,-0.4887309229837767,-0.15991011783324305},
{0.9431954632407328,-0.2096989913502774,-0.2576987604719432},
{0.7365245782352704,-0.3074102584514896,-0.6025201064314331},
{0.3083077401629764,-0.3753094222613203,-0.8741219451069013},
{0.2640957665787923,-0.528991520333893,-0.80648707211585},
{-0.5315118289273807,-0.28680638294707955,-0.7970177378271354},
{-0.6844157348986201,-0.04790110125897706,-0.7275167258017915},
{-0.9593755969786132,0.10560832173557964,-0.26162061520859503},
{0.0,-0.6568321067380852,-0.7540368582224668},
{-0.3530183150652907,-0.5340277060761055,-0.7682398573177233},
{0.20290530705771004,-0.47581244503725206,-0.8558223843271969},
{0.3124000687280227,0.949600208912069,0.025800005676001873},
{-0.6553184179829598,0.5159144999807859,-0.551715506182205},
{-0.7099736427177621,0.6779748306516095,-0.19049292808131504},
{-0.6201101853934433,0.30330498182524007,-0.7235118837802875},
{0.3921089343038533,0.851919411204929,-0.34710790894380894},
{-0.07500380128897642,0.7208365329212562,-0.6890349211747301},
{0.17159500151040796,0.9802714451087,-0.0980971424718591},
{-0.1501039162622636,-0.7570197509029549,0.6359165912803026},
{0.0,-0.9568130462348288,-0.29070396377556934},
{0.5173231533158515,-0.7872352335013307,-0.3356150207863905},
{0.3530183150652907,-0.5340277060761055,-0.7682398573177233},
{0.7628493846534251,-0.4613298651555126,-0.4530293278028338},
{-0.20290530705771004,-0.47581244503725206,-0.8558223843271969},
{-0.7518187618713067,-0.3686091987573339,0.546713643409209},
{-0.7500961820201502,-0.23039882727295374,0.6198968447330904},
{-0.5075140329570196,0.3598099488826318,0.7829216480828584},
{0.8472850116607145,0.20969629050543115,0.48799136750906247},
{0.4344858577154933,0.6125800608435241,0.6602785082843273},
{0.9949728276631097,0.0030999153424679797,0.10009726638098218},
{0.959497299018905,-0.04969986009509075,-0.2772992194037961},
{0.9349787014277694,-0.1165973439427571,-0.3349923689607516},
{0.9895436299404873,-0.09340411827836434,0.10990484581148009},
{0.5226040214534177,-0.2277017521717245,-0.8216063222849751},
{0.5057875350197973,-0.23729415195768663,-0.8293795601926055},
{0.9262444561695364,-0.1046050206384512,-0.36211738024075696},
{0.9942218283798657,-0.04940108461271914,0.09530209238040757},
{0.632127482339705,-0.6642288779782187,-0.3990173476562922},
{0.4000243122163849,-0.4046245918068733,-0.8223499798388332},
{-0.029799284080799838,-0.5448869092492562,-0.8379798677755123},
{-0.4954182763173262,-0.6109225373481117,-0.6175227808355853},
{-0.25161583216625555,-0.29221838695937946,-0.9226580554713328},
{-0.3692106241885687,-0.31750913645685425,-0.8734251331698156},
{-0.6098387259886895,0.2740174006574302,-0.7436472230980478},
{0.7012154374277844,0.17230379330976506,0.6918152304799503},
{0.6331276207949489,0.300513110170403,0.7133311197489134},
{0.17329761717414569,0.8304885808605192,0.5293927209001311},
{-0.32600738578098826,0.6562148667162101,0.6805154172514186},
{-0.5048002725922208,0.4398002374921924,0.7428004011123249},
{-0.5927914520088925,0.2125969343743093,0.7767887987862816},
{-0.6094295915722456,0.2787135332641694,0.7422360401459152},
{0.012700109602418805,0.21190182872067284,0.9772084333451698},
{-0.2962104490078864,-0.019000670260465365,-0.9549336858799146},
{-0.3845034240182364,-0.1995017765712306,-0.90130802618371},
{-0.35499405567430614,-0.02679955124527156,-0.9344843521905326},
{-0.11980152987530482,0.26810342370258117,-0.955912207076827},
{0.10169689981726289,0.057198256337732914,-0.9931697236824533},
{0.42140813957682466,0.5046097466313852,-0.753514554274175},
{0.6002960200505805,-0.15859894849245723,-0.7838948027946862},
{0.7004250441451881,0.0008000286055341955,-0.7137255197121941},
{0.7331373506337663,0.07850399948813348,-0.6755344159775053},
{-0.4665106878822905,0.1947044607302936,0.8628197674273103},
{0.5045164197540757,-0.3435111797532706,0.7921257801530295},
{0.0,-0.3840969848505033,0.9232927521803429},
{-0.46200960527954166,-0.7419154245820172,0.4859101021760374},
{0.46208825617620203,-0.7418811453302842,0.48588765132226047},
{0.22900229919462595,-0.9734097730831829,-0.005600056224846747},
{-0.0,-0.9998554735205492,0.017000943238497036},
{0.00010000145553177798,-0.8068117432303846,0.5908085992817442},
{-0.22900229919462595,-0.9734097730831829,-0.005600056224846747},
{-0.7226277458249617,0.2714104210031754,0.6357244091072906},
{-0.3200201218977664,0.2871180531151523,0.9028567689040734},
{-0.6014078273738103,0.3324043262704598,0.726509455582097},
{0.8088161562640837,-0.5519110245328236,0.20300405504649974},
{0.9019420404982843,-0.41861951231021377,0.10610494566677897},
{-0.17720341474270346,-0.16690321625596619,-0.9699186905132511},
{-0.4427141892171503,0.4194134424162476,-0.7925254008461522},
{-0.7208156202437378,0.18810407625949926,0.6671144565269111},
{-0.9190544601856053,0.3400201484908659,0.19931181057126346},
{-0.9568814318959694,0.20659599104369034,0.20419603761433477},
{0.3312294326989218,-0.13541203257075488,-0.9337829749727756},
{-0.6390195255399089,0.7390225811799572,-0.2133065176802231},
{-0.8251008787329038,0.19050020288282413,-0.531900566474405},
{-0.5006068959074871,0.22280306913341613,0.8365115230255951},
{0.6746629957494967,0.6779628147593877,-0.29188399060216114},
{0.4308211344491383,0.8802431813884204,0.19890975775750605},
{0.6714154393755447,0.6687153772869031,-0.3194073448563434},
{0.44543393222222977,0.8932680472853516,0.06050460911415559},
{0.22389301240812237,0.9663698400679298,-0.12649605211981904},
{-0.39882980167621346,0.7264542826920799,0.5596418179990197},
{-0.29010232372891964,0.5439043566913457,0.7874063071497804},
{-0.2747106218915471,0.494319113218026,0.8247318888749869},
{0.161394469913231,0.985566230151676,0.05109824914848888},
{-0.2994186229203968,0.8994559434021538,0.3183197985155722},
{-0.21250036762595398,0.968501675509348,0.1298002245545827},
{0.06719821759091728,0.9610745078367648,0.2679928915828249},
{-0.5121085753298915,0.858914382641757,0.003300055259887994},
{-0.3574044747320356,0.9202115211203671,0.1596019982295268},
{-0.6202994758471644,0.5487995362645878,0.5603995264626003},
{-0.45953477201408643,0.7019531152920288,0.544141173999705},
{-0.196706148146742,0.4532141654301143,0.8694271743710091},
{-0.23590547542962784,0.649415073098772,0.7229167790931664},
{-0.5440087450108647,0.7464119986693186,0.3833061616960743},
{-0.5413061249134553,0.8408095138134735,-0.005200058838998646},
{-0.452211183320847,0.7771192183959094,0.4377108247225447},
{-0.4308998728845563,0.7782997704016016,0.4566998652735596},
{-0.148694458260809,0.932165258848192,0.3300876978607468},
{-0.2836942538310824,0.9588805780705846,0.00809983593948455},
{0.3560992343874691,0.3946991513977367,0.8469981789558728},
{0.3933199536273841,0.3191161891749257,0.8622437427346316},
{0.2979979363714359,0.406697183631755,0.863594019632121},
{0.11639983704034221,0.898998741402643,0.42219940892124125},
{0.005499916704392263,0.9229860214825562,0.3847941723363896},
{-0.32101967750421745,0.6204380309146931,0.7155438606051949},
{-0.3132043707974919,0.1803025161391692,0.9324130119143725},
{-0.0362989832797173,-0.24369317424978254,0.9691728538485401},
{0.06189997926351041,-0.1640999450265276,0.9844996701926656},
{0.39481361340808946,0.14000482744967713,0.9080313094593345},
{0.5433276750999648,0.798240659423508,0.26001324411189186},
{0.5006321391117885,0.8505546031054257,0.1610103363903275},
{0.3877060114283111,0.424706585126654,0.8181126849355207},
{0.48721298683524844,-0.35330941758804035,0.7986212875341325},
{0.4957361826257316,-0.35732608039575126,0.7915577739525248},
{0.35482518993438195,0.5203369400306057,0.7767551438050575},
{0.47733130918738803,0.29631943622925433,0.8272542613865649},
{0.6639308535836658,0.5079236037583127,0.5488255045138059},
{0.8413183661804027,0.5293115549973697,0.10960239264634748},
{0.8892612544248799,0.41642868459572646,0.18921303344263077},
{0.8280983065406946,-0.05579988588935004,0.5577988593024991},
{0.76874774456131,-0.11710727317305762,0.6287390490512497},
{0.5176038794556148,0.17750133037745677,0.8370062733855286},
{0.6454832596087402,0.30989196305615585,0.6980818954808081},
{0.6162267571467056,-0.11960519337024665,0.7784338003294314},
{0.8267366293778149,0.20850923820645265,0.5225231509010624},
{0.756726535081187,0.1893066381536523,0.6257219413245656},
{0.8922487136483188,0.0826045099163317,0.4439242367053225},
{0.9344950191548218,0.11199940304477266,0.3378981990073989},
{0.7883377031522515,0.1055050458994831,0.6061289888121015},
{-0.6933452283844194,-0.4073265707788461,-0.5944387765061285},
{-0.10120332660801931,0.3659120277260303,-0.9251304095363505},
{0.04349889057494365,-0.38239024726111387,0.9229764597855861},
{0.4521130346066843,-0.7323211131220413,0.5092146808708773},
{0.05099856594048834,-0.9419735120772553,0.33179067017753006},
{0.04940424746573979,-0.6953597826503821,0.7169616398418797},
{-0.5173231533158515,-0.7872352335013307,-0.3356150207863905},
{-0.7628493846534251,-0.4613298651555126,-0.4530293278028338},
{0.7099736427177621,0.6779748306516095,-0.19049292808131504},
{0.6553184179829598,0.5159144999807859,-0.551715506182205},
{-0.3124000687280227,0.949600208912069,0.025800005676001873},
{-0.3921089343038533,0.851919411204929,-0.34710790894380894},
{0.6201101853934433,0.30330498182524007,-0.7235118837802875},
{0.6185592011805908,-0.7135529356005004,0.3289783013068451},
{-0.9571035843596352,0.2883010796895652,0.028900108231107988},
{-0.41160366946307,-0.09000080236072958,-0.9069080851216184},
{0.0,0.7712456243844057,0.6365376554987995},
{-0.37251395090869716,0.728727291348101,0.5746215199788923},
{0.0,-0.0011999991360009332,0.9999992800007776},
{0.27429156703540525,0.127396083267629,0.9531706952174565},
{-0.4035948299833417,0.36749529241545603,0.8378892667072397},
{-0.32100792899377045,0.5788142968897019,0.7496185158060135}
};


// face array: 40kb.
const uint16_t cyborg_face[20547] PROGMEM = {
18, // chain 0
0,0,0, 1,1,1, 2,2,2, 
32771,3,3, 32772,4,4, 5,5,5, 32774,6,6, 7,7,7, 32776,8,8, 9,9,9, 32778,10,10, 32779,11,11, 12,12,12, 13,13,13, 32782,14,14, 32783,15,15, 16,16,16, 32785,17,17, 18,18,18, 
32787,19,19, 
9, // chain 1
20,20,20, 21,21,21, 22,22,22, 
23,23,23, 32792,24,24, 32793,25,25, 32789,21,21, 26,26,26, 32770,2,2, 32795,27,27, 32788,20,20, 
9, // chain 2
28,28,28, 29,29,29, 30,30,30, 
31,31,31, 32800,32,32, 32801,33,33, 32802,34,34, 32803,35,35, 32804,36,36, 32805,37,37, 32797,29,29, 
14, // chain 3
38,38,38, 39,39,39, 14,14,14, 
16,16,16, 18,18,18, 40,40,40, 32809,41,41, 32810,42,42, 32811,43,43, 44,44,44, 45,45,45, 32814,46,46, 47,47,47, 32791,23,23, 32816,48,48, 20,20,20, 
32, // chain 4
49,49,49, 50,50,50, 51,51,51, 
52,52,52, 53,53,53, 32822,54,54, 55,55,55, 32824,56,56, 57,57,57, 58,58,58, 32827,59,59, 60,60,60, 32829,61,61, 62,62,62, 32831,63,63, 64,64,64, 32833,65,65, 66,66,66, 32835,67,67, 
68,68,68, 69,69,69, 70,70,70, 32839,71,71, 72,72,72, 32841,73,73, 74,74,74, 50,50,50, 75,75,75, 32817,49,49, 76,76,76, 32845,77,77, 32821,53,53, 58,58,58, 32823,55,55, 
37, // chain 5
78,78,78, 79,79,79, 80,80,80, 
81,81,81, 32850,82,82, 32851,83,83, 32852,84,84, 32847,79,79, 85,85,85, 32854,86,86, 32855,87,87, 32846,78,78, 88,88,88, 32857,89,89, 32858,90,90, 32849,81,81, 91,91,91, 32860,92,92, 32850,82,82, 
93,93,93, 32862,94,94, 32863,95,95, 32851,83,83, 96,96,96, 32865,97,97, 32852,84,84, 98,98,98, 32853,85,85, 99,99,99, 32868,100,100, 32854,86,86, 101,101,101, 32870,102,102, 32871,103,103, 32855,87,87, 
104,104,104, 32856,88,88, 105,105,105, 32857,89,89, 
41, // chain 6
106,106,106, 107,107,107, 108,108,108, 
109,109,109, 32878,110,110, 32879,111,111, 32880,112,112, 32881,113,113, 32875,107,107, 114,114,114, 32883,115,115, 32884,116,116, 32885,117,117, 32874,106,106, 118,118,118, 32887,119,119, 32877,109,109, 120,120,120, 32889,121,121, 
32890,122,122, 32878,110,110, 111,111,111, 123,123,123, 32892,122,124, 32893,110,125, 32894,108,126, 32880,112,112, 127,113,127, 32896,124,128, 32881,113,113, 129,125,129, 32882,114,114, 130,126,130, 32899,127,131, 32883,115,115, 
132,128,132, 32901,129,133, 32884,116,116, 134,130,134, 32903,131,135, 32904,132,136, 32841,133,73, 32885,117,117, 
16, // chain 7
137,134,137, 138,135,138, 139,136,139, 
140,137,140, 32909,138,141, 32910,139,142, 32906,135,138, 143,140,143, 32912,141,144, 32913,142,145, 32914,143,146, 32905,134,137, 147,144,147, 32916,145,148, 32908,137,140, 149,146,149, 32918,147,150, 32909,138,141, 
7, // chain 8
151,148,151, 152,149,152, 153,150,153, 
154,151,154, 32923,152,155, 32924,153,156, 32925,154,157, 32926,155,158, 32920,149,152, 
5, // chain 9
159,156,159, 160,157,160, 161,158,161, 
162,159,162, 32931,160,163, 32932,161,164, 32928,157,160, 
92, // chain 10
165,150,165, 166,155,166, 167,149,167, 
168,148,168, 32937,162,169, 170,163,170, 171,164,171, 32940,165,172, 173,151,173, 32942,166,174, 175,167,175, 32944,168,176, 177,169,177, 32946,170,178, 32947,171,179, 180,172,180, 32949,173,181, 182,174,182, 32951,175,183, 
184,176,184, 185,177,185, 186,178,186, 32955,179,187, 32956,160,188, 32957,161,189, 190,158,190, 32959,157,191, 192,156,192, 193,159,193, 32962,180,194, 32963,181,195, 196,182,196, 32965,183,197, 198,184,198, 199,185,199, 
32968,186,200, 201,187,201, 32970,188,202, 32971,189,203, 204,190,204, 32973,191,205, 206,192,206, 32975,193,207, 208,194,208, 32977,195,209, 210,196,210, 211,197,211, 32980,198,212, 32981,199,213, 214,200,214, 32983,201,215, 
216,202,216, 217,203,217, 32986,204,218, 219,205,219, 32988,206,220, 32989,207,221, 222,208,222, 32991,209,223, 224,210,224, 225,211,225, 32994,212,226, 227,213,227, 228,214,228, 32997,215,229, 230,216,230, 32999,217,231, 
33000,218,232, 233,219,233, 234,220,234, 33003,221,235, 33004,222,236, 237,223,237, 33006,224,238, 239,225,239, 33008,226,240, 33009,227,241, 242,228,242, 33011,229,243, 244,230,244, 33013,231,245, 33014,232,246, 247,233,247, 
33016,234,248, 249,235,249, 250,236,250, 32934,155,166, 251,154,251, 32933,150,165, 252,153,252, 33021,152,253, 32941,151,173, 32936,148,168, 171,164,171, 
36, // chain 11
254,237,254, 255,238,255, 256,239,256, 
257,240,257, 33026,241,258, 33027,242,259, 33028,243,260, 33023,238,255, 261,244,261, 33030,245,262, 33031,246,263, 33032,247,264, 33022,237,254, 265,248,265, 33034,249,266, 33035,250,267, 33025,240,257, 268,251,268, 33037,252,269, 
33038,253,270, 33026,241,258, 271,254,271, 33027,242,259, 272,255,272, 33041,256,273, 33028,243,260, 274,257,274, 33043,258,275, 33029,244,261, 276,259,276, 33045,260,277, 33030,245,262, 278,261,278, 33031,246,263, 279,262,279, 
33048,263,280, 33033,248,265, 33032,247,264, 
97, // chain 12
281,264,281, 282,265,282, 283,266,283, 
284,267,284, 33053,264,285, 33054,265,286, 33055,268,287, 33050,265,282, 288,269,288, 33057,270,289, 33058,271,290, 33049,264,281, 291,272,291, 33052,267,284, 292,273,292, 33061,274,293, 33062,273,294, 33063,272,295, 33053,264,285, 
296,271,296, 33054,265,286, 297,270,297, 33066,269,298, 33055,268,287, 299,275,299, 33068,276,300, 33069,275,301, 33056,269,288, 302,277,302, 33057,270,289, 303,278,303, 33072,279,304, 33058,271,290, 305,280,305, 33074,281,306, 
33059,272,291, 292,273,292, 307,282,307, 33061,274,293, 308,283,308, 33077,282,309, 33062,273,294, 310,281,310, 33063,272,295, 296,271,296, 311,280,311, 33080,279,312, 33065,270,297, 313,278,313, 33082,277,314, 33066,269,298, 
299,275,299, 315,284,315, 33068,276,300, 316,285,316, 33085,284,317, 33069,275,301, 302,277,302, 318,286,318, 33087,287,319, 33088,288,320, 33089,289,321, 33071,278,303, 322,290,322, 33091,291,323, 33092,292,324, 33093,293,325, 
33072,279,304, 305,280,305, 326,294,326, 33095,295,327, 33096,296,328, 33097,297,329, 33074,281,306, 330,298,330, 33075,282,307, 331,299,331, 33076,283,308, 309,282,309, 332,298,332, 33078,281,310, 333,297,333, 33079,280,311, 
334,296,334, 33103,295,335, 33104,294,336, 33105,293,337, 33080,279,312, 313,278,313, 338,292,338, 33107,291,339, 33108,290,340, 33109,289,341, 33082,277,314, 342,288,342, 33111,287,343, 33112,286,344, 33083,284,315, 316,285,316, 
18, // chain 13
345,300,345, 346,301,346, 347,302,347, 
348,303,348, 33117,304,349, 33118,305,350, 33119,306,351, 33120,307,352, 33121,308,353, 33114,301,346, 354,309,354, 33123,310,355, 33124,311,356, 33113,300,345, 348,303,348, 357,312,357, 358,313,358, 359,314,359, 33128,315,360, 
32886,316,118, 
7, // chain 14
361,317,361, 362,318,362, 363,319,363, 
364,320,364, 33133,321,365, 366,322,366, 33135,323,367, 368,324,368, 33137,325,369, 
51, // chain 15
370,326,370, 371,327,371, 372,328,372, 
373,329,373, 33142,330,374, 33143,331,375, 33144,332,376, 33139,327,371, 377,333,377, 33146,334,378, 33147,335,379, 33148,336,380, 33138,326,370, 381,337,381, 33150,338,382, 33141,329,373, 383,339,383, 33152,340,384, 33153,341,385, 
33142,330,374, 386,342,386, 33143,331,375, 387,343,387, 33156,344,388, 33144,332,376, 377,333,377, 389,345,389, 33158,346,390, 33146,334,378, 391,347,391, 33160,348,392, 33147,335,379, 393,349,393, 33162,350,394, 33163,351,395, 
33164,352,396, 33148,336,380, 381,337,381, 397,353,397, 33166,354,398, 33167,355,399, 33150,338,382, 400,356,400, 33151,339,383, 401,357,401, 33170,358,402, 33152,340,384, 403,359,403, 33153,341,385, 404,360,404, 33173,361,405, 
33174,362,406, 33154,342,386, 
41, // chain 16
407,363,407, 408,364,408, 409,365,409, 
410,366,410, 33179,367,411, 33180,368,412, 33181,369,413, 33176,364,408, 414,370,414, 33183,371,415, 33184,372,416, 33185,373,417, 33175,363,407, 410,366,410, 418,374,418, 416,372,416, 33187,375,419, 420,376,420, 33189,377,421, 
422,378,422, 33191,379,423, 424,380,424, 33159,381,391, 425,382,425, 33160,383,392, 426,384,426, 33161,385,393, 394,386,394, 427,387,427, 33196,388,428, 429,389,429, 430,390,430, 431,391,431, 33200,392,432, 433,393,433, 
33202,394,434, 435,395,435, 33169,357,401, 33204,396,436, 437,397,437, 400,356,400, 33166,354,398, 399,355,399, 
2, // chain 17
438,398,438, 439,399,439, 440,400,440, 
340,401,340, 
9, // chain 18
441,402,441, 442,403,442, 443,404,443, 
444,405,444, 33213,406,445, 33214,407,446, 33210,403,442, 447,408,447, 33216,409,448, 33217,410,449, 33209,402,441, 
28, // chain 19
450,411,450, 451,412,451, 452,413,452, 
453,414,453, 33222,415,454, 455,416,455, 456,417,456, 33225,418,457, 33226,419,458, 459,420,459, 33228,421,460, 461,422,461, 462,423,462, 463,424,463, 33232,425,464, 465,426,465, 33234,427,466, 467,428,467, 33236,429,468, 
469,430,469, 33238,431,470, 471,432,471, 33240,433,472, 473,434,473, 33242,435,474, 475,436,475, 33244,437,476, 477,438,477, 33246,439,478, 479,440,479, 
41, // chain 20
480,441,480, 481,442,481, 482,443,482, 
483,444,483, 33252,445,484, 33253,446,485, 33254,447,486, 33249,442,481, 487,448,487, 33256,449,488, 33257,448,489, 33258,447,490, 33259,443,491, 33248,441,480, 492,444,492, 33261,450,493, 33251,444,483, 494,451,494, 33263,452,495, 
33252,445,484, 496,453,496, 33265,454,497, 33253,446,485, 498,455,498, 33267,456,499, 33254,447,486, 500,457,500, 33255,448,487, 501,458,501, 33256,449,488, 502,459,502, 33271,458,503, 33257,448,489, 504,460,504, 33258,447,490, 
505,456,505, 33274,446,506, 33259,443,491, 507,445,507, 33260,444,492, 508,452,508, 33262,451,494, 33261,450,493, 
55, // chain 21
509,461,509, 510,462,510, 511,463,511, 
512,464,512, 33268,457,500, 33281,465,513, 33282,466,514, 33278,462,510, 515,467,515, 33284,468,516, 33285,469,517, 33277,461,509, 518,470,518, 33287,471,519, 33288,472,520, 33280,464,512, 521,473,521, 33290,474,522, 33268,457,500, 
501,458,501, 523,475,523, 33292,476,524, 33293,477,525, 33270,459,502, 503,458,503, 526,476,526, 33295,475,527, 33296,474,528, 33272,460,504, 529,464,529, 33298,463,530, 33299,478,531, 33273,456,505, 532,455,532, 33274,446,506, 
533,454,533, 33275,445,507, 534,453,534, 33276,452,508, 535,479,535, 33304,480,536, 33262,451,494, 537,481,537, 33306,480,538, 33263,452,495, 539,479,539, 33264,453,496, 540,482,540, 33309,483,541, 33265,454,497, 542,484,542, 
33266,455,498, 543,485,543, 33282,466,514, 33281,465,513, 33267,456,499, 500,457,500, 
54, // chain 22
544,486,544, 545,487,545, 546,488,546, 
547,489,547, 33316,490,548, 33317,491,549, 33313,487,545, 550,492,550, 33319,493,551, 33320,494,552, 33321,495,553, 33312,486,544, 554,262,554, 33323,263,555, 33324,496,556, 33315,489,547, 557,497,557, 33326,498,558, 33327,499,559, 
33328,500,560, 33316,490,548, 561,501,561, 33330,502,562, 33317,491,549, 430,503,430, 33318,492,550, 432,504,432, 33331,505,563, 33319,493,551, 564,506,564, 33333,507,565, 33320,494,552, 566,259,566, 33335,260,567, 33321,495,553, 
568,261,568, 33322,262,554, 569,246,569, 33323,263,555, 570,248,570, 33324,496,556, 571,508,571, 33325,497,557, 572,509,572, 33341,510,573, 33326,498,558, 574,511,574, 33343,512,575, 33327,499,559, 576,513,576, 33328,500,560, 
561,501,561, 577,514,577, 33197,515,429, 33330,502,562, 430,503,430, 
42, // chain 23
578,516,578, 579,517,579, 580,518,580, 
581,519,581, 33350,520,582, 33351,521,583, 33352,522,584, 33347,517,579, 585,523,585, 33354,524,586, 33355,525,587, 33356,526,588, 33346,516,578, 589,527,589, 33349,519,581, 590,528,590, 33359,529,591, 33360,530,592, 33350,520,582, 
593,531,593, 33362,532,594, 33351,521,583, 595,533,595, 33364,534,596, 33365,535,597, 33352,522,584, 585,523,585, 598,536,598, 33367,537,599, 33368,538,600, 33354,524,586, 601,539,601, 33370,540,602, 33355,525,587, 603,541,603, 
33372,542,604, 33356,526,588, 605,543,605, 33357,527,589, 606,544,606, 33358,528,590, 607,545,607, 33376,546,608, 33359,529,591, 
43, // chain 24
609,547,609, 610,548,610, 611,549,611, 
612,550,612, 33381,551,613, 33382,552,614, 33378,548,610, 615,553,615, 33384,554,616, 33385,555,617, 33386,556,618, 33377,547,609, 619,557,619, 33388,558,620, 33380,550,612, 621,559,621, 33390,560,622, 33381,551,613, 623,561,623, 
33392,562,624, 33382,552,614, 625,563,625, 33383,553,615, 626,564,626, 33395,565,627, 33384,554,616, 628,566,628, 33397,567,629, 33398,568,630, 33399,569,631, 33400,570,632, 33385,555,617, 633,571,633, 33386,556,618, 634,572,634, 
33387,557,619, 635,573,635, 33404,574,636, 33388,558,620, 637,575,637, 33406,576,638, 33389,559,621, 639,577,639, 33408,578,640, 33390,560,622, 
11, // chain 25
641,579,641, 642,580,642, 643,581,643, 
644,582,644, 33413,583,645, 33410,580,642, 646,584,646, 647,585,647, 648,586,648, 649,587,649, 33418,588,650, 33419,589,651, 33415,590,647, 
49, // chain 26
652,591,652, 653,592,653, 654,593,654, 
655,594,655, 33424,595,656, 33425,596,657, 33426,597,658, 33427,598,659, 33421,592,653, 660,599,660, 33429,600,661, 33420,591,652, 662,601,662, 33431,602,663, 33432,603,664, 33433,604,665, 33423,594,655, 666,605,666, 33424,595,656, 
667,606,667, 33425,596,657, 668,607,668, 33437,608,669, 33438,609,670, 33426,597,658, 671,610,671, 33427,598,659, 672,611,672, 33428,599,660, 673,612,673, 33442,613,674, 33443,614,675, 33429,600,661, 649,587,649, 33444,615,676, 
33430,601,662, 677,616,677, 33446,617,678, 33431,602,663, 679,618,679, 33448,619,680, 33449,620,681, 33432,603,664, 665,604,665, 682,621,682, 33434,605,666, 683,622,683, 33452,623,684, 33435,606,667, 685,624,685, 33436,607,668, 
10, // chain 27
686,625,686, 687,626,687, 688,627,688, 
689,628,689, 33458,629,690, 33459,630,691, 33460,631,692, 33461,632,693, 33455,626,687, 694,633,694, 33463,634,695, 33454,625,686, 
7, // chain 28
99,99,99, 100,100,100, 696,635,696, 
697,636,697, 33466,637,698, 33467,638,699, 33468,639,700, 32869,101,101, 32868,100,100, 
39, // chain 29
95,95,95, 96,96,96, 701,640,701, 
33470,641,702, 33471,642,703, 32865,97,97, 704,643,704, 33473,644,705, 32866,98,98, 706,645,706, 32867,99,99, 697,636,697, 707,646,707, 33476,647,708, 33477,648,709, 33466,637,698, 710,649,710, 33479,650,711, 33467,638,699, 
712,651,712, 33481,652,713, 33468,639,700, 714,653,714, 33483,654,715, 33484,655,716, 32869,101,101, 717,656,717, 32870,102,102, 718,657,718, 32871,103,103, 719,658,719, 33488,659,720, 32872,104,104, 105,105,105, 721,660,721, 
719,658,719, 32805,661,37, 718,657,718, 32797,662,29, 722,663,722, 33491,664,723, 
44, // chain 30
95,95,95, 701,640,701, 724,665,724, 
94,94,94, 33493,666,725, 33494,667,726, 33495,668,727, 33469,640,701, 702,641,702, 728,669,728, 33471,642,703, 729,670,729, 33472,643,704, 730,671,730, 33499,672,731, 33473,644,705, 706,645,706, 732,673,732, 33501,674,733, 
33475,646,707, 708,647,708, 734,675,734, 33503,676,735, 33477,648,709, 736,677,736, 33478,649,710, 737,678,737, 33506,679,738, 33479,650,711, 712,651,712, 739,680,739, 33481,652,713, 714,653,714, 740,681,740, 33509,682,741, 
33483,654,715, 742,683,742, 33511,684,743, 33512,685,744, 33484,655,716, 745,686,745, 33514,687,746, 33515,688,747, 33485,656,717, 718,657,718, 722,663,722, 
2, // chain 31
748,689,748, 749,690,749, 750,691,750, 
751,692,751, 
22, // chain 32
748,689,748, 752,693,752, 749,690,749, 
33521,694,753, 754,695,754, 33523,696,755, 756,697,756, 33525,698,757, 758,699,758, 759,700,759, 33528,701,760, 32898,702,130, 131,699,131, 761,700,761, 33530,697,762, 32900,698,132, 763,696,763, 764,695,764, 33533,694,765, 
766,690,766, 33535,693,767, 768,689,768, 769,691,769, 33538,692,770, 
9, // chain 33
771,703,771, 772,704,772, 773,705,773, 
774,706,774, 33543,707,775, 776,708,776, 33545,709,777, 778,710,778, 33547,711,779, 780,712,780, 33549,713,781, 
1, // chain 34
0,0,0, 2,2,2, 27,27,27, 
4, // chain 35
782,714,782, 783,715,783, 784,716,784, 
33553,717,785, 33554,718,786, 787,719,787, 
19, // chain 36
788,720,788, 627,412,627, 789,721,789, 
33558,722,790, 33559,413,791, 33396,411,628, 792,414,792, 33561,723,793, 33397,724,629, 794,725,794, 33563,726,795, 796,727,796, 33565,728,797, 798,729,798, 33567,730,799, 800,731,800, 33569,732,801, 802,733,802, 33571,734,803, 
804,735,804, 33573,736,805, 
8, // chain 37
789,721,789, 806,737,806, 788,720,788, 
33575,738,807, 33576,739,808, 809,740,809, 33578,741,810, 811,742,811, 33580,743,812, 33581,744,813, 
38, // chain 38
814,745,814, 815,746,815, 816,747,816, 
817,748,817, 33586,749,818, 33587,748,819, 33588,745,820, 33583,746,815, 821,750,821, 822,751,822, 33591,752,823, 824,753,824, 33593,754,825, 826,755,826, 745,756,745, 827,757,827, 33596,758,828, 33514,759,746, 829,760,829, 
33515,761,747, 830,762,830, 33490,763,722, 723,764,723, 831,765,831, 33600,762,832, 32796,763,28, 31,761,31, 833,760,833, 33602,759,834, 835,758,835, 33604,756,836, 837,757,837, 33606,753,838, 33607,755,839, 840,754,840, 
841,752,841, 842,751,842, 33611,750,843, 814,745,814, 33583,746,815, 
26, // chain 39
844,440,844, 845,439,845, 846,438,846, 
33615,437,847, 848,436,848, 33617,435,849, 850,434,850, 33619,433,851, 852,432,852, 33621,431,853, 854,430,854, 33623,429,855, 856,428,856, 33625,427,857, 858,426,858, 33627,425,859, 860,424,860, 33629,423,861, 862,420,862, 
33631,422,863, 864,421,864, 640,419,640, 865,418,865, 33390,416,622, 866,417,866, 33560,414,792, 33391,415,623, 791,413,791, 
31, // chain 40
867,766,867, 868,767,868, 869,768,869, 
870,769,870, 33639,770,871, 33640,771,872, 33636,767,868, 873,772,873, 33642,773,874, 33643,774,875, 33644,775,876, 33645,776,877, 33635,766,867, 870,769,870, 878,777,878, 33647,778,879, 33639,770,871, 880,779,880, 33649,780,881, 
33640,771,872, 882,781,882, 33651,782,883, 33641,772,873, 884,783,884, 33642,773,874, 885,784,885, 33643,774,875, 886,785,886, 33644,775,876, 887,786,887, 33656,787,888, 33646,777,878, 33645,776,877, 
20, // chain 41
889,788,889, 759,789,759, 760,790,760, 
761,789,761, 890,791,890, 33530,792,762, 891,793,891, 33532,794,764, 892,795,892, 33534,796,766, 827,757,827, 33537,797,769, 824,753,824, 33590,751,822, 33538,798,770, 819,748,819, 33661,799,893, 33662,800,894, 33663,710,895, 
33664,801,896, 368,712,368, 33665,802,897, 
16, // chain 42
837,757,837, 750,797,750, 749,796,749, 
898,795,898, 33522,794,754, 899,793,899, 33524,792,756, 900,791,900, 33527,789,759, 889,788,889, 831,765,831, 33658,791,890, 830,762,830, 33659,793,891, 829,760,829, 33660,795,892, 828,758,828, 33595,757,827, 
87, // chain 43
880,779,880, 881,780,881, 901,803,901, 
33670,804,902, 33671,805,903, 33650,781,882, 904,806,904, 33651,782,883, 905,807,905, 33652,783,884, 906,808,906, 33653,784,885, 907,809,907, 33676,810,908, 33654,785,886, 887,786,887, 909,811,909, 33678,812,910, 33656,787,888, 
911,813,911, 33646,777,878, 912,814,912, 33647,778,879, 913,815,913, 33682,816,914, 33648,779,880, 915,817,915, 33669,803,901, 916,818,916, 33670,804,902, 917,819,917, 33686,820,918, 33687,821,919, 33671,805,903, 920,822,920, 
33672,806,904, 921,823,921, 33690,824,922, 33673,807,905, 923,825,923, 33674,808,906, 924,826,924, 33675,809,907, 925,827,925, 33676,810,908, 909,811,909, 926,828,926, 33502,675,734, 33695,829,927, 33678,812,910, 911,813,911, 
928,830,928, 33697,831,929, 33680,814,912, 913,815,913, 930,832,930, 33699,833,931, 33682,816,914, 932,834,932, 33683,817,915, 933,835,933, 33684,818,916, 934,836,934, 33703,837,935, 33685,819,917, 936,838,936, 33686,820,918, 
937,839,937, 33706,840,938, 33707,841,939, 33687,821,919, 920,822,920, 940,842,940, 33689,823,921, 941,843,941, 33710,844,942, 33711,845,943, 33690,824,922, 923,825,923, 944,846,944, 33713,847,945, 33692,826,924, 946,848,946, 
33693,827,925, 947,849,947, 33716,850,948, 33694,828,926, 735,676,735, 33502,675,734, 
7, // chain 44
949,851,949, 933,835,933, 950,852,950, 
951,853,951, 33720,854,952, 33721,855,953, 33722,856,954, 33702,836,934, 33701,835,933, 
62, // chain 45
932,834,932, 933,835,933, 949,851,949, 
955,857,955, 33724,858,956, 33719,853,951, 957,859,957, 33726,860,958, 33727,861,959, 33720,854,952, 960,862,960, 33729,863,961, 33721,855,953, 962,864,962, 33731,865,963, 33732,866,964, 33722,856,954, 934,836,934, 965,867,965, 
33703,837,935, 966,868,966, 33704,838,936, 967,869,967, 33736,870,968, 33737,871,969, 33705,839,937, 970,872,970, 33739,873,971, 33706,840,938, 972,874,972, 33707,841,939, 940,842,940, 941,843,941, 973,875,973, 33742,876,974, 
33743,877,975, 33710,844,942, 976,878,976, 33745,879,977, 33711,845,943, 978,880,978, 33712,846,944, 979,881,979, 33748,882,980, 33749,883,981, 33713,847,945, 982,884,982, 33714,848,946, 947,849,947, 983,885,983, 33752,886,984, 
33753,887,985, 33716,850,948, 986,888,986, 33503,676,735, 987,889,987, 33504,677,736, 988,890,988, 33757,891,989, 33758,892,990, 33505,678,737, 740,681,740, 33507,680,739, 33506,679,738, 
16, // chain 46
991,893,991, 966,868,966, 967,869,967, 
992,894,992, 33761,895,993, 33736,870,968, 994,896,994, 33763,897,995, 33737,871,969, 996,898,996, 33738,872,970, 997,899,997, 33766,900,998, 33739,873,971, 999,901,999, 33742,876,974, 33741,875,973, 33740,874,972, 
69, // chain 47
966,868,966, 991,893,991, 1000,902,1000, 
965,867,965, 33769,903,1001, 33770,904,1002, 33759,893,991, 1003,905,1003, 33772,906,1004, 33760,894,992, 1005,907,1005, 33774,908,1006, 33761,895,993, 1007,909,1007, 33762,896,994, 1008,910,1008, 33777,911,1009, 33763,897,995, 1010,912,1010, 
33779,913,1011, 33764,898,996, 997,899,997, 1012,914,1012, 33781,915,1013, 33766,900,998, 999,901,999, 974,876,974, 975,877,975, 976,878,976, 977,879,977, 1014,916,1014, 33746,880,978, 979,881,979, 7,7,7, 33748,882,980, 
5,5,5, 32771,3,3, 33749,883,981, 1015,917,1015, 33750,884,982, 1016,918,1016, 33785,919,1017, 33751,885,983, 1018,920,1018, 33787,921,1019, 33752,886,984, 1020,922,1020, 33789,923,1021, 33753,887,985, 1022,924,1022, 33754,888,986, 
987,889,987, 1023,925,1023, 33756,890,988, 1021,923,1021, 33792,926,1024, 33757,891,989, 1025,927,1025, 33794,928,1026, 33758,892,990, 740,681,740, 741,682,741, 1027,929,1027, 33510,683,742, 1028,930,1028, 33511,684,743, 826,931,826, 
33797,932,1029, 33512,685,744, 745,686,745, 826,931,826, 
7, // chain 48
965,867,965, 1001,903,1001, 1030,933,1030, 
964,866,964, 33731,865,963, 33799,934,1031, 33800,935,1032, 33770,904,1002, 33769,903,1001, 
30, // chain 49
1032,935,1032, 1002,904,1002, 1033,936,1033, 
33771,905,1003, 1004,906,1004, 1005,907,1005, 1034,937,1034, 33774,908,1006, 1035,938,1035, 33775,909,1007, 1036,939,1036, 33776,910,1008, 1037,940,1037, 33806,941,1038, 33807,942,1039, 33777,911,1009, 1040,943,1040, 33809,944,1041, 33778,912,1010, 
1042,945,1042, 32808,40,40, 33811,946,1043, 33779,913,1011, 39,39,39, 33780,914,1012, 14,14,14, 32781,13,13, 33812,947,1044, 33781,915,1013, 1014,916,1014, 9,9,9, 32775,7,7, 
25, // chain 50
1032,935,1032, 1033,936,1033, 1045,948,1045, 
1031,934,1031, 33814,949,1046, 33815,950,1047, 33801,936,1033, 1048,951,1048, 33817,952,1049, 33802,937,1034, 1035,938,1035, 1050,953,1050, 33804,939,1036, 1051,954,1051, 33820,955,1052, 33805,940,1037, 1053,956,1053, 33806,941,1038, 1054,957,1054, 
33823,958,1055, 33807,942,1039, 1040,943,1040, 1056,959,1056, 33825,960,1057, 33826,961,1058, 33810,945,1042, 33809,944,1041, 
30, // chain 51
1047,950,1047, 1048,951,1048, 1046,949,1046, 
33827,962,1059, 33817,952,1049, 1050,953,1050, 1060,963,1060, 33819,954,1051, 1061,964,1061, 33820,955,1052, 1062,965,1062, 33831,966,1063, 33821,956,1053, 1064,967,1064, 33822,957,1054, 1065,968,1065, 33823,958,1055, 1056,959,1056, 1066,969,1066, 
33835,970,1067, 33836,971,1068, 33825,960,1057, 1069,972,1069, 33838,973,1070, 33839,974,1071, 33826,961,1058, 1072,975,1072, 33810,945,1042, 1073,976,1073, 33842,977,1074, 32809,41,41, 32808,40,40, 
34, // chain 52
1075,978,1075, 1076,979,1076, 1067,970,1067, 
1077,980,1077, 33836,971,1068, 839,981,839, 33837,972,1069, 840,982,840, 33838,973,1070, 841,983,841, 33846,984,1078, 33839,974,1071, 1072,975,1072, 1079,985,1079, 33848,986,1080, 33841,976,1073, 1081,987,1081, 33842,977,1074, 1082,988,1082, 
33851,989,1083, 32809,41,41, 42,42,42, 1084,990,1084, 32813,45,45, 47,47,47, 1085,991,1085, 32791,23,23, 1086,992,1086, 32792,24,24, 1087,993,1087, 32793,25,25, 1088,994,1088, 32794,26,26, 1016,918,1016, 32771,3,3, 
32770,2,2, 
14, // chain 53
1067,970,1067, 1076,979,1076, 1089,995,1089, 
1066,969,1066, 33858,996,1090, 33859,997,1091, 33860,998,1092, 33844,979,1076, 1093,999,1093, 33862,1000,1094, 32800,32,32, 33863,1001,1095, 33843,978,1075, 836,1002,836, 33607,981,839, 33845,980,1077, 
7, // chain 54
1066,969,1066, 1090,996,1090, 1064,967,1064, 
33864,1003,1096, 33859,997,1091, 1097,1004,1097, 33866,1005,1098, 33861,999,1093, 33860,998,1092, 
11, // chain 55
1064,967,1064, 1096,1003,1096, 1099,1006,1099, 
33868,1007,1100, 33865,1004,1097, 1101,1008,1101, 33870,1009,1102, 33866,1005,1098, 34,34,34, 32801,33,33, 33861,999,1093, 1094,1000,1094, 32,32,32, 
19, // chain 56
1063,966,1063, 1064,967,1064, 1099,1006,1099, 
1103,1010,1103, 33872,1011,1104, 33868,1007,1100, 1105,1012,1105, 33874,1013,1106, 33869,1008,1101, 1107,1014,1107, 33876,1015,1108, 33870,1009,1102, 1109,1016,1109, 32802,34,34, 35,35,35, 1110,1017,1110, 33879,1018,1111, 33880,1019,1112, 32804,36,36, 
721,1020,721, 32805,37,37, 
3, // chain 57
31,31,31, 32,32,32, 834,1021,834, 
33863,1001,1095, 836,1002,836, 
2, // chain 58
105,1022,105, 1111,1018,1111, 1112,1019,1112, 
721,1020,721, 
1, // chain 59
29,29,29, 28,28,28, 723,1023,723, 
5, // chain 60
1110,1017,1110, 1111,1018,1111, 1113,1024,1113, 
1114,1025,1114, 32857,1026,89, 32873,1022,105, 33879,1018,1111, 
7, // chain 61
1108,1015,1108, 1109,1016,1109, 1115,1027,1115, 
33884,1028,1116, 33878,1017,1110, 1114,1025,1114, 1117,1029,1117, 32858,1030,90, 32857,1026,89, 
4, // chain 62
1118,1031,1118, 1107,1014,1107, 1108,1015,1108, 
1115,1027,1115, 1117,1029,1117, 33884,1028,1116, 
19, // chain 63
1117,1029,1117, 90,1030,90, 1119,1032,1119, 
32859,1033,91, 92,1034,92, 1120,1035,1120, 32861,1036,93, 1121,1037,1121, 33493,1038,725, 1122,1039,1122, 33891,1040,1123, 33892,1041,1124, 1125,1042,1125, 33894,1043,1126, 1127,1044,1127, 33896,1045,1128, 33897,1046,1129, 33898,1047,1130, 33892,1048,1124, 
726,667,726, 33493,666,725, 
36, // chain 64
1118,1031,1118, 1117,1029,1117, 1119,1032,1119, 
1131,1049,1131, 33888,1035,1120, 1121,1037,1121, 1132,1050,1132, 33890,1039,1122, 1133,1051,1133, 33902,1052,1134, 33891,1040,1123, 1135,1053,1135, 33893,1042,1125, 1136,1054,1136, 33895,1044,1127, 957,859,957, 33896,1045,1128, 956,858,956, 33905,1055,1137, 
33897,1046,1129, 1138,1056,1138, 33898,1047,1130, 1139,1057,1139, 33494,667,726, 727,668,727, 728,669,728, 1140,1058,1140, 33497,670,729, 1141,1059,1141, 33910,1060,1142, 33498,671,730, 1143,1061,1143, 33499,672,731, 732,673,732, 928,830,928, 
33695,829,927, 33501,674,733, 734,675,734, 
5, // chain 65
1118,1031,1118, 1131,1049,1131, 1144,1062,1144, 
1107,1014,1107, 33913,1063,1145, 33900,1050,1132, 33899,1049,1131, 
10, // chain 66
1132,1050,1132, 1133,1051,1133, 1145,1063,1145, 
33914,1064,1146, 33915,1065,1147, 33902,1052,1134, 1148,1066,1148, 33903,1053,1135, 1149,1067,1149, 33904,1054,1136, 958,860,958, 33725,859,957, 
18, // chain 67
1150,1068,1150, 1147,1065,1147, 1148,1066,1148, 
1151,1069,1151, 33917,1067,1149, 1152,1070,1152, 33921,1071,1153, 33726,860,958, 959,861,959, 1154,1072,1154, 33728,862,960, 1155,1073,1155, 33729,863,961, 1061,964,1061, 33730,864,962, 1060,963,1060, 33827,962,1059, 33814,949,1046, 33731,865,963, 
1031,934,1031, 
11, // chain 68
1150,1068,1150, 1151,1069,1151, 1104,1011,1104, 
1105,1012,1105, 1156,1074,1156, 33925,1075,1157, 33874,1013,1106, 1107,1014,1107, 1145,1063,1145, 1146,1064,1146, 1156,1074,1156, 33915,1065,1147, 1150,1068,1150, 
10, // chain 69
1139,1057,1139, 1140,1058,1140, 1138,1056,1138, 
33926,1076,1158, 33909,1059,1141, 930,832,930, 33927,1077,1159, 33910,1060,1142, 1143,1061,1143, 928,830,928, 929,831,929, 930,832,930, 
5, // chain 70
1137,1055,1137, 1138,1056,1138, 1158,1076,1158, 
956,858,956, 33723,857,955, 33699,833,931, 33698,832,930, 
2, // chain 71
1044,947,1044, 9,9,9, 10,10,10, 
13,13,13, 
1, // chain 72
3,3,3, 1015,917,1015, 1016,918,1016, 
13, // chain 73
1160,1078,1160, 1161,1079,1161, 1018,920,1018, 
1162,1080,1162, 33787,921,1019, 1163,1081,1163, 33788,922,1020, 825,1082,825, 33594,931,826, 33796,930,1028, 33789,923,1021, 1024,926,1024, 1025,927,1025, 1027,929,1027, 33794,928,1026, 
11, // chain 74
1017,919,1017, 1018,920,1018, 1161,1079,1161, 
1164,1083,1164, 33933,1084,1165, 33934,1085,1166, 33928,1078,1160, 1167,1086,1167, 33589,1087,821, 33930,1080,1162, 823,1088,823, 33931,1081,1163, 825,1082,825, 
12, // chain 75
1016,918,1016, 1017,919,1017, 1164,1083,1164, 
1088,994,1088, 33936,1089,1168, 33933,1084,1165, 1169,1090,1169, 33938,1091,1170, 33934,1085,1166, 1171,1092,1171, 33940,1093,1172, 33935,1086,1167, 815,1094,815, 33589,1087,821, 
14, // chain 76
1171,1092,1171, 1173,1095,1173, 1170,1091,1170, 
33937,1090,1169, 33942,1096,1174, 33943,1097,1175, 33944,1098,1176, 33939,1099,1171, 1177,1100,1177, 33940,1101,1172, 1178,1102,1178, 33583,1103,815, 843,1104,843, 1079,985,1079, 33846,984,1078, 33609,983,841, 
11, // chain 77
1179,1105,1179, 1169,1090,1169, 1174,1096,1174, 
1180,1106,1180, 33949,1107,1181, 33943,1097,1175, 1182,1108,1182, 33951,1109,1183, 33944,1098,1176, 1177,1100,1177, 1080,986,1080, 33847,985,1079, 33946,1102,1178, 
11, // chain 78
1168,1089,1168, 1169,1090,1169, 1179,1105,1179, 
1087,993,1087, 33948,1106,1180, 1184,1110,1184, 33953,1111,1185, 33949,1107,1181, 1182,1108,1182, 1082,988,1082, 33849,987,1081, 33848,986,1080, 33951,1109,1183, 
1, // chain 79
1088,994,1088, 1168,1089,1168, 1087,993,1087, 
5, // chain 80
1086,992,1086, 1184,1110,1184, 1185,1111,1185, 
1085,991,1085, 33850,988,1082, 1084,990,1084, 33851,989,1083, 
1, // chain 81
1184,1110,1184, 1086,992,1086, 1087,993,1087, 
2, // chain 82
1043,946,1043, 39,39,39, 38,38,38, 
40,40,40, 
24, // chain 83
1186,1112,1186, 1187,1113,1187, 1188,1114,1188, 
1189,1115,1189, 33958,1116,1190, 33959,1117,1191, 33960,1118,1192, 33961,1119,1193, 33962,1120,1194, 33955,1113,1187, 1195,1121,1195, 33954,1112,1186, 1196,1122,1196, 33965,1123,1197, 33957,1115,1189, 1190,1116,1190, 1198,1124,1198, 33959,1117,1191, 1199,1125,1199, 
33968,1126,1200, 33960,1118,1192, 1201,1127,1201, 33961,1119,1193, 1194,1120,1194, 1202,1128,1202, 33963,1121,1195, 
2, // chain 84
1201,1127,1201, 1202,1128,1202, 1203,1129,1203, 
1200,1126,1200, 
10, // chain 85
1204,130,1204, 1205,129,1205, 755,1130,755, 
753,1131,753, 752,1132,752, 1206,1133,1206, 1207,131,1207, 33976,1134,1208, 33520,1135,752, 748,1136,748, 1209,1137,1209, 33519,1138,751, 
4, // chain 86
784,1139,784, 1207,131,1207, 1208,1134,1208, 
1209,1137,1209, 1210,1140,1210, 782,1141,782, 
9, // chain 87
852,1142,852, 1211,1143,1211, 1212,1144,1212, 
33981,1145,1213, 1214,1146,1214, 33983,1147,1215, 33984,1148,1216, 1217,1149,1217, 33986,1150,1218, 33987,1151,1219, 33988,1152,1220, 
22, // chain 88
1221,1153,1221, 1212,1144,1212, 1214,1146,1214, 
1222,1154,1222, 33991,1155,1223, 33992,1156,1224, 33983,1147,1215, 1217,1149,1217, 1225,1157,1225, 33994,1158,1226, 33986,1150,1218, 1227,1159,1227, 1228,1160,1228, 33997,1161,1229, 796,1162,796, 1230,1163,1230, 1231,1164,1231, 34000,1165,1232, 1233,1166,1233, 
34002,1167,1234, 33565,1168,797, 795,1169,795, 630,568,630, 33397,567,629, 
23, // chain 89
1235,1170,1235, 1236,1171,1236, 1237,1172,1237, 
1238,1173,1238, 34007,1174,1239, 34008,1175,1240, 34009,1176,1241, 34004,1171,1236, 1242,1177,1242, 1243,1178,1243, 1244,1179,1244, 34013,1180,1245, 1246,1181,1246, 34015,1182,1247, 34016,1183,1248, 1249,1184,1249, 1250,1185,1250, 34019,1186,1251, 68,1187,68, 
67,1188,67, 1252,1189,1252, 34021,1190,1253, 1239,1174,1239, 34022,1191,1254, 1238,1173,1238, 
8, // chain 90
1240,1175,1240, 1241,1176,1241, 1244,1179,1244, 
1246,1181,1246, 1255,1192,1255, 34015,1182,1247, 1250,1185,1250, 1252,1189,1252, 1240,1175,1240, 34007,1174,1239, 
6, // chain 91
444,1193,444, 1256,1194,1256, 1257,1195,1257, 
1258,1196,1258, 441,1197,441, 34027,1198,1259, 320,288,320, 33087,287,319, 
20, // chain 92
1260,1199,1260, 1261,1200,1261, 1262,1201,1262, 
694,633,694, 34031,1202,1263, 693,632,693, 34032,1203,1264, 34033,1204,1265, 1266,1205,1266, 34035,1206,1267, 1268,1207,1268, 1269,1208,1269, 34038,1209,1270, 34039,1210,1271, 1261,1211,1261, 1260,1212,1260, 1272,1213,1272, 33463,1214,695, 1273,1215,1273, 
34042,1216,1274, 32888,1217,120, 33454,1218,686, 
1, // chain 93
1066,969,1066, 1064,967,1064, 1065,968,1065, 
6, // chain 94
674,613,674, 675,614,675, 1275,1219,1275, 
34044,1220,1276, 33417,587,649, 650,588,650, 1275,1221,1275, 33419,589,651, 
3, // chain 95
672,611,672, 673,612,673, 1277,1222,1277, 
671,610,671, 34046,1223,1278, 
1, // chain 96
93,93,93, 94,94,94, 725,666,725, 
1, // chain 97
932,834,932, 955,857,955, 931,833,931, 
6, // chain 98
1279,707,1279, 596,705,596, 1280,706,1280, 
1281,708,1281, 34050,1224,1282, 33539,703,771, 33364,705,596, 772,704,772, 
10, // chain 99
818,749,818, 819,748,819, 893,799,893, 
1283,1225,1283, 34050,1224,1282, 33662,800,894, 1281,708,1281, 33663,710,895, 1284,1226,1284, 34053,1227,1285, 33136,712,368, 369,1228,369, 
3, // chain 100
1154,1072,1154, 1155,1073,1155, 1286,1229,1286, 
33830,965,1062, 33829,964,1061, 
3, // chain 101
213,1230,213, 210,1231,210, 215,1232,215, 
34055,1233,1287, 34056,1234,1288, 
6, // chain 102
221,1235,221, 218,1236,218, 1289,1237,1289, 
32984,1238,216, 1290,1239,1290, 32983,1232,215, 461,1240,461, 34055,1233,1287, 
5, // chain 103
1152,1070,1152, 1153,1071,1153, 1154,1072,1154, 
1286,1229,1286, 1103,1010,1103, 33830,965,1062, 1063,966,1063, 
6, // chain 104
1291,1241,1291, 1289,1237,1289, 1292,1242,1292, 
1293,1243,1293, 33228,1244,460, 33229,1240,461, 34058,1239,1290, 34057,1237,1289, 
12, // chain 105
1291,1241,1291, 1293,1243,1293, 1294,1245,1294, 
1295,1246,1295, 34064,1247,1296, 34065,1248,1297, 34061,1243,1293, 1298,1249,1298, 33228,1244,460, 1299,1250,1299, 1300,1251,1300, 170,1252,170, 32940,1253,172, 32942,1254,174, 
12, // chain 106
1301,1255,1301, 1291,1241,1291, 1295,1246,1295, 
1302,1256,1302, 34071,1257,1303, 34064,1247,1296, 1304,1258,1304, 34073,1259,1305, 34074,1260,1306, 34065,1248,1297, 249,1261,249, 32937,1262,169, 34066,1249,1298, 170,1252,170, 
7, // chain 107
223,1263,223, 1289,1237,1289, 1301,1255,1301, 
224,1264,224, 34070,1256,1302, 1307,1265,1307, 34071,1257,1303, 1308,1266,1308, 34072,1258,1304, 
2, // chain 108
1104,1011,1104, 1151,1069,1151, 1103,1010,1103, 
33920,1070,1152, 
2, // chain 109
166,1267,166, 249,1261,249, 169,1262,169, 
167,1268,167, 
5, // chain 110
136,132,136, 1236,1139,1236, 135,131,135, 
34077,1134,1309, 33664,1137,896, 33665,1140,897, 34078,1141,1310, 
11, // chain 111
763,1130,763, 132,128,132, 133,129,133, 
134,130,134, 765,1131,765, 33535,1132,767, 34079,1133,1311, 32903,131,135, 1309,1134,1309, 767,1135,767, 33536,1136,768, 33664,1137,896, 770,1138,770, 
22, // chain 112
1312,1269,1312, 1313,1270,1313, 1314,1271,1314, 
1315,1272,1315, 34084,1273,1316, 34085,1274,1317, 34086,1275,1318, 34081,1270,1313, 1319,1276,1319, 34088,1277,1320, 34089,1278,1321, 34080,1269,1312, 1322,1279,1322, 34083,1272,1315, 1323,1280,1323, 33625,1281,857, 34084,1273,1316, 859,1282,859, 34092,1283,1324, 
34085,1274,1317, 1325,1284,1325, 1326,1285,1326, 861,1286,861, 33631,1287,863, 
5, // chain 113
1323,1280,1323, 857,1281,857, 855,1288,855, 
1223,1155,1223, 33990,1154,1222, 33621,1289,853, 1221,1153,1221, 
9, // chain 114
1320,1277,1320, 1321,1278,1321, 1327,1290,1327, 
1328,1291,1328, 34097,1292,1329, 34098,1293,1330, 34099,1294,1331, 34089,1278,1321, 1322,1279,1322, 1223,1155,1223, 34091,1280,1323, 
6, // chain 115
1330,1293,1330, 1331,1294,1331, 1224,1156,1224, 
1225,1157,1225, 1332,1295,1332, 34101,1296,1333, 33996,1160,1228, 33994,1158,1226, 
6, // chain 116
1334,1297,1334, 631,569,631, 632,570,632, 
1335,1298,1335, 33401,571,633, 1336,1299,1336, 33403,573,635, 33402,572,634, 
8, // chain 117
1329,1292,1329, 1337,1300,1337, 1334,1297,1334, 
1328,1291,1328, 34103,1298,1335, 1338,1301,1338, 34107,1302,1339, 34104,1299,1336, 636,574,636, 33403,573,635, 
2, // chain 118
1337,1300,1337, 1329,1292,1329, 1332,1295,1332, 
34098,1293,1330, 
3, // chain 119
1332,1295,1332, 1333,1296,1333, 1340,1303,1340, 
33999,1164,1231, 33996,1160,1228, 
4, // chain 120
1337,1300,1337, 1332,1295,1332, 1340,1303,1340, 
631,569,631, 34001,1166,1233, 33999,1164,1231, 
2, // chain 121
631,569,631, 1233,1166,1233, 1234,1167,1234, 
630,568,630, 
22, // chain 122
626,564,626, 627,565,627, 788,1304,788, 
1341,1305,1341, 33575,1306,807, 1342,1307,1342, 33577,1308,809, 811,1309,811, 1343,1310,1343, 33580,1311,812, 813,1312,813, 1344,1313,1344, 33578,1314,810, 1345,1315,1345, 33576,1316,808, 806,1317,806, 1346,1318,1346, 34115,1319,1347, 33557,1320,789, 
790,1321,790, 625,563,625, 33392,562,624, 33559,1322,791, 623,561,623, 
5, // chain 123
1346,1318,1346, 626,564,626, 1341,1305,1341, 
1345,1315,1345, 34110,1307,1342, 1343,1310,1343, 1344,1313,1344, 
2, // chain 124
625,563,625, 626,564,626, 1347,1319,1347, 
34114,1318,1346, 
1, // chain 125
1023,925,1023, 1021,923,1021, 1022,924,1022, 
22, // chain 126
596,534,596, 597,535,597, 1348,1323,1348, 
33366,536,598, 1349,1324,1349, 33367,537,599, 600,538,600, 601,539,601, 1350,1325,1350, 33370,540,602, 1351,1326,1351, 34120,1327,1352, 33371,541,603, 1353,1328,1353, 34122,1329,1354, 33372,542,604, 1355,1330,1355, 33373,543,605, 1356,1331,1356, 
33374,544,606, 1357,1332,1357, 33375,545,607, 1358,1333,1358, 33376,546,608, 
19, // chain 127
772,1334,772, 596,534,596, 1348,1323,1348, 
773,1335,773, 34127,1336,1359, 34117,1324,1349, 1360,1337,1360, 34129,1338,1361, 34130,1339,1362, 34131,1340,1363, 34132,1341,1364, 34133,1342,1365, 34118,1325,1350, 1366,1343,1366, 34119,1326,1351, 1367,1344,1367, 34136,1345,1368, 34137,1346,1369, 34138,1347,1370, 
34120,1327,1352, 1353,1328,1353, 
23, // chain 128
1371,1348,1371, 773,1335,773, 1359,1336,1359, 
1360,1337,1360, 1372,1349,1372, 34141,1350,1373, 34142,1351,1374, 34129,1338,1361, 1375,1352,1375, 34130,1339,1362, 1376,1353,1376, 34131,1340,1363, 1377,1354,1377, 34132,1341,1364, 1365,1342,1365, 1366,1343,1366, 1367,1344,1367, 1376,1353,1376, 34146,1355,1378, 
34147,1356,1379, 34148,1357,1380, 34136,1345,1368, 1381,1358,1381, 34150,1359,1382, 34137,1346,1369, 
14, // chain 129
773,1335,773, 1371,1348,1371, 1372,1349,1372, 
1383,1360,1383, 34152,1361,1384, 34153,1362,1385, 34141,1350,1373, 1386,1363,1386, 34155,1364,1387, 34156,1365,1388, 34142,1351,1374, 1389,1366,1389, 34158,1367,1390, 34146,1355,1378, 34143,1352,1375, 1376,1353,1376, 
44, // chain 130
1391,1368,1391, 1392,1369,1392, 1393,1370,1393, 
1379,1356,1379, 34162,1371,1394, 1378,1355,1378, 34163,1372,1395, 1390,1367,1390, 34164,1373,1396, 1397,1374,1397, 34166,1375,1398, 1399,1376,1399, 34168,1377,1400, 1401,1378,1401, 34170,1379,1402, 34171,1380,1403, 1404,1381,1404, 1405,1382,1405, 1406,1383,1406, 
34175,1384,1407, 34176,1385,1408, 34177,1386,1409, 1410,1387,1410, 1411,1388,1411, 33414,1389,646, 642,1390,642, 1412,1391,1412, 34181,1392,1413, 1414,1393,1414, 34183,1394,1415, 34184,1395,1416, 1417,1396,1417, 34186,1397,1418, 34187,1398,1419, 1420,1399,1420, 
1421,1400,1421, 1422,1401,1422, 34191,1402,1423, 1424,1403,1424, 34193,1404,1425, 33547,1405,779, 777,1406,777, 1426,1407,1426, 33543,1408,775, 1383,1360,1383, 33541,1335,773, 
3, // chain 131
1427,1409,1427, 1392,1369,1392, 1391,1368,1391, 
1380,1357,1380, 34147,1356,1379, 
3, // chain 132
1427,1409,1427, 1380,1357,1380, 1381,1358,1381, 
1428,1410,1428, 34150,1359,1382, 
2, // chain 133
1392,1369,1392, 1427,1409,1427, 1429,1411,1429, 
34196,1410,1428, 
10, // chain 134
1430,1412,1430, 1431,1413,1431, 1432,1414,1432, 
1433,1415,1433, 34202,1416,1434, 34203,1417,1435, 34204,1418,1436, 34199,1413,1431, 1437,1419,1437, 34206,1420,1438, 34207,1421,1439, 34198,1412,1430, 
5, // chain 135
1435,1417,1435, 1436,1418,1436, 1440,1422,1440, 
34205,1419,1437, 1441,1423,1441, 34210,1424,1442, 34206,1420,1438, 
9, // chain 136
1435,1417,1435, 1440,1422,1440, 1443,1425,1443, 
1434,1416,1434, 34212,1426,1444, 34213,1427,1445, 34214,1428,1446, 34208,1422,1440, 1441,1423,1441, 1447,1429,1447, 34210,1424,1442, 
2, // chain 137
1445,1427,1445, 1446,1428,1446, 1448,1430,1448, 
34215,1429,1447, 
5, // chain 138
1449,1431,1449, 782,1432,782, 1450,1433,1450, 
1451,1434,1451, 34220,1435,1452, 34221,1436,1453, 33550,1432,782, 
9, // chain 139
1454,1437,1454, 1455,1438,1455, 1456,1439,1456, 
1457,1440,1457, 34226,1441,1458, 34227,1442,1459, 34228,320,1460, 34229,322,1461, 34223,1438,1455, 1210,1443,1210, 34222,1437,1454, 
11, // chain 140
1458,1441,1458, 1459,1442,1459, 1452,1435,1452, 
34219,1434,1451, 34230,317,1462, 34228,320,1460, 1463,319,1463, 34232,321,1464, 34229,322,1461, 1465,323,1465, 33549,325,781, 33548,324,780, 33978,1443,1210, 
3, // chain 141
1449,1431,1449, 1451,1434,1451, 1462,317,1462, 
786,318,786, 34231,319,1463, 
56, // chain 142
1466,1444,1466, 1467,1445,1467, 1468,1446,1468, 
1469,1447,1469, 34238,1448,1470, 34239,1449,1471, 34240,1450,1472, 34241,1451,1473, 34235,1445,1467, 1474,1452,1474, 34243,1453,1475, 34234,1444,1466, 1476,1454,1476, 34245,1455,1477, 34246,1456,1478, 34237,1447,1469, 1470,1448,1470, 1479,1457,1479, 34248,1458,1480, 
34239,1449,1471, 1481,1459,1481, 34250,1460,1482, 34240,1450,1472, 1483,1461,1483, 34241,1451,1473, 1484,1462,1484, 1485,1463,1485, 1486,1464,1486, 1487,1465,1487, 34256,1466,1488, 1489,1467,1489, 34258,1468,1490, 34259,1469,1491, 1492,1470,1492, 34261,1471,1493, 
1494,1472,1494, 1495,1473,1495, 34264,1474,1496, 34265,1475,1497, 1498,1476,1498, 34267,1477,1499, 1500,1478,1500, 1501,1479,1501, 1502,1480,1502, 34271,1481,1503, 34272,1482,1504, 1505,1483,1505, 1506,1484,1506, 1507,1485,1507, 1508,1486,1508, 34277,1487,1509, 
34245,1488,1477, 1478,1489,1478, 1510,1490,1510, 32911,140,143, 32910,139,142, 34247,1491,1479, 141,138,141, 
4, // chain 143
1511,1492,1511, 1475,1453,1475, 1476,1454,1476, 
1506,1493,1506, 34275,1494,1507, 34245,1455,1477, 
7, // chain 144
1475,1453,1475, 1511,1492,1511, 1512,1495,1512, 
1513,1496,1513, 34282,1497,1514, 34283,1498,1515, 34279,1492,1511, 1506,1493,1506, 1505,1499,1505, 
17, // chain 145
1516,1192,1516, 1517,1182,1517, 1518,1181,1518, 
1519,1175,1519, 34288,1179,1520, 34289,1180,1521, 34285,1182,1517, 1522,1183,1522, 34291,1184,1523, 34292,1185,1524, 34284,1192,1516, 1525,1189,1525, 34287,1175,1519, 1526,1174,1526, 34295,1172,1527, 34296,1176,1528, 34288,1179,1520, 1529,1178,1529, 34289,1180,1521, 
15, // chain 146
1530,1231,1530, 1531,1230,1531, 1532,1232,1532, 
1326,1233,1326, 33631,1240,863, 34301,1239,1533, 34302,1238,1534, 1535,1237,1535, 34304,1236,1536, 1537,1235,1537, 1538,1263,1538, 1539,1255,1539, 34308,1264,1540, 1541,1256,1541, 34310,1265,1542, 34311,1500,1543, 34312,1501,1544, 
1, // chain 147
1326,1233,1326, 1325,1234,1325, 1530,1231,1530, 
14, // chain 148
1528,1176,1528, 1529,1178,1529, 1545,1177,1545, 
784,1171,784, 1527,1172,1527, 33553,1170,785, 787,1173,787, 1526,1174,1526, 34314,1191,1546, 1547,1190,1547, 1525,1189,1525, 34316,1188,1548, 1524,1185,1524, 34317,1187,1549, 1550,1186,1550, 1523,1184,1523, 
6, // chain 149
863,1240,863, 1533,1239,1533, 1551,1242,1551, 
864,1244,864, 34320,1243,1552, 34321,1241,1553, 34303,1237,1535, 34301,1239,1533, 
3, // chain 150
1554,1246,1554, 1555,1245,1555, 1553,1241,1553, 
1539,1255,1539, 34303,1237,1535, 
7, // chain 151
1552,1243,1552, 1553,1241,1553, 1555,1245,1555, 
1556,1248,1556, 34325,1247,1557, 34322,1246,1554, 1558,1257,1558, 34309,1256,1541, 34307,1255,1539, 
8, // chain 152
1559,1502,1559, 1560,1503,1560, 1561,1504,1561, 
1562,1505,1562, 34216,1506,1448, 1430,1507,1430, 34215,1508,1447, 1439,1509,1439, 34210,1510,1442, 1438,1511,1438, 
6, // chain 153
1560,1503,1560, 1559,1502,1559, 1563,1512,1563, 
1564,1513,1564, 34333,1514,1565, 1566,1515,1566, 1567,1516,1567, 34336,1517,1568, 
3, // chain 154
1569,1266,1569, 1570,1258,1570, 1558,1257,1558, 
1542,1265,1542, 34309,1256,1541, 
9, // chain 155
1571,1518,1571, 1572,1193,1572, 1256,1194,1256, 
34341,1195,1573, 34342,1196,1574, 34343,1197,1575, 1576,1198,1576, 33110,288,342, 33206,1519,438, 341,289,341, 33108,290,340, 
10, // chain 156
1489,1467,1489, 1577,1520,1577, 1578,1521,1578, 
1487,1465,1487, 34250,1460,1482, 34347,1522,1579, 34348,1523,1580, 34345,1520,1577, 1581,1524,1581, 34350,1525,1582, 34258,1468,1490, 34257,1467,1489, 
4, // chain 157
1583,1260,1583, 1556,1248,1556, 1557,1247,1557, 
1584,1259,1584, 34338,1258,1570, 34326,1257,1558, 
7, // chain 158
1585,1249,1585, 864,1244,864, 1552,1243,1552, 
1556,1248,1556, 1586,1262,1586, 34355,1261,1587, 34351,1260,1583, 1588,1526,1588, 34352,1259,1584, 
2, // chain 159
158,1267,158, 152,1268,152, 1586,1262,1586, 
1587,1261,1587, 
4, // chain 160
1586,1262,1586, 1589,1252,1589, 1585,1249,1585, 
33406,1251,638, 34358,1253,1590, 1591,1254,1591, 
2, // chain 161
1585,1249,1585, 638,1251,638, 639,1250,639, 
864,1244,864, 
25, // chain 162
1481,1459,1481, 1482,1460,1482, 1579,1522,1579, 
1592,1527,1592, 34361,1528,1593, 34348,1523,1580, 674,1529,674, 34349,1524,1581, 673,1530,673, 34362,1531,1594, 34350,1525,1582, 146,143,146, 32913,142,145, 34363,1532,1595, 34258,1468,1490, 1492,1470,1492, 1596,1533,1596, 34365,1534,1597, 34366,1535,1598, 
34263,1473,1495, 1599,1536,1599, 34278,1490,1510, 34277,1487,1509, 34368,1537,1600, 34264,1474,1496, 1502,1480,1502, 34266,1476,1498, 
7, // chain 163
1480,1458,1480, 1481,1459,1481, 1601,1538,1601, 
1479,1457,1479, 32909,1539,141, 34370,1540,1602, 34371,1541,1603, 34360,1527,1592, 34249,1459,1481, 
6, // chain 164
1592,1527,1592, 1593,1528,1593, 1604,1542,1604, 
1603,1541,1603, 33419,1543,651, 34043,1544,1275, 34361,1528,1593, 674,1529,674, 
3, // chain 165
673,1530,673, 1594,1531,1594, 1277,1545,1277, 
32915,144,147, 32914,143,146, 
9, // chain 166
1278,1546,1278, 1277,1545,1277, 147,144,147, 
1605,1547,1605, 33287,1548,519, 32916,145,148, 518,1549,518, 32917,146,149, 517,1550,517, 34374,1551,1606, 32918,147,150, 
7, // chain 167
1607,1552,1607, 145,142,145, 1595,1532,1595, 
1608,1553,1608, 34364,1533,1596, 1609,1554,1609, 34367,1536,1599, 34366,1535,1598, 34365,1534,1597, 
2, // chain 168
1600,1537,1600, 1503,1481,1503, 1508,1486,1508, 
1509,1487,1509, 
24, // chain 169
1610,1208,1610, 1611,1205,1611, 1612,1555,1612, 
1613,1213,1613, 34382,631,1614, 34383,632,1615, 34384,1203,1616, 34379,1205,1611, 1617,1204,1617, 34386,1206,1618, 34387,1207,1619, 34378,1208,1610, 1620,1209,1620, 34381,1213,1613, 1621,1212,1621, 34390,1214,1622, 34391,1215,1623, 34382,631,1614, 1624,630,1624, 
34393,627,1625, 34383,632,1615, 1626,626,1626, 34395,633,1627, 34396,1202,1628, 34384,1203,1616, 1617,1204,1617, 
3, // chain 170
1629,1210,1629, 1619,1207,1619, 1620,1209,1620, 
1630,1211,1630, 34389,1212,1621, 
15, // chain 171
1630,1200,1630, 1621,1199,1621, 1631,1201,1631, 
34395,633,1627, 34390,634,1622, 1626,626,1626, 34400,625,1632, 1625,627,1625, 34401,628,1633, 1634,629,1634, 34403,1556,1635, 1636,1557,1636, 1637,1558,1637, 1638,1216,1638, 34407,1217,1639, 1622,1214,1622, 34400,1218,1632, 
1, // chain 172
1627,633,1627, 1628,1202,1628, 1631,1201,1631, 
36, // chain 173
1640,1559,1640, 1641,1560,1641, 1642,1561,1642, 
565,507,565, 33332,506,564, 34411,1562,1643, 34412,1563,1644, 34409,1560,1641, 1645,1564,1645, 34414,1565,1646, 34415,1566,1647, 34416,1567,1648, 34417,1568,1649, 34418,1569,1650, 34408,1559,1640, 1651,1570,1651, 33333,507,565, 566,259,566, 1652,258,1652, 
34421,244,1653, 33335,260,567, 1654,245,1654, 33336,261,568, 569,246,569, 1655,238,1655, 34424,247,1656, 33338,248,570, 1657,237,1657, 34426,249,1658, 33339,508,571, 1659,1571,1659, 33340,509,572, 1660,1572,1660, 34429,1573,1661, 34430,1574,1662, 
33341,510,573, 1663,1575,1663, 33342,511,574, 
7, // chain 174
1650,1569,1650, 1651,1570,1651, 1664,1576,1664, 
34420,258,1652, 1665,257,1665, 34434,243,1666, 34421,244,1653, 1655,238,1655, 34422,245,1654, 
3, // chain 175
1667,239,1667, 1666,243,1666, 1655,238,1655, 
1657,237,1657, 34424,247,1656, 
11, // chain 176
1668,250,1668, 1657,237,1657, 1658,249,1658, 
1669,1577,1669, 34427,1571,1659, 1660,1572,1660, 1670,1578,1670, 1671,1579,1671, 34440,1580,1672, 1673,1581,1673, 34442,1582,1674, 1675,1583,1675, 34444,1584,1676, 
10, // chain 177
1657,237,1657, 1668,250,1668, 1677,240,1677, 
1667,239,1667, 34446,241,1678, 34447,253,1679, 34448,252,1680, 34449,251,1681, 34436,250,1668, 1673,1581,1673, 34439,1579,1671, 34437,1577,1669, 
19, // chain 178
1682,1585,1682, 1683,1586,1683, 1684,1587,1684, 
34453,1588,1685, 34454,1589,1686, 1687,1590,1687, 34456,1591,1688, 34457,1592,1689, 1690,1593,1690, 34459,1594,1691, 1692,1595,1692, 34461,1596,1693, 34462,1597,1694, 34443,1598,1675, 1695,1599,1695, 34464,1600,1696, 34444,1601,1676, 1697,1602,1697, 1698,1603,1698, 
34450,1604,1682, 34451,1605,1683, 
20, // chain 179
1699,1606,1699, 1688,1591,1688, 1690,1593,1690, 
1700,1607,1700, 34460,1595,1692, 1567,1608,1567, 34332,1609,1564, 34461,1596,1693, 1560,1610,1560, 34329,1611,1561, 34469,1612,1701, 34462,1597,1694, 1444,1426,1444, 34463,1599,1695, 1434,1416,1434, 34464,1600,1696, 1698,1603,1698, 1433,1415,1433, 34470,1613,1702, 
34450,1604,1682, 1559,1614,1559, 34331,1615,1563, 
7, // chain 180
1685,1588,1685, 1687,1590,1687, 1703,1616,1703, 
1684,1587,1684, 34333,1617,1565, 34334,1618,1566, 34467,1606,1699, 34455,1590,1687, 1688,1591,1688, 
2, // chain 181
1682,1585,1682, 1684,1587,1684, 1565,1617,1565, 
1563,1619,1563, 
3, // chain 182
1568,1620,1568, 1566,1618,1566, 1699,1606,1699, 
1700,1607,1700, 1567,1608,1567, 
3, // chain 183
1561,1611,1561, 1701,1612,1701, 1448,1430,1448, 
34213,1427,1445, 34212,1426,1444, 
3, // chain 184
1433,1415,1433, 1702,1613,1702, 1559,1614,1559, 
1562,1621,1562, 1430,1412,1430, 
6, // chain 185
1704,1622,1704, 1663,1623,1663, 574,1624,574, 
1705,1625,1705, 33343,1626,575, 1706,1627,1706, 1707,1628,1707, 34476,1629,1708, 
6, // chain 186
1709,1630,1709, 1663,1623,1663, 1710,1631,1710, 
1711,1632,1711, 34480,1633,1712, 34481,1634,1713, 34472,1622,1704, 34431,1623,1663, 
2, // chain 187
1714,1635,1714, 1663,1623,1663, 1709,1630,1709, 
1711,1636,1711, 
55, // chain 188
1715,1637,1715, 1716,1638,1716, 1717,1639,1717, 
1718,1640,1718, 34487,1641,1719, 34488,1642,1720, 34489,1643,1721, 34490,1644,1722, 34484,1638,1716, 1723,1645,1723, 34492,1646,1724, 34493,1647,1725, 34483,1637,1715, 1726,1648,1726, 34486,1640,1718, 1727,1649,1727, 34496,1650,1728, 34487,1641,1719, 1729,1651,1729, 
34498,1652,1730, 34488,1642,1720, 1731,178,1731, 34500,179,1732, 34489,1643,1721, 162,159,162, 34501,180,1733, 34490,1644,1722, 1734,187,1734, 34503,1653,1735, 34504,1654,1736, 34491,1645,1723, 1737,1655,1737, 34506,1656,1738, 34492,1646,1724, 1739,1657,1739, 
34493,1647,1725, 1740,1658,1740, 34494,1648,1726, 1741,1659,1741, 34495,1649,1727, 1742,1660,1742, 34511,228,1743, 34512,1661,1744, 34496,1650,1728, 156,153,156, 34513,1662,1745, 34497,1651,1729, 1746,1663,1746, 34515,1664,1747, 34498,1652,1730, 155,152,155, 
34499,178,1731, 1748,174,1748, 34517,177,1749, 34500,179,1732, 163,160,163, 32930,159,162, 
3, // chain 189
1662,1574,1662, 1663,1575,1663, 1714,1665,1714, 
1750,1666,1750, 34479,1667,1711, 
1, // chain 190
1661,1573,1661, 1662,1574,1662, 1750,1666,1750, 
38, // chain 191
1673,1581,1673, 1675,1583,1675, 1681,251,1681, 
34459,1668,1691, 1680,252,1680, 34457,1669,1689, 1679,253,1679, 34454,1670,1686, 1751,1671,1751, 34520,1672,1752, 34451,1673,1683, 1753,1674,1753, 34465,1675,1697, 1754,1676,1754, 34444,1677,1676, 1674,1678,1674, 1755,1679,1755, 34440,1680,1672, 1670,1681,1670, 
1756,1682,1756, 34525,1683,1757, 34428,1684,1660, 1649,1568,1649, 34416,1567,1648, 34429,1685,1661, 1750,1686,1750, 1647,1566,1647, 34479,1687,1711, 1712,1688,1712, 1646,1565,1646, 34526,1689,1758, 1645,1564,1645, 34527,1690,1759, 34528,1691,1760, 1761,1692,1761, 
34530,1693,1762, 398,1694,398, 33165,1695,397, 34531,1696,1763, 395,1697,395, 
58, // chain 192
1764,236,1764, 158,155,158, 1587,235,1587, 
1765,233,1765, 34534,234,1766, 1767,232,1767, 1768,231,1768, 34537,229,1769, 1770,230,1770, 34511,228,1743, 34539,227,1771, 1772,226,1772, 34541,224,1773, 1774,225,1774, 34543,223,1775, 34544,222,1776, 1777,221,1777, 34546,219,1778, 1779,220,1779, 
34548,217,1780, 34549,218,1781, 1782,215,1782, 1783,216,1783, 34552,214,1784, 34553,213,1785, 1786,211,1786, 34312,212,1544, 1540,210,1540, 1787,208,1787, 34306,209,1538, 1537,207,1537, 1788,206,1788, 34304,204,1536, 1789,205,1789, 34558,203,1790, 
34302,202,1534, 1791,200,1791, 34300,201,1532, 1531,199,1531, 1792,198,1792, 34298,196,1530, 1793,197,1793, 34562,194,1794, 34563,195,1795, 1796,193,1796, 1797,192,1797, 34566,191,1798, 1799,190,1799, 34568,188,1800, 34569,189,1801, 1802,186,1802, 
1734,187,1734, 34571,185,1803, 34572,184,1804, 1805,182,1805, 34574,183,1806, 1807,181,1807, 1733,180,1733, 32927,156,159, 162,159,162, 
4, // chain 193
1744,1661,1744, 156,153,156, 157,154,157, 
1808,1698,1808, 34532,236,1764, 32926,155,158, 
25, // chain 194
1751,1671,1751, 1752,1672,1752, 1809,254,1809, 
34578,1699,1810, 34521,1674,1753, 1754,1676,1754, 1755,1679,1755, 1811,255,1811, 34524,1682,1756, 1812,1700,1812, 34525,1683,1757, 1813,1701,1813, 34582,1702,1814, 34417,1568,1649, 1650,1569,1650, 1664,1576,1664, 1813,1701,1813, 34580,1700,1812, 34433,257,1665, 
1815,256,1815, 34434,243,1666, 1816,242,1816, 34435,239,1667, 1678,241,1678, 1809,254,1809, 34447,253,1679, 1751,1671,1751, 
14, // chain 195
1586,162,1586, 152,149,152, 151,148,151, 
1589,163,1589, 34585,164,1817, 32922,151,154, 1590,165,1590, 34359,166,1591, 34586,167,1818, 32923,152,155, 1748,174,1748, 1819,172,1819, 33405,173,637, 34107,175,1339, 34106,176,1338, 34517,177,1749, 
1, // chain 196
1590,165,1590, 1589,163,1589, 1817,164,1817, 
3, // chain 197
1747,1664,1747, 155,152,155, 1746,1663,1746, 
32924,153,156, 1745,1662,1745, 
4, // chain 198
1818,167,1818, 1819,172,1819, 1820,169,1820, 
34589,170,1821, 34590,171,1822, 33405,173,637, 
4, // chain 199
1823,168,1823, 1591,166,1591, 1818,167,1818, 
1820,169,1820, 1821,170,1821, 1822,171,1822, 
1, // chain 200
163,160,163, 164,161,164, 1749,177,1749, 
2, // chain 201
1733,180,1733, 1734,187,1734, 1803,185,1803, 
1805,182,1805, 
20, // chain 202
1800,188,1800, 1734,187,1734, 1735,1653,1735, 
1736,1654,1736, 1824,1703,1824, 34505,1655,1737, 1825,1704,1825, 34594,1705,1826, 34506,1656,1738, 1825,1704,1825, 34595,1706,1827, 34507,1657,1739, 1828,1707,1828, 34508,1658,1740, 1829,1708,1829, 34509,1659,1741, 1777,221,1777, 34543,223,1775, 34510,1660,1742, 
1774,225,1774, 34540,226,1772, 34511,228,1743, 
14, // chain 203
1799,190,1799, 1800,188,1800, 1824,1703,1824, 
1793,197,1793, 34560,198,1792, 34557,205,1789, 34593,1704,1825, 1788,206,1788, 34595,1706,1827, 1784,214,1784, 34551,216,1783, 34596,1707,1828, 1780,217,1780, 34547,220,1779, 34597,1708,1829, 1777,221,1777, 
2, // chain 204
1797,192,1797, 1799,190,1799, 1793,197,1793, 
1794,194,1794, 
2, // chain 205
1789,205,1789, 1790,203,1790, 1792,198,1792, 
34559,200,1791, 
2, // chain 206
1816,242,1816, 1809,254,1809, 1811,255,1811, 
34578,1699,1810, 
2, // chain 207
1816,242,1816, 1811,255,1811, 1815,256,1815, 
34580,1700,1812, 
3, // chain 208
1830,106,1830, 1831,107,1831, 1832,117,1832, 
1833,118,1833, 34602,1709,1834, 
14, // chain 209
1832,117,1832, 1831,107,1831, 1835,116,1835, 
1836,133,1836, 33975,131,1207, 33972,130,1204, 33973,129,1205, 34605,115,1837, 34599,107,1831, 1838,114,1838, 32895,113,127, 32894,108,126, 34598,106,1830, 1839,109,1839, 34608,119,1840, 34601,118,1833, 
2, // chain 210
784,1139,784, 1841,132,1841, 1207,131,1207, 
34604,133,1836, 
8, // chain 211
755,1130,755, 1205,129,1205, 757,128,757, 
34605,115,1837, 758,127,758, 34606,114,1838, 130,126,130, 32897,125,129, 32895,113,127, 128,124,128, 
6, // chain 212
1842,1710,1842, 1843,1711,1843, 1844,1712,1844, 
1845,1713,1845, 34614,1714,1846, 1847,1715,1847, 34616,1716,1848, 34617,1717,1849, 
6, // chain 213
1842,1710,1842, 1845,1713,1845, 1850,1718,1850, 
1851,1719,1851, 34620,1720,1852, 34621,1721,1853, 34615,1715,1847, 34613,1713,1845, 
9, // chain 214
1854,1722,1854, 1855,1723,1855, 1856,1724,1856, 
1857,1725,1857, 34619,1719,1851, 1852,1720,1852, 1858,1726,1858, 34621,1721,1853, 1859,1727,1859, 34616,1716,1848, 34615,1715,1847, 
6, // chain 215
1857,1725,1857, 1858,1726,1858, 1860,1728,1860, 
1854,1722,1854, 34629,1729,1861, 34630,1730,1862, 34627,1727,1859, 34626,1726,1858, 
4, // chain 216
1854,1722,1854, 1861,1729,1861, 1863,1731,1863, 
34632,1732,1864, 34633,1733,1865, 34630,1730,1862, 
3, // chain 217
1863,1731,1863, 1864,1732,1864, 1865,1733,1865, 
1855,1723,1855, 1854,1722,1854, 
15, // chain 218
1866,723,1866, 1867,1734,1867, 1868,725,1868, 
1869,724,1869, 34638,726,1870, 34639,727,1871, 34640,1735,1872, 34641,1736,1873, 34635,1734,1867, 1849,1737,1849, 33237,430,469, 34642,1738,1874, 34634,723,1866, 456,417,456, 33221,414,453, 33218,411,450, 34637,724,1869, 
2, // chain 219
1875,1739,1875, 1872,1735,1872, 1876,1740,1876, 
34641,1736,1873, 
2, // chain 220
1877,1741,1877, 1875,1739,1875, 1878,1742,1878, 
34644,1740,1876, 
2, // chain 221
1879,1743,1879, 1877,1741,1877, 1880,1744,1880, 
34646,1742,1878, 
2, // chain 222
1881,1745,1881, 1879,1743,1879, 1882,1746,1882, 
34648,1744,1880, 
23, // chain 223
1883,1638,1883, 1884,1639,1884, 1885,1644,1885, 
1886,1645,1886, 34655,1654,1887, 34656,1653,1888, 32969,187,201, 32962,180,194, 34657,1643,1889, 34652,1639,1884, 1890,1642,1890, 34659,1641,1891, 34660,1640,1892, 34661,1637,1893, 34651,1638,1883, 1894,1647,1894, 34663,1646,1895, 34654,1645,1886, 1896,1656,1896, 
34665,1655,1897, 34655,1654,1887, 1898,1703,1898, 32970,188,202, 34656,1653,1888, 201,187,201, 
20, // chain 224
1891,1641,1891, 1892,1640,1892, 1899,1650,1899, 
34668,1649,1900, 34669,1648,1901, 34661,1637,1893, 1894,1647,1894, 1902,1658,1902, 34671,1657,1903, 34663,1646,1895, 1896,1656,1896, 1904,1706,1904, 34673,1704,1905, 34674,1705,1906, 34665,1655,1897, 1905,1704,1905, 34666,1703,1898, 219,205,219, 32980,198,212, 
32979,197,211, 32972,190,204, 32970,188,202, 
19, // chain 225
1891,1641,1891, 1899,1650,1899, 1907,1651,1907, 
34676,1662,1908, 33020,153,252, 34677,1661,1909, 34668,1649,1900, 242,228,242, 34678,1660,1910, 34679,1659,1911, 34669,1648,1901, 1902,1658,1902, 1912,1708,1912, 34681,1707,1913, 34671,1657,1903, 1904,1706,1904, 230,216,230, 32996,214,228, 32988,206,220, 
34673,1704,1905, 219,205,219, 
9, // chain 226
1914,1663,1914, 1907,1651,1907, 1908,1662,1908, 
252,153,252, 253,152,253, 1915,1664,1915, 34684,1652,1916, 32954,178,186, 32950,174,182, 32943,167,175, 32941,151,173, 
4, // chain 227
1848,1747,1848, 1849,1737,1849, 1842,1748,1842, 
34611,1749,1843, 33237,430,469, 471,432,471, 
6, // chain 228
1865,1750,1865, 1862,1751,1862, 1855,1752,1855, 
34624,1753,1856, 34627,1754,1859, 1851,1755,1851, 34616,1747,1848, 1842,1748,1842, 
9, // chain 229
1917,736,1917, 1918,734,1918, 1919,735,1919, 
34688,733,1920, 34689,732,1921, 1922,731,1922, 34691,730,1923, 1924,729,1924, 34693,728,1925, 1871,727,1871, 34638,726,1870, 
14, // chain 230
477,1756,477, 479,1757,479, 1926,1758,1926, 
34695,1759,1927, 34696,1760,1928, 33246,1761,478, 1929,1762,1929, 33244,1763,476, 1930,1764,1930, 33242,1765,474, 1931,1766,1931, 34700,1767,1932, 33240,1768,472, 1933,1769,1933, 34702,1770,1934, 33238,1771,470, 
5, // chain 231
475,1772,475, 477,1756,477, 1935,1773,1935, 
34694,1758,1926, 1929,1762,1929, 34696,1760,1928, 34695,1759,1927, 
8, // chain 232
471,1774,471, 473,1775,473, 1936,1776,1936, 
34705,1777,1937, 34706,1778,1938, 33243,1772,475, 1939,1779,1939, 34703,1773,1935, 1930,1764,1930, 34697,1762,1929, 
6, // chain 233
1933,1769,1933, 1936,1776,1936, 1937,1777,1937, 
1932,1767,1932, 34706,1778,1938, 1931,1766,1931, 34707,1779,1939, 1930,1764,1930, 
40, // chain 234
1940,1321,1940, 1941,1320,1941, 1942,1319,1942, 
34711,1317,1943, 1944,1318,1944, 34713,1315,1945, 34714,1316,1946, 1947,1314,1947, 1948,1313,1948, 34717,1312,1949, 1950,1310,1950, 34719,1311,1951, 1952,1309,1952, 1953,1307,1953, 34722,1308,1954, 1955,1306,1955, 1956,1305,1956, 34725,1304,1957, 1958,564,1958, 
33219,565,451, 1959,553,1959, 34728,554,1960, 33218,566,450, 1869,567,1869, 1961,568,1961, 34638,1169,1870, 1962,1167,1962, 34693,1168,1925, 1963,1165,1963, 1964,1166,1964, 34733,1164,1965, 34734,1163,1966, 1967,1160,1967, 34639,1162,1871, 1872,1161,1872, 
1968,1159,1968, 1969,1158,1969, 34738,1150,1970, 1971,1149,1971, 34614,1148,1846, 34641,1151,1873, 1849,1152,1849, 
32, // chain 235
1948,1313,1948, 1950,1310,1950, 1945,1315,1945, 
34721,1307,1953, 1956,1305,1956, 1944,1318,1944, 34726,564,1958, 1942,1319,1942, 34740,563,1972, 34727,553,1959, 1973,552,1973, 34742,548,1974, 34728,554,1960, 1975,555,1975, 34744,570,1976, 34745,569,1977, 34729,568,1961, 1962,1167,1962, 1964,1166,1964, 
1978,1303,1978, 34733,1164,1965, 1979,1296,1979, 34735,1160,1967, 1980,1157,1980, 34737,1158,1969, 1971,1149,1971, 1981,1156,1981, 34750,1147,1982, 34614,1148,1846, 1844,1145,1844, 1983,1146,1983, 34704,1144,1936, 34611,1143,1843, 471,1142,471, 
25, // chain 236
1940,1321,1940, 1942,1319,1942, 1972,563,1972, 
1984,562,1984, 34741,552,1973, 1985,551,1985, 34754,549,1986, 34742,548,1974, 1987,547,1987, 34756,556,1988, 34743,555,1975, 1989,571,1989, 34744,570,1976, 1990,1298,1990, 34759,1297,1991, 34745,569,1977, 1992,1300,1992, 34746,1303,1978, 1993,1295,1993, 
34747,1296,1979, 1980,1157,1980, 1994,1293,1994, 34749,1156,1981, 1995,1294,1995, 34764,1155,1996, 34751,1146,1983, 34750,1147,1982, 
6, // chain 237
1997,558,1997, 1300,576,1300, 1998,559,1998, 
1999,550,1999, 33223,560,455, 33226,578,458, 34067,577,1299, 34068,576,1300, 
1, // chain 238
460,1780,460, 458,578,458, 1299,577,1299, 
18, // chain 239
2000,1781,2000, 2001,1782,2001, 2002,1783,2002, 
2003,1784,2003, 34772,1785,2004, 34648,1786,1880, 34650,1787,1882, 34769,1782,2001, 1881,1788,1881, 34773,1789,2005, 34768,1781,2000, 1881,1788,1881, 34647,1790,1879, 34771,1784,2003, 1877,1791,1877, 34774,1792,2006, 34772,1785,2004, 2007,1793,2007, 34646,1794,1878, 
34648,1786,1880, 
4, // chain 240
1970,1795,1970, 1968,1796,1968, 2008,1797,2008, 
34777,1798,2009, 34643,1799,1875, 34640,1800,1872, 
2, // chain 241
1970,1795,1970, 2008,1797,2008, 1876,1801,1876, 
1873,1802,1873, 
10, // chain 242
2006,1792,2006, 2007,1793,2007, 2010,1803,2010, 
1877,1791,1877, 34643,1799,1875, 34777,1798,2009, 34779,1804,2011, 34775,1793,2007, 1878,1794,1878, 1876,1801,1876, 2008,1797,2008, 2009,1798,2009, 
5, // chain 243
332,298,332, 1393,1805,1393, 1429,1806,1429, 
331,299,331, 33098,298,330, 34150,1805,1382, 34196,1807,1428, 
31, // chain 244
1393,1805,1393, 332,298,332, 333,297,333, 
2012,1808,2012, 33102,296,334, 2013,1809,2013, 33103,295,335, 2014,1810,2014, 34783,1811,2015, 33104,294,336, 2016,1812,2016, 34785,1813,2017, 33105,293,337, 2018,1814,2018, 33106,292,338, 2019,1815,2019, 33107,291,339, 2020,1816,2020, 33178,1817,410, 
33108,290,340, 2021,1818,2021, 33208,1819,440, 418,1820,418, 34790,1821,2022, 34791,1822,2023, 2024,1823,2024, 34793,1824,2025, 2026,1825,2026, 34795,1826,2027, 2028,1827,2028, 2029,1828,2029, 34798,1829,2030, 34799,1830,2031, 
20, // chain 245
2032,1831,2032, 2033,1832,2033, 2034,1833,2034, 
2035,1834,2035, 34692,1835,1924, 34690,1836,1922, 34804,1837,2036, 34801,1832,2033, 2037,1838,2037, 34689,1839,1921, 34691,1840,1923, 34800,1831,2032, 2038,1841,2038, 34803,1834,2035, 2039,1842,2039, 34692,1835,1924, 1871,1843,1871, 1966,1844,1966, 1963,1845,1963, 
2038,1841,2038, 34693,1846,1925, 1923,1840,1923, 
1, // chain 246
1429,1806,1429, 1393,1805,1393, 1392,1807,1392, 
11, // chain 247
2040,1847,2040, 2041,1848,2041, 2042,1849,2042, 
1919,1850,1919, 34685,1851,1917, 34809,1848,2041, 1918,1852,1918, 34689,1839,1921, 34805,1838,2037, 34811,1853,2043, 34808,1847,2040, 1920,1854,1920, 34687,1850,1919, 
6, // chain 248
1400,1855,1400, 1398,1856,1398, 2015,1811,2015, 
34782,1810,2014, 34164,1857,1396, 2013,1809,2013, 34162,1858,1394, 34163,1859,1395, 
18, // chain 249
1400,1855,1400, 2015,1811,2015, 2044,1860,2044, 
1403,1861,1403, 34813,1862,2045, 34814,1863,2046, 34783,1811,2015, 2016,1812,2016, 543,485,543, 34785,1813,2017, 542,484,542, 34786,1814,2018, 541,483,541, 33308,482,540, 34787,1815,2019, 2020,1816,2020, 2047,1864,2047, 34816,1865,2048, 33179,1866,411, 
33178,1817,410, 
3, // chain 250
1920,1854,1920, 1922,1836,1922, 2043,1853,2043, 
34804,1837,2036, 2037,1838,2037, 
4, // chain 251
2049,314,2049, 2050,1867,2050, 2051,1868,2051, 
2052,315,2052, 1834,313,1834, 34601,316,1833, 
26, // chain 252
2053,1869,2053, 2051,1868,2051, 2050,1867,2050, 
2054,1870,2054, 34823,310,2055, 34817,314,2049, 2056,311,2056, 34602,313,1834, 2057,312,2057, 2058,303,2058, 2059,300,2059, 34828,302,2060, 34829,304,2061, 2062,305,2062, 2063,306,2063, 2064,307,2064, 34601,1871,1833, 2052,1872,2052, 2065,1873,2065, 
34819,1874,2051, 2066,1875,2066, 2067,1876,2067, 2068,1877,2068, 34837,309,2069, 34838,1878,2070, 2071,1879,2071, 2054,1870,2054, 34821,1869,2053, 
4, // chain 253
2072,308,2072, 2068,1877,2068, 2069,309,2069, 
2073,301,2073, 34823,310,2055, 34822,1870,2054, 
11, // chain 254
1949,744,1949, 1947,741,1947, 1951,743,1951, 
34720,742,1952, 34722,740,1954, 34714,739,1946, 1955,738,1955, 34711,737,1943, 1957,720,1957, 34709,721,1941, 451,412,451, 34708,722,1940, 452,413,452, 
3, // chain 255
463,424,463, 465,426,465, 456,417,456, 
457,418,457, 459,420,459, 
3, // chain 256
456,417,456, 465,426,465, 467,428,467, 
1874,1738,1874, 33237,430,469, 
11, // chain 257
2074,52,2074, 2075,49,2075, 2076,53,2076, 
2077,54,2077, 34846,55,2078, 34847,58,2079, 34848,77,2080, 34843,49,2075, 2081,76,2081, 34850,75,2082, 34851,50,2083, 34852,51,2084, 34842,52,2074, 
28, // chain 258
2077,54,2077, 2078,55,2078, 2085,56,2085, 
34854,57,2086, 34847,58,2079, 2087,59,2087, 34856,60,2088, 34848,77,2080, 2089,62,2089, 34849,76,2081, 2090,64,2090, 34859,1880,2091, 34850,75,2082, 2092,72,2092, 34851,50,2083, 2093,74,2093, 1836,73,1836, 2094,71,2094, 2095,70,2095, 
34864,69,2096, 2097,66,2097, 34317,68,1549, 1548,67,1548, 2098,65,2098, 2090,64,2090, 34867,63,2099, 2089,62,2089, 34188,61,1420, 2088,60,2088, 34855,59,2087, 
3, // chain 259
2100,715,2100, 1236,716,1236, 1235,717,1235, 
362,718,362, 34006,719,1238, 
6, // chain 260
2101,1273,2101, 2102,1272,2102, 466,1281,466, 
464,1282,464, 2103,1283,2103, 33230,1286,462, 1287,1285,1287, 33229,1287,461, 
9, // chain 261
466,1281,466, 2102,1272,2102, 2104,1280,2104, 
34873,1279,2105, 34874,1269,2106, 34875,1271,2107, 34869,1273,2101, 2103,1283,2103, 2108,1274,2108, 34056,1284,1288, 34055,1285,1287, 
9, // chain 262
2109,1278,2109, 2110,1290,2110, 1995,1294,1995, 
2105,1279,2105, 34764,1155,1996, 2104,1280,2104, 33236,1288,468, 34879,1154,2111, 34751,1146,1983, 1934,1153,1934, 34704,1144,1936, 
5, // chain 263
2105,1279,2105, 2106,1269,2106, 2109,1278,2109, 
34880,1270,2112, 34875,1271,2107, 2113,1275,2113, 34876,1274,2108, 
3, // chain 264
2114,1277,2114, 2109,1278,2109, 2112,1270,2112, 
2115,1276,2115, 34881,1275,2113, 
12, // chain 265
2110,1290,2110, 2109,1278,2109, 2114,1277,2114, 
2116,1291,2116, 34883,1276,2115, 184,1301,184, 1990,1298,1990, 32951,1302,183, 2117,1299,2117, 34886,574,2118, 32949,575,181, 1997,558,1997, 34068,576,1300, 32942,1881,174, 
3, // chain 266
2110,1290,2110, 2116,1291,2116, 2119,1292,2119, 
34759,1297,1991, 34758,1298,1990, 
5, // chain 267
2119,1292,2119, 1991,1297,1991, 1992,1300,1992, 
1993,1295,1993, 1994,1293,1994, 2110,1290,2110, 34763,1294,1995, 
24, // chain 268
1230,1844,1230, 796,1843,796, 2120,1842,2120, 
33566,1835,798, 2121,1834,2121, 34890,1833,2122, 33568,1836,800, 2123,1837,2123, 34892,1853,2124, 33570,1854,802, 2125,1847,2125, 33572,1850,804, 2126,1849,2126, 33573,1851,805, 2127,1848,2127, 33571,1852,803, 801,1839,801, 2128,1838,2128, 34897,1832,2129, 
33567,1840,799, 2130,1831,2130, 34899,1841,2131, 33565,1846,797, 1232,1845,1232, 2120,1842,2120, 33998,1844,1230, 
8, // chain 269
2121,1834,2121, 2122,1833,2122, 2130,1831,2130, 
34897,1832,2129, 34891,1837,2123, 2128,1838,2128, 34892,1853,2124, 2127,1848,2127, 34893,1847,2125, 2126,1849,2126, 
2, // chain 270
2120,1842,2120, 2121,1834,2121, 2131,1841,2131, 
34898,1831,2130, 
15, // chain 271
1584,1882,1584, 1570,1883,1570, 1569,1884,1569, 
1588,1885,1588, 34534,1886,1766, 34535,1887,1767, 34537,1888,1769, 34539,1889,1771, 34541,1890,1773, 34544,1891,1776, 34546,1892,1778, 34549,1893,1781, 34550,1894,1782, 34553,1895,1785, 34312,1896,1544, 34311,1897,1543, 34310,1898,1542, 
2, // chain 272
1934,1153,1934, 470,1289,470, 2111,1154,2111, 
33236,1288,468, 
1, // chain 273
2104,1280,2104, 468,1288,468, 466,1281,466, 
2, // chain 274
228,214,228, 220,206,220, 222,208,222, 
225,211,225, 
11, // chain 275
2132,1767,2132, 2133,1777,2133, 2134,1769,2134, 
851,1768,851, 33989,1770,1221, 33980,1776,1212, 34901,1777,2133, 850,1775,850, 34903,1778,2135, 34900,1767,2132, 2136,1766,2136, 33617,1765,849, 33619,1768,851, 
21, // chain 276
848,1772,848, 850,1775,850, 2135,1778,2135, 
2137,1779,2137, 34904,1766,2136, 2138,1764,2138, 33617,1765,849, 847,1763,847, 2139,1762,2139, 33613,1761,845, 2140,1760,2140, 33612,1757,844, 2141,1759,2141, 34910,1758,2142, 33614,1756,846, 2143,1773,2143, 33616,1772,848, 2137,1779,2137, 2138,1764,2138, 
2139,1762,2139, 2142,1758,2142, 34908,1760,2140, 2141,1759,2141, 
2, // chain 277
217,203,217, 219,205,219, 212,198,212, 
214,200,214, 
2, // chain 278
211,197,211, 204,190,204, 206,192,206, 
208,194,208, 
4, // chain 279
190,158,190, 193,159,193, 188,160,188, 
32955,179,187, 34657,1643,1889, 32962,180,194, 
2, // chain 280
196,182,196, 199,185,199, 194,180,194, 
32969,187,201, 
4, // chain 281
1890,1642,1890, 1891,1641,1891, 1916,1652,1916, 
34675,1651,1907, 1915,1664,1915, 34682,1663,1914, 
9, // chain 282
444,405,444, 445,406,445, 1571,1899,1571, 
34340,1900,1572, 34912,1901,2144, 34913,1902,2145, 34914,1903,2146, 33214,407,446, 2147,1904,2147, 34916,1905,2148, 33215,408,447, 
3, // chain 283
1889,1643,1889, 1890,1642,1890, 187,179,187, 
32954,178,186, 34684,1652,1916, 
4, // chain 284
866,417,866, 856,428,856, 858,426,858, 
860,424,860, 865,418,865, 33630,420,862, 
2, // chain 285
793,723,793, 2149,1738,2149, 866,417,866, 
792,414,792, 
8, // chain 286
866,417,866, 2149,1738,2149, 856,428,856, 
33622,430,854, 34918,1734,2150, 33561,723,793, 794,725,794, 1219,1736,1219, 33997,1735,1229, 33564,727,796, 
4, // chain 287
1211,1749,1211, 852,432,852, 854,430,854, 
2150,1734,2150, 1220,1737,1220, 33987,1736,1219, 
8, // chain 288
1211,1749,1211, 1220,1737,1220, 2151,1748,2151, 
34920,1747,2152, 2153,1755,2153, 34922,1754,2154, 2155,1753,2155, 34924,1751,2156, 2157,1752,2157, 34926,1750,2158, 
2, // chain 289
180,172,180, 175,167,175, 177,169,177, 
178,170,178, 
1, // chain 290
180,172,180, 182,174,182, 175,167,175, 
8, // chain 291
1219,1736,1219, 1229,1735,1229, 2159,1740,2159, 
34928,1739,2160, 2161,1742,2161, 34930,1741,2162, 2163,1744,2163, 34932,1743,2164, 2165,1746,2165, 34934,1745,2166, 
11, // chain 292
2167,1718,2167, 2168,1715,2168, 2169,1713,2169, 
2151,1710,2151, 33981,1712,1213, 33984,1714,1216, 34936,1715,2168, 2152,1716,2152, 34938,1721,2170, 34935,1718,2167, 2171,1720,2171, 34921,1719,2153, 34919,1710,2151, 
21, // chain 293
2154,1727,2154, 2152,1716,2152, 2170,1721,2170, 
2172,1726,2172, 34939,1720,2171, 2173,1725,2173, 34921,1719,2153, 2155,1724,2155, 2174,1722,2174, 34925,1723,2157, 2175,1731,2175, 34926,1733,2158, 2176,1732,2176, 34945,1729,2177, 34924,1730,2156, 2178,1728,2178, 34922,1727,2154, 2172,1726,2172, 2173,1725,2173, 
2174,1722,2174, 2177,1729,2177, 34943,1731,2175, 2176,1732,2176, 
1, // chain 294
1213,1712,1213, 1211,1711,1211, 2151,1710,2151, 
1, // chain 295
1220,1717,1220, 1216,1714,1216, 2152,1716,2152, 
22, // chain 296
2179,1446,2179, 2180,1449,2180, 2181,1450,2181, 
2182,1451,2182, 34951,1461,2183, 34952,1460,2184, 34948,1449,2180, 2185,1459,2185, 34954,1458,2186, 34955,1448,2187, 34956,1447,2188, 34947,1446,2179, 2189,1444,2189, 34958,1445,2190, 34950,1451,2182, 2191,1452,2191, 34960,1496,2192, 2193,1453,2193, 34962,1495,2194, 
34963,1497,2195, 2196,1498,2196, 2197,1492,2197, 34966,1493,2198, 34967,1499,2199, 
5, // chain 297
2190,1445,2190, 2191,1452,2191, 2193,1453,2193, 
2189,1444,2189, 34968,1454,2200, 34965,1492,2197, 34962,1495,2194, 
25, // chain 298
2200,1454,2200, 2197,1492,2197, 2198,1493,2198, 
2201,1494,2201, 2202,1455,2202, 2189,1444,2189, 34971,1456,2203, 2188,1447,2188, 34955,1448,2187, 34972,1457,2204, 2186,1458,2186, 34973,1538,2205, 34974,1539,2206, 2207,1540,2207, 34976,1906,2208, 2209,1907,2209, 34978,1908,2210, 2211,1909,2211, 2212,1910,2212, 
2213,1911,2213, 34982,1912,2214, 2215,1913,2215, 2216,1914,2216, 2217,1915,2217, 34986,1916,2218, 34125,1917,1357, 1358,1918,1358, 
55, // chain 299
279,262,279, 280,263,280, 2219,486,2219, 
34988,496,2220, 33033,248,265, 2221,508,2221, 33034,249,266, 2222,1571,2222, 34991,1577,2223, 33035,250,267, 2224,1579,2224, 34993,1581,2225, 33036,251,268, 2226,1583,2226, 34995,1668,2227, 33037,252,269, 2228,1669,2228, 33038,253,270, 2229,1670,2229, 
34998,1671,2230, 33039,254,271, 2231,1672,2231, 35000,1699,2232, 33040,255,272, 2233,1679,2233, 35002,1682,2234, 35003,1700,2235, 33041,256,273, 274,257,274, 2236,1576,2236, 33043,258,275, 2237,1570,2237, 33044,259,276, 2238,507,2238, 35007,494,2239, 
33045,260,277, 2240,495,2240, 33046,261,278, 279,262,279, 2219,486,2219, 2241,487,2241, 35010,488,2242, 35011,489,2243, 34988,496,2220, 2244,497,2244, 34989,508,2221, 2245,509,2245, 34990,1571,2222, 2246,1572,2246, 34991,1577,2223, 2247,1578,2247, 
34992,1579,2224, 2248,1580,2248, 34993,1581,2225, 2249,1582,2249, 34994,1583,2226, 2250,1584,2250, 
6, // chain 300
1264,1203,1264, 1266,1205,1266, 2251,1555,2251, 
693,632,693, 33460,631,692, 34040,1213,1272, 34037,1208,1269, 34034,1205,1266, 
16, // chain 301
2240,495,2240, 2241,487,2241, 2239,494,2239, 
35020,493,2252, 35021,492,2253, 35022,491,2254, 35010,488,2242, 2255,490,2255, 35011,489,2243, 2256,500,2256, 35025,499,2257, 35026,498,2258, 35012,497,2244, 2259,510,2259, 35013,509,2245, 2260,1574,2260, 35029,1573,2261, 35014,1572,2246, 
19, // chain 302
2262,1804,2262, 2159,1801,2159, 2161,1794,2161, 
2263,1793,2263, 35032,1785,2264, 34931,1786,2163, 2265,1783,2265, 34933,1787,2165, 2266,1782,2266, 34934,1788,2166, 2267,1789,2267, 35036,1781,2268, 34932,1790,2164, 2269,1784,2269, 34930,1791,2162, 2270,1792,2270, 35039,1803,2271, 34928,1799,2160, 2272,1798,2272, 
33995,1796,1227, 33997,1800,1229, 
5, // chain 303
1218,1795,1218, 2159,1801,2159, 2273,1797,2273, 
1227,1796,1227, 35040,1798,2272, 35030,1804,2262, 34927,1801,2159, 
1, // chain 304
1218,1795,1218, 1219,1802,1219, 2159,1801,2159, 
10, // chain 305
2274,1636,2274, 2275,1630,2275, 2276,1635,2276, 
35045,1623,2277, 35046,1631,2278, 35042,1632,2274, 2279,1633,2279, 2280,1634,2280, 35049,1919,2281, 2282,1920,2282, 2283,1921,2283, 35052,1922,2284, 
6, // chain 306
2285,1923,2285, 2286,1924,2286, 2287,1925,2287, 
2288,1926,2288, 2199,1927,2199, 2196,1928,2196, 2195,1929,2195, 2192,1930,2192, 
11, // chain 307
2289,1431,2289, 1310,1432,1310, 2100,1931,2100, 
362,318,362, 361,317,361, 2290,1434,2290, 35059,1442,2291, 33132,320,364, 2292,1439,2292, 33134,322,366, 2293,1438,2293, 33665,1443,897, 33136,324,368, 
12, // chain 308
2289,1431,2289, 2290,1434,2290, 2294,1433,2294, 
1310,1432,1310, 35063,1436,2295, 35064,1435,2296, 35058,1434,2290, 2291,1442,2291, 2297,1441,2297, 35060,1439,2292, 2298,1440,2298, 35067,1437,2299, 35061,1438,2293, 897,1443,897, 
1, // chain 309
637,575,637, 638,576,638, 1591,1881,1591, 
5, // chain 310
2300,1503,2300, 2301,1513,2301, 2302,1512,2302, 
35071,1514,2303, 35072,1515,2304, 35073,1516,2305, 2306,1517,2306, 
9, // chain 311
2300,1503,2300, 2302,1512,2302, 2307,1502,2307, 
2308,1504,2308, 35077,1505,2309, 2310,1506,2310, 35079,1507,2311, 2312,1508,2312, 35081,1509,2313, 2314,1510,2314, 35083,1511,2315, 
1, // chain 312
639,577,639, 640,578,640, 864,1780,864, 
5, // chain 313
2316,1875,2316, 2317,1874,2317, 2318,1873,2318, 
33128,1872,360, 352,307,352, 32886,1871,118, 351,306,351, 
2, // chain 314
2318,1873,2318, 2319,1877,2319, 2320,1876,2320, 
2316,1875,2316, 
4, // chain 315
354,309,354, 2320,1876,2320, 2319,1877,2319, 
353,308,353, 35086,1873,2318, 352,307,352, 
2, // chain 316
354,309,354, 2321,1879,2321, 2322,1878,2322, 
2320,1876,2320, 
8, // chain 317
2317,1868,2317, 2323,1869,2323, 2324,1867,2324, 
359,314,359, 33123,310,355, 35093,1870,2325, 35091,1869,2323, 2321,1879,2321, 354,309,354, 355,310,355, 
22, // chain 318
2239,494,2239, 2252,493,2252, 2238,507,2238, 
35094,506,2326, 35095,505,2327, 35021,492,2253, 2328,504,2328, 35097,503,2329, 35022,491,2254, 2330,502,2330, 35023,490,2255, 2331,501,2331, 35024,500,2256, 2332,513,2332, 35025,499,2257, 2333,512,2333, 35026,498,2258, 2334,511,2334, 35027,510,2259, 
2277,1575,2277, 35028,1574,2260, 2276,1665,2276, 35103,1666,2335, 35029,1573,2261, 
18, // chain 319
2336,1543,2336, 2337,1544,2337, 2338,1542,2338, 
35107,1528,2339, 35108,1529,2340, 2341,1523,2341, 35110,1524,2342, 35111,1530,2343, 2344,1531,2344, 35113,1545,2345, 2346,144,2346, 35115,1546,2347, 2348,1547,2348, 2349,1548,2349, 2350,145,2350, 35119,1549,2351, 2352,146,2352, 35121,1550,2353, 2210,1551,2210, 
34979,1932,2211, 
18, // chain 320
2339,1528,2339, 2341,1523,2341, 2354,1522,2354, 
2355,1527,2355, 34953,1459,2185, 34952,1460,2184, 35124,1521,2356, 35109,1523,2341, 2357,1520,2357, 35110,1524,2342, 2358,1525,2358, 35112,1531,2344, 2359,143,2359, 35114,144,2346, 2360,134,2360, 35118,145,2350, 2361,137,2361, 35120,146,2352, 2208,147,2208, 
34978,1551,2210, 
6, // chain 321
2339,1528,2339, 2355,1527,2355, 2338,1542,2338, 
35130,1541,2362, 34975,1540,2207, 34973,1538,2205, 34954,1458,2186, 34953,1459,2185, 
14, // chain 322
2363,1465,2363, 2184,1460,2184, 2356,1521,2356, 
2364,1467,2364, 35125,1520,2357, 2365,1468,2365, 35126,1525,2358, 2366,1532,2366, 35135,142,2367, 35127,143,2359, 2368,135,2368, 35128,134,2360, 2369,136,2369, 35129,137,2361, 2206,138,2206, 34976,147,2208, 
42, // chain 323
2183,1461,2183, 2184,1460,2184, 2363,1465,2363, 
2370,1464,2370, 35139,1466,2371, 35132,1467,2364, 2365,1468,2365, 2372,1469,2372, 35141,1470,2373, 35134,1532,2366, 2374,1533,2374, 35143,1553,2375, 35144,1552,2376, 35135,142,2367, 2377,141,2377, 35136,135,2368, 2378,140,2378, 35147,139,2379, 35137,136,2369, 
2206,138,2206, 2204,1491,2204, 2203,1489,2203, 2378,140,2378, 35148,1490,2380, 35149,1487,2381, 34970,1488,2202, 2201,1485,2201, 2382,1486,2382, 35151,1481,2383, 34966,1484,2198, 2199,1483,2199, 2288,1482,2288, 2287,1479,2287, 2384,1480,2384, 35153,1476,2385, 
35054,1478,2286, 2386,1477,2386, 2387,1475,2387, 2388,1474,2388, 35157,1472,2389, 2390,1473,2390, 35141,1470,2373, 35159,1471,2391, 2372,1469,2372, 
22, // chain 324
2385,1476,2385, 2388,1474,2388, 2384,1480,2384, 
35160,1537,2392, 35158,1473,2390, 2381,1487,2381, 35148,1490,2380, 35161,1536,2393, 35162,1535,2394, 35141,1470,2373, 2395,1534,2395, 35142,1533,2374, 2394,1535,2394, 35161,1536,2393, 35164,1554,2396, 35143,1553,2375, 2397,1933,2397, 35144,1552,2376, 2377,141,2377, 
2398,1934,2398, 35164,1554,2396, 35146,140,2378, 2380,1490,2380, 2393,1536,2393, 
4, // chain 325
2399,588,2399, 2400,1220,2400, 2337,1221,2337, 
2336,589,2336, 2401,586,2401, 34986,590,2218, 
3, // chain 326
2384,1480,2384, 2392,1537,2392, 2383,1481,2383, 
35150,1486,2382, 35149,1487,2381, 
11, // chain 327
2402,614,2402, 2337,1219,2337, 2400,1220,2400, 
2403,587,2403, 35167,588,2399, 2401,586,2401, 2404,583,2404, 34986,585,2218, 1358,584,1358, 608,580,608, 2405,581,2405, 35174,579,2406, 33359,1935,591, 
8, // chain 328
326,294,326, 327,295,327, 2407,1811,2407, 
35176,1810,2408, 35177,1809,2409, 33096,296,328, 2410,1808,2410, 33097,297,329, 1382,1805,1382, 33098,298,330, 
4, // chain 329
2410,1808,2410, 1382,1805,1382, 1369,1858,1369, 
2409,1809,2409, 34121,1857,1353, 34138,1859,1370, 
19, // chain 330
2411,598,2411, 2412,611,2412, 2413,599,2413, 
2414,592,2414, 35183,600,2415, 35170,614,2402, 35108,613,2340, 35111,612,2343, 35180,611,2412, 2345,1222,2345, 35184,610,2416, 35179,598,2411, 2417,597,2417, 35186,593,2418, 35182,592,2414, 2419,591,2419, 35183,600,2415, 2420,601,2420, 35189,615,2421, 
35171,587,2403, 35170,614,2402, 
9, // chain 331
2422,1863,2422, 2407,1811,2407, 2423,1936,2423, 
2424,1862,2424, 35193,1861,2425, 35194,1855,2426, 35175,1811,2407, 1354,1856,1354, 35176,1810,2408, 1353,1857,1353, 35177,1809,2409, 
31, // chain 332
2427,1415,2427, 2428,1603,2428, 2429,1416,2429, 
2430,1414,2430, 35199,1417,2431, 35200,1425,2432, 35201,1426,2433, 35202,1599,2434, 35203,1600,2435, 35196,1603,2428, 2436,1602,2436, 35205,1604,2437, 35206,1613,2438, 35195,1415,2427, 2307,1614,2307, 35077,1621,2309, 35079,1412,2311, 35198,1414,2430, 2439,1413,2439, 
35208,1418,2440, 35199,1417,2431, 2441,1422,2441, 35200,1425,2432, 2442,1428,2442, 35211,1427,2443, 35201,1426,2433, 2444,1612,2444, 35213,1597,2445, 35202,1599,2434, 2226,1598,2226, 35203,1600,2435, 2250,1601,2250, 35204,1602,2436, 
2, // chain 333
2438,1613,2438, 2307,1614,2307, 2437,1604,2437, 
35070,1615,2302, 
1, // chain 334
2436,1602,2436, 2437,1604,2437, 2446,1605,2446, 
25, // chain 335
2302,1619,2302, 2303,1617,2303, 2437,1585,2437, 
35215,1587,2447, 35216,1616,2448, 35072,1618,2304, 2449,1606,2449, 35074,1620,2306, 2450,1607,2450, 35073,1937,2305, 2451,1595,2451, 35069,1609,2301, 2452,1596,2452, 35068,1610,2300, 2308,1611,2308, 2444,1612,2444, 35078,1430,2310, 2443,1427,2443, 35210,1428,2442, 
35080,1429,2312, 2453,1423,2453, 35082,1424,2314, 2454,1419,2454, 35083,1420,2315, 2439,1413,2439, 35081,1421,2313, 2311,1412,2311, 
5, // chain 336
2455,1588,2455, 2448,1616,2448, 2456,1590,2456, 
2229,1589,2229, 35225,1591,2457, 35217,1606,2449, 35216,1616,2448, 
3, // chain 337
2447,1587,2447, 2448,1616,2448, 2455,1588,2455, 
2446,1586,2446, 34997,1589,2229, 
1, // chain 338
2447,1587,2447, 2446,1586,2446, 2437,1585,2437, 
27, // chain 339
2230,1671,2230, 2231,1672,2231, 2229,1670,2229, 
35214,1673,2446, 35226,1674,2458, 35000,1699,2232, 2459,1676,2459, 35001,1679,2233, 2249,1678,2249, 35016,1680,2248, 35015,1681,2247, 35002,1682,2234, 2460,1683,2460, 35003,1700,2235, 2461,1701,2461, 35004,1576,2236, 2462,1702,2462, 35231,1569,2463, 35005,1570,2237, 
2464,1559,2464, 35006,507,2238, 2465,1561,2465, 35094,506,2326, 2466,1562,2466, 35235,1938,2467, 35236,1939,2468, 35095,505,2327, 2469,1940,2469, 35096,504,2328, 
5, // chain 340
2450,1607,2450, 2451,1595,2451, 2470,1593,2470, 
34995,1594,2227, 35220,1596,2452, 2445,1597,2445, 35212,1612,2444, 
4, // chain 341
2449,1606,2449, 2450,1607,2450, 2470,1593,2470, 
2457,1591,2457, 34996,1592,2228, 34995,1594,2227, 
4, // chain 342
2436,1675,2436, 2446,1673,2446, 2458,1674,2458, 
2459,1676,2459, 2250,1677,2250, 35017,1678,2249, 
4, // chain 343
2246,1684,2246, 2247,1681,2247, 2460,1683,2460, 
2471,1568,2471, 35230,1702,2462, 35229,1701,2461, 
1, // chain 344
2229,1589,2229, 2457,1591,2457, 2228,1592,2228, 
10, // chain 345
2472,1560,2472, 2463,1569,2463, 2464,1559,2464, 
2465,1561,2465, 2473,1563,2473, 35234,1562,2466, 2474,1941,2474, 35235,1938,2467, 2475,1942,2475, 35244,1692,2476, 35245,1943,2477, 35236,1939,2468, 
14, // chain 346
2463,1569,2463, 2472,1560,2472, 2471,1568,2471, 
35246,1567,2478, 35247,1566,2479, 35248,1565,2480, 35249,1564,2481, 35241,1563,2473, 2474,1941,2474, 2475,1942,2475, 2482,1690,2482, 35244,1692,2476, 2483,1691,2483, 35252,1693,2484, 35253,1694,2485, 35245,1943,2477, 
1, // chain 347
2463,1569,2463, 2471,1568,2471, 2462,1702,2462, 
11, // chain 348
2471,1568,2471, 2478,1567,2478, 2246,1684,2246, 
35029,1685,2261, 35103,1686,2335, 35247,1566,2479, 2274,1687,2274, 35047,1688,2279, 35248,1565,2480, 2281,1689,2281, 35249,1564,2481, 2482,1690,2482, 2483,1691,2483, 
1, // chain 349
2445,1597,2445, 2226,1598,2226, 2227,1594,2227, 
4, // chain 350
2441,1422,2441, 2442,1428,2442, 2453,1423,2453, 
2454,1419,2454, 2440,1418,2440, 35207,1413,2439, 
1, // chain 351
2335,1666,2335, 2274,1667,2274, 2276,1665,2276, 
3, // chain 352
2333,512,2333, 2486,1944,2486, 2332,513,2332, 
35255,1945,2487, 35256,1946,2488, 
4, // chain 353
2332,513,2332, 2487,1945,2487, 2489,1947,2489, 
35258,1948,2490, 2491,1949,2491, 35260,1950,2492, 
5, // chain 354
2331,501,2331, 2332,513,2332, 2493,514,2493, 
2494,515,2494, 35263,1951,2495, 35257,1947,2489, 35100,513,2332, 
1, // chain 355
2495,1951,2495, 2489,1947,2489, 2491,1949,2491, 
2, // chain 356
2330,502,2330, 2331,501,2331, 2494,515,2494, 
2329,503,2329, 
3, // chain 357
2496,1695,2496, 2491,1697,2491, 2492,1696,2492, 
2484,1693,2484, 2485,1694,2485, 
4, // chain 358
2497,1952,2497, 2498,1953,2498, 2284,1954,2284, 
2282,1955,2282, 2333,1956,2333, 35049,1957,2281, 
26, // chain 359
2499,1958,2499, 2500,1959,2500, 2501,620,2501, 
2502,619,2502, 35271,602,2503, 35272,603,2504, 35273,604,2505, 35274,621,2506, 35268,1959,2500, 2507,1960,2507, 35276,1961,2508, 35277,1962,2509, 35267,1958,2499, 2510,1963,2510, 35279,1964,2511, 35270,619,2502, 2512,618,2512, 35271,602,2503, 2513,617,2513, 
35188,601,2420, 35187,591,2419, 35272,603,2504, 2505,604,2505, 2514,594,2514, 35283,605,2515, 35274,621,2506, 2516,622,2516, 35275,1960,2507, 
4, // chain 360
2514,594,2514, 2515,605,2515, 2517,595,2517, 
35286,606,2518, 35287,623,2519, 35284,622,2516, 
4, // chain 361
2517,595,2517, 2518,606,2518, 2520,596,2520, 
35289,607,2521, 35290,624,2522, 35287,623,2519, 
3, // chain 362
2517,595,2517, 2520,596,2520, 2418,593,2418, 
2514,594,2514, 35187,591,2419, 
2, // chain 363
2523,608,2523, 2521,607,2521, 2522,1965,2522, 
2524,1966,2524, 
7, // chain 364
2524,1967,2524, 2348,1968,2348, 2523,608,2523, 
35293,609,2525, 35115,1969,2347, 2416,610,2416, 2417,597,2417, 2520,596,2520, 35186,593,2418, 
2, // chain 365
2523,608,2523, 2525,609,2525, 2520,596,2520, 
2521,607,2521, 
1, // chain 366
2347,1223,2347, 2345,1222,2345, 2416,610,2416, 
5, // chain 367
2526,335,2526, 2491,351,2491, 2527,352,2527, 
2528,336,2528, 35297,337,2529, 35264,353,2496, 35259,351,2491, 
25, // chain 368
2530,346,2530, 2531,334,2531, 2532,333,2532, 
2533,345,2533, 35302,344,2534, 35303,332,2535, 35304,327,2536, 35299,334,2531, 2526,335,2526, 35305,348,2537, 35306,347,2538, 35298,346,2530, 2539,1970,2539, 35308,1971,2540, 35309,1972,2541, 35301,345,2533, 2542,1973,2542, 35311,1974,2543, 35302,344,2534, 
2544,343,2544, 35313,331,2545, 35303,332,2535, 2546,328,2546, 35304,327,2536, 2547,326,2547, 35296,336,2528, 35294,335,2526, 
58, // chain 369
2529,337,2529, 2496,353,2496, 2485,354,2485, 
2548,355,2548, 35317,356,2549, 35245,397,2477, 2550,357,2550, 35236,396,2468, 2469,394,2469, 2551,395,2551, 35320,393,2552, 35096,392,2328, 2553,391,2553, 35097,390,2329, 2554,387,2554, 35262,389,2494, 2495,388,2495, 2555,1975,2555, 2556,384,2556, 
35325,385,2557, 2537,383,2537, 2558,382,2558, 35306,381,2538, 2559,380,2559, 35307,379,2539, 2560,378,2560, 35308,377,2540, 2561,376,2561, 35330,375,2562, 2563,372,2563, 35332,374,2564, 2565,373,2565, 35334,366,2566, 2567,363,2567, 35336,365,2568, 
35337,367,2569, 2570,368,2570, 35339,1976,2571, 2572,1977,2572, 35341,1978,2573, 2574,1979,2574, 2575,1980,2575, 35344,1981,2576, 2577,1982,2577, 35346,1983,2578, 2579,1984,2579, 35348,1985,2580, 2581,1986,2581, 35350,1987,2582, 2583,1988,2583, 35352,1989,2584, 
35353,1990,2585, 2586,360,2586, 35355,361,2587, 2588,341,2588, 35357,362,2589, 2590,342,2590, 2591,330,2591, 35313,331,2545, 35312,343,2544, 
51, // chain 370
2547,326,2547, 2528,336,2528, 2529,337,2529, 
2592,338,2592, 35316,355,2548, 2549,356,2549, 2593,339,2593, 35318,357,2550, 2594,358,2594, 35363,1991,2595, 35319,395,2551, 2596,1992,2596, 35365,1993,2597, 35320,393,2552, 2598,1994,2598, 35321,391,2553, 2554,387,2554, 2599,1995,2599, 35324,384,2556, 
2558,382,2558, 2559,380,2559, 2600,1996,2600, 35328,378,2560, 2601,1997,2601, 35329,376,2561, 2602,371,2602, 35331,372,2563, 2603,364,2603, 35333,373,2565, 2567,363,2567, 2568,365,2568, 2604,369,2604, 35338,368,2570, 2572,1977,2572, 2605,1998,2605, 
35343,1980,2575, 2577,1982,2577, 2606,1999,2606, 35347,1984,2579, 2581,1986,2581, 2607,2000,2607, 35351,1988,2583, 2608,2001,2608, 35377,2002,2609, 35352,1989,2584, 2586,360,2586, 2610,359,2610, 35356,341,2588, 2611,340,2611, 35380,329,2612, 35359,330,2591, 
2546,328,2546, 35313,331,2545, 
24, // chain 371
2612,329,2612, 2546,328,2546, 2547,326,2547, 
2592,338,2592, 2593,339,2593, 2611,340,2611, 35362,358,2594, 2610,359,2610, 35381,2003,2613, 35363,1991,2595, 2596,1992,2596, 2597,1993,2597, 2614,2004,2614, 35383,2005,2615, 35366,1994,2598, 2599,1995,2599, 2600,1996,2600, 2616,2006,2616, 35369,1997,2601, 
2617,2007,2617, 35370,371,2602, 2618,370,2618, 35371,364,2603, 2604,369,2604, 2606,1999,2606, 35373,1998,2605, 
5, // chain 372
2610,359,2610, 2613,2003,2613, 2609,2002,2609, 
35376,2001,2608, 35382,2004,2614, 2616,2006,2616, 35383,2005,2615, 
10, // chain 373
2541,1972,2541, 2542,1973,2542, 2619,2008,2619, 
2540,1971,2540, 35330,2009,2562, 35388,2010,2620, 35389,2011,2621, 35310,1973,2542, 2622,2012,2622, 35311,1974,2543, 2623,2013,2623, 35312,343,2544, 
6, // chain 374
2622,2012,2622, 2623,2013,2623, 2624,2014,2624, 
2625,2015,2625, 2621,2011,2621, 35388,2010,2620, 35332,2016,2564, 2562,2009,2562, 
4, // chain 375
2526,335,2526, 2537,348,2537, 2557,349,2557, 
2555,350,2555, 2491,351,2491, 35263,2017,2495, 
8, // chain 376
2524,2018,2524, 2522,2019,2522, 2626,2020,2626, 
2627,2021,2627, 35396,2022,2628, 32889,121,121, 35397,2023,2629, 35398,2024,2630, 35290,2019,2522, 2631,2025,2631, 
9, // chain 377
2349,2026,2349, 2348,2027,2348, 2524,2018,2524, 
2632,2028,2632, 35395,2021,2627, 2633,473,2633, 35402,2029,2634, 35396,2022,2628, 2635,2030,2635, 32890,122,122, 32889,121,121, 
21, // chain 378
2212,2031,2212, 2211,468,2211, 2636,467,2636, 
2424,1862,2424, 35405,2032,2637, 35406,466,2638, 35407,462,2639, 34979,468,2211, 2353,469,2353, 2640,461,2640, 35119,470,2351, 2349,2026,2349, 2632,2028,2632, 529,464,529, 35401,473,2633, 528,474,528, 33295,475,527, 35402,2029,2634, 2641,2033,2641, 
35403,2030,2635, 2642,2034,2642, 32891,123,123, 32890,122,122, 
7, // chain 379
2637,2032,2637, 2638,466,2638, 2643,485,2643, 
33300,455,532, 33299,478,531, 33298,463,530, 35407,462,2639, 2640,461,2640, 529,464,529, 
10, // chain 380
2644,2035,2644, 2641,2033,2641, 2642,2034,2642, 
2645,2033,2645, 35414,2030,2646, 32891,123,123, 124,122,124, 2647,2022,2647, 35416,121,2648, 34607,109,1839, 32893,110,125, 126,108,126, 
17, // chain 381
527,475,527, 2641,2033,2641, 526,476,526, 
35412,2035,2644, 525,477,525, 33292,476,524, 35413,2033,2645, 523,475,523, 35417,2029,2649, 35414,2030,2646, 2647,2022,2647, 2650,2021,2650, 35419,2020,2651, 35416,121,2648, 1637,2023,1637, 34407,120,1639, 34607,109,1839, 1840,119,1840, 1632,2036,1632, 
16, // chain 382
2652,482,2652, 534,453,534, 535,479,535, 
2653,2037,2653, 35422,2038,2654, 33304,480,536, 2655,2039,2655, 33305,481,537, 2656,2040,2656, 35425,2039,2657, 33306,480,538, 2658,2038,2658, 33307,479,539, 2659,2037,2659, 33308,482,540, 2047,1864,2047, 2660,2041,2660, 34816,1865,2048, 
7, // chain 383
2661,1815,2661, 324,292,324, 2662,1814,2662, 
2652,482,2652, 35431,483,2663, 35432,484,2664, 35433,1813,2665, 33093,293,325, 33092,292,324, 
9, // chain 384
534,453,534, 2652,482,2652, 2663,483,2663, 
533,454,533, 35432,484,2664, 532,455,532, 35411,485,2643, 35433,1813,2665, 2666,1812,2666, 33094,294,326, 33093,293,325, 
3, // chain 385
2422,1863,2422, 2643,485,2643, 2666,1812,2666, 
2407,1811,2407, 33094,294,326, 
2, // chain 386
2637,2032,2637, 2643,485,2643, 2422,1863,2422, 
2424,1862,2424, 
2, // chain 387
2214,2042,2214, 2212,2031,2212, 2424,1862,2424, 
2425,1861,2425, 
24, // chain 388
2667,616,2667, 2421,615,2421, 2403,587,2403, 
2404,583,2404, 2668,582,2668, 35173,581,2405, 2406,579,2406, 2669,2043,2669, 33359,2044,591, 2670,2045,2670, 2671,2046,2671, 2672,2047,2672, 35279,1964,2511, 35441,2048,2673, 2510,1963,2510, 35442,2049,2674, 2675,2050,2675, 35444,2051,2676, 2677,2052,2677, 
35446,2053,2678, 2679,2054,2679, 33125,2055,357, 2680,2056,2680, 2509,1962,2509, 35276,1961,2508, 35275,1960,2507, 
7, // chain 389
2420,601,2420, 2421,615,2421, 2667,616,2667, 
2513,617,2513, 35436,582,2668, 2669,2043,2669, 2672,2047,2672, 2512,618,2512, 35279,1964,2511, 
1, // chain 390
317,284,317, 318,286,318, 316,285,316, 
3, // chain 391
449,1519,449, 441,1197,441, 320,288,320, 
321,289,321, 322,290,322, 
8, // chain 392
448,1819,448, 322,290,322, 2681,1818,2681, 
2564,1820,2564, 35334,1817,2566, 33090,290,322, 323,291,323, 2682,1816,2682, 35429,1815,2661, 33092,292,324, 
11, // chain 393
448,1819,448, 2564,1820,2564, 2625,1821,2625, 
447,1822,447, 35392,1823,2624, 2148,1824,2148, 35451,1825,2683, 35391,2057,2623, 2544,2058,2544, 2684,1828,2684, 35358,2059,2590, 2685,1829,2685, 35357,2060,2589, 
5, // chain 394
2148,1824,2148, 2683,1825,2683, 2686,1826,2686, 
35455,1827,2687, 35452,1828,2684, 2685,1829,2685, 2688,1830,2688, 
1, // chain 395
120,120,120, 686,2036,686, 119,119,119, 
1, // chain 396
2629,2023,2629, 120,120,120, 121,121,121, 
1, // chain 397
358,1709,358, 117,117,117, 118,118,118, 
1, // chain 398
2340,613,2340, 2337,1219,2337, 2402,614,2402, 
53, // chain 399
2654,2038,2654, 2655,2039,2655, 2689,2061,2689, 
35458,2062,2690, 35424,2040,2656, 2691,2063,2691, 35460,2062,2692, 35425,2039,2657, 2693,2061,2693, 35426,2038,2658, 2659,2037,2659, 2694,2064,2694, 35428,2041,2660, 2695,2065,2695, 2696,2066,2696, 2697,2067,2697, 35466,2068,2698, 2699,2069,2699, 35468,2070,2700, 
2701,2071,2701, 35470,2072,2702, 2703,2073,2703, 2704,2074,2704, 35473,2075,2705, 33173,2076,405, 406,2077,406, 2030,2078,2030, 2706,2079,2706, 34799,2080,2031, 2707,2081,2707, 35476,2082,2708, 2688,2080,2688, 2709,2079,2709, 35453,2078,2685, 2710,2075,2710, 
35357,2077,2589, 2587,2076,2587, 2585,2073,2585, 2711,2074,2711, 35480,2071,2712, 35350,2072,2582, 2580,2070,2580, 2713,2069,2713, 35346,2068,2578, 2714,2067,2714, 35344,2066,2576, 2715,2064,2715, 35342,2065,2574, 2573,2041,2573, 2653,2037,2653, 35484,1864,2716, 
35339,1865,2571, 2682,1816,2682, 35337,1866,2569, 2566,1817,2566, 
7, // chain 400
2717,2083,2717, 2690,2062,2690, 2691,2063,2691, 
2692,2062,2692, 2718,2084,2718, 35487,2085,2719, 35461,2061,2693, 2697,2067,2697, 35462,2064,2694, 
3, // chain 401
2689,2061,2689, 2714,2067,2714, 2715,2064,2715, 
2653,2037,2653, 2654,2038,2654, 
3, // chain 402
2652,482,2652, 2653,2037,2653, 2716,1864,2716, 
2682,1816,2682, 2661,1815,2661, 
12, // chain 403
2720,2086,2720, 2721,2087,2721, 2722,2088,2722, 
2507,2089,2507, 35284,2090,2516, 35489,2087,2721, 2519,2091,2519, 35491,2092,2723, 35492,2093,2724, 35488,2086,2720, 349,2094,349, 33116,2095,348, 35448,2096,2680, 35275,2089,2507, 
1, // chain 404
357,2097,357, 348,2095,348, 2680,2096,2680, 
12, // chain 405
2522,2098,2522, 2519,2091,2519, 2723,2092,2723, 
2631,2099,2631, 35493,2100,2725, 35492,2093,2724, 2726,2101,2726, 33117,2094,349, 350,2102,350, 689,2103,689, 33119,2104,351, 686,2105,686, 32886,2106,118, 119,2107,119, 
2, // chain 406
2631,2099,2631, 2725,2100,2725, 2630,2108,2630, 
35397,2109,2629, 
5, // chain 407
2362,1541,2362, 2207,1540,2207, 2727,2110,2727, 
2217,1915,2217, 34981,1911,2213, 34977,1907,2209, 34975,1540,2207, 
3, // chain 408
2217,1915,2217, 2218,1916,2218, 2336,1543,2336, 
2362,1541,2362, 35106,1542,2338, 
3, // chain 409
2677,2052,2677, 2679,2054,2679, 2509,1962,2509, 
2675,2050,2675, 35278,1963,2510, 
9, // chain 410
2728,2111,2728, 2707,2081,2707, 2729,2112,2729, 
2717,2083,2717, 35498,2084,2730, 35481,2069,2713, 35499,2113,2731, 35475,2081,2707, 2709,2079,2709, 2711,2074,2711, 35478,2075,2710, 
2, // chain 411
2731,2113,2731, 2711,2074,2711, 2713,2069,2713, 
35480,2071,2712, 
6, // chain 412
2690,2062,2690, 2717,2083,2717, 2730,2084,2730, 
2732,2085,2732, 35481,2069,2713, 2714,2067,2714, 2689,2061,2689, 2690,2062,2690, 
1, // chain 413
355,310,355, 356,311,356, 359,314,359, 
1, // chain 414
360,315,360, 2317,1868,2317, 359,314,359, 
1, // chain 415
637,575,637, 1339,1302,1339, 636,574,636, 
1, // chain 416
2398,1934,2398, 2396,1554,2396, 2397,1933,2397, 
6, // chain 417
2278,1631,2278, 2280,1634,2280, 2733,1622,2733, 
35502,1625,2734, 35051,1921,2283, 2735,1628,2735, 35266,2114,2498, 35052,2115,2284, 
7, // chain 418
2498,1629,2498, 2497,1627,2497, 2735,1628,2735, 
35502,1625,2734, 35101,1626,2333, 2334,1624,2334, 2733,1622,2733, 35045,1623,2277, 2278,1631,2278, 
4, // chain 419
2606,1999,2606, 2607,2000,2607, 2618,370,2618, 
35385,2007,2617, 35376,2001,2608, 2616,2006,2616, 
8, // chain 420
2271,1803,2271, 2262,1804,2262, 2263,1793,2263, 
2270,1792,2270, 35032,1785,2264, 2269,1784,2269, 35033,1783,2265, 2268,1781,2268, 35034,1782,2266, 2267,1789,2267, 
1, // chain 421
2271,1803,2271, 2272,1798,2272, 2262,1804,2262, 
1, // chain 422
1269,1208,1269, 1270,1209,1270, 1272,1213,1272, 
6, // chain 423
1272,1213,1272, 1273,1215,1273, 692,631,692, 
33459,630,691, 33458,629,690, 34042,1216,1274, 2629,1558,2629, 32888,1217,120, 
3, // chain 424
2726,1556,2726, 689,628,689, 690,629,690, 
2725,1557,2725, 35397,1558,2629, 
3, // chain 425
2736,1462,2736, 2182,1451,2182, 2183,1461,2183, 
2737,1463,2737, 35138,1464,2370, 
4, // chain 426
69,2116,69, 68,2117,68, 1251,2118,1251, 
71,2119,71, 32904,2120,136, 73,2121,73, 
3, // chain 427
2738,1997,2738, 2739,2007,2739, 415,371,415, 
420,376,420, 33184,372,416, 
4, // chain 428
2739,2007,2739, 2738,1997,2738, 2740,2006,2740, 
35509,1996,2741, 33190,378,422, 33188,376,420, 
7, // chain 429
2742,2001,2742, 2739,2007,2739, 2740,2006,2740, 
2743,2004,2743, 35512,2005,2744, 35509,1996,2741, 2745,1995,2745, 33192,380,424, 33190,378,422, 
17, // chain 430
426,384,426, 427,387,427, 2745,1995,2745, 
35514,1994,2746, 33199,391,431, 433,393,433, 2747,1993,2747, 33203,395,435, 2748,1992,2748, 35517,1991,2749, 33169,357,401, 402,358,402, 2750,2003,2750, 33171,359,403, 2751,2002,2751, 33172,360,404, 2752,1989,2752, 35471,1990,2703, 33173,361,405, 
6, // chain 431
2744,2005,2744, 2745,1995,2745, 2746,1994,2746, 
2747,1993,2747, 2743,2004,2743, 35518,2003,2750, 35516,1992,2748, 2749,1991,2749, 
1, // chain 432
395,351,395, 396,352,396, 397,353,397, 
1, // chain 433
395,351,395, 428,2017,428, 394,350,394, 
19, // chain 434
390,346,390, 391,347,391, 423,1970,423, 
421,1971,421, 2753,1972,2753, 35522,2008,2754, 33187,2009,419, 2755,2010,2755, 33186,2016,418, 2022,2015,2022, 2756,2011,2756, 35525,2012,2757, 34792,2014,2024, 2758,2013,2758, 2759,1974,2759, 33155,343,387, 388,344,388, 389,345,389, 2760,1973,2760, 
35521,1972,2753, 33158,346,390, 
4, // chain 435
2755,2010,2755, 2756,2011,2756, 2754,2008,2754, 
35528,1973,2760, 35525,2012,2757, 2759,1974,2759, 
1, // chain 436
2754,2008,2754, 2760,1973,2760, 2753,1972,2753, 
15, // chain 437
2703,1990,2703, 2702,1987,2702, 2752,1989,2752, 
35529,1988,2761, 35530,1986,2762, 35468,1985,2700, 2763,1984,2763, 35466,1983,2698, 2764,1982,2764, 35464,1981,2696, 2765,1980,2765, 35463,1979,2695, 2766,1977,2766, 35428,1978,2660, 2048,1976,2048, 412,368,412, 33179,367,411, 
13, // chain 438
2761,1988,2761, 2762,1986,2762, 2767,2000,2767, 
2742,2001,2742, 35507,2007,2739, 33182,370,414, 35536,1999,2768, 35530,1986,2762, 2763,1984,2763, 2764,1982,2764, 2769,1998,2769, 35533,1980,2765, 2766,1977,2766, 413,369,413, 33180,368,412, 
4, // chain 439
2751,2002,2751, 2752,1989,2752, 2761,1988,2761, 
2742,2001,2742, 2750,2003,2750, 35511,2004,2743, 
1, // chain 440
414,370,414, 415,371,415, 2739,2007,2739, 
2, // chain 441
413,369,413, 414,370,414, 2768,1999,2768, 
2769,1998,2769, 
7, // chain 442
2770,1698,2770, 1909,1661,1909, 244,230,244, 
245,231,245, 247,233,247, 250,236,250, 251,154,251, 1909,1661,1909, 33020,153,252, 
1, // chain 443
1909,1661,1909, 242,228,242, 244,230,244, 
3, // chain 444
438,398,438, 1575,2122,1575, 439,399,439, 
34912,1901,2144, 34340,1900,1572, 
10, // chain 445
439,399,439, 2144,1901,2144, 2145,1902,2145, 
2023,2123,2023, 34793,2124,2025, 35539,2125,2771, 34914,1903,2146, 2772,2126,2772, 34915,1904,2147, 2773,2127,2773, 35454,2128,2686, 34916,1905,2148, 
1, // chain 446
440,400,440, 439,399,439, 2023,2123,2023, 
7, // chain 447
2027,2129,2027, 2771,2125,2771, 2774,2130,2774, 
2028,2131,2028, 35543,2132,2775, 35544,2133,2776, 35545,2134,2777, 35540,2126,2772, 35539,2125,2771, 
1, // chain 448
2027,2129,2027, 2025,2124,2025, 2771,2125,2771, 
5, // chain 449
2777,2134,2777, 2772,2126,2772, 2773,2127,2773, 
2776,2133,2776, 35546,2135,2778, 35455,2136,2687, 35454,2128,2686, 
3, // chain 450
2776,2133,2776, 2778,2135,2778, 2708,2137,2708, 
35456,2138,2688, 35455,2136,2687, 
3, // chain 451
2776,2133,2776, 2708,2137,2708, 2775,2132,2775, 
34799,2139,2031, 2028,2131,2028, 
1, // chain 452
1212,1776,1212, 850,1775,850, 852,1774,852, 
1, // chain 453
1221,1770,1221, 853,1771,853, 851,1768,851, 
10, // chain 454
1913,1707,1913, 230,216,230, 231,217,231, 
234,220,234, 1912,1708,1912, 33003,221,235, 1911,1659,1911, 33005,223,237, 1910,1660,1910, 33007,225,239, 240,226,240, 242,228,242, 
6, // chain 455
2426,2140,2426, 1354,1329,1354, 1355,1330,1355, 
2425,2141,2425, 34124,1331,1356, 2215,2142,2215, 34984,2143,2216, 34125,1332,1357, 
1, // chain 456
2214,2144,2214, 2425,2141,2425, 2215,2142,2215, 
10, // chain 457
1999,550,1999, 1985,551,1985, 1986,549,1986, 
1987,547,1987, 1997,558,1997, 35547,557,2779, 34756,556,1988, 2780,572,2780, 34757,571,1989, 2781,573,2781, 34885,1299,2117, 34758,1298,1990, 
3, // chain 458
2779,557,2779, 2780,572,2780, 2781,573,2781, 
2118,574,2118, 34885,1299,2117, 
1, // chain 459
2779,557,2779, 2118,574,2118, 1997,558,1997, 
3, // chain 460
2091,1880,2091, 2092,72,2092, 2095,70,2095, 
2090,64,2090, 34865,66,2097, 
1, // chain 461
1310,714,1310, 1236,716,1236, 2100,715,2100, 
5, // chain 462
2060,302,2060, 2064,307,2064, 2072,308,2072, 
2073,301,2073, 2059,300,2059, 34824,311,2056, 34823,310,2055, 
2, // chain 463
2064,307,2064, 2065,1873,2065, 2072,308,2072, 
34836,1877,2068, 
2, // chain 464
2782,2031,2782, 1404,2042,1404, 2045,1862,2045, 
34171,1861,1403, 
2, // chain 465
1393,1805,1393, 2012,1808,2012, 1394,1858,1394, 
34781,1809,2013, 
5, // chain 466
1985,551,1985, 1999,550,1999, 455,560,455, 
454,561,454, 1984,562,1984, 33220,1322,452, 1940,1321,1940, 
6, // chain 467
2046,1863,2046, 543,485,543, 2783,2032,2783, 
33282,466,514, 515,467,515, 2045,1862,2045, 35550,2031,2782, 33284,468,516, 
1, // chain 468
2783,2032,2783, 2045,1862,2045, 2046,1863,2046, 
1, // chain 469
1934,1770,1934, 1936,1776,1936, 1933,1769,1933, 
9, // chain 470
521,473,521, 522,474,522, 523,475,523, 
2649,2029,2649, 2650,2021,2650, 520,472,520, 35552,2018,2784, 35419,2020,2651, 685,2019,685, 35553,2024,2785, 34405,2023,1637, 
2, // chain 471
519,471,519, 520,472,520, 2784,2018,2784, 
1605,2027,1605, 
4, // chain 472
2786,1942,2786, 1759,1690,1759, 1761,1692,1761, 
2787,1938,2787, 33205,1943,437, 33166,1694,398, 
8, // chain 473
2786,1942,2786, 2787,1938,2787, 2788,1941,2788, 
1645,1564,1645, 34412,1563,1644, 34411,1562,1643, 35555,1938,2787, 564,506,564, 33204,1939,436, 33205,1943,437, 
1, // chain 474
1645,1564,1645, 1759,1690,1759, 2786,1942,2786, 
1, // chain 475
2789,2025,2789, 685,2019,685, 2785,2024,2785, 
2, // chain 476
1786,211,1786, 1787,208,1787, 1784,214,1784, 
34556,206,1788, 
5, // chain 477
1808,1698,1808, 1764,236,1764, 1765,233,1765, 
1768,231,1768, 1744,1661,1744, 34538,230,1770, 1743,228,1743, 
4, // chain 478
2790,1922,2790, 2791,1920,2791, 2792,1921,2792, 
34481,1634,1713, 34526,1919,1758, 1712,1633,1712, 
5, // chain 479
1704,1622,1704, 1705,1625,1705, 1713,1634,1713, 
35560,1921,2792, 34475,1628,1707, 1708,2114,1708, 2790,2115,2790, 
21, // chain 480
595,533,595, 596,534,596, 1279,2145,1279, 
594,532,594, 34052,2146,1284, 593,531,593, 34053,2147,1285, 2793,2148,2793, 2794,2149,2794, 35563,2150,2795, 2796,2151,2796, 32829,2152,61, 2797,2153,2797, 35441,2154,2673, 2671,2155,2671, 2798,2156,2798, 35567,2157,2799, 35438,2158,2670, 2800,2159,2800, 
33359,529,591, 592,530,592, 2794,2149,2794, 33361,531,593, 
4, // chain 481
1549,2117,1549, 2096,2116,2096, 1550,2118,1550, 
34862,2119,2094, 1841,2120,1841, 34604,2121,1836, 
23, // chain 482
2801,1961,2801, 2802,1960,2802, 2803,2056,2803, 
2804,1962,2804, 35573,2054,2805, 34825,2055,2057, 2806,2053,2806, 2807,2052,2807, 35576,2051,2808, 2809,2050,2809, 35578,2049,2810, 2811,1963,2811, 34187,2048,1419, 2812,1964,2812, 34184,2046,1416, 2813,2047,2813, 35582,2043,2814, 34181,2044,1413, 641,579,641, 
644,582,644, 678,617,678, 33445,616,677, 33413,583,645, 649,587,649, 676,615,676, 
6, // chain 483
2801,1961,2801, 2804,1962,2804, 2815,1959,2815, 
35584,1958,2816, 35579,1963,2811, 35577,2050,2809, 35575,2052,2807, 35573,2054,2805, 
7, // chain 484
2817,2160,2817, 1422,1401,1422, 1424,1403,1424, 
2818,2161,2818, 34193,1404,1425, 2819,2162,2819, 34194,1407,1426, 1384,1361,1384, 34151,1360,1383, 
11, // chain 485
2820,2163,2820, 1386,1363,1386, 1387,1364,1387, 
2821,2164,2821, 35590,2165,2822, 35591,2166,2823, 34156,1365,1388, 2824,2167,2824, 35593,2168,2825, 34157,1366,1389, 2826,2169,2826, 34165,1374,1397, 34158,1367,1390, 
12, // chain 486
2827,2170,2827, 2820,2163,2820, 2821,2164,2821, 
2828,2171,2828, 35597,2172,2829, 35590,2165,2822, 2823,2166,2823, 2824,2167,2824, 2830,2173,2830, 35599,2174,2831, 35593,2168,2825, 2826,2169,2826, 1399,1376,1399, 34165,1374,1397, 
14, // chain 487
1386,1363,1386, 2820,2163,2820, 2827,2170,2827, 
2832,2175,2832, 35601,2176,2833, 35602,2177,2834, 35603,2178,2835, 35604,2179,2836, 35596,2171,2828, 2829,2172,2829, 2837,2180,2837, 35598,2173,2830, 2831,2174,2831, 2838,2181,2838, 34169,1378,1401, 34167,1376,1399, 
18, // chain 488
1386,1363,1386, 2832,2175,2832, 2839,2182,2839, 
1385,1362,1385, 35587,2162,2819, 35586,2161,2818, 34182,1393,1414, 35600,2175,2832, 1412,1391,1412, 35601,2176,2833, 1411,1388,1411, 34176,1385,1408, 34175,1384,1407, 35602,2177,2834, 1406,1383,1406, 35608,2183,2840, 35603,2178,2835, 2838,2181,2838, 35605,2180,2837, 
35604,2179,2836, 
5, // chain 489
2817,2160,2817, 2818,2161,2818, 1414,1393,1414, 
1415,1394,1415, 1422,1401,1422, 34186,1397,1418, 34185,1396,1417, 
1, // chain 490
1385,1362,1385, 2819,2162,2819, 1384,1361,1384, 
5, // chain 491
2841,2184,2841, 1401,1378,1401, 1402,1379,1402, 
1406,1383,1406, 2840,2183,2840, 2838,2181,2838, 1401,1378,1401, 
3, // chain 492
434,1940,434, 432,504,432, 563,505,563, 
436,1939,436, 33332,506,564, 
5, // chain 493
577,514,577, 429,515,429, 428,1951,428, 
2842,1947,2842, 33163,1949,395, 2843,2185,2843, 34531,1950,1763, 
3, // chain 494
577,514,577, 2842,1947,2842, 576,513,576, 
35612,1945,2844, 35611,2185,2843, 
3, // chain 495
2844,1945,2844, 2845,1946,2845, 2846,1944,2846, 
576,513,576, 33343,512,575, 
2, // chain 496
1623,1215,1623, 1634,629,1634, 1638,1216,1638, 
1622,1214,1622, 
2, // chain 497
1624,630,1624, 1625,627,1625, 1634,629,1634, 
1623,1215,1623, 
4, // chain 498
1708,1953,1708, 1706,1952,1706, 2790,1954,2790, 
35559,1955,2791, 33343,1956,575, 1758,1957,1758, 
1, // chain 499
1502,1480,1502, 1503,1481,1503, 1600,1537,1600, 
7, // chain 500
1609,1554,1609, 1599,1536,1599, 1510,1490,1510, 
143,140,143, 144,141,144, 2847,1934,2847, 35616,1933,2848, 34375,1552,1607, 32913,142,145, 
3, // chain 501
2848,1933,2848, 1607,1552,1607, 1608,1553,1608, 
1609,1554,1609, 2847,1934,2847, 
1, // chain 502
516,1932,516, 517,1550,517, 1606,1551,1606, 
13, // chain 503
647,1916,647, 646,1918,646, 1410,1917,1410, 
1409,1914,1409, 2849,1915,2849, 35618,1911,2850, 34173,1913,1405, 1404,1912,1404, 2782,1910,2782, 2851,1907,2851, 33284,1909,516, 1606,1908,1606, 150,1906,150, 1602,1540,1602, 32909,1539,141, 
7, // chain 504
647,1916,647, 2849,1915,2849, 651,1543,651, 
34371,1541,1603, 35620,2110,2852, 35618,1911,2850, 2851,1907,2851, 1602,1540,1602, 1603,1541,1603, 
1, // chain 505
1487,1465,1487, 1482,1460,1482, 1483,1461,1483, 
6, // chain 506
406,2060,406, 386,2059,386, 2030,1829,2030, 
34797,1828,2029, 33155,2058,387, 2026,1825,2026, 35526,2057,2758, 2024,1823,2024, 
1, // chain 507
1576,1198,1576, 342,288,342, 343,287,343, 
1, // chain 508
410,1817,410, 2021,1818,2021, 418,1820,418, 
4, // chain 509
2853,2112,2853, 2717,2083,2717, 2718,2084,2718, 
2699,2069,2699, 35487,2085,2719, 2697,2067,2697, 
3, // chain 510
2854,2113,2854, 2853,2112,2853, 2699,2069,2699, 
2704,2074,2704, 35469,2071,2701, 
6, // chain 511
2704,2074,2704, 2705,2075,2705, 2706,2079,2706, 
2854,2113,2854, 35475,2081,2707, 2853,2112,2853, 35496,2111,2728, 2717,2083,2717, 
12, // chain 512
2855,2088,2855, 2856,2087,2856, 2857,2086,2857, 
2802,2089,2802, 35571,2096,2803, 34826,2095,2058, 34829,2094,2061, 35626,2093,2858, 35624,2087,2856, 2859,2092,2859, 33452,2091,684, 33451,2090,683, 35623,2088,2855, 2802,2089,2802, 
1, // chain 513
2803,2096,2803, 2058,2095,2058, 2057,2097,2057, 
5, // chain 514
2859,2092,2859, 684,2091,684, 685,2098,685, 
2789,2099,2789, 1636,2100,1636, 35553,2108,2785, 1637,2109,1637, 
9, // chain 515
2858,2093,2858, 2859,2092,2859, 1636,2100,1636, 
1635,2101,1635, 2061,2094,2061, 34830,2102,2062, 34401,2103,1633, 2063,2104,2063, 34400,2105,1632, 1833,2106,1833, 34608,2107,1840, 
1, // chain 516
1766,2186,1766, 1587,1261,1587, 1588,1526,1588, 
4, // chain 517
2794,2149,2794, 2796,2151,2796, 2800,2159,2800, 
35567,2157,2799, 35565,2153,2797, 2798,2156,2798, 
2, // chain 518
1475,1453,1475, 1513,1496,1513, 1474,1452,1474, 
34241,1451,1473, 
2, // chain 519
1449,1431,1449, 786,318,786, 783,1931,783, 
782,1432,782, 
6, // chain 520
1501,1925,1501, 1500,1924,1500, 2860,1923,2860, 
1504,1926,1504, 34273,1927,1505, 34283,1928,1515, 34282,1929,1514, 34281,1930,1513, 
3, // chain 521
2057,2187,2057, 1834,2188,1834, 2806,2189,2806, 
34854,2190,2086, 34600,2191,1832, 
5, // chain 522
1420,2192,1420, 1419,2193,1419, 2810,2194,2810, 
2808,2195,2808, 2087,2196,2087, 35574,2189,2806, 2086,2190,2086, 
7, // chain 523
357,2187,357, 2678,2189,2678, 358,2188,358, 
32825,2190,57, 32827,2196,59, 35444,2195,2676, 61,2192,61, 35442,2194,2674, 2673,2193,2673, 
1, // chain 524
117,2191,117, 358,2188,358, 57,2190,57, 
2, // chain 525
1320,1277,1320, 1328,1291,1328, 1319,1276,1319, 
34106,1301,1338, 
1, // chain 526
1337,1300,1337, 631,569,631, 1334,1297,1334, 
1, // chain 527
1224,1156,1224, 1331,1294,1331, 1223,1155,1223, 
1, // chain 528
859,1282,859, 1324,1283,1324, 861,1286,861, 
3, // chain 529
248,2186,248, 2861,1526,2861, 249,1261,249, 
34074,1260,1306, 34073,1259,1305, 
2, // chain 530
226,1501,226, 224,1264,224, 2862,1500,2862, 
34075,1265,1307, 
1, // chain 531
221,1235,221, 1289,1237,1289, 223,1263,223, 
1, // chain 532
1289,1237,1289, 1291,1241,1291, 1301,1255,1301, 
4, // chain 533
1283,1225,1283, 1282,1224,1282, 2863,2197,2863, 
2864,1224,2864, 33539,703,771, 34050,1224,1282, 
1, // chain 534
822,751,822, 819,748,819, 820,745,820, 
1, // chain 535
1281,708,1281, 1284,1226,1284, 1279,707,1279, 
4, // chain 536
670,609,670, 671,610,671, 1278,1969,1278, 
1605,1968,1605, 669,608,669, 35552,1967,2784, 
2, // chain 537
2784,1966,2784, 685,1965,685, 669,608,669, 
33436,607,668, 
1, // chain 538
448,409,448, 449,410,449, 322,2198,322, 
3, // chain 539
682,621,682, 683,622,683, 2802,1960,2802, 
2815,1959,2815, 35569,1961,2801, 
12, // chain 540
318,2199,318, 319,2200,319, 2865,2201,2865, 
316,2202,316, 33112,2203,344, 33111,2204,343, 34344,2205,1576, 34342,2206,1574, 34341,2207,1573, 34024,2208,1256, 34025,2209,1257, 34026,2210,1258, 34027,2211,1259, 33087,2200,319, 
7, // chain 541
77,77,77, 58,58,58, 60,60,60, 
62,62,62, 76,76,76, 32832,64,64, 2866,1880,2866, 32838,70,70, 32834,66,66, 
3, // chain 542
75,75,75, 76,76,76, 2866,1880,2866, 
72,72,72, 32838,70,70, 
1, // chain 543
1260,1199,1260, 694,633,694, 695,634,695, 
1, // chain 544
1571,1518,1571, 1256,1194,1256, 444,1193,444, 
2, // chain 545
2745,1995,2745, 424,380,424, 425,382,425, 
426,384,426, 
5, // chain 546
681,620,681, 682,621,682, 2815,1959,2815, 
2816,1958,2816, 680,619,680, 35580,1964,2812, 35579,1963,2811, 
4, // chain 547
680,619,680, 2812,1964,2812, 679,618,679, 
35581,2047,2813, 678,617,678, 35582,2043,2814, 
1, // chain 548
641,579,641, 1413,1935,1413, 642,580,642, 
5, // chain 549
899,793,899, 900,791,900, 832,762,832, 
833,760,833, 898,795,898, 33603,758,835, 837,757,837, 
1, // chain 550
832,762,832, 900,791,900, 831,765,831, 
10, // chain 551
814,745,814, 817,748,817, 842,751,842, 
33519,798,751, 35635,799,2867, 33586,749,818, 1283,1225,1283, 2864,1224,2864, 2868,800,2868, 33544,708,776, 33542,706,774, 33539,703,771, 
15, // chain 552
2862,1897,2862, 1307,1898,1307, 1308,1884,1308, 
226,1896,226, 32995,1895,227, 32997,1894,229, 33000,1893,232, 33001,1892,233, 33004,1891,236, 33006,1890,238, 33009,1889,241, 33011,1888,243, 33014,1887,246, 33016,1886,248, 35629,1885,2861, 34073,1882,1305, 34072,1883,1304, 
3, // chain 553
750,797,750, 837,757,837, 838,753,838, 
842,751,842, 751,798,751, 
3, // chain 554
1209,801,1209, 751,798,751, 778,710,778, 
35636,800,2868, 35635,799,2867, 
1, // chain 555
778,710,778, 2868,800,2868, 776,708,776, 
2, // chain 556
1209,801,1209, 778,710,778, 780,712,780, 
1210,802,1210, 

 0};


// mesh info for object cyborg (with tag [ | o Cyborg | usemtl Cyborg])
const tgx::Mesh3D<tgx::RGB565> cyborg = 
    {
    1, // version/id
    
    2869, // number of vertices
    2212, // number of texture coords
    2869, // number of normal vectors
    5549, // number of triangles
    20547,
    
    cyborg_vert_array, // array of vertices
    cyborg_tex_array, // array of texture coords
    cyborg_norm_array, // array of normal vectors        
    cyborg_face, // array of face vertex indexes   
    
    &cyborg_texture, // pointer to texture image 
    
    { 0.75f , 0.75f, 0.75f }, // default color
    
    0.1f, // ambiant light strength 
    0.7f, // diffuse light strength
    0.6f, // specular light strength
    32, // specular exponent
    
    nullptr, // next mesh to draw after this one    
    
    { // mesh bounding box
    -0.8606258921088427, 0.8606258921088427, 
    -1.0, 1.0, 
    -0.23075535744826633, 0.23075535744826633
    },
    
    "cyborg"
    };
    
                
/** end of cyborg.h */
    
    
    