// 3D model [donkeykong_small]
//
// - vertices   : 1598
// - textures   : 2995
// - normals    : 1598
// - triangles  : 3200
//
// - memory size: 90kb
//
// - model bounding box: [-0.89,0.89]x[-0.91,0.91]x[-1.0,1.0]
//
// object [donkeykong_small] (tagged [ | o model]) with 3200 triangles (806 chains)

#pragma once

#include <tgx.h>

#include "donkeykong_texture.h" // texture for object [donkeykong_small]


// vertex array: 18kb.
const tgx::fVec3 donkeykong_small_vert_array[1598] PROGMEM = {
{-0.8596170470812667,-0.5272663277799284,0.274515826325696},
{-0.8701216878425444,-0.5114378817700866,0.3436089801956626},
{-0.888003809295335,-0.4914402928698692,0.3514432370771413},
{-0.8837365261625529,-0.30412449513812034,0.219273774322272},
{-0.891562301788515,-0.27309885085045804,0.2670656491583263},
{-0.8852037833669253,-0.4804655482313857,0.4025040301108803},
{-0.8676148710334229,-0.4775601124129839,0.4062733423840446},
{-0.8735469034633208,-0.8382715443578751,0.41405186530069993},
{-0.8484787353721062,-0.7425860196195673,0.32843964890025384},
{-0.8700817047808231,-0.8451256104232208,0.3562993616643616},
{-0.8484944862752083,-0.8861579246125431,0.2969342078719379},
{-0.8596727810460902,-0.8417791493179557,0.25425410689653294},
{-0.8632264271075466,-0.7724618479807647,0.26199022353560525},
{-0.8690881862774498,-0.794572481112547,0.3246860875301918},
{-0.8499435693606163,-0.45208242084111044,0.4668234487329308},
{-0.8472198747318561,-0.4393011687775907,0.47840520894481675},
{-0.8463996161626075,-0.6655192739560636,0.29738129119845597},
{-0.8098526745336371,-0.720538390100194,0.30156376177607186},
{-0.7539030434985422,-0.648811200588357,0.26240338184005685},
{-0.8106826259663331,-0.536854992945413,0.2699214090515594},
{-0.8517379607063433,-0.5341737045942356,0.30300436360596333},
{-0.7753691012110627,-0.44176557930912913,0.5276146650600746},
{-0.8247263734938957,-0.39795383652622324,0.4821842140814286},
{-0.7803887928689603,-0.23309276857864467,0.4703989037371441},
{-0.7021043812348587,-0.1724069621414929,0.4859826049449355},
{-0.6953314929008862,-0.43981367893237966,0.544882501291877},
{-0.5973669336444744,-0.18779680608033333,0.49419972993259226},
{-0.6146711181142049,-0.3759195346940903,0.526112271225705},
{-0.6264140221809065,-0.44075509829472254,0.5459317537600737},
{-0.5487560118471024,-0.3706042107010425,0.5057911830079258},
{-0.561860763228184,-0.44532770662610216,0.5328548693614039},
{-0.49940237438806234,-0.4402086631178671,0.49185890341001},
{-0.48632670159732333,-0.361998159567553,0.46030620967238733},
{-0.48539982153015176,-0.2062435368289434,0.45613706678201177},
{-0.48422213862127506,-0.11709100205428136,0.4259122953367029},
{-0.593149326436861,-0.09382934138810288,0.45862449786423815},
{-0.5103589449075816,-0.017677359712461333,0.37284265635346},
{-0.6067968781710051,0.03251955686651531,0.36474911537475946},
{-0.517795794387711,0.033251368056804925,0.357699980432532},
{-0.4500160235148868,-0.022031878616271157,0.3239239861416285},
{-0.35257609049257316,0.15108750898861625,0.2882627299101775},
{-0.3521483928929502,0.07313023149586922,0.27512041868323667},
{-0.41499691948683565,-0.04852853245806791,0.2770614145886076},
{-0.3587322703896955,0.02544255494187613,0.24879581316763386},
{-0.20216102390563032,-0.04780883734708753,0.24815123774837208},
{-0.2926172488139873,-0.06335134388522691,0.20633259001186774},
{-0.37262456692589024,-0.019237910727516114,0.19569951880991024},
{-0.7558440394039132,-0.7699828981540549,0.3186316826992686},
{-0.7620959363275801,-0.7585307799907798,0.2652421792222568},
{-0.7724442796657659,-0.7674494259704526,0.3306641610614655},
{-0.7911490829036669,-0.7302373115873942,0.30699903495428305},
{-0.814823901874297,-0.7210327261360189,0.2573315910411287},
{-0.8027041877410722,-0.7487446227325516,0.22142680161555806},
{-0.5958257683563145,-0.617372397996243,-0.6849795147389076},
{-0.5756512846981794,-0.6188457132402697,-0.8230252759588514},
{-0.5829439528345265,-0.633408028962276,-0.7582733133054543},
{-0.5787457313538084,-0.6417402567033724,-0.6869604937059997},
{-0.542173345958288,-0.6531935864745785,-0.6099809838135238},
{-0.5671579131022676,-0.6240834943257373,-0.7471386364200863},
{-0.5850339765154035,-0.7755853732267362,0.302925609090452},
{-0.6270695020715468,-0.7653133611881998,0.3311076095641907},
{-0.5664127742247376,-0.7759597600773976,0.3170129745035285},
{-0.5367659397624885,-0.7649862270468452,0.3305236145414761},
{-0.6533274691509475,-0.7515204165023426,0.334129359743963},
{-0.587581987994177,-0.47220359375028403,0.1766433492720357},
{-0.5431196117523547,-0.5163388358507518,0.23406629555115743},
{-0.6009545047279972,-0.5182871014037085,0.2056141065088184},
{-0.6266296883926143,-0.5443536344300204,0.208758229089616},
{-0.6800252499092809,-0.5007478649953748,0.1813395416123715},
{-0.6730791016411836,-0.5395278000410736,0.2012995706667297},
{-0.7425514887935354,-0.5463140160622865,0.2176998956199768},
{-0.7025405600899983,-0.5409793063423436,0.21462241147538105},
{-0.5153071516975537,-0.6255616560014879,-0.8877554296694915},
{-0.5531735343633213,-0.6062098541284633,-0.8426496896163382},
{-0.4869518912896901,-0.57618499799176,-0.9153813021029272},
{-0.5417117233365987,-0.590858781643413,-0.877980176882642},
{-0.6031220713164545,-0.4716898719875642,-0.8047130336905759},
{-0.645702820441522,-0.4784142960042989,-0.736844815438793},
{-0.6537636480060871,-0.5369107269102363,-0.6545923878308523},
{-0.6285961280645351,-0.5817426435709964,-0.5591564543263188},
{-0.5798725267295856,-0.6000548858392718,-0.4727142864931765},
{-0.5041373381821883,-0.6601748713726731,-0.575233279962004},
{-0.5160159423371554,-0.6627543846576511,-0.605883325791074},
{-0.5432250216423468,-0.6566515155094904,-0.6577449916671665},
{-0.5498803840070177,-0.6562383572050386,-0.7609521784407697},
{-0.5381968487289325,-0.6465261080305981,-0.8396267278286351},
{-0.4647370598758466,-0.5914379302344038,-0.9101047495636697},
{-0.5118007583454041,-0.4438398520869039,0.46869295977037606},
{-0.47302809294729087,-0.464612870062925,0.4142336064903414},
{-0.47001845884682797,-0.4534248824285955,0.4680386914876668},
{-0.5609132858261864,-0.4439488968006888,0.5117110993585142},
{-0.47928362469475055,-0.47276941465403455,0.43381682547817624},
{-0.44933025342597294,-0.7899574665035844,0.1999643787268303},
{-0.4678654315535419,-0.8117458119257358,0.225629869528},
{-0.47276153920248337,-0.7897369538601527,0.23549720451760137},
{-0.45138756369271443,-0.7510660635282388,0.2288430537608613},
{-0.47270217041386714,-0.7860136826883642,0.2981845872566713},
{-0.4573583675764025,-0.752682348508117,0.30851717969175485},
{-0.4621030242339761,-0.7904845159535446,0.33338906729815676},
{-0.45579175852169296,-0.7728677366376306,0.34830759575186027},
{-0.3037398096200458,0.26604244626064466,-0.5083525221739397},
{-0.4266719735094042,0.4379138776966606,-0.2111608476166763},
{-0.3098026957064856,0.4089964312088393,-0.36440138389857873},
{-0.2382802679349779,0.2995809653970832,-0.5356294515232638},
{-0.25828512648278096,0.49472253875479405,-0.30548573664853496},
{-0.3983615425949856,0.5046625702202522,-0.1608488282842602},
{-0.5443833188243283,0.46907764528845036,-0.1311559527206353},
{-0.5879660677082861,0.38240406034049823,-0.16667666243209694},
{-0.48361996947959623,0.332560933277357,-0.21483686607915797},
{-0.4321544993969222,0.333582318763142,-0.25937315040476794},
{-0.35629936166436166,0.21374823635320545,-0.4807121104453326},
{-0.34535611883208267,0.1439341757643276,-0.6283089769849015},
{-0.2789781783353598,0.20511431823730428,-0.6387990784510077},
{-0.18327811430188065,0.26722739881710716,-0.6224326785198271},
{-0.14031934350235872,0.3172995197791964,-0.5572360557557738},
{-0.15722006253108536,0.48187464825507265,-0.3601316775499349},
{-0.1557734026615392,0.5537956950358605,-0.2603933242826221},
{-0.25841355692346096,0.5705376934256337,-0.17460300151632732},
{-0.36421358466928255,0.5451872206865092,-0.07456053465834776},
{-0.5206297453381871,0.5166126592431448,-0.05743203333860381},
{-0.6176189602101898,0.44179344629154066,-0.0928449099442115},
{-0.6733541366415077,0.34564508732361254,-0.10466172209470048},
{-0.6408091360084426,0.31305768041296433,-0.14377969575313246},
{-0.44947685798561704,0.015845408520875005,-0.7797720844321103},
{-0.4980187181309252,-0.01327558809934471,-0.6701215666817512},
{-0.537225139168316,-0.07718669484866719,-0.7108122074345475},
{-0.5088819948397619,-0.09824928712018377,-0.7997817894116371},
{-0.42036070779712115,-0.00398134366107935,-0.8414926040422877},
{-0.3001086206510091,0.09092632878556291,-0.8446149176803281},
{-0.2539160682837998,0.17064770742576324,-0.7561602690738892},
{-0.14238513502461686,0.17322237427901743,-0.8022243910004186},
{0.11413891933053814,0.31139535433171034,-0.5668586459433247},
{0.13075248727963124,0.46839187519953673,-0.37673555263558045},
{0.159124710198528,0.5598404070033363,-0.25117541114400627},
{0.03766464994526559,0.6037199998303747,-0.14891085534067688},
{-0.13742238893947356,0.6024017704015086,-0.1598952928426079},
{-0.2518417955060251,0.5914088516440611,-0.08068642435719654},
{-0.3297348577784321,0.5507194224991956,0.020362888691396814},
{-0.47463710827958344,0.5399458047772489,0.000599140121851425},
{-0.4836187578716653,0.5383161921101304,0.0772818060712462},
{-0.603366816118505,0.48725782229225323,0.0017925739338304715},
{-0.6892056032020375,0.37397248074906436,-0.05147455714215613},
{-0.7744131425535487,0.1315067132166433,0.021446066181660027},
{-0.7392159321596488,0.09827351927880239,-0.03307629071078372},
{-0.28944647085870895,-0.7357174142590505,-0.4995877504014966},
{-0.2793210633798167,-0.7179843205817659,-0.5562158818779196},
{-0.3250023172001679,-0.7534844329584013,-0.4972626747820166},
{-0.3549411491737743,-0.7228925443100166,-0.5136060541625093},
{-0.40177464213645253,-0.7000937178734585,-0.5713331140322979},
{-0.3319145404461989,-0.6868472083644567,-0.613859340800473},
{-0.25262207101355244,-0.7330361259078731,-0.6396496272185298},
{-0.1985310465445245,-0.7463298881261818,-0.468908625982084},
{-0.23136683308101602,-0.7367012398989762,-0.42959921827056297},
{-0.19659610867880822,-0.7728035214172907,-0.4265556591480336},
{-0.22477568593668507,-0.7818312121107484,-0.398479068564287},
{-0.32708628284139024,-0.6571906810387601,-0.6616693897554915},
{-0.298213665847014,-0.6803432969911536,-0.7186670616508521},
{-0.3115304486160106,-0.6300906464473537,-0.7753557735238223},
{-0.3254191103284124,-0.6153623404388081,-0.8611376150346005},
{-0.23861103690012536,-0.7856332377980481,-0.6688336274511585},
{-0.1821779743005842,-0.7906953357335288,-0.4886008896837037},
{-0.19865099572968786,-0.8410909560131801,-0.43791084867683333},
{-0.3022773988473974,0.3171020276864528,0.39719234094162537},
{-0.28862621228946045,0.3098360149245864,0.38182067112174906},
{-0.2978053539742861,0.3029456006213125,0.4569718646464317},
{-0.3442547672228553,0.31160738571962543,0.4090188459555619},
{-0.31785140719174126,0.3200220028000259,0.44743893344577057},
{-0.29683243280573873,0.30763088849026987,0.4772154099566306},
{-0.3045079690482638,0.3412239299836008,0.4900814745753163},
{-0.2452906314234152,0.5111713280252789,0.6774251392894768},
{-0.27883642020743943,0.42287055362606996,0.6003850490004538},
{-0.21793373595064883,0.36758730695299385,0.7082847932906},
{-0.21483807768708896,0.44134878618088447,0.7026823182179187},
{-0.20038359507093664,0.39787508201071164,0.7213725821606484},
{-0.2650313594422727,0.6319444065816965,0.46727295527531065},
{-0.21490471612329082,0.6225483870772321,0.6296259948058368},
{-0.14410682989448714,0.7224503074152223,0.6414306908770164},
{-0.13499796146965623,0.7570356558039958,0.5536375802008725},
{-0.057066127743459004,0.8508443998572724,0.6959409316901507},
{-0.040951742261914524,0.8478396121885333,0.765787705693164},
{-0.09568976536606616,0.7277462456813749,0.7218002797602713},
{-0.18307819899327502,0.6145020988078385,0.6818850680832788},
{-0.22126081132901884,0.6086888039551729,0.6919511067735548},
{-0.2476605365363401,0.6029191269880215,0.6560414709162603},
{-0.2421792222567531,0.5991243709483073,0.6082701934150321},
{-0.2862865973748091,0.5427652164325536,0.5462104235841907},
{-0.3011372757843799,0.560612201255347,0.41233622847048435},
{-0.2513159576639957,0.6061347344367447,0.27904723998742353},
{-0.2223294495241107,0.6829712745933693,0.3890394311743086},
{-0.08703403830740798,0.7977420474598942,0.4856360850766857},
{-0.04869149372477964,0.8369096970434948,0.5430711474351169},
{-0.001100745805261913,0.8790070146041161,0.7479455673020945},
{0.0021548447051824506,0.8542671922621871,0.8381376616815058},
{-0.01555038198969045,0.8195812804151452,0.8520166305304602},
{6.058039654508402e-07,0.8076396726477693,0.8886774633049394},
{-0.19824026064109815,0.5265744996513597,0.7602264252901346},
{-0.21174363103146004,0.5000015145099137,0.7115306909375968},
{-0.14167392116915323,0.5053168385029615,0.7998569091033557},
{-0.09063493707817115,0.4723841233319943,0.8033511863761958},
{-0.19340473338870384,0.5050369570709135,0.7195769792069905},
{-0.21849592203060644,0.40765396962135436,0.6730197328525674},
{-0.1935913210100691,0.3638458616622413,0.7027501682620514},
{-0.17294188704300423,0.43362357401319074,0.7240962767894087},
{-0.21262083517346292,0.515285948558762,0.6654992824252028},
{-0.16220704077484752,0.4679290409699163,0.727354290515715},
{-0.1557964232122271,0.42192186461614145,0.7605220576252848},
{-0.13387601252560283,0.3823798281818792,0.7678656132947315},
{-0.15983350083812983,0.36591044157656843,0.7320795614463933},
{-0.21865221945369814,0.5145844275667459,0.6683538307105051},
{-0.1742225566260112,0.3751138154200128,0.7491898886471732},
{-0.12469565923284624,0.4903377296527106,0.7574312457934488},
{-0.12376514434188186,0.5136236224775079,0.7371755844039405},
{-0.15625925744184738,0.5481920083552484,0.6998059609898596},
{-0.19680208202706856,0.5470530969001616,0.6778661645763402},
{-0.022518339200544763,0.8554509332107186,0.49298085235406336},
{6.058039654508402e-07,0.9092257280097704,0.49225752241929027},
{-0.009932156013906858,0.8538491875260117,0.5640319646404343},
{0.006429397485550041,0.8649826528034488,0.4860213763987257},
{-0.004993642087382397,0.8184011742904067,0.4573220193384742},
{-0.04962200861574402,0.8055169355527568,0.45170500497062155},
{-0.08145700700127645,0.728811249052674,0.28338479638020014},
{0.031390944078841736,0.7316863946728022,0.2743389315677783},
{0.038237740496601724,0.7991147992456529,0.42783390551517875},
{0.040587048274700575,0.835752611469444,0.4921000133882677},
{-0.8099568728156981,-0.5316584065295976,0.23763205769192328},
{-0.8471180996656568,-0.4747843186431931,0.24104636884132116},
{-0.8591118065740635,-0.3236010926280322,0.1713304484948498},
{-0.8073422229007227,-0.44947504057372073,0.488254369815454},
{-0.7117366642858571,-0.44805867090244805,0.5294938689609675},
{-0.6119074404237236,-0.5259480983510623,0.23166488863202803},
{-0.5768641042370536,-0.8745071027485932,-0.5393902825409115},
{-0.5886421449337523,-0.8320353983373107,-0.4494090079414842},
{-0.615482895427937,-0.8837989239709967,-0.5006963716583096},
{-0.6405910465808727,-0.8730834634297351,-0.48175530487387463},
{-0.4389080020039996,0.0013691169619657665,-0.05901681651227752},
{-0.4913803182772874,-0.1155328742550884,0.025737581473060822},
{-0.5448885593315317,-0.13750901890653605,0.008667237334002157},
{-0.5347704215002251,-0.2761109081667828,0.044564757111987124},
{-0.4439119427587949,-0.11384146958349162,0.07106989220930045},
{-0.39171344987790024,-0.0388090136360415,0.06489674980114486},
{-0.4269809335317947,-0.8712539354540109,-0.4908435759638795},
{-0.46543373443613895,-0.8604875873796496,-0.4667967933584499},
{-0.5235787990421028,-0.8783151864755477,-0.5010756049406948},
{-0.4546480006348826,-0.8841490786630393,-0.5418122867948669},
{-0.4486590226322304,-0.6553320744726933,0.49819197806505006},
{-0.35297349789392257,-0.7114925252877721,0.4391466887663954},
{-0.41886558361033727,-0.6036388220990018,0.44150326619207986},
{-0.3357601840190126,-0.6923624476661101,0.3852531563901111},
{-0.34190424783682555,-0.7284647291844244,0.4136774784500385},
{-0.44323465392539774,-0.3984469609541171,0.3614353676836298},
{-0.4509538080534368,-0.4629977966909777,0.42203999638940837},
{-0.4507938758065523,-0.458405802632703,0.3704570003374328},
{-0.45075025792103834,-0.4161352251379568,0.30055933880131996},
{-0.45562819145101563,-0.48204063854161183,0.33843541433053514},
{-0.44531256152696524,-0.7733887280479362,0.38148384411694686},
{-0.3905818080703993,-0.7690172466330931,0.41801866966660794},
{-0.4500911432066052,-0.7941387254732694,0.4378623843595956},
{-0.3657462687019257,-0.7539581716594002,0.4290697456047408},
{-0.37533372225947925,-0.8589124970694234,0.2744031467881183},
{-0.4233860928006863,-0.8534614729881099,0.283728893032588},
{-0.38820705652575066,-0.8659034748309657,0.22606604838313954},
{-0.340080777900756,-0.8312466415742665,0.26035091800503907},
{-0.3325906176716652,-0.8087470822966514,0.243631940165954},
{-0.30212715946396046,-0.837294988365535,-0.5007775493896828},
{-0.282386431445103,-0.8631700873387579,-0.567044021956759},
{-0.2612959721911748,-0.8645755525386519,-0.5204455809326837},
{-0.2729564869185721,-0.8714344650357213,-0.4625985718777318},
{-0.23475691207179508,-0.8805009271829692,-0.46799143877835997},
{-0.24520218404445634,-0.8418227672034696,-0.40920664518485805},
{-0.31916236697302175,-0.13178174821696753,-0.08582848841611947},
{-0.2049598382261091,-0.1857479770691084,-0.02406435092042824},
{-0.29410510335318557,-0.12715461752869545,0.1011722912535841},
{-0.34059449966347594,-0.09926703778217599,0.0744514899445629},
{-0.36666709072944254,-0.039153110288429445,0.16060892991393347},
{-0.19217858616258934,-0.11639675070985085,0.1850167716827841},
{-0.2062974533818704,-0.16487318402688805,0.08965111143824528},
{-0.26190541098043923,-0.7420868371520187,-0.4332728135171827},
{-0.25564139797746294,-0.7811939063390723,-0.3984003140487757},
{-0.2904714911682869,-0.8303258195467497,-0.4349218119111964},
{-0.28830150136396765,-0.7859785460583669,-0.42953984948194673},
{-0.18400750227630844,0.05075667944307222,0.8610564373032273},
{-0.13239785084985212,0.13197197066212557,0.9301120313273348},
{-0.2290187369108481,0.13859461961266104,0.8740775877370739},
{-0.23734854143608258,0.1583317128077257,0.886168223279956},
{-0.04352035107551409,0.3597845518777197,0.9004530807857762},
{-0.11676568532482302,0.3330007469562895,0.9014986984301802},
{-0.06235237314616416,0.3310391537160924,0.8985181429200599},
{0.003729935015408603,0.3345697792268607,0.9253322380397637},
{-0.06273402964441127,0.3134659922856922,0.9299581571201049},
{-0.09750596565455001,0.22219314363187956,0.9702526020794828},
{-0.2046678407147518,0.20998134729590304,0.914365974656797},
{-0.21045932662466024,0.31145108829653373,0.8411061011123168},
{-0.10257412162968538,0.37924176364073653,0.8679941043158081},
{-0.0081886522012796,0.38795807109594177,0.8811800334282629},
{0.043521562683444995,0.3597845518777197,0.9004518691778454},
{0.06235358475409506,0.3310391537160924,0.8985193545279909},
{0.0661386479303616,0.31362592453257676,0.9285672312153822},
{0.009292427026368809,0.22344836944833663,0.9836166375577862},
{-0.07778462336258764,0.20598909916344527,0.9959883661406471},
{-0.20232701419216953,0.20006675959699494,0.9320978567261506},
{-0.28877281684910455,0.1911565948728386,0.8143659140764005},
{-0.7753182136779632,-0.7495975947159357,0.3327081436409667},
{-0.6759978651468257,-0.7003505787548185,0.28106699040830585},
{-0.4712009881874285,-0.7619814393781059,0.3396591383407878},
{-0.4534109489373896,-0.7014022544388772,0.2846872749059641},
{-0.07670629230404818,-0.08566552714940774,0.5923351259072672},
{-0.21355983131994388,-0.04640094893133155,0.6250885231044546},
{-0.16530391064633834,-0.05609865881060089,0.5442282330091677},
{0.009130071563622421,-0.07531233737949812,0.5124635078836299},
{-0.1114830747459107,-0.047309654879538976,0.48767764444032496},
{-0.23620841837306503,0.024756784852962198,0.44106829894487126},
{-0.28195873384548004,0.02213607689833204,0.48943689915605454},
{-0.31657679564838903,0.03521538451286382,0.586901064336987},
{-0.26043573056020514,-0.004605321745515148,0.7054968834414996},
{-0.18678814247782305,-0.026930409481074512,0.7575027306613744},
{-0.05479072804914769,-0.0789507959961205,0.6816948456381206},
{-0.3103006665661032,0.057187894340518665,0.6978395213179387},
{-0.2593222628716683,0.05181441316678564,0.7986901306658574},
{-0.12383420599394562,0.01240686521285821,0.8422244152325774},
{-0.028085677643228737,-0.030401666203226773,0.43979247579358804},
{0.03027747639030494,-0.029333028008134816,0.44034981544182195},
{0.1309536141961678,-0.0385351902436484,0.48184617546869546},
{0.06666812059618378,-0.01864058801756116,0.42822646648480434},
{0.13899990246556154,0.023474903662024295,0.406776159675386},
{0.23620841837306497,0.02475557324503122,0.44106829894487126},
{0.18111175932135415,0.07834256881478688,0.3771402296845155},
{0.2872280167371519,0.10471685025555835,0.3994507781249035},
{0.22963786856356005,0.1316678570714588,0.36509321202714734},
{0.26170549567183354,0.19692142540826635,0.3647939448682044},
{0.3016267653884809,0.198122128867831,0.3897433753821866},
{0.30195995756949023,0.25672033483996776,0.4087498689948925},
{0.25846565606449146,0.2664931644109556,0.39112339681553093},
{0.00014963357947146374,-0.846808533839301,0.391056758379329},
{-0.0912395294357118,-0.7731221743031287,0.39576870162276717},
{-0.1372757843798294,-0.6791946926726194,0.3859752747169533},
{-0.1730000442236895,-0.6190347240774969,0.3904836678279929},
{-0.101729630901818,-0.4134284930202297,0.38109612957904504},
{0.11235058602446597,-0.4761970534906729,0.38090833034974886},
{-0.05457142701364697,-0.1307361305725636,0.38035099070151496},
{0.0553868391511717,-0.1353850702035926,0.3809531598431937},
{0.00440358902501302,-0.0807463989497783,0.33416691958982225},
{-0.061417011823476024,-0.07088391039190078,0.3441651082359655},
{-0.0822493985881133,-0.10191197789542504,0.38544095561940733},
{-0.0797474282107156,0.3871862768439309,0.7807207734420388},
{6.058039654508402e-07,0.397915065072433,0.8397842368596576},
{-0.14202892229291958,0.3837029040424693,0.8075239640903643},
{6.058039654508402e-07,0.3836932111790217,0.7670526243730686},
{0.07974742821071558,0.3871862768439309,0.7807207734420388},
{0.13387722413353373,0.3823798281818792,0.7678656132947315},
{0.1420277106849886,0.3837029040424693,0.8075263873062261},
{0.17422376823394212,0.3751138154200128,0.7491886770392422},
{0.15983471244606073,0.36591044157656843,0.7320783498384624},
{0.19359374422593095,0.3638458616622413,0.7027489566541204},
{0.20038480667886757,0.3978738704027808,0.7213725821606484},
{0.21849592203060642,0.40765396962135436,0.6730197328525674},
{0.21484050090295082,0.4413499977888156,0.7026823182179187},
{-0.22604302783245162,0.3486704723271776,0.772441856449904},
{-0.2844885712052894,0.28911509608959596,0.7260760441485699},
{-0.311244509144308,0.31199146543373435,0.5500815109235543},
{-0.21850198007026117,0.35642476308521404,0.7301373539330914},
{0.15442730625026121,-0.6703487431688032,0.38733348720754057},
{0.16747874688238132,-0.6017414440791448,0.3870826843658353},
{0.11431460248052491,-0.44559183715504774,0.38995540677010165},
{-0.11431096765673211,-0.4455845675074621,0.3899541951621708},
{-0.10526025641258646,-0.45717480897486473,0.3978950735415724},
{-0.05965291067602272,-0.1867875366738577,0.3952186316221189},
{-0.05988311618290194,-0.1290495723326906,0.39124213439276334},
{-0.035082713444425685,-0.12960812358885548,0.4048024503558796},
{0.03500638214477623,-0.12784523404933315,0.4056336133965066},
{0.05859154212851645,-0.1846114888298837,0.395514263957269},
{0.105055494672257,-0.45826767932857543,0.3981083165374184},
{-0.1636791444109435,-0.6281096674802614,0.4025428015646705},
{-0.13541717781376256,0.1592295142845546,0.9563518242877714},
{-0.03775552054008637,0.16216039386950612,0.982961157667146},
{-0.004991218871520511,0.19366704650575298,1.0},
{0.09104446055882992,0.20529727103487672,0.9919331143957802},
{0.1282384008229241,0.16218099120433221,0.961161907773616},
{0.06120255721969903,0.16042658292032644,0.9790912819357134},
{-0.027771871189114453,0.3992151203823349,0.7616742967676119},
{-0.0010280493294053212,0.46460438880740806,0.7719341927268388},
{0.02777187118911441,0.399216331990266,0.7616742967676119},
{0.07586180157618075,0.41742437597648013,0.7862057225454188},
{0.12258019178541937,0.42860267074736225,0.7823310003822623},
{0.15579642321222706,0.42192186461614145,0.7605220576252848},
{0.12404866059772253,0.4901317563044502,0.7582381766754569},
{0.09797485792382497,0.4774425864436822,0.7713998736292929},
{0.03614529359986283,0.4666919892724234,0.764358008334651},
{0.0476422412565828,0.46300991277028697,0.799208698860301},
{-0.12258019178541942,0.42860267074736225,0.7823310003822623},
{-0.07586058996824983,0.41742316436854926,0.7862057225454188},
{-0.037972398359725205,0.46784544002268136,0.7651431302739021},
{-0.33688092135513503,0.27652285486330336,0.521187084986421},
{-0.34930474907902653,0.16903142244588495,0.6195054337586684},
{-0.32281415327688456,0.2808519300005633,0.46268944247255256},
{-0.2730122208833955,0.32428080467729115,0.5215372396784635},
{-0.24696265036811682,0.3421156734207751,0.6210550803023447},
{-0.36436140083685764,0.17450546707788633,0.5071966482078198},
{-0.3430322548205337,0.21747998878051045,0.44331462004884},
{-0.3019611691774212,0.25671912323203677,0.4087498689948925},
{-0.2584644444565606,0.2664931644109556,0.39112339681553093},
{-0.32935804771190874,0.12359612503551519,0.4271008827169581},
{-0.301624342172619,0.19812091725990016,0.38974216377425563},
{0.024917322903812246,-0.07915434612851903,0.43786844239925027},
{-0.029483873195537184,-0.07753200310898598,0.4361721912959298},
{-0.08581516072887913,-0.059259743902431654,0.3618860858339407},
{-0.10009274858711373,-0.04837586985876898,0.386493842911397},
{-0.17610903017448976,0.0023262872274108387,0.3197839218415956},
{-0.1389999024655616,0.023474903662024295,0.4067749480674551},
{-0.06666933220411476,-0.01863937640963018,0.4282252548768734},
{-0.1414461388781359,-0.030093917788767095,0.30618362281675826},
{-0.2177229161706647,0.06444542584686846,0.31673793950320445},
{-0.18110933610549232,0.07834014559892506,0.3771414412924465},
{-0.25755573850835317,0.19427163886329366,0.3445322254390413},
{-0.22963665695562913,0.13166906867938966,0.36509321202714734},
{-0.2617054956718336,0.19692142540826635,0.3647939448682044},
{-0.28510891446593234,0.2938621759630314,0.3497893922514038},
{-0.29325818940945625,0.3823265174329178,0.5055064551441542},
{-0.31087860354916313,0.46832160193954187,0.4756415312543353},
{-0.331101551524536,0.4473086855931942,0.47298568666970786},
{-0.3458298575330815,0.47486186155077326,0.44752495760886757},
{-0.0007421098577027273,0.12304484342693606,0.9529944587111279},
{0.1323954276339902,0.13197197066212557,0.9301132429352656},
{0.18400629066837745,0.05075667944307222,0.8610576489111582},
{0.11629921627140986,0.009887932324427378,0.8407038472792436},
{-0.05901318168848472,0.48986035612791895,0.8299096322224706},
{0.06297029319094516,0.5007381721319272,0.8310630829727285},
{0.09916708012787309,0.47503269826903616,0.8014768289070267},
{-0.12013759019663794,0.5440119609934941,0.8054763466870701},
{0.10219246513143825,0.5382374375946191,0.8111284976849202},
{0.14167513277708413,0.5053168385029615,0.7998569091033557},
{0.19824147224902902,0.5265744996513597,0.7602264252901346},
{0.1919096092019199,0.5831820337929567,0.7422994743438992},
{0.02243231503744775,0.5466932493446715,0.7981764089031375},
{0.10770164639343695,0.5733692211602479,0.7620692809530992},
{0.023660885479424153,0.5936963674176817,0.7955678170278166},
{0.08507607989100374,0.7236800894651296,0.730937015167514},
{0.03811900291936929,0.7037551970407687,0.7609921615024908},
{0.030478603306841507,0.7914998433996748,0.7634505139943746},
{0.042127001954929376,0.8176293800383959,0.7666806607382691},
{-0.275262176811157,0.1884123029092523,0.3160800363967023},
{-0.21759812055377756,0.08957175111876847,0.29568988652685924},
{-0.30819973841384773,0.29474543814468895,0.3053779035426811},
{-0.29981904635551365,0.3563581246490123,0.324212348829193},
{-0.3123870554231874,0.37880921960938957,0.36767999495971104},
{-0.09589816193018838,-0.011573278956369533,0.2922804218091851},
{-0.014505975953217417,-0.04009574125870318,0.2928474543208665},
{-0.020229611818993066,-0.07730300921003772,0.30839238407486774},
{0.05186590650385078,-0.06998368569920993,0.30906119165274837},
{0.07642641087200026,-0.021745939144568543,0.29110637372410114},
{0.16758900320409717,-0.011590241467402689,0.30775144347939876},
{0.13453997367175966,0.021180118240817943,0.28910358581425205},
{0.21759812055377753,0.08957175111876847,0.29568988652685924},
{-0.10770043478550603,0.5733692211602479,0.7620692809530992},
{-0.054012875757482155,0.5510247476977935,0.7930888672011069},
{-0.24530880554237935,0.5737751098171139,0.6868987017015217},
{-0.31797377959276646,0.4265877667582035,0.3724294980490084},
{-0.3159285854053344,0.48609831350234045,0.41545854210852495},
{-0.29928593886589866,0.5213561042927876,0.3254978648439237},
{-0.2961030448313109,0.4211597632275782,0.2922852682409089},
{-0.6863328807977712,-0.06651969862464327,0.4367258961203709},
{-0.7610721276259331,-0.10322172606877462,0.4263690715266685},
{-0.87942925996805,-0.25404510452844536,0.3445067816724915},
{-0.8656169295552976,-0.39450438874682797,0.42352300449688285},
{-0.44971554474801284,-0.5184603613378334,0.3810634161649096},
{-0.4729759938062603,-0.4779769055412284,0.3393937962039112},
{-0.4897725145529258,-0.8034850690525651,0.5077685271512251},
{-0.4836005837527012,-0.7146536103796028,0.5258687380315854},
{-0.5648049705003759,-0.6946972161490377,0.5339138146930482},
{-0.5672463604812265,-0.8204148666716344,0.50642606556374},
{-0.6222339748191523,-0.8169193777908632,0.4902353487825461},
{-0.718734911694985,-0.6533995598228388,0.5337344967192686},
{-0.660529266692474,-0.5176122357861731,0.543624852259558},
{-0.5621067196381655,-0.5304419521669306,0.5317353436332124},
{-0.7604227057749474,-0.8469381758879119,0.4215202165870338},
{-0.7608237480000898,-0.8645488971641712,0.26781199964378727},
{-0.7370544236108462,-0.8906178534063449,0.30287956798907617},
{-0.7211508579092858,-0.8868000768159429,0.2535138144507267},
{-0.7546033528826273,-0.8248978160161241,0.2321495318044053},
{-0.7648559791942687,-0.7915483077169129,0.2357952600686134},
{-0.7824497379594948,-0.8310115896356635,0.2264525513131104},
{-0.7919947852394652,-0.8828417537055516,0.253677381521404},
{-0.827791741559182,-0.8748136395551219,0.24204594538434934},
{-0.8223613148126946,-0.8009891567148221,0.21345563303788276},
{-0.8455466441792235,-0.7435759032991479,0.23499438722625993},
{-0.7012392931721653,-0.8550474677697146,0.2279270781650683},
{-0.7362075096671168,-0.8092789781783354,0.21114025028185032},
{-0.6963989194880472,-0.7709558193226023,0.20926225798888837},
{-0.7361554105260862,-0.7468242241620066,0.230620482595555},
{-0.6824799675773717,-0.873233702813172,0.26876795830130146},
{-0.6759203222392454,-0.885795653841191,0.32087921541116826},
{-0.6298743744316802,-0.9092257280097704,0.286204208035505},
{-0.6545015172360316,-0.8887083593071784,0.24758662845255255},
{-0.7064673813941852,-0.8863178568594274,0.3915644221023942},
{-0.6640090046701428,-0.8590506203735508,0.4430468546961015},
{-0.6153084238858811,-0.8626151709063857,0.4115292975884762},
{-0.5896550491640209,-0.8790627485689396,0.3382379222377914},
{-0.5790389404730967,-0.8636620001587207,0.25949552280579324},
{-0.6115488044761644,-0.8729586678128478,0.22481809221426804},
{-0.6759094177678668,-0.8124000802084451,0.4986099828012254},
{-0.7297484277872587,-0.8025678818488411,0.5002056704462776},
{-0.45199215605025517,-0.7637019226400453,0.4884227833178551},
{-0.45873233097009214,-0.8438715962146945,0.43353694404612836},
{-0.5109550560096057,-0.859072429316308,0.46729839904186043},
{-0.5703044588989271,-0.8686186882042094,0.45367629107426616},
{-0.49513993768700415,-0.8973483354627343,0.38181340147416337},
{-0.5681829334118456,-0.8914623441342124,0.3925894424119722},
{-0.696961105568005,-0.7327744185947894,0.2432720926104638},
{-0.7353133430140807,-0.7373288528072048,0.2877211411650459},
{-0.664985560662483,-0.8433833182185245,0.22456486615670093},
{-0.6713622532030371,-0.7949723117297582,0.22358225212470598},
{-0.6419468358555982,-0.7756944179405211,0.20541297959228183},
{-0.6152102836434747,-0.8057653151786002,0.20098212938882257},
{-0.5934413239482184,-0.7606462474382066,0.23037816100936637},
{-0.5775692600528625,-0.8198817591820194,0.23717164667816487},
{-0.47154145001602354,-0.7771859073035121,0.3581446405431881},
{-0.4958838649566033,-0.5000790574174941,0.2951967620989654},
{-0.4585518013883816,-0.5296956016814696,0.32857898381231226},
{-0.34854749412218705,-0.6726932045151781,0.3419272683875134},
{-0.5423151040862084,-0.5281483783536551,0.2574297312835351},
{-0.5624277957398655,-0.5678176336206663,0.2535683368076191},
{-0.8863293671347714,-0.6820516641737835,0.34646595169682665},
{-0.8921341807319203,-0.6625835479393882,0.3980259271981143},
{-0.8743235441470554,-0.5537726744851728,0.42758189106554256},
{-0.439389010352584,-0.6243548945022686,0.28969485048455235},
{-0.4086202269462816,-0.6932311705525963,0.27859046379745794},
{-0.3736180854292636,-0.6801373236428931,0.29589707148305056},
{-0.3550671563985924,-0.7690705573820547,0.21636712689593926},
{-0.45912610354764866,-0.840132574139804,0.2485328942466192},
{-0.4545874202383354,-0.8269308941242469,0.29827909267528485},
{-0.4388910394929664,-0.8453909525600973,0.21661671812971356},
{-0.43801262374303257,-0.7205650454746748,0.2821174544844336},
{-0.40610129405785067,-0.7496472706411043,0.20214527300252802},
{-0.3938640539553244,-0.8268363887056334,0.18687537824885095},
{-0.3967379879675217,-0.7903161024511436,0.18357495824496173},
{-0.6967636134752612,-0.5256476195841884,0.23720436009230034},
{-0.7505808145518958,-0.5400269825086222,0.24715166120534396},
{-0.6273675576225587,-0.7431821307215914,0.2931939741891163},
{-0.5976371222130746,-0.7505741507082758,0.2730885521830449},
{-0.5735430868983382,-0.7913059861307241,0.26149104106805665},
{-0.5525846929088829,-0.7780049542648297,0.21581463367942916},
{-0.5564678963275559,-0.8541012019756481,0.21539420572739187},
{-0.5482180579257636,-0.9033566991922817,0.2577701931121301},
{-0.5145062788552002,-0.9092257280097704,0.25396816742483036},
{-0.6369889362021787,-0.7420601817775381,0.2455172021065016},
{-0.6693097893680193,-0.7544767398538439,0.2752282517890906},
{-0.6928161948362482,-0.763365095635243,0.324532213322962},
{-0.7014961540535252,-0.7398671714225308,0.299086023557293},
{-0.5183470759962902,-0.7666449183043064,0.21610784279871742},
{-0.5108702434544397,-0.7552691314406806,0.25705413282494266},
{-0.5088456466018335,-0.7679522432617941,0.33460794487668566},
{-0.5105128191148114,-0.8063638494964861,0.19228278444465047},
{-0.4664587547457169,-0.8853812839288085,0.2661484619546023},
{-0.489127939133664,-0.852757528780232,0.20596789602465385},
{-0.8619651432514348,-0.6656065097270915,0.46996030166614267},
{-0.8546894376261209,-0.8186338030131478,0.4532183032763696},
{-0.844001844067271,-0.8595655537442017,0.4148115434734013},
{-0.8006299149632974,-0.8969024637441473,0.29333573231703663},
{-0.6390438232530583,-0.44375746274759975,0.5346710696498878},
{-0.79471121022064,-0.8039854631280446,0.47035407424369924},
{-0.7584962491647478,-0.5200051614497859,0.5276364740028315},
{-0.8428556629645988,-0.24059746810290686,0.41573478871678},
{-0.4030431956401501,-0.16109781371406906,0.33487328701356217},
{-0.42809803604412433,-0.24097791299322294,0.39813860673569196},
{-0.4009337862323779,-0.0855370967087277,0.18768957877844478},
{-0.3856578334390462,-0.2044915517607996,0.21207439999660752},
{-0.3951834949921216,-0.2497935722987657,0.3195815833171281},
{-0.13134375194993153,0.00307263771287192,0.2811469565317481},
{-0.2623561291307501,0.15979170036451212,0.29634536641749953},
{-0.29795680496565397,0.2651713001582965,0.28756120891816134},
{-0.3830977058809632,0.27037394461376657,0.2840947986277329},
{-0.29678639170436283,0.4049108892656989,0.25261843618975965},
{-0.3601098686071779,0.4086608158119682,0.24041875593309261},
{-0.33277478207716854,0.46048371023427026,0.2075042148810898},
{-0.2571498498514872,0.4863551743837005,0.20554989128847842},
{-0.3052434150623463,0.5309362882027553,0.102838252158631},
{-0.09392808743447476,-0.09888538128392894,0.2100704004788275},
{-0.046589353964593204,-0.030620967238727474,0.25825725950036926},
{0.002145151841734905,-0.09200708305996437,0.19555170264233518},
{0.06128615816693411,-0.028877463426100123,0.2612620471691084},
{0.09375725071621172,-0.09580305070760946,0.21269474325725046},
{0.1019331810342164,-0.16148673985990183,0.1251100291452288},
{6.058039654508402e-07,-0.17537661318023465,0.028122025881157028},
{-0.09110261773951524,-0.16343500541285855,0.11713037931203692},
{-0.21444188189367053,0.06606049921881578,-0.8976591128970213},
{-0.0010934761576762537,0.13752719302550004,-0.8318251843612918},
{0.14531359139370653,0.18766110599206756,-0.7784332576684181},
{0.1981954311476532,0.2892762399444113,-0.5723060352008452},
{0.24225555355640244,0.49495759069339706,-0.3154936181581257},
{-0.5444947867539752,-0.11139765638677927,-0.5277467303245474},
{-0.555375025973845,-0.09984860958902876,-0.6060662785886464},
{-0.5849770309426492,-0.2233102461442093,-0.49768794916577763},
{-0.5715330293409036,-0.16930645744620929,-0.6649770794069664},
{-0.5613773316637377,-0.4167131621210167,-0.3304315323387244},
{-0.5013421586855024,-0.33215383301256024,-0.31652954293908214},
{-0.5789286841513808,-0.3473934375679637,-0.3620326903935848},
{-0.6267811393839822,-0.46552642244285614,-0.40414818207317027},
{-0.572034635024314,-0.4937169041721114,-0.3491981275811035},
{-0.6098210515666395,-0.5467332324063927,-0.4235532946951564},
{-0.5249733597706184,-0.5829796952684894,-0.39791324766053654},
{-0.47956835255852226,-0.5061225577770387,-0.32761454389928146},
{-0.44773820060471353,-0.579300041982215,-0.3925906540199031},
{-0.48949869116053263,-0.4500541891647115,-0.3049889773968482},
{-0.3868258234844754,-0.5008702373964,-0.34151895651478553},
{-0.35526222527547424,-0.42668590700061015,-0.31885704177442403},
{-0.4013372516733821,-0.3679835027464124,-0.3043977127265479},
{-0.28026490595802145,-0.35011834380465495,-0.34311343255190685},
{-0.37509261228122154,-0.277814428917689,-0.32485450103259284},
{-0.2657365152580816,-0.2243170923348231,-0.3749666050564034},
{-0.20474780683819402,-0.2778447191159625,-0.3968603603685469},
{-0.3585505292000541,-0.5688499235778299,-0.4234418267655097},
{-0.3894307805360032,-0.6520449821560442,-0.5524562624682029},
{-0.4597306959051893,-0.6560820597819471,-0.5414730365742028},
{-0.4088904155148819,-0.6430960459780979,-0.5604625676758755},
{-0.43869233579229167,-0.6715894296900891,-0.5858045591594834},
{-0.4902862363156457,-0.6724714802638156,-0.5983386432050908},
{-0.30876434770966726,-0.6279521584492389,-0.64101147453291},
{-0.2875393999754044,-0.6217293401159146,-0.7248256647638365},
{-0.2687970368916441,-0.5490316526513921,-0.6444912125105788},
{-0.23844262339772426,-0.48765886451739543,-0.5684555451963078},
{-0.24621024184300108,-0.46973797161081465,-0.6401972740033162},
{-0.29077196993516086,-0.5978170459908198,-0.8016028361318448},
{-0.2802334041518169,-0.4847788724655435,-0.7637764365277983},
{-0.32377616997405345,-0.5832947133305346,-0.8727617815240695},
{-0.31707355490007566,-0.45722206168417145,-0.8134002625554386},
{-0.35540882983511835,-0.5393000177500562,-0.8784527039757097},
{-0.3871190326037637,-0.5681132659558165,-0.9187180703447448},
{-0.36728743399008545,-0.5907594297930756,-0.8926406328470545},
{-0.4147521746847851,-0.580898152843129,-0.9079505106624527},
{-0.38954951811323574,-0.6837067206074519,-0.9823299099351246},
{-0.44596804141760554,-0.7070071527274204,-0.9970909293578054},
{-0.4284724228947858,-0.5314681840844395,-0.9001962199044163},
{-0.38274028154133494,-0.41857661511880734,-0.8388924934224835},
{-0.4729881098855697,-0.43495513112929746,-0.8627963062920618},
{-0.4880508196830555,-0.5372075708533174,-0.8939673435314373},
{-0.4415190170951821,-0.5679618149644485,-0.9241654596022656},
{-0.5561044139482728,-0.7316972991441808,-0.9132246399858484},
{-0.5112349374416536,-0.6995872657583243,-0.9608953540288084},
{-0.4916335443348545,-0.7002572849441359,-0.5874680968486684},
{-0.4697022291768518,-0.7281388066510007,-0.5110834864502857},
{-0.42065997495606416,-0.7237152260951271,-0.515021212225851},
{-0.4494744347697551,-0.7622552627704992,-0.43301716424375375},
{-0.5044487214204407,-0.7318329992324465,-0.41007052163962054},
{-0.5179908632645928,-0.7253557432336242,-0.5435388280964609},
{-0.5328488113217492,-0.6926435407060889,-0.6304256560402594},
{-0.5845626610302667,-0.7419220584734104,-0.5861171540056668},
{-0.5584791654929215,-0.700920034482362,-0.6774045419546507},
{-0.4345025955670901,-0.7469744635454435,-0.3861315721400449},
{-0.45187584168888456,-0.8070169061712645,-0.4011179506378813},
{-0.4788159440334065,-0.7610400200157631,-0.38145840035039696},
{-0.5284955040258703,-0.7662717430615759,-0.36340907700313624},
{-0.5631511256746384,-0.7475693630395367,-0.41483214080822733},
{-0.575469543508538,-0.7661154456384841,-0.4813179144108042},
{-0.6256797877747549,-0.7468145312985591,-0.48192977641593043},
{-0.6279866892752708,-0.762684171978053,-0.5744832946527502},
{-0.6330306130917872,-0.7780691694851697,-0.6377558840224656},
{-0.5896659536353993,-0.7600428666885969,-0.7607643792114734},
{-0.43732079561446396,-0.8047342368293676,-0.3614595998422487},
{-0.3915438247675682,-0.7470495832371621,-0.34957493764762687},
{-0.3895361904259953,-0.8051364906624408,-0.3356123678514375},
{-0.3918103785123757,-0.8576063837198666,-0.3687171313485984},
{-0.42116158063947456,-0.8655811871213347,-0.4048509146731173},
{-0.5406539896128852,-0.8415780224014192,-0.36824581586346145},
{-0.48690706179624516,-0.868710770406961,-0.4033909271163307},
{-0.48368660791579815,-0.8093577326938467,-0.3657632312129589},
{-0.5720940038129302,-0.7968115325689299,-0.38471035603704856},
{-0.5647771035179643,-0.8629047452018813,-0.41705786457736993},
{-0.5894333249126582,-0.7886937594316106,-0.447002754590631},
{-0.4304606715094636,-0.8509364820600244,-0.4617698320529667},
{-0.5557445663927828,-0.787683278417204,-0.9292723870311911},
{-0.5958863487528617,-0.8315652944601046,-0.7464322689963464},
{-0.5115172420895633,-0.762407925369798,-0.9824547055520116},
{-0.4777885005079667,-0.8253243020078161,-0.977500440722385},
{-0.3798639243132758,-0.7781249034499931,-0.9999987883920691},
{-0.3242826220891877,-0.6936831003108382,-0.9557302694191976},
{-0.3002322046599653,-0.7505850551796543,-0.9553740566875003},
{-0.315084094677467,-0.8010376210320599,-0.9611328291832733},
{-0.2690393584778328,-0.7701997759736936,-0.8971599304294727},
{-0.2916685598040588,-0.8245064666544295,-0.8984926991535102},
{-0.545075146952897,-0.8256175111271045,-0.9185617729216532},
{-0.5630711595511962,-0.873274897482824,-0.7114228578317429},
{-0.6110144853786185,-0.8733803073728161,-0.648136940774787},
{-0.6365188323249727,-0.8332385250127371,-0.6479951826468666},
{-0.6408963717794705,-0.856832166251994,-0.5695944566513944},
{-0.19087610763682542,-0.8499066153187227,-0.48688161802969526},
{-0.22289648203579213,-0.8484005866605603,-0.5521848622916716},
{-0.2605641610008851,-0.8330155891534435,-0.6956247020201745},
{-0.3021077737370654,-0.8576136533674523,-0.7056362183535582},
{-0.30669128653982347,-0.7794588837819616,-0.4868174028093553},
{-0.3210427824818456,-0.7946282150773704,-0.4845953138640055},
{-0.3248860028387974,-0.8497660687987332,-0.5125446856150031},
{-0.3327275293678618,-0.8298545040616129,-0.47479825213439886},
{-0.369152098595807,-0.8596564243390226,-0.4746746681254426},
{-0.32913995828433895,-0.8296436842816287,-0.3863496615676147},
{-0.36094587807952877,-0.8704700251226906,-0.41328612908834383},
{-0.35300136487633427,-0.7924873038633937,-0.35012743086413695},
{-0.33755578697267036,-0.7543943505145397,-0.38706935667859493},
{-0.38788355720818884,-0.7180521706258985,-0.3894634939501387},
{-0.3413505430123845,-0.8437649747167716,-0.9262700225783139},
{-0.3936556573912022,-0.8360773223949369,-0.9671702715031631},
{-0.3931952463774438,-0.8657217336413241,-0.8771126656040865},
{-0.27618299883867387,-0.7228465032086407,-0.8912303212154367},
{-0.25130262997675534,-0.498588779662434,-0.4866695866417802},
{-0.30923566319480417,-0.6070507100325379,-0.587369956606262},
{-0.3338773452943269,-0.6461783765544175,-0.5944263611960752},
{-0.35055876328755275,-0.6254295907370151,-0.5470682419992985},
{-0.29560022753996945,-0.507334165707982,-0.4046231323820999},
{-0.1368941278815823,-0.4096931057691318,-0.5031971304277764},
{-0.11001218271774565,-0.4097427816943005,-0.5940689368564469},
{-0.5437169344623096,-0.43850514236696103,-0.841909397170532},
{-0.536713840621458,-0.3572547145179104,-0.7794485851145485},
{-0.5981302466409685,-0.4009319688204816,-0.7726950825074711},
{-0.3345740198546192,-0.3908586604826199,-0.7662880997686434},
{-0.2949023413717462,-0.4164768985744828,-0.7389845150448386},
{-0.40228351746744867,-0.3579344265671695,-0.772289193850605},
{-0.44952774551871666,-0.3840712328534761,-0.8251455898380019},
{-0.22164246782726596,-0.40382771177543586,-0.3942263247266764},
{-0.12463507883629907,-0.32016981896760105,-0.46066726883580833},
{-0.08331076713561954,-0.3433793804927489,-0.5151896257282521},
{-0.02915431583832064,-0.3289927479207294,-0.5803680743733413},
{-0.06600294784209601,-0.3587583199602109,-0.7169780801951173},
{-0.13333078895667838,-0.42044733776418364,-0.6567357222606909},
{-0.16560075458941942,-0.4215620170606514,-0.7087161257140158},
{-0.2587673464392964,-0.4487601918944642,-0.6847953503334042},
{-0.42061393385468826,-0.20923378520251124,-0.35138750311231787},
{-0.3442087261214795,-0.14805848916125847,-0.3906557161541868},
{-0.3174334024555658,-0.16796278425079325,-0.37374166943821985},
{-0.45640483213475025,-0.0838202482705812,-0.4613966568102361},
{-0.49552644061697504,-0.17496103165992116,-0.39366898507844256},
{-0.5639616913804395,-0.22287285568113888,-0.43016019274258965},
{-0.4156160511395476,0.061165603177805214,-0.5873457244476431},
{-0.3868524788589562,0.10767196199912876,-0.5407375905601204},
{-0.40603223240578695,0.015895084446043758,-0.48127187330942833},
{-0.43361448695370874,0.008202585692485357,-0.5334267483048091},
{-0.40320555110289646,0.07598720299703338,-0.44210907015755146},
{-0.3968700532319945,-0.003969227581769974,-0.41546460014817965},
{-0.3833921266081824,-0.08219548203518633,-0.424053688770636},
{-0.363009246385925,-0.09538746918729583,-0.3936617154308569},
{-0.3978042029467517,-0.059614745026198124,-0.23347139605706432},
{-0.3555396834916602,-0.13113838440563674,-0.27381551694161077},
{-0.4290964009792216,-0.042154263133375676,-0.47906311205131885},
{-0.39053334375316157,0.15156488251340788,-0.4517401416006189},
{-0.6391201545527078,-0.3958008092329372,-0.6755398773489292},
{-0.6638042429298134,-0.4595980248367511,-0.583658801513783},
{-0.6064491466948245,-0.32847539133421666,-0.4941100709457024},
{-0.6354841191519472,-0.4184324337750251,-0.44228838813133103},
{-0.6463110476228555,-0.5102614104691408,-0.4684348872810852},
{-0.6081805344281423,-0.35951678652498137,-0.6922794525228403},
{-0.5506703523779927,-0.31424263296942695,-0.6713755808902774},
{-0.5786948438207088,-0.31682578107819787,-0.6041386103705157},
{-0.4861873666852649,-0.3279083588225353,-0.7435050242351877},
{-0.3391769183842724,-0.31710566251024574,-0.8414683718836687},
{-0.3994447200852488,-0.27336055816354177,-0.848138273543511},
{-0.2162302151997427,-0.3929717047141848,-0.7777414295398495},
{-0.11210341800655362,-0.3337349813624411,-0.8144337641205331},
{-0.2450349821499862,-0.3409864548291361,-0.8424134260698044},
{-0.18265171300158298,-0.28293710724971666,-0.3948430331635265},
{-0.43330310371545633,0.0709481256122406,-0.30563961085576474},
{-0.45504177321243916,0.2280015920528212,-0.2311875151072364},
{-0.45869719434009476,0.15617383908271582,-0.18234759941091622},
{-0.43182978847142944,0.03440481880706292,-0.13155336012198468},
{-0.2686249885654502,0.490460102053736,0.24779865984046762},
{-0.30232101673291134,0.42838215810393043,0.2628589464220915},
{-0.23533727227071685,0.5283967579794983,0.20151644848636852},
{-0.2100207245536588,0.5563073582767057,0.20791737318554143},
{-0.35855295241591595,0.47934723411112506,0.4068997436843423},
{-0.3709901078270479,0.4573735126755391,0.38077626508527607},
{-0.6803075545571907,0.029787380982238397,0.34824216892358933},
{-0.5696308048893227,0.2218817603936271,0.33730377252303423},
{-0.47729295286421086,0.1421628049692887,0.3449950596686616},
{-0.49166019970933533,0.2351210002550434,0.3283245461468142},
{-0.4500002726117845,0.4061758079456037,0.2580730950948659},
{-0.48317773258480196,0.4535096949837614,0.23765507824261117},
{-0.4333491448168322,0.5174062624379127,0.15712313389660987},
{-0.5218534693484397,0.4958287367957454,0.17508522147284275},
{-0.5579884642808896,0.4364235999416004,0.22774049054370302},
{-0.6347329222347624,0.43181585498022346,0.16771743364477718},
{-0.6038054181895065,0.47582508985587324,0.1264367398296116},
{-0.7372725130384159,0.009205797059306384,0.31481754093265946},
{-0.728229071441856,0.1817084762273436,0.2718224218952093},
{-0.6471191901127947,0.20047870629351563,0.3228408086513653},
{-0.6178091826553478,0.2851070970540359,0.30034003776581925},
{-0.81209172599002,-0.10965415257415206,0.37778601671170825},
{-0.6320613267470327,-0.3657892807834742,0.07657786186336821},
{-0.7401561399140607,-0.3710706797544556,0.09786702481797108},
{-0.6799852668475598,-0.2750010753020388,0.04185075534667436},
{-0.7978420051141971,-0.34576745972463796,0.11267408534202784},
{-0.501371237275845,-0.3320993106556678,0.0902520689719931},
{-0.6197344276576167,-0.12321446853726827,-0.0029302737809861006},
{-0.688233893641421,-0.1191471007130919,0.01834313827051451},
{-0.7339951135852145,-0.13550138456496316,0.05289577324515253},
{-0.796693400795663,-0.28159343405430076,0.09597207001397592},
{-0.4818316361735241,-0.4924168488622094,0.27697539042551067},
{-0.4889207541774727,-0.44128699417640654,0.2305695950624554},
{-0.45380472151494616,-0.3867137497508632,0.4116892298353607},
{-0.392977156949874,-0.04720303338161601,0.111561829261422},
{-0.3387140841546521,-0.012614050169049668,-0.9013205920643316},
{-0.4154209822626657,-0.0983849872084494,-0.886528070835446},
{-0.31522342958952543,-0.6023957123618541,-0.8324443160140038},
{-0.30957975984719205,-0.6229651802054768,-0.7148807868666547},
{-0.35731226589463017,-0.6477752758074005,-0.6022690993330704},
{-0.3871650737051395,-0.6736806649788969,-0.5914155154876812},
{-0.00043557305117409916,-0.28233857293183073,-0.7744640300866482},
{6.058039654508402e-07,-0.30479693753979387,-0.6979461428158616},
{0.020152068911412663,-0.3235393006235541,-0.5873566289190216},
{-0.06160359944484127,-0.32530703659480026,-0.4702498759616381},
{0.04442542219992862,-0.33138567358434223,-0.45313106750534166},
{0.05236145414760654,-0.33290624153767595,-0.5335442742741106},
{0.09498097472646434,-0.3165822478840783,-0.45771579191603073},
{0.08331197874355045,-0.3433793804927489,-0.5151884141203211},
{-0.26813065252962537,-0.23418321571649356,-0.2969402659115926},
{-0.31676944130940893,-0.17577159736572207,-0.1939935748431422},
{-0.21544024682876772,-0.24520036663256006,-0.14050956594751676},
{-0.14714069615356892,-0.3189509413890722,-0.3002939966644434},
{-0.08909740661380423,-0.3397772701140548,-0.37698272065349286},
{-0.4952998699338887,0.2522495015747874,-0.19649312200467803},
{-0.45918789555212675,0.06869574646861713,-0.11912347435843845},
{0.07269465844469523,0.6185815827113241,0.019333021950095095},
{-0.10871818544749833,0.6197471495408913,-0.05610168783042819},
{-0.08718185447498306,0.6166938975549147,0.03947963862581853},
{-0.19818210346041285,0.6039429356896685,0.01716182053784489},
{-0.39981426050418645,-0.018633318369975425,-0.020223553779338314},
{-0.11604477860591182,-0.2833345146510661,-0.11350282516679297},
{-0.028926533547303315,-0.35313645916063446,-0.3001510269285921},
{0.018781740341515907,-0.35314978684787485,-0.3982694603922338},
{0.10055558281673399,-0.3430219561531207,-0.3364423192841336},
{0.1826553478253758,-0.28293710724971666,-0.3948418215555955},
{0.20474901844612495,-0.2778447191159625,-0.3968603603685469},
{0.13649308565644006,-0.32140323584130126,-0.45133909937547667},
{-0.04984130965124474,-0.24621569407869032,-0.03952204490340152},
{-0.09281583135386891,-0.19423286740950357,0.009331198480159028},
{-0.01556976771658554,-0.3105484403879812,-0.14075552235749825},
{0.07139944956651695,-0.2633926597156721,-0.06283338149474858},
{0.08952146938963432,-0.3145782483662983,-0.18278741308984858},
{0.0928170429617998,-0.19423286740950357,0.009331198480159028},
{0.19653916310605385,-0.23732370347349824,-0.09634766847256829},
{0.17042658897836613,-0.30112213068524313,-0.24661613049986703},
{0.2681330757454872,-0.23418200410856257,-0.2969354194798688},
{0.2657377268660125,-0.2243170923348231,-0.3749666050564034},
{-0.2910264076006589,-0.07397472222373684,-0.9326600428061083},
{-0.3727735947013962,-0.1731593706666086,-0.9008953176805705},
{-0.2807907438000508,-0.22090278118542522,-0.9147464195471131},
{-0.17574675940313775,-0.10808148547978777,-0.9425516099543284},
{-0.15504037986331853,-0.005253531988569699,-0.9287756277795044},
{-0.007865152883717768,0.0674393090442291,-0.8851274520672758},
{6.058039654508402e-07,-0.025682453312202917,-0.9119900115042173},
{0.15504159147124943,-0.005253531988569699,-0.9287756277795044},
{0.15398991578719073,0.09873998833221562,-0.8780710474774626},
{0.3047345397313502,0.011241298383290833,-0.9061185594708665},
{0.30010983225894,0.09092754039349388,-0.8446149176803281},
{0.4203691890526377,-0.003989824916596062,-0.8414913924343567},
{0.4154221938705966,-0.0983849872084494,-0.886528070835446},
{0.508880783231831,-0.0982504987281146,-0.7997842126274991},
{0.48079328817670575,-0.18400568486441204,-0.8286919662518727},
{0.37277601791725806,-0.17316179388247044,-0.9008953176805705},
{0.3994422968693868,-0.27336298137940357,-0.848138273543511},
{0.48020323511433644,-0.2690254249866269,-0.7903639609644157},
{0.5303310900412492,-0.20620718859101514,-0.7639799866601967},
{-0.4807969230004986,-0.1840117429040668,-0.828685908212218},
{-0.16619686569144348,-0.21154310991888906,-0.9198303264253507},
{6.058039654508402e-07,-0.09842497027017047,-0.9094577509285461},
{-0.5303310900412492,-0.2062132466306699,-0.7639763518364039},
{-0.48019838868261266,-0.26902905981041986,-0.7903663841802776},
{-0.5874935406152182,0.28843296082447495,-0.17425890486393947},
{-0.5344372293192158,0.16729518828084333,-0.15482229043574874},
{-0.5456470258963022,0.03323319393784079,-0.11036112580185727},
{-0.13524270627170673,-0.2815619322480961,-0.8741878440587896},
{-6.058039654923549e-07,-0.24056111986497847,-0.8381110063070252},
{6.058039654508402e-07,-0.16376819759386782,-0.8920723887274421},
{0.16619686569144343,-0.21154553313475088,-0.9198291148174199},
{0.17574797101106862,-0.10808148547978777,-0.9425516099543284},
{0.29102640760065884,-0.07397472222373684,-0.9326600428061083},
{0.28079074380005076,-0.22090278118542522,-0.9147464195471131},
{0.3391769183842724,-0.3171068741181767,-0.8414671602757378},
{0.4022823058595177,-0.3579356381751005,-0.772289193850605},
{0.48618857829319584,-0.3279083588225353,-0.7435050242351877},
{0.5506715639859235,-0.314241421361496,-0.6713731576744156},
{-0.4006672324875704,-0.3034193393223114,0.24346231505562194},
{-0.44393011687775913,-0.3271632199450052,0.14304909617077374},
{-0.43049338492359907,-0.23174788377529765,0.10724244698760951},
{-0.7529810098630944,0.27639321281469237,0.05555282943771095},
{-0.7155265738938474,0.36048607286973566,0.09569218858192803},
{-0.7474936375438527,0.2661042382651228,0.17653551616618174},
{-0.7947548281061538,0.11980985025131764,0.10962810300363665},
{-0.6706098446779214,0.4282597857029053,0.03374025185694062},
{-0.6922818757387023,0.2787558482800316,0.25538817191989577},
{-0.17538327702385476,0.5883992175435983,0.09776524975177185},
{-0.19102028898060763,0.5472905720546265,0.1634683246309594},
{-0.17313816752781702,0.5719261961144944,0.1679028096582115},
{-0.7741417423770174,-0.0610105173626446,0.08137219444611042},
{-0.6852303175806129,0.0696020292009626,-0.07819778166703922},
{-0.01280366681024223,0.5959644974644075,0.1244145661928674},
{-0.10014121290435145,0.5851278761300515,0.14228093674255574},
{-0.04775492079416056,0.6174778078862347,0.14628166613053017},
{0.05692558122346956,0.6162201588539158,0.1482008530931442},
{-0.04959656484919422,0.6157391505053313,0.16687657774070258},
{-0.12550380172278536,0.6030427109969775,0.1803011936155532},
{-0.024053446449049786,0.7065031238281478,0.7649710819477082},
{-0.8150504725573834,-0.08848009237298873,0.205686802984675},
{-0.8627635928779264,-0.16988681764513097,0.23635865775650197},
{-0.8509201253529567,-0.1341153050919641,0.31173157553254716},
{-0.7849638244162019,-0.022209984982119815,0.2489545338065874},
{-0.8497194218933919,-0.24766962359582226,0.1506773797039921},
{-0.8035426204292849,-0.1404980556721729,0.1277634505139944},
{-0.8008043865053532,-0.03764950484612888,0.1626492776696418},
{-0.020193263581064772,0.7927538576082012,0.7693510446180679},
{-0.045781211474654096,0.808369060622197,0.7593577024036484},
{-0.02252924367192325,0.8198987216930523,0.798378747427605},
{0.012403836193030931,0.8135353568397389,0.7984708296303566},
{0.0038401913371244336,0.8032488055060311,0.8538812951361818},
{6.058039654508402e-07,0.767012035507382,0.8922371674060504},
{-0.02289757248292998,0.67021667790433,0.19943732927687002},
{0.08088512805787122,0.6785319431343932,0.21906901258194258},
{0.10414315390025679,0.7231397123279291,0.28852564883119214},
{-0.15912228698266617,0.661649398224631,0.2375860165905474},
{-0.18673119690506873,0.6988469733125178,0.32886492328401484},
{0.10082213656154149,0.610758230301224,0.1736579473301917},
{-0.4937162983681459,-0.8607929125782473,-0.9020330175277261},
{-0.6725278200326045,-0.8183454403255834,-0.49383745916124017},
{-0.6592861569553263,-0.7700459017664638,-0.5090891797959531},
{-0.647773458395504,-0.771601606349795,-0.4637520226279897},
{-0.6319353195222145,-0.8070265990347121,-0.44188734590618883},
{-0.36346844579175247,0.4176812368578402,0.36559966414228157},
{-0.3726899937541612,0.3702116497314167,0.367552776126962},
{-0.3452337464310575,0.33741584625664645,0.37671010886903067},
{-0.37465643342608196,0.4454076727495441,0.38958344313530213},
{-0.3055972045781818,0.3773637713477744,0.4165926071318878},
{-0.3349786969035542,0.4112270014097057,0.39973065955695136},
{-0.36412271407446184,0.3494568058743599,0.3941802836253006},
{-0.2872255935212901,0.10471806186348932,0.3994507781249035},
{0.8596182586891977,-0.5272663277799284,0.274515826325696},
{0.8880050209032659,-0.4914415044778001,0.3514432370771413},
{0.8701228994504752,-0.5114378817700866,0.3436101918035936},
{0.8676160826413537,-0.4775613240209149,0.4062733423840446},
{0.8735481150712516,-0.8382727559658061,0.41405307690863086},
{0.8700817047808231,-0.84512439881529,0.3563005732722926},
{0.8484787353721059,-0.7425848080116363,0.32843843729232286},
{0.8690881862774498,-0.794571269504616,0.32468487592226086},
{0.8632276387154775,-0.7724618479807647,0.261995069967329},
{0.859676415869883,-0.841770668062439,0.254252895288602},
{0.8455454325712926,-0.743574691691217,0.23499438722625993},
{0.8148251134822277,-0.7210327261360189,0.2573315910411287},
{0.8098514629257061,-0.720538390100194,0.30156376177607186},
{0.8464008277705384,-0.6655192739560636,0.2973825028063869},
{0.8863281555268404,-0.6820528757817145,0.3464647400888957},
{0.8517391723142741,-0.5341737045942356,0.3030067868218252},
{0.8106826259663331,-0.536854992945413,0.2699214090515594},
{0.7539030434985422,-0.6488124121962879,0.26240338184005685},
{0.6759990767547567,-0.7003505787548185,0.28106699040830585},
{0.7911490829036669,-0.7302385231953252,0.30699903495428305},
{0.7753194252858941,-0.7495975947159357,0.3327081436409667},
{0.6533286807588785,-0.7515204165023426,0.334129359743963},
{0.7724442796657658,-0.7674494259704526,0.3306641610614655},
{0.6270695020715467,-0.7653133611881998,0.3311076095641907},
{0.7558440394039132,-0.7699828981540549,0.3186316826992686},
{0.76209593632758,-0.7585307799907798,0.26524096761432586},
{0.7353145546220117,-0.7373300644151358,0.28772356438090774},
{0.7361554105260862,-0.7468230125540756,0.23062169420348594},
{0.7648571908021995,-0.7915483077169129,0.2357952600686134},
{0.8027053993490031,-0.7487446227325516,0.22142680161555806},
{0.7102778883370016,-0.45046128942950847,0.5298912763623168},
{0.7574167064982774,-0.433023828087374,0.5304486160105507},
{0.6940229563354676,-0.44062787946197346,0.5452375024156434},
{0.5850363997312654,-0.7755853732267362,0.3029268206983829},
{0.5664127742247376,-0.7759585484694667,0.3170141861114595},
{0.6273675576225587,-0.7431821307215914,0.2931939741891163},
{0.5976371222130745,-0.7505753623162068,0.27308734057511397},
{0.6369913594180404,-0.7420601817775381,0.24551599049857065},
{0.5934413239482182,-0.7606474590461375,0.23037816100936637},
{0.6419480474635292,-0.7756944179405211,0.20541297959228183},
{0.5875831996021079,-0.47220601696614595,0.17664456087996663},
{0.6009569279438589,-0.5182871014037085,0.2056141065088184},
{0.5431220349682165,-0.5163400474586828,0.23406629555115743},
{0.6119086520316545,-0.5259480983510623,0.23166488863202803},
{0.6266309000005452,-0.5443536344300204,0.208758229089616},
{0.548679680547453,-0.6081835634479698,-0.8460349221753937},
{0.5691086018710861,-0.606300724723284,-0.8354491036827429},
{0.5666393449078239,-0.6203735508411892,-0.7729131719350408},
{0.5381956371210015,-0.6465248964226671,-0.8396303626524279},
{0.5498815956149485,-0.6562359339891769,-0.7609509668328387},
{0.5432274448582086,-0.6566515155094904,-0.6577498380988903},
{0.542172134350357,-0.6531935864745785,-0.609979772205593},
{0.5160159423371553,-0.6627543846576511,-0.605883325791074},
{0.5041385497901192,-0.6601748713726731,-0.575232068354073},
{0.5798701035137236,-0.6000573090551338,-0.4727167097090384},
{0.6285985512803969,-0.5817414319630655,-0.5591540311104569},
{0.5958269799642454,-0.617371186388312,-0.6849758799151148},
{0.5732644170742213,-0.6409902713941187,-0.6688736105128797},
{0.5854180562295125,-0.627245791025499,-0.7748759767831689},
{0.6537636480060871,-0.5369119385181672,-0.6545911762229213},
{0.645704032049453,-0.47841671922016077,-0.736844815438793},
{0.5417141465524605,-0.590858781643413,-0.877978965274711},
{0.48695310289762095,-0.57618499799176,-0.9153813021029272},
{0.5153095749134154,-0.6255640792173499,-0.8877554296694915},
{0.4647382714837775,-0.5914379302344038,-0.9101047495636697},
{0.441521440311044,-0.5679618149644485,-0.9241654596022656},
{0.4147521746847851,-0.580898152843129,-0.9079505106624527},
{0.3895495181132357,-0.6837079322153828,-0.9823299099351246},
{0.44596804141760554,-0.7070071527274204,-0.9970909293578054},
{0.5112349374416535,-0.6995860541503934,-0.9608941424208775},
{0.5115172420895633,-0.7624091369777289,-0.9824547055520116},
{0.47778971211589755,-0.8253243020078161,-0.977500440722385},
{0.5557469896086445,-0.787682066809273,-0.9292699638153291},
{0.5450763585608278,-0.8256175111271045,-0.9185605613137223},
{0.49371629836814585,-0.8607929125782473,-0.9020330175277261},
{0.4700184588468279,-0.4534248824285955,0.4680374798797358},
{0.4730293045552218,-0.464612870062925,0.4142336064903414},
{0.5117995467374731,-0.4438398520869039,0.4686917481624452},
{0.49940479760392414,-0.4402086631178671,0.4918601150179409},
{0.5609120742182554,-0.44394768519275785,0.5117098877505833},
{0.5618619748361149,-0.44532770662610216,0.5328548693614039},
{0.6390450348609892,-0.44375746274759975,0.5346710696498878},
{0.6268986653532836,-0.4410325565109085,0.5458275554780126},
{0.4792848363026815,-0.4727706262619655,0.4338180370861072},
{0.4486650806718851,-0.6553211700013147,0.49819318967298104},
{0.4188583139627515,-0.6036460917465875,0.44149963136828707},
{0.35297470950185345,-0.711493736895703,0.4391479003743263},
{0.483603006968563,-0.7146548219875338,0.5258687380315854},
{0.45199336765818604,-0.7637019226400453,0.4884227833178551},
{0.3657474803098566,-0.7539581716594002,0.4290697456047408},
{0.44933146503390387,-0.7899562548956535,0.19996559033476125},
{0.4727615392024833,-0.7897381654680835,0.23549720451760137},
{0.4678666431614728,-0.8117446003178048,0.225629869528},
{0.43889225110089725,-0.8453909525600973,0.2166155065217826},
{0.39386284234739344,-0.8268363887056334,0.1868765898567819},
{0.3882070565257506,-0.8659034748309657,0.22606725999107047},
{0.4573607907922644,-0.752684771723979,0.3085196029076167},
{0.4557929701296239,-0.7728677366376306,0.34830759575186027},
{0.462104235841907,-0.7904845159535446,0.3333878556902258},
{0.30979421445096894,0.40897946869780616,-0.3644280392730595},
{0.42667318511733515,0.43791145448079866,-0.21116205922460726},
{0.2900316774893545,0.2739178978117754,-0.5184815644766247},
{0.27897575511949785,0.20511552984523512,-0.6388015016668696},
{0.3453585420479446,0.1439305409405348,-0.6283101885928325},
{0.35629572684056876,0.21374944796113643,-0.4807218033087801},
{0.4321544993969222,0.33358474197900395,-0.2593755736206298},
{0.3983639658108474,0.5046613586123211,-0.1608488282842602},
{0.2584159801393228,0.5705376934256337,-0.17460421312425825},
{0.12187503596961044,0.6163061830170127,-0.10107657422703956},
{0.2518393722901631,0.591410063251992,-0.08068763596512749},
{0.1981869498921366,0.6039417240817374,0.01716060892991395},
{0.17538327702385473,0.5883992175435983,0.0977640381438409},
{0.06848674410052952,0.5902929607396624,0.1344394102134914},
{0.17586065054864636,0.557243931207325,0.15960935337090532},
{0.17314059074367888,0.5719261961144944,0.16790402126614243},
{0.2100219361615897,0.5563073582767057,0.20791737318554143},
{0.16826750364542536,0.656143851786425,0.23952337767212561},
{0.2513183808798576,0.6061335228288138,0.27904845159535446},
{0.1867336201209306,0.698845761704587,0.3288637116760839},
{0.44947928120147884,0.015844196912944024,-0.7797708728241793},
{0.4980150833071323,-0.013269530059689954,-0.6701239898976131},
{0.4156172627474785,0.06116802639366704,-0.5873505708793668},
{0.38685369046688706,0.10767075039119778,-0.5407339557363274},
{0.39053697857695435,0.15156609412133887,-0.45173287195303324},
{0.45504298482037003,0.22800280366075218,-0.23118993832309828},
{0.40320555110289635,0.07598720299703338,-0.44211512819720616},
{0.4333031037154563,0.07094570239637864,-0.3056420340716266},
{0.4586984059480257,0.15618110873030142,-0.18235123423470903},
{0.2793222749877476,-0.7179831089738349,-0.5562170934858506},
{0.2894476824666399,-0.7357174142590505,-0.49959017361735847},
{0.32500352880809885,-0.7534844329584013,-0.4972626747820166},
{0.29821366584701386,-0.6803457202070153,-0.7186719080825759},
{0.25262085940562146,-0.7330361259078731,-0.6396472040026681},
{0.3270874944493211,-0.6571882578228981,-0.6616681781475605},
{0.3115304486160106,-0.6300918580552844,-0.7753545619158914},
{0.3254191103284124,-0.6153611288308772,-0.8611351918187387},
{0.3152258528053873,-0.6023945007539232,-0.8324479508377965},
{0.3672886455980164,-0.5907594297930756,-0.8926406328470545},
{0.29656103262920736,0.30211564918861644,0.45449170321179094},
{0.2886274238973913,0.3098372265325173,0.38181703629795627},
{0.3022786104553283,0.3171020276864528,0.39719234094162537},
{0.3463011730182184,0.3141541855904681,0.40358841920907446},
{0.31785140719174115,0.32001957958416394,0.44743893344577057},
{0.36412392568239277,0.3494580174822908,0.3941802836253006},
{0.3726899937541611,0.3702116497314167,0.367552776126962},
{0.3746576450340129,0.44540524953368243,0.38958344313530213},
{0.2452918430313461,0.5111713280252789,0.6774251392894768},
{0.21793615916651068,0.3675848837371319,0.7082811584668072},
{0.27884126663916314,0.42287055362606996,0.6003741445290753},
{0.28628780898274003,0.5427700628642775,0.546203153936605},
{0.31087981515709406,0.46832160193954187,0.4756415312543353},
{0.2932594010173872,0.382322882609125,0.5055064551441542},
{0.13496645966345164,0.7266121806580123,0.6620837596678741},
{0.21490592773122175,0.6225495986851629,0.6296272064137678},
{0.26503257105020356,0.6319444065816965,0.46727416688324164},
{0.13500038468551806,0.7570344441960647,0.5536387918088035},
{0.2223355075637654,0.6829664281616454,0.38904064278223954},
{0.3011372757843798,0.560610989647416,0.41233259364669156},
{0.242180433864684,0.5991243709483073,0.6082714050229631},
{0.2446908854975983,0.6093115704316776,0.6608612472655524},
{0.18308062220913685,0.6145033104157693,0.6818826448674168},
{0.05812143825131049,0.8441696517657065,0.7257149849851487},
{0.035743039766789685,0.8669830174974358,0.6746614615989954},
{0.03278792802321923,0.8519154612682264,0.5466514488710541},
{0.08703524991533888,0.7977420474598942,0.4856372966846167},
{0.21174363103146,0.5000015145099137,0.7115319025455278},
{0.17294431025886609,0.4336272088369835,0.7240950651814777},
{0.21262083517346286,0.5152883717746239,0.6654992824252028},
{0.21865343106162902,0.5145868507826079,0.6683538307105051},
{0.1934047333887038,0.5050381686788445,0.7195769792069905},
{0.12376635594981275,0.5136248340854388,0.7371743727960095},
{0.15625683422598546,0.5481895851393864,0.6998083842057213},
{0.07350280093463434,-0.06546559972472278,0.3503091720537785},
{0.1435288929114272,-0.008465504613500192,0.35841240589592654},
{0.2177241277785956,0.06444421423893748,0.3167391511111354},
{0.27526217681115694,0.1884098796933905,0.3160800363967023},
{0.26235370591488816,0.15978685393278835,0.29634536641749953},
{0.30820095002177866,0.2947393801050342,0.3053779035426811},
{0.2979580165735849,0.26517251176622747,0.28756120891816134},
{0.01626401906101595,0.8288028283775539,0.8445216238696456},
{0.8099568728156981,-0.5316584065295976,0.23763205769192328},
{0.7505808145518958,-0.5400269825086222,0.24715166120534396},
{0.7425514887935354,-0.5463140160622865,0.2176998956199768},
{0.6730791016411836,-0.5395278000410736,0.2012995706667297},
{0.7025417716979291,-0.5409793063423436,0.21462241147538105},
{0.5886421449337523,-0.8320353983373107,-0.4494090079414842},
{0.5768653158449845,-0.8745071027485932,-0.5393914941488424},
{0.6154841070358679,-0.8837989239709967,-0.5006951600503786},
{0.6405898349729418,-0.873084675037666,-0.48175530487387463},
{0.4913791066693564,-0.1155328742550884,0.025737581473060822},
{0.43890921361193047,0.0013703285698967445,-0.05901802812020846},
{0.5448909825473935,-0.13750901890653605,0.008667237334002157},
{0.5456470258963021,0.03323319393784079,-0.11036112580185727},
{0.4591891071600577,0.06869574646861713,-0.11912347435843845},
{0.3998154721121174,-0.018633318369975425,-0.02022234217140737},
{0.5235787990421028,-0.8783151864755477,-0.5010756049406948},
{0.4654349460440698,-0.8604875873796496,-0.4667967933584499},
{0.42698093353179467,-0.8712539354540109,-0.4908435759638795},
{0.4546480006348826,-0.8841490786630393,-0.541811075186936},
{0.6110169085944803,-0.8733803073728161,-0.6481333059509942},
{0.5630735827670581,-0.873274897482824,-0.7114216462238119},
{0.39319645798537467,-0.8657217336413241,-0.8771114539961555},
{0.5958875603607926,-0.8315640828521736,-0.7464322689963464},
{0.4507950874144832,-0.458405802632703,0.37045821194536377},
{0.4509550196613677,-0.4629977966909777,0.42203999638940837},
{0.4432346539253976,-0.3984469609541171,0.36143294446776797},
{0.4507502579210383,-0.4161340135300258,0.30055933880131996},
{0.4006672324875704,-0.30341570449851857,0.24345989183976005},
{0.39518712981591436,-0.2497959955146275,0.3195888529647138},
{0.4538035099070152,-0.38671738457465604,0.41168438340363694},
{0.3905830196783302,-0.7690184582410241,0.41801745805867696},
{0.44531498474282716,-0.7733899396558671,0.38148263250901593},
{0.4500935664224671,-0.7941399370812003,0.4378599611437337},
{0.4715426616239544,-0.7771859073035121,0.35814342893525714},
{0.458733542578023,-0.8438715962146945,0.43353330922233557},
{0.45458863184626636,-0.8269296825163159,0.2982803042832158},
{0.35873348199762645,0.02544376654980697,0.24879581316763386},
{0.4149981310947665,-0.04853095567392973,0.2770614145886076},
{0.3521496045008811,0.07313023149586922,0.27512041868323667},
{0.20216344712149217,-0.04780883734708753,0.24815123774837208},
{0.35257609049257316,0.15108387416482344,0.2882615183022465},
{0.4500136002990248,-0.022034301832132976,0.3239215629257666},
{0.40304440724808094,-0.16110266014579283,0.334876921837355},
{0.48422213862127494,-0.11709342527014319,0.4259122953367029},
{0.42809682443619335,-0.24097912460115392,0.3981373951277611},
{0.48539982153015176,-0.20624474843687438,0.45613706678201177},
{0.4863254899893924,-0.3620017943913458,0.46030499806445635},
{0.5487560118471023,-0.37060663391690435,0.5057911830079258},
{0.6146711181142049,-0.3759207463020212,0.526112271225705},
{0.5973681452524052,-0.18779680608033333,0.49419972993259226},
{0.7021055928427897,-0.1724069621414929,0.4859826049449355},
{0.7803912160848222,-0.23309761501036846,0.4703989037371441},
{0.8247275851018266,-0.3979514133103613,0.48218300247349766},
{0.7784356808842798,-0.44346667684417335,0.5273808247294026},
{0.8483139566934976,-0.44930299224752673,0.4765950666959876},
{0.3400844127245488,-0.8312502763980593,0.26034970639710814},
{0.33259061767166515,-0.8087470822966514,0.24363315177388492},
{0.35506957961445423,-0.7690669225582617,0.2163683385038702},
{0.2612971837991057,-0.8645755525386519,-0.5204455809326837},
{0.28238643144510295,-0.8631700873387579,-0.5670452335646899},
{0.3021271594639604,-0.8372961999734659,-0.5007775493896828},
{0.27295891013443396,-0.8714332534277903,-0.4625985718777318},
{0.29047270277621784,-0.8303246079388187,-0.43492302351912737},
{0.3066900749318925,-0.7794576721740306,-0.4868174028093553},
{0.3210439940897765,-0.7946282150773704,-0.48459652547193643},
{0.3248872144467283,-0.8497648571908024,-0.5125422623991412},
{0.2941075265690474,-0.1271534059207646,0.1011722912535841},
{0.20495983822610905,-0.1857479770691084,-0.024063139312497296},
{0.31916236697302175,-0.13178053660903669,-0.08582364198439568},
{0.34059571127140686,-0.09926703778217599,0.07445027833663195},
{0.39780904937847544,-0.05960384055481959,-0.23346170319361675},
{0.31677065291733986,-0.17576917414986024,-0.19398872841141843},
{0.2062986649898013,-0.16487318402688805,0.08965111143824528},
{0.18870854104836798,-0.10492403521174981,0.2006683229347083},
{0.29261603720605633,-0.06335376710108873,0.20633137840393678},
{0.3666670907294425,-0.03915068707256748,0.1606137763456572},
{0.3917146614858311,-0.0388090136360415,0.06489432658528298},
{0.2556413979774629,-0.7811939063390723,-0.3984003140487757},
{0.2619054109804392,-0.7420868371520187,-0.4332691786933899},
{0.23136683308101597,-0.7367012398989762,-0.42959921827056297},
{0.22477568593668498,-0.7818300005028174,-0.398479068564287},
{0.19659732028673912,-0.7728023098093597,-0.4265556591480336},
{0.19865220733761876,-0.8410897444052491,-0.4379084254609714},
{0.24520218404445632,-0.8418227672034696,-0.409207856792789},
{0.22902116012670995,0.138595831220592,0.8740775877370739},
{0.25932105126373733,0.05181320155885466,0.7986913422737884},
{0.20653250532047332,-0.007766406837345909,0.7743513505490704},
{0.08627920656643033,-0.06542682827093256,0.717476051054735},
{-0.03423701110862734,-0.040483455796604985,0.7780055600687952},
{0.042087018893208254,-0.09126194418243427,0.614520878730768},
{0.116914713100329,0.33366834292623915,0.901012843649872},
{0.11173024276382307,0.21986079836481381,0.9656921098274126},
{0.16293279392548246,-0.6295878291560122,0.40288568660912744},
{0.09124074104364271,-0.7731221743031287,0.39576870162276717},
{0.07976923715347253,-0.07586361898807725,0.5383894943899524},
{0.2604357305602051,-0.004605321745515148,0.7055005182652925},
{0.27520280802254077,-0.009168237213447275,0.6189468825025035},
{0.31029945495817224,0.05718547112465684,0.6978419445338006},
{0.2887752400649664,0.1911565948728386,0.8143634908605385},
{0.34930596068695746,0.1690302108379541,0.6195054337586684},
{0.32948284332879585,0.06743203939664337,0.5408793486880407},
{0.28195994545341097,0.02213607689833204,0.48943811076398547},
{0.1724681483420054,-0.056600264494011406,0.556847129609941},
{0.1796796387469793,-0.05328530519495087,0.6770034997295086},
{0.23734732982815157,0.1583317128077257,0.8861706464958179},
{0.20232580258423855,0.20006554798906395,0.9320990683340816},
{0.20467147553854456,0.20998134729590304,0.9143635514409351},
{0.1024214590303865,0.3798039497206939,0.8671847502179381},
{0.22604423944038254,0.3486716839351088,0.7724406448419731},
{0.21045811501672926,0.3114583579441193,0.8411036778964548},
{0.05988311618290189,-0.1290495723326906,0.39124213439276334},
{0.2844909944211513,0.28911751930545776,0.7260675628930533},
{0.311243297536377,0.31199146543373435,0.5500802993156233},
{0.33688213296306596,0.2765192200395104,0.52118587337849},
{0.197303687710479,0.5470627897636091,0.6773488079898273},
{0.1622070407748475,0.4679326757937091,0.727353078907784},
{0.21850076846233019,0.35642597469314513,0.7301422003648153},
{0.36436261244478857,0.17450546707788633,0.5071978598157508},
{0.34303225482053357,0.21748483521223425,0.44331462004884},
{0.32936047092777065,0.12359733664344616,0.4271008827169581},
{0.08225182180397515,-0.10191197789542504,0.38544095561940733},
{0.10009396019504463,-0.04837586985876898,0.386493842911397},
{0.29696813289400426,0.3071850167716826,0.47611284673947224},
{0.27301222088339544,0.32428080467729115,0.5215384512863944},
{0.24696749679984054,0.34211446181284394,0.621047810654759},
{0.3094682919175452,0.3743565604631735,0.4954161842952592},
{0.30447040920240453,0.3382676066320994,0.4706194163805758},
{0.24530759393444837,0.5737763214250448,0.6869011249173835},
{0.33110155152453596,0.4473074739852631,0.4729881098855697},
{0.25755695011628404,0.19427042725536267,0.3445285906152485},
{0.32281657649274637,0.2808495067847015,0.4626882308646217},
{0.2851089144659323,0.2938573295313076,0.3497881806434729},
{0.2992859388658986,0.5213657971562349,0.32550271127564745},
{0.3159285854053343,0.48609952511027127,0.41545975371645594},
{0.3179749912006974,0.4265865551502726,0.3724294980490084},
{0.2961018332233799,0.42117066769895656,0.29228163341711605},
{0.3123882670311183,0.37881164282525154,0.36767999495971104},
{0.2998214695713755,0.35636418268866704,0.3242075023974692},
{0.30232222834084227,0.42838336971186153,0.2628589464220915},
{0.5177970059956419,0.0332525796647359,0.357699980432532},
{0.5103613681234435,-0.017676148104530352,0.37284265635346},
{0.6067980897789361,0.03251955686651531,0.36474911537475946},
{0.593149326436861,-0.09382812978017203,0.45862449786423815},
{0.761074550841795,-0.10322293767670547,0.4263690715266685},
{0.6863328807977712,-0.06652091023257424,0.4367271077283018},
{0.6803087661651216,0.029787380982238397,0.34824216892358933},
{0.5696320164972536,0.2218817603936271,0.33730377252303423},
{0.6358027720377851,0.2429407178413507,0.31608851765221885},
{0.7282290714418558,0.181701206579758,0.2718260567190021},
{0.6922867221704261,0.27874979024037694,0.25538938352782675},
{0.87942925996805,-0.25404873935223815,0.3445140513200772},
{0.8852037833669252,-0.4804655482313857,0.40250645332674223},
{0.891562301788515,-0.2730964276345961,0.2670632259424644},
{0.8509237601767494,-0.13411893991575702,0.31173157553254716},
{0.8627611696620644,-0.16987470156582157,0.23636108097236386},
{0.883735314554622,-0.30411843709846564,0.21926529306675538},
{0.8471193112735877,-0.47478674185905495,0.24104758044925212},
{0.7978456399379898,-0.34577230615636173,0.11267650855788974},
{0.7401549283061297,-0.3710706797544556,0.09786702481797108},
{0.6800252499092809,-0.5007478649953748,0.1813395416123715},
{0.6320625383549636,-0.3657892807834742,0.07657786186336821},
{0.501371237275845,-0.3320993106556678,0.0902520689719931},
{0.534771633108156,-0.2761109081667828,0.044564757111987124},
{0.6799876900634216,-0.2750022869099698,0.04185196695460531},
{0.4439155775825877,-0.11384389279935359,0.0710686806013695},
{0.4729772054141912,-0.4779769055412284,0.33939137298804933},
{0.4497155447480128,-0.5184615729457643,0.3810646277728405},
{0.3357613956269435,-0.6923612360581791,0.38525073317424924},
{0.348547494122187,-0.6726956277310401,0.34192605677958254},
{0.45856149425182907,-0.5296762159545745,0.3285826186361051},
{0.4958850765645342,-0.5000790574174941,0.2951967620989654},
{0.43938901035258393,-0.6243536828943376,0.28969485048455235},
{0.5423151040862083,-0.5281483783536551,0.2574297312835351},
{0.5648049705003759,-0.6946972161490377,0.5339138146930482},
{0.4897713029449948,-0.8034850690525651,0.5077685271512251},
{0.5672487836970883,-0.8204148666716344,0.50642606556374},
{0.5109562676175365,-0.859072429316308,0.46729718743392956},
{0.6222351864270833,-0.8169193777908632,0.4902353487825461},
{0.7187337000870541,-0.6534007714307698,0.5337344967192686},
{0.6759106293757977,-0.8124000802084451,0.4986099828012254},
{0.7297508510031205,-0.8025654586329791,0.5002068820542086},
{0.7947112102206398,-0.8039854631280446,0.47035407424369924},
{0.8619651432514347,-0.6655883356081272,0.46996151327407365},
{0.8546894376261209,-0.8186338030131478,0.45321951488430057},
{0.7604227057749474,-0.8469381758879119,0.4215214281949647},
{0.7370544236108462,-0.8906178534063449,0.30288077959700715},
{0.7608249596080205,-0.8645488971641712,0.2678107880358564},
{0.8006299149632974,-0.8969024637441473,0.29333694392496756},
{0.7919947852394652,-0.8828405420976206,0.253677381521404},
{0.8277929531671129,-0.8748136395551219,0.24204594538434934},
{0.8484956978831393,-0.8861579246125431,0.2969342078719379},
{0.8440030556752018,-0.8595655537442017,0.4148115434734013},
{0.8921341807319203,-0.6625762782918025,0.398030773629838},
{0.7211508579092857,-0.8868000768159429,0.2535126028427957},
{0.7064673813941851,-0.8863178568594274,0.3915656337103252},
{0.7546033528826273,-0.8248990276240551,0.23215074341233624},
{0.7362075096671168,-0.8092765549624736,0.21114025028185032},
{0.7012392931721653,-0.8550486793776456,0.22792828977299923},
{0.6824811791853027,-0.873232491205241,0.26876795830130146},
{0.671363464810968,-0.7949735233376891,0.22358225212470598},
{0.664986772270414,-0.8433857414343864,0.22456486615670093},
{0.6545027288439625,-0.8887083593071784,0.24758662845255255},
{0.6115488044761643,-0.8729586678128478,0.22481809221426804},
{0.6298755860396111,-0.9092257280097704,0.28620541964343593},
{0.6964013427039091,-0.7709558193226023,0.20926225798888837},
{0.7824509495674257,-0.8310164360673873,0.2264525513131104},
{0.8223613148126945,-0.8009891567148221,0.21345563303788276},
{0.6759215338471762,-0.885795653841191,0.32088042701909925},
{0.6640077930622118,-0.8590494087656201,0.4430468546961015},
{0.615309635493812,-0.862613959298455,0.41153050919640716},
{0.570305670506858,-0.8686186882042094,0.45367629107426616},
{0.4951399376870041,-0.8973483354627343,0.38181461308209436},
{0.5681841450197765,-0.8914623441342124,0.3925906540199031},
{0.5896550491640208,-0.8790627485689396,0.3382379222377914},
{0.5790401520810274,-0.8636632117666516,0.2594967344137242},
{0.5482229043574873,-0.9033554875843507,0.2577701931121301},
{0.514507490463131,-0.9092257280097704,0.25396695581689943},
{0.46646238956950964,-0.8853824955367393,0.2661484619546023},
{0.4591261035476486,-0.840132574139804,0.2485328942466192},
{0.6969623171759357,-0.7327744185947894,0.2432720926104638},
{0.7014961540535252,-0.7398671714225308,0.29908723516522395},
{0.6693110009759502,-0.7544767398538439,0.2752270401811596},
{0.6152102836434747,-0.8057653151786002,0.20098212938882257},
{0.5775704716607934,-0.8198805475740885,0.2371728582860958},
{0.5624290073477963,-0.5678164220127353,0.25356712519968816},
{0.8073446461165846,-0.44947504057372073,0.488254369815454},
{0.4233873044086172,-0.8534614729881099,0.283728893032588},
{0.47120219979535943,-0.7619814393781059,0.3396591383407878},
{0.4534121605453205,-0.7014022544388772,0.2846872749059641},
{0.6967648250831919,-0.5256476195841884,0.23720436009230034},
{0.40862022694628153,-0.6932311705525963,0.27859046379745794},
{0.4380126237430325,-0.7205638338667438,0.28211624287650267},
{0.45138756369271443,-0.7510648519203078,0.22884547697672322},
{0.4061012940578506,-0.7496472706411043,0.2021440613945971},
{0.472703382021798,-0.7860136826883642,0.2981857988646022},
{0.37361929703719454,-0.6801361120349622,0.29589707148305056},
{0.39673919957545256,-0.7903148908432126,0.18357495824496173},
{0.5735442985062692,-0.7913059861307241,0.2614898294601257},
{0.5525871161247448,-0.7780049542648297,0.21581584528736011},
{0.5564703195434176,-0.854102413583579,0.2153954173353228},
{0.6928174064441791,-0.763365095635243,0.32453342493089293},
{0.5108702434544397,-0.7552691314406806,0.2570565560408046},
{0.518348287604221,-0.7666449183043064,0.21610784279871742},
{0.5088492814256264,-0.7679510316538631,0.33460794487668566},
{0.5367659397624885,-0.7649862270468452,0.3305236145414761},
{0.5105152423306732,-0.8063638494964861,0.19228278444465047},
{0.4891291507415949,-0.852757528780232,0.20596789602465385},
{0.8743223325391244,-0.5537605584058634,0.42758067945761163},
{0.8429647076783835,-0.5441646235927933,0.4803365119867402},
{0.5621103544619582,-0.5304419521669306,0.5317353436332124},
{0.8656169295552976,-0.3944971190992423,0.42352058128102094},
{0.8428592977883915,-0.24059625649497587,0.4157311538929872},
{0.8120941492058819,-0.10965657579001388,0.37778601671170825},
{0.2539197031075926,0.17064407260197043,-0.7561639038976822},
{0.555375025973845,-0.0998461863731668,-0.6060723366283011},
{0.544497209969837,-0.11140129121057207,-0.5277443071086855},
{0.5849733961188563,-0.22328722559352138,-0.49769764202922523},
{0.5639604797725085,-0.22286922085734592,-0.43016019274258965},
{0.49552765222490597,-0.17496345487578296,-0.3936677734705116},
{0.4564060437426811,-0.0838202482705812,-0.4613966568102361},
{0.43361691016957055,0.008201374084554378,-0.5334267483048091},
{0.5613749084478757,-0.4167107389051548,-0.3304291091228625},
{0.5789274725434498,-0.34739707239175655,-0.3620290555697919},
{0.5013433702934332,-0.33215262140462926,-0.31652954293908214},
{0.48949747955260164,-0.4500541891647115,-0.3049889773968482},
{0.4013396748892439,-0.3679822911384814,-0.3043977127265479},
{0.37509624710501427,-0.2778168521335508,-0.32485328942466196},
{0.4206151454626192,-0.20923257359458025,-0.35138750311231787},
{0.3442087261214794,-0.14805848916125847,-0.3906557161541868},
{0.3833921266081824,-0.0821966936431173,-0.42405247716270505},
{0.3174358256714277,-0.1679615726428623,-0.3737428810461507},
{0.44774062382057545,-0.5793012535901458,-0.3925906540199031},
{0.4795695641664531,-0.5061213461691079,-0.32761333229135053},
{0.3868270350924063,-0.5008702373964,-0.34151895651478553},
{0.3585493175921231,-0.568847500361968,-0.4234406151575787},
{0.2687921904599203,-0.5490134785324279,-0.6444803080392003},
{0.2875406115833353,-0.6217293401159146,-0.7248208183321126},
{0.3087643477096672,-0.6279509468413079,-0.6410138977487718},
{0.23844141178979328,-0.4876576529094645,-0.5684567568042387},
{0.25130505319261714,-0.49858999127036496,-0.48666716342591837},
{0.30923323997894225,-0.607045863600814,-0.5873675333904},
{0.3338797685101887,-0.6461783765544175,-0.594428784411937},
{0.3573122658946301,-0.6477752758074005,-0.6022690993330704},
{0.30957975984719205,-0.6229651802054768,-0.7148832100825165},
{0.2907707583272299,-0.5978170459908198,-0.8015943548763282},
{0.24621024184300105,-0.4697367600028837,-0.6401984856112471},
{0.1571691749979857,-0.43495391952136647,-0.655194556972531},
{0.1100061246780909,-0.40973793526257674,-0.5940737832881706},
{0.1368977627053751,-0.40969552898499373,-0.5031959188198454},
{0.2956026507558313,-0.5073365889238438,-0.4046243439900309},
{0.35055755167962177,-0.6254259559132224,-0.5470646071755056},
{0.3894307805360032,-0.6520449821560442,-0.5524562624682029},
{0.4088916271228128,-0.6430960459780979,-0.5604625676758755},
{0.3237761699740534,-0.5832947133305346,-0.8727617815240695},
{0.2802334041518169,-0.4847825072893363,-0.7637764365277983},
{0.3170723432921447,-0.4572184268603786,-0.8133966277316459},
{0.2949035529796771,-0.4164756869665518,-0.7389845150448386},
{0.2587673464392963,-0.4487601918944642,-0.6847941387254732},
{0.3871202442116946,-0.5681132659558165,-0.9187192819526758},
{0.35540882983511835,-0.5393000177500562,-0.8784527039757097},
{0.382739069933404,-0.4185778267267383,-0.8388924934224835},
{0.3345752314625501,-0.3908598720905508,-0.7662880997686434},
{0.4284736345027167,-0.5314681840844395,-0.9001962199044163},
{0.47298810988556966,-0.43495513112929746,-0.8627963062920618},
{0.44952895712664753,-0.3840712328534761,-0.8251455898380019},
{0.3242838336971186,-0.6936831003108382,-0.9557302694191976},
{0.27618299883867375,-0.7228513496403646,-0.8912278979995748},
{0.3002334162678962,-0.7505850551796543,-0.9553752682954313},
{0.37986634752913767,-0.7781249034499931,-1.0},
{0.5561044139482728,-0.7316985107521118,-0.9132294864175722},
{0.5896659536353993,-0.7600428666885969,-0.7607704372511283},
{0.5584803771008524,-0.700918822874431,-0.6774081767784436},
{0.5328500229296801,-0.6926435407060889,-0.6304268676481903},
{0.5845638726381975,-0.7419232700813414,-0.586112307573943},
{0.5179920748725237,-0.7253557432336242,-0.54353761648853},
{0.4916359675507164,-0.7002572849441359,-0.5874680968486684},
{0.4902862363156457,-0.6724714802638156,-0.5983386432050908},
{0.46970465239271364,-0.7281388066510007,-0.5110822748423547},
{0.4017746421364525,-0.7000937178734585,-0.5713331140322979},
{0.42066239817192597,-0.7237152260951271,-0.515021212225851},
{0.44947564637768606,-0.7622552627704992,-0.4330183758516846},
{0.434503807175021,-0.7469744635454435,-0.3861315721400449},
{0.38788355720818873,-0.7180521706258985,-0.3894634939501387},
{0.3915450363754991,-0.7470495832371621,-0.34957493764762687},
{0.43732079561446396,-0.8047390832610913,-0.3614583882343177},
{0.4836866079157981,-0.8093589443017777,-0.3657632312129589},
{0.48691069662003794,-0.868711982014892,-0.4033897155083998},
{0.5406564128287471,-0.8415780224014192,-0.36824581586346145},
{0.5284979272417322,-0.7662729546695068,-0.36340907700313624},
{0.5720927922049992,-0.7968115325689299,-0.3847067212132557},
{0.5631499140667074,-0.7475693630395367,-0.41483092920029635},
{0.5647771035179642,-0.8629047452018813,-0.41705786457736993},
{0.45187705329681543,-0.8070169061712645,-0.4011179506378813},
{0.43046309472532546,-0.8509364820600244,-0.4617686204450357},
{0.4211615806394745,-0.8655823987292657,-0.4048509146731173},
{0.39181037851237566,-0.8576063837198666,-0.3687183429565293},
{0.3895361904259953,-0.8051377022703715,-0.3356135794593684},
{0.22289527042786114,-0.8483993750526293,-0.5521824390758097},
{0.23475691207179503,-0.8805009271829692,-0.46799143877835997},
{0.1908773192447563,-0.8499066153187227,-0.4868840412455572},
{0.23861346011598722,-0.7856320261901171,-0.6688384738828823},
{0.18217918590851512,-0.7906941241255978,-0.48860452450749653},
{0.19853346976038636,-0.7463286765182509,-0.468907414374153},
{0.30210898534499625,-0.8576136533674523,-0.7056350067456272},
{0.260565372608816,-0.8330143775455127,-0.6956259136281054},
{0.2690381468699018,-0.7701973527578319,-0.8971562956056798},
{0.29167098301992067,-0.8245064666544295,-0.898493910761441},
{0.3150840946774669,-0.8010364094241289,-0.9611328291832733},
{0.369152098595807,-0.8596552127310916,-0.4746734565175117},
{0.33272874097579264,-0.8298557156695439,-0.474795828918537},
{0.3609483012953906,-0.8704700251226906,-0.4132873406962747},
{0.3291411698922699,-0.8296412610657667,-0.3863472383517528},
{0.3530013648763342,-0.7924897270792556,-0.3501286424720679},
{0.33755821018853227,-0.7543943505145397,-0.3870705682865259},
{0.33191575205412976,-0.6868472083644567,-0.613859340800473},
{0.3549423607817052,-0.7228925443100166,-0.5136060541625093},
{0.3936568689991331,-0.8360773223949369,-0.9671702715031631},
{0.3413493314044535,-0.8437649747167716,-0.9262700225783139},
{0.5768095818801611,-0.6195702547829739,-0.8230640474126415},
{0.4880544545068483,-0.5372075708533174,-0.8939661319235064},
{0.5437193576781715,-0.43850514236696103,-0.841908185562601},
{0.536712629013527,-0.3572547145179104,-0.7794485851145485},
{0.22164125621933495,-0.40382771177543586,-0.39422753633460733},
{0.3552622252754742,-0.42668348378474824,-0.31885704177442403},
{0.28026127113422855,-0.3501171321967241,-0.3431158557677687},
{0.3968700532319944,-0.0039740740134937514,-0.41546217693231774},
{0.40603344401371777,0.015892661230181803,-0.48127187330942833},
{0.4291012474109453,-0.0421530515254447,-0.47906674687511175},
{0.36300924638592497,-0.09538989240315779,-0.39365929221499496},
{0.43182857686349846,0.034402395591200965,-0.13155336012198468},
{0.5720358466322449,-0.49370721130866385,-0.34919449275731074},
{0.16113961418768655,-0.398961894324768,-0.7504111894415638},
{0.06646335885585437,-0.3637743767943157,-0.6949898194643602},
{0.6031244945323163,-0.47169108359549505,-0.8047130336905759},
{0.5981350930726922,-0.40092954560461974,-0.7726902360757474},
{0.6391225777685696,-0.39580323244879906,-0.6755350309172055},
{0.6638066661456753,-0.4596028712684749,-0.5836551666899901},
{0.5249745713785493,-0.5829796952684894,-0.3979120360526056},
{0.6098198399587085,-0.5467356556222547,-0.4235532946951564},
{0.6267811393839822,-0.465528845658718,-0.40414575885730836},
{0.6463134708387175,-0.5102614104691408,-0.4684421569286708},
{0.6081817460360732,-0.35951678652498137,-0.6922746060911166},
{0.2450361937579171,-0.3409864548291361,-0.8424134260698044},
{0.21623021519974264,-0.3929717047141848,-0.7777426411477805},
{0.26862498856545014,0.49046131366166684,0.24779623662460573},
{0.2353396954865787,0.5283967579794983,0.2015188717022304},
{0.2571510614594181,0.4863563859916314,0.20554867968054746},
{0.2967888149202247,0.404908466049837,0.25261843618975965},
{0.3830989174888941,0.2703727330058356,0.28409601023566383},
{0.47729295286421086,0.14216401657721967,0.3449950596686616},
{0.7372725130384159,0.009205797059306384,0.31481754093265946},
{0.7849638244162019,-0.022209984982119815,0.2489545338065874},
{0.7966946124035938,-0.281589799230508,0.09597207001397592},
{0.7339963251931454,-0.13550259617289412,0.05289577324515253},
{0.688233893641421,-0.11914831232102288,0.01834313827051451},
{0.6197356392655475,-0.1232132569293373,-0.0029302737809861006},
{0.6206067853678957,0.061231030006076145,-0.10872908991887678},
{0.5344384409271467,0.16729518828084333,-0.15482229043574874},
{0.4952986583259577,0.25224828996685644,-0.19649312200467803},
{0.4836175462637344,0.332560933277357,-0.21483807768708893},
{0.5879684909241479,0.38240163712463626,-0.16667666243209694},
{0.5874911173993562,0.2884341724324058,-0.1742601164718704},
{0.6408164056560282,0.31305525719710237,-0.1437748493214087},
{0.6852327407964748,0.0696020292009626,-0.07819657005910828},
{0.7392171437675796,0.09827594249466434,-0.03307629071078372},
{0.6733565598573694,0.34564508732361254,-0.10465929887883858},
{0.45562940305894656,-0.48204063854161183,0.33843541433053514},
{0.48891954256954173,-0.4412845709605447,0.23056838345452443},
{0.48183405938938595,-0.49241806047014036,0.2769729672096488},
{0.44393132848569,-0.3271644315529362,0.1430503077787047},
{0.38565783343904614,-0.20449397497666144,0.21207803482040036},
{0.4009337862323779,-0.08553588510079672,0.18769200199430666},
{0.3726257785338212,-0.01923912233544709,0.1956983072019793},
{0.39297958016573586,-0.047204244989546985,0.11155698282969823},
{0.5715366641646963,-0.16931372709379489,-0.6649685981514498},
{0.5372263507762469,-0.07718669484866719,-0.7108134190424783},
{0.6064491466948244,-0.32847417972628573,-0.4941137057694952},
{0.635485330759878,-0.41843001055916323,-0.44228717652340005},
{0.4597319075131202,-0.6560820597819471,-0.5414730365742028},
{0.3871638620972085,-0.6736806649788969,-0.5914155154876812},
{0.4386935474002226,-0.6715894296900891,-0.5858045591594834},
{0.5786984786445015,-0.31682699268612885,-0.604132552330861},
{0.3555384718837292,-0.13113959601356773,-0.2738130937257489},
{0.5443833188243283,0.46907764528845036,-0.1311559527206353},
{0.6176213834260517,0.4417922346836098,-0.09284369833628056},
{0.5206261105143942,0.5166138708510757,-0.05743203333860381},
{0.3642160078851444,0.5451872206865092,-0.0745593230504168},
{0.4746383198875143,0.5399458047772489,0.0005979285139204818},
{0.32973485777843203,0.5507194224991956,0.020362888691396814},
{0.6892019683782447,0.37397490396492633,-0.05148182678974179},
{0.7744095077297557,0.13151761768802184,0.021437584926143425},
{0.1246653690345726,-0.3006181017859708,-0.8574191902945358},
{0.0709269224734491,-0.33668403506635686,-0.7719075373523581},
{0.7741417423770172,-0.06101536379436838,0.08137098283817948},
{0.6033643929026431,0.48725903390018405,0.0017913623258995282},
{0.4836175462637344,0.5383161921101304,0.07727938285538431},
{0.30524462667027724,0.5309362882027553,0.102838252158631},
{0.43049459653152994,-0.23174909538322863,0.10724244698760951},
{0.7529846446868872,0.27638473155917576,0.055557675869434726},
{0.7155265738938474,0.36048728447766676,0.09568976536606615},
{0.670615902717576,0.42825372766325054,0.03373419381728591},
{0.6038054181895064,0.47582751307173493,0.1264343166137497},
{0.5218546809563707,0.4958287367957454,0.17508522147284275},
{0.43335156803269403,0.5174062624379127,0.15712313389660987},
{0.6347317106268314,0.43181585498022346,0.1677186452527081},
{0.7474948491517837,0.2661042382651228,0.17653551616618174},
{0.7947548281061538,0.11980742703545583,0.10963294943536044},
{0.7770241576447311,0.15331202114982803,0.19690870352499157},
{0.5579884642808896,0.4364235999416004,0.22774049054370302},
{0.4831789441927329,0.4535096949837614,0.23765507824261117},
{0.45000269582764635,0.4061758079456037,0.2580730950948659},
{0.3601098686071779,0.4086608158119682,0.24041875593309261},
{0.33277599368509947,0.46048371023427026,0.2075042148810898},
{0.49165898810140435,0.23512221186297436,0.32832333453888324},
{0.8150528957732452,-0.08848130398091972,0.2056892262005369},
{0.8008055981132841,-0.03764950484612888,0.16264321962998707},
{0.8035486784689395,-0.14050290210389668,0.1277695085536491},
{0.8497218451092539,-0.2476708352037531,0.15067859131192304},
{0.8591142297899255,-0.3236035158438941,0.17133166010278073},
{0.6330306130917872,-0.7780679578772387,-0.6377583072383275},
{0.6279879008832016,-0.762684171978053,-0.574484506260681},
{0.6725290316405352,-0.8183478635414453,-0.493839882377102},
{0.6592849453473953,-0.7700459017664638,-0.509090391403884},
{0.6256809993826857,-0.7468145312985591,-0.48192977641593043},
{0.5754707551164688,-0.7661154456384841,-0.4813191260187351},
{0.5044475098125097,-0.7318329992324465,-0.4100729448554824},
{0.4788147324254755,-0.7610400200157631,-0.38145961195832795},
{0.5894333249126582,-0.7886937594316106,-0.447002754590631},
{0.6477734583955039,-0.771599183133933,-0.4637532342359207},
{0.6319365311301455,-0.8070253874267811,-0.44188734590618883},
{0.6408975833874013,-0.856832166251994,-0.5695920334355324},
{0.6365224671487655,-0.8332348901889443,-0.64798670139135},
{0.660528055084543,-0.5176122357861731,0.543624852259558},
{0.7584962491647478,-0.5200100078815098,0.5276376856107625},
{0.3709913194349787,0.4573723010676083,0.38077626508527607},
{0.3458334923568743,0.47486307315870413,0.4475225343930057},
{0.3585541640238469,0.47934723411112506,0.4068997436843423},
{0.36346844579175247,0.4176812368578402,0.36559966414228157},
{0.3452361696469193,0.3374170578645773,0.37671010886903067},
{0.30559841618611266,0.3773661945636363,0.41659139552395685},
{0.3349799085114851,0.4112282130176368,0.39973065955695136},
{6.058039654508402e-07,-0.8451025898725328,0.40184733861230915},
{-0.09659604809841167,0.46463225578981987,0.7755702281275992},
{-0.8429683425021764,-0.5441731048483098,0.48033287716294737},
{-0.6206067853678957,0.061234664829868946,-0.10873030152680772},
{-0.7770205228209383,0.1533241372291374,0.19691112674085345},
{0.37533493386741007,-0.8589112854614924,0.2744031467881183},
{0.2883027129718986,-0.7859785460583669,-0.4295410610898777},
{0.34190424783682544,-0.7284647291844244,0.4136750552341766}
};


// texture array: 23kb.
const tgx::fVec2 donkeykong_small_tex_array[2995] PROGMEM = {
{0.960754,0.458065},
{0.946932,0.462879},
{0.942123,0.458424},
{0.95268,0.413386},
{0.939676,0.415863},
{0.932342,0.458291},
{0.93329,0.463787},
{0.771207,0.911747},
{0.755895,0.924819},
{0.757476,0.909973},
{0.748017,0.899207},
{0.73939,0.907291},
{0.739577,0.916056},
{0.751651,0.91863},
{0.920627,0.462623},
{0.919832,0.460739},
{0.01156,0.873942},
{0.026513,0.874895},
{0.016599,0.882872},
{0.032289,0.893326},
{0.053114,0.879363},
{0.046794,0.869956},
{0.532376,0.630583},
{0.516854,0.6181},
{0.53161,0.626818},
{0.533016,0.617016},
{0.547,0.586598},
{0.542199,0.568168},
{0.503147,0.605607},
{0.52464,0.556924},
{0.501801,0.584666},
{0.492244,0.596352},
{0.492526,0.573027},
{0.484162,0.586546},
{0.478233,0.574409},
{0.488163,0.561235},
{0.509286,0.540925},
{0.525193,0.527949},
{0.540048,0.542688},
{0.542351,0.513311},
{0.563911,0.521407},
{0.550944,0.507382},
{0.533057,0.49907},
{0.54497,0.463382},
{0.532461,0.471963},
{0.527769,0.490757},
{0.523004,0.478244},
{0.493287,0.458787},
{0.501889,0.477491},
{0.515416,0.483175},
{0.834043,0.386823},
{0.835584,0.383555},
{0.83434,0.394533},
{0.842579,0.390237},
{0.846112,0.381359},
{0.845494,0.375492},
{0.89181,0.447964},
{0.890234,0.422292},
{0.893718,0.432069},
{0.897429,0.447453},
{0.906331,0.463768},
{0.900013,0.449619},
{0.970584,0.678363},
{0.975942,0.672027},
{0.971881,0.682818},
{0.976701,0.687819},
{0.978146,0.668402},
{0.171532,0.523281},
{0.159302,0.511472},
{0.171988,0.509873},
{0.177649,0.505814},
{0.188979,0.513294},
{0.18638,0.503642},
{0.20086,0.49987},
{0.194252,0.502099},
{0.893994,0.401844},
{0.891867,0.415312},
{0.889713,0.398503},
{0.888516,0.408245},
{0.863774,0.427588},
{0.860967,0.443033},
{0.873423,0.456717},
{0.884322,0.473247},
{0.895759,0.490669},
{0.912579,0.470332},
{0.912502,0.463422},
{0.907621,0.45192},
{0.898301,0.43386},
{0.904989,0.434012},
{0.897632,0.417239},
{0.798006,0.624135},
{0.800194,0.624439},
{0.800194,0.631072},
{0.133758,0.746234},
{0.133258,0.738193},
{0.136391,0.740034},
{0.136656,0.74643},
{0.133667,0.759048},
{0.13621,0.763159},
{0.932555,0.944516},
{0.940113,0.946059},
{0.946639,0.947259},
{0.347905,0.975875},
{0.346827,0.981793},
{0.342867,0.981395},
{0.339395,0.973144},
{0.330213,0.985847},
{0.325993,0.981331},
{0.323583,0.988584},
{0.783998,0.626234},
{0.786055,0.625083},
{0.785483,0.628675},
{0.11405,0.171558},
{0.131921,0.24407},
{0.104387,0.217791},
{0.096407,0.169899},
{0.091351,0.230631},
{0.119437,0.260225},
{0.15039,0.267483},
{0.162068,0.256018},
{0.151435,0.231975},
{0.143362,0.224234},
{0.130243,0.170938},
{0.128764,0.136766},
{0.108908,0.140694},
{0.085273,0.150178},
{0.073585,0.169328},
{0.068712,0.21462},
{0.068713,0.238795},
{0.08841,0.260964},
{0.112383,0.280401},
{0.143721,0.281628},
{0.165172,0.273753},
{0.18399,0.266759},
{0.183915,0.256624},
{0.144737,0.096015},
{0.16206,0.108478},
{0.171599,0.094393},
{0.162438,0.079042},
{0.13767,0.082433},
{0.109589,0.093077},
{0.099029,0.113475},
{0.078234,0.108069},
{0.021725,0.159697},
{0.017151,0.206029},
{0.009054,0.239102},
{0.030131,0.263389},
{0.063908,0.264138},
{0.086876,0.279697},
{0.106896,0.29925},
{0.134185,0.2937},
{0.1379,0.309457},
{0.160016,0.291921},
{0.183345,0.278857},
{0.22128,0.281905},
{0.223111,0.266472},
{0.827118,0.733768},
{0.827497,0.722164},
{0.832842,0.739424},
{0.842871,0.735487},
{0.84714,0.723107},
{0.841095,0.712284},
{0.821695,0.705048},
{0.808392,0.738893},
{0.811891,0.747152},
{0.803544,0.746373},
{0.80462,0.752201},
{0.843445,0.699938},
{0.835127,0.688584},
{0.846094,0.675406},
{0.847524,0.65705},
{0.809983,0.695455},
{0.799507,0.734305},
{0.793358,0.741366},
{0.758674,0.669345},
{0.761777,0.67282},
{0.746241,0.671071},
{0.755935,0.662311},
{0.746597,0.664596},
{0.739955,0.66918},
{0.739027,0.659957},
{0.536174,0.949476},
{0.553564,0.95061},
{0.551374,0.974032},
{0.542061,0.964681},
{0.544579,0.976073},
{0.082555,0.403959},
{0.083686,0.438948},
{0.057875,0.443956},
{0.050123,0.42716},
{0.030101,0.457318},
{0.030141,0.472727},
{0.057925,0.454564},
{0.08274,0.451043},
{0.088388,0.452498},
{0.09352,0.441881},
{0.091019,0.433396},
{0.103292,0.417441},
{0.097781,0.390574},
{0.080204,0.366106},
{0.0683,0.390613},
{0.033741,0.409651},
{0.021418,0.429171},
{0.020376,0.471148},
{0.025445,0.488187},
{0.031265,0.491326},
{0.030528,0.495531},
{0.837707,0.558151},
{0.84417,0.551599},
{0.845618,0.557812},
{0.837001,0.576254},
{0.840743,0.587187},
{0.846576,0.559138},
{0.802374,0.615117},
{0.796004,0.606053},
{0.809572,0.604194},
{0.824684,0.618927},
{0.816181,0.600951},
{0.809261,0.594283},
{0.802281,0.589131},
{0.797211,0.599413},
{0.973687,0.506759},
{0.969697,0.504815},
{0.969378,0.501635},
{0.972604,0.491571},
{0.980216,0.488645},
{0.972221,0.482263},
{0.976719,0.478384},
{0.96989,0.475762},
{0.970497,0.472163},
{0.628858,0.801124},
{0.625589,0.795569},
{0.627116,0.780867},
{0.632179,0.795364},
{0.636223,0.784393},
{0.634667,0.775397},
{0.628275,0.772599},
{0.015029,0.417962},
{0.003428,0.422523},
{0.01451,0.434834},
{0.009526,0.41523},
{0.015607,0.405292},
{0.025135,0.405773},
{0.038513,0.369057},
{0.019126,0.364488},
{0.010038,0.396607},
{0.008,0.403904},
{0.970509,0.463398},
{0.957342,0.464961},
{0.973124,0.459577},
{0.964097,0.446516},
{0.964909,0.413913},
{0.467662,0.70925},
{0.465101,0.69455},
{0.473109,0.701102},
{0.469333,0.719798},
{0.4656,0.727756},
{0.953668,0.888655},
{0.960246,0.89614},
{0.947235,0.886695},
{0.959514,0.901692},
{0.96425,0.901779},
{0.966432,0.913957},
{0.939071,0.858298},
{0.943715,0.87533},
{0.932896,0.864837},
{0.931551,0.87153},
{0.160578,0.631775},
{0.16484,0.603679},
{0.177468,0.598132},
{0.171848,0.569887},
{0.151417,0.599886},
{0.153591,0.613466},
{0.671194,0.896926},
{0.660876,0.900423},
{0.653363,0.889705},
{0.667581,0.877262},
{0.649397,0.881405},
{0.88412,0.956607},
{0.874557,0.935372},
{0.894023,0.943704},
{0.878592,0.921525},
{0.870103,0.924962},
{0.254886,0.936695},
{0.243938,0.943421},
{0.245438,0.935113},
{0.250622,0.924701},
{0.241289,0.927211},
{0.964052,0.803929},
{0.970554,0.796248},
{0.973485,0.808777},
{0.975602,0.789997},
{0.939839,0.785877},
{0.938618,0.792134},
{0.930482,0.783536},
{0.940894,0.778797},
{0.940624,0.774534},
{0.977278,0.781201},
{0.962836,0.773519},
{0.743361,0.987072},
{0.732765,0.99425},
{0.73237,0.987693},
{0.737663,0.976877},
{0.732381,0.975785},
{0.739074,0.968401},
{0.57084,0.747055},
{0.595379,0.735213},
{0.601202,0.768773},
{0.588468,0.773997},
{0.594492,0.793698},
{0.609385,0.787408},
{0.619961,0.776777},
{0.611914,0.754023},
{0.99094,0.751193},
{0.982668,0.749847},
{0.986579,0.743361},
{0.992555,0.742853},
{0.986835,0.730964},
{0.978982,0.736582},
{0.978573,0.744072},
{0.886245,0.36668},
{0.893601,0.388888},
{0.874179,0.380773},
{0.880342,0.387785},
{0.591091,0.857003},
{0.596677,0.845393},
{0.595176,0.853762},
{0.597078,0.867368},
{0.60081,0.855033},
{0.621344,0.848648},
{0.619638,0.82428},
{0.596542,0.821135},
{0.584769,0.845792},
{0.582939,0.864797},
{0.590477,0.877186},
{0.594411,0.880724},
{0.599952,0.880486},
{0.621064,0.869696},
{0.62635,0.853161},
{0.623581,0.827099},
{0.618833,0.807298},
{0.007883,0.890809},
{0.014495,0.886651},
{0.021424,0.907558},
{0.008731,0.91415},
{0.012862,0.948803},
{0.023523,0.952687},
{0.564627,0.831606},
{0.538923,0.844036},
{0.543693,0.826686},
{0.571296,0.811766},
{0.549514,0.812737},
{0.520295,0.812941},
{0.514731,0.825733},
{0.513823,0.843977},
{0.531653,0.862749},
{0.547835,0.870433},
{0.565123,0.850743},
{0.515623,0.866213},
{0.52812,0.885638},
{0.54576,0.888011},
{0.55713,0.883623},
{0.503286,0.897346},
{0.520729,0.911523},
{0.521955,0.905219},
{0.625003,0.806363},
{0.73471,0.29537},
{0.734165,0.308027},
{0.723578,0.304458},
{0.727054,0.327857},
{0.737869,0.320455},
{0.746457,0.332227},
{0.738831,0.346421},
{0.757741,0.341736},
{0.756548,0.361611},
{0.763531,0.349822},
{0.777027,0.364045},
{0.772766,0.372441},
{0.780493,0.377253},
{0.785445,0.371493},
{0.677614,0.387859},
{0.660539,0.371708},
{0.656437,0.352701},
{0.649898,0.340327},
{0.66679,0.301407},
{0.705363,0.316782},
{0.68123,0.245009},
{0.704255,0.248747},
{0.694777,0.231489},
{0.681637,0.233528},
{0.677839,0.237374},
{0.685258,0.697215},
{0.685159,0.707822},
{0.682385,0.677794},
{0.676882,0.706759},
{0.685205,0.71884},
{0.689837,0.716735},
{0.694702,0.682314},
{0.698016,0.664966},
{0.704367,0.655692},
{0.695853,0.656637},
{0.713017,0.649659},
{0.712945,0.65368},
{0.722288,0.648706},
{0.719035,0.644004},
{0.727927,0.640618},
{0.722476,0.634683},
{0.583842,0.823133},
{0.672172,0.74549},
{0.647576,0.748753},
{0.662995,0.72539},
{0.675368,0.726155},
{0.701632,0.766421},
{0.684354,0.728867},
{0.668466,0.696212},
{0.674618,0.67805},
{0.711507,0.357036},
{0.714735,0.343729},
{0.713,0.325652},
{0.785736,0.489641},
{0.782829,0.492315},
{0.775866,0.437458},
{0.780715,0.424786},
{0.775055,0.423058},
{0.761374,0.421771},
{0.7567,0.434173},
{0.739999,0.488606},
{0.788147,0.526568},
{0.792323,0.524286},
{0.630735,0.817451},
{0.634385,0.838585},
{0.635211,0.860724},
{0.628668,0.866613},
{0.626397,0.884872},
{0.632827,0.891708},
{0.63651,0.878624},
{0.805136,0.577512},
{0.807385,0.561185},
{0.80944,0.567253},
{0.823072,0.564309},
{0.811436,0.556198},
{0.811015,0.545088},
{0.816563,0.546647},
{0.812309,0.535855},
{0.820498,0.538368},
{0.820453,0.533422},
{0.832839,0.538564},
{0.828321,0.543956},
{0.823924,0.556413},
{0.287698,0.827684},
{0.270464,0.823866},
{0.279574,0.819509},
{0.287377,0.82182},
{0.295193,0.826081},
{0.832343,0.606697},
{0.827292,0.596355},
{0.822783,0.591156},
{0.811471,0.587127},
{0.810886,0.57801},
{0.821331,0.57186},
{0.831811,0.616033},
{0.82427,0.620003},
{0.698481,0.777553},
{0.665082,0.769798},
{0.710896,0.781504},
{0.713883,0.774081},
{0.710588,0.763947},
{0.697333,0.747147},
{0.688714,0.732148},
{0.686615,0.726411},
{0.692022,0.791829},
{0.706696,0.794193},
{0.719102,0.790065},
{0.726753,0.790213},
{0.494423,0.863091},
{0.48155,0.835499},
{0.489855,0.818044},
{0.476896,0.821884},
{0.47651,0.81211},
{0.763664,0.411637},
{0.775116,0.411949},
{0.626647,0.660393},
{0.628193,0.724393},
{0.624753,0.666114},
{0.627976,0.638127},
{0.627272,0.724176},
{0.739403,0.772667},
{0.743086,0.765395},
{0.743578,0.771132},
{0.751132,0.761094},
{0.747862,0.769387},
{0.746122,0.755951},
{0.763503,0.741959},
{0.745345,0.738663},
{0.739677,0.746042},
{0.752524,0.766364},
{0.763869,0.750865},
{0.765737,0.727415},
{0.753123,0.726607},
{0.763225,0.698978},
{0.758884,0.712413},
{0.76081,0.697589},
{0.758006,0.683842},
{0.768705,0.678183},
{0.744365,0.672454},
{0.376426,0.984402},
{0.376733,0.958583},
{0.392771,0.966007},
{0.388948,0.987388},
{0.407008,0.989385},
{0.411669,0.972111},
{0.378627,0.946078},
{0.5319,0.95725},
{0.935541,0.590283},
{0.934062,0.603591},
{0.926786,0.59102},
{0.930921,0.602758},
{0.931799,0.620937},
{0.936646,0.618794},
{0.929874,0.627208},
{0.141679,0.73884},
{0.149724,0.729064},
{0.155174,0.748036},
{0.14359,0.764397},
{0.1559,0.779875},
{0.178385,0.784192},
{0.185786,0.768985},
{0.184722,0.726359},
{0.158822,0.729171},
{0.271351,0.828183},
{0.285481,0.833125},
{0.297553,0.833551},
{0.842553,0.925605},
{0.853532,0.934455},
{0.851968,0.939962},
{0.837856,0.932917},
{0.860826,0.961251},
{0.857666,0.971735},
{0.864568,0.977545},
{0.865269,0.987539},
{0.85768,0.987348},
{0.846187,0.959652},
{0.847525,0.978967},
{0.837825,0.963965},
{0.816898,0.987902},
{0.818489,0.976489},
{0.801052,0.983763},
{0.804471,0.98889},
{0.105544,0.4365},
{0.549596,0.933361},
{0.772546,0.700326},
{0.770999,0.72749},
{0.778438,0.678922},
{0.776258,0.665912},
{0.768744,0.658631},
{0.939691,0.232176},
{0.924257,0.257019},
{0.920323,0.250877},
{0.921805,0.272227},
{0.914385,0.270665},
{0.914779,0.288867},
{0.92453,0.289514},
{0.923246,0.30183},
{0.931746,0.305158},
{0.93887,0.315501},
{0.831397,0.915687},
{0.818354,0.917408},
{0.80949,0.924515},
{0.828747,0.938174},
{0.839469,0.947039},
{0.818685,0.91008},
{0.809236,0.909831},
{0.120519,0.376571},
{0.11485,0.389536},
{0.101496,0.371801},
{0.11644,0.361649},
{0.557174,0.550391},
{0.562926,0.565697},
{0.926354,0.41849},
{0.92534,0.445498},
{0.915784,0.937163},
{0.927338,0.93638},
{0.925161,0.944572},
{0.920893,0.953052},
{0.9245,0.964464},
{0.923811,0.97194},
{0.869028,0.031391},
{0.889001,0.026965},
{0.893422,0.044231},
{0.867857,0.044405},
{0.869639,0.056078},
{0.904238,0.071239},
{0.929381,0.060344},
{0.925977,0.042345},
{0.899035,0.018426},
{0.886009,0.002333},
{0.246609,0.8988},
{0.248358,0.870141},
{0.255326,0.875523},
{0.255588,0.865785},
{0.243295,0.858547},
{0.27057,0.977705},
{0.26911,0.972581},
{0.270399,0.962128},
{0.276118,0.9712},
{0.277533,0.959649},
{0.283876,0.961604},
{0.283697,0.97726},
{0.279055,0.987377},
{0.284461,0.98913},
{0.7335,0.915776},
{0.988302,0.870765},
{0.980196,0.872388},
{0.983821,0.859029},
{0.976587,0.855701},
{0.969889,0.860443},
{0.969983,0.869599},
{0.845157,0.389597},
{0.954702,0.857648},
{0.958027,0.84984},
{0.96151,0.866571},
{0.955464,0.874082},
{0.96199,0.877781},
{0.964041,0.861801},
{0.954727,0.003081},
{0.956722,0.008341},
{0.951443,0.010437},
{0.958995,0.018966},
{0.968951,0.013542},
{0.965511,0.007575},
{0.953678,0.035337},
{0.962116,0.044151},
{0.972801,0.038191},
{0.976719,0.021419},
{0.980568,0.010807},
{0.973997,0.002135},
{0.973617,0.052441},
{0.962425,0.056023},
{0.952239,0.056104},
{0.996154,0.805501},
{0.983705,0.820758},
{0.985521,0.807563},
{0.985134,0.790896},
{0.96441,0.820515},
{0.976498,0.829464},
{0.987324,0.835281},
{0.976373,0.841327},
{0.958061,0.830984},
{0.960324,0.841621},
{0.956274,0.652419},
{0.949317,0.650372},
{0.954452,0.646004},
{0.965276,0.648659},
{0.96239,0.640921},
{0.957124,0.637841},
{0.948754,0.640814},
{0.950218,0.633438},
{0.954124,0.969072},
{0.954996,0.958921},
{0.960665,0.955641},
{0.964078,0.962547},
{0.97039,0.956868},
{0.971828,0.970991},
{0.961611,0.975879},
{0.971503,0.97883},
{0.953319,0.979649},
{0.958005,0.985998},
{0.980439,0.017503},
{0.950916,0.743442},
{0.955925,0.725449},
{0.96126,0.737339},
{0.957487,0.753193},
{0.947785,0.75792},
{0.952293,0.762556},
{0.957788,0.806238},
{0.957256,0.803368},
{0.92851,0.92565},
{0.918518,0.928741},
{0.886205,0.915417},
{0.059615,0.935221},
{0.05114,0.931062},
{0.059847,0.916042},
{0.061397,0.930823},
{0.850507,0.36904},
{0.863822,0.355835},
{0.865256,0.36641},
{0.850349,0.378081},
{0.862843,0.378193},
{0.850229,0.391707},
{0.861483,0.38891},
{0.064408,0.946513},
{0.04068,0.955185},
{0.028187,0.962364},
{0.031868,0.967161},
{0.910561,0.916425},
{0.892238,0.906645},
{0.880026,0.886179},
{0.870104,0.886788},
{0.703322,0.945377},
{0.711358,0.936553},
{0.712987,0.948524},
{0.707351,0.953752},
{0.706899,0.969853},
{0.715156,0.974934},
{0.719228,0.962391},
{0.70401,0.938216},
{0.696441,0.941952},
{0.694169,0.938181},
{0.699701,0.969311},
{0.692981,0.965482},
{0.700053,0.966113},
{0.693536,0.962762},
{0.327048,0.97007},
{0.326619,0.962757},
{0.344566,0.964568},
{0.325768,0.957387},
{0.003501,0.987006},
{0.005556,0.975404},
{0.012084,0.984978},
{0.011732,0.992409},
{0.021429,0.991992},
{0.021397,0.982546},
{0.015011,0.978411},
{0.017918,0.971109},
{0.0239,0.973655},
{0.058186,0.901886},
{0.054781,0.89183},
{0.10375,0.990037},
{0.098412,0.985074},
{0.107757,0.983591},
{0.103305,0.979993},
{0.10151,0.971596},
{0.093171,0.975169},
{0.948345,0.704752},
{0.947484,0.701405},
{0.957439,0.702655},
{0.956165,0.712081},
{0.965481,0.712425},
{0.970919,0.722842},
{0.973334,0.730311},
{0.967624,0.670284},
{0.958327,0.667801},
{0.964331,0.660698},
{0.975321,0.665039},
{0.974467,0.656367},
{0.976634,0.642034},
{0.973766,0.643056},
{0.967937,0.654982},
{0.950136,0.66407},
{0.953931,0.658386},
{0.7065,0.96473},
{0.453548,0.945354},
{0.460523,0.942888},
{0.461386,0.951213},
{0.458728,0.964291},
{0.462692,0.964915},
{0.006815,0.942942},
{0.006504,0.938027},
{0.003187,0.950392},
{0.963196,0.693773},
{0.95626,0.687452},
{0.956095,0.694997},
{0.948895,0.692843},
{0.962066,0.681973},
{0.236193,0.979303},
{0.230365,0.987048},
{0.227203,0.9771},
{0.222459,0.987604},
{0.21712,0.986405},
{0.216436,0.97492},
{0.226831,0.967858},
{0.217913,0.963453},
{0.986631,0.090108},
{0.984566,0.099294},
{0.979184,0.094833},
{0.97804,0.086091},
{0.986045,0.083514},
{0.7598,0.942787},
{0.769323,0.946352},
{0.778519,0.943714},
{0.778417,0.911396},
{0.770678,0.903401},
{0.753532,0.892588},
{0.776884,0.963632},
{0.945396,0.038475},
{0.945391,0.055371},
{0.871782,0.090193},
{0.873576,0.0777},
{0.903507,0.10553},
{0.929044,0.080805},
{0.944947,0.069608},
{0.249733,0.913168},
{0.241045,0.908151},
{0.25741,0.890583},
{0.261999,0.87422},
{0.54651,0.623647},
{0.540049,0.635918},
{0.559543,0.596027},
{0.96344,0.382414},
{0.940949,0.386098},
{0.961234,0.374778},
{0.937625,0.367806},
{0.919611,0.376487},
{0.925354,0.391055},
{0.962789,0.365093},
{0.961533,0.344104},
{0.937122,0.341368},
{0.926473,0.358642},
{0.495012,0.44133},
{0.522181,0.444844},
{0.534562,0.445608},
{0.559832,0.437094},
{0.570694,0.450048},
{0.580604,0.42083},
{0.591922,0.428392},
{0.599787,0.417304},
{0.593397,0.403589},
{0.611164,0.405228},
{0.498323,0.438414},
{0.477326,0.447025},
{0.483349,0.435421},
{0.283329,0.629013},
{0.288434,0.610837},
{0.302842,0.622461},
{0.298094,0.645255},
{0.313571,0.637295},
{0.330392,0.622854},
{0.330077,0.596004},
{0.305133,0.594393},
{0.278434,0.591866},
{0.271881,0.600417},
{0.092491,0.081101},
{0.050729,0.096824},
{0.021396,0.111622},
{0.009278,0.157099},
{0.003195,0.202144},
{0.195026,0.123997},
{0.186591,0.109326},
{0.218827,0.115953},
{0.190852,0.092152},
{0.174989,0.933671},
{0.179571,0.913015},
{0.189762,0.930714},
{0.17815,0.951297},
{0.165636,0.945398},
{0.164806,0.955142},
{0.147781,0.94916},
{0.152073,0.932553},
{0.144801,0.940381},
{0.162449,0.925316},
{0.143713,0.915049},
{0.149356,0.903192},
{0.163841,0.903958},
{0.153583,0.879474},
{0.176101,0.888192},
{0.171503,0.863895},
{0.155819,0.856732},
{0.346114,0.46331},
{0.335174,0.452839},
{0.345504,0.441755},
{0.361068,0.447858},
{0.375963,0.421536},
{0.364193,0.412777},
{0.34002,0.429185},
{0.360363,0.40533},
{0.374258,0.415748},
{0.371431,0.409076},
{0.366032,0.403856},
{0.363429,0.402498},
{0.400151,0.423167},
{0.415883,0.416577},
{0.409027,0.43647},
{0.405816,0.458254},
{0.419889,0.452979},
{0.486323,0.986817},
{0.483489,0.974917},
{0.518614,0.985383},
{0.50697,0.970323},
{0.477841,0.960508},
{0.503978,0.957232},
{0.483792,0.953628},
{0.095111,0.802552},
{0.087132,0.80985},
{0.082205,0.799273},
{0.089581,0.796591},
{0.100152,0.799318},
{0.102766,0.77352},
{0.107121,0.798916},
{0.107933,0.780247},
{0.101276,0.812327},
{0.087199,0.833874},
{0.105195,0.833925},
{0.11112,0.81347},
{0.105608,0.803671},
{0.811459,0.040892},
{0.804668,0.035163},
{0.806253,0.030298},
{0.828403,0.027374},
{0.820641,0.015469},
{0.79852,0.019528},
{0.813858,0.006303},
{0.79359,0.100461},
{0.812152,0.096681},
{0.807187,0.112298},
{0.796249,0.111048},
{0.803682,0.129028},
{0.815574,0.130354},
{0.818365,0.105146},
{0.816024,0.084624},
{0.83047,0.09556},
{0.821705,0.074655},
{0.815041,0.068601},
{0.794404,0.136559},
{0.802556,0.135578},
{0.811029,0.13806},
{0.820264,0.137719},
{0.827134,0.129599},
{0.831871,0.116404},
{0.840343,0.114304},
{0.84334,0.095762},
{0.844037,0.082124},
{0.836197,0.058602},
{0.814894,0.055657},
{0.030635,0.994762},
{0.030219,0.984747},
{0.041301,0.993953},
{0.040074,0.982857},
{0.036181,0.970853},
{0.028086,0.972677},
{0.867502,0.766576},
{0.857843,0.770989},
{0.857756,0.760269},
{0.865311,0.752018},
{0.857682,0.748583},
{0.93987,0.510291},
{0.925823,0.5116},
{0.934138,0.502719},
{0.924259,0.500551},
{0.919789,0.505749},
{0.650037,0.909137},
{0.640413,0.902858},
{0.661136,0.916919},
{0.665303,0.905572},
{0.236786,0.508858},
{0.237363,0.546958},
{0.230643,0.540518},
{0.22747,0.514767},
{0.123489,0.771888},
{0.114337,0.765376},
{0.127233,0.759947},
{0.121109,0.747324},
{0.103206,0.754794},
{0.09144,0.76729},
{0.085096,0.756695},
{0.090267,0.747419},
{0.076813,0.749561},
{0.079929,0.743382},
{0.244306,0.513003},
{0.254169,0.549922},
{0.24412,0.569371},
{0.234192,0.56978},
{0.238943,0.586274},
{0.249925,0.588598},
{0.253683,0.578754},
{0.717648,0.905895},
{0.708324,0.908081},
{0.714108,0.891331},
{0.722103,0.864709},
{0.71405,0.86046},
{0.705005,0.857791},
{0.7026,0.887584},
{0.706888,0.895352},
{0.716993,0.915029},
{0.708471,0.919447},
{0.723798,0.910228},
{0.977347,0.728963},
{0.747727,0.974177},
{0.752963,0.983034},
{0.752891,0.976123},
{0.260526,0.82862},
{0.260358,0.823822},
{0.264111,0.825923},
{0.263911,0.834874},
{0.260553,0.8388},
{0.263626,0.844786},
{0.690881,0.906896},
{0.681128,0.903281},
{0.692519,0.897854},
{0.696936,0.908141},
{0.684829,0.923033},
{0.677622,0.915876},
{0.674403,0.924224},
{0.676772,0.931971},
{0.682346,0.930258},
{0.671245,0.903559},
{0.669495,0.913333},
{0.910364,0.388208},
{0.907059,0.39561},
{0.904522,0.388208},
{0.839368,0.769748},
{0.832605,0.763162},
{0.841776,0.759638},
{0.831163,0.74539},
{0.852435,0.756152},
{0.851178,0.766794},
{0.097598,0.738633},
{0.106258,0.742875},
{0.69421,0.821803},
{0.691729,0.807184},
{0.705434,0.813294},
{0.71607,0.820475},
{0.716291,0.809042},
{0.824132,0.65373},
{0.814511,0.65341},
{0.819239,0.642143},
{0.833872,0.639057},
{0.85485,0.647763},
{0.842429,0.635805},
{0.785121,0.108631},
{0.78516,0.13269},
{0.787478,0.14138},
{0.97111,0.186262},
{0.975435,0.196839},
{0.969581,0.196377},
{0.966849,0.188902},
{0.91311,0.460108},
{0.260657,0.809304},
{0.261576,0.801872},
{0.264468,0.803192},
{0.38759,0.463592},
{0.390974,0.43121},
{0.389037,0.422847},
{0.380175,0.428993},
{0.369019,0.464428},
{0.403885,0.487652},
{0.422479,0.485669},
{0.207258,0.031984},
{0.217406,0.011282},
{0.219311,0.035705},
{0.213205,0.053934},
{0.227125,0.051811},
{0.233575,0.038206},
{0.231766,0.007645},
{0.220164,0.002919},
{0.214792,0.003365},
{0.517408,0.951358},
{0.519606,0.962171},
{0.511714,0.941453},
{0.525838,0.938336},
{0.516033,0.933782},
{0.375851,0.489336},
{0.352336,0.479048},
{0.366121,0.496662},
{0.395693,0.509694},
{0.410978,0.505596},
{0.430991,0.507134},
{0.451475,0.485221},
{0.431865,0.474559},
{0.437512,0.464052},
{0.428794,0.448807},
{0.191557,0.887683},
{0.194385,0.867947},
{0.178901,0.863242},
{0.224849,0.877395},
{0.230147,0.893079},
{0.208484,0.894902},
{0.211149,0.911549},
{0.151232,0.133639},
{0.144563,0.146956},
{0.164498,0.149378},
{0.167696,0.139556},
{0.187653,0.136477},
{0.481994,0.737585},
{0.479798,0.726271},
{0.497558,0.729717},
{0.504817,0.717352},
{0.512856,0.71658},
{0.531835,0.745643},
{0.535709,0.726239},
{0.52814,0.705835},
{0.512823,0.711899},
{0.190061,0.864072},
{0.212901,0.865291},
{0.229513,0.866305},
{0.229387,0.858},
{0.238481,0.864715},
{0.146699,0.169666},
{0.157896,0.16292},
{0.244374,0.051297},
{0.238941,0.068017},
{0.255901,0.076472},
{0.236374,0.104438},
{0.257213,0.106851},
{0.230189,0.128282},
{0.252977,0.123829},
{0.264318,0.114153},
{0.8596,0.473353},
{0.872594,0.493974},
{0.88414,0.502035},
{0.900854,0.505782},
{0.228578,0.068518},
{0.215133,0.074244},
{0.225413,0.087648},
{0.202772,0.06184},
{0.198389,0.04191},
{0.192526,0.053589},
{0.696093,0.033888},
{0.675792,0.030078},
{0.683271,0.01712},
{0.706717,0.021319},
{0.687315,0.007217},
{0.66337,0.061394},
{0.653045,0.044182},
{0.673116,0.054692},
{0.684384,0.078161},
{0.690158,0.050521},
{0.665484,0.037706},
{0.37894,0.514476},
{0.378346,0.516969},
{0.503755,0.756822},
{0.492133,0.79068},
{0.512195,0.783942},
{0.535473,0.774209},
{0.15663,0.216235},
{0.119022,0.358845},
{0.101177,0.353405},
{0.115077,0.352703},
{0.08936,0.344479},
{0.080676,0.346286},
{0.117896,0.402334},
{0.121302,0.394121},
{0.122736,0.387634},
{0.126998,0.382016},
{0.784769,0.664203},
{0.789229,0.663075},
{0.780613,0.684918},
{0.776407,0.700966},
{0.576402,0.53222},
{0.587435,0.488395},
{0.564423,0.485136},
{0.579018,0.474387},
{0.601601,0.443698},
{0.611783,0.442807},
{0.624049,0.42608},
{0.6282,0.44062},
{0.621195,0.456272},
{0.635092,0.465752},
{0.634915,0.448924},
{0.586731,0.545161},
{0.608707,0.517782},
{0.595572,0.502204},
{0.60441,0.485038},
{0.572978,0.572074},
{0.186591,0.547904},
{0.204999,0.540834},
{0.199385,0.564014},
{0.218041,0.543422},
{0.214,0.497657},
{0.162314,0.55761},
{0.194745,0.600705},
{0.207384,0.596077},
{0.219197,0.585331},
{0.222616,0.556298},
{0.242443,0.916168},
{0.246646,0.914878},
{0.256242,0.946983},
{0.259327,0.959553},
{0.24134,0.953794},
{0.244562,0.962378},
{0.843749,0.172722},
{0.846476,0.192018},
{0.833982,0.186691},
{0.831437,0.161707},
{0.846937,0.165078},
{0.847964,0.181863},
{0.121316,0.071226},
{0.14521,0.067118},
{0.434571,0.403689},
{0.440001,0.40023},
{0.432662,0.409077},
{0.412732,0.413613},
{0.387757,0.417096},
{0.847969,0.708524},
{0.977113,0.214719},
{0.970279,0.207799},
{0.970396,0.218068},
{0.970209,0.226849},
{0.967124,0.225816},
{0.967057,0.213741},
{0.8612,0.494189},
{0.862427,0.50953},
{0.461502,0.471843},
{0.471367,0.496225},
{0.455604,0.501964},
{0.428604,0.516483},
{0.4108,0.515687},
{0.416529,0.53536},
{0.427689,0.529909},
{0.424773,0.544172},
{0.431393,0.530917},
{0.540052,0.688855},
{0.54771,0.673903},
{0.54913,0.702881},
{0.556253,0.726577},
{0.578635,0.7156},
{0.567934,0.680782},
{0.564587,0.66105},
{0.552013,0.644644},
{0.549035,0.649097},
{0.488964,0.802263},
{0.481998,0.797771},
{0.499114,0.797352},
{0.52002,0.788868},
{0.019632,0.297083},
{0.057973,0.284882},
{0.052267,0.304854},
{0.076289,0.297951},
{0.851251,0.156007},
{0.851977,0.14448},
{0.840655,0.147694},
{0.576954,0.784514},
{0.560511,0.776019},
{0.597176,0.704211},
{0.582695,0.665855},
{0.568918,0.649513},
{0.403791,0.537264},
{0.403139,0.557217},
{0.424697,0.565371},
{0.427996,0.569662},
{0.428494,0.549655},
{0.336461,0.574255},
{0.320884,0.578674},
{0.340374,0.561789},
{0.361938,0.563838},
{0.357522,0.588056},
{0.378651,0.574594},
{0.383745,0.542389},
{0.313352,0.56624},
{0.292796,0.579668},
{0.347088,0.605742},
{0.379005,0.603982},
{0.398364,0.579901},
{0.419416,0.594182},
{0.434343,0.587909},
{0.48534,0.470327},
{0.759582,0.045283},
{0.769967,0.068054},
{0.746616,0.04913},
{0.743284,0.021766},
{0.728294,0.030544},
{0.718231,0.047576},
{0.737683,0.07169},
{0.758035,0.077471},
{0.771801,0.110187},
{0.751696,0.109653},
{0.752515,0.141581},
{0.76999,0.147967},
{0.754304,0.171536},
{0.770086,0.172866},
{0.748438,0.195256},
{0.731073,0.19175},
{0.731876,0.205247},
{0.712118,0.205965},
{0.717933,0.181911},
{0.695699,0.188873},
{0.692609,0.207484},
{0.703107,0.220246},
{0.72263,0.217589},
{0.72777,0.005905},
{0.741243,0.005121},
{0.717696,0.071192},
{0.734211,0.107351},
{0.745354,0.596611},
{0.72655,0.589956},
{0.738104,0.579998},
{0.756903,0.584759},
{0.770507,0.590086},
{0.761002,0.573755},
{0.20902,0.690059},
{0.188335,0.705799},
{0.18564,0.688301},
{0.188849,0.667816},
{0.170335,0.650872},
{0.185825,0.641705},
{0.152465,0.63129},
{0.219323,0.698952},
{0.210162,0.706021},
{0.538529,0.779323},
{0.76955,0.608325},
{0.741121,0.617015},
{0.772243,0.623893},
{0.762132,0.62779},
{0.710181,0.006685},
{0.700337,0.075386},
{0.699968,0.105465},
{0.718382,0.106591},
{0.712653,0.14166},
{0.732106,0.14393},
{0.737369,0.166652},
{0.710216,0.164623},
{0.68752,0.175635},
{0.673697,0.191057},
{0.677472,0.210588},
{0.675641,0.225841},
{0.923796,0.348065},
{0.947669,0.273613},
{0.974493,0.273362},
{0.96575,0.285138},
{0.946782,0.286644},
{0.961588,0.295014},
{0.951132,0.262928},
{0.978419,0.253435},
{0.951717,0.249724},
{0.981787,0.233671},
{0.95387,0.234221},
{0.943094,0.247002},
{0.147289,0.57693},
{0.151344,0.552742},
{0.147053,0.524444},
{0.142471,0.513035},
{0.208219,0.292825},
{0.19316,0.303212},
{0.215315,0.315003},
{0.238518,0.294537},
{0.175829,0.294712},
{0.164275,0.313062},
{0.176166,0.321967},
{0.205563,0.328452},
{0.148766,0.32585},
{0.131383,0.321645},
{0.103226,0.318651},
{0.072548,0.316509},
{0.078814,0.335308},
{0.099796,0.342323},
{0.072711,0.337998},
{0.118052,0.349226},
{0.110514,0.945693},
{0.104741,0.911009},
{0.120788,0.906806},
{0.12211,0.957286},
{0.130467,0.943603},
{0.13083,0.910436},
{0.128739,0.870649},
{0.122334,0.869796},
{0.035274,0.322831},
{0.055803,0.327434},
{0.041504,0.330721},
{0.021656,0.327292},
{0.040757,0.335842},
{0.058128,0.340506},
{0.802338,0.949378},
{0.813163,0.964912},
{0.954958,0.547702},
{0.972089,0.555334},
{0.963695,0.56942},
{0.938155,0.555513},
{0.931527,0.568547},
{0.954408,0.582696},
{0.973952,0.587113},
{0.986141,0.579137},
{0.983003,0.56474},
{0.990364,0.55435},
{0.98523,0.537086},
{0.964717,0.531323},
{0.944978,0.539055},
{0.993746,0.543462},
{0.978585,0.419899},
{0.797954,0.974317},
{0.790982,0.971241},
{0.789693,0.978345},
{0.794138,0.980096},
{0.47251,0.771769},
{0.470861,0.780018},
{0.469029,0.767806},
{0.467105,0.780361},
{0.472957,0.789951},
{0.46866,0.786456},
{0.031767,0.347614},
{0.013295,0.346425},
{0.011555,0.36189},
{0.058632,0.358538},
{0.059772,0.379904},
{0.017802,0.331193},
{0.781239,0.657303},
{0.664689,0.847675},
{0.679457,0.817887},
{0.698022,0.898703},
{0.791812,0.733484},
{0.724958,0.921069},
{0.718111,0.925701},
{0.836764,0.124419},
{0.835694,0.132937},
{0.856417,0.110184},
{0.848151,0.108661},
{0.847985,0.114822},
{0.851554,0.079436},
{0.984372,0.713009},
{0.991683,0.709954},
{0.992752,0.717388},
{0.979972,0.720987},
{0.986356,0.725196},
{0.993408,0.722985},
{0.229805,0.600933},
{0.238447,0.601886},
{0.243917,0.597713},
{0.959257,0.940842},
{0.955646,0.947092},
{0.963414,0.942511},
{0.96748,0.92963},
{0.963063,0.929773},
{0.962165,0.915335},
{0.94696,0.949464},
{0.941933,0.950438},
{0.87049,0.067736},
{0.950564,0.479203},
{0.959164,0.475001},
{0.965077,0.502254},
{0.949451,0.505754},
{0.964426,0.513265},
{0.95049,0.513327},
{0.951701,0.472347},
{0.423521,0.97789},
{0.418072,0.978605},
{0.417757,0.970167},
{0.425835,0.968847},
{0.417558,0.959382},
{0.428899,0.959511},
{0.424898,0.951927},
{0.419428,0.945924},
{0.425257,0.94685},
{0.42873,0.971313},
{0.975565,0.360229},
{0.97427,0.36291},
{0.970795,0.356981},
{0.745164,0.655247},
{0.732623,0.644689},
{0.737542,0.635362},
{0.74645,0.645184},
{0.74235,0.633588},
{0.979555,0.379916},
{0.971273,0.391229},
{0.968855,0.378557},
{0.971132,0.370892},
{0.743495,0.258702},
{0.759309,0.244052},
{0.755908,0.265484},
{0.747986,0.271881},
{0.72899,0.281833},
{0.738781,0.283167},
{0.783988,0.417618},
{0.786516,0.404673},
{0.775223,0.403233},
{0.763365,0.402145},
{0.755987,0.402357},
{0.766219,0.255374},
{0.780575,0.241973},
{0.778651,0.234749},
{0.766201,0.236237},
{0.790199,0.593397},
{0.785491,0.611876},
{0.783417,0.606331},
{0.777536,0.619916},
{0.294592,0.960115},
{0.305729,0.958801},
{0.295304,0.975426},
{0.302627,0.967678},
{0.309677,0.978076},
{0.319414,0.969711},
{0.309426,0.986404},
{0.302802,0.988963},
{0.294571,0.985046},
{0.882559,0.866773},
{0.887366,0.858001},
{0.897905,0.865026},
{0.895017,0.874691},
{0.921123,0.867906},
{0.924043,0.858431},
{0.902085,0.846247},
{0.890052,0.832986},
{0.884935,0.854419},
{0.877985,0.850842},
{0.876835,0.827497},
{0.875552,0.851012},
{0.874072,0.826452},
{0.231199,0.630646},
{0.22876,0.627896},
{0.242922,0.625365},
{0.240508,0.634175},
{0.251031,0.632431},
{0.25206,0.623777},
{0.249421,0.612894},
{0.2399,0.610696},
{0.232168,0.618904},
{0.227566,0.625237},
{0.722245,0.386303},
{0.718638,0.393907},
{0.718429,0.382706},
{0.240419,0.664951},
{0.238049,0.668509},
{0.233989,0.659226},
{0.241364,0.655578},
{0.245172,0.659746},
{0.251484,0.653801},
{0.253467,0.660957},
{0.258315,0.655334},
{0.804624,0.798022},
{0.801453,0.783179},
{0.813189,0.786305},
{0.801298,0.778524},
{0.795964,0.778989},
{0.88479,0.518802},
{0.887091,0.518045},
{0.884487,0.53648},
{0.880981,0.520858},
{0.879041,0.537585},
{0.878204,0.55704},
{0.880984,0.568909},
{0.874579,0.569491},
{0.87418,0.577128},
{0.894868,0.593969},
{0.904329,0.57579},
{0.893952,0.550813},
{0.888071,0.553474},
{0.893274,0.533832},
{0.913775,0.557939},
{0.918461,0.540609},
{0.902225,0.523815},
{0.744472,0.850659},
{0.736506,0.84921},
{0.739887,0.847301},
{0.758366,0.848014},
{0.750073,0.844037},
{0.761171,0.841982},
{0.76682,0.846974},
{0.771825,0.841774},
{0.76689,0.815939},
{0.756744,0.812849},
{0.744003,0.818734},
{0.74218,0.806656},
{0.744911,0.793446},
{0.730411,0.803993},
{0.732197,0.794613},
{0.736113,0.785705},
{0.624883,0.740723},
{0.631369,0.733482},
{0.629461,0.746534},
{0.626357,0.747237},
{0.630904,0.75933},
{0.628799,0.763709},
{0.636494,0.76782},
{0.635856,0.770851},
{0.858484,0.671411},
{0.858107,0.663199},
{0.862737,0.660182},
{0.903764,0.663618},
{0.889419,0.651871},
{0.911376,0.644908},
{0.913903,0.671556},
{0.923175,0.660632},
{0.923159,0.651881},
{0.252548,0.972209},
{0.258225,0.965866},
{0.260651,0.970255},
{0.260836,0.980355},
{0.251174,0.984877},
{0.254776,0.990831},
{0.682478,0.391776},
{0.683684,0.393802},
{0.681726,0.395749},
{0.50196,0.216067},
{0.467768,0.199527},
{0.544462,0.194437},
{0.496353,0.233742},
{0.560102,0.211742},
{0.573446,0.185974},
{0.571488,0.165398},
{0.537319,0.174877},
{0.481544,0.182144},
{0.456662,0.216696},
{0.466484,0.246637},
{0.484409,0.252948},
{0.456993,0.272329},
{0.448911,0.254383},
{0.434857,0.270285},
{0.43727,0.289031},
{0.418736,0.279664},
{0.427088,0.29528},
{0.418579,0.303235},
{0.402071,0.283985},
{0.414396,0.308328},
{0.399212,0.286987},
{0.405776,0.304247},
{0.388629,0.2831},
{0.385499,0.307828},
{0.370978,0.29195},
{0.367557,0.316197},
{0.383531,0.327327},
{0.393611,0.31777},
{0.607443,0.137972},
{0.590371,0.124258},
{0.568007,0.141873},
{0.556401,0.152577},
{0.532872,0.158223},
{0.48192,0.161746},
{0.534256,0.140689},
{0.505268,0.135716},
{0.479559,0.143787},
{0.850667,0.598696},
{0.847727,0.606226},
{0.844119,0.603721},
{0.82477,0.459987},
{0.834637,0.47832},
{0.815855,0.468605},
{0.81737,0.444301},
{0.818252,0.426851},
{0.815008,0.430013},
{0.812628,0.422057},
{0.362011,0.767157},
{0.368707,0.754228},
{0.369943,0.758016},
{0.375228,0.764301},
{0.366863,0.770954},
{0.38306,0.769864},
{0.386152,0.769265},
{0.38931,0.785463},
{0.284948,0.29201},
{0.279014,0.28524},
{0.296472,0.278669},
{0.314687,0.293668},
{0.322449,0.272789},
{0.313821,0.267461},
{0.306985,0.348672},
{0.304241,0.320867},
{0.336061,0.306402},
{0.329837,0.345679},
{0.354268,0.313274},
{0.341413,0.286905},
{0.305947,0.311966},
{0.296856,0.315653},
{0.29257,0.328337},
{0.293598,0.356141},
{0.297488,0.37808},
{0.30644,0.379524},
{0.316737,0.383041},
{0.342306,0.374033},
{0.352555,0.352165},
{0.325697,0.826846},
{0.331275,0.827324},
{0.32135,0.836512},
{0.305922,0.836976},
{0.295267,0.837886},
{0.950674,0.610302},
{0.943322,0.62194},
{0.938764,0.613864},
{0.944501,0.5928},
{0.942545,0.597741},
{0.357527,0.970857},
{0.35805,0.96681},
{0.366963,0.973759},
{0.354495,0.980261},
{0.353645,0.988019},
{0.123727,0.852304},
{0.127144,0.846902},
{0.129542,0.850787},
{0.122593,0.862604},
{0.129771,0.861791},
{0.118049,0.860562},
{0.112976,0.864462},
{0.118796,0.851197},
{0.11203,0.857893},
{0.112515,0.84643},
{0.289961,0.709766},
{0.277086,0.700614},
{0.285759,0.700259},
{0.310813,0.709594},
{0.30568,0.716257},
{0.326881,0.718263},
{0.332344,0.714246},
{0.353453,0.728655},
{0.350852,0.7224},
{0.37261,0.737579},
{0.369411,0.731167},
{0.353483,0.367008},
{0.366416,0.352621},
{0.339753,0.38218},
{0.308121,0.391604},
{0.287738,0.395589},
{0.282967,0.39125},
{0.275328,0.393766},
{0.270392,0.389867},
{0.784643,0.597826},
{0.78313,0.584271},
{0.786216,0.580818},
{0.777224,0.573409},
{0.778533,0.568705},
{0.853598,0.219001},
{0.854866,0.225214},
{0.853411,0.228153},
{0.802217,0.63061},
{0.803977,0.623508},
{0.808072,0.625298},
{0.81032,0.630613},
{0.709566,0.520343},
{0.716668,0.537979},
{0.700554,0.504943},
{0.691479,0.547669},
{0.706791,0.556977},
{0.72477,0.537505},
{0.035668,0.829574},
{0.023892,0.839343},
{0.014224,0.833836},
{0.022558,0.815388},
{0.048539,0.820557},
{0.048866,0.795628},
{0.030879,0.779997},
{0.003348,0.75788},
{0.017833,0.74767},
{0.028703,0.742926},
{0.047076,0.772482},
{0.039396,0.741997},
{0.849579,0.792364},
{0.857489,0.789862},
{0.851962,0.804972},
{0.838429,0.805317},
{0.837714,0.831816},
{0.854368,0.836422},
{0.862771,0.802809},
{0.86425,0.786707},
{0.960093,0.166308},
{0.963764,0.156588},
{0.969737,0.165528},
{0.963831,0.146858},
{0.961607,0.150046},
{0.95203,0.167951},
{0.968801,0.177163},
{0.981472,0.159415},
{0.973344,0.134726},
{0.966698,0.14218},
{0.090742,0.608871},
{0.07927,0.62572},
{0.083332,0.599279},
{0.125232,0.606847},
{0.128066,0.589684},
{0.110919,0.58505},
{0.077059,0.585472},
{0.069425,0.624663},
{0.081718,0.65354},
{0.059329,0.652551},
{0.07941,0.671299},
{0.062736,0.670384},
{0.073586,0.699043},
{0.083453,0.70064},
{0.08124,0.715859},
{0.072735,0.716082},
{0.059616,0.706623},
{0.059158,0.722374},
{0.047082,0.725925},
{0.045683,0.711229},
{0.034038,0.728244},
{0.041738,0.676045},
{0.020983,0.675582},
{0.02101,0.724918},
{0.006728,0.688701},
{0.007815,0.723349},
{0.015766,0.730189},
{0.001562,0.730044},
{0.945958,0.122451},
{0.942734,0.133596},
{0.937166,0.132957},
{0.936544,0.121904},
{0.932071,0.125616},
{0.142648,0.966072},
{0.142886,0.959498},
{0.153831,0.966561},
{0.148081,0.976713},
{0.157535,0.979735},
{0.163851,0.969143},
{0.15995,0.967043},
{0.154204,0.961073},
{0.357679,0.650031},
{0.36908,0.618439},
{0.391091,0.63415},
{0.369117,0.657462},
{0.396315,0.664432},
{0.429735,0.639201},
{0.408752,0.616446},
{0.350033,0.634022},
{0.330502,0.649344},
{0.341852,0.668809},
{0.359371,0.675713},
{0.378525,0.669916},
{0.895859,0.764031},
{0.895455,0.770877},
{0.888366,0.769735},
{0.890341,0.761835},
{0.882652,0.761936},
{0.887743,0.750905},
{0.896674,0.751409},
{0.166902,0.799388},
{0.186113,0.800601},
{0.19717,0.788156},
{0.212323,0.766903},
{0.2008,0.743681},
{0.206604,0.72103},
{0.22205,0.739417},
{0.233891,0.760242},
{0.233712,0.734572},
{0.59531,0.890161},
{0.620864,0.890227},
{0.634728,0.689522},
{0.632366,0.701242},
{0.631289,0.693888},
{0.634108,0.661447},
{0.719913,0.317659},
{0.207673,0.799923},
{0.222674,0.806594},
{0.202855,0.815119},
{0.16903,0.820738},
{0.205732,0.83672},
{0.231074,0.82864},
{0.244393,0.819134},
{0.239404,0.789031},
{0.217441,0.784759},
{0.16104,0.800978},
{0.147285,0.797624},
{0.145854,0.779109},
{0.620283,0.904817},
{0.624081,0.902836},
{0.584116,0.880386},
{0.844992,0.362099},
{0.84311,0.367837},
{0.83283,0.356438},
{0.835394,0.34264},
{0.825379,0.326092},
{0.813919,0.338968},
{0.813796,0.355969},
{0.791664,0.349059},
{0.789712,0.320271},
{0.788946,0.351636},
{0.248467,0.770964},
{0.253024,0.789035},
{0.253425,0.808726},
{0.698626,0.375568},
{0.265541,0.671053},
{0.263408,0.673271},
{0.264191,0.607891},
{0.26538,0.607004},
{0.253231,0.756855},
{0.243779,0.744709},
{0.813106,0.31076},
{0.827803,0.277636},
{0.819288,0.269766},
{0.792597,0.282982},
{0.737712,0.48505},
{0.753584,0.431069},
{0.323561,0.82739},
{0.363579,0.957645},
{0.369592,0.965823},
{0.956402,0.60664},
{0.959474,0.615182},
{0.966006,0.604101},
{0.965121,0.598781},
{0.955494,0.590978},
{0.98034,0.910393},
{0.974651,0.912188},
{0.979807,0.903907},
{0.98078,0.902833},
{0.835272,0.313872},
{0.846532,0.316902},
{0.839194,0.323532},
{0.832432,0.31935},
{0.836211,0.327951},
{0.805212,0.259659},
{0.817111,0.251519},
{0.807092,0.244121},
{0.23722,0.847722},
{0.247955,0.844969},
{0.710799,0.240747},
{0.707594,0.244138},
{0.70961,0.23295},
{0.319526,0.728762},
{0.305849,0.729611},
{0.291142,0.71877},
{0.288741,0.727299},
{0.281827,0.71441},
{0.276815,0.722565},
{0.273347,0.717683},
{0.273573,0.712142},
{0.834313,0.264377},
{0.836786,0.275112},
{0.834076,0.296445},
{0.341615,0.79881},
{0.329443,0.792969},
{0.350842,0.778573},
{0.36021,0.787341},
{0.358806,0.772816},
{0.362664,0.78483},
{0.365334,0.77765},
{0.320904,0.800779},
{0.323742,0.814456},
{0.295561,0.652093},
{0.285344,0.637868},
{0.303295,0.662664},
{0.287461,0.309913},
{0.279482,0.32302},
{0.278311,0.33348},
{0.373877,0.794242},
{0.832161,0.232197},
{0.837265,0.243176},
{0.830813,0.233246},
{0.835342,0.258442},
{0.827769,0.259757},
{0.82999,0.24772},
{0.821912,0.242682},
{0.358165,0.750039},
{0.368588,0.745471},
{0.348803,0.73694},
{0.335479,0.731783},
{0.347591,0.737878},
{0.273751,0.317684},
{0.35644,0.275357},
{0.335222,0.271421},
{0.343505,0.260686},
{0.359871,0.253822},
{0.344376,0.250185},
{0.351619,0.241936},
{0.36712,0.253475},
{0.35387,0.2299},
{0.348249,0.234216},
{0.385327,0.751794},
{0.381603,0.755964},
{0.048437,0.62026},
{0.052455,0.630261},
{0.029734,0.624833},
{0.03713,0.655748},
{0.006045,0.665358},
{0.018599,0.652084},
{0.013866,0.626927},
{0.027452,0.584344},
{0.013803,0.582572},
{0.002417,0.599068},
{0.001126,0.584655},
{0.31303,0.054117},
{0.290957,0.015843},
{0.323973,0.047831},
{0.325548,0.074469},
{0.337739,0.064476},
{0.333128,0.039449},
{0.298838,0.010435},
{0.654205,0.398984},
{0.666651,0.403147},
{0.653835,0.411653},
{0.662951,0.447658},
{0.675774,0.446645},
{0.680727,0.405892},
{0.692366,0.419571},
{0.695153,0.40992},
{0.687294,0.408257},
{0.703138,0.411075},
{0.709478,0.42998},
{0.69391,0.454258},
{0.715895,0.464861},
{0.707877,0.477237},
{0.680446,0.469878},
{0.712561,0.508488},
{0.716992,0.502051},
{0.806559,0.225093},
{0.799206,0.221255},
{0.8075,0.213455},
{0.814053,0.225189},
{0.823997,0.202179},
{0.822396,0.175675},
{0.812338,0.17691},
{0.799517,0.209753},
{0.786575,0.214211},
{0.793282,0.192394},
{0.783823,0.207745},
{0.910303,0.688621},
{0.931847,0.6716},
{0.935619,0.687399},
{0.944335,0.674105},
{0.934549,0.699167},
{0.900663,0.716002},
{0.934332,0.710874},
{0.931772,0.72102},
{0.934264,0.733456},
{0.901293,0.745324},
{0.930647,0.742298},
{0.893319,0.175155},
{0.916141,0.165172},
{0.923183,0.171652},
{0.918808,0.182292},
{0.925321,0.180418},
{0.92597,0.189816},
{0.918746,0.190529},
{0.927254,0.197866},
{0.907658,0.199466},
{0.894838,0.196784},
{0.896734,0.190106},
{0.887459,0.194182},
{0.867843,0.216196},
{0.885515,0.213323},
{0.893441,0.218953},
{0.924862,0.16274},
{0.898809,0.162722},
{0.87825,0.170311},
{0.883222,0.180814},
{0.947474,0.189193},
{0.954427,0.187147},
{0.960124,0.196629},
{0.943631,0.194068},
{0.952576,0.200487},
{0.960919,0.205725},
{0.941279,0.206531},
{0.951151,0.210888},
{0.959424,0.213861},
{0.954129,0.221684},
{0.96467,0.220157},
{0.94146,0.184837},
{0.933577,0.191746},
{0.935965,0.199572},
{0.084061,0.850756},
{0.084567,0.863681},
{0.080696,0.859759},
{0.07847,0.84813},
{0.934378,0.972094},
{0.934557,0.963657},
{0.942223,0.966413},
{0.943487,0.980929},
{0.949438,0.973011},
{0.945797,0.955223},
{0.939145,0.95545},
{0.232275,0.614365},
{0.911998,0.153176},
{0.886416,0.156872},
{0.874857,0.1606},
{0.915418,0.142041},
{0.922342,0.153537},
{0.922043,0.144362},
{0.889296,0.14345},
{0.874259,0.148634},
{0.879376,0.135449},
{0.867445,0.139194},
{0.872262,0.124713},
{0.884205,0.122982},
{0.893258,0.131477},
{0.9057,0.135522},
{0.920217,0.128944},
{0.91658,0.119968},
{0.910695,0.114166},
{0.893812,0.117944},
{0.980843,0.175319},
{0.988831,0.16717},
{0.992155,0.149084},
{0.985252,0.12751},
{0.975649,0.124275},
{0.256215,0.64199},
{0.248349,0.639934},
{0.239271,0.640758},
{0.244009,0.646564},
{0.254513,0.648333},
{0.935483,0.213569},
{0.940437,0.219569},
{0.9422,0.22515},
{0.950188,0.226507},
{0.927614,0.821274},
{0.917652,0.807106},
{0.925649,0.802231},
{0.927848,0.80641},
{0.266473,0.768937},
{0.261455,0.758031},
{0.264486,0.7507},
{0.65651,0.939068},
{0.670442,0.935888},
{0.657258,0.969132},
{0.64742,0.970617},
{0.64816,0.941121},
{0.957267,0.072082},
{0.955625,0.06049},
{0.965848,0.066811},
{0.964443,0.076017},
{0.967464,0.091533},
{0.966812,0.08647},
{0.964251,0.06058},
{0.970084,0.062959},
{0.875035,0.790954},
{0.880033,0.786563},
{0.88844,0.787427},
{0.927175,0.835528},
{0.903258,0.785169},
{0.891183,0.776296},
{0.885706,0.781527},
{0.776788,0.980106},
{0.77635,0.988324},
{0.765197,0.977634},
{0.777582,0.970493},
{0.762633,0.969654},
{0.77058,0.991502},
{0.760009,0.98403},
{0.757083,0.978156},
{0.79495,0.152145},
{0.799965,0.146605},
{0.801591,0.175174},
{0.796195,0.174329},
{0.785459,0.157887},
{0.787722,0.152129},
{0.250736,0.669231},
{0.254251,0.670812},
{0.261175,0.664025},
{0.17835,0.985454},
{0.170771,0.987173},
{0.172048,0.977533},
{0.166615,0.981622},
{0.973182,0.932976},
{0.980782,0.927739},
{0.982327,0.937162},
{0.977621,0.944077},
{0.970922,0.941374},
{0.233371,0.643701},
{0.977895,0.919286},
{0.971911,0.922479},
{0.247146,0.682159},
{0.255409,0.683576},
{0.250945,0.692237},
{0.233191,0.681596},
{0.235121,0.689461},
{0.228061,0.687661},
{0.230733,0.691828},
{0.245646,0.980123},
{0.241343,0.986434},
{0.234935,0.674907},
{0.231364,0.655976},
{0.872525,0.803903},
{0.872333,0.799011},
{0.868688,0.792761},
{0.870538,0.788815},
{0.240306,0.674306},
{0.987545,0.965497},
{0.979661,0.97653},
{0.980733,0.960035},
{0.986214,0.95837},
{0.982042,0.952185},
{0.976904,0.967138},
{0.973864,0.961819},
{0.982545,0.116046},
{0.24797,0.669252},
{0.869651,0.875321},
{0.671718,0.970663},
{0.669367,0.951319},
{0.682865,0.950534},
{0.878024,0.687886},
{0.858997,0.701384},
{0.858533,0.684497},
{0.27692,0.027649},
{0.291152,0.033091},
{0.276906,0.037585},
{0.299946,0.061714},
{0.288712,0.065668},
{0.302582,0.092432},
{0.313693,0.084284},
{0.323095,0.66042},
{0.614456,0.196722},
{0.60263,0.188124},
{0.620143,0.172248},
{0.583515,0.100449},
{0.567386,0.095442},
{0.570091,0.070622},
{0.556102,0.068112},
{0.542755,0.08143},
{0.548281,0.103035},
{0.55749,0.126442},
{0.389897,0.872957},
{0.398433,0.865017},
{0.412635,0.872032},
{0.396905,0.887425},
{0.418418,0.889565},
{0.436498,0.88127},
{0.441087,0.866321},
{0.438007,0.852609},
{0.460995,0.869176},
{0.455667,0.843347},
{0.467698,0.852038},
{0.463465,0.874411},
{0.382744,0.910769},
{0.388584,0.897453},
{0.401504,0.910781},
{0.394158,0.923714},
{0.314312,0.870858},
{0.302,0.854002},
{0.318651,0.85543},
{0.324692,0.890772},
{0.343653,0.889534},
{0.329826,0.86012},
{0.328934,0.851684},
{0.328276,0.846091},
{0.30396,0.850381},
{0.280612,0.850379},
{0.285299,0.854424},
{0.309085,0.890852},
{0.306701,0.911006},
{0.319827,0.922252},
{0.337083,0.917182},
{0.360607,0.883132},
{0.339283,0.854481},
{0.340843,0.845887},
{0.334167,0.844621},
{0.591781,0.915538},
{0.609694,0.908001},
{0.62341,0.915344},
{0.616472,0.92679},
{0.632735,0.927212},
{0.63694,0.916105},
{0.583003,0.929748},
{0.594693,0.926596},
{0.614693,0.942699},
{0.629805,0.937111},
{0.588246,0.93861},
{0.60472,0.95282},
{0.617484,0.957622},
{0.630034,0.951859},
{0.781009,0.836868},
{0.787797,0.835616},
{0.777035,0.844204},
{0.812065,0.415148},
{0.810413,0.407048},
{0.831369,0.400632},
{0.835781,0.411552},
{0.84199,0.427714},
{0.848296,0.414503},
{0.845477,0.403346},
{0.456856,0.715439},
{0.457843,0.720426},
{0.450428,0.725262},
{0.435372,0.709764},
{0.423506,0.739802},
{0.445381,0.741661},
{0.436141,0.757996},
{0.444932,0.752409},
{0.441557,0.768961},
{0.423616,0.77769},
{0.433447,0.790042},
{0.443274,0.779547},
{0.445223,0.775458},
{0.442571,0.799844},
{0.452843,0.789599},
{0.453316,0.801534},
{0.441502,0.816017},
{0.447264,0.825899},
{0.45728,0.825763},
{0.45168,0.833027},
{0.441636,0.832931},
{0.203552,0.972896},
{0.212887,0.968874},
{0.209176,0.983588},
{0.195788,0.981504},
{0.199407,0.989038},
{0.192019,0.989023},
{0.053694,0.849291},
{0.044592,0.854742},
{0.046149,0.844508},
{0.033105,0.849646},
{0.020165,0.853249},
{0.015525,0.842162},
{0.010083,0.84999},
{0.014778,0.859143},
{0.00383,0.855453},
{0.008109,0.863563},
{0.410518,0.738201},
{0.425393,0.703961},
{0.434366,0.696319},
{0.444622,0.698887},
{0.462789,0.709204},
{0.868896,0.320507},
{0.875053,0.330545},
{0.865553,0.335767},
{0.857197,0.29418},
{0.855905,0.335248},
{0.863285,0.344862},
{0.853021,0.346089},
{0.848915,0.341023},
{0.876518,0.324112},
{0.880365,0.315999},
{0.876714,0.286043},
{0.867623,0.288978},
{0.854868,0.24982},
{0.865022,0.249235},
{0.864599,0.236},
{0.855897,0.23497},
{0.950753,0.304427},
{0.948494,0.315189},
{0.943556,0.311368},
{0.943571,0.30208},
{0.149779,0.987981},
{0.159921,0.988771},
{0.142428,0.978494},
{0.891124,0.32521},
{0.902106,0.329615},
{0.893099,0.333571},
{0.888763,0.33265},
{0.906899,0.341507},
{0.902517,0.349031},
{0.911562,0.349473},
{0.002158,0.846587},
{0.005489,0.836778},
{0.121758,0.982098},
{0.125889,0.99123},
{0.112674,0.981558},
{0.124513,0.975099},
{0.113949,0.968124},
{0.840464,0.514398},
{0.833291,0.521223},
{0.825616,0.493572},
{0.81515,0.481822},
{0.80135,0.49345},
{0.808492,0.503599},
{0.816953,0.509117},
{0.809809,0.528914},
{0.820195,0.513523},
{0.849093,0.512197},
{0.846811,0.46427},
{0.847501,0.433365},
{0.764486,0.796144},
{0.775073,0.805907},
{0.757482,0.785192},
{0.773352,0.788828},
{0.779061,0.795733},
{0.879469,0.232484},
{0.874831,0.241964},
{0.886233,0.249333},
{0.894797,0.238178},
{0.852759,0.423699},
{0.798311,0.497733},
{0.869353,0.571695},
{0.873537,0.565713},
{0.469484,0.806658},
{0.467505,0.816479},
{0.468763,0.795349},
{0.473088,0.796524},
{0.470839,0.792547},
{0.770134,0.855565},
{0.759775,0.857047},
{0.767526,0.87692},
{0.753534,0.8814},
{0.76038,0.888955},
{0.769346,0.885579},
{0.359545,0.908551},
{0.351638,0.923884},
{0.417141,0.903726},
{0.439206,0.904755},
{0.458082,0.89142},
{0.531109,0.129292},
{0.544751,0.128844},
{0.546557,0.114552},
{0.53587,0.108589},
{0.459346,0.612411},
{0.473119,0.62442},
{0.466179,0.629138},
{0.453327,0.613548},
{0.455911,0.649368},
{0.421435,0.666828},
{0.44109,0.679795},
{0.417568,0.671401},
{0.465263,0.926524},
{0.439556,0.924737},
{0.413095,0.920893},
{0.379536,0.882396},
{0.296403,0.890254},
{0.287191,0.913828},
{0.298224,0.933367},
{0.319581,0.947536},
{0.330801,0.941669},
{0.337144,0.935248},
{0.640368,0.03385},
{0.631616,0.044875},
{0.625813,0.026701},
{0.644459,0.019239},
{0.61216,0.038757},
{0.596121,0.02406},
{0.609691,0.012836},
{0.890468,0.61111},
{0.906577,0.603806},
{0.909441,0.62225},
{0.920474,0.613763},
{0.917464,0.595625},
{0.924238,0.574025},
{0.614838,0.04895},
{0.634339,0.059415},
{0.645192,0.049294},
{0.622964,0.973698},
{0.634476,0.969987},
{0.667497,0.177633},
{0.683217,0.158844},
{0.666564,0.153328},
{0.659766,0.170886},
{0.650841,0.161435},
{0.2882,0.902559},
{0.461398,0.909245},
{0.373247,0.267286},
{0.386779,0.274359},
{0.384017,0.263173},
{0.368899,0.249166},
{0.35721,0.2266},
{0.062263,0.560596},
{0.078508,0.556343},
{0.048907,0.593846},
{0.321873,0.120995},
{0.304711,0.104281},
{0.3298,0.109901},
{0.349057,0.138441},
{0.342536,0.098206},
{0.312601,0.005051},
{0.657861,0.461085},
{0.659074,0.492889},
{0.670854,0.501793},
{0.683389,0.506839},
{0.675734,0.548116},
{0.688026,0.573643},
{0.69077,0.594366},
{0.701887,0.577663},
{0.698886,0.596477},
{0.687202,0.612089},
{0.695767,0.615539},
{0.687827,0.629129},
{0.66165,0.612904},
{0.667193,0.595269},
{0.654741,0.594781},
{0.662495,0.543984},
{0.648388,0.5437},
{0.647792,0.592657},
{0.838069,0.79185},
{0.821919,0.804018},
{0.828512,0.79082},
{0.84066,0.787454},
{0.829846,0.786432},
{0.802478,0.832668},
{0.816913,0.831247},
{0.861323,0.853013},
{0.837427,0.852552},
{0.866049,0.827983},
{0.840299,0.87739},
{0.846579,0.890952},
{0.827818,0.890529},
{0.812966,0.877045},
{0.820869,0.895384},
{0.83181,0.893251},
{0.001814,0.091558},
{0.019721,0.085867},
{0.049897,0.086575},
{0.598213,0.089916},
{0.601622,0.111229},
{0.577319,0.050896},
{0.569966,0.031207},
{0.548212,0.041103},
{0.538046,0.054139},
{0.878656,0.618504},
{0.866591,0.585266},
{0.858307,0.585103},
{0.855112,0.590486},
{0.371075,0.856207},
{0.363462,0.866144},
{0.374237,0.876034},
{0.271356,0.850301},
{0.269526,0.845671},
{0.559219,0.943146},
{0.560785,0.935049},
{0.566728,0.939767},
{0.562745,0.950097},
{0.568861,0.954427},
{0.561034,0.960659},
{0.564605,0.970659},
{0.559251,0.971565},
{0.556961,0.953928},
{0.860569,0.579429},
{0.570645,0.015904},
{0.596596,0.057952},
{0.613258,0.064349},
{0.624091,0.068941},
{0.439838,0.600383},
{0.42907,0.619392},
{0.446625,0.177376},
{0.439437,0.1895},
{0.428175,0.177443},
{0.428139,0.200702},
{0.439783,0.230182},
{0.419827,0.213801},
{0.423626,0.241708},
{0.010407,0.273536},
{0.427366,0.156847},
{0.416369,0.162293},
{0.394453,0.116925},
{0.409941,0.119933},
{0.812812,0.90178},
{0.801381,0.905491},
{0.798198,0.881101},
{0.343386,0.689077},
{0.351777,0.682994},
{0.364986,0.676424},
{0.556396,0.023624},
{0.270575,0.929418},
{0.282417,0.934902},
{0.280992,0.951981},
{0.297169,0.950341},
{0.351909,0.932808},
{0.34582,0.936353},
{0.647577,0.506669},
{0.643459,0.533288},
{0.43862,0.16028},
{0.412845,0.188781},
{0.403618,0.215397},
{0.406077,0.251457},
{0.691029,0.13335},
{0.815098,0.852872},
{0.861478,0.878282},
{0.859601,0.89724},
{0.80006,0.851801},
{0.393831,0.145589},
{0.390631,0.162874},
{0.404685,0.175208},
{0.391993,0.191958},
{0.383396,0.209206},
{0.392729,0.221398},
{0.380173,0.184295},
{0.371806,0.148255},
{0.376559,0.118069},
{0.362518,0.128647},
{0.357373,0.159021},
{0.370392,0.197291},
{0.015975,0.538346},
{0.018613,0.524509},
{0.031534,0.532162},
{0.039614,0.538532},
{0.056125,0.531023},
{0.055678,0.517478},
{0.03069,0.511318},
{0.068912,0.529801},
{0.042149,0.576849},
{0.347917,0.079942},
{0.359663,0.090761},
{0.362711,0.067778},
{0.351965,0.047528},
{0.34485,0.03462},
{0.645029,0.441616},
{0.647866,0.459796},
{0.648841,0.486112},
{0.974715,0.606398},
{0.969639,0.599787},
{0.97676,0.596113},
{0.980589,0.598064},
{0.977281,0.615798},
{0.973565,0.616642},
{0.968607,0.625827},
{0.056097,0.970413},
{0.057586,0.982276},
{0.049888,0.982815},
{0.066032,0.50933},
{0.05164,0.500752},
{0.35727,0.382884},
{0.355944,0.374132},
{0.89995,0.309055},
{0.909098,0.322003},
{0.911618,0.329693},
{0.84194,0.523546},
{0.412494,0.762324},
{0.411139,0.77574},
{0.396439,0.787984},
{0.404908,0.787041},
{0.410398,0.792923},
{0.417124,0.797673},
{0.41896,0.812421},
{0.43324,0.809281},
{0.968467,0.304942},
{0.979919,0.301398},
{0.974979,0.311679},
{0.965751,0.313685},
{0.44194,0.82334},
{0.193677,0.971602},
{0.201586,0.96276},
{0.191975,0.961544},
{0.46699,0.953343},
{0.474348,0.949971},
{0.474076,0.958782},
{0.410082,0.818482},
{0.409024,0.804878},
{0.404233,0.793749},
{0.401008,0.800259},
{0.40373,0.807167},
{0.05462,0.838824},
{0.395681,0.771609},
{0.402641,0.758567},
{0.059433,0.809804},
{0.063611,0.825931},
{0.05745,0.823227},
{0.056378,0.794624},
{0.473078,0.819047},
{0.470694,0.830539},
{0.471809,0.818227},
{0.631115,0.731325},
{0.635567,0.726425},
{0.875135,0.705921},
{0.876014,0.726431},
{0.880663,0.742914},
{0.861169,0.734441},
{0.860164,0.715238},
{0.858508,0.723063},
{0.977075,0.354299},
{0.979888,0.346711},
{0.980947,0.355175},
{0.329476,0.266906},
{0.335486,0.264288},
{0.335451,0.256234},
{0.338832,0.257544},
{0.336812,0.242404},
{0.980116,0.335894},
{0.971835,0.345306},
{0.970818,0.352292},
{0.968452,0.335924},
{0.97277,0.328474},
{0.970627,0.32456},
{0.979258,0.321932},
{0.384872,0.794815},
{0.375704,0.779312},
{0.381229,0.781821},
{0.234755,0.700541},
{0.24014,0.710415},
{0.228935,0.710846},
{0.236233,0.715637},
{0.962587,0.312245},
{0.956047,0.307837},
{0.956699,0.304797},
{0.78225,0.624737},
{0.78225,0.630929},
{0.779267,0.627914},
{0.781233,0.895064},
{0.785214,0.893505},
{0.784922,0.901178},
{0.783653,0.902961},
{0.737559,0.899586},
{0.746259,0.893181},
{0.740147,0.892543},
{0.259688,0.739706},
{0.258802,0.731991},
{0.260615,0.733758},
{0.762488,0.385101},
{0.761973,0.393605},
{0.760448,0.392127},
{0.760274,0.383395},
{0.451439,0.969576},
{0.452431,0.960196},
{0.448122,0.964415},
{0.442611,0.964285},
{0.440255,0.974169},
{0.446971,0.978461},
{0.850433,0.220218},
{0.850468,0.226527},
{0.846763,0.223188},
{0.759413,0.775509},
{0.755075,0.772259},
{0.795318,0.390343},
{0.788197,0.370813},
{0.797339,0.375664},
{0.804836,0.388895},
{0.805291,0.382003},
{0.548805,0.978958},
{0.544646,0.979544},
{0.844762,0.576623},
{0.847259,0.587964},
{0.850248,0.594912},
{0.943619,0.890753},
{0.935889,0.885442},
{0.939922,0.882708},
{0.932437,0.880602},
{0.907941,0.386276},
{0.905811,0.386445},
{0.90452,0.375164},
{0.907945,0.37239},
{0.703232,0.972409},
{0.048029,0.983879},
{0.770085,0.557488},
{0.754613,0.565684},
{0.72825,0.521086},
{0.740631,0.554835},
{0.264563,0.738992},
{0.263766,0.710922},
{0.266266,0.735793},
{0.264876,0.689516},
{0.266227,0.690321},
{0.871891,0.365636},
{0.533193,0.922143},
{0.53523,0.927895},
{0.819442,0.584452},
{0.498879,0.80881},
{0.717368,0.79863},
{0.727382,0.798466},
{0.850453,0.537938},
{0.840374,0.544429},
{0.838399,0.538051},
{0.846997,0.533472},
{0.901231,0.394959},
{0.894224,0.393378},
{0.632156,0.709999},
{0.636008,0.707933},
{0.636199,0.714907},
{0.630873,0.72016},
{0.769467,0.649746},
{0.291829,0.974001},
{0.291655,0.979196},
{0.967792,0.854222},
{0.834363,0.376894},
{0.839153,0.372869},
{0.940283,0.750594},
{0.93587,0.760378},
{0.93233,0.752292},
{0.948714,0.869938},
{0.947761,0.857949},
{0.94973,0.854957},
{0.989877,0.099223},
{0.936664,0.825323},
{0.934496,0.832996},
{0.98234,0.466536},
{0.943718,0.092496},
{0.925586,0.099511},
{0.941164,0.109144},
{0.924249,0.110217},
{0.005448,0.890849},
{0.00607,0.915426},
{0.888944,0.886286},
{0.956126,0.680531},
{0.108946,0.973213},
{0.107028,0.966375},
{0.685925,0.391937},
{0.687307,0.395749},
{0.685432,0.395551},
{0.979852,0.105749},
{0.836862,0.395439},
{0.23834,0.968752},
{0.236178,0.973487},
{0.232006,0.960704},
{0.433355,0.950976},
{0.435792,0.947522},
{0.022355,0.957836},
{0.750272,0.943912},
{0.73001,0.908514},
{0.832946,0.205017},
{0.850909,0.2051},
{0.569305,0.603012},
{0.221726,0.127892},
{0.208016,0.13545},
{0.828889,0.011441},
{0.836137,0.023124},
{0.071435,0.9838},
{0.080425,0.973751},
{0.077011,0.98805},
{0.069325,0.992698},
{0.071349,0.969014},
{0.653069,0.921783},
{0.875076,0.757346},
{0.87535,0.749496},
{0.943955,0.502491},
{0.935634,0.48428},
{0.925835,0.483687},
{0.652562,0.851695},
{0.252212,0.500274},
{0.238042,0.497819},
{0.255737,0.513343},
{0.265223,0.502201},
{0.789363,0.393014},
{0.725079,0.819552},
{0.807251,0.676003},
{0.07977,0.827127},
{0.519417,0.976018},
{0.09767,0.842072},
{0.15973,0.192861},
{0.875223,0.509959},
{0.543931,0.678446},
{0.85389,0.65337},
{0.850132,0.660723},
{0.263868,0.898935},
{0.265845,0.898623},
{0.264889,0.904007},
{0.847805,0.686932},
{0.377419,0.411673},
{0.403655,0.414252},
{0.416329,0.409768},
{0.201689,0.642398},
{0.215189,0.638425},
{0.220888,0.688304},
{0.599878,0.689815},
{0.609966,0.720264},
{0.183453,0.077502},
{0.686767,0.103482},
{0.942048,0.32255},
{0.962352,0.325163},
{0.928544,0.324598},
{0.603439,0.802213},
{0.991883,0.24969},
{0.922332,0.770024},
{0.917891,0.754545},
{0.929658,0.757446},
{0.96992,0.516926},
{0.989471,0.523869},
{0.092513,0.946401},
{0.089894,0.917282},
{0.07503,0.941143},
{0.071802,0.922576},
{0.109149,0.96171},
{0.237622,0.314805},
{0.226249,0.324838},
{0.617179,0.49649},
{0.626046,0.504514},
{0.978372,0.404931},
{0.966839,0.400517},
{0.59997,0.549846},
{0.620525,0.525335},
{0.955416,0.527854},
{0.787006,0.965619},
{0.46546,0.765998},
{0.910506,0.443216},
{0.757952,0.391397},
{0.751085,0.392287},
{0.755076,0.382764},
{0.978808,0.701913},
{0.975289,0.71176},
{0.87024,0.103283},
{0.763966,0.635292},
{0.763433,0.650108},
{0.762252,0.637609},
{0.759827,0.653301},
{0.760968,0.657788},
{0.125838,0.388461},
{0.979691,0.387152},
{0.769888,0.391951},
{0.771768,0.385009},
{0.7751,0.388306},
{0.791024,0.410243},
{0.728143,0.386265},
{0.726178,0.395903},
{0.724128,0.39352},
{0.726385,0.382345},
{0.764722,0.388338},
{0.764036,0.384023},
{0.767755,0.386134},
{0.764235,0.393605},
{0.108189,0.86243},
{0.104222,0.858151},
{0.102461,0.851642},
{0.707922,0.416272},
{0.815376,0.782207},
{0.738429,0.385311},
{0.741705,0.382683},
{0.741705,0.393498},
{0.739444,0.393653},
{0.09778,0.861045},
{0.092142,0.861017},
{0.096255,0.849561},
{0.088216,0.853498},
{0.323859,0.267761},
{0.828479,0.517653},
{0.822985,0.504737},
{0.472119,0.7437},
{0.47411,0.743386},
{0.473735,0.753912},
{0.472191,0.752791},
{0.10421,0.862222},
{0.102545,0.866726},
{0.949789,0.132409},
{0.952497,0.158214},
{0.132982,0.982142},
{0.135541,0.990703},
{0.258822,0.700797},
{0.261381,0.700329},
{0.26118,0.717188},
{0.258928,0.717276},
{0.091635,0.573078},
{0.885983,0.32478},
{0.849351,0.620976},
{0.84318,0.629041},
{0.840233,0.621757},
{0.838687,0.610342},
{0.630357,0.640053},
{0.631958,0.64051},
{0.276229,0.695164},
{0.755691,0.373514},
{0.742058,0.358977},
{0.766611,0.380002},
{0.336533,0.835067},
{0.245689,0.606931},
{0.960654,0.098451},
{0.953503,0.102945},
{0.950266,0.071041},
{0.990841,0.062324},
{0.980779,0.067709},
{0.983399,0.058325},
{0.827134,0.185382},
{0.914503,0.637265},
{0.920712,0.640091},
{0.907841,0.633045},
{0.94316,0.169111},
{0.935456,0.169283},
{0.688933,0.935436},
{0.924636,0.845846},
{0.577704,0.939111},
{0.576638,0.943515},
{0.575346,0.939837},
{0.973574,0.090004},
{0.973708,0.087173},
{0.24277,0.974219},
{0.245425,0.968836},
{0.167089,0.968247},
{0.172585,0.962116},
{0.182595,0.969419},
{0.17648,0.959314},
{0.185618,0.978413},
{0.92623,0.125162},
{0.233549,0.652374},
{0.932094,0.221163},
{0.254202,0.695931},
{0.259993,0.688894},
{0.258284,0.697459},
{0.992523,0.124472},
{0.972984,0.118656},
{0.975392,0.114599},
{0.936636,0.9842},
{0.138229,0.594568},
{0.009476,0.115245},
{0.623005,0.141092},
{0.619027,0.115747},
{0.289984,0.877847},
{0.463354,0.805403},
{0.458216,0.811006},
{0.129412,0.969607},
{0.721093,0.950009},
{0.72758,0.949179},
{0.725321,0.955749},
{0.798588,0.524999},
{0.906121,0.750082},
{0.910873,0.751732},
{0.91225,0.765833},
{0.90154,0.769656},
{0.265436,0.784968},
{0.26204,0.79075},
{0.26236,0.778382},
{0.266769,0.779524},
{0.004414,0.741537},
{0.009086,0.738724},
{0.737988,0.879017},
{0.731916,0.860526},
{0.580216,0.93725},
{0.460984,0.885332},
{0.469802,0.938831},
{0.457438,0.940894},
{0.641764,0.434606},
{0.544596,0.026746},
{0.900055,0.629474},
{0.376219,0.896454},
{0.360665,0.845294},
{0.292563,0.847439},
{0.318731,0.845928},
{0.918481,0.628558},
{0.275743,0.912419},
{0.616078,0.087359},
{0.270006,0.954028},
{0.376073,0.082392},
{0.349495,0.166953},
{0.383932,0.337518},
{0.133258,0.879847},
{0.136987,0.879677},
{0.136566,0.886028},
{0.02104,0.320914},
{0.810434,0.378071},
{0.822794,0.372667},
{0.818094,0.388167},
{0.162877,0.978392},
{0.836798,0.625009},
{0.727342,0.936893},
{0.720976,0.943482},
{0.723938,0.936141},
{0.983813,0.755173},
{0.981314,0.765614},
{0.976354,0.759715},
{0.072787,0.822344},
{0.071838,0.832425},
{0.24927,0.704083},
{0.252109,0.703139},
{0.251,0.712612},
{0.730742,0.388322},
{0.733872,0.384858},
{0.73195,0.394001},
{0.71534,0.234578},
{0.839187,0.227442},
{0.839077,0.218277},
{0.843996,0.219271},
{0.843813,0.225754},
{0.908919,0.35909},
{0.905722,0.367916},
{0.905512,0.356163}
};


// normal array: 18kb.
const tgx::fVec3 donkeykong_small_norm_array[1598] PROGMEM = {
{-0.683444859375566,-0.6409420696134039,-0.3494229351270453},
{-0.9391187309098838,-0.3429068393451168,-0.02170043281944892},
{-0.9033186943738221,-0.4184086590567997,0.09460195780777546},
{-0.9454282450907394,-0.02700080666114868,-0.32470970084722134},
{-0.9907641498478448,0.12069563270754427,-0.061797763888369814},
{-0.6727996636002522,-0.631999684000237,0.3845998077001442},
{-0.6180976944998993,-0.6408976094563751,0.45519830211349965},
{-0.8704798703857433,-0.4239901953400978,0.24999421895052937},
{-0.9090069630200053,0.09920075988073104,-0.4048031008036283},
{-0.9836973882869011,-0.17809952714638314,-0.024899933890763278},
{-0.6005713504270755,-0.7950620724684778,-0.08479595490545457},
{-0.8553279098050528,-0.24810809589925595,-0.45481484085038937},
{-0.9515426966787215,0.20240908229928872,-0.2315103881041766},
{-0.9703348793141167,0.18710672567213357,0.15310550347623547},
{-0.48439752715693574,-0.6732965628298201,0.5585971483688363},
{-0.7219105905060447,-0.07770113988408321,0.6876100873139719},
{-0.5636871424429195,-0.1556964486045105,-0.8111814971610721},
{-0.2568110508172801,0.4247182760206343,-0.868137356754209},
{-0.1546019742798174,-0.2527032270408141,-0.9551121968606313},
{-0.38939525719465096,-0.6763917615985153,-0.6251923852031221},
{-0.8079056755573062,-0.43230303693950184,-0.4005028135421478},
{-0.34552380913838127,-0.45853159620824263,0.818756418354827},
{-0.6568962885464545,0.23629866491631482,0.7159959546342844},
{-0.5273876170841246,0.278793454006549,0.8025811556156967},
{-0.22160084651685055,0.327201249911162,0.918603509072107},
{-0.07259935604656778,-0.42069626844064834,0.9042919789657197},
{0.15870514609779468,0.2561083044464097,0.9535309187413185},
{0.17879744947257475,0.20549706860522435,0.9621862745106905},
{0.07129889523217751,-0.5030922046466831,0.8612866544666828},
{0.4218008478205562,0.1757003531580648,0.8895017879003906},
{0.29659590107297057,-0.5837919320512482,0.7557895550605233},
{0.44781516327814724,-0.5062171408025863,0.7370249560875268},
{0.7108332500029214,0.07700360192772221,0.6991327026970209},
{0.5675195854388461,0.1737059946973173,0.8048277750857856},
{0.5683772852556831,0.358885657421296,0.7403704116877335},
{0.1473056581189946,0.46581789240887767,0.8725335146559592},
{0.418787047116946,0.45808583162433847,0.7840757489121235},
{-0.03869841068890884,0.3893840083271603,0.9202622056073076},
{0.2641864726779909,0.14139276016906857,0.9540511490615863},
{0.6700878547676975,0.12319776706070786,0.7319867328606993},
{0.16240126998289692,-0.015200118865394293,0.9866077153025007},
{0.24469550498485973,-0.27969486205257565,0.9283829457619279},
{0.9090776460555219,-0.09089776485144312,0.406590002074772},
{0.32419936456986814,-0.5767988694753238,0.7497985303963207},
{-0.13440484807030642,-0.5585201461850159,0.818529524892454},
{-0.358997418817838,-0.6996949692112568,0.6176955587848983},
{0.31251156626710525,-0.826730597865651,0.4678173142392059},
{-0.06549807765963063,0.9922708772771216,0.10539690664618423},
{-0.009399954081336469,0.9649952860095417,-0.2620987196508817},
{0.4856812603500971,0.7017729226141612,-0.5211798906618708},
{0.6570003744903202,0.03450001966501681,-0.753100429267367},
{0.015199723671535452,0.9653824495066005,-0.26039526605709423},
{0.25660356168215437,0.5048070067698813,-0.8242114401341841},
{-0.8297521080904416,-0.5573678296572815,-0.029198314721909976},
{-0.3888966049474582,-0.8078929471253573,-0.4427961344066199},
{-0.42040095641326375,-0.8827020081493528,-0.2100004777516303},
{-0.40320388287208825,-0.9147088086882418,-0.02710026097676982},
{-0.47532309651040283,-0.8708423152561725,0.12530608877078364},
{-0.21360699787987772,-0.9666316673721431,-0.14140463249164187},
{0.41720605370375924,0.9085131826219205,-0.023300338090358558},
{0.07660214603918236,0.8400235335889449,-0.5371150474888361},
{-0.11019409044938955,0.9378497044689877,-0.3290823517866978},
{-0.014000038080155368,0.9980027145710755,-0.06160016755268362},
{-0.0039001627571878567,-0.31271304978785713,-0.949839637635135},
{0.3326862586778721,-0.5825759371978608,-0.7415693701097383},
{0.42839545689026937,-0.7220923422513154,-0.5431942394556357},
{0.45418835248904865,-0.7358811285704335,-0.5021871215763986},
{0.27580087429015726,-0.9389029763271524,-0.2059006527061036},
{-0.008200041779319298,-0.5369027355264063,-0.8436042981748488},
{-0.035299591586088,-0.7580912289352214,-0.6511924657467566},
{-0.08090285875302194,-0.9454334074796904,-0.3156111523171041},
{0.13619596457335365,-0.9340723238470606,0.33009021957168905},
{-0.77528972360282,0.22309704286829504,-0.5908921677762238},
{-0.3220979595158897,-0.8274947578373136,-0.45989708656118494},
{-0.3660072305442598,0.013200260773727403,-0.9305183825722233},
{-0.47839215443300037,-0.45679250866428633,-0.7499877003025717},
{-0.7583946609203807,0.14959894682712152,-0.6343955338711623},
{-0.9426630766104196,0.010299596572703216,-0.3335869336557081},
{-0.9452269913421122,-0.3132089438090875,-0.09190262431690659},
{-0.789020554253161,-0.6037157269995352,0.11390296721094428},
{-0.48912814768916146,-0.805346344988922,0.3349192734841549},
{-0.23760647961704995,-0.9201250921533992,0.3113084894982645},
{-0.5100054060859569,-0.7322077614434072,0.4514047849160803},
{-0.9506794512857383,-0.23649488821823614,0.20069566201014796},
{-0.9979731548831957,-0.03639902087950734,-0.05219859587665613},
{-0.9623902943428221,0.0334996621576107,-0.2695972811251297},
{-0.19519924067643066,-0.011499955265261028,-0.9806961850992599},
{0.457395990941709,-0.620094564894958,0.6373944132624515},
{0.7536449449564787,-0.595635521783544,0.2779165740491048},
{0.5278867977162817,-0.5954851071037047,0.6055848545121806},
{0.3605044648754464,-0.6677082696181291,0.6513080665003558},
{0.8419284113536197,0.33911144350874506,0.41971416349342466},
{-0.579811004917311,0.0998018942579297,-0.8086153476649494},
{-0.048800844749934,-0.07050122038668742,-0.9963172464008041},
{-0.22329208331952638,0.7818722792097522,-0.5820793627420344},
{-0.688809832830546,0.585108352481348,-0.4280061098308271},
{-0.308804661441547,0.9511143571795833,0.004600069438572267},
{-0.9709362602917235,0.09810366374973539,-0.21830815287020625},
{0.4319893515937232,0.001299967956184815,0.9018777689869883},
{-0.5590130866495394,-0.828319391183924,0.037300873223663364},
{-0.650302441890254,0.5852021974383772,-0.48440181893224515},
{-0.513788180438862,0.5238879480963795,-0.6793843709423176},
{-0.5236887565230949,0.6226866310615451,-0.5813875177439896},
{-0.4106132096394346,0.7221232310780217,-0.556717909903247},
{-0.3529953440221183,0.7592899850311456,-0.5466927891696659},
{-0.3793220525285543,0.7980463957758669,-0.46822722118077803},
{-0.4272991689039248,0.6981986420049621,-0.5743988827952595},
{-0.49778210505497916,0.3190885289735714,-0.8064710078883902},
{-0.49611108572606716,0.08670193737643625,-0.8639193044925407},
{-0.7900218523066562,0.2148059416145187,-0.5742158830309899},
{-0.8150012510278805,0.4328006643495297,-0.3853005914368618},
{-0.7393912234782656,0.6462923285555898,-0.18869776017088008},
{-0.5553827250889999,0.7407769584910535,-0.37788824596891085},
{-0.30310991034053053,0.8218268700687825,-0.4824157728415438},
{-0.12899869195989525,0.8101917846969545,-0.5717942020361868},
{-0.1198989526872224,0.7784931998915983,-0.6160946184370117},
{-0.11479736313485285,0.8572803084974682,-0.5018884717542043},
{-0.32320089849974676,0.8852024608662619,-0.3346009301918789},
{-0.2834134567904002,0.9482450237426164,-0.14320679962027277},
{-0.35540108575197543,0.8963027382090478,-0.26520081018971264},
{-0.6290800616234152,0.6382797700432776,-0.4436859375970582},
{-0.7776010847542698,0.26040036325876015,-0.5723007983601707},
{-0.6133934949964781,0.04139956095998402,-0.7886916359695505},
{-0.693006649430702,0.6341060842770682,-0.3430032911323677},
{-0.7722117801805606,0.6353096917232713,-0.008400128144932283},
{-0.8870104623501055,0.4046047723414348,-0.2225026244339329},
{-0.8082896135451985,0.2215971524948855,-0.5454929904601086},
{-0.5993973746452486,0.49859781614634785,-0.6261972572620197},
{-0.4009927902144474,0.6913875689632641,-0.6009891943114286},
{-0.39289144488193056,0.8016825435526691,-0.45049019068289564},
{-0.08910160117015968,0.775513936110649,-0.6250112315527475},
{0.08259892745989036,0.8160894031478998,-0.5719925727246644},
{0.07629697145182615,0.7798690437127026,-0.62127533896487},
{0.11760013876824561,0.8722010291978216,-0.4748005602649916},
{0.004999814785291855,0.9634643091257405,-0.26779007990023174},
{-0.10180040669343711,0.9494037928757287,-0.2971011869216126},
{-0.3030066692501861,0.9507209255978611,-0.06570144610474332},
{-0.20959183236543596,0.96626234549008,0.14969416653199313},
{-0.23869432510987995,0.968076984243296,-0.07649818127735994},
{-0.21869653478085938,0.9657846972627068,0.13939779125949608},
{-0.5590205779262172,0.8217302484471782,-0.11070407509200758},
{-0.8412758641416817,0.44198731956569987,-0.3112910691873357},
{-0.9238335172880218,0.040801480304558664,-0.38061380891948593},
{-0.7749003835757848,-0.1230000608850452,-0.6200003069002278},
{-0.4715899835351234,0.8073828513703533,0.35459246853595155},
{0.23329551843613588,0.9586815839036582,0.16279687270211282},
{0.4236086395863074,0.6887140464662179,0.5884120007851353},
{0.22849600249740418,0.9256838053034881,0.3014947253959184},
{0.06209936565821968,0.7898919312951325,0.6100937679239907},
{0.5213078483487358,0.7084106652028476,0.47580716333076634},
{0.7840311227331376,0.6106242392102726,-0.11150442625605209},
{0.7261834831445116,0.6855844065600072,0.05129883322130742},
{0.19428685790997996,0.8485426022769377,0.4921667085089662},
{0.8209160162277164,0.2639051488396813,0.5064098801531436},
{0.35670670258191284,0.15530291816924885,0.9212173098358792},
{0.8414736033870861,0.42248674679862613,0.33678943508112963},
{0.8453402645157212,0.5273251170935049,0.08560407741931353},
{0.9957690619358609,0.06809788423160486,-0.061698083070338035},
{0.8213837367630166,0.4509910704652063,-0.34919308604534377},
{0.9733933517461113,0.044899693336141765,-0.22469846531472282},
{0.9915802627913018,0.10619788615211401,-0.07409852508353718},
{0.7439018374398076,-0.4527011181731428,0.4916012142564988},
{-0.39248326094587344,-0.7887663598321145,-0.47307982357577766},
{-0.8567981835897761,-0.5065989260114153,-0.09619979605664852},
{-0.5527209651038171,-0.8182310360918097,0.1581059970742057},
{-0.6010786590810572,-0.7991716259151238,0.005399808283210296},
{-0.8467747580206895,-0.1522954601399988,0.509684806522373},
{-0.9624688646358354,0.2488919484756981,0.10819649989984144},
{-0.6366149319783464,-0.2728063987491248,0.721316918686744},
{-0.8991320546291315,-0.029001033905288416,0.43671556918756727},
{-0.9389852204889434,-0.10419835993072195,0.32779484054981434},
{-0.9069082801103963,0.24070219762109646,0.34580315719723786},
{0.5343948030358106,0.14449859475799892,0.8327919011381419},
{0.2646020877187082,0.8095063870305906,0.5241041351979402},
{-0.8404796816492912,0.5350870644265743,0.08529793794727489},
{-0.6558939461268158,0.7097934486367035,0.2568976288458286},
{-0.8127066764127702,0.49720408454833187,0.3038024957477539},
{-0.7280280259783004,0.6835263128518796,0.05260202495392665},
{-0.6566116188453941,0.7524133140713898,0.05230092547306445},
{-0.78357281833039,0.5048824859303394,0.3620874394045868},
{-0.6903703285209065,0.20979098337729746,0.692370242566448},
{-0.42632895085039463,0.7215489984484159,0.5455370459509506},
{-0.4394008326653669,0.7633014464576116,0.47360089747455114},
{-0.863103064021316,0.49730176542440097,0.08800031240166355},
{-0.8452848484048873,0.4925911703824056,0.20699628962476238},
{-0.9368511960081328,0.2452872220949888,0.2492870137312707},
{-0.9374465922534813,0.3470172471857883,-0.027801381763011283},
{-0.7676707753298642,0.47418194823683935,-0.4310835889601464},
{-0.7310900645535335,0.6740908391677431,-0.10539856764319852},
{-0.6000854121009456,0.7818809927040983,-0.16899589175980637},
{-0.6435970748579422,0.765296521735213,-0.010199953641316052},
{-0.012000315312427307,0.9892259922544242,0.14590383367359533},
{0.03129983505030393,0.8482955294943395,0.5285972143000209},
{-0.9600808225771016,-0.05869882750263084,0.2734945370011846},
{0.0159008667798729,0.3144171393454113,0.9491517396715327},
{-0.6930083230799405,-0.1267015216944134,0.7097085236505539},
{-0.12340417359972791,-0.9416318465275835,0.3132105929613839},
{-0.538970882884557,-0.31238312395757994,0.7822577396671407},
{-0.2951864158337078,-0.8805594775852408,0.37078293696185244},
{0.4396953986117302,-0.5949937734227415,-0.6727929592585219},
{0.4451024525212701,0.4261023478304048,0.7876043397118677},
{0.2061040582288602,0.8354164495118379,0.5095100323513064},
{-0.796493265677908,0.055499530753451216,0.6020949093090626},
{-0.06129944401656414,-0.11569895061527685,0.9913910081243342},
{-0.7027892860590005,0.27809576046244744,0.6547900178022674},
{-0.7933849853312277,-0.06729872638365468,0.604988550700016},
{-0.5112121848876419,0.700816704165218,0.49751185833646683},
{-0.537611714686896,0.7925172691394439,0.2879062735460516},
{0.8726078622322582,-0.32010288413997917,0.36890332383392166},
{-0.11189495085426149,0.9919552390297355,-0.059197328780806795},
{-0.6511105936555389,-0.7020114218187502,0.2885046940095576},
{-0.8514928900640518,-0.5133957131636925,-0.10669910906615893},
{-0.5634023972823007,-0.817303477633696,0.12080051400728066},
{0.2595023744575895,-0.8897081408667337,0.37560343678716995},
{-0.6107635720930814,0.5503671743288016,-0.5692660471391474},
{-0.013700309767505804,0.9310210506239346,-0.36470824614666913},
{-0.20479430986914934,0.9656731691437379,0.15979556014204133},
{0.07289873047966296,0.2878949863524686,-0.9548833708508936},
{-0.010699625840626417,0.7891724031235858,-0.6140785260494096},
{-0.36647771333552465,0.8226499720631272,-0.4346735661308392},
{-0.23999644207911908,0.8376875813736585,-0.49059272701673257},
{0.06910311316537372,0.8465381374021543,-0.5278237789968778},
{0.25500284967276776,0.8823098598677763,-0.3956044209041056},
{0.5959999851000005,0.6928999826775006,-0.4057999898550004},
{-0.38949014797130904,-0.7652806424709699,-0.5124870368043539},
{-0.7422838369454238,-0.31489314327645695,-0.5914871205081749},
{-0.804404810355149,-0.1842011015258807,-0.5648033775342965},
{-0.421788481113869,-0.6116832951573108,0.669281722165748},
{-0.17240057840491083,-0.45680153257171263,0.8727029279232348},
{0.23629749171543807,-0.872490738559965,-0.42769546003678743},
{-0.07369967977558707,-0.9943956793601598,0.07579967065114654},
{-0.5022054615140912,-0.6075066066702716,0.615406692584173},
{0.05159939474264948,-0.9818884825156498,0.18229786165862402},
{-0.48781141248149407,-0.7559176849011098,0.43661021461545774},
{0.3666019283312145,-0.6124032212494157,-0.7004036841330679},
{0.5683806725438396,-0.469184045667786,-0.6758770171927888},
{0.21240008283604847,-0.41110016032909386,-0.8865003457352023},
{0.30199684414946787,-0.3312965379692672,-0.8938906588914217},
{0.7752153494158791,-0.32940652231371337,-0.5390106725169749},
{-0.03840010732844997,-0.9759027276519356,-0.21480060036851703},
{0.09920330749340867,-0.9228307676907008,0.37221240976861597},
{0.26510094641206805,-0.8934031894550796,0.36270129484593394},
{-0.1259955089701227,-0.9826649735312667,0.1359951525391801},
{0.04639851805499961,-0.9963681765086554,0.07139771959325372},
{0.5677045019145504,0.21260168593805429,0.7953063068040196},
{0.7773872276327741,0.06269896986438762,0.6258897167164308},
{0.7425102095855732,0.4295059057468063,0.5140070676457705},
{0.9509388656656759,0.274811231764568,0.14210580798306083},
{0.9069022808621044,-0.22600056839214425,0.35560089433737385},
{0.9778124182965691,-0.18800238764548474,0.09240117350235526},
{0.7144810307804458,-0.665382334333532,0.21629425746369546},
{0.8569346122879995,-0.511920676893718,0.060002423546831565},
{0.918925937050615,-0.34850983682896863,-0.18470521337822243},
{0.6675918020230065,-0.7297910382210757,0.14739818996134085},
{0.025201193052719343,-0.9962471634571035,0.08280392003036356},
{0.26179488850470245,-0.9108822151983708,0.31899377170741056},
{0.8639557579584234,-0.4950746478764067,0.0920952839212625},
{0.5996962279225896,-0.5659964398935895,0.5656964417805718},
{0.33829539583099383,-0.8992877607768631,0.27719622738501776},
{-0.3023930858611368,-0.8980794656477743,0.3193926971694679},
{0.20799263511118377,-0.9118677113360023,-0.3538874690665766},
{0.8379850295311699,-0.5456902513307392,-0.0017999678438617016},
{0.9297100130307608,-0.14010150890137635,-0.3406036683212619},
{-0.5189891714039069,-0.6987854199943162,0.4922897284819718},
{0.1765000397125134,-0.9843002214675748,-0.0009000002025000683},
{-0.17279509873653554,-0.9739723736654259,-0.14669583903153796},
{-0.5062785064022564,-0.8338645990299064,0.21989066473998853},
{0.1856076128523649,-0.9730399100503829,0.1369056152989696},
{-0.03179923460163459,-0.5402869954485274,0.8408797602677525},
{-0.6963073425996418,-0.6961073404906084,0.17490184434967304},
{-0.37370406405379497,-0.8700094614043394,0.32160349745705236},
{-0.46091607011893193,-0.8339290754440818,0.3035105820809196},
{-0.6822016986843447,-0.717301786083671,0.14170035283431784},
{-0.5002971908391601,-0.7904955613798842,0.3532980162372082},
{-0.1579022888102646,-0.7894114426017914,0.593208598620956},
{-0.22359459578392904,-0.9222777088171635,0.31529237947528105},
{-0.4686717165153367,0.7373555019381466,0.4864706423825716},
{-0.34100778018125827,0.20640470917716042,0.9171209243525864},
{-0.7928326019469019,-0.323613307252797,0.5164212356778256},
{-0.8368453808844263,0.1837880045484019,0.5156663435560983},
{-0.3911028413724639,-0.5801042144724272,0.7145051908990679},
{-0.2952093021916704,-0.6037190234861498,0.7405233342578995},
{-0.3998046517541849,-0.5262061224438521,0.7505087322198993},
{-0.6823066491106935,-0.3039029615487905,0.664906479545215},
{-0.19520807299679163,0.4788198020023762,0.8559353979403379},
{-0.36220045275084894,0.5495006868762878,0.7529009411267646},
{-0.09490202238364571,0.48091024830658824,0.8716185743897324},
{0.016500261118698324,0.5609088764532053,0.8277130986634303},
{-0.15689971287378818,0.6380988322802054,0.7537986205497866},
{-0.29999692204736955,0.5783940657073285,0.758592216883782},
{-0.5930398832732703,0.5669381278711921,0.5717384507037583},
{-0.6585224592914677,0.5165176161337024,0.5473186666214431},
{-0.2971937560247782,0.8196827786457291,0.48968971172723386},
{-0.024499577385935112,0.8576852050578181,0.5135911406292356},
{0.19710089582560728,0.510302319329312,0.8371038046454381},
{0.11609662976375622,0.48338596750904184,0.8676748117658164},
{0.1691999822340028,0.6333999334930105,0.7550999207145125},
{0.0247998202019553,0.5138962742655173,0.8574937831926077},
{-0.2293026392885674,0.23600271640689885,0.9443108690806551},
{-0.6015970642134899,0.2567987468251732,0.7563963087950195},
{-0.8860744326911119,0.1032970194075069,0.4518869609898583},
{0.47438436454901245,-0.22159269642508675,-0.8519719194682939},
{-0.004800156847687539,-0.5331174198962974,-0.8460276444049288},
{-0.15840095674466811,-0.7406044732645278,-0.6530039441557342},
{-0.13350258129736434,-0.2178042112851382,-0.9668186936201635},
{-0.15849310411505665,-0.985057141096166,-0.06739706761738057},
{-0.4407996738083621,-0.8971993360727369,0.026999980020022178},
{-0.32439849479447624,-0.9123957664934651,-0.2495988418640606},
{0.0042997651317443425,-0.9339489844300503,-0.3573804786245181},
{-0.20769207150650248,-0.8708667552961629,-0.44548299401129926},
{-0.3741973506921356,-0.7175949194459554,-0.5873958412521659},
{-0.618760542898229,-0.7152543896818087,-0.3248792831086532},
{-0.8260990169427547,-0.5633993295551968,-0.011899985839025278},
{-0.6217838804618457,-0.7418807669904204,0.2509934930780368},
{-0.33820636341259197,-0.8512160157800067,0.4013075506725995},
{-0.110397389684581,-0.9642771999351581,0.24079430648593392},
{-0.8856779380373417,-0.37929055199002343,0.2677933293512477},
{-0.6950472752481937,-0.4939335960360905,0.5224355346613762},
{-0.14769946015945967,-0.7470972693644707,0.648097631207487},
{-0.2199893692705888,-0.8806574432573071,0.41957972429972296},
{0.2526977623712212,-0.8840921713984833,0.3930965191457344},
{0.2476969112387752,-0.8437894780108135,-0.4760940631440488},
{0.5139880087996305,-0.8270807044322458,0.2274946926107314},
{0.6069893535001085,-0.7847862349701569,-0.12519780404977526},
{0.3753000487890095,-0.7193000935090182,-0.5846000759980148},
{0.7697121846403251,-0.6239098765715198,-0.13520214026682076},
{0.5061077485689464,-0.4364066814374396,-0.7439113893705576},
{0.33209311578106404,-0.3710923073362025,-0.8671820235029772},
{0.8083552143199916,-0.05229710255929683,-0.5863675132078712},
{0.626172971826994,0.04699797137634737,-0.7782664068555565},
{0.5828282795141997,0.48142335922809837,-0.6546317635037665},
{0.9581962199233685,-0.06069976053991699,-0.27959889698452706},
{0.004999846682052206,-0.8536738224935937,-0.5207840304025578},
{-0.757708903131918,-0.6511076505598413,0.0440005170091123},
{-0.45787778201967816,-0.2579874814611858,-0.8507587179347941},
{-0.9651727342553804,0.016499533894751117,-0.2610926242375465},
{-0.43222079032003363,0.075003607760302,-0.898643225778765},
{0.28870611630386156,0.08630182832359976,-0.9535202005394249},
{-0.5034841832928189,-0.3246898000301456,-0.8006748471947569},
{0.5777091885377161,-0.20410324628794851,-0.7903125700213901},
{0.023301182681541268,-0.8522432567042689,-0.5226265265825522},
{-0.43749218208455865,-0.7774861064474156,-0.4517919265504082},
{-0.8593351174471263,-0.5053206503503235,0.07870321627265082},
{0.013700307780871486,0.7383165864684246,0.6743151486599739},
{0.0020998953123287406,0.9986502135346254,0.05189741271898173},
{-0.3038952987760916,0.9381854863827876,0.16569743668048167},
{0.0005999920141594368,0.7950894174302805,0.6064919276461641},
{-0.013700307780871486,0.7383165864684246,0.6743151486599739},
{0.5112121848876419,0.700816704165218,0.49751185833646683},
{0.3048008945919385,0.9385027545096267,0.16220047605909588},
{0.11179620570116665,0.9919663332339653,-0.05919799085428503},
{0.537611714686896,0.7925172691394439,0.2879062735460516},
{-0.20609355658567843,0.8353738824438417,0.5095840681031623},
{-0.26448767251686933,0.8095622671820696,0.524075573406772},
{-0.4450222583448906,0.4261213129904671,0.7876393947695187},
{-0.5344025223858585,0.14440068157282554,0.8328039308438304},
{-0.6326085118047898,0.7188096716491984,0.28830387915479117},
{-0.8498958652666733,0.4453978331448127,0.2815986300259974},
{-0.665783858266032,0.7458819163121558,0.01979951996645755},
{-0.6300261938835273,0.7463310293575817,0.2146089225514365},
{0.8024028485351684,-0.41330146722281297,-0.4305015282831381},
{0.9252680880539551,0.169194164593893,-0.3394882912507487},
{0.9718176435094784,0.20510372369190577,0.11620210966845172},
{-0.898963750017656,0.26218942742450435,0.35088585081334317},
{-0.2992822785245502,0.10249393100155829,0.9486438277188132},
{-0.2221962404714166,0.005999898482576506,0.9749835034186821},
{-0.8606889057915059,-0.25269674275997855,0.44199430273015644},
{-0.258011382423209,-0.27411209272171155,0.9264408708405456},
{0.2653086306301339,-0.2874093495782151,0.9203299388198727},
{0.22219936895468828,0.0027999920480338758,0.974997231011796},
{0.3137962517261596,0.10569873743612195,0.9435887288999496},
{-0.5496063205090289,-0.14800170202936005,0.8222094554631071},
{-0.360387492969081,-0.4897830023758487,0.7938724491347209},
{-0.09680116065287438,-0.5467065550508928,0.8317099722623514},
{0.05260202495392665,-0.09550367648479079,0.9940382662396026},
{0.23620567845276583,0.2078049956921454,0.9492228195908777},
{0.3462036334261993,-0.4816050544715701,0.8051084496575189},
{0.16640321078092832,0.3158060935373628,0.9341180239811607},
{0.10930148978945882,0.18880257339661322,0.9759133017889557},
{-0.03349930891638551,-0.7549844248319718,0.6548864898310707},
{-0.11139671607321452,0.19139435777749783,0.9751712523752136},
{-0.15049710295865182,-0.015999692008893215,0.9884809719244341},
{0.32670830829792136,0.07650194546921024,0.9420239559738044},
{0.793501963919791,-0.06760016731062113,0.6048014968855572},
{0.6767162853733635,-0.6713161554176725,0.3023072751121144},
{0.32618076079521996,-0.5942649483157549,0.7351566380645178},
{-0.0030999633276507493,-0.681091942729976,0.7321913382277028},
{0.11090110735308539,-0.9381093670687954,0.32810327612756823},
{-0.3310942025912684,0.0765986587692273,0.9404835322775233},
{0.15229840848994688,-0.02199977010360362,0.9880896745168517},
{-0.013099757001761405,-0.6489879613849735,0.760685889407626},
{-0.8969999820600005,0.4419999911600002,-0.005199999896000003},
{-0.9804766404223096,0.020199518752198525,0.19559533999653622},
{-0.7198857967933424,0.5951882570515313,-0.3570929546255071},
{-0.8778468168191448,0.4323230564034134,0.20611099219232823},
{-0.8747138512035015,0.43820693906182046,0.20700327792285905},
{-0.9961263877375214,-0.045901215939315565,-0.07500198682894699},
{-0.891056918439465,0.1792913314736798,-0.4169798395121276},
{-0.5820869788599227,0.4827892001263884,-0.6542853638001158},
{-0.9581962199233685,-0.06069976053991699,-0.27959889698452706},
{-0.801684022596643,-0.32389354486597566,-0.5023899874673237},
{-0.626172971826994,0.04699797137634737,-0.7782664068555565},
{0.23090095939547944,-0.310201288889033,0.9222038317648815},
{-0.277402245580267,-0.2988024188153705,0.913107391634253},
{-0.6922208050089464,-0.6569197440196142,-0.2988089808388807},
{-0.7498218801216976,-0.5324155361120189,0.3928114624057119},
{-0.7869611959001216,-0.6138697308298406,-0.062096938075473375},
{-0.6067205378378145,-0.7871266446878916,-0.11100375754079021},
{-0.530100564557402,-0.8219008753248983,0.20850022205285473},
{-0.5265889285841636,-0.7299846522340286,-0.4356908396963921},
{-0.8698750088499885,-0.492785842466116,-0.021899370840113515},
{-0.7697121846403251,-0.6239098765715198,-0.13520214026682076},
{-0.9123119559265241,-0.30530400103515054,0.2729035764248037},
{-0.3320041417775032,-0.3711046295591308,-0.8672108185224421},
{-0.8083205558531064,-0.05230133003973458,-0.5864149127208482},
{-0.9121644582043156,-0.28028907874881565,0.2989883501459004},
{-0.8576734725697339,-0.1423955957723331,0.49408471819599564},
{-0.8316169901086636,0.3077062865036505,0.4623094450784454},
{-0.8069608431751043,0.006299694314749884,0.5905713432208384},
{-0.7066003780313034,0.49760026621621367,0.503100269158716},
{-0.0028999511217357612,-0.6462891068889043,0.7630871382746757},
{0.3064078242236886,-0.602915395641194,0.7366188098014655},
{0.3840850574615035,-0.5829773197085564,0.7159721456454998},
{0.1346010996954768,-0.7601062100931048,0.6357051937326493},
{-0.11809615308046907,-0.28149083058553803,0.9522689803431897},
{0.12340099893512958,-0.11890096250718726,0.98520797529084},
{0.33840539930121905,-0.83321329402416,0.4373069772884844},
{-0.2505062301674174,0.5049125573314532,0.8260205433863742},
{0.20699905815642805,0.5278975980713931,0.8236962521905787},
{0.5531096601445723,-0.24550428776982913,0.7961139042507576},
{0.6831202992212915,-0.16500490319354869,0.711421140193276},
{0.3932713433612758,0.6441530622764655,0.6560521952182382},
{0.07269693879635956,0.5816755061601425,0.8101658846328821},
{0.28690929314250974,0.5269170671202105,0.8000259132590024},
{0.15430030088588007,0.16350031882593255,0.9744019000855577},
{0.6586707095648039,0.20179102655256936,0.7248677658471632},
{0.3115907396608239,0.13779590476656461,0.940172058501626},
{0.3244945209562701,-0.3013949109898916,0.8965848612924247},
{0.8163253513774367,-0.15780490070728836,0.5556172549617834},
{-0.9148226467149326,-0.3404084269149137,0.21730537946125367},
{-0.7339265649527864,-0.5448197201066604,0.40561468148909957},
{-0.9906355545480906,-0.11810423883719916,0.06850245859735939},
{-0.9981589665283118,-0.057697628099262266,0.018699231290402157},
{-0.6165866202155105,-0.21279538239030263,-0.7579835519353826},
{-0.3330049335046351,-0.7589112433533561,-0.5596082906582396},
{-0.046301709259146534,-0.7482276213324716,-0.6618244316998527},
{-0.13900498897858327,-0.7871282505398769,-0.6009215674620912},
{0.2242927005128408,-0.8025738806580742,-0.552782010002222},
{0.35860314496337203,-0.7323064223554862,-0.5789050770197882},
{0.6498090843945001,-0.6608092381777251,-0.37560525099811365},
{0.42758964817992484,-0.9020781609520819,-0.05849858376643032},
{0.7516935542554083,-0.5124956053690258,0.4150964405632832},
{-0.28940785174152805,0.6087165147030689,0.7387200417466026},
{-0.11229932564457425,0.6173962925463948,0.7785953245491141},
{-0.9137963037014272,0.1616993459274686,0.37259849284214464},
{-0.6033907893099013,0.22989649065685497,-0.7635883439128945},
{-0.7837423467430227,0.6105329879885357,-0.11400615991923517},
{-0.9356690953601619,0.224092598343713,-0.2725909964680775},
{-0.9877214831758911,0.15360334090899755,-0.028500619895224157},
{-0.23920105966304148,0.5735025406218824,0.7835034709280644},
{-0.508386708403261,0.5012868940254813,0.700181693988913},
{-0.94503987679892,0.19690830872138343,0.2610110135920827},
{-0.8778611730589545,0.15429317576375062,0.4533799474483768},
{0.891861164751103,0.4521803102370768,-0.010799529744715678},
{0.8282683193426662,-0.5564787150962136,0.06559749094395619},
{0.39070944551501935,-0.4190101296923294,0.819619814548528},
{0.34040812563893963,-0.08830210779646995,0.9361223455070841},
{0.007599946002575477,-0.1306990713863967,0.9913929561780694},
{-0.11499902136249229,-0.4810959058912612,0.869092604053409},
{-0.10739681787942866,-0.5652832509054099,0.8178757667000437},
{-0.20430169775416254,-0.13170109444064224,0.9700080608004781},
{-0.020600664485149627,0.04370140961170091,0.9988322178527886},
{0.2907083245520621,0.12180348789281445,0.9490271757822734},
{-0.15260292924134047,-0.8613165331295317,0.48460930216483344},
{-0.006399905666085719,-0.86738721480668,-0.4975926655381646},
{-0.35880483672179875,-0.9334125824864185,-0.00020000269605451436},
{-0.08979945761291404,-0.8601948044390718,-0.5019969679474704},
{-0.693399691437206,-0.3382998494566005,-0.636199716891189},
{-0.08439842345217473,0.18139661154294426,-0.9797816978488246},
{0.4428889146291985,-0.2608934699181709,-0.857778530072085},
{0.2840088328120528,-0.7924246447896854,-0.5398167885631905},
{-0.31569388506866874,-0.6539873323880563,-0.6874866835119093},
{-0.2195124192664399,-0.06480366637114035,-0.9734550747788274},
{-0.6287109459528544,0.534309302405933,-0.5650098369068915},
{0.2900032915560388,-0.517705875995039,-0.8049091357705368},
{-0.3195960482192955,-0.13359834806663917,-0.9380884006086393},
{0.2765073524282529,0.305608126228116,-0.9111242271153027},
{-0.4333017440430296,0.6805027390290368,-0.5909023783868594},
{-0.06170009224170685,-0.8866013254699724,-0.45840068530953676},
{-0.13060203348949226,-0.9903154193311193,0.04710073336412777},
{0.07879712395746237,-0.9929637574842657,-0.08839677357664562},
{-0.3857907623507919,-0.7576818575251297,-0.5263873958047093},
{-0.06550104966273133,-0.9563153250758776,0.28490456563224664},
{0.04829767138390999,-0.8626584079275185,0.5034757255030782},
{-0.12140209723934488,-0.9307160782591292,0.34500596002943973},
{0.11280229555007189,-0.993520218342167,0.013900282873634744},
{-0.13059564601374166,-0.8305723091808103,-0.5413819506266442},
{0.27741024494952243,-0.5847215941672163,-0.7623281532985616},
{-0.0012000253868055895,-0.5235110749939385,0.8520180246319686},
{-0.22799885772858416,-0.49389752557959526,0.8390957961405919},
{0.6289057073451914,-0.3858035011826599,0.6750061257083864},
{0.8556300416981554,-0.4321151718300291,0.28491000336583033},
{0.252702837868804,-0.7659086012018875,0.5912066392878389},
{-0.2084924016328812,-0.8459691692154317,0.4907821137717895},
{0.35948934848840414,-0.9074731119700327,0.21739355872428112},
{-0.2811970685358407,-0.944990148529052,0.16709825800974032},
{0.3142934957634071,0.8850816834240903,-0.3432928956270367},
{-0.35220237209096406,0.8980060480911009,0.26370177603744244},
{-0.592995407268356,-0.27799784691501345,-0.7556941471714952},
{-0.07080314231318534,0.14260632900932527,-0.9872438148527763},
{-0.2544057229211064,0.40670914902521216,-0.8774197377790045},
{0.27049629152126475,-0.059399185642747224,-0.9608868263319159},
{0.6103157127802908,0.62091598568783,-0.4919126644545717},
{-0.04590176197295065,-0.0039001497101199896,-0.9989383449843225},
{0.8091934900645584,-0.41809663642608985,-0.4127966790640753},
{0.7518011690517269,-0.4561007092371543,-0.4762007404927272},
{0.7980124730324311,0.42150658819946074,-0.43070673199883214},
{0.8577933521272815,0.4578964513162534,-0.23349819039603664},
{0.46298675645324483,-0.44098738573624396,-0.7688780065591792},
{0.1830999761970047,-0.13629998228100348,-0.9735998734320248},
{-0.90997326082859,-0.1040969411563255,-0.4013882053808747},
{-0.9912725470869573,0.005899836606287752,0.13169635272001645},
{-0.9334809105105683,0.13239729250305218,0.3332931842240732},
{0.3621874033411639,0.2373917436587308,-0.9013686509434707},
{-0.07719975527716366,0.539098291061126,-0.8386973413336419},
{0.5486958601053532,0.5583957869196815,-0.6221953055541293},
{0.698990249154036,0.32129551795878647,-0.638891087531493},
{0.34639431744783294,-0.8640858247883154,-0.3651940090414221},
{0.3898067749006222,-0.8358145265827092,0.38660671928317225},
{-0.4777866006626739,-0.7033802739768205,-0.5262852405373907},
{-0.7186105349076631,0.2974043599798762,-0.6286092154786489},
{-0.014699585918496932,0.6199825353379659,-0.7844779015687648},
{0.19340712041420946,-0.38591420769308915,-0.9020332089638932},
{0.15120471085615123,0.1435044709514398,-0.9780304710139941},
{0.08360088199395757,-0.9313098253704868,-0.35450374003418617},
{-0.18970034335793223,-0.7998014476419304,-0.5695010307977987},
{0.04819782223060265,0.9492571087865372,0.3107859574537615},
{0.6109171975611705,0.7885221972122817,0.07080199310415922},
{0.0792002229489414,0.9442026579342231,-0.3197008999593},
{-0.5705762274367155,0.5708762149379966,-0.5903754025212703},
{-0.5154135220511289,-0.3579093898760167,-0.7786204273748718},
{-0.4194155836755226,-0.8442313679992278,-0.3337123993145491},
{0.13169235284709882,-0.9184466673504955,-0.3729783417765213},
{-0.17830321394439727,0.9255166825885569,-0.3341060223153289},
{0.13389819104765835,0.9909866118613101,0.004099944610122475},
{0.047398289663575684,0.9020674494833676,0.42898452037286855},
{0.21510585310989577,0.8701236763873561,0.44341206540645184},
{0.11160038111595227,0.8065027542116084,-0.5806019827591566},
{0.19340073782522219,0.9785037329988621,-0.07160027315556312},
{0.2792958022156388,0.7970880198570918,-0.5353919531194165},
{0.12319843723773538,0.16369792350501042,-0.9787875841582419},
{0.7740273971845936,-0.5995212204291522,-0.20360720680462951},
{0.40238127964643655,-0.3964815541247816,-0.8251616102491041},
{-0.707084490271807,-0.061098659815595265,0.7044845473009307},
{-0.5083170238221965,-0.4053135741789027,0.7598254469803362},
{-0.2382047153090098,-0.8561169470027006,0.45860907825655706},
{0.1909924320748156,-0.981461110373987,-0.015999366037680887},
{0.053799769737478284,-0.576397533023838,0.815396510110405},
{-0.23689305795065366,-0.4815858873323546,0.8437752735279086},
{-0.3450069950877388,0.06820138279705446,0.9361189800047314},
{-0.7870893783005094,0.259296500817332,0.5596924470013912},
{0.9170944928641055,0.17419895393842239,0.35859784662639643},
{0.8378112686373452,0.030500410233276473,0.5451073317429183},
{0.9801722811198293,-0.18839467227400108,-0.06139826368165428},
{0.9886355519736849,-0.03740134497654847,-0.14560523605843467},
{0.972177231875841,-0.09299782201651226,0.2149949648768832},
{-0.25129935416148974,-0.5768985173727156,0.7771980026037001},
{-0.5856981872669156,-0.3128990315789959,0.7476976858792432},
{-0.7314990709967698,-0.09979987325424144,0.6744991433866319},
{0.1488925592802703,0.209289541016525,0.9664517027829499},
{-0.8654896358236662,0.336695968089923,0.37089555855227935},
{0.022899993015503196,0.42179987135105884,0.9063997235481265},
{-0.03799883630345704,0.6868789646538063,0.7257777733960294},
{-0.6878975304522984,0.7068974622426658,0.16459940908918205},
{-0.1827014351254094,0.899007061728205,0.39800312632683604},
{0.05700286446591093,-0.7189361274481292,0.692734810798886},
{-0.09020069590105333,-0.884206821681944,0.4583035358254184},
{-0.0023999958480107743,-0.7756986580424823,0.6310989081998332},
{0.10789964069479473,-0.8540971558612065,0.508798305704463},
{-0.0673993617310666,-0.7082932924942801,0.7026933455255268},
{-0.06560159643427409,-0.8966218195574716,0.4379106566854973},
{0.006900133794891437,-0.8575166274086098,0.5144099745061094},
{0.08640008812813485,-0.9020009200414077,0.42300043146066013},
{-0.1301034471364984,0.5374142389788951,-0.8332220765113796},
{-0.002200031064657951,0.6686094408319573,-0.7436104998543874},
{0.10970325055547166,0.8108240250717995,-0.5749170350441262},
{0.3105907926724248,0.7861766941373483,-0.5342841613808003},
{0.32268808173579755,0.7576720159008795,-0.5672790479352896},
{-0.7744526320533464,0.536167206335706,0.3357794626772288},
{-0.8887021417747425,0.4530010917339466,0.07070017038761595},
{-0.944675736315315,0.2971923667120902,0.13879643505934766},
{-0.9702061268710368,0.105300664975799,-0.21820137794605263},
{-0.5588140347907278,0.03080077357114248,0.828720813584603},
{-0.30100712642807825,0.2606061699241103,0.9173217178487582},
{-0.7311919861797469,0.28279690056295465,0.6207931961438552},
{-0.863907006314232,-0.057100463086633454,0.5004040582933692},
{-0.5273120914048854,-0.34580792946673505,0.7761177965851159},
{-0.6884002030780898,-0.53580015806107,0.48890014422556377},
{-0.22141017956701378,-0.7665352422679135,0.6028277156413546},
{-0.03420127077182373,-0.503818719732304,0.8631320702678672},
{0.13010594532701067,-0.773235333795885,0.620628360260898},
{-0.124102078106697,-0.18370307613376502,0.9751163284596313},
{0.2987166046239649,-0.5117284452162131,0.8055447774509665},
{0.33860014898409835,-0.2504001101760727,0.9070003990802634},
{0.10909678278331289,0.06239815990539619,0.9920707442651212},
{0.45270903163527265,-0.008500169580074702,0.8916177879523063},
{0.13719816567278734,0.2760963086170305,0.9512872813740714},
{-0.35889431157024204,-0.4959921385869046,0.7906874677029545},
{0.21500087075528987,-0.3501014179136139,0.9117036924074314},
{0.42591927967255144,-0.7421335934374276,0.5175234262280943},
{0.15990047890265147,-0.9766029249301403,0.14380043068293485},
{0.041300943737346725,-0.9806224074780192,0.1915043759249854},
{0.06030091959603581,-0.99791521832312,0.02300035075802361},
{-0.0638974614042866,-0.23759056071453047,0.9692614920058686},
{-0.44141079483298307,-0.40870999512514766,0.7988195353706091},
{0.6459839119710061,-0.7614810355509615,0.053398670122680694},
{0.6718399958254627,-0.7333436572474126,-0.10410619762642255},
{0.9318976003667687,-0.3622990670811035,0.017499954937674058},
{0.7216070068380548,-0.6901067009685998,-0.05510053502879271},
{0.7252667472819381,-0.6255713182125748,-0.28748681903151413},
{0.779006551472647,-0.5283044430590492,-0.3377028400928278},
{0.9095562468490928,0.1622921931218203,-0.3825815963549504},
{0.6843015978460965,-0.2878006720153537,-0.6700015644554795},
{0.696491972976267,0.38459556756162566,-0.6057930182756963},
{0.4883106379631233,0.39230854653478037,-0.77951698196243},
{0.304209544724201,-0.03310103856137755,-0.9520298704057834},
{0.5511178069040162,0.0009000290804093895,-0.8344269607706607},
{0.15089678065152687,-0.1434969385254745,-0.9780791329042969},
{0.22140090663856904,0.44290181368664056,-0.8688035577578536},
{-0.14820304115760713,0.28360581965112946,-0.9474194412464035},
{0.07790008958515453,0.4820005543009562,-0.8727010036067313},
{0.3560889738756333,0.5595826727908014,-0.7483768268703284},
{-0.09190024859050865,0.477701292183743,-0.8737023633680894},
{-0.3346981357365759,0.3512980432753484,-0.8743951296326918},
{-0.007400209946934334,-0.02210062700368227,-0.9997283626959803},
{-0.8992281282957866,0.2384074575019078,-0.3668114740423649},
{-0.615384997096654,0.3885905262784526,-0.6857832808074183},
{-0.3005887491736736,0.7234729209153455,0.6214767385610053},
{0.013099975765067252,0.9599982240049283,0.2796994825564359},
{-0.10829689679688279,0.955872609862791,0.2730921746558513},
{-0.17339376487232078,0.9205668970095646,0.34998741467884814},
{0.109802597411163,0.9367221584247394,0.33240786320100707},
{-0.2949103205672555,0.9200321970901156,0.25800902918396723},
{-0.7316853261979233,0.4800903718841369,0.48389029567742936},
{-0.3673847152768748,0.9013624995932905,0.22929046056882796},
{-0.858529817258339,0.5027174596805674,0.10100350791274577},
{-0.7347657276519317,0.562373768687325,0.37928230878930014},
{-0.16590266607726595,-0.38160613245982333,0.9093146128032426},
{0.5332900862294446,0.5297901512926304,0.6594877402368624},
{-0.18300212558203302,0.45090523729474696,0.8736101470407871},
{-0.6224997852376113,0.7311997477361306,0.27899990374504985},
{-0.2751054127522444,0.9380184556946756,0.21080414761240682},
{-0.16380765245323073,0.9237431536694091,0.3462161738663521},
{-0.681953584408862,0.7257506034662052,-0.09069382713472696},
{-0.8941989761427585,0.39909954303128486,-0.20279976779439882},
{-0.9523200084535687,0.24900523165487617,-0.17630370417973765},
{-0.749998376255273,-0.12919972028290838,0.6486985955690608},
{-0.04449897764773268,0.5658869988955488,0.8232810853343442},
{-0.04710186008918311,-0.20060792216327242,0.9785386432540483},
{-0.025199831665686713,-0.7413950474976241,0.6705955204368853},
{-0.513715111152245,-0.8352245684920285,0.19620577147765325},
{-0.29030342995528746,-0.4828057043830961,0.8262097617260025},
{0.3932098755900397,-0.8183205523787628,0.41921052860464053},
{0.44671389748552953,-0.14080438049241675,0.883527486967686},
{-0.7898853951540642,0.07709857446053721,0.6083887509959902},
{-0.5909204875684622,-0.7612263921765331,0.2671092608386127},
{-0.5969248266198194,0.45611897038247556,0.6600274511125496},
{-0.11889647477178376,-0.9184727676861513,0.37718881651738295},
{-0.8561052693441493,-0.13520083216368295,-0.49880307014234515},
{-0.8642505082755986,-0.3858225481285882,-0.32281886608581717},
{-0.5341095446228443,-0.034400614744478274,-0.8447150951936279},
{-0.26178530771189545,-0.5784675344206704,-0.7725566414752117},
{0.21089063560923402,-0.16339274470625337,-0.9637572053114261},
{0.6032160910038441,0.4120109905397609,-0.6829182170864144},
{0.7348043500546285,0.07240042861180608,-0.6744039924834533},
{0.5955235980901208,-0.41051626702937793,-0.6905273626888806},
{0.9487812854737143,-0.09149819521589889,-0.30239403533647896},
{0.7164120322411232,-0.6344106550164272,-0.2903048757113317},
{-0.6784942158614646,-0.5901949686093388,-0.4373962712126819},
{-0.28888319037621374,-0.9385453876327942,-0.18888900886835164},
{-0.49890108261652394,-0.8497018438550018,-0.170600370203205},
{-0.9314810585252603,-0.22109550406863665,-0.28889412539768944},
{-0.6820073623092144,-0.7196077682077869,-0.13050140877031155},
{0.8411823816195235,-0.5361887696438286,-0.07009853180162696},
{0.5718126829459631,-0.7622169061584699,-0.3034067296358958},
{0.7372954951382871,-0.6522960144835273,-0.1757989258718444},
{0.31310649702722065,-0.9455196197356663,-0.08920185095761125},
{-0.5574175561424004,0.24250763789833527,0.7940250082114566},
{0.7726865051480304,-0.09919826751738658,0.6269890497318689},
{0.3312210862055431,-0.823252409916676,0.4610293500626672},
{0.8536935034171583,-0.49879620417532927,0.149698860796004},
{0.2933978523355813,-0.9491930519322896,0.11379916699314639},
{0.8422232541050731,-0.36551009187295685,0.3963109422961773},
{0.37420864244839713,-0.9231213197330717,0.08840204166872878},
{0.6062284570316752,0.009200431878408796,0.7952373293163777},
{0.800580370009988,0.4791882504481467,0.35979117802847077},
{0.04899743701110317,0.945850523853112,0.3208832150380206},
{0.3466995250219761,-0.8642988159114333,-0.3643995007730259},
{0.12920223198783656,-0.7641132001695503,-0.6320109180829157},
{0.11690281330005352,-0.9799235821447599,-0.16150388663779847},
{0.9102964589536621,0.3287987209754631,-0.25149902167070853},
{0.679627304575453,-0.7043282969577569,0.20500823637134763},
{0.7270100582537344,-0.615808519769807,0.3037042017766976},
{0.46118556281193074,-0.8798724560238895,0.11459641261545374},
{0.556304953917672,-0.7217064268243464,0.4119036680184956},
{0.5710950486273925,-0.6017947824618539,0.5582951596019492},
{0.6846703509924115,-0.6083736549492963,0.4013826185020505},
{0.6294307641804173,-0.775837920005033,0.04350212621837965},
{-0.4424058707648579,0.40390535985968823,-0.800710625500501},
{-0.3269019303615982,0.7513044364657959,-0.573303385366486},
{-0.6830164608950638,0.4998120456154508,-0.5326128361240277},
{0.3022179764598757,-0.11840704306038809,-0.9458562612036744},
{0.560290808504679,-0.3325945438312623,-0.7585875554732279},
{-0.09959824459640834,0.10299818467299257,-0.989682556998648},
{0.044400251972144915,0.7152040587945505,-0.6975039583461955},
{0.6239685870922043,-0.32868345284808903,0.708964308090341},
{0.35919927441819854,-0.6765986332721412,0.6427987015479344},
{0.5427912367062244,-0.7132884840503868,0.443392841480361},
{0.41230293973044047,-0.9097064862303703,0.04940035222576706},
{0.5800261249650159,-0.7764349714186868,-0.24641109860582747},
{0.5100836826839823,-0.8440729985366583,-0.1653947091078821},
{0.3286017728113465,-0.8614046472906083,-0.3873020895004093},
{0.6744023975047847,-0.529301881671534,-0.5148018301237591},
{-0.08959771707925286,0.4801877649716208,0.8725777670017416},
{-0.24189550683269048,0.3326938202696822,0.9114830693592285},
{-0.7733886544716577,-0.6172909444082678,0.14429788316558084},
{-0.4618249553857146,0.5855316400570288,0.6662360010350001},
{-0.42966911219774623,0.561159659682046,0.7074491433090655},
{-0.7832835277206163,0.42189112772287507,0.4565903980048939},
{-0.7890843368313694,0.595488179676949,0.15079700670912494},
{-0.918816382642155,0.3829068272895964,-0.09570170637663718},
{-0.94774378203529,0.20360940595376706,0.24561134627821804},
{-0.7133046578946242,0.5717037332375671,0.4054026472879302},
{-0.9879427492076573,0.03670158811207716,-0.15040650823041973},
{-0.9779492995328145,-0.20868918078987564,-0.007999585272252061},
{-0.7269991639514423,0.03589995871507122,0.6856992114463603},
{-0.8935659513181252,-0.4208839625221564,0.1561940483391799},
{-0.8997729442343442,-0.43628688105072727,0.007899762457714291},
{-0.8277047551774778,-0.5609032223982691,-0.017100098240346587},
{-0.589711213465337,0.4782090932323625,0.6508123753149759},
{-0.9320186405592186,0.22360447213416446,-0.2852057041711257},
{-0.8879824669592831,0.42499160862353075,-0.17569653090624554},
{-0.9942162008849912,0.10410169635096317,0.026400430198515155},
{-0.9577346179434095,0.2649095753296536,-0.11210405207419465},
{-0.9449140840493848,0.20730308987558208,0.25330377552091143},
{-0.9390578947038678,-0.23411443359976086,0.2517155187401102},
{-0.6799044397904878,0.6817044515446029,-0.2702017644232826},
{-0.8132782816934772,0.3693901355681427,-0.4495879939129317},
{-0.9089279817786351,0.3431105628212672,-0.23690729330328822},
{-0.5251852188700193,0.28659193398352545,-0.8012774483635692},
{-0.2474886739399998,-0.6037723689897854,-0.757765321663563},
{-0.4252237621677635,-0.4462249357461337,-0.7874440036004161},
{0.10529745499126893,-0.8100804205928486,-0.5767860592494198},
{0.35531441539825503,-0.7341297842495328,-0.5786234752305949},
{-0.012799808452299756,-0.6702899691856661,-0.7419888962192515},
{-0.411915304997491,-0.9038335825606517,0.11580430278880666},
{-0.9746483742428882,-0.17389078924883375,-0.14079254241653705},
{-0.8792744398635444,-0.08379756404021951,-0.46888636967134756},
{-0.8949346838657729,-0.275210665996045,-0.35121361154727837},
{-0.899507241062436,-0.4291034542967107,-0.08220066171799026},
{-0.8770855325934589,0.3292945683308927,-0.34969423184121834},
{-0.9589022390393422,0.2554005963610888,-0.12360028860701086},
{-0.7506688253710101,0.5023791366276747,-0.4290821805870526},
{-0.6680905766488741,0.5683919828876216,-0.48019322692230104},
{-0.5650906167482127,0.814786470582983,-0.12959784804559965},
{-0.5856803858923092,0.5484816316577286,-0.5967800141719826},
{-0.4192152827717053,0.4303156874443339,0.7994291437206612},
{-0.08600111802180146,0.27700360107022104,0.9570124412426048},
{0.2530910736352466,0.08979683292155331,0.963266026206373},
{0.16429621301593444,0.27439367529867564,0.9474781608800846},
{0.11760348287871895,0.391511594787572,0.9126270278496507},
{-0.05119992985614415,0.6212991488207491,0.7818989287992014},
{0.0066997271256711444,0.8828640416798587,0.469580874360473},
{-0.27680393894807703,0.8403119577242383,0.4661066327445763},
{-0.3656155828682198,0.6244266136294213,0.6902294182047192},
{-0.6321975565611658,0.6499974877645647,0.4216983701389491},
{-0.544205711468913,0.7996083919341103,0.2539026647224495},
{-0.7015733091511704,0.43518344376081725,0.5642785324315928},
{-0.7220894756225885,0.27569598176034854,0.6344907523646759},
{-0.40041181632705225,0.27490811265810855,0.8741257958328581},
{-0.33319319959619365,0.4422909729333627,0.8326830051132966},
{-0.7358836746017664,0.4883891652065535,0.4689895955812317},
{0.03849941750821961,-0.5214921098840657,-0.8523871034806858},
{-0.27580664426209134,-0.4557109782096992,-0.8463203881037271},
{-0.21169016722009365,-0.26238781236916664,-0.9414562703718383},
{-0.5584069633782504,-0.3079038395848196,-0.7703096058206773},
{0.4642039527134861,-0.507804323972228,-0.7257061794144266},
{-0.1395042200664865,-0.39911207332282983,-0.9062274137939073},
{-0.4504836882809657,-0.27808993054591913,-0.8483692811044867},
{-0.6270038372752262,-0.13400082008752842,-0.7674046965311142},
{-0.5935132889113097,-0.08410188306224288,-0.8004179215578977},
{0.716927853188155,-0.6225241855344212,-0.31381219184048414},
{0.7106721777288523,-0.5033802930472833,-0.491480758904926},
{0.9230248481633734,-0.010000269210870784,0.38461035385009035},
{0.7051432936015568,-0.6996429558979566,-0.11520707335540965},
{-0.37388703008388574,0.38438666585783815,-0.8440707196945919},
{-0.5367124438222667,0.08650200557224905,-0.8393194598472675},
{0.7943774042560993,-0.47918636973756645,-0.37328938193454414},
{0.5858182660983099,-0.8092252320361085,-0.04440138445675138},
{0.5022827569289268,-0.7575739929312263,0.41688568855996333},
{0.3959131801691554,0.017000565958261285,0.9181305650752755},
{0.015100815617077813,-0.8741472139660739,-0.48542621857811724},
{0.004899820032915226,-0.9846638339615559,-0.17439359464090112},
{-0.31580753367857495,-0.9488226344339198,0.001100026241438988},
{-0.04370149920564582,-0.9987342621665555,0.024900854238457223},
{0.13649884658961944,-0.9783917326247887,-0.15529868773163297},
{-0.4399899639433824,-0.8740800624611603,0.20589530358168737},
{0.11180130249276109,-0.9825114463250249,0.1489017347153142},
{-0.5518086607048951,-0.5324083562147267,0.641910074857688},
{-0.6590765307026051,-0.7520732191494905,0.0019999287838039907},
{-0.7361178952435526,-0.6584160062876716,0.15690381437809187},
{-0.5205922406304796,-0.8011880583809841,0.2950956016328362},
{-0.436475608242181,-0.8975498418285949,0.06239651306829804},
{-0.3218046114931243,-0.9377134375298404,-0.1309018758373212},
{-0.4972858897130663,-0.2394932044767331,-0.8338763390945626},
{-0.3794880652880171,-0.5495827158953733,-0.7442765928692255},
{0.0529022629426971,0.9930424783005334,0.10520450021874735},
{-0.0729023161433764,0.995731634896569,-0.0566017982676969},
{-0.06689760410521269,0.9848647277014048,0.15989427348914062},
{-0.26048878619912597,0.9548588942093873,0.14279385285694893},
{-0.6052677128550136,-0.7883579461670126,-0.11019412185135058},
{-0.26409984418113785,-0.8705994863464545,0.4150997550912167},
{-0.08739997159501385,-0.9882996788026566,0.1249999593750198},
{0.06040003231402593,-0.9834005261194222,-0.17110009153857345},
{0.32548989206835033,-0.9454706388652081,-0.011899630462713884},
{0.33509594703903073,-0.9112889780264658,0.23929710571900942},
{-0.2372077876595054,-0.3271107392218559,0.9147300310798887},
{-0.41419629503071137,-0.6004946285995707,0.6839938817020922},
{-0.08750201169437355,-0.7764178500515614,0.6241143485538119},
{-0.0741984177356125,-0.8800812324678243,0.46898999889490917},
{-0.032998280834351634,-0.9255517800083597,0.37718034941567985},
{0.14040467134112455,-0.8221273526320406,0.5517183559750599},
{0.22260143578389122,-0.9275059824328801,0.30030193695374},
{0.07300438440996256,-0.8817529552638903,0.4660279881512679},
{0.4508879659607806,-0.7963787449349428,0.40308924169170696},
{0.4793926413794319,-0.8652867179508185,0.14649775127677672},
{0.661412947285166,-0.7500146816810923,-0.003300064599396806},
{0.35889431157024204,-0.4959921385869046,0.7906874677029545},
{-0.20550745389053135,0.09600348210944532,-0.9739353252748832},
{-0.38090916668939595,-0.2009048348330261,-0.9025217194465208},
{-0.14490316906696163,-0.350407663499402,-0.9253202369748764},
{0.04110025358934697,-0.0519003202259637,-0.9978061564829783},
{0.025899672241721655,0.2664966275065182,-0.9634878071389504},
{-0.008599585638948741,0.47957689214416466,-0.8774577207183162},
{-0.0030999810746733083,0.13679916484364793,-0.9905939524423805},
{-0.015500679719708891,0.28011228319293296,-0.9598420899984899},
{0.0619004497084007,0.611904445501945,-0.7885057285149266},
{0.3022024946918906,0.42590351584803504,-0.8528070399511722},
{0.3857029525674029,0.6976053401893189,-0.6038046221420739},
{0.5944178892755707,0.49491489468788685,-0.6338190750721008},
{0.5322942858515118,0.09429898770580043,-0.8412909687899248},
{0.8082896135451985,0.2215971524948855,-0.5454929904601086},
{0.6604274050037677,-0.16810697574369074,-0.731830367931189},
{0.38090916668939595,-0.2009048348330261,-0.9025217194465208},
{0.4252237621677635,-0.4462249357461337,-0.7874440036004161},
{0.635607433472402,-0.3955046254536422,-0.6630077539210234},
{0.843049636008523,-0.1526089851185061,-0.5157303645190929},
{-0.6604274050037677,-0.16810697574369074,-0.731830367931189},
{0.10780362657499801,-0.36121215138116214,-0.926231158940289},
{-0.0,-0.13409572174424553,-0.990968383658071},
{-0.843049636008523,-0.1526089851185061,-0.5157303645190929},
{-0.635607433472402,-0.3955046254536422,-0.6630077539210234},
{-0.4010013313266301,-0.10000033200165338,-0.9106030232070557},
{-0.1541015957302857,-0.31880330122527634,-0.9352096841464193},
{-0.006399871587864872,-0.46539066203004864,-0.8850822410029997},
{0.2200962815047357,-0.5786902231112702,-0.7852867326927259},
{0.004199812167601112,-0.6908691015703828,-0.7229676659941914},
{0.0006000115263321323,-0.3821073403525129,-0.9241177524725391},
{-0.11329976546972821,-0.3689992361723717,-0.9224980904309292},
{-0.04110025358934697,-0.0519003202259637,-0.9978061564829783},
{0.2126979644902197,0.08639917316386922,-0.9732906856527073},
{0.14490316906696163,-0.350407663499402,-0.9253202369748764},
{0.24739479981596124,-0.6037873085241608,-0.7577840715462224},
{0.09959824459640834,0.10299818467299257,-0.989682556998648},
{0.5251852188700193,0.28659193398352545,-0.8012774483635692},
{0.8132782816934772,0.3693901355681427,-0.4495879939129317},
{0.9417203131262336,-0.3146067861415664,-0.11910256907012257},
{0.7530581085426001,-0.4545747127120781,-0.4756735390170162},
{0.7949027861391482,-0.18230063896485935,-0.5787020283541641},
{-0.9424366190862657,0.3073119408374464,-0.1318051213874892},
{-0.8463025939214256,0.5217015990178515,0.10770033010201764},
{-0.8741171765712811,0.3933077285728004,0.2850056004150727},
{-0.9929382834735433,0.10280396368323119,-0.05920228258800862},
{-0.7643077119037198,0.6438064960403178,-0.03670037030860463},
{-0.6401012642012452,0.45400089665265636,0.6198012241086265},
{-0.25760992203722455,0.9040348195716267,0.341113138225533},
{-0.5761856473942829,0.8152796916358188,0.05769856274670274},
{-0.5094840151897811,0.686278468350828,-0.5190837140039557},
{-0.8780802565873934,-0.0929979089655251,-0.46938944589696213},
{-0.5652999038990246,-0.26369995517101147,-0.781599867128034},
{0.009900092813805196,0.9590089907514326,-0.28320265503733655},
{-0.28459794947916095,0.9290933059068462,-0.2361982981973922},
{-0.1709077542607202,0.844638322110031,-0.507323017767486},
{0.13339651306072228,0.9073762814939985,-0.398589581004527},
{-0.16469001267701266,0.839149111345167,-0.5183685644915808},
{-0.3657140912354082,0.7337282710949384,-0.5726220635531712},
{-0.2285111116229606,0.12450605425408574,0.9655469508620064},
{-0.9264048497420826,0.3469018160357604,-0.14640076641001823},
{-0.92651361058491,0.3254047802313327,-0.18890277500214733},
{-0.8911914223238401,0.4240959180964324,0.16099845039737237},
{-0.907863223205727,0.35498561982380555,0.22309096276814372},
{-0.836887869398249,0.09929856067779438,-0.5382921975111452},
{-0.8412261919852375,0.14980466424083283,-0.5195161753879349},
{-0.9896204556662301,0.11130230064233165,-0.09090187896125738},
{-0.2853098519192831,-0.4154143445049779,0.8637298251058002},
{-0.5931736043618957,-0.16699256899601583,0.7875649541392938},
{-0.6769139242626345,-0.6650136794720816,0.3155064900352507},
{0.2508019662951237,-0.9112071438920123,0.3268025621421308},
{0.2334884250982315,-0.8570575124269559,-0.4592772318955791},
{0.0035000678144708644,-0.8700168567399006,0.4930095521526103},
{-0.06180087572461357,0.6529092517896473,-0.7549106971603686},
{0.20449268542746105,0.6847755060182168,-0.6994749802274279},
{0.31700741013481887,0.8336194860832334,-0.45231057288321314},
{-0.4421073147260337,0.6411106072627465,-0.6273103789360799},
{-0.5594072108054212,0.7669098855321372,-0.31450405398338394},
{0.3249983750121874,0.7209963950270373,-0.6119969400229498},
{-0.22930409426115486,-0.9308166198791232,-0.2846050816691002},
{-0.9782167178665637,-0.1063018167135716,0.17830304722511583},
{-0.8438062610656858,0.5236038851552418,-0.11760087260171206},
{-0.5948773415535822,0.504380788501642,0.6258761608310424},
{-0.35838989175565256,-0.023599334390160157,0.9332736773871387},
{-0.3116938612498534,0.16649672087937312,-0.935481575871793},
{-0.7450245117096596,-0.24140794245196218,-0.6218204582296192},
{-0.1919007877543506,-0.5717023468429507,-0.7977032745786633},
{-0.968924005389604,-0.013200327042153754,0.24700611965242253},
{-0.866274696485668,0.016799509293500197,0.4992854160859911},
{-0.5645962482703953,-0.23969840720937613,0.789794751831311},
{-0.884783392771575,-0.185496518263028,0.42749197605091355},
{-0.5061077485689464,-0.4364066814374396,-0.7439113893705576},
{0.683444859375566,-0.6409420696134039,-0.3494229351270453},
{0.903289436091817,-0.4184951057283576,0.0944988948418872},
{0.9391187309098838,-0.3429068393451168,-0.02170043281944892},
{0.6144903372154203,-0.646189838744678,0.45259288303287104},
{0.8704798703857433,-0.4239901953400978,0.24999421895052937},
{0.9836973882869011,-0.17809952714638314,-0.024899933890763278},
{0.9090069630200053,0.09920075988073104,-0.4048031008036283},
{0.9703348793141167,0.18710672567213357,0.15310550347623547},
{0.9515549116387427,0.20249040521946765,-0.23138903589029536},
{0.855349128388074,-0.24801424510726336,-0.45482612368864267},
{0.6287109459528544,0.534309302405933,-0.5650098369068915},
{-0.015199723671535452,0.9653824495066005,-0.26039526605709423},
{0.2568110508172801,0.4247182760206343,-0.868137356754209},
{0.5636959160378824,-0.15559887269025102,-0.8111941229198691},
{0.909919531632372,-0.1041022345784481,-0.40150861847499436},
{0.8079056755573062,-0.43230303693950184,-0.4005028135421478},
{0.38939525719465096,-0.6763917615985153,-0.6251923852031221},
{0.1546019742798174,-0.2527032270408141,-0.9551121968606313},
{0.004800156847687539,-0.5331174198962974,-0.8460276444049288},
{-0.6570003744903202,0.03450001966501681,-0.753100429267367},
{-0.47438436454901245,-0.22159269642508675,-0.8519719194682939},
{0.0039001627571878567,-0.31271304978785713,-0.949839637635135},
{-0.4856812603500971,0.7017729226141612,-0.5211798906618708},
{-0.07660214603918236,0.8400235335889449,-0.5371150474888361},
{0.06549807765963063,0.9922708772771216,0.10539690664618423},
{0.009399954081336469,0.9649952860095417,-0.2620987196508817},
{0.35220237209096406,0.8980060480911009,0.26370177603744244},
{0.4333017440430296,0.6805027390290368,-0.5909023783868594},
{0.08439842345217473,0.18139661154294426,-0.9797816978488246},
{-0.25660356168215437,0.5048070067698813,-0.8242114401341841},
{0.2271051939551793,-0.3476079498847219,0.9097208055527372},
{0.313013913777708,-0.2569114199664319,0.914340643344915},
{0.07569820635225047,-0.4096902925035273,0.9090784596410951},
{-0.41720507950276464,0.9085110611895054,-0.023400284900203003},
{0.11019409044938955,0.9378497044689877,-0.3290823517866978},
{-0.04819782223060265,0.9492571087865372,0.3107859574537615},
{-0.6109171975611705,0.7885221972122817,0.07080199310415922},
{0.17830321394439727,0.9255166825885569,-0.3341060223153289},
{-0.6103157127802908,0.62091598568783,-0.4919126644545717},
{0.2544057229211064,0.40670914902521216,-0.8774197377790045},
{-0.3326862586778721,-0.5825759371978608,-0.7415693701097383},
{-0.45418835248904865,-0.7358811285704335,-0.5021871215763986},
{-0.42839545689026937,-0.7220923422513154,-0.5431942394556357},
{-0.23629749171543807,-0.872490738559965,-0.42769546003678743},
{-0.27580087429015726,-0.9389029763271524,-0.2059006527061036},
{0.6120065699257924,-0.6202066579542098,-0.4907052677493241},
{0.6304190389424684,-0.613018513438663,-0.476214381891503},
{0.3087099128344542,-0.9347300146626639,-0.1760056516322123},
{0.9599621206420644,0.04439824807969548,-0.2765890860099948},
{0.999159384996483,-0.03209869521455875,-0.02549896348820088},
{0.9598076928894879,-0.1997016006147434,0.1972015805770025},
{0.476214234256196,-0.8707260263898989,0.12270366766744067},
{0.5100054060859569,-0.7322077614434072,0.4514047849160803},
{0.23760647961704995,-0.9201250921533992,0.3113084894982645},
{0.48908875597874857,-0.8053814844925049,0.33489230091450195},
{0.789020554253161,-0.6037157269995352,0.11390296721094428},
{0.7970928142406694,-0.6020945721418981,-0.04609958441411976},
{0.4806981877712481,-0.8760966971216777,0.03719985975679307},
{0.43680781019347004,-0.8590153593319385,-0.2670047740880414},
{0.9457667994392482,-0.3123890337754506,-0.08909687230919541},
{0.9428255509186495,0.013600368574982641,-0.3330090246668544},
{0.5061768631843637,-0.40828133788655807,-0.7596652764937992},
{0.36588847286524073,0.012799596755056248,-0.9305706828324487},
{0.7782047120437973,0.23120139992871488,-0.5839035355466117},
{0.19519924067643066,-0.011499955265261028,-0.9806961850992599},
{0.007400209946934334,-0.02210062700368227,-0.9997283626959803},
{-0.15089678065152687,-0.1434969385254745,-0.9780791329042969},
{-0.22149600203324463,0.4428920058714404,-0.8687843185845732},
{0.14820304115760713,0.28360581965112946,-0.9474194412464035},
{0.615384997096654,0.3885905262784526,-0.6857832808074183},
{0.5341095446228443,-0.034400614744478274,-0.8447150951936279},
{0.26180553200933765,-0.5785122240924441,-0.7725163234423733},
{0.8561052693441493,-0.13520083216368295,-0.49880307014234515},
{0.6784942158614646,-0.5901949686093388,-0.4373962712126819},
{0.22931061962069765,-0.9308431083425441,-0.28451317611028554},
{-0.5278867977162817,-0.5954851071037047,0.6055848545121806},
{-0.7536449449564787,-0.595635521783544,0.2779165740491048},
{-0.457395990941709,-0.620094564894958,0.6373944132624515},
{-0.4478951067726876,-0.5061944698556251,0.7369919484069453},
{-0.3610021208936903,-0.6689039298221315,0.6498038176086427},
{-0.29649104165851237,-0.5852823159619808,0.7546771977729487},
{-0.06439843835680453,-0.5734860931308603,0.8166801957453768},
{-0.0752973002636977,-0.5028819694902201,0.8610691269199215},
{-0.8419284113536197,0.33911144350874506,0.41971416349342466},
{-0.5676924298719211,0.21269716370223293,0.7952893948866283},
{-0.7425102095855732,0.4295059057468063,0.5140070676457705},
{-0.7773872276327741,0.06269896986438762,0.6258897167164308},
{-0.3404051180294246,-0.08840132912397515,0.9361140745809178},
{-0.6289057073451914,-0.3858035011826599,0.6750061257083864},
{-0.5996962279225896,-0.5659964398935895,0.5656964417805718},
{0.5798052153713685,0.09990089861262456,-0.8086072734551373},
{0.22329208331952638,0.7818722792097522,-0.5820793627420344},
{0.04880118856742152,-0.07040171465464089,-0.9963242657729929},
{0.4777866006626739,-0.7033802739768205,-0.5262852405373907},
{-0.19350338053358715,-0.3859067418496707,-0.9020157583529489},
{-0.20799263511118377,-0.9118677113360023,-0.3538874690665766},
{0.9709362602917235,0.09810366374973539,-0.21830815287020625},
{0.5590130866495394,-0.828319391183924,0.037300873223663364},
{-0.4319893515937232,0.001299967956184815,0.9018777689869883},
{0.5025946700117867,0.6320932966861328,-0.5897937452704969},
{0.5136116642533443,0.523111880005694,-0.6801154455971563},
{0.589508521407266,0.6272090663725821,-0.5090073577545349},
{0.5724903078211321,0.7344875652307801,-0.3643938308646647},
{0.7392068266065657,0.6467059723572323,-0.1880017362040508},
{0.8095141059061942,0.43910765151749215,-0.3897067906999925},
{0.785928443265052,0.21850790794428535,-0.5784209334323782},
{0.37770274779748536,0.7980058055133528,-0.4696034163772813},
{0.31410995901412836,0.8893281965974669,-0.33231053607257194},
{0.06570338216864793,0.9866507891565914,-0.1490076703672533},
{0.3047834065191358,0.9500482760296289,-0.06719634159477009},
{0.24348788799625992,0.9579523478456551,0.15179244927241173},
{0.23218806119683202,0.9137530160278429,0.33338285789415933},
{0.1904080153941156,0.9202387382650481,-0.3419143931893283},
{0.5383108228478911,0.8363168143185795,-0.10390208897249839},
{0.5141850888486319,0.7069794978918373,-0.48558591821255476},
{0.6635080218604767,0.5706068986791079,-0.4839058504570983},
{0.48170675839323074,0.6181086721255052,-0.6212087156194206},
{0.770287332728969,0.47219223486254597,-0.4285929518468598},
{0.566074906455583,0.7635661518627153,-0.31068622758479},
{0.693006649430702,0.6341060842770682,-0.3430032911323677},
{0.7722117801805606,0.6353096917232713,-0.008400128144932283},
{0.7890962320744879,0.5954971565078666,0.15069928041265407},
{0.918816382642155,0.3829068272895964,-0.09570170637663718},
{0.9320186405592186,0.22360447213416446,-0.2852057041711257},
{0.8792744398635444,-0.08379756404021951,-0.46888636967134756},
{0.9879427492076573,0.03670158811207716,-0.15040650823041973},
{0.9746483742428882,-0.17389078924883375,-0.14079254241653705},
{0.8949346838657729,-0.275210665996045,-0.35121361154727837},
{-0.23329551843613588,0.9586815839036582,0.16279687270211282},
{0.4715899835351234,0.8073828513703533,0.35459246853595155},
{-0.4236086395863074,0.6887140464662179,0.5884120007851353},
{-0.8453688022400194,0.5272805410706911,0.08559684110686736},
{-0.7840311227331376,0.6106242392102726,-0.11150442625605209},
{-0.8414736033870861,0.42248674679862613,0.33678943508112963},
{-0.9957690619358609,0.06809788423160486,-0.061698083070338035},
{-0.8214207781013764,0.450911405948272,-0.34920883334916075},
{-0.7944154674197275,-0.47910932834943537,-0.37330726836327327},
{-0.5511178069040162,0.0009000290804093895,-0.8344269607706607},
{0.626096224651148,-0.7517954666870038,0.20689875240428449},
{0.8566499055939178,-0.5068295262140995,-0.09630561044675962},
{0.3920033477228845,-0.7876067261901627,-0.47540405996800833},
{0.5952738620985604,-0.8012648172342959,-0.06019735679209361},
{0.8284092740937355,-0.17030190654051566,0.5336059737523144},
{0.879712764724825,-0.17200249577432067,0.4433064324230021},
{0.7455033286797939,-0.23710105865859035,-0.6229027812671275},
{0.9689227215042321,-0.013300311895970984,0.24700579235374684},
{0.8986632948473178,-0.023999019780055218,0.4379821109860077},
{0.9069301060445635,0.2406079871147006,0.34581147940259127},
{0.9389852204889434,-0.10419835993072195,0.32779484054981434},
{0.9368511960081328,0.2452872220949888,0.2492870137312707},
{0.8316169901086636,0.3077062865036505,0.4623094450784454},
{0.819050725382183,-0.14330887539348822,0.5555344053111144},
{0.8112003366482096,0.45980019081711876,0.3613001499395933},
{0.6585826498686308,0.714281182510117,0.23679376175051897},
{0.8404940030966818,0.535096182102361,0.08509939281799835},
{0.7275685951793691,0.6835704943164056,0.058097492275867704},
{0.7311393473227428,0.6740362742381736,-0.10540567255890725},
{0.9374465922534813,0.3470172471857883,-0.027801381763011283},
{0.8630062438727617,0.4738034279802022,0.17530126830926435},
{0.7586637746696187,0.6240702013593106,0.18699107138950663},
{0.4750031350310368,0.6882045421649675,0.5484036194758328},
{0.7757292494227847,0.5721215722505804,0.26631004140942055},
{0.42530433387324335,0.9032092037486794,-0.05770058797198716},
{0.5613808656592855,0.8244718983542587,0.07139756645542035},
{0.5872742955666123,0.7904654020865094,-0.17399238451999066},
{0.12299845207422093,-0.9408881589970282,0.31559602824897665},
{0.7964567017709704,0.0555039514669624,0.6021428680767218},
{0.06249902846015382,-0.1079983211791458,0.992184576610634},
{-0.8743482357450086,-0.31558131656121313,0.3686781730548773},
{-0.4358862153164074,-0.6159805199240811,-0.6561792486593865},
{0.8484935387463035,-0.5202960379607563,-0.09669926363791106},
{0.5626873565571457,-0.8177816246533388,0.12089728346856037},
{0.572479703091934,-0.7404737469686936,-0.3520875169583755},
{0.7023777876536927,-0.6217803365077821,0.34648904245729567},
{0.8815546892534286,-0.4717757513495549,0.01699912626736421},
{0.9148226467149326,-0.3404084269149137,0.21730537946125367},
{0.5856981872669156,-0.3128990315789959,0.7476976858792432},
{0.9906355545480906,-0.11810423883719916,0.06850245859735939},
{0.7314990709967698,-0.09979987325424144,0.6744991433866319},
{0.9380100086201882,0.09650102967147993,0.33290355209985145},
{0.38949014797130904,-0.7652806424709699,-0.5124870368043539},
{0.18970034335793223,-0.7998014476419304,-0.5695010307977987},
{0.08090285875302194,-0.9454334074796904,-0.3156111523171041},
{0.035299591586088,-0.7580912289352214,-0.6511924657467566},
{-0.13619596457335365,-0.9340723238470606,0.33009021957168905},
{0.5022050597414655,-0.6074061196474834,0.6155062012562166},
{0.07369967977558707,-0.9943956793601598,0.07579967065114654},
{-0.05159939474264948,-0.9818884825156498,0.18229786165862402},
{0.48779011259462557,-0.7558846783728526,0.4366911483601332},
{-0.5683806725438396,-0.469184045667786,-0.6758770171927888},
{-0.3666019283312145,-0.6124032212494157,-0.7004036841330679},
{-0.21230459113642552,-0.41110889032588105,-0.8865191711843675},
{0.006399871587864872,-0.46539066203004864,-0.8850822410029997},
{0.3794880652880171,-0.5495827158953733,-0.7442765928692255},
{0.6052677128550136,-0.7883579461670126,-0.11019412185135058},
{0.1259955089701227,-0.9826649735312667,0.1359951525391801},
{-0.26510094641206805,-0.8934031894550796,0.36270129484593394},
{-0.09920330749340867,-0.9228307676907008,0.37221240976861597},
{-0.04639851805499961,-0.9963681765086554,0.07139771959325372},
{0.49890108261652394,-0.8497018438550018,-0.170600370203205},
{0.28888319037621374,-0.9385453876327942,-0.18888900886835164},
{-0.11700144731685504,-0.9799121215879165,-0.1615019977920691},
{0.8642505082755986,-0.3858225481285882,-0.32281886608581717},
{-0.8569346122879995,-0.511920676893718,0.060002423546831565},
{-0.7144810307804458,-0.665382334333532,0.21629425746369546},
{-0.9778124182965691,-0.18800238764548474,0.09240117350235526},
{-0.918925937050615,-0.34850983682896863,-0.18470521337822243},
{-0.9417203131262336,-0.3146067861415664,-0.11910256907012257},
{-0.972177231875841,-0.09299782201651226,0.2149949648768832},
{-0.9230248481633734,-0.010000269210870784,0.38461035385009035},
{-0.26179488850470245,-0.9108822151983708,0.31899377170741056},
{-0.025201193052719343,-0.9962471634571035,0.08280392003036356},
{-0.8639557579584234,-0.4950746478764067,0.0920952839212625},
{-0.8091600851174774,-0.41807937665301204,-0.4128796331500326},
{-0.8556300416981554,-0.4321151718300291,0.28491000336583033},
{-0.38989157648348416,-0.835781943126176,0.3865916477776737},
{-0.32419936456986814,-0.5767988694753238,0.7497985303963207},
{-0.9091146050434461,-0.09090146034369073,0.4065065305798711},
{-0.24359990134205994,-0.2795998867620688,0.9286996238767284},
{0.13509957713898532,-0.547998284768053,0.825497416197131},
{-0.1623039042673763,-0.01520036564919359,0.9866237335193682},
{-0.6700878547676975,0.12319776706070786,0.7319867328606993},
{-0.9170944928641055,0.17419895393842239,0.35859784662639643},
{-0.5683772852556831,0.358885657421296,0.7403704116877335},
{-0.8378112686373452,0.030500410233276473,0.5451073317429183},
{-0.5675195854388461,0.1737059946973173,0.8048277750857856},
{-0.7108332500029214,0.07700360192772221,0.6991327026970209},
{-0.4214117364802937,0.17550488787919208,0.889724779180155},
{-0.18089836920855235,0.20409816006338052,0.9620913267857834},
{-0.1587985604975736,0.25619767757857903,0.9534913566400279},
{0.22200430137500912,0.3266063280589098,0.9187178003298238},
{0.5248920558188523,0.27509583645602265,0.8054878090342648},
{0.6497289168289295,0.22230989412201174,0.726932352844311},
{0.012500086875905684,-0.6083042277290741,0.7936055155775},
{0.6335020113720791,-0.40480128524612097,0.6594020936049708},
{-0.8379850295311699,-0.5456902513307392,-0.0017999678438617016},
{-0.929723034173511,-0.14000346862890348,-0.3406084386786037},
{-0.698990249154036,0.32129551795878647,-0.638891087531493},
{0.17279509873653554,-0.9739723736654259,-0.14669583903153796},
{-0.17650002294500447,-0.984300127959025,-0.0010000001300000255},
{0.5189891714039069,-0.6987854199943162,0.4922897284819718},
{0.5062785064022564,-0.8338645990299064,0.21989066473998853},
{0.7928326019469019,-0.323613307252797,0.5164212356778256},
{0.5574175561424004,0.24250763789833527,0.7940250082114566},
{-0.7726865051480304,-0.09919826751738658,0.6269890497318689},
{-0.3312210862055431,-0.823252409916676,0.4610293500626672},
{0.4567149667946968,-0.8346273511864549,0.3079100903789953},
{0.37538896184986287,-0.8641745893197961,0.3350901468190971},
{0.6944658852013137,-0.6987656739793779,0.17159157077112375},
{0.6822016986843447,-0.717301786083671,0.14170035283431784},
{0.8997729442343442,-0.43628688105072727,0.007899762457714291},
{0.7271169638366518,-0.6662155429899291,0.16570386591628827},
{0.22950991159955328,-0.9187396766296714,0.3213138762393746},
{0.14849449763833314,-0.7618717693646196,0.6304766381210036},
{0.35868544842653005,-0.7020715175362886,0.6151750428547569},
{0.5002971908391601,-0.7904955613798842,0.3532980162372082},
{0.03840010732844997,-0.9759027276519356,-0.21480060036851703},
{0.34100778018125827,0.20640470917716042,0.9171209243525864},
{0.46870627367546003,0.7373098689586445,0.4865065119332436},
{-0.19428685790997996,0.8485426022769377,0.4921667085089662},
{-0.35670670258191284,0.15530291816924885,0.9212173098358792},
{-0.8208943481618693,0.2639981823787715,0.5063965134720071},
{-0.7439018374398076,-0.4527011181731428,0.4916012142564988},
{0.03179923460163459,-0.5402869954485274,0.8408797602677525},
{0.39969959430511764,-0.5262994658063133,0.7504992382436597},
{0.7055231097879479,-0.478215664210626,0.5230171317067281},
{0.39362145098547313,-0.7974434578653868,0.4573249226007542},
{0.1330972442500864,-0.9311807201027833,0.3393929729412421},
{-0.036800263122821995,-0.8661061926814165,0.4985035643132273},
{0.08579902189672554,-0.9959886457941567,0.025399710444951384},
{0.3605998052761577,0.5525997015962417,0.7513995942443287},
{0.3293978160997188,0.5852961194995915,0.7408950878818508},
{0.701201311247678,-0.10010018718752506,0.7059013200367027},
{0.7510949451480288,-0.6583955690127308,0.04869967225230861},
{0.16999384548423435,-0.9495656215989937,-0.26349046050056324},
{0.6196967961758456,-0.7399961742296688,0.26149864805548434},
{0.6542839898666496,-0.7561814964651694,0.010099752862071161},
{0.8875301188456332,-0.38321300455396806,0.2558086810148879},
{0.8860744326911119,0.1032970194075069,0.4518869609898583},
{0.9809062483927035,0.01740011083905907,0.19370123388078975},
{0.8836012679687293,-0.46390066569793287,-0.06360009126619645},
{0.6093740534051973,-0.7207693102961376,-0.330385932466487},
{0.3493148898645275,-0.918539153565899,-0.18510789039199552},
{0.33758805972148775,-0.9266672243599013,0.16529415364917632},
{0.6809962102666348,-0.30379830936711255,0.6662962920714519},
{0.6055729557156831,0.2485888982676995,0.7559662393016123},
{0.5964863227254281,0.5655870312380589,0.5694869418141346},
{0.29410699688868497,0.8256196417249178,0.4815114552937838},
{0.6325302831122234,0.7188344150214485,0.28841380814160505},
{0.658492460304494,0.5167940827416287,0.5470937358125872},
{0.890604497564069,-0.20150101758270822,0.4077020589005962},
{0.8498958652666733,0.4453978331448127,0.2815986300259974},
{0.6656837408731914,0.7459817796175465,0.01939952617235979},
{0.8969999820600005,0.4419999911600002,-0.005199999896000003},
{-0.2613880326228833,-0.8859594372757253,0.3830824609710275},
{0.7024798039959486,0.278192002094908,0.6550811666871827},
{0.6299656520592067,0.7463593058682411,0.21468829443985982},
{0.9967620041565887,-0.035398650629156536,-0.07219724789336446},
{0.8910940697886982,0.17929880677041138,-0.4168972255581958},
{0.797417304143252,-0.31900692252532903,-0.5122111151017978},
{0.8352944327811581,-0.5481963462835279,0.04199972007279856},
{0.7757185166219902,-0.5416129284549052,0.32390773176983717},
{0.9440739297583897,0.31909118841849604,0.08309770528855225},
{0.8790777552188527,0.4313890838373485,0.20279486834078414},
{0.8747138512035015,0.43820693906182046,0.20700327792285905},
{0.7569995836503435,-0.20109988939509124,0.6216996580652822},
{0.9733334686467391,-0.1453049963982032,0.17750610365231292},
{0.9176843214972996,0.16419719471489225,0.3617938188054081},
{0.80788548242832,0.013299761005442081,0.589189412361389},
{0.9122870547385393,-0.3052956678852089,0.2729961262124534},
{0.721187761547529,0.5940899183796269,-0.35629395374290707},
{0.9121476609604603,-0.28031464682295476,0.2990156239745397},
{0.9356945963793087,0.22409870583371067,-0.2724984263261319},
{0.7837423467430227,0.6105329879885357,-0.11400615991923517},
{0.6033907893099013,0.22989649065685497,-0.7635883439128945},
{0.9877214831758911,0.15360334090899755,-0.028500619895224157},
{0.6165866202155105,-0.21279538239030263,-0.7579835519353826},
{0.9981589665283118,-0.057697628099262266,0.018699231290402157},
{0.9589022390393422,0.2554005963610888,-0.12360028860701086},
{-0.2641864726779909,0.14139276016906857,0.9540511490615863},
{-0.418787047116946,0.45808583162433847,0.7840757489121235},
{0.04069851575219529,0.39058575559723535,0.919666460375774},
{-0.1473056581189946,0.46581789240887767,0.8725335146559592},
{0.508386708403261,0.5012868940254813,0.700181693988913},
{0.23921477794937585,0.5734354250676091,0.7835484051978928},
{0.4197917112944899,0.43169147633594873,0.798384236058887},
{0.07750005231255296,0.27540018589518817,0.9582006467856549},
{0.3686898335180092,0.3588901037418321,0.8574763554154947},
{0.7218865225044361,0.27229491630136854,0.636188122478629},
{0.6410284847335928,0.46222053922600087,0.6127272271392703},
{0.94503987679892,0.19690830872138343,0.2610110135920827},
{0.6739056136571427,-0.6313052587947087,0.3838031970939477},
{0.9907641498478448,0.12069563270754427,-0.061797763888369814},
{0.8911914223238401,0.4240959180964324,0.16099845039737237},
{0.92651361058491,0.3254047802313327,-0.18890277500214733},
{0.9454282450907394,-0.02700080666114868,-0.32470970084722134},
{0.7422838369454238,-0.31489314327645695,-0.5914871205081749},
{0.5584069633782504,-0.3079038395848196,-0.7703096058206773},
{0.27580664426209134,-0.4557109782096992,-0.8463203881037271},
{0.008200041779319298,-0.5369027355264063,-0.8436042981748488},
{-0.03849941750821961,-0.5214921098840657,-0.8523871034806858},
{-0.4642039527134861,-0.507804323972228,-0.7257061794144266},
{-0.30199684414946787,-0.3312965379692672,-0.8938906588914217},
{0.21169016722009365,-0.26238781236916664,-0.9414562703718383},
{-0.7752153494158791,-0.32940652231371337,-0.5390106725169749},
{-0.8282369194835474,-0.5565248076462136,0.0656029243155285},
{-0.891861164751103,0.4521803102370768,-0.010799529744715678},
{-0.9509388656656759,0.274811231764568,0.14210580798306083},
{-0.8577933521272815,0.4578964513162534,-0.23349819039603664},
{-0.7980824184379806,0.42139071686476004,-0.43069051199253006},
{-0.7518011690517269,-0.4561007092371543,-0.4762007404927272},
{-0.3621874033411639,0.2373917436587308,-0.9013686509434707},
{-0.46298675645324483,-0.44098738573624396,-0.7688780065591792},
{-0.007599946002575477,-0.1306990713863967,0.9913929561780694},
{-0.39070944551501935,-0.4190101296923294,0.819619814548528},
{0.11499902136249229,-0.4810959058912612,0.869092604053409},
{-0.252702837868804,-0.7659086012018875,0.5912066392878389},
{0.10739681787942866,-0.5652832509054099,0.8178757667000437},
{0.20430169775416254,-0.13170109444064224,0.9700080608004781},
{0.0012000253868055895,-0.5235110749939385,0.8520180246319686},
{0.22799885772858416,-0.49389752557959526,0.8390957961405919},
{0.23689305795065366,-0.4815858873323546,0.8437752735279086},
{0.707034482912618,-0.06110298006500843,0.7045343609786978},
{0.5083170238221965,-0.4053135741789027,0.7598254469803362},
{0.15260292924134047,-0.8613165331295317,0.48460930216483344},
{0.35880483672179875,-0.9334125824864185,-0.00020000269605451436},
{0.006399905666085719,-0.86738721480668,-0.4975926655381646},
{-0.1909924320748156,-0.981461110373987,-0.015999366037680887},
{-0.2841007656525952,-0.792402135526633,-0.5398014547668809},
{0.31569388506866874,-0.6539873323880563,-0.6874866835119093},
{0.6005713504270755,-0.7950620724684778,-0.08479595490545457},
{0.2382047153090098,-0.8561169470027006,0.45860907825655706},
{0.9912725470869573,0.005899836606287752,0.13169635272001645},
{0.08979945761291404,-0.8601948044390718,-0.5019969679474704},
{0.06550104966273133,-0.9563153250758776,0.28490456563224664},
{0.693399691437206,-0.3382998494566005,-0.636199716891189},
{0.3195960482192955,-0.13359834806663917,-0.9380884006086393},
{-0.2900032915560388,-0.517705875995039,-0.8049091357705368},
{0.061600471861421695,-0.8866067914340336,-0.4584035113843458},
{0.07080314231318534,0.14260632900932527,-0.9872438148527763},
{0.592995407268356,-0.27799784691501345,-0.7556941471714952},
{0.3857907623507919,-0.7576818575251297,-0.5263873958047093},
{-0.27750254887261716,-0.5847053705434928,-0.7623070018219678},
{-0.07879712395746237,-0.9929637574842657,-0.08839677357664562},
{-0.2765073524282529,0.305608126228116,-0.9111242271153027},
{-0.44287735847380727,-0.2609866573982021,-0.8577561483378457},
{0.21949105153223983,-0.06479735826555416,-0.9734603128320523},
{0.13060203348949226,-0.9903154193311193,0.04710073336412777},
{-0.04829767138390999,-0.8626584079275185,0.5034757255030782},
{0.12140209723934488,-0.9307160782591292,0.34500596002943973},
{0.2084924016328812,-0.8459691692154317,0.4907821137717895},
{-0.35948934848840414,-0.9074731119700327,0.21739355872428112},
{0.2811970685358407,-0.944990148529052,0.16709825800974032},
{-0.11280229555007189,-0.993520218342167,0.013900282873634744},
{0.13059564601374166,-0.8305723091808103,-0.5413819506266442},
{0.4194155836755226,-0.8442313679992278,-0.3337123993145491},
{-0.13169235284709882,-0.9184466673504955,-0.3729783417765213},
{-0.7740273971845936,-0.5995212204291522,-0.20360720680462951},
{-0.34639431744783294,-0.8640858247883154,-0.3651940090414221},
{-0.3142934957634071,0.8850816834240903,-0.3432928956270367},
{-0.21510585310989577,0.8701236763873561,0.44341206540645184},
{-0.13389819104765835,0.9909866118613101,0.004099944610122475},
{-0.27049629152126475,-0.059399185642747224,-0.9608868263319159},
{0.04590176197295065,-0.0039001497101199896,-0.9989383449843225},
{-0.1830999761970047,-0.13629998228100348,-0.9735998734320248},
{0.40810054277408286,-0.6258008323156605,0.6647008840527636},
{0.3023930858611368,-0.8980794656477743,0.3193926971694679},
{0.15840095674466811,-0.7406044732645278,-0.6530039441557342},
{0.13350258129736434,-0.2178042112851382,-0.9668186936201635},
{-0.08360088199395757,-0.9313098253704868,-0.35450374003418617},
{0.07719975527716366,0.539098291061126,-0.8386973413336419},
{0.7186105349076631,0.2974043599798762,-0.6286092154786489},
{0.688809832830546,0.585108352481348,-0.4280061098308271},
{0.014699585918496932,0.6199825353379659,-0.7844779015687648},
{0.308804661441547,0.9511143571795833,0.004600069438572267},
{-0.5486958601053532,0.5583957869196815,-0.6221953055541293},
{-0.15120471085615123,0.1435044709514398,-0.9780304710139941},
{-0.0792002229489414,0.9442026579342231,-0.3197008999593},
{0.5705762274367155,0.5708762149379966,-0.5903754025212703},
{0.5154135220511289,-0.3579093898760167,-0.7786204273748718},
{-0.047398289663575684,0.9020674494833676,0.42898452037286855},
{-0.19340073782522219,0.9785037329988621,-0.07160027315556312},
{-0.11160038111595227,0.8065027542116084,-0.5806019827591566},
{-0.2792958022156388,0.7970880198570918,-0.5353919531194165},
{0.013999951770249227,0.9979965619077663,-0.06169978744459838},
{-0.12319843723773538,0.16369792350501042,-0.9787875841582419},
{-0.40238127964643655,-0.3964815541247816,-0.8251616102491041},
{0.9334809105105683,0.13239729250305218,0.3332931842240732},
{0.7057141638254034,0.1191023904089635,0.6984140173099925},
{-0.2907083245520621,0.12180348789281445,0.9490271757822734},
{0.8758796185184128,0.1497965142756687,0.4586893264235597},
{0.7870893783005094,0.259296500817332,0.5596924470013912},
{0.7358836746017664,0.4883891652065535,0.4689895955812317},
{0.39099225647504005,0.7989841762750818,-0.45689095136431146},
{0.8887021417747425,0.4530010917339466,0.07070017038761595},
{0.7744526320533464,0.536167206335706,0.3357794626772288},
{0.9446626204396492,0.2971882404939809,0.13889450405320977},
{0.7832835277206163,0.42189112772287507,0.4565903980048939},
{0.42966911219774623,0.561159659682046,0.7074491433090655},
{0.4618249553857146,0.5855316400570288,0.6662360010350001},
{0.7133046578946242,0.5717037332375671,0.4054026472879302},
{0.5587677265081483,0.030798221146118417,0.8287521326591863},
{0.7311919861797469,0.28279690056295465,0.6207931961438552},
{0.30100712642807825,0.2606061699241103,0.9173217178487582},
{0.124102078106697,-0.18370307613376502,0.9751163284596313},
{-0.10909678278331289,0.06239815990539619,0.9920707442651212},
{-0.13719816567278734,0.2760963086170305,0.9512872813740714},
{0.08959771707925286,0.4801877649716208,0.8725777670017416},
{0.24189550683269048,0.3326938202696822,0.9114830693592285},
{0.7269991639514423,0.03589995871507122,0.6856992114463603},
{0.7733886544716577,-0.6172909444082678,0.14429788316558084},
{-0.13010594532701067,-0.773235333795885,0.620628360260898},
{0.03420127077182373,-0.503818719732304,0.8631320702678672},
{-0.2987166046239649,-0.5117284452162131,0.8055447774509665},
{-0.42591927967255144,-0.7421335934374276,0.5175234262280943},
{-0.9318976003667687,-0.3622990670811035,0.017499954937674058},
{-0.671790725993041,-0.7333898756226501,-0.10409856292925808},
{-0.6459839119710061,-0.7614810355509615,0.053398670122680694},
{-0.7205958169534239,-0.6912959870384429,-0.05339969001569919},
{-0.679627304575453,-0.7043282969577569,0.20500823637134763},
{-0.7269652882362102,-0.6158705928812681,0.30368549936359984},
{-0.46110682904270756,-0.8799130316084979,0.1146016972637048},
{-0.5022827569289268,-0.7575739929312263,0.41688568855996333},
{-0.5858182660983099,-0.8092252320361085,-0.04440138445675138},
{-0.7789653952309582,-0.5283765273941442,-0.33768499867714324},
{-0.7318957440386226,-0.6088964592773839,-0.3058982212070155},
{-0.4301086302162488,-0.8731175192787882,-0.22950460505610115},
{-0.6270069566807769,-0.7775086265060669,0.04840053700693716},
{-0.6846071849901099,-0.605906359020607,0.4052042526409473},
{-0.5710950486273925,-0.6017947824618539,0.5582951596019492},
{-0.556304953917672,-0.7217064268243464,0.4119036680184956},
{-0.15990047890265147,-0.9766029249301403,0.14380043068293485},
{-0.06030091959603581,-0.99791521832312,0.02300035075802361},
{-0.6843015978460965,-0.2878006720153537,-0.6700015644554795},
{-0.9095562468490928,0.1622921931218203,-0.3825815963549504},
{-0.696491972976267,0.38459556756162566,-0.6057930182756963},
{-0.560290808504679,-0.3325945438312623,-0.7585875554732279},
{-0.7008787671993667,-0.5176843169911716,-0.49068513491900306},
{-0.304209544724201,-0.03310103856137755,-0.9520298704057834},
{-0.4883106379631233,0.39230854653478037,-0.77951698196243},
{-0.35610889927259065,0.5595139824291335,-0.748418703217093},
{-0.3023088441746064,-0.11840346394400728,-0.9458276705932608},
{-0.07790008958515453,0.4820005543009562,-0.8727010036067313},
{0.09190024859050865,0.477701292183743,-0.8737023633680894},
{-0.044400251972144915,0.7152040587945505,-0.6975039583461955},
{-0.6032160910038441,0.4120109905397609,-0.6829182170864144},
{-0.9102964589536621,0.3287987209754631,-0.25149902167070853},
{-0.7348043500546285,0.07240042861180608,-0.6744039924834533},
{-0.21089063560923402,-0.16339274470625337,-0.9637572053114261},
{0.8992281282957866,0.2384074575019078,-0.3668114740423649},
{0.9523200084535687,0.24900523165487617,-0.17630370417973765},
{0.858529817258339,0.5027174596805674,0.10100350791274577},
{0.7316853261979233,0.4800903718841369,0.48389029567742936},
{0.3673847152768748,0.9013624995932905,0.22929046056882796},
{0.2949103205672555,0.9200321970901156,0.25800902918396723},
{0.3005887491736736,0.7234729209153455,0.6214767385610053},
{0.44141079483298307,-0.40870999512514766,0.7988195353706091},
{-0.013099975765067252,0.9599982240049283,0.2796994825564359},
{-0.06209936565821968,0.7898919312951325,0.6100937679239907},
{0.10829689679688279,0.955872609862791,0.2730921746558513},
{0.17339376487232078,0.9205668970095646,0.34998741467884814},
{0.7347657276519317,0.562373768687325,0.37928230878930014},
{-0.04899743701110317,0.945850523853112,0.3208832150380206},
{0.04449897764773268,0.5658869988955488,0.8232810853343442},
{0.749998376255273,-0.12919972028290838,0.6486985955690608},
{-0.44671389748552953,-0.14080438049241675,0.883527486967686},
{-0.3932098755900397,-0.8183205523787628,0.41921052860464053},
{0.2903949994411641,-0.48279168639873976,0.8261857732034772},
{0.18300212558203302,0.45090523729474696,0.8736101470407871},
{0.7898853951540642,0.07709857446053721,0.6083887509959902},
{0.6224997852376113,0.7311997477361306,0.27899990374504985},
{0.5909204875684622,-0.7612263921765331,0.2671092608386127},
{0.16590266607726595,-0.38160613245982333,0.9093146128032426},
{0.11889647477178376,-0.9184727676861513,0.37718881651738295},
{0.513715111152245,-0.8352245684920285,0.19620577147765325},
{0.025199831665686713,-0.7413950474976241,0.6705955204368853},
{0.04710186008918311,-0.20060792216327242,0.9785386432540483},
{-0.5718126829459631,-0.7622169061584699,-0.3034067296358958},
{-0.1856076128523649,-0.9730399100503829,0.1369056152989696},
{-0.8411823816195235,-0.5361887696438286,-0.07009853180162696},
{-0.9733933517461113,0.044899693336141765,-0.22469846531472282},
{-0.9915802627913018,0.10619788615211401,-0.07409852508353718},
{-0.7261834831445116,0.6855844065600072,0.05129883322130742},
{-0.31310649702722065,-0.9455196197356663,-0.08920185095761125},
{-0.7372954951382871,-0.6522960144835273,-0.1757989258718444},
{-0.9487812854737143,-0.09149819521589889,-0.30239403533647896},
{-0.7164120322411232,-0.6344106550164272,-0.2903048757113317},
{-0.5955881300468512,-0.4104918189795708,-0.6904862387463914},
{-0.2933978523355813,-0.9491930519322896,0.11379916699314639},
{-0.8536636944550958,-0.4988787831365202,0.14959363791786615},
{-0.3742119487782898,-0.9231294759947604,0.08830281955404327},
{-0.8422232541050731,-0.36551009187295685,0.3963109422961773},
{-0.6062284570316752,0.009200431878408796,0.7952373293163777},
{-0.800580370009988,0.4791882504481467,0.35979117802847077},
{-0.5213078483487358,0.7084106652028476,0.47580716333076634},
{-0.22849600249740418,0.9256838053034881,0.3014947253959184},
{-0.12920223198783656,-0.7641132001695503,-0.6320109180829157},
{-0.3466995250219761,-0.8642988159114333,-0.3643995007730259},
{0.4208062953092671,-0.6340094848528407,-0.6488097062658092},
{0.3346981357365759,0.3512980432753484,-0.8743951296326918},
{0.4424058707648579,0.40390535985968823,-0.800710625500501},
{0.3269019303615982,0.7513044364657959,-0.573303385366486},
{-0.6256859816626196,-0.3283926424452681,0.707584146754786},
{-0.33860014898409835,-0.2504001101760727,0.9070003990802634},
{-0.45250964082059764,-0.00850018109828747,0.8917189982756396},
{0.9779492995328145,-0.20868918078987564,-0.007999585272252061},
{0.94774378203529,0.20360940595376706,0.24561134627821804},
{0.5896830114771554,0.4782862207724664,0.6507812512622227},
{0.8935799036139489,-0.4208905342783249,0.15609648942942864},
{0.899507241062436,-0.4291034542967107,-0.08220066171799026},
{0.5273120914048854,-0.34580792946673505,0.7761177965851159},
{-0.31608385010825746,-0.8312575279816339,-0.4572766360471564},
{-0.5978195819011131,-0.7806255698093155,-0.1823059715298978},
{0.7584086989976665,0.14990171938258204,-0.6343072755461759},
{0.6829823212314194,0.4998870605909027,-0.5325862141842664},
{0.8879824669592831,0.42499160862353075,-0.17569653090624554},
{0.9942162008849912,0.10410169635096317,0.026400430198515155},
{0.22141017956701378,-0.7665352422679135,0.6028277156413546},
{0.6883475871136026,-0.5358370436952903,0.4889338011620519},
{0.8639020690479331,-0.057200136994492154,0.5004011984623055},
{0.9390697107949596,-0.23409244946981153,0.2516918818092762},
{0.6799228083931678,0.6817228687772061,-0.27010906096042747},
{0.01750021201635288,-0.6686081002362019,-0.7434090064546701},
{-0.08650064918980825,-0.8095060753658935,-0.5807043582025625},
{0.8770855325934589,0.3292945683308927,-0.34969423184121834},
{0.750701032214629,0.5024006908014247,-0.42900058987621664},
{0.687207171044245,0.7077073849650933,0.16400171136678723},
{0.865432432688134,0.33671261854182427,0.3710139040065839},
{-0.1488925592802703,0.209289541016525,0.9664517027829499},
{-0.2530910736352466,0.08979683292155331,0.963266026206373},
{0.7016128957635372,0.4352079991965385,0.5642103702819096},
{0.907863223205727,0.35498561982380555,0.22309096276814372},
{0.5935132889113097,-0.08410188306224288,-0.8004179215578977},
{0.6270038372752262,-0.13400082008752842,-0.7674046965311142},
{0.4504836882809657,-0.27808993054591913,-0.8483692811044867},
{0.1395042200664865,-0.39911207332282983,-0.9062274137939073},
{0.3102808097253594,-0.3355792450655192,-0.8894449895285438},
{0.1541015957302857,-0.31880330122527634,-0.9352096841464193},
{0.4972858897130663,-0.2394932044767331,-0.8338763390945626},
{0.49611108572606716,0.08670193737643625,-0.8639193044925407},
{0.49778210505497916,0.3190885289735714,-0.8064710078883902},
{0.4010013313266301,-0.10000033200165338,-0.9106030232070557},
{0.6133934949964781,0.04139956095998402,-0.7886916359695505},
{0.5652999038990246,-0.26369995517101147,-0.781599867128034},
{0.7749003835757848,-0.1230000608850452,-0.6200003069002278},
{0.7776010847542698,0.26040036325876015,-0.5723007983601707},
{-0.6675918020230065,-0.7297910382210757,0.14739818996134085},
{-0.7107071035530003,-0.5034050315584357,-0.4914049116166376},
{-0.716927853188155,-0.6225241855344212,-0.31381219184048414},
{-0.7530581085426001,-0.4545747127120781,-0.4756735390170162},
{-0.9886355519736849,-0.03740134497654847,-0.14560523605843467},
{-0.9801722811198293,-0.18839467227400108,-0.06139826368165428},
{-0.31251156626710525,-0.826730597865651,0.4678173142392059},
{-0.7051935686639804,-0.6995936197352818,-0.1151989493903723},
{0.9702061268710368,0.105300664975799,-0.21820137794605263},
{0.8870104623501055,0.4046047723414348,-0.2225026244339329},
{0.9577346179434095,0.2649095753296536,-0.11210405207419465},
{0.9448944912811736,0.20739879086857382,0.25329852327391394},
{-0.041300943737346725,-0.9806224074780192,0.1915043759249854},
{-0.3959131801691554,0.017000565958261285,0.9181305650752755},
{0.0638974614042866,-0.23759056071453047,0.9692614920058686},
{0.9089279817786351,0.3431105628212672,-0.23690729330328822},
{0.8277047551774778,-0.5609032223982691,-0.017100098240346587},
{0.4272991689039248,0.6981986420049621,-0.5743988827952595},
{0.6290800616234152,0.6382797700432776,-0.4436859375970582},
{0.35540108575197543,0.8963027382090478,-0.26520081018971264},
{0.2834134567904002,0.9482450237426164,-0.14320679962027277},
{0.23869432510987995,0.968076984243296,-0.07649818127735994},
{0.20959183236543596,0.96626234549008,0.14969416653199313},
{0.8412758641416817,0.44198731956569987,-0.3112910691873357},
{0.9238335172880218,0.040801480304558664,-0.38061380891948593},
{-0.27540436106258637,-0.6331100253766283,-0.723411455311093},
{-0.5013848584059107,-0.746177465780795,-0.43798677299918015},
{0.8780802565873934,-0.0929979089655251,-0.46938944589696213},
{0.5590205779262172,0.8217302484471782,-0.11070407509200758},
{0.21869653478085938,0.9657846972627068,0.13939779125949608},
{0.18340902302883733,0.8989442246489742,0.3978195712152207},
{-0.7949027861391482,-0.18230063896485935,-0.5787020283541641},
{0.9424366190862657,0.3073119408374464,-0.1318051213874892},
{0.8463025939214256,0.5217015990178515,0.10770033010201764},
{0.7643077119037198,0.6438064960403178,-0.03670037030860463},
{0.544205711468913,0.7996083919341103,0.2539026647224495},
{0.27680393894807703,0.8403119577242383,0.4661066327445763},
{-0.0066997271256711444,0.8828640416798587,0.469580874360473},
{0.6321975565611658,0.6499974877645647,0.4216983701389491},
{0.8741171765712811,0.3933077285728004,0.2850056004150727},
{0.9929382834735433,0.10280396368323119,-0.05920228258800862},
{0.9308831558216917,0.2136961332034542,0.29629463859702143},
{0.3636001890721475,0.6194003220882512,0.6958003618162822},
{0.052802676107439404,0.6202314341256424,0.7826396651833727},
{-0.11760348287871895,0.391511594787572,0.9126270278496507},
{-0.022899993015503196,0.42179987135105884,0.9063997235481265},
{0.03799883630345704,0.6868789646538063,0.7257777733960294},
{-0.16429621301593444,0.27439367529867564,0.9474781608800846},
{0.9264048497420826,0.3469018160357604,-0.14640076641001823},
{0.9896204556662301,0.11130230064233165,-0.09090187896125738},
{0.8412261919852375,0.14980466424083283,-0.5195161753879349},
{0.836887869398249,0.09929856067779438,-0.5382921975111452},
{0.804404810355149,-0.1842011015258807,-0.5648033775342965},
{0.8941989761427585,0.39909954303128486,-0.20279976779439882},
{0.681953584408862,0.7257506034662052,-0.09069382713472696},
{0.9782167178665637,-0.1063018167135716,0.17830304722511583},
{0.8438062610656858,0.5236038851552418,-0.11760087260171206},
{0.16380765245323073,0.9237431536694091,0.3462161738663521},
{0.2751054127522444,0.9380184556946756,0.21080414761240682},
{-0.10990139245946375,0.9367118682145559,0.3324042115880414},
{-0.5332900862294446,0.5297901512926304,0.6594877402368624},
{0.5968975974920051,0.45619816380608597,0.6599973435160386},
{0.5949145726109364,0.5044123557319823,0.6258153295342478},
{0.35838989175565256,-0.023599334390160157,0.9332736773871387},
{0.6820073623092144,-0.7196077682077869,-0.13050140877031155},
{0.9314810585252603,-0.22109550406863665,-0.28889412539768944},
{0.02070053439119305,0.043801130740785295,0.9988257850204647},
{0.3446949433622711,0.07019897018866095,0.9360862677151783},
{0.5856803858923092,0.5484816316577286,-0.5967800141719826},
{0.7066003780313034,0.49760026621621367,0.503100269158716},
{0.5650906167482127,0.814786470582983,-0.12959784804559965},
{0.3116035741134927,0.16650190978785798,-0.9355107303696163},
{0.1632023232016063,-0.552007857887786,-0.8177116402080481},
{0.87006856499061,0.012099562850691163,0.4927821961008765},
{0.5645962482703953,-0.23969840720937613,0.789794751831311},
{-0.004300018296616778,-0.7606032363736562,0.6492027623636308},
{-0.011999913000946114,0.4296968847088788,0.9028934540461873},
{-0.705764356271257,0.11909398531015403,0.698364729979946},
{-0.3102808097253594,-0.3355792450655192,-0.8894449895285438},
{-0.9308831558216917,0.2136961332034542,0.29629463859702143},
{-0.33828601723646035,-0.8992628297391333,0.27728853851513585},
{0.8368885305212832,0.1837974810727827,0.515592933847262},
{-0.9069022808621044,-0.22600056839214425,0.35560089433737385}
};


// face array: 29kb.
const uint16_t donkeykong_small_face[15243] PROGMEM = {
6, // chain 0
0,0,0, 1,1,1, 2,2,2, 
3,3,3, 32772,4,4, 32773,5,5, 32774,6,6, 32769,1,1, 
6, // chain 1
7,7,7, 8,8,8, 9,9,9, 
10,10,10, 32779,11,11, 32780,12,12, 32781,13,13, 32776,8,8, 
2, // chain 2
14,14,14, 15,15,15, 5,5,5, 
6,6,6, 
4, // chain 3
8,16,8, 16,17,16, 17,18,17, 
32786,19,18, 32787,20,19, 32788,21,20, 
27, // chain 4
14,22,14, 21,23,21, 15,24,15, 
32790,25,22, 32791,26,23, 32792,27,24, 32793,28,25, 26,29,26, 32795,30,27, 32796,31,28, 29,32,29, 32798,33,30, 31,34,31, 32,35,32, 33,36,33, 26,29,26, 32802,37,34, 35,38,35, 32804,39,36, 
37,40,37, 32806,41,38, 32807,42,39, 40,43,40, 32809,44,41, 32810,45,42, 43,46,43, 44,47,44, 32813,48,45, 32814,49,46, 
4, // chain 5
47,50,47, 48,51,48, 49,52,49, 
32818,53,50, 32819,54,51, 32820,55,52, 
4, // chain 6
53,56,53, 54,57,54, 55,58,55, 
56,59,56, 57,60,57, 32826,61,58, 
3, // chain 7
59,62,59, 60,63,60, 61,64,61, 
32830,65,62, 32831,66,63, 
6, // chain 8
64,67,64, 65,68,65, 66,69,66, 
67,70,67, 68,71,68, 32837,72,69, 70,73,70, 32839,74,71, 
17, // chain 9
72,75,72, 73,76,73, 74,77,74, 
32843,78,75, 32822,57,54, 76,79,76, 32845,80,77, 32846,81,78, 32821,56,53, 79,82,79, 32825,60,57, 80,83,80, 32849,84,81, 32850,85,82, 32851,86,83, 32826,87,58, 84,88,84, 32853,89,85, 32841,76,73, 
1, // chain 10
74,90,74, 86,91,86, 72,92,72, 
4, // chain 11
87,93,87, 88,94,88, 89,95,89, 
31,96,31, 90,97,90, 32798,98,30, 
1, // chain 12
87,99,87, 91,100,91, 88,101,88, 
5, // chain 13
92,102,92, 93,103,93, 94,104,94, 
95,105,95, 32864,106,96, 97,107,97, 32866,108,98, 
1, // chain 14
99,109,99, 97,110,97, 98,111,98, 
28, // chain 15
100,112,100, 101,113,101, 102,114,102, 
103,115,103, 32872,116,104, 32873,117,105, 32869,113,101, 106,118,106, 32875,119,107, 32876,120,108, 32877,121,109, 32868,112,100, 110,122,110, 32879,123,111, 32880,124,112, 32871,115,103, 113,125,113, 32882,126,114, 32872,116,104, 
115,127,115, 32884,128,116, 32885,129,117, 32873,117,105, 118,130,118, 32887,131,119, 32874,118,106, 120,132,120, 32875,119,107, 121,133,121, 32890,134,122, 
31, // chain 16
111,123,111, 112,124,112, 123,135,123, 
124,136,124, 32893,137,125, 32894,138,126, 32895,139,127, 32896,140,128, 32897,141,129, 32880,124,112, 113,125,113, 130,142,130, 32882,126,114, 131,143,131, 32900,144,132, 32883,127,115, 116,128,116, 133,145,133, 32902,146,134, 
32903,147,135, 32885,129,117, 136,148,136, 32886,130,118, 137,149,137, 32906,150,138, 32887,131,119, 139,151,139, 32908,152,140, 32888,132,120, 141,153,141, 32889,133,121, 142,154,142, 32911,155,143, 
9, // chain 17
144,156,144, 145,157,145, 146,158,146, 
32915,159,147, 32916,160,148, 32917,161,149, 32918,162,150, 32919,163,151, 32920,164,152, 153,165,153, 32922,166,154, 
9, // chain 18
155,167,155, 150,162,150, 156,168,156, 
157,169,157, 32926,170,158, 32927,171,159, 32918,162,150, 160,172,160, 32919,163,151, 153,165,153, 161,173,161, 
5, // chain 19
162,174,162, 163,175,163, 164,176,164, 
165,177,165, 32934,178,166, 32935,179,167, 168,180,168, 
3, // chain 20
169,181,169, 170,182,170, 171,183,171, 
172,184,172, 32941,185,173, 
24, // chain 21
174,186,174, 175,187,175, 176,188,176, 
177,189,177, 32946,190,178, 32947,191,179, 32948,192,180, 32949,193,181, 32943,187,175, 182,194,182, 32951,195,183, 32952,196,184, 32942,186,174, 185,197,185, 32954,198,186, 32955,199,187, 32956,200,188, 32945,189,177, 189,201,189, 
32958,202,190, 32946,190,178, 191,203,191, 32947,191,179, 192,204,192, 32961,205,193, 194,206,194, 
4, // chain 22
195,207,195, 169,208,169, 196,209,196, 
197,210,197, 32966,211,198, 32967,212,199, 
7, // chain 23
200,213,200, 201,214,201, 202,215,202, 
203,216,203, 32972,217,204, 32973,218,205, 32974,219,206, 32975,220,207, 32969,214,201, 
7, // chain 24
208,221,208, 199,222,199, 196,223,196, 
172,224,172, 200,225,200, 32941,226,173, 201,227,201, 32977,228,209, 207,229,207, 
5, // chain 25
210,230,210, 198,231,198, 199,232,199, 
211,233,211, 32980,234,212, 32981,235,213, 32976,236,208, 
4, // chain 26
189,201,189, 190,202,190, 214,237,214, 
32983,238,215, 32984,239,216, 32959,203,191, 
7, // chain 27
215,238,215, 217,240,217, 214,237,214, 
32986,241,218, 219,242,219, 32988,243,220, 32989,244,221, 32990,245,222, 32991,246,223, 
5, // chain 28
19,247,19, 20,248,20, 0,0,0, 
224,249,224, 32993,250,225, 32994,251,226, 32771,3,3, 
3, // chain 29
227,252,227, 228,253,228, 21,254,21, 
14,255,14, 6,256,6, 
4, // chain 30
69,257,69, 67,258,67, 71,259,71, 
32997,260,229, 32834,261,66, 65,262,65, 
2, // chain 31
230,263,230, 231,264,231, 232,265,232, 
33001,266,233, 
4, // chain 32
234,267,234, 235,268,235, 236,269,236, 
33005,270,237, 33006,271,238, 33007,272,239, 
3, // chain 33
240,273,240, 241,274,241, 242,275,242, 
243,276,243, 32998,277,230, 
3, // chain 34
244,278,244, 245,279,245, 246,280,246, 
33015,281,247, 33016,282,248, 
3, // chain 35
249,283,249, 250,284,250, 251,285,251, 
252,286,252, 33021,287,253, 
9, // chain 36
254,288,254, 255,289,255, 256,290,256, 
33025,291,257, 33026,292,258, 33027,293,259, 260,294,260, 261,295,261, 33030,296,262, 248,297,248, 33015,298,247, 
4, // chain 37
263,299,263, 264,300,264, 265,301,265, 
266,302,266, 33035,303,267, 268,304,268, 
7, // chain 38
269,305,269, 270,306,270, 271,307,271, 
272,308,272, 33041,309,273, 32813,310,45, 33042,311,274, 33043,312,275, 33038,306,270, 
6, // chain 39
152,313,152, 276,314,276, 277,315,277, 
154,316,154, 33036,317,268, 33046,318,278, 33047,319,279, 33044,314,276, 
2, // chain 40
280,320,280, 281,321,281, 282,322,282, 
33051,323,283, 
22, // chain 41
284,324,284, 285,325,285, 286,326,286, 
287,327,287, 33056,328,288, 33053,325,285, 289,329,289, 33058,330,290, 33059,331,291, 33060,332,292, 33052,324,284, 293,333,293, 33055,327,287, 294,334,294, 33063,335,295, 33064,336,296, 33065,337,297, 33056,328,288, 289,329,289, 
298,338,298, 33067,339,299, 33058,330,290, 300,340,300, 33059,331,291, 
7, // chain 42
301,341,301, 50,342,50, 302,343,302, 
63,344,63, 33071,345,303, 33072,346,304, 32786,19,18, 32785,18,17, 32818,342,50, 
11, // chain 43
305,347,305, 306,348,306, 307,349,307, 
308,350,308, 33077,351,309, 33078,352,310, 33079,353,311, 33074,348,306, 312,354,312, 33081,355,313, 33082,356,314, 33083,357,315, 33073,347,305, 
5, // chain 44
316,358,316, 312,354,312, 313,355,313, 
317,359,317, 33082,356,314, 280,360,280, 33086,361,318, 
3, // chain 45
300,362,300, 316,358,316, 317,359,317, 
283,363,283, 33050,364,282, 
1, // chain 46
299,339,299, 300,340,300, 283,365,283, 
12, // chain 47
319,366,319, 320,367,320, 308,368,308, 
33089,369,321, 33090,370,322, 323,371,323, 324,372,324, 33093,373,325, 326,374,326, 33095,375,327, 328,376,328, 329,377,329, 33098,378,330, 33099,379,331, 
9, // chain 48
332,380,332, 333,381,333, 334,382,334, 
33103,383,335, 336,384,336, 337,385,337, 33106,386,338, 339,387,339, 33108,388,340, 33109,389,341, 33110,390,342, 
4, // chain 49
343,391,343, 206,392,206, 344,393,344, 
33113,394,345, 32977,395,209, 32975,396,207, 
10, // chain 50
346,397,346, 343,391,343, 344,393,344, 
347,398,347, 33116,399,348, 33117,400,349, 350,401,350, 351,402,351, 33120,403,352, 33121,404,353, 354,405,354, 33123,406,355, 
1, // chain 51
291,331,291, 292,332,292, 356,407,356, 
9, // chain 52
357,408,357, 300,409,300, 291,410,291, 
356,411,356, 358,412,358, 33127,413,359, 32977,395,209, 33113,394,345, 33060,414,292, 344,393,344, 33061,415,293, 
4, // chain 53
332,380,332, 334,382,334, 337,385,337, 
360,416,360, 33129,417,361, 33130,418,362, 
10, // chain 54
363,419,363, 364,420,364, 365,421,365, 
366,422,366, 33135,423,367, 33136,424,368, 33137,425,369, 33132,420,364, 370,426,370, 33139,427,371, 33131,419,363, 335,428,335, 
7, // chain 55
299,339,299, 283,429,283, 372,430,372, 
298,338,298, 33141,431,373, 374,432,374, 33143,433,375, 33144,434,376, 33145,435,377, 
14, // chain 56
343,436,343, 346,437,346, 378,438,378, 
33147,439,379, 33148,440,380, 33115,441,347, 381,442,381, 33116,443,348, 382,444,382, 33151,445,383, 384,446,384, 385,447,385, 381,442,381, 33154,448,386, 380,440,380, 33147,439,379, 
3, // chain 57
387,449,387, 198,450,198, 379,451,379, 
386,452,386, 385,453,385, 
11, // chain 58
203,216,203, 204,217,204, 212,454,212, 
32979,455,211, 32978,456,210, 32973,218,205, 388,457,388, 32974,219,206, 389,458,389, 33111,436,343, 378,438,378, 390,459,390, 33147,439,379, 
3, // chain 59
203,216,203, 212,454,212, 213,460,213, 
208,461,208, 200,213,200, 
9, // chain 60
391,462,391, 392,463,392, 357,408,357, 
358,412,358, 393,464,393, 32935,465,167, 33162,466,394, 33163,467,395, 33127,413,359, 171,468,171, 32941,469,173, 
6, // chain 61
396,470,396, 392,463,392, 391,462,391, 
397,471,397, 33161,464,393, 398,472,398, 33167,473,399, 32935,465,167, 
4, // chain 62
312,354,312, 392,474,392, 396,475,396, 
400,476,400, 33165,477,397, 401,478,401, 
2, // chain 63
402,479,402, 403,480,403, 367,423,367, 
368,424,368, 
2, // chain 64
363,481,363, 366,482,366, 336,483,336, 
335,484,335, 
1, // chain 65
366,482,366, 338,485,338, 336,483,336, 
1, // chain 66
366,486,366, 342,487,342, 338,488,338, 
5, // chain 67
404,489,404, 341,490,341, 342,487,342, 
405,491,405, 406,492,406, 33175,493,407, 33176,494,408, 
13, // chain 68
341,495,341, 404,489,404, 406,492,406, 
409,496,409, 33178,497,410, 33175,493,407, 411,498,411, 412,499,412, 33181,500,413, 414,501,414, 399,502,399, 415,503,415, 32931,175,163, 32932,176,164, 32935,504,167, 
4, // chain 69
394,505,394, 395,506,395, 170,507,170, 
416,508,416, 33185,509,417, 32953,510,185, 
1, // chain 70
395,506,395, 171,511,171, 170,507,170, 
1, // chain 71
196,512,196, 169,181,169, 172,184,172, 
5, // chain 72
394,513,394, 416,514,416, 167,515,167, 
32936,516,168, 33186,517,418, 33185,518,417, 419,519,419, 
8, // chain 73
373,520,373, 281,521,281, 420,522,420, 
377,523,377, 33189,524,421, 33190,525,422, 33191,526,423, 33086,527,318, 33048,528,280, 33049,521,281, 
3, // chain 74
424,529,424, 198,450,198, 387,449,387, 
425,530,425, 33194,531,426, 
14, // chain 75
197,532,197, 198,533,198, 424,534,424, 
427,535,427, 33193,536,425, 428,537,428, 33197,538,429, 430,539,430, 431,540,431, 432,541,432, 33201,542,433, 434,543,434, 33203,544,435, 436,545,436, 33205,546,437, 33206,547,438, 
1, // chain 76
184,196,184, 185,197,185, 169,548,169, 
1, // chain 77
170,182,170, 169,181,169, 185,549,185, 
8, // chain 78
439,550,439, 440,551,440, 410,497,410, 
412,499,412, 415,503,415, 441,552,441, 33210,553,442, 33211,554,443, 32931,175,163, 162,174,162, 
8, // chain 79
440,555,440, 444,556,444, 409,557,409, 
33213,558,445, 446,559,446, 33215,560,447, 33216,561,448, 449,562,449, 33218,563,450, 451,564,451, 
7, // chain 80
195,565,195, 197,532,197, 427,535,427, 
182,566,182, 32949,567,181, 33220,568,452, 33221,569,453, 33200,541,432, 33196,537,428, 
2, // chain 81
454,570,454, 195,565,195, 182,566,182, 
183,571,183, 
2, // chain 82
455,572,455, 456,573,456, 457,574,457, 
458,575,458, 
3, // chain 83
459,576,459, 460,577,460, 24,27,24, 
35,38,35, 32794,29,26, 
2, // chain 84
461,578,461, 4,4,4, 5,5,5, 
462,579,462, 
6, // chain 85
463,580,463, 464,581,464, 88,582,88, 
91,583,91, 246,280,246, 33012,278,244, 32855,584,87, 90,585,90, 
9, // chain 86
465,586,465, 466,587,466, 467,588,467, 
468,589,468, 33237,590,469, 33238,591,470, 33239,592,471, 33240,593,472, 33234,587,466, 244,594,244, 33013,595,245, 
3, // chain 87
473,596,473, 474,597,474, 475,598,475, 
33244,599,476, 33245,600,477, 
8, // chain 88
478,601,478, 477,602,477, 474,603,474, 
479,604,479, 33248,605,480, 481,606,481, 482,607,482, 478,601,478, 32820,608,52, 33251,609,483, 
1, // chain 89
11,11,11, 12,12,12, 483,610,483, 
4, // chain 90
13,611,13, 8,612,8, 12,613,12, 
33251,614,483, 32819,615,51, 32785,616,17, 
1, // chain 91
17,617,17, 50,53,50, 51,54,51, 
3, // chain 92
484,618,484, 476,619,476, 485,620,485, 
486,621,486, 33255,622,487, 
1, // chain 93
476,619,476, 477,623,477, 485,620,485, 
4, // chain 94
484,624,484, 488,625,488, 476,626,476, 
33257,627,489, 33258,628,490, 33259,629,491, 
7, // chain 95
492,630,492, 476,626,476, 489,627,489, 
493,631,493, 33258,628,490, 494,632,494, 33263,633,495, 33264,634,496, 33265,635,497, 
4, // chain 96
494,632,494, 469,636,469, 493,631,493, 
33266,637,498, 492,630,492, 33267,638,499, 
11, // chain 97
466,639,466, 465,640,465, 500,641,500, 
245,642,245, 33025,291,257, 33024,290,256, 33269,643,501, 33233,640,465, 502,644,502, 33236,645,468, 503,646,503, 504,647,504, 33273,648,505, 
6, // chain 98
506,649,506, 486,650,486, 487,651,487, 
507,652,507, 32816,653,48, 33246,654,478, 33253,655,485, 477,656,477, 
6, // chain 99
508,657,508, 509,658,509, 510,659,510, 
511,660,511, 33280,661,512, 513,662,513, 497,663,497, 33264,664,496, 
2, // chain 100
491,665,491, 508,657,508, 497,663,497, 
490,666,490, 
1, // chain 101
495,633,495, 496,634,496, 505,667,505, 
4, // chain 102
494,668,494, 495,669,495, 505,670,505, 
503,671,503, 469,672,469, 33236,673,468, 
2, // chain 103
254,288,254, 256,290,256, 514,674,514, 
99,675,99, 
5, // chain 104
515,676,515, 464,581,464, 516,677,516, 
33231,580,463, 517,678,517, 33015,281,247, 33014,280,246, 
2, // chain 105
518,679,518, 519,680,519, 229,681,229, 
65,682,65, 
5, // chain 106
20,683,20, 16,684,16, 520,685,520, 
1,686,1, 33289,687,521, 6,688,6, 33290,689,522, 
5, // chain 107
515,690,515, 523,691,523, 518,679,518, 
33287,680,519, 33072,346,304, 33292,692,524, 33293,693,525, 
6, // chain 108
523,694,523, 515,676,515, 516,677,516, 
525,695,525, 33285,678,517, 526,696,526, 33030,697,262, 33015,281,247, 
5, // chain 109
527,698,527, 260,699,260, 259,700,259, 
528,701,528, 32867,702,99, 33022,703,254, 33023,704,255, 
3, // chain 110
529,705,529, 260,699,260, 527,698,527, 
93,706,93, 92,707,92, 
2, // chain 111
303,708,303, 304,709,304, 97,710,97, 
33298,711,530, 
4, // chain 112
95,105,95, 97,107,97, 530,712,530, 
524,713,524, 531,714,531, 33293,715,525, 
8, // chain 113
529,716,529, 92,717,92, 532,718,532, 
260,719,260, 33030,720,262, 33294,721,526, 33301,722,533, 32860,717,92, 531,723,531, 526,724,526, 
4, // chain 114
534,725,534, 519,680,519, 304,346,304, 
18,19,18, 535,726,535, 32787,20,19, 
4, // chain 115
60,727,60, 59,728,59, 536,729,536, 
33305,730,537, 33280,731,512, 33306,732,538, 
6, // chain 116
513,733,513, 539,734,539, 540,735,540, 
496,736,496, 33309,737,541, 505,670,505, 33310,738,542, 504,739,504, 
7, // chain 117
536,740,536, 543,741,543, 544,742,544, 
60,743,60, 33313,744,545, 49,745,49, 32815,746,47, 33275,652,507, 33314,747,546, 
2, // chain 118
543,741,543, 510,748,510, 544,742,544, 
33277,749,509, 
1, // chain 119
528,701,528, 99,702,99, 98,750,98, 
3, // chain 120
94,751,94, 547,752,547, 548,753,548, 
549,754,549, 32830,755,62, 
3, // chain 121
549,756,549, 62,757,62, 63,344,63, 
303,345,303, 514,758,514, 
4, // chain 122
62,65,62, 548,759,548, 61,64,61, 
33307,760,539, 33315,761,547, 550,762,550, 
2, // chain 123
61,64,61, 539,760,539, 538,763,538, 
59,62,59, 
6, // chain 124
527,764,527, 551,765,551, 552,766,552, 
33310,767,542, 541,768,541, 540,769,540, 550,770,550, 33307,771,539, 
3, // chain 125
506,772,506, 546,773,546, 544,774,544, 
509,775,509, 486,776,486, 
1, // chain 126
507,652,507, 48,653,48, 47,746,47, 
7, // chain 127
8,8,8, 7,7,7, 520,777,520, 
33289,778,521, 33321,779,553, 33322,780,554, 33323,781,555, 32778,10,10, 556,782,556, 
1, // chain 128
553,779,553, 522,783,522, 521,778,521, 
2, // chain 129
90,784,90, 557,785,557, 472,593,472, 
244,594,244, 
7, // chain 130
558,786,558, 499,787,499, 470,591,470, 
553,788,553, 33327,789,559, 33239,592,471, 228,790,228, 33325,785,557, 33240,593,472, 
4, // chain 131
499,791,499, 558,792,558, 473,596,473, 
492,793,492, 33243,598,475, 476,794,476, 
6, // chain 132
462,795,462, 5,796,5, 15,24,15, 
22,25,22, 560,797,560, 32791,26,23, 460,577,460, 32792,27,24, 
4, // chain 133
36,798,36, 34,799,34, 39,800,39, 
33329,801,561, 33330,802,562, 32801,803,33, 
5, // chain 134
39,800,39, 561,801,561, 42,804,42, 
33331,805,563, 33332,806,564, 33333,807,565, 33330,802,562, 
10, // chain 135
41,44,41, 566,808,566, 440,809,440, 
40,43,40, 33335,810,567, 568,811,568, 569,812,569, 33338,813,570, 571,814,571, 33340,815,572, 33341,816,573, 574,817,574, 
1, // chain 136
440,809,440, 566,808,566, 444,818,444, 
3, // chain 137
44,47,44, 575,819,575, 576,820,576, 
566,808,566, 41,44,41, 
9, // chain 138
576,821,576, 575,822,575, 577,823,577, 
578,824,578, 33347,825,579, 33348,826,580, 33349,827,581, 33350,828,582, 33343,822,575, 274,829,274, 32812,830,44, 
9, // chain 139
129,141,129, 130,142,130, 128,140,128, 
33351,831,583, 33352,832,584, 33353,833,585, 32899,143,131, 586,834,586, 32900,144,132, 587,835,587, 32901,145,133, 
5, // chain 140
588,836,588, 124,136,124, 589,837,589, 
590,838,590, 33359,839,591, 32893,137,125, 32892,136,124, 
7, // chain 141
592,840,592, 593,841,593, 594,842,594, 
595,843,595, 596,844,596, 33365,845,597, 598,846,598, 599,847,599, 33368,848,600, 
10, // chain 142
601,849,601, 593,841,593, 592,840,592, 
596,844,596, 599,847,599, 602,850,602, 603,851,603, 604,852,604, 33373,853,605, 606,854,606, 33375,855,607, 33376,856,608, 
10, // chain 143
602,857,602, 599,858,599, 600,859,600, 
609,860,609, 33378,861,610, 33379,862,611, 33366,863,598, 81,864,81, 612,865,612, 33381,866,613, 33382,867,614, 32850,868,82, 
4, // chain 144
615,869,615, 616,870,616, 617,871,617, 
618,872,618, 33387,873,619, 33384,870,616, 
5, // chain 145
616,874,616, 620,875,620, 619,876,619, 
33389,877,621, 33390,878,622, 623,879,623, 33392,880,624, 
6, // chain 146
625,881,625, 624,882,624, 622,883,622, 
626,884,626, 627,885,627, 33396,886,628, 86,887,86, 33397,888,629, 
8, // chain 147
624,882,624, 625,881,625, 630,889,630, 
631,890,631, 33400,891,632, 33401,892,633, 33402,893,634, 33393,881,625, 627,885,627, 86,887,86, 
5, // chain 148
85,894,85, 73,895,73, 72,896,72, 
635,897,635, 33404,898,636, 32854,899,86, 629,900,629, 
10, // chain 149
148,901,148, 637,902,637, 638,903,638, 
639,904,639, 33408,905,640, 33409,906,641, 33410,907,642, 33405,902,637, 643,908,643, 644,909,644, 33413,910,645, 32851,911,83, 
17, // chain 150
646,912,646, 639,904,639, 640,905,640, 
647,913,647, 33416,914,648, 33409,906,641, 649,915,649, 33418,916,650, 33410,907,642, 651,917,651, 33412,909,644, 652,918,652, 33421,919,653, 33413,910,645, 654,920,654, 33423,921,655, 32852,922,84, 85,894,85, 635,897,635, 
4, // chain 151
646,923,646, 656,924,656, 657,925,657, 
33426,926,658, 33427,927,659, 33428,928,660, 
3, // chain 152
661,929,661, 662,930,662, 663,931,663, 
649,932,649, 33416,933,648, 
3, // chain 153
661,934,661, 664,935,664, 665,936,665, 
32999,937,231, 33434,938,666, 
5, // chain 154
662,939,662, 665,940,665, 242,275,242, 
241,274,241, 647,941,647, 33435,942,667, 33008,273,240, 
2, // chain 155
668,943,668, 669,944,669, 655,945,655, 
635,946,635, 
9, // chain 156
636,947,636, 629,948,629, 670,949,670, 
33439,950,671, 33440,951,672, 33396,886,628, 673,952,673, 674,953,674, 675,954,675, 33444,955,676, 677,956,677, 
6, // chain 157
669,944,669, 678,957,678, 679,958,679, 
680,959,680, 681,960,681, 33450,961,682, 32998,962,230, 33011,963,243, 
7, // chain 158
683,964,683, 267,965,267, 684,966,684, 
159,967,159, 33453,968,685, 33454,969,686, 33032,970,264, 33033,971,265, 33035,965,267, 
3, // chain 159
161,972,161, 268,973,268, 267,965,267, 
683,964,683, 160,974,160, 
1, // chain 160
268,317,268, 278,318,278, 266,975,266, 
3, // chain 161
263,299,263, 266,302,266, 278,976,278, 
687,977,687, 33047,978,279, 
4, // chain 162
688,979,688, 689,980,689, 263,981,263, 
687,982,687, 146,983,146, 32912,984,144, 
7, // chain 163
690,985,690, 691,986,691, 689,987,689, 
688,988,688, 692,989,692, 693,990,693, 33427,991,659, 33426,992,658, 33462,993,694, 
3, // chain 164
691,986,691, 690,985,690, 693,990,693, 
667,994,667, 33428,995,660, 
1, // chain 165
693,996,693, 659,997,659, 660,998,660, 
7, // chain 166
694,999,694, 692,1000,692, 695,1001,695, 
33456,1002,688, 146,158,146, 147,159,147, 696,1003,696, 657,1004,657, 694,999,694, 
3, // chain 167
675,954,675, 697,1005,697, 698,1006,698, 
672,951,672, 33439,950,671, 
4, // chain 168
699,1007,699, 698,1008,698, 697,1009,697, 
686,969,686, 33445,1010,677, 33443,1011,675, 
6, // chain 169
700,1012,700, 159,171,159, 676,1013,676, 
674,1014,674, 673,1015,673, 158,170,158, 33394,1016,626, 33396,1017,628, 
1, // chain 170
700,1012,700, 158,170,158, 159,171,159, 
4, // chain 171
147,1018,147, 148,901,148, 639,904,639, 
696,1019,696, 33414,912,646, 657,1020,657, 
2, // chain 172
643,1021,643, 637,1022,637, 614,1023,614, 
82,1024,82, 
1, // chain 173
82,85,82, 83,86,83, 643,1025,643, 
1, // chain 174
56,1026,56, 55,1027,55, 58,1028,58, 
9, // chain 175
615,869,615, 701,1029,701, 702,1030,702, 
703,1031,703, 33472,1032,704, 33473,1033,705, 33469,1029,701, 706,1034,706, 33475,1035,707, 33386,872,618, 33383,869,615, 
8, // chain 176
632,1036,632, 633,1037,633, 708,1038,708, 
709,1039,709, 33478,1040,710, 32844,1041,76, 32843,1042,75, 33401,1037,633, 74,1043,74, 33402,1044,634, 
4, // chain 177
711,1045,711, 712,1046,712, 623,879,623, 
631,1047,631, 713,1048,713, 33482,1049,714, 
14, // chain 178
705,1033,705, 706,1034,706, 715,1050,715, 
603,1051,603, 33373,1052,605, 33484,1053,716, 33474,1034,706, 717,1054,717, 33486,1055,718, 33475,1035,707, 719,1056,719, 33488,1057,720, 33386,872,618, 721,1058,721, 33387,873,619, 722,1059,722, 
6, // chain 179
593,841,593, 601,849,601, 604,852,604, 
606,854,606, 723,1060,723, 33492,1061,724, 33375,855,607, 725,1062,725, 
6, // chain 180
726,1063,726, 588,1064,588, 727,1065,727, 
724,1061,724, 33491,1060,723, 33361,841,593, 33362,842,594, 33496,1066,728, 
7, // chain 181
124,136,124, 588,836,588, 729,1067,729, 
111,123,111, 33498,1068,730, 33499,1069,731, 33500,1070,732, 33356,836,588, 726,1071,726, 
7, // chain 182
733,1072,733, 731,1073,731, 734,1074,734, 
33503,1075,735, 736,1076,736, 737,1077,737, 33506,1078,738, 33493,1079,725, 33503,1080,735, 
6, // chain 183
724,1061,724, 725,1081,725, 735,1082,735, 
726,1063,726, 33507,1083,739, 33499,1084,731, 732,1085,732, 726,1063,726, 
4, // chain 184
110,122,110, 111,123,111, 730,1068,730, 
740,1086,740, 33501,1087,733, 33499,1069,731, 
9, // chain 185
76,1041,76, 77,1088,77, 710,1040,710, 
33509,1089,741, 33510,1090,742, 743,1091,743, 33512,1092,744, 590,838,590, 33496,1093,728, 33362,1094,594, 33363,1095,595, 
7, // chain 186
742,1096,742, 77,80,77, 78,81,78, 
745,1097,745, 32847,82,79, 597,1098,597, 32848,83,80, 598,1099,598, 32849,84,81, 
6, // chain 187
710,1040,710, 741,1089,741, 746,1100,746, 
709,1039,709, 33515,1101,747, 33516,1102,748, 33509,1089,741, 743,1091,743, 
2, // chain 188
709,1039,709, 749,1103,749, 714,1104,714, 
632,1036,632, 
1, // chain 189
713,1105,713, 714,1104,714, 749,1103,749, 
3, // chain 190
750,1106,750, 711,1107,711, 713,1108,713, 
751,1109,751, 33517,1110,749, 
6, // chain 191
721,1111,721, 722,1112,722, 752,1113,752, 
753,1114,753, 33522,1115,754, 33479,1107,711, 33480,1116,712, 33490,1112,722, 
2, // chain 192
608,1117,608, 605,1052,605, 716,1053,716, 
755,1118,755, 
6, // chain 193
733,1072,733, 734,1074,734, 756,1119,756, 
757,1120,757, 33526,1121,758, 33527,1122,759, 33505,1077,737, 33502,1074,734, 
2, // chain 194
109,121,109, 110,122,110, 740,1086,740, 
757,1123,757, 
12, // chain 195
458,1124,458, 457,574,457, 760,1125,760, 
761,1126,761, 33530,1127,762, 33531,1128,763, 32955,199,187, 33225,574,457, 186,198,186, 33224,573,456, 417,1129,417, 33187,1130,419, 33532,1131,764, 33533,1132,765, 
5, // chain 196
761,1133,761, 570,1134,570, 441,552,441, 
33336,1135,568, 567,1136,567, 439,550,439, 33208,551,440, 
16, // chain 197
766,1137,766, 459,576,459, 37,40,37, 
767,1138,767, 33536,1139,768, 32806,41,38, 40,43,40, 569,812,569, 769,1140,769, 33538,1141,770, 33339,814,571, 771,1142,771, 33340,815,572, 772,1143,772, 773,1144,773, 774,1145,774, 33543,1146,775, 33544,1147,776, 
9, // chain 198
777,1148,777, 459,576,459, 766,1137,766, 
778,1149,778, 33547,1150,779, 33535,1138,767, 780,1151,780, 33539,1142,771, 33538,1141,770, 33537,1140,769, 33536,1139,768, 
2, // chain 199
777,1148,777, 781,1152,781, 460,577,460, 
33328,797,560, 
6, // chain 200
782,1153,782, 68,71,68, 783,1154,783, 
784,1155,784, 33553,1156,785, 32992,1157,224, 32838,73,70, 32836,71,68, 
10, // chain 201
64,67,64, 68,71,68, 782,1153,782, 
786,1158,786, 33005,270,237, 33552,1155,784, 236,269,236, 33555,1159,787, 33556,1160,788, 33557,1161,789, 33558,1162,790, 33553,1156,785, 
1, // chain 202
253,287,253, 791,1163,791, 792,1164,792, 
2, // chain 203
793,1165,793, 32,1166,32, 89,1167,89, 
32799,1168,31, 
5, // chain 204
794,1169,794, 46,1170,46, 563,1171,563, 
238,1172,238, 239,1173,239, 273,1174,273, 46,1170,46, 
3, // chain 205
127,139,127, 128,140,128, 795,1175,795, 
796,1176,796, 126,138,126, 
1, // chain 206
591,839,591, 743,1091,743, 590,838,590, 
12, // chain 207
797,1177,797, 622,1178,622, 620,1179,620, 
616,870,616, 798,1180,798, 33383,869,615, 799,1181,799, 33471,1031,703, 610,861,610, 33472,1032,704, 609,860,609, 33473,1033,705, 602,857,602, 33371,1051,603, 
2, // chain 208
155,167,155, 799,1182,799, 149,161,149, 
150,162,150, 
4, // chain 209
637,1022,637, 148,1183,148, 613,1184,613, 
33568,1185,800, 32917,1186,149, 799,1187,799, 
1, // chain 210
614,1023,614, 637,1022,637, 613,1184,613, 
1, // chain 211
613,1184,613, 800,1185,800, 612,1188,612, 
2, // chain 212
742,1096,742, 745,1097,745, 744,1189,744, 
33363,1190,595, 
10, // chain 213
719,1056,719, 721,1058,721, 753,1191,753, 
801,1192,801, 802,1193,802, 718,1055,718, 33571,1194,803, 804,1195,804, 33573,1196,805, 33574,1197,806, 807,1198,807, 33576,1199,808, 
1, // chain 214
721,1058,721, 719,1056,719, 720,1057,720, 
10, // chain 215
607,1200,607, 755,1201,755, 809,1202,809, 
725,1079,725, 33506,1078,738, 33578,1203,810, 33579,1204,811, 33580,1205,812, 33523,1201,755, 813,1206,813, 33572,1207,804, 33484,1208,716, 
4, // chain 216
108,1209,108, 109,1210,109, 757,1120,757, 
814,1211,814, 33526,1121,758, 815,1212,815, 
6, // chain 217
816,1213,816, 134,146,134, 817,1214,817, 
818,1215,818, 33587,1216,819, 32904,148,136, 32903,147,135, 32902,146,134, 
2, // chain 218
820,1217,820, 239,1173,239, 234,1218,234, 
33003,1219,235, 
2, // chain 219
239,1220,239, 820,1221,820, 272,308,272, 
273,309,273, 
7, // chain 220
270,306,270, 269,305,269, 811,1204,811, 
821,1222,821, 33580,1205,812, 822,1223,822, 33581,1206,813, 823,1224,823, 33572,1207,804, 
6, // chain 221
823,1225,823, 804,1195,804, 805,1196,805, 
824,1226,824, 33575,1198,807, 825,1227,825, 33594,1228,826, 33595,1229,827, 
7, // chain 222
828,1230,828, 829,1231,829, 821,1232,821, 
830,1233,830, 831,1234,831, 33600,1235,832, 33590,1236,822, 824,1226,824, 33591,1225,823, 
14, // chain 223
270,1237,270, 829,1231,829, 275,1238,275, 
33350,828,582, 33349,827,581, 33596,1230,828, 833,1239,833, 33599,1234,831, 834,1240,834, 33600,1235,832, 835,1241,835, 33592,1226,824, 836,1242,836, 33593,1227,825, 837,1243,837, 33594,1228,826, 
1, // chain 224
45,48,45, 274,1244,274, 44,47,44, 
22, // chain 225
795,1245,795, 583,1246,583, 838,1247,838, 
796,1248,796, 33607,1249,839, 33608,1250,840, 33609,1251,841, 33610,1252,842, 33351,1246,583, 843,1253,843, 844,1254,844, 33613,1255,845, 33614,1256,846, 847,1257,847, 33616,1258,848, 849,1259,849, 850,1260,850, 33619,1261,851, 852,1262,852, 
853,1263,853, 33622,1264,854, 33623,1265,855, 33624,1266,856, 33619,1267,851, 
11, // chain 226
857,1268,857, 126,1269,126, 796,1248,796, 
839,1249,839, 751,1109,751, 33608,1250,840, 750,1106,750, 33522,1115,754, 33626,1270,858, 33609,1251,841, 859,1271,859, 33612,1254,844, 33610,1252,842, 
4, // chain 227
860,1272,860, 126,1273,126, 857,1274,857, 
861,1275,861, 749,1276,749, 33519,1277,751, 
6, // chain 228
862,1278,862, 108,1279,108, 814,1280,814, 
863,1281,863, 33583,1282,815, 864,1283,864, 33002,267,234, 33588,1284,820, 
2, // chain 229
862,1278,862, 122,1285,122, 107,1286,107, 
108,1279,108, 
3, // chain 230
759,1122,759, 737,1077,737, 820,1221,820, 
815,1287,815, 758,1121,758, 
4, // chain 231
810,1203,810, 811,1204,811, 269,305,269, 
737,1077,737, 33588,1221,820, 33040,308,272, 
2, // chain 232
717,1054,717, 718,1055,718, 804,1195,804, 
716,1053,716, 
4, // chain 233
860,1272,860, 749,1276,749, 747,1288,747, 
591,1289,591, 33516,1290,748, 743,1291,743, 
1, // chain 234
751,1109,751, 861,1292,861, 857,1268,857, 
22, // chain 235
754,1115,754, 858,1270,858, 865,1293,865, 
753,1114,753, 33634,1294,866, 33635,1295,867, 33626,1270,858, 859,1271,859, 868,1296,868, 33637,1297,869, 33612,1254,844, 845,1255,845, 870,1298,870, 33615,1257,847, 850,1260,850, 853,1263,853, 871,1299,871, 33622,1264,854, 872,1300,872, 
33641,1301,873, 33642,1302,874, 33623,1265,855, 856,1266,856, 875,1303,875, 
1, // chain 236
564,806,564, 565,807,565, 876,1304,876, 
3, // chain 237
793,1305,793, 565,1306,565, 562,1307,562, 
32,1308,32, 32801,1309,33, 
6, // chain 238
565,1306,565, 793,1305,793, 249,1310,249, 
876,1311,876, 33020,1312,252, 877,1313,877, 33560,1314,792, 33021,1315,253, 
5, // chain 239
786,1158,786, 878,1316,878, 877,1317,877, 
792,1318,792, 64,67,64, 32833,68,65, 33559,1319,791, 
2, // chain 240
786,1158,786, 237,270,237, 878,1316,878, 
33006,271,238, 
5, // chain 241
141,153,141, 142,154,142, 879,1320,879, 
880,1321,880, 33649,1322,881, 33650,1323,882, 32910,154,142, 
7, // chain 242
141,153,141, 880,1321,880, 883,1324,883, 
140,152,140, 33544,1325,776, 33648,1321,880, 775,1326,775, 33649,1322,881, 884,1327,884, 
13, // chain 243
139,151,139, 140,152,140, 776,1325,776, 
773,1328,773, 772,1329,772, 574,1330,574, 137,149,137, 33587,1216,819, 33653,1331,885, 33654,1332,886, 33341,1333,573, 887,1334,887, 33530,1127,762, 33529,1126,761, 33338,1335,570, 
6, // chain 244
888,1336,888, 142,1337,142, 143,1338,143, 
789,1339,789, 33556,1340,788, 33657,1341,889, 32890,1342,122, 32889,1343,121, 
11, // chain 245
890,1344,890, 891,1345,891, 892,1346,892, 
893,1347,893, 33662,1348,894, 33663,1349,895, 33655,1334,887, 33659,1345,891, 886,1332,886, 33653,1331,885, 33586,1215,818, 33658,1344,890, 816,1213,816, 
4, // chain 246
452,568,452, 453,569,453, 180,1350,180, 
33664,1351,896, 33202,543,434, 33200,541,432, 
1, // chain 247
180,1350,180, 181,567,181, 452,568,452, 
14, // chain 248
897,1352,897, 898,1353,898, 899,1354,899, 
900,1355,900, 33545,1356,777, 33549,1357,781, 33328,1358,560, 33229,1359,461, 32772,1360,4, 33666,1353,898, 3,1361,3, 33669,1362,901, 33670,1363,902, 33665,1352,897, 903,1364,903, 33668,1355,900, 
1, // chain 249
3,1361,3, 901,1362,901, 226,1365,226, 
2, // chain 250
225,250,225, 226,251,226, 785,1366,785, 
224,249,224, 
4, // chain 251
180,1350,180, 896,1351,896, 904,1367,904, 
905,1368,905, 33674,1369,906, 33675,1370,907, 
4, // chain 252
907,1371,907, 908,1372,908, 906,1373,906, 
32961,1374,193, 33677,1375,909, 194,1376,194, 
3, // chain 253
910,1377,910, 220,243,220, 221,244,221, 
911,1378,911, 33680,1379,912, 
9, // chain 254
220,243,220, 910,1377,910, 913,1380,913, 
914,1381,914, 32955,199,187, 33531,1128,763, 33663,1349,895, 33678,1377,910, 894,1348,894, 33683,1382,915, 33679,1378,911, 
2, // chain 255
442,553,442, 458,1383,458, 761,1133,761, 
441,552,441, 
8, // chain 256
679,1384,679, 916,1385,916, 699,1007,699, 
243,276,243, 33454,969,686, 264,970,264, 240,273,240, 33459,986,691, 33457,987,689, 33031,1386,263, 
1, // chain 257
160,172,160, 683,1387,683, 159,171,159, 
2, // chain 258
153,1388,153, 154,1389,154, 161,972,161, 
33036,973,268, 
2, // chain 259
666,1390,666, 664,1391,664, 650,916,650, 
651,917,651, 
4, // chain 260
653,919,653, 917,1392,917, 918,1393,918, 
652,918,652, 33687,1394,919, 33685,1392,917, 
3, // chain 261
917,1392,917, 653,919,653, 654,920,654, 
681,1395,681, 33423,921,655, 
4, // chain 262
920,1396,920, 231,1397,231, 666,1398,666, 
919,1399,919, 33420,1400,652, 33419,1401,651, 
4, // chain 263
681,960,681, 682,961,682, 917,1402,917, 
33001,1403,233, 33000,1404,232, 32998,962,230, 
6, // chain 264
88,101,88, 464,1405,464, 251,1406,251, 
33021,1407,253, 33559,1408,791, 33283,1409,515, 65,262,65, 33286,1410,518, 
2, // chain 265
251,1406,251, 250,1411,250, 88,101,88, 
32857,1412,89, 
2, // chain 266
498,1413,498, 469,590,469, 470,591,470, 
499,787,499, 
4, // chain 267
556,1414,556, 474,1415,474, 473,1416,473, 
555,1417,555, 33326,1418,558, 554,1419,554, 
1, // chain 268
556,1414,556, 480,1420,480, 474,1415,474, 
7, // chain 269
765,1421,765, 456,1422,456, 455,1423,455, 
921,1424,921, 33211,1425,443, 922,1426,922, 33691,1427,923, 32930,1428,162, 165,1429,165, 
1, // chain 270
922,1426,922, 765,1430,765, 921,1424,921, 
1, // chain 271
765,1431,765, 924,1432,924, 764,1433,764, 
3, // chain 272
925,1434,925, 418,1435,418, 419,1436,419, 
926,1437,926, 33692,1438,924, 
3, // chain 273
927,1439,927, 166,1440,166, 925,1441,925, 
926,1442,926, 924,1432,924, 
6, // chain 274
310,1443,310, 928,1444,928, 411,1445,411, 
407,1446,407, 309,1447,309, 33176,1448,408, 319,366,319, 308,368,308, 
6, // chain 275
367,423,367, 403,480,403, 342,1449,342, 
33176,1450,408, 33087,1451,319, 33170,479,402, 320,1452,320, 33090,1453,322, 
4, // chain 276
413,1454,413, 411,1445,411, 928,1444,928, 
414,1455,414, 33169,1456,401, 33168,1457,400, 
1, // chain 277
1,1,1, 0,0,0, 20,248,20, 
2, // chain 278
929,1458,929, 930,1459,930, 931,1460,931, 
33700,1461,932, 
8, // chain 279
933,1462,933, 934,1463,934, 935,1464,935, 
33704,1465,936, 33705,1466,937, 33706,1467,938, 939,1468,939, 935,1464,935, 33708,1469,940, 941,1470,941, 
12, // chain 280
935,1471,935, 941,1472,941, 942,1473,942, 
943,1474,943, 33712,1475,944, 33713,1476,945, 33714,1477,946, 33709,1472,941, 947,1478,947, 33716,1479,948, 949,1480,949, 950,1481,950, 33719,1482,951, 952,1483,952, 
9, // chain 281
953,1484,953, 951,1485,951, 954,1486,954, 
955,1487,955, 33724,1488,956, 33725,1489,957, 33726,1490,958, 33708,1491,940, 33716,1492,948, 33719,1485,951, 949,1493,949, 
1, // chain 282
959,1494,959, 960,1495,960, 961,1496,961, 
6, // chain 283
962,1497,962, 963,1498,963, 952,1499,952, 
964,1500,964, 965,1501,965, 33734,1502,966, 967,1503,967, 33736,1504,968, 
3, // chain 284
969,1505,969, 970,1506,970, 971,1507,971, 
33740,1508,972, 33741,1509,973, 
15, // chain 285
974,1510,974, 975,1511,975, 976,1512,976, 
977,1513,977, 33746,1514,978, 33747,1515,979, 33748,1516,980, 981,1517,981, 33750,1518,982, 33751,1519,983, 33752,1520,984, 33753,1521,985, 33754,1522,986, 987,1523,987, 988,1524,988, 33757,1525,989, 33743,1526,975, 
14, // chain 286
990,1527,990, 975,1528,975, 974,1529,974, 
991,1530,991, 33760,1531,992, 993,1532,993, 994,1533,994, 33763,1534,995, 33764,1535,996, 33765,1536,997, 33766,1537,998, 999,1538,999, 1000,1539,1000, 33769,1540,1001, 1002,1541,1002, 1003,1542,1003, 
6, // chain 287
1004,1543,1004, 1005,1544,1005, 1006,1545,1006, 
1007,1546,1007, 33776,1547,1008, 1009,1548,1009, 33778,1549,1010, 1011,1550,1011, 
7, // chain 288
1006,1551,1006, 1005,1552,1005, 1012,1553,1012, 
1013,1554,1013, 33782,1555,1014, 1015,1556,1015, 1016,1557,1016, 33785,1558,1017, 33786,1559,1018, 
4, // chain 289
1019,1560,1019, 1020,1561,1020, 1021,1562,1021, 
1022,1563,1022, 1023,1564,1023, 33792,1565,1024, 
1, // chain 290
1025,1566,1025, 1026,1567,1026, 1027,1568,1027, 
8, // chain 291
1028,1569,1028, 1029,1570,1029, 1030,1571,1030, 
587,1572,587, 33354,1573,586, 33799,1574,1031, 33800,1575,1032, 33801,1576,1033, 33802,1577,1034, 33797,1570,1029, 
21, // chain 292
1029,1570,1029, 1028,1569,1028, 1035,1578,1035, 
33355,1572,587, 1036,1579,1036, 32901,1580,133, 1037,1581,1037, 1038,1582,1038, 33807,1583,1039, 33584,1584,816, 1040,1585,1040, 33658,1586,890, 1041,1587,1041, 1042,1588,1042, 33661,1589,893, 1043,1590,1043, 33683,1591,915, 1044,1592,1044, 33813,1593,1045, 
1046,1594,1046, 33815,1595,1047, 33680,1596,912, 33679,1597,911, 
11, // chain 293
1048,1598,1048, 1031,1574,1031, 1032,1575,1032, 
1049,1599,1049, 33818,1600,1050, 33819,1601,1051, 33801,1576,1033, 1052,1602,1052, 33802,1577,1034, 1053,1603,1053, 1054,1604,1054, 33823,1605,1055, 33824,1606,1056, 
1, // chain 294
1057,1607,1057, 1058,1608,1058, 1059,1609,1059, 
5, // chain 295
1060,1610,1060, 1061,1611,1061, 1062,1612,1062, 
1063,1613,1063, 1064,1614,1064, 33833,1615,1065, 1066,1616,1066, 
6, // chain 296
1067,1617,1067, 1068,1618,1068, 1069,1619,1069, 
1070,1620,1070, 1071,1621,1071, 33840,1622,1072, 33841,1623,1073, 1074,1624,1074, 
4, // chain 297
1075,1625,1075, 1076,1626,1076, 1077,1627,1077, 
1078,1628,1078, 33847,1629,1079, 33848,1630,1080, 
21, // chain 298
1081,1631,1081, 1082,1632,1082, 1083,1633,1083, 
1084,1634,1084, 33853,1635,1085, 33814,1594,1046, 33854,1636,1086, 33846,1628,1078, 33855,1637,1087, 33850,1632,1082, 1088,1638,1088, 33857,1639,1089, 33849,1631,1081, 435,1640,435, 33206,1641,438, 33858,1642,1090, 33852,1634,1084, 1091,1643,1091, 33860,1644,1092, 
33861,1645,1093, 33853,1635,1085, 1047,1595,1047, 33814,1594,1046, 
4, // chain 299
1094,1646,1094, 1075,1647,1075, 430,1648,430, 
429,1649,429, 426,531,426, 33193,1650,425, 
3, // chain 300
1095,1651,1095, 352,1652,352, 354,1653,354, 
1096,1654,1096, 33865,1655,1097, 
3, // chain 301
1094,1656,1094, 1098,1657,1098, 1097,1658,1097, 
355,1659,355, 33122,1660,354, 
3, // chain 302
351,1661,351, 352,1662,352, 1095,1663,1095, 
348,1664,348, 33151,1665,383, 
3, // chain 303
426,1666,426, 384,1667,384, 1098,1668,1098, 
33867,1669,1099, 1100,1670,1100, 
9, // chain 304
1101,1671,1101, 340,1672,340, 447,1673,447, 
449,1674,449, 1102,1675,1102, 33871,1676,1103, 33219,1677,451, 1104,1678,1104, 33873,1679,1105, 1106,1680,1106, 33875,1681,1107, 
4, // chain 305
1092,1644,1092, 1093,1645,1093, 223,1682,223, 
32990,1683,222, 33680,1596,912, 33815,1595,1047, 
7, // chain 306
1091,1643,1091, 1092,1644,1092, 216,1684,216, 
191,1685,191, 1090,1642,1090, 32960,1686,192, 1108,1687,1108, 32962,1688,194, 909,1689,909, 
4, // chain 307
929,1458,929, 944,1690,944, 945,1691,945, 
1109,1692,1109, 33878,1693,1110, 1111,1694,1111, 
1, // chain 308
973,1695,973, 1112,1696,1112, 1113,1697,1113, 
2, // chain 309
1114,1698,1114, 1115,1699,1115, 1116,1700,1116, 
1117,1701,1117, 
4, // chain 310
1118,1702,1118, 1119,1703,1119, 1120,1704,1120, 
33889,1705,1121, 33890,1706,1122, 33891,1707,1123, 
10, // chain 311
1124,1708,1124, 1125,1709,1125, 1126,1710,1126, 
1127,1711,1127, 1115,1712,1115, 33896,1713,1128, 33897,1714,1129, 33898,1715,1130, 1003,1716,1003, 1002,1717,1002, 1131,1718,1131, 33769,1719,1001, 
7, // chain 312
1132,1720,1132, 1133,1721,1133, 1134,1722,1134, 
1135,1723,1135, 33904,1724,1136, 33905,1725,1137, 33906,1726,1138, 33901,1721,1133, 1004,1727,1004, 
3, // chain 313
1139,1728,1139, 1140,1729,1140, 1141,1730,1141, 
33910,1731,1142, 33794,1732,1026, 
6, // chain 314
1018,1733,1018, 1139,1728,1139, 1141,1730,1141, 
1017,1734,1017, 33911,1735,1143, 33910,1731,1142, 1144,1736,1144, 33795,1737,1027, 
27, // chain 315
1145,1738,1145, 1146,1739,1146, 1147,1740,1147, 
1148,1741,1148, 33218,1742,450, 33219,1743,451, 33917,1744,1149, 33918,1745,1150, 33914,1739,1146, 1151,1746,1151, 1152,1747,1152, 33921,1748,1153, 1154,1749,1154, 33923,1750,1155, 33906,1751,1138, 1004,1752,1004, 1007,1753,1007, 1156,1754,1156, 33777,1755,1009, 
1011,1756,1011, 1157,1757,1157, 33729,1758,961, 1158,1759,1158, 33927,1760,1159, 33728,1761,960, 1160,1762,1160, 33929,1763,1161, 33930,1764,1162, 1163,1765,1163, 
3, // chain 316
1024,1766,1024, 1164,1767,1164, 1165,1768,1165, 
1023,1769,1023, 33934,1770,1166, 
6, // chain 317
1167,1771,1167, 1168,1772,1168, 1169,1773,1169, 
1170,1774,1170, 33939,1775,1171, 33940,1776,1172, 33941,1777,1173, 33942,1778,1174, 
16, // chain 318
1175,1779,1175, 1176,1780,1176, 1177,1781,1177, 
1178,1782,1178, 33891,1783,1123, 33947,1784,1179, 33948,1785,1180, 33602,1240,834, 33944,1780,1176, 833,1239,833, 33949,1786,1181, 33943,1779,1175, 1182,1787,1182, 33951,1788,1183, 33952,1789,1184, 33946,1782,1178, 1185,1790,1185, 33891,1783,1123, 
6, // chain 319
1186,1791,1186, 1187,1792,1187, 1188,1793,1188, 
1189,1794,1189, 33958,1795,1190, 1191,1796,1191, 1192,1797,1192, 1186,1791,1186, 
12, // chain 320
421,524,421, 422,525,422, 1193,1798,1193, 
33962,1799,1194, 33963,1800,1195, 33191,526,423, 1196,1801,1196, 33965,1802,1197, 33086,527,318, 314,1803,314, 315,1804,315, 1196,1801,1196, 33966,1805,1198, 33073,1806,305, 
7, // chain 321
294,334,294, 295,335,295, 1199,1807,1199, 
33064,336,296, 1200,1808,1200, 33065,337,297, 375,433,375, 33066,338,298, 374,432,374, 
2, // chain 322
360,1809,360, 361,1810,361, 1201,1811,1201, 
1202,1812,1202, 
1, // chain 323
321,369,321, 1203,1813,1203, 308,368,308, 
12, // chain 324
1204,1814,1204, 1205,1815,1205, 1206,1816,1206, 
1194,1799,1194, 33975,1817,1207, 33976,1818,1208, 33977,1819,1209, 33973,1815,1205, 1210,1820,1210, 33979,1821,1211, 33980,1822,1212, 33972,1814,1204, 1195,1800,1195, 33962,1799,1194, 
6, // chain 325
1193,1798,1193, 1194,1799,1194, 1213,1823,1213, 
33975,1817,1207, 1214,1824,1214, 376,1825,376, 421,524,421, 33145,523,377, 
4, // chain 326
1199,1807,1199, 1200,1808,1200, 1215,1826,1215, 
33982,1827,1214, 33143,433,375, 376,434,376, 
2, // chain 327
1216,1828,1216, 293,333,293, 294,334,294, 
1199,1807,1199, 
8, // chain 328
344,1829,344, 293,1830,293, 1216,1831,1216, 
349,1832,349, 33985,1833,1217, 33986,1834,1218, 33967,1835,1199, 1215,1836,1215, 1207,1837,1207, 33982,1838,1214, 
3, // chain 329
1203,1839,1203, 321,1840,321, 1211,1821,1211, 
33092,1841,324, 1210,1820,1210, 
1, // chain 330
1202,1842,1202, 332,380,332, 360,416,360, 
2, // chain 331
362,1843,362, 337,1844,337, 339,1845,339, 
1219,1846,1219, 
2, // chain 332
308,1847,308, 1203,1839,1203, 1198,1805,1198, 
305,1848,305, 
4, // chain 333
1198,1805,1198, 1203,1839,1203, 1211,1821,1211, 
1212,1822,1212, 1196,1801,1196, 33963,1800,1195, 
6, // chain 334
1218,1834,1218, 1207,1837,1207, 1220,1849,1220, 
1217,1833,1217, 33989,1850,1221, 33990,1851,1222, 33976,1852,1208, 33975,1837,1207, 
3, // chain 335
369,425,369, 370,426,370, 362,1853,362, 
1219,1854,1219, 368,424,368, 
1, // chain 336
1098,1855,1098, 1094,1646,1094, 426,531,426, 
2, // chain 337
1100,1856,1100, 1223,1857,1223, 1098,1657,1098, 
33865,1658,1097, 
6, // chain 338
1095,1651,1095, 1096,1654,1096, 1224,1858,1224, 
383,1859,383, 33152,1860,384, 33867,1861,1099, 33868,1862,1100, 33864,1654,1096, 
2, // chain 339
1223,1863,1223, 1100,1864,1100, 1096,1865,1096, 
1097,1866,1097, 
5, // chain 340
1076,1867,1076, 355,1868,355, 353,1869,353, 
1225,1870,1225, 33118,1871,350, 1217,1833,1217, 33117,1832,349, 
3, // chain 341
1222,1851,1222, 1208,1852,1208, 1226,1872,1226, 
1227,1873,1227, 33996,1874,1228, 
3, // chain 342
1226,1875,1226, 1208,1818,1208, 1209,1819,1209, 
1228,1876,1228, 33978,1820,1210, 
3, // chain 343
1229,1877,1229, 1219,1878,1219, 1101,1879,1101, 
33107,387,339, 340,388,340, 
8, // chain 344
1103,1676,1103, 325,1880,325, 323,1881,323, 
1102,1675,1102, 33998,1882,1230, 33090,1883,322, 1229,1884,1229, 33170,1885,402, 368,1886,368, 1219,1887,1219, 
4, // chain 345
1221,1850,1221, 1231,1888,1231, 1232,1889,1232, 
1233,1890,1233, 1225,1870,1225, 33844,1867,1076, 
7, // chain 346
1077,1891,1077, 1233,1892,1233, 1232,1893,1232, 
1080,1894,1080, 33999,1895,1231, 1234,1896,1234, 34003,1897,1235, 33839,1621,1071, 33835,1617,1067, 
1, // chain 347
1076,1898,1076, 1233,1892,1233, 1077,1891,1077, 
2, // chain 348
1075,1647,1075, 1094,1646,1094, 355,1899,355, 
1076,1898,1076, 
2, // chain 349
448,1900,448, 445,1901,445, 578,824,578, 
450,1902,450, 
7, // chain 350
1078,1628,1078, 1087,1637,1087, 1075,1625,1075, 
33856,1638,1088, 1236,1903,1236, 33199,1904,431, 33857,1639,1089, 433,1905,433, 33203,1640,435, 
2, // chain 351
1234,1896,1234, 1235,1897,1235, 1237,1906,1237, 
1080,1894,1080, 
1, // chain 352
1238,1907,1238, 331,1908,331, 328,1909,328, 
7, // chain 353
1067,1910,1067, 1231,1888,1231, 331,1908,331, 
34007,1911,1239, 33989,1850,1221, 1222,1851,1222, 1227,1873,1227, 330,1912,330, 33097,1913,329, 
8, // chain 354
1067,1617,1067, 331,1914,331, 1068,1618,1068, 
34008,1915,1240, 34006,1916,1238, 1104,1678,1104, 33871,1676,1103, 33093,1880,325, 33095,1917,327, 33096,1918,328, 
1, // chain 355
1236,1903,1236, 431,1904,431, 430,1919,430, 
7, // chain 356
1241,1920,1241, 1242,1921,1242, 1243,1922,1243, 
1244,1923,1244, 34013,1924,1245, 1246,1925,1246, 1247,1926,1247, 33874,1927,1106, 34008,1928,1240, 
3, // chain 357
1240,1915,1240, 1246,1929,1246, 1245,1930,1245, 
1068,1618,1068, 33837,1619,1069, 
5, // chain 358
1248,1931,1248, 1150,1745,1150, 1249,1932,1249, 
1250,1933,1250, 34019,1934,1251, 33920,1747,1152, 33918,1745,1150, 
8, // chain 359
1159,1760,1159, 1252,1935,1252, 1253,1936,1253, 
1251,1934,1251, 34018,1933,1250, 34022,1937,1254, 1255,1938,1255, 34024,1939,1256, 34025,1940,1257, 1258,1941,1258, 
6, // chain 360
1259,1942,1259, 1260,1943,1260, 1261,1944,1261, 
1262,1945,1262, 34031,1946,1263, 34032,1947,1264, 33698,1948,930, 34028,1943,1260, 
7, // chain 361
929,1949,929, 1109,1950,1109, 1265,1951,1265, 
34034,1952,1266, 34035,1953,1267, 33879,1954,1111, 1268,1955,1268, 33880,1956,1112, 33881,1957,1113, 
8, // chain 362
1268,1955,1268, 973,1958,973, 969,1959,969, 
1269,1960,1269, 34038,1961,1270, 1271,1962,1271, 1272,1963,1272, 33888,1704,1120, 33886,1964,1118, 34041,1965,1273, 
10, // chain 363
1005,1966,1005, 1274,1967,1274, 1275,1968,1275, 
1012,1969,1012, 33782,1970,1014, 34044,1971,1276, 34045,1972,1277, 34046,1973,1278, 34042,1967,1274, 1279,1974,1279, 1280,1975,1280, 34049,1976,1281, 
3, // chain 364
1282,1977,1282, 1016,1557,1016, 1283,1978,1283, 
1284,1979,1284, 34053,1980,1285, 
7, // chain 365
1282,1977,1282, 1284,1979,1284, 1286,1981,1286, 
1287,1982,1287, 34056,1983,1288, 1289,1984,1289, 1290,1985,1290, 1291,1986,1291, 34060,1987,1292, 
13, // chain 366
1293,1988,1293, 1294,1989,1294, 1295,1990,1295, 
1296,1991,1296, 34065,1992,1297, 1298,1993,1298, 1299,1994,1299, 33706,1995,938, 934,1996,934, 933,1997,933, 1300,1998,1300, 34060,1999,1292, 34059,2000,1291, 34069,2001,1301, 33711,2002,943, 
8, // chain 367
1295,1990,1295, 1294,1989,1294, 1302,2003,1302, 
34071,2004,1303, 34061,1988,1293, 1289,2005,1289, 34058,2006,1290, 34068,1998,1300, 34064,1991,1296, 1299,1994,1299, 
9, // chain 368
1304,2007,1304, 1295,2008,1295, 1302,2009,1302, 
1305,2010,1305, 34074,2011,1306, 34075,2012,1307, 1308,2013,1308, 34077,2014,1309, 34078,2015,1310, 1311,2016,1311, 34080,2017,1312, 
6, // chain 369
957,2018,957, 1295,2008,1295, 1304,2007,1304, 
1305,2010,1305, 956,2019,956, 34081,2020,1313, 34074,2011,1306, 1308,2013,1308, 
2, // chain 370
1295,2021,1295, 957,2022,957, 1314,2023,1314, 
1297,2024,1297, 
6, // chain 371
1314,2025,1314, 957,2026,957, 1315,2027,1315, 
1298,2028,1298, 33706,2029,938, 33707,2030,939, 33726,2031,958, 33725,2026,957, 
1, // chain 372
935,1464,935, 936,1465,936, 937,1466,937, 
1, // chain 373
948,1492,948, 941,2032,941, 940,1491,940, 
4, // chain 374
1302,2003,1302, 1303,2004,1303, 1316,2033,1316, 
34085,2034,1317, 34056,2035,1288, 34057,2005,1289, 
3, // chain 375
1316,2033,1316, 1317,2034,1317, 1312,2036,1312, 
1307,2037,1307, 34078,2038,1310, 
12, // chain 376
1318,2039,1318, 1317,2034,1317, 1286,2040,1286, 
1319,2041,1319, 34052,2042,1284, 1285,2043,1285, 1320,2044,1320, 1321,2045,1321, 1318,2039,1318, 34090,2046,1322, 34091,2047,1323, 34092,2048,1324, 34093,2049,1325, 34088,2050,1320, 
1, // chain 377
1016,1557,1016, 1017,1558,1017, 1283,1978,1283, 
6, // chain 378
1283,2051,1283, 1017,1734,1017, 1143,1735,1143, 
1285,2052,1285, 34088,2053,1320, 34094,2054,1326, 34095,2055,1327, 33912,1736,1144, 
6, // chain 379
956,1488,956, 1313,2056,1313, 1328,2057,1328, 
955,1487,955, 34097,2058,1329, 34098,2059,1330, 34076,2060,1308, 34081,2056,1313, 
5, // chain 380
968,2061,968, 1308,2013,1308, 1309,2014,1309, 
1331,2062,1331, 34079,2016,1311, 1332,2063,1332, 34091,2064,1323, 
3, // chain 381
1322,2046,1322, 1323,2047,1323, 1312,2036,1312, 
1318,2039,1318, 34085,2034,1317, 
2, // chain 382
972,2065,972, 1333,2066,1333, 1281,2067,1281, 
971,2068,971, 
1, // chain 383
932,2069,932, 1163,2070,1163, 1334,2071,1334, 
3, // chain 384
931,2072,931, 932,2073,932, 1301,2074,1301, 
943,2075,943, 944,2076,944, 
4, // chain 385
1335,2077,1335, 1024,2078,1024, 1327,2079,1327, 
1144,2080,1144, 1026,2081,1026, 33795,2082,1027, 
2, // chain 386
1327,2079,1327, 1024,2078,1024, 1022,2083,1022, 
1021,2084,1021, 
9, // chain 387
1336,2085,1336, 1025,2086,1025, 1337,2087,1337, 
947,1478,947, 33714,1477,946, 34106,2088,1338, 34101,2066,1333, 34048,2089,1280, 34107,2090,1339, 34108,2091,1340, 33793,2086,1025, 
3, // chain 388
1340,2092,1340, 1025,2093,1025, 1341,2094,1341, 
1339,2095,1339, 34110,2096,1342, 
3, // chain 389
1341,2094,1341, 1025,2093,1025, 1343,2097,1343, 
1020,2098,1020, 1019,2099,1019, 
2, // chain 390
1277,1972,1277, 1166,2100,1166, 1165,2101,1165, 
1276,1971,1276, 
5, // chain 391
1278,1973,1278, 1280,1975,1280, 1344,2102,1344, 
34107,2103,1339, 1342,2104,1342, 1166,2100,1166, 34113,2105,1345, 
4, // chain 392
965,1501,965, 967,1503,967, 962,1497,962, 
34114,2106,1346, 34100,2107,1332, 34099,2108,1331, 
2, // chain 393
1347,2109,1347, 1332,2110,1332, 1348,2111,1348, 
34091,2112,1323, 
3, // chain 394
1330,2113,1330, 966,2114,966, 964,2115,964, 
952,2116,952, 1349,2117,1349, 
4, // chain 395
951,1485,951, 953,1484,953, 1349,2118,1349, 
33723,1487,955, 1329,2058,1329, 1330,2059,1330, 
2, // chain 396
968,2119,968, 966,2114,966, 1330,2113,1330, 
1308,2120,1308, 
5, // chain 397
1350,2121,1350, 1351,2122,1351, 1020,2123,1020, 
1352,2124,1352, 34111,2125,1343, 1142,2126,1142, 33795,2127,1027, 
2, // chain 398
1345,2128,1345, 1019,1560,1019, 1023,1564,1023, 
1166,2129,1166, 
2, // chain 399
963,1498,963, 1353,2130,1353, 952,1499,952, 
33718,2131,950, 
4, // chain 400
950,1481,950, 1353,2132,1353, 1352,2133,1352, 
1336,2085,1336, 33910,2134,1142, 1026,2135,1026, 
2, // chain 401
1353,2130,1353, 963,2136,963, 1350,2121,1350, 
1352,2124,1352, 
3, // chain 402
1350,2137,1350, 963,2138,963, 1347,2139,1347, 
1351,2140,1351, 34122,2141,1354, 
2, // chain 403
963,2138,963, 1346,2142,1346, 1347,2139,1347, 
34100,2143,1332, 
1, // chain 404
1326,2054,1326, 1327,2055,1327, 1355,2144,1355, 
1, // chain 405
963,1498,963, 962,1497,962, 1346,2145,1346, 
1, // chain 406
1281,2067,1281, 1333,2066,1333, 1280,2089,1280, 
1, // chain 407
933,2146,933, 935,1471,935, 943,1474,943, 
4, // chain 408
1291,2147,1291, 1301,2074,1301, 1356,2148,1356, 
1357,2149,1357, 33700,2073,932, 34069,2074,1301, 
3, // chain 409
1358,2150,1358, 1010,2151,1010, 1008,2152,1008, 
1013,1554,1013, 33774,1551,1006, 
5, // chain 410
1163,2153,1163, 1260,1943,1260, 1359,2154,1359, 
1161,2155,1161, 34128,2156,1360, 34027,1942,1259, 34028,1943,1260, 
5, // chain 411
1160,2157,1160, 1161,2155,1161, 1360,2156,1360, 
1252,2158,1252, 34129,2159,1361, 34030,1945,1262, 34027,1942,1259, 
2, // chain 412
1251,1934,1251, 1152,1747,1152, 1158,1759,1158, 
1159,1760,1159, 
6, // chain 413
1148,2160,1148, 578,824,578, 579,825,579, 
1182,1787,1182, 33348,826,580, 1181,1786,1181, 33601,1239,833, 33349,827,581, 
4, // chain 414
585,2161,585, 1362,2162,1362, 848,2163,848, 
33816,1598,1048, 33799,1574,1031, 33354,1573,586, 
8, // chain 415
1363,2164,1363, 1049,1599,1049, 1364,2165,1364, 
1365,2166,1365, 34134,2167,1366, 34135,2168,1367, 34136,2169,1368, 34137,2170,1369, 33818,1600,1050, 33817,1599,1049, 
10, // chain 416
1370,2171,1370, 1371,2172,1371, 1372,2173,1372, 
1373,2174,1373, 34142,2175,1374, 34143,2176,1375, 34144,2177,1376, 34135,2178,1367, 1377,2179,1377, 34136,2180,1368, 1378,2181,1378, 1379,2182,1379, 
2, // chain 417
1380,2183,1380, 1381,2184,1381, 1382,2185,1382, 
1383,2186,1383, 
24, // chain 418
1384,2187,1384, 1385,2188,1385, 1386,2189,1386, 
1387,2190,1387, 34156,2191,1388, 34157,2192,1389, 34158,2193,1390, 34159,2194,1391, 34160,2195,1392, 34153,2188,1385, 1065,2196,1065, 34161,2197,1393, 34162,2198,1394, 34152,2187,1384, 1387,2190,1387, 1395,2199,1395, 34164,2200,1396, 34156,2191,1388, 1397,2201,1397, 
34166,2202,1398, 34157,2192,1389, 1399,2203,1399, 34158,2193,1390, 1400,2204,1400, 34159,2194,1391, 1401,2205,1401, 
4, // chain 419
1402,2206,1402, 1393,2207,1393, 1403,2208,1403, 
1404,2209,1404, 34173,2210,1405, 34174,2211,1406, 
5, // chain 420
1407,2212,1407, 1402,2206,1402, 1408,2213,1408, 
34172,2209,1404, 1409,2214,1409, 34178,2215,1410, 34173,2210,1405, 
6, // chain 421
1411,2216,1411, 1407,2212,1407, 1408,2213,1408, 
1409,2214,1409, 1412,2217,1412, 34181,2218,1413, 33641,2219,873, 34178,2215,1410, 
3, // chain 422
1066,2220,1066, 1402,2221,1402, 1407,2222,1407, 
995,1534,995, 33762,1533,994, 
6, // chain 423
1066,2223,1066, 995,2224,995, 996,2225,996, 
1414,2226,1414, 1064,1614,1064, 34183,2227,1415, 34184,2228,1416, 34185,2229,1417, 
11, // chain 424
992,2230,992, 974,2231,974, 977,2232,977, 
1418,2233,1418, 34187,2234,1419, 33746,2235,978, 1420,2236,1420, 33747,2237,979, 1421,2238,1421, 1422,2239,1422, 34191,2240,1423, 34192,2241,1424, 34193,2242,1425, 
7, // chain 425
1426,2243,1426, 1424,2241,1424, 1427,2244,1427, 
1428,2245,1428, 1429,2246,1429, 34198,2247,1430, 34199,2248,1431, 1432,2249,1432, 1433,2250,1433, 
4, // chain 426
1434,2251,1434, 1435,2252,1435, 1436,2253,1436, 
1437,2254,1437, 34206,2255,1438, 1439,2256,1439, 
10, // chain 427
1438,2257,1438, 1436,2258,1436, 1440,2259,1440, 
34203,2260,1435, 1124,1708,1124, 33893,1709,1125, 34209,2261,1441, 1442,2262,1442, 34211,2263,1443, 34201,2264,1433, 1444,2265,1444, 34213,2266,1445, 
6, // chain 428
1419,2234,1419, 1131,2267,1131, 1001,2268,1001, 
1418,2233,1418, 33767,2269,999, 998,2270,998, 992,2230,992, 33761,2271,993, 
6, // chain 429
1446,2272,1446, 1447,2273,1447, 1448,2274,1448, 
1449,2275,1449, 34218,2276,1450, 33959,2277,1191, 1190,2278,1190, 1451,2279,1451, 
9, // chain 430
1167,2280,1167, 1447,2273,1447, 1446,2272,1446, 
1168,2281,1168, 34220,2282,1452, 34221,2283,1453, 34217,2275,1449, 1454,2284,1454, 1455,2285,1455, 34224,2286,1456, 34184,2287,1416, 
2, // chain 431
1447,2288,1447, 1192,2289,1192, 1191,2290,1191, 
1448,2291,1448, 
2, // chain 432
1192,2292,1192, 1170,1774,1170, 1171,1775,1171, 
1186,2293,1186, 
2, // chain 433
1170,1774,1170, 1192,2292,1192, 1447,2294,1447, 
1167,1771,1167, 
2, // chain 434
1174,2295,1174, 1457,2296,1457, 1458,2297,1458, 
1173,2298,1173, 
3, // chain 435
1457,2296,1457, 1459,2299,1459, 1458,2297,1458, 
34228,2300,1460, 34212,2301,1444, 
3, // chain 436
1444,2265,1444, 1459,2302,1459, 1443,2263,1443, 
34210,2262,1442, 34225,2303,1457, 
3, // chain 437
1461,2304,1461, 1462,2305,1462, 1460,2306,1460, 
1445,2307,1445, 34212,2308,1444, 
8, // chain 438
1451,2309,1451, 1188,2310,1188, 1057,2311,1057, 
1061,1611,1061, 34231,2312,1463, 34195,2313,1427, 34232,2314,1464, 33827,2315,1059, 1462,2316,1462, 33941,2317,1173, 
6, // chain 439
1450,2318,1450, 1451,2309,1451, 1061,1611,1061, 
1449,2319,1449, 33828,1610,1060, 1064,1614,1064, 1415,2227,1415, 1454,2320,1454, 
6, // chain 440
1417,2321,1417, 1414,2322,1414, 996,1535,996, 
997,1536,997, 1000,1539,1000, 1465,2323,1465, 1456,2324,1456, 1416,2325,1416, 
6, // chain 441
1456,2286,1456, 1465,2326,1465, 1466,2327,1466, 
1455,2285,1455, 34220,2282,1452, 33898,2328,1130, 34233,2326,1465, 1003,2329,1003, 
1, // chain 442
1415,2227,1415, 1416,2228,1416, 1454,2330,1454, 
1, // chain 443
1464,2314,1464, 1428,2331,1428, 1427,2313,1427, 
2, // chain 444
1425,2332,1425, 1421,2333,1421, 981,1517,981, 
33747,1515,979, 
3, // chain 445
986,2334,986, 980,2335,980, 976,2336,976, 
987,2337,987, 34235,2338,1467, 
5, // chain 446
994,1533,994, 1411,2339,1411, 1468,2340,1468, 
34180,2341,1412, 1469,2342,1469, 34238,2343,1470, 34181,2344,1413, 
2, // chain 447
1398,2202,1398, 1471,2345,1471, 1397,2201,1397, 
33595,2346,827, 
6, // chain 448
1472,2347,1472, 1373,2174,1373, 1374,2175,1374, 
1473,2348,1473, 34143,2176,1375, 837,2349,837, 34145,2179,1377, 34144,2177,1376, 
8, // chain 449
1054,1604,1054, 1474,2350,1474, 1475,2351,1475, 
1051,1601,1051, 33818,1600,1050, 34137,2170,1369, 34244,2352,1476, 34146,2353,1378, 1368,2169,1368, 1369,2170,1369, 
9, // chain 450
1378,2354,1378, 1475,2355,1475, 1474,2356,1474, 
1477,2357,1477, 33947,1784,1179, 33823,2358,1055, 1478,2359,1478, 33824,2360,1056, 1122,2361,1122, 1123,1783,1123, 1179,1784,1179, 
8, // chain 451
1473,2348,1473, 827,2362,827, 1471,2363,1471, 
1472,2347,1472, 34166,2364,1398, 1382,2185,1382, 1373,2174,1373, 34149,2184,1381, 1479,2365,1479, 1370,2171,1370, 
8, // chain 452
1406,2366,1406, 1394,2198,1394, 1395,2199,1395, 
1480,2367,1480, 34249,2368,1481, 34164,2200,1396, 803,2369,803, 33574,2370,806, 34165,2201,1397, 808,2371,808, 
2, // chain 453
1482,2372,1482, 1483,2373,1483, 989,2374,989, 
975,2375,975, 
2, // chain 454
989,2374,989, 1484,2376,1484, 1485,2377,1485, 
988,2378,988, 
6, // chain 455
1486,2379,1486, 983,1519,983, 1487,2380,1487, 
1479,2381,1479, 34256,2382,1488, 34257,2383,1489, 33752,1520,984, 33751,1519,983, 
3, // chain 456
988,1524,988, 1485,2384,1485, 1489,2383,1489, 
984,1520,984, 985,1521,985, 
4, // chain 457
1490,2385,1490, 1484,2376,1484, 1483,2373,1483, 
1470,2386,1470, 34237,2387,1469, 34250,2372,1482, 
2, // chain 458
1470,2388,1470, 1413,2218,1413, 874,2389,874, 
33641,2219,873, 
5, // chain 459
872,1300,872, 873,1301,873, 1410,2390,1410, 
1491,2391,1491, 34260,2392,1492, 34173,2393,1405, 1406,2394,1406, 
1, // chain 460
1480,2367,1480, 1492,2395,1492, 1406,2366,1406, 
2, // chain 461
826,2396,826, 827,2362,827, 1473,2348,1473, 
837,2349,837, 
1, // chain 462
1054,1604,1054, 1055,1605,1055, 1474,2350,1474, 
7, // chain 463
1493,2397,1493, 1241,1920,1241, 1244,1923,1244, 
1247,1926,1247, 1494,2398,1494, 34263,2399,1495, 34264,2400,1496, 33874,1927,1106, 1107,2401,1107, 
4, // chain 464
1497,2402,1497, 1107,2403,1107, 1149,1744,1149, 
1498,2404,1498, 34016,1931,1248, 33918,1745,1150, 
7, // chain 465
1254,2405,1254, 1253,2406,1253, 1499,2407,1499, 
1257,2408,1257, 34268,2409,1500, 34030,1945,1262, 34129,2159,1361, 34020,2158,1252, 34021,2406,1253, 
1, // chain 466
929,2410,929, 1264,1947,1264, 930,1948,930, 
24, // chain 467
1267,1953,1267, 1268,1955,1268, 1269,1960,1269, 
1272,1963,1272, 1266,1952,1266, 34269,2411,1501, 34270,2412,1502, 34271,2413,1503, 34272,2414,1504, 33888,1704,1120, 1121,1705,1121, 1505,2415,1505, 34274,2416,1506, 33890,1706,1122, 1507,2417,1507, 33824,2418,1056, 1053,2419,1053, 1508,2420,1508, 33802,2421,1034, 
1029,2422,1029, 1509,2423,1509, 1510,2424,1510, 34279,2425,1511, 1512,2426,1512, 34281,2427,1513, 34282,2428,1514, 
11, // chain 468
1515,2429,1515, 1516,2430,1516, 1517,2431,1517, 
1274,2432,1274, 34047,2433,1279, 33739,1507,971, 34284,2430,1516, 969,1505,969, 34038,2434,1270, 34286,2435,1518, 33903,1723,1135, 34283,2429,1515, 1132,1720,1132, 
3, // chain 469
1152,1747,1152, 1154,1749,1154, 1158,1759,1158, 
33924,1754,1156, 33923,1750,1155, 
3, // chain 470
1151,2436,1151, 1519,2437,1519, 1137,1725,1137, 
1153,2438,1153, 33906,1726,1138, 
4, // chain 471
1520,2439,1520, 1521,2440,1521, 1522,2441,1522, 
1273,2442,1273, 33953,2443,1185, 33952,2444,1184, 
4, // chain 472
848,2445,848, 846,2446,846, 585,833,585, 
33352,832,584, 33611,2447,843, 583,831,583, 
8, // chain 473
1523,2448,1523, 1524,2449,1524, 1363,2164,1363, 
1365,2166,1365, 1525,2450,1525, 34294,2451,1526, 34134,2167,1366, 1371,2452,1371, 34135,2168,1367, 1372,2453,1372, 
4, // chain 474
1486,2379,1486, 1380,2454,1380, 1527,2455,1527, 
982,1518,982, 34169,2456,1401, 34168,2457,1400, 
4, // chain 475
1400,2204,1400, 1380,2458,1380, 1383,2459,1383, 
1399,2203,1399, 34166,2202,1398, 34150,2460,1382, 
2, // chain 476
1065,2196,1065, 1393,2197,1393, 1402,2461,1402, 
1066,2462,1066, 
6, // chain 477
1391,2463,1391, 1062,2464,1062, 1463,2465,1463, 
1528,2466,1528, 34195,2467,1427, 1529,2468,1529, 34192,2469,1424, 1425,2470,1425, 
2, // chain 478
1528,2466,1528, 1529,2468,1529, 1401,2471,1401, 
1391,2463,1391, 
3, // chain 479
1425,2332,1425, 981,1517,981, 982,1518,982, 
1529,2472,1529, 34169,2456,1401, 
8, // chain 480
1489,2473,1489, 1485,2377,1485, 1526,2451,1526, 
34293,2450,1525, 34252,2376,1484, 1530,2474,1530, 34258,2385,1490, 875,2475,875, 34238,2386,1470, 874,2476,874, 
6, // chain 481
836,1242,836, 1379,2477,1379, 1531,2478,1531, 
1180,1785,1180, 33947,1784,1179, 34245,2357,1477, 34147,2477,1379, 1378,2354,1378, 
5, // chain 482
1509,2479,1509, 1029,1570,1029, 1532,2480,1532, 
1533,2481,1533, 34302,2482,1534, 33803,1578,1035, 33797,1570,1029, 
6, // chain 483
1534,2482,1534, 1035,1578,1035, 1535,2483,1535, 
1536,2484,1536, 34305,2485,1537, 33806,1582,1038, 33804,1579,1036, 33803,1578,1035, 
2, // chain 484
816,1213,816, 1037,2486,1037, 134,146,134, 
32901,145,133, 
2, // chain 485
1514,2487,1514, 1538,2488,1538, 1539,2489,1539, 
1513,2490,1513, 
3, // chain 486
1185,2443,1185, 1123,2491,1123, 1119,2492,1119, 
1118,2493,1118, 1273,2442,1273, 
5, // chain 487
1182,1787,1182, 1183,1788,1183, 1148,2160,1148, 
33913,2494,1145, 34289,2495,1521, 33952,1789,1184, 1522,2496,1522, 
2, // chain 488
1526,2451,1526, 1371,2452,1371, 1488,2497,1488, 
1489,2473,1489, 
5, // chain 489
1540,2498,1540, 1480,2367,1480, 1541,2499,1541, 
801,2500,801, 33570,2501,802, 34249,2368,1481, 34248,2367,1480, 
1, // chain 490
827,2502,827, 807,2503,807, 808,2371,808, 
9, // chain 491
1507,2417,1507, 1508,2420,1508, 1510,2424,1510, 
1506,2416,1506, 34273,2415,1505, 34280,2426,1512, 1503,2413,1503, 34281,2427,1513, 1502,2412,1502, 34310,2504,1542, 34307,2505,1539, 
11, // chain 492
1511,2506,1511, 1509,2479,1509, 1514,2487,1514, 
34301,2481,1533, 1538,2488,1538, 34311,2507,1543, 34302,2482,1534, 1544,2508,1544, 34304,2484,1536, 1537,2485,1537, 1545,2509,1545, 33807,1583,1039, 33806,1582,1038, 
2, // chain 493
1491,2391,1491, 868,1296,868, 871,1299,871, 
872,1300,872, 
2, // chain 494
1540,2510,1540, 868,1296,868, 1491,2391,1491, 
1492,2392,1492, 
9, // chain 495
1137,1725,1137, 1519,2437,1519, 1136,1724,1136, 
34286,2435,1518, 34314,2511,1546, 34041,2442,1273, 34288,2439,1520, 33919,2436,1151, 1146,2512,1146, 1521,2440,1521, 33913,2513,1145, 
3, // chain 496
1270,2434,1270, 1518,2435,1518, 1546,2511,1546, 
1271,2514,1271, 34041,2442,1273, 
1, // chain 497
1136,1724,1136, 1518,2435,1518, 1135,1723,1135, 
8, // chain 498
1547,2515,1547, 1539,2489,1539, 1538,2488,1538, 
1548,2516,1548, 34317,2517,1549, 34311,2507,1543, 1550,2518,1550, 34312,2508,1544, 1551,2519,1551, 34320,2520,1552, 
3, // chain 499
1553,2521,1553, 1554,2522,1554, 1548,2516,1548, 
1550,2518,1550, 34317,2517,1549, 
9, // chain 500
1547,2515,1547, 1548,2516,1548, 1554,2522,1554, 
1555,2523,1555, 34324,2524,1556, 34025,2408,1257, 34026,2525,1258, 34321,2521,1553, 1557,2526,1557, 34319,2519,1551, 34318,2518,1550, 
8, // chain 501
1557,2527,1557, 1551,2528,1551, 1558,2529,1558, 
1256,1939,1256, 34023,1938,1255, 34327,2530,1559, 34328,2531,1560, 34329,2532,1561, 34320,2533,1552, 34319,2528,1551, 
4, // chain 502
1241,1920,1241, 1046,1594,1046, 1086,1636,1086, 
1242,1921,1242, 33847,1629,1079, 33846,1628,1078, 
8, // chain 503
1496,2534,1496, 1107,2403,1107, 1497,2402,1497, 
1560,2531,1560, 34327,2530,1559, 34330,2535,1562, 34266,2404,1498, 1255,1938,1255, 34018,1933,1250, 34016,1931,1248, 
8, // chain 504
1262,1945,1262, 1263,1946,1263, 1563,2536,1563, 
1500,2409,1500, 34332,2537,1564, 34333,2538,1565, 34031,1946,1263, 1566,2539,1566, 34032,1947,1264, 1567,2540,1567, 
6, // chain 505
1265,1951,1265, 1266,1952,1266, 1567,2541,1567, 
34269,2411,1501, 1566,2542,1566, 34270,2412,1502, 1565,2543,1565, 34310,2504,1542, 
2, // chain 506
904,1367,904, 896,1351,896, 436,545,436, 
437,546,437, 
5, // chain 507
907,2544,907, 904,2545,904, 437,2546,437, 
438,2547,438, 1108,2548,1108, 908,2549,908, 33677,2550,909, 
1, // chain 508
1108,1687,1108, 438,1641,438, 1090,1642,1090, 
1, // chain 509
915,2551,915, 911,2552,911, 1045,2553,1045, 
6, // chain 510
1042,1588,1042, 1043,1590,1043, 1495,2399,1495, 
34262,2398,1494, 33812,1592,1044, 1493,2397,1493, 33814,1594,1046, 1241,1920,1241, 
3, // chain 511
1495,2554,1495, 1496,2534,1496, 1561,2532,1561, 
1545,2555,1545, 34320,2533,1552, 
3, // chain 512
215,2556,215, 216,1684,216, 1092,1644,1092, 
223,1682,223, 217,2557,217, 
5, // chain 513
1452,2282,1452, 1130,2328,1130, 1127,2558,1127, 
1168,2281,1168, 33894,2559,1126, 1457,2296,1457, 34210,2560,1442, 
1, // chain 514
1188,2310,1188, 1451,2309,1451, 1190,2561,1190, 
6, // chain 515
1568,2562,1568, 1420,2236,1420, 1569,2563,1569, 
1570,2564,1570, 34339,2565,1571, 34340,2566,1572, 34190,2239,1422, 34188,2236,1420, 
5, // chain 516
1573,2567,1573, 1422,2239,1422, 1423,2240,1423, 
1439,2568,1439, 34342,2569,1574, 34194,2243,1426, 34192,2241,1424, 
2, // chain 517
1574,2570,1574, 1429,2571,1429, 1575,2572,1575, 
1437,2573,1437, 
1, // chain 518
1429,2246,1429, 1430,2247,1430, 1441,2574,1441, 
3, // chain 519
1437,2254,1437, 1575,2575,1575, 1434,2251,1434, 
34209,2576,1441, 34197,2577,1429, 
1, // chain 520
1439,2578,1439, 1574,2579,1574, 1437,2580,1437, 
7, // chain 521
1439,2568,1439, 1438,2581,1438, 1576,2582,1576, 
1573,2567,1573, 34340,2566,1572, 34345,2583,1577, 34346,2584,1578, 33882,2585,1114, 34206,2581,1438, 
3, // chain 522
1114,2586,1114, 1438,2257,1438, 1440,2259,1440, 
1124,1708,1124, 1115,1712,1115, 
1, // chain 523
1572,2566,1572, 1422,2239,1422, 1573,2567,1573, 
4, // chain 524
1579,2587,1579, 1580,2588,1580, 1570,2564,1570, 
34336,2562,1568, 34187,2234,1419, 33899,2267,1131, 
6, // chain 525
1579,2589,1579, 1117,2590,1117, 1116,2591,1116, 
1115,1712,1115, 1128,1713,1128, 1580,2592,1580, 33899,1718,1131, 33897,1714,1129, 
1, // chain 526
1274,2593,1274, 1005,2594,1005, 1132,2595,1132, 
2, // chain 527
1133,2596,1133, 1132,2597,1132, 1005,1544,1005, 
1004,1543,1004, 
9, // chain 528
1016,1557,1016, 1282,1977,1282, 1358,2150,1358, 
34349,2598,1581, 34055,1982,1287, 1582,2599,1582, 34059,1986,1291, 1357,2600,1357, 1334,2601,1334, 959,2602,959, 33728,2603,960, 
3, // chain 529
1581,2598,1581, 1582,2599,1582, 959,2602,959, 
1010,2151,1010, 1358,2150,1358, 
1, // chain 530
1583,2604,1583, 1243,2605,1243, 1242,2606,1242, 
5, // chain 531
1242,1921,1242, 1079,1629,1079, 1584,2607,1584, 
1585,2608,1585, 33842,2609,1074, 1583,2610,1583, 33841,2611,1073, 
8, // chain 532
1245,2612,1245, 1243,2605,1243, 1586,2613,1586, 
34351,2614,1583, 1073,2615,1073, 1245,2612,1245, 34355,2616,1587, 33838,2617,1070, 1069,2618,1069, 1245,2612,1245, 
3, // chain 533
1584,2619,1584, 1237,1906,1237, 1588,2620,1588, 
1589,2621,1589, 1074,1624,1074, 
2, // chain 534
1072,2622,1072, 1588,2623,1588, 1071,2624,1071, 
34003,2625,1235, 
1, // chain 535
1221,1850,1221, 1225,1870,1225, 1217,1833,1217, 
1, // chain 536
1101,1671,1101, 1102,1675,1102, 1230,1882,1230, 
1, // chain 537
929,1458,929, 931,1460,931, 944,1690,944, 
1, // chain 538
987,2626,987, 1467,2627,1467, 975,2628,975, 
1, // chain 539
1079,2629,1079, 1080,2630,1080, 1237,2631,1237, 
2, // chain 540
25,2632,25, 228,2633,228, 557,2634,557, 
28,2635,28, 
3, // chain 541
10,10,10, 11,11,11, 481,2636,481, 
556,2637,556, 33248,2638,480, 
1, // chain 542
25,2639,25, 21,2640,21, 228,2641,228, 
2, // chain 543
557,2642,557, 90,2643,90, 30,2644,30, 
28,2645,28, 
2, // chain 544
549,754,549, 514,2646,514, 96,2647,96, 
94,751,94, 
4, // chain 545
96,2647,96, 514,2646,514, 98,2648,98, 
33296,2649,528, 33269,2650,501, 33024,2651,256, 
1, // chain 546
74,2652,74, 634,2653,634, 86,2654,86, 
2, // chain 547
446,2655,446, 340,2656,340, 341,495,341, 
409,496,409, 
3, // chain 548
276,2657,276, 145,2658,145, 144,2659,144, 
279,2660,279, 33455,2661,687, 
1, // chain 549
359,2662,359, 209,2663,209, 173,185,173, 
2, // chain 550
210,2664,210, 390,2665,390, 198,211,198, 
33147,2666,379, 
4, // chain 551
229,260,229, 534,2667,534, 71,259,71, 
33303,2668,535, 70,2669,70, 32992,2670,224, 
2, // chain 552
58,2671,58, 55,2672,55, 54,2673,54, 
73,2674,73, 
2, // chain 553
99,702,99, 514,2675,514, 303,708,303, 
97,710,97, 
1, // chain 554
698,1008,698, 699,1007,699, 916,1385,916, 
1, // chain 555
658,926,658, 694,2676,694, 657,925,657, 
3, // chain 556
371,427,371, 333,2677,333, 1590,2678,1590, 
1201,2679,1201, 33970,2680,1202, 
1, // chain 557
335,2681,335, 333,2682,333, 371,2683,371, 
2, // chain 558
316,358,316, 300,362,300, 392,474,392, 
312,354,312, 
1, // chain 559
332,2684,332, 1590,2685,1590, 333,2682,333, 
1, // chain 560
300,409,300, 357,408,357, 392,463,392, 
1, // chain 561
1201,2679,1201, 370,426,370, 371,427,371, 
1, // chain 562
280,320,280, 282,322,282, 317,2686,317, 
1, // chain 563
281,2687,281, 372,2688,372, 283,363,283, 
4, // chain 564
388,457,388, 389,458,389, 1591,2689,1591, 
33158,459,390, 210,456,210, 388,457,388, 
3, // chain 565
311,353,311, 312,354,312, 400,476,400, 
928,2690,928, 310,352,310, 
3, // chain 566
401,2691,401, 397,471,397, 398,472,398, 
414,2692,414, 33167,473,399, 
2, // chain 567
169,2693,169, 454,2694,454, 183,2695,183, 
184,2696,184, 
1, // chain 568
445,1901,445, 576,821,576, 578,824,578, 
1, // chain 569
373,2697,373, 372,2698,372, 281,321,281, 
1, // chain 570
195,207,195, 454,2694,454, 169,208,169, 
1, // chain 571
168,180,168, 418,1435,418, 925,1434,925, 
1, // chain 572
410,497,410, 440,551,440, 409,496,409, 
2, // chain 573
444,2699,444, 566,2700,566, 576,2701,576, 
445,2702,445, 
1, // chain 574
185,197,185, 186,198,186, 417,1129,417, 
2, // chain 575
443,554,443, 455,2703,455, 458,1383,458, 
442,553,442, 
1, // chain 576
35,38,35, 37,40,37, 459,576,459, 
1, // chain 577
511,660,511, 497,663,497, 508,657,508, 
1, // chain 578
482,607,482, 11,2704,11, 483,2705,483, 
1, // chain 579
52,2706,52, 483,614,483, 51,615,51, 
1, // chain 580
478,2707,478, 52,2708,52, 48,51,48, 
1, // chain 581
488,2709,488, 508,2710,508, 491,2711,491, 
3, // chain 582
509,2712,509, 508,2713,508, 488,2714,488, 
484,618,484, 486,621,486, 
1, // chain 583
506,772,506, 507,2715,507, 546,773,546, 
3, // chain 584
501,643,501, 502,644,502, 504,647,504, 
551,2716,551, 33310,2717,542, 
3, // chain 585
245,642,245, 257,291,257, 248,297,248, 
33029,295,261, 33026,292,258, 
1, // chain 586
535,2718,535, 19,247,19, 224,249,224, 
6, // chain 587
559,789,559, 228,790,228, 227,2719,227, 
1592,2720,1592, 32774,2721,6, 522,2722,522, 553,788,553, 559,789,559, 
1, // chain 588
534,725,534, 229,681,229, 519,680,519, 
2, // chain 589
49,2723,49, 301,341,301, 63,344,63, 
60,2724,60, 
1, // chain 590
95,105,95, 531,714,531, 92,102,92, 
1, // chain 591
526,696,526, 531,2725,531, 525,695,525, 
1, // chain 592
538,763,538, 539,760,539, 513,2726,513, 
2, // chain 593
537,730,537, 512,731,512, 543,2727,543, 
33278,2728,510, 
1, // chain 594
537,730,537, 543,2727,543, 536,729,536, 
1, // chain 595
513,2729,513, 512,2730,512, 538,2731,538, 
1, // chain 596
545,2732,545, 544,774,544, 546,773,546, 
1, // chain 597
301,2733,301, 49,52,49, 50,53,50, 
3, // chain 598
94,2734,94, 93,2735,93, 550,770,550, 
33320,766,552, 33295,764,527, 
1, // chain 599
94,2734,94, 550,770,550, 547,2736,547, 
2, // chain 600
501,2650,501, 551,2737,551, 527,2738,527, 
528,2649,528, 
1, // chain 601
524,692,524, 530,2739,530, 304,346,304, 
1, // chain 602
520,777,520, 16,2740,16, 8,8,8, 
1, // chain 603
11,11,11, 482,2741,482, 481,2636,481, 
2, // chain 604
42,2742,42, 563,1171,563, 46,1170,46, 
43,2743,43, 
1, // chain 605
560,797,560, 461,2744,461, 462,795,462, 
1, // chain 606
588,836,588, 590,838,590, 728,1093,728, 
1, // chain 607
728,2745,728, 727,2746,727, 588,836,588, 
2, // chain 608
635,897,635, 636,898,636, 670,2747,670, 
668,2748,668, 
2, // chain 609
647,2749,647, 660,2750,660, 656,2751,656, 
646,2752,646, 
1, // chain 610
647,2749,647, 667,2753,667, 660,2750,660, 
1, // chain 611
647,941,647, 663,2754,663, 662,939,662, 
2, // chain 612
664,2755,664, 661,929,661, 649,932,649, 
650,2756,650, 
1, // chain 613
665,936,665, 662,2757,662, 661,934,661, 
2, // chain 614
242,2758,242, 665,936,665, 231,937,231, 
230,2759,230, 
1, // chain 615
243,276,243, 680,2760,680, 679,1384,679, 
3, // chain 616
669,944,669, 668,943,668, 678,957,678, 
33439,2761,671, 33438,2762,670, 
3, // chain 617
679,958,679, 678,957,678, 916,2763,916, 
33439,2761,671, 698,2764,698, 
1, // chain 618
691,986,691, 667,994,667, 240,273,240, 
1, // chain 619
152,2765,152, 145,2658,145, 276,2657,276, 
2, // chain 620
686,969,686, 677,1010,677, 685,968,685, 
33444,2766,676, 
1, // chain 621
685,2767,685, 676,1013,676, 159,171,159, 
1, // chain 622
624,882,624, 631,890,631, 623,2768,623, 
3, // chain 623
722,2769,722, 619,876,619, 621,877,621, 
712,1046,712, 33391,879,623, 
1, // chain 624
632,891,632, 714,2770,714, 631,890,631, 
1, // chain 625
733,1087,733, 757,2771,757, 740,1086,740, 
1, // chain 626
597,1098,597, 595,2772,595, 745,1097,745, 
1, // chain 627
608,2773,608, 755,1201,755, 607,1200,607, 
1, // chain 628
459,576,459, 777,1148,777, 460,577,460, 
2, // chain 629
250,284,250, 249,283,249, 793,1165,793, 
89,1167,89, 
1, // chain 630
583,831,583, 795,1175,795, 128,140,128, 
2, // chain 631
799,1181,799, 610,861,610, 612,865,612, 
33379,862,611, 
2, // chain 632
158,170,158, 626,2774,626, 797,2775,797, 
157,169,157, 
1, // chain 633
626,2776,626, 622,2777,622, 797,2778,797, 
1, // chain 634
157,169,157, 798,2779,798, 155,167,155, 
1, // chain 635
612,865,612, 800,2780,800, 799,1181,799, 
1, // chain 636
155,2781,155, 798,1180,798, 799,1181,799, 
1, // chain 637
136,148,136, 137,149,137, 819,1216,819, 
1, // chain 638
798,1180,798, 157,2782,157, 797,1177,797, 
1, // chain 639
747,1101,747, 749,1103,749, 709,1039,709, 
1, // chain 640
754,1115,754, 711,1107,711, 750,1106,750, 
1, // chain 641
818,1215,818, 819,1216,819, 885,1331,885, 
6, // chain 642
1593,2783,1593, 889,2784,889, 862,1278,862, 
863,1281,863, 864,1283,864, 787,1159,787, 33004,269,236, 33002,267,234, 
1, // chain 643
862,1278,862, 889,2784,889, 122,2785,122, 
1, // chain 644
821,1222,821, 822,1223,822, 830,2786,830, 
1, // chain 645
829,2787,829, 270,306,270, 821,1222,821, 
1, // chain 646
274,829,274, 275,1238,275, 582,828,582, 
2, // chain 647
126,138,126, 860,2788,860, 591,839,591, 
125,137,125, 
1, // chain 648
738,1078,738, 810,1203,810, 737,1077,737, 
1, // chain 649
753,1114,753, 866,1294,866, 801,2789,801, 
2, // chain 650
878,2790,878, 238,2791,238, 564,806,564, 
877,2792,877, 
1, // chain 651
564,806,564, 238,2791,238, 563,805,563, 
1, // chain 652
46,2793,46, 273,309,273, 45,310,45, 
1, // chain 653
26,29,26, 27,30,27, 29,32,29, 
1, // chain 654
877,1313,877, 564,2794,564, 876,1311,876, 
2, // chain 655
1593,2783,1593, 787,1159,787, 788,1160,788, 
889,2784,889, 
1, // chain 656
138,150,138, 139,151,139, 137,149,137, 
1, // chain 657
574,2795,574, 772,2796,772, 572,2797,572, 
2, // chain 658
789,2798,789, 790,2799,790, 901,1362,901, 
902,1363,902, 
4, // chain 659
142,1337,142, 888,1336,888, 903,2800,903, 
882,2801,882, 33668,2802,900, 1594,2803,1594, 
1, // chain 660
902,2804,902, 888,1336,888, 789,1339,789, 
2, // chain 661
881,1322,881, 882,1323,882, 1594,2805,1594, 
778,2806,778, 
4, // chain 662
780,1151,780, 774,1145,774, 884,2807,884, 
779,1150,779, 33546,1149,778, 33649,2808,881, 
1, // chain 663
774,1145,774, 775,1146,775, 884,2807,884, 
4, // chain 664
914,1381,914, 188,200,188, 189,201,189, 
220,243,220, 32987,242,219, 32982,237,214, 
1, // chain 665
188,200,188, 914,1381,914, 187,199,187, 
2, // chain 666
790,2809,790, 785,1366,785, 226,251,226, 
901,2810,901, 
2, // chain 667
900,2811,900, 777,1148,777, 778,1149,778, 
1594,2812,1594, 
1, // chain 668
902,1363,902, 903,1364,903, 888,2813,888, 
1, // chain 669
780,1151,780, 771,1142,771, 774,1145,774, 
2, // chain 670
179,2814,179, 180,1350,180, 905,1368,905, 
906,1369,906, 
1, // chain 671
193,1374,193, 179,2815,179, 906,1373,906, 
2, // chain 672
887,1334,887, 762,1127,762, 763,1128,763, 
895,1349,895, 
1, // chain 673
84,88,84, 645,2816,645, 83,86,83, 
1, // chain 674
648,2817,648, 663,2818,663, 647,2819,647, 
3, // chain 675
231,1397,231, 920,1396,920, 233,2820,233, 
33685,2821,917, 33687,1399,919, 
1, // chain 676
681,960,681, 655,945,655, 669,944,669, 
1, // chain 677
554,2822,554, 558,786,558, 553,788,553, 
4, // chain 678
765,2823,765, 922,2824,922, 924,2825,924, 
33695,2826,927, 32933,177,165, 33691,2827,923, 
1, // chain 679
764,1131,764, 924,2828,924, 419,1130,419, 
1, // chain 680
927,1439,927, 165,2829,165, 166,1440,166, 
1, // chain 681
925,2830,925, 166,2831,166, 168,2832,168, 
1, // chain 682
408,1450,408, 405,2833,405, 342,1449,342, 
1, // chain 683
366,422,366, 367,423,367, 342,1449,342, 
2, // chain 684
1260,2834,1260, 1163,2835,1163, 932,2836,932, 
930,2837,930, 
2, // chain 685
1010,2838,1010, 959,2839,959, 961,2840,961, 
1011,2841,1011, 
1, // chain 686
1162,2842,1162, 1334,2843,1334, 1163,2844,1163, 
1, // chain 687
970,2845,970, 969,1959,969, 973,1958,973, 
1, // chain 688
971,1507,971, 1281,2846,1281, 1279,2433,1279, 
2, // chain 689
384,2847,384, 426,2848,426, 387,2849,387, 
385,2850,385, 
2, // chain 690
1074,2851,1074, 1589,2852,1589, 1072,2853,1072, 
34356,2854,1588, 
1, // chain 691
1237,2855,1237, 1584,2607,1584, 1079,1629,1079, 
2, // chain 692
1187,2856,1187, 1058,2857,1058, 1057,2311,1057, 
1188,2310,1188, 
1, // chain 693
1463,2312,1463, 1062,1612,1062, 1061,1611,1061, 
2, // chain 694
1113,2858,1113, 1338,2859,1338, 972,2860,972, 
973,2861,973, 
1, // chain 695
1334,2862,1334, 1162,2842,1162, 960,2863,960, 
1, // chain 696
1125,1709,1125, 1442,2262,1442, 1126,1710,1126, 
3, // chain 697
1164,1767,1164, 1024,1766,1024, 1595,2864,1595, 
1018,1733,1018, 33907,2865,1139, 
3, // chain 698
1461,2304,1461, 1445,2307,1445, 1432,2866,1432, 
1462,2305,1462, 34199,2867,1431, 
2, // chain 699
1201,2868,1201, 361,2869,361, 362,2870,362, 
370,2871,370, 
2, // chain 700
1105,2872,1105, 451,1743,451, 1149,1744,1149, 
1107,2403,1107, 
2, // chain 701
1174,2295,1174, 1169,2873,1169, 1168,2281,1168, 
1457,2296,1457, 
3, // chain 702
1187,2874,1187, 1186,2875,1186, 1596,2876,1596, 
1058,1608,1058, 33940,2877,1172, 
1, // chain 703
1202,1812,1202, 1590,2878,1590, 332,2879,332, 
1, // chain 704
446,2880,446, 447,1673,447, 340,1672,340, 
1, // chain 705
421,524,421, 1193,1798,1193, 1213,1823,1213, 
1, // chain 706
1239,1911,1239, 330,1912,330, 331,1908,331, 
3, // chain 707
1228,2881,1228, 1210,2882,1210, 326,374,326, 
329,377,329, 1227,2883,1227, 
1, // chain 708
1210,2882,1210, 324,372,324, 326,374,326, 
1, // chain 709
1075,1647,1075, 1236,2884,1236, 430,1648,430, 
1, // chain 710
1588,2620,1588, 1237,1906,1237, 1235,1897,1235, 
1, // chain 711
1240,1915,1240, 1104,1678,1104, 1106,1680,1106, 
1, // chain 712
1159,1760,1159, 1160,1762,1160, 1252,1935,1252, 
1, // chain 713
1268,1955,1268, 1112,1956,1112, 973,1958,973, 
1, // chain 714
1013,1554,1013, 1016,1557,1016, 1358,2150,1358, 
1, // chain 715
1286,2040,1286, 1317,2034,1317, 1288,2035,1288, 
1, // chain 716
940,1491,940, 939,2885,939, 958,1490,958, 
1, // chain 717
1316,2033,1316, 1307,2037,1307, 1302,2003,1302, 
4, // chain 718
1026,2081,1026, 1140,2886,1140, 1335,2077,1335, 
33907,2887,1139, 1595,2888,1595, 1024,2078,1024, 
1, // chain 719
1323,2889,1323, 1311,2890,1311, 1312,2891,1312, 
1, // chain 720
1014,1970,1014, 1276,1971,1276, 1015,2892,1015, 
2, // chain 721
1597,2893,1597, 1018,2894,1018, 1015,1556,1015, 
1276,2895,1276, 
3, // chain 722
1597,2896,1597, 1276,2897,1276, 1165,1768,1165, 
1164,1767,1164, 1018,1733,1018, 
1, // chain 723
1357,2149,1357, 932,2073,932, 1334,2898,1334, 
2, // chain 724
946,1477,946, 1338,2088,1338, 1110,2899,1110, 
945,1476,945, 
1, // chain 725
1333,2066,1333, 972,2065,972, 1338,2088,1338, 
2, // chain 726
1277,1972,1277, 1278,1973,1278, 1344,2102,1344, 
1166,2100,1166, 
1, // chain 727
1025,2900,1025, 1027,2901,1027, 1343,2902,1343, 
1, // chain 728
1336,2903,1336, 1026,2081,1026, 1025,2904,1025, 
2, // chain 729
1342,2905,1342, 1341,2906,1341, 1019,1560,1019, 
1345,2128,1345, 
2, // chain 730
1324,2907,1324, 1325,2908,1325, 1355,2909,1355, 
34094,2910,1326, 
3, // chain 731
1324,2907,1324, 1355,2909,1355, 1348,2111,1348, 
34122,2911,1354, 1347,2109,1347, 
1, // chain 732
1323,2047,1323, 1324,2048,1324, 1348,2912,1348, 
1, // chain 733
952,2913,952, 951,1485,951, 1349,2118,1349, 
1, // chain 734
967,2914,967, 968,2061,968, 1331,2062,1331, 
2, // chain 735
1021,2915,1021, 1020,2123,1020, 1354,2916,1354, 
1355,2917,1355, 
1, // chain 736
1354,2916,1354, 1020,2123,1020, 1351,2122,1351, 
1, // chain 737
1326,2054,1326, 1325,2918,1325, 1320,2053,1320, 
1, // chain 738
1021,2919,1021, 1355,2920,1355, 1327,2055,1327, 
1, // chain 739
950,1481,950, 1336,2085,1336, 947,1478,947, 
1, // chain 740
1300,1998,1300, 1292,1999,1292, 1290,2006,1290, 
1, // chain 741
1297,2921,1297, 1314,2025,1314, 1298,2028,1298, 
1, // chain 742
578,2922,578, 1148,1741,1148, 450,1742,450, 
1, // chain 743
586,834,586, 1362,2923,1362, 585,833,585, 
5, // chain 744
849,2924,849, 848,2163,848, 1048,1598,1048, 
851,2925,851, 34292,2449,1524, 33817,1599,1049, 1363,2164,1363, 
2, // chain 745
1403,2926,1403, 1393,2197,1393, 1394,2198,1394, 
1406,2366,1406, 
1, // chain 746
1428,2245,1428, 1464,2927,1464, 1431,2928,1431, 
1, // chain 747
1445,2307,1445, 1433,2929,1433, 1432,2866,1432, 
1, // chain 748
1435,2930,1435, 1434,2931,1434, 1441,2932,1441, 
1, // chain 749
1462,2316,1462, 1431,2933,1431, 1464,2314,1464, 
2, // chain 750
1173,2934,1173, 1458,2935,1458, 1460,2936,1460, 
1462,2937,1462, 
2, // chain 751
1172,2938,1172, 1173,2939,1173, 1059,2940,1059, 
1058,2941,1058, 
1, // chain 752
1453,2283,1453, 1455,2285,1455, 1452,2282,1452, 
1, // chain 753
1003,1716,1003, 1465,2942,1465, 1000,2943,1000, 
1, // chain 754
1051,1601,1051, 1052,1602,1052, 1054,1604,1054, 
5, // chain 755
1482,2944,1482, 975,2945,975, 990,1527,990, 
1469,2342,1469, 34236,2340,1468, 33759,1530,991, 994,1533,994, 
1, // chain 756
1407,2212,1407, 1411,2216,1411, 994,2946,994, 
1, // chain 757
1377,2179,1377, 1379,2947,1379, 837,2349,837, 
1, // chain 758
827,2362,827, 808,2948,808, 1397,2949,1397, 
1, // chain 759
989,2374,989, 1483,2373,1483, 1484,2376,1484, 
1, // chain 760
1486,2379,1486, 982,1518,982, 983,1519,983, 
1, // chain 761
1379,2477,1379, 836,1242,836, 837,1243,837, 
2, // chain 762
929,1949,929, 1265,1951,1265, 1567,2541,1567, 
1264,2950,1264, 
1, // chain 763
1370,2951,1370, 1488,2497,1488, 1371,2452,1371, 
1, // chain 764
1381,2952,1381, 1486,2379,1486, 1479,2381,1479, 
1, // chain 765
1381,2184,1381, 1380,2183,1380, 1486,2953,1486, 
1, // chain 766
1400,2204,1400, 1527,2954,1527, 1380,2458,1380, 
2, // chain 767
1392,2195,1392, 1063,2955,1063, 1062,2956,1062, 
1391,2194,1391, 
1, // chain 768
1065,2196,1065, 1063,2955,1063, 1392,2195,1392, 
1, // chain 769
1488,2382,1488, 1370,2957,1370, 1479,2381,1479, 
1, // chain 770
1480,2367,1480, 1540,2498,1540, 1492,2958,1492, 
4, // chain 771
856,2959,856, 851,2925,851, 1523,2448,1523, 
875,2475,875, 34298,2474,1530, 34293,2450,1525, 
1, // chain 772
851,2925,851, 1524,2449,1524, 1523,2448,1523, 
2, // chain 773
834,1240,834, 835,1241,835, 1180,1785,1180, 
33604,1242,836, 
1, // chain 774
802,2501,802, 1481,2368,1481, 803,2369,803, 
1, // chain 775
801,2500,801, 866,2960,866, 1540,2498,1540, 
2, // chain 776
868,1296,868, 869,1297,869, 871,1299,871, 
33638,1298,870, 
2, // chain 777
868,1296,868, 1540,2510,1540, 867,1295,867, 
33634,1294,866, 
1, // chain 778
1156,1754,1156, 1157,1757,1157, 1158,1759,1158, 
1, // chain 779
1503,2413,1503, 1504,2414,1504, 1505,2415,1505, 
1, // chain 780
893,1347,893, 894,1348,894, 915,1382,915, 
3, // chain 781
1039,1583,1039, 1040,1585,1040, 1545,2509,1545, 
33810,1588,1042, 1495,2399,1495, 
5, // chain 782
1539,2489,1539, 1547,2515,1547, 1555,2523,1555, 
1564,2537,1564, 34268,2409,1500, 34324,2524,1556, 1257,2408,1257, 
2, // chain 783
1542,2961,1542, 1539,2489,1539, 1564,2537,1564, 
1565,2538,1565, 
1, // chain 784
1557,2526,1557, 1256,2962,1256, 1258,2525,1258, 
1, // chain 785
896,1351,896, 434,543,434, 436,545,436, 
1, // chain 786
1560,2531,1560, 1561,2532,1561, 1496,2534,1496, 
1, // chain 787
1255,1938,1255, 1559,2530,1559, 1562,2535,1562, 
1, // chain 788
912,1596,912, 221,2963,221, 222,1683,222, 
1, // chain 789
223,2964,223, 218,2965,218, 217,2966,217, 
1, // chain 790
893,1347,893, 1041,2967,1041, 890,1344,890, 
1, // chain 791
1544,2968,1544, 1545,2969,1545, 1552,2970,1552, 
1, // chain 792
1172,1776,1172, 1596,2971,1596, 1171,1775,1171, 
1, // chain 793
1171,2972,1171, 1596,2876,1596, 1186,2875,1186, 
1, // chain 794
1420,2236,1420, 1568,2562,1568, 1419,2234,1419, 
1, // chain 795
1441,2973,1441, 1430,2974,1430, 1433,2975,1433, 
1, // chain 796
1429,2246,1429, 1574,2569,1574, 1426,2243,1426, 
1, // chain 797
1117,2976,1117, 1578,2977,1578, 1114,2978,1114, 
2, // chain 798
1570,2979,1570, 1578,2980,1578, 1117,2590,1117, 
1579,2589,1579, 
2, // chain 799
1577,2583,1577, 1570,2564,1570, 1571,2565,1571, 
1572,2566,1572, 
1, // chain 800
1577,2583,1577, 1578,2584,1578, 1570,2564,1570, 
1, // chain 801
1515,2981,1515, 1274,2982,1274, 1132,2983,1132, 
1, // chain 802
1585,2984,1585, 1583,2985,1583, 1242,2986,1242, 
1, // chain 803
1101,1879,1101, 1230,2987,1230, 1229,1877,1229, 
2, // chain 804
1110,2988,1110, 1338,2989,1338, 1113,2990,1113, 
1111,2991,1111, 
1, // chain 805
1467,2992,1467, 976,2993,976, 975,2994,975, 

 0};


// mesh info for object donkeykong_small (with tag [ | o model])
const tgx::Mesh3D<tgx::RGB565> donkeykong_small PROGMEM = 
    {
    1, // version/id
    
    1598, // number of vertices
    2995, // number of texture coords
    1598, // number of normal vectors
    3200, // number of triangles
    15243, // size of the face array. 

    donkeykong_small_vert_array, // array of vertices
    donkeykong_small_tex_array, // array of texture coords
    donkeykong_small_norm_array, // array of normal vectors        
    donkeykong_small_face, // array of face vertex indexes   
    
    &donkeykong_texture, // pointer to texture image 
    
    { 0.75f , 0.75f, 0.75f }, // default color
    
    0.1f, // ambiant light strength 
    0.7f, // diffuse light strength
    0.6f, // specular light strength
    32, // specular exponent
    
    nullptr, // next mesh to draw after this one    
    
    { // mesh bounding box
    -0.8921341807319203f, 0.8921341807319203f, 
    -0.9092257280097704f, 0.9092257280097704f, 
    -1.0f, 1.0f
    },
    
    "donkeykong_small" // model name    
    };
    
                
/** end of donkeykong_small.h */
    
    
    