// 3D model [naruto]
//
// - vertices   : 1326
// - textures   : 1145
// - normals    : 1596
// - triangles  : 2472
//
// - memory size: 61kb
//
// - model bounding box: [-0.8,0.8]x[-1.0,1.0]x[-0.2,0.2]
//
// object [naruto_1] (tagged [ | g Body.bmp | usemtl Body.bmp]) with 2166 triangles (250 chains)
// object [naruto_2] (tagged [g Head.bmp | usemtl Head.bmp]) with 298 triangles (45 chains)
// object [naruto_3] (tagged [g Eye.bmp | usemtl Eye.bmp]) with 8 triangles (3 chains)

#pragma once

#include <tgx.h>

#include "naruto_body_texture.h" // texture for object [naruto_1]

#include "naruto_head_texture.h" // texture for object [naruto_2]

#include "naruto_eye_texture.h" // texture for object [naruto_3]


// vertex array: 15kb.
const tgx::fVec3 naruto_vert_array[1326] PROGMEM = {
{0.47319183483182337,0.24162330723210745,-0.050456744970095564},
{0.4671941603889574,0.30364920723943234,0.013004932488957503},
{0.3714407644208081,0.23958925801550482,-0.0683600275339623},
{0.3968299224426658,0.3065881425004072,0.009901397708671501},
{0.4719055505373434,0.37807414000583855,0.00044870382365581847},
{0.402595766576643,0.38223960716877653,-0.009714437782148226},
{0.47877071903927726,0.3950426229370888,-0.09203663262886708},
{0.3936665604858923,0.40913932661297153,-0.1135893729584677},
{0.4869520854239348,0.34634337606028254,-0.13639100559724365},
{0.39268689047091054,0.34673958153657064,-0.15632093376462247},
{0.3906976368527031,0.27868616828210646,-0.13631622162663437},
{0.485000223791032,0.2819693341597959,-0.11820354394506159},
{0.3690102853760057,0.2798005242281555,-0.1445200232024747},
{0.3382366814702783,0.27875354863962537,-0.13773711706821107},
{0.3422151887066931,0.2382281897504158,-0.0684647250928153},
{0.2656812731851341,0.26925605915621487,-0.1394496699951641},
{0.2698616971421941,0.25314751710300076,-0.06755983904844276},
{0.1792609167490256,0.2727260353924863,-0.1339156561700758},
{0.19246028756156727,0.2524446225632438,-0.06907047525475064},
{0.13142161075025557,0.2249015366198969,-0.13903087975975198},
{0.18533337516250087,0.18861642886423455,-0.07065589543166784},
{0.14420219132738515,0.18308241503914627,-0.1458137858940156},
{0.19505529134171004,0.11727252090296122,-0.07177765499080735},
{0.13821947367864107,0.11128980325421711,-0.13758754912699248},
{0.11802780161412972,0.07464565765565948,-0.12861347265387632},
{0.1815941766320358,0.07913269589221746,-0.06878629616643532},
{0.3745742127893378,0.3486541259681392,-0.16281966081057075},
{0.34220771030963215,0.3509650254439372,-0.15759226126498058},
{0.27175373159860944,0.3675744705322924,-0.1578465267650522},
{0.18833221238393383,0.4022743076789791,-0.16394889876677118},
{0.1501923873731902,0.35989423153468797,-0.15690424873537498},
{0.0006319245516485688,0.2193675975787792,-0.15911785426541034},
{-0.00013087194856630435,0.18009105621477428,-0.17797089325601517},
{-0.00013087194856630435,0.107550604723752,-0.17124033590117807},
{-0.00013087194856630435,0.07090645912519436,-0.14880514471838768},
{-0.1271215324402208,0.6655586798221144,-0.04368131723289287},
{-0.11941130507040185,0.685615740739529,-0.022113620109170378},
{-0.10973425927355826,0.7213549255097434,-0.012735710194763996},
{-0.10433485659556671,0.718685212542962,-0.05456986335360714},
{-0.1035645816982909,0.6791021316834296,-0.05818192913403638},
{-0.09552530485779102,0.6640182048115336,-0.08855169959847364},
{-0.05329479665471858,0.7132632998898171,-0.1004124373371088},
{-0.051043799139378614,0.6726333182257249,-0.10012825824879347},
{-0.03853991925350344,0.6655960718074192,-0.1261530800208303},
{0.0006244461545876386,0.7127473652765834,-0.11744822584190764},
{0.0006094893604657784,0.6742111852216105,-0.11215352072276911},
{0.038487570474076874,0.6655212878368097,-0.12658682705036428},
{0.05290592000755017,0.7131961438842099,-0.10071905161660695},
{0.05141771899242507,0.6725659378682061,-0.1004573077194744},
{0.09517382019592724,0.6639658560321069,-0.0885217860102299},
{0.10431242140438386,0.7186328637635356,-0.05446516579475411},
{0.10284665558044156,0.6789598925713306,-0.05883254967833731},
{0.12714396763140354,0.6655137346557782,-0.04338965974751659},
{0.10938277461169449,0.7213101299113485,-0.012593620650606322},
{0.11914956117326923,0.6854886079894932,-0.022637107903435486},
{0.08419553331048181,0.6775614323209367,-0.07079050657876458},
{0.10398337193370294,0.6199853281328064,-0.04640345376307143},
{0.09748464488775464,0.63996005189858,-0.02563594512486847},
{0.09514390660768353,0.6397880487661787,-0.0015330713974906652},
{0.06690547930561136,0.6383298361232678,-0.04590240115998912},
{0.07145982311571782,0.6349196870634838,-0.06204826041453727},
{0.02818981772117609,0.6317563251067103,-0.08896301143682478},
{0.00045244302218624564,0.6383073261481146,-0.07177765499080735},
{0.0005945325663439181,0.6400497926633112,-0.10812266470692777},
{-0.02864599994189288,0.6317487719256787,-0.08919484174571363},
{-0.06695782808503792,0.6383896632997553,-0.045700484439344005},
{-0.07137756074804763,0.6348898482592106,-0.06262409698822889},
{-0.09770151840252168,0.6400049970649161,-0.025688293904294977},
{-0.09480737873994173,0.6398403975456051,-0.0015555065886734552},
{-0.10391606636015462,0.6200376769122328,-0.04650067292486352},
{-0.08481624026653908,0.6776137811003631,-0.07073067940227713},
{-0.03835295932698019,0.6740764992905431,-0.09422032457065867},
{0.0003103534780285732,0.6186840122602336,-0.11519722832656767},
{0.038674530400600135,0.6740017901039045,-0.09465407160019262},
{0.05179911724253251,0.6152440243961765,-0.08671949231854574},
{-0.00013087194856630435,0.03495780445330319,-0.13683223102383854},
{0.10681020602273453,0.036453483865489314,-0.11589271925323419},
{-0.00013087194856630435,-0.04057400586209109,-0.14954550602741976},
{0.12475835896896682,-0.036834807331625974,-0.1301016736690014},
{0.1696287413345476,0.038697002983768304,-0.05905690159016521},
{0.19505529134171004,-0.03384344850725399,-0.06055258100235124},
{0.19056825310515194,0.03794916327767531,0.05386689402987972},
{0.21300344428794235,-0.039078326449904964,0.0643366499151819},
{0.08736637366431618,0.017757491213163994,0.1451033381732273},
{0.10531452661054849,-0.0630091970448814,0.1525817352341574},
{-0.00013087194856630435,0.009531254446140763,0.1765126058291338},
{-0.00013087194856630435,-0.07572247204846261,0.18548668230225},
{-0.1055762705076811,-0.0630091970448814,0.1525817352341574},
{-0.0876281175614488,0.017757491213163994,0.1451033381732273},
{-0.21251734847898193,-0.039078326449904964,0.0643366499151819},
{-0.19082999700228456,0.03794916327767531,0.05386689402987972},
{-0.19456919553274965,-0.03384344850725399,-0.06055258100235124},
{-0.1698904852316802,0.038697002983768304,-0.05905690159016521},
{-0.12801146169047148,-0.036834807331625974,-0.1301016736690014},
{-0.10707194991986713,0.036453483865489314,-0.11589271925323419},
{-0.00013087194856630435,-0.15349780148213601,0.17800828524131984},
{-0.1149093100397219,-0.147604824598123,0.1525593000429746},
{-0.2262028151004841,-0.13438301859439852,0.06976596618141717},
{-0.19868979231332212,-0.1308980855640051,-0.059296210296114975},
{-0.1339941793392156,-0.1348018088298107,-0.12711031484462937},
{-0.029296620486193806,-0.13854100736027566,-0.1405714295543036},
{-0.00013087194856630435,-0.1400366867724618,-0.12935383396290842},
{-0.026896055029635234,-0.17374182232607385,-0.12248866546097456},
{-0.00013087194856630435,-0.17368947354664732,-0.11364920013495514},
{-0.00013087194856630435,-0.20061170296599573,0.1458511778793203},
{-0.03759016282676532,-0.28244032360669324,-0.08502937458277554},
{-0.0213769979986688,-0.3010390970972264,0.09589548551230705},
{-0.03441932247293094,-0.312757745291704,0.08575477909768578},
{-0.04611553547622566,-0.294458107683608,-0.0808938210080812},
{-0.14839009368150607,-0.28387617584239183,-0.10184081117574648},
{-0.14586239547491173,-0.26933069355888273,-0.11521966351775048},
{-0.21661551006837165,-0.2706319346474846,-0.05530274626557828},
{-0.21203873106708243,-0.2842127037101337,-0.04813844188120722},
{-0.23976862736901133,-0.27869364667916724,0.0824343708026328},
{-0.23467583897051789,-0.29175840634461214,0.07470918663869199},
{-0.1484424424609326,-0.3055336137308455,0.12647465109445036},
{-0.14254198717985875,-0.29263337880074103,0.1460007458205389},
{-0.072088008468836,-0.30957942654080867,0.13037089596319493},
{-0.06324106474575565,-0.2956845648016005,0.13506732931745907},
{-0.045337782181888935,-0.1803676821220579,0.1588112399859122},
{-0.12751040908738917,-0.1659493325885846,-0.1151000091647756},
{0.11630029189305485,0.8773842765729601,-0.1416707539222603},
{0.07456335789600381,0.8907557253018739,-0.10199037911696508},
{0.11043722859728564,0.8628835898878463,-0.0955440008504433},
{0.09035773248868824,0.8147301912125171,-0.12082846131344807},
{0.07019597401242061,0.8221115186795963,-0.1285536454773889},
{0.09990016713843508,0.7928409977991453,-0.14983716351279605},
{0.053646281316582244,0.7537364595675417,-0.10173611361689346},
{0.07154208548338804,0.8066835107589269,-0.16664860010576696},
{0.05073718485988043,0.7603772761576475,-0.12210726721086712},
{0.05268156809572226,0.7418981570200892,-0.12218952957853736},
{0.03124100372203558,0.7514631016449895,-0.10833205982463383},
{0.03134570128088861,0.8292233247165997,-0.13858965433315712},
{0.01475113820268465,0.8122175245840152,-0.17732027271171424},
{0.0006767949340141495,0.7643408265999405,-0.13331738440520138},
{0.022094924116518037,0.740529610357939,-0.1402199448924399},
{0.0006169677575267085,0.7481799357672998,-0.11711169797416579},
{-0.022035096940030648,0.7406117979416386,-0.13965906511287013},
{-0.03083717028074541,0.7515378108316283,-0.10784596401567337},
{-0.03072499432483146,0.8292083679224778,-0.13883644143616783},
{-0.0712952983803774,0.8195388753066658,-0.1664840753704265},
{-0.05096901516876931,0.7604446565151665,-0.1217782177401862},
{-0.052763830463392544,0.7411352857359038,-0.1225260574462792},
{-0.054042636360811594,0.7538037651410898,-0.10142949933739531},
{-0.0703978907330658,0.8221712710721132,-0.1283816423449875},
{-0.09978051278546027,0.7928933465785717,-0.1499044690863444},
{-0.09061947638582085,0.8147825399919437,-0.12081350451932621},
{-0.1155300169957791,0.8691729966000589,-0.14164831873107755},
{-0.11017548470015313,0.8621880989611795,-0.09561130642399167},
{-0.07425674361650574,0.8908154776943907,-0.10184828957280741},
{-0.07433900598417596,0.8860817271387925,-0.15777922119150384},
{-0.0308596054719282,0.90432138800246,-0.10854145494233987},
{-0.013719119408276347,0.9042616356099431,-0.1694679557977376},
{0.0005496621839783374,0.9057199978207953,-0.10932668663373753},
{0.03121109013379186,0.9043289411834916,-0.10828718944226826},
{0.07373325582224058,0.8913090519004123,-0.1577941779856257},
{-0.1926771610763343,0.252691334882284,-0.06916769441654275},
{-0.26958499645093975,0.2531175287307864,-0.06728313835718835},
{-0.17895430246952754,0.2729727477115265,-0.13390817777301486},
{-0.2655840540233421,0.2692784195634269,-0.14004046336297757},
{-0.3421030127507792,0.23898343306959888,-0.0680160212691595},
{-0.3380422431466942,0.27898545373248484,-0.13760250592111434},
{-0.37126128289134575,0.23908813062845194,-0.06823289478392648},
{-0.36930194286138207,0.2798753829827356,-0.144168538540611},
{-0.39143799816173525,0.27893310495305845,-0.13596473696477065},
{-0.4732815755965546,0.24154852326149806,-0.050172565881780214},
{-0.4848581342468744,0.28217872927750204,-0.11852511501868158},
{-0.4870866965710316,0.3467172211293583,-0.13660787911201064},
{-0.3930907239122008,0.34659008837932254,-0.15652285048526757},
{-0.39433961622137614,0.40910200941163766,-0.11313319073775097},
{-0.47859871590687586,0.39451173152973334,-0.09234324690836522},
{-0.40293229444438483,0.3822993595612934,-0.009729394576270084},
{-0.47184572336085595,0.3778423096969495,0.0005384445883869805},
{-0.3971589719133468,0.3064011077899135,0.009759308164513827},
{-0.46708946283010444,0.3038509743921364,0.012945105312470062},
{-0.37450690721578944,0.34802594061502123,-0.16290192317824095},
{-0.37085744945005555,0.4132374882023612,-0.11317058272305562},
{-0.3712837180825286,0.3844756478899947,-0.01170369140035564},
{-0.34886348369386,0.3084428597554885,0.001331154676845574},
{0.28759297657365945,0.4570161741649876,-0.08239697881732815},
{0.28555885257308644,0.4563280868514113,-0.03961306923174688},
{0.27755696771789123,0.44511049126001623,-0.04061517443791151},
{0.2515919731223418,0.461899567445775,-0.010155663208743103},
{0.2594816820216231,0.4730571862927414,-0.00988644091454962},
{0.21532174737683066,0.48633134107589227,-0.011397077120857505},
{0.22351059215854918,0.4982669375691075,-0.010469755885302167},
{0.1916526206789868,0.5046311282519295,-0.04276147439439846},
{0.1998414654607053,0.5165665751772034,-0.041841631555904056},
{0.19368674467955982,0.505326619178596,-0.08554538397997972},
{0.20187558946127832,0.5172546624907797,-0.08462554114148532},
{0.22047436295181155,0.48838790026764806,-0.11535427466484721},
{0.228558510174677,0.5002635948004053,-0.11517479313538488},
{0.2557275266970362,0.4633876936769294,-0.1146812189293635},
{0.2639163714787547,0.47531573698911306,-0.1137613760908691},
{0.27745227015903823,0.4464116575646473,-0.08313734012636023},
{0.10456668690445547,0.09832974114762512,0.16680564644404652},
{-0.00013087194856630435,0.14918284116194996,0.19073651703902292},
{-0.00013087194856630435,0.08636430585013691,0.195223555275581},
{0.09260125160696728,0.06766831319781158,0.15932724938311638},
{-0.00013087194856630435,0.057198557312509495,0.19148435674511594},
{0.10082748837399043,0.1581569176350662,0.16231860820748845},
{0.19804665016608208,0.18412939062767658,0.04002438107009806},
{0.2032815281087332,0.1175716567853984,0.04600709871884216},
{0.20178584869654717,0.08466670971730587,0.0482506178371212},
{0.08917614575306128,0.21199382329273156,0.13360904189057768},
{0.1831048128383437,0.2642453835574503,0.024446879992180603},
{0.17403351720343543,0.36195819433953397,0.04330739737984638},
{0.2194722577456469,0.3421702809323423,0.03125222131762702},
{0.273511154907928,0.3156893517235593,0.022517453550460625},
{0.2660402362440588,0.4428594937446762,-0.013618161047953754},
{0.30191410694534065,0.4188014156156933,-0.010080879238133802},
{0.3716800731267578,0.38418391562064763,-0.012107524841645864},
{0.3487737429291288,0.30856236454052227,0.0016377689563437086},
{0.30705176572619963,0.43725824913001,-0.11380624647323467},
{0.3706854463176541,0.4131327906435082,-0.11349215379667561},
{-0.0002804398897849069,0.4846561801342441,0.05524291908909087},
{-0.00041505103688164915,0.44582101376477523,0.08994268145180666},
{0.08497328660481855,0.4576667199253179,0.05651424658944899},
{0.040170209812786156,0.4909006416801208,0.03810243302543902},
{0.13528046363369553,0.4951484459946995,0.004105639986450651},
{0.06797489008532437,0.5063660415860948,0.003260581118565546},
{0.10865737009678428,0.5142182837161008,-0.07054371947575389},
{0.05100640715407391,0.5185333936042282,-0.05321627348557879},
{0.00042252943394252514,0.5241047246306505,-0.12109768360764155},
{0.0002505263015411322,0.5276046892391363,-0.0785904747133147},
{-0.05145511097772978,0.5186081775748373,-0.05288722401489785},
{-0.10821614467018945,0.5143529696471681,-0.06993796931381854},
{-0.06812445802654303,0.506343606394912,0.0027071797360567174},
{-0.1354375099719751,0.49527550396076486,0.004487038236558088},
{-0.03984863873916621,0.4908858344539401,0.03778086195181901},
{-0.08478632667829535,0.45697863261174165,0.05665633613360666},
{0.0002729614927239226,0.6089098220855687,-0.06400012204744003},
{-0.050669879286332105,0.6069803956438486,-0.04214076743834126},
{-0.06570893577586259,0.5899147683347766,0.015742025813257933},
{-0.038151042606335075,0.5774706408414185,0.04442915693898589},
{-8.600156620072359e-05,0.5662156532647187,0.06398516525331818},
{0.038136085812213165,0.5774032604838993,0.04399540990945196},
{0.06591833089356859,0.5898473879772578,0.015532630695551887},
{0.051043799139378565,0.6069130152863297,-0.042477295306083115},
{0.09509155782825703,0.6128809257088932,0.012937626915409133},
{0.1055613137135592,0.6404462224915111,0.010484712679424052},
{0.072080530071775,-0.3098187352467584,0.13054289909559633},
{0.03494281026719599,-0.31272783170346025,0.0856575599358937},
{0.04768599885902093,-0.42550205938228663,0.05902698800192151},
{0.09038764607693196,-0.42533005624988524,0.09515512420327496},
{0.05416976911084735,-0.46743343170292184,0.0460669258953296},
{0.09598148707850769,-0.4681962282031367,0.08403474777367186},
{0.07006136286532387,-0.5861978554275532,0.009071295634908256},
{0.10954729934703494,-0.5937659932532146,0.05949812701676011},
{0.17216391793820293,-0.46826353377668506,0.09808665585115957},
{0.1940531861355454,-0.5935117277531429,0.07254792988808319},
{0.24756111710650047,-0.5822043913970165,0.03099047742049446},
{0.24531759798822142,-0.4527608166693769,0.050464223367156516},
{0.23680718213288293,-0.5708820982467683,-0.06274375134120376},
{0.22460243812944497,-0.45510903334650893,-0.053500452573894124},
{0.17184982526164386,-0.5634485715682037,-0.11391842242914862},
{0.1631449710827212,-0.4712100222186915,-0.10887798281008172},
{0.07326959520446291,-0.5790036374549384,-0.06939952472543158},
{0.06787019252647135,-0.45816021934736845,-0.0716430438437106},
{0.0447993375935019,-0.1800535894454989,0.1585345392946578},
{0.14886123269634463,-0.3057953576279781,0.13814842890656226},
{0.16758713893691368,-0.42604050397067356,0.10967069289854034},
{0.24433792797323958,-0.40995447189261286,0.05859324097238757},
{0.2216858632756822,-0.404697158758779,-0.05338079822091925},
{0.15512812943340407,-0.4039343622585641,-0.1126695301199733},
{0.06193982365715375,-0.40710520261239846,-0.07842594997797424},
{0.11506635637800139,-0.1476571733775495,0.15249947286648718},
{0.23670248457402993,-0.2900832454029638,0.07425300441797525},
{0.22655429976234776,-0.13429327782966743,0.06955657106371113},
{0.21238273733188515,-0.2846314939455457,-0.04816087707239001},
{0.19818126131317884,-0.13135426778472184,-0.05943082144321172},
{0.14835270169620138,-0.28181213825357515,-0.11370902731144258},
{0.1280488536757761,-0.16587454861797535,-0.11526453390011605},
{0.043864537960885644,-0.2916163168004545,-0.08066946909625328},
{0.026701616706050996,-0.17374182232607385,-0.12233161912269502},
{0.029034876589061197,-0.13854100736027566,-0.1405714295543036},
{0.134480275148176,-0.1348018088298107,-0.12711031484462937},
{-0.00013087194856630435,0.14419475032230963,-0.16600545795852698},
{-0.00013087194856630435,0.07090645912519436,-0.14132674765745754},
{0.11204508396538562,0.07464565765565948,-0.12188291529903922},
{0.10755804572882753,0.14643826944058863,-0.14207458736355058},
{0.17262010015891965,0.07913269589221746,-0.06504709763597025},
{0.1703765810406406,0.14748524502911894,-0.07813429249259797},
{0.193559611929524,0.08466670971730587,0.04600709871884216},
{0.1875768942807799,0.14673740532302593,0.044511419306656134},
{0.0881142133704092,0.06766831319781158,0.15110101261609324},
{0.0881142133704092,0.12674764997915966,0.1608229287953024},
{-0.00013087194856630435,0.057198557312509495,0.1817624405659068},
{-0.00013087194856630435,0.11926925291822957,0.18699731850855786},
{-0.08837595726754181,0.12674764997915966,0.1608229287953024},
{-0.0876281175614488,0.06766831319781158,0.15110101261609324},
{-0.1870907984718195,0.14673740532302593,0.044511419306656134},
{-0.19307351612056362,0.08466670971730587,0.04600709871884216},
{-0.1706383249377732,0.14748524502911894,-0.07813429249259797},
{-0.17288184405605225,0.07913269589221746,-0.06504709763597025},
{-0.10707194991986713,0.14643826944058863,-0.14207458736355058},
{-0.11155898815642522,0.07464565765565948,-0.12188291529903922},
{-0.000579575772222112,0.201419444632547,0.1380362529506483},
{-0.07452596591069922,0.21052065385569899,0.11499531160592258},
{-0.1639077675829361,0.2300692585569409,0.027213886904724743},
{-0.14631857769562845,0.2271151421499324,-0.06775427737202695},
{-0.09302004184237943,0.22428830806090075,-0.11634142307689},
{0.0005272269927955469,0.221334416005804,-0.1336688690670651},
{0.09319204497478076,0.22416125009483537,-0.1163189878857072},
{0.14608674738673957,0.22699548779695752,-0.06729809515131022},
{0.1636460236858035,0.22994197623896376,0.027812158669599154},
{0.07504197530790335,0.21113388241469516,0.11474104610585097},
{-0.10379641200717975,-0.614578372273783,0.07266758424105807},
{-0.11045966378846848,-0.7228506049219295,0.04629875620421844},
{-0.08045633478001682,-0.7110945647421473,-0.012115003238706797},
{-0.05712373594991481,-0.6014089150494851,0.008226236767023153},
{-0.07000153568883649,-0.5864745561188076,0.00924329876730965},
{-0.1093977314058164,-0.5938781692091285,0.05958786778149127},
{-0.19376900704723013,-0.5933621598119242,0.0726974978293018},
{-0.19526468645941614,-0.6133743503469733,0.08802821180420856},
{-0.2663244153323742,-0.5981857259162242,0.03446793205382697},
{-0.24781538260657213,-0.5820099530734323,0.030676384743935393},
{-0.2559967489912297,-0.5838346819562993,-0.07368464624134453},
{-0.2366052654122379,-0.570582962364331,-0.06289331928242235},
{-0.17436256667411643,-0.5768872510866951,-0.1353290732145916},
{-0.17226113709999505,-0.563643009891788,-0.11397077120857514},
{-0.06594824448181236,-0.5862352474128578,-0.0860613933771839},
{-0.07327707360152388,-0.5792878165432538,-0.06960891984313762},
{-0.1952048592829287,-0.7231721759955494,0.06244461545876658},
{-0.25707363816800366,-0.7183785234794932,0.017663973857916973},
{-0.2493634107981847,-0.7048575815933316,-0.08110321612578722},
{-0.17953761744028007,-0.6916656891778508,-0.134214792052513},
{-0.09221985335685991,-0.6936025940166316,-0.09950755129273627},
{0.05694425442045243,-0.6013939582553631,0.008428153487668266},
{0.06575380615822812,-0.5860632442804564,-0.08664470834793646},
{0.17496083843899077,-0.5765731584101361,-0.13522437565573855},
{0.255637785932305,-0.5839319011180913,-0.07403613090320825},
{0.2658906683028402,-0.5981558123279805,0.0347221975538986},
{0.19520485928292866,-0.6135687886705574,0.08784125187768531},
{0.10393102315427642,-0.6146008074649658,0.0729741985205562},
{0.08056103233886977,-0.7107729936685273,-0.012167352018133307},
{0.11040731500904191,-0.7228655617160513,0.04592483635117192},
{0.1953992976065128,-0.7234488766868038,0.06274375134120379},
{0.25669223991789614,-0.7185804402001382,0.0179930233285979},
{0.2489072285774679,-0.7051941094610734,-0.08056477153740027},
{0.17917865438135538,-0.6914787292513275,-0.13417740006720835},
{0.09231707251865194,-0.6938643379137642,-0.09953746488097999},
{0.5896678690558101,0.2823805712141765,-0.08242689240557186},
{0.538306238041342,0.2726511018539358,-0.041131183835115694},
{0.5482525061323791,0.2917884695007972,-0.08119295689051839},
{0.5553794185314455,0.33237373035046497,-0.1043311173970362},
{0.5937361170569561,0.32429706152466065,-0.09196184865825777},
{0.6455539302921409,0.302228237013885,-0.09170758315818615},
{0.6490313849254735,0.3517875743366691,-0.09041382046664524},
{0.6887566301131343,0.3093999450113464,-0.09396605907058705},
{0.6916058993933486,0.34468317191275594,-0.09315839218800659},
{0.725602692432337,0.3283428743346237,-0.0911242681874336},
{0.7132857724729851,0.30788938358900925,-0.09312847859976288},
{0.7512461159542664,0.30297607671997817,-0.08813290936306155},
{0.7335073581257403,0.29747945488019456,-0.09107191940800709},
{0.7683866020179184,0.27641281035955434,-0.0831822105087258},
{0.7515377734396428,0.2762707208153968,-0.08475267389152112},
{0.7678631142236532,0.27740743716865784,-0.07199452850557433},
{0.7515527302337646,0.27568733106067356,-0.07344533753539477},
{0.7318396755811527,0.29821974140525587,-0.07322098562356687},
{0.7491147727919015,0.30420245905400006,-0.07109712085826272},
{0.7102271080750646,0.30747059335359705,-0.07281715218227663},
{0.7239050962995058,0.327019198054839,-0.06866664181346042},
{0.6926453965848179,0.34593954261899224,-0.06812819722507345},
{0.6899905656281878,0.310596563325066,-0.06966126862256412},
{0.718423431253844,0.3134457578213097,-0.06595198368034279},
{0.728182739418358,0.3336224730916992,-0.06448621785640048},
{0.7625983226927584,0.3053766421765367,-0.06011883397281729},
{0.7476714421591418,0.2978458963361801,-0.062399745076400975},
{0.7870078106996343,0.27174621580956326,-0.05530274626557828},
{0.7723052820778457,0.27001870608848844,-0.05661146575124106},
{0.7886455796559779,0.27132002196106086,-0.04104144307038453},
{0.7745712363873075,0.26695271286144817,-0.04166962842350266},
{0.7480004916298229,0.2970906530169967,-0.04070491520264268},
{0.7628974585751954,0.3057057664311881,-0.03913445181984735},
{0.7178251594889696,0.3128551140214374,-0.03975515877590455},
{0.7275695108593617,0.3346994370524437,-0.039037232658055254},
{0.693939159276359,0.3460816321631501,-0.03826695776077945},
{0.6914787666433129,0.310678825692736,-0.04051795527611942},
{0.7222374137549186,0.31311685791856986,-0.03365278677418557},
{0.7308600055661708,0.3354398731454463,-0.03258337599447256},
{0.7699047166212871,0.30933278900573924,-0.025262025271821965},
{0.7566829106175627,0.30031369258231644,-0.027064318963506126},
{0.8012840706889499,0.27596403175192785,-0.019593400299636923},
{0.7898421231857269,0.2711180304564453,-0.020550635123435978},
{0.8020693023803476,0.27531348599159755,-0.0034624978392106373},
{0.791001274730171,0.2683884903131762,-0.004247729530608302},
{0.7560248116762007,0.299349054145427,-0.005092788398493404},
{0.7691942689004988,0.3093701809910441,-0.004113118383511559},
{0.7202182465484673,0.3112323018592156,-0.009594783429173344},
{0.7290951038597914,0.3350434433172465,-0.007037171634335239},
{0.6949113508942798,0.34684427909542365,-0.01010331442931659},
{0.6924509582612339,0.3114341437958901,-0.01235431194465656},
{0.7364987169501123,0.32050543943079846,0.0005758365736916311},
{0.7401406963187852,0.3356192798909381,0.002826834089031599},
{0.772611896357344,0.3198024701070708,0.01170369140035566},
{0.7651260208993528,0.30918314628055005,0.008428153487668266},
{0.7973279986437181,0.3010317682681068,0.016557171092899316},
{0.791113450686085,0.2956173340120228,0.01448565510702167},
{0.7864693661112473,0.29308215740836757,0.026144476125011737},
{0.7940300255398478,0.30037359454277446,0.02978645549368471},
{0.7596742694419346,0.30461384567632177,0.023205466080066198},
{0.7692167040916815,0.31755887620482126,0.02584534024257453},
{0.7278088195653115,0.3132363627036036,0.019705576255550902},
{0.7316153236693248,0.33579876142040055,0.021358302006016454},
{0.6945374310412333,0.31456003898338836,0.017454578740210933},
{0.662036317414431,0.297262656149398,0.00868989738480082},
{0.6478348413957246,0.30359685846000595,0.018322072799278825},
{0.5785699278173898,0.30228813897434303,-0.006326723913546876},
{0.5931752372773863,0.2866357791418457,-0.029023658993469818},
{0.6614305672524955,0.2981225970274344,-0.017955631343293227},
{0.6325489978031834,0.25617634269664796,0.005863063295769232},
{0.6287948424785965,0.2708488829462223,0.03140926765590655},
{0.6636890431648964,0.2561837463097382,0.04650815132192448},
{0.66363669438547,0.2460280831009951,0.029547146787734943},
{0.6640180926355774,0.2726586550349674,0.015816809783867233},
{0.6810538811403763,0.24406126467397057,0.05690312323661735},
{0.6857503144946404,0.23245486721937764,0.03994211870242782},
{0.6964668574829533,0.24740418294417693,0.035253163745224636},
{0.674757070815073,0.2576794257219242,0.027685025919563344},
{0.7021653960433821,0.2336886531664898,0.06038057786994986},
{0.7053885851766429,0.22882029146379487,0.05009778191117094},
{0.7103617192221615,0.23273141834269084,0.04958925091102769},
{0.7079312401773591,0.23632867689693945,0.05789027164866013},
{-0.759965926927311,0.30523462741634955,0.022764240653471324},
{-0.7695233183711798,0.31777589928752936,0.02624169528680383},
{-0.793880457598629,0.29966314682198614,0.030122983361426568},
{-0.7866114556554051,0.29360564520263277,0.025755599477843373},
{-0.7968718164230013,0.30065777363108964,0.01684135018121466},
{-0.7918238984068733,0.29586404633106306,0.014208954415767253},
{-0.7654700271641556,0.30997578158503797,0.008061712031682688},
{-0.7724772852102472,0.31969021936718645,0.011374641929674736},
{-0.7370072479502556,0.3207970969161746,0.0007927100884586038},
{-0.739729384480434,0.33644930718073085,0.002722136530178578},
{-0.6952030083796562,0.3468518322764553,-0.009796700149818456},
{-0.692525742231843,0.3113743914033732,-0.012212222400498888},
{-0.7203079873131986,0.3116435389135962,-0.009834092135123106},
{-0.7290876254627305,0.33567910706742565,-0.00702221484021338},
{-0.7689549601945491,0.31006567191771056,-0.0035522386039417994},
{-0.7560248116762007,0.298698433601126,-0.005548970619210142},
{-0.8020693023803476,0.27555286948151797,-0.0033278866921138952},
{-0.7911209290831459,0.26912137322514745,-0.003956072045232025},
{-0.789288721803218,0.27100592928450173,-0.020819857417629466},
{-0.8016729473361184,0.2756799274475831,-0.019189566858346694},
{-0.7562865555733335,0.3001418390178563,-0.026705355904581476},
{-0.7701589821213587,0.3100430871585865,-0.025276982065943823},
{-0.7228356855197928,0.312907462800864,-0.03308442859755488},
{-0.7314507989339845,0.33532762240556196,-0.03242632965619303},
{-0.6940588136293339,0.346500422398562,-0.03875305356973992},
{-0.6912768499226677,0.31109006274711665,-0.04042821451138826},
{-0.7175110668124108,0.312907462800864,-0.040375865731961745},
{-0.7280481282712612,0.33443769315531124,-0.03859600723146038},
{-0.7631068536929018,0.3060945682943859,-0.039089581437481764},
{-0.7480603188063104,0.2977112851890834,-0.041033964673323604},
{-0.7886007092736125,0.2712900335888465,-0.04086943993798314},
{-0.7749975050197806,0.26774534816593637,-0.04230529217368172},
{-0.7727539859015015,0.26983189572990646,-0.05688816644249547},
{-0.7869105915378422,0.2718061177700212,-0.05529526786851736},
{-0.7478883156739089,0.29777118714954137,-0.06209313079690284},
{-0.7629498073546221,0.30509994148528213,-0.06007396359045171},
{-0.718752480724525,0.3142459463068292,-0.06584728612148977},
{-0.7282949153742719,0.3337721158168884,-0.06403003563568374},
{-0.6929146188790115,0.3454010980306054,-0.067642101416113},
{-0.6901401335694063,0.3107311744721627,-0.06938456793130972},
{-0.7102345864721258,0.3084279029613667,-0.07257036507926595},
{-0.7241593617995776,0.326929457290108,-0.06862177143109484},
{-0.7496008686008618,0.30436705857331114,-0.07085781215231295},
{-0.7314807125222281,0.2983544273363232,-0.07328829119711523},
{-0.7672797992529007,0.27710074810518925,-0.072458189123352},
{-0.7514555110719725,0.276008976918264,-0.07333316157948083},
{-0.752038826042725,0.27668195786977706,-0.0852911184799081},
{-0.7684838211797105,0.2762108188549385,-0.08292794500865418},
{-0.7337915372140554,0.29759910923316946,-0.09048112604019361},
{-0.7514181190866679,0.3030433822935264,-0.08805812539245224},
{-0.7136522139289708,0.30801651633904503,-0.09264986118786335},
{-0.7256625196088246,0.32883637375667457,-0.09105696261388523},
{-0.6890931579808761,0.30930280063352494,-0.0936818799822717},
{-0.6913441554962162,0.3445709211728716,-0.09358466082047961},
{-0.6498315734109931,0.35142113288068355,-0.09030164451073128},
{-0.6455015815127145,0.30253485129338326,-0.09171506155524708},
{-0.5941623856894291,0.32419976757889785,-0.09197680545237963},
{-0.5898174369970288,0.28304607376862867,-0.08272602828800907},
{-0.5553868969285065,0.33336828237559807,-0.10383754319101482},
{-0.5482151141470745,0.2922893725359383,-0.08125278406700583},
{-0.5387848554532415,0.27289048534385624,-0.041467711702857554},
{-0.5781361807878559,0.3021085078769395,-0.006506205443009201},
{-0.5445806131754625,0.29894522070413665,-0.0043972974718269045},
{-0.7283771777419422,0.31327390425684953,0.01981027381440392},
{-0.6950758756296204,0.3147769872821258,0.01743214354902814},
{-0.662148493370345,0.29710546024317747,0.008271107149388734},
{-0.6620811877967965,0.2985114736746029,-0.01765649546085602},
{-0.6329079608621081,0.2562660086774085,0.006289331928242248},
{-0.5926592278801822,0.286388992038835,-0.02876191509633726},
{-0.66363669438547,0.24607287869939018,0.0302800296997061},
{-0.6747570708150733,0.25764951213368054,0.02855251997863124},
{-0.6641676605767962,0.27298022610858746,0.015861680166232812},
{-0.6956442338062511,0.24735183416475054,0.03590378428952556},
{-0.685054823567974,0.23281375549433156,0.0403085601584134},
{-0.6810987515227419,0.24413597386060928,0.057359305457334094},
{-0.6638760030914198,0.2565427841526335,0.04598466352765938},
{-0.6291313703463384,0.2710133328975922,0.031700925141282824},
{-0.7102645000603695,0.23217061334709174,0.05025482824945047},
{-0.7052315388383634,0.229134384140354,0.05061379130837511},
{-0.7024720103228803,0.23352420321512013,0.05997674442865964},
{-0.7083500304127712,0.23602198783347056,0.05761357095740572},
{-0.2372558859565388,-0.9469557296468225,-0.10878076364828963},
{-0.2354984626472202,-0.9996186017498925,-0.10818997028047615},
{-0.25232485603431304,-0.9999700864117562,-0.0518327700293067},
{-0.25133770762227026,-0.9593399551797228,-0.04789165477819653},
{-0.28027910424806984,-0.965950858181585,0.00747091866386921},
{-0.27644268655581267,-0.9998653888529032,0.0006506205443009325},
{-0.309160673697382,-0.9749698050370669,0.060111355575756385},
{-0.30957946393279406,-0.9996485153381363,0.06015622595812196},
{-0.3105591339477759,-0.9996485153381363,0.09119905215804293},
{-0.30954955034455034,-0.9772507161406505,0.09092235146678851},
{-0.30667784587315317,-0.9996335585440144,0.11527949069423793},
{-0.30566826226992766,-0.9772357593465286,0.11501026840004444},
{-0.26675068396484725,-0.9995961665587098,0.14953054923329792},
{-0.2667432055677863,-0.9772432377435896,0.14960533320390723},
{-0.21735587137740373,-0.9772282809494677,0.15784652676505226},
{-0.21669777243604188,-0.9996784289263799,0.15807835707394108},
{-0.19320812726766035,-0.9772208025524067,0.14508090298204449},
{-0.1932230840617822,-0.9995737313675269,0.14500611901143518},
{-0.17626207952759268,-0.975276419316565,0.10704577553015387},
{-0.17637425548350663,-0.9993942498380646,0.10480973480893575},
{-0.15777548199297342,-0.9998130400734766,0.0389175783050804},
{-0.15998908752300872,-0.9662649508581441,0.04389819074765987},
{-0.14458358957749265,-0.999244681896846,-0.023930870594976398},
{-0.14626622891620195,-0.9466790289555681,-0.02109655810888388},
{-0.12581281295455804,-0.9418405060571463,-0.07120929681417668},
{-0.12658308785183384,-0.9994241634263084,-0.07215905324091479},
{-0.1711244207467337,-0.9435530589840992,-0.11959452579839461},
{-0.17116929112909926,-0.9997906048822939,-0.119871226489649},
{-0.16984561484931462,-0.8569307858273457,-0.11335754264957887},
{-0.2333072923083677,-0.8571027889597471,-0.10319440104377484},
{-0.24779294741538935,-0.856571822768421,-0.03694328148099482},
{-0.272232349010509,-0.9106256767248241,0.02257728072694807},
{-0.2980328188707179,-0.937809650041305,0.07338551035890736},
{-0.2472844164152461,-0.9239671370815233,0.09403336464413543},
{-0.2277508432920966,-0.9016740354428907,0.038984883878628765},
{-0.18025554355812937,-0.9107976798572254,0.05014265229353652},
{-0.1936493526942552,-0.9340928867020227,0.11139820261961521},
{-0.1563845001396404,-0.8565419091801774,-0.006341680707668739},
{-0.12599229448402036,-0.8567587826949443,-0.0677916693573316},
{-0.21156759205224382,-0.8569307858273457,0.005145137177919939},
{0.27178364518685316,-0.9108051582542863,0.022562323932826207},
{0.2980103836795351,-0.9380414803501939,0.07378934380019758},
{0.3093027632415396,-0.9757026879490379,0.060358142678767074},
{0.28019684188039956,-0.965965814975707,0.007231609957919445},
{0.2757397172320852,-0.9994092066321865,0.0008974076473116265},
{0.30966172630046424,-0.9998279968675986,0.060425448252315446},
{0.30969163988870796,-0.9999027808382078,0.09088495948148385},
{0.30966172630046424,-0.9773928056848081,0.09108687620212898},
{0.30606461731415685,-1.0,0.11530940428248165},
{0.30578043822584156,-0.977310543317138,0.11483078687058212},
{0.26654876724420207,-0.9991848547203586,0.14947820045387142},
{0.2665263320530193,-0.9766823579640199,0.1496801171745165},
{0.21672020762722463,-0.977512460037783,0.15765956683852897},
{0.2167127292301637,-0.9992970306762725,0.15765956683852897},
{0.1923406332085924,-0.9773778488906864,0.14469950473193705},
{0.19329038963533052,-0.999244681896846,0.14514073015853193},
{0.17693513526307636,-0.9753437248901133,0.10741221698613944},
{0.17629947151289727,-0.9994690338086739,0.10456294770592506},
{0.15794748512537474,-0.9996784289263799,0.03895497029038505},
{0.15977969240530263,-0.9661826884904738,0.04465350885081381},
{0.17985171011683906,-0.9107004606954333,0.05007534671998815},
{0.1937316150619254,-0.9343097602167897,0.1110766315459952},
{0.2471273700769665,-0.9238325259344266,0.09439980610012103},
{0.22752649138026865,-0.9021451744577292,0.03918680059927388},
{0.15599562349247198,-0.8569307858273457,-0.006491248648887338},
{0.2116573328169749,-0.8564596468125072,0.005279748325016682},
{0.24759850909180514,-0.8571252241509298,-0.037115284613396214},
{0.25152466754879343,-0.9594147391503322,-0.048310445013608615},
{0.2522201584754599,-0.9996335585440144,-0.051802856441062986},
{0.1465952783868828,-0.9467313777349946,-0.020767508638202953},
{0.1260371648663859,-0.8568111314743708,-0.06768697179847857},
{0.1253715875279631,-0.9419302468218775,-0.07159817346134503},
{0.16964369812866947,-0.8571401809450516,-0.11323788829660399},
{0.17060841134952945,-0.9432015743222356,-0.11960200419545554},
{0.23636595670628804,-0.9469931216321272,-0.10848910616291337},
{0.2332923355142458,-0.8570878321656251,-0.10391980555868506},
{0.23519184836772203,-0.9998653888529032,-0.10885554761889893},
{0.19613218051848397,0.497900496113122,0.003342843486235779},
{0.19625183487145886,0.49800519367197504,-0.00880955173777568},
{0.2683585393329471,0.44890959175093936,-0.00928069075261428},
{0.27272592321653033,0.45504928095399233,-0.013416244327308638},
{0.20081365707862622,0.504862883776848,-0.013027367680140272},
{0.27674930083531074,0.46156296479406245,-0.008443110281790102},
{0.20535304409461083,0.5104567995623941,-0.008054233634621736},
{0.27643520815875167,0.4607329375042697,0.003791547309891587},
{0.20523338974163596,0.510344474038539,0.004098161589389721},
{0.2720678242751685,0.4546005771303365,0.007927100884585947},
{0.20067156753446855,0.5034944118986682,0.008315977531754313},
{0.26805192505344905,0.4480869680742368,0.0029539668390674116},
{-0.0961385334167873,-0.46839066652672084,0.08384778784714861},
{-0.0541174203314209,-0.4677998731589074,0.0463137129983403},
{-0.09017825095922598,-0.4259507632059424,0.09545426008571217},
{-0.04770095565314285,-0.4254497106028601,0.05887742006070291},
{-0.17231348587942158,-0.46883189195331576,0.09825118058650002},
{-0.1677516636722542,-0.4262199855001359,0.10937155701610313},
{-0.24527272760585592,-0.4529029062135346,0.05036700420536443},
{-0.24223649839911826,-0.4115174568783473,0.05857080578120477},
{-0.22500627157073527,-0.4556250427437132,-0.053500452573894124},
{-0.22176064724629158,-0.4048915970823631,-0.053941678000489},
{-0.16352636933282866,-0.4707987103803404,-0.10875832845710684},
{-0.15485890713921066,-0.4044204580675246,-0.10095088192549578},
{-0.06793749810001977,-0.4579209106414187,-0.07192722293202596},
{-0.06244835465729706,-0.4071874649800687,-0.0787176074633505},
{0.476871206185801,0.2957069999927833,0.027385890037126142},
{0.4832428004817134,0.22299462015333035,-0.04665771926314306},
{0.5601057654739533,0.28691988344619046,0.03732467973110228},
{0.5612873522095803,0.2306973691260885,-0.034236101744938116},
{0.4820462569519647,0.38682386456712664,0.011950478503366356},
{0.5667241468728765,0.3679184767970952,0.01868103585820347},
{0.49152886442522403,0.413170182628813,-0.08088634261102026},
{0.5778520016995405,0.3951847124812467,-0.06916769441654275},
{0.4976162796328212,0.3499927590420458,-0.14730946530620165},
{0.5813444131269949,0.3475248132279683,-0.12883782456570425},
{0.49366768598465005,0.2674686474746818,-0.1289275653304354},
{0.5715551913742373,0.26902407927938465,-0.12281771493165548},
{0.5440122549988317,0.2988479267583741,-0.0038364176922571444},
{0.547930935058759,0.343643599937316,-0.011688734606233778},
{0.5535546896485786,0.3591613486227167,-0.06599685406270837},
{0.2633854052874286,0.45434623684629427,-0.11432225587043886},
{0.2633106213168193,0.4537406362523001,-0.12638491032971916},
{0.2663692857147397,0.45787611504302395,-0.11729865790068904},
{0.26560648921452484,0.45807055336660796,-0.12402173685846524},
{0.26776026756807275,0.4605309459996541,-0.13135056597817674},
{0.2675957428327323,0.46042624844080104,-0.12601099047667264},
{0.27096102151015083,0.46719419778094273,-0.12702057407989822},
{0.26940551492147735,0.463260635710864,-0.12421617518204942},
{0.27155929327502526,0.4668801051043838,-0.11495791962061792},
{0.26945038530384297,0.4632680393239545,-0.11740335545954207},
{0.2680145330681444,0.4606056551862928,-0.11017174550162263},
{0.26798461947990065,0.46000005459229865,-0.11542158023839559},
{0.3093551120209661,0.43320488313901534,-0.11243769981108447},
{0.3087044914766652,0.43357887777603243,-0.11772492653316206},
{0.30999077577114514,0.43613634000292933,-0.11886164288642345},
{0.3104095660065572,0.4386416778023116,-0.11768005615079649},
{0.3110601865508582,0.4382678327332356,-0.1123928294287189},
{0.30981877263874374,0.4357924833060679,-0.11050827336936449},
{0.3435762569717824,0.4248888308232903,-0.09840822692477955},
{0.3441147015601694,0.42262287651382874,-0.1004348725282916},
{0.38099067746761583,0.40940862369113556,-0.05956543259030846},
{0.38086354471758,0.4074791972494156,-0.061592078193820524},
{0.34584968967830515,0.4227425308668036,-0.10507895710312921},
{0.3471284955757242,0.4253076210587025,-0.1062156734563906},
{0.3472631067228209,0.42722971867130266,-0.10418902785287852},
{0.34486254126626237,0.42744651740209927,-0.09954494327804093},
{0.3822769617620958,0.41196616070200315,-0.06070962734063077},
{0.38344359170360093,0.4076212120096028,-0.0632747175325298},
{0.38439334813033904,0.4095207996470495,-0.06431421472399909},
{0.3848570087481167,0.41210839981410213,-0.06238478828227911},
{0.04050673768052801,-0.1060099801452297,-0.18849299792074387},
{0.09584687593141096,-0.14041060662550822,-0.14063125673079105},
{0.02928914208913282,-0.11049701838178769,-0.15633589055874433},
{0.02480210385257474,-0.056652559543090855,-0.195223555275581},
{0.012836668555086538,-0.061887437485741964,-0.1555880508526513},
{0.02106290532210968,0.039818762542907865,-0.137639897906419},
{0.03302834061959788,0.03159252577588464,-0.17278836409279058},
{0.08537712004610878,0.06823667137444228,-0.1204395846662797},
{0.1040731126984341,0.03533172430634975,-0.1683013258562325},
{0.16090893036150308,0.03383604489416376,-0.12492662290283778},
{0.1511870141822939,0.042062281661186855,-0.0972565537773963},
{0.18334412154429344,-0.053661200718718736,-0.136892058200326},
{0.17137868624680527,-0.058896078661369845,-0.09800439348348931},
{0.15941325094931705,-0.1082534992635087,-0.11595254642972162},
{0.17063084654071223,-0.10376646102695058,-0.14661397437953513},
{0.11155150975936423,-0.10227078161476459,-0.18774515821465085},
{0.11155150975936423,-0.05066984189434675,-0.195223555275581},
{0.07828759963234702,0.8690009934676577,0.1663345074292079},
{0.033245214134364855,0.8160091466778774,0.13256206630204745},
{0.06242591946611422,0.816143608257033,0.12739449393294475},
{0.08793473184094688,0.8085830236124032,0.10805535913337942},
{0.09320700176890262,0.8652468381430707,0.09688263392434981},
{0.03173457792805697,0.8740713466749682,0.1332426004345921},
{0.09858396925571139,0.9251339165909698,0.13796146898003903},
{0.08136869922145024,0.9093618276215268,0.06225765553224333},
{0.04912185109471952,0.9241317366008347,0.08523876970048161},
{0.0853322496637432,0.9730029866100421,0.08406466136191558},
{0.0725516690866136,0.9334722545299362,0.02399069777146386},
{0.028421648030064924,0.9501490799758106,0.024858191830531756},
{0.02741206442683936,0.9313409861515417,0.08882092189266715},
{0.012021523275445154,0.9850059634607763,0.08988285427531922},
{1.1217595591368092e-05,0.9432017238901769,0.02330268524185829},
{-0.034396887281748154,0.9464247634554965,0.02503767335999408},
{-0.027180234117950577,0.9313259545734495,0.08859656998083923},
{-0.0925937732099064,0.9750222286004641,0.06879377456349627},
{-0.08001510935342193,0.9274970152782531,0.024072960139134097},
{-0.08166035670682656,0.9094217295819849,0.062339917899913555},
{-0.0496004685066191,0.9241990421743829,0.0855827759652844},
{-0.10108923227112304,0.9304734173085033,0.13802129615652645},
{-0.09375292475435058,0.8652991869224971,0.09686019873316702},
{-0.031831797089849116,0.8740637934939368,0.13298085653745956},
{-0.09147201365076689,0.8510528405214252,0.1670000847676307},
{-0.08780759909091114,0.8086427760049201,0.10808527272162316},
{-0.06245583305435799,0.8161212478498207,0.1268859629328015},
{-0.03331999810497421,0.8160838558645162,0.13303320531688606},
{0.014609048658526977,0.8587706210722759,0.1943859748047568},
{-0.00045244302218629985,0.8179758155369609,0.14273268630491243},
{0.032011278619311384,0.9556157134433798,0.14087056543674084},
{-0.0002953966839067672,0.9286711984007897,0.09805674226291584},
{-0.02868339192719753,0.9492815111327718,0.16998396519494183},
{0.00023556950741927192,0.9678504458190321,-0.10913224831015335},
{-0.031128827766121685,0.9308548903425813,-0.0431428726445059},
{-0.0647666577461854,0.957829318973415,-0.12402921525552617},
{-0.07451100911657736,0.9191361673641333,-0.04043569290844919},
{-0.1292080052202203,0.9226136219974657,-0.09077278352556988},
{-0.11115515471513499,0.8771899130333466,-0.03864835601088689},
{-0.12355433704215714,0.9509118764760253,-0.03993464030536687},
{-0.1256333314250957,0.8872108903110226,0.027131624537054512},
{-0.1389299213994295,0.9411898855128454,0.06280357851769122},
{0.030941867839598375,0.9308698471367031,-0.04288860714443428},
{0.0002729614927239226,0.9311240378528043,-0.04078717757031291},
{-0.01448939430555215,1.0,-0.012900234930104462},
{-0.07279097779256342,0.97443136044868,-0.019159653270102977},
{-0.16452099614193239,0.8404110815037217,0.10847414936879152},
{-0.1042077238455309,0.8041781729595447,0.09574591757108844},
{-0.1219315248799353,0.8544929031694533,0.03702554384866508},
{-0.15837375375784782,0.8999914708881521,0.06457595862113166},
{-0.17081032807017463,0.8763373009844301,-0.0019668184270246127},
{-0.12835546795527428,0.8246766088714954,-0.03704050064278691},
{-0.1606546648614315,0.8652916337414658,-0.07886717540456911},
{-0.09896536750581889,0.8100264290291331,-0.09092235146678848},
{-0.1486667943727605,0.7926839514608656,-0.08155191994944302},
{-0.07280593458668529,0.7580440162746375,-0.08468536831797276},
{-0.10203151030080024,0.7687007320864627,-0.07099990169647062},
{-0.10752065374352295,0.7488230779145398,-0.08299525058220256},
{-0.10509017469872065,0.766913469972871,-0.05423333548586528},
{-0.1111102843327694,0.7753938974559953,-0.04622397223360911},
{-0.12034610470301811,0.7536317620086885,-0.05499613198608015},
{-0.11565714974581492,0.7720286187785766,-0.030033242596695382},
{-0.17158808136451134,0.816525081291111,0.00809162561992641},
{-0.13900470537003878,0.7916968778327936,0.008974076473116165},
{-0.15358010124179158,0.7646698760706215,-0.0037915473098915644},
{-0.12045080226187113,0.7921006364901131,0.04439176495368125},
{-0.015775678600032133,0.7202556011417867,-0.1304456799338042},
{0.0006842733310750796,0.7124780681984194,-0.1324798039343772},
{-0.014354783158455408,0.7208688297007831,-0.1124451782081454},
{-0.014354783158455408,0.7366408438862554,-0.1127966628700091},
{-0.015783156997093064,0.7369399797686924,-0.12940618274233492},
{0.0006169677575267085,0.7436332199221956,-0.11732857148893276},
{0.0006767949340141495,0.7441117625501243,-0.13244241194907255},
{0.015618632261752545,0.7369473833817829,-0.1292790499922991},
{0.014055647276018149,0.7366483222833162,-0.11268448691409516},
{0.015626110658813475,0.7202556011417867,-0.1303185471837684},
{0.014063125673079078,0.7208763828818147,-0.1123255238551705},
{0.0006244461545876386,0.7134877265856157,-0.11753796660663882},
{0.0007216653163797303,0.7285119010649947,-0.1434057420403961},
{-0.24039681272212945,-0.8469770393392476,-0.11124115628133564},
{-0.25600422738829065,-0.8467078170450542,-0.03507368221576229},
{-0.21505252508263725,-0.8463563323831904,0.014231389606950046},
{-0.151291711741147,-0.8461020668831188,0.0010021052061646493},
{-0.1160235912018005,-0.8464834651332263,-0.06983327175496552},
{-0.16670468808372396,-0.8471041720892835,-0.12334868112298152},
{-0.23733814832420902,-0.8143787065506533,-0.10620071666226874},
{-0.2478752097830596,-0.815463074124488,-0.029038615787591676},
{-0.20628784372722714,-0.8148498455654919,0.011763518576843103},
{-0.14986333790250933,-0.8122398849912272,-0.0024603926330460007},
{-0.12003949042351997,-0.810445069696604,-0.07521023924177428},
{-0.1684247194077379,-0.8125016288883598,-0.11761275057724811},
{-0.16744504939275603,-0.7830068308800514,-0.123617903417175},
{-0.24115213082528342,-0.7823188183504458,-0.10675411804477757},
{-0.2516069299164637,-0.7826553462181877,-0.029562103581856788},
{-0.20722264335984342,-0.7818252441444244,0.01698343972537233},
{-0.14415732094501962,-0.7820421176591914,-0.0012488923091753205},
{-0.11458026056904098,-0.7824758646887254,-0.07408100128557384},
{-0.2324697118375435,-0.7715574049797673,-0.09814648302764699},
{-0.24192240572255921,-0.7708095652736744,-0.0324936352297414},
{-0.20445563644729928,-0.771161049935538,0.006064980016414345},
{-0.1511645789911112,-0.7711760067296599,-0.009265733958492417},
{-0.1255585474544864,-0.7716097537591938,-0.07081294176994737},
{-0.17064580333483415,-0.7717817568915952,-0.11284901164943563},
{0.14442654323921308,-0.9996036449557707,-0.024050524947951284},
{0.12632882235176215,-0.9992671170880288,-0.0723086211821334},
{0.17082528486429643,-0.9999252160293907,-0.11986374809258808},
{0.23984341133962056,-0.8469246905598211,-0.11142063781079796},
{0.16596432677469183,-0.8466629466626887,-0.12305702363760523},
{0.1160161128047395,-0.8466554682656278,-0.07007258046091529},
{0.15070091837333346,-0.8465881626920793,0.0014059386474548753},
{0.21464869164134698,-0.8458851933683519,0.014538003886448181},
{0.25644545281488546,-0.8463189403978859,-0.03437071289203486},
{0.23686700930937038,-0.8143039225800439,-0.1065895933094371},
{0.1692323862903183,-0.8125165856824815,-0.11779971050377137},
{0.11977026812932644,-0.8105422888583961,-0.07514293366822591},
{0.149676377975986,-0.8126362400354564,-0.0021986487359134457},
{0.20566713677116988,-0.8152312438155993,0.011830824150391474},
{0.24767329306241442,-0.8152088086244166,-0.028530084787448427},
{0.24037437753094662,-0.7829320469094422,-0.10688872919187431},
{0.16810314833411785,-0.7830143092771124,-0.1237151225789671},
{0.11389972643649628,-0.7826553462181877,-0.07411091487381756},
{0.14423958331268982,-0.7824309943063598,-0.0013012410886018319},
{0.20667672037439547,-0.7821169016298006,0.016998396519494193},
{0.2514797971664279,-0.7822589911739584,-0.02970419312601446},
{0.23184152648442535,-0.771490099406219,-0.09877466838076511},
{0.1714385134232927,-0.771699494523925,-0.11300605798771515},
{0.12508740843964777,-0.7715574049797673,-0.07130651597596875},
{0.15061117760860226,-0.7707871300824914,-0.008742246164227307},
{0.20410415178543548,-0.7707048677148213,0.006050023222292485},
{0.24207197366377775,-0.7712657474943911,-0.03228424011203535},
{0.2705721448629825,0.4525889631049169,-0.006094893604658043},
{0.2704300553188248,0.45187103698706765,0.0008001884855195352},
{0.27223234901050897,0.4547126783022798,0.0025950037801427653},
{0.27422160262871637,0.45706096976338234,0.0006057501619353526},
{0.274371170569935,0.45777882109726115,-0.006289331928242226},
{0.2725613984811899,0.4549370302141077,-0.008084147222865459},
{0.31253343077186146,0.4128636431332855,-0.0068128197225073356},
{0.31251099558067863,0.4128186979669493,-0.01284040775361702},
{0.3468742300756526,0.4047869743074809,-0.02451418556572895},
{0.3491925331645409,0.4044055760573733,-0.019324178005443438},
{0.3838025547625255,0.40501140100327954,-0.056947993618982916},
{0.3862330338073279,0.40484680148396823,-0.055564490162710846},
{0.3506059502090567,0.40723241014640493,-0.01823981043160857},
{0.3873174013811627,0.40700805823457703,-0.05437542503002295},
{0.3508527373120674,0.4093713064898017,-0.02001966893210994},
{0.38755671008711245,0.40915435819106405,-0.05616276192758525},
{0.3485344342231791,0.40976010835299925,-0.02520967649239545},
{0.38508883905700547,0.40923662055873433,-0.05828662669288941},
{0.34711353878160234,0.4069332742639679,-0.026294044066230315},
{0.38308462864467624,0.4069183174698461,-0.057882793251599174},
{0.3129522210072735,0.4153689809326675,-0.005623754589819443},
{0.3142385053017535,0.4179265179435351,-0.006767949340141756},
{0.31421607011057073,0.4178741691641087,-0.012795537371251439},
{0.3137972798751586,0.415376384545758,-0.013977124106878397},
{0.19069538585518775,0.5012956135948137,-0.11359685135552863},
{0.19471128507690724,0.5078093722188545,-0.1086237173100101},
{0.19897397140163742,0.5138818306323296,-0.11349963219373654},
{0.198375699636763,0.5141959233088887,-0.12556228665301683},
{0.19446449797389656,0.5077346630322157,-0.12979505938950328},
{0.19020181164916639,0.5016620550507992,-0.12491914450577685},
{-0.4769459901564103,0.29546784085477495,0.026952143007592192},
{-0.48189668901074606,0.38683134296418753,0.012219700797559841},
{-0.4914839940428585,0.4128412827260732,-0.08105086734636072},
{-0.49804254826529426,0.3500077158361676,-0.14718233255616583},
{-0.4937200347640766,0.2677527517790266,-0.12880043258039958},
{-0.48315305971698236,0.2229122830016896,-0.04658293529253376},
{-0.5600235031062831,0.2876229275538885,0.037332158128163206},
{-0.5668587580199732,0.3680905547134674,0.01883060379942207},
{-0.5779866128466373,0.3949902741576624,-0.06939952472543158},
{-0.581538851450579,0.3478688942767418,-0.12904721968341026},
{-0.5711438795358863,0.26882223734271016,-0.12236153271093875},
{-0.5610854354889352,0.23024866530243265,-0.03396687945074463},
{-0.547833715896967,0.34352394558434113,-0.01174856178272122},
{-0.5538687823251376,0.3591014466622587,-0.06592207009209908},
{-0.5551251530313739,0.3326727914489316,-0.10374032402922272},
{-0.547953370249942,0.2915938816092718,-0.08116304330227467},
{0.09445589407807795,0.35527998576412356,0.12058167421043739},
{-0.0005496621839783915,0.4257339644751463,0.12393199609373409},
{-0.000631924551648623,0.345789899893803,0.14842374646828027},
{-0.0006618381398923435,0.20326660870659669,0.15819801142691595},
{0.1027793500068932,0.4444449887055638,0.09127383612865222},
{0.2145813860677986,0.4853742558200344,-0.001951861632902752},
{0.25267634069617667,0.4611517277396819,-0.11467374053230257},
{0.5814865026711525,0.3468668638545475,-0.020281412829242496},
{0.6528902378089135,0.281737354282966,0.029569581978917736},
{0.670165335019662,0.2642304267633285,0.039732723584721776},
{0.6899232600546393,0.25605661355970244,0.04884888960199561},
{0.6569510074129984,0.3520343614396797,0.007246566752041305},
{0.6886818461425249,0.3458572054673515,0.013176935621358897},
{-0.7321238546694683,0.33560432309681626,0.021231169255980644},
{-0.6888164572896218,0.346059047404026,0.013640596239136564},
{-0.6569360506188766,0.35269246038104163,0.007702748972758043},
{-0.6478423197927855,0.3042174158481219,0.018464162343436497},
{-0.5815912002300057,0.347397755261903,-0.02005706091741459},
{-0.6533538984266912,0.2815055987580476,0.02992854503784238},
{-0.6705168196815257,0.26472407575332046,0.03993464030536689},
{-0.6898110840987256,0.25629599704962286,0.04861705929310677},
{0.10443955415441969,0.8041334521451204,0.09585061512994146},
{0.12035358310007899,0.7920633192887792,0.04462359526257009},
{0.1548065583597841,0.8464088307305582,0.109064942736605},
{0.12186421930638687,0.8544481075710583,0.03727233095167577},
{0.1716703437321815,0.830793788099395,0.008562764634765008},
{0.139191665296562,0.791577148695848,0.008615113414191519},
{0.15378201796243665,0.7645502217176466,-0.004030856015841327},
{0.11542531943692602,0.7719913015772427,-0.029838804273111197},
{0.12815355123462913,0.8246316637051593,-0.036748843157410636},
{0.1542157649919706,0.7791032571821872,-0.0809760833757514},
{0.11100558677391632,0.7752592863088986,-0.04680728720436166},
{0.12045828065893201,0.753594370023384,-0.05476430167719132},
{0.10505278271341595,0.7668685248065349,-0.05412863792701226},
{0.10212872946259226,0.7693962230131293,-0.07099990169647062},
{0.10785718161126474,0.7487783571001155,-0.08286063943510581},
{0.0730228081014522,0.7579842638821206,-0.08483493625919136},
{0.09846431490273651,0.809981483862797,-0.09086252429030105},
{0.159420729346378,0.8795530117206299,-0.07849325555152262},
{0.11095323799448982,0.8770552271022795,-0.03923167098163944},
{0.17319593673261127,0.8582246233028572,-0.001443330632759503},
{0.12564080982215658,0.8871660947126275,0.02740832522830893},
{0.1519797242707525,0.9135049343772528,0.06499474885654376},
{0.00070670852225787,0.830831329652641,-0.14417601693767193},
{-0.05215060190439628,0.6152290676020548,-0.08713828255395784},
{-0.12851251429355381,0.7259468108730959,0.00697734445784782},
{-0.11356319856875448,0.7208390656804806,0.008390761502363614},
{-0.10345240574237695,0.7311740608507448,0.09607496704176936},
{-0.09889058353520958,0.7268441437364369,0.07853064753682727},
{-0.06163320937765568,0.727075899261355,0.1125423973699375},
{-0.06169303655414312,0.731802246203863,0.12704300927108103},
{-0.031024130207268664,0.7261710132169824,0.12406660724083084},
{-0.0004374862280644396,0.7314208479537554,0.1431514765403245},
{-0.015341931570498185,0.7262159583833186,0.130901862154521},
{-0.00040757263982071906,0.7260065632656127,0.13550855474405393},
{0.015319496379315341,0.7262233619964091,0.1310289949045568},
{0.03105404379551233,0.7260963040303438,0.12357303303480945},
{-0.13226666961814074,0.7840987516349178,0.008390761502363614},
{0.061700514951203995,0.7317349406303145,0.12680370056513127},
{0.06101250242159842,0.7270161468688381,0.1122956102669268},
{0.10295883153635552,0.7310395992715891,0.09542434649746845},
{0.09928693857943881,0.7267917949570102,0.07859047471331473},
{-0.00013087194856630435,0.03575799293882271,-0.14730946530620165},
{0.11428860308366466,0.037253672351008835,-0.12487427412341127},
{0.18234201633812883,0.039497191469287825,-0.06429925792987723},
{0.2047772075209192,0.03794916327767531,0.05760609256034478},
{0.09409693101915331,0.01831089259567273,0.16306644791358146},
{-0.00013087194856630435,0.010084655828649631,0.1884929979207439},
{-0.09435867491628591,0.01831089259567273,0.16306644791358146},
{-0.09211515579800687,0.06766831319781158,0.15932724938311638},
{-0.2042911117119588,0.03794916327767531,0.05760609256034478},
{-0.20129975288758675,0.08466670971730587,0.0482506178371212},
{-0.18185592052916844,0.039497191469287825,-0.06429925792987723},
{-0.18185592052916844,0.07913269589221746,-0.06878629616643532},
{-0.11455034698079726,0.037253672351008835,-0.12487427412341127},
{-0.11754170580516932,0.07464565765565948,-0.12861347265387632},
{-0.2172287386273679,-0.7747731157159673,-0.0586829817371187},
{-0.2047622507267974,-0.7707946084795524,-0.0994925944986144},
{-0.15550204928645064,-0.7719836736122404,-0.09245542286427917},
{-0.14537629966595125,-0.7733671770685124,-0.0468671143808491},
{-0.1922508924438613,-0.7760519216133863,-0.018972693343579726},
{0.2169669947302353,-0.7748852916718812,-0.05896716082543405},
{0.20393214865303408,-0.7711760067296599,-0.09955242167510187},
{0.15573387959533944,-0.7721930687299464,-0.09250029324664474},
{0.14478550629813772,-0.7738158808921684,-0.046859635983788166},
{0.19246776595862822,-0.7757303505397664,-0.018531467916984845},
{0.1374118067960606,-0.6810912357336956,-0.0500678683229272},
{0.15538987333053664,-0.6762751480264565,-0.09709202904205584},
{0.21381858956758373,-0.6774417779679617,-0.09243298767309636},
{0.22224674305525197,-0.6810912357336956,-0.048856367999056516},
{0.18114547280838,-0.6838806778374226,-0.011905608121000753},
{-0.0005646189781002517,0.5297959343619595,0.1285536454773889},
{0.0743614411753587,0.5503838866867296,0.09254516362901034},
{0.1277796313815826,0.5927042104385037,0.01096333009132358},
{0.150962662270466,0.5860259270791226,0.011845780944513334},
{0.08849561162051664,0.538201652658445,0.1106054925311566},
{-0.0006543597428314132,0.5127675494702509,0.15013629939523326},
{-0.08874239872352739,0.5382540014378714,0.11062792772233938},
{-0.07446613873421178,0.5504437886471876,0.092687253173168},
{-0.12798154810222778,0.5927415276398379,0.010671672605947305},
{-0.09770151840252168,0.6082366915661145,-0.0813948736111635},
{0.00045244302218624564,0.6073693470749878,-0.12683361415337496},
{0.09823996299090859,0.6081843427866878,-0.081342524831737},
{-0.10212872946259231,0.4445794502847194,0.09193193507001407},
{-0.09475502996051523,0.3553323345435499,0.1205592390192546},
{-0.08955754400316877,0.2121135524296771,0.13361652028763862},
{-0.10108923227112304,0.1581569176350662,0.16231860820748845},
{-0.10482843080158809,0.09832974114762512,0.16680564644404652},
{-0.19830839406321468,0.18412939062767658,0.04002438107009806},
{-0.1833366431472326,0.2644923202284023,0.02443192319805874},
{-0.17445978583590854,0.36207029551147724,0.043382181350455684},
{-0.21467860522959076,0.4847311136727946,-0.002116386368243215},
{-0.17131885907031785,0.5089386849590253,-0.0010320187944083457},
{-0.20528573852106252,0.497900496113122,-0.1075543065302971},
{-0.13350060513319423,0.5251742849783048,-0.10595392955925804},
{-0.1519946810648744,0.41305067784377925,-0.15003908023344115},
{-0.18858647788400554,0.4023790052378319,-0.16399376914913677},
{-0.15044665287326187,0.36014094385372797,-0.1566574616323643},
{-0.13181796579448493,0.2244080371978463,-0.13850739196548686},
{-0.14371609551842476,0.18308241503914627,-0.1458137858940156},
{-0.13848121757577367,0.11128980325421711,-0.13758754912699248},
{-0.19531703523884264,0.11727252090296122,-0.07177765499080735},
{-0.2035432720058658,0.1175716567853984,0.04600709871884216},
{-0.18559511905963347,0.18861642886423455,-0.07065589543166784},
{-0.00045992141924723,0.8833743978347947,0.14179788667229618},
{-0.18098842647010052,-0.6842097273081035,-0.01183830254745238},
{-0.22271040367302972,-0.6811884548954876,-0.04872175685195977},
{-0.21403546308235077,-0.6774417779679617,-0.09244794446721823},
{-0.15552448447763345,-0.6761779288646644,-0.09721916179209165},
{-0.13744172038430438,-0.6807397510718318,-0.05041935298479091},
{0.3680455721551457,0.40528810169453383,-0.06281853531181307},
{0.36860645193471553,0.41141290888743565,-0.06509944641539675},
{0.40948337026975956,0.40615552096963115,-0.06466569938586281},
{0.4101639044023042,0.4108520291078659,-0.05923638311962753},
{0.3693393348466867,0.41619900822246025,-0.058922290443068466},
{0.4092440615638098,0.4073445113183485,-0.05196738117640345},
{0.3683222728464002,0.4125121584714218,-0.053141489514969484},
{0.40807743162230475,0.40002331016363907,-0.05403889716228109},
{0.3674921707726369,0.4058489814741036,-0.05531022466263921},
{0.40833917551943727,0.400546797957904,-0.060904065664214954},
{0.41910806728717664,0.4003374028401982,-0.0600216148110252},
{0.41904824011068925,0.4002027169091308,-0.05547474939797968},
{0.40831674032825455,0.4021619821551238,-0.055818755662782465},
{0.4087280521666057,0.4063275241020324,-0.05483160725073969},
{0.41945955194904033,0.40436818407206876,-0.0544876009859369},
{0.4098348549316233,0.40853372601897736,-0.05893724723719032},
{0.41990077737563525,0.4069109138567556,-0.05859324097238754},
{0.40932632393148005,0.4058489814741036,-0.061599556590881455},
{0.419392246375492,0.4042261693118818,-0.06125555032607868},
{0.17119920471734293,0.5088339874001723,-0.0011292379562004371},
{0.13347816994201137,0.5251367434250589,-0.10561740169151619},
{0.10877702444975915,0.6054322926682656,-0.09829605096886558},
{0.0005795757722220578,0.5264904080770577,-0.1549449087054113},
{0.0005347053898564771,0.6005488993874781,-0.14635970887946353},
{-0.1088518084203685,0.605566978599333,-0.09769777920399117},
{-0.1504242176820791,0.586145656216068,0.012107524841645888},
{-0.2736382876579639,0.31582396287065595,0.022607194315191786},
{-0.3018168877835486,0.41853226810547034,-0.01006592244401194},
{-0.21929277621618465,0.3418413810296025,0.0315962275824298},
{-0.30683489221143273,0.43689921128711495,-0.11346971860549282},
{-0.26607762822936354,0.4430389752741384,-0.01357329066558817},
{-0.3420581423684136,0.35059858398795174,-0.15802600829451452},
{-0.27198556190749834,0.36696124197329627,-0.15776426439738198},
{-0.25254172954908,0.4608150503039989,-0.11412033914979373},
{0.12985114736746026,0.9555110158845267,-0.013087194856627711},
{0.07430909239593218,0.919076265403675,-0.04057030405554594},
{0.14001428897326432,0.9300920190583959,-0.0905559100108029},
{0.07433900598417591,0.9442261147195832,-0.12411895602025733},
{0.06256800901027189,0.9879149103495369,-0.01944383235841832},
{0.13777824825204618,0.9373534678205885,0.06287836248830052},
{-0.07641052197005362,0.13103277149507261,0.12228674874032947},
{-0.08314107932489073,0.05141027798734952,0.13837278081839016},
{-0.00013087194856630435,0.04243620151423342,0.16604284994383162},
{-0.00013087194856630435,0.12205869502195651,0.1477132987474919},
{0.07689661777901402,0.13103277149507261,0.12228674874032947},
{0.08362717513385114,0.05141027798734952,0.13837278081839016},
{0.16514170309798953,0.15047660385349093,0.03852870165791203},
{0.1763592986893847,0.07085411034576783,0.051623374911600683},
{0.15616762662487335,0.07608898828841895,-0.05456986335360714},
{0.1464457104456642,0.1519722832656769,-0.05943829984027264},
{0.09858396925571139,0.07309762946404695,-0.10691864278011802},
{0.0933490913130603,0.14823308473521193,-0.10804788073631848},
{-0.00013087194856630435,0.06935843093358184,-0.12785815455072239},
{-0.00013087194856630435,0.1452417259108398,-0.1267438733886438},
{-0.09435867491628591,0.14823308473521193,-0.10804788073631848},
{-0.10108923227112304,0.07309762946404695,-0.10691864278011802},
{-0.1467074543427968,0.1519722832656769,-0.05943829984027264},
{-0.15642937052200598,0.07608898828841895,-0.05456986335360714},
{-0.16465560728902914,0.15047660385349093,0.03852870165791203},
{-0.1766210425865173,0.07085411034576783,0.051623374911600683},
{0.5903035328059891,0.34983571270376634,-0.06479283213589862},
{0.6577063255161525,0.3562969729804394,-0.04186406674708685},
{-0.5902362272324408,0.3500151942332285,-0.06457595862113165},
{-0.6573548408542887,0.3563868633131117,-0.04264929843848451},
{0.1279965048963496,0.72590926931985,0.007276480340285026},
{0.13246858633878578,0.7840613596496133,0.00871981097304454},
{0.11378007208352141,0.7207941205141444,0.008570243031825938},
{-0.30334995918103924,-0.9749922402282496,0.06554067184199165},
{-0.3038360549899997,-0.9756503391696115,0.08986041908413643},
{-0.29648479067910544,-0.9757251231402208,0.10456294770592506},
{-0.26257026000778727,-0.975590511993124,0.13927018846570177},
{-0.21555357768571956,-0.9761439133756328,0.14705519980613005},
{-0.20373023193238904,-0.9753586816842351,0.1360469993324409},
{-0.18494449851533254,-0.9751792001547729,0.10789083439803897},
{0.18498189050063715,-0.9750371106106153,0.10773378805975943},
{0.2034834448293783,-0.9758896478755613,0.1359198665824051},
{0.21528435539152604,-0.97612147818445,0.14703276461494727},
{0.26276469833137145,-0.9761364349785719,0.13888879021559436},
{0.2958266917377435,-0.9757924287137691,0.10500417313251993},
{0.3033948295634048,-0.9757699935225864,0.08977815671646619},
{0.3029610825338709,-0.9751044161841635,0.06539858229783398},
{0.20528573852106244,0.497795798554269,-0.10737482500083476},
{0.1516282396088888,0.4129309487068337,-0.15029334573351277},
{-0.12842277352882264,0.724802541338803,-0.015480281916125355},
{-0.13881774544351552,0.6777035218650943,-0.03180562270013583},
{-0.12321780917441527,0.6776214090653654,-0.006880125296055708},
{-0.11206751915656846,0.6750936360748003,0.010028530458707314},
{-0.11499157240739215,0.638090527417318,-0.003694328148099473},
{-0.1246611398071748,0.6446789952279974,-0.018067807299207178},
{-0.07574494463163084,0.6957565219381209,-0.1381633857006841},
{-0.047027899917659134,0.7154545450126403,-0.11369407051732072},
{-0.03495028866425698,0.7203828834597639,-0.14208954415767241},
{-0.06745140229105932,0.6966238664292476,-0.1563059769705006},
{-0.016919873350354442,0.7150581151844404,-0.161720336442614},
{-0.01503531729100005,0.7301720304285507,-0.12935383396290842},
{-0.015850462570641433,0.7275545914572251,-0.11323788829660399},
{-0.003787808111361137,0.7231797291765811,-0.1375202435534441},
{-0.010548279054441972,0.7180271883855708,-0.1301615008454889},
{-0.028234688103541728,0.7132259826884829,-0.1389560957891427},
{-0.06221652434840823,0.6892877084804163,-0.15466072961709595},
{-0.10555383531649831,0.647027137121159,-0.16190729636913728},
{-0.05165702769837488,0.6919498682661662,-0.17677434972626635},
{0.13937862522308522,0.6776661298797898,-0.03141674605296745},
{0.12808624566108073,0.7247651493534983,-0.015181146033688149},
{0.12282893252724687,0.6774941267473882,-0.007373699502077095},
{0.1251173220278915,0.6446416780266636,-0.017791106607952762},
{0.11459521736316279,0.6380455822509818,-0.0035073682215762195},
{0.1115440313623033,0.6750487656924349,0.010193055194047776},
{0.060997545627476564,0.7699496991796088,-0.1515646732338709},
{0.03599726425278714,0.7553144761313684,-0.12031993031330482},
{0.024884366220244977,0.7396171711325348,-0.1448640294672775},
{0.0528386144340018,0.7627329712318406,-0.16806949554734368},
{0.007010997244621968,0.7351151761018551,-0.16398629075207583},
{0.007392395494729404,0.730261771193282,-0.12852373188914518},
{0.007332568318241963,0.7379570417689789,-0.11436712625280444},
{-0.00453564781745415,0.7329241553309437,-0.13792407699473436},
{0.0006842733310750796,0.7409634321714434,-0.13357912830233393},
{0.0166506510561609,0.7464750108053491,-0.14420593052591563},
{0.046108057079164676,0.7687604844789796,-0.16805453875322182},
{0.08208662533929952,0.8134588637121589,-0.19124504803916614},
{0.036468403267625744,0.7581413102204,-0.18792463974411316},
{0.12220822557118965,0.7874341167240926,-0.11898877563645927},
{0.07231983877772477,0.7627030576435967,-0.0959403558946726},
{0.13492897897183181,0.8515689247026001,-0.1242386103732322},
{-0.1342933152216528,0.8516959826686653,-0.12384973372606384},
{-0.12233535832122554,0.7874789871064584,-0.11923556273946995},
{-0.0720132244982267,0.7627629596040549,-0.09578330955639308},
{-0.29430857713437475,-0.949378730294564,0.07595060055080638},
{-0.2958566053259873,-0.9619424373569265,0.09869240601309491},
{-0.25692407022678504,-0.9585622018853862,0.12896495731574006},
{-0.2471348484740275,-0.9419676388071823,0.09504294824736101},
{-0.1983607428426412,-0.9453254390875397,0.11072514688413149},
{-0.2130557930673689,-0.9588688161648843,0.14548473642333473},
{0.29393465728132817,-0.9496404741916965,0.07556172390363802},
{0.2566473695355306,-0.9579938437087555,0.12871069181566844},
{0.29545277188469704,-0.9621667892687544,0.098041785468794},
{0.21218829900830097,-0.9586968130324829,0.14540995245272542},
{0.19835326444558024,-0.9455797045876114,0.110455924589938},
{0.2469478885475042,-0.9420274659836697,0.09541686810040752},
{-0.22291979879073573,-0.2222616624573885,-0.022637107903435486},
{-0.27520127264369826,-0.21727357161774816,-0.022016400947378285},
{-0.27484978798183457,-0.22162599870720945,0.0502623066465114},
{-0.29252871863387336,-0.4802439258682951,0.032142150567877704},
{-0.292887681692798,-0.4758914987788338,-0.04013655702601199},
{-0.24024724478091083,-0.4852245383108746,0.0315214436118205},
{-0.24077073257517598,-0.48013174991238117,-0.0400169026730371},
{0.0006693165369532193,0.41670006082554245,-0.17620599154963568},
{0.0006842733310750796,0.3515332340526268,-0.17128520628354366},
{-0.09486720591642916,0.6129332744883196,0.012907713327165412},
{-0.10532948340467042,0.6404985712709375,0.010372536723510099},
{-0.14032838164982342,0.7132185042914221,-0.030728733523361883},
{0.14011898653211732,0.7130988499384472,-0.03107273978816467},
{0.08177253266274045,0.7463179644670693,-0.10376275922040552},
{-0.08200436297162934,0.7463777168595862,-0.10368797524979621},
{-0.22256831412887204,-0.2266140895468499,0.0496415996904542},
{-0.07817542367643313,0.7068543883925708,0.09810161264528143},
{-0.07610390769055547,0.6909628694220648,0.09884945235137443},
{-0.07814551008818939,0.7068917803778753,0.09207402461417175},
{-0.07609642929349454,0.6913516712852625,0.09579078795345403},
{-0.06816185001184767,0.6799545193804344,0.10311961707316555},
{-0.06814689321772582,0.6801714676791718,0.09857275166012003},
{-0.048635755285759114,0.6801639144981404,0.11164498972262589},
{-0.04862827688869818,0.6799021706010077,0.10942390579552964},
{-0.03297599184017142,0.6831479444933927,0.11667047254757093},
{-0.0329685134431105,0.6828862005962602,0.11444191022341377},
{-0.029580799574509146,0.6922789925208178,0.11916077876886066},
{-0.02957332117744822,0.6920172486236851,0.11693221644470349},
{-0.03224310892820027,0.7029956102931012,0.11842041745982859},
{-0.03223563053113934,0.7028159791956976,0.11693221644470349},
{-0.04022255859221272,0.7119022316247278,0.1161918551356714},
{-0.04021508019515179,0.7117302284923266,0.11470365412054631},
{-0.05559814294948506,0.7157536808950775,0.11256483256112029},
{-0.05558318615536321,0.7154919369979448,0.11033627023696312},
{-0.06828150436482257,0.714826359659522,0.10570714245624738},
{-0.06827402596776164,0.7145646157623895,0.10347858013209019},
{0.07581972860224008,0.6907982699027537,0.09903641227789771},
{0.07809316130876284,0.706966489564514,0.09829605096886562},
{0.07812307489700655,0.7070038815498185,0.09226846293775594},
{0.06880499215908761,0.7145496589682677,0.10366554005861345},
{0.06880499215908761,0.7147216621006692,0.10515374107373854},
{0.05528405027292595,0.7154769054198523,0.11053070856054731},
{0.055276571875865016,0.715738649316985,0.11275927088470449},
{0.04057404325407638,0.7117751736586627,0.11415773113509842},
{0.04056656485701545,0.7120443211688854,0.1163862934592556},
{0.03227302251644394,0.7029357083326432,0.1163862934592556},
{0.03226554411938301,0.7031974522297756,0.11861485578341277},
{0.029087225368487707,0.6921294993635697,0.11712665476828768},
{0.029079746971426776,0.6923912432607022,0.11935521709244484},
{0.032669377560673236,0.6827141974638589,0.11463634854699795},
{0.032669377560673236,0.6828936042093504,0.11611707116506212},
{0.04830670581507814,0.6798798101937956,0.10887050441302082},
{0.04829174902095627,0.6802312200716887,0.11183942804621007},
{0.06856568345313785,0.67976008105685,0.09885693074843536},
{0.06855072665901599,0.6802911220321469,0.10331405539674973},
{0.07583468539636194,0.6910973310012203,0.09523738657094519},
{-0.03947471888611971,0.7127324084824617,0.11684995407703326},
{-0.03149526922210726,0.7030852762738616,0.1191682571659216},
{-0.022050053734152513,0.6955471268204149,0.12620542880025687},
{-0.016059857688347477,0.6765444451046209,0.12470974938807083},
{-0.03297599184017142,0.6786084079094669,0.11645359903280396},
{-0.0703978907330658,0.6767164482370222,0.10122758261675022},
{-0.0824904587805898,0.6789674457523621,0.09403336464413543},
{-0.08771785832617997,0.7146169645418161,0.08980807030470991},
{-0.06976222698288673,0.7174437986308475,0.10237925576413347},
{-0.05559066455242414,0.7186404169445672,0.1114729865902245},
{-0.059412125450559426,0.6670094888519349,0.12038723588685321},
{-0.09587678951965474,0.6700905884410381,0.07619738765381709},
{-0.01908113010096325,0.6459653543064481,0.13357164990527304},
{-0.057916446038373405,0.6414931980800412,0.12114255399000716},
{-0.09140470807721851,0.6383298361232678,0.08146965758177283},
{-0.10532948340467042,0.6404985712709375,0.010372536723510099},
{-0.11206751915656846,0.6750936360748003,0.010028530458707314},
{-0.09889058353520958,0.7268441437364369,0.07853064753682727},
{-0.06163320937765568,0.727075899261355,0.1125423973699375},
{-0.05613658753787203,0.7214072742891702,0.11290883882592309},
{-0.031024130207268664,0.7261710132169824,0.12406660724083084},
{-0.03821086978282252,0.7116255309334735,0.11940756587187137},
{-0.027015709382610113,0.7092698358592804,0.1250014068734471},
{0.016104728070713004,0.6764621827369506,0.12409652082907456},
{0.022072488925335247,0.695554530433505,0.12638491032971919},
{0.03151770441329,0.7032871182105365,0.11935521709244484},
{0.03981872515092244,0.7128744980266193,0.11703691400355652},
{0.05528405027292595,0.7186178321854431,0.11165994651674775},
{0.06956031026224156,0.7174288418367257,0.10258117248477858},
{0.08802447260567806,0.7145646157623895,0.08977815671646619},
{0.08278211626596603,0.6789150969729355,0.09395858067352614},
{0.07005388446826295,0.6763126895797025,0.10153419689624836},
{0.032669377560673236,0.6783466640123345,0.11590019765029513},
{0.059494387818229605,0.6669421084944159,0.12012549198972065},
{0.019066173306841332,0.6458830171548073,0.13298833493452047},
{0.006345419906199187,0.6789075437919042,0.13205353530190422},
{0.010824979745696333,0.7023674249399832,0.1330705973021907},
{0.026828749456086806,0.709277389040312,0.12521828038821406},
{0.03806878023866479,0.7115508217468348,0.11897381884233742},
{0.09557017524015655,0.6700382396616117,0.07622730124206081},
{0.09181601991556962,0.6382774873438414,0.08146965758177283},
{0.05799870840604358,0.6414258177225223,0.12086585329875274},
{0.023156856499170115,0.6186915654412652,0.1328013750079972},
{-0.00040757263982071906,0.6317264115184666,0.14060134314254735},
{-0.00041505103688164915,0.6348673382840572,0.14173805949580873},
{-0.022984853366768775,0.6186840122602336,0.13267424225796143},
{-0.05139528380124233,0.6143167031606213,0.11851015822455975},
{-0.07419691644001829,0.596787340449801,0.08040772519912075},
{-0.09486720591642916,0.6129332744883196,0.012907713327165412},
{-0.03951958926848528,0.5790560610183357,0.1085414549423399},
{-0.05098397196289118,0.5719740190016347,0.07439509396213292},
{-0.07619364845528663,0.5905203689287708,0.020902119785299718},
{-0.01801171932125024,0.6009602860098001,0.12667656781509545},
{-0.017884586571214427,0.5722881116781938,0.121479081857749},
{-0.02714284213264593,0.5588345501495512,0.09712942102736051},
{1.1217595591368092e-05,0.6011622775144156,0.12950340190412704},
{4.8609580896018714e-05,0.5697604134715994,0.12561463543244336},
{-0.00026548309566304666,0.5534724646728937,0.1091621618983971},
{-0.011468121892936379,0.5552598763544264,0.10513878427961668},
{0.01801171932125019,0.5722955152912843,0.12162117140190667},
{0.011714908995947019,0.5552598763544264,0.10523600344140878},
{0.02744945641214401,0.5588419537626415,0.09734629454212748},
{0.03900357987128106,0.5790710178124576,0.10886302601595989},
{0.05147006777185158,0.5719963794088471,0.07481388419754502},
{0.07387534536639824,0.5974678745823456,0.08018337328729283},
{0.07636565158768797,0.5904680201493444,0.020774987035263908},
{0.09509155782825703,0.6128809257088932,0.012937626915409133},
{0.1055613137135592,0.6404462224915111,0.010484712679424052},
{0.1115440313623033,0.6750487656924349,0.010193055194047776},
{0.09928693857943881,0.7267917949570102,0.07859047471331473},
{0.11378007208352141,0.7207941205141444,0.008570243031825938},
{0.05116345349235344,0.6145858506708439,0.11851015822455975},
{0.01830337680662646,0.6007359340979722,0.12667656781509545},
{0.02213979449888362,0.6124097866940547,0.13048307191910888},
{0.02065159348375852,0.6153786355432732,0.13012410886018425},
{-7.852316913979343e-05,0.6122377835616531,0.1365854439208279},
{-7.852316913979343e-05,0.6151243700432016,0.13549359794993207},
{-0.02084603180734276,0.6153413183419394,0.13024376321315914},
{-0.022341711219528784,0.6123648415277185,0.1305877694779619},
{0.03105404379551233,0.7260963040303438,0.12357303303480945},
{0.05603936837607989,0.7214223058672624,0.11336502104663983},
{0.06101250242159842,0.7270161468688381,0.1122956102669268},
{-0.006367855097382032,0.6789075437919042,0.1320011865224777},
{-0.007945796877238287,0.6589028316539159,0.15392784670512483},
{-0.007945796877238287,0.647670279268399,0.15450368327881644},
{-0.00048235661043002036,0.659254465883721,0.15693416232361876},
{-0.0004898350074909504,0.6474608841506929,0.15907298388304478},
{0.0077588369507149806,0.6476778324494303,0.1545635104553039},
{0.0077588369507149806,0.6589028316539159,0.15399515227867322},
{-0.0004000942427597889,0.6816596686942972,0.13621900246484228},
{-0.00040757263982071906,0.7036386028724001,0.13739311080340832},
{0.015319496379315341,0.7262233619964091,0.1310289949045568},
{-0.010114532024908026,0.7023674249399832,0.13298085653745956},
{-0.015341931570498185,0.7262159583833186,0.130901862154521},
{-0.00040757263982071906,0.7260065632656127,0.13550855474405393},
{0.020928294175012938,0.6161115184552446,0.13008671687487958},
{0.052591827330991096,0.6122227519835607,0.08990528946650202},
{0.027165277323828663,0.6099118525077626,0.04508725588034776},
{1.8695992652298223e-05,0.6350393414164587,0.0984904892924498},
{-4.8609580896072924e-05,0.6168070841658815,0.1353589868028353},
{-0.020726377454367874,0.6161115184552446,0.12997454091896565},
{-0.02742702122096127,0.6098968957136408,0.04486290396851984},
{-0.0528760064193065,0.6119610080864282,0.08990528946650202},
{0.00011591515444438988,0.5995468689652841,0.09883449555725259},
{-8.600156620072359e-05,0.5662156532647187,0.06398516525331818},
{-0.038151042606335075,0.5774706408414185,0.04442915693898589},
{0.038136085812213165,0.5774032604838993,0.04399540990945196},
{0.06591833089356859,0.5898473879772578,0.015532630695551887},
{-7.852316913979343e-05,0.6191627044561039,0.14261303195193756},
{0.04731207900597442,0.6218698841921606,0.09596279108585541},
{0.02928166369207189,0.6158797629303261,0.1154215802383956},
{0.05476804087572176,0.6209949117360317,0.10136967216090789},
{0.032990948634293235,0.6152739379844202,0.12304206684348341},
{9.34799632615995e-05,0.6150046409062562,0.12067889337222949},
{6.356637501787898e-05,0.6136511258221984,0.12836668555086567},
{-0.03281894550189189,0.6152589811902983,0.12277284454928993},
{-0.02979767308927612,0.6158722097492946,0.11518227153244585},
{-0.055171874317012044,0.6210622920935509,0.10166132964628417},
{-0.0476635636678382,0.6218475237849486,0.09558139283574799},
{0.00010843675738345977,0.6257212586785397,0.13536646519989626},
{0.00010095836032252962,0.6122527403557749,0.13030359038964656},
{0.017316228394583685,0.612020760478945,0.12769362981538196},
{0.02930409888325468,0.6273067536394273,0.12955575068355354},
{0.023306424440388718,0.6115346646699846,0.12572681138835734},
{0.030044460192286765,0.6125368446601198,0.12375999296133271},
{0.05406507155199433,0.6204115219813088,0.10686629400069153},
{-0.017084398085694907,0.6120956940174955,0.12754406187416334},
{-0.02902739819200032,0.6270673701495072,0.12995210572778285},
{-0.02380747704347109,0.6116393622288377,0.12552489466771222},
{-0.029782716295154263,0.6126715305911872,0.12349824906420015},
{-0.05362384612539951,0.6202844640152434,0.10704577553015387},
{-0.06570893577586259,0.5899147683347766,0.015742025813257933},
{-0.032803988707770036,0.5997936560682948,0.11932530350420113},
{-0.05365375971364323,0.6085658158207659,0.0978697823363926},
{7.852316913973924e-05,0.5989260872252563,0.12482940374104572},
{0.03300590542841509,0.6005488993874781,0.11950478503366345},
{0.053287318257657604,0.6084984354632469,0.09756316805689447},
{-0.029782716295154263,0.6012369867010544,0.11239282942871891},
{0.00011591515444438988,0.5995394653521939,0.1172313523271407},
{0.02929662048619375,0.6011547243333841,0.11188429842857565},
{0.04583135638791026,0.6092836671546447,0.0914159256728099},
{-0.04615292746153031,0.6093510475121635,0.0917898455258564},
{-0.11356319856875448,0.7208390656804806,0.008390761502363614},
{-0.09621331738739658,0.7017466431999554,0.07790246218370915},
{-0.06205199961306776,0.6620962567668744,0.10428624701467064},
{-0.07168417502754577,0.7343748895767935,0.10114532024908},
{-0.04096291990124481,0.731510738286428,0.11477843809115562},
{-0.032893729472501194,0.6607052001295709,0.11477843809115562},
{-0.008888074906915485,0.696265052938264,0.1210752484164588},
{0.07175895899815501,0.734113145679661,0.1012201042196893},
{0.0407759599747215,0.7312489943892952,0.11492800603237421},
{0.061603295789411906,0.6620063664342019,0.10371041044097903},
{0.032706769545977885,0.6609669440267033,0.11492800603237421},
{0.008633809406843806,0.6961303670071967,0.1210752484164588},
{0.09630305815212771,0.7023897853471952,0.07852316913976637}
};


// texture array: 8kb.
const tgx::fVec2 naruto_tex_array[1145] PROGMEM = {
{0.3809,0.4395},
{0.375,0.4727},
{0.3457,0.4258},
{0.3457,0.4668},
{0.3691,0.502},
{0.3379,0.4961},
{0.3613,0.541},
{0.3242,0.5391},
{0.3652,0.5684},
{0.3262,0.5742},
{0.332,0.6035},
{0.373,0.5977},
{0.3789,0.6309},
{0.334,0.6387},
{0.3223,0.6035},
{0.3105,0.6074},
{0.3223,0.6406},
{0.2832,0.6191},
{0.293,0.6484},
{0.2461,0.6328},
{0.2637,0.6582},
{0.2227,0.6563},
{0.2539,0.6816},
{0.2207,0.6758},
{0.25,0.7109},
{0.2168,0.707},
{0.207,0.7246},
{0.2422,0.7285},
{0.3184,0.5742},
{0.3047,0.5742},
{0.2754,0.5762},
{0.2363,0.5762},
{0.2246,0.5977},
{0.1582,0.6563},
{0.1602,0.6738},
{0.1602,0.7051},
{0.1602,0.7246},
{0.9648,0.541},
{0.9746,0.5332},
{0.9863,0.5547},
{0.9688,0.5684},
{0.957,0.5488},
{0.9434,0.5547},
{0.9297,0.584},
{0.9258,0.5586},
{0.9121,0.5645},
{0.8945,0.5879},
{0.8945,0.5586},
{0.875,0.5645},
{0.8574,0.584},
{0.8633,0.5566},
{0.8457,0.5547},
{0.8203,0.5684},
{0.8301,0.5488},
{0.8242,0.541},
{0.8008,0.5527},
{0.8145,0.5332},
{0.8438,0.541},
{0.8359,0.5156},
{0.832,0.5117},
{0.8203,0.5039},
{0.8496,0.5},
{0.8516,0.5156},
{0.877,0.5176},
{0.8945,0.5},
{0.8945,0.5176},
{0.9102,0.5176},
{0.9375,0.502},
{0.9355,0.5156},
{0.9551,0.5117},
{0.9668,0.5039},
{0.9512,0.5156},
{0.9434,0.541},
{0.918,0.5469},
{0.8945,0.5293},
{0.8691,0.5469},
{0.8613,0.5195},
{0.8262,0.4941},
{0.791,0.4785},
{0.8379,0.4707},
{0.7969,0.4531},
{0.7617,0.4668},
{0.7676,0.4414},
{0.7227,0.4531},
{0.7285,0.4258},
{0.6758,0.4375},
{0.6836,0.4102},
{0.6465,0.4336},
{0.6484,0.4023},
{0.6113,0.4102},
{0.6191,0.4375},
{0.5664,0.4238},
{0.5723,0.4512},
{0.5273,0.4414},
{0.5332,0.4648},
{0.4961,0.4512},
{0.5039,0.4766},
{0.457,0.4688},
{0.4688,0.4922},
{0.6484,0.375},
{0.6074,0.3809},
{0.5586,0.3926},
{0.5156,0.4082},
{0.4863,0.4199},
{0.4531,0.4336},
{0.4434,0.4355},
{0.4473,0.4199},
{0.4395,0.4258},
{0.3535,0.4004},
{0.4375,0.3809},
{0.375,0.3672},
{0.3809,0.3633},
{0.4375,0.375},
{0.4746,0.3672},
{0.4746,0.375},
{0.5039,0.3613},
{0.5039,0.3574},
{0.5488,0.3438},
{0.5469,0.3398},
{0.582,0.3281},
{0.5879,0.334},
{0.6113,0.3242},
{0.6152,0.3281},
{0.6309,0.3184},
{0.627,0.3125},
{0.6309,0.3652},
{0.4805,0.4102},
{0.6484,0.3555},
{0.9766,0.9082},
{0.9629,0.8848},
{0.9941,0.9043},
{0.9746,0.9434},
{0.9531,0.9336},
{0.9668,0.9473},
{0.9434,0.9805},
{0.9395,0.9434},
{0.9355,0.9707},
{0.9355,0.9766},
{0.9219,0.9824},
{0.9199,0.9277},
{0.8945,0.9492},
{0.8945,0.9727},
{0.9063,0.9824},
{0.8945,0.9922},
{0.8848,0.9824},
{0.8672,0.9824},
{0.8711,0.9277},
{0.8516,0.9434},
{0.8555,0.9707},
{0.8555,0.9766},
{0.8457,0.9805},
{0.8359,0.9336},
{0.8242,0.9473},
{0.8164,0.9434},
{0.8125,0.9082},
{0.7969,0.9043},
{0.8281,0.8848},
{0.8457,0.8984},
{0.8652,0.873},
{0.8945,0.8926},
{0.8945,0.8633},
{0.9238,0.873},
{0.9434,0.8984},
{0.3125,0.5371},
{0.3203,0.4922},
{0.3223,0.4551},
{0.3418,0.4238},
{0.8594,0.0898},
{0.8203,0.1055},
{0.8223,0.1035},
{0.8047,0.1426},
{0.8027,0.1426},
{0.8203,0.1816},
{0.8164,0.1816},
{0.8574,0.1992},
{0.8555,0.2012},
{0.8965,0.1855},
{0.8945,0.1855},
{0.9141,0.1465},
{0.9121,0.1484},
{0.9004,0.1074},
{0.8965,0.1074},
{0.8613,0.0918},
{0.2031,0.3125},
{0.1602,0.334},
{0.1582,0.3066},
{0.1992,0.2969},
{0.1582,0.2949},
{0.2051,0.3379},
{0.2676,0.3496},
{0.2656,0.3203},
{0.2617,0.3008},
{0.207,0.3613},
{0.2695,0.3965},
{0.3145,0.3516},
{0.3125,0.3184},
{0.3086,0.2988},
{0.2461,0.4297},
{0.2676,0.4336},
{0.291,0.4375},
{0.3223,0.4082},
{0.3125,0.3809},
{0.2656,0.4883},
{0.2832,0.4883},
{0.2813,0.5352},
{0.2305,0.791},
{0.2031,0.7695},
{0.2578,0.7402},
{0.2637,0.7813},
{0.2988,0.7266},
{0.3027,0.7754},
{0.3418,0.7305},
{0.3535,0.7695},
{0.416,0.75},
{0.3965,0.7695},
{0.4043,0.8184},
{0.3633,0.8281},
{0.3145,0.8359},
{0.2754,0.8379},
{0.2305,0.8398},
{0.4141,0.8359},
{0.3711,0.8535},
{0.3281,0.8633},
{0.3477,0.875},
{0.3438,0.8848},
{0.6875,0.3223},
{0.6738,0.3125},
{0.6914,0.2754},
{0.709,0.2852},
{0.6992,0.2598},
{0.7148,0.2695},
{0.7168,0.2168},
{0.7363,0.2285},
{0.7402,0.2813},
{0.7617,0.2441},
{0.7852,0.2559},
{0.7695,0.2949},
{0.8184,0.2656},
{0.8086,0.3027},
{0.8457,0.2754},
{0.8379,0.3066},
{0.8867,0.2813},
{0.873,0.3203},
{0.9141,0.3281},
{0.9141,0.2832},
{0.666,0.3652},
{0.7129,0.332},
{0.7344,0.2949},
{0.7637,0.3086},
{0.8047,0.3203},
{0.834,0.3301},
{0.8672,0.3398},
{0.916,0.3418},
{0.6895,0.3809},
{0.75,0.3457},
{0.7363,0.3945},
{0.791,0.3594},
{0.7793,0.4102},
{0.8223,0.3711},
{0.8125,0.4102},
{0.8613,0.3809},
{0.8457,0.4199},
{0.9395,0.418},
{0.9199,0.3789},
{0.8535,0.4258},
{0.8496,0.4375},
{0.8398,0.4336},
{0.8086,0.4219},
{0.3262,0.6426},
{0.3281,0.6426},
{0.6367,0.1641},
{0.6387,0.1113},
{0.6699,0.1133},
{0.6738,0.166},
{0.6699,0.1738},
{0.6387,0.1738},
{0.5957,0.1758},
{0.5977,0.1641},
{0.5605,0.166},
{0.5605,0.1777},
{0.5137,0.168},
{0.5137,0.1777},
{0.4727,0.1719},
{0.4727,0.1816},
{0.4219,0.1719},
{0.418,0.1797},
{0.3789,0.1699},
{0.3809,0.1797},
{0.5977,0.1113},
{0.5605,0.1113},
{0.5137,0.1113},
{0.4707,0.1191},
{0.4277,0.1211},
{0.3848,0.1172},
{0.916,0.2754},
{0.8848,0.2754},
{0.8496,0.2676},
{0.8203,0.2578},
{0.7891,0.25},
{0.7637,0.2383},
{0.7402,0.2207},
{0.7207,0.2051},
{0.7578,0.1758},
{0.7637,0.1934},
{0.7832,0.207},
{0.8008,0.2129},
{0.832,0.2188},
{0.8574,0.2285},
{0.8828,0.2363},
{0.9141,0.2344},
{0.1172,0.334},
{0.0859,0.3086},
{0.1133,0.3125},
{0.1289,0.3145},
{0.123,0.3359},
{0.125,0.3652},
{0.125,0.3672},
{0.1289,0.3906},
{0.1309,0.4102},
{0.1309,0.4043},
{0.1289,0.4258},
{0.1309,0.4141},
{0.127,0.4355},
{0.127,0.4258},
{0.1191,0.4355},
{0.1191,0.4258},
{0.1172,0.4141},
{0.1172,0.4258},
{0.1172,0.4023},
{0.1152,0.4121},
{0.1133,0.3945},
{0.1133,0.3926},
{0.1133,0.4082},
{0.1133,0.4141},
{0.1113,0.4336},
{0.1113,0.4238},
{0.1094,0.4473},
{0.1094,0.4395},
{0.0996,0.4492},
{0.0996,0.4414},
{0.0977,0.4258},
{0.0977,0.4336},
{0.0957,0.4082},
{0.0938,0.4141},
{0.0938,0.3965},
{0.0938,0.3945},
{0.0918,0.4121},
{0.0918,0.418},
{0.0879,0.4395},
{0.0879,0.4316},
{0.0859,0.457},
{0.0859,0.4512},
{0.0742,0.459},
{0.0742,0.4512},
{0.0742,0.4316},
{0.0742,0.4395},
{0.0742,0.4121},
{0.0723,0.418},
{0.0742,0.3984},
{0.0742,0.3965},
{0.0684,0.4219},
{0.0684,0.4238},
{0.0645,0.4434},
{0.0664,0.4375},
{0.0625,0.457},
{0.0625,0.4531},
{0.0547,0.4512},
{0.0527,0.4551},
{0.0547,0.4355},
{0.0527,0.4414},
{0.0547,0.418},
{0.0547,0.4199},
{0.0547,0.4004},
{0.0586,0.3809},
{0.0527,0.3828},
{0.0508,0.334},
{0.0801,0.3438},
{0.0762,0.3789},
{0.0586,0.3633},
{0.0313,0.3633},
{0.0234,0.3828},
{0.0391,0.3789},
{0.0488,0.3789},
{0.0176,0.3926},
{0.0332,0.3926},
{0.041,0.4043},
{0.0449,0.3926},
{0.0156,0.4063},
{0.0273,0.4043},
{0.0313,0.4141},
{0.0215,0.4141},
{0.0469,0.3145},
{0.5352,0.9531},
{0.5332,0.9961},
{0.5938,0.9961},
{0.5938,0.9629},
{0.6582,0.9648},
{0.6523,0.9961},
{0.709,0.9727},
{0.709,0.9961},
{0.7441,0.9961},
{0.7441,0.9727},
{0.7676,0.9961},
{0.7676,0.9727},
{0.8145,0.9961},
{0.8145,0.9727},
{0.5898,0.9531},
{0.4844,0.9512},
{0.4863,0.9961},
{0.4844,0.9102},
{0.5371,0.9004},
{0.6016,0.8945},
{0.668,0.9238},
{0.7188,0.9414},
{0.7441,0.9023},
{0.6914,0.8789},
{0.6387,0.8477},
{0.7012,0.0039},
{0.6953,0.0117},
{0.6016,0.0059},
{0.6016,0.0156},
{0.6934,0.0176},
{0.6016,0.0234},
{0.6953,0.0234},
{0.6035,0.0352},
{0.7012,0.0313},
{0.6055,0.043},
{0.7012,0.041},
{0.6055,0.0508},
{0.6992,0.0508},
{0.6055,0.0625},
{0.6406,0.207},
{0.6699,0.2051},
{0.6426,0.2266},
{0.6699,0.2246},
{0.6035,0.207},
{0.6055,0.2266},
{0.5625,0.2109},
{0.5645,0.2285},
{0.5117,0.2051},
{0.5098,0.2285},
{0.4727,0.1973},
{0.4727,0.2285},
{0.4258,0.209},
{0.4277,0.2324},
{0.3711,0.2266},
{0.377,0.207},
{0.3828,0.4707},
{0.3828,0.4355},
{0.4121,0.4746},
{0.416,0.4395},
{0.3789,0.5039},
{0.4102,0.5039},
{0.373,0.5371},
{0.4102,0.5371},
{0.373,0.5684},
{0.4121,0.5625},
{0.3809,0.5977},
{0.4121,0.5879},
{0.3906,0.6348},
{0.4277,0.6211},
{0.4316,0.4531},
{0.4258,0.4766},
{0.4258,0.502},
{0.4277,0.5313},
{0.4297,0.5586},
{0.4355,0.582},
{0.4434,0.6016},
{0.5996,0.0586},
{0.6016,0.0508},
{0.6016,0.043},
{0.5996,0.0352},
{0.5957,0.0234},
{0.5957,0.0156},
{0.5957,0.0098},
{0.9297,0.3711},
{0.9395,0.375},
{0.918,0.3281},
{0.9316,0.334},
{0.9473,0.377},
{0.9434,0.3379},
{0.957,0.377},
{0.9551,0.3379},
{0.9668,0.377},
{0.9688,0.3359},
{0.9746,0.373},
{0.9805,0.332},
{0.9824,0.3691},
{0.9922,0.3262},
{0.9746,0.3027},
{0.9844,0.293},
{0.957,0.2754},
{0.9551,0.2695},
{0.9238,0.2949},
{0.9355,0.3047},
{0.9453,0.3086},
{0.9551,0.3105},
{0.9668,0.3086},
{0.957,0.2793},
{0.9531,0.2754},
{0.9531,0.2793},
{0.9551,0.2793},
{0.2559,0.8711},
{0.2246,0.8535},
{0.2715,0.8613},
{0.2695,0.9102},
{0.291,0.9102},
{0.2715,0.9609},
{0.2559,0.9512},
{0.2266,0.9688},
{0.2246,0.9512},
{0.1934,0.9512},
{0.1777,0.9609},
{0.1797,0.9102},
{0.1582,0.9102},
{0.1777,0.8613},
{0.1934,0.8711},
{0.2246,0.8691},
{0.2246,0.9102},
{0.9531,0.623},
{0.9277,0.5977},
{0.9551,0.5957},
{0.9824,0.6035},
{0.9766,0.6465},
{0.9258,0.6387},
{0.9551,0.6641},
{0.9727,0.6934},
{0.9395,0.6875},
{0.9492,0.7109},
{0.9707,0.7324},
{0.9297,0.7461},
{0.9199,0.6992},
{0.8965,0.7188},
{0.8965,0.7559},
{0.8633,0.7461},
{0.873,0.6992},
{0.8438,0.7109},
{0.8223,0.7324},
{0.8203,0.6934},
{0.8535,0.6875},
{0.8379,0.6641},
{0.8164,0.6465},
{0.8672,0.6406},
{0.8379,0.623},
{0.8105,0.6035},
{0.8379,0.5957},
{0.8652,0.5977},
{0.8965,0.6211},
{0.8965,0.5918},
{0.916,0.666},
{0.8965,0.6914},
{0.877,0.666},
{0.8965,0.8379},
{0.918,0.8516},
{0.8965,0.8594},
{0.873,0.8516},
{0.873,0.8105},
{0.8555,0.834},
{0.8418,0.8516},
{0.8398,0.8125},
{0.8262,0.834},
{0.8105,0.8535},
{0.8047,0.8184},
{0.8203,0.793},
{0.7988,0.7793},
{0.834,0.7734},
{0.8125,0.7656},
{0.8125,0.75},
{0.918,0.8105},
{0.8965,0.8105},
{0.8965,0.7871},
{0.8691,0.7676},
{0.8516,0.791},
{0.9238,0.7676},
{0.8965,0.7598},
{0.7734,0.6582},
{0.8008,0.6602},
{0.7949,0.6836},
{0.752,0.6777},
{0.748,0.627},
{0.7246,0.6465},
{0.707,0.6738},
{0.7168,0.627},
{0.7266,0.6035},
{0.7051,0.5762},
{0.748,0.5684},
{0.7188,0.5527},
{0.707,0.5313},
{0.7461,0.5234},
{0.7637,0.543},
{0.7813,0.502},
{0.7852,0.5254},
{0.791,0.5215},
{0.7988,0.5332},
{0.793,0.5449},
{0.8008,0.541},
{0.7949,0.5605},
{0.7656,0.5957},
{0.7852,0.5918},
{0.7949,0.5801},
{0.791,0.6172},
{0.75,0.0977},
{0.7305,0.0898},
{0.7617,0.084},
{0.7656,0.1309},
{0.7539,0.123},
{0.7383,0.1543},
{0.7363,0.1367},
{0.7168,0.1328},
{0.7051,0.1445},
{0.7148,0.1055},
{0.6992,0.0977},
{0.7285,0.0723},
{0.7324,0.1133},
{0.9375,0.2012},
{0.9375,0.1523},
{0.9434,0.2051},
{0.9434,0.1484},
{0.9375,0.0996},
{0.9434,0.0996},
{0.9375,0.2539},
{0.9434,0.2539},
{0.9668,0.2051},
{0.9648,0.1484},
{0.9648,0.0996},
{0.9668,0.1484},
{0.9688,0.2051},
{0.9668,0.2539},
{0.9844,0.2539},
{0.9863,0.2051},
{0.9863,0.1484},
{0.9863,0.0996},
{0.9922,0.2012},
{0.9922,0.1523},
{0.9922,0.0996},
{0.9922,0.2539},
{0.623,0.8242},
{0.6191,0.8555},
{0.6152,0.793},
{0.5996,0.7852},
{0.6055,0.8633},
{0.5762,0.7852},
{0.5781,0.8633},
{0.5352,0.791},
{0.5332,0.8613},
{0.4941,0.793},
{0.4902,0.8574},
{0.4512,0.791},
{0.4512,0.8574},
{0.4316,0.8242},
{0.2051,0.416},
{0.1641,0.4336},
{0.1641,0.4043},
{0.1621,0.3594},
{0.2031,0.4473},
{0.2402,0.4922},
{0.2578,0.5352},
{0.0957,0.4727},
{0.0938,0.4941},
{0.0781,0.4766},
{0.0723,0.4961},
{0.1016,0.5352},
{0.1172,0.5215},
{0.1133,0.5391},
{0.1309,0.5449},
{0.1191,0.5508},
{0.123,0.5625},
{0.1367,0.5547},
{0.127,0.5723},
{0.1367,0.5684},
{0.084,0.541},
{0.0938,0.5605},
{0.0859,0.5605},
{0.0938,0.5859},
{0.0781,0.5898},
{0.0957,0.6094},
{0.082,0.6094},
{0.084,0.625},
{0.0957,0.623},
{0.1016,0.5449},
{0.1055,0.5469},
{0.1094,0.5547},
{0.1133,0.5684},
{0.1172,0.5801},
{0.8047,0.7129},
{0.791,0.7559},
{0.7754,0.7129},
{0.748,0.7422},
{0.7617,0.7773},
{0.7793,0.7813},
{0.7891,0.793},
{0.793,0.8125},
{0.7461,0.8008},
{0.7617,0.8281},
{0.791,0.8281},
{0.7988,0.832},
{0.7969,0.8379},
{0.7832,0.8477},
{0.7891,0.8516},
{0.7813,0.8711},
{0.7422,0.8496},
{0.7148,0.8184},
{0.7031,0.8379},
{0.7012,0.791},
{0.7246,0.7637},
{0.7148,0.7383},
{0.7246,0.7188},
{0.709,0.6895},
{0.7559,0.6895},
{0.8027,0.6895},
{0.8945,0.9258},
{0.9258,0.5215},
{0.1582,0.0234},
{0.1797,0.0215},
{0.1582,0.0586},
{0.1777,0.0625},
{0.2031,0.0195},
{0.2012,0.0684},
{0.2383,0.0195},
{0.2031,0.0137},
{0.2383,0.0137},
{0.2637,0.0195},
{0.2637,0.0137},
{0.3086,0.0137},
{0.3086,0.0195},
{0.3398,0.0137},
{0.373,0.0195},
{0.3574,0.0137},
{0.373,0.0137},
{0.3887,0.0137},
{0.4043,0.0137},
{0.2363,0.082},
{0.2637,0.0938},
{0.3086,0.1055},
{0.373,0.1055},
{0.4375,0.0215},
{0.4063,0.0137},
{0.4375,0.0137},
{0.4863,0.0215},
{0.4863,0.0137},
{0.0332,0.2422},
{0.0957,0.2422},
{0.0957,0.1484},
{0.0332,0.1484},
{0.0938,0.0254},
{0.0313,0.0254},
{0.0313,0.1484},
{0.5781,0.8945},
{0.4277,0.2402},
{0.4258,0.3125},
{0.3496,0.3047},
{0.3691,0.2363},
{0.4727,0.3125},
{0.4727,0.2363},
{0.5098,0.3105},
{0.5117,0.2344},
{0.5664,0.3125},
{0.5645,0.2363},
{0.6133,0.3105},
{0.6074,0.2344},
{0.6426,0.2344},
{0.6484,0.3105},
{0.6641,0.2344},
{0.6719,0.3066},
{0.8887,0.2285},
{0.8672,0.2305},
{0.8457,0.2129},
{0.8262,0.1992},
{0.7988,0.1836},
{0.7832,0.166},
{0.4336,0.7656},
{0.4336,0.7246},
{0.498,0.7246},
{0.498,0.7676},
{0.5566,0.7227},
{0.5547,0.7031},
{0.498,0.7031},
{0.4336,0.7031},
{0.4961,0.7031},
{0.5566,0.7656},
{0.6113,0.7246},
{0.6113,0.7676},
{0.6621,0.7246},
{0.6621,0.7656},
{0.168,0.3594},
{0.168,0.3359},
{0.2051,0.3613},
{0.248,0.4297},
{0.2031,0.4141},
{0.2402,0.4902},
{0.2227,0.4941},
{0.2344,0.5313},
{0.207,0.5293},
{0.2207,0.5781},
{0.2227,0.5977},
{0.248,0.6328},
{0.2227,0.6543},
{0.2168,0.7051},
{0.166,0.3066},
{0.2656,0.3184},
{0.3125,0.3164},
{0.3125,0.3789},
{0.166,0.2949},
{0.8965,0.6465},
{0.8867,0.084},
{0.8867,0.0684},
{0.9727,0.0723},
{0.9746,0.0586},
{0.8926,0.0586},
{0.9746,0.043},
{0.8926,0.0469},
{0.9707,0.0313},
{0.8867,0.0371},
{0.9707,0.0176},
{0.8867,0.0215},
{0.7773,0.0527},
{0.7949,0.0449},
{0.8145,0.0859},
{0.832,0.0781},
{0.8105,0.0449},
{0.8496,0.0645},
{0.8223,0.0352},
{0.8613,0.0449},
{0.8242,0.0195},
{0.873,0.0273},
{0.8359,0.0059},
{0.4336,0.6582},
{0.4961,0.6582},
{0.5547,0.6582},
{0.6016,0.6582},
{0.6094,0.7051},
{0.6602,0.6582},
{0.6602,0.7031},
{0.9727,0.7949},
{0.9941,0.7813},
{0.9883,0.8203},
{0.9512,0.8125},
{0.9648,0.8359},
{0.9805,0.8555},
{0.9492,0.8535},
{0.9355,0.834},
{0.9414,0.791},
{0.959,0.7734},
{0.9785,0.7676},
{0.9805,0.752},
{0.1133,0.9316},
{0.9746,0.0293},
{0.9785,0.043},
{0.9785,0.0586},
{0.9766,0.0723},
{0.9727,0.084},
{0.2559,0.5352},
{0.2676,0.4316},
{0.0449,0.5},
{0.0293,0.502},
{0.0234,0.4785},
{0.0469,0.4785},
{0.0273,0.5332},
{0.0566,0.541},
{0.0723,0.5645},
{0.0391,0.5605},
{0.0566,0.5625},
{0.0586,0.584},
{0.0742,0.584},
{0.0742,0.6074},
{0.0605,0.6074},
{0.0723,0.627},
{0.0625,0.625},
{0.0391,0.582},
{0.0547,0.582},
{0.0527,0.6016},
{0.041,0.6016},
{0.0508,0.6172},
{0.043,0.6152},
{0.2773,0.7129},
{0.2754,0.6738},
{0.2969,0.6777},
{0.2969,0.7168},
{0.3203,0.6797},
{0.3203,0.7207},
{0.3516,0.6777},
{0.3516,0.7148},
{0.3789,0.707},
{0.3828,0.6719},
{0.4023,0.6973},
{0.4023,0.668},
{0.0254,0.5586},
{0.0254,0.5781},
{0.0371,0.5781},
{0.0254,0.5938},
{0.0352,0.5938},
{0.0352,0.6035},
{0.0273,0.6035},
{0.4395,0.1055},
{0.4844,0.0938},
{0.2363,0.0215},
{0.2383,0.082},
{0.2637,0.0215},
{0.2383,0.0156},
{0.2656,0.0137},
{0.2031,0.0703},
{0.2012,0.0195},
{0.2012,0.0137},
{0.1777,0.0215},
{0.1582,0.0215},
{0.7168,0.9668},
{0.7441,0.9668},
{0.7676,0.9688},
{0.8145,0.9668},
{0.2344,0.5332},
{0.207,0.5313},
{0.0566,0.9492},
{0.0664,0.9082},
{0.043,0.916},
{0.0391,0.9629},
{0.0215,0.9063},
{0.043,0.875},
{0.0586,0.8809},
{0.7754,0.0781},
{0.7949,0.125},
{0.7578,0.1328},
{0.7559,0.0859},
{0.7324,0.1348},
{0.7578,0.1602},
{0.7793,0.1641},
{0.7344,0.1621},
{0.7148,0.1582},
{0.709,0.1348},
{0.6758,0.127},
{0.6895,0.1641},
{0.7168,0.084},
{0.6934,0.0801},
{0.7305,0.0176},
{0.7344,0.0938},
{0.8379,0.6211},
{0.8633,0.5938},
{0.8359,0.5957},
{0.8125,0.6484},
{0.8633,0.6387},
{0.8359,0.6621},
{0.8359,0.6523},
{0.4414,0.9727},
{0.4355,0.9375},
{0.3848,0.9277},
{0.3867,0.9648},
{0.3301,0.9688},
{0.3301,0.9316},
{0.3828,0.9004},
{0.4316,0.9199},
{0.4629,0.9375},
{0.4746,0.9766},
{0.3281,0.9082},
{0.3105,0.9336},
{0.3027,0.9688},
{0.6914,0.5879},
{0.6641,0.5879},
{0.6641,0.5234},
{0.4941,0.5234},
{0.4941,0.5898},
{0.4688,0.5234},
{0.4688,0.5879},
{0.1914,0.1133},
{0.1602,0.1563},
{0.2227,0.1172},
{0.2246,0.1582},
{0.1621,0.1758},
{0.2246,0.1816},
{0.2285,0.2363},
{0.2285,0.2344},
{0.291,0.1758},
{0.2871,0.1563},
{0.2773,0.1094},
{0.4023,0.8184},
{0.4121,0.834},
{0.3281,0.8652},
{0.3125,0.834},
{0.3496,0.873},
{0.1738,0.8242},
{0.1738,0.7891},
{0.1543,0.7891},
{0.1543,0.8223},
{0.1328,0.8242},
{0.1289,0.7891},
{0.1133,0.8262},
{0.1074,0.793},
{0.1992,0.791},
{0.1953,0.8242},
{0.2246,0.7949},
{0.2188,0.8262},
{0.7129,0.0176},
{0.166,0.916},
{0.1699,0.916},
{0.1719,0.9121},
{0.1641,0.9121},
{0.166,0.9102},
{0.1699,0.9102},
{0.168,0.9082},
{0.2617,0.6582},
{0.0586,0.9531},
{0.0742,0.9668},
{0.0645,0.9395},
{0.0684,0.9121},
{0.0879,0.916},
{0.0742,0.8516},
{0.7227,0.9473},
{0.7461,0.9102},
{0.8008,0.0195},
{0.873,0.0547},
{0.7793,0.877},
{0.7754,0.8906},
{0.7734,0.8789},
{0.7793,0.4941},
{0.7734,0.4941},
{0.7754,0.4805},
{0.3086,0.2969},
{0.6641,0.4941},
{0.4961,0.4941},
{0.0098,0.793},
{0.0449,0.793},
{0.0098,0.6465},
{0.0449,0.6465},
{0.6641,0.6191},
{0.4961,0.6191},
{0.0313,0.8652},
{0.0371,0.8496},
{0.791,0.0938},
{0.6914,0.5234},
{0.168,0.916},
{0.2617,0.0938},
{0.7266,0.7148},
{0.6426,0.7324},
{0.6465,0.7266},
{0.623,0.707},
{0.6152,0.7148},
{0.6113,0.6875},
{0.5898,0.6953},
{0.5742,0.6621},
{0.6172,0.6563},
{0.6211,0.6465},
{0.6641,0.6465},
{0.7129,0.6309},
{0.709,0.6406},
{0.7324,0.6602},
{0.7559,0.6191},
{0.7695,0.7012},
{0.7402,0.6875},
{0.7207,0.709},
{0.6914,0.7363},
{0.6855,0.7246},
{0.6621,0.623},
{0.7871,0.5918},
{0.5547,0.5898},
{0.6445,0.5566},
{0.748,0.502},
{0.8887,0.4043},
{0.9355,0.5078},
{0.8105,0.709},
{0.7695,0.6992},
{0.6992,0.7559},
{0.6992,0.748},
{0.6172,0.7676},
{0.6406,0.7324},
{0.5977,0.7285},
{0.5371,0.6719},
{0.5488,0.7246},
{0.5605,0.5273},
{0.5059,0.5547},
{0.5059,0.5625},
{0.6211,0.4941},
{0.6953,0.4102},
{0.834,0.332},
{0.5898,0.4082},
{0.6426,0.3418},
{0.7793,0.2754},
{0.5469,0.4746},
{0.5391,0.4102},
{0.5645,0.3516},
{0.5059,0.4805},
{0.5078,0.4102},
{0.5098,0.3594},
{0.5313,0.3555},
{0.9434,0.6152},
{0.5566,0.5},
{0.5469,0.5117},
{0.5059,0.5117},
{0.5059,0.5176},
{0.5215,0.6211},
{0.5215,0.5957},
{0.5078,0.625},
{0.5078,0.5957},
{0.5078,0.6777},
{0.5078,0.7285},
{0.5605,0.7773},
{0.5078,0.7793},
{0.0664,0.873},
{0.0645,0.8633},
{0.0645,0.957},
{0.0625,0.8984},
{0.0625,0.8555},
{0.0605,0.8633},
{0.0586,0.957},
{0.0566,0.9082},
{0.0586,0.873},
{0.0195,0.8672},
{0.0859,0.7637},
{0.1309,0.8457},
{0.0723,0.9863},
{0.1914,0.9863},
{0.2422,0.8672},
{0.1777,0.7637},
{0.1309,0.748},
{0.5098,0.252},
{0.6621,0.2441},
{0.7852,0.2383},
{0.6934,0.7402},
{0.5059,0.5332},
{0.2539,0.9609},
{0.4238,0.9609},
{0.2539,0.9473},
{0.4238,0.9473},
{0.5117,0.9609},
{0.5117,0.9473},
{0.2559,0.9688},
{0.2559,0.9277},
{0.3047,0.9277},
{0.3516,0.9688},
{0.3281,0.9277},
{0.3516,0.9277},
{0.4375,0.9297},
{0.3535,0.9688},
{0.3535,0.9277},
{0.4238,0.9297},
{0.2539,0.9297},
{0.5117,0.9297},
{0.4238,0.9766},
{0.5117,0.9766},
{0.2539,0.9766},
{0.2188,0.7871},
{0.0449,0.7871},
{0.3359,0.5137},
{0.459,0.3652},
{0.4258,0.6309},
{0.5391,0.6191},
{0.5664,0.3613},
{0.6016,0.582}
};


// normal array: 18kb.
const tgx::fVec3 naruto_norm_array[1596] PROGMEM = {
{0.04790206486300984,-0.9927427931004148,-0.11030475478893496},
{-0.07589947743389679,-0.48359667044838583,0.8719939963420026},
{0.006200138512641576,-0.9998223362804916,0.017800397665325814},
{-0.0982961100084181,-0.29488833002525433,0.9504623861953349},
{-0.047197631446297315,0.5517723100014165,0.8326582140960122},
{-0.030400351278088537,0.7123082307691601,0.701208102506437},
{0.15999205099241476,0.9823511930934267,-0.09689518588228119},
{0.20100464225581996,0.896020693836889,-0.39590914362725926},
{0.23830566816772686,0.1905045312041627,-0.9523226512636437},
{0.28289881889989665,0.056299764948972014,-0.9574960024625346},
{0.193398998195784,-0.6221967770290424,-0.7585960704825324},
{0.16789626099190108,-0.6121863667614166,-0.7726827925458128},
{0.05580050220677981,-0.5156046404626463,-0.8550076951038841},
{-0.025300293864619863,-0.6058070364895934,-0.7952092364089216},
{-0.06409801876085967,-0.9825696292421329,0.1744946064550704},
{-0.03590177879769689,-0.7377365520629804,-0.674133400766782},
{0.017300532345570534,-0.9821302206118395,0.18740576656415714},
{0.14720672308456842,-0.5731261752701506,-0.8061368171091753},
{0.6330915736072324,-0.7244903570975201,-0.27259637176643753},
{0.5429051739109612,-0.09670092156417377,-0.834207950039646},
{0.9494724989273472,0.09479725423729594,-0.29919133404851217},
{0.5107974817746223,0.11409943749115972,-0.8520957991780649},
{0.9074358035859597,-0.1427056305617329,-0.3952155935388707},
{0.4399233033545844,-0.3413180800975668,-0.830644000378081},
{0.5321806555847479,-0.39188575521169244,-0.7504727208123887},
{0.9164195153613717,-0.237805064112761,-0.32190685507946915},
{0.10090044093589035,0.27580120525390045,-0.9559041773103824},
{-0.03760039461821229,0.1530016057602787,-0.9875103639756552},
{0.04429854924626788,0.010099669241248433,-0.9989672843571471},
{0.04160127634673778,0.2402073696751542,-0.9698297548333245},
{0.08059720453444025,-0.06739766235262125,-0.9944655075620451},
{0.0,0.09809771189755469,-0.9951767877721348},
{0.0,0.17329472325601405,-0.984870011164733},
{0.0,-0.25109055791710094,-0.9679636004131967},
{0.0,-0.42718345123364265,-0.9041649733273868},
{-0.9727969551502956,0.016099949607236593,-0.2310992766603961},
{-0.7524173208460911,-0.6154141669971883,0.23480540528264515},
{-0.9528008146450447,0.3033002593218326,-0.013400011457014693},
{-0.8284941922760681,0.20759854473930206,-0.5200963541373362},
{-0.24699008972147088,-0.9689611212150011,0.010499578712856051},
{-0.6154130222773285,-0.6396135343655822,-0.46060974660535836},
{-0.5578195240250173,0.17900626532893169,-0.810428365489197},
{-0.30060032314552104,-0.9418010124366325,-0.15050016178776088},
{-0.2870986377201961,-0.6847967506471273,-0.6697968218216207},
{-9.999646318764449e-05,0.1391950767572011,-0.9902649749472432},
{-0.00010000135052735837,-0.5537074778699832,-0.8327112458413131},
{0.2868954584808381,-0.6848891582904357,-0.66978939731776},
{0.5578884044100202,0.17899627960099232,-0.8103831563611408},
{0.30060032314552104,-0.9418010124366325,-0.15050016178776088},
{0.6154130222773285,-0.6396135343655822,-0.46060974660535836},
{0.8284941922760681,0.20759854473930206,-0.5200963541373362},
{0.246989829168248,-0.9689600990446652,0.01059956351896125},
{0.9727744698690531,0.016099577472133794,-0.2311939323948654},
{0.9528008146450447,0.3033002593218326,-0.013400011457014693},
{0.7521712337612367,-0.6153764653771139,0.23569098617059756},
{0.3836154945427432,-0.874935339352049,-0.29551193596814546},
{0.6846138293390304,-0.701214164669191,-0.19900401992180403},
{0.2554859678185658,-0.8935509230632892,0.36917972336052635},
{0.6064803655159945,-0.7622753217359316,-0.22609268036795768},
{0.32059588678115875,-0.9146882646248469,-0.24609684259776413},
{-0.011999925840687457,-0.995593847249036,0.09299942526532778},
{-0.16890231228848296,-0.9835134643914919,0.06460088439216104},
{0.0004999766366376421,-0.8338610345842594,-0.551974206847957},
{-0.0006000030570233633,-0.8561043618628356,0.5168026331161236},
{0.16760473238642937,-0.9839277815931255,0.06160173934966616},
{-0.32401095013509285,-0.9125308395008401,-0.24960843565962706},
{-0.26111150221501445,-0.8938393744916886,0.36451605728599296},
{-0.6095043853998295,-0.7600054682590163,-0.22560162320951851},
{-0.6846138293390304,-0.701214164669191,-0.19900401992180403},
{-0.3836154945427432,-0.874935339352049,-0.29551193596814546},
{-0.3314034068445336,-0.723807440778737,-0.6052062215519365},
{0.0003000083568491716,-0.49861388908332327,-0.8668241457228733},
{0.33168655038306744,-0.7238706476403451,-0.6049754687421036},
{0.43480945938268445,-0.4849105493437527,-0.7588165082327069},
{-0.0,0.20380250271010003,-0.9790120223414519},
{0.3396861988301066,0.2593894612202816,-0.9040632686555766},
{0.0010000421176606965,0.04140174367115284,-0.999142079754802},
{0.47770120858558657,0.11770029778213008,-0.8706022026263589},
{0.7694679100099555,0.3195866719157658,-0.5529769385776548},
{0.9017094048781396,0.18680194835448205,-0.389904066720624},
{0.9001593632228002,0.34878425449023853,0.2608882224670391},
{0.8819573098895972,0.179091331293908,0.4359788969522272},
{0.46020184541310016,0.2337009371426369,0.856503434585659},
{0.3996123062504594,0.0760023405281154,0.9135281325320186},
{-9.999774957596842e-05,0.1889957466985803,0.9819779008360098},
{0.0,0.002999986500091125,0.9999955000303749},
{-0.3996062239154066,0.0762011868427277,0.9135142280949048},
{-0.4603879518049498,0.23269391048004306,0.8566775810410524},
{-0.8819192921955274,0.17920392012862968,0.4360095378129606},
{-0.9007318279214693,0.3472122689622895,0.26100922292384093},
{-0.9052823154826989,0.1872963412017116,-0.38129255152275826},
{-0.7746769072255884,0.3167905566142589,-0.5472836857164896},
{-0.4824836199591488,0.11909595676090076,-0.8677705396902576},
{-0.33911333928555637,0.25461001528193056,-0.9056356238779116},
{0.0,-0.24429992915303078,0.9696997187871222},
{-0.4022158697402171,-0.004000157829340796,0.9155361231903748},
{-0.9194609145472662,0.12909451230892013,0.37138421279266415},
{-0.8597690617669584,-0.0011999568203307164,-0.5106816234524142},
{-0.4486151320436101,-0.20570693861206105,-0.8697293364652868},
{0.024500493689921826,-0.2636053117005467,-0.9643194312323109},
{-0.0,-0.357209316140449,-0.9340243596729545},
{0.29001558585638715,-0.5636302903057234,-0.7734415658666546},
{-0.0,-0.8214246225720979,-0.5703170955111607},
{-0.004799720280452845,-0.7825543940588326,0.6225637180437379},
{0.6153789051726899,-0.48058352587909453,-0.6247785829572582},
{0.7288769496309462,-0.5969811207705787,0.33518939980284423},
{0.8719936431895118,-0.4766965248950003,0.11129918863187231},
{0.6611977188718048,-0.3788986928017647,-0.6474977661365601},
{-0.17220243754275524,-0.3554050307938166,-0.9187130044746181},
{-0.24009905641256243,-0.3422986547689301,-0.908396430009045},
{-0.8248012825669916,-0.15970024833407925,-0.5424008434339673},
{-0.8438837089822456,-0.1647968186281243,-0.5105901431524288},
{-0.8874737178550128,-0.33669002907243134,0.31469068057349014},
{-0.955010581575866,-0.18220201880955267,0.2340025927630918},
{-0.3187039423921512,-0.4141051225120484,0.8526105468576973},
{-0.246507408891513,-0.30700922730099184,0.9192276278015366},
{0.3613016132153045,-0.5327023785214301,0.765303417087386},
{0.3198097079710304,-0.3775114595342839,0.8690263796961396},
{-0.006800223254994252,-0.27390899257984197,0.9617315741658783},
{-0.3102013571339062,-0.2240009800064313,-0.9239040420890262},
{0.6143150539748488,0.1921047075835397,-0.7653187543658664},
{0.4838858586424187,0.5839829333481557,-0.6517809519800135},
{0.8089909798008625,0.33889622132819813,-0.48029464474456646},
{0.7265127467779643,0.0075001315909631544,-0.6871120554867712},
{0.40149489703228786,0.18689762454628792,-0.8965886044312559},
{0.6204788854627855,0.33498860053188256,-0.7090758705586803},
{0.6076903955291975,-0.738388329864669,-0.29239537872755855},
{0.44188786813511827,-0.32769100336700213,-0.8350770732736755},
{0.36599981700013723,-0.4723997638001771,-0.8017995991003006},
{0.3765070539257336,-0.824815453062271,-0.4218079026450848},
{0.060597116857768224,-0.7133660588503605,-0.6981667820147488},
{0.2063005580437643,0.22570061052097723,-0.9521025754409499},
{0.03980011362948662,0.0031000088505379027,-0.9992028527282169},
{-0.03139856998469433,-0.28078721183764865,-0.9592563116661551},
{-0.09880239104679535,-0.7946192300180525,-0.5990144963262187},
{9.999663167019232e-05,-0.9943665053283923,-0.10599642957040385},
{0.09889754292106881,-0.7947802539298836,-0.5987851233684126},
{-0.014000124811669047,-0.64160571994049,-0.766906837004928},
{-0.20200361084681615,0.17000303883147894,-0.9645172408997731},
{-0.4807964204839742,-0.230498283946664,-0.8459937016003373},
{-0.37688140701441614,-0.38848083477076323,-0.8408585172683006},
{-0.3760078135235484,-0.8240171232537337,-0.42380880683851013},
{-0.6262001346330434,-0.7193001546495499,-0.30080006467202086},
{-0.4105053427618043,0.19660255879895425,-0.8904115887822425},
{-0.620584373882196,0.33499156501858796,-0.7089821480542652},
{-0.7304884364595756,-0.006999889192631115,-0.682889189949684},
{-0.6036956956650349,0.16289883853542186,-0.780394435807509},
{-0.8109067346083965,0.3463028760573285,-0.47170391751730256},
{-0.47019847420842675,0.5838981052537225,-0.6617978524694531},
{-0.40578387244047837,0.37238519984434243,-0.8346668268261885},
{-0.16759641682691198,0.6479861462042897,-0.7429841151694248},
{-0.05319858014884349,0.5216860763844295,-0.8514772743748164},
{0.00019999545115519465,0.6968841495502757,-0.7171836878425278},
{0.13859689754317234,0.6490854703843663,-0.7479832565822},
{0.40810259145968375,0.4013025482792724,-0.8200052070495972},
{-0.6330915736072324,-0.7244903570975201,-0.27259637176643753},
{-0.017300532345570534,-0.9821302206118395,0.18740576656415714},
{-0.14720672308456842,-0.5731261752701506,-0.8061368171091753},
{0.03590177879769689,-0.7377365520629804,-0.674133400766782},
{0.06409801876085967,-0.9825696292421329,0.1744946064550704},
{0.025300293864619863,-0.6058070364895934,-0.7952092364089216},
{-0.006300136808956226,-0.9998217113641961,0.017800386539590606},
{-0.05580050220677981,-0.5156046404626463,-0.8550076951038841},
{-0.193398998195784,-0.6221967770290424,-0.7585960704825324},
{-0.04790206486300984,-0.9927427931004148,-0.11030475478893496},
{-0.16789626099190108,-0.6121863667614166,-0.7726827925458128},
{-0.23839998808000087,0.1904999904750007,-0.9522999523850035},
{-0.28289881889989665,0.056299764948972014,-0.9574960024625346},
{-0.20100464225581996,0.896020693836889,-0.39590914362725926},
{-0.15999205099241476,0.9823511930934267,-0.09689518588228119},
{0.030400351278088537,0.7123082307691601,0.701208102506437},
{0.047197631446297315,0.5517723100014165,0.8326582140960122},
{0.0982961100084181,-0.29488833002525433,0.9504623861953349},
{0.07589947743389679,-0.48359667044838583,0.8719939963420026},
{-0.10090044093589035,0.27580120525390045,-0.9559041773103824},
{-0.23240406594470087,0.9055158421382384,-0.35500621088798967},
{-0.1996013123829434,0.6605043428303312,0.7238047590319361},
{0.03140060902071799,-0.325506313256169,0.9450183288082326},
{0.7554043813581178,-0.6070035206306295,-0.24680143145245362},
{0.6848121555236418,-0.5065089906143758,0.5239092994725992},
{0.758945105447965,-0.5973355007037416,0.2592154056293484},
{0.3770025711663031,-0.3094021101295867,0.8730059539209086},
{0.16569756592063478,-0.16669755123095847,0.9719857216346229},
{-0.2481101962980296,0.12340507143561812,0.9608394865100639},
{-0.4505059962747159,0.2708036044199624,0.8507113230430651},
{-0.727853248052113,0.4839354035894717,0.4858355425992258},
{-0.8027738540813518,0.5496820971456392,0.23109247344070805},
{-0.7812542471847311,0.5609671479209449,-0.2737839663115057},
{-0.6848121555236418,0.5065089906143758,-0.5239092994725992},
{-0.3770025711663031,0.3094021101295867,-0.8730059539209086},
{-0.16569756592063478,0.16669755123095847,-0.9719857216346229},
{0.2557961311127752,-0.12899804891926506,-0.9580855090662622},
{0.4392110462967233,-0.3025076081620191,-0.8459212751876098},
{0.6825169095659044,-0.5428134483697771,-0.4894121253356097},
{0.5771113951769977,-0.06190122225170016,0.8143160788297163},
{-9.99959812422692e-05,0.2313907005946109,0.9728609015060369},
{-0.00019999848701716857,-0.13899894847693217,0.9902925084655101},
{0.4481788285321984,-0.30318567784685985,0.840960273974964},
{0.4357951932055283,0.34789616272648755,0.8300908441484832},
{0.9107204459035183,0.2035045687288525,0.3594080688017179},
{0.9757985899720562,-0.04589993367464376,0.21379969105966962},
{0.9006861880832079,-0.180297235163098,0.39529393821393594},
{0.5275704542440419,0.20318862073993427,0.8248538053561603},
{0.6895166796102221,-0.3024073153214375,0.6581159200166602},
{0.5455097183421992,0.07640136110237217,0.8346148687963326},
{0.21159191522737578,0.10349604549165119,0.9718628658293313},
{0.24990172307832098,-0.2206015210527315,0.9428065006732333},
{0.4785924430849851,0.6420898614811302,0.5988905435929744},
{0.36008312870024783,0.6622689701143409,0.6570692137432183},
{0.1996013123829434,0.6605043428303312,0.7238047590319361},
{-0.03140060902071799,-0.325506313256169,0.9450183288082326},
{0.3547846434790533,0.7827661187018121,-0.5112778698163472},
{0.23240406594470087,0.9055158421382384,-0.35500621088798967},
{0.0,0.45980918707933766,0.8880177427717526},
{0.0001000058560143534,0.6672390713277658,0.7448436155949041},
{0.20710183389485876,0.6658058957373102,0.7168063473483088},
{0.48149507433058425,0.3185967407720128,0.8164916473331715},
{0.17029409260038977,0.8634700467436088,0.47478353004500917},
{0.7218821155921266,0.6562837407717311,0.2194945620895855},
{0.1160968300193339,0.9847731111372957,0.1293964668777072},
{0.5030074420501581,0.7421109796131656,-0.4430065543304574},
{0.0,0.9996190329275821,-0.027600525519008868},
{0.0,0.7669739655106036,-0.641678218602548},
{-0.503022483092334,0.7420331659135424,-0.4431198056823324},
{-0.1160968300193339,0.9847731111372957,0.1293964668777072},
{-0.7219136406871124,0.656212399250427,0.21960414945960643},
{-0.17020507388888007,0.8635257420860631,0.4747141514397848},
{-0.48149507433058425,0.3185967407720128,0.8164916473331715},
{-0.20700611919132628,0.6658196819207006,0.7168211895475491},
{0.0002999858739977823,0.00969954325926163,-0.999952913325941},
{-0.7046068734735763,-0.24020234318528672,-0.667706513508809},
{-0.9433532485714725,-0.246587779412471,0.22198899849784492},
{-0.6056115491223637,-0.0445008486392754,0.7945151515484113},
{0.0,-0.08729844042729254,0.996182203363904},
{0.605677560062092,-0.044398355071416346,0.7944705654108173},
{0.9435314908890214,-0.2466082306870511,0.22120738291960948},
{0.7044157192121633,-0.2399053535476973,-0.6680149069189737},
{0.8426369040913397,-0.48332116751405707,-0.23741039761605037},
{0.8953372736665702,-0.4267177646303201,0.1276053123197301},
{-0.4135055844306268,-0.3245043824612779,0.8507114889362376},
{-0.9411580158773467,-0.2696879694880157,0.2036909135510152},
{-0.9212952369159376,-0.22079885847285252,0.32009834509583374},
{-0.9117057711157968,-0.21980139134721086,0.3471021971638621},
{-0.4553253418371195,-0.26921498357687806,0.8486472327761468},
{-0.8669032032132538,-0.2258008343356243,0.44440164206710114},
{-0.39770950735941146,-0.22410535730260023,0.8897212690411577},
{0.22248937972293237,-0.1868910789672632,0.9568543256488717},
{0.2532999252765331,-0.15369995465852007,0.9550997182456247},
{0.8221874987341219,-0.05139921848082445,0.5668913804820891},
{0.9221216424489255,-0.03920092005639071,0.3849090339210405},
{0.9182872129395893,0.09799863537850348,-0.38359465848157076},
{0.8580226134839715,0.09250243793387805,-0.5052133150723804},
{0.3310144970973576,0.0929040688227931,-0.9390411262067031},
{0.1615977344156451,0.011799834567479036,-0.9867861653549418},
{-0.8081117904370344,-0.055500809762721696,-0.5864085557632434},
{-0.7846186584535497,-0.11180265869883617,-0.6098145015612728},
{0.02050040642458609,-0.2863056760662926,0.9579189909322448},
{0.23019653096441736,-0.14889775612772263,0.961685507508602},
{0.21008681326458406,-0.2176863362574962,0.9531401732689269},
{0.9295363734699548,-0.019500763079789263,0.36821440851171316},
{0.8769108606082634,0.05990074187528222,-0.47690590651622855},
{0.2087905587043983,-0.0029998643492011247,-0.9779557778395667},
{-0.778099354177804,-0.12189989882312595,-0.6161994885546367},
{0.4319061633449267,-0.003200045664977461,0.9019128703884913},
{0.9295211468466389,0.05390122626684652,0.36480829948322097},
{0.9661924009266499,0.10649916238738172,0.23479815331978618},
{0.840815433308919,0.0036000660798193485,-0.5413099358350593},
{0.23369001931240818,-0.2761882042536891,-0.9322601840177928},
{-0.7220727458785504,-0.21919172676440696,-0.6561752331332292},
{-0.2868962388149635,-0.570592519581102,-0.7694899120533789},
{-0.023898945960232128,-0.2627884099727616,-0.9645574591313769},
{0.449010551871955,-0.19840466256435604,-0.8712204739217085},
{-0.0,-0.039400925932639254,0.9992234820277447},
{-0.0,0.3259906833194042,0.9453729816262721},
{-0.3705011948682802,0.25090080915641433,0.894302884131452},
{-0.5542094493516678,-0.0801013657399289,0.8285141262862807},
{-0.8267296263870019,0.09900354785570725,0.5538198464898048},
{-0.9243932103568049,-0.14379894380063668,0.35329740504009},
{-0.9873947618846823,-0.06039967958054974,-0.14629922388467595},
{-0.8696449574581437,-0.20141041218039343,-0.45072330074331346},
{-0.6189029769304786,0.05690027369097468,-0.7834037681811875},
{-0.44278719477948786,-0.19939423360214514,-0.8741747192326744},
{0.0002000104208143937,0.12100630459270818,-0.992651718501836},
{9.999927300792783e-05,-0.2076984900374661,-0.97819288856355},
{0.44279602149562025,-0.19929820931363396,-0.87419214541886},
{0.6187204861744514,0.05720189398606534,-0.7835259429734648},
{0.869537960508267,-0.2012087839611999,-0.45101968969433975},
{0.9873658525424746,-0.060397911174362426,-0.1464949335603327},
{0.9243932103568049,-0.14379894380063668,0.35329740504009},
{0.8267296263870019,0.09900354785570725,0.5538198464898048},
{0.5541679700169728,-0.07999537640086218,0.82855211107193},
{0.3704149169090619,0.2509101043533576,0.8943360156365391},
{0.0001000034451780306,-0.5065174498267249,-0.8622297043249797},
{0.5027837578330506,-0.4313860642982857,-0.7490758014970927},
{0.9335442977279157,-0.32661549827309827,-0.14770700886385982},
{0.7739753067117527,-0.32908950056697395,0.5409827402210056},
{0.3375054845086853,-0.36300589889378587,0.8685141134690167},
{-0.0,-0.386084661161112,0.9224633512590672},
{-0.3374932316411085,-0.36309271824855255,0.8684825827564526},
{-0.7739097319760698,-0.32920413976808655,0.5410068032033257},
{-0.9335275861477621,-0.326709654412934,-0.14760436177333658},
{-0.5030085084608815,-0.4314072973161517,-0.7489126679649188},
{0.5684958784198222,0.25399815852002605,0.7824943269366945},
{0.4534978526927512,-0.22989891143123153,0.8610959227204589},
{0.9600796321266545,-0.21989533496995242,0.17289633204322316},
{0.9151925457870717,0.3221973757130621,0.24209802811959139},
{0.7024162927348672,0.5879136368149607,0.4012093061577857},
{0.3986070992556572,0.5641100468894035,0.7231128787550569},
{-0.14480188822893386,0.5968077824242245,0.7892102913692997},
{-0.22190202597474573,0.06780061902247753,0.9727088808726237},
{-0.843263141773592,0.3376852401007257,0.41818172167640955},
{-0.5876002321021375,0.7639003017406788,0.2668001053860624},
{-0.7744208128390213,0.48251296771026314,-0.4092109976933465},
{-0.47538566971497637,0.8367747758045693,-0.27169180997383063},
{-0.06960022132905573,0.5202016542438908,-0.8512027068289115},
{0.05080186344652745,0.8974329184431838,-0.4382160740604002},
{0.7949091852287034,0.4328050010906816,-0.42520491327115945},
{0.6192077215684322,0.7821097529694296,-0.06990087166930462},
{-0.22248937972293237,-0.1868910789672632,0.9568543256488717},
{-0.820377567082138,-0.14819594763721705,0.5522848979759445},
{-0.9341930449586703,-0.0354997357054515,-0.354997357054515},
{-0.3188060127381009,0.0020000377210671327,-0.947817876013714},
{0.6511985869005996,-0.0852998148996025,-0.7540983636083264},
{-0.7024162927348672,0.5879136368149607,0.4012093061577857},
{-0.6192077215684322,0.7821097529694296,-0.06990087166930462},
{-0.9151925457870717,0.3221973757130621,0.24209802811959139},
{-0.7949091852287034,0.4328050010906816,-0.42520491327115945},
{-0.05080186344652745,0.8974329184431838,-0.4382160740604002},
{0.06960022132905573,0.5202016542438908,-0.8512027068289115},
{0.47538566971497637,0.8367747758045693,-0.27169180997383063},
{0.7744208128390213,0.48251296771026314,-0.4092109976933465},
{0.5876002321021375,0.7639003017406788,0.2668001053860624},
{0.843263141773592,0.3376852401007257,0.41818172167640955},
{0.14480188822893386,0.5968077824242245,0.7892102913692997},
{0.22190202597474573,0.06780061902247753,0.9727088808726237},
{-0.5684958784198222,0.25399815852002605,0.7824943269366945},
{-0.3986070992556572,0.5641100468894035,0.7231128787550569},
{-0.9600796321266545,-0.21989533496995242,0.17289633204322316},
{-0.4534978526927512,-0.22989891143123153,0.8610959227204589},
{0.820377567082138,-0.14819594763721705,0.5522848979759445},
{0.9341930449586703,-0.0354997357054515,-0.354997357054515},
{0.3188060127381009,0.0020000377210671327,-0.947817876013714},
{-0.6511985869005996,-0.0852998148996025,-0.7540983636083264},
{-0.031699721994657155,-0.8350926762693435,-0.5491951835793599},
{0.10689714534984963,-0.9833737393549311,0.1467960798630302},
{-0.19640521266351704,-0.6886182761715777,-0.6980185256575097},
{0.21030593596881525,0.2545071835666357,-0.9439266427054909},
{0.048797559207131164,0.21878905644508806,-0.9745512541653695},
{0.15470285119982166,-0.7848144642638659,-0.6001110601487587},
{-0.024800376348566654,0.6850103951116193,-0.7281110491690073},
{0.02010074565099014,-0.4316160110929027,-0.9018334541324831},
{0.20219464090206335,0.6590825312490107,-0.724380800541319},
{0.4401109456953309,0.5969148454568121,-0.6708166834183775},
{-0.15929424798855582,-0.7582726192700684,-0.6321771724944444},
{0.6832776947637257,0.4883840569626864,-0.5427822811616424},
{-0.3689083632473933,-0.5707129382089654,-0.7336166312775487},
{0.4922179810512777,-0.310711350492954,-0.8131297041706499},
{-0.1726034477883047,-0.9225184274896354,-0.3452068955766094},
{0.5715956758950678,-0.3868970731347126,0.7235945260281159},
{-0.5056712028449736,-0.8170534701297765,0.2769842261974643},
{-0.4224974882598984,-0.6409961892889819,0.6407961904779714},
{0.3780121835290159,0.2423078097065623,0.8935287988972902},
{-0.13420115614794034,-0.5372046280378059,0.8327071738032036},
{0.5038921343051748,0.5800909448510257,0.6399900098339192},
{0.36668303396851837,0.929756981139701,-0.03309846856928813},
{0.16440730888937866,-0.9863438488904754,-0.009800435688052986},
{-0.04870039277025155,-0.6727054253911338,-0.7383059544615342},
{0.4754958275424198,0.756093365309829,-0.44969605393443995},
{0.594290702394691,0.42659332599962163,-0.6817893334893156},
{-0.39019550302274136,-0.5609935345867707,-0.7300915857429612},
{0.5015992551256593,-0.20849969037818966,-0.8395987531967772},
{-0.06530115910586129,-0.9104161600302622,-0.4085072510680603},
{0.7096669231955469,-0.3476837948359753,0.6127714393887997},
{-0.45669900211377057,-0.8377981694129998,0.2991993462501427},
{-0.4207879719477304,-0.6241821580080164,0.6582811833013092},
{0.48501479317679125,0.46181408554441694,0.7426226503362582},
{-0.11729935426883213,-0.48359733780398306,0.8673952250024295},
{0.33148664467212385,0.5942760570999795,0.7327704772721941},
{0.2438970427662846,-0.9697882413888593,0.004999939376102595},
{0.014599932402469462,-0.6930967909692867,-0.7206966631821741},
{0.45009891526292134,0.7858981059878469,-0.423998978163694},
{0.5759135283676738,0.4770112051248141,-0.6639155955605118},
{-0.2877029259536355,-0.6159062637985544,-0.7334074587917842},
{0.5631962941805764,-0.14559904196145584,-0.8133946478808254},
{0.12530542521582963,-0.8924386389673292,-0.4334187652716725},
{0.7612703338731223,-0.16769346511299435,0.6263755906188412},
{-0.32728651116440777,-0.9032627727919632,0.27748856354452545},
{-0.3760131569305455,-0.6441225382419264,0.6661233080623308},
{0.36621113115649984,0.5461165994663151,0.7534229006371026},
{-0.17070595262035362,-0.47561658503948556,0.8629300908969135},
{0.23248715543948312,0.6094663279155482,0.7579581239704439},
{0.29199797938097394,0.9549933914685963,0.05219963877974946},
{0.2768995209642431,-0.9607983378203133,0.0138999759530624},
{0.1341967464393234,-0.5777859917484429,-0.8050804810603521},
{0.4000990117566614,0.8677978565419414,-0.2946992720936969},
{0.5031059542942039,0.5364063484067003,-0.6776080195383671},
{0.061298256089421035,-0.3784892321345165,-0.9235737247012931},
{0.9212353346589043,0.08130311844091284,-0.38041459108146675},
{0.08319552669679103,-0.8428546809221774,-0.5316714127966802},
{0.25049868363287625,-0.920495162810629,0.2998984240379225},
{0.32868660629368474,-0.12699482506631568,0.9358618644060224},
{-0.37200241616353946,-0.8726056675922166,0.31650205568752754},
{0.285904016979658,0.6178086802729371,0.7325102918419011},
{-0.18099477566119973,-0.6571810307433175,0.7316788803939218},
{0.062398071617394524,0.5025844678670272,0.8622733518538349},
{0.06489900997315423,-0.5756912178974559,0.8150875659340218},
{0.8056829076184204,-0.5614880881565634,0.1886959968568896},
{-0.05319969543261547,0.2514985601748645,0.9663944674075111},
{-0.3158998088806734,-0.4437997315012436,0.8385994926474604},
{-0.1437945186574212,-0.9773627436423051,-0.15519408411426822},
{0.40489176863401466,-0.9003816954261962,-0.15929676152975683},
{-0.09700225581368872,-0.9607223418578429,-0.26000604651091824},
{-0.47227830639423224,-0.018299159447415732,0.8812595202736331},
{-0.4043053247361904,0.030600403009961478,0.9141120389348297},
{-0.15320742001503135,-0.8397406696254688,-0.5209252290197769},
{0.8751064670606875,0.0980007242280281,-0.4739035021598215},
{-0.3845852533611844,-0.12069537202468789,0.9151649086743525},
{-0.13600501527740924,-0.9305343140855095,-0.3400125381935231},
{0.6410084485470282,0.23080304200414056,-0.7320096479507404},
{0.6498625137620593,0.39497721639638933,-0.6493625426020638},
{0.10269926775683132,-0.6900950796396231,0.7163948921226286},
{0.23380634559033017,-0.9718263757257607,0.0298008088049266},
{0.7940109177251786,-0.5625077345345251,-0.23050316944036986},
{0.6531874262630656,0.4744908661387394,0.5900886409029928},
{0.3720141888917516,-0.8726332828681249,0.3164120681864253},
{-0.285904016979658,0.6178086802729371,0.7325102918419011},
{-0.32868660629368474,-0.12699482506631568,0.9358618644060224},
{-0.25049868363287625,-0.920495162810629,0.2998984240379225},
{-0.9212353346589043,0.08130311844091284,-0.38041459108146675},
{-0.08319552669679103,-0.8428546809221774,-0.5316714127966802},
{-0.061298256089421035,-0.3784892321345165,-0.9235737247012931},
{-0.5031059542942039,0.5364063484067003,-0.6776080195383671},
{-0.1341967464393234,-0.5777859917484429,-0.8050804810603521},
{-0.4000990117566614,0.8677978565419414,-0.2946992720936969},
{-0.29199797938097394,0.9549933914685963,0.05219963877974946},
{-0.2768995209642431,-0.9607983378203133,0.0138999759530624},
{0.17070595262035362,-0.47561658503948556,0.8629300908969135},
{-0.23248715543948312,0.6094663279155482,0.7579581239704439},
{-0.36621113115649984,0.5461165994663151,0.7534229006371026},
{0.3760131569305455,-0.6441225382419264,0.6661233080623308},
{-0.7612703338731223,-0.16769346511299435,0.6263755906188412},
{0.32728651116440777,-0.9032627727919632,0.27748856354452545},
{-0.12530542521582963,-0.8924386389673292,-0.4334187652716725},
{-0.5631962941805764,-0.14559904196145584,-0.8133946478808254},
{0.2877029259536355,-0.6159062637985544,-0.7334074587917842},
{-0.5759135283676738,0.4770112051248141,-0.6639155955605118},
{-0.014599932402469462,-0.6930967909692867,-0.7206966631821741},
{-0.45009891526292134,0.7858981059878469,-0.423998978163694},
{-0.36668303396851837,0.929756981139701,-0.03309846856928813},
{-0.2438970427662846,-0.9697882413888593,0.004999939376102595},
{0.11729935426883213,-0.48359733780398306,0.8673952250024295},
{-0.33148664467212385,0.5942760570999795,0.7327704772721941},
{-0.48501479317679125,0.46181408554441694,0.7426226503362582},
{0.4207879719477304,-0.6241821580080164,0.6582811833013092},
{-0.7096669231955469,-0.3476837948359753,0.6127714393887997},
{0.45669900211377057,-0.8377981694129998,0.2991993462501427},
{0.06530115910586129,-0.9104161600302622,-0.4085072510680603},
{-0.5015992551256593,-0.20849969037818966,-0.8395987531967772},
{0.39019550302274136,-0.5609935345867707,-0.7300915857429612},
{-0.594290702394691,0.42659332599962163,-0.6817893334893156},
{0.04870039277025155,-0.6727054253911338,-0.7383059544615342},
{-0.4754958275424198,0.756093365309829,-0.44969605393443995},
{-0.16440730888937866,-0.9863438488904754,-0.009800435688052986},
{0.13420115614794034,-0.5372046280378059,0.8327071738032036},
{-0.5038921343051748,0.5800909448510257,0.6399900098339192},
{-0.3780213417972938,0.24221367455900678,0.8935504468145026},
{0.4224974882598984,-0.6409961892889819,0.6407961904779714},
{-0.5715956758950678,-0.3868970731347126,0.7235945260281159},
{0.5056712028449736,-0.8170534701297765,0.2769842261974643},
{0.1726034477883047,-0.9225184274896354,-0.3452068955766094},
{-0.4922179810512777,-0.310711350492954,-0.8131297041706499},
{0.3689083632473933,-0.5707129382089654,-0.7336166312775487},
{-0.6832776947637257,0.4883840569626864,-0.5427822811616424},
{0.15929424798855582,-0.7582726192700684,-0.6321771724944444},
{-0.4401109456953309,0.5969148454568121,-0.6708166834183775},
{-0.02010074565099014,-0.4316160110929027,-0.9018334541324831},
{-0.20219464090206335,0.6590825312490107,-0.724380800541319},
{0.024800376348566654,0.6850103951116193,-0.7281110491690073},
{-0.15470285119982166,-0.7848144642638659,-0.6001110601487587},
{-0.048797559207131164,0.21878905644508806,-0.9745512541653695},
{0.031699721994657155,-0.8350926762693435,-0.5491951835793599},
{-0.21030593596881525,0.2545071835666357,-0.9439266427054909},
{0.19640521266351704,-0.6886182761715777,-0.6980185256575097},
{-0.10689714534984963,-0.9833737393549311,0.1467960798630302},
{0.3158998088806734,-0.4437997315012436,0.8385994926474604},
{-0.09079998683400287,-0.382699944508512,0.9193998666870289},
{0.18099477566119973,-0.6571810307433175,0.7316788803939218},
{-0.06489900997315423,-0.5756912178974559,0.8150875659340218},
{-0.8056829076184204,-0.5614880881565634,0.1886959968568896},
{-0.40489176863401466,-0.9003816954261962,-0.15929676152975683},
{0.09700225581368872,-0.9607223418578429,-0.26000604651091824},
{0.1437945186574212,-0.9773627436423051,-0.15519408411426822},
{0.15320742001503135,-0.8397406696254688,-0.5209252290197769},
{-0.6498625137620593,0.39497721639638933,-0.6493625426020638},
{-0.8751064670606875,0.0980007242280281,-0.4739035021598215},
{-0.6410084485470282,0.23080304200414056,-0.7320096479507404},
{0.13600501527740924,-0.9305343140855095,-0.3400125381935231},
{0.3845852533611844,-0.12069537202468789,0.9151649086743525},
{0.4043053247361904,0.030600403009961478,0.9141120389348297},
{0.47227830639423224,-0.018299159447415732,0.8812595202736331},
{-0.7940292168425604,-0.5625206983298995,-0.23040847803592684},
{-0.23380634559033017,-0.9718263757257607,0.0298008088049266},
{-0.10269926775683132,-0.6900950796396231,0.7163948921226286},
{-0.6531874262630656,0.4744908661387394,0.5900886409029928},
{-0.6739819105682773,0.037798985488844035,-0.7377801982452151},
{-0.49599005549907993,-0.008899821560366556,-0.8682825911085708},
{-0.9374380607579158,0.009800397904232531,-0.3480141296605021},
{-0.9456295324714558,0.08730272650672387,-0.31330978481737215},
{-0.8899715747618459,0.1031967039499129,-0.44418581293169873},
{-0.8866007536109609,-0.005700004845006178,-0.46250039312550123},
{-0.9491347626972874,0.1087039813562271,-0.29551082328210765},
{-0.9656804258561499,0.01819963109721645,-0.25909474820268036},
{-0.9990750484122449,0.010499737772323664,0.04169895858151398},
{-0.9949666194298677,0.004699842322935054,0.10009664181399976},
{-0.9247776900073397,0.003599913153142758,0.3804908207696721},
{-0.8078246551847201,0.002400073251353464,0.589417989311555},
{-0.4244267121357188,0.003100195116919718,0.9054569867287461},
{0.04879980772913632,0.004999980300116426,0.9987960647512573},
{0.274100313845039,-0.00010000011450019666,0.9617011011483912},
{0.6550988535780093,-0.00819998565003767,0.7554986778784705},
{0.813565684523125,-0.018599215501634864,0.5811754865349561},
{0.940817833371049,0.10070190882277277,0.32360613401240584},
{0.9438809196400623,-0.016099674548368473,0.32989333127371184},
{0.9691299223482859,0.013000401393589637,0.24620760177705914},
{0.9583695962068328,0.13649566974356497,0.25079204374861613},
{0.9569834060516074,0.014199753778404206,0.28979497499869994},
{0.9323119663008818,0.06800087279680356,0.3552045590797739},
{0.9824274887057064,0.012800358159032006,-0.1862052100946687},
{0.9206756806730882,-0.0054998547232562025,-0.39028969063398106},
{0.320499280479923,0.02179995105916481,-0.9469978739921594},
{0.32068980062308416,0.05859813631591124,-0.9453699329874143},
{-0.8258843991910475,0.06909869473798447,-0.5595894294555154},
{-0.8748124880374007,0.4580065380899972,0.1579022540707654},
{-0.7925009708142838,0.6067007432088657,-0.06210007607263979},
{-0.711721206049256,0.7024209289433715,0.007600226452120762},
{-0.1268954565895138,0.933566574247203,0.33518799880855016},
{-0.1780018138477247,0.802908181676057,0.56890579717961},
{0.6413947373777696,0.608095010600907,0.46779616174823924},
{0.5529124047289516,0.7306163915626191,0.4006089877634618},
{0.5877875125869413,0.40579137905372703,0.6998851310983331},
{0.998299066590809,0.022699978775529768,0.05369994979057042},
{-0.23691403164904895,0.639537877752498,0.7313433150905423},
{0.7925009708142838,0.6067007432088657,-0.06210007607263979},
{0.711721206049256,0.7024209289433715,0.007600226452120762},
{0.9491347626972874,0.1087039813562271,-0.29551082328210765},
{0.8899715747618459,0.1031967039499129,-0.44418581293169873},
{0.8866007536109609,-0.005700004845006178,-0.46250039312550123},
{0.9656804258561499,0.01819963109721645,-0.25909474820268036},
{0.9990750484122449,0.010499737772323664,0.04169895858151398},
{0.9949666194298677,0.004699842322935054,0.10009664181399976},
{0.9247776900073397,0.003599913153142758,0.3804908207696721},
{0.8078246551847201,0.002400073251353464,0.589417989311555},
{0.424186585311356,0.00249992094125033,0.9055713617585195},
{-0.04879980772913632,0.004999980300116426,0.9987960647512573},
{-0.274100313845039,-0.00010000011450019666,0.9617011011483912},
{-0.6550988535780093,-0.00819998565003767,0.7554986778784705},
{-0.813565684523125,-0.018599215501634864,0.5811754865349561},
{-0.940817833371049,0.10070190882277277,0.32360613401240584},
{-0.9438809196400623,-0.016099674548368473,0.32989333127371184},
{-0.9691299223482859,0.013000401393589637,0.24620760177705914},
{-0.9583695962068328,0.13649566974356497,0.25079204374861613},
{-0.6413947373777696,0.608095010600907,0.46779616174823924},
{-0.5528902526307684,0.7305871198626144,0.40069293584581106},
{0.1268954565895138,0.933566574247203,0.33518799880855016},
{0.1780018138477247,0.802908181676057,0.56890579717961},
{-0.5877875125869413,0.40579137905372703,0.6998851310983331},
{0.23691403164904895,0.639537877752498,0.7313433150905423},
{0.8748124880374007,0.4580065380899972,0.1579022540707654},
{0.9456295324714558,0.08730272650672387,-0.31330978481737215},
{0.9374380607579158,0.009800397904232531,-0.3480141296605021},
{-0.9323119663008818,0.06800087279680356,0.3552045590797739},
{-0.998299066590809,0.022699978775529768,0.05369994979057042},
{-0.9824274887057064,0.012800358159032006,-0.1862052100946687},
{-0.32068980062308416,0.05859813631591124,-0.9453699329874143},
{-0.320499280479923,0.02179995105916481,-0.9469978739921594},
{0.6739819105682773,0.037798985488844035,-0.7377801982452151},
{0.8258843991910475,0.06909869473798447,-0.5595894294555154},
{0.49599005549907993,-0.008899821560366556,-0.8682825911085708},
{-0.5489048605740606,-0.7868069672065421,0.28220249891419186},
{-0.42361143554505587,-0.6008162192527611,-0.6779183006515425},
{-0.5352735072933685,-0.7626622529659111,-0.363082029699649},
{-0.09149928859579674,-0.12369903824371647,-0.9880923176120957},
{0.1328966789534889,0.19689507965343842,-0.9713757256239213},
{0.4508903262518243,0.6490860740076716,-0.6126868549445392},
{0.5489048605740606,0.7868069672065421,-0.28220249891419186},
{0.5352735072933685,0.7626622529659111,0.363082029699649},
{0.42361143554505587,0.6008162192527611,0.6779183006515425},
{0.09149928859579674,0.12369903824371647,0.9880923176120957},
{-0.1328966789534889,-0.19689507965343842,0.9713757256239213},
{-0.4508903262518243,-0.6490860740076716,0.6126868549445392},
{0.4553253418371195,-0.26921498357687806,0.8486472327761468},
{0.39770950735941146,-0.22410535730260023,0.8897212690411577},
{0.8669032032132538,-0.2258008343356243,0.44440164206710114},
{0.9117057711157968,-0.21980139134721086,0.3471021971638621},
{0.380105462154737,-0.2826040610495361,0.8807126559317993},
{0.9212952369159376,-0.22079885847285252,0.32009834509583374},
{-0.21180346513303455,-0.1820029775930703,0.9602157092575062},
{-0.9227843312550817,-0.023599599282206254,0.3845934696583273},
{-0.9219352877484708,0.010000382771976036,0.3872148209309121},
{-0.8585377292695374,0.1019044782906999,-0.5025220838182207},
{-0.8503397032876413,0.09370437515941668,-0.5178241777753038},
{-0.1450054631837401,0.0702026449344728,-0.9869371835588491},
{-0.1808025945358475,0.034500495085656745,-0.9829141049186091},
{0.7728370275090032,-0.07850376120530117,-0.6297301710952631},
{0.7410193964365559,-0.11640304688962902,-0.6613173102071449},
{0.8081117904370344,-0.055500809762721696,-0.5864085557632434},
{-0.5594125505613593,-0.20390457465044898,0.8034180248855847},
{-0.8750972915780738,-0.47629852585834365,0.08569973475973137},
{-0.572674055589604,-0.8133631514171188,0.10239536108324682},
{-0.8366330141901228,-0.05060199679419102,0.5454215227579404},
{-0.42709558812536186,0.6519932649443595,0.6264935283552779},
{0.01860005384723383,0.5040014590863361,0.8635024998433556},
{-0.8275806307020049,0.4970883657829467,0.26079389619028864},
{-0.2772087682520119,0.9097287751762455,-0.3091097772968863},
{0.21329718662866246,0.9769871136249565,0.000699990767182671},
{-0.6738364487992999,0.5967322781219091,-0.43572356892528197},
{-0.2520090107432716,0.27430980812253725,-0.9280331824196668},
{0.22741155507467747,0.5139261132492382,-0.8271420281542029},
{-0.7624044753274053,0.06010035279010632,-0.6443037820743013},
{-0.44350949563995357,-0.5467117052229146,-0.7102152058703384},
{0.1271068270910295,-0.4659250255051978,-0.8756470322651884},
{-0.8440656556671922,-0.3255867521445774,-0.4260826630491536},
{0.9117004102652769,0.40110018049512186,0.08900004005002703},
{0.9140862613867362,0.19529706470717598,-0.3553946584584247},
{0.9004942593673946,0.41789733591297523,-0.12029923309483351},
{0.9319920548015991,0.0076999343583393914,-0.3623969105795059},
{0.9059658230839741,-0.29628882271499063,-0.3023885926055119},
{0.875300407014784,-0.44370020632064394,-0.1923000894195624},
{0.8298947799782509,-0.5520965273237647,0.08039949428877138},
{0.7998087139634082,-0.5424059095445769,0.2571028011502779},
{0.7683911405012247,-0.251497100255151,0.5884932147123513},
{0.7779515117933578,-0.088494484310684,0.6220612281319381},
{0.8053168715651908,0.18750392824844564,0.5624117826502711},
{0.8873733614515278,0.2347929516213869,0.3967880886003676},
{0.8389243207685937,-0.5440157712458159,-0.01590046096104499},
{-0.40160862262969277,-0.6385137090365011,0.6565140955089475},
{-0.42479411876613826,-0.8471882707595864,-0.3190955821522474},
{-0.45768190819174664,-0.781569105183896,0.423883244226527},
{-0.22779174953224524,-0.8233701780722157,-0.5197811738668178},
{0.020400036618098596,-0.2320004164411213,-0.9725017456422002},
{0.24559981825620175,-0.043399967884035655,-0.9683992833847955},
{0.461710559441243,0.6184141432931874,-0.6359145435319178},
{0.4706781280955693,0.7662643925210001,-0.4373796754387126},
{0.4536693942266929,0.8317438882913007,0.31997841338448696},
{0.2410023039930393,0.8138077800395659,0.5288050554004946},
{0.015499682492256184,0.21459560405407596,0.9765799949637026},
{-0.23318635433380488,0.03659785835599168,0.9717431352555386},
{-0.5462004233054921,-0.009500007362508557,0.8376006491407546},
{-0.49001087591208764,-0.8360185556377658,0.24690548012794786},
{-0.7500334822419876,-0.19360864288273175,0.632428232226444},
{-0.42220020898915517,-0.9051004480248326,0.05040002494801852},
{0.029100971843182326,-0.8388280131292555,-0.5436181544314058},
{0.5482122992809031,-0.02950066185477315,-0.8358187518040474},
{0.5169160298146307,0.8106251378752943,-0.2751085312478331},
{-0.04299931803622387,0.8243869253270457,0.5643910488289479},
{-0.32430419328032883,0.7357095127855009,0.5946076883271154},
{0.33101389459984487,-0.7528316007696774,-0.568923881081123},
{0.7603293264676937,0.0889034290713902,-0.6434248173738184},
{0.42690706323579236,0.9033149454694102,-0.04210069656178697},
{-0.34871235684130086,-0.6512230764985808,-0.6740238844595262},
{0.05309851034218824,-0.9910721958595623,-0.12229656901788365},
{-0.798305053286981,-0.5322033688579872,0.28190178444394326},
{-0.6466859864665083,-0.06379861749893803,-0.7600835291683824},
{-0.6933806930833979,-0.16979527211647097,0.7002805009609224},
{-0.8821190495665653,0.3646078737920527,0.2982064398376032},
{-0.2883138999481828,0.5837281422121204,-0.759036594036319},
{0.03880169101454243,0.9896431295874016,-0.13820602314973615},
{0.26839581171603705,0.6128904359193706,-0.7431884026354646},
{0.6879345523806117,0.5895296098682521,-0.4233212618443276},
{0.359611721735108,0.3147102581480492,0.8784286328479392},
{0.9751890925709992,-0.005799935128088387,-0.2212975248010276},
{0.4375972409580936,-0.16769894266149976,0.8833944302156762},
{0.3274086993647148,-0.48831297464810697,0.8089214933296205},
{0.7162975538480304,-0.6166978939802881,-0.3264988850082115},
{0.2997983601074553,-0.36189802042324243,-0.8826951716706165},
{0.33500297316458033,0.1518013472429352,-0.9299082529723678},
{0.37539540894222284,-0.13009840890618857,0.9176887767348905},
{0.22869922814140753,-0.4904983445708806,0.8408971619768675},
{0.24309715456445868,-0.6343925744783734,0.7337914110218008},
{0.4776905967531535,-0.3467931734435705,0.8071841107371688},
{0.6999780700305935,0.3570888125827499,0.618480623305603},
{0.3882924244886966,0.3966922606094926,0.8317837720569092},
{0.6037737967858169,0.6593713839028944,0.4479805580656608},
{0.6588084822138132,0.608407833301281,0.44250569729752925},
{0.4517938533864368,0.6458912127098264,0.6153916276538584},
{0.5953097066038999,0.5511089859052734,0.5847095337666727},
{0.5107158247749998,0.857326564675166,0.06450199862539159},
{0.11350446138053358,0.9883388474218618,0.10150398969272385},
{0.2503079236227354,0.8642273575500117,0.4364138148979694},
{0.021400525496355422,0.9213226233547781,0.388209532602111},
{-0.07419715644846762,0.9725627272477035,0.2204915498232764},
{-0.1782009052628981,0.9818049875820055,0.06560033325053938},
{-0.19880248902274394,0.8754109602138331,0.4406055164155985},
{-0.6442923684020941,0.5805931229151884,0.49779410366376303},
{-0.5327755754636015,0.8455612361336738,-0.034298427624627495},
{-0.6808074174372196,0.6014065523600822,0.41810455527394474},
{-0.44612105294924476,0.6840322802449752,0.5771272352768642},
{-0.5977039030192302,0.6857044776648588,0.41540271258856987},
{-0.7357009784829521,0.30210040179380154,0.6062008062476084},
{-0.3509844622617759,0.2664882028283854,0.8976602614598183},
{-0.40718074691356254,-0.301185758768087,0.8622592290362596},
{-0.4643042785836408,-0.4808044306332425,0.7438068542117425},
{-0.1486992342009158,-0.8030958640669501,0.576997028472955},
{-0.17870838340690304,-0.48802289369092716,0.8543400780331128},
{0.04530186874062912,0.062102561783511444,0.9970411287948616},
{-0.00870015577768381,-0.7865140826607261,0.6175110566344545},
{0.14790475817260684,0.9133293822788494,0.37941220588699826},
{0.01119985613877184,0.8175894981303443,0.5756926052759775},
{-0.13220304334908725,0.843619420342587,0.5204119800216717},
{-0.0001000035271866069,0.8807310639324469,-0.4736167047557703},
{-0.13640480085145043,0.9329328351489597,-0.3332117275931326},
{-0.2702960131632085,0.7953882681095674,-0.5424919983020371},
{-0.4561026157560021,0.8234047222396231,-0.33760193615265577},
{-0.7174089246225338,0.593007377057656,-0.36560454814886856},
{-0.8319602956423131,0.5098756667644417,-0.2187895585174737},
{-0.5592861885981067,0.7360818226838304,-0.38129058414528527},
{-0.8759282184820949,0.4824155412669969,-0.005000161082783964},
{-0.3670896592299472,0.8207768790409715,0.43768767051198004},
{0.09889739408799822,0.9244756403878095,-0.3681902983134575},
{-0.0002999891480888483,0.9404659792585395,-0.3398877047846651},
{-0.0878988617171111,0.9834872639223978,-0.15819795134979495},
{-0.3680958755088222,0.9007899067056427,-0.23039741841138994},
{-0.7658831086343066,-0.2100953663977906,0.6076865976198828},
{-0.3548132188127049,-0.7911294740775954,0.4982185614782682},
{-0.9784841731464979,0.05029918641723949,0.20009676346102628},
{-0.9379941000356661,0.3282979350124831,0.11129929992960516},
{-0.9508975561964209,0.30129922566198514,0.07079981804470145},
{-0.9835664757080035,0.0384986877945894,-0.17639398771339143},
{-0.9207069007240815,0.17740132962794836,-0.34760260529129006},
{-0.9348302469219666,-0.12880416752626156,-0.3309107067891301},
{-0.6852189225818243,-0.6757186602284568,-0.27180750606792153},
{-0.5671035529148886,-0.8115050840952778,-0.1409008827467956},
{-0.7621850727515238,-0.37569264213165504,-0.527189675091319},
{-0.8838689148768861,0.022699201683114963,-0.467183569442789},
{-0.542422291302101,-0.8386344643914858,0.04970204254740859},
{-0.8766052333488646,-0.3201019110141131,-0.3593021450402088},
{-0.7609859447194003,0.22449585359987564,-0.6086887576224691},
{-0.7106060899202861,-0.6913059245171598,-0.13090112182742109},
{-0.9531830239615133,-0.2956947337236881,0.06329887265711685},
{-0.9584218858136467,-0.2764063118101961,0.07090161905695697},
{-0.9926610735592356,-0.0766969923864142,0.09349633361316463},
{-0.7191966485514266,-0.560797386690267,0.4101980884813616},
{-0.8743525326894654,-0.35008099461868925,-0.33608175461679934},
{0.0011000298607158592,-0.9619261118387136,-0.27330741903058575},
{-0.7280918927419112,-0.682892396035505,0.05949933747856574},
{-0.9344516667375247,0.3501818873103062,0.06459665882423124},
{-0.719365363391609,0.6064707991340157,-0.33868369277278004},
{0.0009000230138827012,0.9991255479668965,0.04180106886699657},
{0.0009999570027733012,0.8997613110954166,-0.4363812360102687},
{0.7205744128568912,0.6054784998401993,-0.3378880018100798},
{0.9346278476515874,0.3497104197771882,0.06460192484302649},
{0.8749178047584921,-0.3495071125421111,-0.33520682152822784},
{0.7291079108637495,-0.681807397650397,0.059500645585506926},
{0.0010000436528581917,-0.9987435961094759,0.050102187008195395},
{0.0010999517461753197,0.02619885068163034,-0.9996561460467883},
{-0.3682013163220588,-0.7000025025134197,-0.6119021875542308},
{-0.7495765948362337,-0.658979423688738,0.06229805477360907},
{-0.7078996106553211,-0.40849977532518533,-0.5761996830902615},
{-0.9310794187169215,-0.28399372238814913,0.22899493812283858},
{-0.365489770084501,-0.6821809060236569,0.6332822746771942},
{-0.21769499960328803,-0.25989403030268515,0.9407783905685502},
{0.36520766761547324,-0.6589138340411701,0.6576138067468104},
{0.6225015593683594,-0.41150103081137324,0.6657016675847659},
{0.7193024096671086,-0.6916023168716422,0.06550021942610261},
{0.9177133115281263,-0.3789054960640809,-0.1193017304841511},
{0.3477960055858137,-0.6886920904167622,-0.6361926933688749},
{0.23530353546218072,-0.25850388405003705,-0.9369140772397666},
{-0.6332083172458709,0.06180081175899371,-0.7715101338521626},
{-0.9260166452988001,0.03220057881060622,0.37610676057978265},
{-0.2482958547353075,-0.0008999849748762656,0.9686838279584872},
{0.5938100681350585,-0.025100425581323627,0.8042136355577874},
{0.9466093525466049,-0.06480064023348826,-0.3158031201502407},
{0.2698129864115615,-0.01790086158920293,-0.9627463380964056},
{0.3097903145572208,0.2567919715245135,-0.9154713782347824},
{-0.7047156660033848,0.3663081431205334,-0.6076135073984059},
{-0.8867900502714536,0.4155953370464774,0.20219773135418123},
{-0.3098036727443107,0.27550326611057974,0.9100107882418423},
{0.6555758719740399,0.2983890179942854,0.693674469780951},
{0.9025853601841858,0.4217931585704516,-0.0861986018700164},
{-0.6148215806162262,0.7080248521084711,-0.34741219438203796},
{-0.6491994027368243,0.6853993694328703,0.3297996965844187},
{-0.03910018103425729,0.7023032516715829,0.7108032910268561},
{0.5777043963471844,0.6755051406136802,0.4582034869418035},
{0.6268594497737489,0.7203534018456033,-0.296880795402498},
{0.0608987640721246,0.7022857472553876,-0.7092856051947123},
{-0.0,-1.0,0.0},
{0.7495765948362337,-0.658979423688738,0.06229805477360907},
{0.3682013163220588,-0.7000025025134197,-0.6119021875542308},
{0.7078996106553211,-0.40849977532518533,-0.5761996830902615},
{-0.23530353546218072,-0.25850388405003705,-0.9369140772397666},
{-0.3477960055858137,-0.6886920904167622,-0.6361926933688749},
{-0.9177133115281263,-0.3789054960640809,-0.1193017304841511},
{-0.7193024096671086,-0.6916023168716422,0.06550021942610261},
{-0.6225015593683594,-0.41150103081137324,0.6657016675847659},
{-0.36520766761547324,-0.6589138340411701,0.6576138067468104},
{0.21769499960328803,-0.25989403030268515,0.9407783905685502},
{0.365489770084501,-0.6821809060236569,0.6332822746771942},
{0.9310794187169215,-0.28399372238814913,0.22899493812283858},
{0.6332083172458709,0.06180081175899371,-0.7715101338521626},
{-0.2698129864115615,-0.01790086158920293,-0.9627463380964056},
{-0.9466093525466049,-0.06480064023348826,-0.3158031201502407},
{-0.5938100681350585,-0.025100425581323627,0.8042136355577874},
{0.2482958547353075,-0.0008999849748762656,0.9686838279584872},
{0.9260166452988001,0.03220057881060622,0.37610676057978265},
{0.7047156660033848,0.3663081431205334,-0.6076135073984059},
{-0.3097903145572208,0.2567919715245135,-0.9154713782347824},
{-0.9025853601841858,0.4217931585704516,-0.0861986018700164},
{-0.6555758719740399,0.2983890179942854,0.693674469780951},
{0.3098036727443107,0.27550326611057974,0.9100107882418423},
{0.8867900502714536,0.4155953370464774,0.20219773135418123},
{0.6148215806162262,0.7080248521084711,-0.34741219438203796},
{-0.0608987640721246,0.7022857472553876,-0.7092856051947123},
{-0.6268780565176907,0.720374783722036,-0.296789611061494},
{-0.5777043963471844,0.6755051406136802,0.4582034869418035},
{0.03910018103425729,0.7023032516715829,0.7108032910268561},
{0.6491994027368243,0.6853993694328703,0.3297996965844187},
{0.8194035193456733,-0.5732024619098609,-0.00410001760961345},
{-0.29478388018425616,-0.8172553096153071,0.4951729222091032},
{-0.6199011747138391,-0.7276013788059192,0.29380055675258254},
{-0.5347958286088051,-0.7109944542648848,-0.4565964385616687},
{-0.3549054549387639,-0.8647132907454189,-0.3554054626239411},
{0.13109669771577628,-0.8913775464824026,0.4338890704719705},
{-0.21069496655737271,-0.9451774199811518,-0.249494039658588},
{0.41121047572030517,-0.8080205845865919,0.4219107483132216},
{0.5361896704054985,-0.05969884991273454,0.841983779338735},
{0.6851660542887396,0.10979456036325687,0.7200643252967328},
{0.3933005958508541,0.8382012698758857,0.3778005723683007},
{0.22989323549106708,0.9399723417207614,0.25219257934252765},
{-0.13840424077090682,0.8820270257221084,-0.45041380089029215},
{-0.4031942504909817,0.7991886036517672,-0.44579364302797525},
{-0.5259121644890487,0.023300538947698863,-0.8502196658083079},
{-0.6461826663824584,-0.21049435356469742,-0.7335803219717911},
{-0.04480001859201157,-0.24770010279556398,0.96780040163725},
{0.2619966975524409,-0.09889875338907025,0.959987899428791},
{0.5487204703989794,0.6929258500810148,0.4677174485248819},
{0.3063942260552145,0.8082847680170687,-0.5027905250018337},
{-0.25309386760988084,0.09179777576683945,-0.9630766649351096},
{0.5971983457628733,0.4872986501846085,0.6370982352403326},
{0.6444944541490829,0.7059939249484136,-0.2935974736046094},
{0.07599668471694226,0.2289900105286813,-0.9704576647077956},
{-0.5715304576696554,-0.5086271054606942,-0.6439343161740877},
{-0.2532999252765331,-0.15369995465852007,0.9550997182456247},
{-0.8221874987341219,-0.05139921848082445,0.5668913804820891},
{-0.9182872129395893,0.09799863537850348,-0.38359465848157076},
{-0.3310144970973576,0.0929040688227931,-0.9390411262067031},
{-0.5078828059186535,-0.7930731509629535,0.33628861514164826},
{-0.08589800332411884,-0.16119625303664675,0.9831771463128479},
{0.12710556607461027,0.16750733530682316,0.9776428119161212},
{0.42876618668797767,0.6426493194598023,0.6349499266484744},
{0.5214750897299312,0.7951620160177205,0.30948521624432157},
{0.5078828059186535,0.7930731509629535,-0.33628861514164826},
{0.40160862262969277,0.6385137090365011,-0.6565140955089475},
{0.08589800332411884,0.16119625303664675,-0.9831771463128479},
{-0.12709314033287078,-0.16749095991940094,-0.9776472329146166},
{-0.4287937396571012,-0.6425906182454598,-0.63499072920303},
{-0.5214750897299312,-0.7951620160177205,-0.30948521624432157},
{0.8750972915780738,-0.47629852585834365,0.08569973475973137},
{0.8366330141901228,-0.05060199679419102,0.5454215227579404},
{0.5594125505613593,-0.20390457465044898,0.8034180248855847},
{0.42709558812536186,0.6519932649443595,0.6264935283552779},
{0.8275806307020049,0.4970883657829467,0.26079389619028864},
{0.2772087682520119,0.9097287751762455,-0.3091097772968863},
{0.6738364487992999,0.5967322781219091,-0.43572356892528197},
{0.2520090107432716,0.27430980812253725,-0.9280331824196668},
{0.7624044753274053,0.06010035279010632,-0.6443037820743013},
{0.44350949563995357,-0.5467117052229146,-0.7102152058703384},
{0.8440368978795039,-0.325614234537401,-0.42611862818300544},
{0.572674055589604,-0.8133631514171188,0.10239536108324682},
{-0.01860005384723383,0.5040014590863361,0.8635024998433556},
{-0.21329718662866246,0.9769871136249565,0.000699990767182671},
{-0.22741155507467747,0.5139261132492382,-0.8271420281542029},
{-0.1271009043261514,-0.46600331562538605,-0.8756062299604893},
{-0.9015655788832847,0.41578412566511735,-0.11959543393349696},
{-0.9329213408197597,0.0072001647056514845,-0.36000823528257425},
{-0.9150793789185414,0.19409562610434802,-0.35349203414676467},
{-0.9070126393091937,-0.29520411369798677,-0.30030418476797227},
{-0.8765128541552599,-0.4419064806060575,-0.19090279961008455},
{-0.8312767037968095,-0.5499845868979253,0.0805977412799505},
{-0.801273758714096,-0.5404822994945325,0.25659159676280674},
{-0.769900777600178,-0.25060025310638345,0.586900592769898},
{-0.7793801221634732,-0.08839774544425331,0.6202841798537367},
{-0.806647266881445,0.18621091134803502,0.5609328688244514},
{-0.8883184372404993,0.23320484021668855,0.3956082109336278},
{-0.9126872498481788,0.3988944274837718,0.08879875948999484},
{0.4406161180324018,0.17620644574968042,0.8802321994827963},
{-0.00010000384272148627,0.28831107856604493,0.9575367940582311},
{-0.00020000427413700795,0.14710314362776936,0.9891211377445728},
{-0.00010000305914036937,0.3715113647064722,0.9284284010591892},
{0.5910882670143485,0.6439872169806132,0.4856903591420556},
{0.4958132557445908,0.7940212284413173,-0.3517094030765885},
{0.09079998683400287,-0.382699944508512,0.9193998666870289},
{0.07549852213089378,0.5330895648739004,0.8426835046318436},
{-0.08249470153547511,0.8234471116904697,0.5613639447517058},
{0.3853083266029078,0.5638121841129494,0.7305157866167251},
{0.49459563273984425,0.8020929175508069,0.3346970446381437},
{0.36012180423472606,0.854951764621681,0.37332260350131424},
{-0.05890253256883286,0.7496322311306811,0.6592283441319969},
{0.07319989971620608,0.8014989019472565,0.5934991869066709},
{-0.062398071617394524,0.5025844678670272,0.8622733518538349},
{-0.07319989971620608,0.8014989019472565,0.5934991869066709},
{0.05890253256883286,0.7496322311306811,0.6592283441319969},
{0.05319969543261547,0.2514985601748645,0.9663944674075111},
{0.08249470153547511,0.8234471116904697,0.5613639447517058},
{-0.3852801797709644,0.5637709975470276,0.7305624171831472},
{-0.49459563273984425,0.8020929175508069,0.3346970446381437},
{-0.36012180423472606,0.854951764621681,0.37332260350131424},
{-0.07549852213089378,0.5330895648739004,0.8426835046318436},
{0.45109512368806925,-0.7120923023238176,0.5379941843143012},
{0.7600225844066485,-0.47791420143149643,0.4404130870693263},
{0.7749130147733756,-0.11980201209168977,0.6206104232395883},
{0.962707648742654,0.08110064434717902,0.2581020506289384},
{0.98512452005446,-0.16900420656705287,0.03110077410790144},
{0.9883197913019831,-0.14910298581718678,0.03150063080644791},
{0.9926610735592356,-0.0766969923864142,0.09349633361316463},
{0.7129082377022802,-0.6898079707771537,-0.12620145826627546},
{0.9831693944131203,0.03609887625947279,-0.17909442487732902},
{0.550225495289,-0.8277383541452294,-0.11000509720427117},
{0.8463282932277718,-0.42491420511931965,-0.32121073825447277},
{0.7608996157457912,0.22339988718308548,-0.6091996923542331},
{0.3974204497953798,-0.9088467659135411,0.12670651985172277},
{0.7349643991867342,-0.530174318977968,-0.4227795210559881},
{0.8849386107138966,0.021300929379823707,-0.46522029800441256},
{0.5239740272511878,-0.8514577942831801,-0.02169892441097476},
{0.9345110740218411,-0.1157013710693708,-0.33660398878090075},
{0.8929966021543931,0.2305991225720079,-0.3864985293758936},
{0.8527224396862544,0.4928129685439031,-0.17320455793791398},
{0.9826255829900841,0.17610458494255424,0.05860152571058307},
{0.9086731718206472,0.41598771814393004,0.03559894895654786},
{0.9124013503549978,0.383800568025261,0.14220021045646722},
{-0.0023998643994930513,0.3437805752273796,-0.9390469406516353},
{-0.43480945938268445,-0.4849105493437527,-0.7588165082327069},
{-0.4342868109098259,-0.0018999422996285268,-0.9007726439501984},
{9.999548730548457e-05,-0.009499571294021033,-0.9999548730548456},
{-0.5554875294449444,-0.023899463463067816,-0.8311813401883669},
{-0.7667257087440286,-0.3233108407942408,-0.5546185966733249},
{-0.8649331881231547,-0.029501131980151536,-0.5010192244764718},
{-0.7690649506635421,-0.6352710481817035,-0.07049678718213458},
{-0.33749613737881146,-0.9379892647742966,0.07919909357156109},
{-0.6282818460583334,-0.6750804938309422,0.3866888267877726},
{-0.27430337669535076,-0.9440116208545795,0.1833022564646657},
{-0.17800814227864598,-0.9446432089685899,0.27561260680895977},
{-0.3769998171551331,-0.4778997682186687,0.79339961520128},
{-0.1989953783860049,-0.8550801409943355,0.4787888802573826},
{0.00019999114658790648,-0.6740701595745389,0.7386672999224326},
{-0.23070526360063423,-0.7622173901881379,0.6048137989842375},
{0.0,-0.828417160839232,0.5601116028320303},
{0.23119309667719828,-0.7617772536708031,0.605181929537372},
{0.1994094632006196,-0.8547405626758755,0.47922274205484916},
{-0.9961108078608982,-0.050500547933917644,0.07220078338274959},
{-0.7449037208033781,-0.015000074925561378,0.6670033316899627},
{-0.42521526550205224,-0.010400373380106638,0.9050324912496643},
{9.999995900002524e-05,-0.0008999996310002271,0.9999995900002523},
{0.37708559937593455,-0.4778817500444421,0.793369701789622},
{0.17829087619785985,-0.9444516689224826,0.27608587166701687},
{0.6286691896780023,-0.6746669353837254,0.386781044325515},
{0.27549629459975633,-0.9435873088360437,0.1836975292848466},
{0.0,-0.08550325175049729,-0.9963378914505315},
{0.0,-0.03720029146542545,-0.9993078296075176},
{0.3645086152629338,-0.10880257157916927,-0.9248218584229387},
{0.5348833814315044,-0.1212962313846354,-0.8361740204767694},
{0.8196770616583898,-0.08019775569720979,-0.5671841275742817},
{0.9242408107540182,-0.019400856663739398,-0.38131683741669237},
{0.9881940510897186,0.0763995400761531,0.13279920055121902},
{0.877405488188493,0.11070069243499679,0.4668029198613956},
{0.5741139568799397,0.12210296835924166,0.8096196820937104},
{0.43161454997172344,0.04090137880871986,0.9011303776170528},
{-0.00020000196702901865,0.019500191785329316,0.9998098331780642},
{-0.0001000040872505706,-0.05400220711530812,0.9985408111969475},
{-0.4316906021978841,0.041199103105287994,0.9010803836935682},
{-0.5738658531283342,0.12239271723803467,0.8097518171516379},
{-0.8772073466422923,0.11100092963667857,0.4671039120116447},
{-0.9881602322916611,0.07649692144334352,0.13299464773810052},
{-0.9242408107540182,-0.019400856663739398,-0.38131683741669237},
{-0.8196770616583898,-0.08019775569720979,-0.5671841275742817},
{-0.5348833814315044,-0.1212962313846354,-0.8361740204767694},
{-0.3645086152629338,-0.10880257157916927,-0.9248218584229387},
{-0.0,-0.13310034473033927,0.9911025669589727},
{-0.0,-0.18209642184046593,0.9832806787244928},
{0.35810612545766435,-0.12470213304822883,0.9253158276625993},
{0.528792308771803,-0.1137983448151119,0.8410877664674044},
{0.799786415743092,-0.1662971754664619,0.5767902033015947},
{0.9006071823709192,-0.19880158544896598,0.386503082374373},
{0.952813601511243,-0.2780039685349765,-0.12190174015976125},
{0.8380657615227052,-0.2890881895432694,-0.4626810975498815},
{0.5341031752528154,-0.2873017080137312,-0.7951047269116522},
{0.40220061536741225,-0.22410034287378688,-0.8877013581841171},
{9.999651718195878e-05,-0.14339500563892887,-0.989665530549846},
{-0.402191932110762,-0.22379551070708237,-0.887782191267863},
{-0.5344060495107209,-0.2870032488951663,-0.7950089995528127},
{-0.8382899992599627,-0.2888965534846752,-0.4623944836667145},
{-0.9528368135614517,-0.27801074115248064,-0.12170470215200321},
{-0.9006071823709192,-0.19880158544896598,0.386503082374373},
{-0.799786415743092,-0.1662971754664619,0.5767902033015947},
{-0.528792308771803,-0.1137983448151119,0.8410877664674044},
{-0.35810612545766435,-0.12470213304822883,0.9253158276625993},
{0.0997997460099696,0.9948974679891659,-0.014799962334143789},
{-0.026201276033214982,0.9996486840764006,-0.004000194814231295},
{0.0404991590436936,0.999179252258238,-0.0007999833885174043},
{-0.03699938859015528,0.9982835035014057,0.04539924978359594},
{-0.11939812486717333,0.9927844084432971,0.011099825678606566},
{-0.12340358307505263,0.9914287865527324,-0.04290124565575169},
{-0.12539425331305298,0.9838549109626221,-0.12769414791129877},
{0.013300516269558698,0.99183849895852,-0.12680492202857466},
{0.06600305832256272,0.9902458841060847,-0.1227056856996734},
{-0.0997997460099696,0.9948974679891659,-0.014799962334143789},
{-0.0404991590436936,0.999179252258238,-0.0007999833885174043},
{0.026201276033214982,0.9996486840764006,-0.004000194814231295},
{0.03699938859015528,0.9982835035014057,0.04539924978359594},
{0.11939812486717333,0.9927844084432971,0.011099825678606566},
{0.12340358307505263,0.9914287865527324,-0.04290124565575169},
{0.12539425331305298,0.9838549109626221,-0.12769414791129877},
{-0.013300516269558698,0.99183849895852,-0.12680492202857466},
{-0.06600305832256272,0.9902458841060847,-0.1227056856996734},
{0.2961096148352931,-0.9184298219004835,-0.2623085172958371},
{0.3065951343738259,-0.9426850397071288,0.13169790997075304},
{0.30639993718801933,-0.9388998075255591,-0.1567999678560099},
{0.15140731542117114,-0.9435455885064397,0.2946142346306275},
{-0.15179321954832078,-0.8246631631192368,0.5448756609478261},
{-0.457103487712917,-0.8007061094109224,0.38720295436981284},
{-0.6725840263190601,-0.7014833399685113,0.2356944023244164},
{-0.5454245773851979,-0.8294373752902148,-0.1206054346033276},
{-0.41001937592342463,-0.865740911553436,-0.28701356314639725},
{0.017599753869163196,-0.918987148054601,-0.3938944914240558},
{-0.07379813145496704,-0.8897774711196431,-0.45038859630511047},
{0.16579000647960504,-0.9033455479715029,-0.39557615538800817},
{-0.00019999409526150482,0.365089220899877,-0.9309725134423049},
{-0.00010000438528844445,0.9850431950911778,0.17230755585198979},
{-0.386416212432296,0.9068380471884214,-0.16830706147089913},
{-0.6786734609932015,0.13259481498113823,-0.7223717522049342},
{-0.536286029930878,0.8403781084354092,-0.07849795515490197},
{0.6710810556491947,0.7044801128071192,0.23099347914612428},
{0.44859129517037505,0.5008902803184148,0.7401856368370744},
{0.00010000427327389745,0.16530706372175247,0.9862421430271765},
{-0.44870535308679366,0.5006059722648739,0.7403088319370478},
{0.38621101875754993,0.9069258749643244,-0.1683048018044942},
{0.6786954561491314,0.13289911024343534,-0.7222951642500629},
{0.5361739291765252,0.8404591336681638,-0.0783961880780298},
{0.9971531349039634,-0.06699685122198712,-0.034598373914638124},
{0.5213757305246031,0.7932630744633057,0.314485361047157},
{0.6397089975703267,0.02170030521693933,0.7683108063674879},
{-0.00010000134152699494,0.5800077808565706,0.8146109280789008},
{-0.00020000235904173744,0.0719008480755046,0.9974117645411446},
{-0.6398172209122545,0.021700584079080838,0.7682206769377834},
{-0.5214006882493627,0.7932010470260732,0.31460041527282223},
{-0.997135922468672,-0.06730242461352084,-0.03450124292966522},
{-0.44042390245379687,0.17610955772505366,0.8803477777703846},
{-0.5273825966614605,0.20319329473190895,0.8249727763475634},
{-0.4357951932055283,0.34789616272648755,0.8300908441484832},
{-0.5768804267791735,-0.061997896447059726,0.8144723654214541},
{-0.910586609922351,0.2035970061280372,0.35969471072816783},
{-0.6893734561860946,-0.3023883567604801,0.658274653622434},
{-0.5452120574979789,0.0763016874304765,0.83481846221444},
{-0.5911913864042496,0.6438906185820303,0.4856929235056564},
{-0.41721141297430503,0.8664237013445297,0.27430750378440044},
{-0.3306104127389264,0.7999251940407357,-0.5008157734411807},
{-0.3100009517043826,0.662502033884366,-0.6819020934426403},
{-0.05260229561427201,0.3014131539570643,-0.9520415479997518},
{-0.04160127634673778,0.2402073696751542,-0.9698297548333245},
{-0.08059720453444025,-0.06739766235262125,-0.9944655075620451},
{-0.5429051739109612,-0.09670092156417377,-0.834207950039646},
{-0.5107974817746223,0.11409943749115972,-0.8520957991780649},
{-0.4398867618071022,-0.34128972904015453,-0.8306750012120022},
{-0.5322015087934162,-0.3918011107577235,-0.7505021276765479},
{-0.9074487494562664,-0.14260766108933612,-0.3952212318548782},
{-0.9164195153613717,-0.237805064112761,-0.32190685507946915},
{-0.44820292677466783,-0.30330198056839974,0.8409054911307857},
{-0.9004896894520833,-0.18039793445547567,0.3956954693128144},
{-0.9757520577609594,-0.04590244896097985,0.21401141781371866},
{-0.9494724989273472,0.09479725423729594,-0.29919133404851217},
{0.04500120829866444,0.4763127891700861,0.8781235779346055},
{0.07400028342162825,-0.8897034075705764,-0.45050172542491257},
{0.4112067253409899,-0.8651141490576126,-0.28720469727123615},
{-0.017299848626986764,-0.9189919588555399,-0.3938965534202362},
{0.5473140415218551,-0.8282212482886908,-0.12040308898087221},
{0.6747738024156719,-0.6989728629053863,0.23689080289311304},
{0.45852862683578793,-0.7992498987288151,0.38852425632650733},
{0.15240074295543288,-0.8240040170293745,0.5457026603069535},
{-0.1510057134092523,-0.9437357069159695,0.2942111316887552},
{-0.3056881838516255,-0.9430635465831467,0.13109493262331728},
{-0.30558386407007543,-0.9391504094719073,-0.15689171555168469},
{-0.29539709182994633,-0.9186909555320639,-0.2621974186791196},
{-0.05899729798562697,-0.742565991256383,-0.6671694443391579},
{0.08600354986978281,0.49112027140756215,-0.8668357793852065},
{0.030800094864438275,-0.05140015831273141,-0.9982030744702041},
{0.13050213307479783,0.9541155951468551,-0.269504405085502},
{0.12269536588354421,0.9794630063808603,0.15999395714235592},
{0.05559700090067743,0.5897681858133013,0.8056565400301404},
{-0.009499992495008894,0.12429990180311637,0.9921992161629288},
{-0.10240217862952578,-0.6388135909037214,0.7625162227052089},
{-0.11899477624398183,-0.9165597639095273,0.38178324008363246},
{-0.047999916240219244,-0.8481985198948742,-0.5274990795149094},
{-0.04440142863895006,-0.9645310342853003,-0.2602083723390722},
{-0.09450359025959224,-0.8719331253686611,0.48041825143606465},
{0.09099795165916198,0.5350879553056876,-0.8398810944893422},
{0.07610404960422203,0.0766040762113457,-0.9941529002832735},
{-0.0,-0.2861917463490512,0.9581723667074105},
{0.5461998661810491,-0.13379996721901202,0.8268997974095743},
{0.9341145676302742,0.14940232994750344,0.3242050560172732},
{0.7881727572794589,0.28749006307770164,-0.5441811907022095},
{0.4852148744899698,0.7434227899749454,-0.4603141111453691},
{9.999556679481705e-05,0.15789299996901612,-0.9874562220988183},
{0.00010000053450428539,0.8257044134018844,-0.5641030151386739},
{-0.48519253779615257,0.7433885667717638,-0.4603929192113533},
{-0.7882204388209714,0.28710744479256645,-0.544314114247976},
{-0.6713010103087808,0.7043010599738929,0.2309003475052845},
{-0.9342816602310127,0.1485970830678888,0.3240936381043254},
{-0.5460857528085614,-0.13439649364122075,0.8268784270232546},
{-0.24990172307832098,-0.2206015210527315,0.9428065006732333},
{-0.36008312870024783,0.6622689701143409,0.6570692137432183},
{-0.21159191522737578,0.10349604549165119,0.9718628658293313},
{-0.3547846434790533,0.7827661187018121,-0.5112778698163472},
{-0.4785924430849851,0.6420898614811302,0.5988905435929744},
{0.03760039461821229,0.1530016057602787,-0.9875103639756552},
{-0.04429854924626788,0.010099669241248433,-0.9989672843571471},
{-0.4958132557445908,0.7940212284413173,-0.3517094030765885},
{0.6216034778811882,0.7375041263471305,-0.2640014770923965},
{0.48729042240087067,0.8170839403729765,-0.30809394447303146},
{0.74158430453429,0.5723878855386025,-0.349892594601602},
{0.3458887138353983,0.7485755743775057,-0.5656815421124164},
{0.306084985369305,0.9252546127481802,-0.22408900758334288},
{0.40820619253491147,0.6931105145662596,0.5941090127020845},
{-0.49069455086726876,0.15959822767152249,0.8565904876154522},
{-0.537224258909129,0.21170955996102492,0.8164368670391156},
{0.00010000038250219461,0.22350085489240495,0.9747037282488908},
{-0.0,0.15300395979371986,0.9882255756088495},
{0.4910112320103998,0.15900363724980363,0.8565195931097912},
{0.5373794590627585,0.21119192734286305,0.8164687910769303},
{0.9376231736431084,0.1416034997737459,0.31750784730342035},
{0.9280012203224072,0.1876002466944866,0.321900423299335},
{0.9179666875933498,0.09429657803927328,-0.3852860182240933},
{0.8732515839081082,0.016999057513383535,-0.48697300053045767},
{0.5325081980268134,0.02640040643738568,-0.8460130244707684},
{0.45541389716711134,-0.036601116900123576,-0.8895271443349704},
{0.0009000197061472015,-0.059601304984859126,-0.9982218563068185},
{-0.4572914555889777,-0.030799424518129268,-0.8887833932374446},
{-0.5407237112546192,0.03340146468634045,-0.8405368583493756},
{-0.8769819475124139,0.02039958007896607,-0.4800901174466476},
{-0.9206761087649623,0.09539752446635973,-0.37849017830730775},
{-0.937544576616618,0.1421067566263695,0.31751509661416133},
{-0.9279788191251773,0.1878957113293328,0.3217926551664677},
{-0.9491301306142522,0.05110162224674775,0.3107098636411844},
{-0.4298152200264165,0.10550373595343633,0.8967317538336148},
{-0.00010000252709578997,0.12040304262333111,0.992725086479907},
{0.4300008836527238,0.10500021577566512,0.8967018427241802},
{0.9492080255877846,0.05030042529189377,0.31060262615630624},
{0.8159026353697684,-0.058700189601918626,-0.5752018579050017},
{0.36600148413902733,-0.09450038319983083,-0.9258037541418347},
{0.0,-0.08300409842854235,-0.9965492058318368},
{-0.3652154781599536,-0.0892037805363304,-0.9266392718045262},
{-0.8183648765332326,-0.05379769105264896,-0.5721754427569841},
{-0.9569834060516074,0.014199753778404206,0.28979497499869994},
{-0.9206756806730882,-0.0054998547232562025,-0.39028969063398106},
{0.9913921283777508,-0.12839898051614201,0.025599796738420843},
{0.06269915325365294,0.9423872731458138,-0.32859556234689563},
{0.15389346659156086,0.9862581292999121,-0.06009744861697731},
{0.08920161054961784,0.9959179814614845,-0.013800249165748051},
{0.0008999861538195344,0.2585960215308129,-0.965985138432967},
{-0.5057884656255606,0.28539349167563266,-0.814081435084557},
{-0.8618091653892113,0.36180384780438224,-0.35550378080281336},
{-0.8569025278661858,0.39930117794021236,0.3260009617042556},
{-0.5120019328109445,0.267401009440716,0.8163030815499493},
{-0.00010000285512227119,0.2740078230350231,0.9617274577108821},
{0.511308561933555,0.26990451958902106,0.815913662588671},
{0.8558880262102693,0.4013943845318403,0.32609543795673424},
{0.8584767785172074,0.3635901650190525,-0.36169021641196725},
{0.49718897744255375,0.30389326276104606,-0.8126819830401517},
{-0.06269915325365294,0.9423872731458138,-0.32859556234689563},
{-0.15389346659156086,0.9862581292999121,-0.06009744861697731},
{-0.08920161054961784,0.9959179814614845,-0.013800249165748051},
{0.42521391960549115,-0.0107003502816998,0.9050296266297495},
{0.7448980409207285,-0.015499959235160815,0.6669982457969204},
{0.7692089190291245,-0.6351073641125806,-0.07040081630219756},
{0.9960884753230101,-0.050799412254200295,0.07229916350351735},
{0.3388087244369828,-0.9375241415574717,0.07910203690367575},
{0.8650547328702124,-0.030098424990629282,-0.5007737951929284},
{0.76659581439828,-0.3239982309744883,-0.5543969730007912},
{0.5555947718777948,-0.024499769458254092,-0.8310921794593866},
{0.4342058965561131,-0.0016000217284426095,-0.9008122331131891},
{-0.05950166428482539,0.996627876071546,0.05650158037130478},
{-0.13129568438178038,0.9906674372964953,0.03659879701731274},
{-0.043100982498094194,0.9952226863597063,0.08760199691027962},
{0.017299848626986764,0.9938913034891415,0.10899904626251777},
{0.07479654672315485,0.9926541702149173,0.09509560953705917},
{0.04360177004978349,0.9973404878589236,0.05840237089237054},
{0.005300079660795957,0.9987150107994194,0.050400757529078535},
{-0.005300079660795957,0.9987150107994194,0.050400757529078535},
{-0.04700051865358503,0.9963109943524843,0.071800792326115},
{-0.07479654672315485,0.9926541702149173,0.09509560953705917},
{-0.04140086652920478,0.9933207904217175,0.10770225423177186},
{0.043100982498094194,0.9952226863597063,0.08760199691027962},
{0.05950166428482539,0.996627876071546,0.05650158037130478},
{0.1090011897544793,0.9929108376809402,0.04740051737947081},
{0.15400717921199236,0.9874460308696186,0.03510163630091514},
{0.4168913162443231,0.8665819492859927,0.2742942865095174},
{0.3304948955457571,0.7999876442862502,-0.5007922653231927},
{0.3100015500116251,0.6626033130248478,-0.6818034090255677},
{0.05270202247891968,0.30141156689082343,-0.9520365351030653},
{-0.8254528927475779,-0.018498944295372733,0.5641678038621242},
{-0.8157482203024953,-0.06050357647211103,0.5752340030869135},
{-0.8457028880802941,-0.07180024519825604,0.5288018058612506},
{-0.9073895832273765,-0.020399765812032712,0.4197951807789868},
{-0.9199177683832962,-0.09900191224040257,0.3794073283233205},
{-0.7444668980153033,-0.4287809346795998,0.511777244330735},
{-0.8330863250002118,-0.1330978152172947,0.5368911870034976},
{-0.6008242016862757,0.7754312349992313,-0.1942078228486597},
{-0.4521211733303322,0.8912417378278966,-0.035701671948446936},
{-0.4305807857611435,0.8819606433844137,-0.19169144596008178},
{-0.5229998954000314,0.7337998532400442,-0.43359991328002606},
{-0.16920704423588034,0.8589357582399387,-0.4833201210354668},
{-0.18540634285948568,0.9431322651066933,-0.2759094390233662},
{-0.46088368961483167,0.8853686673572835,0.06089784486340476},
{0.5724794912895803,-0.8197706322431404,-0.015599441160030484},
{0.3676033654242158,-0.905308288135317,0.21280194821075385},
{0.4663944546029019,-0.8818895143960103,0.06889918079361051},
{0.39239053369256066,-0.896778365482896,0.20449506661602612},
{0.28260064433020365,-0.8652019726627466,0.41420094437922983},
{0.3285017131409011,-0.7834040854629586,0.5276027514555233},
{0.4599994733009046,-0.7989990851465714,0.3872995565422616},
{0.3387866368246605,-0.7531702917837494,0.5638777582804783},
{0.5837052825567108,-0.6815061676587261,0.4414039947242285},
{0.5585781907403055,-0.8081684456790457,0.1866927107254118},
{0.8157482203024953,-0.06050357647211103,0.5752340030869135},
{0.8257012839664949,-0.01860002892306746,0.563800876711045},
{0.8463143282228662,-0.07190121729791336,0.5278089358809274},
{0.8330863250002118,-0.1330978152172947,0.5368911870034976},
{0.7442220851180688,-0.43011276378565083,0.5110151646000176},
{0.9204127017829276,-0.099001366228281,0.3782052192680391},
{0.9079361093371169,-0.020300807379164523,0.4186166487151857},
{0.7263391325749297,-0.6866369935645694,0.0310016702599791},
{0.599998125008789,-0.7672976021987398,0.2263992925033164},
{0.5771744086540679,-0.8129639539774033,0.0771965771796501},
{0.6424891259635637,-0.7385874995123551,-0.20419654400273884},
{0.31578872022836657,-0.9293668036106518,-0.1911931707019116},
{0.34639065970179,-0.9375747186385633,0.031099161422418215},
{0.6076151510726904,-0.7289181758013232,0.3154078647931642},
{-0.7061018570503261,0.6643017471158924,-0.24520064487854407},
{-0.5192120744171875,0.8519198116255817,-0.06820158604632547},
{-0.6124249721373688,0.7670312763379521,-0.19130780073461567},
{-0.5421813818110174,0.8371712520327993,-0.07199752764735014},
{-0.4285044778951911,0.8941093434914594,0.13020136061132762},
{-0.45959726770236525,0.8472949628464188,0.2661984174551123},
{-0.5918057109526662,0.7945076670359805,0.13610131338401127},
{-0.46438498667606715,0.8292731900311424,0.31088994909041623},
{-0.6931779122377342,0.6824782531769382,0.23179261404602824},
{-0.6904139050760738,0.7216145334630575,-0.05100102717103094},
{0.7501027716348617,-0.6052022362263942,-0.2666009850924599},
{0.7477985343163092,-0.4137991889543845,-0.5191989823709918},
{0.9007974687626691,-0.3192991027707818,-0.2942991730204857},
{-0.9007974687626691,-0.3192991027707818,-0.2942991730204857},
{-0.750399185817325,-0.6050993434675684,-0.26599971139046974},
{-0.7482516308366863,-0.413773252492611,-0.5185664783534752},
{-0.6149680962827258,0.7175627738089171,0.3269830365600835},
{-0.7810668483211696,0.47717974653547834,0.4027829042424364},
{-0.30319560975935583,0.7995884220434727,0.5183924937310358},
{-0.17909140919114672,0.900756791733026,0.3956810196367211},
{0.25601054657170347,0.8444347872076032,0.4705193834452597},
{0.3783982877516219,0.4354980293758756,0.8167963040050865},
{-0.4411941189215918,0.40089465610985076,0.8028892975569947},
{-0.784616159336204,0.2886059439006226,0.5487113008256119},
{-0.9050735812877377,0.3685892410370789,0.21209380907206848},
{-0.9209880226286481,0.3869949671631779,0.04489941608689066},
{0.6149680962827258,0.7175627738089171,0.3269830365600835},
{0.30319560975935583,0.7995884220434727,0.5183924937310358},
{0.7810668483211696,0.47717974653547834,0.4027829042424364},
{0.9209880226286481,0.3869949671631779,0.04489941608689066},
{0.9050735812877377,0.3685892410370789,0.21209380907206848},
{0.784616159336204,0.2886059439006226,0.5487113008256119},
{0.4411941189215918,0.40089465610985076,0.8028892975569947},
{-0.3783982877516219,0.4354980293758756,0.8167963040050865},
{-0.25601054657170347,0.8444347872076032,0.4705193834452597},
{0.17909140919114672,0.900756791733026,0.3956810196367211},
{-0.2885012766209736,0.05130022700400674,0.9561042307705818},
{-0.7666810057133724,0.05709858540006985,0.6394841569762639},
{-0.8313507388839384,0.23561437998442908,0.5033307192112187},
{0.09599559342342354,0.9933544011128014,0.06349708523320202},
{-0.8587150534068305,0.5114089650777374,0.03270057324607355},
{-0.3642083113284979,0.9294212096340085,0.059401355554400806},
{-0.9249138691874534,-0.37940568923096535,-0.024200362887162256},
{-0.5233074467179505,-0.850412101450306,-0.05430077270549343},
{-0.09149803555826462,-0.9937786638011299,-0.06349863669890496},
{0.0,0.3032985896648371,-0.9528955690459059},
{0.0,0.07980086664211762,-0.9968108254243465},
{-0.8426996081447733,-0.48399977494015695,-0.23579989035307647},
{-0.8954172279932014,-0.4260081964765511,0.12940248972785376},
{-0.9744415803093666,-0.043901873332903525,0.22030940080270264},
{-0.9454003923412442,-0.08400003486002171,0.31490013068358136},
{-0.5987027929550437,-0.020700096566175722,-0.8007037352916376},
{-0.5256259770776965,0.01120055354503463,-0.8506420397684337},
{0.42699684023507334,0.010399923040854245,-0.9041933089942701},
{0.7518577843705782,-0.06449637863000704,-0.6561631574730329},
{0.9928305548304946,-0.051001569597456914,0.10810332693108024},
{0.8573139486114167,-0.10040163354786685,0.5049082149234858},
{-0.3845109625638163,-0.08470241490027369,0.9192262075127696},
{0.1521973327651147,-0.041399274484071935,0.9874826945174164},
{-0.8573221492038408,-0.09980257843292116,0.5050130471806131},
{-0.751931273472009,-0.06400266192606541,-0.6561272889014299},
{-0.9928671813177234,-0.05029833741593462,0.10809642693166069},
{-0.4269959435578042,0.010599899301434953,-0.9041914102224041},
{0.5985856909800837,-0.021099495622585642,-0.8007808575623973},
{0.525583008176014,0.010899647620088571,-0.8506724982026924},
{0.9744113958079114,-0.044600521606150294,0.22030257645369752},
{0.9453525775773889,-0.0845957563603206,0.31488420423008223},
{0.38450117465288286,-0.08500025967618997,0.9192028081688683},
{-0.1521979620829315,-0.0412994470041069,0.9874867776405706},
{0.5727916688057654,0.8185880937227645,0.0426993789420499},
{0.5275049031808626,-0.48800453602324356,-0.6954064638331221},
{0.681208855772688,-0.2834036842718434,-0.6750087751711162},
{0.6463393180166087,-0.337320519831351,-0.6844416358511017},
{0.6195955327323134,-0.37509729555824844,-0.6894950287587638},
{0.4627888515508476,-0.5546866377598426,-0.6914833423669212},
{-0.8389243207685937,0.5440157712458159,0.01590046096104499},
{0.2147918616905379,0.9142653591418008,-0.3434869855246731},
{0.18069555313715527,0.9826758166457249,0.041198986105427764},
{0.38621364516913,0.5629198883109873,-0.7307258169991799},
{0.38279188489805926,0.4015914863507331,-0.8319823621608812},
{0.4555993598833491,-0.032299954618595646,-0.8895987501146342},
{0.3826797778214474,-0.43557698254252025,-0.8147569453068078},
{0.3151003749696693,-0.5840006949612405,-0.7481008902405891},
{0.11069868158655342,-0.8797895217691933,-0.4622944941053626},
{-0.45587758277103735,-0.03229841176465125,-0.889456262063693},
{-0.38621364516913,0.5629198883109873,-0.7307258169991799},
{-0.38270653476987226,0.4016068574956381,-0.8320142067638717},
{-0.214806613997469,0.9143281525972343,-0.34331057069521004},
{-0.38541120021221964,-0.4334125951530254,-0.8146236733079244},
{-0.31969367812002214,-0.5804885209529961,-0.7488851909417722},
{-0.11929782760633875,-0.8762840430128638,-0.4667914998041821},
{-0.5175900778933092,-0.02429953418239454,0.8552836043704548},
{-0.34138629532225595,0.0466981253413865,0.938762314143333},
{-0.1293019201477714,-0.013400198994432611,0.9915147241029801},
{0.04040127973080353,-0.07930251194684951,0.9960315497990178},
{0.8313507388839384,0.23561437998442908,0.5033307192112187},
{0.7666810057133724,0.05709858540006985,0.6394841569762639},
{0.2885012766209736,0.05130022700400674,0.9561042307705818},
{0.6346930374555685,-0.08839903026795691,0.767691578469576},
{0.5133927483786433,-0.0337995225851152,0.8574878880691209},
{0.34138629532225595,0.0466981253413865,0.938762314143333},
{0.1293019201477714,-0.013400198994432611,0.9915147241029801},
{-0.04040127973080353,-0.07930251194684951,0.9960315497990178},
{-0.165496387253299,-0.9034802772408194,-0.39539136870063085},
{-0.9914048529386328,0.12830062803311135,-0.025600125312920115},
{-0.8194035193456733,0.5732024619098609,0.00410001760961345},
{0.919116603991428,0.034100616033193004,-0.39250709070464096},
{-0.9189896706141532,0.034199615598481,-0.39279558500243666},
{-0.6765988971446965,0.5772990590033007,-0.4570992549288217},
{-0.48088654738700265,0.6854808239421716,-0.5466847067092417},
{0.766562128933507,-0.5752715794096616,-0.28538590085784354},
{0.5926128776177475,-0.7373160220512406,-0.3243070472687065},
{-0.0,-0.0697972849384228,0.9975611956242205},
{0.9977099621837088,-0.06750067399759481,-0.004300042936143077},
{0.0,0.0697972849384228,-0.9975611956242205},
{-0.6427957318505106,-0.08599942896568748,0.7611949456823408},
{-0.772801031690066,-0.045700061009622164,0.6330008450566922},
{0.22418590587513254,0.8658455660003446,-0.4472718809007439},
{0.772801031690066,-0.045700061009622164,0.6330008450566922},
{-0.07039765544512747,-0.9886670729914421,-0.13259558397761223},
{0.8313110689805757,-0.5558074006248093,0.00020000266305318794},
{0.9596801396250138,0.2810941828160794,0.00029999379169272074},
{0.9796939357133068,-0.20049875891652344,0.0001999987620114947},
{0.9061243524192113,0.4230113685832981,0.0002000053752166894},
{0.617989358314874,0.786186461985686,0.0},
{0.30170083722098495,0.9534026456960127,0.0},
{-0.06689730609972397,0.997759821020995,0.00029998791972970384},
{-0.12079719632960943,0.9926769602351265,0.0006999837535656175},
{-0.4843006513848142,0.8749011767428742,0.0009000012105024422},
{-0.771603912041751,0.6361032250515266,0.00030000152101156727},
{-0.9889414820204633,0.1483062208349021,-0.00010000419476392591},
{-0.9974621270820384,-0.07119729668996604,-0.0004999810160812222},
{-0.9055741190615104,-0.4241878768837155,-0.0003999885684900665},
{-0.8261109460425531,-0.5635074665233976,-0.00020000265005266994},
{-0.5928885840402204,-0.8052844943963392,9.999807455561147e-05},
{-0.432594445522979,-0.9015884236789594,0.0005999922961483758},
{-0.14809592963931004,-0.9889728184556219,0.0005999835096798515},
{-0.029199221997094692,-0.9995733667224609,0.0006999813492454207},
{0.26800483485083143,-0.9634173802063097,0.0006000108242929062},
{0.44441127707923567,-0.8958227317902324,0.0005000126879829384},
{-0.9596801396250138,0.2810941828160794,0.00029999379169272074},
{-0.8313110689805757,-0.5558074006248093,0.00020000266305318794},
{-0.9796939357133068,-0.20049875891652344,0.0001999987620114947},
{-0.44441127707923567,-0.8958227317902324,0.0005000126879829384},
{-0.26800483485083143,-0.9634173802063097,0.0006000108242929062},
{0.029199221997094692,-0.9995733667224609,0.0006999813492454207},
{0.14809592963931004,-0.9889728184556219,0.0005999835096798515},
{0.432594445522979,-0.9015884236789594,0.0005999922961483758},
{0.5928885840402204,-0.8052844943963392,9.999807455561147e-05},
{0.8261109460425531,-0.5635074665233976,-0.00020000265005266994},
{0.9055741190615104,-0.4241878768837155,-0.0003999885684900665},
{0.9974621270820384,-0.07119729668996604,-0.0004999810160812222},
{0.9889414820204633,0.1483062208349021,-0.00010000419476392591},
{0.771603912041751,0.6361032250515266,0.00030000152101156727},
{0.4843006513848142,0.8749011767428742,0.0009000012105024422},
{0.12079719632960943,0.9926769602351265,0.0006999837535656175},
{0.06689730609972397,0.997759821020995,0.00029998791972970384},
{-0.30170083722098495,0.9534026456960127,0.0},
{-0.617989358314874,0.786186461985686,0.0},
{-0.9061243524192113,0.4230113685832981,0.0002000053752166894},
{-0.4814157305159961,-0.32621065910743235,0.8135265824153777},
{-0.24420121978813925,0.02490012437643189,0.96940484218928},
{-0.26369234116717455,-0.008199761841375925,0.9645719844135631},
{-0.6609990580770134,-0.35759949042108924,0.6596990599295094},
{-0.5133985727539516,-0.12499965250144908,0.8489976397898421},
{-0.5802947222435018,-0.23189789089827337,0.7806928996303666},
{-0.4763003119768065,0.09440006183206075,0.8742005726015626},
{-0.391098590092124,-0.08519969285566087,0.9163966963958641},
{-0.35519156607639407,0.20659509445772248,0.9116783524545283},
{-0.3124864461943381,-0.29528719219580174,0.9028608392603772},
{-0.4324780177010262,0.16209176108517073,0.8869549172273069},
{-0.48350826322682844,-0.13340227986444447,0.865114784938013},
{-0.5944949052004935,-0.035999691483965965,0.8032931158074962},
{-0.6330354066604695,0.1555086978447125,0.7583424152774628},
{-0.6443192203290179,-0.08130242528752003,0.7604226837469893},
{-0.6528932687050993,0.11549880921341549,0.7485922820533579},
{-0.5986781666053885,0.005499799425972334,0.800970789127971},
{-0.5863916117279909,0.3057956256248629,0.7500892700497372},
{-0.5423965585047544,-0.23769849180785418,0.8057948872476606},
{-0.3198951968096796,0.13289800455144235,0.9380859147457343},
{-0.4842976027327997,0.38549809178916844,0.7853961122988662},
{-0.8805460373895971,-0.08109503024335264,0.4669713825357051},
{-0.5568017010317949,0.09580029267034117,0.825102520692051},
{-0.5699109794407794,-0.13150253342070978,0.8111156262930623},
{-0.8812072391472044,-0.20220166109346885,0.4273035103127559},
{-0.8767390201384062,-0.024901108248484443,0.4803213771785976},
{-0.5298038198993124,-0.13250095533533196,0.8377060398823214},
{-0.4623075379858608,-0.32270526175218966,0.825913466628861},
{-0.39951393129368057,-0.08760305477178076,0.912531820539383},
{-0.6378095544586893,-0.5434081403149134,0.5458081762677212},
{-0.4399798647822218,-0.049197748516557525,0.8966589653414052},
{0.4763003119768065,0.09440006183206075,0.8742005726015626},
{0.391098590092124,-0.08519969285566087,0.9163966963958641},
{0.5133985727539516,-0.12499965250144908,0.8489976397898421},
{0.5802947222435018,-0.23189789089827337,0.7806928996303666},
{0.6609990580770134,-0.35759949042108924,0.6596990599295094},
{0.26369234116717455,-0.008199761841375925,0.9645719844135631},
{0.4814157305159961,-0.32621065910743235,0.8135265824153777},
{0.24420121978813925,0.02490012437643189,0.96940484218928},
{0.3198951968096796,0.13289800455144235,0.9380859147457343},
{0.5423965585047544,-0.23769849180785418,0.8057948872476606},
{0.5863916117279909,0.3057956256248629,0.7500892700497372},
{0.5986781666053885,0.005499799425972334,0.800970789127971},
{0.6528932687050993,0.11549880921341549,0.7485922820533579},
{0.6445112854914142,-0.08080141484516101,0.7603133132026723},
{0.5944949052004935,-0.035999691483965965,0.8032931158074962},
{0.6330354066604695,0.1555086978447125,0.7583424152774628},
{0.4324780177010262,0.16209176108517073,0.8869549172273069},
{0.48350826322682844,-0.13340227986444447,0.865114784938013},
{0.3124864461943381,-0.29528719219580174,0.9028608392603772},
{0.35519156607639407,0.20659509445772248,0.9116783524545283},
{0.4842976027327997,0.38549809178916844,0.7853961122988662},
{0.5568017010317949,0.09580029267034117,0.825102520692051},
{0.6576088580509774,0.13530182252782427,0.7411099828187033},
{0.43319770405825275,-0.06439965868271347,0.8989952353378792},
{0.44010643000191385,-0.048900714444657094,0.8966130996130787},
{0.6379033617595747,-0.5432028626866295,0.5459028769157421},
{0.880657848320861,-0.08099612321334136,0.46677765822207096},
{0.8812850447196856,-0.20209657045029894,0.42719275060053297},
{0.5694731812920256,-0.13249376035328078,0.811261794525409},
{0.36788814315621604,-0.00019999355431161514,0.9298700307718545},
{0.0,-0.3720974604434987,0.9281936650998536},
{-0.3675080099243654,0.00040000871828502356,0.9300202700126797},
{-0.5281809198089016,-0.22099201680758662,0.8198703827173768},
{-0.780572052118002,-0.49368232402082707,0.3833862731002331},
{-0.6126150521367488,-0.48211184563357257,0.626315388758155},
{-0.7014683469549995,-0.6515705985400964,0.28878696878204396},
{-0.7564953664800704,-0.6459960432863524,0.10199937525573984},
{-0.31459402748908166,-0.3558932434309096,0.8799832936757529},
{-0.3742985364955835,-0.4786981282939776,0.7941968946962127},
{-0.5739810359798516,-0.6447786968637776,0.5047833222345456},
{0.0,-0.2890996964454781,0.9572989948365832},
{0.0,-0.4428884916920631,0.8965767027570642},
{0.0,-0.7293937381816364,0.6840941270771285},
{-0.35979760015801043,-0.7108952583444402,0.6042959693593265},
{0.3742985364955835,-0.4786981282939776,0.7941968946962127},
{0.35979760015801043,-0.7108952583444402,0.6042959693593265},
{0.5739810359798516,-0.6447786968637776,0.5047833222345456},
{0.6128019456492662,-0.48150152876978075,0.6266019894644749},
{0.7014683469549995,-0.6515705985400964,0.28878696878204396},
{0.7801974721642854,-0.4937984000957756,0.3839987558460466},
{0.7566786127812603,-0.6457817472368679,0.10199711709222749},
{0.8768845406618209,-0.024199573365282317,0.48009153606082816},
{0.5284935814844292,-0.21979733057763012,0.8199900412814226},
{0.3149932828398644,-0.35579241280769447,0.8798812367326879},
{0.3306110277147472,-0.0082002735246852,0.9437314786884662},
{0.2857914421033974,0.33029010961074934,0.8995730626879507},
{-0.000300008986903806,-0.027200814812611745,0.9996299443634817},
{-0.0004999938851121774,0.23749709542828423,0.9713881199959382},
{-0.28690105436331215,0.31980117527147867,0.9030033185432935},
{-0.32999602357187385,-0.013299839737896734,0.943888626210581},
{0.3995963077471746,-0.08659919982709038,0.9125915676928716},
{0.46241411078188904,-0.3220098262797757,0.826125209595412},
{0.5298986143169354,-0.13089965769784268,0.8378978089000946},
{-0.6576088580509774,0.13530182252782427,0.7411099828187033},
{-0.6817293354444699,0.3799163481521991,0.6252269040925371},
{-0.5980996112353789,0.06599995710004182,0.798699480845506},
{0.0,0.31388690177287787,0.9494603798450065},
{0.0,0.12190512865664614,0.992541757110101},
{0.5980996112353789,0.06599995710004182,0.798699480845506},
{0.6817828567855965,0.3798904477747846,0.6251842799389189},
{0.00010000538143436637,0.34811873277302935,0.9374504455657503},
{0.0,0.0060998865126671385,0.999981395519203},
{0.37990548967398896,0.004700067916472093,0.9250133665397204},
{-0.43319770405825275,-0.06439965868271347,0.8989952353378792},
{-0.3796993810905132,0.004599992502018332,0.9250984920906868},
{0.0,0.07489933152644918,0.9971911001091471},
{0.0935000584375548,-0.9225005765630405,0.3745002340627195},
{-0.09559737827785061,-0.9781731739685509,0.18449494029564265},
{-0.02189890573901965,-0.9966501986338304,0.07879606265912094},
{-0.25740156758031985,-0.949105780071801,0.18150110534509734},
{0.0004999770465806751,-0.9933543961464852,-0.11509471612287141},
{-0.0004999914752180207,-0.9802832863124513,0.19759663100616176},
{0.09550510249640494,-0.9779522484946009,0.18570992181761672},
{0.2580048750481715,-0.9490179318632355,0.18110342198148785},
{0.02189907817770576,-0.9966580465625265,0.07869668733266864},
{-0.0943019978089856,-0.9215195225978815,0.37670798064310573},
{0.1636067521899972,0.9805404677401728,-0.10850447807221697},
{0.12599277767102407,0.9563451790838684,-0.2636848846972146},
{0.00010000084251064724,0.9867083130525564,-0.16250136907980178},
{0.11089610040719257,0.9863653150735325,0.12159572416153847},
{-0.11089610040719257,0.9863653150735325,0.12159572416153847},
{-0.16359779717049153,0.9805867964876773,-0.10809854446289814},
{-0.1258004950259219,0.9565037638497161,-0.2632010356981132},
{0.0001000006785069055,0.9169062212298166,-0.3991027079210599},
{0.0,-0.9610128536328766,-0.2765036982616966},
{-0.07150116333339122,-0.9540155219588144,-0.29110473631259004},
{-0.13479528494339757,-0.9473668616867571,-0.2903898423409692},
{-0.19970473405683187,-0.9449223996509787,-0.25930614692507015},
{-0.2895127460792254,-0.8841389250730334,-0.3667161450336855},
{-0.37869277082400676,-0.9139825522396151,-0.14569721866664323},
{0.07150116333339122,-0.9540155219588144,-0.29110473631259004},
{0.1340943272594754,-0.947159931246645,-0.2913876731052284},
{0.19970473405683187,-0.9449223996509787,-0.25930614692507015},
{0.2882983307574974,-0.8837948828424426,-0.36849786640353027},
{0.3010156336529112,-0.8068419044224875,-0.5083264006171918},
{0.384594421498374,-0.5840915278138331,-0.7147896320515802},
{0.37869277082400676,-0.9139825522396151,-0.14569721866664323},
{0.0,0.1486974052529173,0.9888827441466707},
{-0.1087973665916121,0.9795762896428605,0.169095907083103},
{-0.07960077173322296,0.9862095613480462,0.14510140676495792},
{-0.05539853722093675,0.9925737914350511,0.10829714045175903},
{9.999867302641334e-05,0.9957867859970241,0.09169878316522104},
{0.05519975049769162,0.9925955134784186,0.10819951093931583},
{0.07919891617024827,0.9862865027615639,0.14479801845267612},
{0.09209718647392917,0.9761701784565652,0.1964939972000769},
{9.99987830222159e-05,-0.31319618842558017,0.9496884423619844},
{9.999569327823376e-05,-0.34728504275530586,0.9377596115632763},
{0.23770445224608622,-0.3315062091694472,0.9130171009704532},
{0.374480284132047,-0.327282769015805,0.8675543244671936},
{0.3270843559293749,-0.3673824285186559,0.8706583574066241},
{0.46220131265359193,-0.3272009292519586,0.8242023407379716},
{0.6133739014957251,-0.2826879718826891,0.7374686213777264},
{-0.23729745381198078,-0.331596441989266,0.9130902025946889},
{-0.37410385516009126,-0.32730337287863637,0.867708941786718},
{-0.32647954506488586,-0.3674769764512881,0.8708454388882362},
{-0.4620059298841654,-0.32720419969285475,0.8243105800941938},
{-0.6134988435557698,-0.28259946730050617,0.7373986100049301},
{-0.4377021578769575,-0.76390376605485,0.47420233782328824},
{-0.5849249271069142,-0.7326312217447861,0.34801483096803926},
{0.0,-0.8495675428920239,0.5274798480173524},
{0.0,-0.7959983721849934,0.605298762165297},
{0.43773559591728184,-0.7638621159735433,0.47423856427684496},
{0.584990710421277,-0.7325883665891071,0.34799447389163146},
{-0.0006999927131137846,-0.9422901908101703,0.33479651478642153},
{-0.18629886264891526,-0.8203949915038652,0.5405966996672227},
{0.18491053927653767,-0.8230469108955678,0.5370306089318589},
{-0.3034998103126778,-0.8079994950004734,-0.5049996843752959},
{-0.38659165550917274,-0.5855873602332425,-0.7124846211854257},
{-0.48608876904873516,-0.2183949540428796,0.8461804492265783},
{-0.4693979205718178,-0.18449918267043114,0.8634961747204191},
{-0.7448060590219353,-0.20900170023574716,0.6337051552124066},
{-0.7648302381612103,-0.2715107343890803,0.5842230977167614},
{-0.0006000272508564105,-0.2065093788364146,0.9784444370631867},
{0.4880123834713479,-0.21820553703575435,0.8451214452287625},
{0.47122304808293636,-0.18430901477437428,0.8625421879701456},
{0.748410518983767,-0.20820292631269413,0.6297088506200937},
{0.7684203903055887,-0.2706071806568094,0.5799153882589939},
{0.5126883774862221,0.2185950445065109,-0.8302811777390485},
{0.49371481660397276,0.18450553709425352,-0.8498255036460522},
{0.000699991078670553,0.20959732869906847,-0.9777875381772383},
{-0.5148841495354312,0.21839327686645593,-0.8289744804134246},
{-0.4958232819288173,0.18430865441605693,-0.8486398488196739},
{-0.7756770596901844,0.20449395218079505,-0.597082341550869},
{-0.7974870090424331,0.266695655563156,-0.5411911840674167},
{0.7715433580972967,0.20561155466598083,-0.6020338322418309},
{0.7934702811271702,0.267889966369211,-0.5464795319924367},
{0.005199795912015601,0.9964608896776053,-0.08389670711886711},
{-0.0051998395094302735,0.9964692444513977,-0.08379741363274172},
{-0.6446910227400122,-0.055999220216287705,0.7623893838017454},
{-0.47798793095711306,-0.039499002662773994,0.8774778439641563},
{-0.5365220890691198,-0.0379015604393656,0.8430347084534353},
{-0.3249952323549118,-0.02849958191419996,0.9452861327541481},
{-0.2767886505140737,-0.033098642817976295,0.9603606212200737},
{-0.19629087366798828,-0.02389888884699399,0.9802544241300504},
{0.5365220890691198,-0.0379015604393656,0.8430347084534353},
{0.3249952323549118,-0.02849958191419996,0.9452861327541481},
{0.47798793095711306,-0.039499002662773994,0.8774778439641563},
{0.2767886505140737,-0.033098642817976295,0.9603606212200737},
{0.19629087366798828,-0.02389888884699399,0.9802544241300504},
{0.6446910227400122,-0.055999220216287705,0.7623893838017454}
};


// face array: 16kb.
const uint16_t naruto_1_face[8249] PROGMEM = {
26, // chain 0
0,0,0, 1,1,1, 2,2,2, 
32771,3,3, 32772,4,4, 5,5,5, 32774,6,6, 7,7,7, 32776,8,8, 9,9,9, 32778,10,10, 32779,11,11, 0,12,0, 2,13,2, 12,14,12, 32781,15,13, 32782,16,14, 15,17,15, 32784,18,16, 
17,19,17, 32786,20,18, 19,21,19, 32788,22,20, 21,23,21, 32790,24,22, 23,25,23, 32792,26,24, 32793,27,25, 
17, // chain 1
9,9,9, 10,10,10, 12,14,12, 
26,28,26, 32795,29,27, 32781,15,13, 28,30,28, 32783,17,15, 17,19,17, 29,31,29, 32798,32,30, 32787,21,19, 31,33,31, 32789,23,21, 32,34,32, 32801,35,33, 32791,25,23, 34,36,34, 32792,26,24, 
38, // chain 2
35,37,35, 36,38,36, 37,39,37, 
38,40,38, 39,41,39, 32808,42,40, 32809,43,41, 42,44,42, 32811,45,43, 32812,46,44, 45,47,45, 32814,48,46, 32815,49,47, 48,50,48, 32817,51,49, 32818,52,50, 51,53,51, 32820,54,52, 32821,55,53, 
54,56,54, 51,53,51, 32823,57,55, 32824,58,56, 32825,59,57, 32826,60,58, 59,61,59, 60,62,60, 32829,63,61, 32830,64,62, 63,65,63, 32832,66,64, 32833,67,65, 66,68,60, 32835,69,66, 32836,70,67, 
36,38,36, 69,71,68, 32838,72,69, 32807,41,39, 32803,37,35, 
9, // chain 3
42,44,42, 43,45,43, 71,73,70, 
32813,47,45, 72,74,71, 32841,75,72, 32814,48,46, 48,50,48, 55,57,55, 32817,51,49, 51,53,51, 
6, // chain 4
72,74,71, 73,75,72, 61,63,61, 
32842,76,73, 32823,57,55, 60,62,60, 32824,58,56, 57,59,57, 
1, // chain 5
61,63,61, 74,76,73, 60,62,60, 
20, // chain 6
75,77,74, 76,78,75, 77,79,76, 
32846,80,77, 32847,81,78, 80,82,79, 32849,83,80, 82,84,81, 32851,85,82, 84,86,83, 32853,87,84, 86,88,85, 32855,89,86, 32856,90,87, 89,91,88, 32858,92,89, 91,93,90, 32860,94,91, 93,95,92, 
32862,96,93, 77,97,76, 32843,98,74, 
30, // chain 7
86,88,85, 87,89,86, 95,99,94, 
32864,100,95, 32857,91,88, 97,101,96, 32866,102,97, 32859,93,90, 93,95,92, 99,103,98, 32868,104,99, 32845,97,76, 101,105,100, 102,106,101, 32871,107,102, 104,108,103, 105,109,104, 32874,110,105, 107,111,106, 
108,112,107, 109,113,108, 110,114,109, 32879,115,110, 32880,116,111, 113,117,112, 32882,118,113, 115,119,114, 116,120,115, 32885,121,116, 118,122,117, 32874,123,105, 32875,124,106, 
13, // chain 8
95,99,94, 96,100,95, 119,125,118, 
32884,120,115, 32865,101,96, 113,117,112, 32879,115,110, 32866,102,97, 120,126,119, 32867,103,98, 100,104,99, 102,106,101, 105,109,104, 110,114,109, 111,115,110, 
3, // chain 9
119,125,118, 116,120,115, 118,122,117, 
104,127,103, 32874,123,105, 
48, // chain 10
121,128,120, 122,129,121, 123,130,122, 
124,131,123, 125,132,124, 32894,133,125, 32895,134,126, 125,132,124, 32896,135,127, 32897,136,128, 32898,137,129, 32899,138,130, 129,136,128, 32896,135,127, 32900,139,131, 32901,140,132, 32902,141,133, 32903,142,134, 32904,143,135, 
134,141,133, 32905,144,136, 32906,145,137, 134,141,133, 32901,140,132, 32907,146,138, 32908,147,139, 32909,148,140, 32910,149,141, 32911,150,142, 141,148,140, 32908,147,139, 32912,151,143, 32913,152,144, 32914,153,145, 144,151,143, 
32915,154,146, 32916,155,147, 149,156,148, 144,151,143, 32918,157,149, 32919,158,150, 139,146,138, 32920,159,151, 32921,160,152, 154,161,153, 132,139,131, 32923,162,154, 32890,129,121, 125,132,124, 32889,128,120, 
2, // chain 11
125,132,124, 128,135,127, 132,139,131, 
155,162,154, 
19, // chain 12
156,20,155, 157,18,156, 158,19,157, 
32927,17,158, 32928,16,159, 161,15,160, 32930,13,161, 163,14,162, 32932,10,163, 32933,12,164, 166,11,165, 167,8,166, 168,9,167, 32937,7,168, 32938,6,169, 171,5,170, 32940,4,171, 173,3,172, 32942,1,173, 
162,2,161, 32933,0,164, 
10, // chain 13
163,14,162, 164,10,163, 168,9,167, 
175,28,174, 32937,7,168, 176,163,175, 32945,164,176, 32939,5,170, 178,165,177, 32941,3,172, 160,166,159, 32930,2,161, 
16, // chain 14
179,167,178, 180,168,179, 181,169,180, 
32950,170,181, 32951,171,182, 184,172,183, 32953,173,184, 186,174,185, 32955,175,186, 188,176,187, 32957,177,188, 190,178,189, 32959,179,190, 192,180,191, 32961,181,192, 194,182,193, 32947,167,178, 181,169,180, 
3, // chain 15
195,183,194, 196,184,195, 197,185,196, 
198,186,197, 32967,187,196, 
5, // chain 16
196,184,195, 195,183,194, 200,188,198, 
32969,189,199, 32970,190,200, 32971,191,201, 32966,186,197, 
7, // chain 17
200,188,198, 201,189,199, 204,192,202, 
32973,193,203, 32788,194,20, 32790,195,22, 32970,190,200, 25,196,25, 32971,191,201, 
6, // chain 18
204,192,202, 205,193,203, 206,197,204, 
32975,198,205, 32976,199,206, 32784,200,16, 32786,201,18, 32788,194,20, 
9, // chain 19
206,197,204, 207,198,205, 209,202,207, 
32978,203,208, 32976,199,206, 211,164,209, 32980,165,210, 32784,200,16, 14,166,14, 3,3,3, 32770,2,2, 
7, // chain 20
209,202,207, 210,203,208, 213,204,211, 
32982,163,212, 32979,164,209, 7,7,7, 32773,5,5, 32980,165,210, 3,3,3, 
4, // chain 21
213,204,211, 214,163,212, 27,29,27, 
32794,28,26, 32775,7,7, 9,9,9, 
16, // chain 22
215,205,213, 216,206,214, 217,207,215, 
218,208,216, 32987,209,217, 220,210,218, 32989,211,219, 222,212,220, 32991,213,221, 224,214,222, 32993,212,223, 32994,211,224, 227,210,225, 32996,209,226, 229,208,227, 32998,207,228, 215,205,213, 32984,206,214, 
21, // chain 23
231,215,229, 222,212,220, 224,214,222, 
225,212,223, 232,216,230, 32995,210,225, 233,217,231, 32997,208,227, 234,218,232, 33003,219,233, 32983,205,213, 218,208,216, 236,218,234, 33005,217,235, 32988,210,218, 238,216,236, 32990,212,220, 231,215,229, 62,220,62, 
59,221,59, 239,222,237, 32826,223,58, 240,224,238, 
19, // chain 24
241,225,239, 104,127,103, 242,226,240, 
243,227,241, 244,228,239, 33013,229,242, 246,230,243, 33015,231,244, 248,232,245, 249,233,246, 33018,234,247, 251,235,248, 252,236,249, 33021,237,250, 254,238,251, 33023,239,252, 256,240,253, 33025,241,254, 258,242,255, 
33013,243,242, 33015,244,244, 
16, // chain 25
104,127,103, 241,225,239, 259,245,256, 
33028,246,257, 33012,228,239, 261,247,258, 33014,230,243, 249,233,246, 252,236,249, 262,248,259, 33022,238,251, 263,249,260, 33024,240,253, 264,250,261, 33026,242,255, 265,251,262, 33011,252,241, 33013,243,242, 
4, // chain 26
259,245,256, 260,246,257, 266,253,263, 
33035,254,264, 33030,248,259, 33029,247,258, 
4, // chain 27
266,253,263, 267,254,264, 268,255,265, 
33037,256,260, 33031,249,260, 33030,248,259, 
4, // chain 28
268,255,265, 269,256,260, 270,257,266, 
33039,258,261, 33032,250,261, 33031,249,260, 
4, // chain 29
270,257,266, 271,258,261, 272,259,267, 
33041,260,268, 33033,251,262, 33032,250,261, 
5, // chain 30
272,259,267, 273,260,268, 274,261,269, 
32872,262,103, 33010,263,240, 33033,251,262, 243,252,241, 
14, // chain 31
274,261,269, 104,262,103, 103,264,102, 
101,265,100, 275,266,270, 32845,79,76, 78,80,77, 276,267,271, 33038,257,266, 32848,82,79, 82,84,81, 268,255,265, 33034,253,263, 32852,86,83, 95,99,94, 32854,88,85, 
20, // chain 32
277,268,272, 278,269,273, 279,269,274, 
280,268,275, 33049,269,276, 282,268,277, 33051,269,278, 284,268,279, 33053,269,280, 286,268,281, 33055,269,282, 288,268,283, 33057,268,284, 33058,269,285, 291,268,286, 33060,269,287, 293,268,288, 33062,269,289, 295,268,290, 
33064,269,291, 277,268,272, 33046,269,273, 
20, // chain 33
297,269,292, 286,268,281, 288,268,283, 
289,268,284, 298,269,293, 33059,268,286, 299,269,294, 33061,268,288, 300,269,295, 33063,268,290, 301,269,296, 33045,268,272, 302,269,297, 33071,269,298, 33048,268,275, 304,269,299, 33050,268,277, 305,269,300, 33052,268,279, 
306,269,301, 33054,268,281, 297,269,292, 
16, // chain 34
307,270,302, 308,271,303, 309,272,304, 
310,273,305, 311,274,306, 312,275,307, 313,276,308, 314,277,309, 33083,278,310, 33084,279,311, 317,280,312, 33086,281,313, 319,282,314, 33088,283,315, 321,284,316, 33090,285,317, 310,286,305, 33079,287,306, 
12, // chain 35
308,271,303, 307,270,302, 314,277,309, 
323,288,318, 33092,289,319, 33083,278,310, 325,290,320, 33085,280,312, 326,291,321, 33087,282,314, 327,292,322, 33089,284,316, 309,293,304, 33078,286,305, 
28, // chain 36
247,244,323, 257,241,324, 328,294,325, 
33097,295,326, 33023,239,327, 330,296,328, 33021,237,329, 331,297,330, 33019,235,331, 332,298,332, 33018,234,333, 333,299,334, 33102,300,335, 33016,232,336, 247,231,323, 328,301,325, 335,302,337, 336,303,338, 333,299,334, 
33105,304,246, 338,305,339, 332,298,332, 33107,306,340, 331,297,330, 33108,307,341, 330,296,328, 33109,308,342, 329,295,326, 33103,309,337, 328,294,325, 
66, // chain 37
342,310,343, 343,311,344, 344,312,345, 
345,313,346, 346,314,347, 347,315,348, 33116,316,349, 349,317,350, 33118,317,351, 351,318,352, 352,319,353, 33121,320,354, 354,321,355, 33123,322,356, 356,323,357, 33125,324,358, 358,325,359, 33127,326,360, 33128,327,361, 
361,328,362, 33130,329,363, 363,330,364, 364,331,365, 33133,332,366, 33134,333,367, 367,334,368, 368,335,369, 33137,336,370, 370,337,371, 33139,338,372, 372,339,373, 33141,340,374, 33142,341,375, 375,342,376, 33144,343,377, 
377,344,364, 378,345,378, 33147,346,379, 33148,347,380, 381,348,381, 382,349,382, 33151,350,383, 384,351,384, 33153,352,385, 386,353,386, 33155,354,387, 33156,355,388, 389,356,389, 33158,357,390, 391,358,391, 392,359,392, 
33161,360,393, 33162,361,394, 395,362,395, 396,363,396, 33165,364,397, 398,365,398, 33167,366,399, 33168,367,400, 401,368,401, 33170,369,402, 403,370,403, 33172,371,404, 405,372,405, 393,360,393, 33160,359,392, 33174,373,406, 
33175,374,407, 
12, // chain 38
343,311,344, 342,310,343, 408,375,408, 
33177,376,409, 33115,315,348, 410,377,410, 33132,331,365, 33117,317,350, 352,319,353, 361,328,362, 33127,326,360, 33122,321,355, 358,325,359, 33124,323,357, 
12, // chain 39
408,375,408, 409,376,409, 411,378,411, 
33178,377,410, 406,373,406, 33160,359,392, 33146,345,378, 33132,331,365, 365,332,366, 375,342,376, 33141,340,374, 33136,335,369, 372,339,373, 33138,337,371, 
4, // chain 40
401,368,401, 403,370,403, 393,360,393, 
396,363,396, 398,365,398, 399,366,399, 
5, // chain 41
408,375,408, 411,378,411, 412,379,412, 
33181,380,413, 33182,381,414, 33183,382,415, 33174,373,406, 
5, // chain 42
413,380,413, 414,381,414, 416,383,416, 
33185,384,417, 33186,385,418, 33187,386,419, 33183,382,415, 
4, // chain 43
416,383,416, 417,384,417, 420,387,420, 
33189,388,421, 33190,389,422, 33186,385,418, 
2, // chain 44
420,387,420, 421,388,421, 422,389,422, 
423,390,423, 
61, // chain 45
424,368,424, 425,369,425, 426,367,426, 
427,366,427, 33196,364,428, 429,365,429, 33198,363,430, 33199,362,431, 432,360,432, 33201,361,433, 434,358,434, 435,359,435, 33204,356,436, 33205,357,437, 438,355,438, 439,354,439, 33208,352,440, 441,353,441, 33210,351,442, 
33211,350,443, 444,349,444, 33213,348,445, 446,346,446, 33215,347,447, 448,344,448, 449,345,449, 33218,342,450, 33219,343,451, 452,341,452, 453,340,453, 33222,338,454, 455,339,455, 33224,337,456, 33225,336,457, 458,335,458, 
33227,334,459, 460,332,460, 33229,333,461, 462,330,448, 463,331,462, 33232,328,463, 33233,329,464, 466,327,465, 467,326,466, 33236,324,467, 469,325,468, 33238,323,469, 33239,322,470, 472,321,471, 33241,320,472, 474,319,473, 
33243,318,474, 476,317,475, 33245,317,476, 478,316,477, 479,315,478, 33248,314,479, 481,310,480, 33250,313,481, 483,312,482, 484,311,483, 485,375,484, 33254,391,485, 
5, // chain 46
425,369,425, 424,368,424, 487,370,486, 
33200,360,432, 33198,363,430, 33197,365,429, 33195,366,427, 
11, // chain 47
487,370,486, 432,360,432, 488,372,487, 
33203,359,435, 489,373,488, 33258,377,489, 33217,345,449, 33214,346,446, 33204,356,436, 439,354,439, 444,349,444, 33209,353,441, 442,351,442, 
11, // chain 48
489,373,488, 490,377,489, 491,378,490, 
33260,376,491, 33247,315,478, 33231,331,462, 33217,345,449, 460,332,460, 33218,342,450, 453,340,453, 458,335,458, 33223,339,455, 456,337,456, 
3, // chain 49
491,378,490, 492,376,491, 485,375,484, 
33249,310,480, 33247,315,478, 
3, // chain 50
493,381,492, 494,386,493, 495,382,494, 
491,378,490, 33257,373,488, 
7, // chain 51
494,386,493, 493,381,492, 496,385,495, 
33265,384,496, 33266,383,497, 33267,380,498, 33259,378,490, 500,379,499, 33253,375,484, 
4, // chain 52
496,385,495, 497,384,496, 501,389,500, 
33270,388,501, 33271,387,502, 33266,383,497, 
2, // chain 53
501,389,500, 502,388,501, 503,387,502, 
504,390,503, 
48, // chain 54
505,392,504, 506,393,505, 507,394,506, 
508,395,507, 33277,396,508, 33278,397,509, 511,398,510, 33280,399,511, 513,400,512, 514,401,513, 33283,402,514, 516,403,515, 33285,404,516, 518,405,516, 33287,403,517, 33288,402,518, 521,401,519, 33290,400,520, 523,398,521, 
33292,399,522, 525,397,523, 526,396,524, 33295,394,525, 528,406,526, 33297,392,527, 33298,393,528, 531,407,529, 33300,408,529, 506,393,505, 505,392,504, 533,409,530, 33302,410,531, 33276,395,507, 535,411,532, 33304,412,533, 
33277,396,508, 511,398,510, 537,413,534, 538,414,535, 539,415,536, 33308,412,537, 33309,413,538, 523,398,521, 526,396,524, 528,406,526, 542,411,539, 33311,410,540, 33297,392,527, 533,409,530, 33299,407,529, 
4, // chain 55
539,415,536, 540,412,537, 542,411,539, 
544,416,541, 535,411,532, 536,412,533, 
24, // chain 56
545,412,542, 546,413,543, 547,398,544, 
548,396,545, 33317,397,546, 33318,399,547, 33319,400,548, 33320,401,549, 553,402,550, 33322,403,551, 555,404,552, 33324,405,552, 557,403,553, 558,402,554, 33327,401,555, 560,400,556, 33329,398,557, 562,399,558, 33331,397,559, 
33332,396,560, 33333,412,561, 33334,413,562, 567,414,563, 568,415,564, 33313,412,542, 33314,413,543, 
8, // chain 57
569,411,565, 565,412,561, 568,415,564, 
570,416,566, 33339,411,567, 33313,412,542, 572,395,568, 33316,396,545, 573,394,569, 33317,397,546, 
9, // chain 58
565,412,561, 569,411,565, 574,406,570, 
33343,410,571, 576,392,572, 33345,409,573, 578,407,574, 33347,392,575, 33348,410,576, 572,395,568, 33339,411,567, 
3, // chain 59
578,407,574, 579,392,575, 581,393,577, 
33341,394,569, 33340,395,568, 
12, // chain 60
582,417,578, 583,418,579, 584,419,580, 
33353,420,581, 33354,421,582, 587,422,583, 33356,423,584, 589,424,585, 33358,425,586, 591,426,587, 33360,427,588, 593,428,589, 33350,429,578, 584,430,580, 
4, // chain 61
594,431,590, 312,275,591, 311,274,592, 
595,432,593, 596,433,594, 33365,434,595, 
3, // chain 62
312,275,591, 594,431,590, 598,435,318, 
33367,436,596, 33364,433,594, 
12, // chain 63
598,435,318, 599,436,596, 600,437,597, 
33369,438,598, 602,439,599, 33371,440,600, 604,441,601, 33373,442,602, 606,443,603, 33375,444,604, 597,445,595, 595,446,593, 322,285,605, 33079,287,592, 
3, // chain 64
608,447,606, 0,0,607, 609,448,608, 
610,449,1, 33379,450,0, 
4, // chain 65
0,0,607, 608,447,606, 1,1,609, 
33380,451,610, 33381,452,611, 33378,449,1, 
4, // chain 66
1,1,609, 612,451,610, 4,4,612, 
33382,453,613, 33383,454,614, 33381,452,611, 
4, // chain 67
4,4,612, 614,453,613, 6,6,615, 
33384,455,616, 33385,456,617, 33383,454,614, 
4, // chain 68
6,6,615, 616,455,616, 8,8,618, 
33386,457,619, 33387,458,620, 33385,456,617, 
4, // chain 69
8,8,618, 618,457,619, 11,11,621, 
33377,459,608, 33379,460,0, 33387,458,620, 
1, // chain 70
11,11,621, 609,459,608, 0,12,607, 
12, // chain 71
343,461,622, 620,462,623, 611,450,624, 
33378,449,625, 33389,463,626, 613,452,627, 33390,464,628, 615,454,629, 33113,465,630, 617,456,631, 33112,466,632, 619,458,633, 33111,467,622, 611,460,624, 
12, // chain 72
623,430,634, 624,428,634, 625,468,634, 
33394,469,634, 33395,426,634, 628,470,634, 33397,424,634, 630,471,634, 33399,422,634, 632,472,634, 33401,420,634, 634,473,634, 33391,419,634, 625,474,634, 
16, // chain 73
625,475,635, 626,476,636, 635,477,637, 
33404,478,638, 33396,479,639, 637,480,640, 33398,481,641, 638,482,642, 33400,483,643, 639,484,644, 33402,485,645, 640,486,646, 33393,487,635, 635,488,637, 641,489,647, 33410,490,648, 643,491,649, 33412,492,650, 
12, // chain 74
635,477,637, 636,478,638, 642,493,648, 
33413,494,651, 33405,480,640, 646,495,652, 33406,482,642, 647,496,653, 33407,484,644, 648,497,654, 33408,486,646, 641,489,647, 649,498,655, 33411,491,649, 
8, // chain 75
642,493,648, 645,494,651, 644,492,650, 
33418,499,656, 33414,495,652, 651,500,657, 33415,496,653, 652,501,658, 33416,497,654, 649,498,655, 
24, // chain 76
653,502,659, 654,503,660, 655,504,661, 
656,505,662, 33425,506,663, 658,507,664, 659,508,665, 33428,509,666, 661,510,667, 33430,511,668, 33431,512,669, 664,513,670, 33433,514,671, 666,515,672, 667,516,673, 33422,503,660, 668,517,674, 33421,502,659, 656,505,662, 
669,518,675, 33427,508,665, 661,510,667, 662,511,668, 664,513,670, 668,517,674, 33435,516,673, 
5, // chain 77
467,326,466, 472,321,471, 474,319,473, 
464,328,463, 33231,331,462, 33244,317,475, 479,315,478, 
2, // chain 78
472,321,471, 467,326,466, 469,325,468, 
470,323,469, 
32, // chain 79
670,519,676, 671,520,677, 672,521,678, 
673,522,679, 674,523,680, 675,524,681, 33444,525,682, 33445,526,683, 678,527,684, 33447,528,685, 33448,529,686, 681,530,687, 682,531,688, 33451,532,689, 33452,533,690, 685,534,691, 686,535,692, 33455,536,693, 33456,537,694, 
689,538,695, 690,539,696, 33459,540,697, 33460,541,698, 693,542,699, 33462,543,700, 33463,544,701, 696,545,702, 697,546,703, 693,542,699, 33466,547,704, 33467,548,705, 671,520,677, 675,524,681, 33438,519,676, 
8, // chain 80
678,527,684, 679,528,685, 682,531,688, 
700,549,706, 33469,550,707, 33451,532,689, 686,535,692, 702,551,708, 33458,539,696, 33455,536,693, 
16, // chain 81
703,552,709, 154,553,153, 153,554,152, 
151,555,150, 704,556,710, 33473,557,711, 32917,558,148, 706,559,712, 33475,560,713, 32916,561,147, 708,562,714, 706,559,712, 33477,563,715, 33478,564,716, 688,565,694, 33479,566,717, 33457,567,695, 688,565,694, 
8, // chain 82
154,553,153, 703,552,709, 712,568,718, 
33481,569,719, 33472,556,710, 714,570,720, 33453,571,691, 33483,572,721, 33474,559,712, 33473,557,711, 
4, // chain 83
712,568,718, 713,569,719, 714,570,720, 
681,573,687, 33452,574,690, 33453,571,691, 
3, // chain 84
685,571,691, 715,572,721, 688,565,694, 
33474,559,712, 709,563,715, 
36, // chain 85
716,575,722, 717,576,723, 695,577,701, 
692,578,698, 718,579,724, 33487,580,725, 33457,581,695, 710,582,716, 718,579,724, 33488,583,726, 33476,584,714, 721,585,727, 33490,586,728, 32916,587,147, 723,588,729, 721,585,727, 33492,589,730, 33493,590,731, 726,591,732, 
33495,592,733, 33496,593,734, 726,591,732, 33492,589,730, 33497,594,735, 33498,595,736, 33499,596,737, 729,594,735, 33492,589,730, 33489,585,727, 33500,597,738, 33501,598,739, 33502,599,740, 33503,600,741, 733,598,739, 33500,597,738, 
33486,579,724, 33484,575,722, 33485,576,723, 
2, // chain 86
721,585,727, 732,597,738, 718,579,724, 
720,583,726, 
12, // chain 87
736,601,742, 737,602,743, 738,603,744, 
739,604,745, 740,605,746, 33509,606,747, 742,607,748, 33511,608,749, 33512,609,750, 745,610,751, 33514,611,752, 737,602,743, 33515,612,753, 738,603,744, 
6, // chain 88
737,602,743, 736,601,742, 748,613,754, 
33508,605,746, 742,607,748, 743,608,749, 745,610,751, 737,602,743, 
36, // chain 89
534,614,755, 535,615,756, 749,616,757, 
33518,617,758, 33312,618,759, 751,619,760, 33310,615,761, 752,617,762, 33311,614,763, 753,616,764, 33301,620,765, 754,621,766, 33302,614,755, 749,616,757, 755,622,767, 33518,617,758, 756,623,768, 33519,619,760, 757,624,769, 
33526,625,770, 33520,617,762, 753,616,764, 759,626,771, 33522,621,766, 760,627,772, 33523,622,767, 761,628,773, 33530,629,774, 33524,623,768, 763,630,775, 33532,631,776, 33525,624,769, 758,625,770, 765,630,777, 33527,626,771, 
766,629,778, 33529,628,773, 33528,627,772, 
12, // chain 90
762,629,774, 763,630,775, 767,632,779, 
33536,633,780, 33532,631,776, 769,634,781, 33533,630,777, 770,633,782, 33534,629,778, 771,632,783, 33529,628,773, 772,635,784, 33530,629,774, 767,632,779, 
12, // chain 91
555,636,785, 558,637,785, 553,638,785, 
33319,639,785, 33328,640,785, 550,641,785, 33330,642,785, 549,643,785, 33331,644,785, 573,645,785, 33541,646,785, 581,647,785, 33542,648,785, 775,649,785, 
48, // chain 92
571,615,786, 580,614,787, 776,616,788, 
33545,621,789, 33345,620,790, 778,616,791, 33343,614,792, 779,617,793, 33337,615,794, 780,619,795, 33338,618,796, 781,617,797, 33339,615,786, 776,616,788, 782,622,798, 33545,621,789, 783,627,799, 33552,626,800, 33546,616,791, 
785,625,801, 33547,617,793, 780,619,795, 786,624,802, 33555,623,803, 33549,617,797, 782,622,798, 788,629,804, 33557,628,805, 33551,627,799, 784,626,800, 790,629,806, 33559,630,807, 33553,625,801, 792,631,808, 33554,624,802, 
787,623,803, 793,630,809, 33556,629,804, 794,632,810, 33563,635,811, 33557,628,805, 796,632,812, 33558,629,806, 797,633,813, 33559,630,807, 798,634,814, 33560,631,808, 799,633,815, 33561,630,809, 794,632,810, 
11, // chain 93
800,468,816, 801,469,816, 593,428,816, 
33359,426,816, 33570,470,816, 589,424,816, 33571,471,816, 587,422,816, 33572,472,816, 585,420,816, 33573,473,816, 584,419,816, 33568,474,816, 
15, // chain 94
806,478,817, 801,476,818, 807,477,819, 
808,493,820, 809,494,821, 33578,492,822, 811,499,823, 812,495,824, 33581,500,825, 814,496,826, 33583,501,827, 816,497,828, 33585,498,829, 818,489,830, 33587,491,831, 808,490,820, 33578,492,822, 
12, // chain 95
801,476,818, 806,478,817, 802,479,832, 
33588,480,833, 33577,494,821, 812,495,824, 821,482,834, 33582,496,826, 822,484,835, 33584,497,828, 823,486,836, 33586,489,830, 807,488,819, 33576,490,820, 
8, // chain 96
802,479,832, 820,480,833, 803,481,837, 
33589,482,834, 804,483,838, 33590,484,835, 805,485,839, 33591,486,836, 800,487,840, 33575,488,819, 
9, // chain 97
312,275,591, 598,435,318, 313,276,841, 
33084,279,842, 33368,437,597, 318,281,843, 33370,439,599, 320,283,844, 33372,441,601, 322,285,605, 33374,443,603, 
11, // chain 98
623,419,845, 633,420,846, 824,418,635, 
33593,421,847, 33399,422,848, 826,423,849, 33397,424,850, 827,425,851, 33395,426,852, 828,427,853, 33392,428,854, 829,429,855, 33391,430,845, 
11, // chain 99
165,0,856, 174,1,857, 830,447,858, 
33599,451,859, 32940,4,860, 832,453,861, 32938,6,862, 833,455,863, 32935,8,864, 834,457,865, 32934,11,866, 835,459,867, 32933,12,856, 
2, // chain 100
830,447,858, 836,449,173, 835,448,867, 
165,0,856, 
10, // chain 101
836,449,173, 830,447,858, 837,452,868, 
33599,451,859, 838,454,869, 33600,453,861, 839,456,870, 33601,455,863, 840,458,871, 33602,457,865, 841,460,164, 33603,459,867, 
11, // chain 102
841,450,872, 836,449,873, 486,462,874, 
33610,463,875, 33605,452,876, 843,464,877, 33606,454,878, 844,465,879, 33607,456,880, 845,466,881, 33608,458,882, 484,467,883, 33609,460,872, 
5, // chain 103
846,650,884, 847,651,885, 848,652,886, 
204,192,202, 33617,653,887, 200,188,198, 32964,184,195, 
3, // chain 104
847,651,885, 846,650,884, 850,654,216, 
32974,197,204, 32972,192,202, 
7, // chain 105
850,654,216, 206,197,204, 851,655,888, 
32977,202,207, 852,656,889, 32981,204,211, 29,31,29, 32796,30,28, 32795,29,27, 
11, // chain 106
620,657,890, 408,658,408, 621,659,891, 
33621,660,892, 33175,661,407, 33180,662,412, 854,663,893, 33181,664,413, 855,665,894, 33624,666,895, 33184,667,416, 423,668,423, 33188,669,420, 
9, // chain 107
853,660,892, 407,661,407, 857,670,896, 
33173,671,405, 858,672,897, 33172,673,404, 394,674,394, 33170,675,402, 395,676,395, 33165,677,397, 33168,678,400, 
6, // chain 108
378,345,378, 379,346,379, 392,359,392, 
33157,356,389, 33155,354,387, 33150,349,382, 386,353,386, 33152,351,384, 
2, // chain 109
425,675,425, 431,676,431, 428,677,428, 
426,678,426, 
18, // chain 110
431,676,431, 425,675,425, 433,674,433, 
33627,673,898, 860,672,899, 33256,671,487, 861,670,900, 33630,661,901, 863,660,902, 33253,658,484, 33268,662,499, 33632,663,903, 33257,679,488, 495,680,494, 865,665,904, 33262,681,493, 866,666,905, 33264,682,495, 504,668,503, 
33269,683,500, 
2, // chain 111
863,660,902, 485,658,484, 842,659,906, 
33254,657,485, 
36, // chain 112
867,684,907, 868,685,908, 869,686,909, 
33638,687,910, 33639,688,911, 33640,689,912, 33641,690,913, 33642,691,914, 872,689,912, 33639,688,911, 33643,692,915, 33644,693,916, 33645,694,917, 33646,695,918, 33647,696,919, 877,694,917, 33644,693,916, 33648,697,920, 33649,698,921, 
33650,699,922, 880,697,920, 33644,693,916, 33651,700,923, 875,692,915, 33652,701,924, 32891,702,122, 885,703,925, 875,692,915, 33654,704,926, 33655,705,927, 870,687,910, 33656,706,928, 33445,707,683, 674,708,680, 870,687,910, 
33637,686,909, 33441,709,679, 867,684,907, 
2, // chain 113
870,687,910, 871,688,911, 875,692,915, 
886,704,926, 
4, // chain 114
152,159,151, 132,139,131, 889,710,929, 
32901,140,132, 139,146,138, 152,159,151, 
8, // chain 115
70,72,69, 39,41,39, 40,42,40, 
42,44,42, 71,73,70, 890,711,930, 32832,66,64, 32840,74,71, 63,65,63, 32829,63,61, 
4, // chain 116
66,68,60, 67,69,66, 69,71,68, 
70,72,69, 890,711,930, 64,66,64, 
17, // chain 117
44,712,754, 41,713,931, 136,714,932, 
32911,715,933, 32806,716,934, 728,717,935, 33659,718,936, 32805,719,39, 892,720,937, 893,721,938, 33662,722,939, 895,723,940, 896,724,941, 33665,725,942, 898,726,943, 33667,727,944, 900,728,945, 901,729,946, 902,730,947, 
12, // chain 118
728,717,935, 891,718,936, 903,731,948, 
33661,721,938, 717,732,949, 33664,724,941, 696,733,950, 33467,734,951, 33666,726,943, 904,735,952, 33670,736,947, 905,737,953, 906,738,954, 33675,739,955, 
20, // chain 119
908,740,956, 34,741,957, 24,742,958, 
909,743,959, 32793,744,960, 910,745,961, 32971,744,962, 911,745,963, 32966,742,964, 912,746,965, 32967,741,966, 913,740,967, 33682,743,968, 33683,742,969, 916,745,970, 33685,744,971, 918,745,972, 33687,744,973, 920,743,974, 
33689,742,975, 908,740,956, 32802,741,957, 
20, // chain 120
908,740,976, 278,741,977, 296,742,978, 
920,743,979, 33062,744,980, 918,745,981, 33060,744,982, 916,745,983, 33058,742,984, 914,743,985, 33055,741,283, 913,740,986, 33680,746,987, 33053,742,988, 911,745,989, 33051,744,990, 910,745,991, 33049,744,992, 909,743,993, 
33047,742,994, 908,740,976, 33046,741,977, 
11, // chain 121
515,638,785, 513,639,785, 520,637,785, 
33290,640,785, 33280,641,785, 524,642,785, 33278,643,785, 525,644,785, 33275,645,785, 527,646,785, 33274,647,785, 530,648,785, 33300,649,785, 
11, // chain 122
922,747,995, 923,747,996, 767,747,997, 
33540,747,996, 33692,747,998, 771,747,999, 33693,747,1000, 770,747,1001, 33694,747,1002, 769,747,1003, 33690,747,995, 768,747,995, 33535,747,997, 
11, // chain 123
927,747,1004, 799,747,1004, 794,747,1005, 
928,747,1006, 33563,747,1006, 929,747,1007, 33564,747,1008, 930,747,1009, 33565,747,1010, 931,747,1011, 33566,747,1012, 927,747,1004, 33567,747,1004, 
2, // chain 124
607,748,604, 108,749,107, 107,750,106, 
597,751,595, 
12, // chain 125
108,749,107, 607,748,604, 109,752,108, 
33373,753,602, 112,754,111, 33371,755,600, 114,756,113, 33369,757,598, 115,758,114, 33367,759,596, 596,760,594, 117,761,116, 33365,762,595, 107,763,106, 
12, // chain 126
335,309,1013, 341,308,1014, 932,764,1015, 
33701,765,1016, 33108,307,1017, 934,766,1018, 33107,306,1019, 935,767,1020, 33106,305,1021, 936,768,1022, 33105,304,1023, 336,303,1024, 335,302,1013, 932,769,1015, 
22, // chain 127
216,770,1025, 937,771,1026, 938,772,1027, 
217,773,1028, 33707,774,1029, 33708,775,1030, 33709,776,1031, 33705,771,1026, 942,777,1032, 33711,778,1033, 33712,772,1034, 32984,770,1025, 230,773,1035, 945,774,1036, 32996,779,1037, 946,780,1038, 32994,781,1039, 947,782,1040, 32991,783,1041, 
221,781,1042, 948,780,1043, 32987,779,1044, 939,774,1029, 32985,773,1028, 
31, // chain 128
949,654,227, 950,650,1045, 847,651,885, 
33616,652,886, 33719,192,1046, 849,784,887, 33720,188,1047, 196,785,195, 33721,183,1048, 33722,189,1049, 33719,786,1046, 955,193,1050, 33724,787,1051, 33718,788,1045, 949,654,227, 957,789,1052, 33726,790,1053, 959,791,1054, 33728,792,1055, 
961,793,1056, 962,31,1057, 33731,794,1058, 158,795,157, 33732,796,1059, 32799,33,31, 965,23,1060, 32800,34,32, 33,35,33, 966,797,1061, 32802,36,34, 921,26,1062, 967,24,1063, 33687,27,1064, 
9, // chain 129
196,785,195, 953,183,1048, 197,798,196, 
33683,186,1065, 33685,191,1066, 33736,799,1067, 33722,189,1049, 967,800,1063, 33737,194,1068, 33723,193,1050, 156,801,155, 
1, // chain 130
197,798,196, 915,186,1065, 199,802,196, 
8, // chain 131
676,525,682, 678,527,684, 675,524,681, 
33468,549,706, 970,803,1069, 33469,550,707, 702,551,708, 693,542,699, 33458,539,696, 691,540,697, 
9, // chain 132
323,304,1070, 324,305,1071, 971,768,1072, 
33740,767,1073, 33093,306,1074, 973,766,1075, 33094,307,1076, 974,765,1077, 33095,308,1078, 975,764,1079, 33077,309,1080, 
9, // chain 133
976,804,1081, 977,805,1082, 978,806,1083, 
33747,807,1084, 33748,808,1085, 981,809,1086, 33750,810,1087, 983,811,1088, 33752,812,1089, 985,813,1090, 33744,814,1081, 
9, // chain 134
986,815,1091, 987,816,1088, 988,817,1092, 
33757,818,1087, 33758,819,1086, 991,820,1085, 33760,821,1084, 993,822,1093, 33762,823,1094, 985,824,1090, 33754,825,1091, 
16, // chain 135
942,777,1032, 847,826,1095, 850,827,1096, 
941,778,1031, 33763,828,1097, 940,775,1030, 33764,829,1098, 997,830,1099, 33766,831,1100, 999,832,1101, 33768,830,1102, 33728,829,1103, 1001,775,1104, 33726,828,1105, 943,778,1033, 33717,827,1106, 942,777,1032, 33615,826,1095, 
10, // chain 136
943,778,1033, 944,772,1034, 1001,775,1104, 
33713,774,1036, 1000,830,1102, 33714,780,1038, 999,832,1101, 33715,782,1040, 948,780,1043, 997,830,1099, 33707,774,1029, 940,775,1030, 
3, // chain 137
1002,199,1107, 178,165,177, 157,200,156, 
955,193,1050, 32924,201,155, 
4, // chain 138
178,165,177, 1002,199,1107, 177,164,176, 
33771,203,1108, 33772,198,1109, 33723,193,1050, 
4, // chain 139
177,164,176, 1003,203,1108, 176,163,175, 
33773,204,1110, 33774,202,1111, 33772,198,1109, 
5, // chain 140
176,163,175, 1005,204,1110, 1007,29,1112, 
33776,30,1113, 33730,31,1057, 33777,656,1114, 33774,202,1111, 
4, // chain 141
1007,29,1112, 1008,30,1113, 161,15,160, 
32927,17,158, 32926,19,157, 33730,31,1057, 
3, // chain 142
176,163,175, 1007,29,1112, 175,28,174, 
32931,14,162, 32929,15,160, 
19, // chain 143
1010,833,1115, 887,834,927, 885,835,925, 
1011,836,1116, 33780,837,1117, 32891,838,122, 122,839,121, 1011,836,1116, 33781,840,1118, 32922,553,153, 712,568,718, 1011,836,1116, 33782,841,1119, 33449,573,687, 680,842,686, 1011,836,1116, 33778,833,1115, 33655,834,927, 33783,843,1120, 
33445,844,683, 887,834,927, 
2, // chain 144
144,151,143, 150,157,149, 139,146,138, 
140,147,139, 
40, // chain 145
1016,845,1121, 1017,845,1122, 1018,845,1123, 
1019,845,1124, 33788,845,1125, 33789,845,1126, 1022,845,1127, 33791,845,1128, 1024,845,1129, 1025,845,1130, 33794,845,1131, 1027,845,1132, 33796,845,76, 1029,845,1133, 33798,845,1134, 33799,845,1135, 1032,845,1136, 33801,845,1137, 1034,845,1138, 
33803,845,1139, 1017,845,1122, 1016,845,1121, 299,845,1140, 33066,845,1141, 33787,845,1124, 297,845,1142, 33074,845,1143, 33788,845,1125, 305,845,1144, 33790,845,1127, 1025,845,1130, 304,845,1145, 33795,845,1132, 303,845,1146, 33797,845,1133, 
302,845,1147, 33069,845,1148, 33798,845,1134, 300,845,1149, 33800,845,1136, 299,845,1140, 33802,845,1138, 
7, // chain 146
565,412,561, 574,406,570, 564,396,560, 
33541,394,1150, 33344,392,572, 774,393,1151, 33346,407,574, 775,408,574, 33349,393,577, 
8, // chain 147
985,813,1152, 988,846,1152, 983,811,1152, 
33749,809,1152, 33757,847,1152, 979,807,1152, 33759,848,1152, 978,806,1152, 33761,849,1152, 985,850,1152, 
6, // chain 148
962,31,1057, 1009,851,1114, 959,791,1054, 
33725,789,1052, 33774,202,1111, 956,787,1051, 33772,852,1109, 955,193,1050, 
4, // chain 149
1036,853,1153, 346,854,347, 345,855,346, 
622,856,1154, 853,660,892, 33389,659,891, 
7, // chain 150
346,854,347, 1036,853,1153, 348,857,349, 
33805,858,1155, 33621,660,892, 857,670,896, 391,859,391, 33626,672,897, 394,674,394, 
9, // chain 151
348,857,349, 1037,858,1155, 363,860,364, 
33145,861,364, 33159,859,391, 380,862,380, 33158,863,390, 388,864,388, 381,865,381, 33153,866,385, 383,867,383, 
6, // chain 152
363,860,364, 377,861,364, 366,868,367, 
33144,869,377, 374,870,375, 367,871,368, 33139,872,372, 369,873,370, 
8, // chain 153
422,683,422, 418,682,418, 423,668,423, 
33624,666,895, 33187,681,419, 855,665,894, 33183,680,415, 854,663,893, 33174,679,406, 407,661,407, 
2, // chain 154
693,542,699, 698,547,704, 970,803,1069, 
33443,524,681, 
20, // chain 155
1028,874,1156, 75,875,74, 94,876,93, 
1031,877,1157, 32860,878,91, 1033,879,1158, 32858,880,89, 1035,881,1159, 33785,882,1160, 32856,883,87, 1018,884,1161, 32853,885,84, 83,883,82, 1021,882,1162, 32849,880,80, 1023,881,1163, 33792,879,1164, 32847,878,78, 1026,877,1165, 
32844,876,75, 1028,874,1156, 32843,875,74, 
3, // chain 156
270,257,266, 272,259,267, 276,267,271, 
33043,266,270, 33042,261,269, 
3, // chain 157
969,22,1068, 964,796,1059, 965,23,1060, 
967,24,1063, 33734,797,1061, 
12, // chain 158
1038,853,1166, 843,856,1167, 482,855,481, 
480,854,479, 478,857,477, 1039,858,1168, 33230,860,448, 33245,886,476, 475,887,474, 465,888,464, 33241,889,472, 466,890,465, 33236,891,467, 33239,892,470, 
12, // chain 159
843,856,1167, 1038,853,1166, 863,660,902, 
33807,858,1168, 861,670,900, 33202,859,434, 33216,861,448, 33230,860,448, 461,868,461, 451,869,451, 33220,870,452, 33227,871,459, 454,872,454, 33225,873,457, 
2, // chain 160
861,670,900, 434,859,434, 860,672,899, 
33201,674,433, 
4, // chain 161
499,664,498, 865,665,904, 866,666,905, 
498,667,497, 33272,668,503, 503,669,502, 
2, // chain 162
865,665,904, 499,664,498, 864,663,903, 
33268,662,499, 
6, // chain 163
448,861,448, 447,862,447, 434,859,434, 
33205,863,437, 33206,864,438, 33213,865,445, 440,866,440, 33211,867,443, 
3, // chain 164
672,893,1169, 699,734,951, 904,735,952, 
867,894,1170, 33674,738,954, 
3, // chain 165
1040,895,1171, 1041,896,1172, 906,897,954, 
1042,898,1173, 33675,899,955, 
4, // chain 166
1041,896,1172, 1040,895,1171, 879,900,1174, 
32818,901,1175, 32821,902,51, 33810,898,1173, 
4, // chain 167
879,900,1174, 50,901,1175, 127,715,1176, 
32815,903,1177, 136,714,932, 32812,904,754, 
12, // chain 168
511,398,1178, 514,401,1179, 1043,905,1179, 
33812,906,1179, 33284,403,1179, 1045,907,1178, 33286,405,1180, 1046,908,1180, 33815,907,1181, 33287,403,1181, 1048,906,1182, 33289,401,1183, 1049,905,1183, 33291,398,1184, 
12, // chain 169
561,398,1185, 559,401,1186, 1050,905,1186, 
33819,906,1187, 33325,403,1188, 1052,907,1188, 33324,405,1189, 1053,908,1189, 33822,907,1190, 33322,403,1191, 1055,906,1192, 33320,401,1192, 1056,905,1192, 33315,398,1190, 
6, // chain 170
995,790,1193, 851,655,888, 1057,909,1194, 
996,910,1195, 33826,793,1196, 32797,31,29, 33620,656,889, 33619,655,888, 
2, // chain 171
353,889,354, 360,890,361, 357,891,358, 
355,892,356, 
5, // chain 172
360,890,361, 353,889,354, 362,888,363, 
33119,887,352, 363,860,364, 33118,886,351, 348,857,349, 
6, // chain 173
1059,911,1197, 1060,912,1198, 1061,913,1199, 
892,914,1200, 33830,915,1201, 33831,916,1202, 33832,917,1203, 33828,912,1198, 
6, // chain 174
1065,918,1204, 1066,919,1205, 1067,920,1206, 
1068,921,1207, 33837,922,1208, 33838,923,1209, 33839,924,1210, 33834,919,1205, 
4, // chain 175
1072,925,1211, 1073,926,1212, 1069,922,1213, 
33842,927,1214, 33834,928,1215, 33839,929,1216, 
6, // chain 176
1074,927,1214, 1066,928,1215, 1075,930,1217, 
33833,931,1218, 1076,932,1219, 1077,933,1220, 1074,927,1214, 33837,922,1213, 
6, // chain 177
1078,912,1221, 1079,911,1222, 1080,913,1223, 
1081,917,1224, 33850,916,1225, 33851,915,1226, 33810,914,1227, 33847,911,1222, 
6, // chain 178
1084,918,1228, 1085,919,1229, 1086,920,1230, 
1087,921,1231, 33856,922,1232, 33857,923,1233, 33858,924,1234, 33853,919,1229, 
4, // chain 179
1091,925,1235, 1092,926,1236, 1088,922,1237, 
33861,927,1238, 33853,928,1239, 33858,929,1240, 
6, // chain 180
1093,927,1238, 1085,928,1239, 1094,930,1241, 
33852,931,1242, 1095,932,1243, 1096,933,1244, 1093,927,1238, 33856,922,1237, 
7, // chain 181
1097,934,1245, 882,935,922, 1098,936,1246, 
127,544,126, 124,937,123, 883,938,923, 33867,939,1247, 32891,940,122, 883,938,923, 
1, // chain 182
882,935,922, 1097,934,1245, 883,938,923, 
7, // chain 183
1100,939,1248, 148,940,147, 146,937,145, 
723,938,729, 33869,934,1249, 32911,544,142, 1102,936,1250, 725,935,731, 723,938,729, 
1, // chain 184
148,940,147, 1100,939,1248, 723,938,729, 
10, // chain 185
1103,941,1251, 1104,942,1252, 1105,943,1253, 
1106,944,1254, 33875,945,1255, 33876,946,1256, 33814,947,1257, 33872,942,1252, 1045,948,1258, 33812,949,1259, 33811,950,1260, 33871,941,1251, 
10, // chain 186
1109,941,1261, 1110,943,1262, 1111,942,1263, 
1056,950,1264, 33823,949,1265, 33822,948,1266, 33821,947,1267, 33878,943,1262, 1112,946,1268, 33881,945,1269, 33882,944,1270, 33877,941,1261, 
4, // chain 187
1052,951,1271, 1053,947,1267, 1112,946,1268, 
1051,952,1272, 33818,953,1273, 33881,945,1269, 
1, // chain 188
238,216,236, 239,222,237, 237,217,235, 
3, // chain 189
259,245,256, 266,253,263, 95,99,94, 
104,127,103, 32887,125,118, 
5, // chain 190
1115,954,1274, 1116,955,1275, 1117,956,1276, 
33886,957,1277, 33887,958,1278, 1120,959,1279, 33889,960,1279, 
5, // chain 191
996,961,1195, 1058,962,1196, 998,963,1280, 
33890,964,1281, 32798,965,30, 1123,966,1147, 32799,967,31, 
5, // chain 192
31,968,31, 963,969,1058, 1123,966,1147, 
33890,964,1281, 33729,970,1056, 998,963,1280, 33728,971,1055, 
4, // chain 193
231,972,229, 232,216,230, 62,973,62, 
32833,221,65, 33892,974,1282, 33001,975,231, 
2, // chain 194
65,221,65, 1124,974,1282, 68,976,67, 
33893,224,1283, 
6, // chain 195
922,977,1284, 972,978,1285, 973,979,1286, 
923,980,1287, 33692,981,1288, 33742,982,1289, 925,983,1290, 33743,984,1291, 
4, // chain 196
972,978,1285, 922,977,1284, 971,985,1292, 
33694,986,1293, 975,987,1291, 33693,988,1290, 
10, // chain 197
932,984,1294, 933,982,1295, 930,983,1296, 
33697,981,1297, 33702,979,1298, 928,980,1299, 33695,977,1300, 33703,978,1301, 936,985,1302, 931,986,1303, 33700,987,1294, 930,988,1296, 
4, // chain 198
189,177,1304, 187,175,1304, 191,179,1304, 
32947,167,1304, 32951,171,1304, 32953,173,1304, 
1, // chain 199
179,167,1304, 183,171,1304, 180,168,1304, 
4, // chain 200
810,492,1305, 819,491,1306, 811,499,1307, 
33581,500,1307, 33585,498,1308, 815,501,1309, 
4, // chain 201
824,418,1310, 825,421,1310, 829,417,1310, 
33596,989,1310, 33594,423,1310, 827,425,1310, 
5, // chain 202
663,990,669, 658,991,664, 657,992,663, 
665,993,671, 33434,994,672, 33423,995,661, 654,996,660, 
2, // chain 203
156,997,155, 158,795,157, 964,796,1059, 
969,22,1068, 
7, // chain 204
1059,998,1311, 892,914,1312, 37,999,1313, 
1126,1000,1314, 33828,1001,1315, 32804,1002,1177, 68,1003,1316, 1064,917,1317, 33831,916,1318, 
4, // chain 205
1078,1001,1319, 54,1002,931, 53,999,1320, 
1127,1000,1321, 33847,998,1322, 33810,914,691, 
3, // chain 206
54,1002,931, 1078,1001,1319, 58,1003,1323, 
33849,917,1324, 1082,916,1325, 
6, // chain 207
537,413,1326, 1103,1004,1326, 1106,1005,1327, 
538,414,1327, 33309,413,1328, 33875,1004,1328, 1049,905,1329, 523,398,1329, 
4, // chain 208
1049,953,1330, 1107,945,1255, 1108,946,1256, 
1048,952,1331, 33815,951,1332, 33814,947,1257, 
8, // chain 209
1056,905,1333, 547,398,1333, 546,413,1334, 
1109,1004,1334, 33882,1005,1335, 33335,414,1335, 566,413,1336, 1113,1004,1336, 33818,905,1337, 33329,398,1337, 
3, // chain 210
323,304,1070, 971,768,1072, 308,303,1338, 
33077,302,1080, 33743,769,1079, 
3, // chain 211
994,823,1152, 992,821,1152, 986,1006,1152, 
33755,816,1152, 33758,819,1152, 
3, // chain 212
984,812,1339, 982,810,1339, 976,1007,1339, 
33745,805,1339, 33748,808,1339, 
3, // chain 213
582,417,1340, 592,989,1340, 586,421,1340, 
33356,423,1340, 33358,425,1340, 
3, // chain 214
1128,1008,1341, 127,1009,126, 1098,1010,1246, 
882,699,922, 127,1009,126, 
3, // chain 215
1129,1011,1342, 1102,1012,1250, 143,1013,142, 
725,590,731, 1102,1012,1250, 
3, // chain 216
1065,918,1204, 1068,921,1207, 1076,932,1343, 
33845,933,1344, 33837,922,1208, 
3, // chain 217
1084,918,1228, 1087,921,1231, 1095,932,1345, 
33864,933,1346, 33856,922,1232, 
2, // chain 218
917,191,1066, 968,799,1067, 919,1014,1064, 
33735,800,1063, 
1, // chain 219
773,394,1150, 563,397,559, 564,396,560, 
2, // chain 220
1117,1015,1347, 1118,1016,1347, 1130,956,1347, 
33888,957,1347, 
2, // chain 221
1130,1017,1348, 1120,1018,1348, 1115,1019,1348, 
33889,1020,1348, 
2, // chain 222
1115,955,1349, 1121,958,1349, 1116,1021,1349, 
33887,1022,1349, 
2, // chain 223
425,369,425, 487,370,486, 859,371,898, 
33256,372,487, 
2, // chain 224
1062,915,1201, 1063,916,1202, 1125,1023,1283, 
32836,1024,67, 
2, // chain 225
1083,915,1226, 240,1023,238, 1082,916,1225, 
32826,1024,58, 
2, // chain 226
511,398,1350, 1043,905,1350, 537,413,1326, 
33871,1004,1326, 
1, // chain 227
976,804,1081, 978,806,1083, 985,850,1090, 
1, // chain 228
986,815,1091, 988,817,1092, 985,1025,1090, 
1, // chain 229
179,167,1304, 193,181,1304, 191,179,1304, 
1, // chain 230
582,417,1340, 586,421,1340, 583,418,1340, 
1, // chain 231
800,468,816, 593,428,816, 584,430,816, 
1, // chain 232
807,477,819, 801,476,818, 800,475,840, 
1, // chain 233
995,790,1193, 850,654,216, 851,655,888, 
1, // chain 234
1058,793,1196, 29,31,29, 30,32,30, 
1, // chain 235
829,417,855, 623,419,845, 824,418,635, 
1, // chain 236
1115,954,1274, 1117,956,1276, 1130,1026,1274, 
1, // chain 237
663,990,669, 660,1027,666, 658,991,664, 
1, // chain 238
157,200,156, 178,165,177, 160,166,159, 
1, // chain 239
835,448,867, 836,449,173, 841,450,164, 
1, // chain 240
841,450,872, 486,462,874, 484,461,883, 
1, // chain 241
408,375,408, 620,391,890, 343,311,344, 
1, // chain 242
843,856,1167, 863,660,902, 842,659,906, 
1, // chain 243
862,374,901, 488,372,487, 489,373,488, 
1, // chain 244
1060,912,1198, 1059,911,1197, 1126,1000,1351, 
1, // chain 245
1069,922,1208, 1070,923,1209, 1072,925,1352, 
1, // chain 246
1079,911,1222, 1078,912,1221, 1127,1000,1353, 
1, // chain 247
1088,922,1232, 1089,923,1233, 1091,925,1354, 
1, // chain 248
906,897,954, 1041,896,1172, 867,1028,1170, 
1, // chain 249
517,636,785, 515,638,785, 520,637,785, 

 0};


// face array: 2kb.
const uint16_t naruto_2_face[1210] PROGMEM = {
20, // chain 0
1131,1029,1355, 1132,1029,1356, 1133,1029,1357, 
33902,1029,1358, 33903,1029,1359, 1136,1029,1360, 33905,1029,1361, 1138,1029,1362, 33907,1029,1363, 1140,1029,1364, 33909,1029,1365, 1142,1029,1366, 33911,1029,1367, 1144,1029,1368, 33913,1029,1369, 1146,1029,1370, 33915,1029,1371, 1148,1029,1372, 33917,1029,1373, 
1150,1029,1374, 33899,1029,1355, 1133,1029,1357, 
20, // chain 1
1151,1029,1375, 1152,1029,1376, 1153,1029,1377, 
33922,1029,1378, 33923,1029,1379, 1156,1029,1380, 33925,1029,1381, 1158,1029,1382, 33927,1029,1383, 1160,1029,1384, 33929,1029,1385, 1162,1029,1386, 33931,1029,1387, 1164,1029,1388, 33933,1029,1389, 1166,1029,1390, 33935,1029,1391, 1168,1029,1392, 33937,1029,1393, 
1170,1029,1394, 33919,1029,1375, 1153,1029,1377, 
20, // chain 2
1171,1030,1395, 1145,1031,1396, 1143,1032,1397, 
1172,1033,1398, 33909,1034,1399, 1173,1035,1400, 33942,1036,1401, 33907,1037,1402, 1175,1038,1403, 33905,1039,1404, 1176,1040,1405, 33903,1041,1406, 1132,1042,1407, 1177,1043,1408, 33946,1044,1409, 33899,1045,1410, 1179,706,1411, 33917,1046,1412, 1180,1047,1413, 
33915,1048,1414, 1171,1030,1395, 33913,1031,1396, 
3, // chain 3
1181,1049,1415, 1176,1040,1405, 1177,1043,1408, 
1182,1050,1416, 33946,1044,1409, 
17, // chain 4
1176,1040,1405, 1181,1049,1415, 1175,1038,1403, 
33942,1036,1401, 33951,1051,1417, 33952,1052,1418, 33953,1053,1419, 33950,1050,1416, 1186,1054,1283, 33955,1055,1201, 33956,1056,1420, 33946,1057,1409, 1189,1058,1421, 33958,1059,1422, 1191,1060,1423, 33960,1061,1424, 1193,1062,1425, 33941,1035,1400, 33940,1033,1398, 
28, // chain 5
1194,1036,1426, 1165,1037,1427, 1163,1034,1428, 
1195,1035,1429, 33964,1033,1430, 33929,1032,1431, 1197,1030,1432, 33927,1031,1433, 1157,1048,1434, 1198,1047,1435, 33923,1046,1436, 1199,706,1437, 33920,1045,1438, 1200,1044,1439, 33919,1042,1440, 1201,1043,1441, 33970,1040,1442, 33937,1041,1443, 1167,1039,1444, 
1203,1038,1445, 33933,1037,1427, 1194,1036,1426, 1204,1049,1446, 33973,1051,1447, 33974,1063,1448, 33963,1035,1429, 1207,1064,1449, 33976,1062,1450, 33977,1061,1451, 33964,1033,1430, 
17, // chain 6
1203,1038,1445, 1204,1049,1446, 1202,1040,1442, 
33969,1043,1441, 33978,1050,1452, 33979,1053,1453, 33980,1052,1454, 33973,1051,1447, 1213,1065,1455, 33982,1066,967, 33983,1067,1456, 1183,1051,1417, 1216,1065,1457, 33952,1052,1418, 1217,1068,1458, 33986,1069,1459, 33953,1053,1419, 1219,1070,1282, 33954,1054,1283, 
4, // chain 7
1220,1071,1460, 1217,1068,1458, 1218,1069,1459, 
1221,1072,1461, 33990,1073,1462, 33987,1070,1282, 
4, // chain 8
1217,1068,1458, 1220,1071,1460, 1223,1074,1463, 
33992,1075,1464, 33993,1076,1465, 33989,1072,1461, 
5, // chain 9
1223,1074,1463, 1224,1075,1464, 1226,1077,1466, 
33995,1078,1467, 33996,1079,1468, 33997,1080,1469, 33993,1076,1465, 
15, // chain 10
1226,1077,1466, 1227,1078,1467, 1230,1075,1470, 
33996,1079,1468, 1231,1080,1471, 1232,1076,1472, 1233,1071,1473, 34002,1072,1474, 1235,1069,1475, 34004,1073,1476, 1237,1070,237, 1211,1053,1453, 34006,1054,238, 1210,1050,1452, 34007,1055,1226, 1240,1056,1477, 34009,1081,1227, 
17, // chain 11
1213,1065,1455, 1242,1068,1478, 1212,1052,1454, 
34003,1069,1475, 34001,1071,1473, 34011,1074,1479, 34012,1082,1480, 34013,1083,1481, 1246,1084,1482, 34015,1085,1483, 1248,1083,1484, 1249,1082,1485, 33985,1068,1458, 1223,1074,1463, 1246,1084,1482, 33994,1077,1466, 1243,1074,1479, 33998,1075,1470, 1233,1071,1473, 
2, // chain 12
1248,1083,1484, 1246,1084,1482, 1247,1085,1483, 
34013,1083,1481, 
6, // chain 13
1208,1062,1450, 1209,1061,1451, 1250,1060,1486, 
34019,1059,1487, 1252,1058,1488, 33968,1057,1439, 1240,1056,1477, 33978,1050,1452, 
15, // chain 14
1174,1036,1401, 1183,1051,1417, 1253,1063,1489, 
34022,1086,1490, 34023,1087,1491, 1256,1088,1492, 34025,1089,1493, 1258,1087,1494, 1259,1086,1495, 33973,1051,1447, 1206,1063,1448, 1260,1090,1496, 33975,1064,1449, 1261,1091,1497, 34030,1092,1498, 33976,1062,1450, 1250,1060,1486, 
3, // chain 15
1253,1063,1489, 1254,1086,1490, 1260,1090,1496, 
34024,1088,1492, 1259,1086,1495, 
1, // chain 16
1212,1052,1454, 1235,1069,1475, 1211,1053,1453, 
4, // chain 17
1263,1064,1499, 1260,1090,1496, 1261,1091,1497, 
1264,1092,1500, 34033,1093,1501, 34030,1092,1498, 
5, // chain 18
1260,1090,1496, 1263,1064,1499, 1253,1063,1489, 
33941,1035,1400, 33961,1062,1425, 34032,1092,1500, 1191,1060,1423, 
8, // chain 19
1242,1094,1502, 1266,1095,1503, 1267,912,1504, 
34036,1096,1505, 34037,1097,1506, 34038,1098,1507, 1271,1099,1508, 1272,1100,1509, 34041,1101,1510, 33985,1102,1511, 
1, // chain 20
1268,1096,1505, 1269,1097,1506, 1272,1100,1509, 
7, // chain 21
1273,1103,1512, 1248,1104,1513, 1274,1105,1514, 
1272,1106,1515, 34036,1107,1516, 34035,1108,1517, 34013,1109,1518, 34015,1110,1519, 34016,1104,1513, 
5, // chain 22
1275,1111,1520, 1228,1079,1520, 1229,1080,1521, 
1276,1112,1522, 33993,1076,1523, 1222,1073,1524, 33989,1072,1525, 
6, // chain 23
1228,1079,1520, 1275,1111,1520, 1231,1080,1526, 
34045,1112,1527, 1232,1076,1528, 34004,1073,1529, 34046,1113,1530, 1237,1070,1531, 
1, // chain 24
1232,1076,1528, 1236,1073,1529, 1234,1072,1532, 
5, // chain 25
1172,1033,1398, 1192,1030,1424, 1171,1030,1395, 
33948,1047,1413, 33958,1114,1422, 1179,706,1411, 33946,1044,1409, 
5, // chain 26
1196,1033,1430, 1197,1030,1432, 1209,1030,1451, 
33966,1047,1435, 1251,1114,1487, 33967,706,1437, 1200,1044,1439, 
2, // chain 27
1213,1065,1455, 1214,1066,967, 1279,1115,1533, 
33984,1065,1457, 
8, // chain 28
1280,1116,1534, 1281,1117,1535, 1282,1118,1534, 
34051,1119,1536, 34052,1120,1537, 1285,1121,1537, 34054,1119,1538, 34055,1117,1539, 1288,1118,1540, 34057,1116,1540, 
5, // chain 29
1290,1122,1541, 1291,1123,1542, 1292,1124,1543, 
1293,1125,1544, 34062,1126,1545, 1295,1127,1546, 1296,1128,1547, 
5, // chain 30
1291,1123,1542, 1290,1122,1541, 1297,1124,1548, 
34066,1129,1549, 1299,1126,1550, 34068,1130,1551, 34069,1128,1552, 
4, // chain 31
1255,1087,1553, 1183,1051,1554, 1215,1067,1555, 
1257,1089,1556, 34026,1087,1557, 33973,1051,1558, 
3, // chain 32
1270,1085,1507, 1279,1115,1559, 1216,1065,1560, 
1271,1083,1508, 33985,1068,1511, 
3, // chain 33
1279,1115,1559, 1270,1085,1507, 1213,1065,1561, 
34034,1083,1503, 1242,1068,1502, 
2, // chain 34
1302,1113,1562, 1276,1112,1522, 1222,1073,1524, 
1219,1070,1563, 
2, // chain 35
1303,1131,1564, 1286,1119,1565, 1288,1118,1566, 
1304,1132,1567, 
6, // chain 36
1286,1119,1565, 1303,1131,1564, 1285,1121,1568, 
34073,1133,1568, 1306,1131,1569, 1283,1119,1570, 34050,1118,1571, 34075,1132,1572, 
6, // chain 37
1308,1134,1573, 1287,1117,1574, 1284,1120,1575, 
1309,1135,1575, 34078,1134,1576, 34049,1117,1577, 1280,1116,1578, 1311,1136,1579, 
1, // chain 38
1253,1063,1489, 1173,1035,1400, 1174,1036,1401, 
1, // chain 39
1201,1043,1441, 1210,1050,1452, 1200,1044,1439, 
2, // chain 40
1287,1117,1574, 1308,1134,1573, 1289,1116,1580, 
34080,1136,1581, 
1, // chain 41
1187,1055,1201, 1188,1056,1420, 1313,1081,1200, 
1, // chain 42
1246,1084,1482, 1243,1074,1479, 1244,1082,1480, 
1, // chain 43
1242,1137,1582, 1267,1108,1517, 1245,1109,1518, 
1, // chain 44
1217,1138,1583, 1248,1104,1513, 1273,1103,1512, 

 0};


// face array: 0kb.
const uint16_t naruto_3_face[46] PROGMEM = {
4, // chain 0
1314,1139,1584, 1315,1140,1585, 1316,1141,1586, 
34085,1142,1587, 34086,1143,1588, 1319,1144,1589, 
3, // chain 1
1320,1141,1590, 1321,1142,1591, 1322,1140,1592, 
34091,1143,1593, 34092,1144,1594, 
1, // chain 2
1320,1141,1590, 1322,1140,1592, 1325,1139,1595, 

 0};


// mesh info for object naruto_3 (with tag [g Eye.bmp | usemtl Eye.bmp])
const tgx::Mesh3D<tgx::RGB565> naruto_3 = 
    {
    1, // version/id
    
    1326, // number of vertices
    1145, // number of texture coords
    1596, // number of normal vectors
    8, // number of triangles
    46, 
    
    naruto_vert_array, // array of vertices
    naruto_tex_array, // array of texture coords
    naruto_norm_array, // array of normal vectors        
    naruto_3_face, // array of face vertex indexes   
    
    &naruto_eye_texture, // pointer to texture image 
    
    { 0.75f , 0.75f, 0.75f }, // default color
    
    0.1f, // ambiant light strength 
    0.7f, // diffuse light strength
    0.6f, // specular light strength
    32, // specular exponent
    
    nullptr, // next mesh to draw after this one    
    
    { // mesh bounding box
    -0.09621331738739658, 0.09630305815212771, 
    0.6607052001295709, 0.7343748895767935, 
    0.07790246218370915, 0.1210752484164588
    },
    
    "naruto" // model name    
    };
    

// mesh info for object naruto_2 (with tag [g Head.bmp | usemtl Head.bmp])
const tgx::Mesh3D<tgx::RGB565> naruto_2 = 
    {
    1, // version/id
    
    1326, // number of vertices
    1145, // number of texture coords
    1596, // number of normal vectors
    298, // number of triangles
    1210, 
    
    naruto_vert_array, // array of vertices
    naruto_tex_array, // array of texture coords
    naruto_norm_array, // array of normal vectors        
    naruto_2_face, // array of face vertex indexes   
    
    &naruto_head_texture, // pointer to texture image 
    
    { 0.75f , 0.75f, 0.75f }, // default color
    
    0.1f, // ambiant light strength 
    0.7f, // diffuse light strength
    0.6f, // specular light strength
    32, // specular exponent
    
    &naruto_3, // next mesh to draw after this one    
    
    { // mesh bounding box
    -0.11356319856875448, 0.11378007208352141, 
    0.5534724646728937, 0.727075899261355, 
    0.008390761502363614, 0.15907298388304478
    },
    
    "naruto" // model name    
    };
    

// mesh info for object naruto_1 (with tag [ | g Body.bmp | usemtl Body.bmp])
const tgx::Mesh3D<tgx::RGB565> naruto_1 = 
    {
    1, // version/id
    
    1326, // number of vertices
    1145, // number of texture coords
    1596, // number of normal vectors
    2166, // number of triangles
    8249, 
    
    naruto_vert_array, // array of vertices
    naruto_tex_array, // array of texture coords
    naruto_norm_array, // array of normal vectors        
    naruto_1_face, // array of face vertex indexes   
    
    &naruto_body_texture, // pointer to texture image 
    
    { 0.75f , 0.75f, 0.75f }, // default color
    
    0.1f, // ambiant light strength 
    0.7f, // diffuse light strength
    0.6f, // specular light strength
    32, // specular exponent
    
    &naruto_2, // next mesh to draw after this one    
    
    { // mesh bounding box
    -0.8020693023803476, 0.8020693023803476, 
    -1.0, 1.0, 
    -0.195223555275581, 0.195223555275581
    },
    
    "naruto" // model name    
    };
    
                
/** end of naruto.h */
    
    
    