#pragma once

namespace cs::midi_ble_btstack {

constexpr const char *hci_event_names[256] {
    "NOP",
    "INQUIRY_COMPLETE",
    "INQUIRY_RESULT",
    "CONNECTION_COMPLETE",
    "CONNECTION_REQUEST",
    "DISCONNECTION_COMPLETE",
    "AUTHENTICATION_COMPLETE",
    "REMOTE_NAME_REQUEST_COMPLETE",
    "ENCRYPTION_CHANGE",
    "CHANGE_CONNECTION_LINK_KEY_COMPLETE",
    "MASTER_LINK_KEY_COMPLETE",
    "READ_REMOTE_SUPPORTED_FEATURES_COMPLETE",
    "READ_REMOTE_VERSION_INFORMATION_COMPLETE",
    "QOS_SETUP_COMPLETE",
    "COMMAND_COMPLETE",
    "COMMAND_STATUS",
    "HARDWARE_ERROR",
    "FLUSH_OCCURRED",
    "ROLE_CHANGE",
    "NUMBER_OF_COMPLETED_PACKETS",
    "MODE_CHANGE",
    "RETURN_LINK_KEYS",
    "PIN_CODE_REQUEST",
    "LINK_KEY_REQUEST",
    "LINK_KEY_NOTIFICATION",
    "LOOPBACK_COMMAND",
    "DATA_BUFFER_OVERFLOW",
    "MAX_SLOTS_CHANGED",
    "READ_CLOCK_OFFSET_COMPLETE",
    "CONNECTION_PACKET_TYPE_CHANGED",
    "QOS_VIOLATION",
    "(unknown)",
    "PAGE_SCAN_REPETITION_MODE_CHANGE",
    "FLOW_SPECIFICATION_COMPLETE",
    "INQUIRY_RESULT_WITH_RSSI",
    "READ_REMOTE_EXTENDED_FEATURES_COMPLETE",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "SYNCHRONOUS_CONNECTION_COMPLETE",
    "SYNCHRONOUS_CONNECTION_CHANGED",
    "SNIFF_SUBRATING",
    "EXTENDED_INQUIRY_RESPONSE",
    "ENCRYPTION_KEY_REFRESH_COMPLETE",
    "IO_CAPABILITY_REQUEST",
    "IO_CAPABILITY_RESPONSE",
    "USER_CONFIRMATION_REQUEST",
    "USER_PASSKEY_REQUEST",
    "REMOTE_OOB_DATA_REQUEST",
    "SIMPLE_PAIRING_COMPLETE",
    "(unknown)",
    "LINK_SUPERVISION_TIMEOUT_CHANGED",
    "ENHANCED_FLUSH_COMPLETE",
    "(unknown)",
    "USER_PASSKEY_NOTIFICATION",
    "KEYPRESS_NOTIFICATION",
    "REMOTE_HOST_SUPPORTED_FEATURES",
    "LE_META",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "NUMBER_OF_COMPLETED_DATA_BLOCKS",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "ENCRYPTION_CHANGE_V2",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "TRANSPORT_SLEEP_MODE",
    "TRANSPORT_USB_INFO",
    "BIS_CAN_SEND_NOW",
    "CIS_CAN_SEND_NOW",
    "TRANSPORT_READY",
    "TRANSPORT_PACKET_SENT",
    "SCO_CAN_SEND_NOW",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "GATT_EVENT_QUERY_COMPLETE",
    "GATT_EVENT_SERVICE_QUERY_RESULT",
    "GATT_EVENT_CHARACTERISTIC_QUERY_RESULT",
    "GATT_EVENT_INCLUDED_SERVICE_QUERY_RESULT",
    "GATT_EVENT_ALL_CHARACTERISTIC_DESCRIPTORS_QUERY_RESULT",
    "GATT_EVENT_CHARACTERISTIC_VALUE_QUERY_RESULT",
    "GATT_EVENT_LONG_CHARACTERISTIC_VALUE_QUERY_RESULT",
    "GATT_EVENT_NOTIFICATION",
    "GATT_EVENT_INDICATION",
    "GATT_EVENT_CHARACTERISTIC_DESCRIPTOR_QUERY_RESULT",
    "GATT_EVENT_LONG_CHARACTERISTIC_DESCRIPTOR_QUERY_RESULT",
    "GATT_EVENT_MTU",
    "GATT_EVENT_CAN_WRITE_WITHOUT_RESPONSE",
    "GATT_EVENT_CONNECTED",
    "GATT_EVENT_DISCONNECTED",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "ATT_EVENT_CONNECTED",
    "ATT_EVENT_DISCONNECTED",
    "ATT_EVENT_MTU_EXCHANGE_COMPLETE",
    "ATT_EVENT_HANDLE_VALUE_INDICATION_COMPLETE",
    "ATT_EVENT_CAN_SEND_NOW",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "BNEP_EVENT_SERVICE_REGISTERED",
    "BNEP_EVENT_CHANNEL_OPENED",
    "BNEP_EVENT_CHANNEL_CLOSED",
    "BNEP_EVENT_CHANNEL_TIMEOUT",
    "BNEP_EVENT_CAN_SEND_NOW",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "SM_EVENT_JUST_WORKS_REQUEST",
    "SM_EVENT_PASSKEY_DISPLAY_NUMBER",
    "SM_EVENT_PASSKEY_DISPLAY_CANCEL",
    "SM_EVENT_PASSKEY_INPUT_NUMBER",
    "SM_EVENT_NUMERIC_COMPARISON_REQUEST",
    "SM_EVENT_IDENTITY_RESOLVING_STARTED",
    "SM_EVENT_IDENTITY_RESOLVING_FAILED",
    "SM_EVENT_IDENTITY_RESOLVING_SUCCEEDED",
    "SM_EVENT_AUTHORIZATION_REQUEST",
    "SM_EVENT_AUTHORIZATION_RESULT",
    "SM_EVENT_KEYPRESS_NOTIFICATION",
    "SM_EVENT_IDENTITY_CREATED",
    "SM_EVENT_PAIRING_STARTED",
    "SM_EVENT_PAIRING_COMPLETE",
    "SM_EVENT_REENCRYPTION_STARTED",
    "SM_EVENT_REENCRYPTION_COMPLETE",
    "GAP_EVENT_SECURITY_LEVEL",
    "GAP_EVENT_DEDICATED_BONDING_COMPLETED",
    "GAP_EVENT_ADVERTISING_REPORT",
    "GAP_EVENT_EXTENDED_ADVERTISING_REPORT",
    "GAP_EVENT_INQUIRY_RESULT",
    "GAP_EVENT_INQUIRY_COMPLETE",
    "GAP_EVENT_RSSI_MEASUREMENT",
    "GAP_EVENT_LOCAL_OOB_DATA",
    "GAP_EVENT_PAIRING_STARTED",
    "GAP_EVENT_PAIRING_COMPLETE",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "META_GAP",
    "HSP_META",
    "HFP_META",
    "ANCS_META",
    "AVDTP_META",
    "AVRCP_META",
    "GOEP_META",
    "PBAP_META",
    "HID_META",
    "A2DP_META",
    "HIDS_META",
    "GATTSERVICE_META",
    "BIP_META",
    "MAP_META",
    "MESH_META",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "VENDOR_SPECIFIC",
};

constexpr const char *gattservice_event_names[114] {
    "(unknown)",
    "CYCLING_POWER_START_CALIBRATION",
    "CYCLING_POWER_BROADCAST_START",
    "CYCLING_POWER_BROADCAST_STOP",
    "BATTERY_SERVICE_CONNECTED",
    "BATTERY_SERVICE_LEVEL",
    "DEVICE_INFORMATION_DONE",
    "DEVICE_INFORMATION_MANUFACTURER_NAME",
    "DEVICE_INFORMATION_MODEL_NUMBER",
    "DEVICE_INFORMATION_SERIAL_NUMBER",
    "DEVICE_INFORMATION_HARDWARE_REVISION",
    "DEVICE_INFORMATION_FIRMWARE_REVISION",
    "DEVICE_INFORMATION_SOFTWARE_REVISION",
    "DEVICE_INFORMATION_SYSTEM_ID",
    "DEVICE_INFORMATION_IEEE_REGULATORY_CERTIFICATION",
    "DEVICE_INFORMATION_PNP_ID",
    "SCAN_PARAMETERS_SERVICE_CONNECTED",
    "SPP_SERVICE_CONNECTED",
    "SPP_SERVICE_DISCONNECTED",
    "HID_SERVICE_CONNECTED",
    "HID_REPORT",
    "HID_INFORMATION",
    "HID_PROTOCOL_MODE",
    "HID_SERVICE_REPORTS_NOTIFICATION",
    "SCAN_PARAMETERS_SERVICE_SCAN_INTERVAL_UPDATE",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "BASS_SERVER_SCAN_STOPPED",
    "BASS_SERVER_SCAN_STARTED",
    "BASS_SERVER_BROADCAST_CODE",
    "BASS_SERVER_SOURCE_ADDED",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "BASS_SERVER_SOURCE_MODIFIED",
    "BASS_SERVER_SOURCE_DELETED",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "BASS_CLIENT_CONNECTED",
    "BASS_CLIENT_DISCONNECTED",
    "BASS_CLIENT_SCAN_OPERATION_COMPLETE",
    "BASS_NOTIFY_RECEIVE_STATE_BASE",
    "BASS_CLIENT_NOTIFY_RECEIVE_STATE_SUBGROUP",
    "BASS_CLIENT_NOTIFICATION_COMPLETE",
    "BASS_CLIENT_SOURCE_OPERATION_COMPLETE",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "BASS_SERVER_CONNECTED",
    "BASS_SERVER_DISCONNECTED",
};

constexpr const char *le_event_names[42] {
    "(unknown)",
    "HCI_SUBEVENT_LE_CONNECTION_COMPLETE",
    "HCI_SUBEVENT_LE_ADVERTISING_REPORT",
    "HCI_SUBEVENT_LE_CONNECTION_UPDATE_COMPLETE",
    "HCI_SUBEVENT_LE_READ_REMOTE_FEATURES_COMPLETE",
    "HCI_SUBEVENT_LE_LONG_TERM_KEY_REQUEST",
    "HCI_SUBEVENT_LE_REMOTE_CONNECTION_PARAMETER_REQUEST",
    "HCI_SUBEVENT_LE_DATA_LENGTH_CHANGE",
    "HCI_SUBEVENT_LE_READ_LOCAL_P256_PUBLIC_KEY_COMPLETE",
    "HCI_SUBEVENT_LE_GENERATE_DHKEY_COMPLETE",
    "HCI_SUBEVENT_LE_ENHANCED_CONNECTION_COMPLETE_V1",
    "HCI_SUBEVENT_LE_DIRECT_ADVERTISING_REPORT",
    "HCI_SUBEVENT_LE_PHY_UPDATE_COMPLETE",
    "HCI_SUBEVENT_LE_EXTENDED_ADVERTISING_REPORT",
    "HCI_SUBEVENT_LE_PERIODIC_ADVERTISING_SYNC_ESTABLISHMENT",
    "HCI_SUBEVENT_LE_PERIODIC_ADVERTISING_REPORT",
    "HCI_SUBEVENT_LE_PERIODIC_ADVERTISING_SYNC_LOST",
    "HCI_SUBEVENT_LE_SCAN_TIMEOUT",
    "HCI_SUBEVENT_LE_ADVERTISING_SET_TERMINATED",
    "HCI_SUBEVENT_LE_SCAN_REQUEST_RECEIVED",
    "HCI_SUBEVENT_LE_CHANNEL_SELECTION_ALGORITHM",
    "HCI_SUBEVENT_LE_CONNECTIONLESS_IQ_REPORT",
    "HCI_SUBEVENT_LE_CONNECTION_IQ_REPORT",
    "HCI_SUBEVENT_LE_LE_CTE_REQUEST_FAILED",
    "HCI_SUBEVENT_LE_PERIODIC_ADVERTISING_SYNC_TRANSFER_RECEIVED",
    "HCI_SUBEVENT_LE_CIS_ESTABLISHED",
    "HCI_SUBEVENT_LE_CIS_REQUEST",
    "HCI_SUBEVENT_LE_CREATE_BIG_COMPLETE",
    "HCI_SUBEVENT_LE_TERMINATE_BIG_COMPLETE",
    "HCI_SUBEVENT_LE_BIG_SYNC_ESTABLISHED",
    "HCI_SUBEVENT_LE_BIG_SYNC_LOST",
    "HCI_SUBEVENT_LE_REQUEST_PEER_SCA_COMPLETE",
    "(unknown)",
    "HCI_SUBEVENT_LE_TRANSMIT_POWER_REPORTING",
    "HCI_SUBEVENT_LE_BIGINFO_ADVERTISING_REPORT",
    "HCI_SUBEVENT_LE_SUBRATE_CHANGE",
    "(unknown)",
    "(unknown)",
    "(unknown)",
    "HCI_SUBEVENT_LE_PERIODIC_ADVERTISING_DATA_REQUEST",
    "(unknown)",
    "HCI_SUBEVENT_LE_ENHANCED_CONNECTION_COMPLETE_V2",
};

} // namespace cs::midi_ble_btstack
