// :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: //

/**
 * @defgroup    MIDIOutputElements MIDI Output Elements
 * @brief   All Elements that send out MIDI events.  
 *          This includes potentiometers, faders, buttons, rotary encoders, 
 *          program selectors.
 */

/**
 * @ingroup MIDIOutputElements
 * @defgroup    BankableMIDIOutputElements Bankable MIDI Output Elements
 * @brief   All Elements that send out MIDI events, and that can be banked.  
 *          This includes the bankable versions of pretty much all elements in
 *          @ref MIDIOutputElements.
 */

/**
 * @ingroup MIDIOutputElements
 * @defgroup    ManyAddressesMIDIOutputElements Many Addresses MIDI Output Elements
 * @brief   All Elements that send out MIDI events, and that can banked, with
 *          a list of arbitrary addresses.  
 *          This includes the bankable versions of pretty much all elements in
 *          @ref MIDIOutputElements.
 */

// :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: //

/**
 * @defgroup    MIDIInputElements   MIDI Input Elements
 * @brief   All Elements that listen for incoming MIDI events.  
 *          This includes LEDs, VU meters, V-Pot LED rings, time displays ...
 */

/**
 * @ingroup     MIDIInputElements
 * @defgroup    BankableMIDIInputElements   Bankable MIDI Input Elements
 * @brief   All Elements that listen for incoming MIDI events, and that can be
 *          banked.  
 *          This includes the bankable versions of pretty much all elements in
 *          @ref MIDIInputElements.
 */

/**
 * @ingroup MIDIInputElements
 * @defgroup    midi-input-elements-leds    MIDI Input Elements LEDs
 * @brief   All MIDIInputElements that visualize their state using LEDs.
 */

/**
 * @ingroup MIDIInputElements
 * @defgroup    MIDIInputMatchers    MIDI Input Matchers
 * @brief   Classes for matching incoming MIDI messages.
 */

/**
 * @ingroup midi-input-elements-leds
 * @defgroup    BankableMIDIInputElementsLEDs Bankable MIDI Input Elements LEDs
 * @brief   All Bankable MIDIInputElements that visualize their state using 
 *          LEDs.
 */

// :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: //

/**
 * @defgroup    Selectors   Selectors
 * @brief   Selectors are elements that change the bank setting or any other 
 *          selection, such as program selectors.
 */

/**
 * @ingroup Selectors
 * @defgroup    SelectorsLEDs   Selectors LEDs
 * @brief   @ref Selectors with LED feedback.
 */

// :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: //

/**
 * @defgroup    Audio Teensy Audio
 * @brief   All Elements that interact with Audio streams.
 */

// :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: //

/** 
 * @defgroup    MIDIInterfaces MIDI Interfaces
 * @brief   All MIDI Interfaces that can send and receive MIDI events.
 * @see     @ref midi-tutorial
 */

// :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: //

/** 
 * @defgroup    MIDIParsers MIDI Parsers
 * @brief   Utilities for parsing all kinds of MIDI streams.
 */

// :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: //

/** 
 * @defgroup    DisplayElements Display Elements
 * @brief   All Elements that can be used to show the state of the Control 
 *          Surface on the display.
 */

// :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: //

/** 
 * @defgroup    ControlSurfaceModule Control Surface
 * @brief   The main class that initializes, manages and updates all other
 *          elements.
 */

// :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: //

/**
 * @defgroup    MIDIConstants MIDI Constants
 * @brief   Constants for MIDI addresses, controller numbers, programs and 
 *          voices, Mackie Control Universal controls ...
 */

// :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: //