# User Manual {#manual}

 - Getting started
    - @ref md_pages_Installation
    - @ref md_pages_Getting-Started
    - @ref FAQ
    - @ref examples

 - MIDI communication
    - @ref midi-tutorial
        - @ref midi_md-midi-interfaces
        - @ref midi_md-sending
        - @ref midi_md-receiving
        - @ref midi_md-routing

    - MIDI transports
        - @ref md_pages_MIDI-over-USB
        - @ref md_pages_MIDI-over-BLE

    - MIDI API reference
        - @ref MIDIInterfaces "MIDI Interfaces API reference"
        - @ref MIDI_Sender "MIDI Sender API reference"
        - @ref MIDI_Callbacks "MIDI Callbacks API reference"
        - @ref FineGrainedMIDI_Callbacks "Fine Grained MIDI Callbacks API reference"
        - @ref MIDI_Routing "MIDI Routing API reference"
        - @ref MIDIConstants "Lists of MIDI constants"

 - Main Control Surface instance
    - @ref control-surface-purpose
    - @ref ControlSurfaceModule "Control_Surface API reference"

 - MIDI output elements: Controls that send MIDI messages
    - @ref MIDIOutputElements "MIDI output elements API reference"

 - MIDI input elements: Controls that receive MIDI messages
    - @ref MIDIInputElements "MIDI input elements API reference"

 - %Bank support to change control functions and addresses
    - @ref Bank "Bank API reference"
    - @ref Selectors "Selectors API reference"

 - Hardware support
    - @ref AH_ExtIO "Extended Input/Output pins and expanders"
    - @ref AH_HardwareUtils "Hardware utilities for debouncing and filtering, driving LEDs, etc."

 - %Display elements
    - @ref DisplayElements "Display elements API reference"

 - Related projects
    - [**Control-Surface-Motor-Fader**](https://github.com/tttapa/Control-Surface-Motor-Fader)
    - [**Arduino-Helpers**](https://github.com/tttapa/Arduino-Helpers)
