// Servomotor.h
// This file was autogenerated by generate_command_code_new2.py on Sep 3 2025 17:10:03
// Do not edit manually. If changes are needed, modify the generator program instead.

#ifndef SERVOMOTOR_H
#define SERVOMOTOR_H

#ifdef ARDUINO
#include <Arduino.h>
#endif
#include "Communication.h"
#include "Commands.h"
#include "DataTypes.h"
#include "Utils.h"
#include "AutoGeneratedUnitConversions.h"

// ============================================================================
// DATA STRUCTURES
// ============================================================================

// AUTO-GENERATED DATA STRUCTURES
// Structure for multimove list item with raw internal units
typedef struct {
    int32_t value;  // acceleration or velocity value (internal units)
    uint32_t timeSteps;  // duration in time steps (internal units)
} multimoveList_t;

// Structure for multimove list item with user-friendly units
typedef struct {
    float value;  // velocity or acceleration in user units
    float duration;  // duration in user units (seconds, milliseconds, etc.)
} multimoveListConverted_t;

// Structure for Trapezoid move command payload
typedef struct __attribute__((__packed__)) {
    int32_t displacement;
    uint32_t duration;
} trapezoidMovePayload;

// Structure for Set maximum velocity command payload
typedef struct __attribute__((__packed__)) {
    uint32_t maximumVelocity;
} setMaximumVelocityPayload;

// Structure for Go to position command payload
typedef struct __attribute__((__packed__)) {
    int32_t position;
    uint32_t duration;
} goToPositionPayload;

// Structure for Set maximum acceleration command payload
typedef struct __attribute__((__packed__)) {
    uint32_t maximumAcceleration;
} setMaximumAccelerationPayload;

// Structure for Capture hall sensor data command payload
typedef struct __attribute__((__packed__)) {
    uint8_t captureType;
    uint32_t nPointsToRead;
    uint8_t channelsToCaptureBitmask;
    uint16_t timeStepsPerSample;
    uint16_t nSamplesToSum;
    uint16_t divisionFactor;
} captureHallSensorDataPayload;

// Structure for Capture hall sensor data command response
typedef struct __attribute__((__packed__)) {
    uint8_t data;
} captureHallSensorDataResponse;

// Structure for Get current time command response
typedef struct __attribute__((__packed__)) {
    uint64_t currentTime;
} getCurrentTimeResponse;

// Structure for Time sync command payload
typedef struct __attribute__((__packed__)) {
    uint64_t masterTime;
} timeSyncPayload;

// Structure for Time sync command response
typedef struct __attribute__((__packed__)) {
    int32_t timeError;
    uint16_t rccIcscr;
} timeSyncResponse;

// Structure for Get n queued items command response
typedef struct __attribute__((__packed__)) {
    uint8_t queueSize;
} getNQueuedItemsResponse;

// Structure for Homing command payload
typedef struct __attribute__((__packed__)) {
    int32_t maxDistance;
    uint32_t maxDuration;
} homingPayload;

// Structure for Get hall sensor position command response
typedef struct __attribute__((__packed__)) {
    int64_t hallSensorPosition;
} getHallSensorPositionResponse;

// Structure for Get status command response
typedef struct __attribute__((__packed__)) {
    uint16_t statusFlags;
    uint8_t fatalErrorCode;
} getStatusResponse;

// Structure for Get product specs command response
typedef struct __attribute__((__packed__)) {
    uint32_t updateFrequency;
    uint32_t countsPerRotation;
} getProductSpecsResponse;

// Structure for Move with acceleration command payload
typedef struct __attribute__((__packed__)) {
    int32_t acceleration;
    uint32_t timeSteps;
} moveWithAccelerationPayload;

// Structure for Detect devices command response
typedef struct __attribute__((__packed__)) {
    uint64_t uniqueId;
    uint8_t alias;
} detectDevicesResponse;

// Structure for Set device alias command payload
typedef struct __attribute__((__packed__)) {
    uint8_t alias;
} setDeviceAliasPayload;

// Structure for Get product info command response
typedef struct __attribute__((__packed__)) {
    char productCode[8];
    uint8_t firmwareCompatibility;
    uint32_t hardwareVersion;
    uint32_t serialNumber;
    uint64_t uniqueId;
    uint32_t reserved;
} getProductInfoResponse;

// Structure for Firmware upgrade command payload
typedef struct __attribute__((__packed__)) {
    uint8_t firmwarePage[2058];
} firmwareUpgradePayload;

// Structure for Get product description command response
typedef struct __attribute__((__packed__)) {
    char productDescription[32];
} getProductDescriptionResponse;

// Structure for Get firmware version command response
typedef struct __attribute__((__packed__)) {
    uint32_t firmwareVersion;
    uint8_t inBootloader;
} getFirmwareVersionResponse;

// Structure for Move with velocity command payload
typedef struct __attribute__((__packed__)) {
    int32_t velocity;
    uint32_t duration;
} moveWithVelocityPayload;

// Structure for Set maximum motor current command payload
typedef struct __attribute__((__packed__)) {
    uint16_t motorCurrent;
    uint16_t regenerationCurrent;
} setMaximumMotorCurrentPayload;

// Structure for Multimove command payload
typedef struct __attribute__((__packed__)) {
    uint8_t moveCount;
    uint32_t moveTypes;
    multimoveList_t moveList[32];
} multimovePayload;

// Structure for Set safety limits command payload
typedef struct __attribute__((__packed__)) {
    int64_t lowerLimit;
    int64_t upperLimit;
} setSafetyLimitsPayload;

// Structure for Ping command payload
typedef struct __attribute__((__packed__)) {
    uint8_t pingData[10];
} pingPayload;

// Structure for Ping command response
typedef struct __attribute__((__packed__)) {
    uint8_t responsePayload[10];
} pingResponse;

// Structure for Control hall sensor statistics command payload
typedef struct __attribute__((__packed__)) {
    uint8_t control;
} controlHallSensorStatisticsPayload;

// Structure for Get hall sensor statistics command response
typedef struct __attribute__((__packed__)) {
    uint16_t maxHall1;
    uint16_t maxHall2;
    uint16_t maxHall3;
    uint16_t minHall1;
    uint16_t minHall2;
    uint16_t minHall3;
    uint64_t sumHall1;
    uint64_t sumHall2;
    uint64_t sumHall3;
    uint32_t measurementCount;
} getHallSensorStatisticsResponse;

// Structure for Get position command response
typedef struct __attribute__((__packed__)) {
    int64_t position;
} getPositionResponse;

// Structure for Read multipurpose buffer command response
typedef struct __attribute__((__packed__)) {
    uint8_t bufferData;
} readMultipurposeBufferResponse;

// Structure for Test mode command payload
typedef struct __attribute__((__packed__)) {
    uint8_t testMode;
} testModePayload;

// Structure for Get comprehensive position command response
typedef struct __attribute__((__packed__)) {
    int64_t commandedPosition;
    int64_t hallSensorPosition;
    int32_t externalEncoderPosition;
} getComprehensivePositionResponse;

// Structure for converted Get comprehensive position values
typedef struct {
    float commandedPosition;
    float hallSensorPosition;
    float externalEncoderPosition;
} getComprehensivePositionResponseConverted;

// Structure for Get supply voltage command response
typedef struct __attribute__((__packed__)) {
    uint16_t supplyVoltage;
} getSupplyVoltageResponse;

// Structure for Get max PID error command response
typedef struct __attribute__((__packed__)) {
    int32_t minPidError;
    int32_t maxPidError;
} getMaxPidErrorResponse;

// Structure for converted Get max PID error values
typedef struct {
    float minPidError;
    float maxPidError;
} getMaxPidErrorResponseConverted;

// Structure for Vibrate command payload
typedef struct __attribute__((__packed__)) {
    uint8_t vibrationLevel;
} vibratePayload;

// Structure for Get temperature command response
typedef struct __attribute__((__packed__)) {
    int16_t temperature;
} getTemperatureResponse;

// Structure for Set PID constants command payload
typedef struct __attribute__((__packed__)) {
    uint32_t kP;
    uint32_t kI;
    uint32_t kD;
} setPidConstantsPayload;

// Structure for Set max allowable position deviation command payload
typedef struct __attribute__((__packed__)) {
    int64_t maxAllowablePositionDeviation;
} setMaxAllowablePositionDeviationPayload;

// Structure for Get debug values command response
typedef struct __attribute__((__packed__)) {
    int64_t maxAcceleration;
    int64_t maxVelocity;
    int64_t currentVelocity;
    int32_t measuredVelocity;
    uint32_t nTimeSteps;
    int64_t debugValue1;
    int64_t debugValue2;
    int64_t debugValue3;
    int64_t debugValue4;
    uint16_t allMotorControlCalculationsProfilerTime;
    uint16_t allMotorControlCalculationsProfilerMaxTime;
    uint16_t getSensorPositionProfilerTime;
    uint16_t getSensorPositionProfilerMaxTime;
    uint16_t computeVelocityProfilerTime;
    uint16_t computeVelocityProfilerMaxTime;
    uint16_t motorMovementCalculationsProfilerTime;
    uint16_t motorMovementCalculationsProfilerMaxTime;
    uint16_t motorPhaseCalculationsProfilerTime;
    uint16_t motorPhaseCalculationsProfilerMaxTime;
    uint16_t motorControlLoopPeriodProfilerTime;
    uint16_t motorControlLoopPeriodProfilerMaxTime;
    uint16_t hallSensor1Voltage;
    uint16_t hallSensor2Voltage;
    uint16_t hallSensor3Voltage;
    uint32_t commutationPositionOffset;
    uint8_t motorPhasesReversed;
    int32_t maxHallPositionDelta;
    int32_t minHallPositionDelta;
    int32_t averageHallPositionDelta;
    uint8_t motorPwmVoltage;
} getDebugValuesResponse;

// Structure for CRC32 control command payload
typedef struct __attribute__((__packed__)) {
    uint8_t enableCrc32;
} crc32ControlPayload;

// Structure for Get communication statistics command payload
typedef struct __attribute__((__packed__)) {
    uint8_t resetCounter;
} getCommunicationStatisticsPayload;

// Structure for Get communication statistics command response
typedef struct __attribute__((__packed__)) {
    uint32_t crc32ErrorCount;
    uint32_t packetDecodeErrorCount;
    uint32_t firstBitErrorCount;
    uint32_t framingErrorCount;
    uint32_t overrunErrorCount;
    uint32_t noiseErrorCount;
} getCommunicationStatisticsResponse;


// These enum-to-string conversion functions are implemented in the cpp file
// but declared in AutoGeneratedUnitConversions.h

// ============================================================================
// SERVOMOTOR CLASS
// ============================================================================

class Servomotor {
public:
    // Constructor & basic methods
    Servomotor(uint8_t alias = 'X', HardwareSerial& serialPort = Serial1);
    
    // Addressing and command methods
    void sendCommand(uint8_t commandID, const uint8_t* payload, uint16_t payloadSize);
    void useAlias(uint8_t alias);
    void useUniqueId(uint64_t uniqueId);
    uint64_t usingThisUniqueId() const;
    uint8_t usingThisAlias() const;
    bool isUsingExtendedAddressing() const;
    void openSerialPort();
    int getError() const;
    
    
    // CRC32 control methods
    void enableCRC32();
    void disableCRC32();
    bool isCRC32Enabled() const;

    // Unit settings
    void setPositionUnit(PositionUnit unit);
    void setVelocityUnit(VelocityUnit unit);
    void setAccelerationUnit(AccelerationUnit unit);
    void setTimeUnit(TimeUnit unit);
    void setTemperatureUnit(TemperatureUnit unit);
    void setVoltageUnit(VoltageUnit unit);
    void setCurrentUnit(CurrentUnit unit);

    // Unit conversion methods - These are implemented in the cpp file
    // but declared in AutoGeneratedUnitConversions.h

    // AUTO-GENERATED COMMAND METHODS
    void disableMosfets();
    void disableMosfets(uint64_t uniqueId);

    void enableMosfets();
    void enableMosfets(uint64_t uniqueId);

    void trapezoidMoveRaw(int32_t displacement, uint32_t duration);
    void trapezoidMove(float displacement, float duration);
    void trapezoidMove(uint64_t uniqueId, float displacement, float duration);
    void trapezoidMoveRaw(uint64_t uniqueId, int32_t displacement, uint32_t duration);

    void setMaximumVelocityRaw(uint32_t maximumVelocity);
    void setMaximumVelocity(float maximumVelocity);
    void setMaximumVelocity(uint64_t uniqueId, float maximumVelocity);
    void setMaximumVelocityRaw(uint64_t uniqueId, uint32_t maximumVelocity);

    void goToPositionRaw(int32_t position, uint32_t duration);
    void goToPosition(float position, float duration);
    void goToPosition(uint64_t uniqueId, float position, float duration);
    void goToPositionRaw(uint64_t uniqueId, int32_t position, uint32_t duration);

    void setMaximumAccelerationRaw(uint32_t maximumAcceleration);
    void setMaximumAcceleration(float maximumAcceleration);
    void setMaximumAcceleration(uint64_t uniqueId, float maximumAcceleration);
    void setMaximumAccelerationRaw(uint64_t uniqueId, uint32_t maximumAcceleration);

    void startCalibration();
    void startCalibration(uint64_t uniqueId);

    captureHallSensorDataResponse captureHallSensorData(uint8_t captureType, uint32_t nPointsToRead, uint8_t channelsToCaptureBitmask, uint16_t timeStepsPerSample, uint16_t nSamplesToSum, uint16_t divisionFactor);
    captureHallSensorDataResponse captureHallSensorData(uint64_t uniqueId, uint8_t captureType, uint32_t nPointsToRead, uint8_t channelsToCaptureBitmask, uint16_t timeStepsPerSample, uint16_t nSamplesToSum, uint16_t divisionFactor);

    void resetTime();
    void resetTime(uint64_t uniqueId);

    uint64_t getCurrentTimeRaw();
    float getCurrentTime();
    float getCurrentTime(uint64_t uniqueId);
    uint64_t getCurrentTimeRaw(uint64_t uniqueId);

    timeSyncResponse timeSync(uint64_t masterTime);
    timeSyncResponse timeSync(uint64_t uniqueId, uint64_t masterTime);

    uint8_t getNQueuedItems();
    uint8_t getNQueuedItems(uint64_t uniqueId);

    void emergencyStop();
    void emergencyStop(uint64_t uniqueId);

    void zeroPosition();
    void zeroPosition(uint64_t uniqueId);

    void homingRaw(int32_t maxDistance, uint32_t maxDuration);
    void homing(float maxDistance, float maxDuration);
    void homing(uint64_t uniqueId, float maxDistance, float maxDuration);
    void homingRaw(uint64_t uniqueId, int32_t maxDistance, uint32_t maxDuration);

    int64_t getHallSensorPositionRaw();
    float getHallSensorPosition();
    float getHallSensorPosition(uint64_t uniqueId);
    int64_t getHallSensorPositionRaw(uint64_t uniqueId);

    getStatusResponse getStatus();
    getStatusResponse getStatus(uint64_t uniqueId);

    void goToClosedLoop();
    void goToClosedLoop(uint64_t uniqueId);

    getProductSpecsResponse getProductSpecs();
    getProductSpecsResponse getProductSpecs(uint64_t uniqueId);

    void moveWithAccelerationRaw(int32_t acceleration, uint32_t timeSteps);
    void moveWithAcceleration(float acceleration, float timeSteps);
    void moveWithAcceleration(uint64_t uniqueId, float acceleration, float timeSteps);
    void moveWithAccelerationRaw(uint64_t uniqueId, int32_t acceleration, uint32_t timeSteps);

    detectDevicesResponse detectDevices();
    detectDevicesResponse detectDevices(uint64_t uniqueId);
    detectDevicesResponse detectDevicesGetAnotherResponse();

    void setDeviceAlias(uint8_t alias);
    void setDeviceAlias(uint64_t uniqueId, uint8_t alias);

    getProductInfoResponse getProductInfo();
    getProductInfoResponse getProductInfo(uint64_t uniqueId);

    void firmwareUpgrade(uint8_t firmwarePage[2058]);
    void firmwareUpgrade(uint64_t uniqueId, uint8_t firmwarePage[2058]);

    getProductDescriptionResponse getProductDescription();
    getProductDescriptionResponse getProductDescription(uint64_t uniqueId);

    getFirmwareVersionResponse getFirmwareVersion();
    getFirmwareVersionResponse getFirmwareVersion(uint64_t uniqueId);

    void moveWithVelocityRaw(int32_t velocity, uint32_t duration);
    void moveWithVelocity(float velocity, float duration);
    void moveWithVelocity(uint64_t uniqueId, float velocity, float duration);
    void moveWithVelocityRaw(uint64_t uniqueId, int32_t velocity, uint32_t duration);

    void systemReset();
    void systemReset(uint64_t uniqueId);

    void setMaximumMotorCurrentRaw(uint16_t motorCurrent, uint16_t regenerationCurrent);
    void setMaximumMotorCurrent(float motorCurrent, float regenerationCurrent);
    void setMaximumMotorCurrent(uint64_t uniqueId, float motorCurrent, float regenerationCurrent);
    void setMaximumMotorCurrentRaw(uint64_t uniqueId, uint16_t motorCurrent, uint16_t regenerationCurrent);

    void multimoveRaw(uint8_t moveCount, uint32_t moveTypes, multimoveList_t* moveList);
    void multimove(uint8_t moveCount, uint32_t moveTypes, multimoveListConverted_t* moveList);
    void multimove(uint64_t uniqueId, uint8_t moveCount, uint32_t moveTypes, multimoveListConverted_t* moveList);
    void multimoveRaw(uint64_t uniqueId, uint8_t moveCount, uint32_t moveTypes, multimoveList_t* moveList);

    void setSafetyLimitsRaw(int64_t lowerLimit, int64_t upperLimit);
    void setSafetyLimits(float lowerLimit, float upperLimit);
    void setSafetyLimits(uint64_t uniqueId, float lowerLimit, float upperLimit);
    void setSafetyLimitsRaw(uint64_t uniqueId, int64_t lowerLimit, int64_t upperLimit);

    pingResponse ping(uint8_t pingData[10]);
    pingResponse ping(uint64_t uniqueId, uint8_t pingData[10]);

    void controlHallSensorStatistics(uint8_t control);
    void controlHallSensorStatistics(uint64_t uniqueId, uint8_t control);

    getHallSensorStatisticsResponse getHallSensorStatistics();
    getHallSensorStatisticsResponse getHallSensorStatistics(uint64_t uniqueId);

    int64_t getPositionRaw();
    float getPosition();
    float getPosition(uint64_t uniqueId);
    int64_t getPositionRaw(uint64_t uniqueId);

    readMultipurposeBufferResponse readMultipurposeBuffer();
    readMultipurposeBufferResponse readMultipurposeBuffer(uint64_t uniqueId);

    void testMode(uint8_t testMode);
    void testMode(uint64_t uniqueId, uint8_t testMode);

    getComprehensivePositionResponse getComprehensivePositionRaw();
    getComprehensivePositionResponseConverted getComprehensivePosition();
    getComprehensivePositionResponseConverted getComprehensivePosition(uint64_t uniqueId);
    getComprehensivePositionResponse getComprehensivePositionRaw(uint64_t uniqueId);

    uint16_t getSupplyVoltageRaw();
    float getSupplyVoltage();
    float getSupplyVoltage(uint64_t uniqueId);
    uint16_t getSupplyVoltageRaw(uint64_t uniqueId);

    getMaxPidErrorResponse getMaxPidErrorRaw();
    getMaxPidErrorResponseConverted getMaxPidError();
    getMaxPidErrorResponseConverted getMaxPidError(uint64_t uniqueId);
    getMaxPidErrorResponse getMaxPidErrorRaw(uint64_t uniqueId);

    void vibrate(uint8_t vibrationLevel);
    void vibrate(uint64_t uniqueId, uint8_t vibrationLevel);

    void identify();
    void identify(uint64_t uniqueId);

    int16_t getTemperatureRaw();
    float getTemperature();
    float getTemperature(uint64_t uniqueId);
    int16_t getTemperatureRaw(uint64_t uniqueId);

    void setPidConstants(uint32_t kP, uint32_t kI, uint32_t kD);
    void setPidConstants(uint64_t uniqueId, uint32_t kP, uint32_t kI, uint32_t kD);

    void setMaxAllowablePositionDeviationRaw(int64_t maxAllowablePositionDeviation);
    void setMaxAllowablePositionDeviation(float maxAllowablePositionDeviation);
    void setMaxAllowablePositionDeviation(uint64_t uniqueId, float maxAllowablePositionDeviation);
    void setMaxAllowablePositionDeviationRaw(uint64_t uniqueId, int64_t maxAllowablePositionDeviation);

    getDebugValuesResponse getDebugValues();
    getDebugValuesResponse getDebugValues(uint64_t uniqueId);

    void crc32Control(uint8_t enableCrc32);
    void crc32Control(uint64_t uniqueId, uint8_t enableCrc32);

    getCommunicationStatisticsResponse getCommunicationStatistics(uint8_t resetCounter);
    getCommunicationStatisticsResponse getCommunicationStatistics(uint64_t uniqueId, uint8_t resetCounter);


private:
    uint8_t _alias;
    uint64_t _uniqueId;
    bool _useExtendedAddressing;
    Communication _comm;
    int _errno;

    // Unit settings
    PositionUnit m_positionUnit = PositionUnit::SHAFT_ROTATIONS;
    VelocityUnit m_velocityUnit = VelocityUnit::ROTATIONS_PER_SECOND;
    AccelerationUnit m_accelerationUnit = AccelerationUnit::ROTATIONS_PER_SECOND_SQUARED;
    TimeUnit m_timeUnit = TimeUnit::SECONDS;
    TemperatureUnit m_temperatureUnit = TemperatureUnit::CELSIUS;
    VoltageUnit m_voltageUnit = VoltageUnit::VOLTS;
    CurrentUnit m_currentUnit = CurrentUnit::AMPS;
};

#endif // SERVOMOTOR_H