// Servomotor.cpp
// This file was autogenerated by generate_command_code_new2.py on Sep 3 2025 17:10:03
// Do not edit manually. If changes are needed, modify the generator program instead.

#include "Servomotor.h"
#include "Commands.h"
#include "Utils.h"
#include <sstream> // For std::stringstream
#include <iomanip> // For std::setw, std::setfill

Servomotor::Servomotor(uint8_t alias, HardwareSerial& serialPort)
    : _alias(alias), _uniqueId(0), _useExtendedAddressing(false), _comm(serialPort), _errno(0),
      m_positionUnit(PositionUnit::SHAFT_ROTATIONS),
      m_velocityUnit(VelocityUnit::ROTATIONS_PER_SECOND),
      m_accelerationUnit(AccelerationUnit::ROTATIONS_PER_SECOND_SQUARED),
      m_timeUnit(TimeUnit::SECONDS),
      m_temperatureUnit(TemperatureUnit::CELSIUS),
      m_voltageUnit(VoltageUnit::VOLTS),
      m_currentUnit(CurrentUnit::AMPS) {
    
    Serial.print("[Motor] Initialized with standard addressing, Alias: ");
    Serial.println(_alias);
    
    openSerialPort();
}

void Servomotor::useAlias(uint8_t new_alias) {
    _alias = new_alias;
    _useExtendedAddressing = false;
    Serial.print("[Motor] Use alias: ");
    Serial.println(_alias);
}

void Servomotor::useUniqueId(uint64_t uniqueId) {
    _uniqueId = uniqueId;
    _useExtendedAddressing = true;
    // Use stringstream for reliable hex formatting
    std::stringstream ss;
    ss << std::hex << std::setw(16) << std::setfill('0') << _uniqueId;
    Serial.print("[Motor] Use Unique ID: 0x");
    Serial.println(ss.str().c_str()); // Use c_str() for ConsoleSerial compatibility
}

uint64_t Servomotor::usingThisUniqueId() const {
    return _uniqueId;
}

uint8_t Servomotor::usingThisAlias() const {
    return _alias;
}

bool Servomotor::isUsingExtendedAddressing() const {
    return _useExtendedAddressing;
}

void Servomotor::openSerialPort() {
    _comm.openSerialPort();
}

void Servomotor::enableCRC32() {
    _comm.enableCRC32();
    Serial.println("[Motor] CRC32 enabled");
}

void Servomotor::disableCRC32() {
    _comm.disableCRC32();
    Serial.println("[Motor] CRC32 disabled");
}

bool Servomotor::isCRC32Enabled() const {
    return _comm.isCRC32Enabled();
}

int Servomotor::getError() const {
    return _errno;
}

// Helper method to send commands using the appropriate addressing mode
void Servomotor::sendCommand(uint8_t commandID, const uint8_t* payload, uint16_t payloadSize) {
    if (_useExtendedAddressing) {
        _comm.sendCommandByUniqueId(_uniqueId, commandID, payload, payloadSize);
    } else {
        _comm.sendCommand(_alias, commandID, payload, payloadSize);
    }
}


// AUTO-GENERATED UNIT SETTER IMPLEMENTATIONS
void Servomotor::setTimeUnit(TimeUnit unit) {
    Serial.println("[Motor] setTimeUnit called");
    m_timeUnit = unit;
}

void Servomotor::setPositionUnit(PositionUnit unit) {
    Serial.println("[Motor] setPositionUnit called");
    m_positionUnit = unit;
}

void Servomotor::setVelocityUnit(VelocityUnit unit) {
    Serial.println("[Motor] setVelocityUnit called");
    m_velocityUnit = unit;
}

void Servomotor::setAccelerationUnit(AccelerationUnit unit) {
    Serial.println("[Motor] setAccelerationUnit called");
    m_accelerationUnit = unit;
}

void Servomotor::setCurrentUnit(CurrentUnit unit) {
    Serial.println("[Motor] setCurrentUnit called");
    m_currentUnit = unit;
}

void Servomotor::setVoltageUnit(VoltageUnit unit) {
    Serial.println("[Motor] setVoltageUnit called");
    m_voltageUnit = unit;
}

void Servomotor::setTemperatureUnit(TemperatureUnit unit) {
    Serial.println("[Motor] setTemperatureUnit called");
    m_temperatureUnit = unit;
}


// AUTO-GENERATED COMMAND IMPLEMENTATIONS
void Servomotor::disableMosfets() {
    Serial.println("[Motor] disableMosfets called.");
    // Disables the MOSFETS (note that MOSFETs are disabled after initial power on).
    const uint8_t commandID = DISABLE_MOSFETS;
    sendCommand(commandID, nullptr, 0);
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::disableMosfets(uint64_t uniqueId) {
    Serial.println("[Motor] disableMosfets called (by unique ID).");
    // Disables the MOSFETS (note that MOSFETs are disabled after initial power on).
    const uint8_t commandID = DISABLE_MOSFETS;
    _comm.sendCommandByUniqueId(uniqueId, commandID, nullptr, 0);
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::enableMosfets() {
    Serial.println("[Motor] enableMosfets called.");
    // Enables the MOSFETS.
    const uint8_t commandID = ENABLE_MOSFETS;
    sendCommand(commandID, nullptr, 0);
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::enableMosfets(uint64_t uniqueId) {
    Serial.println("[Motor] enableMosfets called (by unique ID).");
    // Enables the MOSFETS.
    const uint8_t commandID = ENABLE_MOSFETS;
    _comm.sendCommandByUniqueId(uniqueId, commandID, nullptr, 0);
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::trapezoidMoveRaw(int32_t displacement, uint32_t duration) {
    Serial.println("[Motor] trapezoidMoveRaw called.");
    // Move immediately to the given position using the currently set speed (the speed is set by a separate command) (Raw version)
    const uint8_t commandID = TRAPEZOID_MOVE;
    trapezoidMovePayload payload;
    payload.displacement = htole32(displacement);
    payload.duration = htole32(duration);
    sendCommand(commandID, (uint8_t*)&payload, sizeof(payload));
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::trapezoidMoveRaw(uint64_t uniqueId, int32_t displacement, uint32_t duration) {
    Serial.println("[Motor] trapezoidMoveRaw called (by unique ID).");
    // Move immediately to the given position using the currently set speed (the speed is set by a separate command) (Raw version)
    const uint8_t commandID = TRAPEZOID_MOVE;
    trapezoidMovePayload payload;
    payload.displacement = htole32(displacement);
    payload.duration = htole32(duration);
    _comm.sendCommandByUniqueId(uniqueId, commandID, (uint8_t*)&payload, sizeof(payload));
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::trapezoidMove(float displacement, float duration) {
    Serial.println("[Motor] trapezoidMove called.");
    Serial.print("  displacement in chosen unit: "); Serial.println(displacement);
    Serial.print("  duration in chosen unit: "); Serial.println(duration);
    float displacement_internal = ::convertPosition(displacement, m_positionUnit, ConversionDirection::TO_INTERNAL);
    float duration_internal = ::convertTime(duration, m_timeUnit, ConversionDirection::TO_INTERNAL);
    trapezoidMoveRaw((int32_t)(displacement_internal), (uint32_t)(duration_internal));
}

void Servomotor::trapezoidMove(uint64_t uniqueId, float displacement, float duration) {
    Serial.println("[Motor] trapezoidMove called (by unique ID).");
    Serial.print("  displacement in chosen unit: "); Serial.println(displacement);
    Serial.print("  duration in chosen unit: "); Serial.println(duration);
    float displacement_internal = ::convertPosition(displacement, m_positionUnit, ConversionDirection::TO_INTERNAL);
    float duration_internal = ::convertTime(duration, m_timeUnit, ConversionDirection::TO_INTERNAL);
    trapezoidMoveRaw(uniqueId, (int32_t)(displacement_internal), (uint32_t)(duration_internal));
}

void Servomotor::setMaximumVelocityRaw(uint32_t maximumVelocity) {
    Serial.println("[Motor] setMaximumVelocityRaw called.");
    // Sets maximum velocity (this is not used at this time) (Raw version)
    const uint8_t commandID = SET_MAXIMUM_VELOCITY;
    setMaximumVelocityPayload payload;
    payload.maximumVelocity = htole32(maximumVelocity);
    sendCommand(commandID, (uint8_t*)&payload, sizeof(payload));
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::setMaximumVelocityRaw(uint64_t uniqueId, uint32_t maximumVelocity) {
    Serial.println("[Motor] setMaximumVelocityRaw called (by unique ID).");
    // Sets maximum velocity (this is not used at this time) (Raw version)
    const uint8_t commandID = SET_MAXIMUM_VELOCITY;
    setMaximumVelocityPayload payload;
    payload.maximumVelocity = htole32(maximumVelocity);
    _comm.sendCommandByUniqueId(uniqueId, commandID, (uint8_t*)&payload, sizeof(payload));
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::setMaximumVelocity(float maximumVelocity) {
    Serial.println("[Motor] setMaximumVelocity called.");
    Serial.print("  maximumVelocity in chosen unit: "); Serial.println(maximumVelocity);
    float maximumVelocity_internal = ::convertVelocity(maximumVelocity, m_velocityUnit, ConversionDirection::TO_INTERNAL);
    setMaximumVelocityRaw((uint32_t)(maximumVelocity_internal));
}

void Servomotor::setMaximumVelocity(uint64_t uniqueId, float maximumVelocity) {
    Serial.println("[Motor] setMaximumVelocity called (by unique ID).");
    Serial.print("  maximumVelocity in chosen unit: "); Serial.println(maximumVelocity);
    float maximumVelocity_internal = ::convertVelocity(maximumVelocity, m_velocityUnit, ConversionDirection::TO_INTERNAL);
    setMaximumVelocityRaw(uniqueId, (uint32_t)(maximumVelocity_internal));
}

void Servomotor::goToPositionRaw(int32_t position, uint32_t duration) {
    Serial.println("[Motor] goToPositionRaw called.");
    // Move to this new given position in the amount of time specified. Acceleration and deceleration will be applied to make the move smooth. (Raw version)
    const uint8_t commandID = GO_TO_POSITION;
    goToPositionPayload payload;
    payload.position = htole32(position);
    payload.duration = htole32(duration);
    sendCommand(commandID, (uint8_t*)&payload, sizeof(payload));
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::goToPositionRaw(uint64_t uniqueId, int32_t position, uint32_t duration) {
    Serial.println("[Motor] goToPositionRaw called (by unique ID).");
    // Move to this new given position in the amount of time specified. Acceleration and deceleration will be applied to make the move smooth. (Raw version)
    const uint8_t commandID = GO_TO_POSITION;
    goToPositionPayload payload;
    payload.position = htole32(position);
    payload.duration = htole32(duration);
    _comm.sendCommandByUniqueId(uniqueId, commandID, (uint8_t*)&payload, sizeof(payload));
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::goToPosition(float position, float duration) {
    Serial.println("[Motor] goToPosition called.");
    Serial.print("  position in chosen unit: "); Serial.println(position);
    Serial.print("  duration in chosen unit: "); Serial.println(duration);
    float position_internal = ::convertPosition(position, m_positionUnit, ConversionDirection::TO_INTERNAL);
    float duration_internal = ::convertTime(duration, m_timeUnit, ConversionDirection::TO_INTERNAL);
    goToPositionRaw((int32_t)(position_internal), (uint32_t)(duration_internal));
}

void Servomotor::goToPosition(uint64_t uniqueId, float position, float duration) {
    Serial.println("[Motor] goToPosition called (by unique ID).");
    Serial.print("  position in chosen unit: "); Serial.println(position);
    Serial.print("  duration in chosen unit: "); Serial.println(duration);
    float position_internal = ::convertPosition(position, m_positionUnit, ConversionDirection::TO_INTERNAL);
    float duration_internal = ::convertTime(duration, m_timeUnit, ConversionDirection::TO_INTERNAL);
    goToPositionRaw(uniqueId, (int32_t)(position_internal), (uint32_t)(duration_internal));
}

void Servomotor::setMaximumAccelerationRaw(uint32_t maximumAcceleration) {
    Serial.println("[Motor] setMaximumAccelerationRaw called.");
    // Sets max acceleration (Raw version)
    const uint8_t commandID = SET_MAXIMUM_ACCELERATION;
    setMaximumAccelerationPayload payload;
    payload.maximumAcceleration = htole32(maximumAcceleration);
    sendCommand(commandID, (uint8_t*)&payload, sizeof(payload));
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::setMaximumAccelerationRaw(uint64_t uniqueId, uint32_t maximumAcceleration) {
    Serial.println("[Motor] setMaximumAccelerationRaw called (by unique ID).");
    // Sets max acceleration (Raw version)
    const uint8_t commandID = SET_MAXIMUM_ACCELERATION;
    setMaximumAccelerationPayload payload;
    payload.maximumAcceleration = htole32(maximumAcceleration);
    _comm.sendCommandByUniqueId(uniqueId, commandID, (uint8_t*)&payload, sizeof(payload));
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::setMaximumAcceleration(float maximumAcceleration) {
    Serial.println("[Motor] setMaximumAcceleration called.");
    Serial.print("  maximumAcceleration in chosen unit: "); Serial.println(maximumAcceleration);
    float maximumAcceleration_internal = ::convertAcceleration(maximumAcceleration, m_accelerationUnit, ConversionDirection::TO_INTERNAL);
    setMaximumAccelerationRaw((uint32_t)(maximumAcceleration_internal));
}

void Servomotor::setMaximumAcceleration(uint64_t uniqueId, float maximumAcceleration) {
    Serial.println("[Motor] setMaximumAcceleration called (by unique ID).");
    Serial.print("  maximumAcceleration in chosen unit: "); Serial.println(maximumAcceleration);
    float maximumAcceleration_internal = ::convertAcceleration(maximumAcceleration, m_accelerationUnit, ConversionDirection::TO_INTERNAL);
    setMaximumAccelerationRaw(uniqueId, (uint32_t)(maximumAcceleration_internal));
}

void Servomotor::startCalibration() {
    Serial.println("[Motor] startCalibration called.");
    // Starts a calibration, which will determine the average values of the hall sensors and will determine if they are working correctly
    const uint8_t commandID = START_CALIBRATION;
    sendCommand(commandID, nullptr, 0);
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::startCalibration(uint64_t uniqueId) {
    Serial.println("[Motor] startCalibration called (by unique ID).");
    // Starts a calibration, which will determine the average values of the hall sensors and will determine if they are working correctly
    const uint8_t commandID = START_CALIBRATION;
    _comm.sendCommandByUniqueId(uniqueId, commandID, nullptr, 0);
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

captureHallSensorDataResponse Servomotor::captureHallSensorData(uint8_t captureType, uint32_t nPointsToRead, uint8_t channelsToCaptureBitmask, uint16_t timeStepsPerSample, uint16_t nSamplesToSum, uint16_t divisionFactor) {
    Serial.println("[Motor] captureHallSensorData called.");
    // Start sending hall sensor data (work in progress; don't send this command)
    const uint8_t commandID = CAPTURE_HALL_SENSOR_DATA;
    captureHallSensorDataPayload payload;
    payload.captureType = captureType;
    payload.nPointsToRead = htole32(nPointsToRead);
    payload.channelsToCaptureBitmask = channelsToCaptureBitmask;
    payload.timeStepsPerSample = htole16(timeStepsPerSample);
    payload.nSamplesToSum = htole16(nSamplesToSum);
    payload.divisionFactor = htole16(divisionFactor);
    sendCommand(commandID, (uint8_t*)&payload, sizeof(payload));
    uint8_t buffer[sizeof(captureHallSensorDataResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(captureHallSensorDataResponse)) {
            captureHallSensorDataResponse* response = (captureHallSensorDataResponse*)buffer;
            return *response;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    captureHallSensorDataResponse defaultResponse = {0};
    return defaultResponse;
}

captureHallSensorDataResponse Servomotor::captureHallSensorData(uint64_t uniqueId, uint8_t captureType, uint32_t nPointsToRead, uint8_t channelsToCaptureBitmask, uint16_t timeStepsPerSample, uint16_t nSamplesToSum, uint16_t divisionFactor) {
    Serial.println("[Motor] captureHallSensorData called (by unique ID).");
    // Start sending hall sensor data (work in progress; don't send this command)
    const uint8_t commandID = CAPTURE_HALL_SENSOR_DATA;
    captureHallSensorDataPayload payload;
    payload.captureType = captureType;
    payload.nPointsToRead = htole32(nPointsToRead);
    payload.channelsToCaptureBitmask = channelsToCaptureBitmask;
    payload.timeStepsPerSample = htole16(timeStepsPerSample);
    payload.nSamplesToSum = htole16(nSamplesToSum);
    payload.divisionFactor = htole16(divisionFactor);
    _comm.sendCommandByUniqueId(uniqueId, commandID, (uint8_t*)&payload, sizeof(payload));
    uint8_t buffer[sizeof(captureHallSensorDataResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(captureHallSensorDataResponse)) {
            captureHallSensorDataResponse* response = (captureHallSensorDataResponse*)buffer;
            return *response;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    captureHallSensorDataResponse defaultResponse = {0};
    return defaultResponse;
}

void Servomotor::resetTime() {
    Serial.println("[Motor] resetTime called.");
    // Resets the absolute time to zero (call this first before issuing any movement commands)
    const uint8_t commandID = RESET_TIME;
    sendCommand(commandID, nullptr, 0);
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::resetTime(uint64_t uniqueId) {
    Serial.println("[Motor] resetTime called (by unique ID).");
    // Resets the absolute time to zero (call this first before issuing any movement commands)
    const uint8_t commandID = RESET_TIME;
    _comm.sendCommandByUniqueId(uniqueId, commandID, nullptr, 0);
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

uint64_t Servomotor::getCurrentTimeRaw() {
    Serial.println("[Motor] getCurrentTimeRaw called.");
    // Gets the current absolute time (Raw version)
    const uint8_t commandID = GET_CURRENT_TIME;
    sendCommand(commandID, nullptr, 0);
    uint8_t buffer[sizeof(getCurrentTimeResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(getCurrentTimeResponse)) {
            getCurrentTimeResponse* response = (getCurrentTimeResponse*)buffer;
            return response->currentTime;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    getCurrentTimeResponse defaultResponse = {0};
    return defaultResponse.currentTime;
}

uint64_t Servomotor::getCurrentTimeRaw(uint64_t uniqueId) {
    Serial.println("[Motor] getCurrentTimeRaw called (by unique ID).");
    // Gets the current absolute time (Raw version)
    const uint8_t commandID = GET_CURRENT_TIME;
    _comm.sendCommandByUniqueId(uniqueId, commandID, nullptr, 0);
    uint8_t buffer[sizeof(getCurrentTimeResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(getCurrentTimeResponse)) {
            getCurrentTimeResponse* response = (getCurrentTimeResponse*)buffer;
            return response->currentTime;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    getCurrentTimeResponse defaultResponse = {0};
    return defaultResponse.currentTime;
}

float Servomotor::getCurrentTime() {
    Serial.println("[Motor] getCurrentTime called.");
    auto rawResult = getCurrentTimeRaw();
    float converted = ::convertTime((float)rawResult, m_timeUnit, ConversionDirection::FROM_INTERNAL);
    return converted;
}

float Servomotor::getCurrentTime(uint64_t uniqueId) {
    Serial.println("[Motor] getCurrentTime called (by unique ID).");
    auto rawResult = getCurrentTimeRaw(uniqueId);
    float converted = ::convertTime((float)rawResult, m_timeUnit, ConversionDirection::FROM_INTERNAL);
    return converted;
}

timeSyncResponse Servomotor::timeSync(uint64_t masterTime) {
    Serial.println("[Motor] timeSync called.");
    // Sends the master time to the motor so that it can sync its own clock (do this 10 times per second).
    const uint8_t commandID = TIME_SYNC;
    timeSyncPayload payload;
    payload.masterTime = htole64(masterTime);
    sendCommand(commandID, (uint8_t*)&payload, sizeof(payload));
    uint8_t buffer[sizeof(timeSyncResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(timeSyncResponse)) {
            timeSyncResponse* response = (timeSyncResponse*)buffer;
            return *response;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    timeSyncResponse defaultResponse = {0};
    return defaultResponse;
}

timeSyncResponse Servomotor::timeSync(uint64_t uniqueId, uint64_t masterTime) {
    Serial.println("[Motor] timeSync called (by unique ID).");
    // Sends the master time to the motor so that it can sync its own clock (do this 10 times per second).
    const uint8_t commandID = TIME_SYNC;
    timeSyncPayload payload;
    payload.masterTime = htole64(masterTime);
    _comm.sendCommandByUniqueId(uniqueId, commandID, (uint8_t*)&payload, sizeof(payload));
    uint8_t buffer[sizeof(timeSyncResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(timeSyncResponse)) {
            timeSyncResponse* response = (timeSyncResponse*)buffer;
            return *response;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    timeSyncResponse defaultResponse = {0};
    return defaultResponse;
}

uint8_t Servomotor::getNQueuedItems() {
    Serial.println("[Motor] getNQueuedItems called.");
    // Get the number of items currently in the movement queue (if this gets too large, don't queue any more movement commands)
    const uint8_t commandID = GET_N_QUEUED_ITEMS;
    sendCommand(commandID, nullptr, 0);
    uint8_t buffer[sizeof(getNQueuedItemsResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(getNQueuedItemsResponse)) {
            getNQueuedItemsResponse* response = (getNQueuedItemsResponse*)buffer;
            return response->queueSize;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    getNQueuedItemsResponse defaultResponse = {0};
    return defaultResponse.queueSize;
}

uint8_t Servomotor::getNQueuedItems(uint64_t uniqueId) {
    Serial.println("[Motor] getNQueuedItems called (by unique ID).");
    // Get the number of items currently in the movement queue (if this gets too large, don't queue any more movement commands)
    const uint8_t commandID = GET_N_QUEUED_ITEMS;
    _comm.sendCommandByUniqueId(uniqueId, commandID, nullptr, 0);
    uint8_t buffer[sizeof(getNQueuedItemsResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(getNQueuedItemsResponse)) {
            getNQueuedItemsResponse* response = (getNQueuedItemsResponse*)buffer;
            return response->queueSize;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    getNQueuedItemsResponse defaultResponse = {0};
    return defaultResponse.queueSize;
}

void Servomotor::emergencyStop() {
    Serial.println("[Motor] emergencyStop called.");
    // Emergency stop (stop all movement, disable MOSFETS, clear the queue)
    const uint8_t commandID = EMERGENCY_STOP;
    sendCommand(commandID, nullptr, 0);
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::emergencyStop(uint64_t uniqueId) {
    Serial.println("[Motor] emergencyStop called (by unique ID).");
    // Emergency stop (stop all movement, disable MOSFETS, clear the queue)
    const uint8_t commandID = EMERGENCY_STOP;
    _comm.sendCommandByUniqueId(uniqueId, commandID, nullptr, 0);
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::zeroPosition() {
    Serial.println("[Motor] zeroPosition called.");
    // Make the current position the position zero (origin)
    const uint8_t commandID = ZERO_POSITION;
    sendCommand(commandID, nullptr, 0);
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::zeroPosition(uint64_t uniqueId) {
    Serial.println("[Motor] zeroPosition called (by unique ID).");
    // Make the current position the position zero (origin)
    const uint8_t commandID = ZERO_POSITION;
    _comm.sendCommandByUniqueId(uniqueId, commandID, nullptr, 0);
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::homingRaw(int32_t maxDistance, uint32_t maxDuration) {
    Serial.println("[Motor] homingRaw called.");
    // Homing (or in other words, move until a crash and then stop immediately) (Raw version)
    const uint8_t commandID = HOMING;
    homingPayload payload;
    payload.maxDistance = htole32(maxDistance);
    payload.maxDuration = htole32(maxDuration);
    sendCommand(commandID, (uint8_t*)&payload, sizeof(payload));
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::homingRaw(uint64_t uniqueId, int32_t maxDistance, uint32_t maxDuration) {
    Serial.println("[Motor] homingRaw called (by unique ID).");
    // Homing (or in other words, move until a crash and then stop immediately) (Raw version)
    const uint8_t commandID = HOMING;
    homingPayload payload;
    payload.maxDistance = htole32(maxDistance);
    payload.maxDuration = htole32(maxDuration);
    _comm.sendCommandByUniqueId(uniqueId, commandID, (uint8_t*)&payload, sizeof(payload));
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::homing(float maxDistance, float maxDuration) {
    Serial.println("[Motor] homing called.");
    Serial.print("  maxDistance in chosen unit: "); Serial.println(maxDistance);
    Serial.print("  maxDuration in chosen unit: "); Serial.println(maxDuration);
    float maxDistance_internal = ::convertPosition(maxDistance, m_positionUnit, ConversionDirection::TO_INTERNAL);
    float maxDuration_internal = ::convertTime(maxDuration, m_timeUnit, ConversionDirection::TO_INTERNAL);
    homingRaw((int32_t)(maxDistance_internal), (uint32_t)(maxDuration_internal));
}

void Servomotor::homing(uint64_t uniqueId, float maxDistance, float maxDuration) {
    Serial.println("[Motor] homing called (by unique ID).");
    Serial.print("  maxDistance in chosen unit: "); Serial.println(maxDistance);
    Serial.print("  maxDuration in chosen unit: "); Serial.println(maxDuration);
    float maxDistance_internal = ::convertPosition(maxDistance, m_positionUnit, ConversionDirection::TO_INTERNAL);
    float maxDuration_internal = ::convertTime(maxDuration, m_timeUnit, ConversionDirection::TO_INTERNAL);
    homingRaw(uniqueId, (int32_t)(maxDistance_internal), (uint32_t)(maxDuration_internal));
}

int64_t Servomotor::getHallSensorPositionRaw() {
    Serial.println("[Motor] getHallSensorPositionRaw called.");
    // Get the position as measured by the hall sensors (this should be the actual position of the motor and if everything is ok then it will be about the same as the desired position) (Raw version)
    const uint8_t commandID = GET_HALL_SENSOR_POSITION;
    sendCommand(commandID, nullptr, 0);
    uint8_t buffer[sizeof(getHallSensorPositionResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(getHallSensorPositionResponse)) {
            getHallSensorPositionResponse* response = (getHallSensorPositionResponse*)buffer;
            return response->hallSensorPosition;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    getHallSensorPositionResponse defaultResponse = {0};
    return defaultResponse.hallSensorPosition;
}

int64_t Servomotor::getHallSensorPositionRaw(uint64_t uniqueId) {
    Serial.println("[Motor] getHallSensorPositionRaw called (by unique ID).");
    // Get the position as measured by the hall sensors (this should be the actual position of the motor and if everything is ok then it will be about the same as the desired position) (Raw version)
    const uint8_t commandID = GET_HALL_SENSOR_POSITION;
    _comm.sendCommandByUniqueId(uniqueId, commandID, nullptr, 0);
    uint8_t buffer[sizeof(getHallSensorPositionResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(getHallSensorPositionResponse)) {
            getHallSensorPositionResponse* response = (getHallSensorPositionResponse*)buffer;
            return response->hallSensorPosition;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    getHallSensorPositionResponse defaultResponse = {0};
    return defaultResponse.hallSensorPosition;
}

float Servomotor::getHallSensorPosition() {
    Serial.println("[Motor] getHallSensorPosition called.");
    auto rawResult = getHallSensorPositionRaw();
    float converted = ::convertPosition((float)rawResult, m_positionUnit, ConversionDirection::FROM_INTERNAL);
    return converted;
}

float Servomotor::getHallSensorPosition(uint64_t uniqueId) {
    Serial.println("[Motor] getHallSensorPosition called (by unique ID).");
    auto rawResult = getHallSensorPositionRaw(uniqueId);
    float converted = ::convertPosition((float)rawResult, m_positionUnit, ConversionDirection::FROM_INTERNAL);
    return converted;
}

getStatusResponse Servomotor::getStatus() {
    Serial.println("[Motor] getStatus called.");
    // Gets the status of the motor
    const uint8_t commandID = GET_STATUS;
    sendCommand(commandID, nullptr, 0);
    uint8_t buffer[sizeof(getStatusResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(getStatusResponse)) {
            getStatusResponse* response = (getStatusResponse*)buffer;
            return *response;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    getStatusResponse defaultResponse = {0};
    return defaultResponse;
}

getStatusResponse Servomotor::getStatus(uint64_t uniqueId) {
    Serial.println("[Motor] getStatus called (by unique ID).");
    // Gets the status of the motor
    const uint8_t commandID = GET_STATUS;
    _comm.sendCommandByUniqueId(uniqueId, commandID, nullptr, 0);
    uint8_t buffer[sizeof(getStatusResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(getStatusResponse)) {
            getStatusResponse* response = (getStatusResponse*)buffer;
            return *response;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    getStatusResponse defaultResponse = {0};
    return defaultResponse;
}

void Servomotor::goToClosedLoop() {
    Serial.println("[Motor] goToClosedLoop called.");
    // Go to closed loop position control mode
    const uint8_t commandID = GO_TO_CLOSED_LOOP;
    sendCommand(commandID, nullptr, 0);
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::goToClosedLoop(uint64_t uniqueId) {
    Serial.println("[Motor] goToClosedLoop called (by unique ID).");
    // Go to closed loop position control mode
    const uint8_t commandID = GO_TO_CLOSED_LOOP;
    _comm.sendCommandByUniqueId(uniqueId, commandID, nullptr, 0);
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

getProductSpecsResponse Servomotor::getProductSpecs() {
    Serial.println("[Motor] getProductSpecs called.");
    // Get the update frequency (reciprocal of the time step)
    const uint8_t commandID = GET_PRODUCT_SPECS;
    sendCommand(commandID, nullptr, 0);
    uint8_t buffer[sizeof(getProductSpecsResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(getProductSpecsResponse)) {
            getProductSpecsResponse* response = (getProductSpecsResponse*)buffer;
            return *response;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    getProductSpecsResponse defaultResponse = {0};
    return defaultResponse;
}

getProductSpecsResponse Servomotor::getProductSpecs(uint64_t uniqueId) {
    Serial.println("[Motor] getProductSpecs called (by unique ID).");
    // Get the update frequency (reciprocal of the time step)
    const uint8_t commandID = GET_PRODUCT_SPECS;
    _comm.sendCommandByUniqueId(uniqueId, commandID, nullptr, 0);
    uint8_t buffer[sizeof(getProductSpecsResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(getProductSpecsResponse)) {
            getProductSpecsResponse* response = (getProductSpecsResponse*)buffer;
            return *response;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    getProductSpecsResponse defaultResponse = {0};
    return defaultResponse;
}

void Servomotor::moveWithAccelerationRaw(int32_t acceleration, uint32_t timeSteps) {
    Serial.println("[Motor] moveWithAccelerationRaw called.");
    // Rotates the motor with the specified acceleration (Raw version)
    const uint8_t commandID = MOVE_WITH_ACCELERATION;
    moveWithAccelerationPayload payload;
    payload.acceleration = htole32(acceleration);
    payload.timeSteps = htole32(timeSteps);
    sendCommand(commandID, (uint8_t*)&payload, sizeof(payload));
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::moveWithAccelerationRaw(uint64_t uniqueId, int32_t acceleration, uint32_t timeSteps) {
    Serial.println("[Motor] moveWithAccelerationRaw called (by unique ID).");
    // Rotates the motor with the specified acceleration (Raw version)
    const uint8_t commandID = MOVE_WITH_ACCELERATION;
    moveWithAccelerationPayload payload;
    payload.acceleration = htole32(acceleration);
    payload.timeSteps = htole32(timeSteps);
    _comm.sendCommandByUniqueId(uniqueId, commandID, (uint8_t*)&payload, sizeof(payload));
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::moveWithAcceleration(float acceleration, float timeSteps) {
    Serial.println("[Motor] moveWithAcceleration called.");
    Serial.print("  acceleration in chosen unit: "); Serial.println(acceleration);
    Serial.print("  timeSteps in chosen unit: "); Serial.println(timeSteps);
    float acceleration_internal = ::convertAcceleration(acceleration, m_accelerationUnit, ConversionDirection::TO_INTERNAL);
    float timeSteps_internal = ::convertTime(timeSteps, m_timeUnit, ConversionDirection::TO_INTERNAL);
    moveWithAccelerationRaw((int32_t)(acceleration_internal), (uint32_t)(timeSteps_internal));
}

void Servomotor::moveWithAcceleration(uint64_t uniqueId, float acceleration, float timeSteps) {
    Serial.println("[Motor] moveWithAcceleration called (by unique ID).");
    Serial.print("  acceleration in chosen unit: "); Serial.println(acceleration);
    Serial.print("  timeSteps in chosen unit: "); Serial.println(timeSteps);
    float acceleration_internal = ::convertAcceleration(acceleration, m_accelerationUnit, ConversionDirection::TO_INTERNAL);
    float timeSteps_internal = ::convertTime(timeSteps, m_timeUnit, ConversionDirection::TO_INTERNAL);
    moveWithAccelerationRaw(uniqueId, (int32_t)(acceleration_internal), (uint32_t)(timeSteps_internal));
}

detectDevicesResponse Servomotor::detectDevices() {
    Serial.println("[Motor] detectDevices called.");
    // Detect all of the devices that are connected on the RS485 interface. Devices will identify themselves at a random time within one seconde. Chance of collision is possible but unlikely. You can repeat this if you suspect a collision (like if you have devices connected but they were not discovered within one to two seconds).
    const uint8_t commandID = DETECT_DEVICES;
    sendCommand(commandID, nullptr, 0);
    uint8_t buffer[sizeof(detectDevicesResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(detectDevicesResponse)) {
            detectDevicesResponse* response = (detectDevicesResponse*)buffer;
            return *response;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    detectDevicesResponse defaultResponse = {0};
    return defaultResponse;
}

detectDevicesResponse Servomotor::detectDevices(uint64_t uniqueId) {
    Serial.println("[Motor] detectDevices called (by unique ID).");
    // Detect all of the devices that are connected on the RS485 interface. Devices will identify themselves at a random time within one seconde. Chance of collision is possible but unlikely. You can repeat this if you suspect a collision (like if you have devices connected but they were not discovered within one to two seconds).
    const uint8_t commandID = DETECT_DEVICES;
    _comm.sendCommandByUniqueId(uniqueId, commandID, nullptr, 0);
    uint8_t buffer[sizeof(detectDevicesResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(detectDevicesResponse)) {
            detectDevicesResponse* response = (detectDevicesResponse*)buffer;
            return *response;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    detectDevicesResponse defaultResponse = {0};
    return defaultResponse;
}

detectDevicesResponse Servomotor::detectDevicesGetAnotherResponse() {
    Serial.println("[Motor] detectDevicesGetAnotherResponse called.");
    uint8_t buffer[sizeof(detectDevicesResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(detectDevicesResponse)) {
            detectDevicesResponse* response = (detectDevicesResponse*)buffer;
            return *response;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    detectDevicesResponse defaultResponse = {0};
    return defaultResponse;
}

void Servomotor::setDeviceAlias(uint8_t alias) {
    Serial.println("[Motor] setDeviceAlias called.");
    // Sets device alias
    const uint8_t commandID = SET_DEVICE_ALIAS;
    setDeviceAliasPayload payload;
    payload.alias = alias;
    sendCommand(commandID, (uint8_t*)&payload, sizeof(payload));
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::setDeviceAlias(uint64_t uniqueId, uint8_t alias) {
    Serial.println("[Motor] setDeviceAlias called (by unique ID).");
    // Sets device alias
    const uint8_t commandID = SET_DEVICE_ALIAS;
    setDeviceAliasPayload payload;
    payload.alias = alias;
    _comm.sendCommandByUniqueId(uniqueId, commandID, (uint8_t*)&payload, sizeof(payload));
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

getProductInfoResponse Servomotor::getProductInfo() {
    Serial.println("[Motor] getProductInfo called.");
    // Get product information
    const uint8_t commandID = GET_PRODUCT_INFO;
    sendCommand(commandID, nullptr, 0);
    uint8_t buffer[sizeof(getProductInfoResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(getProductInfoResponse)) {
            getProductInfoResponse* response = (getProductInfoResponse*)buffer;
            return *response;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    getProductInfoResponse defaultResponse = {0};
    return defaultResponse;
}

getProductInfoResponse Servomotor::getProductInfo(uint64_t uniqueId) {
    Serial.println("[Motor] getProductInfo called (by unique ID).");
    // Get product information
    const uint8_t commandID = GET_PRODUCT_INFO;
    _comm.sendCommandByUniqueId(uniqueId, commandID, nullptr, 0);
    uint8_t buffer[sizeof(getProductInfoResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(getProductInfoResponse)) {
            getProductInfoResponse* response = (getProductInfoResponse*)buffer;
            return *response;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    getProductInfoResponse defaultResponse = {0};
    return defaultResponse;
}

void Servomotor::firmwareUpgrade(uint8_t firmwarePage[2058]) {
    Serial.println("[Motor] firmwareUpgrade called.");
    // This command will upgrade the flash memory of the servo motor. Before issuing a firmware upgrade command, you must do some calculations as shown in the examples.
    const uint8_t commandID = FIRMWARE_UPGRADE;
    firmwareUpgradePayload payload;
    // Copy array data into payload
    memcpy(payload.firmwarePage, firmwarePage, sizeof(payload.firmwarePage));
    sendCommand(commandID, (uint8_t*)&payload, sizeof(payload));
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::firmwareUpgrade(uint64_t uniqueId, uint8_t firmwarePage[2058]) {
    Serial.println("[Motor] firmwareUpgrade called (by unique ID).");
    // This command will upgrade the flash memory of the servo motor. Before issuing a firmware upgrade command, you must do some calculations as shown in the examples.
    const uint8_t commandID = FIRMWARE_UPGRADE;
    firmwareUpgradePayload payload;
    // Copy array data into payload
    memcpy(payload.firmwarePage, firmwarePage, sizeof(payload.firmwarePage));
    _comm.sendCommandByUniqueId(uniqueId, commandID, (uint8_t*)&payload, sizeof(payload));
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

getProductDescriptionResponse Servomotor::getProductDescription() {
    Serial.println("[Motor] getProductDescription called.");
    // Get the product description.
    const uint8_t commandID = GET_PRODUCT_DESCRIPTION;
    sendCommand(commandID, nullptr, 0);
    uint8_t buffer[sizeof(getProductDescriptionResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(getProductDescriptionResponse)) {
            getProductDescriptionResponse* response = (getProductDescriptionResponse*)buffer;
            return *response;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    getProductDescriptionResponse defaultResponse = {0};
    return defaultResponse;
}

getProductDescriptionResponse Servomotor::getProductDescription(uint64_t uniqueId) {
    Serial.println("[Motor] getProductDescription called (by unique ID).");
    // Get the product description.
    const uint8_t commandID = GET_PRODUCT_DESCRIPTION;
    _comm.sendCommandByUniqueId(uniqueId, commandID, nullptr, 0);
    uint8_t buffer[sizeof(getProductDescriptionResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(getProductDescriptionResponse)) {
            getProductDescriptionResponse* response = (getProductDescriptionResponse*)buffer;
            return *response;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    getProductDescriptionResponse defaultResponse = {0};
    return defaultResponse;
}

getFirmwareVersionResponse Servomotor::getFirmwareVersion() {
    Serial.println("[Motor] getFirmwareVersion called.");
    // Get the firmware version or the bootloader version depending on what mode we are in. This command also returns the status bits, where the least significan bit teels us if we are currently in the bootloader (=1) or the main firmware (=0)
    const uint8_t commandID = GET_FIRMWARE_VERSION;
    sendCommand(commandID, nullptr, 0);
    uint8_t buffer[sizeof(getFirmwareVersionResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(getFirmwareVersionResponse)) {
            getFirmwareVersionResponse* response = (getFirmwareVersionResponse*)buffer;
            return *response;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    getFirmwareVersionResponse defaultResponse = {0};
    return defaultResponse;
}

getFirmwareVersionResponse Servomotor::getFirmwareVersion(uint64_t uniqueId) {
    Serial.println("[Motor] getFirmwareVersion called (by unique ID).");
    // Get the firmware version or the bootloader version depending on what mode we are in. This command also returns the status bits, where the least significan bit teels us if we are currently in the bootloader (=1) or the main firmware (=0)
    const uint8_t commandID = GET_FIRMWARE_VERSION;
    _comm.sendCommandByUniqueId(uniqueId, commandID, nullptr, 0);
    uint8_t buffer[sizeof(getFirmwareVersionResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(getFirmwareVersionResponse)) {
            getFirmwareVersionResponse* response = (getFirmwareVersionResponse*)buffer;
            return *response;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    getFirmwareVersionResponse defaultResponse = {0};
    return defaultResponse;
}

void Servomotor::moveWithVelocityRaw(int32_t velocity, uint32_t duration) {
    Serial.println("[Motor] moveWithVelocityRaw called.");
    // Rotates the motor with the specified velocity. (Raw version)
    const uint8_t commandID = MOVE_WITH_VELOCITY;
    moveWithVelocityPayload payload;
    payload.velocity = htole32(velocity);
    payload.duration = htole32(duration);
    sendCommand(commandID, (uint8_t*)&payload, sizeof(payload));
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::moveWithVelocityRaw(uint64_t uniqueId, int32_t velocity, uint32_t duration) {
    Serial.println("[Motor] moveWithVelocityRaw called (by unique ID).");
    // Rotates the motor with the specified velocity. (Raw version)
    const uint8_t commandID = MOVE_WITH_VELOCITY;
    moveWithVelocityPayload payload;
    payload.velocity = htole32(velocity);
    payload.duration = htole32(duration);
    _comm.sendCommandByUniqueId(uniqueId, commandID, (uint8_t*)&payload, sizeof(payload));
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::moveWithVelocity(float velocity, float duration) {
    Serial.println("[Motor] moveWithVelocity called.");
    Serial.print("  velocity in chosen unit: "); Serial.println(velocity);
    Serial.print("  duration in chosen unit: "); Serial.println(duration);
    float velocity_internal = ::convertVelocity(velocity, m_velocityUnit, ConversionDirection::TO_INTERNAL);
    float duration_internal = ::convertTime(duration, m_timeUnit, ConversionDirection::TO_INTERNAL);
    moveWithVelocityRaw((int32_t)(velocity_internal), (uint32_t)(duration_internal));
}

void Servomotor::moveWithVelocity(uint64_t uniqueId, float velocity, float duration) {
    Serial.println("[Motor] moveWithVelocity called (by unique ID).");
    Serial.print("  velocity in chosen unit: "); Serial.println(velocity);
    Serial.print("  duration in chosen unit: "); Serial.println(duration);
    float velocity_internal = ::convertVelocity(velocity, m_velocityUnit, ConversionDirection::TO_INTERNAL);
    float duration_internal = ::convertTime(duration, m_timeUnit, ConversionDirection::TO_INTERNAL);
    moveWithVelocityRaw(uniqueId, (int32_t)(velocity_internal), (uint32_t)(duration_internal));
}

void Servomotor::systemReset() {
    Serial.println("[Motor] systemReset called.");
    // System reset / go to the bootloader. The motor will reset immediately and will enter the bootloader. If there is no command sent within a short time, the motor will exit the bootloader and run the application from the beginning.
    const uint8_t commandID = SYSTEM_RESET;
    sendCommand(commandID, nullptr, 0);
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::systemReset(uint64_t uniqueId) {
    Serial.println("[Motor] systemReset called (by unique ID).");
    // System reset / go to the bootloader. The motor will reset immediately and will enter the bootloader. If there is no command sent within a short time, the motor will exit the bootloader and run the application from the beginning.
    const uint8_t commandID = SYSTEM_RESET;
    _comm.sendCommandByUniqueId(uniqueId, commandID, nullptr, 0);
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::setMaximumMotorCurrentRaw(uint16_t motorCurrent, uint16_t regenerationCurrent) {
    Serial.println("[Motor] setMaximumMotorCurrentRaw called.");
    // Set the maximum motor current and maximum regeneration current. The values are stored in non-volatile memory and survive a reset. (Raw version)
    const uint8_t commandID = SET_MAXIMUM_MOTOR_CURRENT;
    setMaximumMotorCurrentPayload payload;
    payload.motorCurrent = htole16(motorCurrent);
    payload.regenerationCurrent = htole16(regenerationCurrent);
    sendCommand(commandID, (uint8_t*)&payload, sizeof(payload));
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::setMaximumMotorCurrentRaw(uint64_t uniqueId, uint16_t motorCurrent, uint16_t regenerationCurrent) {
    Serial.println("[Motor] setMaximumMotorCurrentRaw called (by unique ID).");
    // Set the maximum motor current and maximum regeneration current. The values are stored in non-volatile memory and survive a reset. (Raw version)
    const uint8_t commandID = SET_MAXIMUM_MOTOR_CURRENT;
    setMaximumMotorCurrentPayload payload;
    payload.motorCurrent = htole16(motorCurrent);
    payload.regenerationCurrent = htole16(regenerationCurrent);
    _comm.sendCommandByUniqueId(uniqueId, commandID, (uint8_t*)&payload, sizeof(payload));
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::setMaximumMotorCurrent(float motorCurrent, float regenerationCurrent) {
    Serial.println("[Motor] setMaximumMotorCurrent called.");
    Serial.print("  motorCurrent in chosen unit: "); Serial.println(motorCurrent);
    Serial.print("  regenerationCurrent in chosen unit: "); Serial.println(regenerationCurrent);
    float motorCurrent_internal = ::convertCurrent(motorCurrent, m_currentUnit, ConversionDirection::TO_INTERNAL);
    float regenerationCurrent_internal = ::convertCurrent(regenerationCurrent, m_currentUnit, ConversionDirection::TO_INTERNAL);
    setMaximumMotorCurrentRaw((uint16_t)(motorCurrent_internal), (uint16_t)(regenerationCurrent_internal));
}

void Servomotor::setMaximumMotorCurrent(uint64_t uniqueId, float motorCurrent, float regenerationCurrent) {
    Serial.println("[Motor] setMaximumMotorCurrent called (by unique ID).");
    Serial.print("  motorCurrent in chosen unit: "); Serial.println(motorCurrent);
    Serial.print("  regenerationCurrent in chosen unit: "); Serial.println(regenerationCurrent);
    float motorCurrent_internal = ::convertCurrent(motorCurrent, m_currentUnit, ConversionDirection::TO_INTERNAL);
    float regenerationCurrent_internal = ::convertCurrent(regenerationCurrent, m_currentUnit, ConversionDirection::TO_INTERNAL);
    setMaximumMotorCurrentRaw(uniqueId, (uint16_t)(motorCurrent_internal), (uint16_t)(regenerationCurrent_internal));
}

void Servomotor::multimoveRaw(uint8_t moveCount, uint32_t moveTypes, multimoveList_t* moveList) {
    Serial.println("[Motor] multimoveRaw called.");
    // The multimove command allows you to compose multiple moves one after another. Please note that when the queue becomes empty after all the moves are executed and the motor is not at a standstill then a fatal error will be triggered. (Raw version)
    const uint8_t commandID = MULTIMOVE;
    multimovePayload payload;
    payload.moveCount = moveCount;
    payload.moveTypes = htole32(moveTypes);
    // Calculate the actual size of the move list data
    uint16_t moveListSize = moveCount * sizeof(multimoveList_t);
    // Copy list data into payload
    memcpy(payload.moveList, moveList, moveListSize);
    // Calculate the actual payload size (just the header plus the used entries)
    uint16_t payloadSize = sizeof(payload.moveCount) + sizeof(payload.moveTypes) + moveListSize;
    sendCommand(commandID, (uint8_t*)&payload, payloadSize);
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::multimoveRaw(uint64_t uniqueId, uint8_t moveCount, uint32_t moveTypes, multimoveList_t* moveList) {
    Serial.println("[Motor] multimoveRaw called (by unique ID).");
    // The multimove command allows you to compose multiple moves one after another. Please note that when the queue becomes empty after all the moves are executed and the motor is not at a standstill then a fatal error will be triggered. (Raw version)
    const uint8_t commandID = MULTIMOVE;
    multimovePayload payload;
    payload.moveCount = moveCount;
    payload.moveTypes = htole32(moveTypes);
    // Calculate the actual size of the move list data
    uint16_t moveListSize = moveCount * sizeof(multimoveList_t);
    // Copy list data into payload
    memcpy(payload.moveList, moveList, moveListSize);
    // Calculate the actual payload size (just the header plus the used entries)
    uint16_t payloadSize = sizeof(payload.moveCount) + sizeof(payload.moveTypes) + moveListSize;
    _comm.sendCommandByUniqueId(uniqueId, commandID, (uint8_t*)&payload, payloadSize);
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::multimove(uint8_t moveCount, uint32_t moveTypes, multimoveListConverted_t* moveList) {
    Serial.println("[Motor] multimove called.");
    Serial.println("  moveList in chosen unit: [complex object - cannot display directly]");
    // Convert list items from user units to internal units
    multimoveList_t convertedList[32];
    for (int i = 0; i < moveCount; i++) {
        // Determine conversion based on move type (velocity or acceleration)
        bool isVelocity = (moveTypes & (1 << i)) != 0;
        if (isVelocity) {
            convertedList[i].value = (int32_t)::convertVelocity(moveList[i].value, m_velocityUnit, ConversionDirection::TO_INTERNAL);
        } else {
            convertedList[i].value = (int32_t)::convertAcceleration(moveList[i].value, m_accelerationUnit, ConversionDirection::TO_INTERNAL);
        }
        convertedList[i].timeSteps = (uint32_t)::convertTime(moveList[i].duration, m_timeUnit, ConversionDirection::TO_INTERNAL);
    }
    multimoveRaw(moveCount, moveTypes, convertedList);
}

void Servomotor::multimove(uint64_t uniqueId, uint8_t moveCount, uint32_t moveTypes, multimoveListConverted_t* moveList) {
    Serial.println("[Motor] multimove called (by unique ID).");
    Serial.println("  moveList in chosen unit: [complex object - cannot display directly]");
    // Convert list items from user units to internal units
    multimoveList_t convertedList[32];
    for (int i = 0; i < moveCount; i++) {
        // Determine conversion based on move type (velocity or acceleration)
        bool isVelocity = (moveTypes & (1 << i)) != 0;
        if (isVelocity) {
            convertedList[i].value = (int32_t)::convertVelocity(moveList[i].value, m_velocityUnit, ConversionDirection::TO_INTERNAL);
        } else {
            convertedList[i].value = (int32_t)::convertAcceleration(moveList[i].value, m_accelerationUnit, ConversionDirection::TO_INTERNAL);
        }
        convertedList[i].timeSteps = (uint32_t)::convertTime(moveList[i].duration, m_timeUnit, ConversionDirection::TO_INTERNAL);
    }
    multimoveRaw(uniqueId, moveCount, moveTypes, convertedList);
}

void Servomotor::setSafetyLimitsRaw(int64_t lowerLimit, int64_t upperLimit) {
    Serial.println("[Motor] setSafetyLimitsRaw called.");
    // Set safety limits (to prevent motion from exceeding set bounds) (Raw version)
    const uint8_t commandID = SET_SAFETY_LIMITS;
    setSafetyLimitsPayload payload;
    payload.lowerLimit = htole64(lowerLimit);
    payload.upperLimit = htole64(upperLimit);
    sendCommand(commandID, (uint8_t*)&payload, sizeof(payload));
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::setSafetyLimitsRaw(uint64_t uniqueId, int64_t lowerLimit, int64_t upperLimit) {
    Serial.println("[Motor] setSafetyLimitsRaw called (by unique ID).");
    // Set safety limits (to prevent motion from exceeding set bounds) (Raw version)
    const uint8_t commandID = SET_SAFETY_LIMITS;
    setSafetyLimitsPayload payload;
    payload.lowerLimit = htole64(lowerLimit);
    payload.upperLimit = htole64(upperLimit);
    _comm.sendCommandByUniqueId(uniqueId, commandID, (uint8_t*)&payload, sizeof(payload));
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::setSafetyLimits(float lowerLimit, float upperLimit) {
    Serial.println("[Motor] setSafetyLimits called.");
    Serial.print("  lowerLimit in chosen unit: "); Serial.println(lowerLimit);
    Serial.print("  upperLimit in chosen unit: "); Serial.println(upperLimit);
    float lowerLimit_internal = ::convertPosition(lowerLimit, m_positionUnit, ConversionDirection::TO_INTERNAL);
    float upperLimit_internal = ::convertPosition(upperLimit, m_positionUnit, ConversionDirection::TO_INTERNAL);
    setSafetyLimitsRaw((int64_t)(lowerLimit_internal), (int64_t)(upperLimit_internal));
}

void Servomotor::setSafetyLimits(uint64_t uniqueId, float lowerLimit, float upperLimit) {
    Serial.println("[Motor] setSafetyLimits called (by unique ID).");
    Serial.print("  lowerLimit in chosen unit: "); Serial.println(lowerLimit);
    Serial.print("  upperLimit in chosen unit: "); Serial.println(upperLimit);
    float lowerLimit_internal = ::convertPosition(lowerLimit, m_positionUnit, ConversionDirection::TO_INTERNAL);
    float upperLimit_internal = ::convertPosition(upperLimit, m_positionUnit, ConversionDirection::TO_INTERNAL);
    setSafetyLimitsRaw(uniqueId, (int64_t)(lowerLimit_internal), (int64_t)(upperLimit_internal));
}

pingResponse Servomotor::ping(uint8_t pingData[10]) {
    Serial.println("[Motor] ping called.");
    // Send a payload containing any data and the device will respond with the same data back
    const uint8_t commandID = PING;
    pingPayload payload;
    // Copy array data into payload
    memcpy(payload.pingData, pingData, sizeof(payload.pingData));
    sendCommand(commandID, (uint8_t*)&payload, sizeof(payload));
    uint8_t buffer[sizeof(pingResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(pingResponse)) {
            pingResponse* response = (pingResponse*)buffer;
            return *response;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    pingResponse defaultResponse = {0};
    return defaultResponse;
}

pingResponse Servomotor::ping(uint64_t uniqueId, uint8_t pingData[10]) {
    Serial.println("[Motor] ping called (by unique ID).");
    // Send a payload containing any data and the device will respond with the same data back
    const uint8_t commandID = PING;
    pingPayload payload;
    // Copy array data into payload
    memcpy(payload.pingData, pingData, sizeof(payload.pingData));
    _comm.sendCommandByUniqueId(uniqueId, commandID, (uint8_t*)&payload, sizeof(payload));
    uint8_t buffer[sizeof(pingResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(pingResponse)) {
            pingResponse* response = (pingResponse*)buffer;
            return *response;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    pingResponse defaultResponse = {0};
    return defaultResponse;
}

void Servomotor::controlHallSensorStatistics(uint8_t control) {
    Serial.println("[Motor] controlHallSensorStatistics called.");
    // Turn on or off the gathering of statistics for the hall sensors and reset the statistics
    const uint8_t commandID = CONTROL_HALL_SENSOR_STATISTICS;
    controlHallSensorStatisticsPayload payload;
    payload.control = control;
    sendCommand(commandID, (uint8_t*)&payload, sizeof(payload));
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::controlHallSensorStatistics(uint64_t uniqueId, uint8_t control) {
    Serial.println("[Motor] controlHallSensorStatistics called (by unique ID).");
    // Turn on or off the gathering of statistics for the hall sensors and reset the statistics
    const uint8_t commandID = CONTROL_HALL_SENSOR_STATISTICS;
    controlHallSensorStatisticsPayload payload;
    payload.control = control;
    _comm.sendCommandByUniqueId(uniqueId, commandID, (uint8_t*)&payload, sizeof(payload));
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

getHallSensorStatisticsResponse Servomotor::getHallSensorStatistics() {
    Serial.println("[Motor] getHallSensorStatistics called.");
    // Read back the statistics gathered from the hall sensors. Useful for checking the hall sensor health and noise in the system.
    const uint8_t commandID = GET_HALL_SENSOR_STATISTICS;
    sendCommand(commandID, nullptr, 0);
    uint8_t buffer[sizeof(getHallSensorStatisticsResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(getHallSensorStatisticsResponse)) {
            getHallSensorStatisticsResponse* response = (getHallSensorStatisticsResponse*)buffer;
            return *response;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    getHallSensorStatisticsResponse defaultResponse = {0};
    return defaultResponse;
}

getHallSensorStatisticsResponse Servomotor::getHallSensorStatistics(uint64_t uniqueId) {
    Serial.println("[Motor] getHallSensorStatistics called (by unique ID).");
    // Read back the statistics gathered from the hall sensors. Useful for checking the hall sensor health and noise in the system.
    const uint8_t commandID = GET_HALL_SENSOR_STATISTICS;
    _comm.sendCommandByUniqueId(uniqueId, commandID, nullptr, 0);
    uint8_t buffer[sizeof(getHallSensorStatisticsResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(getHallSensorStatisticsResponse)) {
            getHallSensorStatisticsResponse* response = (getHallSensorStatisticsResponse*)buffer;
            return *response;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    getHallSensorStatisticsResponse defaultResponse = {0};
    return defaultResponse;
}

int64_t Servomotor::getPositionRaw() {
    Serial.println("[Motor] getPositionRaw called.");
    // Get the current desired position (which may differ a bit from the actual position as measured by the hall sensors) (Raw version)
    const uint8_t commandID = GET_POSITION;
    sendCommand(commandID, nullptr, 0);
    uint8_t buffer[sizeof(getPositionResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(getPositionResponse)) {
            getPositionResponse* response = (getPositionResponse*)buffer;
            return response->position;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    getPositionResponse defaultResponse = {0};
    return defaultResponse.position;
}

int64_t Servomotor::getPositionRaw(uint64_t uniqueId) {
    Serial.println("[Motor] getPositionRaw called (by unique ID).");
    // Get the current desired position (which may differ a bit from the actual position as measured by the hall sensors) (Raw version)
    const uint8_t commandID = GET_POSITION;
    _comm.sendCommandByUniqueId(uniqueId, commandID, nullptr, 0);
    uint8_t buffer[sizeof(getPositionResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(getPositionResponse)) {
            getPositionResponse* response = (getPositionResponse*)buffer;
            return response->position;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    getPositionResponse defaultResponse = {0};
    return defaultResponse.position;
}

float Servomotor::getPosition() {
    Serial.println("[Motor] getPosition called.");
    auto rawResult = getPositionRaw();
    float converted = ::convertPosition((float)rawResult, m_positionUnit, ConversionDirection::FROM_INTERNAL);
    return converted;
}

float Servomotor::getPosition(uint64_t uniqueId) {
    Serial.println("[Motor] getPosition called (by unique ID).");
    auto rawResult = getPositionRaw(uniqueId);
    float converted = ::convertPosition((float)rawResult, m_positionUnit, ConversionDirection::FROM_INTERNAL);
    return converted;
}

readMultipurposeBufferResponse Servomotor::readMultipurposeBuffer() {
    Serial.println("[Motor] readMultipurposeBuffer called.");
    // Read whatever is in the multipurpose buffer (the buffer is used for data generated during calibration, going to closed loop mode, and when capturing hall sensor data)
    const uint8_t commandID = READ_MULTIPURPOSE_BUFFER;
    sendCommand(commandID, nullptr, 0);
    uint8_t buffer[sizeof(readMultipurposeBufferResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(readMultipurposeBufferResponse)) {
            readMultipurposeBufferResponse* response = (readMultipurposeBufferResponse*)buffer;
            return *response;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    readMultipurposeBufferResponse defaultResponse = {0};
    return defaultResponse;
}

readMultipurposeBufferResponse Servomotor::readMultipurposeBuffer(uint64_t uniqueId) {
    Serial.println("[Motor] readMultipurposeBuffer called (by unique ID).");
    // Read whatever is in the multipurpose buffer (the buffer is used for data generated during calibration, going to closed loop mode, and when capturing hall sensor data)
    const uint8_t commandID = READ_MULTIPURPOSE_BUFFER;
    _comm.sendCommandByUniqueId(uniqueId, commandID, nullptr, 0);
    uint8_t buffer[sizeof(readMultipurposeBufferResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(readMultipurposeBufferResponse)) {
            readMultipurposeBufferResponse* response = (readMultipurposeBufferResponse*)buffer;
            return *response;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    readMultipurposeBufferResponse defaultResponse = {0};
    return defaultResponse;
}

void Servomotor::testMode(uint8_t testMode) {
    Serial.println("[Motor] testMode called.");
    // Set or trigger a certain test mode. This is a bit undocumented at the moment. Don't use this unless you are a developer working on test cases.
    const uint8_t commandID = TEST_MODE;
    testModePayload payload;
    payload.testMode = testMode;
    sendCommand(commandID, (uint8_t*)&payload, sizeof(payload));
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::testMode(uint64_t uniqueId, uint8_t testMode) {
    Serial.println("[Motor] testMode called (by unique ID).");
    // Set or trigger a certain test mode. This is a bit undocumented at the moment. Don't use this unless you are a developer working on test cases.
    const uint8_t commandID = TEST_MODE;
    testModePayload payload;
    payload.testMode = testMode;
    _comm.sendCommandByUniqueId(uniqueId, commandID, (uint8_t*)&payload, sizeof(payload));
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

getComprehensivePositionResponse Servomotor::getComprehensivePositionRaw() {
    Serial.println("[Motor] getComprehensivePositionRaw called.");
    // Get the desired motor position, hall sensor position, and external encoder position all in one shot (Raw version)
    const uint8_t commandID = GET_COMPREHENSIVE_POSITION;
    sendCommand(commandID, nullptr, 0);
    uint8_t buffer[sizeof(getComprehensivePositionResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(getComprehensivePositionResponse)) {
            getComprehensivePositionResponse* response = (getComprehensivePositionResponse*)buffer;
            return *response;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    getComprehensivePositionResponse defaultResponse = {0};
    return defaultResponse;
}

getComprehensivePositionResponse Servomotor::getComprehensivePositionRaw(uint64_t uniqueId) {
    Serial.println("[Motor] getComprehensivePositionRaw called (by unique ID).");
    // Get the desired motor position, hall sensor position, and external encoder position all in one shot (Raw version)
    const uint8_t commandID = GET_COMPREHENSIVE_POSITION;
    _comm.sendCommandByUniqueId(uniqueId, commandID, nullptr, 0);
    uint8_t buffer[sizeof(getComprehensivePositionResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(getComprehensivePositionResponse)) {
            getComprehensivePositionResponse* response = (getComprehensivePositionResponse*)buffer;
            return *response;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    getComprehensivePositionResponse defaultResponse = {0};
    return defaultResponse;
}

getComprehensivePositionResponseConverted Servomotor::getComprehensivePosition() {
    Serial.println("[Motor] getComprehensivePosition called.");
    auto rawResult = getComprehensivePositionRaw();
    getComprehensivePositionResponseConverted converted;
    converted.commandedPosition = ::convertPosition((float)rawResult.commandedPosition, m_positionUnit, ConversionDirection::FROM_INTERNAL);
    converted.hallSensorPosition = ::convertPosition((float)rawResult.hallSensorPosition, m_positionUnit, ConversionDirection::FROM_INTERNAL);
    converted.externalEncoderPosition = ::convertPosition((float)rawResult.externalEncoderPosition, m_positionUnit, ConversionDirection::FROM_INTERNAL);
    return converted;
}

getComprehensivePositionResponseConverted Servomotor::getComprehensivePosition(uint64_t uniqueId) {
    Serial.println("[Motor] getComprehensivePosition called (by unique ID).");
    auto rawResult = getComprehensivePositionRaw(uniqueId);
    getComprehensivePositionResponseConverted converted;
    converted.commandedPosition = ::convertPosition((float)rawResult.commandedPosition, m_positionUnit, ConversionDirection::FROM_INTERNAL);
    converted.hallSensorPosition = ::convertPosition((float)rawResult.hallSensorPosition, m_positionUnit, ConversionDirection::FROM_INTERNAL);
    converted.externalEncoderPosition = ::convertPosition((float)rawResult.externalEncoderPosition, m_positionUnit, ConversionDirection::FROM_INTERNAL);
    return converted;
}

uint16_t Servomotor::getSupplyVoltageRaw() {
    Serial.println("[Motor] getSupplyVoltageRaw called.");
    // Get the measured voltage of the power supply. (Raw version)
    const uint8_t commandID = GET_SUPPLY_VOLTAGE;
    sendCommand(commandID, nullptr, 0);
    uint8_t buffer[sizeof(getSupplyVoltageResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(getSupplyVoltageResponse)) {
            getSupplyVoltageResponse* response = (getSupplyVoltageResponse*)buffer;
            return response->supplyVoltage;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    getSupplyVoltageResponse defaultResponse = {0};
    return defaultResponse.supplyVoltage;
}

uint16_t Servomotor::getSupplyVoltageRaw(uint64_t uniqueId) {
    Serial.println("[Motor] getSupplyVoltageRaw called (by unique ID).");
    // Get the measured voltage of the power supply. (Raw version)
    const uint8_t commandID = GET_SUPPLY_VOLTAGE;
    _comm.sendCommandByUniqueId(uniqueId, commandID, nullptr, 0);
    uint8_t buffer[sizeof(getSupplyVoltageResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(getSupplyVoltageResponse)) {
            getSupplyVoltageResponse* response = (getSupplyVoltageResponse*)buffer;
            return response->supplyVoltage;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    getSupplyVoltageResponse defaultResponse = {0};
    return defaultResponse.supplyVoltage;
}

float Servomotor::getSupplyVoltage() {
    Serial.println("[Motor] getSupplyVoltage called.");
    auto rawResult = getSupplyVoltageRaw();
    float converted = ::convertVoltage((float)rawResult, m_voltageUnit, ConversionDirection::FROM_INTERNAL);
    return converted;
}

float Servomotor::getSupplyVoltage(uint64_t uniqueId) {
    Serial.println("[Motor] getSupplyVoltage called (by unique ID).");
    auto rawResult = getSupplyVoltageRaw(uniqueId);
    float converted = ::convertVoltage((float)rawResult, m_voltageUnit, ConversionDirection::FROM_INTERNAL);
    return converted;
}

getMaxPidErrorResponse Servomotor::getMaxPidErrorRaw() {
    Serial.println("[Motor] getMaxPidErrorRaw called.");
    // Get the minimum and maximum error value ovserved in the PID control loop since the last read. (Raw version)
    const uint8_t commandID = GET_MAX_PID_ERROR;
    sendCommand(commandID, nullptr, 0);
    uint8_t buffer[sizeof(getMaxPidErrorResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(getMaxPidErrorResponse)) {
            getMaxPidErrorResponse* response = (getMaxPidErrorResponse*)buffer;
            return *response;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    getMaxPidErrorResponse defaultResponse = {0};
    return defaultResponse;
}

getMaxPidErrorResponse Servomotor::getMaxPidErrorRaw(uint64_t uniqueId) {
    Serial.println("[Motor] getMaxPidErrorRaw called (by unique ID).");
    // Get the minimum and maximum error value ovserved in the PID control loop since the last read. (Raw version)
    const uint8_t commandID = GET_MAX_PID_ERROR;
    _comm.sendCommandByUniqueId(uniqueId, commandID, nullptr, 0);
    uint8_t buffer[sizeof(getMaxPidErrorResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(getMaxPidErrorResponse)) {
            getMaxPidErrorResponse* response = (getMaxPidErrorResponse*)buffer;
            return *response;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    getMaxPidErrorResponse defaultResponse = {0};
    return defaultResponse;
}

getMaxPidErrorResponseConverted Servomotor::getMaxPidError() {
    Serial.println("[Motor] getMaxPidError called.");
    auto rawResult = getMaxPidErrorRaw();
    getMaxPidErrorResponseConverted converted;
    converted.minPidError = ::convertPosition((float)rawResult.minPidError, m_positionUnit, ConversionDirection::FROM_INTERNAL);
    converted.maxPidError = ::convertPosition((float)rawResult.maxPidError, m_positionUnit, ConversionDirection::FROM_INTERNAL);
    return converted;
}

getMaxPidErrorResponseConverted Servomotor::getMaxPidError(uint64_t uniqueId) {
    Serial.println("[Motor] getMaxPidError called (by unique ID).");
    auto rawResult = getMaxPidErrorRaw(uniqueId);
    getMaxPidErrorResponseConverted converted;
    converted.minPidError = ::convertPosition((float)rawResult.minPidError, m_positionUnit, ConversionDirection::FROM_INTERNAL);
    converted.maxPidError = ::convertPosition((float)rawResult.maxPidError, m_positionUnit, ConversionDirection::FROM_INTERNAL);
    return converted;
}

void Servomotor::vibrate(uint8_t vibrationLevel) {
    Serial.println("[Motor] vibrate called.");
    // Cause the motor to start to vary the voltage quickly and therefore to vibrate (or stop).
    const uint8_t commandID = VIBRATE;
    vibratePayload payload;
    payload.vibrationLevel = vibrationLevel;
    sendCommand(commandID, (uint8_t*)&payload, sizeof(payload));
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::vibrate(uint64_t uniqueId, uint8_t vibrationLevel) {
    Serial.println("[Motor] vibrate called (by unique ID).");
    // Cause the motor to start to vary the voltage quickly and therefore to vibrate (or stop).
    const uint8_t commandID = VIBRATE;
    vibratePayload payload;
    payload.vibrationLevel = vibrationLevel;
    _comm.sendCommandByUniqueId(uniqueId, commandID, (uint8_t*)&payload, sizeof(payload));
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::identify() {
    Serial.println("[Motor] identify called.");
    // Identify your motor by sending this command. The motor's green LED will flash rapidly for 3 seconds.
    const uint8_t commandID = IDENTIFY;
    sendCommand(commandID, nullptr, 0);
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::identify(uint64_t uniqueId) {
    Serial.println("[Motor] identify called (by unique ID).");
    // Identify your motor by sending this command. The motor's green LED will flash rapidly for 3 seconds.
    const uint8_t commandID = IDENTIFY;
    _comm.sendCommandByUniqueId(uniqueId, commandID, nullptr, 0);
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

int16_t Servomotor::getTemperatureRaw() {
    Serial.println("[Motor] getTemperatureRaw called.");
    // Get the measured temperature of the motor. (Raw version)
    const uint8_t commandID = GET_TEMPERATURE;
    sendCommand(commandID, nullptr, 0);
    uint8_t buffer[sizeof(getTemperatureResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(getTemperatureResponse)) {
            getTemperatureResponse* response = (getTemperatureResponse*)buffer;
            return response->temperature;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    getTemperatureResponse defaultResponse = {0};
    return defaultResponse.temperature;
}

int16_t Servomotor::getTemperatureRaw(uint64_t uniqueId) {
    Serial.println("[Motor] getTemperatureRaw called (by unique ID).");
    // Get the measured temperature of the motor. (Raw version)
    const uint8_t commandID = GET_TEMPERATURE;
    _comm.sendCommandByUniqueId(uniqueId, commandID, nullptr, 0);
    uint8_t buffer[sizeof(getTemperatureResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(getTemperatureResponse)) {
            getTemperatureResponse* response = (getTemperatureResponse*)buffer;
            return response->temperature;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    getTemperatureResponse defaultResponse = {0};
    return defaultResponse.temperature;
}

float Servomotor::getTemperature() {
    Serial.println("[Motor] getTemperature called.");
    auto rawResult = getTemperatureRaw();
    float converted = ::convertTemperature((float)rawResult, m_temperatureUnit, ConversionDirection::FROM_INTERNAL);
    return converted;
}

float Servomotor::getTemperature(uint64_t uniqueId) {
    Serial.println("[Motor] getTemperature called (by unique ID).");
    auto rawResult = getTemperatureRaw(uniqueId);
    float converted = ::convertTemperature((float)rawResult, m_temperatureUnit, ConversionDirection::FROM_INTERNAL);
    return converted;
}

void Servomotor::setPidConstants(uint32_t kP, uint32_t kI, uint32_t kD) {
    Serial.println("[Motor] setPidConstants called.");
    // Set PID constants for the control loop that will try to maintain the motion trajectory.
    const uint8_t commandID = SET_PID_CONSTANTS;
    setPidConstantsPayload payload;
    payload.kP = htole32(kP);
    payload.kI = htole32(kI);
    payload.kD = htole32(kD);
    sendCommand(commandID, (uint8_t*)&payload, sizeof(payload));
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::setPidConstants(uint64_t uniqueId, uint32_t kP, uint32_t kI, uint32_t kD) {
    Serial.println("[Motor] setPidConstants called (by unique ID).");
    // Set PID constants for the control loop that will try to maintain the motion trajectory.
    const uint8_t commandID = SET_PID_CONSTANTS;
    setPidConstantsPayload payload;
    payload.kP = htole32(kP);
    payload.kI = htole32(kI);
    payload.kD = htole32(kD);
    _comm.sendCommandByUniqueId(uniqueId, commandID, (uint8_t*)&payload, sizeof(payload));
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::setMaxAllowablePositionDeviationRaw(int64_t maxAllowablePositionDeviation) {
    Serial.println("[Motor] setMaxAllowablePositionDeviationRaw called.");
    // Set the amount of microsteps that the actual motor position (as measured by the hall sensors) is allowed to deviate from the desired position. Throw a fatal error if this is exceeded. (Raw version)
    const uint8_t commandID = SET_MAX_ALLOWABLE_POSITION_DEVIATION;
    setMaxAllowablePositionDeviationPayload payload;
    payload.maxAllowablePositionDeviation = htole64(maxAllowablePositionDeviation);
    sendCommand(commandID, (uint8_t*)&payload, sizeof(payload));
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::setMaxAllowablePositionDeviationRaw(uint64_t uniqueId, int64_t maxAllowablePositionDeviation) {
    Serial.println("[Motor] setMaxAllowablePositionDeviationRaw called (by unique ID).");
    // Set the amount of microsteps that the actual motor position (as measured by the hall sensors) is allowed to deviate from the desired position. Throw a fatal error if this is exceeded. (Raw version)
    const uint8_t commandID = SET_MAX_ALLOWABLE_POSITION_DEVIATION;
    setMaxAllowablePositionDeviationPayload payload;
    payload.maxAllowablePositionDeviation = htole64(maxAllowablePositionDeviation);
    _comm.sendCommandByUniqueId(uniqueId, commandID, (uint8_t*)&payload, sizeof(payload));
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::setMaxAllowablePositionDeviation(float maxAllowablePositionDeviation) {
    Serial.println("[Motor] setMaxAllowablePositionDeviation called.");
    Serial.print("  maxAllowablePositionDeviation in chosen unit: "); Serial.println(maxAllowablePositionDeviation);
    float maxAllowablePositionDeviation_internal = ::convertPosition(maxAllowablePositionDeviation, m_positionUnit, ConversionDirection::TO_INTERNAL);
    setMaxAllowablePositionDeviationRaw((int64_t)(maxAllowablePositionDeviation_internal));
}

void Servomotor::setMaxAllowablePositionDeviation(uint64_t uniqueId, float maxAllowablePositionDeviation) {
    Serial.println("[Motor] setMaxAllowablePositionDeviation called (by unique ID).");
    Serial.print("  maxAllowablePositionDeviation in chosen unit: "); Serial.println(maxAllowablePositionDeviation);
    float maxAllowablePositionDeviation_internal = ::convertPosition(maxAllowablePositionDeviation, m_positionUnit, ConversionDirection::TO_INTERNAL);
    setMaxAllowablePositionDeviationRaw(uniqueId, (int64_t)(maxAllowablePositionDeviation_internal));
}

getDebugValuesResponse Servomotor::getDebugValues() {
    Serial.println("[Motor] getDebugValues called.");
    // Get debug values including motor control parameters, profiler times, hall sensor data, and other diagnostic information.
    const uint8_t commandID = GET_DEBUG_VALUES;
    sendCommand(commandID, nullptr, 0);
    uint8_t buffer[sizeof(getDebugValuesResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(getDebugValuesResponse)) {
            getDebugValuesResponse* response = (getDebugValuesResponse*)buffer;
            return *response;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    getDebugValuesResponse defaultResponse = {0};
    return defaultResponse;
}

getDebugValuesResponse Servomotor::getDebugValues(uint64_t uniqueId) {
    Serial.println("[Motor] getDebugValues called (by unique ID).");
    // Get debug values including motor control parameters, profiler times, hall sensor data, and other diagnostic information.
    const uint8_t commandID = GET_DEBUG_VALUES;
    _comm.sendCommandByUniqueId(uniqueId, commandID, nullptr, 0);
    uint8_t buffer[sizeof(getDebugValuesResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(getDebugValuesResponse)) {
            getDebugValuesResponse* response = (getDebugValuesResponse*)buffer;
            return *response;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    getDebugValuesResponse defaultResponse = {0};
    return defaultResponse;
}

void Servomotor::crc32Control(uint8_t enableCrc32) {
    Serial.println("[Motor] crc32Control called.");
    // Enable or disable CRC32 checking for commands
    const uint8_t commandID = CRC32_CONTROL;
    crc32ControlPayload payload;
    payload.enableCrc32 = enableCrc32;
    sendCommand(commandID, (uint8_t*)&payload, sizeof(payload));
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

void Servomotor::crc32Control(uint64_t uniqueId, uint8_t enableCrc32) {
    Serial.println("[Motor] crc32Control called (by unique ID).");
    // Enable or disable CRC32 checking for commands
    const uint8_t commandID = CRC32_CONTROL;
    crc32ControlPayload payload;
    payload.enableCrc32 = enableCrc32;
    _comm.sendCommandByUniqueId(uniqueId, commandID, (uint8_t*)&payload, sizeof(payload));
    uint16_t receivedSize;
    _errno = _comm.getResponse(nullptr, 0, receivedSize);
}

getCommunicationStatisticsResponse Servomotor::getCommunicationStatistics(uint8_t resetCounter) {
    Serial.println("[Motor] getCommunicationStatistics called.");
    // Get and optionally reset the CRC32 error counter
    const uint8_t commandID = GET_COMMUNICATION_STATISTICS;
    getCommunicationStatisticsPayload payload;
    payload.resetCounter = resetCounter;
    sendCommand(commandID, (uint8_t*)&payload, sizeof(payload));
    uint8_t buffer[sizeof(getCommunicationStatisticsResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(getCommunicationStatisticsResponse)) {
            getCommunicationStatisticsResponse* response = (getCommunicationStatisticsResponse*)buffer;
            return *response;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    getCommunicationStatisticsResponse defaultResponse = {0};
    return defaultResponse;
}

getCommunicationStatisticsResponse Servomotor::getCommunicationStatistics(uint64_t uniqueId, uint8_t resetCounter) {
    Serial.println("[Motor] getCommunicationStatistics called (by unique ID).");
    // Get and optionally reset the CRC32 error counter
    const uint8_t commandID = GET_COMMUNICATION_STATISTICS;
    getCommunicationStatisticsPayload payload;
    payload.resetCounter = resetCounter;
    _comm.sendCommandByUniqueId(uniqueId, commandID, (uint8_t*)&payload, sizeof(payload));
    uint8_t buffer[sizeof(getCommunicationStatisticsResponse)];
    uint16_t receivedSize;
    _errno = _comm.getResponse(buffer, sizeof(buffer), receivedSize);
    if (_errno == 0) {
        if (receivedSize == sizeof(getCommunicationStatisticsResponse)) {
            getCommunicationStatisticsResponse* response = (getCommunicationStatisticsResponse*)buffer;
            return *response;
        } else {
            _errno = COMMUNICATION_ERROR_DATA_WRONG_SIZE;
        }
    }
    getCommunicationStatisticsResponse defaultResponse = {0};
    return defaultResponse;
}
