/****************************************************************************
 * Very first version, 100% generated by ChatGPT, untested
 *
 * Evaluation : not very logical choice of Posit usage, but still impressive
 * - 1323 bytes of memory is going to be difficult on UNO, from a 2048 total
 * - makes use of intermediate float for epsilon greedy decision
 * - makes use of many 16-bit ints and floats 
 * - modified by ChatGPT to adapt reward to the car's speed at the goal position
 ****************************************************************************/
#include "Posit.h"  // Include your Posit library

// Hyperparameters
Posit8 alpha = Posit8(0.1);  // Learning rate
Posit8 gamma = Posit8(0.9);  // Discount factor
Posit8 epsilon = Posit8(0.1); // Exploration rate

// State and action space
Posit8 Q_table[21][21][3];   // Q-values table for position, velocity, and actions
int actions[3] = {-1, 0, 1};  // Action values: reverse, neutral, forward

// Environment boundaries
Posit8 position_min = Posit8(-1.0);
Posit8 position_max = Posit8(1.0);
Posit8 velocity_min = Posit8(-0.07);
Posit8 velocity_max = Posit8(0.07);

// Initialize state variables
Posit8 position, velocity;

// Helper function to get a random action with epsilon-greedy
int getAction(Posit8 pos, Posit8 vel) {
    if (random(100) < (epsilon.to_float() * 100)) {
        return actions[random(3)];  // Explore
    }
    // Exploit: choose the action with max Q-value for given state
    int best_action = 0;
    Posit8 max_q = Q_table[(int)(pos.to_float() * 10 + 10)][(int)(vel.to_float() * 10 + 10)][0];
    for (int a = 1; a < 3; a++) {
        Posit8 q_value = Q_table[(int)(pos.to_float() * 10 + 10)][(int)(vel.to_float() * 10 + 10)][a];
        if (q_value > max_q) {
            max_q = q_value;
            best_action = a;
        }
    }
    return actions[best_action];
}

// Update state based on action
void updateState(int action) {
    velocity = velocity + Posit8(action) * Posit8(0.001) - Posit8(0.0025) * cos(Posit8(3.0) * position);
    if (velocity < velocity_min) velocity = velocity_min;
    if (velocity > velocity_max) velocity = velocity_max;

    position = position + velocity;
    if (position < position_min) position = position_min;
    if (position > position_max) position = position_max;
}

// Modified reward function based on speed at the goal
Posit8 getReward() {
    if (position >= position_max) {
        return Posit8(1.0) - abs(velocity);  // Reward inversely proportional to speed
    }
    return Posit8(0);  // No reward otherwise
}

// SARSA Q-table update function
void updateQTable(Posit8 pos, Posit8 vel, int action, Posit8 reward, Posit8 next_pos, Posit8 next_vel, int next_action) {
    int pos_index = (int)(pos.to_float() * 10 + 10);
    int vel_index = (int)(vel.to_float() * 10 + 10);
    int action_index = (action + 1);  // Convert -1, 0, 1 to 0, 1, 2

    Posit8 current_q = Q_table[pos_index][vel_index][action_index];
    Posit8 next_q = Q_table[(int)(next_pos.to_float() * 10 + 10)][(int)(next_vel.to_float() * 10 + 10)][next_action + 1];

    Q_table[pos_index][vel_index][action_index] += alpha * (reward + gamma * next_q - current_q);
}

// Run a single episode
void runEpisode() {
    // Initialize starting position and velocity
    position = Posit8(-0.5);
    velocity = Posit8(0);

    int action = getAction(position, velocity);

    while (position < position_max) {  // Run until reaching the goal position
        // Step environment and get reward
        updateState(action);
        Posit8 reward = getReward();

        // Select next action using SARSA
        int next_action = getAction(position, velocity);

        // Update Q-table
        updateQTable(position, velocity, action, reward, position, velocity, next_action);

        // Transition to next state
        action = next_action;
    }
}

void setup() {
    Serial.begin(9600);
    randomSeed(analogRead(0));  // Seed randomness
    memset(Q_table, 0, sizeof(Q_table));  // Initialize Q-table to zero
}

void loop() {
    runEpisode();
    delay(100);  // Delay between episodes for debugging
}

void loop() {
    runEpisode();
    delay(100);  // Delay between episodes for debugging
}
