![TDKInvensense](doc/pictures/TDKInvensense.jpg)

# TAD214x Arduino library
The TAD214x is an integrated angle sensor with TMR (Tunnel Magneto Resistance) technology. TMR senses the magnetic field which is applied parallelly to the TMR surface. 
It has a configurable host interface that supports Encoder, I2C and SPI serial communication
# Software setup
Use Arduino Library manager to find and install the TAD214x library.

# Hardware setup
There is currently no Arduino shield for the TAD214x.
The wiring must be done manually between the Arduino motherboard and the TAD214x eval board.
The below wiring description is given for an Arduino Zero board, it depends on the interface to be used:
* I2C

|Arduino Zero|TAD214x eval board|
| --- | --- |
| 3.3V       | CN1.1          |
| 5V         | CN1.19         |
| GND        | CN1.11         |
| SDA        | CN1.18         |
| SCL        | CN1.20         |
| GND        | CN1.16         |
| GND        | CN1.4          |

CN1.16 and CN1.4 can be used to define respectively AD0 and AD1 of the TAD214x I2C address (wired to GND by default).

* SPI

|Arduino Zero|TAD214x eval board|
| --- | --- |
| 3.3V       | CN1.1          |
| 5V         | CN1.19         |
| GND        | CN1.11         |
| MISO=SPI.1 | CN1.20         |
| MOSI=SPI.4 | CN1.18         |
| SCK=SPI.3  | CN1.16         |
| CS=DIG.8   | CN1.4          |

* ENCODER

|Arduino Zero|TAD214x eval board|
| --- | --- |
| 3.3V        | CN1.1          |
| 5V          | CN1.19         |
| GND         | CN1.11         |
| ENCA=DIG11  | CN1.18         |
| ENCB=DIG.12 | CN1.20         |
| ENCZ=DIG.13 | CN1.16         |
| 3.3V        | CN1.4          |

* Interrupt

|Arduino Zero|TAD214x eval board|
| --- | --- |
| DIG.2      | CN1.3          |

Note: Interrupt pin can be mapped on any free interruptible IO, updating the sketches accordingly.

# Library API

## Create TAD214x instance

**TAD214x(TwoWire &i2c,bool lsb)**

Create an instance of the TAD214x that will be accessed using the specified I2C. The LSB of the I2C address can be set to 0 or 1.  
I2C default clock is 400kHz.

```C++
TAD214x TAD(Wire,0);
```

**TAD214x(TwoWire &i2c,bool lsb, uint32_t freq)**

Same as above, specifying the I2C clock frequency (must be between 100kHz and 1MHz)

```C++
TAD214x TAD(Wire,0,1000000);
```

**TAD214x(SPIClass &spi,uint8_t cs_id)**

Create an instance of the TAD214x that will be accessed using the specified SPI. The IO number to be used as chip select must be specified.  
SPI default clock is 10MHz.

```C++
TAD214x TAD(SPI,8);
```

**TAD214x(SPIClass &spi,uint8_t cs_id, uint32_t freq)**

Same as above, specifying the SPI clock frequency (must be between 1kHz and 10MHz)

```C++
TAD214x TAD(SPI,8,10000000);
```


**/!\ This library does NOT support multiple instances of TAD214x.**


## Initialize the TAD214x
Call the begin method to execute the TAD214x initialization routine. 

**int begin()**

Initializes all the required parameters to communicate and use the TAD214x.

```C++
TAD.begin();
```

## Log sensor data

**int getDataFromRegisters(float& angle, float& temp)**

This method reads the TAD214x angle and temperature raw data from registers.
Raw data can translate below.
angle = fmod((TMRData*360.0)/65536.0 + 180.0,360.0) - 180;
temp = 25.0 + TempData* 0.00625;

```C++
    float angle, temp;
    TAD.getDataFromRegisters(angle, temp);    
    Serial.print("Angle:");
    Serial.print(angle);
    Serial.print(",");
    Serial.print("Temperature:");
    Serial.print(temp);
    Serial.println("");
```

**int enableInterrupt(uint8_t intpin, TAD214x_irq_handler handler)**

This method is for register the interrupt of the TAD214x. The interrupt is triggered when a read to the data register is detected on SPI/I2C and the provided handler is called.
Any interruptible pin of the Arduino can be used for intpin.

```C++
uint8_t irq_received = 0;

void irq_handler(void)
{
  irq_received = 1;
}
```

## Available Sketches

**TMR_LOW_POWER_MODE_I2C**

This sketch initializes the TAD214x with the I2C interface, and starts logging raw sensor data from TAD registers when interrupt is triggered. Sensor data can be monitored on Serial monitor or Serial plotter

**TMR_SINGLE_SHOT_MODE_I2C**

This sketch initializes the TAD214x with the I2C interface, and single-shot measurement mode, the ASIC transitions back to STANDBY. Sensor data can be monitored on Serial monitor or Serial plotter

**TMR_LOW_POWER_MODE_SPI**

This sketch initializes the TAD214x with the SPI interface, and starts logging raw sensor data from TAD registers when interrupt is triggered. Sensor data can be monitored on Serial monitor or Serial plotter

**TMR_ENCODER**

This sketch initializes the TAD214x with the ENCODER interface, and starts logging sensor data from ABZ rotary encoder protocol. Sensor data can be monitored on Serial monitor or Serial plotter

![ABZ rotary encoder](doc/pictures/rotary.jpg)

# TAD data monitoring

When the TAD214x TAD is logging, the Angle and Temperature data can be monitored with the Arduino Serial Plotter (Tools->Serial Plotter).

![Serial Plotter](doc/pictures/SerialPlotter.jpg)

