/*
 *
 * Copyright (c) [2020] by InvenSense, Inc.
 * 
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */
 
#ifndef TAD214X_H
#define TAD214X_H

#include "Arduino.h"
#include "SPI.h"
#include "Wire.h"

extern "C" {
#include "tad2144/tad214x.h"
}

typedef void (*TAD214x_irq_handler)(void);

class TAD214x {
  public:
    TAD214x(TwoWire &i2c,bool address_lsb, uint32_t freq);
    TAD214x(TwoWire &i2c,bool address_lsb);
    TAD214x(SPIClass &spi,uint8_t chip_select_id, uint32_t freq);
    TAD214x(SPIClass &spi,uint8_t chip_select_id);
    TAD214x(void);    
    int begin();
    int setup_irq(uint8_t intpin, TAD214x_irq_handler handler);

    int getODR(void);
    int getMode(void);
    int write_reg(uint8_t addr, int *value);
    int read_reg(uint8_t addr, int *value);
    int setODR(TAD214X_ODR_t odr);
    int setMode(TAD214X_PowerMode_t mode);
    int getDataFromEncoder(float& angle);    
    int getDataFromRegisters(float& angle, float& temp);
    int enableInterrupt(uint8_t intpin, TAD214x_irq_handler handler);

  protected:
    tad214x_t tad214x_driver;
};

#endif // TAD214X_H