/*
 *
 * Copyright (c) [2020] by InvenSense, Inc.
 * 
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */
 
#include "TAD214x.h"

TAD214x TAD;

unsigned long previousMillis = 0;
const long interval = 10; //ms

void setup() {
  int ret;
  Serial.begin(115200);
  while(!Serial) {}

  // Initializing the TAD2144
  ret = TAD.begin();
  if (ret != 0) {
    Serial.print("TAD2144 initialization failed: ");
    Serial.println(ret);
    while(1);
  }
}

void loop() {
  unsigned long currentMillis = millis(); // Get the current time

  // Check if the interval has passed
  if (currentMillis - previousMillis >= interval) {
    int ret = 0;
    previousMillis = currentMillis; // Save the current time for the next comparison

    float angle;
    ret = TAD.getDataFromEncoder(angle);

    if(ret != INV_ERROR_SUCCESS)
      Serial.println("Error when read data!");      
    
    // Format data for Serial Plotter
    Serial.print("Angle:");
    Serial.print(angle);
    Serial.println("");    
  }
}

