//
// InvenSense Firmware Header Generator v2.5 (Python 3.11.4)
//
// File generated at 2024-02-05 04:23:53.369848 by jenkins
// Script input parameters:
//   - Input file:                 shasta-presence.hex
//   - Output file:                icu_presence_fw.c
//   - Part number:                generic
//   - Program size:               6144
//   - DMEM start address:         0x1000
//   - PMEM start address:         0xe800
//   - Firmware name:              presence
//   - Firmware name (sanitized):  presence
//   - Firmware git version:       1.7.3
//   - Firmware git sha1:          bcffcc210b38ee31a2ec457458a705b36f892506
//
// Copyright (c) 2024, InvenSense. All rights reserved.
//

#include <stdint.h>
#include <invn/soniclib/details/icu.h>
#include "icu_presence.h"

const char * icu_presence_version = "presence_1.7.3";
const char * icu_presence_gitsha1 = "bcffcc210b38ee31a2ec457458a705b36f892506";

#define RAM_INIT_ADDRESS 4096
#define RAM_INIT_WRITE_SIZE  494

uint16_t get_icu_presence_fw_ram_init_addr(void) { return (uint16_t)RAM_INIT_ADDRESS;}
uint16_t get_icu_presence_fw_ram_init_size(void) { return (uint16_t)RAM_INIT_WRITE_SIZE;}

const unsigned char ram_icu_presence_init[RAM_INIT_WRITE_SIZE] = {
0x1E, 0x10, 0x0A, 0x10, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x02, 0x01, 0x07, 0x03, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
0x10, 0x09, 0x01, 0x00, 0xE0, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };

const unsigned char * get_ram_icu_presence_init_ptr(void) { return &ram_icu_presence_init[0];}

#define	ICU_PRESENCE_TEXT_SIZE	5480
#define	ICU_PRESENCE_VEC_SIZE	32

const uint16_t  icu_presence_text_size	= ICU_PRESENCE_TEXT_SIZE;
const uint16_t  icu_presence_vec_size	= ICU_PRESENCE_VEC_SIZE;

const unsigned char icu_presence_fw_text[ICU_PRESENCE_TEXT_SIZE] = {
0x31, 0x40, 0x00, 0x20, 0x3c, 0x40, 0x36, 0x16, 0x0d, 0x43, 0x3e, 0x40, 0x30, 0x09, 0xb0, 0x12, 
0x1a, 0xfd, 0x3c, 0x40, 0x08, 0x10, 0x3d, 0x40, 0x08, 0x10, 0x0d, 0x9c, 0x04, 0x24, 0x3e, 0x40, 
0xe6, 0x01, 0xb0, 0x12, 0x2c, 0xfd, 0x0c, 0x43, 0xb0, 0x12, 0x1c, 0xfb, 0x0a, 0x12, 0x09, 0x12, 
0x08, 0x12, 0x07, 0x12, 0x06, 0x12, 0x05, 0x12, 0x04, 0x12, 0x31, 0x80, 0x0e, 0x00, 0x81, 0x4d, 
0x0a, 0x00, 0x81, 0x4e, 0x0c, 0x00, 0x48, 0x4f, 0x1a, 0x41, 0x1e, 0x00, 0x91, 0x41, 0x20, 0x00, 
0x08, 0x00, 0x16, 0x41, 0x22, 0x00, 0x09, 0x4a, 0x09, 0x59, 0x09, 0x5c, 0x0a, 0x5a, 0x0a, 0x5a, 
0x39, 0x50, 0xfe, 0xff, 0x3a, 0x50, 0xfc, 0xff, 0x3a, 0x90, 0xfc, 0xff, 0x04, 0x20, 0x31, 0x50, 
0x0e, 0x00, 0x30, 0x40, 0x7c, 0xfc, 0x17, 0x41, 0x0a, 0x00, 0x07, 0x5a, 0xa1, 0x47, 0x00, 0x00, 
0x91, 0x47, 0x02, 0x00, 0x02, 0x00, 0x2e, 0x49, 0x0c, 0x4e, 0x3c, 0xb0, 0x00, 0x80, 0x0d, 0x7d, 
0x3d, 0xe3, 0x7e, 0x42, 0xb0, 0x12, 0x9c, 0xfc, 0x0e, 0x4c, 0x0f, 0x4d, 0x2e, 0x81, 0x1f, 0x71, 
0x02, 0x00, 0x81, 0x4e, 0x04, 0x00, 0x81, 0x4f, 0x06, 0x00, 0x0c, 0x4e, 0x0d, 0x4f, 0x0e, 0x48, 
0x3e, 0xb0, 0x00, 0x80, 0x0f, 0x7f, 0x3f, 0xe3, 0xb0, 0x12, 0xb2, 0xfc, 0x0e, 0x4c, 0x0f, 0x4d, 
0x2c, 0x41, 0x0c, 0x5e, 0x87, 0x4c, 0x00, 0x00, 0x1c, 0x41, 0x02, 0x00, 0x0c, 0x6d, 0x87, 0x4c, 
0x02, 0x00, 0x17, 0x41, 0x0c, 0x00, 0x07, 0x5a, 0x1c, 0x41, 0x04, 0x00, 0x1d, 0x41, 0x06, 0x00, 
0xb0, 0x12, 0xda, 0xfc, 0x7e, 0x42, 0xb0, 0x12, 0xb2, 0xfc, 0x04, 0x4c, 0x24, 0x57, 0x15, 0x47, 
0x02, 0x00, 0x05, 0x6d, 0x0c, 0x44, 0x0d, 0x45, 0x0e, 0x48, 0xb0, 0x12, 0xc0, 0xfc, 0x0e, 0x44, 
0x0f, 0x45, 0x0e, 0x8c, 0x0f, 0x7d, 0x0d, 0x4e, 0x0c, 0x4f, 0x06, 0x9f, 0x05, 0x28, 0x0f, 0x96, 
0x06, 0x20, 0x81, 0x9e, 0x08, 0x00, 0x03, 0x2c, 0x1d, 0x41, 0x08, 0x00, 0x0c, 0x46, 0x87, 0x4d, 
0x00, 0x00, 0x87, 0x4c, 0x02, 0x00, 0x9c, 0x3f, 0x3c, 0x40, 0xa0, 0x01, 0x9c, 0x42, 0x64, 0x1f, 
0x06, 0x00, 0x92, 0x43, 0x62, 0x1f, 0x9c, 0x43, 0x08, 0x00, 0x92, 0xd3, 0x60, 0x1f, 0x30, 0x41, 
0xa2, 0xb3, 0x94, 0x01, 0xfd, 0x27, 0x30, 0x41, 0x1c, 0x83, 0xfe, 0x23, 0x30, 0x41, 0x0a, 0x12, 
0x82, 0xdc, 0x22, 0x10, 0x1a, 0x42, 0x1c, 0x10, 0xda, 0x43, 0x03, 0x00, 0xc2, 0x93, 0x5f, 0x1f, 
0x0d, 0x24, 0xc2, 0x93, 0x5e, 0x1f, 0x06, 0x24, 0xda, 0x43, 0x02, 0x00, 0x7c, 0x40, 0x10, 0x00, 
0xb0, 0x12, 0x48, 0xe9, 0xca, 0x43, 0x03, 0x00, 0xca, 0x43, 0x02, 0x00, 0x3a, 0x41, 0x30, 0x41, 
0x5e, 0x42, 0x34, 0x10, 0x4d, 0x43, 0x0e, 0xbc, 0x06, 0x24, 0x92, 0xb3, 0x22, 0x10, 0x05, 0x20, 
0x5d, 0x43, 0x1d, 0xc2, 0x60, 0x1f, 0x0c, 0x4d, 0x30, 0x41, 0x4d, 0x43, 0xfc, 0x3f, 0x0a, 0x12, 
0x09, 0x12, 0x5a, 0x42, 0x33, 0x10, 0x0c, 0x4a, 0x7d, 0x40, 0x84, 0x00, 0xb0, 0x12, 0xc6, 0xfc, 
0x5c, 0x4c, 0xb8, 0x10, 0x7c, 0xf0, 0x07, 0x00, 0xc2, 0x4c, 0x46, 0x16, 0x0c, 0x4a, 0x7d, 0x40, 
0x84, 0x00, 0xb0, 0x12, 0xc6, 0xfc, 0x5c, 0x4c, 0xb8, 0x10, 0x19, 0x42, 0xa0, 0x01, 0x7c, 0xf0, 
0x07, 0x00, 0x7d, 0x42, 0xb0, 0x12, 0x90, 0xfc, 0x39, 0xf0, 0xff, 0xf8, 0x0c, 0xd9, 0x82, 0x4c, 
0xa0, 0x01, 0x0c, 0x4a, 0x7d, 0x40, 0x84, 0x00, 0xb0, 0x12, 0xc6, 0xfc, 0x3c, 0x50, 0x36, 0x10, 
0x82, 0x4c, 0x64, 0x1f, 0x1c, 0x42, 0x20, 0x01, 0x7c, 0xf0, 0x80, 0x00, 0x3c, 0xd0, 0x18, 0x5a, 
0x82, 0x4c, 0x20, 0x01, 0xf2, 0xb2, 0x34, 0x10, 0x0c, 0x24, 0xb2, 0x40, 0xfe, 0x13, 0xaa, 0x01, 
0xb2, 0x40, 0xee, 0x11, 0xae, 0x01, 0xa2, 0x43, 0xa8, 0x01, 0x82, 0x43, 0xa8, 0x01, 0x30, 0x40, 
0x86, 0xfc, 0xb2, 0x40, 0xee, 0x11, 0xaa, 0x01, 0xf3, 0x3f, 0x00, 0x13, 0x00, 0x13, 0x00, 0x13, 
0x00, 0x13, 0x00, 0x13, 0x00, 0x13, 0x0f, 0x12, 0x0e, 0x12, 0x0d, 0x12, 0x0c, 0x12, 0x0b, 0x12, 
0x3c, 0x40, 0x00, 0x04, 0xb0, 0x12, 0x4e, 0xe9, 0xb1, 0xc0, 0xf0, 0x00, 0x0a, 0x00, 0x3b, 0x41, 
0x3c, 0x41, 0x3d, 0x41, 0x3e, 0x41, 0x3f, 0x41, 0x00, 0x13, 0x0f, 0x12, 0x0e, 0x12, 0x0d, 0x12, 
0x0c, 0x12, 0x0b, 0x12, 0x6c, 0x43, 0xb0, 0x12, 0x80, 0xe9, 0x0c, 0x93, 0x02, 0x24, 0xb0, 0x12, 
0x28, 0xe9, 0xb1, 0xc0, 0xf0, 0x00, 0x0a, 0x00, 0x3b, 0x41, 0x3c, 0x41, 0x3d, 0x41, 0x3e, 0x41, 
0x3f, 0x41, 0x00, 0x13, 0x0f, 0x12, 0x0e, 0x12, 0x0d, 0x12, 0x0c, 0x12, 0x0b, 0x12, 0x5c, 0x43, 
0xb0, 0x12, 0x80, 0xe9, 0x0c, 0x93, 0x02, 0x24, 0xb0, 0x12, 0x28, 0xe9, 0xb1, 0xc0, 0xf0, 0x00, 
0x0a, 0x00, 0x3b, 0x41, 0x3c, 0x41, 0x3d, 0x41, 0x3e, 0x41, 0x3f, 0x41, 0x00, 0x13, 0x0d, 0x12, 
0x0c, 0x12, 0x3d, 0x40, 0xd8, 0x01, 0x3c, 0x40, 0x1e, 0x10, 0x9c, 0x4d, 0x02, 0x00, 0xc2, 0x01, 
0xed, 0x43, 0x00, 0x00, 0xbc, 0xd0, 0x20, 0x00, 0x04, 0x00, 0xb1, 0xc0, 0xf0, 0x00, 0x04, 0x00, 
0x3c, 0x41, 0x3d, 0x41, 0x00, 0x13, 0x0f, 0x12, 0x0e, 0x12, 0x0d, 0x12, 0x0c, 0x12, 0x0b, 0x12, 
0xb2, 0xf0, 0xfd, 0xfe, 0x60, 0x1f, 0xf2, 0xd2, 0x58, 0x00, 0x92, 0xb3, 0xd4, 0x01, 0xfd, 0x27, 
0x1c, 0x42, 0x5c, 0x1f, 0x0c, 0x93, 0x14, 0x24, 0x82, 0x43, 0x5c, 0x1f, 0x92, 0x42, 0xd2, 0x01, 
0xe4, 0x11, 0x92, 0xb3, 0x60, 0x1f, 0x03, 0x20, 0x6c, 0x42, 0xb0, 0x12, 0x4e, 0xe9, 0xb1, 0xc0, 
0xf0, 0x00, 0x0a, 0x00, 0x3b, 0x41, 0x3c, 0x41, 0x3d, 0x41, 0x3e, 0x41, 0x3f, 0x41, 0x00, 0x13, 
0x92, 0x42, 0xd2, 0x01, 0xe2, 0x11, 0x92, 0xb3, 0x60, 0x1f, 0xf1, 0x23, 0x5c, 0x42, 0x2f, 0x10, 
0x8c, 0x11, 0x0c, 0x93, 0x0d, 0x24, 0x5c, 0x42, 0x2f, 0x10, 0x8c, 0x11, 0x1d, 0x42, 0xf0, 0x01, 
0x0c, 0x5d, 0x3c, 0xf0, 0xff, 0x01, 0x3d, 0xf0, 0x00, 0xfe, 0x0c, 0xdd, 0x82, 0x4c, 0xf0, 0x01, 
0x6c, 0x43, 0xdb, 0x3f, 0x0f, 0x12, 0x0e, 0x12, 0x0d, 0x12, 0x0c, 0x12, 0x0b, 0x12, 0x0a, 0x12, 
0x1a, 0x42, 0x1c, 0x10, 0xc2, 0x93, 0x5e, 0x1f, 0x06, 0x24, 0xda, 0x43, 0x02, 0x00, 0x7c, 0x40, 
0x10, 0x00, 0xb0, 0x12, 0x48, 0xe9, 0xca, 0x43, 0x03, 0x00, 0xca, 0x43, 0x02, 0x00, 0x7c, 0x40, 
0x4c, 0x00, 0xb0, 0x12, 0x48, 0xe9, 0xea, 0xd2, 0x00, 0x00, 0x1c, 0x42, 0x26, 0x10, 0x0c, 0x93, 
0x0f, 0x20, 0xb2, 0xb2, 0x04, 0x02, 0x02, 0x24, 0x82, 0x43, 0x22, 0x10, 0xb1, 0xc0, 0xf0, 0x00, 
0x0c, 0x00, 0x3a, 0x41, 0x3b, 0x41, 0x3c, 0x41, 0x3d, 0x41, 0x3e, 0x41, 0x3f, 0x41, 0x00, 0x13, 
0x92, 0xb3, 0x26, 0x10, 0x05, 0x24, 0x92, 0xc3, 0x26, 0x10, 0xb0, 0x12, 0x28, 0xe9, 0xe5, 0x3f, 
0xb2, 0xb0, 0x00, 0x02, 0x26, 0x10, 0x06, 0x24, 0xb2, 0xf0, 0xff, 0xfd, 0x26, 0x10, 0xb0, 0x12, 
0x9e, 0xe9, 0xdb, 0x3f, 0xb2, 0xb0, 0x00, 0x08, 0x26, 0x10, 0x5a, 0x24, 0xb2, 0xf0, 0xff, 0xf7, 
0x26, 0x10, 0xd2, 0xb3, 0x30, 0x10, 0x4c, 0x20, 0x3c, 0x40, 0xe0, 0x01, 0x82, 0x4c, 0x1c, 0x10, 
0x5c, 0x42, 0x30, 0x10, 0x12, 0xc3, 0x0c, 0x10, 0x12, 0xc3, 0x0c, 0x10, 0x5c, 0xf3, 0xc2, 0x4c, 
0x5f, 0x1f, 0x5c, 0x42, 0x30, 0x10, 0x12, 0xc3, 0x0c, 0x10, 0x12, 0xc3, 0x0c, 0x10, 0x12, 0xc3, 
0x0c, 0x10, 0x5c, 0xf3, 0xc2, 0x4c, 0x5e, 0x1f, 0xe2, 0xb2, 0x34, 0x10, 0x34, 0x24, 0x92, 0xb3, 
0x94, 0x01, 0xfd, 0x27, 0xb2, 0x40, 0x0a, 0x00, 0x90, 0x01, 0x3a, 0x40, 0x40, 0xe9, 0x8a, 0x12, 
0xb2, 0x40, 0x03, 0x00, 0x92, 0x01, 0x8a, 0x12, 0xb2, 0x40, 0x07, 0x00, 0x92, 0x01, 0xd2, 0xc3, 
0xe0, 0x01, 0xd2, 0xc3, 0xe4, 0x01, 0xe2, 0xd3, 0xe0, 0x01, 0xe2, 0xd3, 0xe4, 0x01, 0xd2, 0xb3, 
0x34, 0x10, 0x07, 0x24, 0xd2, 0xd3, 0xe0, 0x01, 0xc2, 0x93, 0x5e, 0x1f, 0x02, 0x24, 0xe2, 0xc3, 
0xe0, 0x01, 0xe2, 0xb3, 0x34, 0x10, 0x07, 0x24, 0xd2, 0xd3, 0xe4, 0x01, 0xc2, 0x93, 0x5e, 0x1f, 
0x02, 0x24, 0xe2, 0xc3, 0xe4, 0x01, 0x5c, 0x42, 0x34, 0x10, 0x0c, 0x93, 0x86, 0x27, 0xa7, 0x3f, 
0x3c, 0x40, 0xe4, 0x01, 0xb3, 0x3f, 0xb0, 0x12, 0x40, 0xe9, 0x82, 0x43, 0x92, 0x01, 0xd7, 0x3f, 
0xa2, 0xb3, 0x26, 0x10, 0x0f, 0x24, 0xa2, 0xc3, 0x26, 0x10, 0x1c, 0x42, 0x2c, 0x10, 0xf2, 0xd2, 
0x58, 0x00, 0xa2, 0xd3, 0x60, 0x1f, 0x3c, 0xf0, 0xff, 0x0f, 0x3c, 0xd0, 0x00, 0x10, 0x82, 0x4c, 
0xd0, 0x01, 0x6b, 0x3f, 0xa2, 0xb2, 0x26, 0x10, 0x14, 0x24, 0xa2, 0xc2, 0x26, 0x10, 0x1c, 0x42, 
0x2c, 0x10, 0xf2, 0xc2, 0x58, 0x00, 0xb2, 0xd0, 0x00, 0x01, 0x60, 0x1f, 0x92, 0x43, 0x5c, 0x1f, 
0x12, 0xc3, 0x0c, 0x10, 0x12, 0xc3, 0x0c, 0x10, 0x12, 0xc3, 0x0c, 0x10, 0x12, 0xc3, 0x0c, 0x10, 
0xe4, 0x3f, 0xb2, 0xb0, 0x20, 0x00, 0x26, 0x10, 0x08, 0x24, 0xb2, 0xf0, 0xdf, 0xff, 0x26, 0x10, 
0xc2, 0x43, 0xd9, 0x01, 0xd2, 0x43, 0xd8, 0x01, 0x48, 0x3f, 0xb2, 0xb0, 0x00, 0x10, 0x26, 0x10, 
0x2e, 0x24, 0xb2, 0xf0, 0xff, 0xef, 0x26, 0x10, 0x5c, 0x42, 0x29, 0x10, 0x7c, 0xd0, 0x40, 0x00, 
0xc2, 0x4c, 0xf3, 0x01, 0x92, 0x42, 0x2a, 0x10, 0xf0, 0x01, 0xd2, 0x42, 0x28, 0x10, 0xf2, 0x01, 
0x5c, 0x42, 0x2e, 0x10, 0x7c, 0xf0, 0xf0, 0xff, 0x7c, 0x90, 0x50, 0x00, 0x08, 0x20, 0xe2, 0xb2, 
0x2e, 0x10, 0x0e, 0x24, 0xb2, 0x40, 0x18, 0x5a, 0x20, 0x01, 0xd2, 0xd3, 0x00, 0x00, 0xd2, 0xb3, 
0x2e, 0x10, 0x0a, 0x24, 0xa2, 0xd2, 0x60, 0x1f, 0xf2, 0xf0, 0x0f, 0x00, 0x2e, 0x10, 0x1d, 0x3f, 
0xb2, 0x40, 0x80, 0x5a, 0x20, 0x01, 0xf3, 0x3f, 0xa2, 0xc2, 0x60, 0x1f, 0xf5, 0x3f, 0xb2, 0xb0, 
0x00, 0x20, 0x26, 0x10, 0x12, 0x27, 0xb2, 0xf0, 0xff, 0xdf, 0x26, 0x10, 0x3e, 0x40, 0x10, 0x09, 
0x4d, 0x43, 0x3c, 0x40, 0x4c, 0x16, 0xb0, 0x12, 0x1a, 0xfd, 0x7e, 0x40, 0x1c, 0x00, 0x3d, 0x40, 
0x1a, 0x16, 0x3c, 0x40, 0x60, 0x16, 0xb0, 0x12, 0x08, 0xfd, 0xd2, 0x93, 0x6f, 0x16, 0x36, 0x20, 
0xb2, 0x42, 0x4e, 0x16, 0xb2, 0x40, 0x3c, 0x00, 0x4c, 0x16, 0xe2, 0x42, 0x56, 0x16, 0xc2, 0x43, 
0x5e, 0x16, 0xf2, 0x40, 0x10, 0x00, 0x57, 0x16, 0xb2, 0x40, 0x96, 0x00, 0x50, 0x16, 0xe2, 0x42, 
0x54, 0x16, 0x82, 0x43, 0x52, 0x16, 0xf2, 0x40, 0x03, 0x00, 0x59, 0x16, 0xb2, 0x40, 0x04, 0x80, 
0x5a, 0x16, 0xb2, 0x40, 0x04, 0x64, 0x5c, 0x16, 0xc2, 0x43, 0x3a, 0x1f, 0x82, 0x43, 0x3c, 0x1f, 
0x3c, 0x40, 0x92, 0x18, 0x3d, 0x40, 0xa4, 0x1a, 0x8c, 0x43, 0x24, 0x04, 0x8c, 0x43, 0x00, 0x00, 
0x2c, 0x53, 0x0d, 0x9c, 0xf9, 0x23, 0x82, 0x43, 0x52, 0x1f, 0xc2, 0x43, 0x36, 0x1f, 0x82, 0x43, 
0x34, 0x1f, 0x82, 0x43, 0x2a, 0x1f, 0xc2, 0x43, 0x1a, 0x10, 0xc7, 0x3e, 0xb2, 0x40, 0x28, 0x00, 
0x4e, 0x16, 0xb2, 0x40, 0x64, 0x00, 0x4c, 0x16, 0xc2, 0x43, 0x56, 0x16, 0xf2, 0x40, 0x28, 0x00, 
0x5e, 0x16, 0xc7, 0x3f, 0x0f, 0x12, 0x0e, 0x12, 0x0d, 0x12, 0x0c, 0x12, 0x0b, 0x12, 0x92, 0xb3, 
0x60, 0x1f, 0x1a, 0x20, 0xb0, 0x12, 0x28, 0xe9, 0x5c, 0x42, 0x33, 0x10, 0x7d, 0x40, 0x84, 0x00, 
0xb0, 0x12, 0xc6, 0xfc, 0x1f, 0x4c, 0xb6, 0x10, 0x1c, 0x4c, 0xb6, 0x10, 0x3c, 0xf0, 0x00, 0xc0, 
0x3c, 0x90, 0x00, 0xc0, 0x12, 0x20, 0x3f, 0xf0, 0xff, 0x3f, 0x4c, 0x43, 0x0c, 0x5f, 0x92, 0xb3, 
0x94, 0x01, 0xfd, 0x27, 0x82, 0x4c, 0x90, 0x01, 0xb1, 0xc0, 0xf0, 0x00, 0x0a, 0x00, 0x3b, 0x41, 
0x3c, 0x41, 0x3d, 0x41, 0x3e, 0x41, 0x3f, 0x41, 0x00, 0x13, 0x1c, 0x42, 0x4a, 0x16, 0x0d, 0x4c, 
0x0c, 0x93, 0x20, 0x24, 0x1e, 0x42, 0x48, 0x16, 0x0d, 0x4e, 0x0e, 0x93, 0x1b, 0x24, 0x3e, 0x50, 
0xfd, 0x3f, 0x0e, 0x5e, 0x0e, 0x5e, 0x0c, 0x5e, 0x2e, 0x4c, 0x0e, 0x5e, 0x0e, 0x5e, 0x0e, 0x5e, 
0x7e, 0xf0, 0x38, 0x00, 0x1d, 0x4c, 0x02, 0x00, 0x7d, 0xf0, 0x07, 0x00, 0x0e, 0xdd, 0x0d, 0x4e, 
0x0d, 0x5d, 0x0d, 0x5d, 0x0d, 0x5d, 0x0e, 0x5e, 0x0e, 0x5e, 0x0e, 0x5e, 0x0e, 0x5e, 0x0d, 0x5e, 
0x3d, 0x50, 0x0c, 0xfd, 0x0c, 0x43, 0x0c, 0x8f, 0x0c, 0x11, 0x0c, 0x11, 0x0c, 0x9d, 0xc6, 0x37, 
0x0c, 0x4d, 0xc4, 0x3f, 0xb2, 0x40, 0x0f, 0x00, 0xa4, 0x01, 0xb1, 0xc0, 0xf0, 0x00, 0x00, 0x00, 
0x00, 0x13, 0x0f, 0x12, 0x0e, 0x12, 0x0d, 0x12, 0x0c, 0x12, 0x0b, 0x12, 0x0a, 0x12, 0x09, 0x12, 
0x08, 0x12, 0x07, 0x12, 0x06, 0x12, 0x05, 0x12, 0x04, 0x12, 0x31, 0x80, 0x50, 0x00, 0x92, 0xc3, 
0x60, 0x1f, 0xd2, 0x42, 0x46, 0x16, 0xe7, 0x11, 0xd2, 0x42, 0x33, 0x10, 0xe6, 0x11, 0x1c, 0x42, 
0xb0, 0x01, 0x3d, 0x40, 0xee, 0x11, 0x3d, 0xf0, 0xff, 0x0f, 0x0c, 0x8d, 0x82, 0x4c, 0xec, 0x11, 
0x1c, 0x42, 0xec, 0x11, 0x12, 0xc3, 0x0c, 0x10, 0x12, 0xc3, 0x0c, 0x10, 0x82, 0x4c, 0x44, 0x16, 
0x5c, 0x42, 0x33, 0x10, 0x81, 0x4c, 0x42, 0x00, 0x91, 0x42, 0x62, 0x1f, 0x3a, 0x00, 0x3c, 0x40, 
0x00, 0x80, 0x91, 0x93, 0x3a, 0x00, 0x45, 0x20, 0x54, 0x42, 0x1a, 0x10, 0x81, 0x44, 0x3e, 0x00, 
0xc2, 0x93, 0x1a, 0x10, 0x02, 0x24, 0x30, 0x40, 0xec, 0xfa, 0x1c, 0x42, 0x38, 0x16, 0x2c, 0x4c, 
0x12, 0xc3, 0x0c, 0x10, 0x12, 0xc3, 0x0c, 0x10, 0x82, 0x4c, 0x7c, 0x16, 0x65, 0x42, 0x05, 0x9c, 
0x44, 0x28, 0xd2, 0x43, 0x17, 0x16, 0xf2, 0x43, 0x18, 0x16, 0xc2, 0x43, 0xe8, 0x11, 0x5d, 0x42, 
0x31, 0x10, 0x5c, 0x42, 0x32, 0x10, 0x0d, 0x9c, 0x02, 0x20, 0x30, 0x40, 0xfa, 0xfa, 0xd2, 0xe3, 
0x33, 0x10, 0x1c, 0x42, 0xec, 0x11, 0x12, 0xc3, 0x0c, 0x10, 0x12, 0xc3, 0x0c, 0x10, 0x82, 0x4c, 
0x48, 0x16, 0xb0, 0x12, 0x9e, 0xe9, 0x1c, 0x41, 0x42, 0x00, 0x7d, 0x40, 0x84, 0x00, 0xb0, 0x12, 
0xc6, 0xfc, 0x5c, 0x4c, 0xb9, 0x10, 0x5c, 0xf3, 0x3c, 0xf0, 0xff, 0x00, 0x5d, 0x42, 0x17, 0x16, 
0x0d, 0x93, 0x03, 0x20, 0xe2, 0xb3, 0x30, 0x10, 0x06, 0x20, 0x0c, 0x93, 0x04, 0x20, 0x1c, 0x41, 
0x3a, 0x00, 0xb0, 0x12, 0x4e, 0xe9, 0xb1, 0xc0, 0xf0, 0x00, 0x68, 0x00, 0x31, 0x50, 0x50, 0x00, 
0x34, 0x41, 0x35, 0x41, 0x36, 0x41, 0x37, 0x41, 0x38, 0x41, 0x39, 0x41, 0x3a, 0x41, 0x3b, 0x41, 
0x3c, 0x41, 0x3d, 0x41, 0x3e, 0x41, 0x3f, 0x41, 0x00, 0x13, 0x91, 0x42, 0x7c, 0x16, 0x0c, 0x00, 
0x36, 0x40, 0x09, 0x01, 0x16, 0x91, 0x0c, 0x00, 0x03, 0x34, 0xb1, 0x40, 0x09, 0x01, 0x0c, 0x00, 
0x92, 0x41, 0x0c, 0x00, 0x7c, 0x16, 0x57, 0x42, 0x56, 0x16, 0x87, 0x11, 0x81, 0x47, 0x38, 0x00, 
0x1c, 0x41, 0x0c, 0x00, 0x0c, 0x87, 0x0c, 0x11, 0x81, 0x4c, 0x28, 0x00, 0x82, 0x4c, 0x7e, 0x16, 
0x58, 0x42, 0x57, 0x16, 0x88, 0x11, 0x81, 0x48, 0x36, 0x00, 0x1e, 0x41, 0x0c, 0x00, 0x5e, 0x82, 
0x57, 0x16, 0x4c, 0x4e, 0xc2, 0x4e, 0xc8, 0x1e, 0x5d, 0x42, 0x5d, 0x16, 0xc2, 0x9e, 0x5d, 0x16, 
0x04, 0x2c, 0x1c, 0x53, 0x0c, 0x11, 0xc2, 0x4c, 0xc8, 0x1e, 0x5c, 0x42, 0xc8, 0x1e, 0x5d, 0x92, 
0xc8, 0x1e, 0x04, 0x2c, 0x1c, 0x53, 0x0c, 0x11, 0xc2, 0x4c, 0xc8, 0x1e, 0x5b, 0x42, 0x3a, 0x1f, 
0x81, 0x4b, 0x3c, 0x00, 0xc2, 0x93, 0x3a, 0x1f, 0x02, 0x24, 0x30, 0x40, 0x04, 0xfb, 0x91, 0x43, 
0x10, 0x00, 0xb1, 0x40, 0x10, 0x00, 0x24, 0x00, 0x5c, 0x42, 0x70, 0x16, 0x0c, 0x5c, 0x0c, 0x5c, 
0x1c, 0x52, 0x36, 0x16, 0x81, 0x4c, 0x14, 0x00, 0xb1, 0x40, 0x4c, 0x16, 0x12, 0x00, 0x1c, 0x41, 
0x0c, 0x00, 0x0c, 0x5c, 0x3c, 0x50, 0x4c, 0x16, 0x81, 0x4c, 0x40, 0x00, 0x3a, 0x40, 0x4c, 0x16, 
0x14, 0x41, 0x14, 0x00, 0x18, 0x44, 0x02, 0x00, 0x2b, 0x44, 0x45, 0x43, 0x05, 0x9b, 0x02, 0x38, 
0x30, 0x40, 0x9a, 0xf8, 0x46, 0x43, 0x06, 0x88, 0x08, 0x46, 0x05, 0x4b, 0x05, 0x11, 0x08, 0x11, 
0x47, 0x43, 0x0c, 0x45, 0x0d, 0x47, 0xb0, 0x12, 0xa6, 0xfc, 0x09, 0x4c, 0x0c, 0x48, 0x0d, 0x47, 
0xb0, 0x12, 0xa6, 0xfc, 0x4b, 0x43, 0x0b, 0x98, 0x02, 0x38, 0x30, 0x40, 0xa4, 0xf8, 0x05, 0x5c, 
0x08, 0x89, 0x17, 0x53, 0x37, 0x90, 0x06, 0x00, 0xec, 0x23, 0x81, 0x93, 0x3c, 0x00, 0x06, 0x20, 
0x8a, 0x45, 0x58, 0x04, 0x0c, 0x45, 0x0c, 0x11, 0x8a, 0x4c, 0x34, 0x00, 0x1d, 0x4a, 0x34, 0x00, 
0x08, 0x4d, 0x38, 0xb0, 0x00, 0x80, 0x09, 0x79, 0x39, 0xe3, 0x1c, 0x41, 0x24, 0x00, 0x1c, 0x53, 
0x06, 0x4c, 0x36, 0xb0, 0x00, 0x80, 0x07, 0x77, 0x37, 0xe3, 0x81, 0x46, 0x2a, 0x00, 0x81, 0x47, 
0x2c, 0x00, 0x0c, 0x48, 0x0d, 0x49, 0x0e, 0x46, 0xb0, 0x12, 0x9c, 0xfc, 0x07, 0x48, 0x07, 0x58, 
0x81, 0x47, 0x20, 0x00, 0x0b, 0x49, 0x0b, 0x69, 0x81, 0x4b, 0x22, 0x00, 0x1c, 0x81, 0x20, 0x00, 
0x1d, 0x71, 0x22, 0x00, 0x08, 0x45, 0x38, 0xb0, 0x00, 0x80, 0x09, 0x79, 0x39, 0xe3, 0x17, 0x4a, 
0x58, 0x04, 0x06, 0x47, 0x36, 0xb0, 0x00, 0x80, 0x07, 0x77, 0x37, 0xe3, 0x81, 0x46, 0x08, 0x00, 
0x81, 0x47, 0x0a, 0x00, 0x0e, 0x48, 0x0e, 0x56, 0x04, 0x47, 0x04, 0x69, 0x0e, 0x5c, 0x81, 0x4e, 
0x44, 0x00, 0x04, 0x6d, 0x1b, 0x41, 0x10, 0x00, 0x06, 0x4b, 0x36, 0xb0, 0x00, 0x80, 0x07, 0x77, 
0x37, 0xe3, 0x0c, 0x48, 0x0d, 0x49, 0x0e, 0x46, 0xb0, 0x12, 0x9c, 0xfc, 0x0e, 0x48, 0x0e, 0x58, 
0x81, 0x4e, 0x2e, 0x00, 0x0f, 0x49, 0x0f, 0x69, 0x81, 0x4f, 0x30, 0x00, 0x08, 0x4c, 0x09, 0x4d, 
0x18, 0x81, 0x2e, 0x00, 0x19, 0x71, 0x30, 0x00, 0x1c, 0x41, 0x08, 0x00, 0x1d, 0x41, 0x0a, 0x00, 
0x0e, 0x46, 0xb0, 0x12, 0x9c, 0xfc, 0x1b, 0x41, 0x08, 0x00, 0x0b, 0x5b, 0x81, 0x4b, 0x32, 0x00, 
0x1e, 0x41, 0x0a, 0x00, 0x0e, 0x6e, 0x81, 0x4e, 0x34, 0x00, 0x1c, 0x81, 0x32, 0x00, 0x1d, 0x71, 
0x34, 0x00, 0x0e, 0x48, 0x0f, 0x49, 0x0e, 0x8c, 0x0f, 0x7d, 0x81, 0x4e, 0x08, 0x00, 0x81, 0x4f, 
0x0a, 0x00, 0x19, 0x4a, 0x46, 0x02, 0x0c, 0x49, 0x3c, 0xb0, 0x00, 0x80, 0x0d, 0x7d, 0x3d, 0xe3, 
0x0e, 0x46, 0xb0, 0x12, 0x9c, 0xfc, 0x09, 0x11, 0x0e, 0x49, 0x3e, 0xb0, 0x00, 0x80, 0x0f, 0x7f, 
0x3f, 0xe3, 0x0c, 0x8e, 0x0d, 0x7f, 0x09, 0x4c, 0x19, 0x51, 0x08, 0x00, 0x18, 0x41, 0x0a, 0x00, 
0x08, 0x6d, 0x1c, 0x41, 0x44, 0x00, 0x0d, 0x44, 0x1e, 0x41, 0x2a, 0x00, 0xb0, 0x12, 0xb2, 0xfc, 
0x8a, 0x4c, 0x34, 0x00, 0x0c, 0x49, 0x0d, 0x48, 0x1e, 0x41, 0x10, 0x00, 0x1e, 0x53, 0x3e, 0xb0, 
0x00, 0x80, 0x0f, 0x7f, 0x3f, 0xe3, 0xb0, 0x12, 0xb2, 0xfc, 0x09, 0x4c, 0x8a, 0x4c, 0x46, 0x02, 
0x8a, 0x45, 0x58, 0x04, 0x18, 0x4a, 0x6a, 0x06, 0x06, 0x48, 0x36, 0xb0, 0x00, 0x80, 0x07, 0x77, 
0x37, 0xe3, 0x7d, 0x40, 0x0f, 0x00, 0xb0, 0x12, 0xa6, 0xfc, 0x09, 0xec, 0x09, 0x8c, 0x0c, 0x49, 
0x0d, 0x43, 0x0c, 0x5c, 0x0d, 0x6d, 0x0c, 0x5c, 0x0d, 0x6d, 0x0f, 0x4c, 0x0f, 0x56, 0x81, 0x4f, 
0x1c, 0x00, 0x04, 0x4d, 0x04, 0x67, 0x81, 0x44, 0x1e, 0x00, 0x08, 0x11, 0x08, 0x11, 0x38, 0xb0, 
0x00, 0x80, 0x09, 0x79, 0x39, 0xe3, 0x1e, 0x41, 0x1c, 0x00, 0x1f, 0x41, 0x1e, 0x00, 0x0e, 0x88, 
0x0f, 0x79, 0x45, 0x43, 0x05, 0x9f, 0x06, 0x38, 0x0f, 0x93, 0x06, 0x20, 0x36, 0x40, 0xff, 0x7f, 
0x06, 0x9e, 0x02, 0x2c, 0x3e, 0x40, 0xff, 0x7f, 0x8a, 0x4e, 0x6a, 0x06, 0xa1, 0x52, 0x14, 0x00, 
0x2a, 0x53, 0x1a, 0x91, 0x40, 0x00, 0xf4, 0x22, 0x82, 0x43, 0x2c, 0x1f, 0x82, 0x43, 0x30, 0x1f, 
0x82, 0x43, 0x2e, 0x1f, 0x82, 0x43, 0x3e, 0x1f, 0x82, 0x43, 0x58, 0x1f, 0x7e, 0x40, 0x10, 0x00, 
0x4d, 0x43, 0x3c, 0x40, 0xca, 0x1e, 0xb0, 0x12, 0x1a, 0xfd, 0x17, 0x41, 0x3c, 0x00, 0x58, 0x43, 
0x48, 0x97, 0x10, 0x2d, 0x5b, 0x42, 0x59, 0x16, 0x81, 0x4b, 0x08, 0x00, 0x54, 0x42, 0x6f, 0x16, 
0x81, 0x44, 0x2e, 0x00, 0x5c, 0x42, 0x5b, 0x16, 0x0d, 0x43, 0x7e, 0x42, 0xb0, 0x12, 0x9c, 0xfc, 
0x81, 0x4c, 0x2a, 0x00, 0x81, 0x4d, 0x10, 0x00, 0x55, 0x42, 0xc8, 0x1e, 0x81, 0x45, 0x32, 0x00, 
0x38, 0x40, 0xb6, 0x1c, 0x15, 0x41, 0x36, 0x00, 0x44, 0x43, 0x81, 0x43, 0x1c, 0x00, 0x81, 0x43, 
0x40, 0x00, 0x81, 0x43, 0x14, 0x00, 0x81, 0x43, 0x16, 0x00, 0x91, 0x41, 0x14, 0x00, 0x24, 0x00, 
0x91, 0x41, 0x16, 0x00, 0x26, 0x00, 0x47, 0x43, 0x39, 0x43, 0x4a, 0x43, 0x0c, 0x4a, 0x7d, 0x40, 
0x05, 0x00, 0xb0, 0x12, 0xa6, 0xfc, 0x4e, 0x4c, 0x16, 0x41, 0x08, 0x00, 0x46, 0x9c, 0x02, 0x2c, 
0x30, 0x40, 0xac, 0xf8, 0xa1, 0x93, 0x2e, 0x00, 0x01, 0x24, 0x0e, 0x46, 0x06, 0x48, 0x1b, 0x48, 
0xca, 0xf9, 0x0c, 0x4b, 0x3c, 0xb0, 0x00, 0x80, 0x0d, 0x7d, 0x3d, 0xe3, 0x3e, 0xb0, 0x00, 0x80, 
0x0f, 0x7f, 0x3f, 0xe3, 0xb0, 0x12, 0x9c, 0xfc, 0x81, 0x9d, 0x10, 0x00, 0x06, 0x38, 0x1d, 0x91, 
0x10, 0x00, 0x07, 0x20, 0x81, 0x9c, 0x2a, 0x00, 0x04, 0x2c, 0x1c, 0x41, 0x2a, 0x00, 0x1d, 0x41, 
0x10, 0x00, 0x28, 0x53, 0x3e, 0x40, 0x00, 0x80, 0x4f, 0x43, 0x0e, 0x8c, 0x0f, 0x7d, 0x0c, 0x4e, 
0x0d, 0x4f, 0x26, 0x46, 0x0e, 0x46, 0x3e, 0xb0, 0x00, 0x80, 0x0f, 0x7f, 0x3f, 0xe3, 0xb0, 0x12, 
0xda, 0xfc, 0x7e, 0x40, 0x0f, 0x00, 0xb0, 0x12, 0xb2, 0xfc, 0x88, 0x4c, 0xfe, 0xff, 0x0a, 0x95, 
0x0f, 0x20, 0x6f, 0x43, 0x4f, 0x99, 0x0c, 0x38, 0x59, 0x53, 0x4d, 0x49, 0x89, 0x11, 0x0d, 0x5d, 
0x0d, 0x5d, 0x8d, 0x43, 0xca, 0x1e, 0x8d, 0x43, 0xcc, 0x1e, 0x15, 0x41, 0x32, 0x00, 0x05, 0x5a, 
0x1a, 0x91, 0x36, 0x00, 0x12, 0x38, 0x0d, 0x4c, 0x3d, 0xb0, 0x00, 0x80, 0x0e, 0x7e, 0x3e, 0xe3, 
0x81, 0x4d, 0x20, 0x00, 0x81, 0x4e, 0x22, 0x00, 0x0d, 0x49, 0x0d, 0x5d, 0x0d, 0x5d, 0x9d, 0x51, 
0x20, 0x00, 0xca, 0x1e, 0x9d, 0x61, 0x22, 0x00, 0xcc, 0x1e, 0x1a, 0x91, 0x38, 0x00, 0x22, 0x38, 
0x0e, 0x4c, 0x3e, 0xb0, 0x00, 0x80, 0x0f, 0x7f, 0x3f, 0xe3, 0x0d, 0x47, 0x1d, 0x53, 0x17, 0x91, 
0x28, 0x00, 0x02, 0x38, 0x30, 0x40, 0xb4, 0xf8, 0x16, 0x41, 0x24, 0x00, 0x17, 0x41, 0x26, 0x00, 
0x06, 0x5e, 0x07, 0x6f, 0x81, 0x46, 0x24, 0x00, 0x81, 0x47, 0x26, 0x00, 0x07, 0x4d, 0x81, 0x9a, 
0x38, 0x00, 0x08, 0x34, 0x81, 0x9c, 0x40, 0x00, 0x05, 0x34, 0x04, 0x4a, 0x81, 0x4c, 0x40, 0x00, 
0x91, 0x43, 0x1c, 0x00, 0x1a, 0x53, 0x1a, 0x91, 0x0c, 0x00, 0x70, 0x23, 0x81, 0x93, 0x1c, 0x00, 
0x05, 0x24, 0x92, 0x41, 0x40, 0x00, 0x3e, 0x1f, 0x82, 0x44, 0x58, 0x1f, 0x17, 0x41, 0x0c, 0x00, 
0x17, 0x81, 0x28, 0x00, 0x81, 0x47, 0x10, 0x00, 0x18, 0x41, 0x0c, 0x00, 0x38, 0x53, 0x81, 0x48, 
0x20, 0x00, 0x1b, 0x41, 0x0c, 0x00, 0x0b, 0x11, 0x81, 0x4b, 0x0c, 0x00, 0x54, 0x42, 0x5e, 0x16, 
0x81, 0x44, 0x2e, 0x00, 0x0a, 0x48, 0x81, 0x43, 0x1c, 0x00, 0x4b, 0x43, 0x81, 0x43, 0x36, 0x00, 
0x81, 0x43, 0x2a, 0x00, 0x81, 0x43, 0x32, 0x00, 0x47, 0x43, 0x81, 0x43, 0x08, 0x00, 0x81, 0x43, 
0x0a, 0x00, 0x46, 0x43, 0x49, 0x43, 0x81, 0x43, 0x28, 0x00, 0x48, 0x43, 0x81, 0x9a, 0x38, 0x00, 
0x02, 0x34, 0x30, 0x40, 0xcc, 0xf8, 0x81, 0x93, 0x2a, 0x00, 0x03, 0x24, 0x92, 0x41, 0x32, 0x00, 
0x2c, 0x1f, 0x0b, 0x93, 0x06, 0x24, 0x92, 0x41, 0x36, 0x00, 0x2e, 0x1f, 0x92, 0x41, 0x1c, 0x00, 
0x30, 0x1f, 0x0c, 0x46, 0x0d, 0x49, 0x7e, 0x40, 0x06, 0x00, 0xb0, 0x12, 0xb2, 0xfc, 0x82, 0x4c, 
0x54, 0x1f, 0x1c, 0x41, 0x28, 0x00, 0x0d, 0x48, 0x7e, 0x40, 0x06, 0x00, 0xb0, 0x12, 0xb2, 0xfc, 
0x82, 0x4c, 0x56, 0x1f, 0x1e, 0x42, 0x3e, 0x1f, 0x0e, 0x11, 0x0e, 0x11, 0x0e, 0x11, 0x0e, 0x11, 
0x81, 0x4e, 0x46, 0x00, 0x1c, 0x41, 0x3c, 0x00, 0x3c, 0x50, 0xfe, 0xff, 0x5a, 0x42, 0x5c, 0x16, 
0x5f, 0x42, 0x37, 0x1f, 0x0a, 0x8f, 0x0c, 0x9a, 0x01, 0x34, 0x0a, 0x4c, 0x3a, 0xf0, 0xff, 0x00, 
0x38, 0x40, 0xca, 0x1e, 0x09, 0x41, 0x39, 0x50, 0x48, 0x00, 0x04, 0x41, 0x34, 0x50, 0x50, 0x00, 
0x07, 0x49, 0x3c, 0x48, 0x3d, 0x48, 0x7e, 0x40, 0x06, 0x00, 0xb0, 0x12, 0xb2, 0xfc, 0x45, 0x43, 
0x05, 0x9d, 0x06, 0x38, 0x0d, 0x93, 0x06, 0x20, 0x36, 0x40, 0x00, 0x80, 0x06, 0x9c, 0x02, 0x2c, 
0x3c, 0x40, 0x00, 0x80, 0x89, 0x4c, 0x00, 0x00, 0x29, 0x53, 0x04, 0x99, 0xea, 0x23, 0xb1, 0x43, 
0x02, 0x00, 0xb1, 0x40, 0xff, 0x7f, 0x04, 0x00, 0x91, 0x43, 0x00, 0x00, 0x39, 0x40, 0x2c, 0xe8, 
0x4f, 0x4a, 0x3e, 0x40, 0x46, 0x1f, 0x3d, 0x40, 0x42, 0x1f, 0x0c, 0x41, 0x3c, 0x50, 0x46, 0x00, 
0x89, 0x12, 0xb1, 0x40, 0x00, 0x35, 0x02, 0x00, 0xb1, 0x40, 0x0c, 0x00, 0x04, 0x00, 0xa1, 0x42, 
0x00, 0x00, 0x4f, 0x4a, 0x3e, 0x40, 0xea, 0x1e, 0x3d, 0x40, 0xda, 0x1e, 0x0c, 0x47, 0x89, 0x12, 
0x91, 0x42, 0x3c, 0x1f, 0x08, 0x00, 0x1d, 0x42, 0x4c, 0x16, 0x1c, 0x42, 0x3c, 0x1f, 0xb0, 0x12, 
0x74, 0xfc, 0x0c, 0x93, 0x02, 0x20, 0x30, 0x40, 0xf4, 0xf9, 0x77, 0x40, 0x27, 0x00, 0x57, 0x92, 
0x3a, 0x1f, 0x02, 0x28, 0x30, 0x40, 0xf4, 0xf9, 0x18, 0x41, 0x08, 0x00, 0x18, 0x53, 0x82, 0x48, 
0x3c, 0x1f, 0x5a, 0x42, 0x3a, 0x1f, 0x7b, 0x40, 0x27, 0x00, 0x4b, 0x9a, 0x02, 0x2c, 0x7a, 0x40, 
0x27, 0x00, 0x5a, 0x53, 0xc2, 0x4a, 0x3a, 0x1f, 0x3e, 0x40, 0xda, 0x1e, 0x34, 0x40, 0xea, 0x1e, 
0x48, 0x43, 0x45, 0x43, 0x49, 0x43, 0x4d, 0x43, 0x3c, 0x40, 0x00, 0x10, 0x27, 0x4e, 0x1f, 0x4e, 
0x02, 0x00, 0x2e, 0x52, 0x56, 0x43, 0x8e, 0x9f, 0x2e, 0x00, 0x07, 0x38, 0x8e, 0x9f, 0x2e, 0x00, 
0x03, 0x20, 0x8e, 0x97, 0x2c, 0x00, 0x01, 0x28, 0x46, 0x43, 0x48, 0xd6, 0x38, 0xf0, 0xff, 0x00, 
0x0f, 0x9c, 0x04, 0x38, 0x0c, 0x9f, 0x04, 0x20, 0x07, 0x9d, 0x02, 0x2c, 0x0d, 0x47, 0x0c, 0x4f, 
0x09, 0x9f, 0x04, 0x38, 0x0f, 0x99, 0x04, 0x20, 0x05, 0x97, 0x02, 0x2c, 0x05, 0x47, 0x09, 0x4f, 
0x04, 0x9e, 0xdc, 0x23, 0xe2, 0x93, 0x6f, 0x16, 0x14, 0x20, 0x0d, 0x5d, 0x0c, 0x6c, 0x09, 0x9c, 
0x04, 0x38, 0x0c, 0x99, 0x0e, 0x20, 0x05, 0x9d, 0x0c, 0x2c, 0x5c, 0x42, 0x57, 0x16, 0x8c, 0x11, 
0x1d, 0x42, 0x7c, 0x16, 0x0d, 0x8c, 0x5c, 0x42, 0x5d, 0x16, 0x0c, 0x5c, 0x0c, 0x9d, 0x01, 0x34, 
0x48, 0x43, 0x1e, 0x42, 0x50, 0x16, 0x0c, 0x4e, 0x3c, 0xb0, 0x00, 0x80, 0x0d, 0x7d, 0x3d, 0xe3, 
0x1e, 0x42, 0x4e, 0x1f, 0x1f, 0x42, 0x50, 0x1f, 0xb0, 0x12, 0xda, 0xfc, 0x1d, 0x92, 0x48, 0x1f, 
0x08, 0x28, 0x82, 0x9d, 0x48, 0x1f, 0x03, 0x20, 0x1c, 0x92, 0x46, 0x1f, 0x02, 0x28, 0x08, 0x93, 
0x1b, 0x24, 0x92, 0x42, 0x1a, 0x1f, 0xfa, 0x1e, 0x92, 0x42, 0x1c, 0x1f, 0xfc, 0x1e, 0x92, 0x42, 
0x1e, 0x1f, 0xfe, 0x1e, 0x92, 0x42, 0x20, 0x1f, 0x00, 0x1f, 0x92, 0x42, 0x22, 0x1f, 0x02, 0x1f, 
0x92, 0x42, 0x24, 0x1f, 0x04, 0x1f, 0x92, 0x42, 0x26, 0x1f, 0x06, 0x1f, 0x92, 0x42, 0x28, 0x1f, 
0x08, 0x1f, 0x92, 0x42, 0x68, 0x16, 0x52, 0x1f, 0x7a, 0x90, 0x28, 0x00, 0x18, 0x24, 0x92, 0x42, 
0x0a, 0x1f, 0xfa, 0x1e, 0x92, 0x42, 0x0c, 0x1f, 0xfc, 0x1e, 0x92, 0x42, 0x0e, 0x1f, 0xfe, 0x1e, 
0x92, 0x42, 0x10, 0x1f, 0x00, 0x1f, 0x92, 0x42, 0x12, 0x1f, 0x02, 0x1f, 0x92, 0x42, 0x14, 0x1f, 
0x04, 0x1f, 0x92, 0x42, 0x16, 0x1f, 0x06, 0x1f, 0x92, 0x42, 0x18, 0x1f, 0x08, 0x1f, 0x19, 0x42, 
0x52, 0x1f, 0x18, 0x42, 0x68, 0x16, 0x38, 0x50, 0xce, 0xff, 0x47, 0x43, 0x4f, 0x43, 0x0f, 0x99, 
0xc9, 0x35, 0x14, 0x41, 0x12, 0x00, 0x94, 0x94, 0x90, 0x08, 0xb0, 0x08, 0x16, 0x38, 0x94, 0x94, 
0xb0, 0x08, 0x90, 0x08, 0x04, 0x20, 0x94, 0x94, 0x8e, 0x08, 0xae, 0x08, 0x0e, 0x28, 0x15, 0x41, 
0x12, 0x00, 0x1c, 0x45, 0x9e, 0x08, 0x1d, 0x45, 0xa0, 0x08, 0x7e, 0x40, 0x0f, 0x00, 0xb0, 0x12, 
0xc0, 0xfc, 0x56, 0x47, 0x75, 0x16, 0x06, 0x9c, 0xad, 0x2d, 0x5c, 0x43, 0x0d, 0x47, 0xb0, 0x12, 
0x90, 0xfc, 0x1b, 0x41, 0x3e, 0x00, 0x4c, 0xdb, 0x3c, 0xf0, 0xff, 0x00, 0x81, 0x4c, 0x3e, 0x00, 
0x17, 0x53, 0xa1, 0x52, 0x12, 0x00, 0x27, 0x92, 0xd1, 0x23, 0x7a, 0x90, 0x28, 0x00, 0x14, 0x20, 
0x75, 0x40, 0x03, 0x00, 0x15, 0x92, 0x44, 0x1f, 0x0c, 0x38, 0xb2, 0x90, 0x03, 0x00, 0x44, 0x1f, 
0x05, 0x20, 0x36, 0x40, 0x00, 0xe8, 0x16, 0x92, 0x42, 0x1f, 0x03, 0x28, 0x81, 0x93, 0x3e, 0x00, 
0x03, 0x24, 0x92, 0x42, 0x6c, 0x16, 0x34, 0x1f, 0x1a, 0x42, 0x34, 0x1f, 0x0a, 0x93, 0x8d, 0x25, 
0xd2, 0x43, 0x36, 0x1f, 0x82, 0x93, 0x2a, 0x1f, 0x0a, 0x24, 0x1c, 0x42, 0x4e, 0x16, 0x1c, 0x92, 
0x54, 0x1f, 0x18, 0x34, 0x0d, 0x43, 0x0d, 0x8c, 0x82, 0x9d, 0x56, 0x1f, 0x13, 0x34, 0x17, 0x42, 
0x2e, 0x1f, 0x0c, 0x47, 0x3c, 0xb0, 0x00, 0x80, 0x0d, 0x7d, 0x3d, 0xe3, 0x18, 0x42, 0x6a, 0x16, 
0x0e, 0x48, 0x0f, 0x43, 0xb0, 0x12, 0xda, 0xfc, 0x7e, 0x40, 0x0a, 0x00, 0xb0, 0x12, 0xc0, 0xfc, 
0x82, 0x4c, 0x2a, 0x1f, 0x3a, 0x53, 0x82, 0x4a, 0x34, 0x1f, 0x4b, 0x43, 0x0b, 0x99, 0x03, 0x34, 
0x39, 0x53, 0x82, 0x49, 0x52, 0x1f, 0x5a, 0x42, 0x37, 0x1f, 0x58, 0x42, 0x36, 0x1f, 0x19, 0x42, 
0x2a, 0x1f, 0xc2, 0x93, 0x37, 0x1f, 0x5f, 0x25, 0x08, 0x93, 0x5d, 0x25, 0x0c, 0x49, 0x7d, 0x40, 
0x07, 0x00, 0xb0, 0x12, 0xc6, 0xfc, 0x1c, 0x52, 0x38, 0x1f, 0x12, 0xc3, 0x0c, 0x10, 0x12, 0xc3, 
0x0c, 0x10, 0x12, 0xc3, 0x0c, 0x10, 0x82, 0x4c, 0x12, 0x16, 0xb2, 0x40, 0x64, 0x00, 0x14, 0x16, 
0xc2, 0x48, 0x16, 0x16, 0xc2, 0x43, 0x17, 0x16, 0x5d, 0x42, 0x6e, 0x16, 0x0c, 0x4d, 0x4c, 0xf8, 
0xc2, 0xdc, 0x17, 0x16, 0x0c, 0x4d, 0x0c, 0x11, 0x4c, 0xf8, 0x4c, 0xca, 0x5c, 0xf3, 0xc2, 0xdc, 
0x17, 0x16, 0x0d, 0x11, 0x0d, 0x11, 0x4a, 0xfd, 0x4a, 0xc8, 0x5a, 0xf3, 0xc2, 0xda, 0x17, 0x16, 
0x5c, 0x42, 0x17, 0x16, 0x0d, 0x48, 0xb0, 0x12, 0x90, 0xfc, 0xc2, 0x4c, 0x18, 0x16, 0xc2, 0x48, 
0x37, 0x1f, 0x82, 0x49, 0x38, 0x1f, 0x30, 0x40, 0x6a, 0xef, 0x47, 0x43, 0x07, 0x8b, 0x0b, 0x47, 
0x30, 0x40, 0xba, 0xf0, 0x05, 0x8c, 0x08, 0x59, 0x30, 0x40, 0xe2, 0xf0, 0x1e, 0x41, 0x08, 0x00, 
0x30, 0x40, 0x5c, 0xf3, 0x16, 0x41, 0x14, 0x00, 0x17, 0x41, 0x16, 0x00, 0x06, 0x5e, 0x07, 0x6f, 
0x81, 0x46, 0x14, 0x00, 0x81, 0x47, 0x16, 0x00, 0x30, 0x40, 0x3c, 0xf4, 0x91, 0x91, 0x38, 0x00, 
0x10, 0x00, 0x03, 0x34, 0x91, 0x41, 0x20, 0x00, 0x10, 0x00, 0x81, 0x4a, 0x40, 0x00, 0x0c, 0x4a, 
0x0c, 0x5c, 0x1d, 0x4c, 0xb6, 0x1c, 0x1c, 0x41, 0x10, 0x00, 0x0c, 0x5c, 0x1c, 0x4c, 0xb6, 0x1c, 
0x0e, 0x4d, 0x0e, 0x8c, 0x3e, 0xb0, 0x00, 0x80, 0x0f, 0x7f, 0x3f, 0xe3, 0x14, 0x41, 0x24, 0x00, 
0x15, 0x41, 0x26, 0x00, 0x04, 0x5e, 0x05, 0x6f, 0x81, 0x44, 0x24, 0x00, 0x81, 0x45, 0x26, 0x00, 
0x0c, 0x8d, 0x3c, 0xb0, 0x00, 0x80, 0x0d, 0x7d, 0x3d, 0xe3, 0x14, 0x41, 0x14, 0x00, 0x15, 0x41, 
0x16, 0x00, 0x04, 0x5c, 0x05, 0x6d, 0x81, 0x44, 0x14, 0x00, 0x81, 0x45, 0x16, 0x00, 0x0c, 0x44, 
0x0d, 0x45, 0x1c, 0x81, 0x24, 0x00, 0x1d, 0x71, 0x26, 0x00, 0x04, 0x4c, 0x05, 0x4d, 0x09, 0x9d, 
0x04, 0x38, 0x0d, 0x99, 0x29, 0x20, 0x06, 0x94, 0x27, 0x2c, 0x1a, 0x91, 0x0c, 0x00, 0xe2, 0x38, 
0x0c, 0x44, 0x0d, 0x45, 0x0d, 0x11, 0x0c, 0x10, 0x0d, 0x11, 0x0c, 0x10, 0x46, 0x43, 0x47, 0x43, 
0x06, 0x8c, 0x07, 0x7d, 0x81, 0x46, 0x08, 0x00, 0x81, 0x47, 0x0a, 0x00, 0x81, 0x4a, 0x36, 0x00, 
0x81, 0x4a, 0x32, 0x00, 0x07, 0x4a, 0x06, 0x44, 0x09, 0x45, 0x5b, 0x43, 0x91, 0x43, 0x2a, 0x00, 
0xb1, 0x53, 0x10, 0x00, 0x81, 0x4a, 0x1c, 0x00, 0x81, 0x44, 0x28, 0x00, 0x08, 0x45, 0x1a, 0x41, 
0x40, 0x00, 0x3a, 0x53, 0x30, 0x40, 0xbc, 0xf4, 0x1a, 0x91, 0x2e, 0x00, 0x0e, 0x34, 0x0c, 0x46, 
0x0d, 0x49, 0x7e, 0x40, 0x06, 0x00, 0x81, 0x4b, 0x06, 0x00, 0xb0, 0x12, 0xb2, 0xfc, 0x81, 0x8c, 
0x08, 0x00, 0x81, 0x7d, 0x0a, 0x00, 0x1b, 0x41, 0x06, 0x00, 0x15, 0x91, 0x0a, 0x00, 0x08, 0x38, 
0x1c, 0x41, 0x0a, 0x00, 0x0c, 0x95, 0x03, 0x20, 0x14, 0x91, 0x08, 0x00, 0x01, 0x28, 0x07, 0x4a, 
0x08, 0x95, 0x05, 0x38, 0x05, 0x98, 0x0a, 0x20, 0x81, 0x94, 0x28, 0x00, 0x07, 0x2c, 0x1a, 0x41, 
0x1c, 0x00, 0x1c, 0x41, 0x28, 0x00, 0x04, 0x4c, 0x05, 0x48, 0xca, 0x3f, 0x81, 0x47, 0x36, 0x00, 
0x5b, 0x43, 0xc6, 0x3f, 0x92, 0x42, 0x42, 0x1f, 0x4a, 0x1f, 0x92, 0x42, 0x44, 0x1f, 0x4c, 0x1f, 
0x92, 0x42, 0x46, 0x1f, 0x4e, 0x1f, 0x92, 0x42, 0x48, 0x1f, 0x50, 0x1f, 0x14, 0x42, 0x52, 0x16, 
0x05, 0x43, 0x81, 0x44, 0x0c, 0x00, 0x81, 0x45, 0x0e, 0x00, 0x15, 0x42, 0x60, 0x16, 0x19, 0x42, 
0x62, 0x16, 0x54, 0x42, 0x37, 0x1f, 0x16, 0x42, 0x64, 0x16, 0x18, 0x42, 0x66, 0x16, 0x3a, 0x40, 
0xda, 0x1e, 0x37, 0x40, 0x71, 0x16, 0x7c, 0x47, 0x0d, 0x43, 0x3e, 0x4a, 0x3f, 0x4a, 0xb0, 0x12, 
0xda, 0xfc, 0x7e, 0x40, 0x05, 0x00, 0xb0, 0x12, 0xb2, 0xfc, 0x1c, 0x51, 0x0c, 0x00, 0x81, 0x4c, 
0x18, 0x00, 0x1d, 0x61, 0x0e, 0x00, 0x81, 0x4d, 0x1a, 0x00, 0x09, 0x9d, 0x05, 0x38, 0x0d, 0x99, 
0x07, 0x20, 0x15, 0x91, 0x18, 0x00, 0x04, 0x2c, 0x81, 0x45, 0x18, 0x00, 0x81, 0x49, 0x1a, 0x00, 
0x9a, 0x41, 0x18, 0x00, 0x2c, 0x00, 0x9a, 0x41, 0x1a, 0x00, 0x2e, 0x00, 0x04, 0x93, 0x1c, 0x20, 
0x1e, 0x41, 0x18, 0x00, 0x1f, 0x41, 0x1a, 0x00, 0x0f, 0x11, 0x0e, 0x10, 0x0f, 0x11, 0x0e, 0x10, 
0x1c, 0x41, 0x18, 0x00, 0x1d, 0x41, 0x1a, 0x00, 0x0c, 0x8e, 0x0d, 0x7f, 0x0e, 0x4c, 0x0c, 0x4d, 
0x08, 0x9d, 0x04, 0x38, 0x0d, 0x98, 0x04, 0x20, 0x06, 0x9e, 0x02, 0x2c, 0x0e, 0x46, 0x0c, 0x48, 
0x8a, 0x4e, 0x3c, 0x00, 0x8a, 0x4c, 0x3e, 0x00, 0x3b, 0x40, 0xea, 0x1e, 0x0b, 0x9a, 0xbb, 0x23, 
0x30, 0x40, 0xd8, 0xf5, 0x09, 0x98, 0x5c, 0x36, 0x14, 0x41, 0x12, 0x00, 0x94, 0x44, 0xbe, 0x08, 
0xae, 0x08, 0x94, 0x44, 0xc0, 0x08, 0xb0, 0x08, 0x53, 0x3e, 0xc2, 0x43, 0x36, 0x1f, 0x92, 0x42, 
0x34, 0x1f, 0x2a, 0x1f, 0x92, 0x3e, 0x82, 0x49, 0x12, 0x16, 0xaf, 0x3e, 0xd2, 0x43, 0x17, 0x16, 
0xb1, 0x40, 0x00, 0x20, 0x3a, 0x00, 0x30, 0x40, 0x6a, 0xef, 0xd2, 0x42, 0x42, 0x16, 0x33, 0x10, 
0x30, 0x40, 0x82, 0xef, 0x54, 0x42, 0x5a, 0x16, 0x81, 0x44, 0x24, 0x00, 0xa1, 0x43, 0x10, 0x00, 
0x30, 0x40, 0x78, 0xf0, 0x1a, 0x91, 0x2e, 0x00, 0x5a, 0x37, 0x41, 0x3f, 0x0a, 0x12, 0x09, 0x12, 
0xb2, 0x40, 0x80, 0x5a, 0x20, 0x01, 0xf2, 0x42, 0x58, 0x00, 0xf2, 0x40, 0x05, 0x00, 0x57, 0x00, 
0xe2, 0x43, 0xd8, 0x01, 0xc2, 0x43, 0x17, 0x16, 0xf2, 0xf0, 0xcf, 0xff, 0xe9, 0x01, 0x39, 0x40, 
0x5e, 0x11, 0x4a, 0x43, 0xc2, 0x4a, 0xe8, 0x01, 0xe2, 0xd3, 0xe9, 0x01, 0x7c, 0x40, 0x10, 0x00, 
0xb0, 0x12, 0x48, 0xe9, 0x29, 0x53, 0x99, 0x42, 0xea, 0x01, 0xfe, 0xff, 0xe2, 0xc3, 0xe9, 0x01, 
0x2a, 0x53, 0x3a, 0x90, 0x40, 0x00, 0xee, 0x23, 0xe2, 0x92, 0x5f, 0x11, 0x04, 0x20, 0x5c, 0x42, 
0x6a, 0x11, 0x82, 0x4c, 0x08, 0x10, 0x1d, 0x42, 0x08, 0x10, 0xa2, 0x43, 0xa8, 0x01, 0x3d, 0x90, 
0x03, 0x00, 0x44, 0x20, 0xb2, 0x40, 0x35, 0x20, 0xa2, 0x01, 0xb2, 0x40, 0x30, 0x00, 0xa0, 0x01, 
0xb2, 0x40, 0x03, 0x00, 0x36, 0x10, 0xb2, 0x40, 0x03, 0x00, 0xba, 0x10, 0x82, 0x43, 0xa8, 0x01, 
0xb2, 0x40, 0xee, 0x11, 0x36, 0x16, 0xb2, 0x40, 0x42, 0x16, 0x3a, 0x16, 0xb2, 0x40, 0x44, 0x16, 
0x3c, 0x16, 0xb2, 0x40, 0xec, 0x11, 0x38, 0x16, 0xb2, 0x40, 0xe8, 0x11, 0x3e, 0x16, 0xb2, 0x40, 
0x33, 0x10, 0x40, 0x16, 0xb2, 0x40, 0xee, 0x11, 0x4a, 0x16, 0xb2, 0xd0, 0x03, 0x00, 0x04, 0x02, 
0xc2, 0x43, 0xe2, 0x01, 0xc2, 0x43, 0xe6, 0x01, 0x3c, 0x40, 0x00, 0x08, 0xb0, 0x12, 0x4e, 0xe9, 
0xb2, 0x40, 0x1a, 0x16, 0x0e, 0x10, 0xb2, 0x40, 0x12, 0x16, 0x12, 0x10, 0xb2, 0x40, 0x4c, 0x16, 
0x16, 0x10, 0x32, 0xc2, 0x03, 0x43, 0x1c, 0x42, 0x60, 0x1f, 0x0c, 0x93, 0x1a, 0x24, 0xb2, 0xb0, 
0x00, 0xff, 0x60, 0x1f, 0x13, 0x24, 0x32, 0xd0, 0x18, 0x00, 0xf3, 0x3f, 0xb2, 0x40, 0x33, 0x20, 
0xa2, 0x01, 0x7c, 0x42, 0x2d, 0x93, 0x02, 0x24, 0x7c, 0x40, 0x12, 0x00, 0x3c, 0xd0, 0x40, 0x00, 
0x82, 0x4c, 0xac, 0x01, 0xb2, 0x40, 0x12, 0x00, 0xa0, 0x01, 0xb2, 0x3f, 0x32, 0xd0, 0x58, 0x00, 
0xe0, 0x3f, 0x32, 0xd0, 0xf8, 0x00, 0xdd, 0x3f, 0x0f, 0x4c, 0x7c, 0x40, 0x11, 0x00, 0x5b, 0x43, 
0x0d, 0x9f, 0x05, 0x2c, 0x3c, 0x53, 0x0c, 0x93, 0x05, 0x24, 0x0d, 0x93, 0x07, 0x34, 0x4c, 0x43, 
0x0b, 0x93, 0x07, 0x20, 0x0e, 0x93, 0x01, 0x24, 0x0c, 0x4f, 0x30, 0x41, 0x0d, 0x5d, 0x0b, 0x5b, 
0xef, 0x3f, 0x0f, 0x9d, 0x02, 0x28, 0x0f, 0x8d, 0x0c, 0xdb, 0x12, 0xc3, 0x0b, 0x10, 0x12, 0xc3, 
0x0d, 0x10, 0xee, 0x3f, 0x5e, 0x43, 0xb0, 0x12, 0x38, 0xfc, 0x30, 0x41, 0x34, 0x41, 0x35, 0x41, 
0x36, 0x41, 0x37, 0x41, 0x38, 0x41, 0x39, 0x41, 0x3a, 0x41, 0x30, 0x41, 0x3d, 0x53, 0x0c, 0x5c, 
0x0d, 0x93, 0xfc, 0x23, 0x30, 0x41, 0x3e, 0x53, 0x0c, 0x5c, 0x0d, 0x6d, 0x0e, 0x93, 0xfb, 0x23, 
0x30, 0x41, 0x3d, 0x53, 0x0c, 0x11, 0x0d, 0x93, 0xfc, 0x23, 0x30, 0x41, 0x3e, 0x53, 0x0d, 0x11, 
0x0c, 0x10, 0x0e, 0x93, 0xfb, 0x23, 0x30, 0x41, 0x3e, 0x53, 0x12, 0xc3, 0x0d, 0x10, 0x0c, 0x10, 
0x0e, 0x93, 0xfa, 0x23, 0x30, 0x41, 0x02, 0x12, 0x32, 0xc2, 0x03, 0x43, 0x82, 0x4c, 0x30, 0x01, 
0x82, 0x4d, 0x38, 0x01, 0x1c, 0x42, 0x3a, 0x01, 0x00, 0x13, 0x02, 0x12, 0x32, 0xc2, 0x03, 0x43, 
0x82, 0x4c, 0x30, 0x01, 0x82, 0x4e, 0x38, 0x01, 0x82, 0x4c, 0x34, 0x01, 0x1c, 0x42, 0x3a, 0x01, 
0x92, 0x42, 0x3c, 0x01, 0x3a, 0x01, 0x82, 0x4f, 0x38, 0x01, 0x82, 0x4d, 0x34, 0x01, 0x82, 0x4e, 
0x38, 0x01, 0x1d, 0x42, 0x3a, 0x01, 0x00, 0x13, 0x0f, 0x4c, 0x0e, 0x5d, 0x0d, 0x9e, 0x01, 0x20, 
0x30, 0x41, 0xff, 0x4d, 0x00, 0x00, 0x1f, 0x53, 0xf9, 0x3f, 0x0e, 0x5c, 0x0f, 0x4c, 0x0f, 0x9e, 
0x01, 0x20, 0x30, 0x41, 0x1f, 0x53, 0xcf, 0x4d, 0xff, 0xff, 0xf9, 0x3f, 0x0a, 0x12, 0x09, 0x12, 
0x0f, 0x4d, 0x0f, 0x5e, 0x0d, 0x9c, 0x02, 0x2c, 0x0c, 0x9f, 0x07, 0x28, 0x0e, 0x4c, 0x0d, 0x9f, 
0x0a, 0x24, 0xfe, 0x4d, 0x00, 0x00, 0x1e, 0x53, 0xfa, 0x3f, 0x09, 0x4e, 0x39, 0xe3, 0x4d, 0x43, 
0x3d, 0x53, 0x09, 0x9d, 0x01, 0x20, 0x97, 0x3f, 0x0b, 0x4e, 0x0b, 0x5d, 0x0b, 0x5c, 0x0a, 0x4f, 
0x0a, 0x5d, 0xeb, 0x4a, 0x00, 0x00, 0xf4, 0x3f, };

const unsigned char icu_presence_fw_vec[ICU_PRESENCE_VEC_SIZE] = {
0x30, 0xea, 0x32, 0xea, 0x34, 0xea, 0xae, 0xea, 0x84, 0xea, 0x5a, 0xea, 0x2c, 0xea, 0x2e, 0xea, 
0xd2, 0xee, 0xc4, 0xee, 0x36, 0xea, 0xd6, 0xea, 0x14, 0xee, 0x54, 0xeb, 0x2a, 0xea, 0x00, 0xe8, 
};

