/*
 *
 * Copyright (c) [2020] by InvenSense, Inc.
 * 
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#ifndef __INV_IMU_EDMP_ALGO_DEFS_H__
#define __INV_IMU_EDMP_ALGO_DEFS_H__

#ifdef __cplusplus
extern "C" {
#endif

/* ======== GAF define values ======== */

/* Set GAF algorithm define values useful at driver level*/
#define EDMP_COV_MAX_SELECTED_ACCURACY_0 500000
#define EDMP_COV_MAX_SELECTED_ACCURACY_1 9999
#define EDMP_COV_MAX_SELECTED_ACCURACY_2 4999
#define EDMP_COV_MAX_SELECTED_ACCURACY_3 2499

/* Macro used when reconfiguring GAF PDR */
#define EDMP_GAF_PARTITION_CNT 12
#define EDMP_GAF_DMPODR_CNT 6

#define EDMP_GAF_PDR_NOT_ALLOWED  {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/*******************************************/
/* Set of macro used when GAF PDR is 50 Hz */
/*******************************************/

/* Set of macro used when GAF PDR is 50 Hz and there is NO MAG */
#define EDMP_GAF_PDR_50HZ_NOMAG_DMPODR_800HZ  {0x80008000, 0x00010001, 0x00020002, 0x00040004, 0x00000008, 0x00000010, 0x00000020, 0x00000040, 0x00000080, 0x00000100, 0x02000200, 0x00000880}
#define EDMP_GAF_PDR_50HZ_NOMAG_DMPODR_400HZ  {0x00008080, 0x00008080, 0x00008080, 0x00008080, 0x00000001, 0x00000002, 0x00000004, 0x00000008, 0x00000008, 0x00000010, 0x00001010, 0x00000042}
#define EDMP_GAF_PDR_50HZ_NOMAG_DMPODR_200HZ  {0x00000088, 0x00000088, 0x00000088, 0x00000088, 0x00000008, 0x00000001, 0x00000001, 0x00000001, 0x00000002, 0x00000002, 0x00000022, 0x00000005}
#define EDMP_GAF_PDR_50HZ_NOMAG_DMPODR_100HZ  {0x0000000A, 0x0000000A, 0x0000000A, 0x0000000A, 0x00000002, 0x00000002, 0x00000002, 0x00000002, 0x00000002, 0x00000002, 0x0000000A, 0x00000003}
#define EDMP_GAF_PDR_50HZ_NOMAG_DMPODR_50HZ   {0x00000003, 0x00000003, 0x00000003, 0x00000003, 0x00000002, 0x00000002, 0x00000002, 0x00000002, 0x00000002, 0x00000002, 0x00000003, 0x00000003}
#define EDMP_GAF_PDR_50HZ_NOMAG {EDMP_GAF_PDR_NOT_ALLOWED, EDMP_GAF_PDR_50HZ_NOMAG_DMPODR_50HZ, EDMP_GAF_PDR_50HZ_NOMAG_DMPODR_100HZ, EDMP_GAF_PDR_50HZ_NOMAG_DMPODR_200HZ, EDMP_GAF_PDR_50HZ_NOMAG_DMPODR_400HZ, EDMP_GAF_PDR_50HZ_NOMAG_DMPODR_800HZ}
#define EDMP_GAF_PDR_50HZ_NOMAG_DECLARE_ARRAY(a) const int32_t a[EDMP_GAF_DMPODR_CNT][EDMP_GAF_PARTITION_CNT] = EDMP_GAF_PDR_50HZ_NOMAG

/* Set of macro used when GAF PDR is 50 Hz and MAG ODR is 25Hz */
#define EDMP_GAF_PDR_50HZ_MAGODR_25HZ_DMPODR_800HZ  {0x80008000, 0x00010001, 0x00020002, 0x00040004, 0x00080000, 0x00100000, 0x00200000, 0x00400000, 0x00800000, 0x01000000, 0x02000200, 0x00000880}
#define EDMP_GAF_PDR_50HZ_MAGODR_25HZ_DMPODR_400HZ  {0x00008080, 0x00008080, 0x00008080, 0x00008080, 0x00000100, 0x00000200, 0x00000400, 0x00000800, 0x00000800, 0x00001000, 0x00001010, 0x00000042}
#define EDMP_GAF_PDR_50HZ_MAGODR_25HZ_DMPODR_200HZ  {0x00000088, 0x00000088, 0x00000088, 0x00000088, 0x00000008, 0x00000008, 0x00000010, 0x00000010, 0x00000010, 0x00000010, 0x00000011, 0x00000005}
#define EDMP_GAF_PDR_50HZ_MAGODR_25HZ_DMPODR_100HZ  {0x0000000A, 0x0000000A, 0x0000000A, 0x0000000A, 0x00000002, 0x00000002, 0x00000002, 0x00000002, 0x00000002, 0x00000002, 0x0000000A, 0x00000003}
#define EDMP_GAF_PDR_50HZ_MAGODR_25HZ {EDMP_GAF_PDR_NOT_ALLOWED, EDMP_GAF_PDR_NOT_ALLOWED, EDMP_GAF_PDR_50HZ_MAGODR_25HZ_DMPODR_100HZ, EDMP_GAF_PDR_50HZ_MAGODR_25HZ_DMPODR_200HZ, EDMP_GAF_PDR_50HZ_MAGODR_25HZ_DMPODR_400HZ, EDMP_GAF_PDR_50HZ_MAGODR_25HZ_DMPODR_800HZ}
#define EDMP_GAF_PDR_50HZ_MAGODR_25HZ_DECLARE_ARRAY(a) const int32_t a[EDMP_GAF_DMPODR_CNT][EDMP_GAF_PARTITION_CNT] = EDMP_GAF_PDR_50HZ_MAGODR_25HZ

/* Set of macro used when GAF PDR is 50 Hz and MAG ODR is 50Hz */
#define EDMP_GAF_PDR_50HZ_MAGODR_50HZ_DMPODR_800HZ  {0x80008000, 0x00010001, 0x00020002, 0x00040004, 0x00080008, 0x00100010, 0x00200020, 0x00400040, 0x00800080, 0x01000100, 0x02000200, 0x08800880}
#define EDMP_GAF_PDR_50HZ_MAGODR_50HZ_DMPODR_400HZ  {0x00008080, 0x00008080, 0x00008080, 0x00008080, 0x00000101, 0x00000202, 0x00000404, 0x00000808, 0x00000808, 0x00001010, 0x00001010, 0x00004242}
#define EDMP_GAF_PDR_50HZ_MAGODR_50HZ_DMPODR_200HZ  {0x00000088, 0x00000088, 0x00000088, 0x00000088, 0x00000088, 0x00000088, 0x00000011, 0x00000011, 0x00000011, 0x00000011, 0x00000011, 0x00000055}
#define EDMP_GAF_PDR_50HZ_MAGODR_50HZ_DMPODR_100HZ  {0x0000000A, 0x0000000A, 0x0000000A, 0x0000000A, 0x0000000A, 0x0000000A, 0x0000000A, 0x0000000A, 0x0000000A, 0x0000000A, 0x0000000A, 0x0000000F}
#define EDMP_GAF_PDR_50HZ_MAGODR_50HZ {EDMP_GAF_PDR_NOT_ALLOWED, EDMP_GAF_PDR_NOT_ALLOWED, EDMP_GAF_PDR_50HZ_MAGODR_50HZ_DMPODR_100HZ, EDMP_GAF_PDR_50HZ_MAGODR_50HZ_DMPODR_200HZ, EDMP_GAF_PDR_50HZ_MAGODR_50HZ_DMPODR_400HZ, EDMP_GAF_PDR_50HZ_MAGODR_50HZ_DMPODR_800HZ}
#define EDMP_GAF_PDR_50HZ_MAGODR_50HZ_DECLARE_ARRAY(a) const int32_t a[EDMP_GAF_DMPODR_CNT][EDMP_GAF_PARTITION_CNT] = EDMP_GAF_PDR_50HZ_MAGODR_50HZ

/********************************************/
/* Set of macro used when GAF PDR is 100 Hz */
/********************************************/

/* Set of macro used when GAF PDR is 100 Hz and there is NO MAG */
#define EDMP_GAF_PDR_100HZ_NOMAG_DMPODR_800HZ  {0x80808080, 0x80808080, 0x00810081, 0x00810081, 0x01000100, 0x02000200, 0x02000200, 0x04000400, 0x08000800, 0x08000800, 0x08080808, 0x00220022}
#define EDMP_GAF_PDR_100HZ_NOMAG_DMPODR_400HZ  {0x00000909, 0x00000909, 0x00000909, 0x00001212, 0x00001010, 0x00002020, 0x00002020, 0x00004040, 0x00004040, 0x00008080, 0x00008888, 0x00001414}
#define EDMP_GAF_PDR_100HZ_NOMAG_DMPODR_200HZ  {0x000000AA, 0x000000AA, 0x000000AA, 0x000000AA, 0x00000022, 0x00000022, 0x00000044, 0x00000044, 0x00000044, 0x00000044, 0x00000055, 0x00000033}
#define EDMP_GAF_PDR_100HZ_NOMAG_DMPODR_100HZ  {0x0000000F, 0x0000000F, 0x0000000F, 0x0000000F, 0x0000000A, 0x0000000A, 0x0000000A, 0x0000000A, 0x0000000A, 0x0000000A, 0x0000000F, 0x0000000F}
#define EDMP_GAF_PDR_100HZ_NOMAG {EDMP_GAF_PDR_NOT_ALLOWED, EDMP_GAF_PDR_NOT_ALLOWED, EDMP_GAF_PDR_100HZ_NOMAG_DMPODR_100HZ, EDMP_GAF_PDR_100HZ_NOMAG_DMPODR_200HZ, EDMP_GAF_PDR_100HZ_NOMAG_DMPODR_400HZ, EDMP_GAF_PDR_100HZ_NOMAG_DMPODR_800HZ}
#define EDMP_GAF_PDR_100HZ_NOMAG_DECLARE_ARRAY(a) const int32_t a[EDMP_GAF_DMPODR_CNT][EDMP_GAF_PARTITION_CNT] = EDMP_GAF_PDR_100HZ_NOMAG


/* Set of macro used when GAF PDR is 100 Hz and MAG ODR is 50Hz (GAF-9 axis Fusion can not be ON when DMP ODR is 800 Hz) */
#define EDMP_GAF_PDR_100HZ_MAGODR_50HZ_DMPODR_800HZ  {0x80808080, 0x80808080, 0x00810081, 0x00810081, 0x01000100, 0x02000200, 0x02000200, 0x04000400, 0x08000800, 0x08000800, 0x08080808, 0x00220022}
#define EDMP_GAF_PDR_100HZ_MAGODR_50HZ_DMPODR_400HZ  {0x00000909, 0x00000909, 0x00000909, 0x00001212, 0x00001010, 0x00002020, 0x00002020, 0x00004040, 0x00004040, 0x00008080, 0x00008888, 0x00001414}
#define EDMP_GAF_PDR_100HZ_MAGODR_50HZ_DMPODR_200HZ  {0x000000AA, 0x000000AA, 0x000000AA, 0x000000AA, 0x00000022, 0x00000022, 0x00000044, 0x00000044, 0x00000044, 0x00000044, 0x00000055, 0x00000033}
#define EDMP_GAF_PDR_100HZ_MAGODR_50HZ {EDMP_GAF_PDR_NOT_ALLOWED, EDMP_GAF_PDR_NOT_ALLOWED, EDMP_GAF_PDR_NOT_ALLOWED, EDMP_GAF_PDR_100HZ_MAGODR_50HZ_DMPODR_200HZ, EDMP_GAF_PDR_100HZ_MAGODR_50HZ_DMPODR_400HZ, EDMP_GAF_PDR_100HZ_MAGODR_50HZ_DMPODR_800HZ}
#define EDMP_GAF_PDR_100HZ_MAGODR_50HZ_DECLARE_ARRAY(a) const int32_t a[EDMP_GAF_DMPODR_CNT][EDMP_GAF_PARTITION_CNT] = EDMP_GAF_PDR_100HZ_MAGODR_50HZ

/* Set of macro used when GAF PDR is 100 Hz and MAG ODR is 100Hz (GAF-9 axis Fusion can not be ON when DMP ODR is 400 or 800 Hz) */
#define EDMP_GAF_PDR_100HZ_MAGODR_100HZ_DMPODR_800HZ  {0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x01010101, 0x02020202, 0x02020202, 0x04040404, 0x08080808, 0x08080808, 0x08080808, 0x22222222}
#define EDMP_GAF_PDR_100HZ_MAGODR_100HZ_DMPODR_400HZ  {0x00008888, 0x00008888, 0x00008888, 0x00008888, 0x00008888, 0x00001111, 0x00002222, 0x00002222, 0x00002222, 0x00002222, 0x00002222, 0x0000AAAA}
#define EDMP_GAF_PDR_100HZ_MAGODR_100HZ_DMPODR_200HZ  {0x000000AA, 0x000000AA, 0x000000AA, 0x000000AA, 0x000000AA, 0x000000AA, 0x00000055, 0x00000055, 0x00000055, 0x00000055, 0x00000055, 0x000000FF}
#define EDMP_GAF_PDR_100HZ_MAGODR_100HZ {EDMP_GAF_PDR_NOT_ALLOWED, EDMP_GAF_PDR_NOT_ALLOWED, EDMP_GAF_PDR_NOT_ALLOWED, EDMP_GAF_PDR_100HZ_MAGODR_100HZ_DMPODR_200HZ, EDMP_GAF_PDR_100HZ_MAGODR_100HZ_DMPODR_400HZ, EDMP_GAF_PDR_100HZ_MAGODR_100HZ_DMPODR_800HZ}
#define EDMP_GAF_PDR_100HZ_MAGODR_100HZ_DECLARE_ARRAY(a) const int32_t a[EDMP_GAF_DMPODR_CNT][EDMP_GAF_PARTITION_CNT] = EDMP_GAF_PDR_100HZ_MAGODR_100HZ

/********************************************/
/* Set of macro used when GAF PDR is 200 Hz */
/********************************************/

/* Set of macro used when GAF PDR is 200 Hz and there is NO MAG */
#define EDMP_GAF_PDR_200HZ_NOMAG_DMPODR_800HZ  {0x11111111, 0x11111111, 0x11111111, 0x11111111, 0x00400040, 0x00800080, 0x02000200, 0x04000400, 0x04000400, 0x08000800, 0x88888888, 0x00220022}
#define EDMP_GAF_PDR_200HZ_NOMAG_DMPODR_400HZ  {0x00005555, 0x00005555, 0x0000AAAA, 0x0000AAAA, 0x00001010, 0x00002020, 0x00004040, 0x00008080, 0x00000101, 0x00000202, 0x00005555, 0x00001414}
#define EDMP_GAF_PDR_200HZ_NOMAG_DMPODR_200HZ  {0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x00000022, 0x00000044, 0x00000044, 0x00000088, 0x00000088, 0x00000011, 0x000000FF, 0x00000033}
#define EDMP_GAF_PDR_200HZ_NOMAG {EDMP_GAF_PDR_NOT_ALLOWED, EDMP_GAF_PDR_NOT_ALLOWED, EDMP_GAF_PDR_NOT_ALLOWED, EDMP_GAF_PDR_200HZ_NOMAG_DMPODR_200HZ, EDMP_GAF_PDR_200HZ_NOMAG_DMPODR_400HZ, EDMP_GAF_PDR_200HZ_NOMAG_DMPODR_800HZ}
#define EDMP_GAF_PDR_200HZ_NOMAG_DECLARE_ARRAY(a) const int32_t a[EDMP_GAF_DMPODR_CNT][EDMP_GAF_PARTITION_CNT] = EDMP_GAF_PDR_200HZ_NOMAG


/* Set of macro used when GAF PDR is 200 Hz and MAG ODR is 50Hz (only allowed DMP ODR is 400Hz and GAF-9 axis Fusion can not be ON if other ROM features run concurrently) */
/* EDMP_GAF_PDR_200HZ_MAGODR_50HZ_DMPODR_800HZ is not allowed, this is not a possible usecase to have DMP ODR 800 Hz and GAF 200 Hz with mag ON
 */
#define EDMP_GAF_PDR_200HZ_MAGODR_50HZ_DMPODR_400HZ  {0x00005555, 0x00005555, 0x0000AAAA, 0x0000AAAA, 0x00001010, 0x00002020, 0x00004040, 0x00008080, 0x00000101, 0x00000202, 0x00005555, 0x00001414}
#define EDMP_GAF_PDR_200HZ_MAGODR_50HZ {EDMP_GAF_PDR_NOT_ALLOWED, EDMP_GAF_PDR_NOT_ALLOWED, EDMP_GAF_PDR_NOT_ALLOWED, EDMP_GAF_PDR_NOT_ALLOWED, EDMP_GAF_PDR_200HZ_MAGODR_50HZ_DMPODR_400HZ, EDMP_GAF_PDR_NOT_ALLOWED}
#define EDMP_GAF_PDR_200HZ_MAGODR_50HZ_DECLARE_ARRAY(a) const int32_t a[EDMP_GAF_DMPODR_CNT][EDMP_GAF_PARTITION_CNT] = EDMP_GAF_PDR_200HZ_MAGODR_50HZ

/* Set of macro used when GAF PDR is 200 Hz and MAG ODR is 100Hz (only allowed DMP ODR is 400Hz and GAF-9 axis Fusion can not be ON) */
/* EDMP_GAF_PDR_200HZ_MAGODR_100HZ_DMPODR_800HZ is not allowed, this is not a possible usecase to have DMP ODR 800 Hz and GAF 200 Hz with mag ON
 */
#define EDMP_GAF_PDR_200HZ_MAGODR_100HZ_DMPODR_400HZ  {0x0000AAAA, 0x0000AAAA, 0x0000AAAA, 0x0000AAAA, 0x00008888, 0x00001111, 0x00001111, 0x00002222, 0x00002222, 0x00002222, 0x0000AAAA, 0x0000AAAA}
#define EDMP_GAF_PDR_200HZ_MAGODR_100HZ {EDMP_GAF_PDR_NOT_ALLOWED, EDMP_GAF_PDR_NOT_ALLOWED, EDMP_GAF_PDR_NOT_ALLOWED, EDMP_GAF_PDR_NOT_ALLOWED, EDMP_GAF_PDR_200HZ_MAGODR_100HZ_DMPODR_400HZ, EDMP_GAF_PDR_NOT_ALLOWED}
#define EDMP_GAF_PDR_200HZ_MAGODR_100HZ_DECLARE_ARRAY(a) const int32_t a[EDMP_GAF_DMPODR_CNT][EDMP_GAF_PARTITION_CNT] = EDMP_GAF_PDR_200HZ_MAGODR_100HZ

/********************************************/
/* Set of macro used when GAF PDR is 400 Hz */
/********************************************/

/* Set of macro used when GAF PDR is 400 Hz and there is NO MAG */
#define EDMP_GAF_PDR_400HZ_NOMAG_DMPODR_800HZ  {0x55555555, 0x55555555, 0x55555555, 0x55555555, 0x00200020, 0x00800080, 0x02000200, 0x08000800, 0x08000800, 0x08000800, 0xAAAAAAAA, 0x00220022}
#define EDMP_GAF_PDR_400HZ_NOMAG_DMPODR_400HZ  {0x0000FFFF, 0x0000FFFF, 0x0000FFFF, 0x0000FFFF, 0x00000808, 0x00001010, 0x00002020, 0x00004040, 0x00008080, 0x00008080, 0x0000FFFF, 0x00000A0A}
#define EDMP_GAF_PDR_400HZ_NOMAG {EDMP_GAF_PDR_NOT_ALLOWED, EDMP_GAF_PDR_NOT_ALLOWED, EDMP_GAF_PDR_NOT_ALLOWED, EDMP_GAF_PDR_NOT_ALLOWED, EDMP_GAF_PDR_400HZ_NOMAG_DMPODR_400HZ, EDMP_GAF_PDR_400HZ_NOMAG_DMPODR_800HZ}
#define EDMP_GAF_PDR_400HZ_NOMAG_DECLARE_ARRAY(a) const int32_t a[EDMP_GAF_DMPODR_CNT][EDMP_GAF_PARTITION_CNT] = EDMP_GAF_PDR_400HZ_NOMAG



/* ======== SIF define values ======== */

/* Macro used when reconfiguring SIF PDR */
#define EDMP_SIF_PARTITION_CNT 7
#define EDMP_SIF_DMPODR_CNT 6

#define EDMP_SIF_PDR_NOT_ALLOWED  {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* Set of macro used when SIF PDR is 50 Hz - This is default in ROM at DMP Init time */
#define EDMP_SIF_PDR_50HZ_DMPODR_800HZ  {0x00010001, 0x00020002, 0x00040004, 0x00080008, 0x00100010, 0x00200020, 0x00400040}
#define EDMP_SIF_PDR_50HZ_DMPODR_400HZ  {0x00000101, 0x00000202, 0x00000202, 0x00000404, 0x00000404, 0x00008080, 0x00008080}
#define EDMP_SIF_PDR_50HZ_DMPODR_200HZ  {0x00000022, 0x00000044, 0x00000044, 0x00000088, 0x00000088, 0x00000088, 0x00000088}
#define EDMP_SIF_PDR_50HZ_DMPODR_100HZ  {0x00000005, 0x00000005, 0x00000005, 0x00000005, 0x00000005, 0x00000005, 0x00000005}
#define EDMP_SIF_PDR_50HZ_DMPODR_50HZ   {0x00000003, 0x00000003, 0x00000003, 0x00000003, 0x00000003, 0x00000003, 0x00000003}
#define EDMP_SIF_PDR_50HZ {EDMP_SIF_PDR_NOT_ALLOWED, EDMP_SIF_PDR_50HZ_DMPODR_50HZ, EDMP_SIF_PDR_50HZ_DMPODR_100HZ, EDMP_SIF_PDR_50HZ_DMPODR_200HZ, EDMP_SIF_PDR_50HZ_DMPODR_400HZ, EDMP_SIF_PDR_50HZ_DMPODR_800HZ}
#define EDMP_SIF_PDR_50HZ_DECLARE_ARRAY(a) const int32_t a[EDMP_SIF_DMPODR_CNT][EDMP_SIF_PARTITION_CNT] = EDMP_SIF_PDR_50HZ

/* Set of macro used when SIF PDR is 100 Hz */
#define EDMP_SIF_PDR_100HZ_DMPODR_800HZ {0x01010101, 0x02020202, 0x04040404, 0x08080808, 0x10101010, 0x20202020, 0x40404040}
#define EDMP_SIF_PDR_100HZ_DMPODR_400HZ {0x00001111, 0x00002222, 0x00002222, 0x00004444, 0x00004444, 0x00008888, 0x00008888}
#define EDMP_SIF_PDR_100HZ_DMPODR_200HZ {0x00000055, 0x00000055, 0x00000055, 0x000000AA, 0x000000AA, 0x000000AA, 0x000000AA}
#define EDMP_SIF_PDR_100HZ_DMPODR_100HZ {0x0000000F, 0x0000000F, 0x0000000F, 0x0000000F, 0x0000000F, 0x0000000F, 0x0000000F}
#define EDMP_SIF_PDR_100HZ {EDMP_SIF_PDR_NOT_ALLOWED, EDMP_SIF_PDR_NOT_ALLOWED, EDMP_SIF_PDR_100HZ_DMPODR_100HZ, EDMP_SIF_PDR_100HZ_DMPODR_200HZ, EDMP_SIF_PDR_100HZ_DMPODR_400HZ, EDMP_SIF_PDR_100HZ_DMPODR_800HZ}
#define EDMP_SIF_PDR_100HZ_DECLARE_ARRAY(a) const int32_t a[EDMP_SIF_DMPODR_CNT][EDMP_SIF_PARTITION_CNT] = EDMP_SIF_PDR_100HZ


#ifdef __cplusplus
}
#endif

#endif // __INV_IMU_EDMP_ALGO_DEFS_H__

