#ifndef TickerTape7SegmentDisplay_H
#define TickerTape7SegmentDisplay_H

#include "Arduino.h"

class TickerTape7SegmentDisplay
{
public:
    TickerTape7SegmentDisplay(int a, int b, int c, int d,
                  int e, int f, int g, int dp,
                  bool isAnode);
    void test();
    void setRepresentation(int position, char ch, byte repr);
    int  findCharIndex(char ch);
    void showChar(char ch);
    void showTicker(String stringTicker, int delayMicros);
    void clearDisplay();

private:
    int pins[8];
    bool isAnode;
    byte representationsByte[70];
    char representationsChar[70];
};


class TickerTape7SegmentDisplay4Digit
{
public:
    TickerTape7SegmentDisplay4Digit(int a,  int b,  int c,  int d,
                        int e,  int f,  int g,  int dp,
                        int d0, int d1, int d2, int d3,
                        bool isAnode);
    void setRepresentation(int position, char ch, byte repr);
    int  findCharIndex(char ch);
    void clearDisplay();
    void showChar(char ch, int digitIdx);
    void show4Chars(char ch0, char ch1, char ch2, char ch3, int durationMicros);
    void test();
    void showTicker(String stringTicker, int delayMicros);

private:
    int pins[8], dpins[4];
    bool isAnode;
    byte representationsByte[70];
    char representationsChar[70];
};

#endif
