#include "Arduino.h"
#include "TickerTape7SegmentDisplay.h"

TickerTape7SegmentDisplay::TickerTape7SegmentDisplay(int a, int b, int c, int d,
                             int e, int f, int g, int dp,
                             bool isAnode) {
    pins[0] = a;
    pins[1] = b;
    pins[2] = c;
    pins[3] = d;
    pins[4] = e;
    pins[5] = f;
    pins[6] = g;
    pins[7] = dp;
    this->isAnode = isAnode;
    setRepresentation(0,  'a', B11101110);
    setRepresentation(1,  'A', B11101110);
    setRepresentation(2,  'b', B00111110);
    setRepresentation(3,  'B', B00111110);
    setRepresentation(4,  'c', B00011010);
    setRepresentation(5,  'C', B00011010);
    setRepresentation(6,  'd', B01111010);
    setRepresentation(7,  'D', B01111010);
    setRepresentation(8,  'e', B10011110);
    setRepresentation(9,  'E', B10011110);
    setRepresentation(10, 'f', B10001110);
    setRepresentation(11, 'F', B10001110);
    setRepresentation(12, 'g', B10111100);
    setRepresentation(13, 'G', B10111100);
    setRepresentation(14, 'h', B00101110);
    setRepresentation(15, 'H', B00101110);
    setRepresentation(16, 'i', B00001100);
    setRepresentation(17, 'I', B00001100);
    setRepresentation(18, 'j', B01111000);
    setRepresentation(19, 'J', B01111000);
    setRepresentation(20, 'k', B01101110);
    setRepresentation(21, 'K', B01101110);
    setRepresentation(22, 'l', B00011100);
    setRepresentation(23, 'L', B00011100);
    setRepresentation(24, 'm', B10101010);
    setRepresentation(25, 'M', B10101010);
    setRepresentation(26, 'n', B00101010);
    setRepresentation(27, 'N', B00101010);
    setRepresentation(28, 'o', B00111010);
    setRepresentation(29, 'O', B00111010);
    setRepresentation(30, 'p', B11001110);
    setRepresentation(31, 'P', B11001110);
    setRepresentation(32, 'q', B11100110);
    setRepresentation(33, 'Q', B11100110);
    setRepresentation(34, 'r', B00001010);
    setRepresentation(35, 'R', B00001010);
    setRepresentation(36, 's', B10110100);
    setRepresentation(37, 'S', B10110100);
    setRepresentation(38, 't', B00011110);
    setRepresentation(39, 'T', B00011110);
    setRepresentation(40, 'u', B01111100);
    setRepresentation(41, 'U', B01111100);
    setRepresentation(42, 'v', B00111000);
    setRepresentation(43, 'V', B00111000);
    setRepresentation(44, 'w', B01010110);
    setRepresentation(45, 'W', B01010110);
    setRepresentation(46, 'x', B01101100);
    setRepresentation(47, 'X', B01101100);
    setRepresentation(48, 'Y', B01110110);
    setRepresentation(49, 'y', B01110110);
    setRepresentation(50, 'z', B11011000);
    setRepresentation(51, 'Z', B11011000);
    setRepresentation(52, '0', B11111100);
    setRepresentation(53, '1', B01100000);
    setRepresentation(54, '2', B11011010);
    setRepresentation(55, '3', B11110010);
    setRepresentation(56, '4', B01100110);
    setRepresentation(57, '5', B10110110);
    setRepresentation(58, '6', B10111110);
    setRepresentation(59, '7', B11100000);
    setRepresentation(60, '8', B11111110);
    setRepresentation(61, '9', B11110110);
    setRepresentation(62, '@', B11111010);
    setRepresentation(63, '.', B00000001);
    setRepresentation(64, ' ', B00000000);
    for (int i = 0; i < 8; i++) {
        pinMode(pins[i], OUTPUT);
    }
}

void TickerTape7SegmentDisplay::setRepresentation(int position, char ch, byte repr) {
    representationsChar[position] = ch;
    representationsByte[position] = repr;
}
   
int TickerTape7SegmentDisplay::findCharIndex(char ch) {
    for (int i=0; i<70; i++) {
        if (representationsChar[i] == ch) {
            return i;
        }
    } 
    return -1;
}
 
void TickerTape7SegmentDisplay::showChar(char ch) {
    int charIndex = findCharIndex(ch);
    if (charIndex >= 0) {
        for (int i=0; i<8; i++) {
            digitalWrite(pins[i], bitRead(representationsByte[charIndex], 7-i) ? ! isAnode : isAnode);
        }
    }
}
    
void TickerTape7SegmentDisplay::clearDisplay(){
    for (int i=0; i<8; i++) {
        digitalWrite(pins[i], LOW);
    }
}

void TickerTape7SegmentDisplay::test() {
    String testString = "abcdefghijklmnopqrstuvwxyz0123456789@. ";
    showTicker(testString, 1000);
};

void TickerTape7SegmentDisplay::showTicker(String stringTicker, int delayMicros) {
    for (int i=0; i < stringTicker.length(); i++) {
        clearDisplay();
        showChar(stringTicker.charAt(i));
        delay(delayMicros);
    }
};


TickerTape7SegmentDisplay4Digit::TickerTape7SegmentDisplay4Digit(int a, int b, int c, int d,
                                         int e, int f, int g, int dp,
                                         int d0, int d1, int d2, int d3,
                                         bool isAnode) {
    pins[0] = a;
    pins[1] = b;
    pins[2] = c;
    pins[3] = d;
    pins[4] = e;
    pins[5] = f;
    pins[6] = g;
    pins[7] = dp;
    dpins[0] = d0;
    dpins[1] = d1;
    dpins[2] = d2;
    dpins[3] = d3;
    this->isAnode = isAnode;
    setRepresentation(0,  'a', B11101110);
    setRepresentation(1,  'A', B11101110);
    setRepresentation(2,  'b', B00111110);
    setRepresentation(3,  'B', B00111110);
    setRepresentation(4,  'c', B00011010);
    setRepresentation(5,  'C', B00011010);
    setRepresentation(6,  'd', B01111010);
    setRepresentation(7,  'D', B01111010);
    setRepresentation(8,  'e', B10011110);
    setRepresentation(9,  'E', B10011110);
    setRepresentation(10, 'f', B10001110);
    setRepresentation(11, 'F', B10001110);
    setRepresentation(12, 'g', B10111100);
    setRepresentation(13, 'G', B10111100);
    setRepresentation(14, 'h', B00101110);
    setRepresentation(15, 'H', B00101110);
    setRepresentation(16, 'i', B00001100);
    setRepresentation(17, 'I', B00001100);
    setRepresentation(18, 'j', B01111000);
    setRepresentation(19, 'J', B01111000);
    setRepresentation(20, 'k', B01101110);
    setRepresentation(21, 'K', B01101110);
    setRepresentation(22, 'l', B00011100);
    setRepresentation(23, 'L', B00011100);
    setRepresentation(24, 'm', B10101010);
    setRepresentation(25, 'M', B10101010);
    setRepresentation(26, 'n', B00101010);
    setRepresentation(27, 'N', B00101010);
    setRepresentation(28, 'o', B00111010);
    setRepresentation(29, 'O', B00111010);
    setRepresentation(30, 'p', B11001110);
    setRepresentation(31, 'P', B11001110);
    setRepresentation(32, 'q', B11100110);
    setRepresentation(33, 'Q', B11100110);
    setRepresentation(34, 'r', B00001010);
    setRepresentation(35, 'R', B00001010);
    setRepresentation(36, 's', B10110100);
    setRepresentation(37, 'S', B10110100);
    setRepresentation(38, 't', B00011110);
    setRepresentation(39, 'T', B00011110);
    setRepresentation(40, 'u', B01111100);
    setRepresentation(41, 'U', B01111100);
    setRepresentation(42, 'v', B00111000);
    setRepresentation(43, 'V', B00111000);
    setRepresentation(44, 'w', B01010110);
    setRepresentation(45, 'W', B01010110);
    setRepresentation(46, 'x', B01101100);
    setRepresentation(47, 'X', B01101100);
    setRepresentation(48, 'Y', B01110110);
    setRepresentation(49, 'y', B01110110);
    setRepresentation(50, 'z', B11011000);
    setRepresentation(51, 'Z', B11011000);
    setRepresentation(52, '0', B11111100);
    setRepresentation(53, '1', B01100000);
    setRepresentation(54, '2', B11011010);
    setRepresentation(55, '3', B11110010);
    setRepresentation(56, '4', B01100110);
    setRepresentation(57, '5', B10110110);
    setRepresentation(58, '6', B10111110);
    setRepresentation(59, '7', B11100000);
    setRepresentation(60, '8', B11111110);
    setRepresentation(61, '9', B11110110);
    setRepresentation(62, '@', B11111010);
    setRepresentation(63, '.', B00000001);
    setRepresentation(64, ' ', B00000000);
    for (int i = 0; i < 8; i++) {
        pinMode(pins[i], OUTPUT);
    }
    for (int i = 0; i < 4; i++) {
        pinMode(dpins[i], OUTPUT);
    }
}

void TickerTape7SegmentDisplay4Digit::setRepresentation(int position, char ch, byte repr) {
    representationsChar[position] = ch;
    representationsByte[position] = repr;
}
   
int TickerTape7SegmentDisplay4Digit::findCharIndex(char ch) {
    for (int i=0; i<70; i++) {
        if (representationsChar[i] == ch) {
            return i;
        }
    } 
    return -1;
}

void TickerTape7SegmentDisplay4Digit::clearDisplay(){
    for (int i=0; i<8; i++) {
        digitalWrite(pins[i], LOW);
    }
    for (int i=0; i<4; i++) {
        digitalWrite(dpins[i], HIGH);
    }
}
 
void TickerTape7SegmentDisplay4Digit::showChar(char ch, int digitIdx) {
    digitalWrite(dpins[digitIdx], LOW);
    int charIndex = findCharIndex(ch);
    if (charIndex >= 0) {
        for (int i=0; i<8; i++) {
            digitalWrite(pins[i], bitRead(representationsByte[charIndex], 7-i) ? ! isAnode : isAnode);
        }
    }
}

void TickerTape7SegmentDisplay4Digit::show4Chars(char ch0, char ch1, char ch2, char ch3, int durationMicros) {
    for (int i=0; i<(durationMicros / 8); i++) {
        clearDisplay();
        showChar(ch0, 0);
        delay(2);
        clearDisplay();
        showChar(ch1, 1);
        delay(2);
        clearDisplay();
        showChar(ch2, 2);
        delay(2);
        clearDisplay();
        showChar(ch3, 3);
        delay(2);
    }
}

void TickerTape7SegmentDisplay4Digit::test() {
    String testString = "abcdefghijklmnopqrstuvwxyz0123456789@. ";
    showTicker(testString, 1000);
};

void TickerTape7SegmentDisplay4Digit::showTicker(String stringTicker, int delayMicros) {
    String padStringTicker = "   " + stringTicker + "   ";
    for (int i=0; i < padStringTicker.length() - 3; i++) {
        show4Chars(padStringTicker.charAt(i),
                   padStringTicker.charAt(i+1),
                   padStringTicker.charAt(i+2),
                   padStringTicker.charAt(i+3),
                   delayMicros);
    }
};
