# TickerTape7SegmentDisplay
Use single-digit or four-digit 7-segment display with Arduino to display arbitrary strings in ticker tape/news ticker style. Utilize a default mapping from alphanumeric characters to 7-segment display representations or configure your own.

## Manual Install
place .h and .cpp files into your `$ARDUINO_DIR/user/libraries`
```
$ tree user/libraries/TickerTape7SegmentDisplay/
user/libraries/TickerTape7SegmentDisplay/
├── TickerTape7SegmentDisplay.cpp
└── TickerTape7SegmentDisplay.h

1 directory, 2 files
```

## Install via Arduino library manager
TBD

## Sample usage with single-digit display

![Connecting one-digit display](./assets/circuit_one_digit.png)

```[c++]
#include <TickerTape7SegmentDisplay.h>

int A_pin=2, B_pin=3, C_pin=4, D_pin=5,
    E_pin=6, F_pin=7, G_pin=8, DP_pin=9;
bool isAnodeDisplay=false;

TickerTape7SegmentDisplay TT7SD(A_pin, B_pin, C_pin, D_pin,
                                E_pin, F_pin, G_pin, DP_pin,
                                isAnodeDisplay);

void setup() {
}

void loop() {
    TT7SD.clearDisplay();
    TT7SD.setRepresentation(66, '!', B01100001);
    TT7SD.showTicker("Hello world!", 1000);
    // TT7SD.test();
}

```
![One-digit display demo](./assets/circuit_one_digit_demo.gif)

## Sample usage with 4-digit display

![Connecting four-digit display](./assets/circuit_four_digit.png)

```[c++]
#include <TickerTape7SegmentDisplay.h>

int A_pin=2, B_pin=3, C_pin=4, D_pin=5,
    E_pin=6, F_pin=7, G_pin=8, DP_pin=9,
    d1=A0,   d2=A1,   d3=A2,   d4=A3;
bool isAnodeDisplay=false;

TickerTape7SegmentDisplay4Digit TT7SD4D(A_pin, B_pin, C_pin, D_pin,
                                        E_pin, F_pin, G_pin, DP_pin,
                                        d1,    d2,    d3,    d4,
                                        isAnodeDisplay);

void setup() {
}

void loop() {
    TT7SD4D.clearDisplay();
    TT7SD4D.setRepresentation(66, '!', B01100001);
    TT7SD4D.showTicker("Hello world!", 1000);
    TT7SD4D.test();
    TT7SD4D.showChar('a', 0);
    TT7SD4D.show4Chars('a', 'b', 'c', 'd', 2000);
}
```
![Four-digit display demo](./assets/circuit_four_digit_demo.gif)

## Defining your own character representations
first argument in `setRepresentation(66, '!', B01100001)` is a unique integer identifier for a character. Use 66-69 for custom mappings or 0-65 to override the default mapping for alphanumerics 
