#include <ESP32AutoTask.h>
#include <ESP32SyncKit.h>

ESP32SyncKit::BinarySemaphore startSignal;

void setup()
{
  Serial.begin(115200);
  ESP32AutoTask::AutoTask.begin();
}

// en: Producer gives every 500 ms (if semaphore already given, give may fail)
// ja: 送信側は 500 ms ごとに give（セマフォ保持中は give 失敗する）
void LoopCore0_Normal()
{
  if (!startSignal.give())
  {
    // en: skip if already given; Binary semaphore caps at 1
    // ja: すでに保持されている場合はスキップ（バイナリは最大1）
  }
  delay(500);
}

// en: Consumer waits, prints on each take, then waits again
// ja: 受信側は take できたら出力し、再び待つ
void LoopCore1_Normal()
{
  if (startSignal.take())
  {
    Serial.printf("[BinarySemaphore] core=%d, millis=%lu take!\n", xPortGetCoreID(), static_cast<unsigned long>(millis()));
  }
}

void loop()
{
  delay(1);
}
