#include <DCF77FreeRTOS.h>

#ifndef LED_BUILTIN
#define LED_BUILTIN 2
#endif

// Create DCF77 receiver instance
// Parameters: input pin, debug flag (DCF_DEBUG / DCF_NODEBUG)
DCF77FreeRTOS receiver(26, DCF_NODEBUG);

void setup() {
  Serial.begin(115200);
  delay(100);  // give serial time to initialize
  Serial.println("DCF77FreeRTOS Basic Demo starting...");

  receiver.begin(LED_BUILTIN);  // optional LED pin
}

void loop() {
  DCFtime t;
  if (receiver.getTime(&t)) {
    Serial.printf(
      "DCF time: %02u-%02u-%02u %02u:%02u (dow=%u)\n",
      t.year, t.month, t.day, t.hour, t.minute, t.dow
    );
  }

  Serial.printf("Status: %d\n", receiver.getStatus());
  delay(1000);
}
