/**
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2022 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */

#ifndef ISPU_CONF_H
#define ISPU_CONF_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>

#ifndef MEMS_UCF_EXT_SHARED_TYPES
#define MEMS_UCF_EXT_SHARED_TYPES

/*
 * UCF extended format supports the following commands:
 * - MEMS_UCF_OP_READ: read the register at the location specified by the
 *   "address" field ("data" field is ignored
 * - MEMS_UCF_OP_WRITE: write the value specified by the "data" field at the
 *   location specified by the "address" field
 * - MEMS_UCF_OP_DELAY: wait the number of milliseconds specified by the "data"
 *   field ("address" field is ignored)
 * - MEMS_UCF_OP_POLL_SET: poll the register at the location specified by the
 *   "address" field until all the bits identified by the mask specified by the
 *   "data" field are set to 1
 * - MEMS_UCF_OP_POLL_RESET: poll the register at the location specified by the
 *   "address" field until all the bits identified by the mask specified by the
 *   "data" field are reset to 0
 */

#define MEMS_UCF_OP_READ       0
#define MEMS_UCF_OP_WRITE      1
#define MEMS_UCF_OP_DELAY      2
#define MEMS_UCF_OP_POLL_SET   3
#define MEMS_UCF_OP_POLL_RESET 4

typedef struct {
  uint8_t op;
  uint8_t address;
  uint8_t data;
} ucf_line_ext_t;

#endif /* MEMS_UCF_EXT_SHARED_TYPES */

static const ucf_line_ext_t ispu_conf[] = {
  { .op = MEMS_UCF_OP_WRITE, .address = 0x01, .data = 0x02 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x01, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x01, .data = 0x80 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x08, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x09, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0A, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x02 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x3F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x3E },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x20 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x3F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x80 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0D },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x08, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x09, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0A, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x90 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x60 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAE },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x20 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x37 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x47 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x57 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x67 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x77 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x87 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x97 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xE7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAE },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x88 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA6 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x28 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA6 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x28 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAE },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA6 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA6 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x88 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x09 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x20 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAE },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x02 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x24 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA6 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x88 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x48 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x02 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x18 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x02 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x80 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFE },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0E },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xED },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x1F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x2F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x3F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x02 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x3F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x2F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x1F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x1F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x2F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x3F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xBF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xCF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xCF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x81 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x80 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x68 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x09 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0A },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x4F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x40 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDA },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x39 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x81 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x84 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x68 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x09 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0A },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x4F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x40 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDA },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x39 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xBF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0A },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x81 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x88 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x68 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x09 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0A },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x14 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x4F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x40 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDA },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x39 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x1C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x44 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x03 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x93 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x68 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0A },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x93 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x14 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x68 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x93 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x18 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x68 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x90 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x1C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x68 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x83 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x88 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xCF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x67 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xBF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x93 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x88 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x3F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x2F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x1F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x38 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x58 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x68 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x6F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x28 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x5C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x68 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x7F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x75 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x81 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x98 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x54 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x68 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x50 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x68 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xBF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x70 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x68 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xCF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x80 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x68 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x64 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x68 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x90 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x68 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x90 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x68 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x02 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x80 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x93 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x88 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x13 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x82 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x98 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x13 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFE },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x6A },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x50 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x83 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x88 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x65 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x53 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x23 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x63 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x68 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x1F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x69 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x50 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x83 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x88 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x65 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x53 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x67 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x02 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x67 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x60 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x60 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x83 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x88 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x63 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x02 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x98 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x90 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x80 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x4C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x69 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x24 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x24 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x90 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x80 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x4C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x69 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x05 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x90 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x80 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x4C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x69 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x7B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x12 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x90 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x58 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x05 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x90 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x03 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x14 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x23 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x98 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x03 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x05 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x80 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD1 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x14 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x24 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0E },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xED },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xCF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x80 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0A },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x05 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x12 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x54 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x09 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x03 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xCF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0E },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xED },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x11 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x54 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x03 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x05 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF5 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x54 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x03 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEE },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x28 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x24 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAE },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x48 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0E },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xED },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x6F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x7F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xBF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xCF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC6 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x88 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x18 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x03 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x02 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD6 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x90 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xE0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x13 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAE },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xE8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x11 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x88 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x18 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x14 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0A },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x11 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x89 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x1B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x55 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x1A },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x99 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x15 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x20 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x28 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x14 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x88 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0E },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x02 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD6 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC1 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x20 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x28 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x14 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0D },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x22 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x88 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x28 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x02 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD6 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC1 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x1A },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x99 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x7B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x20 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x12 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x24 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x31 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x22 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAE },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xE4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x30 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x93 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x21 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x20 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x28 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x14 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x16 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x30 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x22 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x88 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x38 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x14 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x14 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x20 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x90 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x20 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x28 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x14 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x18 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x33 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x89 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x22 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x30 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x91 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x20 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x93 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x20 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x28 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x14 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x1C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x18 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x14 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x1B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x22 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x88 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x37 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x20 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x90 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x20 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x21 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x31 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x98 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x22 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x89 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x20 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x91 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x20 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x28 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x14 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x1D },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x22 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x88 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x25 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x02 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD6 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x20 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x90 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF9 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x03 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x26 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x21 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x98 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x20 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x28 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x14 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x1E },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x22 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x88 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x25 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x02 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD6 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x20 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x90 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFA },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x03 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x25 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x21 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x98 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x20 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x28 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x14 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x1F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x22 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x88 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x25 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x02 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD6 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x20 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x90 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x28 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x03 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x21 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x98 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x18 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x14 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x22 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x21 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x88 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x25 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x02 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD6 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAE },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFE },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x21 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x98 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x20 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x28 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x14 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x23 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x15 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x22 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x88 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x25 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x21 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x98 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x1E },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD6 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAE },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x03 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x21 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x97 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x93 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x23 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x39 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x98 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x93 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x19 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x61 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB6 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x14 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x96 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x3B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x32 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF6 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x97 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x72 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x87 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x3B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x22 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x86 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x91 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x23 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x13 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x78 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x68 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xE2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD1 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x28 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x24 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAE },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x48 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xCF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xBF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x7F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x6F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0E },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xED },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAE },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xCF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAE },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x03 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x90 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x28 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x70 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x1C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x14 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x42 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x98 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x99 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x93 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xCF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0E },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xED },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAE },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x90 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x6F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x37 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x7F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xBF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xCF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x80 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x20 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x23 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x13 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x91 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x21 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x2B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x2A },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB1 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x81 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA1 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB1 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x28 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x4F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x3F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x98 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x14 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x18 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x88 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x14 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x14 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x24 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x14 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x30 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x25 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x79 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x78 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8A },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x89 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9A },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x2B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x34 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x38 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x14 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x1A },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x90 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xCF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xBF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x7F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x6F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0E },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xED },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x28 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x29 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x2A },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x80 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xE0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0A },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x14 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x03 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x70 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAE },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x13 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xBA },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x90 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0A },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x13 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x14 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x80 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x18 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x09 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x09 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x90 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDA },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x13 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x09 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x09 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x87 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDA },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x83 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xE4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x09 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x09 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x09 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x77 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x18 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x1F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA1 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x18 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x09 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x09 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x79 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x13 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x09 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x09 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x70 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x83 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xE4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x18 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x80 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x09 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x09 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x18 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x1F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x80 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x81 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x90 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAE },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xCC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB1 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x69 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x89 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x13 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x66 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x11 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xBB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x70 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x83 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x69 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x99 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x09 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0A },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x18 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x80 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x09 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x03 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x66 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x65 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x69 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x99 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x70 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x83 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x09 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x43 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x18 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x80 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x09 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x09 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x77 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x18 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x1F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x20 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAE },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xCE },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x32 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x72 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x88 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x12 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x38 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x14 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0A },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB6 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x78 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x14 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x4B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x2C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB5 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x6B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x03 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x86 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x88 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x03 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x89 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x09 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x81 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA1 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x05 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x80 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x98 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x09 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA5 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x03 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x15 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x03 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x99 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x52 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD1 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x09 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x18 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF9 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC1 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x88 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x49 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD1 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xBB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x64 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x80 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x44 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x83 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xCA },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x60 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD1 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x09 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x89 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x20 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x81 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xE8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x02 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x51 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA5 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x29 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAE },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x20 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x98 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0A },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x20 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x99 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x80 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x02 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC5 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC1 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x98 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xCB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x26 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF1 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x02 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x05 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x80 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x20 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x89 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xBB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x2B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA1 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0A },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD6 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x80 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x03 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x09 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x03 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x99 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x98 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x05 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x80 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB9 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x87 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x09 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x80 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB6 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x05 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x20 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x99 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x05 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x26 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x15 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x20 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x99 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9A },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x15 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x80 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF1 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x89 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xBB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA1 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x15 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD6 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x80 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x23 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0A },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0E },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB1 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x99 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x90 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD6 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x02 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x14 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x99 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x03 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x02 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x98 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x7F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x15 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x99 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x7C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB5 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x90 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x80 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x89 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x99 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA9 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA1 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x28 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD6 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x03 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x89 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x90 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x81 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x90 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA1 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x28 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x14 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0D },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD6 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x92 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x88 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x80 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x90 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x03 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x02 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x98 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x02 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x88 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x14 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x02 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x98 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x23 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x99 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x20 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x80 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFE },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x05 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x20 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x80 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x02 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x98 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x21 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x98 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x90 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x98 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x82 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x88 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x14 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x98 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x89 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x97 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA5 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x99 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x15 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x98 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x99 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA6 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x15 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x99 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x42 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x23 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x88 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x80 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x11 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x19 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x15 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x92 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x98 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x18 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x99 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xE1 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x80 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x03 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x09 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x03 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x99 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x98 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xE8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x20 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x31 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xBF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xCF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC1 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x2F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xCF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x3F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x26 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x36 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x57 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x7F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAE },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x18 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x57 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x7F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x29 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0E },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x33 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x39 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x19 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x33 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC6 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x36 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x37 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x03 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x34 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x22 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x16 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x1F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xCF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xBF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0E },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xED },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x31 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC6 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD1 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC1 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xE9 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x22 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x33 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x32 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x21 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDA },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x23 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x05 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDA },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x1B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x1D },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD6 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB1 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x13 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xE3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x09 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xE1 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x19 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x39 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xE5 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD1 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x37 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD6 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD5 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xCA },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xCF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xBF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0E },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xED },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xE7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0A },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC5 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x20 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x31 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xBF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xCF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC1 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x2F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xCF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x3F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x26 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x36 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x57 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x7F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAE },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x18 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x57 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x7F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x29 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0E },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x11 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x39 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x13 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x3F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC6 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x42 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x37 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x14 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x12 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x14 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x19 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x15 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x39 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x2F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x11 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC6 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x32 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x1B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x05 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x09 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x03 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x05 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xCF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xBF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0E },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xED },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x22 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x33 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x32 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x1D },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDA },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x23 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x05 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDA },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x1B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x19 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD6 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB1 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD6 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD5 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEA },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD1 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xCF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xBF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0E },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xED },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x37 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD9 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDA },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x37 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xBF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD1 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD1 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC1 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xCF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD6 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xBF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xCF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x1D },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xBC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x1F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x2C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDA },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x18 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9E },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x23 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x18 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x97 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x26 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x09 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x03 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDA },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x57 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x7F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x03 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC1 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xCF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC6 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x57 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x7F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x2B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x63 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x18 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x1F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xCF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x21 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x02 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x63 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xBF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0E },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xED },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x23 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x18 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9A },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDA },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x20 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x28 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x14 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x1B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x3C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x32 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x23 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x23 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x23 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x63 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x38 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x05 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x30 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x23 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x2F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x2E },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x63 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDA },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x20 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x28 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x3C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x2C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x38 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x54 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x37 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x28 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x57 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x12 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC8 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x54 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0E },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x24 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x32 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x38 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x57 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x37 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x18 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x28 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x57 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x23 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x02 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x02 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x57 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x7F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x1B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0D },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD6 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x28 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x18 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x88 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x11 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x02 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x23 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0E },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xED },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x21 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x88 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x11 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x02 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x23 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0E },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xED },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0D },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD6 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x23 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x88 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x11 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x02 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x23 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0E },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xED },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0F },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x22 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x88 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x11 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x02 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x23 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0E },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xED },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAE },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xCF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x83 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0D },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x18 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x14 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x28 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x11 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA7 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x02 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0D },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x80 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x37 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xBF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x27 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xCF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x23 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xCF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xBF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF4 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0E },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xED },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB1 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xB3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x13 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xC3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x13 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xBB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x88 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x36 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x17 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xBC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x98 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x30 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAB },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x20 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x13 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x32 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xA3 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x02 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xD2 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0E },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xED },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x13 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xFC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDD },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x36 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xAF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x26 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x9B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x98 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0C },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xEF },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x8B },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xF0 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x16 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xDC },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x0E },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0xED },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x02 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x02 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x03 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x03 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x03 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x03 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x04 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x05 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x05 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x05 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x05 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x05 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x05 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x05 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x05 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x05 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x05 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x05 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x05 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x05 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x05 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x05 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x05 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x06 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x07 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x08 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x28 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x43 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0B, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x01, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x18, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x19, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x10, .data = 0x10 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x01, .data = 0x80 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x02, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x01, .data = 0x00 },
  { .op = MEMS_UCF_OP_DELAY, .address = 0, .data = 5 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x10, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x11, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x0E, .data = 0x80 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x15, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x18, .data = 0x60 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x5E, .data = 0x02 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x01, .data = 0x80 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x02, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x50, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x70, .data = 0x01 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x01, .data = 0x00 },
  { .op = MEMS_UCF_OP_WRITE, .address = 0x10, .data = 0x64 }
};

#ifdef __cplusplus
}
#endif

#endif

