/**
 ******************************************************************************
 * @file    vl53l7cx_plugin_xtalk.h
 * @author  STMicroelectronics
 * @version V1.0.0
 * @date    13 January 2023
 * @brief   Header file for the VL53L7CX xtalk structures.
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2021 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
 */

#ifndef VL53L7CX_PLUGIN_XTALK_H_
#define VL53L7CX_PLUGIN_XTALK_H_

#include "vl53l7cx_class.h"

/**
 * @brief Inner internal number of targets.
 */

#if VL53L7CX_NB_TARGET_PER_ZONE == 1
  #define VL53L7CX_FW_NBTAR_XTALK 2
#else
  #define VL53L7CX_FW_NBTAR_XTALK VL53L7CX_NB_TARGET_PER_ZONE
#endif

/**
 * @brief Inner Macro for plugin. Not for user, only for development.
 */

#define VL53L7CX_DCI_CAL_CFG        ((uint16_t)0x5470U)
#define VL53L7CX_DCI_XTALK_CFG        ((uint16_t)0xAD94U)

/**
 * @brief Command used to get Xtalk calibration data
 */

static const uint8_t VL53L7CX_GET_XTALK_CMD[] = {
  0x54, 0x00, 0x00, 0x40,
  0x9F, 0xD8, 0x00, 0xC0,
  0x9F, 0xE4, 0x01, 0x40,
  0x9F, 0xF8, 0x00, 0x40,
  0x9F, 0xFC, 0x04, 0x04,
  0xA0, 0xFC, 0x01, 0x00,
  0xA1, 0x0C, 0x01, 0x00,
  0xA1, 0x1C, 0x00, 0xC0,
  0xA1, 0x28, 0x09, 0x02,
  0xA2, 0x48, 0x00, 0x40,
  0xA2, 0x4C, 0x00, 0x81,
  0xA2, 0x54, 0x00, 0x81,
  0xA2, 0x5C, 0x00, 0x81,
  0xA2, 0x64, 0x00, 0x81,
  0xA2, 0x6C, 0x00, 0x84,
  0xA2, 0x8C, 0x00, 0x82,
  0x00, 0x00, 0x00, 0x0F,
  0x07, 0x02, 0x00, 0x44
};

/**
 * @brief Command used to get run Xtalk calibration
 */

static const uint8_t VL53L7CX_CALIBRATE_XTALK[] = {
  0x54, 0x50, 0x00, 0x80,
  0x00, 0x04, 0x08, 0x08,
  0x00, 0x00, 0x04, 0x04,
  0xAD, 0x30, 0x00, 0x80,
  0x03, 0x01, 0x06, 0x03,
  0x00, 0x00, 0x01, 0x00,
  0xAD, 0x38, 0x01, 0x00,
  0x01, 0xE0, 0x01, 0x40,
  0x00, 0x10, 0x00, 0x10,
  0x01, 0x00, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x01,
  0x54, 0x58, 0x00, 0x40,
  0x04, 0x1A, 0x02, 0x00,
  0x54, 0x5C, 0x01, 0x40,
  0x00, 0x01, 0x00, 0x51,
  0x00, 0x00, 0x0F, 0xA0,
  0x0F, 0xA0, 0x03, 0xE8,
  0x02, 0x80, 0x1F, 0x40,
  0x00, 0x00, 0x05, 0x00,
  0x54, 0x70, 0x00, 0x80,
  0x03, 0x20, 0x03, 0x20,
  0x00, 0x00, 0x00, 0x08,
  0x54, 0x78, 0x01, 0x00,
  0x01, 0x1B, 0x00, 0x21,
  0x00, 0x33, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x01,
  0x04, 0x01, 0x08, VL53L7CX_FW_NBTAR_XTALK,
  0x54, 0x88, 0x01, 0x40,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x08, 0x00,
  0xAD, 0x48, 0x01, 0x00,
  0x01, 0xF4, 0x00, 0x00,
  0x03, 0x06, 0x00, 0x10,
  0x08, 0x08, 0x08, 0x08,
  0x00, 0x00, 0x00, 0x08,
  0xAD, 0x60, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x80,
  0x00, 0x00, 0x00, 0x00,
  0x20, 0x1F, 0x01, 0xF4,
  0x00, 0x00, 0x1D, 0x0A,
  0xAD, 0x70, 0x00, 0x80,
  0x08, 0x00, 0x1F, 0x40,
  0x00, 0x00, 0x00, 0x01,
  0xAD, 0x78, 0x00, 0x80,
  0x00, 0xA0, 0x03, 0x20,
  0x00, 0x01, 0x01, 0x90,
  0xAD, 0x80, 0x00, 0x40,
  0x00, 0x00, 0x28, 0x00,
  0xAD, 0x84, 0x00, 0x80,
  0x00, 0x00, 0x32, 0x00,
  0x03, 0x20, 0x00, 0x00,
  0xAD, 0x8C, 0x00, 0x80,
  0x02, 0x58, 0xFF, 0x38,
  0x00, 0x00, 0x00, 0x0C,
  0xAD, 0x94, 0x01, 0x00,
  0x00, 0x01, 0x90, 0x00,
  0xFF, 0xFF, 0xFC, 0x00,
  0x00, 0x00, 0x04, 0x00,
  0x00, 0x00, 0x01, 0x00,
  0xAD, 0xA4, 0x00, 0xC0,
  0x04, 0x80, 0x06, 0x1A,
  0x00, 0x80, 0x05, 0x80,
  0x00, 0x00, 0x01, 0x06,
  0xAD, 0xB0, 0x00, 0xC0,
  0x04, 0x80, 0x06, 0x1A,
  0x19, 0x00, 0x05, 0x80,
  0x00, 0x00, 0x01, 0x90,
  0xAD, 0xBC, 0x04, 0x40,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x12, 0x00, 0x25,
  0x00, 0x00, 0x00, 0x06,
  0x00, 0x00, 0x00, 0x05,
  0x00, 0x00, 0x00, 0x05,
  0x00, 0x00, 0x00, 0x06,
  0x00, 0x00, 0x00, 0x04,
  0x00, 0x00, 0x00, 0x0F,
  0x00, 0x00, 0x00, 0x5A,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x09,
  0x0B, 0x0C, 0x0B, 0x0B,
  0x03, 0x03, 0x11, 0x05,
  0x01, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x0D, 0x00, 0x00,
  0xAE, 0x00, 0x01, 0x04,
  0x00, 0x00, 0x00, 0x04,
  0x00, 0x00, 0x00, 0x08,
  0x00, 0x00, 0x00, 0x0A,
  0x00, 0x00, 0x00, 0x0C,
  0x00, 0x00, 0x00, 0x0D,
  0x00, 0x00, 0x00, 0x0E,
  0x00, 0x00, 0x00, 0x08,
  0x00, 0x00, 0x00, 0x08,
  0x00, 0x00, 0x00, 0x10,
  0x00, 0x00, 0x00, 0x10,
  0x00, 0x00, 0x00, 0x20,
  0x00, 0x00, 0x00, 0x20,
  0x00, 0x00, 0x00, 0x06,
  0x00, 0x00, 0x05, 0x0A,
  0x02, 0x00, 0x0C, 0x08,
  0x00, 0x00, 0x00, 0x00,
  0xAE, 0x40, 0x00, 0x40,
  0x00, 0x00, 0x00, 0xFF,
  0xAE, 0x44, 0x00, 0x40,
  0x00, 0x10, 0x04, 0x01,
  0xAE, 0x48, 0x00, 0x40,
  0x00, 0x00, 0x10, 0x00,
  0xAE, 0x4C, 0x00, 0x40,
  0x00, 0x00, 0x00, 0x01,
  0xAE, 0x50, 0x01, 0x40,
  0x00, 0x00, 0x00, 0x14,
  0x04, 0x00, 0x28, 0x00,
  0x03, 0x20, 0x6C, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0xAE, 0x64, 0x00, 0x40,
  0x00, 0x00, 0x00, 0x01,
  0xAE, 0xD8, 0x01, 0x00,
  0x00, 0xC8, 0x05, 0xDC,
  0x00, 0x00, 0x0C, 0xCD,
  0x01, 0x04, 0x00, 0x00,
  0x00, 0x01, 0x26, 0x01,
  0xB5, 0x50, 0x02, 0x82,
  0xA3, 0xE8, 0xA3, 0xB8,
  0xA4, 0x38, 0xA4, 0x28,
  0xA6, 0x48, 0xA4, 0x48,
  0xA7, 0x88, 0xA7, 0x48,
  0xAC, 0x10, 0xA7, 0x90,
  0x99, 0xBC, 0x99, 0xB4,
  0x9A, 0xFC, 0x9A, 0xBC,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0xB5, 0xA0, 0x02, 0x82,
  0x00, 0x88, 0x03, 0x00,
  0x00, 0x82, 0x00, 0x82,
  0x04, 0x04, 0x04, 0x08,
  0x00, 0x80, 0x04, 0x01,
  0x09, 0x02, 0x09, 0x08,
  0x04, 0x04, 0x00, 0x80,
  0x04, 0x01, 0x04, 0x01,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0xB5, 0xF0, 0x00, 0x40,
  0x00, 0x04, 0x00, 0x00,
  0xB3, 0x9C, 0x01, 0x00,
  0x40, 0x00, 0x05, 0x1E,
  0x02, 0x1B, 0x08, 0x7C,
  0x80, 0x01, 0x12, 0x01,
  0x00, 0x00, 0x08, 0x00,
  0xB6, 0xC0, 0x00, 0xC0,
  0x00, 0x00, 0x60, 0x00,
  0x00, 0x00, 0x20, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0xAE, 0xA8, 0x00, 0x40,
  0x00, 0x00, 0x04, 0x05,
  0xAE, 0xAC, 0x00, 0x80,
  0x01, 0x00, 0x01, 0x00,
  0x00, 0x02, 0x00, 0x00,
  0xAE, 0xB4, 0x00, 0x40,
  0x00, 0x00, 0x00, 0x00,
  0xAE, 0xB8, 0x00, 0x81,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0xAE, 0xC0, 0x00, 0x81,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0xAE, 0xC8, 0x00, 0x81,
  0x08, 0x01, 0x01, 0x08,
  0x00, 0x00, 0x00, 0x08,
  0xAE, 0xD0, 0x00, 0x81,
  0x01, 0x08, 0x08, 0x08,
  0x00, 0x00, 0x00, 0x01,
  0xB5, 0xF4, 0x00, 0x80,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0xB5, 0xFC, 0x00, 0x80,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0xB6, 0x04, 0x00, 0x40,
  0x00, 0x00, 0x00, 0x00,
  0xB6, 0x08, 0x00, 0x44,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0xB6, 0x18, 0x00, 0x44,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0xB6, 0x28, 0x00, 0x44,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0xB6, 0x38, 0x00, 0x44,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0xB6, 0x48, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0xB6, 0x58, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0xB6, 0x68, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x54, 0x70, 0x00, 0x80,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x02,
  0x00, 0x00, 0x00, 0x0F,
  0x00, 0x01, 0x03, 0xD4
};

#endif /* VL53L7CX_PLUGIN_XTALK_H_ */
