/******************************************************************************
  * \attention
  *
  * <h2><center>&copy; COPYRIGHT 2021 STMicroelectronics</center></h2>
  *
  * Licensed under ST MIX MYLIBERTY SOFTWARE LICENSE AGREEMENT (the "License");
  * You may not use this file except in compliance with the License.
  * You may obtain a copy of the License at:
  *
  *        www.st.com/mix_myliberty
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an "AS IS" BASIS,
  * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied,
  * AND SPECIFICALLY DISCLAIMING THE IMPLIED WARRANTIES OF MERCHANTABILITY,
  * FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
******************************************************************************/

/*! \file
 *
 *  \author SRA
 *
 *  \brief ST25R95 declaration file
 *
 * API:
 * - Initialize ST25R95 driver: #st25r95Initialize
 * - Deinitialize ST25R95 driver: #st25r95Deinitialize
 *
 *
 * \addtogroup RFAL
 * @{
 *
 * \addtogroup RFAL-HAL
 * \brief RFAL Hardware Abstraction Layer
 * @{
 *
 * \addtogroup ST25R95
 * \brief RFAL ST25R95 Driver
 * @{
 *
 * \addtogroup ST25R95_Driver
 * \brief RFAL ST25R95 Driver
 * @{
 *
 */

#ifndef ST25R95_H
#define ST25R95_H

/*
******************************************************************************
* INCLUDES
******************************************************************************
*/
#include "st_errno.h"
#include "st25r95_com.h"

/*
******************************************************************************
* GLOBAL DATATYPES
******************************************************************************
*/

/*
******************************************************************************
* GLOBAL DEFINES
******************************************************************************
*/

/*
******************************************************************************
* GLOBAL MACROS
******************************************************************************
*/

/*
******************************************************************************
* GLOBAL FUNCTION PROTOTYPES
******************************************************************************
*/


#endif /* ST25R95_H */

/**
  * @}
  *
  * @}
  *
  * @}
  *
  * @}
  */

