#include "SBLC_Motors.h"

void Motor::begin(void)
{
  pinMode(_Channel1, OUTPUT);
  pinMode(_Channel2, OUTPUT);
  setSpeed(0);
}

void Motor::setSpeed(int speed)
{
  _speed = speed;
  if(_speed > 0)
  {
    _dir = CW;
    analogWrite(_Channel1, _speed);
    analogWrite(_Channel2, 0);
  }
  else if(_speed < 0) 
  {
    _dir = CCW;
    analogWrite(_Channel1, 0);
    analogWrite(_Channel2, abs(_speed));
  }
  else
  {
    _dir = STOP;
    analogWrite(_Channel1, 0);
    analogWrite(_Channel2, 0);
  }
}

void Motor::getSpeed(void)
{
  String dir_str;
  if(_dir == 1) dir_str = "CW";
  else if(_dir == 2) dir_str = "CCW";
  else dir_str = "STOP";
  char str[50];
  sprintf("| MOTOR %d | SPEED: %d | DIR: %s", _motorNum, _speed, dir_str);
  Serial.print("Speed: ");
}

