// Example for ST7656DOG

#include <ST7565DOG.h>
#include <fonts/Small_7.h>
#include <fonts/ArialR12x14.h>

// DOGM132x-5, DOGM128x-6, DOGL128x6 Single Supply
// Pins for Rasberry Pi Pico(2), SPI0

// DOG Pin   Purpose   Pico Pin
// 40        CS        17 (SPI0 CSn)
// 39        RST       21
// 38        A0        20
// 37        SCL       18 (SPI0 SCK)
// 36        SI        19 (SPI0 Tx)
// 35        VDD       3.3V
// 34        VDD2      3.3V
// 33        VSS       GND
// 32        VOUT      1uF -> GND
// 31        CAP3P     1uF -> CAP1N
// 30        CAP1N     1uF -> CAP1P
// 29        CAP1P
// 28        CAP2P     1uF -> CAP2N
// 27        CAP2N
// 26        VSS       GND
// 25        V4        1uF -> GND
// 24        V3        1uF -> GND
// 23        V2        1uF -> GND
// 22        V1        1uF -> GND
// 21        V0        1uF -> GND

#define CS 17
#define A_0 20
#define RESET 21

ST7565DOG lcd(RESET, A_0, CS);

void exampleDOGx128();
void exampleDOGM132();

void setup() {
	lcd.begin(DOGM132); // for DOGM132
	// lcd.begin(DOGM128); // for DOGM128
	// lcd.begin(DOGL128); // for DOGL128
	exampleDOGM132(); // for DOGM132
	// exampleDOGx128(); // for DOGx128
	lcd.display(OFF);          // display off
	delay(1000);
	lcd.display(ON);           // display on
	delay(1000);
	}

void loop() {
	lcd.display(INVERT); // display inverted
	delay(1000);
	lcd.display(DEFAULT); // display normal
	delay(1000);
	lcd.display(VIEW_TOP); // display rotated
	delay(1000);
	lcd.display(VIEW_BOTTOM); // display normal orientation
	delay(1000);
	}

void exampleDOGM132() {
	lcd.rectangle(0, 0, 131, 31);
	lcd.rectangleFill(2, 2, 4, 4);
	lcd.rectangleFill(2, 27, 4, 29);
	lcd.rectangleFill(61, 2, 63, 4);
	lcd.rectangleFill(61, 27, 63, 29);
	lcd.line(65, 0, 65, 31);
	lcd.ellipse(33, 15, 20, 10);
	lcd.circle(33, 15, 6);
	lcd.circleFill(33, 15, 3);
	lcd.locate(70, 1);
	lcd.font((uint8_t*)ArialR12x14);
	lcd.printf("Arduino");
	lcd.locate(70, 13);
	lcd.font((uint8_t*)Small_7);
	lcd.printf("EA");
	lcd.locate(70, 22);
 	lcd.printf("DOGM132");
	delay(1000);
	for (uint8_t i = 0; i <= 64; i++) {
		lcd.display(CONTRAST, i);
		delay(50);
		}
	lcd.display(CONTRAST);     // contrast default
	delay(1000);
	}

void exampleDOGx128() {
	lcd.rectangle(0, 0, 127, 63);
	lcd.rectangleFill(2, 2, 4, 4);
	lcd.rectangleFill(2, 59, 4, 61);
	lcd.rectangleFill(61, 2, 63, 4);
	lcd.rectangleFill(61, 59, 63, 61);
	lcd.line(65, 0, 65, 63);
	lcd.ellipse(33, 31, 20, 10);
	lcd.circle(33, 31, 6);
	lcd.circleFill(33, 31, 3);
	lcd.locate(70, 1);
	lcd.font((uint8_t*)ArialR12x14);
	lcd.printf("Arduino");
	lcd.locate(70, 43);
	lcd.font((uint8_t*)Small_7);
	lcd.printf("EA");
	lcd.locate(70, 52);
 	lcd.printf("DOGM128");
	delay(1000);
	}