# How to Contribute

Thank you so *much* for offering to help out. We truly appreciate it.

If you'd like to contribute, start by searching through the [issues](https://github.com/sparkfun/SparkFun_Weather_Meter_Kit_Arduino_Library/issues) and [pull requests](https://github.com/sparkfun/SparkFun_Weather_Meter_Kit_Arduino_Library/pulls) to see whether someone else has raised a similar idea or question.
Please check the [closed issues](https://github.com/sparkfun/SparkFun_Weather_Meter_Kit_Arduino_Library/issues?q=is%3Aissue+is%3Aclosed)
and [closed pull requests](https://github.com/sparkfun/SparkFun_Weather_Meter_Kit_Arduino_Library/pulls?q=is%3Apr+is%3Aclosed) too - you may find that your issue or feature has already been discussed.

If you decide to add a feature to this library, please create a PR and follow these best practices:

* Change as little as possible. Do not submit a PR that changes 100 lines of whitespace. Break up into multiple PRs if necessary.
* If you've added a new feature document it with a simple example sketch. This serves both as a test of your PR and as a quick way for users to quickly learn how to use your new feature.
* If you add new functions also add them to _keywords.txt_ so that they are properly highlighted in Arduino. [Read more](https://www.arduino.cc/en/Hacking/libraryTutorial).
* **Important:** Please submit your PR using the [release_candidate branch](https://github.com/sparkfun/SparkFun_Weather_Meter_Kit_Arduino_Library/tree/release_candidate). That way, we can merge and test your PR quickly without changing the _master_ branch

![Contributing.JPG](https://github.com/sparkfun/SparkFun_ICM-20948_ArduinoLibrary/blob/main/img/Contributing.JPG)

## Style guide

Please read and follow the [Arduino API style guide](https://www.arduino.cc/en/Reference/APIStyleGuide). Also read and consider the [Arduino style guide](https://www.arduino.cc/en/Reference/StyleGuide).
