/*
  Read the 18 channels of spectral light over I2C using the Spectral Triad
  By: Nathan Seidle
  SparkFun Electronics
  Date: October 25th, 2018
  License: MIT. See license file for more information but you can
  basically do whatever you want with this code.

  This example shows how to read the temperature of the ICs
  
  Feel like supporting open source hardware?
  Buy a board from SparkFun! https://www.sparkfun.com/products/15050

  Hardware Connections:
  Plug a Qwiic cable into the Spectral Triad and a BlackBoard
  If you don't have a platform with a Qwiic connection use the SparkFun Qwiic Breadboard Jumper (https://www.sparkfun.com/products/14425)
  Open the serial monitor at 115200 baud to see the output
*/

#include "SparkFun_AS7265X.h" //Click here to get the library: http://librarymanager/All#SparkFun_AS7265X
AS7265X sensor;

#include <Wire.h>

void setup()
{
  Serial.begin(115200);
  Serial.println("AS7265x Spectral Triad Example");

  if (sensor.begin() == false)
  {
    Serial.println("Sensor does not appear to be connected. Please check wiring. Freezing...");
    while (1)
      ;
  }

  //Once the sensor is started we can increase the I2C speed
  Wire.setClock(400000);

  int oneSensorTemp = sensor.getTemperature(); //Returns the temperature of master IC
  Serial.print("Main IC temp: ");
  Serial.println(oneSensorTemp);

  float threeSensorTemp = sensor.getTemperatureAverage(); //Returns the average temperature of all three ICs
  Serial.print("Average IC temp: ");
  Serial.println(threeSensorTemp, 2);
}

void loop()
{
  //Do nothing
}
