
![SparkFun Qwiic Soil Moisture Sensor](docs/images/gh-banner-2025-soil-moisture.png "SparkFun Qwiic Soil Moisture Sensor")

# SparkFun Qwiic Soil Moisture Sensor

Arduino Library for the SparkFun Qwiic Soil Moisture Sensor

![License](https://img.shields.io/github/license/sparkfun/SparkFun_Soil_Moisture_Arduino_Library)
![Release](https://img.shields.io/github/v/release/sparkfun/SparkFun_Soil_Moisture_Arduino_Library)
![Release Date](https://img.shields.io/github/release-date/sparkfun/SparkFun_Soil_Moisture_Arduino_Library)
![Documentation - build](https://img.shields.io/github/actions/workflow/status/sparkfun/SparkFun_Soil_Moisture_Arduino_Library/build-deploy-ghpages.yml)
![GitHub issues](https://img.shields.io/github/issues/sparkfun/SparkFun_Soil_Moisture_Arduino_Library)


The [SparkFun Qwiic Soil Moisture Sensor (SEN-17731)](https://www.sparkfun.com/sparkfun-qwiic-soil-moisture-sensor.html) is a simple breakout for measuring the moisture in soil and similar materials. The soil moisture sensor is pretty straightforward to use. The two large, exposed pads function as probes for the sensor, together acting as a variable resistor. The more water that is in the soil means the better the conductivity between the pads will be, resulting in a lower resistance and a higher SIG out. 

Looking for the board that matches this library - pick up a [SparkFun Qwiic Soil Moisture Sensor (SEN-17731)](https://www.sparkfun.com/sparkfun-qwiic-soil-moisture-sensor.html) at www.sparkfun.com.

## Functionality

This library provides a simple interface that enables the following functionality when using the SparkFun Qwiic Soil Moisture Sensor:

* Read the current resistance (moisture) value from the sensor
* Turn the on-board LED on and off
* Change the I2C address of the sensor - if you want to avoid a conflict, or used multiple moisture sensors together. 

## Documentation

The full API and use documentation for this library is provided [here](docs.sparkfun.com/SparkFun_Soil_Moisture_Arduino_Library/). For a quick reference, the main methods available in the library are listed [here](https://docs.sparkfun.com/SparkFun_Soil_Moisture_Arduino_Library/functions.html).

Curious about the hardware this board works with - visit the SparkFun Qwiic Soil Moisture Sensor [hardware repository](https://github.com/sparkfun/Zio-Qwiic-Soil-Moisture-Sensor).

The Hookup Guide for the SparkFun Qwiic Soil Moisture Sensor is available [here](https://learn.sparkfun.com/tutorials/soil-moisture-sensor-hookup-guide).

## License Information

This product is ***open source***!

This product is licensed using the [MIT Open Source License](https://opensource.org/license/mit). 