# Did we make a mistake?

Spot something wrong? Please let us know. <a href="https://github.com/sparkfun/SparkFun_Qwiic_OLED_Arduino_Library/issues" alt="Issues"><img src="https://img.shields.io/github/issues/sparkfun/SparkFun_Qwiic_OLED_Arduino_Library.svg" /></a>

!!! attention
    This is not where customers should seek assistance on a product. If you require technical assistance or have questions about a product that is not working as expected, please head over to the [SparkFun Technical Assistance](https://www.sparkfun.com/technical_assistance) page for some initial troubleshooting.
    <center>
    [SparkFun Technical Assistance Page](https://www.sparkfun.com/technical_assistance){ .md-button .md-button--primary }
    </center>

    If you can't find what you need there, you'll need a [Forum Account](https://forum.sparkfun.com/ucp.php?mode=register) to search product forums and post questions.

## Discrepancies in the Documentation

All of this documentation can be modified by you! Please help us make it better.

* The documentation files for these pages are contained in the [`docs` folder of the SparkFun Qwiic OLED Arduino Library repository](https://github.com/sparkfun/SparkFun_Qwiic_OLED_Arduino_Library/tree/main/docs).

### Spot something wrong?
If a section of the documentation is incorrect, please [open an issue](https://github.com/sparkfun/SparkFun_Qwiic_OLED_Arduino_Library/issues) and let us know.

### Do you have a suggested correction?
1. With a GitHub account, fork this repo
2. Add your correction(s) or improvement(s) to the markdown file(s)
3. File a pull request with your changes, and enjoy making the ~~words~~ ~~worlds~~ world a better place.
    * Once received, the documentation specialist will automatically be notified.
    * We will review your suggested improvement(s) to make sure they are correct and fit within our documentation standards.

## Problems in the Hardware Design

All of our designs are open-source! Please help us make it better.

Our board design files are contained in the `Hardware` folder of their respective repositories:

* [SparkFun Micro OLED Breakout (Qwiic)](https://github.com/sparkfun/Qwiic_Micro_OLED/tree/main/Hardware)
* [SparkFun Qwiic OLED Display (0.91 in, 128x32)](https://github.com/sparkfun/SparkFun_Qwiic_OLED-0.91/tree/main/Hardware)
* [SparkFun Transparent Graphical OLED Breakout (Qwiic)](https://github.com/sparkfun/Qwiic_Transparent_Graphical_OLED/tree/main/Hardware)
* [SparkFun Qwiic OLED - (1.3in., 128x64)](https://github.com/sparkfun/SparkFun_Qwiic_OLED_Arduino_Library/tree/main/Hardware)

### Does something not make sense?
If part of the design is confusing, please [open an issue](https://github.com/sparkfun/SparkFun_Qwiic_OLED_Arduino_Library/issues) and let us know.

### Did we forget to include an important function of the board?
* Please keep in mind that we may intentionally exclude certain functions of the board to meet our product design requirements. *(For example, our Qwiic Micro boards are intended to fit on a small board layout and only use I<sup>2</sup>C communication; therefore, we may not have the SPI and interrupt pins available for users.)*
* If part of the board's functionality is missing, please [open an issue](https://github.com/sparkfun/SparkFun_Qwiic_OLED_Arduino_Library/issues) and file a feature request.

### Do you wish to contribute directly to improving the board design?
1. With a GitHub account, Fork this repo
2. Add your design improvement(s)
3. File a pull request with your changes, and enjoy making the ~~words~~ ~~worlds~~ world a better place.
    * Once received, the engineer in charge of the original design will automatically be notified.
    * We will review your suggested improvement(s), if they are within our board design standards and meet our product design requirements, we will flag these changes for our next board revision. *(Please note, that even if your suggestion is accepted, these changes may not be immediate. We may have to cycle through our current product inventory first.)*
