// Note - this example is from the AdaFruit Pico DVI library, but
// modified to work with the SparkFun RedBoard IoT - RP2350. All
// that is changed is the hardware configuration.

// 8-bit Adafruit_GFX-compatible framebuffer for PicoDVI.

#include <SparkFun_PicoDVI.h>

// Here's how a 320x240 8-bit (color-paletted) framebuffer is declared.
// Second argument ('false' here) means NO double-buffering; all drawing
// operations are shown as they occur. Third argument is a hardware
// configuration -- examples are written for Adafruit Feather RP2040 DVI,
// but that's easily switched out for boards like the Pimoroni Pico DV
// (use 'pimoroni_demo_hdmi_cfg') or the SparkFun RedBoard IoT - RP2350 -
// which this example is using.

DVIGFX8 display(DVI_RES_320x240p60, false, sparkfun_iot_redboard_rp2350_dvi_cfg);

// A 400x240 mode is possible but pushes overclocking even higher than
// 320x240 mode. SOME BOARDS MIGHT SIMPLY NOT BE COMPATIBLE WITH THIS.
// May require selecting QSPI div4 clock (Tools menu) to slow down flash
// accesses, may require further over-volting the CPU to 1.25 or 1.3 V.
// DVIGFX8 display(DVI_RES_400x240p60, false, sparkfun_iot_redboard_rp2350_dvi_cfg);

void setup()
{ // Runs once on startup
    if (!display.begin())
    { // Blink LED if insufficient RAM
        pinMode(LED_BUILTIN, OUTPUT);
        for (;;)
            digitalWrite(LED_BUILTIN, (millis() / 500) & 1);
    }

    // Randomize color palette. First entry is left black, last is set white.
    for (int i = 1; i < 255; i++)
        display.setColor(i, random(65536));
    display.setColor(255, 0xFFFF);
}

void loop()
{
    // Draw random lines
    display.drawLine(random(display.width()), random(display.height()), random(display.width()),
                     random(display.height()), random(256));
}
