/* 
  ESP_WebConfig 

  Copyright (c) 2015 John Lassen. All rights reserved.
  This is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  This software is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  Latest version: 1.1.3  - 2015-07-20
  Changed the loading of the Javascript and CCS Files, so that they will successively loaded and that only one request goes to the ESP.

  -----------------------------------------------------------------------------------------------
  History

  Version: 1.1.2  - 2015-07-17
  Added URLDECODE for some input-fields (SSID, PASSWORD...)

  Version  1.1.1 - 2015-07-12
  First initial version to the public
*/


//
//  HTML PAGE
//
const char PAGE_NetworkConfiguration[] PROGMEM = R"=====(
<meta name="viewport" content="width=device-width, initial-scale=1" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<a href="admin.html"  class="btn btn--s"><</a>&nbsp;&nbsp;<strong>Network Configuration</strong>
<hr>
Connect to Router with these settings:<br>
<form action="" method="get">
<table border="0"  cellspacing="0" cellpadding="3" style="width:310px" >
<tr><br><td align="left"><strong>Enable this Node as Gateway?:</strong></td></tr>
<tr><td><input type="checkbox" id="mnenabled" name="mnenabled"></td></tr>
<br>
<tr><td align="right">SSID:</td><td><input type="text" id="ssid" name="ssid" value=""></td></tr>
<tr><td align="right">Password:</td><td><input type="text" id="password" name="password" value=""></td></tr>
<tr><td align="right">DHCP:</td><td><input type="checkbox" id="dhcp" name="dhcp"></td></tr>
<tr><td align="right">IP:     </td><td><input type="text" id="ip_0" name="ip_0" size="3">.<input type="text" id="ip_1" name="ip_1" size="3">.<input type="text" id="ip_2" name="ip_2" size="3">.<input type="text" id="ip_3" name="ip_3" value="" size="3"></td></tr>
<tr><td align="right">Netmask:</td><td><input type="text" id="nm_0" name="nm_0" size="3">.<input type="text" id="nm_1" name="nm_1" size="3">.<input type="text" id="nm_2" name="nm_2" size="3">.<input type="text" id="nm_3" name="nm_3" size="3"></td></tr>
<tr><td align="right">Gateway:</td><td><input type="text" id="gw_0" name="gw_0" size="3">.<input type="text" id="gw_1" name="gw_1" size="3">.<input type="text" id="gw_2" name="gw_2" size="3">.<input type="text" id="gw_3" name="gw_3" size="3"></td></tr>
<tr><td colspan="2" align="center"><input type="submit" style="width:150px" class="btn btn--m btn--blue" value="Save"></td></tr>
</table>
</form>
<hr>
<strong>You will need only ONE Gateway Node, If this is your First Node you must enable it as Gateway..</strong>
<strong>Connection State:</strong><div id="connectionstate">N/A</div>
<hr>
<strong>Networks:</strong><br>
<table border="0"  cellspacing="3" style="width:310px" >
<tr><td><div id="networks">Scanning...</div></td></tr>
<tr><td align="center"><a href="javascript:GetState()" style="width:150px" class="btn btn--m btn--blue">Refresh</a></td></tr>
</table>


<script>

function GetState()
{
	setValues("/admin/connectionstate");
}
function selssid(value)
{
	document.getElementById("ssid").value = value; 
}


window.onload = function ()
{
	load("style.css","css", function() 
	{
		load("microajax.js","js", function() 
		{
					setValues("/admin/values");
					setTimeout(GetState,3000);
		});
	});
}
function load(e,t,n){if("js"==t){var a=document.createElement("script");a.src=e,a.type="text/javascript",a.async=!1,a.onload=function(){n()},document.getElementsByTagName("head")[0].appendChild(a)}else if("css"==t){var a=document.createElement("link");a.href=e,a.rel="stylesheet",a.type="text/css",a.async=!1,a.onload=function(){n()},document.getElementsByTagName("head")[0].appendChild(a)}}




</script>


)=====";

const char PAGE_WaitAndReload[] PROGMEM = R"=====(
<meta http-equiv="refresh" content="5; URL=config.html">
<tr><br><td align="left"><strong>Please Wait....Configuring and Restarting</strong></td></tr>
<br>
<tr><br><td align="left">This page won't be available any longer, because the node will connect to your router and join your WiFi. Start SoulissApp and have fun!</td></tr>
)=====";


//
//  SEND HTML PAGE OR IF A FORM SUMBITTED VALUES, PROCESS THESE VALUES
// 

#ifndef ASYNCWEBSERVER
void send_network_configuration_html()
#else
void send_network_configuration_html(AsyncWebServerRequest *request)
#endif
{
#ifndef ASYNCWEBSERVER
	yield();
#endif
#ifndef ASYNCWEBSERVER
	if (server.args() > 0 )  // Save Settings
#else
	if (request->params() > 0 )  // Save Settings
#endif
	{
		String temp = "";
		config.dhcp = false;
		config.RuntimeGateway = false;
#ifndef ASYNCWEBSERVER	
		for ( uint8_t i = 0; i < server.args(); i++ ) {
			if (server.argName(i) == "ssid") config.ssid =   urldecode(server.arg(i));
			if (server.argName(i) == "password") config.password =    urldecode(server.arg(i)); 
			if (server.argName(i) == "ip_0") if (checkRange(server.arg(i))) 	config.IP[0] =  server.arg(i).toInt();
			if (server.argName(i) == "ip_1") if (checkRange(server.arg(i))) 	config.IP[1] =  server.arg(i).toInt();
			if (server.argName(i) == "ip_2") if (checkRange(server.arg(i))) 	config.IP[2] =  server.arg(i).toInt();
			if (server.argName(i) == "ip_3") if (checkRange(server.arg(i))) 	config.IP[3] =  server.arg(i).toInt();
			if (server.argName(i) == "nm_0") if (checkRange(server.arg(i))) 	config.Netmask[0] =  server.arg(i).toInt();
			if (server.argName(i) == "nm_1") if (checkRange(server.arg(i))) 	config.Netmask[1] =  server.arg(i).toInt();
			if (server.argName(i) == "nm_2") if (checkRange(server.arg(i))) 	config.Netmask[2] =  server.arg(i).toInt();
			if (server.argName(i) == "nm_3") if (checkRange(server.arg(i))) 	config.Netmask[3] =  server.arg(i).toInt();
			if (server.argName(i) == "gw_0") if (checkRange(server.arg(i))) 	config.Gateway[0] =  server.arg(i).toInt();
			if (server.argName(i) == "gw_1") if (checkRange(server.arg(i))) 	config.Gateway[1] =  server.arg(i).toInt();
			if (server.argName(i) == "gw_2") if (checkRange(server.arg(i))) 	config.Gateway[2] =  server.arg(i).toInt();
			if (server.argName(i) == "gw_3") if (checkRange(server.arg(i))) 	config.Gateway[3] =  server.arg(i).toInt();
			if (server.argName(i) == "dhcp") config.dhcp = true;
			if (server.argName(i) == "mnenabled") config.RuntimeGateway = true;
		}
#else
		for ( uint8_t i = 0; i < request->params(); i++ ) {
			AsyncWebParameter* p = request->getParam(i);
			if (p->name() == "ssid") config.ssid =   urldecode(p->value());
			if (p->name() == "password") config.password =    urldecode(p->value());
			if (p->name() == "ip_0") if (checkRange(p->value())) 	config.IP[0] =  p->value().toInt();
			if (p->name() == "ip_1") if (checkRange(p->value())) 	config.IP[1] =  p->value().toInt();
			if (p->name() == "ip_2") if (checkRange(p->value())) 	config.IP[2] =  p->value().toInt();
			if (p->name() == "ip_3") if (checkRange(p->value())) 	config.IP[3] =  p->value().toInt();
			if (p->name() == "nm_0") if (checkRange(p->value())) 	config.Netmask[0] =  p->value().toInt();
			if (p->name() == "nm_1") if (checkRange(p->value())) 	config.Netmask[1] =  p->value().toInt();
			if (p->name() == "nm_2") if (checkRange(p->value())) 	config.Netmask[2] =  p->value().toInt();
			if (p->name() == "nm_3") if (checkRange(p->value())) 	config.Netmask[3] =  p->value().toInt();
			if (p->name() == "gw_0") if (checkRange(p->value())) 	config.Gateway[0] =  p->value().toInt();
			if (p->name() == "gw_1") if (checkRange(p->value())) 	config.Gateway[1] =  p->value().toInt();
			if (p->name() == "gw_2") if (checkRange(p->value())) 	config.Gateway[2] =  p->value().toInt();
			if (p->name() == "gw_3") if (checkRange(p->value())) 	config.Gateway[3] =  p->value().toInt();
			if (p->name() == "dhcp") config.dhcp = true;
			if (p->name() == "mnenabled") config.RuntimeGateway = true;
		}
#endif
	
		// Save the configuration
		WriteConfig();
#ifndef ASYNCWEBSERVER
		server.send (200, "text/html", reinterpret_cast<const __FlashStringHelper *>(PAGE_WaitAndReload ));
#else
		request->send (200, "text/html", reinterpret_cast<const __FlashStringHelper *>(PAGE_WaitAndReload ));
#endif
		delay(10000);
		
		// Connect a first time, and write into the ESP8266 own FLASH sector the SSID and Password
		WiFi.mode(WIFI_STA);
		WiFi.begin(config.ssid.c_str(), config.password.c_str());
		
		// Wait for a connection
		uint8_t timeout=20;
		while ((WiFi.status() != WL_CONNECTED) && timeout)
		{
			timeout--;
			delay(500);
		}
		
		// Time to restart and enter in the user application
		ESP.restart();
	}
	else
	{
#ifndef ASYNCWEBSERVER
            server.send_P ( 200, "text/html", PAGE_NetworkConfiguration ); 
#else
            request->send_P ( 200, "text/html", PAGE_NetworkConfiguration );
#endif

	}
}

//
//   FILL THE PAGE WITH VALUES
//

#ifndef ASYNCWEBSERVER
void send_network_configuration_values_html()
#else
void send_network_configuration_values_html(AsyncWebServerRequest *request)
#endif
{
#ifndef ASYNCWEBSERVER
	yield();
#endif
	String values ="";

	values += "ssid|" + (String) config.ssid + "|input\n";
	values += "password|" +  (String) config.password + "|input\n";
	values += "ip_0|" +  (String) config.IP[0] + "|input\n";
	values += "ip_1|" +  (String) config.IP[1] + "|input\n";
	values += "ip_2|" +  (String) config.IP[2] + "|input\n";
	values += "ip_3|" +  (String) config.IP[3] + "|input\n";
	values += "nm_0|" +  (String) config.Netmask[0] + "|input\n";
	values += "nm_1|" +  (String) config.Netmask[1] + "|input\n";
	values += "nm_2|" +  (String) config.Netmask[2] + "|input\n";
	values += "nm_3|" +  (String) config.Netmask[3] + "|input\n";
	values += "gw_0|" +  (String) config.Gateway[0] + "|input\n";
	values += "gw_1|" +  (String) config.Gateway[1] + "|input\n";
	values += "gw_2|" +  (String) config.Gateway[2] + "|input\n";
	values += "gw_3|" +  (String) config.Gateway[3] + "|input\n";
	values += "dhcp|" +  (String) (config.dhcp ? "checked" : "") + "|chk\n";
	values += "mnenabled|" +  (String) (config.RuntimeGateway ? "checked" : "") + "|chk\n";
#ifndef ASYNCWEBSERVER
	server.send ( 200, "text/plain", values);
#else
	request->send ( 200, "text/plain", values);
#endif	
	
}


//
//   FILL THE PAGE WITH NETWORKSTATE & NETWORKS
//

#ifndef ASYNCWEBSERVER
void send_connection_state_values_html()
#else
void send_connection_state_values_html(AsyncWebServerRequest *request)
#endif
{
#ifndef ASYNCWEBSERVER
	yield();
#endif
	String state = "N/A";
	String Networks = "";
	if (WiFi.status() == 0) state = "Idle";
	else if (WiFi.status() == 1) state = "NO SSID AVAILBLE";
	else if (WiFi.status() == 2) state = "SCAN COMPLETED";
	else if (WiFi.status() == 3) state = "CONNECTED";
	else if (WiFi.status() == 4) state = "CONNECT FAILED";
	else if (WiFi.status() == 5) state = "CONNECTION LOST";
	else if (WiFi.status() == 6) state = "DISCONNECTED";



#ifdef ASYNCWEBSERVER
	int n = WiFi.scanComplete();
#else
	int n = WiFi.scanNetworks();
#endif
 
#ifdef ASYNCWEBSERVER
	if (n == WIFI_SCAN_FAILED) {
	 	WiFi.scanNetworks(true);
	 	Networks = "<font color='#FF0000'>Scan in progess</font>";
		uint8_t percent;
	} else 
#endif
	if (n == 0)
	{
		Networks = "<font color='#FF0000'>No networks found!</font>";
	}
	else
#ifdef ASYNCWEBSERVER
	if (n >= 0)
#endif		
	{
		Networks = "Found " +String(n) + " Networks<br>";
		Networks += "<table border='0' cellspacing='0' cellpadding='3'>";
		Networks += "<tr bgcolor='#DDDDDD' ><td><strong>Name</strong></td><td><strong>Quality</strong></td><td><strong>Enc</strong></td><tr>";
		for (int i = 0; i < n; ++i)
		{
			int quality=0;
			if(WiFi.RSSI(i) <= -100)
			{
					quality = 0;
			}
			else if(WiFi.RSSI(i) >= -50)
			{
					quality = 100;
			}
			else
			{
				quality = 2 * (WiFi.RSSI(i) + 100);
			}


			//Networks += "<tr><td><a href='javascript:selssid(\""  +  String(WiFi.SSID(i))  + "\")'>"  +  String(WiFi.SSID(i))  + "</a></td><td>" +  String(quality) + "%</td><td>" +  String((WiFi.encryptionType(i) == ENC_TYPE_NONE)?" ":"*")  + "</td></tr>";
			Networks += "<tr><td><a href='javascript:selssid(\""  +  String(WiFi.SSID(i))  + "\")'>"  +  String(WiFi.SSID(i))  + "</a></td><td>" +  String(quality) + "%</td><td>" +  String((WiFi.encryptionType(i) == WIFI_AUTH_OPEN)?" ":"*")  + "</td></tr>";
			
		}
		Networks += "</table>";
	}
   
	String values ="";
	values += "connectionstate|" +  state + "|div\n";
	values += "networks|" +  Networks + "|div\n";
#ifndef ASYNCWEBSERVER
	server.send ( 200, "text/plain", values);
#else
	request->send ( 200, "text/plain", values);
#endif
	
}

