#pragma once

// BOARD BASE PIN
#define BOARD_RESET_PIN     (38)
#define BOARD_I2C_SDA_PIN   (-1)
#define BOARD_I2C_SCL_PIN   (-1)

// LCD PIN
#define LCD_BL_PIN          (15)

// LCD 8080 PIN
#define LCD_RST_PIN         (-1)
#define LCD_RS_PIN          (47)
#define LCD_CS_PIN          (-1)
#define LCD_TE_PIN          (48)
#define LCD_WR_PIN          (21)
#define LCD_RD_PIN          (-1)

#define LCD_D0_PIN          (39)
#define LCD_D1_PIN          (40)
#define LCD_D2_PIN          (41)
#define LCD_D3_PIN          (14)
#define LCD_D4_PIN          (13)
#define LCD_D5_PIN          (12)
#define LCD_D6_PIN          (11)
#define LCD_D7_PIN          (10)

// TOUCH PAD PIN
#define TP_I2C_SDA_PIN      (9)
#define TP_I2C_SCL_PIN      (3)
#define TP_I2C_INT_PIN      (42)
#define TP_I2C_RST_PIN      (-1)

// I2S PIN
#define I2S_MCLK_PIN        (-1)
#define I2S_SCLK_PIN        (-1)
#define I2S_LRCK_PIN        (-1)
#define I2S_DOUT_PIN        (-1)
#define I2S_DIN_PIN         (-1)

// SD CARD
#define SD_CLK_PIN          (-1) // CLK
#define SD_CMD_PIN          (-1) // MOSI
#define SD_D0_PIN           (-1) // MISO
#define SD_D1_PIN           (-1)
#define SD_D2_PIN           (-1)
#define SD_D3_PIN           (-1) // CS

// UART-485
#define RS485_RTS_PIN       (46)
#define RS485_RXD_PIN       (17)
#define RS485_TXD_PIN       (16)

// EXT_UART
#define EXT_UART_TXD_PIN    (8)
#define EXT_UART_RXD_PIN    (18)

// USB
#define USB_DP_PIN          (20)
#define USB_DN_PIN          (19)

// CAN
#define CAN_TX_PIN          (6)
#define CAN_RX_PIN          (7)

// BUZZER
#define BUZZER_PIN          (45)

// EXTERNAL PIN
#define EXTERNAL_PIN_1      (1)
#define EXTERNAL_PIN_2      (2)
#define EXTERNAL_PIN_3      (4)
#define EXTERNAL_PIN_4      (5)
