#include "PanelLan.h"

/*
  change images into byte arrays
  image2cpp: https://javl.github.io/image2cpp/
  Draw mode:Horizontal - 2 bytes per pixel(565)
*/

// BOARD_SC01, BOARD_SC01_PLUS, BOARD_SC02, BOARD_SC05, BOARD_KC01, BOARD_BC02
PanelLan tft(BOARD_SC01_PLUS);

static constexpr int image_width  = 140;
static constexpr int image_height = 140;
extern const uint16_t epd_bitmap_image[];

void setup(void) {
  tft.begin();

  tft.pushImage(0, 0, image_width, image_height, (lgfx::rgb565_t*)epd_bitmap_image);
}

void loop(void) {
  delay(1000);
}

// 'image', 140x140px
const uint16_t epd_bitmap_image [] PROGMEM = {
	0xa514, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 
	0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 
	0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 
	0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 
	0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 
	0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 
	0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 
	0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 
	0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xa514, 0xbdf7, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 
	0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 
	0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 
	0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffdf, 0xffdf, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xf7ff, 
	0xf7ff, 0xefff, 0xefff, 0xefff, 0xefff, 0xefff, 0xe7ff, 0xdfdf, 0xdfdf, 0xd7bf, 0xdfdf, 0xdfff, 0xe7ff, 0xefff, 0xefff, 0xefff, 
	0xefff, 0xf7ff, 0xf7ff, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xefff, 0xdfff, 0xc79f, 0xb75f, 0xa71f, 0x96df, 0x865f, 
	0x761f, 0x6dff, 0x6ddf, 0x65de, 0x5dde, 0x5dbe, 0x65df, 0x65ff, 0x6dff, 0x7e3f, 0x8e7f, 0x9eff, 0xaf3f, 0xbf5f, 0xd7ff, 0xefff, 
	0xefff, 0xf7ff, 0xffff, 0xffff, 0xf7df, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffdf, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 
	0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xfffe, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xf7ff, 0xefff, 0xdfdf, 0xcf9f, 0xbf5f, 0x9ebf, 0x863e, 0x659c, 0x4d3b, 0x2c7a, 0x247a, 0x1c3b, 0x141b, 0x143c, 0x0c3c, 0x0c1b, 
	0x041b, 0x041b, 0x0c3b, 0x0c3b, 0x143b, 0x143b, 0x247b, 0x2c9b, 0x349b, 0x555c, 0x6dbd, 0x8e7f, 0xaf1f, 0xc77f, 0xdfff, 0xefff, 
	0xf7ff, 0xf7ff, 0xf7ff, 0xf7ff, 0xffff, 0xffff, 0xffdf, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xf7ff, 0xe7ff, 0xcfdf, 0xaf5f, 0x86bf, 0x5d9e, 
	0x34bb, 0x243b, 0x1c3b, 0x141b, 0x143c, 0x0c5d, 0x0c7d, 0x0c5d, 0x0c7e, 0x0c7e, 0x0c7e, 0x0c7e, 0x0c7e, 0x0c7e, 0x0c7e, 0x0c7e, 
	0x0c7d, 0x045d, 0x0c7d, 0x0c7d, 0x0c5d, 0x145c, 0x0c1b, 0x143b, 0x247c, 0x453d, 0x6e3f, 0x9f3f, 0xb79f, 0xd7df, 0xe7ff, 0xf7ff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffdf, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xf7ff, 0xf7ff, 0xefff, 0xdfff, 0xc77f, 0x969f, 0x5d7d, 0x2c5a, 0x1c7b, 0x145c, 0x0c5d, 0x0c7e, 0x0c7f, 0x0c7f, 
	0x0c7f, 0x049f, 0x049f, 0x049f, 0x049f, 0x045e, 0x047f, 0x047f, 0x049f, 0x049f, 0x049f, 0x047f, 0x045e, 0x045e, 0x047f, 0x047f, 
	0x049f, 0x049f, 0x047f, 0x047e, 0x047e, 0x0c5d, 0x147b, 0x1c7a, 0x44fb, 0x7e3f, 0xaeff, 0xd7df, 0xe7ff, 0xf7ff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xefff, 0xdfff, 
	0xb75f, 0x7e5f, 0x4d5e, 0x1c7c, 0x0c5c, 0x145d, 0x0c5e, 0x0c7e, 0x0c7e, 0x0c7f, 0x0c7f, 0x0c7f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x049f, 
	0x049e, 0x047e, 0x047d, 0x0c7d, 0x0c7d, 0x1c7c, 0x2c9c, 0x5dbe, 0x9f1f, 0xe7ff, 0xf7ff, 0xf7ff, 0xffff, 0xffff, 0xffde, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 
	0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffbe, 0xffdf, 0xffff, 0xf7ff, 0xe7ff, 0xc79f, 0x8e7f, 0x4cfb, 0x1c3b, 0x0c7e, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x049f, 0x049e, 0x049e, 0x049f, 0x049f, 
	0x047f, 0x045f, 0x0c9e, 0x145c, 0x2459, 0x655b, 0xaedf, 0xdfff, 0xe7ff, 0xf7ff, 0xffff, 0xffff, 0xffdf, 0xffff, 0xf7ff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffdf, 0xffff, 0xefff, 0xcfbf, 0x869f, 0x455d, 0x1c3b, 0x0c3c, 0x0c5e, 0x043f, 0x045f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x049f, 0x049f, 0x047f, 0x0c5d, 
	0x145d, 0x141b, 0x2cbb, 0x65de, 0xaf5f, 0xd7df, 0xf7ff, 0xf7ff, 0xf7be, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xefff, 0xb71f, 
	0x659c, 0x249b, 0x0c7d, 0x047e, 0x049f, 0x047f, 0x047f, 0x047f, 0x045f, 0x047f, 0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 0x049f, 
	0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 0x049f, 0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 0x049f, 0x049f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x049f, 0x047f, 0x045f, 0x047f, 0x047f, 0x045e, 0x045e, 0x045d, 0x1c9c, 
	0x3cfb, 0x8e9e, 0xcfdf, 0xefff, 0xefdf, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffdf, 0xffff, 0xffff, 0xefff, 0xd7bf, 0x8e5f, 0x44fc, 0x145b, 0x0c7d, 0x047e, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047e, 0x047f, 0x047e, 0x0c7e, 0x145c, 0x249b, 0x5d9d, 0xaf3f, 
	0xefff, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 
	0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xe7ff, 0xbf5f, 0x75de, 0x349b, 0x0c3c, 0x047e, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047e, 0x043d, 0x1c5b, 0x4d3b, 0x9e9f, 0xdfdf, 0xf7ff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xe7ff, 0xa73f, 
	0x555d, 0x1c3c, 0x0c3e, 0x045e, 0x043e, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x0c9f, 0x043c, 0x143c, 0x3cdc, 0x865f, 0xcf9f, 0xefff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xe7ff, 0x9ebf, 0x451c, 0x145b, 0x043d, 0x0c7f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x0c9f, 0x0c7f, 0x0c3c, 0x2439, 0x75fe, 0xcf9f, 0xefff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffde, 0xf79e, 0xffff, 0xe7ff, 0x8e9f, 0x3cdc, 0x143b, 0x149e, 0x0c5e, 0x0c7f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x049f, 0x049f, 0x049e, 
	0x0c7e, 0x0c5d, 0x247c, 0x659d, 0xc77f, 0xefff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 
	0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7de, 0xf7ff, 0xdfff, 
	0x969f, 0x3cdc, 0x147d, 0x0c7e, 0x047f, 0x0c7e, 0x0c7e, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x049f, 0x049f, 0x049f, 0x049f, 0x047f, 0x041c, 0x245b, 
	0x5d3c, 0xc75f, 0xefff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xdfff, 0x8ebf, 0x3cdc, 0x145d, 0x0c7f, 0x0c9f, 
	0x043e, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x049f, 0x049f, 0x049f, 0x049f, 0x045e, 0x0c9f, 0x149e, 0x1c3b, 0x6dbe, 0xbf7f, 0xf7ff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xe7ff, 0x9ebe, 0x34bb, 0x0c3b, 0x0c7e, 0x047f, 0x047f, 0x047f, 0x049f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047e, 0x047e, 0x047e, 0x047e, 0x047e, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x049f, 0x049f, 0x047f, 0x047f, 0x04bf, 0x049f, 0x043e, 0x0c7d, 0x1c5a, 0x761f, 0xd7bf, 0xf7ff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 
	0xefff, 0xaf5f, 0x44fa, 0x1c9c, 0x045d, 0x049f, 0x049f, 0x049f, 0x049f, 0x049f, 0x049f, 0x049f, 0x049f, 0x049f, 0x049f, 0x049f, 
	0x049f, 0x049f, 0x049f, 0x049f, 0x049f, 0x047e, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x045f, 0x045e, 0x047e, 0x045e, 0x043d, 
	0x041d, 0x041d, 0x041c, 0x03fc, 0x03dc, 0x0c3d, 0x041c, 0x041c, 0x0c5d, 0x043d, 0x043d, 0x045e, 0x0cbf, 0x049e, 0x04bf, 0x049f, 
	0x045e, 0x047f, 0x047f, 0x047f, 0x047f, 0x049f, 0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047e, 0x0c7d, 0x247b, 0x7e3d, 0xd7df, 0xf7ff, 0xffde, 0xfffe, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 
	0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xf7ff, 0xbf3f, 0x555c, 0x1c5b, 0x0c7d, 
	0x04bf, 0x049f, 0x049f, 0x049f, 0x049f, 0x049f, 0x049f, 0x049f, 0x049f, 0x049f, 0x049f, 0x049f, 0x049f, 0x049f, 0x049f, 0x049f, 
	0x049f, 0x049f, 0x049f, 0x047f, 0x045f, 0x0c7f, 0x0c5d, 0x0c3c, 0x0c1b, 0x0bfa, 0x13fa, 0x13d9, 0x13d9, 0x1bd8, 0x1bb8, 0x13b7, 
	0x1397, 0x1397, 0x0b77, 0x0357, 0x0377, 0x03b9, 0x0399, 0x03da, 0x043c, 0x045d, 0x045d, 0x0c5e, 0x045e, 0x045f, 0x047f, 0x047f, 
	0x047f, 0x049f, 0x049f, 0x049f, 0x049f, 0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x049f, 0x0c7c, 0x34ba, 0x865e, 0xe7ff, 0xf7ff, 0xfffe, 0xfffe, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffdf, 0xf7ff, 0xd7bf, 0x75bd, 0x1c5b, 0x0c5d, 0x047e, 0x0c9f, 0x049f, 0x049f, 0x049f, 
	0x049f, 0x049f, 0x049f, 0x049f, 0x049f, 0x049f, 0x049f, 0x049f, 0x049f, 0x049f, 0x049f, 0x049e, 0x049f, 0x049f, 0x049f, 0x045e, 
	0x0c3d, 0x03fa, 0x13f9, 0x2418, 0x3417, 0x3c36, 0x5497, 0x6d3a, 0x7d9b, 0x8dfc, 0x8dfb, 0x8ddb, 0x8dbb, 0x7d59, 0x64d8, 0x4c57, 
	0x33d5, 0x1b55, 0x0b55, 0x0315, 0x0336, 0x0399, 0x039a, 0x0bfc, 0x145e, 0x0c5e, 0x045f, 0x047f, 0x047f, 0x047f, 0x047f, 0x049f, 
	0x049f, 0x049f, 0x049f, 0x049f, 0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x049f, 0x0c9e, 0x0c5c, 
	0x3cdb, 0xb73f, 0xe7ff, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xefff, 0x8e7f, 0x2c7a, 0x145d, 0x045f, 0x047f, 0x047f, 0x049f, 0x049f, 0x049f, 0x049f, 0x049f, 0x049f, 0x04bf, 
	0x049f, 0x049f, 0x049f, 0x049f, 0x049f, 0x049f, 0x049f, 0x049e, 0x049e, 0x0c9e, 0x147d, 0x143b, 0x1bf9, 0x3459, 0x5d3a, 0x8e7e, 
	0xb73f, 0xd7ff, 0xdfff, 0xe7ff, 0xefff, 0xefff, 0xefff, 0xefff, 0xefff, 0xe7df, 0xe7df, 0xdfbf, 0xcf7f, 0x9e9f, 0x7dbc, 0x4437, 
	0x1b75, 0x0b15, 0x02f6, 0x0317, 0x0359, 0x0c1c, 0x0c5e, 0x045e, 0x045e, 0x047f, 0x047f, 0x049f, 0x049f, 0x049f, 0x049f, 0x049f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047e, 0x045e, 0x0cbf, 0x147c, 0x5d5c, 0xcf9f, 0xefff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7be, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xbf5f, 0x44fb, 
	0x145c, 0x0c7e, 0x047f, 0x047f, 0x049f, 0x049e, 0x049e, 0x049e, 0x049e, 0x04bf, 0x04bf, 0x04bf, 0x04be, 0x04bf, 0x04bf, 0x04bf, 
	0x04df, 0x04df, 0x051f, 0x04df, 0x045c, 0x143a, 0x2418, 0x54b9, 0x9e7e, 0xc75f, 0xdfbf, 0xefff, 0xefff, 0xf7ff, 0xf7ff, 0xf7ff, 
	0xf7ff, 0xf7ff, 0xf7ff, 0xf7ff, 0xf7ff, 0xffff, 0xffff, 0xf7ff, 0xf7ff, 0xefff, 0xe7df, 0xcf3f, 0xaebe, 0x6519, 0x2b95, 0x0af4, 
	0x0b77, 0x0316, 0x0358, 0x0bdb, 0x145d, 0x0c9e, 0x047e, 0x049f, 0x04bf, 0x049f, 0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047e, 0x047e, 0x049e, 0x0c7d, 0x247b, 0x7e1f, 0xe7ff, 0xf7df, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 
	0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xd7df, 0x6dbd, 0x1c5b, 0x045e, 0x047f, 0x047f, 0x049f, 
	0x049f, 0x04bf, 0x04bf, 0x04bf, 0x04bf, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04ff, 0x04ff, 0x04be, 0x0c9c, 
	0x1c7a, 0x4d3b, 0x969e, 0xd7bf, 0xefff, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xdfdf, 0xa69e, 0x653a, 0x2bb5, 0x1335, 0x0315, 0x0357, 
	0x0399, 0x0c3c, 0x045d, 0x047e, 0x049f, 0x049f, 0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047e, 0x049e, 0x047e, 0x0c5d, 0x3cfc, 0xaedf, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xe7ff, 0x96ff, 0x34db, 0x0c5c, 0x045e, 0x047f, 0x047f, 0x049f, 0x049f, 0x04bf, 0x04be, 0x04df, 
	0x04df, 0x04df, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x049e, 0x147b, 0x451b, 0x863d, 0xcfbf, 0xe7ff, 0xf7ff, 
	0xf7df, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffdf, 0xffff, 0xffff, 0xf7df, 0xefff, 0xdfbf, 0x9e5c, 0x4c56, 0x1b54, 0x0315, 0x0336, 0x03b9, 0x041b, 0x043d, 
	0x047e, 0x049f, 0x049f, 0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x049f, 0x049e, 0x049e, 
	0x049e, 0x049e, 0x1c7c, 0x5d5b, 0xd7df, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xefdf, 
	0xcfbf, 0x557d, 0x147c, 0x0c7e, 0x14df, 0x049f, 0x049f, 0x049f, 0x04bf, 0x04df, 0x04df, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 
	0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x14dd, 0x249b, 0x5d9d, 0xa6ff, 0xdfff, 0xf7ff, 0xffde, 0xffde, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffdf, 0xffdf, 
	0xffff, 0xffdf, 0xffff, 0xf7ff, 0xefff, 0xc75f, 0x6d19, 0x2b95, 0x0af4, 0x0336, 0x0378, 0x03fb, 0x045d, 0x047e, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x049f, 0x049f, 0x049f, 0x049f, 0x043c, 0x34bb, 
	0x96bf, 0xefff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xe7ff, 0x965e, 0x247b, 0x0c9e, 0x049e, 
	0x047e, 0x049f, 0x04bf, 0x04bf, 0x04df, 0x04df, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04de, 0x0d1f, 0x0cbd, 
	0x2cdb, 0x75dc, 0xcf9f, 0xefff, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xefff, 0xe7ff, 0xa65d, 0x3394, 0x0b14, 0x02f6, 0x0357, 0x0399, 0x03db, 0x0c5e, 0x0c7f, 0x045f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x049f, 0x049f, 0x049f, 0x045e, 0x0c5b, 0x453c, 0xc79f, 0xf7ff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 
	0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xefff, 0xbf7f, 0x5d7d, 0x147d, 0x0c9f, 0x049f, 0x049f, 0x04bf, 0x04bf, 0x04ff, 
	0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04df, 0x04df, 0x04de, 0x0d1e, 0x14bc, 0x2cdb, 0x761e, 0xcfbf, 0xf7ff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xdf7f, 
	0xa69d, 0x3c17, 0x02d3, 0x0335, 0x0357, 0x0379, 0x0bfc, 0x0c5e, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047e, 0x047d, 0x24bc, 0x967f, 0xe7df, 0xf7ff, 0xfffe, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xf7ff, 0xe7ff, 0x8ebf, 0x245a, 0x0c7d, 0x049f, 0x049f, 0x04bf, 0x04bf, 0x04ff, 0x0cff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 
	0x04ff, 0x04ff, 0x04df, 0x04df, 0x04de, 0x0cbc, 0x2cdb, 0x7e1d, 0xd7bf, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xfffe, 0xffff, 0xf7ff, 0xe7ff, 0x9e5c, 0x3c15, 0x0b14, 
	0x0336, 0x0337, 0x0379, 0x03fc, 0x047e, 0x047f, 0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x049f, 0x047e, 0x049f, 0x047d, 0x0c3b, 0x551b, 0xc79f, 0xf7ff, 0xfffe, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xf7ff, 0xcfbf, 0x5dbe, 
	0x0c3b, 0x047e, 0x049f, 0x04bf, 0x04df, 0x04df, 0x0cff, 0x04ff, 0x04ff, 0x04fe, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04df, 
	0x0cdd, 0x2cdb, 0x761d, 0xd7bf, 0xf7ff, 0xffdf, 0xffdf, 0xffff, 0xf7de, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xfffe, 0xfffe, 0xfffe, 0xffff, 0xe7ff, 0x9e5c, 0x2bb5, 0x0b14, 0x0315, 0x0317, 0x0399, 
	0x0c3d, 0x047e, 0x049f, 0x047f, 0x047f, 0x047e, 0x047e, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047e, 0x049e, 0x049e, 0x047e, 
	0x0c3c, 0x349a, 0x9edf, 0xefff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xefff, 0xa6df, 0x2c9b, 0x0c7e, 0x049e, 0x04bf, 0x04df, 
	0x04df, 0x0cff, 0x04ff, 0x04ff, 0x04fe, 0x04fe, 0x04fe, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x049d, 0x1cbc, 0x75fd, 0xcf9f, 0xf7ff, 
	0xffbf, 0xffdf, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xe7ff, 0x8ddb, 0x2b74, 0x0b35, 0x0357, 0x0357, 0x03ba, 0x0c7d, 0x049f, 0x047f, 
	0x047f, 0x049f, 0x049f, 0x049f, 0x049f, 0x047f, 0x047f, 0x047f, 0x049f, 0x049e, 0x049e, 0x047f, 0x0c7e, 0x145c, 0x659e, 0xdfdf, 
	0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 
	0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffdf, 0xffff, 0xf7ff, 0xdfff, 0x7dfd, 0x143b, 0x0cbf, 0x04bf, 0x04df, 0x04df, 0x0cff, 0x04ff, 0x04ff, 0x04ff, 
	0x04ff, 0x04fe, 0x04fe, 0x04ff, 0x04ff, 0x04ff, 0x0cde, 0x0cbc, 0x4d7c, 0xbf5f, 0xf7ff, 0xffff, 0xffbe, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xd77f, 0x6d19, 0x1334, 0x02f5, 0x0316, 0x0378, 0x0c1b, 0x045d, 0x047f, 0x047f, 0x049f, 0x049f, 0x049f, 
	0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 0x049e, 0x049e, 0x047f, 0x047f, 0x043c, 0x3cdc, 0xbf5f, 0xf7ff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xefff, 0xbf7f, 0x4d1c, 0x0c5c, 0x049e, 0x04df, 0x04df, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 
	0x04ff, 0x04df, 0x0cdd, 0x353c, 0x96df, 0xe7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 
	0xbeff, 0x4c37, 0x02b3, 0x02d5, 0x0b58, 0x0398, 0x0c3c, 0x045f, 0x047f, 0x049f, 0x049f, 0x049f, 0x049f, 0x049f, 0x049f, 0x047f, 
	0x047f, 0x047f, 0x049f, 0x047f, 0x047f, 0x047e, 0x1c5b, 0x965e, 0xefff, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xefff, 0x96bf, 0x2c9c, 0x0c9d, 
	0x04de, 0x04df, 0x04df, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04de, 0x1cdc, 0x5dbb, 
	0xd7ff, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0x8dfc, 0x2334, 0x1336, 
	0x02f6, 0x0316, 0x03da, 0x043e, 0x049f, 0x047f, 0x049f, 0x047f, 0x049f, 0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x049f, 0x047f, 0x0c5c, 0x655c, 0xdfff, 0xf7ff, 0xffff, 0xfffe, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xffff, 0xdfff, 0x65df, 0x145c, 0x049d, 0x0d1f, 0x04df, 0x04ff, 0x04ff, 
	0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04df, 0x04df, 0x04ff, 0x04fe, 0x0cfd, 0x3d5c, 0xb77f, 0xefff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffdf, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xd79f, 0x64b8, 0x0ad4, 0x0b37, 0x0336, 0x0378, 0x041c, 
	0x0c9f, 0x047f, 0x049f, 0x049f, 0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x045f, 0x149e, 0x349b, 
	0xb75f, 0xefff, 0xffff, 0xfffe, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 
	0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xf7ff, 0xf7ff, 0xc77f, 0x4d5e, 0x0c9d, 0x04be, 0x04ff, 0x04df, 0x04df, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 
	0x04ff, 0x04df, 0x04df, 0x04df, 0x0cde, 0x1cdc, 0x6e3e, 0xd7df, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xe7bf, 0x9e1c, 0x2b96, 0x0b36, 0x0316, 0x0357, 0x03da, 0x045d, 0x047f, 0x047f, 0x049f, 
	0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x0c7e, 0x247c, 0x96ff, 0xe7ff, 0xffff, 0xfffe, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 
	0xaebf, 0x2cbc, 0x0c9e, 0x0cff, 0x04be, 0x04df, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04df, 0x04df, 0x04df, 0x04df, 
	0x14bd, 0x453c, 0xaf5f, 0xefff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xfffe, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xf7ff, 0xf7ff, 0xd77f, 0x4c78, 0x0af4, 0x0b36, 0x0336, 0x03b9, 0x043c, 0x047e, 0x047f, 0x049f, 0x049f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x0c5e, 0x1c5c, 0x6dde, 0xd7df, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xefff, 0x965e, 0x1c7b, 0x0cdf, 0x0cff, 
	0x04de, 0x04df, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04df, 0x04df, 0x0cdf, 0x0cbf, 0x1c9c, 0x65bd, 0xd7ff, 0xf7ff, 
	0xffde, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xefff, 
	0xefff, 0xefff, 0xefff, 0xefff, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xfffe, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0x85dc, 
	0x1314, 0x0b15, 0x0337, 0x0378, 0x03da, 0x0c7e, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x045e, 0x145d, 0x4d1c, 0xcfbf, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xe7ff, 0x7e1e, 0x145b, 0x04bf, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 
	0x04df, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04df, 0x0cbe, 0x2cfd, 0x8e5e, 0xe7ff, 0xffff, 0xffde, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xe7df, 0xc71f, 0x8e1c, 0x757b, 0x64f9, 0x6519, 0x8e1c, 
	0xbf5f, 0xefff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xefff, 0xb6ff, 0x33b5, 0x0af4, 0x0316, 0x0337, 
	0x0399, 0x0c5e, 0x047f, 0x047f, 0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x045e, 0x0c5e, 
	0x2c7b, 0xb73f, 0xf7ff, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 
	0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xf7ff, 0xd7ff, 0x6ddd, 0x147b, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04ff, 0x04ff, 0x04ff, 
	0x04ff, 0x04ff, 0x04df, 0x0cbe, 0x453d, 0xb71f, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xf7ff, 0xf7ff, 0xd77f, 0x855a, 0x43f6, 0x2375, 0x1314, 0x1b56, 0x0af4, 0x1b74, 0x4436, 0x6cf8, 0xbede, 0xf7ff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xfffe, 0xf7ff, 0xcf9f, 0x5cb8, 0x12f4, 0x0316, 0x0317, 0x0378, 0x041d, 0x0c7f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x045e, 0x1c3b, 0xaeff, 0xefff, 0xf7ff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xefff, 0xbf9f, 
	0x4d7c, 0x0c7c, 0x04df, 0x04ff, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04de, 0x149c, 
	0x5d9e, 0xd7df, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xf7ff, 0xbeff, 
	0x64b8, 0x2334, 0x0ab4, 0x0b16, 0x0b37, 0x0b37, 0x0b56, 0x0b35, 0x0b14, 0x12f4, 0x5cb9, 0xb69e, 0xefff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xf7fe, 0xf7ff, 0xefff, 0x8dba, 0x1b14, 0x0316, 0x0316, 0x0358, 0x03db, 0x0c5e, 0x0c7f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x1c3b, 0x9e7f, 0xe7ff, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xefff, 0xaf5f, 0x3d1b, 0x0c9c, 0x04df, 0x04ff, 
	0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04bd, 0x147b, 0x6dfe, 0xe7ff, 0xf7ff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xd77f, 0x64b8, 0x0ab2, 0x0af5, 0x0b58, 0x02f6, 
	0x0337, 0x0316, 0x02f5, 0x02f4, 0x02f4, 0x0b36, 0x0ab3, 0x5457, 0xc73f, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xf7de, 0xffff, 0xf7ff, 
	0x9e1b, 0x1b14, 0x0316, 0x0316, 0x0337, 0x039a, 0x0c5e, 0x0c7f, 0x045f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x049f, 0x047f, 0x047f, 0x1c3c, 0x8e3f, 0xdfdf, 0xf7ff, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xefff, 0x96ff, 0x351c, 0x0c9d, 0x04df, 0x04df, 0x04ff, 0x04df, 0x04df, 0x04df, 
	0x04df, 0x04df, 0x04df, 0x04df, 0x04ff, 0x04ff, 0x0c9c, 0x2cfb, 0x8ebf, 0xe7ff, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xefff, 0x8559, 0x1b13, 0x0af5, 0x0b37, 0x0337, 0x0357, 0x0b36, 0x0af3, 0x2bd6, 0x4458, 
	0x3c17, 0x1b75, 0x0ad3, 0x1313, 0x6d5a, 0xe7df, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xb69d, 0x33d7, 0x0316, 0x0336, 
	0x0337, 0x0379, 0x0bfd, 0x0c7f, 0x0c9f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x1c3c, 0x759d, 0xdfdf, 0xf7ff, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 
	0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xefff, 0x96df, 0x2cfc, 0x0cbd, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 
	0x04ff, 0x04ff, 0x0cbc, 0x351b, 0x96df, 0xefff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xf7ff, 0xc73f, 0x43f4, 0x0b14, 0x0316, 0x0337, 0x0316, 0x0356, 0x0b34, 0x4c78, 0x965e, 0xb71f, 0xaeff, 0x5cfa, 0x2375, 0x02d3, 
	0x2374, 0xc73f, 0xefdf, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xc71e, 0x3c17, 0x0315, 0x0336, 0x0337, 0x0358, 0x0bfc, 0x0c5f, 
	0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x1c5c, 0x6d7c, 0xd7bf, 0xf7ff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xefff, 0x8ebf, 
	0x24bc, 0x0cbe, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04ff, 0x04df, 0x0cbd, 0x3d1b, 
	0x9eff, 0xefff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xaebf, 0x1b12, 0x0af4, 
	0x0b56, 0x0357, 0x0316, 0x0315, 0x33d6, 0xa69e, 0xefff, 0xf7ff, 0xe7ff, 0xcf9f, 0x651a, 0x0b14, 0x1b54, 0x95fb, 0xefff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xd79f, 0x4c79, 0x0b36, 0x0315, 0x0336, 0x0338, 0x03dc, 0x045e, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x145c, 0x5d3b, 0xcf9f, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xefff, 0x86bf, 0x1c9c, 0x0cbe, 0x04df, 0x04df, 
	0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x0cbd, 0x3d3b, 0xa71f, 0xefff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0x8dfc, 0x1333, 0x0b55, 0x0356, 0x0357, 0x0336, 0x02f4, 
	0x54fa, 0xcf5f, 0xf7ff, 0xffff, 0xf7ff, 0xefff, 0x965e, 0x1355, 0x1314, 0x7539, 0xdfdf, 0xffff, 0xfffe, 0xffff, 0xffff, 0xf7ff, 
	0xcf7f, 0x54b9, 0x0b35, 0x0315, 0x0336, 0x0337, 0x03db, 0x045e, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x145c, 0x551b, 0xc79f, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xe7ff, 0x765f, 0x149c, 0x0cbe, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 
	0x04df, 0x04ff, 0x04ff, 0x04ff, 0x04df, 0x04df, 0x0cbd, 0x455b, 0xaf3f, 0xefff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffdf, 0xe7df, 0x7d9c, 0x1334, 0x0b35, 0x0336, 0x0336, 0x0315, 0x02f4, 0x5cfa, 0xd79f, 0xf7ff, 0xffff, 
	0xf7ff, 0xe7ff, 0x963d, 0x1334, 0x0af4, 0x6d18, 0xdf9f, 0xffff, 0xffde, 0xffff, 0xf7df, 0xf7ff, 0xd79f, 0x5d1a, 0x0315, 0x0315, 
	0x0336, 0x0337, 0x03db, 0x045e, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x049f, 
	0x147c, 0x4cfb, 0xbf7f, 0xf7ff, 0xffde, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 
	0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xe7ff, 0x6e5f, 0x14bc, 0x0cbe, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04ff, 0x04ff, 0x04ff, 
	0x04ff, 0x04df, 0x0cbd, 0x453b, 0xaf3f, 0xefff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffdf, 
	0xefff, 0x85fc, 0x1334, 0x0315, 0x0336, 0x0357, 0x0315, 0x0315, 0x2bf7, 0x9e5e, 0xe7ff, 0xf7ff, 0xe7ff, 0xbf5f, 0x5cf9, 0x02f4, 
	0x1b55, 0x7d59, 0xdf9f, 0xffff, 0xfffe, 0xffff, 0xf7ff, 0xf7ff, 0xd77f, 0x5cfa, 0x0315, 0x0315, 0x0336, 0x0337, 0x0bfb, 0x0c5e, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x049e, 0x147c, 0x4d1b, 0xbf7f, 0xefff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xe7ff, 0x6e7f, 
	0x14bd, 0x0cde, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04df, 0x0cbd, 0x451a, 
	0x9f1f, 0xefff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xefff, 0xa6bf, 0x2375, 0x02f5, 
	0x0337, 0x0b57, 0x0337, 0x0336, 0x0335, 0x3c17, 0x85fd, 0xaf1f, 0xa6df, 0x54fa, 0x1b55, 0x0315, 0x1334, 0x9e1b, 0xefdf, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xcf5f, 0x54d9, 0x0315, 0x0336, 0x0357, 0x0337, 0x0bfa, 0x0c7e, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x049e, 0x147c, 0x4d3b, 0xbf9f, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xe7ff, 0x6e5f, 0x14bd, 0x0cde, 0x04df, 0x04df, 
	0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04df, 0x0cbd, 0x3cfa, 0x9ede, 0xefff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xcf9f, 0x3bb5, 0x0af4, 0x0316, 0x02f6, 0x0b78, 0x0316, 
	0x0336, 0x1356, 0x1b96, 0x2396, 0x2396, 0x0b15, 0x0b36, 0x0314, 0x33d5, 0xc71e, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 
	0xc71e, 0x4c98, 0x0315, 0x0336, 0x0337, 0x0337, 0x0bfa, 0x047e, 0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x049f, 0x049f, 0x049f, 0x145c, 0x553b, 0xc7bf, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xe7ff, 0x765f, 0x149c, 0x0cde, 0x04df, 0x04df, 0x04df, 0x04df, 0x04ff, 0x04ff, 
	0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04df, 0x0cbd, 0x2c9a, 0x865e, 0xe7ff, 0xf7ff, 0xffde, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xefff, 0x8dbb, 0x1b14, 0x02f5, 0x0b58, 0x0317, 0x0338, 0x0358, 0x0b57, 0x02f6, 0x0b16, 
	0x02d5, 0x0b58, 0x0315, 0x1b54, 0x757a, 0xefff, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xbf1f, 0x3c16, 0x0315, 0x0b57, 
	0x0337, 0x0378, 0x0c1b, 0x0c7e, 0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x049f, 0x047f, 0x047f, 
	0x145d, 0x5d7c, 0xcfbf, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 
	0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xe7ff, 0x765f, 0x149c, 0x0cde, 0x04df, 0x04df, 0x04df, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 
	0x04ff, 0x04df, 0x0cbe, 0x247b, 0x7dfd, 0xefff, 0xffff, 0xffdf, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xd79f, 0x6d19, 0x1313, 0x0b15, 0x0317, 0x0b58, 0x0317, 0x0316, 0x02f6, 0x0358, 0x0b78, 0x0316, 0x0ad3, 0x5cb8, 
	0xc77f, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xae9d, 0x2394, 0x0315, 0x0337, 0x0337, 0x0358, 0x041b, 0x047e, 
	0x047e, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x049f, 0x047f, 0x047f, 0x145d, 0x6dbd, 0xcfdf, 0xefff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xe7ff, 0x765f, 
	0x149c, 0x0cde, 0x04df, 0x04df, 0x04df, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04df, 0x0cbe, 0x145b, 
	0x659d, 0xe7ff, 0xffff, 0xffdf, 0xffdf, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7df, 0xffff, 0xc71e, 
	0x6cd8, 0x2354, 0x0b15, 0x0315, 0x02f6, 0x0316, 0x0357, 0x0336, 0x0335, 0x1b34, 0x64f9, 0xbede, 0xf7ff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xefff, 0x95fb, 0x1313, 0x0316, 0x0316, 0x0337, 0x0378, 0x041c, 0x047e, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x049f, 0x047f, 0x047f, 0x1c5c, 0x7e3e, 0xdfff, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xe7ff, 0x765f, 0x149c, 0x0cde, 0x04df, 0x04df, 
	0x04df, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04df, 0x0cde, 0x0c5c, 0x555d, 0xd77f, 0xffdf, 0xffdf, 
	0xffdf, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xd77f, 0x8dfc, 0x5498, 0x33b6, 
	0x1b34, 0x0af3, 0x0b13, 0x1b74, 0x4c98, 0x85fc, 0xc75f, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xe7ff, 
	0x7d9a, 0x0af3, 0x0316, 0x0336, 0x0357, 0x0399, 0x043c, 0x0c9f, 0x04bf, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x049f, 0x047f, 0x047f, 0x1c5b, 0x8e5e, 0xe7ff, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xe7ff, 0x765f, 0x149c, 0x0cde, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 
	0x04df, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04df, 0x04df, 0x049d, 0x2c9b, 0xa67d, 0xf7ff, 0xffdf, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xefff, 0xcf3f, 0xa63c, 0x8d9a, 0x8dba, 0x8dda, 0x9e5b, 
	0xcf7f, 0xefff, 0xf7ff, 0xffff, 0xffdf, 0xffdf, 0xffff, 0xffdf, 0xffdf, 0xffff, 0xf7ff, 0xc75f, 0x5497, 0x02f4, 0x0336, 0x0336, 
	0x0337, 0x03ba, 0x043c, 0x049f, 0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x049f, 0x049f, 0x047e, 
	0x1c1a, 0xa6df, 0xefff, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 
	0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xe7ff, 0x765f, 0x14bc, 0x0cde, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04ff, 0x04ff, 0x04ff, 
	0x04ff, 0x04df, 0x04df, 0x04be, 0x1c7b, 0x757a, 0xefff, 0xffff, 0xffdf, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xefff, 0xefff, 0xefff, 0xefff, 0xf7ff, 0xffff, 0xffde, 0xffdf, 
	0xffdf, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xefff, 0x9e7e, 0x2374, 0x02f4, 0x0336, 0x0336, 0x0337, 0x03db, 0x045d, 0x047f, 
	0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x049f, 0x049f, 0x049f, 0x0c7e, 0x2c9b, 0xbf3f, 0xf7ff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xe7ff, 0x765f, 
	0x14bc, 0x0cde, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04df, 0x04ff, 0x04df, 
	0x0c5b, 0x44b9, 0xc77f, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xf7df, 0xf7ff, 0xffff, 0xf7ff, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xe7df, 0x755b, 0x0b13, 0x0315, 0x0336, 0x0336, 0x0378, 0x041c, 0x047e, 0x047e, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x049f, 0x049f, 0x049f, 0x0c7d, 0x453d, 0xcf9f, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xe7ff, 0x765f, 0x14bc, 0x0cde, 0x04df, 0x04df, 
	0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04df, 0x047c, 0x2c79, 0x8e5d, 0xefff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xbeff, 0x4437, 
	0x0b35, 0x0336, 0x0337, 0x0337, 0x0399, 0x043d, 0x047f, 0x047e, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x049f, 0x049f, 0x047e, 0x0c7d, 0x5d9e, 0xcf9f, 0xf7df, 0xffdf, 0xffdf, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xe7ff, 0x765f, 0x0c7b, 0x0cde, 0x04df, 0x04df, 0x04ff, 0x04df, 0x04df, 0x04df, 
	0x04df, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x0cde, 0x143a, 0x44b8, 0xdfff, 0xf7ff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xefff, 0x857a, 0x1b54, 0x0316, 0x0b37, 0x0317, 0x0338, 
	0x03db, 0x0c7e, 0x047f, 0x047f, 0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x049f, 0x047e, 0x047d, 0x1c9d, 
	0x869f, 0xe7ff, 0xffff, 0xffdf, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 
	0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xe7ff, 0x765f, 0x0c7b, 0x0cbe, 0x04df, 0x04df, 0x04ff, 0x04df, 0x04df, 0x04df, 0x04df, 0x04ff, 0x04ff, 0x04ff, 
	0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04de, 0x045b, 0x2459, 0x963c, 0xf7ff, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xefff, 0xb6ff, 0x4416, 0x1334, 0x0336, 0x0337, 0x0317, 0x0379, 0x041c, 0x047f, 0x049f, 0x049f, 
	0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x045e, 0x045c, 0x2c9b, 0xa71f, 0xefff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xefff, 0x765f, 
	0x0c7b, 0x049d, 0x04df, 0x04df, 0x04ff, 0x04df, 0x04df, 0x04df, 0x04df, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 
	0x04de, 0x049e, 0x0c1a, 0x4497, 0xcf9f, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 
	0xdfdf, 0x757a, 0x1334, 0x0315, 0x0336, 0x0337, 0x0338, 0x03db, 0x0c5d, 0x047f, 0x049f, 0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x0c3c, 0x553c, 0xcf9f, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xefff, 0x765f, 0x145b, 0x049d, 0x04bf, 0x04df, 
	0x04ff, 0x04df, 0x04df, 0x04df, 0x04df, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04de, 0x04df, 0x04bf, 0x0c9d, 0x13b6, 
	0x759b, 0xe7ff, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xefff, 0x9e7d, 0x2bf6, 0x0315, 0x0315, 
	0x0336, 0x0337, 0x0379, 0x03fc, 0x0c7e, 0x047f, 0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x049f, 0x1c3b, 0x861e, 0xe7ff, 0xffff, 0xffdf, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xefff, 0x763f, 0x145b, 0x047d, 0x04bf, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 
	0x04df, 0x04df, 0x04df, 0x04df, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04df, 0x04ff, 0x0cbe, 0x0bfa, 0x23d6, 0xa65d, 0xf7ff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7de, 0xf7ff, 0xbf7f, 0x4c98, 0x02f3, 0x0356, 0x0357, 0x0336, 0x0358, 0x0bfb, 0x0c7e, 
	0x047e, 0x049f, 0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047e, 0x2cbb, 0xb75f, 
	0xefff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 
	0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffdf, 0xefff, 0x763f, 0x145b, 0x0c7d, 0x049f, 0x04bf, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 
	0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04df, 0x04ff, 0x04df, 0x0cbe, 0x0bb8, 0x4437, 0xbeff, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xcf7f, 0x5cfa, 0x1355, 0x0315, 0x0356, 0x0377, 0x0357, 0x03b9, 0x0c3c, 0x0c7e, 0x049f, 0x049f, 0x049f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047e, 0x0c5b, 0x559d, 0xd7ff, 0xf7ff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xefff, 0x763f, 
	0x145b, 0x0c7d, 0x049e, 0x04bf, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 
	0x04df, 0x04df, 0x0cff, 0x0cff, 0x0c3c, 0x0b36, 0x54b9, 0xb6de, 0xf7ff, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xdfff, 0x755a, 0x1314, 
	0x02f5, 0x0336, 0x0356, 0x0377, 0x0398, 0x0c1b, 0x0c5d, 0x047e, 0x049f, 0x049f, 0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x0c7d, 0x2c9b, 0x8e9f, 0xe7ff, 0xf7df, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xefff, 0x763f, 0x145b, 0x0c7e, 0x047f, 0x049f, 
	0x04bf, 0x04df, 0x04df, 0x04df, 0x04df, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x0cff, 0x04bf, 
	0x0cbf, 0x0c1b, 0x0315, 0x5cf9, 0xc73f, 0xefff, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xefff, 0x7d9a, 0x2354, 0x0b15, 0x0316, 0x0b57, 0x0337, 0x0358, 
	0x03ba, 0x147d, 0x0c7e, 0x047e, 0x047f, 0x049f, 0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x145c, 0x4d1b, 0xc79f, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xefff, 0x7e1f, 0x143b, 0x0c5e, 0x047f, 0x049f, 0x04bf, 0x04df, 0x04ff, 0x04ff, 
	0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04df, 0x04df, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04df, 0x0cdf, 0x14de, 0x03fa, 0x0335, 
	0x4c98, 0xbf3f, 0xefff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffde, 
	0xffde, 0xffff, 0xf7ff, 0xcf7f, 0x7d7b, 0x1b34, 0x02f4, 0x0b36, 0x0356, 0x0337, 0x0338, 0x03ba, 0x0c5d, 0x0c7e, 0x047f, 0x047f, 
	0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x049f, 0x049f, 0x0c7e, 0x1c3b, 0x863e, 0xdfdf, 0xffff, 
	0xffdf, 0xffdf, 0xffdf, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 
	0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xefff, 0x7e1f, 0x1c1b, 0x0c3e, 0x047f, 0x047e, 0x049f, 0x04df, 0x04ff, 0x04ff, 0x04df, 0x04df, 0x04ff, 0x04ff, 
	0x04ff, 0x04df, 0x04df, 0x04ff, 0x04ff, 0x04df, 0x04df, 0x04df, 0x04df, 0x0cde, 0x0c9d, 0x03fa, 0x0335, 0x4c78, 0xb6bf, 0xefff, 
	0xf7df, 0xffff, 0xffdf, 0xffbf, 0xf7be, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xefff, 0xc75f, 0x6d3a, 
	0x1b14, 0x02f5, 0x0316, 0x0316, 0x0317, 0x0358, 0x039a, 0x041c, 0x0c7f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x049f, 0x047e, 0x147d, 0x44fc, 0xbf5f, 0xf7ff, 0xffff, 0xffde, 0xffdf, 0xffdf, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xefff, 0x7e1f, 
	0x1c1b, 0x0c3d, 0x045f, 0x047e, 0x047e, 0x04bf, 0x04df, 0x04df, 0x04df, 0x04df, 0x04ff, 0x04ff, 0x04ff, 0x04df, 0x04df, 0x04df, 
	0x04df, 0x04df, 0x04df, 0x04df, 0x04ff, 0x04ff, 0x04be, 0x049d, 0x03da, 0x02f5, 0x33b6, 0x859c, 0xd77f, 0xefff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7df, 0xffff, 0xf7ff, 0xe7ff, 0x9e7d, 0x4c77, 0x0b13, 0x02f4, 0x0b36, 0x0317, 0x0317, 
	0x0339, 0x03bb, 0x041d, 0x0c7f, 0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x049f, 0x047f, 0x047f, 
	0x047f, 0x049f, 0x0c5d, 0x2cbc, 0x7e5f, 0xe7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xefff, 0x7e1f, 0x1c1b, 0x0c3d, 0x045e, 0x045e, 
	0x047e, 0x049e, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 
	0x04df, 0x04df, 0x04df, 0x04bf, 0x14be, 0x0bdb, 0x02d5, 0x1b34, 0x64b8, 0xaebd, 0xdfbf, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xf7ff, 0xefff, 0xe7ff, 0xb6de, 0x7559, 0x33f5, 0x02f3, 0x0315, 0x0b56, 0x0337, 0x0317, 0x0339, 0x03bb, 0x041d, 0x047e, 0x049f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 0x143c, 0x4d1b, 
	0xbfbf, 0xefff, 0xf7de, 0xf7be, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xefff, 0x7dff, 0x13fa, 0x0c1d, 0x043e, 0x043e, 0x045e, 0x047e, 0x049f, 0x04bf, 
	0x04bf, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 
	0x0cbf, 0x149e, 0x0bfb, 0x0336, 0x0b14, 0x2bd6, 0x6519, 0xa69e, 0xd7bf, 0xf7ff, 0xffff, 0xffff, 0xf7ff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffdf, 0xffdf, 0xffdf, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xffff, 0xf7ff, 0xdf9f, 0xb6ff, 0x7d7b, 0x3bf6, 
	0x0ad3, 0x0b15, 0x0b35, 0x0b56, 0x0337, 0x0317, 0x0338, 0x037a, 0x0c1d, 0x047f, 0x049f, 0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x0c7f, 0x0c7e, 0x2c7b, 0x967e, 0xefff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xfffe, 0xfffe, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 
	0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xefff, 0x7dff, 0x1bfa, 0x0bfd, 0x041e, 0x041e, 0x043e, 0x045e, 0x047e, 0x049f, 0x04bf, 0x04bf, 0x04df, 0x04df, 
	0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x0cbf, 0x047e, 0x0c9e, 0x0c3b, 
	0x03b9, 0x0336, 0x0314, 0x2374, 0x5c97, 0x9e3c, 0xbf1e, 0xd79f, 0xe7ff, 0xefff, 0xf7ff, 0xf7ff, 0xf7ff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xefff, 0xf7ff, 0xefff, 0xe7ff, 0xdfdf, 0xc75f, 0xae7c, 0x7d7a, 0x3bf5, 0x0af3, 0x02d4, 0x0b57, 0x0337, 0x0336, 0x0336, 
	0x0337, 0x0379, 0x0bdb, 0x0c3d, 0x0c9f, 0x049f, 0x049f, 0x049f, 0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x0c5e, 0x13fa, 0x65be, 0xd7bf, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xfffe, 
	0xfffe, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xefff, 0x7dff, 
	0x1bfa, 0x0bfd, 0x041e, 0x041e, 0x041e, 0x043e, 0x045e, 0x047e, 0x049f, 0x04bf, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 
	0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04ff, 0x04ff, 0x0cde, 0x047c, 0x03d9, 0x0377, 0x0356, 
	0x0b55, 0x1333, 0x33f6, 0x5cf9, 0x8e5d, 0xaedf, 0xb6ff, 0xbf5f, 0xc77f, 0xcf9f, 0xcf9f, 0xcf9f, 0xcf9f, 0xc77f, 0xbf5f, 0xa6ff, 
	0x967e, 0x655a, 0x3c37, 0x1b54, 0x0ad3, 0x0b55, 0x0335, 0x0336, 0x0316, 0x0336, 0x0357, 0x0378, 0x03b9, 0x0c1c, 0x0c5e, 0x0c9f, 
	0x0c9f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x145c, 0x4cfb, 0xb71f, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffdf, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xefff, 0x7dff, 0x1bda, 0x0bfd, 0x03fe, 0x03fe, 
	0x041e, 0x043d, 0x043e, 0x045e, 0x047e, 0x04bf, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 
	0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x051f, 0x04df, 0x04df, 0x0cde, 0x0c7d, 0x0c5c, 0x03d9, 0x0378, 0x02f5, 0x0315, 0x0b54, 
	0x0b13, 0x1b12, 0x2b73, 0x3c15, 0x4c77, 0x54b8, 0x5cb8, 0x5cb8, 0x5cb8, 0x4436, 0x33d5, 0x1b54, 0x1333, 0x02f4, 0x0315, 0x0356, 
	0x0336, 0x0357, 0x0377, 0x02f5, 0x0357, 0x0337, 0x0378, 0x03fa, 0x0c5d, 0x045e, 0x0c9f, 0x049f, 0x045f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x0c5d, 0x243a, 0x9e9f, 0xe7ff, 0xefff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffdf, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xefff, 0x7dfe, 0x13b9, 0x0bdc, 0x03fe, 0x03fe, 0x041e, 0x041e, 0x041d, 0x043e, 
	0x045e, 0x047f, 0x04bf, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 
	0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04be, 0x049d, 0x043c, 0x03d9, 0x0378, 0x0336, 0x0336, 0x02f5, 0x0b15, 0x0b35, 
	0x0b35, 0x0b35, 0x0b35, 0x0b35, 0x0b35, 0x0b35, 0x0b35, 0x0b35, 0x0b36, 0x0336, 0x0337, 0x0357, 0x0357, 0x0337, 0x0357, 0x0378, 
	0x03b9, 0x03fb, 0x0c3d, 0x0c7e, 0x0c7e, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x045f, 0x0c3d, 0x245b, 0x761e, 0xe7ff, 0xf7ff, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 
	0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xefff, 0x7dfe, 0x13b9, 0x03bc, 0x03de, 0x03fe, 0x041e, 0x041d, 0x041d, 0x041d, 0x043e, 0x045e, 0x047f, 0x04bf, 
	0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 
	0x04df, 0x04ff, 0x04ff, 0x04df, 0x0cbe, 0x0c9d, 0x0c5c, 0x041b, 0x03da, 0x0378, 0x0358, 0x0337, 0x0317, 0x0317, 0x0337, 0x0337, 
	0x0337, 0x0317, 0x0317, 0x0337, 0x0337, 0x0358, 0x0378, 0x0378, 0x0379, 0x03ba, 0x03fb, 0x0c1c, 0x0c5d, 0x0c7e, 0x0c7e, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047e, 0x0c3d, 0x1c3b, 0x659d, 0xbf7f, 0xefff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xefff, 0x7dfe, 
	0x13b9, 0x0bbc, 0x03dd, 0x03dd, 0x03dd, 0x03fd, 0x03fd, 0x041d, 0x041d, 0x043e, 0x045e, 0x049f, 0x04bf, 0x04bf, 0x04bf, 0x04bf, 
	0x04bf, 0x04bf, 0x04bf, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 
	0x04df, 0x0cdf, 0x0cde, 0x0cbe, 0x049d, 0x0c5d, 0x0c3c, 0x03fb, 0x03db, 0x039a, 0x0399, 0x0399, 0x0399, 0x0379, 0x0379, 0x0399, 
	0x0399, 0x03db, 0x03db, 0x03fb, 0x03fc, 0x045d, 0x0c7e, 0x0c7f, 0x0c7f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047e, 0x047e, 0x049f, 0x0c7d, 0x0c1a, 0x5d9d, 0xbf5f, 
	0xefff, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xefff, 0x7dde, 0x1399, 0x0bbc, 0x03bd, 0x03bd, 
	0x03dd, 0x03dd, 0x0bfd, 0x0bfd, 0x041d, 0x041e, 0x043e, 0x045e, 0x047f, 0x049f, 0x049f, 0x049f, 0x049f, 0x04bf, 0x04bf, 0x04df, 
	0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 
	0x04df, 0x0cbf, 0x0cbf, 0x0c9e, 0x0c7e, 0x045e, 0x0c5d, 0x0c5d, 0x0c5d, 0x045d, 0x045d, 0x0c5d, 0x045d, 0x047e, 0x047e, 0x047e, 
	0x047e, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047e, 0x0c7d, 0x145b, 0x555d, 0xaf3f, 0xe7ff, 0xf7ff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xefff, 0x7dde, 0x1398, 0x0b9b, 0x03bd, 0x03bd, 0x03bd, 0x03bc, 0x03dd, 0x03dd, 
	0x03dd, 0x03fd, 0x041d, 0x043e, 0x043e, 0x047e, 0x049f, 0x049f, 0x049f, 0x049f, 0x04bf, 0x04bf, 0x04bf, 0x04df, 0x04df, 0x04df, 
	0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x0cbf, 0x0cbf, 
	0x04bf, 0x04bf, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x0cdf, 0x0cdf, 0x0cbf, 0x049f, 0x049f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x049f, 0x047f, 
	0x047f, 0x049f, 0x0c9e, 0x147c, 0x451b, 0xb73f, 0xe7ff, 0xf7ff, 0xf7df, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 
	0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xefff, 0x7ddd, 0x1398, 0x0b9b, 0x039c, 0x03bd, 0x03bd, 0x0bbc, 0x0bbc, 0x0bbd, 0x0bbd, 0x03dd, 0x03dd, 0x03fd, 
	0x041d, 0x045e, 0x047e, 0x049f, 0x049f, 0x049f, 0x049f, 0x04bf, 0x04bf, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 
	0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04ff, 
	0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04df, 0x04bf, 0x049f, 0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x049f, 0x049f, 0x047f, 0x047f, 0x043d, 0x145b, 0x4d7c, 
	0xa71f, 0xe7ff, 0xffff, 0xffff, 0xffdf, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xefff, 0x7ddd, 
	0x1b98, 0x0b9b, 0x039c, 0x0b9c, 0x0b9c, 0x0bbc, 0x0bbc, 0x0bbd, 0x0bbd, 0x0bbd, 0x03dd, 0x03dd, 0x03fd, 0x041d, 0x045e, 0x047e, 
	0x049f, 0x049f, 0x049f, 0x04bf, 0x04bf, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 
	0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04ff, 
	0x04df, 0x04bf, 0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x049e, 0x049f, 0x049f, 0x0c7e, 0x247b, 0x5d7c, 0xaf1f, 0xe7ff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xefff, 0x7ddd, 0x1b78, 0x0b7b, 0x037c, 0x037c, 
	0x0b9c, 0x0bbc, 0x0bbd, 0x0bbd, 0x0bbd, 0x0bbd, 0x0bbd, 0x0bbd, 0x03dd, 0x03fd, 0x041d, 0x043e, 0x047e, 0x047f, 0x049f, 0x049f, 
	0x04bf, 0x04bf, 0x04df, 0x04df, 0x04bf, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04ff, 0x04ff, 
	0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04bf, 0x049e, 0x047e, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x049f, 0x049f, 
	0x047f, 0x049e, 0x047e, 0x0c7d, 0x1c5b, 0x6dbe, 0xb75f, 0xefff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xefff, 0x7dbd, 0x1337, 0x135a, 0x0b7c, 0x037c, 0x0b7c, 0x0b9c, 0x0b9c, 0x13bc, 
	0x0bbc, 0x0bbd, 0x0bbd, 0x0bbd, 0x03bc, 0x03dd, 0x03dd, 0x03fd, 0x041e, 0x043e, 0x045f, 0x047f, 0x049f, 0x049f, 0x04bf, 0x04bf, 
	0x04bf, 0x04bf, 0x04bf, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 
	0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04ff, 0x04df, 0x04bf, 0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x049f, 0x049f, 0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x049f, 0x049f, 0x049f, 0x047f, 0x047f, 0x041c, 0x34bc, 
	0x865f, 0xcf7f, 0xefff, 0xf7ff, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 
	0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xefff, 0x85be, 0x1b37, 0x133a, 0x0b5c, 0x0b7c, 0x037c, 0x0b7c, 0x137c, 0x139c, 0x13bc, 0x0bbd, 0x0bbc, 0x0b9c, 
	0x0b9c, 0x0bbd, 0x0bbd, 0x03dd, 0x03dd, 0x03fe, 0x041e, 0x043e, 0x045f, 0x047e, 0x049f, 0x04bf, 0x04bf, 0x04bf, 0x04bf, 0x04bf, 
	0x04bf, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 
	0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04bf, 0x04bf, 0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x049f, 0x049f, 0x049f, 
	0x049f, 0x047f, 0x047f, 0x047f, 0x045f, 0x045e, 0x045e, 0x047e, 0x0c7d, 0x143b, 0x453d, 0x96bf, 0xd7df, 0xefff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xefff, 0x85be, 
	0x1b37, 0x0b1a, 0x0b3b, 0x0b5b, 0x0b7b, 0x0b5b, 0x0b7c, 0x0b7c, 0x0b9c, 0x0b9c, 0x0b9c, 0x0b9c, 0x0b9c, 0x0b9c, 0x03bc, 0x03bc, 
	0x03dd, 0x03dd, 0x03fd, 0x041d, 0x043e, 0x045e, 0x049e, 0x049f, 0x04bf, 0x04bf, 0x04bf, 0x04bf, 0x04bf, 0x04bf, 0x04bf, 0x04df, 
	0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 
	0x04df, 0x04bf, 0x04bf, 0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047e, 0x047e, 0x049f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x0c7f, 0x045d, 0x145c, 0x2c9a, 0x763e, 0xb73f, 0xe7ff, 0xf7ff, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xefff, 0x85be, 0x1b37, 0x131a, 0x0b1b, 0x0b5b, 
	0x0b5b, 0x0b5b, 0x0b5b, 0x0b7c, 0x0b7c, 0x0b9c, 0x0b9c, 0x0b9c, 0x0b9c, 0x0b9c, 0x0b9c, 0x03bc, 0x03bc, 0x03dd, 0x03dd, 0x03dd, 
	0x03fd, 0x043d, 0x045e, 0x047e, 0x049f, 0x049f, 0x049f, 0x04bf, 0x049f, 0x04bf, 0x04bf, 0x04bf, 0x04bf, 0x04df, 0x04df, 0x04df, 
	0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04bf, 0x04bf, 0x049f, 
	0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047e, 0x049e, 0x047e, 0x047f, 0x047f, 0x0c7e, 0x0c5e, 0x0bfb, 0x245b, 0x557d, 
	0x8e7f, 0xd7ff, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffde, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xefff, 0x7d9d, 0x12f6, 0x1319, 0x0b1b, 0x0b3b, 0x0b3a, 0x0b5b, 0x0b5b, 0x0b7c, 
	0x0b7c, 0x0b7c, 0x0b7c, 0x0b9c, 0x0b9c, 0x0b9c, 0x039c, 0x0b9c, 0x039c, 0x03bc, 0x03dc, 0x03dc, 0x03fd, 0x03fd, 0x041d, 0x045e, 
	0x047e, 0x047e, 0x047e, 0x049f, 0x049f, 0x049f, 0x049f, 0x04bf, 0x04bf, 0x04bf, 0x04bf, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 
	0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04bf, 0x04bf, 0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 
	0x047f, 0x049f, 0x049f, 0x049e, 0x047f, 0x043e, 0x043e, 0x0c5d, 0x247c, 0x551c, 0x8e3e, 0xc77f, 0xefff, 0xf7ff, 0xffff, 0xffff, 
	0xffff, 0xfffe, 0xfffe, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 
	0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xefff, 0x7d9d, 0x1b17, 0x1319, 0x131b, 0x0b3b, 0x0b3b, 0x0b3b, 0x0b3b, 0x0b3b, 0x0b5b, 0x0b7c, 0x0b7c, 0x0b7c, 
	0x0b7c, 0x0b7c, 0x039c, 0x0b9c, 0x039c, 0x03bc, 0x03bc, 0x03bc, 0x03dc, 0x03dd, 0x03fd, 0x041d, 0x043e, 0x045e, 0x045e, 0x047e, 
	0x047e, 0x047f, 0x049f, 0x049f, 0x049f, 0x04bf, 0x04bf, 0x04bf, 0x04bf, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 
	0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04bf, 0x04bf, 0x049f, 0x047f, 0x047f, 0x047f, 0x049f, 0x047e, 0x047e, 0x047e, 0x0c7d, 
	0x0c5c, 0x143c, 0x2c7c, 0x4d5e, 0x761f, 0xc7bf, 0xe7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xfffe, 0xfffe, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0x85bd, 
	0x2337, 0x1319, 0x0b1a, 0x131a, 0x0b3a, 0x0b1a, 0x0b1b, 0x0b3b, 0x0b5b, 0x0b5b, 0x0b5b, 0x0b7b, 0x0b7b, 0x037b, 0x037b, 0x037b, 
	0x037b, 0x039c, 0x03bc, 0x03bc, 0x03bc, 0x03bc, 0x03dd, 0x03dd, 0x03fd, 0x041e, 0x043e, 0x045e, 0x045e, 0x045f, 0x047f, 0x047f, 
	0x049f, 0x049f, 0x04bf, 0x04bf, 0x04bf, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 
	0x04df, 0x04bf, 0x04bf, 0x049f, 0x047f, 0x047f, 0x047f, 0x047f, 0x047f, 0x045e, 0x147d, 0x249c, 0x349a, 0x553b, 0x8e3e, 0xc77f, 
	0xe7ff, 0xf7ff, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xfffe, 0xf7ff, 0x8dbd, 0x2b57, 0x1318, 0x0b1a, 0x0b1a, 
	0x0b1a, 0x0b1a, 0x0b1b, 0x0b3b, 0x0b3b, 0x0b5b, 0x035b, 0x0b5b, 0x0b5b, 0x035b, 0x035b, 0x037b, 0x037b, 0x037b, 0x0b9c, 0x0b9c, 
	0x0bbc, 0x0bbc, 0x0bbc, 0x03dd, 0x03dd, 0x03dd, 0x03fd, 0x041d, 0x043e, 0x043e, 0x045e, 0x045f, 0x047f, 0x047f, 0x049f, 0x049f, 
	0x04bf, 0x04bf, 0x04bf, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04ff, 0x04df, 0x04df, 0x04be, 0x049e, 0x047e, 
	0x0c7d, 0x145d, 0x145c, 0x145c, 0x1c5b, 0x247b, 0x4d3d, 0x763f, 0x9edf, 0xcfdf, 0xe7ff, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffde, 0xf7ff, 0xa63e, 0x3b77, 0x12f7, 0x0b19, 0x0af9, 0x131a, 0x0b1a, 0x0b1a, 0x0b3a, 
	0x0b3a, 0x0b3a, 0x033a, 0x0b5b, 0x0b5b, 0x0b5b, 0x035b, 0x0b5b, 0x0b7b, 0x0b7b, 0x0b7b, 0x0b9c, 0x0b9c, 0x0bbc, 0x03bc, 0x0bbc, 
	0x03bc, 0x03dd, 0x03dd, 0x03dd, 0x03fd, 0x0bfe, 0x041e, 0x041e, 0x041e, 0x045e, 0x047e, 0x047f, 0x049f, 0x049f, 0x049f, 0x04bf, 
	0x04bf, 0x04bf, 0x04bf, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04df, 0x04be, 0x0cbd, 0x147b, 0x245b, 0x2c5a, 0x4cdb, 0x6dbd, 
	0x8e5e, 0xb73f, 0xcf9f, 0xdfff, 0xefff, 0xf7ff, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 
	0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffde, 0xffff, 0xc6df, 0x4bd7, 0x12d6, 0x0b19, 0x0af9, 0x0afa, 0x0b1a, 0x0b1a, 0x0b1a, 0x0b3a, 0x0b3a, 0x0b3a, 0x0b3b, 
	0x0b3b, 0x0b3b, 0x0b3b, 0x0b5b, 0x0b5b, 0x0b5b, 0x0b5b, 0x0b7b, 0x0b9c, 0x0b9c, 0x0b9c, 0x0bbc, 0x0bbc, 0x0bbc, 0x0bbc, 0x0bbd, 
	0x0bdd, 0x0bdd, 0x0bde, 0x0bfe, 0x03fe, 0x041d, 0x043e, 0x045e, 0x045e, 0x047e, 0x047e, 0x047f, 0x047f, 0x049e, 0x049e, 0x049f, 
	0x04bf, 0x04be, 0x04be, 0x04bf, 0x0c9d, 0x149c, 0x55ff, 0x7e9f, 0x96bf, 0xaf5f, 0xbf7f, 0xcfbf, 0xdfff, 0xefff, 0xf7ff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xfffe, 0xffff, 0xdf9f, 
	0x6c99, 0x1296, 0x12fa, 0x0ad9, 0x0ad9, 0x0b1a, 0x0b1a, 0x0b1a, 0x0b3a, 0x0b3a, 0x0b3a, 0x0b3b, 0x0b3b, 0x0b3b, 0x0b3b, 0x0b5b, 
	0x0b5b, 0x0b5b, 0x0b5b, 0x0b5b, 0x0b7b, 0x0b7c, 0x0b9c, 0x0b9c, 0x0b9c, 0x0b9c, 0x0bbc, 0x0bbc, 0x0bbd, 0x0bbd, 0x0bbd, 0x0bbd, 
	0x0bdd, 0x03fd, 0x03fd, 0x041d, 0x041e, 0x043e, 0x043e, 0x043e, 0x045e, 0x045e, 0x045e, 0x045e, 0x047e, 0x047e, 0x047e, 0x047d, 
	0x145b, 0x3cfb, 0xa75f, 0xdfff, 0xf7ff, 0xefff, 0xefff, 0xf7ff, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xefdf, 0x853b, 0x1255, 0x12da, 0x12d9, 
	0x0ab9, 0x0af9, 0x0b1a, 0x0b1a, 0x0b1a, 0x0b1a, 0x0b1a, 0x0b3b, 0x0b3b, 0x133b, 0x133b, 0x133b, 0x133b, 0x135b, 0x0b5b, 0x0b5b, 
	0x0b5b, 0x0b7b, 0x0b7b, 0x0b7c, 0x0b7c, 0x0b9c, 0x0b9c, 0x0bbc, 0x0bbc, 0x0b9d, 0x0b9d, 0x0bbd, 0x0bbd, 0x0bdd, 0x03dd, 0x03fd, 
	0x03fd, 0x041d, 0x041d, 0x041e, 0x041e, 0x041d, 0x043d, 0x043e, 0x043e, 0x043e, 0x045e, 0x045d, 0x143a, 0x6dbc, 0xd7ff, 0xf7ff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xae3e, 0x32f7, 0x1258, 0x12ba, 0x0a99, 0x0ad9, 0x0ad9, 0x0af9, 
	0x0af9, 0x0afa, 0x0b1a, 0x0afa, 0x0afa, 0x131a, 0x131a, 0x133b, 0x133b, 0x133b, 0x133b, 0x135b, 0x0b5b, 0x0b5b, 0x0b5b, 0x0b5b, 
	0x0b5b, 0x0b7b, 0x0b9b, 0x0b9c, 0x0b9c, 0x0b9c, 0x03bd, 0x0bbd, 0x0bbd, 0x03dd, 0x03dd, 0x03dd, 0x03dd, 0x03fd, 0x03fd, 0x03fd, 
	0x03fd, 0x03fd, 0x03fd, 0x041d, 0x041d, 0x0c3d, 0x0c3d, 0x0c5e, 0x13f9, 0x967e, 0xe7ff, 0xf7ff, 0xffbf, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 
	0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffdf, 0xffff, 0xf7ff, 0xceff, 0x5c1a, 0x1236, 0x1299, 0x1ada, 0x12d9, 0x0ad9, 0x12d9, 0x0af9, 0x0af9, 0x0af9, 0x0af9, 
	0x12fa, 0x12fa, 0x12fa, 0x131a, 0x131a, 0x131b, 0x133b, 0x133b, 0x135b, 0x0b5b, 0x0b5b, 0x0b5b, 0x0b5b, 0x0b5b, 0x0b7b, 0x0b7b, 
	0x0b9b, 0x0b9c, 0x0b9c, 0x03bc, 0x03bc, 0x03bc, 0x03dd, 0x03dd, 0x03dd, 0x03dd, 0x03dd, 0x0bfd, 0x0bfd, 0x03fd, 0x03fd, 0x03fd, 
	0x03fd, 0x0c1d, 0x0c1d, 0x0c1c, 0x347b, 0xb73f, 0xefff, 0xffff, 0xffdf, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffdf, 0xffff, 0xffff, 
	0xefdf, 0x855c, 0x22b5, 0x1277, 0x1299, 0x12b9, 0x12d9, 0x12d9, 0x12d9, 0x12f9, 0x12f9, 0x12f9, 0x12f9, 0x12fa, 0x12fa, 0x12fa, 
	0x12fa, 0x131a, 0x131a, 0x133b, 0x133b, 0x0b3b, 0x0b5b, 0x0b5b, 0x0b5b, 0x0b5b, 0x0b5b, 0x0b5b, 0x0b7b, 0x0b7c, 0x0b9c, 0x0b9c, 
	0x0b9c, 0x0bbc, 0x0bbc, 0x0bbc, 0x0bbd, 0x0bdd, 0x0bdd, 0x0bfd, 0x0bfd, 0x03fd, 0x03fd, 0x03fd, 0x03fd, 0x041d, 0x0c1d, 0x13fb, 
	0x659e, 0xdfdf, 0xffff, 0xffff, 0xffde, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffdf, 0xffdf, 0xffff, 0xf7ff, 0xb67e, 0x4376, 0x1a96, 
	0x1298, 0x12b9, 0x12d9, 0x12d9, 0x12d9, 0x12d9, 0x12f9, 0x12f9, 0x12f9, 0x12fa, 0x12fa, 0x12fa, 0x0afa, 0x12fa, 0x0b1a, 0x131a, 
	0x131a, 0x0b3b, 0x0b3b, 0x0b3b, 0x0b3b, 0x0b5b, 0x0b5b, 0x0b5b, 0x0b5b, 0x0b7b, 0x0b7b, 0x0b7c, 0x0b7c, 0x0b9c, 0x0b9c, 0x0b9c, 
	0x0b9c, 0x0bbc, 0x03bd, 0x0bdd, 0x03dd, 0x03dd, 0x03fd, 0x0bfd, 0x03fd, 0x03fd, 0x0c1c, 0x2c3a, 0x9edf, 0xefff, 0xffff, 0xffde, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xefbf, 0x853a, 0x1253, 0x1298, 0x1298, 0x1299, 0x12b9, 
	0x12d8, 0x12d8, 0x12d8, 0x0ad8, 0x0ad9, 0x0af9, 0x12fa, 0x12fa, 0x0afa, 0x0afa, 0x0afa, 0x0b1a, 0x0b1a, 0x0b1a, 0x0b3b, 0x0b3b, 
	0x0b5b, 0x0b5b, 0x0b5b, 0x0b5b, 0x0b5b, 0x0b5b, 0x0b5b, 0x0b7b, 0x0b7b, 0x0b7c, 0x0b9c, 0x0b9c, 0x0b9c, 0x0bbc, 0x03bc, 0x03dd, 
	0x03dc, 0x03dd, 0x03dd, 0x0bfe, 0x0bfd, 0x03fd, 0x13fa, 0x5d1a, 0xd7bf, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 
	0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xc6be, 0x4bd7, 0x0a34, 0x1277, 0x1298, 0x12b8, 0x12b8, 0x12b8, 0x12b8, 0x0ab8, 
	0x0ad8, 0x0ad9, 0x0ad9, 0x0ad9, 0x0afa, 0x0afa, 0x0afa, 0x0afa, 0x0afa, 0x0b1a, 0x0b1a, 0x0b3a, 0x0b3a, 0x0b5b, 0x0b5b, 0x0b5b, 
	0x0b5b, 0x0b5b, 0x0b5b, 0x0b5b, 0x0b5b, 0x0b5b, 0x0b7c, 0x0b9c, 0x0b9c, 0x0b9c, 0x03bc, 0x03bc, 0x03bc, 0x0bdc, 0x0bbd, 0x03bd, 
	0x0bdc, 0x0bba, 0x345a, 0xa6be, 0xefff, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xf7ff, 0x959c, 0x2a94, 0x1256, 0x1298, 0x12b7, 0x12b7, 0x12b7, 0x12b8, 0x12b8, 0x0ab8, 0x0ab8, 0x0ab9, 0x0ad9, 
	0x0ad9, 0x0ad9, 0x0afa, 0x0afa, 0x0b1a, 0x0b1a, 0x0b1a, 0x0b1a, 0x0b1a, 0x0b3a, 0x0b3a, 0x0b5b, 0x0b5b, 0x0b3b, 0x0b3b, 0x0b5b, 
	0x0b5b, 0x0b5b, 0x0b7b, 0x0b9b, 0x0b9c, 0x0b9c, 0x03bc, 0x03bc, 0x03bc, 0x0bbc, 0x0bbc, 0x0bbd, 0x0bbc, 0x1bd9, 0x6d7c, 0xe7ff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffdf, 0xffff, 0xd73f, 
	0x7499, 0x1a54, 0x1a77, 0x1a97, 0x1ab7, 0x1a98, 0x12b8, 0x12b8, 0x12b8, 0x12b8, 0x12b8, 0x0ab8, 0x0ab9, 0x0ad9, 0x0ad9, 0x0afa, 
	0x0afa, 0x0b1a, 0x0b1a, 0x0b1a, 0x0b1a, 0x0b1a, 0x0b1a, 0x0b3a, 0x0b3a, 0x0b3b, 0x0b3b, 0x0b3b, 0x0b3b, 0x0b5b, 0x0b5b, 0x0b7b, 
	0x0b9b, 0x0b9c, 0x0b9c, 0x03bc, 0x03bc, 0x0bbc, 0x0bbc, 0x0bbc, 0x139a, 0x54db, 0xc77f, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7df, 0xc6df, 0x5397, 0x2296, 0x1216, 
	0x1258, 0x1278, 0x1278, 0x1298, 0x0a98, 0x0a98, 0x12b8, 0x12b8, 0x12b8, 0x12b9, 0x0ab9, 0x0ad9, 0x0ad9, 0x0afa, 0x0afa, 0x0afa, 
	0x0b1a, 0x0b1a, 0x0b1a, 0x0b1a, 0x0b1a, 0x0b3a, 0x0b3b, 0x0b3b, 0x0b3b, 0x0b5b, 0x0b5b, 0x0b5b, 0x0b7b, 0x0b9b, 0x0b9b, 0x0b9b, 
	0x0b9b, 0x13fd, 0x0b9b, 0x139a, 0x445a, 0xb6ff, 0xe7ff, 0xf7ff, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 
	0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7df, 0xb65f, 0x4b77, 0x11f4, 0x1237, 0x1257, 0x1278, 0x1278, 
	0x1278, 0x1297, 0x1298, 0x1298, 0x12b8, 0x12b8, 0x12b9, 0x0ab9, 0x0ad9, 0x0ada, 0x0ada, 0x0afa, 0x0afa, 0x0afa, 0x0afa, 0x0b1a, 
	0x0b1a, 0x0b1a, 0x0b3a, 0x0b3a, 0x0b3a, 0x0b3a, 0x0b5a, 0x0b5a, 0x0b5b, 0x0b7b, 0x0b7b, 0x0b7b, 0x0b9b, 0x0b9b, 0x0b39, 0x33f9, 
	0x965f, 0xe7ff, 0xffff, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7df, 0xa59c, 0x5398, 0x1a35, 0x1236, 0x1a58, 0x1278, 0x1278, 0x1277, 0x1277, 0x1277, 
	0x1298, 0x1298, 0x12b9, 0x12b9, 0x12b9, 0x12d9, 0x0ad9, 0x12da, 0x0ada, 0x12fa, 0x0afa, 0x0afa, 0x0afa, 0x0afa, 0x0b1a, 0x0b3a, 
	0x0b3a, 0x0b3a, 0x0b5a, 0x0b5a, 0x0b5a, 0x0b5b, 0x0b5b, 0x0b7b, 0x0b7a, 0x1359, 0x33f9, 0x8dbc, 0xe7df, 0xffff, 0xffdf, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffdf, 0xf7ff, 0xa5fe, 0x4336, 0x1a14, 0x1a56, 0x1a57, 0x1278, 0x1277, 0x1277, 0x1277, 0x1277, 0x1298, 0x1298, 0x12b9, 
	0x12b9, 0x12b9, 0x0ab9, 0x0ab9, 0x0ad9, 0x12da, 0x0ad9, 0x12fa, 0x0afa, 0x0afa, 0x0afa, 0x0b1a, 0x0b3a, 0x0b3a, 0x0b3a, 0x0b3a, 
	0x0b3a, 0x0b5b, 0x0b5b, 0x0b5a, 0x1358, 0x33b7, 0x961e, 0xe7df, 0xffff, 0xffdf, 0xffdf, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xefdf, 
	0xbe9f, 0x5bd7, 0x19f3, 0x09d5, 0x1a78, 0x0a57, 0x0a57, 0x0a77, 0x1277, 0x1278, 0x1298, 0x12b9, 0x12d9, 0x12b9, 0x0ab9, 0x12b9, 
	0x12b9, 0x0ab9, 0x12d9, 0x12d9, 0x12f9, 0x12f9, 0x0af9, 0x0afa, 0x0b1a, 0x131a, 0x0afa, 0x12fa, 0x131a, 0x137b, 0x1359, 0x1317, 
	0x4418, 0x9e3d, 0xe7df, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 
	0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffde, 0xffff, 0xffff, 0xefdf, 0xc6df, 0x749a, 0x32b5, 
	0x09d4, 0x1256, 0x1277, 0x1a98, 0x1277, 0x1277, 0x1278, 0x1298, 0x1299, 0x12b9, 0x12b9, 0x12b9, 0x12b9, 0x12b9, 0x12d9, 0x12d9, 
	0x12d9, 0x12f9, 0x12fa, 0x12fa, 0x0afa, 0x0ada, 0x131a, 0x1b1a, 0x1b19, 0x0ad7, 0x2377, 0x5cba, 0xaebf, 0xefff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffdf, 0xffff, 0xffdf, 0xffdf, 0xf7bf, 0xdf7f, 0xa5bc, 0x5bd7, 0x1a13, 0x1214, 0x1215, 
	0x1a77, 0x1257, 0x1278, 0x1278, 0x1278, 0x1298, 0x1299, 0x1299, 0x12b9, 0x12b9, 0x12b9, 0x12d9, 0x12d9, 0x12d9, 0x12da, 0x12da, 
	0x12da, 0x131a, 0x12f9, 0x12b8, 0x12d6, 0x3bd7, 0x8dfd, 0xd77f, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xff9e, 0xffff, 0xffff, 0xefdf, 0xd71f, 0x8d1c, 0x5bd8, 0x2273, 0x1213, 0x1214, 0x1236, 0x1a77, 
	0x1a78, 0x1278, 0x1278, 0x1278, 0x1298, 0x12b8, 0x1298, 0x12b8, 0x12b9, 0x12d9, 0x12d9, 0x12d8, 0x1ad8, 0x0a75, 0x1ad6, 0x4c1a, 
	0x7d7d, 0xbeff, 0xe7df, 0xf7ff, 0xf7df, 0xffff, 0xffff, 0xffff, 0xffdf, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xf7ff, 0xceff, 0x9d9a, 0x7497, 0x53b6, 0x32d5, 0x2255, 0x11f4, 0x1236, 0x0a36, 0x0a36, 
	0x1257, 0x1257, 0x0a56, 0x0a56, 0x0a56, 0x0a35, 0x0a55, 0x22f6, 0x3b97, 0x6479, 0x8d7b, 0xceff, 0xefff, 0xf7ff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 
	0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xfffe, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xf7ff, 0xf7ff, 0xe7bf, 0xbebf, 0x957c, 0x7479, 0x63f9, 0x4b98, 0x4378, 0x3b16, 0x32f6, 0x32f6, 0x3336, 0x3b77, 
	0x43b8, 0x5c39, 0x6479, 0x855c, 0xae7f, 0xdf9f, 0xefdf, 0xffff, 0xffdf, 0xffdf, 0xffdf, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7df, 0xf7df, 
	0xffdf, 0xffff, 0xf7df, 0xf7ff, 0xe77f, 0xcedf, 0xc69e, 0xbe7d, 0xb65d, 0xb63d, 0xb67d, 0xbebe, 0xceff, 0xe79f, 0xefdf, 0xf7ff, 
	0xf7ff, 0xf7ff, 0xffff, 0xffff, 0xffdf, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffdf, 0xffdf, 0xffff, 0xffff, 
	0xffdf, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf7ff, 0xffff, 0xffff, 0xffff, 0xffdf, 0xffdf, 0xf7bf, 0xffdf, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 
	0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 
	0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 
	0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbdf7, 0xbdf7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xbdf7, 0xa514, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 
	0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 
	0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 
	0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 
	0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 
	0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 
	0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 
	0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 
	0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xbdf7, 0xa514
};

// Array of all bitmaps for convenience. (Total bytes used to store images in PROGMEM = 19616)
const int epd_bitmap_allArray_LEN = 1;
const uint16_t* epd_bitmap_allArray[1] = {
	epd_bitmap_image
};

