// amy-example.c
// a simple C example that plays audio using AMY out your speaker 
#ifndef ARDUINO 

#include "amy.h"
#include "examples.h"
#include "libminiaudio-audio.h"

void delay_ms(uint32_t ms) {
    uint32_t start = amy_sysclock();
    while(amy_sysclock() - start < ms) usleep(THREAD_USLEEP);
}

int main(int argc, char ** argv) {
    amy_config_t amy_config = amy_default_config();
    amy_config.audio = AMY_AUDIO_IS_MINIAUDIO;
    amy_config.features.default_synths = 0;
    amy_start(amy_config);
    
    amy_live_start();

	amy_add_message("S16384Z");
	amy_add_message("t0V5Z");
	amy_add_message("K1024uv0w10Zv21w9ZZ");
	amy_add_message("K1024r0,1,2Z");
	amy_add_message("v0w11a,,,0r0,1,2p20Z");
	amy_add_message("v1w9A0,0,4,0,4,0,4,0,4,0,8,0,8,0,16,0,16,0,32,0,32,0,64,0,64,0,128,0,128,0,256,0,256,0,512,0,512,0,1024,0,1024,0,200,0T3r0,1,2Z");
	amy_add_message("v2w9A0,0,4,0,4,0,4,0,4,0,8,0,8,0,16,0,16,0,32,0,32,0,64,0,64,0,128,0,128,0,256,0,256,0,512,0,512,0,1024,0,1024,0,200,0T3r0,1,2Z");
	amy_add_message("v3w9A0,0,4,0,4,0,4,0,4,0,8,0,8,0,16,0,16,0,32,0,32,0,64,0,64,0,128,0,128,0,256,0,256,0,512,0,512,0,1024,0,1024,0,200,0T3r0,1,2Z");
	amy_add_message("v4w9A0,0,4,0,4,0,4,0,4,0,8,0,8,0,16,0,16,0,32,0,32,0,64,0,64,0,128,0,128,0,256,0,256,0,512,0,512,0,1024,0,1024,0,200,0T3r0,1,2Z");
	amy_add_message("v5w9A0,0,4,0,4,0,4,0,4,0,8,0,8,0,16,0,16,0,32,0,32,0,64,0,64,0,128,0,128,0,256,0,256,0,512,0,512,0,1024,0,1024,0,200,0T3r0,1,2Z");
	amy_add_message("v6w9A0,0,4,0,4,0,4,0,4,0,8,0,8,0,16,0,16,0,32,0,32,0,64,0,64,0,128,0,128,0,256,0,256,0,512,0,512,0,1024,0,1024,0,200,0T3r0,1,2Z");
	amy_add_message("v7w9A0,0,4,0,4,0,4,0,4,0,8,0,8,0,16,0,16,0,32,0,32,0,64,0,64,0,128,0,128,0,256,0,256,0,512,0,512,0,1024,0,1024,0,200,0T3r0,1,2Z");
	amy_add_message("v8w9A0,0,4,0,4,0,4,0,4,0,8,0,8,0,16,0,16,0,32,0,32,0,64,0,64,0,128,0,128,0,256,0,256,0,512,0,512,0,1024,0,1024,0,200,0T3r0,1,2Z");
	amy_add_message("v9w9A0,0,4,0,4,0,4,0,4,0,8,0,8,0,16,0,16,0,32,0,32,0,64,0,64,0,128,0,128,0,256,0,256,0,512,0,512,0,1024,0,1024,0,200,0T3r0,1,2Z");
	amy_add_message("v10w9A0,0,4,0,4,0,4,0,4,0,8,0,8,0,16,0,16,0,32,0,32,0,64,0,64,0,128,0,128,0,256,0,256,0,512,0,512,0,1024,0,1024,0,200,0T3r0,1,2Z");
	amy_add_message("v11w9A0,0,4,0,4,0,4,0,4,0,8,0,8,0,16,0,16,0,32,0,32,0,64,0,64,0,128,0,128,0,256,0,256,0,512,0,512,0,1024,0,1024,0,200,0T3r0,1,2Z");
	amy_add_message("v12w9A0,0,4,0,4,0,4,0,4,0,8,0,8,0,16,0,16,0,32,0,32,0,64,0,64,0,128,0,128,0,256,0,256,0,512,0,512,0,1024,0,1024,0,200,0T3r0,1,2Z");
	amy_add_message("v13w9A0,0,4,0,4,0,4,0,4,0,8,0,8,0,16,0,16,0,32,0,32,0,64,0,64,0,128,0,128,0,256,0,256,0,512,0,512,0,1024,0,1024,0,200,0T3r0,1,2Z");
	amy_add_message("v14w9A0,0,4,0,4,0,4,0,4,0,8,0,8,0,16,0,16,0,32,0,32,0,64,0,64,0,128,0,128,0,256,0,256,0,512,0,512,0,1024,0,1024,0,200,0T3r0,1,2Z");
	amy_add_message("v15w9A0,0,4,0,4,0,4,0,4,0,8,0,8,0,16,0,16,0,32,0,32,0,64,0,64,0,128,0,128,0,256,0,256,0,512,0,512,0,1024,0,1024,0,200,0T3r0,1,2Z");
	amy_add_message("v16w9A0,0,4,0,4,0,4,0,4,0,8,0,8,0,16,0,16,0,32,0,32,0,64,0,64,0,128,0,128,0,256,0,256,0,512,0,512,0,1024,0,1024,0,200,0T3r0,1,2Z");
	amy_add_message("v17w9A0,0,4,0,4,0,4,0,4,0,8,0,8,0,16,0,16,0,32,0,32,0,64,0,64,0,128,0,128,0,256,0,256,0,512,0,512,0,1024,0,1024,0,200,0T3r0,1,2Z");
	amy_add_message("v18w9A0,0,4,0,4,0,4,0,4,0,8,0,8,0,16,0,16,0,32,0,32,0,64,0,64,0,128,0,128,0,256,0,256,0,512,0,512,0,1024,0,1024,0,200,0T3r0,1,2Z");
	amy_add_message("v19w9A0,0,4,0,4,0,4,0,4,0,8,0,8,0,16,0,16,0,32,0,32,0,64,0,64,0,128,0,128,0,256,0,256,0,512,0,512,0,1024,0,1024,0,200,0T3r0,1,2Z");
	amy_add_message("v20w9A0,0,4,0,4,0,4,0,4,0,8,0,8,0,16,0,16,0,32,0,32,0,64,0,64,0,128,0,128,0,256,0,256,0,512,0,512,0,1024,0,1024,0,200,0T3r0,1,2Z");
	amy_add_message("v0w11r0,1,2p20Z");
	amy_add_message("v1f262.07932089369143A,,,0.199,,0.354,,0.630,,0.890,,0.707,,0.707,,0.707,,0.707,,0.707,,0.630,,0.446,,0.354,,0.250,,0.157,,0.070,,0.027,,0.012,,0.007,,0.015,,0.012,200,0r0,1,2Z");
	amy_add_message("v2f524.4614951503778A,,,0.031,,0.039,,0.049,,0.099,,0.177,,0.177,,0.281,,0.281,,0.281,,0.281,,0.250,,0.199,,0.111,,0.070,,0.055,,0.055,,0.044,,0.044,,0.017,,0.005,200,0r0,1,2Z");
	amy_add_message("v3f787.6220624166158A,,,0.034,,0.019,,0.015,,0.021,,0.031,,0.055,,0.070,,0.078,,0.062,,0.062,,0.049,,0.039,,0.024,,0.019,,0.013,,0.007,,0.007,,0.001,,0.002,,0.000,200,0r0,1,2Z");
	amy_add_message("v4f1051.3493189372969A,,,0.027,,0.031,,0.039,,0.062,,0.078,,0.078,,0.070,,0.070,,0.070,,0.062,,0.049,,0.039,,0.024,,0.024,,0.024,,0.012,,0.003,,0.006,,0.008,,0.001,200,0r0,1,2Z");
	amy_add_message("v5f1315.467338798746A,,,0.039,,0.070,,0.088,,0.099,,0.111,,0.125,,0.111,,0.111,,0.099,,0.088,,0.078,,0.062,,0.034,,0.013,,0.003,,0.003,,0.007,,0.003,,0.002,,0.001,200,0r0,1,2Z");
	amy_add_message("v6f1581.6262956462915A,,,0.006,,0.008,,0.010,,0.019,,0.013,,0.019,,0.021,,0.021,,0.021,,0.021,,0.017,,0.013,,0.007,,0.003,,0.001,,0.000,,0.001,,0.002,,0.000,,0.000,200,0r0,1,2Z");
	amy_add_message("v7f1848.5688300775876A,,,0.003,,0.012,,0.012,,0.012,,0.017,,0.019,,0.019,,0.021,,0.021,,0.021,,0.019,,0.017,,0.009,,0.003,,0.003,,0.001,,0.003,,0.000,,0.000,,0.000,200,0r0,1,2Z");
	amy_add_message("v8f2118.547431130394A,,,0.001,,0.001,,0.002,,0.001,,0.001,,0.001,,0.002,,0.002,,0.002,,0.002,,0.002,,0.002,,0.001,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0,1,2Z");
	amy_add_message("v9f2387.6236163079025A,,,0.001,,0.003,,0.003,,0.002,,0.002,,0.002,,0.001,,0.001,,0.000,,0.001,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0,1,2Z");
	amy_add_message("v10f2669.2025036818936A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0,1,2Z");
	amy_add_message("v11f2937.8120394192533A,,,0.000,,0.000,,0.000,,0.001,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0,1,2Z");
	amy_add_message("v12f3218.545272631402A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0,1,2Z");
	amy_add_message("v13f3501.7483969650048A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0,1,2Z");
	amy_add_message("v14f3787.9276154035115A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0,1,2Z");
	amy_add_message("v15f4073.89490182507A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0,1,2Z");
	amy_add_message("v16f4361.251218595678A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0,1,2Z");
	amy_add_message("v17f4660.7929645917975A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0,1,2Z");
	amy_add_message("v18f4943.645962597751A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0,1,2Z");
	amy_add_message("v19f5249.725889585327A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0,1,2Z");
	amy_add_message("v20f5549.0549732938325A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0,1,2Z");
	amy_add_message("v0w11t50r0p20Z");
	amy_add_message("v1f294.34406205294465t50A,,,0.093,,0.099,,0.132,,0.177,,0.177,,0.167,,0.118,,0.167,,0.132,,0.132,,0.083,,0.070,,0.046,,0.031,,0.015,,0.003,,0.003,,0.003,,0.002,,0.003,200,0r0Z");
	amy_add_message("v2f588.5181288580752t50A,,,0.006,,0.016,,0.009,,0.018,,0.006,,0.004,,0.015,,0.013,,0.014,,0.011,,0.012,,0.012,,0.012,,0.013,,0.014,,0.012,,0.006,,0.005,,0.002,,0.000,200,0r0Z");
	amy_add_message("v3f884.842198784884t50A,,,0.004,,0.002,,0.003,,0.004,,0.006,,0.008,,0.008,,0.008,,0.008,,0.006,,0.005,,0.004,,0.002,,0.001,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v4f1181.1226315895071t50A,,,0.002,,0.003,,0.004,,0.005,,0.005,,0.004,,0.005,,0.004,,0.004,,0.003,,0.002,,0.001,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v5f1477.4153057160197t50A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v6f1787.6637872384977t50A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v7f2093.6090931138556t50A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v8f2404.92532126672t50A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v9f2756.9544448689694t50A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v10f3015.1757467760062t50A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v11f3333.972248358063t50A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v12f3638.8739959179798t50A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v13f3955.6334984986797t50A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v14f4269.031364842567t50A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v15f4593.972101679235t50A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v16f4902.413229284128t50A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v17f5228.542220951779t50A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v18f5550.65783466558t50A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v19f5894.3201757031875t50A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v20f6192.729494493947t50A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("n60l1t50r0Z");
	amy_add_message("l0t435r0Z");
	amy_add_message("v0w11t450r0p20Z");
	amy_add_message("v1f294.68429813771826t450A,,,0.236,,0.265,,0.334,,0.561,,0.500,,0.500,,0.354,,0.446,,0.397,,0.397,,0.250,,0.210,,0.149,,0.093,,0.041,,0.017,,0.010,,0.008,,0.001,,0.007,200,0r0Z");
	amy_add_message("v2f588.3481826997248t450A,,,0.039,,0.074,,0.093,,0.111,,0.055,,0.062,,0.125,,0.125,,0.125,,0.118,,0.099,,0.074,,0.046,,0.039,,0.039,,0.034,,0.029,,0.027,,0.009,,0.006,200,0r0Z");
	amy_add_message("v3f884.5866832364989t450A,,,0.041,,0.046,,0.044,,0.055,,0.074,,0.099,,0.099,,0.105,,0.088,,0.083,,0.070,,0.059,,0.037,,0.027,,0.014,,0.012,,0.009,,0.001,,0.003,,0.002,200,0r0Z");
	amy_add_message("v4f1181.1226315895071t450A,,,0.037,,0.049,,0.055,,0.074,,0.070,,0.070,,0.070,,0.070,,0.066,,0.059,,0.041,,0.031,,0.020,,0.017,,0.018,,0.012,,0.003,,0.002,,0.005,,0.001,200,0r0Z");
	amy_add_message("v5f1478.6959432469293t450A,,,0.024,,0.041,,0.044,,0.055,,0.052,,0.059,,0.052,,0.049,,0.044,,0.039,,0.031,,0.023,,0.010,,0.005,,0.003,,0.003,,0.003,,0.001,,0.001,,0.000,200,0r0Z");
	amy_add_message("v6f1778.908240479117t450A,,,0.009,,0.011,,0.014,,0.018,,0.017,,0.020,,0.021,,0.021,,0.019,,0.018,,0.012,,0.008,,0.003,,0.000,,0.001,,0.000,,0.001,,0.001,,0.000,,0.000,200,0r0Z");
	amy_add_message("v7f2080.34878834591t450A,,,0.003,,0.006,,0.008,,0.010,,0.010,,0.012,,0.012,,0.013,,0.013,,0.012,,0.010,,0.007,,0.004,,0.002,,0.001,,0.001,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v8f2384.8669179827475t450A,,,0.001,,0.003,,0.003,,0.002,,0.002,,0.002,,0.002,,0.002,,0.002,,0.001,,0.001,,0.001,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v9f2707.244952192445t450A,,,0.000,,0.001,,0.001,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v10f3003.008924119927t450A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v11f3319.5601545674176t450A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v12f3635.7225173258425t450A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v13f3964.7835189690277t450A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v14f4285.0897718795295t450A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v15f4617.91652761982t450A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v16f4943.645962597751t450A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v17f5261.869355194984t450A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v18f5610.290319412823t450A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v19f5962.808877105187t450A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v20f6300.976499332925t450A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("n60l1t450r0Z");
	amy_add_message("l0t835r0Z");
	amy_add_message("v0w11t850r0p20Z");
	amy_add_message("v1f294.8545636329288t850A,,,0.943,,1.121,,1.495,,2.370,,2.370,,2.238,,1.584,,2.112,,1.678,,1.777,,1.058,,0.999,,0.667,,0.446,,0.177,,0.052,,0.049,,0.037,,0.012,,0.027,200,0r0Z");
	amy_add_message("v2f588.5181288580752t850A,,,0.223,,0.334,,0.530,,0.530,,0.397,,0.421,,0.707,,0.840,,0.749,,0.707,,0.561,,0.446,,0.236,,0.118,,0.132,,0.132,,0.111,,0.118,,0.031,,0.026,200,0r0Z");
	amy_add_message("v3f884.842198784884t850A,,,0.265,,0.281,,0.281,,0.375,,0.375,,0.561,,0.500,,0.500,,0.472,,0.397,,0.315,,0.250,,0.167,,0.105,,0.044,,0.032,,0.044,,0.010,,0.013,,0.010,200,0r0Z");
	amy_add_message("v4f1181.463802446632t850A,,,0.265,,0.334,,0.354,,0.500,,0.500,,0.500,,0.500,,0.530,,0.500,,0.397,,0.265,,0.187,,0.125,,0.066,,0.088,,0.070,,0.013,,0.017,,0.026,,0.010,200,0r0Z");
	amy_add_message("v5f1479.5503182463226t850A,,,0.199,,0.334,,0.375,,0.472,,0.421,,0.472,,0.421,,0.397,,0.421,,0.354,,0.281,,0.223,,0.111,,0.046,,0.041,,0.044,,0.023,,0.008,,0.014,,0.003,200,0r0Z");
	amy_add_message("v6f1778.908240479117t850A,,,0.111,,0.132,,0.167,,0.210,,0.187,,0.236,,0.265,,0.187,,0.167,,0.140,,0.099,,0.066,,0.021,,0.006,,0.011,,0.014,,0.005,,0.012,,0.001,,0.000,200,0r0Z");
	amy_add_message("v7f2081.550792045791t850A,,,0.059,,0.118,,0.140,,0.132,,0.132,,0.140,,0.149,,0.149,,0.167,,0.140,,0.099,,0.062,,0.032,,0.039,,0.037,,0.014,,0.004,,0.006,,0.000,,0.000,200,0r0Z");
	amy_add_message("v8f2384.8669179827475t850A,,,0.049,,0.132,,0.149,,0.099,,0.066,,0.078,,0.093,,0.083,,0.074,,0.074,,0.070,,0.059,,0.027,,0.015,,0.012,,0.003,,0.006,,0.001,,0.000,,0.000,200,0r0Z");
	amy_add_message("v9f2690.875101205299t850A,,,0.024,,0.132,,0.105,,0.083,,0.093,,0.078,,0.066,,0.026,,0.041,,0.031,,0.021,,0.023,,0.007,,0.016,,0.005,,0.010,,0.001,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v10f3003.008924119927t850A,,,0.044,,0.046,,0.055,,0.052,,0.052,,0.070,,0.059,,0.059,,0.046,,0.046,,0.037,,0.026,,0.006,,0.006,,0.011,,0.001,,0.001,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v11f3315.7274625736522t850A,,,0.031,,0.044,,0.026,,0.029,,0.024,,0.021,,0.016,,0.012,,0.009,,0.012,,0.009,,0.005,,0.012,,0.006,,0.001,,0.001,,0.001,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v12f3631.524791140783t850A,,,0.012,,0.017,,0.031,,0.041,,0.052,,0.049,,0.046,,0.041,,0.031,,0.018,,0.011,,0.012,,0.007,,0.004,,0.002,,0.001,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v13f3948.7848436027166t850A,,,0.029,,0.034,,0.031,,0.034,,0.018,,0.027,,0.024,,0.021,,0.018,,0.016,,0.007,,0.001,,0.004,,0.002,,0.001,,0.001,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v14f4280.142300378328t850A,,,0.032,,0.059,,0.062,,0.039,,0.039,,0.039,,0.031,,0.027,,0.010,,0.014,,0.012,,0.005,,0.005,,0.005,,0.000,,0.002,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v15f4609.921217475937t850A,,,0.027,,0.029,,0.027,,0.032,,0.029,,0.031,,0.027,,0.024,,0.016,,0.011,,0.006,,0.006,,0.005,,0.002,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v16f4946.502349359061t850A,,,0.026,,0.024,,0.019,,0.016,,0.016,,0.014,,0.016,,0.012,,0.005,,0.006,,0.008,,0.005,,0.002,,0.001,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v17f5281.662425954995t850A,,,0.007,,0.006,,0.008,,0.008,,0.010,,0.006,,0.007,,0.005,,0.003,,0.002,,0.001,,0.002,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v18f5631.394011994379t850A,,,0.007,,0.012,,0.010,,0.008,,0.008,,0.009,,0.008,,0.006,,0.004,,0.003,,0.002,,0.001,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v19f5981.782393936098t850A,,,0.006,,0.008,,0.009,,0.010,,0.012,,0.011,,0.010,,0.009,,0.006,,0.004,,0.001,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("v20f6337.47768486349t850A,,,0.007,,0.008,,0.008,,0.007,,0.006,,0.005,,0.004,,0.002,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r0Z");
	amy_add_message("n60l1t850r0Z");
	amy_add_message("l0t1485r0Z");
	amy_add_message("v0w11t1500r1p20Z");
	amy_add_message("v1f74.04864238799458t1500A,,,0.010,,0.022,,0.044,,0.064,,0.092,,0.073,,0.076,,0.017,,0.068,,0.061,,0.044,,0.042,,0.035,,0.026,,0.015,,0.008,,0.004,,0.003,,0.002,,0.002,200,0r1Z");
	amy_add_message("v2f146.48082858990549t1500A,,,0.026,,0.047,,0.055,,0.089,,0.129,,0.130,,0.135,,0.113,,0.127,,0.126,,0.107,,0.095,,0.084,,0.062,,0.029,,0.023,,0.028,,0.016,,0.002,,0.003,200,0r1Z");
	amy_add_message("v3f219.77772763935312t1500A,,,0.043,,0.077,,0.119,,0.157,,0.195,,0.206,,0.208,,0.218,,0.173,,0.131,,0.092,,0.070,,0.049,,0.033,,0.019,,0.008,,0.004,,0.003,,0.011,,0.010,200,0r1Z");
	amy_add_message("v4f293.8259581897736t1500A,,,0.025,,0.064,,0.099,,0.122,,0.113,,0.082,,0.070,,0.109,,0.084,,0.078,,0.100,,0.093,,0.078,,0.070,,0.056,,0.042,,0.028,,0.019,,0.014,,0.009,200,0r1Z");
	amy_add_message("v5f367.2477173747501t1500A,,,0.028,,0.047,,0.069,,0.084,,0.089,,0.079,,0.081,,0.096,,0.113,,0.120,,0.127,,0.119,,0.106,,0.089,,0.070,,0.049,,0.021,,0.013,,0.015,,0.011,200,0r1Z");
	amy_add_message("v6f441.017791210556t1500A,,,0.023,,0.040,,0.045,,0.023,,0.059,,0.085,,0.132,,0.123,,0.104,,0.093,,0.083,,0.074,,0.061,,0.051,,0.028,,0.013,,0.024,,0.020,,0.016,,0.011,200,0r1Z");
	amy_add_message("v7f515.4515605776315t1500A,,,0.014,,0.031,,0.047,,0.063,,0.109,,0.129,,0.137,,0.137,,0.136,,0.116,,0.109,,0.109,,0.091,,0.069,,0.030,,0.037,,0.049,,0.030,,0.007,,0.009,200,0r1Z");
	amy_add_message("v8f589.3856181537751t1500A,,,0.009,,0.012,,0.013,,0.016,,0.028,,0.032,,0.026,,0.030,,0.023,,0.022,,0.016,,0.011,,0.008,,0.004,,0.008,,0.005,,0.001,,0.001,,0.001,,0.001,200,0r1Z");
	amy_add_message("v9f664.2241559003637t1500A,,,0.014,,0.030,,0.046,,0.054,,0.048,,0.045,,0.046,,0.038,,0.026,,0.024,,0.024,,0.020,,0.015,,0.009,,0.001,,0.003,,0.007,,0.008,,0.003,,0.003,200,0r1Z");
	amy_add_message("v10f738.8996902376488t1500A,,,0.021,,0.043,,0.056,,0.051,,0.014,,0.043,,0.045,,0.045,,0.040,,0.040,,0.040,,0.038,,0.030,,0.025,,0.016,,0.010,,0.006,,0.003,,0.002,,0.002,200,0r1Z");
	amy_add_message("v11f813.5157009859971t1500A,,,0.018,,0.032,,0.040,,0.049,,0.064,,0.066,,0.063,,0.053,,0.039,,0.029,,0.026,,0.024,,0.012,,0.012,,0.017,,0.013,,0.004,,0.009,,0.002,,0.001,200,0r1Z");
	amy_add_message("v12f888.6838007336429t1500A,,,0.016,,0.032,,0.039,,0.036,,0.024,,0.022,,0.017,,0.013,,0.013,,0.007,,0.003,,0.004,,0.001,,0.003,,0.004,,0.002,,0.000,,0.000,,0.000,,0.000,200,0r1Z");
	amy_add_message("v13f963.562684336728t1500A,,,0.012,,0.023,,0.033,,0.044,,0.064,,0.066,,0.063,,0.067,,0.065,,0.069,,0.044,,0.057,,0.038,,0.024,,0.012,,0.026,,0.017,,0.008,,0.008,,0.002,200,0r1Z");
	amy_add_message("v14f1040.4748517038904t1500A,,,0.012,,0.025,,0.044,,0.058,,0.073,,0.077,,0.081,,0.077,,0.073,,0.076,,0.064,,0.052,,0.032,,0.018,,0.020,,0.016,,0.019,,0.014,,0.007,,0.003,200,0r1Z");
	amy_add_message("v15f1117.5069177375879t1500A,,,0.004,,0.004,,0.012,,0.020,,0.024,,0.025,,0.022,,0.022,,0.023,,0.021,,0.018,,0.016,,0.012,,0.008,,0.003,,0.002,,0.006,,0.006,,0.003,,0.002,200,0r1Z");
	amy_add_message("v16f1193.156893756t1500A,,,0.005,,0.010,,0.013,,0.015,,0.018,,0.018,,0.016,,0.017,,0.017,,0.016,,0.013,,0.010,,0.002,,0.003,,0.007,,0.009,,0.003,,0.006,,0.002,,0.000,200,0r1Z");
	amy_add_message("v17f1272.4204192002574t1500A,,,0.002,,0.003,,0.005,,0.006,,0.004,,0.003,,0.004,,0.004,,0.003,,0.004,,0.003,,0.002,,0.000,,0.000,,0.001,,0.001,,0.001,,0.000,,0.000,,0.000,200,0r1Z");
	amy_add_message("v18f1349.640740512321t1500A,,,0.001,,0.001,,0.001,,0.000,,0.002,,0.002,,0.000,,0.002,,0.001,,0.001,,0.000,,0.000,,0.000,,0.000,,0.001,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r1Z");
	amy_add_message("v19f1430.5967761508439t1500A,,,0.001,,0.002,,0.003,,0.003,,0.002,,0.002,,0.002,,0.003,,0.002,,0.002,,0.003,,0.003,,0.002,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r1Z");
	amy_add_message("v20f1506.3692225341174t1500A,,,0.004,,0.009,,0.012,,0.013,,0.014,,0.011,,0.011,,0.010,,0.009,,0.007,,0.003,,0.003,,0.005,,0.004,,0.005,,0.005,,0.002,,0.002,,0.001,,0.000,200,0r1Z");
	amy_add_message("n60l1t1500r1Z");
	amy_add_message("v0w11t2100r2p11Z");
	amy_add_message("v1f1178.0565238532624t2100A,,,0.078,,1.777,,1.584,,2.370,,1.994,,1.883,,1.188,,0.999,,0.943,,0.707,,0.236,,0.265,,0.334,,0.281,,0.167,,0.111,,0.062,,0.034,,0.004,,0.004,200,0r2Z");
	amy_add_message("v2f2371.131095283615t2100A,,,0.008,,0.223,,0.236,,0.236,,0.281,,0.265,,0.177,,0.118,,0.125,,0.049,,0.031,,0.034,,0.034,,0.026,,0.016,,0.008,,0.000,,0.000,,0.000,,0.000,200,0r2Z");
	amy_add_message("v3f3574.2951284802925t2100A,,,0.001,,0.062,,0.021,,0.010,,0.032,,0.021,,0.024,,0.014,,0.006,,0.005,,0.003,,0.004,,0.002,,0.001,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r2Z");
	amy_add_message("v4f4843.305799442923t2100A,,,0.000,,0.016,,0.008,,0.003,,0.006,,0.008,,0.011,,0.006,,0.004,,0.001,,0.003,,0.002,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r2Z");
	amy_add_message("v5f6149.953187253529t2100A,,,0.000,,0.005,,0.005,,0.003,,0.003,,0.002,,0.003,,0.002,,0.000,,0.001,,0.001,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r2Z");
	amy_add_message("v6f7525.698169256955t2100A,,,0.000,,0.001,,0.001,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r2Z");
	amy_add_message("v7f8967.725358717675t2100A,,,0.000,,0.002,,0.001,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r2Z");
	amy_add_message("v8f10457.084441903562t2100A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r2Z");
	amy_add_message("v9f11987.775744026429t2100A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r2Z");
	amy_add_message("v10f13612.172452050445t2100A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r2Z");
	amy_add_message("v11f15363.220457587324t2100A,,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,,0.000,200,0r2Z");
	amy_add_message("n60l1t2100r2Z");
	amy_add_message("l0t3000r1Z");
	amy_add_message("l0t3000r2Z");


    show_debug(99);

    // Now just spin for 15s
    uint32_t start = amy_sysclock();
    while(amy_sysclock() - start < 5000) {
        usleep(THREAD_USLEEP);
    }

    show_debug(99);

    amy_live_stop();

    return 0;
}

#endif
