// Automatically generated.
// Piano interpolated partials data table
#ifndef __INTERP_PARTIALS_H
#define __INTERP_PARTIALS_H

#define NUM_INTERP_PARTIALS_PRESETS 1

#define NUM_PIANO_SAMPLE_TIMES_MS 20
const uint16_t piano_sample_times_ms[NUM_PIANO_SAMPLE_TIMES_MS] PROGMEM = {
    4, 8, 12, 16, 24, 32, 48, 64, 96, 128, 192, 256, 384, 512, 768, 1024, 1536, 2048, 3072, 4096,
};

#define NUM_PIANO_VELOCITIES 3
const uint8_t piano_velocities[NUM_PIANO_VELOCITIES] PROGMEM = {
    40, 80, 120,
};

#define NUM_PIANO_NOTES 21
const uint8_t piano_notes[NUM_PIANO_NOTES] PROGMEM = {
    24, 28, 32, 36, 40, 44, 48, 52, 56, 60, 64, 68, 72, 76, 80, 84, 88, 92, 96, 100,
    104,
};

#define NUM_PIANO_NUM_HARMONICS 63
const uint8_t piano_num_harmonics[NUM_PIANO_NUM_HARMONICS] PROGMEM = {
    40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
    40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 37, 33, 32, 23, 28, 26, 22,
    22, 21, 17, 17, 17, 13, 13, 13, 11, 11, 11, 8, 8, 9, 7, 7, 7, 6, 5, 5,
    3, 4, 4,
};

#define NUM_PIANO_HARMONICS_FREQ 1760
const uint16_t piano_harmonics_freq[NUM_PIANO_HARMONICS_FREQ] PROGMEM = {
    2272, 3586, 4290, 4791, 5181, 5498, 5767, 5996, 6209, 6397, 6566, 6721, 6865, 6999, 7124, 7243, 7356, 7462, 7562, 7660,
    7752, 7841, 7928, 8009, 8091, 8171, 8246, 8321, 8398, 8464, 8565, 8629, 8704, 8765, 8826, 8895, 8955, 9012, 9069, 9128,
    2172, 3587, 4287, 4787, 5175, 5493, 5762, 5996, 6205, 6393, 6561, 6716, 6860, 6993, 7118, 7237, 7348, 7456, 7555, 7652,
    7744, 7833, 7918, 8001, 8081, 8166, 8233, 8306, 8376, 8446, 8514, 8579, 8643, 8706, 8768, 8828, 8891, 8945, 8995, 9035,
    2394, 3588, 4289, 4787, 5176, 5495, 5764, 5998, 6207, 6395, 6564, 6717, 6862, 6995, 7120, 7241, 7351, 7458, 7557, 7654,
    7746, 7835, 7920, 8003, 8082, 8221, 8235, 8310, 8378, 8448, 8515, 8581, 8645, 8708, 8819, 8854, 8901, 8997, 9036, 9079,
    2851, 3989, 4692, 5187, 5576, 5893, 6161, 6394, 6600, 6785, 6952, 7105, 7246, 7379, 7501, 7616, 7724, 7828, 7926, 8019,
    8108, 8193, 8275, 8355, 8434, 8505, 8574, 8641, 8710, 8774, 8836, 8891, 8945, 8996, 9053, 9115, 9147, 9206, 9252, 9304,
    3069, 3987, 4692, 5187, 5577, 5892, 6161, 6393, 6600, 6784, 6952, 7105, 7246, 7379, 7501, 7616, 7725, 7828, 7926, 8019,
    8108, 8193, 8275, 8354, 8435, 8509, 8578, 8643, 8712, 8775, 8838, 8893, 8941, 9006, 9065, 9127, 9177, 9239, 9266, 9333,
    3008, 3989, 4693, 5188, 5577, 5894, 6162, 6395, 6601, 6785, 6953, 7106, 7247, 7379, 7502, 7617, 7726, 7829, 7927, 8019,
    8109, 8194, 8277, 8355, 8438, 8511, 8580, 8645, 8713, 8776, 8839, 8901, 8961, 9019, 9075, 9133, 9182, 9249, 9267, 9351,
    3114, 4391, 5094, 5596, 5984, 6300, 6567, 6804, 7008, 7191, 7358, 7512, 7653, 7784, 7906, 8022, 8130, 8233, 8330, 8424,
    8512, 8595, 8679, 8764, 8838, 8906, 8978, 9049, 9121, 9171, 9242, 9305, 9364, 9424, 9482, 9536, 9593, 9645, 9697, 9750,
    3224, 4390, 5096, 5595, 5983, 6299, 6567, 6799, 7006, 7190, 7358, 7512, 7653, 7784, 7906, 8022, 8129, 8232, 8329, 8422,
    8511, 8595, 8677, 8758, 8856, 8970, 8986, 9105, 9169, 9231, 9291, 9350, 9408, 9473, 9539, 9582, 9664, 9723, 9771, 9820,
    3275, 4391, 5099, 5598, 5985, 6300, 6567, 6805, 7008, 7191, 7358, 7513, 7654, 7785, 7907, 8022, 8130, 8233, 8330, 8423,
    8511, 8595, 8678, 8755, 8855, 8900, 8980, 9041, 9106, 9170, 9232, 9291, 9350, 9407, 9472, 9518, 9574, 9624, 9669, 9724,
    3610, 4789, 5497, 5999, 6386, 6702, 6972, 7205, 7411, 7596, 7763, 7916, 8055, 8189, 8314, 8427, 8551, 8655, 8819, 8852,
    8923, 9072, 9156, 9232, 9311, 9384, 9453, 9521, 9595, 9674, 9748, 9812, 9878, 9942, 10004, 10068, 10130, 10187, 10246, 10303,
    3623, 4792, 5493, 5999, 6385, 6702, 6972, 7205, 7411, 7596, 7763, 7916, 8054, 8189, 8313, 8426, 8537, 8638, 8737, 8831,
    8919, 9004, 9084, 9164, 9257, 9321, 9389, 9515, 9580, 9643, 9707, 9766, 9818, 9885, 9934, 9984, 10050, 10096, 10160, 10207,
    3646, 4792, 5491, 6000, 6386, 6703, 6973, 7206, 7412, 7597, 7764, 7918, 8054, 8190, 8313, 8427, 8539, 8639, 8738, 8832,
    8920, 9005, 9086, 9165, 9259, 9322, 9390, 9518, 9583, 9644, 9707, 9765, 9823, 9889, 9937, 9984, 10040, 10096, 10160, 10205,
    4008, 5200, 5904, 6403, 6790, 7106, 7376, 7608, 7815, 7998, 8165, 8318, 8460, 8591, 8715, 8826, 8939, 9042, 9139, 9229,
    9318, 9402, 9480, 9562, 9644, 9713, 9780, 9846, 9911, 9977, 10038, 10101, 10158, 10216, 10274, 10346, 10385, 10434, 10486, 10536,
    4008, 5200, 5903, 6403, 6789, 7106, 7376, 7607, 7815, 7999, 8165, 8318, 8460, 8591, 8714, 8828, 8937, 9039, 9137, 9228,
    9318, 9401, 9484, 9568, 9659, 9718, 9782, 9847, 9916, 9977, 10038, 10099, 10186, 10265, 10321, 10370, 10421, 10477, 10531, 10576,
    4010, 5201, 5903, 6404, 6790, 7108, 7376, 7608, 7816, 7999, 8166, 8318, 8461, 8592, 8714, 8829, 8938, 9040, 9137, 9228,
    9318, 9402, 9484, 9564, 9658, 9714, 9784, 9847, 9913, 9976, 10038, 10096, 10165, 10272, 10317, 10379, 10428, 10480, 10529, 10566,
    4398, 5600, 6302, 6802, 7189, 7506, 7774, 8007, 8213, 8398, 8566, 8720, 8860, 8992, 9130, 9234, 9347, 9448, 9543, 9645,
    9727, 9809, 9903, 9985, 10063, 10138, 10214, 10287, 10349, 10419, 10481, 10547, 10605, 10668, 10731, 10784, 10842, 10897, 10950, 11004,
    4398, 5599, 6303, 6801, 7188, 7507, 7773, 8006, 8213, 8397, 8565, 8717, 8858, 8990, 9112, 9227, 9334, 9438, 9536, 9629,
    9716, 9802, 9884, 9962, 10042, 10112, 10182, 10252, 10328, 10380, 10443, 10506, 10573, 10632, 10685, 10739, 10792, 10851, 10906, 10960,
    4400, 5598, 6304, 6803, 7190, 7508, 7775, 8008, 8215, 8398, 8566, 8718, 8860, 8991, 9113, 9228, 9337, 9440, 9536, 9629,
    9718, 9803, 9885, 9963, 10045, 10112, 10182, 10250, 10316, 10381, 10443, 10535, 10556, 10623, 10679, 10735, 10788, 10841, 10893, 10945,
    4782, 6001, 6703, 7203, 7591, 7907, 8175, 8410, 8623, 8800, 8966, 9124, 9265, 9407, 9526, 9658, 9778, 9886, 9995, 10084,
    10175, 10271, 10349, 10437, 10516, 10592, 10669, 10744, 10818, 10887, 10956, 11022, 11087, 11151, 11223, 11277, 11336, 11398, 11454, 11511,
    4797, 6000, 6702, 7204, 7591, 7907, 8174, 8407, 8615, 8797, 8964, 9117, 9258, 9389, 9511, 9625, 9735, 9837, 9934, 10027,
    10115, 10200, 10281, 10353, 10441, 10507, 10580, 10646, 10715, 10779, 10842, 10904, 10967, 11024, 11085, 11137, 11194, 11247, 11299, 11352,
    4801, 6002, 6703, 7205, 7592, 7908, 8176, 8408, 8616, 8798, 8966, 9118, 9259, 9390, 9512, 9626, 9736, 9838, 9934, 10028,
    10115, 10201, 10282, 10360, 10438, 10508, 10578, 10646, 10713, 10777, 10839, 10899, 10966, 11016, 11074, 11128, 11183, 11238, 11287, 11343,
    5204, 6408, 7107, 7608, 7994, 8311, 8580, 8812, 9020, 9202, 9373, 9527, 9666, 9802, 9927, 10042, 10158, 10256, 10348, 10446,
    10535, 10617, 10702, 10777, 10853, 10924, 10996, 11059, 11131, 11196, 11250, 11317, 11392, 11437, 11491, 11545, 11599, 11653, 11696, 11753,
    5206, 6408, 7107, 7608, 7994, 8311, 8580, 8812, 9019, 9205, 9372, 9526, 9667, 9799, 9916, 10038, 10147, 10251, 10349, 10444,
    10533, 10620, 10701, 10779, 10855, 10928, 11001, 11069, 11136, 11202, 11250, 11313, 11384, 11428, 11486, 11544, 11589, 11644, 11689, 11743,
    5208, 6409, 7108, 7609, 7995, 8312, 8581, 8812, 9020, 9205, 9373, 9527, 9668, 9800, 9922, 10039, 10147, 10252, 10351, 10443,
    10534, 10619, 10702, 10781, 10857, 10931, 11005, 11073, 11141, 11208, 11269, 11332, 11396, 11452, 11510, 11567, 11622, 11679, 11729, 11778,
    5606, 6807, 7508, 8009, 8396, 8714, 8994, 9205, 9428, 9629, 9787, 9941, 10072, 10212, 10347, 10463, 10569, 10668, 10765, 10858,
    10948, 11037, 11116, 11197, 11272, 11348, 11401, 11485, 11557, 11622, 11686, 11749, 11810, 11870, 11933, 11986, 12040, 12095, 12148, 12201,
    5603, 6807, 7509, 8009, 8396, 8714, 8983, 9216, 9423, 9609, 9778, 9932, 10072, 10209, 10335, 10452, 10563, 10667, 10767, 10863,
    10954, 11042, 11124, 11209, 11284, 11363, 11424, 11500, 11569, 11634, 11697, 11762, 11825, 11886, 11940, 12002, 12059, 12116, 12170, 12225,
    5599, 6808, 7510, 8010, 8397, 8715, 8984, 9217, 9425, 9611, 9779, 9934, 10075, 10210, 10334, 10451, 10562, 10667, 10767, 10862,
    10952, 11040, 11124, 11208, 11284, 11362, 11431, 11506, 11575, 11645, 11707, 11772, 11834, 11895, 11951, 12014, 12071, 12128, 12190, 12237,
    6002, 7204, 7909, 8408, 8797, 9126, 9394, 9638, 9844, 10034, 10201, 10348, 10493, 10621, 10748, 10862, 10970, 11069, 11174, 11257,
    11369, 11436, 11525, 11606, 11686, 11758, 11829, 11903, 11964, 12035, 12101, 12165, 12227, 12288, 12347, 12406, 12460, 12518, 12572, 12628,
    6003, 7204, 7908, 8408, 8796, 9115, 9385, 9621, 9828, 10021, 10187, 10345, 10491, 10627, 10753, 10871, 10986, 11088, 11192, 11288,
    11394, 11469, 11551, 11631, 11703, 11785, 11860, 11936, 12007, 12074, 12141, 12208, 12271, 12334, 12396, 12452, 12514, 12573, 12631, 12685,
    6004, 7205, 7909, 8408, 8797, 9115, 9386, 9621, 9829, 10018, 10187, 10344, 10489, 10624, 10751, 10871, 10984, 11092, 11195, 11293,
    11388, 11474, 11564, 11650, 11732, 11825, 11890, 11958, 12033, 12107, 12176, 12241, 12307, 12371, 12436, 12496, 12555, 12617, 12675, 12733,
    6406, 7603, 8310, 8811, 9197, 9528, 9807, 10043, 10310, 10430, 10611, 10767, 10911, 11047, 11174, 11285, 11400, 11508, 11611, 11699,
    11796, 11893, 11969, 12057, 12142, 12220, 12296, 12371, 12441, 12515, 12585, 12651, 12719, 12783, 12847, 12906, 12972, 13038, 13091, 13149,
    6409, 7602, 8310, 8811, 9201, 9522, 9794, 10031, 10264, 10429, 10611, 10768, 10921, 11055, 11189, 11307, 11406, 11528, 11635, 11731,
    11829, 11931, 12015, 12099, 12184, 12265, 12346, 12427, 12501, 12575, 12646, 12717, 12786, 12854, 12922, 12987, 13052, 13114, 13176, 13237,
    6410, 7602, 8310, 8812, 9202, 9522, 9795, 10031, 10241, 10432, 10606, 10764, 10909, 11053, 11183, 11306, 11421, 11534, 11641, 11740,
    11836, 11928, 12001, 12097, 12162, 12238, 12319, 12395, 12469, 12543, 12615, 12683, 12752, 12819, 12885, 12949, 13012, 13074, 13134, 13194,
    6806, 8006, 8712, 9210, 9616, 9933, 10237, 10412, 10652, 10840, 11011, 11164, 11299, 11410, 11549, 11675, 11779, 11888, 11975, 12073,
    12166, 12256, 12338, 12423, 12500, 12574, 12647, 12720, 12788, 12856, 12921, 12987, 13051, 13111, 13171, 13231, 13288, 6807, 8006, 8713,
    9214, 9606, 9928, 10202, 10441, 10658, 10855, 11030, 11209, 11350, 11483, 11616, 11733, 11855, 11956, 12071, 12180, 12281, 12378, 12468,
    12562, 12653, 12736, 12823, 12903, 12985, 13061, 13138, 13214, 13285, 6808, 8007, 8714, 9215, 9607, 9929, 10203, 10442, 10656, 10850,
    11025, 11260, 11338, 11485, 11618, 11744, 11868, 11975, 12091, 12198, 12300, 12400, 12494, 12587, 12676, 12763, 12845, 12930, 13011, 13090,
    13167, 13244, 7203, 8404, 9117, 9628, 10035, 10354, 10659, 10914, 11147, 11380, 11552, 11716, 11904, 12052, 12205, 12350, 12490, 12629,
    12753, 12885, 13006, 13122, 13240, 7203, 8405, 9112, 9616, 10012, 10339, 10621, 10863, 11067, 11254, 11419, 11587, 11729, 11876, 12000,
    12124, 12241, 12353, 12456, 12562, 12658, 12756, 12847, 12938, 13024, 13110, 13192, 13275, 7203, 8406, 9112, 9617, 10012, 10337, 10615,
    10859, 11077, 11248, 11460, 11652, 11791, 11940, 12076, 12212, 12324, 12430, 12541, 12648, 12755, 12857, 12957, 13054, 13147, 13241, 7606,
    8805, 9529, 10039, 10389, 10754, 11037, 11275, 11460, 11674, 11852, 12002, 12155, 12296, 12430, 12553, 12680, 12791, 12898, 13007, 13108,
    13205, 7607, 8809, 9516, 10022, 10413, 10745, 11028, 11274, 11465, 11672, 11849, 12002, 12160, 12296, 12430, 12553, 12673, 12793, 12899,
    13003, 13109, 13208, 7607, 8809, 9516, 10020, 10415, 10744, 11025, 11273, 11492, 11680, 11880, 12068, 12212, 12358, 12494, 12627, 12752,
    12878, 12993, 13110, 13220, 8006, 9206, 9946, 10405, 10854, 11193, 11444, 11706, 11936, 12136, 12320, 12490, 12660, 12814, 12959, 13093,
    13237, 8007, 9203, 9925, 10423, 10846, 11183, 11436, 11694, 11926, 12117, 12295, 12461, 12621, 12767, 12911, 13051, 13177, 8008, 9212,
    9921, 10428, 10830, 11162, 11443, 11703, 11930, 12135, 12321, 12495, 12659, 12815, 12960, 13102, 13241, 8400, 9616, 10349, 10895, 11315,
    11634, 11921, 12168, 12401, 12617, 12811, 13012, 13180, 8398, 9607, 10331, 10859, 11293, 11620, 11911, 12158, 12386, 12597, 12790, 12979,
    13148, 8400, 9614, 10323, 10842, 11255, 11606, 11902, 12163, 12395, 12617, 12820, 13012, 13186, 8802, 10047, 10789, 11338, 11714, 12032,
    12335, 12599, 12833, 13055, 13264, 8809, 10024, 10758, 11307, 11704, 12027, 12332, 12600, 12838, 13051, 13262, 8810, 10018, 10730, 11263,
    11677, 12025, 12336, 12607, 12848, 13066, 13282, 9119, 10411, 11228, 11733, 12138, 12481, 12772, 13058, 9211, 10418, 11212, 11719, 12131,
    12476, 12767, 13048, 9216, 10420, 11163, 11688, 12105, 12453, 12745, 13030, 13271, 9334, 10833, 11609, 12150, 12590, 12947, 13265, 9578,
    10866, 11617, 12155, 12598, 12960, 13292, 9613, 10827, 11575, 12112, 12547, 12902, 13211, 9520, 11256, 12011, 12541, 12935, 13269, 9943,
    11276, 12039, 12603, 13022, 9996, 11242, 12016, 12585, 13016, 8908, 11863, 12902, 10199, 11574, 12376, 12924, 10409, 11646, 12421, 12947,
};

#define NUM_PIANO_HARMONICS_MAGS 35200
const uint8_t piano_harmonics_mags[NUM_PIANO_HARMONICS_MAGS] PROGMEM = {
    39, 40, 41, 42, 37, 37, 40, 39, 42, 46, 41, 42, 44, 41, 41, 39, 42, 41, 40, 40,
    51, 53, 55, 56, 55, 50, 48, 53, 49, 49, 51, 52, 53, 52, 52, 52, 53, 50, 52, 50,
    65, 68, 70, 72, 73, 73, 73, 73, 73, 73, 72, 72, 72, 72, 71, 71, 70, 70, 68, 67,
    69, 71, 73, 74, 75, 77, 77, 77, 74, 75, 75, 75, 75, 74, 72, 71, 69, 67, 62, 59,
    69, 71, 73, 73, 74, 73, 74, 74, 75, 74, 74, 74, 73, 72, 71, 70, 67, 64, 58, 53,
    68, 70, 72, 74, 75, 76, 77, 76, 72, 74, 72, 73, 72, 71, 71, 70, 68, 66, 62, 58,
    52, 52, 52, 52, 53, 53, 49, 52, 53, 51, 52, 52, 52, 53, 52, 51, 51, 50, 46, 45,
    43, 41, 44, 48, 54, 56, 56, 58, 59, 58, 56, 56, 50, 47, 47, 42, 39, 34, 29, 21,
    48, 52, 55, 56, 59, 60, 62, 63, 62, 63, 63, 63, 62, 62, 60, 58, 56, 53, 49, 44,
    56, 57, 57, 58, 59, 61, 61, 63, 63, 65, 64, 63, 62, 61, 59, 57, 53, 50, 45, 44,
    47, 45, 51, 57, 62, 65, 67, 67, 66, 65, 64, 63, 62, 61, 59, 57, 53, 49, 41, 30,
    61, 63, 64, 66, 68, 69, 71, 71, 71, 72, 71, 71, 70, 70, 68, 67, 64, 60, 48, 46,
    58, 60, 61, 62, 63, 64, 64, 65, 66, 66, 66, 65, 65, 64, 62, 61, 58, 55, 49, 40,
    45, 51, 55, 57, 61, 62, 63, 63, 62, 62, 62, 61, 61, 60, 60, 59, 57, 55, 48, 44,
    51, 53, 54, 56, 57, 58, 58, 59, 61, 61, 61, 60, 60, 59, 57, 56, 51, 46, 38, 45,
    45, 46, 47, 47, 47, 46, 47, 47, 42, 39, 51, 49, 46, 44, 45, 44, 43, 41, 39, 37,
    46, 48, 49, 50, 50, 48, 44, 41, 42, 41, 40, 40, 37, 35, 33, 13, 29, 32, 35, 32,
    48, 50, 51, 52, 53, 54, 55, 54, 54, 55, 54, 54, 53, 53, 51, 49, 45, 38, 30, 37,
    50, 52, 52, 53, 53, 53, 53, 53, 52, 52, 52, 51, 51, 51, 50, 48, 45, 42, 33, 29,
    49, 51, 52, 53, 53, 53, 51, 49, 48, 49, 48, 48, 48, 47, 47, 45, 44, 44, 42, 41,
    35, 39, 41, 43, 45, 44, 38, 27, 15, 37, 36, 38, 40, 43, 44, 46, 47, 46, 41, 33,
    36, 38, 39, 40, 42, 40, 33, 37, 43, 44, 43, 44, 43, 43, 43, 42, 41, 39, 36, 35,
    39, 41, 43, 44, 45, 46, 47, 46, 45, 44, 44, 43, 41, 41, 34, 30, 31, 35, 38, 35,
    38, 40, 42, 43, 43, 43, 44, 46, 47, 46, 46, 46, 46, 45, 43, 42, 40, 37, 34, 31,
    36, 37, 38, 38, 38, 38, 38, 37, 39, 39, 38, 37, 38, 37, 34, 32, 25, 17, 26, 26,
    30, 30, 28, 26, 24, 23, 29, 30, 31, 30, 25, 29, 27, 23, 23, 24, 24, 24, 13, 17,
    26, 24, 21, 25, 31, 30, 35, 35, 32, 35, 34, 33, 33, 31, 28, 22, 22, 23, 19, 16,
    26, 24, 23, 23, 26, 32, 32, 32, 33, 35, 35, 31, 31, 33, 29, 29, 26, 21, 0, 12,
    41, 41, 40, 38, 37, 41, 31, 35, 24, 30, 31, 19, 32, 18, 27, 27, 21, 17, 8, 13,
    38, 38, 37, 35, 19, 33, 35, 31, 34, 34, 31, 23, 25, 21, 21, 22, 19, 20, 5, 11,
    27, 29, 30, 29, 21, 24, 9, 26, 21, 23, 22, 7, 25, 23, 21, 16, 20, 16, 12, 13,
    19, 21, 22, 23, 22, 12, 16, 6, 20, 19, 14, 10, 16, 14, 12, 11, 11, 7, 13, 10,
    12, 6, 0, 12, 19, 22, 24, 17, 23, 24, 21, 14, 21, 15, 11, 18, 17, 12, 14, 9,
    3, 10, 14, 17, 17, 12, 5, 14, 1, 16, 13, 19, 10, 20, 11, 8, 12, 8, 15, 13,
    15, 17, 18, 19, 20, 20, 18, 14, 12, 18, 14, 17, 21, 15, 15, 11, 11, 14, 14, 14,
    27, 28, 29, 30, 29, 28, 28, 27, 28, 28, 27, 28, 30, 27, 23, 19, 21, 21, 16, 4,
    20, 21, 20, 20, 17, 16, 25, 26, 23, 19, 24, 22, 25, 25, 18, 4, 21, 13, 2, 6,
    20, 20, 20, 19, 20, 20, 19, 18, 20, 20, 23, 19, 23, 20, 17, 6, 0, 5, 7, 0,
    17, 20, 22, 22, 22, 20, 22, 19, 23, 20, 18, 10, 3, 18, 14, 12, 8, 8, 0, 1,
    28, 29, 30, 31, 31, 29, 24, 21, 20, 19, 18, 15, 19, 16, 10, 5, 7, 2, 3, 16,
    38, 36, 36, 36, 33, 30, 34, 44, 47, 42, 41, 35, 41, 39, 42, 37, 44, 42, 40, 38,
    55, 59, 62, 65, 67, 66, 59, 57, 61, 59, 59, 59, 60, 58, 58, 57, 57, 56, 56, 53,
    70, 73, 76, 79, 81, 82, 79, 79, 81, 80, 80, 79, 79, 79, 78, 77, 75, 74, 71, 68,
    73, 76, 77, 78, 79, 79, 79, 76, 78, 77, 77, 77, 76, 76, 75, 75, 73, 71, 67, 61,
    74, 77, 79, 81, 83, 84, 84, 82, 84, 83, 83, 83, 83, 82, 81, 80, 79, 77, 73, 69,
    71, 73, 75, 76, 78, 79, 78, 79, 79, 79, 78, 78, 78, 78, 77, 76, 75, 74, 72, 69,
    66, 68, 69, 69, 69, 68, 65, 64, 66, 69, 69, 69, 68, 68, 67, 66, 65, 63, 61, 58,
    62, 62, 62, 62, 65, 68, 70, 71, 72, 71, 69, 68, 67, 65, 63, 61, 57, 51, 44, 43,
    54, 58, 61, 64, 67, 66, 65, 67, 66, 66, 67, 66, 66, 66, 64, 63, 61, 59, 55, 51,
    62, 64, 65, 66, 63, 48, 63, 62, 49, 44, 52, 50, 48, 50, 49, 48, 50, 51, 51, 51,
    59, 62, 65, 67, 72, 75, 78, 77, 76, 74, 72, 70, 69, 68, 65, 63, 58, 52, 40, 47,
    66, 68, 69, 70, 70, 70, 70, 72, 73, 74, 73, 72, 71, 70, 68, 66, 62, 60, 56, 52,
    57, 60, 64, 67, 71, 72, 69, 67, 69, 71, 73, 72, 72, 71, 70, 69, 67, 64, 59, 54,
    61, 64, 67, 69, 71, 73, 75, 74, 74, 75, 74, 74, 74, 73, 72, 71, 68, 66, 66, 64,
    48, 48, 47, 45, 53, 59, 62, 64, 58, 56, 57, 52, 54, 53, 52, 53, 54, 54, 53, 49,
    53, 54, 55, 57, 61, 65, 68, 67, 63, 43, 57, 47, 54, 57, 57, 50, 54, 51, 50, 48,
    56, 59, 61, 62, 62, 58, 43, 49, 52, 51, 49, 47, 47, 47, 45, 45, 44, 44, 34, 35,
    59, 60, 61, 60, 59, 55, 42, 48, 40, 44, 46, 46, 46, 42, 43, 44, 40, 39, 39, 32,
    56, 59, 61, 63, 64, 65, 65, 64, 63, 63, 63, 62, 62, 63, 63, 62, 60, 57, 57, 51,
    51, 56, 59, 61, 63, 64, 63, 62, 57, 50, 53, 54, 54, 52, 54, 52, 52, 51, 49, 45,
    61, 63, 64, 65, 66, 67, 67, 68, 68, 69, 69, 68, 67, 66, 65, 66, 65, 61, 60, 58,
    56, 59, 62, 64, 66, 67, 67, 67, 67, 67, 68, 68, 67, 67, 66, 64, 62, 60, 56, 51,
    55, 57, 57, 57, 57, 55, 55, 59, 61, 61, 60, 61, 60, 59, 57, 56, 55, 53, 50, 47,
    55, 58, 60, 62, 63, 64, 64, 63, 63, 64, 63, 63, 62, 62, 61, 60, 58, 56, 53, 49,
    59, 60, 61, 61, 61, 59, 57, 55, 55, 56, 54, 54, 54, 54, 52, 50, 50, 47, 43, 38,
    51, 51, 50, 49, 50, 53, 45, 36, 38, 39, 40, 29, 34, 42, 37, 26, 26, 14, 18, 22,
    57, 57, 57, 56, 54, 49, 55, 57, 54, 56, 56, 56, 55, 53, 52, 51, 48, 44, 39, 31,
    57, 57, 56, 56, 59, 62, 65, 65, 61, 62, 60, 59, 59, 59, 59, 55, 54, 47, 43, 34,
    55, 53, 48, 29, 53, 58, 59, 60, 57, 59, 58, 58, 58, 56, 54, 52, 46, 42, 32, 21,
    58, 60, 61, 62, 63, 63, 61, 57, 61, 61, 59, 58, 57, 56, 54, 52, 49, 45, 37, 28,
    51, 53, 54, 55, 56, 57, 58, 58, 59, 58, 58, 57, 53, 46, 51, 54, 42, 48, 40, 34,
    46, 48, 49, 51, 52, 53, 54, 55, 55, 55, 55, 55, 54, 52, 51, 51, 47, 45, 39, 35,
    49, 50, 50, 50, 49, 46, 45, 46, 47, 48, 47, 49, 47, 44, 44, 44, 39, 37, 32, 28,
    42, 44, 45, 46, 46, 45, 44, 44, 44, 45, 45, 44, 44, 43, 42, 41, 38, 35, 27, 22,
    35, 34, 32, 31, 31, 31, 28, 29, 34, 34, 37, 30, 34, 35, 23, 31, 27, 10, 15, 4,
    45, 46, 47, 48, 48, 47, 44, 41, 48, 47, 49, 48, 45, 41, 41, 43, 39, 34, 29, 23,
    33, 32, 30, 33, 40, 43, 42, 41, 45, 40, 45, 39, 40, 34, 43, 24, 36, 23, 17, 20,
    36, 37, 39, 40, 42, 43, 44, 45, 45, 45, 45, 45, 43, 37, 35, 32, 34, 33, 24, 19,
    41, 42, 43, 44, 45, 46, 45, 45, 40, 46, 35, 45, 47, 43, 37, 41, 28, 27, 15, 12,
    39, 40, 41, 41, 40, 39, 40, 42, 39, 40, 37, 43, 37, 41, 35, 35, 25, 24, 19, 14,
    45, 45, 44, 49, 54, 58, 57, 42, 53, 50, 57, 43, 48, 54, 29, 47, 47, 48, 42, 42,
    67, 70, 74, 76, 79, 80, 76, 69, 73, 71, 68, 69, 70, 69, 69, 69, 67, 66, 65, 63,
    77, 81, 84, 86, 90, 92, 92, 91, 93, 92, 92, 91, 91, 91, 90, 89, 88, 86, 83, 80,
    79, 84, 86, 88, 90, 90, 90, 88, 88, 87, 88, 87, 86, 86, 85, 84, 83, 81, 77, 72,
    76, 82, 86, 89, 93, 95, 96, 95, 96, 96, 96, 95, 95, 94, 93, 92, 90, 88, 84, 80,
    81, 84, 86, 88, 90, 91, 90, 89, 90, 89, 89, 88, 88, 88, 87, 87, 86, 85, 83, 81,
    77, 79, 81, 82, 82, 81, 78, 76, 79, 80, 81, 80, 80, 79, 79, 78, 76, 74, 71, 68,
    76, 77, 78, 78, 77, 79, 83, 85, 86, 85, 83, 83, 81, 79, 77, 75, 70, 62, 56, 52,
    69, 69, 70, 73, 79, 81, 78, 76, 80, 78, 79, 78, 78, 78, 76, 75, 73, 70, 65, 61,
    76, 78, 78, 79, 78, 69, 77, 76, 67, 67, 68, 70, 67, 67, 62, 58, 55, 57, 60, 62,
    74, 76, 78, 80, 83, 85, 89, 89, 89, 88, 85, 83, 82, 81, 79, 78, 74, 70, 61, 54,
    66, 72, 76, 79, 82, 84, 86, 87, 86, 86, 85, 85, 84, 83, 81, 80, 76, 74, 68, 64,
    66, 67, 71, 76, 82, 85, 85, 82, 83, 84, 84, 83, 83, 83, 82, 80, 79, 76, 72, 67,
    63, 68, 73, 76, 81, 84, 87, 87, 86, 86, 86, 87, 86, 85, 84, 83, 80, 76, 75, 75,
    56, 56, 56, 55, 59, 67, 73, 77, 80, 79, 78, 70, 73, 73, 71, 66, 67, 67, 65, 61,
    56, 53, 53, 61, 72, 78, 82, 80, 73, 77, 72, 74, 75, 76, 74, 56, 70, 64, 63, 61,
    71, 74, 76, 78, 79, 77, 57, 70, 70, 70, 64, 63, 65, 66, 61, 63, 61, 59, 50, 50,
    72, 74, 75, 76, 75, 73, 67, 72, 69, 68, 69, 70, 67, 66, 64, 64, 60, 58, 56, 51,
    67, 71, 75, 77, 80, 81, 82, 82, 82, 81, 81, 80, 80, 80, 79, 78, 76, 73, 71, 66,
    60, 65, 71, 74, 79, 81, 82, 81, 81, 79, 79, 77, 78, 76, 74, 71, 70, 68, 64, 61,
    71, 75, 78, 80, 82, 84, 85, 86, 84, 84, 84, 84, 83, 82, 81, 81, 79, 73, 71, 71,
    67, 71, 75, 78, 82, 84, 85, 86, 85, 86, 85, 84, 83, 83, 82, 81, 77, 76, 71, 67,
    70, 73, 75, 76, 77, 76, 70, 68, 73, 74, 75, 76, 75, 74, 70, 70, 68, 66, 59, 55,
    70, 74, 77, 79, 82, 83, 83, 82, 81, 81, 82, 81, 81, 80, 78, 76, 74, 71, 66, 63,
    75, 78, 80, 81, 81, 81, 77, 71, 67, 71, 67, 73, 69, 69, 68, 65, 63, 59, 51, 48,
    74, 74, 73, 72, 69, 67, 73, 74, 59, 73, 57, 72, 57, 71, 44, 67, 59, 58, 46, 46,
    75, 77, 77, 77, 76, 74, 76, 78, 75, 80, 79, 77, 74, 74, 72, 70, 65, 62, 54, 48,
    77, 80, 81, 82, 83, 85, 88, 88, 82, 83, 85, 82, 81, 81, 78, 73, 64, 65, 63, 53,
    71, 72, 74, 75, 77, 79, 79, 81, 79, 79, 77, 78, 77, 73, 70, 66, 61, 56, 41, 34,
    76, 79, 82, 84, 86, 87, 86, 85, 84, 84, 82, 82, 81, 80, 76, 71, 67, 65, 50, 46,
    72, 75, 77, 78, 80, 81, 81, 80, 80, 80, 79, 77, 72, 67, 72, 71, 64, 60, 55, 53,
    74, 75, 77, 77, 78, 78, 79, 79, 77, 78, 77, 77, 76, 74, 70, 69, 62, 60, 48, 46,
    70, 72, 72, 73, 73, 73, 74, 74, 74, 75, 73, 74, 72, 68, 64, 64, 58, 52, 48, 42,
    64, 67, 69, 71, 73, 73, 70, 71, 72, 71, 70, 69, 69, 66, 64, 63, 58, 56, 52, 47,
    62, 66, 69, 70, 68, 57, 68, 71, 67, 70, 66, 61, 67, 68, 67, 57, 61, 49, 34, 30,
    68, 70, 71, 72, 73, 75, 77, 73, 76, 76, 77, 76, 73, 71, 65, 64, 58, 55, 50, 42,
    61, 61, 59, 51, 62, 64, 61, 54, 68, 65, 70, 67, 72, 73, 70, 57, 61, 55, 49, 43,
    69, 71, 71, 71, 76, 78, 79, 78, 71, 73, 75, 68, 74, 76, 64, 61, 62, 51, 43, 36,
    60, 60, 62, 64, 68, 67, 70, 74, 72, 71, 72, 74, 72, 70, 62, 62, 55, 55, 43, 38,
    63, 65, 67, 69, 69, 67, 58, 65, 64, 68, 69, 68, 69, 65, 60, 56, 52, 45, 35, 31,
    41, 41, 40, 38, 39, 38, 32, 40, 38, 46, 42, 32, 43, 38, 23, 41, 45, 37, 35, 45,
    58, 63, 66, 69, 70, 70, 73, 73, 75, 76, 76, 76, 75, 74, 69, 63, 50, 43, 29, 34,
    67, 70, 72, 73, 75, 76, 77, 77, 74, 74, 76, 75, 74, 73, 72, 70, 68, 65, 59, 52,
    64, 68, 71, 72, 74, 74, 73, 72, 74, 74, 74, 74, 73, 73, 72, 72, 70, 69, 66, 64,
    65, 67, 69, 70, 71, 71, 71, 71, 71, 71, 72, 71, 71, 70, 69, 68, 66, 64, 59, 51,
    62, 64, 66, 67, 67, 66, 63, 65, 68, 68, 69, 70, 70, 69, 68, 66, 63, 60, 55, 50,
    63, 65, 66, 67, 68, 67, 68, 67, 66, 67, 67, 67, 67, 66, 65, 64, 63, 61, 57, 53,
    39, 39, 42, 45, 49, 50, 45, 44, 47, 48, 47, 48, 46, 46, 44, 45, 42, 39, 37, 33,
    43, 44, 45, 47, 49, 51, 50, 52, 53, 50, 50, 50, 50, 47, 46, 46, 47, 43, 41, 40,
    44, 43, 39, 25, 45, 50, 54, 54, 54, 55, 55, 56, 55, 54, 54, 53, 52, 51, 48, 45,
    36, 46, 51, 55, 58, 60, 61, 63, 63, 63, 64, 63, 63, 63, 62, 61, 59, 57, 53, 50,
    51, 54, 56, 57, 58, 59, 60, 60, 59, 60, 60, 59, 59, 58, 58, 56, 54, 53, 49, 46,
    45, 48, 50, 52, 51, 53, 58, 58, 58, 59, 59, 59, 59, 59, 58, 58, 57, 54, 48, 40,
    43, 46, 49, 52, 56, 60, 62, 61, 62, 62, 61, 60, 59, 58, 56, 55, 53, 49, 21, 35,
    46, 47, 48, 49, 49, 50, 51, 52, 53, 53, 53, 53, 52, 51, 49, 47, 41, 35, 41, 42,
    38, 39, 40, 41, 40, 40, 41, 38, 37, 39, 37, 35, 35, 33, 29, 19, 28, 32, 31, 14,
    28, 28, 26, 24, 25, 28, 31, 30, 34, 31, 31, 29, 22, 31, 27, 18, 13, 19, 13, 10,
    38, 40, 41, 41, 41, 42, 43, 43, 43, 43, 43, 43, 41, 38, 31, 18, 37, 38, 24, 30,
    34, 37, 39, 40, 42, 41, 39, 41, 40, 40, 39, 38, 38, 36, 29, 26, 35, 33, 25, 22,
    24, 27, 29, 30, 29, 29, 31, 28, 28, 30, 30, 32, 30, 32, 26, 20, 24, 24, 25, 22,
    21, 24, 26, 28, 32, 34, 35, 35, 34, 34, 34, 33, 32, 28, 14, 21, 27, 14, 20, 19,
    30, 31, 32, 33, 33, 33, 32, 29, 29, 32, 33, 33, 34, 31, 26, 23, 29, 18, 11, 13,
    33, 35, 35, 36, 36, 36, 34, 34, 36, 34, 34, 32, 27, 20, 31, 30, 4, 26, 25, 16,
    25, 26, 27, 26, 23, 21, 16, 24, 25, 28, 28, 29, 31, 29, 19, 27, 18, 18, 15, 10,
    17, 17, 15, 12, 10, 15, 16, 25, 15, 19, 21, 19, 11, 14, 15, 17, 5, 13, 14, 0,
    28, 28, 27, 27, 25, 18, 28, 26, 22, 19, 8, 21, 21, 20, 16, 19, 19, 15, 8, 5,
    34, 34, 33, 31, 34, 37, 36, 37, 34, 30, 26, 21, 22, 26, 20, 12, 12, 16, 7, 16,
    29, 31, 32, 33, 33, 31, 18, 19, 18, 21, 21, 21, 21, 22, 21, 22, 16, 16, 1, 16,
    23, 23, 22, 22, 21, 24, 25, 26, 26, 28, 27, 28, 27, 25, 24, 21, 20, 16, 13, 16,
    27, 29, 30, 31, 31, 30, 32, 32, 31, 31, 30, 26, 13, 29, 30, 22, 23, 15, 9, 12,
    24, 26, 28, 29, 29, 28, 25, 27, 28, 29, 28, 24, 19, 27, 19, 24, 20, 11, 4, 6,
    14, 13, 11, 9, 0, 11, 19, 19, 10, 8, 7, 15, 20, 16, 10, 15, 7, 0, 0, 10,
    15, 14, 12, 5, 10, 15, 8, 16, 0, 12, 6, 13, 5, 8, 13, 10, 5, 11, 6, 0,
    6, 4, 7, 11, 12, 8, 6, 0, 9, 10, 0, 9, 0, 15, 10, 7, 7, 5, 7, 7,
    7, 11, 13, 15, 15, 12, 8, 14, 10, 14, 5, 6, 12, 5, 5, 13, 5, 6, 2, 5,
    15, 15, 14, 14, 13, 11, 10, 0, 12, 15, 15, 18, 16, 12, 10, 15, 14, 15, 0, 2,
    17, 16, 13, 7, 15, 20, 16, 18, 14, 14, 13, 10, 12, 10, 11, 14, 16, 15, 15, 10,
    23, 22, 22, 20, 13, 10, 23, 21, 15, 7, 16, 16, 10, 9, 15, 0, 0, 10, 9, 9,
    31, 32, 33, 32, 30, 28, 26, 26, 19, 20, 18, 10, 14, 0, 13, 11, 10, 3, 8, 7,
    15, 15, 13, 8, 2, 12, 17, 17, 5, 9, 11, 12, 10, 14, 8, 0, 10, 0, 6, 9,
    47, 48, 46, 41, 45, 42, 48, 47, 47, 48, 46, 51, 47, 43, 48, 38, 42, 27, 42, 34,
    47, 60, 67, 71, 76, 77, 79, 80, 81, 82, 82, 81, 80, 78, 76, 73, 65, 51, 42, 38,
    65, 71, 75, 77, 80, 82, 83, 83, 81, 81, 82, 81, 81, 79, 78, 76, 72, 70, 65, 60,
    63, 69, 73, 76, 80, 81, 81, 79, 80, 81, 80, 80, 80, 79, 79, 78, 77, 75, 73, 71,
    67, 71, 73, 75, 77, 78, 78, 78, 78, 78, 79, 78, 78, 77, 77, 76, 74, 72, 66, 59,
    65, 69, 72, 74, 75, 75, 73, 72, 75, 77, 78, 78, 78, 78, 77, 75, 72, 69, 63, 57,
    68, 71, 73, 75, 76, 76, 76, 76, 75, 76, 76, 76, 75, 75, 74, 73, 71, 69, 65, 62,
    47, 45, 35, 42, 56, 59, 57, 53, 56, 55, 54, 55, 54, 55, 53, 52, 51, 50, 47, 44,
    56, 56, 57, 57, 59, 60, 60, 62, 61, 61, 59, 60, 60, 59, 57, 58, 55, 54, 51, 48,
    55, 57, 58, 56, 46, 57, 63, 65, 65, 66, 67, 66, 66, 66, 65, 64, 63, 62, 58, 55,
    43, 51, 57, 62, 67, 70, 71, 73, 74, 74, 75, 74, 74, 74, 73, 72, 70, 69, 65, 61,
    56, 61, 64, 67, 69, 70, 72, 72, 71, 71, 71, 71, 71, 70, 70, 69, 68, 66, 63, 60,
    55, 58, 61, 63, 65, 63, 70, 71, 71, 72, 72, 72, 72, 72, 72, 71, 69, 67, 61, 56,
    53, 56, 58, 61, 66, 71, 76, 76, 76, 76, 75, 75, 73, 72, 70, 69, 67, 62, 37, 51,
    55, 59, 61, 63, 64, 64, 66, 66, 67, 67, 67, 67, 66, 65, 62, 60, 52, 50, 55, 56,
    52, 54, 56, 57, 56, 55, 56, 55, 53, 54, 52, 52, 50, 49, 43, 31, 45, 48, 44, 28,
    46, 47, 48, 47, 43, 44, 48, 49, 49, 48, 49, 47, 46, 45, 39, 28, 38, 42, 34, 34,
    53, 57, 59, 61, 61, 61, 62, 62, 62, 61, 61, 60, 57, 55, 45, 45, 55, 54, 46, 46,
    51, 54, 57, 59, 61, 62, 61, 61, 61, 60, 59, 59, 57, 55, 45, 46, 55, 52, 47, 42,
    45, 48, 51, 52, 54, 55, 57, 56, 58, 59, 59, 59, 59, 57, 51, 47, 56, 48, 51, 47,
    49, 51, 53, 54, 55, 57, 59, 59, 57, 56, 56, 54, 53, 50, 34, 50, 51, 38, 36, 42,
    52, 55, 56, 57, 58, 57, 57, 56, 58, 58, 58, 58, 57, 55, 34, 52, 52, 45, 37, 30,
    51, 54, 56, 57, 58, 58, 59, 60, 59, 58, 56, 54, 50, 48, 54, 56, 44, 52, 48, 43,
    47, 48, 49, 48, 42, 32, 42, 46, 49, 51, 52, 52, 51, 47, 40, 48, 31, 44, 36, 29,
    44, 44, 42, 40, 34, 35, 30, 35, 45, 43, 42, 28, 39, 13, 39, 35, 29, 33, 11, 15,
    39, 42, 46, 49, 51, 49, 37, 48, 40, 48, 39, 37, 34, 37, 33, 32, 32, 31, 19, 4,
    54, 56, 57, 57, 51, 44, 48, 54, 55, 54, 55, 55, 53, 51, 44, 44, 40, 42, 37, 29,
    48, 50, 51, 52, 52, 51, 41, 40, 33, 35, 37, 38, 36, 40, 39, 39, 35, 30, 27, 17,
    42, 44, 44, 44, 44, 43, 44, 44, 43, 45, 45, 44, 43, 41, 41, 38, 36, 31, 27, 20,
    41, 43, 44, 45, 44, 44, 45, 46, 47, 46, 46, 45, 33, 40, 43, 36, 32, 25, 19, 16,
    26, 25, 28, 32, 36, 35, 34, 37, 38, 40, 38, 37, 24, 35, 28, 35, 31, 26, 17, 22,
    28, 27, 26, 23, 18, 23, 32, 27, 26, 24, 22, 23, 27, 25, 21, 16, 11, 11, 6, 6,
    24, 26, 28, 28, 26, 23, 26, 22, 22, 21, 23, 25, 22, 21, 21, 10, 15, 10, 11, 7,
    31, 32, 32, 31, 27, 16, 25, 23, 10, 15, 22, 9, 1, 10, 14, 14, 15, 11, 14, 7,
    12, 19, 22, 23, 21, 21, 16, 19, 14, 10, 10, 17, 12, 7, 11, 15, 14, 2, 1, 5,
    28, 28, 30, 30, 29, 25, 25, 24, 25, 26, 27, 23, 27, 22, 24, 23, 20, 19, 11, 12,
    37, 38, 37, 35, 24, 30, 34, 20, 24, 31, 6, 31, 27, 30, 22, 27, 12, 21, 13, 14,
    47, 50, 51, 51, 50, 45, 41, 40, 36, 36, 29, 28, 31, 25, 24, 21, 24, 14, 9, 10,
    41, 42, 42, 41, 38, 40, 40, 41, 39, 36, 38, 30, 27, 34, 36, 26, 27, 24, 13, 15,
    31, 33, 32, 30, 20, 26, 27, 26, 22, 25, 13, 20, 23, 17, 13, 20, 4, 11, 6, 7,
    60, 59, 58, 56, 60, 63, 63, 44, 60, 60, 54, 53, 46, 40, 43, 44, 41, 40, 44, 47,
    67, 73, 79, 82, 87, 88, 89, 92, 93, 93, 92, 91, 89, 87, 86, 85, 81, 76, 60, 44,
    69, 77, 82, 86, 89, 92, 94, 94, 93, 93, 94, 93, 92, 92, 90, 88, 84, 80, 73, 66,
    73, 78, 82, 86, 90, 92, 92, 90, 90, 92, 91, 91, 91, 90, 90, 88, 87, 86, 83, 80,
    74, 78, 81, 83, 86, 88, 89, 89, 90, 89, 90, 89, 89, 88, 88, 87, 85, 84, 79, 72,
    66, 74, 79, 82, 86, 88, 87, 84, 86, 87, 87, 88, 88, 87, 86, 84, 82, 80, 74, 68,
    80, 83, 85, 87, 90, 90, 91, 90, 89, 90, 90, 90, 89, 89, 88, 87, 85, 83, 79, 76,
    56, 56, 63, 68, 74, 77, 74, 67, 69, 69, 68, 68, 68, 68, 67, 65, 63, 62, 59, 55,
    71, 73, 74, 75, 75, 75, 73, 74, 73, 75, 72, 72, 72, 71, 67, 71, 67, 65, 63, 60,
    65, 68, 70, 70, 71, 76, 77, 79, 79, 80, 80, 80, 80, 80, 79, 78, 76, 75, 72, 68,
    65, 70, 73, 76, 81, 83, 86, 87, 88, 89, 89, 88, 87, 87, 86, 85, 84, 83, 79, 76,
    67, 73, 77, 80, 83, 83, 85, 86, 85, 84, 84, 83, 84, 83, 82, 81, 79, 78, 74, 72,
    66, 70, 73, 77, 81, 80, 83, 86, 86, 84, 86, 85, 85, 84, 84, 83, 82, 80, 74, 68,
    64, 69, 72, 76, 83, 88, 93, 93, 93, 93, 92, 92, 90, 88, 86, 85, 84, 80, 54, 66,
    71, 76, 79, 81, 83, 83, 85, 85, 87, 87, 86, 85, 84, 82, 78, 74, 62, 70, 73, 71,
    69, 72, 74, 75, 76, 76, 75, 73, 72, 69, 67, 64, 64, 61, 47, 51, 62, 64, 58, 50,
    65, 67, 67, 66, 63, 64, 68, 69, 70, 71, 70, 69, 68, 67, 61, 44, 61, 64, 55, 55,
    70, 74, 77, 79, 81, 81, 81, 80, 81, 81, 81, 81, 79, 77, 69, 61, 75, 75, 65, 67,
    70, 73, 75, 77, 79, 80, 80, 79, 80, 78, 78, 76, 74, 72, 60, 64, 71, 69, 63, 58,
    64, 68, 72, 74, 76, 77, 77, 73, 75, 75, 75, 75, 75, 75, 71, 67, 69, 66, 65, 59,
    68, 71, 73, 74, 76, 78, 79, 78, 75, 75, 74, 74, 73, 70, 62, 68, 71, 58, 56, 60,
    76, 79, 80, 81, 82, 83, 83, 82, 83, 82, 82, 81, 78, 74, 69, 77, 72, 71, 64, 57,
    75, 78, 80, 82, 83, 83, 85, 85, 83, 84, 82, 79, 73, 66, 78, 80, 60, 75, 71, 66,
    70, 72, 73, 73, 69, 60, 67, 65, 69, 72, 74, 74, 73, 73, 56, 68, 58, 65, 59, 41,
    60, 60, 51, 53, 67, 69, 64, 58, 69, 64, 62, 62, 63, 44, 61, 57, 54, 53, 42, 28,
    70, 74, 77, 79, 81, 78, 68, 76, 72, 75, 66, 62, 62, 64, 55, 57, 52, 50, 42, 19,
    78, 81, 82, 82, 72, 79, 85, 86, 88, 88, 88, 88, 86, 82, 78, 75, 75, 74, 64, 60,
    72, 75, 77, 78, 78, 77, 60, 72, 66, 67, 71, 73, 74, 73, 70, 66, 66, 60, 56, 51,
    72, 74, 75, 75, 76, 76, 80, 81, 82, 82, 83, 82, 77, 73, 78, 69, 64, 59, 51, 43,
    72, 76, 79, 81, 82, 83, 83, 83, 84, 83, 82, 79, 72, 78, 76, 73, 68, 63, 48, 49,
    66, 70, 73, 75, 77, 78, 76, 77, 77, 78, 78, 75, 59, 74, 60, 72, 68, 58, 56, 55,
    64, 65, 65, 65, 66, 67, 69, 67, 69, 65, 55, 64, 70, 68, 64, 62, 54, 44, 51, 50,
    54, 57, 59, 60, 59, 57, 55, 53, 51, 57, 60, 62, 57, 24, 57, 52, 52, 48, 27, 38,
    60, 62, 63, 64, 62, 59, 50, 48, 54, 42, 47, 44, 44, 41, 45, 38, 41, 34, 30, 22,
    61, 63, 65, 65, 63, 59, 54, 56, 61, 49, 61, 62, 59, 49, 53, 54, 49, 49, 40, 36,
    49, 55, 60, 63, 65, 64, 59, 67, 69, 70, 74, 73, 64, 67, 61, 67, 55, 55, 48, 49,
    62, 64, 65, 64, 58, 58, 63, 71, 76, 73, 74, 59, 67, 60, 71, 65, 62, 57, 34, 42,
    64, 68, 72, 75, 77, 79, 86, 83, 83, 82, 60, 73, 66, 72, 69, 64, 63, 58, 43, 35,
    69, 72, 74, 75, 76, 77, 80, 79, 80, 76, 74, 74, 69, 75, 71, 62, 60, 56, 48, 41,
    62, 62, 61, 59, 61, 61, 52, 64, 67, 62, 53, 62, 59, 56, 59, 61, 42, 48, 44, 40,
    54, 54, 53, 50, 43, 45, 53, 42, 41, 37, 38, 44, 34, 43, 47, 41, 46, 45, 44, 45,
    68, 72, 74, 75, 77, 77, 76, 75, 74, 75, 73, 72, 72, 71, 70, 68, 64, 61, 62, 63,
    65, 67, 68, 67, 63, 60, 62, 61, 60, 56, 58, 56, 59, 58, 57, 56, 54, 55, 52, 50,
    68, 70, 71, 72, 71, 70, 70, 70, 69, 68, 68, 68, 67, 66, 63, 60, 53, 52, 52, 47,
    70, 72, 73, 73, 74, 75, 76, 76, 77, 77, 77, 77, 75, 74, 71, 68, 59, 55, 63, 63,
    65, 66, 67, 67, 67, 67, 67, 69, 70, 70, 70, 70, 69, 68, 67, 66, 62, 54, 52, 57,
    54, 56, 58, 59, 60, 61, 60, 58, 53, 53, 55, 55, 53, 53, 50, 48, 42, 32, 38, 41,
    46, 48, 50, 49, 45, 44, 44, 36, 37, 38, 40, 39, 38, 37, 38, 32, 35, 32, 19, 24,
    54, 54, 54, 55, 56, 57, 54, 50, 47, 48, 48, 48, 48, 45, 45, 42, 39, 34, 34, 40,
    62, 64, 65, 65, 66, 67, 66, 67, 67, 67, 67, 66, 66, 65, 63, 62, 58, 55, 46, 38,
    62, 63, 64, 64, 63, 62, 60, 60, 60, 60, 60, 59, 57, 55, 49, 31, 50, 52, 46, 43,
    60, 61, 62, 63, 63, 63, 61, 61, 62, 61, 61, 60, 58, 56, 51, 44, 42, 47, 44, 36,
    55, 56, 57, 58, 58, 58, 56, 56, 55, 55, 54, 52, 52, 50, 46, 42, 34, 38, 42, 40,
    51, 52, 52, 52, 52, 51, 51, 51, 52, 53, 52, 52, 52, 52, 50, 49, 46, 46, 42, 10,
    47, 49, 50, 51, 51, 50, 51, 51, 51, 50, 49, 48, 47, 45, 41, 38, 31, 36, 37, 34,
    36, 37, 38, 38, 37, 37, 37, 36, 38, 37, 38, 38, 36, 33, 31, 30, 25, 22, 24, 23,
    25, 26, 27, 27, 29, 28, 26, 29, 28, 26, 21, 23, 23, 20, 16, 16, 15, 21, 17, 18,
    34, 35, 36, 37, 37, 36, 34, 35, 36, 36, 36, 35, 34, 34, 31, 28, 23, 20, 19, 20,
    34, 35, 36, 36, 36, 37, 36, 35, 36, 34, 33, 32, 30, 24, 24, 27, 28, 27, 19, 18,
    29, 31, 32, 32, 31, 31, 29, 33, 33, 30, 29, 31, 30, 30, 26, 27, 26, 16, 15, 19,
    24, 25, 27, 28, 29, 27, 29, 30, 29, 29, 28, 26, 21, 25, 15, 19, 18, 16, 10, 9,
    30, 32, 34, 35, 34, 34, 36, 36, 37, 37, 36, 36, 32, 29, 25, 27, 30, 17, 13, 15,
    22, 23, 24, 23, 21, 23, 26, 26, 29, 24, 25, 23, 20, 20, 23, 20, 15, 6, 16, 17,
    14, 20, 23, 24, 24, 22, 27, 16, 23, 18, 19, 12, 16, 16, 3, 11, 14, 9, 19, 19,
    25, 25, 23, 23, 28, 24, 18, 17, 22, 21, 15, 16, 13, 12, 14, 14, 12, 11, 12, 0,
    22, 19, 17, 23, 28, 27, 25, 23, 23, 24, 20, 19, 14, 14, 12, 11, 9, 6, 5, 4,
    13, 9, 15, 19, 21, 22, 21, 24, 13, 20, 18, 13, 3, 17, 19, 18, 11, 1, 0, 9,
    19, 19, 17, 10, 12, 13, 19, 6, 15, 10, 16, 7, 12, 7, 19, 8, 4, 8, 12, 11,
    14, 15, 17, 19, 21, 22, 20, 22, 16, 17, 19, 11, 16, 19, 16, 8, 12, 20, 17, 8,
    24, 25, 25, 25, 23, 23, 24, 22, 18, 20, 16, 13, 21, 17, 18, 6, 19, 16, 3, 17,
    18, 15, 9, 0, 13, 14, 15, 15, 9, 17, 13, 9, 10, 11, 13, 10, 11, 9, 0, 7,
    17, 19, 20, 19, 9, 9, 11, 8, 12, 16, 9, 11, 6, 8, 8, 2, 0, 12, 7, 8,
    19, 21, 21, 20, 13, 5, 5, 0, 16, 12, 10, 8, 13, 12, 10, 5, 9, 0, 8, 6,
    21, 22, 21, 19, 7, 0, 12, 11, 3, 7, 0, 9, 13, 12, 6, 1, 8, 0, 6, 0,
    16, 19, 20, 18, 18, 17, 10, 4, 16, 0, 6, 10, 5, 7, 0, 3, 9, 0, 3, 8,
    13, 18, 20, 20, 5, 11, 11, 6, 3, 8, 5, 0, 0, 6, 0, 10, 10, 5, 5, 4,
    19, 24, 26, 27, 22, 5, 9, 6, 12, 0, 5, 10, 6, 10, 6, 11, 5, 3, 0, 0,
    21, 23, 24, 23, 20, 12, 16, 13, 14, 12, 11, 0, 3, 11, 3, 13, 7, 10, 2, 5,
    16, 17, 18, 17, 13, 6, 7, 13, 10, 9, 7, 4, 4, 7, 9, 7, 3, 5, 6, 2,
    15, 16, 14, 11, 8, 11, 5, 0, 12, 3, 6, 0, 8, 6, 9, 2, 2, 5, 0, 0,
    53, 60, 62, 64, 63, 58, 59, 56, 47, 56, 50, 56, 50, 53, 50, 48, 50, 41, 48, 44,
    62, 69, 74, 78, 83, 85, 86, 84, 82, 83, 81, 81, 80, 79, 78, 76, 71, 68, 71, 70,
    57, 62, 70, 74, 76, 72, 70, 69, 68, 64, 63, 64, 65, 65, 64, 63, 63, 62, 61, 59,
    68, 74, 77, 79, 81, 81, 78, 78, 78, 76, 76, 75, 74, 73, 71, 68, 61, 58, 61, 58,
    71, 76, 80, 82, 83, 84, 86, 86, 88, 87, 87, 86, 85, 84, 82, 79, 68, 66, 74, 74,
    64, 70, 74, 77, 78, 78, 78, 79, 81, 81, 80, 80, 80, 79, 78, 76, 72, 66, 60, 67,
    66, 68, 69, 70, 71, 72, 73, 72, 68, 65, 66, 66, 65, 65, 64, 62, 59, 54, 41, 50,
    57, 59, 61, 61, 61, 56, 57, 53, 51, 53, 51, 53, 54, 50, 50, 49, 45, 40, 31, 29,
    64, 67, 68, 68, 69, 70, 71, 67, 60, 61, 62, 62, 62, 59, 58, 57, 53, 50, 48, 52,
    68, 73, 76, 78, 80, 81, 82, 82, 83, 83, 82, 82, 81, 80, 79, 77, 74, 70, 63, 57,
    70, 75, 77, 78, 79, 79, 75, 75, 76, 75, 75, 74, 73, 71, 64, 53, 65, 66, 58, 57,
    71, 75, 77, 78, 79, 80, 79, 78, 79, 79, 78, 78, 76, 74, 70, 64, 56, 63, 61, 55,
    66, 71, 73, 75, 76, 77, 76, 73, 75, 73, 73, 73, 72, 71, 69, 65, 59, 42, 56, 56,
    64, 68, 71, 72, 73, 73, 71, 71, 70, 71, 72, 72, 72, 72, 71, 70, 68, 67, 62, 49,
    61, 65, 68, 70, 73, 73, 73, 74, 73, 73, 73, 72, 71, 69, 67, 63, 52, 51, 57, 54,
    59, 61, 61, 61, 61, 62, 63, 63, 63, 63, 62, 62, 60, 59, 56, 53, 48, 29, 52, 49,
    54, 56, 56, 56, 55, 53, 51, 54, 52, 52, 52, 51, 50, 49, 48, 45, 40, 38, 42, 40,
    58, 61, 63, 63, 62, 61, 61, 62, 62, 62, 62, 61, 60, 58, 55, 52, 43, 44, 47, 45,
    60, 64, 67, 68, 69, 69, 68, 67, 67, 66, 65, 64, 63, 60, 54, 48, 53, 55, 53, 43,
    48, 55, 60, 62, 63, 63, 64, 64, 63, 62, 62, 62, 61, 60, 57, 56, 56, 46, 44, 35,
    58, 62, 63, 63, 63, 64, 64, 65, 65, 65, 63, 63, 61, 59, 54, 49, 51, 56, 49, 45,
    57, 62, 65, 68, 70, 71, 70, 71, 71, 71, 70, 68, 65, 57, 59, 65, 62, 49, 50, 50,
    48, 47, 49, 53, 56, 55, 57, 59, 60, 59, 55, 58, 56, 52, 50, 49, 43, 48, 47, 31,
    58, 60, 60, 59, 50, 52, 52, 51, 43, 51, 40, 45, 30, 36, 40, 42, 43, 33, 36, 34,
    59, 60, 61, 62, 60, 56, 58, 58, 57, 56, 54, 53, 50, 46, 14, 43, 41, 32, 32, 29,
    58, 59, 59, 58, 56, 56, 45, 52, 49, 51, 35, 43, 43, 38, 43, 39, 32, 24, 17, 22,
    45, 49, 50, 51, 52, 50, 46, 45, 41, 44, 39, 39, 39, 37, 35, 28, 26, 24, 17, 23,
    43, 46, 47, 47, 46, 47, 51, 49, 48, 47, 45, 44, 40, 42, 39, 42, 33, 41, 31, 32,
    46, 48, 50, 50, 50, 50, 49, 47, 44, 40, 35, 36, 45, 45, 35, 41, 40, 38, 34, 29,
    35, 38, 41, 43, 44, 43, 40, 35, 37, 37, 34, 32, 28, 33, 30, 29, 24, 29, 19, 20,
    40, 42, 43, 42, 40, 37, 32, 38, 36, 36, 35, 33, 26, 29, 31, 28, 22, 5, 4, 13,
    21, 22, 32, 35, 35, 31, 34, 29, 29, 17, 8, 25, 31, 31, 20, 28, 26, 24, 18, 13,
    39, 42, 43, 43, 40, 36, 36, 34, 29, 30, 23, 23, 29, 29, 18, 22, 13, 16, 15, 10,
    34, 35, 35, 33, 29, 31, 27, 14, 3, 21, 20, 20, 14, 18, 17, 16, 13, 10, 5, 6,
    24, 24, 24, 26, 31, 31, 11, 27, 26, 14, 12, 12, 17, 21, 7, 13, 11, 0, 2, 8,
    40, 43, 44, 45, 41, 29, 27, 36, 34, 26, 25, 20, 20, 21, 17, 15, 13, 5, 0, 11,
    38, 39, 38, 34, 29, 38, 32, 41, 28, 27, 34, 30, 25, 30, 30, 25, 25, 19, 9, 7,
    25, 28, 30, 31, 31, 32, 31, 33, 32, 30, 12, 28, 23, 21, 26, 26, 19, 18, 10, 0,
    22, 24, 31, 35, 36, 30, 29, 26, 25, 8, 23, 27, 15, 20, 22, 24, 18, 15, 11, 9,
    33, 34, 33, 29, 23, 27, 23, 27, 19, 21, 24, 14, 23, 25, 18, 21, 9, 8, 4, 3,
    59, 67, 71, 73, 73, 68, 66, 67, 48, 65, 55, 66, 55, 63, 58, 53, 59, 47, 49, 54,
    74, 80, 85, 88, 93, 95, 95, 93, 91, 92, 91, 91, 89, 89, 87, 85, 79, 77, 79, 77,
    70, 73, 79, 84, 86, 83, 77, 80, 73, 65, 65, 65, 59, 64, 65, 68, 71, 72, 71, 69,
    72, 80, 84, 87, 90, 91, 89, 90, 89, 87, 86, 85, 84, 82, 79, 74, 66, 63, 66, 64,
    81, 86, 89, 91, 92, 93, 95, 96, 96, 96, 95, 94, 93, 92, 90, 87, 75, 75, 83, 83,
    71, 78, 83, 86, 88, 88, 88, 88, 90, 90, 90, 89, 89, 88, 87, 86, 82, 77, 67, 75,
    75, 78, 79, 81, 83, 84, 84, 83, 79, 79, 77, 78, 76, 74, 72, 69, 66, 61, 59, 62,
    68, 70, 71, 70, 70, 69, 65, 67, 62, 65, 65, 66, 65, 64, 62, 60, 57, 53, 31, 47,
    73, 77, 79, 80, 80, 81, 82, 78, 73, 75, 75, 74, 73, 72, 71, 68, 64, 60, 58, 61,
    78, 83, 87, 89, 91, 92, 93, 93, 94, 94, 93, 93, 92, 91, 89, 87, 84, 80, 74, 69,
    80, 85, 88, 89, 90, 90, 87, 87, 87, 87, 87, 85, 84, 82, 75, 67, 75, 77, 67, 66,
    82, 86, 88, 89, 91, 91, 90, 89, 91, 91, 90, 89, 87, 86, 81, 74, 67, 74, 71, 65,
    78, 82, 85, 87, 89, 90, 91, 86, 87, 83, 85, 84, 84, 82, 80, 76, 69, 55, 66, 67,
    75, 81, 84, 85, 85, 85, 83, 82, 82, 84, 84, 85, 85, 85, 85, 84, 81, 79, 72, 59,
    74, 79, 82, 85, 87, 87, 87, 87, 87, 86, 84, 84, 82, 81, 78, 75, 64, 60, 67, 64,
    73, 75, 76, 76, 76, 78, 78, 77, 77, 76, 76, 75, 73, 71, 67, 65, 61, 53, 63, 61,
    68, 70, 70, 70, 68, 66, 67, 69, 69, 68, 67, 68, 66, 65, 64, 60, 53, 53, 56, 51,
    72, 76, 78, 78, 78, 77, 78, 79, 79, 79, 79, 77, 75, 74, 70, 67, 56, 58, 61, 62,
    75, 79, 82, 83, 84, 84, 83, 83, 83, 83, 82, 81, 79, 77, 71, 55, 67, 69, 67, 55,
    63, 71, 76, 79, 80, 80, 81, 81, 81, 81, 81, 81, 79, 78, 74, 73, 73, 66, 61, 52,
    74, 79, 81, 81, 81, 82, 82, 83, 82, 82, 81, 81, 79, 77, 71, 62, 62, 71, 64, 59,
    76, 80, 84, 86, 89, 90, 89, 89, 89, 88, 87, 85, 81, 74, 76, 82, 79, 66, 62, 64,
    67, 67, 69, 73, 75, 74, 78, 81, 81, 80, 74, 79, 75, 70, 66, 68, 61, 66, 65, 52,
    76, 79, 79, 77, 59, 66, 72, 73, 67, 73, 67, 70, 61, 54, 60, 64, 63, 51, 58, 55,
    78, 79, 79, 81, 82, 80, 77, 82, 81, 80, 78, 76, 74, 68, 57, 65, 62, 58, 54, 52,
    78, 81, 82, 82, 79, 80, 79, 76, 66, 66, 65, 61, 57, 57, 58, 50, 52, 39, 40, 30,
    73, 74, 71, 68, 79, 81, 78, 77, 77, 79, 73, 70, 71, 68, 69, 67, 58, 61, 52, 39,
    58, 54, 58, 63, 67, 63, 54, 58, 48, 54, 58, 57, 62, 60, 61, 59, 57, 48, 47, 26,
    67, 71, 73, 74, 75, 75, 77, 76, 72, 72, 71, 67, 60, 68, 68, 63, 59, 64, 53, 50,
    73, 76, 78, 78, 79, 79, 79, 79, 77, 76, 72, 64, 71, 74, 61, 70, 68, 68, 63, 58,
    57, 63, 67, 69, 70, 69, 68, 65, 65, 64, 61, 60, 48, 62, 64, 39, 57, 58, 41, 47,
    63, 65, 66, 66, 62, 60, 64, 63, 56, 63, 64, 62, 54, 60, 56, 56, 51, 46, 42, 32,
    54, 58, 61, 64, 68, 69, 68, 68, 67, 65, 62, 51, 61, 65, 49, 62, 58, 56, 51, 46,
    61, 63, 65, 65, 63, 62, 64, 61, 60, 59, 55, 50, 51, 54, 49, 50, 44, 43, 42, 28,
    61, 62, 62, 62, 59, 55, 41, 49, 48, 44, 50, 50, 51, 37, 38, 35, 44, 36, 32, 22,
    42, 47, 51, 51, 48, 39, 41, 38, 34, 43, 48, 35, 42, 44, 40, 34, 28, 35, 30, 21,
    55, 54, 53, 59, 67, 69, 67, 62, 53, 60, 62, 60, 57, 56, 51, 54, 57, 43, 41, 11,
    60, 62, 62, 60, 56, 62, 65, 63, 61, 66, 65, 47, 60, 49, 50, 45, 40, 38, 30, 20,
    52, 54, 55, 54, 54, 54, 61, 67, 62, 68, 62, 62, 57, 50, 60, 54, 51, 43, 30, 30,
    52, 54, 56, 58, 63, 64, 64, 59, 59, 56, 61, 61, 52, 60, 59, 57, 50, 42, 25, 34,
    59, 63, 66, 67, 65, 61, 57, 44, 54, 53, 52, 53, 53, 51, 51, 48, 47, 50, 43, 39,
    60, 62, 68, 70, 72, 74, 70, 70, 71, 69, 68, 68, 67, 65, 62, 58, 58, 50, 44, 42,
    69, 73, 75, 76, 78, 79, 79, 78, 75, 73, 68, 67, 63, 58, 48, 43, 21, 36, 40, 43,
    65, 69, 71, 71, 71, 72, 73, 73, 74, 74, 74, 73, 71, 69, 67, 65, 65, 62, 58, 56,
    57, 59, 62, 64, 65, 64, 68, 71, 70, 71, 72, 71, 70, 68, 65, 62, 51, 53, 57, 55,
    60, 62, 61, 57, 55, 60, 64, 65, 61, 62, 62, 61, 60, 59, 57, 55, 49, 45, 51, 52,
    58, 61, 63, 66, 68, 69, 71, 71, 71, 71, 70, 69, 67, 64, 51, 60, 68, 66, 58, 59,
    48, 52, 56, 60, 64, 63, 61, 60, 59, 59, 57, 55, 53, 53, 48, 41, 38, 27, 35, 37,
    54, 56, 58, 57, 54, 53, 56, 54, 52, 48, 51, 51, 50, 47, 41, 41, 47, 48, 40, 42,
    52, 53, 50, 42, 48, 52, 51, 51, 52, 54, 54, 53, 52, 51, 48, 46, 45, 45, 33, 34,
    51, 53, 53, 55, 56, 57, 56, 55, 50, 46, 47, 49, 47, 47, 45, 44, 41, 38, 31, 21,
    53, 56, 57, 57, 56, 52, 46, 33, 43, 41, 44, 47, 46, 45, 43, 41, 29, 20, 26, 26,
    51, 52, 54, 56, 59, 59, 60, 60, 60, 61, 58, 60, 59, 58, 54, 51, 34, 32, 36, 41,
    50, 54, 56, 57, 58, 58, 58, 58, 58, 59, 58, 57, 54, 50, 47, 49, 50, 48, 42, 39,
    37, 42, 45, 46, 46, 45, 44, 44, 46, 46, 45, 44, 45, 44, 39, 36, 38, 28, 37, 36,
    39, 42, 43, 44, 44, 43, 44, 45, 45, 45, 44, 44, 41, 37, 36, 39, 35, 39, 34, 29,
    32, 33, 33, 30, 11, 20, 22, 21, 20, 25, 23, 20, 23, 10, 20, 11, 13, 18, 12, 9,
    24, 23, 22, 22, 26, 28, 26, 25, 20, 23, 24, 22, 19, 17, 10, 18, 13, 20, 17, 7,
    26, 30, 32, 34, 31, 27, 29, 32, 28, 27, 27, 13, 31, 30, 28, 21, 19, 26, 8, 12,
    31, 33, 30, 19, 30, 13, 30, 29, 31, 26, 24, 25, 26, 23, 24, 23, 11, 22, 13, 0,
    15, 25, 29, 29, 29, 30, 31, 29, 31, 30, 28, 27, 27, 23, 14, 24, 16, 12, 12, 13,
    21, 23, 23, 23, 23, 24, 27, 22, 24, 23, 11, 23, 19, 15, 17, 11, 10, 22, 13, 13,
    27, 27, 26, 26, 27, 25, 26, 27, 27, 24, 16, 16, 22, 21, 11, 21, 18, 23, 13, 19,
    23, 24, 21, 17, 20, 17, 14, 18, 12, 14, 12, 20, 12, 1, 13, 10, 8, 7, 10, 9,
    28, 31, 32, 31, 25, 26, 31, 27, 27, 20, 24, 22, 21, 15, 15, 18, 5, 6, 4, 4,
    24, 21, 17, 18, 19, 20, 19, 20, 7, 7, 19, 7, 17, 16, 16, 15, 10, 7, 0, 9,
    0, 9, 10, 8, 12, 11, 10, 16, 22, 17, 19, 14, 9, 17, 13, 8, 13, 4, 10, 0,
    15, 19, 22, 23, 24, 23, 19, 20, 11, 12, 11, 14, 21, 15, 19, 6, 15, 12, 3, 1,
    14, 19, 22, 21, 18, 20, 21, 19, 15, 12, 14, 15, 18, 12, 19, 13, 11, 0, 6, 11,
    17, 17, 17, 17, 10, 9, 13, 8, 1, 11, 0, 13, 16, 10, 9, 0, 7, 7, 9, 0,
    15, 12, 5, 0, 10, 12, 6, 9, 6, 11, 13, 13, 15, 0, 12, 11, 2, 2, 6, 10,
    11, 10, 9, 1, 4, 9, 11, 11, 12, 7, 14, 12, 10, 11, 0, 11, 6, 3, 0, 9,
    16, 14, 9, 0, 1, 8, 0, 1, 11, 0, 0, 5, 5, 9, 13, 16, 12, 13, 13, 9,
    14, 14, 11, 3, 5, 5, 5, 7, 0, 10, 7, 7, 10, 12, 4, 3, 8, 6, 0, 6,
    19, 16, 8, 12, 10, 9, 13, 9, 13, 17, 11, 13, 4, 0, 0, 12, 10, 3, 8, 5,
    14, 17, 21, 22, 15, 16, 18, 16, 11, 12, 14, 9, 11, 8, 14, 7, 0, 9, 6, 0,
    8, 7, 8, 8, 15, 16, 11, 8, 12, 6, 8, 4, 6, 3, 11, 0, 4, 7, 7, 0,
    12, 9, 7, 7, 9, 12, 0, 10, 12, 3, 0, 10, 8, 8, 12, 1, 1, 7, 0, 2,
    5, 4, 7, 5, 6, 9, 0, 1, 9, 0, 7, 9, 8, 0, 4, 6, 0, 0, 7, 11,
    9, 1, 2, 3, 0, 7, 10, 8, 10, 11, 0, 0, 7, 6, 7, 5, 0, 4, 0, 0,
    55, 63, 71, 75, 77, 73, 73, 45, 68, 65, 60, 60, 63, 64, 62, 62, 61, 58, 54, 54,
    69, 71, 70, 77, 84, 85, 84, 82, 84, 82, 81, 80, 80, 78, 76, 73, 67, 59, 44, 50,
    74, 81, 85, 87, 89, 90, 90, 90, 88, 84, 80, 77, 72, 66, 62, 54, 46, 33, 54, 59,
    72, 79, 82, 84, 83, 83, 85, 86, 86, 86, 86, 86, 85, 84, 82, 80, 78, 74, 69, 63,
    70, 71, 73, 76, 80, 79, 82, 84, 85, 85, 86, 86, 85, 84, 82, 79, 69, 64, 72, 68,
    69, 75, 78, 77, 71, 73, 80, 81, 78, 78, 78, 77, 76, 76, 74, 73, 68, 63, 66, 67,
    68, 74, 77, 79, 84, 86, 87, 87, 87, 86, 85, 85, 83, 80, 68, 72, 82, 80, 70, 71,
    63, 67, 70, 73, 79, 81, 78, 78, 76, 76, 74, 70, 71, 70, 66, 59, 43, 49, 53, 54,
    67, 72, 76, 77, 76, 75, 76, 75, 71, 69, 70, 69, 67, 64, 56, 56, 62, 64, 57, 61,
    68, 73, 75, 73, 48, 70, 72, 72, 72, 73, 74, 74, 73, 72, 69, 66, 64, 65, 57, 52,
    67, 72, 74, 74, 75, 77, 77, 75, 71, 66, 65, 68, 65, 67, 64, 62, 59, 57, 49, 40,
    67, 73, 76, 77, 76, 73, 68, 62, 65, 59, 51, 61, 56, 52, 55, 50, 45, 43, 50, 53,
    68, 72, 73, 75, 81, 83, 82, 82, 84, 85, 79, 85, 84, 82, 78, 77, 68, 60, 63, 58,
    69, 74, 78, 81, 83, 83, 83, 83, 82, 83, 82, 80, 76, 67, 71, 69, 76, 70, 65, 62,
    60, 62, 68, 72, 73, 73, 72, 71, 71, 70, 69, 68, 67, 64, 57, 59, 62, 61, 59, 60,
    63, 68, 70, 72, 73, 73, 73, 73, 73, 73, 72, 70, 66, 57, 67, 69, 63, 66, 60, 52,
    64, 67, 68, 68, 63, 56, 56, 57, 56, 58, 56, 54, 49, 41, 53, 52, 50, 42, 36, 40,
    47, 50, 51, 42, 54, 56, 55, 55, 53, 51, 35, 39, 46, 50, 52, 37, 56, 49, 45, 45,
    35, 51, 57, 57, 56, 55, 56, 58, 52, 52, 57, 59, 58, 54, 51, 49, 54, 50, 26, 44,
    65, 70, 72, 73, 74, 74, 73, 72, 71, 70, 61, 66, 70, 63, 70, 68, 61, 66, 62, 55,
    57, 62, 67, 69, 69, 70, 70, 71, 70, 68, 57, 62, 70, 62, 61, 65, 63, 53, 59, 47,
    56, 56, 50, 49, 61, 65, 64, 64, 64, 62, 58, 55, 61, 54, 59, 56, 55, 34, 46, 46,
    48, 55, 59, 61, 57, 57, 60, 63, 67, 64, 48, 63, 67, 55, 56, 60, 62, 59, 43, 47,
    65, 67, 67, 66, 60, 60, 62, 64, 62, 61, 54, 49, 53, 60, 53, 49, 55, 55, 35, 49,
    59, 46, 59, 62, 32, 62, 66, 63, 63, 63, 62, 60, 56, 45, 49, 41, 52, 46, 40, 24,
    68, 72, 74, 74, 68, 52, 63, 68, 54, 54, 49, 35, 52, 47, 43, 49, 43, 25, 23, 20,
    53, 54, 46, 55, 63, 65, 65, 65, 64, 64, 60, 60, 57, 50, 50, 56, 35, 46, 30, 26,
    43, 53, 60, 62, 60, 58, 55, 54, 53, 50, 56, 48, 54, 51, 52, 46, 47, 48, 35, 37,
    44, 47, 52, 56, 59, 60, 58, 55, 42, 48, 54, 29, 53, 54, 49, 48, 41, 41, 42, 33,
    46, 49, 48, 42, 40, 45, 39, 40, 34, 46, 48, 42, 30, 43, 46, 42, 40, 34, 24, 23,
    43, 40, 40, 46, 48, 45, 44, 46, 44, 40, 42, 39, 42, 42, 39, 36, 34, 24, 21, 13,
    46, 50, 50, 49, 50, 51, 48, 50, 49, 52, 45, 49, 48, 49, 48, 45, 40, 33, 27, 26,
    36, 38, 38, 38, 41, 41, 31, 29, 23, 21, 8, 30, 25, 20, 30, 29, 17, 20, 9, 13,
    48, 52, 53, 52, 43, 39, 37, 30, 29, 37, 28, 23, 29, 28, 32, 26, 21, 26, 21, 20,
    44, 45, 47, 48, 40, 37, 38, 34, 42, 37, 24, 32, 29, 38, 33, 30, 22, 22, 7, 11,
    48, 49, 52, 56, 58, 55, 53, 49, 51, 45, 52, 51, 48, 45, 39, 45, 47, 38, 35, 19,
    49, 53, 55, 55, 50, 50, 42, 38, 42, 46, 47, 37, 35, 40, 32, 31, 7, 21, 16, 14,
    40, 44, 46, 48, 47, 49, 46, 47, 45, 44, 48, 39, 43, 43, 39, 38, 27, 25, 24, 17,
    31, 38, 42, 43, 38, 45, 48, 40, 37, 28, 43, 22, 33, 39, 32, 3, 20, 27, 7, 9,
    25, 33, 37, 37, 28, 39, 39, 36, 22, 28, 36, 16, 32, 31, 30, 16, 10, 18, 11, 10,
    69, 73, 78, 82, 86, 84, 79, 61, 73, 61, 64, 53, 67, 67, 66, 67, 65, 64, 61, 57,
    78, 82, 82, 84, 90, 92, 89, 86, 89, 88, 86, 86, 85, 84, 81, 79, 73, 66, 35, 56,
    79, 85, 89, 91, 94, 95, 95, 93, 92, 87, 83, 81, 76, 70, 67, 61, 52, 29, 58, 63,
    75, 82, 86, 87, 88, 89, 90, 91, 91, 91, 92, 92, 91, 90, 89, 88, 84, 81, 73, 67,
    76, 78, 77, 77, 83, 85, 87, 89, 89, 89, 91, 90, 89, 88, 86, 83, 74, 71, 76, 73,
    75, 80, 83, 84, 76, 78, 84, 86, 82, 80, 80, 80, 80, 79, 78, 76, 73, 68, 70, 72,
    72, 78, 82, 84, 89, 92, 93, 93, 93, 92, 91, 91, 89, 86, 74, 78, 87, 86, 76, 76,
    66, 70, 74, 78, 85, 87, 85, 85, 83, 84, 82, 80, 80, 76, 71, 66, 55, 53, 60, 62,
    71, 78, 81, 83, 83, 82, 82, 81, 77, 78, 76, 76, 74, 70, 62, 63, 69, 70, 63, 66,
    74, 79, 82, 81, 71, 75, 79, 78, 80, 81, 83, 83, 82, 81, 79, 75, 71, 70, 61, 58,
    73, 78, 80, 81, 82, 84, 84, 83, 80, 78, 77, 80, 77, 78, 75, 75, 69, 67, 57, 53,
    71, 78, 82, 83, 81, 79, 71, 58, 59, 66, 66, 67, 59, 61, 57, 49, 50, 51, 58, 59,
    73, 77, 77, 78, 87, 90, 86, 86, 91, 92, 84, 91, 89, 87, 82, 82, 74, 63, 67, 65,
    73, 79, 84, 87, 90, 90, 90, 89, 90, 89, 88, 87, 82, 72, 78, 75, 83, 77, 69, 66,
    65, 68, 74, 78, 81, 81, 80, 80, 80, 79, 80, 79, 77, 74, 68, 69, 70, 70, 66, 68,
    70, 76, 79, 80, 81, 81, 81, 82, 82, 82, 81, 80, 75, 65, 75, 77, 70, 75, 69, 63,
    73, 76, 77, 77, 71, 65, 65, 64, 65, 65, 63, 61, 54, 51, 58, 56, 57, 51, 41, 46,
    60, 61, 58, 52, 54, 61, 58, 61, 57, 49, 56, 56, 61, 60, 58, 38, 64, 53, 51, 51,
    59, 55, 61, 63, 65, 67, 67, 68, 64, 68, 69, 68, 71, 67, 42, 52, 64, 63, 47, 56,
    73, 78, 80, 81, 81, 82, 80, 80, 78, 77, 68, 72, 76, 71, 77, 74, 68, 72, 68, 61,
    62, 70, 75, 78, 79, 78, 78, 79, 80, 78, 72, 68, 79, 74, 71, 75, 71, 59, 67, 56,
    67, 68, 64, 59, 72, 74, 74, 73, 71, 71, 67, 67, 71, 64, 66, 64, 61, 53, 55, 52,
    43, 65, 71, 74, 71, 69, 75, 76, 78, 76, 63, 70, 75, 49, 67, 68, 71, 68, 41, 55,
    77, 79, 80, 78, 72, 71, 76, 77, 75, 73, 64, 65, 65, 72, 60, 59, 67, 67, 48, 60,
    75, 68, 66, 73, 65, 72, 76, 73, 73, 71, 73, 70, 66, 50, 58, 51, 61, 55, 48, 32,
    80, 85, 87, 88, 83, 68, 77, 81, 58, 66, 58, 50, 65, 59, 53, 58, 52, 44, 25, 26,
    66, 69, 66, 55, 74, 77, 77, 77, 75, 74, 71, 72, 63, 63, 57, 62, 51, 57, 41, 43,
    50, 60, 71, 74, 73, 70, 69, 68, 63, 57, 70, 63, 67, 59, 66, 58, 60, 59, 40, 48,
    57, 57, 64, 70, 73, 73, 71, 65, 58, 62, 67, 60, 64, 67, 61, 59, 46, 54, 53, 39,
    61, 65, 66, 63, 47, 61, 60, 62, 57, 52, 66, 56, 58, 62, 62, 51, 58, 41, 21, 31,
    53, 48, 59, 64, 66, 62, 57, 62, 58, 54, 60, 54, 56, 56, 57, 54, 47, 40, 23, 24,
    62, 65, 65, 64, 66, 66, 62, 62, 58, 64, 53, 65, 61, 64, 62, 59, 50, 39, 41, 41,
    50, 52, 49, 41, 53, 54, 52, 47, 22, 34, 43, 47, 38, 41, 41, 42, 34, 39, 30, 18,
    63, 67, 69, 68, 61, 51, 53, 50, 54, 51, 46, 46, 47, 50, 45, 41, 35, 38, 32, 18,
    58, 62, 64, 65, 58, 53, 54, 50, 57, 54, 44, 43, 46, 53, 51, 36, 34, 24, 25, 28,
    51, 59, 70, 75, 76, 72, 69, 59, 70, 59, 70, 66, 63, 64, 61, 58, 60, 48, 48, 33,
    58, 65, 66, 61, 68, 70, 62, 70, 55, 67, 65, 63, 62, 57, 47, 45, 39, 35, 23, 20,
    58, 64, 67, 67, 64, 66, 62, 63, 65, 64, 66, 59, 61, 58, 55, 56, 43, 43, 34, 12,
    47, 49, 58, 61, 55, 60, 65, 57, 50, 50, 60, 58, 50, 55, 52, 48, 37, 44, 24, 22,
    43, 50, 54, 53, 41, 54, 57, 56, 33, 51, 56, 50, 53, 51, 47, 33, 28, 33, 26, 22,
    62, 67, 71, 73, 73, 73, 76, 76, 77, 78, 78, 77, 72, 62, 56, 48, 40, 43, 46, 45,
    69, 70, 71, 71, 71, 70, 71, 68, 69, 70, 69, 67, 64, 60, 48, 50, 57, 56, 42, 37,
    66, 70, 72, 73, 73, 72, 74, 74, 73, 72, 70, 69, 67, 66, 61, 56, 58, 61, 60, 50,
    66, 70, 71, 71, 67, 56, 63, 67, 58, 54, 61, 58, 58, 58, 58, 57, 53, 50, 50, 46,
    68, 71, 71, 68, 68, 66, 66, 65, 68, 68, 68, 67, 66, 65, 62, 59, 55, 48, 46, 48,
    56, 53, 55, 65, 71, 73, 73, 70, 71, 69, 68, 66, 63, 60, 48, 52, 59, 59, 50, 43,
    53, 56, 59, 62, 63, 64, 64, 64, 63, 63, 62, 62, 61, 60, 58, 56, 51, 43, 36, 33,
    38, 37, 38, 41, 45, 42, 42, 43, 44, 44, 43, 38, 27, 26, 38, 39, 35, 30, 26, 23,
    50, 53, 53, 53, 53, 52, 53, 51, 49, 49, 48, 45, 41, 34, 23, 36, 40, 38, 31, 25,
    55, 56, 57, 57, 56, 55, 54, 54, 53, 52, 51, 51, 49, 47, 42, 33, 34, 30, 34, 33,
    48, 50, 53, 55, 56, 52, 54, 53, 51, 50, 47, 41, 40, 47, 49, 45, 42, 45, 37, 37,
    44, 46, 44, 39, 34, 42, 33, 40, 34, 32, 20, 25, 30, 33, 35, 33, 30, 30, 17, 18,
    36, 38, 37, 36, 34, 31, 31, 33, 29, 27, 26, 31, 38, 41, 40, 37, 35, 31, 13, 31,
    33, 37, 38, 39, 41, 40, 40, 40, 40, 38, 35, 30, 20, 33, 33, 21, 28, 15, 4, 21,
    26, 30, 32, 33, 32, 33, 31, 31, 30, 31, 29, 24, 22, 25, 24, 19, 12, 21, 18, 17,
    20, 23, 23, 16, 26, 32, 30, 26, 27, 25, 21, 19, 19, 17, 23, 25, 9, 24, 10, 8,
    19, 17, 20, 20, 21, 22, 20, 18, 18, 21, 19, 22, 18, 9, 19, 17, 16, 19, 15, 0,
    26, 27, 27, 28, 27, 28, 16, 26, 21, 19, 17, 14, 22, 23, 22, 23, 0, 13, 17, 12,
    27, 25, 24, 23, 26, 19, 18, 21, 18, 26, 27, 29, 23, 16, 18, 15, 24, 19, 18, 6,
    33, 33, 34, 34, 31, 26, 30, 28, 26, 23, 25, 26, 28, 28, 25, 22, 17, 17, 9, 11,
    28, 32, 34, 34, 33, 25, 24, 29, 29, 28, 25, 20, 29, 34, 33, 27, 29, 25, 22, 17,
    25, 25, 23, 18, 16, 27, 30, 24, 28, 22, 0, 20, 24, 9, 27, 14, 22, 20, 13, 12,
    16, 18, 20, 22, 21, 16, 14, 14, 11, 17, 18, 16, 11, 20, 12, 14, 11, 16, 8, 7,
    29, 30, 29, 27, 15, 15, 14, 11, 17, 18, 15, 3, 15, 12, 14, 9, 0, 2, 0, 12,
    27, 24, 17, 12, 11, 1, 18, 11, 16, 10, 13, 8, 13, 6, 7, 8, 2, 9, 9, 9,
    20, 19, 17, 12, 18, 22, 13, 10, 18, 10, 10, 9, 12, 9, 8, 8, 10, 6, 7, 9,
    24, 23, 17, 6, 18, 24, 12, 17, 7, 15, 17, 0, 8, 4, 13, 15, 11, 9, 1, 1,
    23, 23, 20, 12, 9, 19, 7, 4, 15, 16, 16, 16, 13, 18, 12, 8, 8, 10, 8, 12,
    19, 20, 16, 8, 17, 15, 11, 11, 12, 12, 19, 11, 17, 11, 9, 6, 10, 1, 12, 0,
    20, 19, 13, 3, 9, 14, 19, 19, 18, 21, 21, 17, 22, 13, 7, 13, 11, 9, 10, 14,
    18, 18, 18, 19, 16, 17, 19, 19, 16, 22, 18, 17, 16, 7, 17, 5, 9, 8, 14, 11,
    25, 26, 24, 21, 16, 14, 18, 10, 7, 0, 11, 17, 12, 0, 12, 4, 0, 3, 7, 0,
    17, 22, 21, 15, 3, 19, 7, 12, 8, 7, 2, 0, 0, 14, 7, 11, 10, 8, 4, 11,
    19, 15, 13, 7, 9, 9, 10, 7, 6, 14, 6, 3, 0, 5, 7, 0, 7, 7, 8, 6,
    22, 21, 19, 17, 11, 4, 11, 12, 0, 9, 8, 8, 7, 0, 7, 8, 0, 2, 9, 5,
    20, 25, 27, 26, 18, 13, 10, 14, 18, 19, 18, 12, 15, 18, 15, 16, 14, 18, 18, 14,
    0, 8, 11, 7, 11, 0, 12, 9, 6, 9, 11, 7, 0, 7, 0, 5, 0, 0, 0, 2,
    17, 20, 22, 21, 4, 11, 9, 0, 10, 0, 10, 10, 0, 9, 11, 3, 4, 2, 2, 7,
    6, 0, 7, 13, 11, 1, 5, 6, 4, 11, 15, 2, 1, 2, 1, 5, 5, 4, 2, 4,
    12, 13, 10, 8, 11, 8, 5, 14, 4, 5, 9, 15, 9, 9, 7, 9, 11, 5, 11, 12,
    66, 72, 76, 79, 84, 84, 85, 86, 88, 89, 88, 87, 81, 76, 69, 59, 48, 45, 43, 46,
    69, 78, 81, 83, 83, 82, 84, 83, 83, 85, 83, 82, 80, 77, 66, 65, 74, 73, 54, 55,
    73, 76, 80, 83, 85, 85, 85, 86, 84, 83, 81, 79, 78, 77, 73, 67, 66, 71, 72, 66,
    65, 75, 80, 82, 82, 77, 71, 78, 74, 73, 77, 76, 74, 73, 71, 68, 63, 60, 60, 59,
    70, 78, 83, 84, 81, 80, 77, 78, 80, 81, 81, 80, 79, 77, 75, 72, 68, 64, 59, 58,
    68, 73, 72, 60, 83, 87, 88, 86, 86, 84, 82, 81, 79, 76, 68, 55, 71, 73, 66, 60,
    61, 69, 73, 76, 81, 82, 82, 82, 82, 80, 80, 80, 79, 77, 75, 74, 69, 63, 49, 53,
    61, 62, 59, 59, 63, 64, 63, 66, 63, 62, 59, 57, 52, 42, 56, 57, 52, 47, 43, 45,
    62, 71, 75, 77, 76, 76, 75, 73, 70, 71, 70, 68, 65, 60, 41, 51, 58, 58, 49, 45,
    69, 77, 80, 81, 82, 80, 79, 79, 77, 76, 75, 74, 71, 69, 64, 61, 54, 44, 48, 50,
    68, 73, 75, 78, 82, 81, 80, 79, 78, 78, 77, 73, 64, 61, 70, 68, 53, 67, 55, 52,
    66, 72, 73, 71, 65, 66, 68, 70, 66, 61, 58, 50, 38, 53, 56, 54, 44, 48, 28, 33,
    62, 68, 74, 77, 78, 77, 77, 78, 76, 76, 74, 72, 65, 58, 50, 66, 69, 65, 62, 45,
    60, 68, 74, 76, 78, 79, 80, 79, 79, 79, 77, 76, 72, 69, 68, 67, 62, 64, 59, 48,
    52, 49, 62, 67, 69, 70, 69, 70, 71, 70, 69, 68, 64, 60, 53, 47, 59, 60, 52, 44,
    55, 60, 63, 65, 65, 64, 63, 64, 64, 63, 61, 58, 38, 53, 56, 58, 46, 54, 47, 36,
    42, 44, 48, 52, 54, 57, 59, 58, 58, 56, 54, 52, 43, 39, 45, 49, 47, 38, 37, 26,
    47, 49, 50, 48, 48, 46, 22, 48, 41, 49, 48, 49, 43, 36, 43, 48, 28, 27, 27, 0,
    53, 55, 53, 49, 47, 52, 50, 52, 54, 53, 52, 53, 47, 30, 39, 36, 36, 38, 34, 24,
    48, 56, 59, 62, 60, 58, 57, 57, 56, 54, 49, 43, 47, 53, 49, 49, 46, 37, 33, 30,
    54, 60, 63, 64, 66, 66, 67, 67, 66, 65, 61, 54, 38, 56, 63, 61, 51, 57, 52, 46,
    36, 40, 53, 58, 61, 62, 61, 59, 60, 62, 63, 61, 53, 55, 50, 43, 49, 50, 44, 36,
    39, 44, 52, 55, 55, 57, 55, 56, 49, 48, 43, 44, 43, 47, 44, 50, 35, 23, 36, 28,
    43, 45, 46, 49, 45, 44, 29, 34, 39, 29, 32, 34, 33, 36, 36, 31, 24, 11, 3, 11,
    45, 49, 50, 48, 48, 46, 43, 43, 41, 39, 38, 31, 34, 36, 36, 32, 33, 23, 13, 13,
    40, 43, 43, 39, 35, 25, 36, 40, 35, 26, 25, 24, 24, 31, 33, 25, 29, 18, 13, 15,
    38, 40, 36, 24, 41, 45, 46, 39, 46, 35, 34, 35, 32, 33, 42, 35, 26, 17, 14, 12,
    38, 41, 41, 39, 32, 31, 26, 34, 39, 32, 31, 29, 36, 43, 35, 37, 24, 12, 15, 9,
    21, 21, 29, 31, 27, 27, 25, 26, 27, 9, 20, 22, 32, 31, 29, 27, 13, 16, 10, 3,
    38, 40, 40, 39, 39, 35, 36, 35, 36, 37, 37, 30, 42, 40, 31, 32, 16, 21, 21, 10,
    41, 43, 41, 41, 40, 34, 39, 39, 40, 38, 25, 42, 40, 40, 34, 36, 32, 21, 11, 7,
    34, 33, 33, 38, 40, 41, 37, 40, 34, 33, 30, 30, 39, 30, 26, 19, 17, 18, 11, 5,
    34, 35, 31, 27, 26, 31, 20, 22, 10, 20, 18, 13, 12, 8, 9, 9, 6, 2, 7, 6,
    42, 47, 47, 44, 26, 36, 37, 32, 27, 20, 34, 20, 20, 22, 24, 20, 3, 10, 1, 4,
    43, 48, 49, 46, 28, 36, 36, 33, 39, 39, 32, 34, 29, 25, 21, 20, 12, 12, 11, 8,
    35, 39, 40, 38, 35, 36, 33, 30, 19, 31, 31, 31, 21, 26, 18, 20, 3, 6, 6, 9,
    29, 24, 14, 14, 19, 26, 26, 19, 16, 23, 22, 18, 22, 14, 17, 9, 5, 9, 11, 2,
    20, 22, 19, 23, 29, 31, 32, 29, 23, 30, 32, 24, 25, 19, 19, 23, 17, 14, 12, 6,
    25, 24, 26, 28, 31, 31, 31, 31, 28, 35, 38, 36, 24, 35, 31, 22, 7, 12, 10, 0,
    25, 28, 28, 27, 21, 20, 20, 17, 7, 22, 19, 20, 4, 17, 13, 8, 13, 4, 7, 7,
    68, 74, 80, 85, 90, 91, 92, 94, 96, 95, 95, 94, 87, 82, 76, 68, 57, 40, 48, 41,
    80, 87, 89, 90, 90, 91, 94, 92, 92, 93, 91, 90, 88, 85, 74, 71, 82, 81, 62, 63,
    82, 85, 88, 91, 93, 93, 93, 94, 92, 90, 88, 87, 86, 85, 80, 73, 75, 80, 79, 70,
    75, 84, 89, 91, 89, 85, 80, 85, 77, 78, 79, 76, 75, 75, 74, 72, 70, 68, 67, 66,
    78, 86, 90, 92, 88, 87, 84, 85, 89, 88, 88, 88, 86, 85, 82, 79, 73, 69, 66, 66,
    77, 81, 80, 65, 91, 96, 97, 95, 95, 94, 92, 90, 88, 85, 75, 68, 81, 81, 71, 67,
    70, 78, 82, 85, 90, 91, 91, 90, 89, 89, 88, 88, 86, 84, 82, 81, 77, 69, 59, 56,
    70, 72, 69, 70, 72, 75, 75, 78, 75, 75, 72, 69, 61, 49, 67, 68, 62, 57, 47, 51,
    75, 83, 86, 87, 87, 87, 86, 85, 83, 82, 80, 78, 74, 69, 46, 62, 68, 67, 57, 51,
    80, 88, 92, 93, 94, 92, 91, 91, 90, 89, 88, 87, 84, 81, 77, 73, 57, 64, 64, 63,
    79, 84, 87, 91, 95, 93, 92, 90, 90, 90, 89, 86, 77, 70, 81, 80, 71, 79, 68, 66,
    77, 82, 83, 81, 77, 77, 78, 78, 76, 74, 73, 69, 58, 58, 65, 68, 60, 61, 53, 36,
    74, 79, 85, 88, 89, 88, 89, 89, 89, 89, 86, 85, 79, 72, 64, 79, 81, 72, 73, 64,
    74, 82, 87, 90, 92, 93, 93, 92, 92, 92, 90, 89, 85, 82, 81, 80, 77, 77, 70, 61,
    71, 70, 77, 81, 82, 83, 83, 84, 84, 82, 81, 79, 76, 73, 67, 67, 74, 73, 52, 63,
    72, 77, 80, 81, 81, 80, 78, 80, 79, 78, 76, 74, 57, 67, 71, 71, 47, 67, 61, 53,
    58, 60, 64, 65, 65, 70, 72, 72, 71, 70, 67, 66, 58, 54, 60, 64, 57, 47, 45, 42,
    66, 66, 65, 60, 59, 63, 56, 63, 57, 66, 66, 69, 65, 53, 64, 68, 50, 50, 48, 33,
    69, 73, 72, 70, 72, 73, 70, 73, 74, 74, 76, 75, 69, 60, 61, 58, 60, 61, 50, 48,
    71, 75, 76, 77, 75, 72, 70, 70, 70, 70, 66, 62, 62, 67, 61, 61, 55, 53, 50, 43,
    69, 78, 82, 83, 84, 84, 85, 84, 84, 83, 79, 73, 61, 73, 80, 77, 72, 70, 65, 59,
    68, 70, 75, 79, 82, 82, 81, 75, 76, 79, 81, 81, 74, 74, 73, 59, 71, 70, 58, 43,
    51, 68, 76, 80, 81, 81, 79, 79, 74, 70, 61, 67, 63, 68, 65, 70, 56, 49, 54, 44,
    72, 78, 79, 79, 79, 77, 70, 66, 64, 61, 61, 61, 55, 60, 62, 57, 53, 41, 38, 33,
    68, 69, 67, 67, 69, 70, 70, 70, 66, 61, 61, 59, 58, 57, 56, 51, 48, 42, 32, 22,
    63, 66, 65, 62, 50, 48, 63, 51, 54, 54, 44, 43, 45, 42, 49, 37, 45, 44, 35, 28,
    62, 65, 66, 68, 71, 71, 68, 55, 68, 59, 63, 60, 42, 59, 57, 55, 45, 49, 35, 16,
    63, 66, 65, 58, 53, 58, 65, 68, 67, 66, 60, 53, 61, 66, 54, 60, 52, 45, 15, 25,
    55, 58, 62, 63, 60, 60, 62, 65, 68, 68, 64, 47, 54, 54, 62, 54, 38, 41, 33, 26,
    60, 61, 60, 57, 57, 60, 68, 71, 72, 71, 64, 62, 67, 70, 62, 59, 58, 35, 49, 37,
    63, 66, 67, 67, 66, 66, 67, 67, 65, 63, 60, 63, 65, 62, 58, 57, 54, 48, 32, 34,
    53, 57, 62, 65, 67, 67, 63, 62, 54, 47, 52, 55, 59, 59, 53, 43, 43, 36, 37, 31,
    41, 41, 49, 47, 47, 46, 48, 46, 45, 37, 30, 35, 38, 37, 37, 34, 26, 23, 16, 7,
    54, 59, 59, 56, 56, 60, 50, 53, 54, 55, 50, 50, 51, 47, 50, 29, 27, 25, 15, 14,
    56, 59, 61, 59, 57, 43, 55, 58, 61, 58, 55, 50, 55, 52, 42, 35, 32, 26, 11, 11,
    53, 59, 60, 59, 53, 60, 64, 58, 60, 39, 46, 57, 54, 51, 48, 46, 38, 37, 15, 17,
    45, 40, 38, 34, 45, 49, 48, 43, 43, 46, 46, 29, 38, 31, 33, 28, 16, 16, 16, 6,
    49, 51, 52, 53, 54, 56, 52, 40, 41, 47, 49, 41, 42, 42, 19, 37, 37, 28, 18, 2,
    45, 48, 49, 49, 46, 51, 50, 41, 39, 47, 53, 49, 40, 47, 40, 31, 29, 26, 16, 9,
    36, 40, 41, 39, 40, 37, 36, 39, 43, 41, 39, 36, 41, 22, 32, 30, 24, 5, 4, 0,
    63, 70, 73, 74, 78, 80, 78, 76, 75, 78, 75, 73, 73, 73, 71, 70, 67, 65, 63, 57,
    72, 74, 71, 60, 45, 51, 66, 64, 69, 66, 65, 65, 66, 65, 64, 62, 56, 52, 50, 47,
    66, 68, 66, 61, 59, 64, 70, 66, 71, 70, 70, 70, 69, 68, 65, 63, 60, 53, 42, 53,
    62, 66, 67, 66, 68, 68, 68, 69, 69, 69, 69, 68, 67, 66, 63, 59, 38, 55, 56, 51,
    51, 51, 53, 60, 65, 66, 64, 64, 64, 63, 63, 62, 60, 59, 53, 44, 45, 47, 42, 50,
    51, 49, 44, 39, 51, 56, 56, 53, 49, 46, 45, 47, 40, 30, 33, 37, 42, 39, 44, 43,
    50, 50, 53, 56, 59, 57, 60, 58, 56, 56, 56, 54, 50, 44, 36, 46, 46, 38, 50, 43,
    49, 51, 48, 45, 48, 45, 46, 48, 47, 46, 46, 44, 41, 39, 32, 33, 28, 30, 32, 33,
    40, 42, 42, 44, 45, 46, 45, 45, 43, 42, 42, 39, 36, 31, 30, 34, 26, 31, 34, 28,
    31, 37, 41, 43, 46, 46, 47, 46, 44, 43, 40, 33, 27, 36, 40, 38, 18, 38, 32, 19,
    31, 31, 32, 32, 33, 33, 28, 30, 30, 30, 31, 27, 27, 31, 33, 21, 23, 24, 9, 18,
    30, 24, 18, 15, 10, 25, 28, 30, 26, 20, 26, 26, 17, 13, 16, 13, 16, 21, 21, 8,
    32, 35, 35, 35, 35, 34, 34, 32, 33, 29, 27, 18, 19, 12, 7, 27, 23, 23, 23, 20,
    25, 21, 20, 22, 21, 17, 24, 24, 23, 23, 23, 14, 22, 24, 15, 14, 15, 19, 0, 5,
    25, 21, 14, 5, 19, 20, 15, 22, 14, 20, 12, 23, 25, 24, 22, 9, 17, 12, 14, 14,
    10, 15, 15, 20, 21, 19, 20, 13, 19, 19, 10, 21, 16, 3, 17, 13, 10, 0, 16, 17,
    20, 17, 16, 10, 12, 24, 16, 15, 9, 9, 8, 10, 3, 13, 3, 4, 5, 5, 12, 7,
    21, 16, 12, 21, 19, 17, 20, 16, 18, 20, 14, 9, 13, 4, 13, 0, 16, 0, 9, 9,
    16, 22, 26, 26, 21, 23, 25, 24, 24, 25, 22, 23, 15, 14, 15, 14, 18, 13, 8, 7,
    8, 14, 13, 13, 10, 16, 15, 13, 16, 13, 8, 6, 11, 16, 7, 5, 9, 7, 6, 8,
    20, 18, 18, 17, 21, 15, 19, 13, 18, 15, 15, 16, 19, 23, 10, 4, 11, 10, 6, 2,
    25, 25, 26, 27, 26, 26, 27, 27, 24, 25, 21, 18, 12, 20, 14, 13, 10, 17, 8, 6,
    7, 15, 14, 12, 10, 7, 14, 12, 15, 6, 8, 14, 0, 7, 0, 0, 5, 6, 1, 6,
    15, 0, 4, 8, 11, 3, 8, 12, 17, 14, 7, 14, 2, 8, 9, 0, 10, 0, 9, 11,
    19, 14, 1, 3, 2, 0, 10, 3, 15, 16, 2, 12, 12, 8, 10, 9, 14, 7, 16, 2,
    18, 7, 11, 15, 15, 11, 2, 10, 16, 11, 9, 0, 8, 0, 8, 5, 11, 7, 10, 14,
    4, 9, 6, 4, 10, 9, 4, 9, 5, 11, 16, 10, 4, 7, 5, 0, 12, 7, 11, 8,
    18, 14, 10, 11, 10, 12, 14, 8, 0, 0, 14, 4, 0, 10, 8, 9, 4, 0, 8, 10,
    18, 16, 16, 16, 18, 18, 13, 15, 17, 8, 20, 18, 20, 15, 20, 14, 15, 16, 17, 17,
    8, 11, 0, 12, 3, 0, 7, 9, 10, 0, 1, 4, 15, 12, 9, 11, 0, 8, 0, 6,
    12, 1, 8, 12, 11, 13, 13, 0, 6, 2, 12, 5, 6, 13, 0, 12, 0, 12, 11, 1,
    12, 12, 3, 12, 6, 16, 12, 12, 4, 8, 0, 7, 11, 11, 0, 0, 0, 6, 8, 13,
    10, 13, 14, 7, 0, 3, 10, 0, 10, 0, 0, 12, 13, 14, 0, 6, 5, 12, 11, 11,
    10, 7, 9, 9, 12, 12, 6, 10, 14, 9, 11, 12, 5, 3, 0, 9, 9, 6, 0, 0,
    8, 9, 10, 10, 1, 8, 0, 9, 2, 0, 1, 9, 10, 13, 5, 13, 5, 14, 10, 11,
    15, 15, 13, 14, 13, 17, 12, 3, 6, 10, 6, 9, 4, 8, 5, 0, 0, 6, 3, 10,
    12, 8, 7, 7, 0, 0, 6, 7, 0, 12, 11, 5, 6, 11, 6, 1, 11, 6, 6, 4,
    0, 15, 15, 15, 16, 16, 16, 14, 10, 15, 12, 6, 5, 4, 10, 12, 7, 5, 0, 10,
    2, 2, 13, 17, 1, 9, 11, 11, 10, 0, 1, 9, 1, 7, 7, 9, 10, 12, 8, 7,
    16, 11, 9, 8, 0, 6, 3, 0, 0, 12, 3, 4, 5, 5, 4, 4, 4, 9, 9, 10,
    55, 68, 77, 82, 84, 89, 88, 87, 84, 87, 84, 84, 83, 82, 81, 79, 76, 74, 69, 63,
    68, 79, 85, 85, 72, 65, 75, 79, 79, 78, 76, 77, 77, 76, 75, 72, 67, 62, 59, 59,
    64, 75, 80, 80, 66, 71, 81, 76, 82, 80, 80, 80, 79, 78, 76, 74, 71, 66, 54, 64,
    64, 72, 77, 78, 79, 79, 81, 81, 81, 81, 81, 80, 79, 77, 75, 71, 50, 65, 67, 60,
    54, 61, 63, 65, 75, 78, 77, 77, 77, 77, 77, 76, 75, 74, 70, 64, 50, 61, 55, 62,
    61, 66, 66, 64, 60, 69, 72, 68, 67, 69, 70, 68, 65, 62, 53, 33, 53, 52, 55, 56,
    58, 67, 68, 70, 77, 78, 79, 79, 76, 76, 76, 75, 73, 69, 58, 61, 64, 58, 65, 59,
    63, 68, 70, 70, 66, 69, 66, 68, 68, 67, 66, 64, 61, 58, 50, 49, 42, 46, 50, 52,
    48, 60, 65, 67, 69, 68, 69, 69, 67, 65, 65, 64, 61, 57, 49, 55, 52, 52, 57, 49,
    51, 44, 60, 66, 71, 74, 74, 76, 74, 73, 70, 67, 60, 52, 61, 63, 55, 60, 58, 46,
    44, 51, 58, 61, 62, 64, 62, 62, 61, 62, 63, 62, 56, 47, 59, 56, 56, 50, 41, 37,
    51, 52, 41, 52, 57, 57, 59, 60, 55, 56, 53, 53, 48, 43, 38, 31, 39, 45, 41, 24,
    54, 62, 64, 65, 64, 64, 64, 64, 64, 62, 60, 57, 48, 39, 49, 47, 52, 47, 42, 40,
    54, 59, 62, 62, 63, 61, 60, 57, 55, 53, 50, 48, 40, 45, 48, 40, 52, 41, 42, 20,
    50, 56, 63, 64, 64, 63, 59, 60, 63, 63, 58, 56, 48, 47, 51, 49, 49, 41, 39, 34,
    53, 58, 62, 62, 61, 60, 60, 61, 59, 59, 58, 55, 46, 36, 42, 50, 51, 37, 39, 26,
    40, 50, 55, 55, 49, 58, 60, 54, 50, 43, 38, 45, 34, 37, 38, 36, 37, 20, 26, 9,
    42, 47, 38, 47, 49, 46, 51, 49, 48, 42, 41, 42, 39, 33, 42, 35, 39, 30, 25, 23,
    41, 49, 51, 51, 53, 53, 51, 52, 50, 47, 44, 45, 49, 50, 41, 37, 45, 39, 37, 27,
    41, 47, 46, 42, 44, 41, 36, 32, 26, 27, 29, 30, 26, 29, 16, 36, 25, 17, 23, 19,
    36, 47, 47, 47, 48, 48, 46, 45, 45, 43, 37, 41, 46, 45, 35, 45, 36, 35, 31, 19,
    39, 50, 55, 57, 58, 58, 57, 56, 54, 52, 48, 51, 53, 48, 50, 46, 46, 39, 38, 29,
    37, 43, 44, 43, 40, 39, 35, 34, 30, 36, 36, 35, 32, 35, 35, 40, 15, 25, 17, 16,
    29, 36, 37, 37, 37, 36, 31, 29, 29, 26, 22, 27, 29, 25, 27, 25, 19, 21, 12, 5,
    26, 30, 29, 21, 23, 18, 21, 30, 23, 23, 20, 19, 23, 19, 18, 21, 8, 4, 10, 14,
    24, 25, 29, 32, 29, 21, 31, 30, 31, 30, 13, 16, 25, 19, 28, 22, 3, 14, 7, 5,
    8, 24, 26, 22, 32, 33, 34, 30, 14, 19, 15, 24, 25, 22, 29, 29, 17, 17, 9, 9,
    12, 10, 27, 31, 27, 27, 28, 27, 27, 26, 25, 21, 18, 0, 12, 13, 0, 3, 2, 9,
    20, 23, 24, 27, 33, 29, 29, 27, 27, 30, 25, 29, 21, 20, 24, 20, 19, 18, 16, 13,
    21, 22, 18, 18, 24, 18, 20, 26, 28, 29, 30, 27, 28, 34, 26, 25, 21, 0, 9, 9,
    18, 16, 21, 24, 28, 31, 29, 29, 26, 29, 32, 30, 23, 26, 29, 24, 17, 16, 8, 4,
    20, 30, 32, 26, 33, 33, 22, 9, 18, 23, 14, 26, 26, 23, 24, 22, 12, 13, 3, 6,
    16, 25, 29, 29, 25, 26, 25, 21, 8, 7, 17, 14, 4, 0, 9, 0, 0, 1, 10, 2,
    17, 14, 6, 13, 13, 14, 10, 13, 8, 14, 7, 0, 14, 19, 0, 6, 1, 8, 5, 8,
    10, 5, 17, 21, 15, 21, 18, 21, 14, 17, 13, 20, 19, 15, 5, 15, 1, 0, 11, 13,
    16, 24, 23, 21, 21, 20, 24, 21, 20, 21, 15, 13, 19, 16, 15, 17, 12, 10, 8, 0,
    12, 22, 28, 30, 30, 29, 26, 22, 24, 24, 25, 22, 15, 22, 17, 16, 16, 11, 10, 4,
    6, 7, 13, 17, 15, 15, 11, 13, 18, 17, 22, 18, 11, 18, 13, 11, 7, 0, 2, 4,
    0, 22, 26, 25, 17, 22, 23, 23, 24, 22, 19, 20, 11, 10, 3, 12, 13, 7, 13, 0,
    16, 0, 19, 21, 21, 21, 18, 13, 10, 11, 8, 4, 9, 10, 10, 8, 13, 0, 8, 0,
    69, 87, 93, 96, 97, 102, 101, 99, 97, 97, 96, 96, 95, 94, 92, 90, 86, 83, 78, 70,
    83, 93, 98, 96, 84, 81, 83, 88, 85, 86, 82, 83, 84, 83, 82, 80, 75, 67, 69, 69,
    78, 89, 92, 91, 68, 85, 91, 84, 93, 94, 94, 94, 92, 91, 88, 86, 82, 76, 66, 75,
    78, 86, 91, 92, 92, 92, 94, 95, 94, 94, 94, 94, 92, 91, 88, 84, 63, 77, 75, 72,
    73, 78, 76, 76, 87, 89, 87, 86, 85, 84, 83, 83, 82, 80, 76, 70, 61, 68, 53, 70,
    74, 79, 78, 74, 74, 81, 85, 82, 67, 71, 78, 75, 72, 68, 59, 53, 64, 60, 65, 65,
    66, 75, 77, 83, 91, 92, 94, 93, 90, 88, 86, 84, 82, 78, 69, 71, 74, 68, 77, 66,
    77, 82, 85, 86, 78, 83, 83, 83, 82, 83, 82, 81, 78, 74, 65, 63, 60, 63, 68, 65,
    70, 73, 82, 85, 84, 83, 85, 86, 81, 80, 81, 79, 74, 71, 62, 65, 57, 67, 68, 58,
    76, 73, 77, 82, 86, 89, 88, 90, 89, 88, 86, 84, 77, 63, 76, 78, 63, 78, 71, 54,
    67, 71, 76, 77, 79, 81, 74, 73, 75, 75, 75, 73, 71, 71, 76, 76, 63, 55, 59, 54,
    72, 74, 69, 57, 68, 70, 78, 79, 75, 77, 74, 72, 67, 65, 58, 53, 59, 70, 54, 52,
    75, 80, 81, 80, 79, 79, 80, 81, 80, 79, 77, 76, 69, 60, 64, 63, 65, 64, 57, 57,
    70, 75, 78, 80, 80, 77, 79, 81, 79, 81, 78, 76, 68, 61, 62, 64, 57, 68, 41, 53,
    68, 78, 84, 86, 86, 85, 83, 81, 84, 81, 78, 77, 71, 47, 71, 70, 75, 67, 61, 52,
    78, 82, 85, 85, 84, 83, 83, 85, 82, 81, 79, 75, 64, 54, 64, 68, 72, 64, 60, 49,
    63, 75, 81, 80, 76, 83, 85, 78, 72, 76, 56, 66, 61, 43, 58, 55, 59, 50, 50, 44,
    73, 76, 69, 76, 73, 73, 77, 74, 75, 71, 68, 66, 68, 68, 69, 64, 61, 48, 42, 45,
    71, 77, 78, 77, 80, 81, 76, 81, 80, 79, 75, 69, 65, 73, 56, 68, 68, 58, 43, 52,
    69, 73, 73, 72, 72, 66, 68, 71, 71, 69, 62, 57, 56, 54, 57, 62, 47, 52, 34, 20,
    66, 72, 70, 70, 65, 70, 66, 67, 65, 67, 64, 59, 55, 58, 43, 61, 54, 52, 45, 33,
    68, 79, 83, 85, 86, 86, 85, 85, 82, 80, 71, 66, 76, 76, 75, 65, 67, 56, 41, 52,
    71, 78, 79, 79, 79, 79, 75, 72, 73, 72, 71, 69, 54, 63, 70, 75, 52, 62, 49, 32,
    69, 75, 77, 77, 76, 76, 74, 74, 70, 70, 60, 54, 63, 56, 67, 66, 38, 57, 47, 40,
    60, 62, 55, 50, 59, 58, 56, 51, 48, 47, 45, 41, 44, 28, 50, 33, 23, 38, 23, 13,
    53, 55, 62, 66, 64, 61, 61, 61, 62, 61, 56, 51, 44, 53, 57, 35, 47, 33, 36, 24,
    61, 65, 64, 62, 67, 68, 68, 67, 67, 66, 60, 48, 57, 47, 64, 59, 45, 46, 38, 29,
    60, 67, 69, 67, 67, 66, 65, 65, 64, 62, 56, 34, 50, 45, 54, 50, 42, 42, 35, 26,
    55, 61, 62, 58, 52, 53, 58, 59, 58, 55, 29, 47, 50, 56, 56, 42, 47, 39, 32, 23,
    63, 66, 65, 68, 72, 72, 70, 67, 68, 69, 69, 66, 55, 72, 67, 58, 56, 51, 35, 29,
    65, 66, 59, 65, 70, 68, 61, 65, 59, 55, 58, 59, 64, 58, 59, 60, 43, 28, 12, 24,
    68, 74, 76, 77, 78, 75, 71, 69, 63, 66, 61, 63, 51, 60, 55, 48, 44, 40, 29, 19,
    63, 69, 70, 68, 65, 65, 65, 60, 50, 57, 47, 52, 30, 46, 37, 33, 26, 30, 7, 8,
    53, 58, 57, 55, 49, 55, 48, 52, 44, 38, 25, 39, 36, 46, 39, 34, 33, 12, 15, 3,
    53, 59, 61, 60, 58, 58, 57, 55, 51, 43, 48, 50, 52, 46, 41, 40, 38, 27, 14, 9,
    58, 63, 63, 63, 64, 63, 63, 63, 58, 53, 45, 49, 48, 51, 40, 45, 32, 21, 17, 15,
    59, 67, 70, 70, 68, 66, 64, 60, 48, 53, 53, 53, 42, 55, 43, 49, 41, 31, 18, 7,
    54, 62, 64, 64, 64, 64, 64, 59, 56, 46, 51, 50, 54, 58, 29, 44, 39, 29, 16, 12,
    61, 67, 70, 70, 70, 69, 67, 66, 62, 58, 47, 50, 46, 55, 45, 37, 37, 23, 3, 10,
    55, 63, 67, 68, 65, 62, 55, 50, 53, 58, 57, 52, 50, 49, 45, 21, 28, 18, 0, 8,
    67, 71, 75, 76, 75, 73, 69, 67, 71, 67, 67, 66, 66, 64, 60, 58, 47, 28, 35, 25,
    73, 75, 76, 78, 79, 79, 80, 81, 81, 81, 80, 80, 78, 77, 75, 72, 68, 61, 54, 59,
    71, 74, 74, 74, 70, 68, 71, 69, 70, 70, 69, 68, 67, 65, 60, 55, 29, 46, 52, 50,
    66, 66, 65, 68, 72, 72, 70, 68, 65, 64, 63, 61, 59, 56, 53, 52, 40, 47, 49, 24,
    50, 52, 49, 47, 49, 44, 47, 36, 32, 49, 50, 49, 47, 46, 43, 35, 38, 41, 31, 35,
    55, 56, 55, 54, 55, 56, 56, 53, 53, 50, 49, 48, 45, 43, 37, 28, 37, 38, 18, 32,
    56, 58, 59, 59, 59, 59, 59, 59, 58, 58, 57, 56, 54, 52, 45, 34, 41, 36, 38, 34,
    37, 38, 38, 40, 40, 42, 39, 40, 39, 41, 40, 38, 34, 34, 29, 26, 21, 25, 22, 21,
    20, 29, 33, 34, 35, 31, 28, 19, 16, 27, 16, 8, 22, 21, 23, 20, 23, 25, 14, 20,
    32, 36, 37, 34, 29, 33, 30, 29, 31, 33, 30, 27, 21, 16, 12, 27, 25, 18, 16, 7,
    33, 37, 39, 38, 37, 38, 38, 38, 36, 35, 34, 31, 26, 12, 27, 31, 22, 16, 13, 0,
    33, 38, 39, 38, 38, 36, 36, 36, 35, 35, 35, 33, 27, 10, 20, 17, 24, 15, 17, 18,
    26, 28, 27, 25, 28, 27, 26, 27, 23, 27, 19, 23, 23, 11, 19, 20, 19, 17, 6, 13,
    25, 21, 25, 18, 19, 22, 18, 21, 16, 18, 19, 20, 2, 14, 12, 11, 7, 15, 2, 0,
    31, 30, 24, 26, 24, 26, 21, 25, 21, 20, 17, 18, 12, 12, 14, 10, 7, 11, 4, 17,
    15, 11, 19, 13, 0, 0, 13, 11, 10, 12, 11, 4, 11, 12, 13, 11, 0, 10, 14, 11,
    12, 11, 5, 10, 1, 9, 0, 18, 5, 14, 16, 13, 12, 0, 10, 11, 4, 7, 0, 12,
    16, 13, 4, 0, 15, 7, 15, 0, 13, 18, 9, 9, 11, 9, 0, 0, 9, 13, 4, 10,
    11, 13, 15, 12, 9, 8, 6, 16, 16, 7, 8, 8, 6, 1, 0, 7, 14, 15, 11, 1,
    13, 19, 11, 10, 2, 3, 0, 11, 9, 0, 14, 1, 6, 7, 14, 1, 10, 0, 11, 16,
    23, 19, 21, 18, 22, 16, 13, 0, 14, 13, 10, 7, 11, 7, 12, 7, 13, 0, 12, 13,
    14, 13, 20, 23, 22, 18, 11, 17, 17, 6, 12, 16, 12, 10, 10, 11, 12, 11, 6, 0,
    15, 12, 21, 19, 16, 15, 17, 18, 16, 17, 14, 16, 15, 12, 15, 20, 19, 13, 19, 15,
    21, 22, 21, 12, 0, 9, 0, 17, 11, 0, 9, 6, 6, 3, 4, 3, 6, 11, 0, 0,
    13, 15, 13, 13, 10, 9, 9, 1, 9, 6, 5, 12, 10, 11, 3, 10, 8, 15, 3, 9,
    17, 3, 17, 19, 7, 15, 4, 12, 8, 11, 12, 6, 0, 9, 5, 0, 2, 3, 13, 6,
    15, 8, 14, 17, 9, 13, 7, 7, 8, 14, 2, 9, 6, 13, 7, 0, 6, 9, 11, 10,
    0, 7, 6, 13, 16, 12, 7, 11, 12, 14, 5, 3, 11, 14, 0, 7, 4, 7, 11, 0,
    14, 8, 13, 3, 12, 18, 9, 0, 13, 9, 7, 1, 10, 10, 0, 8, 9, 0, 0, 14,
    15, 14, 12, 0, 8, 4, 11, 6, 10, 0, 0, 4, 10, 4, 2, 7, 8, 0, 6, 6,
    11, 10, 9, 17, 12, 1, 6, 13, 2, 11, 13, 1, 6, 9, 11, 12, 6, 13, 4, 12,
    12, 4, 7, 5, 2, 11, 6, 0, 6, 10, 14, 15, 14, 0, 11, 7, 0, 9, 14, 9,
    10, 10, 0, 10, 5, 12, 0, 4, 11, 12, 8, 1, 6, 11, 6, 0, 4, 9, 12, 14,
    9, 5, 11, 7, 12, 1, 10, 10, 12, 7, 7, 4, 7, 0, 5, 10, 10, 11, 10, 12,
    13, 16, 9, 12, 6, 16, 11, 12, 3, 12, 10, 6, 0, 0, 12, 9, 14, 9, 7, 11,
    10, 8, 13, 16, 8, 10, 12, 10, 6, 11, 14, 9, 0, 7, 3, 16, 12, 13, 11, 10,
    2, 6, 11, 10, 0, 7, 2, 4, 8, 14, 6, 18, 13, 10, 9, 7, 7, 5, 12, 11,
    19, 16, 13, 13, 12, 7, 8, 15, 13, 10, 3, 12, 10, 12, 14, 7, 18, 3, 11, 13,
    15, 16, 18, 7, 11, 13, 10, 11, 11, 7, 15, 11, 13, 0, 11, 7, 9, 1, 6, 7,
    19, 14, 15, 16, 12, 1, 12, 9, 10, 12, 5, 13, 0, 2, 14, 3, 11, 11, 1, 5,
    62, 78, 82, 86, 88, 85, 82, 82, 83, 80, 80, 78, 77, 76, 73, 70, 65, 60, 48, 43,
    72, 83, 89, 89, 92, 92, 93, 93, 95, 94, 93, 93, 92, 91, 89, 86, 80, 72, 68, 73,
    53, 81, 88, 89, 88, 84, 86, 85, 85, 86, 86, 84, 82, 80, 76, 70, 57, 63, 65, 63,
    69, 80, 83, 82, 87, 88, 86, 86, 82, 81, 79, 77, 74, 72, 66, 65, 61, 53, 63, 53,
    52, 66, 69, 67, 62, 62, 57, 56, 60, 67, 67, 67, 65, 64, 59, 53, 49, 55, 50, 41,
    66, 74, 75, 76, 73, 75, 76, 73, 73, 69, 68, 67, 65, 63, 57, 41, 56, 57, 46, 52,
    66, 78, 82, 83, 84, 83, 84, 84, 83, 83, 82, 81, 79, 76, 67, 62, 68, 64, 61, 58,
    57, 61, 69, 65, 65, 66, 67, 68, 69, 69, 68, 68, 66, 62, 51, 52, 53, 34, 49, 43,
    58, 60, 63, 67, 61, 64, 57, 53, 53, 54, 54, 52, 51, 47, 37, 42, 49, 43, 41, 32,
    59, 68, 74, 76, 75, 74, 75, 74, 73, 72, 72, 70, 67, 63, 60, 63, 62, 53, 50, 41,
    55, 65, 68, 70, 70, 70, 71, 70, 69, 68, 66, 64, 58, 45, 61, 63, 56, 45, 42, 42,
    53, 61, 67, 68, 69, 68, 66, 67, 67, 67, 66, 66, 63, 59, 56, 54, 51, 45, 44, 29,
    42, 59, 62, 60, 60, 59, 61, 64, 63, 60, 57, 57, 53, 40, 42, 41, 48, 42, 20, 25,
    54, 68, 72, 72, 72, 71, 71, 71, 71, 71, 69, 67, 62, 52, 41, 54, 54, 46, 45, 38,
    57, 68, 69, 63, 65, 64, 66, 67, 67, 63, 60, 56, 49, 47, 52, 54, 47, 41, 37, 29,
    52, 52, 54, 56, 45, 49, 47, 49, 46, 33, 29, 33, 40, 44, 42, 40, 33, 29, 24, 19,
    42, 47, 45, 46, 43, 43, 49, 46, 48, 47, 47, 45, 38, 40, 37, 35, 36, 28, 19, 9,
    40, 48, 49, 49, 48, 48, 47, 44, 41, 42, 41, 35, 35, 36, 36, 33, 30, 24, 19, 11,
    43, 49, 52, 51, 52, 54, 51, 52, 48, 50, 46, 40, 41, 47, 50, 47, 37, 35, 19, 20,
    35, 30, 32, 35, 43, 45, 46, 47, 47, 46, 45, 43, 37, 34, 36, 35, 33, 18, 13, 13,
    41, 44, 42, 42, 42, 39, 42, 41, 38, 40, 37, 37, 34, 35, 35, 33, 25, 19, 11, 9,
    38, 41, 39, 28, 34, 33, 40, 40, 40, 40, 38, 34, 30, 36, 40, 37, 30, 28, 21, 3,
    30, 36, 39, 41, 40, 43, 43, 44, 43, 42, 39, 36, 34, 38, 33, 32, 29, 24, 15, 12,
    29, 29, 13, 15, 21, 24, 28, 28, 26, 29, 29, 20, 24, 25, 19, 21, 14, 9, 18, 7,
    34, 33, 29, 15, 26, 31, 25, 18, 21, 19, 14, 19, 10, 23, 15, 17, 10, 16, 2, 4,
    31, 34, 30, 32, 36, 33, 34, 35, 36, 36, 33, 29, 21, 25, 24, 29, 3, 15, 6, 0,
    22, 30, 33, 34, 36, 35, 35, 34, 32, 31, 26, 20, 21, 26, 22, 13, 12, 1, 3, 0,
    23, 33, 37, 38, 39, 40, 40, 40, 39, 37, 34, 31, 29, 30, 13, 20, 17, 9, 8, 15,
    8, 10, 25, 27, 27, 15, 25, 24, 21, 24, 20, 16, 13, 12, 18, 9, 13, 3, 0, 9,
    14, 28, 33, 33, 32, 33, 35, 25, 26, 29, 28, 25, 11, 21, 15, 5, 1, 7, 7, 7,
    17, 22, 27, 28, 26, 13, 23, 17, 21, 22, 23, 17, 18, 13, 16, 12, 14, 11, 10, 8,
    25, 26, 27, 27, 24, 21, 28, 27, 27, 27, 26, 21, 18, 19, 17, 21, 4, 8, 0, 4,
    6, 7, 10, 10, 13, 19, 0, 14, 5, 11, 9, 0, 0, 7, 6, 14, 2, 11, 3, 10,
    6, 16, 23, 25, 21, 25, 22, 23, 21, 20, 15, 0, 6, 15, 13, 7, 0, 10, 10, 6,
    19, 17, 10, 7, 11, 13, 0, 17, 12, 6, 10, 5, 5, 0, 10, 5, 9, 7, 0, 9,
    16, 28, 29, 23, 17, 23, 14, 18, 15, 20, 19, 0, 16, 16, 1, 7, 4, 3, 16, 7,
    22, 7, 1, 7, 18, 17, 21, 17, 17, 13, 15, 12, 15, 10, 4, 7, 5, 5, 10, 15,
    19, 17, 4, 11, 7, 13, 11, 6, 7, 5, 6, 13, 4, 14, 11, 6, 5, 4, 5, 11,
    16, 14, 17, 21, 16, 19, 14, 18, 15, 11, 5, 13, 9, 6, 5, 2, 3, 11, 13, 0,
    8, 12, 9, 6, 16, 18, 16, 9, 8, 0, 11, 15, 10, 13, 12, 0, 13, 14, 4, 8,
    72, 86, 89, 94, 96, 93, 94, 89, 89, 89, 87, 87, 86, 85, 83, 80, 74, 68, 64, 55,
    81, 91, 97, 97, 100, 101, 102, 102, 103, 103, 102, 102, 101, 99, 97, 95, 89, 80, 76, 80,
    65, 91, 97, 98, 97, 94, 95, 94, 93, 93, 92, 91, 89, 87, 81, 75, 60, 69, 71, 72,
    78, 89, 92, 91, 96, 97, 95, 95, 92, 93, 92, 91, 88, 86, 81, 77, 74, 68, 73, 62,
    54, 75, 78, 78, 75, 73, 62, 68, 62, 72, 75, 72, 70, 68, 63, 55, 56, 61, 58, 50,
    77, 82, 82, 83, 81, 83, 84, 80, 82, 80, 79, 79, 77, 75, 70, 62, 66, 68, 52, 60,
    76, 88, 93, 94, 95, 94, 94, 94, 94, 94, 93, 92, 90, 87, 77, 73, 77, 73, 71, 68,
    67, 74, 80, 74, 75, 79, 80, 80, 80, 79, 79, 79, 76, 72, 61, 63, 64, 45, 59, 51,
    73, 76, 74, 80, 73, 78, 75, 72, 69, 66, 59, 49, 55, 51, 42, 60, 65, 61, 54, 39,
    72, 81, 87, 89, 88, 87, 88, 87, 87, 87, 86, 85, 81, 76, 71, 76, 75, 66, 57, 59,
    67, 78, 80, 82, 81, 81, 81, 81, 80, 79, 77, 76, 70, 63, 71, 73, 65, 55, 48, 48,
    67, 76, 82, 84, 86, 85, 84, 84, 83, 82, 81, 80, 77, 71, 69, 68, 67, 62, 57, 34,
    53, 72, 75, 76, 75, 75, 71, 74, 80, 74, 74, 74, 66, 58, 57, 60, 64, 56, 45, 37,
    72, 83, 87, 87, 87, 86, 87, 87, 86, 85, 83, 81, 75, 62, 65, 70, 67, 61, 57, 51,
    76, 86, 86, 79, 82, 80, 85, 84, 84, 80, 76, 70, 62, 66, 72, 70, 69, 53, 53, 36,
    72, 71, 72, 75, 67, 68, 67, 65, 68, 63, 58, 28, 58, 62, 62, 58, 51, 50, 42, 36,
    65, 71, 69, 69, 69, 68, 71, 71, 72, 72, 71, 68, 58, 59, 61, 55, 56, 50, 41, 25,
    59, 69, 71, 73, 73, 73, 71, 70, 68, 68, 65, 61, 58, 59, 56, 54, 57, 45, 43, 34,
    61, 68, 70, 69, 70, 74, 69, 70, 65, 68, 64, 60, 56, 64, 66, 62, 52, 52, 36, 30,
    52, 45, 59, 63, 65, 67, 66, 68, 66, 64, 63, 61, 49, 56, 61, 58, 47, 40, 25, 35,
    60, 63, 60, 58, 56, 58, 57, 55, 44, 52, 51, 43, 46, 48, 52, 37, 31, 38, 30, 24,
    59, 65, 66, 61, 63, 60, 65, 67, 67, 66, 65, 63, 53, 55, 61, 60, 49, 45, 33, 17,
    58, 64, 67, 70, 71, 73, 74, 74, 74, 73, 70, 68, 64, 68, 67, 61, 57, 53, 40, 25,
    57, 61, 57, 46, 53, 54, 54, 54, 55, 52, 52, 49, 41, 24, 48, 48, 38, 29, 28, 13,
    44, 51, 57, 59, 46, 40, 44, 54, 35, 50, 50, 44, 43, 45, 41, 33, 36, 23, 6, 11,
    55, 56, 56, 56, 58, 58, 56, 54, 54, 54, 50, 46, 38, 45, 46, 47, 21, 37, 25, 19,
    50, 56, 58, 60, 61, 59, 60, 61, 60, 59, 56, 53, 44, 48, 49, 42, 34, 32, 17, 11,
    51, 53, 54, 54, 58, 59, 57, 55, 57, 52, 50, 49, 43, 41, 36, 39, 32, 23, 13, 11,
    52, 51, 52, 52, 54, 46, 50, 46, 49, 50, 47, 35, 48, 45, 37, 33, 23, 24, 15, 10,
    39, 59, 63, 62, 64, 62, 61, 62, 59, 60, 47, 47, 48, 50, 41, 38, 2, 18, 10, 5,
    48, 60, 62, 58, 50, 59, 57, 60, 59, 54, 51, 55, 50, 45, 44, 29, 31, 25, 13, 12,
    29, 51, 52, 50, 52, 51, 53, 52, 51, 48, 43, 36, 28, 35, 45, 39, 31, 21, 14, 0,
    36, 46, 40, 37, 30, 28, 37, 31, 27, 29, 24, 26, 20, 18, 20, 20, 13, 10, 10, 8,
    41, 45, 47, 50, 51, 51, 51, 51, 49, 47, 42, 37, 40, 42, 36, 22, 22, 19, 10, 9,
    34, 42, 46, 43, 43, 42, 41, 40, 36, 35, 27, 29, 33, 29, 25, 23, 16, 11, 9, 16,
    41, 43, 42, 42, 39, 37, 40, 36, 37, 31, 32, 36, 39, 37, 27, 28, 13, 16, 10, 2,
    37, 26, 33, 36, 42, 43, 29, 35, 39, 39, 38, 36, 32, 31, 19, 24, 18, 11, 13, 9,
    46, 39, 43, 38, 23, 38, 34, 41, 36, 38, 35, 33, 31, 32, 24, 13, 1, 13, 7, 7,
    44, 50, 52, 51, 51, 51, 48, 47, 44, 37, 32, 39, 38, 32, 29, 29, 19, 7, 8, 10,
    32, 37, 38, 35, 36, 31, 38, 42, 36, 33, 36, 32, 12, 22, 24, 15, 0, 2, 11, 11,
    69, 79, 79, 76, 82, 80, 80, 78, 76, 79, 77, 77, 75, 74, 70, 65, 55, 49, 50, 51,
    65, 74, 79, 79, 81, 83, 82, 83, 84, 84, 81, 79, 75, 70, 57, 58, 60, 55, 47, 34,
    56, 53, 59, 67, 73, 75, 77, 76, 76, 75, 73, 73, 71, 69, 66, 62, 57, 61, 59, 56,
    58, 66, 69, 67, 64, 61, 65, 64, 63, 65, 65, 64, 62, 60, 54, 43, 53, 42, 46, 34,
    59, 57, 61, 64, 65, 65, 66, 67, 68, 68, 68, 67, 66, 63, 55, 51, 51, 52, 42, 40,
    56, 64, 66, 67, 66, 66, 66, 67, 65, 65, 65, 64, 62, 60, 51, 50, 37, 52, 36, 40,
    49, 51, 52, 52, 54, 55, 56, 56, 56, 56, 56, 56, 55, 53, 50, 50, 45, 37, 38, 32,
    43, 40, 45, 45, 44, 44, 42, 43, 45, 44, 41, 39, 38, 29, 33, 34, 29, 21, 18, 16,
    37, 40, 40, 43, 44, 44, 44, 45, 45, 44, 45, 42, 38, 30, 36, 32, 30, 24, 15, 17,
    25, 29, 25, 12, 23, 23, 26, 23, 25, 21, 28, 28, 31, 30, 8, 23, 22, 20, 20, 0,
    18, 31, 34, 35, 35, 37, 38, 39, 39, 40, 41, 41, 38, 30, 28, 17, 23, 15, 14, 7,
    27, 33, 33, 31, 33, 33, 33, 33, 34, 34, 34, 34, 31, 21, 20, 21, 21, 18, 19, 9,
    22, 25, 25, 28, 26, 23, 24, 24, 25, 25, 21, 24, 18, 18, 26, 12, 20, 7, 2, 8,
    17, 6, 25, 28, 22, 27, 28, 27, 30, 31, 32, 32, 27, 14, 11, 14, 18, 5, 11, 2,
    9, 19, 23, 21, 25, 25, 25, 22, 17, 19, 25, 9, 10, 19, 11, 5, 0, 0, 8, 5,
    9, 1, 13, 10, 12, 8, 14, 9, 8, 11, 5, 15, 17, 6, 15, 3, 10, 8, 8, 15,
    7, 7, 9, 1, 9, 20, 12, 14, 14, 8, 11, 11, 9, 14, 15, 1, 8, 7, 0, 7,
    16, 20, 19, 23, 23, 21, 20, 23, 22, 21, 15, 12, 7, 0, 15, 14, 11, 8, 12, 6,
    25, 22, 19, 22, 19, 15, 22, 14, 19, 12, 16, 10, 13, 14, 18, 18, 16, 18, 18, 17,
    10, 3, 1, 14, 18, 15, 19, 4, 13, 9, 13, 13, 8, 8, 6, 8, 8, 11, 0, 15,
    15, 21, 24, 27, 26, 25, 26, 24, 23, 21, 18, 0, 9, 18, 10, 15, 9, 7, 9, 15,
    2, 5, 9, 0, 13, 6, 10, 0, 12, 5, 13, 11, 13, 7, 9, 8, 9, 12, 8, 4,
    18, 14, 15, 12, 12, 14, 6, 8, 13, 5, 10, 9, 11, 11, 15, 9, 9, 14, 0, 10,
    13, 13, 12, 1, 6, 14, 0, 13, 11, 13, 0, 8, 8, 0, 0, 14, 0, 4, 10, 8,
    6, 5, 0, 6, 17, 12, 7, 6, 15, 9, 5, 12, 0, 12, 0, 9, 1, 4, 7, 7,
    14, 7, 16, 16, 5, 4, 13, 7, 18, 11, 0, 5, 6, 3, 6, 13, 6, 11, 9, 7,
    12, 12, 12, 7, 13, 7, 15, 15, 9, 7, 13, 12, 9, 14, 13, 0, 13, 16, 3, 9,
    7, 9, 13, 15, 17, 16, 13, 12, 12, 11, 10, 10, 14, 0, 7, 9, 12, 0, 13, 5,
    19, 16, 19, 19, 8, 14, 4, 0, 13, 16, 2, 15, 1, 4, 13, 0, 7, 12, 4, 11,
    22, 22, 20, 16, 15, 9, 17, 12, 15, 8, 9, 14, 17, 5, 0, 0, 7, 9, 7, 0,
    9, 12, 1, 12, 7, 18, 3, 8, 7, 8, 7, 10, 11, 7, 10, 9, 9, 10, 10, 9,
    15, 12, 10, 8, 6, 13, 5, 15, 13, 3, 11, 6, 6, 3, 7, 13, 12, 8, 6, 1,
    15, 12, 15, 18, 11, 11, 12, 15, 14, 16, 11, 12, 14, 16, 12, 17, 10, 16, 20, 18,
    8, 7, 4, 13, 9, 15, 12, 13, 3, 5, 8, 12, 3, 2, 8, 0, 6, 10, 5, 7,
    14, 8, 7, 7, 2, 11, 13, 8, 12, 4, 11, 14, 12, 11, 4, 7, 5, 7, 5, 13,
    17, 14, 10, 11, 6, 11, 4, 0, 11, 6, 10, 4, 13, 13, 4, 8, 0, 13, 12, 3,
    9, 12, 13, 0, 5, 8, 5, 13, 0, 11, 16, 8, 15, 11, 7, 5, 0, 0, 11, 9,
    16, 5, 11, 17, 13, 15, 15, 7, 0, 12, 12, 13, 4, 0, 14, 9, 7, 0, 3, 0,
    12, 7, 0, 12, 10, 7, 0, 0, 13, 8, 0, 0, 11, 9, 5, 13, 0, 16, 9, 2,
    0, 12, 12, 5, 10, 12, 13, 6, 3, 6, 7, 7, 10, 12, 0, 6, 6, 0, 0, 8,
    70, 84, 89, 87, 90, 90, 91, 88, 85, 89, 87, 87, 85, 83, 79, 75, 62, 60, 63, 54,
    74, 81, 90, 91, 92, 94, 94, 94, 95, 95, 92, 90, 86, 81, 72, 71, 70, 66, 56, 52,
    64, 74, 67, 79, 85, 88, 89, 88, 88, 87, 85, 84, 81, 77, 68, 64, 67, 68, 66, 65,
    64, 78, 84, 85, 80, 79, 81, 81, 80, 81, 79, 77, 74, 70, 56, 61, 67, 51, 54, 55,
    73, 73, 76, 79, 80, 80, 80, 82, 82, 82, 81, 80, 77, 72, 60, 69, 53, 68, 58, 60,
    67, 79, 83, 84, 84, 84, 84, 85, 83, 83, 82, 80, 76, 69, 66, 68, 62, 65, 53, 45,
    64, 73, 75, 74, 76, 76, 78, 79, 78, 77, 76, 76, 72, 69, 67, 58, 70, 58, 61, 54,
    69, 67, 69, 74, 71, 73, 71, 71, 71, 70, 67, 61, 55, 57, 58, 44, 51, 42, 40, 41,
    62, 72, 74, 75, 77, 76, 76, 77, 77, 76, 74, 71, 61, 63, 63, 60, 54, 53, 52, 43,
    56, 58, 52, 59, 63, 65, 66, 65, 66, 66, 65, 63, 55, 53, 56, 50, 55, 53, 46, 34,
    52, 64, 68, 69, 70, 70, 70, 71, 71, 70, 69, 67, 57, 52, 46, 59, 50, 42, 39, 33,
    55, 65, 67, 66, 66, 66, 65, 66, 66, 66, 64, 61, 48, 55, 50, 49, 43, 33, 27, 29,
    50, 60, 62, 63, 63, 65, 65, 63, 65, 65, 60, 52, 52, 56, 53, 44, 40, 38, 35, 20,
    54, 48, 63, 64, 63, 64, 66, 66, 66, 67, 66, 63, 48, 51, 40, 43, 45, 43, 22, 27,
    53, 53, 54, 58, 57, 61, 48, 55, 42, 52, 54, 49, 41, 49, 44, 41, 42, 29, 19, 19,
    46, 43, 48, 46, 43, 44, 42, 40, 40, 40, 30, 21, 25, 25, 23, 12, 8, 12, 10, 11,
    39, 37, 40, 39, 38, 36, 41, 41, 39, 41, 39, 31, 33, 35, 17, 29, 26, 14, 15, 8,
    35, 45, 46, 46, 48, 48, 50, 50, 51, 51, 50, 45, 31, 40, 33, 37, 29, 25, 19, 7,
    40, 46, 40, 38, 41, 34, 30, 29, 38, 40, 41, 41, 32, 24, 33, 26, 24, 11, 13, 14,
    29, 32, 30, 27, 30, 34, 31, 32, 30, 23, 28, 30, 34, 33, 19, 24, 21, 17, 0, 14,
    24, 32, 38, 41, 42, 43, 43, 43, 44, 43, 41, 38, 38, 31, 22, 22, 15, 11, 7, 9,
    24, 24, 25, 28, 19, 26, 11, 12, 14, 20, 26, 27, 25, 23, 15, 19, 16, 14, 12, 8,
    27, 24, 22, 23, 27, 28, 21, 17, 13, 11, 24, 25, 21, 19, 20, 18, 6, 5, 16, 10,
    23, 21, 25, 25, 25, 26, 23, 27, 25, 26, 21, 21, 15, 17, 14, 5, 5, 16, 14, 0,
    24, 25, 28, 26, 24, 22, 22, 10, 17, 21, 23, 26, 16, 23, 12, 14, 5, 9, 12, 8,
    18, 24, 32, 30, 27, 26, 27, 27, 20, 10, 13, 24, 19, 8, 11, 10, 0, 5, 9, 9,
    27, 32, 33, 33, 32, 28, 31, 30, 27, 27, 26, 29, 19, 20, 20, 12, 12, 5, 2, 7,
    33, 39, 40, 38, 38, 35, 31, 28, 20, 28, 28, 31, 25, 6, 10, 11, 13, 9, 15, 6,
    22, 29, 20, 27, 26, 23, 26, 23, 22, 25, 25, 15, 18, 19, 8, 0, 14, 3, 0, 15,
    25, 30, 31, 31, 32, 32, 32, 31, 30, 24, 19, 26, 17, 22, 16, 16, 11, 0, 14, 8,
    26, 20, 21, 13, 18, 18, 15, 17, 18, 8, 6, 19, 8, 10, 6, 14, 0, 0, 13, 5,
    15, 9, 14, 15, 20, 14, 9, 15, 15, 13, 6, 9, 14, 0, 5, 7, 0, 1, 9, 1,
    19, 18, 21, 15, 20, 19, 18, 17, 12, 16, 1, 7, 7, 13, 7, 9, 12, 5, 0, 16,
    20, 15, 6, 5, 23, 9, 15, 13, 15, 10, 15, 15, 6, 0, 3, 6, 4, 11, 11, 11,
    14, 15, 13, 6, 14, 16, 7, 14, 8, 14, 9, 9, 9, 6, 10, 8, 1, 11, 7, 4,
    24, 25, 14, 21, 15, 21, 23, 24, 21, 18, 8, 12, 9, 0, 13, 11, 1, 9, 5, 7,
    17, 19, 18, 12, 20, 22, 18, 18, 20, 13, 12, 10, 9, 4, 9, 11, 0, 9, 1, 4,
    5, 8, 16, 19, 15, 0, 14, 15, 14, 11, 6, 12, 3, 14, 17, 9, 14, 7, 2, 0,
    13, 9, 18, 10, 15, 18, 18, 20, 21, 14, 0, 15, 7, 14, 12, 2, 17, 14, 11, 14,
    10, 5, 16, 13, 16, 13, 17, 17, 19, 10, 15, 12, 2, 8, 12, 14, 13, 0, 2, 5,
    79, 89, 95, 94, 96, 99, 98, 98, 93, 95, 94, 94, 92, 91, 88, 84, 71, 67, 71, 62,
    80, 88, 97, 98, 100, 102, 102, 103, 104, 103, 100, 98, 94, 89, 80, 80, 78, 73, 61, 56,
    68, 82, 75, 86, 92, 95, 95, 95, 94, 93, 92, 90, 86, 80, 71, 74, 74, 74, 74, 71,
    72, 86, 91, 92, 88, 88, 88, 87, 85, 87, 85, 83, 80, 75, 53, 70, 72, 48, 61, 57,
    80, 82, 84, 87, 90, 89, 88, 90, 89, 89, 89, 88, 84, 78, 73, 78, 65, 77, 64, 68,
    75, 87, 90, 91, 91, 91, 90, 90, 88, 88, 86, 84, 78, 67, 74, 71, 73, 70, 61, 55,
    74, 82, 85, 83, 85, 86, 88, 88, 88, 88, 87, 86, 82, 79, 78, 62, 79, 71, 72, 63,
    80, 77, 80, 85, 83, 84, 82, 82, 82, 81, 76, 65, 66, 63, 57, 56, 41, 55, 44, 32,
    72, 84, 86, 87, 89, 88, 88, 88, 87, 86, 84, 80, 73, 77, 70, 75, 70, 62, 60, 55,
    69, 72, 54, 71, 74, 78, 79, 79, 80, 80, 78, 73, 47, 69, 69, 62, 65, 66, 53, 51,
    64, 77, 80, 81, 82, 82, 82, 83, 82, 81, 79, 75, 62, 69, 60, 72, 63, 57, 50, 44,
    69, 79, 82, 80, 81, 81, 80, 80, 80, 80, 77, 72, 64, 71, 51, 65, 60, 56, 48, 41,
    65, 73, 76, 76, 75, 76, 79, 75, 78, 76, 74, 66, 68, 66, 67, 54, 50, 38, 47, 26,
    70, 68, 78, 79, 77, 77, 79, 78, 79, 79, 77, 73, 63, 67, 64, 62, 57, 36, 35, 31,
    71, 69, 75, 79, 76, 82, 75, 79, 72, 67, 71, 63, 68, 69, 61, 57, 60, 49, 40, 22,
    65, 65, 69, 68, 64, 66, 63, 64, 62, 57, 32, 51, 46, 53, 47, 42, 28, 36, 17, 12,
    61, 62, 55, 57, 60, 47, 61, 61, 61, 61, 58, 50, 56, 48, 41, 47, 42, 31, 17, 11,
    57, 64, 67, 69, 69, 69, 68, 68, 67, 65, 60, 55, 59, 50, 46, 51, 48, 17, 25, 22,
    58, 63, 55, 50, 58, 57, 56, 61, 60, 58, 54, 55, 51, 38, 48, 50, 35, 36, 24, 22,
    44, 54, 52, 53, 55, 56, 54, 54, 52, 52, 52, 54, 51, 50, 45, 47, 38, 30, 16, 1,
    56, 62, 63, 62, 64, 63, 63, 62, 60, 57, 47, 45, 49, 38, 37, 41, 36, 18, 12, 8,
    41, 38, 54, 53, 47, 48, 49, 51, 58, 58, 55, 49, 44, 47, 33, 45, 36, 29, 14, 0,
    57, 60, 61, 62, 63, 63, 63, 63, 60, 57, 47, 53, 48, 43, 40, 36, 32, 34, 19, 10,
    42, 50, 53, 54, 53, 53, 52, 49, 48, 46, 38, 42, 39, 39, 32, 32, 24, 17, 9, 9,
    45, 40, 47, 46, 50, 48, 35, 43, 37, 45, 46, 41, 36, 35, 0, 29, 20, 19, 4, 13,
    36, 45, 52, 49, 45, 47, 46, 44, 41, 36, 42, 45, 26, 33, 26, 21, 20, 3, 5, 0,
    51, 55, 58, 58, 57, 51, 44, 49, 51, 39, 42, 52, 43, 42, 29, 23, 15, 20, 13, 5,
    50, 53, 53, 56, 55, 54, 48, 48, 50, 45, 38, 46, 37, 32, 31, 22, 5, 13, 10, 8,
    47, 49, 52, 51, 50, 50, 44, 41, 44, 43, 35, 38, 31, 26, 33, 24, 15, 14, 9, 8,
    40, 50, 49, 47, 50, 49, 49, 48, 42, 36, 37, 32, 34, 29, 28, 19, 0, 9, 4, 8,
    42, 32, 36, 32, 35, 34, 37, 38, 39, 38, 34, 27, 25, 24, 18, 15, 14, 8, 5, 0,
    33, 26, 29, 13, 27, 26, 31, 26, 30, 27, 23, 20, 18, 22, 18, 2, 10, 5, 13, 8,
    29, 30, 37, 37, 37, 33, 33, 34, 32, 19, 30, 14, 13, 18, 10, 19, 14, 15, 13, 15,
    28, 33, 38, 36, 35, 32, 28, 34, 35, 33, 15, 25, 26, 19, 14, 12, 11, 13, 4, 0,
    37, 39, 33, 38, 38, 37, 37, 31, 16, 22, 12, 26, 10, 16, 17, 2, 9, 10, 10, 3,
    33, 41, 41, 42, 42, 45, 45, 46, 43, 39, 29, 28, 29, 31, 27, 12, 14, 1, 4, 7,
    28, 21, 29, 28, 28, 27, 29, 29, 25, 16, 21, 12, 18, 3, 10, 9, 8, 0, 12, 0,
    29, 33, 28, 32, 32, 13, 26, 31, 34, 36, 25, 28, 24, 0, 7, 11, 13, 3, 0, 0,
    32, 33, 33, 35, 36, 36, 36, 30, 28, 23, 29, 29, 16, 16, 6, 11, 2, 12, 8, 4,
    35, 43, 38, 42, 45, 46, 47, 47, 45, 37, 39, 34, 37, 31, 24, 4, 11, 2, 7, 15,
    74, 74, 58, 70, 67, 62, 62, 67, 64, 64, 64, 65, 65, 64, 64, 63, 59, 56, 54, 55,
    63, 71, 74, 72, 74, 75, 77, 77, 76, 75, 73, 71, 67, 63, 58, 56, 54, 57, 55, 51,
    48, 53, 59, 63, 64, 63, 61, 62, 63, 61, 58, 54, 40, 51, 56, 55, 49, 48, 44, 47,
    50, 53, 52, 51, 51, 51, 53, 54, 56, 56, 56, 56, 56, 52, 46, 48, 47, 32, 41, 41,
    30, 40, 44, 47, 49, 50, 50, 49, 45, 40, 36, 44, 50, 52, 50, 45, 45, 46, 38, 36,
    45, 48, 48, 50, 51, 50, 49, 49, 49, 48, 46, 45, 44, 43, 42, 41, 33, 39, 29, 28,
    33, 26, 23, 30, 27, 29, 23, 31, 30, 27, 16, 14, 19, 22, 25, 23, 17, 17, 16, 8,
    15, 2, 25, 19, 26, 26, 24, 22, 18, 20, 17, 23, 20, 21, 15, 15, 4, 19, 12, 21,
    14, 10, 17, 9, 16, 15, 19, 13, 18, 19, 16, 18, 0, 9, 14, 18, 0, 5, 16, 0,
    21, 19, 19, 24, 23, 22, 19, 17, 19, 14, 16, 16, 16, 17, 9, 8, 10, 9, 16, 8,
    19, 22, 22, 25, 24, 24, 23, 21, 22, 22, 18, 16, 17, 13, 0, 0, 15, 5, 12, 8,
    21, 21, 23, 17, 18, 20, 9, 9, 15, 20, 19, 17, 0, 14, 0, 9, 2, 8, 4, 3,
    11, 20, 20, 21, 14, 17, 20, 20, 18, 14, 8, 0, 4, 9, 3, 16, 8, 15, 11, 7,
    15, 20, 12, 8, 11, 14, 14, 15, 18, 15, 18, 8, 16, 5, 15, 8, 2, 8, 12, 7,
    10, 17, 20, 21, 22, 15, 21, 18, 23, 21, 7, 18, 18, 16, 16, 18, 20, 11, 12, 0,
    7, 12, 10, 16, 16, 10, 0, 13, 16, 1, 11, 4, 8, 9, 14, 0, 12, 3, 8, 7,
    14, 13, 5, 7, 15, 15, 7, 2, 0, 16, 13, 18, 0, 9, 0, 7, 10, 11, 11, 4,
    12, 11, 2, 12, 8, 9, 13, 15, 12, 15, 12, 17, 17, 4, 8, 6, 13, 13, 5, 2,
    5, 14, 15, 17, 17, 13, 16, 14, 9, 0, 3, 12, 0, 4, 15, 7, 4, 3, 13, 13,
    19, 19, 16, 11, 13, 16, 18, 7, 11, 15, 14, 13, 10, 8, 15, 2, 13, 9, 13, 0,
    18, 18, 10, 18, 19, 19, 10, 16, 11, 17, 22, 12, 13, 11, 8, 1, 1, 14, 15, 7,
    13, 17, 19, 6, 15, 17, 9, 14, 9, 5, 12, 9, 8, 5, 11, 12, 8, 1, 5, 5,
    16, 7, 18, 17, 18, 12, 10, 2, 0, 17, 0, 14, 7, 11, 3, 11, 14, 6, 8, 12,
    14, 0, 7, 11, 0, 1, 8, 1, 11, 9, 17, 3, 6, 0, 8, 1, 2, 8, 6, 9,
    5, 14, 15, 16, 10, 13, 15, 16, 16, 15, 15, 15, 10, 6, 12, 7, 2, 7, 4, 15,
    2, 14, 14, 13, 16, 15, 15, 10, 14, 6, 7, 11, 2, 15, 9, 10, 7, 8, 6, 10,
    17, 7, 16, 14, 21, 18, 4, 15, 9, 8, 5, 12, 16, 17, 11, 13, 12, 11, 14, 10,
    19, 16, 21, 14, 11, 15, 16, 15, 17, 10, 0, 12, 8, 12, 10, 2, 4, 12, 5, 5,
    20, 17, 19, 16, 14, 19, 18, 15, 15, 0, 7, 13, 12, 1, 0, 8, 5, 8, 12, 13,
    17, 11, 5, 11, 5, 13, 10, 14, 5, 13, 12, 13, 9, 17, 0, 6, 6, 13, 10, 2,
    17, 16, 16, 14, 9, 8, 12, 8, 9, 16, 1, 10, 6, 14, 12, 12, 16, 15, 7, 4,
    21, 16, 14, 15, 6, 4, 9, 12, 7, 11, 16, 8, 5, 4, 17, 9, 4, 13, 15, 6,
    6, 8, 8, 0, 7, 15, 0, 3, 4, 8, 11, 0, 13, 12, 16, 10, 12, 12, 4, 8,
    8, 9, 1, 10, 12, 10, 3, 0, 7, 5, 16, 16, 13, 9, 5, 7, 9, 8, 12, 6,
    11, 6, 0, 15, 10, 13, 19, 15, 16, 7, 12, 6, 9, 9, 8, 18, 12, 11, 10, 14,
    10, 14, 14, 19, 8, 6, 7, 8, 16, 6, 5, 7, 8, 6, 5, 9, 8, 6, 15, 8,
    18, 9, 2, 4, 15, 8, 12, 6, 5, 7, 6, 17, 0, 9, 5, 7, 7, 7, 11, 6,
    9, 4, 10, 7, 14, 13, 8, 6, 8, 15, 5, 9, 1, 9, 7, 16, 11, 9, 14, 0,
    9, 8, 17, 12, 3, 3, 0, 10, 9, 7, 8, 9, 0, 8, 11, 0, 11, 4, 11, 6,
    18, 10, 13, 7, 6, 8, 15, 15, 12, 16, 4, 7, 3, 13, 12, 6, 2, 0, 13, 8,
    80, 87, 79, 80, 76, 66, 71, 80, 73, 70, 73, 73, 73, 73, 72, 71, 69, 65, 65, 67,
    71, 84, 90, 90, 88, 92, 93, 93, 93, 92, 90, 89, 85, 80, 68, 54, 56, 67, 66, 59,
    70, 59, 77, 81, 83, 83, 81, 82, 83, 82, 79, 77, 71, 62, 63, 65, 57, 66, 49, 52,
    74, 80, 80, 80, 79, 77, 79, 80, 80, 77, 78, 78, 77, 74, 71, 71, 65, 60, 60, 59,
    67, 68, 70, 68, 74, 78, 78, 78, 77, 76, 75, 75, 74, 73, 68, 68, 68, 62, 56, 42,
    68, 71, 72, 73, 75, 75, 73, 75, 74, 73, 71, 67, 60, 52, 57, 48, 58, 57, 51, 47,
    60, 52, 67, 63, 55, 58, 61, 61, 58, 56, 58, 60, 62, 60, 54, 53, 57, 50, 44, 42,
    55, 53, 58, 60, 60, 60, 58, 57, 57, 57, 54, 54, 51, 50, 46, 26, 32, 31, 30, 16,
    53, 56, 63, 65, 65, 63, 62, 61, 61, 60, 59, 57, 48, 53, 55, 45, 49, 32, 34, 30,
    50, 52, 55, 57, 52, 51, 50, 51, 43, 38, 41, 40, 23, 35, 34, 41, 33, 32, 22, 19,
    54, 59, 61, 60, 59, 60, 60, 60, 59, 58, 55, 45, 53, 55, 41, 49, 45, 38, 28, 24,
    48, 52, 51, 51, 51, 51, 48, 49, 46, 46, 37, 25, 46, 50, 42, 41, 36, 29, 18, 16,
    45, 51, 51, 49, 49, 34, 48, 33, 43, 46, 46, 46, 42, 36, 41, 20, 34, 24, 22, 12,
    30, 27, 36, 39, 47, 49, 48, 50, 48, 42, 33, 27, 38, 41, 31, 37, 31, 26, 16, 13,
    42, 39, 37, 35, 37, 45, 44, 45, 47, 46, 44, 36, 42, 35, 36, 25, 26, 20, 23, 17,
    26, 31, 34, 32, 32, 31, 28, 27, 31, 30, 31, 32, 30, 26, 21, 17, 3, 1, 14, 10,
    31, 36, 34, 30, 25, 29, 27, 21, 19, 24, 30, 31, 31, 21, 21, 18, 0, 11, 15, 11,
    27, 40, 40, 38, 37, 38, 36, 35, 32, 33, 33, 32, 16, 26, 14, 19, 13, 16, 7, 5,
    30, 33, 31, 30, 28, 28, 31, 29, 25, 22, 31, 32, 31, 24, 24, 17, 14, 13, 8, 6,
    27, 26, 17, 25, 30, 30, 30, 28, 28, 30, 27, 23, 9, 22, 19, 5, 6, 6, 9, 10,
    21, 25, 29, 30, 27, 24, 25, 19, 26, 29, 33, 32, 23, 21, 17, 7, 13, 11, 11, 14,
    28, 19, 18, 13, 21, 29, 27, 24, 22, 27, 26, 25, 24, 9, 18, 8, 10, 13, 2, 0,
    27, 26, 30, 30, 32, 32, 31, 31, 31, 29, 26, 19, 13, 18, 11, 10, 9, 0, 13, 1,
    23, 5, 19, 27, 23, 22, 25, 22, 11, 17, 4, 17, 17, 13, 6, 0, 16, 9, 12, 12,
    25, 10, 14, 18, 27, 20, 27, 23, 21, 19, 15, 12, 20, 11, 13, 13, 8, 14, 0, 9,
    24, 24, 22, 21, 22, 24, 23, 23, 17, 16, 12, 17, 16, 10, 16, 13, 6, 0, 3, 0,
    23, 27, 31, 18, 25, 16, 22, 9, 16, 17, 18, 9, 14, 8, 11, 14, 10, 0, 7, 14,
    25, 24, 20, 17, 22, 19, 20, 19, 6, 1, 18, 10, 15, 12, 11, 12, 8, 11, 4, 12,
    21, 19, 5, 16, 17, 19, 20, 19, 20, 15, 8, 18, 16, 16, 12, 10, 18, 15, 10, 8,
    13, 13, 20, 22, 13, 16, 13, 16, 13, 18, 15, 17, 15, 9, 1, 11, 12, 10, 2, 10,
    20, 25, 27, 24, 24, 24, 23, 23, 18, 19, 12, 14, 13, 15, 17, 16, 4, 12, 8, 12,
    14, 8, 14, 6, 10, 10, 9, 17, 7, 8, 6, 0, 11, 16, 14, 3, 5, 13, 7, 11,
    17, 10, 5, 12, 10, 11, 13, 13, 3, 6, 13, 14, 8, 4, 8, 15, 11, 0, 15, 10,
    14, 9, 5, 7, 19, 24, 7, 9, 8, 5, 5, 13, 0, 12, 16, 13, 14, 4, 14, 8,
    18, 25, 21, 15, 15, 18, 13, 16, 6, 17, 8, 13, 11, 5, 13, 10, 10, 3, 13, 19,
    12, 0, 16, 18, 18, 19, 13, 8, 13, 17, 10, 5, 12, 6, 9, 2, 5, 9, 10, 7,
    0, 15, 22, 19, 4, 19, 13, 12, 14, 10, 4, 17, 11, 15, 4, 7, 12, 9, 14, 9,
    15, 11, 0, 17, 23, 10, 16, 7, 12, 12, 12, 15, 12, 5, 8, 18, 13, 10, 9, 7,
    5, 9, 6, 1, 23, 6, 17, 20, 1, 14, 16, 11, 0, 12, 13, 7, 5, 5, 9, 18,
    13, 15, 7, 11, 0, 16, 10, 11, 7, 15, 5, 12, 13, 8, 0, 10, 13, 0, 8, 8,
    86, 96, 89, 93, 86, 80, 86, 82, 80, 78, 80, 81, 83, 82, 81, 81, 78, 75, 73, 75,
    77, 93, 99, 99, 97, 101, 102, 101, 102, 101, 100, 99, 94, 89, 76, 69, 61, 75, 72, 70,
    80, 67, 85, 90, 93, 93, 91, 91, 92, 89, 87, 84, 76, 64, 74, 72, 68, 73, 53, 55,
    85, 89, 89, 91, 91, 90, 91, 92, 91, 89, 88, 87, 84, 82, 78, 80, 73, 71, 68, 66,
    77, 81, 83, 80, 87, 90, 90, 90, 90, 88, 87, 84, 82, 81, 74, 76, 77, 69, 65, 53,
    79, 83, 84, 84, 85, 86, 84, 84, 82, 81, 77, 72, 58, 62, 69, 61, 64, 62, 54, 50,
    74, 64, 78, 73, 73, 72, 69, 74, 70, 63, 70, 72, 69, 65, 58, 63, 63, 50, 44, 43,
    71, 64, 78, 78, 74, 76, 73, 72, 72, 70, 69, 66, 56, 55, 50, 51, 36, 40, 37, 28,
    70, 75, 81, 84, 84, 81, 79, 77, 75, 69, 62, 59, 65, 70, 69, 49, 60, 42, 42, 39,
    67, 71, 74, 75, 74, 72, 72, 72, 66, 70, 65, 58, 43, 51, 58, 55, 53, 47, 39, 33,
    74, 79, 81, 79, 79, 79, 79, 79, 77, 74, 71, 66, 69, 70, 63, 58, 57, 50, 44, 28,
    68, 70, 67, 68, 69, 68, 65, 66, 68, 67, 64, 58, 61, 63, 53, 55, 47, 39, 32, 19,
    65, 73, 74, 72, 76, 70, 73, 61, 66, 70, 66, 61, 58, 59, 59, 49, 52, 45, 34, 26,
    66, 70, 65, 67, 70, 70, 70, 72, 70, 67, 65, 55, 61, 63, 39, 57, 51, 45, 34, 22,
    71, 68, 67, 67, 66, 74, 73, 73, 75, 74, 64, 59, 66, 56, 66, 47, 43, 36, 26, 21,
    56, 62, 65, 66, 65, 64, 63, 62, 58, 55, 57, 58, 57, 55, 52, 44, 24, 20, 0, 4,
    56, 63, 64, 57, 61, 59, 58, 56, 54, 52, 50, 55, 55, 34, 47, 37, 33, 28, 19, 3,
    55, 61, 60, 61, 62, 61, 60, 59, 56, 47, 53, 53, 43, 48, 43, 32, 31, 24, 14, 15,
    54, 57, 56, 59, 60, 58, 53, 52, 54, 51, 50, 51, 52, 41, 43, 31, 31, 22, 10, 7,
    52, 58, 57, 56, 61, 62, 62, 62, 62, 60, 54, 55, 56, 49, 47, 36, 30, 27, 15, 13,
    54, 56, 56, 55, 56, 54, 52, 47, 40, 48, 53, 53, 39, 44, 34, 26, 16, 9, 4, 7,
    58, 57, 56, 58, 60, 58, 60, 59, 57, 54, 51, 56, 50, 46, 47, 38, 33, 25, 13, 9,
    59, 62, 63, 62, 61, 62, 61, 59, 56, 50, 44, 46, 47, 43, 36, 16, 20, 18, 4, 8,
    50, 47, 50, 50, 44, 44, 42, 35, 26, 28, 26, 28, 29, 24, 19, 12, 10, 13, 15, 10,
    50, 46, 51, 55, 55, 53, 51, 53, 49, 47, 37, 40, 43, 40, 28, 26, 1, 9, 12, 1,
    53, 53, 49, 51, 44, 46, 41, 39, 39, 28, 35, 35, 30, 29, 22, 10, 6, 11, 7, 9,
    52, 48, 62, 59, 57, 58, 51, 54, 50, 46, 41, 44, 45, 32, 32, 15, 5, 11, 0, 12,
    50, 49, 48, 52, 47, 47, 47, 46, 43, 42, 33, 38, 22, 11, 24, 7, 11, 9, 9, 4,
    47, 42, 42, 43, 43, 40, 45, 47, 49, 50, 42, 32, 37, 33, 3, 13, 15, 6, 9, 13,
    27, 40, 36, 31, 34, 38, 24, 32, 19, 19, 27, 19, 15, 14, 17, 6, 9, 10, 5, 6,
    49, 52, 50, 49, 48, 47, 46, 41, 40, 36, 36, 28, 30, 30, 26, 14, 15, 8, 10, 9,
    30, 40, 39, 34, 22, 23, 19, 26, 22, 25, 13, 20, 21, 15, 0, 5, 14, 13, 16, 0,
    14, 33, 31, 30, 20, 24, 29, 33, 31, 27, 24, 12, 12, 0, 0, 10, 12, 13, 12, 16,
    23, 41, 38, 30, 31, 31, 27, 29, 23, 16, 27, 21, 18, 18, 5, 16, 12, 13, 6, 9,
    27, 41, 35, 37, 37, 37, 38, 39, 39, 35, 25, 29, 21, 15, 8, 15, 4, 14, 6, 4,
    24, 42, 37, 35, 31, 30, 25, 27, 30, 30, 31, 26, 19, 4, 9, 14, 0, 17, 9, 12,
    33, 43, 45, 41, 35, 31, 28, 26, 17, 7, 15, 8, 17, 12, 12, 4, 10, 7, 12, 9,
    30, 39, 28, 30, 34, 30, 31, 29, 26, 31, 22, 14, 2, 2, 18, 4, 11, 12, 9, 12,
    35, 38, 39, 39, 40, 32, 35, 38, 23, 27, 28, 26, 21, 17, 13, 13, 12, 13, 7, 7,
    35, 28, 18, 31, 31, 31, 26, 20, 18, 9, 14, 3, 5, 12, 1, 8, 13, 9, 0, 0,
    77, 82, 86, 87, 86, 86, 86, 87, 86, 85, 82, 80, 76, 73, 66, 59, 46, 52, 56, 52,
    52, 57, 51, 62, 64, 65, 68, 68, 69, 69, 68, 66, 64, 65, 67, 66, 58, 56, 53, 36,
    49, 37, 39, 42, 48, 51, 54, 54, 53, 52, 50, 48, 42, 40, 36, 37, 31, 32, 38, 34,
    46, 49, 50, 53, 55, 55, 55, 55, 55, 54, 53, 50, 45, 46, 47, 40, 24, 40, 38, 27,
    42, 47, 49, 50, 50, 51, 51, 50, 50, 48, 46, 44, 42, 42, 39, 39, 32, 31, 28, 25,
    16, 21, 25, 29, 18, 28, 28, 25, 26, 29, 33, 31, 16, 27, 22, 18, 27, 20, 21, 13,
    5, 24, 21, 27, 26, 22, 26, 29, 28, 29, 27, 27, 26, 22, 17, 16, 14, 8, 14, 10,
    14, 21, 18, 17, 17, 8, 10, 19, 13, 7, 17, 17, 20, 16, 12, 8, 15, 12, 12, 18,
    20, 23, 27, 28, 24, 26, 22, 20, 13, 21, 20, 21, 20, 17, 8, 16, 10, 13, 8, 12,
    20, 18, 26, 23, 16, 23, 12, 10, 8, 5, 14, 13, 14, 10, 13, 15, 17, 14, 15, 18,
    20, 22, 27, 12, 21, 12, 16, 21, 15, 14, 17, 12, 17, 15, 6, 17, 16, 14, 3, 5,
    19, 22, 20, 22, 19, 23, 19, 22, 11, 22, 9, 23, 13, 14, 6, 14, 17, 18, 7, 17,
    25, 14, 25, 24, 15, 22, 11, 22, 17, 9, 17, 14, 13, 10, 12, 14, 10, 14, 0, 4,
    12, 7, 19, 22, 16, 8, 10, 0, 19, 6, 13, 5, 15, 17, 10, 13, 12, 7, 9, 6,
    11, 10, 13, 24, 13, 20, 12, 12, 12, 5, 9, 10, 12, 12, 18, 17, 11, 8, 14, 11,
    11, 14, 10, 18, 11, 13, 4, 3, 6, 14, 16, 14, 15, 11, 12, 12, 8, 0, 0, 12,
    6, 15, 9, 13, 0, 12, 9, 2, 5, 12, 10, 5, 0, 11, 1, 16, 9, 18, 13, 7,
    6, 16, 8, 17, 13, 14, 4, 4, 11, 11, 0, 9, 18, 6, 0, 6, 9, 18, 16, 10,
    17, 9, 15, 21, 10, 10, 5, 14, 8, 11, 14, 8, 0, 9, 1, 6, 10, 6, 12, 2,
    16, 19, 16, 10, 15, 14, 20, 8, 12, 9, 15, 15, 11, 17, 7, 16, 8, 5, 13, 15,
    19, 1, 11, 6, 0, 16, 9, 14, 15, 14, 16, 14, 3, 13, 11, 11, 3, 10, 10, 1,
    8, 12, 9, 14, 0, 14, 8, 9, 0, 11, 7, 14, 14, 2, 4, 6, 7, 11, 5, 12,
    15, 13, 4, 16, 4, 0, 14, 6, 15, 3, 5, 11, 11, 16, 11, 14, 6, 11, 10, 14,
    15, 5, 10, 14, 10, 19, 7, 17, 9, 12, 11, 7, 14, 18, 5, 15, 13, 16, 11, 4,
    19, 11, 13, 13, 0, 8, 14, 0, 15, 12, 12, 0, 15, 14, 13, 16, 0, 13, 9, 14,
    13, 9, 17, 15, 11, 14, 11, 10, 13, 14, 14, 10, 13, 8, 8, 10, 0, 9, 0, 16,
    12, 7, 16, 19, 11, 0, 9, 13, 10, 8, 7, 10, 13, 1, 12, 9, 11, 1, 12, 8,
    8, 6, 0, 22, 13, 8, 16, 6, 0, 12, 12, 11, 9, 0, 10, 13, 17, 11, 10, 15,
    3, 17, 21, 12, 19, 20, 19, 16, 15, 8, 8, 10, 7, 0, 10, 8, 16, 10, 4, 11,
    1, 16, 15, 13, 15, 16, 13, 17, 13, 7, 14, 3, 5, 16, 16, 15, 17, 5, 0, 9,
    15, 17, 20, 20, 18, 13, 11, 10, 6, 8, 14, 11, 10, 8, 12, 10, 3, 13, 3, 11,
    16, 7, 12, 20, 14, 17, 11, 16, 12, 7, 14, 9, 4, 8, 4, 11, 13, 11, 3, 13,
    7, 5, 17, 9, 9, 16, 16, 1, 10, 0, 9, 17, 9, 7, 10, 9, 8, 18, 8, 8,
    19, 9, 5, 15, 10, 17, 2, 5, 5, 8, 11, 14, 14, 11, 8, 0, 10, 17, 10, 18,
    14, 10, 0, 12, 14, 13, 18, 9, 5, 6, 6, 20, 10, 7, 11, 4, 5, 18, 0, 9,
    5, 18, 4, 16, 15, 11, 10, 11, 5, 7, 12, 6, 8, 13, 14, 6, 6, 4, 9, 4,
    7, 15, 0, 0, 15, 15, 12, 9, 16, 11, 17, 13, 5, 10, 15, 9, 18, 9, 11, 14,
    14, 11, 16, 6, 2, 2, 12, 5, 7, 13, 9, 0, 8, 7, 8, 8, 15, 6, 5, 18,
    13, 15, 0, 11, 9, 3, 6, 9, 9, 12, 4, 13, 0, 5, 6, 15, 12, 11, 5, 15,
    15, 9, 17, 14, 17, 1, 2, 7, 6, 0, 4, 12, 17, 15, 5, 5, 15, 10, 5, 5,
    86, 91, 96, 99, 97, 97, 97, 97, 97, 96, 93, 91, 88, 84, 77, 69, 62, 58, 64, 62,
    70, 72, 74, 80, 85, 85, 89, 89, 89, 89, 88, 86, 81, 77, 75, 75, 73, 73, 65, 56,
    71, 66, 64, 67, 70, 75, 77, 78, 76, 76, 74, 72, 68, 66, 63, 58, 58, 45, 50, 43,
    69, 70, 72, 76, 78, 78, 77, 77, 77, 76, 74, 72, 68, 68, 68, 62, 51, 57, 59, 47,
    72, 77, 79, 80, 81, 82, 81, 81, 80, 79, 78, 76, 71, 63, 51, 52, 58, 52, 49, 44,
    57, 59, 61, 66, 63, 66, 67, 67, 67, 67, 65, 63, 58, 51, 46, 41, 46, 48, 36, 30,
    51, 62, 62, 62, 65, 66, 66, 67, 67, 67, 66, 65, 60, 52, 51, 44, 51, 35, 38, 31,
    46, 47, 50, 45, 47, 47, 50, 50, 50, 49, 50, 49, 45, 40, 37, 33, 27, 26, 17, 17,
    45, 53, 51, 50, 50, 48, 47, 45, 39, 45, 40, 40, 38, 25, 39, 32, 25, 17, 11, 8,
    28, 38, 38, 36, 35, 36, 35, 29, 25, 25, 33, 32, 27, 20, 23, 22, 11, 9, 9, 17,
    40, 38, 40, 44, 41, 41, 39, 37, 36, 35, 38, 43, 42, 34, 17, 29, 21, 23, 13, 11,
    23, 32, 37, 41, 41, 42, 40, 40, 38, 32, 32, 37, 31, 32, 20, 25, 21, 23, 13, 21,
    33, 29, 23, 32, 32, 37, 36, 35, 32, 29, 22, 21, 25, 26, 17, 23, 6, 12, 15, 9,
    35, 38, 35, 16, 32, 27, 34, 28, 32, 25, 24, 20, 21, 18, 13, 18, 11, 13, 13, 11,
    24, 31, 33, 34, 33, 33, 34, 33, 33, 29, 18, 16, 24, 8, 13, 9, 8, 3, 9, 3,
    17, 16, 21, 16, 19, 22, 21, 22, 21, 20, 20, 18, 17, 8, 14, 11, 2, 13, 16, 8,
    17, 1, 17, 15, 20, 17, 16, 19, 14, 16, 12, 15, 11, 0, 13, 4, 8, 9, 7, 11,
    18, 20, 26, 24, 23, 22, 26, 23, 19, 20, 15, 16, 4, 17, 15, 14, 17, 13, 7, 3,
    20, 14, 9, 15, 11, 15, 20, 19, 26, 23, 16, 10, 17, 11, 2, 17, 14, 5, 10, 14,
    21, 24, 27, 27, 23, 27, 26, 27, 25, 22, 16, 21, 23, 10, 19, 10, 14, 11, 12, 16,
    4, 19, 15, 0, 18, 17, 19, 8, 18, 14, 22, 8, 16, 14, 3, 16, 13, 12, 16, 12,
    26, 27, 27, 26, 27, 23, 24, 19, 16, 11, 13, 18, 14, 11, 5, 8, 8, 15, 12, 7,
    23, 18, 25, 22, 14, 22, 16, 15, 2, 4, 13, 0, 15, 13, 9, 9, 9, 2, 6, 13,
    16, 12, 21, 12, 14, 14, 18, 6, 8, 13, 9, 4, 8, 16, 7, 4, 6, 15, 10, 2,
    20, 0, 19, 14, 8, 9, 7, 4, 15, 10, 14, 14, 1, 8, 14, 11, 4, 2, 15, 11,
    24, 25, 18, 4, 16, 15, 16, 8, 12, 4, 10, 12, 15, 0, 12, 3, 13, 14, 16, 4,
    15, 16, 11, 8, 14, 18, 6, 11, 5, 5, 8, 12, 15, 1, 11, 0, 9, 7, 1, 14,
    19, 3, 24, 18, 16, 19, 12, 12, 9, 17, 9, 15, 14, 14, 14, 11, 14, 15, 10, 19,
    19, 10, 5, 20, 4, 4, 15, 12, 15, 13, 10, 12, 11, 15, 12, 14, 12, 8, 14, 10,
    9, 8, 5, 8, 7, 4, 17, 19, 7, 17, 10, 13, 7, 12, 17, 1, 10, 16, 12, 9,
    8, 14, 11, 9, 4, 11, 12, 15, 10, 20, 16, 11, 10, 13, 15, 13, 12, 14, 11, 12,
    15, 13, 0, 2, 13, 10, 6, 18, 16, 3, 15, 0, 6, 10, 5, 14, 9, 12, 12, 9,
    7, 6, 10, 6, 16, 7, 12, 9, 10, 16, 4, 11, 13, 6, 12, 16, 16, 7, 17, 1,
    13, 5, 13, 1, 13, 13, 8, 12, 12, 14, 8, 0, 15, 5, 0, 2, 14, 11, 7, 5,
    15, 6, 0, 10, 15, 18, 8, 14, 16, 14, 13, 8, 19, 1, 13, 18, 5, 0, 10, 11,
    16, 15, 15, 4, 6, 14, 7, 9, 0, 9, 17, 10, 14, 16, 6, 15, 5, 18, 0, 9,
    11, 14, 11, 3, 13, 15, 15, 0, 14, 0, 15, 12, 8, 12, 7, 5, 8, 17, 13, 11,
    12, 16, 8, 16, 10, 8, 14, 18, 6, 11, 10, 7, 7, 11, 14, 13, 10, 22, 18, 15,
    15, 14, 1, 8, 9, 8, 14, 11, 9, 12, 1, 19, 13, 9, 0, 15, 14, 18, 16, 8,
    8, 13, 15, 11, 14, 12, 4, 4, 16, 10, 14, 11, 11, 16, 9, 19, 0, 11, 18, 12,
    98, 105, 110, 112, 111, 111, 111, 111, 110, 109, 106, 105, 102, 98, 90, 81, 77, 73, 72, 72,
    87, 85, 90, 94, 101, 103, 105, 106, 105, 104, 103, 101, 97, 92, 88, 88, 87, 87, 77, 71,
    88, 82, 81, 85, 84, 90, 91, 91, 91, 89, 87, 85, 81, 78, 74, 63, 71, 62, 60, 57,
    87, 87, 88, 93, 95, 95, 95, 95, 95, 93, 91, 88, 85, 83, 83, 79, 74, 63, 77, 64,
    90, 95, 97, 99, 99, 100, 100, 99, 99, 97, 95, 93, 87, 80, 75, 76, 76, 66, 67, 60,
    78, 79, 82, 86, 83, 87, 87, 83, 82, 81, 79, 76, 70, 60, 62, 63, 48, 63, 50, 39,
    76, 85, 85, 83, 86, 85, 86, 87, 89, 88, 86, 84, 77, 76, 77, 63, 70, 60, 56, 48,
    73, 78, 81, 77, 71, 75, 79, 76, 78, 78, 79, 77, 73, 67, 63, 61, 58, 46, 43, 38,
    77, 86, 85, 82, 84, 83, 80, 67, 77, 77, 75, 78, 69, 73, 64, 68, 52, 51, 32, 14,
    76, 68, 71, 70, 71, 76, 74, 75, 73, 75, 75, 74, 61, 54, 62, 52, 51, 46, 40, 28,
    74, 74, 67, 74, 70, 70, 66, 61, 62, 66, 70, 72, 71, 62, 47, 56, 55, 46, 39, 32,
    61, 62, 70, 75, 77, 76, 75, 74, 69, 63, 61, 64, 58, 56, 56, 51, 34, 42, 32, 20,
    72, 70, 69, 69, 63, 73, 74, 75, 73, 71, 62, 48, 62, 59, 57, 56, 48, 44, 33, 25,
    66, 75, 75, 68, 70, 70, 69, 72, 69, 68, 65, 63, 58, 57, 38, 51, 40, 31, 12, 16,
    70, 74, 74, 75, 75, 76, 76, 76, 75, 75, 60, 62, 65, 59, 53, 51, 36, 36, 24, 15,
    70, 71, 68, 66, 68, 68, 68, 64, 53, 55, 63, 65, 58, 52, 36, 38, 32, 26, 12, 6,
    63, 58, 61, 59, 62, 63, 63, 61, 59, 52, 51, 57, 44, 45, 29, 36, 25, 11, 5, 19,
    61, 67, 65, 66, 66, 66, 64, 62, 59, 55, 55, 53, 49, 47, 49, 36, 25, 27, 7, 12,
    57, 60, 61, 62, 65, 65, 65, 65, 64, 61, 51, 50, 44, 35, 39, 39, 21, 13, 9, 5,
    65, 66, 64, 63, 63, 64, 61, 60, 58, 58, 54, 50, 47, 47, 33, 36, 16, 12, 13, 14,
    63, 66, 66, 67, 67, 66, 64, 62, 59, 59, 55, 40, 42, 29, 36, 34, 6, 15, 8, 20,
    61, 56, 47, 45, 50, 51, 31, 46, 41, 37, 34, 39, 30, 28, 24, 21, 20, 6, 9, 15,
    64, 62, 59, 57, 60, 55, 53, 57, 56, 51, 56, 49, 47, 41, 27, 28, 9, 11, 4, 10,
    59, 58, 60, 59, 58, 57, 56, 53, 46, 37, 43, 30, 38, 34, 23, 14, 18, 12, 11, 12,
    54, 52, 46, 46, 44, 47, 41, 43, 43, 20, 21, 32, 30, 15, 11, 12, 9, 14, 6, 19,
    56, 54, 53, 58, 64, 56, 55, 57, 52, 50, 48, 46, 40, 38, 24, 22, 4, 5, 14, 12,
    44, 54, 47, 49, 44, 34, 43, 45, 42, 30, 40, 38, 33, 25, 20, 15, 5, 3, 9, 5,
    50, 52, 51, 47, 51, 47, 44, 40, 48, 42, 40, 30, 29, 24, 8, 16, 15, 13, 19, 8,
    40, 35, 40, 40, 27, 29, 24, 29, 24, 18, 18, 23, 3, 13, 12, 15, 20, 16, 11, 15,
    44, 44, 44, 46, 47, 48, 50, 49, 44, 38, 18, 32, 27, 11, 14, 12, 16, 3, 15, 1,
    42, 41, 46, 44, 45, 45, 44, 44, 41, 37, 34, 26, 20, 14, 5, 10, 0, 13, 7, 7,
    18, 43, 35, 26, 32, 33, 29, 21, 27, 28, 20, 15, 8, 13, 13, 18, 1, 11, 6, 8,
    30, 25, 37, 31, 16, 27, 31, 27, 15, 14, 22, 10, 9, 9, 4, 0, 18, 14, 10, 12,
    26, 35, 36, 15, 17, 24, 27, 25, 25, 18, 22, 18, 12, 18, 10, 10, 0, 10, 9, 0,
    30, 39, 36, 38, 36, 34, 31, 30, 31, 25, 27, 24, 8, 12, 8, 17, 10, 10, 19, 18,
    23, 28, 20, 29, 21, 25, 21, 26, 16, 17, 22, 10, 15, 10, 9, 18, 4, 13, 11, 10,
    21, 28, 25, 24, 18, 24, 20, 23, 17, 17, 7, 19, 0, 2, 13, 5, 16, 6, 11, 18,
    21, 28, 26, 27, 34, 33, 31, 27, 19, 10, 15, 15, 11, 16, 17, 12, 16, 14, 17, 14,
    30, 35, 35, 32, 20, 21, 21, 16, 0, 23, 16, 14, 11, 0, 15, 11, 13, 9, 12, 7,
    32, 29, 25, 28, 27, 26, 24, 9, 0, 14, 10, 14, 6, 8, 10, 12, 10, 10, 13, 16,
    82, 78, 79, 83, 84, 83, 77, 82, 79, 80, 75, 74, 71, 67, 62, 47, 56, 54, 45, 51,
    62, 72, 69, 69, 50, 44, 60, 58, 58, 54, 56, 58, 60, 61, 60, 58, 57, 54, 45, 47,
    59, 63, 64, 65, 67, 67, 65, 65, 65, 63, 62, 60, 57, 55, 50, 49, 42, 43, 40, 45,
    54, 56, 57, 57, 55, 54, 55, 54, 53, 51, 45, 42, 42, 38, 37, 37, 38, 36, 35, 27,
    20, 33, 25, 22, 33, 34, 33, 30, 14, 26, 26, 26, 16, 26, 25, 21, 27, 29, 22, 15,
    31, 34, 38, 35, 37, 35, 31, 34, 27, 26, 25, 22, 25, 29, 28, 26, 22, 5, 14, 13,
    26, 20, 13, 12, 11, 15, 2, 7, 18, 16, 13, 21, 15, 13, 16, 8, 13, 3, 10, 21,
    18, 14, 22, 12, 11, 8, 6, 16, 16, 14, 7, 14, 9, 15, 15, 15, 15, 9, 7, 17,
    19, 19, 26, 18, 21, 19, 16, 19, 11, 10, 22, 1, 11, 19, 7, 16, 13, 16, 15, 20,
    9, 20, 17, 23, 17, 19, 12, 17, 8, 19, 13, 4, 0, 16, 16, 8, 7, 12, 7, 17,
    10, 22, 20, 10, 16, 15, 15, 14, 17, 7, 16, 7, 0, 14, 13, 12, 14, 10, 12, 13,
    18, 21, 22, 16, 19, 16, 6, 20, 17, 21, 16, 11, 16, 12, 12, 12, 15, 8, 10, 7,
    20, 20, 16, 22, 19, 14, 7, 7, 8, 15, 17, 14, 13, 13, 4, 15, 10, 0, 10, 11,
    22, 22, 23, 13, 19, 19, 4, 15, 16, 1, 17, 7, 12, 14, 18, 6, 12, 14, 0, 10,
    23, 22, 20, 22, 20, 23, 19, 22, 23, 18, 17, 15, 16, 6, 13, 3, 7, 15, 10, 9,
    15, 10, 17, 15, 12, 16, 6, 15, 9, 10, 5, 15, 10, 11, 16, 11, 16, 16, 14, 3,
    10, 23, 26, 17, 22, 20, 17, 12, 16, 18, 16, 12, 12, 8, 14, 13, 20, 16, 10, 20,
    12, 21, 17, 16, 3, 1, 8, 17, 13, 7, 11, 4, 0, 10, 4, 8, 13, 4, 5, 14,
    19, 16, 20, 18, 22, 18, 17, 19, 6, 9, 14, 8, 8, 11, 14, 2, 12, 15, 12, 2,
    17, 23, 17, 18, 20, 19, 18, 4, 13, 10, 3, 17, 14, 6, 17, 11, 9, 12, 9, 13,
    14, 11, 12, 15, 19, 13, 12, 9, 16, 10, 10, 14, 16, 12, 1, 13, 7, 13, 11, 9,
    11, 14, 22, 15, 12, 4, 11, 15, 0, 14, 15, 10, 5, 11, 11, 14, 1, 15, 17, 13,
    19, 9, 2, 16, 15, 1, 14, 11, 17, 6, 0, 21, 14, 2, 13, 14, 7, 15, 11, 11,
    9, 14, 0, 8, 9, 9, 19, 10, 14, 14, 10, 7, 15, 9, 19, 17, 0, 12, 13, 13,
    1, 13, 16, 21, 9, 9, 15, 17, 12, 8, 6, 16, 9, 3, 0, 8, 14, 18, 10, 20,
    13, 19, 13, 7, 8, 22, 19, 13, 14, 15, 9, 12, 10, 14, 2, 18, 15, 4, 18, 6,
    15, 16, 14, 9, 14, 7, 15, 14, 17, 8, 0, 10, 16, 13, 14, 6, 14, 2, 14, 7,
    14, 16, 15, 0, 7, 0, 13, 8, 12, 16, 12, 19, 10, 10, 19, 18, 3, 14, 14, 11,
    18, 16, 13, 15, 14, 11, 14, 13, 14, 14, 12, 1, 10, 15, 19, 13, 16, 6, 0, 6,
    10, 11, 17, 21, 13, 17, 13, 16, 13, 14, 14, 8, 8, 2, 15, 18, 15, 14, 10, 3,
    15, 11, 0, 14, 13, 8, 11, 16, 13, 9, 15, 10, 14, 0, 13, 13, 18, 11, 0, 7,
    14, 13, 5, 20, 16, 13, 15, 17, 16, 4, 14, 18, 3, 3, 12, 12, 13, 8, 5, 15,
    15, 9, 15, 13, 15, 9, 8, 6, 16, 11, 13, 10, 22, 9, 13, 11, 5, 16, 9, 20,
    20, 2, 8, 16, 14, 8, 4, 13, 17, 3, 18, 16, 14, 4, 21, 10, 0, 9, 17, 13,
    7, 11, 7, 16, 20, 11, 17, 5, 14, 15, 0, 15, 10, 8, 16, 14, 17, 10, 0, 10,
    19, 8, 10, 16, 15, 9, 15, 14, 11, 17, 15, 13, 11, 7, 14, 11, 9, 6, 0, 15,
    13, 3, 16, 15, 0, 12, 11, 12, 8, 6, 14, 9, 1, 0, 14, 18, 11, 9, 0, 11,
    10, 14, 12, 7, 16, 0, 8, 20, 10, 13, 17, 12, 13, 5, 19, 17, 9, 13, 16, 17,
    12, 15, 15, 12, 11, 10, 12, 13, 6, 10, 10, 16, 12, 21, 16, 17, 12, 16, 15, 7,
    7, 17, 0, 6, 19, 6, 12, 12, 16, 12, 10, 14, 8, 8, 15, 14, 12, 11, 10, 15,
    89, 86, 85, 91, 91, 91, 85, 89, 87, 88, 83, 82, 79, 75, 68, 61, 60, 60, 26, 55,
    74, 83, 85, 82, 65, 67, 75, 75, 75, 74, 72, 69, 66, 67, 69, 67, 66, 65, 55, 57,
    74, 81, 82, 83, 85, 85, 83, 83, 82, 81, 80, 79, 75, 72, 64, 67, 62, 49, 56, 54,
    74, 78, 78, 79, 76, 76, 77, 77, 76, 75, 71, 68, 65, 62, 63, 62, 52, 40, 51, 46,
    64, 68, 67, 70, 68, 69, 68, 67, 66, 65, 62, 59, 50, 47, 53, 51, 46, 40, 45, 32,
    63, 64, 66, 65, 67, 67, 67, 67, 65, 64, 60, 56, 45, 34, 47, 46, 48, 41, 25, 23,
    55, 51, 57, 60, 57, 59, 59, 59, 59, 57, 55, 52, 48, 48, 44, 46, 29, 39, 17, 23,
    48, 56, 55, 52, 52, 50, 50, 51, 49, 46, 43, 39, 33, 36, 31, 17, 28, 21, 9, 17,
    23, 41, 38, 37, 36, 35, 36, 37, 34, 34, 29, 27, 26, 25, 16, 17, 2, 8, 11, 17,
    28, 32, 39, 38, 36, 37, 36, 33, 34, 29, 24, 14, 27, 27, 24, 0, 11, 14, 7, 14,
    35, 38, 38, 33, 34, 35, 30, 27, 28, 26, 25, 26, 21, 18, 15, 20, 9, 8, 5, 14,
    31, 33, 32, 31, 34, 33, 33, 33, 31, 30, 28, 26, 19, 12, 7, 15, 9, 13, 6, 9,
    30, 30, 28, 26, 20, 8, 22, 20, 22, 18, 17, 18, 6, 10, 3, 15, 17, 15, 8, 11,
    30, 29, 29, 30, 31, 30, 26, 19, 16, 15, 20, 19, 19, 17, 6, 6, 15, 16, 10, 0,
    29, 28, 26, 25, 28, 28, 24, 23, 21, 16, 18, 10, 14, 17, 15, 13, 13, 7, 7, 6,
    27, 25, 24, 22, 17, 11, 23, 15, 17, 14, 7, 14, 13, 18, 6, 11, 12, 14, 6, 13,
    12, 15, 18, 12, 22, 13, 16, 15, 20, 17, 18, 8, 20, 5, 11, 15, 15, 0, 17, 5,
    23, 24, 22, 26, 25, 22, 21, 23, 6, 18, 11, 14, 14, 15, 9, 10, 14, 12, 3, 3,
    26, 27, 27, 27, 27, 22, 21, 20, 19, 20, 17, 17, 9, 7, 14, 19, 17, 11, 20, 1,
    27, 30, 30, 29, 31, 24, 23, 18, 9, 20, 12, 14, 17, 13, 20, 19, 6, 9, 12, 12,
    21, 18, 24, 17, 15, 21, 11, 12, 12, 15, 10, 10, 6, 14, 10, 10, 15, 6, 13, 13,
    18, 22, 20, 17, 24, 19, 17, 13, 4, 18, 14, 17, 8, 15, 10, 11, 12, 2, 4, 4,
    14, 0, 18, 14, 20, 5, 12, 0, 8, 9, 12, 10, 10, 9, 17, 19, 13, 1, 8, 19,
    22, 20, 12, 13, 18, 11, 17, 15, 13, 12, 15, 18, 10, 0, 4, 16, 13, 9, 15, 12,
    10, 15, 10, 10, 11, 3, 0, 12, 12, 4, 12, 8, 2, 6, 16, 7, 9, 13, 11, 11,
    7, 13, 18, 7, 13, 20, 12, 9, 7, 12, 16, 8, 9, 11, 11, 6, 6, 5, 16, 10,
    12, 17, 3, 12, 3, 8, 12, 10, 17, 18, 11, 6, 0, 13, 15, 15, 9, 3, 12, 11,
    6, 8, 16, 11, 13, 10, 0, 10, 6, 15, 7, 12, 6, 1, 4, 16, 15, 17, 21, 6,
    14, 15, 13, 13, 17, 15, 0, 12, 8, 15, 12, 0, 13, 16, 14, 12, 12, 16, 15, 12,
    6, 4, 6, 10, 18, 11, 15, 10, 0, 3, 11, 4, 11, 12, 17, 18, 16, 15, 18, 16,
    17, 8, 13, 10, 15, 13, 12, 9, 4, 18, 0, 9, 15, 9, 7, 10, 9, 7, 3, 0,
    14, 9, 3, 19, 14, 0, 16, 3, 2, 4, 9, 13, 9, 6, 5, 21, 7, 21, 15, 17,
    16, 14, 9, 13, 11, 13, 12, 15, 13, 10, 15, 0, 14, 17, 14, 6, 17, 6, 8, 19,
    7, 10, 11, 9, 8, 11, 8, 20, 9, 11, 0, 16, 5, 0, 0, 8, 18, 19, 13, 15,
    4, 11, 10, 11, 15, 7, 13, 9, 19, 9, 8, 11, 20, 12, 11, 17, 3, 6, 15, 0,
    10, 8, 16, 12, 20, 15, 7, 17, 6, 4, 10, 17, 13, 6, 12, 11, 18, 1, 8, 9,
    15, 17, 3, 10, 7, 6, 15, 5, 8, 18, 12, 4, 11, 13, 13, 20, 14, 11, 10, 5,
    18, 15, 11, 5, 14, 8, 15, 7, 11, 15, 14, 18, 8, 16, 19, 13, 16, 9, 10, 13,
    16, 5, 18, 5, 17, 14, 14, 11, 15, 4, 14, 16, 15, 3, 14, 12, 0, 15, 8, 15,
    10, 15, 16, 8, 1, 8, 7, 0, 16, 6, 19, 16, 18, 2, 8, 13, 18, 13, 13, 13,
    101, 97, 97, 103, 104, 103, 97, 102, 99, 101, 95, 95, 91, 88, 80, 68, 71, 70, 53, 66,
    87, 96, 99, 95, 83, 82, 89, 91, 90, 90, 87, 85, 78, 71, 77, 77, 75, 76, 63, 66,
    89, 96, 97, 98, 99, 100, 97, 97, 96, 95, 93, 91, 88, 83, 72, 78, 75, 59, 66, 65,
    90, 94, 94, 95, 93, 93, 93, 94, 93, 91, 86, 83, 79, 70, 75, 75, 52, 67, 60, 57,
    82, 86, 86, 88, 86, 87, 85, 85, 86, 85, 83, 81, 75, 67, 70, 70, 59, 53, 60, 46,
    84, 86, 87, 87, 88, 88, 90, 88, 87, 85, 81, 77, 64, 55, 61, 64, 64, 62, 45, 37,
    75, 78, 81, 82, 79, 81, 81, 80, 80, 78, 74, 68, 64, 68, 66, 64, 39, 55, 24, 39,
    75, 87, 86, 83, 82, 81, 80, 81, 77, 77, 75, 74, 65, 61, 61, 45, 57, 48, 24, 33,
    59, 79, 76, 75, 75, 73, 73, 70, 68, 63, 59, 57, 48, 56, 47, 53, 42, 33, 20, 22,
    70, 79, 79, 79, 78, 78, 77, 76, 74, 72, 68, 63, 53, 60, 61, 40, 40, 35, 16, 13,
    66, 72, 70, 65, 66, 64, 63, 63, 58, 58, 50, 38, 53, 52, 45, 38, 36, 30, 22, 0,
    64, 68, 70, 70, 72, 72, 72, 71, 71, 68, 62, 61, 59, 52, 41, 40, 32, 11, 0, 5,
    67, 72, 71, 73, 68, 65, 62, 59, 58, 58, 55, 40, 46, 40, 36, 33, 14, 8, 11, 5,
    75, 76, 77, 76, 74, 74, 71, 66, 53, 59, 59, 47, 52, 55, 41, 46, 33, 27, 11, 7,
    68, 65, 64, 66, 64, 64, 62, 60, 54, 48, 53, 51, 46, 39, 33, 27, 0, 22, 10, 12,
    67, 65, 64, 63, 61, 59, 61, 61, 58, 58, 55, 47, 43, 39, 28, 26, 6, 8, 13, 12,
    53, 56, 58, 59, 59, 51, 53, 50, 44, 47, 39, 42, 36, 31, 24, 25, 7, 15, 15, 9,
    56, 57, 56, 53, 53, 54, 54, 53, 49, 48, 45, 39, 28, 27, 21, 15, 8, 13, 7, 12,
    58, 59, 59, 59, 59, 58, 57, 54, 50, 46, 42, 29, 34, 28, 11, 17, 5, 5, 6, 4,
    52, 53, 55, 53, 51, 47, 46, 40, 15, 27, 28, 29, 24, 21, 11, 15, 10, 12, 4, 5,
    54, 57, 57, 51, 44, 40, 41, 41, 35, 33, 17, 27, 6, 21, 5, 7, 15, 13, 9, 12,
    51, 47, 51, 45, 40, 32, 34, 30, 28, 20, 16, 17, 23, 20, 15, 16, 15, 18, 2, 18,
    37, 39, 42, 36, 35, 19, 26, 22, 21, 19, 20, 18, 3, 17, 14, 13, 14, 11, 15, 14,
    36, 42, 45, 45, 41, 40, 39, 35, 27, 22, 23, 27, 18, 18, 12, 12, 12, 16, 15, 19,
    38, 33, 36, 28, 29, 28, 25, 25, 20, 16, 12, 15, 13, 2, 10, 14, 9, 12, 11, 7,
    41, 44, 46, 37, 30, 33, 29, 22, 17, 19, 24, 14, 12, 2, 1, 12, 9, 14, 13, 0,
    30, 34, 35, 32, 21, 21, 23, 19, 17, 15, 16, 15, 10, 13, 6, 13, 18, 12, 5, 1,
    35, 27, 30, 26, 23, 23, 19, 22, 12, 19, 15, 4, 13, 14, 7, 17, 8, 13, 17, 16,
    28, 29, 18, 20, 30, 22, 10, 14, 19, 16, 10, 17, 9, 11, 22, 17, 5, 4, 8, 11,
    23, 26, 34, 19, 22, 19, 23, 22, 11, 7, 11, 13, 10, 6, 14, 13, 6, 19, 8, 12,
    26, 18, 5, 24, 21, 22, 17, 15, 11, 16, 1, 11, 9, 11, 8, 13, 9, 17, 19, 11,
    33, 34, 28, 30, 29, 18, 14, 17, 21, 18, 18, 2, 9, 10, 14, 17, 6, 16, 16, 20,
    27, 29, 21, 27, 23, 24, 23, 20, 0, 1, 10, 12, 11, 15, 16, 5, 10, 17, 16, 20,
    19, 23, 24, 14, 13, 20, 8, 18, 12, 15, 15, 9, 17, 16, 6, 15, 9, 12, 21, 20,
    18, 21, 25, 27, 7, 22, 17, 9, 13, 19, 16, 13, 4, 1, 8, 0, 7, 10, 15, 13,
    8, 18, 21, 19, 20, 13, 11, 13, 10, 15, 9, 17, 12, 14, 13, 6, 15, 15, 4, 11,
    14, 24, 27, 23, 22, 13, 11, 14, 18, 1, 17, 15, 12, 11, 16, 14, 18, 10, 12, 1,
    17, 25, 26, 18, 18, 12, 11, 10, 4, 10, 5, 14, 15, 15, 4, 15, 12, 15, 12, 17,
    15, 17, 21, 10, 7, 9, 8, 16, 14, 13, 11, 11, 10, 15, 15, 6, 7, 11, 18, 14,
    14, 27, 26, 17, 18, 1, 9, 1, 11, 10, 3, 10, 6, 9, 4, 8, 10, 12, 8, 14,
    82, 86, 87, 89, 89, 91, 91, 91, 90, 89, 87, 85, 81, 77, 67, 43, 59, 55, 53, 56,
    65, 69, 67, 67, 62, 62, 62, 61, 57, 55, 53, 55, 56, 55, 50, 51, 52, 45, 45, 41,
    47, 51, 48, 52, 45, 50, 46, 47, 48, 47, 48, 46, 44, 41, 34, 31, 35, 33, 18, 27,
    41, 49, 47, 48, 47, 47, 47, 47, 46, 46, 44, 39, 26, 18, 29, 22, 18, 23, 19, 16,
    36, 37, 25, 34, 33, 32, 36, 38, 35, 30, 22, 29, 23, 13, 12, 18, 23, 10, 6, 12,
    42, 44, 45, 45, 45, 46, 45, 45, 43, 41, 37, 29, 14, 22, 27, 22, 24, 21, 9, 15,
    29, 31, 33, 33, 32, 31, 29, 30, 29, 24, 16, 22, 17, 17, 13, 15, 10, 14, 0, 9,
    28, 28, 31, 33, 32, 28, 29, 29, 27, 25, 21, 21, 16, 10, 17, 11, 7, 6, 13, 13,
    16, 16, 14, 20, 0, 11, 18, 6, 17, 18, 20, 0, 10, 10, 13, 2, 11, 10, 6, 19,
    12, 21, 20, 16, 19, 9, 5, 4, 14, 16, 4, 9, 17, 10, 2, 11, 11, 12, 8, 4,
    23, 18, 22, 15, 19, 7, 17, 18, 13, 16, 10, 13, 18, 14, 21, 8, 15, 14, 12, 10,
    14, 7, 11, 16, 10, 0, 14, 11, 7, 17, 9, 10, 14, 11, 14, 14, 5, 8, 11, 16,
    17, 16, 13, 18, 22, 21, 20, 18, 4, 11, 9, 14, 17, 14, 9, 15, 6, 7, 7, 15,
    14, 10, 11, 16, 20, 13, 18, 4, 8, 17, 15, 15, 12, 12, 19, 8, 11, 20, 15, 19,
    17, 10, 15, 5, 14, 10, 5, 7, 16, 0, 10, 16, 15, 13, 7, 12, 0, 17, 0, 14,
    23, 20, 22, 14, 16, 15, 17, 16, 10, 10, 12, 18, 17, 18, 20, 19, 16, 10, 15, 0,
    13, 13, 1, 2, 8, 12, 16, 19, 14, 16, 3, 10, 6, 13, 9, 11, 14, 12, 16, 14,
    7, 16, 8, 13, 18, 11, 1, 1, 14, 18, 8, 7, 16, 14, 15, 1, 11, 19, 10, 14,
    9, 11, 15, 17, 13, 22, 18, 7, 14, 17, 3, 17, 18, 10, 15, 10, 4, 16, 13, 13,
    9, 13, 15, 10, 14, 14, 4, 13, 12, 11, 14, 13, 19, 13, 13, 10, 13, 6, 7, 9,
    10, 15, 11, 17, 14, 19, 11, 17, 7, 12, 12, 15, 10, 16, 10, 14, 20, 17, 8, 9,
    12, 0, 7, 7, 7, 16, 13, 7, 9, 23, 6, 7, 17, 12, 0, 13, 16, 15, 7, 6,
    19, 14, 0, 11, 10, 14, 8, 11, 7, 10, 12, 15, 12, 20, 13, 11, 12, 12, 12, 0,
    14, 11, 20, 1, 9, 13, 14, 18, 18, 15, 13, 3, 16, 15, 10, 15, 15, 12, 14, 14,
    12, 10, 15, 10, 16, 8, 11, 3, 0, 13, 7, 16, 10, 7, 0, 10, 14, 12, 2, 17,
    12, 11, 0, 14, 15, 7, 14, 13, 15, 11, 16, 13, 6, 16, 11, 0, 0, 3, 4, 16,
    11, 0, 16, 4, 17, 13, 7, 12, 8, 16, 12, 15, 9, 19, 12, 15, 17, 5, 9, 0,
    9, 12, 11, 0, 5, 1, 3, 15, 16, 15, 10, 10, 9, 14, 14, 17, 16, 20, 14, 14,
    2, 22, 5, 11, 11, 12, 15, 16, 5, 14, 8, 14, 17, 14, 7, 10, 9, 13, 10, 8,
    18, 15, 8, 6, 4, 17, 7, 9, 8, 8, 7, 13, 16, 11, 15, 11, 16, 11, 13, 9,
    5, 4, 9, 8, 15, 0, 14, 15, 14, 8, 10, 15, 12, 15, 9, 0, 12, 12, 12, 12,
    18, 5, 21, 14, 4, 13, 18, 0, 17, 4, 11, 6, 16, 14, 16, 16, 6, 21, 15, 9,
    9, 13, 14, 7, 14, 18, 13, 16, 15, 11, 19, 18, 10, 8, 13, 15, 6, 12, 15, 14,
    9, 11, 17, 9, 9, 17, 10, 14, 17, 16, 18, 1, 14, 0, 10, 13, 5, 11, 15, 4,
    16, 4, 16, 19, 15, 7, 15, 11, 14, 14, 9, 0, 14, 14, 12, 15, 17, 4, 10, 14,
    19, 2, 7, 14, 9, 0, 12, 12, 15, 18, 16, 14, 8, 16, 18, 13, 10, 9, 9, 11,
    18, 14, 15, 12, 11, 3, 19, 14, 12, 8, 14, 10, 10, 16, 10, 9, 10, 14, 0, 11,
    95, 98, 99, 103, 102, 104, 105, 104, 103, 102, 100, 98, 94, 90, 81, 67, 68, 66, 65, 66,
    82, 88, 90, 87, 86, 87, 88, 88, 86, 85, 82, 79, 75, 71, 65, 63, 65, 61, 57, 52,
    83, 81, 76, 80, 78, 76, 78, 78, 78, 77, 75, 73, 70, 65, 55, 56, 59, 54, 41, 41,
    71, 78, 76, 76, 77, 76, 76, 76, 74, 72, 72, 68, 59, 58, 59, 55, 48, 44, 35, 22,
    71, 71, 63, 71, 70, 70, 69, 70, 69, 67, 66, 63, 57, 48, 52, 53, 44, 38, 33, 28,
    75, 79, 79, 79, 79, 79, 79, 79, 77, 76, 73, 69, 63, 60, 62, 56, 39, 44, 35, 30,
    60, 63, 58, 61, 59, 59, 61, 62, 64, 64, 63, 61, 52, 36, 44, 39, 33, 27, 19, 6,
    61, 65, 66, 67, 67, 66, 65, 64, 62, 60, 56, 51, 39, 47, 30, 33, 18, 20, 19, 14,
    45, 48, 48, 43, 44, 43, 44, 43, 41, 41, 38, 30, 19, 19, 19, 16, 21, 15, 4, 9,
    40, 39, 30, 36, 34, 25, 27, 33, 32, 33, 28, 23, 9, 23, 12, 13, 10, 0, 17, 21,
    42, 45, 43, 41, 41, 41, 41, 41, 39, 36, 32, 25, 25, 21, 13, 9, 8, 13, 8, 20,
    36, 33, 34, 35, 37, 38, 34, 31, 29, 27, 21, 23, 22, 19, 13, 14, 13, 12, 15, 20,
    45, 48, 47, 46, 44, 46, 38, 39, 37, 33, 30, 23, 13, 17, 12, 3, 18, 17, 14, 16,
    42, 42, 42, 40, 39, 38, 35, 32, 27, 8, 25, 25, 19, 18, 11, 3, 18, 15, 12, 16,
    32, 31, 34, 32, 31, 32, 30, 28, 22, 17, 20, 16, 10, 13, 19, 6, 8, 3, 9, 16,
    16, 24, 21, 28, 30, 23, 21, 17, 27, 24, 8, 19, 20, 11, 7, 12, 0, 20, 16, 7,
    24, 12, 19, 5, 22, 11, 18, 12, 9, 9, 17, 15, 14, 20, 12, 15, 14, 7, 16, 11,
    8, 12, 6, 15, 18, 18, 15, 8, 7, 17, 18, 7, 7, 14, 12, 11, 10, 3, 9, 11,
    13, 19, 19, 25, 7, 18, 8, 12, 13, 7, 6, 6, 17, 16, 6, 5, 14, 15, 19, 8,
    29, 24, 21, 25, 15, 14, 11, 9, 16, 14, 11, 13, 9, 0, 19, 8, 16, 3, 7, 7,
    18, 21, 16, 26, 3, 17, 17, 5, 0, 0, 10, 16, 16, 17, 8, 16, 10, 8, 11, 14,
    19, 22, 19, 1, 12, 6, 12, 2, 5, 10, 3, 18, 9, 8, 9, 0, 18, 7, 11, 15,
    18, 17, 7, 19, 9, 15, 6, 15, 8, 14, 16, 4, 5, 11, 8, 1, 13, 5, 13, 17,
    16, 16, 12, 19, 16, 11, 6, 11, 0, 20, 9, 18, 0, 12, 13, 14, 11, 19, 20, 10,
    17, 15, 18, 13, 13, 16, 19, 8, 0, 6, 8, 2, 10, 2, 6, 16, 16, 13, 17, 11,
    8, 7, 15, 4, 17, 16, 17, 9, 20, 9, 14, 5, 17, 13, 18, 3, 5, 11, 14, 16,
    12, 18, 17, 15, 12, 7, 17, 17, 11, 20, 13, 14, 17, 19, 12, 20, 16, 17, 16, 15,
    18, 17, 8, 10, 4, 14, 11, 11, 6, 18, 19, 17, 16, 21, 17, 17, 1, 17, 15, 15,
    10, 12, 13, 13, 16, 8, 14, 12, 15, 13, 15, 12, 15, 12, 7, 13, 13, 15, 8, 17,
    12, 5, 6, 21, 11, 18, 8, 16, 13, 21, 19, 15, 20, 14, 13, 15, 9, 17, 14, 16,
    10, 16, 8, 15, 15, 1, 20, 17, 15, 16, 9, 13, 17, 13, 17, 14, 9, 12, 14, 0,
    17, 9, 5, 14, 20, 16, 13, 15, 10, 15, 0, 11, 4, 11, 9, 15, 14, 17, 21, 15,
    19, 5, 8, 5, 12, 8, 19, 10, 12, 14, 14, 8, 14, 7, 6, 3, 0, 14, 9, 4,
    105, 109, 111, 114, 114, 115, 116, 115, 114, 113, 112, 110, 105, 100, 90, 75, 77, 75, 73, 74,
    94, 99, 104, 100, 101, 100, 100, 100, 99, 98, 94, 91, 86, 84, 79, 76, 78, 74, 69, 60,
    96, 96, 91, 93, 91, 91, 95, 96, 97, 95, 93, 91, 87, 82, 71, 70, 73, 69, 58, 55,
    83, 88, 87, 88, 89, 89, 87, 87, 85, 82, 80, 80, 69, 69, 70, 67, 58, 54, 47, 29,
    88, 88, 83, 90, 90, 89, 88, 89, 88, 85, 84, 81, 76, 64, 66, 68, 59, 54, 48, 39,
    92, 96, 97, 97, 97, 97, 97, 97, 96, 94, 92, 88, 79, 72, 75, 69, 63, 55, 55, 39,
    76, 82, 77, 78, 77, 74, 73, 76, 80, 80, 78, 75, 66, 54, 62, 52, 52, 38, 37, 3,
    83, 87, 87, 89, 87, 87, 85, 84, 81, 79, 76, 73, 61, 66, 53, 50, 39, 33, 30, 13,
    77, 77, 80, 75, 77, 76, 77, 78, 75, 72, 68, 62, 40, 46, 42, 42, 36, 26, 22, 10,
    74, 79, 79, 78, 77, 77, 77, 77, 73, 68, 65, 65, 65, 61, 43, 40, 28, 13, 12, 8,
    68, 73, 71, 70, 68, 68, 68, 67, 61, 61, 52, 53, 50, 50, 26, 32, 28, 22, 10, 12,
    62, 75, 75, 76, 75, 73, 66, 64, 66, 53, 53, 55, 55, 42, 42, 25, 25, 8, 14, 14,
    78, 80, 76, 74, 79, 74, 75, 72, 68, 61, 37, 38, 48, 43, 39, 31, 21, 17, 3, 10,
    79, 77, 75, 77, 75, 71, 74, 68, 65, 60, 53, 49, 47, 36, 23, 7, 13, 6, 17, 16,
    70, 70, 73, 70, 71, 72, 72, 69, 66, 62, 49, 50, 47, 42, 35, 28, 17, 17, 11, 9,
    47, 65, 65, 67, 64, 56, 53, 57, 56, 53, 44, 47, 26, 23, 12, 13, 16, 19, 16, 15,
    55, 47, 53, 56, 58, 48, 34, 51, 52, 48, 29, 36, 20, 17, 12, 14, 10, 10, 15, 3,
    53, 48, 44, 47, 43, 34, 28, 32, 30, 23, 18, 18, 19, 13, 15, 3, 11, 16, 19, 19,
    52, 45, 44, 43, 45, 22, 29, 33, 31, 27, 20, 5, 20, 18, 13, 16, 5, 16, 18, 12,
    48, 46, 51, 47, 46, 41, 35, 32, 26, 24, 26, 12, 18, 18, 10, 16, 3, 8, 10, 18,
    55, 54, 53, 52, 50, 47, 42, 35, 30, 35, 24, 8, 16, 12, 11, 14, 14, 14, 19, 13,
    48, 51, 49, 49, 46, 45, 42, 36, 29, 7, 26, 16, 1, 14, 14, 4, 8, 10, 10, 18,
    48, 47, 46, 39, 38, 33, 26, 14, 13, 20, 7, 10, 11, 15, 3, 13, 13, 7, 17, 9,
    45, 50, 49, 50, 47, 38, 31, 32, 25, 19, 18, 14, 17, 5, 10, 17, 12, 17, 9, 0,
    44, 39, 41, 32, 30, 36, 33, 28, 17, 27, 18, 12, 11, 12, 10, 10, 7, 12, 15, 20,
    43, 43, 38, 36, 31, 30, 30, 29, 15, 9, 18, 4, 14, 14, 9, 12, 11, 2, 13, 12,
    35, 39, 29, 25, 26, 9, 13, 13, 11, 13, 9, 9, 13, 16, 4, 20, 18, 17, 11, 17,
    21, 34, 24, 28, 16, 18, 20, 15, 17, 19, 5, 18, 9, 18, 11, 19, 1, 19, 17, 18,
    31, 30, 22, 16, 19, 22, 18, 23, 11, 11, 18, 15, 7, 14, 9, 16, 11, 19, 5, 7,
    32, 20, 31, 3, 20, 14, 21, 17, 10, 11, 19, 13, 15, 12, 15, 15, 1, 18, 15, 13,
    20, 31, 26, 24, 10, 16, 16, 12, 6, 0, 17, 7, 6, 11, 9, 2, 18, 19, 11, 18,
    28, 25, 18, 21, 17, 12, 10, 12, 13, 16, 5, 9, 4, 9, 14, 10, 15, 18, 18, 8,
    82, 87, 90, 92, 93, 93, 94, 94, 91, 90, 88, 85, 80, 73, 71, 75, 71, 68, 57, 59,
    55, 51, 48, 51, 53, 57, 55, 56, 55, 55, 51, 45, 45, 46, 43, 40, 41, 29, 34, 26,
    40, 40, 44, 44, 45, 48, 48, 48, 46, 45, 43, 40, 28, 32, 24, 26, 30, 16, 11, 22,
    39, 43, 41, 36, 39, 39, 34, 37, 33, 33, 32, 26, 30, 33, 24, 9, 26, 7, 17, 21,
    35, 32, 36, 33, 33, 31, 31, 30, 17, 26, 21, 24, 22, 13, 22, 17, 25, 11, 18, 12,
    22, 33, 36, 33, 31, 28, 26, 28, 24, 21, 20, 19, 22, 11, 22, 16, 21, 19, 16, 22,
    18, 19, 24, 21, 19, 18, 23, 20, 18, 19, 5, 15, 10, 9, 6, 16, 21, 11, 14, 22,
    9, 19, 15, 19, 19, 19, 21, 15, 18, 18, 14, 18, 18, 6, 15, 18, 19, 16, 18, 5,
    22, 12, 15, 9, 16, 16, 17, 17, 10, 21, 4, 13, 14, 10, 17, 9, 23, 7, 11, 17,
    21, 13, 18, 16, 13, 11, 18, 16, 22, 14, 7, 14, 15, 11, 13, 17, 16, 20, 11, 6,
    19, 3, 8, 16, 18, 12, 15, 11, 2, 7, 13, 18, 0, 12, 14, 19, 23, 6, 3, 13,
    14, 21, 16, 13, 18, 11, 14, 13, 16, 17, 14, 13, 15, 17, 15, 19, 15, 9, 12, 8,
    8, 10, 15, 10, 20, 18, 13, 13, 17, 10, 0, 12, 12, 11, 14, 12, 8, 8, 6, 18,
    18, 16, 10, 13, 16, 16, 17, 18, 13, 14, 19, 6, 2, 12, 5, 9, 19, 15, 17, 14,
    5, 18, 12, 17, 15, 16, 17, 20, 4, 16, 10, 15, 0, 20, 16, 11, 4, 0, 13, 13,
    19, 17, 12, 18, 18, 15, 15, 13, 14, 20, 13, 14, 4, 1, 11, 7, 18, 14, 16, 13,
    19, 15, 7, 15, 12, 20, 19, 9, 17, 19, 15, 16, 18, 16, 12, 22, 9, 17, 10, 12,
    3, 5, 16, 0, 19, 19, 12, 15, 22, 15, 17, 14, 1, 13, 4, 13, 18, 4, 17, 12,
    18, 15, 17, 17, 18, 12, 18, 17, 19, 7, 17, 20, 19, 16, 17, 6, 18, 15, 6, 11,
    9, 13, 10, 19, 15, 15, 14, 9, 11, 7, 9, 5, 18, 5, 23, 10, 11, 21, 17, 18,
    16, 15, 17, 18, 20, 18, 14, 16, 14, 19, 12, 16, 9, 17, 7, 17, 22, 8, 15, 10,
    7, 6, 13, 15, 18, 22, 18, 18, 16, 19, 19, 17, 23, 13, 19, 18, 13, 10, 17, 8,
    14, 21, 12, 19, 16, 21, 10, 21, 16, 11, 15, 17, 25, 15, 16, 10, 15, 14, 3, 17,
    93, 98, 101, 103, 105, 104, 106, 105, 103, 102, 99, 96, 90, 82, 84, 87, 83, 77, 70, 71,
    73, 76, 79, 77, 78, 78, 78, 77, 76, 76, 73, 70, 64, 70, 65, 69, 58, 63, 51, 48,
    65, 72, 74, 74, 75, 75, 74, 72, 70, 68, 58, 55, 63, 60, 62, 54, 56, 51, 36, 31,
    59, 62, 59, 56, 55, 55, 53, 55, 42, 38, 40, 37, 39, 46, 41, 38, 29, 23, 19, 16,
    61, 63, 63, 62, 61, 60, 57, 56, 51, 49, 38, 44, 47, 51, 39, 49, 40, 34, 19, 13,
    54, 50, 48, 49, 46, 47, 43, 43, 40, 35, 40, 35, 32, 40, 22, 31, 24, 23, 20, 18,
    32, 36, 40, 39, 35, 36, 36, 36, 32, 30, 28, 31, 13, 21, 21, 17, 8, 8, 18, 17,
    35, 38, 39, 39, 38, 38, 37, 35, 29, 23, 30, 26, 12, 9, 15, 16, 15, 14, 3, 8,
    17, 20, 20, 22, 18, 22, 8, 10, 16, 17, 17, 12, 20, 15, 3, 13, 15, 9, 12, 0,
    13, 18, 23, 13, 2, 21, 18, 19, 16, 17, 18, 14, 11, 22, 2, 15, 10, 9, 14, 19,
    21, 6, 20, 16, 17, 20, 24, 19, 25, 24, 13, 20, 20, 0, 7, 7, 9, 10, 18, 18,
    16, 3, 9, 11, 20, 11, 0, 9, 4, 4, 17, 17, 13, 12, 11, 9, 12, 14, 11, 18,
    26, 19, 17, 19, 16, 6, 19, 14, 10, 14, 0, 20, 3, 12, 17, 20, 10, 10, 15, 0,
    23, 20, 16, 10, 20, 4, 17, 17, 17, 1, 3, 14, 1, 12, 22, 11, 13, 13, 20, 8,
    12, 10, 9, 17, 19, 8, 12, 16, 16, 16, 17, 19, 10, 20, 15, 15, 16, 12, 5, 19,
    16, 17, 20, 15, 19, 15, 12, 16, 21, 12, 14, 19, 6, 17, 12, 15, 7, 11, 14, 10,
    0, 26, 24, 19, 16, 9, 10, 16, 18, 5, 21, 13, 14, 16, 16, 14, 14, 14, 13, 7,
    22, 3, 6, 18, 18, 12, 19, 16, 20, 8, 17, 4, 6, 12, 16, 13, 2, 11, 14, 19,
    16, 22, 20, 16, 20, 18, 14, 13, 5, 13, 15, 10, 11, 17, 12, 21, 9, 14, 1, 13,
    4, 8, 23, 14, 16, 16, 11, 12, 2, 18, 6, 16, 12, 22, 17, 9, 20, 1, 0, 5,
    0, 8, 15, 14, 9, 15, 8, 0, 16, 16, 16, 18, 16, 13, 4, 19, 16, 11, 13, 4,
    14, 8, 16, 5, 5, 18, 14, 11, 19, 11, 12, 20, 20, 20, 18, 14, 14, 10, 14, 3,
    12, 3, 14, 10, 17, 16, 17, 17, 13, 12, 12, 1, 8, 16, 17, 14, 12, 8, 18, 21,
    11, 17, 13, 8, 12, 20, 15, 11, 13, 9, 12, 7, 18, 12, 8, 5, 7, 16, 16, 15,
    12, 14, 16, 12, 18, 9, 18, 18, 13, 16, 16, 17, 13, 8, 10, 14, 21, 15, 18, 16,
    22, 15, 16, 12, 19, 12, 19, 4, 16, 10, 14, 5, 3, 16, 6, 4, 9, 8, 20, 21,
    12, 19, 22, 14, 11, 4, 0, 13, 11, 1, 12, 10, 13, 17, 16, 13, 11, 15, 5, 8,
    11, 6, 17, 19, 16, 13, 16, 16, 18, 11, 4, 16, 21, 16, 15, 13, 12, 17, 14, 8,
    106, 110, 114, 117, 118, 117, 119, 118, 115, 114, 111, 108, 100, 84, 99, 99, 93, 85, 81, 81,
    89, 91, 95, 92, 95, 92, 91, 92, 91, 90, 89, 85, 82, 88, 80, 83, 75, 71, 69, 63,
    87, 94, 97, 97, 98, 98, 98, 97, 96, 93, 85, 82, 85, 82, 76, 63, 70, 66, 52, 34,
    83, 91, 89, 87, 87, 85, 86, 85, 78, 77, 66, 70, 63, 70, 59, 61, 53, 48, 38, 21,
    87, 91, 93, 92, 93, 91, 89, 88, 84, 80, 76, 79, 77, 68, 57, 71, 60, 44, 31, 21,
    85, 85, 85, 84, 81, 79, 72, 75, 67, 66, 71, 72, 51, 65, 57, 58, 31, 35, 25, 5,
    64, 69, 71, 69, 68, 62, 64, 65, 66, 64, 56, 53, 47, 49, 51, 38, 24, 24, 1, 8,
    81, 83, 82, 82, 83, 81, 79, 77, 61, 65, 60, 61, 61, 59, 50, 51, 32, 25, 9, 6,
    67, 61, 69, 66, 64, 65, 63, 63, 60, 58, 52, 44, 39, 42, 36, 30, 16, 17, 19, 18,
    57, 59, 54, 52, 51, 48, 53, 57, 50, 50, 50, 43, 40, 38, 20, 27, 9, 17, 14, 17,
    69, 71, 71, 70, 69, 68, 66, 63, 59, 54, 47, 44, 46, 49, 30, 29, 17, 14, 14, 10,
    58, 61, 56, 47, 56, 56, 43, 49, 43, 42, 38, 44, 41, 44, 16, 12, 5, 19, 10, 10,
    68, 68, 66, 64, 53, 51, 56, 56, 56, 52, 43, 32, 37, 43, 21, 19, 18, 11, 14, 18,
    54, 59, 60, 61, 60, 58, 53, 38, 36, 39, 47, 43, 38, 42, 24, 10, 18, 9, 16, 16,
    45, 50, 49, 48, 50, 46, 38, 42, 41, 32, 26, 22, 16, 41, 20, 8, 17, 17, 17, 12,
    53, 56, 54, 52, 52, 51, 45, 42, 45, 37, 31, 31, 27, 41, 6, 20, 5, 11, 7, 13,
    25, 31, 16, 33, 30, 22, 29, 34, 34, 28, 6, 16, 11, 40, 10, 12, 12, 18, 19, 16,
    21, 31, 14, 25, 32, 22, 21, 16, 16, 24, 10, 13, 18, 40, 11, 11, 19, 11, 8, 15,
    29, 25, 32, 29, 22, 23, 17, 5, 8, 23, 18, 13, 17, 40, 14, 7, 13, 1, 12, 11,
    13, 24, 34, 24, 23, 12, 16, 18, 6, 9, 15, 12, 14, 40, 2, 14, 21, 16, 14, 15,
    25, 30, 15, 21, 21, 14, 20, 10, 13, 11, 9, 15, 5, 39, 8, 18, 12, 15, 12, 17,
    18, 21, 16, 16, 11, 21, 16, 16, 19, 20, 10, 13, 21, 39, 7, 4, 18, 16, 11, 16,
    22, 14, 22, 13, 20, 21, 19, 17, 10, 17, 15, 21, 15, 39, 14, 17, 13, 12, 17, 17,
    21, 13, 23, 18, 18, 17, 11, 12, 16, 9, 10, 10, 8, 39, 10, 4, 9, 5, 1, 15,
    25, 20, 18, 8, 23, 22, 4, 18, 13, 11, 16, 15, 7, 38, 15, 17, 20, 16, 18, 18,
    12, 17, 17, 17, 18, 18, 22, 20, 9, 20, 14, 0, 1, 38, 11, 4, 12, 20, 21, 9,
    85, 88, 91, 93, 93, 93, 92, 90, 90, 88, 82, 78, 77, 75, 64, 59, 51, 70, 54, 60,
    52, 48, 50, 55, 51, 50, 50, 48, 47, 45, 48, 47, 45, 43, 34, 32, 32, 37, 24, 30,
    41, 47, 31, 20, 37, 36, 34, 28, 19, 25, 30, 30, 30, 21, 29, 21, 15, 13, 17, 4,
    40, 35, 33, 36, 39, 40, 39, 39, 32, 27, 24, 28, 28, 24, 18, 23, 16, 17, 16, 12,
    41, 36, 35, 29, 28, 26, 22, 30, 29, 28, 28, 18, 23, 19, 23, 18, 16, 18, 13, 14,
    16, 27, 27, 22, 26, 25, 22, 24, 23, 24, 22, 24, 20, 9, 18, 18, 13, 15, 14, 12,
    23, 27, 18, 26, 24, 24, 20, 7, 18, 23, 11, 20, 15, 16, 18, 16, 15, 10, 12, 18,
    13, 13, 17, 21, 12, 18, 12, 0, 16, 18, 20, 17, 18, 10, 11, 8, 12, 12, 16, 19,
    20, 12, 18, 12, 9, 14, 10, 15, 14, 16, 9, 1, 0, 10, 13, 8, 16, 12, 15, 19,
    8, 13, 15, 13, 18, 21, 12, 16, 14, 23, 17, 16, 23, 15, 11, 10, 6, 11, 20, 8,
    14, 13, 14, 15, 11, 11, 17, 21, 12, 12, 13, 8, 17, 13, 6, 14, 8, 21, 16, 7,
    16, 12, 21, 23, 11, 22, 15, 22, 13, 4, 18, 20, 16, 15, 9, 20, 14, 12, 6, 8,
    15, 13, 1, 2, 20, 21, 17, 6, 16, 8, 12, 17, 13, 20, 5, 18, 6, 16, 8, 16,
    21, 23, 12, 18, 11, 15, 6, 20, 11, 12, 9, 12, 11, 15, 16, 17, 18, 8, 1, 15,
    19, 18, 14, 18, 16, 13, 21, 12, 14, 7, 9, 16, 14, 15, 17, 15, 11, 12, 20, 16,
    18, 16, 21, 17, 16, 15, 18, 7, 11, 19, 14, 16, 17, 14, 18, 0, 13, 20, 21, 20,
    13, 15, 14, 17, 10, 18, 12, 5, 17, 22, 14, 11, 18, 4, 15, 10, 23, 15, 16, 12,
    20, 15, 19, 7, 12, 11, 1, 20, 12, 18, 12, 15, 10, 22, 12, 18, 17, 8, 18, 16,
    10, 12, 7, 8, 15, 7, 10, 6, 17, 0, 19, 8, 5, 12, 15, 7, 11, 18, 16, 13,
    3, 11, 17, 19, 13, 11, 8, 11, 9, 19, 17, 8, 15, 18, 15, 18, 15, 5, 17, 16,
    8, 13, 18, 11, 13, 8, 11, 6, 19, 14, 18, 13, 14, 19, 10, 19, 11, 17, 9, 18,
    14, 18, 15, 14, 12, 18, 16, 10, 20, 15, 0, 13, 14, 18, 3, 15, 10, 13, 17, 18,
    99, 102, 105, 107, 107, 106, 106, 105, 104, 102, 96, 90, 90, 89, 80, 74, 70, 82, 68, 70,
    77, 80, 81, 83, 82, 83, 84, 82, 81, 80, 72, 73, 75, 63, 67, 64, 63, 64, 42, 41,
    75, 66, 63, 63, 72, 72, 64, 67, 64, 58, 61, 60, 56, 49, 58, 52, 41, 34, 22, 18,
    67, 57, 58, 61, 63, 63, 63, 62, 57, 48, 53, 48, 47, 46, 41, 41, 17, 23, 22, 13,
    65, 63, 59, 55, 57, 57, 55, 54, 54, 47, 50, 49, 31, 46, 41, 22, 17, 21, 8, 21,
    55, 59, 61, 60, 59, 58, 58, 57, 47, 47, 48, 40, 42, 29, 32, 18, 21, 16, 8, 4,
    55, 54, 55, 56, 53, 53, 49, 46, 42, 36, 38, 38, 26, 30, 24, 18, 13, 14, 10, 1,
    34, 44, 41, 40, 38, 42, 28, 30, 32, 27, 26, 30, 18, 24, 20, 15, 14, 6, 14, 14,
    38, 18, 30, 21, 28, 23, 26, 23, 19, 24, 14, 18, 23, 12, 15, 18, 21, 17, 12, 9,
    23, 27, 16, 24, 19, 17, 18, 22, 16, 16, 12, 18, 16, 18, 9, 17, 16, 19, 19, 15,
    20, 22, 15, 19, 11, 18, 20, 14, 14, 19, 17, 9, 19, 8, 10, 13, 16, 19, 12, 15,
    21, 26, 10, 17, 17, 2, 8, 21, 21, 21, 6, 16, 14, 13, 19, 15, 14, 18, 8, 0,
    22, 26, 27, 25, 16, 17, 20, 14, 19, 19, 5, 23, 14, 11, 19, 18, 15, 17, 9, 15,
    19, 15, 21, 20, 20, 12, 14, 12, 16, 16, 13, 12, 20, 21, 14, 18, 18, 7, 16, 12,
    19, 19, 22, 17, 25, 18, 10, 19, 20, 11, 22, 8, 15, 21, 14, 15, 19, 18, 17, 14,
    14, 20, 17, 14, 9, 21, 10, 16, 19, 16, 19, 16, 19, 6, 15, 16, 17, 18, 10, 16,
    22, 19, 23, 17, 19, 17, 4, 17, 0, 8, 21, 3, 14, 18, 23, 1, 17, 0, 20, 9,
    14, 14, 13, 8, 21, 10, 17, 16, 11, 15, 15, 12, 15, 17, 17, 14, 18, 21, 15, 20,
    12, 13, 19, 17, 10, 16, 11, 18, 15, 4, 11, 8, 17, 14, 13, 17, 10, 21, 16, 18,
    17, 17, 19, 18, 17, 15, 13, 14, 16, 20, 4, 16, 18, 14, 17, 10, 7, 11, 12, 18,
    20, 20, 13, 19, 9, 17, 21, 6, 20, 9, 15, 19, 20, 10, 15, 22, 14, 16, 16, 20,
    17, 21, 14, 5, 11, 0, 6, 23, 21, 5, 10, 21, 19, 0, 20, 17, 24, 13, 8, 22,
    108, 111, 115, 116, 116, 116, 115, 113, 112, 110, 104, 99, 97, 97, 89, 87, 80, 88, 80, 75,
    87, 92, 92, 94, 94, 95, 95, 93, 91, 89, 82, 84, 83, 77, 80, 76, 75, 71, 58, 50,
    89, 81, 70, 72, 83, 84, 74, 77, 68, 73, 72, 70, 72, 67, 68, 62, 45, 46, 30, 24,
    83, 78, 77, 80, 81, 80, 79, 78, 58, 70, 62, 64, 53, 63, 56, 55, 39, 37, 17, 22,
    83, 82, 77, 72, 73, 70, 67, 59, 60, 69, 65, 60, 56, 62, 48, 49, 40, 28, 22, 18,
    71, 76, 79, 79, 76, 76, 71, 70, 65, 69, 62, 56, 59, 48, 48, 36, 28, 24, 24, 18,
    75, 75, 76, 77, 75, 75, 72, 68, 61, 64, 61, 53, 56, 51, 49, 32, 29, 23, 9, 12,
    62, 63, 66, 67, 63, 62, 54, 61, 55, 51, 52, 50, 42, 26, 22, 19, 21, 6, 14, 14,
    69, 66, 66, 64, 62, 62, 61, 63, 58, 55, 53, 47, 37, 36, 32, 25, 15, 17, 15, 18,
    52, 51, 57, 48, 55, 51, 41, 43, 45, 37, 33, 23, 11, 18, 13, 14, 7, 18, 7, 16,
    54, 46, 48, 50, 48, 44, 29, 43, 38, 21, 22, 18, 23, 23, 10, 11, 20, 22, 9, 18,
    49, 49, 43, 50, 45, 42, 47, 46, 35, 39, 25, 28, 22, 19, 13, 14, 8, 15, 10, 6,
    43, 46, 47, 51, 50, 50, 41, 27, 36, 29, 28, 20, 17, 23, 15, 18, 13, 19, 5, 6,
    44, 46, 45, 46, 44, 41, 36, 34, 21, 16, 19, 15, 13, 21, 15, 20, 17, 15, 18, 12,
    38, 31, 36, 34, 33, 23, 23, 13, 20, 11, 21, 18, 17, 19, 15, 18, 17, 4, 3, 7,
    34, 26, 25, 16, 15, 16, 17, 12, 9, 17, 19, 14, 3, 16, 17, 0, 22, 9, 15, 19,
    15, 29, 22, 25, 12, 20, 19, 13, 16, 20, 14, 15, 21, 0, 17, 16, 6, 10, 2, 10,
    23, 27, 14, 21, 23, 13, 20, 24, 16, 12, 15, 13, 18, 18, 13, 12, 0, 19, 22, 11,
    20, 19, 24, 17, 11, 16, 20, 21, 21, 10, 21, 21, 12, 13, 2, 19, 19, 19, 18, 10,
    14, 28, 21, 21, 19, 18, 18, 9, 12, 3, 5, 14, 18, 18, 18, 6, 4, 18, 16, 11,
    20, 20, 12, 14, 17, 8, 20, 17, 13, 11, 10, 14, 7, 7, 16, 19, 9, 9, 17, 17,
    87, 88, 85, 85, 87, 86, 86, 85, 83, 78, 68, 71, 77, 76, 59, 68, 62, 58, 55, 40,
    51, 48, 45, 51, 35, 46, 44, 45, 28, 40, 45, 41, 39, 39, 35, 24, 27, 16, 22, 21,
    39, 35, 39, 38, 34, 32, 41, 38, 33, 36, 34, 30, 15, 28, 24, 16, 18, 22, 21, 7,
    43, 43, 42, 40, 39, 38, 37, 33, 24, 15, 17, 26, 24, 22, 21, 23, 19, 23, 18, 13,
    24, 25, 25, 12, 27, 20, 13, 22, 17, 23, 11, 15, 19, 11, 15, 19, 18, 13, 13, 9,
    14, 23, 24, 16, 24, 21, 23, 12, 18, 21, 26, 17, 16, 3, 15, 11, 16, 13, 9, 20,
    17, 29, 18, 22, 9, 11, 15, 17, 21, 20, 16, 16, 14, 16, 15, 8, 16, 12, 13, 15,
    19, 17, 18, 26, 25, 8, 13, 9, 16, 12, 8, 11, 7, 16, 15, 9, 17, 18, 19, 16,
    13, 13, 20, 11, 20, 19, 13, 19, 10, 13, 7, 19, 11, 17, 19, 16, 16, 21, 12, 20,
    11, 14, 19, 15, 21, 15, 20, 10, 15, 18, 10, 16, 15, 13, 19, 9, 18, 13, 7, 18,
    19, 12, 12, 17, 6, 18, 22, 20, 9, 22, 16, 16, 19, 7, 19, 9, 14, 18, 21, 19,
    14, 16, 17, 17, 23, 17, 15, 18, 4, 15, 16, 6, 15, 18, 9, 13, 16, 15, 14, 3,
    19, 18, 11, 12, 14, 22, 17, 9, 10, 10, 18, 23, 1, 18, 16, 8, 16, 7, 13, 21,
    15, 12, 1, 22, 14, 16, 15, 22, 18, 19, 20, 19, 25, 14, 18, 13, 22, 20, 18, 18,
    15, 13, 25, 13, 18, 18, 18, 13, 15, 17, 15, 9, 13, 14, 7, 13, 18, 12, 16, 10,
    18, 17, 11, 15, 22, 18, 18, 11, 14, 16, 9, 22, 6, 14, 11, 11, 16, 24, 6, 13,
    17, 16, 17, 16, 16, 20, 12, 13, 20, 21, 2, 20, 14, 18, 18, 16, 2, 14, 19, 19,
    73, 98, 95, 94, 96, 95, 95, 95, 92, 88, 79, 81, 87, 85, 66, 76, 71, 67, 65, 53,
    63, 60, 66, 68, 62, 64, 58, 63, 54, 39, 50, 49, 46, 44, 40, 36, 30, 22, 16, 24,
    54, 42, 52, 39, 39, 42, 48, 42, 37, 42, 43, 23, 42, 38, 30, 24, 20, 18, 14, 15,
    51, 60, 56, 55, 53, 49, 49, 45, 45, 44, 44, 41, 32, 26, 27, 26, 22, 22, 8, 14,
    33, 29, 20, 31, 29, 13, 28, 36, 32, 27, 30, 11, 24, 18, 21, 12, 17, 19, 12, 16,
    20, 24, 30, 22, 22, 21, 18, 23, 24, 12, 16, 15, 15, 15, 13, 17, 16, 10, 12, 21,
    15, 25, 25, 21, 19, 16, 22, 24, 16, 15, 16, 17, 15, 16, 16, 18, 18, 19, 18, 12,
    12, 22, 21, 11, 24, 15, 17, 18, 6, 14, 9, 17, 18, 16, 11, 15, 13, 10, 14, 10,
    19, 18, 22, 7, 17, 18, 6, 21, 22, 10, 21, 14, 15, 10, 17, 14, 23, 17, 16, 16,
    14, 16, 12, 22, 24, 21, 20, 13, 17, 19, 13, 14, 15, 8, 9, 18, 5, 6, 11, 21,
    25, 21, 24, 12, 0, 20, 18, 13, 19, 22, 20, 22, 18, 19, 19, 16, 10, 15, 11, 16,
    25, 17, 21, 20, 17, 19, 23, 10, 18, 23, 19, 16, 14, 7, 19, 11, 7, 19, 18, 5,
    11, 12, 20, 11, 18, 13, 15, 15, 19, 10, 19, 20, 19, 15, 5, 18, 17, 19, 21, 15,
    16, 13, 19, 12, 19, 20, 21, 12, 22, 12, 10, 18, 20, 18, 24, 13, 13, 16, 12, 13,
    14, 16, 8, 17, 12, 20, 23, 19, 9, 9, 14, 16, 14, 16, 23, 21, 18, 13, 0, 20,
    18, 12, 18, 11, 16, 15, 19, 19, 19, 15, 16, 8, 12, 16, 18, 10, 10, 18, 23, 18,
    20, 4, 10, 21, 6, 14, 20, 17, 20, 20, 6, 21, 13, 16, 19, 23, 17, 14, 5, 6,
    59, 105, 113, 108, 108, 109, 109, 108, 106, 101, 84, 96, 101, 97, 85, 88, 83, 80, 73, 64,
    35, 87, 79, 83, 93, 87, 82, 85, 78, 81, 74, 84, 64, 69, 69, 60, 57, 52, 42, 35,
    26, 79, 71, 81, 67, 75, 74, 65, 65, 72, 57, 68, 59, 44, 56, 47, 34, 29, 19, 16,
    19, 84, 82, 78, 72, 72, 71, 69, 72, 72, 60, 53, 46, 39, 38, 35, 25, 22, 15, 18,
    20, 65, 67, 67, 70, 66, 65, 64, 63, 60, 57, 49, 44, 41, 23, 14, 16, 22, 13, 11,
    9, 59, 44, 58, 62, 60, 59, 57, 57, 53, 38, 38, 32, 19, 12, 22, 0, 5, 13, 19,
    19, 66, 65, 63, 54, 51, 40, 58, 56, 50, 47, 47, 35, 14, 19, 10, 20, 18, 19, 20,
    13, 60, 60, 50, 34, 38, 44, 36, 45, 42, 35, 28, 22, 17, 18, 2, 18, 12, 20, 13,
    10, 55, 55, 56, 51, 49, 45, 42, 35, 38, 32, 35, 25, 20, 20, 16, 21, 16, 11, 18,
    19, 44, 43, 48, 45, 40, 31, 16, 27, 19, 11, 10, 0, 19, 4, 10, 5, 11, 7, 4,
    3, 33, 40, 38, 35, 34, 22, 31, 24, 22, 24, 13, 13, 12, 14, 23, 12, 19, 22, 18,
    13, 35, 39, 41, 35, 31, 28, 28, 23, 22, 19, 14, 18, 18, 19, 21, 17, 20, 14, 22,
    20, 32, 38, 34, 27, 21, 17, 9, 8, 15, 11, 18, 21, 13, 11, 25, 16, 12, 13, 15,
    7, 32, 31, 28, 36, 33, 16, 25, 11, 17, 14, 10, 15, 19, 21, 18, 16, 12, 18, 17,
    20, 21, 15, 19, 24, 21, 23, 22, 13, 20, 7, 10, 25, 17, 21, 21, 22, 19, 21, 9,
    14, 25, 22, 20, 14, 12, 8, 13, 15, 23, 14, 23, 7, 10, 15, 19, 19, 14, 10, 7,
    6, 27, 28, 24, 26, 11, 21, 16, 18, 13, 12, 15, 24, 11, 13, 18, 14, 12, 13, 13,
    78, 77, 78, 78, 72, 63, 73, 72, 72, 72, 69, 67, 67, 68, 62, 61, 54, 35, 41, 38,
    46, 47, 49, 53, 53, 52, 52, 51, 49, 45, 38, 42, 42, 36, 24, 29, 19, 19, 23, 12,
    32, 37, 31, 26, 36, 27, 29, 28, 27, 19, 36, 34, 31, 21, 21, 26, 20, 17, 17, 14,
    26, 28, 25, 23, 19, 20, 25, 24, 17, 21, 13, 23, 11, 21, 19, 16, 13, 13, 16, 20,
    18, 22, 17, 21, 6, 16, 14, 11, 16, 11, 3, 18, 8, 20, 15, 19, 9, 26, 21, 15,
    16, 16, 21, 15, 19, 13, 17, 7, 13, 20, 11, 11, 17, 11, 18, 14, 13, 20, 17, 10,
    23, 23, 19, 18, 21, 13, 8, 13, 22, 6, 20, 20, 19, 14, 6, 10, 18, 8, 15, 19,
    23, 20, 11, 14, 8, 16, 16, 13, 20, 9, 23, 18, 15, 17, 7, 13, 14, 11, 13, 14,
    19, 15, 23, 19, 18, 23, 18, 26, 15, 16, 19, 17, 14, 6, 16, 19, 8, 23, 18, 18,
    9, 14, 16, 10, 19, 7, 13, 16, 6, 21, 19, 18, 16, 19, 22, 19, 7, 7, 19, 22,
    10, 7, 10, 20, 13, 12, 16, 14, 13, 23, 15, 15, 8, 21, 14, 16, 7, 19, 21, 7,
    17, 5, 18, 12, 20, 16, 22, 23, 17, 7, 19, 6, 13, 23, 20, 18, 13, 18, 21, 21,
    11, 10, 18, 9, 16, 9, 8, 20, 21, 16, 14, 21, 8, 18, 17, 12, 17, 15, 20, 11,
    94, 92, 91, 93, 88, 80, 77, 75, 75, 72, 73, 72, 77, 76, 68, 70, 64, 47, 50, 43,
    53, 59, 50, 59, 60, 55, 52, 50, 48, 54, 54, 41, 47, 49, 41, 35, 34, 26, 17, 24,
    59, 51, 53, 55, 55, 52, 56, 55, 50, 51, 53, 45, 41, 41, 18, 22, 7, 0, 20, 20,
    39, 41, 41, 37, 41, 41, 39, 39, 36, 33, 31, 9, 24, 6, 19, 9, 12, 20, 6, 19,
    31, 33, 33, 25, 24, 30, 30, 23, 16, 13, 13, 19, 17, 16, 20, 12, 21, 17, 13, 9,
    26, 20, 21, 20, 24, 18, 20, 16, 15, 17, 19, 20, 14, 8, 21, 15, 20, 14, 4, 11,
    24, 22, 16, 20, 23, 17, 17, 22, 20, 16, 16, 20, 2, 15, 8, 19, 21, 21, 17, 14,
    23, 26, 13, 12, 17, 19, 18, 21, 13, 20, 20, 13, 14, 8, 21, 9, 22, 14, 4, 14,
    23, 14, 16, 18, 22, 16, 10, 13, 17, 22, 12, 19, 18, 22, 14, 16, 21, 19, 9, 15,
    20, 22, 19, 22, 17, 13, 19, 17, 19, 22, 15, 19, 16, 20, 10, 18, 11, 21, 21, 12,
    16, 16, 19, 16, 11, 13, 20, 9, 15, 18, 21, 17, 17, 19, 17, 21, 12, 10, 11, 24,
    21, 14, 15, 15, 14, 14, 18, 14, 22, 21, 13, 18, 18, 19, 14, 16, 19, 21, 18, 9,
    23, 21, 16, 23, 7, 19, 20, 19, 21, 18, 11, 18, 15, 10, 18, 20, 6, 17, 12, 23,
    54, 103, 98, 103, 101, 100, 92, 89, 91, 89, 77, 86, 87, 85, 80, 78, 75, 66, 52, 51,
    32, 88, 87, 86, 86, 86, 84, 86, 85, 80, 71, 68, 78, 70, 67, 63, 54, 41, 40, 30,
    23, 80, 69, 69, 74, 70, 71, 67, 57, 63, 62, 58, 50, 51, 43, 44, 34, 27, 25, 24,
    19, 65, 58, 65, 66, 66, 66, 59, 56, 45, 57, 51, 21, 42, 30, 29, 16, 16, 14, 20,
    24, 58, 62, 61, 55, 46, 56, 51, 46, 49, 50, 47, 42, 29, 27, 23, 10, 22, 24, 18,
    21, 51, 51, 32, 41, 36, 33, 31, 37, 36, 29, 25, 17, 20, 9, 20, 17, 12, 11, 18,
    16, 55, 52, 50, 41, 42, 37, 42, 28, 29, 21, 21, 6, 10, 11, 18, 16, 17, 14, 16,
    20, 38, 44, 43, 40, 42, 35, 36, 25, 32, 22, 23, 20, 8, 12, 16, 10, 17, 18, 20,
    10, 48, 44, 39, 34, 21, 20, 26, 24, 27, 21, 21, 19, 13, 21, 17, 15, 19, 17, 16,
    22, 34, 36, 30, 26, 27, 25, 13, 16, 22, 18, 17, 20, 18, 13, 21, 18, 9, 17, 18,
    19, 18, 27, 21, 25, 20, 14, 13, 1, 10, 17, 20, 11, 21, 1, 15, 17, 19, 8, 26,
    12, 28, 29, 23, 22, 16, 20, 24, 18, 10, 1, 21, 17, 17, 17, 8, 21, 12, 16, 18,
    12, 27, 19, 19, 17, 16, 21, 15, 10, 20, 20, 17, 12, 20, 15, 20, 20, 24, 15, 19,
    67, 70, 78, 81, 81, 78, 78, 78, 73, 71, 68, 63, 66, 67, 60, 56, 51, 50, 29, 37,
    47, 52, 53, 56, 56, 55, 54, 53, 47, 40, 40, 41, 27, 30, 27, 25, 7, 16, 22, 18,
    22, 33, 35, 36, 34, 37, 36, 35, 24, 17, 22, 18, 21, 23, 7, 16, 16, 19, 8, 15,
    24, 26, 23, 20, 18, 18, 22, 24, 17, 17, 16, 19, 21, 13, 12, 16, 21, 24, 0, 12,
    18, 20, 15, 26, 21, 22, 22, 16, 21, 11, 15, 17, 18, 17, 25, 24, 23, 18, 9, 12,
    21, 7, 17, 16, 15, 16, 17, 20, 18, 13, 20, 16, 19, 20, 14, 8, 11, 18, 15, 18,
    14, 13, 19, 18, 20, 19, 7, 15, 23, 21, 19, 18, 15, 16, 17, 18, 22, 15, 16, 13,
    16, 26, 23, 21, 23, 9, 14, 22, 12, 16, 17, 23, 14, 16, 15, 13, 18, 21, 19, 15,
    17, 6, 6, 15, 21, 25, 17, 23, 17, 20, 19, 16, 27, 18, 12, 14, 21, 10, 23, 11,
    22, 11, 8, 20, 6, 21, 23, 17, 22, 20, 24, 22, 18, 24, 16, 11, 25, 17, 19, 20,
    21, 14, 20, 22, 19, 26, 14, 18, 16, 12, 19, 24, 19, 24, 12, 20, 17, 23, 16, 21,
    85, 90, 94, 96, 95, 95, 95, 95, 92, 89, 83, 77, 78, 79, 73, 72, 63, 63, 32, 46,
    62, 61, 63, 63, 66, 65, 63, 63, 56, 46, 47, 52, 34, 38, 37, 34, 19, 18, 15, 21,
    38, 48, 49, 49, 44, 43, 43, 41, 31, 31, 38, 35, 18, 30, 27, 22, 21, 17, 19, 23,
    40, 40, 36, 30, 28, 24, 24, 30, 31, 27, 24, 21, 14, 17, 24, 10, 15, 13, 14, 22,
    23, 34, 21, 26, 23, 28, 19, 20, 25, 20, 16, 15, 9, 12, 23, 3, 25, 7, 22, 7,
    23, 19, 18, 20, 25, 16, 16, 19, 26, 20, 21, 18, 11, 19, 23, 21, 19, 17, 18, 22,
    23, 26, 13, 20, 21, 18, 12, 9, 12, 12, 19, 19, 8, 19, 19, 16, 19, 18, 17, 19,
    12, 20, 19, 18, 19, 14, 24, 15, 26, 16, 21, 8, 15, 16, 17, 20, 13, 15, 17, 20,
    21, 17, 13, 18, 20, 17, 19, 23, 17, 22, 24, 1, 23, 14, 11, 12, 17, 16, 12, 12,
    16, 5, 15, 20, 15, 14, 11, 20, 18, 14, 14, 12, 13, 19, 16, 13, 21, 5, 13, 11,
    14, 21, 15, 20, 19, 17, 15, 19, 21, 18, 23, 7, 21, 8, 15, 17, 22, 14, 21, 22,
    102, 107, 110, 112, 111, 111, 111, 111, 108, 105, 98, 91, 94, 93, 89, 84, 77, 76, 57, 57,
    86, 86, 88, 89, 92, 91, 86, 77, 79, 68, 69, 74, 64, 67, 62, 56, 31, 37, 21, 16,
    66, 72, 65, 53, 67, 64, 65, 60, 57, 47, 44, 49, 47, 42, 37, 29, 15, 20, 17, 18,
    63, 64, 60, 37, 47, 52, 57, 55, 52, 49, 47, 47, 42, 24, 25, 18, 22, 13, 20, 16,
    53, 52, 48, 45, 51, 52, 50, 49, 27, 42, 40, 29, 23, 12, 21, 8, 12, 22, 23, 10,
    41, 44, 43, 38, 38, 28, 34, 30, 22, 21, 24, 18, 16, 10, 17, 17, 15, 20, 20, 12,
    46, 43, 40, 29, 21, 30, 24, 28, 25, 23, 22, 11, 15, 16, 15, 18, 14, 16, 13, 18,
    31, 37, 36, 35, 24, 29, 21, 20, 9, 20, 21, 16, 20, 16, 13, 20, 18, 20, 24, 22,
    29, 25, 30, 18, 24, 12, 20, 24, 20, 18, 15, 19, 17, 13, 19, 10, 22, 8, 14, 20,
    24, 28, 20, 18, 21, 16, 19, 2, 19, 13, 11, 21, 19, 20, 17, 25, 15, 20, 12, 14,
    26, 28, 23, 23, 14, 18, 21, 23, 16, 13, 18, 23, 20, 14, 15, 19, 23, 19, 18, 19,
    65, 73, 67, 72, 69, 67, 65, 65, 58, 54, 57, 48, 56, 37, 40, 42, 36, 31, 24, 19,
    45, 45, 43, 42, 43, 40, 42, 41, 43, 42, 30, 36, 23, 15, 23, 8, 23, 21, 19, 22,
    26, 21, 28, 26, 24, 19, 22, 20, 22, 15, 21, 20, 15, 20, 22, 11, 16, 22, 13, 18,
    30, 32, 34, 35, 31, 32, 19, 18, 26, 15, 14, 11, 21, 18, 13, 13, 17, 17, 15, 12,
    21, 25, 24, 22, 5, 12, 19, 14, 21, 20, 17, 20, 8, 18, 12, 24, 18, 17, 17, 10,
    23, 25, 24, 26, 22, 16, 24, 22, 13, 22, 14, 22, 12, 15, 9, 14, 15, 18, 15, 18,
    23, 11, 11, 22, 22, 20, 23, 22, 26, 11, 18, 20, 18, 10, 15, 19, 11, 17, 16, 17,
    15, 22, 15, 19, 17, 20, 18, 25, 21, 22, 20, 17, 20, 21, 26, 19, 22, 18, 20, 20,
    89, 93, 90, 92, 90, 87, 88, 85, 85, 82, 62, 72, 77, 71, 64, 58, 51, 41, 25, 26,
    43, 59, 52, 46, 52, 48, 46, 50, 48, 50, 20, 46, 34, 13, 22, 26, 20, 22, 16, 18,
    27, 36, 33, 37, 28, 31, 33, 31, 32, 21, 19, 20, 16, 17, 15, 20, 13, 23, 10, 13,
    32, 42, 28, 27, 29, 32, 35, 33, 28, 31, 23, 19, 16, 20, 23, 23, 21, 16, 22, 20,
    29, 22, 26, 33, 27, 24, 22, 24, 10, 15, 14, 16, 18, 17, 14, 5, 19, 14, 16, 23,
    10, 22, 20, 13, 19, 21, 25, 20, 21, 23, 13, 9, 17, 17, 15, 20, 20, 21, 19, 10,
    23, 18, 18, 22, 24, 29, 18, 15, 23, 21, 20, 20, 10, 15, 22, 16, 23, 17, 21, 18,
    24, 11, 7, 8, 18, 17, 21, 16, 19, 24, 21, 23, 13, 22, 18, 19, 21, 16, 21, 27,
    105, 107, 106, 106, 105, 104, 103, 101, 101, 97, 77, 91, 91, 86, 77, 70, 64, 54, 46, 40,
    83, 80, 79, 68, 63, 78, 75, 73, 68, 72, 63, 66, 56, 56, 46, 31, 15, 8, 15, 18,
    55, 51, 52, 56, 48, 51, 53, 47, 41, 40, 20, 34, 36, 28, 19, 20, 20, 19, 21, 19,
    56, 53, 50, 40, 47, 54, 54, 49, 28, 50, 39, 40, 35, 30, 19, 26, 25, 28, 16, 21,
    38, 43, 37, 41, 39, 39, 41, 40, 29, 20, 19, 20, 21, 21, 15, 12, 14, 17, 18, 11,
    46, 38, 38, 33, 30, 29, 28, 22, 17, 17, 14, 12, 12, 15, 24, 18, 16, 19, 17, 15,
    31, 38, 25, 27, 13, 21, 20, 19, 12, 15, 19, 24, 17, 13, 17, 20, 17, 18, 21, 16,
    16, 23, 23, 27, 18, 26, 16, 15, 12, 8, 13, 22, 15, 15, 16, 18, 14, 22, 23, 22,
    18, 24, 19, 25, 25, 21, 13, 12, 15, 19, 18, 23, 22, 12, 22, 16, 16, 26, 17, 20,
    60, 58, 51, 66, 50, 61, 47, 51, 45, 56, 52, 50, 39, 48, 35, 36, 27, 31, 28, 25,
    42, 43, 39, 37, 37, 42, 40, 29, 33, 23, 35, 29, 23, 23, 14, 21, 17, 17, 23, 21,
    32, 23, 15, 21, 28, 32, 23, 25, 14, 25, 21, 20, 19, 23, 21, 18, 16, 9, 19, 13,
    15, 18, 26, 24, 20, 24, 23, 18, 22, 16, 17, 20, 4, 20, 24, 18, 12, 11, 18, 12,
    22, 25, 19, 18, 20, 16, 22, 26, 16, 24, 13, 19, 14, 17, 26, 17, 6, 21, 23, 18,
    24, 19, 19, 26, 21, 18, 22, 17, 21, 23, 17, 19, 26, 21, 18, 24, 24, 23, 15, 23,
    28, 18, 20, 29, 17, 22, 20, 16, 19, 22, 23, 19, 21, 15, 20, 11, 19, 21, 19, 21,
    83, 78, 76, 78, 69, 69, 74, 77, 67, 77, 70, 70, 66, 66, 53, 52, 42, 32, 26, 23,
    52, 53, 49, 49, 43, 35, 47, 42, 42, 40, 36, 37, 29, 23, 22, 19, 24, 25, 18, 19,
    37, 39, 33, 34, 28, 33, 28, 27, 27, 27, 12, 24, 26, 19, 23, 20, 17, 18, 20, 14,
    28, 24, 23, 28, 24, 22, 26, 26, 23, 24, 26, 26, 20, 20, 19, 22, 24, 13, 17, 20,
    28, 15, 22, 23, 28, 25, 15, 25, 22, 20, 21, 20, 23, 21, 20, 27, 16, 19, 16, 19,
    8, 19, 22, 25, 21, 25, 16, 21, 20, 20, 22, 26, 26, 19, 21, 14, 23, 23, 13, 16,
    19, 14, 23, 25, 24, 24, 15, 26, 22, 20, 22, 22, 19, 21, 23, 22, 14, 18, 19, 21,
    108, 106, 101, 101, 89, 89, 96, 101, 94, 98, 88, 90, 87, 76, 72, 69, 51, 51, 25, 21,
    81, 73, 80, 81, 70, 77, 73, 64, 58, 60, 61, 52, 42, 46, 35, 28, 21, 20, 19, 15,
    64, 60, 58, 61, 63, 56, 61, 52, 46, 43, 43, 23, 27, 21, 16, 23, 21, 21, 21, 11,
    49, 54, 48, 58, 55, 33, 46, 48, 46, 25, 32, 27, 23, 20, 22, 18, 21, 12, 20, 13,
    39, 43, 47, 37, 38, 29, 35, 32, 28, 20, 10, 16, 17, 12, 23, 13, 20, 17, 22, 22,
    33, 32, 23, 34, 27, 29, 21, 16, 21, 18, 20, 14, 9, 19, 18, 22, 11, 21, 15, 20,
    18, 27, 17, 24, 27, 18, 25, 24, 23, 20, 22, 16, 19, 24, 18, 21, 20, 21, 25, 16,
    61, 71, 70, 72, 63, 58, 56, 54, 58, 50, 46, 50, 46, 34, 37, 28, 25, 26, 26, 25,
    30, 40, 37, 38, 33, 31, 34, 31, 27, 30, 22, 22, 19, 25, 21, 21, 14, 17, 20, 25,
    25, 30, 22, 26, 28, 24, 28, 24, 14, 20, 19, 19, 15, 23, 14, 18, 16, 16, 20, 18,
    26, 19, 25, 22, 21, 20, 27, 16, 22, 15, 19, 18, 14, 22, 22, 22, 22, 18, 18, 22,
    17, 23, 20, 20, 26, 21, 14, 23, 17, 8, 24, 21, 20, 8, 17, 20, 20, 20, 19, 24,
    22, 23, 24, 23, 21, 20, 16, 27, 27, 18, 20, 18, 17, 19, 18, 14, 15, 19, 16, 19,
    72, 82, 85, 83, 81, 79, 73, 68, 75, 69, 67, 69, 58, 51, 53, 46, 40, 35, 29, 25,
    49, 49, 54, 52, 39, 45, 46, 37, 29, 40, 35, 28, 29, 26, 17, 23, 20, 27, 17, 20,
    33, 36, 31, 33, 32, 35, 32, 35, 28, 28, 24, 23, 18, 22, 13, 19, 19, 22, 17, 19,
    28, 28, 29, 27, 27, 25, 28, 21, 17, 20, 20, 24, 20, 23, 22, 19, 21, 15, 19, 22,
    25, 26, 26, 22, 9, 24, 19, 20, 22, 23, 18, 14, 16, 22, 19, 26, 22, 22, 23, 21,
    82, 93, 96, 100, 99, 94, 90, 83, 91, 79, 81, 80, 69, 66, 62, 54, 43, 35, 17, 21,
    68, 66, 71, 61, 53, 64, 63, 57, 45, 51, 44, 40, 33, 28, 17, 25, 20, 24, 14, 16,
    41, 51, 49, 50, 47, 48, 42, 39, 32, 29, 20, 23, 23, 22, 19, 20, 17, 27, 14, 12,
    39, 43, 43, 37, 34, 36, 26, 26, 20, 17, 24, 21, 18, 21, 14, 11, 23, 16, 15, 23,
    32, 30, 31, 26, 25, 21, 24, 23, 18, 16, 25, 25, 20, 17, 24, 24, 13, 19, 17, 23,
    63, 69, 56, 66, 51, 62, 55, 47, 48, 45, 37, 37, 30, 28, 28, 23, 28, 23, 17, 25,
    29, 28, 28, 34, 25, 32, 29, 28, 27, 21, 17, 20, 19, 22, 23, 19, 25, 16, 23, 21,
    22, 23, 28, 28, 22, 27, 28, 20, 24, 22, 21, 23, 24, 24, 24, 25, 26, 15, 19, 27,
    70, 84, 83, 83, 78, 70, 67, 64, 77, 66, 70, 66, 55, 52, 47, 35, 30, 26, 26, 25,
    45, 55, 40, 47, 42, 46, 42, 36, 37, 37, 32, 22, 17, 24, 19, 14, 21, 27, 22, 18,
    31, 32, 36, 34, 24, 23, 22, 19, 21, 24, 24, 20, 22, 23, 19, 15, 15, 20, 21, 21,
    23, 24, 25, 29, 28, 22, 26, 22, 19, 25, 23, 22, 24, 24, 22, 23, 19, 18, 25, 23,
    83, 91, 97, 98, 91, 90, 93, 89, 89, 78, 80, 76, 65, 65, 55, 41, 36, 27, 18, 22,
    70, 68, 58, 58, 66, 61, 62, 53, 48, 47, 46, 33, 18, 24, 26, 20, 17, 16, 19, 16,
    46, 52, 51, 47, 39, 41, 41, 27, 32, 29, 26, 22, 25, 17, 18, 19, 21, 16, 26, 24,
    34, 36, 36, 36, 32, 27, 29, 23, 21, 21, 27, 17, 13, 26, 23, 19, 20, 25, 24, 18,
};

const interp_partials_voice_t interp_partials_map[NUM_INTERP_PARTIALS_PRESETS] PROGMEM = {
    {
        NUM_PIANO_SAMPLE_TIMES_MS,
        piano_sample_times_ms,
        NUM_PIANO_VELOCITIES,
        piano_velocities,
        NUM_PIANO_NOTES,
        piano_notes,
        piano_num_harmonics,
        piano_harmonics_freq,
        piano_harmonics_mags,
    },
};

#endif // ndef __INTERP_PARTIALS_H

