#ifndef WHITENOISE8192_H_
#define WHITENOISE8192_H_

#include <Arduino.h>
#include "mozzi_pgmspace.h"

#define WHITENOISE8192_NUM_CELLS 8192
#define WHITENOISE8192_SAMPLERATE 16384

/** @ingroup tables
White noise table.
*/

CONSTTABLE_STORAGE(int8_t) WHITENOISE8192_DATA []  =
        {
	22, -13, 108, 2, -79, -98, 62, -61, -10, -126, -101, -79, 
	-113, -65, -1, 68, -62, -100, 0, -12, 37, 55, 104, 61, 
	125, 101, -53, 60, -90, -101, -126, 17, 26, -22, -96, 80, 
	43, -76, 117, -70, 66, -58, 30, -85, 111, 112, 65, -48, 
	85, -94, 38, 27, -38, 80, 94, 44, 20, 116, 36, -73, 
	-105, -56, 57, 96, -36, 39, -71, 21, -79, 121, -126, 88, 
	-83, 54, 120, -5, -93, 41, -40, -21, 39, 113, 84, 85, 
	-30, -48, 79, -12, -42, -24, 7, -26, -1, -90, 85, 102, 
	82, 37, -27, 115, -81, -78, -32, -37, 80, 47, 68, 32, 
	36, -28, 30, 47, -35, -89, -1, -36, 46, -34, -48, -63, 
	81, 35, -86, 121, 121, -109, -43, -32, 9, 83, 70, 48, 
	10, 43, 85, 40, 48, 88, 122, -82, -21, -37, 78, 113, 
	-90, 110, 0, 114, 72, 2, 49, -91, 80, -29, 124, -14, 
	125, -115, 87, -75, 115, 84, -111, 107, -100, 109, -65, 27, 
	-98, 59, -55, 91, 89, -17, -112, -56, 27, -109, -106, -86, 
	-13, -30, -53, -9, 1, 90, 91, 28, -8, -121, 31, -31, 
	-127, 98, 25, 110, -40, -96, 19, 17, 42, 5, 68, 123, 
	66, 22, -76, -42, -124, 86, 92, -3, -14, 33, -78, -37, 
	-127, 113, -101, -63, 94, -11, 14, 118, 106, -104, -85, -75, 
	27, -76, -15, 46, -99, 22, 118, -30, -1, 36, 74, 85, 
	63, -80, 93, 114, 37, -28, -91, 104, 115, -88, 127, 81, 
	-73, 8, -93, -28, -119, -49, -123, 53, 10, 0, 18, 121, 
	87, -71, 26, -48, -61, 43, 65, -56, 21, -60, 10, -87, 
	-110, 54, 42, -4, 5, 50, -71, 59, 116, 80, -3, -109, 
	-102, -63, -70, 79, 124, -60, -57, 1, -112, 16, -74, -124, 
	114, -96, -52, -29, -126, 101, -82, 70, -76, -41, 51, -14, 
	-16, -122, 44, 19, 53, 40, 22, -94, -9, -83, -11, -101, 
	9, 44, 124, 82, -73, -111, 36, 5, 65, 9, 63, 73, 
	103, -14, 33, 90, -52, 60, 104, -71, 80, -22, 84, -74, 
	98, -62, 82, 61, 100, -27, -95, 68, -102, -123, -56, 0, 
	59, 6, -43, 34, -113, -82, 50, 103, -119, -105, -74, -10, 
	92, -122, 115, -35, 116, -62, 1, -15, -12, -72, 33, 127, 
	-6, -9, 26, -19, 97, -71, 19, 77, 21, 28, 12, -16, 
	-24, 33, 118, -68, -32, -35, -45, 34, 96, 111, -13, -73, 
	-50, -79, 2, -41, -70, -27, 74, 8, 111, -12, 33, 81, 
	68, -70, -87, 60, 36, 17, 123, 103, 46, 0, -62, -127, 
	-43, 66, -91, 63, -101, 76, -24, -52, 67, -15, 4, -51, 
	-69, -76, 74, 71, -50, -77, -35, -68, 35, -64, 26, 22, 
	7, 85, 36, -38, 17, 64, -46, -114, -57, 124, 92, 29, 
	-102, -77, 64, 85, 49, 30, 57, -65, 65, -89, -77, -123, 
	38, 90, 11, -84, 73, -22, -41, -94, -70, 79, 106, 38, 
	-6, -106, -18, 1, 91, 119, 103, -46, 124, -39, -95, -102, 
	88, -52, 18, -59, -76, -13, 54, -69, -81, -7, -48, 111, 
	-75, -51, 105, 117, -10, -49, -25, 111, -36, 48, 42, -70, 
	5, 3, -80, -50, -34, -23, -97, 83, -58, -37, -28, 18, 
	102, -125, -33, -59, 98, 0, 124, -112, 101, 55, -5, 69, 
	-105, -95, 39, 49, 35, -3, 7, 27, -77, 89, 44, -46, 
	68, -22, -125, -35, 92, -11, -73, 117, -27, 30, 118, 52, 
	-30, -125, 9, -1, -114, 6, 121, 106, -111, -36, 92, -84, 
	-43, 102, 112, 47, 43, -56, -60, -18, -80, 112, 72, 19, 
	113, -71, 44, -52, -20, 94, 44, 0, 44, -1, -120, 77, 
	89, -91, 98, 117, 100, -23, 33, 47, 20, -92, -102, -28, 
	29, -20, 18, 102, -26, -24, -92, 79, -17, 29, 53, 50, 
	26, -20, 104, 25, 73, -68, -69, -30, 9, 53, -80, 27, 
	63, -60, -39, 49, 123, -30, 34, 32, -32, -116, -54, -46, 
	-16, 106, -33, -96, 117, 14, -123, -6, -96, -60, 121, -123, 
	-47, 118, 12, -69, 52, -74, -67, -14, -5, 53, 121, -32, 
	122, -20, 23, 19, 86, -29, 101, -124, -80, -26, -105, 17, 
	29, -100, -79, -91, -90, -65, 118, -43, 36, -126, 66, 71, 
	-99, 119, 60, -110, -49, -73, -40, 97, 13, 55, -48, 9, 
	11, 8, 41, 27, 110, 127, 87, 56, 29, -33, 26, -47, 
	99, -124, 113, -98, -99, -72, -71, -3, -115, -92, 58, -59, 
	20, 89, 82, 54, -34, -12, -12, 65, -91, -122, 106, -114, 
	-19, -67, -122, -45, 69, -109, -18, -81, 59, 54, -1, 4, 
	61, -95, 84, -105, -36, 72, 53, -91, 108, -79, -125, -84, 
	97, 21, 39, -25, -120, 101, 18, -66, -102, -8, 37, 45, 
	-70, 58, 56, 41, 70, 76, -109, 51, 114, 40, -95, -34, 
	81, -11, -27, -14, -111, -113, 100, -81, 105, 80, 55, -35, 
	0, -29, 47, -45, -37, -21, 93, -3, -72, 114, 79, 16, 
	-39, 5, -115, 50, 24, -16, 94, 70, 53, -75, 70, 126, 
	15, -68, -117, 117, 75, -121, 64, -16, 6, -82, -108, -86, 
	67, 106, 29, -29, 19, -19, 38, -122, 31, 84, 78, -2, 
	-59, -86, -116, -109, -27, 14, -12, 120, -108, 19, 9, 88, 
	29, 26, -126, -114, -32, -8, 93, 59, 38, 57, 80, 4, 
	-62, -85, -126, -29, 16, -32, -8, -20, 81, -101, -110, -126, 
	-4, 95, 34, -45, 82, -101, 75, -94, 17, 10, 52, -105, 
	-47, 39, -113, -27, 126, -33, -61, 70, -46, 20, -109, 34, 
	46, -74, -114, 0, 45, -111, -74, -71, -125, -72, 4, 79, 
	18, 70, -109, 45, 2, 40, 45, 11, 43, 13, -84, -57, 
	-17, 100, 111, 18, 10, -53, 94, 124, -35, -53, 23, -66, 
	113, 93, 101, -79, -114, 69, 124, 32, -107, 106, -11, -19, 
	26, 48, 123, -120, 59, 50, -66, 28, -61, 109, -40, -116, 
	19, -112, 126, -50, 35, -101, -87, -35, -59, -73, 113, -48, 
	-111, -21, -21, -47, 7, 77, -52, -63, -85, -113, -90, -7, 
	3, -118, -78, 72, 120, -13, 15, -114, 80, 95, -38, 97, 
	100, 109, 77, -31, -21, 77, 124, 58, -105, 110, -92, -38, 
	97, -69, 55, 38, 112, 108, 1, 19, -25, -126, 97, -68, 
	-108, -57, -97, 53, 80, -35, 90, 94, 79, -12, 119, -125, 
	69, 15, -53, -103, 43, 8, 69, 92, -19, 23, 32, 49, 
	-115, 53, 102, 96, 75, -14, -70, -91, -27, 94, -14, -51, 
	-91, 73, 2, -55, 93, 39, 103, -120, -89, -10, -109, 37, 
	40, -5, -51, 7, 79, -63, 100, 49, -34, 74, -105, -92, 
	104, 55, -4, -71, 28, -108, -94, -31, 86, 15, 58, -12, 
	68, -32, 106, 47, -96, 127, -72, 77, -46, 75, 106, -68, 
	48, -13, -77, 67, -106, 47, -94, -74, -66, -109, -66, -120, 
	-100, 104, -80, 33, -35, 95, -55, 104, 67, 25, -52, -33, 
	92, 104, -9, 84, 26, 45, -30, 42, -31, 2, 49, 108, 
	-81, 105, -55, -79, -55, 101, -48, 80, 86, -95, -26, -102, 
	86, 77, -89, 73, 85, 40, 62, -99, -94, 74, -80, 79, 
	10, -46, 77, 55, 35, 121, 46, -39, -35, 112, 49, -9, 
	-103, -12, 22, 38, 69, 37, -97, -58, -87, -36, 82, 109, 
	-96, 69, -101, 114, -75, 23, -33, -58, 11, -20, 10, -19, 
	127, -32, 26, 30, 115, -61, 93, 112, 59, -12, -117, -100, 
	104, 5, 75, 70, 65, 11, 115, -119, -39, 60, -60, -16, 
	-66, 30, 61, -44, 48, 96, -61, -124, -124, 77, -62, -14, 
	-37, 81, 78, -27, 117, -15, -78, -53, 99, 7, -73, -8, 
	5, 51, -48, -118, 114, -105, -57, 27, 110, 105, 35, -32, 
	9, -107, 63, 22, -51, 89, -111, -124, 66, -65, -24, 66, 
	55, -125, 36, -62, 21, -68, -127, -36, -92, 16, -52, 115, 
	-4, 58, -85, 87, -92, 45, 55, 102, 2, 73, 78, 115, 
	-93, -75, 121, -39, 27, 55, 101, 5, -2, 110, 12, 87, 
	65, -17, -111, -86, 73, -56, 54, 94, 125, -72, -126, 97, 
	-47, 8, -20, -97, 31, 50, -111, 90, -45, -126, 110, -8, 
	106, -103, -122, -71, 118, -43, 21, 14, 15, 126, -116, 45, 
	-92, -26, 0, 127, 0, -110, -23, -31, 101, -40, -71, 121, 
	-85, -46, -110, 89, -41, 11, 17, -68, -39, 1, 14, 113, 
	-29, 111, -116, -123, 98, -92, 94, -118, 96, -4, 102, 95, 
	-101, -7, 44, 85, 119, 41, 98, 111, -7, 19, -79, -34, 
	10, 100, -83, -11, -127, -108, 3, -122, 44, 36, 67, -100, 
	59, -80, 126, -102, 83, 120, -127, 61, 44, 6, 23, 17, 
	-118, -99, 105, -78, -5, -35, 76, -69, 78, -44, -19, 10, 
	109, -17, 47, -99, 75, -54, -61, -120, 108, 50, -40, 48, 
	-83, 0, 70, 126, 1, -70, -93, 88, 31, 33, -32, 12, 
	-57, 86, 18, 26, 124, -97, 34, -17, -95, -98, 41, -20, 
	73, -79, -33, -108, -123, -101, -33, -38, 122, 56, 98, 71, 
	124, 14, -71, 15, -77, 19, 123, -58, 28, -89, -89, 21, 
	38, -113, -118, -105, 126, 11, -33, -60, 78, 102, 36, 67, 
	99, 66, -113, 68, 62, -127, 32, -101, -42, 7, -3, 96, 
	17, 21, -20, 28, 20, -73, -97, -71, 45, -69, 31, 78, 
	46, -98, -12, -37, -47, 32, -122, -74, -92, -11, 66, 0, 
	-50, -79, -101, -87, -59, -85, -96, -79, -71, -115, 84, -31, 
	-57, 67, 97, -54, 19, 78, -84, 83, -3, -1, 81, -53, 
	-37, -52, 76, 93, -103, 67, -97, 38, -77, -5, 98, -18, 
	53, -29, 43, -31, 24, 94, 91, 66, -18, -122, -9, 113, 
	1, 89, -55, -59, 27, 16, 7, -20, -127, -69, -63, -4, 
	27, 29, 39, 17, -32, 100, -40, 98, 80, 114, 28, -94, 
	94, -59, 122, 15, 124, -14, 73, -92, 58, -57, -28, -49, 
	34, -51, 104, 122, 46, -122, -96, 36, -10, 4, 3, 57, 
	-75, -2, 35, -37, -73, 38, 116, -30, -48, -96, -83, -27, 
	-109, 50, -93, -105, 104, 6, -65, -36, -83, -87, -49, -91, 
	88, 113, 36, 99, 48, -5, 96, -100, -42, -46, -119, 83, 
	68, 34, -45, 91, -100, -75, 28, 93, -33, -34, 57, -117, 
	-90, -81, 21, -78, 55, -92, -66, 106, 122, 22, -36, -36, 
	36, 110, -66, 99, -101, 75, 112, -102, 0, -67, -92, 43, 
	22, -115, 116, 65, 96, 45, -27, 46, -116, -92, -74, -112, 
	121, -13, 24, 9, -108, -35, -120, -71, 8, -93, 29, -59, 
	-107, 76, -31, 34, 79, -122, 65, -103, 122, 119, 117, 75, 
	-53, 102, 108, 4, -74, -35, 4, -54, 115, -70, -117, 96, 
	-33, 100, -4, -42, -119, 61, -63, 42, -69, 82, 84, -66, 
	35, -99, 112, -15, -106, 118, -4, 58, -51, 121, 71, 124, 
	93, 84, -25, 122, -72, 11, -91, 60, 45, -53, 113, 48, 
	126, -28, 2, -124, 19, 33, -120, 27, -127, -84, -43, -110, 
	-36, -112, -1, -67, -7, -83, 8, 86, -74, 28, 17, 28, 
	109, 108, -112, 49, -4, -39, 97, 78, -17, -88, -87, 34, 
	-105, 109, 17, 10, -111, -99, 84, 0, 24, 9, 126, 122, 
	55, 0, -27, 102, -114, 108, 29, 84, -20, -17, -45, -77, 
	0, 110, -124, 65, 125, -105, -63, -88, -89, -14, 9, -33, 
	-89, -15, -58, 29, -127, 1, -7, 48, -78, 58, 119, 21, 
	56, -125, -38, 72, 56, -80, 51, -97, 36, 2, -9, -8, 
	-119, -109, -104, -8, 3, 62, 35, -70, -101, 74, 39, 120, 
	21, 37, 88, -43, -65, -58, 120, -66, 8, 108, 26, 82, 
	-120, -17, 118, 38, -60, 28, -43, -79, 104, 114, 117, 117, 
	-3, 22, -88, 83, -3, -3, 31, 60, -77, 37, 40, 75, 
	74, 48, 56, -75, 24, 99, -34, 111, 111, -65, -19, 15, 
	82, 92, 114, -30, 40, -41, 56, 9, -63, -90, 67, 16, 
	-33, 93, -93, 29, 7, -29, -23, -112, 85, 0, 21, 34, 
	78, 55, 114, -48, -89, -33, -112, 104, 8, 89, 7, -37, 
	-73, 119, 115, 78, 58, -68, 0, -122, 18, -4, 55, -35, 
	-88, -114, 74, -93, 97, -21, -78, -68, -105, -86, 83, 94, 
	54, -81, 47, 73, -51, -57, 59, 97, -57, -30, -48, -3, 
	-47, -124, -41, 112, -69, -3, 59, -97, 99, -38, 51, -25, 
	61, -55, -122, 7, 11, 23, -95, 83, 88, 24, -67, -41, 
	-29, 59, 97, 112, 34, -33, 57, -11, 9, -69, 124, 81, 
	-11, 73, 114, -108, -52, 94, 97, 23, -120, 65, 6, 62, 
	-91, -110, -15, -120, -15, -85, -18, 56, 109, -9, -89, -18, 
	79, 99, -20, 123, -11, -78, -96, -60, -10, 82, 48, -87, 
	26, -41, 42, -76, -72, 1, -7, 25, -69, 8, 92, 121, 
	10, 77, -71, 43, -30, -10, -26, 103, 113, 63, 28, -109, 
	111, 124, 1, 66, -16, -86, -109, 88, 12, 124, -62, 99, 
	-79, 92, 26, 68, 111, -102, 78, 37, -101, 118, -2, -119, 
	-66, -62, -27, 6, 56, 12, -74, -85, 78, -5, -41, 45, 
	26, -39, -65, -92, -48, -125, 86, -33, -5, 24, 6, -83, 
	-110, 20, 96, 6, -90, -15, 110, 35, -127, 39, 90, 58, 
	-107, 28, 66, -7, 28, -81, -56, 45, 72, 35, -59, -106, 
	84, -55, -83, -114, 25, -58, 32, 24, -77, 33, 67, -85, 
	-55, -64, 83, 52, -102, 34, -1, 92, -55, 95, -114, 105, 
	42, -24, -9, 104, 15, 115, 88, -16, -41, 15, -28, 113, 
	102, 112, 81, 28, -59, 33, 21, 113, 26, -6, 89, -68, 
	63, 1, -103, 81, -60, -56, 0, -42, -44, -116, -15, -112, 
	-84, 15, -99, 7, 37, 108, -125, 83, -20, 77, -20, 82, 
	7, -79, 39, -79, -81, -127, 34, 106, 125, 109, -61, -121, 
	-81, 10, 122, -120, -101, 76, 82, 107, -105, -19, 112, -123, 
	-86, 12, 108, -45, 89, 24, -21, 10, 79, 94, 38, 19, 
	-11, -125, -42, 4, 15, -6, -38, 2, -56, 92, -125, 61, 
	95, 3, 125, -60, -67, -104, -47, 110, -102, 42, -30, 34, 
	90, 83, 3, 82, -9, 113, -10, -94, -111, 5, -69, 46, 
	-96, 102, -89, 127, 103, -82, 20, 23, 109, 119, -105, 122, 
	9, 47, 59, -23, -100, -41, -108, -68, -116, -14, -77, 88, 
	-27, -71, 71, -49, 87, -14, -84, 31, 52, 64, -18, 27, 
	-125, 2, -23, -19, 107, 92, -45, 8, -96, 96, 1, 67, 
	103, -24, 76, 13, -35, -52, -21, 123, 74, 40, 63, -3, 
	-100, 58, 54, 31, -120, 123, -54, 124, -82, 50, -109, 74, 
	-90, 22, -5, -95, 31, 38, 36, 107, -70, 80, -120, -55, 
	111, 88, 82, -70, -48, -109, -55, -102, -22, 38, 103, -77, 
	18, -48, 3, 7, 87, -59, 54, 105, 95, -90, -5, -53, 
	13, 101, -40, 92, 94, -7, 8, 114, -80, 24, 41, -12, 
	100, 59, 55, -89, -84, -55, 98, -104, 99, -87, 10, 110, 
	-30, 127, -25, 125, -123, 56, 14, -63, 17, 75, -113, 107, 
	-91, -56, 97, -88, -106, 64, 69, 95, -121, 99, -117, -95, 
	-126, 1, 2, 80, 86, 70, 60, 58, -104, -127, 54, -17, 
	45, 10, 28, 56, -11, 99, -116, -22, 0, -117, 9, -123, 
	-30, -28, 58, -86, 90, -114, -99, 50, 86, -8, -119, -126, 
	41, -67, 37, -5, -16, 50, -55, -20, 37, 0, -33, 78, 
	31, -60, 13, -79, -69, -73, 121, -113, -79, 61, -15, -44, 
	-106, -69, -2, -100, -70, -28, -22, 87, 110, 59, -122, -96, 
	41, -8, 35, -22, 24, 126, 46, -96, 37, 99, -30, 62, 
	-65, 100, 26, 0, 77, -116, 36, -37, -61, 57, -46, 113, 
	44, -69, 77, -112, 100, 8, -43, -108, -75, 106, -23, -112, 
	24, 57, 85, -60, -47, 103, -8, 74, -68, 42, 44, -126, 
	60, -58, 15, -87, -23, 82, 126, -40, 115, -78, 7, -96, 
	119, -20, 3, -79, -113, 0, -21, 70, 28, -34, -72, -106, 
	108, -76, 80, 19, 114, -21, -39, 41, 117, 8, 107, 9, 
	-29, -113, 46, 22, 109, -1, -30, -58, 43, -78, -5, 67, 
	75, 39, -76, -114, -113, -59, -45, 100, -70, 24, -62, 76, 
	-33, -69, 64, 5, -93, -97, 19, 124, 93, 96, -91, 113, 
	-6, -59, 70, -53, 46, 24, 74, -3, 121, -40, 81, -64, 
	-68, 58, 86, 71, -32, -125, -12, 86, -70, -72, 36, 4, 
	121, 105, 85, -41, -2, 87, 126, 58, 127, -72, -4, 114, 
	-18, -15, -34, -67, 28, 90, -71, -30, -54, 54, -73, 79, 
	114, 5, -61, 31, -125, -124, -34, -21, 125, -30, -18, -28, 
	-42, 122, -18, -44, 113, -46, -112, 50, 59, 42, 16, -115, 
	-47, 11, 118, -125, 81, -80, 63, -85, 59, 0, 61, 100, 
	127, 88, -61, -63, -125, 27, 73, -13, -119, -28, 123, -46, 
	-15, -29, -80, 77, 78, -69, -36, 70, -74, -73, 10, -35, 
	23, -89, 46, 17, 24, -44, -89, 101, -33, 117, -9, 115, 
	-13, -15, -87, -19, 15, 31, 115, 40, 68, -108, 32, -75, 
	67, -24, 0, -100, 96, -58, -83, 96, 45, -43, 79, -85, 
	12, 7, -29, 94, -50, -25, 95, 89, 0, -35, -21, -52, 
	6, 18, -15, 101, 0, 39, -97, -16, -36, 19, 80, -93, 
	-125, 76, -120, 73, -67, 97, 90, 87, 109, 38, -79, -20, 
	-40, 76, -22, -119, 4, -123, 9, -86, 10, -71, -117, 13, 
	-8, 115, -55, -81, 63, -54, 51, 67, -48, -70, -33, -122, 
	-6, -78, 16, 36, 8, -18, -14, 81, 125, -18, -114, -86, 
	43, -103, 47, -66, -31, -48, -92, 7, 24, -27, -84, 94, 
	46, 27, 122, 49, -12, -89, -92, 70, -60, -91, -3, 51, 
	-74, 115, 119, 119, 79, -49, 111, -29, 6, 53, 97, 17, 
	106, 86, -53, -79, -76, -2, 17, -101, 31, 102, -58, 75, 
	-119, 9, 123, -89, -71, -104, -125, -43, -40, -69, -126, -77, 
	114, -116, 39, 24, -52, -83, 34, 10, -87, -10, -41, -121, 
	17, 28, 29, 96, 6, -6, 125, -84, 25, -91, 63, -9, 
	-73, -94, -114, 68, 19, 64, 3, 54, -77, -94, 59, -87, 
	81, -119, -30, 74, 94, -117, 0, 113, 80, -52, 64, -19, 
	92, 0, 40, -57, -118, -112, 102, 120, 122, 97, -67, -48, 
	39, 100, -109, 26, -26, -93, -81, -8, -17, 22, 55, 50, 
	59, 10, -108, -126, -63, 51, 39, -77, -104, 45, -1, -73, 
	-15, -1, -100, 20, -67, -106, 6, 105, 43, -43, 99, -37, 
	116, 9, 38, -62, 13, 109, 71, 23, -84, -106, -2, 40, 
	60, -88, -109, -33, 43, -104, -75, -61, -104, 83, 101, -21, 
	10, 110, 124, 54, 93, -100, -113, -101, -80, 122, 54, -39, 
	77, 11, -30, 18, 35, 14, 25, 81, 87, 15, -6, -78, 
	-14, 2, -96, -3, 125, 103, 31, -91, 118, 9, 39, 34, 
	-22, 60, 90, 63, 69, 49, 68, -19, 91, -35, 28, 7, 
	104, -126, -111, 2, 48, -91, -21, 98, 72, 86, 2, 117, 
	102, 27, -52, 20, 0, 96, -32, -30, -61, 0, 23, 83, 
	2, 11, 51, 38, 23, 0, -23, 93, 121, 4, 87, -103, 
	-126, -1, -96, -84, -114, -43, -42, -99, 120, 84, -98, 1, 
	18, 1, -28, -22, 119, -17, 73, 56, -76, -76, -80, -17, 
	47, 117, -89, -28, 51, 32, 114, 0, -50, 88, -24, 2, 
	44, -79, 97, 127, 80, -88, 127, -19, 39, 81, 94, 124, 
	-73, -84, -27, -33, 113, 85, 67, 79, -31, -7, -120, -35, 
	50, 123, 8, 54, -90, 7, -42, 32, -109, 51, -119, 59, 
	-105, 70, 122, 71, 114, -94, -70, -5, 9, 38, 68, 124, 
	-110, 26, 62, -46, 126, 0, 125, -127, 115, 29, -43, 40, 
	105, 78, -94, 49, -121, -109, 43, -18, 57, -13, 35, 30, 
	114, -12, -49, -95, 65, -20, 84, -17, -3, 12, -99, -88, 
	-122, -78, -43, 12, 90, -65, -94, -12, -124, -109, 28, -49, 
	-38, 46, -113, -32, 65, 28, -8, 38, -60, 24, 55, 55, 
	92, 63, 101, -55, -100, -82, -44, 87, 58, 63, 122, 53, 
	-108, -127, -96, -47, 87, -19, -1, -61, -86, -116, 49, 89, 
	58, 127, 1, 2, 7, 76, 90, 54, 2, 96, -95, 84, 
	-3, 47, -22, -117, -125, 36, 58, 47, 6, -45, -91, 86, 
	103, 72, 54, -33, -84, 47, 124, -7, -52, 117, -54, 102, 
	-23, 43, -126, 126, 62, 121, -126, 123, -105, 126, 10, 57, 
	-54, -123, 68, 16, -72, 91, 78, 122, 56, 25, -73, -79, 
	-87, 19, -73, -82, 96, -70, -98, -36, 36, 105, -4, 64, 
	-1, -115, 19, -89, 78, 89, 93, 37, -68, -7, -48, -45, 
	-71, -70, 117, -117, 114, 12, -41, 63, 23, -113, -72, 25, 
	-31, -69, 75, -47, 46, -38, -121, -7, -107, 59, 63, -20, 
	44, -73, -95, 116, -108, 126, 85, -61, -24, 27, -102, -112, 
	-89, -38, -125, -45, 3, -56, -111, -20, -47, 45, 59, 8, 
	-28, 60, 12, -105, 124, 51, 50, -99, 103, 37, -41, 11, 
	-109, 113, 39, -120, 44, -104, 99, -110, 100, -116, 92, 110, 
	123, 115, -44, 19, 96, -126, -81, 113, 72, 40, -37, -115, 
	-125, -121, -78, 11, -103, 40, 55, -25, -8, -74, -119, 101, 
	73, -20, 60, 124, -25, -35, -82, -13, -3, -6, -72, -67, 
	5, 107, -79, 101, -56, -41, -10, -119, 62, 65, 0, 91, 
	-85, -101, 42, -9, 85, 102, 120, 103, 100, -67, 31, 74, 
	-108, -26, -124, -103, -85, 78, -73, -63, 78, -26, -115, -98, 
	36, 117, 75, -49, -95, -62, 1, 106, 46, 80, -32, -71, 
	61, -33, 65, 53, 95, -100, -125, -91, 88, -2, 73, -113, 
	26, 63, -120, 61, -83, 3, -12, 80, -33, -9, -96, 127, 
	65, -80, -89, -30, -9, 99, 30, -12, 125, 52, -37, -79, 
	-60, -34, 124, -101, 51, -48, 67, 116, -116, -50, 87, -3, 
	-55, 73, 114, 114, -42, -112, -65, 51, -17, -13, -89, -46, 
	85, 40, -6, -126, -94, -42, 11, -89, -33, 57, 101, -28, 
	-50, 1, 117, 21, 61, -7, -69, 121, -23, 87, -88, -11, 
	121, 50, -27, -5, -5, -94, -5, 38, 49, -98, 127, 120, 
	55, -54, 46, 39, -56, 33, -57, -3, -6, -85, 86, -30, 
	94, 25, 16, -125, 90, 80, 106, -32, 109, 82, -43, 109, 
	-64, -68, 2, -71, -53, -59, -118, -120, 111, 69, -68, -94, 
	-20, -105, 37, 2, -17, -28, 30, 32, 127, 75, 32, -52, 
	-57, 79, -35, -77, 110, 5, -110, 82, -4, 28, -61, 64, 
	-51, 22, -95, -29, 52, 22, 104, 126, -8, -71, 34, -117, 
	62, -89, 115, 63, -100, -25, 36, -31, 90, -61, -109, 100, 
	95, -7, -119, -112, -89, 3, -101, -26, -9, 110, -121, 18, 
	106, -68, 3, -63, -93, 118, 25, -98, -106, -23, -59, 71, 
	-9, -92, -127, -120, -75, 53, -41, -113, 20, -60, 77, 88, 
	81, -60, -80, 21, -26, 43, 99, -37, 111, -32, 31, -108, 
	119, -109, -49, -95, -80, 95, -35, 63, 85, 16, 56, -73, 
	94, -42, 115, -86, -51, 109, -51, -48, -116, 82, -80, -15, 
	-59, 39, 123, 125, 64, 29, -106, -89, 119, -75, 101, 24, 
	67, 116, -81, -95, 3, -118, -56, -59, -52, -115, -2, 87, 
	110, -24, 23, 93, 0, 106, -79, -18, -88, -86, -7, -93, 
	108, 115, -27, -93, -19, -51, 5, 113, -100, -114, -46, 110, 
	-120, -36, 37, -59, 70, -104, -27, 63, 91, -90, 108, -89, 
	119, 96, 34, 23, 11, 107, 42, -121, 42, 17, 124, 51, 
	93, -87, -2, -112, 26, 97, -116, 28, -107, 7, -108, -127, 
	101, 35, -107, 102, 85, -112, 20, 57, -80, 39, -26, -67, 
	23, 66, 4, -18, -34, 79, 21, -1, 82, 95, 1, 67, 
	57, 29, 88, 57, -83, 11, 81, -43, -25, 101, -127, -109, 
	52, 32, -6, 39, 70, -22, -52, 101, 38, -96, -116, 106, 
	-88, -91, 67, -76, -63, 77, -123, -74, 77, 94, 46, -50, 
	57, 34, -14, 119, -70, 70, 63, -46, -83, 69, -9, 82, 
	115, -66, -72, -43, -2, 48, 25, -87, -80, -104, 8, 55, 
	-98, -4, -26, 100, 116, -102, -36, 114, 102, -101, 51, 110, 
	-63, -108, -100, 107, 37, 65, -7, 34, 91, 84, 21, 126, 
	67, -53, 63, 118, -58, -22, 59, -123, -83, 65, -54, -20, 
	122, 118, 105, 0, 83, 55, 12, -99, 77, 3, 64, 104, 
	-21, -17, 84, 114, -27, 108, 46, 50, -10, 28, 44, -75, 
	47, -69, -114, -47, -18, -37, 127, 35, -68, 127, 103, -78, 
	62, 37, -90, 1, 99, -98, 126, -118, -13, -92, 39, -60, 
	-110, -100, 17, -14, 104, 111, 55, 64, 35, 47, 119, -87, 
	113, -80, -125, 113, -75, 27, 58, -55, -1, -28, 97, 64, 
	-47, -73, 118, -28, 36, 98, 103, 64, 114, 70, -94, -86, 
	87, 4, 48, -103, -65, 77, 81, -126, 41, 50, 19, 67, 
	-61, -33, -43, -10, 101, -65, -17, -39, -21, 65, -96, -43, 
	76, -86, 52, -51, 16, -85, -77, 77, 37, 87, -28, -53, 
	-76, 34, 35, 95, 9, 111, 124, 18, -83, -46, -30, 7, 
	-80, -5, -79, 117, 1, 35, 104, -16, -124, -117, -96, -74, 
	35, -94, -94, -33, -44, -95, -57, 86, -83, 92, -118, -47, 
	-16, -27, 91, 80, 13, -50, -103, -48, 26, 43, -71, -116, 
	65, -41, 36, 99, 14, 25, -53, -96, -11, -30, -51, 113, 
	-42, 84, -55, -81, 73, 27, -38, -59, 113, -114, 68, -105, 
	41, -31, -27, 118, -20, -49, 24, 60, -11, 77, -79, 19, 
	-5, -15, 79, 110, 44, 36, 44, 122, -66, -19, -17, 88, 
	101, -120, -79, 22, 49, -99, -113, 37, -117, 105, 99, 2, 
	-30, 42, 21, -80, 105, -103, 7, -25, -48, -116, 111, -39, 
	-16, -27, 104, -77, 102, -96, 104, 62, 99, -11, -108, 38, 
	88, 44, -97, 101, 98, 11, -37, -94, 125, 124, -41, -7, 
	29, -34, -100, -44, -125, -123, 104, -66, 83, -75, -59, -122, 
	37, 98, 59, -86, -35, 59, -105, -86, -115, 74, 66, 36, 
	29, 53, 39, 126, 27, -20, -65, -7, 80, 57, -47, 26, 
	93, 39, 66, -86, -30, -10, -84, -110, -90, 121, 37, 65, 
	81, 62, 124, -69, -15, 127, -54, 55, 36, -115, -107, -30, 
	-57, 54, -64, -105, 31, 34, 47, 30, -116, -67, -114, -22, 
	9, 122, 118, -73, 84, 3, -90, 51, -21, 17, -57, -86, 
	-24, 119, 44, -28, 111, 85, -42, -12, -56, -50, 58, 0, 
	114, 101, 87, -71, -126, -19, -89, 7, 54, -16, -113, -22, 
	-24, -26, 99, 69, 102, 68, 43, 66, -39, -40, -104, 19, 
	93, -125, 50, 16, 68, 14, -8, -65, 104, 72, -51, -83, 
	24, 104, 17, -20, 47, -124, -38, 36, 57, 81, 33, 33, 
	-77, 102, 47, 84, -75, 51, 70, -110, 18, 28, -49, -99, 
	26, 58, 28, -38, -36, 97, 96, -103, -35, 94, 120, 78, 
	90, -47, -68, 76, 59, 59, 44, -89, 25, 30, 48, 99, 
	95, 14, 58, -91, 56, 38, -43, 48, 13, -12, -84, 0, 
	9, 6, -96, 87, -103, -91, -43, 126, 56, 73, -17, 89, 
	41, 2, 78, -43, 105, 40, 52, 75, -13, -41, -118, 103, 
	69, 110, 47, 48, 127, 45, -21, 27, -90, -12, 60, -63, 
	-68, -70, 53, -89, -31, 15, 123, 27, -8, 31, 114, -22, 
	-4, 8, -59, 103, -93, -81, -15, 86, 4, -27, -73, -19, 
	73, -52, 126, 82, 111, -40, 2, -70, 41, 70, 40, 15, 
	44, -127, 71, -116, 98, 52, -84, 12, -114, -120, 50, 7, 
	12, 48, 1, -113, -10, 95, 34, 107, 66, -101, -42, -103, 
	107, 75, -37, -92, 23, 21, -42, -52, -3, 26, 83, 4, 
	-50, 98, 97, 42, 73, 38, -89, -125, 48, 111, -7, -50, 
	63, -109, 28, 42, 122, -15, 20, -19, 113, 68, 11, -76, 
	90, 41, 58, -126, -37, 101, -69, 15, 10, -99, -53, 46, 
	-30, -1, 90, -87, 51, 29, 15, -13, 119, 87, 59, -117, 
	56, 75, 22, -21, -21, -46, 97, 77, -8, -85, -90, 90, 
	-95, -88, 109, -27, -22, 120, -93, 121, -16, 7, 12, -117, 
	70, 43, 96, -81, -99, -17, -29, -48, -44, -4, -54, -125, 
	50, 65, -38, 69, -101, -55, 20, 61, 57, -15, -90, 64, 
	81, -35, -102, 47, -112, -116, -44, 38, 27, -67, -49, -7, 
	27, -11, -118, 63, -100, 2, 5, -30, 117, 18, -6, -50, 
	-57, 103, 33, 54, -1, -42, 8, -13, -6, 89, -107, 88, 
	-33, -119, 81, -69, 57, 120, -105, -97, -21, 94, -93, 1, 
	36, 114, -24, -62, 26, 98, -42, -114, -8, -118, -10, 13, 
	-123, -64, -54, 39, -30, -31, -111, -117, -2, -91, 84, 98, 
	48, -26, -117, -20, 1, 114, 47, 15, 56, -15, -94, -5, 
	3, -83, -34, 91, -9, -47, 62, -30, 38, -48, -70, -84, 
	-122, -126, 37, -25, -21, -56, -31, 112, 14, 75, -58, 6, 
	125, -64, 58, 101, -9, -113, -42, -81, -8, -126, 4, -44, 
	-14, 96, -60, 88, -65, 11, 95, 48, -8, -116, 40, 58, 
	77, 113, -82, 70, -57, 65, 14, 31, 112, -21, 113, 73, 
	-116, 69, -16, 10, -57, -123, -119, 66, 61, 53, -80, 67, 
	-36, -26, 65, 5, 122, 5, -95, -65, -21, -30, -53, 31, 
	-18, 99, -58, -75, 83, -72, 127, 13, -10, -99, 122, -4, 
	-68, -88, 34, 33, 32, 123, 28, -101, -34, -68, 95, 84, 
	16, 104, 29, -52, -123, -86, 37, 1, 65, 106, -7, -97, 
	-45, 55, -13, 86, -94, -22, -41, -124, 25, 26, 59, 118, 
	-101, 38, -16, -34, 17, 49, 53, -16, -112, -120, 54, 107, 
	-35, -111, 103, 13, 36, 18, 115, 72, 98, -13, -22, 78, 
	91, -44, 26, -38, 51, -124, -58, -40, 106, 62, 5, 127, 
	-122, 12, -82, -70, 46, 95, -93, -126, -74, 109, -29, -26, 
	-107, 78, 51, 83, -45, 73, -22, -59, 17, 0, -87, 53, 
	-1, -98, -73, 106, -49, 29, 13, 3, 60, -39, 20, 21, 
	21, -113, -75, 65, 54, -95, -65, 58, 63, 96, 0, 65, 
	45, -119, 107, -37, 3, -45, 101, 83, -33, 111, 38, -18, 
	14, 32, -34, -95, -107, 39, 4, -18, 65, 31, 76, -29, 
	53, -68, 67, -8, 71, -92, 103, 64, -100, -99, -2, -115, 
	68, -77, 28, -103, -85, 110, -82, -106, -5, -67, 23, -106, 
	-126, 64, 27, -47, 59, -52, -72, -58, 111, 22, 99, 74, 
	-72, -89, -71, 94, -36, 57, -28, 33, 68, -32, -85, 118, 
	63, 75, -29, 55, -73, -54, 89, -29, -69, -115, -77, -97, 
	108, -74, 24, 108, 88, 31, 47, -81, -34, 0, 79, -113, 
	-7, 95, -30, -103, 123, 21, 61, -50, 61, 49, 12, 57, 
	-75, -109, 68, -99, -40, -2, -103, -120, -102, 99, -111, 31, 
	60, 2, -32, 43, 62, 6, -55, -4, 64, 116, -40, -109, 
	36, -17, -33, 123, -36, 84, -102, -48, 12, -8, 85, 93, 
	75, -55, -78, 90, -127, -106, -113, 35, -1, -31, 1, 84, 
	-100, 113, 52, -53, -84, -127, -4, 20, 103, 62, -101, 92, 
	-2, -59, -41, 102, -60, -58, -5, 19, 101, -92, 13, -75, 
	-35, 9, -88, 94, 34, 35, -59, 70, -84, 50, 37, 14, 
	69, -101, 95, -16, 60, -123, 90, -84, -37, -39, -24, -8, 
	-85, 122, 31, 113, -89, -41, -61, 117, -106, 43, -83, 23, 
	-88, -3, 0, 76, 40, -88, 69, -74, 127, 111, 101, 29, 
	53, -34, 46, -66, 100, 50, 19, -21, 102, 19, 121, 18, 
	103, 127, 8, -5, 81, 85, -53, 47, 120, -31, 3, 6, 
	24, -102, 35, -122, 77, -116, -127, 124, 46, -67, 75, -1, 
	-93, 66, -12, -34, -92, 75, -80, 111, -92, 112, 77, 28, 
	52, 93, 21, -55, 28, -2, 92, 64, 68, -118, 40, -119, 
	-32, 113, 56, 122, -32, 19, 121, -88, -95, -23, -73, 82, 
	-12, -60, -19, 24, -100, -124, 27, 122, -65, -44, 3, 0, 
	-79, -88, 100, 89, 86, -75, -37, -127, -53, 66, 118, 33, 
	83, 32, -125, 30, -99, 19, -23, -119, 10, -72, -52, -9, 
	63, -99, 103, 19, -47, -30, -9, 11, -94, -98, 72, 119, 
	4, 74, -42, 33, -81, -73, -27, -107, 71, 12, -117, 43, 
	-79, 126, 60, 18, -114, 26, -55, -15, 75, 100, -44, 84, 
	110, 108, -77, -47, 18, 101, -12, 6, -99, -86, -113, 113, 
	-28, -113, 60, 70, -102, -82, -49, 84, 86, 62, 92, -94, 
	107, 107, 24, -80, 29, -110, 35, 26, 50, -119, 24, -92, 
	11, 100, -11, -19, -10, 94, -3, -86, 66, -23, 124, 41, 
	64, 88, 62, -13, 4, -66, -109, -50, -89, -75, 94, 110, 
	-61, 78, -23, -42, 116, 89, -127, 96, 69, 91, -95, -64, 
	-72, -110, -61, -106, -108, 110, 41, 82, 42, 83, 59, 69, 
	-97, 45, 55, -58, -39, -84, -42, 30, 54, -56, 44, 90, 
	12, 86, -60, 97, -83, 102, 61, 2, 50, 58, 66, 49, 
	-82, -121, 20, 36, 21, -70, 59, -98, 58, 65, 19, 32, 
	-90, 4, 72, -100, 50, 39, 125, -66, -97, 114, -126, 74, 
	-101, 59, -26, 6, -11, 6, 30, 58, 44, 95, -127, 116, 
	-50, 27, 26, -64, 36, -27, -103, -60, -31, -44, 99, -77, 
	46, -55, 40, -52, 97, -124, -114, 64, 53, 20, 120, 10, 
	90, 67, 48, -25, -114, -34, -32, -99, -39, 68, -23, -55, 
	95, 92, -66, -58, 84, 88, 55, 93, -64, 107, -57, 116, 
	87, -123, -115, -111, 75, 85, 79, -36, -79, -43, 98, -86, 
	-125, 73, 82, 126, 37, -48, -33, -37, 59, 10, 17, -85, 
	63, 47, 61, 22, 29, 83, -107, -30, 45, -17, 28, 53, 
	-120, -33, -22, 86, 114, -47, -123, -59, 53, -93, -118, 108, 
	37, 36, 11, -8, 61, -25, -47, 124, 115, 89, -80, -69, 
	-43, -82, -34, -86, -36, -104, -44, -68, -127, 60, -108, -13, 
	-32, -116, 0, -3, 68, -47, 17, 67, -106, 45, -62, -35, 
	57, 47, -109, 62, -50, 69, -98, 63, 88, -82, -69, -85, 
	-112, -71, -83, -105, 31, -13, 33, 94, -124, 42, 73, -21, 
	-85, 109, 101, -63, -49, -33, 66, 33, -32, 31, -96, 105, 
	20, -119, -122, 66, -46, -14, -86, 49, 18, -97, 1, 94, 
	-81, 101, -116, -63, -117, 85, -127, -57, -18, -87, 83, 6, 
	59, 22, 26, -94, -111, -38, -32, -58, 87, 5, 49, -90, 
	-7, -71, -46, -88, -106, -117, -27, 15, 82, -10, 102, 96, 
	0, -81, -80, 81, 47, -88, 30, -125, -55, 92, 80, 56, 
	125, -8, -113, 107, 7, -99, -62, -43, -58, 21, -34, 79, 
	-93, 54, 76, -118, 24, 31, 85, -96, 41, 92, -107, 78, 
	-116, -68, -71, 112, 46, -100, -7, 17, 108, -21, -104, -74, 
	-33, -36, -49, 99, 30, 126, -39, -119, -126, 32, 19, -35, 
	-92, -83, 116, 92, -73, -21, 44, -16, 31, 78, -120, 54, 
	11, -44, 115, 10, -73, 60, -41, 74, 12, 88, 73, -41, 
	65, -114, -16, -117, 44, 38, 2, -107, -8, -71, 71, -112, 
	33, 86, -121, 59, 84, -62, 120, -56, -84, 80, -29, -77, 
	0, 10, 37, -78, 82, 30, -35, -6, 69, -73, 44, -111, 
	69, -42, -55, -99, -77, -102, -62, -67, 105, -97, 67, -82, 
	-35, -29, 109, 104, 55, -2, 59, -61, -21, 94, 114, -88, 
	110, 74, 106, 68, 119, -1, 75, -55, -27, -102, -38, 125, 
	53, -79, -26, -58, 118, -79, -40, 100, 53, -18, -94, 45, 
	-95, -119, 46, -81, 114, -81, 79, -40, -108, -97, 76, -21, 
	73, -105, 103, -127, -51, 35, 67, 39, 45, -23, 43, -65, 
	-47, 5, -125, -69, -24, -114, 15, -43, 99, 0, 61, 62, 
	123, 19, 86, -83, -65, -37, -86, 98, 117, -19, 91, -52, 
	-58, -91, 116, 63, 62, -121, 24, 6, 61, -92, -55, 125, 
	-93, 88, -41, -70, 94, 78, 20, 17, -59, 56, 108, 71, 
	33, -118, -75, -67, 126, -75, -19, -59, 10, -14, -126, 42, 
	5, -40, -45, 89, -93, -68, 82, -97, -103, -87, 106, -42, 
	-65, 61, -124, -125, 0, -49, -32, 73, -61, 10, -98, 66, 
	85, -107, 105, -87, -78, 13, 25, 73, 84, -111, 14, 14, 
	-28, -33, 17, 23, -89, 49, -51, 68, 60, -41, 48, 83, 
	-2, -118, -121, -59, -68, 32, -83, 13, -51, -73, -59, 57, 
	-1, 103, -125, -90, -56, -99, 49, 107, 22, 127, -53, 18, 
	-49, -61, -29, 10, 109, 112, 1, -76, -48, -17, 65, -114, 
	87, 14, 85, 81, -47, 1, 126, 104, -6, -23, -76, -121, 
	-53, 84, 2, 123, 99, -90, -11, -67, 115, 14, -89, 11, 
	-124, 34, 29, -20, -120, 86, 35, 2, -30, 53, 35, 38, 
	-96, 94, -47, -27, -94, 112, 6, 114, 29, -111, -109, -64, 
	52, 27, 105, -92, -53, -52, 74, -84, -9, -107, 59, 74, 
	-16, -117, -62, 63, -95, -45, 56, 26, 89, 9, 113, 85, 
	117, 58, -17, 127, 46, 9, -98, -87, -17, -30, 37, -99, 
	77, 39, 30, 51, -12, -54, -36, -97, 99, 113, 118, -54, 
	26, 9, 9, 39, 89, -68, -18, -22, -46, 0, 75, 64, 
	30, -102, 91, -84, 50, -55, -49, -89, 34, -45, 125, 117, 
	-68, -13, 102, 113, -72, 2, 34, -20, -103, 96, 112, -9, 
	-76, 92, 63, -34, -15, -8, 20, -112, -65, 98, -80, -49, 
	79, -36, 119, 2, -120, -58, 99, 28, -99, 30, -76, -3, 
	-90, -89, -69, -94, -4, -34, 26, -117, -11, 112, 3, 108, 
	-22, -4, -56, -127, 31, 125, 82, -29, 10, 35, -94, -13, 
	102, -38, -49, 31, 114, -107, 14, 11, 30, 1, -47, 33, 
	-1, 38, -117, 20, -72, -84, -127, 82, 12, -81, -73, 105, 
	-82, -6, 127, 36, -11, 52, -36, 83, 86, -63, 92, 92, 
	13, 36, 54, -8, 68, -99, 101, -39, -12, 64, -56, 13, 
	104, 106, -101, -24, 18, -54, -1, -95, -78, 80, -26, -79, 
	-7, -64, -54, 25, -77, -13, -101, -55, 50, 123, 113, -72, 
	-23, 32, -50, -71, -30, 89, -83, 82, 101, -98, -19, -17, 
	29, -16, -88, 74, 103, -51, -122, -17, 107, -65, 80, 56, 
	113, -51, -68, -84, -85, 103, -100, 51, 109, 23, -104, 46, 
	13, -41, -50, -32, 106, 44, 20, -122, 32, 122, 24, 33, 
	88, -103, -67, 82, 39, 31, -116, -40, -106, -115, -120, -112, 
	23, 28, -54, -84, 89, 22, 40, -41, 72, 16, 23, -15, 
	-80, -56, -31, 104, 104, 47, 101, -116, 109, -41, 124, 48, 
	-45, -114, -71, -57, 29, 50, 113, -66, -112, -113, -104, -116, 
	17, -65, 88, -76, -23, -112, -97, 0, -77, 78, 40, -1, 
	58, -21, 29, 71, 117, 63, -95, 72, -55, -110, -69, 17, 
	-85, -15, 10, 34, -112, -49, -96, 31, 27, -42, 89, -58, 
	62, -56, 4, 98, -103, 17, 106, 25, -75, -49, 108, -5, 
	-81, 10, 82, 40, 27, -121, -46, -4, 21, -99, 14, 125, 
	1, 78, 102, -54, 117, 51, 29, -9, -11, 29, -84, -111, 
	102, 65, -96, -116, 74, -87, -85, -74, 70, 115, -63, -41, 
	117, -104, 15, -22, -114, 4, -24, 29, -92, -124, -95, 94, 
	99, -63, 86, 37, 3, 110, 63, -15, 45, 76, 74, -97, 
	-88, 124, -27, 100, 32, -26, 2, 34, 114, 58, 66, -30, 
	-39, -117, -9, 13, 19, 62, -73, -49, -88, -69, 104, 0, 
	-121, 97, 37, -92, -47, -93, -38, -97, -41, -38, -14, -52, 
	-112, -73, 91, -102, -53, -102, 30, -112, 118, 43, -17, 58, 
	66, 62, -3, 3, -107, 58, -20, 54, 95, 30, 26, 57, 
	120, 41, -62, -98, 24, -111, -50, -56, -52, 96, 93, 69, 
	11, 31, -69, 68, 7, 10, -15, 14, -29, -122, -92, -11, 
	81, -16, 83, 25, -5, 110, 99, -6, 1, -16, -9, 33, 
	-32, -75, -127, -77, -97, -40, 17, 115, -122, 91, 33, -93, 
	39, -80, -117, -114, -66, 47, -52, -55, -115, -6, -96, -123, 
	-122, 49, -28, -103, 97, 109, 117, 30, 60, -72, 64, 96, 
	83, -92, 127, -109, -99, -90, 111, 65, -4, 32, 70, 0, 
	-82, -24, -30, 118, 6, 18, -3, 113, -76, 115, 82, 65, 
	-13, 127, 40, 53, 67, -106, -44, 28, 127, 30, -97, 93, 
	-52, -72, -19, -105, 15, 23, 88, -17, 3, -32, 61, 70, 
	15, 109, 66, -85, -17, 71, -29, 67, 93, -94, -77, -106, 
	-117, 62, 120, 50, 20, -72, 69, 61, -62, 21, -122, 46, 
	28, 65, -114, 66, 66, 44, -65, 67, 109, 62, -126, 62, 
	-26, 120, -105, 64, -53, 61, -84, -93, 41, 20, -34, 29, 
	9, -23, -15, 103, -73, 67, -82, -48, 71, -102, 60, 98, 
	121, -91, 7, -31, 12, 95, -14, 86, -31, -87, -26, -106, 
	-4, 47, -125, -64, 46, 21, 72, 110, -40, -48, 63, -51, 
	0, 45, 44, 26, -85, 90, 0, -46, 107, -81, 23, -29, 
	-81, -43, -36, 111, 93, -107, 7, -108, -109, 106, -54, -37, 
	113, -67, -102, -80, -119, -120, -66, -84, -84, -101, 27, 36, 
	88, 53, -72, 61, 3, 99, -41, 36, 25, 95, -4, -109, 
	-46, 84, -117, -124, -110, 43, 59, 37, -50, 53, 42, 71, 
	35, 9, -113, -85, -58, 90, 18, 90, 41, 62, -120, 44, 
	76, 86, 119, 102, -116, 120, 12, 35, 124, 37, 5, -66, 
	-29, 125, -63, -37, 116, -51, 10, 35, -62, 94, 4, 126, 
	106, -85, -85, -124, 92, 79, -5, -127, 81, -110, -89, -119, 
	-120, -125, 89, -72, -28, -36, -119, 75, 124, 70, 96, -73, 
	-112, -62, 32, 79, -52, -62, 112, -53, 11, -120, 88, 116, 
	17, 60, 52, 108, 1, 19, 103, -57, -28, -29, 52, 53, 
	30, -37, 12, 8, 20, 13, -123, 22, -40, 118, -94, 48, 
	38, -42, -43, 82, 76, -32, 71, -103, 20, -119, -16, -81, 
	-46, -35, 93, 78, 9, 66, 2, 126, -15, 76, -93, 51, 
	-17, 28, 48, -117, 2, 58, 103, 59, -114, 55, 123, 32, 
	67, 70, 6, 21, -46, -83, 29, -22, -118, 81, 127, 63, 
	28, 45, -65, 102, -111, 7, 118, 118, 18, -53, -14, -14, 
	-108, -67, -84, 108, 79, 82, 16, -31, -46, 123, -124, 6, 
	-14, -101, -88, 113, 120, 126, 119, -27, -43, 51, -24, -95, 
	23, 42, 122, -31, 9, 127, -98, -18, -13, -37, 71, 7, 
	66, -31, -58, -123, -120, 46, 125, 44, -102, -108, 83, 121, 
	-64, 39, -8, -77, 34, -9, -45, 53, -116, 5, 13, -16, 
	-92, 44, 77, -74, -6, 5, 20, 53, 71, -80, 102, -98, 
	-93, 68, -19, 27, 101, -18, 92, 89, -16, 4, -123, -114, 
	21, -59, 36, 127, 62, -55, -92, -64, 41, -104, -75, -35, 
	-90, -65, 112, 75, 94, -93, 106, -78, 50, -117, 28, 82, 
	-31, -22, -44, 86, -85, 34, -71, -90, 64, 85, -46, -92, 
	80, 1, 110, 6, 117, -33, -48, 118, 34, 123, 82, 83, 
	-33, -18, 109, 66, 50, -69, -89, 89, -102, -83, 55, -76, 
	27, -64, -110, -103, -9, -72, 72, 3, -49, 97, -89, 34, 
	-3, 96, 8, -17, -35, -111, -118, 116, -53, -51, 66, -66, 
	-119, 7, -56, 92, -39, -69, 77, 43, -124, 100, -122, 116, 
	-107, -111, 105, 76, -107, 19, -124, 83, 12, 19, -32, 39, 
	31, -38, -35, 38, -110, 118, 42, -30, -97, -86, 40, 22, 
	8, 23, 25, -42, -32, 115, -124, -93, 120, 108, -70, -87, 
	-96, -11, 117, 14, 80, -69, 88, -98, 53, 14, 104, -57, 
	73, -59, 102, 56, 6, 111, -15, -61, -103, 109, 62, -115, 
	-27, 120, 27, -123, -116, 66, 74, -8, 75, -87, -75, 54, 
	84, 44, 53, 19, 20, 125, -86, 80, -127, -124, 126, -118, 
	69, -125, -98, 15, -110, 126, 63, -94, -13, 44, -77, 76, 
	-73, 55, 75, 39, 77, -87, 37, 65, -31, 80, -113, -28, 
	18, -56, 9, 13, -92, 36, -20, -4, -58, -28, -51, 72, 
	94, 101, -35, 32, -79, -64, -111, 57, -59, 107, 5, 76, 
	-117, 46, 103, -101, 106, -112, 23, -18, 121, -33, 46, 108, 
	56, -64, -49, 56, -84, -85, -5, -33, -29, -10, -100, 8, 
	113, 112, -121, -91, 17, 116, -85, -102, -89, 82, 81, -1, 
	0, -123, -119, -1, -104, 46, -110, -28, -105, 61, -98, 63, 
	-79, -35, 86, -41, 80, -33, -119, 23, 82, 6, 16, 95, 
	102, -94, 42, -40, 34, -33, -78, 26, -95, 55, 39, 65, 
	54, 82, -70, -86, 58, 112, 100, 119, -84, -87, -18, 29, 
	17, -28, 34, -57, 15, 19, -107, -4, 93, -108, -115, 96, 
	36, -103, 26, 75, -56, -30, 35, 24, -115, 101, -94, 78, 
	48, 80, -66, -104, 34, -59, -103, -36, 105, -98, -109, -11, 
	86, -107, -111, -60, -67, -92, -51, -39, 32, -75, -81, 15, 
	38, 64, -53, 122, -20, 82, -53, -91, 39, 45, 91, 101, 
	100, 86, 101, 44, -119, -69, 49, 20, 20, 34, -109, -123, 
	18, -4, 39, 111, 60, 80, -121, 10, -105, -73, -76, -92, 
	-52, 41, 33, -73, -41, -22, -30, -107, -126, -29, -33, -58, 
	80, -49, 87, -95, -85, 29, 12, 102, 49, -56, -53, -101, 
	-10, 121, -25, 51, -94, -106, 80, -87, 89, 51, -101, 76, 
	10, 45, 24, 101, 24, 106, 59, 24, 1, 80, 104, 119, 
	-40, 35, 3, 89, 71, -50, 72, 107, 33, 91, -59, 124, 
	103, 19, 40, -104, -93, -10, 80, 73, -113, 43, -90, -97, 
	56, 90, 116, -25, -46, -54, 18, -52, 12, -28, 105, -40, 
	0, -2, 110, 18, 28, -73, 40, 41, -13, 45, 25, -24, 
	-121, -16, -101, 18, -100, -79, -4, -39, -38, -17, 118, 103, 
	101, -115, 110, 68, -22, -32, -115, 117, 118, -87, 48, 40, 
	18, 11, 111, -11, 46, -88, -49, 10, 58, 81, -94, 5, 
	2, 72, -106, 0, -29, 77, -62, -108, -67, -107, -73, -60, 
	124, 1, 124, 39, -102, 103, -49, 25, -4, 74, 12, -118, 
	2, 38, 115, 58, -23, -79, -36, -117, -96, -9, 84, -34, 
	23, 0, -27, -35, -96, -94, -96, 112, -64, 2, -6, -69, 
	0, -58, -89, 59, 31, 95, 40, 100, 65, 38, -11, -62, 
	-10, 67, 124, -122, -112, -25, 70, -94, 69, 112, -47, -68, 
	-93, 65, -109, -70, 104, 29, -20, -33, 65, 36, 87, -62, 
	59, -34, 82, -56, 59, -35, 17, 35, 13, 96, 97, 28, 
	99, -31, -79, 30, -110, 21, -126, 24, -64, 19, -59, -106, 
	11, -45, 41, -115, 101, -100, 23, 21, 92, -69, -42, -84, 
	32, 20, 11, 54, 20, 45, 37, 74, -72, -82, 114, -58, 
	-92, 26, -75, 28, -75, -58, -73, 69, 28, 49, 19, 5, 
	-52, -56, -3, 7, 67, -116, -54, 52, 100, 47, 0, -96, 
	-48, 35, 40, 59, -101, 53, -10, 18, -81, -88, -88, -19, 
	-108, 18, -73, -15, 21, 68, 102, 39, 36, 68, -88, -74, 
	32, -49, 33, -3, -44, 33, 23, -102, -1, 63, 109, -110, 
	77, 20, 56, 21, 15, -77, -98, 69, 88, -95, -8, -115, 
	28, -60, -85, 55, 119, 22, 106, -58, -124, -98, -116, -42, 
	-6, -15, -70, -46, -8, -57, -22, -114, 77, 81, -84, -68, 
	-33, 69, 106, -113, -22, -81, 47, -89, 50, -75, -62, -100, 
	4, 33, 84, -80, 76, -109, 76, 25, -43, -65, 121, 101, 
	16, 53, 27, -89, -30, -36, 40, -35, -66, -114, -85, -11, 
	-20, -123, -52, 96, -8, 41, -26, 36, -30, -94, -52, 78, 
	-60, 84, 79, -72, -62, -100, -16, -109, 55, -123, 8, 70, 
	-31, 32, -17, 109, 44, -16, -120, -28, -111, 97, 13, 13, 
	-12, -101, -69, -76, -61, -103, 2, 44, -108, 46, -93, -20, 
	2, -32, 77, 21, -86, 64, -56, -46, -32, -52, 42, 34, 
	-2, 42, -13, 100, 7, -76, 103, -94, 28, 55, -76, -43, 
	-105, 20, 81, 45, -13, -126, 46, 102, -55, 41, -34, 61, 
	91, 121, -64, -74, -97, -113, 27, 103, -79, 0, -6, -99, 
	-43, -63, -88, -37, 114, 105, -32, 113, 55, 26, 31, 98, 
	55, -19, -80, 114, -109, 72, 37, -32, -49, -90, -110, -106, 
	-47, -38, 52, 57, 118, 111, 43, 68, -5, 67, 122, -4, 
	40, -102, -99, 86, -57, 51, 54, -119, 14, -69, -65, 35, 
	52, -72, -4, -68, 5, -6, -79, 86, 43, -30, -58, -71, 
	-28, 2, -116, -118, -32, 102, 50, 77, 50, -11, -78, -83, 
	72, -62, 53, -124, -25, 98, 117, -44, -101, -65, -72, -71, 
	61, 58, 51, 81, 52, -93, -101, -49, 20, -40, 108, -17, 
	-38, 44, -82, 75, -19, 3, -86, -23, 94, 52, 111, -18, 
	19, -78, -113, -62, 1, 106, -80, 111, -68, -50, -96, -32, 
	-104, -110, -20, 72, -58, 62, 89, 55, 111, -39, -115, -45, 
	101, -29, -27, 59, 45, 33, 11, 30, 35, -6, 122, 25, 
	53, 20, 72, 44, 51, -45, -14, 111, 10, -73, -36, -38, 
	83, 52, -45, 94, 23, 121, -115, -24, 98, 46, -30, 12, 
	78, 86, -26, -53, 78, -24, 2, -56, -56, 122, -79, 126, 
	119, 76, -16, -124, 55, 6, 44, 1, -100, 78, 87, -52, 
	17, 36, 84, 5, 91, 40, -37, 65, 7, -55, -98, -35, 
	119, 27, -98, -30, -68, 26, -84, -122, 
        };

#endif /* WHITENOISE8192_H_ */
