#ifndef PINKNOISE8192_H_
#define PINKNOISE8192_H_

#include <Arduino.h>
#include "mozzi_pgmspace.h"

/* generated pink noise
*/

#define PINKNOISE8192_NUM_CELLS 8192
#define PINKNOISE8192_SAMPLERATE 8192

CONSTTABLE_STORAGE(int8_t) PINKNOISE8192_DATA []  =
        {
                -27, -51, -55, -63, -69, -29, -48,
                -46, -37, 4, -40, -6, 12, 17, -34, -22, -30, 0, -33, -18, 19, -14, -4, 29, -26,
                -2, 28, 27, 40, 19, 41, 25, 11, -27, -11, -13, -30, -38, -56, -23, -59, -40,
                -43, -63, -79, -45, -62, -64, -42, -72, -59, -55, -30, -68, -25, -45, -46, -34,
                -11, 19, 4, 21, -9, 24, -19, -33, -6, 9, 29, 37, 42, 18, -24, -37, -5, -47, -5,
                -27, -24, -11, -16, 13, 14, -26, 1, -8, -34, 7, 5, 16, 36, 43, 12, 34, 44, 45,
                13, -18, -13, 17, 5, -29, 22, 16, 37, 53, 36, 5, -2, -24, -11, 16, 7, 30, 24, 6,
                -11, 6, -12, 23, 46, 44, 66, 13, -11, 25, -12, 15, 8, 25, 20, 43, 44, 8, -24,
                -13, 7, 45, 58, 48, 56, 11, 30, -4, -12, 14, 52, -5, 33, 29, 20, -4, 16, 40, 19,
                51, 74, 22, -10, 41, 11, -19, -16, 2, 10, 23, 18, 14, 0, 43, 68, 30, 23, 20, -8,
                39, 6, 27, 43, 51, 6, -13, -34, 8, 1, -4, -30, -20, 16, 28, 30, 13, -17, -22,
                -45, -16, -31, -17, -29, -31, -61, -71, -34, -13, -1, -22, 11, 37, 20, 15, -12,
                3, -22, 2, 9, 26, 45, 19, 16, -13, -26, -38, -48, -12, -3, -25, 13, -19, 8, -28,
                -1, -12, -44, -44, -36, -10, -45, -29, -60, -34, -52, -63, -26, -66, -83, -24,
                -25, -48, -4, 18, -10, -45, -56, -67, -17, -24, -15, 3, -25, -1, -48, -60, -67,
                -89, -90, -106, -45, -44, -21, -68, -42, -59, -30, -27, -25, -41, -59, -33, -59,
                -31, -43, -47, -29, -68, -71, -85, -90, -64, -93, -110, -105, -95, -66, -47,
                -40, -56, -24, -11, -22, -41, 1, -28, -53, -39, -64, -57, -80, -78, -75, -27,
                -22, -27, -58, -55, -18, -12, -21, -12, -29, -33, -48, -66, -72, -52, -25, -46,
                -19, -23, -59, -55, -16, 4, 3, -37, -64, -59, -18, -21, 9, -44, -50, -63, -43,
                -68, -59, -27, -59, -56, -24, -17, -16, -33, -29, -18, -62, -43, -69, -40, -53,
                -32, -53, -79, -35, -38, -35, -38, -41, -64, -80, -97, -40, -38, -42, -51, -29,
                -67, -73, -56, -20, -56, -10, -40, -22, -14, -35, 3, 21, -27, -48, -74, -86,
                -36, -57, -49, -16, -28, -28, -58, -67, -44, -5, 3, -5, 23, 35, 17, -26, -46,
                -34, -54, -72, -40, -58, -30, -10, -50, -27, -4, -14, -27, 3, -3, -5, -42, 0, 5,
                -7, -47, -52, -9, -36, -65, -37, -2, -16, -18, -49, -67, -88, -95, -81, -75,
                -32, -31, -72, -37, -40, -36, -1, -37, -70, -27, -63, -38, -14, -22, 3, -29,
                -40, -57, -78, -39, -2, -5, -36, -28, -31, -33, -4, -5, -26, 7, -28, 10, -23,
                18, -13, -35, 6, -6, 1, 23, -14, -27, -36, -11, -10, 4, -9, -30, -51, 3, 5, 1,
                32, -12, 0, -37, 2, -8, -23, 4, 9, 32, -6, 27, 36, 0, 8, -9, -26, -14, -30, 3,
                12, -5, 26, 35, -3, 25, 53, 1, -17, -19, -20, -51, -43, -69, -80, -87, -80, -33,
                -1, -53, -76, -81, -99, -96, -104, -80, -57, -68, -64, -91, -68, -91, -63, -65,
                -84, -49, -45, -18, -29, 3, 22, -14, -36, -62, -16, -8, -18, 9, 18, 38, 3, -13,
                5, -41, -34, -35, -49, -44, -5, -54, -10, -1, -11, -47, -45, -56, -61, -44, -66,
                -87, -76, -88, -85, -66, -23, -38, -46, -63, -30, -58, -37, -48, -36, -40, -44,
                -64, -14, -52, -20, -2, -15, 17, 37, 7, 39, 14, -24, -38, 7, 3, 9, 38, -22, -37,
                -46, -50, -10, -2, -34, -9, 7, -11, -43, -54, -26, -52, -2, -41, -69, -36, 0,
                -53, -74, -22, -5, 16, -40, 8, -18, -21, 12, 10, 32, 34, 25, 40, -11, -10, -44,
                -39, -31, -24, 15, -4, -41, -14, -20, -23, -46, -72, -89, -36, -56, -68, -42,
                -26, -25, 7, -12, -9, -21, -40, 5, 2, -9, -22, -58, -61, -13, -54, -63, -25,
                -52, -20, -53, -34, -2, -34, -44, -66, -44, -59, -67, -74, -63, -39, -21, -1,
                -2, -4, 9, -15, -53, 0, 12, -17, 8, 7, 35, -21, -32, -45, -28, -21, -55, -71,
                -23, -21, -41, -33, -10, -6, 24, -2, -21, 1, 24, 27, 42, 34, 29, 56, 67, 66, 31,
                37, 0, -6, -25, -39, -53, 5, -34, -59, -78, -84, -55, -26, -25, -16, -57, -39,
                -67, -35, -68, -58, -47, -55, -54, -38, -25, -23, -18, -27, -55, -4, -50, -15,
                -49, -78, -22, 2, -51, -47, -69, -58, -60, -81, -47, -49, -75, -56, -45, -36,
                -8, 16, -8, -21, -49, 0, -19, -30, 1, 2, -29, -58, -49, -36, -25, -25, -40, -26,
                -65, -71, -89, -47, -20, -27, -33, -2, 12, 16, -9, -4, 12, -25, -53, -56, -72,
                -45, -76, -93, -58, -38, -60, -74, -84, -106, -115, -126, -97, -85, -73, -80,
                -104, -103, -97, -47, -49, -50, -84, -38, -35, -35, -14, -33, -54, -13, -13,
                -52, -26, -22, -54, -26, 4, -47, -72, -58, -84, -101, -48, -53, -14, 3, -6, 13,
                -31, -43, -2, 19, 6, -37, -35, -1, -43, 5, -26, 11, 25, 20, 8, 16, -22, -41,
                -12, -4, -14, 17, 6, -24, 7, -17, -9, 12, 38, 17, -4, 25, 0, -13, 18, -26, -8,
                -17, 1, -40, -23, 18, -20, -22, -55, -28, 2, -14, -15, -17, -46, -10, -7, -26,
                -3, -21, -18, 0, 31, 6, -23, -40, 11, -12, -8, 1, -26, -1, 24, 23, 12, 6, 11,
                22, 33, 27, 40, 63, 23, -11, 30, 58, 9, -25, 32, 23, -17, 20, 37, 51, 34, 28,
                53, 46, 53, 16, -18, -17, -40, 10, 8, 23, 18, -14, 18, 24, 22, 31, 38, -2, 38,
                33, -1, 13, -21, -38, -52, -7, -31, 19, 25, 50, 67, 18, 25, 18, -10, -13, -21,
                18, -9, -7, 17, 38, 24, 55, 23, 3, -10, 31, -4, 11, 13, -22, -33, -29, -45, -22,
                0, -41, -54, -18, -52, -49, -23, -43, -57, -71, -77, -64, -38, -52, -83, -72,
                -84, -95, -99, -67, -69, -45, -62, -34, -37, -33, -20, 10, 7, -9, -40, -27, 8,
                -1, -7, -14, 15, -9, -35, -46, -38, -29, -36, -24, -45, -26, 2, -12, -31, -64,
                -35, -3, -5, 7, 29, 26, 16, 21, 21, 6, -17, -44, -63, -23, -34, -32, -52, -9,
                -1, 26, 2, -38, -26, -53, -48, -69, -35, -42, -43, -59, -41, -49, -37, -71, -63,
                -77, -64, -30, -26, -61, -37, -33, -50, -33, -53, -40, -72, -44, -9, 11, -9,
                -20, -37, -61, -24, -24, -36, -67, -16, 0, 26, -33, -21, 2, -24, -60, -62, -18,
                -24, 0, -1, 6, -32, -34, 11, -40, -59, -23, 10, -4, -8, -1, 21, 41, -8, -22,
                -39, -16, -34, -25, -20, -44, -59, -30, -56, -54, -56, -80, -21, -33, -58, -25,
                -48, -25, 0, -28, -38, -17, -54, -38, -34, -46, -24, -45, -39, -19, 15, -18, 11,
                -6, -19, -37, -22, -50, -53, -20, -47, -11, -55, -38, 2, -8, -6, 24, 16, 43,
                -17, 14, 24, 22, 33, -16, -35, 18, -6, 8, -23, 11, 18, -3, 27, -4, 31, 15, -13,
                1, 17, 21, 10, 24, 46, 24, 16, -23, -30, -43, -50, -3, 18, -31, -57, -72, -73,
                -43, -16, -50, -63, -65, -57, -65, -84, -87, -38, -9, -9, -29, -45, -33, -61,
                -8, -7, -43, -10, 10, 6, 27, 20, -29, -6, -29, -13, -40, -13, -14, 15, -33, -28,
                -50, -26, -20, -59, -52, -66, -74, -23, -67, -70, -82, -28, -66, -72, -71, -21,
                -2, -10, 13, -3, 18, -8, 14, -21, -28, -53, -44, -39, 3, -23, 18, -34, -4, -34,
                -52, -17, 16, 22, 3, -34, -9, -9, -30, -17, -10, 5, 2, -29, -40, -42, -19, -39,
                -34, 6, 20, -6, -33, -2, -39, -58, -32, -30, -23, -7, 18, -32, -35, -10, 11,
                -39, -26, 17, -3, -24, -34, -54, -77, -31, -14, -17, -43, -72, -29, 2, 26, 20,
                -30, -48, -17, 1, -24, -38, -1, -31, 14, -16, -32, -57, -22, 5, 32, -14, 22,
                -29, -36, -17, -14, -34, -13, -33, 4, 1, 29, 30, 32, 47, 52, 52, 26, 41, 30, 45,
                16, 5, 38, -2, -1, -26, -18, -9, -18, 10, -8, -1, 2, 19, 21, -1, 26, 55, 60, 18,
                -11, 18, -17, 17, -23, -42, -30, -13, 24, 41, 16, 9, 26, -20, 22, 43, 59, 76,
                36, -4, -13, 27, -15, -28, 1, -3, -19, 17, 28, 39, -11, -33, 1, -4, -26, -3, 10,
                -22, 4, 39, 4, 34, 26, -17, -34, -14, -26, 3, 12, 31, 37, 61, 16, -20, 24, 55,
                23, 35, 57, 73, 24, -12, -15, 0, -35, 22, 33, 29, 18, 13, 14, 50, 43, 69, 52,
                36, 57, 61, 14, -8, 46, 15, -10, -16, 9, 22, 36, 22, 3, -25, -11, 14, -11, -24,
                -49, -22, -42, -27, 3, 14, 42, 15, 4, 41, 19, 56, 3, 5, 14, -12, 8, -11, 4, -10,
                7, 16, 20, 16, 30, 34, 47, 73, 33, 58, 6, -10, 4, -22, 32, 26, -18, -20, -30,
                19, -17, 4, -24, -38, -6, -22, -21, -3, 3, 24, 50, 29, -3, 18, 35, 14, 32, 2, 2,
                -20, -41, -60, -8, -19, -43, -37, -50, -73, -24, -57, -41, -42, -44, -50, -80,
                -29, -47, -79, -73, -48, -33, -70, -18, -6, -18, -26, -42, -38, -23, -14, -16,
                18, -33, -41, -68, -78, -22, -16, -10, 18, -23, -16, -18, -49, -34, -16, -58,
                -28, -29, -19, -29, -4, -32, -27, -32, -41, -59, -70, -24, -46, -30, -23, -27,
                -60, -47, -22, -59, -31, 1, -27, -10, -25, -16, 18, -32, 13, -14, -1, 19, 8, 36,
                41, 59, 59, 49, 36, -4, 11, 50, 9, 21, -12, 2, -17, -33, 12, 12, -7, -39, -29,
                -47, -5, 15, -11, -11, 16, 2, -17, 0, -10, 13, 36, 49, 37, 30, 5, 45, 47, 57,
                31, 12, -17, -22, 13, 36, 50, 18, 0, -15, -2, -21, -38, 18, 30, 6, 2, 3, 29, 7,
                20, 10, 4, -18, -12, -31, 20, 19, 22, 41, 33, 56, 55, 24, -2, 8, 35, 16, -2, 15,
                50, 50, 45, 21, 7, -21, -35, -48, 3, 9, 15, 3, -2, 31, -7, -16, 4, -27, -49,
                -31, -54, -57, -17, -51, -65, -56, -79, -32, -63, -63, -65, -78, -62, -84, -95,
                -100, -70, -91, -108, -48, -25, 1, -39, -38, -15, 14, 5, 19, 33, 50, -6, -24, 1,
                -7, -7, 27, -15, 29, 36, 26, 40, -3, 7, -16, 2, -35, 15, 26, -12, -12, -41, -63,
                -8, 11, 14, 44, 0, 18, 18, 22, 2, -16, -25, 11, 10, -9, 5, -38, -25, -47, -56,
                -2, 15, 20, 34, 11, 12, 33, 15, 21, 6, -17, -17, 0, -20, 7, 14, -11, -6, 15, -3,
                -26, -11, 7, -29, 17, -23, -33, -61, -74, -34, -42, -18, 15, -18, -4, -45, -16,
                16, 21, 41, -12, 24, 34, 0, 10, -18, 27, -24, 5, 20, -6, -15, 24, 9, -3, -6,
                -36, -13, 10, 16, -30, -52, -36, -46, -62, -42, -68, -24, -48, -67, -40, -50,
                -46, -40, -30, -12, -40, -11, -42, -63, -9, -44, -73, -53, -77, -73, -44, -35,
                2, -46, -45, -57, -34, -26, -66, -42, -17, 4, -17, -16, 17, -12, -7, 7, -8, -35,
                13, 36, 12, 26, 13, 30, 39, -14, 32, 33, 59, 4, -20, -31, -28, -38, -46, -13,
                15, -3, 29, 7, 22, 36, 44, 33, 56, 61, 54, 59, 19, 51, 72, 88, 68, 25, 32, 53,
                12, -14, 0, -2, 20, -17, -4, 4, -2, -27, -45, -65, -1, -32, -37, -61, -77, -74,
                -38, -16, 8, -40, -43, -45, -71, -29, -42, -30, -16, -20, -5, -7, -32, -44, -56,
                -66, -41, -2, 15, 9, 26, 16, -3, 22, 15, 30, 54, 17, -16, -2, 14, -2, -6, 4,
                -10, 19, 41, 7, 13, -16, -16, 24, -25, 17, -13, -38, -3, 26, 45, 64, 52, 4, 37,
                59, 24, 1, -10, -16, 23, 17, -22, -14, -32, -14, -29, -29, -44, -5, -31, -18, 6,
                -24, -35, -39, -11, 11, -22, -35, -44, -14, -20, -5, -4, -28, 15, -34, 0, 10,
                17, 5, -7, -21, 11, -22, -41, 12, 37, -9, 11, 14, 31, 49, 28, 39, 27, -9, -25,
                21, 51, 27, -3, 42, 62, 74, 79, 19, 33, 58, 25, 27, 64, 37, 3, -17, -8, -38, -9,
                23, 24, -6, 7, -17, 14, 26, 54, 23, -9, 4, -33, -23, -52, 5, 29, 34, 13, 30, -8,
                34, 21, 4, -12, -25, -39, -54, -46, -65, -53, -53, -62, -9, -54, -21, -39, -3,
                24, -10, 0, -16, -23, -19, -50, -65, -31, -10, -12, -38, -4, -6, -16, -20, -22,
                -43, -21, -50, -36, -46, 1, 23, 27, -24, 21, -18, 18, 29, -2, -1, 20, 30, -6,
                30, 17, -23, -34, -32, 16, 27, 18, -11, 25, 25, 30, 22, 56, 2, 42, 20, 2, 36,
                57, 49, 39, 40, 56, 66, 87, 46, 49, 61, 65, 32, 45, 31, 31, 69, 50, 71, 90, 98,
                101, 59, 24, 46, 65, 85, 75, 49, 84, 83, 106, 82, 108, 119, 125, 114, 93, 53,
                32, 17, -1, 48, 40, 60, 19, 58, 74, 83, 65, 86, 88, 48, 39, 47, 31, 12, 9, 51,
                72, 51, 20, 19, 12, -3, 14, 20, 32, 20, 18, 2, -20, -20, -2, -12, -31, -15, -1,
                12, 11, 12, 34, 5, -11, 7, -26, -50, -5, 21, 6, -34, -55, -39, -1, 23, 37, -3,
                -4, -11, -15, -32, -15, -46, -7, 4, 10, 39, -8, 7, -14, 9, 26, 50, 25, 39, 65,
                39, 30, 33, 51, 61, 28, 15, 51, 19, -7, 42, -1, -17, -10, -18, -28, -27, -8,
                -22, 16, -32, 16, -10, -18, 26, 22, 14, -13, -15, 23, 16, 38, -10, 32, 17, 45,
                26, -10, 25, 32, 1, 8, -30, -47, -37, -37, -52, -65, -31, -2, -49, -32, -36,
                -24, -41, -51, 0, 19, -3, -10, 26, 44, 6, -31, -1, 24, 24, 5, 40, 23, -13, -28,
                -38, 9, 10, 26, 12, 18, -22, 14, -10, 10, -13, -16, 24, 18, 12, -20, 7, 37, 46,
                67, 47, 58, 66, 25, 3, 45, 5, 0, -1, 22, 18, 43, 67, 30, 43, 13, 58, 70, 35, 6,
                31, 2, -8, 31, -8, -6, -17, -35, -54, -20, -40, -8, 21, -7, -3, -8, -32, -58,
                -65, -23, 17, -33, -1, -2, -10, -47, 1, 33, 6, -19, -20, -21, -28, -27, -35,
                -53, -21, -20, -28, -48, -2, -18, -23, -9, -14, 15, -12, -37, -35, -3, -18, -16,
                -48, -41, -8, 4, -19, 22, 30, 24, 10, -18, -43, -7, -15, 8, -9, -25, -52, -32,
                -37, -52, -43, -3, -31, -38, -62, -22, -22, -19, -44, -73, -36, -66, -39, -11,
                -41, -34, -36, -38, -36, -12, -26, -63, -53, -27, -51, -17, -19, 4, 16, -21,
                -30, -58, -54, -5, -3, 22, -6, 7, -18, -50, -29, -32, 11, -41, -17, 2, -9, 4,
                28, -23, 7, -34, 17, 0, -32, -52, -61, -12, -13, 3, -33, -46, -51, -24, -50,
                -71, -77, -82, -31, -50, -55, -61, -34, -20, -33, -50, -56, -9, -53, -35, -22,
                -5, -2, -38, -48, -12, 15, 29, 44, 8, -18, -35, -45, 1, -47, -41, -41, -62, -14,
                -43, -24, -48, -73, -16, -9, 5, -46, -64, -29, -30, -16, -61, -72, -54, -81,
                -29, -55, -73, -69, -78, -92, -56, -82, -90, -49, -50, -68, -78, -34, -22, 2,
                -19, -11, 14, -35, -23, 5, -7, -24, -18, 1, -20, -55, -25, -22, -9, 8, -23, 19,
                -35, -36, -62, -16, -8, -24, -31, -60, -46, -9, 5, -19, 6, -30, 13, -34, -48,
                -44, -57, -17, -58, -11, -2, -44, -32, -53, -16, 7, -23, -9, -20, -30, -6, -47,
                -14, -58, -45, -65, -26, -64, -35, 0, 17, 17, 29, 10, 33, 54, 18, -12, -32, 10,
                -36, -24, -38, -39, -5, -38, -13, -34, -56, -53, -66, -75, -23, -63, -41, -78,
                -55, -41, -5, -23, -55, -72, -16, -65, -63, -74, -47, -16, -16, -46, -67, -74,
                -80, -88, -39, -67, -54, -55, -18, -17, -17, -11, -13, -31, -26, -10, 10, 27,
                29, 24, 35, 44, -6, -6, 24, 13, 16, 23, 46, 41, 61, 20, 47, 30, 40, 5, -8, 24,
                -8, 40, -8, 7, 25, 16, 22, 20, 54, 42, 44, 6, 44, 66, 62, 75, 31, 53, 74, 52,
                83, 58, 74, 64, 55, 21, 32, 20, 39, 59, 53, 32, 27, 19, 60, 12, 37, 25, 20, 29,
                58, 8, 37, 54, 63, 64, 32, 40, 16, 31, 41, 16, 51, 75, 74, 85, 59, 42, 77, 98,
                85, 93, 39, 40, 80, 49, 54, 19, 54, 61, 16, 14, 61, 25, 36, 26, 30, 18, 27, 24,
                43, 17, 60, 61, 71, 22, 19, 33, 39, 58, 43, 71, 47, 84, 73, 70, 26, 74, 51, 12,
                43, 27, 47, 24, 42, 49, 80, 100, 41, 64, 23, 27, -3, -9, -26, 10, 10, -19, -31,
                -22, -29, -15, -7, 14, -23, 20, 17, 32, 10, -12, 15, 19, 49, 29, 8, 26, 57, 48,
                54, 25, 35, 34, 39, 70, 75, 82, 49, 26, 32, 15, 39, 7, -22, 26, -12, 1, 39, 20,
                40, 61, 24, 16, -5, 40, 27, 62, 15, 38, 15, 4, 12, 33, 38, -8, 25, 4, 15, 45, 5,
                5, 3, 14, -5, -11, 37, 31, 7, 17, -23, -44, -19, 14, -14, -36, -52, -36, -46,
                -48, -59, -3, -17, -48, -52, -66, -62, -15, 14, 23, 18, 26, 3, -11, 32, -4, 24,
                3, -11, -39, 8, -5, 13, 29, -16, -13, 22, 23, 12, 4, 36, 62, 49, 54, 71, 90, 63,
                67, 16, 58, 73, 79, 46, 58, 73, 32, 46, 43, 72, 35, 73, 39, 6, 23, 16, 18, 55,
                45, 40, 64, 61, 52, 55, 73, 54, 77, 82, 84, 85, 73, 35, 79, 26, 36, 71, 63, 92,
                40, 49, 78, 102, 81, 32, 83, 100, 79, 70, 82, 42, 45, 46, 17, 61, 46, 12, 34,
                26, 30, -1, -20, -24, -28, -18, -7, 27, 40, -1, -28, -17, -9, -17, -1, -14, -13,
                15, 17, -18, 30, 46, 1, -28, -33, -39, 7, 21, -27, 8, -14, 14, 24, -1, 39, 28,
                -1, -26, 10, 33, -18, 12, -20, -33, -40, -8, -31, 1, 19, -22, -5, -17, -44, -58,
                -52, -55, -64, -64, -61, -44, -33, -63, -43, -21, -28, 3, -21, -59, -36, -46,
                -57, -78, -27, 7, -31, -5, -4, -19, 11, 5, -10, 6, -3, 11, 22, 31, -5, -19, -1,
                -19, 11, 10, -18, -23, -20, -44, 7, 26, -29, -54, -29, 4, 3, -1, -28, -30, 16,
                26, 0, 15, 43, 56, 56, 47, 38, 61, 67, 13, 31, 3, -26, -8, -19, -3, 34, 33, 40,
                54, 60, 57, 20, 48, 10, 10, 51, 61, 40, 16, 13, 39, 10, -10, 30, 33, 8, 2, -24,
                0, -26, -36, 13, -20, -12, 10, 24, -25, 23, 45, 22, -17, 32, 59, 4, 19, 28, 45,
                3, 0, -23, -28, 6, 36, 9, -9, -16, -2, 31, 15, 9, 37, 41, 0, 42, 29, 3, -26, 25,
                17, 51, 0, 16, -9, 12, 36, 8, -25, 21, 2, 42, 50, 64, 84, 67, 68, 50, 28, 2, 32,
                -11, -28, -4, -19, -41, -47, -14, 15, 4, 0, -3, -18, 19, 2, -8, 16, 20, -1, 23,
                33, 10, -24, -39, -16, -40, 6, 34, 15, 6, 21, -8, -31, -39, 5, 11, 2, 22, 3, -7,
                -13, 11, 9, -22, -16, -6, -23, 22, -7, 11, 27, 37, -14, 29, 23, 16, -8, -34,
                -26, 20, 0, 19, 38, 18, 30, 20, 4, -19, -34, -44, -54, -62, -3, 0, 32, 21, 32,
                11, 10, 9, 24, 38, 7, 36, 20, 51, 16, 1, -29, 3, 2, 35, -6, -32, -15, -11, 9,
                -27, 12, 21, -27, -20, -44, -40, -8, -12, -33, 11, -23, 22, -20, -50, -26, -20,
                -12, -50, -44, -49, -38, -20, -27, -3, 19, 37, 5, -8, -18, -47, -48, -30, -63,
                -57, -44, -2, -53, -47, -47, -53, -27, -52, -15, -24, -30, -60, -37, -18, 7, 12,
                -13, -13, -41, -67, -37, -47, -8, -21, -11, 3, -45, -54, -42, -55, -23, -10, 13,
                -32, -54, 1, -13, -31, -8, -23, -5, -39, -10, 7, -15, -5, 16, -35, -44, -54,
                -49, -65, -36, -19, -53, -26, 7, 21, 32, -5, -31, -5, -15, 20, 36, 17, 0, 36,
                56, 72, 84, 95, 88, 100, 63, 95, 100, 83, 32, 71, 37, 44, 40, 69, 16, 20, 53,
                53, 14, 56, 9, 46, -2, 19, -9, 7, 25, 48, 39, 64, 58, 68, 26, 59, 52, 28, 52,
                24, 43, 24, -11, 25, 25, 45, 16, -1, 45, 43, 74, 60, 76, 84, 77, 101, 115, 96,
                103, 114, 62, 97, 43, 73, 89, 63, 61, 38, 23, 25, 38, 66, 74, 45, 86, 59, 30,
                17, -9, 44, 64, 53, 8, 7, -17, 3, 38, 61, 6, 28, -4, -17, 12, 47, 22, 31, 32,
                13, 26, 6, 13, 10, 33, 19, 51, 14, 13, 29, -2, 21, -8, 38, 44, 5, 25, 39, 2, 18,
                52, 19, 31, 18, 30, 55, 10, 15, 30, 49, 52, 21, 52, 37, 7, 57, 64, 44, 25, 20,
                62, 34, 27, 31, -7, -22, -2, -27, 10, -13, 14, 12, 27, 43, 46, 52, 75, 56, 42,
                45, 67, 74, 85, 99, 93, 43, 16, 19, 36, 48, 61, 39, 62, 39, 72, 53, 50, 86, 58,
                56, 54, 12, 61, 36, 51, 11, 20, 11, 20, 14, 35, 57, 57, 81, 38, 61, 84, 103, 52,
                29, 14, -10, 35, 65, 28, 4, 4, -10, 26, 11, -5, 25, 35, 57, 7, -10, 24, 21, 60,
                39, 68, 63, 89, 81, 62, 67, 29, 33, 67, 35, 34, 15, -1, 33, 35, 1, 45, 72, 67,
                26, 64, 26, 15, 7, 40, 17, 29, 19, -10, 15, -19, -3, 33, 46, -5, 17, 18, -6, 7,
                25, -2, 35, 15, 48, 68, 24, -7, 12, 52, 49, 26, -2, 23, -16, -12, -20, -28, -3,
                31, 1, 11, -29, -51, -1, -17, -15, -43, 1, -43, -8, -41, -26, 17, 29, 6, 16,
                -14, -7, 9, 25, 54, 25, 3, 48, 55, 44, 36, -6, -10, -5, -22, 6, -19, 9, 37, 35,
                -1, 44, 57, 0, 0, 14, -14, -36, -8, -16, -15, -47, -21, 7, 33, 24, -13, -35,
                -10, -32, -54, 6, 25, 1, -21, -11, 10, 33, -4, 6, 23, 38, 53, -2, 16, -22, 32,
                -10, -3, -37, -41, -20, -5, -17, -19, -3, -40, -7, 22, 7, -33, 12, 20, 19, -12,
                10, 35, -18, 14, 30, 5, 16, 23, 41, 29, -3, 21, 42, 35, 1, -11, 21, 24, 5, 41,
                0, 40, 26, 51, 64, 77, 81, 79, 43, 19, 61, 49, 72, 45, 13, 51, 20, -11, 23, -13,
                -31, -7, 16, 25, 58, 34, 28, 63, 80, 84, 90, 71, 31, 54, 56, 49, 55, 13, 32, 18,
                16, 36, 48, 26, 6, 37, 56, 30, 9, 26, 40, 47, 20, 43, 66, 10, 7, -22, -1, 22,
                14, -24, -36, -16, -46, -46, -64, -39, -7, -6, -22, -3, -17, 20, 9, 32, 52, 2,
                14, 19, -8, 30, -16, -36, -29, -41, -34, -64, -17, -6, 8, -38, -28, 14, 1, -18,
                -12, -48, 5, -12, -36, -15, -54, -30, -18, 10, 16, 19, -2, -4, -21, -7, -18, -1,
                29, 10, 46, 14, 10, 17, -19, -26, -4, -32, 20, -21, 26, 27, -19, 17, 19, -12,
                -4, -24, 18, -10, 14, -13, -39, -19, -51, -11, -50, -45, -11, 6, -39, -53, -63,
                -60, -78, -29, -31, -33, -61, -33, -21, -63, -54, -48, -5, -5, -24, -15, 12,
                -12, 20, 14, 30, -2, -38, -51, 3, -21, -26, -23, 19, 21, -10, 33, 30, 30, -12,
                9, -8, -30, -51, -28, -1, 10, 29, 30, 17, -26, 6, -19, -36, -44, -39, -25, -49,
                -53, -48, -73, -47, -18, -16, -22, -15, -47, -56, -17, -9, -39, -25, -24, 14,
                -39, -29, -58, -47, -64, -82, -62, -39, -72, -69, -55, -66, -30, -23, -33, -57,
                -76, -88, -85, -53, -25, -68, -17, -63, -89, -94, -43, -40, -36, -55, -70, -28,
                -41, -62, -40, -43, -20, -68, -45, -21, -5, 16, 35, 30, 47, -6, -28, -32, -60,
                -11, -37, -29, -24, 6, 1, 14, -31, 8, 1, -15, -50, -46, -4, 22, -35, -59, -7,
                -12, -4, -24, -31, 12, 5, -26, -34, 10, 33, -20, -34, -40, -59, -3, 17, 36, -11,
                -6, -36, -42, -25, -15, -4, -45, -38, -10, -21, -50, -65, -40, -73, -49, -58,
                -44, -17, 10, 15, 15, 8, 12, 36, 13, -7, 1, 20, 28, 55, 52, 9, 46, 27, -5, 17,
                37, 53, 40, 44, -2, 27, 20, 18, 54, 72, 57, 45, -1, 29, 56, 34, 41, 58, 21, 45,
                52, 4, 48, 26, -10, 25, 45, 71, 56, 28, 28, 64, 52, 65, 54, 73, 40, 38, 8, 57,
                13, 8, 5, 21, 39, 70, 89, 62, 40, 69, 43, 17, 33, 30, -8, 31, -6, 39, 49, 32,
                30, 54, 60, 65, 34, 7, -12, -33, -28, -23, -5, 33, -9, 11, 48, 61, 53, 34, 51,
                25, 44, 35, 8, 46, 63, 25, 7, 25, 58, 15, 52, 24, 57, 31, 61, 75, 81, 67, 22,
                63, 50, 64, 81, 74, 33, 79, 99, 68, 101, 72, 98, 69, 43, 85, 32, 37, 74, 38, 61,
                75, 101, 68, 67, 29, 44, 56, 42, 65, 37, 77, 40, 10, 47, 54, 41, 6, 16, -8, 8,
                3, 7, 6, -25, 19, 11, 11, -8, 24, 49, 27, 13, 53, 32, 52, 19, 57, 52, 51, 83,
                30, 9, -10, 46, 45, 29, 41, 35, 63, 59, 22, 58, 55, 78, 29, 39, 65, 44, 15, -7,
                28, 25, 37, -6, -28, -20, -31, 16, 40, 39, 39, 27, 16, 20, 50, 71, 49, 31, 60,
                56, 40, 16, 18, 27, 59, 18, -3, 0, -15, -31, -46, -48, -1, -42, -5, -44, -63,
                -77, -36, -30, 7, -37, -62, -45, -36, -16, 5, -24, -48, -36, 6, -23, 5, 2, -27,
                -24, -23, 8, 18, 3, -7, 19, 13, 44, 24, 26, 22, 9, 21, -9, 7, 13, -25, -2, 7,
                21, 52, -7, -5, 30, 29, -8, -20, 19, 3, 2, 36, 51, 68, 28, 26, -6, -14, -23,
                -47, -55, 5, -37, -15, 11, -9, 22, -4, -7, -36, -3, 5, 9, -16, -44, -33, -33,
                -41, -48, -64, -51, -63, -29, -56, -11, 0, 10, -33, 14, 11, 35, 49, 54, 61, 7,
                1, 12, 22, -5, 40, 11, 6, 8, -3, 17, -17, 16, 36, 54, 48, 38, -4, -27, -21, -37,
                -3, 26, 23, -2, 5, -10, 17, 18, 15, -19, -43, 12, 1, -38, -35, -29, 0, 22, 14,
                37, 35, 22, 37, 44, 66, 25, -2, -28, -5, 11, 1, 7, 14, -3, -6, -7, 7, 29, -18,
                -16, -34, 19, 12, 27, 35, 31, -4, -21, -30, 23, 11, 37, 47, 69, 40, 25, 18, 17,
                7, 1, 3, 29, 35, 1, 31, 58, 53, 30, 53, 53, 54, 23, 35, -5, 23, 54, 64, 23, 51,
                25, 19, 9, 21, 13, 48, 9, 38, 58, 33, 27, -1, 45, 4, -18, -9, 10, 32, 51, 62,
                26, 47, 2, 26, 33, 22, 18, -3, -16, -34, -20, -33, -29, -10, -39, -19, -2, 18,
                41, 2, 19, -10, -40, 2, -4, -9, 29, 21, -14, -19, -21, -5, 34, 0, 10, -10, 10,
                -24, 12, 3, -29, 11, -26, -33, 11, -27, -10, 21, 20, 30, 26, 17, 9, 16, -18, 15,
                41, 51, 42, 13, -17, 19, 33, 0, 4, 40, -13, -28, 2, -21, -46, -21, -50, -26, 6,
                -2, 12, 12, -17, -11, -33, -54, -19, 14, -33, -16, -20, -52, -38, 7, 25, 22, 31,
                -1, -17, -12, -22, 5, 19, 34, 58, 74, 10, 44, 68, 71, 18, 2, 46, -1, 47, 59, 54,
                15, 12, 4, -1, 13, -23, 0, 25, -6, 19, 45, 13, 24, 46, 53, 72, 57, 22, 13, -11,
                -19, 29, 52, 8, -20, -16, -12, -37, 9, -11, 20, 22, 12, 49, 8, 50, 3, -14, -19,
                7, 10, -4, -17, -2, -29, -36, -12, -12, 28, 22, 16, -2, -20, -8, -11, -2, -22,
                22, 9, -26, -21, -10, -23, -34, -57, -18, -13, -47, -1, -21, -48, -22, -43, -3,
                -44, -6, -2, -27, -14, -54, -22, -61, -67, -46, -72, -58, -50, -23, -19, 7, 12,
                8, -15, 11, -30, -49, 5, 31, -12, -23, -36, -37, -4, -27, -4, -12, -40, -14, 21,
                43, 53, 66, 49, 35, 32, 59, 77, 47, 76, 92, 35, 70, 84, 33, 67, 82, 80, 62, 72,
                57, 57, 23, 20, 56, 34, 27, 56, 35, 45, 46, 66, 50, 52, 11, 60, 58, 84, 96, 62,
                77, 49, 22, 68, 35, 56, 67, 71, 82, 38, 66, 38, 70, 48, 42, 77, 70, 84, 89, 55,
                53, 73, 102, 108, 66, 70, 63, 55, 44, 81, 89, 109, 125, 122, 127, 92, 75, 94,
                50, 43, 21, -2, -17, -25, -40, 16, 26, 55, 41, 72, 71, 84, 41, 78, 80, 94, 88,
                87, 75, 99, 98, 95, 111, 118, 88, 88, 121, 127, 122, 127, 97, 69, 43, 71, 74,
                75, 78, 102, 80, 90, 79, 110, 57, 43, 94, 89, 113, 105, 54, 38, 71, 90, 79, 35,
                31, 6, 58, 26, 13, 12, 58, 35, 27, 71, 33, 23, 10, 4, -10, -10, -28, -40, -17,
                4, -31, 23, 28, -16, -37, 14, -21, 17, -2, 42, 26, -13, -9, -23, -11, -23, 8,
                -4, 15, 39, 51, 4, 5, 31, 36, -11, -22, 19, 10, 48, 34, -2, 9, 35, 61, 50, 76,
                63, 86, 80, 61, 55, 74, 62, 63, 21, 54, 17, 60, 31, 67, 83, 85, 78, 41, 24, 24,
                37, 61, 68, 80, 77, 81, 74, 43, 42, 65, 67, 87, 46, 61, 25, 9, 35, -4, -11, -14,
                39, -6, 29, 23, 20, 60, 21, -12, 37, 2, -6, -18, 4, -20, -9, 25, 28, 16, 1, -16,
                11, 49, 25, 39, 3, 42, 11, 5, 49, 72, 23, 37, 23, 56, 72, 65, 75, 34, 47, 81,
                48, 48, 58, 46, 40, 27, -6, -9, 25, 23, 7, -17, 27, 49, 42, 54, 67, 90, 36, 28,
                -4, 29, 49, 9, 22, -10, -26, -25, 5, -16, -37, -4, -40, -24, -32, 19, -8, -35,
                -49, -10, 7, 11, -28, -16, -49, -38, -5, -17, -21, -15, 0, 35, -14, -33, 17,
                -18, -4, -8, -28, 10, 16, 7, 1, -35, 19, 22, 7, 19, 23, 19, 40, -7, 42, 1, 16,
                18, 22, 15, -19, 27, 35, 55, 23, 14, 56, 68, 54, 58, 30, 33, 26, 20, -14, 5,
                -16, 8, -24, -8, -29, -54, -53, -62, -36, -2, -6, 27, 12, 45, -2, 33, 60, 12,
                -10, 34, 48, 14, 13, 48, 34, 19, 5, 20, 56, 56, 61, 46, 34, 16, 53, 29, 57, 18,
                57, 65, 88, 51, 21, 54, 51, 67, 30, 22, 51, 81, 65, 63, 30, 49, 11, -11, 14, 1,
                30, 14, 42, -3, -3, -20, -34, -31, -31, -14, -10, -27, -44, -53, 1, -21, 13,
                -21, -17, -44, -16, -49, -20, 19, 24, 18, 13, -4, 3, -14, 11, -23, -35, -5, 3,
                -22, 2, 9, 43, 16, -24, -1, -15, -4, -35, -24, -47, -23, -34, -35, -19, -2, 17,
                -5, 25, 17, 2, -9, -24, 12, 30, 38, 23, 22, 16, 32, -9, -9, -7, 23, 31, -8, -11,
                36, 52, 11, 3, -10, -17, 29, -19, -24, -22, 22, 15, -10, 28, -6, 34, 37, 22, 36,
                21, 41, 63, 58, 77, 65, 67, 67, 38, 34, 24, 51, 31, 15, 57, 21, 38, 49, 11, -8,
                25, 51, 77, 42, 2, 38, 6, 48, 62, 28, -6, -11, 15, 46, 46, 34, -4, -27, -26,
                -43, -42, -14, -1, 28, 23, -14, 20, 0, -14, -6, 5, 30, -16, -6, -40, -11, -37,
                6, 11, 25, 26, 12, 37, 8, -29, 26, -3, -37, 14, 33, -2, -18, 10, 3, -24, -45,
                -39, 3, -32, -12, -24, -13, -4, 23, -18, -41, -6, 5, -11, -9, -9, 7, -17, -26,
                -19, -17, 3, -38, -9, -22, -55, -4, -33, -62, -63, -37, -72, -80, -24, -28, 7,
                -3, 29, 20, -8, -29, -49, -17, -3, -8, -10, -19, 8, 33, -14, -14, -25, -14, -51,
                -11, -19, -47, -12, -7, -36, -54, -19, -12, 5, -33, -22, 14, 13, 27, -20, -8,
                12, -23, 21, 4, -18, 8, -4, -8, -20, 1, 36, -17, 26, -21, -14, -22, -4, 16, 33,
                -1, 19, -10, -17, -33, -57, -2, -24, -36, -62, -26, -43, -38, -29, -47, -35,
                -65, -35, -10, -56, -72, -15, -55, -21, -22, 2, -36, -10, -15, -28, -55, -2,
                -12, -52, -29, -8, -15, 1, -38, -14, -38, -7, -32, 6, -9, -49, 5, -8, -25, -21,
                13, 35, -1, 16, 10, 23, -8, -13, -30, 3, -38, -49, 1, 10, 8, -38, -10, -9, -32,
                -61, -8, -5, -12, 7, 34, -14, -11, 28, -23, -15, -24, -14, -44, -15, -34, -41,
                -24, -31, -54, 0, 25, -15, 9, -38, -29, -61, -52, -3, 9, 21, 1, 32, -21, -50,
                -20, -55, -11, -30, -6, -13, -24, -14, -21, -5, 30, -15, -19, -39, -14, 1, 23,
                32, -6, 31, 40, 24, 21, -12, -1, 25, 32, 19, 14, 23, 30, 42, 44, 53, 75, 64, 84,
                96, 85, 66, 95, 72, 58, 89, 60, 44, 57, 87, 99, 54, 66, 86, 39, 69, 80, 70, 70,
                62, 75, 57, 95, 80, 59, 24, 21, 65, 33, 49, 78, 37, 21, 12, 25, 34, 37, 69, 47,
                75, 74, 60, 20, 25, 28, 45, 68, 81, 70, 51, 19, -7, 1, 19, 42, 27, 35, 32, 31,
                11, 34, 13, 35, 33, 5, 47, 41, 59, 14, 40, 23, 64, 46, 1, 30, 38, 3, -21, -3,
                31, 46, 28, 5, 44, 60, 58, 47, 10, 10, 22, 17, 20, 15, 21, 24, -8, -7, -8, 27,
                22, -21, 35, 24, 30, 33, 19, 31, 61, 73, 24, 57, 44, 75, 94, 71, 30, 34, 68, 75,
                88, 39, 77, 36, 24, 45, 40, 27, 43, 33, 16, 3, 51, 21, 10, 25, 42, 62, 83, 81,
                25, 26, 15, 18, 59, 61, 79, 56, 47, 30, 37, 34, -1, -2, 48, 14, 30, 37, 72, 61,
                17, 64, 55, 31, 32, 47, 26, -1, -21, 25, 17, 39, 46, 10, 5, 17, 53, 62, 76, 81,
                79, 59, 26, 28, 59, 31, 37, 74, 49, 9, 62, 81, 36, 17, 19, 20, 52, 10, 21, -3,
                13, 1, -11, 39, -3, 3, 41, 16, 6, 49, 39, 44, 33, 61, 13, 60, 39, 47, 73, 94,
                74, 56, 74, 46, 49, 18, 61, 83, 27, 21, 18, 10, -8, 9, 39, 33, 29, 46, 18, -1,
                44, 61, 79, 84, 26, 8, -1, -9, -32, 23, 53, 5, -15, 3, -21, 6, -15, -3, -4, 31,
                33, -10, -4, 35, 6, 26, -5, 3, 39, 65, 6, 17, -3, 35, 53, 76, 27, 3, -10, 34,
                30, 53, 0, -26, -41, -33, -6, -43, -8, 5, 36, 41, 11, 11, -7, -3, 27, 16, 11,
                -1, 29, 13, 9, -12, -23, 20, -7, 23, 24, -21, -14, -26, -36, -41, -10, -23, 1,
                22, -20, 2, 32, -17, 22, 3, -2, -14, 25, 28, 9, 19, -17, -10, 34, 9, 44, 13, 4,
                17, 33, 15, 39, -6, -22, 26, 41, -10, -18, 30, -10, -30, -24, -42, 8, -6, 34,
                -15, 12, -27, -51, -1, -44, -31, -55, -7, -1, 25, -23, 0, 11, 16, 5, -4, -4, 3,
                -4, 32, -10, 14, 42, 23, 39, 53, 29, 65, 29, 49, 18, -10, -14, -16, -7, -34, 18,
                28, 31, 7, 48, 60, 67, 43, 49, 64, 86, 84, 80, 29, 74, 58, 16, 60, 77, 79, 56,
                53, 89, 92, 54, 71, 79, 97, 83, 109, 109, 75, 110, 106, 106, 90, 56, 62, 47, 25,
                0, -18, 40, 43, 6, 28, 8, 20, 30, -9, -28, 1, -21, 14, 45, 11, 3, 3, 4, 47, 8,
                -18, -36, 19, 16, 16, -20, -23, 3, 41, 2, 16, 30, -9, -37, 8, 38, 8, 9, 2, 39,
                27, 14, 20, 28, 26, 0, 0, -3, 10, -21, -32, -52, -48, -28, 3, -22, 14, -35, -28,
                -7, 12, -1, 9, 0, 4, 0, 0, -26, 15, -17, 23, 36, 53, 6, 4, 47, 63, 15, 41, 46,
                19, 23, 5, 46, 24, 16, 7, 6, -4, 24, 43, 26, -10, 0, 24, 42, 26, 26, 1, 43, 34,
                7, -4, 5, 6, 18, 18, 26, -18, 23, 34, 51, 23, 22, 3, 24, -16, -16, 13, 40, 17,
                -21, 30, -7, 24, 17, -7, 31, 55, 6, 24, 0, -11, 33, 7, 15, 42, 51, 61, 48, 74,
                23, 54, 34, 41, 24, 30, 34, 16, 36, 4, -23, 29, 49, 59, 55, 33, 36, 60, 48, 75,
                27, 21, 41, 60, 32, 21, 36, 24, 49, 4, 8, 7, 7, -21, -23, -2, 5, -9, 0, 11, -11,
                -27, -40, 7, -23, -18, -5, -9, -18, -2, -16, 21, 45, 9, 37, 5, -9, 11, 6, 19,
                11, -23, -6, 4, 28, 30, 9, -14, -30, 14, -21, 26, 46, 8, 18, 39, -2, -4, 28, 40,
                63, 16, 1, -9, -19, 23, 18, -2, 28, 30, 46, 23, 26, 3, 46, 17, 0, 34, 16, -7,
                -18, 24, 11, -6, -18, -37, -42, -57, -74, -72, -33, -22, -2, -28, -38, -3, -42,
                10, 29, -9, 15, 27, 24, 9, 25, 4, 15, 16, 16, -18, 25, -17, 17, -8, -37, -6, -7,
                -2, -10, -2, -1, 33, -20, 17, -18, -38, -46, -6, -48, -34, -24, -46, -71, -17,
                -28, -42, -26, -45, -36, -64, -77, -49, -53, -38, -28, -46, -74, -37, -59, -42,
                -31, -66, -53, -64, -46, -16, -8, -36, -39, -27, -18, 15, -13, -50, -19, -43,
                -27, -19, -47, -59, -22, -28, -7, -16, -55, -67, -30, -22, 6, 13, 24, 37, 33,
                47, 43, 62, 50, 2, -17, -4, 23, 38, 7, 46, 7, 45, 15, 42, -8, -7, 26, -2, -4,
                -22, 20, -24, -3, -21, -32, -49, 7, 3, 30, 48, 18, -7, -24, -16, -7, -35, 1, 13,
                15, 26, -21, 21, 40, 53, 47, 23, 27, 28, -1, 22, -21, -38, -21, 5, -25, -35,
                -23, -31, 4, -20, -12, 3, -18, 25, -23, -5, -35, 11, 14, -8, 21, 1, 29, -15,
                -21, 2, 39, 29, 51, 28, 23, 41, 59, 80, 73, 83, 49, 15, 43, -2, 24, 1, 50, -1,
                -14, -36, -8, -6, -35, 14, 26, 32, 27, 27, 15, 2, 41, -11, 7, 26, 42, 38, 27,
                32, 47, 0, -12, 35, 35, 21, -4, 19, -3, 17, -22, -17, -45, 13, 27, -21, -19, -2,
                32, -4, 28, 2, 8, 36, 23, 13, 9, 39, 46, 1, -14, -10, -36, -5, -40, -10, 17,
                -17, -22, -8, 5, -37, 1, -27, 9, 13, 33, 29, 20, 1, -11, 32, -1, 23, 47, 45, 68,
                17, 23, 25, 19, 16, 12, 39, 8, 34, 8, 0, -3, 5, 36, 24, -18, 3, -12, -3, -11,
                27, 30, -16, 8, -26, -41, -1, -9, 17, 32, -13, -13, -6, -19, -18, 10, 18, 4,
                -26, -29, -37, -13, -34, -59, -21, 16, -19, -39, -27, -19, -13, -50, -29, -5,
                -44, -32, -61, -68, -80, -27, -2, 14, -32, -8, 4, -11, -14, -21, 7, -33, -9,
                -30, -11, -17, -3, -20, -42, -58, -23, -29, -13, -12, -48, -7, -10, 21, 28, 47,
                42, 8, -11, 33, 26, 30, 23, 34, 60, 22, -9, -3, -8, 11, -17, -11, -30, -5, -25,
                -23, -45, 10, 23, 39, 52, 69, 27, 43, 56, 75, 60, 13, -9, 6, 45, 55, 62, 45, 20,
                41, 49, 71, 17, 8, 48, 50, 17, 17, 46, 14, -18, -3, 42, -2, 1, 25, -18, 3, -10,
                -13, -18, -5, -14, -24, -18, 7, 37, -1, 21, 17, 26, 55, 31, 8, -17, -4, 34, 1,
                13, -4, 29, 6, 39, 5, 14, -16, 34, 31, 8, 10, 37, -13, -2, 28, 46, 2, 24, 22,
                -14, 16, -13, 37, 32, 43, 21, 22, 31, 57, 72, 78, 65, 53, 26, -1, 26, 33, 59,
                68, 74, 29, 16, 12, 49, 59, 70, 53, 76, 25, 11, 52, 20, 12, 41, 69, 84, 91, 85,
                99, 58, 38, 44, 42, 6, 11, -14, 34, 42, 26, 56, 6, 0, 1, -5, 38, 6, 27, 29, 26,
                42, 8, 2, -10, 29, 9, 31, 41, -3, 23, -8, 27, -9, 35, 8, 48, 56, 7, 49, 6, -4,
                -14, -14, 34, 46, 11, 53, 73, 25, 58, 64, 77, 70, 62, 38, 48, 5, 20, 15, 35, 36,
                19, -12, 44, 50, 9, -21, 7, 13, 53, 70, 48, 63, 72, 33, 44, 60, 26, 32, 68, 52,
                65, 48, 38, 58, 76, 76, 45, 22, 4, -12, -27, 26, -8, 34, 27, -14, 25, 14, 46,
                69, 39, 23, 36, 32, 22, 5, 46, 5, 27, 27, 29, 6, 46, 69, 14, 31, 63, 16, 8, 25,
                -3, -28, -31, 27, 18, 6, 45, 36, 43, 64, 33, 47, 46, 65, 53, 37, 45, 24, 42, 45,
                37, 22, 29, 16, 24, -2, 33, 20, 24, 59, 28, 3, -9, -2, -20, -22, 21, -22, -5, 6,
                25, 5, 4, -33, -7, -2, 36, -5, -24, -39, 0, -19, -1, -18, 9, -6, 11, -17, 4, 41,
                37, 29, 21, -18, 29, 35, -6, 17, 14, -23, 24, 38, 44, 4, 5, 17, 50, 44, 9, 4,
                38, 43, 14, 3, -22, 29, -15, 20, 19, 43, 4, -2, 18, 37, 51, 4, 39, 13, 24, 47,
                26, -1, -4, 24, 37, 36, 59, 10, 35, 68, 54, 68, 35, 15, -2, 33, 58, 76, 37, 14,
                -6, 23, 49, 2, 23, 10, -15, -33, 25, 18, 26, 35, 41, 42, 24, 45, -1, 42, 20, 39,
                61, 79, 50, 54, 84, 100, 103, 64, 97, 82, 69, 87, 92, 103, 120, 64, 75, 72, 47,
                47, 69, 92, 60, 48, 77, 104, 106, 71, 66, 79, 52, 67, 28, 8, 58, 20, 49, 54, 57,
                31, 16, 64, 67, 40, 79, 24, 21, 30, 50, 43, 27, 10, 3, 17, 15, 57, 37, 68, 37,
                9, 39, 66, 37, 26, 62, 66, 47, 11, 28, 23, 11, 12, 24, 39, 12, 9, 26, 48, 51,
                31, 60, 55, 72, 28, 3, 2, 13, 29, 28, 3, 25, 33, 57, 38, 67, 63, 41, 81, 45, 54,
                30, 16, 8, -20, 4, 49, 44, 50, 30, 17, 3, 49, 4, -7, 38, 61, 7, 33, -7, 37, 10,
                8, -14, 28, 38, 26, 50, 1, -3, -32, 11, 39, 14, 27, 14, 2, 35, 6, -18, -38, -35,
                -41, -59, -46, -60, -76, -55, -12, 18, -3, -20, -5, -14, -47, -42, -31, -18,
                -41, -41, 4, -35, 1, 30, -20, 28, -26, -18, -31, -52, -58, -49, -14, -31, -26,
                -27, -43, -63, -16, -15, -36, -13, -25, -34, 10, -10, -10, -19, -31, -10, -17,
                -37, -15, -47, -12, 0, -35, -10, 26, 37, 38, 3, 30, 57, 58, 56, 47, 59, 11, 24,
                25, 9, -24, 10, 11, -28, -11, -8, 27, -14, -32, 2, 0, 14, 10, 26, 13, -8, 37,
                -16, -26, -4, 16, 5, 18, -3, 10, 43, 45, 25, 40, 8, -14, -31, 22, 26, -22, 9,
                19, 33, 32, 40, 14, -13, 33, -11, 13, -10, 37, 13, 22, 16, 28, -9, -13, 11, 48,
                43, 67, 33, -6, -23, -42, -29, -21, 24, 0, 1, 13, -19, 24, 5, 22, 10, 7, 11, 17,
                25, 23, 25, 27, 10, -4, 39, 12, 23, 33, 10, -8, -7, 11, -10, -40, -44, -60, -64,
                -70, -72, -14, -19, -11, -7, -26, -5, -6, -5, 29, 23, 37, 21, -7, -21, 5, 23,
                -6, 29, 3, 19, -11, 6, -1, 21, -5, 39, 51, 24, 43, 23, 0, 35, 22, 38, 40, 4,
                -21, 30, 18, 37, 44, 56, 73, 78, 79, 49, 69, 62, 35, 33, 67, 82, 32, 45, 66, 36,
                49, 48, 79, 32, 75, 99, 91, 51, 79, 62, 91, 64, 55, 15, 23, 36, 34, 64, 14, 25,
                29, 64, 88, 95, 85, 99, 73, 48, 76, 48, 67, 91, 90, 58, 84, 38, 68, 57, 76, 58,
                51, 69, 45, 44, 60, 33, 43, 76, 64, 30, 32, 5, 31, 37, 19, -3, 39, 13, 56, 69,
                33, 0, 34, 57, 21, 30, 28, 46, 21, 3, 51, 1, -24, 27, 42, 52, 36, 20, 46, 12,
                19, 4, 38, 9, -17, -31, 10, 1, -17, 7, 0, -6, -26, -51, -56, -39, -57, -6, -22,
                -30, -59, -32, -41, -44, -3, -25, -5, -42, -40, -60, -38, -36, -3, -27, -42,
                -18, -41, -1, -6, -49, -1, 1, -44, -68, -73, -62, -42, -32, -65, -59, -17, -13,
                -36, -5, 23, 39, -2, 38, 58, 60, 24, -6, -26, -33, -27, 0, 0, -17, -4, -17, 23,
                48, 28, 2, 6, -26, -38, -6, -45, -37, 3, 0, -20, 6, -33, -42, -14, 25, 15, 23,
                15, 1, 16, -10, -37, -24, -55, -29, -52, -29, -64, -68, -26, -61, -15, -59, -39,
                -46, -9, -35, -45, -72, -60, -54, -45, -79, -62, -87, -36, -7, -36, -70, -47,
                -76, -95, -82, -66, -21, -64, -65, -81, -33, -13, -26, -1, -11, -11, -44, -38,
                -36, -12, -25, -28, 11, 17, -27, -30, -16, -39, 7, 19, -15, 1, 12, -35, 11, -21,
                -23, -35, -3, -15, -28, -41, -12, -35, -50, -8, -36, -38, 0, 3, 15, -31, -19,
                -48, -8, -46, -49, -77, -42, -63, -71, -27, -26, -60, -39, -56, -16, 0, -6, -52,
                -43, -2, 7, -14, 20, -32, -56, -66, -14, 1, -9, -17, 4, -33, -64, -39, -41, -45,
                -51, -15, -34, -35, -70, -71, -45, -82, -84, -54, -60, -53, -84, -69, -25, -5,
                -13, -54, -49, -66, -70, -83, -102, -93, -61, -31, -51, -16, -50, -80, -87, -77,
                -74, -35, -32, -35, -56, -26, -54, -66, -80, -77, -104, -71, -82, -104, -104,
                -49, -49, -21, -1, -20, -23, -39, -4, 21, -24, 13, 28, 33, 25, -8, -17, -31,
                -27, 17, 30, 20, 2, 27, 17, -20, -18, -8, 24, -7, -35, -54, -33, -33, -32, -47,
                -34, -16, -9, -23, 11, 37, 13, 14, 36, 33, 12, -10, -9, -27, 8, 32, 23, 9, -9,
                -18, -24, 11, 15, 39, -5, 34, 36, 22, 29, 44, 27, 14, 4, -20, -39, -41, -3, 16,
                -26, -9, 13, 28, 28, 35, 62, 77, 84, 88, 63, 32, 43, 6, 27, 53, 62, 11, 28, 23,
                5, 50, 75, 69, 65, 54, 20, 29, 29, 9, 45, 69, 18, 56, 27, 63, 15, -3, -16, -4,
                -35, 3, -8, -3, -5, 31, 56, 17, -11, 6, 46, 20, 8, 2, 20, -14, -4, 32, -13, 5,
                43, -11, -32, -54, -25, 1, 36, 41, 39, 52, 40, 17, 28, 17, -2, -17, -27, -24,
                -24, -32, -42, -2, -25, -28, 18, -14, -33, -2, -13, -45, -21, 15, -17, -25, -4,
                24, 26, -20, -36, -38, -18, 5, -32, 17, 44, 25, -14, -42, -40, -58, -75, -90,
                -46, -32, -56, -72, -52, -59, -29, -64, -57, -32, -13, -28, -10, -40, -1, 18, 1,
                31, -11, 31, 23, 24, -8, -35, 17, -24, -2, -41, -13, -42, -64, -5, 18, 16, 38,
                37, 7, 40, 36, 14, 33, 8, -22, 7, -25, 5, -36, -52, -41, -67, -62, -56, -57,
                -15, -39, -30, -13, -23, 17, 28, -9, -39, -17, -22, -34, -48, -3, -12, -10, -22,
                -20, 1, 33, 38, 28, 48, 50, 32, 23, 39, 6, -27, -9, -26, -19, 5, -36, -1, 2,
                -13, -35, -41, -39, -69, -34, -33, -44, -32, 2, -29, -42, 4, 23, 33, 15, 40, 2,
                -13, 5, -19, -2, 15, -21, -11, 7, -29, -44, -19, -25, -13, 20, -6, 33, -20, -48,
                -64, -68, -17, -2, -41, -45, -54, -4, -5, -17, -29, -6, 0, -7, -45, -61, -32,
                -23, -41, -68, -67, -27, -59, -22, 3, 19, -31, 8, -42, -57, -74, -45, -64, -62,
                -59, -64, -72, -96, -97, -101, -43, -53, -59, -39, -7, -47, -14, 2, 3, 29, 38,
                44, 2, -12, 26, 14, -20, -13, 23, 5, 22, 49, 7, -23, -38, -58, -59, -60, -73,
                -91, -67, -96, -97, -99, -72, -85,
        };

#endif /* PINKNOISE8192_H_ */
