#ifndef NOISE_STATIC_1_16384_H_
#define NOISE_STATIC_1_16384_H_

#include <Arduino.h>
#include "mozzi_pgmspace.h"

/* static noise from needle on old record
 */

#define NOISE_STATIC_1_16384_NUM_CELLS 16384
#define NOISE_STATIC_1_16384_SAMPLERATE 16384

CONSTTABLE_STORAGE(int8_t) NOISE_STATIC_1_16384_DATA []  =
  {
    -5, -8, -8, 1, 4, -1, 5, 3, 3, 0, -4, 7, 1, -1, 0, -9, -3, -2, 2, 2, 
    -2, 1, -8, -7, -5, -4, -1, -3, -6, -14, 0, 5, -5, -4, 1, -2, -4, 3, -6, 4, 
    13, -15, -14, 1, -2, -3, -7, -4, -1, -7, -1, -12, -12, 6, -4, 0, -8, 0, 4, -20, 
    3, 0, -6, -4, -9, -1, -6, -3, -8, -1, 4, -6, -5, -8, -6, -12, -12, -1, -5, -3, 
    -4, 2, -4, -17, 0, -3, -5, -1, -7, -4, -6, -1, -1, -8, -3, -4, -5, 1, 1, 1, 
    -2, 45, 25, -26, -4, -6, -5, -4, -4, 0, 6, 7, 5, -2, -16, -5, 2, 4, -3, -3, 
    1, -10, 1, 1, -1, 6, 6, 0, -2, 4, -9, -13, -1, -1, 8, -2, 18, 5, -14, 3, 
    2, 36, -17, -29, -5, 5, -25, -57, 24, 5, 1, -17, -28, 12, 8, 4, -16, 5, 4, -46, 
    -20, 26, 10, 11, 12, 6, -9, 3, 21, -1, 5, 12, 4, -5, 1, 2, 6, 14, 7, 1, 
    0, -4, 2, 9, -1, 7, 2, -3, 9, 6, 6, 3, -1, 6, 9, 3, 4, -2, -6, 7, 
    19, 12, -3, -10, -13, -4, 5, -2, -6, -3, 2, 7, -1, -4, 1, 5, -1, -4, 3, 4, 
    1, -3, 5, 5, -9, -4, -9, -16, -13, -10, -1, 4, 2, -4, 2, 5, -7, -3, 1, 5, 
    8, -4, 6, -4, -12, 2, 4, 14, 9, -10, -13, 6, 5, 4, 2, -11, 2, -6, -8, 1, 
    1, 6, -1, -4, -7, -2, 7, -3, -4, 1, 4, 13, 4, 10, 16, -4, 6, 9, -5, 0, 
    6, 0, -2, 8, 0, -2, 2, 6, 11, 2, 0, 3, 4, 4, 11, -14, -8, 25, 8, -4, 
    5, 13, -11, 2, 11, 2, 13, 11, 1, -1, 6, 7, 19, 2, -2, -8, 4, 20, 5, 5, 
    1, 4, -1, 3, -4, -2, 8, 10, 9, -3, 1, 5, 6, 0, 1, -3, -8, -1, 2, 1, 
    1, 2, 2, 5, 2, 6, 7, 0, 5, 4, 1, 2, -7, -1, 8, 0, -3, -6, -3, 6, 
    2, 2, 11, 14, 1, 2, 13, -8, -5, 12, 5, 10, 14, 11, 3, 9, 7, 11, 5, 1, 
    16, 6, 8, 4, 7, 8, 11, 13, 4, 15, 13, 8, 7, 14, 11, 5, 16, 17, 13, 11, 
    12, 12, 12, 5, 10, 21, 9, 17, 21, 6, 10, 18, 10, 19, 24, 4, 11, 7, 11, 17, 
    11, 13, 12, 20, 16, 11, 12, 7, 13, 15, 1, 19, 32, 15, 15, 10, 11, 18, 13, 10, 
    13, 15, 9, 8, 4, 6, 9, 17, 18, 12, 10, 4, 14, 13, 11, 13, 7, 14, 18, 17, 
    15, 6, 4, 9, 12, 14, 11, 3, 14, 20, 7, 10, 10, 9, 9, 13, 22, 12, 13, 7, 
    3, 10, 10, 12, 0, 4, 8, 12, 16, 6, 17, 13, 4, 13, 4, 2, 5, 13, 19, 17, 
    15, 4, 11, 14, 3, 3, 6, 9, -6, -4, 16, 13, 8, 8, 6, 10, 10, 10, 8, 6, 
    10, 1, 6, 7, 7, 11, 7, 15, 5, 4, 5, -6, 14, 14, 9, 7, -9, 4, 9, 2, 
    6, 8, 13, 13, 8, 7, 13, 17, 8, -5, 1, -2, -3, 11, -2, 4, 5, 2, 3, 2, 
    14, 5, 0, -9, 7, 12, -6, 6, 3, 0, 5, -1, -3, 2, 3, 5, 9, 6, 10, 6, 
    7, 7, -2, 5, 3, -6, -1, 2, 6, 0, 4, 2, 2, 6, -13, 10, 10, 2, 4, -7, 
    3, 0, 2, 5, 0, -6, 2, 5, -8, 8, 10, -15, -23, -26, -15, 6, 26, 36, 16, -6, 
    -8, 3, -27, -25, 29, 15, -29, -18, 2, 4, -4, -15, 22, 43, 12, 9, 6, -3, 13, 2, 
    -8, -8, -5, 1, -9, -15, -23, -19, -6, 10, 2, -4, 1, -7, -2, 9, -9, -17, -14, -1, 
    -17, -40, -5, -6, -12, -20, -18, 3, -8, -11, -16, -15, -12, -14, -5, -12, -19, -9, -19, -15, 
    0, -13, -9, -22, -32, -15, -13, -15, -17, -20, -14, -8, 1, -4, -27, -14, -11, -17, -16, -10, 
    -2, -17, -13, -4, -7, -16, -9, -16, -22, -8, -17, -16, -12, -15, -14, -17, -12, -11, -15, -21, 
    -17, -13, -17, -9, -17, -12, -13, -29, -11, -10, -17, -18, -19, -16, -17, -18, -17, -20, -16, -6, 
    -18, -9, -13, -32, 2, -17, -27, -2, -21, -16, -21, -24, -14, -18, -14, -18, -17, -14, -22, -23, 
    -9, -14, -26, -14, -17, -20, -17, -20, -30, -16, -1, -16, -17, -28, -25, -16, -17, -19, -21, -16, 
    -15, -11, -11, -24, -20, -16, -23, -22, -25, -14, -6, -21, -24, -19, -24, -17, -3, -21, -27, -14, 
    -27, -28, -19, -19, -27, -17, -4, -21, -25, -24, -25, -20, -20, -27, -17, -17, -23, -24, -17, -15, 
    -24, -13, -11, -26, -35, -19, -16, -22, -24, -21, -17, -23, -27, -18, -14, -21, -22, -18, -22, -33, 
    -24, -17, -24, -24, -14, -17, -27, -14, -21, -27, -23, -16, -25, -24, -15, -24, -17, -27, -25, -28, 
    -24, -15, -29, -33, -22, -17, -25, -17, -21, -19, -21, -30, -22, -28, -28, -33, -29, -24, -31, -40, 
    -38, -26, -23, -28, -30, -8, -13, -35, -25, -23, -31, -28, -28, -25, -21, -24, -26, -24, -33, -29, 
    -17, -34, -24, -37, -30, -18, -38, -19, -23, -24, -28, -33, -23, -34, -26, -12, -15, -17, -19, -27, 
    -21, -24, -27, -18, -19, -18, -32, -27, -13, -21, -16, -22, -22, -24, -24, -15, -22, -25, -25, -24, 
    -24, -21, -24, -23, -13, -15, -24, -16, -15, -22, -13, -32, -30, -22, -23, -14, -22, -23, -32, -15, 
    -10, -26, -17, -20, -18, -9, -13, -17, -14, -17, -15, -17, -21, -21, -16, -17, -19, -5, -9, -17, 
    -10, -12, -17, -9, -13, -20, -14, -8, -6, -9, -14, -15, -6, -2, -10, -11, -14, -10, 5, 1, 
    -21, -15, -5, -10, -15, -18, -6, -10, -10, 6, 1, -5, -13, -17, -10, -11, -13, 1, 5, 1, 
    -3, -7, -1, -1, -7, -1, 6, -11, -7, -3, -4, -2, -14, -2, -2, -10, -2, 2, 2, 1, 
    -5, -7, -4, -1, -7, 0, 12, 2, -4, -4, 5, 10, -12, -22, 6, 9, -8, 0, 9, 14, 
    14, 16, -1, 0, 9, -1, 4, 11, 10, 10, 10, 12, 10, 4, 4, 12, 17, 10, 4, 12, 
    12, 6, 16, 23, 11, 0, 4, 5, 8, 12, 5, 14, 16, 14, 16, 11, 14, 9, 11, 22, 
    11, 7, 21, 25, 25, 23, 29, 21, 14, 50, 28, -9, 14, 15, 4, 7, 22, 23, 16, 24, 
    28, 23, 25, 17, 20, 25, 26, 37, 12, 19, 34, 28, 33, 18, 20, 34, 29, 21, 24, 24, 
    17, 25, 29, 21, 31, 30, 30, 34, 27, 32, 33, 28, 21, 23, 26, 13, 32, 40, 32, 42, 
    35, 35, 22, 30, 33, 37, 54, 17, 22, 29, 25, 23, 25, 56, 9, 4, 74, 30, 2, 35, 
    34, 48, 37, 38, 48, 31, 37, 43, 38, 40, 39, 45, 37, 34, 42, 38, 42, 54, 41, 35, 
    45, 35, 36, 49, 44, 41, 48, 30, 26, 40, 28, 36, 53, 34, 36, 36, 36, 52, 20, 32, 
    56, 40, 38, 31, 37, 39, 48, 39, 37, 39, 31, 50, 21, 14, 43, 40, 32, 34, 38, 27, 
    33, 36, 36, 47, 34, 22, 28, 34, 33, 37, 36, 35, 29, 34, 40, 22, 31, 39, 29, 29, 
    38, 29, 35, 35, 26, 42, 31, 31, 42, 34, 30, 32, 36, 34, 34, 43, 21, 55, 11, -18, 
    80, 31, 17, 36, 30, 22, 22, 38, 28, 45, 19, 39, 21, -1, 46, 39, 37, 32, 33, 37, 
    23, 28, 26, 30, 37, 27, 35, 27, 32, 58, 38, 24, 30, 24, 22, 26, 24, 27, 27, 27, 
    36, 26, 21, 45, 39, 21, 16, 32, 32, 13, 35, 32, 24, 33, 26, 25, 25, 39, 60, 20, 
    1, 29, 26, 24, 25, 15, 22, 32, 31, 25, 19, 23, 22, 21, 23, 20, 24, 32, 32, 17, 
    20, 13, 23, 27, 11, 34, 19, 14, 21, 20, 10, 4, 51, 27, 4, 19, 17, 20, 7, 14, 
    12, 10, 24, 14, 3, 19, 19, 6, 10, 15, 8, 9, 17, 12, 15, 10, 35, 22, 9, 26, 
    6, 15, 10, 12, 21, 14, 17, 10, 12, 19, 17, 9, 0, 19, 18, 15, 7, 3, 10, -2, 
    6, 14, 5, 8, 32, 13, -2, 11, 10, 3, 4, 8, -1, -1, 6, 12, 1, -6, 4, 9, 
    5, 9, 16, 6, 8, 3, -4, -1, 1, -1, 3, 19, 6, -1, -4, 5, 3, -11, 7, -2, 
    -12, -12, -4, -1, 2, 11, -3, 5, 8, -6, -8, -4, -2, -3, -1, -6, -7, -4, -4, -13, 
    -12, -12, -5, -4, -13, -13, -4, 7, -6, -9, -1, -6, 5, -1, -18, -1, -8, 1, 9, -14, 
    -4, 3, -10, -10, -1, 0, 0, -18, -4, -6, -6, 5, -22, -3, 0, -18, -16, -12, -9, -10, 
    1, -16, -23, -13, -10, -14, -26, -4, -5, -6, -17, -17, -5, -20, -18, -14, -3, -14, -22, -17, 
    -20, -12, -2, -15, -18, -16, -15, -22, -22, -19, -14, -22, -56, -24, -3, -12, -9, -9, -17, -20, 
    -6, -13, -11, -4, -17, -22, -17, -17, -20, -30, -31, -15, -14, -26, -22, -4, -8, -27, -14, -12, 
    -21, -11, -17, -22, -21, -24, -17, -15, -16, -15, -18, -26, -14, -14, -19, -17, -21, -12, -11, -16, 
    -16, -15, -19, -24, -24, -24, -21, -16, -17, -17, -16, -21, -26, -26, -19, -18, -17, -12, -15, -33, 
    -29, -17, -26, -25, -30, -21, -21, -32, -25, -23, -14, -9, -21, -32, -27, -26, -36, -28, -24, -26, 
    -24, -30, -30, -24, -34, -33, -27, -28, -23, -29, -23, -35, -41, -28, -29, -19, -22, -38, -20, -15, 
    -27, -29, -26, -23, -27, -28, -24, -21, -35, -32, -28, -21, -17, -21, -29, -37, -23, -27, -28, -21, 
    -26, -33, -34, -24, -35, -27, -11, -37, -40, -21, -34, -42, -31, -25, -39, -26, -18, -29, -30, -41, 
    -35, -33, -38, -34, -33, -27, -32, -46, -33, -38, -37, -31, -47, -32, -23, -31, -28, -28, -30, -30, 
    -28, -29, -33, -30, -35, -34, -30, -30, -32, -34, -31, -29, -33, -31, -25, -33, -28, -28, -39, -38, 
    -28, -17, -37, -41, -21, -49, -27, -13, -36, -28, -34, -34, -30, -26, -25, -14, -24, -39, -27, -33, 
    -26, -25, -40, -28, -22, -26, -28, -30, -30, -38, -29, -27, -22, -29, -38, -20, -41, -39, -23, -31, 
    -23, -22, -20, -28, -32, -27, -27, -17, -27, -30, -22, -31, -32, -27, -30, -26, -20, -33, -23, -26, 
    -57, -18, 2, -19, -22, -26, -15, -17, -23, -20, -25, -30, -28, -28, -22, -22, -21, -20, -26, -17, 
    -19, -29, -34, -25, -22, -26, -19, -26, -24, -23, -16, -15, -16, -17, -25, -22, -36, -22, -22, -34, 
    -22, -10, -16, -22, -24, -29, -15, -22, -31, -22, -17, -21, -15, -14, -21, -18, -22, -21, -17, -16, 
    -22, -22, -18, -11, -25, -20, 0, -12, -15, -13, -13, -17, -14, -14, -15, -10, -17, -15, -16, -16, 
    -6, -15, -15, -5, -11, -17, -5, -7, -17, -10, -4, -8, -2, 1, -32, -19, 3, -12, -3, -1, 
    0, -2, 5, -5, -11, 7, -6, -7, -6, -2, 4, -9, -5, -5, -5, 7, -10, -14, 4, 0, 
    -2, -1, 7, 6, -2, 2, 2, 0, 5, 15, 5, 6, 6, 1, -1, 2, 24, -14, -3, 26, 
    -5, 9, 11, -1, -2, 14, 13, -1, 6, 7, 3, 7, 16, 10, 2, 6, 15, 10, 0, 15, 
    15, 4, -6, -2, 18, 13, -2, 9, 20, 6, 16, 21, 11, 13, 16, 13, 12, 10, 3, 9, 
    15, 17, 10, 4, 14, 11, 7, 7, 5, 9, 18, 15, 16, 8, 5, 20, 8, 12, 23, 13, 
    16, 19, 14, 24, 17, 16, 13, 16, 18, 3, 38, 18, 12, 28, 4, 14, 17, 12, 18, 26, 
    14, 19, 21, 11, 18, 17, 18, 12, 26, 17, 11, 25, 24, 11, 8, 23, 15, 18, 11, 28, 
    28, 12, 24, 27, 15, 2, 13, 18, 27, 17, 13, 8, 10, 35, 25, 12, 20, 24, 15, 10, 
    17, 10, 15, 35, 12, 7, 18, 20, 24, 13, 16, 25, 19, 26, 18, 0, 11, 13, 26, 22, 
    16, 27, 21, 21, 0, 22, 41, 17, 16, 22, 20, 14, 17, 30, 44, 30, 11, 14, 24, 30, 
    12, 20, 27, 22, 17, -6, 31, 37, 22, 25, 12, 26, 22, 23, 28, 24, 22, 27, 23, 21, 
    31, 16, 23, 36, 28, 27, 14, 23, 33, 17, 18, 28, 23, 21, 30, 33, 13, 17, 29, 29, 
    26, 25, 28, 25, 19, 28, 32, 24, 33, 28, 22, 28, 26, 30, 27, 25, 33, 27, 24, 31, 
    29, 24, 22, 30, 27, 22, 29, 27, 20, 17, 16, 24, 29, 15, 13, 26, 26, 21, 25, 26, 
    17, 29, 34, 19, 23, 31, 29, 20, 26, 17, 18, 21, 15, 28, 15, 26, 31, 12, 33, 27, 
    15, 22, 16, 22, 25, 12, 9, 32, 33, 27, 27, 15, 23, 24, 21, 25, 20, 23, 24, 21, 
    12, 21, 22, 10, 19, 13, 14, 23, 25, 17, 24, 31, 17, 12, 21, 34, 21, 18, 25, 18, 
    18, 13, 24, 18, 0, 23, 17, 11, 35, 20, 21, 31, 10, 19, 24, 16, 14, 13, 27, 13, 
    6, 16, 12, 32, 19, 7, 17, 17, 23, 14, 6, 17, 13, 14, 24, 17, 22, 13, 6, 8, 
    8, 16, 12, 16, 11, -13, 8, 22, 5, 8, 25, 23, 9, 14, 13, 15, 9, -3, 5, 8, 
    12, 9, 8, 9, 3, 41, 13, -11, 59, 6, -17, 31, 0, 0, 11, 13, 12, 20, 15, -10, 
    16, 21, 10, 22, 12, 12, 17, 14, 17, 17, 15, 19, 24, 18, 20, 20, 12, 12, 10, 13, 
    26, 24, 10, 11, 10, 9, 16, 9, 32, 24, -14, 2, 19, 18, 3, 17, 21, 10, 14, 9, 
    3, 13, 28, 4, 7, 11, 5, 24, 6, -2, 21, 8, 10, 14, -11, -9, 20, 17, -10, -2, 
    10, 16, 9, -13, 10, 15, 0, 8, 11, 7, 4, 13, 6, -5, -5, 4, -2, -4, 6, 0, 
    -5, -14, -3, 0, 2, 11, -4, -4, 9, 3, 7, 5, -19, -12, 10, 12, 3, 0, -2, -4, 
    -5, 5, 15, 2, 9, -2, -2, 5, -19, 4, 7, -8, 7, 4, -8, -11, 6, -2, -20, 3, 
    1, -14, 8, 3, -6, -2, -5, -3, -6, -10, -8, -6, -27, -10, 18, -7, -19, -6, -17, -16, 
    3, -5, -4, -2, -13, -12, -13, -13, 2, 2, -5, 1, -15, -19, -4, -14, -12, -6, -14, -13, 
    -3, -7, -25, -15, -12, -20, -10, -14, -14, -19, -17, -4, -15, -20, -20, -10, -10, -17, -17, -7, 
    -5, -16, -11, -19, -9, -14, -29, -9, -16, -23, -22, 3, -16, -34, 5, -11, -20, -11, -22, -8, 
    -17, -30, -25, -15, -20, -21, 15, -22, -34, -12, -24, -22, -34, -22, -11, -17, -18, -24, -11, -26, 
    -33, -12, -11, -17, -23, -19, -19, -26, -26, -12, -11, -19, -13, -25, -36, -23, -12, -16, -17, -28, 
    -19, -12, -23, -16, -21, -33, -24, -18, -15, -17, -21, -17, -27, -17, -8, -21, -17, -15, -18, -17, 
    -19, -20, -27, -22, -19, -23, -12, -23, -26, -15, -25, -12, -25, -42, -7, -27, -36, -13, -19, -31, 
    -30, -20, -37, -27, -21, -30, -25, -17, -21, -23, -36, -30, -11, -45, -44, -15, -17, -32, -24, -13, 
    -18, -35, -37, -23, -28, -27, -29, -28, -34, -38, -19, -40, -35, -20, -31, -17, -18, -29, -26, -26, 
    -31, -36, -34, -29, -36, -23, -18, -36, -28, -26, -37, -27, -26, -31, -22, -34, -43, -17, -17, -30, 
    -21, -20, -21, -28, -29, -22, -29, -32, -30, -37, -34, -30, -26, -26, -22, -24, -24, -18, -41, -34, 
    -20, -25, -27, -20, -19, -23, -13, -25, -29, -31, -26, -24, -30, -27, -34, -28, -24, -23, -33, -44, 
    -25, -13, -25, -22, -28, -31, -23, -31, -7, -29, -43, -8, -17, -30, -20, -42, -97, -39, 15, -18, 
    -25, -24, -25, -22, -11, -18, -29, -23, -26, -25, -7, -21, -32, -7, -15, -27, -18, -22, -16, -13, 
    -19, -17, -28, -19, -16, -19, -18, -27, -12, -11, -26, -18, -3, -25, -27, -7, -30, -29, -4, -2, 
    -32, -33, -17, -22, -17, -14, -9, -13, -22, -11, -12, -17, -14, -11, 0, -13, -18, -14, -17, -21, 
    -16, -17, -16, -10, -13, -16, -13, -1, -9, -12, -15, -17, -15, -29, -11, 0, -17, -11, -6, -10, 
    -17, -11, -21, -1, 18, -35, -14, -2, -25, -20, -25, -16, -20, -37, -70, -71, -18, -2, -14, -19, 
    -1, 20, 6, -4, 3, 3, -9, -13, -8, -8, -15, -11, 8, -9, -5, 7, -6, -10, -12, -3, 
    -1, 3, 3, -2, 1, -5, -7, 2, -9, -17, 16, 11, -14, -9, -16, -10, -16, -5, 17, -2, 
    -12, -15, -8, -5, -11, 15, 0, -11, -1, -7, -1, -4, 1, -5, -11, -7, -6, -5, -1, 12, 
    5, -13, -12, -9, -20, -1, 6, -7, 11, 9, 6, 3, 2, 5, -2, 2, 3, 0, 0, 0, 
    9, 13, -3, -3, 12, 8, 0, -9, -2, 3, 9, -4, -16, 14, 15, 1, -3, 1, 14, -3, 
    -17, 3, 11, 8, 13, 14, 10, 8, 4, 9, 5, 8, 6, 9, 37, 0, -4, -7, 1, 23, 
    5, 12, 13, 15, 16, 12, 5, 16, 12, 2, 5, -1, 8, 23, 9, 2, 15, 14, 6, -15, 
    28, 26, -14, 11, 7, 3, 2, 3, 2, 3, 23, 23, 13, 17, 13, 5, 13, 21, 1, 5, 
    18, 6, 5, 10, 16, 14, 13, 7, 0, 12, 12, 15, 22, 6, 18, 5, -11, 19, 30, 13, 
    8, 15, 10, 11, -3, 12, 17, 7, 11, 7, 15, 18, 17, 11, 10, 10, 3, 11, 6, -2, 
    20, 17, 8, 9, 3, 14, 7, 7, 20, 3, 15, 20, 1, 14, 9, 11, 21, 13, 8, 15, 
    21, 15, 11, 11, 14, 14, 12, 17, 16, 14, 18, 23, 20, 19, 20, 14, 19, 19, 14, 19, 
    18, 16, 13, 10, 13, 7, 23, 17, 5, 30, 10, 10, 20, 10, 8, 14, 37, 20, 10, 29, 
    12, 11, 35, 14, 4, 14, 12, 9, 9, 16, 19, 9, 6, 17, 25, 14, 9, 18, 20, 13, 
    1, 23, 19, 1, 4, 17, 10, 12, 51, 4, 1, 15, 2, 20, -1, 14, 11, 5, 27, 13, 
    20, 13, 17, 15, -11, 11, 17, 9, 9, 2, 8, 13, 12, 11, 21, 14, -1, 24, -2, 4, 
    19, -2, 15, -1, 7, 11, 7, 16, 12, 26, 18, 0, 9, 13, 13, 13, 5, 13, 21, 15, 
    11, 20, 19, 3, 13, 19, 6, 14, 12, 16, 15, 4, 6, 8, 19, 15, 9, 9, 14, 21, 
    12, 7, 19, 13, 9, 18, 9, 17, 19, 12, 11, 8, 22, 16, 5, 4, 11, 22, 15, 13, 
    16, 22, 21, 7, 12, 9, 5, 30, 16, 2, 8, 11, 22, -3, 3, 23, 14, 10, 17, 20, 
    2, 4, 22, 19, 9, 12, 16, 15, 13, 17, 12, 5, 20, 18, 14, 14, 15, 18, 11, 16, 
    13, 13, 7, 12, 23, 7, 10, 14, 7, 12, 14, 8, 5, 2, 15, 15, -1, 17, 11, -6, 
    7, 7, 17, 6, -3, 7, 5, 4, -3, -1, 6, 5, -8, 14, 18, -9, 2, 6, 2, -5, 
    -4, -1, -6, 1, 3, -2, -4, -6, -3, -1, -10, -1, -5, -8, 5, 3, 0, 9, 6, -14, 
    -4, -3, 0, 3, -5, -1, -15, -7, -2, -8, 4, -8, -8, -6, -18, -12, -9, -10, -9, -10, 
    -3, -6, -12, -8, -11, -12, -6, -16, -10, -2, -7, -14, -21, -18, -19, -14, -12, -10, -6, -30, 
    -15, 2, -27, -23, -22, -16, -15, -18, -7, -13, -4, -18, -27, -14, -20, -23, -17, -17, -19, -16, 
    -25, -24, -25, -17, 0, -8, -14, -4, -12, -27, 6, -7, -25, -12, -6, -16, -18, -3, -7, -9, 
    -16, -15, -15, -17, -6, -3, -12, -8, -5, -13, -1, 2, -17, -10, -12, -23, -5, -17, -18, -4, 
    -6, -5, -35, -8, -12, -29, 13, -10, -12, -17, -26, -2, -8, -14, -9, -11, 1, -24, -20, -5, 
    -33, -14, -7, -10, -11, -17, -15, -18, -15, -18, -17, -11, -12, -20, -24, -17, -17, -17, -14, -20, 
    -20, -16, -22, -7, -17, -43, -22, -14, -19, -21, -22, -17, -21, -21, -20, -22, -20, -20, -21, -19, 
    -16, -17, -29, -17, -11, -22, -17, -17, -18, -23, -19, -15, -27, -22, -22, -24, -20, -28, -19, -17, 
    -31, -29, -30, -27, -13, -17, -12, -7, -3, -25, -39, -20, -29, -23, -24, -22, -23, -37, -25, -23, 
    -16, -21, -17, -17, -57, -32, 7, -17, -43, -29, -38, -33, -21, -30, -26, -17, -20, -27, -22, -32, 
    -23, -24, -26, -17, -25, -31, -23, -27, -25, -17, -26, -26, -15, -10, -20, -16, -19, -28, -17, -20, 
    -18, -12, -20, -21, -23, -24, -27, -28, -34, -21, -13, -22, -20, -30, -27, -27, -16, -20, -26, -19, 
    -16, -22, -47, -15, -17, -29, -15, -30, -13, -18, -18, -8, -32, -30, -30, -20, -28, -30, -7, -18, 
    -17, -17, -24, -14, -14, -19, -23, -17, -21, -19, -12, -21, -24, -25, -19, -17, -16, -17, -24, -14, 
    -10, -12, -19, -28, -16, -16, -11, -4, -11, -17, -28, -13, -10, -18, -10, -17, -17, -17, -16, -17, 
    -17, -4, -18, -22, -13, -31, -25, -8, -20, -31, -29, -18, -18, -14, -21, -30, -17, -23, -30, -19, 
    -17, -18, -22, -27, -17, -27, -30, -20, -27, -19, -18, -35, -23, -17, -32, -19, -25, -24, -22, -27, 
    -8, -18, -30, -19, -19, -28, -23, -19, -20, -15, -6, -16, -26, -13, -22, -32, -19, -28, -15, -8, 
    -31, -18, -27, -23, -12, -20, -16, -22, -18, -17, -25, -23, -17, -25, -26, -13, -24, -31, -12, -20, 
    -19, -14, -24, -16, -21, -24, -19, -20, -19, -12, -14, -22, -12, -18, -17, -13, -15, -9, -17, -12, 
    -13, -12, -5, -7, -15, -13, -14, -19, -8, -15, -13, -7, -7, -8, -14, -10, -5, -5, -8, -10, 
    -16, 1, 2, -4, -9, -15, -4, -6, -10, -14, -3, -2, -6, -1, -12, -3, -3, -11, -4, -19, 
    -12, 3, -10, -10, -9, -3, -4, -3, 4, -6, -10, 2, 0, -12, -3, 8, 8, -1, -12, -3, 
    -1, -9, -5, -6, 4, 3, -3, 5, 8, -8, -18, 5, 21, 3, -17, 4, 17, -6, -6, 9, 
    3, -12, 12, 23, -7, 3, 12, 1, 7, 6, -2, 9, 16, 7, 13, 10, 4, -1, 6, 16, 
    10, 9, 3, 8, 12, 1, 3, 7, 12, 9, 11, 20, 5, 13, 10, 2, 18, 7, 10, 17, 
    14, 6, 6, 8, 4, 16, 19, 20, 9, 14, 19, 10, 17, 8, 12, 10, 7, 15, 8, 28, 
    20, 2, 21, 14, -4, 6, 26, 9, 11, 21, 6, 11, 17, 15, 22, 26, 6, 15, 24, 12, 
    9, 7, 11, 5, 13, 19, 19, 15, 9, 12, 16, 4, 4, 20, 15, 8, 0, 16, 17, -6, 
    15, 12, 2, 16, 17, 17, 27, 12, 3, 15, 1, 9, 23, 17, 15, 15, 6, 9, 19, 19, 
    11, 19, 26, 8, 18, 18, 8, 11, 12, 12, 14, 31, 23, 10, 8, 12, 19, 12, 20, 30, 
    19, 10, 23, 17, 12, 24, 18, 22, 19, 16, 17, 23, 21, 23, 25, 12, 18, 23, 16, 16, 
    26, 23, 20, 14, 9, 16, 22, 26, 22, 23, 17, 22, 28, 19, 21, 14, 13, 21, 24, 27, 
    24, 29, 23, 16, 22, 33, 23, 6, 27, 25, 35, 40, 12, 19, 28, 29, 21, 23, 32, 18, 
    39, 47, 12, 24, 47, 16, 12, 23, 28, 32, 22, 24, -8, 30, 52, 23, 44, 29, 22, 29, 
    15, 21, 31, 16, 31, 27, 6, 34, 41, 16, 17, 39, 11, 14, 31, 15, 17, 19, 17, 29, 
    40, 13, 17, 20, 20, 23, 11, 10, 24, 19, 13, 27, 17, 22, 18, 12, 18, 17, 7, 15, 
    23, 6, 44, 22, -1, 20, 8, 13, 14, 16, 9, 8, 18, 12, 6, 10, 8, 8, 7, 1, 
    3, 7, 17, 11, 2, 10, 14, 0, -10, -6, 0, 6, 3, 11, 12, 3, 13, 3, -3, 8, 
    7, 1, -8, -1, 5, 9, 18, 6, 5, 13, -4, -2, 9, -1, 8, 8, -9, 10, 18, -4, 
    6, 11, -6, 5, 4, -5, 4, 6, 4, 7, 8, 12, -3, -17, 10, 5, -5, 5, -6, -6, 
    -8, 3, -7, -1, 12, -4, 9, 2, -3, 9, -13, -15, 7, 1, 2, 2, 2, 3, -2, 3, 
    -2, -8, -1, 1, -3, -5, -9, -9, -4, 0, 6, 3, -14, -7, 11, -12, -9, 9, 1, -8, 
    -13, 5, -1, -11, -4, 2, -1, 0, 5, 4, -19, -28, 8, 3, -4, 3, 6, -4, -15, 2, 
    -2, 0, 3, -6, 6, 3, 0, 0, 1, 7, -9, -17, 19, 18, -11, 11, 2, -12, 4, 2, 
    5, 1, -4, -11, -1, -1, -67, -22, 37, 2, 18, 23, 6, -3, -6, 0, -10, -2, -3, 6, 
    8, -5, -4, -2, 6, 0, 6, 0, -2, -7, -10, 2, -12, -6, 9, 2, -8, 5, 7, -5, 
    -4, 3, -2, -12, 4, -8, -7, 3, -17, -11, 2, -5, -4, 1, -3, -3, -14, -11, -5, 0, 
    -4, -13, -7, -6, -1, -8, 1, 4, 0, 0, -17, -9, -1, 2, -3, -11, -1, -1, -5, -10, 
    -10, 9, -2, -15, -9, -7, 0, 0, -14, -15, -5, -19, -19, -7, -6, 1, -11, -8, -17, -20, 
    -3, -9, 1, 0, -4, 9, -21, -10, 33, -8, -34, -13, -6, -10, -7, -10, 0, -5, -14, -10, 
    -21, 9, 3, -12, -8, -19, -9, -14, -14, 10, -3, -15, 3, -5, -14, -15, -4, 6, -1, -2, 
    -4, -5, -9, -17, -9, -3, -10, -16, -8, -9, -11, -4, -5, 1, 3, -11, -11, -9, -5, 0, 
    -7, -3, -6, -5, 5, -3, -7, -9, -11, -3, -9, -15, -8, 2, -7, -10, -3, -11, -2, 0, 
    -4, -5, -6, -16, -15, 5, -12, -15, 1, -3, 0, -4, -9, -2, 0, -8, 0, 3, -12, -7, 
    5, 7, -4, -10, -11, -6, 1, 1, -7, -2, -5, -17, -6, 0, 1, -10, -11, -1, -4, -7, 
    -9, -10, -13, 8, 5, -9, 11, 0, -16, -4, -6, -4, -7, -8, 3, -2, 3, -5, -15, -2, 
    -4, -11, -7, -9, -7, 0, -2, -4, -8, -12, -13, -14, 2, -2, -6, 2, -10, -9, -12, -13, 
    -5, -14, -9, -5, 10, 7, -23, -9, -6, -3, 10, -10, -5, -7, -11, -5, -11, -5, -7, -11, 
    -7, -7, 1, -6, -7, -2, -6, 0, -12, -20, -13, -7, -17, -13, -3, -5, -2, -11, -11, -6, 
    -25, -21, -2, -9, -7, -3, -7, -9, -5, -8, -10, -5, -6, -3, -12, -9, -3, -9, 1, -6, 
    -10, -10, -6, 1, -11, 0, 3, -21, -13, 1, -5, -2, -9, -16, -10, -6, -12, -14, -2, -11, 
    -11, -6, -11, -8, 2, 2, -16, -2, 2, -13, -1, -3, 6, 5, -5, -1, -2, 4, 10, -6, 
    -4, 10, -8, -2, 8, 5, 4, -2, 2, 6, -3, 8, 15, -4, -3, 1, -1, 9, 5, -6, 
    1, -4, 2, 6, 0, 6, 1, -8, -14, -2, -4, -12, 1, 5, 3, -4, -13, -1, 4, 4, 
    1, -4, 5, 4, -4, -4, 7, -11, -9, 5, 3, -6, -6, 2, -13, -4, 3, -4, -7, -6, 
    5, 3, -1, 0, -2, -5, -2, 1, 2, 4, 6, 4, -5, -7, 5, 11, 7, 3, 0, -2, 
    2, 12, -6, -15, 4, 1, 4, 0, 4, 0, 2, 49, -29, -47, 19, -2, -1, 2, -6, -9, 
    1, 3, -2, 1, 2, -7, -6, 8, -1, -6, 0, 1, -9, -9, 2, -5, -8, -5, -3, -7, 
    -2, -4, -5, 7, -2, 5, 4, 9, 8, -3, 2, -5, -2, 1, 2, -7, -11, 0, -2, 1, 
    0, 7, 7, -8, -5, 5, 3, 8, 9, 6, -5, -12, 2, 0, 0, -8, 6, 9, -8, 10, 
    4, -6, 2, 0, 9, 38, -1, -17, 0, 4, 22, -7, -8, -4, -2, 5, 2, 5, -7, 0, 
    8, 4, 4, 5, 1, -1, 8, 3, 3, 3, 0, -3, -6, 6, 2, 9, 7, 4, -3, 13, 
    25, -3, 12, 3, -7, 8, 11, 3, 3, 4, 1, 0, 3, 0, -2, 6, 5, 4, -2, -3, 
    -4, 5, 12, 13, 6, 2, 7, 5, 25, 28, -11, -10, 14, 1, 19, 16, -1, -10, -4, 27, 
    9, -2, 18, 21, 12, 5, 11, 20, 10, 17, 14, 5, 9, 9, 20, 14, 10, 12, 2, 10, 
    28, 28, 19, 12, 16, 18, 8, 2, 10, 26, 23, 25, 25, 13, 4, 23, 11, 47, 80, -10, 
    4, 20, 1, 14, 5, 34, 36, 18, 23, 12, 12, 19, 24, 23, 16, 23, 23, 13, 10, 18, 
    17, 17, 18, 13, 22, 25, 15, 29, 25, 35, 18, 0, 38, 27, 28, 13, 4, 25, 13, 14, 
    22, 35, 35, 17, 20, 22, 18, 27, 21, 24, 29, 25, 25, 24, 25, 26, 26, 21, 31, 31, 
    20, 28, 30, 26, 17, 24, 32, 21, 31, 37, 22, 27, 36, 29, 20, 30, 34, 43, 31, 13, 
    25, 20, 21, 21, 38, 28, 9, 25, 20, 28, 32, 22, 17, 21, 23, 32, 24, 20, 28, 18, 
    29, 33, 21, 23, 29, 14, 18, 20, 20, 34, 29, 32, 18, 26, 3, -2, 48, 23, 24, 44, 
    23, 13, 29, 27, 18, 24, 15, 20, 33, 26, 30, 28, 17, 23, 32, 28, 27, 24, 26, 24, 
    21, 38, 29, 19, 27, 36, 30, 25, 34, 24, 30, 32, 29, 36, 30, 32, 24, 35, 21, 15, 
    40, 37, 37, 32, 27, 32, 37, 27, 26, 27, 27, 37, 33, 33, 32, 35, 28, 19, 42, 43, 
    35, 41, 34, 27, 31, 39, 36, 34, 35, 32, 36, 37, 30, 33, 31, 38, 36, 22, 29, 31, 
    38, 36, 28, 35, 33, 35, 33, 29, 37, 32, 32, 33, 34, 33, 26, 29, 27, 32, 25, 26, 
    42, 38, 39, 37, 27, 35, 38, 32, 29, 32, 41, 32, 24, 36, 26, 34, 27, 77, 93, -6, 
    16, 37, 18, 31, 29, 30, 24, 27, 32, 38, 34, 27, 34, 32, 19, 17, 28, 33, 26, 35, 
    28, 23, 35, 27, 28, 29, 19, 26, 38, 18, 57, 63, -5, 18, 29, 26, 38, 21, 18, 34, 
    32, 17, 21, 16, 18, 29, 22, 9, 18, 32, 19, 19, 35, 24, 29, 25, 5, 27, 33, 23, 
    15, 24, 26, 28, 44, 9, 12, 25, 13, 25, 17, 19, 23, 18, 21, 22, 18, 14, 16, 22, 
    34, 8, 11, 26, 0, 22, 15, 11, 21, 9, -3, 16, 36, -1, -1, 14, 19, 16, 8, 6, 
    10, 8, 0, 11, 18, 9, 6, 9, 14, 12, -2, 2, 5, 8, 8, 2, 9, 3, 3, 5, 
    15, 12, -3, 14, 15, -2, 3, 5, -1, 13, 6, -12, 2, 12, 2, 0, 1, -2, 2, 4, 
    6, -6, 1, 6, -12, -4, 1, -7, -13, -3, 4, -2, -3, -3, -3, -8, -6, -12, -7, -3, 
    -15, 4, 2, -8, 2, -7, -7, -10, -10, -3, -2, -8, -16, -9, -9, -17, -11, -6, -1, 4, 
    -13, -10, -1, -8, -8, -10, -8, -11, -17, -4, -8, -17, -7, -13, -9, 23, 58, 39, 19, 41, 
    8, 7, 13, -11, 24, 26, -17, 9, 24, 4, 12, 4, 6, 8, 25, 10, -37, -25, -12, -17, 
    -25, -43, -35, -21, -39, -19, -12, -20, -10, -33, -30, -21, -28, -28, -24, -22, -27, -16, -8, -12, 
    -24, -33, -27, -34, -27, -26, -31, -14, -17, -14, -13, -19, -15, -23, -19, -15, -14, -13, -17, -14, 
    -28, -26, -15, -13, -11, -20, -23, -20, -23, -23, -24, -18, -7, -19, -28, -17, -21, -14, -13, -25, 
    -18, -21, -20, -20, -21, -10, -18, -22, -10, -15, -18, -14, -14, -17, -18, -15, -20, -17, -12, -18, 
    -14, -17, -20, -16, -23, -37, -16, 0, -23, -17, -20, -17, -19, -28, -20, -33, -28, -11, -13, -26, 
    -25, -12, -19, -22, -15, -17, -17, -26, -36, -24, -17, -8, -19, -45, -17, -10, -27, -22, -32, -38, 
    -21, -32, -24, -16, -24, -7, -26, -29, -20, -30, -19, -17, -26, -29, -27, -24, -25, -24, -21, -18, 
    -21, -24, -20, -26, -27, -16, -14, -15, -16, -17, -18, -23, -23, -19, -20, -15, -18, -31, -9, -10, 
    -26, -23, -21, -32, -31, -11, -20, -22, -22, -28, -19, -17, -35, -32, -17, -21, -17, -22, -23, -18, 
    -18, -22, -19, -7, -16, -23, -17, -20, -18, -14, -25, -18, -11, -18, -22, -16, -6, -24, -25, -16, 
    -23, -13, -20, -26, -18, -18, -17, -22, -21, -25, -5, -4, -32, -18, -19, -21, -15, -17, -17, -25, 
    -21, -16, -15, -16, -26, -6, -2, -21, -20, -20, -7, -17, -22, -13, -15, -9, -19, -24, -20, -17, 
    -21, -25, -22, -27, -16, -9, -15, -19, -19, -17, -30, -27, -16, -19, -17, -23, -34, -22, -22, -21, 
    -19, -21, -15, -19, -33, -21, -15, -23, -13, -22, -26, -27, -24, -16, -29, -35, -27, -17, -26, -31, 
    -23, -17, -22, -17, -14, -21, -26, -31, -10, -24, -23, -11, -28, -16, -18, -26, -19, -19, -14, -9, 
    -16, -23, -13, -17, -21, -16, -36, -19, -8, -17, 2, -17, -17, -8, -6, 5, -18, -17, -10, -14, 
    -9, -18, -17, -8, -7, -11, -8, -9, -39, -13, 11, -17, -6, -10, -13, -15, -30, -6, -7, -15, 
    -1, -15, -11, -1, -1, -3, -14, -11, -7, -6, -3, -8, -6, -5, -7, 3, -5, -7, -1, -9, 
    -2, -1, -5, -2, -16, -10, 8, -3, -17, -14, 4, 3, 1, -8, 2, 14, -5, 3, -8, 5, 
    8, -11, 3, -2, 4, -2, -3, 5, -7, 0, 0, 1, -2, -9, 2, -5, -1, 5, 2, 1, 
    2, -8, -6, 5, 5, 6, -1, 0, 5, 0, -7, 1, 9, -1, 1, 5, 0, -1, -7, -3, 
    2, -6, 6, 8, -4, -3, -3, 5, 2, 0, -5, 5, 4, -26, 6, 20, -6, 7, 2, -4, 
    7, -3, 1, 8, 10, 3, 0, 14, 2, 21, 9, -14, 8, 8, 6, 8, 7, 0, 5, 15, 
    4, 2, 19, 7, 2, 4, 2, 2, 1, 8, 9, 11, 2, 2, 5, 9, 11, -1, 10, 14, 
    5, 12, 7, 4, 2, -13, 7, 11, 5, 6, 3, 10, 5, 10, 11, 2, 4, -4, -1, 15, 
    12, 9, 8, 16, 7, -13, 15, 11, 8, 23, 13, 13, 10, 4, 3, 7, 10, 14, 6, 6, 
    15, 10, 6, 8, 9, 12, 12, -1, 2, 17, 17, 12, 8, 3, 7, 7, 13, 19, 2, 7, 
    6, -5, 12, 14, 9, 11, 9, 4, 2, 12, 7, 4, 16, 3, 2, 15, 5, 11, 14, 0, 
    8, 19, 18, 10, 7, 16, -10, -5, 20, 9, 7, 11, 11, 15, 22, -3, 5, 16, 7, 16, 
    7, 14, 7, 5, 17, 11, 15, 18, 8, 6, 15, 14, 17, 25, 20, 19, 19, 6, 10, 15, 
    21, 21, 11, 13, -2, 2, 12, 15, 8, 7, 21, 10, 11, 14, 11, 14, 11, 13, 11, 13, 
    1, 1, 25, 12, 4, 11, 4, 10, 15, 7, 8, 9, 14, 13, 11, 9, 13, 15, 14, 14, 
    15, 30, 13, 23, 12, -20, 7, 12, 6, 14, 12, -5, 8, 15, 2, 7, 4, 3, 11, 7, 
    1, 6, 6, 16, 0, -9, 13, 9, 5, 6, 5, -2, 10, 18, 6, 5, 9, 9, 5, 11, 
    17, 4, 20, 25, 7, 9, -5, 0, 3, -2, 9, 3, 0, 15, 4, -3, 13, 2, 5, 11, 
    11, 9, 4, 8, 9, 4, 4, 5, 6, 8, -3, -9, -5, 10, 5, 12, 15, -13, 3, 16, 
    8, -4, -2, 8, 7, 21, 0, -17, 12, 19, 8, 3, -9, -5, 8, 0, 8, 15, 3, 3, 
    12, 4, -11, -6, 13, 8, 4, 9, -1, 2, -1, 10, 19, -6, -2, 7, -5, 8, 14, 10, 
    18, 4, 14, -7, 12, 40, -46, 3, 27, -19, 26, 27, -2, -5, 13, 3, 1, 9, 5, 6, 
    -1, 5, 5, 5, 15, -1, 8, 18, 8, 8, 0, 17, 11, -5, 8, 7, 1, 8, 5, -2, 
    5, 7, -1, 4, 16, 13, 6, 2, 12, 10, 1, 13, 9, 4, 14, 4, -2, 12, 8, 1, 
    8, 14, 14, 5, -3, 6, 11, 0, 8, 6, 1, 9, 5, 0, 3, 10, 10, 11, 7, 7, 
    10, 8, 4, 7, 14, 12, -1, -4, 13, -26, -4, 44, 3, 2, 7, 7, 11, 3, 1, 10, 
    19, 11, 13, 13, 6, 5, 7, 6, 0, -1, 6, 7, 0, 0, -2, 3, 2, 2, 3, -13, 
    3, 8, -3, 4, -8, -1, 5, 6, 14, 4, -4, -5, -9, -8, 11, 0, -9, 1, -3, -3, 
    -1, -5, -1, 3, -9, -3, -6, -10, 11, 0, -3, -25, -19, 8, -13, -11, -16, -15, -4, -3, 
    -12, -9, -4, -4, 8, 15, -4, -24, -21, -16, -14, -33, -4, 16, -17, -8, -12, -17, -5, 3, 
    -6, -17, -11, -17, -15, 2, -7, -23, -6, -10, 0, -2, -17, -5, -17, 0, -2, -17, 0, -2, 
    -10, -2, 4, -7, -13, -6, -7, -8, 0, -4, -6, -8, -14, 0, 4, -3, -5, -10, -1, 1, 
    -2, 1, -2, 4, -3, -6, 3, -2, 1, -6, -8, -4, -5, -5, -3, -2, -8, -6, -4, -3, 
    0, -4, -12, 1, 2, -12, -2, -6, -6, -3, 0, -3, -8, -3, -16, -12, -15, 13, 32, -27, 
    -24, -5, -11, -15, -5, -4, -8, 4, -13, -12, -17, -14, 10, -10, -40, -17, 15, -12, -17, -7, 
    -10, -8, -13, -6, -4, -17, -11, 3, -1, -14, -20, -13, -7, -12, -18, -16, -13, -11, -20, -17, 
    -7, 3, -9, -18, -15, -18, -10, -13, -10, -13, -12, -21, -28, 5, -23, -16, 41, -19, -30, -5, 
    -20, -19, -17, -3, -15, -21, -16, -10, -11, -11, -5, -17, -18, -11, -21, -26, -5, -7, -18, -14, 
    -15, -7, -10, -23, -17, -11, -14, -13, -14, -11, -2, -5, -20, -27, -20, -14, -16, -22, -14, -10, 
    -20, -19, -17, -18, -12, -14, -15, -6, -13, -17, -18, -16, -17, -10, -11, -16, 1, -14, -20, -8, 
    -13, -16, -17, -18, -11, -2, -7, 6, 4, -35, -21, -2, -10, -3, -14, 2, 3, -35, -16, -11, 
    -12, -6, -13, -11, -15, 4, 20, 2, -24, -13, -8, -16, -8, -9, -1, 4, 0, -13, -13, -7, 
    -8, -16, -17, -5, -7, 3, -12, -12, -3, -15, 18, -2, -17, 1, -9, -3, -8, -11, -3, -4, 
    -6, -2, -5, -12, -16, 1, -5, -22, -1, -8, -10, -7, -9, 3, -4, -7, -13, -3, -3, -15, 
    -5, -3, -2, -6, -15, -17, 2, 8, -8, -8, -8, -5, -3, -2, -12, -17, -10, -12, 5, 4, 
    -4, -5, -9, -2, -5, -6, -12, -4, -18, -18, 7, -1, -2, -13, -15, -2, 0, -4, -11, -6, 
    -12, -11, -4, -13, -11, -9, -3, -7, -9, -2, -7, -8, -14, -8, -3, -15, -8, -1, -13, -5, 
    -6, -13, -4, -10, -2, 7, -1, -4, 1, 0, -9, -17, -9, -8, -14, -10, -7, 7, -16, -17, 
    -9, -36, 7, 4, -15, -9, -14, 8, -10, -15, -4, -11, -5, -5, 3, 4, -9, -6, -2, -12, 
    -3, 2, -17, -13, -2, 0, -9, -4, 1, 0, 8, -8, -10, -4, -15, -3, -4, 2, -2, -10, 
    4, 3, -6, 2, -7, 13, 37, -19, -10, 2, -16, -7, 9, -1, -13, 6, -9, -10, -3, -7, 
    -1, 4, 6, 4, -9, -7, 0, 0, 5, -3, 6, -3, -10, -6, -21, 4, 15, -2, 1, 15, 
    11, -10, -6, 8, -2, -1, 5, -9, -11, 4, 7, 0, 3, 5, 6, 8, 6, 4, 10, -4, 
    2, 12, -4, -2, 2, 6, 13, 11, 2, 12, 3, 3, 4, 9, 29, 8, 2, -1, 10, 4, 
    -10, 22, 18, 4, 6, 3, 7, 15, 3, 0, 10, 0, -2, 0, 3, 9, 0, 8, 13, 5, 
    11, 13, 1, -1, 10, 3, 6, 6, -4, 8, 13, 15, 15, 8, 4, 8, 14, 11, 17, 7, 
    5, 15, 13, 1, 9, 29, 4, 0, 5, 4, 19, 24, 13, 2, 13, 16, 2, 7, 14, 4, 
    16, 10, 8, 21, 8, -3, -2, 15, 15, 6, 12, 6, 6, 9, 8, 11, 1, 5, 11, 10, 
    15, 8, 5, 9, 5, 2, 0, 5, 10, -7, 11, 20, 0, 7, -9, 0, 8, -7, 0, -4, 
    3, 14, 12, 10, -1, 2, 11, 2, -1, 3, 7, 17, 8, 1, 2, -23, -5, 22, 2, 3, 
    5, 8, 13, 4, 13, 9, 7, 2, -1, 16, 9, 7, 21, 16, 6, 10, 4, 0, 7, 0, 
    11, 9, -9, 14, 8, 4, 5, 8, 8, -8, 12, 13, 11, 6, 10, 38, 27, 9, 1, 6, 
    14, 7, 13, 12, -6, 7, 13, 5, 6, 0, 3, 13, 5, -4, 13, 9, -4, -4, 10, 13, 
    5, 19, 3, -2, 4, 0, -5, -4, 23, 6, -5, 9, 10, 4, -2, 9, 8, 11, 3, 1, 
    13, 2, 1, 11, 3, 10, 2, -11, 20, 13, 9, 21, 12, 11, 2, 3, 9, 12, 10, 17, 
    15, 1, 6, 10, 18, 7, 11, 13, 7, 22, -7, 4, 11, 5, 23, 0, 7, 13, 1, 5, 
    15, 14, 1, 7, 3, 8, 16, -7, 13, 12, 4, 19, 14, 8, -1, 4, 14, 16, 37, 43, 
    -4, 9, 21, 3, 11, 9, 4, 10, 13, 4, 9, 11, 11, 15, 11, 5, 6, 10, 6, 7, 
    16, -5, -2, 4, 10, 20, 5, 23, 9, -8, -2, 0, 5, 13, 16, 1, 2, 12, 16, 14, 
    12, 1, 5, 18, 11, 10, 7, 6, 5, 10, 18, 13, 6, 6, 12, 6, 7, 17, 9, 12, 
    3, 2, 21, 7, 4, 10, 10, 10, -3, -5, 13, 8, 11, 17, 8, 18, 2, 7, 16, 9, 
    5, 3, 10, -14, 7, 23, 4, 5, 3, 9, 9, 16, 4, -8, 13, 17, 6, -2, -3, 3, 
    4, 6, 1, -2, 7, 7, 4, 6, 1, 2, 2, 5, -5, -7, 16, 3, 0, 13, -4, -8, 
    10, 0, 0, -13, -11, 31, 19, 1, 5, 0, -1, 2, -5, 6, 16, 8, -7, -2, 2, -10, 
    6, 0, 4, 11, -12, 0, 8, -1, 7, -7, 1, 13, -6, -1, 5, 6, 6, 4, 12, 3, 
    -2, 1, -4, 10, 12, 1, 5, 6, -1, 5, 14, -2, 4, 10, 0, 15, -1, 4, 18, -11, 
    3, 13, -3, 2, 10, 1, -4, 4, 0, 4, 5, 2, 3, -3, 14, 9, -2, 0, -8, -13, 
    4, 15, -1, 0, 7, 5, 4, 0, 4, 7, -1, 6, -4, -12, -2, 0, 6, 3, 7, -3, 
    -4, -3, -2, -1, -9, 6, -9, -9, 1, -11, -3, -3, 0, -5, -10, 4, 15, 9, -6, -8, 
    -5, -2, -3, -4, -4, -5, -9, -6, -12, -3, 11, -19, -16, -9, -20, -7, -7, -12, -8, -13, 
    -9, -2, -18, -18, -6, -14, -6, -9, -12, -8, -13, -9, -17, -16, -9, -13, -19, -16, -13, -19, 
    -17, -17, -22, -20, -14, -16, -18, -16, -13, -10, -21, -14, -20, -26, -20, -21, -17, -23, -19, -19, 
    -15, -17, -30, -18, -22, -26, -26, -22, -17, -22, -17, -22, -25, -14, -19, -26, -22, -22, -10, -4, 
    -24, -19, -17, -28, -21, -17, -23, -32, -17, -7, -6, -18, -14, -9, -22, -16, -14, -18, -25, -23, 
    -17, -18, -15, -20, -28, -13, -19, -36, -20, -6, -16, -22, -16, -18, -17, -16, -19, -15, -15, -16, 
    -19, -17, -12, -16, -17, -7, -18, -27, -18, -17, -14, -20, -12, -9, -21, -16, -7, -7, -13, -14, 
    -17, -23, 3, -2, -19, -7, -20, -11, -1, -21, -24, -16, -10, -10, -8, -11, -17, 0, -6, -23, 
    -8, -11, -13, -6, -8, -6, -10, -13, -9, -8, -14, -17, -15, -5, -11, -17, -8, -5, -3, -17, 
    -18, -12, -17, -10, -12, -15, -2, -7, -17, -22, -13, -14, -6, 12, -12, 2, -9, -32, -10, -8, 
    -22, -14, -7, -17, -12, -1, -4, -17, -14, -10, -14, -17, -9, -3, -7, 2, -4, -15, -10, -6, 
    -3, -4, -17, -12, -2, -9, -5, -3, -12, -4, -1, -3, -3, -12, 3, 2, -12, -9, -5, 1, 
    -10, -13, 0, -19, -9, 8, -5, 5, -7, 4, -2, -13, 5, 0, -5, -6, -2, -1, 0, -6, 
    -4, -1, -6, -10, -3, -6, -15, -13, -4, 0, -13, -1, 2, -4, -8, -17, -15, 0, -14, -22, 
    5, -1, -6, -6, -8, -3, -7, -2, -2, -7, -4, -2, 5, -19, -25, 5, 2, 4, -4, -4, 
    7, -7, 25, 8, -20, 8, -4, -11, -1, -5, -9, -1, -4, 1, 3, -4, 18, -1, -19, -3, 
    -13, -6, -1, -8, -3, -14, -2, -3, -16, 7, -11, -12, -5, -5, 2, -11, 0, -9, 27, -4, 
    -24, -9, -97, 5, 37, -21, 8, -9, 3, -7, -8, -5, -9, 2, -5, -5, -4, -19, -12, -2, 
    -7, 1, -3, -13, -7, 0, -6, -20, -20, -10, -13, -2, -1, -1, -3, -17, -9, -11, -12, -10, 
    -6, -5, -11, 1, -1, -7, -1, -9, -12, 0, -2, -17, -4, 3, -21, -9, -1, -3, 4, -7, 
    -17, -18, -4, 9, -8, -12, -10, 0, 8, -14, -3, 2, -8, -10, -6, 0, -5, 6, 3, -5, 
    1, -4, -11, -8, 5, 4, -10, -3, 3, 0, 11, 6, 2, 0, -11, 2, 4, 10, 3, -6, 
    15, -4, -11, 7, 2, 3, -1, 4, 25, -1, -7, 17, -12, -16, -5, 7, 16, -9, 3, 2, 
    -10, 10, 1, 2, -8, -2, 25, 0, -1, 5, -18, -11, 6, 4, 4, 4, 5, 12, -1, -13, 
    6, 9, 7, 3, 0, 2, 6, 10, 1, 3, -3, 11, 9, -2, 12, -4, 1, 13, 4, 6, 
    3, -8, -5, 11, 7, -1, -1, -2, 0, -1, 1, 7, -1, -5, -2, 7, 0, -6, 10, 7, 
    -8, 5, 11, -5, 8, 7, 0, -2, -1, 2, 0, 4, -7, 6, 19, 8, 8, -2, -9, -4, 
    -3, 5, 5, -6, 7, 8, -5, 6, 5, -3, 4, 4, -1, 1, 3, -3, -1, 4, -4, -1, 
    -4, -3, 2, 3, 9, -1, -5, -10, -10, -8, -6, -6, -7, -4, -6, -1, -5, -4, -4, 3, 
    3, -4, -3, -1, 2, -6, -2, 6, 1, -3, 0, 3, 4, 7, 2, -4, -10, 3, 2, -1, 
    10, 7, -7, -17, -6, 9, 2, 10, 6, -16, 10, 9, -13, -4, -1, 5, 2, 1, 8, 0, 
    2, -2, 1, 12, -2, 1, 4, 5, 4, -1, -13, -11, 0, -5, -8, -8, -6, 4, 15, 7, 
    2, -19, 0, 7, 0, 9, -6, 5, -12, 5, 17, -11, 11, 5, -17, 10, -14, -17, 28, -8, 
    1, 17, -6, 0, -11, 3, 3, -15, 7, 7, -6, 16, 19, -5, 0, 4, -2, -4, -13, -6, 
    4, 1, 7, 14, 2, -6, 13, -1, -9, 3, -18, -1, 20, 10, 10, 5, -5, -2, 3, 5, 
    -2, -4, -8, -8, 2, -6, -2, -1, -8, -12, -13, -3, -15, -17, 7, -3, -11, -7, 6, 0, 
    -15, -3, -10, -7, -7, -11, -6, -11, -15, -3, -5, -23, 3, 6, -8, -2, -7, 14, 16, -21, 
    -15, -1, -17, -8, -10, -15, -11, -11, -10, -9, -8, -17, -11, 2, -9, -25, -20, 0, -17, -22, 
    -3, -15, -18, -2, 11, -13, -19, -2, -10, -15, -11, -3, -13, -14, 3, -76, -45, 44, -5, -9, 
    -4, -8, -9, -13, 15, -1, -15, 11, 4, -6, -2, -2, -6, -8, -3, -10, 1, 0, -17, -14, 
    -9, 8, -4, -18, -6, 0, 1, -2, 3, -3, -15, -8, -6, -7, -14, -16, -2, -11, -6, -23, 
    -22, 12, -15, -6, -6, -21, 2, -5, -4, 5, -13, -11, -6, -19, -18, -2, -4, -9, -4, 1, 
    -5, -15, -4, 1, 4, -4, -15, -6, 4, 1, -11, -3, 1, -11, -20, 0, 0, -8, -1, 0, 
    8, -6, -9, 3, -3, -17, -15, -5, -4, -3, -15, -17, -1, -2, -12, 11, 5, -3, 3, -9, 
    -3, -4, -4, -5, -1, 0, 1, -3, 0, 2, -5, -8, -8, 10, -9, -14, -13, -1, 20, -5, 
    -22, -10, 0, -9, -12, -3, -11, -22, -2, 8, -17, -21, 4, -2, -5, -2, -5, 4, -3, 13, 
    -39, -39, 31, 10, 6, 3, 1, 4, 2, 2, -2, 3, 4, 1, -9, -11, -4, 3, 12, -6, 
    -5, 10, 18, 5, 0, 22, 5, -3, -2, 5, 7, 4, 14, 2, 8, 7, 1, 8, -4, 7, 
    4, 4, 13, 8, -4, -17, 1, 5, 2, -5, -4, 9, -3, 6, 9, 4, 11, 7, 3, -2, 
    1, 2, 0, 6, -3, -3, 5, -7, 7, 8, -15, -3, 9, -2, -1, 3, 2, -1, 7, 11, 
    -6, 2, 2, -5, 4, 3, 11, -1, -8, 7, -3, -4, -1, -1, -3, -11, 5, 1, -12, -4, 
    1, -1, 1, 6, 4, -5, -22, -3, 18, 11, 4, 3, -3, -9, 3, 4, -2, -9, 5, 2, 
    4, 17, -6, 0, 0, -2, 5, -3, 7, 6, -6, 2, 11, 6, -6, -8, 6, 9, 2, -4, 
    -6, -4, 8, 7, -17, 0, 7, 3, 10, -2, 1, 6, 4, 1, 7, -2, -5, 7, -1, 4, 
    5, 0, 4, 6, 10, 3, 1, 1, -7, -1, 6, 2, 4, 6, -1, 14, 19, -17, -4, -16, 
    -5, 26, -16, 3, 19, -7, -20, 6, 11, -1, 1, -3, 5, -15, 2, 20, 2, 2, 6, -4, 
    -2, 2, -9, 12, -12, -12, 33, 2, 8, 1, -7, 18, -12, -12, 3, -2, -14, -9, 14, 0, 
    -1, 15, -3, -6, -14, -2, 15, 5, 5, -12, -13, 1, -4, -9, 4, 5, -4, -2, -4, 0, 
    0, -5, -1, 6, 10, -9, -6, -17, 5, -11, -48, 27, 18, -2, 8, -2, 3, -3, -9, 9, 
    5, -6, 2, -8, 22, 0, -21, 4, 4, 3, -3, 3, 5, 8, 12, 10, 2, -6, 0, -4, 
    -12, 6, 9, 0, 9, 10, 17, 2, 2, 18, -4, -4, -2, -4, 0, 2, 6, 0, 21, 15, 
    -12, 8, 8, 12, 20, 19, 6, 2, 11, 7, 8, -1, 10, 15, 1, 6, 19, 13, 2, 7, 
    11, 10, -6, 10, 25, 14, 6, 11, 20, 8, 3, 9, 2, 11, 22, 8, -4, 3, 25, 13, 
    1, 11, 15, 10, 3, 2, 12, 9, 0, 4, -2, 13, 15, 8, 16, 4, 14, 10, 0, 22, 
    5, 22, 40, -8, 1, 17, 1, 3, 8, 8, 6, 3, 10, 11, 2, 3, 5, 3, 3, 10, 
    -5, -8, 2, 8, 19, 5, -4, -4, 7, 2, -2, 11, 4, 4, 7, -18, -4, 7, -4, 22, 
    9, 1, 6, 2, 7, -4, 2, 4, -13, 2, 3, -11, -7, 2, -1, -6, -1, 3, 0, 3, 
    14, 6, -4, -3, -5, -5, -4, 1, 0, 2, 7, -6, -3, 1, -6, 0, 6, -5, -3, 6, 
    0, -7, 1, 22, 4, -6, -4, -9, 4, 1, -3, -12, -10, 3, -7, -1, 3, -11, 0, 2, 
    -1, -2, -7, 1, 1, -3, -4, 4, -2, -3, -3, -15, -2, -2, -3, -2, -12, -11, -8, -6, 
    -9, 2, 2, -8, 0, -9, -12, 6, -6, -12, 0, 4, -6, -8, 3, -4, 4, -1, -13, -1, 
    -11, -8, -4, -7, 8, -4, -5, -3, -7, -1, -4, 0, -4, -6, -15, -17, 6, 0, -3, 9, 
    4, -6, -1, 6, 1, 4, 7, -3, -1, 11, 7, 0, 7, -4, -9, 12, 2, 2, -4, -1, 
    10, -5, -1, 4, 1, -2, -6, 2, 1, -2, 7, 0, 4, 2, -6, 5, 6, 1, -55, -24, 
    29, 9, -4, -6, 8, -7, 7, 0, -5, 1, 15, -6, -26, 19, -1, -7, 5, -8, -10, 0, 
    7, -4, -5, 2, -2, -2, 1, -1, 3, 11, 11, -5, -14, 3, 3, -4, 12, -3, 5, 2, 
    -12, 2, 3, 4, -9, -2, 2, -14, 2, 3, 8, 21, -5, 1, 7, -4, -2, -7, 3, 1, 
    11, 8, -7, 11, -13, 1, 15, -8, 16, 8, -2, 4, -9, -6, 9, 3, 2, 11, 6, 3, 
    7, 11, 0, 1, 22, 12, -4, -12, -9, 11, 14, 5, 11, 0, -25, 6, 4, -1, 5, -4, 
    29, 5, -6, -2, -4, 17, 4, -1, -6, 1, 8, 1, 26, 17, -5, 9, 5, 8, 5, -1, 
    -1, -1, 2, 0, 0, 17, 14, -3, -2, 2, 10, -3, 11, 14, 1, 12, 4, 9, 5, -7, 
    -3, 6, 11, 5, 5, 7, 10, 8, 7, 17, 1, -4, 14, 4, 12, 18, 4, -8, 4, 15, 
    5, 16, 10, 5, 13, 7, 2, 5, 17, 10, 2, 7, 2, -2, 10, 23, 8, 4, 20, 14, 
    2, 0, 7, 6, -8, 9, 8, -12, 8, 3, 0, 12, -10, -6, 3, 1, 6, -3, 6, 7, 
    -3, -1, 3, -5, -7, 6, 7, 8, -1, 8, 15, -3, 0, -1, -2, 7, 6, 10, 4, -3, 
    7, 5, -1, 0, 2, 6, 2, 3, 4, -7, -4, -1, -1, 5, 5, -1, 3, -1, -15, 5, 
    11, -1, 9, 11, -4, -8, -1, -11, 2, 9, -4, 2, 7, 6, 6, -2, -3, -2, 1, -1, 
    -3, 0, -3, 8, -3, 3, 3, -8, 14, 2, -5, -1, -6, 3, 10, -1, 4, 18, 1, -5, 
    -4, 3, 10, 7, 8, 0, -1, 7, 5, -2, -4, 9, 9, -9, -10, 1, -13, -12, 18, -4, 
    -2, 10, 4, 17, 10, 14, 10, 12, 13, -2, 11, 10, 7, 7, 3, 15, -1, 5, 5, -2, 
    4, -1, 14, 5, 2, 14, -4, 0, 10, 3, 9, 6, -6, 14, 26, -2, -1, 17, 25, 8, 
    -8, 11, 5, 2, 7, 7, 6, 6, 13, 9, 0, 8, 6, 0, 18, 18, 1, 6, 6, 0, 
    14, 6, -3, 14, 12, 12, 10, 0, 16, 9, 9, 18, -17, 4, 23, -9, 1, 10, 4, 6, 
    1, 9, 11, 4, 1, 3, 5, -1, 4, 6, 0, 9, 5, 7, 6, 4, 13, 11, 0, -6, 
    6, 3, 2, 7, 5, -5, 5, 14, 5, 0, -9, 7, 0, -5, 3, -13, -4, 2, 3, 7, 
    -2, 1, 3, 13, 18, 0, -1, -7, -4, 0, -5, -4, 2, 5, -4, -1, -6, -1, 3, -5, 
    0, -6, 0, 0, -5, 7, 1, 18, 6, -20, -6, -2, 6, 4, -1, 3, -1, 1, -5, -3, 
    0, -11, -3, -3, -7, -8, -2, 6, 4, 2, -12, -11, 5, -5, -8, 1, -9, -3, 1, -6, 
    -4, 0, -5, -11, -4, -1, 2, -1, -12, -4, 3, -2, 0, -5, -4, -6, 3, 38, -10, -27, 
    3, -13, -7, -9, -16, -8, -15, -7, 4, -6, -12, -13, -5, -7, -10, -2, -8, -6, 0, -13, 
    -7, -3, -20, -1, -4, -21, -1, -3, -11, -7, -6, -4, -9, -5, -7, -11, -5, -16, -16, -10, 
    -12, -12, -14, -17, -10, 0, -12, -17, -15, -14, -14, -5, -7, -6, -1, -28, -22, 11, 5, -2, 
    -14, -14, -10, -19, 5, 0, -15, 4, -7, -12, -6, -12, -9, -2, -7, -15, -7, -2, -8, -4, 
    -9, -20, -8, -18, -14, 0, -13, 4, 3, -4, -13, -22, -7, -7, -13, -16, -17, -8, -10, -14, 
    -9, -2, -9, -10, -7, -7, -2, -18, -19, -10, -10, -8, -6, 1, -9, -5, -3, -18, -18, -19, 
    -20, -16, -2, -10, -21, -6, -9, 3, -10, -10, 23, -32, -25, 6, -20, -11, -12, -17, -6, -22, 
    -16, -2, -29, -14, -6, -17, -4, -17, -12, 0, -13, -19, -14, -7, -12, -9, -3, -12, -12, 1, 
    -8, -15, -12, -15, -19, -16, -1, -6, -5, -2, -9, 0, 2, -10, -13, -6, 5, -12, -11, -3, 
    -10, 2, -7, -13, -4, -9, -13, 2, -1, -7, -6, -9, -12, -9, -12, -14, 3, -2, 1, -1, 
    -6, -6, -11, -8, -7, -6, -3, -5, -4, -1, -10, 0, 2, -9, -5, -1, -12, -12, -5, -5, 
    0, -5, -8, -2, -12, -23, 10, 1, -23, 9, 4, -8, -6, -15, -8, -9, -9, -3, 4, -6, 
    -8, 9, -5, -15, -12, -1, 2, -17, -12, -1, -6, -1, -2, -7, 6, -3, -6, 0, 5, 7, 
    -12, -9, -8, -8, -2, -3, 6, 1, -7, -6, -8, -8, 4, 1, -11, 3, -3, -13, -5, -4, 
    -2, -3, -1, -16, -13, 5, -7, -4, -5, -20, -6, -6, -17, -2, 1, -5, -11, -9, 2, -5, 
    -3, -9, -9, -3, -12, -4, -12, -8, -11, -4, 0, -14, 0, 4, -2, -4, 1, -20, -17, 1, 
    -12, -5, -2, 1, 2, -4, -7, -9, -5, -7, -1, 1, 1, -14, -16, 4, -8, -5, 1, -4, 
    1, -15, -17, -13, -17, 1, 3, -6, -4, -11, -12, -7, -10, -4, -15, -2, 18, -11, -15, -8, 
    -11, -5, 0, -2, -13, -4, -1, -17, -10, -8, -12, 8, -2, -13, -4, -13, -6, -15, -18, 0, 
    -34, -11, 10, -6, 2, -12, 13, -2, -15, -3, 1, 1, -18, -9, -1, 8, 3, -5, 2, -9, 
    -9, -4, 2, 0, -5, 2, -1, 3, -4, -6, 0, -7, 1, -2, -8, 1, -5, -3, 7, -6, 
    3, -4, 0, 1, -15, 6, -10, -16, 4, -1, -4, 0, 1, -6, 1, -5, -4, 7, -3, 2, 
    -6, 6, 8, -7, 4, -2, -5, 5, -1, -10, 8, 1, 5, -2, -12, 0, -4, 8, 5, -11, 
    -6, -10, 8, 9, -14, 3, -25, 23, 32, -19, 7, -5, -12, -5, 5, -9, 3, 11, 1, 14, 
    4, 5, 0, -3, 10, 3, -1, -4, 23, -3, -5, 74, 10, -15, 8, -9, -4, -7, 7, 9, 
    6, -1, 8, 6, -2, 9, -1, 18, 10, 0, 4, 4, 19, -19, -4, 12, -2, 9, 4, 7, 
    12, 7, 4, 16, 8, 0, -2, 7, 15, 4, 4, 3, 7, -3, 5, 12, -5, -4, 9, 12, 
    6, 7, -2, 7, 10, 6, 10, -4, 3, 8, 9, 11, -3, 0, 8, 3, 8, 5, 1, 9, 
    -2, -6, 9, 6, -2, 6, 4, -3, 4, 5, 4, 0, 9, 4, -3, 9, 1, -2, 9, 7, 
    4, 9, 3, 3, -3, -1, 6, -1, 10, -3, -7, 9, 2, 1, 5, 7, 1, 0, 0, -1, 
    11, -2, 2, 16, 4, -1, 3, 3, 2, 2, 3, 3, 24, 27, -8, -3, 5, 5, 2, 6, 
    10, -2, 9, 2, 7, 5, -6, 10, 8, 5, 9, 4, 3, 5, 2, 2, 4, 8, 11, 6, 
    4, 4, 2, 11, 6, 4, 9, 14, 9, -17, 14, 23, 1, 10, 5, -2, 8, 17, 12, 20, 
    11, 5, 3, 4, 24, 20, 10, 9, 10, 4, -1, 7, 6, 0, -4, -4, 6, 3, -2, 6, 
    5, 3, 4, -6, -1, 7, 1, -2, 11, 13, -4, -3, -3, -2, 5, 10, 3, 2, -2, -4, 
    8, 3, 6, -1, -12, 3, -1, -6, 3, -7, 5, 2, -10, 10, 0, -1, 19, -5, -27, 5, 
    2, -20, -3, 0, -5, -3, 1, 14, 5, -5, 5, 3, -11, -8, 2, -8, -8, -14, -15, 3, 
    -8, -16, -10, -16, -5, 6, 2, 0, -2, 11, -5, -18, 0, 7, 5, -7, -6, -8, 8, 15, 
    -3, -5, -4, 0, -5, -8, -4, -4, 0, 3, -1, 2, 0, 7, 2, -12, -1, 6, 8, -4, 
    3, 17, 12, 11, -2, -3, 19, 5, -4, 12, 1, 10, 0, 22, 30, -24, 11, 22, -2, -1, 
    -2, 8, 1, 5, 9, 2, 1, 9, -3, -6, 15, 10, -5, 4, 7, 5, 15, -3, 2, 14, 
    -9, 8, 13, 3, 5, -1, 6, 10, 7, 13, 8, -3, 5, 15, 10, 2, 4, 4, 5, 8, 
    12, 14, 7, 1, 9, 3, -8, 16, 9, 4, 4, 7, 14, -6, 0, 0, 22, 22, -4, 5, 
    -4, 0, 3, -2, 8, 4, 6, 3, 4, 4, 2, 12, 10, 4, 4, 12, 9, 4, 5, 5, 
    0, -3, 8, 5, 13, 7, 8, 17, 1, 5, 3, 2, 9, 13, 3, 11, 18, 5, 22, -10, 
    9, 54, -7, -2, 14, 0, 13, 4, 4, 6, 14, 21, 2, -8, 2, 7, 7, 8, 4, 12, 
    13, 2, 1, 2, -2, 2, 17, 13, 3, 5, 5, 3, -6, 12, 23, 0, 12, 5, -1, 6, 
    -5, 10, 8, 2, 7, -3, 3, 8, 13, 21, 1, 11, 13, -10, 0, 6, -8, -10, 8, 16, 
    15, 9, 1, 1, 2, 7, 10, 6, 6, 10, 3, 1, 12, 14, 7, 13, 11, -3, 0, -8, 
    31, 37, 15, 5, -7, 0, -8, 6, 8, 1, 2, 4, 11, 2, -6, 3, 3, -7, 4, 5, 
    0, 8, 1, 14, 12, 9, 14, -5, -2, -2, 1, 7, 0, 1, 12, 11, 2, 5, 0, 3, 
    7, 11, 1, -3, 15, 7, -1, -3, 7, 8, 0, 5, -2, 1, 3, 9, 14, 4, 2, 4, 
    1, 7, 4, -10, 5, 18, -3, -2, 12, 4, -1, 1, 19, 9, 2, 14, 3, 6, 0, -4, 
    8, 4, 9, 2, 0, 5, -3, 5, 4, 5, 1, -13, -2, 0, 4, 14, 7, -5, -8, -2, 
    0, 6, 4, 13, 5, -12, 2, 4, 3, 8, -22, -14, 19, 8, 9, 8, 3, 6, -1, 3, 
    8, 4, 3, -3, 12, 20, 3, 13, 26, 16, -13, -25, 4, 1, 4, 15, -17, 15, 9, -9, 
    7, 0, 14, -2, 0, 12, 2, 11, 5, 2, 9, 5, 5, 2, -2, -4, 6, -3, -9, 7, 
    -4, -5, -1, -2, -2, 6, 11, -9, -7, 4, -14, -11, 11, -14, -16, 17, 9, -3, 9, 2, 
    -10, 5, 5, -10, -4, -6, -1, -2, 10, 12, -16, 0, 1, -2, -2, -4, 7, -7, -1, 6, 
    5, 1, -4, 1, 0, -3, -7, 2, 5, -1, -2, 0, 5, 2, -3, 6, 4, 6, 2, -12, 
    6, 3, 3, 1, 0, 9, 3, 4, 0, 12, 8, -8, 5, 10, 4, 0, 6, 12, 7, -1, 
    3, 12, 7, 5, -2, -1, 13, 0, 9, 34, -7, -11, 7, -4, 0, 3, 3, -1, -1, 1, 
    9, 2, 3, 6, -7, -3, 6, 4, 5, 5, -5, 0, -1, 1, 5, -1, 11, 6, -7, -1, 
    -6, -2, 7, 2, -5, -8, 3, 7, 0, -3, -10, -9, 2, 8, -1, -13, -4, 4, 0, -3, 
    -1, 7, -5, -2, 9, -4, -4, -4, -10, -6, -5, -5, 2, 5, -4, 2, 9, -10, -16, -12, 
    -3, 6, -1, -11, -5, -4, 2, -8, -20, 5, -7, -13, -1, -7, 4, -3, -10, -3, -5, -3, 
    -8, -14, -15, -13, -2, -8, -4, -8, -4, -3, -16, -1, 0, -6, -17, -13, -4, -10, -13, -9, 
    -7, -14, -7, -4, -5, -16, -14, -4, -16, -1, 10, -7, -4, 6, -10, -12, -1, -11, -8, 3, 
    -2, -6, 0, -2, -1, -4, -7, 6, 4, -10, -4, 0, 0, 9, -13, -19, -2, 3, -4, -11, 
    6, 9, -15, -22, 1, 16, 2, -3, 11, -7, -18, -5, -14, 3, 5, -18, 5, 4, -1, -2, 
    -13, 6, 5, -4, -3, -11, -10, 5, -1, -5, -9, -4, 4, -13, -11, -11, 3, 11, -12, -14, 
    -2, -1, -9, -11, -15, -5, 8, 0, -4, -7, -2, 2, -10, -6, -8, -8, -7, -4, -1, -16, 
    -8, -14, -14, -14, -16, -4, -12, -6, -10, -6, 6, -10, -1, 3, -7, -6, -13, -7, -5, -8, 
    -8, -1, -3, -6, -11, 1, 11, -13, -4, -11, -17, -2, -7, -11, -11, -2, 4, -4, -6, -6, 
    -14, -7, -4, -10, -9, 4, 5, -1, -2, -1, -14, -3, 8, -8, 11, 5, 1, 6, 0, 7, 
    5, -7, -6, -4, 6, 0, -12, 14, 7, -3, -10, -9, 13, 8, 3, 8, -1, -5, 5, -11, 
    -8, 6, 6, 7, 5, -7, 6, 17, -19, -10, 2, -8, 5, 10, 1, 0, 2, -8, -8, 5, 
    3, -16, -7, -5, -5, 11, -2, -5, -3, -2, 2, 0, 7, 0, -7, -2, 7, -11, -17, -5, 
    -5, -2, -8, -4, -5, 0, -1, -15, -1, 11, -4, -5, -3, -5, 0, -4, -4, 0, 6, -9, 
    -1, -15, -19, 20, 11, 14, 16, -24, -39, -2, 5, -13, -3, -1, 6, 5, -6, -7, -1, -4, 
    -17, 1, 4, -14, -3, 9, 0, 5, -2, -6, -1, -10, -6, -9, -8, -6, -6, -9, -10, -1, 
    6, -1, -13, -10, -2, -4, -11, -6, -2, -1, -9, -2, -4, -12, -7, -8, -6, -6, 2, -3, 
    0, -7, 19, 32, -20, -6, 5, -7, -7, -8, -5, -7, 7, -3, -10, 3, 14, 4, -11, 8, 
    7, 0, 5, 0, 5, 23, 3, -10, 14, -2, -3, -5, -5, 11, 3, -1, -3, 11, 7, -4, 
    4, -2, 0, 10, 4, -3, -2, -9, 1, 8, -1, -3, -3, 0, -3, 9, 7, -2, 0, -1, 
    3, 4, -1, 3, 5, 5, 8, -1, 0, 5, -9, 4, 12, -3, 9, 6, 2, 10, 5, 0, 
    5, 7, 7, 9, 8, 1, -2, 4, -4, 3, 1, 2, 10, -10, 1, 5, 0, 7, -3, 10, 
    14, -6, 3, 10, 9, 10, 1, 11, 9, 0, 14, 14, 3, 1, 7, 7, 0, 1, -1, 4, 
    12, -5, 3, 14, 4, 3, -1, 7, 9, 4, 1, 5, 10, -1, 3, 10, 9, 3, 2, 5, 
    2, -1, -3, 7, 3, -2, 7, 7, 4, 2, 2, -3, 3, 11, -2, -3, -1, -3, -7, -8, 
    7, -1, -3, 4, 5, 6, -3, -11, -2, 12, -3, 2, 6, 2, -12, -8, 21, 2, 2, 6, 
    -2, -8, -3, -7, -11, 15, -2, -9, 8, 5, -3, -3, -2, 0, 1, -1, -6, -23, -8, 0, 
    -8, -5, 0, -8, 2, -6, -41, 17, 16, -18, 3, 1, -6, -16, 4, 2, -23, 5, 8, -13, 
    -6, 3, 10, -3, 3, -1, -17, -2, 3, -5, -2, 2, -1, -1, -6, -4, 9, 3, -4, 1, 
    1, -2, -6, -4, -5, 0, -6, -8, -7, -6, 0, -5, 1, -2, 6, 12, -7, -14, -8, -8, 
    1, 2, -9, -7, -3, -1, -7, 4, 14, -1, -11, -14, -5, 8, 0, -4, 4, -4, -2, -8, 
    -17, -3, -11, -2, 2, 0, 3, -1, -3, -6, -6, -2, -3, 1, 12, -11, -5, -4, -7, 12, 
    -8, -8, 4, -4, -3, 0, -6, -3, -4, -5, 4, -10, -16, -6, -4, -6, -10, -2, 0, -11, 
    -6, 2, -8, -16, -6, -3, -12, -2, -3, -8, -5, -9, -6, -5, -3, 0, -3, -9, -8, -10, 
    -6, -10, -12, -7, -17, -17, -11, -14, -9, -2, -3, -2, -11, -16, -14, -11, -1, -9, -12, -11, 
    -11, 5, -4, -14, 0, -5, -13, -3, -5, -7, -7, -1, 7, -10, -7, -3, -14, -14, -13, -6, 
    -7, -25, 3, 11, 8, 34, -24, -23, -53, -127, -67, 2, 34, 29, 14, 4, -11, -2, -5, -7, 
    4, -9, -15, -10, -3, 1, -2, 1, -1, -14, -16, -6, -2, -9, -1, 3, -6, -11, -3, 4, 
    -12, -10, 1, -12, -12, 6, -2, -4, -1, -14, -1, 5, -9, -14, -9, -10, -2, -8, -7, 8, 
    -7, -1, -2, -7, -4, -4, 3, -8, -3, 2, 0, -1, 0, 6, 0, -5, -7, -4, -4, 0, 
    2, -2, 4, 7, -8, -3, 8, -3, 6, 8, -1, -6, -7, -2, 0, 4, 4, -8, -4, 2, 
    -7, 5, 9, 9, 1, -7, 3, -7, 0, 2, -8, 2, 5, 0, 7, 5, -4, 1, -2, -3, 
    0, 0, -6, -10, -4, 3, 13, 7, -7, -10, -4, 4, 8, -3, -16, -1, -5, -15, -6, -5, 
    -5, 3, 6, -1, 5, 4, 4, 3, 2, 5, 2, 6, -9, -10, 1, 9, 14, -7, -10, 5, 
    4, -3, -1, 5, -3, 7, 9, -4, 4, 8, 5, 5, -8, -5, 10, -8, -2, 5, 1, 4, 
    -1, 6, -5, -11, 6, 1, 1, 9, -4, -12, -17, -9, 3, -10, -8, -3, -9, -12, -2, 10, 
    -2, -9, -5, -9, -1, 1, -5, -3, 1, 1, -5, 2, 8, -9, -9, -1, -7, 4, 1, -4, 
    -1, -2, 7, -1, 2, 6, 15, 8, 4, 20, 5, 1, -2, 2, 4, 4, 9, -1, -4, 8, 
    11, 8, -1, -3, 9, -2, -3, 8, 2, 4, 0, 2, 7, 9, 9, -4, 5, 11, 7, 1, 
    0, 11, 3, 6, 9, 4, 14, 4, 8, 15, 5, 8, 2, 5, -4, 5, 6, -2, 13, 5, 
    18, 4, -5, 6, -2, 7, 19, 12, -3, 5, 8, 2, 18, 10, -19, 4, 16, 7, 10, 2, 
    14, 17, 11, 13, 9, 2, 6, 4, -2, 16, 8, 13, 17, 0, 9, 9, 5, 0, 4, -11, 
    7, 20, -1, 6, 10, 12, 0, 5, 15, 0, 0, 6, 3, -4, 0, 4, 13, -2, -7, 17, 
    3, 6, 10, 8, 9, 0, 4, -5, -7, 9, 3, 5, 8, -2, 2, 16, 11, -4, -1, 4, 
    -1, -1, 4, 1, 5, 12, 3, 5, 5, -3, -3, -6, 1, 10, 14, 9, 8, 16, 6, -4, 
    0, 3, 6, 4, 1, 5, 11, 4, 4, 4, -2, 3, -5, -1, 0, -1, 4, -4, 10, 2, 
    -17, -1, -1, -13, -6, 6, 21, 1, -11, -1, -3, 4, -7, -16, 2, -7, -7, 8, -4, -11, 
    -10, -1, -5, 2, -12, -6, 22, -8, -6, 0, -11, -8, 1, -7, -14, -1, 2, 8, -2, -5, 
    8, 6, -1, -3, 12, 5, -10, -2, 48, 66, -5, -38, -18, -8, -15, -1, 13, 8, 3, -5, 
    -5, -7, -5, -1, 3, 1, 5, 0, -4, -6, -12, -1, 5, 5, -10, -3, 11, -4, -7, -13, 
    -7, 7, -4, -1, 10, -6, 1, 0, -10, 2, 0, 3, 0, 3, 4, -5, 0, 4, -10, -11, 
    4, -4, -5, 5, -9, -3, 2, -15, 7, -1, -17, 2, -1, -5, -7, -4, -2, -12, -13, -6, 
    -5, -6, -7, -6, -14, -13, -6, -9, -4, 1, -9, -19, -6, -6, -11, -15, -25, 1, 4, -11, 
    -7, -11, -8, -13, -9, -12, -23, -14, -12, -11, -15, -17, -13, -13, -19, -22, -15, -17, -17, -2, 
    -10, -5, 4, -9, 3, 0, -9, -2, 4, -17, -25, 1, 6, -4, -7, -3, -1, -5, -15, -17, 
    -5, -4, -23, -10, -7, -17, 9, 1, -10, 2, -4, -8, 6, 12, -4, -6, -2, -9, -9, -3, 
    -5, -8, 10, -1, -17, -2, -4, 6, -1, -20, -22, -17, 6, 4, 5, 3, -11, -3, -4, -9, 
    -2, 3, 0, -2, 1, -3, -1, -2, -2, -4, -10, 3, -4, -14, -2, -5, -1, 9, -4, -2, 
    5, 8, 10, -2, 10, -36, -35, 27, -1, -7, 8, 5, -6, 1, 14, -1, 2, -2, -15, -3, 
    8, -4, -13, 5, -1, -9, 3, -5, -13, 3, 16, 5, 7, 6, -6, -16, -10, 3, 1, 9, 
    -6, -11, -10, 1, 10, -2, 2, 0, -2, -3, -5, -4, 4, 5, -7, 8, 5, -8, 4, -3, 
    -4, 5, 30, 8, -15, 12, 7, 6, 2, 3, 8, 13, 15, 18, 21, -1, -3, 12, 6, -1, 
    -2, -1, 4, 9, 18, 13, -1, -10, -4, -7, 2, 4, 1, 11, 10, -4, -2, 11, -16, 2, 
    0, -3, 26, -1, 2, 14, 1, 4, 9, 0, 4, 3, 5, 12, 4, -6, -2, 2, -1, 13, 
    7, 7, 7, 3, 0, 29, 28, -23, 5, -12, -17, 25, 6, 5, 5, 7, 11, 3, 7, 5, 
    1, 8, 26, 6, -6, 7, -2, 0, 0, 3, 13, 13, 4, 3, -2, -2, 7, 2, 5, 8, 
    3, -1, 5, 13, 2, 1, 4, -1, 11, -1, -1, 8, 0, 14, 15, 8, -7, 5, 8, -6, 
    10, 10, 4, 5, 2, 0, 1, 7, 1, 3, 8, 3, 13, 9, 12, 1, -23, 13, 24, 5, 
    -5, 13, 24, 5, 24, 20, 10, 18, 4, 4, 6, 1, 7, 15, 9, 8, 20, 19, 13, 7, 
    5, 13, 9, 16, 33, 10, 6, 15, 8, 15, 16, 7, 22, 20, -1, 7, 7, 10, 22, 11, 
    4, 13, 14, 9, 10, 15, 10, -7, 9, 12, 9, 21, 5, 12, 8, 6, 23, 5, 15, 27, 
    13, 12, 11, 7, 9, 13, 9, 19, 15, -2, -1, 11, 9, 11, 9, -3, 20, 21, 13, 4, 
    3, 17, -2, -6, 17, 15, 12, 8, 11, 5, 2, 11, 6, 15, 8, 11, 16, 12, 16, 4, 
    13, 18, 15, 9, 4, 12, 10, 14, 15, 12, 26, 17, -6, 15, 17, 7, 21, 14, 9, 16, 
    11, 2, 5, 9, 6, 8, 28, 11, 8, 21, -9, 8, 13, 0, 19, 7, 4, 10, 8, -13, 
    0, 23, 5, 14, 10, 5, 5, 3, 13, 7, 15, 8, -6, 8, 11, 0, -7, 16, 21, 5, 
    -3, 10, 14, 1, 11, 14, 14, -3, 7, -2, -18, 20, 21, 12, 6, 19, 9, 1, 6, -8, 
    9, 9, 6, -10, 0, 14, 5, 11, 10, 0, 0, -1, 1, 14, -4, -4, 4, 6, 4, -3, 
    2, 6, 6, 4, 11, -4, 0, 11, 1, 2, -8, -2, 7, -4, 4, 7, 10, 7, -9, 10, 
    6, -4, 13, 12, 8, 9, 10, 10, 10, 5, -4, 4, 17, 19, 13, 4, -1, 12, 9, -3, 
    0, -5, -2, 6, 3, -3, -2, -1, 4, 4, 0, 2, 10, 11, 4, 2, -1, -3, 2, 0, 
    -4, 5, 4, -23, -9, 14, 11, 14, 1, 4, 5, 2, 5, 2, 7, 0, -1, 13, 1, 4, 
    -2, -17, 7, 1, -7, 2, 6, -1, 2, -5, 3, 13, -5, 6, -4, -2, -10, -12, -1, -8, 
    7, 16, 13, -18, -2, 2, -13, 1, 5, 8, -18, 3, 19, -3, 2, 10, -3, -4, 8, -35, 
    -4, 23, -4, 0, -13, -9, -7, -17, -12, 3, -11, -3, 3, -15, -2, 6, 1, -3, -2, -3, 
    -2, -5, -7, -1, -2, -10, -17, -2, 0, -7, -10, -18, -12, 0, -16, -16, 4, -13, -4, -1, 
    -13, -6, -14, 2, 0, -4, -3, -15, -18, -21, -7, -7, -4, 4, -10, -11, -4, -2, -13, -13, 
    -4, -10, -8, -11, -11, -18, -3, -20, -28, 4, -17, -8, 4, -9, -6, -3, -23, -23, 3, -4, 
    -8, -16, -15, -16, -22, -4, -5, -6, -8, -16, -1, -4, -23, -14, -8, -4, -14, -8, 5, -24, 
    -3, 0, -4, 5, -14, -13, -7, -10, -73, -33, 51, 2, -10, 3, -2, 41, 24, -19, -7, -9, 
    -7, 2, 1, -9, -5, -6, -10, 3, 5, 2, -2, -5, -3, -9, -7, 4, 5, -10, -7, -9, 
    -7, -4, -27, -9, 4, -3, -4, -14, -6, 4, 3, -12, 4, 20, 1, -1, -1, -13, -3, 4, 
    -16, -11, -4, 1, 5, -8, -4, 5, -5, -3, -5, -10, 1, -5, -10, 7, 5, -16, 3, 5, 
    -16, -8, -2, 2, -1, -5, -2, -6, -7, -2, -5, -7, -7, -11, 6, 0, -10, 15, -3, -9, 
    7, -8, -4, 4, -4, -2, 3, -1, 8, 4, -8, 2, 7, -1, -12, -2, 5, -3, -1, 5, 
    0, -7, -2, 0, 1, 7, -10, -5, 9, -9, 2, 3, 0, 1, -3, 0, -1, 1, -6, -2, 
    -2, -8, -12, -8, 0, -7, -2, 12, 1, -7, -3, -4, -2, -2, -6, 2, 0, -8, 3, -3, 
    -3, 2, -16, -5, 4, -2, 0, -7, 4, -6, -15, 5, 3, -1, -3, -11, -12, -9, -10, -16, 
    -6, 8, -15, -22, 5, 4, -2, -5, -11, -7, -11, -7, -2, 0, -8, -19, 8, 14, -14, -10, 
    0, -11, -8, 6, -17, 0, 13, -4, 16, 3, -2, -2, -7, 10, -1, 10, 7, -7, 2, -6, 
    0, -6, -7, -2, -2, -2, 3, 4, -3, -9, 2, 14, -14, 1, 10, -6, -2, -5, 15, -2, 
    11, -32, -69, 21, 12, 8, 11, -2, 3, -7, 10, 3, 9, 3, 6, 17, -6, 2, 11, -2, 
    2, 5, 5, 10, 0, 3, 13, 12, 0, 0, 10, 10, 1, 1, 12, 3, 5, 15, 13, -4, 
    3, 15, 5, 17, 16, 8, 14, 9, 4, -1, 5, 1, 6, 12, -2, 2, 2, 1, 9, 14, 
    12, 0, -3, 15, 6, -14, 7, -5, -10, 22, -1, 4, 11, 3, 15, -7, -10, 0, 4, -4, 
    6, 7, 2, 7, -15, 0, 5, -4, 2, 2, 6, -6, 2, 12, 4, 1, -8, 2, 10, 9, 
    15, 5, -8, -1, -1, -2, 5, 12, 8, -7, 5, 3, 5, 13, 0, -2, 4, 2, 5, 8, 
    -5, 2, 11, 13, 4, 6, 6, -10, 7, 6, 1, 10, 0, 0, 8, 9, 16, 9, -18, 12, 
    28, 5, 9, 11, 16, 5, 6, 9, 5, 9, 3, -1, 15, 14, -7, 9, 19, 10, 7, 7, 
    17, 7, 7, 6, 8, 26, 11, 0, 8, 5, 1, 16, 14, 9, 5, -2, 19, 23, 4, -4, 
    5, 7, 9, 10, 11, 5, 16, 19, 10, 17, 2, 18, 25, 4, 14, 12, 8, 12, 10, 13, 
    8, 3, 12, 17, -15, -4, 22, 16, 9, 3, 21, 16, 24, 22, 8, 19, -4, 14, 9, -17, 
    23, 26, 9, 4, 10, 2, 5, 19, 18, 33, 13, 3, 4, 2, 13, -3, 10, 13, -3, 9, 
    13, 10, 6, 6, 2, 2, -12, -7, 10, 0, 2, 7, 0, -2, 5, 13, 5, -3, 3, -6, 
    2, 6, -2, 1, -1, 2, 7, -2, 2, 11, -8, 13, 17, 4, 21, 4, 8, 17, 27, 33, 
    13, 25, 21, 6, 21, 31, 15, -7, 5, 20, 16, 14, 11, 11, 6, 13, 15, 12, 20, -5, 
    0, 21, 2, 3, 4, 5, 11, 8, 3, 2, 14, -3, -4, -6, -1, 7, 3, 3, -10, -5, 
    -6, 7, 9, -11, 1, -3, -9, 7, -6, -10, -10, -10, -11, -17, -5, -8, -11, -16, -20, 0, 
    -11, -18, -4, -10, -17, -33, -26, -23, -22, -15, -22, -2, -6, -25, -4, 3, 8, 16, 11, 23, 
    9, -2, 4, 12, 1, -18, -11, 11, 11, 0, 18, 23, 19, 23, 7, 1, 4, 4, 10, -3, 
    -10, 3, 0, -5, -1, -3, 5, -2, -12, 0, -11, -10, 7, -18, -17, 2, 0, 1, -11, -9, 
    -3, -10, -13, -5, -4, 2, -6, -7, -3, -9, -2, -8, -12, -10, -4, -9, -15, -6, -13, -16, 
    -17, -17, -11, -1, -4, -26, -21, -11, -17, -13, -9, -8, -12, -12, -4, -30, -20, 2, -12, -8, 
    -14, -23, -28, -23, -17, -19, -17, -24, -22, -17, -20, -18, -17, -23, -22, -13, -20, -12, -13, -26, 
    -18, -22, -23, -18, -4, -5, -16, 1, -7, -19, -10, -23, -22, -3, -18, -20, -19, -19, -3, -18, 
    -24, -8, -17, -16, -12, -8, 7, -17, -36, -10, -25, -30, -25, -29, -12, -23, -25, -38, -19, 7, 
    -22, -45, -23, -1, -17, -23, -13, -12, -10, -16, -20, -17, -12, -15, -19, -11, -16, -13, -18, -22, 
    -13, -22, -18, -10, -10, -26, -29, -24, -20, -14, -22, -22, -17, -17, -19, -21, -23, -24, -32, -26, 
    -9, -20, -24, -19, -15, -17, -23, -30, -32, -20, -29, -29, -15, -17, -17, -14, -16, -9, -19, -26, 
    -17, -28, -24, -17, -28, -21, -18, -15, -17, -25, -23, -20, -22, -25, -17, -20, -24, -15, -29, -18, 
    -17, -30, -19, -22, -9, -15, -19, -17, -25, -14, -28, -29, -9, -3, -22, -39, -16, -11, -30, -32, 
    -27, -24, -19, -4, -18, -21, -17, -27, -8, -23, -17, -21, -14, -1, -37, -10, -12, -16, -6, -22, 
    -17, -20, -19, -16, -13, -6, -14, -15, -13, -10, -11, -17, -16, -5, -13, -14, -8, -20, -8, -9, 
    -24, -14, 3, -9, -16, 6, -2, -11, -8, -10, -18, -18, -10, -20, -12, -1, -4, -13, -15, -9, 
    -7, -17, -23, -17, -10, -4, -12, -17, -21, -10, -25, -29, -6, -20, -16, -16, -20, -5, -12, -15, 
    -3, -13, -15, -2, -15, -11, -12, -22, -11, -4, -5, -8, -17, -18, -12, -7, -4, -9, -15, -18, 
    -19, -17, -9, -21, -13, -1, -13, -8, -18, 2, -19, -25, 7, -16, -5, -3, -7, -12, -13, -3, 
    -13, -14, -11, -2, -8, -17, -2, -6, -7, -2, -5, 9, 1, 7, 12, -17, -15, 4, -8, -6, 
    6, -5, -4, -4, -5, -1, -3, -4, 5, 5, -5, 3, 8, 0, -9, 0, 14, -4, -3, 6, 
    2, 9, 3, 0, -5, 5, 13, 0, 5, 17, 10, -8, -1, 5, -3, 14, 9, -4, 7, -1, 
    5, 31, 8, -9, 13, 16, 3, 0, -5, 4, 8, 2, 13, 6, 2, 5, 6, 5, 0, 5, 
    22, 34, 5, -6, 1, 7, -5, -8, 26, 4, 0, 1, -4, 14, -2, 5, 7, 8, 0, -4, 
    -2, -3, 8, -2, 10, 1, -9, 9, 5, -5, 3, 13, 11, 4, 1, 16, 6, 7, 17, 5, 
    8, 13, 7, 8, 14, 3, -4, 0, 9, -2, -1, 6, 6, 16, 2, 10, 4, -2, 11, -3, 
    7, 16, 7, 4, -2, -1, 10, 7, 23, 15, -5, 6, 10, 12, 2, 4, -4, -5, 6, -5, 
    1, 5, 5, 12, 4, 7, 15, 12, 9, 18, 22, 4, 5, -7, -1, 25, 10, 7, 19, 9, 
    -4, 2, 11, 9, -2, 1, 9, 1, 3, 0, 2, 11, 17, 14, 3, 10, 17, 15, 7, 7, 
    4, 8, 12, 4, 5, 8, 13, 10, 11, -1, 7, 23, -1, 6, 10, 7, 13, 3, 27, 26, 
    -3, 2, 4, 7, -5, -9, 3, 5, 12, 10, 9, 8, 2, 5, 8, 6, 4, 3, 12, 8, 
    1, 12, 19, -1, -6, 14, 10, 9, 1, 10, 15, -5, 0, 3, 10, 15, -3, 0, 20, 16, 
    0, -3, 2, 13, 14, 5, 13, 13, 13, 2, -5, 12, -4, 23, -10, -51, 33, 13, -3, 23, 
    9, 16, 13, -1, 3, 3, 4, 21, 3, 4, 13, -3, 8, 4, 1, 11, 8, 17, 10, 10, 
    11, 0, 16, 11, -2, 8, 12, 8, 12, 5, -5, 5, 8, 1, 14, 5, 1, 16, 13, 16, 
    9, 13, 8, 0, 7, 16, 21, 12, 9, 5, 8, 10, -2, 2, 5, 10, 18, 4, 10, 23, 
    1, -4, 17, -5, -1, 5, 1, -3, 6, -3, -18, 25, -8, -1, 9, -10, 8, 2, 4, -2, 
    -2, 2, 0, -2, 2, -3, -2, 7, 4, 8, -12, -14, 15, 1, -10, -2, -1, -2, 1, -5, 
    -10, 0, 1, 8, -2, -14, 0, -2, -2, 2, -6, 3, 1, -9, -9, -9, 6, -9, 3, 14, 
    -23, -9, 0, 4, 3, -8, -7, -1, 17, 9, -12, -6, -5, -7, 5, -15, -24, -3, 5, -5, 
    -9, 8, -5, -9, -4, -8, -1, -10, -11, -8, -9, -10, -2, -9, -8, -5, -3, 3, -8, -9, 
    -19, -6, -4, -12, -5, -14, -3, -2, -2, -11, -16, 0, -10, -6, -7, -21, -11, -9, -3, 4, 
    -18, -10, -11, -15, -2, -10, -9, -14, -11, -8, -6, -6, -15, -16, -13, -7, -14, 4, 7, -5, 
    -4, -15, -6, 4, 4, -13, -10, -4, -19, -21, -8, 1, -14, -13, 8, -17, -25, -1, -7, 1, 
    5, -4, -26, -10, -8, -24, 0, -9, 11, 1, -14, 10, 2, 10, -5, -9, -12, -5, 8, -22, 
    -6, -2, -10, -2, -9, 3, -1, -9, -5, -7, -11, -8, 0, 2, 6, 0, 1, -1, -8, 1, 
    -9, -4, -13, -31, -2, 4, -7, 3, 8, -5, -13, -8, 5, 1, -16, -11, -7, 0, -8, -10, 
    6, -2, -17, -6, 3, -2, -1, -7, -6, -11, -5, -8, -7, -15, -24, 7, 1, -12, -13, -6, 
    -3, -5, 51, 63, -19, -43, -29, -17, -8, -16, -12, -10, -16, -17, -2, -8, -17, -11, -11, -6, 
    -5, -10, -9, -6, 1, -10, -27, -10, -11, -2, -6, -29, 16, -15, -23, 5, -10, 2, -14, -10, 
    6, 7, 4, -9, -11, -6, -11, 1, -4, -8, -2, 1, 13, -1, -4, -7, -7, 0, -2, -1, 
    -11, -9, 3, 3, 3, -3, -6, 7, 2, -10, -10, 4, -1, -13, 7, 7, -14, 0, 0, -15, 
    -2, 2, 11, 9, -2, 8, -4, -8, 4, -6, -8, 8, 10, -2, 6, 10, 12, 3, 2, 12, 
    -1, 1, 6, 4, 5, 1, 12, 8, -7, 4, -3, -10, 6, 14, 1, -7, -2, 4, 0, -6, 
    6, 3, -1, 9, 0, -9, -1, -18, 1, 8, -12, -13, -7, 10, 1, 6, -5, -5, 6, -12, 
    5, 6, 5, 24, 9, -13, -13, -6, 0, 9, 4, -1, 0, -3, -12, 0, 4, 10, 7, -3, 
    3, -1, 11, 0, -3, -4, -3, 10, -11, -12, 8, 10, -4, 0, 11, -5, -12, -17, -18, -7, 
    5, 3, 8, 2, -12, 7, 7, 3, -13, -26, 13, 17, -11, -1, 8, -7, -5, -8, -7, -2, 
    -5, 2, -22, -31, -15, -9, 0, 11, 11, -3, -9, -17, -7, -5, -10, 13, 10, -4, -7, 5, 
    9, -13, -4, 8, -16, -2, 5, 3, 4, -19, -14, -7, 2, 11, -16, -14, 2, -8, -15, -6, 
    -6, -12, -9, -7, -3, -12, -13, -1, -5, 1, 8, -4, 1, 13, 5, -5, 1, -14, -12, 0, 
    -13, -14, -26, -8, 9, -1, -3, -7, -4, -2, -10, -14, 7, -6, -15, 5, 0, -4, -9, -10, 
    0, 2, 6, 3, 1, 3, -15, 0, 7, -1, 1, -12, -1, -5, 2, 9, -4, 2, -5, 8, 
    -3, -14, 9, 5, 8, -16, 6, 32, -3, -1, -2, -8, 4, 12, -12, -9, 3, -2, 2, -1, 
    0, 1, 3, 2, -3, -12, -3, 18, 4, 1, 9, -3, -1, 2, 2, -5, -8, -2, 4, 0, 
    4, 11, -5, -2, 3, 0, 11, 4, -8, 5, 3, 1, 3, -11, -9, 1, 11, 0, -24, -6, 
    8, 1, -7, -8, 0, -7, 1, 0, -3, -1, -8, -4, 9, 19, -4, -1, -2, -17, -1, -4, 
    11, 8, -15, -4, 3, -6, -7, 1, -2, -1, -16, 11, 21, -18, -3, -10, -24, -17, -4, 4, 
    -10, -3, -7, -4, -2, -11, -9, -8, -4, -8, -5, -5, 2, -1, -16, -11, -2, -1, -5, 1, 
    -15, -8, -2, -16, -9, 5, -6, -21, -11, -10, -2, -6, -16, -7, 5, 2, -5, -9, -5, -11, 
    -22, 1, 4, -8, -6, -9, -7, 0, 6, -2, -6, -7, 6, -5, -31, -8, -11, -11, 8, 2, 
    0, -4, -7, -8, -17, -7, 5, 3, -2, -1, 1, -21, -11, -4, -7, 0, -2, -1, -2, 0, 
    -12, 3, 2, -4, 9, -5, -1, 3, -4, 5, -8, -10, -1, -8, -7, 0, 8, 5, -6, -6, 
    4, -4, -17, -6, 21, 9, 13, 24, -22, -1, 4, -1, 13, 6, 5, -17, -1, 8, 3, 2, 
    -1, 4, 0, 6, 4, -1, -4, 5, 15, -1, -1, 0, 1, 13, 5, 4, -4, -4, 0, 7, 
    14, -9, 1, 15, 4, 4, 7, 5, 2, 7, 3, -12, 2, 5, 4, 11, -2, 3, 13, 8, 
    -13, 9, 11, -3, 11, 3, 7, 8, 2, -2, -4, 6, 13, 12, 10, 18, 8, 7, 5, -8, 
    19, 28, 9, 10, 23, 11, 0, 12, 11, 12, 11, 13, 17, 14, 21, 15, 2, -1, 5, 12, 
    5, 7, 8, 2, 2, 10, 8, 3, 17, 8, -2, 12, 11, 7, 12, 18, 12, 3, 9, 11, 
    25, 13, -14, 4, 7, 7, 6, -3, 22, 9, -6, 9, -7, 10, 8, 0, 9, 3, 18, 3, 
    10, 14, 1, 18, 17, 13, 11, -1, 3, 8, 9, 14, 10, 6, 8, -3, 1, 10, 9, 25, 
    15, 9, 6, 8, 18, 9, 13, 7, 9, 12, 11, 16, 14, 17, 13, 11, 14, 8, 6, 7, 
    10, 6, 10, -2, -4, 25, 13, 3, 1, 3, 16, 5, 2, 14, 9, 9, 9, 4, 14, 6, 
    3, 15, 5, -3, 10, 14, 12, 8, 12, 4, 4, 10, 6, 13, -5, 1, 11, 9, 13, 3, 
    6, 11, 14, 22, 6, -6, 3, 6, 12, 3, 6, 16, -5, 4, 11, 7, 13, 4, 14, 20, 
    5, 1, 7, 5, 9, 17, 7, 11, 14, 3, 4, 4, 7, 15, 11, 13, 4, -6, 11, 9, 
    1, 6, 13, 12, 14, 6, -8, 5, 11, 17, 8, -3, 16, 7, 7, 14, 6, 22, 19, 4, 
    11, 12, 7, 6, 16, 15, 6, 15, 8, 14, 14, 4, 11, 2, 1, 10, 13, 6, 5, 15, 
    9, 0, 12, 9, -5, 10, 14, 10, 12, 5, 6, 1, 4, 7, -2, -1, 17, 17, -11, 7, 
    17, 7, 1, -19, -5, 10, 3, -1, 7, 10, 9, 17, 6, 5, -6, -15, 2, 11, 11, -4, 
    3, 4, 2, 12, -6, 1, 4, -3, 16, -2, 1, 10, 2, 4, 6, 9, -1, 10, 3, -3, 
    10, 7, 12, 7, 6, 12, 10, 5, 0, -2, 11, 17, 6, 5, 4, 7, -1, -5, 14, 9, 
    9, 4, 11, 27, 3, 1, 7, 1, 0, -6, -5, 7, -1, -4, 0, -14, 2, 9, 8, -5, 
    -13, 9, 12, 10, 0, 6, 13, -1, 3, 11, 4, 6, 3, 3, 17, 0, -17, -5, 2, -2, 
    -7, -8, -10, -5, 5, -2, 3, 6, -5, -2, -1, -8, -1, -1, 3, 11, -8, -5, 1, 3, 
    6, -3, -2, -2, 9, -1, -32, -3, 7, -1, 6, -18, 3, 21, 1, -8, -12, 10, 16, -4, 
    3, 4, -12, -5, 10, 11, 1, -5, -3, -2, 0, -7, 1, 3, -7, -1, -14, -12, 12, 1, 
    -5, -3, 3, 14, -3, 3, 3, -12, -4, -4, -8, 3, 4, -12, 6, -18, -27, 11, -8, -2, 
    2, -9, -3, -7, -1, -9, -14, 6, -3, -7, -3, -16, -12, -10, -13, -14, -12, -4, -18, -6, 
    6, -16, -6, -10, -3, -1, -10, -3, -8, -11, -12, 1, -5, -7, -1, -8, -3, -1, -5, -11, 
    -8, -5, 1, -18, -19, 3, 4, -1, -16, -9, -2, 3, -2, -15, -11, -8, 7, 5, -4, 4, 
    0, -3, -11, -18, -7, -12, -16, -6, -8, -9, -13, -13, -6, -6, -17, -20, -10, -7, -7, -11, 
    -12, -5, -16, -17, -8, -15, -10, -11, -6, -10, -6, 1, -10, -9, -15, -7, -10, -12, 2, 1, 
    -6, -5, 17, -8, -24, -4, -16, -12, -3, -5, -2, -3, -11, -7, -1, -7, -8, -12, -6, -7, 
    -10, -5, -4, 0, -8, -13, -10, -9, 0, -2, -9, -3, -6, -8, -3, -4, -5, -14, -12, -4, 
    -1, -4, -4, -5, -12, -5, 0, -6, -1, 0, -15, -1, 2, -6, 6, -8, -6, -7, -17, -7, 
    3, 1, -10, -11, -20, -9, -4, -14, -5, -6, -4, -5, -1, -9, -4, 3, -7, 4, 0, -13, 
    -11, 1, -7, -8, -3, -8, 22, 17, -12, -4, -10, -3, 6, -2, 0, -5, 2, 0, 1, 8, 
    1, 4, -1, -3, -11, -5, -12, -10, 5, -2, -6, -10, -3, 0, 13, -1, -14, -1, 0, -3, 
    -2, 3, 0, 6, 3, 2, -1, -5, 10, 3, 3, 1, -5, 3, -8, 8, 9, 4, 15, -13, 
    -9, 2, -5, -4, -1, 5, 8, 10, -4, 1, 8, -1, 1, -9, -1, 8, -1, -1, -3, 3, 
    4, 13, 8, -1, -1, -7, 4, -8, -9, -3, -6, 7, 5, -5, -7, -7, -1, 3, 2, 2, 
    0, -5, -5, -6, -7, -4, -6, -2, 4, -1, -5, -3, -2, -4, -5, 4, -6, -10, 4, -6, 
    -3, -8, -7, 0, -11, 0, -2, -6, -5, 1, 10, -10, -11, 7, 2, 0, 0, -3, 0, -7, 
    -6, 3, 7, 3, -16, -7, 19, -3, -8, 0, -10, -3, -5, -9, 2, 4, -4, -2, -3, -9, 
    1, 14, -2, -3, 12, -4, -1, 4, -1, 5, -5, 4, 9, 7, -1, -1, 10, 8, 11, 0, 
    -6, 2, 9, 15, 4, 4, 11, 1, 0, 7, 9, -2, 4, 14, -1, 5, 8, -4, 0, -1, 
    5, 10, -3, 5, 11, 3, 4, 9, 10, 10, 9, 9, 0, 2, 8, -2, 5, 8, 3, -3, 
    -5, 1, 5, 9, 7, 10, 7, 1, 9, 4, -5, 7, 10, 9, 14, 5, 7, 7, 12, 8, 
    3, 6, 0, 6, 8, -2, -21, 8, 19, 5, 9, 12, 9, 7, 10, 0, 12, 1, -1, 14, 
    0, 1, 5, 5, 4, 4, 11, -2, 10, 14, 6, 2, 2, 1, -6, 19, 7, -6, 6, 0, 
    7, 1, 0, 13, 2, -5, -3, -1, 5, 2, 7, 0, -1, 2, -6, -1, -4, 3, 13, 7, 
    -1, 13, 12, 3, 11, 5, 4, 5, 0, 7, 10, 2, 5, 0, -7, -2, -1, 12, -2, -1, 
    14, 1, 3, 5, -4, 7, 18, 8, 3, -5, 3, 13, 7, 7, 1, -1, 15, 11, 3, 9, 
    3, 7, 5, 14, 10, -11, 4, 12, 6, 4, 9, 9, 8, -4, -4, 11, 3, 9, 10, 9, 
    2, -3, 12, 26, 10, -11, 2, 12, 16, 11, 6, 5, 14, 13, 0, 4, 7, 14, 25, 15, 
    2, 9, 4, 13, 23, 3, 4, 11, 8, 9, 6, 10, 10, 11, 14, 5, 13, 15, 16, 15, 
    2, 2, 14, 18, 8, 5, 9, 17, 13, -1, 9, 0, 9, 11, -6, 15, 16, 14, 10, -1, 
    3, 12, 7, 16, 13, 5, 16, 16, 8, 2, 7, 10, 18, 15, 9, 14, 14, 16, 20, 18, 
    18, 18, 11, 10, 13, 13, 13, 9, 12, 15, 11, 13, 7, 8, 13, 16, 12, 9, 17, 10, 
    4, 8, 13, 14, 14, 12, 17, 5, 4, 12, 13, 15, 5, 7, 7, 11, 24, 13, 15, 18, 
    7, 11, 26, 28, -1, 5, 6, 4, 11, 9, 20, 8, 6, 8, 11, 14, 3, 3, 3, 2, 
    22, 14, 8, 21, 10, 0, 3, 8, 4, 3, 6, 7, 11, 16, 13, 15, 4, 2, 8, 3, 
    8, 9, 5, 9, 5, 8, 9, 12, 16, 9, 9, 11, 7, 6, 11, 13, 9, 8, 6, 1, 
    11, 16, 9, 21, -8, -17, 23, 16, 7, 5, -1, 13, 8, 0, 20, 20, 11, 5, 14, 14, 
    2, 11, 5, 7, 13, 7, 7, 7, 10, 5, 9, 1, -5, 9, 8, 6, 1, 1, 9, 16, 
    11, -3, 5, 7, -2, 1, 5, 3, 12, 3, -3, 5, 3, 8, 0, 8, 6, -3, 6, 9, 
    12, 7, 8, 10, 2, 10, 9, 3, 11, 7, 6, -1, 8, 19, 11, 6, 16, 13, -3, 6, 
    9, 13, 12, 12, 0, 1, 17, 5, 11, 11, 6, -1, 6, 20, -2, 0, 13, -3, 7, 4, 
    -8, 1, -3, 8, 7, -4, 3, 7, 4, 5, 2, -1, 3, -17, -17, 18, 9, 2, 5, 2, 
    12, 6, 9, -1, -7, 3, 8, 5, 14, 8, -4, 35, -6, -24, -1, 0, 5, -2, 12, 2, 
    4, -11, -9, 5, -5, 1, -5, 6, 8, 9, 8, -3, -5, -7, 4, 11, -3, 0, -2, -3, 
    0, 0, 7, 6, 5, -1, 2, -13, -15, 2, -9, 7, 1, -10, 4, -2, 8, 6, -8, -7, 
    -4, -2, -3, 1, -7, -2, 5, -11, 3, 7, -6, 0, -2, -1, -9, -8, 3, -6, 0, 0, 
    -11, -8, -3, 1, -2, 3, 0, -4, 1, -7, -2, -2, -1, -22, -19, 8, -1, -3, -5, -2, 
    -1, 2, 2, -4, -7, -1, 0, -14, -17, -7, -14, -15, -4, -11, -3, -9, -16, 0, 0, -3, 
    2, 0, -9, -17, -8, -2, 1, -18, -18, 16, -6, -16, -1, 0, 1, -10, -8, -7, -17, -8, 
    -5, -11, -5, -4, 4, -7, -16, 3, 0, -9, -10, -7, -2, -1, -11, -5, -9, -5, 1, -14, 
    1, -5, -10, -5, -11, 9, 3, -24, -9, 2, -8, -1, 3, -3, -7, -8, -3, -5, -3, 6, 
    -7, -7, 2, -16, -21, -9, 12, 3, -18, -2, -7, -12, -5, -6, -4, -9, -4, -6, -21, -17, 
    -8, -11, -7, 4, -1, -8, 3, -4, -4, 1, -14, -14, -14, -14, -9, -17, -19, -2, -9, -11, 
    8, -13, -8, 11, -15, -23, -18, -9, -10, -1, 10, -6, -1, -1, -12, -12, -2, -6, -10, -14, 
    -9, 4, -8, -7, -8, -5, 0, -8, -17, -18, 0, -6, -9, -2, -11, -3, -4, -13, -6, -8, 
    -14, -15, -13, -5, -5, -10, -6, -8, -8, -16, -17, -3, 1, -17, -26, -6, -11, -5, -8, -17, 
    -8, -14, -8, -11, -18, -14, -6, -5, -11, -12, -13, -13, -11, -7, -9, -16, -13, -6, -5, -16, 
    -23, -12, -7, -11, -5, -4, -10, -8, -5, -4, -14, -14, -12, -15, 0, -1, -9, -11, -2, 4, 
    -19, -11, -2, -12, -12, 10, 4, -18, -1, -7, -12, -10, -6, -10, -15, -8, -11, -10, -2, -8, 
    -14, -14, -17, -3, -2, -11, -10, -12, -11, -6, -11, -17, -9, -7, -6, -5, -3, -1, -1, -5, 
    -7, 16, -7, -19, -4, -10, -5, -15, -6, -4, -10, 1, -2, -2, 1, -8, -10, 0, 6, 2, 
    -5, -12, -7, 0, -2, -9, -7, -2, -10, -1, -2, -6, -7, -8, -1, -4, -12, -8, -6, -14, 
    -2, -3, 0, 4, -9, -10, -13, -16, -2, -7, -14, -3, -8, -9, -1, -17, -17, -11, 0, 10, 
    -21, -7, -13, -23, -1, -7, -12, -9, 0, -17, -17, -3, -18, -8, 11, -11, -16, -2, -3, -3, 
    -14, -11, -1, -11, 0, -3, -20, -11, -14, -9, -3, -8, -11, -12, 0, 1, -5, -6, -7, -11, 
    -8, 9, -4, -15, -8, -4, -1, -16, -6, -1, -13, -19, -11, -4, -17, -8, -4, -6, -6, -11, 
    -15, -8, -4, -8, -22, -18, -12, -11, -2, -5, -21, -19, -15, -15, -1, -14, -13, -8, -12, -7, 
    -4, -11, -16, 3, 
  };

#endif /* NOISE_STATIC_1_16384_H_ */
