#ifndef CHUM9_H_
#define CHUM9_H_

#include <Arduino.h>
#include "mozzi_pgmspace.h"

/* A sampled guitar sound
*/

#define CHUM9_NUM_CELLS 8192
#define CHUM9_SAMPLERATE 16384

CONSTTABLE_STORAGE(int8_t) CHUM9_DATA []  =
        {
                29, 42, 43, 38, 44, 37, 44, 35, 42, 51, -108,
                -82, -34, -72, -50, -65, -57, -61, -53, -59, -60, -53, -56, -58, -55, -55, -57,
                -56, -56, -56, -54, -53, -54, -54, -52, -51, -58, -52, -53, -55, -51, -54, -48,
                -52, -52, -49, -49, -49, -50, -54, -43, -50, -41, -61, -1, 107, 45, 48, 57, 44,
                59, 47, 55, 49, 54, 53, 50, 57, 54, 49, 50, 54, 51, 53, 54, 47, 49, 47, 54, 50,
                47, 47, 43, 52, 50, 45, 49, 47, 42, 44, 46, 46, 46, 46, 50, 51, 47, 45, 46, 46,
                46, 46, 45, 46, 47, 46, 44, 50, 42, 43, 43, 35, 56, -77, -91, -19, -71, -43,
                -51, -56, -46, -50, -46, -47, -50, -48, -45, -53, -50, -48, -49, -47, -45, -45,
                -46, -49, -49, -45, -46, -46, -48, -46, -42, -46, -43, -43, -43, -44, -44, -38,
                -45, -43, -43, -44, -38, -42, -40, -39, -39, -37, -35, -42, -40, -37, -40, -35,
                -41, -33, -49, -21, -53, 2, 127, 39, 52, 67, 48, 64, 53, 61, 56, 58, 56, 56, 55,
                58, 56, 58, 56, 54, 58, 52, 52, 54, 55, 53, 51, 53, 51, 49, 52, 54, 48, 48, 54,
                49, 48, 47, 43, 47, 50, 41, 54, 33, 50, 32, -95, -62, -42, -65, -48, -56, -48,
                -52, -51, -50, -52, -55, -53, -53, -52, -47, -48, -49, -51, -49, -49, -52, -50,
                -51, -47, -49, -52, -49, -47, -49, -48, -44, -50, -47, -48, -50, -49, -48, -47,
                -48, -48, -47, -44, -45, -49, -48, -46, -45, -49, -46, -45, -44, -46, -44, -44,
                -47, -38, -45, -30, -68, 45, 112, 10, 57, 52, 45, 50, 41, 45, 42, 52, 46, 51,
                48, 50, 48, 43, 48, 49, 50, 46, 44, 45, 45, 46, 47, 48, 45, 45, 46, 42, 43, 41,
                38, 40, 42, 41, 41, 40, 39, 42, 36, 38, 37, 38, 39, 32, 39, 34, 46, 29, 46, 31,
                40, 51, -115, -64, -30, -72, -45, -67, -47, -54, -55, -52, -49, -52, -54, -50,
                -54, -51, -50, -50, -52, -52, -49, -51, -51, -49, -51, -50, -48, -49, -48, -50,
                -48, -49, -48, -45, -50, -46, -45, -47, -42, -47, -41, -52, -37, -60, -23, 116,
                43, 31, 70, 35, 52, 45, 51, 52, 50, 51, 52, 49, 48, 52, 49, 49, 47, 46, 45, 45,
                47, 47, 43, 42, 43, 43, 45, 43, 41, 46, 47, 45, 46, 45, 47, 46, 42, 45, 43, 46,
                46, 42, 45, 46, 45, 45, 44, 41, 47, 43, 42, 49, 44, 46, 34, 48, 27, 60, 7, -116,
                -42, -53, -54, -38, -51, -38, -50, -43, -50, -42, -45, -47, -47, -46, -43, -46,
                -39, -45, -43, -42, -43, -42, -46, -41, -41, -41, -38, -41, -38, -41, -39, -33,
                -40, -38, -35, -40, -40, -36, -36, -36, -37, -36, -36, -37, -32, -37, -35, -37,
                -38, -32, -36, -34, -56, -27, -55, 5, 113, 34, 58, 55, 44, 59, 45, 56, 49, 52,
                48, 54, 51, 48, 48, 48, 48, 44, 48, 47, 46, 49, 50, 47, 47, 48, 44, 46, 43, 45,
                45, 41, 43, 45, 43, 43, 42, 44, 46, 48, 45, 51, 36, 44, 39, -86, -75, -31, -65,
                -46, -50, -55, -55, -54, -46, -51, -53, -55, -44, -41, -47, -41, -46, -45, -49,
                -44, -41, -42, -38, -43, -41, -39, -41, -47, -38, -40, -46, -38, -39, -42, -45,
                -41, -42, -41, -40, -40, -43, -43, -38, -41, -42, -40, -44, -44, -40, -41, -36,
                -40, -38, -42, -38, -48, -40, -29, -67, 59, 82, 20, 56, 36, 52, 48, 45, 45, 40,
                48, 41, 44, 44, 39, 40, 39, 35, 38, 35, 39, 40, 38, 43, 36, 36, 35, 34, 37, 34,
                35, 39, 41, 36, 39, 38, 35, 40, 36, 33, 36, 36, 34, 35, 28, 30, 34, 35, 39, 29,
                32, 26, 37, 37, -60, -71, -34, -59, -49, -48, -50, -49, -49, -46, -47, -47, -49,
                -47, -46, -43, -44, -45, -47, -45, -42, -48, -46, -44, -45, -42, -45, -42, -41,
                -42, -39, -43, -41, -41, -47, -44, -38, -46, -36, -49, -35, -48, -36, -45, -34,
                117, 52, 31, 64, 38, 58, 45, 53, 46, 49, 54, 54, 50, 52, 51, 50, 38, 32, 42, 41,
                40, 41, 41, 43, 40, 40, 44, 38, 41, 42, 36, 41, 39, 35, 41, 42, 41, 40, 35, 39,
                40, 38, 38, 35, 41, 41, 37, 38, 39, 41, 36, 38, 37, 40, 41, 31, 42, 30, 48, 24,
                52, 28, -105, -35, -33, -54, -36, -50, -39, -48, -39, -42, -39, -44, -45, -41,
                -42, -36, -37, -39, -38, -37, -37, -39, -41, -37, -36, -41, -39, -37, -40, -41,
                -38, -36, -36, -35, -39, -37, -35, -37, -36, -33, -34, -32, -34, -35, -35, -34,
                -30, -32, -33, -34, -29, -55, -20, -62, 7, 120, 20, 51, 56, 42, 54, 40, 52, 43,
                50, 52, 45, 48, 47, 48, 47, 47, 49, 45, 52, 50, 50, 50, 44, 46, 43, 41, 43, 41,
                42, 41, 43, 40, 39, 41, 36, 38, 40, 38, 41, 41, 35, 46, 31, 56, -26, -104, -36,
                -54, -47, -48, -51, -48, -53, -42, -54, -48, -48, -35, -38, -44, -36, -43, -40,
                -38, -38, -38, -38, -36, -38, -41, -41, -36, -42, -41, -37, -35, -38, -38, -32,
                -36, -39, -39, -35, -40, -37, -30, -36, -35, -35, -35, -35, -29, -33, -35, -32,
                -35, -35, -39, -34, -36, -32, -44, -51, -39, -54, 50, 88, 17, 43, 40, 35, 37,
                41, 44, 40, 43, 40, 42, 40, 43, 42, 38, 42, 35, 38, 39, 33, 37, 37, 38, 32, 31,
                34, 38, 34, 33, 36, 29, 34, 36, 30, 32, 34, 37, 34, 30, 31, 31, 34, 31, 33, 30,
                37, 27, 37, 26, 40, 1, -104, -29, -38, -56, -34, -49, -47, -49, -40, -46, -37,
                -44, -44, -46, -46, -42, -44, -44, -47, -43, -43, -43, -39, -40, -47, -44, -41,
                -45, -42, -42, -40, -39, -41, -38, -38, -36, -36, -37, -38, -35, -35, -36, -35,
                -31, -41, 22, 92, 42, 40, 51, 49, 49, 47, 53, 47, 53, 48, 52, 49, 53, 48, 27,
                40, 39, 31, 41, 39, 36, 40, 38, 38, 39, 38, 36, 34, 33, 32, 37, 38, 36, 34, 33,
                33, 36, 35, 31, 28, 28, 33, 33, 31, 30, 30, 31, 31, 30, 37, 36, 35, 33, 35, 30,
                36, 34, 43, 53, 21, 72, -38, -87, -9, -55, -33, -40, -41, -38, -42, -42, -45,
                -37, -44, -38, -38, -39, -36, -35, -38, -33, -35, -40, -37, -36, -37, -37, -33,
                -34, -35, -36, -37, -34, -34, -34, -30, -26, -30, -30, -28, -31, -32, -30, -28,
                -31, -31, -30, -26, -28, -28, -27, -52, -39, -31, -55, 28, 74, 37, 51, 44, 43,
                47, 42, 43, 43, 46, 43, 47, 42, 42, 45, 39, 41, 45, 43, 42, 39, 41, 41, 41, 39,
                35, 37, 37, 42, 42, 37, 39, 39, 39, 35, 40, 35, 41, 36, 28, 45, 16, 61, -41,
                -114, -14, -57, -46, -47, -54, -46, -55, -46, -51, -47, -55, -38, -28, -37, -34,
                -32, -33, -33, -36, -36, -33, -33, -32, -31, -33, -34, -30, -31, -32, -32, -31,
                -29, -30, -31, -30, -31, -32, -30, -30, -32, -32, -30, -29, -29, -27, -32, -31,
                -33, -34, -29, -35, -33, -31, -34, -34, -57, -45, -41, -54, -33, -73, 57, 84, 3,
                55, 31, 37, 33, 39, 34, 29, 41, 33, 33, 31, 36, 33, 30, 33, 33, 32, 30, 34, 31,
                30, 36, 31, 35, 33, 29, 30, 31, 31, 33, 33, 25, 29, 29, 27, 28, 25, 29, 27, 24,
                29, 22, 31, 24, 24, 29, 12, 51, -72, -84, -8, -62, -34, -47, -45, -38, -46, -39,
                -41, -42, -45, -42, -42, -41, -43, -39, -44, -44, -37, -38, -38, -36, -38, -36,
                -36, -38, -34, -35, -34, -36, -39, -36, -33, -37, -35, -33, -42, -33, -37, -32,
                -36, -33, -31, -36, 65, 69, 36, 53, 46, 54, 44, 50, 53, 46, 53, 52, 49, 50, 55,
                35, 22, 38, 30, 31, 34, 31, 33, 32, 31, 30, 29, 29, 29, 29, 30, 31, 30, 29, 33,
                31, 25, 31, 32, 30, 32, 29, 31, 32, 33, 30, 27, 30, 33, 35, 35, 31, 28, 30, 28,
                30, 32, 34, 34, 39, 59, 42, 42, 70, -58, -74, -11, -44, -30, -37, -33, -35, -38,
                -39, -37, -35, -36, -38, -40, -32, -35, -35, -34, -34, -31, -31, -30, -30, -30,
                -31, -31, -29, -24, -29, -30, -26, -29, -27, -28, -31, -27, -27, -26, -26, -27,
                -28, -27, -22, -27, -26, -26, -26, -21, -32, -59, -30, -43, -43, 83, 52, 28, 51,
                29, 48, 40, 42, 41, 42, 42, 42, 41, 40, 41, 41, 42, 39, 43, 42, 36, 39, 44, 39,
                39, 34, 35, 38, 31, 35, 35, 33, 37, 33, 35, 34, 36, 34, 36, 34, 24, 55, -44,
                -81, -31, -56, -40, -50, -49, -48, -49, -44, -48, -46, -51, -40, -22, -32, -35,
                -29, -31, -29, -29, -29, -34, -29, -29, -29, -30, -31, -27, -28, -33, -28, -25,
                -30, -29, -31, -29, -27, -31, -27, -26, -28, -28, -28, -27, -30, -31, -30, -30,
                -33, -32, -32, -26, -28, -32, -25, -29, -23, -45, -53, -41, -42, -53, -33, -56,
                -28, 84, 30, 27, 44, 27, 42, 28, 37, 33, 32, 35, 34, 33, 31, 32, 32, 30, 28, 31,
                32, 32, 31, 28, 26, 26, 29, 30, 28, 27, 29, 25, 23, 26, 26, 24, 27, 29, 24, 25,
                23, 24, 22, 24, 21, 26, 11, 35, -13, -108, -54, -48, -32, -34, -45, -34, -44,
                -33, -41, -40, -38, -39, -39, -38, -36, -34, -35, -37, -36, -36, -36, -38, -34,
                -33, -37, -32, -36, -35, -31, -34, -30, -33, -34, -32, -33, -32, -32, -34, -34,
                -33, -28, -35, -29, -39, -22, -46, 0, 104, 32, 46, 59, 37, 53, 46, 51, 46, 49,
                45, 47, 44, 52, 39, 15, 31, 29, 25, 28, 27, 29, 24, 27, 28, 24, 26, 28, 28, 26,
                23, 25, 23, 26, 27, 26, 26, 26, 26, 25, 26, 23, 24, 27, 27, 25, 25, 25, 25, 27,
                26, 21, 25, 26, 22, 26, 20, 42, 57, 45, 36, 62, -10, -91, -21, -30, -42, -28,
                -36, -28, -32, -31, -31, -33, -30, -29, -28, -32, -29, -27, -34, -30, -30, -25,
                -28, -30, -27, -30, -27, -28, -26, -25, -28, -26, -25, -26, -27, -23, -22, -22,
                -19, -24, -21, -22, -25, -23, -21, -18, -26, -22, -19, -25, -16, -31, -55, -46,
                38, 64, 22, 40, 37, 32, 34, 34, 40, 36, 36, 38, 33, 36, 37, 31, 35, 35, 34, 34,
                33, 32, 32, 32, 29, 33, 32, 31, 36, 33, 36, 33, 32, 28, 31, 34, 29, 31, 29, 38,
                19, 57, -21, -95, -23, -52, -49, -42, -49, -49, -46, -47, -50, -49, -47, -46,
                -52, -15, -20, -32, -19, -26, -23, -26, -23, -21, -22, -22, -26, -26, -25, -23,
                -23, -27, -25, -25, -23, -24, -23, -21, -25, -26, -23, -22, -24, -25, -25, -26,
                -25, -25, -26, -24, -24, -25, -25, -25, -21, -27, -25, -21, -29, -20, -43, -59,
                -43, -45, -52, -33, -60, 7, 79, 12, 35, 30, 26, 35, 21, 35, 27, 29, 27, 28, 29,
                24, 25, 29, 26, 28, 27, 25, 29, 26, 24, 22, 22, 23, 20, 20, 21, 21, 21, 24, 21,
                23, 21, 21, 19, 20, 18, 21, 21, 24, 21, 13, 40, -68, -95, -25, -73, -52, -19,
                -35, -36, -33, -33, -30, -32, -31, -30, -33, -31, -32, -34, -34, -33, -28, -30,
                -33, -32, -31, -30, -32, -34, -34, -31, -31, -31, -30, -28, -26, -30, -28, -30,
                -31, -30, -33, -31, -28, -26, -32, -23, -36, -25, -37, 10, 90, 38, 44, 52, 46,
                55, 41, 50, 45, 47, 48, 45, 49, 42, 52, 17, 9, 30, 16, 26, 23, 23, 21, 19, 25,
                23, 23, 20, 19, 21, 21, 22, 19, 21, 22, 20, 20, 21, 22, 20, 24, 24, 19, 22, 21,
                24, 22, 19, 25, 21, 19, 24, 18, 18, 19, 22, 17, 33, 65, 40, 51, 38, 59, 26, -82,
                -25, -24, -29, -23, -39, -22, -31, -25, -29, -28, -25, -29, -27, -25, -24, -23,
                -25, -24, -23, -26, -25, -25, -22, -22, -23, -22, -22, -23, -23, -26, -23, -20,
                -23, -19, -21, -22, -17, -19, -18, -21, -18, -19, -17, -20, -20, -12, -23, -11,
                -26, 42, 60, 7, 47, 24, 27, 32, 23, 32, 28, 32, 28, 29, 27, 30, 29, 32, 33, 30,
                31, 28, 29, 31, 30, 30, 29, 30, 30, 27, 28, 27, 28, 29, 26, 31, 30, 26, 30, 26,
                32, 27, 23, 29, 20, 35, -42, -76, -37, -47, -46, -50, -41, -48, -47, -47, -48,
                -47, -43, -48, -31, -3, -24, -20, -18, -21, -16, -22, -21, -20, -20, -19, -18,
                -18, -22, -22, -18, -15, -17, -22, -19, -18, -20, -20, -19, -17, -15, -17, -23,
                -18, -20, -21, -18, -22, -22, -19, -19, -24, -21, -18, -20, -17, -19, -16, -17,
                -15, -33, -65, -31, -53, -28, 66, 31, 21, 29, 23, 30, 23, 27, 27, 24, 22, 22,
                21, 18, 20, 23, 21, 22, 21, 18, 21, 20, 20, 22, 19, 20, 17, 15, 22, 21, 19, 17,
                15, 17, 17, 16, 20, 18, 17, 20, 14, 14, 15, 19, 9, 30, -3, -93, -56, -46, -64,
                -43, -64, -33, -7, -31, -30, -25, -27, -32, -26, -27, -30, -25, -28, -26, -29,
                -26, -27, -27, -22, -25, -29, -29, -27, -22, -24, -26, -27, -25, -24, -26, -24,
                -25, -25, -26, -23, -26, -25, -23, -27, -19, -30, -9, -41, 18, 94, 31, 50, 49,
                44, 48, 43, 52, 44, 51, 50, 44, 48, 40, 53, 42, -5, 22, 20, 15, 24, 13, 21, 15,
                15, 17, 17, 16, 16, 19, 15, 14, 17, 13, 15, 15, 12, 14, 15, 14, 17, 17, 16, 17,
                16, 17, 18, 17, 16, 17, 20, 15, 16, 18, 16, 22, 13, 20, 11, 32, 65, 34, 49, 38,
                48, 24, -57, -23, -22, -26, -18, -28, -20, -31, -24, -24, -23, -21, -25, -23,
                -25, -21, -23, -23, -19, -23, -21, -20, -21, -20, -20, -16, -21, -19, -18, -19,
                -15, -17, -18, -17, -18, -20, -17, -17, -16, -16, -19, -17, -19, -17, -22, 9,
                84, 54, 47, 60, 9, 25, 29, 21, 28, 21, 27, 25, 26, 27, 25, 25, 26, 24, 25, 27,
                24, 24, 25, 25, 25, 23, 24, 24, 23, 25, 25, 24, 26, 26, 24, 25, 26, 26, 24, 21,
                23, 23, 20, 27, 16, 29, 16, 32, 10, -99, -41, -33, -61, -35, -50, -41, -47, -43,
                -44, -45, -45, -45, -45, -45, -3, -11, -21, -12, -18, -14, -16, -15, -15, -15,
                -17, -13, -13, -14, -14, -15, -12, -15, -15, -13, -14, -16, -15, -13, -14, -13,
                -15, -14, -13, -14, -16, -16, -14, -15, -14, -15, -14, -15, -14, -15, -18, -14,
                -19, -10, -31, -75, -17, 57, 27, 16, 23, 16, 25, 22, 24, 21, 23, 20, 20, 25, 18,
                20, 20, 19, 19, 19, 19, 18, 21, 18, 19, 19, 15, 19, 16, 17, 17, 17, 18, 15, 16,
                18, 16, 15, 19, 17, 17, 16, 11, 18, 9, 18, 7, 24, 1, -105, -51, -42, -69, -42,
                -59, -48, -50, -57, -6, -18, -34, -14, -28, -18, -23, -22, -23, -23, -22, -22,
                -21, -21, -15, -20, -20, -21, -21, -21, -23, -22, -23, -19, -22, -23, -23, -23,
                -24, -20, -17, -20, -18, -19, -16, -20, -13, -25, -9, -28, -9, 90, 46, 44, 52,
                37, 54, 46, 51, 50, 47, 46, 48, 46, 50, 26, 6, 16, 17, 16, 13, 12, 12, 12, 12,
                17, 11, 11, 16, 10, 9, 7, 9, 10, 8, 11, 9, 11, 9, 9, 8, 12, 14, 9, 16, 14, 10,
                12, 15, 12, 14, 12, 13, 11, 12, 6, 6, 14, 8, 21, 2, 36, 57, 43, 29, 55, 12, -83,
                -2, -23, -34, -13, -24, -14, -29, -20, -16, -17, -21, -24, -21, -15, -23, -16,
                -17, -22, -13, -13, -17, -19, -13, -16, -17, -18, -20, -12, -16, -16, -18, -18,
                -16, -14, -10, -18, -12, -11, -9, -11, -8, -12, -22, 43, 63, 51, 54, 41, 62, 36,
                0, 22, 18, 21, 20, 17, 23, 15, 18, 15, 14, 19, 19, 21, 19, 19, 20, 16, 21, 15,
                20, 25, 15, 23, 23, 17, 23, 24, 21, 24, 20, 14, 16, 20, 20, 19, 13, 22, 11, 21,
                13, 26, -1, -83, -38, -41, -50, -39, -46, -40, -50, -43, -49, -48, -46, -43,
                -47, -42, -39, -47, 0, -2, -19, -11, -15, -6, -11, -11, -11, -10, -10, -10, -9,
                -9, -7, -9, -9, -8, -12, -10, -8, -12, -9, -13, -10, -8, -10, -7, -12, -9, -8,
                -16, -12, -9, -10, -11, -10, -5, -8, -12, -9, -12, -6, -43, -56, 32, 42, 8, 24,
                21, 17, 18, 16, 19, 16, 17, 18, 19, 18, 17, 20, 17, 15, 15, 15, 17, 15, 12, 14,
                13, 12, 12, 14, 11, 12, 13, 12, 12, 10, 13, 12, 12, 10, 15, 9, 13, 12, 10, 13,
                3, 23, -49, -81, -42, -52, -54, -54, -50, -52, -51, -50, -54, -49, -61, -26, 6,
                -30, -17, -16, -19, -15, -21, -17, -18, -17, -20, -15, -18, -18, -16, -17, -16,
                -14, -12, -15, -17, -16, -17, -19, -16, -16, -17, -14, -12, -15, -13, -17, -14,
                -14, -18, -11, -22, -6, -30, 19, 89, 38, 48, 50, 45, 49, 46, 53, 43, 49, 43, 49,
                48, -2, 5, 16, 3, 11, 10, 13, 13, 11, 8, 11, 6, 8, 9, 7, 8, 9, 10, 7, 10, 9, 8,
                10, 10, 6, 5, 9, 10, 10, 8, 10, 10, 10, 7, 7, 9, 7, 9, 8, 8, 9, 9, 9, 3, 14, 1,
                24, 57, 48, 39, -39, -27, -3, -30, -7, -18, -20, -13, -17, -16, -17, -17, -16,
                -16, -15, -16, -16, -16, -15, -11, -13, -14, -14, -13, -15, -13, -10, -11, -8,
                -11, -11, -13, -11, -9, -11, -11, -13, -8, -12, -12, -12, -3, -17, 7, 77, 57,
                43, 53, 53, 49, 55, 57, 45, 60, 14, -5, 20, 11, 16, 15, 13, 14, 19, 16, 12, 15,
                15, 16, 18, 14, 15, 19, 15, 13, 14, 16, 15, 15, 13, 12, 16, 17, 17, 14, 13, 16,
                14, 13, 11, 15, 8, 16, 10, 18, 6, -73, -50, -36, -51, -45, -50, -45, -46, -46,
                -50, -46, -47, -45, -46, -50, -39, -56, -17, 15, -16, -6, -7, -6, -3, -6, -4,
                -8, -4, -4, -4, -9, -8, -6, -6, -4, -7, -6, -6, -7, -5, -7, -8, -2, -6, -7, 1,
                -4, -7, -7, -6, -5, -5, -3, -7, -6, -8, -5, -8, -10, -8, -14, 6, -68, -7, 66,
                -11, 15, 13, 10, 12, 10, 14, 11, 16, 8, 10, 14, 10, 10, 15, 13, 10, 13, 9, 9,
                15, 14, 11, 12, 12, 13, 14, 8, 8, 10, 7, 8, 7, 8, 10, 4, 10, 3, 15, 3, 9, 11,
                -80, -52, -39, -60, -45, -53, -48, -51, -52, -54, -52, -49, -55, -48, -55, -49,
                16, -11, -22, -5, -21, -8, -15, -12, -9, -11, -15, -13, -8, -14, -11, -10, -12,
                -11, -11, -12, -11, -8, -8, -14, -13, -12, -13, -11, -13, -9, -10, -13, -11, -8,
                -15, -7, -15, -4, -19, -7, 87, 45, 38, 54, 37, 53, 38, 46, 46, 45, 48, 36, 57,
                -2, -20, 26, 1, 8, 6, 2, 4, 1, 2, 3, 6, 3, 5, 5, 3, 5, 5, 3, 4, 5, 5, 4, 3, 3,
                4, 8, 6, 4, 5, 4, 3, 0, 7, 5, 4, 6, 3, 5, 4, 5, 5, 8, 5, 8, -7, 42, 62, 43, 39,
                -36, -17, -3, -18, -13, -16, -11, -16, -12, -16, -12, -10, -16, -13, -13, -13,
                -14, -14, -9, -12, -13, -12, -9, -11, -13, -9, -12, -12, -9, -9, -10, -12, -8,
                -9, -6, -13, -2, -14, -3, -9, -5, 91, 42, 42, 63, 43, 62, 45, 57, 50, 52, 51,
                49, 54, 50, 55, 5, -6, 21, 3, 9, 10, 8, 9, 9, 8, 9, 10, 8, 10, 12, 8, 6, 10, 10,
                12, 8, 12, 13, 9, 12, 9, 10, 10, 10, 10, 8, 13, 7, 18, 7, 13, 8, 8, 12, -78,
                -51, -36, -57, -40, -51, -42, -48, -43, -44, -45, -41, -43, -43, -48, -35, -53,
                -23, 24, -6, 1, -2, -9, -2, -6, -4, -4, -2, -2, -1, -2, -2, -2, -1, -4, -1, -1,
                -3, 0, -2, 0, -1, 0, 2, -1, -1, -1, -4, -3, -2, -2, -4, -2, 0, -5, -2, 0, 2, -5,
                -3, -1, -6, 4, -1, 24, 12, 5, 22, 7, 15, 10, 9, 14, 7, 13, 9, 7, 11, 12, 13, 13,
                11, 10, 11, 11, 11, 10, 6, 5, 12, 10, 7, 10, 6, 7, 9, 6, 11, 6, 8, 5, 10, 3, 1,
                20, -79, -67, -28, -62, -41, -53, -48, -49, -52, -49, -52, -49, -51, -50, -49,
                -53, -44, -59, -22, 20, -17, -7, -5, -8, -7, -10, -6, -8, -3, -5, -4, -2, -5,
                -9, -7, -7, -8, -9, -5, -6, -9, -6, -8, -8, -8, -8, -7, -7, -7, -9, -11, -6, -6,
                -7, -10, -10, -1, -22, 47, 73, 30, 51, 43, 50, 45, 41, 47, 42, 48, 42, 54, 17,
                -27, 2, 0, -3, 4, 1, 1, -1, 2, 4, 4, 0, 2, 4, 1, -2, -1, 1, 2, -1, 1, 2, -1, 2,
                1, -1, 1, 0, 2, 1, -1, -1, -4, 0, 1, 2, -1, -3, 1, 1, -2, 1, 1, 3, -4, 25, 71,
                44, -28, -17, -2, -19, -5, -14, -7, -5, -12, -5, -11, -14, -6, -9, -11, -7, -7,
                -8, -7, -8, -7, -7, -6, -4, -8, -9, -5, -7, -8, -6, -8, -7, -4, -6, -5, -4, -1,
                -9, -3, -8, -9, 1, -5, 68, 69, 35, 62, 45, 50, 53, 47, 51, 50, 52, 49, 55, 45,
                58, 34, -24, 12, 9, 1, 10, 1, 9, 1, 3, 6, 5, 5, 2, 5, 8, 7, 8, 5, 2, 3, 7, 10,
                8, 8, 4, 2, 3, 4, 3, 5, 4, 5, 4, 6, 8, -2, 18, -47, -77, -28, -54, -45, -45,
                -47, -40, -47, -43, -48, -41, -45, -42, -45, -42, -43, -49, 33, 13, -15, 16, -7,
                3, 0, 3, 5, 1, 4, 2, 0, 1, 3, 3, 3, 1, 3, 4, 1, 1, -2, 1, 2, 2, 3, 3, 3, 0, 3,
                2, 0, 5, 2, 4, 0, 4, 3, -3, 7, -7, 13, -18, 37, 47, -36, 27, 6, 4, 17, 4, 12, 5,
                11, 4, 8, 6, 5, 7, 4, 9, 8, 6, 9, 8, 7, 3, 5, 6, 5, 6, 3, 2, 6, 5, 2, 4, 1, 2,
                -1, 6, 4, 1, -2, 8, -23, -80, -51, -50, -52, -46, -56, -49, -53, -50, -51, -50,
                -51, -49, -49, -48, -43, -53, -46, -62, -8, 21, -18, 3, -8, -3, -3, -4, 3, -4,
                -3, -4, -3, -3, -4, -4, 0, -4, -4, -2, -5, 0, -3, -3, 0, -1, -4, -3, 0, -4, -6,
                -2, -3, -1, -6, -2, -3, -6, -3, -9, 59, 68, 34, 56, 44, 46, 47, 42, 51, 37, 52,
                26, -38, 2, 5, -11, 3, -6, -2, -5, -3, -2, -3, -2, -6, -5, -5, -7, -4, -4, -4,
                -3, -6, -2, -5, -7, -2, -4, -1, 0, -1, 0, -6, -3, 1, -4, -6, -7, -4, -3, -6, -4,
                -3, -11, -3, -5, -6, 9, -22, 60, 39, -54, 5, -10, -9, -1, -9, -3, -4, -6, -8,
                -1, -9, -4, -4, -3, -3, -5, -3, -4, -4, -3, 0, -2, -2, -2, -3, -2, -2, -3, -7,
                -5, -1, 0, 0, -3, 2, -3, 0, -3, 1, 3, -4, 68, 66, 39, 54, 48, 53, 45, 46, 48,
                47, 49, 46, 51, 50, 49, 51, 47, 49, -11, -14, 13, -8, 7, 0, 0, 2, -4, 2, 1, 0,
                -3, -3, 4, 2, 1, 3, 2, 4, 4, 0, -1, -3, -3, 3, 1, -4, 2, 2, 0, 4, -1, 5, 5, -3,
                13, -54, -72, -32, -52, -40, -45, -44, -41, -45, -42, -48, -40, -46, -42, -43,
                -37, -43, -37, 35, 11, -4, 16, 1, 9, 5, 7, 6, 7, 5, 7, 11, 11, 8, 5, 6, 4, 10,
                6, 4, 6, 2, 6, 8, 8, 6, 3, 7, 7, 4, 3, 8, 9, 4, 6, 6, 7, 2, 10, -1, 18, -8, -43,
                27, 8, -1, 8, 2, 8, -3, 7, 0, 3, 5, 2, 3, 2, 1, 0, 1, 2, -1, 2, 3, -1, 0, 0, 0,
                1, 2, 3, 2, 2, 2, 2, -1, 1, 1, 1, 1, 3, -1, 6, -5, 6, -9, -80, -49, -41, -54,
                -41, -51, -46, -48, -48, -49, -49, -48, -50, -46, -51, -45, -51, -45, -45, -53,
                35, 16, -12, 14, -4, 6, 0, 3, 2, 2, 3, 1, 3, 0, 2, 3, 0, 0, 1, -1, -1, 1, -2,
                -1, 0, -2, 3, -1, 0, 0, -1, 1, 1, -1, 3, -4, -1, -3, 2, 67, 53, 35, 51, 42, 44,
                49, 42, 50, 37, -21, -18, -6, -6, -7, -11, -6, -6, -8, -8, -7, -5, -5, -11, -10,
                -8, -7, -6, -8, -9, -8, -8, -8, -7, -8, -9, -7, -8, -10, -8, -8, -7, -7, -7, -5,
                -9, -8, -7, -7, -5, -10, -7, -11, -9, -3, -11, -4, -18, 44, 69, -32, -12, 11,
                -11, 6, -6, -4, 3, -3, -1, 0, -2, -1, 0, -4, -2, 1, 1, -2, -2, -2, -1, 1, -1, 1,
                1, -1, -3, -1, 1, 0, 0, 3, 2, 2, 4, -3, 3, 1, 7, 2, -6, 68, 61, 36, 59, 41, 52,
                51, 49, 54, 46, 44, 49, 46, 51, 45, 49, 48, 49, 46, -39, -7, 14, -15, 2, -14,
                -5, -5, -5, -3, -1, -3, -4, -3, -8, -4, -7, -4, -3, -5, -4, -6, 0, -2, -4, -2,
                -4, -1, -4, -3, -2, -4, 1, -4, 1, -4, 9, -33, -76, -35, -50, -48, -41, -49, -46,
                -47, -42, -44, -45, -44, -48, -38, -49, -7, 42, 3, 12, 12, 6, 13, 6, 11, 9, 13,
                12, 12, 9, 10, 11, 8, 14, 7, 6, 8, 8, 14, 9, 12, 9, 5, 11, 11, 12, 9, 11, 12,
                13, 12, 8, 13, 8, 14, 3, 18, 3, 20, 3, -67, 20, 13, -9, 10, -5, 3, -4, 2, 1, -2,
                2, -1, -3, -2, -2, 1, 1, 0, -1, -2, -1, 2, 0, -4, 0, -3, -3, 1, -2, -1, -5, -5,
                -1, -2, 1, -6, -2, 0, -2, -5, -3, -3, -7, 3, -60, -67, -31, -53, -44, -49, -48,
                -50, -51, -48, -49, -47, -53, -45, -49, -45, -56, -49, -51, -42, 42, 7, -3, 17,
                0, 14, 4, 6, 5, 8, 9, 4, 9, 7, 4, 4, 3, 8, 5, 3, 5, 6, 7, 5, 4, 3, 7, 6, 2, 4,
                3, 7, 4, 3, 4, 2, 12, -11, 46, 71, 32, 52, 37, 43, 45, 46, 44, -27, -25, 2, -17,
                -8, -13, -14, -13, -13, -11, -10, -9, -13, -7, -13, -13, -12, -12, -9, -12, -10,
                -12, -14, -13, -12, -9, -10, -10, -11, -10, -11, -11, -8, -10, -10, -11, -9, -8,
                -11, -10, -12, -11, -9, -15, -5, -18, -5, -20, 2, 79, 43, 23, -16, -2, 14, -5,
                13, -1, 4, 3, 4, 4, 3, 5, 3, 5, 4, 1, 3, 2, 2, 3, 3, 8, 2, 1, 4, 5, 4, 4, 5, 4,
                5, 6, 8, 2, 4, 2, 5, 5, 6, 5, 9, 68, 57, 42, 52, 42, 50, 45, 45, 45, 47, 47, 45,
                48, 47, 47, 47, 48, 47, 0, -25, -11, -11, -8, -10, -10, -9, -8, -9, -10, -8,
                -12, -10, -10, -8, -9, -10, -7, -10, -5, -10, -8, -5, -8, -6, -8, -5, -9, -6,
                -7, -6, -4, -5, -2, -8, -1, -12, 6, -26, -73, -37, -44, -47, -43, -46, -40, -50,
                -41, -41, -48, -36, -60, 8, 39, -3, 25, 9, 17, 15, 10, 18, 9, 16, 14, 17, 18,
                14, 16, 15, 14, 12, 9, 13, 11, 10, 13, 12, 15, 15, 13, 14, 15, 14, 11, 11, 13,
                11, 13, 13, 11, 13, 15, 9, 18, 3, 25, -15, -97, -8, 14, -9, 2, -8, 1, -7, -4,
                -4, -7, -2, -4, -3, -5, -5, -5, -7, -2, -6, -8, -3, -3, -5, -5, -6, -7, -7, -4,
                -6, -7, -7, -7, -9, -11, -8, -9, -10, -6, -10, -5, -8, -5, -11, -9, -16, -75,
                -53, -42, -56, -44, -53, -47, -47, -48, -46, -46, -45, -48, -46, -49, -45, -46,
                -53, 2, 36, 9, 9, 16, 8, 10, 12, 11, 11, 11, 10, 7, 7, 10, 11, 11, 9, 8, 10, 11,
                10, 8, 7, 9, 9, 7, 8, 8, 7, 6, 8, 5, 7, 7, 6, 4, 1, 12, -3, 45, 71, 29, 52, 46,
                44, 48, -36, -28, 6, -24, -10, -18, -17, -11, -21, -13, -16, -15, -17, -19, -12,
                -14, -15, -17, -16, -17, -18, -15, -16, -14, -18, -13, -13, -19, -15, -17, -15,
                -15, -13, -12, -14, -13, -14, -13, -11, -12, -15, -13, -12, -14, -18, -13, -14,
                -11, -18, -3, 65, 59, -2, -12, 6, 6, 6, 9, 5, 6, 7, 5, 7, 6, 4, 6, 7, 8, 5, 6,
                7, 7, 8, 7, 8, 6, 7, 7, 7, 7, 5, 5, 9, 10, 9, 13, 7, 9, 9, 11, 10, 2, 13, -2,
                38, 69, 39, 49, 45, 44, 50, 46, 45, 48, 48, 47, 46, 46, 47, 43, 53, 35, 62, -5,
                -54, 9, -21, -15, -12, -18, -11, -13, -14, -16, -15, -12, -11, -16, -14, -12,
                -13, -15, -11, -13, -14, -10, -12, -12, -12, -11, -10, -9, -10, -13, -9, -9,
                -13, -9, -14, -9, -15, -4, -23, -77, -42, -43, -48, -40, -53, -40, -51, -37,
                -55, -6, 58, -3, 20, 23, 12, 27, 14, 19, 19, 20, 18, 20, 19, 18, 19, 20, 19, 17,
                16, 18, 21, 17, 16, 21, 19, 18, 19, 15, 18, 19, 20, 20, 16, 20, 17, 18, 20, 16,
                18, 14, 21, 13, 18, 15, 13, 10, -86, -55, 23, -10, -13, -8, -9, -9, -8, -6, -9,
                -5, -10, -12, -7, -8, -9, -7, -6, -8, -11, -10, -11, -10, -10, -12, -9, -7, -10,
                -6, -8, -11, -9, -10, -10, -10, -10, -12, -10, -9, -8, -12, -10, -6, -16, 0,
                -46, -70, -38, -53, -45, -48, -46, -44, -45, -46, -47, -45, -51, -43, -51, -36,
                -66, -3, 59, -2, 20, 16, 13, 18, 14, 18, 11, 16, 14, 15, 14, 15, 15, 13, 14, 12,
                10, 14, 10, 14, 14, 9, 16, 13, 12, 11, 10, 15, 12, 11, 10, 11, 10, 15, 12, 11,
                9, 11, 12, 5, 55, 62, 34, 60, 5, -59, -10, -13, -25, -11, -19, -17, -20, -20,
                -17, -23, -22, -19, -20, -19, -21, -19, -19, -19, -18, -19, -21, -19, -18, -21,
                -18, -16, -17, -17, -15, -17, -17, -19, -20, -15, -15, -19, -17, -18, -21, -18,
                -22, -18, -21, -16, -16, -17, -16, -23, 41, 75, 30, -15, 11, 17, 1, 18, 9, 8,
                12, 13, 9, 10, 11, 11, 12, 12, 12, 13, 15, 13, 8, 11, 9, 12, 14, 13, 16, 10, 11,
                12, 10, 13, 10, 10, 13, 10, 10, 13, 7, 12, 11, 10, 16, 13, 63, 54, 34, 51, 39,
                50, 47, 48, 48, 44, 42, 45, 47, 44, 43, 46, 40, 47, 40, -51, -26, -5, -34, -7,
                -22, -22, -20, -17, -21, -22, -14, -18, -18, -19, -17, -17, -19, -16, -19, -17,
                -16, -16, -16, -19, -13, -17, -16, -17, -16, -14, -17, -10, -13, -14, -16, -12,
                -16, -7, -25, -64, -45, -41, -48, -42, -43, -58, 29, 50, 5, 29, 15, 22, 21, 20,
                23, 21, 25, 22, 22, 24, 26, 24, 20, 20, 21, 21, 21, 22, 20, 18, 22, 21, 18, 20,
                20, 21, 20, 18, 21, 20, 19, 23, 21, 21, 22, 22, 21, 18, 20, 22, 16, 23, 10, 29,
                5, -73, -53, -36, 4, -6, -23, -9, -18, -8, -17, -11, -9, -16, -14, -12, -13,
                -16, -12, -10, -14, -14, -13, -11, -11, -14, -13, -9, -12, -11, -11, -15, -9,
                -13, -14, -12, -15, -11, -14, -12, -11, -13, -11, -16, -7, -18, -8, -25, -74,
                -39, -44, -50, -40, -50, -44, -46, -46, -45, -49, -44, -43, -59, 27, 48, 2, 30,
                17, 21, 28, 18, 19, 19, 19, 21, 21, 20, 22, 20, 18, 18, 20, 15, 19, 19, 15, 21,
                18, 19, 20, 15, 17, 17, 17, 16, 17, 19, 16, 16, 18, 12, 15, 15, 13, 16, 12, 17,
                16, 15, 59, 52, -62, -31, 0, -36, -13, -30, -20, -25, -24, -20, -22, -17, -24,
                -21, -23, -22, -21, -25, -24, -23, -22, -23, -22, -22, -22, -17, -20, -21, -19,
                -21, -22, -24, -21, -23, -23, -21, -23, -22, -24, -22, -20, -25, -20, -25, -23,
                -21, -24, -21, -26, -12, -41, 49, 98, -4, 13, 18, 15, 20, 13, 19, 16, 13, 16,
                20, 16, 19, 19, 16, 14, 11, 16, 14, 15, 18, 15, 19, 15, 13, 17, 15, 13, 13, 17,
                15, 17, 17, 13, 15, 15, 15, 11, 12, 19, 12, 21, 12, 20, 63, 47, 43, 52, 43, 45,
                44, 44, 45, 43, 46, 45, 42, 48, 41, 50, 37, 54, 23, -60, -23, -19, -26, -15,
                -25, -21, -27, -28, -25, -28, -26, -27, -28, -22, -22, -23, -23, -21, -21, -21,
                -21, -23, -18, -20, -19, -19, -21, -15, -16, -19, -17, -16, -16, -21, -18, -18,
                -18, -18, -21, -6, -34, -47, -79, 18, 70, -11, 39, 16, 20, 23, 15, 25, 18, 28,
                23, 28, 22, 24, 24, 25, 24, 22, 25, 22, 21, 22, 23, 22, 26, 25, 22, 25, 22, 20,
                22, 23, 24, 27, 24, 18, 22, 21, 22, 23, 20, 18, 23, 23, 24, 21, 22, 27, 18, 30,
                -23, -83, -43, -11, -8, -19, -18, -14, -19, -14, -20, -17, -17, -18, -18, -20,
                -18, -18, -15, -15, -17, -20, -18, -15, -17, -16, -15, -16, -16, -17, -16, -18,
                -17, -16, -18, -16, -15, -13, -13, -17, -13, -14, -18, -15, -14, -15, -19, -9,
                -49, -61, -34, -51, -43, -47, -48, -38, -53, -45, -54, -36, -59, -17, 70, 7, 25,
                38, 18, 30, 24, 26, 23, 25, 23, 26, 25, 22, 26, 26, 25, 22, 21, 26, 22, 21, 23,
                18, 22, 22, 21, 24, 22, 22, 21, 18, 20, 23, 20, 16, 23, 14, 23, 18, 24, 20, 24,
                20, 5, 48, -91, -38, 21, -54, -5, -35, -17, -27, -32, -20, -28, -23, -25, -22,
                -24, -23, -25, -27, -28, -24, -24, -21, -23, -29, -26, -25, -22, -25, -24, -21,
                -24, -25, -23, -24, -26, -24, -26, -26, -22, -23, -26, -25, -22, -25, -29, -23,
                -26, -19, -31, -19, -27, -24, -19, -39, 84, 25, -12, 43, 1, 23, 16, 18, 19, 20,
                23, 14, 18, 23, 16, 20, 18, 18, 19, 17, 19, 19, 20, 16, 21, 22, 17, 17, 19, 18,
                19, 19, 17, 16, 16, 17, 16, 17, 20, 16, 21, 16, 18, 19, 14, 56, 52, 41, 53, 40,
                45, 44, 41, 44, 43, 46, 44, 41, 44, 41, 49, 32, 53, -7, -80, -6, -28, -29, -17,
                -31, -19, -28, -25, -29, -27, -26, -28, -27, -24, -27, -30, -25, -23, -25, -24,
                -27, -26, -23, -24, -24, -22, -24, -26, -21, -24, -23, -22, -19, -23, -18, -20,
                -15, -24, -21, -15, -27, 92, 43, -9, 41, 12, 29, 19, 26, 27, 23, 27, 24, 24, 23,
                24, 23, 24, 29, 28, 26, 32, 28, 24, 28, 27, 25, 25, 26, 24, 24, 28, 23, 25, 29,
                26, 28, 28, 26, 28, 24, 27, 27, 25, 27, 21, 28, 24, 27, 23, 24, 23, 19, 30, -74,
                -75, -27, -52, -5, -16, -29, -18, -22, -22, -21, -21, -24, -19, -19, -21, -20,
                -20, -21, -24, -22, -22, -21, -20, -21, -19, -21, -22, -18, -21, -23, -22, -20,
                -17, -17, -21, -26, -19, -18, -20, -17, -20, -18, -18, -20, -16, -21, -14, -24,
                -57, -42, -38, -44, -40, -46, -38, -43, -39, -45, -39, -41, -42, 67, 44, 7, 44,
                16, 29, 26, 26, 32, 28, 30, 30, 31, 25, 26, 31, 28, 29, 28, 27, 26, 27, 29, 23,
                23, 24, 24, 26, 25, 26, 26, 25, 27, 26, 24, 27, 21, 26, 21, 23, 24, 29, 17, 19,
                25, -75, -66, -38, -36, -11, -36, -25, -28, -27, -26, -29, -27, -27, -24, -26,
                -24, -27, -27, -31, -28, -29, -32, -25, -28, -27, -30, -28, -24, -30, -28, -29,
                -23, -27, -31, -26, -32, -28, -28, -29, -30, -26, -24, -29, -25, -29, -32, -27,
                -30, -27, -26, -29, -26, -37, -28, -39, 28, 63, -3, 34, 22, 21, 29, 22, 30, 21,
                28, 27, 29, 27, 26, 26, 24, 24, 21, 21, 22, 19, 22, 19, 17, 22, 25, 22, 21, 24,
                21, 20, 19, 20, 18, 21, 21, 18, 19, 20, 21, 23, 20, 26, 20, 27, 63, 43, 42, 47,
                38, 48, 44, 43, 48, 45, 51, 40, 47, 41, 38, 47, -66, -45, -11, -42, -23, -39,
                -30, -34, -30, -34, -31, -31, -35, -28, -32, -30, -30, -34, -31, -31, -34, -32,
                -31, -31, -27, -27, -27, -26, -28, -29, -27, -25, -28, -29, -30, -24, -28, -27,
                -28, -25, -23, -25, 59, 70, 44, 56, 51, 28, 12, 41, 23, 32, 33, 23, 32, 25, 29,
                28, 30, 27, 30, 29, 26, 32, 30, 27, 28, 31, 30, 26, 26, 30, 27, 26, 32, 29, 28,
                28, 28, 29, 29, 32, 29, 29, 30, 29, 27, 28, 32, 29, 35, 28, 23, 34, 18, 51, -39,
                -84, -27, -55, -45, -35, -12, -30, -29, -22, -30, -22, -30, -22, -23, -21, -24,
                -30, -22, -25, -27, -23, -27, -25, -26, -25, -26, -24, -23, -26, -23, -24, -25,
                -24, -23, -26, -25, -21, -23, -22, -22, -24, -22, -24, -22, -20, -21, -24, -19,
                -33, -56, -42, -43, -47, -41, -38, -47, -35, -49, -33, -49, -37, 87, 29, 31, 45,
                23, 46, 29, 34, 31, 37, 29, 35, 34, 31, 31, 28, 35, 33, 32, 32, 30, 32, 36, 35,
                30, 33, 31, 31, 32, 31, 31, 29, 30, 31, 27, 27, 27, 28, 31, 18, 36, 11, 45, -10,
                -101, -28, -63, -51, -45, -66, -22, -27, -35, -29, -34, -30, -30, -30, -33, -32,
                -28, -32, -32, -35, -28, -29, -30, -30, -33, -30, -31, -32, -32, -32, -32, -33,
                -32, -30, -30, -32, -30, -32, -32, -33, -32, -29, -32, -31, -30, -30, -29, -31,
                -31, -28, -29, -31, -31, -27, -34, -21, -44, 19, 63, 9, 37, 23, 30, 30, 21, 34,
                26, 31, 29, 29, 26, 28, 28, 24, 28, 23, 27, 28, 25, 29, 25, 26, 25, 24, 28, 31,
                30, 25, 27, 28, 27, 25, 25, 26, 25, 27, 29, 25, 24, 26, 24, 16, 32, 51, 41, 41,
                43, 41, 38, 45, 39, 37, 41, 39, 38, 36, 34, 42, 37, -71, -61, -19, -51, -33,
                -39, -39, -40, -39, -40, -37, -37, -39, -37, -38, -37, -36, -32, -33, -35, -37,
                -37, -38, -35, -32, -35, -32, -35, -36, -28, -35, -35, -32, -32, -30, -29, -27,
                -31, -27, -34, -21, -34, -18, 81, 63, 42, 51, 50, 55, 23, 32, 31, 32, 37, 30,
                37, 33, 29, 37, 33, 31, 40, 36, 38, 37, 32, 35, 33, 32, 35, 38, 36, 34, 34, 33,
                32, 34, 35, 31, 29, 33, 32, 35, 36, 31, 34, 29, 32, 35, 33, 30, 34, 32, 32, 22,
                40, 31, -94, -58, -21, -66, -28, -21, -30, -33, -29, -32, -32, -27, -29, -31,
                -26, -30, -30, -29, -32, -30, -30, -28, -27, -27, -28, -27, -25, -28, -29, -26,
                -25, -27, -28, -28, -28, -29, -26, -23, -28, -28, -26, -26, -27, -24, -20, -31,
                -18, -34, -58, -36, -45, -39, -35, -45, -37, -45, -32, -48, -32, -43, -46, 80,
                58, 29, 45, 33, 52, 36, 39, 43, 40, 39, 43, 37, 36, 44, 36, 38, 39, 35, 39, 35,
                36, 38, 34, 37, 33, 33, 37, 36, 34, 33, 34, 34, 32, 33, 34, 33, 30, 41, 24, 41,
                25, 34, 28, -110, -52, -34, -68, -40, -63, -43, -30, -37, -38, -35, -37, -38,
                -37, -33, -34, -34, -35, -36, -35, -37, -34, -33, -33, -33, -35, -32, -35, -32,
                -30, -36, -37, -35, -35, -36, -33, -31, -32, -36, -33, -30, -34, -30, -34, -37,
                -33, -38, -36, -33, -36, -32, -34, -33, -33, -35, -34, -33, -71, -11, 84, 27,
                28, 37, 25, 35, 27, 37, 30, 29, 30, 30, 32, 34, 34, 28, 36, 32, 27, 32, 28, 26,
                25, 28, 29, 27, 25, 29, 27, 26, 29, 27, 26, 29, 29, 26, 26, 27, 29, 27, 26, 28,
                28, 49, 47, 38, 43, 40, 41, 38, 38, 38, 38, 39, 44, 41, 45, 38, 48, 10, -82,
                -44, -34, -50, -31, -44, -43, -38, -41, -43, -39, -42, -36, -39, -46, -34, -39,
                -39, -34, -38, -35, -40, -37, -37, -38, -38, -39, -37, -36, -33, -39, -40, -34,
                -33, -36, -32, -34, -36, -28, -43, -21, -56, 20, 102, 24, 55, 51, 48, 42, 26,
                47, 30, 38, 36, 34, 42, 39, 38, 37, 41, 37, 36, 40, 34, 38, 40, 35, 37, 36, 34,
                36, 39, 36, 36, 38, 31, 32, 40, 39, 34, 35, 33, 35, 38, 36, 41, 33, 35, 38, 35,
                38, 35, 36, 28, 43, 29, 49, -15, -91, -27, -47, -32, -29, -41, -22, -38, -31,
                -31, -34, -30, -30, -34, -32, -32, -32, -31, -34, -33, -31, -30, -28, -32, -32,
                -26, -28, -30, -34, -37, -32, -33, -30, -33, -31, -32, -36, -32, -34, -29, -34,
                -33, -29, -33, -27, -42, -47, -44, -47, -40, -42, -35, -43, -40, -38, -41, -30,
                -51, -26, -59, 14, 99, 21, 44, 51, 40, 46, 39, 43, 45, 42, 44, 48, 42, 45, 44,
                40, 44, 40, 40, 41, 43, 43, 38, 42, 39, 40, 38, 34, 36, 39, 36, 39, 37, 30, 35,
                40, 36, 38, 36, 34, 39, 26, 47, -56, -95, -23, -61, -56, -53, -56, -53, -53,
                -32, -39, -43, -39, -38, -38, -39, -36, -43, -38, -38, -41, -41, -40, -36, -38,
                -42, -44, -38, -38, -42, -39, -40, -40, -37, -36, -36, -40, -40, -38, -38, -36,
                -37, -38, -40, -37, -38, -38, -38, -36, -34, -39, -36, -43, -41, -48, -65, -34,
                -70, 7, 93, 13, 38, 44, 31, 38, 36, 42, 33, 38, 35, 40, 35, 36, 39, 33, 35, 37,
                35, 33, 35, 37, 36, 34, 32, 35, 34, 33, 34, 34, 31, 31, 34, 33, 34, 31, 30, 31,
                30, 31, 27, 30, 32, 28, 45, 46, 39, 42, 39, 40, 41, 41, 44, 40, 45, 35, 43, 36,
                35, 57, -85, -73, -19, -66, -38, -53, -46, -46, -46, -44, -48, -45, -47, -46,
                -47, -46, -45, -42, -39, -45, -45, -43, -46, -43, -42, -46, -43, -43, -42, -38,
                -42, -42, -38, -42, -38, -35, -39, -35, -45, -22, -59, 36, 112, 17, 63, 51, 49,
                49, 30, 48, 34, 44, 41, 43, 43, 41, 43, 45, 43, 41, 42, 41, 43, 43, 41, 41, 44,
                42, 41, 41, 39, 37, 39, 38, 37, 41, 40, 39, 41, 38, 41, 41, 39, 40, 39, 39, 41,
                42, 40, 44, 40, 40, 38, 38, 42, 32, 46, 24, 59, -16, -119, -10, -35, -52, -26,
                -50, -37, -44, -40, -41, -45, -39, -37, -40, -41, -38, -37, -34, -39, -39, -39,
                -40, -37, -38, -37, -35, -37, -36, -38, -36, -30, -34, -36, -35, -33, -34, -33,
                -31, -36, -28, -30, -30, -38, -49, -39, -45, -39, -41, -45, -39, -47, -35, -45,
                -33, -49, -32, -45, -43, 105, 51, 40, 62, 36, 62, 41, 52, 48, 51, 51, 47, 51,
                47, 45, 48, 45, 43, 44, 41, 46, 50, 46, 45, 47, 46, 44, 40, 43, 45, 45, 48, 43,
                44, 41, 43, 38, 33, 42, 27, 42, 32, 38, 33, 30, 44, -107, -77, -30, -68, -39,
                -59, -51, -44, -38, -49, -42, -44, -50, -43, -48, -49, -47, -45, -43, -41, -46,
                -44, -44, -39, -41, -44, -38, -47, -44, -40, -44, -39, -36, -39, -45, -44, -43,
                -41, -41, -37, -40, -47, -42, -45, -41, -42, -40, -38, -40, -39, -48, -49, -46,
                -43, -54, -30, -68, 11, 102, 17, 47, 39, 33, 50, 36, 46, 38, 42, 44, 42, 42, 42,
                41, 38, 37, 44, 38, 38, 41, 36, 40, 41, 41, 39, 33, 38, 43, 40, 41, 41, 38, 32,
                39, 41, 36, 38, 36, 37, 35, 32, 31, 39, 50, 41, 39, 45, 44, 41, 40, 39, 42, 33,
                44, 38, 43, 36, 49, 32, -105, -59, -34, -60, -36, -56, -44, -54, -47, -45, -55,
                -50, -47, -53, -46, -51, -52, -45, -55, -51, -47, -46, -47, -46, -45, -46, -47,
                -48, -46, -45, -46, -43, -44, -43, -40, -51, -37, -42, -27, -45, -19, 100, 59,
                36, 59, 50, 57, 41, 43, 45, 42, 47, 43, 46, 51, 44, 48, 45, 40, 44, 44, 49, 44,
                37, 46, 44, 43, 47, 45, 42, 43, 44, 46, 41, 39, 50, 44, 41, 44, 42, 43, 40, 43,
                45, 44, 43, 43, 43, 44, 45, 43, 45, 41, 39, 41, 46, 43, 52, 52, -58, -72, -25,
                -55, -39, -42, -44, -42, -45, -40, -41, -43, -44, -43, -43, -39, -41, -37, -39,
                -39, -39, -39, -38, -41, -39, -45, -40, -38, -42, -38, -41, -39, -39, -40, -39,
                -37, -36, -39, -35, -34, -36, -34, -38, -40, -39, -39, -41, -43, -41, -43, -39,
                -47, -35, -46, -34, -44, -35, -36, -56, 110, 66, 24, 74, 35, 60, 46, 52, 54, 49,
                58, 50, 53, 52, 49, 53, 49, 49, 54, 48, 46, 50, 48, 49, 46, 45, 50, 49, 47, 49,
                48, 47, 47, 48, 48, 45, 46, 47, 40, 38, 46, 34, 55, 34, 60, -2, -115, -31, -49,
                -60, -37, -52, -44, -53, -41, -45, -50, -41, -45, -48, -47, -47, -45, -51, -46,
                -42, -47, -45, -44, -46, -47, -51, -47, -46, -50, -46, -46, -49, -48, -46, -44,
                -43, -45, -45, -45, -41, -42, -45, -46, -48, -46, -48, -44, -43, -53, -50, -50,
                -51, -53, -38, -51, -49, -44, -53, 88, 69, 25, 65, 32, 52, 46, 47, 44, 42, 46,
                42, 43, 41, 42, 46, 46, 40, 45, 43, 40, 40, 40, 40, 39, 41, 43, 42, 42, 43, 41,
                44, 40, 39, 38, 39, 44, 42, 42, 42, 38, 39, 45, 47, 42, 39, 47, 43, 44, 42, 41,
                43, 43, 41, 42, 43, 34, 50, -27, -109, -44, -47, -67, -48, -62, -59, -54, -51,
                -59, -59, -53, -58, -54, -53, -53, -50, -54, -53, -54, -48, -49, -56, -50, -47,
                -50, -51, -52, -53, -49, -47, -52, -48, -43, -50, -44, -47, -45, -48, -47, -44,
                -44, 79, 74, 30, 62, 40, 58, 43, 45, 52, 45, 49, 51, 49, 46, 54, 53, 50, 52, 47,
                49, 51, 51, 53, 47, 45, 46, 45, 49, 51, 51, 48, 46, 48, 46, 48, 46, 48, 49, 46,
                51, 49, 49, 51, 49, 46, 50, 41, 43, 50, 44, 45, 37, 48, 39, 53, 40, 52, 28, -97,
                -54, -39, -61, -40, -53, -45, -47, -42, -50, -52, -49, -49, -43, -48, -46, -42,
                -48, -44, -47, -48, -46, -47, -41, -45, -42, -39, -45, -43, -41, -44, -43, -42,
                -43, -41, -39, -45, -43, -40, -43, -43, -40, -43, -43, -39, -40, -41, -41, -42,
                -45, -38, -46, -36, -40, -41, -40, -42, -32, -64, 90, 90, 23, 83, 39, 63, 54,
                53, 58, 53, 61, 55, 60, 52, 57, 56, 49, 58, 54, 53, 55, 52, 56, 50, 52, 54, 49,
                53, 51, 50, 50, 51, 51, 49, 50, 47, 47, 46, 45, 51, 37, 57, 32, 60, 12, -120,
                -42, -41, -61, -44, -55, -49, -55, -51, -53, -51, -53, -49, -53, -51, -51, -51,
                -50, -51, -50, -53, -51, -52, -52, -51, -53, -50, -50, -49, -52, -51, -49, -50,
                -47, -49, -50, -49, -47, -48, -50, -48, -49, -48, -47, -48, -48, -47, -49, -47,
                -47, -47, -49, -44, -49, -42, -47, -50, -35, -71, 60, 90, 28, 69, 40, 56, 50,
                48, 54, 50, 51, 49, 51, 47, 52, 49, 47, 52, 51, 47, 49, 49, 48, 47, 44, 45, 47,
                45, 44, 44, 43, 44, 44, 46, 44, 43, 44, 42, 45, 43, 44, 44, 42, 41, 40, 40,
        };

#endif /* CHUM9_H_ */
