#ifndef CHUM78_H_
#define CHUM78_H_

#include <Arduino.h>
#include "mozzi_pgmspace.h"

/* A sampled guitar sound
 */

#define CHUM78_NUM_CELLS 8193
#define CHUM78_SAMPLERATE 16384

CONSTTABLE_STORAGE(int8_t) CHUM78_DATA []  =
  {
    -11, -27, -23, -13, -14, -13, -14, -22, -20, -12, -9, -24, -46, -48, -36, -36, -46, -45, -34, -27, 
    -29, -26, -26, -47, -56, -51, -33, -29, -55, -58, -43, -37, -37, -36, -34, -38, -58, -64, -55, -60, 
    -56, -40, -35, -36, -40, -31, -15, -9, -20, -24, 2, 7, -12, -16, -10, -23, -29, -13, -2, -7, 
    -24, -15, 1, -6, -11, 2, 13, -2, -17, 1, 11, 12, 12, 12, 25, 9, -13, -11, -4, -5, 
    -1, 12, 1, -14, -2, 20, 28, 25, 7, 9, 30, 15, 2, -1, 1, 21, 30, 27, 33, 26, 
    14, 14, 20, 32, 35, 23, 21, 25, 32, 43, 42, 49, 42, 23, 23, 21, 23, 16, 9, 12, 
    12, 21, 33, 29, 12, 11, 10, 10, 14, 18, 29, 23, 6, -8, 8, 22, 16, 6, -18, -24, 
    -19, 4, 4, -14, -13, -18, -2, 5, 2, -3, -20, -21, 1, 13, -6, -23, -20, -19, 0, 8, 
    -9, -14, -15, -16, -20, -14, -11, -18, -21, -18, -19, -18, -9, -13, -9, -10, -29, -39, -40, -40, 
    -39, -44, -33, -16, -26, -30, -25, -23, -21, -21, -31, -44, -43, -41, -42, -42, -51, -47, -28, -24, 
    -40, -60, -61, -60, -57, -39, -39, -53, -60, -48, -28, -22, -23, -15, -13, -26, -15, -11, -7, -7, 
    -21, -20, -20, -18, -30, -25, -8, -19, -11, 6, 1, -11, -21, -9, 12, 8, 10, 17, 14, 18, 
    19, 22, 13, 0, 22, 25, 11, 5, 2, 29, 47, 48, 49, 41, 34, 19, 24, 41, 41, 37, 
    41, 53, 43, 34, 46, 42, 31, 28, 24, 30, 39, 41, 50, 57, 59, 61, 62, 54, 36, 33, 
    32, 24, 20, 17, 15, 30, 47, 38, 23, 22, 20, 9, 8, 5, 10, 15, 11, 23, 33, 22, 
    10, 14, 4, -6, -7, -17, -20, -22, -30, -26, -21, -10, 1, -10, -21, -20, -25, -36, -37, -43, 
    -42, -29, -26, -28, -38, -36, -36, -49, -40, -31, -37, -41, -51, -62, -54, -58, -56, -41, -42, -48, 
    -52, -50, -53, -56, -57, -67, -68, -60, -49, -37, -43, -44, -27, -24, -27, -33, -53, -50, -35, -31, 
    -36, -46, -34, -24, -18, -19, -42, -46, -38, -34, -34, -30, -36, -42, -28, -17, -8, -2, -2, 1, 
    -6, 11, 19, 12, 18, 3, 1, -2, 9, 23, 6, 7, 10, 3, -1, -1, 0, 13, 33, 35, 
    37, 38, 37, 38, 40, 46, 47, 44, 46, 35, 20, 23, 23, 35, 52, 60, 66, 55, 48, 48, 
    45, 47, 45, 45, 48, 46, 53, 55, 51, 48, 51, 54, 38, 36, 35, 36, 44, 48, 59, 67, 
    66, 71, 59, 40, 43, 40, 36, 32, 23, 32, 44, 40, 46, 45, 25, 23, 22, 20, 15, 25, 
    33, 24, 25, 22, 21, 21, 15, -2, -7, -2, -2, -7, -10, -13, -18, -7, 4, 2, -10, -18, 
    -17, -19, -22, -26, -29, -26, -23, -28, -32, -30, -30, -29, -30, -31, -31, -33, -34, -38, -38, -40, 
    -41, -40, -46, -55, -57, -55, -55, -51, -52, -56, -61, -62, -61, -61, -61, -54, -50, -50, -45, -49, 
    -64, -68, -61, -57, -55, -64, -67, -52, -45, -43, -47, -58, -69, -68, -65, -68, -71, -71, -68, -63, 
    -47, -39, -43, -38, -33, -31, -26, -18, -14, -18, -31, -26, -7, -1, -2, -18, -27, -22, -20, -15, 
    -15, -15, -2, 17, 23, 23, 25, 23, 24, 29, 36, 37, 29, 25, 31, 32, 30, 41, 49, 52, 
    51, 48, 50, 53, 53, 50, 56, 64, 71, 72, 72, 69, 72, 81, 83, 85, 66, 53, 58, 56, 
    55, 51, 61, 78, 80, 81, 84, 80, 62, 53, 57, 52, 54, 58, 55, 54, 55, 54, 56, 49, 
    40, 36, 31, 24, 17, 14, 21, 30, 28, 29, 27, 27, 15, 1, -1, -10, -12, -4, -8, -9, 
    4, 5, -1, -18, -23, -16, -28, -30, -34, -38, -25, -27, -34, -33, -37, -40, -35, -35, -37, -38, 
    -39, -39, -40, -41, -42, -53, -60, -55, -53, -56, -52, -46, -57, -60, -53, -55, -55, -56, -62, -64, 
    -51, -44, -45, -45, -44, -40, -40, -42, -49, -53, -55, -53, -37, -21, -20, -21, -31, -39, -34, -41, 
    -46, -40, -40, -42, -43, -35, -21, -19, -13, -9, -9, -3, -1, 9, 13, 8, 8, 12, 22, 17, 
    3, 2, -2, -2, 0, 8, 14, 6, 15, 29, 31, 33, 37, 42, 34, 32, 42, 45, 42, 41, 
    50, 52, 51, 54, 54, 51, 54, 61, 69, 73, 71, 69, 68, 66, 68, 72, 74, 76, 82, 88, 
    88, 72, 56, 55, 56, 62, 59, 60, 69, 68, 78, 83, 77, 65, 54, 50, 37, 46, 68, 63, 
    50, 49, 49, 55, 49, 34, 27, 17, 17, 21, 24, 15, 13, 26, 32, 34, 33, 9, -10, -7, 
    -12, -6, -9, -24, -29, -24, -16, -32, -40, -39, -46, -46, -45, -40, -42, -57, -62, -53, -50, -45, 
    -59, -74, -69, -72, -74, -72, -68, -67, -69, -67, -71, -83, -87, -84, -76, -72, -77, -86, -84, -76, 
    -79, -76, -74, -79, -91, -89, -73, -69, -61, -52, -57, -67, -67, -61, -63, -57, -64, -72, -47, -32, 
    -35, -45, -55, -61, -62, -50, -45, -52, -60, -59, -49, -36, -31, -19, -10, -17, -17, -5, 1, 5, 
    6, 7, 16, 17, 5, -7, -6, -4, -2, 9, 7, -2, 3, 17, 29, 36, 30, 32, 43, 35, 
    29, 33, 33, 45, 51, 48, 53, 53, 45, 43, 50, 61, 63, 58, 54, 55, 63, 71, 73, 78, 
    70, 62, 68, 74, 75, 71, 67, 57, 63, 80, 82, 78, 65, 67, 72, 72, 71, 72, 84, 71, 
    51, 48, 69, 76, 72, 65, 53, 59, 56, 68, 55, 31, 31, 28, 35, 34, 30, 30, 36, 37, 
    42, 42, 16, 0, -3, -5, 3, 0, -17, -20, -21, -25, -26, -26, -35, -41, -44, -50, -51, -50, 
    -44, -47, -52, -55, -67, -72, -73, -76, -76, -81, -79, -71, -73, -73, -75, -78, -79, -79, -85, -95, 
    -93, -92, -95, -94, -95, -92, -84, -86, -95, -102, -99, -89, -79, -69, -70, -81, -89, -79, -76, -76, 
    -74, -73, -70, -77, -58, -43, -44, -55, -72, -69, -69, -65, -69, -72, -68, -67, -48, -29, -35, -41, 
    -36, -25, -13, -9, -5, -2, 1, 6, 9, 15, 8, -2, 4, 5, 1, 2, 1, 12, 21, 27, 
    40, 45, 45, 39, 34, 44, 54, 52, 54, 58, 54, 52, 59, 60, 56, 57, 59, 63, 70, 74, 
    78, 81, 82, 81, 86, 82, 74, 79, 81, 84, 83, 74, 74, 86, 96, 87, 77, 73, 70, 76, 
    81, 79, 87, 89, 87, 89, 88, 88, 86, 85, 76, 71, 74, 74, 71, 52, 45, 47, 44, 48, 
    51, 41, 41, 48, 46, 42, 39, 32, 29, 26, 17, 10, -2, -9, -9, -15, -19, -19, -21, -27, 
    -31, -35, -38, -46, -45, -40, -44, -51, -63, -67, -71, -74, -76, -78, -78, -83, -81, -74, -77, -80, 
    -79, -82, -83, -90, -96, -95, -97, -98, -101, -99, -91, -91, -91, -96, -106, -105, -105, -101, -98, -98, 
    -97, -98, -91, -90, -90, -90, -88, -89, -97, -78, -64, -69, -75, -90, -89, -89, -85, -77, -88, -88, 
    -83, -80, -75, -70, -61, -54, -43, -38, -34, -28, -23, -18, -14, -9, -4, -1, 3, -6, -19, -14, 
    -11, 0, 8, 7, 13, 20, 34, 40, 41, 45, 46, 49, 51, 54, 58, 61, 66, 68, 71, 68, 
    62, 66, 67, 75, 86, 84, 90, 93, 93, 98, 92, 87, 91, 92, 92, 92, 92, 100, 105, 104, 
    105, 100, 91, 89, 86, 89, 92, 99, 105, 102, 103, 102, 101, 101, 100, 89, 87, 88, 87, 84, 
    66, 60, 59, 64, 71, 63, 50, 46, 53, 54, 52, 49, 43, 37, 27, 15, 9, 4, -2, -6, 
    -10, -15, -17, -23, -30, -33, -37, -41, -46, -51, -55, -59, -63, -69, -72, -76, -79, -82, -85, -88, 
    -90, -93, -95, -91, -88, -91, -92, -94, -103, -107, -108, -108, -109, -111, -110, -103, -100, -102, -104, -110, 
    -114, -114, -114, -114, -113, -112, -112, -110, -104, -99, -99, -98, -97, -93, -83, -75, -73, -79, -93, -90, 
    -80, -78, -78, -87, -88, -84, -82, -77, -73, -63, -46, -38, -36, -31, -27, -22, -17, -11, -6, -2, 
    4, 8, 11, 1, -6, 4, 12, 14, 18, 21, 25, 36, 49, 52, 55, 58, 60, 64, 66, 69, 
    73, 75, 78, 81, 73, 71, 74, 75, 78, 78, 86, 95, 97, 97, 101, 101, 93, 91, 95, 92, 
    99, 107, 106, 106, 107, 107, 109, 104, 94, 88, 85, 88, 92, 93, 98, 104, 103, 102, 101, 101, 
    91, 84, 86, 86, 79, 65, 59, 64, 76, 78, 68, 55, 53, 54, 52, 50, 46, 43, 37, 29, 
    21, 14, 8, 3, -2, -6, -11, -16, -21, -25, -30, -35, -40, -44, -49, -54, -58, -62, -60, -57, 
    -67, -77, -79, -81, -84, -87, -90, -90, -83, -81, -86, -86, -88, -93, -94, -98, -103, -103, -103, -105, 
    -97, -91, -94, -93, -100, -107, -105, -106, -106, -103, -105, -106, -106, -100, -92, -93, -91, -90, -88, -83, 
    -78, -76, -76, -75, -73, -75, -74, -76, -85, -83, -81, -79, -75, -71, -65, -58, -44, -35, -33, -29, 
    -24, -19, -14, -9, -4, 0, 5, 9, 10, 5, 3, 8, 12, 14, 20, 22, 26, 37, 49, 54, 
    56, 60, 61, 64, 67, 70, 73, 76, 80, 74, 70, 73, 75, 77, 78, 87, 95, 95, 98, 100, 
    101, 95, 91, 94, 94, 102, 108, 107, 108, 109, 109, 111, 107, 99, 100, 98, 93, 89, 90, 94, 
    102, 109, 105, 105, 105, 93, 89, 89, 87, 87, 80, 74, 72, 77, 80, 76, 73, 71, 69, 67, 
    65, 62, 55, 49, 46, 43, 39, 39, 25, 14, 12, 6, 3, -2, -6, -11, -15, -20, -25, -30, 
    -35, -39, -45, -47, -49, -58, -63, -65, -70, -73, -76, -79, -83, -82, -76, -78, -81, -82, -87, -95, 
    -100, -100, -101, -103, -104, -103, -98, -94, -98, -104, -110, -110, -111, -111, -110, -112, -111, -112, -108, -100, 
    -100, -99, -98, -98, -96, -93, -90, -87, -86, -84, -83, -83, -86, -93, -92, -90, -90, -88, -86, -82, 
    -78, -71, -56, -47, -45, -40, -36, -30, -24, -20, -15, -9, -4, 0, 1, -2, -3, -1, 4, 8, 
    12, 17, 23, 34, 46, 49, 51, 55, 57, 61, 63, 67, 70, 74, 74, 72, 78, 84, 87, 89, 
    91, 95, 97, 102, 104, 106, 109, 104, 100, 105, 114, 117, 117, 118, 119, 120, 121, 123, 116, 110, 
    112, 110, 103, 103, 107, 114, 120, 118, 118, 113, 102, 100, 100, 99, 97, 90, 81, 75, 72, 73, 
    77, 78, 74, 71, 68, 64, 58, 51, 46, 43, 39, 34, 24, 15, 11, 6, 1, -2, -7, -13, 
    -17, -22, -29, -33, -38, -44, -48, -53, -58, -62, -67, -71, -75, -78, -81, -85, -87, -90, -93, -89, 
    -86, -89, -93, -99, -105, -107, -108, -109, -110, -111, -112, -112, -106, -103, -105, -110, -115, -117, -117, -116, 
    -117, -117, -118, -115, -107, -104, -104, -102, -100, -98, -94, -91, -88, -86, -86, -86, -86, -83, -84, -90, 
    -91, -89, -87, -85, -83, -80, -75, -67, -55, -48, -43, -38, -33, -28, -24, -19, -14, -8, -4, 0, 
    0, -3, -3, 1, 5, 9, 12, 16, 23, 35, 45, 48, 50, 53, 57, 59, 62, 65, 68, 71, 
    72, 76, 79, 81, 83, 83, 85, 91, 97, 100, 102, 104, 107, 109, 111, 113, 114, 115, 116, 118, 
    119, 121, 121, 113, 111, 113, 112, 109, 108, 111, 118, 122, 121, 120, 120, 118, 115, 108, 103, 102, 
    101, 94, 86, 82, 81, 85, 87, 83, 80, 78, 76, 73, 70, 67, 64, 59, 53, 44, 34, 27, 
    23, 19, 14, 9, 4, -2, -6, -10, -15, -20, -25, -31, -36, -41, -47, -52, -56, -61, -64, -68, 
    -73, -76, -80, -83, -86, -87, -88, -93, -96, -98, -100, -103, -105, -107, -109, -111, -112, -109, -106, -108, 
    -114, -119, -120, -120, -121, -122, -122, -123, -121, -118, -117, -114, -110, -105, -101, -96, -92, -89, -86, -85, 
    -87, -87, -86, -83, -82, -87, -89, -87, -86, -84, -82, -79, -74, -65, -54, -47, -42, -35, -31, -26, 
    -22, -17, -11, -6, -2, 3, 4, 1, 1, 4, 7, 11, 15, 21, 30, 42, 48, 50, 54, 57, 
    59, 62, 66, 69, 72, 74, 77, 79, 82, 84, 87, 88, 88, 93, 99, 101, 104, 107, 109, 112, 
    113, 115, 117, 118, 119, 120, 122, 121, 113, 111, 111, 108, 101, 96, 98, 107, 114, 116, 114, 113, 
    110, 108, 102, 96, 94, 94, 92, 87, 79, 74, 73, 71, 72, 73, 71, 68, 66, 63, 60, 56, 
    51, 45, 37, 29, 22, 17, 13, 9, 4, -2, -5, -10, -15, -20, -25, -30, -34, -40, -45, -50, 
    -54, -59, -63, -67, -71, -75, -78, -81, -85, -88, -91, -95, -97, -99, -102, -104, -106, -108, -109, -111, 
    -113, -114, -111, -108, -110, -114, -118, -119, -120, -121, -122, -123, -123, -122, -121, -120, -118, -113, -108, -104, 
    -100, -96, -91, -88, -86, -87, -88, -88, -86, -82, -82, -87, -88, -86, -84, -82, -80, -76, -71, -63, 
    -53, -47, -41, -35, -30, -26, -22, -17, -12, -7, -2, 0, -2, -3, -2, 1, 5, 9, 12, 17, 
    26, 37, 44, 47, 50, 52, 55, 58, 61, 64, 67, 70, 72, 74, 77, 80, 82, 81, 82, 87, 
    92, 96, 100, 102, 104, 106, 108, 110, 111, 113, 114, 116, 114, 108, 107, 109, 109, 106, 100, 99, 
    104, 111, 114, 112, 111, 109, 105, 102, 99, 96, 94, 93, 91, 86, 78, 72, 70, 72, 75, 74, 
    70, 69, 66, 64, 62, 59, 56, 53, 44, 34, 28, 23, 19, 15, 10, 6, 1, -3, -7, -13, 
    -18, -23, -27, -33, -37, -40, -43, -47, -53, -59, -63, -66, -70, -73, -77, -80, -82, -85, -87, -90, 
    -93, -96, -98, -100, -102, -104, -105, -105, -105, -106, -109, -110, -112, -114, -116, -117, -118, -118, -119, -119, 
    -118, -115, -112, -107, -103, -100, -96, -91, -86, -84, -83, -83, -83, -82, -80, -78, -78, -82, -84, -83, 
    -82, -80, -79, -76, -72, -63, -52, -45, -39, -33, -29, -25, -21, -16, -12, -7, -2, 1, 0, -3, 
    -2, 1, 5, 8, 11, 14, 20, 31, 42, 46, 48, 51, 53, 56, 59, 62, 64, 67, 70, 72, 
    75, 78, 81, 82, 82, 83, 87, 94, 98, 100, 103, 105, 106, 107, 109, 111, 112, 113, 112, 110, 
    112, 112, 109, 106, 105, 107, 111, 116, 119, 117, 114, 112, 111, 111, 108, 104, 100, 99, 97, 90, 
    81, 75, 73, 75, 79, 79, 77, 73, 71, 68, 65, 62, 60, 55, 47, 40, 34, 29, 25, 20, 
    15, 10, 4, -1, -4, -8, -14, -19, -24, -29, -34, -36, -41, -47, -52, -57, -61, -65, -68, -72, 
    -75, -79, -82, -85, -87, -90, -93, -95, -97, -99, -101, -103, -105, -106, -108, -109, -111, -112, -114, -117, 
    -117, -118, -120, -121, -121, -121, -121, -119, -116, -113, -108, -103, -98, -91, -86, -84, -82, -82, -82, -82, 
    -80, -79, -80, -82, -83, -82, -79, -77, -76, -72, -66, -57, -47, -41, -35, -29, -25, -21, -17, -13, 
    -7, -3, 2, 5, 4, 1, 2, 5, 9, 12, 15, 19, 26, 37, 46, 50, 52, 55, 58, 60, 
    63, 66, 68, 70, 73, 75, 77, 80, 83, 84, 84, 87, 93, 97, 99, 102, 104, 106, 107, 109, 
    111, 112, 113, 111, 108, 108, 108, 106, 102, 101, 101, 102, 105, 111, 112, 107, 105, 104, 104, 102, 
    97, 94, 92, 91, 85, 76, 69, 65, 64, 66, 68, 69, 66, 64, 61, 59, 56, 53, 49, 43, 
    37, 32, 29, 26, 23, 20, 15, 8, 1, -4, -8, -12, -16, -21, -25, -27, -28, -30, -33, -40, 
    -48, -54, -57, -59, -63, -66, -69, -72, -75, -78, -81, -84, -87, -89, -91, -93, -94, -95, -97, -98, 
    -100, -101, -104, -106, -108, -110, -111, -112, -113, -114, -114, -114, -114, -114, -112, -110, -106, -102, -95, -88, 
    -83, -79, -78, -78, -78, -77, -76, -75, -77, -80, -80, -78, -76, -75, -73, -70, -65, -57, -51, -46, 
    -40, -32, -26, -23, -19, -15, -11, -6, -2, 0, -2, -5, -3, -1, 2, 5, 8, 11, 15, 24, 
    34, 40, 43, 45, 48, 51, 53, 55, 58, 60, 63, 65, 67, 70, 73, 74, 77, 82, 85, 88, 
    91, 94, 96, 98, 100, 102, 103, 105, 106, 105, 103, 103, 104, 101, 99, 98, 98, 101, 106, 111, 
    112, 110, 110, 108, 106, 102, 98, 97, 96, 95, 90, 81, 76, 75, 77, 78, 78, 77, 74, 72, 
    70, 67, 64, 62, 59, 55, 49, 44, 41, 38, 36, 33, 28, 21, 14, 8, 3, -1, -4, -6, 
    -7, -8, -10, -14, -19, -28, -36, -42, -44, -48, -51, -54, -57, -61, -64, -67, -70, -73, -76, -79, 
    -80, -82, -82, -83, -84, -85, -88, -91, -95, -98, -100, -102, -103, -104, -105, -106, -107, -108, -108, -107, 
    -105, -103, -100, -95, -88, -82, -77, -75, -74, -75, -75, -74, -73, -72, -73, -75, -75, -73, -72, -70, 
    -68, -65, -58, -50, -45, -40, -34, -27, -22, -19, -14, -10, -6, -2, 3, 6, 4, 1, 1, 3, 
    7, 10, 12, 16, 22, 30, 39, 44, 47, 50, 52, 54, 56, 59, 61, 63, 65, 67, 69, 68, 
    67, 68, 72, 79, 84, 86, 89, 91, 92, 94, 95, 97, 99, 100, 101, 101, 99, 98, 95, 89, 
    88, 88, 89, 91, 96, 102, 103, 101, 99, 97, 93, 89, 87, 86, 85, 83, 78, 71, 68, 67, 
    69, 70, 69, 67, 65, 63, 61, 59, 57, 54, 52, 49, 45, 41, 38, 35, 32, 28, 23, 16, 
    10, 4, 0, -3, -6, -9, -11, -12, -15, -18, -25, -33, -39, -43, -46, -50, -53, -57, -60, -62, 
    -66, -69, -72, -75, -78, -80, -82, -83, -84, -84, -85, -87, -89, -93, -96, -99, -101, -103, -104, -104, 
    -105, -106, -107, -107, -107, -105, -103, -101, -99, -95, -88, -80, -77, -77, -75, -74, -75, -76, -74, -74, 
    -76, -78, -78, -77, -75, -72, -68, -68, -67, -58, -52, -52, -49, -44, -34, -26, -24, -26, -20, -10, 
    -5, -10, -22, -17, -9, -10, -8, -2, -1, -2, 2, 20, 31, 17, 5, 18, 37, 36, 36, 41, 
    45, 40, 44, 49, 50, 43, 27, 48, 59, 59, 66, 67, 70, 69, 73, 74, 82, 70, 66, 83, 
    84, 75, 60, 73, 85, 75, 66, 72, 80, 66, 72, 87, 87, 85, 87, 86, 81, 72, 57, 71, 
    76, 71, 73, 56, 41, 48, 63, 64, 51, 34, 49, 56, 47, 47, 49, 40, 18, 29, 40, 33, 
    14, 4, 21, 28, 19, 11, 17, 4, -12, -1, 11, -2, -22, -18, -2, -6, -27, -36, -22, -14, 
    -36, -44, -38, -42, -46, -48, -34, -35, -57, -59, -49, -49, -62, -64, -62, -61, -60, -61, -65, -71, 
    -72, -73, -75, -79, -81, -82, -83, -84, -83, -69, -65, -84, -89, -78, -63, -58, -72, -75, -71, -58, 
    -45, -44, -51, -63, -56, -38, -34, -53, -65, -60, -47, -36, -34, -43, -51, -44, -33, -14, -10, -26, 
    -31, -15, -2, -2, -1, 1, 7, 12, 16, 24, 11, 4, 11, 18, 39, 29, 17, 25, 25, 39, 
    49, 51, 50, 49, 57, 57, 60, 54, 52, 64, 59, 57, 60, 63, 69, 72, 77, 79, 79, 80, 
    84, 85, 86, 88, 90, 92, 91, 89, 86, 87, 79, 68, 78, 91, 82, 72, 80, 95, 95, 92, 
    92, 90, 87, 83, 81, 79, 77, 73, 75, 78, 72, 64, 63, 67, 68, 66, 64, 64, 56, 55, 
    59, 54, 44, 35, 42, 45, 30, 20, 19, 16, 9, 11, 22, 22, 13, 5, 6, 9, 3, -2, 
    -9, -18, -24, -26, -31, -36, -38, -41, -43, -47, -51, -53, -55, -58, -62, -64, -67, -70, -72, -73, 
    -74, -74, -75, -76, -78, -81, -84, -88, -90, -92, -94, -95, -95, -96, -98, -99, -96, -89, -86, -95, 
    -97, -93, -83, -69, -69, -80, -85, -80, -67, -57, -56, -57, -63, -69, -67, -67, -69, -69, -69, -68, 
    -61, -54, -52, -53, -53, -45, -29, -23, -27, -26, -19, -15, -19, -17, -19, -22, -18, -10, -2, -10, 
    -10, -5, -3, -3, 2, 11, 10, 9, 20, 28, 26, 28, 32, 33, 32, 30, 31, 31, 30, 34, 
    38, 45, 50, 51, 54, 56, 58, 59, 63, 65, 70, 71, 72, 65, 49, 48, 55, 62, 59, 54, 
    53, 54, 54, 56, 69, 72, 71, 66, 63, 61, 44, 36, 48, 62, 56, 52, 47, 45, 49, 47, 
    49, 45, 45, 32, 29, 50, 49, 42, 40, 38, 40, 35, 32, 33, 26, 12, 5, 11, 9, -2, 
    -8, -4, 7, 5, 3, -10, -18, -2, 0, -3, -16, -20, -10, -13, -13, -24, -35, -32, -34, -35, 
    -40, -44, -43, -46, -50, -50, -47, -46, -47, -47, -38, -30, -30, -45, -57, -57, -60, -56, -58, -57, 
    -51, -59, -49, -42, -56, -65, -53, -40, -54, -58, -36, -25, -27, -46, -46, -20, -19, -19, -29, -44, 
    -43, -39, -20, -15, -28, -38, -40, -19, 1, 0, 0, 3, 3, -7, 2, 18, 3, -6, 5, 23, 
    29, 17, 16, 34, 38, 28, 25, 39, 41, 28, 35, 55, 56, 54, 59, 56, 49, 48, 57, 60, 
    61, 49, 43, 56, 57, 58, 64, 66, 72, 68, 55, 68, 77, 76, 78, 75, 77, 72, 55, 50, 
    52, 49, 52, 54, 53, 53, 47, 51, 67, 65, 47, 41, 55, 61, 42, 35, 47, 50, 49, 29, 
    20, 18, 13, 26, 32, 24, 7, 16, 31, 29, 25, 9, 0, 6, 15, 14, -1, -14, -13, -15, 
    -14, -12, -21, -25, -26, -28, -23, -26, -29, -20, -20, -23, -23, -26, -28, -26, -39, -50, -51, -46, 
    -33, -36, -45, -47, -52, -43, -33, -33, -34, -36, -33, -28, -28, -24, -22, -32, -37, -37, -32, -30, 
    -42, -45, -43, -31, -18, -28, -40, -41, -38, -30, -23, -21, -25, -32, -31, -18, -14, -21, -19, -9, 
    -5, -17, -22, -20, -27, -19, -12, -15, -18, -22, -25, -26, -17, -5, 0, 2, 4, 1, 2, 7, 
    10, 13, 13, 17, 16, 10, 7, 4, 7, 8, 9, 11, 12, 14, 16, 23, 30, 31, 24, 16, 
    15, 15, 13, 14, 24, 31, 22, 10, 11, 20, 18, 10, 8, 11, 11, 20, 32, 29, 30, 30, 
    31, 33, 32, 35, 25, 10, 12, 13, 11, 13, 14, 27, 38, 36, 35, 37, 38, 41, 41, 42, 
    34, 19, 19, 21, 21, 19, 15, 13, 22, 27, 28, 20, 3, 5, 4, 8, 18, 18, 16, 13, 
    12, 10, 9, 6, -8, -15, -13, -12, -17, -21, -23, -18, -6, -10, -12, -13, -14, -15, -16, -16, 
    -16, -24, -35, -33, -32, -34, -37, -40, -35, -36, -39, -41, -41, -40, -44, -44, -47, -50, -48, -43, 
    -39, -45, -50, -51, -48, -45, -46, -53, -57, -56, -52, -42, -39, -49, -59, -60, -61, -58, -55, -57, 
    -58, -56, -45, -35, -33, -34, -31, -26, -24, -24, -30, -29, -26, -24, -27, -26, -19, -17, -13, -7, 
    -16, -22, -10, -2, 8, 5, -4, 4, 14, 14, 17, 6, 4, 16, 18, 21, 12, 10, 14, 13, 
    15, 16, 19, 14, 21, 28, 24, 21, 13, 15, 19, 24, 17, 4, -2, 6, 23, 17, 18, 25, 
    19, 22, 28, 29, 32, 27, 16, 31, 37, 37, 33, 11, 3, 10, 35, 42, 23, 7, 23, 41, 
    41, 41, 26, 13, 8, 32, 48, 40, 30, 10, 20, 40, 42, 36, 24, 12, 12, 33, 44, 34, 
    15, 11, 34, 36, 24, 16, 11, 24, 24, 19, 24, 25, 22, 21, 30, 31, 21, 21, 24, 24, 
    21, 20, 20, 17, 14, 9, 1, -2, -2, -4, -1, 8, 9, 7, 7, 4, 6, 8, -2, -15, 
    -12, 4, 1, -11, -18, -24, -26, -15, 2, -4, -20, -20, -12, -3, 4, -2, -10, -10, -8, -2, 
    -2, -14, -24, -22, -16, -2, -7, -25, -28, -22, -15, -1, 8, 4, 5, 8, 10, 13, 4, -1, 
    -10, -20, -6, -14, -13, 5, 0, 2, -1, -6, -3, -2, -2, -7, -8, -3, 8, 17, 8, 6, 
    15, 20, 5, -2, -1, -9, -2, 8, 19, 15, -5, -7, 1, 11, 16, 3, -5, -2, -8, 0, 
    8, -4, -18, -8, 15, 15, 12, 0, -9, -8, -7, 16, 8, -2, -4, -2, 13, -10, -15, -9, 
    -8, -4, -9, 3, 8, -12, -17, 1, 16, 5, -16, -21, -19, -12, -20, -22, -4, -6, -9, -3, 
    6, 0, -16, -12, 7, 11, -4, -14, -7, 0, -8, -6, 1, -3, -21, -28, -26, -25, -7, -6, 
    -6, -5, -10, 3, 15, 17, 24, 31, 24, 13, 12, 9, -5, -8, -5, 0, 10, -2, -10, 2, 
    3, -6, 3, 14, 15, 1, -9, -5, -6, -1, 5, 15, 18, -1, -18, -14, -3, -2, 12, 20, 
    0, -12, 2, 14, 13, 15, 13, 12, 9, -9, -13, -7, -15, -2, 18, 17, 18, 14, 0, 0, 
    8, 12, 10, 5, -7, -6, 6, 9, 5, 13, 13, -12, -20, -15, -15, -13, -12, -11, -17, -4, 
    12, 14, 6, 4, 1, -10, -7, -4, 11, 5, -13, -7, -4, 9, 12, -5, -13, -12, -13, 7, 
    4, -15, -25, -32, -8, 3, -5, -20, -27, -21, -10, -1, -14, -25, -21, -26, -6, -2, -27, -33, 
    -30, -18, -17, -20, -27, -32, -29, -28, -30, -24, -10, -18, -18, -5, -8, -25, -32, -31, -29, -30, 
    -23, -9, -13, -13, -10, -2, 1, -2, -10, -22, -9, -5, -7, -15, -24, -17, 3, 14, -12, -29, 
    -23, -20, -13, -4, -12, -26, -23, -6, 3, 9, 13, 12, 11, 16, 19, 13, 15, 7, -2, 5, 
    -2, -10, -9, -7, -6, -1, 12, 14, 9, -6, -8, 17, 15, 4, 13, 16, 7, 5, 18, 24, 
    7, -11, 5, 11, 5, 10, 1, 17, 23, 26, 38, 35, 19, -2, -2, 10, 33, 30, 32, 27, 
    8, 12, 25, 38, 17, -4, 1, 19, 37, 30, 30, 40, 43, 36, 37, 39, 20, 8, 13, 22, 
    17, 14, 14, 27, 30, 13, 13, 13, 8, 2, 6, 7, 15, 26, 25, 26, 26, 24, 18, 25, 
    13, -4, -1, -2, 0, 1, -15, -16, -19, -19, -1, -12, -26, -26, -32, -28, -22, -29, -30, -21, 
    -16, -13, -38, -45, -29, -33, -35, -41, -47, -51, -53, -46, -41, -54, -58, -34, -24, -33, -50, -60, 
    -60, -58, -53, -52, -58, -67, -62, -52, -50, -44, -40, -40, -35, -52, -58, -50, -51, -44, -45, -45, 
    -27, -23, -23, -25, -51, -58, -55, -54, -42, -36, -35, -35, -26, -12, -2, 1, 1, 5, 4, 13, 
    18, 21, 20, -5, -10, -7, 5, 21, 3, 1, 5, 7, 17, 13, 1, 11, 24, 23, 29, 32, 
    27, 23, 25, 32, 35, 32, 31, 20, 16, 13, 11, 28, 33, 41, 50, 46, 43, 41, 36, 28, 
    37, 47, 50, 53, 56, 55, 56, 59, 59, 56, 40, 41, 41, 48, 57, 52, 55, 57, 60, 62, 
    51, 33, 34, 37, 36, 35, 30, 39, 41, 36, 41, 29, 16, 19, 13, 7, 7, 14, 25, 15, 
    10, 14, 9, 18, 21, -2, -7, -7, -10, -9, -14, -14, -23, -26, -9, -14, -32, -35, -37, -32, 
    -28, -30, -29, -24, -14, -27, -40, -36, -43, -52, -51, -50, -50, -51, -55, -56, -52, -50, -50, -58, 
    -69, -70, -71, -70, -64, -62, -64, -66, -66, -67, -69, -72, -80, -78, -60, -55, -56, -56, -70, -69, 
    -60, -57, -55, -59, -53, -40, -35, -32, -27, -35, -56, -61, -54, -54, -53, -44, -43, -45, -35, -23, 
    -16, -11, -5, -4, -4, -1, -1, -2, -14, -18, -2, 5, 8, -3, -8, -4, -6, -4, -2, 11, 
    23, 19, 15, 14, 15, 16, 19, 24, 23, 23, 27, 30, 34, 26, 29, 42, 42, 47, 53, 58, 
    59, 59, 59, 56, 60, 68, 73, 71, 67, 69, 82, 86, 84, 84, 61, 55, 66, 63, 61, 53, 
    60, 80, 86, 80, 73, 72, 54, 40, 43, 37, 40, 50, 54, 62, 62, 50, 47, 43, 32, 27, 
    20, 13, 15, 13, 17, 29, 33, 31, 26, 29, 18, 3, 1, -5, -6, -6, -12, -4, 6, 0, 
    -11, -25, -18, -15, -26, -31, -31, -24, -24, -26, -37, -43, -42, -38, -34, -37, -42, -55, -58, -50, 
    -47, -50, -60, -66, -63, -58, -55, -56, -59, -55, -55, -61, -62, -67, -75, -69, -62, -63, -49, -42, 
    -43, -37, -41, -44, -46, -47, -46, -45, -44, -35, -20, -15, -13, -12, -27, -43, -45, -43, -36, -20, 
    -22, -28, -27, -18, 0, -1, -3, 1, 11, 20, 15, 10, 11, 15, 17, 21, 34, 21, 1, 11, 
    15, 16, 21, 21, 20, 27, 36, 38, 38, 37, 36, 39, 45, 48, 43, 39, 42, 43, 44, 52, 
    58, 57, 61, 70, 70, 67, 70, 72, 66, 58, 62, 66, 70, 80, 84, 82, 74, 72, 77, 67, 
    52, 52, 50, 53, 68, 78, 75, 72, 79, 80, 71, 56, 42, 39, 33, 40, 64, 64, 50, 46, 
    49, 56, 54, 31, 16, 17, 19, 28, 26, 11, 9, 28, 35, 35, 33, 5, -9, -7, -6, 0, 
    -14, -24, -25, -19, -17, -35, -41, -40, -43, -49, -47, -40, -46, -60, -62, -54, -52, -44, -54, -72, 
    -75, -74, -76, -72, -62, -66, -70, -74, -73, -78, -86, -79, -70, -71, -84, -89, -80, -76, -81, -81, 
    -78, -78, -89, -89, -73, -67, -58, -56, -65, -70, -69, -67, -62, -60, -60, -53, -43, -34, -32, -37, 
    -55, -63, -58, -52, -43, -50, -57, -57, -47, -30, -18, -10, -8, -11, -9, 2, 5, 8, 11, 14, 
    20, 15, 3, -5, -2, 0, 10, 19, 7, 3, 12, 26, 38, 41, 39, 41, 44, 36, 34, 38, 
    37, 46, 55, 52, 56, 55, 46, 48, 61, 67, 68, 67, 59, 59, 68, 75, 78, 80, 77, 69, 
    71, 75, 75, 75, 70, 57, 54, 63, 67, 69, 72, 80, 75, 65, 68, 67, 78, 66, 41, 41, 
    46, 63, 70, 59, 52, 52, 51, 62, 50, 22, 21, 20, 27, 32, 20, 15, 26, 32, 36, 33, 
    5, -4, -2, -3, 2, -6, -22, -26, -25, -25, -25, -28, -39, -44, -46, -49, -54, -51, -47, -51, 
    -52, -55, -59, -68, -73, -73, -75, -77, -72, -64, -70, -73, -73, -74, -76, -76, -79, -91, -89, -90, 
    -90, -87, -92, -91, -83, -80, -89, -97, -96, -89, -76, -66, -69, -84, -84, -76, -74, -74, -74, -71, 
    -69, -61, -45, -43, -44, -50, -65, -65, -66, -65, -64, -66, -64, -55, -32, -24, -27, -34, -29, -14, 
    -9, -5, -1, 1, 5, 11, 14, 14, 0, -7, 4, 2, -2, 2, 3, 14, 18, 28, 40, 41, 
    36, 29, 32, 34, 43, 46, 47, 46, 39, 46, 55, 59, 55, 50, 50, 58, 71, 69, 71, 75, 
    76, 78, 81, 78, 71, 74, 76, 80, 82, 77, 74, 80, 83, 71, 69, 71, 73, 75, 75, 74, 
    80, 86, 83, 85, 84, 83, 84, 81, 73, 70, 73, 71, 70, 65, 48, 46, 46, 47, 53, 42, 
    40, 49, 49, 45, 39, 34, 35, 34, 21, 14, 4, -2, -6, -9, -8, -12, -20, -26, -29, -34, 
    -37, -42, -39, -34, -40, -46, -58, -61, -63, -67, -69, -74, -74, -78, -77, -74, -78, -78, -78, -78, 
    -81, -91, -97, -97, -99, -99, -98, -95, -90, -90, -91, -95, -103, -104, -107, -106, -101, -101, -98, -98, 
    -96, -92, -91, -90, -90, -90, -90, -74, -62, -63, -68, -86, -87, -86, -81, -72, -81, -83, -79, -73, 
    -71, -66, -59, -45, -34, -33, -27, -24, -21, -14, -10, -3, -1, 5, 4, -16, -18, -12, -10, 1, 
    6, 11, 20, 31, 36, 38, 40, 40, 45, 50, 51, 53, 56, 58, 64, 65, 69, 70, 61, 65, 
    70, 78, 87, 87, 89, 92, 95, 97, 93, 87, 89, 91, 93, 93, 96, 103, 105, 104, 106, 101, 
    92, 92, 91, 93, 92, 95, 104, 100, 100, 103, 102, 103, 100, 90, 88, 90, 89, 89, 84, 75, 
    69, 72, 78, 71, 54, 49, 53, 55, 55, 54, 51, 51, 50, 31, 17, 13, 7, 5, 3, 0, 
    -3, -13, -19, -23, -27, -32, -35, -40, -45, -50, -55, -59, -62, -64, -70, -74, -76, -80, -83, -85, 
    -89, -89, -83, -83, -86, -91, -101, -104, -104, -105, -105, -107, -103, -97, -97, -98, -98, -102, -110, -112, 
    -110, -111, -111, -107, -109, -110, -104, -98, -96, -96, -94, -90, -80, -71, -70, -74, -88, -89, -79, -78, 
    -78, -85, -87, -83, -80, -75, -70, -59, -44, -36, -34, -30, -24, -20, -14, -9, -6, -1, 3, 8, 
    6, -5, -2, 6, 8, 12, 17, 22, 30, 42, 48, 50, 53, 54, 57, 61, 64, 67, 70, 71, 
    74, 75, 69, 68, 73, 74, 75, 77, 88, 96, 95, 97, 98, 98, 91, 89, 92, 90, 97, 105, 
    106, 105, 106, 106, 107, 104, 92, 91, 96, 96, 94, 93, 95, 102, 104, 103, 104, 103, 94, 88, 
    90, 87, 85, 84, 79, 84, 91, 89, 77, 64, 63, 61, 60, 58, 56, 56, 53, 48, 41, 34, 
    28, 20, 14, 9, 4, 0, -6, -10, -15, -20, -25, -30, -35, -39, -43, -48, -50, -48, -56, -66, 
    -68, -73, -75, -78, -81, -83, -80, -78, -83, -83, -86, -94, -97, -99, -101, -103, -104, -101, -95, -94, 
    -96, -96, -101, -109, -108, -108, -109, -102, -106, -111, -110, -106, -96, -95, -96, -95, -94, -88, -81, -77, 
    -77, -75, -74, -78, -75, -80, -88, -84, -82, -81, -79, -76, -71, -60, -45, -38, -36, -34, -29, -23, 
    -19, -14, -10, -5, -1, 5, -2, -6, -2, 3, 6, 9, 11, 16, 24, 36, 43, 44, 49, 53, 
    54, 58, 61, 63, 66, 68, 71, 68, 63, 66, 69, 72, 80, 88, 90, 91, 94, 95, 98, 94, 
    86, 91, 91, 95, 104, 106, 105, 106, 108, 109, 106, 97, 96, 97, 97, 98, 97, 97, 100, 109, 
    108, 106, 107, 98, 93, 93, 91, 89, 88, 86, 85, 91, 87, 80, 79, 77, 75, 69, 64, 60, 
    56, 52, 52, 51, 51, 55, 47, 31, 27, 23, 18, 9, 1, -2, -7, -10, -14, -20, -24, -28, 
    -33, -38, -42, -48, -51, -55, -60, -64, -68, -72, -76, -77, -72, -72, -76, -80, -87, -95, -96, -98, 
    -99, -100, -102, -101, -96, -95, -96, -101, -109, -111, -111, -113, -113, -114, -114, -116, -110, -102, -103, -103, 
    -101, -101, -98, -95, -91, -87, -85, -82, -84, -85, -90, -97, -95, -93, -92, -91, -90, -87, -84, -73, 
    -59, -53, -48, -43, -39, -34, -30, -25, -19, -14, -9, -7, -10, -14, -11, -6, -2, 1, 5, 11, 
    19, 30, 37, 40, 43, 45, 48, 52, 54, 58, 61, 65, 65, 60, 62, 67, 70, 75, 81, 86, 
    88, 90, 93, 95, 98, 94, 87, 89, 94, 102, 106, 106, 107, 108, 109, 111, 107, 99, 100, 99, 
    98, 99, 98, 100, 110, 110, 109, 107, 97, 94, 94, 93, 92, 90, 87, 84, 84, 87, 87, 84, 
    78, 74, 71, 67, 62, 57, 54, 53, 54, 51, 47, 40, 33, 29, 27, 21, 12, 4, -1, -4, 
    -9, -14, -19, -24, -29, -34, -39, -43, -48, -52, -57, -61, -65, -69, -73, -76, -80, -78, -75, -78, 
    -83, -91, -96, -98, -100, -102, -103, -106, -107, -105, -99, -99, -100, -103, -110, -114, -116, -116, -116, -117, 
    -117, -113, -105, -104, -105, -104, -103, -100, -98, -94, -91, -88, -86, -86, -87, -87, -90, -95, -95, -93, 
    -92, -91, -90, -88, -83, -73, -62, -56, -50, -44, -41, -36, -32, -27, -22, -17, -13, -14, -18, -17, 
    -14, -10, -5, -2, 2, 8, 16, 26, 33, 36, 39, 42, 44, 48, 51, 54, 57, 60, 61, 62, 
    65, 67, 70, 75, 80, 84, 86, 90, 93, 95, 98, 100, 103, 105, 107, 108, 110, 111, 113, 115, 
    117, 114, 106, 107, 108, 109, 109, 108, 113, 118, 118, 117, 117, 116, 115, 111, 105, 102, 102, 100, 
    98, 96, 96, 94, 91, 88, 85, 83, 81, 79, 76, 71, 69, 66, 62, 57, 51, 46, 41, 38, 
    33, 26, 18, 11, 6, 1, -3, -8, -13, -19, -24, -29, -34, -39, -44, -49, -53, -58, -62, -66, 
    -71, -75, -79, -82, -85, -88, -92, -96, -98, -101, -103, -106, -108, -111, -112, -108, -105, -107, -113, -118, 
    -121, -122, -123, -124, -124, -125, -124, -122, -121, -119, -114, -112, -110, -107, -103, -98, -93, -90, -90, -89, 
    -90, -89, -92, -97, -96, -94, -94, -92, -90, -86, -78, -67, -59, -53, -46, -41, -37, -32, -28, -23, 
    -18, -13, -8, -4, -6, -7, -4, -2, 2, 7, 14, 21, 29, 38, 43, 46, 49, 52, 55, 57, 
    60, 64, 67, 70, 73, 76, 79, 82, 85, 87, 91, 95, 97, 100, 103, 105, 107, 109, 111, 113, 
    114, 116, 118, 119, 120, 122, 122, 118, 117, 117, 113, 111, 112, 114, 116, 119, 120, 120, 119, 117, 
    113, 108, 105, 103, 102, 100, 98, 97, 96, 92, 89, 87, 85, 83, 80, 77, 73, 70, 67, 64, 
    59, 54, 49, 45, 41, 38, 34, 28, 21, 13, 6, 1, -3, -7, -13, -18, -24, -29, -34, -39, 
    -44, -48, -53, -57, -61, -66, -70, -74, -78, -81, -85, -89, -92, -95, -98, -100, -103, -105, -108, -110, 
    -106, -103, -106, -110, -115, -117, -119, -121, -122, -123, -123, -124, -123, -122, -121, -118, -113, -111, -109, -106, 
    -101, -97, -92, -90, -89, -89, -90, -89, -93, -98, -97, -96, -94, -93, -91, -87, -78, -68, -61, -54, 
    -48, -43, -39, -35, -31, -26, -21, -16, -13, -15, -17, -16, -13, -8, -4, -2, 1, 6, 13, 23, 
    32, 35, 37, 39, 42, 45, 48, 51, 54, 57, 60, 63, 66, 68, 70, 72, 78, 82, 84, 88, 
    90, 93, 96, 98, 100, 102, 104, 106, 108, 109, 111, 112, 113, 115, 115, 113, 111, 111, 112, 114, 
    114, 115, 117, 117, 116, 114, 112, 110, 108, 105, 103, 101, 100, 98, 95, 93, 91, 89, 87, 84, 
    82, 80, 78, 75, 73, 70, 65, 60, 55, 51, 47, 44, 39, 34, 26, 17, 11, 6, 2, -3, 
    -8, -13, -18, -21, -25, -30, -36, -43, -47, -52, -56, -60, -64, -68, -72, -76, -79, -83, -87, -90, 
    -93, -96, -98, -101, -104, -104, -103, -104, -106, -108, -110, -114, -117, -119, -120, -121, -122, -123, -123, -122, 
    -120, -118, -114, -112, -110, -106, -102, -97, -94, -91, -89, -89, -89, -89, -95, -99, -98, -96, -95, -93, 
    -91, -88, -81, -70, -61, -54, -48, -43, -40, -36, -31, -27, -22, -17, -13, -12, -13, -12, -11, -8, 
    -4, -1, 2, 8, 15, 26, 34, 37, 39, 42, 45, 48, 51, 54, 57, 59, 62, 65, 68, 71, 
    73, 76, 80, 83, 86, 90, 93, 95, 98, 100, 102, 104, 106, 107, 109, 110, 112, 113, 115, 114, 
    111, 110, 110, 114, 118, 118, 117, 115, 113, 113, 114, 115, 115, 114, 111, 109, 107, 106, 103, 97, 
    93, 92, 92, 90, 88, 86, 84, 81, 78, 76, 73, 70, 64, 59, 55, 50, 46, 41, 36, 30, 
    22, 14, 9, 4, -1, -5, -10, -16, -21, -27, -32, -37, -42, -47, -52, -56, -61, -65, -70, -73, 
    -77, -81, -85, -89, -92, -95, -98, -101, -104, -106, -108, -109, -110, -110, -111, -113, -116, -120, -122, -123, 
    -125, -126, -127, -127, -127, -127, -125, -123, -120, -116, -112, -107, -102, -97, -93, -90, -87, -85, -85, -87, 
    -92, -96, -96, -94, -92, -90, -88, -83, -75, -64, -55, -49, -43, -39, -36, -31, -27, -22, -17, -13, 
    -7, -5, -5, -6, -5, -3, -1, 3, 7, 11, 18, 28, 36, 40, 42, 45, 48, 50, 53, 56, 
    58, 61, 64, 66, 69, 72, 75, 77, 80, 83, 86, 89, 92, 94, 97, 99, 101, 103, 104, 106, 
    107, 109, 110, 111, 111, 110, 107, 105, 106, 109, 112, 114, 112, 111, 110, 111, 112, 113, 112, 109, 
    106, 106, 105, 103, 97, 93, 91, 90, 89, 87, 85, 83, 81, 79, 77, 74, 72, 69, 66, 62, 
    59, 56, 52, 48, 43, 36, 27, 19, 14, 9, 4, -1, -4, -9, -12, -15, -20, -26, -32, -39, 
    -43, -48, -52, -56, -60, -65, -69, -73, -77, -80, -84, -87, -90, -93, -96, -98, -100, -102, -103, -104, 
    -106, -109, -113, -115, -117, -119, -121, -122, -123, -124, -125, -125, -124, -122, -120, -116, -112, -108, -103, -99, 
    -95, -93, -91, -90, -90, -94, -98, -100, -100, -99, -97, -95, -93, -89, -82, -73, -66, -61, -55, -49, 
    -44, -40, -36, -32, -27, -22, -20, -20, -20, -20, -18, -15, -11, -8, -5, -2, 3, 11, 19, 26, 
    30, 32, 35, 37, 40, 43, 46, 48, 51, 54, 57, 60, 63, 66, 69, 73, 76, 79, 82, 85, 
    88, 90, 92, 94, 96, 98, 100, 102, 104, 105, 106, 103, 100, 99, 100, 104, 109, 112, 111, 110, 
    110, 111, 111, 109, 108, 106, 106, 106, 104, 101, 96, 93, 92, 91, 89, 87, 86, 84, 82, 79, 
    77, 74, 72, 69, 66, 63, 60, 58, 55, 52, 48, 42, 33, 25, 18, 13, 9, 4, 0, -2, 
    -5, -10, -15, -23, -29, -33, -38, -42, -47, -51, -56, -60, -64, -68, -72, -75, -79, -83, -86, -89, 
    -91, -93, -94, -95, -95, -97, -100, -103, -106, -109, -111, -113, -114, -116, -117, -118, -119, -119, -117, -115, 
    -111, -107, -101, -95, -91, -86, -83, -80, -77, -75, -74, -75, -79, -82, -82, -82, -79, -76, -72, -66, 
    -58, -51, -44, -39, -33, -28, -24, -20, -16, -11, -7, -2, 1, 3, 2, 1, 1, 3, 6, 9, 
    12, 15, 20, 28, 37, 42, 44, 46, 48, 50, 52, 54, 57, 59, 61, 63, 65, 66, 67, 70, 
    74, 78, 80, 82, 85, 87, 89, 91, 93, 95, 96, 98, 99, 100, 101, 100, 96, 92, 89, 89, 
    89, 92, 96, 100, 101, 100, 100, 99, 98, 97, 95, 94, 94, 93, 92, 88, 84, 81, 80, 79, 
    78, 76, 75, 73, 71, 69, 67, 65, 62, 60, 58, 56, 54, 51, 49, 46, 42, 36, 29, 22, 
    15, 10, 6, 3, 1, -1, -2, -6, -10, -17, -25, -31, -36, -39, -43, -47, -51, -55, -58, -62, 
    -66, -70, -73, -76, -79, -82, -85, -86, -87, -88, -89, -91, -95, -98, -102, -104, -107, -109, -110, -112, 
    -113, -115, -115, -115, -114, -112, -108, -103, -98, -94, -90, -87, -85, -84, -83, -82, -84, -88, -92, -92, 
    -92, -91, -90, -88, -87, -84, -80, -74, -67, -64, -59, -54, -48, -44, -39, -36, -33, -31, -30, -30, 
    -31, -30, -28, -24, -22, -19, -16, -14, -11, -5, 1, 8, 14, 18, 20, 23, 25, 27, 30, 33, 
    36, 39, 41, 43, 46, 50, 54, 58, 61, 64, 67, 70, 73, 76, 79, 81, 83, 86, 88, 90, 
    92, 93, 91, 88, 86, 87, 89, 93, 98, 101, 102, 102, 103, 103, 102, 101, 101, 100, 100, 100, 
    100, 98, 94, 91, 89, 88, 87, 85, 84, 82, 81, 80, 79, 77, 73, 70, 68, 66, 64, 61, 
    59, 57, 54, 50, 44, 38, 32, 27, 23, 19, 16, 13, 9, 4, -2, -8, -14, -19, -23, -27, 
    -32, -36, -41, -45, -49, -53, -57, -61, -65, -69, -72, -75, -78, -79, -81, -82, -84, -86, -89, -92, 
    -96, -99, -101, -104, -106, -108, -109, -111, -112, -112, -110, -107, -103, -98, -92, -88, -84, -81, -78, -76, 
    -75, -73, -72, -75, -78, -79, -79, -79, -78, -76, -72, -68, -65, -59, -51, -45, -41, -37, -31, -26, 
    -23, -19, -15, -11, -9, -8, -9, -9, -9, -7, -4, -2, -1, 3, 6, 7, 13, 24, 31, 33, 
    34, 36, 38, 40, 42, 45, 47, 46, 44, 47, 53, 57, 57, 59, 65, 70, 72, 74, 75, 75, 
    77, 82, 87, 85, 82, 85, 90, 93, 79, 83, 97, 80, 71, 81, 97, 98, 79, 70, 85, 97, 
    88, 87, 89, 71, 61, 77, 83, 72, 50, 47, 65, 68, 58, 39, 37, 44, 47, 46, 45, 36, 
    13, 22, 34, 27, 6, -1, 19, 20, 12, -5, -9, -9, -22, -11, -2, -6, -26, -31, -12, -20, 
    -41, -48, -38, -24, -41, -57, -54, -56, -58, -63, -50, -43, -64, -70, -48, -55, -76, -74, -73, -71, 
    -70, -71, -71, -73, -71, -74, -76, -78, -82, -84, -86, -66, -70, -93, -90, -90, -78, -61, -57, -62, 
    -76, -77, -67, -49, -44, -55, -65, -54, -35, -34, -49, -59, -60, -53, -41, -37, -34, -48, -51, -39, 
    -24, -15, -25, -22, -7, -14, -25, -7, 3, -12, -13, 7, 18, 3, -5, 1, 11, 17, 6, 7, 
    13, 12, 14, 18, 33, 21, 11, 34, 40, 33, 18, 19, 37, 38, 34, 32, 34, 41, 46, 47, 
    47, 53, 57, 58, 59, 59, 64, 67, 68, 62, 63, 72, 72, 70, 57, 60, 73, 62, 58, 60, 
    64, 80, 80, 79, 69, 55, 71, 77, 76, 76, 73, 79, 75, 70, 58, 52, 54, 58, 60, 59, 
    57, 42, 50, 57, 52, 52, 48, 46, 43, 41, 40, 38, 22, 26, 36, 32, 29, 11, 3, 3, 
    -5, -1, 7, -2, -15, -9, -2, -12, -26, -33, -24, -18, -25, -34, -45, -48, -51, -56, -60, -59, 
    -60, -65, -67, -70, -70, -71, -76, -74, -72, -77, -79, -82, -85, -86, -89, -92, -94, -94, -94, -97, 
    -96, -97, -101, -101, -99, -93, -81, -84, -95, -93, -92, -83, -70, -71, -73, -73, -83, -90, -87, -86, 
    -86, -85, -82, -69, -66, -71, -68, -64, -58, -52, -42, -34, -40, -54, -52, -31, -16, -27, -37, -29, 
    -17, -6, 5, 0, -10, -12, -12, 10, 19, 1, -4, 4, 19, 18, 22, 31, 32, 28, 10, 23, 
    36, 26, 29, 34, 42, 46, 42, 49, 50, 36, 37, 48, 61, 58, 40, 39, 41, 55, 67, 65, 
    66, 67, 67, 70, 65, 48, 47, 46, 56, 69, 64, 59, 63, 71, 68, 69, 57, 51, 51, 45, 
    54, 59, 55, 54, 53, 51, 53, 43, 27, 26, 18, 11, 10, 5, 2, -4, 7, 16, 16, 7, 
    -12, -15, -12, -7, -11, -12, -9, -16, -15, -21, -37, -41, -39, -39, -41, -45, -46, -48, -54, -49, 
    -36, -36, -38, -38, -39, -40, -39, -49, -60, -57, -56, -57, -55, -58, -51, -35, -30, -31, -30, -31, 
    -29, -25, -28, -28, -25, -25, -24, -32, -31, -17, -20, -28, -23, -12, 5, 1, -16, -14, -14, 2, 
    14, 6, 11, 8, 4, 6, 9, 0, -11, -13, 1, 20, 21, 25, 15, 9, 24, 27, 29, 32, 
    28, 33, 41, 39, 43, 48, 46, 45, 43, 43, 40, 35, 36, 35, 33, 38, 53, 56, 44, 35, 
    44, 56, 51, 55, 43, 25, 40, 45, 44, 38, 24, 31, 40, 39, 31, 30, 27, 30, 38, 30, 
    19, 30, 42, 42, 35, 19, 16, 18, 28, 38, 36, 32, 22, 29, 40, 40, 39, 39, 41, 41, 
    41, 45, 44, 32, 30, 35, 44, 49, 44, 46, 45, 39, 44, 48, 47, 33, 21, 22, 20, 15, 
    13, 13, 7, 11, 25, 21, 16, 15, 13, 13, 10, 7, 6, 5, 4, 5, -1, -4, -6, -10, 
    -14, -18, -21, -22, -15, -13, -17, -24, -24, -17, -19, -18, -25, -41, -41, -41, -41, -39, -41, -30, 
    -27, -36, -44, -43, -29, -25, -28, -42, -54, -50, -52, -53, -54, -57, -58, -58, -54, -55, -59, -58, 
    -56, -55, -48, -40, -49, -59, -53, -43, -44, -47, -44, -44, -46, -47, -47, -48, -50, -53, -50, -45, 
    -42, -43, -39, -24, -20, -24, -18, -14, -10, -16, -28, -25, -24, -22, -18, -18, -16, -16, -8, 4, 
    5, 4, 10, 13, 11, 5, 5, 13, 21, 25, 26, 20, 10, 15, 26, 29, 26, 17, 17, 35, 
    45, 44, 45, 37, 27, 24, 37, 49, 47, 50, 50, 52, 54, 56, 58, 43, 37, 43, 38, 45, 
    57, 53, 57, 61, 57, 62, 57, 42, 42, 44, 42, 47, 44, 34, 39, 49, 46, 44, 45, 42, 
    38, 33, 22, 13, 11, 19, 27, 22, 9, 1, 12, 17, 12, 11, 8, -2, 0, 5, 3, -3, 
    -22, -26, -19, -7, -9, -28, -31, -31, -32, -18, -20, -41, -45, -47, -43, -30, -30, -39, -54, -54, 
    -53, -53, -54, -56, -54, -56, -42, -32, -35, -34, -32, -35, -34, -40, -55, -56, -55, -47, -41, -51, 
    -51, -39, -30, -27, -21, -34, -43, -24, -13, -17, -29, -25, -10, -10, -13, -13, -15, -31, -30, -11, 
    -12, -24, -26, -26, -18, 1, 6, -2, -14, -14, 0, 12, 13, 3, -12, -10, -5, 6, 15, 0, 
    -3, -1, -1, 13, 20, 18, 22, 24, 26, 26, 26, 27, 27, 34, 38, 37, 32, 31, 27, 16, 
    17, 24, 24, 27, 35, 32, 39, 43, 25, 22, 32, 31, 27, 25, 16, 20, 27, 27, 40, 40, 
    19, 4, 12, 25, 14, 10, 15, 15, 17, 22, 31, 17, -7, 1, 30, 23, -1, -16, -6, 12, 
    11, 13, 17, 14, 7, 10, 25, 9, -16, -20, 0, 22, 6, 
  };

#endif /* CHUM78_H_ */
