#ifndef BROWNNOISE8192_H_
#define BROWNNOISE8192_H_

#include <Arduino.h>
#include "mozzi_pgmspace.h"

/* Brown noise generated in Audacity
 */

#define BROWNNOISE8192_NUM_CELLS 8192
#define BROWNNOISE8192_SAMPLERATE 8192

CONSTTABLE_STORAGE(int8_t) BROWNNOISE8192_DATA []  =
  {
    54, 75, 42, 8, 11, 63, 34, -5, 36, 79, 36, 72, 108, 99, 59, 106, 70, 102, 60, 100, 
    101, 97, 95, 127, 127, 127, 127, 127, 127, 85, 124, 73, 56, 54, 12, -33, 25, -10, -1, 43, 
    41, 18, -28, 19, 76, 40, 37, 79, 25, 72, 29, 8, 18, 45, 43, 31, 1, 8, -43, 4, 
    34, 25, 36, 46, 18, 18, 43, 86, 27, 10, 49, 8, 3, 1, -36, -83, -42, -2, -35, -48, 
    -87, -36, -47, -47, -33, -4, -56, -40, -16, 1, 7, 31, 0, 36, -11, 22, -16, -27, 0, -22, 
    2, -49, -18, 8, -40, 0, 13, 34, 21, 76, 117, 127, 123, 73, 93, 54, 25, -19, -24, -27, 
    -61, -2, -16, 0, 21, -31, 11, 47, 9, 38, 33, 63, 33, 5, 27, 69, 26, 66, 35, 34, 
    0, 36, 54, 99, 127, 79, 115, 127, 111, 124, 127, 127, 127, 127, 127, 127, 127, 94, 32, 10, 
    10, 7, -5, 25, -16, 15, -37, -88, -73, -56, -75, -29, -32, -86, -97, -110, -127, -122, -109, -95, 
    -58, -54, -90, -49, -31, -80, -43, 17, 73, 81, 51, 89, 127, 108, 127, 90, 66, 13, -41, -48, 
    4, 33, -8, -44, -70, -97, -118, -104, -58, -61, -12, -32, -50, 9, 65, 58, 49, 85, 112, 107, 
    102, 58, 69, 36, 77, 95, 36, 43, 70, 109, 127, 109, 127, 127, 126, 71, 119, 127, 127, 127, 
    116, 127, 91, 52, 49, 6, 57, 109, 44, 92, 118, 59, 66, 115, 105, 107, 76, 110, 114, 77, 
    87, 52, -7, -53, 1, 22, -7, -24, -3, -41, 11, 56, 82, 28, 35, 34, -17, -5, 33, 9, 
    23, 40, 50, 17, -19, -64, -33, 10, 45, 91, 29, -11, -3, 27, -28, -23, -66, -34, -53, 3, 
    -26, -5, 8, 14, 49, 80, 20, 31, 22, 12, -25, -12, 40, 11, -14, 44, -16, 35, 60, 88, 
    64, 11, 65, 42, -6, -32, 8, 18, 23, -36, -3, -26, -23, -33, 17, -27, 31, 22, 3, 0, 
    50, 0, -50, -22, -78, -40, -90, -110, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -116, 
    -108, -113, -124, -127, -127, -120, -96, -127, -127, -127, -112, -60, -94, -76, -17, -63, -63, -82, -76, -87, 
    -30, -84, -114, -91, -127, -127, -87, -41, -5, 14, -17, -28, 9, 21, 77, 90, 84, 81, 63, 47, 
    30, 65, 4, 25, 23, 40, -2, 24, 39, 71, 55, 94, 127, 87, 112, 102, 127, 127, 87, 68, 
    48, 50, 8, -29, -50, -74, -88, -50, -22, 22, 28, 50, 56, 13, -41, -96, -127, -127, -101, -127, 
    -114, -58, -25, -19, -32, 26, -31, 0, -57, -51, -32, -51, -33, -27, -24, -53, -99, -40, -11, 21, 
    -12, -21, -36, -27, 13, 39, 19, 8, 45, 92, 74, 102, 39, 78, 43, 71, 107, 108, 61, 101, 
    127, 127, 127, 127, 121, 115, 121, 127, 97, 39, 19, -39, -36, 8, -6, -28, -39, -56, -73, -50, 
    -23, -27, 13, 13, 33, 87, 54, 86, 55, 1, 7, 42, 78, 104, 123, 127, 95, 127, 93, 72, 
    98, 127, 95, 78, 26, 11, -41, -58, -42, -82, -104, -127, -127, -87, -126, -127, -127, -127, -127, -127, 
    -127, -127, -97, -94, -95, -73, -77, -127, -106, -127, -111, -84, -31, 11, 32, 14, -36, -39, -72, -50, 
    -72, -15, -59, -45, -82, -58, -84, -72, -18, -2, 54, 107, 52, 70, 116, 127, 68, 75, 14, 36, 
    55, 102, 127, 127, 127, 114, 118, 127, 127, 100, 127, 113, 127, 127, 127, 127, 71, 71, 72, 96, 
    97, 95, 126, 120, 96, 75, 106, 42, 15, 54, 38, 67, 37, 20, 49, 96, 103, 126, 127, 120, 
    110, 115, 93, 127, 127, 127, 127, 119, 66, 52, 18, -11, -36, -21, -18, 7, -10, 19, 72, 61, 
    64, 27, -29, -16, 11, 16, -37, -53, -35, -49, -36, 0, -12, -2, 21, 12, 16, -22, -62, -91, 
    -107, -77, -108, -105, -127, -90, -40, -64, -68, -84, -101, -95, -55, -30, -51, -46, -49, -52, -94, -123, 
    -127, -127, -127, -124, -127, -109, -127, -127, -127, -127, -127, -127, -112, -127, -127, -100, -51, -62, -36, -6, 
    16, 44, 76, 84, 52, 98, 39, 19, 21, 34, 81, 88, 52, 7, 1, -10, 44, 30, 22, -15, 
    -36, -67, -36, 23, 0, -37, -81, -127, -95, -127, -123, -127, -127, -103, -87, -100, -127, -127, -127, -127, 
    -127, -127, -127, -127, -127, -127, -127, -127, -127, -90, -38, -24, -30, 1, 50, 42, 0, -5, -15, 26, 
    -1, 15, 17, 30, 25, -6, 5, -15, 11, -14, 0, -55, -74, -77, -125, -127, -127, -80, -21, -40, 
    -63, -97, -102, -87, -59, -9, 41, 0, -54, -84, -109, -86, -93, -52, -54, -62, -6, -48, -27, -7, 
    -12, -34, 6, -15, -6, -57, -41, -14, 29, -8, 35, 61, 16, 16, 29, -10, -55, -3, 52, -1, 
    -58, -25, 28, 8, 20, -33, -35, 10, 28, 22, -11, -14, -13, 22, 55, 70, 64, 5, 39, 84, 
    61, 70, 121, 127, 127, 127, 127, 127, 127, 121, 127, 91, 43, -15, -38, -4, 31, 78, 31, 6, 
    13, 41, 21, 6, -25, -74, -54, -54, -67, -91, -80, -125, -117, -127, -127, -108, -77, -78, -73, -63, 
    -60, -2, -22, 11, 66, 95, 127, 71, 14, -6, 43, 87, 100, 127, 74, 26, 71, 51, 74, 13, 
    -14, -12, -33, -60, -24, 25, -10, -27, -27, -5, 16, 8, -50, -95, -125, -127, -127, -127, -127, -127, 
    -127, -103, -39, -51, -51, -21, 13, -5, 6, -12, -20, 0, -23, 30, 42, 28, 37, 19, 30, 80, 
    75, 102, 87, 109, 56, 80, 89, 113, 86, 55, 68, 101, 112, 127, 127, 107, 61, 99, 77, 90, 
    74, 107, 98, 116, 124, 89, 48, -12, -68, -25, -33, -27, 3, -39, -15, 22, 40, 42, 10, 48, 
    1, -17, -60, -66, -73, -15, -18, 2, -5, 14, 15, -33, 25, 16, 4, 57, 68, 102, 63, 39, 
    41, 15, 23, -16, 12, -33, -39, -60, -100, -35, -87, -112, -117, -64, -90, -30, 29, -6, -23, -59, 
    -81, -46, -47, -7, -3, 53, 99, 78, 55, 44, -5, -58, -105, -127, -109, -127, -124, -77, -45, -43, 
    0, -8, 29, -26, 24, 32, 24, -9, -46, -90, -49, -85, -114, -127, -99, -127, -127, -127, -127, -127, 
    -127, -127, -100, -58, -64, -113, -75, -72, -68, -67, -15, 17, -35, -74, -36, -28, -33, -47, -90, -32, 
    -74, -106, -127, -127, -127, -127, -119, -93, -88, -24, -65, -32, -1, 7, -37, -9, -60, -63, -37, 0, 
    -40, -41, -4, -1, 47, 11, -44, -33, 13, -4, 15, -7, -46, -80, -102, -67, -98, -89, -101, -123, 
    -127, -117, -94, -44, -2, -50, -90, -33, -31, -8, -64, -67, -77, -37, -20, -44, -56, -35, -74, -83, 
    -56, 0, 2, -33, 24, -21, 29, 72, 80, 16, -11, -64, -56, -95, -75, -99, -108, -122, -55, -13, 
    -32, -26, -5, 51, 4, 54, -1, 46, 19, -15, -35, -24, -2, -11, -11, 8, 3, -35, 14, 4, 
    37, 38, -7, 47, 85, 127, 103, 127, 127, 127, 101, 53, 83, 49, 73, 115, 103, 63, 100, 79, 
    35, 30, 39, 9, -48, -23, -72, -75, -77, -66, -3, -31, -10, -15, -43, -9, 32, -19, -14, -33, 
    -55, -23, 28, 0, -21, -76, -125, -95, -127, -94, -90, -30, -32, -10, 1, 47, 22, -28, 9, -13, 
    35, 64, 58, 50, 57, 14, -33, -65, -20, -13, -63, -49, -36, -78, -100, -71, -69, -110, -73, -44, 
    -78, -104, -85, -57, -74, -16, -46, -63, -56, -15, -49, -57, -1, 48, 70, 51, 100, 114, 87, 38, 
    24, 15, -2, 11, 2, 30, 22, -17, 13, 42, -4, -19, -40, -80, -16, 30, 29, -18, 2, 30, 
    0, -43, -70, -84, -117, -112, -54, -22, -64, -36, -85, -59, -95, -75, -40, -20, 32, 1, 30, -16, 
    -15, 37, 18, 27, 13, 16, -22, -12, -34, -85, -67, -22, -9, 36, 9, -20, -21, -30, -61, -72, 
    -68, -62, -28, -28, -17, 16, -27, -15, 25, -21, -13, 7, -5, 2, -13, 0, -37, -30, -59, -101, 
    -112, -114, -88, -89, -69, -54, -72, -20, 11, -32, -18, -61, -91, -70, -69, -67, -69, -19, 9, 62, 
    14, -33, -8, 11, 24, 55, 88, 127, 127, 127, 127, 127, 127, 127, 127, 79, 37, 22, -6, -29, 
    -81, -43, -80, -99, -100, -52, -3, 31, 53, 7, -39, 6, -6, 5, 25, 40, 63, 97, 98, 58, 
    83, 124, 127, 127, 127, 127, 127, 100, 127, 93, 112, 95, 52, 20, 9, 36, 48, 41, 54, 54, 
    47, -5, 16, -29, -62, -89, -54, -19, -2, 10, 62, 12, 47, -5, 13, -26, -56, -109, -127, -103, 
    -71, -104, -98, -47, -32, -1, 44, 27, -17, -63, -3, 28, 59, 62, 0, -52, -16, -45, -12, 17, 
    52, 57, 36, 83, 89, 91, 113, 127, 91, 82, 58, 79, 113, 76, 100, 82, 59, 108, 57, 82, 
    91, 68, 95, 127, 73, 43, -13, -25, -73, -106, -114, -96, -64, -105, -108, -80, -88, -83, -127, -127, 
    -114, -109, -51, -75, -63, 0, -34, -46, -14, -56, -93, -118, -76, -37, 16, 4, 7, 12, 31, 26, 
    -32, -68, -68, -53, -58, -60, -53, -1, -39, -15, -39, -78, -127, -61, -111, -63, -72, -88, -127, -86, 
    -63, -82, -109, -91, -101, -75, -82, -124, -81, -81, -20, 6, 5, 10, 51, 37, 39, 45, 34, 17, 
    57, 96, 124, 127, 92, 123, 127, 127, 127, 127, 127, 127, 127, 123, 127, 127, 80, 92, 62, 67, 
    67, 108, 68, 15, 16, 21, 73, 41, 33, 43, -1, -36, 6, -24, -68, -65, -59, -34, -62, -86, 
    -47, -34, -7, -38, -72, -72, -123, -114, -127, -127, -127, -127, -81, -43, -6, -53, -78, -127, -127, -127, 
    -127, -127, -127, -127, -127, -127, -127, -127, -127, -86, -34, -78, -54, -85, -40, -63, -84, -77, -14, -56, 
    -48, -59, -50, -39, -57, -78, -92, -105, -63, -51, -40, 2, 59, 101, 57, 33, 14, -5, 40, 73, 
    26, 75, 118, 127, 124, 118, 127, 127, 127, 127, 127, 127, 127, 109, 122, 59, 56, 56, 68, 118, 
    127, 93, 65, 34, 83, 107, 127, 127, 127, 127, 127, 120, 125, 86, 83, 69, 102, 55, 107, 127, 
    86, 78, 48, 4, -41, -75, -90, -127, -127, -80, -127, -93, -71, -118, -127, -127, -127, -127, -127, -127, 
    -127, -101, -46, -75, -46, -48, 6, -19, 35, 32, 26, -10, -45, -85, -106, -127, -127, -91, -122, -67, 
    -110, -120, -66, -43, -38, -25, -81, -20, 27, -21, 38, 88, 103, 127, 115, 50, 46, 84, 73, 15, 
    10, 41, 3, 17, -36, -3, -27, -28, -13, -44, -68, -115, -96, -60, -6, -43, -51, -3, -54, -65, 
    -32, 14, -18, -51, 2, -29, -45, -22, -53, -75, -32, -81, -70, -121, -127, -127, -89, -127, -127, -127, 
    -109, -127, -127, -124, -114, -125, -127, -127, -97, -69, -11, -44, -39, -23, 20, 70, 10, 19, 27, -20, 
    -75, -103, -126, -127, -110, -76, -28, -53, -74, -97, -124, -60, -103, -87, -65, -67, -89, -110, -45, -59, 
    -1, -9, -54, -50, -81, -44, -9, -45, -56, -102, -125, -127, -127, -127, -118, -82, -95, -108, -127, -85, 
    -46, -89, -127, -65, -37, -49, -32, -3, -25, 15, -2, 39, 26, 74, 119, 97, 89, 126, 127, 127, 
    127, 127, 127, 127, 127, 127, 82, 56, 92, 65, 4, -35, -73, -100, -93, -83, -105, -106, -127, -88, 
    -67, -116, -73, -124, -127, -127, -125, -127, -127, -88, -71, -102, -114, -67, -29, -83, -38, -52, -11, 6, 
    48, 56, 5, -6, 44, 92, 79, 69, 100, 68, 82, 78, 40, 48, 12, 28, 61, 113, 118, 102, 
    98, 90, 37, -21, -35, -3, -39, -41, -12, -42, -37, -24, -27, 1, -27, 28, -32, 4, 0, -17, 
    -72, -54, 6, 47, -10, -26, -41, -69, -85, -127, -127, -127, -101, -65, -95, -119, -61, -75, -106, -64, 
    -44, -28, 28, 31, 2, 11, -1, -15, -53, -82, -41, -84, -95, -77, -34, -26, 33, 38, 56, 108, 
    127, 112, 120, 64, 3, -49, -66, -85, -52, -42, -87, -39, -24, 29, 3, -22, -33, 13, -17, -7, 
    21, 63, 25, 27, 39, 5, 2, 18, -10, -10, 0, 11, -11, -6, 18, -4, 28, 7, -41, -30, 
    30, -7, -7, 38, -19, -34, 21, 60, 35, 13, 0, -23, 3, 37, 58, 18, 21, 53, 23, -8, 
    -44, -83, -20, 0, 36, 30, 69, 43, 51, 13, 35, 3, 58, 4, 49, 67, 57, 92, 87, 84, 
    53, 90, 67, 53, 106, 94, 30, 75, 92, 127, 97, 50, -10, -47, -80, -49, -72, -47, -81, -87, 
    -127, -76, -106, -121, -63, -86, -116, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -78, 
    -29, 4, 57, 45, 78, 52, 72, 58, 14, 21, 37, 45, 19, 25, 22, -28, -17, -66, -74, -89, 
    -106, -100, -69, -87, -116, -96, -46, -42, -20, -66, -31, 6, 26, 36, -23, 35, -9, 37, 69, 5, 
    -29, -34, 19, 53, 103, 127, 89, 40, -14, -48, -50, -32, -67, -60, 2, 4, -15, -24, -80, -122, 
    -127, -127, -127, -127, -127, -127, -127, -127, -120, -111, -57, -37, -83, -118, -127, -127, -127, -127, -127, -127, 
    -127, -127, -127, -105, -127, -74, -27, -41, -81, -91, -100, -40, -87, -112, -63, -115, -127, -118, -127, -103, 
    -41, -92, -127, -116, -127, -125, -109, -108, -69, -58, 0, 41, 69, 103, 127, 127, 127, 121, 74, 123, 
    127, 101, 45, 18, 30, 77, 125, 127, 127, 102, 80, 69, 106, 45, 37, 15, 25, 64, 31, -21, 
    -56, -104, -60, -88, -105, -80, -50, -59, -83, -36, -22, 8, 48, 20, -29, -37, -16, -52, -9, -26, 
    -19, -27, -12, -61, -35, -26, 26, 78, 28, -28, -78, -113, -94, -97, -92, -104, -51, -75, -69, -56, 
    -49, -40, -74, -83, -119, -55, -97, -107, -68, -67, -32, 7, -10, 28, 42, 55, 15, -24, -64, -96, 
    -127, -74, -89, -88, -36, -16, -42, 4, -13, 12, -11, 40, 95, 73, 90, 121, 112, 68, 117, 57, 
    92, 79, 86, 24, 71, 86, 109, 56, 108, 127, 92, 77, 47, 57, 25, -31, -23, -11, -27, -46, 
    -27, 9, 16, 68, 116, 57, 9, 26, 68, 16, 58, 39, -6, -31, -55, -50, -41, 2, 22, -2, 
    -23, -47, -63, -53, -105, -116, -65, -51, -74, -42, -82, -69, -101, -80, -60, -110, -127, -100, -37, -87, 
    -74, -122, -80, -73, -63, 0, 47, 47, 90, 81, 72, 32, 72, 95, 114, 52, 38, 0, -14, -25, 
    -73, -27, -14, 38, 34, 68, 88, 112, 58, 0, -50, -95, -49, -91, -84, -127, -127, -127, -127, -127, 
    -113, -127, -127, -127, -127, -127, -127, -127, -81, -99, -127, -127, -127, -69, -111, -63, -114, -81, -69, -43, 
    -89, -50, -8, 48, 95, 68, 32, -20, -58, -37, -54, -84, -33, -5, 36, -20, -7, 34, 59, 38, 
    40, 41, 22, 43, 17, 65, 17, -11, 26, 41, 53, -8, 18, 43, -18, 7, -1, 29, -13, -30, 
    -61, -40, -40, -88, -127, -127, -127, -96, -124, -112, -127, -127, -127, -96, -109, -79, -36, -81, -56, -40, 
    -25, -19, 30, 26, 34, 27, -16, 23, -6, 49, 7, -9, 25, 12, 58, 33, 61, 29, -5, -55, 
    -35, -38, -4, 29, 81, 48, 7, 46, 90, 78, 113, 90, 124, 127, 127, 127, 76, 87, 96, 88, 
    70, 49, 101, 83, 53, 27, 52, 89, 127, 110, 114, 91, 97, 59, 6, 32, 61, 23, -14, 0, 
    35, -5, 16, 58, 63, 111, 127, 127, 127, 127, 127, 127, 127, 124, 125, 123, 127, 127, 127, 122, 
    117, 71, 106, 127, 127, 92, 81, 127, 127, 127, 127, 87, 87, 39, 50, 4, -3, 4, 37, 52, 
    89, 41, 22, -34, -15, -63, -15, 32, -11, -3, 32, 53, 50, -4, 28, 23, 79, 78, 110, 116, 
    121, 76, 57, 82, 114, 57, 104, 120, 127, 116, 85, 32, 32, 65, 17, 59, 4, 46, 95, 88, 
    60, 90, 109, 95, 86, 110, 45, -2, 39, -10, 6, 7, 57, 3, 34, 19, 62, 76, 48, 66, 
    63, 13, -28, -29, 28, 11, -40, -67, -52, -84, -116, -127, -127, -94, -119, -126, -104, -127, -94, -95, 
    -67, -53, -70, -9, 6, 58, 63, 27, 76, 111, 123, 98, 95, 127, 88, 46, 82, 127, 67, 120, 
    127, 106, 127, 124, 82, 118, 103, 123, 102, 86, 114, 74, 38, -8, -22, -45, -47, -100, -105, -47, 
    -18, -19, -70, -55, -1, 44, 25, 61, 23, -11, -4, 53, 89, 36, 24, -31, 26, 35, -11, -34, 
    -18, -63, -92, -103, -121, -121, -127, -127, -112, -64, -21, -16, -7, 29, 58, -3, 5, -45, 4, 51, 
    54, 109, 44, 83, 55, 105, 127, 127, 127, 127, 127, 127, 104, 94, 110, 77, 100, 94, 127, 81, 
    127, 127, 127, 127, 127, 127, 82, 30, -10, 37, 61, 10, -6, -19, 13, 53, 14, 69, 84, 37, 
    42, 59, 67, 108, 62, 45, -8, -25, -53, -9, 7, 23, -31, -49, -52, -102, -81, -67, -66, -32, 
    -15, -27, -47, -31, -22, -40, -68, -119, -107, -84, -49, -41, -4, 28, 60, 43, 89, 59, 20, 7, 
    -36, -69, -102, -75, -93, -116, -87, -40, -48, -13, 23, 74, 34, 27, 80, 127, 127, 108, 126, 127, 
    127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 97, 121, 102, 61, 72, 27, -30, 3, -54, -80, 
    -50, -29, -2, 33, 18, -10, -42, -83, -56, -52, -39, -52, -13, -52, -86, -95, -62, -46, -55, -22, 
    -31, -86, -57, -79, -92, -86, -70, -41, -64, -47, -65, -87, -55, -18, 16, 65, 113, 63, 18, 39, 
    80, 119, 70, 48, 30, -10, -57, -91, -60, -76, -75, -99, -108, -127, -127, -106, -52, -33, 2, 33, 
    51, 39, 5, -40, -53, -23, 8, 40, -7, -62, -90, -60, -82, -127, -80, -24, 20, 25, 59, 74, 
    122, 60, 103, 120, 70, 88, 127, 110, 78, 21, -27, 1, 59, 13, -36, -83, -58, -108, -49, -87, 
    -106, -70, -92, -87, -24, 17, 25, 53, 69, 58, 39, 43, 23, 51, 29, 2, 41, 34, -18, -46, 
    -37, -90, -58, -64, -102, -127, -71, -84, -51, -69, -62, -107, -64, -115, -117, -124, -102, -87, -82, -127, 
    -88, -50, -15, 42, -3, -47, -89, -94, -98, -127, -127, -85, -61, -75, -68, -61, -8, -33, 23, 75, 
    27, 79, 22, 34, 13, -39, -62, -109, -63, -46, -94, -116, -127, -127, -127, -127, -127, -127, -127, -127, 
    -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -86, 
    -127, -94, -97, -105, -60, -80, -82, -34, 14, -4, 41, 80, 58, 42, -4, -14, 39, 60, 114, 127, 
    118, 70, 14, 22, -15, -25, -49, -95, -49, -29, 27, 32, 75, 47, -1, -17, 3, -4, 39, 8, 
    -39, -22, -14, -43, 10, 46, 95, 83, 127, 99, 72, 112, 53, 86, 26, 26, 12, -30, 23, 79, 
    34, 58, 20, -23, 18, 72, 27, 10, -34, -61, -42, 3, 48, 90, 112, 62, 85, 84, 102, 127, 
    98, 40, 54, -4, -54, -49, -57, -12, -68, -67, -95, -105, -127, -127, -110, -87, -127, -127, -127, -127, 
    -127, -110, -87, -104, -60, -43, -38, -64, -23, -21, 6, 0, -54, -83, -58, 0, 21, 8, 49, 66, 
    102, 70, 51, -5, -59, -73, -97, -42, -8, -30, 10, 44, 71, 66, 3, -21, -23, 0, 38, 92, 
    94, 93, 103, 77, 43, 83, 122, 91, 73, 106, 52, 57, 74, 88, 69, 101, 63, 115, 89, 63, 
    9, -35, -29, -30, -77, -76, -97, -54, -29, -76, -116, -127, -127, -127, -127, -127, -105, -127, -63, -102, 
    -127, -127, -127, -72, -97, -127, -127, -127, -127, -84, -57, -3, -32, 9, -18, -12, 46, 10, 24, -13, 
    -55, -73, -27, -12, -38, -93, -93, -45, -12, 14, 68, 53, 53, 73, 22, 66, 104, 103, 100, 127, 
    89, 49, -11, 43, 90, 111, 85, 115, 127, 89, 48, 20, -11, -24, -79, -74, -74, -88, -127, -127, 
    -127, -127, -127, -127, -116, -127, -127, -127, -127, -116, -101, -113, -82, -43, -88, -77, -44, 13, 70, 117, 
    127, 127, 127, 127, 127, 127, 127, 124, 127, 106, 126, 127, 127, 119, 127, 127, 127, 127, 76, 45, 
    75, 101, 127, 127, 127, 127, 127, 127, 127, 127, 95, 76, 51, -8, -62, -92, -57, -56, -53, -39, 
    -88, -99, -59, -90, -127, -127, -75, -95, -32, -61, -1, 27, 10, 10, -2, 55, 93, 127, 69, 85, 
    37, -2, -42, -60, -8, -57, 3, 30, 25, -20, -67, -70, -38, -42, -3, 30, 10, 12, 45, 98, 
    127, 127, 127, 77, 112, 127, 127, 127, 127, 127, 127, 127, 127, 97, 115, 82, 29, 65, 5, -36, 
    20, 42, 32, 21, 33, 45, 61, 36, 59, 50, 100, 106, 117, 123, 127, 127, 127, 127, 127, 127, 
    127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 
    127, 127, 127, 113, 118, 121, 127, 121, 80, 44, 75, 116, 127, 127, 127, 127, 119, 127, 91, 74, 
    62, 51, 54, 84, 125, 127, 122, 71, 122, 69, 40, 87, 36, 61, 96, 127, 98, 47, 84, 85, 
    122, 99, 71, 106, 108, 113, 114, 127, 115, 89, 120, 109, 127, 127, 104, 71, 108, 80, 99, 114, 
    77, 14, 3, -30, -31, -74, -66, -111, -118, -89, -43, -14, -34, -80, -75, -16, -8, 26, 11, 49, 
    66, 43, 79, 16, 8, -35, -51, -28, -66, -112, -107, -45, -99, -43, -55, -1, -10, -61, -20, -9, 
    -33, -28, 18, 33, 41, 90, 92, 87, 104, 83, 28, -20, -9, 16, 62, 59, 18, 22, 1, -27, 
    -39, -34, 25, 5, 52, 46, 41, 20, 3, -29, -13, -56, -83, -24, 35, 37, 33, 56, -3, 2, 
    -2, -41, -24, -75, -67, -49, -83, -63, -10, 34, -8, -38, -31, 6, 8, -13, 44, 6, -1, -45, 
    -7, -39, -74, -68, -87, -87, -100, -127, -127, -82, -105, -127, -115, -110, -74, -96, -55, 5, -42, -78, 
    -127, -98, -107, -104, -118, -121, -86, -88, -41, -66, -88, -118, -97, -127, -127, -127, -123, -114, -56, -76, 
    -65, -77, -56, -81, -61, -41, -64, -54, -92, -94, -96, -95, -127, -86, -127, -127, -127, -107, -108, -45, 
    -37, -64, -109, -92, -77, -123, -127, -127, -127, -127, -127, -91, -113, -127, -81, -111, -57, -18, -29, 10, 
    -33, -9, -40, -1, -11, 47, 82, 24, 20, 37, -18, -48, -79, -100, -121, -118, -127, -127, -127, -127, 
    -127, -127, -112, -112, -58, -28, -72, -41, -62, -105, -45, -67, -108, -127, -103, -47, -21, 22, -18, 29, 
    51, 91, 116, 127, 123, 60, 28, 27, 58, 31, 72, 82, 76, 37, 46, 0, -40, 18, 62, 73, 
    34, 10, 66, 87, 25, 33, 26, -22, -22, -30, -43, -72, -37, 7, 39, -5, -18, -49, 7, -26, 
    -39, -93, -117, -73, -89, -96, -127, -79, -50, -90, -86, -41, -10, -6, 21, -14, 29, -11, -46, -51, 
    -97, -38, -84, -90, -90, -34, -78, -74, -112, -68, -49, -41, -34, -32, -50, -3, 43, 33, 46, 40, 
    39, 75, 71, 33, -10, 21, -21, -51, -9, -60, -106, -127, -112, -106, -127, -127, -123, -127, -121, -81, 
    -80, -49, -32, -17, -47, 3, -20, -20, -56, -42, -46, -76, -127, -77, -90, -74, -77, -52, -37, -31, 
    17, 46, 58, 6, -32, -11, 27, 13, 52, 40, 57, 49, 74, 48, 84, 90, 35, 72, 29, 53, 
    64, 3, 53, 73, 59, 1, 30, 57, 28, 12, -46, -15, 26, -30, -18, -27, -55, 5, 25, 66, 
    46, 51, -4, -46, -80, -74, -12, 45, 0, -24, -78, -32, -24, -49, -67, -25, 17, -5, -58, -48, 
    0, 37, 82, 127, 74, 39, 53, 101, 127, 127, 127, 127, 127, 127, 127, 127, 127, 82, 25, 76, 
    66, 3, 45, 71, 123, 127, 88, 63, 81, 33, -11, 15, 55, 12, 61, 55, 87, 127, 127, 127, 
    111, 127, 92, 93, 80, 96, 55, 44, 59, 71, 114, 111, 127, 127, 127, 127, 127, 110, 127, 127, 
    97, 39, -11, -63, -75, -54, -25, -53, -44, -55, -1, 20, 38, 51, 7, -17, -62, -96, -48, -78, 
    -95, -91, -127, -122, -106, -88, -104, -64, -104, -54, -1, -5, -16, -73, -75, -88, -51, 3, 33, 57, 
    75, 78, 48, 102, 73, 30, 14, -31, -67, -69, -65, -96, -108, -67, -5, -5, -19, -22, -5, -49, 
    -8, -12, -18, -36, -88, -35, -5, 24, 15, 35, 79, 124, 75, 94, 127, 98, 58, 102, 112, 54, 
    35, 8, -42, 14, 64, 75, 105, 65, 95, 88, 98, 90, 124, 127, 101, 111, 114, 81, 79, 49, 
    69, 63, 94, 80, 69, 47, 73, 27, 6, -20, -76, -94, -59, -90, -26, -72, -117, -60, -58, -12, 
    22, 29, -24, 30, 85, 114, 74, 13, -29, -15, 16, -26, -78, -24, 13, -25, -81, -126, -81, -62, 
    -9, 21, -1, 38, 86, 21, 61, 61, 111, 127, 102, 110, 53, 87, 43, 74, 66, 58, 9, 34, 
    -2, -31, -20, -68, -50, -19, 11, 6, 20, 61, 57, 102, 127, 127, 112, 127, 127, 85, 127, 116, 
    90, 37, -2, 40, 23, 74, 21, 43, 97, 72, 67, 76, 108, 61, 68, 70, 68, 29, 64, 73, 
    121, 127, 107, 86, 35, 16, 14, 37, 1, -49, -18, 32, 13, 29, 39, 56, 74, 36, 75, 100, 
    83, 37, 64, 58, 29, 72, 79, 74, 125, 127, 97, 88, 61, 66, 113, 91, 28, 34, -19, -64, 
    -72, -29, -34, 19, 53, 8, 61, 1, 25, 66, 16, 15, 33, 61, 93, 80, 116, 109, 109, 123, 
    65, 15, -42, -88, -51, -20, -46, -96, -102, -127, -94, -93, -127, -127, -127, -127, -127, -127, -127, -127, 
    -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -93, -60, -73, -69, -99, -110, -77, -119, -56, -50, 
    -35, -79, -97, -41, -4, -54, -99, -38, 6, 39, 52, 67, 70, 117, 91, 113, 127, 127, 127, 127, 
    127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 108, 111, 127, 
    127, 127, 127, 127, 127, 127, 127, 127, 115, 90, 96, 61, 77, 24, 28, 46, 39, 76, 127, 113, 
    120, 127, 103, 75, 61, 8, -9, -53, -107, -112, -70, -79, -127, -109, -70, -16, -59, -71, -81, -91, 
    -60, -76, -64, -80, -20, -22, 25, 38, -11, 21, 40, 26, 71, 67, 78, 42, 95, 63, 107, 127, 
    127, 111, 47, 67, 19, 55, 77, 48, 2, 26, 65, 50, 13, -17, -72, -98, -45, -46, -76, -96, 
    -127, -123, -103, -56, -96, -48, -1, 15, -27, -81, -83, -83, -57, -23, 16, -29, -49, -57, -107, -101, 
    -40, -70, -64, -28, -17, 37, 13, -4, -48, -70, -53, -97, -123, -85, -62, -67, -95, -80, -71, -8, 
    -41, -83, -83, -115, -127, -120, -82, -44, -31, -63, -104, -113, -122, -127, -127, -127, -127, -127, -127, -127, 
    -127, -127, -127, -127, -127, -127, -127, -127, -112, -127, -127, -127, -127, -127, -127, -101, -85, -124, -127, -127, 
    -127, -127, -127, -98, -50, -56, -88, -54, -93, -105, -123, -108, -122, -77, -65, -45, 10, 10, 9, 14, 
    -20, -50, -98, -69, -81, -91, -96, -127, -127, -127, -127, -127, -127, -122, -127, -113, -86, -24, -46, -69, 
    -84, -114, -127, -127, -114, -56, -66, -33, -16, 7, -16, 33, -23, -55, -41, -94, -74, -89, -127, -108, 
    -85, -57, -48, -40, -18, 10, 49, -7, -60, -81, -46, -78, -116, -127, -127, -79, -31, 8, -49, -22, 
    -54, -51, -8, -52, -72, -86, -59, -28, -83, -100, -50, -39, -49, -60, -10, -42, -56, -99, -36, 10, 
    45, 55, 19, 44, 92, 72, 12, -22, -9, -35, -68, -43, -80, -20, 20, 19, -5, -35, -26, -18, 
    36, 20, 62, 70, 33, -20, 2, 9, 9, 25, 77, 54, 32, 49, 22, 50, 79, 98, 95, 75, 
    103, 102, 120, 76, 121, 83, 41, 81, 67, 32, 74, 58, 70, 66, 61, 112, 127, 127, 127, 127, 
    127, 127, 127, 101, 123, 60, 105, 127, 127, 127, 127, 127, 127, 127, 127, 109, 127, 92, 55, 102, 
    127, 127, 107, 57, 76, 56, 14, 10, 51, 73, 94, 93, 45, 58, 7, 35, 44, 2, -11, -29, 
    -41, -27, -22, -24, -27, -45, -76, -76, -32, 23, 14, 5, -20, -31, 13, 60, 81, 37, 67, 63, 
    105, 115, 122, 127, 127, 127, 127, 127, 127, 127, 120, 127, 61, 92, 127, 88, 92, 38, 93, 102, 
    74, 33, 76, 38, 35, 82, 78, 79, 107, 65, 81, 127, 127, 127, 127, 127, 127, 127, 127, 127, 
    127, 123, 127, 127, 121, 114, 127, 127, 127, 127, 127, 75, 105, 91, 29, 43, -1, -4, 27, 4, 
    13, 65, 66, 91, 120, 127, 123, 112, 127, 90, 127, 97, 100, 88, 115, 127, 127, 118, 84, 108, 
    98, 127, 127, 127, 123, 108, 95, 68, 50, 64, 12, 58, 52, 79, 29, 74, 82, 44, 9, 47, 
    64, 82, 73, 126, 127, 86, 92, 53, 34, 89, 115, 84, 67, 44, 13, 18, -30, -15, -70, -57, 
    -62, -95, -48, -11, -29, 1, -14, 18, 35, -5, -21, -38, -34, 3, -10, 32, 43, -16, 3, -49, 
    -84, -114, -113, -74, -103, -106, -127, -123, -116, -95, -125, -127, -112, -58, -40, -17, -48, 0, 47, 81, 
    26, 67, 25, 21, 35, 12, -8, -27, 15, -36, -31, 3, -43, -87, -62, -112, -57, -13, 23, -12, 
    -21, -39, -84, -109, -111, -127, -90, -118, -122, -127, -125, -69, -40, -2, -25, 2, 49, 62, 88, 31, 
    -9, -12, 19, 15, -10, 8, 32, 86, 57, 33, -4, 36, 64, 13, 24, 41, 33, 31, 40, -17, 
    -73, -117, -127, -93, -108, -106, -62, -116, -76, -106, -42, -76, -84, -125, -69, -24, -38, -28, 0, -31, 
    -48, -93, -124, -88, -41, 12, -25, 15, 70, 113, 93, 108, 86, 83, 44, 94, 113, 54, 35, 13, 
    3, -25, 25, 9, -35, -37, -56, -88, -108, -85, -41, -74, -28, -24, -29, -27, -33, -2, -5, -47, 
    7, 22, -11, 7, -16, 9, -23, 2, 42, -14, -36, -50, -62, -19, 6, 56, 106, 59, 94, 127, 
    73, 104, 86, 127, 127, 127, 127, 127, 91, 67, 51, 36, 70, 69, 43, -16, -20, -64, -14, -44, 
    -51, -1, -9, 37, 0, -32, -4, -56, -73, -68, -69, -110, -85, -111, -92, -71, -20, 38, 91, 55, 
    72, 25, -34, -76, -84, -44, -11, 27, 70, 10, 47, 94, 127, 127, 127, 127, 127, 127, 127, 127, 
    127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 117, 55, 8, 43, 91, 49, -6, 
    -10, 3, 53, 65, 24, -3, 52, 32, 82, 115, 79, 110, 110, 53, 99, 51, 97, 104, 127, 69, 
    119, 89, 61, 35, 60, 10, -20, -68, -54, -39, 12, -39, 9, 65, 111, 56, 96, 114, 88, 63, 
    37, 29, -13, -33, -83, -77, -122, -86, -125, -127, -127, -127, -127, -109, -120, -127, -127, -127, -122, -60, 
    -74, -21, -77, -109, -127, -127, -118, -78, -97, -78, -117, -117, -73, -82, -52, 4, -44, 8, -4, -41, 
    8, 26, 42, 43, 4, 49, 11, 11, 45, 67, 35, -7, -21, -42, 6, 46, 28, -15, -44, -33, 
    -56, -57, -57, 2, -29, -24, -18, -11, -40, -8, -45, -19, 7, 16, 36, 66, 69, 99, 127, 127, 
    127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 
    127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 118, 52, 99, 
    40, 28, 12, 26, -29, 10, -41, -19, 1, -17, 13, -5, 35, 60, 100, 83, 57, -4, 35, -15, 
    16, 23, 34, 8, -6, -51, 9, -11, -54, -64, -115, -122, -127, -92, -84, -100, -121, -110, -64, -66, 
    -72, -28, -73, -71, -65, -83, -121, -116, -127, -127, -127, -127, -127, -121, -127, -66, -90, -127, -86, -127, 
    -77, -52, -92, -30, -16, 40, 1, 26, 16, 44, 58, 30, 2, -56, -44, -53, -93, -124, -127, -127, 
    -120, -92, -122, -74, -70, -100, -72, -121, -73, -20, -72, -89, -38, -65, -27, 18, 52, 49, 67, 105, 
    115, 117, 127, 112, 127, 111, 121, 105, 40, 69, 47, 29, 37, 19, 46, 12, 69, 119, 97, 78, 
    46, 40, 29, 38, 58, 105, 127, 127, 127, 127, 60, 97, 127, 114, 127, 127, 127, 127, 127, 127, 
    127, 91, 78, 102, 127, 108, 68, 28, 55, 93, 108, 127, 76, 127, 127, 88, 36, 89, 37, 4, 
    60, 64, 98, 114, 91, 103, 72, 29, 62, 73, 102, 96, 89, 42, 40, 21, -35, 15, -18, -66, 
    -87, -79, -67, -64, -104, -45, -20, 2, -53, -105, -127, -127, -127, -93, -99, -44, -9, 34, 65, 14, 
    25, -24, -65, -96, -61, -100, -110, -113, -103, -48, -3, 32, 38, 7, -14, 16, 54, -3, 8, -39, 
    -45, -23, -59, -103, -40, -37, -7, 40, 20, -26, -44, -86, -41, -15, 8, 19, 62, 106, 88, 93, 
    90, 76, 94, 41, 82, 27, 47, 91, 27, -31, -61, -13, 35, 89, 122, 127, 127, 127, 127, 127, 
    127, 127, 96, 65, 5, 14, -7, 27, 55, 14, -1, -25, -68, -7, -29, -43, 7, 17, -15, -20, 
    -33, -34, -66, -104, -116, -121, -127, -110, -58, -24, -11, 41, -13, -41, -89, -25, -14, -64, -92, -107, 
    -43, -85, -46, -89, -126, -127, -127, -127, -127, -109, -111, -63, -108, -79, -30, -72, -66, -65, -84, -108, 
    -46, -93, -80, -79, -112, -62, -2, 8, 11, 28, -20, 36, -5, -46, -89, -124, -108, -75, -97, -127, 
    -108, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, 
    -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -123, -127, -127, -127, -127, -127, -127, -127, -127, -127, 
    -127, -127, -127, -127, -123, -127, -127, -127, -127, -127, -113, -80, -121, -92, -114, -81, -25, 29, 6, 6, 
    62, 33, -6, -37, -69, -66, -30, 7, 57, 28, 44, 1, -6, 44, -11, 6, 45, 58, 10, 5, 
    58, 90, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 121, 127, 127, 127, 127, 127, 127, 
    127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 123, 127, 105, 
    66, 42, 26, 28, 33, -9, 11, -18, -54, -103, -62, -22, -17, -41, -62, -33, -57, -28, 18, 35, 
    4, 54, 77, 28, 9, -41, -59, -37, -71, -16, 35, -1, -14, -43, 17, 15, 57, 26, 46, 5, 
    -3, -15, 16, 37, 65, 9, -24, -53, -20, -54, -32, -79, -115, -127, -127, -90, -127, -127, -127, -86, 
    -127, -108, -86, -44, -61, -45, 6, -5, -32, 6, 37, 93, 111, 99, 46, 3, -44, -37, -50, 5, 
    50, 88, 66, 7, -34, 17, 18, 67, 47, 0, 12, -31, 23, 26, -4, -54, -35, -10, 15, 72, 
    88, 109, 73, 23, 10, 35, -18, -63, -3, -54, -88, -38, -67, -11, -41, 3, 25, 80, 60, 60, 
    77, 52, 16, 71, 79, 80, 19, -5, -53, 0, -41, -43, -60, -113, -46, -97, -66, -7, -14, -33, 
    -80, -23, 3, -36, -18, -48, 10, -48, 0, 21, 28, 6, -2, 54, -6, 36, 22, 76, 78, 18, 
    -33, -46, -26, 1, -31, -80, -96, -36, 1, 34, 54, 2, 59, 77, 66, 84, 97, 123, 69, 102, 
    68, 85, 47, 17, -3, -39, -5, 31, 9, -27, 31, 55, 88, 92, 104, 90, 100, 72, 111, 45, 
    61, 36, -24, -30, 14, 48, 35, 29, 5, 7, 47, 48, 14, -26, -77, -43, -55, -28, -18, 24, 
    74, 115, 115, 67, 41, 53, 72, 123, 122, 103, 89, 52, 65, 117, 127, 77, 127, 99, 105, 49, 
    2, 31, 50, 29, -6, 20, -1, 0, -50, -49, -19, -24, 30, -13, -22, -65, -113, -127, -118, -127, 
    -127, -127, -127, -127, -86, -100, -73, -90, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -93, -81, 
    -17, 4, -47, -45, -93, -88, -74, -22, -64, -35, 0, 53, 57, 47, 91, 69, 86, 99, 59, 24, 
    -5, 25, 49, 55, 78, 43, 14, 40, 58, 57, 3, 30, 25, 46, -5, -35, 24, -28, -74, -114, 
    -49, -73, -79, -61, -63, -73, -49, -1, -2, 35, 12, -1, 36, 85, 91, 75, 43, 85, 54, 68, 
    80, 67, 27, 15, 63, 85, 62, 113, 95, 112, 52, 7, 56, 5, 10, -20, -21, -43, -48, -22, 
    -9, 4, -7, -25, -59, -49, 0, 28, 10, 38, 63, 108, 112, 116, 127, 126, 127, 127, 127, 100, 
    127, 127, 127, 127, 127, 127, 120, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 
    127, 127, 114, 101, 45, 72, 103, 44, 91, 82, 116, 110, 127, 127, 127, 106, 56, 11, 2, -34, 
    -39, -31, -1, -53, -78, -127, -127, -127, -127, -127, -127, -127, -127, -127, -108, -58, -1, -25, 7, -27, 
    31, 44, 13, -25, 22, 7, -24, 14, -17, -22, 36, 38, 6, -11, -45, -45, -72, -10, -9, -6, 
    -2, 24, 50, -1, 23, 19, 18, 4, 20, -34, 12, 34, 8, 60, 5, 20, 73, 31, -4, -51, 
    -96, -44, -6, 24, 63, 110, 127, 127, 127, 127, 122, 96, 117, 125, 63, 14, 49, 5, 38, 80, 
    49, 96, 97, 31, 17, -8, -40, -93, -127, -127, -127, -127, -127, -127, -127, -122, -104, -41, -15, -58, 
    -56, -77, -48, -7, -32, -6, -30, -31, -14, -56, -16, 27, 36, 50, 35, 0, 45, 67, 119, 78, 
    67, 109, 127, 106, 118, 127, 127, 127, 127, 127, 90, 117, 127, 91, 40, 8, -35, -22, -36, -47, 
    -27, 29, 56, 10, 18, 26, -16, 34, 51, 28, -26, -4, -39, 5, 28, 39, 92, 127, 127, 127, 
    127, 94, 127, 127, 127, 127, 127, 127, 127, 127, 127, 116, 94, 71, 98, 127, 73, 116, 127, 127, 
    127, 77, 84, 106, 120, 127, 107, 111, 67, 59, 95, 127, 120, 123, 99, 77, 47, 92, 90, 90, 
    127, 127, 94, 109, 91, 41, 85, 22, -32, 7, 57, 53, 65, 90, 127, 127, 94, 122, 109, 92, 
    127, 127, 127, 127, 110, 127, 100, 50, 88, 127, 103, 126, 127, 127, 118, 127, 113, 92, 116, 51, 
    2, -21, 12, 41, -4, -57, -86, -79, -95, -89, -114, -86, -68, -56, -43, 4, 53, 56, 105, 127, 
    127, 127, 127, 123, 76, 99, 118, 107, 69, 57, 35, -19, 25, 51, 3, 10, -29, -11, -1, -25, 
    17, 41, 37, 0, -29, -38, -93, -51, -11, 31, 59, 35, 3, 35, 9, 53, 105, 122, 127, 127, 
    127, 114, 127, 73, 33, 42, 50, 44, 53, 58, 37, 10, 49, 78, 109, 62, 76, 31, 6, 35, 
    12, -21, -48, 13, 21, 56, 9, -44, 3, 4, 0, 17, 10, 35, -25, -18, 28, 67, 16, 47, 
    31, 46, 4, -46, -42, -40, -8, -14, -55, -108, -127, -127, -103, -61, -33, 9, 50, 97, 127, 122, 
    58, 38, 1, -14, -63, -88, -101, -113, -127, -62, -13, -24, -33, -65, -65, -42, -35, -22, 15, -18, 
    27, -31, -52, -89, -61, -88, -111, -82, -49, -6, -51, -40, -92, -57, -108, -60, -26, -4, 20, 59, 
    50, 47, 70, 98, 92, 66, 83, 39, 75, 51, -2, -27, -70, -25, -47, -48, -66, -46, -47, -70, 
    -107, -62, -80, -65, -50, -32, -45, -86, -36, -29, -49, -44, -50, -102, -94, -68, -83, -36, -84, -79, 
    -79, -32, -87, -80, -110, -127, -96, -51, -38, -39, -5, -43, -93, -56, 4, -42, 2, 22, 69, 14, 
    42, 83, 106, 60, 114, 97, 100, 94, 69, 19, -20, 31, 35, 65, 60, 18, -2, -55, -11, 12, 
    32, 39, -18, -54, -91, -120, -127, -127, -127, -127, -127, -127, -106, -122, -123, -67, -68, -61, -87, -65, 
    -111, -64, -3, -20, -24, 7, -10, -5, -60, -4, -24, -77, -60, -27, -44, -6, 8, 58, 94, 127, 
    85, 52, 37, 29, 64, 116, 117, 51, 91, 88, 112, 68, 77, 75, 47, 97, 127, 127, 125, 127, 
    127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 89, 62, 89, 93, 71, 
    59, 79, 97, 90, 125, 103, 59, 69, 52, 5, -35, -35, -57, -94, -110, -127, -127, -125, -80, -122, 
    -64, -43, -42, -94, -111, -120, -96, -69, -108, -79, -40, 6, -42, -11, -68, -72, -100, -127, -100, -68, 
    -93, -127, -101, -127, -127, -127, -127, -127, -127, -127, -99, -73, -121, -64, -79, -115, -51, -103, -50, -40, 
    -23, 22, 42, 74, 70, 41, 37, -11, 37, 64, 24, -2, 50, 11, 14, -11, 37, 79, 70, 38, 
    28, -6, -21, -53, -80, -54, -18, -24, -37, -73, -62, -91, -76, -24, -79, -47, -53, -68, -92, -85, 
    -93, -71, -13, 3, -8, 15, -4, 48, 28, 3, -16, 0, 28, -2, -45, 15, 52, 69, 57, 89, 
    95, 100, 87, 107, 97, 72, 26, 22, 51, 46, 62, 12, 62, 31, -22, 14, -15, 10, -16, 0, 
    -26, -73, -114, -127, -110, -76, -114, -103, -93, -127, -109, -127, -127, -127, -117, -127, -103, -113, -63, -26, 
    2, -29, -51, -28, 20, 54, 22, 47, 29, 27, -31, 13, -17, 36, 10, -10, -40, -82, -21, 14, 
    -12, 47, 45, 84, 127, 127, 127, 110, 127, 127, 94, 127, 85, 127, 127, 127, 76, 94, 127, 127, 
    121, 124, 127, 108, 115, 127, 89, 79, 114, 93, 79, 39, 72, 124, 127, 127, 127, 118, 127, 106, 
    88, 75, 62, 63, 20, 0, -46, -31, -57, -61, 0, -2, 25, 50, 63, 109, 98, 127, 127, 127, 
    127, 127, 122, 100, 46, 59, 54, -6, -38, -65, -68, -24, 0, -56, -84, -44, -98, -37, -68, -33, 
    -45, -22, -5, -25, -22, -17, -22, -13, -47, 5, -35, -14, 15, -19, 10, 22, 46, 43, 30, 74, 
    86, 78, 91, 91, 127, 82, 52, 82, 31, 22, 52, 78, 23, -18, -62, -56, -27, -19, -31, -9, 
    38, 65, 2, 13, -16, -14, -28, -79, -86, -71, -121, -127, -127, -127, -127, -84, -118, -127, -127, -127, 
    -127, -127, -107, -90, -110, -127, -89, -127, -113, -63, -71, -30, -66, -20, 1, -14, 39, 43, 3, -9, 
    11, 7, -20, -27, 13, 31, 82, 95, 99, 62, 103, 59, 1, 28, -10, 39, 82, 50, 8, 35, 
    62, 22, 55, 40, 35, 3, -53, -12, -25, 11, -40, -25, -45, -33, -44, -14, -28, 26, 7, 26, 
    18, -27, -70, -16, -19, 17, -2, 34, -4, -4, -7, 8, -4, 53, 1, 45, 25, -22, 15, -22, 
    -59, -16, -14, 0, 30, 52, 49, 16, -10, -50, -40, -52, -86, -29, -14, 28, 31, 72, 57, 63, 
    25, 31, 27, 29, -26, 29, 28, 72, 30, 11, -35, -50, -43, 14, 8, 23, 41, 85, 120, 87, 
    26, 23, -19, 0, 9, -46, 12, -43, 5, -29, 1, -20, 26, -20, -20, -19, 8, -6, -11, -27, 
    -75, -20, 17, -21, -17, -15, -17, 9, 13, 44, 38, 57, 86, 110, 81, 103, 71, 15, 6, 47, 
    -4, 27, -2, 52, 0, -48, -68, -114, -127, -127, -117, -113, -101, -127, -85, -57, 1, -30, -46, -74, 
    -73, -82, -38, -2, -35, -85, -121, -126, -127, -105, -91, -61, -17, -36, -46, -61, -82, -94, -103, -67, 
    -108, -43, -92, -54, 2, 3, -3, 19, -29, 12, -23, 32, 38, 85, 94, 79, 75, 22, 65, 64, 
    3, 29, 27, 49, 72, 62, 56, 10, 39, 9, 59, 77, 112, 104, 127, 98, 127, 127, 111, 70, 
    68, 111, 112, 109, 77, 111, 122, 73, 117, 91, 81, 121, 111, 127, 66, 44, 43, 93, 39, 17, 
    -8, -14, -6, -24, 14, -18, -49, -12, 24, -22, -67, -7, -27, -39, -15, -45, -27, -40, -10, -3, 
    22, -7, -49, -45, -36, -72, -32, -60, -112, -89, -82, -122, -101, -127, -124, -127, -127, -127, -127, -127, 
    -127, -127, -127, -127, -127, -89, -39, -25, -28, 31, 34, 30, 9, 35, -23, 31, 36, 51, 83, 94, 
    42, 51, 67, 106, 81, 124, 101, 54, 21, -26, 12, 43, 5, -32, -32, 27, 25, 49, 32, 21, 
    12, -39, -9, -45, -98, -127, -119, -101, -54, -58, -70, -86, -86, -50, -41, -60, -92, -91, -113, -85, 
    -51, -37, -25, -13, 11, 39, 70, 40, 64, 44, 94, 91, 68, 21, 39, 32, -26, -41, 2, -9, 
    -60, -90, -122, -127, -123, -62, -48, -31, -12, -62, -91, -127, -127, -127, -127, -127, -114, -121, -119, -121, 
    -103, -77, -127, -120, -60, -23, 16, 55, -3, 5, 63, 76, 20, 74, 89, 68, 52, 97, 48, -12, 
    28, 80, 85, 39, 17, 46, 76, 40, 30, 72, 36, 19, -32, 2, -22, -72, -39, -87, -94, -126, 
    -127, -127, -127, -127, -82, -59, -101, -104, -127, -90, -46, -91, -98, -83, -75, -51, -96, -73, -56, -30, 
    -27, -5, 41, 25, 29, -27, -9, -17, -26, 22, 62, 54, 101, 127, 127, 127, 127, 127, 127, 127, 
    127, 127, 127, 127, 127, 127, 127, 127, 127, 115, 122, 127, 93, 71, 75, 72, 108, 123, 127, 127, 
    127, 127, 80, 122, 78, 101, 71, 68, 66, 96, 122, 127, 127, 127, 127, 127, 127, 127, 127, 127, 
    127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 109, 127, 127, 90, 38, 
    47, 77, 56, 25, -13, 37, 75, 38, 30, -5, 43, 52, 104, 127, 74, 96, 31, -3, -9, 30, 
    -20, 25, 9, 49, 101, 127, 83, 31, 15, 8, 32, 61, 17, -41, -31, -7, 9, 10, -2, 4, 
    37, 2, -40, -94, -110, -116, -88, -59, -44, -77, -89, -114, -87, -127, -127, -127, -90, -88, -37, 22, 
    -17, 23, 64, 69, 8, 3, 43, -17, -62, -16, -7, -37, -57, -41, -90, -95, -127, -109, -127, -117, 
    -126, -64, -43, -15, -3, 53, 35, 25, -1, -8, -25, -21, -35, -62, -12, -15, 34, 61, 73, 87, 
    87, 74, 100, 106, 66, 13, -13, -38, -34, -39, -85, -95, -58, -92, -34, 0, 0, 51, 37, 58, 
    105, 127, 80, 103, 120, 94, 74, 13, -33, -13, -40, -48, -65, -72, -38, 15, 50, 77, 107, 127, 
    65, 26, 59, 110, 127, 127, 127, 127, 84, 55, 69, 62, 57, 18, -20, -7, -21, -6, -25, -46, 
    -46, -59, -109, -127, -127, -99, -123, -127, -127, -127, -99, -66, -7, -25, -29, -37, -13, -53, -1, -23, 
    -45, -14, -6, 23, 55, 72, 22, -18, 17, 38, -21, 36, 0, 6, -49, -6, 5, -15, -64, -99, 
    -69, -98, -127, -127, -89, -50, 3, 24, 21, 17, 8, -6, 45, 97, 97, 52, 11, -16, -60, -113, 
    -93, -30, -56, -9, -47, -36, -5, -50, -49, -57, -11, -30, 0, -22, -5, -32, -56, -82, -18, -41, 
    4, 62, 37, 15, -13, -31, 17, 29, -11, -7, 13, 6, -19, -31, 0, -53, -40, -89, -67, -110, 
    -47, -84, -56, -77, -35, -49, -59, -14, 2, 21, 5, 10, -7, -17, -29, 28, 1, 58, 100, 96, 
    52, 65, 98, 127, 90, 75, 61, 94, 113, 64, 66, 61, 106, 122, 127, 127, 127, 79, 32, 30, 
    80, 112, 127, 127, 127, 127, 72, 27, 52, 105, 53, 83, 47, -4, -33, -80, -22, -9, -14, 39, 
    57, 7, -27, 17, 19, 45, 35, 24, 77, 40, 4, -46, 12, 30, 18, 64, 79, 24, -33, -6, 
    7, -36, -42, -51, -90, -43, -95, -104, -95, -39, -77, -61, -95, -89, -36, -3, -26, -52, -5, 17, 
    11, -27, -74, -19, -54, -75, -114, -83, -85, -58, -90, -65, -35, -26, -80, -119, -127, -127, -127, -127, 
    -127, -84, -61, -100, -127, -127, -127, -127, -127, -127, -95, -110, -70, -67, -12, 11, 41, 26, -5, -2, 
    -28, -38, 19, 76, 102, 67, 83, 59, 104, 112, 108, 57, 96, 112, 127, 127, 127, 87, 39, 77, 
    38, 83, 97, 86, 104, 96, 45, 36, -12, 5, 31, 37, -1, -43, -1, -6, 34, 29, 80, 63, 
    115, 127, 127, 127, 127, 127, 111, 95, 49, 3, 34, 56, 40, 19, -34, -5, 29, 75, 71, 100, 
    41, 46, 92, 53, 90, 48, 42, 13, 0, 20, -7, -13, -40, -24, 13, -38, -85, -66, -29, -37, 
    -47, 3, 15, 33, 88, 89, 122, 69, 61, 27, 21, -19, -13, -33, 18, 29, 44, 2, 10, 58, 
    9, 3, -19, -3, 46, -5, 6, -38, -67, -60, -53, -40, -44, -16, 3, -14, 0, 44, 84, 100, 
    41, 67, 28, 62, 89, 118, 127, 127, 127, 127, 127, 96, 66, 78, 97, 126, 89, 45, 40, 83, 
    127, 93, 96, 53, 22, 18, -23, -39, -47, -70, -86, -34, -28, 12, 69, 50, 91, 90, 127, 127, 
    127, 127, 127, 127, 127, 127, 114, 127, 127, 127, 127, 76, 42, 20, 57, 80, 102, 64, 24, 2, 
    -41, -94, -111, -100, -60, -50, -64, -113, -95, -109, -115, -90,       };

#endif /* BROWNNOISE8192_H_ */
