#ifndef UFM02_H
#define UFM02_H

#include "lib/ufm02/ScioSense_Ufm02.h"
#include "lib/io/ScioSense_IOInterface_Arduino_SPI.h"
#include "lib/io/ScioSense_IOInterface_Arduino_I2C.h"
#include "lib/io/ScioSense_IOInterface_Arduino_Serial.h"

class UFM02 : public ScioSense_Ufm02
{
    public:
        UFM02();
        virtual ~UFM02();

    public:
        void        begin                       (SPIClass* spi, uint8_t chipSelect, const SPISettings settings);    // Connnects to UFM02 using Arduino's SPI class
        void        begin                       (Stream* serial);                                                   // Connnects to UFM02 using Arduino's Serial class
        void        begin                       (TwoWire* wire, const uint8_t address);                             // Connnects to UFM02 using Arduino's I2C class
        bool        isConnected                 ();                                                                 // Checks if a communication to the device was established; returns true, if so.
        bool        init                        ();                                                                 // Resets the device and configuration
        
    public:
        Result      reset                       ();                                                                 // Software reset the device
        Result      update                      ();                                                                 // Reads the Frontend Data Buffer and Status
        
    public:
        uint32_t    getVolumeIntegerPartRaw     ();                                                                 // Parse the content of the VOLUME_INT output
        uint32_t    getVolumeFractionalPartRaw  ();                                                                 // Parse the content of the VOLUME_FRAC output
        uint32_t    getInstantFlowRaw           ();                                                                 // Parse the content of the FLOW_LPH output
        uint32_t    getInstantFilteredFlowRaw   ();                                                                 // Parse the content of the FILTERED_FLOW_LPH output
        uint32_t    getTemperatureRaw           ();                                                                 // Parse the content of the TEMPERATURE output
        uint32_t    getErrorFlags               ();                                                                 // Parse the content of the ERROR_FLAGS output
        
    public:
        float       getVolumeM3                 ();                                                                 // Parse the total volume of fluid measured in cubic meters
        float       getInstantFlowLPerHr        ();                                                                 // Parse instant flow in litres per hour
        float       getInstantFilteredFlowLPerHr();                                                                 // Parse filtered instant flow in litres per hour
        float       getTemperatureDegC          ();                                                                 // Parse temperature measured in degrees Celsius
        
    public:
        uint32_t    getMaterialId               ();                                                                 // Returns the Material ID
        uint32_t    getThread                   ();                                                                 // Returns the thread identifier
        uint32_t    getFamilyNumber             ();                                                                 // Returns the family number
        uint32_t    getApplicationFamily        ();                                                                 // Returns the application family (water, gas, or custom Solex)
    
    public:
        Result      setSerialPassiveMode        ();                                                                 // Sets the device into passive mode, only giving data when requested
        Result      setSerialActiveMode         ();                                                                 // Sets the device into active mode, printing data every time new values are ready
    
    public:
        uint8_t     hasErrors                   ();                                                                 // Returns how many errors were detected
        bool        hasErrorFlag                (uint8_t errorFlag);                                                // Checks if the provided flag has been activated
        const char* errorToString               (uint8_t errorFlag);                                                // Returns a string that describes the provided error
    
    protected:
        ScioSense_Arduino_Spi_Config            spiConfig;
        ScioSense_Arduino_I2c_Config            i2cConfig;
        ScioSense_Arduino_Serial_Config         serialConfig;
};

#endif //UFM02_H
