#include <Arduino.h>
#include <ScioSense_UFM02.h>

#define I2C_ADDRESS                 0x10

#define UPDATE_PERIOD_MS            1000
#define AMOUNT_DECIMALS_VOLUME_M3   6

UFM02 ufm02;

uint8_t errorsToCheck[] = {UFM02_ERROR_FLAG_MEAS_NOT_OK, UFM02_ERROR_FLAG_BUBBLES};
uint8_t amountErrorsToCheck = (uint8_t)( sizeof(errorsToCheck) / sizeof(errorsToCheck[0]) );
unsigned long lastUpdate;

void setup()
{
    Serial.begin(9600);

    Serial.println("Starting UFM02 02_Basic_I2C demo on Arduino...");

    Wire.begin();

    ufm02.begin(&Wire, I2C_ADDRESS);
    
    if( ufm02.init() )
    {
        Serial.println("UFM02 initialized properly");
    }
    else
    {
        Serial.println("UFM02 type not recognized");
    }

    Serial.print("Product ID read: ");
    Serial.println(ufm02.getMaterialId());
    
    lastUpdate = millis();
}

void loop()
{
    unsigned long currentTimeMs = millis();
    if( (currentTimeMs - lastUpdate) > UPDATE_PERIOD_MS )
    {
        ufm02.update();
        
        // Check for errors
        uint8_t errorDetected = 0;
        for( uint8_t errorIdx = 0; errorIdx < amountErrorsToCheck; errorIdx++ )
        {
            if( ufm02.hasErrorFlag(errorsToCheck[errorIdx]) )
            {
                Serial.print("Error detected: ");
                Serial.println( ufm02.errorToString(errorsToCheck[errorIdx]) );
                errorDetected = 1;
            }
        }
        
        if( !errorDetected )
        {
            // Print the accumulated flow in cubic meters
            Serial.print("AccumulatedVolume[m3]:");
            Serial.print(ufm02.getVolumeM3(), AMOUNT_DECIMALS_VOLUME_M3);
            Serial.print("\t");
    
            // Print the current flow rate in litres per hour
            Serial.print("FlowRate[l_per_hr]:");
            Serial.print(ufm02.getInstantFlowLPerHr());
            Serial.print("\t");
            
            // Print the temperature in degrees celsius
            Serial.print("Temperature[degC]:");
            Serial.println(ufm02.getTemperatureDegC());
        }
        
        lastUpdate = currentTimeMs;
    }
}