# ScioSense UFM02 Arduino Library

Arduino library for the UFM02 ultrasonic flow sensing module through SPI, I2C, and UART from ScioSense.

<img src="images/UFM-02.png" height="400">

The UFM-02 is a complete unit including the sensor electronics, spool piece, connectors with standard ½” thread, and a cable connector supporting single-wire and UART interfaces.

## Links
* [Further information about the UFM02](https://www.sciosense.com/ufm-02-ultrasonic-flow-sensing-module/)
* [Datasheet](https://www.sciosense.com/wp-content/uploads/2025/11/UFM-02-Datasheet.pdf)
 
## Prerequisites
It is assumed that
 - The Arduino IDE has been installed.
   If not, refer to "Install the Arduino Desktop IDE" on the
   [Arduino site](https://www.arduino.cc/en/Guide/HomePage).
- The library directory is at its default location. Normally this is `C:\Users\[your_username]\Documents\Arduino\libraries`.

## Installation

### Installation via Arduino Library Manager (coming soon)
- In the Arduino IDE, navigate to the Arduino Library Manager on the left side (or, alternatively, select Sketch > 
Include Library > Manage Libraries...)
- Search for `ScioSense_UFM02`
- Select the library from the search results and press `Install`

### Manual installation
- Download the code from this repository via "Download ZIP".
- In Arduino IDE, select Sketch > Include Library > Add .ZIP library... and browse to the just downloaded ZIP file.
- When the IDE is ready this README.md should be located at `C:\Users\[your_username]\Documents\Arduino\libraries\ScioSense_UFM02\README.md`.

## Wiring

### General
Please make sure that you use the correct supply voltage: The UFM-02 runs at VDD = 5V, but the IO lines operate at 3.3V.

### Example with ESP32 (SPI)
This example shows how to wire an ESP32 with a UFM-02 to communicate through SPI.

|  UFM-02   | ESP32 |
|:---------:|:-----:|
|  IO1      |  -    |
|  IO2      |  -    |
|  VCC      |  5V   |
|  GND      |  GND  |
|  3V3      |  -    |
|  CS       |  5    |
|  MO       |  23   |
|  SCK      |  18   |
|  MI       |  19   |
|  INT      |  2    |

<img src="images/UFM-02_ESP32_SPI.png" width="1000">

### Example with ESP32 (I2C)
This example shows how to wire an ESP32 with a UFM-02 to communicate through I2C. Currently, the connections are mediated through a board that transforms the SPI output into I2C

|  UFM-02 translation board | ESP32 |
|:-------------------------:|:-----:|
|  SDA                      |  21   |
|  SCL                      |  22   |
|  RX                       |  -    |
|  TX                       |  -    |
|  AOUT                     |  -    |
|  5V0                      |  5V   |
|  GND                      |  GND  |

<img src="images/UFM-02_ESP32_I2C.png" width="1000">

### Example with ESP32 (UART)
This example shows how to wire an ESP32 with a UFM-02 to communicate through I2C. Currently, the connections are mediated through a board that transforms the SPI output into I2C

|  UFM-02 translation board | ESP32 |
|:-------------------------:|:-----:|
|  SDA                      |  -    |
|  SCL                      |  -    |
|  RX                       |  17   |
|  TX                       |  16   |
|  AOUT                     |  -    |
|  5V0                      |  5V   |
|  GND                      |  GND  |

<img src="images/UFM-02_ESP32_UART.png" width="1000">

## Build an example
To build an example sketch
 - (Re)start Arduino.
 - Open File > Examples > Examples from Custom Libraries > ScioSense_UFM02 > 01_Basi_SPI (or any other of the provided 
examples you wish to run)
 - Make sure Tools > Board lists the correct board.
 - Select Sketch > Verify/Compile.

## Contributing
Contributions in the form of issue opening or creating pull requests are very welcome!

### ScioSense is a Joint Venture of ams AG