#include <Arduino.h>
#include <SPI.h>
#include <ScioSense_AS60XX.h>

#define PIN_INTN                    2     // define pin for interrupt
#define PIN_CS                      5     // define pin for chip select

#define AMOUNT_DECIMALS_VOLUME_M3   6

static AS6031f1 as6031f1;

As6031F1_ErrorFlag errorsToCheck[] = {FW_ERR_MEAS_NOT_OK, FW_ERR_BUBBLE};
uint8_t amountErrorsToCheck = (uint8_t)( sizeof(errorsToCheck) / sizeof(errorsToCheck[0]) );

void setup()
{
    Serial.begin(9600);

    Serial.println("Starting AS60xx 03_AS6031F1_Example demo on Arduino...");

    delay(AS60XX_BOOTUP_COMM_RELEASE_TIME_MAX_MS);

    SPI.begin();
    as6031f1.begin(&SPI, PIN_CS, SPISettings(14000000, MSBFIRST, SPI_MODE1));

    if( as6031f1.init() )
    {
        Serial.println("AS6031F1 initialized properly");
    }
    else
    {
        Serial.println("AS6031F1 initialization failed");
    }
    
    delay(1000);
}

void loop()
{
    if( !digitalRead(PIN_INTN) )
    {
        as6031f1.updateF1();
        
        // Print the accumulated flow in cubic meters
        Serial.print("AccumulatedVolume[m3]:");
        Serial.print(as6031f1.getF1VolumeM3(), AMOUNT_DECIMALS_VOLUME_M3);
        Serial.print("\t");

        // Print the current flow rate in litres per hour
        Serial.print("FlowRate[l_per_hr]:");
        Serial.print(as6031f1.getF1InstantFlowLPerHr());
        Serial.print("\t");
        
        // Print the temperature in degrees celsius
        Serial.print("Temperature[degC]:");
        Serial.print(as6031f1.getF1TemperatureDegC());
        Serial.print("\t");

        for( uint8_t errorIdx = 0; errorIdx < amountErrorsToCheck; errorIdx++ )
        {
            if( as6031f1.hasF1ErrorFlag(errorsToCheck[errorIdx]) )
            {
                Serial.print("\tError detected: ");
                Serial.print( as6031f1.errorF1ToString(errorsToCheck[errorIdx]) );
            }
        }

        Serial.println("");
    }
}